
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  144 ( 2319),  selected  144 , name 2h3k_A
# Molecule2: number of CA atoms  145 ( 1093),  selected  145 , name T0514.pdb
# PARAMETERS: 2h3k_A.T0514.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      S       1           -
LGA    D     2_A      S       2           -
LGA    E     3_A      L       3           -
LGA    S     4_A      T       4           -
LGA    L     5_A      E       5           -
LGA    K     6_A      T       6           -
LGA    D     7_A      Y       7           -
LGA    A     8_A      G       8           -
LGA    I     9_A      L       9           -
LGA    K    10_A      W      10           -
LGA    D    11_A      S      11           -
LGA    P    12_A      I      12           -
LGA    A    13_A      N      13           -
LGA    L    14_A      C      14           -
LGA    E    15_A      G      15           -
LGA    N    16_A      I      16           -
LGA    K    17_A      -       -           -
LGA    E    18_A      -       -           -
LGA    H    19_A      -       -           -
LGA    D    20_A      Q      17           #
LGA    I    21_A      E      18           #
LGA    -       -      G      19           -
LGA    -       -      K      20           -
LGA    G    22_A      K      21           #
LGA    P    23_A      V      22          2.733
LGA    R    24_A      C      23          4.397
LGA    E    25_A      F      24          2.197
LGA    -       -      M      25           -
LGA    Q    26_A      H      26          2.017
LGA    V    27_A      R      27          1.925
LGA    N    28_A      Q      28          2.654
LGA    F    29_A      E      29          3.999
LGA    Q    30_A      V      30           #
LGA    L    31_A      -       -           -
LGA    L    32_A      -       -           -
LGA    D    33_A      -       -           -
LGA    K    34_A      -       -           -
LGA    N    35_A      -       -           -
LGA    N    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    T    38_A      -       -           -
LGA    Q    39_A      N      31          3.597
LGA    Y    40_A      D      32          2.900
LGA    Y    41_A      Q      33          3.815
LGA    H    42_A      N      34           -
LGA    -       -      R      35           -
LGA    F    43_A      V      36          4.805
LGA    F    44_A      V      37           #
LGA    S    45_A      -       -           -
LGA    I    46_A      V      38          3.745
LGA    K    47_A      -       -           -
LGA    D    48_A      -       -           -
LGA    P    49_A      A      39          3.278
LGA    A    50_A      M      40          1.300
LGA    D    51_A      S      41          0.733
LGA    V    52_A      V      42          0.954
LGA    Y    53_A      V      43          1.981
LGA    Y    54_A      L      44          1.686
LGA    T    55_A      N      45          1.109
LGA    K    56_A      A      46          2.627
LGA    -       -      D      47           -
LGA    K    57_A      G      48          2.300
LGA    K    58_A      V      49          2.024
LGA    A    59_A      V      50          1.500
LGA    E    60_A      S      51          1.600
LGA    V    61_A      G      52          3.938
LGA    E    62_A      N      53          1.594
LGA    L    63_A      L      54          1.665
LGA    D    64_A      T      55          2.245
LGA    I    65_A      V      56          3.293
LGA    N    66_A      P      57          4.811
LGA    T    67_A      F      58          1.316
LGA    A    68_A      -       -           -
LGA    S    69_A      G      59          4.907
LGA    T    70_A      I      60          2.445
LGA    W    71_A      L      61          2.828
LGA    K    72_A      V      62          4.408
LGA    -       -      S      63           -
LGA    -       -      K      64           -
LGA    K    73_A      P      65          2.861
LGA    F    74_A      V      66          1.468
LGA    E    75_A      R      67          1.166
LGA    V    76_A      L      68          0.872
LGA    Y    77_A      Q      69          1.381
LGA    E    78_A      V      70          1.586
LGA    N    79_A      D      71           #
LGA    -       -      E      72           -
LGA    N    80_A      G      73          2.859
LGA    Q    81_A      K      74          3.349
LGA    -       -      A      75           -
LGA    K    82_A      V      76          0.864
LGA    L    83_A      I      77          1.247
LGA    P    84_A      E      78          2.614
LGA    V    85_A      T      79          2.732
LGA    R    86_A      G      80          4.536
LGA    L    87_A      I      81          4.733
LGA    V    88_A      -       -           -
LGA    S    89_A      R      82          4.305
LGA    Y    90_A      T      83          1.420
LGA    S    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    V    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    E    95_A      -       -           -
LGA    D    96_A      C      84          3.964
LGA    H    97_A      V      85          3.079
LGA    -       -      P      86           -
LGA    -       -      A      87           -
LGA    -       -      G      88           -
LGA    A    98_A      C      89          3.024
LGA    Y    99_A      I      90          1.691
LGA    I   100_A      V      91          1.279
LGA    R   101_A      P      92          2.582
LGA    F   102_A      I      93          2.269
LGA    -       -      V      94           -
LGA    P   103_A      F      95          1.642
LGA    V   104_A      D      96           #
LGA    -       -      K      97           -
LGA    -       -      N      98           -
LGA    -       -      Y      99           -
LGA    S   105_A      V     100          0.544
LGA    D   106_A      A     101          2.242
LGA    -       -      A     102           -
LGA    -       -      L     103           -
LGA    G   107_A      R     104          2.470
LGA    T   108_A      A     105           #
LGA    Q   109_A      G     106          4.954
LGA    E   110_A      K     107          3.805
LGA    -       -      H     108           -
LGA    L   111_A      L     109          1.772
LGA    K   112_A      K     110          2.055
LGA    I   113_A      L     111          1.332
LGA    V   114_A      A     112          1.684
LGA    S   115_A      M     113          1.470
LGA    S   116_A      T     114          1.922
LGA    T   117_A      I     115          1.002
LGA    Q   118_A      A     116          3.047
LGA    I   119_A      A     117          3.848
LGA    D   120_A      P     118          4.910
LGA    D   121_A      -       -           -
LGA    G   122_A      -       -           -
LGA    E   123_A      G     119           #
LGA    E   124_A      E     120          5.031
LGA    T   125_A      P     121          4.019
LGA    N   126_A      P     122          1.503
LGA    Y   127_A      L     123          2.704
LGA    D   128_A      N     124          4.218
LGA    Y   129_A      -       -           -
LGA    T   130_A      D     125          3.242
LGA    K   131_A      L     126           #
LGA    L   132_A      F     127          1.752
LGA    V   133_A      V     128          3.751
LGA    F   134_A      Q     129          2.547
LGA    A   135_A      L     130          5.166
LGA    -       -      N     131           -
LGA    K   136_A      G     132          2.936
LGA    P   137_A      F     133          0.837
LGA    -       -      S     134           -
LGA    -       -      N     135           -
LGA    I   138_A      A     136           #
LGA    Y   139_A      L     137          2.545
LGA    -       -      N     138           -
LGA    -       -      R     139           -
LGA    N   140_A      L     140           #
LGA    D   141_A      I     141          2.237
LGA    P   142_A      A     142           #
LGA    S   143_A      L     143           #
LGA    L   144_A      Q     144          2.226
LGA    -       -      K     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  144  145    5.0     89    2.88     6.74     35.707     2.983

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.504213 * X  +   0.551775 * Y  +  -0.664315 * Z  + -99.998886
  Y_new =   0.826384 * X  +   0.531620 * Y  +  -0.185663 * Z  +  12.564561
  Z_new =   0.250718 * X  +  -0.642592 * Y  +  -0.724027 * Z  + -32.761700 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.415713    0.725880  [ DEG:  -138.4101     41.5899 ]
  Theta =  -0.253422   -2.888170  [ DEG:   -14.5200   -165.4800 ]
  Phi   =   2.118641   -1.022952  [ DEG:   121.3892    -58.6108 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2h3k_A                                        
REMARK     2: T0514.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2h3k_A.T0514.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  144  145   5.0   89   2.88    6.74  35.707
REMARK  ---------------------------------------------------------- 
MOLECULE 2h3k_A
HEADER    PROTEIN BINDING                         22-MAY-06   2H3K              
TITLE     SOLUTION STRUCTURE OF THE FIRST NEAT DOMAIN OF ISDH                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HAPTOGLOBIN-BINDING SURFACE ANCHORED PROTEIN;              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: FIRST NEAT DOMAIN, ISDH-N1;                                
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   3 STRAIN: MSSA476;                                                     
SOURCE   4 GENE: SA1552;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    NEAT DOMAIN, ISDH, HARA                                               
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    R.M.PILPA,E.A.FADEEV,V.A.VILLAREAL,M.A.WONG,M.PHILLIPS,               
AUTHOR   2 R.T.CLUBB                                                            
REVDAT   1   22-AUG-06 2H3K    0                                                
JRNL        AUTH   R.M.PILPA,E.A.FADEEV,V.A.VILLAREAL,M.L.WONG,                 
JRNL        AUTH 2 M.PHILLIPS,R.T.CLUBB                                         
JRNL        TITL   SOLUTION STRUCTURE OF THE NEAT (NEAR TRANSPORTER)            
JRNL        TITL 2 DOMAIN FROM ISDH/HARA: THE HUMAN HEMOGLOBIN                  
JRNL        TITL 3 RECEPTOR IN STAPHYLOCOCCUS AUREUS.                           
JRNL        REF    J.MOL.BIOL.                   V. 360   435 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2H3K A    1   144  UNP    Q6G8J7   Q6G8J7_STAAS    86    229             
SEQRES   1 A  144  ALA ASP GLU SER LEU LYS ASP ALA ILE LYS ASP PRO ALA          
SEQRES   2 A  144  LEU GLU ASN LYS GLU HIS ASP ILE GLY PRO ARG GLU GLN          
SEQRES   3 A  144  VAL ASN PHE GLN LEU LEU ASP LYS ASN ASN GLU THR GLN          
SEQRES   4 A  144  TYR TYR HIS PHE PHE SER ILE LYS ASP PRO ALA ASP VAL          
SEQRES   5 A  144  TYR TYR THR LYS LYS LYS ALA GLU VAL GLU LEU ASP ILE          
SEQRES   6 A  144  ASN THR ALA SER THR TRP LYS LYS PHE GLU VAL TYR GLU          
SEQRES   7 A  144  ASN ASN GLN LYS LEU PRO VAL ARG LEU VAL SER TYR SER          
SEQRES   8 A  144  PRO VAL PRO GLU ASP HIS ALA TYR ILE ARG PHE PRO VAL          
SEQRES   9 A  144  SER ASP GLY THR GLN GLU LEU LYS ILE VAL SER SER THR          
SEQRES  10 A  144  GLN ILE ASP ASP GLY GLU GLU THR ASN TYR ASP TYR THR          
SEQRES  11 A  144  LYS LEU VAL PHE ALA LYS PRO ILE TYR ASN ASP PRO SER          
SEQRES  12 A  144  LEU                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1    -113.170   9.552 -43.191  1.00  0.00           N  
ATOM      2  CA  ALA A   1    -113.501   8.102 -43.091  1.00  0.00           C  
ATOM      3  C   ALA A   1    -112.445   7.374 -42.258  1.00  0.00           C  
ATOM      4  O   ALA A   1    -112.075   6.254 -42.549  1.00  0.00           O  
ATOM      5  CB  ALA A   1    -113.491   7.594 -44.533  1.00  0.00           C  
ATOM      6  HA  ALA A   1    -114.481   7.969 -42.661  1.00  0.00           H  
ATOM      7  HB1 ALA A   1    -114.492   7.630 -44.935  1.00  0.00           H  
ATOM      8  HB2 ALA A   1    -113.132   6.575 -44.552  1.00  0.00           H  
ATOM      9  HB3 ALA A   1    -112.840   8.216 -45.129  1.00  0.00           H  
ATOM     10  H1  ALA A   1    -112.138   9.676 -43.144  1.00  0.00           H  
ATOM     11  H2  ALA A   1    -113.617  10.066 -42.404  1.00  0.00           H  
ATOM     12  H3  ALA A   1    -113.520   9.928 -44.094  1.00  0.00           H  
ATOM     13  N   ASP A   2    -111.955   8.000 -41.222  1.00  0.00           N  
ATOM     14  CA  ASP A   2    -110.922   7.342 -40.372  1.00  0.00           C  
ATOM     15  C   ASP A   2    -111.531   6.151 -39.627  1.00  0.00           C  
ATOM     16  O   ASP A   2    -112.719   5.909 -39.688  1.00  0.00           O  
ATOM     17  CB  ASP A   2    -110.476   8.421 -39.385  1.00  0.00           C  
ATOM     18  CG  ASP A   2    -109.635   9.467 -40.117  1.00  0.00           C  
ATOM     19  OD1 ASP A   2    -109.612   9.434 -41.336  1.00  0.00           O  
ATOM     20  OD2 ASP A   2    -109.027  10.286 -39.446  1.00  0.00           O  
ATOM     21  H   ASP A   2    -112.267   8.904 -41.005  1.00  0.00           H  
ATOM     22  HA  ASP A   2    -110.085   7.024 -40.974  1.00  0.00           H  
ATOM     23  HB2 ASP A   2    -111.345   8.894 -38.952  1.00  0.00           H  
ATOM     24  HB3 ASP A   2    -109.884   7.970 -38.602  1.00  0.00           H  
ATOM     25  N   GLU A   3    -110.723   5.406 -38.921  1.00  0.00           N  
ATOM     26  CA  GLU A   3    -111.255   4.231 -38.172  1.00  0.00           C  
ATOM     27  C   GLU A   3    -110.667   4.197 -36.758  1.00  0.00           C  
ATOM     28  O   GLU A   3    -110.364   5.220 -36.177  1.00  0.00           O  
ATOM     29  CB  GLU A   3    -110.801   3.011 -38.975  1.00  0.00           C  
ATOM     30  CG  GLU A   3    -109.276   2.898 -38.913  1.00  0.00           C  
ATOM     31  CD  GLU A   3    -108.737   2.503 -40.288  1.00  0.00           C  
ATOM     32  OE1 GLU A   3    -108.591   3.383 -41.121  1.00  0.00           O  
ATOM     33  OE2 GLU A   3    -108.479   1.326 -40.486  1.00  0.00           O  
ATOM     34  H   GLU A   3    -109.767   5.617 -38.884  1.00  0.00           H  
ATOM     35  HA  GLU A   3    -112.333   4.266 -38.133  1.00  0.00           H  
ATOM     36  HB2 GLU A   3    -111.246   2.120 -38.560  1.00  0.00           H  
ATOM     37  HB3 GLU A   3    -111.108   3.123 -40.005  1.00  0.00           H  
ATOM     38  HG2 GLU A   3    -108.857   3.850 -38.620  1.00  0.00           H  
ATOM     39  HG3 GLU A   3    -109.000   2.145 -38.190  1.00  0.00           H  
ATOM     40  N   SER A   4    -110.505   3.028 -36.198  1.00  0.00           N  
ATOM     41  CA  SER A   4    -109.939   2.934 -34.821  1.00  0.00           C  
ATOM     42  C   SER A   4    -108.451   2.572 -34.880  1.00  0.00           C  
ATOM     43  O   SER A   4    -108.050   1.659 -35.576  1.00  0.00           O  
ATOM     44  CB  SER A   4    -110.734   1.821 -34.142  1.00  0.00           C  
ATOM     45  OG  SER A   4    -112.122   2.116 -34.227  1.00  0.00           O  
ATOM     46  H   SER A   4    -110.757   2.214 -36.680  1.00  0.00           H  
ATOM     47  HA  SER A   4    -110.080   3.863 -34.291  1.00  0.00           H  
ATOM     48  HB2 SER A   4    -110.541   0.884 -34.636  1.00  0.00           H  
ATOM     49  HB3 SER A   4    -110.434   1.747 -33.104  1.00  0.00           H  
ATOM     50  HG  SER A   4    -112.445   1.784 -35.067  1.00  0.00           H  
ATOM     51  N   LEU A   5    -107.630   3.279 -34.153  1.00  0.00           N  
ATOM     52  CA  LEU A   5    -106.171   2.976 -34.166  1.00  0.00           C  
ATOM     53  C   LEU A   5    -105.933   1.513 -33.777  1.00  0.00           C  
ATOM     54  O   LEU A   5    -104.960   0.906 -34.177  1.00  0.00           O  
ATOM     55  CB  LEU A   5    -105.562   3.914 -33.124  1.00  0.00           C  
ATOM     56  CG  LEU A   5    -104.257   4.500 -33.665  1.00  0.00           C  
ATOM     57  CD1 LEU A   5    -103.857   5.717 -32.828  1.00  0.00           C  
ATOM     58  CD2 LEU A   5    -103.153   3.443 -33.585  1.00  0.00           C  
ATOM     59  H   LEU A   5    -107.974   4.011 -33.597  1.00  0.00           H  
ATOM     60  HA  LEU A   5    -105.751   3.181 -35.138  1.00  0.00           H  
ATOM     61  HB2 LEU A   5    -106.256   4.714 -32.912  1.00  0.00           H  
ATOM     62  HB3 LEU A   5    -105.358   3.364 -32.218  1.00  0.00           H  
ATOM     63  HG  LEU A   5    -104.397   4.800 -34.694  1.00  0.00           H  
ATOM     64 HD11 LEU A   5    -104.620   6.477 -32.910  1.00  0.00           H  
ATOM     65 HD12 LEU A   5    -102.918   6.110 -33.192  1.00  0.00           H  
ATOM     66 HD13 LEU A   5    -103.748   5.425 -31.794  1.00  0.00           H  
ATOM     67 HD21 LEU A   5    -102.886   3.126 -34.582  1.00  0.00           H  
ATOM     68 HD22 LEU A   5    -103.509   2.594 -33.020  1.00  0.00           H  
ATOM     69 HD23 LEU A   5    -102.287   3.863 -33.095  1.00  0.00           H  
ATOM     70  N   LYS A   6    -106.814   0.947 -33.000  1.00  0.00           N  
ATOM     71  CA  LYS A   6    -106.641  -0.473 -32.585  1.00  0.00           C  
ATOM     72  C   LYS A   6    -106.992  -1.410 -33.742  1.00  0.00           C  
ATOM     73  O   LYS A   6    -106.396  -2.456 -33.911  1.00  0.00           O  
ATOM     74  CB  LYS A   6    -107.619  -0.667 -31.426  1.00  0.00           C  
ATOM     75  CG  LYS A   6    -106.982  -1.568 -30.370  1.00  0.00           C  
ATOM     76  CD  LYS A   6    -107.675  -2.932 -30.374  1.00  0.00           C  
ATOM     77  CE  LYS A   6    -106.623  -4.038 -30.470  1.00  0.00           C  
ATOM     78  NZ  LYS A   6    -107.349  -5.292 -30.122  1.00  0.00           N  
ATOM     79  H   LYS A   6    -107.592   1.455 -32.689  1.00  0.00           H  
ATOM     80  HA  LYS A   6    -105.632  -0.649 -32.247  1.00  0.00           H  
ATOM     81  HB2 LYS A   6    -107.854   0.293 -30.989  1.00  0.00           H  
ATOM     82  HB3 LYS A   6    -108.524  -1.128 -31.793  1.00  0.00           H  
ATOM     83  HG2 LYS A   6    -105.933  -1.695 -30.594  1.00  0.00           H  
ATOM     84  HG3 LYS A   6    -107.091  -1.114 -29.397  1.00  0.00           H  
ATOM     85  HD2 LYS A   6    -108.242  -3.051 -29.462  1.00  0.00           H  
ATOM     86  HD3 LYS A   6    -108.339  -2.995 -31.222  1.00  0.00           H  
ATOM     87  HE2 LYS A   6    -106.230  -4.096 -31.476  1.00  0.00           H  
ATOM     88  HE3 LYS A   6    -105.827  -3.864 -29.764  1.00  0.00           H  
ATOM     89  HZ1 LYS A   6    -107.504  -5.329 -29.095  1.00  0.00           H  
ATOM     90  HZ2 LYS A   6    -106.785  -6.113 -30.418  1.00  0.00           H  
ATOM     91  HZ3 LYS A   6    -108.267  -5.307 -30.608  1.00  0.00           H  
ATOM     92  N   ASP A   7    -107.957  -1.044 -34.539  1.00  0.00           N  
ATOM     93  CA  ASP A   7    -108.348  -1.916 -35.684  1.00  0.00           C  
ATOM     94  C   ASP A   7    -107.661  -1.453 -36.976  1.00  0.00           C  
ATOM     95  O   ASP A   7    -108.003  -1.889 -38.058  1.00  0.00           O  
ATOM     96  CB  ASP A   7    -109.865  -1.759 -35.796  1.00  0.00           C  
ATOM     97  CG  ASP A   7    -110.534  -2.382 -34.570  1.00  0.00           C  
ATOM     98  OD1 ASP A   7    -109.992  -3.342 -34.047  1.00  0.00           O  
ATOM     99  OD2 ASP A   7    -111.577  -1.888 -34.173  1.00  0.00           O  
ATOM    100  H   ASP A   7    -108.426  -0.198 -34.383  1.00  0.00           H  
ATOM    101  HA  ASP A   7    -108.101  -2.943 -35.474  1.00  0.00           H  
ATOM    102  HB2 ASP A   7    -110.116  -0.710 -35.851  1.00  0.00           H  
ATOM    103  HB3 ASP A   7    -110.214  -2.261 -36.688  1.00  0.00           H  
ATOM    104  N   ALA A   8    -106.696  -0.579 -36.876  1.00  0.00           N  
ATOM    105  CA  ALA A   8    -105.995  -0.099 -38.102  1.00  0.00           C  
ATOM    106  C   ALA A   8    -104.517  -0.501 -38.054  1.00  0.00           C  
ATOM    107  O   ALA A   8    -103.891  -0.725 -39.071  1.00  0.00           O  
ATOM    108  CB  ALA A   8    -106.141   1.422 -38.072  1.00  0.00           C  
ATOM    109  H   ALA A   8    -106.431  -0.237 -35.997  1.00  0.00           H  
ATOM    110  HA  ALA A   8    -106.466  -0.498 -38.986  1.00  0.00           H  
ATOM    111  HB1 ALA A   8    -107.143   1.681 -37.765  1.00  0.00           H  
ATOM    112  HB2 ALA A   8    -105.951   1.821 -39.058  1.00  0.00           H  
ATOM    113  HB3 ALA A   8    -105.430   1.838 -37.373  1.00  0.00           H  
ATOM    114  N   ILE A   9    -103.957  -0.592 -36.879  1.00  0.00           N  
ATOM    115  CA  ILE A   9    -102.521  -0.979 -36.764  1.00  0.00           C  
ATOM    116  C   ILE A   9    -102.312  -2.422 -37.238  1.00  0.00           C  
ATOM    117  O   ILE A   9    -101.197  -2.858 -37.448  1.00  0.00           O  
ATOM    118  CB  ILE A   9    -102.196  -0.852 -35.276  1.00  0.00           C  
ATOM    119  CG1 ILE A   9    -103.145  -1.741 -34.469  1.00  0.00           C  
ATOM    120  CG2 ILE A   9    -102.368   0.603 -34.839  1.00  0.00           C  
ATOM    121  CD1 ILE A   9    -102.546  -2.002 -33.086  1.00  0.00           C  
ATOM    122  H   ILE A   9    -104.480  -0.406 -36.072  1.00  0.00           H  
ATOM    123  HA  ILE A   9    -101.903  -0.304 -37.333  1.00  0.00           H  
ATOM    124  HB  ILE A   9    -101.175  -1.161 -35.103  1.00  0.00           H  
ATOM    125 HG12 ILE A   9    -104.098  -1.245 -34.361  1.00  0.00           H  
ATOM    126 HG13 ILE A   9    -103.283  -2.681 -34.982  1.00  0.00           H  
ATOM    127 HG21 ILE A   9    -101.413   1.105 -34.877  1.00  0.00           H  
ATOM    128 HG22 ILE A   9    -102.753   0.634 -33.831  1.00  0.00           H  
ATOM    129 HG23 ILE A   9    -103.061   1.099 -35.505  1.00  0.00           H  
ATOM    130 HD11 ILE A   9    -101.759  -1.288 -32.894  1.00  0.00           H  
ATOM    131 HD12 ILE A   9    -102.139  -3.003 -33.054  1.00  0.00           H  
ATOM    132 HD13 ILE A   9    -103.314  -1.902 -32.335  1.00  0.00           H  
ATOM    133  N   LYS A  10    -103.371  -3.169 -37.410  1.00  0.00           N  
ATOM    134  CA  LYS A  10    -103.219  -4.580 -37.870  1.00  0.00           C  
ATOM    135  C   LYS A  10    -103.088  -4.632 -39.395  1.00  0.00           C  
ATOM    136  O   LYS A  10    -103.959  -5.123 -40.085  1.00  0.00           O  
ATOM    137  CB  LYS A  10    -104.499  -5.283 -37.417  1.00  0.00           C  
ATOM    138  CG  LYS A  10    -104.222  -6.084 -36.143  1.00  0.00           C  
ATOM    139  CD  LYS A  10    -103.218  -7.199 -36.448  1.00  0.00           C  
ATOM    140  CE  LYS A  10    -103.834  -8.554 -36.087  1.00  0.00           C  
ATOM    141  NZ  LYS A  10    -102.846  -9.195 -35.174  1.00  0.00           N  
ATOM    142  H   LYS A  10    -104.264  -2.805 -37.237  1.00  0.00           H  
ATOM    143  HA  LYS A  10    -102.362  -5.039 -37.402  1.00  0.00           H  
ATOM    144  HB2 LYS A  10    -105.264  -4.545 -37.220  1.00  0.00           H  
ATOM    145  HB3 LYS A  10    -104.837  -5.951 -38.194  1.00  0.00           H  
ATOM    146  HG2 LYS A  10    -103.813  -5.428 -35.388  1.00  0.00           H  
ATOM    147  HG3 LYS A  10    -105.142  -6.518 -35.784  1.00  0.00           H  
ATOM    148  HD2 LYS A  10    -102.972  -7.183 -37.500  1.00  0.00           H  
ATOM    149  HD3 LYS A  10    -102.322  -7.047 -35.866  1.00  0.00           H  
ATOM    150  HE2 LYS A  10    -104.780  -8.414 -35.583  1.00  0.00           H  
ATOM    151  HE3 LYS A  10    -103.963  -9.157 -36.972  1.00  0.00           H  
ATOM    152  HZ1 LYS A  10    -101.882  -8.964 -35.490  1.00  0.00           H  
ATOM    153  HZ2 LYS A  10    -102.978 -10.227 -35.190  1.00  0.00           H  
ATOM    154  HZ3 LYS A  10    -102.987  -8.841 -34.208  1.00  0.00           H  
ATOM    155  N   ASP A  11    -102.007  -4.130 -39.925  1.00  0.00           N  
ATOM    156  CA  ASP A  11    -101.821  -4.154 -41.405  1.00  0.00           C  
ATOM    157  C   ASP A  11    -100.398  -4.607 -41.750  1.00  0.00           C  
ATOM    158  O   ASP A  11     -99.464  -4.320 -41.027  1.00  0.00           O  
ATOM    159  CB  ASP A  11    -102.048  -2.710 -41.856  1.00  0.00           C  
ATOM    160  CG  ASP A  11    -103.338  -2.627 -42.675  1.00  0.00           C  
ATOM    161  OD1 ASP A  11    -104.345  -3.133 -42.211  1.00  0.00           O  
ATOM    162  OD2 ASP A  11    -103.296  -2.057 -43.753  1.00  0.00           O  
ATOM    163  H   ASP A  11    -101.315  -3.739 -39.352  1.00  0.00           H  
ATOM    164  HA  ASP A  11    -102.548  -4.803 -41.865  1.00  0.00           H  
ATOM    165  HB2 ASP A  11    -102.128  -2.071 -40.990  1.00  0.00           H  
ATOM    166  HB3 ASP A  11    -101.216  -2.388 -42.466  1.00  0.00           H  
ATOM    167  N   PRO A  12    -100.281  -5.305 -42.848  1.00  0.00           N  
ATOM    168  CA  PRO A  12     -98.958  -5.806 -43.292  1.00  0.00           C  
ATOM    169  C   PRO A  12     -98.128  -4.667 -43.893  1.00  0.00           C  
ATOM    170  O   PRO A  12     -96.917  -4.655 -43.806  1.00  0.00           O  
ATOM    171  CB  PRO A  12     -99.305  -6.842 -44.357  1.00  0.00           C  
ATOM    172  CG  PRO A  12    -100.650  -6.435 -44.875  1.00  0.00           C  
ATOM    173  CD  PRO A  12    -101.355  -5.692 -43.769  1.00  0.00           C  
ATOM    174  HA  PRO A  12     -98.432  -6.275 -42.475  1.00  0.00           H  
ATOM    175  HB2 PRO A  12     -98.571  -6.821 -45.151  1.00  0.00           H  
ATOM    176  HB3 PRO A  12     -99.361  -7.826 -43.918  1.00  0.00           H  
ATOM    177  HG2 PRO A  12    -100.530  -5.793 -45.736  1.00  0.00           H  
ATOM    178  HG3 PRO A  12    -101.219  -7.311 -45.145  1.00  0.00           H  
ATOM    179  HD2 PRO A  12    -101.854  -4.817 -44.162  1.00  0.00           H  
ATOM    180  HD3 PRO A  12    -102.059  -6.338 -43.268  1.00  0.00           H  
ATOM    181  N   ALA A  13     -98.774  -3.713 -44.507  1.00  0.00           N  
ATOM    182  CA  ALA A  13     -98.024  -2.579 -45.119  1.00  0.00           C  
ATOM    183  C   ALA A  13     -97.592  -1.579 -44.042  1.00  0.00           C  
ATOM    184  O   ALA A  13     -96.599  -0.892 -44.184  1.00  0.00           O  
ATOM    185  CB  ALA A  13     -99.016  -1.929 -46.085  1.00  0.00           C  
ATOM    186  H   ALA A  13     -99.751  -3.745 -44.569  1.00  0.00           H  
ATOM    187  HA  ALA A  13     -97.167  -2.941 -45.662  1.00  0.00           H  
ATOM    188  HB1 ALA A  13     -98.902  -2.365 -47.065  1.00  0.00           H  
ATOM    189  HB2 ALA A  13     -98.823  -0.867 -46.138  1.00  0.00           H  
ATOM    190  HB3 ALA A  13    -100.023  -2.093 -45.732  1.00  0.00           H  
ATOM    191  N   LEU A  14     -98.328  -1.486 -42.969  1.00  0.00           N  
ATOM    192  CA  LEU A  14     -97.955  -0.525 -41.892  1.00  0.00           C  
ATOM    193  C   LEU A  14     -97.381  -1.267 -40.682  1.00  0.00           C  
ATOM    194  O   LEU A  14     -97.454  -0.799 -39.564  1.00  0.00           O  
ATOM    195  CB  LEU A  14     -99.260   0.178 -41.518  1.00  0.00           C  
ATOM    196  CG  LEU A  14     -99.500   1.348 -42.472  1.00  0.00           C  
ATOM    197  CD1 LEU A  14    -100.208   0.845 -43.731  1.00  0.00           C  
ATOM    198  CD2 LEU A  14    -100.374   2.398 -41.781  1.00  0.00           C  
ATOM    199  H   LEU A  14     -99.127  -2.046 -42.872  1.00  0.00           H  
ATOM    200  HA  LEU A  14     -97.244   0.196 -42.262  1.00  0.00           H  
ATOM    201  HB2 LEU A  14    -100.079  -0.522 -41.591  1.00  0.00           H  
ATOM    202  HB3 LEU A  14     -99.192   0.549 -40.506  1.00  0.00           H  
ATOM    203  HG  LEU A  14     -98.552   1.789 -42.745  1.00  0.00           H  
ATOM    204 HD11 LEU A  14    -100.356   1.667 -44.415  1.00  0.00           H  
ATOM    205 HD12 LEU A  14    -101.164   0.423 -43.462  1.00  0.00           H  
ATOM    206 HD13 LEU A  14     -99.601   0.087 -44.207  1.00  0.00           H  
ATOM    207 HD21 LEU A  14     -99.869   3.353 -41.796  1.00  0.00           H  
ATOM    208 HD22 LEU A  14    -100.552   2.102 -40.758  1.00  0.00           H  
ATOM    209 HD23 LEU A  14    -101.317   2.481 -42.302  1.00  0.00           H  
ATOM    210  N   GLU A  15     -96.806  -2.419 -40.896  1.00  0.00           N  
ATOM    211  CA  GLU A  15     -96.226  -3.183 -39.754  1.00  0.00           C  
ATOM    212  C   GLU A  15     -94.753  -2.804 -39.564  1.00  0.00           C  
ATOM    213  O   GLU A  15     -94.224  -2.861 -38.472  1.00  0.00           O  
ATOM    214  CB  GLU A  15     -96.355  -4.655 -40.149  1.00  0.00           C  
ATOM    215  CG  GLU A  15     -96.188  -5.532 -38.906  1.00  0.00           C  
ATOM    216  CD  GLU A  15     -96.397  -7.000 -39.283  1.00  0.00           C  
ATOM    217  OE1 GLU A  15     -97.227  -7.259 -40.138  1.00  0.00           O  
ATOM    218  OE2 GLU A  15     -95.726  -7.841 -38.708  1.00  0.00           O  
ATOM    219  H   GLU A  15     -96.754  -2.780 -41.805  1.00  0.00           H  
ATOM    220  HA  GLU A  15     -96.783  -2.992 -38.851  1.00  0.00           H  
ATOM    221  HB2 GLU A  15     -97.330  -4.826 -40.583  1.00  0.00           H  
ATOM    222  HB3 GLU A  15     -95.591  -4.904 -40.869  1.00  0.00           H  
ATOM    223  HG2 GLU A  15     -95.192  -5.402 -38.505  1.00  0.00           H  
ATOM    224  HG3 GLU A  15     -96.915  -5.246 -38.162  1.00  0.00           H  
ATOM    225  N   ASN A  16     -94.091  -2.416 -40.620  1.00  0.00           N  
ATOM    226  CA  ASN A  16     -92.654  -2.034 -40.499  1.00  0.00           C  
ATOM    227  C   ASN A  16     -92.235  -1.176 -41.696  1.00  0.00           C  
ATOM    228  O   ASN A  16     -91.312  -1.505 -42.415  1.00  0.00           O  
ATOM    229  CB  ASN A  16     -91.889  -3.358 -40.491  1.00  0.00           C  
ATOM    230  CG  ASN A  16     -91.774  -3.871 -39.055  1.00  0.00           C  
ATOM    231  OD1 ASN A  16     -91.429  -3.128 -38.157  1.00  0.00           O  
ATOM    232  ND2 ASN A  16     -92.048  -5.121 -38.798  1.00  0.00           N  
ATOM    233  H   ASN A  16     -94.537  -2.376 -41.491  1.00  0.00           H  
ATOM    234  HA  ASN A  16     -92.482  -1.503 -39.576  1.00  0.00           H  
ATOM    235  HB2 ASN A  16     -92.419  -4.083 -41.093  1.00  0.00           H  
ATOM    236  HB3 ASN A  16     -90.901  -3.205 -40.898  1.00  0.00           H  
ATOM    237 HD21 ASN A  16     -92.324  -5.720 -39.522  1.00  0.00           H  
ATOM    238 HD22 ASN A  16     -91.977  -5.459 -37.881  1.00  0.00           H  
ATOM    239  N   LYS A  17     -92.905  -0.078 -41.914  1.00  0.00           N  
ATOM    240  CA  LYS A  17     -92.546   0.802 -43.062  1.00  0.00           C  
ATOM    241  C   LYS A  17     -91.554   1.877 -42.612  1.00  0.00           C  
ATOM    242  O   LYS A  17     -91.587   2.332 -41.486  1.00  0.00           O  
ATOM    243  CB  LYS A  17     -93.865   1.438 -43.500  1.00  0.00           C  
ATOM    244  CG  LYS A  17     -93.744   1.920 -44.947  1.00  0.00           C  
ATOM    245  CD  LYS A  17     -93.416   3.414 -44.963  1.00  0.00           C  
ATOM    246  CE  LYS A  17     -94.590   4.199 -44.372  1.00  0.00           C  
ATOM    247  NZ  LYS A  17     -95.089   5.044 -45.493  1.00  0.00           N  
ATOM    248  H   LYS A  17     -93.646   0.169 -41.321  1.00  0.00           H  
ATOM    249  HA  LYS A  17     -92.132   0.219 -43.869  1.00  0.00           H  
ATOM    250  HB2 LYS A  17     -94.658   0.707 -43.428  1.00  0.00           H  
ATOM    251  HB3 LYS A  17     -94.089   2.278 -42.861  1.00  0.00           H  
ATOM    252  HG2 LYS A  17     -92.957   1.372 -45.445  1.00  0.00           H  
ATOM    253  HG3 LYS A  17     -94.679   1.754 -45.461  1.00  0.00           H  
ATOM    254  HD2 LYS A  17     -92.528   3.593 -44.373  1.00  0.00           H  
ATOM    255  HD3 LYS A  17     -93.246   3.736 -45.979  1.00  0.00           H  
ATOM    256  HE2 LYS A  17     -95.363   3.521 -44.036  1.00  0.00           H  
ATOM    257  HE3 LYS A  17     -94.255   4.823 -43.559  1.00  0.00           H  
ATOM    258  HZ1 LYS A  17     -94.284   5.492 -45.975  1.00  0.00           H  
ATOM    259  HZ2 LYS A  17     -95.721   5.781 -45.115  1.00  0.00           H  
ATOM    260  HZ3 LYS A  17     -95.611   4.452 -46.169  1.00  0.00           H  
ATOM    261  N   GLU A  18     -90.672   2.287 -43.482  1.00  0.00           N  
ATOM    262  CA  GLU A  18     -89.678   3.332 -43.102  1.00  0.00           C  
ATOM    263  C   GLU A  18     -90.360   4.700 -43.005  1.00  0.00           C  
ATOM    264  O   GLU A  18     -90.350   5.477 -43.940  1.00  0.00           O  
ATOM    265  CB  GLU A  18     -88.647   3.324 -44.231  1.00  0.00           C  
ATOM    266  CG  GLU A  18     -87.430   4.153 -43.816  1.00  0.00           C  
ATOM    267  CD  GLU A  18     -86.788   4.773 -45.060  1.00  0.00           C  
ATOM    268  OE1 GLU A  18     -86.027   4.083 -45.717  1.00  0.00           O  
ATOM    269  OE2 GLU A  18     -87.070   5.928 -45.334  1.00  0.00           O  
ATOM    270  H   GLU A  18     -90.662   1.908 -44.386  1.00  0.00           H  
ATOM    271  HA  GLU A  18     -89.204   3.080 -42.167  1.00  0.00           H  
ATOM    272  HB2 GLU A  18     -88.340   2.306 -44.429  1.00  0.00           H  
ATOM    273  HB3 GLU A  18     -89.084   3.749 -45.121  1.00  0.00           H  
ATOM    274  HG2 GLU A  18     -87.741   4.937 -43.141  1.00  0.00           H  
ATOM    275  HG3 GLU A  18     -86.711   3.517 -43.323  1.00  0.00           H  
ATOM    276  N   HIS A  19     -90.950   5.001 -41.880  1.00  0.00           N  
ATOM    277  CA  HIS A  19     -91.630   6.320 -41.725  1.00  0.00           C  
ATOM    278  C   HIS A  19     -90.595   7.431 -41.532  1.00  0.00           C  
ATOM    279  O   HIS A  19     -90.587   8.120 -40.531  1.00  0.00           O  
ATOM    280  CB  HIS A  19     -92.505   6.174 -40.478  1.00  0.00           C  
ATOM    281  CG  HIS A  19     -91.636   5.977 -39.265  1.00  0.00           C  
ATOM    282  ND1 HIS A  19     -91.338   7.013 -38.394  1.00  0.00           N  
ATOM    283  CD2 HIS A  19     -90.998   4.870 -38.763  1.00  0.00           C  
ATOM    284  CE1 HIS A  19     -90.554   6.512 -37.421  1.00  0.00           C  
ATOM    285  NE2 HIS A  19     -90.317   5.210 -37.598  1.00  0.00           N  
ATOM    286  H   HIS A  19     -90.947   4.361 -41.139  1.00  0.00           H  
ATOM    287  HA  HIS A  19     -92.248   6.528 -42.585  1.00  0.00           H  
ATOM    288  HB2 HIS A  19     -93.101   7.066 -40.352  1.00  0.00           H  
ATOM    289  HB3 HIS A  19     -93.157   5.321 -40.595  1.00  0.00           H  
ATOM    290  HD1 HIS A  19     -91.642   7.941 -38.471  1.00  0.00           H  
ATOM    291  HD2 HIS A  19     -91.023   3.884 -39.203  1.00  0.00           H  
ATOM    292  HE1 HIS A  19     -90.165   7.093 -36.598  1.00  0.00           H  
ATOM    293  N   ASP A  20     -89.721   7.614 -42.483  1.00  0.00           N  
ATOM    294  CA  ASP A  20     -88.688   8.681 -42.352  1.00  0.00           C  
ATOM    295  C   ASP A  20     -88.081   9.002 -43.721  1.00  0.00           C  
ATOM    296  O   ASP A  20     -86.938   8.690 -43.992  1.00  0.00           O  
ATOM    297  CB  ASP A  20     -87.630   8.093 -41.419  1.00  0.00           C  
ATOM    298  CG  ASP A  20     -86.903   9.227 -40.693  1.00  0.00           C  
ATOM    299  OD1 ASP A  20     -86.859  10.319 -41.234  1.00  0.00           O  
ATOM    300  OD2 ASP A  20     -86.403   8.983 -39.606  1.00  0.00           O  
ATOM    301  H   ASP A  20     -89.744   7.049 -43.284  1.00  0.00           H  
ATOM    302  HA  ASP A  20     -89.116   9.567 -41.912  1.00  0.00           H  
ATOM    303  HB2 ASP A  20     -88.106   7.448 -40.696  1.00  0.00           H  
ATOM    304  HB3 ASP A  20     -86.917   7.524 -41.997  1.00  0.00           H  
ATOM    305  N   ILE A  21     -88.837   9.621 -44.585  1.00  0.00           N  
ATOM    306  CA  ILE A  21     -88.302   9.959 -45.935  1.00  0.00           C  
ATOM    307  C   ILE A  21     -88.482  11.452 -46.219  1.00  0.00           C  
ATOM    308  O   ILE A  21     -89.510  12.031 -45.925  1.00  0.00           O  
ATOM    309  CB  ILE A  21     -89.134   9.124 -46.909  1.00  0.00           C  
ATOM    310  CG1 ILE A  21     -88.988   7.640 -46.561  1.00  0.00           C  
ATOM    311  CG2 ILE A  21     -88.639   9.362 -48.337  1.00  0.00           C  
ATOM    312  CD1 ILE A  21     -90.144   6.853 -47.179  1.00  0.00           C  
ATOM    313  H   ILE A  21     -89.757   9.864 -44.348  1.00  0.00           H  
ATOM    314  HA  ILE A  21     -87.262   9.683 -46.009  1.00  0.00           H  
ATOM    315  HB  ILE A  21     -90.172   9.414 -46.835  1.00  0.00           H  
ATOM    316 HG12 ILE A  21     -88.050   7.270 -46.949  1.00  0.00           H  
ATOM    317 HG13 ILE A  21     -89.006   7.519 -45.488  1.00  0.00           H  
ATOM    318 HG21 ILE A  21     -87.566   9.489 -48.330  1.00  0.00           H  
ATOM    319 HG22 ILE A  21     -89.104  10.252 -48.735  1.00  0.00           H  
ATOM    320 HG23 ILE A  21     -88.898   8.514 -48.954  1.00  0.00           H  
ATOM    321 HD11 ILE A  21     -91.067   7.394 -47.036  1.00  0.00           H  
ATOM    322 HD12 ILE A  21     -90.216   5.886 -46.704  1.00  0.00           H  
ATOM    323 HD13 ILE A  21     -89.965   6.721 -48.236  1.00  0.00           H  
ATOM    324  N   GLY A  22     -87.491  12.082 -46.787  1.00  0.00           N  
ATOM    325  CA  GLY A  22     -87.606  13.537 -47.089  1.00  0.00           C  
ATOM    326  C   GLY A  22     -87.082  14.349 -45.904  1.00  0.00           C  
ATOM    327  O   GLY A  22     -86.338  13.846 -45.086  1.00  0.00           O  
ATOM    328  H   GLY A  22     -86.670  11.598 -47.017  1.00  0.00           H  
ATOM    329  HA2 GLY A  22     -87.025  13.768 -47.971  1.00  0.00           H  
ATOM    330  HA3 GLY A  22     -88.641  13.787 -47.264  1.00  0.00           H  
ATOM    331  N   PRO A  23     -87.495  15.587 -45.852  1.00  0.00           N  
ATOM    332  CA  PRO A  23     -87.065  16.488 -44.755  1.00  0.00           C  
ATOM    333  C   PRO A  23     -87.757  16.100 -43.445  1.00  0.00           C  
ATOM    334  O   PRO A  23     -88.636  15.262 -43.422  1.00  0.00           O  
ATOM    335  CB  PRO A  23     -87.521  17.867 -45.225  1.00  0.00           C  
ATOM    336  CG  PRO A  23     -88.652  17.600 -46.166  1.00  0.00           C  
ATOM    337  CD  PRO A  23     -88.391  16.257 -46.800  1.00  0.00           C  
ATOM    338  HA  PRO A  23     -85.993  16.470 -44.642  1.00  0.00           H  
ATOM    339  HB2 PRO A  23     -87.858  18.456 -44.383  1.00  0.00           H  
ATOM    340  HB3 PRO A  23     -86.721  18.371 -45.743  1.00  0.00           H  
ATOM    341  HG2 PRO A  23     -89.586  17.577 -45.621  1.00  0.00           H  
ATOM    342  HG3 PRO A  23     -88.686  18.361 -46.929  1.00  0.00           H  
ATOM    343  HD2 PRO A  23     -89.315  15.705 -46.908  1.00  0.00           H  
ATOM    344  HD3 PRO A  23     -87.903  16.375 -47.754  1.00  0.00           H  
ATOM    345  N   ARG A  24     -87.366  16.703 -42.355  1.00  0.00           N  
ATOM    346  CA  ARG A  24     -88.001  16.367 -41.045  1.00  0.00           C  
ATOM    347  C   ARG A  24     -87.399  17.226 -39.930  1.00  0.00           C  
ATOM    348  O   ARG A  24     -86.249  17.615 -39.985  1.00  0.00           O  
ATOM    349  CB  ARG A  24     -87.676  14.891 -40.814  1.00  0.00           C  
ATOM    350  CG  ARG A  24     -86.175  14.664 -41.005  1.00  0.00           C  
ATOM    351  CD  ARG A  24     -85.741  13.426 -40.219  1.00  0.00           C  
ATOM    352  NE  ARG A  24     -84.943  12.619 -41.183  1.00  0.00           N  
ATOM    353  CZ  ARG A  24     -83.655  12.490 -41.018  1.00  0.00           C  
ATOM    354  NH1 ARG A  24     -82.845  13.414 -41.458  1.00  0.00           N  
ATOM    355  NH2 ARG A  24     -83.177  11.439 -40.412  1.00  0.00           N  
ATOM    356  H   ARG A  24     -86.655  17.376 -42.395  1.00  0.00           H  
ATOM    357  HA  ARG A  24     -89.069  16.507 -41.097  1.00  0.00           H  
ATOM    358  HB2 ARG A  24     -87.958  14.615 -39.808  1.00  0.00           H  
ATOM    359  HB3 ARG A  24     -88.222  14.285 -41.520  1.00  0.00           H  
ATOM    360  HG2 ARG A  24     -85.964  14.517 -42.055  1.00  0.00           H  
ATOM    361  HG3 ARG A  24     -85.632  15.525 -40.645  1.00  0.00           H  
ATOM    362  HD2 ARG A  24     -85.132  13.713 -39.371  1.00  0.00           H  
ATOM    363  HD3 ARG A  24     -86.603  12.865 -39.891  1.00  0.00           H  
ATOM    364  HE  ARG A  24     -85.385  12.185 -41.942  1.00  0.00           H  
ATOM    365 HH11 ARG A  24     -83.211  14.219 -41.924  1.00  0.00           H  
ATOM    366 HH12 ARG A  24     -81.858  13.315 -41.331  1.00  0.00           H  
ATOM    367 HH21 ARG A  24     -83.798  10.730 -40.074  1.00  0.00           H  
ATOM    368 HH22 ARG A  24     -82.190  11.340 -40.285  1.00  0.00           H  
ATOM    369  N   GLU A  25     -88.166  17.523 -38.918  1.00  0.00           N  
ATOM    370  CA  GLU A  25     -87.635  18.353 -37.798  1.00  0.00           C  
ATOM    371  C   GLU A  25     -88.107  17.790 -36.454  1.00  0.00           C  
ATOM    372  O   GLU A  25     -88.674  16.717 -36.385  1.00  0.00           O  
ATOM    373  CB  GLU A  25     -88.214  19.750 -38.030  1.00  0.00           C  
ATOM    374  CG  GLU A  25     -87.156  20.638 -38.690  1.00  0.00           C  
ATOM    375  CD  GLU A  25     -87.041  21.956 -37.923  1.00  0.00           C  
ATOM    376  OE1 GLU A  25     -88.018  22.347 -37.305  1.00  0.00           O  
ATOM    377  OE2 GLU A  25     -85.977  22.552 -37.965  1.00  0.00           O  
ATOM    378  H   GLU A  25     -89.091  17.199 -38.891  1.00  0.00           H  
ATOM    379  HA  GLU A  25     -86.558  18.390 -37.836  1.00  0.00           H  
ATOM    380  HB2 GLU A  25     -89.080  19.680 -38.673  1.00  0.00           H  
ATOM    381  HB3 GLU A  25     -88.503  20.183 -37.083  1.00  0.00           H  
ATOM    382  HG2 GLU A  25     -86.203  20.129 -38.680  1.00  0.00           H  
ATOM    383  HG3 GLU A  25     -87.444  20.843 -39.711  1.00  0.00           H  
ATOM    384  N   GLN A  26     -87.877  18.502 -35.385  1.00  0.00           N  
ATOM    385  CA  GLN A  26     -88.312  18.003 -34.049  1.00  0.00           C  
ATOM    386  C   GLN A  26     -89.156  19.062 -33.334  1.00  0.00           C  
ATOM    387  O   GLN A  26     -88.718  20.174 -33.112  1.00  0.00           O  
ATOM    388  CB  GLN A  26     -87.016  17.744 -33.281  1.00  0.00           C  
ATOM    389  CG  GLN A  26     -86.252  16.594 -33.941  1.00  0.00           C  
ATOM    390  CD  GLN A  26     -86.838  15.259 -33.477  1.00  0.00           C  
ATOM    391  OE1 GLN A  26     -86.554  14.802 -32.388  1.00  0.00           O  
ATOM    392  NE2 GLN A  26     -87.652  14.611 -34.264  1.00  0.00           N  
ATOM    393  H   GLN A  26     -87.417  19.364 -35.460  1.00  0.00           H  
ATOM    394  HA  GLN A  26     -88.867  17.085 -34.153  1.00  0.00           H  
ATOM    395  HB2 GLN A  26     -86.406  18.636 -33.292  1.00  0.00           H  
ATOM    396  HB3 GLN A  26     -87.248  17.480 -32.259  1.00  0.00           H  
ATOM    397  HG2 GLN A  26     -86.339  16.674 -35.014  1.00  0.00           H  
ATOM    398  HG3 GLN A  26     -85.211  16.645 -33.658  1.00  0.00           H  
ATOM    399 HE21 GLN A  26     -87.882  14.979 -35.142  1.00  0.00           H  
ATOM    400 HE22 GLN A  26     -88.032  13.754 -33.978  1.00  0.00           H  
ATOM    401  N   VAL A  27     -90.365  18.727 -32.972  1.00  0.00           N  
ATOM    402  CA  VAL A  27     -91.237  19.714 -32.272  1.00  0.00           C  
ATOM    403  C   VAL A  27     -91.821  19.102 -30.997  1.00  0.00           C  
ATOM    404  O   VAL A  27     -92.537  18.121 -31.040  1.00  0.00           O  
ATOM    405  CB  VAL A  27     -92.354  20.035 -33.264  1.00  0.00           C  
ATOM    406  CG1 VAL A  27     -93.494  20.749 -32.534  1.00  0.00           C  
ATOM    407  CG2 VAL A  27     -91.808  20.944 -34.367  1.00  0.00           C  
ATOM    408  H   VAL A  27     -90.700  17.824 -33.160  1.00  0.00           H  
ATOM    409  HA  VAL A  27     -90.682  20.610 -32.041  1.00  0.00           H  
ATOM    410  HB  VAL A  27     -92.724  19.117 -33.698  1.00  0.00           H  
ATOM    411 HG11 VAL A  27     -93.108  21.233 -31.648  1.00  0.00           H  
ATOM    412 HG12 VAL A  27     -94.248  20.028 -32.251  1.00  0.00           H  
ATOM    413 HG13 VAL A  27     -93.933  21.489 -33.187  1.00  0.00           H  
ATOM    414 HG21 VAL A  27     -91.750  21.959 -34.002  1.00  0.00           H  
ATOM    415 HG22 VAL A  27     -92.465  20.906 -35.222  1.00  0.00           H  
ATOM    416 HG23 VAL A  27     -90.823  20.608 -34.654  1.00  0.00           H  
ATOM    417  N   ASN A  28     -91.530  19.678 -29.863  1.00  0.00           N  
ATOM    418  CA  ASN A  28     -92.079  19.131 -28.591  1.00  0.00           C  
ATOM    419  C   ASN A  28     -93.566  19.475 -28.480  1.00  0.00           C  
ATOM    420  O   ASN A  28     -94.146  20.055 -29.378  1.00  0.00           O  
ATOM    421  CB  ASN A  28     -91.283  19.824 -27.484  1.00  0.00           C  
ATOM    422  CG  ASN A  28     -91.065  18.849 -26.325  1.00  0.00           C  
ATOM    423  OD1 ASN A  28     -90.139  18.064 -26.344  1.00  0.00           O  
ATOM    424  ND2 ASN A  28     -91.884  18.868 -25.309  1.00  0.00           N  
ATOM    425  H   ASN A  28     -90.956  20.473 -29.849  1.00  0.00           H  
ATOM    426  HA  ASN A  28     -91.931  18.064 -28.541  1.00  0.00           H  
ATOM    427  HB2 ASN A  28     -90.327  20.142 -27.874  1.00  0.00           H  
ATOM    428  HB3 ASN A  28     -91.833  20.684 -27.130  1.00  0.00           H  
ATOM    429 HD21 ASN A  28     -92.631  19.504 -25.293  1.00  0.00           H  
ATOM    430 HD22 ASN A  28     -91.755  18.245 -24.564  1.00  0.00           H  
ATOM    431  N   PHE A  29     -94.191  19.126 -27.390  1.00  0.00           N  
ATOM    432  CA  PHE A  29     -95.639  19.442 -27.234  1.00  0.00           C  
ATOM    433  C   PHE A  29     -95.984  19.646 -25.757  1.00  0.00           C  
ATOM    434  O   PHE A  29     -95.494  18.949 -24.891  1.00  0.00           O  
ATOM    435  CB  PHE A  29     -96.376  18.227 -27.797  1.00  0.00           C  
ATOM    436  CG  PHE A  29     -95.616  16.970 -27.450  1.00  0.00           C  
ATOM    437  CD1 PHE A  29     -95.680  16.449 -26.154  1.00  0.00           C  
ATOM    438  CD2 PHE A  29     -94.851  16.323 -28.428  1.00  0.00           C  
ATOM    439  CE1 PHE A  29     -94.977  15.281 -25.833  1.00  0.00           C  
ATOM    440  CE2 PHE A  29     -94.148  15.155 -28.108  1.00  0.00           C  
ATOM    441  CZ  PHE A  29     -94.211  14.634 -26.810  1.00  0.00           C  
ATOM    442  H   PHE A  29     -93.709  18.660 -26.675  1.00  0.00           H  
ATOM    443  HA  PHE A  29     -95.894  20.321 -27.805  1.00  0.00           H  
ATOM    444  HB2 PHE A  29     -97.367  18.177 -27.369  1.00  0.00           H  
ATOM    445  HB3 PHE A  29     -96.450  18.316 -28.870  1.00  0.00           H  
ATOM    446  HD1 PHE A  29     -96.271  16.949 -25.400  1.00  0.00           H  
ATOM    447  HD2 PHE A  29     -94.801  16.726 -29.428  1.00  0.00           H  
ATOM    448  HE1 PHE A  29     -95.027  14.878 -24.832  1.00  0.00           H  
ATOM    449  HE2 PHE A  29     -93.556  14.656 -28.862  1.00  0.00           H  
ATOM    450  HZ  PHE A  29     -93.670  13.732 -26.563  1.00  0.00           H  
ATOM    451  N   GLN A  30     -96.825  20.600 -25.466  1.00  0.00           N  
ATOM    452  CA  GLN A  30     -97.205  20.856 -24.046  1.00  0.00           C  
ATOM    453  C   GLN A  30     -98.511  20.134 -23.711  1.00  0.00           C  
ATOM    454  O   GLN A  30     -99.561  20.451 -24.233  1.00  0.00           O  
ATOM    455  CB  GLN A  30     -97.387  22.372 -23.957  1.00  0.00           C  
ATOM    456  CG  GLN A  30     -96.073  23.018 -23.509  1.00  0.00           C  
ATOM    457  CD  GLN A  30     -94.904  22.354 -24.236  1.00  0.00           C  
ATOM    458  OE1 GLN A  30     -94.194  21.550 -23.664  1.00  0.00           O  
ATOM    459  NE2 GLN A  30     -94.671  22.657 -25.485  1.00  0.00           N  
ATOM    460  H   GLN A  30     -97.205  21.150 -26.181  1.00  0.00           H  
ATOM    461  HA  GLN A  30     -96.418  20.540 -23.380  1.00  0.00           H  
ATOM    462  HB2 GLN A  30     -97.666  22.758 -24.926  1.00  0.00           H  
ATOM    463  HB3 GLN A  30     -98.162  22.600 -23.240  1.00  0.00           H  
ATOM    464  HG2 GLN A  30     -96.093  24.073 -23.743  1.00  0.00           H  
ATOM    465  HG3 GLN A  30     -95.953  22.888 -22.443  1.00  0.00           H  
ATOM    466 HE21 GLN A  30     -95.242  23.305 -25.947  1.00  0.00           H  
ATOM    467 HE22 GLN A  30     -93.923  22.236 -25.960  1.00  0.00           H  
ATOM    468  N   LEU A  31     -98.453  19.163 -22.841  1.00  0.00           N  
ATOM    469  CA  LEU A  31     -99.690  18.417 -22.471  1.00  0.00           C  
ATOM    470  C   LEU A  31    -100.421  19.138 -21.337  1.00  0.00           C  
ATOM    471  O   LEU A  31     -99.876  19.358 -20.274  1.00  0.00           O  
ATOM    472  CB  LEU A  31     -99.202  17.045 -22.004  1.00  0.00           C  
ATOM    473  CG  LEU A  31     -98.294  16.433 -23.072  1.00  0.00           C  
ATOM    474  CD1 LEU A  31     -97.695  15.128 -22.547  1.00  0.00           C  
ATOM    475  CD2 LEU A  31     -99.113  16.147 -24.333  1.00  0.00           C  
ATOM    476  H   LEU A  31     -97.595  18.921 -22.432  1.00  0.00           H  
ATOM    477  HA  LEU A  31    -100.335  18.307 -23.328  1.00  0.00           H  
ATOM    478  HB2 LEU A  31     -98.650  17.154 -21.082  1.00  0.00           H  
ATOM    479  HB3 LEU A  31    -100.050  16.398 -21.843  1.00  0.00           H  
ATOM    480  HG  LEU A  31     -97.498  17.126 -23.307  1.00  0.00           H  
ATOM    481 HD11 LEU A  31     -97.686  15.146 -21.466  1.00  0.00           H  
ATOM    482 HD12 LEU A  31     -96.685  15.022 -22.913  1.00  0.00           H  
ATOM    483 HD13 LEU A  31     -98.293  14.295 -22.887  1.00  0.00           H  
ATOM    484 HD21 LEU A  31    -100.144  16.421 -24.163  1.00  0.00           H  
ATOM    485 HD22 LEU A  31     -99.054  15.095 -24.569  1.00  0.00           H  
ATOM    486 HD23 LEU A  31     -98.719  16.724 -25.158  1.00  0.00           H  
ATOM    487  N   LEU A  32    -101.653  19.510 -21.555  1.00  0.00           N  
ATOM    488  CA  LEU A  32    -102.417  20.217 -20.489  1.00  0.00           C  
ATOM    489  C   LEU A  32    -103.841  19.656 -20.402  1.00  0.00           C  
ATOM    490  O   LEU A  32    -104.420  19.255 -21.392  1.00  0.00           O  
ATOM    491  CB  LEU A  32    -102.437  21.681 -20.927  1.00  0.00           C  
ATOM    492  CG  LEU A  32    -101.012  22.239 -20.895  1.00  0.00           C  
ATOM    493  CD1 LEU A  32    -101.023  23.696 -21.362  1.00  0.00           C  
ATOM    494  CD2 LEU A  32    -100.470  22.168 -19.465  1.00  0.00           C  
ATOM    495  H   LEU A  32    -102.075  19.323 -22.419  1.00  0.00           H  
ATOM    496  HA  LEU A  32    -101.916  20.122 -19.539  1.00  0.00           H  
ATOM    497  HB2 LEU A  32    -102.830  21.751 -21.930  1.00  0.00           H  
ATOM    498  HB3 LEU A  32    -103.059  22.250 -20.254  1.00  0.00           H  
ATOM    499  HG  LEU A  32    -100.380  21.655 -21.552  1.00  0.00           H  
ATOM    500 HD11 LEU A  32    -100.972  23.728 -22.439  1.00  0.00           H  
ATOM    501 HD12 LEU A  32    -100.172  24.214 -20.944  1.00  0.00           H  
ATOM    502 HD13 LEU A  32    -101.934  24.173 -21.030  1.00  0.00           H  
ATOM    503 HD21 LEU A  32    -101.279  21.945 -18.785  1.00  0.00           H  
ATOM    504 HD22 LEU A  32    -100.027  23.116 -19.200  1.00  0.00           H  
ATOM    505 HD23 LEU A  32     -99.722  21.391 -19.402  1.00  0.00           H  
ATOM    506  N   ASP A  33    -104.406  19.617 -19.226  1.00  0.00           N  
ATOM    507  CA  ASP A  33    -105.788  19.072 -19.082  1.00  0.00           C  
ATOM    508  C   ASP A  33    -106.763  20.174 -18.658  1.00  0.00           C  
ATOM    509  O   ASP A  33    -107.254  20.187 -17.545  1.00  0.00           O  
ATOM    510  CB  ASP A  33    -105.679  18.006 -17.992  1.00  0.00           C  
ATOM    511  CG  ASP A  33    -105.103  18.632 -16.720  1.00  0.00           C  
ATOM    512  OD1 ASP A  33    -104.879  19.831 -16.723  1.00  0.00           O  
ATOM    513  OD2 ASP A  33    -104.899  17.902 -15.765  1.00  0.00           O  
ATOM    514  H   ASP A  33    -103.921  19.939 -18.437  1.00  0.00           H  
ATOM    515  HA  ASP A  33    -106.111  18.620 -20.005  1.00  0.00           H  
ATOM    516  HB2 ASP A  33    -106.660  17.604 -17.785  1.00  0.00           H  
ATOM    517  HB3 ASP A  33    -105.028  17.214 -18.326  1.00  0.00           H  
ATOM    518  N   LYS A  34    -107.056  21.093 -19.536  1.00  0.00           N  
ATOM    519  CA  LYS A  34    -108.009  22.186 -19.182  1.00  0.00           C  
ATOM    520  C   LYS A  34    -107.618  22.826 -17.848  1.00  0.00           C  
ATOM    521  O   LYS A  34    -108.441  23.391 -17.156  1.00  0.00           O  
ATOM    522  CB  LYS A  34    -109.366  21.492 -19.065  1.00  0.00           C  
ATOM    523  CG  LYS A  34    -110.482  22.497 -19.352  1.00  0.00           C  
ATOM    524  CD  LYS A  34    -111.762  22.053 -18.643  1.00  0.00           C  
ATOM    525  CE  LYS A  34    -112.978  22.482 -19.468  1.00  0.00           C  
ATOM    526  NZ  LYS A  34    -114.106  22.521 -18.496  1.00  0.00           N  
ATOM    527  H   LYS A  34    -106.657  21.062 -20.430  1.00  0.00           H  
ATOM    528  HA  LYS A  34    -108.042  22.927 -19.964  1.00  0.00           H  
ATOM    529  HB2 LYS A  34    -109.419  20.682 -19.778  1.00  0.00           H  
ATOM    530  HB3 LYS A  34    -109.486  21.102 -18.066  1.00  0.00           H  
ATOM    531  HG2 LYS A  34    -110.189  23.473 -18.991  1.00  0.00           H  
ATOM    532  HG3 LYS A  34    -110.659  22.545 -20.416  1.00  0.00           H  
ATOM    533  HD2 LYS A  34    -111.760  20.978 -18.536  1.00  0.00           H  
ATOM    534  HD3 LYS A  34    -111.812  22.512 -17.668  1.00  0.00           H  
ATOM    535  HE2 LYS A  34    -112.813  23.460 -19.898  1.00  0.00           H  
ATOM    536  HE3 LYS A  34    -113.182  21.758 -20.241  1.00  0.00           H  
ATOM    537  HZ1 LYS A  34    -113.782  22.165 -17.574  1.00  0.00           H  
ATOM    538  HZ2 LYS A  34    -114.885  21.926 -18.845  1.00  0.00           H  
ATOM    539  HZ3 LYS A  34    -114.437  23.501 -18.389  1.00  0.00           H  
ATOM    540  N   ASN A  35    -106.368  22.746 -17.481  1.00  0.00           N  
ATOM    541  CA  ASN A  35    -105.931  23.353 -16.190  1.00  0.00           C  
ATOM    542  C   ASN A  35    -104.448  23.727 -16.255  1.00  0.00           C  
ATOM    543  O   ASN A  35    -103.788  23.865 -15.244  1.00  0.00           O  
ATOM    544  CB  ASN A  35    -106.166  22.262 -15.143  1.00  0.00           C  
ATOM    545  CG  ASN A  35    -107.495  22.517 -14.428  1.00  0.00           C  
ATOM    546  OD1 ASN A  35    -107.521  23.086 -13.354  1.00  0.00           O  
ATOM    547  ND2 ASN A  35    -108.608  22.117 -14.981  1.00  0.00           N  
ATOM    548  H   ASN A  35    -105.717  22.288 -18.053  1.00  0.00           H  
ATOM    549  HA  ASN A  35    -106.530  24.220 -15.960  1.00  0.00           H  
ATOM    550  HB2 ASN A  35    -106.197  21.298 -15.629  1.00  0.00           H  
ATOM    551  HB3 ASN A  35    -105.363  22.277 -14.422  1.00  0.00           H  
ATOM    552 HD21 ASN A  35    -108.587  21.658 -15.847  1.00  0.00           H  
ATOM    553 HD22 ASN A  35    -109.464  22.276 -14.530  1.00  0.00           H  
ATOM    554  N   ASN A  36    -103.918  23.892 -17.436  1.00  0.00           N  
ATOM    555  CA  ASN A  36    -102.478  24.258 -17.563  1.00  0.00           C  
ATOM    556  C   ASN A  36    -101.614  23.326 -16.710  1.00  0.00           C  
ATOM    557  O   ASN A  36    -100.535  23.685 -16.281  1.00  0.00           O  
ATOM    558  CB  ASN A  36    -102.386  25.694 -17.046  1.00  0.00           C  
ATOM    559  CG  ASN A  36    -103.168  26.625 -17.973  1.00  0.00           C  
ATOM    560  OD1 ASN A  36    -102.599  27.249 -18.846  1.00  0.00           O  
ATOM    561  ND2 ASN A  36    -104.459  26.745 -17.819  1.00  0.00           N  
ATOM    562  H   ASN A  36    -104.467  23.776 -18.239  1.00  0.00           H  
ATOM    563  HA  ASN A  36    -102.169  24.219 -18.595  1.00  0.00           H  
ATOM    564  HB2 ASN A  36    -102.801  25.744 -16.049  1.00  0.00           H  
ATOM    565  HB3 ASN A  36    -101.351  26.001 -17.020  1.00  0.00           H  
ATOM    566 HD21 ASN A  36    -104.917  26.243 -17.114  1.00  0.00           H  
ATOM    567 HD22 ASN A  36    -104.969  27.339 -18.409  1.00  0.00           H  
ATOM    568  N   GLU A  37    -102.077  22.132 -16.459  1.00  0.00           N  
ATOM    569  CA  GLU A  37    -101.277  21.182 -15.633  1.00  0.00           C  
ATOM    570  C   GLU A  37    -100.409  20.302 -16.536  1.00  0.00           C  
ATOM    571  O   GLU A  37    -100.902  19.454 -17.253  1.00  0.00           O  
ATOM    572  CB  GLU A  37    -102.310  20.335 -14.891  1.00  0.00           C  
ATOM    573  CG  GLU A  37    -101.723  19.865 -13.558  1.00  0.00           C  
ATOM    574  CD  GLU A  37    -101.834  20.990 -12.527  1.00  0.00           C  
ATOM    575  OE1 GLU A  37    -102.162  22.097 -12.919  1.00  0.00           O  
ATOM    576  OE2 GLU A  37    -101.587  20.724 -11.362  1.00  0.00           O  
ATOM    577  H   GLU A  37    -102.949  21.861 -16.814  1.00  0.00           H  
ATOM    578  HA  GLU A  37    -100.665  21.719 -14.927  1.00  0.00           H  
ATOM    579  HB2 GLU A  37    -103.196  20.925 -14.707  1.00  0.00           H  
ATOM    580  HB3 GLU A  37    -102.568  19.475 -15.491  1.00  0.00           H  
ATOM    581  HG2 GLU A  37    -102.270  19.001 -13.209  1.00  0.00           H  
ATOM    582  HG3 GLU A  37    -100.685  19.604 -13.694  1.00  0.00           H  
ATOM    583  N   THR A  38     -99.120  20.497 -16.508  1.00  0.00           N  
ATOM    584  CA  THR A  38     -98.221  19.673 -17.365  1.00  0.00           C  
ATOM    585  C   THR A  38     -97.756  18.428 -16.604  1.00  0.00           C  
ATOM    586  O   THR A  38     -96.946  18.506 -15.701  1.00  0.00           O  
ATOM    587  CB  THR A  38     -97.034  20.582 -17.683  1.00  0.00           C  
ATOM    588  OG1 THR A  38     -97.461  21.633 -18.537  1.00  0.00           O  
ATOM    589  CG2 THR A  38     -95.938  19.772 -18.376  1.00  0.00           C  
ATOM    590  H   THR A  38     -98.741  21.187 -15.923  1.00  0.00           H  
ATOM    591  HA  THR A  38     -98.724  19.392 -18.277  1.00  0.00           H  
ATOM    592  HB  THR A  38     -96.643  20.998 -16.767  1.00  0.00           H  
ATOM    593  HG1 THR A  38     -97.777  21.242 -19.355  1.00  0.00           H  
ATOM    594 HG21 THR A  38     -95.307  19.308 -17.632  1.00  0.00           H  
ATOM    595 HG22 THR A  38     -95.343  20.427 -18.996  1.00  0.00           H  
ATOM    596 HG23 THR A  38     -96.390  19.008 -18.991  1.00  0.00           H  
ATOM    597  N   GLN A  39     -98.258  17.278 -16.965  1.00  0.00           N  
ATOM    598  CA  GLN A  39     -97.841  16.030 -16.265  1.00  0.00           C  
ATOM    599  C   GLN A  39     -96.548  15.489 -16.881  1.00  0.00           C  
ATOM    600  O   GLN A  39     -96.568  14.794 -17.878  1.00  0.00           O  
ATOM    601  CB  GLN A  39     -98.994  15.051 -16.484  1.00  0.00           C  
ATOM    602  CG  GLN A  39    -100.298  15.681 -15.990  1.00  0.00           C  
ATOM    603  CD  GLN A  39    -100.820  14.897 -14.784  1.00  0.00           C  
ATOM    604  OE1 GLN A  39    -101.921  14.384 -14.809  1.00  0.00           O  
ATOM    605  NE2 GLN A  39    -100.071  14.783 -13.721  1.00  0.00           N  
ATOM    606  H   GLN A  39     -98.907  17.235 -17.698  1.00  0.00           H  
ATOM    607  HA  GLN A  39     -97.708  16.215 -15.210  1.00  0.00           H  
ATOM    608  HB2 GLN A  39     -99.079  14.823 -17.537  1.00  0.00           H  
ATOM    609  HB3 GLN A  39     -98.805  14.141 -15.933  1.00  0.00           H  
ATOM    610  HG2 GLN A  39    -100.115  16.706 -15.702  1.00  0.00           H  
ATOM    611  HG3 GLN A  39    -101.034  15.653 -16.780  1.00  0.00           H  
ATOM    612 HE21 GLN A  39     -99.183  15.197 -13.701  1.00  0.00           H  
ATOM    613 HE22 GLN A  39    -100.397  14.283 -12.943  1.00  0.00           H  
ATOM    614  N   TYR A  40     -95.424  15.804 -16.299  1.00  0.00           N  
ATOM    615  CA  TYR A  40     -94.130  15.311 -16.856  1.00  0.00           C  
ATOM    616  C   TYR A  40     -93.813  13.905 -16.330  1.00  0.00           C  
ATOM    617  O   TYR A  40     -92.722  13.400 -16.511  1.00  0.00           O  
ATOM    618  CB  TYR A  40     -93.084  16.311 -16.366  1.00  0.00           C  
ATOM    619  CG  TYR A  40     -92.158  16.669 -17.503  1.00  0.00           C  
ATOM    620  CD1 TYR A  40     -92.489  17.714 -18.374  1.00  0.00           C  
ATOM    621  CD2 TYR A  40     -90.967  15.955 -17.685  1.00  0.00           C  
ATOM    622  CE1 TYR A  40     -91.629  18.045 -19.428  1.00  0.00           C  
ATOM    623  CE2 TYR A  40     -90.108  16.287 -18.739  1.00  0.00           C  
ATOM    624  CZ  TYR A  40     -90.438  17.333 -19.610  1.00  0.00           C  
ATOM    625  OH  TYR A  40     -89.590  17.659 -20.649  1.00  0.00           O  
ATOM    626  H   TYR A  40     -95.428  16.368 -15.498  1.00  0.00           H  
ATOM    627  HA  TYR A  40     -94.161  15.311 -17.934  1.00  0.00           H  
ATOM    628  HB2 TYR A  40     -93.579  17.203 -16.009  1.00  0.00           H  
ATOM    629  HB3 TYR A  40     -92.513  15.870 -15.563  1.00  0.00           H  
ATOM    630  HD1 TYR A  40     -93.407  18.265 -18.234  1.00  0.00           H  
ATOM    631  HD2 TYR A  40     -90.712  15.150 -17.013  1.00  0.00           H  
ATOM    632  HE1 TYR A  40     -91.884  18.852 -20.099  1.00  0.00           H  
ATOM    633  HE2 TYR A  40     -89.189  15.737 -18.880  1.00  0.00           H  
ATOM    634  HH  TYR A  40     -89.423  16.862 -21.158  1.00  0.00           H  
ATOM    635  N   TYR A  41     -94.751  13.266 -15.683  1.00  0.00           N  
ATOM    636  CA  TYR A  41     -94.489  11.896 -15.155  1.00  0.00           C  
ATOM    637  C   TYR A  41     -95.506  10.907 -15.729  1.00  0.00           C  
ATOM    638  O   TYR A  41     -95.808   9.893 -15.131  1.00  0.00           O  
ATOM    639  CB  TYR A  41     -94.651  12.017 -13.640  1.00  0.00           C  
ATOM    640  CG  TYR A  41     -93.297  12.212 -13.001  1.00  0.00           C  
ATOM    641  CD1 TYR A  41     -92.677  13.467 -13.046  1.00  0.00           C  
ATOM    642  CD2 TYR A  41     -92.660  11.140 -12.366  1.00  0.00           C  
ATOM    643  CE1 TYR A  41     -91.420  13.648 -12.457  1.00  0.00           C  
ATOM    644  CE2 TYR A  41     -91.403  11.322 -11.776  1.00  0.00           C  
ATOM    645  CZ  TYR A  41     -90.784  12.576 -11.822  1.00  0.00           C  
ATOM    646  OH  TYR A  41     -89.545  12.756 -11.241  1.00  0.00           O  
ATOM    647  H   TYR A  41     -95.626  13.682 -15.545  1.00  0.00           H  
ATOM    648  HA  TYR A  41     -93.483  11.586 -15.395  1.00  0.00           H  
ATOM    649  HB2 TYR A  41     -95.283  12.863 -13.412  1.00  0.00           H  
ATOM    650  HB3 TYR A  41     -95.104  11.116 -13.253  1.00  0.00           H  
ATOM    651  HD1 TYR A  41     -93.167  14.294 -13.536  1.00  0.00           H  
ATOM    652  HD2 TYR A  41     -93.137  10.171 -12.330  1.00  0.00           H  
ATOM    653  HE1 TYR A  41     -90.942  14.616 -12.492  1.00  0.00           H  
ATOM    654  HE2 TYR A  41     -90.912  10.495 -11.285  1.00  0.00           H  
ATOM    655  HH  TYR A  41     -88.876  12.484 -11.874  1.00  0.00           H  
ATOM    656  N   HIS A  42     -96.036  11.194 -16.887  1.00  0.00           N  
ATOM    657  CA  HIS A  42     -97.034  10.271 -17.501  1.00  0.00           C  
ATOM    658  C   HIS A  42     -96.578   9.851 -18.900  1.00  0.00           C  
ATOM    659  O   HIS A  42     -97.382   9.642 -19.787  1.00  0.00           O  
ATOM    660  CB  HIS A  42     -98.328  11.082 -17.580  1.00  0.00           C  
ATOM    661  CG  HIS A  42     -99.183  10.780 -16.381  1.00  0.00           C  
ATOM    662  ND1 HIS A  42    -100.308   9.973 -16.459  1.00  0.00           N  
ATOM    663  CD2 HIS A  42     -99.091  11.168 -15.067  1.00  0.00           C  
ATOM    664  CE1 HIS A  42    -100.841   9.901 -15.226  1.00  0.00           C  
ATOM    665  NE2 HIS A  42    -100.140  10.612 -14.339  1.00  0.00           N  
ATOM    666  H   HIS A  42     -95.778  12.016 -17.353  1.00  0.00           H  
ATOM    667  HA  HIS A  42     -97.180   9.405 -16.875  1.00  0.00           H  
ATOM    668  HB2 HIS A  42     -98.091  12.136 -17.597  1.00  0.00           H  
ATOM    669  HB3 HIS A  42     -98.863  10.818 -18.479  1.00  0.00           H  
ATOM    670  HD1 HIS A  42    -100.651   9.535 -17.266  1.00  0.00           H  
ATOM    671  HD2 HIS A  42     -98.323  11.809 -14.660  1.00  0.00           H  
ATOM    672  HE1 HIS A  42    -101.730   9.337 -14.983  1.00  0.00           H  
ATOM    673  N   PHE A  43     -95.296   9.724 -19.105  1.00  0.00           N  
ATOM    674  CA  PHE A  43     -94.792   9.316 -20.447  1.00  0.00           C  
ATOM    675  C   PHE A  43     -95.080   7.830 -20.686  1.00  0.00           C  
ATOM    676  O   PHE A  43     -94.187   7.006 -20.686  1.00  0.00           O  
ATOM    677  CB  PHE A  43     -93.284   9.571 -20.401  1.00  0.00           C  
ATOM    678  CG  PHE A  43     -93.023  11.055 -20.510  1.00  0.00           C  
ATOM    679  CD1 PHE A  43     -93.184  11.706 -21.739  1.00  0.00           C  
ATOM    680  CD2 PHE A  43     -92.618  11.779 -19.382  1.00  0.00           C  
ATOM    681  CE1 PHE A  43     -92.941  13.082 -21.839  1.00  0.00           C  
ATOM    682  CE2 PHE A  43     -92.375  13.155 -19.482  1.00  0.00           C  
ATOM    683  CZ  PHE A  43     -92.537  13.805 -20.712  1.00  0.00           C  
ATOM    684  H   PHE A  43     -94.663   9.896 -18.376  1.00  0.00           H  
ATOM    685  HA  PHE A  43     -95.245   9.917 -21.219  1.00  0.00           H  
ATOM    686  HB2 PHE A  43     -92.885   9.203 -19.468  1.00  0.00           H  
ATOM    687  HB3 PHE A  43     -92.807   9.062 -21.224  1.00  0.00           H  
ATOM    688  HD1 PHE A  43     -93.495  11.147 -22.609  1.00  0.00           H  
ATOM    689  HD2 PHE A  43     -92.493  11.277 -18.434  1.00  0.00           H  
ATOM    690  HE1 PHE A  43     -93.065  13.584 -22.787  1.00  0.00           H  
ATOM    691  HE2 PHE A  43     -92.064  13.714 -18.613  1.00  0.00           H  
ATOM    692  HZ  PHE A  43     -92.350  14.866 -20.789  1.00  0.00           H  
ATOM    693  N   PHE A  44     -96.322   7.484 -20.888  1.00  0.00           N  
ATOM    694  CA  PHE A  44     -96.668   6.052 -21.123  1.00  0.00           C  
ATOM    695  C   PHE A  44     -96.993   5.820 -22.603  1.00  0.00           C  
ATOM    696  O   PHE A  44     -96.755   4.757 -23.139  1.00  0.00           O  
ATOM    697  CB  PHE A  44     -97.903   5.797 -20.258  1.00  0.00           C  
ATOM    698  CG  PHE A  44     -97.474   5.556 -18.831  1.00  0.00           C  
ATOM    699  CD1 PHE A  44     -96.462   4.630 -18.552  1.00  0.00           C  
ATOM    700  CD2 PHE A  44     -98.087   6.259 -17.786  1.00  0.00           C  
ATOM    701  CE1 PHE A  44     -96.064   4.407 -17.229  1.00  0.00           C  
ATOM    702  CE2 PHE A  44     -97.688   6.036 -16.464  1.00  0.00           C  
ATOM    703  CZ  PHE A  44     -96.676   5.109 -16.185  1.00  0.00           C  
ATOM    704  H   PHE A  44     -97.027   8.163 -20.882  1.00  0.00           H  
ATOM    705  HA  PHE A  44     -95.860   5.412 -20.810  1.00  0.00           H  
ATOM    706  HB2 PHE A  44     -98.555   6.657 -20.298  1.00  0.00           H  
ATOM    707  HB3 PHE A  44     -98.427   4.928 -20.626  1.00  0.00           H  
ATOM    708  HD1 PHE A  44     -95.990   4.087 -19.358  1.00  0.00           H  
ATOM    709  HD2 PHE A  44     -98.868   6.974 -18.003  1.00  0.00           H  
ATOM    710  HE1 PHE A  44     -95.283   3.693 -17.013  1.00  0.00           H  
ATOM    711  HE2 PHE A  44     -98.162   6.578 -15.659  1.00  0.00           H  
ATOM    712  HZ  PHE A  44     -96.368   4.938 -15.164  1.00  0.00           H  
ATOM    713  N   SER A  45     -97.537   6.806 -23.264  1.00  0.00           N  
ATOM    714  CA  SER A  45     -97.878   6.637 -24.706  1.00  0.00           C  
ATOM    715  C   SER A  45     -96.802   7.284 -25.585  1.00  0.00           C  
ATOM    716  O   SER A  45     -95.947   6.616 -26.129  1.00  0.00           O  
ATOM    717  CB  SER A  45     -99.215   7.353 -24.883  1.00  0.00           C  
ATOM    718  OG  SER A  45    -100.271   6.413 -24.740  1.00  0.00           O  
ATOM    719  H   SER A  45     -97.722   7.656 -22.812  1.00  0.00           H  
ATOM    720  HA  SER A  45     -97.984   5.592 -24.948  1.00  0.00           H  
ATOM    721  HB2 SER A  45     -99.317   8.119 -24.133  1.00  0.00           H  
ATOM    722  HB3 SER A  45     -99.252   7.807 -25.865  1.00  0.00           H  
ATOM    723  HG  SER A  45    -101.087   6.839 -25.015  1.00  0.00           H  
ATOM    724  N   ILE A  46     -96.841   8.581 -25.728  1.00  0.00           N  
ATOM    725  CA  ILE A  46     -95.819   9.268 -26.572  1.00  0.00           C  
ATOM    726  C   ILE A  46     -94.439   9.163 -25.914  1.00  0.00           C  
ATOM    727  O   ILE A  46     -94.323   8.870 -24.740  1.00  0.00           O  
ATOM    728  CB  ILE A  46     -96.275  10.727 -26.643  1.00  0.00           C  
ATOM    729  CG1 ILE A  46     -97.726  10.790 -27.126  1.00  0.00           C  
ATOM    730  CG2 ILE A  46     -95.384  11.490 -27.624  1.00  0.00           C  
ATOM    731  CD1 ILE A  46     -97.908   9.862 -28.328  1.00  0.00           C  
ATOM    732  H   ILE A  46     -97.538   9.102 -25.280  1.00  0.00           H  
ATOM    733  HA  ILE A  46     -95.799   8.839 -27.561  1.00  0.00           H  
ATOM    734  HB  ILE A  46     -96.198  11.176 -25.663  1.00  0.00           H  
ATOM    735 HG12 ILE A  46     -98.386  10.482 -26.327  1.00  0.00           H  
ATOM    736 HG13 ILE A  46     -97.965  11.802 -27.416  1.00  0.00           H  
ATOM    737 HG21 ILE A  46     -95.537  11.104 -28.622  1.00  0.00           H  
ATOM    738 HG22 ILE A  46     -94.349  11.364 -27.344  1.00  0.00           H  
ATOM    739 HG23 ILE A  46     -95.639  12.539 -27.601  1.00  0.00           H  
ATOM    740 HD11 ILE A  46     -98.893  10.006 -28.748  1.00  0.00           H  
ATOM    741 HD12 ILE A  46     -97.798   8.836 -28.010  1.00  0.00           H  
ATOM    742 HD13 ILE A  46     -97.161  10.090 -29.074  1.00  0.00           H  
ATOM    743  N   LYS A  47     -93.392   9.395 -26.659  1.00  0.00           N  
ATOM    744  CA  LYS A  47     -92.025   9.302 -26.068  1.00  0.00           C  
ATOM    745  C   LYS A  47     -91.158  10.479 -26.525  1.00  0.00           C  
ATOM    746  O   LYS A  47     -90.733  11.296 -25.732  1.00  0.00           O  
ATOM    747  CB  LYS A  47     -91.456   7.985 -26.595  1.00  0.00           C  
ATOM    748  CG  LYS A  47     -89.930   8.009 -26.492  1.00  0.00           C  
ATOM    749  CD  LYS A  47     -89.367   6.649 -26.909  1.00  0.00           C  
ATOM    750  CE  LYS A  47     -89.158   6.627 -28.426  1.00  0.00           C  
ATOM    751  NZ  LYS A  47     -89.430   5.220 -28.832  1.00  0.00           N  
ATOM    752  H   LYS A  47     -93.503   9.628 -27.604  1.00  0.00           H  
ATOM    753  HA  LYS A  47     -92.082   9.273 -24.991  1.00  0.00           H  
ATOM    754  HB2 LYS A  47     -91.844   7.164 -26.008  1.00  0.00           H  
ATOM    755  HB3 LYS A  47     -91.742   7.857 -27.628  1.00  0.00           H  
ATOM    756  HG2 LYS A  47     -89.536   8.777 -27.143  1.00  0.00           H  
ATOM    757  HG3 LYS A  47     -89.640   8.217 -25.473  1.00  0.00           H  
ATOM    758  HD2 LYS A  47     -88.422   6.482 -26.412  1.00  0.00           H  
ATOM    759  HD3 LYS A  47     -90.063   5.871 -26.633  1.00  0.00           H  
ATOM    760  HE2 LYS A  47     -89.849   7.302 -28.909  1.00  0.00           H  
ATOM    761  HE3 LYS A  47     -88.140   6.891 -28.669  1.00  0.00           H  
ATOM    762  HZ1 LYS A  47     -88.722   4.917 -29.530  1.00  0.00           H  
ATOM    763  HZ2 LYS A  47     -90.381   5.160 -29.253  1.00  0.00           H  
ATOM    764  HZ3 LYS A  47     -89.381   4.602 -27.999  1.00  0.00           H  
ATOM    765  N   ASP A  48     -90.890  10.570 -27.799  1.00  0.00           N  
ATOM    766  CA  ASP A  48     -90.045  11.688 -28.307  1.00  0.00           C  
ATOM    767  C   ASP A  48     -90.924  12.873 -28.709  1.00  0.00           C  
ATOM    768  O   ASP A  48     -92.135  12.785 -28.683  1.00  0.00           O  
ATOM    769  CB  ASP A  48     -89.324  11.117 -29.527  1.00  0.00           C  
ATOM    770  CG  ASP A  48     -87.855  10.866 -29.182  1.00  0.00           C  
ATOM    771  OD1 ASP A  48     -87.588   9.909 -28.474  1.00  0.00           O  
ATOM    772  OD2 ASP A  48     -87.022  11.637 -29.630  1.00  0.00           O  
ATOM    773  H   ASP A  48     -91.239   9.901 -28.423  1.00  0.00           H  
ATOM    774  HA  ASP A  48     -89.327  11.988 -27.561  1.00  0.00           H  
ATOM    775  HB2 ASP A  48     -89.790  10.186 -29.816  1.00  0.00           H  
ATOM    776  HB3 ASP A  48     -89.385  11.819 -30.344  1.00  0.00           H  
ATOM    777  N   PRO A  49     -90.278  13.947 -29.071  1.00  0.00           N  
ATOM    778  CA  PRO A  49     -91.008  15.167 -29.485  1.00  0.00           C  
ATOM    779  C   PRO A  49     -91.638  14.973 -30.866  1.00  0.00           C  
ATOM    780  O   PRO A  49     -91.069  14.347 -31.738  1.00  0.00           O  
ATOM    781  CB  PRO A  49     -89.921  16.237 -29.526  1.00  0.00           C  
ATOM    782  CG  PRO A  49     -88.645  15.487 -29.745  1.00  0.00           C  
ATOM    783  CD  PRO A  49     -88.823  14.124 -29.127  1.00  0.00           C  
ATOM    784  HA  PRO A  49     -91.757  15.427 -28.756  1.00  0.00           H  
ATOM    785  HB2 PRO A  49     -90.102  16.924 -30.342  1.00  0.00           H  
ATOM    786  HB3 PRO A  49     -89.879  16.769 -28.588  1.00  0.00           H  
ATOM    787  HG2 PRO A  49     -88.452  15.392 -30.805  1.00  0.00           H  
ATOM    788  HG3 PRO A  49     -87.827  16.001 -29.266  1.00  0.00           H  
ATOM    789  HD2 PRO A  49     -88.367  13.365 -29.748  1.00  0.00           H  
ATOM    790  HD3 PRO A  49     -88.407  14.102 -28.131  1.00  0.00           H  
ATOM    791  N   ALA A  50     -92.812  15.504 -31.068  1.00  0.00           N  
ATOM    792  CA  ALA A  50     -93.485  15.351 -32.389  1.00  0.00           C  
ATOM    793  C   ALA A  50     -92.528  15.731 -33.522  1.00  0.00           C  
ATOM    794  O   ALA A  50     -91.750  16.656 -33.408  1.00  0.00           O  
ATOM    795  CB  ALA A  50     -94.669  16.318 -32.344  1.00  0.00           C  
ATOM    796  H   ALA A  50     -93.253  16.004 -30.350  1.00  0.00           H  
ATOM    797  HA  ALA A  50     -93.840  14.341 -32.518  1.00  0.00           H  
ATOM    798  HB1 ALA A  50     -95.574  15.769 -32.130  1.00  0.00           H  
ATOM    799  HB2 ALA A  50     -94.766  16.814 -33.298  1.00  0.00           H  
ATOM    800  HB3 ALA A  50     -94.503  17.055 -31.571  1.00  0.00           H  
ATOM    801  N   ASP A  51     -92.586  15.024 -34.617  1.00  0.00           N  
ATOM    802  CA  ASP A  51     -91.687  15.342 -35.762  1.00  0.00           C  
ATOM    803  C   ASP A  51     -92.416  16.251 -36.755  1.00  0.00           C  
ATOM    804  O   ASP A  51     -93.606  16.468 -36.649  1.00  0.00           O  
ATOM    805  CB  ASP A  51     -91.371  13.991 -36.403  1.00  0.00           C  
ATOM    806  CG  ASP A  51     -89.906  13.632 -36.146  1.00  0.00           C  
ATOM    807  OD1 ASP A  51     -89.051  14.213 -36.794  1.00  0.00           O  
ATOM    808  OD2 ASP A  51     -89.664  12.782 -35.304  1.00  0.00           O  
ATOM    809  H   ASP A  51     -93.225  14.286 -34.687  1.00  0.00           H  
ATOM    810  HA  ASP A  51     -90.780  15.810 -35.415  1.00  0.00           H  
ATOM    811  HB2 ASP A  51     -92.008  13.232 -35.974  1.00  0.00           H  
ATOM    812  HB3 ASP A  51     -91.543  14.047 -37.468  1.00  0.00           H  
ATOM    813  N   VAL A  52     -91.717  16.788 -37.718  1.00  0.00           N  
ATOM    814  CA  VAL A  52     -92.387  17.683 -38.705  1.00  0.00           C  
ATOM    815  C   VAL A  52     -91.900  17.385 -40.124  1.00  0.00           C  
ATOM    816  O   VAL A  52     -90.861  17.854 -40.544  1.00  0.00           O  
ATOM    817  CB  VAL A  52     -91.989  19.101 -38.296  1.00  0.00           C  
ATOM    818  CG1 VAL A  52     -93.242  19.968 -38.172  1.00  0.00           C  
ATOM    819  CG2 VAL A  52     -91.262  19.061 -36.951  1.00  0.00           C  
ATOM    820  H   VAL A  52     -90.756  16.606 -37.790  1.00  0.00           H  
ATOM    821  HA  VAL A  52     -93.458  17.573 -38.645  1.00  0.00           H  
ATOM    822  HB  VAL A  52     -91.335  19.520 -39.047  1.00  0.00           H  
ATOM    823 HG11 VAL A  52     -93.801  19.925 -39.096  1.00  0.00           H  
ATOM    824 HG12 VAL A  52     -92.955  20.989 -37.972  1.00  0.00           H  
ATOM    825 HG13 VAL A  52     -93.855  19.601 -37.362  1.00  0.00           H  
ATOM    826 HG21 VAL A  52     -90.352  18.488 -37.051  1.00  0.00           H  
ATOM    827 HG22 VAL A  52     -91.899  18.599 -36.211  1.00  0.00           H  
ATOM    828 HG23 VAL A  52     -91.022  20.067 -36.642  1.00  0.00           H  
ATOM    829  N   TYR A  53     -92.648  16.620 -40.870  1.00  0.00           N  
ATOM    830  CA  TYR A  53     -92.231  16.308 -42.266  1.00  0.00           C  
ATOM    831  C   TYR A  53     -92.743  17.402 -43.205  1.00  0.00           C  
ATOM    832  O   TYR A  53     -93.795  17.282 -43.802  1.00  0.00           O  
ATOM    833  CB  TYR A  53     -92.889  14.967 -42.590  1.00  0.00           C  
ATOM    834  CG  TYR A  53     -92.250  13.876 -41.765  1.00  0.00           C  
ATOM    835  CD1 TYR A  53     -92.738  13.590 -40.484  1.00  0.00           C  
ATOM    836  CD2 TYR A  53     -91.171  13.149 -42.281  1.00  0.00           C  
ATOM    837  CE1 TYR A  53     -92.146  12.578 -39.720  1.00  0.00           C  
ATOM    838  CE2 TYR A  53     -90.580  12.135 -41.517  1.00  0.00           C  
ATOM    839  CZ  TYR A  53     -91.067  11.850 -40.236  1.00  0.00           C  
ATOM    840  OH  TYR A  53     -90.485  10.850 -39.483  1.00  0.00           O  
ATOM    841  H   TYR A  53     -93.488  16.259 -40.516  1.00  0.00           H  
ATOM    842  HA  TYR A  53     -91.159  16.222 -42.332  1.00  0.00           H  
ATOM    843  HB2 TYR A  53     -93.943  15.019 -42.362  1.00  0.00           H  
ATOM    844  HB3 TYR A  53     -92.758  14.746 -43.638  1.00  0.00           H  
ATOM    845  HD1 TYR A  53     -93.570  14.152 -40.085  1.00  0.00           H  
ATOM    846  HD2 TYR A  53     -90.795  13.370 -43.270  1.00  0.00           H  
ATOM    847  HE1 TYR A  53     -92.523  12.357 -38.732  1.00  0.00           H  
ATOM    848  HE2 TYR A  53     -89.747  11.575 -41.916  1.00  0.00           H  
ATOM    849  HH  TYR A  53     -90.588  10.023 -39.959  1.00  0.00           H  
ATOM    850  N   TYR A  54     -92.013  18.475 -43.330  1.00  0.00           N  
ATOM    851  CA  TYR A  54     -92.461  19.585 -44.220  1.00  0.00           C  
ATOM    852  C   TYR A  54     -92.422  19.148 -45.686  1.00  0.00           C  
ATOM    853  O   TYR A  54     -91.379  18.846 -46.229  1.00  0.00           O  
ATOM    854  CB  TYR A  54     -91.466  20.718 -43.965  1.00  0.00           C  
ATOM    855  CG  TYR A  54     -91.728  21.318 -42.604  1.00  0.00           C  
ATOM    856  CD1 TYR A  54     -93.034  21.654 -42.225  1.00  0.00           C  
ATOM    857  CD2 TYR A  54     -90.665  21.538 -41.720  1.00  0.00           C  
ATOM    858  CE1 TYR A  54     -93.276  22.209 -40.962  1.00  0.00           C  
ATOM    859  CE2 TYR A  54     -90.907  22.092 -40.457  1.00  0.00           C  
ATOM    860  CZ  TYR A  54     -92.213  22.429 -40.079  1.00  0.00           C  
ATOM    861  OH  TYR A  54     -92.451  22.975 -38.834  1.00  0.00           O  
ATOM    862  H   TYR A  54     -91.172  18.555 -42.833  1.00  0.00           H  
ATOM    863  HA  TYR A  54     -93.454  19.902 -43.949  1.00  0.00           H  
ATOM    864  HB2 TYR A  54     -90.458  20.326 -43.999  1.00  0.00           H  
ATOM    865  HB3 TYR A  54     -91.582  21.478 -44.722  1.00  0.00           H  
ATOM    866  HD1 TYR A  54     -93.854  21.486 -42.906  1.00  0.00           H  
ATOM    867  HD2 TYR A  54     -89.657  21.279 -42.012  1.00  0.00           H  
ATOM    868  HE1 TYR A  54     -94.284  22.467 -40.670  1.00  0.00           H  
ATOM    869  HE2 TYR A  54     -90.086  22.262 -39.776  1.00  0.00           H  
ATOM    870  HH  TYR A  54     -91.663  23.454 -38.564  1.00  0.00           H  
ATOM    871  N   THR A  55     -93.557  19.118 -46.332  1.00  0.00           N  
ATOM    872  CA  THR A  55     -93.592  18.704 -47.763  1.00  0.00           C  
ATOM    873  C   THR A  55     -93.725  19.938 -48.662  1.00  0.00           C  
ATOM    874  O   THR A  55     -93.516  21.054 -48.233  1.00  0.00           O  
ATOM    875  CB  THR A  55     -94.827  17.811 -47.888  1.00  0.00           C  
ATOM    876  OG1 THR A  55     -95.997  18.593 -47.695  1.00  0.00           O  
ATOM    877  CG2 THR A  55     -94.768  16.705 -46.832  1.00  0.00           C  
ATOM    878  H   THR A  55     -94.387  19.368 -45.874  1.00  0.00           H  
ATOM    879  HA  THR A  55     -92.705  18.146 -48.017  1.00  0.00           H  
ATOM    880  HB  THR A  55     -94.851  17.363 -48.870  1.00  0.00           H  
ATOM    881  HG1 THR A  55     -96.756  18.009 -47.749  1.00  0.00           H  
ATOM    882 HG21 THR A  55     -94.735  15.742 -47.320  1.00  0.00           H  
ATOM    883 HG22 THR A  55     -95.645  16.761 -46.204  1.00  0.00           H  
ATOM    884 HG23 THR A  55     -93.884  16.833 -46.227  1.00  0.00           H  
ATOM    885  N   LYS A  56     -94.070  19.744 -49.907  1.00  0.00           N  
ATOM    886  CA  LYS A  56     -94.214  20.908 -50.829  1.00  0.00           C  
ATOM    887  C   LYS A  56     -95.610  21.523 -50.695  1.00  0.00           C  
ATOM    888  O   LYS A  56     -95.813  22.688 -50.974  1.00  0.00           O  
ATOM    889  CB  LYS A  56     -94.015  20.329 -52.229  1.00  0.00           C  
ATOM    890  CG  LYS A  56     -94.062  21.461 -53.256  1.00  0.00           C  
ATOM    891  CD  LYS A  56     -94.933  21.041 -54.442  1.00  0.00           C  
ATOM    892  CE  LYS A  56     -96.394  20.951 -53.997  1.00  0.00           C  
ATOM    893  NZ  LYS A  56     -97.030  22.195 -54.514  1.00  0.00           N  
ATOM    894  H   LYS A  56     -94.233  18.837 -50.236  1.00  0.00           H  
ATOM    895  HA  LYS A  56     -93.455  21.645 -50.625  1.00  0.00           H  
ATOM    896  HB2 LYS A  56     -93.056  19.833 -52.281  1.00  0.00           H  
ATOM    897  HB3 LYS A  56     -94.801  19.619 -52.442  1.00  0.00           H  
ATOM    898  HG2 LYS A  56     -94.479  22.345 -52.796  1.00  0.00           H  
ATOM    899  HG3 LYS A  56     -93.063  21.673 -53.603  1.00  0.00           H  
ATOM    900  HD2 LYS A  56     -94.840  21.772 -55.233  1.00  0.00           H  
ATOM    901  HD3 LYS A  56     -94.610  20.076 -54.803  1.00  0.00           H  
ATOM    902  HE2 LYS A  56     -96.865  20.079 -54.428  1.00  0.00           H  
ATOM    903  HE3 LYS A  56     -96.459  20.923 -52.921  1.00  0.00           H  
ATOM    904  HZ1 LYS A  56     -98.065  22.104 -54.461  1.00  0.00           H  
ATOM    905  HZ2 LYS A  56     -96.745  22.344 -55.504  1.00  0.00           H  
ATOM    906  HZ3 LYS A  56     -96.727  23.006 -53.938  1.00  0.00           H  
ATOM    907  N   LYS A  57     -96.573  20.751 -50.269  1.00  0.00           N  
ATOM    908  CA  LYS A  57     -97.953  21.296 -50.120  1.00  0.00           C  
ATOM    909  C   LYS A  57     -98.138  21.899 -48.725  1.00  0.00           C  
ATOM    910  O   LYS A  57     -98.230  23.100 -48.565  1.00  0.00           O  
ATOM    911  CB  LYS A  57     -98.877  20.091 -50.309  1.00  0.00           C  
ATOM    912  CG  LYS A  57     -99.144  19.881 -51.800  1.00  0.00           C  
ATOM    913  CD  LYS A  57    -100.504  19.204 -51.984  1.00  0.00           C  
ATOM    914  CE  LYS A  57    -100.301  17.707 -52.234  1.00  0.00           C  
ATOM    915  NZ  LYS A  57    -101.153  17.029 -51.217  1.00  0.00           N  
ATOM    916  H   LYS A  57     -96.388  19.814 -50.051  1.00  0.00           H  
ATOM    917  HA  LYS A  57     -98.152  22.034 -50.880  1.00  0.00           H  
ATOM    918  HB2 LYS A  57     -98.405  19.209 -49.899  1.00  0.00           H  
ATOM    919  HB3 LYS A  57     -99.811  20.271 -49.799  1.00  0.00           H  
ATOM    920  HG2 LYS A  57     -99.145  20.837 -52.304  1.00  0.00           H  
ATOM    921  HG3 LYS A  57     -98.373  19.253 -52.220  1.00  0.00           H  
ATOM    922  HD2 LYS A  57    -101.100  19.345 -51.094  1.00  0.00           H  
ATOM    923  HD3 LYS A  57    -101.013  19.642 -52.831  1.00  0.00           H  
ATOM    924  HE2 LYS A  57    -100.622  17.447 -53.232  1.00  0.00           H  
ATOM    925  HE3 LYS A  57     -99.266  17.438 -52.088  1.00  0.00           H  
ATOM    926  HZ1 LYS A  57    -102.075  17.505 -51.163  1.00  0.00           H  
ATOM    927  HZ2 LYS A  57    -100.685  17.071 -50.289  1.00  0.00           H  
ATOM    928  HZ3 LYS A  57    -101.293  16.036 -51.489  1.00  0.00           H  
ATOM    929  N   LYS A  58     -98.191  21.074 -47.714  1.00  0.00           N  
ATOM    930  CA  LYS A  58     -98.370  21.601 -46.330  1.00  0.00           C  
ATOM    931  C   LYS A  58     -97.444  20.860 -45.361  1.00  0.00           C  
ATOM    932  O   LYS A  58     -96.918  19.809 -45.673  1.00  0.00           O  
ATOM    933  CB  LYS A  58     -99.835  21.325 -45.987  1.00  0.00           C  
ATOM    934  CG  LYS A  58    -100.272  22.238 -44.840  1.00  0.00           C  
ATOM    935  CD  LYS A  58    -100.132  23.700 -45.267  1.00  0.00           C  
ATOM    936  CE  LYS A  58     -99.065  24.384 -44.409  1.00  0.00           C  
ATOM    937  NZ  LYS A  58     -99.262  25.842 -44.638  1.00  0.00           N  
ATOM    938  H   LYS A  58     -98.115  20.110 -47.865  1.00  0.00           H  
ATOM    939  HA  LYS A  58     -98.177  22.662 -46.301  1.00  0.00           H  
ATOM    940  HB2 LYS A  58    -100.449  21.516 -46.855  1.00  0.00           H  
ATOM    941  HB3 LYS A  58     -99.945  20.294 -45.685  1.00  0.00           H  
ATOM    942  HG2 LYS A  58    -101.303  22.032 -44.589  1.00  0.00           H  
ATOM    943  HG3 LYS A  58     -99.648  22.056 -43.977  1.00  0.00           H  
ATOM    944  HD2 LYS A  58     -99.842  23.745 -46.307  1.00  0.00           H  
ATOM    945  HD3 LYS A  58    -101.076  24.207 -45.134  1.00  0.00           H  
ATOM    946  HE2 LYS A  58     -99.212  24.141 -43.365  1.00  0.00           H  
ATOM    947  HE3 LYS A  58     -98.078  24.089 -44.729  1.00  0.00           H  
ATOM    948  HZ1 LYS A  58     -98.342  26.324 -44.613  1.00  0.00           H  
ATOM    949  HZ2 LYS A  58     -99.878  26.229 -43.894  1.00  0.00           H  
ATOM    950  HZ3 LYS A  58     -99.703  25.990 -45.567  1.00  0.00           H  
ATOM    951  N   ALA A  59     -97.242  21.396 -44.188  1.00  0.00           N  
ATOM    952  CA  ALA A  59     -96.351  20.716 -43.204  1.00  0.00           C  
ATOM    953  C   ALA A  59     -97.006  19.423 -42.711  1.00  0.00           C  
ATOM    954  O   ALA A  59     -98.212  19.279 -42.738  1.00  0.00           O  
ATOM    955  CB  ALA A  59     -96.197  21.713 -42.055  1.00  0.00           C  
ATOM    956  H   ALA A  59     -97.677  22.242 -43.955  1.00  0.00           H  
ATOM    957  HA  ALA A  59     -95.390  20.510 -43.645  1.00  0.00           H  
ATOM    958  HB1 ALA A  59     -97.172  22.050 -41.736  1.00  0.00           H  
ATOM    959  HB2 ALA A  59     -95.615  22.560 -42.389  1.00  0.00           H  
ATOM    960  HB3 ALA A  59     -95.693  21.234 -41.228  1.00  0.00           H  
ATOM    961  N   GLU A  60     -96.223  18.479 -42.265  1.00  0.00           N  
ATOM    962  CA  GLU A  60     -96.808  17.198 -41.776  1.00  0.00           C  
ATOM    963  C   GLU A  60     -96.191  16.806 -40.431  1.00  0.00           C  
ATOM    964  O   GLU A  60     -95.113  16.250 -40.371  1.00  0.00           O  
ATOM    965  CB  GLU A  60     -96.457  16.167 -42.848  1.00  0.00           C  
ATOM    966  CG  GLU A  60     -97.742  15.548 -43.401  1.00  0.00           C  
ATOM    967  CD  GLU A  60     -97.530  15.145 -44.861  1.00  0.00           C  
ATOM    968  OE1 GLU A  60     -96.615  14.381 -45.117  1.00  0.00           O  
ATOM    969  OE2 GLU A  60     -98.286  15.608 -45.699  1.00  0.00           O  
ATOM    970  H   GLU A  60     -95.251  18.612 -42.252  1.00  0.00           H  
ATOM    971  HA  GLU A  60     -97.879  17.284 -41.687  1.00  0.00           H  
ATOM    972  HB2 GLU A  60     -95.914  16.650 -43.648  1.00  0.00           H  
ATOM    973  HB3 GLU A  60     -95.844  15.391 -42.414  1.00  0.00           H  
ATOM    974  HG2 GLU A  60     -98.000  14.674 -42.819  1.00  0.00           H  
ATOM    975  HG3 GLU A  60     -98.543  16.269 -43.341  1.00  0.00           H  
ATOM    976  N   VAL A  61     -96.870  17.087 -39.353  1.00  0.00           N  
ATOM    977  CA  VAL A  61     -96.326  16.726 -38.013  1.00  0.00           C  
ATOM    978  C   VAL A  61     -96.435  15.214 -37.793  1.00  0.00           C  
ATOM    979  O   VAL A  61     -97.180  14.533 -38.469  1.00  0.00           O  
ATOM    980  CB  VAL A  61     -97.204  17.476 -37.013  1.00  0.00           C  
ATOM    981  CG1 VAL A  61     -96.796  17.095 -35.589  1.00  0.00           C  
ATOM    982  CG2 VAL A  61     -97.024  18.984 -37.208  1.00  0.00           C  
ATOM    983  H   VAL A  61     -97.739  17.533 -39.424  1.00  0.00           H  
ATOM    984  HA  VAL A  61     -95.300  17.048 -37.920  1.00  0.00           H  
ATOM    985  HB  VAL A  61     -98.239  17.211 -37.173  1.00  0.00           H  
ATOM    986 HG11 VAL A  61     -97.171  17.833 -34.897  1.00  0.00           H  
ATOM    987 HG12 VAL A  61     -95.718  17.054 -35.521  1.00  0.00           H  
ATOM    988 HG13 VAL A  61     -97.208  16.128 -35.343  1.00  0.00           H  
ATOM    989 HG21 VAL A  61     -97.825  19.509 -36.710  1.00  0.00           H  
ATOM    990 HG22 VAL A  61     -97.043  19.215 -38.262  1.00  0.00           H  
ATOM    991 HG23 VAL A  61     -96.077  19.290 -36.789  1.00  0.00           H  
ATOM    992  N   GLU A  62     -95.698  14.684 -36.855  1.00  0.00           N  
ATOM    993  CA  GLU A  62     -95.766  13.218 -36.599  1.00  0.00           C  
ATOM    994  C   GLU A  62     -95.581  12.927 -35.107  1.00  0.00           C  
ATOM    995  O   GLU A  62     -94.831  13.593 -34.422  1.00  0.00           O  
ATOM    996  CB  GLU A  62     -94.612  12.623 -37.408  1.00  0.00           C  
ATOM    997  CG  GLU A  62     -94.697  11.096 -37.374  1.00  0.00           C  
ATOM    998  CD  GLU A  62     -93.667  10.551 -36.384  1.00  0.00           C  
ATOM    999  OE1 GLU A  62     -93.565  11.102 -35.300  1.00  0.00           O  
ATOM   1000  OE2 GLU A  62     -92.996   9.590 -36.727  1.00  0.00           O  
ATOM   1001  H   GLU A  62     -95.102  15.249 -36.320  1.00  0.00           H  
ATOM   1002  HA  GLU A  62     -96.704  12.816 -36.948  1.00  0.00           H  
ATOM   1003  HB2 GLU A  62     -94.676  12.965 -38.431  1.00  0.00           H  
ATOM   1004  HB3 GLU A  62     -93.672  12.938 -36.981  1.00  0.00           H  
ATOM   1005  HG2 GLU A  62     -95.689  10.798 -37.063  1.00  0.00           H  
ATOM   1006  HG3 GLU A  62     -94.494  10.702 -38.357  1.00  0.00           H  
ATOM   1007  N   LEU A  63     -96.259  11.933 -34.602  1.00  0.00           N  
ATOM   1008  CA  LEU A  63     -96.123  11.592 -33.157  1.00  0.00           C  
ATOM   1009  C   LEU A  63     -96.122  10.072 -32.975  1.00  0.00           C  
ATOM   1010  O   LEU A  63     -97.017   9.382 -33.426  1.00  0.00           O  
ATOM   1011  CB  LEU A  63     -97.348  12.215 -32.484  1.00  0.00           C  
ATOM   1012  CG  LEU A  63     -97.036  13.659 -32.091  1.00  0.00           C  
ATOM   1013  CD1 LEU A  63     -97.857  14.613 -32.960  1.00  0.00           C  
ATOM   1014  CD2 LEU A  63     -97.396  13.877 -30.619  1.00  0.00           C  
ATOM   1015  H   LEU A  63     -96.856  11.407 -35.174  1.00  0.00           H  
ATOM   1016  HA  LEU A  63     -95.221  12.021 -32.750  1.00  0.00           H  
ATOM   1017  HB2 LEU A  63     -98.182  12.199 -33.171  1.00  0.00           H  
ATOM   1018  HB3 LEU A  63     -97.599  11.649 -31.599  1.00  0.00           H  
ATOM   1019  HG  LEU A  63     -95.983  13.853 -32.239  1.00  0.00           H  
ATOM   1020 HD11 LEU A  63     -98.893  14.308 -32.949  1.00  0.00           H  
ATOM   1021 HD12 LEU A  63     -97.485  14.586 -33.974  1.00  0.00           H  
ATOM   1022 HD13 LEU A  63     -97.773  15.617 -32.572  1.00  0.00           H  
ATOM   1023 HD21 LEU A  63     -96.674  13.370 -29.994  1.00  0.00           H  
ATOM   1024 HD22 LEU A  63     -98.382  13.479 -30.426  1.00  0.00           H  
ATOM   1025 HD23 LEU A  63     -97.383  14.933 -30.398  1.00  0.00           H  
ATOM   1026  N   ASP A  64     -95.123   9.542 -32.325  1.00  0.00           N  
ATOM   1027  CA  ASP A  64     -95.062   8.066 -32.123  1.00  0.00           C  
ATOM   1028  C   ASP A  64     -95.869   7.659 -30.886  1.00  0.00           C  
ATOM   1029  O   ASP A  64     -95.808   8.297 -29.854  1.00  0.00           O  
ATOM   1030  CB  ASP A  64     -93.578   7.756 -31.920  1.00  0.00           C  
ATOM   1031  CG  ASP A  64     -93.413   6.298 -31.492  1.00  0.00           C  
ATOM   1032  OD1 ASP A  64     -94.047   5.448 -32.096  1.00  0.00           O  
ATOM   1033  OD2 ASP A  64     -92.656   6.054 -30.566  1.00  0.00           O  
ATOM   1034  H   ASP A  64     -94.410  10.115 -31.973  1.00  0.00           H  
ATOM   1035  HA  ASP A  64     -95.427   7.551 -32.997  1.00  0.00           H  
ATOM   1036  HB2 ASP A  64     -93.046   7.923 -32.846  1.00  0.00           H  
ATOM   1037  HB3 ASP A  64     -93.177   8.402 -31.152  1.00  0.00           H  
ATOM   1038  N   ILE A  65     -96.622   6.597 -30.983  1.00  0.00           N  
ATOM   1039  CA  ILE A  65     -97.431   6.144 -29.815  1.00  0.00           C  
ATOM   1040  C   ILE A  65     -96.918   4.788 -29.318  1.00  0.00           C  
ATOM   1041  O   ILE A  65     -97.143   3.765 -29.934  1.00  0.00           O  
ATOM   1042  CB  ILE A  65     -98.859   6.017 -30.347  1.00  0.00           C  
ATOM   1043  CG1 ILE A  65     -99.482   7.410 -30.465  1.00  0.00           C  
ATOM   1044  CG2 ILE A  65     -99.691   5.167 -29.386  1.00  0.00           C  
ATOM   1045  CD1 ILE A  65     -99.123   8.018 -31.822  1.00  0.00           C  
ATOM   1046  H   ILE A  65     -96.654   6.095 -31.825  1.00  0.00           H  
ATOM   1047  HA  ILE A  65     -97.394   6.876 -29.023  1.00  0.00           H  
ATOM   1048  HB  ILE A  65     -98.840   5.547 -31.320  1.00  0.00           H  
ATOM   1049 HG12 ILE A  65    -100.556   7.332 -30.377  1.00  0.00           H  
ATOM   1050 HG13 ILE A  65     -99.102   8.043 -29.677  1.00  0.00           H  
ATOM   1051 HG21 ILE A  65    -100.713   5.129 -29.733  1.00  0.00           H  
ATOM   1052 HG22 ILE A  65     -99.662   5.606 -28.400  1.00  0.00           H  
ATOM   1053 HG23 ILE A  65     -99.286   4.167 -29.348  1.00  0.00           H  
ATOM   1054 HD11 ILE A  65     -98.548   8.920 -31.671  1.00  0.00           H  
ATOM   1055 HD12 ILE A  65    -100.028   8.254 -32.361  1.00  0.00           H  
ATOM   1056 HD13 ILE A  65     -98.540   7.309 -32.390  1.00  0.00           H  
ATOM   1057  N   ASN A  66     -96.225   4.774 -28.212  1.00  0.00           N  
ATOM   1058  CA  ASN A  66     -95.688   3.487 -27.678  1.00  0.00           C  
ATOM   1059  C   ASN A  66     -96.826   2.499 -27.396  1.00  0.00           C  
ATOM   1060  O   ASN A  66     -96.802   1.370 -27.844  1.00  0.00           O  
ATOM   1061  CB  ASN A  66     -94.976   3.867 -26.379  1.00  0.00           C  
ATOM   1062  CG  ASN A  66     -93.775   2.945 -26.165  1.00  0.00           C  
ATOM   1063  OD1 ASN A  66     -93.675   1.904 -26.785  1.00  0.00           O  
ATOM   1064  ND2 ASN A  66     -92.852   3.284 -25.307  1.00  0.00           N  
ATOM   1065  H   ASN A  66     -96.051   5.613 -27.734  1.00  0.00           H  
ATOM   1066  HA  ASN A  66     -94.982   3.059 -28.371  1.00  0.00           H  
ATOM   1067  HB2 ASN A  66     -94.638   4.892 -26.441  1.00  0.00           H  
ATOM   1068  HB3 ASN A  66     -95.660   3.763 -25.550  1.00  0.00           H  
ATOM   1069 HD21 ASN A  66     -92.932   4.122 -24.806  1.00  0.00           H  
ATOM   1070 HD22 ASN A  66     -92.078   2.700 -25.164  1.00  0.00           H  
ATOM   1071  N   THR A  67     -97.816   2.910 -26.652  1.00  0.00           N  
ATOM   1072  CA  THR A  67     -98.946   1.986 -26.340  1.00  0.00           C  
ATOM   1073  C   THR A  67    -100.011   2.052 -27.437  1.00  0.00           C  
ATOM   1074  O   THR A  67    -101.175   2.271 -27.170  1.00  0.00           O  
ATOM   1075  CB  THR A  67     -99.511   2.489 -25.012  1.00  0.00           C  
ATOM   1076  OG1 THR A  67     -99.740   3.889 -25.096  1.00  0.00           O  
ATOM   1077  CG2 THR A  67     -98.515   2.201 -23.888  1.00  0.00           C  
ATOM   1078  H   THR A  67     -97.816   3.823 -26.295  1.00  0.00           H  
ATOM   1079  HA  THR A  67     -98.585   0.976 -26.226  1.00  0.00           H  
ATOM   1080  HB  THR A  67    -100.441   1.984 -24.802  1.00  0.00           H  
ATOM   1081  HG1 THR A  67    -100.028   4.196 -24.234  1.00  0.00           H  
ATOM   1082 HG21 THR A  67     -97.705   2.912 -23.934  1.00  0.00           H  
ATOM   1083 HG22 THR A  67     -98.123   1.201 -24.004  1.00  0.00           H  
ATOM   1084 HG23 THR A  67     -99.015   2.283 -22.934  1.00  0.00           H  
ATOM   1085  N   ALA A  68     -99.625   1.863 -28.669  1.00  0.00           N  
ATOM   1086  CA  ALA A  68    -100.620   1.916 -29.779  1.00  0.00           C  
ATOM   1087  C   ALA A  68    -101.762   0.928 -29.518  1.00  0.00           C  
ATOM   1088  O   ALA A  68    -102.874   1.117 -29.970  1.00  0.00           O  
ATOM   1089  CB  ALA A  68     -99.839   1.512 -31.029  1.00  0.00           C  
ATOM   1090  H   ALA A  68     -98.681   1.686 -28.864  1.00  0.00           H  
ATOM   1091  HA  ALA A  68    -101.005   2.917 -29.892  1.00  0.00           H  
ATOM   1092  HB1 ALA A  68     -99.080   2.252 -31.234  1.00  0.00           H  
ATOM   1093  HB2 ALA A  68    -100.514   1.446 -31.869  1.00  0.00           H  
ATOM   1094  HB3 ALA A  68     -99.371   0.552 -30.866  1.00  0.00           H  
ATOM   1095  N   SER A  69    -101.494  -0.125 -28.795  1.00  0.00           N  
ATOM   1096  CA  SER A  69    -102.563  -1.127 -28.510  1.00  0.00           C  
ATOM   1097  C   SER A  69    -103.603  -0.554 -27.538  1.00  0.00           C  
ATOM   1098  O   SER A  69    -104.643  -1.142 -27.317  1.00  0.00           O  
ATOM   1099  CB  SER A  69    -101.835  -2.309 -27.874  1.00  0.00           C  
ATOM   1100  OG  SER A  69    -102.602  -2.801 -26.783  1.00  0.00           O  
ATOM   1101  H   SER A  69    -100.591  -0.259 -28.441  1.00  0.00           H  
ATOM   1102  HA  SER A  69    -103.038  -1.441 -29.426  1.00  0.00           H  
ATOM   1103  HB2 SER A  69    -101.710  -3.093 -28.602  1.00  0.00           H  
ATOM   1104  HB3 SER A  69    -100.862  -1.985 -27.526  1.00  0.00           H  
ATOM   1105  HG  SER A  69    -103.213  -3.458 -27.123  1.00  0.00           H  
ATOM   1106  N   THR A  70    -103.337   0.583 -26.953  1.00  0.00           N  
ATOM   1107  CA  THR A  70    -104.318   1.174 -25.997  1.00  0.00           C  
ATOM   1108  C   THR A  70    -105.139   2.276 -26.675  1.00  0.00           C  
ATOM   1109  O   THR A  70    -106.161   2.696 -26.170  1.00  0.00           O  
ATOM   1110  CB  THR A  70    -103.469   1.758 -24.866  1.00  0.00           C  
ATOM   1111  OG1 THR A  70    -102.689   2.833 -25.370  1.00  0.00           O  
ATOM   1112  CG2 THR A  70    -102.548   0.676 -24.302  1.00  0.00           C  
ATOM   1113  H   THR A  70    -102.493   1.047 -27.137  1.00  0.00           H  
ATOM   1114  HA  THR A  70    -104.969   0.408 -25.606  1.00  0.00           H  
ATOM   1115  HB  THR A  70    -104.115   2.119 -24.081  1.00  0.00           H  
ATOM   1116  HG1 THR A  70    -103.096   3.654 -25.085  1.00  0.00           H  
ATOM   1117 HG21 THR A  70    -103.143  -0.148 -23.937  1.00  0.00           H  
ATOM   1118 HG22 THR A  70    -101.966   1.087 -23.490  1.00  0.00           H  
ATOM   1119 HG23 THR A  70    -101.885   0.325 -25.079  1.00  0.00           H  
ATOM   1120  N   TRP A  71    -104.703   2.753 -27.809  1.00  0.00           N  
ATOM   1121  CA  TRP A  71    -105.466   3.831 -28.505  1.00  0.00           C  
ATOM   1122  C   TRP A  71    -106.700   3.250 -29.202  1.00  0.00           C  
ATOM   1123  O   TRP A  71    -106.652   2.187 -29.789  1.00  0.00           O  
ATOM   1124  CB  TRP A  71    -104.493   4.405 -29.535  1.00  0.00           C  
ATOM   1125  CG  TRP A  71    -103.580   5.386 -28.869  1.00  0.00           C  
ATOM   1126  CD1 TRP A  71    -102.542   5.057 -28.067  1.00  0.00           C  
ATOM   1127  CD2 TRP A  71    -103.603   6.841 -28.933  1.00  0.00           C  
ATOM   1128  NE1 TRP A  71    -101.926   6.217 -27.635  1.00  0.00           N  
ATOM   1129  CE2 TRP A  71    -102.542   7.343 -28.142  1.00  0.00           C  
ATOM   1130  CE3 TRP A  71    -104.432   7.765 -29.594  1.00  0.00           C  
ATOM   1131  CZ2 TRP A  71    -102.314   8.713 -28.011  1.00  0.00           C  
ATOM   1132  CZ3 TRP A  71    -104.204   9.145 -29.464  1.00  0.00           C  
ATOM   1133  CH2 TRP A  71    -103.147   9.618 -28.674  1.00  0.00           C  
ATOM   1134  H   TRP A  71    -103.876   2.406 -28.203  1.00  0.00           H  
ATOM   1135  HA  TRP A  71    -105.755   4.599 -27.805  1.00  0.00           H  
ATOM   1136  HB2 TRP A  71    -103.909   3.604 -29.964  1.00  0.00           H  
ATOM   1137  HB3 TRP A  71    -105.048   4.905 -30.315  1.00  0.00           H  
ATOM   1138  HD1 TRP A  71    -102.243   4.054 -27.806  1.00  0.00           H  
ATOM   1139  HE1 TRP A  71    -101.145   6.257 -27.043  1.00  0.00           H  
ATOM   1140  HE3 TRP A  71    -105.249   7.411 -30.206  1.00  0.00           H  
ATOM   1141  HZ2 TRP A  71    -101.498   9.072 -27.401  1.00  0.00           H  
ATOM   1142  HZ3 TRP A  71    -104.846   9.846 -29.976  1.00  0.00           H  
ATOM   1143  HH2 TRP A  71    -102.977  10.680 -28.578  1.00  0.00           H  
ATOM   1144  N   LYS A  72    -107.805   3.943 -29.144  1.00  0.00           N  
ATOM   1145  CA  LYS A  72    -109.042   3.438 -29.808  1.00  0.00           C  
ATOM   1146  C   LYS A  72    -109.509   4.438 -30.867  1.00  0.00           C  
ATOM   1147  O   LYS A  72    -109.795   4.079 -31.993  1.00  0.00           O  
ATOM   1148  CB  LYS A  72    -110.076   3.319 -28.686  1.00  0.00           C  
ATOM   1149  CG  LYS A  72    -111.164   2.325 -29.099  1.00  0.00           C  
ATOM   1150  CD  LYS A  72    -112.505   3.052 -29.220  1.00  0.00           C  
ATOM   1151  CE  LYS A  72    -113.151   2.708 -30.564  1.00  0.00           C  
ATOM   1152  NZ  LYS A  72    -114.458   2.084 -30.215  1.00  0.00           N  
ATOM   1153  H   LYS A  72    -107.821   4.800 -28.668  1.00  0.00           H  
ATOM   1154  HA  LYS A  72    -108.864   2.471 -30.251  1.00  0.00           H  
ATOM   1155  HB2 LYS A  72    -109.591   2.970 -27.786  1.00  0.00           H  
ATOM   1156  HB3 LYS A  72    -110.522   4.284 -28.505  1.00  0.00           H  
ATOM   1157  HG2 LYS A  72    -110.905   1.883 -30.051  1.00  0.00           H  
ATOM   1158  HG3 LYS A  72    -111.244   1.549 -28.353  1.00  0.00           H  
ATOM   1159  HD2 LYS A  72    -113.156   2.743 -28.416  1.00  0.00           H  
ATOM   1160  HD3 LYS A  72    -112.343   4.118 -29.164  1.00  0.00           H  
ATOM   1161  HE2 LYS A  72    -113.304   3.606 -31.147  1.00  0.00           H  
ATOM   1162  HE3 LYS A  72    -112.539   2.004 -31.107  1.00  0.00           H  
ATOM   1163  HZ1 LYS A  72    -114.903   2.620 -29.443  1.00  0.00           H  
ATOM   1164  HZ2 LYS A  72    -114.301   1.101 -29.910  1.00  0.00           H  
ATOM   1165  HZ3 LYS A  72    -115.081   2.095 -31.046  1.00  0.00           H  
ATOM   1166  N   LYS A  73    -109.583   5.693 -30.516  1.00  0.00           N  
ATOM   1167  CA  LYS A  73    -110.026   6.722 -31.502  1.00  0.00           C  
ATOM   1168  C   LYS A  73    -109.067   7.916 -31.480  1.00  0.00           C  
ATOM   1169  O   LYS A  73    -108.100   7.931 -30.744  1.00  0.00           O  
ATOM   1170  CB  LYS A  73    -111.420   7.145 -31.040  1.00  0.00           C  
ATOM   1171  CG  LYS A  73    -112.281   7.484 -32.259  1.00  0.00           C  
ATOM   1172  CD  LYS A  73    -113.534   6.606 -32.259  1.00  0.00           C  
ATOM   1173  CE  LYS A  73    -114.767   7.473 -32.527  1.00  0.00           C  
ATOM   1174  NZ  LYS A  73    -115.923   6.545 -32.388  1.00  0.00           N  
ATOM   1175  H   LYS A  73    -109.344   5.961 -29.604  1.00  0.00           H  
ATOM   1176  HA  LYS A  73    -110.077   6.297 -32.492  1.00  0.00           H  
ATOM   1177  HB2 LYS A  73    -111.877   6.336 -30.489  1.00  0.00           H  
ATOM   1178  HB3 LYS A  73    -111.341   8.015 -30.406  1.00  0.00           H  
ATOM   1179  HG2 LYS A  73    -112.568   8.525 -32.220  1.00  0.00           H  
ATOM   1180  HG3 LYS A  73    -111.715   7.300 -33.161  1.00  0.00           H  
ATOM   1181  HD2 LYS A  73    -113.447   5.854 -33.029  1.00  0.00           H  
ATOM   1182  HD3 LYS A  73    -113.637   6.127 -31.297  1.00  0.00           H  
ATOM   1183  HE2 LYS A  73    -114.830   8.271 -31.800  1.00  0.00           H  
ATOM   1184  HE3 LYS A  73    -114.734   7.875 -33.528  1.00  0.00           H  
ATOM   1185  HZ1 LYS A  73    -115.925   6.135 -31.433  1.00  0.00           H  
ATOM   1186  HZ2 LYS A  73    -115.841   5.782 -33.093  1.00  0.00           H  
ATOM   1187  HZ3 LYS A  73    -116.808   7.067 -32.542  1.00  0.00           H  
ATOM   1188  N   PHE A  74    -109.328   8.917 -32.276  1.00  0.00           N  
ATOM   1189  CA  PHE A  74    -108.429  10.107 -32.293  1.00  0.00           C  
ATOM   1190  C   PHE A  74    -108.989  11.186 -33.224  1.00  0.00           C  
ATOM   1191  O   PHE A  74    -109.143  10.975 -34.410  1.00  0.00           O  
ATOM   1192  CB  PHE A  74    -107.092   9.591 -32.830  1.00  0.00           C  
ATOM   1193  CG  PHE A  74    -105.967  10.519 -32.417  1.00  0.00           C  
ATOM   1194  CD1 PHE A  74    -106.241  11.762 -31.822  1.00  0.00           C  
ATOM   1195  CD2 PHE A  74    -104.637  10.130 -32.632  1.00  0.00           C  
ATOM   1196  CE1 PHE A  74    -105.188  12.605 -31.446  1.00  0.00           C  
ATOM   1197  CE2 PHE A  74    -103.588  10.975 -32.257  1.00  0.00           C  
ATOM   1198  CZ  PHE A  74    -103.863  12.213 -31.663  1.00  0.00           C  
ATOM   1199  H   PHE A  74    -110.114   8.889 -32.860  1.00  0.00           H  
ATOM   1200  HA  PHE A  74    -108.299  10.494 -31.297  1.00  0.00           H  
ATOM   1201  HB2 PHE A  74    -106.905   8.604 -32.435  1.00  0.00           H  
ATOM   1202  HB3 PHE A  74    -107.137   9.541 -33.908  1.00  0.00           H  
ATOM   1203  HD1 PHE A  74    -107.261  12.073 -31.651  1.00  0.00           H  
ATOM   1204  HD2 PHE A  74    -104.423   9.176 -33.091  1.00  0.00           H  
ATOM   1205  HE1 PHE A  74    -105.399  13.561 -30.988  1.00  0.00           H  
ATOM   1206  HE2 PHE A  74    -102.565  10.673 -32.423  1.00  0.00           H  
ATOM   1207  HZ  PHE A  74    -103.052  12.864 -31.373  1.00  0.00           H  
ATOM   1208  N   GLU A  75    -109.289  12.344 -32.700  1.00  0.00           N  
ATOM   1209  CA  GLU A  75    -109.829  13.433 -33.563  1.00  0.00           C  
ATOM   1210  C   GLU A  75    -109.233  14.780 -33.145  1.00  0.00           C  
ATOM   1211  O   GLU A  75    -109.846  15.544 -32.427  1.00  0.00           O  
ATOM   1212  CB  GLU A  75    -111.340  13.420 -33.330  1.00  0.00           C  
ATOM   1213  CG  GLU A  75    -111.813  11.985 -33.088  1.00  0.00           C  
ATOM   1214  CD  GLU A  75    -113.342  11.948 -33.073  1.00  0.00           C  
ATOM   1215  OE1 GLU A  75    -113.940  12.689 -33.836  1.00  0.00           O  
ATOM   1216  OE2 GLU A  75    -113.890  11.178 -32.300  1.00  0.00           O  
ATOM   1217  H   GLU A  75    -109.153  12.498 -31.741  1.00  0.00           H  
ATOM   1218  HA  GLU A  75    -109.614  13.231 -34.601  1.00  0.00           H  
ATOM   1219  HB2 GLU A  75    -111.576  14.026 -32.467  1.00  0.00           H  
ATOM   1220  HB3 GLU A  75    -111.841  13.820 -34.198  1.00  0.00           H  
ATOM   1221  HG2 GLU A  75    -111.443  11.347 -33.878  1.00  0.00           H  
ATOM   1222  HG3 GLU A  75    -111.437  11.637 -32.137  1.00  0.00           H  
ATOM   1223  N   VAL A  76    -108.043  15.080 -33.593  1.00  0.00           N  
ATOM   1224  CA  VAL A  76    -107.412  16.380 -33.223  1.00  0.00           C  
ATOM   1225  C   VAL A  76    -108.167  17.536 -33.884  1.00  0.00           C  
ATOM   1226  O   VAL A  76    -108.617  17.430 -35.008  1.00  0.00           O  
ATOM   1227  CB  VAL A  76    -105.983  16.294 -33.759  1.00  0.00           C  
ATOM   1228  CG1 VAL A  76    -105.226  17.577 -33.410  1.00  0.00           C  
ATOM   1229  CG2 VAL A  76    -105.274  15.095 -33.125  1.00  0.00           C  
ATOM   1230  H   VAL A  76    -107.566  14.452 -34.174  1.00  0.00           H  
ATOM   1231  HA  VAL A  76    -107.397  16.502 -32.150  1.00  0.00           H  
ATOM   1232  HB  VAL A  76    -106.009  16.172 -34.832  1.00  0.00           H  
ATOM   1233 HG11 VAL A  76    -105.306  18.277 -34.228  1.00  0.00           H  
ATOM   1234 HG12 VAL A  76    -104.185  17.345 -33.236  1.00  0.00           H  
ATOM   1235 HG13 VAL A  76    -105.650  18.014 -32.519  1.00  0.00           H  
ATOM   1236 HG21 VAL A  76    -104.395  14.850 -33.702  1.00  0.00           H  
ATOM   1237 HG22 VAL A  76    -105.943  14.248 -33.110  1.00  0.00           H  
ATOM   1238 HG23 VAL A  76    -104.982  15.343 -32.114  1.00  0.00           H  
ATOM   1239  N   TYR A  77    -108.315  18.635 -33.198  1.00  0.00           N  
ATOM   1240  CA  TYR A  77    -109.045  19.789 -33.795  1.00  0.00           C  
ATOM   1241  C   TYR A  77    -108.471  21.111 -33.283  1.00  0.00           C  
ATOM   1242  O   TYR A  77    -108.266  21.295 -32.100  1.00  0.00           O  
ATOM   1243  CB  TYR A  77    -110.494  19.619 -33.335  1.00  0.00           C  
ATOM   1244  CG  TYR A  77    -110.897  20.808 -32.495  1.00  0.00           C  
ATOM   1245  CD1 TYR A  77    -111.246  22.015 -33.112  1.00  0.00           C  
ATOM   1246  CD2 TYR A  77    -110.922  20.703 -31.099  1.00  0.00           C  
ATOM   1247  CE1 TYR A  77    -111.621  23.118 -32.334  1.00  0.00           C  
ATOM   1248  CE2 TYR A  77    -111.296  21.805 -30.321  1.00  0.00           C  
ATOM   1249  CZ  TYR A  77    -111.645  23.012 -30.938  1.00  0.00           C  
ATOM   1250  OH  TYR A  77    -112.015  24.098 -30.170  1.00  0.00           O  
ATOM   1251  H   TYR A  77    -107.948  18.702 -32.292  1.00  0.00           H  
ATOM   1252  HA  TYR A  77    -108.996  19.749 -34.872  1.00  0.00           H  
ATOM   1253  HB2 TYR A  77    -111.140  19.552 -34.197  1.00  0.00           H  
ATOM   1254  HB3 TYR A  77    -110.582  18.718 -32.746  1.00  0.00           H  
ATOM   1255  HD1 TYR A  77    -111.228  22.097 -34.189  1.00  0.00           H  
ATOM   1256  HD2 TYR A  77    -110.652  19.772 -30.623  1.00  0.00           H  
ATOM   1257  HE1 TYR A  77    -111.891  24.049 -32.811  1.00  0.00           H  
ATOM   1258  HE2 TYR A  77    -111.315  21.724 -29.244  1.00  0.00           H  
ATOM   1259  HH  TYR A  77    -112.960  24.224 -30.272  1.00  0.00           H  
ATOM   1260  N   GLU A  78    -108.211  22.032 -34.168  1.00  0.00           N  
ATOM   1261  CA  GLU A  78    -107.654  23.347 -33.740  1.00  0.00           C  
ATOM   1262  C   GLU A  78    -108.547  24.480 -34.250  1.00  0.00           C  
ATOM   1263  O   GLU A  78    -109.020  24.451 -35.369  1.00  0.00           O  
ATOM   1264  CB  GLU A  78    -106.269  23.417 -34.385  1.00  0.00           C  
ATOM   1265  CG  GLU A  78    -105.581  24.722 -33.977  1.00  0.00           C  
ATOM   1266  CD  GLU A  78    -105.841  25.792 -35.039  1.00  0.00           C  
ATOM   1267  OE1 GLU A  78    -106.080  25.425 -36.177  1.00  0.00           O  
ATOM   1268  OE2 GLU A  78    -105.796  26.962 -34.695  1.00  0.00           O  
ATOM   1269  H   GLU A  78    -108.387  21.862 -35.118  1.00  0.00           H  
ATOM   1270  HA  GLU A  78    -107.566  23.387 -32.666  1.00  0.00           H  
ATOM   1271  HB2 GLU A  78    -105.675  22.577 -34.052  1.00  0.00           H  
ATOM   1272  HB3 GLU A  78    -106.369  23.384 -35.458  1.00  0.00           H  
ATOM   1273  HG2 GLU A  78    -105.971  25.053 -33.027  1.00  0.00           H  
ATOM   1274  HG3 GLU A  78    -104.517  24.555 -33.891  1.00  0.00           H  
ATOM   1275  N   ASN A  79    -108.787  25.475 -33.435  1.00  0.00           N  
ATOM   1276  CA  ASN A  79    -109.656  26.612 -33.863  1.00  0.00           C  
ATOM   1277  C   ASN A  79    -111.098  26.132 -34.057  1.00  0.00           C  
ATOM   1278  O   ASN A  79    -111.978  26.451 -33.283  1.00  0.00           O  
ATOM   1279  CB  ASN A  79    -109.067  27.095 -35.191  1.00  0.00           C  
ATOM   1280  CG  ASN A  79    -108.901  28.615 -35.153  1.00  0.00           C  
ATOM   1281  OD1 ASN A  79    -109.667  29.336 -35.759  1.00  0.00           O  
ATOM   1282  ND2 ASN A  79    -107.924  29.136 -34.462  1.00  0.00           N  
ATOM   1283  H   ASN A  79    -108.398  25.471 -32.535  1.00  0.00           H  
ATOM   1284  HA  ASN A  79    -109.620  27.406 -33.135  1.00  0.00           H  
ATOM   1285  HB2 ASN A  79    -108.105  26.629 -35.348  1.00  0.00           H  
ATOM   1286  HB3 ASN A  79    -109.732  26.829 -35.998  1.00  0.00           H  
ATOM   1287 HD21 ASN A  79    -107.305  28.554 -33.973  1.00  0.00           H  
ATOM   1288 HD22 ASN A  79    -107.808  30.108 -34.434  1.00  0.00           H  
ATOM   1289  N   ASN A  80    -111.345  25.367 -35.085  1.00  0.00           N  
ATOM   1290  CA  ASN A  80    -112.729  24.866 -35.328  1.00  0.00           C  
ATOM   1291  C   ASN A  80    -112.730  23.850 -36.474  1.00  0.00           C  
ATOM   1292  O   ASN A  80    -113.642  23.806 -37.275  1.00  0.00           O  
ATOM   1293  CB  ASN A  80    -113.538  26.106 -35.710  1.00  0.00           C  
ATOM   1294  CG  ASN A  80    -114.428  26.518 -34.537  1.00  0.00           C  
ATOM   1295  OD1 ASN A  80    -114.268  27.589 -33.984  1.00  0.00           O  
ATOM   1296  ND2 ASN A  80    -115.366  25.707 -34.129  1.00  0.00           N  
ATOM   1297  H   ASN A  80    -110.621  25.120 -35.697  1.00  0.00           H  
ATOM   1298  HA  ASN A  80    -113.132  24.425 -34.431  1.00  0.00           H  
ATOM   1299  HB2 ASN A  80    -112.864  26.914 -35.953  1.00  0.00           H  
ATOM   1300  HB3 ASN A  80    -114.156  25.883 -36.567  1.00  0.00           H  
ATOM   1301 HD21 ASN A  80    -115.495  24.843 -34.574  1.00  0.00           H  
ATOM   1302 HD22 ASN A  80    -115.941  25.961 -33.377  1.00  0.00           H  
ATOM   1303  N   GLN A  81    -111.715  23.033 -36.556  1.00  0.00           N  
ATOM   1304  CA  GLN A  81    -111.659  22.021 -37.651  1.00  0.00           C  
ATOM   1305  C   GLN A  81    -110.921  20.766 -37.171  1.00  0.00           C  
ATOM   1306  O   GLN A  81    -109.730  20.787 -36.933  1.00  0.00           O  
ATOM   1307  CB  GLN A  81    -110.883  22.702 -38.780  1.00  0.00           C  
ATOM   1308  CG  GLN A  81    -110.831  21.776 -39.997  1.00  0.00           C  
ATOM   1309  CD  GLN A  81    -110.049  22.457 -41.124  1.00  0.00           C  
ATOM   1310  OE1 GLN A  81    -110.619  22.856 -42.119  1.00  0.00           O  
ATOM   1311  NE2 GLN A  81    -108.757  22.606 -41.007  1.00  0.00           N  
ATOM   1312  H   GLN A  81    -110.991  23.085 -35.899  1.00  0.00           H  
ATOM   1313  HA  GLN A  81    -112.652  21.770 -37.984  1.00  0.00           H  
ATOM   1314  HB2 GLN A  81    -111.379  23.624 -39.050  1.00  0.00           H  
ATOM   1315  HB3 GLN A  81    -109.879  22.917 -38.449  1.00  0.00           H  
ATOM   1316  HG2 GLN A  81    -110.342  20.852 -39.725  1.00  0.00           H  
ATOM   1317  HG3 GLN A  81    -111.834  21.568 -40.335  1.00  0.00           H  
ATOM   1318 HE21 GLN A  81    -108.298  22.283 -40.204  1.00  0.00           H  
ATOM   1319 HE22 GLN A  81    -108.248  23.040 -41.723  1.00  0.00           H  
ATOM   1320  N   LYS A  82    -111.621  19.673 -37.028  1.00  0.00           N  
ATOM   1321  CA  LYS A  82    -110.961  18.419 -36.562  1.00  0.00           C  
ATOM   1322  C   LYS A  82    -110.158  17.787 -37.703  1.00  0.00           C  
ATOM   1323  O   LYS A  82    -110.712  17.265 -38.651  1.00  0.00           O  
ATOM   1324  CB  LYS A  82    -112.108  17.499 -36.142  1.00  0.00           C  
ATOM   1325  CG  LYS A  82    -111.779  16.853 -34.796  1.00  0.00           C  
ATOM   1326  CD  LYS A  82    -112.812  17.287 -33.754  1.00  0.00           C  
ATOM   1327  CE  LYS A  82    -113.194  16.089 -32.882  1.00  0.00           C  
ATOM   1328  NZ  LYS A  82    -114.630  16.297 -32.549  1.00  0.00           N  
ATOM   1329  H   LYS A  82    -112.582  19.677 -37.225  1.00  0.00           H  
ATOM   1330  HA  LYS A  82    -110.323  18.620 -35.717  1.00  0.00           H  
ATOM   1331  HB2 LYS A  82    -113.017  18.077 -36.053  1.00  0.00           H  
ATOM   1332  HB3 LYS A  82    -112.243  16.729 -36.886  1.00  0.00           H  
ATOM   1333  HG2 LYS A  82    -111.799  15.777 -34.898  1.00  0.00           H  
ATOM   1334  HG3 LYS A  82    -110.797  17.166 -34.476  1.00  0.00           H  
ATOM   1335  HD2 LYS A  82    -112.393  18.066 -33.134  1.00  0.00           H  
ATOM   1336  HD3 LYS A  82    -113.693  17.659 -34.254  1.00  0.00           H  
ATOM   1337  HE2 LYS A  82    -113.062  15.167 -33.432  1.00  0.00           H  
ATOM   1338  HE3 LYS A  82    -112.603  16.077 -31.979  1.00  0.00           H  
ATOM   1339  HZ1 LYS A  82    -115.147  16.581 -33.405  1.00  0.00           H  
ATOM   1340  HZ2 LYS A  82    -114.715  17.042 -31.827  1.00  0.00           H  
ATOM   1341  HZ3 LYS A  82    -115.034  15.412 -32.181  1.00  0.00           H  
ATOM   1342  N   LEU A  83    -108.855  17.827 -37.620  1.00  0.00           N  
ATOM   1343  CA  LEU A  83    -108.023  17.225 -38.700  1.00  0.00           C  
ATOM   1344  C   LEU A  83    -108.050  15.694 -38.590  1.00  0.00           C  
ATOM   1345  O   LEU A  83    -107.861  15.152 -37.519  1.00  0.00           O  
ATOM   1346  CB  LEU A  83    -106.610  17.756 -38.452  1.00  0.00           C  
ATOM   1347  CG  LEU A  83    -106.547  19.235 -38.836  1.00  0.00           C  
ATOM   1348  CD1 LEU A  83    -105.279  19.861 -38.253  1.00  0.00           C  
ATOM   1349  CD2 LEU A  83    -106.524  19.365 -40.361  1.00  0.00           C  
ATOM   1350  H   LEU A  83    -108.424  18.250 -36.848  1.00  0.00           H  
ATOM   1351  HA  LEU A  83    -108.373  17.548 -39.665  1.00  0.00           H  
ATOM   1352  HB2 LEU A  83    -106.361  17.643 -37.407  1.00  0.00           H  
ATOM   1353  HB3 LEU A  83    -105.906  17.201 -39.053  1.00  0.00           H  
ATOM   1354  HG  LEU A  83    -107.414  19.746 -38.443  1.00  0.00           H  
ATOM   1355 HD11 LEU A  83    -104.801  19.154 -37.591  1.00  0.00           H  
ATOM   1356 HD12 LEU A  83    -105.539  20.752 -37.701  1.00  0.00           H  
ATOM   1357 HD13 LEU A  83    -104.602  20.118 -39.055  1.00  0.00           H  
ATOM   1358 HD21 LEU A  83    -105.616  19.864 -40.667  1.00  0.00           H  
ATOM   1359 HD22 LEU A  83    -107.378  19.939 -40.687  1.00  0.00           H  
ATOM   1360 HD23 LEU A  83    -106.561  18.381 -40.807  1.00  0.00           H  
ATOM   1361  N   PRO A  84    -108.288  15.042 -39.700  1.00  0.00           N  
ATOM   1362  CA  PRO A  84    -108.341  13.560 -39.709  1.00  0.00           C  
ATOM   1363  C   PRO A  84    -106.934  12.971 -39.592  1.00  0.00           C  
ATOM   1364  O   PRO A  84    -106.290  12.680 -40.581  1.00  0.00           O  
ATOM   1365  CB  PRO A  84    -108.953  13.230 -41.067  1.00  0.00           C  
ATOM   1366  CG  PRO A  84    -108.634  14.406 -41.934  1.00  0.00           C  
ATOM   1367  CD  PRO A  84    -108.526  15.610 -41.033  1.00  0.00           C  
ATOM   1368  HA  PRO A  84    -108.977  13.195 -38.918  1.00  0.00           H  
ATOM   1369  HB2 PRO A  84    -108.507  12.330 -41.469  1.00  0.00           H  
ATOM   1370  HB3 PRO A  84    -110.022  13.114 -40.981  1.00  0.00           H  
ATOM   1371  HG2 PRO A  84    -107.697  14.240 -42.447  1.00  0.00           H  
ATOM   1372  HG3 PRO A  84    -109.425  14.559 -42.651  1.00  0.00           H  
ATOM   1373  HD2 PRO A  84    -107.696  16.233 -41.336  1.00  0.00           H  
ATOM   1374  HD3 PRO A  84    -109.446  16.171 -41.038  1.00  0.00           H  
ATOM   1375  N   VAL A  85    -106.450  12.786 -38.393  1.00  0.00           N  
ATOM   1376  CA  VAL A  85    -105.087  12.211 -38.226  1.00  0.00           C  
ATOM   1377  C   VAL A  85    -105.052  10.791 -38.797  1.00  0.00           C  
ATOM   1378  O   VAL A  85    -105.880   9.962 -38.472  1.00  0.00           O  
ATOM   1379  CB  VAL A  85    -104.847  12.194 -36.718  1.00  0.00           C  
ATOM   1380  CG1 VAL A  85    -103.550  11.446 -36.415  1.00  0.00           C  
ATOM   1381  CG2 VAL A  85    -104.741  13.632 -36.204  1.00  0.00           C  
ATOM   1382  H   VAL A  85    -106.984  13.022 -37.606  1.00  0.00           H  
ATOM   1383  HA  VAL A  85    -104.352  12.832 -38.712  1.00  0.00           H  
ATOM   1384  HB  VAL A  85    -105.672  11.698 -36.229  1.00  0.00           H  
ATOM   1385 HG11 VAL A  85    -102.713  12.003 -36.808  1.00  0.00           H  
ATOM   1386 HG12 VAL A  85    -103.582  10.470 -36.876  1.00  0.00           H  
ATOM   1387 HG13 VAL A  85    -103.440  11.335 -35.347  1.00  0.00           H  
ATOM   1388 HG21 VAL A  85    -104.006  13.678 -35.413  1.00  0.00           H  
ATOM   1389 HG22 VAL A  85    -105.700  13.952 -35.823  1.00  0.00           H  
ATOM   1390 HG23 VAL A  85    -104.441  14.282 -37.011  1.00  0.00           H  
ATOM   1391  N   ARG A  86    -104.110  10.506 -39.652  1.00  0.00           N  
ATOM   1392  CA  ARG A  86    -104.038   9.142 -40.248  1.00  0.00           C  
ATOM   1393  C   ARG A  86    -102.823   8.380 -39.710  1.00  0.00           C  
ATOM   1394  O   ARG A  86    -102.104   8.859 -38.855  1.00  0.00           O  
ATOM   1395  CB  ARG A  86    -103.896   9.379 -41.751  1.00  0.00           C  
ATOM   1396  CG  ARG A  86    -102.604  10.153 -42.026  1.00  0.00           C  
ATOM   1397  CD  ARG A  86    -102.944  11.525 -42.612  1.00  0.00           C  
ATOM   1398  NE  ARG A  86    -102.000  11.698 -43.751  1.00  0.00           N  
ATOM   1399  CZ  ARG A  86    -101.090  12.633 -43.710  1.00  0.00           C  
ATOM   1400  NH1 ARG A  86     -99.999  12.451 -43.018  1.00  0.00           N  
ATOM   1401  NH2 ARG A  86    -101.272  13.750 -44.360  1.00  0.00           N  
ATOM   1402  H   ARG A  86    -103.456  11.190 -39.908  1.00  0.00           H  
ATOM   1403  HA  ARG A  86    -104.945   8.596 -40.046  1.00  0.00           H  
ATOM   1404  HB2 ARG A  86    -103.864   8.429 -42.264  1.00  0.00           H  
ATOM   1405  HB3 ARG A  86    -104.739   9.953 -42.106  1.00  0.00           H  
ATOM   1406  HG2 ARG A  86    -102.060  10.281 -41.101  1.00  0.00           H  
ATOM   1407  HG3 ARG A  86    -101.998   9.602 -42.729  1.00  0.00           H  
ATOM   1408  HD2 ARG A  86    -103.966  11.541 -42.962  1.00  0.00           H  
ATOM   1409  HD3 ARG A  86    -102.783  12.299 -41.879  1.00  0.00           H  
ATOM   1410  HE  ARG A  86    -102.062  11.110 -44.532  1.00  0.00           H  
ATOM   1411 HH11 ARG A  86     -99.859  11.596 -42.521  1.00  0.00           H  
ATOM   1412 HH12 ARG A  86     -99.302  13.168 -42.986  1.00  0.00           H  
ATOM   1413 HH21 ARG A  86    -102.108  13.890 -44.890  1.00  0.00           H  
ATOM   1414 HH22 ARG A  86    -100.575  14.466 -44.327  1.00  0.00           H  
ATOM   1415  N   LEU A  87    -102.592   7.196 -40.208  1.00  0.00           N  
ATOM   1416  CA  LEU A  87    -101.426   6.396 -39.733  1.00  0.00           C  
ATOM   1417  C   LEU A  87    -100.427   6.197 -40.876  1.00  0.00           C  
ATOM   1418  O   LEU A  87    -100.803   5.985 -42.013  1.00  0.00           O  
ATOM   1419  CB  LEU A  87    -102.019   5.055 -39.301  1.00  0.00           C  
ATOM   1420  CG  LEU A  87    -101.749   4.829 -37.810  1.00  0.00           C  
ATOM   1421  CD1 LEU A  87    -103.057   4.949 -37.026  1.00  0.00           C  
ATOM   1422  CD2 LEU A  87    -101.160   3.431 -37.605  1.00  0.00           C  
ATOM   1423  H   LEU A  87    -103.186   6.832 -40.897  1.00  0.00           H  
ATOM   1424  HA  LEU A  87    -100.951   6.879 -38.895  1.00  0.00           H  
ATOM   1425  HB2 LEU A  87    -103.085   5.058 -39.479  1.00  0.00           H  
ATOM   1426  HB3 LEU A  87    -101.563   4.260 -39.872  1.00  0.00           H  
ATOM   1427  HG  LEU A  87    -101.048   5.571 -37.455  1.00  0.00           H  
ATOM   1428 HD11 LEU A  87    -103.894   4.815 -37.696  1.00  0.00           H  
ATOM   1429 HD12 LEU A  87    -103.114   5.924 -36.567  1.00  0.00           H  
ATOM   1430 HD13 LEU A  87    -103.087   4.188 -36.259  1.00  0.00           H  
ATOM   1431 HD21 LEU A  87    -101.429   3.067 -36.624  1.00  0.00           H  
ATOM   1432 HD22 LEU A  87    -100.084   3.476 -37.690  1.00  0.00           H  
ATOM   1433 HD23 LEU A  87    -101.551   2.761 -38.357  1.00  0.00           H  
ATOM   1434  N   VAL A  88     -99.156   6.264 -40.587  1.00  0.00           N  
ATOM   1435  CA  VAL A  88     -98.137   6.077 -41.660  1.00  0.00           C  
ATOM   1436  C   VAL A  88     -97.361   4.778 -41.433  1.00  0.00           C  
ATOM   1437  O   VAL A  88     -96.888   4.152 -42.362  1.00  0.00           O  
ATOM   1438  CB  VAL A  88     -97.209   7.286 -41.535  1.00  0.00           C  
ATOM   1439  CG1 VAL A  88     -98.042   8.568 -41.493  1.00  0.00           C  
ATOM   1440  CG2 VAL A  88     -96.390   7.169 -40.247  1.00  0.00           C  
ATOM   1441  H   VAL A  88     -98.873   6.435 -39.665  1.00  0.00           H  
ATOM   1442  HA  VAL A  88     -98.606   6.072 -42.631  1.00  0.00           H  
ATOM   1443  HB  VAL A  88     -96.542   7.317 -42.386  1.00  0.00           H  
ATOM   1444 HG11 VAL A  88     -97.396   9.422 -41.635  1.00  0.00           H  
ATOM   1445 HG12 VAL A  88     -98.537   8.645 -40.537  1.00  0.00           H  
ATOM   1446 HG13 VAL A  88     -98.781   8.542 -42.281  1.00  0.00           H  
ATOM   1447 HG21 VAL A  88     -95.766   6.289 -40.295  1.00  0.00           H  
ATOM   1448 HG22 VAL A  88     -97.058   7.091 -39.402  1.00  0.00           H  
ATOM   1449 HG23 VAL A  88     -95.768   8.045 -40.135  1.00  0.00           H  
ATOM   1450  N   SER A  89     -97.227   4.366 -40.201  1.00  0.00           N  
ATOM   1451  CA  SER A  89     -96.485   3.106 -39.908  1.00  0.00           C  
ATOM   1452  C   SER A  89     -96.769   2.653 -38.475  1.00  0.00           C  
ATOM   1453  O   SER A  89     -97.034   3.458 -37.603  1.00  0.00           O  
ATOM   1454  CB  SER A  89     -95.009   3.467 -40.073  1.00  0.00           C  
ATOM   1455  OG  SER A  89     -94.215   2.313 -39.825  1.00  0.00           O  
ATOM   1456  H   SER A  89     -97.618   4.886 -39.468  1.00  0.00           H  
ATOM   1457  HA  SER A  89     -96.758   2.334 -40.610  1.00  0.00           H  
ATOM   1458  HB2 SER A  89     -94.830   3.812 -41.077  1.00  0.00           H  
ATOM   1459  HB3 SER A  89     -94.751   4.251 -39.373  1.00  0.00           H  
ATOM   1460  HG  SER A  89     -93.716   2.464 -39.019  1.00  0.00           H  
ATOM   1461  N   TYR A  90     -96.719   1.375 -38.219  1.00  0.00           N  
ATOM   1462  CA  TYR A  90     -96.990   0.886 -36.837  1.00  0.00           C  
ATOM   1463  C   TYR A  90     -96.200  -0.393 -36.551  1.00  0.00           C  
ATOM   1464  O   TYR A  90     -96.289  -1.364 -37.276  1.00  0.00           O  
ATOM   1465  CB  TYR A  90     -98.490   0.593 -36.801  1.00  0.00           C  
ATOM   1466  CG  TYR A  90     -98.764  -0.463 -35.756  1.00  0.00           C  
ATOM   1467  CD1 TYR A  90     -99.021  -0.086 -34.433  1.00  0.00           C  
ATOM   1468  CD2 TYR A  90     -98.756  -1.820 -36.108  1.00  0.00           C  
ATOM   1469  CE1 TYR A  90     -99.272  -1.062 -33.462  1.00  0.00           C  
ATOM   1470  CE2 TYR A  90     -99.007  -2.798 -35.137  1.00  0.00           C  
ATOM   1471  CZ  TYR A  90     -99.266  -2.419 -33.813  1.00  0.00           C  
ATOM   1472  OH  TYR A  90     -99.513  -3.381 -32.855  1.00  0.00           O  
ATOM   1473  H   TYR A  90     -96.505   0.739 -38.934  1.00  0.00           H  
ATOM   1474  HA  TYR A  90     -96.749   1.649 -36.116  1.00  0.00           H  
ATOM   1475  HB2 TYR A  90     -99.028   1.496 -36.553  1.00  0.00           H  
ATOM   1476  HB3 TYR A  90     -98.811   0.235 -37.767  1.00  0.00           H  
ATOM   1477  HD1 TYR A  90     -99.026   0.959 -34.162  1.00  0.00           H  
ATOM   1478  HD2 TYR A  90     -98.557  -2.111 -37.129  1.00  0.00           H  
ATOM   1479  HE1 TYR A  90     -99.467  -0.769 -32.441  1.00  0.00           H  
ATOM   1480  HE2 TYR A  90     -98.995  -3.846 -35.408  1.00  0.00           H  
ATOM   1481  HH  TYR A  90     -98.722  -3.477 -32.319  1.00  0.00           H  
ATOM   1482  N   SER A  91     -95.443  -0.408 -35.489  1.00  0.00           N  
ATOM   1483  CA  SER A  91     -94.669  -1.634 -35.151  1.00  0.00           C  
ATOM   1484  C   SER A  91     -95.617  -2.680 -34.560  1.00  0.00           C  
ATOM   1485  O   SER A  91     -96.635  -2.338 -34.003  1.00  0.00           O  
ATOM   1486  CB  SER A  91     -93.635  -1.183 -34.125  1.00  0.00           C  
ATOM   1487  OG  SER A  91     -92.381  -1.776 -34.434  1.00  0.00           O  
ATOM   1488  H   SER A  91     -95.394   0.380 -34.909  1.00  0.00           H  
ATOM   1489  HA  SER A  91     -94.176  -2.024 -36.029  1.00  0.00           H  
ATOM   1490  HB2 SER A  91     -93.537  -0.111 -34.161  1.00  0.00           H  
ATOM   1491  HB3 SER A  91     -93.956  -1.483 -33.136  1.00  0.00           H  
ATOM   1492  HG  SER A  91     -92.137  -1.506 -35.323  1.00  0.00           H  
ATOM   1493  N   PRO A  92     -95.260  -3.921 -34.725  1.00  0.00           N  
ATOM   1494  CA  PRO A  92     -96.108  -5.037 -34.232  1.00  0.00           C  
ATOM   1495  C   PRO A  92     -96.171  -5.100 -32.698  1.00  0.00           C  
ATOM   1496  O   PRO A  92     -95.391  -4.485 -31.998  1.00  0.00           O  
ATOM   1497  CB  PRO A  92     -95.441  -6.277 -34.817  1.00  0.00           C  
ATOM   1498  CG  PRO A  92     -94.021  -5.876 -35.051  1.00  0.00           C  
ATOM   1499  CD  PRO A  92     -94.037  -4.405 -35.376  1.00  0.00           C  
ATOM   1500  HA  PRO A  92     -97.104  -4.946 -34.635  1.00  0.00           H  
ATOM   1501  HB2 PRO A  92     -95.496  -7.099 -34.119  1.00  0.00           H  
ATOM   1502  HB3 PRO A  92     -95.909  -6.544 -35.752  1.00  0.00           H  
ATOM   1503  HG2 PRO A  92     -93.436  -6.055 -34.160  1.00  0.00           H  
ATOM   1504  HG3 PRO A  92     -93.612  -6.428 -35.883  1.00  0.00           H  
ATOM   1505  HD2 PRO A  92     -93.164  -3.917 -34.966  1.00  0.00           H  
ATOM   1506  HD3 PRO A  92     -94.097  -4.251 -36.442  1.00  0.00           H  
ATOM   1507  N   VAL A  93     -97.130  -5.846 -32.197  1.00  0.00           N  
ATOM   1508  CA  VAL A  93     -97.344  -6.004 -30.719  1.00  0.00           C  
ATOM   1509  C   VAL A  93     -96.045  -5.946 -29.897  1.00  0.00           C  
ATOM   1510  O   VAL A  93     -95.953  -5.164 -28.972  1.00  0.00           O  
ATOM   1511  CB  VAL A  93     -97.997  -7.377 -30.569  1.00  0.00           C  
ATOM   1512  CG1 VAL A  93     -97.810  -7.876 -29.135  1.00  0.00           C  
ATOM   1513  CG2 VAL A  93     -99.492  -7.264 -30.875  1.00  0.00           C  
ATOM   1514  H   VAL A  93     -97.736  -6.307 -32.812  1.00  0.00           H  
ATOM   1515  HA  VAL A  93     -98.030  -5.250 -30.368  1.00  0.00           H  
ATOM   1516  HB  VAL A  93     -97.537  -8.072 -31.256  1.00  0.00           H  
ATOM   1517 HG11 VAL A  93     -98.671  -8.455 -28.840  1.00  0.00           H  
ATOM   1518 HG12 VAL A  93     -97.699  -7.030 -28.471  1.00  0.00           H  
ATOM   1519 HG13 VAL A  93     -96.926  -8.494 -29.082  1.00  0.00           H  
ATOM   1520 HG21 VAL A  93     -99.932  -6.506 -30.245  1.00  0.00           H  
ATOM   1521 HG22 VAL A  93     -99.971  -8.213 -30.685  1.00  0.00           H  
ATOM   1522 HG23 VAL A  93     -99.627  -6.994 -31.912  1.00  0.00           H  
ATOM   1523  N   PRO A  94     -95.084  -6.776 -30.226  1.00  0.00           N  
ATOM   1524  CA  PRO A  94     -93.813  -6.785 -29.454  1.00  0.00           C  
ATOM   1525  C   PRO A  94     -93.151  -5.409 -29.490  1.00  0.00           C  
ATOM   1526  O   PRO A  94     -92.558  -4.973 -28.523  1.00  0.00           O  
ATOM   1527  CB  PRO A  94     -92.980  -7.864 -30.150  1.00  0.00           C  
ATOM   1528  CG  PRO A  94     -93.572  -7.961 -31.516  1.00  0.00           C  
ATOM   1529  CD  PRO A  94     -95.050  -7.751 -31.322  1.00  0.00           C  
ATOM   1530  HA  PRO A  94     -94.004  -7.077 -28.434  1.00  0.00           H  
ATOM   1531  HB2 PRO A  94     -91.942  -7.563 -30.204  1.00  0.00           H  
ATOM   1532  HB3 PRO A  94     -93.076  -8.808 -29.636  1.00  0.00           H  
ATOM   1533  HG2 PRO A  94     -93.160  -7.192 -32.156  1.00  0.00           H  
ATOM   1534  HG3 PRO A  94     -93.391  -8.938 -31.935  1.00  0.00           H  
ATOM   1535  HD2 PRO A  94     -95.494  -7.356 -32.219  1.00  0.00           H  
ATOM   1536  HD3 PRO A  94     -95.533  -8.668 -31.022  1.00  0.00           H  
ATOM   1537  N   GLU A  95     -93.269  -4.702 -30.577  1.00  0.00           N  
ATOM   1538  CA  GLU A  95     -92.669  -3.340 -30.632  1.00  0.00           C  
ATOM   1539  C   GLU A  95     -93.681  -2.324 -30.100  1.00  0.00           C  
ATOM   1540  O   GLU A  95     -93.328  -1.348 -29.469  1.00  0.00           O  
ATOM   1541  CB  GLU A  95     -92.370  -3.081 -32.105  1.00  0.00           C  
ATOM   1542  CG  GLU A  95     -91.038  -3.730 -32.478  1.00  0.00           C  
ATOM   1543  CD  GLU A  95     -89.985  -2.641 -32.697  1.00  0.00           C  
ATOM   1544  OE1 GLU A  95     -89.970  -1.697 -31.923  1.00  0.00           O  
ATOM   1545  OE2 GLU A  95     -89.214  -2.768 -33.633  1.00  0.00           O  
ATOM   1546  H   GLU A  95     -93.770  -5.052 -31.342  1.00  0.00           H  
ATOM   1547  HA  GLU A  95     -91.757  -3.305 -30.055  1.00  0.00           H  
ATOM   1548  HB2 GLU A  95     -93.161  -3.498 -32.714  1.00  0.00           H  
ATOM   1549  HB3 GLU A  95     -92.308  -2.018 -32.274  1.00  0.00           H  
ATOM   1550  HG2 GLU A  95     -90.721  -4.383 -31.679  1.00  0.00           H  
ATOM   1551  HG3 GLU A  95     -91.156  -4.300 -33.386  1.00  0.00           H  
ATOM   1552  N   ASP A  96     -94.944  -2.562 -30.345  1.00  0.00           N  
ATOM   1553  CA  ASP A  96     -96.002  -1.629 -29.856  1.00  0.00           C  
ATOM   1554  C   ASP A  96     -95.621  -0.177 -30.159  1.00  0.00           C  
ATOM   1555  O   ASP A  96     -95.066   0.517 -29.330  1.00  0.00           O  
ATOM   1556  CB  ASP A  96     -96.068  -1.868 -28.347  1.00  0.00           C  
ATOM   1557  CG  ASP A  96     -97.526  -1.830 -27.887  1.00  0.00           C  
ATOM   1558  OD1 ASP A  96     -98.290  -2.666 -28.338  1.00  0.00           O  
ATOM   1559  OD2 ASP A  96     -97.853  -0.965 -27.092  1.00  0.00           O  
ATOM   1560  H   ASP A  96     -95.199  -3.361 -30.852  1.00  0.00           H  
ATOM   1561  HA  ASP A  96     -96.954  -1.868 -30.308  1.00  0.00           H  
ATOM   1562  HB2 ASP A  96     -95.641  -2.834 -28.118  1.00  0.00           H  
ATOM   1563  HB3 ASP A  96     -95.510  -1.097 -27.835  1.00  0.00           H  
ATOM   1564  N   HIS A  97     -95.921   0.284 -31.340  1.00  0.00           N  
ATOM   1565  CA  HIS A  97     -95.584   1.689 -31.703  1.00  0.00           C  
ATOM   1566  C   HIS A  97     -96.395   2.117 -32.928  1.00  0.00           C  
ATOM   1567  O   HIS A  97     -96.267   1.552 -33.995  1.00  0.00           O  
ATOM   1568  CB  HIS A  97     -94.091   1.667 -32.031  1.00  0.00           C  
ATOM   1569  CG  HIS A  97     -93.292   1.902 -30.779  1.00  0.00           C  
ATOM   1570  ND1 HIS A  97     -93.399   3.071 -30.041  1.00  0.00           N  
ATOM   1571  CD2 HIS A  97     -92.365   1.129 -30.125  1.00  0.00           C  
ATOM   1572  CE1 HIS A  97     -92.557   2.967 -28.995  1.00  0.00           C  
ATOM   1573  NE2 HIS A  97     -91.902   1.803 -28.999  1.00  0.00           N  
ATOM   1574  H   HIS A  97     -96.371  -0.294 -31.990  1.00  0.00           H  
ATOM   1575  HA  HIS A  97     -95.771   2.351 -30.872  1.00  0.00           H  
ATOM   1576  HB2 HIS A  97     -93.830   0.706 -32.446  1.00  0.00           H  
ATOM   1577  HB3 HIS A  97     -93.869   2.442 -32.750  1.00  0.00           H  
ATOM   1578  HD1 HIS A  97     -93.981   3.832 -30.243  1.00  0.00           H  
ATOM   1579  HD2 HIS A  97     -92.045   0.145 -30.437  1.00  0.00           H  
ATOM   1580  HE1 HIS A  97     -92.426   3.734 -28.246  1.00  0.00           H  
ATOM   1581  N   ALA A  98     -97.231   3.110 -32.786  1.00  0.00           N  
ATOM   1582  CA  ALA A  98     -98.046   3.565 -33.949  1.00  0.00           C  
ATOM   1583  C   ALA A  98     -97.588   4.956 -34.395  1.00  0.00           C  
ATOM   1584  O   ALA A  98     -97.315   5.819 -33.585  1.00  0.00           O  
ATOM   1585  CB  ALA A  98     -99.485   3.615 -33.434  1.00  0.00           C  
ATOM   1586  H   ALA A  98     -97.323   3.554 -31.918  1.00  0.00           H  
ATOM   1587  HA  ALA A  98     -97.969   2.860 -34.761  1.00  0.00           H  
ATOM   1588  HB1 ALA A  98     -99.497   4.022 -32.435  1.00  0.00           H  
ATOM   1589  HB2 ALA A  98     -99.897   2.618 -33.423  1.00  0.00           H  
ATOM   1590  HB3 ALA A  98    -100.077   4.242 -34.086  1.00  0.00           H  
ATOM   1591  N   TYR A  99     -97.496   5.181 -35.677  1.00  0.00           N  
ATOM   1592  CA  TYR A  99     -97.049   6.515 -36.167  1.00  0.00           C  
ATOM   1593  C   TYR A  99     -98.202   7.243 -36.864  1.00  0.00           C  
ATOM   1594  O   TYR A  99     -98.743   6.776 -37.846  1.00  0.00           O  
ATOM   1595  CB  TYR A  99     -95.923   6.215 -37.156  1.00  0.00           C  
ATOM   1596  CG  TYR A  99     -94.741   5.642 -36.408  1.00  0.00           C  
ATOM   1597  CD1 TYR A  99     -94.051   6.432 -35.481  1.00  0.00           C  
ATOM   1598  CD2 TYR A  99     -94.337   4.322 -36.643  1.00  0.00           C  
ATOM   1599  CE1 TYR A  99     -92.957   5.900 -34.788  1.00  0.00           C  
ATOM   1600  CE2 TYR A  99     -93.242   3.791 -35.949  1.00  0.00           C  
ATOM   1601  CZ  TYR A  99     -92.553   4.580 -35.021  1.00  0.00           C  
ATOM   1602  OH  TYR A  99     -91.474   4.058 -34.337  1.00  0.00           O  
ATOM   1603  H   TYR A  99     -97.718   4.472 -36.317  1.00  0.00           H  
ATOM   1604  HA  TYR A  99     -96.671   7.108 -35.350  1.00  0.00           H  
ATOM   1605  HB2 TYR A  99     -96.267   5.500 -37.889  1.00  0.00           H  
ATOM   1606  HB3 TYR A  99     -95.626   7.127 -37.653  1.00  0.00           H  
ATOM   1607  HD1 TYR A  99     -94.363   7.449 -35.300  1.00  0.00           H  
ATOM   1608  HD2 TYR A  99     -94.869   3.712 -37.358  1.00  0.00           H  
ATOM   1609  HE1 TYR A  99     -92.424   6.510 -34.071  1.00  0.00           H  
ATOM   1610  HE2 TYR A  99     -92.931   2.773 -36.130  1.00  0.00           H  
ATOM   1611  HH  TYR A  99     -91.752   3.879 -33.436  1.00  0.00           H  
ATOM   1612  N   ILE A 100     -98.575   8.389 -36.362  1.00  0.00           N  
ATOM   1613  CA  ILE A 100     -99.689   9.157 -36.989  1.00  0.00           C  
ATOM   1614  C   ILE A 100     -99.185  10.525 -37.457  1.00  0.00           C  
ATOM   1615  O   ILE A 100     -98.268  11.084 -36.889  1.00  0.00           O  
ATOM   1616  CB  ILE A 100    -100.735   9.317 -35.885  1.00  0.00           C  
ATOM   1617  CG1 ILE A 100    -100.141  10.127 -34.729  1.00  0.00           C  
ATOM   1618  CG2 ILE A 100    -101.152   7.937 -35.373  1.00  0.00           C  
ATOM   1619  CD1 ILE A 100    -100.829  11.491 -34.650  1.00  0.00           C  
ATOM   1620  H   ILE A 100     -98.120   8.745 -35.571  1.00  0.00           H  
ATOM   1621  HA  ILE A 100    -100.108   8.606 -37.817  1.00  0.00           H  
ATOM   1622  HB  ILE A 100    -101.600   9.831 -36.280  1.00  0.00           H  
ATOM   1623 HG12 ILE A 100    -100.292   9.594 -33.801  1.00  0.00           H  
ATOM   1624 HG13 ILE A 100     -99.084  10.270 -34.894  1.00  0.00           H  
ATOM   1625 HG21 ILE A 100    -102.188   7.761 -35.619  1.00  0.00           H  
ATOM   1626 HG22 ILE A 100    -101.023   7.896 -34.302  1.00  0.00           H  
ATOM   1627 HG23 ILE A 100    -100.539   7.180 -35.839  1.00  0.00           H  
ATOM   1628 HD11 ILE A 100    -101.743  11.400 -34.081  1.00  0.00           H  
ATOM   1629 HD12 ILE A 100    -101.058  11.836 -35.646  1.00  0.00           H  
ATOM   1630 HD13 ILE A 100    -100.173  12.198 -34.165  1.00  0.00           H  
ATOM   1631  N   ARG A 101     -99.772  11.067 -38.489  1.00  0.00           N  
ATOM   1632  CA  ARG A 101     -99.315  12.398 -38.987  1.00  0.00           C  
ATOM   1633  C   ARG A 101    -100.514  13.260 -39.394  1.00  0.00           C  
ATOM   1634  O   ARG A 101    -101.519  12.764 -39.863  1.00  0.00           O  
ATOM   1635  CB  ARG A 101     -98.446  12.087 -40.206  1.00  0.00           C  
ATOM   1636  CG  ARG A 101     -97.038  11.707 -39.746  1.00  0.00           C  
ATOM   1637  CD  ARG A 101     -96.015  12.200 -40.772  1.00  0.00           C  
ATOM   1638  NE  ARG A 101     -96.391  11.523 -42.045  1.00  0.00           N  
ATOM   1639  CZ  ARG A 101     -95.474  11.228 -42.924  1.00  0.00           C  
ATOM   1640  NH1 ARG A 101     -94.760  12.177 -43.466  1.00  0.00           N  
ATOM   1641  NH2 ARG A 101     -95.269   9.984 -43.263  1.00  0.00           N  
ATOM   1642  H   ARG A 101    -100.508  10.601 -38.937  1.00  0.00           H  
ATOM   1643  HA  ARG A 101     -98.727  12.900 -38.237  1.00  0.00           H  
ATOM   1644  HB2 ARG A 101     -98.880  11.265 -40.757  1.00  0.00           H  
ATOM   1645  HB3 ARG A 101     -98.393  12.957 -40.841  1.00  0.00           H  
ATOM   1646  HG2 ARG A 101     -96.837  12.164 -38.788  1.00  0.00           H  
ATOM   1647  HG3 ARG A 101     -96.966  10.633 -39.656  1.00  0.00           H  
ATOM   1648  HD2 ARG A 101     -96.080  13.273 -40.882  1.00  0.00           H  
ATOM   1649  HD3 ARG A 101     -95.018  11.908 -40.481  1.00  0.00           H  
ATOM   1650  HE  ARG A 101     -97.329  11.299 -42.222  1.00  0.00           H  
ATOM   1651 HH11 ARG A 101     -94.916  13.130 -43.207  1.00  0.00           H  
ATOM   1652 HH12 ARG A 101     -94.056  11.952 -44.140  1.00  0.00           H  
ATOM   1653 HH21 ARG A 101     -95.816   9.257 -42.848  1.00  0.00           H  
ATOM   1654 HH22 ARG A 101     -94.566   9.758 -43.937  1.00  0.00           H  
ATOM   1655  N   PHE A 102    -100.409  14.549 -39.222  1.00  0.00           N  
ATOM   1656  CA  PHE A 102    -101.535  15.450 -39.603  1.00  0.00           C  
ATOM   1657  C   PHE A 102    -100.981  16.798 -40.076  1.00  0.00           C  
ATOM   1658  O   PHE A 102     -99.943  17.236 -39.620  1.00  0.00           O  
ATOM   1659  CB  PHE A 102    -102.365  15.617 -38.328  1.00  0.00           C  
ATOM   1660  CG  PHE A 102    -101.445  15.837 -37.151  1.00  0.00           C  
ATOM   1661  CD1 PHE A 102    -100.878  14.740 -36.492  1.00  0.00           C  
ATOM   1662  CD2 PHE A 102    -101.160  17.137 -36.719  1.00  0.00           C  
ATOM   1663  CE1 PHE A 102    -100.025  14.943 -35.401  1.00  0.00           C  
ATOM   1664  CE2 PHE A 102    -100.308  17.341 -35.627  1.00  0.00           C  
ATOM   1665  CZ  PHE A 102     -99.740  16.243 -34.969  1.00  0.00           C  
ATOM   1666  H   PHE A 102     -99.587  14.927 -38.846  1.00  0.00           H  
ATOM   1667  HA  PHE A 102    -102.134  14.995 -40.376  1.00  0.00           H  
ATOM   1668  HB2 PHE A 102    -103.023  16.468 -38.435  1.00  0.00           H  
ATOM   1669  HB3 PHE A 102    -102.952  14.726 -38.163  1.00  0.00           H  
ATOM   1670  HD1 PHE A 102    -101.098  13.737 -36.826  1.00  0.00           H  
ATOM   1671  HD2 PHE A 102    -101.598  17.984 -37.227  1.00  0.00           H  
ATOM   1672  HE1 PHE A 102     -99.588  14.097 -34.893  1.00  0.00           H  
ATOM   1673  HE2 PHE A 102    -100.087  18.344 -35.294  1.00  0.00           H  
ATOM   1674  HZ  PHE A 102     -99.082  16.400 -34.127  1.00  0.00           H  
ATOM   1675  N   PRO A 103    -101.691  17.407 -40.987  1.00  0.00           N  
ATOM   1676  CA  PRO A 103    -101.261  18.716 -41.541  1.00  0.00           C  
ATOM   1677  C   PRO A 103    -101.443  19.834 -40.509  1.00  0.00           C  
ATOM   1678  O   PRO A 103    -102.247  19.733 -39.603  1.00  0.00           O  
ATOM   1679  CB  PRO A 103    -102.191  18.921 -42.733  1.00  0.00           C  
ATOM   1680  CG  PRO A 103    -103.406  18.106 -42.421  1.00  0.00           C  
ATOM   1681  CD  PRO A 103    -102.948  16.942 -41.580  1.00  0.00           C  
ATOM   1682  HA  PRO A 103    -100.238  18.670 -41.877  1.00  0.00           H  
ATOM   1683  HB2 PRO A 103    -102.452  19.966 -42.830  1.00  0.00           H  
ATOM   1684  HB3 PRO A 103    -101.729  18.562 -43.639  1.00  0.00           H  
ATOM   1685  HG2 PRO A 103    -104.119  18.704 -41.873  1.00  0.00           H  
ATOM   1686  HG3 PRO A 103    -103.852  17.741 -43.334  1.00  0.00           H  
ATOM   1687  HD2 PRO A 103    -103.678  16.724 -40.810  1.00  0.00           H  
ATOM   1688  HD3 PRO A 103    -102.771  16.074 -42.195  1.00  0.00           H  
ATOM   1689  N   VAL A 104    -100.701  20.900 -40.644  1.00  0.00           N  
ATOM   1690  CA  VAL A 104    -100.827  22.032 -39.680  1.00  0.00           C  
ATOM   1691  C   VAL A 104    -100.512  23.355 -40.382  1.00  0.00           C  
ATOM   1692  O   VAL A 104     -99.368  23.739 -40.523  1.00  0.00           O  
ATOM   1693  CB  VAL A 104     -99.795  21.751 -38.591  1.00  0.00           C  
ATOM   1694  CG1 VAL A 104    -100.395  20.804 -37.549  1.00  0.00           C  
ATOM   1695  CG2 VAL A 104     -98.557  21.103 -39.216  1.00  0.00           C  
ATOM   1696  H   VAL A 104    -100.062  20.959 -41.385  1.00  0.00           H  
ATOM   1697  HA  VAL A 104    -101.818  22.056 -39.254  1.00  0.00           H  
ATOM   1698  HB  VAL A 104     -99.519  22.679 -38.116  1.00  0.00           H  
ATOM   1699 HG11 VAL A 104    -101.460  20.971 -37.482  1.00  0.00           H  
ATOM   1700 HG12 VAL A 104     -99.939  20.990 -36.589  1.00  0.00           H  
ATOM   1701 HG13 VAL A 104    -100.209  19.781 -37.844  1.00  0.00           H  
ATOM   1702 HG21 VAL A 104     -98.802  20.105 -39.549  1.00  0.00           H  
ATOM   1703 HG22 VAL A 104     -97.768  21.053 -38.481  1.00  0.00           H  
ATOM   1704 HG23 VAL A 104     -98.228  21.694 -40.059  1.00  0.00           H  
ATOM   1705  N   SER A 105    -101.519  24.049 -40.828  1.00  0.00           N  
ATOM   1706  CA  SER A 105    -101.285  25.345 -41.528  1.00  0.00           C  
ATOM   1707  C   SER A 105    -101.374  26.516 -40.544  1.00  0.00           C  
ATOM   1708  O   SER A 105    -101.806  26.365 -39.420  1.00  0.00           O  
ATOM   1709  CB  SER A 105    -102.401  25.435 -42.568  1.00  0.00           C  
ATOM   1710  OG  SER A 105    -103.660  25.417 -41.907  1.00  0.00           O  
ATOM   1711  H   SER A 105    -102.432  23.718 -40.706  1.00  0.00           H  
ATOM   1712  HA  SER A 105    -100.326  25.338 -42.022  1.00  0.00           H  
ATOM   1713  HB2 SER A 105    -102.306  26.354 -43.122  1.00  0.00           H  
ATOM   1714  HB3 SER A 105    -102.327  24.597 -43.248  1.00  0.00           H  
ATOM   1715  HG  SER A 105    -103.977  24.510 -41.897  1.00  0.00           H  
ATOM   1716  N   ASP A 106    -100.974  27.685 -40.969  1.00  0.00           N  
ATOM   1717  CA  ASP A 106    -101.039  28.877 -40.074  1.00  0.00           C  
ATOM   1718  C   ASP A 106    -100.089  28.721 -38.884  1.00  0.00           C  
ATOM   1719  O   ASP A 106    -100.280  29.326 -37.847  1.00  0.00           O  
ATOM   1720  CB  ASP A 106    -102.489  28.938 -39.595  1.00  0.00           C  
ATOM   1721  CG  ASP A 106    -102.966  30.391 -39.594  1.00  0.00           C  
ATOM   1722  OD1 ASP A 106    -103.207  30.916 -40.669  1.00  0.00           O  
ATOM   1723  OD2 ASP A 106    -103.082  30.955 -38.519  1.00  0.00           O  
ATOM   1724  H   ASP A 106    -100.636  27.780 -41.884  1.00  0.00           H  
ATOM   1725  HA  ASP A 106    -100.801  29.772 -40.626  1.00  0.00           H  
ATOM   1726  HB2 ASP A 106    -103.112  28.353 -40.257  1.00  0.00           H  
ATOM   1727  HB3 ASP A 106    -102.554  28.540 -38.593  1.00  0.00           H  
ATOM   1728  N   GLY A 107     -99.065  27.926 -39.018  1.00  0.00           N  
ATOM   1729  CA  GLY A 107     -98.113  27.756 -37.884  1.00  0.00           C  
ATOM   1730  C   GLY A 107     -98.849  27.162 -36.683  1.00  0.00           C  
ATOM   1731  O   GLY A 107     -98.496  27.418 -35.549  1.00  0.00           O  
ATOM   1732  H   GLY A 107     -98.918  27.449 -39.862  1.00  0.00           H  
ATOM   1733  HA2 GLY A 107     -97.313  27.093 -38.182  1.00  0.00           H  
ATOM   1734  HA3 GLY A 107     -97.703  28.716 -37.611  1.00  0.00           H  
ATOM   1735  N   THR A 108     -99.881  26.389 -36.933  1.00  0.00           N  
ATOM   1736  CA  THR A 108    -100.678  25.769 -35.823  1.00  0.00           C  
ATOM   1737  C   THR A 108     -99.782  25.361 -34.650  1.00  0.00           C  
ATOM   1738  O   THR A 108     -98.852  24.594 -34.801  1.00  0.00           O  
ATOM   1739  CB  THR A 108    -101.317  24.529 -36.445  1.00  0.00           C  
ATOM   1740  OG1 THR A 108    -102.168  24.920 -37.512  1.00  0.00           O  
ATOM   1741  CG2 THR A 108    -102.131  23.785 -35.386  1.00  0.00           C  
ATOM   1742  H   THR A 108    -100.141  26.221 -37.862  1.00  0.00           H  
ATOM   1743  HA  THR A 108    -101.447  26.446 -35.491  1.00  0.00           H  
ATOM   1744  HB  THR A 108    -100.543  23.879 -36.820  1.00  0.00           H  
ATOM   1745  HG1 THR A 108    -102.268  24.170 -38.103  1.00  0.00           H  
ATOM   1746 HG21 THR A 108    -102.546  22.885 -35.817  1.00  0.00           H  
ATOM   1747 HG22 THR A 108    -102.933  24.419 -35.037  1.00  0.00           H  
ATOM   1748 HG23 THR A 108    -101.491  23.524 -34.557  1.00  0.00           H  
ATOM   1749  N   GLN A 109    -100.058  25.873 -33.483  1.00  0.00           N  
ATOM   1750  CA  GLN A 109     -99.226  25.519 -32.299  1.00  0.00           C  
ATOM   1751  C   GLN A 109    -100.101  24.952 -31.172  1.00  0.00           C  
ATOM   1752  O   GLN A 109     -99.605  24.536 -30.145  1.00  0.00           O  
ATOM   1753  CB  GLN A 109     -98.579  26.835 -31.864  1.00  0.00           C  
ATOM   1754  CG  GLN A 109     -97.346  26.543 -31.007  1.00  0.00           C  
ATOM   1755  CD  GLN A 109     -97.303  27.515 -29.826  1.00  0.00           C  
ATOM   1756  OE1 GLN A 109     -98.101  27.419 -28.915  1.00  0.00           O  
ATOM   1757  NE2 GLN A 109     -96.398  28.455 -29.804  1.00  0.00           N  
ATOM   1758  H   GLN A 109    -100.812  26.491 -33.384  1.00  0.00           H  
ATOM   1759  HA  GLN A 109     -98.463  24.809 -32.576  1.00  0.00           H  
ATOM   1760  HB2 GLN A 109     -98.285  27.396 -32.740  1.00  0.00           H  
ATOM   1761  HB3 GLN A 109     -99.287  27.412 -31.288  1.00  0.00           H  
ATOM   1762  HG2 GLN A 109     -97.397  25.529 -30.638  1.00  0.00           H  
ATOM   1763  HG3 GLN A 109     -96.455  26.664 -31.604  1.00  0.00           H  
ATOM   1764 HE21 GLN A 109     -95.754  28.533 -30.539  1.00  0.00           H  
ATOM   1765 HE22 GLN A 109     -96.362  29.082 -29.052  1.00  0.00           H  
ATOM   1766  N   GLU A 110    -101.396  24.931 -31.350  1.00  0.00           N  
ATOM   1767  CA  GLU A 110    -102.284  24.386 -30.283  1.00  0.00           C  
ATOM   1768  C   GLU A 110    -103.434  23.594 -30.903  1.00  0.00           C  
ATOM   1769  O   GLU A 110    -104.178  24.095 -31.724  1.00  0.00           O  
ATOM   1770  CB  GLU A 110    -102.816  25.611 -29.543  1.00  0.00           C  
ATOM   1771  CG  GLU A 110    -103.728  25.162 -28.399  1.00  0.00           C  
ATOM   1772  CD  GLU A 110    -104.648  26.315 -27.996  1.00  0.00           C  
ATOM   1773  OE1 GLU A 110    -104.520  27.380 -28.577  1.00  0.00           O  
ATOM   1774  OE2 GLU A 110    -105.465  26.114 -27.113  1.00  0.00           O  
ATOM   1775  H   GLU A 110    -101.786  25.269 -32.183  1.00  0.00           H  
ATOM   1776  HA  GLU A 110    -101.720  23.764 -29.606  1.00  0.00           H  
ATOM   1777  HB2 GLU A 110    -101.988  26.176 -29.143  1.00  0.00           H  
ATOM   1778  HB3 GLU A 110    -103.378  26.228 -30.228  1.00  0.00           H  
ATOM   1779  HG2 GLU A 110    -104.324  24.321 -28.724  1.00  0.00           H  
ATOM   1780  HG3 GLU A 110    -103.127  24.871 -27.552  1.00  0.00           H  
ATOM   1781  N   LEU A 111    -103.587  22.361 -30.512  1.00  0.00           N  
ATOM   1782  CA  LEU A 111    -104.692  21.529 -31.072  1.00  0.00           C  
ATOM   1783  C   LEU A 111    -105.345  20.706 -29.958  1.00  0.00           C  
ATOM   1784  O   LEU A 111    -104.679  20.203 -29.074  1.00  0.00           O  
ATOM   1785  CB  LEU A 111    -104.053  20.599 -32.114  1.00  0.00           C  
ATOM   1786  CG  LEU A 111    -102.527  20.584 -31.972  1.00  0.00           C  
ATOM   1787  CD1 LEU A 111    -101.971  19.324 -32.636  1.00  0.00           C  
ATOM   1788  CD2 LEU A 111    -101.941  21.818 -32.662  1.00  0.00           C  
ATOM   1789  H   LEU A 111    -102.978  21.984 -29.846  1.00  0.00           H  
ATOM   1790  HA  LEU A 111    -105.426  22.160 -31.548  1.00  0.00           H  
ATOM   1791  HB2 LEU A 111    -104.432  19.597 -31.974  1.00  0.00           H  
ATOM   1792  HB3 LEU A 111    -104.314  20.942 -33.104  1.00  0.00           H  
ATOM   1793  HG  LEU A 111    -102.257  20.585 -30.927  1.00  0.00           H  
ATOM   1794 HD11 LEU A 111    -101.414  19.599 -33.520  1.00  0.00           H  
ATOM   1795 HD12 LEU A 111    -102.787  18.673 -32.912  1.00  0.00           H  
ATOM   1796 HD13 LEU A 111    -101.319  18.811 -31.945  1.00  0.00           H  
ATOM   1797 HD21 LEU A 111    -101.389  21.513 -33.538  1.00  0.00           H  
ATOM   1798 HD22 LEU A 111    -101.280  22.332 -31.979  1.00  0.00           H  
ATOM   1799 HD23 LEU A 111    -102.744  22.480 -32.953  1.00  0.00           H  
ATOM   1800  N   LYS A 112    -106.640  20.563 -29.995  1.00  0.00           N  
ATOM   1801  CA  LYS A 112    -107.333  19.771 -28.939  1.00  0.00           C  
ATOM   1802  C   LYS A 112    -107.431  18.304 -29.361  1.00  0.00           C  
ATOM   1803  O   LYS A 112    -108.292  17.924 -30.130  1.00  0.00           O  
ATOM   1804  CB  LYS A 112    -108.726  20.392 -28.829  1.00  0.00           C  
ATOM   1805  CG  LYS A 112    -108.805  21.256 -27.567  1.00  0.00           C  
ATOM   1806  CD  LYS A 112    -107.651  22.265 -27.552  1.00  0.00           C  
ATOM   1807  CE  LYS A 112    -107.802  23.243 -28.720  1.00  0.00           C  
ATOM   1808  NZ  LYS A 112    -108.300  24.504 -28.104  1.00  0.00           N  
ATOM   1809  H   LYS A 112    -107.158  20.977 -30.717  1.00  0.00           H  
ATOM   1810  HA  LYS A 112    -106.814  19.857 -27.999  1.00  0.00           H  
ATOM   1811  HB2 LYS A 112    -108.916  21.004 -29.699  1.00  0.00           H  
ATOM   1812  HB3 LYS A 112    -109.465  19.608 -28.772  1.00  0.00           H  
ATOM   1813  HG2 LYS A 112    -109.746  21.787 -27.554  1.00  0.00           H  
ATOM   1814  HG3 LYS A 112    -108.737  20.624 -26.695  1.00  0.00           H  
ATOM   1815  HD2 LYS A 112    -107.667  22.814 -26.620  1.00  0.00           H  
ATOM   1816  HD3 LYS A 112    -106.711  21.742 -27.643  1.00  0.00           H  
ATOM   1817  HE2 LYS A 112    -106.844  23.407 -29.197  1.00  0.00           H  
ATOM   1818  HE3 LYS A 112    -108.520  22.871 -29.433  1.00  0.00           H  
ATOM   1819  HZ1 LYS A 112    -108.588  25.165 -28.853  1.00  0.00           H  
ATOM   1820  HZ2 LYS A 112    -107.544  24.934 -27.533  1.00  0.00           H  
ATOM   1821  HZ3 LYS A 112    -109.117  24.295 -27.497  1.00  0.00           H  
ATOM   1822  N   ILE A 113    -106.554  17.477 -28.864  1.00  0.00           N  
ATOM   1823  CA  ILE A 113    -106.594  16.035 -29.236  1.00  0.00           C  
ATOM   1824  C   ILE A 113    -107.820  15.358 -28.620  1.00  0.00           C  
ATOM   1825  O   ILE A 113    -108.129  15.548 -27.460  1.00  0.00           O  
ATOM   1826  CB  ILE A 113    -105.311  15.443 -28.653  1.00  0.00           C  
ATOM   1827  CG1 ILE A 113    -104.168  15.621 -29.654  1.00  0.00           C  
ATOM   1828  CG2 ILE A 113    -105.519  13.952 -28.375  1.00  0.00           C  
ATOM   1829  CD1 ILE A 113    -102.943  16.190 -28.934  1.00  0.00           C  
ATOM   1830  H   ILE A 113    -105.868  17.805 -28.247  1.00  0.00           H  
ATOM   1831  HA  ILE A 113    -106.597  15.920 -30.309  1.00  0.00           H  
ATOM   1832  HB  ILE A 113    -105.068  15.950 -27.731  1.00  0.00           H  
ATOM   1833 HG12 ILE A 113    -103.919  14.665 -30.090  1.00  0.00           H  
ATOM   1834 HG13 ILE A 113    -104.474  16.304 -30.432  1.00  0.00           H  
ATOM   1835 HG21 ILE A 113    -104.570  13.441 -28.429  1.00  0.00           H  
ATOM   1836 HG22 ILE A 113    -106.193  13.540 -29.110  1.00  0.00           H  
ATOM   1837 HG23 ILE A 113    -105.940  13.827 -27.388  1.00  0.00           H  
ATOM   1838 HD11 ILE A 113    -102.333  15.379 -28.567  1.00  0.00           H  
ATOM   1839 HD12 ILE A 113    -103.266  16.801 -28.105  1.00  0.00           H  
ATOM   1840 HD13 ILE A 113    -102.368  16.791 -29.622  1.00  0.00           H  
ATOM   1841  N   VAL A 114    -108.515  14.562 -29.385  1.00  0.00           N  
ATOM   1842  CA  VAL A 114    -109.716  13.864 -28.842  1.00  0.00           C  
ATOM   1843  C   VAL A 114    -109.555  12.353 -29.007  1.00  0.00           C  
ATOM   1844  O   VAL A 114    -109.515  11.843 -30.108  1.00  0.00           O  
ATOM   1845  CB  VAL A 114    -110.887  14.370 -29.685  1.00  0.00           C  
ATOM   1846  CG1 VAL A 114    -112.205  13.949 -29.033  1.00  0.00           C  
ATOM   1847  CG2 VAL A 114    -110.829  15.897 -29.773  1.00  0.00           C  
ATOM   1848  H   VAL A 114    -108.244  14.418 -30.316  1.00  0.00           H  
ATOM   1849  HA  VAL A 114    -109.867  14.120 -27.807  1.00  0.00           H  
ATOM   1850  HB  VAL A 114    -110.823  13.946 -30.677  1.00  0.00           H  
ATOM   1851 HG11 VAL A 114    -112.094  13.952 -27.959  1.00  0.00           H  
ATOM   1852 HG12 VAL A 114    -112.469  12.956 -29.364  1.00  0.00           H  
ATOM   1853 HG13 VAL A 114    -112.984  14.642 -29.316  1.00  0.00           H  
ATOM   1854 HG21 VAL A 114    -110.760  16.313 -28.779  1.00  0.00           H  
ATOM   1855 HG22 VAL A 114    -111.722  16.264 -30.256  1.00  0.00           H  
ATOM   1856 HG23 VAL A 114    -109.962  16.192 -30.347  1.00  0.00           H  
ATOM   1857  N   SER A 115    -109.460  11.632 -27.924  1.00  0.00           N  
ATOM   1858  CA  SER A 115    -109.298  10.155 -28.030  1.00  0.00           C  
ATOM   1859  C   SER A 115    -109.518   9.497 -26.665  1.00  0.00           C  
ATOM   1860  O   SER A 115    -109.604  10.160 -25.650  1.00  0.00           O  
ATOM   1861  CB  SER A 115    -107.858   9.949 -28.496  1.00  0.00           C  
ATOM   1862  OG  SER A 115    -106.968  10.383 -27.477  1.00  0.00           O  
ATOM   1863  H   SER A 115    -109.493  12.062 -27.044  1.00  0.00           H  
ATOM   1864  HA  SER A 115    -109.982   9.752 -28.759  1.00  0.00           H  
ATOM   1865  HB2 SER A 115    -107.687   8.904 -28.696  1.00  0.00           H  
ATOM   1866  HB3 SER A 115    -107.690  10.518 -29.401  1.00  0.00           H  
ATOM   1867  HG  SER A 115    -106.745   9.622 -26.935  1.00  0.00           H  
ATOM   1868  N   SER A 116    -109.606   8.195 -26.632  1.00  0.00           N  
ATOM   1869  CA  SER A 116    -109.816   7.492 -25.333  1.00  0.00           C  
ATOM   1870  C   SER A 116    -109.043   6.170 -25.325  1.00  0.00           C  
ATOM   1871  O   SER A 116    -109.296   5.288 -26.120  1.00  0.00           O  
ATOM   1872  CB  SER A 116    -111.319   7.235 -25.261  1.00  0.00           C  
ATOM   1873  OG  SER A 116    -111.553   5.982 -24.629  1.00  0.00           O  
ATOM   1874  H   SER A 116    -109.531   7.679 -27.461  1.00  0.00           H  
ATOM   1875  HA  SER A 116    -109.507   8.117 -24.511  1.00  0.00           H  
ATOM   1876  HB2 SER A 116    -111.794   8.014 -24.687  1.00  0.00           H  
ATOM   1877  HB3 SER A 116    -111.732   7.227 -26.262  1.00  0.00           H  
ATOM   1878  HG  SER A 116    -111.462   5.293 -25.292  1.00  0.00           H  
ATOM   1879  N   THR A 117    -108.098   6.028 -24.436  1.00  0.00           N  
ATOM   1880  CA  THR A 117    -107.311   4.763 -24.388  1.00  0.00           C  
ATOM   1881  C   THR A 117    -107.678   3.947 -23.147  1.00  0.00           C  
ATOM   1882  O   THR A 117    -108.114   4.479 -22.146  1.00  0.00           O  
ATOM   1883  CB  THR A 117    -105.849   5.208 -24.324  1.00  0.00           C  
ATOM   1884  OG1 THR A 117    -105.479   5.416 -22.968  1.00  0.00           O  
ATOM   1885  CG2 THR A 117    -105.672   6.508 -25.108  1.00  0.00           C  
ATOM   1886  H   THR A 117    -107.904   6.752 -23.805  1.00  0.00           H  
ATOM   1887  HA  THR A 117    -107.478   4.184 -25.282  1.00  0.00           H  
ATOM   1888  HB  THR A 117    -105.221   4.444 -24.755  1.00  0.00           H  
ATOM   1889  HG1 THR A 117    -104.552   5.663 -22.947  1.00  0.00           H  
ATOM   1890 HG21 THR A 117    -104.648   6.593 -25.438  1.00  0.00           H  
ATOM   1891 HG22 THR A 117    -105.916   7.347 -24.474  1.00  0.00           H  
ATOM   1892 HG23 THR A 117    -106.329   6.503 -25.966  1.00  0.00           H  
ATOM   1893  N   GLN A 118    -107.500   2.655 -23.205  1.00  0.00           N  
ATOM   1894  CA  GLN A 118    -107.832   1.798 -22.032  1.00  0.00           C  
ATOM   1895  C   GLN A 118    -106.807   0.667 -21.905  1.00  0.00           C  
ATOM   1896  O   GLN A 118    -106.493  -0.008 -22.865  1.00  0.00           O  
ATOM   1897  CB  GLN A 118    -109.221   1.231 -22.333  1.00  0.00           C  
ATOM   1898  CG  GLN A 118    -109.925   0.879 -21.020  1.00  0.00           C  
ATOM   1899  CD  GLN A 118    -110.764  -0.385 -21.213  1.00  0.00           C  
ATOM   1900  OE1 GLN A 118    -110.233  -1.475 -21.286  1.00  0.00           O  
ATOM   1901  NE2 GLN A 118    -112.062  -0.285 -21.299  1.00  0.00           N  
ATOM   1902  H   GLN A 118    -107.144   2.248 -24.023  1.00  0.00           H  
ATOM   1903  HA  GLN A 118    -107.860   2.386 -21.129  1.00  0.00           H  
ATOM   1904  HB2 GLN A 118    -109.802   1.969 -22.867  1.00  0.00           H  
ATOM   1905  HB3 GLN A 118    -109.125   0.342 -22.936  1.00  0.00           H  
ATOM   1906  HG2 GLN A 118    -109.185   0.708 -20.251  1.00  0.00           H  
ATOM   1907  HG3 GLN A 118    -110.568   1.695 -20.726  1.00  0.00           H  
ATOM   1908 HE21 GLN A 118    -112.490   0.595 -21.239  1.00  0.00           H  
ATOM   1909 HE22 GLN A 118    -112.610  -1.088 -21.423  1.00  0.00           H  
ATOM   1910  N   ILE A 119    -106.277   0.460 -20.730  1.00  0.00           N  
ATOM   1911  CA  ILE A 119    -105.268  -0.624 -20.550  1.00  0.00           C  
ATOM   1912  C   ILE A 119    -105.782  -1.678 -19.566  1.00  0.00           C  
ATOM   1913  O   ILE A 119    -105.018  -2.424 -18.987  1.00  0.00           O  
ATOM   1914  CB  ILE A 119    -104.032   0.078 -19.986  1.00  0.00           C  
ATOM   1915  CG1 ILE A 119    -103.590   1.180 -20.951  1.00  0.00           C  
ATOM   1916  CG2 ILE A 119    -102.900  -0.937 -19.818  1.00  0.00           C  
ATOM   1917  CD1 ILE A 119    -103.946   2.547 -20.364  1.00  0.00           C  
ATOM   1918  H   ILE A 119    -106.540   1.017 -19.968  1.00  0.00           H  
ATOM   1919  HA  ILE A 119    -105.031  -1.078 -21.498  1.00  0.00           H  
ATOM   1920  HB  ILE A 119    -104.273   0.512 -19.026  1.00  0.00           H  
ATOM   1921 HG12 ILE A 119    -102.522   1.119 -21.101  1.00  0.00           H  
ATOM   1922 HG13 ILE A 119    -104.094   1.054 -21.898  1.00  0.00           H  
ATOM   1923 HG21 ILE A 119    -103.051  -1.761 -20.500  1.00  0.00           H  
ATOM   1924 HG22 ILE A 119    -102.896  -1.305 -18.803  1.00  0.00           H  
ATOM   1925 HG23 ILE A 119    -101.956  -0.460 -20.032  1.00  0.00           H  
ATOM   1926 HD11 ILE A 119    -104.544   3.100 -21.075  1.00  0.00           H  
ATOM   1927 HD12 ILE A 119    -103.040   3.095 -20.152  1.00  0.00           H  
ATOM   1928 HD13 ILE A 119    -104.507   2.412 -19.452  1.00  0.00           H  
ATOM   1929  N   ASP A 120    -107.071  -1.747 -19.371  1.00  0.00           N  
ATOM   1930  CA  ASP A 120    -107.626  -2.758 -18.425  1.00  0.00           C  
ATOM   1931  C   ASP A 120    -107.019  -2.569 -17.031  1.00  0.00           C  
ATOM   1932  O   ASP A 120    -106.859  -3.512 -16.281  1.00  0.00           O  
ATOM   1933  CB  ASP A 120    -107.218  -4.111 -19.008  1.00  0.00           C  
ATOM   1934  CG  ASP A 120    -108.418  -5.058 -18.993  1.00  0.00           C  
ATOM   1935  OD1 ASP A 120    -109.176  -5.038 -19.949  1.00  0.00           O  
ATOM   1936  OD2 ASP A 120    -108.559  -5.789 -18.025  1.00  0.00           O  
ATOM   1937  H   ASP A 120    -107.672  -1.138 -19.847  1.00  0.00           H  
ATOM   1938  HA  ASP A 120    -108.700  -2.684 -18.382  1.00  0.00           H  
ATOM   1939  HB2 ASP A 120    -106.878  -3.976 -20.025  1.00  0.00           H  
ATOM   1940  HB3 ASP A 120    -106.421  -4.534 -18.416  1.00  0.00           H  
ATOM   1941  N   ASP A 121    -106.678  -1.360 -16.679  1.00  0.00           N  
ATOM   1942  CA  ASP A 121    -106.082  -1.113 -15.335  1.00  0.00           C  
ATOM   1943  C   ASP A 121    -107.188  -0.906 -14.298  1.00  0.00           C  
ATOM   1944  O   ASP A 121    -107.226  -1.561 -13.275  1.00  0.00           O  
ATOM   1945  CB  ASP A 121    -105.252   0.161 -15.498  1.00  0.00           C  
ATOM   1946  CG  ASP A 121    -104.035   0.100 -14.573  1.00  0.00           C  
ATOM   1947  OD1 ASP A 121    -104.142  -0.515 -13.526  1.00  0.00           O  
ATOM   1948  OD2 ASP A 121    -103.016   0.669 -14.930  1.00  0.00           O  
ATOM   1949  H   ASP A 121    -106.814  -0.612 -17.298  1.00  0.00           H  
ATOM   1950  HA  ASP A 121    -105.444  -1.935 -15.049  1.00  0.00           H  
ATOM   1951  HB2 ASP A 121    -104.923   0.247 -16.523  1.00  0.00           H  
ATOM   1952  HB3 ASP A 121    -105.855   1.018 -15.239  1.00  0.00           H  
ATOM   1953  N   GLY A 122    -108.092  -0.003 -14.557  1.00  0.00           N  
ATOM   1954  CA  GLY A 122    -109.198   0.246 -13.591  1.00  0.00           C  
ATOM   1955  C   GLY A 122    -110.347   0.954 -14.310  1.00  0.00           C  
ATOM   1956  O   GLY A 122    -111.367   0.362 -14.604  1.00  0.00           O  
ATOM   1957  H   GLY A 122    -108.045   0.512 -15.390  1.00  0.00           H  
ATOM   1958  HA2 GLY A 122    -109.546  -0.696 -13.192  1.00  0.00           H  
ATOM   1959  HA3 GLY A 122    -108.842   0.870 -12.786  1.00  0.00           H  
ATOM   1960  N   GLU A 123    -110.189   2.215 -14.600  1.00  0.00           N  
ATOM   1961  CA  GLU A 123    -111.271   2.960 -15.305  1.00  0.00           C  
ATOM   1962  C   GLU A 123    -110.925   3.103 -16.790  1.00  0.00           C  
ATOM   1963  O   GLU A 123    -110.188   2.311 -17.343  1.00  0.00           O  
ATOM   1964  CB  GLU A 123    -111.316   4.331 -14.629  1.00  0.00           C  
ATOM   1965  CG  GLU A 123    -110.009   5.079 -14.901  1.00  0.00           C  
ATOM   1966  CD  GLU A 123    -109.410   5.558 -13.578  1.00  0.00           C  
ATOM   1967  OE1 GLU A 123    -109.165   4.722 -12.724  1.00  0.00           O  
ATOM   1968  OE2 GLU A 123    -109.207   6.754 -13.441  1.00  0.00           O  
ATOM   1969  H   GLU A 123    -109.357   2.673 -14.356  1.00  0.00           H  
ATOM   1970  HA  GLU A 123    -112.216   2.457 -15.184  1.00  0.00           H  
ATOM   1971  HB2 GLU A 123    -112.146   4.899 -15.024  1.00  0.00           H  
ATOM   1972  HB3 GLU A 123    -111.441   4.204 -13.565  1.00  0.00           H  
ATOM   1973  HG2 GLU A 123    -109.311   4.416 -15.393  1.00  0.00           H  
ATOM   1974  HG3 GLU A 123    -110.206   5.930 -15.534  1.00  0.00           H  
ATOM   1975  N   GLU A 124    -111.447   4.106 -17.439  1.00  0.00           N  
ATOM   1976  CA  GLU A 124    -111.144   4.294 -18.887  1.00  0.00           C  
ATOM   1977  C   GLU A 124    -110.548   5.684 -19.126  1.00  0.00           C  
ATOM   1978  O   GLU A 124    -111.116   6.687 -18.744  1.00  0.00           O  
ATOM   1979  CB  GLU A 124    -112.492   4.159 -19.596  1.00  0.00           C  
ATOM   1980  CG  GLU A 124    -112.401   4.782 -20.990  1.00  0.00           C  
ATOM   1981  CD  GLU A 124    -113.229   3.955 -21.974  1.00  0.00           C  
ATOM   1982  OE1 GLU A 124    -113.284   2.747 -21.804  1.00  0.00           O  
ATOM   1983  OE2 GLU A 124    -113.794   4.541 -22.882  1.00  0.00           O  
ATOM   1984  H   GLU A 124    -112.040   4.735 -16.976  1.00  0.00           H  
ATOM   1985  HA  GLU A 124    -110.468   3.529 -19.232  1.00  0.00           H  
ATOM   1986  HB2 GLU A 124    -112.750   3.114 -19.683  1.00  0.00           H  
ATOM   1987  HB3 GLU A 124    -113.253   4.671 -19.024  1.00  0.00           H  
ATOM   1988  HG2 GLU A 124    -112.781   5.792 -20.958  1.00  0.00           H  
ATOM   1989  HG3 GLU A 124    -111.370   4.794 -21.312  1.00  0.00           H  
ATOM   1990  N   THR A 125    -109.406   5.750 -19.755  1.00  0.00           N  
ATOM   1991  CA  THR A 125    -108.774   7.075 -20.017  1.00  0.00           C  
ATOM   1992  C   THR A 125    -109.481   7.778 -21.178  1.00  0.00           C  
ATOM   1993  O   THR A 125    -109.169   7.556 -22.333  1.00  0.00           O  
ATOM   1994  CB  THR A 125    -107.324   6.758 -20.383  1.00  0.00           C  
ATOM   1995  OG1 THR A 125    -106.818   5.772 -19.494  1.00  0.00           O  
ATOM   1996  CG2 THR A 125    -106.477   8.026 -20.278  1.00  0.00           C  
ATOM   1997  H   THR A 125    -108.962   4.928 -20.054  1.00  0.00           H  
ATOM   1998  HA  THR A 125    -108.804   7.689 -19.130  1.00  0.00           H  
ATOM   1999  HB  THR A 125    -107.281   6.385 -21.396  1.00  0.00           H  
ATOM   2000  HG1 THR A 125    -105.867   5.890 -19.432  1.00  0.00           H  
ATOM   2001 HG21 THR A 125    -105.603   7.827 -19.677  1.00  0.00           H  
ATOM   2002 HG22 THR A 125    -107.060   8.811 -19.816  1.00  0.00           H  
ATOM   2003 HG23 THR A 125    -106.172   8.339 -21.266  1.00  0.00           H  
ATOM   2004  N   ASN A 126    -110.431   8.622 -20.885  1.00  0.00           N  
ATOM   2005  CA  ASN A 126    -111.156   9.337 -21.974  1.00  0.00           C  
ATOM   2006  C   ASN A 126    -110.689  10.793 -22.057  1.00  0.00           C  
ATOM   2007  O   ASN A 126    -111.042  11.616 -21.235  1.00  0.00           O  
ATOM   2008  CB  ASN A 126    -112.632   9.269 -21.580  1.00  0.00           C  
ATOM   2009  CG  ASN A 126    -113.496   9.759 -22.744  1.00  0.00           C  
ATOM   2010  OD1 ASN A 126    -113.897   8.982 -23.587  1.00  0.00           O  
ATOM   2011  ND2 ASN A 126    -113.801  11.025 -22.826  1.00  0.00           N  
ATOM   2012  H   ASN A 126    -110.668   8.787 -19.949  1.00  0.00           H  
ATOM   2013  HA  ASN A 126    -111.005   8.838 -22.918  1.00  0.00           H  
ATOM   2014  HB2 ASN A 126    -112.894   8.247 -21.341  1.00  0.00           H  
ATOM   2015  HB3 ASN A 126    -112.804   9.895 -20.718  1.00  0.00           H  
ATOM   2016 HD21 ASN A 126    -113.479  11.652 -22.146  1.00  0.00           H  
ATOM   2017 HD22 ASN A 126    -114.353  11.349 -23.568  1.00  0.00           H  
ATOM   2018  N   TYR A 127    -109.899  11.117 -23.043  1.00  0.00           N  
ATOM   2019  CA  TYR A 127    -109.411  12.521 -23.178  1.00  0.00           C  
ATOM   2020  C   TYR A 127    -110.470  13.385 -23.866  1.00  0.00           C  
ATOM   2021  O   TYR A 127    -110.358  13.711 -25.031  1.00  0.00           O  
ATOM   2022  CB  TYR A 127    -108.158  12.422 -24.048  1.00  0.00           C  
ATOM   2023  CG  TYR A 127    -107.038  11.803 -23.248  1.00  0.00           C  
ATOM   2024  CD1 TYR A 127    -106.544  12.458 -22.113  1.00  0.00           C  
ATOM   2025  CD2 TYR A 127    -106.492  10.575 -23.640  1.00  0.00           C  
ATOM   2026  CE1 TYR A 127    -105.505  11.884 -21.371  1.00  0.00           C  
ATOM   2027  CE2 TYR A 127    -105.454  10.001 -22.898  1.00  0.00           C  
ATOM   2028  CZ  TYR A 127    -104.960  10.656 -21.763  1.00  0.00           C  
ATOM   2029  OH  TYR A 127    -103.936  10.090 -21.032  1.00  0.00           O  
ATOM   2030  H   TYR A 127    -109.627  10.439 -23.696  1.00  0.00           H  
ATOM   2031  HA  TYR A 127    -109.159  12.927 -22.212  1.00  0.00           H  
ATOM   2032  HB2 TYR A 127    -108.365  11.809 -24.912  1.00  0.00           H  
ATOM   2033  HB3 TYR A 127    -107.865  13.411 -24.369  1.00  0.00           H  
ATOM   2034  HD1 TYR A 127    -106.965  13.406 -21.810  1.00  0.00           H  
ATOM   2035  HD2 TYR A 127    -106.875  10.070 -24.515  1.00  0.00           H  
ATOM   2036  HE1 TYR A 127    -105.123  12.389 -20.496  1.00  0.00           H  
ATOM   2037  HE2 TYR A 127    -105.033   9.054 -23.201  1.00  0.00           H  
ATOM   2038  HH  TYR A 127    -103.394   9.571 -21.632  1.00  0.00           H  
ATOM   2039  N   ASP A 128    -111.498  13.761 -23.156  1.00  0.00           N  
ATOM   2040  CA  ASP A 128    -112.558  14.605 -23.775  1.00  0.00           C  
ATOM   2041  C   ASP A 128    -111.942  15.881 -24.352  1.00  0.00           C  
ATOM   2042  O   ASP A 128    -112.363  16.377 -25.378  1.00  0.00           O  
ATOM   2043  CB  ASP A 128    -113.519  14.941 -22.634  1.00  0.00           C  
ATOM   2044  CG  ASP A 128    -114.236  16.257 -22.942  1.00  0.00           C  
ATOM   2045  OD1 ASP A 128    -113.703  17.296 -22.590  1.00  0.00           O  
ATOM   2046  OD2 ASP A 128    -115.307  16.204 -23.524  1.00  0.00           O  
ATOM   2047  H   ASP A 128    -111.572  13.489 -22.217  1.00  0.00           H  
ATOM   2048  HA  ASP A 128    -113.078  14.056 -24.545  1.00  0.00           H  
ATOM   2049  HB2 ASP A 128    -114.247  14.149 -22.532  1.00  0.00           H  
ATOM   2050  HB3 ASP A 128    -112.964  15.043 -21.714  1.00  0.00           H  
ATOM   2051  N   TYR A 129    -110.946  16.416 -23.699  1.00  0.00           N  
ATOM   2052  CA  TYR A 129    -110.303  17.660 -24.212  1.00  0.00           C  
ATOM   2053  C   TYR A 129    -108.827  17.703 -23.807  1.00  0.00           C  
ATOM   2054  O   TYR A 129    -108.494  17.952 -22.665  1.00  0.00           O  
ATOM   2055  CB  TYR A 129    -111.073  18.804 -23.551  1.00  0.00           C  
ATOM   2056  CG  TYR A 129    -110.231  20.056 -23.577  1.00  0.00           C  
ATOM   2057  CD1 TYR A 129    -110.192  20.850 -24.730  1.00  0.00           C  
ATOM   2058  CD2 TYR A 129    -109.490  20.426 -22.448  1.00  0.00           C  
ATOM   2059  CE1 TYR A 129    -109.412  22.012 -24.755  1.00  0.00           C  
ATOM   2060  CE2 TYR A 129    -108.709  21.588 -22.473  1.00  0.00           C  
ATOM   2061  CZ  TYR A 129    -108.670  22.381 -23.625  1.00  0.00           C  
ATOM   2062  OH  TYR A 129    -107.901  23.526 -23.651  1.00  0.00           O  
ATOM   2063  H   TYR A 129    -110.621  16.001 -22.874  1.00  0.00           H  
ATOM   2064  HA  TYR A 129    -110.403  17.721 -25.284  1.00  0.00           H  
ATOM   2065  HB2 TYR A 129    -111.993  18.977 -24.089  1.00  0.00           H  
ATOM   2066  HB3 TYR A 129    -111.296  18.543 -22.527  1.00  0.00           H  
ATOM   2067  HD1 TYR A 129    -110.763  20.565 -25.601  1.00  0.00           H  
ATOM   2068  HD2 TYR A 129    -109.520  19.815 -21.558  1.00  0.00           H  
ATOM   2069  HE1 TYR A 129    -109.382  22.624 -25.643  1.00  0.00           H  
ATOM   2070  HE2 TYR A 129    -108.137  21.873 -21.602  1.00  0.00           H  
ATOM   2071  HH  TYR A 129    -108.098  23.998 -24.462  1.00  0.00           H  
ATOM   2072  N   THR A 130    -107.940  17.466 -24.734  1.00  0.00           N  
ATOM   2073  CA  THR A 130    -106.487  17.498 -24.401  1.00  0.00           C  
ATOM   2074  C   THR A 130    -105.820  18.692 -25.089  1.00  0.00           C  
ATOM   2075  O   THR A 130    -105.614  18.695 -26.286  1.00  0.00           O  
ATOM   2076  CB  THR A 130    -105.926  16.182 -24.939  1.00  0.00           C  
ATOM   2077  OG1 THR A 130    -106.430  15.103 -24.164  1.00  0.00           O  
ATOM   2078  CG2 THR A 130    -104.399  16.202 -24.856  1.00  0.00           C  
ATOM   2079  H   THR A 130    -108.229  17.270 -25.649  1.00  0.00           H  
ATOM   2080  HA  THR A 130    -106.346  17.551 -23.332  1.00  0.00           H  
ATOM   2081  HB  THR A 130    -106.225  16.057 -25.968  1.00  0.00           H  
ATOM   2082  HG1 THR A 130    -106.348  15.340 -23.238  1.00  0.00           H  
ATOM   2083 HG21 THR A 130    -104.004  15.285 -25.267  1.00  0.00           H  
ATOM   2084 HG22 THR A 130    -104.096  16.294 -23.823  1.00  0.00           H  
ATOM   2085 HG23 THR A 130    -104.019  17.042 -25.419  1.00  0.00           H  
ATOM   2086  N   LYS A 131    -105.489  19.710 -24.341  1.00  0.00           N  
ATOM   2087  CA  LYS A 131    -104.844  20.907 -24.952  1.00  0.00           C  
ATOM   2088  C   LYS A 131    -103.357  20.643 -25.202  1.00  0.00           C  
ATOM   2089  O   LYS A 131    -102.536  20.765 -24.315  1.00  0.00           O  
ATOM   2090  CB  LYS A 131    -105.023  22.020 -23.920  1.00  0.00           C  
ATOM   2091  CG  LYS A 131    -104.155  23.220 -24.303  1.00  0.00           C  
ATOM   2092  CD  LYS A 131    -104.948  24.512 -24.096  1.00  0.00           C  
ATOM   2093  CE  LYS A 131    -104.058  25.716 -24.409  1.00  0.00           C  
ATOM   2094  NZ  LYS A 131    -103.763  26.329 -23.083  1.00  0.00           N  
ATOM   2095  H   LYS A 131    -105.671  19.689 -23.378  1.00  0.00           H  
ATOM   2096  HA  LYS A 131    -105.339  21.174 -25.871  1.00  0.00           H  
ATOM   2097  HB2 LYS A 131    -106.061  22.320 -23.891  1.00  0.00           H  
ATOM   2098  HB3 LYS A 131    -104.725  21.661 -22.946  1.00  0.00           H  
ATOM   2099  HG2 LYS A 131    -103.270  23.237 -23.683  1.00  0.00           H  
ATOM   2100  HG3 LYS A 131    -103.867  23.140 -25.341  1.00  0.00           H  
ATOM   2101  HD2 LYS A 131    -105.806  24.516 -24.756  1.00  0.00           H  
ATOM   2102  HD3 LYS A 131    -105.283  24.569 -23.071  1.00  0.00           H  
ATOM   2103  HE2 LYS A 131    -103.144  25.392 -24.888  1.00  0.00           H  
ATOM   2104  HE3 LYS A 131    -104.583  26.421 -25.033  1.00  0.00           H  
ATOM   2105  HZ1 LYS A 131    -103.211  27.199 -23.220  1.00  0.00           H  
ATOM   2106  HZ2 LYS A 131    -103.217  25.658 -22.505  1.00  0.00           H  
ATOM   2107  HZ3 LYS A 131    -104.655  26.558 -22.601  1.00  0.00           H  
ATOM   2108  N   LEU A 132    -103.003  20.284 -26.406  1.00  0.00           N  
ATOM   2109  CA  LEU A 132    -101.569  20.018 -26.713  1.00  0.00           C  
ATOM   2110  C   LEU A 132    -100.959  21.216 -27.443  1.00  0.00           C  
ATOM   2111  O   LEU A 132    -101.123  21.379 -28.636  1.00  0.00           O  
ATOM   2112  CB  LEU A 132    -101.574  18.787 -27.617  1.00  0.00           C  
ATOM   2113  CG  LEU A 132    -100.160  18.546 -28.154  1.00  0.00           C  
ATOM   2114  CD1 LEU A 132     -99.871  17.044 -28.185  1.00  0.00           C  
ATOM   2115  CD2 LEU A 132    -100.045  19.114 -29.571  1.00  0.00           C  
ATOM   2116  H   LEU A 132    -103.680  20.195 -27.109  1.00  0.00           H  
ATOM   2117  HA  LEU A 132    -101.022  19.810 -25.807  1.00  0.00           H  
ATOM   2118  HB2 LEU A 132    -101.899  17.926 -27.051  1.00  0.00           H  
ATOM   2119  HB3 LEU A 132    -102.248  18.950 -28.444  1.00  0.00           H  
ATOM   2120  HG  LEU A 132     -99.444  19.035 -27.508  1.00  0.00           H  
ATOM   2121 HD11 LEU A 132     -98.806  16.882 -28.116  1.00  0.00           H  
ATOM   2122 HD12 LEU A 132    -100.240  16.626 -29.109  1.00  0.00           H  
ATOM   2123 HD13 LEU A 132    -100.363  16.565 -27.351  1.00  0.00           H  
ATOM   2124 HD21 LEU A 132    -101.014  19.455 -29.903  1.00  0.00           H  
ATOM   2125 HD22 LEU A 132     -99.684  18.346 -30.237  1.00  0.00           H  
ATOM   2126 HD23 LEU A 132     -99.353  19.944 -29.570  1.00  0.00           H  
ATOM   2127  N   VAL A 133    -100.257  22.057 -26.737  1.00  0.00           N  
ATOM   2128  CA  VAL A 133     -99.639  23.243 -27.394  1.00  0.00           C  
ATOM   2129  C   VAL A 133     -98.233  22.900 -27.891  1.00  0.00           C  
ATOM   2130  O   VAL A 133     -97.312  22.738 -27.115  1.00  0.00           O  
ATOM   2131  CB  VAL A 133     -99.578  24.312 -26.303  1.00  0.00           C  
ATOM   2132  CG1 VAL A 133     -98.664  25.452 -26.755  1.00  0.00           C  
ATOM   2133  CG2 VAL A 133    -100.984  24.858 -26.047  1.00  0.00           C  
ATOM   2134  H   VAL A 133    -100.137  21.911 -25.775  1.00  0.00           H  
ATOM   2135  HA  VAL A 133    -100.255  23.586 -28.210  1.00  0.00           H  
ATOM   2136  HB  VAL A 133     -99.188  23.876 -25.395  1.00  0.00           H  
ATOM   2137 HG11 VAL A 133     -99.045  26.390 -26.380  1.00  0.00           H  
ATOM   2138 HG12 VAL A 133     -98.632  25.482 -27.834  1.00  0.00           H  
ATOM   2139 HG13 VAL A 133     -97.668  25.290 -26.370  1.00  0.00           H  
ATOM   2140 HG21 VAL A 133    -101.053  25.213 -25.030  1.00  0.00           H  
ATOM   2141 HG22 VAL A 133    -101.709  24.073 -26.205  1.00  0.00           H  
ATOM   2142 HG23 VAL A 133    -101.183  25.674 -26.727  1.00  0.00           H  
ATOM   2143  N   PHE A 134     -98.064  22.791 -29.182  1.00  0.00           N  
ATOM   2144  CA  PHE A 134     -96.719  22.463 -29.739  1.00  0.00           C  
ATOM   2145  C   PHE A 134     -95.653  23.356 -29.102  1.00  0.00           C  
ATOM   2146  O   PHE A 134     -95.952  24.394 -28.548  1.00  0.00           O  
ATOM   2147  CB  PHE A 134     -96.825  22.772 -31.233  1.00  0.00           C  
ATOM   2148  CG  PHE A 134     -97.359  21.571 -31.975  1.00  0.00           C  
ATOM   2149  CD1 PHE A 134     -96.810  20.303 -31.746  1.00  0.00           C  
ATOM   2150  CD2 PHE A 134     -98.398  21.730 -32.897  1.00  0.00           C  
ATOM   2151  CE1 PHE A 134     -97.304  19.193 -32.443  1.00  0.00           C  
ATOM   2152  CE2 PHE A 134     -98.892  20.622 -33.592  1.00  0.00           C  
ATOM   2153  CZ  PHE A 134     -98.345  19.353 -33.367  1.00  0.00           C  
ATOM   2154  H   PHE A 134     -98.823  22.928 -29.787  1.00  0.00           H  
ATOM   2155  HA  PHE A 134     -96.487  21.421 -29.590  1.00  0.00           H  
ATOM   2156  HB2 PHE A 134     -97.494  23.607 -31.378  1.00  0.00           H  
ATOM   2157  HB3 PHE A 134     -95.848  23.024 -31.616  1.00  0.00           H  
ATOM   2158  HD1 PHE A 134     -96.007  20.182 -31.035  1.00  0.00           H  
ATOM   2159  HD2 PHE A 134     -98.820  22.708 -33.072  1.00  0.00           H  
ATOM   2160  HE1 PHE A 134     -96.882  18.216 -32.268  1.00  0.00           H  
ATOM   2161  HE2 PHE A 134     -99.694  20.747 -34.304  1.00  0.00           H  
ATOM   2162  HZ  PHE A 134     -98.726  18.497 -33.904  1.00  0.00           H  
ATOM   2163  N   ALA A 135     -94.410  22.974 -29.197  1.00  0.00           N  
ATOM   2164  CA  ALA A 135     -93.334  23.821 -28.619  1.00  0.00           C  
ATOM   2165  C   ALA A 135     -93.155  25.056 -29.499  1.00  0.00           C  
ATOM   2166  O   ALA A 135     -92.728  26.102 -29.051  1.00  0.00           O  
ATOM   2167  CB  ALA A 135     -92.077  22.949 -28.647  1.00  0.00           C  
ATOM   2168  H   ALA A 135     -94.186  22.146 -29.665  1.00  0.00           H  
ATOM   2169  HA  ALA A 135     -93.573  24.103 -27.606  1.00  0.00           H  
ATOM   2170  HB1 ALA A 135     -91.528  23.138 -29.558  1.00  0.00           H  
ATOM   2171  HB2 ALA A 135     -92.360  21.908 -28.605  1.00  0.00           H  
ATOM   2172  HB3 ALA A 135     -91.455  23.188 -27.796  1.00  0.00           H  
ATOM   2173  N   LYS A 136     -93.494  24.938 -30.756  1.00  0.00           N  
ATOM   2174  CA  LYS A 136     -93.365  26.093 -31.683  1.00  0.00           C  
ATOM   2175  C   LYS A 136     -94.399  25.970 -32.807  1.00  0.00           C  
ATOM   2176  O   LYS A 136     -94.994  24.926 -32.988  1.00  0.00           O  
ATOM   2177  CB  LYS A 136     -91.944  26.002 -32.240  1.00  0.00           C  
ATOM   2178  CG  LYS A 136     -91.073  27.078 -31.592  1.00  0.00           C  
ATOM   2179  CD  LYS A 136     -89.603  26.804 -31.910  1.00  0.00           C  
ATOM   2180  CE  LYS A 136     -88.717  27.688 -31.029  1.00  0.00           C  
ATOM   2181  NZ  LYS A 136     -87.321  27.306 -31.381  1.00  0.00           N  
ATOM   2182  H   LYS A 136     -93.841  24.085 -31.089  1.00  0.00           H  
ATOM   2183  HA  LYS A 136     -93.496  27.017 -31.147  1.00  0.00           H  
ATOM   2184  HB2 LYS A 136     -91.534  25.026 -32.024  1.00  0.00           H  
ATOM   2185  HB3 LYS A 136     -91.966  26.153 -33.309  1.00  0.00           H  
ATOM   2186  HG2 LYS A 136     -91.352  28.047 -31.979  1.00  0.00           H  
ATOM   2187  HG3 LYS A 136     -91.217  27.062 -30.522  1.00  0.00           H  
ATOM   2188  HD2 LYS A 136     -89.380  25.764 -31.716  1.00  0.00           H  
ATOM   2189  HD3 LYS A 136     -89.410  27.026 -32.949  1.00  0.00           H  
ATOM   2190  HE2 LYS A 136     -88.892  28.732 -31.251  1.00  0.00           H  
ATOM   2191  HE3 LYS A 136     -88.904  27.487 -29.986  1.00  0.00           H  
ATOM   2192  HZ1 LYS A 136     -87.034  27.800 -32.249  1.00  0.00           H  
ATOM   2193  HZ2 LYS A 136     -87.271  26.278 -31.534  1.00  0.00           H  
ATOM   2194  HZ3 LYS A 136     -86.682  27.573 -30.606  1.00  0.00           H  
ATOM   2195  N   PRO A 137     -94.584  27.045 -33.521  1.00  0.00           N  
ATOM   2196  CA  PRO A 137     -95.563  27.059 -34.637  1.00  0.00           C  
ATOM   2197  C   PRO A 137     -95.041  26.243 -35.822  1.00  0.00           C  
ATOM   2198  O   PRO A 137     -93.906  26.381 -36.232  1.00  0.00           O  
ATOM   2199  CB  PRO A 137     -95.672  28.538 -34.998  1.00  0.00           C  
ATOM   2200  CG  PRO A 137     -94.382  29.143 -34.544  1.00  0.00           C  
ATOM   2201  CD  PRO A 137     -93.906  28.336 -33.364  1.00  0.00           C  
ATOM   2202  HA  PRO A 137     -96.519  26.687 -34.309  1.00  0.00           H  
ATOM   2203  HB2 PRO A 137     -95.791  28.654 -36.066  1.00  0.00           H  
ATOM   2204  HB3 PRO A 137     -96.498  28.993 -34.474  1.00  0.00           H  
ATOM   2205  HG2 PRO A 137     -93.655  29.099 -35.342  1.00  0.00           H  
ATOM   2206  HG3 PRO A 137     -94.540  30.168 -34.243  1.00  0.00           H  
ATOM   2207  HD2 PRO A 137     -92.832  28.211 -33.401  1.00  0.00           H  
ATOM   2208  HD3 PRO A 137     -94.204  28.803 -32.438  1.00  0.00           H  
ATOM   2209  N   ILE A 138     -95.863  25.393 -36.377  1.00  0.00           N  
ATOM   2210  CA  ILE A 138     -95.410  24.571 -37.534  1.00  0.00           C  
ATOM   2211  C   ILE A 138     -95.693  25.305 -38.848  1.00  0.00           C  
ATOM   2212  O   ILE A 138     -96.790  25.265 -39.369  1.00  0.00           O  
ATOM   2213  CB  ILE A 138     -96.230  23.284 -37.453  1.00  0.00           C  
ATOM   2214  CG1 ILE A 138     -96.192  22.746 -36.020  1.00  0.00           C  
ATOM   2215  CG2 ILE A 138     -95.638  22.243 -38.404  1.00  0.00           C  
ATOM   2216  CD1 ILE A 138     -94.743  22.459 -35.620  1.00  0.00           C  
ATOM   2217  H   ILE A 138     -96.776  25.293 -36.031  1.00  0.00           H  
ATOM   2218  HA  ILE A 138     -94.360  24.345 -37.445  1.00  0.00           H  
ATOM   2219  HB  ILE A 138     -97.252  23.490 -37.735  1.00  0.00           H  
ATOM   2220 HG12 ILE A 138     -96.614  23.479 -35.349  1.00  0.00           H  
ATOM   2221 HG13 ILE A 138     -96.766  21.833 -35.964  1.00  0.00           H  
ATOM   2222 HG21 ILE A 138     -94.620  22.511 -38.641  1.00  0.00           H  
ATOM   2223 HG22 ILE A 138     -96.223  22.211 -39.310  1.00  0.00           H  
ATOM   2224 HG23 ILE A 138     -95.654  21.273 -37.930  1.00  0.00           H  
ATOM   2225 HD11 ILE A 138     -94.666  21.449 -35.248  1.00  0.00           H  
ATOM   2226 HD12 ILE A 138     -94.440  23.152 -34.850  1.00  0.00           H  
ATOM   2227 HD13 ILE A 138     -94.103  22.575 -36.482  1.00  0.00           H  
ATOM   2228  N   TYR A 139     -94.712  25.973 -39.390  1.00  0.00           N  
ATOM   2229  CA  TYR A 139     -94.926  26.707 -40.671  1.00  0.00           C  
ATOM   2230  C   TYR A 139     -94.274  25.946 -41.829  1.00  0.00           C  
ATOM   2231  O   TYR A 139     -93.080  25.725 -41.847  1.00  0.00           O  
ATOM   2232  CB  TYR A 139     -94.249  28.062 -40.472  1.00  0.00           C  
ATOM   2233  CG  TYR A 139     -95.225  29.026 -39.839  1.00  0.00           C  
ATOM   2234  CD1 TYR A 139     -96.389  29.394 -40.526  1.00  0.00           C  
ATOM   2235  CD2 TYR A 139     -94.968  29.549 -38.568  1.00  0.00           C  
ATOM   2236  CE1 TYR A 139     -97.294  30.287 -39.939  1.00  0.00           C  
ATOM   2237  CE2 TYR A 139     -95.873  30.441 -37.981  1.00  0.00           C  
ATOM   2238  CZ  TYR A 139     -97.036  30.811 -38.666  1.00  0.00           C  
ATOM   2239  OH  TYR A 139     -97.928  31.691 -38.087  1.00  0.00           O  
ATOM   2240  H   TYR A 139     -93.833  25.993 -38.956  1.00  0.00           H  
ATOM   2241  HA  TYR A 139     -95.979  26.845 -40.855  1.00  0.00           H  
ATOM   2242  HB2 TYR A 139     -93.390  27.944 -39.826  1.00  0.00           H  
ATOM   2243  HB3 TYR A 139     -93.930  28.450 -41.427  1.00  0.00           H  
ATOM   2244  HD1 TYR A 139     -96.589  28.991 -41.507  1.00  0.00           H  
ATOM   2245  HD2 TYR A 139     -94.070  29.264 -38.037  1.00  0.00           H  
ATOM   2246  HE1 TYR A 139     -98.193  30.571 -40.467  1.00  0.00           H  
ATOM   2247  HE2 TYR A 139     -95.673  30.845 -36.999  1.00  0.00           H  
ATOM   2248  HH  TYR A 139     -98.614  31.884 -38.731  1.00  0.00           H  
ATOM   2249  N   ASN A 140     -95.051  25.542 -42.797  1.00  0.00           N  
ATOM   2250  CA  ASN A 140     -94.477  24.795 -43.953  1.00  0.00           C  
ATOM   2251  C   ASN A 140     -93.411  25.639 -44.656  1.00  0.00           C  
ATOM   2252  O   ASN A 140     -93.363  26.845 -44.508  1.00  0.00           O  
ATOM   2253  CB  ASN A 140     -95.660  24.540 -44.887  1.00  0.00           C  
ATOM   2254  CG  ASN A 140     -95.155  24.410 -46.326  1.00  0.00           C  
ATOM   2255  OD1 ASN A 140     -94.898  25.400 -46.983  1.00  0.00           O  
ATOM   2256  ND2 ASN A 140     -95.003  23.223 -46.847  1.00  0.00           N  
ATOM   2257  H   ASN A 140     -96.012  25.729 -42.763  1.00  0.00           H  
ATOM   2258  HA  ASN A 140     -94.059  23.857 -43.624  1.00  0.00           H  
ATOM   2259  HB2 ASN A 140     -96.158  23.627 -44.596  1.00  0.00           H  
ATOM   2260  HB3 ASN A 140     -96.353  25.365 -44.824  1.00  0.00           H  
ATOM   2261 HD21 ASN A 140     -95.212  22.426 -46.316  1.00  0.00           H  
ATOM   2262 HD22 ASN A 140     -94.680  23.130 -47.767  1.00  0.00           H  
ATOM   2263  N   ASP A 141     -92.557  25.015 -45.420  1.00  0.00           N  
ATOM   2264  CA  ASP A 141     -91.496  25.780 -46.135  1.00  0.00           C  
ATOM   2265  C   ASP A 141     -91.727  25.707 -47.648  1.00  0.00           C  
ATOM   2266  O   ASP A 141     -91.222  24.822 -48.311  1.00  0.00           O  
ATOM   2267  CB  ASP A 141     -90.186  25.089 -45.757  1.00  0.00           C  
ATOM   2268  CG  ASP A 141     -89.401  25.975 -44.789  1.00  0.00           C  
ATOM   2269  OD1 ASP A 141     -89.662  25.898 -43.600  1.00  0.00           O  
ATOM   2270  OD2 ASP A 141     -88.550  26.717 -45.253  1.00  0.00           O  
ATOM   2271  H   ASP A 141     -92.616  24.042 -45.526  1.00  0.00           H  
ATOM   2272  HA  ASP A 141     -91.482  26.806 -45.804  1.00  0.00           H  
ATOM   2273  HB2 ASP A 141     -90.403  24.141 -45.284  1.00  0.00           H  
ATOM   2274  HB3 ASP A 141     -89.597  24.920 -46.646  1.00  0.00           H  
ATOM   2275  N   PRO A 142     -92.489  26.645 -48.140  1.00  0.00           N  
ATOM   2276  CA  PRO A 142     -92.801  26.695 -49.589  1.00  0.00           C  
ATOM   2277  C   PRO A 142     -91.575  27.145 -50.393  1.00  0.00           C  
ATOM   2278  O   PRO A 142     -91.514  26.975 -51.594  1.00  0.00           O  
ATOM   2279  CB  PRO A 142     -93.919  27.731 -49.678  1.00  0.00           C  
ATOM   2280  CG  PRO A 142     -93.742  28.597 -48.473  1.00  0.00           C  
ATOM   2281  CD  PRO A 142     -93.127  27.738 -47.397  1.00  0.00           C  
ATOM   2282  HA  PRO A 142     -93.155  25.739 -49.937  1.00  0.00           H  
ATOM   2283  HB2 PRO A 142     -93.817  28.314 -50.583  1.00  0.00           H  
ATOM   2284  HB3 PRO A 142     -94.882  27.247 -49.648  1.00  0.00           H  
ATOM   2285  HG2 PRO A 142     -93.087  29.425 -48.708  1.00  0.00           H  
ATOM   2286  HG3 PRO A 142     -94.700  28.965 -48.139  1.00  0.00           H  
ATOM   2287  HD2 PRO A 142     -92.392  28.302 -46.839  1.00  0.00           H  
ATOM   2288  HD3 PRO A 142     -93.888  27.348 -46.741  1.00  0.00           H  
ATOM   2289  N   SER A 143     -90.598  27.715 -49.741  1.00  0.00           N  
ATOM   2290  CA  SER A 143     -89.381  28.170 -50.473  1.00  0.00           C  
ATOM   2291  C   SER A 143     -88.137  27.495 -49.891  1.00  0.00           C  
ATOM   2292  O   SER A 143     -87.199  27.182 -50.598  1.00  0.00           O  
ATOM   2293  CB  SER A 143     -89.328  29.681 -50.251  1.00  0.00           C  
ATOM   2294  OG  SER A 143     -90.345  30.305 -51.024  1.00  0.00           O  
ATOM   2295  H   SER A 143     -90.662  27.843 -48.771  1.00  0.00           H  
ATOM   2296  HA  SER A 143     -89.471  27.954 -51.525  1.00  0.00           H  
ATOM   2297  HB2 SER A 143     -89.489  29.900 -49.209  1.00  0.00           H  
ATOM   2298  HB3 SER A 143     -88.355  30.052 -50.548  1.00  0.00           H  
ATOM   2299  HG  SER A 143     -90.962  29.626 -51.307  1.00  0.00           H  
ATOM   2300  N   LEU A 144     -88.123  27.269 -48.607  1.00  0.00           N  
ATOM   2301  CA  LEU A 144     -86.942  26.614 -47.977  1.00  0.00           C  
ATOM   2302  C   LEU A 144     -85.691  27.474 -48.171  1.00  0.00           C  
ATOM   2303  O   LEU A 144     -84.615  27.003 -47.841  1.00  0.00           O  
ATOM   2304  CB  LEU A 144     -86.794  25.277 -48.706  1.00  0.00           C  
ATOM   2305  CG  LEU A 144     -86.784  24.137 -47.688  1.00  0.00           C  
ATOM   2306  CD1 LEU A 144     -87.239  22.842 -48.364  1.00  0.00           C  
ATOM   2307  CD2 LEU A 144     -85.367  23.953 -47.144  1.00  0.00           C  
ATOM   2308  OXT LEU A 144     -85.830  28.588 -48.649  1.00  0.00           O  
ATOM   2309  H   LEU A 144     -88.890  27.529 -48.054  1.00  0.00           H  
ATOM   2310  HA  LEU A 144     -87.124  26.442 -46.929  1.00  0.00           H  
ATOM   2311  HB2 LEU A 144     -87.622  25.146 -49.388  1.00  0.00           H  
ATOM   2312  HB3 LEU A 144     -85.868  25.270 -49.261  1.00  0.00           H  
ATOM   2313  HG  LEU A 144     -87.457  24.374 -46.876  1.00  0.00           H  
ATOM   2314 HD11 LEU A 144     -88.146  23.027 -48.922  1.00  0.00           H  
ATOM   2315 HD12 LEU A 144     -87.428  22.090 -47.612  1.00  0.00           H  
ATOM   2316 HD13 LEU A 144     -86.467  22.496 -49.035  1.00  0.00           H  
ATOM   2317 HD21 LEU A 144     -85.352  23.127 -46.448  1.00  0.00           H  
ATOM   2318 HD22 LEU A 144     -85.056  24.855 -46.636  1.00  0.00           H  
ATOM   2319 HD23 LEU A 144     -84.691  23.749 -47.960  1.00  0.00           H  
TER    2320      LEU A 144                                                      
END
MOLECULE T0514.pdb
ATOM   7695  N   SER     1     -73.106  18.033 -40.322  1.00 86.00           N  
ATOM   7696  CA  SER     1     -73.011  18.711 -38.995  1.00 85.50           C  
ATOM   7697  C   SER     1     -74.354  19.367 -38.664  1.00 79.83           C  
ATOM   7698  O   SER     1     -74.616  20.512 -39.038  1.00 86.46           O  
ATOM   7699  CB  SER     1     -71.867  19.728 -38.999  1.00 86.33           C  
ATOM   7700  OG  SER     1     -71.212  19.767 -37.742  1.00 88.81           O  
ATOM   7701  N   SER     2     -75.186  18.622 -37.940  1.00 70.86           N  
ATOM   7702  CA  SER     2     -76.629  18.868 -37.847  1.00 70.05           C  
ATOM   7703  C   SER     2     -77.049  19.675 -36.613  1.00 66.08           C  
ATOM   7704  O   SER     2     -77.518  19.116 -35.621  1.00 67.53           O  
ATOM   7705  CB  SER     2     -77.364  17.524 -37.883  1.00 72.15           C  
ATOM   7706  OG  SER     2     -78.761  17.686 -37.715  1.00 76.65           O  
ATOM   7707  N   LEU     3     -76.905  20.994 -36.702  1.00 57.90           N  
ATOM   7708  CA  LEU     3     -77.150  21.891 -35.579  1.00 49.32           C  
ATOM   7709  C   LEU     3     -78.641  22.135 -35.344  1.00 45.20           C  
ATOM   7710  O   LEU     3     -79.395  22.383 -36.285  1.00 46.29           O  
ATOM   7711  CB  LEU     3     -76.427  23.218 -35.823  1.00 50.89           C  
ATOM   7712  CG  LEU     3     -75.688  23.894 -34.673  1.00 48.11           C  
ATOM   7713  CD1 LEU     3     -74.641  22.973 -34.089  1.00 51.21           C  
ATOM   7714  CD2 LEU     3     -75.040  25.155 -35.184  1.00 47.04           C  
ATOM   7715  N   THR     4     -79.051  22.068 -34.078  1.00 40.66           N  
ATOM   7716  CA  THR     4     -80.445  22.293 -33.688  1.00 38.62           C  
ATOM   7717  C   THR     4     -80.772  23.788 -33.633  1.00 40.67           C  
ATOM   7718  O   THR     4     -80.086  24.559 -32.951  1.00 39.89           O  
ATOM   7719  CB  THR     4     -80.760  21.636 -32.319  1.00 36.41           C  
ATOM   7720  OG1 THR     4     -80.313  20.276 -32.327  1.00 37.81           O  
ATOM   7721  CG2 THR     4     -82.255  21.661 -32.026  1.00 30.45           C  
ATOM   7722  N   GLU     5     -81.811  24.184 -34.370  1.00 39.96           N  
ATOM   7723  CA  GLU     5     -82.345  25.546 -34.329  1.00 39.54           C  
ATOM   7724  C   GLU     5     -83.553  25.564 -33.417  1.00 37.36           C  
ATOM   7725  O   GLU     5     -84.281  24.581 -33.340  1.00 38.64           O  
ATOM   7726  CB  GLU     5     -82.768  26.019 -35.722  1.00 39.72           C  
ATOM   7727  CG  GLU     5     -81.673  25.972 -36.765  1.00 42.97           C  
ATOM   7728  CD  GLU     5     -82.038  26.679 -38.058  1.00 52.29           C  
ATOM   7729  OE1 GLU     5     -81.494  26.288 -39.114  1.00 59.87           O  
ATOM   7730  OE2 GLU     5     -82.861  27.622 -38.023  1.00 58.70           O  
ATOM   7731  N   THR     6     -83.771  26.685 -32.739  1.00 39.74           N  
ATOM   7732  CA  THR     6     -84.865  26.804 -31.783  1.00 40.46           C  
ATOM   7733  C   THR     6     -85.754  27.995 -32.125  1.00 40.75           C  
ATOM   7734  O   THR     6     -85.275  29.127 -32.261  1.00 42.54           O  
ATOM   7735  CB  THR     6     -84.337  26.935 -30.323  1.00 42.91           C  
ATOM   7736  OG1 THR     6     -83.371  25.908 -30.059  1.00 46.85           O  
ATOM   7737  CG2 THR     6     -85.477  26.818 -29.319  1.00 44.55           C  
ATOM   7738  N   TYR     7     -87.047  27.721 -32.277  1.00 39.16           N  
ATOM   7739  CA  TYR     7     -88.045  28.754 -32.525  1.00 35.75           C  
ATOM   7740  C   TYR     7     -89.166  28.573 -31.529  1.00 35.97           C  
ATOM   7741  O   TYR     7     -90.017  27.699 -31.698  1.00 39.75           O  
ATOM   7742  CB  TYR     7     -88.560  28.689 -33.969  1.00 38.99           C  
ATOM   7743  CG  TYR     7     -87.478  28.999 -34.969  1.00 40.54           C  
ATOM   7744  CD1 TYR     7     -87.179  30.317 -35.305  1.00 37.88           C  
ATOM   7745  CD2 TYR     7     -86.726  27.978 -35.553  1.00 37.35           C  
ATOM   7746  CE1 TYR     7     -86.166  30.614 -36.212  1.00 41.16           C  
ATOM   7747  CE2 TYR     7     -85.712  28.261 -36.456  1.00 37.99           C  
ATOM   7748  CZ  TYR     7     -85.437  29.579 -36.783  1.00 40.84           C  
ATOM   7749  OH  TYR     7     -84.431  29.867 -37.675  1.00 49.82           O  
ATOM   7750  N   GLY     8     -89.140  29.398 -30.483  1.00 35.98           N  
ATOM   7751  CA  GLY     8     -90.046  29.261 -29.348  1.00 34.78           C  
ATOM   7752  C   GLY     8     -89.837  27.928 -28.661  1.00 37.11           C  
ATOM   7753  O   GLY     8     -88.768  27.666 -28.097  1.00 39.11           O  
ATOM   7754  N   LEU     9     -90.858  27.081 -28.742  1.00 35.37           N  
ATOM   7755  CA  LEU     9     -90.831  25.755 -28.144  1.00 32.71           C  
ATOM   7756  C   LEU     9     -90.501  24.674 -29.174  1.00 33.56           C  
ATOM   7757  O   LEU     9     -90.358  23.498 -28.825  1.00 34.51           O  
ATOM   7758  CB  LEU     9     -92.174  25.452 -27.473  1.00 30.66           C  
ATOM   7759  CG  LEU     9     -92.546  26.278 -26.243  1.00 31.48           C  
ATOM   7760  CD1 LEU     9     -93.946  25.918 -25.798  1.00 26.00           C  
ATOM   7761  CD2 LEU     9     -91.550  26.088 -25.099  1.00 28.69           C  
ATOM   7762  N   TRP    10     -90.363  25.084 -30.436  1.00 35.01           N  
ATOM   7763  CA  TRP    10     -90.121  24.154 -31.539  1.00 33.36           C  
ATOM   7764  C   TRP    10     -88.660  24.091 -31.974  1.00 35.75           C  
ATOM   7765  O   TRP    10     -87.944  25.097 -31.949  1.00 33.95           O  
ATOM   7766  CB  TRP    10     -91.035  24.480 -32.721  1.00 31.82           C  
ATOM   7767  CG  TRP    10     -92.432  23.993 -32.495  1.00 30.68           C  
ATOM   7768  CD1 TRP    10     -93.389  24.573 -31.708  1.00 27.17           C  
ATOM   7769  CD2 TRP    10     -93.025  22.808 -33.041  1.00 29.19           C  
ATOM   7770  NE1 TRP    10     -94.545  23.827 -31.737  1.00 30.50           N  
ATOM   7771  CE2 TRP    10     -94.350  22.738 -32.549  1.00 31.52           C  
ATOM   7772  CE3 TRP    10     -92.566  21.798 -33.901  1.00 28.90           C  
ATOM   7773  CZ2 TRP    10     -95.224  21.695 -32.888  1.00 32.76           C  
ATOM   7774  CZ3 TRP    10     -93.437  20.759 -34.242  1.00 30.01           C  
ATOM   7775  CH2 TRP    10     -94.749  20.716 -33.733  1.00 32.69           C  
ATOM   7776  N   SER    11     -88.225  22.890 -32.351  1.00 35.54           N  
ATOM   7777  CA  SER    11     -86.858  22.665 -32.800  1.00 34.01           C  
ATOM   7778  C   SER    11     -86.809  22.282 -34.273  1.00 34.91           C  
ATOM   7779  O   SER    11     -87.770  21.719 -34.807  1.00 32.84           O  
ATOM   7780  CB  SER    11     -86.184  21.585 -31.957  1.00 34.82           C  
ATOM   7781  OG  SER    11     -86.153  21.951 -30.592  1.00 40.26           O  
ATOM   7782  N   ILE    12     -85.691  22.609 -34.921  1.00 37.39           N  
ATOM   7783  CA  ILE    12     -85.430  22.225 -36.311  1.00 38.04           C  
ATOM   7784  C   ILE    12     -84.071  21.530 -36.443  1.00 37.76           C  
ATOM   7785  O   ILE    12     -83.051  22.050 -35.989  1.00 38.44           O  
ATOM   7786  CB  ILE    12     -85.517  23.448 -37.280  1.00 39.96           C  
ATOM   7787  CG1 ILE    12     -86.963  23.902 -37.431  1.00 38.91           C  
ATOM   7788  CG2 ILE    12     -84.949  23.115 -38.674  1.00 37.07           C  
ATOM   7789  CD1 ILE    12     -87.101  25.226 -38.088  1.00 41.12           C  
ATOM   7790  N   ASN    13     -84.079  20.346 -37.047  1.00 40.63           N  
ATOM   7791  CA  ASN    13     -82.853  19.655 -37.434  1.00 42.33           C  
ATOM   7792  C   ASN    13     -82.896  19.247 -38.904  1.00 45.34           C  
ATOM   7793  O   ASN    13     -83.948  18.864 -39.422  1.00 47.47           O  
ATOM   7794  CB  ASN    13     -82.620  18.432 -36.552  1.00 40.33           C  
ATOM   7795  CG  ASN    13     -82.231  18.804 -35.141  1.00 41.17           C  
ATOM   7796  OD1 ASN    13     -83.081  18.895 -34.255  1.00 42.99           O  
ATOM   7797  ND2 ASN    13     -80.942  19.039 -34.925  1.00 36.69           N  
ATOM   7798  N   CYS    14     -81.753  19.358 -39.573  1.00 51.92           N  
ATOM   7799  CA  CYS    14     -81.608  18.893 -40.950  1.00 58.30           C  
ATOM   7800  C   CYS    14     -80.651  17.708 -40.975  1.00 63.16           C  
ATOM   7801  O   CYS    14     -79.557  17.774 -40.421  1.00 65.08           O  
ATOM   7802  CB  CYS    14     -81.105  20.020 -41.853  1.00 57.24           C  
ATOM   7803  SG  CYS    14     -82.207  21.455 -41.929  1.00 61.75           S  
ATOM   7804  N   GLY    15     -81.073  16.612 -41.593  1.00 71.49           N  
ATOM   7805  CA  GLY    15     -80.278  15.392 -41.572  1.00 79.04           C  
ATOM   7806  C   GLY    15     -80.256  14.637 -42.882  1.00 83.68           C  
ATOM   7807  O   GLY    15     -81.005  14.953 -43.807  1.00 81.70           O  
ATOM   7808  N   ILE    16     -79.385  13.635 -42.951  1.00 89.29           N  
ATOM   7809  CA  ILE    16     -79.296  12.768 -44.116  1.00 95.07           C  
ATOM   7810  C   ILE    16     -79.867  11.387 -43.785  1.00 97.80           C  
ATOM   7811  O   ILE    16     -79.246  10.598 -43.067  1.00101.91           O  
ATOM   7812  CB  ILE    16     -77.840  12.662 -44.659  1.00 95.61           C  
ATOM   7813  CG1 ILE    16     -77.255  14.058 -44.917  1.00 95.45           C  
ATOM   7814  CG2 ILE    16     -77.797  11.817 -45.936  1.00 97.89           C  
ATOM   7815  CD1 ILE    16     -75.734  14.100 -44.990  1.00 96.35           C  
ATOM   7816  N   GLN    17     -81.070  11.121 -44.289  1.00 99.86           N  
ATOM   7817  CA  GLN    17     -81.656   9.781 -44.248  1.00103.94           C  
ATOM   7818  C   GLN    17     -81.935   9.297 -45.671  1.00107.30           C  
ATOM   7819  O   GLN    17     -82.322  10.090 -46.537  1.00109.45           O  
ATOM   7820  CB  GLN    17     -82.913   9.730 -43.366  1.00103.97           C  
ATOM   7821  CG  GLN    17     -84.047  10.667 -43.776  1.00103.34           C  
ATOM   7822  CD  GLN    17     -85.227  10.643 -42.816  1.00103.34           C  
ATOM   7823  OE1 GLN    17     -86.325  11.077 -43.163  1.00101.58           O  
ATOM   7824  NE2 GLN    17     -85.007  10.138 -41.605  1.00103.62           N  
ATOM   7825  N   GLU    18     -81.735   7.993 -45.887  1.00109.68           N  
ATOM   7826  CA  GLU    18     -81.668   7.343 -47.222  1.00108.94           C  
ATOM   7827  C   GLU    18     -80.948   8.127 -48.341  1.00104.86           C  
ATOM   7828  O   GLU    18     -81.362   8.105 -49.506  1.00105.18           O  
ATOM   7829  CB  GLU    18     -83.026   6.751 -47.681  1.00110.74           C  
ATOM   7830  CG  GLU    18     -84.210   7.717 -47.825  1.00113.55           C  
ATOM   7831  CD  GLU    18     -85.104   7.762 -46.593  1.00119.58           C  
ATOM   7832  OE1 GLU    18     -84.621   7.489 -45.471  1.00119.83           O  
ATOM   7833  OE2 GLU    18     -86.303   8.075 -46.749  1.00123.72           O  
ATOM   7834  N   GLY    19     -79.866   8.811 -47.965  1.00 99.61           N  
ATOM   7835  CA  GLY    19     -79.063   9.610 -48.891  1.00 93.47           C  
ATOM   7836  C   GLY    19     -79.633  10.977 -49.231  1.00 89.20           C  
ATOM   7837  O   GLY    19     -79.123  11.659 -50.126  1.00 84.86           O  
ATOM   7838  N   LYS    20     -80.686  11.380 -48.519  1.00 87.80           N  
ATOM   7839  CA  LYS    20     -81.356  12.659 -48.774  1.00 85.31           C  
ATOM   7840  C   LYS    20     -81.306  13.652 -47.624  1.00 84.60           C  
ATOM   7841  O   LYS    20     -81.594  13.304 -46.478  1.00 83.32           O  
ATOM   7842  CB  LYS    20     -82.820  12.453 -49.188  1.00 82.26           C  
ATOM   7843  CG  LYS    20     -83.153  12.836 -50.629  1.00 80.18           C  
ATOM   7844  CD  LYS    20     -82.756  14.271 -50.990  1.00 79.88           C  
ATOM   7845  CE  LYS    20     -81.530  14.316 -51.907  1.00 71.59           C  
ATOM   7846  NZ  LYS    20     -81.177  15.696 -52.331  1.00 69.67           N  
ATOM   7847  N   LYS    21     -80.950  14.892 -47.957  1.00 84.11           N  
ATOM   7848  CA  LYS    21     -81.076  16.017 -47.038  1.00 83.87           C  
ATOM   7849  C   LYS    21     -82.556  16.337 -46.825  1.00 81.07           C  
ATOM   7850  O   LYS    21     -83.272  16.685 -47.769  1.00 86.07           O  
ATOM   7851  CB  LYS    21     -80.317  17.244 -47.569  1.00 87.63           C  
ATOM   7852  CG  LYS    21     -80.607  18.573 -46.838  1.00 91.25           C  
ATOM   7853  CD  LYS    21     -80.062  18.608 -45.407  1.00 91.27           C  
ATOM   7854  CE  LYS    21     -78.579  18.952 -45.370  1.00 92.40           C  
ATOM   7855  NZ  LYS    21     -78.069  19.024 -43.973  1.00 94.73           N  
ATOM   7856  N   VAL    22     -83.006  16.185 -45.583  1.00 75.46           N  
ATOM   7857  CA  VAL    22     -84.368  16.538 -45.195  1.00 66.54           C  
ATOM   7858  C   VAL    22     -84.341  17.350 -43.894  1.00 60.14           C  
ATOM   7859  O   VAL    22     -83.654  16.991 -42.932  1.00 50.69           O  
ATOM   7860  CB  VAL    22     -85.316  15.282 -45.129  1.00 69.02           C  
ATOM   7861  CG1 VAL    22     -84.927  14.316 -44.011  1.00 62.21           C  
ATOM   7862  CG2 VAL    22     -86.785  15.694 -45.009  1.00 75.37           C  
ATOM   7863  N   CYS    23     -85.051  18.474 -43.893  1.00 57.05           N  
ATOM   7864  CA  CYS    23     -85.160  19.292 -42.693  1.00 52.37           C  
ATOM   7865  C   CYS    23     -86.501  19.053 -42.026  1.00 48.74           C  
ATOM   7866  O   CYS    23     -87.550  19.124 -42.672  1.00 48.88           O  
ATOM   7867  CB  CYS    23     -84.960  20.774 -43.012  1.00 53.59           C  
ATOM   7868  SG  CYS    23     -83.302  21.159 -43.621  1.00 61.48           S  
ATOM   7869  N   PHE    24     -86.462  18.751 -40.734  1.00 47.22           N  
ATOM   7870  CA  PHE    24     -87.689  18.483 -39.991  1.00 45.34           C  
ATOM   7871  C   PHE    24     -87.883  19.369 -38.767  1.00 40.99           C  
ATOM   7872  O   PHE    24     -86.934  19.890 -38.181  1.00 37.69           O  
ATOM   7873  CB  PHE    24     -87.866  16.983 -39.669  1.00 47.46           C  
ATOM   7874  CG  PHE    24     -86.757  16.385 -38.850  1.00 53.18           C  
ATOM   7875  CD1 PHE    24     -86.894  16.249 -37.469  1.00 57.41           C  
ATOM   7876  CD2 PHE    24     -85.590  15.920 -39.458  1.00 56.07           C  
ATOM   7877  CE1 PHE    24     -85.877  15.680 -36.699  1.00 57.82           C  
ATOM   7878  CE2 PHE    24     -84.563  15.356 -38.702  1.00 61.34           C  
ATOM   7879  CZ  PHE    24     -84.707  15.235 -37.317  1.00 59.01           C  
ATOM   7880  N   MET    25     -89.150  19.526 -38.415  1.00 40.89           N  
ATOM   7881  CA  MET    25     -89.627  20.457 -37.417  1.00 37.14           C  
ATOM   7882  C   MET    25     -90.204  19.579 -36.318  1.00 36.34           C  
ATOM   7883  O   MET    25     -91.072  18.749 -36.595  1.00 35.61           O  
ATOM   7884  CB  MET    25     -90.745  21.248 -38.069  1.00 40.66           C  
ATOM   7885  CG  MET    25     -91.015  22.605 -37.554  1.00 41.74           C  
ATOM   7886  SD  MET    25     -92.447  23.209 -38.467  1.00 33.57           S  
ATOM   7887  CE  MET    25     -93.338  23.885 -37.087  1.00 29.70           C  
ATOM   7888  N   HIS    26     -89.737  19.742 -35.080  1.00 36.22           N  
ATOM   7889  CA  HIS    26     -90.155  18.821 -34.012  1.00 34.22           C  
ATOM   7890  C   HIS    26     -90.321  19.388 -32.595  1.00 34.68           C  
ATOM   7891  O   HIS    26     -89.727  20.411 -32.225  1.00 32.90           O  
ATOM   7892  CB  HIS    26     -89.268  17.565 -33.993  1.00 31.23           C  
ATOM   7893  CG  HIS    26     -87.822  17.849 -33.742  1.00 33.71           C  
ATOM   7894  ND1 HIS    26     -87.235  17.684 -32.506  1.00 37.09           N  
ATOM   7895  CD2 HIS    26     -86.845  18.296 -34.566  1.00 32.07           C  
ATOM   7896  CE1 HIS    26     -85.959  18.012 -32.580  1.00 36.78           C  
ATOM   7897  NE2 HIS    26     -85.697  18.388 -33.819  1.00 36.25           N  
ATOM   7898  N   ARG    27     -91.147  18.696 -31.815  1.00 34.90           N  
ATOM   7899  CA  ARG    27     -91.499  19.109 -30.464  1.00 35.60           C  
ATOM   7900  C   ARG    27     -91.845  17.880 -29.620  1.00 37.37           C  
ATOM   7901  O   ARG    27     -92.615  17.022 -30.055  1.00 37.78           O  
ATOM   7902  CB  ARG    27     -92.693  20.072 -30.515  1.00 34.68           C  
ATOM   7903  CG  ARG    27     -93.389  20.316 -29.183  1.00 32.93           C  
ATOM   7904  CD  ARG    27     -92.882  21.562 -28.499  1.00 34.97           C  
ATOM   7905  NE  ARG    27     -93.150  21.549 -27.062  1.00 35.70           N  
ATOM   7906  CZ  ARG    27     -92.237  21.777 -26.118  1.00 35.79           C  
ATOM   7907  NH1 ARG    27     -90.983  22.061 -26.446  1.00 35.35           N  
ATOM   7908  NH2 ARG    27     -92.584  21.734 -24.840  1.00 32.78           N  
ATOM   7909  N   GLN    28     -91.264  17.802 -28.424  1.00 39.12           N  
ATOM   7910  CA  GLN    28     -91.625  16.785 -27.438  1.00 39.03           C  
ATOM   7911  C   GLN    28     -92.318  17.425 -26.248  1.00 35.59           C  
ATOM   7912  O   GLN    28     -91.953  18.522 -25.819  1.00 36.00           O  
ATOM   7913  CB  GLN    28     -90.382  16.060 -26.928  1.00 37.97           C  
ATOM   7914  CG  GLN    28     -89.815  15.019 -27.865  1.00 50.79           C  
ATOM   7915  CD  GLN    28     -88.584  14.336 -27.295  1.00 51.82           C  
ATOM   7916  OE1 GLN    28     -87.931  14.854 -26.380  1.00 48.50           O  
ATOM   7917  NE2 GLN    28     -88.258  13.163 -27.836  1.00 56.54           N  
ATOM   7918  N   GLU    29     -93.310  16.727 -25.706  1.00 34.54           N  
ATOM   7919  CA  GLU    29     -93.924  17.138 -24.452  1.00 36.76           C  
ATOM   7920  C   GLU    29     -93.641  16.119 -23.352  1.00 37.73           C  
ATOM   7921  O   GLU    29     -93.732  14.906 -23.576  1.00 36.19           O  
ATOM   7922  CB  GLU    29     -95.432  17.367 -24.605  1.00 38.13           C  
ATOM   7923  CG  GLU    29     -95.845  18.263 -25.776  1.00 38.36           C  
ATOM   7924  CD  GLU    29     -95.494  19.736 -25.598  1.00 42.52           C  
ATOM   7925  OE1 GLU    29     -95.164  20.170 -24.475  1.00 47.87           O  
ATOM   7926  OE2 GLU    29     -95.559  20.472 -26.602  1.00 44.00           O  
ATOM   7927  N   VAL    30     -93.284  16.629 -22.172  1.00 39.11           N  
ATOM   7928  CA  VAL    30     -92.918  15.794 -21.024  1.00 38.76           C  
ATOM   7929  C   VAL    30     -93.876  15.994 -19.843  1.00 40.55           C  
ATOM   7930  O   VAL    30     -94.572  17.009 -19.767  1.00 40.75           O  
ATOM   7931  CB  VAL    30     -91.444  16.041 -20.568  1.00 36.91           C  
ATOM   7932  CG1 VAL    30     -90.460  15.709 -21.687  1.00 33.10           C  
ATOM   7933  CG2 VAL    30     -91.237  17.483 -20.087  1.00 35.14           C  
ATOM   7934  N   ASN    31     -93.917  15.016 -18.939  1.00 43.33           N  
ATOM   7935  CA  ASN    31     -94.651  15.160 -17.681  1.00 43.25           C  
ATOM   7936  C   ASN    31     -93.779  15.766 -16.584  1.00 47.22           C  
ATOM   7937  O   ASN    31     -92.674  16.237 -16.865  1.00 47.32           O  
ATOM   7938  CB  ASN    31     -95.294  13.832 -17.233  1.00 43.59           C  
ATOM   7939  CG  ASN    31     -94.288  12.688 -17.073  1.00 43.57           C  
ATOM   7940  OD1 ASN    31     -93.078  12.894 -16.971  1.00 49.89           O  
ATOM   7941  ND2 ASN    31     -94.803  11.466 -17.049  1.00 39.28           N  
ATOM   7942  N   ASP    32     -94.274  15.749 -15.343  1.00 52.63           N  
ATOM   7943  CA  ASP    32     -93.516  16.253 -14.183  1.00 58.15           C  
ATOM   7944  C   ASP    32     -92.281  15.415 -13.813  1.00 58.15           C  
ATOM   7945  O   ASP    32     -91.374  15.908 -13.142  1.00 58.05           O  
ATOM   7946  CB  ASP    32     -94.427  16.458 -12.960  1.00 63.77           C  
ATOM   7947  CG  ASP    32     -95.443  15.332 -12.767  1.00 76.42           C  
ATOM   7948  OD1 ASP    32     -95.134  14.158 -13.075  1.00 83.20           O  
ATOM   7949  OD2 ASP    32     -96.559  15.631 -12.288  1.00 85.45           O  
ATOM   7950  N   GLN    33     -92.253  14.159 -14.264  1.00 60.15           N  
ATOM   7951  CA  GLN    33     -91.095  13.270 -14.084  1.00 60.41           C  
ATOM   7952  C   GLN    33     -90.101  13.388 -15.240  1.00 60.28           C  
ATOM   7953  O   GLN    33     -89.128  12.631 -15.309  1.00 63.82           O  
ATOM   7954  CB  GLN    33     -91.542  11.809 -13.928  1.00 58.58           C  
ATOM   7955  CG  GLN    33     -92.418  11.530 -12.707  1.00 67.98           C  
ATOM   7956  CD  GLN    33     -91.759  11.932 -11.396  1.00 76.84           C  
ATOM   7957  OE1 GLN    33     -92.246  12.817 -10.691  1.00 77.72           O  
ATOM   7958  NE2 GLN    33     -90.641  11.290 -11.069  1.00 78.90           N  
ATOM   7959  N   ASN    34     -90.371  14.333 -16.142  1.00 56.72           N  
ATOM   7960  CA  ASN    34     -89.528  14.644 -17.307  1.00 57.64           C  
ATOM   7961  C   ASN    34     -89.388  13.517 -18.343  1.00 53.14           C  
ATOM   7962  O   ASN    34     -88.394  13.450 -19.064  1.00 54.45           O  
ATOM   7963  CB  ASN    34     -88.152  15.190 -16.875  1.00 63.11           C  
ATOM   7964  CG  ASN    34     -87.574  16.183 -17.871  1.00 73.48           C  
ATOM   7965  OD1 ASN    34     -88.079  17.298 -18.021  1.00 82.99           O  
ATOM   7966  ND2 ASN    34     -86.505  15.782 -18.552  1.00 71.05           N  
ATOM   7967  N   ARG    35     -90.384  12.638 -18.426  1.00 50.00           N  
ATOM   7968  CA  ARG    35     -90.399  11.638 -19.493  1.00 52.19           C  
ATOM   7969  C   ARG    35     -91.392  12.000 -20.607  1.00 49.40           C  
ATOM   7970  O   ARG    35     -92.459  12.566 -20.351  1.00 46.47           O  
ATOM   7971  CB  ARG    35     -90.621  10.214 -18.955  1.00 54.38           C  
ATOM   7972  CG  ARG    35     -92.008   9.913 -18.435  1.00 63.48           C  
ATOM   7973  CD  ARG    35     -92.314   8.431 -18.562  1.00 72.96           C  
ATOM   7974  NE  ARG    35     -93.747   8.174 -18.460  1.00 81.89           N  
ATOM   7975  CZ  ARG    35     -94.569   7.959 -19.487  1.00 85.10           C  
ATOM   7976  NH1 ARG    35     -94.122   7.945 -20.737  1.00 84.71           N  
ATOM   7977  NH2 ARG    35     -95.855   7.748 -19.252  1.00 85.00           N  
ATOM   7978  N   VAL    36     -91.016  11.665 -21.839  1.00 46.28           N  
ATOM   7979  CA  VAL    36     -91.781  12.021 -23.036  1.00 43.64           C  
ATOM   7980  C   VAL    36     -93.111  11.271 -23.099  1.00 43.57           C  
ATOM   7981  O   VAL    36     -93.145  10.043 -23.052  1.00 45.58           O  
ATOM   7982  CB  VAL    36     -90.946  11.794 -24.329  1.00 43.77           C  
ATOM   7983  CG1 VAL    36     -91.721  12.214 -25.571  1.00 40.76           C  
ATOM   7984  CG2 VAL    36     -89.632  12.564 -24.252  1.00 43.73           C  
ATOM   7985  N   VAL    37     -94.199  12.032 -23.190  1.00 42.93           N  
ATOM   7986  CA  VAL    37     -95.549  11.475 -23.274  1.00 42.32           C  
ATOM   7987  C   VAL    37     -96.081  11.586 -24.705  1.00 43.22           C  
ATOM   7988  O   VAL    37     -96.640  10.634 -25.249  1.00 45.11           O  
ATOM   7989  CB  VAL    37     -96.511  12.177 -22.282  1.00 41.41           C  
ATOM   7990  CG1 VAL    37     -97.901  11.548 -22.323  1.00 44.11           C  
ATOM   7991  CG2 VAL    37     -95.952  12.127 -20.860  1.00 41.25           C  
ATOM   7992  N   VAL    38     -95.891  12.752 -25.312  1.00 42.01           N  
ATOM   7993  CA  VAL    38     -96.311  12.978 -26.691  1.00 44.83           C  
ATOM   7994  C   VAL    38     -95.192  13.689 -27.472  1.00 39.42           C  
ATOM   7995  O   VAL    38     -94.454  14.503 -26.911  1.00 42.68           O  
ATOM   7996  CB  VAL    38     -97.733  13.666 -26.765  1.00 47.06           C  
ATOM   7997  CG1 VAL    38     -97.745  15.019 -26.108  1.00 49.87           C  
ATOM   7998  CG2 VAL    38     -98.250  13.765 -28.184  1.00 54.30           C  
ATOM   7999  N   ALA    39     -95.029  13.324 -28.742  1.00 39.00           N  
ATOM   8000  CA  ALA    39     -94.053  13.963 -29.619  1.00 36.49           C  
ATOM   8001  C   ALA    39     -94.664  14.211 -30.995  1.00 40.04           C  
ATOM   8002  O   ALA    39     -95.598  13.516 -31.405  1.00 41.01           O  
ATOM   8003  CB  ALA    39     -92.787  13.106 -29.733  1.00 33.14           C  
ATOM   8004  N   MET    40     -94.135  15.209 -31.698  1.00 39.36           N  
ATOM   8005  CA  MET    40     -94.594  15.548 -33.040  1.00 37.36           C  
ATOM   8006  C   MET    40     -93.396  15.917 -33.903  1.00 36.61           C  
ATOM   8007  O   MET    40     -92.546  16.694 -33.484  1.00 38.65           O  
ATOM   8008  CB  MET    40     -95.604  16.701 -32.982  1.00 35.72           C  
ATOM   8009  CG  MET    40     -96.020  17.272 -34.336  1.00 44.41           C  
ATOM   8010  SD  MET    40     -97.527  18.253 -34.261  1.00 43.34           S  
ATOM   8011  CE  MET    40     -98.734  16.944 -34.198  1.00 57.38           C  
ATOM   8012  N   SER    41     -93.328  15.329 -35.095  1.00 38.59           N  
ATOM   8013  CA  SER    41     -92.282  15.642 -36.068  1.00 39.90           C  
ATOM   8014  C   SER    41     -92.924  15.923 -37.423  1.00 42.42           C  
ATOM   8015  O   SER    41     -93.814  15.194 -37.858  1.00 44.66           O  
ATOM   8016  CB  SER    41     -91.275  14.497 -36.171  1.00 38.92           C  
ATOM   8017  OG  SER    41     -90.050  14.948 -36.720  1.00 45.02           O  
ATOM   8018  N   VAL    42     -92.465  16.980 -38.084  1.00 43.27           N  
ATOM   8019  CA  VAL    42     -93.147  17.520 -39.258  1.00 43.16           C  
ATOM   8020  C   VAL    42     -92.174  17.983 -40.359  1.00 42.78           C  
ATOM   8021  O   VAL    42     -91.132  18.582 -40.069  1.00 41.02           O  
ATOM   8022  CB  VAL    42     -94.163  18.624 -38.813  1.00 45.42           C  
ATOM   8023  CG1 VAL    42     -94.091  19.877 -39.667  1.00 47.71           C  
ATOM   8024  CG2 VAL    42     -95.576  18.055 -38.765  1.00 50.61           C  
ATOM   8025  N   VAL    43     -92.503  17.669 -41.615  1.00 44.23           N  
ATOM   8026  CA  VAL    43     -91.737  18.158 -42.773  1.00 45.03           C  
ATOM   8027  C   VAL    43     -92.593  19.010 -43.711  1.00 47.46           C  
ATOM   8028  O   VAL    43     -93.827  18.887 -43.743  1.00 45.91           O  
ATOM   8029  CB  VAL    43     -91.058  17.017 -43.599  1.00 45.82           C  
ATOM   8030  CG1 VAL    43     -89.978  16.311 -42.785  1.00 47.96           C  
ATOM   8031  CG2 VAL    43     -92.085  16.022 -44.131  1.00 44.05           C  
ATOM   8032  N   LEU    44     -91.923  19.882 -44.461  1.00 48.25           N  
ATOM   8033  CA  LEU    44     -92.552  20.638 -45.533  1.00 49.20           C  
ATOM   8034  C   LEU    44     -92.233  19.926 -46.840  1.00 50.17           C  
ATOM   8035  O   LEU    44     -91.069  19.834 -47.241  1.00 48.59           O  
ATOM   8036  CB  LEU    44     -92.007  22.069 -45.574  1.00 50.42           C  
ATOM   8037  CG  LEU    44     -92.858  23.273 -46.005  1.00 51.57           C  
ATOM   8038  CD1 LEU    44     -92.022  24.181 -46.886  1.00 48.17           C  
ATOM   8039  CD2 LEU    44     -94.179  22.925 -46.686  1.00 53.02           C  
ATOM   8040  N   ASN    45     -93.269  19.405 -47.490  1.00 53.56           N  
ATOM   8041  CA  ASN    45     -93.105  18.705 -48.759  1.00 60.61           C  
ATOM   8042  C   ASN    45     -92.953  19.682 -49.926  1.00 61.95           C  
ATOM   8043  O   ASN    45     -93.225  20.880 -49.780  1.00 62.94           O  
ATOM   8044  CB  ASN    45     -94.268  17.736 -48.991  1.00 61.44           C  
ATOM   8045  CG  ASN    45     -94.318  16.625 -47.955  1.00 61.88           C  
ATOM   8046  OD1 ASN    45     -93.560  15.656 -48.027  1.00 64.24           O  
ATOM   8047  ND2 ASN    45     -95.216  16.760 -46.986  1.00 54.93           N  
ATOM   8048  N   ALA    46     -92.519  19.160 -51.073  1.00 67.68           N  
ATOM   8049  CA  ALA    46     -92.230  19.965 -52.270  1.00 72.47           C  
ATOM   8050  C   ALA    46     -93.438  20.734 -52.823  1.00 71.74           C  
ATOM   8051  O   ALA    46     -93.283  21.830 -53.370  1.00 64.68           O  
ATOM   8052  CB  ALA    46     -91.609  19.090 -53.357  1.00 71.52           C  
ATOM   8053  N   ASP    47     -94.630  20.158 -52.664  1.00 76.25           N  
ATOM   8054  CA  ASP    47     -95.876  20.788 -53.116  1.00 81.64           C  
ATOM   8055  C   ASP    47     -96.438  21.812 -52.121  1.00 80.37           C  
ATOM   8056  O   ASP    47     -97.388  22.535 -52.433  1.00 83.42           O  
ATOM   8057  CB  ASP    47     -96.933  19.726 -53.454  1.00 83.20           C  
ATOM   8058  CG  ASP    47     -97.331  18.887 -52.253  1.00 89.84           C  
ATOM   8059  OD1 ASP    47     -96.480  18.135 -51.726  1.00 88.83           O  
ATOM   8060  OD2 ASP    47     -98.509  18.972 -51.847  1.00 94.11           O  
ATOM   8061  N   GLY    48     -95.851  21.869 -50.928  1.00 78.39           N  
ATOM   8062  CA  GLY    48     -96.258  22.836 -49.913  1.00 75.66           C  
ATOM   8063  C   GLY    48     -97.114  22.258 -48.802  1.00 74.27           C  
ATOM   8064  O   GLY    48     -97.499  22.977 -47.874  1.00 73.74           O  
ATOM   8065  N   VAL    49     -97.419  20.963 -48.893  1.00 70.95           N  
ATOM   8066  CA  VAL    49     -98.200  20.284 -47.858  1.00 66.91           C  
ATOM   8067  C   VAL    49     -97.320  19.964 -46.637  1.00 61.43           C  
ATOM   8068  O   VAL    49     -96.161  19.555 -46.773  1.00 59.04           O  
ATOM   8069  CB  VAL    49     -98.986  19.037 -48.419  1.00 70.53           C  
ATOM   8070  CG1 VAL    49     -98.077  17.831 -48.676  1.00 70.34           C  
ATOM   8071  CG2 VAL    49    -100.136  18.653 -47.503  1.00 72.21           C  
ATOM   8072  N   VAL    50     -97.867  20.205 -45.449  1.00 55.18           N  
ATOM   8073  CA  VAL    50     -97.165  19.942 -44.198  1.00 51.62           C  
ATOM   8074  C   VAL    50     -97.600  18.579 -43.655  1.00 50.09           C  
ATOM   8075  O   VAL    50     -98.779  18.360 -43.366  1.00 49.43           O  
ATOM   8076  CB  VAL    50     -97.396  21.082 -43.168  1.00 54.49           C  
ATOM   8077  CG1 VAL    50     -96.922  20.691 -41.780  1.00 51.97           C  
ATOM   8078  CG2 VAL    50     -96.696  22.361 -43.622  1.00 58.52           C  
ATOM   8079  N   SER    51     -96.642  17.662 -43.546  1.00 46.60           N  
ATOM   8080  CA  SER    51     -96.927  16.305 -43.098  1.00 46.78           C  
ATOM   8081  C   SER    51     -95.855  15.764 -42.153  1.00 45.98           C  
ATOM   8082  O   SER    51     -94.767  16.326 -42.041  1.00 47.23           O  
ATOM   8083  CB  SER    51     -97.097  15.362 -44.297  1.00 46.56           C  
ATOM   8084  OG  SER    51     -95.844  15.036 -44.878  1.00 47.27           O  
ATOM   8085  N   GLY    52     -96.178  14.667 -41.478  1.00 45.55           N  
ATOM   8086  CA  GLY    52     -95.223  13.985 -40.616  1.00 43.07           C  
ATOM   8087  C   GLY    52     -95.883  12.979 -39.699  1.00 43.98           C  
ATOM   8088  O   GLY    52     -96.833  12.294 -40.090  1.00 43.52           O  
ATOM   8089  N   ASN    53     -95.381  12.902 -38.469  1.00 43.90           N  
ATOM   8090  CA  ASN    53     -95.834  11.907 -37.504  1.00 40.61           C  
ATOM   8091  C   ASN    53     -96.062  12.463 -36.107  1.00 39.65           C  
ATOM   8092  O   ASN    53     -95.329  13.336 -35.638  1.00 40.08           O  
ATOM   8093  CB  ASN    53     -94.838  10.745 -37.431  1.00 41.51           C  
ATOM   8094  CG  ASN    53     -94.871   9.867 -38.667  1.00 47.13           C  
ATOM   8095  OD1 ASN    53     -95.901   9.287 -39.005  1.00 50.75           O  
ATOM   8096  ND2 ASN    53     -93.738   9.759 -39.343  1.00 49.89           N  
ATOM   8097  N   LEU    54     -97.097  11.938 -35.462  1.00 37.37           N  
ATOM   8098  CA  LEU    54     -97.386  12.191 -34.062  1.00 38.77           C  
ATOM   8099  C   LEU    54     -97.122  10.899 -33.277  1.00 38.50           C  
ATOM   8100  O   LEU    54     -97.566   9.821 -33.675  1.00 39.47           O  
ATOM   8101  CB  LEU    54     -98.845  12.642 -33.919  1.00 40.65           C  
ATOM   8102  CG  LEU    54     -99.498  12.858 -32.553  1.00 48.06           C  
ATOM   8103  CD1 LEU    54     -98.949  14.092 -31.861  1.00 52.48           C  
ATOM   8104  CD2 LEU    54    -101.005  12.973 -32.727  1.00 43.73           C  
ATOM   8105  N   THR    55     -96.378  11.010 -32.180  1.00 39.30           N  
ATOM   8106  CA  THR    55     -96.126   9.865 -31.304  1.00 39.91           C  
ATOM   8107  C   THR    55     -96.993   9.965 -30.053  1.00 40.74           C  
ATOM   8108  O   THR    55     -96.873  10.912 -29.277  1.00 41.61           O  
ATOM   8109  CB  THR    55     -94.633   9.737 -30.907  1.00 41.37           C  
ATOM   8110  OG1 THR    55     -93.816   9.773 -32.083  1.00 45.21           O  
ATOM   8111  CG2 THR    55     -94.383   8.421 -30.165  1.00 38.83           C  
ATOM   8112  N   VAL    56     -97.865   8.980 -29.871  1.00 41.74           N  
ATOM   8113  CA  VAL    56     -98.785   8.946 -28.740  1.00 39.47           C  
ATOM   8114  C   VAL    56     -98.411   7.781 -27.797  1.00 40.99           C  
ATOM   8115  O   VAL    56     -97.630   6.910 -28.194  1.00 39.59           O  
ATOM   8116  CB  VAL    56    -100.268   8.874 -29.224  1.00 39.38           C  
ATOM   8117  CG1 VAL    56    -100.628  10.107 -30.044  1.00 38.86           C  
ATOM   8118  CG2 VAL    56    -100.544   7.595 -30.007  1.00 36.61           C  
ATOM   8119  N   PRO    57     -98.932   7.774 -26.543  1.00 40.92           N  
ATOM   8120  CA  PRO    57     -98.623   6.686 -25.603  1.00 40.34           C  
ATOM   8121  C   PRO    57     -99.085   5.286 -26.011  1.00 39.91           C  
ATOM   8122  O   PRO    57     -99.891   5.127 -26.932  1.00 41.60           O  
ATOM   8123  CB  PRO    57     -99.368   7.101 -24.325  1.00 40.00           C  
ATOM   8124  CG  PRO    57     -99.582   8.555 -24.455  1.00 39.77           C  
ATOM   8125  CD  PRO    57     -99.794   8.790 -25.906  1.00 37.98           C  
ATOM   8126  N   PHE    58     -98.547   4.284 -25.316  1.00 39.09           N  
ATOM   8127  CA  PHE    58     -99.014   2.905 -25.401  1.00 36.94           C  
ATOM   8128  C   PHE    58    -100.369   2.794 -24.711  1.00 38.40           C  
ATOM   8129  O   PHE    58    -100.719   3.639 -23.889  1.00 39.49           O  
ATOM   8130  CB  PHE    58     -98.033   1.968 -24.691  1.00 36.65           C  
ATOM   8131  CG  PHE    58     -96.719   1.777 -25.406  1.00 37.29           C  
ATOM   8132  CD1 PHE    58     -96.674   1.317 -26.721  1.00 32.46           C  
ATOM   8133  CD2 PHE    58     -95.525   2.011 -24.740  1.00 36.17           C  
ATOM   8134  CE1 PHE    58     -95.456   1.124 -27.365  1.00 30.64           C  
ATOM   8135  CE2 PHE    58     -94.301   1.820 -25.375  1.00 36.39           C  
ATOM   8136  CZ  PHE    58     -94.265   1.374 -26.687  1.00 33.57           C  
ATOM   8137  N   GLY    59    -101.122   1.746 -25.033  1.00 38.02           N  
ATOM   8138  CA  GLY    59    -102.386   1.476 -24.353  1.00 38.64           C  
ATOM   8139  C   GLY    59    -103.588   2.148 -24.991  1.00 40.57           C  
ATOM   8140  O   GLY    59    -104.689   2.114 -24.437  1.00 41.45           O  
ATOM   8141  N   ILE    60    -103.373   2.751 -26.159  1.00 39.42           N  
ATOM   8142  CA  ILE    60    -104.424   3.446 -26.893  1.00 38.65           C  
ATOM   8143  C   ILE    60    -105.140   2.452 -27.794  1.00 39.98           C  
ATOM   8144  O   ILE    60    -104.493   1.652 -28.471  1.00 42.85           O  
ATOM   8145  CB  ILE    60    -103.848   4.646 -27.724  1.00 38.15           C  
ATOM   8146  CG1 ILE    60    -103.155   5.668 -26.813  1.00 35.54           C  
ATOM   8147  CG2 ILE    60    -104.926   5.336 -28.572  1.00 36.48           C  
ATOM   8148  CD1 ILE    60    -103.977   6.131 -25.609  1.00 40.32           C  
ATOM   8149  N   LEU    61    -106.473   2.500 -27.777  1.00 40.96           N  
ATOM   8150  CA  LEU    61    -107.313   1.695 -28.658  1.00 41.73           C  
ATOM   8151  C   LEU    61    -107.102   2.086 -30.115  1.00 43.74           C  
ATOM   8152  O   LEU    61    -107.481   3.174 -30.556  1.00 45.62           O  
ATOM   8153  CB  LEU    61    -108.791   1.801 -28.261  1.00 43.12           C  
ATOM   8154  CG  LEU    61    -109.809   0.889 -28.954  1.00 47.01           C  
ATOM   8155  CD1 LEU    61    -109.384  -0.574 -28.917  1.00 46.29           C  
ATOM   8156  CD2 LEU    61    -111.168   1.062 -28.305  1.00 48.24           C  
ATOM   8157  N   VAL    62    -106.482   1.158 -30.833  1.00 45.81           N  
ATOM   8158  CA  VAL    62    -106.000   1.327 -32.199  1.00 46.43           C  
ATOM   8159  C   VAL    62    -107.124   1.393 -33.254  1.00 49.99           C  
ATOM   8160  O   VAL    62    -106.973   2.042 -34.297  1.00 49.86           O  
ATOM   8161  CB  VAL    62    -104.952   0.203 -32.488  1.00 47.63           C  
ATOM   8162  CG1 VAL    62    -105.276  -0.618 -33.727  1.00 44.38           C  
ATOM   8163  CG2 VAL    62    -103.540   0.753 -32.479  1.00 43.08           C  
ATOM   8164  N   SER    63    -108.252   0.744 -32.963  1.00 52.24           N  
ATOM   8165  CA  SER    63    -109.386   0.694 -33.888  1.00 55.22           C  
ATOM   8166  C   SER    63    -110.231   1.973 -33.879  1.00 55.13           C  
ATOM   8167  O   SER    63    -110.996   2.225 -34.813  1.00 56.93           O  
ATOM   8168  CB  SER    63    -110.260  -0.534 -33.604  1.00 56.41           C  
ATOM   8169  OG  SER    63    -110.703  -0.554 -32.259  1.00 58.82           O  
ATOM   8170  N   LYS    64    -110.087   2.770 -32.823  1.00 54.64           N  
ATOM   8171  CA  LYS    64    -110.773   4.056 -32.702  1.00 54.80           C  
ATOM   8172  C   LYS    64    -109.828   5.216 -33.061  1.00 55.37           C  
ATOM   8173  O   LYS    64    -108.627   5.136 -32.792  1.00 54.67           O  
ATOM   8174  CB  LYS    64    -111.362   4.217 -31.295  1.00 55.30           C  
ATOM   8175  CG  LYS    64    -112.561   3.308 -31.037  1.00 63.31           C  
ATOM   8176  CD  LYS    64    -113.400   3.779 -29.855  1.00 78.37           C  
ATOM   8177  CE  LYS    64    -114.502   4.741 -30.289  1.00 85.91           C  
ATOM   8178  NZ  LYS    64    -115.560   4.064 -31.097  1.00 90.27           N  
ATOM   8179  N   PRO    65    -110.364   6.296 -33.674  1.00 55.58           N  
ATOM   8180  CA  PRO    65    -109.497   7.330 -34.247  1.00 52.60           C  
ATOM   8181  C   PRO    65    -108.828   8.256 -33.237  1.00 49.82           C  
ATOM   8182  O   PRO    65    -109.250   8.339 -32.083  1.00 48.16           O  
ATOM   8183  CB  PRO    65    -110.454   8.155 -35.122  1.00 54.13           C  
ATOM   8184  CG  PRO    65    -111.767   7.441 -35.107  1.00 56.65           C  
ATOM   8185  CD  PRO    65    -111.788   6.625 -33.873  1.00 55.49           C  
ATOM   8186  N   VAL    66    -107.782   8.940 -33.696  1.00 46.27           N  
ATOM   8187  CA  VAL    66    -107.118   9.997 -32.944  1.00 44.24           C  
ATOM   8188  C   VAL    66    -107.577  11.331 -33.533  1.00 46.00           C  
ATOM   8189  O   VAL    66    -107.417  11.587 -34.731  1.00 43.01           O  
ATOM   8190  CB  VAL    66    -105.565   9.870 -33.002  1.00 42.88           C  
ATOM   8191  CG1 VAL    66    -104.891  11.013 -32.249  1.00 35.13           C  
ATOM   8192  CG2 VAL    66    -105.110   8.531 -32.428  1.00 35.10           C  
ATOM   8193  N   ARG    67    -108.167  12.164 -32.684  1.00 48.36           N  
ATOM   8194  CA  ARG    67    -108.753  13.427 -33.112  1.00 53.92           C  
ATOM   8195  C   ARG    67    -107.820  14.591 -32.793  1.00 49.32           C  
ATOM   8196  O   ARG    67    -107.342  14.724 -31.667  1.00 48.15           O  
ATOM   8197  CB  ARG    67    -110.116  13.618 -32.440  1.00 58.21           C  
ATOM   8198  CG  ARG    67    -110.978  14.714 -33.038  1.00 66.31           C  
ATOM   8199  CD  ARG    67    -112.314  14.790 -32.317  1.00 73.54           C  
ATOM   8200  NE  ARG    67    -112.903  16.125 -32.388  1.00 80.28           N  
ATOM   8201  CZ  ARG    67    -112.664  17.103 -31.518  1.00 86.09           C  
ATOM   8202  NH1 ARG    67    -111.839  16.912 -30.494  1.00 80.35           N  
ATOM   8203  NH2 ARG    67    -113.252  18.282 -31.672  1.00 91.87           N  
ATOM   8204  N   LEU    68    -107.562  15.424 -33.795  1.00 49.12           N  
ATOM   8205  CA  LEU    68    -106.675  16.571 -33.647  1.00 49.18           C  
ATOM   8206  C   LEU    68    -107.459  17.867 -33.811  1.00 49.62           C  
ATOM   8207  O   LEU    68    -108.159  18.051 -34.804  1.00 48.56           O  
ATOM   8208  CB  LEU    68    -105.534  16.513 -34.671  1.00 49.41           C  
ATOM   8209  CG  LEU    68    -104.300  15.649 -34.391  1.00 49.62           C  
ATOM   8210  CD1 LEU    68    -104.533  14.193 -34.745  1.00 50.08           C  
ATOM   8211  CD2 LEU    68    -103.119  16.188 -35.170  1.00 55.46           C  
ATOM   8212  N   GLN    69    -107.330  18.764 -32.839  1.00 48.75           N  
ATOM   8213  CA  GLN    69    -108.055  20.028 -32.864  1.00 49.66           C  
ATOM   8214  C   GLN    69    -107.172  21.176 -32.386  1.00 47.73           C  
ATOM   8215  O   GLN    69    -106.540  21.078 -31.335  1.00 45.89           O  
ATOM   8216  CB  GLN    69    -109.320  19.936 -32.002  1.00 49.58           C  
ATOM   8217  CG  GLN    69    -110.243  21.150 -32.100  1.00 56.24           C  
ATOM   8218  CD  GLN    69    -111.428  21.082 -31.147  1.00 57.65           C  
ATOM   8219  OE1 GLN    69    -111.413  20.341 -30.165  1.00 61.51           O  
ATOM   8220  NE2 GLN    69    -112.460  21.865 -31.434  1.00 63.23           N  
ATOM   8221  N   VAL    70    -107.132  22.258 -33.162  1.00 46.79           N  
ATOM   8222  CA  VAL    70    -106.425  23.465 -32.744  1.00 45.63           C  
ATOM   8223  C   VAL    70    -107.314  24.237 -31.771  1.00 50.88           C  
ATOM   8224  O   VAL    70    -108.377  24.738 -32.157  1.00 51.95           O  
ATOM   8225  CB  VAL    70    -106.029  24.367 -33.933  1.00 44.32           C  
ATOM   8226  CG1 VAL    70    -105.031  25.425 -33.477  1.00 41.51           C  
ATOM   8227  CG2 VAL    70    -105.442  23.542 -35.065  1.00 37.72           C  
ATOM   8228  N   ASP    71    -106.859  24.307 -30.517  1.00 57.99           N  
ATOM   8229  CA  ASP    71    -107.581  24.923 -29.392  1.00 60.52           C  
ATOM   8230  C   ASP    71    -109.024  24.421 -29.270  1.00 61.83           C  
ATOM   8231  O   ASP    71    -109.254  23.219 -29.136  1.00 62.03           O  
ATOM   8232  CB  ASP    71    -107.508  26.457 -29.463  1.00 62.89           C  
ATOM   8233  CG  ASP    71    -106.079  26.981 -29.403  1.00 69.66           C  
ATOM   8234  OD1 ASP    71    -105.280  26.458 -28.597  1.00 66.80           O  
ATOM   8235  OD2 ASP    71    -105.759  27.927 -30.157  1.00 74.25           O  
ATOM   8236  N   GLU    72    -109.986  25.336 -29.324  1.00 67.01           N  
ATOM   8237  CA  GLU    72    -111.397  24.967 -29.370  1.00 69.33           C  
ATOM   8238  C   GLU    72    -112.042  25.472 -30.658  1.00 67.56           C  
ATOM   8239  O   GLU    72    -113.250  25.704 -30.716  1.00 69.21           O  
ATOM   8240  CB  GLU    72    -112.128  25.476 -28.127  1.00 72.79           C  
ATOM   8241  CG  GLU    72    -111.884  24.613 -26.893  1.00 84.26           C  
ATOM   8242  CD  GLU    72    -112.101  25.361 -25.594  1.00 95.67           C  
ATOM   8243  OE1 GLU    72    -111.532  26.464 -25.436  1.00100.41           O  
ATOM   8244  OE2 GLU    72    -112.831  24.839 -24.724  1.00 98.92           O  
ATOM   8245  N   GLY    73    -111.215  25.616 -31.691  1.00 67.67           N  
ATOM   8246  CA  GLY    73    -111.646  26.110 -32.993  1.00 68.92           C  
ATOM   8247  C   GLY    73    -112.233  25.051 -33.907  1.00 68.85           C  
ATOM   8248  O   GLY    73    -112.516  23.929 -33.484  1.00 66.45           O  
ATOM   8249  N   LYS    74    -112.392  25.420 -35.175  1.00 73.69           N  
ATOM   8250  CA  LYS    74    -113.137  24.626 -36.153  1.00 76.53           C  
ATOM   8251  C   LYS    74    -112.253  23.676 -36.967  1.00 75.07           C  
ATOM   8252  O   LYS    74    -112.757  22.896 -37.783  1.00 74.22           O  
ATOM   8253  CB  LYS    74    -113.920  25.556 -37.090  1.00 81.61           C  
ATOM   8254  CG  LYS    74    -114.897  26.494 -36.380  1.00 88.45           C  
ATOM   8255  CD  LYS    74    -115.299  27.663 -37.273  1.00 94.43           C  
ATOM   8256  CE  LYS    74    -116.285  28.596 -36.579  1.00 94.31           C  
ATOM   8257  NZ  LYS    74    -117.639  27.985 -36.428  1.00 96.16           N  
ATOM   8258  N   ALA    75    -110.943  23.746 -36.739  1.00 73.41           N  
ATOM   8259  CA  ALA    75    -109.978  22.892 -37.434  1.00 69.88           C  
ATOM   8260  C   ALA    75    -109.856  21.516 -36.768  1.00 67.42           C  
ATOM   8261  O   ALA    75    -109.128  21.353 -35.782  1.00 65.58           O  
ATOM   8262  CB  ALA    75    -108.621  23.581 -37.510  1.00 70.25           C  
ATOM   8263  N   VAL    76    -110.579  20.535 -37.311  1.00 60.66           N  
ATOM   8264  CA  VAL    76    -110.595  19.175 -36.765  1.00 59.27           C  
ATOM   8265  C   VAL    76    -110.114  18.142 -37.797  1.00 59.79           C  
ATOM   8266  O   VAL    76    -110.641  18.064 -38.908  1.00 60.59           O  
ATOM   8267  CB  VAL    76    -111.999  18.791 -36.193  1.00 58.84           C  
ATOM   8268  CG1 VAL    76    -112.044  17.324 -35.750  1.00 59.68           C  
ATOM   8269  CG2 VAL    76    -112.380  19.697 -35.023  1.00 57.82           C  
ATOM   8270  N   ILE    77    -109.096  17.371 -37.417  1.00 58.69           N  
ATOM   8271  CA  ILE    77    -108.611  16.242 -38.207  1.00 59.27           C  
ATOM   8272  C   ILE    77    -108.860  14.942 -37.441  1.00 57.23           C  
ATOM   8273  O   ILE    77    -108.650  14.878 -36.228  1.00 54.63           O  
ATOM   8274  CB  ILE    77    -107.106  16.413 -38.573  1.00 60.42           C  
ATOM   8275  CG1 ILE    77    -106.971  17.218 -39.864  1.00 62.03           C  
ATOM   8276  CG2 ILE    77    -106.384  15.063 -38.733  1.00 63.50           C  
ATOM   8277  CD1 ILE    77    -105.544  17.554 -40.232  1.00 65.24           C  
ATOM   8278  N   GLU    78    -109.340  13.922 -38.145  1.00 57.78           N  
ATOM   8279  CA  GLU    78    -109.468  12.599 -37.555  1.00 60.04           C  
ATOM   8280  C   GLU    78    -108.614  11.602 -38.333  1.00 57.68           C  
ATOM   8281  O   GLU    78    -108.806  11.399 -39.533  1.00 59.36           O  
ATOM   8282  CB  GLU    78    -110.933  12.161 -37.490  1.00 61.44           C  
ATOM   8283  CG  GLU    78    -111.316  11.586 -36.139  1.00 71.59           C  
ATOM   8284  CD  GLU    78    -112.807  11.362 -35.982  1.00 82.86           C  
ATOM   8285  OE1 GLU    78    -113.399  11.973 -35.065  1.00 85.63           O  
ATOM   8286  OE2 GLU    78    -113.384  10.575 -36.764  1.00 85.45           O  
ATOM   8287  N   THR    79    -107.655  11.004 -37.634  1.00 55.81           N  
ATOM   8288  CA  THR    79    -106.732  10.030 -38.214  1.00 53.71           C  
ATOM   8289  C   THR    79    -106.540   8.885 -37.214  1.00 50.88           C  
ATOM   8290  O   THR    79    -107.223   8.843 -36.198  1.00 53.52           O  
ATOM   8291  CB  THR    79    -105.387  10.704 -38.633  1.00 56.65           C  
ATOM   8292  OG1 THR    79    -104.436   9.713 -39.047  1.00 55.80           O  
ATOM   8293  CG2 THR    79    -104.801  11.534 -37.490  1.00 53.91           C  
ATOM   8294  N   GLY    80    -105.636   7.952 -37.499  1.00 48.90           N  
ATOM   8295  CA  GLY    80    -105.436   6.798 -36.626  1.00 45.19           C  
ATOM   8296  C   GLY    80    -103.998   6.328 -36.531  1.00 43.56           C  
ATOM   8297  O   GLY    80    -103.134   6.782 -37.288  1.00 43.06           O  
ATOM   8298  N   ILE    81    -103.749   5.418 -35.588  1.00 41.38           N  
ATOM   8299  CA  ILE    81    -102.425   4.828 -35.381  1.00 38.65           C  
ATOM   8300  C   ILE    81    -102.105   3.891 -36.542  1.00 38.79           C  
ATOM   8301  O   ILE    81    -102.950   3.084 -36.931  1.00 42.90           O  
ATOM   8302  CB  ILE    81    -102.347   4.072 -34.017  1.00 37.88           C  
ATOM   8303  CG1 ILE    81    -102.470   5.056 -32.844  1.00 37.27           C  
ATOM   8304  CG2 ILE    81    -101.049   3.254 -33.893  1.00 33.72           C  
ATOM   8305  CD1 ILE    81    -102.728   4.400 -31.495  1.00 36.56           C  
ATOM   8306  N   ARG    82    -100.906   4.039 -37.106  1.00 36.17           N  
ATOM   8307  CA  ARG    82    -100.434   3.188 -38.197  0.50 35.92           C  
ATOM   8309  C   ARG    82     -99.723   1.959 -37.641  1.00 38.22           C  
ATOM   8310  O   ARG    82     -99.928   0.840 -38.121  1.00 36.05           O  
ATOM   8311  CB  ARG    82     -99.487   3.972 -39.112  0.50 34.83           C  
ATOM   8313  CG  ARG    82     -99.010   3.215 -40.350  0.50 39.11           C  
ATOM   8315  CD  ARG    82     -98.224   4.118 -41.294  0.50 35.84           C  
ATOM   8317  NE  ARG    82     -97.622   3.368 -42.395  0.50 33.08           N  
ATOM   8319  CZ  ARG    82     -96.374   2.903 -42.404  0.50 37.07           C  
ATOM   8321  NH1 ARG    82     -95.569   3.106 -41.368  0.50 32.81           N  
ATOM   8323  NH2 ARG    82     -95.926   2.231 -43.457  0.50 36.71           N  
ATOM   8325  N   THR    83     -98.886   2.189 -36.632  1.00 37.48           N  
ATOM   8326  CA  THR    83     -98.088   1.158 -35.979  1.00 39.27           C  
ATOM   8327  C   THR    83     -97.544   1.685 -34.654  1.00 39.23           C  
ATOM   8328  O   THR    83     -97.584   2.892 -34.390  1.00 39.06           O  
ATOM   8329  CB  THR    83     -96.901   0.695 -36.874  1.00 41.83           C  
ATOM   8330  OG1 THR    83     -96.245  -0.419 -36.262  1.00 49.98           O  
ATOM   8331  CG2 THR    83     -95.888   1.825 -37.118  1.00 40.10           C  
ATOM   8332  N   CYS    84     -97.042   0.782 -33.816  1.00 39.51           N  
ATOM   8333  CA  CYS    84     -96.324   1.200 -32.615  1.00 40.53           C  
ATOM   8334  C   CYS    84     -94.914   0.628 -32.602  1.00 39.63           C  
ATOM   8335  O   CYS    84     -94.671  -0.472 -33.091  1.00 41.58           O  
ATOM   8336  CB  CYS    84     -97.084   0.853 -31.328  1.00 40.84           C  
ATOM   8337  SG  CYS    84     -98.856   1.307 -31.327  1.00 47.99           S  
ATOM   8338  N   VAL    85     -93.994   1.422 -32.069  1.00 41.26           N  
ATOM   8339  CA  VAL    85     -92.575   1.088 -31.962  1.00 38.74           C  
ATOM   8340  C   VAL    85     -92.207   1.247 -30.470  1.00 39.32           C  
ATOM   8341  O   VAL    85     -93.071   1.667 -29.693  1.00 38.98           O  
ATOM   8342  CB  VAL    85     -91.720   2.011 -32.891  1.00 39.61           C  
ATOM   8343  CG1 VAL    85     -91.939   1.654 -34.361  1.00 36.84           C  
ATOM   8344  CG2 VAL    85     -92.010   3.488 -32.630  1.00 36.34           C  
ATOM   8345  N   PRO    86     -90.965   0.887 -30.050  1.00 39.93           N  
ATOM   8346  CA  PRO    86     -90.579   1.125 -28.642  1.00 40.46           C  
ATOM   8347  C   PRO    86     -90.798   2.546 -28.099  1.00 41.17           C  
ATOM   8348  O   PRO    86     -91.110   2.702 -26.920  1.00 41.73           O  
ATOM   8349  CB  PRO    86     -89.090   0.763 -28.623  1.00 38.19           C  
ATOM   8350  CG  PRO    86     -88.964  -0.271 -29.677  1.00 39.12           C  
ATOM   8351  CD  PRO    86     -89.882   0.187 -30.776  1.00 40.81           C  
ATOM   8352  N   ALA    87     -90.664   3.561 -28.953  1.00 41.92           N  
ATOM   8353  CA  ALA    87     -90.876   4.959 -28.552  1.00 41.74           C  
ATOM   8354  C   ALA    87     -92.349   5.317 -28.308  1.00 42.35           C  
ATOM   8355  O   ALA    87     -92.646   6.320 -27.659  1.00 44.31           O  
ATOM   8356  CB  ALA    87     -90.265   5.907 -29.580  1.00 39.31           C  
ATOM   8357  N   GLY    88     -93.261   4.500 -28.829  1.00 40.31           N  
ATOM   8358  CA  GLY    88     -94.694   4.729 -28.676  1.00 35.02           C  
ATOM   8359  C   GLY    88     -95.465   4.404 -29.941  1.00 38.26           C  
ATOM   8360  O   GLY    88     -94.940   3.763 -30.856  1.00 38.56           O  
ATOM   8361  N   CYS    89     -96.718   4.846 -29.992  1.00 37.23           N  
ATOM   8362  CA  CYS    89     -97.581   4.594 -31.143  1.00 37.64           C  
ATOM   8363  C   CYS    89     -97.558   5.742 -32.153  1.00 37.25           C  
ATOM   8364  O   CYS    89     -97.679   6.909 -31.783  1.00 38.90           O  
ATOM   8365  CB  CYS    89     -98.997   4.263 -30.677  1.00 36.32           C  
ATOM   8366  SG  CYS    89     -99.087   2.665 -29.817  1.00 44.05           S  
ATOM   8367  N   ILE    90     -97.386   5.397 -33.426  1.00 38.32           N  
ATOM   8368  CA  ILE    90     -97.156   6.382 -34.485  1.00 38.77           C  
ATOM   8369  C   ILE    90     -98.438   6.728 -35.234  1.00 38.84           C  
ATOM   8370  O   ILE    90     -99.085   5.851 -35.811  1.00 39.38           O  
ATOM   8371  CB  ILE    90     -96.072   5.896 -35.490  1.00 40.66           C  
ATOM   8372  CG1 ILE    90     -94.799   5.434 -34.759  1.00 40.11           C  
ATOM   8373  CG2 ILE    90     -95.768   6.968 -36.549  1.00 36.05           C  
ATOM   8374  CD1 ILE    90     -94.091   6.505 -33.922  1.00 47.31           C  
ATOM   8375  N   VAL    91     -98.788   8.015 -35.214  1.00 37.89           N  
ATOM   8376  CA  VAL    91     -99.967   8.541 -35.903  1.00 38.22           C  
ATOM   8377  C   VAL    91     -99.531   9.458 -37.056  1.00 38.71           C  
ATOM   8378  O   VAL    91     -99.006  10.547 -36.804  1.00 37.63           O  
ATOM   8379  CB  VAL    91    -100.880   9.336 -34.930  1.00 37.64           C  
ATOM   8380  CG1 VAL    91    -102.136   9.797 -35.628  1.00 34.89           C  
ATOM   8381  CG2 VAL    91    -101.244   8.505 -33.701  1.00 34.78           C  
ATOM   8382  N   PRO    92     -99.724   9.015 -38.321  1.00 41.21           N  
ATOM   8383  CA  PRO    92     -99.403   9.864 -39.476  1.00 42.25           C  
ATOM   8384  C   PRO    92    -100.380  11.022 -39.603  1.00 43.69           C  
ATOM   8385  O   PRO    92    -101.587  10.855 -39.385  1.00 46.34           O  
ATOM   8386  CB  PRO    92     -99.558   8.923 -40.679  1.00 40.31           C  
ATOM   8387  CG  PRO    92     -99.658   7.560 -40.117  1.00 41.73           C  
ATOM   8388  CD  PRO    92    -100.242   7.706 -38.751  1.00 40.34           C  
ATOM   8389  N   ILE    93     -99.847  12.189 -39.942  1.00 45.44           N  
ATOM   8390  CA  ILE    93    -100.636  13.410 -40.027  1.00 49.26           C  
ATOM   8391  C   ILE    93    -100.320  14.166 -41.312  1.00 48.71           C  
ATOM   8392  O   ILE    93     -99.160  14.278 -41.705  1.00 47.82           O  
ATOM   8393  CB  ILE    93    -100.407  14.322 -38.799  1.00 49.93           C  
ATOM   8394  CG1 ILE    93     -98.955  14.218 -38.324  1.00 54.73           C  
ATOM   8395  CG2 ILE    93    -101.351  13.927 -37.673  1.00 51.42           C  
ATOM   8396  CD1 ILE    93     -98.444  15.402 -37.553  1.00 48.62           C  
ATOM   8397  N   VAL    94    -101.369  14.643 -41.977  1.00 50.69           N  
ATOM   8398  CA  VAL    94    -101.246  15.502 -43.154  1.00 50.83           C  
ATOM   8399  C   VAL    94    -102.096  16.742 -42.903  1.00 50.88           C  
ATOM   8400  O   VAL    94    -103.281  16.628 -42.589  1.00 49.91           O  
ATOM   8401  CB  VAL    94    -101.702  14.779 -44.456  1.00 51.87           C  
ATOM   8402  CG1 VAL    94    -101.773  15.746 -45.634  1.00 51.56           C  
ATOM   8403  CG2 VAL    94    -100.766  13.624 -44.794  1.00 52.37           C  
ATOM   8404  N   PHE    95    -101.482  17.918 -43.019  1.00 51.11           N  
ATOM   8405  CA  PHE    95    -102.182  19.184 -42.817  1.00 53.11           C  
ATOM   8406  C   PHE    95    -102.367  19.943 -44.131  1.00 55.23           C  
ATOM   8407  O   PHE    95    -101.393  20.207 -44.839  1.00 57.10           O  
ATOM   8408  CB  PHE    95    -101.417  20.069 -41.830  1.00 51.34           C  
ATOM   8409  CG  PHE    95    -101.156  19.428 -40.493  1.00 51.30           C  
ATOM   8410  CD1 PHE    95     -99.856  19.297 -40.014  1.00 52.45           C  
ATOM   8411  CD2 PHE    95    -102.205  18.971 -39.704  1.00 51.81           C  
ATOM   8412  CE1 PHE    95     -99.611  18.719 -38.773  1.00 51.34           C  
ATOM   8413  CE2 PHE    95    -101.969  18.393 -38.462  1.00 49.46           C  
ATOM   8414  CZ  PHE    95    -100.673  18.267 -37.997  1.00 47.79           C  
ATOM   8415  N   ASP    96    -103.612  20.298 -44.449  1.00 58.17           N  
ATOM   8416  CA  ASP    96    -103.896  21.166 -45.601  1.00 62.07           C  
ATOM   8417  C   ASP    96    -103.629  22.639 -45.269  1.00 61.94           C  
ATOM   8418  O   ASP    96    -103.404  22.977 -44.103  1.00 61.30           O  
ATOM   8419  CB  ASP    96    -105.324  20.955 -46.143  1.00 62.34           C  
ATOM   8420  CG  ASP    96    -106.411  21.130 -45.079  1.00 68.13           C  
ATOM   8421  OD1 ASP    96    -106.406  22.134 -44.332  1.00 70.22           O  
ATOM   8422  OD2 ASP    96    -107.305  20.260 -45.012  1.00 74.75           O  
ATOM   8423  N   LYS    97    -103.677  23.499 -46.293  1.00 63.21           N  
ATOM   8424  CA  LYS    97    -103.397  24.944 -46.171  1.00 62.15           C  
ATOM   8425  C   LYS    97    -104.205  25.629 -45.062  1.00 58.72           C  
ATOM   8426  O   LYS    97    -103.676  26.483 -44.340  1.00 56.63           O  
ATOM   8427  CB  LYS    97    -103.646  25.671 -47.505  1.00 66.63           C  
ATOM   8428  CG  LYS    97    -103.078  24.989 -48.754  1.00 79.15           C  
ATOM   8429  CD  LYS    97    -101.597  25.278 -48.960  1.00 86.33           C  
ATOM   8430  CE  LYS    97    -101.089  24.618 -50.234  1.00 91.32           C  
ATOM   8431  NZ  LYS    97     -99.626  24.816 -50.433  1.00 92.22           N  
ATOM   8432  N   ASN    98    -105.474  25.231 -44.942  1.00 57.44           N  
ATOM   8433  CA  ASN    98    -106.388  25.775 -43.937  0.50 56.36           C  
ATOM   8435  C   ASN    98    -106.004  25.379 -42.513  1.00 56.07           C  
ATOM   8436  O   ASN    98    -106.101  26.193 -41.586  1.00 55.82           O  
ATOM   8437  CB  ASN    98    -107.826  25.333 -44.230  0.50 55.43           C  
ATOM   8439  CG  ASN    98    -108.272  25.685 -45.639  0.50 59.53           C  
ATOM   8441  OD1 ASN    98    -108.337  24.821 -46.514  0.50 56.99           O  
ATOM   8443  ND2 ASN    98    -108.574  26.959 -45.866  0.50 60.32           N  
ATOM   8445  N   TYR    99    -105.572  24.127 -42.346  1.00 53.30           N  
ATOM   8446  CA  TYR    99    -105.174  23.604 -41.038  1.00 49.37           C  
ATOM   8447  C   TYR    99    -103.825  24.171 -40.601  1.00 46.29           C  
ATOM   8448  O   TYR    99    -103.633  24.483 -39.422  1.00 46.34           O  
ATOM   8449  CB  TYR    99    -105.136  22.073 -41.041  1.00 49.20           C  
ATOM   8450  CG  TYR    99    -105.383  21.459 -39.678  1.00 47.60           C  
ATOM   8451  CD1 TYR    99    -104.369  21.396 -38.725  1.00 45.07           C  
ATOM   8452  CD2 TYR    99    -106.631  20.950 -39.339  1.00 47.01           C  
ATOM   8453  CE1 TYR    99    -104.583  20.839 -37.479  1.00 45.69           C  
ATOM   8454  CE2 TYR    99    -106.857  20.387 -38.087  1.00 49.26           C  
ATOM   8455  CZ  TYR    99    -105.826  20.337 -37.164  1.00 46.90           C  
ATOM   8456  OH  TYR    99    -106.029  19.789 -35.921  1.00 49.80           O  
ATOM   8457  N   VAL   100    -102.906  24.302 -41.556  1.00 43.96           N  
ATOM   8458  CA  VAL   100    -101.616  24.960 -41.332  1.00 43.98           C  
ATOM   8459  C   VAL   100    -101.799  26.388 -40.802  1.00 45.79           C  
ATOM   8460  O   VAL   100    -101.137  26.778 -39.843  1.00 48.00           O  
ATOM   8461  CB  VAL   100    -100.750  24.947 -42.617  1.00 44.35           C  
ATOM   8462  CG1 VAL   100     -99.566  25.891 -42.500  1.00 40.53           C  
ATOM   8463  CG2 VAL   100    -100.267  23.541 -42.908  1.00 42.15           C  
ATOM   8464  N   ALA   101    -102.725  27.136 -41.407  1.00 47.44           N  
ATOM   8465  CA  ALA   101    -103.055  28.503 -40.983  1.00 47.64           C  
ATOM   8466  C   ALA   101    -103.597  28.568 -39.554  1.00 46.99           C  
ATOM   8467  O   ALA   101    -103.307  29.517 -38.819  1.00 51.32           O  
ATOM   8468  CB  ALA   101    -104.048  29.135 -41.954  1.00 47.36           C  
ATOM   8469  N   ALA   102    -104.378  27.558 -39.174  1.00 45.72           N  
ATOM   8470  CA  ALA   102    -104.909  27.437 -37.818  1.00 43.91           C  
ATOM   8471  C   ALA   102    -103.809  27.097 -36.807  1.00 45.33           C  
ATOM   8472  O   ALA   102    -103.827  27.592 -35.680  1.00 46.79           O  
ATOM   8473  CB  ALA   102    -106.022  26.394 -37.774  1.00 42.26           C  
ATOM   8474  N   LEU   103    -102.859  26.258 -37.228  1.00 45.67           N  
ATOM   8475  CA  LEU   103    -101.682  25.882 -36.429  1.00 44.40           C  
ATOM   8476  C   LEU   103    -100.780  27.074 -36.107  1.00 44.93           C  
ATOM   8477  O   LEU   103    -100.211  27.149 -35.017  1.00 44.18           O  
ATOM   8478  CB  LEU   103    -100.866  24.811 -37.167  1.00 43.89           C  
ATOM   8479  CG  LEU   103    -100.812  23.312 -36.816  1.00 45.04           C  
ATOM   8480  CD1 LEU   103    -101.862  22.848 -35.824  1.00 40.47           C  
ATOM   8481  CD2 LEU   103    -100.864  22.475 -38.089  1.00 39.92           C  
ATOM   8482  N   ARG   104    -100.654  27.997 -37.060  1.00 45.96           N  
ATOM   8483  CA  ARG   104     -99.846  29.205 -36.884  1.00 45.42           C  
ATOM   8484  C   ARG   104    -100.493  30.188 -35.908  1.00 45.70           C  
ATOM   8485  O   ARG   104     -99.793  30.910 -35.198  1.00 47.56           O  
ATOM   8486  CB  ARG   104     -99.612  29.903 -38.226  1.00 48.20           C  
ATOM   8487  CG  ARG   104     -98.985  29.032 -39.300  1.00 48.50           C  
ATOM   8488  CD  ARG   104     -98.942  29.763 -40.628  1.00 48.41           C  
ATOM   8489  NE  ARG   104     -97.597  30.242 -40.930  1.00 45.45           N  
ATOM   8490  CZ  ARG   104     -96.884  29.856 -41.983  1.00 48.70           C  
ATOM   8491  NH1 ARG   104     -97.389  28.999 -42.860  1.00 61.07           N  
ATOM   8492  NH2 ARG   104     -95.668  30.342 -42.172  1.00 38.74           N  
ATOM   8493  N   ALA   105    -101.825  30.206 -35.880  1.00 46.39           N  
ATOM   8494  CA  ALA   105    -102.577  31.137 -35.038  1.00 48.45           C  
ATOM   8495  C   ALA   105    -102.917  30.547 -33.674  1.00 49.51           C  
ATOM   8496  O   ALA   105    -103.317  31.272 -32.760  1.00 52.08           O  
ATOM   8497  CB  ALA   105    -103.850  31.589 -35.753  1.00 48.13           C  
ATOM   8498  N   GLY   106    -102.755  29.232 -33.541  1.00 47.95           N  
ATOM   8499  CA  GLY   106    -103.172  28.515 -32.335  1.00 42.97           C  
ATOM   8500  C   GLY   106    -102.157  28.480 -31.207  1.00 42.20           C  
ATOM   8501  O   GLY   106    -100.995  28.862 -31.377  1.00 42.49           O  
ATOM   8502  N   LYS   107    -102.614  28.015 -30.048  1.00 43.00           N  
ATOM   8503  CA  LYS   107    -101.771  27.880 -28.865  1.00 47.17           C  
ATOM   8504  C   LYS   107    -101.509  26.412 -28.525  1.00 45.45           C  
ATOM   8505  O   LYS   107    -100.383  26.029 -28.207  1.00 44.60           O  
ATOM   8506  CB  LYS   107    -102.407  28.607 -27.674  1.00 50.63           C  
ATOM   8507  CG  LYS   107    -101.873  30.023 -27.475  1.00 65.02           C  
ATOM   8508  CD  LYS   107    -102.913  30.961 -26.882  1.00 77.55           C  
ATOM   8509  CE  LYS   107    -103.747  31.627 -27.972  1.00 86.67           C  
ATOM   8510  NZ  LYS   107    -104.663  32.663 -27.416  1.00 90.76           N  
ATOM   8511  N   HIS   108    -102.546  25.600 -28.561  1.00 45.01           N  
ATOM   8512  CA  HIS   108    -102.459  24.180 -28.282  1.00 44.56           C  
ATOM   8513  C   HIS   108    -103.063  23.346 -29.397  1.00 44.55           C  
ATOM   8514  O   HIS   108    -104.122  23.632 -29.880  1.00 43.56           O  
ATOM   8515  CB  HIS   108    -103.221  23.854 -27.015  1.00 47.32           C  
ATOM   8516  CG  HIS   108    -102.505  24.212 -25.762  1.00 54.73           C  
ATOM   8517  ND1 HIS   108    -102.780  23.614 -24.564  1.00 64.61           N  
ATOM   8518  CD2 HIS   108    -101.536  25.110 -25.515  1.00 62.28           C  
ATOM   8519  CE1 HIS   108    -102.005  24.123 -23.633  1.00 65.87           C  
ATOM   8520  NE2 HIS   108    -101.244  25.038 -24.183  1.00 62.10           N  
ATOM   8521  N   LEU   109    -102.395  22.283 -29.779  1.00 41.56           N  
ATOM   8522  CA  LEU   109    -102.997  21.270 -30.627  1.00 41.76           C  
ATOM   8523  C   LEU   109    -103.484  20.151 -29.717  1.00 42.73           C  
ATOM   8524  O   LEU   109    -102.692  19.347 -29.231  1.00 43.29           O  
ATOM   8525  CB  LEU   109    -102.010  20.747 -31.677  1.00 38.66           C  
ATOM   8526  CG  LEU   109    -102.527  19.658 -32.627  1.00 38.21           C  
ATOM   8527  CD1 LEU   109    -103.705  20.134 -33.472  1.00 38.18           C  
ATOM   8528  CD2 LEU   109    -101.416  19.180 -33.517  1.00 37.24           C  
ATOM   8529  N   LYS   110    -104.791  20.125 -29.480  1.00 43.89           N  
ATOM   8530  CA  LYS   110    -105.404  19.176 -28.560  1.00 43.28           C  
ATOM   8531  C   LYS   110    -105.587  17.811 -29.212  1.00 42.81           C  
ATOM   8532  O   LYS   110    -105.958  17.711 -30.386  1.00 41.27           O  
ATOM   8533  CB  LYS   110    -106.747  19.713 -28.057  1.00 46.86           C  
ATOM   8534  CG  LYS   110    -106.637  20.949 -27.172  1.00 53.48           C  
ATOM   8535  CD  LYS   110    -107.995  21.343 -26.614  1.00 68.99           C  
ATOM   8536  CE  LYS   110    -107.894  22.573 -25.725  1.00 83.43           C  
ATOM   8537  NZ  LYS   110    -109.224  22.997 -25.197  1.00 87.33           N  
ATOM   8538  N   LEU   111    -105.312  16.761 -28.444  1.00 43.69           N  
ATOM   8539  CA  LEU   111    -105.471  15.391 -28.923  1.00 43.91           C  
ATOM   8540  C   LEU   111    -106.586  14.683 -28.168  1.00 42.18           C  
ATOM   8541  O   LEU   111    -106.776  14.908 -26.971  1.00 42.42           O  
ATOM   8542  CB  LEU   111    -104.172  14.585 -28.777  1.00 44.52           C  
ATOM   8543  CG  LEU   111    -102.890  14.770 -29.601  1.00 45.49           C  
ATOM   8544  CD1 LEU   111    -103.057  15.711 -30.792  1.00 43.61           C  
ATOM   8545  CD2 LEU   111    -101.758  15.239 -28.714  1.00 46.82           C  
ATOM   8546  N   ALA   112    -107.317  13.826 -28.874  1.00 41.70           N  
ATOM   8547  CA  ALA   112    -108.374  13.027 -28.265  1.00 42.11           C  
ATOM   8548  C   ALA   112    -108.318  11.600 -28.786  1.00 40.83           C  
ATOM   8549  O   ALA   112    -108.326  11.375 -29.995  1.00 41.53           O  
ATOM   8550  CB  ALA   112    -109.737  13.640 -28.541  1.00 43.85           C  
ATOM   8551  N   MET   113    -108.261  10.641 -27.867  1.00 42.50           N  
ATOM   8552  CA  MET   113    -108.178   9.224 -28.225  1.00 41.77           C  
ATOM   8553  C   MET   113    -108.865   8.337 -27.185  1.00 43.96           C  
ATOM   8554  O   MET   113    -109.351   8.830 -26.165  1.00 43.85           O  
ATOM   8555  CB  MET   113    -106.716   8.800 -28.455  1.00 39.60           C  
ATOM   8556  CG  MET   113    -105.768   9.074 -27.297  1.00 39.28           C  
ATOM   8557  SD  MET   113    -104.057   9.187 -27.855  1.00 38.65           S  
ATOM   8558  CE  MET   113    -103.916  10.929 -28.210  1.00 41.68           C  
ATOM   8559  N   THR   114    -108.912   7.036 -27.464  1.00 46.22           N  
ATOM   8560  CA  THR   114    -109.570   6.062 -26.595  1.00 45.64           C  
ATOM   8561  C   THR   114    -108.539   5.101 -26.004  1.00 45.67           C  
ATOM   8562  O   THR   114    -107.699   4.574 -26.725  1.00 45.03           O  
ATOM   8563  CB  THR   114    -110.642   5.261 -27.373  1.00 45.96           C  
ATOM   8564  OG1 THR   114    -111.473   6.162 -28.109  1.00 48.22           O  
ATOM   8565  CG2 THR   114    -111.514   4.449 -26.434  1.00 42.63           C  
ATOM   8566  N   ILE   115    -108.603   4.896 -24.688  1.00 45.73           N  
ATOM   8567  CA  ILE   115    -107.736   3.945 -23.995  1.00 46.76           C  
ATOM   8568  C   ILE   115    -108.279   2.526 -24.181  1.00 48.35           C  
ATOM   8569  O   ILE   115    -109.484   2.295 -24.043  1.00 46.33           O  
ATOM   8570  CB  ILE   115    -107.608   4.296 -22.484  1.00 48.02           C  
ATOM   8571  CG1 ILE   115    -107.145   5.752 -22.308  1.00 45.46           C  
ATOM   8572  CG2 ILE   115    -106.644   3.342 -21.767  1.00 46.95           C  
ATOM   8573  CD1 ILE   115    -107.260   6.284 -20.886  1.00 46.24           C  
ATOM   8574  N   ALA   116    -107.391   1.590 -24.528  1.00 50.35           N  
ATOM   8575  CA  ALA   116    -107.740   0.171 -24.607  1.00 52.06           C  
ATOM   8576  C   ALA   116    -107.751  -0.436 -23.205  1.00 55.15           C  
ATOM   8577  O   ALA   116    -106.767  -1.031 -22.750  1.00 59.61           O  
ATOM   8578  CB  ALA   116    -106.782  -0.572 -25.521  1.00 44.31           C  
ATOM   8579  N   ALA   117    -108.878  -0.253 -22.527  1.00 58.19           N  
ATOM   8580  CA  ALA   117    -109.069  -0.675 -21.145  1.00 61.47           C  
ATOM   8581  C   ALA   117    -110.547  -1.048 -20.998  1.00 66.06           C  
ATOM   8582  O   ALA   117    -111.353  -0.647 -21.847  1.00 65.12           O  
ATOM   8583  CB  ALA   117    -108.688   0.464 -20.192  1.00 59.16           C  
ATOM   8584  N   PRO   118    -110.907  -1.847 -19.961  1.00 70.36           N  
ATOM   8585  CA  PRO   118    -112.326  -2.104 -19.686  1.00 69.83           C  
ATOM   8586  C   PRO   118    -113.139  -0.815 -19.520  1.00 67.26           C  
ATOM   8587  O   PRO   118    -112.801   0.036 -18.690  1.00 65.41           O  
ATOM   8588  CB  PRO   118    -112.289  -2.889 -18.371  1.00 72.29           C  
ATOM   8589  CG  PRO   118    -110.970  -3.562 -18.380  1.00 73.53           C  
ATOM   8590  CD  PRO   118    -110.035  -2.587 -19.025  1.00 71.48           C  
ATOM   8591  N   GLY   119    -114.183  -0.678 -20.336  1.00 64.56           N  
ATOM   8592  CA  GLY   119    -115.020   0.521 -20.353  1.00 65.34           C  
ATOM   8593  C   GLY   119    -114.679   1.468 -21.491  1.00 66.33           C  
ATOM   8594  O   GLY   119    -115.500   2.313 -21.870  1.00 65.92           O  
ATOM   8595  N   GLU   120    -113.468   1.304 -22.031  1.00 65.10           N  
ATOM   8596  CA  GLU   120    -112.886   2.149 -23.091  1.00 60.07           C  
ATOM   8597  C   GLU   120    -112.930   3.659 -22.797  1.00 56.48           C  
ATOM   8598  O   GLU   120    -113.626   4.403 -23.499  1.00 54.40           O  
ATOM   8599  CB  GLU   120    -113.501   1.823 -24.461  1.00 57.83           C  
ATOM   8600  CG  GLU   120    -113.168   0.420 -24.972  1.00 61.58           C  
ATOM   8601  CD  GLU   120    -113.903   0.049 -26.256  1.00 66.14           C  
ATOM   8602  OE1 GLU   120    -114.475   0.945 -26.917  1.00 66.14           O  
ATOM   8603  OE2 GLU   120    -113.890  -1.148 -26.617  1.00 72.51           O  
ATOM   8604  N   PRO   121    -112.171   4.114 -21.774  1.00 52.88           N  
ATOM   8605  CA  PRO   121    -112.229   5.517 -21.353  1.00 53.24           C  
ATOM   8606  C   PRO   121    -111.534   6.454 -22.351  1.00 56.38           C  
ATOM   8607  O   PRO   121    -110.611   6.030 -23.048  1.00 53.06           O  
ATOM   8608  CB  PRO   121    -111.475   5.522 -20.009  1.00 52.61           C  
ATOM   8609  CG  PRO   121    -111.177   4.091 -19.683  1.00 52.96           C  
ATOM   8610  CD  PRO   121    -111.185   3.358 -20.979  1.00 52.36           C  
ATOM   8611  N   PRO   122    -111.985   7.719 -22.435  1.00 59.94           N  
ATOM   8612  CA  PRO   122    -111.286   8.657 -23.309  1.00 58.33           C  
ATOM   8613  C   PRO   122    -110.017   9.220 -22.674  1.00 56.98           C  
ATOM   8614  O   PRO   122    -109.922   9.322 -21.444  1.00 57.07           O  
ATOM   8615  CB  PRO   122    -112.315   9.769 -23.519  1.00 60.21           C  
ATOM   8616  CG  PRO   122    -113.144   9.755 -22.281  1.00 61.14           C  
ATOM   8617  CD  PRO   122    -113.148   8.339 -21.768  1.00 60.85           C  
ATOM   8618  N   LEU   123    -109.047   9.561 -23.519  1.00 54.52           N  
ATOM   8619  CA  LEU   123    -107.865  10.303 -23.100  1.00 53.27           C  
ATOM   8620  C   LEU   123    -107.857  11.620 -23.871  1.00 54.53           C  
ATOM   8621  O   LEU   123    -107.614  11.639 -25.083  1.00 51.60           O  
ATOM   8622  CB  LEU   123    -106.586   9.495 -23.354  1.00 51.52           C  
ATOM   8623  CG  LEU   123    -105.254  10.038 -22.815  1.00 53.22           C  
ATOM   8624  CD1 LEU   123    -105.218  10.070 -21.284  1.00 52.01           C  
ATOM   8625  CD2 LEU   123    -104.097   9.215 -23.355  1.00 50.63           C  
ATOM   8626  N   ASN   124    -108.144  12.713 -23.163  1.00 56.50           N  
ATOM   8627  CA  ASN   124    -108.382  14.015 -23.792  1.00 56.92           C  
ATOM   8628  C   ASN   124    -107.468  15.139 -23.302  1.00 56.47           C  
ATOM   8629  O   ASN   124    -107.540  16.263 -23.805  1.00 57.02           O  
ATOM   8630  CB  ASN   124    -109.848  14.431 -23.610  1.00 59.19           C  
ATOM   8631  CG  ASN   124    -110.825  13.484 -24.293  1.00 62.91           C  
ATOM   8632  OD1 ASN   124    -110.506  12.856 -25.306  1.00 63.84           O  
ATOM   8633  ND2 ASN   124    -112.032  13.388 -23.741  1.00 62.51           N  
ATOM   8634  N   ASP   125    -106.609  14.837 -22.332  1.00 55.89           N  
ATOM   8635  CA  ASP   125    -105.779  15.864 -21.692  1.00 57.91           C  
ATOM   8636  C   ASP   125    -104.396  16.068 -22.331  1.00 55.21           C  
ATOM   8637  O   ASP   125    -103.591  16.868 -21.845  1.00 54.81           O  
ATOM   8638  CB  ASP   125    -105.666  15.616 -20.173  1.00 62.84           C  
ATOM   8639  CG  ASP   125    -105.107  14.231 -19.822  1.00 72.01           C  
ATOM   8640  OD1 ASP   125    -104.941  13.962 -18.613  1.00 81.27           O  
ATOM   8641  OD2 ASP   125    -104.833  13.413 -20.727  1.00 74.19           O  
ATOM   8642  N   LEU   126    -104.131  15.349 -23.420  1.00 51.02           N  
ATOM   8643  CA  LEU   126    -102.862  15.481 -24.138  1.00 46.92           C  
ATOM   8644  C   LEU   126    -102.934  16.535 -25.235  1.00 44.90           C  
ATOM   8645  O   LEU   126    -103.976  16.714 -25.877  1.00 45.37           O  
ATOM   8646  CB  LEU   126    -102.422  14.140 -24.730  1.00 47.54           C  
ATOM   8647  CG  LEU   126    -101.420  13.221 -24.023  1.00 47.39           C  
ATOM   8648  CD1 LEU   126    -101.581  13.167 -22.504  1.00 46.51           C  
ATOM   8649  CD2 LEU   126    -101.553  11.842 -24.625  1.00 44.20           C  
ATOM   8650  N   PHE   127    -101.809  17.212 -25.446  1.00 41.83           N  
ATOM   8651  CA  PHE   127    -101.706  18.298 -26.410  1.00 41.39           C  
ATOM   8652  C   PHE   127    -100.275  18.487 -26.886  1.00 40.58           C  
ATOM   8653  O   PHE   127     -99.340  17.969 -26.280  1.00 41.29           O  
ATOM   8654  CB  PHE   127    -102.233  19.626 -25.825  1.00 44.43           C  
ATOM   8655  CG  PHE   127    -101.652  19.980 -24.479  1.00 47.75           C  
ATOM   8656  CD1 PHE   127    -100.417  20.619 -24.373  1.00 47.14           C  
ATOM   8657  CD2 PHE   127    -102.350  19.680 -23.312  1.00 49.24           C  
ATOM   8658  CE1 PHE   127     -99.883  20.940 -23.128  1.00 49.24           C  
ATOM   8659  CE2 PHE   127    -101.824  19.998 -22.065  1.00 50.32           C  
ATOM   8660  CZ  PHE   127    -100.590  20.629 -21.973  1.00 51.44           C  
ATOM   8661  N   VAL   128    -100.116  19.241 -27.969  1.00 39.64           N  
ATOM   8662  CA  VAL   128     -98.810  19.727 -28.402  1.00 35.39           C  
ATOM   8663  C   VAL   128     -98.871  21.252 -28.339  1.00 37.91           C  
ATOM   8664  O   VAL   128     -99.822  21.863 -28.828  1.00 37.48           O  
ATOM   8665  CB  VAL   128     -98.448  19.246 -29.832  1.00 34.96           C  
ATOM   8666  CG1 VAL   128     -97.069  19.763 -30.258  1.00 30.06           C  
ATOM   8667  CG2 VAL   128     -98.479  17.727 -29.917  1.00 32.12           C  
ATOM   8668  N   GLN   129     -97.872  21.862 -27.707  1.00 38.26           N  
ATOM   8669  CA  GLN   129     -97.810  23.317 -27.601  1.00 36.17           C  
ATOM   8670  C   GLN   129     -97.309  23.935 -28.904  1.00 36.80           C  
ATOM   8671  O   GLN   129     -96.326  23.473 -29.489  1.00 36.17           O  
ATOM   8672  CB  GLN   129     -96.923  23.732 -26.432  1.00 35.06           C  
ATOM   8673  CG  GLN   129     -97.478  23.348 -25.062  1.00 36.77           C  
ATOM   8674  CD  GLN   129     -96.547  23.751 -23.932  1.00 39.52           C  
ATOM   8675  OE1 GLN   129     -96.678  24.837 -23.363  1.00 44.44           O  
ATOM   8676  NE2 GLN   129     -95.588  22.888 -23.615  1.00 37.86           N  
ATOM   8677  N   LEU   130     -97.986  24.989 -29.348  1.00 39.66           N  
ATOM   8678  CA  LEU   130     -97.746  25.542 -30.682  1.00 37.39           C  
ATOM   8679  C   LEU   130     -96.927  26.823 -30.700  1.00 36.78           C  
ATOM   8680  O   LEU   130     -96.784  27.445 -31.753  1.00 41.24           O  
ATOM   8681  CB  LEU   130     -99.072  25.741 -31.425  1.00 35.81           C  
ATOM   8682  CG  LEU   130     -99.896  24.487 -31.722  1.00 34.91           C  
ATOM   8683  CD1 LEU   130    -101.245  24.877 -32.294  1.00 34.39           C  
ATOM   8684  CD2 LEU   130     -99.152  23.531 -32.666  1.00 30.66           C  
ATOM   8685  N   ASN   131     -96.387  27.213 -29.548  1.00 39.07           N  
ATOM   8686  CA  ASN   131     -95.550  28.406 -29.468  1.00 38.32           C  
ATOM   8687  C   ASN   131     -94.264  28.239 -30.276  1.00 39.51           C  
ATOM   8688  O   ASN   131     -93.415  27.407 -29.953  1.00 40.05           O  
ATOM   8689  CB  ASN   131     -95.232  28.778 -28.015  1.00 41.74           C  
ATOM   8690  CG  ASN   131     -94.448  30.077 -27.907  1.00 44.69           C  
ATOM   8691  OD1 ASN   131     -93.229  30.068 -27.732  1.00 50.64           O  
ATOM   8692  ND2 ASN   131     -95.144  31.199 -28.033  1.00 50.20           N  
ATOM   8693  N   GLY   132     -94.150  29.023 -31.343  1.00 37.36           N  
ATOM   8694  CA  GLY   132     -93.003  28.953 -32.239  1.00 31.67           C  
ATOM   8695  C   GLY   132     -93.244  28.183 -33.527  1.00 34.02           C  
ATOM   8696  O   GLY   132     -92.359  28.129 -34.377  1.00 38.35           O  
ATOM   8697  N   PHE   133     -94.431  27.590 -33.670  1.00 36.76           N  
ATOM   8698  CA  PHE   133     -94.796  26.820 -34.870  1.00 38.96           C  
ATOM   8699  C   PHE   133     -94.644  27.644 -36.152  1.00 41.71           C  
ATOM   8700  O   PHE   133     -94.022  27.185 -37.115  1.00 42.81           O  
ATOM   8701  CB  PHE   133     -96.235  26.273 -34.773  1.00 39.20           C  
ATOM   8702  CG  PHE   133     -96.596  25.297 -35.871  1.00 41.70           C  
ATOM   8703  CD1 PHE   133     -96.525  23.924 -35.649  1.00 43.33           C  
ATOM   8704  CD2 PHE   133     -97.017  25.749 -37.127  1.00 42.03           C  
ATOM   8705  CE1 PHE   133     -96.848  23.014 -36.665  1.00 43.98           C  
ATOM   8706  CE2 PHE   133     -97.337  24.854 -38.146  1.00 39.80           C  
ATOM   8707  CZ  PHE   133     -97.254  23.484 -37.916  1.00 42.34           C  
ATOM   8708  N   SER   134     -95.220  28.848 -36.149  1.00 42.18           N  
ATOM   8709  CA  SER   134     -95.229  29.740 -37.313  1.00 42.38           C  
ATOM   8710  C   SER   134     -93.817  30.116 -37.757  1.00 40.58           C  
ATOM   8711  O   SER   134     -93.495  30.008 -38.943  1.00 42.40           O  
ATOM   8712  CB  SER   134     -96.059  30.995 -37.014  1.00 46.82           C  
ATOM   8713  OG  SER   134     -96.150  31.853 -38.136  1.00 54.10           O  
ATOM   8714  N   ASN   135     -92.980  30.528 -36.802  1.00 38.02           N  
ATOM   8715  CA  ASN   135     -91.591  30.900 -37.084  1.00 39.07           C  
ATOM   8716  C   ASN   135     -90.716  29.738 -37.534  1.00 40.40           C  
ATOM   8717  O   ASN   135     -89.853  29.910 -38.399  1.00 45.00           O  
ATOM   8718  CB  ASN   135     -90.956  31.588 -35.877  1.00 42.86           C  
ATOM   8719  CG  ASN   135     -91.424  33.016 -35.704  1.00 45.18           C  
ATOM   8720  OD1 ASN   135     -91.832  33.673 -36.664  1.00 49.01           O  
ATOM   8721  ND2 ASN   135     -91.363  33.509 -34.472  1.00 45.57           N  
ATOM   8722  N   ALA   136     -90.941  28.563 -36.950  1.00 40.02           N  
ATOM   8723  CA  ALA   136     -90.217  27.350 -37.346  1.00 38.53           C  
ATOM   8724  C   ALA   136     -90.631  26.886 -38.742  1.00 36.86           C  
ATOM   8725  O   ALA   136     -89.804  26.381 -39.498  1.00 38.11           O  
ATOM   8726  CB  ALA   136     -90.411  26.230 -36.319  1.00 36.47           C  
ATOM   8727  N   LEU   137     -91.905  27.070 -39.082  1.00 37.02           N  
ATOM   8728  CA  LEU   137     -92.394  26.736 -40.420  1.00 39.48           C  
ATOM   8729  C   LEU   137     -91.861  27.698 -41.484  1.00 41.97           C  
ATOM   8730  O   LEU   137     -91.545  27.270 -42.596  1.00 45.89           O  
ATOM   8731  CB  LEU   137     -93.922  26.674 -40.453  1.00 38.11           C  
ATOM   8732  CG  LEU   137     -94.596  26.152 -41.724  1.00 38.77           C  
ATOM   8733  CD1 LEU   137     -94.068  24.788 -42.136  1.00 37.35           C  
ATOM   8734  CD2 LEU   137     -96.089  26.102 -41.522  1.00 38.36           C  
ATOM   8735  N   ASN   138     -91.750  28.982 -41.131  1.00 42.09           N  
ATOM   8736  CA  ASN   138     -91.138  29.994 -42.000  1.00 42.09           C  
ATOM   8737  C   ASN   138     -89.689  29.657 -42.328  1.00 43.62           C  
ATOM   8738  O   ASN   138     -89.239  29.867 -43.454  1.00 48.34           O  
ATOM   8739  CB  ASN   138     -91.190  31.386 -41.355  1.00 42.26           C  
ATOM   8740  CG  ASN   138     -92.591  31.979 -41.320  1.00 42.14           C  
ATOM   8741  OD1 ASN   138     -93.517  31.477 -41.950  1.00 42.75           O  
ATOM   8742  ND2 ASN   138     -92.745  33.061 -40.571  1.00 41.76           N  
ATOM   8743  N   ARG   139     -88.969  29.140 -41.334  1.00 45.67           N  
ATOM   8744  CA  ARG   139     -87.590  28.693 -41.508  1.00 43.72           C  
ATOM   8745  C   ARG   139     -87.516  27.463 -42.424  1.00 43.33           C  
ATOM   8746  O   ARG   139     -86.610  27.356 -43.247  1.00 45.37           O  
ATOM   8747  CB  ARG   139     -86.942  28.429 -40.142  1.00 42.86           C  
ATOM   8748  CG  ARG   139     -85.506  27.912 -40.174  1.00 43.81           C  
ATOM   8749  CD  ARG   139     -84.563  28.856 -40.900  1.00 45.81           C  
ATOM   8750  NE  ARG   139     -83.174  28.411 -40.801  1.00 53.72           N  
ATOM   8751  CZ  ARG   139     -82.195  28.800 -41.613  1.00 55.64           C  
ATOM   8752  NH1 ARG   139     -82.438  29.636 -42.614  1.00 57.67           N  
ATOM   8753  NH2 ARG   139     -80.965  28.341 -41.429  1.00 55.83           N  
ATOM   8754  N   LEU   140     -88.484  26.557 -42.290  1.00 44.94           N  
ATOM   8755  CA  LEU   140     -88.597  25.388 -43.168  1.00 46.02           C  
ATOM   8756  C   LEU   140     -88.870  25.768 -44.627  1.00 49.25           C  
ATOM   8757  O   LEU   140     -88.360  25.119 -45.547  1.00 50.94           O  
ATOM   8758  CB  LEU   140     -89.676  24.427 -42.657  1.00 44.43           C  
ATOM   8759  CG  LEU   140     -89.263  23.036 -42.161  1.00 42.54           C  
ATOM   8760  CD1 LEU   140     -88.145  23.071 -41.135  1.00 34.28           C  
ATOM   8761  CD2 LEU   140     -90.474  22.281 -41.622  1.00 34.42           C  
ATOM   8762  N   ILE   141     -89.674  26.813 -44.825  1.00 50.63           N  
ATOM   8763  CA  ILE   141     -89.933  27.380 -46.152  1.00 51.16           C  
ATOM   8764  C   ILE   141     -88.652  28.003 -46.720  1.00 52.42           C  
ATOM   8765  O   ILE   141     -88.311  27.776 -47.885  1.00 55.57           O  
ATOM   8766  CB  ILE   141     -91.092  28.418 -46.116  1.00 51.67           C  
ATOM   8767  CG1 ILE   141     -92.414  27.733 -45.743  1.00 48.54           C  
ATOM   8768  CG2 ILE   141     -91.245  29.126 -47.466  1.00 53.10           C  
ATOM   8769  CD1 ILE   141     -93.491  28.667 -45.217  1.00 46.79           C  
ATOM   8770  N   ALA   142     -87.940  28.750 -45.876  1.00 52.51           N  
ATOM   8771  CA  ALA   142     -86.662  29.376 -46.232  1.00 53.46           C  
ATOM   8772  C   ALA   142     -85.546  28.372 -46.549  1.00 55.72           C  
ATOM   8773  O   ALA   142     -84.695  28.639 -47.401  1.00 60.79           O  
ATOM   8774  CB  ALA   142     -86.216  30.336 -45.124  1.00 50.56           C  
ATOM   8775  N   LEU   143     -85.555  27.228 -45.864  1.00 57.21           N  
ATOM   8776  CA  LEU   143     -84.567  26.172 -46.092  1.00 58.17           C  
ATOM   8777  C   LEU   143     -84.829  25.377 -47.377  1.00 61.92           C  
ATOM   8778  O   LEU   143     -83.911  24.755 -47.923  1.00 63.84           O  
ATOM   8779  CB  LEU   143     -84.485  25.230 -44.885  1.00 55.26           C  
ATOM   8780  CG  LEU   143     -83.691  25.691 -43.658  1.00 52.15           C  
ATOM   8781  CD1 LEU   143     -84.099  24.885 -42.426  1.00 47.67           C  
ATOM   8782  CD2 LEU   143     -82.186  25.601 -43.889  1.00 51.87           C  
ATOM   8783  N   GLN   144     -86.078  25.390 -47.846  1.00 65.75           N  
ATOM   8784  CA  GLN   144     -86.444  24.772 -49.123  1.00 71.05           C  
ATOM   8785  C   GLN   144     -85.878  25.549 -50.307  1.00 73.07           C  
ATOM   8786  O   GLN   144     -85.436  24.954 -51.296  1.00 73.75           O  
ATOM   8787  CB  GLN   144     -87.963  24.664 -49.268  1.00 71.94           C  
ATOM   8788  CG  GLN   144     -88.529  23.295 -48.930  1.00 77.77           C  
ATOM   8789  CD  GLN   144     -89.821  22.994 -49.678  1.00 79.09           C  
ATOM   8790  OE1 GLN   144     -90.596  23.898 -50.003  1.00 73.88           O  
ATOM   8791  NE2 GLN   144     -90.057  21.714 -49.952  1.00 79.06           N  
ATOM   8792  N   LYS   145     -85.898  26.877 -50.191  1.00 74.17           N  
ATOM   8793  CA  LYS   145     -85.368  27.774 -51.220  1.00 75.54           C  
ATOM   8794  C   LYS   145     -83.838  27.721 -51.302  1.00 76.51           C  
ATOM   8795  O   LYS   145     -83.263  27.926 -52.374  1.00 79.49           O  
ATOM   8796  CB  LYS   145     -85.854  29.206 -50.982  1.00 76.15           C  
ATOM   8797  CG  LYS   145     -87.359  29.376 -51.148  1.00 79.02           C  
ATOM   8798  CD  LYS   145     -87.827  30.741 -50.679  1.00 82.69           C  
ATOM   8799  CE  LYS   145     -89.345  30.829 -50.697  1.00 86.16           C  
ATOM   8800  NZ  LYS   145     -89.840  32.104 -50.106  1.00 88.65           N  
END
