
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 (  908),  selected  127 , name 1hl4_C
# Molecule2: number of CA atoms  145 ( 1093),  selected  145 , name T0514.pdb
# PARAMETERS: 1hl4_C.T0514.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_C      S       1           -
LGA    T     2_C      S       2           -
LGA    K     3_C      L       3           -
LGA    A     4_C      T       4           -
LGA    -       -      E       5           -
LGA    -       -      T       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      L       9           -
LGA    -       -      W      10           -
LGA    -       -      S      11           -
LGA    -       -      I      12           -
LGA    -       -      N      13           -
LGA    -       -      C      14           -
LGA    -       -      G      15           -
LGA    -       -      I      16           -
LGA    -       -      Q      17           -
LGA    -       -      E      18           -
LGA    -       -      G      19           -
LGA    -       -      K      20           -
LGA    -       -      K      21           -
LGA    -       -      V      22           -
LGA    -       -      C      23           -
LGA    -       -      F      24           -
LGA    V     5_C      M      25          5.242
LGA    C     6_C      H      26           #
LGA    V     7_C      R      27          2.341
LGA    L     8_C      -       -           -
LGA    K     9_C      Q      28          3.562
LGA    G    10_C      E      29          3.384
LGA    D    11_C      V      30          4.219
LGA    G    12_C      N      31          5.004
LGA    -       -      D      32           -
LGA    -       -      Q      33           -
LGA    -       -      N      34           -
LGA    -       -      R      35           -
LGA    -       -      V      36           -
LGA    P    13_C      V      37          1.734
LGA    V    14_C      V      38          1.356
LGA    Q    15_C      A      39          0.959
LGA    G    16_C      M      40          1.403
LGA    I    17_C      S      41          1.948
LGA    I    18_C      V      42          3.245
LGA    N    19_C      V      43          4.544
LGA    F    20_C      L      44           #
LGA    -       -      N      45           -
LGA    -       -      A      46           -
LGA    -       -      D      47           -
LGA    E    21_C      G      48          4.350
LGA    Q    22_C      -       -           -
LGA    K    23_C      -       -           -
LGA    E    24_C      -       -           -
LGA    S    25_C      -       -           -
LGA    N    26_C      -       -           -
LGA    G    27_C      -       -           -
LGA    P    28_C      -       -           -
LGA    V    29_C      -       -           -
LGA    K    30_C      V      49          2.584
LGA    V    31_C      V      50          3.099
LGA    W    32_C      S      51          1.028
LGA    G    33_C      G      52          1.064
LGA    S    34_C      N      53          1.042
LGA    I    35_C      L      54          1.511
LGA    K    36_C      T      55          1.476
LGA    G    37_C      V      56          3.309
LGA    L    38_C      P      57          3.226
LGA    T    39_C      F      58          4.152
LGA    -       -      G      59           -
LGA    E    40_C      I      60          4.548
LGA    G    41_C      L      61          4.958
LGA    -       -      V      62           -
LGA    -       -      S      63           -
LGA    -       -      K      64           -
LGA    L    42_C      P      65          2.128
LGA    H    43_C      V      66          1.426
LGA    G    44_C      R      67          1.290
LGA    F    45_C      L      68          0.638
LGA    H    46_C      Q      69          1.267
LGA    V    47_C      V      70          1.119
LGA    H    48_C      D      71          1.462
LGA    E    49_C      -       -           -
LGA    F    50_C      -       -           -
LGA    G    51_C      -       -           -
LGA    D    52_C      -       -           -
LGA    N    53_C      -       -           -
LGA    T    54_C      -       -           -
LGA    A    55_C      -       -           -
LGA    G    56_C      -       -           -
LGA    C    57_C      -       -           -
LGA    T    58_C      -       -           -
LGA    S    59_C      -       -           -
LGA    A    60_C      -       -           -
LGA    G    61_C      -       -           -
LGA    P    62_C      -       -           -
LGA    H    63_C      E      72          1.361
LGA    F    64_C      G      73          2.615
LGA    N    65_C      -       -           -
LGA    P    66_C      -       -           -
LGA    L    67_C      -       -           -
LGA    S    68_C      -       -           -
LGA    R    79_C      -       -           -
LGA    H    80_C      K      74          1.180
LGA    V    81_C      -       -           -
LGA    G    82_C      A      75          2.302
LGA    D    83_C      V      76          1.740
LGA    L    84_C      -       -           -
LGA    G    85_C      I      77          1.539
LGA    N    86_C      E      78          2.111
LGA    V    87_C      T      79          3.094
LGA    T    88_C      G      80          1.587
LGA    A    89_C      I      81          1.706
LGA    D    90_C      R      82          3.105
LGA    K    91_C      T      83          3.777
LGA    D    92_C      C      84          0.702
LGA    -       -      V      85           -
LGA    -       -      P      86           -
LGA    -       -      A      87           -
LGA    -       -      G      88           -
LGA    G    93_C      C      89          0.598
LGA    V    94_C      I      90          0.844
LGA    A    95_C      V      91          1.107
LGA    D    96_C      P      92          1.657
LGA    V    97_C      I      93          1.512
LGA    S    98_C      V      94          2.159
LGA    I    99_C      F      95          3.672
LGA    E   100_C      D      96          2.781
LGA    D   101_C      K      97          4.917
LGA    S   102_C      N      98          3.955
LGA    V   103_C      -       -           -
LGA    I   104_C      Y      99          3.608
LGA    S   105_C      V     100           #
LGA    L   106_C      A     101          3.335
LGA    S   107_C      -       -           -
LGA    G   108_C      -       -           -
LGA    D   109_C      -       -           -
LGA    H   110_C      -       -           -
LGA    C   111_C      A     102          5.068
LGA    I   112_C      L     103          3.695
LGA    I   113_C      R     104          1.573
LGA    G   114_C      A     105          4.379
LGA    R   115_C      G     106          1.752
LGA    T   116_C      K     107          2.734
LGA    L   117_C      H     108          4.370
LGA    V   118_C      L     109          1.908
LGA    V   119_C      K     110          4.291
LGA    H   120_C      L     111          1.457
LGA    E   121_C      A     112          3.518
LGA    K   122_C      M     113          1.730
LGA    A   123_C      T     114           #
LGA    D   124_C      I     115           -
LGA    -       -      A     116           -
LGA    -       -      A     117           -
LGA    -       -      P     118           -
LGA    -       -      G     119           -
LGA    -       -      E     120           -
LGA    -       -      P     121           -
LGA    -       -      P     122           -
LGA    G   141_C      L     123          4.216
LGA    S   142_C      N     124          1.757
LGA    R   143_C      D     125          2.629
LGA    L   144_C      L     126          1.571
LGA    A   145_C      F     127          2.933
LGA    C   146_C      V     128          0.884
LGA    G   147_C      Q     129          1.808
LGA    V   148_C      L     130          1.217
LGA    -       -      N     131           -
LGA    -       -      G     132           -
LGA    I   149_C      F     133          2.355
LGA    G   150_C      S     134          2.617
LGA    I   151_C      N     135          1.956
LGA    A   152_C      A     136          2.870
LGA    -       -      L     137           -
LGA    -       -      N     138           -
LGA    Q   153_C      R     139          1.131
LGA    -       -      L     140           -
LGA    -       -      I     141           -
LGA    -       -      A     142           -
LGA    -       -      L     143           -
LGA    -       -      Q     144           -
LGA    -       -      K     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127  145    5.0     83    2.79     7.23     35.233     2.874

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.292869 * X  +  -0.826690 * Y  +  -0.480427 * Z  + -86.172585
  Y_new =  -0.857647 * X  +  -0.005003 * Y  +  -0.514214 * Z  +  61.102589
  Z_new =   0.422692 * X  +   0.562635 * Y  +  -0.710474 * Z  + -32.219574 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.471801   -0.669791  [ DEG:   141.6238    -38.3762 ]
  Theta =  -0.436414   -2.705179  [ DEG:   -25.0047   -154.9953 ]
  Phi   =  -1.241732    1.899861  [ DEG:   -71.1460    108.8540 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1hl4_C                                        
REMARK     2: T0514.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1hl4_C.T0514.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127  145   5.0   83   2.79    7.23  35.233
REMARK  ---------------------------------------------------------- 
MOLECULE 1hl4_C
HEADER    OXIDOREDUCTASE                          13-MAR-03   1HL4              
TITLE     THE STRUCTURE OF APO TYPE HUMAN CU, ZN SUPEROXIDE DISMUTASE           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SUPEROXIDE DISMUTASE;                                      
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 EC: 1.15.1.1;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: SACCHAROMYCES CEREVISIAE;                         
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: EG118;                                     
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: YEP351                                     
KEYWDS    OXIDOREDUCTASE, HUMAN CU, ZN SUPEROXIDE DISMUTASE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.W.STRANGE,S.ANTONYUK,M.A.HOUGH,P.DOUCETTE,J.RODRIGUEZ,              
AUTHOR   2 P.J.HART,L.J.HAYWARD,J.S.VALENTINE,S.S.HASNAIN                       
REVDAT   1   08-MAY-03 1HL4    0                                                
JRNL        AUTH   R.W.STRANGE,S.ANTONYUK,M.A.HOUGH,P.A.DOUCETTE,               
JRNL        AUTH 2 J.A.RODRIGUEZ,P.J.HART,L.J.HAYWARD,J.S.VALENTINE,            
JRNL        AUTH 3 S.S.HASNAIN                                                  
JRNL        TITL   THE STRUCTURE OF HOLO AND METAL-DEFICIENT                    
JRNL        TITL 2 WILD-TYPE HUMAN CU, ZN SUPEROXIDE DISMUTASE AND              
JRNL        TITL 3 ITS RELEVANCE TO FAMILIAL AMYOTROPHIC LATERAL                
JRNL        TITL 4 SCLEROSIS.                                                   
JRNL        REF    J.MOL.BIOL.                   V. 328   877 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.82 ANGSTROMS.                                          
DBREF  1HL4 A    1   153  UNP    P00441   SODC_HUMAN       2    154             
DBREF  1HL4 B    1   153  UNP    P00441   SODC_HUMAN       2    154             
DBREF  1HL4 C    1   153  UNP    P00441   SODC_HUMAN       2    154             
DBREF  1HL4 D    1   153  UNP    P00441   SODC_HUMAN       2    154             
SEQRES   1 A  153  ALA THR LYS ALA VAL CYS VAL LEU LYS GLY ASP GLY PRO          
SEQRES   2 A  153  VAL GLN GLY ILE ILE ASN PHE GLU GLN LYS GLU SER ASN          
SEQRES   3 A  153  GLY PRO VAL LYS VAL TRP GLY SER ILE LYS GLY LEU THR          
SEQRES   4 A  153  GLU GLY LEU HIS GLY PHE HIS VAL HIS GLU PHE GLY ASP          
SEQRES   5 A  153  ASN THR ALA GLY CYS THR SER ALA GLY PRO HIS PHE ASN          
SEQRES   6 A  153  PRO LEU SER ARG LYS HIS GLY GLY PRO LYS ASP GLU GLU          
SEQRES   7 A  153  ARG HIS VAL GLY ASP LEU GLY ASN VAL THR ALA ASP LYS          
SEQRES   8 A  153  ASP GLY VAL ALA ASP VAL SER ILE GLU ASP SER VAL ILE          
SEQRES   9 A  153  SER LEU SER GLY ASP HIS CYS ILE ILE GLY ARG THR LEU          
SEQRES  10 A  153  VAL VAL HIS GLU LYS ALA ASP ASP LEU GLY LYS GLY GLY          
SEQRES  11 A  153  ASN GLU GLU SER THR LYS THR GLY ASN ALA GLY SER ARG          
SEQRES  12 A  153  LEU ALA CYS GLY VAL ILE GLY ILE ALA GLN                      
SEQRES   1 B  153  ALA THR LYS ALA VAL CYS VAL LEU LYS GLY ASP GLY PRO          
SEQRES   2 B  153  VAL GLN GLY ILE ILE ASN PHE GLU GLN LYS GLU SER ASN          
SEQRES   3 B  153  GLY PRO VAL LYS VAL TRP GLY SER ILE LYS GLY LEU THR          
SEQRES   4 B  153  GLU GLY LEU HIS GLY PHE HIS VAL HIS GLU PHE GLY ASP          
SEQRES   5 B  153  ASN THR ALA GLY CYS THR SER ALA GLY PRO HIS PHE ASN          
SEQRES   6 B  153  PRO LEU SER ARG LYS HIS GLY GLY PRO LYS ASP GLU GLU          
SEQRES   7 B  153  ARG HIS VAL GLY ASP LEU GLY ASN VAL THR ALA ASP LYS          
SEQRES   8 B  153  ASP GLY VAL ALA ASP VAL SER ILE GLU ASP SER VAL ILE          
SEQRES   9 B  153  SER LEU SER GLY ASP HIS CYS ILE ILE GLY ARG THR LEU          
SEQRES  10 B  153  VAL VAL HIS GLU LYS ALA ASP ASP LEU GLY LYS GLY GLY          
SEQRES  11 B  153  ASN GLU GLU SER THR LYS THR GLY ASN ALA GLY SER ARG          
SEQRES  12 B  153  LEU ALA CYS GLY VAL ILE GLY ILE ALA GLN                      
SEQRES   1 C  153  ALA THR LYS ALA VAL CYS VAL LEU LYS GLY ASP GLY PRO          
SEQRES   2 C  153  VAL GLN GLY ILE ILE ASN PHE GLU GLN LYS GLU SER ASN          
SEQRES   3 C  153  GLY PRO VAL LYS VAL TRP GLY SER ILE LYS GLY LEU THR          
SEQRES   4 C  153  GLU GLY LEU HIS GLY PHE HIS VAL HIS GLU PHE GLY ASP          
SEQRES   5 C  153  ASN THR ALA GLY CYS THR SER ALA GLY PRO HIS PHE ASN          
SEQRES   6 C  153  PRO LEU SER ARG LYS HIS GLY GLY PRO LYS ASP GLU GLU          
SEQRES   7 C  153  ARG HIS VAL GLY ASP LEU GLY ASN VAL THR ALA ASP LYS          
SEQRES   8 C  153  ASP GLY VAL ALA ASP VAL SER ILE GLU ASP SER VAL ILE          
SEQRES   9 C  153  SER LEU SER GLY ASP HIS CYS ILE ILE GLY ARG THR LEU          
SEQRES  10 C  153  VAL VAL HIS GLU LYS ALA ASP ASP LEU GLY LYS GLY GLY          
SEQRES  11 C  153  ASN GLU GLU SER THR LYS THR GLY ASN ALA GLY SER ARG          
SEQRES  12 C  153  LEU ALA CYS GLY VAL ILE GLY ILE ALA GLN                      
SEQRES   1 D  153  ALA THR LYS ALA VAL CYS VAL LEU LYS GLY ASP GLY PRO          
SEQRES   2 D  153  VAL GLN GLY ILE ILE ASN PHE GLU GLN LYS GLU SER ASN          
SEQRES   3 D  153  GLY PRO VAL LYS VAL TRP GLY SER ILE LYS GLY LEU THR          
SEQRES   4 D  153  GLU GLY LEU HIS GLY PHE HIS VAL HIS GLU PHE GLY ASP          
SEQRES   5 D  153  ASN THR ALA GLY CYS THR SER ALA GLY PRO HIS PHE ASN          
SEQRES   6 D  153  PRO LEU SER ARG LYS HIS GLY GLY PRO LYS ASP GLU GLU          
SEQRES   7 D  153  ARG HIS VAL GLY ASP LEU GLY ASN VAL THR ALA ASP LYS          
SEQRES   8 D  153  ASP GLY VAL ALA ASP VAL SER ILE GLU ASP SER VAL ILE          
SEQRES   9 D  153  SER LEU SER GLY ASP HIS CYS ILE ILE GLY ARG THR LEU          
SEQRES  10 D  153  VAL VAL HIS GLU LYS ALA ASP ASP LEU GLY LYS GLY GLY          
SEQRES  11 D  153  ASN GLU GLU SER THR LYS THR GLY ASN ALA GLY SER ARG          
SEQRES  12 D  153  LEU ALA CYS GLY VAL ILE GLY ILE ALA GLN                      
HET     ZN  A 155       1                                                       
HET     ZN  B 155       1                                                       
HET    ACE  B   0       3                                                       
HETNAM      ZN ZINC ION                                                         
HETNAM     ACE ACETYL GROUP                                                     
FORMUL   5   ZN    2(ZN 2+)                                                     
FORMUL   7  ACE    C2 H4 O                                                      
FORMUL   8  HOH   *312(H2 O)                                                    
CRYST1  156.404   34.978  114.809  90.00 112.26  90.00 C 1 2 1      16          
ATOM   2193  N   ALA C   1     -96.544  33.918 -43.974  1.00 31.84           N  
ATOM   2194  CA  ALA C   1     -95.607  32.746 -44.089  1.00 30.27           C  
ATOM   2195  C   ALA C   1     -96.098  31.603 -44.967  1.00 29.28           C  
ATOM   2196  O   ALA C   1     -97.277  31.304 -45.051  1.00 30.22           O  
ATOM   2197  CB  ALA C   1     -95.217  32.222 -42.731  1.00 30.58           C  
ATOM   2198  N   THR C   2     -95.164  30.940 -45.610  1.00 27.46           N  
ATOM   2199  CA  THR C   2     -95.521  29.791 -46.408  1.00 26.15           C  
ATOM   2200  C   THR C   2     -95.221  28.497 -45.650  1.00 24.75           C  
ATOM   2201  O   THR C   2     -95.748  27.421 -46.011  1.00 26.87           O  
ATOM   2202  CB  THR C   2     -94.772  29.800 -47.759  1.00 24.31           C  
ATOM   2203  OG1 THR C   2     -93.367  29.667 -47.524  1.00 27.93           O  
ATOM   2204  CG2 THR C   2     -94.890  31.142 -48.469  1.00 24.84           C  
ATOM   2205  N   LYS C   3     -94.346  28.572 -44.649  1.00 22.88           N  
ATOM   2206  CA  LYS C   3     -94.005  27.383 -43.848  1.00 23.57           C  
ATOM   2207  C   LYS C   3     -94.089  27.600 -42.335  1.00 21.51           C  
ATOM   2208  O   LYS C   3     -93.668  28.631 -41.799  1.00 23.57           O  
ATOM   2209  CB  LYS C   3     -92.603  26.847 -44.159  1.00 23.32           C  
ATOM   2210  CG  LYS C   3     -92.384  26.385 -45.558  1.00 29.19           C  
ATOM   2211  CD  LYS C   3     -91.350  25.268 -45.584  1.00 35.51           C  
ATOM   2212  CE  LYS C   3     -91.888  24.080 -46.363  1.00 38.52           C  
ATOM   2213  NZ  LYS C   3     -91.230  22.782 -45.964  1.00 42.47           N  
ATOM   2214  N   ALA C   4     -94.606  26.595 -41.653  1.00 23.52           N  
ATOM   2215  CA  ALA C   4     -94.668  26.537 -40.223  1.00 20.46           C  
ATOM   2216  C   ALA C   4     -94.342  25.098 -39.721  1.00 20.06           C  
ATOM   2217  O   ALA C   4     -94.425  24.119 -40.460  1.00 22.40           O  
ATOM   2218  CB  ALA C   4     -96.052  27.051 -39.676  1.00 19.65           C  
ATOM   2219  N   VAL C   5     -93.989  25.033 -38.461  1.00 21.14           N  
ATOM   2220  CA  VAL C   5     -93.606  23.855 -37.720  1.00 20.89           C  
ATOM   2221  C   VAL C   5     -94.003  23.941 -36.206  1.00 20.72           C  
ATOM   2222  O   VAL C   5     -93.991  25.026 -35.539  1.00 23.35           O  
ATOM   2223  CB  VAL C   5     -92.087  23.694 -37.750  1.00 18.51           C  
ATOM   2224  CG1 VAL C   5     -91.456  24.657 -36.694  1.00 18.78           C  
ATOM   2225  CG2 VAL C   5     -91.688  22.252 -37.365  1.00 21.36           C  
ATOM   2226  N   CYS C   6     -94.287  22.768 -35.659  1.00 21.44           N  
ATOM   2227  CA  CYS C   6     -94.688  22.575 -34.309  1.00 20.67           C  
ATOM   2228  C   CYS C   6     -94.125  21.288 -33.689  1.00 18.73           C  
ATOM   2229  O   CYS C   6     -94.208  20.211 -34.271  1.00 23.17           O  
ATOM   2230  CB  CYS C   6     -96.203  22.569 -34.278  1.00 18.90           C  
ATOM   2231  SG  CYS C   6     -96.828  22.339 -32.673  1.00 27.92           S  
ATOM   2232  N   VAL C   7     -93.530  21.445 -32.525  1.00 20.33           N  
ATOM   2233  CA  VAL C   7     -93.062  20.388 -31.648  1.00 19.16           C  
ATOM   2234  C   VAL C   7     -94.131  20.126 -30.575  1.00 20.56           C  
ATOM   2235  O   VAL C   7     -94.479  21.007 -29.811  1.00 23.41           O  
ATOM   2236  CB  VAL C   7     -91.745  20.740 -30.973  1.00 17.65           C  
ATOM   2237  CG1 VAL C   7     -91.254  19.623 -29.986  1.00 18.08           C  
ATOM   2238  CG2 VAL C   7     -90.610  21.081 -32.084  1.00 16.70           C  
ATOM   2239  N   LEU C   8     -94.575  18.879 -30.530  1.00 23.79           N  
ATOM   2240  CA  LEU C   8     -95.606  18.427 -29.567  1.00 23.39           C  
ATOM   2241  C   LEU C   8     -94.941  17.728 -28.417  1.00 23.94           C  
ATOM   2242  O   LEU C   8     -94.177  16.771 -28.606  1.00 26.12           O  
ATOM   2243  CB  LEU C   8     -96.657  17.512 -30.245  1.00 23.04           C  
ATOM   2244  CG  LEU C   8     -97.284  17.985 -31.570  1.00 26.26           C  
ATOM   2245  CD1 LEU C   8     -97.902  16.900 -32.349  1.00 27.64           C  
ATOM   2246  CD2 LEU C   8     -98.311  19.085 -31.336  1.00 24.55           C  
ATOM   2247  N   LYS C   9     -95.191  18.241 -27.219  1.00 22.62           N  
ATOM   2248  CA  LYS C   9     -94.775  17.607 -25.992  1.00 22.79           C  
ATOM   2249  C   LYS C   9     -95.932  17.734 -25.024  1.00 21.78           C  
ATOM   2250  O   LYS C   9     -96.727  18.697 -25.137  1.00 23.79           O  
ATOM   2251  CB  LYS C   9     -93.543  18.292 -25.425  1.00 22.10           C  
ATOM   2252  CG  LYS C   9     -92.229  17.972 -26.167  1.00 22.72           C  
ATOM   2253  CD  LYS C   9     -91.062  18.582 -25.423  1.00 28.71           C  
ATOM   2254  CE  LYS C   9     -89.954  19.065 -26.376  1.00 29.23           C  
ATOM   2255  NZ  LYS C   9     -89.274  17.918 -27.009  1.00 34.00           N  
ATOM   2256  N   GLY C  10     -95.978  16.792 -24.087  1.00 23.97           N  
ATOM   2257  CA  GLY C  10     -96.947  16.714 -22.993  1.00 23.89           C  
ATOM   2258  C   GLY C  10     -96.398  16.186 -21.670  1.00 24.74           C  
ATOM   2259  O   GLY C  10     -95.191  16.084 -21.416  1.00 26.46           O  
ATOM   2260  N   ASP C  11     -97.292  15.798 -20.780  1.00 24.77           N  
ATOM   2261  CA  ASP C  11     -96.822  15.307 -19.501  1.00 25.24           C  
ATOM   2262  C   ASP C  11     -96.349  13.872 -19.609  1.00 24.23           C  
ATOM   2263  O   ASP C  11     -95.576  13.429 -18.772  1.00 26.74           O  
ATOM   2264  CB  ASP C  11     -97.936  15.419 -18.459  1.00 25.75           C  
ATOM   2265  CG  ASP C  11     -98.139  16.846 -18.008  1.00 29.72           C  
ATOM   2266  OD1 ASP C  11     -97.122  17.563 -17.916  1.00 35.21           O  
ATOM   2267  OD2 ASP C  11     -99.254  17.358 -17.755  1.00 34.31           O  
ATOM   2268  N   GLY C  12     -96.811  13.173 -20.650  1.00 24.57           N  
ATOM   2269  CA  GLY C  12     -96.509  11.770 -20.859  1.00 23.34           C  
ATOM   2270  C   GLY C  12     -95.450  11.594 -21.921  1.00 23.16           C  
ATOM   2271  O   GLY C  12     -94.653  12.488 -22.163  1.00 23.49           O  
ATOM   2272  N   PRO C  13     -95.480  10.455 -22.590  1.00 23.66           N  
ATOM   2273  CA  PRO C  13     -94.489  10.147 -23.621  1.00 23.87           C  
ATOM   2274  C   PRO C  13     -94.881  10.619 -25.024  1.00 23.80           C  
ATOM   2275  O   PRO C  13     -94.099  10.412 -25.978  1.00 26.14           O  
ATOM   2276  CB  PRO C  13     -94.432   8.621 -23.571  1.00 23.24           C  
ATOM   2277  CG  PRO C  13     -95.861   8.194 -23.095  1.00 22.74           C  
ATOM   2278  CD  PRO C  13     -96.498   9.402 -22.467  1.00 22.57           C  
ATOM   2279  N   VAL C  14     -96.058  11.213 -25.206  1.00 23.51           N  
ATOM   2280  CA  VAL C  14     -96.454  11.637 -26.557  1.00 23.53           C  
ATOM   2281  C   VAL C  14     -95.589  12.784 -27.073  1.00 22.86           C  
ATOM   2282  O   VAL C  14     -95.588  13.866 -26.533  1.00 25.16           O  
ATOM   2283  CB  VAL C  14     -97.965  12.027 -26.680  1.00 22.11           C  
ATOM   2284  CG1 VAL C  14     -98.322  12.471 -28.123  1.00 21.39           C  
ATOM   2285  CG2 VAL C  14     -98.860  10.901 -26.223  1.00 22.16           C  
ATOM   2286  N   GLN C  15     -94.806  12.542 -28.111  1.00 25.17           N  
ATOM   2287  CA  GLN C  15     -94.062  13.642 -28.716  1.00 24.90           C  
ATOM   2288  C   GLN C  15     -94.071  13.486 -30.225  1.00 24.77           C  
ATOM   2289  O   GLN C  15     -94.307  12.383 -30.745  1.00 25.46           O  
ATOM   2290  CB  GLN C  15     -92.643  13.751 -28.164  1.00 24.63           C  
ATOM   2291  CG  GLN C  15     -92.018  12.415 -27.913  1.00 26.98           C  
ATOM   2292  CD  GLN C  15     -90.523  12.494 -27.713  1.00 27.75           C  
ATOM   2293  OE1 GLN C  15     -89.840  13.231 -28.427  1.00 34.99           O  
ATOM   2294  NE2 GLN C  15     -90.008  11.724 -26.766  1.00 30.85           N  
ATOM   2295  N   GLY C  16     -93.826  14.597 -30.925  1.00 25.30           N  
ATOM   2296  CA  GLY C  16     -93.816  14.591 -32.370  1.00 24.64           C  
ATOM   2297  C   GLY C  16     -93.462  15.945 -32.968  1.00 23.86           C  
ATOM   2298  O   GLY C  16     -93.274  16.952 -32.244  1.00 24.92           O  
ATOM   2299  N   ILE C  17     -93.298  15.935 -34.287  1.00 23.21           N  
ATOM   2300  CA  ILE C  17     -93.067  17.127 -35.081  1.00 22.39           C  
ATOM   2301  C   ILE C  17     -94.036  17.173 -36.230  1.00 21.73           C  
ATOM   2302  O   ILE C  17     -94.191  16.207 -36.996  1.00 23.47           O  
ATOM   2303  CB  ILE C  17     -91.618  17.253 -35.562  1.00 21.23           C  
ATOM   2304  CG1 ILE C  17     -90.687  17.543 -34.367  1.00 23.05           C  
ATOM   2305  CG2 ILE C  17     -91.467  18.391 -36.577  1.00 22.53           C  
ATOM   2306  CD1 ILE C  17     -89.200  17.196 -34.689  1.00 18.56           C  
ATOM   2307  N   ILE C  18     -94.718  18.296 -36.353  1.00 21.86           N  
ATOM   2308  CA  ILE C  18     -95.656  18.465 -37.429  1.00 19.24           C  
ATOM   2309  C   ILE C  18     -95.301  19.699 -38.265  1.00 19.76           C  
ATOM   2310  O   ILE C  18     -95.029  20.812 -37.719  1.00 22.60           O  
ATOM   2311  CB  ILE C  18     -97.113  18.602 -36.824  1.00 16.27           C  
ATOM   2312  CG1 ILE C  18     -97.555  17.328 -36.075  1.00 16.34           C  
ATOM   2313  CG2 ILE C  18     -98.059  19.031 -37.912  1.00 17.46           C  
ATOM   2314  CD1 ILE C  18     -97.793  16.081 -36.996  1.00 21.55           C  
ATOM   2315  N   ASN C  19     -95.223  19.498 -39.567  1.00 23.50           N  
ATOM   2316  CA  ASN C  19     -94.887  20.535 -40.520  1.00 23.70           C  
ATOM   2317  C   ASN C  19     -96.098  21.087 -41.235  1.00 24.23           C  
ATOM   2318  O   ASN C  19     -97.069  20.373 -41.523  1.00 26.35           O  
ATOM   2319  CB  ASN C  19     -93.856  20.060 -41.562  1.00 23.64           C  
ATOM   2320  CG  ASN C  19     -92.603  19.455 -40.926  1.00 21.42           C  
ATOM   2321  OD1 ASN C  19     -92.441  18.228 -40.888  1.00 26.85           O  
ATOM   2322  ND2 ASN C  19     -91.783  20.299 -40.330  1.00 18.10           N  
ATOM   2323  N   PHE C  20     -96.071  22.384 -41.440  1.00 24.78           N  
ATOM   2324  CA  PHE C  20     -97.059  23.026 -42.303  1.00 23.81           C  
ATOM   2325  C   PHE C  20     -96.465  23.768 -43.493  1.00 23.93           C  
ATOM   2326  O   PHE C  20     -95.437  24.478 -43.393  1.00 25.70           O  
ATOM   2327  CB  PHE C  20     -97.967  23.991 -41.544  1.00 23.74           C  
ATOM   2328  CG  PHE C  20     -98.543  23.449 -40.259  1.00 23.20           C  
ATOM   2329  CD1 PHE C  20     -97.750  23.267 -39.136  1.00 21.76           C  
ATOM   2330  CD2 PHE C  20     -99.875  23.120 -40.175  1.00 24.59           C  
ATOM   2331  CE1 PHE C  20     -98.302  22.801 -37.909  1.00 25.36           C  
ATOM   2332  CE2 PHE C  20    -100.399  22.630 -39.014  1.00 19.83           C  
ATOM   2333  CZ  PHE C  20     -99.622  22.509 -37.848  1.00 21.78           C  
ATOM   2334  N   GLU C  21     -97.158  23.649 -44.613  1.00 23.32           N  
ATOM   2335  CA  GLU C  21     -96.825  24.301 -45.856  1.00 23.34           C  
ATOM   2336  C   GLU C  21     -98.011  24.797 -46.694  1.00 22.12           C  
ATOM   2337  O   GLU C  21     -98.910  24.023 -47.054  1.00 24.82           O  
ATOM   2338  CB  GLU C  21     -95.938  23.393 -46.663  1.00 21.67           C  
ATOM   2339  CG  GLU C  21     -95.449  24.011 -47.935  1.00 27.16           C  
ATOM   2340  CD  GLU C  21     -94.545  23.062 -48.713  1.00 30.80           C  
ATOM   2341  OE1 GLU C  21     -94.998  22.568 -49.767  1.00 34.14           O  
ATOM   2342  OE2 GLU C  21     -93.404  22.784 -48.262  1.00 35.11           O  
ATOM   2343  N   GLN C  22     -98.007  26.101 -46.944  1.00 23.02           N  
ATOM   2344  CA  GLN C  22     -98.964  26.817 -47.808  1.00 22.54           C  
ATOM   2345  C   GLN C  22     -98.236  27.550 -48.961  1.00 23.05           C  
ATOM   2346  O   GLN C  22     -97.555  28.590 -48.754  1.00 22.86           O  
ATOM   2347  CB  GLN C  22     -99.733  27.836 -46.996  1.00 22.83           C  
ATOM   2348  CG  GLN C  22    -101.106  28.180 -47.577  1.00 20.91           C  
ATOM   2349  CD  GLN C  22    -101.816  29.167 -46.686  1.00 21.01           C  
ATOM   2350  OE1 GLN C  22    -101.183  29.770 -45.816  1.00 26.02           O  
ATOM   2351  NE2 GLN C  22    -103.127  29.347 -46.885  1.00 27.50           N  
ATOM   2352  N   LYS C  23     -98.445  27.052 -50.167  1.00 23.29           N  
ATOM   2353  CA  LYS C  23     -97.784  27.572 -51.375  1.00 23.48           C  
ATOM   2354  C   LYS C  23     -98.410  28.883 -51.839  1.00 22.63           C  
ATOM   2355  O   LYS C  23     -97.716  29.816 -52.196  1.00 25.21           O  
ATOM   2356  CB  LYS C  23     -97.826  26.543 -52.506  1.00 24.04           C  
ATOM   2357  CG  LYS C  23     -96.747  25.436 -52.410  1.00 24.94           C  
ATOM   2358  CD  LYS C  23     -97.058  24.284 -53.353  1.00 28.54           C  
ATOM   2359  CE  LYS C  23     -95.854  23.311 -53.461  1.00 28.96           C  
ATOM   2360  NZ  LYS C  23     -95.700  22.650 -54.799  1.00 34.88           N  
ATOM   2361  N   GLU C  24     -99.731  28.958 -51.757  1.00 22.46           N  
ATOM   2362  CA  GLU C  24    -100.490  30.098 -52.212  1.00 21.19           C  
ATOM   2363  C   GLU C  24    -101.312  30.611 -51.054  1.00 20.32           C  
ATOM   2364  O   GLU C  24    -101.858  29.820 -50.261  1.00 21.37           O  
ATOM   2365  CB  GLU C  24    -101.343  29.689 -53.414  1.00 19.67           C  
ATOM   2366  CG  GLU C  24    -100.501  29.483 -54.697  1.00 26.20           C  
ATOM   2367  CD  GLU C  24    -101.033  28.382 -55.595  1.00 28.97           C  
ATOM   2368  OE1 GLU C  24    -101.856  27.557 -55.123  1.00 33.60           O  
ATOM   2369  OE2 GLU C  24    -100.628  28.336 -56.781  1.00 30.74           O  
ATOM   2370  N   SER C  25    -101.357  31.932 -50.899  1.00 19.78           N  
ATOM   2371  CA  SER C  25    -102.042  32.460 -49.721  1.00 18.08           C  
ATOM   2372  C   SER C  25    -103.519  32.158 -49.657  1.00 17.74           C  
ATOM   2373  O   SER C  25    -104.112  32.132 -48.560  1.00 20.55           O  
ATOM   2374  CB  SER C  25    -101.776  33.932 -49.520  1.00 16.13           C  
ATOM   2375  OG  SER C  25    -102.377  34.708 -50.555  1.00 15.43           O  
ATOM   2376  N   ASN C  26    -104.095  31.850 -50.792  1.00 19.91           N  
ATOM   2377  CA  ASN C  26    -105.479  31.448 -50.842  1.00 19.94           C  
ATOM   2378  C   ASN C  26    -105.601  29.975 -51.204  1.00 21.12           C  
ATOM   2379  O   ASN C  26    -106.649  29.497 -51.629  1.00 23.17           O  
ATOM   2380  CB  ASN C  26    -106.298  32.402 -51.761  1.00 20.00           C  
ATOM   2381  CG  ASN C  26    -106.021  32.237 -53.270  1.00 19.48           C  
ATOM   2382  OD1 ASN C  26    -104.938  31.847 -53.708  1.00 24.45           O  
ATOM   2383  ND2 ASN C  26    -107.022  32.572 -54.070  1.00 24.84           N  
ATOM   2384  N   GLY C  27    -104.492  29.256 -51.104  1.00 23.02           N  
ATOM   2385  CA  GLY C  27    -104.502  27.824 -51.343  1.00 23.10           C  
ATOM   2386  C   GLY C  27    -104.481  26.945 -50.089  1.00 22.46           C  
ATOM   2387  O   GLY C  27    -104.442  27.407 -48.956  1.00 23.71           O  
ATOM   2388  N   PRO C  28    -104.545  25.631 -50.274  1.00 23.45           N  
ATOM   2389  CA  PRO C  28    -104.557  24.721 -49.142  1.00 22.25           C  
ATOM   2390  C   PRO C  28    -103.247  24.666 -48.345  1.00 21.59           C  
ATOM   2391  O   PRO C  28    -102.158  25.018 -48.806  1.00 23.94           O  
ATOM   2392  CB  PRO C  28    -104.821  23.373 -49.814  1.00 21.83           C  
ATOM   2393  CG  PRO C  28    -104.201  23.572 -51.145  1.00 22.19           C  
ATOM   2394  CD  PRO C  28    -104.680  24.911 -51.554  1.00 22.39           C  
ATOM   2395  N   VAL C  29    -103.374  24.223 -47.124  1.00 22.29           N  
ATOM   2396  CA  VAL C  29    -102.221  23.989 -46.275  1.00 20.70           C  
ATOM   2397  C   VAL C  29    -101.942  22.486 -46.262  1.00 21.06           C  
ATOM   2398  O   VAL C  29    -102.826  21.661 -45.986  1.00 24.60           O  
ATOM   2399  CB  VAL C  29    -102.446  24.513 -44.831  1.00 19.31           C  
ATOM   2400  CG1 VAL C  29    -101.193  24.319 -43.934  1.00 16.24           C  
ATOM   2401  CG2 VAL C  29    -102.970  25.971 -44.800  1.00 24.27           C  
ATOM   2402  N   LYS C  30    -100.725  22.106 -46.590  1.00 21.48           N  
ATOM   2403  CA  LYS C  30    -100.278  20.730 -46.389  1.00 21.79           C  
ATOM   2404  C   LYS C  30     -99.746  20.596 -44.957  1.00 21.16           C  
ATOM   2405  O   LYS C  30     -98.947  21.431 -44.481  1.00 24.18           O  
ATOM   2406  CB  LYS C  30     -99.165  20.369 -47.380  1.00 20.13           C  
ATOM   2407  CG  LYS C  30     -99.459  20.509 -48.864  1.00 23.39           C  
ATOM   2408  CD  LYS C  30     -98.202  20.097 -49.669  1.00 26.53           C  
ATOM   2409  CE  LYS C  30     -97.866  21.136 -50.732  1.00 30.39           C  
ATOM   2410  NZ  LYS C  30     -97.155  22.321 -50.189  1.00 32.51           N  
ATOM   2411  N   VAL C  31    -100.243  19.586 -44.234  1.00 22.28           N  
ATOM   2412  CA  VAL C  31     -99.882  19.298 -42.852  1.00 20.04           C  
ATOM   2413  C   VAL C  31     -99.319  17.886 -42.757  1.00 21.20           C  
ATOM   2414  O   VAL C  31    -100.011  16.903 -43.036  1.00 24.35           O  
ATOM   2415  CB  VAL C  31    -101.119  19.440 -41.844  1.00 17.40           C  
ATOM   2416  CG1 VAL C  31    -100.668  19.187 -40.368  1.00 16.48           C  
ATOM   2417  CG2 VAL C  31    -101.830  20.739 -41.988  1.00 21.28           C  
ATOM   2418  N   TRP C  32     -98.087  17.748 -42.294  1.00 22.78           N  
ATOM   2419  CA  TRP C  32     -97.469  16.432 -42.233  1.00 21.21           C  
ATOM   2420  C   TRP C  32     -96.365  16.283 -41.217  1.00 21.56           C  
ATOM   2421  O   TRP C  32     -95.709  17.275 -40.846  1.00 23.12           O  
ATOM   2422  CB  TRP C  32     -96.898  16.022 -43.580  1.00 21.95           C  
ATOM   2423  CG  TRP C  32     -95.561  16.612 -43.877  1.00 21.06           C  
ATOM   2424  CD1 TRP C  32     -94.359  16.011 -43.739  1.00 23.58           C  
ATOM   2425  CD2 TRP C  32     -95.301  17.934 -44.326  1.00 23.87           C  
ATOM   2426  NE1 TRP C  32     -93.352  16.871 -44.097  1.00 24.57           N  
ATOM   2427  CE2 TRP C  32     -93.905  18.043 -44.516  1.00 24.82           C  
ATOM   2428  CE3 TRP C  32     -96.116  19.013 -44.696  1.00 22.62           C  
ATOM   2429  CZ2 TRP C  32     -93.295  19.209 -44.968  1.00 25.47           C  
ATOM   2430  CZ3 TRP C  32     -95.517  20.178 -45.121  1.00 27.19           C  
ATOM   2431  CH2 TRP C  32     -94.102  20.251 -45.295  1.00 28.12           C  
ATOM   2432  N   GLY C  33     -96.147  15.038 -40.791  1.00 21.91           N  
ATOM   2433  CA  GLY C  33     -95.097  14.698 -39.836  1.00 22.61           C  
ATOM   2434  C   GLY C  33     -95.315  13.371 -39.138  1.00 22.92           C  
ATOM   2435  O   GLY C  33     -95.935  12.451 -39.695  1.00 25.03           O  
ATOM   2436  N   SER C  34     -94.779  13.257 -37.928  1.00 23.96           N  
ATOM   2437  CA  SER C  34     -94.869  12.046 -37.135  1.00 24.36           C  
ATOM   2438  C   SER C  34     -95.036  12.314 -35.636  1.00 24.16           C  
ATOM   2439  O   SER C  34     -94.367  13.195 -35.069  1.00 25.32           O  
ATOM   2440  CB  SER C  34     -93.614  11.225 -37.358  1.00 22.90           C  
ATOM   2441  OG  SER C  34     -93.878   9.863 -37.070  1.00 29.51           O  
ATOM   2442  N   ILE C  35     -95.905  11.532 -34.996  1.00 24.67           N  
ATOM   2443  CA  ILE C  35     -96.109  11.565 -33.554  1.00 23.65           C  
ATOM   2444  C   ILE C  35     -96.021  10.153 -32.926  1.00 23.93           C  
ATOM   2445  O   ILE C  35     -96.631   9.203 -33.421  1.00 25.83           O  
ATOM   2446  CB  ILE C  35     -97.496  12.126 -33.180  1.00 22.57           C  
ATOM   2447  CG1 ILE C  35     -97.835  13.422 -33.924  1.00 24.39           C  
ATOM   2448  CG2 ILE C  35     -97.608  12.183 -31.623  1.00 20.03           C  
ATOM   2449  CD1 ILE C  35     -99.300  13.792 -33.824  1.00 27.79           C  
ATOM   2450  N   LYS C  36     -95.303  10.034 -31.816  1.00 25.19           N  
ATOM   2451  CA  LYS C  36     -95.156   8.773 -31.092  1.00 24.95           C  
ATOM   2452  C   LYS C  36     -95.587   8.799 -29.622  1.00 24.92           C  
ATOM   2453  O   LYS C  36     -95.846   9.870 -29.038  1.00 26.37           O  
ATOM   2454  CB  LYS C  36     -93.724   8.268 -31.193  1.00 24.46           C  
ATOM   2455  CG  LYS C  36     -92.654   9.192 -30.639  1.00 25.50           C  
ATOM   2456  CD  LYS C  36     -91.448   8.341 -30.232  1.00 27.61           C  
ATOM   2457  CE  LYS C  36     -90.050   8.990 -30.384  1.00 28.15           C  
ATOM   2458  NZ  LYS C  36     -88.978   7.952 -30.057  1.00 28.65           N  
ATOM   2459  N   GLY C  37     -95.658   7.609 -29.026  1.00 25.06           N  
ATOM   2460  CA  GLY C  37     -96.034   7.482 -27.629  1.00 23.62           C  
ATOM   2461  C   GLY C  37     -97.532   7.416 -27.478  1.00 23.16           C  
ATOM   2462  O   GLY C  37     -98.043   7.515 -26.354  1.00 24.50           O  
ATOM   2463  N   LEU C  38     -98.232   7.274 -28.605  1.00 23.50           N  
ATOM   2464  CA  LEU C  38     -99.686   7.164 -28.612  1.00 23.30           C  
ATOM   2465  C   LEU C  38    -100.197   5.745 -28.469  1.00 23.73           C  
ATOM   2466  O   LEU C  38     -99.565   4.784 -28.923  1.00 24.79           O  
ATOM   2467  CB  LEU C  38    -100.264   7.681 -29.942  1.00 21.88           C  
ATOM   2468  CG  LEU C  38    -100.599   9.092 -30.409  1.00 22.11           C  
ATOM   2469  CD1 LEU C  38    -100.801  10.059 -29.303  1.00 22.14           C  
ATOM   2470  CD2 LEU C  38     -99.502   9.561 -31.363  1.00 22.90           C  
ATOM   2471  N   THR C  39    -101.362   5.591 -27.847  1.00 24.98           N  
ATOM   2472  CA  THR C  39    -102.038   4.305 -27.879  1.00 24.90           C  
ATOM   2473  C   THR C  39    -102.559   4.044 -29.299  1.00 25.66           C  
ATOM   2474  O   THR C  39    -102.948   4.988 -30.019  1.00 25.61           O  
ATOM   2475  CB  THR C  39    -103.191   4.260 -26.858  1.00 25.74           C  
ATOM   2476  OG1 THR C  39    -104.088   5.351 -27.116  1.00 27.82           O  
ATOM   2477  CG2 THR C  39    -102.675   4.563 -25.444  1.00 23.51           C  
ATOM   2478  N   GLU C  40    -102.496   2.782 -29.725  1.00 25.85           N  
ATOM   2479  CA  GLU C  40    -102.938   2.411 -31.065  1.00 26.35           C  
ATOM   2480  C   GLU C  40    -104.358   2.909 -31.284  1.00 26.46           C  
ATOM   2481  O   GLU C  40    -105.211   2.775 -30.404  1.00 26.74           O  
ATOM   2482  CB  GLU C  40    -102.854   0.903 -31.300  1.00 26.50           C  
ATOM   2483  CG  GLU C  40    -103.416   0.413 -32.638  1.00 27.58           C  
ATOM   2484  CD  GLU C  40    -103.152  -1.080 -32.914  1.00 28.42           C  
ATOM   2485  OE1 GLU C  40    -102.566  -1.784 -32.048  1.00 30.61           O  
ATOM   2486  OE2 GLU C  40    -103.527  -1.556 -34.021  1.00 30.15           O  
ATOM   2487  N   GLY C  41    -104.581   3.505 -32.446  1.00 25.39           N  
ATOM   2488  CA  GLY C  41    -105.897   3.990 -32.818  1.00 25.52           C  
ATOM   2489  C   GLY C  41    -105.977   5.477 -33.127  1.00 25.03           C  
ATOM   2490  O   GLY C  41    -104.978   6.145 -33.433  1.00 26.35           O  
ATOM   2491  N   LEU C  42    -107.208   5.984 -33.054  1.00 24.55           N  
ATOM   2492  CA  LEU C  42    -107.540   7.340 -33.412  1.00 22.92           C  
ATOM   2493  C   LEU C  42    -107.432   8.327 -32.273  1.00 22.23           C  
ATOM   2494  O   LEU C  42    -107.853   8.057 -31.142  1.00 22.01           O  
ATOM   2495  CB  LEU C  42    -108.964   7.399 -33.940  1.00 22.81           C  
ATOM   2496  CG  LEU C  42    -109.441   7.543 -35.384  1.00 22.72           C  
ATOM   2497  CD1 LEU C  42    -108.356   7.524 -36.429  1.00 24.50           C  
ATOM   2498  CD2 LEU C  42    -110.401   6.429 -35.593  1.00 19.22           C  
ATOM   2499  N   HIS C  43    -106.901   9.488 -32.628  1.00 22.95           N  
ATOM   2500  CA  HIS C  43    -106.688  10.612 -31.731  1.00 21.87           C  
ATOM   2501  C   HIS C  43    -107.078  11.953 -32.337  1.00 21.44           C  
ATOM   2502  O   HIS C  43    -106.566  12.424 -33.412  1.00 21.57           O  
ATOM   2503  CB  HIS C  43    -105.230  10.662 -31.252  1.00 20.99           C  
ATOM   2504  CG  HIS C  43    -104.805   9.445 -30.492  1.00 22.66           C  
ATOM   2505  ND1 HIS C  43    -105.159   9.228 -29.181  1.00 22.25           N  
ATOM   2506  CD2 HIS C  43    -104.064   8.372 -30.862  1.00 17.23           C  
ATOM   2507  CE1 HIS C  43    -104.631   8.093 -28.769  1.00 23.49           C  
ATOM   2508  NE2 HIS C  43    -103.953   7.560 -29.768  1.00 24.25           N  
ATOM   2509  N   GLY C  44    -107.943  12.657 -31.621  1.00 22.01           N  
ATOM   2510  CA  GLY C  44    -108.254  14.009 -32.075  1.00 22.24           C  
ATOM   2511  C   GLY C  44    -107.028  14.902 -32.380  1.00 21.84           C  
ATOM   2512  O   GLY C  44    -105.979  14.850 -31.727  1.00 24.44           O  
ATOM   2513  N   PHE C  45    -107.181  15.751 -33.372  1.00 21.18           N  
ATOM   2514  CA  PHE C  45    -106.072  16.620 -33.850  1.00 19.77           C  
ATOM   2515  C   PHE C  45    -106.659  17.990 -34.164  1.00 20.04           C  
ATOM   2516  O   PHE C  45    -107.349  18.203 -35.169  1.00 21.91           O  
ATOM   2517  CB  PHE C  45    -105.505  15.912 -35.038  1.00 20.30           C  
ATOM   2518  CG  PHE C  45    -104.189  16.414 -35.506  1.00 18.71           C  
ATOM   2519  CD1 PHE C  45    -103.108  16.484 -34.643  1.00 24.42           C  
ATOM   2520  CD2 PHE C  45    -104.031  16.715 -36.831  1.00 19.22           C  
ATOM   2521  CE1 PHE C  45    -101.857  16.895 -35.099  1.00 20.98           C  
ATOM   2522  CE2 PHE C  45    -102.793  17.106 -37.320  1.00 20.93           C  
ATOM   2523  CZ  PHE C  45    -101.708  17.222 -36.430  1.00 24.59           C  
ATOM   2524  N   HIS C  46    -106.380  18.922 -33.276  1.00 21.59           N  
ATOM   2525  CA  HIS C  46    -106.901  20.264 -33.331  1.00 20.74           C  
ATOM   2526  C   HIS C  46    -105.903  21.362 -33.051  1.00 20.22           C  
ATOM   2527  O   HIS C  46    -104.975  21.280 -32.181  1.00 22.91           O  
ATOM   2528  CB  HIS C  46    -108.049  20.449 -32.295  1.00 20.57           C  
ATOM   2529  CG  HIS C  46    -109.299  19.690 -32.608  1.00 23.88           C  
ATOM   2530  ND1 HIS C  46    -109.561  18.444 -32.088  1.00 24.21           N  
ATOM   2531  CD2 HIS C  46    -110.369  20.011 -33.374  1.00 23.52           C  
ATOM   2532  CE1 HIS C  46    -110.723  18.017 -32.535  1.00 21.35           C  
ATOM   2533  NE2 HIS C  46    -111.243  18.956 -33.306  1.00 24.77           N  
ATOM   2534  N   VAL C  47    -106.142  22.448 -33.767  1.00 21.82           N  
ATOM   2535  CA  VAL C  47    -105.566  23.689 -33.426  1.00 22.20           C  
ATOM   2536  C   VAL C  47    -106.499  24.363 -32.437  1.00 20.99           C  
ATOM   2537  O   VAL C  47    -107.701  24.481 -32.672  1.00 24.27           O  
ATOM   2538  CB  VAL C  47    -105.387  24.573 -34.625  1.00 20.39           C  
ATOM   2539  CG1 VAL C  47    -104.953  25.951 -34.180  1.00 20.34           C  
ATOM   2540  CG2 VAL C  47    -104.343  23.975 -35.576  1.00 26.37           C  
ATOM   2541  N   HIS C  48    -105.925  24.830 -31.337  1.00 23.53           N  
ATOM   2542  CA  HIS C  48    -106.650  25.562 -30.320  1.00 23.57           C  
ATOM   2543  C   HIS C  48    -106.213  27.019 -30.409  1.00 23.52           C  
ATOM   2544  O   HIS C  48    -105.140  27.340 -30.990  1.00 24.92           O  
ATOM   2545  CB  HIS C  48    -106.376  24.982 -28.923  1.00 21.94           C  
ATOM   2546  CG  HIS C  48    -106.902  23.603 -28.746  1.00 20.83           C  
ATOM   2547  ND1 HIS C  48    -107.898  23.296 -27.828  1.00 19.02           N  
ATOM   2548  CD2 HIS C  48    -106.635  22.457 -29.415  1.00 16.33           C  
ATOM   2549  CE1 HIS C  48    -108.168  22.011 -27.909  1.00 16.25           C  
ATOM   2550  NE2 HIS C  48    -107.430  21.484 -28.865  1.00 22.47           N  
ATOM   2551  N   GLU C  49    -107.086  27.870 -29.870  1.00 23.35           N  
ATOM   2552  CA  GLU C  49    -107.023  29.319 -29.965  1.00 23.53           C  
ATOM   2553  C   GLU C  49    -105.763  30.038 -29.452  1.00 22.67           C  
ATOM   2554  O   GLU C  49    -105.281  30.917 -30.143  1.00 25.38           O  
ATOM   2555  CB  GLU C  49    -108.255  29.979 -29.341  1.00 23.22           C  
ATOM   2556  CG  GLU C  49    -108.338  31.497 -29.588  1.00 20.68           C  
ATOM   2557  CD  GLU C  49    -109.568  32.110 -28.972  1.00 24.90           C  
ATOM   2558  OE1 GLU C  49    -110.278  31.357 -28.305  1.00 26.54           O  
ATOM   2559  OE2 GLU C  49    -109.819  33.315 -29.131  1.00 29.45           O  
ATOM   2560  N   PHE C  50    -105.234  29.647 -28.301  1.00 22.73           N  
ATOM   2561  CA  PHE C  50    -104.116  30.374 -27.715  1.00 21.98           C  
ATOM   2562  C   PHE C  50    -102.786  29.639 -27.859  1.00 23.49           C  
ATOM   2563  O   PHE C  50    -102.728  28.396 -27.736  1.00 24.72           O  
ATOM   2564  CB  PHE C  50    -104.445  30.795 -26.269  1.00 21.63           C  
ATOM   2565  CG  PHE C  50    -105.740  31.548 -26.163  1.00 19.67           C  
ATOM   2566  CD1 PHE C  50    -105.933  32.739 -26.856  1.00 18.30           C  
ATOM   2567  CD2 PHE C  50    -106.799  31.049 -25.359  1.00 19.08           C  
ATOM   2568  CE1 PHE C  50    -107.136  33.435 -26.784  1.00 21.20           C  
ATOM   2569  CE2 PHE C  50    -107.989  31.708 -25.320  1.00 19.57           C  
ATOM   2570  CZ  PHE C  50    -108.170  32.916 -25.999  1.00 19.11           C  
ATOM   2571  N   GLY C  51    -101.746  30.392 -28.251  1.00 24.15           N  
ATOM   2572  CA  GLY C  51    -100.392  29.900 -28.265  1.00 23.31           C  
ATOM   2573  C   GLY C  51     -99.854  30.073 -26.858  1.00 23.79           C  
ATOM   2574  O   GLY C  51     -98.752  30.607 -26.640  1.00 25.06           O  
ATOM   2575  N   ASP C  52    -100.688  29.681 -25.883  1.00 24.81           N  
ATOM   2576  CA  ASP C  52    -100.387  29.800 -24.450  1.00 23.29           C  
ATOM   2577  C   ASP C  52    -100.215  28.417 -23.828  1.00 23.79           C  
ATOM   2578  O   ASP C  52    -101.157  27.600 -23.683  1.00 25.31           O  
ATOM   2579  CB  ASP C  52    -101.500  30.578 -23.725  1.00 24.81           C  
ATOM   2580  CG  ASP C  52    -101.197  30.901 -22.212  1.00 21.02           C  
ATOM   2581  OD1 ASP C  52    -100.521  30.148 -21.451  1.00 23.27           O  
ATOM   2582  OD2 ASP C  52    -101.627  31.954 -21.687  1.00 25.81           O  
ATOM   2583  N   ASN C  53     -98.999  28.123 -23.439  1.00 24.70           N  
ATOM   2584  CA  ASN C  53     -98.772  26.873 -22.761  1.00 25.35           C  
ATOM   2585  C   ASN C  53     -98.250  27.048 -21.305  1.00 24.44           C  
ATOM   2586  O   ASN C  53     -97.564  26.170 -20.732  1.00 25.27           O  
ATOM   2587  CB  ASN C  53     -97.921  25.962 -23.650  1.00 25.97           C  
ATOM   2588  CG  ASN C  53     -98.715  25.435 -24.936  1.00 28.39           C  
ATOM   2589  OD1 ASN C  53     -98.112  25.085 -25.966  1.00 31.32           O  
ATOM   2590  ND2 ASN C  53    -100.050  25.367 -24.847  1.00 26.43           N  
ATOM   2591  N   THR C  54     -98.593  28.165 -20.686  1.00 24.40           N  
ATOM   2592  CA  THR C  54     -98.116  28.424 -19.325  1.00 24.12           C  
ATOM   2593  C   THR C  54     -98.436  27.349 -18.286  1.00 24.13           C  
ATOM   2594  O   THR C  54     -97.653  27.111 -17.391  1.00 25.10           O  
ATOM   2595  CB  THR C  54     -98.529  29.824 -18.794  1.00 23.33           C  
ATOM   2596  OG1 THR C  54     -99.936  30.016 -18.965  1.00 25.59           O  
ATOM   2597  CG2 THR C  54     -97.902  30.942 -19.625  1.00 21.68           C  
ATOM   2598  N   ALA C  55     -99.558  26.665 -18.443  1.00 24.20           N  
ATOM   2599  CA  ALA C  55     -99.957  25.617 -17.530  1.00 24.32           C  
ATOM   2600  C   ALA C  55    -100.260  24.420 -18.375  1.00 24.23           C  
ATOM   2601  O   ALA C  55    -101.296  23.766 -18.215  1.00 25.57           O  
ATOM   2602  CB  ALA C  55    -101.187  26.028 -16.748  1.00 22.17           C  
ATOM   2603  N   GLY C  56     -99.368  24.147 -19.315  1.00 24.44           N  
ATOM   2604  CA  GLY C  56     -99.569  23.012 -20.171  1.00 22.78           C  
ATOM   2605  C   GLY C  56    -100.570  23.280 -21.268  1.00 23.12           C  
ATOM   2606  O   GLY C  56    -100.907  24.443 -21.589  1.00 24.30           O  
ATOM   2607  N   CYS C  57    -101.019  22.173 -21.835  1.00 22.60           N  
ATOM   2608  CA  CYS C  57    -101.905  22.117 -22.972  1.00 23.22           C  
ATOM   2609  C   CYS C  57    -103.264  22.742 -22.672  1.00 23.22           C  
ATOM   2610  O   CYS C  57    -103.961  23.228 -23.593  1.00 26.30           O  
ATOM   2611  CB  CYS C  57    -101.991  20.652 -23.435  1.00 20.97           C  
ATOM   2612  SG  CYS C  57    -100.419  20.067 -24.148  1.00 27.29           S  
ATOM   2613  N   THR C  58    -103.601  22.787 -21.385  1.00 25.52           N  
ATOM   2614  CA  THR C  58    -104.828  23.380 -20.921  1.00 25.37           C  
ATOM   2615  C   THR C  58    -104.918  24.871 -21.175  1.00 26.06           C  
ATOM   2616  O   THR C  58    -105.998  25.380 -21.434  1.00 26.29           O  
ATOM   2617  CB  THR C  58    -105.000  23.094 -19.420  1.00 25.62           C  
ATOM   2618  OG1 THR C  58    -105.017  21.674 -19.223  1.00 28.42           O  
ATOM   2619  CG2 THR C  58    -106.406  23.538 -18.919  1.00 23.34           C  
ATOM   2620  N   SER C  59    -103.805  25.587 -21.126  1.00 26.57           N  
ATOM   2621  CA  SER C  59    -103.878  27.027 -21.338  1.00 25.89           C  
ATOM   2622  C   SER C  59    -104.204  27.438 -22.777  1.00 24.99           C  
ATOM   2623  O   SER C  59    -104.490  28.620 -23.019  1.00 25.84           O  
ATOM   2624  CB  SER C  59    -102.605  27.750 -20.883  1.00 25.06           C  
ATOM   2625  OG  SER C  59    -101.892  26.977 -19.959  1.00 29.37           O  
ATOM   2626  N   ALA C  60    -104.170  26.486 -23.707  1.00 23.71           N  
ATOM   2627  CA  ALA C  60    -104.427  26.767 -25.135  1.00 23.50           C  
ATOM   2628  C   ALA C  60    -105.848  27.254 -25.377  1.00 22.29           C  
ATOM   2629  O   ALA C  60    -106.170  27.754 -26.446  1.00 22.95           O  
ATOM   2630  CB  ALA C  60    -104.166  25.537 -25.939  1.00 21.68           C  
ATOM   2631  N   GLY C  61    -106.734  27.023 -24.405  1.00 22.40           N  
ATOM   2632  CA  GLY C  61    -108.118  27.392 -24.601  1.00 21.34           C  
ATOM   2633  C   GLY C  61    -108.838  26.394 -25.478  1.00 20.16           C  
ATOM   2634  O   GLY C  61    -108.422  25.253 -25.631  1.00 19.81           O  
ATOM   2635  N   PRO C  62    -109.933  26.837 -26.055  1.00 21.34           N  
ATOM   2636  CA  PRO C  62    -110.786  25.999 -26.906  1.00 22.31           C  
ATOM   2637  C   PRO C  62    -110.272  25.860 -28.332  1.00 23.11           C  
ATOM   2638  O   PRO C  62    -109.289  26.481 -28.683  1.00 24.57           O  
ATOM   2639  CB  PRO C  62    -112.039  26.826 -26.993  1.00 22.61           C  
ATOM   2640  CG  PRO C  62    -111.545  28.186 -26.939  1.00 20.44           C  
ATOM   2641  CD  PRO C  62    -110.426  28.211 -25.965  1.00 20.04           C  
ATOM   2642  N   HIS C  63    -110.981  25.060 -29.130  1.00 25.64           N  
ATOM   2643  CA  HIS C  63    -110.713  24.868 -30.543  1.00 24.87           C  
ATOM   2644  C   HIS C  63    -110.693  26.240 -31.205  1.00 24.95           C  
ATOM   2645  O   HIS C  63    -111.576  27.071 -30.970  1.00 25.18           O  
ATOM   2646  CB  HIS C  63    -111.802  23.986 -31.218  1.00 25.19           C  
ATOM   2647  CG  HIS C  63    -111.895  22.582 -30.690  1.00 23.98           C  
ATOM   2648  ND1 HIS C  63    -112.750  21.648 -31.220  1.00 28.49           N  
ATOM   2649  CD2 HIS C  63    -111.239  21.955 -29.683  1.00 27.31           C  
ATOM   2650  CE1 HIS C  63    -112.615  20.503 -30.575  1.00 27.48           C  
ATOM   2651  NE2 HIS C  63    -111.700  20.662 -29.637  1.00 27.42           N  
ATOM   2652  N   PHE C  64    -109.668  26.504 -32.005  1.00 25.25           N  
ATOM   2653  CA  PHE C  64    -109.615  27.741 -32.771  1.00 25.34           C  
ATOM   2654  C   PHE C  64    -110.832  27.894 -33.697  1.00 27.11           C  
ATOM   2655  O   PHE C  64    -111.133  27.016 -34.529  1.00 28.48           O  
ATOM   2656  CB  PHE C  64    -108.319  27.779 -33.599  1.00 22.98           C  
ATOM   2657  CG  PHE C  64    -108.200  29.001 -34.504  1.00 22.00           C  
ATOM   2658  CD1 PHE C  64    -108.364  30.291 -34.004  1.00 23.16           C  
ATOM   2659  CD2 PHE C  64    -107.844  28.851 -35.851  1.00 24.64           C  
ATOM   2660  CE1 PHE C  64    -108.216  31.409 -34.827  1.00 22.13           C  
ATOM   2661  CE2 PHE C  64    -107.671  29.984 -36.692  1.00 20.89           C  
ATOM   2662  CZ  PHE C  64    -107.846  31.252 -36.191  1.00 20.96           C  
ATOM   2663  N   ASN C  65    -111.525  29.020 -33.553  1.00 29.17           N  
ATOM   2664  CA  ASN C  65    -112.730  29.306 -34.328  1.00 32.32           C  
ATOM   2665  C   ASN C  65    -113.045  30.782 -34.355  1.00 33.67           C  
ATOM   2666  O   ASN C  65    -113.848  31.294 -33.569  1.00 34.92           O  
ATOM   2667  CB  ASN C  65    -113.924  28.558 -33.758  1.00 32.42           C  
ATOM   2668  CG  ASN C  65    -114.918  28.210 -34.819  1.00 34.32           C  
ATOM   2669  OD1 ASN C  65    -114.535  27.986 -35.987  1.00 37.36           O  
ATOM   2670  ND2 ASN C  65    -116.202  28.194 -34.455  1.00 35.32           N  
ATOM   2671  N   PRO C  66    -112.448  31.456 -35.319  1.00 34.93           N  
ATOM   2672  CA  PRO C  66    -112.490  32.911 -35.415  1.00 36.37           C  
ATOM   2673  C   PRO C  66    -113.874  33.563 -35.516  1.00 37.49           C  
ATOM   2674  O   PRO C  66    -114.051  34.680 -34.991  1.00 38.56           O  
ATOM   2675  CB  PRO C  66    -111.673  33.174 -36.687  1.00 36.27           C  
ATOM   2676  CG  PRO C  66    -111.853  31.929 -37.454  1.00 35.37           C  
ATOM   2677  CD  PRO C  66    -111.713  30.850 -36.430  1.00 34.74           C  
ATOM   2678  N   LEU C  67    -114.869  32.895 -36.155  1.00 36.41           N  
ATOM   2679  CA  LEU C  67    -116.188  33.530 -36.352  1.00 36.80           C  
ATOM   2680  C   LEU C  67    -117.355  32.880 -35.568  1.00 37.34           C  
ATOM   2681  O   LEU C  67    -117.980  33.536 -34.727  1.00 37.99           O  
ATOM   2682  CB  LEU C  67    -116.434  33.651 -37.862  1.00 36.21           C  
ATOM   2683  CG  LEU C  67    -115.990  34.975 -38.495  1.00 35.69           C  
ATOM   2684  CD1 LEU C  67    -115.637  35.980 -37.393  1.00 35.85           C  
ATOM   2685  CD2 LEU C  67    -114.803  34.779 -39.427  1.00 34.22           C  
ATOM   2686  N   SER C  68    -117.674  31.634 -35.779  1.00 37.70           N  
ATOM   2687  CA  SER C  68    -118.755  31.064 -34.985  1.00 37.72           C  
ATOM   2688  CB  SER C  68    -119.788  32.118 -34.564  1.00 37.66           C  
ATOM   2689  N   ARG C  79    -117.573  22.696 -39.483  1.00 32.07           N  
ATOM   2690  CA  ARG C  79    -116.534  22.463 -38.482  1.00 32.06           C  
ATOM   2691  C   ARG C  79    -115.896  23.738 -37.982  1.00 31.72           C  
ATOM   2692  O   ARG C  79    -116.100  24.825 -38.535  1.00 33.08           O  
ATOM   2693  CB  ARG C  79    -115.397  21.587 -39.041  1.00 32.21           C  
ATOM   2694  CG  ARG C  79    -114.785  22.116 -40.332  1.00 32.22           C  
ATOM   2695  CD  ARG C  79    -113.282  22.287 -40.271  1.00 35.63           C  
ATOM   2696  NE  ARG C  79    -112.624  21.774 -41.469  1.00 37.08           N  
ATOM   2697  CZ  ARG C  79    -111.313  21.846 -41.693  1.00 34.75           C  
ATOM   2698  NH1 ARG C  79    -110.507  22.417 -40.803  1.00 33.76           N  
ATOM   2699  NH2 ARG C  79    -110.815  21.329 -42.818  1.00 33.60           N  
ATOM   2700  N   HIS C  80    -115.098  23.588 -36.933  1.00 31.26           N  
ATOM   2701  CA  HIS C  80    -114.282  24.681 -36.431  1.00 29.57           C  
ATOM   2702  C   HIS C  80    -113.058  24.804 -37.349  1.00 28.91           C  
ATOM   2703  O   HIS C  80    -112.599  23.823 -37.934  1.00 29.20           O  
ATOM   2704  CB  HIS C  80    -113.846  24.417 -34.975  1.00 29.19           C  
ATOM   2705  N   VAL C  81    -112.539  26.013 -37.481  1.00 28.88           N  
ATOM   2706  CA  VAL C  81    -111.340  26.231 -38.287  1.00 28.12           C  
ATOM   2707  C   VAL C  81    -110.212  25.325 -37.824  1.00 28.64           C  
ATOM   2708  O   VAL C  81    -109.598  24.648 -38.632  1.00 31.75           O  
ATOM   2709  CB  VAL C  81    -110.915  27.701 -38.320  1.00 27.35           C  
ATOM   2710  CG1 VAL C  81    -109.583  27.851 -39.052  1.00 26.45           C  
ATOM   2711  CG2 VAL C  81    -111.964  28.547 -39.056  1.00 27.61           C  
ATOM   2712  N   GLY C  82    -109.944  25.276 -36.532  1.00 29.36           N  
ATOM   2713  CA  GLY C  82    -108.949  24.354 -35.985  1.00 29.21           C  
ATOM   2714  C   GLY C  82    -109.104  22.825 -36.120  1.00 28.37           C  
ATOM   2715  O   GLY C  82    -108.148  22.090 -35.805  1.00 29.99           O  
ATOM   2716  N   ASP C  83    -110.265  22.353 -36.586  1.00 27.17           N  
ATOM   2717  CA  ASP C  83    -110.576  20.912 -36.671  1.00 25.79           C  
ATOM   2718  C   ASP C  83    -109.857  20.154 -37.791  1.00 24.62           C  
ATOM   2719  O   ASP C  83    -110.286  20.179 -38.910  1.00 26.78           O  
ATOM   2720  CB  ASP C  83    -112.095  20.725 -36.759  1.00 25.69           C  
ATOM   2721  CG  ASP C  83    -112.536  19.254 -36.757  1.00 25.92           C  
ATOM   2722  OD1 ASP C  83    -111.685  18.333 -36.837  0.50 27.04           O  
ATOM   2723  OD2 ASP C  83    -113.754  18.932 -36.695  0.50 27.23           O  
ATOM   2724  N   LEU C  84    -108.776  19.461 -37.465  1.00 23.69           N  
ATOM   2725  CA  LEU C  84    -108.008  18.713 -38.441  1.00 22.84           C  
ATOM   2726  C   LEU C  84    -108.292  17.185 -38.366  1.00 23.15           C  
ATOM   2727  O   LEU C  84    -107.471  16.363 -38.742  1.00 26.28           O  
ATOM   2728  CB  LEU C  84    -106.509  19.058 -38.249  1.00 21.44           C  
ATOM   2729  CG  LEU C  84    -106.074  20.526 -38.388  1.00 20.71           C  
ATOM   2730  CD1 LEU C  84    -104.531  20.619 -38.108  1.00 21.70           C  
ATOM   2731  CD2 LEU C  84    -106.517  21.063 -39.730  1.00 27.18           C  
ATOM   2732  N   GLY C  85    -109.441  16.788 -37.823  1.00 23.12           N  
ATOM   2733  CA  GLY C  85    -109.804  15.377 -37.764  1.00 22.06           C  
ATOM   2734  C   GLY C  85    -109.033  14.590 -36.708  1.00 21.69           C  
ATOM   2735  O   GLY C  85    -108.808  15.065 -35.580  1.00 22.81           O  
ATOM   2736  N   ASN C  86    -108.606  13.395 -37.082  1.00 21.56           N  
ATOM   2737  CA  ASN C  86    -107.836  12.524 -36.217  1.00 22.02           C  
ATOM   2738  C   ASN C  86    -106.524  12.150 -36.835  1.00 21.52           C  
ATOM   2739  O   ASN C  86    -106.341  12.239 -38.041  1.00 24.69           O  
ATOM   2740  CB  ASN C  86    -108.542  11.202 -35.928  1.00 21.42           C  
ATOM   2741  CG  ASN C  86    -109.859  11.371 -35.230  1.00 22.51           C  
ATOM   2742  OD1 ASN C  86    -109.918  11.824 -34.091  1.00 22.26           O  
ATOM   2743  ND2 ASN C  86    -110.929  10.972 -35.902  1.00 26.31           N  
ATOM   2744  N   VAL C  87    -105.596  11.759 -35.986  1.00 23.58           N  
ATOM   2745  CA  VAL C  87    -104.411  11.145 -36.498  1.00 23.32           C  
ATOM   2746  C   VAL C  87    -104.550   9.705 -35.981  1.00 23.19           C  
ATOM   2747  O   VAL C  87    -105.302   9.418 -35.018  1.00 26.04           O  
ATOM   2748  CB  VAL C  87    -103.086  11.906 -36.136  1.00 20.98           C  
ATOM   2749  CG1 VAL C  87    -103.026  13.392 -36.823  1.00 21.05           C  
ATOM   2750  CG2 VAL C  87    -102.795  11.875 -34.619  1.00 23.52           C  
ATOM   2751  N   THR C  88    -103.852   8.785 -36.623  1.00 24.76           N  
ATOM   2752  CA  THR C  88    -103.991   7.380 -36.322  1.00 24.97           C  
ATOM   2753  C   THR C  88    -102.685   6.729 -35.875  1.00 25.54           C  
ATOM   2754  O   THR C  88    -101.705   6.678 -36.630  1.00 27.11           O  
ATOM   2755  CB  THR C  88    -104.551   6.618 -37.535  1.00 25.43           C  
ATOM   2756  OG1 THR C  88    -105.731   7.260 -38.041  1.00 25.49           O  
ATOM   2757  CG2 THR C  88    -105.039   5.262 -37.108  1.00 24.21           C  
ATOM   2758  N   ALA C  89    -102.672   6.223 -34.655  1.00 25.52           N  
ATOM   2759  CA  ALA C  89    -101.465   5.553 -34.171  1.00 26.32           C  
ATOM   2760  C   ALA C  89    -101.518   4.081 -34.495  1.00 26.54           C  
ATOM   2761  O   ALA C  89    -102.540   3.420 -34.268  1.00 26.67           O  
ATOM   2762  CB  ALA C  89    -101.291   5.744 -32.665  1.00 26.29           C  
ATOM   2763  N   ASP C  90    -100.408   3.564 -35.022  1.00 27.29           N  
ATOM   2764  CA  ASP C  90    -100.267   2.134 -35.281  1.00 26.98           C  
ATOM   2765  C   ASP C  90    -100.001   1.313 -34.005  1.00 27.30           C  
ATOM   2766  O   ASP C  90    -100.125   1.812 -32.871  1.00 27.33           O  
ATOM   2767  CB  ASP C  90     -99.210   1.848 -36.366  1.00 26.69           C  
ATOM   2768  CG  ASP C  90     -97.788   2.206 -35.935  1.00 27.20           C  
ATOM   2769  OD1 ASP C  90     -97.544   2.354 -34.724  1.00 25.64           O  
ATOM   2770  OD2 ASP C  90     -96.835   2.360 -36.740  1.00 28.94           O  
ATOM   2771  N   LYS C  91     -99.639   0.052 -34.198  1.00 27.23           N  
ATOM   2772  CA  LYS C  91     -99.434  -0.842 -33.071  1.00 27.17           C  
ATOM   2773  C   LYS C  91     -98.254  -0.404 -32.220  1.00 27.29           C  
ATOM   2774  O   LYS C  91     -98.228  -0.627 -31.019  1.00 27.95           O  
ATOM   2775  CB  LYS C  91     -99.355  -2.322 -33.508  1.00 26.88           C  
ATOM   2776  CG  LYS C  91     -98.477  -2.649 -34.736  1.00 27.09           C  
ATOM   2777  CD  LYS C  91     -96.985  -2.720 -34.350  1.00 26.25           C  
ATOM   2778  N   ASP C  92     -97.294   0.263 -32.846  1.00 27.89           N  
ATOM   2779  CA  ASP C  92     -96.125   0.742 -32.121  1.00 27.72           C  
ATOM   2780  C   ASP C  92     -96.221   2.192 -31.638  1.00 26.79           C  
ATOM   2781  O   ASP C  92     -95.192   2.852 -31.481  1.00 26.98           O  
ATOM   2782  CB  ASP C  92     -94.875   0.556 -32.982  1.00 28.57           C  
ATOM   2783  CG  ASP C  92     -94.460  -0.886 -33.093  1.00 31.17           C  
ATOM   2784  OD1 ASP C  92     -94.877  -1.711 -32.232  1.00 34.68           O  
ATOM   2785  OD2 ASP C  92     -93.706  -1.298 -34.011  1.00 34.33           O  
ATOM   2786  N   GLY C  93     -97.443   2.697 -31.419  1.00 25.72           N  
ATOM   2787  CA  GLY C  93     -97.667   4.049 -30.913  1.00 24.51           C  
ATOM   2788  C   GLY C  93     -97.318   5.192 -31.864  1.00 23.56           C  
ATOM   2789  O   GLY C  93     -97.279   6.371 -31.481  1.00 24.98           O  
ATOM   2790  N   VAL C  94     -97.077   4.839 -33.116  1.00 23.14           N  
ATOM   2791  CA  VAL C  94     -96.660   5.824 -34.092  1.00 22.36           C  
ATOM   2792  C   VAL C  94     -97.728   6.217 -35.103  1.00 23.36           C  
ATOM   2793  O   VAL C  94     -98.244   5.385 -35.860  1.00 24.66           O  
ATOM   2794  CB  VAL C  94     -95.385   5.408 -34.829  1.00 21.90           C  
ATOM   2795  CG1 VAL C  94     -94.940   6.554 -35.729  1.00 19.10           C  
ATOM   2796  CG2 VAL C  94     -94.277   5.056 -33.837  1.00 21.41           C  
ATOM   2797  N   ALA C  95     -98.051   7.505 -35.096  1.00 24.28           N  
ATOM   2798  CA  ALA C  95     -98.980   8.060 -36.041  1.00 25.22           C  
ATOM   2799  C   ALA C  95     -98.235   8.860 -37.088  1.00 25.47           C  
ATOM   2800  O   ALA C  95     -97.555   9.847 -36.759  1.00 27.79           O  
ATOM   2801  CB  ALA C  95    -100.013   8.946 -35.327  1.00 24.02           C  
ATOM   2802  N   ASP C  96     -98.336   8.437 -38.348  1.00 26.75           N  
ATOM   2803  CA  ASP C  96     -97.847   9.295 -39.430  1.00 26.90           C  
ATOM   2804  C   ASP C  96     -98.949  10.192 -39.976  1.00 26.28           C  
ATOM   2805  O   ASP C  96    -100.107   9.762 -40.247  1.00 26.96           O  
ATOM   2806  CB  ASP C  96     -97.138   8.525 -40.534  1.00 27.88           C  
ATOM   2807  CG  ASP C  96     -95.719   8.167 -40.153  1.00 30.52           C  
ATOM   2808  OD1 ASP C  96     -95.433   6.968 -39.966  1.00 35.36           O  
ATOM   2809  OD2 ASP C  96     -94.826   9.025 -39.996  1.00 35.60           O  
ATOM   2810  N   VAL C  97     -98.601  11.456 -40.136  1.00 25.07           N  
ATOM   2811  CA  VAL C  97     -99.603  12.412 -40.502  1.00 24.01           C  
ATOM   2812  C   VAL C  97     -99.342  12.951 -41.860  1.00 24.25           C  
ATOM   2813  O   VAL C  97     -98.218  13.275 -42.188  1.00 26.92           O  
ATOM   2814  CB  VAL C  97     -99.693  13.561 -39.451  1.00 22.14           C  
ATOM   2815  CG1 VAL C  97    -100.726  14.658 -39.866  1.00 22.70           C  
ATOM   2816  CG2 VAL C  97     -99.962  12.985 -38.001  1.00 22.91           C  
ATOM   2817  N   SER C  98    -100.392  12.972 -42.665  1.00 25.33           N  
ATOM   2818  CA  SER C  98    -100.416  13.669 -43.936  1.00 25.88           C  
ATOM   2819  C   SER C  98    -101.840  14.092 -44.229  1.00 25.52           C  
ATOM   2820  O   SER C  98    -102.682  13.264 -44.604  1.00 27.02           O  
ATOM   2821  CB  SER C  98     -99.881  12.809 -45.076  1.00 25.18           C  
ATOM   2822  OG  SER C  98    -100.094  13.425 -46.329  1.00 29.03           O  
ATOM   2823  N   ILE C  99    -102.061  15.393 -44.106  1.00 26.20           N  
ATOM   2824  CA  ILE C  99    -103.350  16.021 -44.271  1.00 25.34           C  
ATOM   2825  C   ILE C  99    -103.244  17.261 -45.160  1.00 25.87           C  
ATOM   2826  O   ILE C  99    -102.284  18.055 -45.064  1.00 26.47           O  
ATOM   2827  CB  ILE C  99    -103.826  16.518 -42.906  1.00 25.24           C  
ATOM   2828  CG1 ILE C  99    -104.175  15.344 -41.972  1.00 23.85           C  
ATOM   2829  CG2 ILE C  99    -104.948  17.516 -43.104  1.00 24.57           C  
ATOM   2830  CD1 ILE C  99    -104.149  15.728 -40.497  1.00 20.82           C  
ATOM   2831  N   GLU C 100    -104.252  17.438 -46.011  1.00 26.30           N  
ATOM   2832  CA  GLU C 100    -104.428  18.679 -46.726  1.00 25.79           C  
ATOM   2833  C   GLU C 100    -105.695  19.383 -46.221  1.00 26.18           C  
ATOM   2834  O   GLU C 100    -106.782  18.808 -46.183  1.00 27.87           O  
ATOM   2835  CB  GLU C 100    -104.454  18.479 -48.245  1.00 25.07           C  
ATOM   2836  CG  GLU C 100    -104.915  19.712 -49.010  1.00 25.43           C  
ATOM   2837  CD  GLU C 100    -104.610  19.679 -50.502  0.50 25.27           C  
ATOM   2838  OE1 GLU C 100    -103.504  19.224 -50.889  0.50 25.46           O  
ATOM   2839  OE2 GLU C 100    -105.488  20.113 -51.287  0.50 24.44           O  
ATOM   2840  N   ASP C 101    -105.544  20.634 -45.830  1.00 26.39           N  
ATOM   2841  CA  ASP C 101    -106.695  21.393 -45.344  1.00 26.33           C  
ATOM   2842  C   ASP C 101    -106.844  22.780 -46.010  1.00 25.68           C  
ATOM   2843  O   ASP C 101    -105.877  23.545 -46.158  1.00 26.52           O  
ATOM   2844  CB  ASP C 101    -106.668  21.486 -43.823  1.00 26.02           C  
ATOM   2845  CG  ASP C 101    -107.984  21.919 -43.265  1.00 26.46           C  
ATOM   2846  OD1 ASP C 101    -108.853  21.062 -43.161  1.00 31.33           O  
ATOM   2847  OD2 ASP C 101    -108.260  23.102 -42.996  1.00 31.07           O  
ATOM   2848  N   SER C 102    -108.079  23.117 -46.345  1.00 25.53           N  
ATOM   2849  CA  SER C 102    -108.368  24.350 -47.050  1.00 25.29           C  
ATOM   2850  C   SER C 102    -109.089  25.387 -46.215  1.00 24.62           C  
ATOM   2851  O   SER C 102    -109.635  26.363 -46.743  1.00 26.36           O  
ATOM   2852  CB  SER C 102    -109.179  24.029 -48.294  1.00 24.64           C  
ATOM   2853  OG  SER C 102    -108.330  23.583 -49.350  1.00 28.96           O  
ATOM   2854  N   VAL C 103    -109.117  25.161 -44.917  1.00 25.34           N  
ATOM   2855  CA  VAL C 103    -109.810  26.062 -44.022  1.00 23.22           C  
ATOM   2856  C   VAL C 103    -108.799  26.816 -43.207  1.00 22.02           C  
ATOM   2857  O   VAL C 103    -108.872  28.039 -43.133  1.00 25.40           O  
ATOM   2858  CB  VAL C 103    -110.797  25.313 -43.147  1.00 21.92           C  
ATOM   2859  CG1 VAL C 103    -111.481  26.311 -42.203  1.00 21.98           C  
ATOM   2860  CG2 VAL C 103    -111.823  24.625 -44.035  1.00 24.84           C  
ATOM   2861  N   ILE C 104    -107.851  26.104 -42.625  1.00 23.74           N  
ATOM   2862  CA  ILE C 104    -106.758  26.728 -41.904  1.00 22.78           C  
ATOM   2863  C   ILE C 104    -105.914  27.459 -42.929  1.00 23.13           C  
ATOM   2864  O   ILE C 104    -105.959  27.127 -44.096  1.00 24.56           O  
ATOM   2865  CB  ILE C 104    -105.852  25.715 -41.131  1.00 23.17           C  
ATOM   2866  CG1 ILE C 104    -105.249  24.641 -42.086  1.00 16.75           C  
ATOM   2867  CG2 ILE C 104    -106.609  25.199 -39.869  1.00 19.21           C  
ATOM   2868  CD1 ILE C 104    -104.052  23.935 -41.530  1.00 20.65           C  
ATOM   2869  N   SER C 105    -105.178  28.456 -42.462  1.00 23.55           N  
ATOM   2870  CA  SER C 105    -104.206  29.178 -43.257  1.00 23.44           C  
ATOM   2871  C   SER C 105    -102.951  29.503 -42.437  1.00 22.77           C  
ATOM   2872  O   SER C 105    -102.953  29.445 -41.183  1.00 26.84           O  
ATOM   2873  CB  SER C 105    -104.860  30.449 -43.860  1.00 20.04           C  
ATOM   2874  OG  SER C 105    -104.046  31.051 -44.844  1.00 26.31           O  
ATOM   2875  N   LEU C 106    -101.850  29.742 -43.133  1.00 23.01           N  
ATOM   2876  CA  LEU C 106    -100.636  30.229 -42.499  1.00 21.25           C  
ATOM   2877  C   LEU C 106    -100.558  31.783 -42.494  1.00 21.89           C  
ATOM   2878  O   LEU C 106     -99.556  32.365 -42.038  1.00 24.36           O  
ATOM   2879  CB  LEU C 106     -99.394  29.571 -43.155  1.00 19.44           C  
ATOM   2880  CG  LEU C 106     -99.287  28.042 -42.966  1.00 18.51           C  
ATOM   2881  CD1 LEU C 106     -97.931  27.427 -43.411  1.00 21.17           C  
ATOM   2882  CD2 LEU C 106     -99.568  27.564 -41.539  1.00 22.60           C  
ATOM   2883  N   SER C 107    -101.599  32.464 -42.989  1.00 23.01           N  
ATOM   2884  CA  SER C 107    -101.680  33.938 -42.934  1.00 23.69           C  
ATOM   2885  C   SER C 107    -103.136  34.391 -42.941  1.00 23.85           C  
ATOM   2886  O   SER C 107    -104.034  33.567 -43.066  1.00 25.65           O  
ATOM   2887  CB  SER C 107    -100.899  34.617 -44.101  1.00 21.64           C  
ATOM   2888  OG  SER C 107    -101.511  34.417 -45.370  1.00 25.94           O  
ATOM   2889  N   GLY C 108    -103.373  35.693 -42.801  1.00 26.02           N  
ATOM   2890  CA  GLY C 108    -104.723  36.229 -42.755  1.00 26.30           C  
ATOM   2891  C   GLY C 108    -105.550  35.815 -41.541  1.00 26.99           C  
ATOM   2892  O   GLY C 108    -105.029  35.459 -40.496  1.00 28.48           O  
ATOM   2893  N   ASP C 109    -106.868  35.847 -41.703  1.00 28.66           N  
ATOM   2894  CA  ASP C 109    -107.811  35.650 -40.599  1.00 28.13           C  
ATOM   2895  C   ASP C 109    -107.923  34.226 -40.076  1.00 27.60           C  
ATOM   2896  O   ASP C 109    -108.313  34.019 -38.936  1.00 27.61           O  
ATOM   2897  CB  ASP C 109    -109.179  36.172 -41.040  1.00 28.91           C  
ATOM   2898  CG  ASP C 109    -110.276  35.935 -40.010  1.00 31.45           C  
ATOM   2899  OD1 ASP C 109    -110.231  36.557 -38.920  1.00 35.36           O  
ATOM   2900  OD2 ASP C 109    -111.245  35.163 -40.220  1.00 34.12           O  
ATOM   2901  N   HIS C 110    -107.554  33.239 -40.886  1.00 27.54           N  
ATOM   2902  CA  HIS C 110    -107.591  31.869 -40.416  1.00 27.01           C  
ATOM   2903  C   HIS C 110    -106.183  31.409 -40.038  1.00 26.91           C  
ATOM   2904  O   HIS C 110    -105.965  30.204 -39.850  1.00 26.26           O  
ATOM   2905  CB  HIS C 110    -108.225  30.898 -41.431  1.00 27.09           C  
ATOM   2906  CG  HIS C 110    -109.705  31.060 -41.609  1.00 25.37           C  
ATOM   2907  ND1 HIS C 110    -110.458  30.162 -42.333  1.00 28.21           N  
ATOM   2908  CD2 HIS C 110    -110.571  31.991 -41.148  1.00 25.12           C  
ATOM   2909  CE1 HIS C 110    -111.725  30.536 -42.316  1.00 27.99           C  
ATOM   2910  NE2 HIS C 110    -111.820  31.646 -41.607  1.00 30.18           N  
ATOM   2911  N   CYS C 111    -105.261  32.378 -39.904  1.00 27.28           N  
ATOM   2912  CA  CYS C 111    -103.879  32.084 -39.559  1.00 25.86           C  
ATOM   2913  C   CYS C 111    -103.729  31.327 -38.205  1.00 23.67           C  
ATOM   2914  O   CYS C 111    -104.189  31.762 -37.154  1.00 24.44           O  
ATOM   2915  CB  CYS C 111    -102.965  33.318 -39.680  1.00 23.77           C  
ATOM   2916  SG  CYS C 111    -101.241  33.082 -39.163  1.00 30.89           S  
ATOM   2917  N   ILE C 112    -103.034  30.218 -38.272  1.00 23.43           N  
ATOM   2918  CA  ILE C 112    -102.809  29.334 -37.111  1.00 22.55           C  
ATOM   2919  C   ILE C 112    -101.408  29.515 -36.492  1.00 22.79           C  
ATOM   2920  O   ILE C 112    -101.126  28.951 -35.450  1.00 23.51           O  
ATOM   2921  CB  ILE C 112    -103.092  27.885 -37.488  1.00 20.64           C  
ATOM   2922  CG1 ILE C 112    -102.046  27.343 -38.515  1.00 13.19           C  
ATOM   2923  CG2 ILE C 112    -104.562  27.700 -37.982  1.00 18.36           C  
ATOM   2924  CD1 ILE C 112    -102.260  25.907 -38.856  1.00 20.31           C  
ATOM   2925  N   ILE C 113    -100.517  30.263 -37.173  1.00 23.94           N  
ATOM   2926  CA  ILE C 113     -99.260  30.625 -36.544  1.00 23.18           C  
ATOM   2927  C   ILE C 113     -99.407  31.394 -35.201  1.00 22.18           C  
ATOM   2928  O   ILE C 113    -100.097  32.422 -35.068  1.00 25.41           O  
ATOM   2929  CB  ILE C 113     -98.315  31.380 -37.574  1.00 21.57           C  
ATOM   2930  CG1 ILE C 113     -98.135  30.498 -38.834  1.00 22.95           C  
ATOM   2931  CG2 ILE C 113     -97.091  31.889 -36.796  1.00 23.39           C  
ATOM   2932  CD1 ILE C 113     -97.186  31.024 -39.822  1.00 21.54           C  
ATOM   2933  N   GLY C 114     -98.784  30.859 -34.155  1.00 23.14           N  
ATOM   2934  CA  GLY C 114     -98.801  31.459 -32.842  1.00 22.62           C  
ATOM   2935  C   GLY C 114     -99.935  30.810 -32.058  1.00 19.44           C  
ATOM   2936  O   GLY C 114    -100.192  31.115 -30.923  1.00 22.53           O  
ATOM   2937  N   ARG C 115    -100.616  29.840 -32.649  1.00 22.58           N  
ATOM   2938  CA  ARG C 115    -101.630  29.223 -31.900  1.00 21.87           C  
ATOM   2939  C   ARG C 115    -100.992  27.844 -31.535  1.00 22.49           C  
ATOM   2940  O   ARG C 115     -99.814  27.568 -31.886  1.00 25.85           O  
ATOM   2941  CB  ARG C 115    -102.938  29.165 -32.734  1.00 20.44           C  
ATOM   2942  CG  ARG C 115    -103.391  30.559 -33.130  1.00 17.25           C  
ATOM   2943  CD  ARG C 115    -104.846  30.678 -33.631  1.00 23.21           C  
ATOM   2944  NE  ARG C 115    -105.128  32.014 -34.155  1.00 21.83           N  
ATOM   2945  CZ  ARG C 115    -105.672  32.995 -33.435  1.00 20.14           C  
ATOM   2946  NH1 ARG C 115    -105.996  32.801 -32.161  1.00 25.94           N  
ATOM   2947  NH2 ARG C 115    -105.904  34.186 -33.977  1.00 23.40           N  
ATOM   2948  N   THR C 116    -101.725  27.016 -30.828  1.00 21.26           N  
ATOM   2949  CA  THR C 116    -101.333  25.661 -30.401  1.00 19.98           C  
ATOM   2950  C   THR C 116    -101.990  24.494 -31.177  1.00 20.12           C  
ATOM   2951  O   THR C 116    -103.245  24.366 -31.337  1.00 24.10           O  
ATOM   2952  CB  THR C 116    -101.668  25.524 -28.854  1.00 17.87           C  
ATOM   2953  OG1 THR C 116    -100.939  26.489 -28.107  1.00 21.83           O  
ATOM   2954  CG2 THR C 116    -101.375  24.114 -28.207  1.00 15.68           C  
ATOM   2955  N   LEU C 117    -101.139  23.615 -31.669  1.00 20.17           N  
ATOM   2956  CA  LEU C 117    -101.583  22.311 -32.134  1.00 18.98           C  
ATOM   2957  C   LEU C 117    -101.639  21.320 -30.943  1.00 19.25           C  
ATOM   2958  O   LEU C 117    -100.709  21.271 -30.095  1.00 21.56           O  
ATOM   2959  CB  LEU C 117    -100.588  21.832 -33.155  1.00 16.42           C  
ATOM   2960  CG  LEU C 117    -100.942  20.493 -33.836  1.00 14.89           C  
ATOM   2961  CD1 LEU C 117    -102.189  20.622 -34.683  1.00 22.01           C  
ATOM   2962  CD2 LEU C 117     -99.717  20.013 -34.690  1.00 17.70           C  
ATOM   2963  N   VAL C 118    -102.720  20.551 -30.837  1.00 19.97           N  
ATOM   2964  CA  VAL C 118    -102.969  19.577 -29.748  1.00 19.06           C  
ATOM   2965  C   VAL C 118    -103.453  18.216 -30.279  1.00 17.72           C  
ATOM   2966  O   VAL C 118    -104.392  18.103 -31.106  1.00 21.23           O  
ATOM   2967  CB  VAL C 118    -104.149  20.066 -28.757  1.00 15.62           C  
ATOM   2968  CG1 VAL C 118    -104.455  19.016 -27.683  1.00 18.95           C  
ATOM   2969  CG2 VAL C 118    -103.832  21.412 -28.083  1.00 20.41           C  
ATOM   2970  N   VAL C 119    -102.773  17.176 -29.873  1.00 19.76           N  
ATOM   2971  CA  VAL C 119    -103.201  15.826 -30.087  1.00 19.62           C  
ATOM   2972  C   VAL C 119    -103.921  15.284 -28.835  1.00 19.88           C  
ATOM   2973  O   VAL C 119    -103.339  15.155 -27.723  1.00 21.58           O  
ATOM   2974  CB  VAL C 119    -102.047  14.927 -30.460  1.00 18.48           C  
ATOM   2975  CG1 VAL C 119    -100.959  14.940 -29.409  1.00 22.03           C  
ATOM   2976  CG2 VAL C 119    -102.554  13.553 -30.727  1.00 19.58           C  
ATOM   2977  N   HIS C 120    -105.184  14.935 -29.030  1.00 22.02           N  
ATOM   2978  CA  HIS C 120    -106.023  14.484 -27.925  1.00 20.18           C  
ATOM   2979  C   HIS C 120    -105.999  12.993 -27.510  1.00 21.62           C  
ATOM   2980  O   HIS C 120    -105.623  12.095 -28.272  1.00 23.38           O  
ATOM   2981  CB  HIS C 120    -107.448  14.923 -28.179  1.00 20.06           C  
ATOM   2982  CG  HIS C 120    -107.655  16.404 -28.089  1.00 20.92           C  
ATOM   2983  ND1 HIS C 120    -108.343  16.997 -27.050  1.00 23.94           N  
ATOM   2984  CD2 HIS C 120    -107.298  17.404 -28.926  1.00 21.12           C  
ATOM   2985  CE1 HIS C 120    -108.391  18.302 -27.251  1.00 21.28           C  
ATOM   2986  NE2 HIS C 120    -107.776  18.572 -28.392  1.00 21.95           N  
ATOM   2987  N   GLU C 121    -106.450  12.723 -26.292  1.00 23.54           N  
ATOM   2988  CA  GLU C 121    -106.524  11.334 -25.797  1.00 23.41           C  
ATOM   2989  C   GLU C 121    -107.408  10.420 -26.650  1.00 23.86           C  
ATOM   2990  O   GLU C 121    -106.958   9.369 -27.123  1.00 24.41           O  
ATOM   2991  CB  GLU C 121    -106.996  11.265 -24.344  1.00 22.52           C  
ATOM   2992  CG  GLU C 121    -106.829   9.876 -23.745  1.00 26.36           C  
ATOM   2993  CD  GLU C 121    -107.049   9.851 -22.248  1.00 32.22           C  
ATOM   2994  OE1 GLU C 121    -106.459   8.963 -21.588  1.00 37.56           O  
ATOM   2995  OE2 GLU C 121    -107.805  10.712 -21.725  1.00 32.79           O  
ATOM   2996  N   LYS C 122    -108.659  10.816 -26.858  1.00 24.12           N  
ATOM   2997  CA  LYS C 122    -109.597   9.993 -27.603  1.00 24.18           C  
ATOM   2998  C   LYS C 122    -109.864  10.512 -29.013  1.00 25.24           C  
ATOM   2999  O   LYS C 122    -109.654  11.701 -29.296  1.00 26.33           O  
ATOM   3000  CB  LYS C 122    -110.936   9.950 -26.867  1.00 23.51           C  
ATOM   3001  CG  LYS C 122    -110.907   9.849 -25.346  1.00 23.04           C  
ATOM   3002  N   ALA C 123    -110.326   9.628 -29.897  1.00 26.57           N  
ATOM   3003  CA  ALA C 123    -110.764  10.027 -31.232  1.00 27.55           C  
ATOM   3004  C   ALA C 123    -111.824  11.136 -31.198  1.00 28.62           C  
ATOM   3005  O   ALA C 123    -112.627  11.218 -30.252  1.00 29.23           O  
ATOM   3006  CB  ALA C 123    -111.297   8.847 -31.975  1.00 27.12           C  
ATOM   3007  N   ASP C 124    -111.789  11.995 -32.219  1.00 29.87           N  
ATOM   3008  CA  ASP C 124    -112.775  13.055 -32.432  1.00 30.72           C  
ATOM   3009  C   ASP C 124    -114.144  12.392 -32.497  1.00 31.27           C  
ATOM   3010  O   ASP C 124    -114.349  11.417 -33.252  1.00 32.48           O  
ATOM   3011  CB  ASP C 124    -112.528  13.731 -33.779  1.00 30.88           C  
ATOM   3012  CG  ASP C 124    -112.478  15.227 -33.681  1.00 31.90           C  
ATOM   3013  OD1 ASP C 124    -112.190  15.706 -32.570  1.00 35.16           O  
ATOM   3014  OD2 ASP C 124    -112.666  16.007 -34.666  1.00 34.14           O  
ATOM   3015  N   GLY C 141    -110.731  14.030 -26.128  1.00 32.84           N  
ATOM   3016  CA  GLY C 141    -109.918  13.379 -25.123  1.00 31.01           C  
ATOM   3017  C   GLY C 141    -109.131  14.401 -24.331  1.00 31.06           C  
ATOM   3018  O   GLY C 141    -109.094  15.582 -24.726  1.00 31.34           O  
ATOM   3019  N   SER C 142    -108.563  13.964 -23.190  1.00 30.31           N  
ATOM   3020  CA  SER C 142    -107.703  14.799 -22.374  1.00 28.39           C  
ATOM   3021  C   SER C 142    -106.607  15.234 -23.366  1.00 26.61           C  
ATOM   3022  O   SER C 142    -106.565  14.730 -24.486  1.00 27.37           O  
ATOM   3023  CB  SER C 142    -107.167  14.023 -21.159  1.00 28.55           C  
ATOM   3024  OG  SER C 142    -105.770  13.748 -21.246  1.00 30.32           O  
ATOM   3025  N   ARG C 143    -105.772  16.195 -23.001  1.00 25.73           N  
ATOM   3026  CA  ARG C 143    -104.788  16.701 -23.978  1.00 24.51           C  
ATOM   3027  C   ARG C 143    -103.443  16.056 -23.771  1.00 24.70           C  
ATOM   3028  O   ARG C 143    -102.711  16.436 -22.863  1.00 26.65           O  
ATOM   3029  CB  ARG C 143    -104.678  18.232 -23.904  1.00 23.86           C  
ATOM   3030  CG  ARG C 143    -105.984  18.915 -24.259  1.00 22.40           C  
ATOM   3031  CD  ARG C 143    -106.036  20.401 -23.915  1.00 22.52           C  
ATOM   3032  NE  ARG C 143    -107.370  20.938 -24.178  1.00 26.15           N  
ATOM   3033  CZ  ARG C 143    -107.644  22.221 -24.318  1.00 22.12           C  
ATOM   3034  NH1 ARG C 143    -106.674  23.140 -24.266  1.00 27.01           N  
ATOM   3035  NH2 ARG C 143    -108.901  22.586 -24.527  1.00 23.86           N  
ATOM   3036  N   LEU C 144    -103.094  15.144 -24.669  1.00 25.01           N  
ATOM   3037  CA  LEU C 144    -101.845  14.383 -24.614  1.00 24.64           C  
ATOM   3038  C   LEU C 144    -100.502  15.115 -24.824  1.00 24.81           C  
ATOM   3039  O   LEU C 144     -99.565  14.899 -24.042  1.00 25.78           O  
ATOM   3040  CB  LEU C 144    -101.943  13.170 -25.551  1.00 24.13           C  
ATOM   3041  CG  LEU C 144    -103.147  12.246 -25.281  1.00 22.90           C  
ATOM   3042  CD1 LEU C 144    -103.075  11.003 -26.133  1.00 19.99           C  
ATOM   3043  CD2 LEU C 144    -103.260  11.880 -23.839  1.00 18.92           C  
ATOM   3044  N   ALA C 145    -100.420  15.952 -25.858  1.00 23.90           N  
ATOM   3045  CA  ALA C 145     -99.233  16.736 -26.189  1.00 22.37           C  
ATOM   3046  C   ALA C 145     -99.671  17.924 -27.028  1.00 22.29           C  
ATOM   3047  O   ALA C 145    -100.725  17.852 -27.722  1.00 25.55           O  
ATOM   3048  CB  ALA C 145     -98.233  15.888 -26.953  1.00 18.16           C  
ATOM   3049  N   CYS C 146     -98.884  18.998 -26.973  1.00 22.88           N  
ATOM   3050  CA  CYS C 146     -99.068  20.233 -27.725  1.00 22.62           C  
ATOM   3051  C   CYS C 146     -97.775  21.003 -27.954  1.00 21.49           C  
ATOM   3052  O   CYS C 146     -96.708  20.654 -27.392  1.00 22.80           O  
ATOM   3053  CB  CYS C 146    -100.083  21.165 -27.034  1.00 20.71           C  
ATOM   3054  SG  CYS C 146     -99.689  21.602 -25.344  1.00 26.09           S  
ATOM   3055  N   GLY C 147     -97.920  22.131 -28.651  1.00 22.58           N  
ATOM   3056  CA  GLY C 147     -96.828  23.014 -29.088  1.00 20.69           C  
ATOM   3057  C   GLY C 147     -97.415  24.209 -29.760  1.00 18.53           C  
ATOM   3058  O   GLY C 147     -98.516  24.114 -30.414  1.00 22.88           O  
ATOM   3059  N   VAL C 148     -96.734  25.330 -29.627  1.00 20.60           N  
ATOM   3060  CA  VAL C 148     -97.146  26.537 -30.319  1.00 18.96           C  
ATOM   3061  C   VAL C 148     -96.680  26.394 -31.819  1.00 19.87           C  
ATOM   3062  O   VAL C 148     -95.578  25.980 -32.085  1.00 23.88           O  
ATOM   3063  CB  VAL C 148     -96.578  27.794 -29.623  1.00 17.13           C  
ATOM   3064  CG1 VAL C 148     -97.078  29.161 -30.305  1.00 17.43           C  
ATOM   3065  CG2 VAL C 148     -96.755  27.775 -28.021  1.00 21.64           C  
ATOM   3066  N   ILE C 149     -97.504  26.705 -32.797  1.00 20.31           N  
ATOM   3067  CA  ILE C 149     -97.055  26.698 -34.216  1.00 20.19           C  
ATOM   3068  C   ILE C 149     -96.173  27.906 -34.544  1.00 18.98           C  
ATOM   3069  O   ILE C 149     -96.549  29.112 -34.446  1.00 21.49           O  
ATOM   3070  CB  ILE C 149     -98.285  26.619 -35.080  1.00 18.18           C  
ATOM   3071  CG1 ILE C 149     -99.197  25.436 -34.687  1.00 23.45           C  
ATOM   3072  CG2 ILE C 149     -97.952  26.541 -36.572  1.00 18.22           C  
ATOM   3073  CD1 ILE C 149    -100.577  25.486 -35.382  1.00 17.97           C  
ATOM   3074  N   GLY C 150     -94.949  27.634 -34.980  1.00 20.03           N  
ATOM   3075  CA  GLY C 150     -94.029  28.718 -35.224  1.00 19.65           C  
ATOM   3076  C   GLY C 150     -93.620  28.724 -36.691  1.00 20.40           C  
ATOM   3077  O   GLY C 150     -93.780  27.728 -37.353  1.00 22.28           O  
ATOM   3078  N   ILE C 151     -93.246  29.907 -37.138  1.00 22.76           N  
ATOM   3079  CA  ILE C 151     -92.793  30.256 -38.487  1.00 21.43           C  
ATOM   3080  C   ILE C 151     -91.515  29.484 -38.709  1.00 21.40           C  
ATOM   3081  O   ILE C 151     -90.668  29.400 -37.827  1.00 22.58           O  
ATOM   3082  CB  ILE C 151     -92.539  31.739 -38.581  1.00 21.08           C  
ATOM   3083  CG1 ILE C 151     -93.865  32.489 -38.594  1.00 21.64           C  
ATOM   3084  CG2 ILE C 151     -91.805  32.053 -39.907  1.00 19.98           C  
ATOM   3085  CD1 ILE C 151     -93.705  33.947 -38.260  1.00 26.70           C  
ATOM   3086  N   ALA C 152     -91.465  28.811 -39.838  1.00 22.18           N  
ATOM   3087  CA  ALA C 152     -90.354  27.942 -40.151  1.00 21.62           C  
ATOM   3088  C   ALA C 152     -89.567  28.445 -41.373  1.00 22.00           C  
ATOM   3089  O   ALA C 152     -90.072  29.208 -42.197  1.00 23.89           O  
ATOM   3090  CB  ALA C 152     -90.853  26.547 -40.360  1.00 20.51           C  
ATOM   3091  N   GLN C 153     -88.326  28.024 -41.489  1.00 23.58           N  
ATOM   3092  CA  GLN C 153     -87.523  28.462 -42.613  1.00 24.39           C  
ATOM   3093  C   GLN C 153     -88.044  27.823 -43.921  1.00 25.76           C  
ATOM   3094  O   GLN C 153     -88.368  26.615 -43.953  1.00 27.20           O  
ATOM   3095  CB  GLN C 153     -86.020  28.208 -42.348  1.00 23.69           C  
ATOM   3096  CG  GLN C 153     -85.034  28.733 -43.450  1.00 25.45           C  
ATOM   3097  CD  GLN C 153     -83.551  28.786 -42.972  1.00 26.26           C  
ATOM   3098  OE1 GLN C 153     -82.959  27.744 -42.636  1.00 29.16           O  
ATOM   3099  NE2 GLN C 153     -82.964  29.990 -42.949  1.00 26.23           N  
ATOM   3100  OXT GLN C 153     -88.178  28.537 -44.938  1.00 25.46           O  
TER    3101      GLN C 153                                                      
END
MOLECULE T0514.pdb
ATOM   7695  N   SER     1     -73.106  18.033 -40.322  1.00 86.00           N  
ATOM   7696  CA  SER     1     -73.011  18.711 -38.995  1.00 85.50           C  
ATOM   7697  C   SER     1     -74.354  19.367 -38.664  1.00 79.83           C  
ATOM   7698  O   SER     1     -74.616  20.512 -39.038  1.00 86.46           O  
ATOM   7699  CB  SER     1     -71.867  19.728 -38.999  1.00 86.33           C  
ATOM   7700  OG  SER     1     -71.212  19.767 -37.742  1.00 88.81           O  
ATOM   7701  N   SER     2     -75.186  18.622 -37.940  1.00 70.86           N  
ATOM   7702  CA  SER     2     -76.629  18.868 -37.847  1.00 70.05           C  
ATOM   7703  C   SER     2     -77.049  19.675 -36.613  1.00 66.08           C  
ATOM   7704  O   SER     2     -77.518  19.116 -35.621  1.00 67.53           O  
ATOM   7705  CB  SER     2     -77.364  17.524 -37.883  1.00 72.15           C  
ATOM   7706  OG  SER     2     -78.761  17.686 -37.715  1.00 76.65           O  
ATOM   7707  N   LEU     3     -76.905  20.994 -36.702  1.00 57.90           N  
ATOM   7708  CA  LEU     3     -77.150  21.891 -35.579  1.00 49.32           C  
ATOM   7709  C   LEU     3     -78.641  22.135 -35.344  1.00 45.20           C  
ATOM   7710  O   LEU     3     -79.395  22.383 -36.285  1.00 46.29           O  
ATOM   7711  CB  LEU     3     -76.427  23.218 -35.823  1.00 50.89           C  
ATOM   7712  CG  LEU     3     -75.688  23.894 -34.673  1.00 48.11           C  
ATOM   7713  CD1 LEU     3     -74.641  22.973 -34.089  1.00 51.21           C  
ATOM   7714  CD2 LEU     3     -75.040  25.155 -35.184  1.00 47.04           C  
ATOM   7715  N   THR     4     -79.051  22.068 -34.078  1.00 40.66           N  
ATOM   7716  CA  THR     4     -80.445  22.293 -33.688  1.00 38.62           C  
ATOM   7717  C   THR     4     -80.772  23.788 -33.633  1.00 40.67           C  
ATOM   7718  O   THR     4     -80.086  24.559 -32.951  1.00 39.89           O  
ATOM   7719  CB  THR     4     -80.760  21.636 -32.319  1.00 36.41           C  
ATOM   7720  OG1 THR     4     -80.313  20.276 -32.327  1.00 37.81           O  
ATOM   7721  CG2 THR     4     -82.255  21.661 -32.026  1.00 30.45           C  
ATOM   7722  N   GLU     5     -81.811  24.184 -34.370  1.00 39.96           N  
ATOM   7723  CA  GLU     5     -82.345  25.546 -34.329  1.00 39.54           C  
ATOM   7724  C   GLU     5     -83.553  25.564 -33.417  1.00 37.36           C  
ATOM   7725  O   GLU     5     -84.281  24.581 -33.340  1.00 38.64           O  
ATOM   7726  CB  GLU     5     -82.768  26.019 -35.722  1.00 39.72           C  
ATOM   7727  CG  GLU     5     -81.673  25.972 -36.765  1.00 42.97           C  
ATOM   7728  CD  GLU     5     -82.038  26.679 -38.058  1.00 52.29           C  
ATOM   7729  OE1 GLU     5     -81.494  26.288 -39.114  1.00 59.87           O  
ATOM   7730  OE2 GLU     5     -82.861  27.622 -38.023  1.00 58.70           O  
ATOM   7731  N   THR     6     -83.771  26.685 -32.739  1.00 39.74           N  
ATOM   7732  CA  THR     6     -84.865  26.804 -31.783  1.00 40.46           C  
ATOM   7733  C   THR     6     -85.754  27.995 -32.125  1.00 40.75           C  
ATOM   7734  O   THR     6     -85.275  29.127 -32.261  1.00 42.54           O  
ATOM   7735  CB  THR     6     -84.337  26.935 -30.323  1.00 42.91           C  
ATOM   7736  OG1 THR     6     -83.371  25.908 -30.059  1.00 46.85           O  
ATOM   7737  CG2 THR     6     -85.477  26.818 -29.319  1.00 44.55           C  
ATOM   7738  N   TYR     7     -87.047  27.721 -32.277  1.00 39.16           N  
ATOM   7739  CA  TYR     7     -88.045  28.754 -32.525  1.00 35.75           C  
ATOM   7740  C   TYR     7     -89.166  28.573 -31.529  1.00 35.97           C  
ATOM   7741  O   TYR     7     -90.017  27.699 -31.698  1.00 39.75           O  
ATOM   7742  CB  TYR     7     -88.560  28.689 -33.969  1.00 38.99           C  
ATOM   7743  CG  TYR     7     -87.478  28.999 -34.969  1.00 40.54           C  
ATOM   7744  CD1 TYR     7     -87.179  30.317 -35.305  1.00 37.88           C  
ATOM   7745  CD2 TYR     7     -86.726  27.978 -35.553  1.00 37.35           C  
ATOM   7746  CE1 TYR     7     -86.166  30.614 -36.212  1.00 41.16           C  
ATOM   7747  CE2 TYR     7     -85.712  28.261 -36.456  1.00 37.99           C  
ATOM   7748  CZ  TYR     7     -85.437  29.579 -36.783  1.00 40.84           C  
ATOM   7749  OH  TYR     7     -84.431  29.867 -37.675  1.00 49.82           O  
ATOM   7750  N   GLY     8     -89.140  29.398 -30.483  1.00 35.98           N  
ATOM   7751  CA  GLY     8     -90.046  29.261 -29.348  1.00 34.78           C  
ATOM   7752  C   GLY     8     -89.837  27.928 -28.661  1.00 37.11           C  
ATOM   7753  O   GLY     8     -88.768  27.666 -28.097  1.00 39.11           O  
ATOM   7754  N   LEU     9     -90.858  27.081 -28.742  1.00 35.37           N  
ATOM   7755  CA  LEU     9     -90.831  25.755 -28.144  1.00 32.71           C  
ATOM   7756  C   LEU     9     -90.501  24.674 -29.174  1.00 33.56           C  
ATOM   7757  O   LEU     9     -90.358  23.498 -28.825  1.00 34.51           O  
ATOM   7758  CB  LEU     9     -92.174  25.452 -27.473  1.00 30.66           C  
ATOM   7759  CG  LEU     9     -92.546  26.278 -26.243  1.00 31.48           C  
ATOM   7760  CD1 LEU     9     -93.946  25.918 -25.798  1.00 26.00           C  
ATOM   7761  CD2 LEU     9     -91.550  26.088 -25.099  1.00 28.69           C  
ATOM   7762  N   TRP    10     -90.363  25.084 -30.436  1.00 35.01           N  
ATOM   7763  CA  TRP    10     -90.121  24.154 -31.539  1.00 33.36           C  
ATOM   7764  C   TRP    10     -88.660  24.091 -31.974  1.00 35.75           C  
ATOM   7765  O   TRP    10     -87.944  25.097 -31.949  1.00 33.95           O  
ATOM   7766  CB  TRP    10     -91.035  24.480 -32.721  1.00 31.82           C  
ATOM   7767  CG  TRP    10     -92.432  23.993 -32.495  1.00 30.68           C  
ATOM   7768  CD1 TRP    10     -93.389  24.573 -31.708  1.00 27.17           C  
ATOM   7769  CD2 TRP    10     -93.025  22.808 -33.041  1.00 29.19           C  
ATOM   7770  NE1 TRP    10     -94.545  23.827 -31.737  1.00 30.50           N  
ATOM   7771  CE2 TRP    10     -94.350  22.738 -32.549  1.00 31.52           C  
ATOM   7772  CE3 TRP    10     -92.566  21.798 -33.901  1.00 28.90           C  
ATOM   7773  CZ2 TRP    10     -95.224  21.695 -32.888  1.00 32.76           C  
ATOM   7774  CZ3 TRP    10     -93.437  20.759 -34.242  1.00 30.01           C  
ATOM   7775  CH2 TRP    10     -94.749  20.716 -33.733  1.00 32.69           C  
ATOM   7776  N   SER    11     -88.225  22.890 -32.351  1.00 35.54           N  
ATOM   7777  CA  SER    11     -86.858  22.665 -32.800  1.00 34.01           C  
ATOM   7778  C   SER    11     -86.809  22.282 -34.273  1.00 34.91           C  
ATOM   7779  O   SER    11     -87.770  21.719 -34.807  1.00 32.84           O  
ATOM   7780  CB  SER    11     -86.184  21.585 -31.957  1.00 34.82           C  
ATOM   7781  OG  SER    11     -86.153  21.951 -30.592  1.00 40.26           O  
ATOM   7782  N   ILE    12     -85.691  22.609 -34.921  1.00 37.39           N  
ATOM   7783  CA  ILE    12     -85.430  22.225 -36.311  1.00 38.04           C  
ATOM   7784  C   ILE    12     -84.071  21.530 -36.443  1.00 37.76           C  
ATOM   7785  O   ILE    12     -83.051  22.050 -35.989  1.00 38.44           O  
ATOM   7786  CB  ILE    12     -85.517  23.448 -37.280  1.00 39.96           C  
ATOM   7787  CG1 ILE    12     -86.963  23.902 -37.431  1.00 38.91           C  
ATOM   7788  CG2 ILE    12     -84.949  23.115 -38.674  1.00 37.07           C  
ATOM   7789  CD1 ILE    12     -87.101  25.226 -38.088  1.00 41.12           C  
ATOM   7790  N   ASN    13     -84.079  20.346 -37.047  1.00 40.63           N  
ATOM   7791  CA  ASN    13     -82.853  19.655 -37.434  1.00 42.33           C  
ATOM   7792  C   ASN    13     -82.896  19.247 -38.904  1.00 45.34           C  
ATOM   7793  O   ASN    13     -83.948  18.864 -39.422  1.00 47.47           O  
ATOM   7794  CB  ASN    13     -82.620  18.432 -36.552  1.00 40.33           C  
ATOM   7795  CG  ASN    13     -82.231  18.804 -35.141  1.00 41.17           C  
ATOM   7796  OD1 ASN    13     -83.081  18.895 -34.255  1.00 42.99           O  
ATOM   7797  ND2 ASN    13     -80.942  19.039 -34.925  1.00 36.69           N  
ATOM   7798  N   CYS    14     -81.753  19.358 -39.573  1.00 51.92           N  
ATOM   7799  CA  CYS    14     -81.608  18.893 -40.950  1.00 58.30           C  
ATOM   7800  C   CYS    14     -80.651  17.708 -40.975  1.00 63.16           C  
ATOM   7801  O   CYS    14     -79.557  17.774 -40.421  1.00 65.08           O  
ATOM   7802  CB  CYS    14     -81.105  20.020 -41.853  1.00 57.24           C  
ATOM   7803  SG  CYS    14     -82.207  21.455 -41.929  1.00 61.75           S  
ATOM   7804  N   GLY    15     -81.073  16.612 -41.593  1.00 71.49           N  
ATOM   7805  CA  GLY    15     -80.278  15.392 -41.572  1.00 79.04           C  
ATOM   7806  C   GLY    15     -80.256  14.637 -42.882  1.00 83.68           C  
ATOM   7807  O   GLY    15     -81.005  14.953 -43.807  1.00 81.70           O  
ATOM   7808  N   ILE    16     -79.385  13.635 -42.951  1.00 89.29           N  
ATOM   7809  CA  ILE    16     -79.296  12.768 -44.116  1.00 95.07           C  
ATOM   7810  C   ILE    16     -79.867  11.387 -43.785  1.00 97.80           C  
ATOM   7811  O   ILE    16     -79.246  10.598 -43.067  1.00101.91           O  
ATOM   7812  CB  ILE    16     -77.840  12.662 -44.659  1.00 95.61           C  
ATOM   7813  CG1 ILE    16     -77.255  14.058 -44.917  1.00 95.45           C  
ATOM   7814  CG2 ILE    16     -77.797  11.817 -45.936  1.00 97.89           C  
ATOM   7815  CD1 ILE    16     -75.734  14.100 -44.990  1.00 96.35           C  
ATOM   7816  N   GLN    17     -81.070  11.121 -44.289  1.00 99.86           N  
ATOM   7817  CA  GLN    17     -81.656   9.781 -44.248  1.00103.94           C  
ATOM   7818  C   GLN    17     -81.935   9.297 -45.671  1.00107.30           C  
ATOM   7819  O   GLN    17     -82.322  10.090 -46.537  1.00109.45           O  
ATOM   7820  CB  GLN    17     -82.913   9.730 -43.366  1.00103.97           C  
ATOM   7821  CG  GLN    17     -84.047  10.667 -43.776  1.00103.34           C  
ATOM   7822  CD  GLN    17     -85.227  10.643 -42.816  1.00103.34           C  
ATOM   7823  OE1 GLN    17     -86.325  11.077 -43.163  1.00101.58           O  
ATOM   7824  NE2 GLN    17     -85.007  10.138 -41.605  1.00103.62           N  
ATOM   7825  N   GLU    18     -81.735   7.993 -45.887  1.00109.68           N  
ATOM   7826  CA  GLU    18     -81.668   7.343 -47.222  1.00108.94           C  
ATOM   7827  C   GLU    18     -80.948   8.127 -48.341  1.00104.86           C  
ATOM   7828  O   GLU    18     -81.362   8.105 -49.506  1.00105.18           O  
ATOM   7829  CB  GLU    18     -83.026   6.751 -47.681  1.00110.74           C  
ATOM   7830  CG  GLU    18     -84.210   7.717 -47.825  1.00113.55           C  
ATOM   7831  CD  GLU    18     -85.104   7.762 -46.593  1.00119.58           C  
ATOM   7832  OE1 GLU    18     -84.621   7.489 -45.471  1.00119.83           O  
ATOM   7833  OE2 GLU    18     -86.303   8.075 -46.749  1.00123.72           O  
ATOM   7834  N   GLY    19     -79.866   8.811 -47.965  1.00 99.61           N  
ATOM   7835  CA  GLY    19     -79.063   9.610 -48.891  1.00 93.47           C  
ATOM   7836  C   GLY    19     -79.633  10.977 -49.231  1.00 89.20           C  
ATOM   7837  O   GLY    19     -79.123  11.659 -50.126  1.00 84.86           O  
ATOM   7838  N   LYS    20     -80.686  11.380 -48.519  1.00 87.80           N  
ATOM   7839  CA  LYS    20     -81.356  12.659 -48.774  1.00 85.31           C  
ATOM   7840  C   LYS    20     -81.306  13.652 -47.624  1.00 84.60           C  
ATOM   7841  O   LYS    20     -81.594  13.304 -46.478  1.00 83.32           O  
ATOM   7842  CB  LYS    20     -82.820  12.453 -49.188  1.00 82.26           C  
ATOM   7843  CG  LYS    20     -83.153  12.836 -50.629  1.00 80.18           C  
ATOM   7844  CD  LYS    20     -82.756  14.271 -50.990  1.00 79.88           C  
ATOM   7845  CE  LYS    20     -81.530  14.316 -51.907  1.00 71.59           C  
ATOM   7846  NZ  LYS    20     -81.177  15.696 -52.331  1.00 69.67           N  
ATOM   7847  N   LYS    21     -80.950  14.892 -47.957  1.00 84.11           N  
ATOM   7848  CA  LYS    21     -81.076  16.017 -47.038  1.00 83.87           C  
ATOM   7849  C   LYS    21     -82.556  16.337 -46.825  1.00 81.07           C  
ATOM   7850  O   LYS    21     -83.272  16.685 -47.769  1.00 86.07           O  
ATOM   7851  CB  LYS    21     -80.317  17.244 -47.569  1.00 87.63           C  
ATOM   7852  CG  LYS    21     -80.607  18.573 -46.838  1.00 91.25           C  
ATOM   7853  CD  LYS    21     -80.062  18.608 -45.407  1.00 91.27           C  
ATOM   7854  CE  LYS    21     -78.579  18.952 -45.370  1.00 92.40           C  
ATOM   7855  NZ  LYS    21     -78.069  19.024 -43.973  1.00 94.73           N  
ATOM   7856  N   VAL    22     -83.006  16.185 -45.583  1.00 75.46           N  
ATOM   7857  CA  VAL    22     -84.368  16.538 -45.195  1.00 66.54           C  
ATOM   7858  C   VAL    22     -84.341  17.350 -43.894  1.00 60.14           C  
ATOM   7859  O   VAL    22     -83.654  16.991 -42.932  1.00 50.69           O  
ATOM   7860  CB  VAL    22     -85.316  15.282 -45.129  1.00 69.02           C  
ATOM   7861  CG1 VAL    22     -84.927  14.316 -44.011  1.00 62.21           C  
ATOM   7862  CG2 VAL    22     -86.785  15.694 -45.009  1.00 75.37           C  
ATOM   7863  N   CYS    23     -85.051  18.474 -43.893  1.00 57.05           N  
ATOM   7864  CA  CYS    23     -85.160  19.292 -42.693  1.00 52.37           C  
ATOM   7865  C   CYS    23     -86.501  19.053 -42.026  1.00 48.74           C  
ATOM   7866  O   CYS    23     -87.550  19.124 -42.672  1.00 48.88           O  
ATOM   7867  CB  CYS    23     -84.960  20.774 -43.012  1.00 53.59           C  
ATOM   7868  SG  CYS    23     -83.302  21.159 -43.621  1.00 61.48           S  
ATOM   7869  N   PHE    24     -86.462  18.751 -40.734  1.00 47.22           N  
ATOM   7870  CA  PHE    24     -87.689  18.483 -39.991  1.00 45.34           C  
ATOM   7871  C   PHE    24     -87.883  19.369 -38.767  1.00 40.99           C  
ATOM   7872  O   PHE    24     -86.934  19.890 -38.181  1.00 37.69           O  
ATOM   7873  CB  PHE    24     -87.866  16.983 -39.669  1.00 47.46           C  
ATOM   7874  CG  PHE    24     -86.757  16.385 -38.850  1.00 53.18           C  
ATOM   7875  CD1 PHE    24     -86.894  16.249 -37.469  1.00 57.41           C  
ATOM   7876  CD2 PHE    24     -85.590  15.920 -39.458  1.00 56.07           C  
ATOM   7877  CE1 PHE    24     -85.877  15.680 -36.699  1.00 57.82           C  
ATOM   7878  CE2 PHE    24     -84.563  15.356 -38.702  1.00 61.34           C  
ATOM   7879  CZ  PHE    24     -84.707  15.235 -37.317  1.00 59.01           C  
ATOM   7880  N   MET    25     -89.150  19.526 -38.415  1.00 40.89           N  
ATOM   7881  CA  MET    25     -89.627  20.457 -37.417  1.00 37.14           C  
ATOM   7882  C   MET    25     -90.204  19.579 -36.318  1.00 36.34           C  
ATOM   7883  O   MET    25     -91.072  18.749 -36.595  1.00 35.61           O  
ATOM   7884  CB  MET    25     -90.745  21.248 -38.069  1.00 40.66           C  
ATOM   7885  CG  MET    25     -91.015  22.605 -37.554  1.00 41.74           C  
ATOM   7886  SD  MET    25     -92.447  23.209 -38.467  1.00 33.57           S  
ATOM   7887  CE  MET    25     -93.338  23.885 -37.087  1.00 29.70           C  
ATOM   7888  N   HIS    26     -89.737  19.742 -35.080  1.00 36.22           N  
ATOM   7889  CA  HIS    26     -90.155  18.821 -34.012  1.00 34.22           C  
ATOM   7890  C   HIS    26     -90.321  19.388 -32.595  1.00 34.68           C  
ATOM   7891  O   HIS    26     -89.727  20.411 -32.225  1.00 32.90           O  
ATOM   7892  CB  HIS    26     -89.268  17.565 -33.993  1.00 31.23           C  
ATOM   7893  CG  HIS    26     -87.822  17.849 -33.742  1.00 33.71           C  
ATOM   7894  ND1 HIS    26     -87.235  17.684 -32.506  1.00 37.09           N  
ATOM   7895  CD2 HIS    26     -86.845  18.296 -34.566  1.00 32.07           C  
ATOM   7896  CE1 HIS    26     -85.959  18.012 -32.580  1.00 36.78           C  
ATOM   7897  NE2 HIS    26     -85.697  18.388 -33.819  1.00 36.25           N  
ATOM   7898  N   ARG    27     -91.147  18.696 -31.815  1.00 34.90           N  
ATOM   7899  CA  ARG    27     -91.499  19.109 -30.464  1.00 35.60           C  
ATOM   7900  C   ARG    27     -91.845  17.880 -29.620  1.00 37.37           C  
ATOM   7901  O   ARG    27     -92.615  17.022 -30.055  1.00 37.78           O  
ATOM   7902  CB  ARG    27     -92.693  20.072 -30.515  1.00 34.68           C  
ATOM   7903  CG  ARG    27     -93.389  20.316 -29.183  1.00 32.93           C  
ATOM   7904  CD  ARG    27     -92.882  21.562 -28.499  1.00 34.97           C  
ATOM   7905  NE  ARG    27     -93.150  21.549 -27.062  1.00 35.70           N  
ATOM   7906  CZ  ARG    27     -92.237  21.777 -26.118  1.00 35.79           C  
ATOM   7907  NH1 ARG    27     -90.983  22.061 -26.446  1.00 35.35           N  
ATOM   7908  NH2 ARG    27     -92.584  21.734 -24.840  1.00 32.78           N  
ATOM   7909  N   GLN    28     -91.264  17.802 -28.424  1.00 39.12           N  
ATOM   7910  CA  GLN    28     -91.625  16.785 -27.438  1.00 39.03           C  
ATOM   7911  C   GLN    28     -92.318  17.425 -26.248  1.00 35.59           C  
ATOM   7912  O   GLN    28     -91.953  18.522 -25.819  1.00 36.00           O  
ATOM   7913  CB  GLN    28     -90.382  16.060 -26.928  1.00 37.97           C  
ATOM   7914  CG  GLN    28     -89.815  15.019 -27.865  1.00 50.79           C  
ATOM   7915  CD  GLN    28     -88.584  14.336 -27.295  1.00 51.82           C  
ATOM   7916  OE1 GLN    28     -87.931  14.854 -26.380  1.00 48.50           O  
ATOM   7917  NE2 GLN    28     -88.258  13.163 -27.836  1.00 56.54           N  
ATOM   7918  N   GLU    29     -93.310  16.727 -25.706  1.00 34.54           N  
ATOM   7919  CA  GLU    29     -93.924  17.138 -24.452  1.00 36.76           C  
ATOM   7920  C   GLU    29     -93.641  16.119 -23.352  1.00 37.73           C  
ATOM   7921  O   GLU    29     -93.732  14.906 -23.576  1.00 36.19           O  
ATOM   7922  CB  GLU    29     -95.432  17.367 -24.605  1.00 38.13           C  
ATOM   7923  CG  GLU    29     -95.845  18.263 -25.776  1.00 38.36           C  
ATOM   7924  CD  GLU    29     -95.494  19.736 -25.598  1.00 42.52           C  
ATOM   7925  OE1 GLU    29     -95.164  20.170 -24.475  1.00 47.87           O  
ATOM   7926  OE2 GLU    29     -95.559  20.472 -26.602  1.00 44.00           O  
ATOM   7927  N   VAL    30     -93.284  16.629 -22.172  1.00 39.11           N  
ATOM   7928  CA  VAL    30     -92.918  15.794 -21.024  1.00 38.76           C  
ATOM   7929  C   VAL    30     -93.876  15.994 -19.843  1.00 40.55           C  
ATOM   7930  O   VAL    30     -94.572  17.009 -19.767  1.00 40.75           O  
ATOM   7931  CB  VAL    30     -91.444  16.041 -20.568  1.00 36.91           C  
ATOM   7932  CG1 VAL    30     -90.460  15.709 -21.687  1.00 33.10           C  
ATOM   7933  CG2 VAL    30     -91.237  17.483 -20.087  1.00 35.14           C  
ATOM   7934  N   ASN    31     -93.917  15.016 -18.939  1.00 43.33           N  
ATOM   7935  CA  ASN    31     -94.651  15.160 -17.681  1.00 43.25           C  
ATOM   7936  C   ASN    31     -93.779  15.766 -16.584  1.00 47.22           C  
ATOM   7937  O   ASN    31     -92.674  16.237 -16.865  1.00 47.32           O  
ATOM   7938  CB  ASN    31     -95.294  13.832 -17.233  1.00 43.59           C  
ATOM   7939  CG  ASN    31     -94.288  12.688 -17.073  1.00 43.57           C  
ATOM   7940  OD1 ASN    31     -93.078  12.894 -16.971  1.00 49.89           O  
ATOM   7941  ND2 ASN    31     -94.803  11.466 -17.049  1.00 39.28           N  
ATOM   7942  N   ASP    32     -94.274  15.749 -15.343  1.00 52.63           N  
ATOM   7943  CA  ASP    32     -93.516  16.253 -14.183  1.00 58.15           C  
ATOM   7944  C   ASP    32     -92.281  15.415 -13.813  1.00 58.15           C  
ATOM   7945  O   ASP    32     -91.374  15.908 -13.142  1.00 58.05           O  
ATOM   7946  CB  ASP    32     -94.427  16.458 -12.960  1.00 63.77           C  
ATOM   7947  CG  ASP    32     -95.443  15.332 -12.767  1.00 76.42           C  
ATOM   7948  OD1 ASP    32     -95.134  14.158 -13.075  1.00 83.20           O  
ATOM   7949  OD2 ASP    32     -96.559  15.631 -12.288  1.00 85.45           O  
ATOM   7950  N   GLN    33     -92.253  14.159 -14.264  1.00 60.15           N  
ATOM   7951  CA  GLN    33     -91.095  13.270 -14.084  1.00 60.41           C  
ATOM   7952  C   GLN    33     -90.101  13.388 -15.240  1.00 60.28           C  
ATOM   7953  O   GLN    33     -89.128  12.631 -15.309  1.00 63.82           O  
ATOM   7954  CB  GLN    33     -91.542  11.809 -13.928  1.00 58.58           C  
ATOM   7955  CG  GLN    33     -92.418  11.530 -12.707  1.00 67.98           C  
ATOM   7956  CD  GLN    33     -91.759  11.932 -11.396  1.00 76.84           C  
ATOM   7957  OE1 GLN    33     -92.246  12.817 -10.691  1.00 77.72           O  
ATOM   7958  NE2 GLN    33     -90.641  11.290 -11.069  1.00 78.90           N  
ATOM   7959  N   ASN    34     -90.371  14.333 -16.142  1.00 56.72           N  
ATOM   7960  CA  ASN    34     -89.528  14.644 -17.307  1.00 57.64           C  
ATOM   7961  C   ASN    34     -89.388  13.517 -18.343  1.00 53.14           C  
ATOM   7962  O   ASN    34     -88.394  13.450 -19.064  1.00 54.45           O  
ATOM   7963  CB  ASN    34     -88.152  15.190 -16.875  1.00 63.11           C  
ATOM   7964  CG  ASN    34     -87.574  16.183 -17.871  1.00 73.48           C  
ATOM   7965  OD1 ASN    34     -88.079  17.298 -18.021  1.00 82.99           O  
ATOM   7966  ND2 ASN    34     -86.505  15.782 -18.552  1.00 71.05           N  
ATOM   7967  N   ARG    35     -90.384  12.638 -18.426  1.00 50.00           N  
ATOM   7968  CA  ARG    35     -90.399  11.638 -19.493  1.00 52.19           C  
ATOM   7969  C   ARG    35     -91.392  12.000 -20.607  1.00 49.40           C  
ATOM   7970  O   ARG    35     -92.459  12.566 -20.351  1.00 46.47           O  
ATOM   7971  CB  ARG    35     -90.621  10.214 -18.955  1.00 54.38           C  
ATOM   7972  CG  ARG    35     -92.008   9.913 -18.435  1.00 63.48           C  
ATOM   7973  CD  ARG    35     -92.314   8.431 -18.562  1.00 72.96           C  
ATOM   7974  NE  ARG    35     -93.747   8.174 -18.460  1.00 81.89           N  
ATOM   7975  CZ  ARG    35     -94.569   7.959 -19.487  1.00 85.10           C  
ATOM   7976  NH1 ARG    35     -94.122   7.945 -20.737  1.00 84.71           N  
ATOM   7977  NH2 ARG    35     -95.855   7.748 -19.252  1.00 85.00           N  
ATOM   7978  N   VAL    36     -91.016  11.665 -21.839  1.00 46.28           N  
ATOM   7979  CA  VAL    36     -91.781  12.021 -23.036  1.00 43.64           C  
ATOM   7980  C   VAL    36     -93.111  11.271 -23.099  1.00 43.57           C  
ATOM   7981  O   VAL    36     -93.145  10.043 -23.052  1.00 45.58           O  
ATOM   7982  CB  VAL    36     -90.946  11.794 -24.329  1.00 43.77           C  
ATOM   7983  CG1 VAL    36     -91.721  12.214 -25.571  1.00 40.76           C  
ATOM   7984  CG2 VAL    36     -89.632  12.564 -24.252  1.00 43.73           C  
ATOM   7985  N   VAL    37     -94.199  12.032 -23.190  1.00 42.93           N  
ATOM   7986  CA  VAL    37     -95.549  11.475 -23.274  1.00 42.32           C  
ATOM   7987  C   VAL    37     -96.081  11.586 -24.705  1.00 43.22           C  
ATOM   7988  O   VAL    37     -96.640  10.634 -25.249  1.00 45.11           O  
ATOM   7989  CB  VAL    37     -96.511  12.177 -22.282  1.00 41.41           C  
ATOM   7990  CG1 VAL    37     -97.901  11.548 -22.323  1.00 44.11           C  
ATOM   7991  CG2 VAL    37     -95.952  12.127 -20.860  1.00 41.25           C  
ATOM   7992  N   VAL    38     -95.891  12.752 -25.312  1.00 42.01           N  
ATOM   7993  CA  VAL    38     -96.311  12.978 -26.691  1.00 44.83           C  
ATOM   7994  C   VAL    38     -95.192  13.689 -27.472  1.00 39.42           C  
ATOM   7995  O   VAL    38     -94.454  14.503 -26.911  1.00 42.68           O  
ATOM   7996  CB  VAL    38     -97.733  13.666 -26.765  1.00 47.06           C  
ATOM   7997  CG1 VAL    38     -97.745  15.019 -26.108  1.00 49.87           C  
ATOM   7998  CG2 VAL    38     -98.250  13.765 -28.184  1.00 54.30           C  
ATOM   7999  N   ALA    39     -95.029  13.324 -28.742  1.00 39.00           N  
ATOM   8000  CA  ALA    39     -94.053  13.963 -29.619  1.00 36.49           C  
ATOM   8001  C   ALA    39     -94.664  14.211 -30.995  1.00 40.04           C  
ATOM   8002  O   ALA    39     -95.598  13.516 -31.405  1.00 41.01           O  
ATOM   8003  CB  ALA    39     -92.787  13.106 -29.733  1.00 33.14           C  
ATOM   8004  N   MET    40     -94.135  15.209 -31.698  1.00 39.36           N  
ATOM   8005  CA  MET    40     -94.594  15.548 -33.040  1.00 37.36           C  
ATOM   8006  C   MET    40     -93.396  15.917 -33.903  1.00 36.61           C  
ATOM   8007  O   MET    40     -92.546  16.694 -33.484  1.00 38.65           O  
ATOM   8008  CB  MET    40     -95.604  16.701 -32.982  1.00 35.72           C  
ATOM   8009  CG  MET    40     -96.020  17.272 -34.336  1.00 44.41           C  
ATOM   8010  SD  MET    40     -97.527  18.253 -34.261  1.00 43.34           S  
ATOM   8011  CE  MET    40     -98.734  16.944 -34.198  1.00 57.38           C  
ATOM   8012  N   SER    41     -93.328  15.329 -35.095  1.00 38.59           N  
ATOM   8013  CA  SER    41     -92.282  15.642 -36.068  1.00 39.90           C  
ATOM   8014  C   SER    41     -92.924  15.923 -37.423  1.00 42.42           C  
ATOM   8015  O   SER    41     -93.814  15.194 -37.858  1.00 44.66           O  
ATOM   8016  CB  SER    41     -91.275  14.497 -36.171  1.00 38.92           C  
ATOM   8017  OG  SER    41     -90.050  14.948 -36.720  1.00 45.02           O  
ATOM   8018  N   VAL    42     -92.465  16.980 -38.084  1.00 43.27           N  
ATOM   8019  CA  VAL    42     -93.147  17.520 -39.258  1.00 43.16           C  
ATOM   8020  C   VAL    42     -92.174  17.983 -40.359  1.00 42.78           C  
ATOM   8021  O   VAL    42     -91.132  18.582 -40.069  1.00 41.02           O  
ATOM   8022  CB  VAL    42     -94.163  18.624 -38.813  1.00 45.42           C  
ATOM   8023  CG1 VAL    42     -94.091  19.877 -39.667  1.00 47.71           C  
ATOM   8024  CG2 VAL    42     -95.576  18.055 -38.765  1.00 50.61           C  
ATOM   8025  N   VAL    43     -92.503  17.669 -41.615  1.00 44.23           N  
ATOM   8026  CA  VAL    43     -91.737  18.158 -42.773  1.00 45.03           C  
ATOM   8027  C   VAL    43     -92.593  19.010 -43.711  1.00 47.46           C  
ATOM   8028  O   VAL    43     -93.827  18.887 -43.743  1.00 45.91           O  
ATOM   8029  CB  VAL    43     -91.058  17.017 -43.599  1.00 45.82           C  
ATOM   8030  CG1 VAL    43     -89.978  16.311 -42.785  1.00 47.96           C  
ATOM   8031  CG2 VAL    43     -92.085  16.022 -44.131  1.00 44.05           C  
ATOM   8032  N   LEU    44     -91.923  19.882 -44.461  1.00 48.25           N  
ATOM   8033  CA  LEU    44     -92.552  20.638 -45.533  1.00 49.20           C  
ATOM   8034  C   LEU    44     -92.233  19.926 -46.840  1.00 50.17           C  
ATOM   8035  O   LEU    44     -91.069  19.834 -47.241  1.00 48.59           O  
ATOM   8036  CB  LEU    44     -92.007  22.069 -45.574  1.00 50.42           C  
ATOM   8037  CG  LEU    44     -92.858  23.273 -46.005  1.00 51.57           C  
ATOM   8038  CD1 LEU    44     -92.022  24.181 -46.886  1.00 48.17           C  
ATOM   8039  CD2 LEU    44     -94.179  22.925 -46.686  1.00 53.02           C  
ATOM   8040  N   ASN    45     -93.269  19.405 -47.490  1.00 53.56           N  
ATOM   8041  CA  ASN    45     -93.105  18.705 -48.759  1.00 60.61           C  
ATOM   8042  C   ASN    45     -92.953  19.682 -49.926  1.00 61.95           C  
ATOM   8043  O   ASN    45     -93.225  20.880 -49.780  1.00 62.94           O  
ATOM   8044  CB  ASN    45     -94.268  17.736 -48.991  1.00 61.44           C  
ATOM   8045  CG  ASN    45     -94.318  16.625 -47.955  1.00 61.88           C  
ATOM   8046  OD1 ASN    45     -93.560  15.656 -48.027  1.00 64.24           O  
ATOM   8047  ND2 ASN    45     -95.216  16.760 -46.986  1.00 54.93           N  
ATOM   8048  N   ALA    46     -92.519  19.160 -51.073  1.00 67.68           N  
ATOM   8049  CA  ALA    46     -92.230  19.965 -52.270  1.00 72.47           C  
ATOM   8050  C   ALA    46     -93.438  20.734 -52.823  1.00 71.74           C  
ATOM   8051  O   ALA    46     -93.283  21.830 -53.370  1.00 64.68           O  
ATOM   8052  CB  ALA    46     -91.609  19.090 -53.357  1.00 71.52           C  
ATOM   8053  N   ASP    47     -94.630  20.158 -52.664  1.00 76.25           N  
ATOM   8054  CA  ASP    47     -95.876  20.788 -53.116  1.00 81.64           C  
ATOM   8055  C   ASP    47     -96.438  21.812 -52.121  1.00 80.37           C  
ATOM   8056  O   ASP    47     -97.388  22.535 -52.433  1.00 83.42           O  
ATOM   8057  CB  ASP    47     -96.933  19.726 -53.454  1.00 83.20           C  
ATOM   8058  CG  ASP    47     -97.331  18.887 -52.253  1.00 89.84           C  
ATOM   8059  OD1 ASP    47     -96.480  18.135 -51.726  1.00 88.83           O  
ATOM   8060  OD2 ASP    47     -98.509  18.972 -51.847  1.00 94.11           O  
ATOM   8061  N   GLY    48     -95.851  21.869 -50.928  1.00 78.39           N  
ATOM   8062  CA  GLY    48     -96.258  22.836 -49.913  1.00 75.66           C  
ATOM   8063  C   GLY    48     -97.114  22.258 -48.802  1.00 74.27           C  
ATOM   8064  O   GLY    48     -97.499  22.977 -47.874  1.00 73.74           O  
ATOM   8065  N   VAL    49     -97.419  20.963 -48.893  1.00 70.95           N  
ATOM   8066  CA  VAL    49     -98.200  20.284 -47.858  1.00 66.91           C  
ATOM   8067  C   VAL    49     -97.320  19.964 -46.637  1.00 61.43           C  
ATOM   8068  O   VAL    49     -96.161  19.555 -46.773  1.00 59.04           O  
ATOM   8069  CB  VAL    49     -98.986  19.037 -48.419  1.00 70.53           C  
ATOM   8070  CG1 VAL    49     -98.077  17.831 -48.676  1.00 70.34           C  
ATOM   8071  CG2 VAL    49    -100.136  18.653 -47.503  1.00 72.21           C  
ATOM   8072  N   VAL    50     -97.867  20.205 -45.449  1.00 55.18           N  
ATOM   8073  CA  VAL    50     -97.165  19.942 -44.198  1.00 51.62           C  
ATOM   8074  C   VAL    50     -97.600  18.579 -43.655  1.00 50.09           C  
ATOM   8075  O   VAL    50     -98.779  18.360 -43.366  1.00 49.43           O  
ATOM   8076  CB  VAL    50     -97.396  21.082 -43.168  1.00 54.49           C  
ATOM   8077  CG1 VAL    50     -96.922  20.691 -41.780  1.00 51.97           C  
ATOM   8078  CG2 VAL    50     -96.696  22.361 -43.622  1.00 58.52           C  
ATOM   8079  N   SER    51     -96.642  17.662 -43.546  1.00 46.60           N  
ATOM   8080  CA  SER    51     -96.927  16.305 -43.098  1.00 46.78           C  
ATOM   8081  C   SER    51     -95.855  15.764 -42.153  1.00 45.98           C  
ATOM   8082  O   SER    51     -94.767  16.326 -42.041  1.00 47.23           O  
ATOM   8083  CB  SER    51     -97.097  15.362 -44.297  1.00 46.56           C  
ATOM   8084  OG  SER    51     -95.844  15.036 -44.878  1.00 47.27           O  
ATOM   8085  N   GLY    52     -96.178  14.667 -41.478  1.00 45.55           N  
ATOM   8086  CA  GLY    52     -95.223  13.985 -40.616  1.00 43.07           C  
ATOM   8087  C   GLY    52     -95.883  12.979 -39.699  1.00 43.98           C  
ATOM   8088  O   GLY    52     -96.833  12.294 -40.090  1.00 43.52           O  
ATOM   8089  N   ASN    53     -95.381  12.902 -38.469  1.00 43.90           N  
ATOM   8090  CA  ASN    53     -95.834  11.907 -37.504  1.00 40.61           C  
ATOM   8091  C   ASN    53     -96.062  12.463 -36.107  1.00 39.65           C  
ATOM   8092  O   ASN    53     -95.329  13.336 -35.638  1.00 40.08           O  
ATOM   8093  CB  ASN    53     -94.838  10.745 -37.431  1.00 41.51           C  
ATOM   8094  CG  ASN    53     -94.871   9.867 -38.667  1.00 47.13           C  
ATOM   8095  OD1 ASN    53     -95.901   9.287 -39.005  1.00 50.75           O  
ATOM   8096  ND2 ASN    53     -93.738   9.759 -39.343  1.00 49.89           N  
ATOM   8097  N   LEU    54     -97.097  11.938 -35.462  1.00 37.37           N  
ATOM   8098  CA  LEU    54     -97.386  12.191 -34.062  1.00 38.77           C  
ATOM   8099  C   LEU    54     -97.122  10.899 -33.277  1.00 38.50           C  
ATOM   8100  O   LEU    54     -97.566   9.821 -33.675  1.00 39.47           O  
ATOM   8101  CB  LEU    54     -98.845  12.642 -33.919  1.00 40.65           C  
ATOM   8102  CG  LEU    54     -99.498  12.858 -32.553  1.00 48.06           C  
ATOM   8103  CD1 LEU    54     -98.949  14.092 -31.861  1.00 52.48           C  
ATOM   8104  CD2 LEU    54    -101.005  12.973 -32.727  1.00 43.73           C  
ATOM   8105  N   THR    55     -96.378  11.010 -32.180  1.00 39.30           N  
ATOM   8106  CA  THR    55     -96.126   9.865 -31.304  1.00 39.91           C  
ATOM   8107  C   THR    55     -96.993   9.965 -30.053  1.00 40.74           C  
ATOM   8108  O   THR    55     -96.873  10.912 -29.277  1.00 41.61           O  
ATOM   8109  CB  THR    55     -94.633   9.737 -30.907  1.00 41.37           C  
ATOM   8110  OG1 THR    55     -93.816   9.773 -32.083  1.00 45.21           O  
ATOM   8111  CG2 THR    55     -94.383   8.421 -30.165  1.00 38.83           C  
ATOM   8112  N   VAL    56     -97.865   8.980 -29.871  1.00 41.74           N  
ATOM   8113  CA  VAL    56     -98.785   8.946 -28.740  1.00 39.47           C  
ATOM   8114  C   VAL    56     -98.411   7.781 -27.797  1.00 40.99           C  
ATOM   8115  O   VAL    56     -97.630   6.910 -28.194  1.00 39.59           O  
ATOM   8116  CB  VAL    56    -100.268   8.874 -29.224  1.00 39.38           C  
ATOM   8117  CG1 VAL    56    -100.628  10.107 -30.044  1.00 38.86           C  
ATOM   8118  CG2 VAL    56    -100.544   7.595 -30.007  1.00 36.61           C  
ATOM   8119  N   PRO    57     -98.932   7.774 -26.543  1.00 40.92           N  
ATOM   8120  CA  PRO    57     -98.623   6.686 -25.603  1.00 40.34           C  
ATOM   8121  C   PRO    57     -99.085   5.286 -26.011  1.00 39.91           C  
ATOM   8122  O   PRO    57     -99.891   5.127 -26.932  1.00 41.60           O  
ATOM   8123  CB  PRO    57     -99.368   7.101 -24.325  1.00 40.00           C  
ATOM   8124  CG  PRO    57     -99.582   8.555 -24.455  1.00 39.77           C  
ATOM   8125  CD  PRO    57     -99.794   8.790 -25.906  1.00 37.98           C  
ATOM   8126  N   PHE    58     -98.547   4.284 -25.316  1.00 39.09           N  
ATOM   8127  CA  PHE    58     -99.014   2.905 -25.401  1.00 36.94           C  
ATOM   8128  C   PHE    58    -100.369   2.794 -24.711  1.00 38.40           C  
ATOM   8129  O   PHE    58    -100.719   3.639 -23.889  1.00 39.49           O  
ATOM   8130  CB  PHE    58     -98.033   1.968 -24.691  1.00 36.65           C  
ATOM   8131  CG  PHE    58     -96.719   1.777 -25.406  1.00 37.29           C  
ATOM   8132  CD1 PHE    58     -96.674   1.317 -26.721  1.00 32.46           C  
ATOM   8133  CD2 PHE    58     -95.525   2.011 -24.740  1.00 36.17           C  
ATOM   8134  CE1 PHE    58     -95.456   1.124 -27.365  1.00 30.64           C  
ATOM   8135  CE2 PHE    58     -94.301   1.820 -25.375  1.00 36.39           C  
ATOM   8136  CZ  PHE    58     -94.265   1.374 -26.687  1.00 33.57           C  
ATOM   8137  N   GLY    59    -101.122   1.746 -25.033  1.00 38.02           N  
ATOM   8138  CA  GLY    59    -102.386   1.476 -24.353  1.00 38.64           C  
ATOM   8139  C   GLY    59    -103.588   2.148 -24.991  1.00 40.57           C  
ATOM   8140  O   GLY    59    -104.689   2.114 -24.437  1.00 41.45           O  
ATOM   8141  N   ILE    60    -103.373   2.751 -26.159  1.00 39.42           N  
ATOM   8142  CA  ILE    60    -104.424   3.446 -26.893  1.00 38.65           C  
ATOM   8143  C   ILE    60    -105.140   2.452 -27.794  1.00 39.98           C  
ATOM   8144  O   ILE    60    -104.493   1.652 -28.471  1.00 42.85           O  
ATOM   8145  CB  ILE    60    -103.848   4.646 -27.724  1.00 38.15           C  
ATOM   8146  CG1 ILE    60    -103.155   5.668 -26.813  1.00 35.54           C  
ATOM   8147  CG2 ILE    60    -104.926   5.336 -28.572  1.00 36.48           C  
ATOM   8148  CD1 ILE    60    -103.977   6.131 -25.609  1.00 40.32           C  
ATOM   8149  N   LEU    61    -106.473   2.500 -27.777  1.00 40.96           N  
ATOM   8150  CA  LEU    61    -107.313   1.695 -28.658  1.00 41.73           C  
ATOM   8151  C   LEU    61    -107.102   2.086 -30.115  1.00 43.74           C  
ATOM   8152  O   LEU    61    -107.481   3.174 -30.556  1.00 45.62           O  
ATOM   8153  CB  LEU    61    -108.791   1.801 -28.261  1.00 43.12           C  
ATOM   8154  CG  LEU    61    -109.809   0.889 -28.954  1.00 47.01           C  
ATOM   8155  CD1 LEU    61    -109.384  -0.574 -28.917  1.00 46.29           C  
ATOM   8156  CD2 LEU    61    -111.168   1.062 -28.305  1.00 48.24           C  
ATOM   8157  N   VAL    62    -106.482   1.158 -30.833  1.00 45.81           N  
ATOM   8158  CA  VAL    62    -106.000   1.327 -32.199  1.00 46.43           C  
ATOM   8159  C   VAL    62    -107.124   1.393 -33.254  1.00 49.99           C  
ATOM   8160  O   VAL    62    -106.973   2.042 -34.297  1.00 49.86           O  
ATOM   8161  CB  VAL    62    -104.952   0.203 -32.488  1.00 47.63           C  
ATOM   8162  CG1 VAL    62    -105.276  -0.618 -33.727  1.00 44.38           C  
ATOM   8163  CG2 VAL    62    -103.540   0.753 -32.479  1.00 43.08           C  
ATOM   8164  N   SER    63    -108.252   0.744 -32.963  1.00 52.24           N  
ATOM   8165  CA  SER    63    -109.386   0.694 -33.888  1.00 55.22           C  
ATOM   8166  C   SER    63    -110.231   1.973 -33.879  1.00 55.13           C  
ATOM   8167  O   SER    63    -110.996   2.225 -34.813  1.00 56.93           O  
ATOM   8168  CB  SER    63    -110.260  -0.534 -33.604  1.00 56.41           C  
ATOM   8169  OG  SER    63    -110.703  -0.554 -32.259  1.00 58.82           O  
ATOM   8170  N   LYS    64    -110.087   2.770 -32.823  1.00 54.64           N  
ATOM   8171  CA  LYS    64    -110.773   4.056 -32.702  1.00 54.80           C  
ATOM   8172  C   LYS    64    -109.828   5.216 -33.061  1.00 55.37           C  
ATOM   8173  O   LYS    64    -108.627   5.136 -32.792  1.00 54.67           O  
ATOM   8174  CB  LYS    64    -111.362   4.217 -31.295  1.00 55.30           C  
ATOM   8175  CG  LYS    64    -112.561   3.308 -31.037  1.00 63.31           C  
ATOM   8176  CD  LYS    64    -113.400   3.779 -29.855  1.00 78.37           C  
ATOM   8177  CE  LYS    64    -114.502   4.741 -30.289  1.00 85.91           C  
ATOM   8178  NZ  LYS    64    -115.560   4.064 -31.097  1.00 90.27           N  
ATOM   8179  N   PRO    65    -110.364   6.296 -33.674  1.00 55.58           N  
ATOM   8180  CA  PRO    65    -109.497   7.330 -34.247  1.00 52.60           C  
ATOM   8181  C   PRO    65    -108.828   8.256 -33.237  1.00 49.82           C  
ATOM   8182  O   PRO    65    -109.250   8.339 -32.083  1.00 48.16           O  
ATOM   8183  CB  PRO    65    -110.454   8.155 -35.122  1.00 54.13           C  
ATOM   8184  CG  PRO    65    -111.767   7.441 -35.107  1.00 56.65           C  
ATOM   8185  CD  PRO    65    -111.788   6.625 -33.873  1.00 55.49           C  
ATOM   8186  N   VAL    66    -107.782   8.940 -33.696  1.00 46.27           N  
ATOM   8187  CA  VAL    66    -107.118   9.997 -32.944  1.00 44.24           C  
ATOM   8188  C   VAL    66    -107.577  11.331 -33.533  1.00 46.00           C  
ATOM   8189  O   VAL    66    -107.417  11.587 -34.731  1.00 43.01           O  
ATOM   8190  CB  VAL    66    -105.565   9.870 -33.002  1.00 42.88           C  
ATOM   8191  CG1 VAL    66    -104.891  11.013 -32.249  1.00 35.13           C  
ATOM   8192  CG2 VAL    66    -105.110   8.531 -32.428  1.00 35.10           C  
ATOM   8193  N   ARG    67    -108.167  12.164 -32.684  1.00 48.36           N  
ATOM   8194  CA  ARG    67    -108.753  13.427 -33.112  1.00 53.92           C  
ATOM   8195  C   ARG    67    -107.820  14.591 -32.793  1.00 49.32           C  
ATOM   8196  O   ARG    67    -107.342  14.724 -31.667  1.00 48.15           O  
ATOM   8197  CB  ARG    67    -110.116  13.618 -32.440  1.00 58.21           C  
ATOM   8198  CG  ARG    67    -110.978  14.714 -33.038  1.00 66.31           C  
ATOM   8199  CD  ARG    67    -112.314  14.790 -32.317  1.00 73.54           C  
ATOM   8200  NE  ARG    67    -112.903  16.125 -32.388  1.00 80.28           N  
ATOM   8201  CZ  ARG    67    -112.664  17.103 -31.518  1.00 86.09           C  
ATOM   8202  NH1 ARG    67    -111.839  16.912 -30.494  1.00 80.35           N  
ATOM   8203  NH2 ARG    67    -113.252  18.282 -31.672  1.00 91.87           N  
ATOM   8204  N   LEU    68    -107.562  15.424 -33.795  1.00 49.12           N  
ATOM   8205  CA  LEU    68    -106.675  16.571 -33.647  1.00 49.18           C  
ATOM   8206  C   LEU    68    -107.459  17.867 -33.811  1.00 49.62           C  
ATOM   8207  O   LEU    68    -108.159  18.051 -34.804  1.00 48.56           O  
ATOM   8208  CB  LEU    68    -105.534  16.513 -34.671  1.00 49.41           C  
ATOM   8209  CG  LEU    68    -104.300  15.649 -34.391  1.00 49.62           C  
ATOM   8210  CD1 LEU    68    -104.533  14.193 -34.745  1.00 50.08           C  
ATOM   8211  CD2 LEU    68    -103.119  16.188 -35.170  1.00 55.46           C  
ATOM   8212  N   GLN    69    -107.330  18.764 -32.839  1.00 48.75           N  
ATOM   8213  CA  GLN    69    -108.055  20.028 -32.864  1.00 49.66           C  
ATOM   8214  C   GLN    69    -107.172  21.176 -32.386  1.00 47.73           C  
ATOM   8215  O   GLN    69    -106.540  21.078 -31.335  1.00 45.89           O  
ATOM   8216  CB  GLN    69    -109.320  19.936 -32.002  1.00 49.58           C  
ATOM   8217  CG  GLN    69    -110.243  21.150 -32.100  1.00 56.24           C  
ATOM   8218  CD  GLN    69    -111.428  21.082 -31.147  1.00 57.65           C  
ATOM   8219  OE1 GLN    69    -111.413  20.341 -30.165  1.00 61.51           O  
ATOM   8220  NE2 GLN    69    -112.460  21.865 -31.434  1.00 63.23           N  
ATOM   8221  N   VAL    70    -107.132  22.258 -33.162  1.00 46.79           N  
ATOM   8222  CA  VAL    70    -106.425  23.465 -32.744  1.00 45.63           C  
ATOM   8223  C   VAL    70    -107.314  24.237 -31.771  1.00 50.88           C  
ATOM   8224  O   VAL    70    -108.377  24.738 -32.157  1.00 51.95           O  
ATOM   8225  CB  VAL    70    -106.029  24.367 -33.933  1.00 44.32           C  
ATOM   8226  CG1 VAL    70    -105.031  25.425 -33.477  1.00 41.51           C  
ATOM   8227  CG2 VAL    70    -105.442  23.542 -35.065  1.00 37.72           C  
ATOM   8228  N   ASP    71    -106.859  24.307 -30.517  1.00 57.99           N  
ATOM   8229  CA  ASP    71    -107.581  24.923 -29.392  1.00 60.52           C  
ATOM   8230  C   ASP    71    -109.024  24.421 -29.270  1.00 61.83           C  
ATOM   8231  O   ASP    71    -109.254  23.219 -29.136  1.00 62.03           O  
ATOM   8232  CB  ASP    71    -107.508  26.457 -29.463  1.00 62.89           C  
ATOM   8233  CG  ASP    71    -106.079  26.981 -29.403  1.00 69.66           C  
ATOM   8234  OD1 ASP    71    -105.280  26.458 -28.597  1.00 66.80           O  
ATOM   8235  OD2 ASP    71    -105.759  27.927 -30.157  1.00 74.25           O  
ATOM   8236  N   GLU    72    -109.986  25.336 -29.324  1.00 67.01           N  
ATOM   8237  CA  GLU    72    -111.397  24.967 -29.370  1.00 69.33           C  
ATOM   8238  C   GLU    72    -112.042  25.472 -30.658  1.00 67.56           C  
ATOM   8239  O   GLU    72    -113.250  25.704 -30.716  1.00 69.21           O  
ATOM   8240  CB  GLU    72    -112.128  25.476 -28.127  1.00 72.79           C  
ATOM   8241  CG  GLU    72    -111.884  24.613 -26.893  1.00 84.26           C  
ATOM   8242  CD  GLU    72    -112.101  25.361 -25.594  1.00 95.67           C  
ATOM   8243  OE1 GLU    72    -111.532  26.464 -25.436  1.00100.41           O  
ATOM   8244  OE2 GLU    72    -112.831  24.839 -24.724  1.00 98.92           O  
ATOM   8245  N   GLY    73    -111.215  25.616 -31.691  1.00 67.67           N  
ATOM   8246  CA  GLY    73    -111.646  26.110 -32.993  1.00 68.92           C  
ATOM   8247  C   GLY    73    -112.233  25.051 -33.907  1.00 68.85           C  
ATOM   8248  O   GLY    73    -112.516  23.929 -33.484  1.00 66.45           O  
ATOM   8249  N   LYS    74    -112.392  25.420 -35.175  1.00 73.69           N  
ATOM   8250  CA  LYS    74    -113.137  24.626 -36.153  1.00 76.53           C  
ATOM   8251  C   LYS    74    -112.253  23.676 -36.967  1.00 75.07           C  
ATOM   8252  O   LYS    74    -112.757  22.896 -37.783  1.00 74.22           O  
ATOM   8253  CB  LYS    74    -113.920  25.556 -37.090  1.00 81.61           C  
ATOM   8254  CG  LYS    74    -114.897  26.494 -36.380  1.00 88.45           C  
ATOM   8255  CD  LYS    74    -115.299  27.663 -37.273  1.00 94.43           C  
ATOM   8256  CE  LYS    74    -116.285  28.596 -36.579  1.00 94.31           C  
ATOM   8257  NZ  LYS    74    -117.639  27.985 -36.428  1.00 96.16           N  
ATOM   8258  N   ALA    75    -110.943  23.746 -36.739  1.00 73.41           N  
ATOM   8259  CA  ALA    75    -109.978  22.892 -37.434  1.00 69.88           C  
ATOM   8260  C   ALA    75    -109.856  21.516 -36.768  1.00 67.42           C  
ATOM   8261  O   ALA    75    -109.128  21.353 -35.782  1.00 65.58           O  
ATOM   8262  CB  ALA    75    -108.621  23.581 -37.510  1.00 70.25           C  
ATOM   8263  N   VAL    76    -110.579  20.535 -37.311  1.00 60.66           N  
ATOM   8264  CA  VAL    76    -110.595  19.175 -36.765  1.00 59.27           C  
ATOM   8265  C   VAL    76    -110.114  18.142 -37.797  1.00 59.79           C  
ATOM   8266  O   VAL    76    -110.641  18.064 -38.908  1.00 60.59           O  
ATOM   8267  CB  VAL    76    -111.999  18.791 -36.193  1.00 58.84           C  
ATOM   8268  CG1 VAL    76    -112.044  17.324 -35.750  1.00 59.68           C  
ATOM   8269  CG2 VAL    76    -112.380  19.697 -35.023  1.00 57.82           C  
ATOM   8270  N   ILE    77    -109.096  17.371 -37.417  1.00 58.69           N  
ATOM   8271  CA  ILE    77    -108.611  16.242 -38.207  1.00 59.27           C  
ATOM   8272  C   ILE    77    -108.860  14.942 -37.441  1.00 57.23           C  
ATOM   8273  O   ILE    77    -108.650  14.878 -36.228  1.00 54.63           O  
ATOM   8274  CB  ILE    77    -107.106  16.413 -38.573  1.00 60.42           C  
ATOM   8275  CG1 ILE    77    -106.971  17.218 -39.864  1.00 62.03           C  
ATOM   8276  CG2 ILE    77    -106.384  15.063 -38.733  1.00 63.50           C  
ATOM   8277  CD1 ILE    77    -105.544  17.554 -40.232  1.00 65.24           C  
ATOM   8278  N   GLU    78    -109.340  13.922 -38.145  1.00 57.78           N  
ATOM   8279  CA  GLU    78    -109.468  12.599 -37.555  1.00 60.04           C  
ATOM   8280  C   GLU    78    -108.614  11.602 -38.333  1.00 57.68           C  
ATOM   8281  O   GLU    78    -108.806  11.399 -39.533  1.00 59.36           O  
ATOM   8282  CB  GLU    78    -110.933  12.161 -37.490  1.00 61.44           C  
ATOM   8283  CG  GLU    78    -111.316  11.586 -36.139  1.00 71.59           C  
ATOM   8284  CD  GLU    78    -112.807  11.362 -35.982  1.00 82.86           C  
ATOM   8285  OE1 GLU    78    -113.399  11.973 -35.065  1.00 85.63           O  
ATOM   8286  OE2 GLU    78    -113.384  10.575 -36.764  1.00 85.45           O  
ATOM   8287  N   THR    79    -107.655  11.004 -37.634  1.00 55.81           N  
ATOM   8288  CA  THR    79    -106.732  10.030 -38.214  1.00 53.71           C  
ATOM   8289  C   THR    79    -106.540   8.885 -37.214  1.00 50.88           C  
ATOM   8290  O   THR    79    -107.223   8.843 -36.198  1.00 53.52           O  
ATOM   8291  CB  THR    79    -105.387  10.704 -38.633  1.00 56.65           C  
ATOM   8292  OG1 THR    79    -104.436   9.713 -39.047  1.00 55.80           O  
ATOM   8293  CG2 THR    79    -104.801  11.534 -37.490  1.00 53.91           C  
ATOM   8294  N   GLY    80    -105.636   7.952 -37.499  1.00 48.90           N  
ATOM   8295  CA  GLY    80    -105.436   6.798 -36.626  1.00 45.19           C  
ATOM   8296  C   GLY    80    -103.998   6.328 -36.531  1.00 43.56           C  
ATOM   8297  O   GLY    80    -103.134   6.782 -37.288  1.00 43.06           O  
ATOM   8298  N   ILE    81    -103.749   5.418 -35.588  1.00 41.38           N  
ATOM   8299  CA  ILE    81    -102.425   4.828 -35.381  1.00 38.65           C  
ATOM   8300  C   ILE    81    -102.105   3.891 -36.542  1.00 38.79           C  
ATOM   8301  O   ILE    81    -102.950   3.084 -36.931  1.00 42.90           O  
ATOM   8302  CB  ILE    81    -102.347   4.072 -34.017  1.00 37.88           C  
ATOM   8303  CG1 ILE    81    -102.470   5.056 -32.844  1.00 37.27           C  
ATOM   8304  CG2 ILE    81    -101.049   3.254 -33.893  1.00 33.72           C  
ATOM   8305  CD1 ILE    81    -102.728   4.400 -31.495  1.00 36.56           C  
ATOM   8306  N   ARG    82    -100.906   4.039 -37.106  1.00 36.17           N  
ATOM   8307  CA  ARG    82    -100.434   3.188 -38.197  0.50 35.92           C  
ATOM   8309  C   ARG    82     -99.723   1.959 -37.641  1.00 38.22           C  
ATOM   8310  O   ARG    82     -99.928   0.840 -38.121  1.00 36.05           O  
ATOM   8311  CB  ARG    82     -99.487   3.972 -39.112  0.50 34.83           C  
ATOM   8313  CG  ARG    82     -99.010   3.215 -40.350  0.50 39.11           C  
ATOM   8315  CD  ARG    82     -98.224   4.118 -41.294  0.50 35.84           C  
ATOM   8317  NE  ARG    82     -97.622   3.368 -42.395  0.50 33.08           N  
ATOM   8319  CZ  ARG    82     -96.374   2.903 -42.404  0.50 37.07           C  
ATOM   8321  NH1 ARG    82     -95.569   3.106 -41.368  0.50 32.81           N  
ATOM   8323  NH2 ARG    82     -95.926   2.231 -43.457  0.50 36.71           N  
ATOM   8325  N   THR    83     -98.886   2.189 -36.632  1.00 37.48           N  
ATOM   8326  CA  THR    83     -98.088   1.158 -35.979  1.00 39.27           C  
ATOM   8327  C   THR    83     -97.544   1.685 -34.654  1.00 39.23           C  
ATOM   8328  O   THR    83     -97.584   2.892 -34.390  1.00 39.06           O  
ATOM   8329  CB  THR    83     -96.901   0.695 -36.874  1.00 41.83           C  
ATOM   8330  OG1 THR    83     -96.245  -0.419 -36.262  1.00 49.98           O  
ATOM   8331  CG2 THR    83     -95.888   1.825 -37.118  1.00 40.10           C  
ATOM   8332  N   CYS    84     -97.042   0.782 -33.816  1.00 39.51           N  
ATOM   8333  CA  CYS    84     -96.324   1.200 -32.615  1.00 40.53           C  
ATOM   8334  C   CYS    84     -94.914   0.628 -32.602  1.00 39.63           C  
ATOM   8335  O   CYS    84     -94.671  -0.472 -33.091  1.00 41.58           O  
ATOM   8336  CB  CYS    84     -97.084   0.853 -31.328  1.00 40.84           C  
ATOM   8337  SG  CYS    84     -98.856   1.307 -31.327  1.00 47.99           S  
ATOM   8338  N   VAL    85     -93.994   1.422 -32.069  1.00 41.26           N  
ATOM   8339  CA  VAL    85     -92.575   1.088 -31.962  1.00 38.74           C  
ATOM   8340  C   VAL    85     -92.207   1.247 -30.470  1.00 39.32           C  
ATOM   8341  O   VAL    85     -93.071   1.667 -29.693  1.00 38.98           O  
ATOM   8342  CB  VAL    85     -91.720   2.011 -32.891  1.00 39.61           C  
ATOM   8343  CG1 VAL    85     -91.939   1.654 -34.361  1.00 36.84           C  
ATOM   8344  CG2 VAL    85     -92.010   3.488 -32.630  1.00 36.34           C  
ATOM   8345  N   PRO    86     -90.965   0.887 -30.050  1.00 39.93           N  
ATOM   8346  CA  PRO    86     -90.579   1.125 -28.642  1.00 40.46           C  
ATOM   8347  C   PRO    86     -90.798   2.546 -28.099  1.00 41.17           C  
ATOM   8348  O   PRO    86     -91.110   2.702 -26.920  1.00 41.73           O  
ATOM   8349  CB  PRO    86     -89.090   0.763 -28.623  1.00 38.19           C  
ATOM   8350  CG  PRO    86     -88.964  -0.271 -29.677  1.00 39.12           C  
ATOM   8351  CD  PRO    86     -89.882   0.187 -30.776  1.00 40.81           C  
ATOM   8352  N   ALA    87     -90.664   3.561 -28.953  1.00 41.92           N  
ATOM   8353  CA  ALA    87     -90.876   4.959 -28.552  1.00 41.74           C  
ATOM   8354  C   ALA    87     -92.349   5.317 -28.308  1.00 42.35           C  
ATOM   8355  O   ALA    87     -92.646   6.320 -27.659  1.00 44.31           O  
ATOM   8356  CB  ALA    87     -90.265   5.907 -29.580  1.00 39.31           C  
ATOM   8357  N   GLY    88     -93.261   4.500 -28.829  1.00 40.31           N  
ATOM   8358  CA  GLY    88     -94.694   4.729 -28.676  1.00 35.02           C  
ATOM   8359  C   GLY    88     -95.465   4.404 -29.941  1.00 38.26           C  
ATOM   8360  O   GLY    88     -94.940   3.763 -30.856  1.00 38.56           O  
ATOM   8361  N   CYS    89     -96.718   4.846 -29.992  1.00 37.23           N  
ATOM   8362  CA  CYS    89     -97.581   4.594 -31.143  1.00 37.64           C  
ATOM   8363  C   CYS    89     -97.558   5.742 -32.153  1.00 37.25           C  
ATOM   8364  O   CYS    89     -97.679   6.909 -31.783  1.00 38.90           O  
ATOM   8365  CB  CYS    89     -98.997   4.263 -30.677  1.00 36.32           C  
ATOM   8366  SG  CYS    89     -99.087   2.665 -29.817  1.00 44.05           S  
ATOM   8367  N   ILE    90     -97.386   5.397 -33.426  1.00 38.32           N  
ATOM   8368  CA  ILE    90     -97.156   6.382 -34.485  1.00 38.77           C  
ATOM   8369  C   ILE    90     -98.438   6.728 -35.234  1.00 38.84           C  
ATOM   8370  O   ILE    90     -99.085   5.851 -35.811  1.00 39.38           O  
ATOM   8371  CB  ILE    90     -96.072   5.896 -35.490  1.00 40.66           C  
ATOM   8372  CG1 ILE    90     -94.799   5.434 -34.759  1.00 40.11           C  
ATOM   8373  CG2 ILE    90     -95.768   6.968 -36.549  1.00 36.05           C  
ATOM   8374  CD1 ILE    90     -94.091   6.505 -33.922  1.00 47.31           C  
ATOM   8375  N   VAL    91     -98.788   8.015 -35.214  1.00 37.89           N  
ATOM   8376  CA  VAL    91     -99.967   8.541 -35.903  1.00 38.22           C  
ATOM   8377  C   VAL    91     -99.531   9.458 -37.056  1.00 38.71           C  
ATOM   8378  O   VAL    91     -99.006  10.547 -36.804  1.00 37.63           O  
ATOM   8379  CB  VAL    91    -100.880   9.336 -34.930  1.00 37.64           C  
ATOM   8380  CG1 VAL    91    -102.136   9.797 -35.628  1.00 34.89           C  
ATOM   8381  CG2 VAL    91    -101.244   8.505 -33.701  1.00 34.78           C  
ATOM   8382  N   PRO    92     -99.724   9.015 -38.321  1.00 41.21           N  
ATOM   8383  CA  PRO    92     -99.403   9.864 -39.476  1.00 42.25           C  
ATOM   8384  C   PRO    92    -100.380  11.022 -39.603  1.00 43.69           C  
ATOM   8385  O   PRO    92    -101.587  10.855 -39.385  1.00 46.34           O  
ATOM   8386  CB  PRO    92     -99.558   8.923 -40.679  1.00 40.31           C  
ATOM   8387  CG  PRO    92     -99.658   7.560 -40.117  1.00 41.73           C  
ATOM   8388  CD  PRO    92    -100.242   7.706 -38.751  1.00 40.34           C  
ATOM   8389  N   ILE    93     -99.847  12.189 -39.942  1.00 45.44           N  
ATOM   8390  CA  ILE    93    -100.636  13.410 -40.027  1.00 49.26           C  
ATOM   8391  C   ILE    93    -100.320  14.166 -41.312  1.00 48.71           C  
ATOM   8392  O   ILE    93     -99.160  14.278 -41.705  1.00 47.82           O  
ATOM   8393  CB  ILE    93    -100.407  14.322 -38.799  1.00 49.93           C  
ATOM   8394  CG1 ILE    93     -98.955  14.218 -38.324  1.00 54.73           C  
ATOM   8395  CG2 ILE    93    -101.351  13.927 -37.673  1.00 51.42           C  
ATOM   8396  CD1 ILE    93     -98.444  15.402 -37.553  1.00 48.62           C  
ATOM   8397  N   VAL    94    -101.369  14.643 -41.977  1.00 50.69           N  
ATOM   8398  CA  VAL    94    -101.246  15.502 -43.154  1.00 50.83           C  
ATOM   8399  C   VAL    94    -102.096  16.742 -42.903  1.00 50.88           C  
ATOM   8400  O   VAL    94    -103.281  16.628 -42.589  1.00 49.91           O  
ATOM   8401  CB  VAL    94    -101.702  14.779 -44.456  1.00 51.87           C  
ATOM   8402  CG1 VAL    94    -101.773  15.746 -45.634  1.00 51.56           C  
ATOM   8403  CG2 VAL    94    -100.766  13.624 -44.794  1.00 52.37           C  
ATOM   8404  N   PHE    95    -101.482  17.918 -43.019  1.00 51.11           N  
ATOM   8405  CA  PHE    95    -102.182  19.184 -42.817  1.00 53.11           C  
ATOM   8406  C   PHE    95    -102.367  19.943 -44.131  1.00 55.23           C  
ATOM   8407  O   PHE    95    -101.393  20.207 -44.839  1.00 57.10           O  
ATOM   8408  CB  PHE    95    -101.417  20.069 -41.830  1.00 51.34           C  
ATOM   8409  CG  PHE    95    -101.156  19.428 -40.493  1.00 51.30           C  
ATOM   8410  CD1 PHE    95     -99.856  19.297 -40.014  1.00 52.45           C  
ATOM   8411  CD2 PHE    95    -102.205  18.971 -39.704  1.00 51.81           C  
ATOM   8412  CE1 PHE    95     -99.611  18.719 -38.773  1.00 51.34           C  
ATOM   8413  CE2 PHE    95    -101.969  18.393 -38.462  1.00 49.46           C  
ATOM   8414  CZ  PHE    95    -100.673  18.267 -37.997  1.00 47.79           C  
ATOM   8415  N   ASP    96    -103.612  20.298 -44.449  1.00 58.17           N  
ATOM   8416  CA  ASP    96    -103.896  21.166 -45.601  1.00 62.07           C  
ATOM   8417  C   ASP    96    -103.629  22.639 -45.269  1.00 61.94           C  
ATOM   8418  O   ASP    96    -103.404  22.977 -44.103  1.00 61.30           O  
ATOM   8419  CB  ASP    96    -105.324  20.955 -46.143  1.00 62.34           C  
ATOM   8420  CG  ASP    96    -106.411  21.130 -45.079  1.00 68.13           C  
ATOM   8421  OD1 ASP    96    -106.406  22.134 -44.332  1.00 70.22           O  
ATOM   8422  OD2 ASP    96    -107.305  20.260 -45.012  1.00 74.75           O  
ATOM   8423  N   LYS    97    -103.677  23.499 -46.293  1.00 63.21           N  
ATOM   8424  CA  LYS    97    -103.397  24.944 -46.171  1.00 62.15           C  
ATOM   8425  C   LYS    97    -104.205  25.629 -45.062  1.00 58.72           C  
ATOM   8426  O   LYS    97    -103.676  26.483 -44.340  1.00 56.63           O  
ATOM   8427  CB  LYS    97    -103.646  25.671 -47.505  1.00 66.63           C  
ATOM   8428  CG  LYS    97    -103.078  24.989 -48.754  1.00 79.15           C  
ATOM   8429  CD  LYS    97    -101.597  25.278 -48.960  1.00 86.33           C  
ATOM   8430  CE  LYS    97    -101.089  24.618 -50.234  1.00 91.32           C  
ATOM   8431  NZ  LYS    97     -99.626  24.816 -50.433  1.00 92.22           N  
ATOM   8432  N   ASN    98    -105.474  25.231 -44.942  1.00 57.44           N  
ATOM   8433  CA  ASN    98    -106.388  25.775 -43.937  0.50 56.36           C  
ATOM   8435  C   ASN    98    -106.004  25.379 -42.513  1.00 56.07           C  
ATOM   8436  O   ASN    98    -106.101  26.193 -41.586  1.00 55.82           O  
ATOM   8437  CB  ASN    98    -107.826  25.333 -44.230  0.50 55.43           C  
ATOM   8439  CG  ASN    98    -108.272  25.685 -45.639  0.50 59.53           C  
ATOM   8441  OD1 ASN    98    -108.337  24.821 -46.514  0.50 56.99           O  
ATOM   8443  ND2 ASN    98    -108.574  26.959 -45.866  0.50 60.32           N  
ATOM   8445  N   TYR    99    -105.572  24.127 -42.346  1.00 53.30           N  
ATOM   8446  CA  TYR    99    -105.174  23.604 -41.038  1.00 49.37           C  
ATOM   8447  C   TYR    99    -103.825  24.171 -40.601  1.00 46.29           C  
ATOM   8448  O   TYR    99    -103.633  24.483 -39.422  1.00 46.34           O  
ATOM   8449  CB  TYR    99    -105.136  22.073 -41.041  1.00 49.20           C  
ATOM   8450  CG  TYR    99    -105.383  21.459 -39.678  1.00 47.60           C  
ATOM   8451  CD1 TYR    99    -104.369  21.396 -38.725  1.00 45.07           C  
ATOM   8452  CD2 TYR    99    -106.631  20.950 -39.339  1.00 47.01           C  
ATOM   8453  CE1 TYR    99    -104.583  20.839 -37.479  1.00 45.69           C  
ATOM   8454  CE2 TYR    99    -106.857  20.387 -38.087  1.00 49.26           C  
ATOM   8455  CZ  TYR    99    -105.826  20.337 -37.164  1.00 46.90           C  
ATOM   8456  OH  TYR    99    -106.029  19.789 -35.921  1.00 49.80           O  
ATOM   8457  N   VAL   100    -102.906  24.302 -41.556  1.00 43.96           N  
ATOM   8458  CA  VAL   100    -101.616  24.960 -41.332  1.00 43.98           C  
ATOM   8459  C   VAL   100    -101.799  26.388 -40.802  1.00 45.79           C  
ATOM   8460  O   VAL   100    -101.137  26.778 -39.843  1.00 48.00           O  
ATOM   8461  CB  VAL   100    -100.750  24.947 -42.617  1.00 44.35           C  
ATOM   8462  CG1 VAL   100     -99.566  25.891 -42.500  1.00 40.53           C  
ATOM   8463  CG2 VAL   100    -100.267  23.541 -42.908  1.00 42.15           C  
ATOM   8464  N   ALA   101    -102.725  27.136 -41.407  1.00 47.44           N  
ATOM   8465  CA  ALA   101    -103.055  28.503 -40.983  1.00 47.64           C  
ATOM   8466  C   ALA   101    -103.597  28.568 -39.554  1.00 46.99           C  
ATOM   8467  O   ALA   101    -103.307  29.517 -38.819  1.00 51.32           O  
ATOM   8468  CB  ALA   101    -104.048  29.135 -41.954  1.00 47.36           C  
ATOM   8469  N   ALA   102    -104.378  27.558 -39.174  1.00 45.72           N  
ATOM   8470  CA  ALA   102    -104.909  27.437 -37.818  1.00 43.91           C  
ATOM   8471  C   ALA   102    -103.809  27.097 -36.807  1.00 45.33           C  
ATOM   8472  O   ALA   102    -103.827  27.592 -35.680  1.00 46.79           O  
ATOM   8473  CB  ALA   102    -106.022  26.394 -37.774  1.00 42.26           C  
ATOM   8474  N   LEU   103    -102.859  26.258 -37.228  1.00 45.67           N  
ATOM   8475  CA  LEU   103    -101.682  25.882 -36.429  1.00 44.40           C  
ATOM   8476  C   LEU   103    -100.780  27.074 -36.107  1.00 44.93           C  
ATOM   8477  O   LEU   103    -100.211  27.149 -35.017  1.00 44.18           O  
ATOM   8478  CB  LEU   103    -100.866  24.811 -37.167  1.00 43.89           C  
ATOM   8479  CG  LEU   103    -100.812  23.312 -36.816  1.00 45.04           C  
ATOM   8480  CD1 LEU   103    -101.862  22.848 -35.824  1.00 40.47           C  
ATOM   8481  CD2 LEU   103    -100.864  22.475 -38.089  1.00 39.92           C  
ATOM   8482  N   ARG   104    -100.654  27.997 -37.060  1.00 45.96           N  
ATOM   8483  CA  ARG   104     -99.846  29.205 -36.884  1.00 45.42           C  
ATOM   8484  C   ARG   104    -100.493  30.188 -35.908  1.00 45.70           C  
ATOM   8485  O   ARG   104     -99.793  30.910 -35.198  1.00 47.56           O  
ATOM   8486  CB  ARG   104     -99.612  29.903 -38.226  1.00 48.20           C  
ATOM   8487  CG  ARG   104     -98.985  29.032 -39.300  1.00 48.50           C  
ATOM   8488  CD  ARG   104     -98.942  29.763 -40.628  1.00 48.41           C  
ATOM   8489  NE  ARG   104     -97.597  30.242 -40.930  1.00 45.45           N  
ATOM   8490  CZ  ARG   104     -96.884  29.856 -41.983  1.00 48.70           C  
ATOM   8491  NH1 ARG   104     -97.389  28.999 -42.860  1.00 61.07           N  
ATOM   8492  NH2 ARG   104     -95.668  30.342 -42.172  1.00 38.74           N  
ATOM   8493  N   ALA   105    -101.825  30.206 -35.880  1.00 46.39           N  
ATOM   8494  CA  ALA   105    -102.577  31.137 -35.038  1.00 48.45           C  
ATOM   8495  C   ALA   105    -102.917  30.547 -33.674  1.00 49.51           C  
ATOM   8496  O   ALA   105    -103.317  31.272 -32.760  1.00 52.08           O  
ATOM   8497  CB  ALA   105    -103.850  31.589 -35.753  1.00 48.13           C  
ATOM   8498  N   GLY   106    -102.755  29.232 -33.541  1.00 47.95           N  
ATOM   8499  CA  GLY   106    -103.172  28.515 -32.335  1.00 42.97           C  
ATOM   8500  C   GLY   106    -102.157  28.480 -31.207  1.00 42.20           C  
ATOM   8501  O   GLY   106    -100.995  28.862 -31.377  1.00 42.49           O  
ATOM   8502  N   LYS   107    -102.614  28.015 -30.048  1.00 43.00           N  
ATOM   8503  CA  LYS   107    -101.771  27.880 -28.865  1.00 47.17           C  
ATOM   8504  C   LYS   107    -101.509  26.412 -28.525  1.00 45.45           C  
ATOM   8505  O   LYS   107    -100.383  26.029 -28.207  1.00 44.60           O  
ATOM   8506  CB  LYS   107    -102.407  28.607 -27.674  1.00 50.63           C  
ATOM   8507  CG  LYS   107    -101.873  30.023 -27.475  1.00 65.02           C  
ATOM   8508  CD  LYS   107    -102.913  30.961 -26.882  1.00 77.55           C  
ATOM   8509  CE  LYS   107    -103.747  31.627 -27.972  1.00 86.67           C  
ATOM   8510  NZ  LYS   107    -104.663  32.663 -27.416  1.00 90.76           N  
ATOM   8511  N   HIS   108    -102.546  25.600 -28.561  1.00 45.01           N  
ATOM   8512  CA  HIS   108    -102.459  24.180 -28.282  1.00 44.56           C  
ATOM   8513  C   HIS   108    -103.063  23.346 -29.397  1.00 44.55           C  
ATOM   8514  O   HIS   108    -104.122  23.632 -29.880  1.00 43.56           O  
ATOM   8515  CB  HIS   108    -103.221  23.854 -27.015  1.00 47.32           C  
ATOM   8516  CG  HIS   108    -102.505  24.212 -25.762  1.00 54.73           C  
ATOM   8517  ND1 HIS   108    -102.780  23.614 -24.564  1.00 64.61           N  
ATOM   8518  CD2 HIS   108    -101.536  25.110 -25.515  1.00 62.28           C  
ATOM   8519  CE1 HIS   108    -102.005  24.123 -23.633  1.00 65.87           C  
ATOM   8520  NE2 HIS   108    -101.244  25.038 -24.183  1.00 62.10           N  
ATOM   8521  N   LEU   109    -102.395  22.283 -29.779  1.00 41.56           N  
ATOM   8522  CA  LEU   109    -102.997  21.270 -30.627  1.00 41.76           C  
ATOM   8523  C   LEU   109    -103.484  20.151 -29.717  1.00 42.73           C  
ATOM   8524  O   LEU   109    -102.692  19.347 -29.231  1.00 43.29           O  
ATOM   8525  CB  LEU   109    -102.010  20.747 -31.677  1.00 38.66           C  
ATOM   8526  CG  LEU   109    -102.527  19.658 -32.627  1.00 38.21           C  
ATOM   8527  CD1 LEU   109    -103.705  20.134 -33.472  1.00 38.18           C  
ATOM   8528  CD2 LEU   109    -101.416  19.180 -33.517  1.00 37.24           C  
ATOM   8529  N   LYS   110    -104.791  20.125 -29.480  1.00 43.89           N  
ATOM   8530  CA  LYS   110    -105.404  19.176 -28.560  1.00 43.28           C  
ATOM   8531  C   LYS   110    -105.587  17.811 -29.212  1.00 42.81           C  
ATOM   8532  O   LYS   110    -105.958  17.711 -30.386  1.00 41.27           O  
ATOM   8533  CB  LYS   110    -106.747  19.713 -28.057  1.00 46.86           C  
ATOM   8534  CG  LYS   110    -106.637  20.949 -27.172  1.00 53.48           C  
ATOM   8535  CD  LYS   110    -107.995  21.343 -26.614  1.00 68.99           C  
ATOM   8536  CE  LYS   110    -107.894  22.573 -25.725  1.00 83.43           C  
ATOM   8537  NZ  LYS   110    -109.224  22.997 -25.197  1.00 87.33           N  
ATOM   8538  N   LEU   111    -105.312  16.761 -28.444  1.00 43.69           N  
ATOM   8539  CA  LEU   111    -105.471  15.391 -28.923  1.00 43.91           C  
ATOM   8540  C   LEU   111    -106.586  14.683 -28.168  1.00 42.18           C  
ATOM   8541  O   LEU   111    -106.776  14.908 -26.971  1.00 42.42           O  
ATOM   8542  CB  LEU   111    -104.172  14.585 -28.777  1.00 44.52           C  
ATOM   8543  CG  LEU   111    -102.890  14.770 -29.601  1.00 45.49           C  
ATOM   8544  CD1 LEU   111    -103.057  15.711 -30.792  1.00 43.61           C  
ATOM   8545  CD2 LEU   111    -101.758  15.239 -28.714  1.00 46.82           C  
ATOM   8546  N   ALA   112    -107.317  13.826 -28.874  1.00 41.70           N  
ATOM   8547  CA  ALA   112    -108.374  13.027 -28.265  1.00 42.11           C  
ATOM   8548  C   ALA   112    -108.318  11.600 -28.786  1.00 40.83           C  
ATOM   8549  O   ALA   112    -108.326  11.375 -29.995  1.00 41.53           O  
ATOM   8550  CB  ALA   112    -109.737  13.640 -28.541  1.00 43.85           C  
ATOM   8551  N   MET   113    -108.261  10.641 -27.867  1.00 42.50           N  
ATOM   8552  CA  MET   113    -108.178   9.224 -28.225  1.00 41.77           C  
ATOM   8553  C   MET   113    -108.865   8.337 -27.185  1.00 43.96           C  
ATOM   8554  O   MET   113    -109.351   8.830 -26.165  1.00 43.85           O  
ATOM   8555  CB  MET   113    -106.716   8.800 -28.455  1.00 39.60           C  
ATOM   8556  CG  MET   113    -105.768   9.074 -27.297  1.00 39.28           C  
ATOM   8557  SD  MET   113    -104.057   9.187 -27.855  1.00 38.65           S  
ATOM   8558  CE  MET   113    -103.916  10.929 -28.210  1.00 41.68           C  
ATOM   8559  N   THR   114    -108.912   7.036 -27.464  1.00 46.22           N  
ATOM   8560  CA  THR   114    -109.570   6.062 -26.595  1.00 45.64           C  
ATOM   8561  C   THR   114    -108.539   5.101 -26.004  1.00 45.67           C  
ATOM   8562  O   THR   114    -107.699   4.574 -26.725  1.00 45.03           O  
ATOM   8563  CB  THR   114    -110.642   5.261 -27.373  1.00 45.96           C  
ATOM   8564  OG1 THR   114    -111.473   6.162 -28.109  1.00 48.22           O  
ATOM   8565  CG2 THR   114    -111.514   4.449 -26.434  1.00 42.63           C  
ATOM   8566  N   ILE   115    -108.603   4.896 -24.688  1.00 45.73           N  
ATOM   8567  CA  ILE   115    -107.736   3.945 -23.995  1.00 46.76           C  
ATOM   8568  C   ILE   115    -108.279   2.526 -24.181  1.00 48.35           C  
ATOM   8569  O   ILE   115    -109.484   2.295 -24.043  1.00 46.33           O  
ATOM   8570  CB  ILE   115    -107.608   4.296 -22.484  1.00 48.02           C  
ATOM   8571  CG1 ILE   115    -107.145   5.752 -22.308  1.00 45.46           C  
ATOM   8572  CG2 ILE   115    -106.644   3.342 -21.767  1.00 46.95           C  
ATOM   8573  CD1 ILE   115    -107.260   6.284 -20.886  1.00 46.24           C  
ATOM   8574  N   ALA   116    -107.391   1.590 -24.528  1.00 50.35           N  
ATOM   8575  CA  ALA   116    -107.740   0.171 -24.607  1.00 52.06           C  
ATOM   8576  C   ALA   116    -107.751  -0.436 -23.205  1.00 55.15           C  
ATOM   8577  O   ALA   116    -106.767  -1.031 -22.750  1.00 59.61           O  
ATOM   8578  CB  ALA   116    -106.782  -0.572 -25.521  1.00 44.31           C  
ATOM   8579  N   ALA   117    -108.878  -0.253 -22.527  1.00 58.19           N  
ATOM   8580  CA  ALA   117    -109.069  -0.675 -21.145  1.00 61.47           C  
ATOM   8581  C   ALA   117    -110.547  -1.048 -20.998  1.00 66.06           C  
ATOM   8582  O   ALA   117    -111.353  -0.647 -21.847  1.00 65.12           O  
ATOM   8583  CB  ALA   117    -108.688   0.464 -20.192  1.00 59.16           C  
ATOM   8584  N   PRO   118    -110.907  -1.847 -19.961  1.00 70.36           N  
ATOM   8585  CA  PRO   118    -112.326  -2.104 -19.686  1.00 69.83           C  
ATOM   8586  C   PRO   118    -113.139  -0.815 -19.520  1.00 67.26           C  
ATOM   8587  O   PRO   118    -112.801   0.036 -18.690  1.00 65.41           O  
ATOM   8588  CB  PRO   118    -112.289  -2.889 -18.371  1.00 72.29           C  
ATOM   8589  CG  PRO   118    -110.970  -3.562 -18.380  1.00 73.53           C  
ATOM   8590  CD  PRO   118    -110.035  -2.587 -19.025  1.00 71.48           C  
ATOM   8591  N   GLY   119    -114.183  -0.678 -20.336  1.00 64.56           N  
ATOM   8592  CA  GLY   119    -115.020   0.521 -20.353  1.00 65.34           C  
ATOM   8593  C   GLY   119    -114.679   1.468 -21.491  1.00 66.33           C  
ATOM   8594  O   GLY   119    -115.500   2.313 -21.870  1.00 65.92           O  
ATOM   8595  N   GLU   120    -113.468   1.304 -22.031  1.00 65.10           N  
ATOM   8596  CA  GLU   120    -112.886   2.149 -23.091  1.00 60.07           C  
ATOM   8597  C   GLU   120    -112.930   3.659 -22.797  1.00 56.48           C  
ATOM   8598  O   GLU   120    -113.626   4.403 -23.499  1.00 54.40           O  
ATOM   8599  CB  GLU   120    -113.501   1.823 -24.461  1.00 57.83           C  
ATOM   8600  CG  GLU   120    -113.168   0.420 -24.972  1.00 61.58           C  
ATOM   8601  CD  GLU   120    -113.903   0.049 -26.256  1.00 66.14           C  
ATOM   8602  OE1 GLU   120    -114.475   0.945 -26.917  1.00 66.14           O  
ATOM   8603  OE2 GLU   120    -113.890  -1.148 -26.617  1.00 72.51           O  
ATOM   8604  N   PRO   121    -112.171   4.114 -21.774  1.00 52.88           N  
ATOM   8605  CA  PRO   121    -112.229   5.517 -21.353  1.00 53.24           C  
ATOM   8606  C   PRO   121    -111.534   6.454 -22.351  1.00 56.38           C  
ATOM   8607  O   PRO   121    -110.611   6.030 -23.048  1.00 53.06           O  
ATOM   8608  CB  PRO   121    -111.475   5.522 -20.009  1.00 52.61           C  
ATOM   8609  CG  PRO   121    -111.177   4.091 -19.683  1.00 52.96           C  
ATOM   8610  CD  PRO   121    -111.185   3.358 -20.979  1.00 52.36           C  
ATOM   8611  N   PRO   122    -111.985   7.719 -22.435  1.00 59.94           N  
ATOM   8612  CA  PRO   122    -111.286   8.657 -23.309  1.00 58.33           C  
ATOM   8613  C   PRO   122    -110.017   9.220 -22.674  1.00 56.98           C  
ATOM   8614  O   PRO   122    -109.922   9.322 -21.444  1.00 57.07           O  
ATOM   8615  CB  PRO   122    -112.315   9.769 -23.519  1.00 60.21           C  
ATOM   8616  CG  PRO   122    -113.144   9.755 -22.281  1.00 61.14           C  
ATOM   8617  CD  PRO   122    -113.148   8.339 -21.768  1.00 60.85           C  
ATOM   8618  N   LEU   123    -109.047   9.561 -23.519  1.00 54.52           N  
ATOM   8619  CA  LEU   123    -107.865  10.303 -23.100  1.00 53.27           C  
ATOM   8620  C   LEU   123    -107.857  11.620 -23.871  1.00 54.53           C  
ATOM   8621  O   LEU   123    -107.614  11.639 -25.083  1.00 51.60           O  
ATOM   8622  CB  LEU   123    -106.586   9.495 -23.354  1.00 51.52           C  
ATOM   8623  CG  LEU   123    -105.254  10.038 -22.815  1.00 53.22           C  
ATOM   8624  CD1 LEU   123    -105.218  10.070 -21.284  1.00 52.01           C  
ATOM   8625  CD2 LEU   123    -104.097   9.215 -23.355  1.00 50.63           C  
ATOM   8626  N   ASN   124    -108.144  12.713 -23.163  1.00 56.50           N  
ATOM   8627  CA  ASN   124    -108.382  14.015 -23.792  1.00 56.92           C  
ATOM   8628  C   ASN   124    -107.468  15.139 -23.302  1.00 56.47           C  
ATOM   8629  O   ASN   124    -107.540  16.263 -23.805  1.00 57.02           O  
ATOM   8630  CB  ASN   124    -109.848  14.431 -23.610  1.00 59.19           C  
ATOM   8631  CG  ASN   124    -110.825  13.484 -24.293  1.00 62.91           C  
ATOM   8632  OD1 ASN   124    -110.506  12.856 -25.306  1.00 63.84           O  
ATOM   8633  ND2 ASN   124    -112.032  13.388 -23.741  1.00 62.51           N  
ATOM   8634  N   ASP   125    -106.609  14.837 -22.332  1.00 55.89           N  
ATOM   8635  CA  ASP   125    -105.779  15.864 -21.692  1.00 57.91           C  
ATOM   8636  C   ASP   125    -104.396  16.068 -22.331  1.00 55.21           C  
ATOM   8637  O   ASP   125    -103.591  16.868 -21.845  1.00 54.81           O  
ATOM   8638  CB  ASP   125    -105.666  15.616 -20.173  1.00 62.84           C  
ATOM   8639  CG  ASP   125    -105.107  14.231 -19.822  1.00 72.01           C  
ATOM   8640  OD1 ASP   125    -104.941  13.962 -18.613  1.00 81.27           O  
ATOM   8641  OD2 ASP   125    -104.833  13.413 -20.727  1.00 74.19           O  
ATOM   8642  N   LEU   126    -104.131  15.349 -23.420  1.00 51.02           N  
ATOM   8643  CA  LEU   126    -102.862  15.481 -24.138  1.00 46.92           C  
ATOM   8644  C   LEU   126    -102.934  16.535 -25.235  1.00 44.90           C  
ATOM   8645  O   LEU   126    -103.976  16.714 -25.877  1.00 45.37           O  
ATOM   8646  CB  LEU   126    -102.422  14.140 -24.730  1.00 47.54           C  
ATOM   8647  CG  LEU   126    -101.420  13.221 -24.023  1.00 47.39           C  
ATOM   8648  CD1 LEU   126    -101.581  13.167 -22.504  1.00 46.51           C  
ATOM   8649  CD2 LEU   126    -101.553  11.842 -24.625  1.00 44.20           C  
ATOM   8650  N   PHE   127    -101.809  17.212 -25.446  1.00 41.83           N  
ATOM   8651  CA  PHE   127    -101.706  18.298 -26.410  1.00 41.39           C  
ATOM   8652  C   PHE   127    -100.275  18.487 -26.886  1.00 40.58           C  
ATOM   8653  O   PHE   127     -99.340  17.969 -26.280  1.00 41.29           O  
ATOM   8654  CB  PHE   127    -102.233  19.626 -25.825  1.00 44.43           C  
ATOM   8655  CG  PHE   127    -101.652  19.980 -24.479  1.00 47.75           C  
ATOM   8656  CD1 PHE   127    -100.417  20.619 -24.373  1.00 47.14           C  
ATOM   8657  CD2 PHE   127    -102.350  19.680 -23.312  1.00 49.24           C  
ATOM   8658  CE1 PHE   127     -99.883  20.940 -23.128  1.00 49.24           C  
ATOM   8659  CE2 PHE   127    -101.824  19.998 -22.065  1.00 50.32           C  
ATOM   8660  CZ  PHE   127    -100.590  20.629 -21.973  1.00 51.44           C  
ATOM   8661  N   VAL   128    -100.116  19.241 -27.969  1.00 39.64           N  
ATOM   8662  CA  VAL   128     -98.810  19.727 -28.402  1.00 35.39           C  
ATOM   8663  C   VAL   128     -98.871  21.252 -28.339  1.00 37.91           C  
ATOM   8664  O   VAL   128     -99.822  21.863 -28.828  1.00 37.48           O  
ATOM   8665  CB  VAL   128     -98.448  19.246 -29.832  1.00 34.96           C  
ATOM   8666  CG1 VAL   128     -97.069  19.763 -30.258  1.00 30.06           C  
ATOM   8667  CG2 VAL   128     -98.479  17.727 -29.917  1.00 32.12           C  
ATOM   8668  N   GLN   129     -97.872  21.862 -27.707  1.00 38.26           N  
ATOM   8669  CA  GLN   129     -97.810  23.317 -27.601  1.00 36.17           C  
ATOM   8670  C   GLN   129     -97.309  23.935 -28.904  1.00 36.80           C  
ATOM   8671  O   GLN   129     -96.326  23.473 -29.489  1.00 36.17           O  
ATOM   8672  CB  GLN   129     -96.923  23.732 -26.432  1.00 35.06           C  
ATOM   8673  CG  GLN   129     -97.478  23.348 -25.062  1.00 36.77           C  
ATOM   8674  CD  GLN   129     -96.547  23.751 -23.932  1.00 39.52           C  
ATOM   8675  OE1 GLN   129     -96.678  24.837 -23.363  1.00 44.44           O  
ATOM   8676  NE2 GLN   129     -95.588  22.888 -23.615  1.00 37.86           N  
ATOM   8677  N   LEU   130     -97.986  24.989 -29.348  1.00 39.66           N  
ATOM   8678  CA  LEU   130     -97.746  25.542 -30.682  1.00 37.39           C  
ATOM   8679  C   LEU   130     -96.927  26.823 -30.700  1.00 36.78           C  
ATOM   8680  O   LEU   130     -96.784  27.445 -31.753  1.00 41.24           O  
ATOM   8681  CB  LEU   130     -99.072  25.741 -31.425  1.00 35.81           C  
ATOM   8682  CG  LEU   130     -99.896  24.487 -31.722  1.00 34.91           C  
ATOM   8683  CD1 LEU   130    -101.245  24.877 -32.294  1.00 34.39           C  
ATOM   8684  CD2 LEU   130     -99.152  23.531 -32.666  1.00 30.66           C  
ATOM   8685  N   ASN   131     -96.387  27.213 -29.548  1.00 39.07           N  
ATOM   8686  CA  ASN   131     -95.550  28.406 -29.468  1.00 38.32           C  
ATOM   8687  C   ASN   131     -94.264  28.239 -30.276  1.00 39.51           C  
ATOM   8688  O   ASN   131     -93.415  27.407 -29.953  1.00 40.05           O  
ATOM   8689  CB  ASN   131     -95.232  28.778 -28.015  1.00 41.74           C  
ATOM   8690  CG  ASN   131     -94.448  30.077 -27.907  1.00 44.69           C  
ATOM   8691  OD1 ASN   131     -93.229  30.068 -27.732  1.00 50.64           O  
ATOM   8692  ND2 ASN   131     -95.144  31.199 -28.033  1.00 50.20           N  
ATOM   8693  N   GLY   132     -94.150  29.023 -31.343  1.00 37.36           N  
ATOM   8694  CA  GLY   132     -93.003  28.953 -32.239  1.00 31.67           C  
ATOM   8695  C   GLY   132     -93.244  28.183 -33.527  1.00 34.02           C  
ATOM   8696  O   GLY   132     -92.359  28.129 -34.377  1.00 38.35           O  
ATOM   8697  N   PHE   133     -94.431  27.590 -33.670  1.00 36.76           N  
ATOM   8698  CA  PHE   133     -94.796  26.820 -34.870  1.00 38.96           C  
ATOM   8699  C   PHE   133     -94.644  27.644 -36.152  1.00 41.71           C  
ATOM   8700  O   PHE   133     -94.022  27.185 -37.115  1.00 42.81           O  
ATOM   8701  CB  PHE   133     -96.235  26.273 -34.773  1.00 39.20           C  
ATOM   8702  CG  PHE   133     -96.596  25.297 -35.871  1.00 41.70           C  
ATOM   8703  CD1 PHE   133     -96.525  23.924 -35.649  1.00 43.33           C  
ATOM   8704  CD2 PHE   133     -97.017  25.749 -37.127  1.00 42.03           C  
ATOM   8705  CE1 PHE   133     -96.848  23.014 -36.665  1.00 43.98           C  
ATOM   8706  CE2 PHE   133     -97.337  24.854 -38.146  1.00 39.80           C  
ATOM   8707  CZ  PHE   133     -97.254  23.484 -37.916  1.00 42.34           C  
ATOM   8708  N   SER   134     -95.220  28.848 -36.149  1.00 42.18           N  
ATOM   8709  CA  SER   134     -95.229  29.740 -37.313  1.00 42.38           C  
ATOM   8710  C   SER   134     -93.817  30.116 -37.757  1.00 40.58           C  
ATOM   8711  O   SER   134     -93.495  30.008 -38.943  1.00 42.40           O  
ATOM   8712  CB  SER   134     -96.059  30.995 -37.014  1.00 46.82           C  
ATOM   8713  OG  SER   134     -96.150  31.853 -38.136  1.00 54.10           O  
ATOM   8714  N   ASN   135     -92.980  30.528 -36.802  1.00 38.02           N  
ATOM   8715  CA  ASN   135     -91.591  30.900 -37.084  1.00 39.07           C  
ATOM   8716  C   ASN   135     -90.716  29.738 -37.534  1.00 40.40           C  
ATOM   8717  O   ASN   135     -89.853  29.910 -38.399  1.00 45.00           O  
ATOM   8718  CB  ASN   135     -90.956  31.588 -35.877  1.00 42.86           C  
ATOM   8719  CG  ASN   135     -91.424  33.016 -35.704  1.00 45.18           C  
ATOM   8720  OD1 ASN   135     -91.832  33.673 -36.664  1.00 49.01           O  
ATOM   8721  ND2 ASN   135     -91.363  33.509 -34.472  1.00 45.57           N  
ATOM   8722  N   ALA   136     -90.941  28.563 -36.950  1.00 40.02           N  
ATOM   8723  CA  ALA   136     -90.217  27.350 -37.346  1.00 38.53           C  
ATOM   8724  C   ALA   136     -90.631  26.886 -38.742  1.00 36.86           C  
ATOM   8725  O   ALA   136     -89.804  26.381 -39.498  1.00 38.11           O  
ATOM   8726  CB  ALA   136     -90.411  26.230 -36.319  1.00 36.47           C  
ATOM   8727  N   LEU   137     -91.905  27.070 -39.082  1.00 37.02           N  
ATOM   8728  CA  LEU   137     -92.394  26.736 -40.420  1.00 39.48           C  
ATOM   8729  C   LEU   137     -91.861  27.698 -41.484  1.00 41.97           C  
ATOM   8730  O   LEU   137     -91.545  27.270 -42.596  1.00 45.89           O  
ATOM   8731  CB  LEU   137     -93.922  26.674 -40.453  1.00 38.11           C  
ATOM   8732  CG  LEU   137     -94.596  26.152 -41.724  1.00 38.77           C  
ATOM   8733  CD1 LEU   137     -94.068  24.788 -42.136  1.00 37.35           C  
ATOM   8734  CD2 LEU   137     -96.089  26.102 -41.522  1.00 38.36           C  
ATOM   8735  N   ASN   138     -91.750  28.982 -41.131  1.00 42.09           N  
ATOM   8736  CA  ASN   138     -91.138  29.994 -42.000  1.00 42.09           C  
ATOM   8737  C   ASN   138     -89.689  29.657 -42.328  1.00 43.62           C  
ATOM   8738  O   ASN   138     -89.239  29.867 -43.454  1.00 48.34           O  
ATOM   8739  CB  ASN   138     -91.190  31.386 -41.355  1.00 42.26           C  
ATOM   8740  CG  ASN   138     -92.591  31.979 -41.320  1.00 42.14           C  
ATOM   8741  OD1 ASN   138     -93.517  31.477 -41.950  1.00 42.75           O  
ATOM   8742  ND2 ASN   138     -92.745  33.061 -40.571  1.00 41.76           N  
ATOM   8743  N   ARG   139     -88.969  29.140 -41.334  1.00 45.67           N  
ATOM   8744  CA  ARG   139     -87.590  28.693 -41.508  1.00 43.72           C  
ATOM   8745  C   ARG   139     -87.516  27.463 -42.424  1.00 43.33           C  
ATOM   8746  O   ARG   139     -86.610  27.356 -43.247  1.00 45.37           O  
ATOM   8747  CB  ARG   139     -86.942  28.429 -40.142  1.00 42.86           C  
ATOM   8748  CG  ARG   139     -85.506  27.912 -40.174  1.00 43.81           C  
ATOM   8749  CD  ARG   139     -84.563  28.856 -40.900  1.00 45.81           C  
ATOM   8750  NE  ARG   139     -83.174  28.411 -40.801  1.00 53.72           N  
ATOM   8751  CZ  ARG   139     -82.195  28.800 -41.613  1.00 55.64           C  
ATOM   8752  NH1 ARG   139     -82.438  29.636 -42.614  1.00 57.67           N  
ATOM   8753  NH2 ARG   139     -80.965  28.341 -41.429  1.00 55.83           N  
ATOM   8754  N   LEU   140     -88.484  26.557 -42.290  1.00 44.94           N  
ATOM   8755  CA  LEU   140     -88.597  25.388 -43.168  1.00 46.02           C  
ATOM   8756  C   LEU   140     -88.870  25.768 -44.627  1.00 49.25           C  
ATOM   8757  O   LEU   140     -88.360  25.119 -45.547  1.00 50.94           O  
ATOM   8758  CB  LEU   140     -89.676  24.427 -42.657  1.00 44.43           C  
ATOM   8759  CG  LEU   140     -89.263  23.036 -42.161  1.00 42.54           C  
ATOM   8760  CD1 LEU   140     -88.145  23.071 -41.135  1.00 34.28           C  
ATOM   8761  CD2 LEU   140     -90.474  22.281 -41.622  1.00 34.42           C  
ATOM   8762  N   ILE   141     -89.674  26.813 -44.825  1.00 50.63           N  
ATOM   8763  CA  ILE   141     -89.933  27.380 -46.152  1.00 51.16           C  
ATOM   8764  C   ILE   141     -88.652  28.003 -46.720  1.00 52.42           C  
ATOM   8765  O   ILE   141     -88.311  27.776 -47.885  1.00 55.57           O  
ATOM   8766  CB  ILE   141     -91.092  28.418 -46.116  1.00 51.67           C  
ATOM   8767  CG1 ILE   141     -92.414  27.733 -45.743  1.00 48.54           C  
ATOM   8768  CG2 ILE   141     -91.245  29.126 -47.466  1.00 53.10           C  
ATOM   8769  CD1 ILE   141     -93.491  28.667 -45.217  1.00 46.79           C  
ATOM   8770  N   ALA   142     -87.940  28.750 -45.876  1.00 52.51           N  
ATOM   8771  CA  ALA   142     -86.662  29.376 -46.232  1.00 53.46           C  
ATOM   8772  C   ALA   142     -85.546  28.372 -46.549  1.00 55.72           C  
ATOM   8773  O   ALA   142     -84.695  28.639 -47.401  1.00 60.79           O  
ATOM   8774  CB  ALA   142     -86.216  30.336 -45.124  1.00 50.56           C  
ATOM   8775  N   LEU   143     -85.555  27.228 -45.864  1.00 57.21           N  
ATOM   8776  CA  LEU   143     -84.567  26.172 -46.092  1.00 58.17           C  
ATOM   8777  C   LEU   143     -84.829  25.377 -47.377  1.00 61.92           C  
ATOM   8778  O   LEU   143     -83.911  24.755 -47.923  1.00 63.84           O  
ATOM   8779  CB  LEU   143     -84.485  25.230 -44.885  1.00 55.26           C  
ATOM   8780  CG  LEU   143     -83.691  25.691 -43.658  1.00 52.15           C  
ATOM   8781  CD1 LEU   143     -84.099  24.885 -42.426  1.00 47.67           C  
ATOM   8782  CD2 LEU   143     -82.186  25.601 -43.889  1.00 51.87           C  
ATOM   8783  N   GLN   144     -86.078  25.390 -47.846  1.00 65.75           N  
ATOM   8784  CA  GLN   144     -86.444  24.772 -49.123  1.00 71.05           C  
ATOM   8785  C   GLN   144     -85.878  25.549 -50.307  1.00 73.07           C  
ATOM   8786  O   GLN   144     -85.436  24.954 -51.296  1.00 73.75           O  
ATOM   8787  CB  GLN   144     -87.963  24.664 -49.268  1.00 71.94           C  
ATOM   8788  CG  GLN   144     -88.529  23.295 -48.930  1.00 77.77           C  
ATOM   8789  CD  GLN   144     -89.821  22.994 -49.678  1.00 79.09           C  
ATOM   8790  OE1 GLN   144     -90.596  23.898 -50.003  1.00 73.88           O  
ATOM   8791  NE2 GLN   144     -90.057  21.714 -49.952  1.00 79.06           N  
ATOM   8792  N   LYS   145     -85.898  26.877 -50.191  1.00 74.17           N  
ATOM   8793  CA  LYS   145     -85.368  27.774 -51.220  1.00 75.54           C  
ATOM   8794  C   LYS   145     -83.838  27.721 -51.302  1.00 76.51           C  
ATOM   8795  O   LYS   145     -83.263  27.926 -52.374  1.00 79.49           O  
ATOM   8796  CB  LYS   145     -85.854  29.206 -50.982  1.00 76.15           C  
ATOM   8797  CG  LYS   145     -87.359  29.376 -51.148  1.00 79.02           C  
ATOM   8798  CD  LYS   145     -87.827  30.741 -50.679  1.00 82.69           C  
ATOM   8799  CE  LYS   145     -89.345  30.829 -50.697  1.00 86.16           C  
ATOM   8800  NZ  LYS   145     -89.840  32.104 -50.106  1.00 88.65           N  
END
