
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   91 (  706),  selected   91 , name 1lzw_A
# Molecule2: number of CA atoms   71 (  556),  selected   71 , name T0513_17_85.pdb
# PARAMETERS: 1lzw_A.T0513_17_85.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     1_A      N      17           -
LGA    K     2_A      F      18           -
LGA    V     3_A      V      19           -
LGA    R     4_A      R      20           -
LGA    D     5_A      F      21           -
LGA    A     6_A      V      22           -
LGA    L     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    M    12_A      -       -           -
LGA    Y    13_A      -       -           -
LGA    K    14_A      I      23          3.354
LGA    V    15_A      E      24           -
LGA    -       -      G      25           -
LGA    -       -      R      26           -
LGA    -       -      R      27           -
LGA    I    16_A      V      28           #
LGA    L    17_A      G      29           -
LGA    V    18_A      W      30          4.390
LGA    N    19_A      V      31          2.167
LGA    D    20_A      R      32          0.849
LGA    D    21_A      K      33          4.489
LGA    Y    22_A      A      34          4.392
LGA    T    23_A      L      35          2.817
LGA    P    24_A      A      36           #
LGA    M    25_A      Q      37          2.275
LGA    E    26_A      -       -           -
LGA    F    27_A      R      38          2.663
LGA    V    28_A      L      39          2.365
LGA    I    29_A      K      40          2.102
LGA    D    30_A      A      41          0.972
LGA    V    31_A      H      42          1.446
LGA    L    32_A      G      43          1.746
LGA    Q    33_A      -       -           -
LGA    K    34_A      -       -           -
LGA    F    35_A      R      44          3.748
LGA    F    36_A      V      45          3.219
LGA    S    37_A      F      46           -
LGA    Y    38_A      -       -           -
LGA    D    39_A      -       -           -
LGA    V    40_A      -       -           -
LGA    E    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    A    43_A      -       -           -
LGA    T    44_A      -       -           -
LGA    Q    45_A      -       -           -
LGA    L    46_A      D      47          3.707
LGA    M    47_A      V      48          2.271
LGA    L    48_A      T      49          2.347
LGA    A    49_A      R      50          3.921
LGA    V    50_A      -       -           -
LGA    A    51_A      -       -           -
LGA    Y    52_A      D      51          2.113
LGA    Q    53_A      A      52          3.965
LGA    G    54_A      -       -           -
LGA    K    55_A      -       -           -
LGA    A    56_A      V      53          2.617
LGA    I    57_A      L      54          2.077
LGA    C    58_A      L      55          2.090
LGA    G    59_A      S      56          1.933
LGA    V    60_A      A      57          3.594
LGA    -       -      S      58           -
LGA    -       -      L      59           -
LGA    F    61_A      R      60          1.761
LGA    T    62_A      T      61          1.097
LGA    A    63_A      P      62          1.793
LGA    E    64_A      Q      63          1.608
LGA    V    65_A      S      64          1.184
LGA    A    66_A      R      65          1.339
LGA    E    67_A      T      66          1.368
LGA    T    68_A      R      67          0.728
LGA    K    69_A      A      68          0.959
LGA    V    70_A      V      69          1.708
LGA    A    71_A      A      70          0.662
LGA    M    72_A      D      71          0.853
LGA    V    73_A      V      72          1.380
LGA    N    74_A      V      73          1.098
LGA    K    75_A      D      74          1.017
LGA    Y    76_A      R      75          1.503
LGA    A    77_A      L      76          1.367
LGA    R    78_A      A      77          0.954
LGA    E    79_A      D      78          1.203
LGA    N    80_A      E      79          1.531
LGA    E    81_A      G      80          1.626
LGA    H    82_A      V      81          1.531
LGA    P    83_A      V      82          3.234
LGA    L    84_A      P      83           -
LGA    L    85_A      A      84           -
LGA    C    86_A      P      85           -
LGA    T    87_A      R      86           -
LGA    L    88_A      G      87           -
LGA    E    89_A      -       -           -
LGA    K    90_A      -       -           -
LGA    A    91_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   91   71    5.0     50    2.36     8.00     52.417     2.037

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.561796 * X  +   0.821005 * Y  +  -0.101672 * Z  + -64.636116
  Y_new =   0.229939 * X  +  -0.273023 * Y  +  -0.934123 * Z  +  91.059105
  Z_new =  -0.794678 * X  +   0.501408 * Y  +  -0.342164 * Z  +  -8.543949 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.169617   -0.971976  [ DEG:   124.3099    -55.6901 ]
  Theta =   0.918478    2.223115  [ DEG:    52.6249    127.3751 ]
  Phi   =   0.388492   -2.753101  [ DEG:    22.2589   -157.7411 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1lzw_A                                        
REMARK     2: T0513_17_85.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1lzw_A.T0513_17_85.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   91   71   5.0   50   2.36    8.00  52.417
REMARK  ---------------------------------------------------------- 
MOLECULE 1lzw_A
HEADER    CHAPERONE                               11-JUN-02   1LZW              
TITLE     STRUCTURAL BASIS OF CLPS-MEDIATED SWITCH IN CLPA SUBSTRATE            
TITLE    2 RECOGNITION                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN YLJA;                                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES;                                                       
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: ATP-DEPENDENT CLP PROTEASE ATP-BINDING SUBUNIT             
COMPND   8 CLPA;                                                                
COMPND   9 CHAIN: B;                                                            
COMPND  10 FRAGMENT: RESIDUES 1-146;                                            
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   8 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    ALPHA-BETA-PROTEIN (CLPS), ALPHA-PROTEIN (CLPA-ND)                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.ZETH,R.B.RAVELLI,K.PAAL,S.CUSACK,B.BUKAU,D.A.DOUGAN                 
REVDAT   1   27-NOV-02 1LZW    0                                                
JRNL        AUTH   K.ZETH,R.B.RAVELLI,K.PAAL,S.CUSACK,B.BUKAU,                  
JRNL        AUTH 2 D.A.DOUGAN                                                   
JRNL        TITL   STRUCTURAL ANALYSIS OF THE ADAPTOR PROTEIN CLPS IN           
JRNL        TITL 2 COMPLEX WITH THE N-TERMINAL DOMAIN OF CLPA                   
JRNL        REF    NAT.STRUCT.BIOL.              V.   9   906 2002              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1LZW A  -14    91  UNP    P0A8Q6   CLPS_ECOLI       1    106             
DBREF  1LZW B   92   237  UNP    P0ABH9   CLPA_ECOLI       1    146             
SEQRES   1 A  106  MET GLY LYS THR ASN ASP TRP LEU ASP PHE ASP GLN LEU          
SEQRES   2 A  106  ALA GLU GLU LYS VAL ARG ASP ALA LEU LYS PRO PRO SER          
SEQRES   3 A  106  MET TYR LYS VAL ILE LEU VAL ASN ASP ASP TYR THR PRO          
SEQRES   4 A  106  MET GLU PHE VAL ILE ASP VAL LEU GLN LYS PHE PHE SER          
SEQRES   5 A  106  TYR ASP VAL GLU ARG ALA THR GLN LEU MET LEU ALA VAL          
SEQRES   6 A  106  ALA TYR GLN GLY LYS ALA ILE CYS GLY VAL PHE THR ALA          
SEQRES   7 A  106  GLU VAL ALA GLU THR LYS VAL ALA MET VAL ASN LYS TYR          
SEQRES   8 A  106  ALA ARG GLU ASN GLU HIS PRO LEU LEU CYS THR LEU GLU          
SEQRES   9 A  106  LYS ALA                                                      
SEQRES   1 B  146  MET LEU ASN GLN GLU LEU GLU LEU SER LEU ASN MET ALA          
SEQRES   2 B  146  PHE ALA ARG ALA ARG GLU HIS ARG HIS GLU PHE MET THR          
SEQRES   3 B  146  VAL GLU HIS LEU LEU LEU ALA LEU LEU SER ASN PRO SER          
SEQRES   4 B  146  ALA ARG GLU ALA LEU GLU ALA CYS SER VAL ASP LEU VAL          
SEQRES   5 B  146  ALA LEU ARG GLN GLU LEU GLU ALA PHE ILE GLU GLN THR          
SEQRES   6 B  146  THR PRO VAL LEU PRO ALA SER GLU GLU GLU ARG ASP THR          
SEQRES   7 B  146  GLN PRO THR LEU SER PHE GLN ARG VAL LEU GLN ARG ALA          
SEQRES   8 B  146  VAL PHE HIS VAL GLN SER SER GLY ARG ASN GLU VAL THR          
SEQRES   9 B  146  GLY ALA ASN VAL LEU VAL ALA ILE PHE SER GLU GLN GLU          
SEQRES  10 B  146  SER GLN ALA ALA TYR LEU LEU ARG LYS HIS GLU VAL SER          
SEQRES  11 B  146  ARG LEU ASP VAL VAL ASN PHE ILE SER HIS GLY THR ARG          
SEQRES  12 B  146  LYS ASP GLU                                                  
HET     PT    300       1                                                       
HETNAM      PT PLATINUM (II) ION                                                
FORMUL   3   PT    PT 2+                                                        
FORMUL   4  HOH   *48(H2 O)                                                     
CRYST1   90.880  114.590   38.490  90.00  90.00  90.00 P 21 21 2     4          
ATOM      1  N   GLU A   1      46.880  53.151 -30.933  1.00114.21           N  
ATOM      2  CA  GLU A   1      45.970  54.091 -30.210  1.00114.19           C  
ATOM      3  C   GLU A   1      45.174  53.355 -29.126  1.00114.00           C  
ATOM      4  O   GLU A   1      45.184  52.124 -29.074  1.00114.02           O  
ATOM      5  CB  GLU A   1      45.022  54.759 -31.206  1.00113.86           C  
ATOM      6  N   LYS A   2      44.493  54.113 -28.263  1.00113.62           N  
ATOM      7  CA  LYS A   2      43.695  53.543 -27.170  1.00112.94           C  
ATOM      8  C   LYS A   2      42.321  54.219 -26.993  1.00112.48           C  
ATOM      9  O   LYS A   2      41.861  54.943 -27.885  1.00112.36           O  
ATOM     10  CB  LYS A   2      44.484  53.617 -25.865  1.00112.74           C  
ATOM     11  N   VAL A   3      41.664  53.981 -25.853  1.00111.42           N  
ATOM     12  CA  VAL A   3      40.350  54.585 -25.603  1.00110.53           C  
ATOM     13  C   VAL A   3      39.784  54.500 -24.166  1.00110.03           C  
ATOM     14  O   VAL A   3      38.694  53.957 -23.950  1.00110.20           O  
ATOM     15  CB  VAL A   3      39.334  54.017 -26.590  1.00110.09           C  
ATOM     16  N   ARG A   4      40.520  55.061 -23.202  1.00108.70           N  
ATOM     17  CA  ARG A   4      40.121  55.099 -21.786  1.00107.01           C  
ATOM     18  C   ARG A   4      39.707  53.769 -21.148  1.00105.78           C  
ATOM     19  O   ARG A   4      39.829  52.705 -21.760  1.00106.53           O  
ATOM     20  CB  ARG A   4      39.009  56.135 -21.591  1.00107.21           C  
ATOM     21  N   ASP A   5      39.207  53.852 -19.912  1.00103.34           N  
ATOM     22  CA  ASP A   5      38.777  52.684 -19.133  1.00100.45           C  
ATOM     23  C   ASP A   5      37.731  51.795 -19.806  1.00 98.30           C  
ATOM     24  O   ASP A   5      37.180  52.143 -20.856  1.00 98.44           O  
ATOM     25  CB  ASP A   5      38.267  53.133 -17.766  1.00100.66           C  
ATOM     26  N   ALA A   6      37.457  50.653 -19.174  1.00 94.96           N  
ATOM     27  CA  ALA A   6      36.506  49.665 -19.686  1.00 91.86           C  
ATOM     28  C   ALA A   6      35.057  50.129 -19.746  1.00 89.47           C  
ATOM     29  O   ALA A   6      34.740  51.275 -19.424  1.00 89.33           O  
ATOM     30  CB  ALA A   6      36.600  48.379 -18.861  1.00 91.23           C  
ATOM     31  N   LEU A   7      34.182  49.223 -20.173  1.00 86.38           N  
ATOM     32  CA  LEU A   7      32.760  49.526 -20.269  1.00 83.13           C  
ATOM     33  C   LEU A   7      31.922  48.609 -19.372  1.00 80.66           C  
ATOM     34  O   LEU A   7      31.651  48.945 -18.215  1.00 80.74           O  
ATOM     35  CB  LEU A   7      32.284  49.417 -21.724  1.00 83.21           C  
ATOM     36  CG  LEU A   7      32.818  50.454 -22.720  1.00 83.53           C  
ATOM     37  CD1 LEU A   7      32.174  50.238 -24.085  1.00 82.35           C  
ATOM     38  CD2 LEU A   7      32.519  51.857 -22.212  1.00 83.91           C  
ATOM     39  N   LYS A   8      31.525  47.454 -19.908  1.00 76.72           N  
ATOM     40  CA  LYS A   8      30.702  46.489 -19.173  1.00 71.61           C  
ATOM     41  C   LYS A   8      29.355  47.117 -18.798  1.00 66.19           C  
ATOM     42  O   LYS A   8      29.303  48.150 -18.130  1.00 65.39           O  
ATOM     43  CB  LYS A   8      31.406  46.023 -17.888  1.00 73.97           C  
ATOM     44  CG  LYS A   8      32.858  45.581 -18.057  1.00 77.48           C  
ATOM     45  CD  LYS A   8      33.005  44.349 -18.942  1.00 79.60           C  
ATOM     46  CE  LYS A   8      34.483  44.011 -19.155  1.00 81.11           C  
ATOM     47  NZ  LYS A   8      34.705  42.865 -20.087  1.00 81.51           N  
ATOM     48  N   PRO A   9      28.247  46.506 -19.238  1.00 60.73           N  
ATOM     49  CA  PRO A   9      26.927  47.051 -18.910  1.00 56.18           C  
ATOM     50  C   PRO A   9      26.681  46.919 -17.413  1.00 51.76           C  
ATOM     51  O   PRO A   9      27.247  46.039 -16.767  1.00 50.96           O  
ATOM     52  CB  PRO A   9      25.973  46.169 -19.716  1.00 56.44           C  
ATOM     53  CG  PRO A   9      26.812  45.715 -20.868  1.00 58.31           C  
ATOM     54  CD  PRO A   9      28.133  45.408 -20.210  1.00 59.81           C  
ATOM     55  N   PRO A  10      25.843  47.794 -16.839  1.00 48.47           N  
ATOM     56  CA  PRO A  10      25.575  47.694 -15.404  1.00 45.85           C  
ATOM     57  C   PRO A  10      24.985  46.320 -15.084  1.00 43.25           C  
ATOM     58  O   PRO A  10      24.236  45.751 -15.874  1.00 42.00           O  
ATOM     59  CB  PRO A  10      24.568  48.816 -15.156  1.00 45.93           C  
ATOM     60  CG  PRO A  10      24.906  49.810 -16.204  1.00 47.56           C  
ATOM     61  CD  PRO A  10      25.140  48.949 -17.420  1.00 47.97           C  
ATOM     62  N   SER A  11      25.325  45.791 -13.925  1.00 40.60           N  
ATOM     63  CA  SER A  11      24.824  44.496 -13.521  1.00 39.59           C  
ATOM     64  C   SER A  11      23.421  44.599 -12.904  1.00 37.91           C  
ATOM     65  O   SER A  11      23.051  45.642 -12.369  1.00 37.60           O  
ATOM     66  CB  SER A  11      25.813  43.889 -12.520  1.00 40.51           C  
ATOM     67  OG  SER A  11      25.206  42.890 -11.715  1.00 44.49           O  
ATOM     68  N   MET A  12      22.637  43.526 -13.004  1.00 37.01           N  
ATOM     69  CA  MET A  12      21.307  43.484 -12.388  1.00 37.01           C  
ATOM     70  C   MET A  12      21.556  43.168 -10.906  1.00 36.54           C  
ATOM     71  O   MET A  12      22.593  42.593 -10.552  1.00 35.96           O  
ATOM     72  CB  MET A  12      20.443  42.366 -12.994  1.00 36.93           C  
ATOM     73  CG  MET A  12      19.980  42.581 -14.421  1.00 38.13           C  
ATOM     74  SD  MET A  12      18.693  43.860 -14.598  1.00 46.20           S  
ATOM     75  CE  MET A  12      17.152  42.847 -14.633  1.00 38.96           C  
ATOM     76  N   TYR A  13      20.621  43.540 -10.038  1.00 36.11           N  
ATOM     77  CA  TYR A  13      20.779  43.265  -8.612  1.00 34.92           C  
ATOM     78  C   TYR A  13      19.589  42.580  -7.980  1.00 35.36           C  
ATOM     79  O   TYR A  13      18.458  42.717  -8.441  1.00 35.41           O  
ATOM     80  CB  TYR A  13      21.050  44.545  -7.827  1.00 34.03           C  
ATOM     81  CG  TYR A  13      22.455  45.048  -7.961  1.00 35.47           C  
ATOM     82  CD1 TYR A  13      22.925  45.531  -9.178  1.00 36.95           C  
ATOM     83  CD2 TYR A  13      23.329  45.029  -6.875  1.00 35.92           C  
ATOM     84  CE1 TYR A  13      24.226  45.979  -9.317  1.00 37.56           C  
ATOM     85  CE2 TYR A  13      24.637  45.479  -7.003  1.00 36.05           C  
ATOM     86  CZ  TYR A  13      25.077  45.951  -8.229  1.00 37.29           C  
ATOM     87  OH  TYR A  13      26.369  46.386  -8.385  1.00 41.96           O  
ATOM     88  N   LYS A  14      19.869  41.839  -6.913  1.00 36.26           N  
ATOM     89  CA  LYS A  14      18.842  41.149  -6.148  1.00 36.84           C  
ATOM     90  C   LYS A  14      18.513  42.066  -4.974  1.00 35.14           C  
ATOM     91  O   LYS A  14      19.400  42.714  -4.423  1.00 33.53           O  
ATOM     92  CB  LYS A  14      19.365  39.821  -5.592  1.00 38.27           C  
ATOM     93  CG  LYS A  14      19.770  38.793  -6.615  1.00 41.88           C  
ATOM     94  CD  LYS A  14      20.510  37.651  -5.940  1.00 45.48           C  
ATOM     95  CE  LYS A  14      20.982  36.612  -6.948  1.00 47.84           C  
ATOM     96  NZ  LYS A  14      21.889  35.598  -6.326  1.00 48.06           N  
ATOM     97  N   VAL A  15      17.236  42.126  -4.621  1.00 34.47           N  
ATOM     98  CA  VAL A  15      16.770  42.917  -3.494  1.00 34.61           C  
ATOM     99  C   VAL A  15      16.400  41.861  -2.458  1.00 35.42           C  
ATOM    100  O   VAL A  15      15.648  40.933  -2.744  1.00 33.47           O  
ATOM    101  CB  VAL A  15      15.540  43.753  -3.873  1.00 35.45           C  
ATOM    102  CG1 VAL A  15      14.983  44.454  -2.652  1.00 35.73           C  
ATOM    103  CG2 VAL A  15      15.929  44.768  -4.932  1.00 35.45           C  
ATOM    104  N   ILE A  16      16.936  42.008  -1.254  1.00 36.47           N  
ATOM    105  CA  ILE A  16      16.718  41.025  -0.211  1.00 35.92           C  
ATOM    106  C   ILE A  16      16.141  41.557   1.098  1.00 37.56           C  
ATOM    107  O   ILE A  16      16.454  42.672   1.525  1.00 38.33           O  
ATOM    108  CB  ILE A  16      18.069  40.309   0.074  1.00 35.26           C  
ATOM    109  CG1 ILE A  16      18.551  39.613  -1.209  1.00 33.65           C  
ATOM    110  CG2 ILE A  16      17.933  39.344   1.241  1.00 32.60           C  
ATOM    111  CD1 ILE A  16      19.939  39.029  -1.127  1.00 32.66           C  
ATOM    112  N   LEU A  17      15.279  40.753   1.716  1.00 37.67           N  
ATOM    113  CA  LEU A  17      14.701  41.091   3.012  1.00 37.91           C  
ATOM    114  C   LEU A  17      15.338  40.155   4.022  1.00 38.10           C  
ATOM    115  O   LEU A  17      15.241  38.936   3.901  1.00 38.42           O  
ATOM    116  CB  LEU A  17      13.182  40.913   3.025  1.00 37.09           C  
ATOM    117  CG  LEU A  17      12.389  41.965   2.241  1.00 36.48           C  
ATOM    118  CD1 LEU A  17      10.906  41.768   2.505  1.00 33.33           C  
ATOM    119  CD2 LEU A  17      12.827  43.370   2.645  1.00 32.91           C  
ATOM    120  N   VAL A  18      16.019  40.737   4.999  1.00 39.14           N  
ATOM    121  CA  VAL A  18      16.685  39.976   6.043  1.00 40.03           C  
ATOM    122  C   VAL A  18      15.712  39.707   7.177  1.00 40.79           C  
ATOM    123  O   VAL A  18      14.766  40.466   7.391  1.00 40.33           O  
ATOM    124  CB  VAL A  18      17.889  40.751   6.605  1.00 40.10           C  
ATOM    125  CG1 VAL A  18      18.551  39.968   7.712  1.00 39.07           C  
ATOM    126  CG2 VAL A  18      18.874  41.025   5.501  1.00 41.62           C  
ATOM    127  N   ASN A  19      15.943  38.623   7.905  1.00 41.39           N  
ATOM    128  CA  ASN A  19      15.079  38.274   9.022  1.00 40.18           C  
ATOM    129  C   ASN A  19      15.582  38.897  10.321  1.00 40.13           C  
ATOM    130  O   ASN A  19      16.748  39.268  10.441  1.00 40.01           O  
ATOM    131  CB  ASN A  19      15.027  36.758   9.187  1.00 39.91           C  
ATOM    132  CG  ASN A  19      13.934  36.314  10.140  1.00 41.53           C  
ATOM    133  OD1 ASN A  19      14.107  35.361  10.897  1.00 41.28           O  
ATOM    134  ND2 ASN A  19      12.793  37.000  10.095  1.00 42.06           N  
ATOM    135  N   ASP A  20      14.682  39.010  11.288  1.00 41.23           N  
ATOM    136  CA  ASP A  20      15.000  39.539  12.607  1.00 43.32           C  
ATOM    137  C   ASP A  20      13.896  39.067  13.553  1.00 43.85           C  
ATOM    138  O   ASP A  20      12.873  38.530  13.110  1.00 43.25           O  
ATOM    139  CB  ASP A  20      15.058  41.074  12.597  1.00 45.54           C  
ATOM    140  CG  ASP A  20      13.690  41.714  12.428  1.00 47.82           C  
ATOM    141  OD1 ASP A  20      13.197  41.813  11.284  1.00 50.30           O  
ATOM    142  OD2 ASP A  20      13.099  42.110  13.448  1.00 48.54           O  
ATOM    143  N   ASP A  21      14.090  39.272  14.851  1.00 44.39           N  
ATOM    144  CA  ASP A  21      13.098  38.841  15.828  1.00 45.50           C  
ATOM    145  C   ASP A  21      12.125  39.912  16.303  1.00 45.20           C  
ATOM    146  O   ASP A  21      11.136  39.592  16.960  1.00 44.83           O  
ATOM    147  CB  ASP A  21      13.790  38.234  17.046  1.00 47.17           C  
ATOM    148  CG  ASP A  21      14.513  36.951  16.724  1.00 48.27           C  
ATOM    149  OD1 ASP A  21      13.881  36.050  16.130  1.00 48.93           O  
ATOM    150  OD2 ASP A  21      15.707  36.842  17.072  1.00 49.79           O  
ATOM    151  N   TYR A  22      12.391  41.172  15.982  1.00 44.97           N  
ATOM    152  CA  TYR A  22      11.505  42.241  16.424  1.00 45.28           C  
ATOM    153  C   TYR A  22      10.444  42.697  15.436  1.00 46.68           C  
ATOM    154  O   TYR A  22       9.405  43.211  15.838  1.00 48.12           O  
ATOM    155  CB  TYR A  22      12.324  43.436  16.891  1.00 43.15           C  
ATOM    156  CG  TYR A  22      12.999  43.194  18.219  1.00 43.08           C  
ATOM    157  CD1 TYR A  22      14.289  42.675  18.289  1.00 40.76           C  
ATOM    158  CD2 TYR A  22      12.340  43.483  19.410  1.00 41.27           C  
ATOM    159  CE1 TYR A  22      14.911  42.458  19.516  1.00 40.70           C  
ATOM    160  CE2 TYR A  22      12.944  43.267  20.639  1.00 40.90           C  
ATOM    161  CZ  TYR A  22      14.233  42.756  20.695  1.00 41.90           C  
ATOM    162  OH  TYR A  22      14.834  42.551  21.932  1.00 39.20           O  
ATOM    163  N   THR A  23      10.686  42.509  14.146  1.00 48.32           N  
ATOM    164  CA  THR A  23       9.707  42.922  13.152  1.00 49.20           C  
ATOM    165  C   THR A  23       8.568  41.916  13.130  1.00 51.24           C  
ATOM    166  O   THR A  23       8.795  40.717  12.990  1.00 52.84           O  
ATOM    167  CB  THR A  23      10.318  42.986  11.729  1.00 47.71           C  
ATOM    168  OG1 THR A  23      11.449  43.864  11.722  1.00 46.27           O  
ATOM    169  CG2 THR A  23       9.290  43.498  10.740  1.00 46.14           C  
ATOM    170  N   PRO A  24       7.326  42.382  13.296  1.00 53.09           N  
ATOM    171  CA  PRO A  24       6.209  41.429  13.267  1.00 54.80           C  
ATOM    172  C   PRO A  24       5.958  40.884  11.859  1.00 56.55           C  
ATOM    173  O   PRO A  24       6.075  41.607  10.868  1.00 56.66           O  
ATOM    174  CB  PRO A  24       5.032  42.242  13.809  1.00 54.54           C  
ATOM    175  CG  PRO A  24       5.412  43.668  13.502  1.00 55.42           C  
ATOM    176  CD  PRO A  24       6.893  43.699  13.791  1.00 53.74           C  
ATOM    177  N   MET A  25       5.616  39.601  11.784  1.00 58.77           N  
ATOM    178  CA  MET A  25       5.359  38.932  10.510  1.00 59.73           C  
ATOM    179  C   MET A  25       4.416  39.699   9.585  1.00 59.13           C  
ATOM    180  O   MET A  25       4.664  39.792   8.383  1.00 59.39           O  
ATOM    181  CB  MET A  25       4.807  37.519  10.759  1.00 60.70           C  
ATOM    182  CG  MET A  25       5.841  36.527  11.300  1.00 62.37           C  
ATOM    183  SD  MET A  25       7.054  35.942  10.073  1.00 63.81           S  
ATOM    184  CE  MET A  25       6.769  34.175  10.172  1.00 64.15           C  
ATOM    185  N   GLU A  26       3.343  40.253  10.138  1.00 58.56           N  
ATOM    186  CA  GLU A  26       2.371  40.993   9.337  1.00 58.17           C  
ATOM    187  C   GLU A  26       2.990  42.163   8.572  1.00 55.98           C  
ATOM    188  O   GLU A  26       2.647  42.406   7.410  1.00 54.33           O  
ATOM    189  CB  GLU A  26       1.229  41.499  10.221  1.00 60.64           C  
ATOM    190  CG  GLU A  26       0.552  40.397  11.026  1.00 66.16           C  
ATOM    191  CD  GLU A  26       1.186  40.183  12.400  1.00 69.36           C  
ATOM    192  OE1 GLU A  26       2.434  40.217  12.505  1.00 71.03           O  
ATOM    193  OE2 GLU A  26       0.430  39.972  13.376  1.00 71.06           O  
ATOM    194  N   PHE A  27       3.906  42.878   9.217  1.00 53.37           N  
ATOM    195  CA  PHE A  27       4.547  44.015   8.572  1.00 51.24           C  
ATOM    196  C   PHE A  27       5.378  43.602   7.351  1.00 50.87           C  
ATOM    197  O   PHE A  27       5.379  44.308   6.339  1.00 51.67           O  
ATOM    198  CB  PHE A  27       5.423  44.778   9.570  1.00 49.34           C  
ATOM    199  CG  PHE A  27       6.017  46.044   9.012  1.00 47.45           C  
ATOM    200  CD1 PHE A  27       5.217  47.156   8.766  1.00 44.53           C  
ATOM    201  CD2 PHE A  27       7.383  46.119   8.710  1.00 48.14           C  
ATOM    202  CE1 PHE A  27       5.766  48.326   8.226  1.00 44.77           C  
ATOM    203  CE2 PHE A  27       7.946  47.286   8.166  1.00 45.76           C  
ATOM    204  CZ  PHE A  27       7.133  48.390   7.925  1.00 45.32           C  
ATOM    205  N   VAL A  28       6.080  42.469   7.423  1.00 49.07           N  
ATOM    206  CA  VAL A  28       6.873  42.053   6.268  1.00 48.30           C  
ATOM    207  C   VAL A  28       5.942  41.699   5.107  1.00 49.31           C  
ATOM    208  O   VAL A  28       6.227  42.037   3.957  1.00 50.10           O  
ATOM    209  CB  VAL A  28       7.848  40.859   6.587  1.00 45.44           C  
ATOM    210  CG1 VAL A  28       7.903  40.606   8.063  1.00 46.58           C  
ATOM    211  CG2 VAL A  28       7.445  39.620   5.843  1.00 46.23           C  
ATOM    212  N   ILE A  29       4.826  41.035   5.401  1.00 49.54           N  
ATOM    213  CA  ILE A  29       3.866  40.685   4.356  1.00 50.07           C  
ATOM    214  C   ILE A  29       3.397  41.985   3.707  1.00 50.49           C  
ATOM    215  O   ILE A  29       3.207  42.057   2.488  1.00 50.51           O  
ATOM    216  CB  ILE A  29       2.647  39.927   4.941  1.00 50.87           C  
ATOM    217  CG1 ILE A  29       3.055  38.491   5.283  1.00 52.08           C  
ATOM    218  CG2 ILE A  29       1.489  39.931   3.950  1.00 49.78           C  
ATOM    219  CD1 ILE A  29       1.978  37.686   5.984  1.00 51.50           C  
ATOM    220  N   ASP A  30       3.225  43.011   4.539  1.00 49.72           N  
ATOM    221  CA  ASP A  30       2.798  44.333   4.097  1.00 48.99           C  
ATOM    222  C   ASP A  30       3.841  44.927   3.142  1.00 48.71           C  
ATOM    223  O   ASP A  30       3.508  45.414   2.053  1.00 48.31           O  
ATOM    224  CB  ASP A  30       2.621  45.243   5.322  1.00 50.33           C  
ATOM    225  CG  ASP A  30       2.306  46.691   4.955  1.00 53.09           C  
ATOM    226  OD1 ASP A  30       2.385  47.551   5.861  1.00 54.48           O  
ATOM    227  OD2 ASP A  30       1.978  46.979   3.780  1.00 52.65           O  
ATOM    228  N   VAL A  31       5.104  44.885   3.549  1.00 46.03           N  
ATOM    229  CA  VAL A  31       6.168  45.426   2.721  1.00 43.61           C  
ATOM    230  C   VAL A  31       6.246  44.726   1.371  1.00 44.24           C  
ATOM    231  O   VAL A  31       6.414  45.382   0.348  1.00 43.96           O  
ATOM    232  CB  VAL A  31       7.535  45.323   3.436  1.00 43.11           C  
ATOM    233  CG1 VAL A  31       8.672  45.547   2.451  1.00 38.53           C  
ATOM    234  CG2 VAL A  31       7.601  46.348   4.549  1.00 41.11           C  
ATOM    235  N   LEU A  32       6.123  43.398   1.372  1.00 44.44           N  
ATOM    236  CA  LEU A  32       6.186  42.620   0.137  1.00 45.16           C  
ATOM    237  C   LEU A  32       5.071  43.008  -0.824  1.00 46.88           C  
ATOM    238  O   LEU A  32       5.241  42.971  -2.044  1.00 46.15           O  
ATOM    239  CB  LEU A  32       6.083  41.120   0.431  1.00 43.96           C  
ATOM    240  CG  LEU A  32       7.317  40.227   0.595  1.00 44.01           C  
ATOM    241  CD1 LEU A  32       8.586  40.972   0.222  1.00 42.76           C  
ATOM    242  CD2 LEU A  32       7.377  39.734   2.026  1.00 44.97           C  
ATOM    243  N   GLN A  33       3.923  43.374  -0.268  1.00 48.69           N  
ATOM    244  CA  GLN A  33       2.788  43.758  -1.091  1.00 50.73           C  
ATOM    245  C   GLN A  33       2.901  45.185  -1.595  1.00 50.53           C  
ATOM    246  O   GLN A  33       2.664  45.454  -2.775  1.00 51.06           O  
ATOM    247  CB  GLN A  33       1.484  43.582  -0.308  1.00 52.66           C  
ATOM    248  CG  GLN A  33       1.127  42.123  -0.060  1.00 56.60           C  
ATOM    249  CD  GLN A  33      -0.252  41.946   0.544  1.00 58.45           C  
ATOM    250  OE1 GLN A  33      -0.516  42.381   1.669  1.00 59.39           O  
ATOM    251  NE2 GLN A  33      -1.141  41.302  -0.202  1.00 58.90           N  
ATOM    252  N   LYS A  34       3.282  46.092  -0.701  1.00 49.81           N  
ATOM    253  CA  LYS A  34       3.412  47.500  -1.044  1.00 49.79           C  
ATOM    254  C   LYS A  34       4.583  47.847  -1.951  1.00 48.67           C  
ATOM    255  O   LYS A  34       4.441  48.677  -2.845  1.00 49.83           O  
ATOM    256  CB  LYS A  34       3.498  48.347   0.231  1.00 52.07           C  
ATOM    257  CG  LYS A  34       3.772  49.825  -0.024  1.00 55.32           C  
ATOM    258  CD  LYS A  34       3.504  50.687   1.208  1.00 58.32           C  
ATOM    259  CE  LYS A  34       2.034  50.623   1.629  1.00 59.98           C  
ATOM    260  NZ  LYS A  34       1.724  51.501   2.798  1.00 61.03           N  
ATOM    261  N   PHE A  35       5.736  47.221  -1.737  1.00 47.28           N  
ATOM    262  CA  PHE A  35       6.905  47.538  -2.547  1.00 46.49           C  
ATOM    263  C   PHE A  35       7.301  46.514  -3.598  1.00 46.95           C  
ATOM    264  O   PHE A  35       8.309  46.686  -4.282  1.00 47.64           O  
ATOM    265  CB  PHE A  35       8.111  47.829  -1.648  1.00 45.43           C  
ATOM    266  CG  PHE A  35       7.873  48.937  -0.660  1.00 44.73           C  
ATOM    267  CD1 PHE A  35       7.352  48.662   0.600  1.00 44.16           C  
ATOM    268  CD2 PHE A  35       8.133  50.259  -1.003  1.00 43.52           C  
ATOM    269  CE1 PHE A  35       7.090  49.689   1.507  1.00 43.17           C  
ATOM    270  CE2 PHE A  35       7.875  51.290  -0.107  1.00 43.50           C  
ATOM    271  CZ  PHE A  35       7.352  51.003   1.152  1.00 43.97           C  
ATOM    272  N   PHE A  36       6.523  45.448  -3.739  1.00 47.86           N  
ATOM    273  CA  PHE A  36       6.847  44.454  -4.749  1.00 48.42           C  
ATOM    274  C   PHE A  36       5.628  43.951  -5.512  1.00 50.67           C  
ATOM    275  O   PHE A  36       5.737  43.035  -6.323  1.00 50.55           O  
ATOM    276  CB  PHE A  36       7.608  43.292  -4.115  1.00 45.26           C  
ATOM    277  CG  PHE A  36       8.904  43.703  -3.486  1.00 40.80           C  
ATOM    278  CD1 PHE A  36       8.942  44.156  -2.179  1.00 40.49           C  
ATOM    279  CD2 PHE A  36      10.078  43.690  -4.221  1.00 40.31           C  
ATOM    280  CE1 PHE A  36      10.136  44.598  -1.612  1.00 41.19           C  
ATOM    281  CE2 PHE A  36      11.276  44.129  -3.670  1.00 40.22           C  
ATOM    282  CZ  PHE A  36      11.306  44.586  -2.360  1.00 41.19           C  
ATOM    283  N   SER A  37       4.477  44.576  -5.262  1.00 53.82           N  
ATOM    284  CA  SER A  37       3.221  44.214  -5.920  1.00 56.81           C  
ATOM    285  C   SER A  37       3.008  42.714  -5.911  1.00 59.15           C  
ATOM    286  O   SER A  37       2.644  42.124  -6.925  1.00 59.96           O  
ATOM    287  CB  SER A  37       3.209  44.715  -7.365  1.00 56.63           C  
ATOM    288  OG  SER A  37       3.041  46.123  -7.415  1.00 58.37           O  
ATOM    289  N   TYR A  38       3.239  42.105  -4.754  1.00 61.25           N  
ATOM    290  CA  TYR A  38       3.088  40.672  -4.596  1.00 63.14           C  
ATOM    291  C   TYR A  38       1.694  40.252  -4.174  1.00 65.83           C  
ATOM    292  O   TYR A  38       1.034  40.921  -3.379  1.00 65.45           O  
ATOM    293  CB  TYR A  38       4.108  40.151  -3.586  1.00 62.03           C  
ATOM    294  CG  TYR A  38       5.418  39.740  -4.210  1.00 61.15           C  
ATOM    295  CD1 TYR A  38       6.616  39.892  -3.524  1.00 60.63           C  
ATOM    296  CD2 TYR A  38       5.458  39.180  -5.485  1.00 61.62           C  
ATOM    297  CE1 TYR A  38       7.821  39.501  -4.089  1.00 60.80           C  
ATOM    298  CE2 TYR A  38       6.659  38.783  -6.061  1.00 61.40           C  
ATOM    299  CZ  TYR A  38       7.838  38.948  -5.356  1.00 61.56           C  
ATOM    300  OH  TYR A  38       9.034  38.560  -5.919  1.00 61.73           O  
ATOM    301  N   ASP A  39       1.258  39.129  -4.732  1.00 69.38           N  
ATOM    302  CA  ASP A  39      -0.040  38.554  -4.431  1.00 72.28           C  
ATOM    303  C   ASP A  39      -0.096  38.266  -2.929  1.00 74.44           C  
ATOM    304  O   ASP A  39       0.910  37.881  -2.326  1.00 74.87           O  
ATOM    305  CB  ASP A  39      -0.208  37.257  -5.221  1.00 72.82           C  
ATOM    306  CG  ASP A  39      -1.520  36.571  -4.939  1.00 74.73           C  
ATOM    307  OD1 ASP A  39      -1.776  36.225  -3.767  1.00 75.74           O  
ATOM    308  OD2 ASP A  39      -2.297  36.375  -5.895  1.00 76.43           O  
ATOM    309  N   VAL A  40      -1.264  38.455  -2.326  1.00 76.02           N  
ATOM    310  CA  VAL A  40      -1.417  38.203  -0.897  1.00 77.11           C  
ATOM    311  C   VAL A  40      -0.860  36.828  -0.556  1.00 77.64           C  
ATOM    312  O   VAL A  40      -0.023  36.690   0.331  1.00 77.62           O  
ATOM    313  CB  VAL A  40      -2.897  38.231  -0.468  1.00 77.81           C  
ATOM    314  CG1 VAL A  40      -2.988  38.211   1.052  1.00 77.03           C  
ATOM    315  CG2 VAL A  40      -3.593  39.457  -1.051  1.00 77.86           C  
ATOM    316  N   GLU A  41      -1.334  35.816  -1.274  1.00 78.50           N  
ATOM    317  CA  GLU A  41      -0.902  34.443  -1.052  1.00 79.83           C  
ATOM    318  C   GLU A  41       0.398  34.118  -1.779  1.00 78.78           C  
ATOM    319  O   GLU A  41       0.618  32.991  -2.219  1.00 79.08           O  
ATOM    320  CB  GLU A  41      -2.011  33.472  -1.480  1.00 82.54           C  
ATOM    321  CG  GLU A  41      -3.270  33.560  -0.609  1.00 85.64           C  
ATOM    322  CD  GLU A  41      -4.371  32.601  -1.043  1.00 86.98           C  
ATOM    323  OE1 GLU A  41      -4.111  31.379  -1.106  1.00 88.26           O  
ATOM    324  OE2 GLU A  41      -5.499  33.070  -1.315  1.00 87.22           O  
ATOM    325  N   ARG A  42       1.257  35.123  -1.893  1.00 77.79           N  
ATOM    326  CA  ARG A  42       2.554  34.983  -2.545  1.00 76.67           C  
ATOM    327  C   ARG A  42       3.549  35.714  -1.663  1.00 74.91           C  
ATOM    328  O   ARG A  42       4.695  35.292  -1.496  1.00 73.69           O  
ATOM    329  CB  ARG A  42       2.522  35.627  -3.927  1.00 78.24           C  
ATOM    330  CG  ARG A  42       3.793  35.448  -4.730  1.00 80.57           C  
ATOM    331  CD  ARG A  42       3.471  34.766  -6.041  1.00 83.48           C  
ATOM    332  NE  ARG A  42       2.252  35.323  -6.623  1.00 86.32           N  
ATOM    333  CZ  ARG A  42       1.723  34.934  -7.778  1.00 86.94           C  
ATOM    334  NH1 ARG A  42       2.307  33.978  -8.490  1.00 86.88           N  
ATOM    335  NH2 ARG A  42       0.603  35.496  -8.216  1.00 87.75           N  
ATOM    336  N   ALA A  43       3.087  36.829  -1.107  1.00 73.39           N  
ATOM    337  CA  ALA A  43       3.887  37.643  -0.204  1.00 71.39           C  
ATOM    338  C   ALA A  43       3.960  36.864   1.099  1.00 69.59           C  
ATOM    339  O   ALA A  43       5.017  36.740   1.718  1.00 68.26           O  
ATOM    340  CB  ALA A  43       3.208  38.988   0.026  1.00 71.28           C  
ATOM    341  N   THR A  44       2.810  36.334   1.499  1.00 68.90           N  
ATOM    342  CA  THR A  44       2.699  35.554   2.717  1.00 68.26           C  
ATOM    343  C   THR A  44       3.619  34.334   2.664  1.00 67.37           C  
ATOM    344  O   THR A  44       4.234  33.970   3.667  1.00 66.61           O  
ATOM    345  CB  THR A  44       1.242  35.101   2.942  1.00 67.87           C  
ATOM    346  OG1 THR A  44       1.179  34.226   4.074  1.00 67.89           O  
ATOM    347  CG2 THR A  44       0.717  34.377   1.720  1.00 68.40           C  
ATOM    348  N   GLN A  45       3.730  33.711   1.494  1.00 66.56           N  
ATOM    349  CA  GLN A  45       4.589  32.541   1.358  1.00 66.11           C  
ATOM    350  C   GLN A  45       6.052  32.964   1.338  1.00 63.47           C  
ATOM    351  O   GLN A  45       6.942  32.199   1.701  1.00 62.47           O  
ATOM    352  CB  GLN A  45       4.265  31.778   0.073  1.00 69.13           C  
ATOM    353  CG  GLN A  45       4.736  32.466  -1.193  1.00 73.87           C  
ATOM    354  CD  GLN A  45       4.667  31.556  -2.412  1.00 77.23           C  
ATOM    355  OE1 GLN A  45       5.276  30.477  -2.433  1.00 77.94           O  
ATOM    356  NE2 GLN A  45       3.925  31.986  -3.433  1.00 77.27           N  
ATOM    357  N   LEU A  46       6.284  34.198   0.909  1.00 61.45           N  
ATOM    358  CA  LEU A  46       7.627  34.745   0.824  1.00 58.85           C  
ATOM    359  C   LEU A  46       8.134  35.215   2.195  1.00 57.37           C  
ATOM    360  O   LEU A  46       9.343  35.251   2.440  1.00 55.74           O  
ATOM    361  CB  LEU A  46       7.634  35.891  -0.182  1.00 59.21           C  
ATOM    362  CG  LEU A  46       8.970  36.320  -0.777  1.00 59.28           C  
ATOM    363  CD1 LEU A  46       9.709  35.126  -1.361  1.00 58.75           C  
ATOM    364  CD2 LEU A  46       8.699  37.353  -1.853  1.00 60.50           C  
ATOM    365  N   MET A  47       7.212  35.573   3.088  1.00 55.31           N  
ATOM    366  CA  MET A  47       7.610  35.999   4.424  1.00 54.83           C  
ATOM    367  C   MET A  47       8.122  34.740   5.121  1.00 53.90           C  
ATOM    368  O   MET A  47       9.120  34.774   5.847  1.00 53.23           O  
ATOM    369  CB  MET A  47       6.422  36.613   5.192  1.00 54.73           C  
ATOM    370  CG  MET A  47       5.442  35.618   5.813  1.00 57.68           C  
ATOM    371  SD  MET A  47       5.818  35.159   7.531  1.00 56.76           S  
ATOM    372  CE  MET A  47       4.265  35.543   8.344  1.00 58.04           C  
ATOM    373  N   LEU A  48       7.444  33.621   4.870  1.00 51.83           N  
ATOM    374  CA  LEU A  48       7.837  32.346   5.453  1.00 50.54           C  
ATOM    375  C   LEU A  48       9.241  32.010   4.980  1.00 49.76           C  
ATOM    376  O   LEU A  48      10.047  31.463   5.735  1.00 48.66           O  
ATOM    377  CB  LEU A  48       6.859  31.244   5.037  1.00 50.07           C  
ATOM    378  CG  LEU A  48       5.467  31.449   5.652  1.00 50.61           C  
ATOM    379  CD1 LEU A  48       4.449  30.433   5.120  1.00 47.16           C  
ATOM    380  CD2 LEU A  48       5.611  31.370   7.172  1.00 48.82           C  
ATOM    381  N   ALA A  49       9.530  32.351   3.726  1.00 48.27           N  
ATOM    382  CA  ALA A  49      10.850  32.105   3.159  1.00 47.44           C  
ATOM    383  C   ALA A  49      11.912  32.873   3.952  1.00 47.36           C  
ATOM    384  O   ALA A  49      12.975  32.336   4.267  1.00 46.27           O  
ATOM    385  CB  ALA A  49      10.874  32.537   1.707  1.00 47.89           C  
ATOM    386  N   VAL A  50      11.615  34.130   4.275  1.00 46.12           N  
ATOM    387  CA  VAL A  50      12.548  34.960   5.029  1.00 45.99           C  
ATOM    388  C   VAL A  50      12.763  34.430   6.445  1.00 46.41           C  
ATOM    389  O   VAL A  50      13.896  34.346   6.921  1.00 45.75           O  
ATOM    390  CB  VAL A  50      12.048  36.423   5.126  1.00 45.75           C  
ATOM    391  CG1 VAL A  50      13.030  37.263   5.936  1.00 41.76           C  
ATOM    392  CG2 VAL A  50      11.865  37.003   3.734  1.00 44.31           C  
ATOM    393  N   ALA A  51      11.674  34.070   7.119  1.00 46.76           N  
ATOM    394  CA  ALA A  51      11.765  33.561   8.484  1.00 46.85           C  
ATOM    395  C   ALA A  51      12.518  32.237   8.541  1.00 47.75           C  
ATOM    396  O   ALA A  51      13.432  32.053   9.352  1.00 46.71           O  
ATOM    397  CB  ALA A  51      10.370  33.395   9.070  1.00 45.20           C  
ATOM    398  N   TYR A  52      12.136  31.324   7.657  1.00 49.28           N  
ATOM    399  CA  TYR A  52      12.741  29.998   7.599  1.00 50.62           C  
ATOM    400  C   TYR A  52      14.225  30.029   7.267  1.00 49.85           C  
ATOM    401  O   TYR A  52      15.043  29.458   7.990  1.00 49.46           O  
ATOM    402  CB  TYR A  52      12.006  29.143   6.559  1.00 53.35           C  
ATOM    403  CG  TYR A  52      12.187  27.655   6.734  1.00 56.17           C  
ATOM    404  CD1 TYR A  52      11.489  26.959   7.725  1.00 57.42           C  
ATOM    405  CD2 TYR A  52      13.075  26.941   5.923  1.00 58.14           C  
ATOM    406  CE1 TYR A  52      11.672  25.583   7.909  1.00 58.33           C  
ATOM    407  CE2 TYR A  52      13.269  25.565   6.097  1.00 59.99           C  
ATOM    408  CZ  TYR A  52      12.564  24.893   7.093  1.00 59.42           C  
ATOM    409  OH  TYR A  52      12.747  23.538   7.262  1.00 59.53           O  
ATOM    410  N   GLN A  53      14.567  30.706   6.175  1.00 49.53           N  
ATOM    411  CA  GLN A  53      15.946  30.780   5.719  1.00 50.12           C  
ATOM    412  C   GLN A  53      16.774  31.923   6.277  1.00 49.55           C  
ATOM    413  O   GLN A  53      18.000  31.918   6.164  1.00 48.51           O  
ATOM    414  CB  GLN A  53      15.960  30.820   4.202  1.00 52.13           C  
ATOM    415  CG  GLN A  53      15.329  29.590   3.593  1.00 56.27           C  
ATOM    416  CD  GLN A  53      15.167  29.707   2.099  1.00 59.66           C  
ATOM    417  OE1 GLN A  53      14.332  30.470   1.610  1.00 61.83           O  
ATOM    418  NE2 GLN A  53      15.975  28.957   1.360  1.00 61.79           N  
ATOM    419  N   GLY A  54      16.106  32.899   6.880  1.00 49.56           N  
ATOM    420  CA  GLY A  54      16.814  34.024   7.464  1.00 48.93           C  
ATOM    421  C   GLY A  54      17.063  35.146   6.484  1.00 49.31           C  
ATOM    422  O   GLY A  54      17.570  36.198   6.863  1.00 50.15           O  
ATOM    423  N   LYS A  55      16.702  34.917   5.225  1.00 49.19           N  
ATOM    424  CA  LYS A  55      16.879  35.899   4.161  1.00 49.40           C  
ATOM    425  C   LYS A  55      16.190  35.367   2.906  1.00 49.31           C  
ATOM    426  O   LYS A  55      16.166  34.158   2.668  1.00 49.16           O  
ATOM    427  CB  LYS A  55      18.377  36.140   3.900  1.00 48.68           C  
ATOM    428  CG  LYS A  55      18.846  35.849   2.478  1.00 50.74           C  
ATOM    429  CD  LYS A  55      20.333  36.152   2.278  1.00 51.67           C  
ATOM    430  CE  LYS A  55      20.740  35.937   0.820  1.00 54.21           C  
ATOM    431  NZ  LYS A  55      22.095  36.476   0.495  1.00 54.47           N  
ATOM    432  N   ALA A  56      15.621  36.265   2.109  1.00 48.74           N  
ATOM    433  CA  ALA A  56      14.936  35.852   0.891  1.00 47.20           C  
ATOM    434  C   ALA A  56      14.994  36.901  -0.209  1.00 47.02           C  
ATOM    435  O   ALA A  56      14.842  38.096   0.048  1.00 47.89           O  
ATOM    436  CB  ALA A  56      13.494  35.516   1.204  1.00 46.14           C  
ATOM    437  N   ILE A  57      15.214  36.441  -1.437  1.00 46.07           N  
ATOM    438  CA  ILE A  57      15.271  37.325  -2.594  1.00 44.66           C  
ATOM    439  C   ILE A  57      13.846  37.742  -2.935  1.00 43.93           C  
ATOM    440  O   ILE A  57      12.981  36.895  -3.146  1.00 43.93           O  
ATOM    441  CB  ILE A  57      15.907  36.610  -3.807  1.00 44.13           C  
ATOM    442  CG1 ILE A  57      17.373  36.296  -3.507  1.00 42.52           C  
ATOM    443  CG2 ILE A  57      15.794  37.479  -5.051  1.00 44.22           C  
ATOM    444  CD1 ILE A  57      18.072  35.518  -4.599  1.00 41.64           C  
ATOM    445  N   CYS A  58      13.602  39.048  -2.976  1.00 43.56           N  
ATOM    446  CA  CYS A  58      12.272  39.567  -3.270  1.00 43.74           C  
ATOM    447  C   CYS A  58      12.116  40.039  -4.696  1.00 42.59           C  
ATOM    448  O   CYS A  58      11.010  40.370  -5.130  1.00 42.63           O  
ATOM    449  CB  CYS A  58      11.932  40.710  -2.323  1.00 44.37           C  
ATOM    450  SG  CYS A  58      11.775  40.149  -0.647  1.00 52.04           S  
ATOM    451  N   GLY A  59      13.225  40.078  -5.422  1.00 40.68           N  
ATOM    452  CA  GLY A  59      13.165  40.504  -6.802  1.00 37.38           C  
ATOM    453  C   GLY A  59      14.529  40.752  -7.397  1.00 36.81           C  
ATOM    454  O   GLY A  59      15.559  40.646  -6.722  1.00 35.19           O  
ATOM    455  N   VAL A  60      14.520  41.066  -8.686  1.00 35.50           N  
ATOM    456  CA  VAL A  60      15.732  41.366  -9.420  1.00 35.60           C  
ATOM    457  C   VAL A  60      15.456  42.598 -10.287  1.00 35.99           C  
ATOM    458  O   VAL A  60      14.534  42.600 -11.105  1.00 35.78           O  
ATOM    459  CB  VAL A  60      16.145  40.175 -10.300  1.00 35.72           C  
ATOM    460  CG1 VAL A  60      17.382  40.533 -11.118  1.00 33.98           C  
ATOM    461  CG2 VAL A  60      16.427  38.964  -9.418  1.00 34.52           C  
ATOM    462  N   PHE A  61      16.244  43.652 -10.091  1.00 33.79           N  
ATOM    463  CA  PHE A  61      16.054  44.876 -10.853  1.00 33.18           C  
ATOM    464  C   PHE A  61      17.389  45.405 -11.324  1.00 33.72           C  
ATOM    465  O   PHE A  61      18.437  44.813 -11.048  1.00 35.00           O  
ATOM    466  CB  PHE A  61      15.377  45.943  -9.990  1.00 32.27           C  
ATOM    467  CG  PHE A  61      14.186  45.441  -9.220  1.00 32.91           C  
ATOM    468  CD1 PHE A  61      14.353  44.766  -8.014  1.00 31.38           C  
ATOM    469  CD2 PHE A  61      12.894  45.624  -9.708  1.00 33.29           C  
ATOM    470  CE1 PHE A  61      13.259  44.282  -7.309  1.00 30.71           C  
ATOM    471  CE2 PHE A  61      11.784  45.136  -9.003  1.00 32.09           C  
ATOM    472  CZ  PHE A  61      11.971  44.467  -7.804  1.00 31.13           C  
ATOM    473  N   THR A  62      17.356  46.515 -12.051  1.00 32.45           N  
ATOM    474  CA  THR A  62      18.594  47.127 -12.516  1.00 30.66           C  
ATOM    475  C   THR A  62      19.243  47.721 -11.270  1.00 30.32           C  
ATOM    476  O   THR A  62      18.562  47.965 -10.268  1.00 30.09           O  
ATOM    477  CB  THR A  62      18.331  48.272 -13.533  1.00 29.29           C  
ATOM    478  OG1 THR A  62      17.527  49.290 -12.920  1.00 28.97           O  
ATOM    479  CG2 THR A  62      17.626  47.742 -14.767  1.00 28.46           C  
ATOM    480  N   ALA A  63      20.550  47.954 -11.324  1.00 29.10           N  
ATOM    481  CA  ALA A  63      21.245  48.531 -10.185  1.00 27.37           C  
ATOM    482  C   ALA A  63      20.566  49.830  -9.755  1.00 25.37           C  
ATOM    483  O   ALA A  63      20.425  50.094  -8.574  1.00 26.07           O  
ATOM    484  CB  ALA A  63      22.698  48.795 -10.536  1.00 26.57           C  
ATOM    485  N   GLU A  64      20.133  50.626 -10.722  1.00 25.06           N  
ATOM    486  CA  GLU A  64      19.487  51.905 -10.440  1.00 26.37           C  
ATOM    487  C   GLU A  64      18.157  51.766  -9.701  1.00 26.29           C  
ATOM    488  O   GLU A  64      17.923  52.448  -8.702  1.00 27.11           O  
ATOM    489  CB  GLU A  64      19.268  52.675 -11.748  1.00 27.10           C  
ATOM    490  CG  GLU A  64      18.873  54.132 -11.576  1.00 24.25           C  
ATOM    491  CD  GLU A  64      18.502  54.778 -12.899  1.00 25.36           C  
ATOM    492  OE1 GLU A  64      18.969  54.276 -13.940  1.00 25.23           O  
ATOM    493  OE2 GLU A  64      17.755  55.783 -12.906  1.00 23.37           O  
ATOM    494  N   VAL A  65      17.282  50.895 -10.201  1.00 26.66           N  
ATOM    495  CA  VAL A  65      15.983  50.669  -9.574  1.00 27.05           C  
ATOM    496  C   VAL A  65      16.124  49.952  -8.225  1.00 27.02           C  
ATOM    497  O   VAL A  65      15.469  50.319  -7.253  1.00 26.28           O  
ATOM    498  CB  VAL A  65      15.053  49.846 -10.505  1.00 26.11           C  
ATOM    499  CG1 VAL A  65      13.810  49.368  -9.745  1.00 21.91           C  
ATOM    500  CG2 VAL A  65      14.646  50.699 -11.675  1.00 22.99           C  
ATOM    501  N   ALA A  66      16.984  48.939  -8.171  1.00 27.23           N  
ATOM    502  CA  ALA A  66      17.204  48.188  -6.937  1.00 28.49           C  
ATOM    503  C   ALA A  66      17.621  49.129  -5.798  1.00 29.91           C  
ATOM    504  O   ALA A  66      17.101  49.046  -4.681  1.00 29.16           O  
ATOM    505  CB  ALA A  66      18.280  47.124  -7.162  1.00 27.64           C  
ATOM    506  N   GLU A  67      18.560  50.023  -6.086  1.00 29.91           N  
ATOM    507  CA  GLU A  67      19.031  50.968  -5.084  1.00 31.42           C  
ATOM    508  C   GLU A  67      17.892  51.837  -4.526  1.00 30.91           C  
ATOM    509  O   GLU A  67      17.818  52.105  -3.322  1.00 31.20           O  
ATOM    510  CB  GLU A  67      20.125  51.861  -5.680  1.00 29.88           C  
ATOM    511  CG  GLU A  67      20.430  53.066  -4.818  1.00 34.45           C  
ATOM    512  CD  GLU A  67      21.393  54.042  -5.460  1.00 37.12           C  
ATOM    513  OE1 GLU A  67      21.206  54.393  -6.650  1.00 36.96           O  
ATOM    514  OE2 GLU A  67      22.334  54.469  -4.758  1.00 40.07           O  
ATOM    515  N   THR A  68      17.002  52.275  -5.405  1.00 30.95           N  
ATOM    516  CA  THR A  68      15.890  53.120  -4.993  1.00 31.14           C  
ATOM    517  C   THR A  68      14.907  52.313  -4.159  1.00 31.14           C  
ATOM    518  O   THR A  68      14.428  52.767  -3.124  1.00 32.50           O  
ATOM    519  CB  THR A  68      15.171  53.711  -6.229  1.00 32.04           C  
ATOM    520  OG1 THR A  68      16.122  54.426  -7.033  1.00 33.61           O  
ATOM    521  CG2 THR A  68      14.056  54.649  -5.807  1.00 27.84           C  
ATOM    522  N   LYS A  69      14.621  51.104  -4.610  1.00 31.05           N  
ATOM    523  CA  LYS A  69      13.706  50.238  -3.893  1.00 30.98           C  
ATOM    524  C   LYS A  69      14.218  49.935  -2.474  1.00 28.11           C  
ATOM    525  O   LYS A  69      13.469  50.053  -1.511  1.00 27.76           O  
ATOM    526  CB  LYS A  69      13.505  48.945  -4.689  1.00 33.18           C  
ATOM    527  CG  LYS A  69      12.069  48.454  -4.684  1.00 38.36           C  
ATOM    528  CD  LYS A  69      11.586  48.151  -6.092  1.00 39.13           C  
ATOM    529  CE  LYS A  69      10.072  48.009  -6.112  1.00 40.99           C  
ATOM    530  NZ  LYS A  69       9.551  47.896  -7.510  1.00 44.16           N  
ATOM    531  N   VAL A  70      15.486  49.552  -2.350  1.00 26.98           N  
ATOM    532  CA  VAL A  70      16.080  49.249  -1.046  1.00 26.99           C  
ATOM    533  C   VAL A  70      15.893  50.429  -0.092  1.00 28.67           C  
ATOM    534  O   VAL A  70      15.549  50.254   1.077  1.00 28.65           O  
ATOM    535  CB  VAL A  70      17.606  48.935  -1.163  1.00 26.67           C  
ATOM    536  CG1 VAL A  70      18.242  48.838   0.221  1.00 24.51           C  
ATOM    537  CG2 VAL A  70      17.816  47.632  -1.913  1.00 24.10           C  
ATOM    538  N   ALA A  71      16.118  51.632  -0.609  1.00 30.74           N  
ATOM    539  CA  ALA A  71      15.977  52.852   0.175  1.00 30.06           C  
ATOM    540  C   ALA A  71      14.526  53.130   0.560  1.00 31.47           C  
ATOM    541  O   ALA A  71      14.264  53.606   1.666  1.00 32.07           O  
ATOM    542  CB  ALA A  71      16.543  54.025  -0.597  1.00 28.38           C  
ATOM    543  N   MET A  72      13.590  52.854  -0.348  1.00 32.88           N  
ATOM    544  CA  MET A  72      12.173  53.076  -0.054  1.00 34.89           C  
ATOM    545  C   MET A  72      11.736  52.118   1.054  1.00 35.54           C  
ATOM    546  O   MET A  72      11.056  52.516   2.001  1.00 34.98           O  
ATOM    547  CB  MET A  72      11.284  52.838  -1.290  1.00 37.54           C  
ATOM    548  CG  MET A  72      11.247  53.956  -2.356  1.00 39.80           C  
ATOM    549  SD  MET A  72       9.695  53.897  -3.362  1.00 45.47           S  
ATOM    550  CE  MET A  72       9.906  52.354  -4.217  1.00 43.48           C  
ATOM    551  N   VAL A  73      12.132  50.853   0.931  1.00 35.64           N  
ATOM    552  CA  VAL A  73      11.772  49.833   1.913  1.00 34.82           C  
ATOM    553  C   VAL A  73      12.339  50.121   3.299  1.00 35.15           C  
ATOM    554  O   VAL A  73      11.618  50.063   4.294  1.00 35.55           O  
ATOM    555  CB  VAL A  73      12.233  48.430   1.449  1.00 35.04           C  
ATOM    556  CG1 VAL A  73      12.130  47.436   2.589  1.00 32.82           C  
ATOM    557  CG2 VAL A  73      11.365  47.966   0.285  1.00 34.15           C  
ATOM    558  N   ASN A  74      13.627  50.436   3.365  1.00 33.52           N  
ATOM    559  CA  ASN A  74      14.250  50.729   4.639  1.00 32.90           C  
ATOM    560  C   ASN A  74      13.704  51.995   5.297  1.00 34.91           C  
ATOM    561  O   ASN A  74      13.562  52.051   6.519  1.00 33.04           O  
ATOM    562  CB  ASN A  74      15.765  50.809   4.473  1.00 30.75           C  
ATOM    563  CG  ASN A  74      16.398  49.434   4.328  1.00 31.09           C  
ATOM    564  OD1 ASN A  74      15.926  48.465   4.912  1.00 29.30           O  
ATOM    565  ND2 ASN A  74      17.475  49.348   3.562  1.00 31.78           N  
ATOM    566  N   LYS A  75      13.394  53.009   4.495  1.00 36.79           N  
ATOM    567  CA  LYS A  75      12.850  54.245   5.039  1.00 38.98           C  
ATOM    568  C   LYS A  75      11.492  53.947   5.663  1.00 39.36           C  
ATOM    569  O   LYS A  75      11.161  54.438   6.744  1.00 40.79           O  
ATOM    570  CB  LYS A  75      12.690  55.301   3.939  1.00 42.38           C  
ATOM    571  CG  LYS A  75      11.914  56.538   4.394  1.00 47.68           C  
ATOM    572  CD  LYS A  75      11.768  57.604   3.302  1.00 53.04           C  
ATOM    573  CE  LYS A  75      13.073  58.389   3.053  1.00 58.40           C  
ATOM    574  NZ  LYS A  75      14.163  57.625   2.342  1.00 60.51           N  
ATOM    575  N   TYR A  76      10.713  53.128   4.971  1.00 38.55           N  
ATOM    576  CA  TYR A  76       9.391  52.742   5.429  1.00 38.55           C  
ATOM    577  C   TYR A  76       9.472  51.970   6.744  1.00 39.62           C  
ATOM    578  O   TYR A  76       8.749  52.265   7.690  1.00 40.39           O  
ATOM    579  CB  TYR A  76       8.726  51.882   4.367  1.00 38.07           C  
ATOM    580  CG  TYR A  76       7.306  51.503   4.686  1.00 39.08           C  
ATOM    581  CD1 TYR A  76       6.307  52.476   4.791  1.00 38.62           C  
ATOM    582  CD2 TYR A  76       6.947  50.169   4.840  1.00 38.80           C  
ATOM    583  CE1 TYR A  76       4.985  52.122   5.036  1.00 37.30           C  
ATOM    584  CE2 TYR A  76       5.631  49.806   5.084  1.00 39.35           C  
ATOM    585  CZ  TYR A  76       4.660  50.785   5.179  1.00 38.45           C  
ATOM    586  OH  TYR A  76       3.366  50.406   5.403  1.00 41.29           O  
ATOM    587  N   ALA A  77      10.354  50.976   6.792  1.00 40.21           N  
ATOM    588  CA  ALA A  77      10.542  50.164   7.993  1.00 40.39           C  
ATOM    589  C   ALA A  77      10.877  51.068   9.164  1.00 40.48           C  
ATOM    590  O   ALA A  77      10.331  50.928  10.253  1.00 41.36           O  
ATOM    591  CB  ALA A  77      11.680  49.159   7.781  1.00 39.16           C  
ATOM    592  N   ARG A  78      11.782  51.999   8.912  1.00 41.18           N  
ATOM    593  CA  ARG A  78      12.248  52.947   9.903  1.00 43.10           C  
ATOM    594  C   ARG A  78      11.110  53.805  10.446  1.00 44.94           C  
ATOM    595  O   ARG A  78      10.977  53.996  11.656  1.00 45.17           O  
ATOM    596  CB  ARG A  78      13.324  53.819   9.259  1.00 44.71           C  
ATOM    597  CG  ARG A  78      14.054  54.746  10.189  1.00 48.10           C  
ATOM    598  CD  ARG A  78      15.376  55.187   9.569  1.00 51.31           C  
ATOM    599  NE  ARG A  78      15.207  55.939   8.324  1.00 55.06           N  
ATOM    600  CZ  ARG A  78      15.643  55.537   7.129  1.00 55.81           C  
ATOM    601  NH1 ARG A  78      16.278  54.376   6.998  1.00 53.81           N  
ATOM    602  NH2 ARG A  78      15.456  56.310   6.062  1.00 54.92           N  
ATOM    603  N   GLU A  79      10.278  54.311   9.547  1.00 45.94           N  
ATOM    604  CA  GLU A  79       9.167  55.155   9.955  1.00 45.94           C  
ATOM    605  C   GLU A  79       8.153  54.377  10.767  1.00 45.64           C  
ATOM    606  O   GLU A  79       7.446  54.946  11.592  1.00 47.12           O  
ATOM    607  CB  GLU A  79       8.500  55.776   8.728  1.00 47.31           C  
ATOM    608  CG  GLU A  79       9.472  56.570   7.873  1.00 49.28           C  
ATOM    609  CD  GLU A  79       8.807  57.238   6.693  1.00 51.02           C  
ATOM    610  OE1 GLU A  79       8.006  56.568   6.000  1.00 52.56           O  
ATOM    611  OE2 GLU A  79       9.096  58.429   6.455  1.00 51.04           O  
ATOM    612  N   ASN A  80       8.077  53.074  10.540  1.00 44.64           N  
ATOM    613  CA  ASN A  80       7.142  52.254  11.281  1.00 44.81           C  
ATOM    614  C   ASN A  80       7.820  51.671  12.520  1.00 46.18           C  
ATOM    615  O   ASN A  80       7.205  50.954  13.316  1.00 45.68           O  
ATOM    616  CB  ASN A  80       6.585  51.165  10.374  1.00 44.40           C  
ATOM    617  CG  ASN A  80       5.560  51.707   9.397  1.00 45.15           C  
ATOM    618  OD1 ASN A  80       4.472  52.106   9.796  1.00 44.25           O  
ATOM    619  ND2 ASN A  80       5.907  51.734   8.116  1.00 45.32           N  
ATOM    620  N   GLU A  81       9.099  52.005  12.676  1.00 46.15           N  
ATOM    621  CA  GLU A  81       9.891  51.574  13.821  1.00 46.34           C  
ATOM    622  C   GLU A  81      10.128  50.078  13.937  1.00 45.36           C  
ATOM    623  O   GLU A  81       9.971  49.496  15.010  1.00 46.29           O  
ATOM    624  CB  GLU A  81       9.255  52.099  15.108  1.00 47.75           C  
ATOM    625  CG  GLU A  81       9.065  53.600  15.083  1.00 52.45           C  
ATOM    626  CD  GLU A  81       8.955  54.205  16.461  1.00 54.90           C  
ATOM    627  OE1 GLU A  81       8.032  53.812  17.213  1.00 56.73           O  
ATOM    628  OE2 GLU A  81       9.792  55.079  16.786  1.00 55.16           O  
ATOM    629  N   HIS A  82      10.510  49.462  12.825  1.00 44.03           N  
ATOM    630  CA  HIS A  82      10.802  48.039  12.797  1.00 41.35           C  
ATOM    631  C   HIS A  82      12.169  47.879  12.180  1.00 38.57           C  
ATOM    632  O   HIS A  82      12.487  48.529  11.196  1.00 37.20           O  
ATOM    633  CB  HIS A  82       9.762  47.295  11.970  1.00 44.05           C  
ATOM    634  CG  HIS A  82       8.366  47.476  12.473  1.00 46.61           C  
ATOM    635  ND1 HIS A  82       8.050  47.443  13.815  1.00 46.25           N  
ATOM    636  CD2 HIS A  82       7.200  47.678  11.815  1.00 46.74           C  
ATOM    637  CE1 HIS A  82       6.749  47.617  13.962  1.00 47.48           C  
ATOM    638  NE2 HIS A  82       6.209  47.762  12.765  1.00 48.04           N  
ATOM    639  N   PRO A  83      13.011  47.019  12.765  1.00 38.43           N  
ATOM    640  CA  PRO A  83      14.359  46.811  12.229  1.00 37.74           C  
ATOM    641  C   PRO A  83      14.381  45.991  10.944  1.00 37.90           C  
ATOM    642  O   PRO A  83      15.349  45.310  10.676  1.00 39.22           O  
ATOM    643  CB  PRO A  83      15.073  46.105  13.372  1.00 36.05           C  
ATOM    644  CG  PRO A  83      13.974  45.263  13.933  1.00 37.31           C  
ATOM    645  CD  PRO A  83      12.805  46.220  13.987  1.00 35.91           C  
ATOM    646  N   LEU A  84      13.313  46.051  10.155  1.00 38.07           N  
ATOM    647  CA  LEU A  84      13.256  45.305   8.902  1.00 36.82           C  
ATOM    648  C   LEU A  84      14.387  45.800   8.003  1.00 37.35           C  
ATOM    649  O   LEU A  84      14.423  46.978   7.640  1.00 38.12           O  
ATOM    650  CB  LEU A  84      11.912  45.544   8.211  1.00 37.42           C  
ATOM    651  CG  LEU A  84      11.314  44.425   7.354  1.00 36.94           C  
ATOM    652  CD1 LEU A  84      10.694  45.046   6.127  1.00 36.19           C  
ATOM    653  CD2 LEU A  84      12.370  43.415   6.952  1.00 35.58           C  
ATOM    654  N   LEU A  85      15.313  44.914   7.649  1.00 36.51           N  
ATOM    655  CA  LEU A  85      16.441  45.292   6.796  1.00 35.70           C  
ATOM    656  C   LEU A  85      16.291  44.795   5.364  1.00 35.79           C  
ATOM    657  O   LEU A  85      16.021  43.619   5.134  1.00 37.16           O  
ATOM    658  CB  LEU A  85      17.744  44.725   7.354  1.00 34.62           C  
ATOM    659  CG  LEU A  85      19.036  45.551   7.306  1.00 34.22           C  
ATOM    660  CD1 LEU A  85      20.216  44.593   7.300  1.00 32.27           C  
ATOM    661  CD2 LEU A  85      19.084  46.441   6.094  1.00 33.02           C  
ATOM    662  N   CYS A  86      16.467  45.695   4.404  1.00 36.11           N  
ATOM    663  CA  CYS A  86      16.393  45.348   2.988  1.00 35.59           C  
ATOM    664  C   CYS A  86      17.801  45.568   2.432  1.00 35.10           C  
ATOM    665  O   CYS A  86      18.435  46.580   2.738  1.00 34.79           O  
ATOM    666  CB  CYS A  86      15.389  46.258   2.272  1.00 37.33           C  
ATOM    667  SG  CYS A  86      15.112  45.855   0.529  1.00 39.13           S  
ATOM    668  N   THR A  87      18.300  44.625   1.636  1.00 34.97           N  
ATOM    669  CA  THR A  87      19.647  44.759   1.080  1.00 34.80           C  
ATOM    670  C   THR A  87      19.769  44.521  -0.432  1.00 35.91           C  
ATOM    671  O   THR A  87      18.860  43.999  -1.078  1.00 32.35           O  
ATOM    672  CB  THR A  87      20.642  43.819   1.809  1.00 34.12           C  
ATOM    673  OG1 THR A  87      20.279  42.451   1.584  1.00 35.37           O  
ATOM    674  CG2 THR A  87      20.618  44.085   3.290  1.00 34.13           C  
ATOM    675  N   LEU A  88      20.923  44.917  -0.968  1.00 38.69           N  
ATOM    676  CA  LEU A  88      21.255  44.786  -2.386  1.00 41.72           C  
ATOM    677  C   LEU A  88      22.212  43.634  -2.638  1.00 43.36           C  
ATOM    678  O   LEU A  88      23.154  43.423  -1.884  1.00 42.42           O  
ATOM    679  CB  LEU A  88      21.900  46.076  -2.905  1.00 42.77           C  
ATOM    680  CG  LEU A  88      20.915  47.143  -3.355  1.00 44.18           C  
ATOM    681  CD1 LEU A  88      21.654  48.362  -3.872  1.00 44.53           C  
ATOM    682  CD2 LEU A  88      20.031  46.548  -4.439  1.00 46.08           C  
ATOM    683  N   GLU A  89      21.994  42.926  -3.739  1.00 46.02           N  
ATOM    684  CA  GLU A  89      22.815  41.775  -4.092  1.00 48.51           C  
ATOM    685  C   GLU A  89      23.167  41.752  -5.579  1.00 46.86           C  
ATOM    686  O   GLU A  89      22.286  41.640  -6.421  1.00 46.41           O  
ATOM    687  CB  GLU A  89      22.043  40.498  -3.748  1.00 52.57           C  
ATOM    688  CG  GLU A  89      22.836  39.227  -3.886  1.00 57.54           C  
ATOM    689  CD  GLU A  89      23.824  39.082  -2.763  1.00 60.02           C  
ATOM    690  OE1 GLU A  89      24.627  40.021  -2.576  1.00 61.69           O  
ATOM    691  OE2 GLU A  89      23.791  38.041  -2.068  1.00 61.45           O  
ATOM    692  N   LYS A  90      24.447  41.837  -5.907  1.00 46.75           N  
ATOM    693  CA  LYS A  90      24.850  41.806  -7.307  1.00 47.71           C  
ATOM    694  C   LYS A  90      24.522  40.448  -7.947  1.00 48.37           C  
ATOM    695  O   LYS A  90      24.129  39.506  -7.262  1.00 48.36           O  
ATOM    696  CB  LYS A  90      26.342  42.103  -7.416  1.00 47.73           C  
ATOM    697  CG  LYS A  90      26.820  42.440  -8.814  1.00 49.48           C  
ATOM    698  CD  LYS A  90      28.100  43.261  -8.747  1.00 52.29           C  
ATOM    699  CE  LYS A  90      28.663  43.562 -10.127  1.00 54.71           C  
ATOM    700  NZ  LYS A  90      29.900  44.399 -10.046  1.00 56.24           N  
ATOM    701  N   ALA A  91      24.683  40.350  -9.262  1.00 50.59           N  
ATOM    702  CA  ALA A  91      24.393  39.111  -9.992  1.00 50.37           C  
ATOM    703  C   ALA A  91      22.924  38.777  -9.819  1.00 48.55           C  
ATOM    704  O   ALA A  91      22.175  39.579  -9.271  1.00 46.04           O  
ATOM    705  CB  ALA A  91      25.253  37.962  -9.468  1.00 50.75           C  
ATOM    706  OXT ALA A  91      22.522  37.682 -10.271  1.00 46.65           O  
TER     707      ALA A  91                                                      
END
MOLECULE T0513_17_85.pdb
ATOM    136  N   ASN    17      17.209  32.934  15.316  1.00 20.86           N  
ATOM    137  CA  ASN    17      16.055  33.821  15.215  1.00 21.30           C  
ATOM    138  C   ASN    17      16.030  34.653  13.915  1.00 19.81           C  
ATOM    139  O   ASN    17      15.279  35.635  13.809  1.00 22.73           O  
ATOM    140  CB  ASN    17      15.951  34.697  16.480  1.00 20.06           C  
ATOM    141  CG  ASN    17      14.625  35.442  16.589  1.00 20.33           C  
ATOM    142  OD1 ASN    17      14.596  36.674  16.657  1.00 26.71           O  
ATOM    143  ND2 ASN    17      13.524  34.701  16.602  1.00 25.28           N  
ATOM    144  N   PHE    18      16.863  34.266  12.950  1.00 22.83           N  
ATOM    145  CA  PHE    18      17.038  34.993  11.685  1.00 20.77           C  
ATOM    146  C   PHE    18      16.729  34.131  10.466  1.00 26.09           C  
ATOM    147  O   PHE    18      16.856  32.904  10.510  1.00 23.90           O  
ATOM    148  CB  PHE    18      18.489  35.478  11.537  1.00 20.07           C  
ATOM    149  CG  PHE    18      18.897  36.501  12.565  1.00 21.76           C  
ATOM    150  CD1 PHE    18      18.942  37.859  12.237  1.00 24.52           C  
ATOM    151  CD2 PHE    18      19.251  36.104  13.865  1.00 24.38           C  
ATOM    152  CE1 PHE    18      19.316  38.798  13.175  1.00 21.09           C  
ATOM    153  CE2 PHE    18      19.629  37.040  14.816  1.00 27.62           C  
ATOM    154  CZ  PHE    18      19.662  38.396  14.477  1.00 22.52           C  
ATOM    155  N   VAL    19      16.347  34.797   9.371  1.00 23.29           N  
ATOM    156  CA  VAL    19      16.190  34.157   8.064  1.00 23.44           C  
ATOM    157  C   VAL    19      17.116  34.822   7.054  1.00 23.87           C  
ATOM    158  O   VAL    19      17.450  36.007   7.186  1.00 26.05           O  
ATOM    159  CB  VAL    19      14.722  34.166   7.535  1.00 26.11           C  
ATOM    160  CG1 VAL    19      13.813  33.322   8.418  1.00 29.80           C  
ATOM    161  CG2 VAL    19      14.181  35.594   7.420  1.00 26.39           C  
ATOM    162  N   ARG    20      17.533  34.023   6.065  1.00 21.52           N  
ATOM    163  CA  ARG    20      18.422  34.472   4.999  0.50 25.24           C  
ATOM    165  C   ARG    20      17.799  35.611   4.197  1.00 23.67           C  
ATOM    166  O   ARG    20      16.602  35.598   3.885  1.00 26.54           O  
ATOM    167  CB  ARG    20      18.765  33.299   4.066  0.50 26.19           C  
ATOM    169  CG  ARG    20      19.517  32.169   4.752  0.50 32.31           C  
ATOM    171  CD  ARG    20      19.716  30.936   3.868  0.50 37.64           C  
ATOM    173  NE  ARG    20      21.039  30.345   4.075  0.50 32.60           N  
ATOM    175  CZ  ARG    20      21.962  30.231   3.123  0.50 38.95           C  
ATOM    177  NH1 ARG    20      23.143  29.697   3.411  0.50 43.99           N  
ATOM    179  NH2 ARG    20      21.705  30.634   1.880  0.50 28.71           N  
ATOM    181  N   PHE    21      18.612  36.600   3.890  1.00 20.41           N  
ATOM    182  CA  PHE    21      18.195  37.664   2.981  1.00 19.15           C  
ATOM    183  C   PHE    21      18.908  37.400   1.650  1.00 22.86           C  
ATOM    184  O   PHE    21      20.145  37.355   1.582  1.00 21.81           O  
ATOM    185  CB  PHE    21      18.522  39.041   3.558  1.00 21.05           C  
ATOM    186  CG  PHE    21      18.246  40.177   2.615  1.00 24.51           C  
ATOM    187  CD1 PHE    21      17.130  40.161   1.782  1.00 25.06           C  
ATOM    188  CD2 PHE    21      19.075  41.286   2.588  1.00 26.03           C  
ATOM    189  CE1 PHE    21      16.873  41.200   0.908  1.00 32.51           C  
ATOM    190  CE2 PHE    21      18.810  42.341   1.700  1.00 24.87           C  
ATOM    191  CZ  PHE    21      17.706  42.282   0.869  1.00 21.39           C  
ATOM    192  N   VAL    22      18.104  37.221   0.606  1.00 23.08           N  
ATOM    193  CA  VAL    22      18.559  36.692  -0.692  1.00 20.41           C  
ATOM    194  C   VAL    22      18.247  37.636  -1.870  1.00 23.08           C  
ATOM    195  O   VAL    22      17.138  38.165  -1.984  1.00 23.12           O  
ATOM    196  CB  VAL    22      17.935  35.297  -0.938  1.00 20.68           C  
ATOM    197  CG1 VAL    22      18.300  34.736  -2.328  1.00 23.11           C  
ATOM    198  CG2 VAL    22      18.358  34.340   0.161  1.00 27.48           C  
ATOM    199  N   ILE    23      19.243  37.852  -2.723  1.00 24.77           N  
ATOM    200  CA  ILE    23      19.057  38.610  -3.967  1.00 27.98           C  
ATOM    201  C   ILE    23      19.535  37.726  -5.131  1.00 32.10           C  
ATOM    202  O   ILE    23      20.708  37.296  -5.164  1.00 25.66           O  
ATOM    203  CB  ILE    23      19.843  39.955  -3.981  1.00 31.42           C  
ATOM    204  CG1 ILE    23      19.464  40.859  -2.795  1.00 24.84           C  
ATOM    205  CG2 ILE    23      19.614  40.727  -5.293  1.00 31.38           C  
ATOM    206  CD1 ILE    23      20.302  42.150  -2.745  1.00 24.85           C  
ATOM    207  N   GLU    24      18.619  37.471  -6.067  1.00 35.79           N  
ATOM    208  CA  GLU    24      18.867  36.635  -7.256  1.00 40.85           C  
ATOM    209  C   GLU    24      19.596  35.344  -6.899  1.00 38.68           C  
ATOM    210  O   GLU    24      20.621  35.030  -7.497  1.00 39.34           O  
ATOM    211  CB  GLU    24      19.661  37.404  -8.330  1.00 41.46           C  
ATOM    212  CG  GLU    24      19.095  38.765  -8.702  1.00 58.88           C  
ATOM    213  CD  GLU    24      17.908  38.707  -9.655  1.00 71.12           C  
ATOM    214  OE1 GLU    24      17.830  37.743 -10.453  1.00 72.33           O  
ATOM    215  OE2 GLU    24      17.060  39.637  -9.610  1.00 72.59           O  
ATOM    216  N   GLY    25      19.097  34.634  -5.890  1.00 38.63           N  
ATOM    217  CA  GLY    25      19.656  33.332  -5.487  1.00 35.84           C  
ATOM    218  C   GLY    25      20.919  33.370  -4.642  1.00 39.23           C  
ATOM    219  O   GLY    25      21.433  32.320  -4.260  1.00 36.34           O  
ATOM    220  N   ARG    26      21.434  34.570  -4.363  1.00 31.50           N  
ATOM    221  CA  ARG    26      22.645  34.735  -3.546  1.00 31.87           C  
ATOM    222  C   ARG    26      22.285  35.258  -2.152  1.00 27.89           C  
ATOM    223  O   ARG    26      21.606  36.279  -2.051  1.00 25.53           O  
ATOM    224  CB  ARG    26      23.601  35.715  -4.232  1.00 34.35           C  
ATOM    225  CG  ARG    26      24.062  35.266  -5.640  1.00 46.09           C  
ATOM    226  CD  ARG    26      24.650  33.842  -5.609  1.00 67.45           C  
ATOM    227  NE  ARG    26      24.739  33.221  -6.934  1.00 79.26           N  
ATOM    228  CZ  ARG    26      25.765  33.359  -7.774  1.00 81.40           C  
ATOM    229  NH1 ARG    26      26.814  34.109  -7.449  1.00 76.67           N  
ATOM    230  NH2 ARG    26      25.738  32.746  -8.951  1.00 81.53           N  
ATOM    231  N   ARG    27      22.741  34.579  -1.097  1.00 28.09           N  
ATOM    232  CA  ARG    27      22.516  35.067   0.266  1.00 29.86           C  
ATOM    233  C   ARG    27      23.404  36.265   0.561  1.00 27.38           C  
ATOM    234  O   ARG    27      24.632  36.167   0.521  1.00 27.76           O  
ATOM    235  CB  ARG    27      22.714  33.994   1.345  1.00 28.19           C  
ATOM    236  CG  ARG    27      22.185  34.495   2.724  1.00 27.64           C  
ATOM    237  CD  ARG    27      22.737  33.767   3.968  1.00 32.43           C  
ATOM    238  NE  ARG    27      24.189  33.836   4.100  1.00 26.50           N  
ATOM    239  CZ  ARG    27      24.855  34.923   4.495  1.00 32.07           C  
ATOM    240  NH1 ARG    27      24.213  36.047   4.809  1.00 26.92           N  
ATOM    241  NH2 ARG    27      26.169  34.892   4.579  1.00 32.44           N  
ATOM    242  N   VAL    28      22.789  37.414   0.846  1.00 18.52           N  
ATOM    243  CA  VAL    28      23.609  38.605   1.129  1.00 22.68           C  
ATOM    244  C   VAL    28      23.372  39.166   2.544  1.00 22.19           C  
ATOM    245  O   VAL    28      23.990  40.150   2.928  1.00 22.40           O  
ATOM    246  CB  VAL    28      23.365  39.738   0.098  1.00 24.96           C  
ATOM    247  CG1 VAL    28      23.876  39.321  -1.282  1.00 24.70           C  
ATOM    248  CG2 VAL    28      21.873  40.109   0.066  1.00 28.33           C  
ATOM    249  N   GLY    29      22.451  38.565   3.285  1.00 20.83           N  
ATOM    250  CA  GLY    29      22.212  38.997   4.657  1.00 15.98           C  
ATOM    251  C   GLY    29      21.388  38.062   5.499  1.00 19.37           C  
ATOM    252  O   GLY    29      21.164  36.897   5.142  1.00 24.06           O  
ATOM    253  N   TRP    30      20.973  38.584   6.649  1.00 19.03           N  
ATOM    254  CA  TRP    30      20.178  37.855   7.647  1.00 17.42           C  
ATOM    255  C   TRP    30      19.232  38.867   8.246  1.00 20.49           C  
ATOM    256  O   TRP    30      19.659  39.943   8.660  1.00 20.00           O  
ATOM    257  CB  TRP    30      21.042  37.350   8.791  1.00 23.22           C  
ATOM    258  CG  TRP    30      22.128  36.434   8.394  1.00 25.03           C  
ATOM    259  CD1 TRP    30      23.468  36.727   8.254  1.00 27.24           C  
ATOM    260  CD2 TRP    30      21.986  35.054   8.118  1.00 28.67           C  
ATOM    261  NE1 TRP    30      24.156  35.601   7.893  1.00 31.31           N  
ATOM    262  CE2 TRP    30      23.274  34.556   7.803  1.00 28.47           C  
ATOM    263  CE3 TRP    30      20.896  34.186   8.096  1.00 24.83           C  
ATOM    264  CZ2 TRP    30      23.501  33.216   7.473  1.00 36.90           C  
ATOM    265  CZ3 TRP    30      21.118  32.847   7.769  1.00 36.21           C  
ATOM    266  CH2 TRP    30      22.413  32.379   7.460  1.00 31.44           C  
ATOM    267  N   VAL    31      17.957  38.507   8.323  1.00 17.37           N  
ATOM    268  CA  VAL    31      16.909  39.418   8.827  1.00 19.85           C  
ATOM    269  C   VAL    31      16.218  38.708   9.974  1.00 18.71           C  
ATOM    270  O   VAL    31      15.887  37.527   9.863  1.00 18.44           O  
ATOM    271  CB  VAL    31      15.901  39.734   7.689  1.00 24.44           C  
ATOM    272  CG1 VAL    31      14.615  40.380   8.198  1.00 28.37           C  
ATOM    273  CG2 VAL    31      16.560  40.638   6.637  1.00 24.28           C  
ATOM    274  N   ARG    32      16.008  39.417  11.082  1.00 18.35           N  
ATOM    275  CA  ARG    32      15.317  38.839  12.248  1.00 18.09           C  
ATOM    276  C   ARG    32      13.910  38.390  11.843  1.00 20.69           C  
ATOM    277  O   ARG    32      13.289  39.032  11.011  1.00 20.50           O  
ATOM    278  CB  ARG    32      15.253  39.853  13.387  1.00 26.61           C  
ATOM    279  CG  ARG    32      15.330  39.189  14.723  1.00 39.40           C  
ATOM    280  CD  ARG    32      15.433  40.164  15.878  1.00 32.98           C  
ATOM    281  NE  ARG    32      16.788  40.385  16.397  1.00 27.34           N  
ATOM    282  CZ  ARG    32      17.559  39.468  16.999  1.00 31.20           C  
ATOM    283  NH1 ARG    32      17.168  38.216  17.147  1.00 23.24           N  
ATOM    284  NH2 ARG    32      18.758  39.802  17.443  1.00 29.28           N  
ATOM    285  N   LYS    33      13.453  37.255  12.362  1.00 20.44           N  
ATOM    286  CA  LYS    33      12.118  36.739  11.984  1.00 24.51           C  
ATOM    287  C   LYS    33      10.963  37.745  12.142  1.00 23.04           C  
ATOM    288  O   LYS    33      10.120  37.859  11.246  1.00 20.15           O  
ATOM    289  CB  LYS    33      11.813  35.443  12.738  1.00 25.25           C  
ATOM    290  CG  LYS    33      12.553  34.232  12.191  1.00 24.38           C  
ATOM    291  CD  LYS    33      12.538  33.069  13.190  1.00 22.85           C  
ATOM    292  CE  LYS    33      13.393  31.904  12.653  1.00 29.69           C  
ATOM    293  NZ  LYS    33      13.288  30.715  13.555  1.00 33.21           N  
ATOM    294  N   ALA    34      10.908  38.463  13.263  1.00 23.39           N  
ATOM    295  CA  ALA    34       9.837  39.486  13.438  1.00 23.82           C  
ATOM    296  C   ALA    34       9.931  40.608  12.392  1.00 21.06           C  
ATOM    297  O   ALA    34       8.915  41.079  11.869  1.00 23.26           O  
ATOM    298  CB  ALA    34       9.838  40.053  14.861  1.00 24.14           C  
ATOM    299  N   LEU    35      11.150  41.021  12.057  1.00 21.64           N  
ATOM    300  CA  LEU    35      11.318  42.030  11.020  1.00 22.65           C  
ATOM    301  C   LEU    35      10.867  41.492   9.646  1.00 20.58           C  
ATOM    302  O   LEU    35      10.277  42.233   8.860  1.00 21.78           O  
ATOM    303  CB  LEU    35      12.768  42.517  10.957  1.00 18.60           C  
ATOM    304  CG  LEU    35      13.159  43.481   9.832  1.00 21.60           C  
ATOM    305  CD1 LEU    35      12.357  44.782   9.930  1.00 22.31           C  
ATOM    306  CD2 LEU    35      14.625  43.774   9.959  1.00 17.99           C  
ATOM    307  N   ALA    36      11.134  40.209   9.376  1.00 20.53           N  
ATOM    308  CA  ALA    36      10.707  39.572   8.135  1.00 24.82           C  
ATOM    309  C   ALA    36       9.195  39.669   7.995  1.00 25.43           C  
ATOM    310  O   ALA    36       8.695  39.931   6.891  1.00 25.13           O  
ATOM    311  CB  ALA    36      11.176  38.108   8.077  1.00 18.16           C  
ATOM    312  N   GLN    37       8.487  39.531   9.128  1.00 19.18           N  
ATOM    313  CA  GLN    37       7.026  39.711   9.172  1.00 21.96           C  
ATOM    314  C   GLN    37       6.611  41.128   8.806  1.00 24.15           C  
ATOM    315  O   GLN    37       5.595  41.324   8.129  1.00 28.98           O  
ATOM    316  CB  GLN    37       6.450  39.304  10.526  1.00 24.96           C  
ATOM    317  CG  GLN    37       6.470  37.799  10.786  1.00 41.37           C  
ATOM    318  CD  GLN    37       5.780  36.990   9.688  1.00 51.39           C  
ATOM    319  OE1 GLN    37       4.587  37.161   9.429  1.00 45.08           O  
ATOM    320  NE2 GLN    37       6.534  36.104   9.043  1.00 47.83           N  
ATOM    321  N   ARG    38       7.402  42.119   9.220  1.00 23.70           N  
ATOM    322  CA  ARG    38       7.148  43.510   8.841  0.50 22.14           C  
ATOM    324  C   ARG    38       7.373  43.714   7.341  1.00 27.87           C  
ATOM    325  O   ARG    38       6.623  44.433   6.689  1.00 25.76           O  
ATOM    326  CB  ARG    38       8.025  44.495   9.637  0.50 24.12           C  
ATOM    328  CG  ARG    38       7.914  44.432  11.169  0.50 21.02           C  
ATOM    330  CD  ARG    38       6.591  45.017  11.738  0.50 19.70           C  
ATOM    332  NE  ARG    38       5.452  44.110  11.583  0.50 18.95           N  
ATOM    334  CZ  ARG    38       5.293  42.965  12.246  0.50 23.77           C  
ATOM    336  NH1 ARG    38       4.217  42.214  12.017  0.50 28.31           N  
ATOM    338  NH2 ARG    38       6.198  42.563  13.140  0.50 29.77           N  
ATOM    340  N   LEU    39       8.399  43.069   6.804  1.00 27.55           N  
ATOM    341  CA  LEU    39       8.758  43.182   5.394  1.00 26.92           C  
ATOM    342  C   LEU    39       7.715  42.557   4.451  1.00 28.70           C  
ATOM    343  O   LEU    39       7.550  42.940   3.331  1.00 27.28           O  
ATOM    344  CB  LEU    39      10.122  42.556   5.162  1.00 23.52           C  
ATOM    345  CG  LEU    39      11.339  43.205   5.783  1.00 21.20           C  
ATOM    346  CD1 LEU    39      12.583  42.462   5.385  1.00 23.20           C  
ATOM    347  CD2 LEU    39      11.462  44.614   5.429  1.00 23.96           C  
ATOM    348  N   LYS    40       7.035  41.573   4.967  1.00 24.98           N  
ATOM    349  CA  LYS    40       5.956  40.906   4.311  1.00 32.51           C  
ATOM    350  C   LYS    40       4.847  41.820   3.842  1.00 33.88           C  
ATOM    351  O   LYS    40       4.201  41.545   2.891  1.00 34.37           O  
ATOM    352  CB  LYS    40       5.398  39.871   5.265  1.00 35.26           C  
ATOM    353  CG  LYS    40       4.833  38.712   4.620  1.00 42.25           C  
ATOM    354  CD  LYS    40       4.215  37.788   5.581  1.00 47.99           C  
ATOM    355  CE  LYS    40       5.219  36.895   6.146  1.00 56.22           C  
ATOM    356  NZ  LYS    40       4.614  35.738   6.844  1.00 65.56           N  
ATOM    357  N   ALA    41       4.651  42.919   4.534  1.00 33.32           N  
ATOM    358  CA  ALA    41       3.654  43.879   4.166  1.00 26.43           C  
ATOM    359  C   ALA    41       4.055  44.652   2.919  1.00 31.43           C  
ATOM    360  O   ALA    41       3.262  45.313   2.315  1.00 31.38           O  
ATOM    361  CB  ALA    41       3.446  44.781   5.243  1.00 28.22           C  
ATOM    362  N   HIS    42       5.315  44.560   2.560  1.00 22.14           N  
ATOM    363  CA  HIS    42       5.782  45.155   1.354  1.00 22.67           C  
ATOM    364  C   HIS    42       5.977  44.112   0.240  1.00 24.61           C  
ATOM    365  O   HIS    42       7.041  43.935  -0.242  1.00 21.94           O  
ATOM    366  CB  HIS    42       7.064  45.909   1.625  1.00 23.33           C  
ATOM    367  CG  HIS    42       6.906  47.023   2.603  1.00 26.26           C  
ATOM    368  ND1 HIS    42       6.771  48.327   2.211  1.00 28.75           N  
ATOM    369  CD2 HIS    42       6.846  47.032   3.946  1.00 27.23           C  
ATOM    370  CE1 HIS    42       6.650  49.092   3.270  1.00 29.65           C  
ATOM    371  NE2 HIS    42       6.684  48.330   4.335  1.00 22.96           N  
ATOM    372  N   GLY    43       4.902  43.451  -0.118  1.00 21.77           N  
ATOM    373  CA  GLY    43       4.938  42.357  -1.055  1.00 24.76           C  
ATOM    374  C   GLY    43       5.412  42.645  -2.467  1.00 28.20           C  
ATOM    375  O   GLY    43       5.741  41.776  -3.184  1.00 25.79           O  
ATOM    376  N   ARG    44       5.456  43.907  -2.835  1.00 21.72           N  
ATOM    377  CA  ARG    44       5.914  44.304  -4.161  1.00 24.32           C  
ATOM    378  C   ARG    44       7.437  44.361  -4.225  1.00 20.86           C  
ATOM    379  O   ARG    44       8.019  44.447  -5.305  1.00 23.65           O  
ATOM    380  CB  ARG    44       5.321  45.661  -4.548  1.00 22.47           C  
ATOM    381  CG  ARG    44       3.815  45.643  -4.754  1.00 21.53           C  
ATOM    382  CD  ARG    44       3.289  47.028  -5.094  1.00 22.88           C  
ATOM    383  NE  ARG    44       3.817  47.518  -6.364  1.00 23.77           N  
ATOM    384  CZ  ARG    44       3.800  48.793  -6.738  1.00 28.40           C  
ATOM    385  NH1 ARG    44       3.279  49.714  -5.938  1.00 23.25           N  
ATOM    386  NH2 ARG    44       4.303  49.149  -7.912  1.00 22.34           N  
ATOM    387  N   VAL    45       8.075  44.311  -3.060  1.00 16.84           N  
ATOM    388  CA  VAL    45       9.532  44.444  -2.974  1.00 19.47           C  
ATOM    389  C   VAL    45      10.146  43.169  -2.404  1.00 21.56           C  
ATOM    390  O   VAL    45      11.226  42.779  -2.841  1.00 22.98           O  
ATOM    391  CB  VAL    45       9.907  45.652  -2.097  1.00 19.99           C  
ATOM    392  CG1 VAL    45      11.447  45.847  -1.919  1.00 21.44           C  
ATOM    393  CG2 VAL    45       9.247  46.952  -2.669  1.00 21.74           C  
ATOM    394  N   PHE    46       9.484  42.556  -1.421  1.00 23.63           N  
ATOM    395  CA  PHE    46      10.014  41.345  -0.749  1.00 20.04           C  
ATOM    396  C   PHE    46       9.057  40.164  -0.851  1.00 26.86           C  
ATOM    397  O   PHE    46       7.859  40.313  -0.628  1.00 28.56           O  
ATOM    398  CB  PHE    46      10.268  41.631   0.747  1.00 21.13           C  
ATOM    399  CG  PHE    46      11.314  42.678   1.005  1.00 21.58           C  
ATOM    400  CD1 PHE    46      12.673  42.366   0.922  1.00 26.18           C  
ATOM    401  CD2 PHE    46      10.942  43.978   1.337  1.00 23.12           C  
ATOM    402  CE1 PHE    46      13.650  43.337   1.165  1.00 24.11           C  
ATOM    403  CE2 PHE    46      11.889  44.948   1.576  1.00 21.14           C  
ATOM    404  CZ  PHE    46      13.251  44.646   1.504  1.00 17.18           C  
ATOM    405  N   ASP    47       9.590  38.987  -1.178  1.00 20.78           N  
ATOM    406  CA  ASP    47       8.849  37.730  -1.002  1.00 24.46           C  
ATOM    407  C   ASP    47       9.338  37.080   0.284  1.00 26.67           C  
ATOM    408  O   ASP    47      10.537  36.823   0.431  1.00 31.75           O  
ATOM    409  CB  ASP    47       9.107  36.797  -2.180  1.00 32.25           C  
ATOM    410  CG  ASP    47       8.665  37.398  -3.500  1.00 45.29           C  
ATOM    411  OD1 ASP    47       7.537  37.927  -3.556  1.00 49.98           O  
ATOM    412  OD2 ASP    47       9.446  37.343  -4.473  1.00 54.42           O  
ATOM    413  N   VAL    48       8.430  36.834   1.220  1.00 27.58           N  
ATOM    414  CA  VAL    48       8.826  36.313   2.532  1.00 30.03           C  
ATOM    415  C   VAL    48       8.249  34.926   2.741  1.00 33.16           C  
ATOM    416  O   VAL    48       7.034  34.738   2.683  1.00 34.75           O  
ATOM    417  CB  VAL    48       8.411  37.276   3.708  1.00 29.61           C  
ATOM    418  CG1 VAL    48       8.797  36.679   5.070  1.00 29.77           C  
ATOM    419  CG2 VAL    48       9.052  38.643   3.525  1.00 31.49           C  
ATOM    420  N   THR    49       9.133  33.957   2.966  1.00 28.52           N  
ATOM    421  CA  THR    49       8.723  32.591   3.293  1.00 33.79           C  
ATOM    422  C   THR    49       9.204  32.264   4.698  1.00 37.87           C  
ATOM    423  O   THR    49       9.802  33.109   5.366  1.00 34.40           O  
ATOM    424  CB  THR    49       9.305  31.582   2.285  1.00 33.24           C  
ATOM    425  OG1 THR    49      10.733  31.717   2.232  1.00 42.54           O  
ATOM    426  CG2 THR    49       8.726  31.811   0.890  1.00 38.14           C  
ATOM    427  N   ARG    50       8.966  31.031   5.134  1.00 46.46           N  
ATOM    428  CA  ARG    50       9.394  30.554   6.452  1.00 50.39           C  
ATOM    429  C   ARG    50      10.920  30.552   6.612  1.00 42.25           C  
ATOM    430  O   ARG    50      11.437  30.711   7.717  1.00 50.08           O  
ATOM    431  CB  ARG    50       8.833  29.143   6.689  1.00 51.10           C  
ATOM    432  CG  ARG    50       8.908  28.632   8.125  1.00 65.81           C  
ATOM    433  CD  ARG    50       8.648  27.129   8.184  1.00 65.65           C  
ATOM    434  NE  ARG    50       9.511  26.455   9.160  1.00 82.09           N  
ATOM    435  CZ  ARG    50       9.228  26.304  10.454  1.00 86.34           C  
ATOM    436  NH1 ARG    50       8.094  26.778  10.958  1.00 87.28           N  
ATOM    437  NH2 ARG    50      10.086  25.675  11.248  1.00 84.79           N  
ATOM    438  N   ASP    51      11.629  30.389   5.503  1.00 32.87           N  
ATOM    439  CA  ASP    51      13.077  30.235   5.527  1.00 37.90           C  
ATOM    440  C   ASP    51      13.855  31.424   4.946  1.00 33.77           C  
ATOM    441  O   ASP    51      15.081  31.474   5.085  1.00 33.12           O  
ATOM    442  CB  ASP    51      13.488  28.953   4.773  1.00 46.29           C  
ATOM    443  CG  ASP    51      12.793  27.692   5.302  1.00 57.41           C  
ATOM    444  OD1 ASP    51      12.856  27.426   6.522  1.00 66.19           O  
ATOM    445  OD2 ASP    51      12.195  26.956   4.484  1.00 61.45           O  
ATOM    446  N   ALA    52      13.176  32.363   4.277  1.00 29.51           N  
ATOM    447  CA  ALA    52      13.909  33.400   3.549  1.00 31.37           C  
ATOM    448  C   ALA    52      13.112  34.666   3.256  1.00 27.18           C  
ATOM    449  O   ALA    52      11.890  34.637   3.109  1.00 27.33           O  
ATOM    450  CB  ALA    52      14.477  32.834   2.236  1.00 32.40           C  
ATOM    451  N   VAL    53      13.844  35.771   3.191  1.00 24.06           N  
ATOM    452  CA  VAL    53      13.359  37.013   2.627  1.00 23.42           C  
ATOM    453  C   VAL    53      14.046  37.168   1.268  1.00 27.83           C  
ATOM    454  O   VAL    53      15.281  37.291   1.186  1.00 26.26           O  
ATOM    455  CB  VAL    53      13.720  38.216   3.535  1.00 22.71           C  
ATOM    456  CG1 VAL    53      13.313  39.521   2.909  1.00 23.66           C  
ATOM    457  CG2 VAL    53      13.050  38.097   4.878  1.00 24.13           C  
ATOM    458  N   LEU    54      13.253  37.153   0.201  1.00 22.46           N  
ATOM    459  CA  LEU    54      13.779  37.276  -1.151  1.00 22.52           C  
ATOM    460  C   LEU    54      13.415  38.629  -1.732  1.00 22.04           C  
ATOM    461  O   LEU    54      12.262  39.026  -1.688  1.00 23.72           O  
ATOM    462  CB  LEU    54      13.206  36.181  -2.066  1.00 28.23           C  
ATOM    463  CG  LEU    54      14.094  34.965  -2.357  1.00 44.20           C  
ATOM    464  CD1 LEU    54      14.301  34.149  -1.120  1.00 47.96           C  
ATOM    465  CD2 LEU    54      13.496  34.074  -3.455  1.00 42.25           C  
ATOM    466  N   LEU    55      14.402  39.333  -2.262  1.00 20.07           N  
ATOM    467  CA  LEU    55      14.093  40.556  -2.999  1.00 24.13           C  
ATOM    468  C   LEU    55      13.367  40.173  -4.288  1.00 27.55           C  
ATOM    469  O   LEU    55      13.743  39.198  -4.951  1.00 23.84           O  
ATOM    470  CB  LEU    55      15.370  41.320  -3.291  1.00 25.84           C  
ATOM    471  CG  LEU    55      15.168  42.775  -3.660  1.00 25.00           C  
ATOM    472  CD1 LEU    55      14.453  43.534  -2.557  1.00 23.86           C  
ATOM    473  CD2 LEU    55      16.490  43.392  -3.953  1.00 22.17           C  
ATOM    474  N   SER    56      12.313  40.909  -4.621  1.00 26.26           N  
ATOM    475  CA  SER    56      11.503  40.630  -5.822  1.00 29.54           C  
ATOM    476  C   SER    56      12.328  40.562  -7.109  1.00 27.78           C  
ATOM    477  O   SER    56      13.165  41.423  -7.367  1.00 22.69           O  
ATOM    478  CB  SER    56      10.431  41.699  -6.007  1.00 31.72           C  
ATOM    479  OG  SER    56       9.711  41.455  -7.207  1.00 32.81           O  
ATOM    480  N   ALA    57      12.058  39.545  -7.920  1.00 29.77           N  
ATOM    481  CA  ALA    57      12.789  39.319  -9.167  1.00 32.42           C  
ATOM    482  C   ALA    57      12.470  40.390 -10.205  1.00 33.36           C  
ATOM    483  O   ALA    57      13.229  40.569 -11.147  1.00 34.96           O  
ATOM    484  CB  ALA    57      12.509  37.914  -9.725  1.00 36.66           C  
ATOM    485  N   SER    58      11.376  41.128  -9.990  1.00 28.68           N  
ATOM    486  CA  SER    58      11.012  42.274 -10.826  1.00 28.25           C  
ATOM    487  C   SER    58      11.974  43.463 -10.707  1.00 31.71           C  
ATOM    488  O   SER    58      11.977  44.358 -11.557  1.00 31.32           O  
ATOM    489  CB  SER    58       9.565  42.695 -10.543  1.00 34.24           C  
ATOM    490  OG  SER    58       9.420  43.333  -9.284  1.00 35.76           O  
ATOM    491  N   LEU    59      12.787  43.475  -9.653  1.00 24.78           N  
ATOM    492  CA  LEU    59      13.783  44.526  -9.471  1.00 30.63           C  
ATOM    493  C   LEU    59      15.071  44.018 -10.106  1.00 31.92           C  
ATOM    494  O   LEU    59      15.820  43.244  -9.497  1.00 31.98           O  
ATOM    495  CB  LEU    59      13.955  44.871  -7.980  1.00 29.62           C  
ATOM    496  CG  LEU    59      12.714  45.319  -7.215  1.00 25.65           C  
ATOM    497  CD1 LEU    59      12.954  45.256  -5.702  1.00 25.36           C  
ATOM    498  CD2 LEU    59      12.301  46.719  -7.619  1.00 29.09           C  
ATOM    499  N   ARG    60      15.300  44.459 -11.342  1.00 33.21           N  
ATOM    500  CA  ARG    60      16.249  43.826 -12.253  1.00 36.10           C  
ATOM    501  C   ARG    60      17.617  44.474 -12.231  1.00 33.20           C  
ATOM    502  O   ARG    60      18.578  43.881 -12.717  1.00 44.58           O  
ATOM    503  CB  ARG    60      15.712  43.878 -13.696  1.00 39.12           C  
ATOM    504  CG  ARG    60      14.323  43.261 -13.930  1.00 52.12           C  
ATOM    505  CD  ARG    60      14.402  41.782 -14.285  1.00 67.62           C  
ATOM    506  NE  ARG    60      13.334  41.402 -15.212  1.00 85.24           N  
ATOM    507  CZ  ARG    60      12.391  40.490 -14.977  1.00 88.67           C  
ATOM    508  NH1 ARG    60      12.359  39.816 -13.833  1.00 90.37           N  
ATOM    509  NH2 ARG    60      11.478  40.240 -15.906  1.00 88.09           N  
ATOM    510  N   THR    61      17.700  45.706 -11.724  1.00 29.10           N  
ATOM    511  CA  THR    61      18.947  46.463 -11.718  1.00 26.42           C  
ATOM    512  C   THR    61      19.334  46.835 -10.279  1.00 27.29           C  
ATOM    513  O   THR    61      18.456  46.936  -9.417  1.00 22.73           O  
ATOM    514  CB  THR    61      18.868  47.776 -12.543  1.00 29.34           C  
ATOM    515  OG1 THR    61      18.018  48.728 -11.881  1.00 26.60           O  
ATOM    516  CG2 THR    61      18.422  47.539 -13.999  1.00 24.84           C  
ATOM    517  N   PRO    62      20.634  47.044 -10.018  1.00 25.78           N  
ATOM    518  CA  PRO    62      21.002  47.565  -8.694  1.00 22.69           C  
ATOM    519  C   PRO    62      20.253  48.870  -8.342  1.00 29.65           C  
ATOM    520  O   PRO    62      19.791  49.003  -7.207  1.00 24.80           O  
ATOM    521  CB  PRO    62      22.528  47.800  -8.813  1.00 27.82           C  
ATOM    522  CG  PRO    62      22.973  46.819  -9.858  1.00 31.58           C  
ATOM    523  CD  PRO    62      21.829  46.806 -10.863  1.00 27.50           C  
ATOM    524  N   GLN    63      20.076  49.775  -9.315  1.00 24.51           N  
ATOM    525  CA  GLN    63      19.422  51.067  -9.069  1.00 25.29           C  
ATOM    526  C   GLN    63      17.965  50.872  -8.650  1.00 21.95           C  
ATOM    527  O   GLN    63      17.484  51.547  -7.720  1.00 23.61           O  
ATOM    528  CB  GLN    63      19.507  52.002 -10.296  1.00 31.56           C  
ATOM    529  CG  GLN    63      20.910  52.567 -10.603  1.00 41.77           C  
ATOM    530  CD  GLN    63      21.898  51.536 -11.202  1.00 57.34           C  
ATOM    531  OE1 GLN    63      21.501  50.544 -11.848  1.00 32.51           O  
ATOM    532  NE2 GLN    63      23.202  51.774 -10.973  1.00 51.09           N  
ATOM    533  N   SER    64      17.280  49.920  -9.284  1.00 21.83           N  
ATOM    534  CA  SER    64      15.876  49.666  -8.954  1.00 25.03           C  
ATOM    535  C   SER    64      15.750  49.055  -7.554  1.00 24.32           C  
ATOM    536  O   SER    64      14.890  49.460  -6.775  1.00 20.62           O  
ATOM    537  CB  SER    64      15.192  48.792 -10.011  1.00 28.61           C  
ATOM    538  OG  SER    64      15.627  47.452  -9.913  1.00 30.88           O  
ATOM    539  N   ARG    65      16.631  48.109  -7.241  1.00 20.58           N  
ATOM    540  CA  ARG    65      16.695  47.517  -5.897  1.00 21.14           C  
ATOM    541  C   ARG    65      16.955  48.511  -4.773  1.00 21.18           C  
ATOM    542  O   ARG    65      16.253  48.488  -3.756  1.00 19.62           O  
ATOM    543  CB  ARG    65      17.750  46.409  -5.852  1.00 23.32           C  
ATOM    544  CG  ARG    65      17.463  45.270  -6.805  1.00 18.45           C  
ATOM    545  CD  ARG    65      18.665  44.418  -6.897  1.00 23.80           C  
ATOM    546  NE  ARG    65      18.445  43.302  -7.792  1.00 28.23           N  
ATOM    547  CZ  ARG    65      19.393  42.818  -8.571  1.00 39.35           C  
ATOM    548  NH1 ARG    65      20.600  43.365  -8.529  1.00 26.87           N  
ATOM    549  NH2 ARG    65      19.131  41.801  -9.384  1.00 39.24           N  
ATOM    550  N   THR    66      17.976  49.349  -4.961  1.00 18.13           N  
ATOM    551  CA  THR    66      18.367  50.404  -4.029  1.00 18.63           C  
ATOM    552  C   THR    66      17.207  51.354  -3.731  1.00 22.30           C  
ATOM    553  O   THR    66      16.892  51.610  -2.565  1.00 17.93           O  
ATOM    554  CB  THR    66      19.518  51.206  -4.624  1.00 15.67           C  
ATOM    555  OG1 THR    66      20.662  50.330  -4.794  1.00 19.82           O  
ATOM    556  CG2 THR    66      19.902  52.414  -3.716  1.00 22.75           C  
ATOM    557  N   ARG    67      16.562  51.837  -4.791  1.00 21.29           N  
ATOM    558  CA  ARG    67      15.388  52.717  -4.654  1.00 26.02           C  
ATOM    559  C   ARG    67      14.202  52.034  -3.933  1.00 17.62           C  
ATOM    560  O   ARG    67      13.593  52.643  -3.029  1.00 21.68           O  
ATOM    561  CB  ARG    67      15.032  53.252  -6.059  1.00 24.56           C  
ATOM    562  CG  ARG    67      13.700  53.913  -6.270  1.00 35.10           C  
ATOM    563  CD  ARG    67      13.442  54.083  -7.804  1.00 28.40           C  
ATOM    564  NE  ARG    67      14.538  54.784  -8.478  1.00 34.03           N  
ATOM    565  CZ  ARG    67      15.203  54.347  -9.545  1.00 43.18           C  
ATOM    566  NH1 ARG    67      14.900  53.185 -10.139  1.00 42.38           N  
ATOM    567  NH2 ARG    67      16.184  55.099 -10.032  1.00 51.91           N  
ATOM    568  N   ALA    68      13.898  50.784  -4.297  1.00 21.03           N  
ATOM    569  CA  ALA    68      12.785  50.049  -3.702  1.00 16.16           C  
ATOM    570  C   ALA    68      13.012  49.854  -2.200  1.00 20.76           C  
ATOM    571  O   ALA    68      12.143  50.134  -1.392  1.00 20.74           O  
ATOM    572  CB  ALA    68      12.611  48.667  -4.367  1.00 15.55           C  
ATOM    573  N   VAL    69      14.181  49.335  -1.841  1.00 17.62           N  
ATOM    574  CA  VAL    69      14.494  49.098  -0.428  1.00 17.98           C  
ATOM    575  C   VAL    69      14.677  50.379   0.391  1.00 18.80           C  
ATOM    576  O   VAL    69      14.300  50.412   1.572  1.00 21.34           O  
ATOM    577  CB  VAL    69      15.722  48.180  -0.310  1.00 16.22           C  
ATOM    578  CG1 VAL    69      16.157  47.989   1.146  1.00 17.56           C  
ATOM    579  CG2 VAL    69      15.351  46.828  -0.894  1.00 15.21           C  
ATOM    580  N   ALA    70      15.217  51.420  -0.231  1.00 16.22           N  
ATOM    581  CA  ALA    70      15.393  52.699   0.447  1.00 18.41           C  
ATOM    582  C   ALA    70      14.053  53.236   0.933  1.00 23.35           C  
ATOM    583  O   ALA    70      13.960  53.719   2.057  1.00 20.90           O  
ATOM    584  CB  ALA    70      16.106  53.706  -0.414  1.00 20.53           C  
ATOM    585  N   ASP    71      13.029  53.113   0.093  1.00 19.14           N  
ATOM    586  CA  ASP    71      11.661  53.564   0.421  1.00 22.77           C  
ATOM    587  C   ASP    71      11.066  52.725   1.566  1.00 22.49           C  
ATOM    588  O   ASP    71      10.469  53.270   2.493  1.00 18.09           O  
ATOM    589  CB  ASP    71      10.774  53.529  -0.847  1.00 16.87           C  
ATOM    590  CG  ASP    71       9.287  53.667  -0.537  1.00 22.63           C  
ATOM    591  OD1 ASP    71       8.899  54.604   0.199  1.00 23.94           O  
ATOM    592  OD2 ASP    71       8.512  52.807  -0.986  1.00 23.44           O  
ATOM    593  N   VAL    72      11.256  51.403   1.515  1.00 19.22           N  
ATOM    594  CA  VAL    72      10.769  50.516   2.571  1.00 20.05           C  
ATOM    595  C   VAL    72      11.420  50.874   3.922  1.00 19.36           C  
ATOM    596  O   VAL    72      10.726  51.017   4.927  1.00 19.01           O  
ATOM    597  CB  VAL    72      11.034  49.025   2.216  1.00 20.04           C  
ATOM    598  CG1 VAL    72      10.739  48.072   3.440  1.00 24.21           C  
ATOM    599  CG2 VAL    72      10.201  48.614   1.010  1.00 22.38           C  
ATOM    600  N   VAL    73      12.743  51.023   3.908  1.00 17.33           N  
ATOM    601  CA  VAL    73      13.536  51.443   5.070  1.00 20.26           C  
ATOM    602  C   VAL    73      13.027  52.774   5.630  1.00 22.10           C  
ATOM    603  O   VAL    73      12.812  52.861   6.840  1.00 17.86           O  
ATOM    604  CB  VAL    73      15.051  51.490   4.716  1.00 21.15           C  
ATOM    605  CG1 VAL    73      15.854  52.320   5.724  1.00 22.24           C  
ATOM    606  CG2 VAL    73      15.574  50.041   4.613  1.00 20.63           C  
ATOM    607  N   ASP    74      12.790  53.755   4.746  1.00 20.58           N  
ATOM    608  CA  ASP    74      12.251  55.063   5.119  1.00 18.28           C  
ATOM    609  C   ASP    74      11.020  54.878   5.970  1.00 20.19           C  
ATOM    610  O   ASP    74      10.914  55.452   7.042  1.00 21.19           O  
ATOM    611  CB  ASP    74      11.869  55.914   3.896  1.00 19.53           C  
ATOM    612  CG  ASP    74      13.056  56.564   3.220  1.00 31.44           C  
ATOM    613  OD1 ASP    74      14.149  56.596   3.817  1.00 30.23           O  
ATOM    614  OD2 ASP    74      12.889  57.055   2.076  1.00 33.16           O  
ATOM    615  N   ARG    75      10.109  54.037   5.496  1.00 19.10           N  
ATOM    616  CA  ARG    75       8.804  53.931   6.138  1.00 21.32           C  
ATOM    617  C   ARG    75       8.854  53.063   7.393  1.00 21.32           C  
ATOM    618  O   ARG    75       8.255  53.401   8.398  1.00 17.97           O  
ATOM    619  CB  ARG    75       7.755  53.513   5.125  1.00 19.91           C  
ATOM    620  CG  ARG    75       7.548  54.674   4.110  1.00 20.27           C  
ATOM    621  CD  ARG    75       6.359  54.402   3.225  1.00 22.86           C  
ATOM    622  NE  ARG    75       6.733  53.521   2.129  1.00 25.46           N  
ATOM    623  CZ  ARG    75       6.126  52.384   1.815  1.00 27.49           C  
ATOM    624  NH1 ARG    75       5.079  51.963   2.505  1.00 25.53           N  
ATOM    625  NH2 ARG    75       6.553  51.690   0.767  1.00 23.23           N  
ATOM    626  N   LEU    76       9.635  51.995   7.363  1.00 20.28           N  
ATOM    627  CA  LEU    76       9.884  51.208   8.580  1.00 18.24           C  
ATOM    628  C   LEU    76      10.543  52.045   9.684  1.00 17.75           C  
ATOM    629  O   LEU    76      10.208  51.893  10.865  1.00 18.96           O  
ATOM    630  CB  LEU    76      10.747  49.987   8.241  1.00 18.67           C  
ATOM    631  CG  LEU    76      10.044  48.840   7.491  1.00 24.03           C  
ATOM    632  CD1 LEU    76      11.029  47.720   7.214  1.00 24.96           C  
ATOM    633  CD2 LEU    76       8.841  48.331   8.274  1.00 27.30           C  
ATOM    634  N   ALA    77      11.474  52.925   9.310  1.00 16.73           N  
ATOM    635  CA  ALA    77      12.117  53.812  10.286  1.00 21.15           C  
ATOM    636  C   ALA    77      11.117  54.843  10.818  1.00 22.18           C  
ATOM    637  O   ALA    77      11.066  55.100  12.027  1.00 19.61           O  
ATOM    638  CB  ALA    77      13.325  54.466   9.693  1.00 17.59           C  
ATOM    639  N   ASP    78      10.291  55.395   9.931  1.00 20.66           N  
ATOM    640  CA  ASP    78       9.179  56.292  10.347  1.00 19.06           C  
ATOM    641  C   ASP    78       8.312  55.602  11.411  1.00 18.85           C  
ATOM    642  O   ASP    78       7.870  56.240  12.365  1.00 22.08           O  
ATOM    643  CB  ASP    78       8.266  56.625   9.159  1.00 23.91           C  
ATOM    644  CG  ASP    78       8.888  57.584   8.160  1.00 19.56           C  
ATOM    645  OD1 ASP    78       9.904  58.282   8.455  1.00 22.27           O  
ATOM    646  OD2 ASP    78       8.328  57.646   7.032  1.00 23.65           O  
ATOM    647  N   GLU    79       8.110  54.294  11.256  1.00 19.40           N  
ATOM    648  CA  GLU    79       7.257  53.515  12.140  1.00 18.58           C  
ATOM    649  C   GLU    79       7.984  53.003  13.407  1.00 19.38           C  
ATOM    650  O   GLU    79       7.387  52.305  14.226  1.00 23.70           O  
ATOM    651  CB  GLU    79       6.646  52.344  11.361  1.00 20.27           C  
ATOM    652  CG  GLU    79       5.647  52.804  10.265  1.00 22.77           C  
ATOM    653  CD  GLU    79       5.568  51.905   9.043  1.00 30.88           C  
ATOM    654  OE1 GLU    79       6.058  50.756   9.116  1.00 25.70           O  
ATOM    655  OE2 GLU    79       5.018  52.361   7.992  1.00 25.40           O  
ATOM    656  N   GLY    80       9.262  53.354  13.564  1.00 17.12           N  
ATOM    657  CA  GLY    80      10.044  52.909  14.737  1.00 17.37           C  
ATOM    658  C   GLY    80      10.604  51.500  14.654  1.00 21.05           C  
ATOM    659  O   GLY    80      11.103  50.971  15.658  1.00 22.12           O  
ATOM    660  N   VAL    81      10.558  50.887  13.467  1.00 19.14           N  
ATOM    661  CA  VAL    81      10.930  49.474  13.314  1.00 20.51           C  
ATOM    662  C   VAL    81      12.445  49.248  13.111  1.00 20.06           C  
ATOM    663  O   VAL    81      13.037  48.268  13.647  1.00 17.76           O  
ATOM    664  CB  VAL    81      10.120  48.806  12.186  1.00 25.27           C  
ATOM    665  CG1 VAL    81      10.474  47.322  12.042  1.00 22.76           C  
ATOM    666  CG2 VAL    81       8.654  48.971  12.458  1.00 20.85           C  
ATOM    667  N   VAL    82      13.073  50.146  12.346  1.00 18.25           N  
ATOM    668  CA  VAL    82      14.499  50.035  12.016  1.00 16.89           C  
ATOM    669  C   VAL    82      15.127  51.393  12.281  1.00 16.23           C  
ATOM    670  O   VAL    82      14.387  52.399  12.357  1.00 19.06           O  
ATOM    671  CB  VAL    82      14.720  49.615  10.509  1.00 18.42           C  
ATOM    672  CG1 VAL    82      13.994  48.315  10.210  1.00 16.44           C  
ATOM    673  CG2 VAL    82      14.267  50.713   9.547  1.00 21.23           C  
ATOM    674  N   PRO    83      16.467  51.445  12.420  1.00 19.03           N  
ATOM    675  CA  PRO    83      17.159  52.709  12.574  1.00 16.16           C  
ATOM    676  C   PRO    83      16.935  53.643  11.408  1.00 19.13           C  
ATOM    677  O   PRO    83      16.727  53.205  10.281  1.00 19.03           O  
ATOM    678  CB  PRO    83      18.633  52.274  12.648  1.00 14.32           C  
ATOM    679  CG  PRO    83      18.580  50.895  13.208  1.00 19.67           C  
ATOM    680  CD  PRO    83      17.423  50.315  12.495  1.00 18.96           C  
ATOM    681  N   ALA    84      16.964  54.937  11.681  1.00 19.88           N  
ATOM    682  CA  ALA    84      16.800  55.923  10.623  1.00 19.34           C  
ATOM    683  C   ALA    84      18.026  55.982   9.719  1.00 17.45           C  
ATOM    684  O   ALA    84      19.150  56.024  10.202  1.00 19.89           O  
ATOM    685  CB  ALA    84      16.552  57.280  11.219  1.00 23.23           C  
ATOM    686  N   PRO    85      17.805  55.997   8.393  1.00 20.18           N  
ATOM    687  CA  PRO    85      18.928  56.220   7.463  1.00 23.79           C  
ATOM    688  C   PRO    85      19.585  57.578   7.699  1.00 26.63           C  
ATOM    689  O   PRO    85      18.905  58.550   8.050  1.00 22.39           O  
ATOM    690  CB  PRO    85      18.282  56.124   6.071  1.00 28.43           C  
ATOM    691  CG  PRO    85      16.819  56.059   6.290  1.00 31.93           C  
ATOM    692  CD  PRO    85      16.530  55.736   7.715  1.00 23.72           C  
ATOM    693  N   ARG    86      20.904  57.637   7.571  1.00 21.40           N  
ATOM    694  CA  ARG    86      21.638  58.873   7.856  1.00 25.10           C  
ATOM    695  C   ARG    86      22.387  59.424   6.647  1.00 26.58           C  
ATOM    696  O   ARG    86      23.023  60.469   6.752  1.00 28.84           O  
ATOM    697  CB  ARG    86      22.602  58.662   9.042  1.00 25.49           C  
ATOM    698  CG  ARG    86      21.896  58.067  10.263  1.00 30.08           C  
ATOM    699  CD  ARG    86      22.607  58.369  11.562  1.00 31.92           C  
ATOM    700  NE  ARG    86      22.427  59.762  11.944  1.00 40.56           N  
ATOM    701  CZ  ARG    86      21.426  60.221  12.691  1.00 33.94           C  
ATOM    702  NH1 ARG    86      21.371  61.511  12.968  1.00 31.03           N  
ATOM    703  NH2 ARG    86      20.491  59.408  13.175  1.00 24.20           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
END
