
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 (  753),  selected   99 , name 1lxn_A
# Molecule2: number of CA atoms   71 (  556),  selected   71 , name T0513_17_85.pdb
# PARAMETERS: 1lxn_A.T0513_17_85.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      N      17           -
LGA    I     2_A      F      18           -
LGA    -       -      V      19           -
LGA    -       -      R      20           -
LGA    -       -      F      21           -
LGA    -       -      V      22           -
LGA    T     3_A      I      23          4.002
LGA    A     4_A      E      24          3.715
LGA    -       -      G      25           -
LGA    -       -      R      26           -
LGA    -       -      R      27           -
LGA    E     5_A      V      28          5.691
LGA    L     6_A      G      29          6.134
LGA    T     7_A      W      30          5.030
LGA    V     8_A      V      31          4.722
LGA    I     9_A      R      32          4.314
LGA    P    10_A      -       -           -
LGA    L    11_A      -       -           -
LGA    G    12_A      -       -           -
LGA    T    13_A      -       -           -
LGA    C    14_A      -       -           -
LGA    S    15_A      -       -           -
LGA    T    16_A      -       -           -
LGA    S    17_A      K      33           #
LGA    L    18_A      A      34          1.406
LGA    -       -      L      35           -
LGA    S    19_A      A      36          5.360
LGA    S    20_A      Q      37          4.307
LGA    Y    21_A      R      38          2.108
LGA    V    22_A      L      39          2.658
LGA    A    23_A      K      40          2.411
LGA    A    24_A      A      41          3.692
LGA    A    25_A      H      42           #
LGA    V    26_A      G      43          4.236
LGA    E    27_A      -       -           -
LGA    A    28_A      -       -           -
LGA    L    29_A      -       -           -
LGA    K    30_A      R      44          1.193
LGA    K    31_A      V      45          6.180
LGA    L    32_A      -       -           -
LGA    N    33_A      -       -           -
LGA    V    34_A      -       -           -
LGA    R    35_A      -       -           -
LGA    Y    36_A      F      46           #
LGA    E    37_A      D      47          3.048
LGA    I    38_A      V      48          2.011
LGA    S    39_A      T      49          2.961
LGA    G    40_A      R      50          2.872
LGA    X    41_A      D      51          3.790
LGA    G    42_A      A      52          3.169
LGA    T    43_A      V      53          1.690
LGA    L    44_A      L      54          1.485
LGA    L    45_A      L      55          2.606
LGA    -       -      S      56           -
LGA    E    46_A      A      57          2.263
LGA    -       -      S      58           -
LGA    A    47_A      L      59          2.864
LGA    E    48_A      R      60          1.778
LGA    D    49_A      T      61          1.081
LGA    L    50_A      P      62          0.986
LGA    D    51_A      Q      63          0.485
LGA    E    52_A      S      64          0.510
LGA    L    53_A      R      65          1.102
LGA    X    54_A      T      66          1.135
LGA    E    55_A      R      67          1.290
LGA    A    56_A      A      68          1.871
LGA    V    57_A      V      69          2.094
LGA    K    58_A      A      70          1.524
LGA    A    59_A      D      71          2.343
LGA    A    60_A      V      72          2.732
LGA    H    61_A      V      73          2.281
LGA    E    62_A      D      74          2.414
LGA    A    63_A      R      75          2.951
LGA    V    64_A      L      76          2.150
LGA    L    65_A      A      77          1.368
LGA    Q    66_A      D      78          2.323
LGA    A    67_A      E      79          2.516
LGA    G    68_A      G      80          1.874
LGA    S    69_A      V      81          2.146
LGA    D    70_A      V      82          5.135
LGA    R    71_A      P      83          3.451
LGA    V    72_A      A      84           #
LGA    Y    73_A      P      85           -
LGA    T    74_A      R      86           -
LGA    T    75_A      G      87           -
LGA    L    76_A      -       -           -
LGA    K    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    D    80_A      -       -           -
LGA    R    81_A      -       -           -
LGA    R    82_A      -       -           -
LGA    D    83_A      -       -           -
LGA    A    84_A      -       -           -
LGA    D    85_A      -       -           -
LGA    R    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    L    88_A      -       -           -
LGA    R    89_A      -       -           -
LGA    D    90_A      -       -           -
LGA    K    91_A      -       -           -
LGA    V    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    V    95_A      -       -           -
LGA    K    96_A      -       -           -
LGA    E    97_A      -       -           -
LGA    K    98_A      -       -           -
LGA    I    99_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99   71    5.0     52    3.10    13.46     50.930     1.623

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.524005 * X  +  -0.421582 * Y  +   0.740059 * Z  + -31.079250
  Y_new =  -0.146760 * X  +   0.811215 * Y  +   0.566032 * Z  +  13.600601
  Z_new =  -0.838976 * X  +  -0.405215 * Y  +   0.363209 * Z  + 121.411690 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.840008    2.301585  [ DEG:   -48.1289    131.8711 ]
  Theta =   0.995398    2.146195  [ DEG:    57.0321    122.9679 ]
  Phi   =  -0.273077    2.868516  [ DEG:   -15.6462    164.3538 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1lxn_A                                        
REMARK     2: T0513_17_85.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1lxn_A.T0513_17_85.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99   71   5.0   52   3.10   13.46  50.930
REMARK  ---------------------------------------------------------- 
MOLECULE 1lxn_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   05-JUN-02   1LXN              
TITLE     X-RAY STRUCTURE OF MTH1187 NORTHEAST STRUCTURAL GENOMICS              
TITLE    2 CONSORTIUM TARGET TT272                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN MTH1187;                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOBACTERIUM THERMOAUTOTROPHICUM;           
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    HYPOTHETICAL STRUCTURE, STRUCTURAL GENOMICS, PSI, PROTEIN             
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    X.TAO,R.KHAYAT,D.CHRISTENDAT,A.SAVCHENKO,X.XU,A.EDWARDS,              
AUTHOR   2 C.H.ARROWSMITH,L.TONG,NORTHEAST STRUCTURAL GENOMICS                  
AUTHOR   3 CONSORTIUM (NESG)                                                    
REVDAT   2   25-JAN-05 1LXN    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   29-JUL-03 1LXN    0                                                
JRNL        AUTH   X.TAO,R.KHAYAT,D.CHRISTENDAT,A.SAVCHENKO,X.XU,               
JRNL        AUTH 2 S.GOLDSMITH-FISCHMAN,B.HONIG,A.EDWARDS,                      
JRNL        AUTH 3 C.H.ARROWSMITH,L.TONG                                        
JRNL        TITL   CRYSTAL STRUCTURES OF MTH1187 AND ITS YEAST                  
JRNL        TITL 2 ORTHOLOG YBL001C                                             
JRNL        REF    PROTEINS: STRUCT., FUNCT.,    V.  52   478 2003              
JRNL        REF  2 GENET.                                                       
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1LXN A    1    99  UNP    O27255   Y1187_METTH      1     99             
DBREF  1LXN B 1001  1099  UNP    O27255   Y1187_METTH      1     99             
DBREF  1LXN C 2001  2099  UNP    O27255   Y1187_METTH      1     99             
DBREF  1LXN D 3001  3099  UNP    O27255   Y1187_METTH      1     99             
SEQRES   1 A   99  MSE ILE THR ALA GLU LEU THR VAL ILE PRO LEU GLY THR          
SEQRES   2 A   99  CYS SER THR SER LEU SER SER TYR VAL ALA ALA ALA VAL          
SEQRES   3 A   99  GLU ALA LEU LYS LYS LEU ASN VAL ARG TYR GLU ILE SER          
SEQRES   4 A   99  GLY MSE GLY THR LEU LEU GLU ALA GLU ASP LEU ASP GLU          
SEQRES   5 A   99  LEU MSE GLU ALA VAL LYS ALA ALA HIS GLU ALA VAL LEU          
SEQRES   6 A   99  GLN ALA GLY SER ASP ARG VAL TYR THR THR LEU LYS ILE          
SEQRES   7 A   99  ASP ASP ARG ARG ASP ALA ASP ARG GLY LEU ARG ASP LYS          
SEQRES   8 A   99  VAL GLU SER VAL LYS GLU LYS ILE                              
SEQRES   1 B   99  MSE ILE THR ALA GLU LEU THR VAL ILE PRO LEU GLY THR          
SEQRES   2 B   99  CYS SER THR SER LEU SER SER TYR VAL ALA ALA ALA VAL          
SEQRES   3 B   99  GLU ALA LEU LYS LYS LEU ASN VAL ARG TYR GLU ILE SER          
SEQRES   4 B   99  GLY MSE GLY THR LEU LEU GLU ALA GLU ASP LEU ASP GLU          
SEQRES   5 B   99  LEU MSE GLU ALA VAL LYS ALA ALA HIS GLU ALA VAL LEU          
SEQRES   6 B   99  GLN ALA GLY SER ASP ARG VAL TYR THR THR LEU LYS ILE          
SEQRES   7 B   99  ASP ASP ARG ARG ASP ALA ASP ARG GLY LEU ARG ASP LYS          
SEQRES   8 B   99  VAL GLU SER VAL LYS GLU LYS ILE                              
SEQRES   1 C   99  MSE ILE THR ALA GLU LEU THR VAL ILE PRO LEU GLY THR          
SEQRES   2 C   99  CYS SER THR SER LEU SER SER TYR VAL ALA ALA ALA VAL          
SEQRES   3 C   99  GLU ALA LEU LYS LYS LEU ASN VAL ARG TYR GLU ILE SER          
SEQRES   4 C   99  GLY MSE GLY THR LEU LEU GLU ALA GLU ASP LEU ASP GLU          
SEQRES   5 C   99  LEU MSE GLU ALA VAL LYS ALA ALA HIS GLU ALA VAL LEU          
SEQRES   6 C   99  GLN ALA GLY SER ASP ARG VAL TYR THR THR LEU LYS ILE          
SEQRES   7 C   99  ASP ASP ARG ARG ASP ALA ASP ARG GLY LEU ARG ASP LYS          
SEQRES   8 C   99  VAL GLU SER VAL LYS GLU LYS ILE                              
SEQRES   1 D   99  MSE ILE THR ALA GLU LEU THR VAL ILE PRO LEU GLY THR          
SEQRES   2 D   99  CYS SER THR SER LEU SER SER TYR VAL ALA ALA ALA VAL          
SEQRES   3 D   99  GLU ALA LEU LYS LYS LEU ASN VAL ARG TYR GLU ILE SER          
SEQRES   4 D   99  GLY MSE GLY THR LEU LEU GLU ALA GLU ASP LEU ASP GLU          
SEQRES   5 D   99  LEU MSE GLU ALA VAL LYS ALA ALA HIS GLU ALA VAL LEU          
SEQRES   6 D   99  GLN ALA GLY SER ASP ARG VAL TYR THR THR LEU LYS ILE          
SEQRES   7 D   99  ASP ASP ARG ARG ASP ALA ASP ARG GLY LEU ARG ASP LYS          
SEQRES   8 D   99  VAL GLU SER VAL LYS GLU LYS ILE                              
HET    MSE  A   1       8                                                       
HET    MSE  A  41       8                                                       
HET    MSE  A  54       8                                                       
HET    MSE  B1001       8                                                       
HET    MSE  B1041       8                                                       
HET    MSE  B1054       8                                                       
HET    MSE  C2001       8                                                       
HET    MSE  C2041       8                                                       
HET    MSE  C2054       8                                                       
HET    MSE  D3001       8                                                       
HET    MSE  D3041       8                                                       
HET    MSE  D3054       8                                                       
HET    SO4    161       5                                                       
HET    SO4    261       5                                                       
HET    SO4    361       5                                                       
HET    SO4    461       5                                                       
HET    SO4    561       5                                                       
HET    SO4    661       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   5  SO4    6(O4 S 2-)                                                   
FORMUL  11  HOH   *139(H2 O)                                                    
CRYST1  175.365  175.365  175.365  90.00  90.00  90.00 P 41 3 2     96          
HETATM    1  N   MSE A   1      19.166  40.252 -15.339  1.00 38.98           N  
HETATM    2  CA  MSE A   1      18.645  39.318 -14.292  1.00 38.86           C  
HETATM    3  C   MSE A   1      19.551  39.190 -13.069  1.00 34.38           C  
HETATM    4  O   MSE A   1      20.501  38.407 -13.066  1.00 34.46           O  
HETATM    5  CB  MSE A   1      18.421  37.927 -14.885  1.00 45.08           C  
HETATM    6  CG  MSE A   1      17.975  36.899 -13.855  1.00 52.27           C  
HETATM    7 SE   MSE A   1      16.465  37.532 -12.814  1.00 68.10          SE  
HETATM    8  CE  MSE A   1      15.037  37.099 -14.057  1.00 61.83           C  
ATOM      9  N   ILE A   2      19.243  39.951 -12.026  1.00 28.88           N  
ATOM     10  CA  ILE A   2      20.024  39.919 -10.793  1.00 25.18           C  
ATOM     11  C   ILE A   2      19.228  39.203  -9.695  1.00 24.45           C  
ATOM     12  O   ILE A   2      18.025  39.434  -9.545  1.00 22.45           O  
ATOM     13  CB  ILE A   2      20.346  41.361 -10.306  1.00 24.38           C  
ATOM     14  CG1 ILE A   2      21.059  42.140 -11.411  1.00 25.40           C  
ATOM     15  CG2 ILE A   2      21.215  41.318  -9.063  1.00 22.12           C  
ATOM     16  CD1 ILE A   2      21.319  43.606 -11.068  1.00 25.63           C  
ATOM     17  N   THR A   3      19.888  38.324  -8.946  1.00 22.23           N  
ATOM     18  CA  THR A   3      19.220  37.628  -7.844  1.00 21.68           C  
ATOM     19  C   THR A   3      19.802  38.135  -6.530  1.00 21.36           C  
ATOM     20  O   THR A   3      20.992  38.450  -6.436  1.00 20.04           O  
ATOM     21  CB  THR A   3      19.397  36.083  -7.904  1.00 21.23           C  
ATOM     22  OG1 THR A   3      20.789  35.757  -8.022  1.00 20.66           O  
ATOM     23  CG2 THR A   3      18.613  35.497  -9.077  1.00 20.39           C  
ATOM     24  N   ALA A   4      18.962  38.211  -5.509  1.00 20.69           N  
ATOM     25  CA  ALA A   4      19.412  38.710  -4.223  1.00 20.28           C  
ATOM     26  C   ALA A   4      18.533  38.220  -3.090  1.00 19.00           C  
ATOM     27  O   ALA A   4      17.484  37.618  -3.312  1.00 19.31           O  
ATOM     28  CB  ALA A   4      19.416  40.244  -4.244  1.00 19.13           C  
ATOM     29  N   GLU A   5      18.982  38.486  -1.872  1.00 19.84           N  
ATOM     30  CA  GLU A   5      18.233  38.133  -0.679  1.00 20.64           C  
ATOM     31  C   GLU A   5      18.302  39.313   0.273  1.00 19.51           C  
ATOM     32  O   GLU A   5      19.365  39.904   0.473  1.00 19.18           O  
ATOM     33  CB  GLU A   5      18.806  36.893   0.007  1.00 22.43           C  
ATOM     34  CG  GLU A   5      18.076  36.578   1.299  1.00 27.48           C  
ATOM     35  CD  GLU A   5      18.406  35.209   1.853  1.00 33.39           C  
ATOM     36  OE1 GLU A   5      17.836  34.852   2.906  1.00 35.78           O  
ATOM     37  OE2 GLU A   5      19.228  34.493   1.242  1.00 35.19           O  
ATOM     38  N   LEU A   6      17.164  39.645   0.868  1.00 19.09           N  
ATOM     39  CA  LEU A   6      17.090  40.768   1.784  1.00 17.48           C  
ATOM     40  C   LEU A   6      16.448  40.396   3.110  1.00 19.50           C  
ATOM     41  O   LEU A   6      15.411  39.734   3.142  1.00 15.25           O  
ATOM     42  CB  LEU A   6      16.277  41.892   1.142  1.00 17.03           C  
ATOM     43  CG  LEU A   6      15.929  43.058   2.066  1.00 20.10           C  
ATOM     44  CD1 LEU A   6      17.183  43.882   2.364  1.00 17.14           C  
ATOM     45  CD2 LEU A   6      14.854  43.911   1.404  1.00 19.04           C  
ATOM     46  N   THR A   7      17.074  40.822   4.204  1.00 19.68           N  
ATOM     47  CA  THR A   7      16.522  40.582   5.528  1.00 21.91           C  
ATOM     48  C   THR A   7      16.599  41.919   6.256  1.00 21.61           C  
ATOM     49  O   THR A   7      17.672  42.514   6.370  1.00 22.73           O  
ATOM     50  CB  THR A   7      17.322  39.529   6.336  1.00 24.10           C  
ATOM     51  OG1 THR A   7      18.521  40.127   6.838  1.00 31.92           O  
ATOM     52  CG2 THR A   7      17.700  38.340   5.455  1.00 25.67           C  
ATOM     53  N   VAL A   8      15.449  42.411   6.701  1.00 20.22           N  
ATOM     54  CA  VAL A   8      15.379  43.664   7.437  1.00 21.33           C  
ATOM     55  C   VAL A   8      14.969  43.239   8.839  1.00 22.21           C  
ATOM     56  O   VAL A   8      13.868  42.736   9.038  1.00 24.45           O  
ATOM     57  CB  VAL A   8      14.315  44.609   6.846  1.00 21.46           C  
ATOM     58  CG1 VAL A   8      14.347  45.949   7.574  1.00 19.99           C  
ATOM     59  CG2 VAL A   8      14.564  44.809   5.358  1.00 18.92           C  
ATOM     60  N   ILE A   9      15.860  43.427   9.804  1.00 20.82           N  
ATOM     61  CA  ILE A   9      15.588  43.007  11.171  1.00 19.92           C  
ATOM     62  C   ILE A   9      15.582  44.160  12.167  1.00 19.79           C  
ATOM     63  O   ILE A   9      16.614  44.755  12.450  1.00 19.43           O  
ATOM     64  CB  ILE A   9      16.637  41.963  11.634  1.00 19.82           C  
ATOM     65  CG1 ILE A   9      16.747  40.835  10.600  1.00 19.31           C  
ATOM     66  CG2 ILE A   9      16.250  41.394  12.991  1.00 19.55           C  
ATOM     67  CD1 ILE A   9      17.801  39.782  10.927  1.00 20.58           C  
ATOM     68  N   PRO A  10      14.403  44.505  12.697  1.00 19.74           N  
ATOM     69  CA  PRO A  10      14.345  45.601  13.669  1.00 18.67           C  
ATOM     70  C   PRO A  10      14.880  45.079  14.998  1.00 17.90           C  
ATOM     71  O   PRO A  10      14.616  43.936  15.366  1.00 16.16           O  
ATOM     72  CB  PRO A  10      12.857  45.940  13.718  1.00 18.77           C  
ATOM     73  CG  PRO A  10      12.201  44.603  13.451  1.00 19.11           C  
ATOM     74  CD  PRO A  10      13.054  44.025  12.341  1.00 18.39           C  
ATOM     75  N   LEU A  11      15.645  45.911  15.697  1.00 18.16           N  
ATOM     76  CA  LEU A  11      16.232  45.533  16.979  1.00 19.31           C  
ATOM     77  C   LEU A  11      15.642  46.355  18.137  1.00 20.55           C  
ATOM     78  O   LEU A  11      15.278  47.514  17.960  1.00 20.88           O  
ATOM     79  CB  LEU A  11      17.749  45.737  16.919  1.00 20.07           C  
ATOM     80  CG  LEU A  11      18.490  45.070  15.751  1.00 20.50           C  
ATOM     81  CD1 LEU A  11      19.978  45.394  15.836  1.00 18.53           C  
ATOM     82  CD2 LEU A  11      18.276  43.559  15.802  1.00 17.03           C  
ATOM     83  N   GLY A  12      15.559  45.752  19.320  1.00 21.14           N  
ATOM     84  CA  GLY A  12      15.008  46.448  20.472  1.00 22.96           C  
ATOM     85  C   GLY A  12      13.510  46.658  20.332  1.00 25.25           C  
ATOM     86  O   GLY A  12      12.959  47.647  20.806  1.00 26.16           O  
ATOM     87  N   THR A  13      12.860  45.698  19.688  1.00 24.10           N  
ATOM     88  CA  THR A  13      11.426  45.723  19.413  1.00 25.71           C  
ATOM     89  C   THR A  13      10.526  45.382  20.617  1.00 25.80           C  
ATOM     90  O   THR A  13       9.337  45.704  20.624  1.00 24.27           O  
ATOM     91  CB  THR A  13      11.150  44.761  18.213  1.00 25.48           C  
ATOM     92  OG1 THR A  13      11.294  45.493  16.986  1.00 28.66           O  
ATOM     93  CG2 THR A  13       9.786  44.132  18.282  1.00 30.10           C  
ATOM     94  N   CYS A  14      11.111  44.748  21.630  1.00 24.41           N  
ATOM     95  CA  CYS A  14      10.407  44.329  22.843  1.00 24.38           C  
ATOM     96  C   CYS A  14       9.306  43.336  22.502  1.00 24.14           C  
ATOM     97  O   CYS A  14       8.213  43.363  23.074  1.00 23.82           O  
ATOM     98  CB  CYS A  14       9.823  45.526  23.598  1.00 24.55           C  
ATOM     99  SG  CYS A  14       9.504  45.251  25.381  1.00 25.33           S  
ATOM    100  N   SER A  15       9.623  42.468  21.549  1.00 22.26           N  
ATOM    101  CA  SER A  15       8.740  41.403  21.101  1.00 19.48           C  
ATOM    102  C   SER A  15       9.557  40.507  20.186  1.00 20.53           C  
ATOM    103  O   SER A  15      10.241  40.995  19.284  1.00 20.32           O  
ATOM    104  CB  SER A  15       7.550  41.953  20.326  1.00 18.72           C  
ATOM    105  OG  SER A  15       6.773  40.884  19.809  1.00 15.85           O  
ATOM    106  N   THR A  16       9.486  39.204  20.416  1.00 19.81           N  
ATOM    107  CA  THR A  16      10.225  38.246  19.605  1.00 20.77           C  
ATOM    108  C   THR A  16       9.487  37.914  18.316  1.00 21.04           C  
ATOM    109  O   THR A  16       9.957  37.112  17.510  1.00 21.52           O  
ATOM    110  CB  THR A  16      10.477  36.945  20.376  1.00 19.48           C  
ATOM    111  OG1 THR A  16       9.236  36.469  20.909  1.00 20.39           O  
ATOM    112  CG2 THR A  16      11.476  37.186  21.512  1.00 19.37           C  
ATOM    113  N   SER A  17       8.326  38.523  18.126  1.00 22.89           N  
ATOM    114  CA  SER A  17       7.556  38.292  16.910  1.00 25.40           C  
ATOM    115  C   SER A  17       7.793  39.489  15.991  1.00 25.11           C  
ATOM    116  O   SER A  17       7.376  40.601  16.303  1.00 26.52           O  
ATOM    117  CB  SER A  17       6.072  38.159  17.235  1.00 26.20           C  
ATOM    118  OG  SER A  17       5.327  38.057  16.033  1.00 34.42           O  
ATOM    119  N   LEU A  18       8.456  39.248  14.861  1.00 25.17           N  
ATOM    120  CA  LEU A  18       8.801  40.309  13.914  1.00 23.94           C  
ATOM    121  C   LEU A  18       8.037  40.306  12.583  1.00 24.28           C  
ATOM    122  O   LEU A  18       8.312  41.131  11.711  1.00 24.11           O  
ATOM    123  CB  LEU A  18      10.301  40.231  13.615  1.00 24.56           C  
ATOM    124  CG  LEU A  18      11.251  40.081  14.815  1.00 25.46           C  
ATOM    125  CD1 LEU A  18      12.682  40.033  14.319  1.00 23.50           C  
ATOM    126  CD2 LEU A  18      11.062  41.244  15.793  1.00 20.76           C  
ATOM    127  N   SER A  19       7.085  39.392  12.428  1.00 22.99           N  
ATOM    128  CA  SER A  19       6.315  39.269  11.192  1.00 23.17           C  
ATOM    129  C   SER A  19       5.640  40.521  10.653  1.00 23.56           C  
ATOM    130  O   SER A  19       5.588  40.716   9.437  1.00 23.56           O  
ATOM    131  CB  SER A  19       5.259  38.176  11.345  1.00 24.80           C  
ATOM    132  OG  SER A  19       5.882  36.916  11.454  1.00 29.37           O  
ATOM    133  N   SER A  20       5.102  41.359  11.535  1.00 21.11           N  
ATOM    134  CA  SER A  20       4.431  42.570  11.082  1.00 20.34           C  
ATOM    135  C   SER A  20       5.444  43.560  10.535  1.00 19.53           C  
ATOM    136  O   SER A  20       5.144  44.326   9.616  1.00 18.90           O  
ATOM    137  CB  SER A  20       3.628  43.204  12.225  1.00 19.49           C  
ATOM    138  OG  SER A  20       2.602  42.323  12.648  1.00 21.10           O  
ATOM    139  N   TYR A  21       6.641  43.554  11.111  1.00 19.41           N  
ATOM    140  CA  TYR A  21       7.693  44.450  10.647  1.00 20.84           C  
ATOM    141  C   TYR A  21       8.162  43.993   9.269  1.00 20.72           C  
ATOM    142  O   TYR A  21       8.375  44.811   8.376  1.00 21.52           O  
ATOM    143  CB  TYR A  21       8.877  44.443  11.617  1.00 20.72           C  
ATOM    144  CG  TYR A  21       8.725  45.396  12.778  1.00 20.64           C  
ATOM    145  CD1 TYR A  21       8.719  46.775  12.574  1.00 18.53           C  
ATOM    146  CD2 TYR A  21       8.614  44.921  14.082  1.00 19.80           C  
ATOM    147  CE1 TYR A  21       8.610  47.653  13.638  1.00 20.61           C  
ATOM    148  CE2 TYR A  21       8.506  45.798  15.158  1.00 22.29           C  
ATOM    149  CZ  TYR A  21       8.507  47.158  14.929  1.00 22.27           C  
ATOM    150  OH  TYR A  21       8.411  48.029  15.992  1.00 29.30           O  
ATOM    151  N   VAL A  22       8.312  42.681   9.104  1.00 19.32           N  
ATOM    152  CA  VAL A  22       8.754  42.126   7.833  1.00 20.17           C  
ATOM    153  C   VAL A  22       7.693  42.328   6.748  1.00 20.80           C  
ATOM    154  O   VAL A  22       8.022  42.637   5.603  1.00 20.28           O  
ATOM    155  CB  VAL A  22       9.083  40.628   7.962  1.00 21.09           C  
ATOM    156  CG1 VAL A  22       9.534  40.076   6.613  1.00 18.59           C  
ATOM    157  CG2 VAL A  22      10.188  40.429   9.012  1.00 20.26           C  
ATOM    158  N   ALA A  23       6.423  42.152   7.105  1.00 20.09           N  
ATOM    159  CA  ALA A  23       5.350  42.357   6.139  1.00 18.67           C  
ATOM    160  C   ALA A  23       5.397  43.813   5.668  1.00 16.51           C  
ATOM    161  O   ALA A  23       5.192  44.089   4.495  1.00 16.07           O  
ATOM    162  CB  ALA A  23       3.989  42.043   6.764  1.00 17.37           C  
ATOM    163  N   ALA A  24       5.668  44.745   6.578  1.00 15.76           N  
ATOM    164  CA  ALA A  24       5.749  46.153   6.183  1.00 18.20           C  
ATOM    165  C   ALA A  24       6.924  46.361   5.212  1.00 18.79           C  
ATOM    166  O   ALA A  24       6.826  47.140   4.264  1.00 20.36           O  
ATOM    167  CB  ALA A  24       5.925  47.046   7.404  1.00 16.46           C  
ATOM    168  N   ALA A  25       8.036  45.675   5.454  1.00 17.18           N  
ATOM    169  CA  ALA A  25       9.192  45.794   4.570  1.00 18.27           C  
ATOM    170  C   ALA A  25       8.829  45.273   3.185  1.00 18.84           C  
ATOM    171  O   ALA A  25       9.138  45.905   2.177  1.00 18.88           O  
ATOM    172  CB  ALA A  25      10.376  45.007   5.125  1.00 17.07           C  
ATOM    173  N   VAL A  26       8.160  44.122   3.139  1.00 20.15           N  
ATOM    174  CA  VAL A  26       7.774  43.525   1.866  1.00 21.16           C  
ATOM    175  C   VAL A  26       6.752  44.391   1.138  1.00 24.28           C  
ATOM    176  O   VAL A  26       6.803  44.536  -0.088  1.00 24.56           O  
ATOM    177  CB  VAL A  26       7.194  42.105   2.070  1.00 22.18           C  
ATOM    178  CG1 VAL A  26       6.711  41.535   0.735  1.00 19.32           C  
ATOM    179  CG2 VAL A  26       8.263  41.192   2.685  1.00 20.43           C  
ATOM    180  N   GLU A  27       5.828  44.969   1.897  1.00 24.35           N  
ATOM    181  CA  GLU A  27       4.801  45.820   1.320  1.00 25.26           C  
ATOM    182  C   GLU A  27       5.469  46.988   0.591  1.00 24.42           C  
ATOM    183  O   GLU A  27       4.997  47.428  -0.459  1.00 22.07           O  
ATOM    184  CB  GLU A  27       3.881  46.353   2.420  1.00 28.82           C  
ATOM    185  CG  GLU A  27       2.476  46.682   1.946  1.00 37.75           C  
ATOM    186  CD  GLU A  27       1.552  45.468   1.968  1.00 43.89           C  
ATOM    187  OE1 GLU A  27       1.223  44.992   3.084  1.00 47.07           O  
ATOM    188  OE2 GLU A  27       1.159  44.990   0.878  1.00 44.47           O  
ATOM    189  N   ALA A  28       6.569  47.487   1.150  1.00 21.95           N  
ATOM    190  CA  ALA A  28       7.289  48.596   0.531  1.00 23.38           C  
ATOM    191  C   ALA A  28       8.006  48.118  -0.731  1.00 24.30           C  
ATOM    192  O   ALA A  28       8.075  48.841  -1.723  1.00 22.40           O  
ATOM    193  CB  ALA A  28       8.289  49.193   1.516  1.00 22.46           C  
ATOM    194  N   LEU A  29       8.531  46.892  -0.678  1.00 26.67           N  
ATOM    195  CA  LEU A  29       9.237  46.263  -1.800  1.00 29.08           C  
ATOM    196  C   LEU A  29       8.316  46.099  -3.001  1.00 29.59           C  
ATOM    197  O   LEU A  29       8.709  46.346  -4.138  1.00 32.31           O  
ATOM    198  CB  LEU A  29       9.734  44.863  -1.412  1.00 29.25           C  
ATOM    199  CG  LEU A  29      11.051  44.685  -0.674  1.00 30.57           C  
ATOM    200  CD1 LEU A  29      11.155  43.268  -0.133  1.00 30.25           C  
ATOM    201  CD2 LEU A  29      12.196  44.980  -1.627  1.00 34.37           C  
ATOM    202  N   LYS A  30       7.095  45.654  -2.728  1.00 30.03           N  
ATOM    203  CA  LYS A  30       6.087  45.412  -3.756  1.00 30.53           C  
ATOM    204  C   LYS A  30       5.810  46.596  -4.676  1.00 28.84           C  
ATOM    205  O   LYS A  30       5.286  46.413  -5.773  1.00 29.66           O  
ATOM    206  CB  LYS A  30       4.770  44.982  -3.098  1.00 30.58           C  
ATOM    207  CG  LYS A  30       4.848  43.670  -2.346  1.00 35.70           C  
ATOM    208  CD  LYS A  30       3.571  43.390  -1.554  1.00 37.29           C  
ATOM    209  CE  LYS A  30       2.353  43.244  -2.454  1.00 39.61           C  
ATOM    210  NZ  LYS A  30       1.115  42.946  -1.668  1.00 41.25           N  
ATOM    211  N   LYS A  31       6.142  47.802  -4.229  1.00 26.08           N  
ATOM    212  CA  LYS A  31       5.889  48.995  -5.027  1.00 25.82           C  
ATOM    213  C   LYS A  31       6.927  49.253  -6.114  1.00 25.22           C  
ATOM    214  O   LYS A  31       6.692  50.061  -7.014  1.00 23.85           O  
ATOM    215  CB  LYS A  31       5.788  50.223  -4.121  1.00 26.09           C  
ATOM    216  CG  LYS A  31       4.754  50.092  -3.016  1.00 26.21           C  
ATOM    217  CD  LYS A  31       4.595  51.405  -2.270  1.00 30.31           C  
ATOM    218  CE  LYS A  31       3.689  51.250  -1.055  1.00 31.91           C  
ATOM    219  NZ  LYS A  31       2.488  50.439  -1.388  1.00 31.50           N  
ATOM    220  N   LEU A  32       8.072  48.580  -6.031  1.00 24.28           N  
ATOM    221  CA  LEU A  32       9.128  48.758  -7.024  1.00 25.07           C  
ATOM    222  C   LEU A  32       9.028  47.681  -8.088  1.00 24.93           C  
ATOM    223  O   LEU A  32       8.314  46.698  -7.916  1.00 24.39           O  
ATOM    224  CB  LEU A  32      10.516  48.727  -6.364  1.00 23.92           C  
ATOM    225  CG  LEU A  32      10.943  49.970  -5.562  1.00 25.47           C  
ATOM    226  CD1 LEU A  32      10.885  51.205  -6.463  1.00 25.06           C  
ATOM    227  CD2 LEU A  32      10.041  50.169  -4.358  1.00 21.30           C  
ATOM    228  N   ASN A  33       9.749  47.858  -9.187  1.00 24.75           N  
ATOM    229  CA  ASN A  33       9.695  46.886 -10.267  1.00 25.76           C  
ATOM    230  C   ASN A  33      10.613  45.683 -10.062  1.00 25.68           C  
ATOM    231  O   ASN A  33      11.515  45.434 -10.857  1.00 24.50           O  
ATOM    232  CB  ASN A  33      10.011  47.567 -11.597  1.00 28.87           C  
ATOM    233  CG  ASN A  33       9.684  46.688 -12.785  1.00 35.45           C  
ATOM    234  OD1 ASN A  33       8.621  46.059 -12.829  1.00 38.90           O  
ATOM    235  ND2 ASN A  33      10.588  46.640 -13.762  1.00 36.23           N  
ATOM    236  N   VAL A  34      10.377  44.938  -8.987  1.00 25.01           N  
ATOM    237  CA  VAL A  34      11.167  43.748  -8.690  1.00 24.38           C  
ATOM    238  C   VAL A  34      10.243  42.575  -8.384  1.00 25.09           C  
ATOM    239  O   VAL A  34       9.083  42.766  -8.017  1.00 25.53           O  
ATOM    240  CB  VAL A  34      12.077  43.951  -7.452  1.00 24.21           C  
ATOM    241  CG1 VAL A  34      13.016  45.130  -7.672  1.00 23.95           C  
ATOM    242  CG2 VAL A  34      11.219  44.160  -6.200  1.00 22.17           C  
ATOM    243  N   ARG A  35      10.748  41.361  -8.554  1.00 24.98           N  
ATOM    244  CA  ARG A  35       9.966  40.179  -8.224  1.00 26.60           C  
ATOM    245  C   ARG A  35      10.523  39.720  -6.885  1.00 25.12           C  
ATOM    246  O   ARG A  35      11.709  39.883  -6.615  1.00 23.02           O  
ATOM    247  CB  ARG A  35      10.150  39.085  -9.275  1.00 29.82           C  
ATOM    248  CG  ARG A  35       9.437  39.361 -10.589  1.00 36.31           C  
ATOM    249  CD  ARG A  35       9.810  38.331 -11.648  1.00 43.33           C  
ATOM    250  NE  ARG A  35       9.088  38.545 -12.901  1.00 49.91           N  
ATOM    251  CZ  ARG A  35       9.379  37.935 -14.046  1.00 53.68           C  
ATOM    252  NH1 ARG A  35      10.386  37.069 -14.102  1.00 55.83           N  
ATOM    253  NH2 ARG A  35       8.667  38.190 -15.139  1.00 54.27           N  
ATOM    254  N   TYR A  36       9.674  39.165  -6.033  1.00 24.79           N  
ATOM    255  CA  TYR A  36      10.144  38.717  -4.735  1.00 23.74           C  
ATOM    256  C   TYR A  36       9.511  37.390  -4.346  1.00 23.66           C  
ATOM    257  O   TYR A  36       8.494  36.978  -4.902  1.00 22.63           O  
ATOM    258  CB  TYR A  36       9.835  39.779  -3.671  1.00 24.77           C  
ATOM    259  CG  TYR A  36       8.380  39.840  -3.259  1.00 27.80           C  
ATOM    260  CD1 TYR A  36       7.876  38.985  -2.278  1.00 29.32           C  
ATOM    261  CD2 TYR A  36       7.499  40.730  -3.871  1.00 31.34           C  
ATOM    262  CE1 TYR A  36       6.526  39.012  -1.917  1.00 31.69           C  
ATOM    263  CE2 TYR A  36       6.148  40.764  -3.521  1.00 32.48           C  
ATOM    264  CZ  TYR A  36       5.669  39.904  -2.543  1.00 32.33           C  
ATOM    265  OH  TYR A  36       4.337  39.947  -2.187  1.00 35.42           O  
ATOM    266  N   GLU A  37      10.130  36.727  -3.383  1.00 23.95           N  
ATOM    267  CA  GLU A  37       9.636  35.461  -2.878  1.00 24.80           C  
ATOM    268  C   GLU A  37      10.032  35.388  -1.411  1.00 24.25           C  
ATOM    269  O   GLU A  37      11.218  35.424  -1.077  1.00 21.44           O  
ATOM    270  CB  GLU A  37      10.254  34.295  -3.650  1.00 28.10           C  
ATOM    271  CG  GLU A  37       9.738  32.934  -3.217  1.00 36.56           C  
ATOM    272  CD  GLU A  37      10.389  31.782  -3.970  1.00 41.92           C  
ATOM    273  OE1 GLU A  37      11.631  31.629  -3.885  1.00 44.71           O  
ATOM    274  OE2 GLU A  37       9.655  31.027  -4.647  1.00 46.67           O  
ATOM    275  N   ILE A  38       9.034  35.314  -0.536  1.00 23.07           N  
ATOM    276  CA  ILE A  38       9.275  35.231   0.897  1.00 22.37           C  
ATOM    277  C   ILE A  38       9.776  33.830   1.255  1.00 22.36           C  
ATOM    278  O   ILE A  38       9.122  32.843   0.935  1.00 21.65           O  
ATOM    279  CB  ILE A  38       7.973  35.524   1.677  1.00 24.61           C  
ATOM    280  CG1 ILE A  38       7.484  36.936   1.342  1.00 23.52           C  
ATOM    281  CG2 ILE A  38       8.216  35.387   3.179  1.00 25.10           C  
ATOM    282  CD1 ILE A  38       6.052  37.200   1.720  1.00 24.29           C  
ATOM    283  N   SER A  39      10.944  33.746   1.894  1.00 22.42           N  
ATOM    284  CA  SER A  39      11.509  32.457   2.298  1.00 23.42           C  
ATOM    285  C   SER A  39      11.674  32.437   3.815  1.00 24.59           C  
ATOM    286  O   SER A  39      11.545  33.467   4.480  1.00 25.43           O  
ATOM    287  CB  SER A  39      12.873  32.210   1.641  1.00 24.75           C  
ATOM    288  OG  SER A  39      13.935  32.609   2.504  1.00 30.36           O  
ATOM    289  N   GLY A  40      11.983  31.268   4.360  1.00 23.96           N  
ATOM    290  CA  GLY A  40      12.127  31.145   5.800  1.00 25.74           C  
ATOM    291  C   GLY A  40      13.218  31.963   6.468  1.00 25.75           C  
ATOM    292  O   GLY A  40      13.166  32.165   7.681  1.00 26.73           O  
HETATM  293  N   MSE A  41      14.194  32.445   5.704  1.00 24.20           N  
HETATM  294  CA  MSE A  41      15.290  33.215   6.293  1.00 25.79           C  
HETATM  295  C   MSE A  41      15.512  34.601   5.695  1.00 25.46           C  
HETATM  296  O   MSE A  41      16.542  35.222   5.941  1.00 27.56           O  
HETATM  297  CB  MSE A  41      16.591  32.413   6.197  1.00 26.96           C  
HETATM  298  CG  MSE A  41      16.610  31.132   7.037  1.00 27.91           C  
HETATM  299 SE   MSE A  41      16.473  31.477   8.946  1.00 34.32          SE  
HETATM  300  CE  MSE A  41      18.237  32.223   9.261  1.00 25.56           C  
ATOM    301  N   GLY A  42      14.547  35.083   4.919  1.00 26.01           N  
ATOM    302  CA  GLY A  42      14.666  36.387   4.287  1.00 23.50           C  
ATOM    303  C   GLY A  42      13.913  36.393   2.971  1.00 24.30           C  
ATOM    304  O   GLY A  42      13.483  35.335   2.498  1.00 26.94           O  
ATOM    305  N   THR A  43      13.737  37.570   2.375  1.00 22.47           N  
ATOM    306  CA  THR A  43      13.024  37.675   1.108  1.00 22.14           C  
ATOM    307  C   THR A  43      13.961  37.606  -0.108  1.00 23.40           C  
ATOM    308  O   THR A  43      14.944  38.345  -0.201  1.00 22.14           O  
ATOM    309  CB  THR A  43      12.201  38.980   1.041  1.00 22.62           C  
ATOM    310  OG1 THR A  43      11.277  39.012   2.132  1.00 23.36           O  
ATOM    311  CG2 THR A  43      11.411  39.054  -0.256  1.00 20.95           C  
ATOM    312  N   LEU A  44      13.647  36.696  -1.026  1.00 22.30           N  
ATOM    313  CA  LEU A  44      14.419  36.507  -2.249  1.00 21.59           C  
ATOM    314  C   LEU A  44      13.954  37.534  -3.281  1.00 22.11           C  
ATOM    315  O   LEU A  44      12.775  37.858  -3.347  1.00 22.16           O  
ATOM    316  CB  LEU A  44      14.202  35.087  -2.776  1.00 20.94           C  
ATOM    317  CG  LEU A  44      15.037  33.922  -2.217  1.00 22.78           C  
ATOM    318  CD1 LEU A  44      15.491  34.199  -0.813  1.00 22.14           C  
ATOM    319  CD2 LEU A  44      14.221  32.637  -2.288  1.00 21.22           C  
ATOM    320  N   LEU A  45      14.879  38.048  -4.083  1.00 22.84           N  
ATOM    321  CA  LEU A  45      14.534  39.052  -5.082  1.00 22.29           C  
ATOM    322  C   LEU A  45      15.172  38.819  -6.444  1.00 21.56           C  
ATOM    323  O   LEU A  45      16.214  38.172  -6.565  1.00 20.37           O  
ATOM    324  CB  LEU A  45      14.968  40.442  -4.595  1.00 22.66           C  
ATOM    325  CG  LEU A  45      14.451  40.963  -3.246  1.00 23.71           C  
ATOM    326  CD1 LEU A  45      15.317  42.127  -2.779  1.00 21.39           C  
ATOM    327  CD2 LEU A  45      12.998  41.395  -3.385  1.00 20.75           C  
ATOM    328  N   GLU A  46      14.527  39.368  -7.465  1.00 19.94           N  
ATOM    329  CA  GLU A  46      15.027  39.325  -8.833  1.00 21.84           C  
ATOM    330  C   GLU A  46      14.780  40.731  -9.366  1.00 20.95           C  
ATOM    331  O   GLU A  46      13.685  41.287  -9.209  1.00 19.11           O  
ATOM    332  CB  GLU A  46      14.274  38.309  -9.688  1.00 21.51           C  
ATOM    333  CG  GLU A  46      14.424  36.878  -9.231  1.00 25.17           C  
ATOM    334  CD  GLU A  46      13.702  35.916 -10.152  1.00 28.66           C  
ATOM    335  OE1 GLU A  46      12.789  36.373 -10.870  1.00 29.89           O  
ATOM    336  OE2 GLU A  46      14.036  34.711 -10.149  1.00 28.64           O  
ATOM    337  N   ALA A  47      15.803  41.313  -9.973  1.00 20.79           N  
ATOM    338  CA  ALA A  47      15.691  42.662 -10.511  1.00 20.97           C  
ATOM    339  C   ALA A  47      16.380  42.711 -11.863  1.00 23.02           C  
ATOM    340  O   ALA A  47      17.217  41.864 -12.167  1.00 22.74           O  
ATOM    341  CB  ALA A  47      16.339  43.659  -9.547  1.00 18.41           C  
ATOM    342  N   GLU A  48      16.021  43.702 -12.672  1.00 25.85           N  
ATOM    343  CA  GLU A  48      16.609  43.867 -13.994  1.00 27.71           C  
ATOM    344  C   GLU A  48      17.856  44.740 -13.954  1.00 26.43           C  
ATOM    345  O   GLU A  48      18.660  44.724 -14.882  1.00 24.99           O  
ATOM    346  CB  GLU A  48      15.592  44.491 -14.951  1.00 31.80           C  
ATOM    347  CG  GLU A  48      14.537  43.529 -15.464  1.00 38.29           C  
ATOM    348  CD  GLU A  48      13.465  44.237 -16.277  1.00 43.88           C  
ATOM    349  OE1 GLU A  48      12.694  43.540 -16.974  1.00 46.81           O  
ATOM    350  OE2 GLU A  48      13.392  45.489 -16.212  1.00 45.48           O  
ATOM    351  N   ASP A  49      18.011  45.520 -12.894  1.00 24.98           N  
ATOM    352  CA  ASP A  49      19.184  46.376 -12.769  1.00 24.32           C  
ATOM    353  C   ASP A  49      19.449  46.730 -11.313  1.00 22.18           C  
ATOM    354  O   ASP A  49      18.565  46.626 -10.467  1.00 21.21           O  
ATOM    355  CB  ASP A  49      19.019  47.645 -13.619  1.00 26.53           C  
ATOM    356  CG  ASP A  49      17.805  48.466 -13.225  1.00 28.13           C  
ATOM    357  OD1 ASP A  49      17.857  49.175 -12.202  1.00 29.31           O  
ATOM    358  OD2 ASP A  49      16.793  48.397 -13.943  1.00 33.73           O  
ATOM    359  N   LEU A  50      20.676  47.139 -11.029  1.00 21.43           N  
ATOM    360  CA  LEU A  50      21.075  47.479  -9.673  1.00 22.18           C  
ATOM    361  C   LEU A  50      20.323  48.650  -9.074  1.00 21.66           C  
ATOM    362  O   LEU A  50      20.070  48.662  -7.870  1.00 20.65           O  
ATOM    363  CB  LEU A  50      22.582  47.743  -9.623  1.00 23.95           C  
ATOM    364  CG  LEU A  50      23.402  46.461  -9.762  1.00 28.39           C  
ATOM    365  CD1 LEU A  50      24.873  46.786 -10.007  1.00 30.55           C  
ATOM    366  CD2 LEU A  50      23.219  45.626  -8.497  1.00 27.48           C  
ATOM    367  N   ASP A  51      19.966  49.631  -9.903  1.00 21.12           N  
ATOM    368  CA  ASP A  51      19.227  50.789  -9.414  1.00 20.06           C  
ATOM    369  C   ASP A  51      17.894  50.383  -8.771  1.00 20.62           C  
ATOM    370  O   ASP A  51      17.620  50.782  -7.642  1.00 20.24           O  
ATOM    371  CB  ASP A  51      18.972  51.802 -10.544  1.00 21.55           C  
ATOM    372  CG  ASP A  51      20.194  52.674 -10.847  1.00 24.09           C  
ATOM    373  OD1 ASP A  51      21.089  52.791  -9.981  1.00 25.85           O  
ATOM    374  OD2 ASP A  51      20.252  53.263 -11.948  1.00 26.91           O  
ATOM    375  N   GLU A  52      17.076  49.596  -9.473  1.00 19.25           N  
ATOM    376  CA  GLU A  52      15.783  49.165  -8.930  1.00 21.30           C  
ATOM    377  C   GLU A  52      15.964  48.410  -7.623  1.00 22.46           C  
ATOM    378  O   GLU A  52      15.251  48.659  -6.645  1.00 21.15           O  
ATOM    379  CB  GLU A  52      15.030  48.245  -9.898  1.00 22.65           C  
ATOM    380  CG  GLU A  52      14.219  48.949 -10.958  1.00 30.24           C  
ATOM    381  CD  GLU A  52      13.218  49.951 -10.400  1.00 28.51           C  
ATOM    382  OE1 GLU A  52      12.202  49.547  -9.781  1.00 25.94           O  
ATOM    383  OE2 GLU A  52      13.463  51.157 -10.594  1.00 29.01           O  
ATOM    384  N   LEU A  53      16.907  47.470  -7.620  1.00 21.40           N  
ATOM    385  CA  LEU A  53      17.182  46.684  -6.430  1.00 20.69           C  
ATOM    386  C   LEU A  53      17.517  47.585  -5.238  1.00 20.07           C  
ATOM    387  O   LEU A  53      16.922  47.438  -4.169  1.00 20.32           O  
ATOM    388  CB  LEU A  53      18.328  45.702  -6.693  1.00 18.83           C  
ATOM    389  CG  LEU A  53      18.714  44.785  -5.527  1.00 21.22           C  
ATOM    390  CD1 LEU A  53      17.499  44.015  -5.023  1.00 21.00           C  
ATOM    391  CD2 LEU A  53      19.788  43.817  -5.998  1.00 24.30           C  
HETATM  392  N   MSE A  54      18.454  48.513  -5.414  1.00 19.62           N  
HETATM  393  CA  MSE A  54      18.832  49.411  -4.323  1.00 21.83           C  
HETATM  394  C   MSE A  54      17.627  50.236  -3.856  1.00 21.01           C  
HETATM  395  O   MSE A  54      17.448  50.464  -2.660  1.00 18.82           O  
HETATM  396  CB  MSE A  54      19.962  50.360  -4.744  1.00 28.39           C  
HETATM  397  CG  MSE A  54      21.271  49.685  -5.165  1.00 40.04           C  
HETATM  398 SE   MSE A  54      21.847  48.271  -3.966  1.00 59.75          SE  
HETATM  399  CE  MSE A  54      21.533  46.764  -5.135  1.00 53.25           C  
ATOM    400  N   GLU A  55      16.807  50.696  -4.795  1.00 19.59           N  
ATOM    401  CA  GLU A  55      15.631  51.471  -4.426  1.00 21.54           C  
ATOM    402  C   GLU A  55      14.656  50.586  -3.638  1.00 19.89           C  
ATOM    403  O   GLU A  55      14.036  51.044  -2.682  1.00 19.30           O  
ATOM    404  CB  GLU A  55      14.932  52.041  -5.666  1.00 22.55           C  
ATOM    405  CG  GLU A  55      15.716  53.131  -6.403  1.00 27.21           C  
ATOM    406  CD  GLU A  55      16.040  54.334  -5.524  1.00 31.89           C  
ATOM    407  OE1 GLU A  55      15.115  54.885  -4.880  1.00 33.74           O  
ATOM    408  OE2 GLU A  55      17.226  54.735  -5.481  1.00 32.92           O  
ATOM    409  N   ALA A  56      14.524  49.324  -4.035  1.00 18.02           N  
ATOM    410  CA  ALA A  56      13.620  48.417  -3.330  1.00 20.33           C  
ATOM    411  C   ALA A  56      14.143  48.137  -1.917  1.00 19.99           C  
ATOM    412  O   ALA A  56      13.367  48.071  -0.959  1.00 20.64           O  
ATOM    413  CB  ALA A  56      13.462  47.111  -4.101  1.00 18.39           C  
ATOM    414  N   VAL A  57      15.459  47.985  -1.791  1.00 18.71           N  
ATOM    415  CA  VAL A  57      16.074  47.726  -0.494  1.00 19.37           C  
ATOM    416  C   VAL A  57      15.947  48.937   0.425  1.00 20.34           C  
ATOM    417  O   VAL A  57      15.648  48.785   1.608  1.00 20.12           O  
ATOM    418  CB  VAL A  57      17.568  47.329  -0.647  1.00 20.20           C  
ATOM    419  CG1 VAL A  57      18.252  47.249   0.726  1.00 15.85           C  
ATOM    420  CG2 VAL A  57      17.661  45.975  -1.354  1.00 19.33           C  
ATOM    421  N   LYS A  58      16.173  50.136  -0.107  1.00 21.27           N  
ATOM    422  CA  LYS A  58      16.039  51.343   0.706  1.00 22.07           C  
ATOM    423  C   LYS A  58      14.597  51.471   1.178  1.00 20.33           C  
ATOM    424  O   LYS A  58      14.339  51.789   2.336  1.00 21.11           O  
ATOM    425  CB  LYS A  58      16.417  52.601  -0.086  1.00 24.06           C  
ATOM    426  CG  LYS A  58      17.913  52.851  -0.192  1.00 29.15           C  
ATOM    427  CD  LYS A  58      18.228  54.149  -0.932  1.00 31.32           C  
ATOM    428  CE  LYS A  58      17.802  54.077  -2.392  1.00 34.97           C  
ATOM    429  NZ  LYS A  58      18.234  55.276  -3.173  1.00 37.86           N  
ATOM    430  N   ALA A  59      13.659  51.212   0.277  1.00 17.85           N  
ATOM    431  CA  ALA A  59      12.245  51.303   0.612  1.00 19.16           C  
ATOM    432  C   ALA A  59      11.863  50.338   1.738  1.00 19.66           C  
ATOM    433  O   ALA A  59      11.145  50.714   2.668  1.00 19.94           O  
ATOM    434  CB  ALA A  59      11.398  51.027  -0.623  1.00 18.18           C  
ATOM    435  N   ALA A  60      12.347  49.101   1.651  1.00 18.52           N  
ATOM    436  CA  ALA A  60      12.036  48.097   2.661  1.00 18.10           C  
ATOM    437  C   ALA A  60      12.613  48.518   4.005  1.00 18.51           C  
ATOM    438  O   ALA A  60      11.932  48.457   5.028  1.00 19.14           O  
ATOM    439  CB  ALA A  60      12.585  46.737   2.243  1.00 17.59           C  
ATOM    440  N   HIS A  61      13.870  48.954   3.990  1.00 18.13           N  
ATOM    441  CA  HIS A  61      14.557  49.408   5.193  1.00 18.74           C  
ATOM    442  C   HIS A  61      13.792  50.558   5.867  1.00 20.02           C  
ATOM    443  O   HIS A  61      13.543  50.527   7.075  1.00 19.15           O  
ATOM    444  CB  HIS A  61      15.971  49.873   4.831  1.00 17.86           C  
ATOM    445  CG  HIS A  61      16.795  50.310   6.007  1.00 18.03           C  
ATOM    446  ND1 HIS A  61      17.547  49.431   6.757  1.00 16.54           N  
ATOM    447  CD2 HIS A  61      17.005  51.539   6.541  1.00 14.61           C  
ATOM    448  CE1 HIS A  61      18.189  50.099   7.701  1.00 14.54           C  
ATOM    449  NE2 HIS A  61      17.877  51.379   7.591  1.00 16.48           N  
ATOM    450  N   GLU A  62      13.424  51.564   5.076  1.00 21.49           N  
ATOM    451  CA  GLU A  62      12.703  52.736   5.578  1.00 23.62           C  
ATOM    452  C   GLU A  62      11.333  52.388   6.149  1.00 23.59           C  
ATOM    453  O   GLU A  62      10.900  52.994   7.122  1.00 22.21           O  
ATOM    454  CB  GLU A  62      12.513  53.769   4.459  1.00 27.16           C  
ATOM    455  CG  GLU A  62      13.781  54.114   3.694  1.00 35.73           C  
ATOM    456  CD  GLU A  62      14.558  55.269   4.295  1.00 41.51           C  
ATOM    457  OE1 GLU A  62      14.505  55.454   5.533  1.00 43.57           O  
ATOM    458  OE2 GLU A  62      15.234  55.987   3.520  1.00 43.90           O  
ATOM    459  N   ALA A  63      10.649  51.425   5.535  1.00 21.69           N  
ATOM    460  CA  ALA A  63       9.325  51.030   6.000  1.00 22.61           C  
ATOM    461  C   ALA A  63       9.374  50.489   7.425  1.00 21.60           C  
ATOM    462  O   ALA A  63       8.449  50.696   8.203  1.00 22.03           O  
ATOM    463  CB  ALA A  63       8.718  49.981   5.060  1.00 21.28           C  
ATOM    464  N   VAL A  64      10.456  49.798   7.767  1.00 21.74           N  
ATOM    465  CA  VAL A  64      10.589  49.247   9.108  1.00 20.61           C  
ATOM    466  C   VAL A  64      10.848  50.360  10.118  1.00 21.93           C  
ATOM    467  O   VAL A  64      10.371  50.302  11.257  1.00 21.08           O  
ATOM    468  CB  VAL A  64      11.702  48.185   9.159  1.00 20.34           C  
ATOM    469  CG1 VAL A  64      11.920  47.710  10.588  1.00 18.89           C  
ATOM    470  CG2 VAL A  64      11.311  47.012   8.270  1.00 19.83           C  
ATOM    471  N   LEU A  65      11.594  51.380   9.705  1.00 21.02           N  
ATOM    472  CA  LEU A  65      11.849  52.506  10.591  1.00 22.06           C  
ATOM    473  C   LEU A  65      10.527  53.258  10.764  1.00 23.16           C  
ATOM    474  O   LEU A  65      10.174  53.653  11.871  1.00 21.30           O  
ATOM    475  CB  LEU A  65      12.899  53.447   9.992  1.00 21.51           C  
ATOM    476  CG  LEU A  65      14.363  52.996  10.027  1.00 24.89           C  
ATOM    477  CD1 LEU A  65      15.210  53.866   9.082  1.00 23.12           C  
ATOM    478  CD2 LEU A  65      14.880  53.080  11.459  1.00 23.35           C  
ATOM    479  N   GLN A  66       9.801  53.450   9.664  1.00 23.25           N  
ATOM    480  CA  GLN A  66       8.525  54.155   9.715  1.00 28.40           C  
ATOM    481  C   GLN A  66       7.520  53.393  10.557  1.00 27.61           C  
ATOM    482  O   GLN A  66       6.660  53.989  11.190  1.00 27.78           O  
ATOM    483  CB  GLN A  66       7.941  54.350   8.315  1.00 31.35           C  
ATOM    484  CG  GLN A  66       8.716  55.314   7.449  1.00 39.62           C  
ATOM    485  CD  GLN A  66       7.872  55.879   6.319  1.00 43.49           C  
ATOM    486  OE1 GLN A  66       7.211  55.135   5.584  1.00 46.30           O  
ATOM    487  NE2 GLN A  66       7.892  57.203   6.172  1.00 44.14           N  
ATOM    488  N   ALA A  67       7.639  52.070  10.542  1.00 27.71           N  
ATOM    489  CA  ALA A  67       6.757  51.197  11.299  1.00 27.47           C  
ATOM    490  C   ALA A  67       6.949  51.418  12.797  1.00 27.58           C  
ATOM    491  O   ALA A  67       6.136  50.974  13.601  1.00 29.49           O  
ATOM    492  CB  ALA A  67       7.042  49.739  10.937  1.00 27.50           C  
ATOM    493  N   GLY A  68       8.031  52.093  13.176  1.00 26.58           N  
ATOM    494  CA  GLY A  68       8.260  52.356  14.587  1.00 26.76           C  
ATOM    495  C   GLY A  68       9.561  51.863  15.201  1.00 26.45           C  
ATOM    496  O   GLY A  68       9.824  52.122  16.378  1.00 25.44           O  
ATOM    497  N   SER A  69      10.378  51.158  14.430  1.00 25.39           N  
ATOM    498  CA  SER A  69      11.644  50.656  14.957  1.00 26.27           C  
ATOM    499  C   SER A  69      12.701  51.751  15.036  1.00 25.35           C  
ATOM    500  O   SER A  69      12.854  52.546  14.107  1.00 26.44           O  
ATOM    501  CB  SER A  69      12.168  49.513  14.093  1.00 26.60           C  
ATOM    502  OG  SER A  69      13.354  48.982  14.657  1.00 29.53           O  
ATOM    503  N   ASP A  70      13.427  51.783  16.150  1.00 24.45           N  
ATOM    504  CA  ASP A  70      14.480  52.771  16.362  1.00 26.52           C  
ATOM    505  C   ASP A  70      15.861  52.257  15.960  1.00 26.58           C  
ATOM    506  O   ASP A  70      16.850  52.996  16.023  1.00 27.87           O  
ATOM    507  CB  ASP A  70      14.506  53.207  17.826  1.00 30.02           C  
ATOM    508  CG  ASP A  70      13.457  54.262  18.139  1.00 33.37           C  
ATOM    509  OD1 ASP A  70      13.082  54.388  19.324  1.00 36.15           O  
ATOM    510  OD2 ASP A  70      13.022  54.973  17.206  1.00 32.37           O  
ATOM    511  N   ARG A  71      15.932  50.988  15.567  1.00 23.54           N  
ATOM    512  CA  ARG A  71      17.195  50.401  15.140  1.00 23.17           C  
ATOM    513  C   ARG A  71      16.944  49.253  14.172  1.00 21.89           C  
ATOM    514  O   ARG A  71      16.362  48.233  14.534  1.00 22.54           O  
ATOM    515  CB  ARG A  71      18.003  49.904  16.344  1.00 22.68           C  
ATOM    516  CG  ARG A  71      19.411  49.447  15.973  1.00 22.03           C  
ATOM    517  CD  ARG A  71      20.230  49.036  17.181  1.00 21.09           C  
ATOM    518  NE  ARG A  71      21.596  48.669  16.803  1.00 22.77           N  
ATOM    519  CZ  ARG A  71      22.558  48.347  17.669  1.00 25.84           C  
ATOM    520  NH1 ARG A  71      22.310  48.346  18.974  1.00 21.99           N  
ATOM    521  NH2 ARG A  71      23.773  48.020  17.230  1.00 26.05           N  
ATOM    522  N   VAL A  72      17.383  49.428  12.933  1.00 20.92           N  
ATOM    523  CA  VAL A  72      17.188  48.403  11.923  1.00 20.19           C  
ATOM    524  C   VAL A  72      18.507  47.826  11.417  1.00 20.68           C  
ATOM    525  O   VAL A  72      19.432  48.556  11.044  1.00 19.58           O  
ATOM    526  CB  VAL A  72      16.363  48.954  10.739  1.00 20.40           C  
ATOM    527  CG1 VAL A  72      16.037  47.843   9.765  1.00 18.66           C  
ATOM    528  CG2 VAL A  72      15.073  49.584  11.263  1.00 21.97           C  
ATOM    529  N   TYR A  73      18.579  46.499  11.429  1.00 21.49           N  
ATOM    530  CA  TYR A  73      19.752  45.768  10.980  1.00 21.10           C  
ATOM    531  C   TYR A  73      19.373  45.103   9.666  1.00 20.34           C  
ATOM    532  O   TYR A  73      18.617  44.126   9.649  1.00 19.91           O  
ATOM    533  CB  TYR A  73      20.128  44.704  12.004  1.00 23.88           C  
ATOM    534  CG  TYR A  73      21.404  43.970  11.669  1.00 27.30           C  
ATOM    535  CD1 TYR A  73      22.648  44.584  11.828  1.00 28.15           C  
ATOM    536  CD2 TYR A  73      21.371  42.659  11.197  1.00 27.58           C  
ATOM    537  CE1 TYR A  73      23.821  43.905  11.527  1.00 30.83           C  
ATOM    538  CE2 TYR A  73      22.542  41.975  10.892  1.00 28.80           C  
ATOM    539  CZ  TYR A  73      23.757  42.601  11.061  1.00 29.05           C  
ATOM    540  OH  TYR A  73      24.913  41.917  10.776  1.00 37.33           O  
ATOM    541  N   THR A  74      19.901  45.630   8.568  1.00 18.74           N  
ATOM    542  CA  THR A  74      19.572  45.108   7.252  1.00 18.77           C  
ATOM    543  C   THR A  74      20.724  44.418   6.541  1.00 19.96           C  
ATOM    544  O   THR A  74      21.864  44.902   6.528  1.00 18.81           O  
ATOM    545  CB  THR A  74      19.015  46.237   6.360  1.00 18.50           C  
ATOM    546  OG1 THR A  74      17.769  46.679   6.903  1.00 21.29           O  
ATOM    547  CG2 THR A  74      18.797  45.761   4.933  1.00 18.27           C  
ATOM    548  N   THR A  75      20.404  43.279   5.942  1.00 19.04           N  
ATOM    549  CA  THR A  75      21.379  42.485   5.219  1.00 20.75           C  
ATOM    550  C   THR A  75      20.909  42.278   3.781  1.00 21.18           C  
ATOM    551  O   THR A  75      19.742  41.973   3.527  1.00 19.23           O  
ATOM    552  CB  THR A  75      21.578  41.108   5.901  1.00 22.79           C  
ATOM    553  OG1 THR A  75      22.118  41.301   7.216  1.00 24.61           O  
ATOM    554  CG2 THR A  75      22.530  40.239   5.095  1.00 24.98           C  
ATOM    555  N   LEU A  76      21.828  42.464   2.844  1.00 20.45           N  
ATOM    556  CA  LEU A  76      21.529  42.287   1.436  1.00 20.08           C  
ATOM    557  C   LEU A  76      22.642  41.479   0.787  1.00 20.64           C  
ATOM    558  O   LEU A  76      23.817  41.811   0.924  1.00 21.02           O  
ATOM    559  CB  LEU A  76      21.422  43.644   0.739  1.00 18.78           C  
ATOM    560  CG  LEU A  76      21.245  43.609  -0.782  1.00 20.50           C  
ATOM    561  CD1 LEU A  76      19.878  43.044  -1.130  1.00 17.98           C  
ATOM    562  CD2 LEU A  76      21.406  45.016  -1.356  1.00 17.68           C  
ATOM    563  N   LYS A  77      22.267  40.403   0.106  1.00 20.60           N  
ATOM    564  CA  LYS A  77      23.223  39.570  -0.606  1.00 22.26           C  
ATOM    565  C   LYS A  77      22.848  39.697  -2.070  1.00 21.75           C  
ATOM    566  O   LYS A  77      21.686  39.523  -2.432  1.00 20.71           O  
ATOM    567  CB  LYS A  77      23.109  38.097  -0.202  1.00 25.30           C  
ATOM    568  CG  LYS A  77      23.443  37.783   1.240  1.00 31.25           C  
ATOM    569  CD  LYS A  77      23.536  36.266   1.458  1.00 35.25           C  
ATOM    570  CE  LYS A  77      22.292  35.531   0.949  1.00 36.75           C  
ATOM    571  NZ  LYS A  77      22.368  34.047   1.127  1.00 35.22           N  
ATOM    572  N   ILE A  78      23.827  40.007  -2.908  1.00 21.59           N  
ATOM    573  CA  ILE A  78      23.585  40.151  -4.332  1.00 22.22           C  
ATOM    574  C   ILE A  78      24.425  39.164  -5.137  1.00 22.83           C  
ATOM    575  O   ILE A  78      25.644  39.069  -4.958  1.00 25.16           O  
ATOM    576  CB  ILE A  78      23.936  41.577  -4.829  1.00 21.79           C  
ATOM    577  CG1 ILE A  78      23.193  42.631  -4.007  1.00 21.79           C  
ATOM    578  CG2 ILE A  78      23.570  41.714  -6.302  1.00 21.53           C  
ATOM    579  CD1 ILE A  78      23.542  44.056  -4.394  1.00 19.95           C  
ATOM    580  N   ASP A  79      23.764  38.418  -6.013  1.00 22.92           N  
ATOM    581  CA  ASP A  79      24.450  37.476  -6.887  1.00 21.92           C  
ATOM    582  C   ASP A  79      24.215  38.042  -8.285  1.00 21.51           C  
ATOM    583  O   ASP A  79      23.151  37.872  -8.863  1.00 21.97           O  
ATOM    584  CB  ASP A  79      23.843  36.075  -6.772  1.00 22.30           C  
ATOM    585  CG  ASP A  79      24.581  35.044  -7.626  1.00 24.59           C  
ATOM    586  OD1 ASP A  79      24.104  33.898  -7.724  1.00 26.71           O  
ATOM    587  OD2 ASP A  79      25.643  35.377  -8.198  1.00 24.40           O  
ATOM    588  N   ASP A  80      25.212  38.734  -8.815  1.00 23.02           N  
ATOM    589  CA  ASP A  80      25.092  39.355 -10.126  1.00 22.92           C  
ATOM    590  C   ASP A  80      25.908  38.585 -11.156  1.00 23.27           C  
ATOM    591  O   ASP A  80      27.127  38.737 -11.231  1.00 22.49           O  
ATOM    592  CB  ASP A  80      25.574  40.805 -10.034  1.00 23.36           C  
ATOM    593  CG  ASP A  80      25.260  41.614 -11.277  1.00 25.19           C  
ATOM    594  OD1 ASP A  80      24.680  41.058 -12.238  1.00 24.77           O  
ATOM    595  OD2 ASP A  80      25.602  42.819 -11.287  1.00 25.38           O  
ATOM    596  N   ARG A  81      25.233  37.754 -11.945  1.00 21.85           N  
ATOM    597  CA  ARG A  81      25.919  36.960 -12.956  1.00 23.91           C  
ATOM    598  C   ARG A  81      25.652  37.526 -14.347  1.00 24.96           C  
ATOM    599  O   ARG A  81      24.512  37.546 -14.815  1.00 24.25           O  
ATOM    600  CB  ARG A  81      25.472  35.496 -12.877  1.00 22.65           C  
ATOM    601  CG  ARG A  81      26.280  34.577 -13.778  1.00 21.36           C  
ATOM    602  CD  ARG A  81      25.947  33.116 -13.553  1.00 21.95           C  
ATOM    603  NE  ARG A  81      26.797  32.250 -14.364  1.00 22.74           N  
ATOM    604  CZ  ARG A  81      26.681  30.928 -14.437  1.00 23.10           C  
ATOM    605  NH1 ARG A  81      25.744  30.296 -13.737  1.00 18.57           N  
ATOM    606  NH2 ARG A  81      27.493  30.237 -15.230  1.00 23.81           N  
ATOM    607  N   ARG A  82      26.720  37.968 -15.002  1.00 25.34           N  
ATOM    608  CA  ARG A  82      26.630  38.578 -16.323  1.00 26.42           C  
ATOM    609  C   ARG A  82      26.880  37.672 -17.535  1.00 26.95           C  
ATOM    610  O   ARG A  82      26.593  38.073 -18.665  1.00 26.90           O  
ATOM    611  CB  ARG A  82      27.582  39.784 -16.387  1.00 26.66           C  
ATOM    612  CG  ARG A  82      27.257  40.889 -15.380  1.00 28.85           C  
ATOM    613  CD  ARG A  82      25.847  41.414 -15.596  1.00 31.62           C  
ATOM    614  NE  ARG A  82      25.414  42.351 -14.563  1.00 35.68           N  
ATOM    615  CZ  ARG A  82      25.616  43.665 -14.605  1.00 39.25           C  
ATOM    616  NH1 ARG A  82      26.253  44.209 -15.637  1.00 39.74           N  
ATOM    617  NH2 ARG A  82      25.167  44.440 -13.622  1.00 36.30           N  
ATOM    618  N   ASP A  83      27.416  36.471 -17.327  1.00 24.64           N  
ATOM    619  CA  ASP A  83      27.670  35.586 -18.462  1.00 24.70           C  
ATOM    620  C   ASP A  83      26.570  34.544 -18.650  1.00 26.63           C  
ATOM    621  O   ASP A  83      26.715  33.616 -19.445  1.00 26.23           O  
ATOM    622  CB  ASP A  83      29.039  34.894 -18.335  1.00 22.26           C  
ATOM    623  CG  ASP A  83      29.174  34.065 -17.063  1.00 22.75           C  
ATOM    624  OD1 ASP A  83      28.240  34.060 -16.236  1.00 21.99           O  
ATOM    625  OD2 ASP A  83      30.231  33.417 -16.883  1.00 21.40           O  
ATOM    626  N   ALA A  84      25.469  34.708 -17.923  1.00 27.03           N  
ATOM    627  CA  ALA A  84      24.335  33.789 -18.026  1.00 27.84           C  
ATOM    628  C   ALA A  84      23.127  34.378 -17.316  1.00 28.51           C  
ATOM    629  O   ALA A  84      23.272  35.102 -16.331  1.00 28.09           O  
ATOM    630  CB  ALA A  84      24.686  32.436 -17.414  1.00 25.53           C  
ATOM    631  N   ASP A  85      21.939  34.078 -17.829  1.00 30.54           N  
ATOM    632  CA  ASP A  85      20.697  34.563 -17.241  1.00 31.81           C  
ATOM    633  C   ASP A  85      20.174  33.478 -16.307  1.00 31.01           C  
ATOM    634  O   ASP A  85      19.765  32.410 -16.758  1.00 31.60           O  
ATOM    635  CB  ASP A  85      19.668  34.847 -18.338  1.00 36.79           C  
ATOM    636  CG  ASP A  85      20.019  36.073 -19.170  1.00 42.60           C  
ATOM    637  OD1 ASP A  85      19.398  36.260 -20.240  1.00 46.74           O  
ATOM    638  OD2 ASP A  85      20.904  36.859 -18.758  1.00 45.09           O  
ATOM    639  N   ARG A  86      20.190  33.751 -15.007  1.00 27.85           N  
ATOM    640  CA  ARG A  86      19.732  32.774 -14.031  1.00 26.23           C  
ATOM    641  C   ARG A  86      18.821  33.381 -12.977  1.00 26.13           C  
ATOM    642  O   ARG A  86      19.256  34.205 -12.175  1.00 27.58           O  
ATOM    643  CB  ARG A  86      20.934  32.130 -13.331  1.00 26.30           C  
ATOM    644  CG  ARG A  86      21.848  31.319 -14.237  1.00 26.44           C  
ATOM    645  CD  ARG A  86      21.404  29.867 -14.338  1.00 28.06           C  
ATOM    646  NE  ARG A  86      22.390  29.047 -15.046  1.00 28.60           N  
ATOM    647  CZ  ARG A  86      22.575  29.074 -16.362  1.00 28.64           C  
ATOM    648  NH1 ARG A  86      21.834  29.875 -17.121  1.00 27.01           N  
ATOM    649  NH2 ARG A  86      23.513  28.316 -16.918  1.00 27.19           N  
ATOM    650  N   GLY A  87      17.558  32.971 -12.981  1.00 24.68           N  
ATOM    651  CA  GLY A  87      16.626  33.457 -11.982  1.00 22.52           C  
ATOM    652  C   GLY A  87      16.712  32.543 -10.769  1.00 22.67           C  
ATOM    653  O   GLY A  87      17.462  31.566 -10.775  1.00 22.06           O  
ATOM    654  N   LEU A  88      15.947  32.855  -9.727  1.00 21.79           N  
ATOM    655  CA  LEU A  88      15.945  32.063  -8.505  1.00 21.96           C  
ATOM    656  C   LEU A  88      15.662  30.588  -8.800  1.00 23.72           C  
ATOM    657  O   LEU A  88      16.391  29.703  -8.343  1.00 23.24           O  
ATOM    658  CB  LEU A  88      14.897  32.615  -7.522  1.00 19.87           C  
ATOM    659  CG  LEU A  88      15.105  34.055  -7.019  1.00 19.54           C  
ATOM    660  CD1 LEU A  88      13.864  34.538  -6.287  1.00 17.27           C  
ATOM    661  CD2 LEU A  88      16.317  34.116  -6.102  1.00 15.98           C  
ATOM    662  N   ARG A  89      14.605  30.333  -9.565  1.00 26.23           N  
ATOM    663  CA  ARG A  89      14.218  28.972  -9.922  1.00 29.05           C  
ATOM    664  C   ARG A  89      15.330  28.255 -10.698  1.00 28.47           C  
ATOM    665  O   ARG A  89      15.668  27.106 -10.395  1.00 29.19           O  
ATOM    666  CB  ARG A  89      12.933  28.984 -10.762  1.00 32.64           C  
ATOM    667  CG  ARG A  89      12.394  27.582 -11.065  1.00 41.61           C  
ATOM    668  CD  ARG A  89      11.396  27.571 -12.230  1.00 48.49           C  
ATOM    669  NE  ARG A  89      10.158  28.292 -11.933  1.00 55.23           N  
ATOM    670  CZ  ARG A  89       9.274  27.920 -11.009  1.00 58.70           C  
ATOM    671  NH1 ARG A  89       9.485  26.827 -10.283  1.00 60.18           N  
ATOM    672  NH2 ARG A  89       8.177  28.644 -10.810  1.00 59.38           N  
ATOM    673  N   ASP A  90      15.896  28.931 -11.698  1.00 28.46           N  
ATOM    674  CA  ASP A  90      16.971  28.344 -12.504  1.00 27.16           C  
ATOM    675  C   ASP A  90      18.107  27.853 -11.616  1.00 25.58           C  
ATOM    676  O   ASP A  90      18.634  26.763 -11.818  1.00 27.14           O  
ATOM    677  CB  ASP A  90      17.553  29.364 -13.497  1.00 28.48           C  
ATOM    678  CG  ASP A  90      16.543  29.836 -14.522  1.00 31.74           C  
ATOM    679  OD1 ASP A  90      15.751  29.002 -15.009  1.00 31.96           O  
ATOM    680  OD2 ASP A  90      16.558  31.044 -14.856  1.00 32.02           O  
ATOM    681  N   LYS A  91      18.482  28.665 -10.634  1.00 23.69           N  
ATOM    682  CA  LYS A  91      19.570  28.309  -9.733  1.00 23.25           C  
ATOM    683  C   LYS A  91      19.222  27.108  -8.865  1.00 22.55           C  
ATOM    684  O   LYS A  91      20.076  26.265  -8.590  1.00 19.90           O  
ATOM    685  CB  LYS A  91      19.942  29.510  -8.857  1.00 22.40           C  
ATOM    686  CG  LYS A  91      20.415  30.724  -9.665  1.00 22.21           C  
ATOM    687  CD  LYS A  91      20.676  31.933  -8.771  1.00 22.47           C  
ATOM    688  CE  LYS A  91      21.759  31.655  -7.740  1.00 20.56           C  
ATOM    689  NZ  LYS A  91      21.923  32.834  -6.846  1.00 21.19           N  
ATOM    690  N   VAL A  92      17.969  27.027  -8.432  1.00 23.03           N  
ATOM    691  CA  VAL A  92      17.548  25.900  -7.611  1.00 24.32           C  
ATOM    692  C   VAL A  92      17.604  24.632  -8.456  1.00 24.10           C  
ATOM    693  O   VAL A  92      18.171  23.629  -8.038  1.00 22.83           O  
ATOM    694  CB  VAL A  92      16.103  26.097  -7.065  1.00 25.89           C  
ATOM    695  CG1 VAL A  92      15.593  24.803  -6.432  1.00 23.86           C  
ATOM    696  CG2 VAL A  92      16.090  27.221  -6.029  1.00 25.41           C  
ATOM    697  N   GLU A  93      17.032  24.691  -9.654  1.00 26.30           N  
ATOM    698  CA  GLU A  93      17.013  23.533 -10.548  1.00 28.20           C  
ATOM    699  C   GLU A  93      18.403  23.084 -11.002  1.00 26.83           C  
ATOM    700  O   GLU A  93      18.630  21.897 -11.221  1.00 25.39           O  
ATOM    701  CB  GLU A  93      16.137  23.815 -11.769  1.00 30.96           C  
ATOM    702  CG  GLU A  93      14.669  24.070 -11.434  1.00 39.16           C  
ATOM    703  CD  GLU A  93      14.039  22.939 -10.624  1.00 45.17           C  
ATOM    704  OE1 GLU A  93      14.090  21.774 -11.083  1.00 49.46           O  
ATOM    705  OE2 GLU A  93      13.486  23.214  -9.528  1.00 47.59           O  
ATOM    706  N   SER A  94      19.336  24.022 -11.139  1.00 25.68           N  
ATOM    707  CA  SER A  94      20.689  23.659 -11.557  1.00 26.14           C  
ATOM    708  C   SER A  94      21.374  22.810 -10.502  1.00 24.52           C  
ATOM    709  O   SER A  94      22.097  21.873 -10.825  1.00 25.19           O  
ATOM    710  CB  SER A  94      21.539  24.906 -11.822  1.00 26.07           C  
ATOM    711  OG  SER A  94      21.144  25.529 -13.029  1.00 28.89           O  
ATOM    712  N   VAL A  95      21.152  23.154  -9.238  1.00 23.82           N  
ATOM    713  CA  VAL A  95      21.744  22.416  -8.134  1.00 23.11           C  
ATOM    714  C   VAL A  95      21.093  21.042  -8.006  1.00 23.78           C  
ATOM    715  O   VAL A  95      21.781  20.029  -7.888  1.00 23.26           O  
ATOM    716  CB  VAL A  95      21.581  23.189  -6.804  1.00 23.22           C  
ATOM    717  CG1 VAL A  95      22.104  22.352  -5.637  1.00 19.54           C  
ATOM    718  CG2 VAL A  95      22.332  24.515  -6.882  1.00 20.10           C  
ATOM    719  N   LYS A  96      19.767  21.010  -8.046  1.00 25.34           N  
ATOM    720  CA  LYS A  96      19.037  19.752  -7.932  1.00 27.33           C  
ATOM    721  C   LYS A  96      19.434  18.773  -9.024  1.00 27.18           C  
ATOM    722  O   LYS A  96      19.616  17.593  -8.762  1.00 28.02           O  
ATOM    723  CB  LYS A  96      17.526  20.001  -7.986  1.00 27.86           C  
ATOM    724  CG  LYS A  96      16.971  20.621  -6.711  1.00 31.54           C  
ATOM    725  CD  LYS A  96      15.452  20.713  -6.748  1.00 34.01           C  
ATOM    726  CE  LYS A  96      14.899  21.105  -5.388  1.00 36.09           C  
ATOM    727  NZ  LYS A  96      13.411  21.230  -5.403  1.00 37.65           N  
ATOM    728  N   GLU A  97      19.569  19.273 -10.246  1.00 27.95           N  
ATOM    729  CA  GLU A  97      19.944  18.446 -11.385  1.00 29.05           C  
ATOM    730  C   GLU A  97      21.296  17.772 -11.147  1.00 29.98           C  
ATOM    731  O   GLU A  97      21.536  16.660 -11.623  1.00 29.56           O  
ATOM    732  CB  GLU A  97      19.995  19.310 -12.650  1.00 28.80           C  
ATOM    733  CG  GLU A  97      20.180  18.555 -13.968  1.00 31.96           C  
ATOM    734  CD  GLU A  97      21.627  18.166 -14.244  1.00 33.82           C  
ATOM    735  OE1 GLU A  97      22.527  19.007 -14.023  1.00 33.02           O  
ATOM    736  OE2 GLU A  97      21.859  17.024 -14.699  1.00 33.40           O  
ATOM    737  N   LYS A  98      22.171  18.439 -10.399  1.00 29.59           N  
ATOM    738  CA  LYS A  98      23.490  17.891 -10.121  1.00 30.46           C  
ATOM    739  C   LYS A  98      23.514  16.943  -8.926  1.00 31.96           C  
ATOM    740  O   LYS A  98      24.528  16.292  -8.668  1.00 30.60           O  
ATOM    741  CB  LYS A  98      24.506  19.025  -9.927  1.00 31.19           C  
ATOM    742  CG  LYS A  98      24.909  19.731 -11.230  1.00 32.56           C  
ATOM    743  CD  LYS A  98      25.627  18.767 -12.177  1.00 34.62           C  
ATOM    744  CE  LYS A  98      26.125  19.449 -13.454  1.00 35.21           C  
ATOM    745  NZ  LYS A  98      25.034  19.952 -14.339  1.00 33.88           N  
ATOM    746  N   ILE A  99      22.402  16.863  -8.199  1.00 33.62           N  
ATOM    747  CA  ILE A  99      22.324  15.960  -7.055  1.00 35.82           C  
ATOM    748  C   ILE A  99      21.814  14.603  -7.527  1.00 36.65           C  
ATOM    749  O   ILE A  99      22.594  13.767  -7.974  1.00 38.66           O  
ATOM    750  CB  ILE A  99      21.364  16.475  -5.963  1.00 35.38           C  
ATOM    751  CG1 ILE A  99      21.896  17.775  -5.366  1.00 34.94           C  
ATOM    752  CG2 ILE A  99      21.220  15.423  -4.870  1.00 33.24           C  
ATOM    753  CD1 ILE A  99      20.934  18.437  -4.419  1.00 33.29           C  
TER     754      ILE A  99                                                      
END
MOLECULE T0513_17_85.pdb
ATOM    136  N   ASN    17      17.209  32.934  15.316  1.00 20.86           N  
ATOM    137  CA  ASN    17      16.055  33.821  15.215  1.00 21.30           C  
ATOM    138  C   ASN    17      16.030  34.653  13.915  1.00 19.81           C  
ATOM    139  O   ASN    17      15.279  35.635  13.809  1.00 22.73           O  
ATOM    140  CB  ASN    17      15.951  34.697  16.480  1.00 20.06           C  
ATOM    141  CG  ASN    17      14.625  35.442  16.589  1.00 20.33           C  
ATOM    142  OD1 ASN    17      14.596  36.674  16.657  1.00 26.71           O  
ATOM    143  ND2 ASN    17      13.524  34.701  16.602  1.00 25.28           N  
ATOM    144  N   PHE    18      16.863  34.266  12.950  1.00 22.83           N  
ATOM    145  CA  PHE    18      17.038  34.993  11.685  1.00 20.77           C  
ATOM    146  C   PHE    18      16.729  34.131  10.466  1.00 26.09           C  
ATOM    147  O   PHE    18      16.856  32.904  10.510  1.00 23.90           O  
ATOM    148  CB  PHE    18      18.489  35.478  11.537  1.00 20.07           C  
ATOM    149  CG  PHE    18      18.897  36.501  12.565  1.00 21.76           C  
ATOM    150  CD1 PHE    18      18.942  37.859  12.237  1.00 24.52           C  
ATOM    151  CD2 PHE    18      19.251  36.104  13.865  1.00 24.38           C  
ATOM    152  CE1 PHE    18      19.316  38.798  13.175  1.00 21.09           C  
ATOM    153  CE2 PHE    18      19.629  37.040  14.816  1.00 27.62           C  
ATOM    154  CZ  PHE    18      19.662  38.396  14.477  1.00 22.52           C  
ATOM    155  N   VAL    19      16.347  34.797   9.371  1.00 23.29           N  
ATOM    156  CA  VAL    19      16.190  34.157   8.064  1.00 23.44           C  
ATOM    157  C   VAL    19      17.116  34.822   7.054  1.00 23.87           C  
ATOM    158  O   VAL    19      17.450  36.007   7.186  1.00 26.05           O  
ATOM    159  CB  VAL    19      14.722  34.166   7.535  1.00 26.11           C  
ATOM    160  CG1 VAL    19      13.813  33.322   8.418  1.00 29.80           C  
ATOM    161  CG2 VAL    19      14.181  35.594   7.420  1.00 26.39           C  
ATOM    162  N   ARG    20      17.533  34.023   6.065  1.00 21.52           N  
ATOM    163  CA  ARG    20      18.422  34.472   4.999  0.50 25.24           C  
ATOM    165  C   ARG    20      17.799  35.611   4.197  1.00 23.67           C  
ATOM    166  O   ARG    20      16.602  35.598   3.885  1.00 26.54           O  
ATOM    167  CB  ARG    20      18.765  33.299   4.066  0.50 26.19           C  
ATOM    169  CG  ARG    20      19.517  32.169   4.752  0.50 32.31           C  
ATOM    171  CD  ARG    20      19.716  30.936   3.868  0.50 37.64           C  
ATOM    173  NE  ARG    20      21.039  30.345   4.075  0.50 32.60           N  
ATOM    175  CZ  ARG    20      21.962  30.231   3.123  0.50 38.95           C  
ATOM    177  NH1 ARG    20      23.143  29.697   3.411  0.50 43.99           N  
ATOM    179  NH2 ARG    20      21.705  30.634   1.880  0.50 28.71           N  
ATOM    181  N   PHE    21      18.612  36.600   3.890  1.00 20.41           N  
ATOM    182  CA  PHE    21      18.195  37.664   2.981  1.00 19.15           C  
ATOM    183  C   PHE    21      18.908  37.400   1.650  1.00 22.86           C  
ATOM    184  O   PHE    21      20.145  37.355   1.582  1.00 21.81           O  
ATOM    185  CB  PHE    21      18.522  39.041   3.558  1.00 21.05           C  
ATOM    186  CG  PHE    21      18.246  40.177   2.615  1.00 24.51           C  
ATOM    187  CD1 PHE    21      17.130  40.161   1.782  1.00 25.06           C  
ATOM    188  CD2 PHE    21      19.075  41.286   2.588  1.00 26.03           C  
ATOM    189  CE1 PHE    21      16.873  41.200   0.908  1.00 32.51           C  
ATOM    190  CE2 PHE    21      18.810  42.341   1.700  1.00 24.87           C  
ATOM    191  CZ  PHE    21      17.706  42.282   0.869  1.00 21.39           C  
ATOM    192  N   VAL    22      18.104  37.221   0.606  1.00 23.08           N  
ATOM    193  CA  VAL    22      18.559  36.692  -0.692  1.00 20.41           C  
ATOM    194  C   VAL    22      18.247  37.636  -1.870  1.00 23.08           C  
ATOM    195  O   VAL    22      17.138  38.165  -1.984  1.00 23.12           O  
ATOM    196  CB  VAL    22      17.935  35.297  -0.938  1.00 20.68           C  
ATOM    197  CG1 VAL    22      18.300  34.736  -2.328  1.00 23.11           C  
ATOM    198  CG2 VAL    22      18.358  34.340   0.161  1.00 27.48           C  
ATOM    199  N   ILE    23      19.243  37.852  -2.723  1.00 24.77           N  
ATOM    200  CA  ILE    23      19.057  38.610  -3.967  1.00 27.98           C  
ATOM    201  C   ILE    23      19.535  37.726  -5.131  1.00 32.10           C  
ATOM    202  O   ILE    23      20.708  37.296  -5.164  1.00 25.66           O  
ATOM    203  CB  ILE    23      19.843  39.955  -3.981  1.00 31.42           C  
ATOM    204  CG1 ILE    23      19.464  40.859  -2.795  1.00 24.84           C  
ATOM    205  CG2 ILE    23      19.614  40.727  -5.293  1.00 31.38           C  
ATOM    206  CD1 ILE    23      20.302  42.150  -2.745  1.00 24.85           C  
ATOM    207  N   GLU    24      18.619  37.471  -6.067  1.00 35.79           N  
ATOM    208  CA  GLU    24      18.867  36.635  -7.256  1.00 40.85           C  
ATOM    209  C   GLU    24      19.596  35.344  -6.899  1.00 38.68           C  
ATOM    210  O   GLU    24      20.621  35.030  -7.497  1.00 39.34           O  
ATOM    211  CB  GLU    24      19.661  37.404  -8.330  1.00 41.46           C  
ATOM    212  CG  GLU    24      19.095  38.765  -8.702  1.00 58.88           C  
ATOM    213  CD  GLU    24      17.908  38.707  -9.655  1.00 71.12           C  
ATOM    214  OE1 GLU    24      17.830  37.743 -10.453  1.00 72.33           O  
ATOM    215  OE2 GLU    24      17.060  39.637  -9.610  1.00 72.59           O  
ATOM    216  N   GLY    25      19.097  34.634  -5.890  1.00 38.63           N  
ATOM    217  CA  GLY    25      19.656  33.332  -5.487  1.00 35.84           C  
ATOM    218  C   GLY    25      20.919  33.370  -4.642  1.00 39.23           C  
ATOM    219  O   GLY    25      21.433  32.320  -4.260  1.00 36.34           O  
ATOM    220  N   ARG    26      21.434  34.570  -4.363  1.00 31.50           N  
ATOM    221  CA  ARG    26      22.645  34.735  -3.546  1.00 31.87           C  
ATOM    222  C   ARG    26      22.285  35.258  -2.152  1.00 27.89           C  
ATOM    223  O   ARG    26      21.606  36.279  -2.051  1.00 25.53           O  
ATOM    224  CB  ARG    26      23.601  35.715  -4.232  1.00 34.35           C  
ATOM    225  CG  ARG    26      24.062  35.266  -5.640  1.00 46.09           C  
ATOM    226  CD  ARG    26      24.650  33.842  -5.609  1.00 67.45           C  
ATOM    227  NE  ARG    26      24.739  33.221  -6.934  1.00 79.26           N  
ATOM    228  CZ  ARG    26      25.765  33.359  -7.774  1.00 81.40           C  
ATOM    229  NH1 ARG    26      26.814  34.109  -7.449  1.00 76.67           N  
ATOM    230  NH2 ARG    26      25.738  32.746  -8.951  1.00 81.53           N  
ATOM    231  N   ARG    27      22.741  34.579  -1.097  1.00 28.09           N  
ATOM    232  CA  ARG    27      22.516  35.067   0.266  1.00 29.86           C  
ATOM    233  C   ARG    27      23.404  36.265   0.561  1.00 27.38           C  
ATOM    234  O   ARG    27      24.632  36.167   0.521  1.00 27.76           O  
ATOM    235  CB  ARG    27      22.714  33.994   1.345  1.00 28.19           C  
ATOM    236  CG  ARG    27      22.185  34.495   2.724  1.00 27.64           C  
ATOM    237  CD  ARG    27      22.737  33.767   3.968  1.00 32.43           C  
ATOM    238  NE  ARG    27      24.189  33.836   4.100  1.00 26.50           N  
ATOM    239  CZ  ARG    27      24.855  34.923   4.495  1.00 32.07           C  
ATOM    240  NH1 ARG    27      24.213  36.047   4.809  1.00 26.92           N  
ATOM    241  NH2 ARG    27      26.169  34.892   4.579  1.00 32.44           N  
ATOM    242  N   VAL    28      22.789  37.414   0.846  1.00 18.52           N  
ATOM    243  CA  VAL    28      23.609  38.605   1.129  1.00 22.68           C  
ATOM    244  C   VAL    28      23.372  39.166   2.544  1.00 22.19           C  
ATOM    245  O   VAL    28      23.990  40.150   2.928  1.00 22.40           O  
ATOM    246  CB  VAL    28      23.365  39.738   0.098  1.00 24.96           C  
ATOM    247  CG1 VAL    28      23.876  39.321  -1.282  1.00 24.70           C  
ATOM    248  CG2 VAL    28      21.873  40.109   0.066  1.00 28.33           C  
ATOM    249  N   GLY    29      22.451  38.565   3.285  1.00 20.83           N  
ATOM    250  CA  GLY    29      22.212  38.997   4.657  1.00 15.98           C  
ATOM    251  C   GLY    29      21.388  38.062   5.499  1.00 19.37           C  
ATOM    252  O   GLY    29      21.164  36.897   5.142  1.00 24.06           O  
ATOM    253  N   TRP    30      20.973  38.584   6.649  1.00 19.03           N  
ATOM    254  CA  TRP    30      20.178  37.855   7.647  1.00 17.42           C  
ATOM    255  C   TRP    30      19.232  38.867   8.246  1.00 20.49           C  
ATOM    256  O   TRP    30      19.659  39.943   8.660  1.00 20.00           O  
ATOM    257  CB  TRP    30      21.042  37.350   8.791  1.00 23.22           C  
ATOM    258  CG  TRP    30      22.128  36.434   8.394  1.00 25.03           C  
ATOM    259  CD1 TRP    30      23.468  36.727   8.254  1.00 27.24           C  
ATOM    260  CD2 TRP    30      21.986  35.054   8.118  1.00 28.67           C  
ATOM    261  NE1 TRP    30      24.156  35.601   7.893  1.00 31.31           N  
ATOM    262  CE2 TRP    30      23.274  34.556   7.803  1.00 28.47           C  
ATOM    263  CE3 TRP    30      20.896  34.186   8.096  1.00 24.83           C  
ATOM    264  CZ2 TRP    30      23.501  33.216   7.473  1.00 36.90           C  
ATOM    265  CZ3 TRP    30      21.118  32.847   7.769  1.00 36.21           C  
ATOM    266  CH2 TRP    30      22.413  32.379   7.460  1.00 31.44           C  
ATOM    267  N   VAL    31      17.957  38.507   8.323  1.00 17.37           N  
ATOM    268  CA  VAL    31      16.909  39.418   8.827  1.00 19.85           C  
ATOM    269  C   VAL    31      16.218  38.708   9.974  1.00 18.71           C  
ATOM    270  O   VAL    31      15.887  37.527   9.863  1.00 18.44           O  
ATOM    271  CB  VAL    31      15.901  39.734   7.689  1.00 24.44           C  
ATOM    272  CG1 VAL    31      14.615  40.380   8.198  1.00 28.37           C  
ATOM    273  CG2 VAL    31      16.560  40.638   6.637  1.00 24.28           C  
ATOM    274  N   ARG    32      16.008  39.417  11.082  1.00 18.35           N  
ATOM    275  CA  ARG    32      15.317  38.839  12.248  1.00 18.09           C  
ATOM    276  C   ARG    32      13.910  38.390  11.843  1.00 20.69           C  
ATOM    277  O   ARG    32      13.289  39.032  11.011  1.00 20.50           O  
ATOM    278  CB  ARG    32      15.253  39.853  13.387  1.00 26.61           C  
ATOM    279  CG  ARG    32      15.330  39.189  14.723  1.00 39.40           C  
ATOM    280  CD  ARG    32      15.433  40.164  15.878  1.00 32.98           C  
ATOM    281  NE  ARG    32      16.788  40.385  16.397  1.00 27.34           N  
ATOM    282  CZ  ARG    32      17.559  39.468  16.999  1.00 31.20           C  
ATOM    283  NH1 ARG    32      17.168  38.216  17.147  1.00 23.24           N  
ATOM    284  NH2 ARG    32      18.758  39.802  17.443  1.00 29.28           N  
ATOM    285  N   LYS    33      13.453  37.255  12.362  1.00 20.44           N  
ATOM    286  CA  LYS    33      12.118  36.739  11.984  1.00 24.51           C  
ATOM    287  C   LYS    33      10.963  37.745  12.142  1.00 23.04           C  
ATOM    288  O   LYS    33      10.120  37.859  11.246  1.00 20.15           O  
ATOM    289  CB  LYS    33      11.813  35.443  12.738  1.00 25.25           C  
ATOM    290  CG  LYS    33      12.553  34.232  12.191  1.00 24.38           C  
ATOM    291  CD  LYS    33      12.538  33.069  13.190  1.00 22.85           C  
ATOM    292  CE  LYS    33      13.393  31.904  12.653  1.00 29.69           C  
ATOM    293  NZ  LYS    33      13.288  30.715  13.555  1.00 33.21           N  
ATOM    294  N   ALA    34      10.908  38.463  13.263  1.00 23.39           N  
ATOM    295  CA  ALA    34       9.837  39.486  13.438  1.00 23.82           C  
ATOM    296  C   ALA    34       9.931  40.608  12.392  1.00 21.06           C  
ATOM    297  O   ALA    34       8.915  41.079  11.869  1.00 23.26           O  
ATOM    298  CB  ALA    34       9.838  40.053  14.861  1.00 24.14           C  
ATOM    299  N   LEU    35      11.150  41.021  12.057  1.00 21.64           N  
ATOM    300  CA  LEU    35      11.318  42.030  11.020  1.00 22.65           C  
ATOM    301  C   LEU    35      10.867  41.492   9.646  1.00 20.58           C  
ATOM    302  O   LEU    35      10.277  42.233   8.860  1.00 21.78           O  
ATOM    303  CB  LEU    35      12.768  42.517  10.957  1.00 18.60           C  
ATOM    304  CG  LEU    35      13.159  43.481   9.832  1.00 21.60           C  
ATOM    305  CD1 LEU    35      12.357  44.782   9.930  1.00 22.31           C  
ATOM    306  CD2 LEU    35      14.625  43.774   9.959  1.00 17.99           C  
ATOM    307  N   ALA    36      11.134  40.209   9.376  1.00 20.53           N  
ATOM    308  CA  ALA    36      10.707  39.572   8.135  1.00 24.82           C  
ATOM    309  C   ALA    36       9.195  39.669   7.995  1.00 25.43           C  
ATOM    310  O   ALA    36       8.695  39.931   6.891  1.00 25.13           O  
ATOM    311  CB  ALA    36      11.176  38.108   8.077  1.00 18.16           C  
ATOM    312  N   GLN    37       8.487  39.531   9.128  1.00 19.18           N  
ATOM    313  CA  GLN    37       7.026  39.711   9.172  1.00 21.96           C  
ATOM    314  C   GLN    37       6.611  41.128   8.806  1.00 24.15           C  
ATOM    315  O   GLN    37       5.595  41.324   8.129  1.00 28.98           O  
ATOM    316  CB  GLN    37       6.450  39.304  10.526  1.00 24.96           C  
ATOM    317  CG  GLN    37       6.470  37.799  10.786  1.00 41.37           C  
ATOM    318  CD  GLN    37       5.780  36.990   9.688  1.00 51.39           C  
ATOM    319  OE1 GLN    37       4.587  37.161   9.429  1.00 45.08           O  
ATOM    320  NE2 GLN    37       6.534  36.104   9.043  1.00 47.83           N  
ATOM    321  N   ARG    38       7.402  42.119   9.220  1.00 23.70           N  
ATOM    322  CA  ARG    38       7.148  43.510   8.841  0.50 22.14           C  
ATOM    324  C   ARG    38       7.373  43.714   7.341  1.00 27.87           C  
ATOM    325  O   ARG    38       6.623  44.433   6.689  1.00 25.76           O  
ATOM    326  CB  ARG    38       8.025  44.495   9.637  0.50 24.12           C  
ATOM    328  CG  ARG    38       7.914  44.432  11.169  0.50 21.02           C  
ATOM    330  CD  ARG    38       6.591  45.017  11.738  0.50 19.70           C  
ATOM    332  NE  ARG    38       5.452  44.110  11.583  0.50 18.95           N  
ATOM    334  CZ  ARG    38       5.293  42.965  12.246  0.50 23.77           C  
ATOM    336  NH1 ARG    38       4.217  42.214  12.017  0.50 28.31           N  
ATOM    338  NH2 ARG    38       6.198  42.563  13.140  0.50 29.77           N  
ATOM    340  N   LEU    39       8.399  43.069   6.804  1.00 27.55           N  
ATOM    341  CA  LEU    39       8.758  43.182   5.394  1.00 26.92           C  
ATOM    342  C   LEU    39       7.715  42.557   4.451  1.00 28.70           C  
ATOM    343  O   LEU    39       7.550  42.940   3.331  1.00 27.28           O  
ATOM    344  CB  LEU    39      10.122  42.556   5.162  1.00 23.52           C  
ATOM    345  CG  LEU    39      11.339  43.205   5.783  1.00 21.20           C  
ATOM    346  CD1 LEU    39      12.583  42.462   5.385  1.00 23.20           C  
ATOM    347  CD2 LEU    39      11.462  44.614   5.429  1.00 23.96           C  
ATOM    348  N   LYS    40       7.035  41.573   4.967  1.00 24.98           N  
ATOM    349  CA  LYS    40       5.956  40.906   4.311  1.00 32.51           C  
ATOM    350  C   LYS    40       4.847  41.820   3.842  1.00 33.88           C  
ATOM    351  O   LYS    40       4.201  41.545   2.891  1.00 34.37           O  
ATOM    352  CB  LYS    40       5.398  39.871   5.265  1.00 35.26           C  
ATOM    353  CG  LYS    40       4.833  38.712   4.620  1.00 42.25           C  
ATOM    354  CD  LYS    40       4.215  37.788   5.581  1.00 47.99           C  
ATOM    355  CE  LYS    40       5.219  36.895   6.146  1.00 56.22           C  
ATOM    356  NZ  LYS    40       4.614  35.738   6.844  1.00 65.56           N  
ATOM    357  N   ALA    41       4.651  42.919   4.534  1.00 33.32           N  
ATOM    358  CA  ALA    41       3.654  43.879   4.166  1.00 26.43           C  
ATOM    359  C   ALA    41       4.055  44.652   2.919  1.00 31.43           C  
ATOM    360  O   ALA    41       3.262  45.313   2.315  1.00 31.38           O  
ATOM    361  CB  ALA    41       3.446  44.781   5.243  1.00 28.22           C  
ATOM    362  N   HIS    42       5.315  44.560   2.560  1.00 22.14           N  
ATOM    363  CA  HIS    42       5.782  45.155   1.354  1.00 22.67           C  
ATOM    364  C   HIS    42       5.977  44.112   0.240  1.00 24.61           C  
ATOM    365  O   HIS    42       7.041  43.935  -0.242  1.00 21.94           O  
ATOM    366  CB  HIS    42       7.064  45.909   1.625  1.00 23.33           C  
ATOM    367  CG  HIS    42       6.906  47.023   2.603  1.00 26.26           C  
ATOM    368  ND1 HIS    42       6.771  48.327   2.211  1.00 28.75           N  
ATOM    369  CD2 HIS    42       6.846  47.032   3.946  1.00 27.23           C  
ATOM    370  CE1 HIS    42       6.650  49.092   3.270  1.00 29.65           C  
ATOM    371  NE2 HIS    42       6.684  48.330   4.335  1.00 22.96           N  
ATOM    372  N   GLY    43       4.902  43.451  -0.118  1.00 21.77           N  
ATOM    373  CA  GLY    43       4.938  42.357  -1.055  1.00 24.76           C  
ATOM    374  C   GLY    43       5.412  42.645  -2.467  1.00 28.20           C  
ATOM    375  O   GLY    43       5.741  41.776  -3.184  1.00 25.79           O  
ATOM    376  N   ARG    44       5.456  43.907  -2.835  1.00 21.72           N  
ATOM    377  CA  ARG    44       5.914  44.304  -4.161  1.00 24.32           C  
ATOM    378  C   ARG    44       7.437  44.361  -4.225  1.00 20.86           C  
ATOM    379  O   ARG    44       8.019  44.447  -5.305  1.00 23.65           O  
ATOM    380  CB  ARG    44       5.321  45.661  -4.548  1.00 22.47           C  
ATOM    381  CG  ARG    44       3.815  45.643  -4.754  1.00 21.53           C  
ATOM    382  CD  ARG    44       3.289  47.028  -5.094  1.00 22.88           C  
ATOM    383  NE  ARG    44       3.817  47.518  -6.364  1.00 23.77           N  
ATOM    384  CZ  ARG    44       3.800  48.793  -6.738  1.00 28.40           C  
ATOM    385  NH1 ARG    44       3.279  49.714  -5.938  1.00 23.25           N  
ATOM    386  NH2 ARG    44       4.303  49.149  -7.912  1.00 22.34           N  
ATOM    387  N   VAL    45       8.075  44.311  -3.060  1.00 16.84           N  
ATOM    388  CA  VAL    45       9.532  44.444  -2.974  1.00 19.47           C  
ATOM    389  C   VAL    45      10.146  43.169  -2.404  1.00 21.56           C  
ATOM    390  O   VAL    45      11.226  42.779  -2.841  1.00 22.98           O  
ATOM    391  CB  VAL    45       9.907  45.652  -2.097  1.00 19.99           C  
ATOM    392  CG1 VAL    45      11.447  45.847  -1.919  1.00 21.44           C  
ATOM    393  CG2 VAL    45       9.247  46.952  -2.669  1.00 21.74           C  
ATOM    394  N   PHE    46       9.484  42.556  -1.421  1.00 23.63           N  
ATOM    395  CA  PHE    46      10.014  41.345  -0.749  1.00 20.04           C  
ATOM    396  C   PHE    46       9.057  40.164  -0.851  1.00 26.86           C  
ATOM    397  O   PHE    46       7.859  40.313  -0.628  1.00 28.56           O  
ATOM    398  CB  PHE    46      10.268  41.631   0.747  1.00 21.13           C  
ATOM    399  CG  PHE    46      11.314  42.678   1.005  1.00 21.58           C  
ATOM    400  CD1 PHE    46      12.673  42.366   0.922  1.00 26.18           C  
ATOM    401  CD2 PHE    46      10.942  43.978   1.337  1.00 23.12           C  
ATOM    402  CE1 PHE    46      13.650  43.337   1.165  1.00 24.11           C  
ATOM    403  CE2 PHE    46      11.889  44.948   1.576  1.00 21.14           C  
ATOM    404  CZ  PHE    46      13.251  44.646   1.504  1.00 17.18           C  
ATOM    405  N   ASP    47       9.590  38.987  -1.178  1.00 20.78           N  
ATOM    406  CA  ASP    47       8.849  37.730  -1.002  1.00 24.46           C  
ATOM    407  C   ASP    47       9.338  37.080   0.284  1.00 26.67           C  
ATOM    408  O   ASP    47      10.537  36.823   0.431  1.00 31.75           O  
ATOM    409  CB  ASP    47       9.107  36.797  -2.180  1.00 32.25           C  
ATOM    410  CG  ASP    47       8.665  37.398  -3.500  1.00 45.29           C  
ATOM    411  OD1 ASP    47       7.537  37.927  -3.556  1.00 49.98           O  
ATOM    412  OD2 ASP    47       9.446  37.343  -4.473  1.00 54.42           O  
ATOM    413  N   VAL    48       8.430  36.834   1.220  1.00 27.58           N  
ATOM    414  CA  VAL    48       8.826  36.313   2.532  1.00 30.03           C  
ATOM    415  C   VAL    48       8.249  34.926   2.741  1.00 33.16           C  
ATOM    416  O   VAL    48       7.034  34.738   2.683  1.00 34.75           O  
ATOM    417  CB  VAL    48       8.411  37.276   3.708  1.00 29.61           C  
ATOM    418  CG1 VAL    48       8.797  36.679   5.070  1.00 29.77           C  
ATOM    419  CG2 VAL    48       9.052  38.643   3.525  1.00 31.49           C  
ATOM    420  N   THR    49       9.133  33.957   2.966  1.00 28.52           N  
ATOM    421  CA  THR    49       8.723  32.591   3.293  1.00 33.79           C  
ATOM    422  C   THR    49       9.204  32.264   4.698  1.00 37.87           C  
ATOM    423  O   THR    49       9.802  33.109   5.366  1.00 34.40           O  
ATOM    424  CB  THR    49       9.305  31.582   2.285  1.00 33.24           C  
ATOM    425  OG1 THR    49      10.733  31.717   2.232  1.00 42.54           O  
ATOM    426  CG2 THR    49       8.726  31.811   0.890  1.00 38.14           C  
ATOM    427  N   ARG    50       8.966  31.031   5.134  1.00 46.46           N  
ATOM    428  CA  ARG    50       9.394  30.554   6.452  1.00 50.39           C  
ATOM    429  C   ARG    50      10.920  30.552   6.612  1.00 42.25           C  
ATOM    430  O   ARG    50      11.437  30.711   7.717  1.00 50.08           O  
ATOM    431  CB  ARG    50       8.833  29.143   6.689  1.00 51.10           C  
ATOM    432  CG  ARG    50       8.908  28.632   8.125  1.00 65.81           C  
ATOM    433  CD  ARG    50       8.648  27.129   8.184  1.00 65.65           C  
ATOM    434  NE  ARG    50       9.511  26.455   9.160  1.00 82.09           N  
ATOM    435  CZ  ARG    50       9.228  26.304  10.454  1.00 86.34           C  
ATOM    436  NH1 ARG    50       8.094  26.778  10.958  1.00 87.28           N  
ATOM    437  NH2 ARG    50      10.086  25.675  11.248  1.00 84.79           N  
ATOM    438  N   ASP    51      11.629  30.389   5.503  1.00 32.87           N  
ATOM    439  CA  ASP    51      13.077  30.235   5.527  1.00 37.90           C  
ATOM    440  C   ASP    51      13.855  31.424   4.946  1.00 33.77           C  
ATOM    441  O   ASP    51      15.081  31.474   5.085  1.00 33.12           O  
ATOM    442  CB  ASP    51      13.488  28.953   4.773  1.00 46.29           C  
ATOM    443  CG  ASP    51      12.793  27.692   5.302  1.00 57.41           C  
ATOM    444  OD1 ASP    51      12.856  27.426   6.522  1.00 66.19           O  
ATOM    445  OD2 ASP    51      12.195  26.956   4.484  1.00 61.45           O  
ATOM    446  N   ALA    52      13.176  32.363   4.277  1.00 29.51           N  
ATOM    447  CA  ALA    52      13.909  33.400   3.549  1.00 31.37           C  
ATOM    448  C   ALA    52      13.112  34.666   3.256  1.00 27.18           C  
ATOM    449  O   ALA    52      11.890  34.637   3.109  1.00 27.33           O  
ATOM    450  CB  ALA    52      14.477  32.834   2.236  1.00 32.40           C  
ATOM    451  N   VAL    53      13.844  35.771   3.191  1.00 24.06           N  
ATOM    452  CA  VAL    53      13.359  37.013   2.627  1.00 23.42           C  
ATOM    453  C   VAL    53      14.046  37.168   1.268  1.00 27.83           C  
ATOM    454  O   VAL    53      15.281  37.291   1.186  1.00 26.26           O  
ATOM    455  CB  VAL    53      13.720  38.216   3.535  1.00 22.71           C  
ATOM    456  CG1 VAL    53      13.313  39.521   2.909  1.00 23.66           C  
ATOM    457  CG2 VAL    53      13.050  38.097   4.878  1.00 24.13           C  
ATOM    458  N   LEU    54      13.253  37.153   0.201  1.00 22.46           N  
ATOM    459  CA  LEU    54      13.779  37.276  -1.151  1.00 22.52           C  
ATOM    460  C   LEU    54      13.415  38.629  -1.732  1.00 22.04           C  
ATOM    461  O   LEU    54      12.262  39.026  -1.688  1.00 23.72           O  
ATOM    462  CB  LEU    54      13.206  36.181  -2.066  1.00 28.23           C  
ATOM    463  CG  LEU    54      14.094  34.965  -2.357  1.00 44.20           C  
ATOM    464  CD1 LEU    54      14.301  34.149  -1.120  1.00 47.96           C  
ATOM    465  CD2 LEU    54      13.496  34.074  -3.455  1.00 42.25           C  
ATOM    466  N   LEU    55      14.402  39.333  -2.262  1.00 20.07           N  
ATOM    467  CA  LEU    55      14.093  40.556  -2.999  1.00 24.13           C  
ATOM    468  C   LEU    55      13.367  40.173  -4.288  1.00 27.55           C  
ATOM    469  O   LEU    55      13.743  39.198  -4.951  1.00 23.84           O  
ATOM    470  CB  LEU    55      15.370  41.320  -3.291  1.00 25.84           C  
ATOM    471  CG  LEU    55      15.168  42.775  -3.660  1.00 25.00           C  
ATOM    472  CD1 LEU    55      14.453  43.534  -2.557  1.00 23.86           C  
ATOM    473  CD2 LEU    55      16.490  43.392  -3.953  1.00 22.17           C  
ATOM    474  N   SER    56      12.313  40.909  -4.621  1.00 26.26           N  
ATOM    475  CA  SER    56      11.503  40.630  -5.822  1.00 29.54           C  
ATOM    476  C   SER    56      12.328  40.562  -7.109  1.00 27.78           C  
ATOM    477  O   SER    56      13.165  41.423  -7.367  1.00 22.69           O  
ATOM    478  CB  SER    56      10.431  41.699  -6.007  1.00 31.72           C  
ATOM    479  OG  SER    56       9.711  41.455  -7.207  1.00 32.81           O  
ATOM    480  N   ALA    57      12.058  39.545  -7.920  1.00 29.77           N  
ATOM    481  CA  ALA    57      12.789  39.319  -9.167  1.00 32.42           C  
ATOM    482  C   ALA    57      12.470  40.390 -10.205  1.00 33.36           C  
ATOM    483  O   ALA    57      13.229  40.569 -11.147  1.00 34.96           O  
ATOM    484  CB  ALA    57      12.509  37.914  -9.725  1.00 36.66           C  
ATOM    485  N   SER    58      11.376  41.128  -9.990  1.00 28.68           N  
ATOM    486  CA  SER    58      11.012  42.274 -10.826  1.00 28.25           C  
ATOM    487  C   SER    58      11.974  43.463 -10.707  1.00 31.71           C  
ATOM    488  O   SER    58      11.977  44.358 -11.557  1.00 31.32           O  
ATOM    489  CB  SER    58       9.565  42.695 -10.543  1.00 34.24           C  
ATOM    490  OG  SER    58       9.420  43.333  -9.284  1.00 35.76           O  
ATOM    491  N   LEU    59      12.787  43.475  -9.653  1.00 24.78           N  
ATOM    492  CA  LEU    59      13.783  44.526  -9.471  1.00 30.63           C  
ATOM    493  C   LEU    59      15.071  44.018 -10.106  1.00 31.92           C  
ATOM    494  O   LEU    59      15.820  43.244  -9.497  1.00 31.98           O  
ATOM    495  CB  LEU    59      13.955  44.871  -7.980  1.00 29.62           C  
ATOM    496  CG  LEU    59      12.714  45.319  -7.215  1.00 25.65           C  
ATOM    497  CD1 LEU    59      12.954  45.256  -5.702  1.00 25.36           C  
ATOM    498  CD2 LEU    59      12.301  46.719  -7.619  1.00 29.09           C  
ATOM    499  N   ARG    60      15.300  44.459 -11.342  1.00 33.21           N  
ATOM    500  CA  ARG    60      16.249  43.826 -12.253  1.00 36.10           C  
ATOM    501  C   ARG    60      17.617  44.474 -12.231  1.00 33.20           C  
ATOM    502  O   ARG    60      18.578  43.881 -12.717  1.00 44.58           O  
ATOM    503  CB  ARG    60      15.712  43.878 -13.696  1.00 39.12           C  
ATOM    504  CG  ARG    60      14.323  43.261 -13.930  1.00 52.12           C  
ATOM    505  CD  ARG    60      14.402  41.782 -14.285  1.00 67.62           C  
ATOM    506  NE  ARG    60      13.334  41.402 -15.212  1.00 85.24           N  
ATOM    507  CZ  ARG    60      12.391  40.490 -14.977  1.00 88.67           C  
ATOM    508  NH1 ARG    60      12.359  39.816 -13.833  1.00 90.37           N  
ATOM    509  NH2 ARG    60      11.478  40.240 -15.906  1.00 88.09           N  
ATOM    510  N   THR    61      17.700  45.706 -11.724  1.00 29.10           N  
ATOM    511  CA  THR    61      18.947  46.463 -11.718  1.00 26.42           C  
ATOM    512  C   THR    61      19.334  46.835 -10.279  1.00 27.29           C  
ATOM    513  O   THR    61      18.456  46.936  -9.417  1.00 22.73           O  
ATOM    514  CB  THR    61      18.868  47.776 -12.543  1.00 29.34           C  
ATOM    515  OG1 THR    61      18.018  48.728 -11.881  1.00 26.60           O  
ATOM    516  CG2 THR    61      18.422  47.539 -13.999  1.00 24.84           C  
ATOM    517  N   PRO    62      20.634  47.044 -10.018  1.00 25.78           N  
ATOM    518  CA  PRO    62      21.002  47.565  -8.694  1.00 22.69           C  
ATOM    519  C   PRO    62      20.253  48.870  -8.342  1.00 29.65           C  
ATOM    520  O   PRO    62      19.791  49.003  -7.207  1.00 24.80           O  
ATOM    521  CB  PRO    62      22.528  47.800  -8.813  1.00 27.82           C  
ATOM    522  CG  PRO    62      22.973  46.819  -9.858  1.00 31.58           C  
ATOM    523  CD  PRO    62      21.829  46.806 -10.863  1.00 27.50           C  
ATOM    524  N   GLN    63      20.076  49.775  -9.315  1.00 24.51           N  
ATOM    525  CA  GLN    63      19.422  51.067  -9.069  1.00 25.29           C  
ATOM    526  C   GLN    63      17.965  50.872  -8.650  1.00 21.95           C  
ATOM    527  O   GLN    63      17.484  51.547  -7.720  1.00 23.61           O  
ATOM    528  CB  GLN    63      19.507  52.002 -10.296  1.00 31.56           C  
ATOM    529  CG  GLN    63      20.910  52.567 -10.603  1.00 41.77           C  
ATOM    530  CD  GLN    63      21.898  51.536 -11.202  1.00 57.34           C  
ATOM    531  OE1 GLN    63      21.501  50.544 -11.848  1.00 32.51           O  
ATOM    532  NE2 GLN    63      23.202  51.774 -10.973  1.00 51.09           N  
ATOM    533  N   SER    64      17.280  49.920  -9.284  1.00 21.83           N  
ATOM    534  CA  SER    64      15.876  49.666  -8.954  1.00 25.03           C  
ATOM    535  C   SER    64      15.750  49.055  -7.554  1.00 24.32           C  
ATOM    536  O   SER    64      14.890  49.460  -6.775  1.00 20.62           O  
ATOM    537  CB  SER    64      15.192  48.792 -10.011  1.00 28.61           C  
ATOM    538  OG  SER    64      15.627  47.452  -9.913  1.00 30.88           O  
ATOM    539  N   ARG    65      16.631  48.109  -7.241  1.00 20.58           N  
ATOM    540  CA  ARG    65      16.695  47.517  -5.897  1.00 21.14           C  
ATOM    541  C   ARG    65      16.955  48.511  -4.773  1.00 21.18           C  
ATOM    542  O   ARG    65      16.253  48.488  -3.756  1.00 19.62           O  
ATOM    543  CB  ARG    65      17.750  46.409  -5.852  1.00 23.32           C  
ATOM    544  CG  ARG    65      17.463  45.270  -6.805  1.00 18.45           C  
ATOM    545  CD  ARG    65      18.665  44.418  -6.897  1.00 23.80           C  
ATOM    546  NE  ARG    65      18.445  43.302  -7.792  1.00 28.23           N  
ATOM    547  CZ  ARG    65      19.393  42.818  -8.571  1.00 39.35           C  
ATOM    548  NH1 ARG    65      20.600  43.365  -8.529  1.00 26.87           N  
ATOM    549  NH2 ARG    65      19.131  41.801  -9.384  1.00 39.24           N  
ATOM    550  N   THR    66      17.976  49.349  -4.961  1.00 18.13           N  
ATOM    551  CA  THR    66      18.367  50.404  -4.029  1.00 18.63           C  
ATOM    552  C   THR    66      17.207  51.354  -3.731  1.00 22.30           C  
ATOM    553  O   THR    66      16.892  51.610  -2.565  1.00 17.93           O  
ATOM    554  CB  THR    66      19.518  51.206  -4.624  1.00 15.67           C  
ATOM    555  OG1 THR    66      20.662  50.330  -4.794  1.00 19.82           O  
ATOM    556  CG2 THR    66      19.902  52.414  -3.716  1.00 22.75           C  
ATOM    557  N   ARG    67      16.562  51.837  -4.791  1.00 21.29           N  
ATOM    558  CA  ARG    67      15.388  52.717  -4.654  1.00 26.02           C  
ATOM    559  C   ARG    67      14.202  52.034  -3.933  1.00 17.62           C  
ATOM    560  O   ARG    67      13.593  52.643  -3.029  1.00 21.68           O  
ATOM    561  CB  ARG    67      15.032  53.252  -6.059  1.00 24.56           C  
ATOM    562  CG  ARG    67      13.700  53.913  -6.270  1.00 35.10           C  
ATOM    563  CD  ARG    67      13.442  54.083  -7.804  1.00 28.40           C  
ATOM    564  NE  ARG    67      14.538  54.784  -8.478  1.00 34.03           N  
ATOM    565  CZ  ARG    67      15.203  54.347  -9.545  1.00 43.18           C  
ATOM    566  NH1 ARG    67      14.900  53.185 -10.139  1.00 42.38           N  
ATOM    567  NH2 ARG    67      16.184  55.099 -10.032  1.00 51.91           N  
ATOM    568  N   ALA    68      13.898  50.784  -4.297  1.00 21.03           N  
ATOM    569  CA  ALA    68      12.785  50.049  -3.702  1.00 16.16           C  
ATOM    570  C   ALA    68      13.012  49.854  -2.200  1.00 20.76           C  
ATOM    571  O   ALA    68      12.143  50.134  -1.392  1.00 20.74           O  
ATOM    572  CB  ALA    68      12.611  48.667  -4.367  1.00 15.55           C  
ATOM    573  N   VAL    69      14.181  49.335  -1.841  1.00 17.62           N  
ATOM    574  CA  VAL    69      14.494  49.098  -0.428  1.00 17.98           C  
ATOM    575  C   VAL    69      14.677  50.379   0.391  1.00 18.80           C  
ATOM    576  O   VAL    69      14.300  50.412   1.572  1.00 21.34           O  
ATOM    577  CB  VAL    69      15.722  48.180  -0.310  1.00 16.22           C  
ATOM    578  CG1 VAL    69      16.157  47.989   1.146  1.00 17.56           C  
ATOM    579  CG2 VAL    69      15.351  46.828  -0.894  1.00 15.21           C  
ATOM    580  N   ALA    70      15.217  51.420  -0.231  1.00 16.22           N  
ATOM    581  CA  ALA    70      15.393  52.699   0.447  1.00 18.41           C  
ATOM    582  C   ALA    70      14.053  53.236   0.933  1.00 23.35           C  
ATOM    583  O   ALA    70      13.960  53.719   2.057  1.00 20.90           O  
ATOM    584  CB  ALA    70      16.106  53.706  -0.414  1.00 20.53           C  
ATOM    585  N   ASP    71      13.029  53.113   0.093  1.00 19.14           N  
ATOM    586  CA  ASP    71      11.661  53.564   0.421  1.00 22.77           C  
ATOM    587  C   ASP    71      11.066  52.725   1.566  1.00 22.49           C  
ATOM    588  O   ASP    71      10.469  53.270   2.493  1.00 18.09           O  
ATOM    589  CB  ASP    71      10.774  53.529  -0.847  1.00 16.87           C  
ATOM    590  CG  ASP    71       9.287  53.667  -0.537  1.00 22.63           C  
ATOM    591  OD1 ASP    71       8.899  54.604   0.199  1.00 23.94           O  
ATOM    592  OD2 ASP    71       8.512  52.807  -0.986  1.00 23.44           O  
ATOM    593  N   VAL    72      11.256  51.403   1.515  1.00 19.22           N  
ATOM    594  CA  VAL    72      10.769  50.516   2.571  1.00 20.05           C  
ATOM    595  C   VAL    72      11.420  50.874   3.922  1.00 19.36           C  
ATOM    596  O   VAL    72      10.726  51.017   4.927  1.00 19.01           O  
ATOM    597  CB  VAL    72      11.034  49.025   2.216  1.00 20.04           C  
ATOM    598  CG1 VAL    72      10.739  48.072   3.440  1.00 24.21           C  
ATOM    599  CG2 VAL    72      10.201  48.614   1.010  1.00 22.38           C  
ATOM    600  N   VAL    73      12.743  51.023   3.908  1.00 17.33           N  
ATOM    601  CA  VAL    73      13.536  51.443   5.070  1.00 20.26           C  
ATOM    602  C   VAL    73      13.027  52.774   5.630  1.00 22.10           C  
ATOM    603  O   VAL    73      12.812  52.861   6.840  1.00 17.86           O  
ATOM    604  CB  VAL    73      15.051  51.490   4.716  1.00 21.15           C  
ATOM    605  CG1 VAL    73      15.854  52.320   5.724  1.00 22.24           C  
ATOM    606  CG2 VAL    73      15.574  50.041   4.613  1.00 20.63           C  
ATOM    607  N   ASP    74      12.790  53.755   4.746  1.00 20.58           N  
ATOM    608  CA  ASP    74      12.251  55.063   5.119  1.00 18.28           C  
ATOM    609  C   ASP    74      11.020  54.878   5.970  1.00 20.19           C  
ATOM    610  O   ASP    74      10.914  55.452   7.042  1.00 21.19           O  
ATOM    611  CB  ASP    74      11.869  55.914   3.896  1.00 19.53           C  
ATOM    612  CG  ASP    74      13.056  56.564   3.220  1.00 31.44           C  
ATOM    613  OD1 ASP    74      14.149  56.596   3.817  1.00 30.23           O  
ATOM    614  OD2 ASP    74      12.889  57.055   2.076  1.00 33.16           O  
ATOM    615  N   ARG    75      10.109  54.037   5.496  1.00 19.10           N  
ATOM    616  CA  ARG    75       8.804  53.931   6.138  1.00 21.32           C  
ATOM    617  C   ARG    75       8.854  53.063   7.393  1.00 21.32           C  
ATOM    618  O   ARG    75       8.255  53.401   8.398  1.00 17.97           O  
ATOM    619  CB  ARG    75       7.755  53.513   5.125  1.00 19.91           C  
ATOM    620  CG  ARG    75       7.548  54.674   4.110  1.00 20.27           C  
ATOM    621  CD  ARG    75       6.359  54.402   3.225  1.00 22.86           C  
ATOM    622  NE  ARG    75       6.733  53.521   2.129  1.00 25.46           N  
ATOM    623  CZ  ARG    75       6.126  52.384   1.815  1.00 27.49           C  
ATOM    624  NH1 ARG    75       5.079  51.963   2.505  1.00 25.53           N  
ATOM    625  NH2 ARG    75       6.553  51.690   0.767  1.00 23.23           N  
ATOM    626  N   LEU    76       9.635  51.995   7.363  1.00 20.28           N  
ATOM    627  CA  LEU    76       9.884  51.208   8.580  1.00 18.24           C  
ATOM    628  C   LEU    76      10.543  52.045   9.684  1.00 17.75           C  
ATOM    629  O   LEU    76      10.208  51.893  10.865  1.00 18.96           O  
ATOM    630  CB  LEU    76      10.747  49.987   8.241  1.00 18.67           C  
ATOM    631  CG  LEU    76      10.044  48.840   7.491  1.00 24.03           C  
ATOM    632  CD1 LEU    76      11.029  47.720   7.214  1.00 24.96           C  
ATOM    633  CD2 LEU    76       8.841  48.331   8.274  1.00 27.30           C  
ATOM    634  N   ALA    77      11.474  52.925   9.310  1.00 16.73           N  
ATOM    635  CA  ALA    77      12.117  53.812  10.286  1.00 21.15           C  
ATOM    636  C   ALA    77      11.117  54.843  10.818  1.00 22.18           C  
ATOM    637  O   ALA    77      11.066  55.100  12.027  1.00 19.61           O  
ATOM    638  CB  ALA    77      13.325  54.466   9.693  1.00 17.59           C  
ATOM    639  N   ASP    78      10.291  55.395   9.931  1.00 20.66           N  
ATOM    640  CA  ASP    78       9.179  56.292  10.347  1.00 19.06           C  
ATOM    641  C   ASP    78       8.312  55.602  11.411  1.00 18.85           C  
ATOM    642  O   ASP    78       7.870  56.240  12.365  1.00 22.08           O  
ATOM    643  CB  ASP    78       8.266  56.625   9.159  1.00 23.91           C  
ATOM    644  CG  ASP    78       8.888  57.584   8.160  1.00 19.56           C  
ATOM    645  OD1 ASP    78       9.904  58.282   8.455  1.00 22.27           O  
ATOM    646  OD2 ASP    78       8.328  57.646   7.032  1.00 23.65           O  
ATOM    647  N   GLU    79       8.110  54.294  11.256  1.00 19.40           N  
ATOM    648  CA  GLU    79       7.257  53.515  12.140  1.00 18.58           C  
ATOM    649  C   GLU    79       7.984  53.003  13.407  1.00 19.38           C  
ATOM    650  O   GLU    79       7.387  52.305  14.226  1.00 23.70           O  
ATOM    651  CB  GLU    79       6.646  52.344  11.361  1.00 20.27           C  
ATOM    652  CG  GLU    79       5.647  52.804  10.265  1.00 22.77           C  
ATOM    653  CD  GLU    79       5.568  51.905   9.043  1.00 30.88           C  
ATOM    654  OE1 GLU    79       6.058  50.756   9.116  1.00 25.70           O  
ATOM    655  OE2 GLU    79       5.018  52.361   7.992  1.00 25.40           O  
ATOM    656  N   GLY    80       9.262  53.354  13.564  1.00 17.12           N  
ATOM    657  CA  GLY    80      10.044  52.909  14.737  1.00 17.37           C  
ATOM    658  C   GLY    80      10.604  51.500  14.654  1.00 21.05           C  
ATOM    659  O   GLY    80      11.103  50.971  15.658  1.00 22.12           O  
ATOM    660  N   VAL    81      10.558  50.887  13.467  1.00 19.14           N  
ATOM    661  CA  VAL    81      10.930  49.474  13.314  1.00 20.51           C  
ATOM    662  C   VAL    81      12.445  49.248  13.111  1.00 20.06           C  
ATOM    663  O   VAL    81      13.037  48.268  13.647  1.00 17.76           O  
ATOM    664  CB  VAL    81      10.120  48.806  12.186  1.00 25.27           C  
ATOM    665  CG1 VAL    81      10.474  47.322  12.042  1.00 22.76           C  
ATOM    666  CG2 VAL    81       8.654  48.971  12.458  1.00 20.85           C  
ATOM    667  N   VAL    82      13.073  50.146  12.346  1.00 18.25           N  
ATOM    668  CA  VAL    82      14.499  50.035  12.016  1.00 16.89           C  
ATOM    669  C   VAL    82      15.127  51.393  12.281  1.00 16.23           C  
ATOM    670  O   VAL    82      14.387  52.399  12.357  1.00 19.06           O  
ATOM    671  CB  VAL    82      14.720  49.615  10.509  1.00 18.42           C  
ATOM    672  CG1 VAL    82      13.994  48.315  10.210  1.00 16.44           C  
ATOM    673  CG2 VAL    82      14.267  50.713   9.547  1.00 21.23           C  
ATOM    674  N   PRO    83      16.467  51.445  12.420  1.00 19.03           N  
ATOM    675  CA  PRO    83      17.159  52.709  12.574  1.00 16.16           C  
ATOM    676  C   PRO    83      16.935  53.643  11.408  1.00 19.13           C  
ATOM    677  O   PRO    83      16.727  53.205  10.281  1.00 19.03           O  
ATOM    678  CB  PRO    83      18.633  52.274  12.648  1.00 14.32           C  
ATOM    679  CG  PRO    83      18.580  50.895  13.208  1.00 19.67           C  
ATOM    680  CD  PRO    83      17.423  50.315  12.495  1.00 18.96           C  
ATOM    681  N   ALA    84      16.964  54.937  11.681  1.00 19.88           N  
ATOM    682  CA  ALA    84      16.800  55.923  10.623  1.00 19.34           C  
ATOM    683  C   ALA    84      18.026  55.982   9.719  1.00 17.45           C  
ATOM    684  O   ALA    84      19.150  56.024  10.202  1.00 19.89           O  
ATOM    685  CB  ALA    84      16.552  57.280  11.219  1.00 23.23           C  
ATOM    686  N   PRO    85      17.805  55.997   8.393  1.00 20.18           N  
ATOM    687  CA  PRO    85      18.928  56.220   7.463  1.00 23.79           C  
ATOM    688  C   PRO    85      19.585  57.578   7.699  1.00 26.63           C  
ATOM    689  O   PRO    85      18.905  58.550   8.050  1.00 22.39           O  
ATOM    690  CB  PRO    85      18.282  56.124   6.071  1.00 28.43           C  
ATOM    691  CG  PRO    85      16.819  56.059   6.290  1.00 31.93           C  
ATOM    692  CD  PRO    85      16.530  55.736   7.715  1.00 23.72           C  
ATOM    693  N   ARG    86      20.904  57.637   7.571  1.00 21.40           N  
ATOM    694  CA  ARG    86      21.638  58.873   7.856  1.00 25.10           C  
ATOM    695  C   ARG    86      22.387  59.424   6.647  1.00 26.58           C  
ATOM    696  O   ARG    86      23.023  60.469   6.752  1.00 28.84           O  
ATOM    697  CB  ARG    86      22.602  58.662   9.042  1.00 25.49           C  
ATOM    698  CG  ARG    86      21.896  58.067  10.263  1.00 30.08           C  
ATOM    699  CD  ARG    86      22.607  58.369  11.562  1.00 31.92           C  
ATOM    700  NE  ARG    86      22.427  59.762  11.944  1.00 40.56           N  
ATOM    701  CZ  ARG    86      21.426  60.221  12.691  1.00 33.94           C  
ATOM    702  NH1 ARG    86      21.371  61.511  12.968  1.00 31.03           N  
ATOM    703  NH2 ARG    86      20.491  59.408  13.175  1.00 24.20           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
END
