
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  182 ( 1369),  selected  182 , name 2nyu_B
# Molecule2: number of CA atoms  174 ( 1400),  selected  174 , name T0508.pdb
# PARAMETERS: 2nyu_B.T0508.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_B      Q      17          3.866
LGA    Y     2_B      L      18          1.657
LGA    R     3_B      R      19          6.081
LGA    S     4_B      S      20          2.479
LGA    R     5_B      R      21          1.169
LGA    S     6_B      A      22          0.446
LGA    A     7_B      A      23          0.506
LGA    F     8_B      F      24          0.705
LGA    K     9_B      K      25          0.868
LGA    L    10_B      L      26          0.702
LGA    L    11_B      E      27          0.633
LGA    E    12_B      F      28          0.913
LGA    V    13_B      L      29          0.811
LGA    N    14_B      L      30          0.616
LGA    E    15_B      D      31          0.889
LGA    R    16_B      R      32          1.385
LGA    H    17_B      Y      33          1.336
LGA    Q    18_B      R      34          1.484
LGA    I    19_B      V      35          2.269
LGA    L    20_B      V      36          2.272
LGA    R    21_B      R      37          2.475
LGA    P    22_B      K      38          2.705
LGA    G    23_B      G      39          2.088
LGA    L    24_B      D      40          0.912
LGA    R    25_B      A      41          0.561
LGA    V    26_B      V      42          0.402
LGA    L    27_B      I      43          0.701
LGA    D    28_B      E      44          0.687
LGA    C    29_B      I      45          0.296
LGA    G    30_B      G      46          0.304
LGA    A    31_B      S      47          0.352
LGA    A    32_B      S      48          0.435
LGA    P    33_B      P      49          0.508
LGA    G    34_B      G      50          0.623
LGA    A    35_B      G      51          0.560
LGA    W    36_B      W      52          0.555
LGA    S    37_B      T      53          0.746
LGA    Q    38_B      Q      54          0.746
LGA    V    39_B      V      55          0.884
LGA    A    40_B      L      56          0.831
LGA    V    41_B      N      57          0.842
LGA    Q    42_B      S      58          0.303
LGA    K    43_B      L      59          1.343
LGA    V    44_B      A      60          1.768
LGA    N    45_B      -       -           -
LGA    A    46_B      -       -           -
LGA    A    47_B      -       -           -
LGA    G    48_B      -       -           -
LGA    T    49_B      -       -           -
LGA    D    50_B      -       -           -
LGA    P    51_B      -       -           -
LGA    S    52_B      -       -           -
LGA    S    53_B      -       -           -
LGA    P    54_B      -       -           -
LGA    V    55_B      -       -           -
LGA    G    56_B      R      61          1.113
LGA    F    57_B      K      62          0.486
LGA    V    58_B      I      63          0.688
LGA    L    59_B      I      64          1.186
LGA    G    60_B      S      65          0.857
LGA    V    61_B      I      66          0.445
LGA    D    62_B      D      67          0.355
LGA    L    63_B      L      68          0.507
LGA    L    64_B      Q      69          0.663
LGA    H    65_B      E      70          0.674
LGA    I    66_B      M      71          0.970
LGA    F    67_B      E      72          0.781
LGA    P    68_B      E      73          0.506
LGA    L    69_B      I      74          0.875
LGA    E    70_B      A      75          1.751
LGA    G    71_B      G      76          2.576
LGA    A    72_B      V      77          1.129
LGA    T    73_B      R      78          1.400
LGA    F    74_B      F      79          0.787
LGA    L    75_B      I      80          0.803
LGA    C    76_B      R      81          1.639
LGA    P    77_B      -       -           -
LGA    A    78_B      C      82          0.832
LGA    D    79_B      D      83          0.778
LGA    V    80_B      I      84          1.759
LGA    T    81_B      F      85          2.280
LGA    D    82_B      K      86          2.292
LGA    P    83_B      E      87          3.389
LGA    R    84_B      T      88          0.818
LGA    T    85_B      I      89          1.734
LGA    S    86_B      F      90          1.907
LGA    Q    87_B      D      91          1.597
LGA    R    88_B      D      92          0.936
LGA    I    89_B      I      93          1.171
LGA    L    90_B      D      94          1.985
LGA    E    91_B      R      95          1.478
LGA    V    92_B      A      96          0.873
LGA    L    93_B      L      97          2.351
LGA    -       -      R      98           -
LGA    -       -      E      99           -
LGA    -       -      E     100           -
LGA    P    94_B      G     101          3.468
LGA    G    95_B      I     102          1.627
LGA    R    96_B      E     103          3.567
LGA    R    97_B      K     104          2.387
LGA    A    98_B      V     105          1.530
LGA    D    99_B      D     106          0.699
LGA    V   100_B      D     107          0.507
LGA    I   101_B      V     108          0.470
LGA    L   102_B      V     109          0.542
LGA    S   103_B      S     110          0.320
LGA    D   104_B      D     111          0.402
LGA    M   105_B      A     112          0.569
LGA    A   106_B      M     113          0.743
LGA    P   107_B      A     114          1.734
LGA    N   108_B      K     115          1.253
LGA    A   109_B      V     116          1.593
LGA    T   110_B      S     117          2.591
LGA    G   111_B      G     118          3.820
LGA    F   112_B      I     119          3.908
LGA    R   113_B      P     120          2.986
LGA    D   114_B      S     121          0.888
LGA    L   115_B      R     122          1.981
LGA    D   116_B      D     123          1.939
LGA    H   117_B      H     124          0.752
LGA    D   118_B      A     125          1.295
LGA    R   119_B      V     126          1.519
LGA    L   120_B      S     127          0.496
LGA    I   121_B      Y     128          0.932
LGA    S   122_B      Q     129          1.553
LGA    L   123_B      I     130          1.072
LGA    C   124_B      G     131          0.411
LGA    L   125_B      Q     132          1.069
LGA    T   126_B      R     133          1.720
LGA    L   127_B      V     134          1.652
LGA    L   128_B      M     135          0.902
LGA    S   129_B      E     136          1.874
LGA    V   130_B      I     137          2.778
LGA    T   131_B      A     138          2.193
LGA    P   132_B      V     139          2.278
LGA    D   133_B      R     140          1.495
LGA    I   134_B      Y     141          1.060
LGA    L   135_B      L     142          1.106
LGA    Q   136_B      R     143          1.137
LGA    P   137_B      N     144          1.499
LGA    G   138_B      G     145          0.933
LGA    G   139_B      G     146          0.441
LGA    T   140_B      N     147          0.393
LGA    F   141_B      V     148          0.382
LGA    L   142_B      L     149          0.372
LGA    C   143_B      L     150          0.372
LGA    K   144_B      K     151          0.371
LGA    T   145_B      Q     152          0.804
LGA    W   146_B      F     153          1.102
LGA    A   147_B      Q     154          1.923
LGA    G   148_B      G     155          1.320
LGA    S   149_B      D     156          1.850
LGA    Q   150_B      M     157          1.373
LGA    S   151_B      T     158          0.796
LGA    R   152_B      N     159          1.388
LGA    R   153_B      D     160          2.120
LGA    L   154_B      F     161          1.365
LGA    Q   155_B      I     162          0.667
LGA    R   156_B      A     163          1.088
LGA    R   157_B      I     164          1.869
LGA    L   158_B      W     165          2.105
LGA    T   159_B      R     166          1.518
LGA    E   160_B      K     167          0.960
LGA    E   161_B      N     168          1.122
LGA    F   162_B      F     169          0.672
LGA    Q   163_B      S     170          0.852
LGA    N   164_B      S     171          0.472
LGA    V   165_B      Y     172          0.611
LGA    R   166_B      K     173          0.450
LGA    I   167_B      I     174          0.685
LGA    I   168_B      S     175          0.769
LGA    K   169_B      K     176          1.088
LGA    -       -      P     177           -
LGA    S   177_B      S     184          5.073
LGA    S   178_B      S     185          4.123
LGA    E   179_B      E     186          1.661
LGA    V   180_B      I     187          0.586
LGA    Y   181_B      Y     188          0.594
LGA    F   182_B      I     189          0.595
LGA    L   183_B      M     190          0.652
LGA    A   184_B      F     191          0.397
LGA    T   185_B      F     192          0.640
LGA    Q   186_B      G     193          0.390
LGA    Y   187_B      F     194          0.490
LGA    H   188_B      K     195          0.713
LGA    G   189_B      A     196          2.801

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  182  174    5.0    170    1.60    25.29     90.167    10.026

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.729507 * X  +   0.630496 * Y  +  -0.265131 * Z  + -11.460607
  Y_new =   0.195135 * X  +  -0.563376 * Y  +  -0.802826 * Z  +  30.471455
  Z_new =  -0.655547 * X  +   0.533931 * Y  +  -0.534019 * Z  +  13.627490 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.356277   -0.785316  [ DEG:   135.0047    -44.9953 ]
  Theta =   0.714907    2.426686  [ DEG:    40.9611    139.0389 ]
  Phi   =   0.261370   -2.880223  [ DEG:    14.9754   -165.0246 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nyu_B                                        
REMARK     2: T0508.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nyu_B.T0508.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  182  174   5.0  170   1.60   25.29  90.167
REMARK  ---------------------------------------------------------- 
MOLECULE 2nyu_B
HEADER    TRANSFERASE                             21-NOV-06   2NYU              
TITLE     CRYSTAL STRUCTURE OF HUMAN FTSJ HOMOLOG 2 (E.COLI) PROTEIN            
TITLE    2 IN COMPLEX WITH S-ADENOSYLMETHIONINE                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE RIBOSOMAL RNA METHYLTRANSFERASE 2;                
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 51-246;                                           
COMPND   5 SYNONYM: RRNA (URIDINE-2'-O-)-METHYLTRANSFERASE;                     
COMPND   6 EC: 2.1.1.-;                                                         
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: FTSJ2, FJH1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 CODON PLUS RIL;                       
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: P28-LIC-THROMBIN DERIVED FROM             
SOURCE  10 PET28                                                                
KEYWDS    TRANSFERASE, SAM, RIBOSOMAL RNA, STRUCTURAL GENOMICS,                 
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, SGC                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.DONG,H.WU,H.ZENG,P.LOPPNAU,J.WEIGELT,M.SUNDSTROM,                   
AUTHOR   2 C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,A.N.PLOTNIKOV,                
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   05-DEC-06 2NYU    0                                                
JRNL        AUTH   H.WU,A.DONG,H.ZENG,P.LOPPNAU,J.WEIGELT,M.SUNDSTROM,          
JRNL        AUTH 2 C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,                      
JRNL        AUTH 3 A.N.PLOTNIKOV                                                
JRNL        TITL   THE CRYSTAL STRUCTURE OF HUMAN FTSJ HOMOLOG 2                
JRNL        TITL 2 (E.COLI) PROTEIN IN COMPLEX WITH ADOMET                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.76 ANGSTROMS.                                          
DBREF  2NYU A    1   196  UNP    Q9UI43   RRMJ2_HUMAN     51    246             
DBREF  2NYU B    1   196  UNP    Q9UI43   RRMJ2_HUMAN     51    246             
SEQRES   1 A  196  SER TYR ARG SER ARG SER ALA PHE LYS LEU LEU GLU VAL          
SEQRES   2 A  196  ASN GLU ARG HIS GLN ILE LEU ARG PRO GLY LEU ARG VAL          
SEQRES   3 A  196  LEU ASP CYS GLY ALA ALA PRO GLY ALA TRP SER GLN VAL          
SEQRES   4 A  196  ALA VAL GLN LYS VAL ASN ALA ALA GLY THR ASP PRO SER          
SEQRES   5 A  196  SER PRO VAL GLY PHE VAL LEU GLY VAL ASP LEU LEU HIS          
SEQRES   6 A  196  ILE PHE PRO LEU GLU GLY ALA THR PHE LEU CYS PRO ALA          
SEQRES   7 A  196  ASP VAL THR ASP PRO ARG THR SER GLN ARG ILE LEU GLU          
SEQRES   8 A  196  VAL LEU PRO GLY ARG ARG ALA ASP VAL ILE LEU SER ASP          
SEQRES   9 A  196  MET ALA PRO ASN ALA THR GLY PHE ARG ASP LEU ASP HIS          
SEQRES  10 A  196  ASP ARG LEU ILE SER LEU CYS LEU THR LEU LEU SER VAL          
SEQRES  11 A  196  THR PRO ASP ILE LEU GLN PRO GLY GLY THR PHE LEU CYS          
SEQRES  12 A  196  LYS THR TRP ALA GLY SER GLN SER ARG ARG LEU GLN ARG          
SEQRES  13 A  196  ARG LEU THR GLU GLU PHE GLN ASN VAL ARG ILE ILE LYS          
SEQRES  14 A  196  PRO GLU ALA SER ARG LYS GLU SER SER GLU VAL TYR PHE          
SEQRES  15 A  196  LEU ALA THR GLN TYR HIS GLY ARG LYS GLY THR VAL LYS          
SEQRES  16 A  196  GLN                                                          
SEQRES   1 B  196  SER TYR ARG SER ARG SER ALA PHE LYS LEU LEU GLU VAL          
SEQRES   2 B  196  ASN GLU ARG HIS GLN ILE LEU ARG PRO GLY LEU ARG VAL          
SEQRES   3 B  196  LEU ASP CYS GLY ALA ALA PRO GLY ALA TRP SER GLN VAL          
SEQRES   4 B  196  ALA VAL GLN LYS VAL ASN ALA ALA GLY THR ASP PRO SER          
SEQRES   5 B  196  SER PRO VAL GLY PHE VAL LEU GLY VAL ASP LEU LEU HIS          
SEQRES   6 B  196  ILE PHE PRO LEU GLU GLY ALA THR PHE LEU CYS PRO ALA          
SEQRES   7 B  196  ASP VAL THR ASP PRO ARG THR SER GLN ARG ILE LEU GLU          
SEQRES   8 B  196  VAL LEU PRO GLY ARG ARG ALA ASP VAL ILE LEU SER ASP          
SEQRES   9 B  196  MET ALA PRO ASN ALA THR GLY PHE ARG ASP LEU ASP HIS          
SEQRES  10 B  196  ASP ARG LEU ILE SER LEU CYS LEU THR LEU LEU SER VAL          
SEQRES  11 B  196  THR PRO ASP ILE LEU GLN PRO GLY GLY THR PHE LEU CYS          
SEQRES  12 B  196  LYS THR TRP ALA GLY SER GLN SER ARG ARG LEU GLN ARG          
SEQRES  13 B  196  ARG LEU THR GLU GLU PHE GLN ASN VAL ARG ILE ILE LYS          
SEQRES  14 B  196  PRO GLU ALA SER ARG LYS GLU SER SER GLU VAL TYR PHE          
SEQRES  15 B  196  LEU ALA THR GLN TYR HIS GLY ARG LYS GLY THR VAL LYS          
SEQRES  16 B  196  GLN                                                          
HET    SAM  A 201      27                                                       
HET    SAM  B 201      27                                                       
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   3  SAM    2(C15 H22 N6 O5 S)                                           
FORMUL   5  HOH   *201(H2 O)                                                    
CRYST1  102.022  102.022   37.068  90.00  90.00  90.00 P 43          8          
ATOM   1405  N   SER B   1      27.728  18.891  21.937  1.00 52.72           N  
ATOM   1406  CA  SER B   1      27.138  19.240  23.269  1.00 54.26           C  
ATOM   1407  C   SER B   1      27.023  20.755  23.404  1.00 58.21           C  
ATOM   1408  O   SER B   1      27.745  21.377  24.255  1.00 66.56           O  
ATOM   1409  CB  SER B   1      28.020  18.663  24.404  1.00 60.69           C  
ATOM   1410  N   TYR B   2      26.177  21.380  22.568  1.00 54.44           N  
ATOM   1411  CA  TYR B   2      25.315  20.677  21.573  1.00 46.74           C  
ATOM   1412  C   TYR B   2      25.839  20.788  20.115  1.00 45.32           C  
ATOM   1413  O   TYR B   2      26.608  21.704  19.785  1.00 49.04           O  
ATOM   1414  CB  TYR B   2      23.860  21.162  21.665  1.00 45.21           C  
ATOM   1415  CG  TYR B   2      23.177  20.757  22.936  1.00 46.56           C  
ATOM   1416  CD1 TYR B   2      22.839  19.428  23.171  1.00 44.88           C  
ATOM   1417  CD2 TYR B   2      22.912  21.702  23.946  1.00 50.87           C  
ATOM   1418  CE1 TYR B   2      22.227  19.038  24.390  1.00 45.74           C  
ATOM   1419  CE2 TYR B   2      22.286  21.331  25.150  1.00 54.75           C  
ATOM   1420  CZ  TYR B   2      21.950  19.996  25.355  1.00 53.72           C  
ATOM   1421  OH  TYR B   2      21.365  19.611  26.534  1.00 57.59           O  
ATOM   1422  N   ARG B   3      25.437  19.842  19.258  1.00 41.18           N  
ATOM   1423  CA  ARG B   3      25.983  19.763  17.905  1.00 40.21           C  
ATOM   1424  C   ARG B   3      25.453  20.862  16.994  1.00 40.75           C  
ATOM   1425  O   ARG B   3      26.010  21.120  15.921  1.00 42.29           O  
ATOM   1426  CB  ARG B   3      25.714  18.382  17.293  1.00 37.57           C  
ATOM   1427  CG  ARG B   3      26.563  17.274  17.936  1.00 37.32           C  
ATOM   1428  CD  ARG B   3      26.174  15.887  17.464  1.00 39.00           C  
ATOM   1429  NE  ARG B   3      27.039  14.888  18.102  1.00 39.17           N  
ATOM   1430  CZ  ARG B   3      27.121  13.605  17.756  1.00 39.41           C  
ATOM   1431  NH1 ARG B   3      26.357  13.110  16.784  1.00 37.74           N  
ATOM   1432  NH2 ARG B   3      27.956  12.801  18.425  1.00 40.15           N  
ATOM   1433  N   SER B   4      24.342  21.447  17.406  1.00 38.82           N  
ATOM   1434  CA  SER B   4      23.609  22.428  16.631  1.00 39.66           C  
ATOM   1435  C   SER B   4      22.754  23.293  17.573  1.00 40.22           C  
ATOM   1436  O   SER B   4      22.365  22.862  18.670  1.00 40.96           O  
ATOM   1437  CB  SER B   4      22.698  21.723  15.592  1.00 36.96           C  
ATOM   1438  OG  SER B   4      21.890  22.650  14.873  1.00 39.47           O  
ATOM   1439  N   ARG B   5      22.379  24.461  17.074  1.00 40.67           N  
ATOM   1440  CA  ARG B   5      21.421  25.362  17.712  1.00 40.54           C  
ATOM   1441  C   ARG B   5      20.011  24.756  17.917  1.00 36.04           C  
ATOM   1442  O   ARG B   5      19.257  25.200  18.799  1.00 38.45           O  
ATOM   1443  CB  ARG B   5      21.304  26.631  16.861  1.00 43.71           C  
ATOM   1444  N   SER B   6      19.665  23.748  17.104  0.50 32.46           N  
ATOM   1446  CA  SER B   6      18.340  23.132  17.184  0.50 30.52           C  
ATOM   1448  C   SER B   6      18.059  22.643  18.601  0.50 30.29           C  
ATOM   1450  O   SER B   6      16.934  22.734  19.068  0.50 31.37           O  
ATOM   1452  CB  SER B   6      18.227  21.955  16.209  0.50 28.13           C  
ATOM   1454  OG  SER B   6      18.766  22.302  14.960  0.50 32.05           O  
ATOM   1456  N   ALA B   7      19.098  22.150  19.278  1.00 31.73           N  
ATOM   1457  CA  ALA B   7      18.962  21.616  20.635  1.00 33.78           C  
ATOM   1458  C   ALA B   7      18.108  22.488  21.518  1.00 34.35           C  
ATOM   1459  O   ALA B   7      17.248  21.986  22.252  1.00 34.55           O  
ATOM   1460  CB  ALA B   7      20.357  21.388  21.299  1.00 34.25           C  
ATOM   1461  N   PHE B   8      18.321  23.801  21.436  1.00 34.51           N  
ATOM   1462  CA  PHE B   8      17.671  24.729  22.363  1.00 36.91           C  
ATOM   1463  C   PHE B   8      16.167  24.817  22.139  1.00 37.11           C  
ATOM   1464  O   PHE B   8      15.425  24.989  23.105  1.00 36.96           O  
ATOM   1465  CB  PHE B   8      18.366  26.099  22.368  1.00 39.77           C  
ATOM   1466  CG  PHE B   8      19.841  26.003  22.590  1.00 41.04           C  
ATOM   1467  CD1 PHE B   8      20.347  25.524  23.795  1.00 42.16           C  
ATOM   1468  CD2 PHE B   8      20.737  26.338  21.577  1.00 40.75           C  
ATOM   1469  CE1 PHE B   8      21.719  25.371  23.986  1.00 40.60           C  
ATOM   1470  CE2 PHE B   8      22.104  26.214  21.775  1.00 42.00           C  
ATOM   1471  CZ  PHE B   8      22.591  25.721  22.983  1.00 41.78           C  
ATOM   1472  N   LYS B   9      15.730  24.539  20.891  1.00 34.99           N  
ATOM   1473  CA  LYS B   9      14.309  24.498  20.527  1.00 35.80           C  
ATOM   1474  C   LYS B   9      13.629  23.285  21.118  1.00 34.20           C  
ATOM   1475  O   LYS B   9      12.491  23.359  21.609  1.00 35.07           O  
ATOM   1476  CB  LYS B   9      14.135  24.507  19.004  1.00 35.53           C  
ATOM   1477  CG  LYS B   9      14.866  25.635  18.330  1.00 41.57           C  
ATOM   1478  CD  LYS B   9      14.175  26.035  17.044  1.00 46.83           C  
ATOM   1479  CE  LYS B   9      15.145  26.669  16.091  1.00 50.17           C  
ATOM   1480  NZ  LYS B   9      15.899  25.622  15.350  1.00 55.06           N  
ATOM   1481  N   LEU B  10      14.328  22.168  21.137  1.00 31.47           N  
ATOM   1482  CA  LEU B  10      13.743  20.990  21.699  1.00 31.01           C  
ATOM   1483  C   LEU B  10      13.740  21.121  23.221  1.00 32.19           C  
ATOM   1484  O   LEU B  10      12.790  20.745  23.874  1.00 31.72           O  
ATOM   1485  CB  LEU B  10      14.534  19.771  21.286  1.00 31.11           C  
ATOM   1486  CG  LEU B  10      14.015  18.434  21.831  1.00 31.06           C  
ATOM   1487  CD1 LEU B  10      12.629  18.111  21.392  1.00 28.42           C  
ATOM   1488  CD2 LEU B  10      15.032  17.337  21.398  1.00 30.81           C  
ATOM   1489  N   LEU B  11      14.813  21.647  23.767  1.00 32.04           N  
ATOM   1490  CA  LEU B  11      14.828  21.894  25.246  1.00 34.79           C  
ATOM   1491  C   LEU B  11      13.633  22.703  25.712  1.00 35.58           C  
ATOM   1492  O   LEU B  11      12.974  22.351  26.723  1.00 36.49           O  
ATOM   1493  CB  LEU B  11      16.135  22.529  25.659  1.00 34.99           C  
ATOM   1494  CG  LEU B  11      17.248  21.486  25.723  1.00 36.33           C  
ATOM   1495  CD1 LEU B  11      18.643  22.069  25.646  1.00 37.39           C  
ATOM   1496  CD2 LEU B  11      17.058  20.568  26.963  1.00 36.68           C  
ATOM   1497  N   GLU B  12      13.350  23.783  24.975  1.00 36.35           N  
ATOM   1498  CA  GLU B  12      12.260  24.702  25.271  1.00 38.22           C  
ATOM   1499  C   GLU B  12      10.916  24.023  25.185  1.00 37.32           C  
ATOM   1500  O   GLU B  12      10.091  24.142  26.098  1.00 36.80           O  
ATOM   1501  CB  GLU B  12      12.315  25.886  24.302  1.00 41.37           C  
ATOM   1502  CG  GLU B  12      12.010  27.178  24.931  1.00 48.20           C  
ATOM   1503  CD  GLU B  12      10.650  27.744  24.535  1.00 56.73           C  
ATOM   1504  OE1 GLU B  12      10.614  28.861  23.956  1.00 62.53           O  
ATOM   1505  OE2 GLU B  12       9.619  27.099  24.842  1.00 59.40           O  
ATOM   1506  N   VAL B  13      10.676  23.308  24.087  1.00 33.55           N  
ATOM   1507  CA  VAL B  13       9.448  22.504  23.966  1.00 33.02           C  
ATOM   1508  C   VAL B  13       9.301  21.515  25.118  1.00 32.87           C  
ATOM   1509  O   VAL B  13       8.242  21.409  25.741  1.00 32.54           O  
ATOM   1510  CB  VAL B  13       9.427  21.708  22.618  1.00 32.10           C  
ATOM   1511  CG1 VAL B  13       8.236  20.691  22.583  1.00 31.11           C  
ATOM   1512  CG2 VAL B  13       9.373  22.678  21.455  1.00 34.71           C  
ATOM   1513  N   ASN B  14      10.370  20.798  25.436  1.00 31.60           N  
ATOM   1514  CA  ASN B  14      10.300  19.865  26.572  1.00 32.02           C  
ATOM   1515  C   ASN B  14      10.094  20.556  27.943  1.00 33.22           C  
ATOM   1516  O   ASN B  14       9.345  20.057  28.794  1.00 34.65           O  
ATOM   1517  CB  ASN B  14      11.545  19.003  26.623  1.00 33.62           C  
ATOM   1518  CG  ASN B  14      11.418  17.879  27.603  1.00 34.46           C  
ATOM   1519  OD1 ASN B  14      10.457  17.117  27.558  1.00 39.22           O  
ATOM   1520  ND2 ASN B  14      12.380  17.750  28.472  1.00 39.52           N  
ATOM   1521  N   GLU B  15      10.757  21.679  28.169  1.00 32.53           N  
ATOM   1522  CA  GLU B  15      10.544  22.426  29.445  1.00 34.77           C  
ATOM   1523  C   GLU B  15       9.059  22.770  29.621  1.00 34.44           C  
ATOM   1524  O   GLU B  15       8.497  22.564  30.704  1.00 36.06           O  
ATOM   1525  CB  GLU B  15      11.405  23.685  29.508  1.00 37.22           C  
ATOM   1526  CG  GLU B  15      11.099  24.522  30.738  1.00 44.16           C  
ATOM   1527  CD  GLU B  15      11.629  23.908  32.022  1.00 51.05           C  
ATOM   1528  OE1 GLU B  15      12.490  22.997  31.930  1.00 54.25           O  
ATOM   1529  OE2 GLU B  15      11.207  24.369  33.129  1.00 58.90           O  
ATOM   1530  N   ARG B  16       8.401  23.223  28.539  1.00 34.03           N  
ATOM   1531  CA  ARG B  16       7.006  23.597  28.623  1.00 36.33           C  
ATOM   1532  C   ARG B  16       6.053  22.417  28.604  1.00 33.53           C  
ATOM   1533  O   ARG B  16       5.012  22.457  29.274  1.00 34.58           O  
ATOM   1534  CB  ARG B  16       6.625  24.552  27.506  1.00 37.20           C  
ATOM   1535  CG  ARG B  16       7.254  25.940  27.607  1.00 47.62           C  
ATOM   1536  CD  ARG B  16       6.871  26.759  26.358  1.00 57.41           C  
ATOM   1537  NE  ARG B  16       7.168  25.985  25.153  1.00 59.23           N  
ATOM   1538  CZ  ARG B  16       6.512  26.057  24.003  1.00 58.04           C  
ATOM   1539  NH1 ARG B  16       5.470  26.861  23.858  1.00 60.28           N  
ATOM   1540  NH2 ARG B  16       6.891  25.284  23.013  1.00 54.91           N  
ATOM   1541  N   HIS B  17       6.351  21.411  27.778  1.00 31.83           N  
ATOM   1542  CA  HIS B  17       5.334  20.394  27.460  1.00 30.06           C  
ATOM   1543  C   HIS B  17       5.610  19.024  28.010  1.00 28.91           C  
ATOM   1544  O   HIS B  17       4.749  18.161  27.941  1.00 29.68           O  
ATOM   1545  CB  HIS B  17       5.081  20.326  25.951  1.00 31.09           C  
ATOM   1546  CG  HIS B  17       4.677  21.639  25.345  1.00 32.39           C  
ATOM   1547  ND1 HIS B  17       3.387  22.132  25.418  1.00 34.70           N  
ATOM   1548  CD2 HIS B  17       5.396  22.563  24.670  1.00 33.38           C  
ATOM   1549  CE1 HIS B  17       3.333  23.304  24.805  1.00 35.59           C  
ATOM   1550  NE2 HIS B  17       4.539  23.586  24.337  1.00 33.61           N  
ATOM   1551  N   GLN B  18       6.808  18.818  28.549  1.00 28.25           N  
ATOM   1552  CA  GLN B  18       7.146  17.612  29.319  1.00 27.44           C  
ATOM   1553  C   GLN B  18       6.883  16.360  28.497  1.00 31.01           C  
ATOM   1554  O   GLN B  18       6.103  15.506  28.884  1.00 33.61           O  
ATOM   1555  CB  GLN B  18       6.374  17.551  30.697  1.00 30.17           C  
ATOM   1556  CG  GLN B  18       6.728  18.709  31.613  1.00 27.34           C  
ATOM   1557  CD  GLN B  18       5.798  18.780  32.767  1.00 29.31           C  
ATOM   1558  OE1 GLN B  18       4.718  19.343  32.664  1.00 31.62           O  
ATOM   1559  NE2 GLN B  18       6.198  18.195  33.872  1.00 34.34           N  
ATOM   1560  N   ILE B  19       7.524  16.267  27.333  1.00 34.22           N  
ATOM   1561  CA  ILE B  19       7.256  15.123  26.421  1.00 35.24           C  
ATOM   1562  C   ILE B  19       8.273  14.013  26.538  1.00 34.56           C  
ATOM   1563  O   ILE B  19       8.050  12.884  26.034  1.00 36.73           O  
ATOM   1564  CB  ILE B  19       7.152  15.568  24.969  1.00 34.50           C  
ATOM   1565  CG1 ILE B  19       8.295  16.545  24.654  1.00 34.06           C  
ATOM   1566  CG2 ILE B  19       5.765  16.198  24.717  1.00 36.17           C  
ATOM   1567  CD1 ILE B  19       8.573  16.733  23.110  1.00 35.11           C  
ATOM   1568  N   LEU B  20       9.402  14.325  27.182  1.00 34.70           N  
ATOM   1569  CA  LEU B  20      10.470  13.351  27.403  1.00 34.10           C  
ATOM   1570  C   LEU B  20      10.688  13.090  28.862  1.00 36.16           C  
ATOM   1571  O   LEU B  20      10.827  14.036  29.678  1.00 37.44           O  
ATOM   1572  CB  LEU B  20      11.788  13.811  26.745  1.00 33.95           C  
ATOM   1573  CG  LEU B  20      11.668  14.188  25.252  1.00 30.87           C  
ATOM   1574  CD1 LEU B  20      12.930  14.936  24.791  1.00 32.02           C  
ATOM   1575  CD2 LEU B  20      11.440  12.900  24.391  1.00 28.74           C  
ATOM   1576  N   ARG B  21      10.660  11.806  29.218  1.00 35.04           N  
ATOM   1577  CA  ARG B  21      10.938  11.401  30.587  1.00 36.57           C  
ATOM   1578  C   ARG B  21      11.619  10.056  30.575  1.00 35.59           C  
ATOM   1579  O   ARG B  21      11.549   9.324  29.578  1.00 35.22           O  
ATOM   1580  CB  ARG B  21       9.658  11.322  31.429  1.00 36.43           C  
ATOM   1581  CG  ARG B  21       8.667  10.223  30.967  1.00 38.70           C  
ATOM   1582  CD  ARG B  21       7.449  10.106  31.952  1.00 39.61           C  
ATOM   1583  NE  ARG B  21       6.636   8.921  31.651  1.00 41.62           N  
ATOM   1584  CZ  ARG B  21       5.786   8.856  30.621  1.00 42.51           C  
ATOM   1585  NH1 ARG B  21       5.606   9.914  29.828  1.00 41.76           N  
ATOM   1586  NH2 ARG B  21       5.107   7.743  30.381  1.00 42.96           N  
ATOM   1587  N   PRO B  22      12.285   9.709  31.696  1.00 38.14           N  
ATOM   1588  CA  PRO B  22      12.987   8.437  31.724  1.00 36.79           C  
ATOM   1589  C   PRO B  22      12.179   7.218  31.328  1.00 35.98           C  
ATOM   1590  O   PRO B  22      10.960   7.062  31.742  1.00 35.94           O  
ATOM   1591  CB  PRO B  22      13.514   8.361  33.148  1.00 37.38           C  
ATOM   1592  CG  PRO B  22      13.775   9.779  33.482  1.00 41.30           C  
ATOM   1593  CD  PRO B  22      12.537  10.480  32.936  1.00 38.70           C  
ATOM   1594  N   GLY B  23      12.863   6.382  30.520  1.00 35.68           N  
ATOM   1595  CA  GLY B  23      12.344   5.134  29.991  1.00 35.95           C  
ATOM   1596  C   GLY B  23      11.577   5.205  28.679  1.00 34.30           C  
ATOM   1597  O   GLY B  23      11.241   4.165  28.123  1.00 35.56           O  
ATOM   1598  N   LEU B  24      11.326   6.406  28.141  1.00 32.22           N  
ATOM   1599  CA  LEU B  24      10.533   6.460  26.917  1.00 30.45           C  
ATOM   1600  C   LEU B  24      11.425   6.056  25.765  1.00 30.26           C  
ATOM   1601  O   LEU B  24      12.598   6.265  25.831  1.00 30.54           O  
ATOM   1602  CB  LEU B  24       9.986   7.847  26.699  1.00 31.54           C  
ATOM   1603  CG  LEU B  24       8.825   8.250  27.604  1.00 30.15           C  
ATOM   1604  CD1 LEU B  24       8.141   9.442  26.978  1.00 31.03           C  
ATOM   1605  CD2 LEU B  24       7.802   7.118  27.804  1.00 32.88           C  
ATOM   1606  N   ARG B  25      10.849   5.393  24.752  1.00 29.23           N  
ATOM   1607  CA  ARG B  25      11.575   5.024  23.549  1.00 31.70           C  
ATOM   1608  C   ARG B  25      11.317   6.154  22.555  1.00 29.67           C  
ATOM   1609  O   ARG B  25      10.147   6.523  22.293  1.00 31.44           O  
ATOM   1610  CB  ARG B  25      11.038   3.686  23.028  1.00 31.54           C  
ATOM   1611  CG  ARG B  25      11.185   2.536  24.052  1.00 34.00           C  
ATOM   1612  CD  ARG B  25      10.222   1.400  23.730  1.00 40.08           C  
ATOM   1613  NE  ARG B  25       8.816   1.786  23.893  1.00 40.37           N  
ATOM   1614  CZ  ARG B  25       7.786   0.988  23.594  1.00 43.44           C  
ATOM   1615  NH1 ARG B  25       8.019  -0.238  23.104  1.00 41.75           N  
ATOM   1616  NH2 ARG B  25       6.531   1.409  23.748  1.00 41.07           N  
ATOM   1617  N   VAL B  26      12.374   6.682  21.975  1.00 30.38           N  
ATOM   1618  CA  VAL B  26      12.253   7.870  21.101  1.00 27.36           C  
ATOM   1619  C   VAL B  26      12.843   7.592  19.735  1.00 28.37           C  
ATOM   1620  O   VAL B  26      13.948   7.125  19.644  1.00 28.89           O  
ATOM   1621  CB  VAL B  26      13.048   9.059  21.645  1.00 27.13           C  
ATOM   1622  CG1 VAL B  26      12.999  10.276  20.579  1.00 27.87           C  
ATOM   1623  CG2 VAL B  26      12.541   9.453  23.035  1.00 27.61           C  
ATOM   1624  N   LEU B  27      12.067   7.823  18.695  1.00 26.77           N  
ATOM   1625  CA  LEU B  27      12.638   7.797  17.332  1.00 27.79           C  
ATOM   1626  C   LEU B  27      12.860   9.288  16.944  1.00 27.60           C  
ATOM   1627  O   LEU B  27      11.914  10.031  16.927  1.00 28.99           O  
ATOM   1628  CB  LEU B  27      11.629   7.178  16.399  1.00 29.93           C  
ATOM   1629  CG  LEU B  27      11.907   7.242  14.897  1.00 28.95           C  
ATOM   1630  CD1 LEU B  27      13.236   6.462  14.543  1.00 30.19           C  
ATOM   1631  CD2 LEU B  27      10.687   6.664  14.184  1.00 33.35           C  
ATOM   1632  N   ASP B  28      14.038   9.620  16.431  1.00 26.55           N  
ATOM   1633  CA  ASP B  28      14.380  11.004  16.087  1.00 27.71           C  
ATOM   1634  C   ASP B  28      14.694  10.990  14.602  1.00 25.95           C  
ATOM   1635  O   ASP B  28      15.756  10.510  14.188  1.00 27.86           O  
ATOM   1636  CB  ASP B  28      15.621  11.427  16.863  1.00 25.44           C  
ATOM   1637  CG  ASP B  28      16.051  12.885  16.567  1.00 31.11           C  
ATOM   1638  OD1 ASP B  28      15.200  13.663  16.099  1.00 31.38           O  
ATOM   1639  OD2 ASP B  28      17.246  13.191  16.724  1.00 28.26           O  
ATOM   1640  N   CYS B  29      13.776  11.537  13.826  1.00 25.72           N  
ATOM   1641  CA  CYS B  29      13.861  11.516  12.377  1.00 26.64           C  
ATOM   1642  C   CYS B  29      14.546  12.794  11.893  1.00 26.33           C  
ATOM   1643  O   CYS B  29      14.201  13.892  12.331  1.00 24.22           O  
ATOM   1644  CB  CYS B  29      12.446  11.437  11.812  1.00 27.69           C  
ATOM   1645  SG  CYS B  29      11.520   9.965  12.310  1.00 31.50           S  
ATOM   1646  N   GLY B  30      15.487  12.640  10.954  1.00 23.93           N  
ATOM   1647  CA  GLY B  30      16.322  13.755  10.482  1.00 24.40           C  
ATOM   1648  C   GLY B  30      17.264  14.149  11.595  1.00 24.46           C  
ATOM   1649  O   GLY B  30      17.368  15.316  11.910  1.00 24.79           O  
ATOM   1650  N   ALA B  31      17.948  13.154  12.182  1.00 24.48           N  
ATOM   1651  CA  ALA B  31      18.712  13.361  13.363  1.00 25.96           C  
ATOM   1652  C   ALA B  31      20.038  14.083  13.158  1.00 26.41           C  
ATOM   1653  O   ALA B  31      20.585  14.636  14.128  1.00 27.68           O  
ATOM   1654  CB  ALA B  31      18.978  12.028  14.113  1.00 25.00           C  
ATOM   1655  N   ALA B  32      20.579  14.088  11.954  1.00 25.03           N  
ATOM   1656  CA  ALA B  32      21.940  14.657  11.776  1.00 26.23           C  
ATOM   1657  C   ALA B  32      21.914  16.219  11.951  1.00 26.29           C  
ATOM   1658  O   ALA B  32      20.985  16.871  11.409  1.00 26.04           O  
ATOM   1659  CB  ALA B  32      22.493  14.283  10.362  1.00 26.10           C  
ATOM   1660  N   PRO B  33      22.981  16.815  12.542  1.00 27.60           N  
ATOM   1661  CA  PRO B  33      24.213  16.173  13.102  1.00 28.86           C  
ATOM   1662  C   PRO B  33      24.013  15.447  14.422  1.00 28.78           C  
ATOM   1663  O   PRO B  33      24.816  14.589  14.775  1.00 31.72           O  
ATOM   1664  CB  PRO B  33      25.174  17.357  13.292  1.00 30.55           C  
ATOM   1665  CG  PRO B  33      24.257  18.557  13.536  1.00 26.86           C  
ATOM   1666  CD  PRO B  33      23.034  18.294  12.644  1.00 29.76           C  
ATOM   1667  N   GLY B  34      22.920  15.746  15.117  1.00 27.11           N  
ATOM   1668  CA  GLY B  34      22.529  14.963  16.309  1.00 25.35           C  
ATOM   1669  C   GLY B  34      22.184  15.694  17.604  1.00 27.48           C  
ATOM   1670  O   GLY B  34      22.131  15.042  18.684  1.00 25.45           O  
ATOM   1671  N   ALA B  35      21.853  16.991  17.509  1.00 27.34           N  
ATOM   1672  CA  ALA B  35      21.507  17.820  18.704  1.00 29.95           C  
ATOM   1673  C   ALA B  35      20.208  17.393  19.399  1.00 29.60           C  
ATOM   1674  O   ALA B  35      20.207  17.216  20.597  1.00 31.24           O  
ATOM   1675  CB  ALA B  35      21.490  19.339  18.372  1.00 31.90           C  
ATOM   1676  N   TRP B  36      19.146  17.099  18.636  1.00 27.95           N  
ATOM   1677  CA  TRP B  36      17.923  16.638  19.265  1.00 27.71           C  
ATOM   1678  C   TRP B  36      18.174  15.272  19.930  1.00 26.68           C  
ATOM   1679  O   TRP B  36      17.609  14.948  21.018  1.00 26.59           O  
ATOM   1680  CB  TRP B  36      16.827  16.520  18.222  1.00 25.81           C  
ATOM   1681  CG  TRP B  36      16.113  17.811  17.934  1.00 24.45           C  
ATOM   1682  CD1 TRP B  36      16.584  19.102  18.124  1.00 27.38           C  
ATOM   1683  CD2 TRP B  36      14.809  17.940  17.400  1.00 22.52           C  
ATOM   1684  NE1 TRP B  36      15.626  20.031  17.703  1.00 29.14           N  
ATOM   1685  CE2 TRP B  36      14.510  19.337  17.307  1.00 25.37           C  
ATOM   1686  CE3 TRP B  36      13.818  17.014  17.039  1.00 24.66           C  
ATOM   1687  CZ2 TRP B  36      13.271  19.822  16.819  1.00 26.22           C  
ATOM   1688  CZ3 TRP B  36      12.594  17.497  16.566  1.00 23.66           C  
ATOM   1689  CH2 TRP B  36      12.334  18.892  16.454  1.00 27.71           C  
ATOM   1690  N   SER B  37      18.926  14.417  19.236  1.00 28.21           N  
ATOM   1691  CA  SER B  37      19.268  13.058  19.788  1.00 28.69           C  
ATOM   1692  C   SER B  37      20.002  13.145  21.103  1.00 32.39           C  
ATOM   1693  O   SER B  37      19.686  12.422  22.046  1.00 30.09           O  
ATOM   1694  CB  SER B  37      20.016  12.208  18.760  1.00 29.28           C  
ATOM   1695  OG  SER B  37      19.068  11.787  17.787  1.00 29.56           O  
ATOM   1696  N   GLN B  38      20.899  14.123  21.200  1.00 30.71           N  
ATOM   1697  CA  GLN B  38      21.622  14.376  22.415  1.00 33.00           C  
ATOM   1698  C   GLN B  38      20.711  14.805  23.529  1.00 32.83           C  
ATOM   1699  O   GLN B  38      20.900  14.382  24.645  1.00 33.37           O  
ATOM   1700  CB  GLN B  38      22.605  15.512  22.198  1.00 32.50           C  
ATOM   1701  CG  GLN B  38      23.760  15.174  21.370  1.00 34.60           C  
ATOM   1702  CD  GLN B  38      24.645  16.350  21.225  1.00 37.56           C  
ATOM   1703  OE1 GLN B  38      24.306  17.321  20.542  1.00 39.09           O  
ATOM   1704  NE2 GLN B  38      25.762  16.316  21.913  1.00 40.07           N  
ATOM   1705  N   VAL B  39      19.752  15.676  23.223  1.00 31.50           N  
ATOM   1706  CA  VAL B  39      18.710  16.073  24.215  1.00 30.61           C  
ATOM   1707  C   VAL B  39      17.847  14.869  24.622  1.00 31.37           C  
ATOM   1708  O   VAL B  39      17.570  14.664  25.815  1.00 29.42           O  
ATOM   1709  CB  VAL B  39      17.796  17.284  23.690  1.00 30.75           C  
ATOM   1710  CG1 VAL B  39      16.728  17.593  24.685  1.00 30.36           C  
ATOM   1711  CG2 VAL B  39      18.590  18.482  23.405  1.00 29.49           C  
ATOM   1712  N   ALA B  40      17.424  14.071  23.651  1.00 28.67           N  
ATOM   1713  CA  ALA B  40      16.590  12.924  23.926  1.00 30.85           C  
ATOM   1714  C   ALA B  40      17.290  11.915  24.848  1.00 31.23           C  
ATOM   1715  O   ALA B  40      16.685  11.425  25.793  1.00 31.59           O  
ATOM   1716  CB  ALA B  40      16.186  12.261  22.669  1.00 30.30           C  
ATOM   1717  N   VAL B  41      18.545  11.611  24.550  1.00 31.59           N  
ATOM   1718  CA  VAL B  41      19.329  10.669  25.375  1.00 32.71           C  
ATOM   1719  C   VAL B  41      19.284  11.122  26.833  1.00 34.67           C  
ATOM   1720  O   VAL B  41      18.963  10.329  27.742  1.00 35.15           O  
ATOM   1721  CB  VAL B  41      20.809  10.600  24.910  1.00 31.56           C  
ATOM   1722  CG1 VAL B  41      21.653   9.784  25.929  1.00 35.83           C  
ATOM   1723  CG2 VAL B  41      20.892   9.921  23.545  1.00 32.88           C  
ATOM   1724  N   GLN B  42      19.636  12.395  27.071  1.00 35.17           N  
ATOM   1725  CA  GLN B  42      19.576  12.941  28.449  1.00 37.51           C  
ATOM   1726  C   GLN B  42      18.227  12.770  29.110  1.00 36.86           C  
ATOM   1727  O   GLN B  42      18.118  12.253  30.236  1.00 36.44           O  
ATOM   1728  CB  GLN B  42      19.932  14.404  28.457  1.00 38.65           C  
ATOM   1729  CG  GLN B  42      21.354  14.607  28.119  1.00 39.78           C  
ATOM   1730  CD  GLN B  42      21.652  15.939  27.505  1.00 45.00           C  
ATOM   1731  OE1 GLN B  42      20.779  16.848  27.423  1.00 47.07           O  
ATOM   1732  NE2 GLN B  42      22.905  16.103  27.070  1.00 40.86           N  
ATOM   1733  N   LYS B  43      17.202  13.224  28.418  1.00 34.10           N  
ATOM   1734  CA  LYS B  43      15.906  13.320  28.996  1.00 34.63           C  
ATOM   1735  C   LYS B  43      15.182  11.977  29.163  1.00 34.35           C  
ATOM   1736  O   LYS B  43      14.368  11.867  30.071  1.00 34.76           O  
ATOM   1737  CB  LYS B  43      15.033  14.322  28.234  1.00 33.50           C  
ATOM   1738  CG  LYS B  43      15.659  15.706  28.086  1.00 35.23           C  
ATOM   1739  CD  LYS B  43      15.748  16.483  29.399  1.00 39.25           C  
ATOM   1740  CE  LYS B  43      16.572  17.740  29.165  1.00 42.89           C  
ATOM   1741  NZ  LYS B  43      16.623  18.664  30.338  1.00 47.08           N  
ATOM   1742  N   VAL B  44      15.449  10.985  28.299  1.00 32.83           N  
ATOM   1743  CA  VAL B  44      14.871   9.648  28.509  1.00 32.50           C  
ATOM   1744  C   VAL B  44      15.809   8.708  29.223  1.00 33.89           C  
ATOM   1745  O   VAL B  44      15.463   7.543  29.411  1.00 32.46           O  
ATOM   1746  CB  VAL B  44      14.250   8.975  27.185  1.00 32.03           C  
ATOM   1747  CG1 VAL B  44      13.345  10.007  26.396  1.00 31.10           C  
ATOM   1748  CG2 VAL B  44      15.365   8.390  26.253  1.00 32.56           C  
ATOM   1749  N   ASN B  45      16.972   9.218  29.693  1.00 31.64           N  
ATOM   1750  CA  ASN B  45      17.903   8.399  30.410  1.00 33.67           C  
ATOM   1751  C   ASN B  45      18.355   7.163  29.587  1.00 33.86           C  
ATOM   1752  O   ASN B  45      18.589   6.076  30.139  1.00 37.26           O  
ATOM   1753  CB  ASN B  45      17.289   8.004  31.786  1.00 34.98           C  
ATOM   1754  CG  ASN B  45      18.288   7.480  32.739  1.00 37.57           C  
ATOM   1755  OD1 ASN B  45      19.464   7.884  32.726  1.00 41.25           O  
ATOM   1756  ND2 ASN B  45      17.854   6.541  33.587  1.00 30.48           N  
ATOM   1757  N   ALA B  46      18.526   7.349  28.278  1.00 34.26           N  
ATOM   1758  CA  ALA B  46      18.895   6.247  27.373  1.00 33.28           C  
ATOM   1759  C   ALA B  46      20.349   5.788  27.550  1.00 36.17           C  
ATOM   1760  O   ALA B  46      20.721   4.650  27.134  1.00 34.73           O  
ATOM   1761  CB  ALA B  46      18.682   6.669  25.941  1.00 32.44           C  
ATOM   1762  N   ALA B  47      21.191   6.695  28.057  1.00 37.44           N  
ATOM   1763  CA  ALA B  47      22.554   6.308  28.414  1.00 39.77           C  
ATOM   1764  C   ALA B  47      22.639   5.681  29.858  1.00 43.07           C  
ATOM   1765  O   ALA B  47      23.717   5.235  30.304  1.00 44.48           O  
ATOM   1766  CB  ALA B  47      23.489   7.506  28.267  1.00 39.11           C  
ATOM   1767  N   GLY B  48      21.487   5.620  30.549  1.00 46.87           N  
ATOM   1768  CA  GLY B  48      21.400   5.142  31.937  1.00 49.98           C  
ATOM   1769  C   GLY B  48      22.179   5.996  32.918  1.00 51.85           C  
ATOM   1770  O   GLY B  48      22.623   5.489  33.956  1.00 54.03           O  
ATOM   1771  N   THR B  49      22.368   7.288  32.586  1.00 51.70           N  
ATOM   1772  CA  THR B  49      23.234   8.171  33.405  1.00 54.82           C  
ATOM   1773  C   THR B  49      22.745   8.301  34.844  1.00 55.75           C  
ATOM   1774  O   THR B  49      23.539   8.501  35.782  1.00 58.30           O  
ATOM   1775  CB  THR B  49      23.433   9.575  32.777  1.00 53.07           C  
ATOM   1776  OG1 THR B  49      23.409   9.471  31.348  1.00 52.95           O  
ATOM   1777  CG2 THR B  49      24.779  10.166  33.228  1.00 55.37           C  
ATOM   1778  N   ASP B  50      21.433   8.144  35.022  1.00 54.13           N  
ATOM   1779  CA  ASP B  50      20.833   8.086  36.356  1.00 54.17           C  
ATOM   1780  C   ASP B  50      20.388   6.652  36.654  1.00 53.78           C  
ATOM   1781  O   ASP B  50      19.361   6.197  36.131  1.00 51.07           O  
ATOM   1782  CB  ASP B  50      19.641   9.058  36.413  1.00 52.75           C  
ATOM   1783  CG  ASP B  50      18.830   8.931  37.685  1.00 54.03           C  
ATOM   1784  OD1 ASP B  50      19.320   8.353  38.682  1.00 56.23           O  
ATOM   1785  OD2 ASP B  50      17.699   9.434  37.681  1.00 54.49           O  
ATOM   1786  N   PRO B  51      21.137   5.947  37.539  1.00 55.82           N  
ATOM   1787  CA  PRO B  51      20.879   4.541  37.879  1.00 56.95           C  
ATOM   1788  C   PRO B  51      19.519   4.289  38.531  1.00 55.54           C  
ATOM   1789  O   PRO B  51      19.060   3.148  38.551  1.00 57.04           O  
ATOM   1790  CB  PRO B  51      21.979   4.217  38.907  1.00 59.50           C  
ATOM   1791  CG  PRO B  51      23.002   5.287  38.742  1.00 60.89           C  
ATOM   1792  CD  PRO B  51      22.264   6.499  38.319  1.00 58.46           C  
ATOM   1793  N   SER B  52      18.925   5.332  39.119  1.00 53.61           N  
ATOM   1794  CA  SER B  52      17.680   5.222  39.876  1.00 52.56           C  
ATOM   1795  C   SER B  52      16.411   5.325  39.021  1.00 49.39           C  
ATOM   1796  O   SER B  52      15.287   5.186  39.544  1.00 48.42           O  
ATOM   1797  CB  SER B  52      17.630   6.315  40.956  1.00 54.21           C  
ATOM   1798  OG  SER B  52      17.555   7.599  40.351  1.00 53.81           O  
ATOM   1799  N   SER B  53      16.599   5.600  37.732  1.00 47.20           N  
ATOM   1800  CA  SER B  53      15.507   5.906  36.795  1.00 44.25           C  
ATOM   1801  C   SER B  53      15.517   4.944  35.617  1.00 43.15           C  
ATOM   1802  O   SER B  53      16.590   4.462  35.206  1.00 42.88           O  
ATOM   1803  CB  SER B  53      15.605   7.355  36.295  1.00 42.43           C  
ATOM   1804  OG  SER B  53      15.213   8.271  37.338  1.00 45.03           O  
ATOM   1805  N   PRO B  54      14.321   4.654  35.061  1.00 40.76           N  
ATOM   1806  CA  PRO B  54      14.203   3.769  33.884  1.00 39.52           C  
ATOM   1807  C   PRO B  54      15.115   4.192  32.761  1.00 38.52           C  
ATOM   1808  O   PRO B  54      15.353   5.398  32.589  1.00 36.50           O  
ATOM   1809  CB  PRO B  54      12.749   3.979  33.428  1.00 39.22           C  
ATOM   1810  CG  PRO B  54      12.011   4.366  34.647  1.00 39.66           C  
ATOM   1811  CD  PRO B  54      13.002   5.124  35.546  1.00 40.53           C  
ATOM   1812  N   VAL B  55      15.566   3.226  31.955  1.00 37.74           N  
ATOM   1813  CA  VAL B  55      16.464   3.538  30.824  1.00 37.70           C  
ATOM   1814  C   VAL B  55      15.661   3.528  29.543  1.00 36.19           C  
ATOM   1815  O   VAL B  55      14.995   2.515  29.189  1.00 36.61           O  
ATOM   1816  CB  VAL B  55      17.629   2.557  30.777  1.00 40.70           C  
ATOM   1817  CG1 VAL B  55      18.614   2.884  29.661  1.00 40.63           C  
ATOM   1818  CG2 VAL B  55      18.334   2.560  32.107  1.00 44.47           C  
ATOM   1819  N   GLY B  56      15.643   4.685  28.886  1.00 33.70           N  
ATOM   1820  CA  GLY B  56      14.892   4.822  27.688  1.00 33.03           C  
ATOM   1821  C   GLY B  56      15.723   4.382  26.507  1.00 33.92           C  
ATOM   1822  O   GLY B  56      16.728   3.681  26.654  1.00 35.66           O  
ATOM   1823  N   PHE B  57      15.327   4.847  25.323  1.00 31.80           N  
ATOM   1824  CA  PHE B  57      15.984   4.429  24.117  1.00 33.25           C  
ATOM   1825  C   PHE B  57      15.857   5.551  23.091  1.00 30.98           C  
ATOM   1826  O   PHE B  57      14.763   6.194  22.934  1.00 30.21           O  
ATOM   1827  CB  PHE B  57      15.344   3.141  23.577  1.00 36.48           C  
ATOM   1828  CG  PHE B  57      16.154   2.462  22.517  1.00 34.58           C  
ATOM   1829  CD1 PHE B  57      17.045   1.432  22.845  1.00 39.54           C  
ATOM   1830  CD2 PHE B  57      16.051   2.859  21.183  1.00 35.08           C  
ATOM   1831  CE1 PHE B  57      17.807   0.806  21.856  1.00 42.17           C  
ATOM   1832  CE2 PHE B  57      16.802   2.241  20.200  1.00 37.28           C  
ATOM   1833  CZ  PHE B  57      17.701   1.224  20.530  1.00 41.51           C  
ATOM   1834  N   VAL B  58      16.964   5.791  22.372  1.00 30.00           N  
ATOM   1835  CA  VAL B  58      16.983   6.831  21.411  1.00 29.47           C  
ATOM   1836  C   VAL B  58      17.591   6.305  20.138  1.00 30.38           C  
ATOM   1837  O   VAL B  58      18.717   5.800  20.135  1.00 31.42           O  
ATOM   1838  CB  VAL B  58      17.792   8.060  21.865  1.00 28.96           C  
ATOM   1839  CG1 VAL B  58      17.928   9.102  20.650  1.00 31.11           C  
ATOM   1840  CG2 VAL B  58      17.083   8.728  22.950  1.00 28.81           C  
ATOM   1841  N   LEU B  59      16.773   6.317  19.090  1.00 30.49           N  
ATOM   1842  CA  LEU B  59      17.216   5.928  17.759  1.00 31.08           C  
ATOM   1843  C   LEU B  59      17.086   7.147  16.864  1.00 27.54           C  
ATOM   1844  O   LEU B  59      15.959   7.577  16.585  1.00 27.13           O  
ATOM   1845  CB  LEU B  59      16.269   4.848  17.235  1.00 30.70           C  
ATOM   1846  CG  LEU B  59      16.362   4.365  15.811  1.00 34.29           C  
ATOM   1847  CD1 LEU B  59      17.824   3.924  15.507  1.00 32.62           C  
ATOM   1848  CD2 LEU B  59      15.346   3.213  15.521  1.00 36.21           C  
ATOM   1849  N   GLY B  60      18.212   7.629  16.288  1.00 28.53           N  
ATOM   1850  CA  GLY B  60      18.125   8.665  15.243  1.00 27.05           C  
ATOM   1851  C   GLY B  60      18.341   8.119  13.828  1.00 27.56           C  
ATOM   1852  O   GLY B  60      19.122   7.165  13.621  1.00 29.18           O  
ATOM   1853  N   VAL B  61      17.646   8.696  12.856  1.00 25.75           N  
ATOM   1854  CA  VAL B  61      17.776   8.224  11.473  1.00 27.39           C  
ATOM   1855  C   VAL B  61      18.020   9.426  10.590  1.00 26.65           C  
ATOM   1856  O   VAL B  61      17.375  10.480  10.790  1.00 23.59           O  
ATOM   1857  CB  VAL B  61      16.506   7.535  11.024  1.00 28.40           C  
ATOM   1858  CG1 VAL B  61      16.689   6.907   9.668  1.00 31.60           C  
ATOM   1859  CG2 VAL B  61      15.969   6.465  12.107  1.00 26.85           C  
ATOM   1860  N   ASP B  62      18.959   9.339   9.625  1.00 25.44           N  
ATOM   1861  CA  ASP B  62      19.118  10.465   8.716  1.00 25.27           C  
ATOM   1862  C   ASP B  62      19.692   9.997   7.386  1.00 23.16           C  
ATOM   1863  O   ASP B  62      20.332   8.976   7.347  1.00 25.67           O  
ATOM   1864  CB  ASP B  62      20.066  11.517   9.306  1.00 23.61           C  
ATOM   1865  CG  ASP B  62      19.870  12.914   8.709  1.00 26.46           C  
ATOM   1866  OD1 ASP B  62      20.167  13.151   7.484  1.00 26.81           O  
ATOM   1867  OD2 ASP B  62      19.465  13.811   9.485  1.00 21.24           O  
ATOM   1868  N   LEU B  63      19.363  10.713   6.321  1.00 24.84           N  
ATOM   1869  CA  LEU B  63      20.061  10.539   5.022  1.00 24.70           C  
ATOM   1870  C   LEU B  63      21.586  10.665   5.117  1.00 26.14           C  
ATOM   1871  O   LEU B  63      22.343  10.096   4.282  1.00 26.60           O  
ATOM   1872  CB  LEU B  63      19.541  11.533   3.955  1.00 25.67           C  
ATOM   1873  CG  LEU B  63      18.042  11.464   3.670  1.00 27.84           C  
ATOM   1874  CD1 LEU B  63      17.766  12.648   2.733  1.00 27.39           C  
ATOM   1875  CD2 LEU B  63      17.662  10.119   3.020  1.00 29.19           C  
ATOM   1876  N   LEU B  64      22.033  11.531   6.036  1.00 24.28           N  
ATOM   1877  CA  LEU B  64      23.440  11.908   6.177  1.00 24.15           C  
ATOM   1878  C   LEU B  64      24.084  11.189   7.387  1.00 26.77           C  
ATOM   1879  O   LEU B  64      23.390  10.804   8.352  1.00 26.31           O  
ATOM   1880  CB  LEU B  64      23.541  13.437   6.398  1.00 22.77           C  
ATOM   1881  CG  LEU B  64      22.846  14.349   5.373  1.00 23.82           C  
ATOM   1882  CD1 LEU B  64      22.992  15.874   5.773  1.00 29.35           C  
ATOM   1883  CD2 LEU B  64      23.379  14.081   4.022  1.00 29.69           C  
ATOM   1884  N   HIS B  65      25.405  11.059   7.347  1.00 27.87           N  
ATOM   1885  CA  HIS B  65      26.140  10.375   8.393  1.00 28.75           C  
ATOM   1886  C   HIS B  65      25.999  11.126   9.685  1.00 29.51           C  
ATOM   1887  O   HIS B  65      26.079  12.388   9.712  1.00 29.70           O  
ATOM   1888  CB  HIS B  65      27.622  10.239   8.030  1.00 31.86           C  
ATOM   1889  CG  HIS B  65      28.485   9.748   9.155  1.00 34.41           C  
ATOM   1890  ND1 HIS B  65      28.507   8.428   9.558  1.00 40.48           N  
ATOM   1891  CD2 HIS B  65      29.374  10.395   9.951  1.00 40.52           C  
ATOM   1892  CE1 HIS B  65      29.348   8.282  10.570  1.00 39.79           C  
ATOM   1893  NE2 HIS B  65      29.880   9.460  10.839  1.00 44.34           N  
ATOM   1894  N   ILE B  66      25.753  10.365  10.767  1.00 30.56           N  
ATOM   1895  CA  ILE B  66      25.703  10.940  12.107  1.00 29.93           C  
ATOM   1896  C   ILE B  66      26.834  10.339  12.939  1.00 32.24           C  
ATOM   1897  O   ILE B  66      26.941   9.118  13.064  1.00 31.84           O  
ATOM   1898  CB  ILE B  66      24.317  10.663  12.841  1.00 30.19           C  
ATOM   1899  CG1 ILE B  66      23.120  11.193  12.052  1.00 26.23           C  
ATOM   1900  CG2 ILE B  66      24.301  11.261  14.238  1.00 30.26           C  
ATOM   1901  CD1 ILE B  66      21.831  10.327  12.342  1.00 29.07           C  
ATOM   1902  N   PHE B  67      27.687  11.183  13.487  1.00 33.81           N  
ATOM   1903  CA  PHE B  67      28.796  10.715  14.331  1.00 38.11           C  
ATOM   1904  C   PHE B  67      28.283  10.059  15.596  1.00 39.16           C  
ATOM   1905  O   PHE B  67      27.334  10.548  16.201  1.00 36.40           O  
ATOM   1906  CB  PHE B  67      29.728  11.880  14.661  1.00 41.10           C  
ATOM   1907  CG  PHE B  67      30.644  12.261  13.516  1.00 45.88           C  
ATOM   1908  CD1 PHE B  67      31.799  11.524  13.246  1.00 50.71           C  
ATOM   1909  CD2 PHE B  67      30.348  13.354  12.714  1.00 46.92           C  
ATOM   1910  CE1 PHE B  67      32.619  11.860  12.189  1.00 53.27           C  
ATOM   1911  CE2 PHE B  67      31.162  13.707  11.661  1.00 48.73           C  
ATOM   1912  CZ  PHE B  67      32.311  12.964  11.390  1.00 50.11           C  
ATOM   1913  N   PRO B  68      28.908   8.921  16.008  1.00 41.30           N  
ATOM   1914  CA  PRO B  68      28.347   8.138  17.131  1.00 42.02           C  
ATOM   1915  C   PRO B  68      28.037   8.961  18.388  1.00 41.49           C  
ATOM   1916  O   PRO B  68      28.695   9.958  18.652  1.00 43.21           O  
ATOM   1917  CB  PRO B  68      29.464   7.133  17.431  1.00 44.11           C  
ATOM   1918  CG  PRO B  68      30.123   6.922  16.140  1.00 46.66           C  
ATOM   1919  CD  PRO B  68      30.119   8.272  15.450  1.00 43.40           C  
ATOM   1920  N   LEU B  69      27.044   8.534  19.154  1.00 40.55           N  
ATOM   1921  CA  LEU B  69      26.713   9.236  20.391  1.00 41.50           C  
ATOM   1922  C   LEU B  69      26.324   8.233  21.471  1.00 41.95           C  
ATOM   1923  O   LEU B  69      25.543   7.346  21.207  1.00 42.52           O  
ATOM   1924  CB  LEU B  69      25.566  10.236  20.137  1.00 39.64           C  
ATOM   1925  CG  LEU B  69      24.956  10.918  21.379  1.00 39.58           C  
ATOM   1926  CD1 LEU B  69      25.885  12.073  21.830  1.00 42.72           C  
ATOM   1927  CD2 LEU B  69      23.582  11.443  21.041  1.00 39.09           C  
ATOM   1928  N   GLU B  70      26.873   8.379  22.675  1.00 45.38           N  
ATOM   1929  CA  GLU B  70      26.634   7.422  23.767  1.00 45.16           C  
ATOM   1930  C   GLU B  70      25.188   7.376  24.180  1.00 43.58           C  
ATOM   1931  O   GLU B  70      24.600   8.398  24.491  1.00 42.95           O  
ATOM   1932  CB  GLU B  70      27.510   7.748  24.986  1.00 49.43           C  
ATOM   1933  N   GLY B  71      24.599   6.185  24.140  1.00 43.86           N  
ATOM   1934  CA  GLY B  71      23.188   6.008  24.499  1.00 42.30           C  
ATOM   1935  C   GLY B  71      22.190   6.230  23.367  1.00 39.33           C  
ATOM   1936  O   GLY B  71      20.953   6.124  23.598  1.00 37.91           O  
ATOM   1937  N   ALA B  72      22.705   6.499  22.146  1.00 39.21           N  
ATOM   1938  CA  ALA B  72      21.893   6.490  20.919  1.00 37.13           C  
ATOM   1939  C   ALA B  72      22.402   5.476  19.902  1.00 37.32           C  
ATOM   1940  O   ALA B  72      23.612   5.232  19.798  1.00 38.00           O  
ATOM   1941  CB  ALA B  72      21.819   7.890  20.268  1.00 35.55           C  
ATOM   1942  N   THR B  73      21.463   4.866  19.187  1.00 35.32           N  
ATOM   1943  CA  THR B  73      21.799   4.091  18.004  1.00 36.50           C  
ATOM   1944  C   THR B  73      21.398   4.964  16.826  1.00 35.20           C  
ATOM   1945  O   THR B  73      20.439   5.732  16.931  1.00 33.84           O  
ATOM   1946  CB  THR B  73      21.019   2.774  17.971  1.00 36.80           C  
ATOM   1947  OG1 THR B  73      21.348   1.995  19.135  1.00 39.35           O  
ATOM   1948  CG2 THR B  73      21.385   1.990  16.726  1.00 40.55           C  
ATOM   1949  N   PHE B  74      22.160   4.902  15.734  1.00 34.72           N  
ATOM   1950  CA  PHE B  74      21.810   5.713  14.554  1.00 32.64           C  
ATOM   1951  C   PHE B  74      21.703   4.845  13.328  1.00 33.65           C  
ATOM   1952  O   PHE B  74      22.508   3.933  13.155  1.00 34.96           O  
ATOM   1953  CB  PHE B  74      22.853   6.781  14.293  1.00 32.09           C  
ATOM   1954  CG  PHE B  74      22.924   7.833  15.365  1.00 29.09           C  
ATOM   1955  CD1 PHE B  74      21.774   8.577  15.726  1.00 29.28           C  
ATOM   1956  CD2 PHE B  74      24.125   8.133  15.969  1.00 31.93           C  
ATOM   1957  CE1 PHE B  74      21.849   9.600  16.710  1.00 31.34           C  
ATOM   1958  CE2 PHE B  74      24.192   9.133  16.964  1.00 31.85           C  
ATOM   1959  CZ  PHE B  74      23.046   9.838  17.350  1.00 30.26           C  
ATOM   1960  N   LEU B  75      20.719   5.132  12.469  1.00 30.94           N  
ATOM   1961  CA  LEU B  75      20.626   4.476  11.158  1.00 33.19           C  
ATOM   1962  C   LEU B  75      20.902   5.538  10.151  1.00 31.56           C  
ATOM   1963  O   LEU B  75      20.131   6.516  10.007  1.00 29.58           O  
ATOM   1964  CB  LEU B  75      19.253   3.874  10.913  1.00 32.90           C  
ATOM   1965  CG  LEU B  75      18.825   2.797  11.898  1.00 39.04           C  
ATOM   1966  CD1 LEU B  75      17.354   2.485  11.706  1.00 38.63           C  
ATOM   1967  CD2 LEU B  75      19.705   1.553  11.693  1.00 46.02           C  
ATOM   1968  N   CYS B  76      22.026   5.398   9.472  1.00 32.73           N  
ATOM   1969  CA  CYS B  76      22.428   6.379   8.478  1.00 31.91           C  
ATOM   1970  C   CYS B  76      23.464   5.703   7.612  1.00 32.80           C  
ATOM   1971  O   CYS B  76      24.296   4.947   8.117  1.00 36.17           O  
ATOM   1972  CB  CYS B  76      23.024   7.639   9.123  1.00 29.54           C  
ATOM   1973  SG  CYS B  76      24.299   7.418  10.408  1.00 39.56           S  
ATOM   1974  N   PRO B  77      23.402   5.934   6.307  1.00 32.95           N  
ATOM   1975  CA  PRO B  77      22.404   6.682   5.542  1.00 30.39           C  
ATOM   1976  C   PRO B  77      21.057   5.921   5.409  1.00 34.12           C  
ATOM   1977  O   PRO B  77      21.030   4.726   5.077  1.00 33.96           O  
ATOM   1978  CB  PRO B  77      23.088   6.830   4.167  1.00 32.72           C  
ATOM   1979  CG  PRO B  77      23.896   5.541   4.060  1.00 34.91           C  
ATOM   1980  CD  PRO B  77      24.476   5.385   5.428  1.00 34.39           C  
ATOM   1981  N   ALA B  78      19.959   6.605   5.708  1.00 32.25           N  
ATOM   1982  CA  ALA B  78      18.626   5.982   5.763  1.00 33.46           C  
ATOM   1983  C   ALA B  78      17.536   7.010   5.514  1.00 32.88           C  
ATOM   1984  O   ALA B  78      17.472   8.047   6.216  1.00 33.40           O  
ATOM   1985  CB  ALA B  78      18.395   5.280   7.121  1.00 32.58           C  
ATOM   1986  N   ASP B  79      16.731   6.745   4.479  1.00 34.42           N  
ATOM   1987  CA  ASP B  79      15.566   7.550   4.108  1.00 34.11           C  
ATOM   1988  C   ASP B  79      14.345   7.111   4.956  1.00 35.84           C  
ATOM   1989  O   ASP B  79      13.846   5.998   4.812  1.00 37.73           O  
ATOM   1990  CB  ASP B  79      15.313   7.390   2.590  1.00 35.23           C  
ATOM   1991  CG  ASP B  79      14.041   8.125   2.100  1.00 37.10           C  
ATOM   1992  OD1 ASP B  79      13.372   8.750   2.912  1.00 38.45           O  
ATOM   1993  OD2 ASP B  79      13.691   8.012   0.874  1.00 41.16           O  
ATOM   1994  N   VAL B  80      13.934   7.963   5.909  1.00 32.44           N  
ATOM   1995  CA  VAL B  80      12.814   7.635   6.788  1.00 35.11           C  
ATOM   1996  C   VAL B  80      11.567   7.195   5.985  1.00 37.54           C  
ATOM   1997  O   VAL B  80      10.683   6.454   6.512  1.00 39.00           O  
ATOM   1998  CB  VAL B  80      12.511   8.811   7.768  1.00 36.66           C  
ATOM   1999  CG1 VAL B  80      11.224   8.551   8.542  1.00 41.70           C  
ATOM   2000  CG2 VAL B  80      13.672   8.944   8.750  1.00 36.76           C  
ATOM   2001  N   THR B  81      11.487   7.647   4.720  1.00 40.34           N  
ATOM   2002  CA  THR B  81      10.290   7.431   3.891  1.00 44.00           C  
ATOM   2003  C   THR B  81      10.394   6.138   3.057  1.00 45.01           C  
ATOM   2004  O   THR B  81       9.488   5.802   2.283  1.00 48.73           O  
ATOM   2005  CB  THR B  81       9.994   8.640   2.940  1.00 47.72           C  
ATOM   2006  OG1 THR B  81      10.918   8.643   1.830  1.00 47.92           O  
ATOM   2007  CG2 THR B  81      10.042   9.981   3.688  1.00 48.53           C  
ATOM   2008  N   ASP B  82      11.491   5.408   3.234  1.00 42.97           N  
ATOM   2009  CA  ASP B  82      11.696   4.136   2.529  1.00 43.99           C  
ATOM   2010  C   ASP B  82      11.228   2.946   3.425  1.00 44.04           C  
ATOM   2011  O   ASP B  82      11.717   2.775   4.549  1.00 41.32           O  
ATOM   2012  CB  ASP B  82      13.181   4.018   2.103  1.00 42.56           C  
ATOM   2013  CG  ASP B  82      13.473   2.808   1.249  1.00 49.96           C  
ATOM   2014  OD1 ASP B  82      12.801   1.749   1.397  1.00 53.25           O  
ATOM   2015  OD2 ASP B  82      14.408   2.907   0.416  1.00 50.55           O  
ATOM   2016  N   PRO B  83      10.305   2.095   2.906  1.00 48.55           N  
ATOM   2017  CA  PRO B  83       9.836   0.932   3.661  1.00 49.74           C  
ATOM   2018  C   PRO B  83      10.941   0.189   4.455  1.00 47.57           C  
ATOM   2019  O   PRO B  83      10.672  -0.350   5.536  1.00 48.34           O  
ATOM   2020  CB  PRO B  83       9.283   0.010   2.562  1.00 57.14           C  
ATOM   2021  CG  PRO B  83       8.747   0.956   1.545  1.00 59.64           C  
ATOM   2022  CD  PRO B  83       9.627   2.194   1.593  1.00 52.96           C  
ATOM   2023  N   ARG B  84      12.147   0.130   3.907  1.00 45.21           N  
ATOM   2024  CA  ARG B  84      13.184  -0.721   4.485  1.00 48.20           C  
ATOM   2025  C   ARG B  84      13.628  -0.137   5.818  1.00 44.54           C  
ATOM   2026  O   ARG B  84      13.956  -0.856   6.769  1.00 46.52           O  
ATOM   2027  CB  ARG B  84      14.368  -0.808   3.530  1.00 49.21           C  
ATOM   2028  CG  ARG B  84      15.562  -1.606   4.046  1.00 53.25           C  
ATOM   2029  CD  ARG B  84      16.763  -1.449   3.111  1.00 56.26           C  
ATOM   2030  NE  ARG B  84      16.406  -1.740   1.714  1.00 66.41           N  
ATOM   2031  CZ  ARG B  84      16.199  -0.806   0.780  1.00 65.46           C  
ATOM   2032  NH1 ARG B  84      16.343   0.483   1.076  1.00 58.55           N  
ATOM   2033  NH2 ARG B  84      15.889  -1.165  -0.465  1.00 74.65           N  
ATOM   2034  N   THR B  85      13.630   1.182   5.868  1.00 39.58           N  
ATOM   2035  CA  THR B  85      14.019   1.901   7.058  1.00 38.34           C  
ATOM   2036  C   THR B  85      12.990   1.674   8.170  1.00 39.33           C  
ATOM   2037  O   THR B  85      13.351   1.422   9.331  1.00 40.66           O  
ATOM   2038  CB  THR B  85      14.227   3.393   6.715  1.00 35.70           C  
ATOM   2039  OG1 THR B  85      15.107   3.505   5.577  1.00 38.46           O  
ATOM   2040  CG2 THR B  85      14.841   4.101   7.874  1.00 34.74           C  
ATOM   2041  N   SER B  86      11.711   1.674   7.804  1.00 40.42           N  
ATOM   2042  CA  SER B  86      10.660   1.350   8.759  1.00 45.15           C  
ATOM   2043  C   SER B  86      10.863   0.005   9.408  1.00 48.81           C  
ATOM   2044  O   SER B  86      10.796  -0.108  10.620  1.00 51.52           O  
ATOM   2045  CB  SER B  86       9.277   1.431   8.118  1.00 47.98           C  
ATOM   2046  OG  SER B  86       9.052   2.743   7.646  1.00 50.80           O  
ATOM   2047  N   GLN B  87      11.132  -1.027   8.604  1.00 50.65           N  
ATOM   2048  CA  GLN B  87      11.344  -2.346   9.168  1.00 56.48           C  
ATOM   2049  C   GLN B  87      12.553  -2.359  10.089  1.00 56.17           C  
ATOM   2050  O   GLN B  87      12.534  -3.012  11.146  1.00 62.16           O  
ATOM   2051  CB  GLN B  87      11.483  -3.402   8.067  1.00 61.00           C  
ATOM   2052  CG  GLN B  87      10.159  -3.881   7.512  1.00 65.78           C  
ATOM   2053  CD  GLN B  87       9.239  -4.475   8.567  1.00 73.98           C  
ATOM   2054  OE1 GLN B  87       9.674  -5.202   9.464  1.00 78.48           O  
ATOM   2055  NE2 GLN B  87       7.951  -4.184   8.447  1.00 77.17           N  
ATOM   2056  N   ARG B  88      13.574  -1.596   9.705  1.00 52.45           N  
ATOM   2057  CA  ARG B  88      14.822  -1.519  10.463  1.00 53.75           C  
ATOM   2058  C   ARG B  88      14.587  -0.845  11.801  1.00 53.82           C  
ATOM   2059  O   ARG B  88      15.032  -1.338  12.835  1.00 57.89           O  
ATOM   2060  CB  ARG B  88      15.895  -0.784   9.675  1.00 49.06           C  
ATOM   2061  CG  ARG B  88      16.466  -1.585   8.535  1.00 55.26           C  
ATOM   2062  N   ILE B  89      13.861   0.274  11.757  1.00 48.90           N  
ATOM   2063  CA  ILE B  89      13.379   0.962  12.945  1.00 49.72           C  
ATOM   2064  C   ILE B  89      12.700  -0.013  13.911  1.00 56.94           C  
ATOM   2065  O   ILE B  89      13.129  -0.154  15.045  1.00 60.92           O  
ATOM   2066  CB  ILE B  89      12.406   2.105  12.566  1.00 46.65           C  
ATOM   2067  CG1 ILE B  89      13.176   3.271  11.943  1.00 42.64           C  
ATOM   2068  CG2 ILE B  89      11.602   2.571  13.799  1.00 47.95           C  
ATOM   2069  CD1 ILE B  89      12.313   4.176  11.095  1.00 43.14           C  
ATOM   2070  N   LEU B  90      11.699  -0.730  13.415  1.00 47.37           N  
ATOM   2071  CA  LEU B  90      10.951  -1.688  14.236  1.00 49.74           C  
ATOM   2072  C   LEU B  90      11.851  -2.772  14.852  1.00 52.21           C  
ATOM   2073  O   LEU B  90      11.678  -3.138  16.024  1.00 52.46           O  
ATOM   2074  CB  LEU B  90       9.816  -2.301  13.414  1.00 52.06           C  
ATOM   2075  CG  LEU B  90       8.769  -1.268  13.000  1.00 49.48           C  
ATOM   2076  CD1 LEU B  90       7.771  -1.877  12.089  1.00 52.04           C  
ATOM   2077  CD2 LEU B  90       8.066  -0.642  14.226  1.00 50.17           C  
ATOM   2078  N   GLU B  91      12.806  -3.283  14.062  1.00 53.72           N  
ATOM   2079  CA  GLU B  91      13.767  -4.282  14.560  1.00 55.78           C  
ATOM   2080  C   GLU B  91      14.688  -3.762  15.675  1.00 53.44           C  
ATOM   2081  O   GLU B  91      15.112  -4.528  16.529  1.00 55.13           O  
ATOM   2082  CB  GLU B  91      14.609  -4.853  13.408  1.00 59.33           C  
ATOM   2083  CG  GLU B  91      13.810  -5.639  12.400  1.00 61.72           C  
ATOM   2084  CD  GLU B  91      14.632  -6.075  11.212  1.00 67.10           C  
ATOM   2085  OE1 GLU B  91      15.710  -5.483  10.953  1.00 66.76           O  
ATOM   2086  OE2 GLU B  91      14.193  -7.004  10.518  1.00 71.09           O  
ATOM   2087  N   VAL B  92      14.949  -2.455  15.686  1.00 49.11           N  
ATOM   2088  CA  VAL B  92      15.955  -1.858  16.568  1.00 47.76           C  
ATOM   2089  C   VAL B  92      15.312  -1.370  17.887  1.00 46.16           C  
ATOM   2090  O   VAL B  92      15.906  -1.491  18.970  1.00 46.16           O  
ATOM   2091  CB  VAL B  92      16.674  -0.658  15.856  1.00 46.81           C  
ATOM   2092  CG1 VAL B  92      17.378   0.289  16.864  1.00 45.17           C  
ATOM   2093  CG2 VAL B  92      17.648  -1.135  14.800  1.00 49.36           C  
ATOM   2094  N   LEU B  93      14.094  -0.855  17.793  1.00 42.93           N  
ATOM   2095  CA  LEU B  93      13.405  -0.317  18.987  1.00 41.91           C  
ATOM   2096  C   LEU B  93      13.029  -1.466  19.942  1.00 43.30           C  
ATOM   2097  O   LEU B  93      12.524  -2.505  19.493  1.00 45.96           O  
ATOM   2098  CB  LEU B  93      12.142   0.451  18.585  1.00 40.72           C  
ATOM   2099  CG  LEU B  93      12.294   1.768  17.806  1.00 39.08           C  
ATOM   2100  CD1 LEU B  93      10.944   2.184  17.236  1.00 36.47           C  
ATOM   2101  CD2 LEU B  93      12.801   2.822  18.742  1.00 35.68           C  
ATOM   2102  N   PRO B  94      13.289  -1.285  21.258  1.00 43.56           N  
ATOM   2103  CA  PRO B  94      12.681  -2.150  22.275  1.00 45.31           C  
ATOM   2104  C   PRO B  94      11.187  -2.318  22.036  1.00 45.69           C  
ATOM   2105  O   PRO B  94      10.464  -1.314  21.817  1.00 44.86           O  
ATOM   2106  CB  PRO B  94      12.949  -1.382  23.570  1.00 43.49           C  
ATOM   2107  CG  PRO B  94      14.275  -0.719  23.293  1.00 44.46           C  
ATOM   2108  CD  PRO B  94      14.136  -0.240  21.885  1.00 43.20           C  
ATOM   2109  N   GLY B  95      10.727  -3.573  22.088  1.00 47.39           N  
ATOM   2110  CA  GLY B  95       9.317  -3.890  21.912  1.00 47.77           C  
ATOM   2111  C   GLY B  95       8.727  -3.493  20.569  1.00 46.91           C  
ATOM   2112  O   GLY B  95       7.495  -3.409  20.423  1.00 46.26           O  
ATOM   2113  N   ARG B  96       9.605  -3.251  19.590  1.00 45.94           N  
ATOM   2114  CA  ARG B  96       9.221  -2.818  18.240  1.00 46.54           C  
ATOM   2115  C   ARG B  96       8.322  -1.585  18.192  1.00 43.51           C  
ATOM   2116  O   ARG B  96       7.540  -1.416  17.249  1.00 44.99           O  
ATOM   2117  CB  ARG B  96       8.579  -3.965  17.455  1.00 49.29           C  
ATOM   2118  CG  ARG B  96       9.539  -5.134  17.163  1.00 52.84           C  
ATOM   2119  CD  ARG B  96       8.795  -6.319  16.571  1.00 57.22           C  
ATOM   2120  NE  ARG B  96       8.461  -6.058  15.166  1.00 59.49           N  
ATOM   2121  CZ  ARG B  96       9.270  -6.293  14.131  1.00 62.40           C  
ATOM   2122  NH1 ARG B  96      10.476  -6.825  14.312  1.00 64.56           N  
ATOM   2123  NH2 ARG B  96       8.871  -5.986  12.906  1.00 63.77           N  
ATOM   2124  N   ARG B  97       8.434  -0.712  19.182  1.00 41.60           N  
ATOM   2125  CA  ARG B  97       7.553   0.463  19.229  1.00 38.68           C  
ATOM   2126  C   ARG B  97       8.284   1.679  19.800  1.00 37.21           C  
ATOM   2127  O   ARG B  97       9.271   1.563  20.590  1.00 37.27           O  
ATOM   2128  CB  ARG B  97       6.238   0.177  20.048  1.00 40.64           C  
ATOM   2129  CG  ARG B  97       5.266  -0.897  19.462  1.00 44.91           C  
ATOM   2130  CD  ARG B  97       4.528  -0.364  18.217  1.00 48.02           C  
ATOM   2131  NE  ARG B  97       3.538  -1.318  17.710  1.00 52.33           N  
ATOM   2132  CZ  ARG B  97       3.805  -2.330  16.878  1.00 54.21           C  
ATOM   2133  NH1 ARG B  97       5.046  -2.541  16.418  1.00 52.50           N  
ATOM   2134  NH2 ARG B  97       2.822  -3.129  16.496  1.00 54.40           N  
ATOM   2135  N   ALA B  98       7.850   2.850  19.373  1.00 35.36           N  
ATOM   2136  CA  ALA B  98       8.362   4.106  19.979  1.00 33.35           C  
ATOM   2137  C   ALA B  98       7.268   4.674  20.841  1.00 34.39           C  
ATOM   2138  O   ALA B  98       6.079   4.471  20.561  1.00 36.81           O  
ATOM   2139  CB  ALA B  98       8.748   5.115  18.928  1.00 33.86           C  
ATOM   2140  N   ASP B  99       7.675   5.346  21.915  1.00 31.76           N  
ATOM   2141  CA  ASP B  99       6.755   6.159  22.760  1.00 33.39           C  
ATOM   2142  C   ASP B  99       6.692   7.609  22.311  1.00 32.49           C  
ATOM   2143  O   ASP B  99       5.742   8.320  22.620  1.00 30.89           O  
ATOM   2144  CB  ASP B  99       7.265   6.156  24.191  1.00 34.54           C  
ATOM   2145  CG  ASP B  99       7.319   4.781  24.784  1.00 38.91           C  
ATOM   2146  OD1 ASP B  99       6.280   4.056  24.720  1.00 42.65           O  
ATOM   2147  OD2 ASP B  99       8.395   4.419  25.324  1.00 41.87           O  
ATOM   2148  N   VAL B 100       7.754   8.062  21.614  1.00 30.12           N  
ATOM   2149  CA  VAL B 100       7.807   9.437  21.138  1.00 30.22           C  
ATOM   2150  C   VAL B 100       8.468   9.451  19.770  1.00 28.79           C  
ATOM   2151  O   VAL B 100       9.529   8.880  19.594  1.00 29.58           O  
ATOM   2152  CB  VAL B 100       8.652  10.373  22.061  1.00 29.42           C  
ATOM   2153  CG1 VAL B 100       8.729  11.842  21.452  1.00 31.23           C  
ATOM   2154  CG2 VAL B 100       8.079  10.442  23.471  1.00 33.40           C  
ATOM   2155  N   ILE B 101       7.821  10.051  18.796  1.00 28.58           N  
ATOM   2156  CA  ILE B 101       8.481  10.265  17.512  1.00 27.03           C  
ATOM   2157  C   ILE B 101       8.776  11.759  17.442  1.00 27.91           C  
ATOM   2158  O   ILE B 101       7.840  12.589  17.535  1.00 28.78           O  
ATOM   2159  CB  ILE B 101       7.615   9.838  16.310  1.00 29.37           C  
ATOM   2160  CG1 ILE B 101       7.358   8.318  16.349  1.00 30.39           C  
ATOM   2161  CG2 ILE B 101       8.288  10.326  14.914  1.00 26.43           C  
ATOM   2162  CD1 ILE B 101       6.374   7.872  15.301  1.00 31.51           C  
ATOM   2163  N   LEU B 102      10.061  12.089  17.272  1.00 26.80           N  
ATOM   2164  CA  LEU B 102      10.485  13.488  17.006  1.00 27.06           C  
ATOM   2165  C   LEU B 102      10.860  13.571  15.536  1.00 26.30           C  
ATOM   2166  O   LEU B 102      11.438  12.625  14.969  1.00 26.95           O  
ATOM   2167  CB  LEU B 102      11.688  13.841  17.841  1.00 26.07           C  
ATOM   2168  CG  LEU B 102      11.729  13.657  19.344  1.00 29.45           C  
ATOM   2169  CD1 LEU B 102      13.082  14.169  19.824  1.00 32.73           C  
ATOM   2170  CD2 LEU B 102      10.557  14.499  19.918  1.00 27.00           C  
ATOM   2171  N   SER B 103      10.503  14.669  14.894  1.00 25.25           N  
ATOM   2172  CA  SER B 103      11.000  14.867  13.535  1.00 25.22           C  
ATOM   2173  C   SER B 103      11.412  16.269  13.291  1.00 23.40           C  
ATOM   2174  O   SER B 103      10.581  17.207  13.403  1.00 24.68           O  
ATOM   2175  CB  SER B 103       9.953  14.504  12.499  1.00 24.84           C  
ATOM   2176  OG  SER B 103      10.506  14.700  11.183  1.00 27.80           O  
ATOM   2177  N   ASP B 104      12.675  16.427  12.875  1.00 23.09           N  
ATOM   2178  CA  ASP B 104      13.165  17.747  12.428  1.00 25.35           C  
ATOM   2179  C   ASP B 104      13.637  17.659  10.973  1.00 24.45           C  
ATOM   2180  O   ASP B 104      14.505  18.396  10.557  1.00 25.61           O  
ATOM   2181  CB  ASP B 104      14.302  18.198  13.332  1.00 24.68           C  
ATOM   2182  CG  ASP B 104      14.631  19.706  13.197  1.00 30.85           C  
ATOM   2183  OD1 ASP B 104      13.743  20.507  12.883  1.00 30.86           O  
ATOM   2184  OD2 ASP B 104      15.779  20.051  13.429  1.00 27.11           O  
ATOM   2185  N   MET B 105      13.072  16.714  10.211  1.00 25.33           N  
ATOM   2186  CA  MET B 105      13.445  16.522   8.826  1.00 24.53           C  
ATOM   2187  C   MET B 105      13.056  17.743   7.999  1.00 25.25           C  
ATOM   2188  O   MET B 105      12.063  18.397   8.300  1.00 27.24           O  
ATOM   2189  CB  MET B 105      12.711  15.299   8.245  1.00 24.57           C  
ATOM   2190  CG  MET B 105      13.115  13.930   8.870  1.00 25.89           C  
ATOM   2191  SD  MET B 105      12.309  12.590   7.913  1.00 31.82           S  
ATOM   2192  CE  MET B 105      10.606  12.753   8.527  1.00 30.72           C  
ATOM   2193  N   ALA B 106      13.848  18.054   6.984  1.00 24.60           N  
ATOM   2194  CA  ALA B 106      13.484  19.123   6.044  1.00 27.63           C  
ATOM   2195  C   ALA B 106      14.114  18.787   4.712  1.00 26.93           C  
ATOM   2196  O   ALA B 106      15.219  18.187   4.659  1.00 26.69           O  
ATOM   2197  CB  ALA B 106      13.989  20.430   6.530  1.00 27.74           C  
ATOM   2198  N   PRO B 107      13.419  19.141   3.628  1.00 26.98           N  
ATOM   2199  CA  PRO B 107      13.994  18.966   2.302  1.00 26.92           C  
ATOM   2200  C   PRO B 107      15.090  19.940   2.078  1.00 27.18           C  
ATOM   2201  O   PRO B 107      15.215  20.954   2.816  1.00 25.96           O  
ATOM   2202  CB  PRO B 107      12.812  19.301   1.356  1.00 28.30           C  
ATOM   2203  CG  PRO B 107      11.899  20.211   2.185  1.00 29.91           C  
ATOM   2204  CD  PRO B 107      12.063  19.756   3.600  1.00 27.60           C  
ATOM   2205  N   ASN B 108      15.846  19.706   1.006  1.00 26.97           N  
ATOM   2206  CA  ASN B 108      16.804  20.699   0.532  1.00 26.49           C  
ATOM   2207  C   ASN B 108      16.068  21.963   0.129  1.00 27.37           C  
ATOM   2208  O   ASN B 108      15.132  21.908  -0.639  1.00 29.56           O  
ATOM   2209  CB  ASN B 108      17.600  20.149  -0.682  1.00 28.81           C  
ATOM   2210  CG  ASN B 108      18.491  18.977  -0.309  1.00 28.34           C  
ATOM   2211  OD1 ASN B 108      19.217  19.032   0.666  1.00 30.12           O  
ATOM   2212  ND2 ASN B 108      18.391  17.882  -1.071  1.00 30.55           N  
ATOM   2213  N   ALA B 109      16.515  23.108   0.622  1.00 34.24           N  
ATOM   2214  CA  ALA B 109      15.900  24.385   0.254  1.00 34.23           C  
ATOM   2215  C   ALA B 109      16.224  24.731  -1.176  1.00 35.59           C  
ATOM   2216  O   ALA B 109      17.379  24.588  -1.602  1.00 36.07           O  
ATOM   2217  CB  ALA B 109      16.426  25.464   1.157  1.00 37.17           C  
ATOM   2218  N   THR B 110      15.232  25.253  -1.904  1.00 34.47           N  
ATOM   2219  CA  THR B 110      15.426  25.588  -3.331  1.00 36.17           C  
ATOM   2220  C   THR B 110      15.235  27.069  -3.660  1.00 36.46           C  
ATOM   2221  O   THR B 110      15.590  27.506  -4.765  1.00 39.03           O  
ATOM   2222  CB  THR B 110      14.448  24.850  -4.216  1.00 36.18           C  
ATOM   2223  OG1 THR B 110      13.109  25.256  -3.911  1.00 37.55           O  
ATOM   2224  CG2 THR B 110      14.611  23.321  -4.091  1.00 38.69           C  
ATOM   2225  N   GLY B 111      14.633  27.813  -2.726  1.00 34.67           N  
ATOM   2226  CA  GLY B 111      14.224  29.199  -2.960  1.00 34.57           C  
ATOM   2227  C   GLY B 111      12.803  29.283  -3.505  1.00 33.21           C  
ATOM   2228  O   GLY B 111      12.271  30.364  -3.699  1.00 34.87           O  
ATOM   2229  N   PHE B 112      12.206  28.136  -3.806  1.00 32.66           N  
ATOM   2230  CA  PHE B 112      10.797  28.116  -4.228  1.00 32.15           C  
ATOM   2231  C   PHE B 112       9.995  27.836  -2.988  1.00 30.96           C  
ATOM   2232  O   PHE B 112      10.060  26.753  -2.431  1.00 30.92           O  
ATOM   2233  CB  PHE B 112      10.594  27.062  -5.327  1.00 33.02           C  
ATOM   2234  CG  PHE B 112      11.220  27.456  -6.628  1.00 35.66           C  
ATOM   2235  CD1 PHE B 112      10.543  28.295  -7.505  1.00 37.37           C  
ATOM   2236  CD2 PHE B 112      12.530  27.102  -6.917  1.00 37.42           C  
ATOM   2237  CE1 PHE B 112      11.142  28.707  -8.711  1.00 40.43           C  
ATOM   2238  CE2 PHE B 112      13.123  27.502  -8.091  1.00 42.78           C  
ATOM   2239  CZ  PHE B 112      12.430  28.308  -8.990  1.00 38.32           C  
ATOM   2240  N   ARG B 113       9.318  28.852  -2.484  1.00 32.34           N  
ATOM   2241  CA  ARG B 113       8.884  28.812  -1.079  1.00 32.55           C  
ATOM   2242  C   ARG B 113       7.693  27.848  -0.839  1.00 32.62           C  
ATOM   2243  O   ARG B 113       7.758  26.967   0.021  1.00 32.47           O  
ATOM   2244  CB  ARG B 113       8.583  30.240  -0.565  1.00 34.80           C  
ATOM   2245  CG  ARG B 113       9.715  31.246  -0.848  1.00 37.17           C  
ATOM   2246  CD  ARG B 113       9.352  32.684  -0.375  1.00 38.41           C  
ATOM   2247  NE  ARG B 113       8.302  33.246  -1.204  1.00 41.89           N  
ATOM   2248  CZ  ARG B 113       8.514  33.851  -2.368  1.00 45.81           C  
ATOM   2249  NH1 ARG B 113       9.760  34.013  -2.832  1.00 46.23           N  
ATOM   2250  NH2 ARG B 113       7.484  34.309  -3.067  1.00 48.77           N  
ATOM   2251  N   ASP B 114       6.633  27.991  -1.634  1.00 31.38           N  
ATOM   2252  CA  ASP B 114       5.482  27.097  -1.552  1.00 32.06           C  
ATOM   2253  C   ASP B 114       5.949  25.654  -1.788  1.00 31.71           C  
ATOM   2254  O   ASP B 114       5.546  24.728  -1.063  1.00 32.57           O  
ATOM   2255  CB  ASP B 114       4.433  27.448  -2.636  1.00 32.05           C  
ATOM   2256  CG  ASP B 114       3.557  28.675  -2.289  1.00 34.52           C  
ATOM   2257  OD1 ASP B 114       3.770  29.396  -1.271  1.00 32.57           O  
ATOM   2258  OD2 ASP B 114       2.660  28.941  -3.097  1.00 36.36           O  
ATOM   2259  N   LEU B 115       6.834  25.463  -2.759  1.00 30.15           N  
ATOM   2260  CA  LEU B 115       7.261  24.116  -3.111  1.00 30.84           C  
ATOM   2261  C   LEU B 115       8.023  23.457  -1.952  1.00 31.07           C  
ATOM   2262  O   LEU B 115       7.754  22.289  -1.580  1.00 30.11           O  
ATOM   2263  CB  LEU B 115       8.114  24.156  -4.408  1.00 31.65           C  
ATOM   2264  CG  LEU B 115       8.574  22.808  -4.894  1.00 32.20           C  
ATOM   2265  CD1 LEU B 115       7.388  21.937  -5.182  1.00 36.54           C  
ATOM   2266  CD2 LEU B 115       9.453  22.949  -6.154  1.00 34.66           C  
ATOM   2267  N   ASP B 116       8.965  24.205  -1.371  1.00 29.46           N  
ATOM   2268  CA  ASP B 116       9.732  23.705  -0.189  1.00 30.63           C  
ATOM   2269  C   ASP B 116       8.766  23.446   0.970  1.00 30.39           C  
ATOM   2270  O   ASP B 116       8.854  22.408   1.630  1.00 30.84           O  
ATOM   2271  CB  ASP B 116      10.795  24.707   0.260  1.00 30.64           C  
ATOM   2272  CG  ASP B 116      11.975  24.845  -0.737  1.00 34.07           C  
ATOM   2273  OD1 ASP B 116      12.053  24.090  -1.735  1.00 29.58           O  
ATOM   2274  OD2 ASP B 116      12.782  25.801  -0.546  1.00 34.63           O  
ATOM   2275  N   HIS B 117       7.799  24.349   1.175  1.00 30.98           N  
ATOM   2276  CA  HIS B 117       6.863  24.197   2.323  1.00 31.70           C  
ATOM   2277  C   HIS B 117       6.015  22.951   2.112  1.00 32.24           C  
ATOM   2278  O   HIS B 117       5.794  22.156   3.021  1.00 30.88           O  
ATOM   2279  CB  HIS B 117       5.937  25.408   2.471  1.00 34.38           C  
ATOM   2280  CG  HIS B 117       6.626  26.682   2.841  1.00 37.14           C  
ATOM   2281  ND1 HIS B 117       5.990  27.907   2.772  1.00 38.24           N  
ATOM   2282  CD2 HIS B 117       7.894  26.939   3.239  1.00 39.99           C  
ATOM   2283  CE1 HIS B 117       6.828  28.860   3.148  1.00 41.43           C  
ATOM   2284  NE2 HIS B 117       7.983  28.296   3.462  1.00 43.14           N  
ATOM   2285  N   ASP B 118       5.513  22.795   0.912  1.00 31.30           N  
ATOM   2286  CA  ASP B 118       4.639  21.681   0.613  1.00 32.06           C  
ATOM   2287  C   ASP B 118       5.411  20.373   0.701  1.00 30.45           C  
ATOM   2288  O   ASP B 118       4.859  19.353   1.071  1.00 32.58           O  
ATOM   2289  CB  ASP B 118       4.069  21.847  -0.813  1.00 32.25           C  
ATOM   2290  CG  ASP B 118       3.130  23.035  -0.916  1.00 34.84           C  
ATOM   2291  OD1 ASP B 118       2.817  23.652   0.141  1.00 34.35           O  
ATOM   2292  OD2 ASP B 118       2.717  23.368  -2.041  1.00 36.20           O  
ATOM   2293  N   ARG B 119       6.672  20.389   0.271  1.00 31.08           N  
ATOM   2294  CA  ARG B 119       7.472  19.184   0.310  1.00 29.29           C  
ATOM   2295  C   ARG B 119       7.685  18.755   1.789  1.00 29.62           C  
ATOM   2296  O   ARG B 119       7.667  17.573   2.125  1.00 29.58           O  
ATOM   2297  CB  ARG B 119       8.811  19.428  -0.394  1.00 29.96           C  
ATOM   2298  CG  ARG B 119       8.673  19.245  -1.894  1.00 31.38           C  
ATOM   2299  CD  ARG B 119      10.020  19.394  -2.564  1.00 29.18           C  
ATOM   2300  NE  ARG B 119       9.921  19.157  -3.985  1.00 34.37           N  
ATOM   2301  CZ  ARG B 119      10.777  19.640  -4.880  1.00 35.02           C  
ATOM   2302  NH1 ARG B 119      11.786  20.417  -4.492  1.00 38.30           N  
ATOM   2303  NH2 ARG B 119      10.601  19.372  -6.171  1.00 38.70           N  
ATOM   2304  N   LEU B 120       7.876  19.740   2.652  1.00 29.55           N  
ATOM   2305  CA  LEU B 120       8.013  19.468   4.075  1.00 29.41           C  
ATOM   2306  C   LEU B 120       6.733  18.883   4.638  1.00 29.46           C  
ATOM   2307  O   LEU B 120       6.741  17.847   5.303  1.00 29.59           O  
ATOM   2308  CB  LEU B 120       8.459  20.730   4.824  1.00 29.76           C  
ATOM   2309  CG  LEU B 120       8.587  20.552   6.350  1.00 33.68           C  
ATOM   2310  CD1 LEU B 120       9.273  19.174   6.716  1.00 33.80           C  
ATOM   2311  CD2 LEU B 120       9.373  21.703   6.989  1.00 33.03           C  
ATOM   2312  N   ILE B 121       5.605  19.518   4.352  1.00 29.79           N  
ATOM   2313  CA  ILE B 121       4.318  18.954   4.774  1.00 30.36           C  
ATOM   2314  C   ILE B 121       4.156  17.507   4.264  1.00 31.65           C  
ATOM   2315  O   ILE B 121       3.691  16.653   4.987  1.00 31.60           O  
ATOM   2316  CB  ILE B 121       3.112  19.847   4.288  1.00 31.37           C  
ATOM   2317  CG1 ILE B 121       3.181  21.226   4.957  1.00 31.83           C  
ATOM   2318  CG2 ILE B 121       1.744  19.189   4.619  1.00 33.53           C  
ATOM   2319  CD1 ILE B 121       3.212  21.184   6.456  1.00 37.48           C  
ATOM   2320  N   SER B 122       4.481  17.255   2.997  1.00 31.71           N  
ATOM   2321  CA  SER B 122       4.346  15.893   2.454  1.00 33.96           C  
ATOM   2322  C   SER B 122       5.212  14.918   3.275  1.00 34.51           C  
ATOM   2323  O   SER B 122       4.796  13.785   3.549  1.00 36.05           O  
ATOM   2324  CB  SER B 122       4.776  15.844   0.995  1.00 35.59           C  
ATOM   2325  OG  SER B 122       4.393  14.592   0.422  1.00 40.91           O  
ATOM   2326  N   LEU B 123       6.396  15.379   3.679  1.00 33.53           N  
ATOM   2327  CA  LEU B 123       7.311  14.541   4.439  1.00 34.04           C  
ATOM   2328  C   LEU B 123       6.659  14.139   5.761  1.00 33.64           C  
ATOM   2329  O   LEU B 123       6.733  12.982   6.173  1.00 35.05           O  
ATOM   2330  CB  LEU B 123       8.553  15.310   4.770  1.00 33.99           C  
ATOM   2331  CG  LEU B 123       9.885  14.695   4.356  1.00 38.93           C  
ATOM   2332  CD1 LEU B 123      11.028  15.502   4.941  1.00 36.32           C  
ATOM   2333  CD2 LEU B 123       9.981  13.213   4.707  1.00 35.34           C  
ATOM   2334  N   CYS B 124       6.088  15.126   6.437  1.00 32.53           N  
ATOM   2335  CA  CYS B 124       5.379  14.893   7.739  1.00 32.95           C  
ATOM   2336  C   CYS B 124       4.230  13.937   7.536  1.00 33.59           C  
ATOM   2337  O   CYS B 124       4.041  13.020   8.336  1.00 34.96           O  
ATOM   2338  CB  CYS B 124       4.878  16.184   8.312  1.00 31.50           C  
ATOM   2339  SG  CYS B 124       6.157  17.400   8.748  1.00 35.10           S  
ATOM   2340  N   LEU B 125       3.449  14.144   6.459  1.00 33.68           N  
ATOM   2341  CA  LEU B 125       2.300  13.261   6.183  1.00 35.23           C  
ATOM   2342  C   LEU B 125       2.740  11.813   5.931  1.00 35.13           C  
ATOM   2343  O   LEU B 125       2.089  10.868   6.365  1.00 37.57           O  
ATOM   2344  CB  LEU B 125       1.465  13.798   4.976  1.00 36.42           C  
ATOM   2345  CG  LEU B 125       0.504  14.972   5.273  1.00 37.72           C  
ATOM   2346  CD1 LEU B 125      -0.009  15.618   3.995  1.00 40.25           C  
ATOM   2347  CD2 LEU B 125      -0.689  14.550   6.192  1.00 41.52           C  
ATOM   2348  N   THR B 126       3.856  11.642   5.223  1.00 35.93           N  
ATOM   2349  CA  THR B 126       4.398  10.316   4.966  1.00 36.14           C  
ATOM   2350  C   THR B 126       4.842   9.665   6.259  1.00 34.60           C  
ATOM   2351  O   THR B 126       4.605   8.471   6.477  1.00 34.48           O  
ATOM   2352  CB  THR B 126       5.578  10.410   3.962  1.00 36.10           C  
ATOM   2353  OG1 THR B 126       5.069  10.906   2.724  1.00 39.17           O  
ATOM   2354  CG2 THR B 126       6.213   9.066   3.731  1.00 40.03           C  
ATOM   2355  N   LEU B 127       5.512  10.439   7.121  1.00 32.40           N  
ATOM   2356  CA  LEU B 127       5.938   9.917   8.406  1.00 31.43           C  
ATOM   2357  C   LEU B 127       4.703   9.560   9.241  1.00 32.02           C  
ATOM   2358  O   LEU B 127       4.707   8.562   9.944  1.00 33.26           O  
ATOM   2359  CB  LEU B 127       6.796  10.951   9.183  1.00 32.09           C  
ATOM   2360  CG  LEU B 127       7.188  10.622  10.632  1.00 29.59           C  
ATOM   2361  CD1 LEU B 127       8.014   9.343  10.793  1.00 35.33           C  
ATOM   2362  CD2 LEU B 127       7.935  11.770  11.258  1.00 29.87           C  
ATOM   2363  N   LEU B 128       3.659  10.369   9.162  1.00 32.21           N  
ATOM   2364  CA  LEU B 128       2.415  10.087   9.950  1.00 34.52           C  
ATOM   2365  C   LEU B 128       1.770   8.796   9.465  1.00 37.32           C  
ATOM   2366  O   LEU B 128       1.076   8.084  10.239  1.00 39.39           O  
ATOM   2367  CB  LEU B 128       1.417  11.235   9.813  1.00 34.96           C  
ATOM   2368  CG  LEU B 128       0.076  11.109  10.554  1.00 36.40           C  
ATOM   2369  CD1 LEU B 128       0.290  10.845  12.036  1.00 36.38           C  
ATOM   2370  CD2 LEU B 128      -0.788  12.343  10.355  1.00 39.32           C  
ATOM   2371  N   SER B 129       1.970   8.515   8.180  1.00 38.98           N  
ATOM   2372  CA  SER B 129       1.302   7.381   7.525  1.00 42.60           C  
ATOM   2373  C   SER B 129       1.897   6.063   8.014  1.00 44.46           C  
ATOM   2374  O   SER B 129       1.222   5.007   7.997  1.00 46.03           O  
ATOM   2375  CB  SER B 129       1.391   7.490   6.002  1.00 43.01           C  
ATOM   2376  OG  SER B 129       2.673   7.117   5.534  1.00 45.06           O  
ATOM   2377  N   VAL B 130       3.160   6.114   8.424  1.00 42.86           N  
ATOM   2378  CA  VAL B 130       3.838   4.946   8.969  1.00 44.68           C  
ATOM   2379  C   VAL B 130       3.839   4.924  10.494  1.00 44.79           C  
ATOM   2380  O   VAL B 130       4.350   3.976  11.128  1.00 45.44           O  
ATOM   2381  CB  VAL B 130       5.277   4.753   8.387  1.00 44.86           C  
ATOM   2382  CG1 VAL B 130       5.256   4.736   6.868  1.00 47.27           C  
ATOM   2383  CG2 VAL B 130       6.250   5.838   8.880  1.00 41.51           C  
ATOM   2384  N   THR B 131       3.227   5.941  11.098  1.00 44.16           N  
ATOM   2385  CA  THR B 131       3.151   6.005  12.532  1.00 43.43           C  
ATOM   2386  C   THR B 131       2.225   4.893  13.175  1.00 44.67           C  
ATOM   2387  O   THR B 131       2.617   4.294  14.176  1.00 45.14           O  
ATOM   2388  CB  THR B 131       2.876   7.475  13.015  1.00 43.59           C  
ATOM   2389  OG1 THR B 131       4.065   8.272  12.769  1.00 42.50           O  
ATOM   2390  CG2 THR B 131       2.557   7.526  14.445  1.00 44.72           C  
ATOM   2391  N   PRO B 132       1.059   4.562  12.545  1.00 46.55           N  
ATOM   2392  CA  PRO B 132       0.263   3.434  13.077  1.00 48.63           C  
ATOM   2393  C   PRO B 132       1.093   2.167  13.320  1.00 48.38           C  
ATOM   2394  O   PRO B 132       0.780   1.374  14.207  1.00 49.06           O  
ATOM   2395  CB  PRO B 132      -0.777   3.184  11.981  1.00 52.57           C  
ATOM   2396  CG  PRO B 132      -0.923   4.483  11.279  1.00 53.94           C  
ATOM   2397  CD  PRO B 132       0.399   5.204  11.390  1.00 49.56           C  
ATOM   2398  N   ASP B 133       2.134   1.979  12.520  1.00 49.28           N  
ATOM   2399  CA  ASP B 133       3.014   0.824  12.633  1.00 50.59           C  
ATOM   2400  C   ASP B 133       4.012   0.969  13.787  1.00 47.11           C  
ATOM   2401  O   ASP B 133       4.565  -0.005  14.270  1.00 46.94           O  
ATOM   2402  CB  ASP B 133       3.788   0.664  11.323  1.00 53.82           C  
ATOM   2403  CG  ASP B 133       2.876   0.637  10.114  1.00 58.90           C  
ATOM   2404  OD1 ASP B 133       2.189  -0.386   9.921  1.00 63.72           O  
ATOM   2405  OD2 ASP B 133       2.838   1.647   9.368  1.00 62.39           O  
ATOM   2406  N   ILE B 134       4.335   2.197  14.157  1.00 44.87           N  
ATOM   2407  CA  ILE B 134       5.486   2.356  15.015  1.00 41.95           C  
ATOM   2408  C   ILE B 134       5.183   3.069  16.340  1.00 39.32           C  
ATOM   2409  O   ILE B 134       5.883   2.868  17.365  1.00 37.26           O  
ATOM   2410  CB  ILE B 134       6.722   2.977  14.233  1.00 43.88           C  
ATOM   2411  CG1 ILE B 134       7.223   4.225  14.893  1.00 40.87           C  
ATOM   2412  CG2 ILE B 134       6.497   3.041  12.672  1.00 46.72           C  
ATOM   2413  CD1 ILE B 134       8.332   3.924  15.854  1.00 43.88           C  
ATOM   2414  N   LEU B 135       4.139   3.886  16.353  1.00 38.05           N  
ATOM   2415  CA  LEU B 135       3.833   4.628  17.588  1.00 35.99           C  
ATOM   2416  C   LEU B 135       2.888   3.872  18.532  1.00 37.17           C  
ATOM   2417  O   LEU B 135       1.768   3.459  18.153  1.00 39.81           O  
ATOM   2418  CB  LEU B 135       3.340   6.059  17.294  1.00 34.83           C  
ATOM   2419  CG  LEU B 135       3.214   7.049  18.445  1.00 35.65           C  
ATOM   2420  CD1 LEU B 135       4.481   7.244  19.220  1.00 30.04           C  
ATOM   2421  CD2 LEU B 135       2.672   8.394  17.979  1.00 34.12           C  
ATOM   2422  N   GLN B 136       3.368   3.624  19.736  1.00 34.37           N  
ATOM   2423  CA  GLN B 136       2.479   3.105  20.807  1.00 38.58           C  
ATOM   2424  C   GLN B 136       1.224   3.998  20.956  1.00 40.25           C  
ATOM   2425  O   GLN B 136       1.358   5.227  21.049  1.00 40.22           O  
ATOM   2426  CB  GLN B 136       3.255   3.109  22.130  1.00 37.72           C  
ATOM   2427  CG  GLN B 136       2.540   2.339  23.239  1.00 42.24           C  
ATOM   2428  CD  GLN B 136       2.764   0.853  23.114  1.00 50.14           C  
ATOM   2429  OE1 GLN B 136       3.839   0.395  22.678  1.00 47.22           O  
ATOM   2430  NE2 GLN B 136       1.761   0.086  23.481  1.00 53.81           N  
ATOM   2431  N   PRO B 137       0.007   3.399  20.990  1.00 44.29           N  
ATOM   2432  CA  PRO B 137      -1.165   4.134  21.483  1.00 47.27           C  
ATOM   2433  C   PRO B 137      -0.818   4.904  22.778  1.00 48.11           C  
ATOM   2434  O   PRO B 137      -0.093   4.363  23.636  1.00 48.26           O  
ATOM   2435  CB  PRO B 137      -2.169   3.017  21.774  1.00 52.15           C  
ATOM   2436  CG  PRO B 137      -1.838   1.971  20.739  1.00 50.83           C  
ATOM   2437  CD  PRO B 137      -0.342   2.024  20.557  1.00 45.48           C  
ATOM   2438  N   GLY B 138      -1.279   6.168  22.880  1.00 48.02           N  
ATOM   2439  CA  GLY B 138      -0.923   7.075  24.007  1.00 48.08           C  
ATOM   2440  C   GLY B 138       0.363   7.891  23.777  1.00 45.55           C  
ATOM   2441  O   GLY B 138       0.755   8.716  24.617  1.00 44.91           O  
ATOM   2442  N   GLY B 139       0.986   7.672  22.625  1.00 40.01           N  
ATOM   2443  CA  GLY B 139       2.352   8.129  22.361  1.00 39.07           C  
ATOM   2444  C   GLY B 139       2.358   9.559  21.878  1.00 36.53           C  
ATOM   2445  O   GLY B 139       1.298  10.149  21.695  1.00 39.84           O  
ATOM   2446  N   THR B 140       3.553  10.094  21.589  1.00 34.91           N  
ATOM   2447  CA  THR B 140       3.723  11.524  21.273  1.00 31.81           C  
ATOM   2448  C   THR B 140       4.416  11.679  19.920  1.00 30.94           C  
ATOM   2449  O   THR B 140       5.211  10.831  19.546  1.00 29.73           O  
ATOM   2450  CB  THR B 140       4.517  12.238  22.378  1.00 32.25           C  
ATOM   2451  OG1 THR B 140       3.732  12.216  23.553  1.00 32.90           O  
ATOM   2452  CG2 THR B 140       4.872  13.709  22.006  1.00 31.29           C  
ATOM   2453  N   PHE B 141       3.997  12.692  19.162  1.00 29.14           N  
ATOM   2454  CA  PHE B 141       4.564  12.953  17.785  1.00 29.50           C  
ATOM   2455  C   PHE B 141       4.848  14.467  17.738  1.00 28.40           C  
ATOM   2456  O   PHE B 141       3.929  15.276  17.862  1.00 29.89           O  
ATOM   2457  CB  PHE B 141       3.478  12.570  16.742  1.00 31.66           C  
ATOM   2458  CG  PHE B 141       3.894  12.721  15.297  1.00 30.84           C  
ATOM   2459  CD1 PHE B 141       4.381  11.632  14.593  1.00 33.43           C  
ATOM   2460  CD2 PHE B 141       3.618  13.894  14.604  1.00 32.00           C  
ATOM   2461  CE1 PHE B 141       4.800  11.796  13.227  1.00 32.77           C  
ATOM   2462  CE2 PHE B 141       3.935  14.030  13.255  1.00 33.11           C  
ATOM   2463  CZ  PHE B 141       4.512  12.961  12.574  1.00 33.91           C  
ATOM   2464  N   LEU B 142       6.106  14.841  17.552  1.00 28.73           N  
ATOM   2465  CA  LEU B 142       6.496  16.255  17.415  1.00 28.44           C  
ATOM   2466  C   LEU B 142       7.144  16.399  16.070  1.00 27.55           C  
ATOM   2467  O   LEU B 142       8.161  15.721  15.798  1.00 29.42           O  
ATOM   2468  CB  LEU B 142       7.520  16.640  18.494  1.00 28.51           C  
ATOM   2469  CG  LEU B 142       8.150  18.039  18.346  1.00 31.90           C  
ATOM   2470  CD1 LEU B 142       7.138  19.103  18.782  1.00 29.95           C  
ATOM   2471  CD2 LEU B 142       9.412  18.163  19.189  1.00 32.46           C  
ATOM   2472  N   CYS B 143       6.574  17.229  15.202  1.00 27.37           N  
ATOM   2473  CA  CYS B 143       7.157  17.414  13.853  1.00 30.24           C  
ATOM   2474  C   CYS B 143       7.376  18.872  13.442  1.00 30.91           C  
ATOM   2475  O   CYS B 143       6.531  19.720  13.681  1.00 30.76           O  
ATOM   2476  CB  CYS B 143       6.343  16.661  12.781  1.00 33.50           C  
ATOM   2477  SG  CYS B 143       4.701  17.391  12.356  1.00 40.28           S  
ATOM   2478  N   LYS B 144       8.494  19.150  12.758  1.00 30.68           N  
ATOM   2479  CA  LYS B 144       8.774  20.494  12.333  1.00 33.81           C  
ATOM   2480  C   LYS B 144       8.040  20.788  11.011  1.00 36.45           C  
ATOM   2481  O   LYS B 144       7.991  19.931  10.119  1.00 38.15           O  
ATOM   2482  CB  LYS B 144      10.280  20.665  12.110  1.00 35.93           C  
ATOM   2483  CG  LYS B 144      10.637  20.709  10.639  1.00 43.84           C  
ATOM   2484  CD  LYS B 144      11.640  21.808  10.308  1.00 43.89           C  
ATOM   2485  CE  LYS B 144      13.016  21.229  10.216  1.00 49.03           C  
ATOM   2486  NZ  LYS B 144      14.100  22.246  10.412  1.00 49.87           N  
ATOM   2487  N   THR B 145       7.531  22.009  10.887  1.00 38.48           N  
ATOM   2488  CA  THR B 145       7.003  22.552   9.614  1.00 43.29           C  
ATOM   2489  C   THR B 145       7.524  23.989   9.311  1.00 45.48           C  
ATOM   2490  O   THR B 145       8.100  24.662  10.189  1.00 42.03           O  
ATOM   2491  CB  THR B 145       5.464  22.547   9.607  1.00 44.73           C  
ATOM   2492  OG1 THR B 145       4.987  21.200   9.793  1.00 47.97           O  
ATOM   2493  CG2 THR B 145       4.911  23.133   8.294  1.00 51.26           C  
ATOM   2494  N   TRP B 146       7.377  24.408   8.050  1.00 38.01           N  
ATOM   2495  CA  TRP B 146       7.424  25.832   7.693  1.00 42.47           C  
ATOM   2496  C   TRP B 146       6.027  26.367   7.403  1.00 44.11           C  
ATOM   2497  O   TRP B 146       5.244  25.765   6.610  1.00 44.64           O  
ATOM   2498  CB  TRP B 146       8.335  26.094   6.492  1.00 43.17           C  
ATOM   2499  CG  TRP B 146       9.758  25.674   6.662  1.00 45.16           C  
ATOM   2500  CD1 TRP B 146      10.630  26.046   7.660  1.00 47.40           C  
ATOM   2501  CD2 TRP B 146      10.491  24.843   5.770  1.00 44.91           C  
ATOM   2502  NE1 TRP B 146      11.877  25.460   7.457  1.00 46.83           N  
ATOM   2503  CE2 TRP B 146      11.816  24.715   6.297  1.00 48.46           C  
ATOM   2504  CE3 TRP B 146      10.154  24.154   4.598  1.00 43.24           C  
ATOM   2505  CZ2 TRP B 146      12.802  23.932   5.669  1.00 44.32           C  
ATOM   2506  CZ3 TRP B 146      11.145  23.407   3.946  1.00 43.11           C  
ATOM   2507  CH2 TRP B 146      12.454  23.296   4.493  1.00 47.12           C  
ATOM   2508  N   ALA B 147       5.741  27.517   8.016  1.00 46.37           N  
ATOM   2509  CA  ALA B 147       4.443  28.179   7.926  1.00 49.05           C  
ATOM   2510  C   ALA B 147       3.937  28.254   6.489  1.00 49.62           C  
ATOM   2511  O   ALA B 147       4.672  28.654   5.564  1.00 49.87           O  
ATOM   2512  CB  ALA B 147       4.505  29.580   8.556  1.00 50.93           C  
ATOM   2513  N   GLY B 148       2.665  27.892   6.320  1.00 50.41           N  
ATOM   2514  CA  GLY B 148       2.064  27.729   4.991  1.00 50.52           C  
ATOM   2515  C   GLY B 148       0.571  27.368   5.048  1.00 50.72           C  
ATOM   2516  O   GLY B 148       0.037  27.009   6.116  1.00 50.11           O  
ATOM   2517  N   SER B 149      -0.102  27.471   3.892  1.00 50.62           N  
ATOM   2518  CA  SER B 149      -1.544  27.178   3.793  1.00 50.05           C  
ATOM   2519  C   SER B 149      -1.846  25.655   3.824  1.00 48.36           C  
ATOM   2520  O   SER B 149      -2.982  25.243   4.090  1.00 48.33           O  
ATOM   2521  CB  SER B 149      -2.099  27.769   2.478  1.00 52.23           C  
ATOM   2522  OG  SER B 149      -1.576  27.064   1.363  1.00 51.20           O  
ATOM   2523  N   GLN B 150      -0.848  24.842   3.447  1.00 45.74           N  
ATOM   2524  CA  GLN B 150      -1.052  23.417   3.245  1.00 44.71           C  
ATOM   2525  C   GLN B 150      -0.832  22.681   4.551  1.00 44.85           C  
ATOM   2526  O   GLN B 150      -1.121  21.491   4.640  1.00 44.27           O  
ATOM   2527  CB  GLN B 150      -0.083  22.878   2.178  1.00 44.50           C  
ATOM   2528  CG  GLN B 150      -0.297  23.477   0.794  1.00 42.75           C  
ATOM   2529  CD  GLN B 150      -1.719  23.309   0.279  1.00 43.13           C  
ATOM   2530  OE1 GLN B 150      -2.081  22.252  -0.229  1.00 42.77           O  
ATOM   2531  NE2 GLN B 150      -2.507  24.366   0.359  1.00 44.03           N  
ATOM   2532  N   SER B 151      -0.354  23.415   5.568  1.00 45.16           N  
ATOM   2533  CA  SER B 151      -0.157  22.877   6.925  1.00 46.51           C  
ATOM   2534  C   SER B 151      -1.495  22.474   7.557  1.00 47.63           C  
ATOM   2535  O   SER B 151      -1.517  21.672   8.449  1.00 47.82           O  
ATOM   2536  CB  SER B 151       0.570  23.898   7.835  1.00 46.77           C  
ATOM   2537  OG  SER B 151       1.965  24.019   7.496  1.00 48.02           O  
ATOM   2538  N   ARG B 152      -2.611  23.015   7.049  1.00 50.66           N  
ATOM   2539  CA  ARG B 152      -3.935  22.633   7.550  1.00 52.09           C  
ATOM   2540  C   ARG B 152      -4.351  21.168   7.256  1.00 52.08           C  
ATOM   2541  O   ARG B 152      -5.141  20.578   8.012  1.00 53.81           O  
ATOM   2542  CB  ARG B 152      -5.016  23.620   7.077  1.00 54.39           C  
ATOM   2543  N   ARG B 153      -3.841  20.578   6.181  1.00 50.55           N  
ATOM   2544  CA  ARG B 153      -4.104  19.143   5.930  1.00 50.63           C  
ATOM   2545  C   ARG B 153      -3.332  18.267   6.955  1.00 48.97           C  
ATOM   2546  O   ARG B 153      -3.808  17.204   7.394  1.00 49.76           O  
ATOM   2547  CB  ARG B 153      -3.712  18.751   4.482  1.00 50.27           C  
ATOM   2548  N   LEU B 154      -2.142  18.718   7.319  1.00 46.51           N  
ATOM   2549  CA  LEU B 154      -1.379  18.027   8.342  1.00 43.90           C  
ATOM   2550  C   LEU B 154      -2.123  18.139   9.675  1.00 45.58           C  
ATOM   2551  O   LEU B 154      -2.334  17.139  10.367  1.00 44.61           O  
ATOM   2552  CB  LEU B 154       0.026  18.615   8.461  1.00 44.31           C  
ATOM   2553  CG  LEU B 154       0.928  17.961   9.502  1.00 41.41           C  
ATOM   2554  CD1 LEU B 154       0.950  16.463   9.283  1.00 39.92           C  
ATOM   2555  CD2 LEU B 154       2.374  18.559   9.421  1.00 40.44           C  
ATOM   2556  N   GLN B 155      -2.548  19.353  10.003  1.00 46.09           N  
ATOM   2557  CA  GLN B 155      -3.112  19.608  11.299  1.00 47.33           C  
ATOM   2558  C   GLN B 155      -4.366  18.771  11.512  1.00 49.23           C  
ATOM   2559  O   GLN B 155      -4.652  18.349  12.630  1.00 50.15           O  
ATOM   2560  CB  GLN B 155      -3.410  21.091  11.477  1.00 48.74           C  
ATOM   2561  CG  GLN B 155      -3.777  21.433  12.916  1.00 50.26           C  
ATOM   2562  CD  GLN B 155      -4.009  22.899  13.136  1.00 56.10           C  
ATOM   2563  OE1 GLN B 155      -3.563  23.743  12.341  1.00 58.19           O  
ATOM   2564  NE2 GLN B 155      -4.744  23.229  14.213  1.00 56.50           N  
ATOM   2565  N   ARG B 156      -5.128  18.538  10.441  1.00 51.26           N  
ATOM   2566  CA  ARG B 156      -6.430  17.871  10.585  1.00 53.69           C  
ATOM   2567  C   ARG B 156      -6.295  16.351  10.713  1.00 53.53           C  
ATOM   2568  O   ARG B 156      -7.127  15.699  11.371  1.00 55.38           O  
ATOM   2569  CB  ARG B 156      -7.410  18.266   9.463  1.00 55.54           C  
ATOM   2570  N   ARG B 157      -5.239  15.788  10.121  1.00 52.35           N  
ATOM   2571  CA  ARG B 157      -4.977  14.354  10.290  1.00 52.67           C  
ATOM   2572  C   ARG B 157      -4.466  14.058  11.704  1.00 50.44           C  
ATOM   2573  O   ARG B 157      -4.865  13.070  12.314  1.00 52.16           O  
ATOM   2574  CB  ARG B 157      -4.003  13.809   9.225  1.00 51.49           C  
ATOM   2575  CG  ARG B 157      -4.500  12.472   8.587  1.00 55.71           C  
ATOM   2576  CD  ARG B 157      -3.370  11.631   8.006  1.00 53.39           C  
ATOM   2577  NE  ARG B 157      -3.348  11.655   6.544  1.00 58.97           N  
ATOM   2578  N   LEU B 158      -3.577  14.905  12.221  1.00 47.72           N  
ATOM   2579  CA  LEU B 158      -3.157  14.772  13.625  1.00 46.70           C  
ATOM   2580  C   LEU B 158      -4.352  14.942  14.565  1.00 48.32           C  
ATOM   2581  O   LEU B 158      -4.506  14.181  15.526  1.00 49.19           O  
ATOM   2582  CB  LEU B 158      -2.038  15.760  13.993  1.00 44.63           C  
ATOM   2583  CG  LEU B 158      -0.727  15.579  13.213  1.00 41.02           C  
ATOM   2584  CD1 LEU B 158       0.156  16.804  13.387  1.00 42.36           C  
ATOM   2585  CD2 LEU B 158      -0.010  14.306  13.714  1.00 38.62           C  
ATOM   2586  N   THR B 159      -5.203  15.931  14.277  1.00 50.18           N  
ATOM   2587  CA  THR B 159      -6.383  16.189  15.122  1.00 51.63           C  
ATOM   2588  C   THR B 159      -7.312  14.962  15.159  1.00 53.86           C  
ATOM   2589  O   THR B 159      -8.028  14.729  16.154  1.00 54.56           O  
ATOM   2590  CB  THR B 159      -7.192  17.449  14.667  1.00 53.20           C  
ATOM   2591  OG1 THR B 159      -6.340  18.597  14.671  1.00 53.01           O  
ATOM   2592  CG2 THR B 159      -8.342  17.716  15.629  1.00 55.78           C  
ATOM   2593  N   GLU B 160      -7.319  14.203  14.063  1.00 53.55           N  
ATOM   2594  CA  GLU B 160      -8.151  12.989  13.958  1.00 56.07           C  
ATOM   2595  C   GLU B 160      -7.538  11.785  14.681  1.00 55.31           C  
ATOM   2596  O   GLU B 160      -8.263  10.928  15.191  1.00 58.67           O  
ATOM   2597  CB  GLU B 160      -8.433  12.636  12.485  1.00 56.40           C  
ATOM   2598  N   GLU B 161      -6.210  11.736  14.726  1.00 52.70           N  
ATOM   2599  CA  GLU B 161      -5.480  10.532  15.138  1.00 51.52           C  
ATOM   2600  C   GLU B 161      -4.939  10.592  16.571  1.00 48.62           C  
ATOM   2601  O   GLU B 161      -4.474   9.576  17.103  1.00 49.65           O  
ATOM   2602  CB  GLU B 161      -4.345  10.229  14.136  1.00 49.38           C  
ATOM   2603  CG  GLU B 161      -4.822   9.580  12.848  1.00 52.66           C  
ATOM   2604  CD  GLU B 161      -3.742   9.455  11.819  1.00 52.14           C  
ATOM   2605  OE1 GLU B 161      -2.594   9.125  12.194  1.00 54.66           O  
ATOM   2606  OE2 GLU B 161      -4.037   9.679  10.612  1.00 57.55           O  
ATOM   2607  N   PHE B 162      -4.994  11.786  17.185  1.00 48.73           N  
ATOM   2608  CA  PHE B 162      -4.456  12.031  18.547  1.00 44.11           C  
ATOM   2609  C   PHE B 162      -5.475  12.792  19.364  1.00 44.10           C  
ATOM   2610  O   PHE B 162      -6.292  13.541  18.824  1.00 45.69           O  
ATOM   2611  CB  PHE B 162      -3.171  12.895  18.530  1.00 40.60           C  
ATOM   2612  CG  PHE B 162      -1.969  12.231  17.874  1.00 38.06           C  
ATOM   2613  CD1 PHE B 162      -0.926  11.746  18.651  1.00 33.28           C  
ATOM   2614  CD2 PHE B 162      -1.896  12.097  16.474  1.00 40.78           C  
ATOM   2615  CE1 PHE B 162       0.214  11.138  18.026  1.00 37.75           C  
ATOM   2616  CE2 PHE B 162      -0.790  11.494  15.862  1.00 37.48           C  
ATOM   2617  CZ  PHE B 162       0.260  11.020  16.652  1.00 36.67           C  
ATOM   2618  N   GLN B 163      -5.380  12.670  20.668  1.00 42.20           N  
ATOM   2619  CA  GLN B 163      -6.292  13.409  21.543  1.00 43.91           C  
ATOM   2620  C   GLN B 163      -6.025  14.926  21.548  1.00 41.77           C  
ATOM   2621  O   GLN B 163      -6.960  15.735  21.554  1.00 43.50           O  
ATOM   2622  CB  GLN B 163      -6.239  12.859  22.948  1.00 44.95           C  
ATOM   2623  CG  GLN B 163      -7.501  13.136  23.737  1.00 52.58           C  
ATOM   2624  CD  GLN B 163      -8.653  12.190  23.384  1.00 62.52           C  
ATOM   2625  OE1 GLN B 163      -9.781  12.637  23.117  1.00 68.25           O  
ATOM   2626  NE2 GLN B 163      -8.381  10.874  23.403  1.00 63.74           N  
ATOM   2627  N   ASN B 164      -4.755  15.314  21.501  1.00 37.65           N  
ATOM   2628  CA  ASN B 164      -4.430  16.725  21.622  1.00 36.62           C  
ATOM   2629  C   ASN B 164      -3.379  17.077  20.634  1.00 34.91           C  
ATOM   2630  O   ASN B 164      -2.449  16.305  20.453  1.00 33.59           O  
ATOM   2631  CB  ASN B 164      -3.942  17.030  23.029  1.00 35.27           C  
ATOM   2632  CG  ASN B 164      -5.009  16.751  24.071  1.00 40.78           C  
ATOM   2633  OD1 ASN B 164      -5.025  15.686  24.692  1.00 45.78           O  
ATOM   2634  ND2 ASN B 164      -5.954  17.651  24.192  1.00 41.91           N  
ATOM   2635  N   VAL B 165      -3.547  18.235  19.999  1.00 35.70           N  
ATOM   2636  CA  VAL B 165      -2.578  18.779  19.020  1.00 34.47           C  
ATOM   2637  C   VAL B 165      -2.301  20.256  19.345  1.00 35.10           C  
ATOM   2638  O   VAL B 165      -3.232  21.057  19.456  1.00 39.07           O  
ATOM   2639  CB  VAL B 165      -3.126  18.668  17.589  1.00 37.52           C  
ATOM   2640  CG1 VAL B 165      -2.076  19.149  16.586  1.00 35.06           C  
ATOM   2641  CG2 VAL B 165      -3.534  17.226  17.263  1.00 37.30           C  
ATOM   2642  N   ARG B 166      -1.022  20.603  19.490  1.00 33.21           N  
ATOM   2643  CA  ARG B 166      -0.573  21.952  19.808  1.00 32.73           C  
ATOM   2644  C   ARG B 166       0.236  22.482  18.617  1.00 35.47           C  
ATOM   2645  O   ARG B 166       0.881  21.713  17.946  1.00 34.49           O  
ATOM   2646  CB  ARG B 166       0.302  21.918  21.045  1.00 32.18           C  
ATOM   2647  CG  ARG B 166      -0.549  21.806  22.363  1.00 33.75           C  
ATOM   2648  CD  ARG B 166       0.298  21.659  23.601  1.00 32.43           C  
ATOM   2649  NE  ARG B 166      -0.499  21.845  24.825  1.00 33.48           N  
ATOM   2650  CZ  ARG B 166      -1.244  20.896  25.367  1.00 34.01           C  
ATOM   2651  NH1 ARG B 166      -1.901  21.138  26.458  1.00 40.02           N  
ATOM   2652  NH2 ARG B 166      -1.310  19.677  24.765  1.00 34.56           N  
ATOM   2653  N   ILE B 167       0.183  23.804  18.402  1.00 38.38           N  
ATOM   2654  CA  ILE B 167       1.042  24.466  17.441  1.00 40.82           C  
ATOM   2655  C   ILE B 167       2.061  25.311  18.200  1.00 41.89           C  
ATOM   2656  O   ILE B 167       1.690  26.218  18.990  1.00 44.29           O  
ATOM   2657  CB  ILE B 167       0.218  25.332  16.460  1.00 43.85           C  
ATOM   2658  CG1 ILE B 167      -0.824  24.462  15.745  1.00 44.27           C  
ATOM   2659  CG2 ILE B 167       1.121  25.922  15.427  1.00 43.56           C  
ATOM   2660  CD1 ILE B 167      -1.844  25.249  14.911  1.00 48.86           C  
ATOM   2661  N   ILE B 168       3.337  25.015  17.998  1.00 39.66           N  
ATOM   2662  CA  ILE B 168       4.411  25.750  18.672  1.00 42.29           C  
ATOM   2663  C   ILE B 168       5.229  26.650  17.702  1.00 44.06           C  
ATOM   2664  O   ILE B 168       5.640  26.198  16.627  1.00 41.20           O  
ATOM   2665  CB  ILE B 168       5.361  24.754  19.405  1.00 41.32           C  
ATOM   2666  CG1 ILE B 168       4.554  23.820  20.326  1.00 42.57           C  
ATOM   2667  CG2 ILE B 168       6.436  25.506  20.182  1.00 44.49           C  
ATOM   2668  CD1 ILE B 168       5.307  22.559  20.756  1.00 40.29           C  
ATOM   2669  N   LYS B 169       5.456  27.918  18.088  1.00 48.26           N  
ATOM   2670  CA  LYS B 169       6.283  28.850  17.287  1.00 52.41           C  
ATOM   2671  C   LYS B 169       7.652  29.068  17.928  1.00 55.49           C  
ATOM   2672  O   LYS B 169       8.570  28.254  17.738  1.00 56.00           O  
ATOM   2673  CB  LYS B 169       5.578  30.199  17.102  1.00 54.97           C  
ATOM   2674  N   SER B 177      14.698  32.217  13.001  1.00 88.06           N  
ATOM   2675  CA  SER B 177      13.929  31.008  12.713  1.00 82.50           C  
ATOM   2676  C   SER B 177      12.430  31.296  12.522  1.00 79.25           C  
ATOM   2677  O   SER B 177      11.883  32.248  13.110  1.00 80.17           O  
ATOM   2678  CB  SER B 177      14.130  29.967  13.823  1.00 79.79           C  
ATOM   2679  OG  SER B 177      15.476  29.509  13.857  1.00 83.10           O  
ATOM   2680  N   SER B 178      11.792  30.487  11.669  1.00 75.33           N  
ATOM   2681  CA  SER B 178      10.342  30.543  11.434  1.00 71.76           C  
ATOM   2682  C   SER B 178       9.807  29.141  11.122  1.00 66.45           C  
ATOM   2683  O   SER B 178       8.948  28.935  10.243  1.00 65.52           O  
ATOM   2684  CB  SER B 178       9.983  31.537  10.325  1.00 75.07           C  
ATOM   2685  OG  SER B 178       9.988  32.883  10.804  1.00 79.26           O  
ATOM   2686  N   GLU B 179      10.331  28.176  11.857  1.00 63.17           N  
ATOM   2687  CA  GLU B 179       9.704  26.899  11.961  1.00 57.31           C  
ATOM   2688  C   GLU B 179       8.411  27.018  12.779  1.00 53.22           C  
ATOM   2689  O   GLU B 179       8.197  27.983  13.513  1.00 53.67           O  
ATOM   2690  CB  GLU B 179      10.637  25.871  12.616  1.00 57.17           C  
ATOM   2691  CG  GLU B 179      11.864  26.445  13.316  1.00 61.58           C  
ATOM   2692  CD  GLU B 179      13.149  26.046  12.623  1.00 67.94           C  
ATOM   2693  OE1 GLU B 179      14.033  26.922  12.424  1.00 72.90           O  
ATOM   2694  OE2 GLU B 179      13.269  24.853  12.258  1.00 69.00           O  
ATOM   2695  N   VAL B 180       7.549  26.043  12.583  1.00 47.72           N  
ATOM   2696  CA  VAL B 180       6.369  25.830  13.391  1.00 43.09           C  
ATOM   2697  C   VAL B 180       6.421  24.349  13.664  1.00 39.43           C  
ATOM   2698  O   VAL B 180       6.760  23.592  12.759  1.00 37.61           O  
ATOM   2699  CB  VAL B 180       5.094  26.169  12.566  1.00 44.05           C  
ATOM   2700  CG1 VAL B 180       3.845  25.919  13.380  1.00 42.54           C  
ATOM   2701  CG2 VAL B 180       5.143  27.625  12.055  1.00 48.00           C  
ATOM   2702  N   TYR B 181       6.193  23.923  14.918  1.00 36.39           N  
ATOM   2703  CA  TYR B 181       6.130  22.507  15.214  1.00 35.48           C  
ATOM   2704  C   TYR B 181       4.725  22.156  15.525  1.00 34.53           C  
ATOM   2705  O   TYR B 181       4.025  22.939  16.187  1.00 34.61           O  
ATOM   2706  CB  TYR B 181       6.969  22.153  16.455  1.00 35.63           C  
ATOM   2707  CG  TYR B 181       8.372  22.599  16.347  1.00 40.55           C  
ATOM   2708  CD1 TYR B 181       9.301  21.839  15.649  1.00 42.31           C  
ATOM   2709  CD2 TYR B 181       8.771  23.819  16.866  1.00 47.41           C  
ATOM   2710  CE1 TYR B 181      10.600  22.253  15.504  1.00 47.65           C  
ATOM   2711  CE2 TYR B 181      10.080  24.239  16.743  1.00 50.01           C  
ATOM   2712  CZ  TYR B 181      10.985  23.444  16.053  1.00 48.65           C  
ATOM   2713  OH  TYR B 181      12.267  23.835  15.944  1.00 51.35           O  
ATOM   2714  N   PHE B 182       4.308  20.964  15.109  1.00 33.03           N  
ATOM   2715  CA  PHE B 182       3.087  20.370  15.663  1.00 31.45           C  
ATOM   2716  C   PHE B 182       3.474  19.367  16.738  1.00 30.77           C  
ATOM   2717  O   PHE B 182       4.373  18.518  16.548  1.00 31.19           O  
ATOM   2718  CB  PHE B 182       2.269  19.658  14.587  1.00 33.25           C  
ATOM   2719  CG  PHE B 182       1.605  20.593  13.591  1.00 37.99           C  
ATOM   2720  CD1 PHE B 182       1.137  21.837  13.985  1.00 43.12           C  
ATOM   2721  CD2 PHE B 182       1.408  20.196  12.262  1.00 44.97           C  
ATOM   2722  CE1 PHE B 182       0.519  22.724  13.032  1.00 46.71           C  
ATOM   2723  CE2 PHE B 182       0.764  21.070  11.305  1.00 45.66           C  
ATOM   2724  CZ  PHE B 182       0.347  22.327  11.703  1.00 44.92           C  
ATOM   2725  N   LEU B 183       2.793  19.457  17.871  1.00 30.53           N  
ATOM   2726  CA  LEU B 183       3.035  18.559  18.975  1.00 29.60           C  
ATOM   2727  C   LEU B 183       1.740  17.824  19.287  1.00 30.85           C  
ATOM   2728  O   LEU B 183       0.790  18.419  19.751  1.00 32.27           O  
ATOM   2729  CB  LEU B 183       3.521  19.339  20.205  1.00 30.48           C  
ATOM   2730  CG  LEU B 183       3.548  18.470  21.487  1.00 30.02           C  
ATOM   2731  CD1 LEU B 183       4.537  17.310  21.380  1.00 28.30           C  
ATOM   2732  CD2 LEU B 183       3.944  19.315  22.647  1.00 26.19           C  
ATOM   2733  N   ALA B 184       1.692  16.533  18.943  1.00 30.11           N  
ATOM   2734  CA  ALA B 184       0.473  15.751  19.073  1.00 31.22           C  
ATOM   2735  C   ALA B 184       0.676  14.733  20.157  1.00 30.60           C  
ATOM   2736  O   ALA B 184       1.702  14.109  20.231  1.00 30.69           O  
ATOM   2737  CB  ALA B 184       0.115  15.060  17.688  1.00 32.78           C  
ATOM   2738  N   THR B 185      -0.280  14.621  21.080  1.00 32.63           N  
ATOM   2739  CA  THR B 185      -0.049  13.750  22.238  1.00 30.68           C  
ATOM   2740  C   THR B 185      -1.256  12.863  22.433  1.00 33.42           C  
ATOM   2741  O   THR B 185      -2.366  13.195  21.986  1.00 34.53           O  
ATOM   2742  CB  THR B 185       0.201  14.571  23.559  1.00 33.09           C  
ATOM   2743  OG1 THR B 185      -0.823  15.569  23.680  1.00 33.61           O  
ATOM   2744  CG2 THR B 185       1.610  15.250  23.520  1.00 30.48           C  
ATOM   2745  N   GLN B 186      -1.047  11.718  23.069  0.38 33.43           N  
ATOM   2747  CA  GLN B 186      -2.133  10.757  23.311  0.38 35.79           C  
ATOM   2749  C   GLN B 186      -2.648  10.160  21.994  0.38 36.44           C  
ATOM   2751  O   GLN B 186      -3.830  10.296  21.656  0.38 37.60           O  
ATOM   2753  CB  GLN B 186      -3.270  11.420  24.096  0.38 36.76           C  
ATOM   2755  CG  GLN B 186      -2.794  12.269  25.271  0.38 35.66           C  
ATOM   2757  CD  GLN B 186      -3.863  12.472  26.301  0.38 37.24           C  
ATOM   2759  OE1 GLN B 186      -4.239  11.540  27.019  0.38 37.10           O  
ATOM   2761  NE2 GLN B 186      -4.366  13.692  26.395  0.38 36.80           N  
ATOM   2763  N   TYR B 187      -1.732   9.555  21.232  1.00 36.05           N  
ATOM   2764  CA  TYR B 187      -2.087   8.834  19.987  1.00 36.81           C  
ATOM   2765  C   TYR B 187      -3.213   7.807  20.207  1.00 41.11           C  
ATOM   2766  O   TYR B 187      -3.136   7.025  21.125  1.00 40.19           O  
ATOM   2767  CB  TYR B 187      -0.818   8.120  19.460  1.00 37.56           C  
ATOM   2768  CG  TYR B 187      -0.993   7.483  18.110  1.00 38.47           C  
ATOM   2769  CD1 TYR B 187      -0.580   6.160  17.866  1.00 38.32           C  
ATOM   2770  CD2 TYR B 187      -1.553   8.207  17.045  1.00 42.30           C  
ATOM   2771  CE1 TYR B 187      -0.742   5.567  16.594  1.00 41.81           C  
ATOM   2772  CE2 TYR B 187      -1.723   7.621  15.774  1.00 42.71           C  
ATOM   2773  CZ  TYR B 187      -1.309   6.313  15.561  1.00 42.92           C  
ATOM   2774  OH  TYR B 187      -1.492   5.755  14.323  1.00 49.20           O  
ATOM   2775  N   HIS B 188      -4.251   7.824  19.366  1.00 43.62           N  
ATOM   2776  CA  HIS B 188      -5.432   6.939  19.588  1.00 49.19           C  
ATOM   2777  C   HIS B 188      -5.039   5.470  19.332  1.00 51.67           C  
ATOM   2778  O   HIS B 188      -5.353   4.598  20.121  1.00 55.32           O  
ATOM   2779  CB  HIS B 188      -6.631   7.348  18.723  1.00 51.58           C  
ATOM   2780  CG  HIS B 188      -7.252   8.653  19.120  1.00 53.98           C  
ATOM   2781  ND1 HIS B 188      -7.604   9.622  18.200  1.00 56.52           N  
ATOM   2782  CD2 HIS B 188      -7.566   9.159  20.335  1.00 52.46           C  
ATOM   2783  CE1 HIS B 188      -8.139  10.653  18.831  1.00 53.95           C  
ATOM   2784  NE2 HIS B 188      -8.116  10.402  20.126  1.00 54.46           N  
ATOM   2785  N   GLY B 189      -4.328   5.208  18.253  1.00 51.64           N  
ATOM   2786  CA  GLY B 189      -4.202   6.115  17.126  1.00 51.37           C  
ATOM   2787  C   GLY B 189      -4.725   5.383  15.903  1.00 54.97           C  
ATOM   2788  O   GLY B 189      -5.615   4.541  16.039  1.00 59.39           O  
TER    2789      GLY B 189                                                      
END
MOLECULE T0508.pdb
ATOM      1  N   GLN    17      27.341  18.956  20.266  1.00 28.55           N  
ATOM      2  CA  GLN    17      26.133  19.476  19.544  1.00 26.35           C  
ATOM      3  C   GLN    17      25.067  19.993  20.513  1.00 30.77           C  
ATOM      4  O   GLN    17      24.034  20.543  20.088  1.00 24.08           O  
ATOM      5  CB  GLN    17      25.542  18.382  18.646  1.00 27.54           C  
ATOM      6  CG  GLN    17      26.434  17.946  17.479  1.00 28.33           C  
ATOM      7  CD  GLN    17      26.586  19.019  16.411  1.00 35.79           C  
ATOM      8  OE1 GLN    17      25.718  19.891  16.241  1.00 34.30           O  
ATOM      9  NE2 GLN    17      27.692  18.953  15.672  1.00 38.09           N  
ATOM     10  N   LEU    18      25.329  19.819  21.814  1.00 31.52           N  
ATOM     11  CA  LEU    18      24.433  20.242  22.907  1.00 36.19           C  
ATOM     12  C   LEU    18      24.053  21.718  22.876  1.00 37.06           C  
ATOM     13  O   LEU    18      23.038  22.126  23.448  1.00 36.28           O  
ATOM     14  CB  LEU    18      25.085  19.950  24.263  1.00 40.29           C  
ATOM     15  CG  LEU    18      25.116  18.500  24.733  1.00 40.46           C  
ATOM     16  CD1 LEU    18      25.963  18.381  25.991  1.00 45.09           C  
ATOM     17  CD2 LEU    18      23.700  18.005  24.965  1.00 39.67           C  
ATOM     18  N   ARG    19      24.888  22.495  22.199  1.00 35.74           N  
ATOM     19  CA  ARG    19      24.812  23.945  22.161  1.00 37.88           C  
ATOM     20  C   ARG    19      24.334  24.487  20.806  1.00 29.39           C  
ATOM     21  O   ARG    19      24.321  25.705  20.601  1.00 29.87           O  
ATOM     22  CB  ARG    19      26.205  24.493  22.466  1.00 42.33           C  
ATOM     23  CG  ARG    19      27.341  23.712  21.765  1.00 53.58           C  
ATOM     24  CD  ARG    19      27.752  24.332  20.429  1.00 61.77           C  
ATOM     25  NE  ARG    19      28.576  23.428  19.629  1.00 75.01           N  
ATOM     26  CZ  ARG    19      28.165  22.800  18.529  1.00 80.38           C  
ATOM     27  NH1 ARG    19      26.931  22.978  18.067  1.00 80.36           N  
ATOM     28  NH2 ARG    19      28.996  21.994  17.880  1.00 82.30           N  
ATOM     29  N   SER    20      23.992  23.591  19.877  1.00 22.34           N  
ATOM     30  CA  SER    20      23.537  23.996  18.549  1.00 20.35           C  
ATOM     31  C   SER    20      22.175  24.689  18.593  1.00 18.47           C  
ATOM     32  O   SER    20      21.426  24.558  19.561  1.00 18.01           O  
ATOM     33  CB  SER    20      23.472  22.799  17.611  1.00 22.60           C  
ATOM     34  OG  SER    20      22.316  22.019  17.885  1.00 20.95           O  
ATOM     35  N   ARG    21      21.846  25.410  17.528  1.00 18.65           N  
ATOM     36  CA  ARG    21      20.566  26.116  17.455  1.00 19.51           C  
ATOM     37  C   ARG    21      19.421  25.111  17.556  1.00 17.07           C  
ATOM     38  O   ARG    21      18.440  25.343  18.268  1.00 19.73           O  
ATOM     39  CB  ARG    21      20.473  26.874  16.130  1.00 23.77           C  
ATOM     40  CG  ARG    21      19.192  27.666  15.945  1.00 31.80           C  
ATOM     41  CD  ARG    21      19.340  28.620  14.778  1.00 45.60           C  
ATOM     42  NE  ARG    21      18.350  29.692  14.818  1.00 57.03           N  
ATOM     43  CZ  ARG    21      18.418  30.803  14.089  1.00 65.61           C  
ATOM     44  NH1 ARG    21      19.437  30.999  13.257  1.00 66.62           N  
ATOM     45  NH2 ARG    21      17.468  31.723  14.194  1.00 68.54           N  
ATOM     46  N   ALA    22      19.578  23.995  16.850  1.00 17.83           N  
ATOM     47  CA  ALA    22      18.573  22.948  16.851  1.00 15.55           C  
ATOM     48  C   ALA    22      18.381  22.371  18.258  1.00 16.33           C  
ATOM     49  O   ALA    22      17.249  22.202  18.720  1.00 17.50           O  
ATOM     50  CB  ALA    22      18.933  21.869  15.862  1.00 19.42           C  
ATOM     51  N   ALA    23      19.481  22.100  18.964  1.00 16.59           N  
ATOM     52  CA  ALA    23      19.386  21.661  20.362  1.00 15.10           C  
ATOM     53  C   ALA    23      18.604  22.656  21.238  1.00 16.51           C  
ATOM     54  O   ALA    23      17.775  22.244  22.038  1.00 15.64           O  
ATOM     55  CB  ALA    23      20.787  21.427  20.948  1.00 15.49           C  
ATOM     56  N   PHE    24      18.867  23.967  21.093  1.00 15.01           N  
ATOM     57  CA  PHE    24      18.139  24.958  21.887  1.00 20.00           C  
ATOM     58  C   PHE    24      16.644  24.967  21.591  1.00 14.73           C  
ATOM     59  O   PHE    24      15.815  25.130  22.508  1.00 18.39           O  
ATOM     60  CB  PHE    24      18.733  26.367  21.714  1.00 25.77           C  
ATOM     61  CG  PHE    24      19.868  26.656  22.659  1.00 37.19           C  
ATOM     62  CD1 PHE    24      19.615  27.052  23.971  1.00 47.97           C  
ATOM     63  CD2 PHE    24      21.193  26.508  22.245  1.00 46.26           C  
ATOM     64  CE1 PHE    24      20.666  27.309  24.857  1.00 54.49           C  
ATOM     65  CE2 PHE    24      22.251  26.764  23.120  1.00 49.16           C  
ATOM     66  CZ  PHE    24      21.989  27.165  24.428  1.00 48.58           C  
ATOM     67  N   LYS    25      16.301  24.766  20.314  1.00 15.96           N  
ATOM     68  CA  LYS    25      14.893  24.667  19.907  1.00 15.07           C  
ATOM     69  C   LYS    25      14.239  23.492  20.622  1.00 14.67           C  
ATOM     70  O   LYS    25      13.147  23.626  21.185  1.00 14.53           O  
ATOM     71  CB  LYS    25      14.751  24.520  18.391  1.00 16.88           C  
ATOM     72  CG  LYS    25      15.042  25.803  17.590  1.00 24.44           C  
ATOM     73  CD  LYS    25      14.706  25.620  16.105  1.00 27.14           C  
ATOM     74  CE  LYS    25      15.959  25.479  15.249  1.00 35.96           C  
ATOM     75  NZ  LYS    25      15.649  25.049  13.851  1.00 38.22           N  
ATOM     76  N   LEU    26      14.912  22.340  20.648  1.00 13.44           N  
ATOM     77  CA  LEU    26      14.307  21.207  21.341  1.00 12.47           C  
ATOM     78  C   LEU    26      14.186  21.435  22.842  1.00 12.58           C  
ATOM     79  O   LEU    26      13.165  21.067  23.427  1.00 13.35           O  
ATOM     80  CB  LEU    26      15.051  19.889  21.058  1.00 14.07           C  
ATOM     81  CG  LEU    26      14.419  18.650  21.686  1.00 12.73           C  
ATOM     82  CD1 LEU    26      13.020  18.452  21.173  1.00 13.01           C  
ATOM     83  CD2 LEU    26      15.264  17.428  21.366  1.00 13.66           C  
ATOM     84  N   GLU    27      15.197  22.047  23.463  1.00 14.16           N  
ATOM     85  CA  GLU    27      15.124  22.335  24.902  1.00 15.27           C  
ATOM     86  C   GLU    27      13.907  23.219  25.231  1.00 12.64           C  
ATOM     87  O   GLU    27      13.205  22.990  26.204  1.00 14.02           O  
ATOM     88  CB  GLU    27      16.428  22.989  25.382  1.00 16.28           C  
ATOM     89  CG  GLU    27      17.600  21.998  25.485  1.00 27.56           C  
ATOM     90  CD  GLU    27      18.915  22.632  25.940  1.00 38.21           C  
ATOM     91  OE1 GLU    27      19.405  23.577  25.272  1.00 49.67           O  
ATOM     92  OE2 GLU    27      19.469  22.163  26.960  1.00 51.34           O  
ATOM     93  N   PHE    28      13.670  24.214  24.380  1.00 14.06           N  
ATOM     94  CA  PHE    28      12.541  25.133  24.517  1.00 12.72           C  
ATOM     95  C   PHE    28      11.221  24.373  24.460  1.00 13.27           C  
ATOM     96  O   PHE    28      10.360  24.568  25.306  1.00 13.48           O  
ATOM     97  CB  PHE    28      12.682  26.168  23.405  1.00 13.96           C  
ATOM     98  CG  PHE    28      11.502  27.087  23.215  1.00 14.57           C  
ATOM     99  CD1 PHE    28      11.408  28.290  23.917  1.00 19.84           C  
ATOM    100  CD2 PHE    28      10.536  26.793  22.258  1.00 17.11           C  
ATOM    101  CE1 PHE    28      10.346  29.167  23.677  1.00 17.75           C  
ATOM    102  CE2 PHE    28       9.457  27.663  22.024  1.00 16.94           C  
ATOM    103  CZ  PHE    28       9.381  28.850  22.735  1.00 20.66           C  
ATOM    104  N   LEU    29      11.108  23.480  23.476  1.00 13.95           N  
ATOM    105  CA  LEU    29       9.905  22.672  23.317  1.00 11.98           C  
ATOM    106  C   LEU    29       9.685  21.692  24.466  1.00 12.60           C  
ATOM    107  O   LEU    29       8.537  21.496  24.882  1.00 13.48           O  
ATOM    108  CB  LEU    29       9.940  21.899  21.982  1.00 13.29           C  
ATOM    109  CG  LEU    29       9.955  22.790  20.727  1.00 13.34           C  
ATOM    110  CD1 LEU    29      10.381  21.990  19.476  1.00 14.82           C  
ATOM    111  CD2 LEU    29       8.600  23.481  20.463  1.00 14.32           C  
ATOM    112  N   LEU    30      10.753  21.064  24.967  1.00 10.58           N  
ATOM    113  CA  LEU    30      10.602  20.155  26.121  1.00 12.83           C  
ATOM    114  C   LEU    30      10.172  20.920  27.372  1.00 12.29           C  
ATOM    115  O   LEU    30       9.300  20.465  28.111  1.00 14.05           O  
ATOM    116  CB  LEU    30      11.895  19.370  26.400  1.00 15.66           C  
ATOM    117  CG  LEU    30      12.359  18.479  25.258  1.00 16.16           C  
ATOM    118  CD1 LEU    30      13.759  17.903  25.567  1.00 17.08           C  
ATOM    119  CD2 LEU    30      11.320  17.389  24.963  1.00 19.76           C  
ATOM    120  N   ASP    31      10.738  22.115  27.577  1.00 13.31           N  
ATOM    121  CA  ASP    31      10.380  22.953  28.748  1.00 12.70           C  
ATOM    122  C   ASP    31       8.916  23.346  28.710  1.00 13.57           C  
ATOM    123  O   ASP    31       8.207  23.347  29.728  1.00 13.47           O  
ATOM    124  CB  ASP    31      11.213  24.239  28.773  1.00 16.51           C  
ATOM    125  CG  ASP    31      12.593  24.044  29.368  1.00 23.03           C  
ATOM    126  OD1 ASP    31      12.832  23.035  30.067  1.00 27.41           O  
ATOM    127  OD2 ASP    31      13.448  24.930  29.141  1.00 27.84           O  
ATOM    128  N   ARG    32       8.452  23.717  27.535  1.00 12.67           N  
ATOM    129  CA  ARG    32       7.103  24.226  27.393  1.00 12.84           C  
ATOM    130  C   ARG    32       6.040  23.146  27.326  1.00 13.39           C  
ATOM    131  O   ARG    32       4.932  23.349  27.808  1.00 13.37           O  
ATOM    132  CB  ARG    32       7.000  25.023  26.116  1.00 12.72           C  
ATOM    133  CG  ARG    32       7.559  26.433  26.139  1.00 14.78           C  
ATOM    134  CD  ARG    32       7.075  27.174  24.878  1.00 14.18           C  
ATOM    135  NE  ARG    32       7.107  28.621  25.069  1.00 18.87           N  
ATOM    136  CZ  ARG    32       6.487  29.493  24.283  1.00 19.83           C  
ATOM    137  NH1 ARG    32       6.604  30.782  24.540  1.00 27.51           N  
ATOM    138  NH2 ARG    32       5.760  29.077  23.246  1.00 19.18           N  
ATOM    139  N   TYR    33       6.361  22.031  26.665  1.00 10.84           N  
ATOM    140  CA  TYR    33       5.349  21.039  26.290  1.00 11.98           C  
ATOM    141  C   TYR    33       5.577  19.599  26.760  1.00 12.64           C  
ATOM    142  O   TYR    33       4.688  18.759  26.572  1.00 13.17           O  
ATOM    143  CB  TYR    33       5.177  21.027  24.770  1.00 11.87           C  
ATOM    144  CG  TYR    33       4.950  22.401  24.210  1.00 12.45           C  
ATOM    145  CD1 TYR    33       3.748  23.065  24.432  1.00 12.73           C  
ATOM    146  CD2 TYR    33       5.941  23.052  23.490  1.00 11.65           C  
ATOM    147  CE1 TYR    33       3.525  24.350  23.915  1.00 13.75           C  
ATOM    148  CE2 TYR    33       5.720  24.343  22.958  1.00 13.97           C  
ATOM    149  CZ  TYR    33       4.524  24.980  23.189  1.00 14.82           C  
ATOM    150  OH  TYR    33       4.331  26.250  22.673  1.00 17.07           O  
ATOM    151  N   ARG    34       6.737  19.329  27.320  1.00 11.94           N  
ATOM    152  CA  ARG    34       7.075  17.987  27.885  0.50 12.60           C  
ATOM    154  C   ARG    34       6.752  16.863  26.836  1.00 15.29           C  
ATOM    155  O   ARG    34       6.265  15.838  27.180  1.00 16.34           O  
ATOM    156  CB  ARG    34       6.341  17.730  29.206  0.50 15.27           C  
ATOM    158  CG  ARG    34       6.715  18.721  30.308  0.50 18.80           C  
ATOM    160  CD  ARG    34       6.251  18.251  31.685  0.50 24.09           C  
ATOM    162  NE  ARG    34       7.080  17.171  32.217  0.50 29.99           N  
ATOM    164  CZ  ARG    34       6.723  15.887  32.260  0.50 35.77           C  
ATOM    166  NH1 ARG    34       7.554  14.986  32.768  0.50 30.23           N  
ATOM    168  NH2 ARG    34       5.538  15.495  31.800  0.50 39.31           N  
ATOM    170  N   VAL    35       7.093  17.136  25.601  1.00 14.33           N  
ATOM    171  CA  VAL    35       6.681  16.252  24.539  1.00 16.23           C  
ATOM    172  C   VAL    35       7.397  14.907  24.563  1.00 15.87           C  
ATOM    173  O   VAL    35       6.842  13.935  24.164  1.00 18.60           O  
ATOM    174  CB  VAL    35       6.614  16.981  23.155  1.00 20.79           C  
ATOM    175  CG1 VAL    35       7.901  17.453  22.753  1.00 19.27           C  
ATOM    176  CG2 VAL    35       5.962  16.095  22.079  1.00 22.03           C  
ATOM    177  N   VAL    36       8.620  14.904  25.063  1.00 14.69           N  
ATOM    178  CA  VAL    36       9.323  13.708  25.475  1.00 14.45           C  
ATOM    179  C   VAL    36       9.549  13.719  27.008  1.00 14.37           C  
ATOM    180  O   VAL    36       9.873  14.725  27.537  1.00 16.00           O  
ATOM    181  CB  VAL    36      10.688  13.600  24.695  1.00 15.76           C  
ATOM    182  CG1 VAL    36      11.501  12.407  25.134  1.00 14.06           C  
ATOM    183  CG2 VAL    36      10.462  13.571  23.222  1.00 13.18           C  
ATOM    184  N   ARG    37       9.328  12.593  27.672  1.00 13.64           N  
ATOM    185  CA  ARG    37       9.333  12.429  29.008  0.50 18.53           C  
ATOM    187  C   ARG    37      10.496  11.527  29.402  1.00 15.77           C  
ATOM    188  O   ARG    37      10.863  10.667  28.672  1.00 14.89           O  
ATOM    189  CB  ARG    37       7.994  11.913  29.555  0.50 20.65           C  
ATOM    191  CG  ARG    37       6.819  12.854  29.252  0.50 30.27           C  
ATOM    193  CD  ARG    37       5.434  12.185  29.360  0.50 33.11           C  
ATOM    195  NE  ARG    37       5.097  11.095  28.417  0.50 42.98           N  
ATOM    197  CZ  ARG    37       5.375  11.018  27.107  0.50 40.65           C  
ATOM    199  NH1 ARG    37       6.040  11.964  26.456  0.50 28.66           N  
ATOM    201  NH2 ARG    37       4.975   9.949  26.427  0.50 44.72           N  
ATOM    203  N   LYS    38      11.067  11.751  30.563  1.00 15.15           N  
ATOM    204  CA  LYS    38      12.094  10.917  31.115  1.00 13.26           C  
ATOM    205  C   LYS    38      11.741   9.422  31.039  1.00 14.54           C  
ATOM    206  O   LYS    38      10.728   9.042  31.504  1.00 15.92           O  
ATOM    207  CB  LYS    38      12.289  11.304  32.594  1.00 16.09           C  
ATOM    208  CG  LYS    38      13.380  10.611  33.234  1.00 22.87           C  
ATOM    209  CD  LYS    38      14.598  11.183  32.785  1.00 36.52           C  
ATOM    210  CE  LYS    38      15.770  10.611  33.427  1.00 45.52           C  
ATOM    211  NZ  LYS    38      16.989  11.533  33.326  1.00 52.07           N  
ATOM    212  N   GLY    39      12.616   8.645  30.434  1.00 14.73           N  
ATOM    213  CA  GLY    39      12.416   7.193  30.331  1.00 13.34           C  
ATOM    214  C   GLY    39      11.741   6.729  29.047  1.00 14.96           C  
ATOM    215  O   GLY    39      11.562   5.538  28.824  1.00 12.59           O  
ATOM    216  N   ASP    40      11.334   7.670  28.208  1.00 11.88           N  
ATOM    217  CA  ASP    40      10.695   7.357  26.933  1.00  9.89           C  
ATOM    218  C   ASP    40      11.656   6.706  25.958  1.00 10.44           C  
ATOM    219  O   ASP    40      12.871   6.965  25.986  1.00 11.68           O  
ATOM    220  CB  ASP    40      10.168   8.642  26.291  1.00  9.60           C  
ATOM    221  CG  ASP    40       8.825   9.075  26.855  1.00 15.15           C  
ATOM    222  OD1 ASP    40       8.300   8.390  27.768  1.00 15.94           O  
ATOM    223  OD2 ASP    40       8.287  10.116  26.398  1.00 13.89           O  
ATOM    224  N   ALA    41      11.087   5.869  25.081  1.00  9.23           N  
ATOM    225  CA  ALA    41      11.803   5.381  23.917  1.00 10.66           C  
ATOM    226  C   ALA    41      11.312   6.214  22.746  1.00 10.39           C  
ATOM    227  O   ALA    41      10.097   6.409  22.593  1.00 10.52           O  
ATOM    228  CB  ALA    41      11.509   3.893  23.655  1.00 11.78           C  
ATOM    229  N   VAL    42      12.251   6.703  21.934  1.00  9.29           N  
ATOM    230  CA  VAL    42      11.966   7.691  20.884  1.00  9.19           C  
ATOM    231  C   VAL    42      12.535   7.249  19.544  1.00  9.09           C  
ATOM    232  O   VAL    42      13.680   6.824  19.477  1.00 10.43           O  
ATOM    233  CB  VAL    42      12.634   9.041  21.259  1.00 10.87           C  
ATOM    234  CG1 VAL    42      12.350  10.120  20.216  1.00 10.02           C  
ATOM    235  CG2 VAL    42      12.159   9.507  22.641  1.00  9.93           C  
ATOM    236  N   ILE    43      11.714   7.336  18.489  1.00  9.23           N  
ATOM    237  CA  ILE    43      12.233   7.267  17.117  1.00  8.55           C  
ATOM    238  C   ILE    43      12.455   8.724  16.690  1.00  9.88           C  
ATOM    239  O   ILE    43      11.523   9.538  16.716  1.00 10.54           O  
ATOM    240  CB  ILE    43      11.247   6.608  16.168  1.00  9.68           C  
ATOM    241  CG1 ILE    43      11.134   5.117  16.514  1.00 11.32           C  
ATOM    242  CG2 ILE    43      11.709   6.781  14.705  1.00 13.11           C  
ATOM    243  CD1 ILE    43       9.953   4.437  15.835  1.00 12.08           C  
ATOM    244  N   GLU    44      13.695   9.056  16.345  1.00 10.06           N  
ATOM    245  CA  GLU    44      14.079  10.401  15.958  1.00 10.36           C  
ATOM    246  C   GLU    44      14.415  10.427  14.478  1.00 11.21           C  
ATOM    247  O   GLU    44      15.330   9.729  14.050  1.00 12.60           O  
ATOM    248  CB  GLU    44      15.301  10.844  16.764  1.00 11.21           C  
ATOM    249  CG  GLU    44      15.747  12.224  16.301  1.00 11.70           C  
ATOM    250  CD  GLU    44      17.120  12.636  16.766  1.00 13.48           C  
ATOM    251  OE1 GLU    44      17.897  11.771  17.255  1.00 15.29           O  
ATOM    252  OE2 GLU    44      17.420  13.836  16.601  1.00 17.75           O  
ATOM    253  N   ILE    45      13.664  11.191  13.701  1.00  9.39           N  
ATOM    254  CA  ILE    45      13.837  11.257  12.237  1.00  9.26           C  
ATOM    255  C   ILE    45      14.554  12.550  11.852  1.00 10.33           C  
ATOM    256  O   ILE    45      14.161  13.633  12.285  1.00 12.16           O  
ATOM    257  CB  ILE    45      12.486  11.132  11.523  1.00 10.48           C  
ATOM    258  CG1 ILE    45      11.919   9.730  11.811  1.00 14.98           C  
ATOM    259  CG2 ILE    45      12.642  11.353  10.015  1.00 13.76           C  
ATOM    260  CD1 ILE    45      10.461   9.557  11.499  1.00 20.21           C  
ATOM    261  N   GLY    46      15.643  12.439  11.084  1.00 11.67           N  
ATOM    262  CA  GLY    46      16.424  13.628  10.739  1.00 10.89           C  
ATOM    263  C   GLY    46      17.394  14.013  11.850  1.00 11.86           C  
ATOM    264  O   GLY    46      17.433  15.156  12.283  1.00 14.16           O  
ATOM    265  N   SER    47      18.192  13.047  12.287  1.00 14.11           N  
ATOM    266  CA  SER    47      19.016  13.223  13.476  1.00 13.31           C  
ATOM    267  C   SER    47      20.367  13.896  13.288  1.00 12.81           C  
ATOM    268  O   SER    47      20.932  14.398  14.248  1.00 14.54           O  
ATOM    269  CB  SER    47      19.277  11.857  14.108  1.00 11.08           C  
ATOM    270  OG  SER    47      19.928  10.995  13.176  1.00 14.23           O  
ATOM    271  N   SER    48      20.890  13.926  12.065  1.00 12.35           N  
ATOM    272  CA  SER    48      22.264  14.391  11.892  0.50 12.78           C  
ATOM    274  C   SER    48      22.363  15.908  11.904  1.00 12.43           C  
ATOM    275  O   SER    48      21.495  16.587  11.361  1.00 16.33           O  
ATOM    276  CB  SER    48      22.855  13.821  10.613  0.50 13.15           C  
ATOM    278  OG  SER    48      22.792  12.407  10.651  0.50 12.11           O  
ATOM    280  N   PRO    49      23.431  16.454  12.534  1.00 13.69           N  
ATOM    281  CA  PRO    49      24.584  15.838  13.196  1.00 14.45           C  
ATOM    282  C   PRO    49      24.402  15.350  14.622  1.00 15.17           C  
ATOM    283  O   PRO    49      25.297  14.696  15.125  1.00 18.41           O  
ATOM    284  CB  PRO    49      25.646  16.960  13.158  1.00 13.96           C  
ATOM    285  CG  PRO    49      24.828  18.216  13.270  1.00 16.02           C  
ATOM    286  CD  PRO    49      23.555  17.932  12.489  1.00 16.62           C  
ATOM    287  N   GLY    50      23.286  15.668  15.282  1.00 14.24           N  
ATOM    288  CA  GLY    50      23.063  15.082  16.608  1.00 11.34           C  
ATOM    289  C   GLY    50      22.701  16.000  17.754  1.00 13.31           C  
ATOM    290  O   GLY    50      22.751  15.585  18.900  1.00 13.91           O  
ATOM    291  N   GLY    51      22.342  17.254  17.466  1.00 12.78           N  
ATOM    292  CA  GLY    51      21.909  18.171  18.531  1.00 12.63           C  
ATOM    293  C   GLY    51      20.682  17.708  19.307  1.00 13.36           C  
ATOM    294  O   GLY    51      20.701  17.634  20.539  1.00 13.73           O  
ATOM    295  N   TRP    52      19.601  17.405  18.587  1.00 11.89           N  
ATOM    296  CA  TRP    52      18.441  16.839  19.275  1.00 11.79           C  
ATOM    297  C   TRP    52      18.798  15.531  19.953  1.00 11.80           C  
ATOM    298  O   TRP    52      18.345  15.262  21.057  1.00 13.79           O  
ATOM    299  CB  TRP    52      17.276  16.596  18.323  1.00 12.99           C  
ATOM    300  CG  TRP    52      16.480  17.814  17.965  1.00 13.11           C  
ATOM    301  CD1 TRP    52      16.894  19.126  17.985  1.00 11.58           C  
ATOM    302  CD2 TRP    52      15.125  17.829  17.523  1.00 12.99           C  
ATOM    303  NE1 TRP    52      15.878  19.948  17.579  1.00 13.19           N  
ATOM    304  CE2 TRP    52      14.777  19.177  17.287  1.00 13.10           C  
ATOM    305  CE3 TRP    52      14.164  16.825  17.299  1.00 13.89           C  
ATOM    306  CZ2 TRP    52      13.496  19.554  16.851  1.00 12.31           C  
ATOM    307  CZ3 TRP    52      12.906  17.193  16.854  1.00 14.51           C  
ATOM    308  CH2 TRP    52      12.586  18.547  16.632  1.00 12.23           C  
ATOM    309  N   THR    53      19.602  14.703  19.281  1.00 11.88           N  
ATOM    310  CA  THR    53      19.935  13.386  19.848  1.00 13.53           C  
ATOM    311  C   THR    53      20.637  13.514  21.192  1.00 11.78           C  
ATOM    312  O   THR    53      20.307  12.798  22.142  1.00 15.17           O  
ATOM    313  CB  THR    53      20.836  12.558  18.891  1.00 13.39           C  
ATOM    314  OG1 THR    53      20.362  12.667  17.548  1.00 15.73           O  
ATOM    315  CG2 THR    53      20.864  11.092  19.305  1.00 15.16           C  
ATOM    316  N   GLN    54      21.570  14.460  21.279  1.00 13.11           N  
ATOM    317  CA  GLN    54      22.293  14.685  22.521  1.00 14.80           C  
ATOM    318  C   GLN    54      21.366  15.235  23.616  1.00 14.98           C  
ATOM    319  O   GLN    54      21.513  14.867  24.783  1.00 17.30           O  
ATOM    320  CB  GLN    54      23.494  15.605  22.274  1.00 15.90           C  
ATOM    321  CG  GLN    54      24.615  14.902  21.537  1.00 17.43           C  
ATOM    322  CD  GLN    54      25.871  15.739  21.359  1.00 23.10           C  
ATOM    323  OE1 GLN    54      26.032  16.792  21.966  1.00 27.50           O  
ATOM    324  NE2 GLN    54      26.777  15.252  20.521  1.00 36.12           N  
ATOM    325  N   VAL    55      20.407  16.085  23.253  1.00 13.38           N  
ATOM    326  CA  VAL    55      19.436  16.577  24.224  1.00 13.23           C  
ATOM    327  C   VAL    55      18.549  15.413  24.682  1.00 16.58           C  
ATOM    328  O   VAL    55      18.325  15.241  25.881  1.00 19.21           O  
ATOM    329  CB  VAL    55      18.568  17.734  23.646  1.00 14.91           C  
ATOM    330  CG1 VAL    55      17.342  18.049  24.540  1.00 15.77           C  
ATOM    331  CG2 VAL    55      19.428  18.996  23.464  1.00 18.22           C  
ATOM    332  N   LEU    56      18.064  14.627  23.718  1.00 13.47           N  
ATOM    333  CA  LEU    56      17.193  13.485  24.034  1.00 16.57           C  
ATOM    334  C   LEU    56      17.903  12.413  24.853  1.00 14.44           C  
ATOM    335  O   LEU    56      17.277  11.761  25.667  1.00 13.36           O  
ATOM    336  CB  LEU    56      16.608  12.859  22.769  1.00 14.57           C  
ATOM    337  CG  LEU    56      15.627  13.647  21.890  1.00 16.91           C  
ATOM    338  CD1 LEU    56      15.467  12.948  20.538  1.00 18.51           C  
ATOM    339  CD2 LEU    56      14.279  13.842  22.594  1.00 24.21           C  
ATOM    340  N   ASN    57      19.208  12.243  24.651  1.00 16.18           N  
ATOM    341  CA  ASN    57      19.983  11.196  25.321  1.00 15.31           C  
ATOM    342  C   ASN    57      20.077  11.415  26.823  1.00 21.90           C  
ATOM    343  O   ASN    57      20.399  10.493  27.563  1.00 25.60           O  
ATOM    344  CB  ASN    57      21.370  11.128  24.689  1.00 17.13           C  
ATOM    345  CG  ASN    57      22.121   9.851  25.011  1.00 20.72           C  
ATOM    346  OD1 ASN    57      23.343   9.875  25.184  1.00 24.28           O  
ATOM    347  ND2 ASN    57      21.411   8.736  25.084  1.00 17.68           N  
ATOM    348  N   SER    58      19.746  12.635  27.241  1.00 20.84           N  
ATOM    349  CA  SER    58      19.785  13.036  28.646  0.50 22.94           C  
ATOM    351  C   SER    58      18.504  12.628  29.365  1.00 23.93           C  
ATOM    352  O   SER    58      18.425  12.706  30.598  1.00 27.24           O  
ATOM    353  CB  SER    58      20.006  14.557  28.772  0.50 25.02           C  
ATOM    355  OG  SER    58      18.881  15.303  28.321  0.50 21.84           O  
ATOM    357  N   LEU    59      17.512  12.169  28.595  1.00 15.23           N  
ATOM    358  CA  LEU    59      16.141  12.000  29.080  1.00 14.65           C  
ATOM    359  C   LEU    59      15.541  10.635  28.673  1.00 14.87           C  
ATOM    360  O   LEU    59      14.897   9.940  29.474  1.00 15.65           O  
ATOM    361  CB  LEU    59      15.324  13.132  28.429  1.00 25.84           C  
ATOM    362  CG  LEU    59      13.879  13.493  28.741  1.00 25.18           C  
ATOM    363  CD1 LEU    59      13.803  14.181  30.089  1.00 29.94           C  
ATOM    364  CD2 LEU    59      13.301  14.413  27.667  1.00 26.06           C  
ATOM    365  N   ALA    60      15.735  10.265  27.407  1.00 13.09           N  
ATOM    366  CA  ALA    60      15.152   9.037  26.874  1.00 13.19           C  
ATOM    367  C   ALA    60      15.880   7.798  27.391  1.00 12.67           C  
ATOM    368  O   ALA    60      17.097   7.835  27.650  1.00 12.83           O  
ATOM    369  CB  ALA    60      15.211   9.067  25.359  1.00 11.38           C  
ATOM    370  N   ARG    61      15.153   6.674  27.513  1.00 12.32           N  
ATOM    371  CA  ARG    61      15.834   5.402  27.814  1.00 11.46           C  
ATOM    372  C   ARG    61      16.487   4.775  26.579  1.00 10.52           C  
ATOM    373  O   ARG    61      17.451   4.018  26.691  1.00 13.25           O  
ATOM    374  CB  ARG    61      14.887   4.389  28.488  1.00 10.24           C  
ATOM    375  CG  ARG    61      13.912   3.659  27.577  1.00 13.10           C  
ATOM    376  CD  ARG    61      13.040   2.670  28.379  1.00 13.71           C  
ATOM    377  NE  ARG    61      12.274   1.828  27.468  1.00 12.52           N  
ATOM    378  CZ  ARG    61      11.148   2.200  26.863  1.00 10.75           C  
ATOM    379  NH1 ARG    61      10.592   3.392  27.102  1.00 11.33           N  
ATOM    380  NH2 ARG    61      10.528   1.359  26.026  1.00 12.41           N  
ATOM    381  N   LYS    62      15.955   5.090  25.394  1.00 10.76           N  
ATOM    382  CA  LYS    62      16.456   4.537  24.153  1.00 10.80           C  
ATOM    383  C   LYS    62      16.015   5.435  23.008  1.00 10.46           C  
ATOM    384  O   LYS    62      14.887   5.903  22.985  1.00 11.00           O  
ATOM    385  CB  LYS    62      15.908   3.128  23.926  1.00 11.68           C  
ATOM    386  CG  LYS    62      16.537   2.368  22.731  1.00 14.08           C  
ATOM    387  CD  LYS    62      18.069   2.338  22.718  1.00 15.23           C  
ATOM    388  CE  LYS    62      18.694   1.776  24.000  1.00 16.71           C  
ATOM    389  NZ  LYS    62      20.167   1.507  23.839  1.00 19.21           N  
ATOM    390  N   ILE    63      16.956   5.708  22.103  1.00 10.53           N  
ATOM    391  CA  ILE    63      16.669   6.490  20.903  1.00 10.94           C  
ATOM    392  C   ILE    63      17.062   5.657  19.694  1.00 10.88           C  
ATOM    393  O   ILE    63      18.155   5.100  19.632  1.00 11.23           O  
ATOM    394  CB  ILE    63      17.478   7.812  20.873  1.00 11.95           C  
ATOM    395  CG1 ILE    63      17.197   8.628  22.130  1.00 12.48           C  
ATOM    396  CG2 ILE    63      17.111   8.626  19.607  1.00 11.36           C  
ATOM    397  CD1 ILE    63      18.239   9.693  22.421  1.00 14.22           C  
ATOM    398  N   ILE    64      16.164   5.593  18.725  1.00 10.48           N  
ATOM    399  CA  ILE    64      16.486   5.060  17.412  1.00 10.88           C  
ATOM    400  C   ILE    64      16.486   6.269  16.504  1.00 10.93           C  
ATOM    401  O   ILE    64      15.419   6.864  16.260  1.00 11.03           O  
ATOM    402  CB  ILE    64      15.416   4.042  16.960  1.00 11.86           C  
ATOM    403  CG1 ILE    64      15.450   2.832  17.899  1.00 15.49           C  
ATOM    404  CG2 ILE    64      15.662   3.608  15.514  1.00 16.09           C  
ATOM    405  CD1 ILE    64      14.287   1.900  17.713  1.00 19.46           C  
ATOM    406  N   SER    65      17.668   6.635  16.021  1.00 10.83           N  
ATOM    407  CA  SER    65      17.876   7.846  15.224  1.00 10.05           C  
ATOM    408  C   SER    65      18.068   7.492  13.751  1.00 10.66           C  
ATOM    409  O   SER    65      18.777   6.522  13.452  1.00 12.61           O  
ATOM    410  CB  SER    65      19.134   8.568  15.720  1.00 10.73           C  
ATOM    411  OG  SER    65      18.920   9.202  16.979  1.00 13.77           O  
ATOM    412  N   ILE    66      17.450   8.258  12.851  1.00  9.40           N  
ATOM    413  CA  ILE    66      17.439   7.937  11.425  1.00 10.04           C  
ATOM    414  C   ILE    66      17.853   9.169  10.617  1.00 11.20           C  
ATOM    415  O   ILE    66      17.303  10.259  10.835  1.00 11.03           O  
ATOM    416  CB  ILE    66      16.023   7.511  10.961  1.00 10.72           C  
ATOM    417  CG1 ILE    66      15.571   6.266  11.760  1.00 13.63           C  
ATOM    418  CG2 ILE    66      16.044   7.193   9.456  1.00 15.71           C  
ATOM    419  CD1 ILE    66      14.091   5.931  11.698  1.00 16.82           C  
ATOM    420  N   ASP    67      18.776   9.007   9.672  1.00 11.18           N  
ATOM    421  CA  ASP    67      19.114  10.119   8.794  1.00 11.30           C  
ATOM    422  C   ASP    67      19.697   9.605   7.495  1.00 11.71           C  
ATOM    423  O   ASP    67      20.207   8.493   7.440  1.00 12.81           O  
ATOM    424  CB  ASP    67      20.142  11.041   9.475  1.00 13.14           C  
ATOM    425  CG  ASP    67      20.150  12.447   8.900  1.00 12.63           C  
ATOM    426  OD1 ASP    67      20.680  12.687   7.798  1.00 14.91           O  
ATOM    427  OD2 ASP    67      19.609  13.342   9.554  1.00 12.57           O  
ATOM    428  N   LEU    68      19.618  10.433   6.454  1.00 11.57           N  
ATOM    429  CA  LEU    68      20.321  10.139   5.195  1.00 12.52           C  
ATOM    430  C   LEU    68      21.838  10.180   5.347  1.00 15.17           C  
ATOM    431  O   LEU    68      22.553   9.453   4.634  1.00 16.52           O  
ATOM    432  CB  LEU    68      19.948  11.168   4.126  1.00 12.94           C  
ATOM    433  CG  LEU    68      18.525  11.192   3.601  1.00 13.40           C  
ATOM    434  CD1 LEU    68      18.271  12.492   2.840  1.00 16.72           C  
ATOM    435  CD2 LEU    68      18.308  10.018   2.701  1.00 16.24           C  
ATOM    436  N   GLN    69      22.310  11.046   6.234  1.00 14.15           N  
ATOM    437  CA  GLN    69      23.728  11.351   6.393  0.50 15.08           C  
ATOM    439  C   GLN    69      24.290  10.685   7.630  1.00 16.76           C  
ATOM    440  O   GLN    69      23.584  10.523   8.611  1.00 16.67           O  
ATOM    441  CB  GLN    69      23.913  12.867   6.539  0.50 14.48           C  
ATOM    443  CG  GLN    69      23.303  13.684   5.409  0.50 17.02           C  
ATOM    445  CD  GLN    69      23.454  15.188   5.597  0.50 21.02           C  
ATOM    447  OE1 GLN    69      24.102  15.855   4.791  0.50 26.25           O  
ATOM    449  NE2 GLN    69      22.855  15.728   6.661  0.50 23.75           N  
ATOM    451  N   GLU    70      25.572  10.325   7.596  1.00 18.94           N  
ATOM    452  CA  GLU    70      26.232   9.832   8.782  1.00 22.18           C  
ATOM    453  C   GLU    70      26.240  10.901   9.868  1.00 20.61           C  
ATOM    454  O   GLU    70      26.174  12.106   9.592  1.00 22.85           O  
ATOM    455  CB  GLU    70      27.677   9.422   8.457  1.00 28.88           C  
ATOM    456  CG  GLU    70      27.852   7.941   8.115  1.00 41.08           C  
ATOM    457  CD  GLU    70      27.435   7.003   9.249  1.00 47.85           C  
ATOM    458  OE1 GLU    70      26.837   5.947   8.953  1.00 44.50           O  
ATOM    459  OE2 GLU    70      27.701   7.316  10.433  1.00 53.10           O  
ATOM    460  N   MET    71      26.268  10.446  11.111  1.00 22.46           N  
ATOM    461  CA  MET    71      26.587  11.326  12.213  1.00 25.42           C  
ATOM    462  C   MET    71      27.448  10.554  13.197  1.00 23.59           C  
ATOM    463  O   MET    71      27.522   9.316  13.134  1.00 26.19           O  
ATOM    464  CB  MET    71      25.322  11.862  12.878  1.00 23.96           C  
ATOM    465  CG  MET    71      24.476  10.818  13.500  1.00 17.30           C  
ATOM    466  SD  MET    71      23.049  11.579  14.604  0.70 26.40          SE  
ATOM    467  CE  MET    71      22.642   9.910  15.033  1.00 10.60           C  
ATOM    468  N   GLU    72      28.096  11.285  14.094  1.00 26.79           N  
ATOM    469  CA  GLU    72      28.953  10.671  15.095  1.00 33.65           C  
ATOM    470  C   GLU    72      28.145   9.796  16.045  1.00 30.46           C  
ATOM    471  O   GLU    72      26.991  10.116  16.373  1.00 25.47           O  
ATOM    472  CB  GLU    72      29.745  11.727  15.868  1.00 37.99           C  
ATOM    473  CG  GLU    72      31.107  12.025  15.258  1.00 50.28           C  
ATOM    474  CD  GLU    72      32.059  12.668  16.247  1.00 59.79           C  
ATOM    475  OE1 GLU    72      32.889  11.938  16.833  1.00 58.00           O  
ATOM    476  OE2 GLU    72      31.968  13.900  16.446  1.00 64.90           O  
ATOM    477  N   GLU    73      28.759   8.679  16.436  1.00 31.06           N  
ATOM    478  CA  GLU    73      28.176   7.737  17.389  1.00 33.36           C  
ATOM    479  C   GLU    73      27.967   8.371  18.761  1.00 28.63           C  
ATOM    480  O   GLU    73      28.727   9.226  19.207  1.00 23.68           O  
ATOM    481  CB  GLU    73      29.018   6.449  17.491  1.00 36.66           C  
ATOM    482  CG  GLU    73      30.441   6.610  18.065  1.00 54.51           C  
ATOM    483  CD  GLU    73      31.506   7.002  17.029  1.00 65.94           C  
ATOM    484  OE1 GLU    73      31.163   7.273  15.854  1.00 68.44           O  
ATOM    485  OE2 GLU    73      32.701   7.039  17.403  1.00 69.26           O  
ATOM    486  N   ILE    74      26.872   7.991  19.401  1.00 22.88           N  
ATOM    487  CA  ILE    74      26.562   8.449  20.743  1.00 19.83           C  
ATOM    488  C   ILE    74      26.268   7.153  21.468  1.00 21.56           C  
ATOM    489  O   ILE    74      25.559   6.292  20.937  1.00 20.26           O  
ATOM    490  CB  ILE    74      25.373   9.459  20.768  1.00 18.50           C  
ATOM    491  CG1 ILE    74      25.750  10.731  20.004  1.00 19.31           C  
ATOM    492  CG2 ILE    74      25.007   9.835  22.203  1.00 19.70           C  
ATOM    493  CD1 ILE    74      24.565  11.626  19.648  1.00 16.30           C  
ATOM    494  N   ALA    75      26.864   6.985  22.648  1.00 20.90           N  
ATOM    495  CA  ALA    75      26.737   5.721  23.362  1.00 24.22           C  
ATOM    496  C   ALA    75      25.269   5.387  23.594  1.00 16.89           C  
ATOM    497  O   ALA    75      24.505   6.211  24.078  1.00 19.33           O  
ATOM    498  CB  ALA    75      27.493   5.779  24.688  1.00 24.81           C  
ATOM    499  N   GLY    76      24.889   4.172  23.202  1.00 19.08           N  
ATOM    500  CA  GLY    76      23.548   3.677  23.464  1.00 17.20           C  
ATOM    501  C   GLY    76      22.463   4.103  22.491  1.00 15.30           C  
ATOM    502  O   GLY    76      21.329   3.646  22.609  1.00 15.69           O  
ATOM    503  N   VAL    77      22.806   4.973  21.542  1.00 14.31           N  
ATOM    504  CA  VAL    77      21.842   5.431  20.531  1.00 13.17           C  
ATOM    505  C   VAL    77      21.950   4.492  19.341  1.00 13.37           C  
ATOM    506  O   VAL    77      23.080   4.158  18.899  1.00 15.18           O  
ATOM    507  CB  VAL    77      22.116   6.883  20.066  1.00 12.43           C  
ATOM    508  CG1 VAL    77      21.270   7.236  18.841  1.00 12.61           C  
ATOM    509  CG2 VAL    77      21.880   7.889  21.205  1.00 14.75           C  
ATOM    510  N   ARG    78      20.800   4.033  18.840  1.00 11.93           N  
ATOM    511  CA  ARG    78      20.811   3.143  17.711  1.00 12.60           C  
ATOM    512  C   ARG    78      20.600   3.982  16.467  1.00 14.57           C  
ATOM    513  O   ARG    78      19.518   4.500  16.242  1.00 15.17           O  
ATOM    514  CB  ARG    78      19.687   2.130  17.870  1.00 13.99           C  
ATOM    515  CG  ARG    78      19.597   1.139  16.749  1.00 22.12           C  
ATOM    516  CD  ARG    78      18.604   0.066  17.103  1.00 33.92           C  
ATOM    517  NE  ARG    78      19.095  -0.893  18.091  1.00 36.42           N  
ATOM    518  CZ  ARG    78      19.566  -2.102  17.801  1.00 40.20           C  
ATOM    519  NH1 ARG    78      19.627  -2.522  16.538  1.00 33.04           N  
ATOM    520  NH2 ARG    78      19.979  -2.893  18.783  1.00 34.30           N  
ATOM    521  N   PHE    79      21.639   4.139  15.673  1.00 12.80           N  
ATOM    522  CA  PHE    79      21.557   4.970  14.492  1.00 12.11           C  
ATOM    523  C   PHE    79      21.322   4.109  13.255  1.00 15.59           C  
ATOM    524  O   PHE    79      21.970   3.080  13.073  1.00 18.23           O  
ATOM    525  CB  PHE    79      22.824   5.823  14.349  1.00 13.66           C  
ATOM    526  CG  PHE    79      22.852   6.660  13.095  1.00 13.92           C  
ATOM    527  CD1 PHE    79      21.877   7.611  12.857  1.00 14.07           C  
ATOM    528  CD2 PHE    79      23.848   6.472  12.138  1.00 16.12           C  
ATOM    529  CE1 PHE    79      21.892   8.377  11.684  1.00 14.81           C  
ATOM    530  CE2 PHE    79      23.858   7.213  10.961  1.00 19.04           C  
ATOM    531  CZ  PHE    79      22.879   8.168  10.732  1.00 18.26           C  
ATOM    532  N   ILE    80      20.403   4.548  12.398  1.00 13.67           N  
ATOM    533  CA  ILE    80      20.103   3.867  11.146  1.00 14.45           C  
ATOM    534  C   ILE    80      20.258   4.895  10.030  1.00 14.03           C  
ATOM    535  O   ILE    80      19.560   5.907  10.008  1.00 13.61           O  
ATOM    536  CB  ILE    80      18.662   3.349  11.105  1.00 13.42           C  
ATOM    537  CG1 ILE    80      18.360   2.431  12.311  1.00 16.58           C  
ATOM    538  CG2 ILE    80      18.406   2.615   9.777  1.00 18.22           C  
ATOM    539  CD1 ILE    80      16.914   2.000  12.421  1.00 19.95           C  
ATOM    540  N   ARG    81      21.150   4.631   9.083  1.00 13.88           N  
ATOM    541  CA  ARG    81      21.227   5.441   7.874  1.00 13.30           C  
ATOM    542  C   ARG    81      20.158   4.928   6.915  1.00 15.06           C  
ATOM    543  O   ARG    81      20.173   3.759   6.520  1.00 13.56           O  
ATOM    544  CB  ARG    81      22.615   5.338   7.223  1.00 16.75           C  
ATOM    545  CG  ARG    81      23.450   6.594   7.390  1.00 33.80           C  
ATOM    546  CD  ARG    81      24.652   6.576   6.480  1.00 32.17           C  
ATOM    547  NE  ARG    81      24.561   7.513   5.368  1.00 23.99           N  
ATOM    548  CZ  ARG    81      25.551   7.722   4.507  1.00 24.73           C  
ATOM    549  NH1 ARG    81      26.692   7.059   4.649  1.00 32.42           N  
ATOM    550  NH2 ARG    81      25.417   8.590   3.517  1.00 33.32           N  
ATOM    551  N   CYS    82      19.225   5.793   6.535  1.00 12.53           N  
ATOM    552  CA  CYS    82      18.074   5.359   5.777  1.00 13.00           C  
ATOM    553  C   CYS    82      17.358   6.563   5.184  1.00 13.41           C  
ATOM    554  O   CYS    82      17.306   7.620   5.834  1.00 14.05           O  
ATOM    555  CB  CYS    82      17.112   4.609   6.690  1.00 14.25           C  
ATOM    556  SG  CYS    82      15.720   3.923   5.762  1.00 19.53           S  
ATOM    557  N   ASP    83      16.812   6.411   3.971  1.00 11.70           N  
ATOM    558  CA  ASP    83      15.918   7.424   3.426  1.00 13.14           C  
ATOM    559  C   ASP    83      14.520   6.983   3.823  1.00 12.87           C  
ATOM    560  O   ASP    83      14.055   5.923   3.397  1.00 13.51           O  
ATOM    561  CB  ASP    83      16.049   7.465   1.892  1.00 11.45           C  
ATOM    562  CG  ASP    83      15.148   8.506   1.230  1.00 15.18           C  
ATOM    563  OD1 ASP    83      14.130   8.930   1.810  1.00 14.62           O  
ATOM    564  OD2 ASP    83      15.471   8.904   0.089  1.00 18.70           O  
ATOM    565  N   ILE    84      13.815   7.793   4.614  1.00 12.08           N  
ATOM    566  CA  ILE    84      12.487   7.374   5.080  1.00 10.97           C  
ATOM    567  C   ILE    84      11.473   7.126   3.959  1.00 13.47           C  
ATOM    568  O   ILE    84      10.482   6.462   4.189  1.00 13.31           O  
ATOM    569  CB  ILE    84      11.885   8.365   6.121  1.00 13.38           C  
ATOM    570  CG1 ILE    84      11.602   9.759   5.495  1.00 12.86           C  
ATOM    571  CG2 ILE    84      12.798   8.462   7.361  1.00 13.54           C  
ATOM    572  CD1 ILE    84      10.751  10.702   6.380  1.00 14.69           C  
ATOM    573  N   PHE    85      11.714   7.676   2.777  1.00 13.02           N  
ATOM    574  CA  PHE    85      10.765   7.515   1.662  1.00 12.85           C  
ATOM    575  C   PHE    85      10.973   6.201   0.908  1.00 15.25           C  
ATOM    576  O   PHE    85      10.124   5.806   0.095  1.00 17.25           O  
ATOM    577  CB  PHE    85      10.912   8.669   0.671  1.00 12.29           C  
ATOM    578  CG  PHE    85      10.433   9.989   1.201  1.00 11.32           C  
ATOM    579  CD1 PHE    85       9.089  10.185   1.493  1.00 12.76           C  
ATOM    580  CD2 PHE    85      11.325  11.028   1.391  1.00 11.72           C  
ATOM    581  CE1 PHE    85       8.653  11.410   1.982  1.00 15.78           C  
ATOM    582  CE2 PHE    85      10.888  12.257   1.881  1.00 14.28           C  
ATOM    583  CZ  PHE    85       9.542  12.440   2.161  1.00 16.43           C  
ATOM    584  N   LYS    86      12.090   5.521   1.161  1.00 15.12           N  
ATOM    585  CA  LYS    86      12.431   4.349   0.368  1.00 15.16           C  
ATOM    586  C   LYS    86      11.876   3.069   1.009  1.00 15.80           C  
ATOM    587  O   LYS    86      11.010   3.133   1.883  1.00 17.52           O  
ATOM    588  CB  LYS    86      13.945   4.285   0.104  1.00 15.21           C  
ATOM    589  CG  LYS    86      14.498   5.434  -0.749  1.00 18.74           C  
ATOM    590  CD  LYS    86      13.847   5.550  -2.129  1.00 25.60           C  
ATOM    591  CE  LYS    86      14.376   6.798  -2.845  1.00 30.31           C  
ATOM    592  NZ  LYS    86      13.560   7.154  -4.039  1.00 39.14           N  
ATOM    593  N   GLU    87      12.352   1.907   0.555  1.00 14.35           N  
ATOM    594  CA  GLU    87      11.668   0.641   0.825  1.00 18.83           C  
ATOM    595  C   GLU    87      12.058  -0.083   2.092  1.00 16.10           C  
ATOM    596  O   GLU    87      11.344  -1.014   2.497  1.00 18.86           O  
ATOM    597  CB  GLU    87      11.829  -0.343  -0.352  1.00 16.40           C  
ATOM    598  CG  GLU    87      11.473   0.263  -1.727  1.00 24.26           C  
ATOM    599  CD  GLU    87      11.768  -0.673  -2.915  1.00 32.24           C  
ATOM    600  OE1 GLU    87      12.880  -1.247  -3.018  1.00 22.27           O  
ATOM    601  OE2 GLU    87      10.871  -0.822  -3.769  1.00 38.54           O  
ATOM    602  N   THR    88      13.181   0.284   2.702  1.00 14.31           N  
ATOM    603  CA  THR    88      13.659  -0.478   3.865  1.00 12.35           C  
ATOM    604  C   THR    88      13.197   0.081   5.223  1.00 14.22           C  
ATOM    605  O   THR    88      13.419  -0.547   6.228  1.00 14.68           O  
ATOM    606  CB  THR    88      15.204  -0.564   3.925  1.00 13.50           C  
ATOM    607  OG1 THR    88      15.751   0.750   4.057  1.00 14.98           O  
ATOM    608  CG2 THR    88      15.779  -1.252   2.680  1.00 16.24           C  
ATOM    609  N   ILE    89      12.594   1.267   5.235  1.00 12.41           N  
ATOM    610  CA  ILE    89      12.386   2.013   6.486  1.00 11.93           C  
ATOM    611  C   ILE    89      11.652   1.215   7.561  1.00 13.83           C  
ATOM    612  O   ILE    89      12.071   1.204   8.727  1.00 13.99           O  
ATOM    613  CB  ILE    89      11.719   3.394   6.209  1.00 14.69           C  
ATOM    614  CG1 ILE    89      11.573   4.220   7.504  1.00 12.66           C  
ATOM    615  CG2 ILE    89      10.379   3.264   5.465  1.00 15.13           C  
ATOM    616  CD1 ILE    89      12.869   4.423   8.248  1.00 14.32           C  
ATOM    617  N   PHE    90      10.607   0.498   7.154  1.00 14.71           N  
ATOM    618  CA  PHE    90       9.821  -0.247   8.141  1.00 14.60           C  
ATOM    619  C   PHE    90      10.538  -1.480   8.612  1.00 16.51           C  
ATOM    620  O   PHE    90      10.508  -1.789   9.792  1.00 16.36           O  
ATOM    621  CB  PHE    90       8.431  -0.572   7.621  1.00 14.85           C  
ATOM    622  CG  PHE    90       7.667   0.634   7.185  1.00 15.88           C  
ATOM    623  CD1 PHE    90       7.239   1.592   8.107  1.00 17.54           C  
ATOM    624  CD2 PHE    90       7.402   0.845   5.835  1.00 19.99           C  
ATOM    625  CE1 PHE    90       6.530   2.729   7.673  1.00 20.12           C  
ATOM    626  CE2 PHE    90       6.701   1.964   5.402  1.00 24.98           C  
ATOM    627  CZ  PHE    90       6.264   2.908   6.314  1.00 18.82           C  
ATOM    628  N   ASP    91      11.219  -2.166   7.698  1.00 13.68           N  
ATOM    629  CA  ASP    91      12.028  -3.312   8.096  1.00 13.68           C  
ATOM    630  C   ASP    91      13.162  -2.919   9.047  1.00 14.80           C  
ATOM    631  O   ASP    91      13.516  -3.670   9.977  1.00 16.34           O  
ATOM    632  CB  ASP    91      12.633  -3.997   6.862  1.00 17.52           C  
ATOM    633  CG  ASP    91      11.588  -4.694   5.996  1.00 24.50           C  
ATOM    634  OD1 ASP    91      10.492  -5.018   6.497  1.00 21.30           O  
ATOM    635  OD2 ASP    91      11.869  -4.923   4.799  1.00 25.94           O  
ATOM    636  N   ASP    92      13.744  -1.741   8.792  1.00 13.74           N  
ATOM    637  CA  ASP    92      14.841  -1.220   9.576  1.00 12.72           C  
ATOM    638  C   ASP    92      14.374  -0.880  10.980  1.00 13.13           C  
ATOM    639  O   ASP    92      15.044  -1.216  11.962  1.00 14.01           O  
ATOM    640  CB  ASP    92      15.394   0.057   8.928  1.00 13.56           C  
ATOM    641  CG  ASP    92      16.180  -0.193   7.654  1.00 17.23           C  
ATOM    642  OD1 ASP    92      16.647  -1.335   7.426  1.00 16.56           O  
ATOM    643  OD2 ASP    92      16.330   0.788   6.886  1.00 16.08           O  
ATOM    644  N   ILE    93      13.230  -0.204  11.067  1.00 12.18           N  
ATOM    645  CA  ILE    93      12.724   0.159  12.399  1.00 14.15           C  
ATOM    646  C   ILE    93      12.235  -1.093  13.129  1.00 17.32           C  
ATOM    647  O   ILE    93      12.549  -1.268  14.324  1.00 15.16           O  
ATOM    648  CB  ILE    93      11.617   1.219  12.327  1.00 13.03           C  
ATOM    649  CG1 ILE    93      12.191   2.564  11.848  1.00 12.61           C  
ATOM    650  CG2 ILE    93      11.000   1.412  13.719  1.00 14.05           C  
ATOM    651  CD1 ILE    93      11.121   3.600  11.455  1.00 12.35           C  
ATOM    652  N   ASP    94      11.502  -1.963  12.419  1.00 14.05           N  
ATOM    653  CA  ASP    94      11.083  -3.250  13.017  1.00 16.18           C  
ATOM    654  C   ASP    94      12.256  -3.979  13.665  1.00 15.42           C  
ATOM    655  O   ASP    94      12.155  -4.422  14.814  1.00 17.28           O  
ATOM    656  CB  ASP    94      10.513  -4.217  11.974  1.00 17.07           C  
ATOM    657  CG  ASP    94       9.121  -3.855  11.489  1.00 17.35           C  
ATOM    658  OD1 ASP    94       8.505  -2.885  11.987  1.00 18.27           O  
ATOM    659  OD2 ASP    94       8.633  -4.548  10.555  1.00 21.85           O  
ATOM    660  N   ARG    95      13.367  -4.122  12.932  1.00 15.58           N  
ATOM    661  CA  ARG    95      14.535  -4.842  13.428  1.00 16.07           C  
ATOM    662  C   ARG    95      15.118  -4.171  14.663  1.00 19.11           C  
ATOM    663  O   ARG    95      15.440  -4.833  15.641  1.00 18.91           O  
ATOM    664  CB  ARG    95      15.615  -4.981  12.348  1.00 20.99           C  
ATOM    665  CG  ARG    95      16.734  -5.950  12.716  1.00 29.41           C  
ATOM    666  CD  ARG    95      17.846  -6.022  11.666  1.00 35.92           C  
ATOM    667  NE  ARG    95      19.041  -5.272  12.063  1.00 53.69           N  
ATOM    668  CZ  ARG    95      20.279  -5.526  11.631  1.00 57.40           C  
ATOM    669  NH1 ARG    95      20.511  -6.528  10.781  1.00 50.29           N  
ATOM    670  NH2 ARG    95      21.295  -4.777  12.056  1.00 50.88           N  
ATOM    671  N   ALA    96      15.224  -2.839  14.627  1.00 15.34           N  
ATOM    672  CA  ALA    96      15.780  -2.102  15.748  1.00 15.93           C  
ATOM    673  C   ALA    96      14.919  -2.271  17.000  1.00 16.84           C  
ATOM    674  O   ALA    96      15.439  -2.511  18.081  1.00 17.65           O  
ATOM    675  CB  ALA    96      15.873  -0.633  15.370  1.00 16.45           C  
ATOM    676  N   LEU    97      13.605  -2.139  16.847  1.00 15.40           N  
ATOM    677  CA  LEU    97      12.680  -2.321  17.994  1.00 13.08           C  
ATOM    678  C   LEU    97      12.750  -3.730  18.579  1.00 16.91           C  
ATOM    679  O   LEU    97      12.794  -3.905  19.802  1.00 16.10           O  
ATOM    680  CB  LEU    97      11.253  -1.987  17.596  1.00 13.95           C  
ATOM    681  CG  LEU    97      11.014  -0.503  17.284  1.00 15.23           C  
ATOM    682  CD1 LEU    97       9.596  -0.311  16.828  1.00 17.81           C  
ATOM    683  CD2 LEU    97      11.298   0.351  18.487  1.00 16.90           C  
ATOM    684  N   ARG    98      12.784  -4.716  17.691  1.00 19.05           N  
ATOM    685  CA  ARG    98      12.877  -6.131  18.092  1.00 20.68           C  
ATOM    686  C   ARG    98      14.131  -6.358  18.933  1.00 20.56           C  
ATOM    687  O   ARG    98      14.065  -6.934  20.021  1.00 20.37           O  
ATOM    688  CB  ARG    98      12.881  -7.022  16.843  1.00 19.15           C  
ATOM    689  CG  ARG    98      12.874  -8.519  17.105  1.00 36.63           C  
ATOM    690  CD  ARG    98      12.535  -9.327  15.828  1.00 35.92           C  
ATOM    691  NE  ARG    98      13.244  -8.889  14.616  1.00 42.00           N  
ATOM    692  CZ  ARG    98      12.657  -8.384  13.527  1.00 49.87           C  
ATOM    693  NH1 ARG    98      11.336  -8.239  13.470  1.00 49.31           N  
ATOM    694  NH2 ARG    98      13.394  -8.022  12.482  1.00 44.13           N  
ATOM    695  N   GLU    99      15.250  -5.823  18.468  1.00 16.76           N  
ATOM    696  CA  GLU    99      16.506  -5.965  19.184  1.00 18.98           C  
ATOM    697  C   GLU    99      16.523  -5.234  20.527  1.00 21.82           C  
ATOM    698  O   GLU    99      17.222  -5.656  21.456  1.00 22.66           O  
ATOM    699  CB  GLU    99      17.666  -5.544  18.293  1.00 20.90           C  
ATOM    700  CG  GLU    99      17.841  -6.543  17.134  1.00 26.92           C  
ATOM    701  CD  GLU    99      18.967  -6.203  16.182  1.00 37.81           C  
ATOM    702  OE1 GLU    99      19.767  -5.310  16.503  1.00 37.69           O  
ATOM    703  OE2 GLU    99      19.052  -6.841  15.109  1.00 39.69           O  
ATOM    704  N   GLU   100      15.730  -4.167  20.641  1.00 17.11           N  
ATOM    705  CA  GLU   100      15.619  -3.454  21.902  1.00 17.75           C  
ATOM    706  C   GLU   100      14.556  -4.001  22.837  1.00 16.86           C  
ATOM    707  O   GLU   100      14.469  -3.550  23.983  1.00 20.47           O  
ATOM    708  CB  GLU   100      15.371  -1.964  21.640  1.00 18.83           C  
ATOM    709  CG  GLU   100      16.493  -1.253  20.883  1.00 18.10           C  
ATOM    710  CD  GLU   100      17.824  -1.244  21.638  1.00 31.26           C  
ATOM    711  OE1 GLU   100      17.809  -1.279  22.895  1.00 24.65           O  
ATOM    712  OE2 GLU   100      18.883  -1.200  20.968  1.00 30.33           O  
ATOM    713  N   GLY   101      13.760  -4.962  22.366  1.00 15.44           N  
ATOM    714  CA  GLY   101      12.667  -5.499  23.175  1.00 15.63           C  
ATOM    715  C   GLY   101      11.522  -4.517  23.332  1.00 15.58           C  
ATOM    716  O   GLY   101      10.802  -4.537  24.330  1.00 18.18           O  
ATOM    717  N   ILE   102      11.326  -3.662  22.335  1.00 14.55           N  
ATOM    718  CA  ILE   102      10.278  -2.661  22.376  1.00 12.71           C  
ATOM    719  C   ILE   102       9.208  -3.041  21.358  1.00 15.93           C  
ATOM    720  O   ILE   102       9.564  -3.350  20.214  1.00 16.82           O  
ATOM    721  CB  ILE   102      10.837  -1.270  22.004  1.00 13.71           C  
ATOM    722  CG1 ILE   102      11.898  -0.824  23.021  1.00 15.46           C  
ATOM    723  CG2 ILE   102       9.698  -0.240  21.874  1.00 13.97           C  
ATOM    724  CD1 ILE   102      12.686   0.444  22.609  1.00 13.84           C  
ATOM    725  N   GLU   103       7.930  -3.051  21.762  1.00 14.80           N  
ATOM    726  CA  GLU   103       6.819  -3.287  20.834  1.00 14.37           C  
ATOM    727  C   GLU   103       6.346  -1.975  20.207  1.00 16.25           C  
ATOM    728  O   GLU   103       6.170  -1.894  18.980  1.00 16.50           O  
ATOM    729  CB  GLU   103       5.666  -4.007  21.536  1.00 14.59           C  
ATOM    730  CG  GLU   103       4.478  -4.362  20.618  1.00 23.31           C  
ATOM    731  CD  GLU   103       4.731  -5.541  19.690  1.00 38.88           C  
ATOM    732  OE1 GLU   103       5.747  -6.263  19.848  1.00 40.58           O  
ATOM    733  OE2 GLU   103       3.890  -5.744  18.787  1.00 44.02           O  
ATOM    734  N   LYS   104       6.144  -0.967  21.058  1.00 11.97           N  
ATOM    735  CA  LYS   104       5.641   0.354  20.654  1.00 12.65           C  
ATOM    736  C   LYS   104       6.441   1.416  21.368  1.00 12.46           C  
ATOM    737  O   LYS   104       6.720   1.289  22.552  1.00 12.40           O  
ATOM    738  CB  LYS   104       4.160   0.551  20.980  1.00 14.66           C  
ATOM    739  CG  LYS   104       3.184  -0.415  20.278  1.00 15.66           C  
ATOM    740  CD  LYS   104       3.093  -0.147  18.783  1.00 17.92           C  
ATOM    741  CE  LYS   104       1.964  -0.991  18.176  1.00 18.93           C  
ATOM    742  NZ  LYS   104       1.927  -0.784  16.721  1.00 22.15           N  
ATOM    743  N   VAL   105       6.847   2.455  20.631  1.00 12.16           N  
ATOM    744  CA  VAL   105       7.670   3.513  21.208  1.00 10.51           C  
ATOM    745  C   VAL   105       6.772   4.544  21.856  1.00  9.96           C  
ATOM    746  O   VAL   105       5.568   4.609  21.587  1.00 12.50           O  
ATOM    747  CB  VAL   105       8.559   4.211  20.136  1.00 11.01           C  
ATOM    748  CG1 VAL   105       9.606   3.235  19.613  1.00 13.10           C  
ATOM    749  CG2 VAL   105       7.688   4.808  19.026  1.00 12.29           C  
ATOM    750  N   ASP   106       7.380   5.387  22.687  1.00 11.09           N  
ATOM    751  CA  ASP   106       6.613   6.395  23.402  1.00  9.99           C  
ATOM    752  C   ASP   106       6.445   7.655  22.573  1.00 12.17           C  
ATOM    753  O   ASP   106       5.420   8.311  22.669  1.00 12.24           O  
ATOM    754  CB  ASP   106       7.297   6.743  24.721  1.00 11.76           C  
ATOM    755  CG  ASP   106       7.472   5.526  25.608  1.00 10.29           C  
ATOM    756  OD1 ASP   106       6.536   5.239  26.395  1.00 14.19           O  
ATOM    757  OD2 ASP   106       8.523   4.866  25.562  1.00 10.87           O  
ATOM    758  N   ASP   107       7.462   8.022  21.776  1.00 10.50           N  
ATOM    759  CA  ASP   107       7.385   9.240  20.937  1.00 11.36           C  
ATOM    760  C   ASP   107       8.046   9.027  19.596  1.00  9.58           C  
ATOM    761  O   ASP   107       8.985   8.248  19.481  1.00 10.07           O  
ATOM    762  CB  ASP   107       8.101  10.413  21.595  1.00 11.91           C  
ATOM    763  CG  ASP   107       7.779  10.538  23.051  1.00 11.98           C  
ATOM    764  OD1 ASP   107       6.625  10.852  23.399  1.00 15.21           O  
ATOM    765  OD2 ASP   107       8.690  10.276  23.851  1.00 13.81           O  
ATOM    766  N   VAL   108       7.560   9.755  18.589  1.00  9.74           N  
ATOM    767  CA  VAL   108       8.268   9.888  17.329  1.00  8.61           C  
ATOM    768  C   VAL   108       8.518  11.387  17.167  1.00 11.05           C  
ATOM    769  O   VAL   108       7.583  12.208  17.282  1.00 11.94           O  
ATOM    770  CB  VAL   108       7.426   9.325  16.155  1.00 11.46           C  
ATOM    771  CG1 VAL   108       8.110   9.616  14.804  1.00 14.09           C  
ATOM    772  CG2 VAL   108       7.177   7.803  16.292  1.00 14.03           C  
ATOM    773  N   VAL   109       9.778  11.775  16.978  1.00  9.92           N  
ATOM    774  CA  VAL   109      10.097  13.186  16.779  1.00 11.54           C  
ATOM    775  C   VAL   109      10.829  13.345  15.470  1.00 10.98           C  
ATOM    776  O   VAL   109      11.574  12.456  15.072  1.00 12.56           O  
ATOM    777  CB  VAL   109      10.912  13.788  17.938  1.00 11.55           C  
ATOM    778  CG1 VAL   109      10.234  13.524  19.285  1.00 14.62           C  
ATOM    779  CG2 VAL   109      12.324  13.234  17.963  1.00 13.66           C  
ATOM    780  N   SER   110      10.605  14.469  14.782  1.00  9.10           N  
ATOM    781  CA  SER   110      11.280  14.712  13.524  1.00  9.63           C  
ATOM    782  C   SER   110      11.697  16.168  13.394  1.00  9.21           C  
ATOM    783  O   SER   110      10.871  17.076  13.572  1.00 10.64           O  
ATOM    784  CB  SER   110      10.339  14.386  12.377  1.00 11.38           C  
ATOM    785  OG  SER   110      10.906  14.752  11.108  1.00 12.49           O  
ATOM    786  N   ASP   111      12.975  16.367  13.054  1.00  9.78           N  
ATOM    787  CA  ASP   111      13.502  17.661  12.628  1.00 10.30           C  
ATOM    788  C   ASP   111      13.948  17.541  11.174  1.00 12.59           C  
ATOM    789  O   ASP   111      14.731  18.370  10.700  1.00 14.21           O  
ATOM    790  CB  ASP   111      14.678  18.042  13.517  1.00 12.34           C  
ATOM    791  CG  ASP   111      14.999  19.521  13.476  1.00 17.14           C  
ATOM    792  OD1 ASP   111      14.082  20.342  13.247  1.00 16.72           O  
ATOM    793  OD2 ASP   111      16.181  19.859  13.708  1.00 19.06           O  
ATOM    794  N   ALA   112      13.454  16.527  10.465  1.00 11.25           N  
ATOM    795  CA  ALA   112      13.892  16.275   9.078  1.00 11.10           C  
ATOM    796  C   ALA   112      13.422  17.377   8.141  1.00 13.86           C  
ATOM    797  O   ALA   112      12.283  17.843   8.214  1.00 13.37           O  
ATOM    798  CB  ALA   112      13.363  14.945   8.591  1.00 11.26           C  
ATOM    799  N   MET   113      14.327  17.730   7.238  1.00 13.40           N  
ATOM    800  CA  MET   113      14.080  18.704   6.191  1.00 13.40           C  
ATOM    801  C   MET   113      15.114  18.498   5.091  1.00 13.11           C  
ATOM    802  O   MET   113      16.267  18.145   5.370  1.00 13.85           O  
ATOM    803  CB  MET   113      14.123  20.131   6.730  1.00 14.46           C  
ATOM    804  CG  MET   113      13.833  21.222   5.677  1.00 13.23           C  
ATOM    805  SD  MET   113      12.116  20.916   4.727  0.70 15.43          SE  
ATOM    806  CE  MET   113      12.287  22.453   3.505  1.00 17.59           C  
ATOM    807  N   ALA   114      14.695  18.720   3.846  1.00 13.67           N  
ATOM    808  CA  ALA   114      15.638  18.631   2.739  1.00 16.40           C  
ATOM    809  C   ALA   114      16.282  19.987   2.529  1.00 15.41           C  
ATOM    810  O   ALA   114      16.163  20.856   3.367  1.00 14.70           O  
ATOM    811  CB  ALA   114      14.941  18.156   1.487  1.00 21.46           C  
ATOM    812  N   LYS   115      16.985  20.170   1.419  1.00 15.14           N  
ATOM    813  CA  LYS   115      17.557  21.487   1.150  1.00 15.78           C  
ATOM    814  C   LYS   115      16.471  22.577   1.046  1.00 13.07           C  
ATOM    815  O   LYS   115      15.398  22.359   0.466  1.00 14.83           O  
ATOM    816  CB  LYS   115      18.384  21.466  -0.133  1.00 17.66           C  
ATOM    817  CG  LYS   115      19.659  20.652  -0.013  1.00 20.06           C  
ATOM    818  CD  LYS   115      20.393  20.629  -1.344  1.00 19.58           C  
ATOM    819  CE  LYS   115      21.714  19.898  -1.250  1.00 29.22           C  
ATOM    820  NZ  LYS   115      22.368  19.836  -2.592  1.00 33.84           N  
ATOM    821  N   VAL   116      16.777  23.723   1.653  1.00 13.59           N  
ATOM    822  CA  VAL   116      15.891  24.882   1.767  0.50 13.96           C  
ATOM    824  C   VAL   116      16.070  25.782   0.530  1.00 15.19           C  
ATOM    825  O   VAL   116      17.210  26.085   0.148  1.00 14.70           O  
ATOM    826  CB  VAL   116      16.231  25.658   3.074  0.50 14.92           C  
ATOM    828  CG1 VAL   116      15.448  26.948   3.196  0.50 15.69           C  
ATOM    830  CG2 VAL   116      15.990  24.771   4.328  0.50 17.33           C  
ATOM    832  N   SER   117      14.963  26.201  -0.072  1.00 13.54           N  
ATOM    833  CA  SER   117      15.001  27.069  -1.247  1.00 11.53           C  
ATOM    834  C   SER   117      14.856  28.544  -0.888  1.00 13.31           C  
ATOM    835  O   SER   117      15.171  29.404  -1.713  1.00 15.65           O  
ATOM    836  CB  SER   117      13.865  26.696  -2.189  1.00 13.27           C  
ATOM    837  OG  SER   117      12.606  27.050  -1.610  1.00 13.68           O  
ATOM    838  N   GLY   118      14.357  28.833   0.316  1.00 13.72           N  
ATOM    839  CA  GLY   118      14.073  30.198   0.724  1.00 17.52           C  
ATOM    840  C   GLY   118      12.734  30.709   0.218  1.00 15.20           C  
ATOM    841  O   GLY   118      12.437  31.912   0.363  1.00 18.36           O  
ATOM    842  N   ILE   119      11.923  29.814  -0.356  1.00 13.99           N  
ATOM    843  CA  ILE   119      10.619  30.178  -0.913  1.00 14.12           C  
ATOM    844  C   ILE   119       9.579  29.446  -0.056  1.00 13.80           C  
ATOM    845  O   ILE   119       9.548  28.229  -0.039  1.00 13.42           O  
ATOM    846  CB  ILE   119      10.467  29.693  -2.378  1.00 11.69           C  
ATOM    847  CG1 ILE   119      11.576  30.223  -3.304  1.00 14.24           C  
ATOM    848  CG2 ILE   119       9.084  30.029  -2.926  1.00 13.99           C  
ATOM    849  CD1 ILE   119      11.731  31.748  -3.313  1.00 16.18           C  
ATOM    850  N   PRO   120       8.764  30.194   0.701  1.00 14.28           N  
ATOM    851  CA  PRO   120       7.815  29.543   1.612  1.00 14.71           C  
ATOM    852  C   PRO   120       6.972  28.435   0.981  1.00 13.91           C  
ATOM    853  O   PRO   120       6.846  27.379   1.580  1.00 13.07           O  
ATOM    854  CB  PRO   120       6.942  30.713   2.088  1.00 16.54           C  
ATOM    855  CG  PRO   120       7.921  31.876   2.108  1.00 20.48           C  
ATOM    856  CD  PRO   120       8.742  31.667   0.847  1.00 16.71           C  
ATOM    857  N   SER   121       6.428  28.623  -0.221  1.00 12.41           N  
ATOM    858  CA  SER   121       5.595  27.600  -0.829  1.00 13.18           C  
ATOM    859  C   SER   121       6.374  26.329  -1.122  1.00 13.95           C  
ATOM    860  O   SER   121       5.860  25.244  -0.874  1.00 13.03           O  
ATOM    861  CB  SER   121       4.922  28.091  -2.125  1.00 18.33           C  
ATOM    862  OG  SER   121       5.883  28.515  -3.077  1.00 19.51           O  
ATOM    863  N   ARG   122       7.592  26.473  -1.666  1.00 12.92           N  
ATOM    864  CA  ARG   122       8.398  25.294  -1.995  1.00 13.33           C  
ATOM    865  C   ARG   122       8.831  24.590  -0.738  1.00 12.54           C  
ATOM    866  O   ARG   122       8.801  23.361  -0.669  1.00 13.01           O  
ATOM    867  CB  ARG   122       9.651  25.680  -2.775  1.00 15.70           C  
ATOM    868  CG  ARG   122       9.384  26.107  -4.191  1.00 15.72           C  
ATOM    869  CD  ARG   122      10.687  26.421  -4.930  1.00 14.92           C  
ATOM    870  NE  ARG   122      11.477  25.204  -5.093  1.00 17.78           N  
ATOM    871  CZ  ARG   122      12.717  25.156  -5.578  1.00 17.08           C  
ATOM    872  NH1 ARG   122      13.334  26.269  -5.966  1.00 14.73           N  
ATOM    873  NH2 ARG   122      13.349  23.986  -5.663  1.00 17.62           N  
ATOM    874  N   ASP   123       9.271  25.360   0.249  1.00 10.85           N  
ATOM    875  CA  ASP   123       9.774  24.725   1.459  1.00 10.72           C  
ATOM    876  C   ASP   123       8.636  24.052   2.227  1.00 12.40           C  
ATOM    877  O   ASP   123       8.812  22.953   2.789  1.00 11.60           O  
ATOM    878  CB  ASP   123      10.555  25.712   2.309  1.00 12.96           C  
ATOM    879  CG  ASP   123      11.841  26.184   1.616  1.00 13.68           C  
ATOM    880  OD1 ASP   123      12.315  25.471   0.695  1.00 13.31           O  
ATOM    881  OD2 ASP   123      12.333  27.262   2.001  1.00 15.24           O  
ATOM    882  N   HIS   124       7.440  24.643   2.168  1.00 12.54           N  
ATOM    883  CA  HIS   124       6.249  23.987   2.702  1.00 11.00           C  
ATOM    884  C   HIS   124       6.013  22.648   2.010  1.00 10.83           C  
ATOM    885  O   HIS   124       5.754  21.621   2.647  1.00 11.93           O  
ATOM    886  CB  HIS   124       5.015  24.864   2.495  1.00 11.21           C  
ATOM    887  CG  HIS   124       3.734  24.178   2.840  1.00 10.23           C  
ATOM    888  ND1 HIS   124       3.462  23.724   4.115  1.00 11.30           N  
ATOM    889  CD2 HIS   124       2.654  23.865   2.088  1.00 11.04           C  
ATOM    890  CE1 HIS   124       2.268  23.155   4.129  1.00  9.49           C  
ATOM    891  NE2 HIS   124       1.770  23.205   2.906  1.00 10.84           N  
ATOM    892  N   ALA   125       6.081  22.645   0.677  1.00 11.36           N  
ATOM    893  CA  ALA   125       5.718  21.453  -0.065  1.00 12.11           C  
ATOM    894  C   ALA   125       6.604  20.251   0.294  1.00 11.47           C  
ATOM    895  O   ALA   125       6.107  19.136   0.534  1.00 13.45           O  
ATOM    896  CB  ALA   125       5.759  21.738  -1.578  1.00 13.21           C  
ATOM    897  N   VAL   126       7.910  20.508   0.352  1.00 11.41           N  
ATOM    898  CA  VAL   126       8.910  19.489   0.690  0.50 11.13           C  
ATOM    900  C   VAL   126       8.685  19.016   2.122  1.00 13.15           C  
ATOM    901  O   VAL   126       8.677  17.830   2.410  1.00 13.62           O  
ATOM    902  CB  VAL   126      10.345  20.061   0.529  0.50 10.09           C  
ATOM    904  CG1 VAL   126      11.411  19.100   1.079  0.50 11.60           C  
ATOM    906  CG2 VAL   126      10.613  20.356  -0.940  0.50 10.13           C  
ATOM    908  N   SER   127       8.487  19.987   3.015  1.00 11.21           N  
ATOM    909  CA  SER   127       8.267  19.704   4.430  0.50 10.89           C  
ATOM    911  C   SER   127       6.994  18.889   4.674  1.00 11.26           C  
ATOM    912  O   SER   127       6.967  18.010   5.536  1.00 11.71           O  
ATOM    913  CB  SER   127       8.213  21.012   5.205  0.50 13.85           C  
ATOM    915  OG  SER   127       8.144  20.775   6.582  0.50 12.04           O  
ATOM    917  N   TYR   128       5.929  19.213   3.931  1.00 10.99           N  
ATOM    918  CA  TYR   128       4.664  18.487   4.046  1.00 10.36           C  
ATOM    919  C   TYR   128       4.840  17.017   3.689  1.00 12.02           C  
ATOM    920  O   TYR   128       4.337  16.137   4.415  1.00 12.45           O  
ATOM    921  CB  TYR   128       3.616  19.131   3.143  1.00  9.90           C  
ATOM    922  CG  TYR   128       2.374  18.311   2.989  1.00 10.64           C  
ATOM    923  CD1 TYR   128       1.401  18.313   3.990  1.00 12.75           C  
ATOM    924  CD2 TYR   128       2.149  17.576   1.838  1.00 10.69           C  
ATOM    925  CE1 TYR   128       0.231  17.571   3.847  1.00 12.99           C  
ATOM    926  CE2 TYR   128       1.000  16.796   1.690  1.00 14.34           C  
ATOM    927  CZ  TYR   128       0.037  16.811   2.701  1.00 14.74           C  
ATOM    928  OH  TYR   128      -1.130  16.062   2.554  1.00 19.35           O  
ATOM    929  N   GLN   129       5.561  16.745   2.587  1.00 12.30           N  
ATOM    930  CA  GLN   129       5.778  15.368   2.159  0.50 11.89           C  
ATOM    932  C   GLN   129       6.551  14.579   3.213  1.00 11.90           C  
ATOM    933  O   GLN   129       6.223  13.433   3.494  1.00 13.97           O  
ATOM    934  CB  GLN   129       6.463  15.319   0.790  0.50 17.43           C  
ATOM    936  CG  GLN   129       5.564  15.766  -0.373  0.50 21.28           C  
ATOM    938  CD  GLN   129       4.328  14.888  -0.571  0.50 27.50           C  
ATOM    940  OE1 GLN   129       3.227  15.395  -0.790  0.50 37.10           O  
ATOM    942  NE2 GLN   129       4.507  13.573  -0.502  0.50 39.43           N  
ATOM    944  N   ILE   130       7.546  15.214   3.816  1.00 10.99           N  
ATOM    945  CA  ILE   130       8.265  14.597   4.924  1.00 11.28           C  
ATOM    946  C   ILE   130       7.298  14.331   6.093  1.00 10.32           C  
ATOM    947  O   ILE   130       7.309  13.247   6.687  1.00 11.94           O  
ATOM    948  CB  ILE   130       9.456  15.480   5.369  1.00 10.79           C  
ATOM    949  CG1 ILE   130      10.539  15.476   4.263  1.00 12.69           C  
ATOM    950  CG2 ILE   130       9.987  15.048   6.769  1.00 11.24           C  
ATOM    951  CD1 ILE   130      11.663  16.488   4.451  1.00 13.94           C  
ATOM    952  N   GLY   131       6.468  15.325   6.412  1.00 10.56           N  
ATOM    953  CA  GLY   131       5.536  15.217   7.541  1.00 10.56           C  
ATOM    954  C   GLY   131       4.578  14.052   7.347  1.00 12.07           C  
ATOM    955  O   GLY   131       4.317  13.291   8.292  1.00 12.17           O  
ATOM    956  N   GLN   132       4.050  13.892   6.134  1.00 12.52           N  
ATOM    957  CA  GLN   132       3.177  12.763   5.827  1.00 13.85           C  
ATOM    958  C   GLN   132       3.827  11.420   6.131  1.00 11.58           C  
ATOM    959  O   GLN   132       3.199  10.536   6.740  1.00 13.19           O  
ATOM    960  CB  GLN   132       2.736  12.814   4.359  1.00 13.17           C  
ATOM    961  CG  GLN   132       1.733  13.902   4.071  1.00 16.82           C  
ATOM    962  CD  GLN   132       0.401  13.611   4.732  1.00 20.54           C  
ATOM    963  OE1 GLN   132       0.089  14.171   5.780  1.00 22.06           O  
ATOM    964  NE2 GLN   132      -0.378  12.700   4.144  1.00 24.13           N  
ATOM    965  N   ARG   133       5.088  11.261   5.723  1.00 11.88           N  
ATOM    966  CA  ARG   133       5.782   9.999   5.936  1.00 11.18           C  
ATOM    967  C   ARG   133       6.121   9.800   7.426  1.00 10.84           C  
ATOM    968  O   ARG   133       6.039   8.693   7.944  1.00 12.01           O  
ATOM    969  CB  ARG   133       7.005   9.914   5.020  1.00 12.43           C  
ATOM    970  CG  ARG   133       7.758   8.586   5.061  1.00 13.14           C  
ATOM    971  CD  ARG   133       6.902   7.426   4.535  1.00 14.39           C  
ATOM    972  NE  ARG   133       7.781   6.378   4.031  1.00 18.04           N  
ATOM    973  CZ  ARG   133       7.380   5.306   3.371  1.00 15.95           C  
ATOM    974  NH1 ARG   133       6.083   5.109   3.148  1.00 18.22           N  
ATOM    975  NH2 ARG   133       8.277   4.420   2.952  1.00 17.71           N  
ATOM    976  N   VAL   134       6.483  10.879   8.117  1.00 11.86           N  
ATOM    977  CA  VAL   134       6.704  10.813   9.564  1.00 11.94           C  
ATOM    978  C   VAL   134       5.443  10.329  10.269  1.00 10.69           C  
ATOM    979  O   VAL   134       5.500   9.471  11.160  1.00 12.44           O  
ATOM    980  CB  VAL   134       7.171  12.173  10.137  1.00 11.36           C  
ATOM    981  CG1 VAL   134       7.164  12.156  11.665  1.00 11.92           C  
ATOM    982  CG2 VAL   134       8.567  12.493   9.608  1.00 13.37           C  
ATOM    983  N   MET   135       4.291  10.852   9.860  1.00 11.80           N  
ATOM    984  CA  MET   135       3.045  10.414  10.507  1.00 12.72           C  
ATOM    985  C   MET   135       2.715   8.968  10.190  1.00 12.07           C  
ATOM    986  O   MET   135       2.195   8.258  11.064  1.00 12.57           O  
ATOM    987  CB  MET   135       1.880  11.317  10.131  1.00 13.33           C  
ATOM    988  CG  MET   135       2.034  12.771  10.541  1.00 14.97           C  
ATOM    989  SD  MET   135       2.476  12.977  12.442  0.70 14.74          SE  
ATOM    990  CE  MET   135       0.918  12.078  13.211  1.00 17.71           C  
ATOM    991  N   GLU   136       3.011   8.522   8.968  1.00 13.34           N  
ATOM    992  CA  GLU   136       2.786   7.116   8.638  1.00 14.66           C  
ATOM    993  C   GLU   136       3.637   6.218   9.539  1.00 13.86           C  
ATOM    994  O   GLU   136       3.169   5.190  10.048  1.00 14.68           O  
ATOM    995  CB  GLU   136       3.073   6.851   7.158  1.00 14.11           C  
ATOM    996  CG  GLU   136       2.850   5.419   6.721  1.00 19.12           C  
ATOM    997  CD  GLU   136       3.271   5.132   5.281  1.00 25.99           C  
ATOM    998  OE1 GLU   136       3.825   6.028   4.592  1.00 22.32           O  
ATOM    999  OE2 GLU   136       3.039   3.978   4.856  1.00 26.05           O  
ATOM   1000  N   ILE   137       4.866   6.651   9.806  1.00 11.87           N  
ATOM   1001  CA  ILE   137       5.759   5.917  10.725  1.00 12.27           C  
ATOM   1002  C   ILE   137       5.200   5.972  12.152  1.00 14.18           C  
ATOM   1003  O   ILE   137       5.159   4.958  12.879  1.00 14.08           O  
ATOM   1004  CB  ILE   137       7.197   6.523  10.671  1.00 14.79           C  
ATOM   1005  CG1 ILE   137       7.818   6.226   9.301  1.00 14.66           C  
ATOM   1006  CG2 ILE   137       8.092   6.057  11.823  1.00 17.41           C  
ATOM   1007  CD1 ILE   137       9.049   7.054   8.968  1.00 14.56           C  
ATOM   1008  N   ALA   138       4.756   7.155  12.564  1.00 13.36           N  
ATOM   1009  CA  ALA   138       4.239   7.308  13.920  1.00 15.50           C  
ATOM   1010  C   ALA   138       3.055   6.392  14.183  1.00 17.10           C  
ATOM   1011  O   ALA   138       3.029   5.691  15.197  1.00 17.07           O  
ATOM   1012  CB  ALA   138       3.863   8.740  14.187  1.00 14.77           C  
ATOM   1013  N   VAL   139       2.076   6.364  13.290  1.00 14.22           N  
ATOM   1014  CA  VAL   139       0.893   5.559  13.602  1.00 17.81           C  
ATOM   1015  C   VAL   139       1.211   4.051  13.593  1.00 16.57           C  
ATOM   1016  O   VAL   139       0.520   3.268  14.255  1.00 18.88           O  
ATOM   1017  CB  VAL   139      -0.350   5.940  12.747  1.00 25.03           C  
ATOM   1018  CG1 VAL   139      -0.700   7.418  12.942  1.00 23.47           C  
ATOM   1019  CG2 VAL   139      -0.116   5.632  11.315  1.00 23.85           C  
ATOM   1020  N   ARG   140       2.260   3.651  12.881  1.00 14.60           N  
ATOM   1021  CA  ARG   140       2.713   2.272  12.855  1.00 14.63           C  
ATOM   1022  C   ARG   140       3.375   1.842  14.176  1.00 14.50           C  
ATOM   1023  O   ARG   140       3.273   0.670  14.584  1.00 16.94           O  
ATOM   1024  CB  ARG   140       3.722   2.106  11.729  1.00 17.48           C  
ATOM   1025  CG  ARG   140       4.114   0.710  11.407  1.00 23.55           C  
ATOM   1026  CD  ARG   140       4.253   0.612   9.922  1.00 28.61           C  
ATOM   1027  NE  ARG   140       4.768  -0.681   9.510  1.00 35.75           N  
ATOM   1028  CZ  ARG   140       4.692  -1.131   8.267  1.00 23.47           C  
ATOM   1029  NH1 ARG   140       4.095  -0.390   7.329  1.00 25.25           N  
ATOM   1030  NH2 ARG   140       5.191  -2.319   7.969  1.00 33.07           N  
ATOM   1031  N   TYR   141       4.078   2.770  14.845  1.00 12.86           N  
ATOM   1032  CA  TYR   141       4.960   2.361  15.935  1.00 12.52           C  
ATOM   1033  C   TYR   141       4.629   2.955  17.296  1.00 10.49           C  
ATOM   1034  O   TYR   141       5.192   2.517  18.288  1.00 11.91           O  
ATOM   1035  CB  TYR   141       6.417   2.676  15.606  1.00 11.72           C  
ATOM   1036  CG  TYR   141       6.939   1.896  14.435  1.00 15.03           C  
ATOM   1037  CD1 TYR   141       7.106   0.514  14.520  1.00 15.39           C  
ATOM   1038  CD2 TYR   141       7.242   2.533  13.239  1.00 15.09           C  
ATOM   1039  CE1 TYR   141       7.577  -0.210  13.439  1.00 16.45           C  
ATOM   1040  CE2 TYR   141       7.712   1.832  12.159  1.00 17.80           C  
ATOM   1041  CZ  TYR   141       7.872   0.467  12.249  1.00 17.33           C  
ATOM   1042  OH  TYR   141       8.350  -0.169  11.125  1.00 18.29           O  
ATOM   1043  N   LEU   142       3.742   3.950  17.349  1.00 10.86           N  
ATOM   1044  CA  LEU   142       3.441   4.618  18.622  0.50 11.36           C  
ATOM   1046  C   LEU   142       2.571   3.806  19.548  1.00 13.48           C  
ATOM   1047  O   LEU   142       1.594   3.191  19.112  1.00 14.78           O  
ATOM   1048  CB  LEU   142       2.723   5.941  18.416  0.50 11.66           C  
ATOM   1050  CG  LEU   142       3.563   7.179  18.176  0.50  9.60           C  
ATOM   1052  CD1 LEU   142       2.600   8.224  17.674  0.50 14.73           C  
ATOM   1054  CD2 LEU   142       4.278   7.649  19.457  0.50 11.81           C  
ATOM   1056  N   ARG   143       2.901   3.846  20.837  1.00 12.69           N  
ATOM   1057  CA  ARG   143       2.033   3.237  21.845  1.00 13.33           C  
ATOM   1058  C   ARG   143       0.826   4.130  22.018  1.00 14.30           C  
ATOM   1059  O   ARG   143       0.884   5.351  21.765  1.00 14.62           O  
ATOM   1060  CB  ARG   143       2.752   3.055  23.194  1.00 15.19           C  
ATOM   1061  CG  ARG   143       3.082   4.318  23.972  1.00 13.79           C  
ATOM   1062  CD  ARG   143       3.539   3.944  25.394  1.00 16.54           C  
ATOM   1063  NE  ARG   143       3.892   5.104  26.190  1.00 18.51           N  
ATOM   1064  CZ  ARG   143       3.032   5.816  26.914  1.00 20.32           C  
ATOM   1065  NH1 ARG   143       1.738   5.491  26.943  1.00 23.94           N  
ATOM   1066  NH2 ARG   143       3.464   6.847  27.622  1.00 24.25           N  
ATOM   1067  N   ASN   144      -0.271   3.530  22.476  1.00 15.98           N  
ATOM   1068  CA  ASN   144      -1.406   4.304  22.952  0.50 16.67           C  
ATOM   1070  C   ASN   144      -0.921   5.238  24.030  1.00 14.32           C  
ATOM   1071  O   ASN   144      -0.252   4.786  24.965  1.00 16.71           O  
ATOM   1072  CB  ASN   144      -2.467   3.388  23.551  0.50 15.10           C  
ATOM   1074  CG  ASN   144      -3.203   2.613  22.509  0.50 27.23           C  
ATOM   1076  OD1 ASN   144      -3.474   3.128  21.432  0.50 29.27           O  
ATOM   1078  ND2 ASN   144      -3.542   1.362  22.818  0.50 20.43           N  
ATOM   1080  N   GLY   145      -1.245   6.519  23.892  1.00 13.95           N  
ATOM   1081  CA  GLY   145      -0.760   7.549  24.793  1.00 13.60           C  
ATOM   1082  C   GLY   145       0.538   8.244  24.347  1.00 15.52           C  
ATOM   1083  O   GLY   145       1.003   9.170  25.010  1.00 19.43           O  
ATOM   1084  N   GLY   146       1.119   7.788  23.235  1.00 14.32           N  
ATOM   1085  CA  GLY   146       2.390   8.342  22.745  1.00 14.96           C  
ATOM   1086  C   GLY   146       2.242   9.696  22.063  1.00 12.11           C  
ATOM   1087  O   GLY   146       1.129  10.096  21.713  1.00 12.15           O  
ATOM   1088  N   ASN   147       3.368  10.378  21.882  1.00 12.02           N  
ATOM   1089  CA  ASN   147       3.384  11.718  21.315  1.00 10.79           C  
ATOM   1090  C   ASN   147       4.188  11.817  20.029  1.00 11.00           C  
ATOM   1091  O   ASN   147       5.095  11.005  19.790  1.00 10.12           O  
ATOM   1092  CB  ASN   147       4.028  12.711  22.298  1.00 13.03           C  
ATOM   1093  CG  ASN   147       3.254  12.859  23.595  1.00 14.49           C  
ATOM   1094  OD1 ASN   147       2.062  12.540  23.674  1.00 14.43           O  
ATOM   1095  ND2 ASN   147       3.935  13.349  24.618  1.00 15.04           N  
ATOM   1096  N   VAL   148       3.875  12.836  19.229  1.00 10.08           N  
ATOM   1097  CA  VAL   148       4.678  13.200  18.054  1.00 10.32           C  
ATOM   1098  C   VAL   148       5.112  14.659  18.127  1.00 10.96           C  
ATOM   1099  O   VAL   148       4.328  15.526  18.524  1.00 12.33           O  
ATOM   1100  CB  VAL   148       3.911  12.970  16.729  1.00 11.82           C  
ATOM   1101  CG1 VAL   148       4.750  13.388  15.517  1.00 13.57           C  
ATOM   1102  CG2 VAL   148       3.550  11.547  16.594  1.00 13.33           C  
ATOM   1103  N   LEU   149       6.360  14.917  17.737  1.00  9.54           N  
ATOM   1104  CA  LEU   149       6.847  16.284  17.535  1.00 10.13           C  
ATOM   1105  C   LEU   149       7.401  16.330  16.129  1.00  9.76           C  
ATOM   1106  O   LEU   149       8.202  15.491  15.769  1.00 10.76           O  
ATOM   1107  CB  LEU   149       7.977  16.622  18.518  1.00 12.13           C  
ATOM   1108  CG  LEU   149       8.880  17.829  18.198  1.00 11.89           C  
ATOM   1109  CD1 LEU   149       8.058  19.099  18.208  1.00 13.01           C  
ATOM   1110  CD2 LEU   149      10.021  17.909  19.210  1.00 14.70           C  
ATOM   1111  N   LEU   150       6.970  17.296  15.313  1.00  8.99           N  
ATOM   1112  CA  LEU   150       7.511  17.380  13.962  0.50 11.44           C  
ATOM   1114  C   LEU   150       7.656  18.800  13.473  1.00 12.24           C  
ATOM   1115  O   LEU   150       6.793  19.675  13.686  1.00 12.49           O  
ATOM   1116  CB  LEU   150       6.712  16.536  12.949  0.50 20.07           C  
ATOM   1118  CG  LEU   150       5.352  17.056  12.470  0.50 21.76           C  
ATOM   1120  CD1 LEU   150       5.133  16.793  10.984  0.50 23.31           C  
ATOM   1122  CD2 LEU   150       4.213  16.474  13.281  0.50 26.23           C  
ATOM   1124  N   LYS   151       8.809  19.031  12.839  1.00 11.05           N  
ATOM   1125  CA  LYS   151       9.069  20.312  12.200  1.00 12.47           C  
ATOM   1126  C   LYS   151       8.279  20.375  10.888  1.00 12.07           C  
ATOM   1127  O   LYS   151       8.258  19.406  10.103  1.00 11.40           O  
ATOM   1128  CB  LYS   151      10.563  20.476  11.890  1.00 15.74           C  
ATOM   1129  CG  LYS   151      10.857  21.850  11.284  1.00 15.82           C  
ATOM   1130  CD  LYS   151      12.303  22.226  11.298  1.00 23.41           C  
ATOM   1131  CE  LYS   151      13.066  21.415  10.296  1.00 23.56           C  
ATOM   1132  NZ  LYS   151      14.517  21.541  10.640  1.00 28.21           N  
ATOM   1133  N   GLN   152       7.663  21.529  10.632  1.00 11.33           N  
ATOM   1134  CA  GLN   152       7.024  21.794   9.346  1.00  9.32           C  
ATOM   1135  C   GLN   152       7.236  23.254   8.961  1.00 13.53           C  
ATOM   1136  O   GLN   152       7.270  24.131   9.811  1.00 16.85           O  
ATOM   1137  CB  GLN   152       5.521  21.478   9.397  1.00 11.40           C  
ATOM   1138  CG  GLN   152       4.805  21.567   8.029  1.00 12.88           C  
ATOM   1139  CD  GLN   152       3.428  20.909   7.999  1.00 15.18           C  
ATOM   1140  OE1 GLN   152       2.407  21.585   7.807  1.00 16.33           O  
ATOM   1141  NE2 GLN   152       3.394  19.588   8.162  1.00 13.42           N  
ATOM   1142  N   PHE   153       7.390  23.505   7.673  1.00 11.92           N  
ATOM   1143  CA  PHE   153       7.368  24.860   7.177  1.00 13.28           C  
ATOM   1144  C   PHE   153       5.909  25.142   6.823  1.00 12.52           C  
ATOM   1145  O   PHE   153       5.315  24.398   6.033  1.00 14.65           O  
ATOM   1146  CB  PHE   153       8.313  24.968   5.976  1.00 16.75           C  
ATOM   1147  CG  PHE   153       9.772  25.034   6.367  1.00 15.41           C  
ATOM   1148  CD1 PHE   153      10.418  26.266   6.415  1.00 23.92           C  
ATOM   1149  CD2 PHE   153      10.488  23.902   6.733  1.00 18.53           C  
ATOM   1150  CE1 PHE   153      11.767  26.364   6.787  1.00 25.02           C  
ATOM   1151  CE2 PHE   153      11.851  24.006   7.130  1.00 18.44           C  
ATOM   1152  CZ  PHE   153      12.476  25.232   7.132  1.00 23.62           C  
ATOM   1153  N   GLN   154       5.336  26.191   7.414  1.00 12.75           N  
ATOM   1154  CA  GLN   154       3.898  26.435   7.325  1.00 14.37           C  
ATOM   1155  C   GLN   154       3.474  26.798   5.902  1.00 14.38           C  
ATOM   1156  O   GLN   154       4.179  27.504   5.181  1.00 13.34           O  
ATOM   1157  CB  GLN   154       3.497  27.565   8.284  1.00 18.17           C  
ATOM   1158  CG  GLN   154       1.971  27.723   8.437  1.00 23.89           C  
ATOM   1159  CD  GLN   154       1.567  28.266   9.789  1.00 37.14           C  
ATOM   1160  OE1 GLN   154       2.246  29.124  10.356  1.00 41.97           O  
ATOM   1161  NE2 GLN   154       0.451  27.766  10.318  1.00 46.60           N  
ATOM   1162  N   GLY   155       2.301  26.314   5.515  1.00 11.64           N  
ATOM   1163  CA  GLY   155       1.732  26.708   4.223  1.00 11.82           C  
ATOM   1164  C   GLY   155       0.327  26.182   4.073  1.00 11.40           C  
ATOM   1165  O   GLY   155      -0.336  25.849   5.060  1.00 12.08           O  
ATOM   1166  N   ASP   156      -0.138  26.104   2.830  1.00 11.38           N  
ATOM   1167  CA  ASP   156      -1.538  25.804   2.554  1.00 12.44           C  
ATOM   1168  C   ASP   156      -1.982  24.534   3.272  1.00 13.47           C  
ATOM   1169  O   ASP   156      -3.104  24.452   3.772  1.00 14.62           O  
ATOM   1170  CB  ASP   156      -1.768  25.664   1.048  1.00 11.62           C  
ATOM   1171  CG  ASP   156      -1.751  26.999   0.330  1.00 14.84           C  
ATOM   1172  OD1 ASP   156      -1.882  28.041   1.006  1.00 13.69           O  
ATOM   1173  OD2 ASP   156      -1.606  27.007  -0.911  1.00 14.10           O  
ATOM   1174  N   MET   157      -1.095  23.545   3.319  1.00 11.53           N  
ATOM   1175  CA  MET   157      -1.484  22.182   3.659  1.00 12.40           C  
ATOM   1176  C   MET   157      -1.526  21.982   5.170  1.00 10.48           C  
ATOM   1177  O   MET   157      -1.946  20.932   5.656  1.00 12.88           O  
ATOM   1178  CB  MET   157      -0.524  21.176   3.022  1.00 13.36           C  
ATOM   1179  CG  MET   157      -0.571  21.150   1.503  1.00 11.62           C  
ATOM   1180  SD  MET   157      -2.370  20.854   0.810  0.70 16.42          SE  
ATOM   1181  CE  MET   157      -2.754  19.154   1.684  1.00 16.01           C  
ATOM   1182  N   THR   158      -1.087  22.996   5.909  1.00 11.91           N  
ATOM   1183  CA  THR   158      -0.832  22.849   7.346  1.00 11.22           C  
ATOM   1184  C   THR   158      -2.101  22.627   8.154  1.00 13.90           C  
ATOM   1185  O   THR   158      -2.183  21.670   8.935  1.00 11.92           O  
ATOM   1186  CB  THR   158      -0.027  24.021   7.916  1.00 12.96           C  
ATOM   1187  OG1 THR   158       1.250  24.065   7.252  1.00 12.46           O  
ATOM   1188  CG2 THR   158       0.188  23.831   9.441  1.00 15.05           C  
ATOM   1189  N   ASN   159      -3.103  23.472   7.928  1.00 13.35           N  
ATOM   1190  CA  ASN   159      -4.340  23.307   8.693  1.00 14.30           C  
ATOM   1191  C   ASN   159      -5.052  22.013   8.390  1.00 12.35           C  
ATOM   1192  O   ASN   159      -5.561  21.352   9.306  1.00 15.82           O  
ATOM   1193  CB  ASN   159      -5.285  24.484   8.480  1.00 16.47           C  
ATOM   1194  CG  ASN   159      -4.833  25.709   9.213  1.00 21.05           C  
ATOM   1195  OD1 ASN   159      -3.877  25.658   9.986  1.00 22.39           O  
ATOM   1196  ND2 ASN   159      -5.512  26.828   8.978  1.00 24.55           N  
ATOM   1197  N   ASP   160      -5.045  21.608   7.117  1.00 13.38           N  
ATOM   1198  CA  ASP   160      -5.652  20.343   6.741  0.50 12.59           C  
ATOM   1200  C   ASP   160      -4.886  19.124   7.297  1.00 14.86           C  
ATOM   1201  O   ASP   160      -5.504  18.139   7.723  1.00 17.44           O  
ATOM   1202  CB  ASP   160      -5.838  20.269   5.214  0.50 16.57           C  
ATOM   1204  CG  ASP   160      -7.056  21.076   4.719  0.50 22.87           C  
ATOM   1206  OD1 ASP   160      -7.115  22.314   4.906  0.50 15.88           O  
ATOM   1208  OD2 ASP   160      -7.956  20.470   4.094  0.50 19.25           O  
ATOM   1210  N   PHE   161      -3.549  19.211   7.316  1.00 14.31           N  
ATOM   1211  CA  PHE   161      -2.656  18.197   7.890  1.00 14.03           C  
ATOM   1212  C   PHE   161      -3.006  17.995   9.378  1.00 11.91           C  
ATOM   1213  O   PHE   161      -3.197  16.851   9.829  1.00 14.86           O  
ATOM   1214  CB  PHE   161      -1.192  18.665   7.692  1.00 12.85           C  
ATOM   1215  CG  PHE   161      -0.150  17.778   8.326  1.00 12.52           C  
ATOM   1216  CD1 PHE   161       0.404  16.743   7.591  1.00 15.17           C  
ATOM   1217  CD2 PHE   161       0.321  18.003   9.640  1.00 12.26           C  
ATOM   1218  CE1 PHE   161       1.376  15.926   8.139  1.00 15.39           C  
ATOM   1219  CE2 PHE   161       1.292  17.175  10.192  1.00 14.73           C  
ATOM   1220  CZ  PHE   161       1.819  16.153   9.435  1.00 14.16           C  
ATOM   1221  N   ILE   162      -3.104  19.107  10.108  1.00 12.59           N  
ATOM   1222  CA  ILE   162      -3.429  19.063  11.516  1.00 13.26           C  
ATOM   1223  C   ILE   162      -4.823  18.505  11.726  1.00 14.67           C  
ATOM   1224  O   ILE   162      -4.990  17.642  12.585  1.00 17.12           O  
ATOM   1225  CB  ILE   162      -3.250  20.441  12.162  1.00 13.98           C  
ATOM   1226  CG1 ILE   162      -1.761  20.787  12.181  1.00 15.65           C  
ATOM   1227  CG2 ILE   162      -3.835  20.489  13.604  1.00 16.81           C  
ATOM   1228  CD1 ILE   162      -1.495  22.170  12.613  1.00 16.81           C  
ATOM   1229  N   ALA   163      -5.789  18.953  10.912  1.00 13.67           N  
ATOM   1230  CA  ALA   163      -7.183  18.497  11.059  1.00 15.76           C  
ATOM   1231  C   ALA   163      -7.291  16.988  10.871  1.00 17.54           C  
ATOM   1232  O   ALA   163      -8.055  16.321  11.584  1.00 20.78           O  
ATOM   1233  CB  ALA   163      -8.095  19.224  10.095  1.00 17.98           C  
ATOM   1234  N   ILE   164      -6.536  16.441   9.913  1.00 15.90           N  
ATOM   1235  CA  ILE   164      -6.589  15.011   9.610  1.00 16.22           C  
ATOM   1236  C   ILE   164      -5.888  14.208  10.704  1.00 19.24           C  
ATOM   1237  O   ILE   164      -6.469  13.282  11.287  1.00 20.94           O  
ATOM   1238  CB  ILE   164      -6.008  14.690   8.200  1.00 19.88           C  
ATOM   1239  CG1 ILE   164      -6.947  15.210   7.097  1.00 22.44           C  
ATOM   1240  CG2 ILE   164      -5.752  13.191   8.028  1.00 22.35           C  
ATOM   1241  CD1 ILE   164      -6.292  15.382   5.739  1.00 28.45           C  
ATOM   1242  N   TRP   165      -4.650  14.577  11.016  1.00 15.75           N  
ATOM   1243  CA  TRP   165      -3.852  13.749  11.922  1.00 19.10           C  
ATOM   1244  C   TRP   165      -4.288  13.829  13.376  1.00 15.64           C  
ATOM   1245  O   TRP   165      -4.101  12.864  14.129  1.00 18.93           O  
ATOM   1246  CB  TRP   165      -2.349  14.030  11.765  1.00 16.07           C  
ATOM   1247  CG  TRP   165      -1.815  13.501  10.472  1.00 15.98           C  
ATOM   1248  CD1 TRP   165      -1.403  14.233   9.384  1.00 17.48           C  
ATOM   1249  CD2 TRP   165      -1.671  12.121  10.097  1.00 14.31           C  
ATOM   1250  NE1 TRP   165      -0.997  13.397   8.376  1.00 16.98           N  
ATOM   1251  CE2 TRP   165      -1.163  12.098   8.779  1.00 17.19           C  
ATOM   1252  CE3 TRP   165      -1.905  10.903  10.753  1.00 18.10           C  
ATOM   1253  CZ2 TRP   165      -0.875  10.903   8.105  1.00 17.54           C  
ATOM   1254  CZ3 TRP   165      -1.634   9.719  10.074  1.00 17.05           C  
ATOM   1255  CH2 TRP   165      -1.119   9.728   8.771  1.00 19.78           C  
ATOM   1256  N   ARG   166      -4.891  14.955  13.767  1.00 14.46           N  
ATOM   1257  CA  ARG   166      -5.303  15.123  15.173  1.00 17.91           C  
ATOM   1258  C   ARG   166      -6.444  14.205  15.583  1.00 18.87           C  
ATOM   1259  O   ARG   166      -6.679  14.029  16.777  1.00 22.29           O  
ATOM   1260  CB  ARG   166      -5.641  16.572  15.522  1.00 22.23           C  
ATOM   1261  CG  ARG   166      -6.984  17.076  15.044  1.00 22.75           C  
ATOM   1262  CD  ARG   166      -7.045  18.555  15.325  1.00 33.12           C  
ATOM   1263  NE  ARG   166      -8.271  19.178  14.863  1.00 34.39           N  
ATOM   1264  CZ  ARG   166      -9.360  19.321  15.608  1.00 42.29           C  
ATOM   1265  NH1 ARG   166     -10.426  19.909  15.088  1.00 44.12           N  
ATOM   1266  NH2 ARG   166      -9.383  18.880  16.860  1.00 38.24           N  
ATOM   1267  N   LYS   167      -7.109  13.605  14.595  1.00 20.24           N  
ATOM   1268  CA  LYS   167      -8.148  12.593  14.833  1.00 22.36           C  
ATOM   1269  C   LYS   167      -7.604  11.337  15.528  1.00 23.24           C  
ATOM   1270  O   LYS   167      -8.370  10.587  16.133  1.00 23.92           O  
ATOM   1271  CB  LYS   167      -8.811  12.209  13.513  1.00 21.65           C  
ATOM   1272  CG  LYS   167      -9.668  13.306  12.912  1.00 25.38           C  
ATOM   1273  CD  LYS   167     -10.216  12.866  11.556  1.00 37.24           C  
ATOM   1274  CE  LYS   167     -11.133  13.921  10.960  1.00 47.22           C  
ATOM   1275  NZ  LYS   167     -11.554  13.576   9.571  1.00 57.19           N  
ATOM   1276  N   ASN   168      -6.291  11.106  15.434  1.00 20.02           N  
ATOM   1277  CA  ASN   168      -5.632   9.961  16.092  1.00 21.18           C  
ATOM   1278  C   ASN   168      -5.032  10.308  17.460  1.00 17.20           C  
ATOM   1279  O   ASN   168      -4.284   9.511  18.038  1.00 18.97           O  
ATOM   1280  CB  ASN   168      -4.524   9.384  15.204  1.00 24.01           C  
ATOM   1281  CG  ASN   168      -4.997   9.070  13.807  1.00 29.97           C  
ATOM   1282  OD1 ASN   168      -5.571   8.016  13.556  1.00 38.36           O  
ATOM   1283  ND2 ASN   168      -4.750   9.988  12.884  1.00 35.11           N  
ATOM   1284  N   PHE   169      -5.329  11.504  17.958  1.00 17.50           N  
ATOM   1285  CA  PHE   169      -4.700  12.009  19.172  1.00 19.00           C  
ATOM   1286  C   PHE   169      -5.681  12.734  20.095  1.00 19.40           C  
ATOM   1287  O   PHE   169      -6.741  13.197  19.659  1.00 22.92           O  
ATOM   1288  CB  PHE   169      -3.525  12.940  18.830  1.00 15.77           C  
ATOM   1289  CG  PHE   169      -2.365  12.233  18.154  1.00 13.65           C  
ATOM   1290  CD1 PHE   169      -1.297  11.733  18.900  1.00 12.61           C  
ATOM   1291  CD2 PHE   169      -2.314  12.125  16.767  1.00 12.39           C  
ATOM   1292  CE1 PHE   169      -0.211  11.096  18.262  1.00 12.66           C  
ATOM   1293  CE2 PHE   169      -1.247  11.496  16.134  1.00 12.84           C  
ATOM   1294  CZ  PHE   169      -0.203  10.980  16.878  1.00 13.03           C  
ATOM   1295  N   SER   170      -5.303  12.819  21.366  1.00 17.70           N  
ATOM   1296  CA  SER   170      -6.109  13.503  22.370  0.50 20.33           C  
ATOM   1298  C   SER   170      -6.104  15.017  22.173  1.00 23.24           C  
ATOM   1299  O   SER   170      -7.136  15.682  22.371  1.00 22.67           O  
ATOM   1300  CB  SER   170      -5.616  13.134  23.771  0.50 21.72           C  
ATOM   1302  OG  SER   170      -5.662  11.732  23.953  0.50 23.48           O  
ATOM   1304  N   SER   171      -4.957  15.564  21.759  1.00 17.62           N  
ATOM   1305  CA  SER   171      -4.808  16.999  21.555  1.00 17.90           C  
ATOM   1306  C   SER   171      -3.626  17.327  20.640  1.00 17.62           C  
ATOM   1307  O   SER   171      -2.849  16.447  20.276  1.00 16.20           O  
ATOM   1308  CB  SER   171      -4.610  17.718  22.896  1.00 18.97           C  
ATOM   1309  OG  SER   171      -3.388  17.332  23.527  1.00 20.91           O  
ATOM   1310  N   TYR   172      -3.493  18.594  20.270  1.00 15.71           N  
ATOM   1311  CA  TYR   172      -2.332  19.040  19.515  1.00 14.60           C  
ATOM   1312  C   TYR   172      -1.932  20.430  19.958  1.00 17.02           C  
ATOM   1313  O   TYR   172      -2.754  21.163  20.549  1.00 16.90           O  
ATOM   1314  CB  TYR   172      -2.604  19.043  17.992  1.00 15.60           C  
ATOM   1315  CG  TYR   172      -3.399  20.235  17.502  1.00 19.02           C  
ATOM   1316  CD1 TYR   172      -2.763  21.389  17.030  1.00 20.38           C  
ATOM   1317  CD2 TYR   172      -4.788  20.208  17.515  1.00 25.26           C  
ATOM   1318  CE1 TYR   172      -3.497  22.490  16.604  1.00 18.75           C  
ATOM   1319  CE2 TYR   172      -5.525  21.289  17.071  1.00 25.40           C  
ATOM   1320  CZ  TYR   172      -4.884  22.419  16.629  1.00 23.67           C  
ATOM   1321  OH  TYR   172      -5.637  23.489  16.188  1.00 26.51           O  
ATOM   1322  N   LYS   173      -0.678  20.787  19.672  1.00 16.10           N  
ATOM   1323  CA  LYS   173      -0.171  22.147  19.859  0.50 15.36           C  
ATOM   1325  C   LYS   173       0.734  22.529  18.698  1.00 16.51           C  
ATOM   1326  O   LYS   173       1.356  21.658  18.076  1.00 15.47           O  
ATOM   1327  CB  LYS   173       0.607  22.279  21.172  0.50 17.13           C  
ATOM   1329  CG  LYS   173      -0.230  22.012  22.410  0.50 21.46           C  
ATOM   1331  CD  LYS   173       0.334  22.672  23.637  0.50 30.27           C  
ATOM   1333  CE  LYS   173      -0.307  22.140  24.905  0.50 31.83           C  
ATOM   1335  NZ  LYS   173      -1.758  22.461  24.978  0.50 23.82           N  
ATOM   1337  N   ILE   174       0.794  23.824  18.398  1.00 13.68           N  
ATOM   1338  CA  ILE   174       1.722  24.383  17.440  1.00 14.31           C  
ATOM   1339  C   ILE   174       2.597  25.396  18.178  1.00 15.81           C  
ATOM   1340  O   ILE   174       2.093  26.174  19.012  1.00 17.33           O  
ATOM   1341  CB  ILE   174       1.006  25.076  16.237  1.00 18.32           C  
ATOM   1342  CG1 ILE   174       0.082  24.091  15.519  1.00 22.53           C  
ATOM   1343  CG2 ILE   174       2.014  25.674  15.248  1.00 22.62           C  
ATOM   1344  CD1 ILE   174      -1.106  24.804  14.872  1.00 36.94           C  
ATOM   1345  N   SER   175       3.893  25.376  17.889  1.00 16.05           N  
ATOM   1346  CA  SER   175       4.820  26.356  18.433  1.00 16.42           C  
ATOM   1347  C   SER   175       5.801  26.935  17.420  1.00 24.16           C  
ATOM   1348  O   SER   175       6.188  26.265  16.461  1.00 19.16           O  
ATOM   1349  CB  SER   175       5.643  25.705  19.546  1.00 19.60           C  
ATOM   1350  OG  SER   175       6.513  26.650  20.151  1.00 23.47           O  
ATOM   1351  N   LYS   176       6.232  28.170  17.687  1.00 30.96           N  
ATOM   1352  CA  LYS   176       7.315  28.823  16.943  0.50 37.46           C  
ATOM   1354  C   LYS   176       8.448  29.228  17.907  1.00 40.47           C  
ATOM   1355  O   LYS   176       8.335  30.246  18.600  1.00 45.07           O  
ATOM   1356  CB  LYS   176       6.798  30.064  16.190  0.50 38.18           C  
ATOM   1358  CG  LYS   176       5.703  29.805  15.147  0.50 39.96           C  
ATOM   1360  CD  LYS   176       4.298  30.018  15.707  0.50 42.89           C  
ATOM   1362  CE  LYS   176       3.237  29.878  14.626  0.50 42.91           C  
ATOM   1364  NZ  LYS   176       1.858  30.045  15.160  0.50 44.53           N  
ATOM   1366  N   PRO   177       9.544  28.429  17.976  1.00 44.39           N  
ATOM   1367  CA  PRO   177      10.685  28.789  18.851  1.00 46.09           C  
ATOM   1368  C   PRO   177      11.475  30.021  18.408  1.00 45.73           C  
ATOM   1369  O   PRO   177      11.329  30.472  17.274  1.00 44.57           O  
ATOM   1370  CB  PRO   177      11.591  27.550  18.789  1.00 46.13           C  
ATOM   1371  CG  PRO   177      10.723  26.457  18.270  1.00 45.78           C  
ATOM   1372  CD  PRO   177       9.781  27.134  17.319  1.00 47.03           C  
ATOM   1373  N   SER   184      11.206  32.146   8.615  1.00 47.14           N  
ATOM   1374  CA  SER   184      10.221  32.550   9.614  1.00 43.59           C  
ATOM   1375  C   SER   184       8.890  31.810   9.444  1.00 36.29           C  
ATOM   1376  O   SER   184       7.917  32.105  10.148  1.00 37.97           O  
ATOM   1377  CB  SER   184      10.008  34.074   9.592  1.00 48.80           C  
ATOM   1378  OG  SER   184       9.332  34.502   8.416  1.00 50.96           O  
ATOM   1379  N   SER   185       8.850  30.856   8.508  1.00 30.41           N  
ATOM   1380  CA  SER   185       7.675  29.994   8.338  1.00 26.29           C  
ATOM   1381  C   SER   185       7.817  28.621   9.031  1.00 21.47           C  
ATOM   1382  O   SER   185       6.892  27.818   8.996  1.00 18.11           O  
ATOM   1383  CB  SER   185       7.316  29.817   6.853  1.00 28.47           C  
ATOM   1384  OG  SER   185       8.319  29.111   6.138  1.00 27.82           O  
ATOM   1385  N   GLU   186       8.963  28.371   9.663  1.00 18.19           N  
ATOM   1386  CA  GLU   186       9.182  27.112  10.398  1.00 18.84           C  
ATOM   1387  C   GLU   186       8.323  27.056  11.661  1.00 17.96           C  
ATOM   1388  O   GLU   186       8.293  28.003  12.456  1.00 19.32           O  
ATOM   1389  CB  GLU   186      10.659  27.004  10.755  1.00 23.73           C  
ATOM   1390  CG  GLU   186      11.044  25.796  11.583  1.00 28.26           C  
ATOM   1391  CD  GLU   186      12.518  25.820  11.930  1.00 36.25           C  
ATOM   1392  OE1 GLU   186      13.340  25.634  11.009  1.00 41.09           O  
ATOM   1393  OE2 GLU   186      12.845  26.037  13.116  1.00 27.26           O  
ATOM   1394  N   ILE   187       7.595  25.952  11.832  1.00 12.61           N  
ATOM   1395  CA  ILE   187       6.822  25.734  13.033  1.00 14.48           C  
ATOM   1396  C   ILE   187       7.046  24.310  13.512  1.00 11.25           C  
ATOM   1397  O   ILE   187       7.566  23.463  12.777  1.00 12.69           O  
ATOM   1398  CB  ILE   187       5.292  25.927  12.794  1.00 13.62           C  
ATOM   1399  CG1 ILE   187       4.748  24.936  11.756  1.00 16.83           C  
ATOM   1400  CG2 ILE   187       4.981  27.380  12.355  1.00 16.35           C  
ATOM   1401  CD1 ILE   187       3.219  24.939  11.638  1.00 16.25           C  
ATOM   1402  N   TYR   188       6.645  24.058  14.740  1.00 12.52           N  
ATOM   1403  CA  TYR   188       6.685  22.709  15.280  1.00 11.12           C  
ATOM   1404  C   TYR   188       5.284  22.293  15.669  1.00 13.07           C  
ATOM   1405  O   TYR   188       4.590  23.002  16.389  1.00 15.22           O  
ATOM   1406  CB  TYR   188       7.650  22.636  16.469  1.00 12.16           C  
ATOM   1407  CG  TYR   188       9.091  22.682  15.995  1.00 14.96           C  
ATOM   1408  CD1 TYR   188       9.742  21.518  15.624  1.00 14.22           C  
ATOM   1409  CD2 TYR   188       9.788  23.895  15.877  1.00 24.10           C  
ATOM   1410  CE1 TYR   188      11.058  21.533  15.162  1.00 20.23           C  
ATOM   1411  CE2 TYR   188      11.132  23.920  15.405  1.00 17.23           C  
ATOM   1412  CZ  TYR   188      11.740  22.728  15.060  1.00 20.20           C  
ATOM   1413  OH  TYR   188      13.040  22.688  14.585  1.00 22.77           O  
ATOM   1414  N   ILE   189       4.848  21.170  15.112  1.00 10.86           N  
ATOM   1415  CA  ILE   189       3.551  20.614  15.382  1.00 11.58           C  
ATOM   1416  C   ILE   189       3.700  19.439  16.344  1.00 12.48           C  
ATOM   1417  O   ILE   189       4.542  18.576  16.131  1.00 10.76           O  
ATOM   1418  CB  ILE   189       2.904  20.096  14.062  1.00 12.23           C  
ATOM   1419  CG1 ILE   189       2.816  21.238  13.017  1.00 13.52           C  
ATOM   1420  CG2 ILE   189       1.567  19.495  14.350  1.00 13.92           C  
ATOM   1421  CD1 ILE   189       2.330  20.833  11.608  1.00 13.20           C  
ATOM   1422  N   MET   190       2.902  19.413  17.410  1.00 10.89           N  
ATOM   1423  CA  MET   190       2.932  18.331  18.373  1.00 10.73           C  
ATOM   1424  C   MET   190       1.579  17.719  18.511  1.00 11.66           C  
ATOM   1425  O   MET   190       0.586  18.426  18.642  1.00 14.15           O  
ATOM   1426  CB  MET   190       3.391  18.873  19.717  1.00 14.40           C  
ATOM   1427  CG  MET   190       4.825  19.361  19.671  1.00 11.28           C  
ATOM   1428  SD  MET   190       5.290  20.609  21.075  0.70 15.68          SE  
ATOM   1429  CE  MET   190       4.616  22.239  20.199  1.00 15.83           C  
ATOM   1430  N   PHE   191       1.553  16.402  18.473  1.00 10.91           N  
ATOM   1431  CA  PHE   191       0.346  15.645  18.712  1.00 11.71           C  
ATOM   1432  C   PHE   191       0.498  14.847  19.997  1.00 13.28           C  
ATOM   1433  O   PHE   191       1.502  14.154  20.182  1.00 12.81           O  
ATOM   1434  CB  PHE   191       0.085  14.710  17.541  1.00 13.21           C  
ATOM   1435  CG  PHE   191      -0.197  15.410  16.236  1.00 12.64           C  
ATOM   1436  CD1 PHE   191      -1.429  16.065  15.992  1.00 14.49           C  
ATOM   1437  CD2 PHE   191       0.749  15.408  15.237  1.00 14.78           C  
ATOM   1438  CE1 PHE   191      -1.683  16.692  14.767  1.00 15.89           C  
ATOM   1439  CE2 PHE   191       0.502  16.023  14.015  1.00 13.87           C  
ATOM   1440  CZ  PHE   191      -0.714  16.678  13.776  1.00 14.54           C  
ATOM   1441  N   PHE   192      -0.491  14.916  20.882  1.00 12.86           N  
ATOM   1442  CA  PHE   192      -0.370  14.302  22.207  1.00 14.39           C  
ATOM   1443  C   PHE   192      -1.384  13.187  22.416  1.00 12.55           C  
ATOM   1444  O   PHE   192      -2.570  13.360  22.102  1.00 16.09           O  
ATOM   1445  CB  PHE   192      -0.564  15.354  23.309  1.00 12.50           C  
ATOM   1446  CG  PHE   192       0.479  16.433  23.302  1.00 11.60           C  
ATOM   1447  CD1 PHE   192       1.676  16.297  24.024  1.00 11.91           C  
ATOM   1448  CD2 PHE   192       0.284  17.586  22.557  1.00 13.16           C  
ATOM   1449  CE1 PHE   192       2.655  17.302  23.997  1.00 13.78           C  
ATOM   1450  CE2 PHE   192       1.245  18.597  22.520  1.00 12.61           C  
ATOM   1451  CZ  PHE   192       2.436  18.460  23.242  1.00 15.38           C  
ATOM   1452  N   GLY   193      -0.922  12.057  22.946  1.00 13.98           N  
ATOM   1453  CA  GLY   193      -1.843  11.007  23.383  1.00 15.36           C  
ATOM   1454  C   GLY   193      -2.468  10.213  22.256  1.00 13.95           C  
ATOM   1455  O   GLY   193      -3.678  10.295  21.999  1.00 16.05           O  
ATOM   1456  N   PHE   194      -1.636   9.445  21.562  1.00 13.46           N  
ATOM   1457  CA  PHE   194      -2.059   8.635  20.433  1.00 11.69           C  
ATOM   1458  C   PHE   194      -3.164   7.669  20.824  1.00 13.52           C  
ATOM   1459  O   PHE   194      -3.112   7.089  21.889  1.00 16.71           O  
ATOM   1460  CB  PHE   194      -0.862   7.833  19.914  1.00 13.82           C  
ATOM   1461  CG  PHE   194      -1.163   6.995  18.710  1.00 16.03           C  
ATOM   1462  CD1 PHE   194      -1.590   7.578  17.524  1.00 14.81           C  
ATOM   1463  CD2 PHE   194      -1.003   5.620  18.770  1.00 16.98           C  
ATOM   1464  CE1 PHE   194      -1.858   6.788  16.397  1.00 18.56           C  
ATOM   1465  CE2 PHE   194      -1.271   4.813  17.657  1.00 23.43           C  
ATOM   1466  CZ  PHE   194      -1.702   5.406  16.461  1.00 18.74           C  
ATOM   1467  N   LYS   195      -4.139   7.516  19.967  1.00 18.76           N  
ATOM   1468  CA  LYS   195      -5.181   6.511  20.100  1.00 24.68           C  
ATOM   1469  C   LYS   195      -5.265   5.710  18.826  1.00 26.91           C  
ATOM   1470  O   LYS   195      -5.695   6.190  17.864  1.00 28.15           O  
ATOM   1471  CB  LYS   195      -6.557   7.140  20.275  1.00 28.13           C  
ATOM   1472  CG  LYS   195      -6.727   8.370  21.094  1.00 36.83           C  
ATOM   1473  CD  LYS   195      -8.202   8.847  21.108  1.00 38.91           C  
ATOM   1474  CE  LYS   195      -8.420  10.211  20.514  1.00 50.63           C  
ATOM   1475  NZ  LYS   195      -9.752  10.881  20.750  1.00 53.49           N  
ATOM   1476  N   ALA   196      -4.888   4.461  18.873  1.00 33.64           N  
ATOM   1477  CA  ALA   196      -5.097   3.537  17.757  1.00 41.41           C  
ATOM   1478  C   ALA   196      -6.586   3.396  17.404  1.00 43.93           C  
ATOM   1479  O   ALA   196      -6.926   3.095  16.260  1.00 48.00           O  
ATOM   1480  CB  ALA   196      -4.494   2.188  18.068  1.00 40.11           C  
END
