
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  719),  selected   90 , name 1voq_a
# Molecule2: number of CA atoms   81 (  610),  selected   81 , name T0506_174_254.pdb
# PARAMETERS: 1voq_a.T0506_174_254.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     1_a      -       -           -
LGA    M     2_a      -       -           -
LGA    N     3_a      -       -           -
LGA    I     4_a      -       -           -
LGA    T     5_a      -       -           -
LGA    S     6_a      L     174          2.472
LGA    K     7_a      S     175          4.007
LGA    Q     8_a      G     176          3.685
LGA    M     9_a      A     177          3.371
LGA    E    10_a      E     178          2.754
LGA    -       -      E     179           -
LGA    I    11_a      L     180           #
LGA    T    12_a      M     181           #
LGA    P    13_a      A     182          4.965
LGA    A    14_a      A     183          4.204
LGA    I    15_a      A     184          4.644
LGA    R    16_a      E     185          3.549
LGA    Q    17_a      S     186          2.773
LGA    H    18_a      E     187          3.519
LGA    V    19_a      A     188          3.985
LGA    A    20_a      T     189          2.610
LGA    D    21_a      R     190          1.612
LGA    R    22_a      L     191          2.033
LGA    L    23_a      N     192          1.983
LGA    A    24_a      A     193          1.301
LGA    K    25_a      I     194          1.955
LGA    L    26_a      K     195          3.372
LGA    E    27_a      G     196          4.743
LGA    K    28_a      E     197           #
LGA    W    29_a      A     198          5.059
LGA    Q    30_a      S     199           #
LGA    -       -      R     200           -
LGA    -       -      L     201           -
LGA    -       -      A     202           -
LGA    -       -      V     203           -
LGA    -       -      L     204           -
LGA    -       -      A     205           -
LGA    -       -      G     206           -
LGA    -       -      A     207           -
LGA    -       -      K     208           -
LGA    -       -      T     209           -
LGA    T    31_a      G     210          4.722
LGA    H    32_a      R     211          2.671
LGA    L    33_a      W     212          3.319
LGA    I    34_a      K     213           #
LGA    N    35_a      I     214           #
LGA    P    36_a      T     215          1.632
LGA    H    37_a      S     216          2.266
LGA    I    38_a      I     217          2.215
LGA    I    39_a      D     218          1.776
LGA    L    40_a      P     219          1.609
LGA    S    41_a      -       -           -
LGA    K    42_a      -       -           -
LGA    E    43_a      -       -           -
LGA    P    44_a      -       -           -
LGA    Q    45_a      -       -           -
LGA    G    46_a      -       -           -
LGA    F    47_a      -       -           -
LGA    V    48_a      -       -           -
LGA    A    49_a      D     220          2.975
LGA    D    50_a      G     221          1.254
LGA    A    51_a      I     222          1.574
LGA    T    52_a      D     223          1.994
LGA    I    53_a      L     224          1.823
LGA    N    54_a      A     225          2.991
LGA    T    55_a      S     226          2.405
LGA    P    56_a      A     227          2.890
LGA    N    57_a      S     228          3.734
LGA    G    58_a      D     229          2.792
LGA    V    59_a      L     230          2.719
LGA    L    60_a      A     231          2.103
LGA    V    61_a      R     232          2.063
LGA    A    62_a      L     233          1.115
LGA    S    63_a      W     234          1.904
LGA    G    64_a      F     235          1.818
LGA    K    65_a      A     236          4.118
LGA    H    66_a      E     237          4.693
LGA    E    67_a      R     238           #
LGA    D    68_a      V     239           #
LGA    M    69_a      E     240          3.274
LGA    Y    70_a      T     241          3.862
LGA    -       -      L     242           -
LGA    T    71_a      K     243          4.635
LGA    A    72_a      Q     244          4.250
LGA    I    73_a      F     245          2.433
LGA    N    74_a      E     246          2.868
LGA    -       -      K     247           -
LGA    E    75_a      A     248          2.275
LGA    L    76_a      L     249          4.661
LGA    I    77_a      A     250           -
LGA    N    78_a      Q     251           #
LGA    K    79_a      L     252          4.461
LGA    L    80_a      -       -           -
LGA    E    81_a      -       -           -
LGA    R    82_a      L     253          4.931
LGA    Q    83_a      K     254           -
LGA    L    84_a      -       -           -
LGA    N    85_a      -       -           -
LGA    K    86_a      -       -           -
LGA    L    87_a      -       -           -
LGA    Q    88_a      -       -           -
LGA    H    89_a      -       -           -
LGA    K    90_a      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90   81    5.0     57    3.21     8.77     43.305     1.722

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.845445 * X  +   0.433456 * Y  +   0.311992 * Z  + 655.144836
  Y_new =   0.522167 * X  +  -0.793509 * Y  +  -0.312547 * Z  + 418.921600
  Z_new =   0.112093 * X  +   0.427153 * Y  +  -0.897204 * Z  + 159.253952 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.697253   -0.444340  [ DEG:   154.5412    -25.4588 ]
  Theta =  -0.112329   -3.029264  [ DEG:    -6.4360   -173.5640 ]
  Phi   =   0.553277   -2.588315  [ DEG:    31.7005   -148.2995 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1voq_a                                        
REMARK     2: T0506_174_254.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1voq_a.T0506_174_254.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90   81   5.0   57   3.21    8.77  43.305
REMARK  ---------------------------------------------------------- 
MOLECULE 1voq_a
HEADER    RIBOSOME                                06-OCT-04   1VOQ              
TITLE     CRYSTAL STRUCTURE OF FIVE 70S RIBOSOMES FROM ESCHERICHIA              
TITLE    2 COLI IN COMPLEX WITH PROTEIN Y. THIS FILE CONTAINS THE 30S           
TITLE    3 SUBUNIT OF ONE 70S RIBOSOME. THE ENTIRE CRYSTAL STRUCTURE            
TITLE    4 CONTAINS FIVE 70S RIBOSOMES AND IS DESCRIBED IN REMARK 400.          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 16S RIBOSOMAL RNA;                                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 MOL_ID: 2;                                                           
COMPND   5 MOLECULE: 30S RIBOSOMAL PROTEIN S2;                                  
COMPND   6 CHAIN: B;                                                            
COMPND   7 MOL_ID: 3;                                                           
COMPND   8 MOLECULE: 30S RIBOSOMAL PROTEIN S3;                                  
COMPND   9 CHAIN: C;                                                            
COMPND  10 MOL_ID: 4;                                                           
COMPND  11 MOLECULE: 30S RIBOSOMAL PROTEIN S4;                                  
COMPND  12 CHAIN: D;                                                            
COMPND  13 MOL_ID: 5;                                                           
COMPND  14 MOLECULE: 30S RIBOSOMAL PROTEIN S5;                                  
COMPND  15 CHAIN: E;                                                            
COMPND  16 MOL_ID: 6;                                                           
COMPND  17 MOLECULE: 30S RIBOSOMAL PROTEIN S6;                                  
COMPND  18 CHAIN: F;                                                            
COMPND  19 MOL_ID: 7;                                                           
COMPND  20 MOLECULE: 30S RIBOSOMAL PROTEIN S7;                                  
COMPND  21 CHAIN: G;                                                            
COMPND  22 MOL_ID: 8;                                                           
COMPND  23 MOLECULE: 30S RIBOSOMAL PROTEIN S8;                                  
COMPND  24 CHAIN: H;                                                            
COMPND  25 MOL_ID: 9;                                                           
COMPND  26 MOLECULE: 30S RIBOSOMAL PROTEIN S9;                                  
COMPND  27 CHAIN: I;                                                            
COMPND  28 MOL_ID: 10;                                                          
COMPND  29 MOLECULE: 30S RIBOSOMAL PROTEIN S10;                                 
COMPND  30 CHAIN: J;                                                            
COMPND  31 MOL_ID: 11;                                                          
COMPND  32 MOLECULE: 30S RIBOSOMAL PROTEIN S11;                                 
COMPND  33 CHAIN: K;                                                            
COMPND  34 MOL_ID: 12;                                                          
COMPND  35 MOLECULE: 30S RIBOSOMAL PROTEIN S12;                                 
COMPND  36 CHAIN: L;                                                            
COMPND  37 MOL_ID: 13;                                                          
COMPND  38 MOLECULE: 30S RIBOSOMAL PROTEIN S13;                                 
COMPND  39 CHAIN: M;                                                            
COMPND  40 MOL_ID: 14;                                                          
COMPND  41 MOLECULE: 30S RIBOSOMAL PROTEIN S14;                                 
COMPND  42 CHAIN: N;                                                            
COMPND  43 MOL_ID: 15;                                                          
COMPND  44 MOLECULE: 30S RIBOSOMAL PROTEIN S15;                                 
COMPND  45 CHAIN: O;                                                            
COMPND  46 MOL_ID: 16;                                                          
COMPND  47 MOLECULE: 30S RIBOSOMAL PROTEIN S16;                                 
COMPND  48 CHAIN: P;                                                            
COMPND  49 MOL_ID: 17;                                                          
COMPND  50 MOLECULE: 30S RIBOSOMAL PROTEIN S17;                                 
COMPND  51 CHAIN: Q;                                                            
COMPND  52 MOL_ID: 18;                                                          
COMPND  53 MOLECULE: 30S RIBOSOMAL PROTEIN S18;                                 
COMPND  54 CHAIN: R;                                                            
COMPND  55 MOL_ID: 19;                                                          
COMPND  56 MOLECULE: 30S RIBOSOMAL PROTEIN S19;                                 
COMPND  57 CHAIN: S;                                                            
COMPND  58 MOL_ID: 20;                                                          
COMPND  59 MOLECULE: 30S RIBOSOMAL PROTEIN S20;                                 
COMPND  60 CHAIN: T;                                                            
COMPND  61 MOL_ID: 21;                                                          
COMPND  62 MOLECULE: PROTEIN Y;                                                 
COMPND  63 CHAIN: a                                                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   6 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   7 MOL_ID: 3;                                                           
SOURCE   8 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   9 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  10 MOL_ID: 4;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 MOL_ID: 5;                                                           
SOURCE  14 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  15 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  16 MOL_ID: 6;                                                           
SOURCE  17 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  18 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  19 MOL_ID: 7;                                                           
SOURCE  20 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  21 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  22 MOL_ID: 8;                                                           
SOURCE  23 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  24 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  25 MOL_ID: 9;                                                           
SOURCE  26 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  27 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  28 MOL_ID: 10;                                                          
SOURCE  29 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  30 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  31 MOL_ID: 11;                                                          
SOURCE  32 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  33 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  34 MOL_ID: 12;                                                          
SOURCE  35 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  36 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  37 MOL_ID: 13;                                                          
SOURCE  38 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  39 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  40 MOL_ID: 14;                                                          
SOURCE  41 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  42 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  43 MOL_ID: 15;                                                          
SOURCE  44 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  45 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  46 MOL_ID: 16;                                                          
SOURCE  47 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  48 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  49 MOL_ID: 17;                                                          
SOURCE  50 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  51 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  52 MOL_ID: 18;                                                          
SOURCE  53 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  54 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  55 MOL_ID: 19;                                                          
SOURCE  56 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  57 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  58 MOL_ID: 20;                                                          
SOURCE  59 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  60 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  61 MOL_ID: 21;                                                          
SOURCE  62 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  63 ORGANISM_COMMON: BACTERIA                                            
KEYWDS    30S RIBOSOMAL SUBUNIT, PROTEIN-RNA COMPLEX, PROTEIN-PROTEIN           
KEYWDS   2 COMPLEX, RNA-RNA COMPLEX                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.VILA-SANJURJO,B.S.SCHUWIRTH,C.W.HAU,J.H.CATE                        
REVDAT   1   16-NOV-04 1VOQ    0                                                
JRNL        AUTH   A.VILA-SANJURJO,B.S.SCHUWIRTH,C.W.HAU,J.H.CATE               
JRNL        TITL   STRUCTURAL BASIS FOR THE CONTROL OF TRANSLATION              
JRNL        TITL 2 INITIATION DURING STRESS.                                    
JRNL        REF    NAT.STRUCT.MOL.BIOL.          V.  11  1054 2004              
JRNL        REFN                US ISSN 1545-9993                               
REMARK   2 RESOLUTION.11.50 ANGSTROMS.                                          
SEQRES   1 A 1526    U   G   G   A   G   A   G   U   U   U   G   A   U          
SEQRES   2 A 1526    C   C   U   G   G   C   U   C   A   G   G   G   U          
SEQRES   3 A 1526    G   A   A   C   G   C   U   G   G   C   G   G   C          
SEQRES   4 A 1526    G   U   G   C   C   U   A   A   G   A   C   A   U          
SEQRES   5 A 1526    G   C   A   A   G   U   C   G   U   G   C   G   G          
SEQRES   6 A 1526    A   U   A   C   G   C   G   C   G   G   C   C   C          
SEQRES   7 A 1526    C   U   U   G   G   G   G   C   C   G   U   G   C          
SEQRES   8 A 1526    G   U   C   A   G   C   G   G   C   G   G   A   C          
SEQRES   9 A 1526    G   G   G   U   G   A   G   U   A   A   C   G   C          
SEQRES  10 A 1526    G   U   G   G   G   U   G   A   C   C   U   A   C          
SEQRES  11 A 1526    C   C   G   G   A   A   G   A   G   G   G   G   G          
SEQRES  12 A 1526    A   C   A   A   C   C   C   G   G   G   G   A   A          
SEQRES  13 A 1526    A   C   U   C   G   G   G   C   U   A   A   U   C          
SEQRES  14 A 1526    C   C   C   C   A   U   G   U   G   G   A   C   G          
SEQRES  15 A 1526    C   A   A   G   U   C   C   A   A   A   G   G   G          
SEQRES  16 A 1526    G   G   A   A   G   C   C   U   U   C   G   G   G          
SEQRES  17 A 1526    U   C   C   C   C   C   G   C   U   U   C   C   G          
SEQRES  18 A 1526    G   A   U   G   G   G   C   C   C   G   C   G   U          
SEQRES  19 A 1526    C   C   C   A   U   C   A   G   C   U   A   G   U          
SEQRES  20 A 1526    U   G   G   U   G   G   G   G   U   A   A   U   G          
SEQRES  21 A 1526    G   C   C   C   A   C   C   A   A   G   G   C   G          
SEQRES  22 A 1526    A   C   G   A   C   G   G   G   U   A   G   C   C          
SEQRES  23 A 1526    G   G   U   C   U   G   A   G   A   G   G   A   U          
SEQRES  24 A 1526    G   G   C   C   G   G   C   C   A   C   A   G   G          
SEQRES  25 A 1526    G   G   C   A   C   U   G   A   G   A   C   A   C          
SEQRES  26 A 1526    G   G   G   C   C   C   C   A   C   U   C   C   U          
SEQRES  27 A 1526    A   C   G   G   G   A   G   G   C   A   G   C   A          
SEQRES  28 A 1526    G   U   U   A   G   G   A   A   U   C   U   U   C          
SEQRES  29 A 1526    C   G   C   A   A   U   G   G   G   C   G   C   A          
SEQRES  30 A 1526    A   G   C   C   U   G   A   C   G   G   A   G   C          
SEQRES  31 A 1526    G   A   C   G   C   C   G   C   U   U   G   G   A          
SEQRES  32 A 1526    G   G   A   A   G   A   A   G   C   C   C   U   U          
SEQRES  33 A 1526    C   G   G   G   G   U   G   U   A   A   A   C   U          
SEQRES  34 A 1526    C   C   U   G   A   A   C   C   C   G   G   G   A          
SEQRES  35 A 1526    C   G   A   A   A   C   C   A   G   G   G   C   C          
SEQRES  36 A 1526    A   C   U   C   A   U   A   C   U   G   G   C   U          
SEQRES  37 A 1526    C   U   G   A   C   U   G   A   C   G   G   U   A          
SEQRES  38 A 1526    C   C   G   G   G   G   U   A   A   U   A   G   C          
SEQRES  39 A 1526    G   C   C   G   G   C   C   A   A   C   U   C   C          
SEQRES  40 A 1526    G   U   G   C   C   A   G   C   A   G   C   C   G          
SEQRES  41 A 1526    C   G   G   U   A   A   U   A   C   G   G   A   G          
SEQRES  42 A 1526    G   G   C   G   C   G   A   G   C   G   U   U   A          
SEQRES  43 A 1526    C   C   C   G   G   A   U   U   C   A   C   U   G          
SEQRES  44 A 1526    G   G   C   G   U   A   A   A   G   G   G   C   G          
SEQRES  45 A 1526    U   G   U   A   G   G   C   G   G   C   C   U   G          
SEQRES  46 A 1526    G   G   G   C   G   U   C   C   C   A   U   G   U          
SEQRES  47 A 1526    G   A   A   A   G   A   C   C   A   C   G   G   C          
SEQRES  48 A 1526    U   C   A   A   C   C   G   U   G   G   G   G   G          
SEQRES  49 A 1526    A   G   C   G   U   G   G   G   A   U   A   C   G          
SEQRES  50 A 1526    C   U   C   A   G   G   C   U   A   G   A   C   G          
SEQRES  51 A 1526    G   U   G   G   G   A   G   A   G   G   G   U   G          
SEQRES  52 A 1526    G   U   G   G   A   A   U   U   C   C   C   G   G          
SEQRES  53 A 1526    A   G   U   A   G   C   G   G   U   G   A   A   A          
SEQRES  54 A 1526    U   G   C   G   C   A   G   A   U   A   C   C   G          
SEQRES  55 A 1526    G   G   A   G   G   A   A   C   G   C   C   G   A          
SEQRES  56 A 1526    U   G   G   C   G   A   A   G   G   C   A   G   C          
SEQRES  57 A 1526    C   A   C   C   U   G   G   U   C   C   A   C   C          
SEQRES  58 A 1526    C   G   U   G   A   C   G   C   U   G   A   G   G          
SEQRES  59 A 1526    C   G   C   G   A   A   A   G   C   G   U   G   G          
SEQRES  60 A 1526    G   G   A   G   C   A   A   A   C   C   G   G   A          
SEQRES  61 A 1526    U   U   A   G   A   U   A   C   C   C   G   G   G          
SEQRES  62 A 1526    U   A   G   U   C   C   A   C   G   C   C   C   U          
SEQRES  63 A 1526    A   A   A   C   G   A   U   G   C   G   C   G   C          
SEQRES  64 A 1526    U   A   G   G   U   C   U   C   U   G   G   C   G          
SEQRES  65 A 1526    G   C   U   C   A   A   C   C   G   C   U   G   G          
SEQRES  66 A 1526    G   G   G   C   C   G   A   A   G   C   U   A   A          
SEQRES  67 A 1526    C   G   C   G   U   U   A   A   G   C   G   C   G          
SEQRES  68 A 1526    C   C   G   C   C   U   G   G   G   G   A   G   U          
SEQRES  69 A 1526    A   C   G   G   C   C   G   C   A   A   G   G   C          
SEQRES  70 A 1526    U   G   A   A   A   C   U   C   A   A   A   G   G          
SEQRES  71 A 1526    A   A   U   U   G   A   C   G   G   G   G   G   C          
SEQRES  72 A 1526    C   C   G   C   A   C   A   A   G   C   G   G   U          
SEQRES  73 A 1526    G   G   A   G   C   A   U   G   U   G   G   U   U          
SEQRES  74 A 1526    U   A   A   U   U   C   G   A   A   G   C   A   A          
SEQRES  75 A 1526    C   G   C   G   A   A   G   A   A   C   C   U   U          
SEQRES  76 A 1526    A   C   C   A   G   G   C   C   U   U   G   A   C          
SEQRES  77 A 1526    A   U   G   C   U   A   G   G   G   A   A   C   C          
SEQRES  78 A 1526    C   G   G   G   U   G   A   A   A   G   C   C   U          
SEQRES  79 A 1526    G   G   G   G   U   G   C   C   U   U   C   G   G          
SEQRES  80 A 1526    G   A   G   C   C   C   U   A   G   C   A   C   A          
SEQRES  81 A 1526    G   G   U   G   C   U   G   C   A   U   G   G   C          
SEQRES  82 A 1526    C   G   U   C   G   U   C   A   G   C   U   C   G          
SEQRES  83 A 1526    U   G   C   C   G   U   G   A   G   G   U   G   U          
SEQRES  84 A 1526    U   G   G   G   U   U   A   A   G   U   C   C   C          
SEQRES  85 A 1526    G   C   A   A   C   G   A   G   C   G   C   A   A          
SEQRES  86 A 1526    C   C   C   C   C   G   C   C   G   U   U   A   G          
SEQRES  87 A 1526    U   U   G   C   C   A   G   C   G   G   U   U   C          
SEQRES  88 A 1526    G   G   C   C   G   G   G   C   A   C   U   C   U          
SEQRES  89 A 1526    A   A   C   G   G   G   A   C   U   G   C   C   C          
SEQRES  90 A 1526    G   C   G   A   A   A   G   C   G   G   G   A   G          
SEQRES  91 A 1526    G   A   A   G   G   A   G   G   G   G   A   C   G          
SEQRES  92 A 1526    A   C   G   U   C   U   G   G   U   C   A   G   C          
SEQRES  93 A 1526    A   U   G   G   C   C   C   U   U   A   C   G   G          
SEQRES  94 A 1526    C   C   U   G   G   G   C   G   A   C   A   C   A          
SEQRES  95 A 1526    C   G   U   G   C   U   A   C   A   A   U   G   C          
SEQRES  96 A 1526    C   C   A   C   U   A   C   A   A   A   G   C   G          
SEQRES  97 A 1526    A   U   G   C   C   A   C   C   C   G   G   C   A          
SEQRES  98 A 1526    A   C   G   G   G   G   A   G   C   U   A   A   U          
SEQRES  99 A 1526    C   G   C   A   A   A   A   A   G   G   U   G   G          
SEQRES  10 A 1526    G   C   C   C   A   G   U   U   C   G   G   A   U          
SEQRES  10 A 1526    U   G   G   G   G   U   C   U   G   C   A   A   C          
SEQRES  10 A 1526    C   C   G   A   C   C   C   C   A   U   G   A   A          
SEQRES  10 A 1526    G   C   C   G   G   A   A   U   C   G   C   U   A          
SEQRES  10 A 1526    G   U   A   A   U   C   G   C   G   G   A   U   C          
SEQRES  10 A 1526    A   G   C   C   A   U   G   C   C   G   C   G   G          
SEQRES  10 A 1526    U   G   A   A   U   A   C   G   U   U   C   C   C          
SEQRES  10 A 1526    G   G   G   C   C   U   U   G   U   A   C   A   C          
SEQRES  10 A 1526    A   C   C   G   C   C   C   G   U   C   A   C   G          
SEQRES  10 A 1526    C   C   A   U   G   G   G   A   G   C   G   G   G          
SEQRES  11 A 1526    C   U   C   U   A   C   C   C   G   A   A   G   U          
SEQRES  11 A 1526    C   G   C   C   G   G   G   U   A   A   C   C   U          
SEQRES  11 A 1526    A   C   G   G   G   A   A   G   A   G   G   C   G          
SEQRES  11 A 1526    C   C   G   A   G   G   G   U   A   G   G   G   C          
SEQRES  11 A 1526    C   C   G   U   G   A   C   U   G   G   G   G   C          
SEQRES  11 A 1526    G   A   A   G   U   C   G   U   A   A   C   A   A          
SEQRES  11 A 1526    G   G   U   A   G   C   U   G   U   A   C   C   G          
SEQRES  11 A 1526    G   A   A   G   G   U   G   C   G   G   C   U   G          
SEQRES  11 A 1526    G   A   U   C   A                                          
SEQRES   1 B  234  VAL LYS GLU LEU LEU GLU ALA GLY VAL HIS PHE GLY HIS          
SEQRES   2 B  234  GLU ARG LYS ARG TRP ASN PRO LYS PHE ALA ARG TYR ILE          
SEQRES   3 B  234  TYR ALA GLU ARG ASN GLY ILE HIS ILE ILE ASP LEU GLN          
SEQRES   4 B  234  LYS THR MET GLU GLU LEU GLU ARG THR PHE ARG PHE ILE          
SEQRES   5 B  234  GLU ASP LEU ALA MET ARG GLY GLY THR ILE LEU PHE VAL          
SEQRES   6 B  234  GLY THR LYS LYS GLN ALA GLN ASP ILE VAL ARG MET GLU          
SEQRES   7 B  234  ALA GLU ARG ALA GLY MET PRO TYR VAL ASN GLN ARG TRP          
SEQRES   8 B  234  LEU GLY GLY MET LEU THR ASN PHE LYS THR ILE SER GLN          
SEQRES   9 B  234  ARG VAL HIS ARG LEU GLU GLU LEU GLU ALA LEU PHE ALA          
SEQRES  10 B  234  SER PRO GLU ILE GLU GLU ARG PRO LYS LYS GLU GLN VAL          
SEQRES  11 B  234  ARG LEU LYS HIS GLU LEU GLU ARG LEU GLN LYS TYR LEU          
SEQRES  12 B  234  SER GLY PHE ARG LEU LEU LYS ARG LEU PRO ASP ALA ILE          
SEQRES  13 B  234  PHE VAL VAL ASP PRO THR LYS GLU ALA ILE ALA VAL ARG          
SEQRES  14 B  234  GLU ALA ARG LYS LEU PHE ILE PRO VAL ILE ALA LEU ALA          
SEQRES  15 B  234  ASP THR ASP SER ASP PRO ASP LEU VAL ASP TYR ILE ILE          
SEQRES  16 B  234  PRO GLY ASN ASP ASP ALA ILE ARG SER ILE GLN LEU ILE          
SEQRES  17 B  234  LEU SER ARG ALA VAL ASP LEU ILE ILE GLN ALA ARG GLY          
SEQRES  18 B  234  GLY VAL VAL GLU PRO SER PRO SER TYR ALA LEU VAL GLN          
SEQRES   1 C  206  GLY ASN LYS ILE HIS PRO ILE GLY PHE ARG LEU GLY ILE          
SEQRES   2 C  206  THR ARG ASP TRP GLU SER ARG TRP TYR ALA GLY LYS LYS          
SEQRES   3 C  206  GLN TYR ARG HIS LEU LEU LEU GLU ASP GLN ARG ILE ARG          
SEQRES   4 C  206  GLY LEU LEU GLU LYS GLU LEU TYR SER ALA GLY LEU ALA          
SEQRES   5 C  206  ARG VAL ASP ILE GLU ARG ALA ALA ASP ASN VAL ALA VAL          
SEQRES   6 C  206  THR VAL HIS VAL ALA LYS PRO GLY VAL VAL ILE GLY ARG          
SEQRES   7 C  206  GLY GLY GLU ARG ILE ARG VAL LEU ARG GLU GLU LEU ALA          
SEQRES   8 C  206  LYS LEU THR GLY LYS ASN VAL ALA LEU ASN VAL GLN GLU          
SEQRES   9 C  206  VAL GLN ASN PRO ASN LEU SER ALA PRO LEU VAL ALA GLN          
SEQRES  10 C  206  ARG VAL ALA GLU GLN ILE GLU ARG ARG PHE ALA VAL ARG          
SEQRES  11 C  206  ARG ALA ILE LYS GLN ALA VAL GLN ARG VAL MET GLU SER          
SEQRES  12 C  206  GLY ALA LYS GLY ALA LYS VAL ILE VAL SER GLY ARG ILE          
SEQRES  13 C  206  GLY GLY ALA GLU GLN ALA ARG THR GLU TRP ALA ALA GLN          
SEQRES  14 C  206  GLY ARG VAL PRO LEU HIS THR LEU ARG ALA ASN ILE ASP          
SEQRES  15 C  206  TYR GLY PHE ALA LEU ALA ARG THR THR TYR GLY VAL LEU          
SEQRES  16 C  206  GLY VAL LYS ALA TYR ILE PHE LEU GLY GLU VAL                  
SEQRES   1 D  208  GLY ARG TYR ILE GLY PRO VAL CYS ARG LEU CYS ARG ARG          
SEQRES   2 D  208  GLU GLY VAL LYS LEU TYR LEU LYS GLY GLU ARG CYS TYR          
SEQRES   3 D  208  SER PRO LYS CYS ALA MET GLU ARG ARG PRO TYR PRO PRO          
SEQRES   4 D  208  GLY GLN HIS GLY GLN LYS ARG ALA ARG ARG PRO SER ASP          
SEQRES   5 D  208  TYR ALA VAL ARG LEU ARG GLU LYS GLN LYS LEU ARG ARG          
SEQRES   6 D  208  ILE TYR GLY ILE SER GLU ARG GLN PHE ARG ASN LEU PHE          
SEQRES   7 D  208  GLU GLU ALA SER LYS LYS LYS GLY VAL THR GLY SER VAL          
SEQRES   8 D  208  PHE LEU GLY LEU LEU GLU SER ARG LEU ASP ASN VAL VAL          
SEQRES   9 D  208  TYR ARG LEU GLY PHE ALA VAL SER ARG ARG GLN ALA ARG          
SEQRES  10 D  208  GLN LEU VAL ARG HIS GLY HIS ILE THR VAL ASN GLY ARG          
SEQRES  11 D  208  ARG VAL ASP LEU PRO SER TYR ARG VAL ARG PRO GLY ASP          
SEQRES  12 D  208  GLU ILE ALA VAL ALA GLU LYS SER ARG ASN LEU GLU LEU          
SEQRES  13 D  208  ILE ARG GLN ASN LEU GLU ALA MET LYS GLY ARG LYS VAL          
SEQRES  14 D  208  GLY PRO TRP LEU SER LEU ASP VAL GLU GLY MET LYS GLY          
SEQRES  15 D  208  LYS PHE LEU ARG LEU PRO ASP ARG GLU ASP LEU ALA LEU          
SEQRES  16 D  208  PRO VAL ASN GLU GLN LEU VAL ILE GLU PHE TYR SER ARG          
SEQRES   1 E  150  ASP PHE GLU GLU LYS MET ILE LEU ILE ARG ARG THR ALA          
SEQRES   2 E  150  ARG MET GLN ALA GLY GLY ARG ARG PHE ARG PHE GLY ALA          
SEQRES   3 E  150  LEU VAL VAL VAL GLY ASP ARG GLN GLY ARG VAL GLY LEU          
SEQRES   4 E  150  GLY PHE GLY LYS ALA PRO GLU VAL PRO LEU ALA VAL GLN          
SEQRES   5 E  150  LYS ALA GLY TYR TYR ALA ARG ARG ASN MET VAL GLU VAL          
SEQRES   6 E  150  PRO LEU GLN ASN GLY THR ILE PRO HIS GLU ILE GLU VAL          
SEQRES   7 E  150  GLU PHE GLY ALA SER LYS ILE VAL LEU LYS PRO ALA ALA          
SEQRES   8 E  150  PRO GLY THR GLY VAL ILE ALA GLY ALA VAL PRO ARG ALA          
SEQRES   9 E  150  ILE LEU GLU LEU ALA GLY VAL THR ASP ILE LEU THR LYS          
SEQRES  10 E  150  GLU LEU GLY SER ARG ASN PRO ILE ASN ILE ALA TYR ALA          
SEQRES  11 E  150  THR MET GLU ALA LEU ARG GLN LEU ARG THR LYS ALA ASP          
SEQRES  12 E  150  VAL GLU ARG LEU ARG LYS GLY                                  
SEQRES   1 F  101  MET ARG ARG TYR GLU VAL ASN ILE VAL LEU ASN PRO ASN          
SEQRES   2 F  101  LEU ASP GLN SER GLN LEU ALA LEU GLU LYS GLU ILE ILE          
SEQRES   3 F  101  GLN ARG ALA LEU GLU ASN TYR GLY ALA ARG VAL GLU LYS          
SEQRES   4 F  101  VAL GLU GLU LEU GLY LEU ARG ARG LEU ALA TYR PRO ILE          
SEQRES   5 F  101  ALA LYS ASP PRO GLN GLY TYR PHE LEU TRP TYR GLN VAL          
SEQRES   6 F  101  GLU MET PRO GLU ASP ARG VAL ASN ASP LEU ALA ARG GLU          
SEQRES   7 F  101  LEU ARG ILE ARG ASP ASN VAL ARG ARG VAL MET VAL VAL          
SEQRES   8 F  101  LYS SER GLN GLU PRO PHE LEU ALA ASN ALA                      
SEQRES   1 G  155  ALA ARG ARG ARG ARG ALA GLU VAL ARG GLN LEU GLN PRO          
SEQRES   2 G  155  ASP LEU VAL TYR GLY ASP VAL LEU VAL THR ALA PHE ILE          
SEQRES   3 G  155  ASN LYS ILE MET ARG ASP GLY LYS LYS ASN LEU ALA ALA          
SEQRES   4 G  155  ARG ILE PHE TYR ASP ALA CYS LYS ILE ILE GLN GLU LYS          
SEQRES   5 G  155  THR GLY GLN GLU PRO LEU LYS VAL PHE LYS GLN ALA VAL          
SEQRES   6 G  155  GLU ASN VAL LYS PRO ARG MET GLU VAL ARG SER ARG ARG          
SEQRES   7 G  155  VAL GLY GLY ALA ASN TYR GLN VAL PRO MET GLU VAL SER          
SEQRES   8 G  155  PRO ARG ARG GLN GLN SER LEU ALA LEU ARG TRP LEU VAL          
SEQRES   9 G  155  GLN ALA ALA ASN GLN ARG PRO GLU ARG ARG ALA ALA VAL          
SEQRES  10 G  155  ARG ILE ALA HIS GLU LEU MET ASP ALA ALA GLU GLY LYS          
SEQRES  11 G  155  GLY GLY ALA VAL LYS LYS LYS GLU ASP VAL GLU ARG MET          
SEQRES  12 G  155  ALA GLU ALA ASN ARG ALA TYR ALA HIS TYR ARG TRP              
SEQRES   1 H  138  MET LEU THR ASP PRO ILE ALA ASP MET LEU THR ARG ILE          
SEQRES   2 H  138  ARG ASN ALA THR ARG VAL TYR LYS GLU SER THR ASP VAL          
SEQRES   3 H  138  PRO ALA SER ARG PHE LYS GLU GLU ILE LEU ARG ILE LEU          
SEQRES   4 H  138  ALA ARG GLU GLY PHE ILE LYS GLY TYR GLU ARG VAL ASP          
SEQRES   5 H  138  VAL ASP GLY LYS PRO TYR LEU ARG VAL TYR LEU LYS TYR          
SEQRES   6 H  138  GLY PRO ARG ARG GLN GLY PRO ASP PRO ARG PRO GLU GLN          
SEQRES   7 H  138  VAL ILE HIS HIS ILE ARG ARG ILE SER LYS PRO GLY ARG          
SEQRES   8 H  138  ARG VAL TYR VAL GLY VAL LYS GLU ILE PRO ARG VAL ARG          
SEQRES   9 H  138  ARG GLY LEU GLY ILE ALA ILE LEU SER THR SER LYS GLY          
SEQRES  10 H  138  VAL LEU THR ASP ARG GLU ALA ARG LYS LEU GLY VAL GLY          
SEQRES  11 H  138  GLY GLU LEU ILE CYS GLU VAL TRP                              
SEQRES   1 I  127  GLU GLN TYR TYR GLY THR GLY ARG ARG LYS GLU ALA VAL          
SEQRES   2 I  127  ALA ARG VAL PHE LEU ARG PRO GLY ASN GLY LYS VAL THR          
SEQRES   3 I  127  VAL ASN GLY GLN ASP PHE ASN GLU TYR PHE GLN GLY LEU          
SEQRES   4 I  127  VAL ARG ALA VAL ALA ALA LEU GLU PRO LEU ARG ALA VAL          
SEQRES   5 I  127  ASP ALA LEU GLY ARG PHE ASP ALA TYR ILE THR VAL ARG          
SEQRES   6 I  127  GLY GLY GLY LYS SER GLY GLN ILE ASP ALA ILE LYS LEU          
SEQRES   7 I  127  GLY ILE ALA ARG ALA LEU VAL GLN TYR ASN PRO ASP TYR          
SEQRES   8 I  127  ARG ALA LYS LEU LYS PRO LEU GLY PHE LEU THR ARG ASP          
SEQRES   9 I  127  ALA ARG VAL VAL GLU ARG LYS LYS TYR GLY LYS HIS LYS          
SEQRES  10 I  127  ALA ARG ARG ALA PRO GLN TYR SER LYS ARG                      
SEQRES   1 J   98  LYS ILE ARG ILE LYS LEU ARG GLY PHE ASP HIS LYS THR          
SEQRES   2 J   98  LEU ASP ALA SER ALA GLN LYS ILE VAL GLU ALA ALA ARG          
SEQRES   3 J   98  ARG SER GLY ALA GLN VAL SER GLY PRO ILE PRO LEU PRO          
SEQRES   4 J   98  THR ARG VAL ARG ARG PHE THR VAL ILE ARG GLY PRO PHE          
SEQRES   5 J   98  LYS HIS LYS ASP SER ARG GLU HIS PHE GLU LEU ARG THR          
SEQRES   6 J   98  HIS ASN ARG LEU VAL ASP ILE ILE ASN PRO ASN ARG LYS          
SEQRES   7 J   98  THR ILE GLU GLN LEU MET THR LEU ASP LEU PRO THR GLY          
SEQRES   8 J   98  VAL GLU ILE GLU ILE LYS THR                                  
SEQRES   1 K  119  LYS ARG GLN VAL ALA SER GLY ARG ALA TYR ILE HIS ALA          
SEQRES   2 K  119  SER TYR ASN ASN THR ILE VAL THR ILE THR ASP PRO ASP          
SEQRES   3 K  119  GLY ASN PRO ILE THR TRP SER SER GLY GLY VAL ILE GLY          
SEQRES   4 K  119  TYR LYS GLY SER ARG LYS GLY THR PRO TYR ALA ALA GLN          
SEQRES   5 K  119  LEU ALA ALA LEU ASP ALA ALA LYS LYS ALA MET ALA TYR          
SEQRES   6 K  119  GLY MET GLN SER VAL ASP VAL ILE VAL ARG GLY THR GLY          
SEQRES   7 K  119  ALA GLY ARG GLU GLN ALA ILE ARG ALA LEU GLN ALA SER          
SEQRES   8 K  119  GLY LEU GLN VAL LYS SER ILE VAL ASP ASP THR PRO VAL          
SEQRES   9 K  119  PRO HIS ASN GLY CYS ARG PRO LYS LYS LYS PHE ARG LYS          
SEQRES  10 K  119  ALA SER                                                      
SEQRES   1 L  124  PRO THR ILE ASN GLN LEU VAL ARG LYS GLY ARG GLU LYS          
SEQRES   2 L  124  VAL ARG LYS LYS SER LYS VAL PRO ALA LEU LYS GLY ALA          
SEQRES   3 L  124  PRO PHE ARG ARG GLY VAL CYS THR VAL VAL ARG THR VAL          
SEQRES   4 L  124  THR PRO LYS LYS PRO ASN SER ALA LEU ARG LYS VAL ALA          
SEQRES   5 L  124  LYS VAL ARG LEU THR SER GLY TYR GLU VAL THR ALA TYR          
SEQRES   6 L  124  ILE PRO GLY GLU GLY HIS ASN LEU GLN GLU HIS SER VAL          
SEQRES   7 L  124  VAL LEU ILE ARG GLY GLY ARG VAL LYS ASP LEU PRO GLY          
SEQRES   8 L  124  VAL ARG TYR HIS ILE VAL ARG GLY VAL TYR ASP ALA ALA          
SEQRES   9 L  124  GLY VAL LYS ASP ARG LYS LYS SER ARG SER LYS TYR GLY          
SEQRES  10 L  124  THR LYS LYS PRO LYS GLU ALA                                  
SEQRES   1 M  125  ALA ARG ILE ALA GLY VAL GLU ILE PRO ARG ASN LYS ARG          
SEQRES   2 M  125  VAL ASP VAL ALA LEU THR TYR ILE TYR GLY ILE GLY LYS          
SEQRES   3 M  125  ALA ARG ALA LYS GLU ALA LEU GLU LYS THR GLY ILE ASN          
SEQRES   4 M  125  PRO ALA THR ARG VAL LYS ASP LEU THR GLU ALA GLU VAL          
SEQRES   5 M  125  VAL ARG LEU ARG GLU TYR VAL GLU ASN THR TRP LYS LEU          
SEQRES   6 M  125  GLU GLY GLU LEU ARG ALA GLU VAL ALA ALA ASN ILE LYS          
SEQRES   7 M  125  ARG LEU MET ASP ILE GLY CYS TYR ARG GLY LEU ARG HIS          
SEQRES   8 M  125  ARG ARG GLY LEU PRO VAL ARG GLY GLN ARG THR ARG THR          
SEQRES   9 M  125  ASN ALA ARG THR ARG LYS GLY PRO ARG LYS THR VAL ALA          
SEQRES  10 M  125  GLY LYS LYS LYS ALA PRO ARG LYS                              
SEQRES   1 N   60  ALA ARG LYS ALA LEU ILE GLU LYS ALA LYS ARG THR PRO          
SEQRES   2 N   60  LYS PHE LYS VAL ARG ALA TYR THR ARG CYS VAL ARG CYS          
SEQRES   3 N   60  GLY ARG ALA ARG SER VAL TYR ARG PHE PHE GLY LEU CYS          
SEQRES   4 N   60  ARG ILE CYS LEU ARG GLU LEU ALA HIS LYS GLY GLN LEU          
SEQRES   5 N   60  PRO GLY VAL ARG LYS ALA SER TRP                              
SEQRES   1 O   88  PRO ILE THR LYS GLU GLU LYS GLN LYS VAL ILE GLN GLU          
SEQRES   2 O   88  PHE ALA ARG PHE PRO GLY ASP THR GLY SER THR GLU VAL          
SEQRES   3 O   88  GLN VAL ALA LEU LEU THR LEU ARG ILE ASN ARG LEU SER          
SEQRES   4 O   88  GLU HIS LEU LYS VAL HIS LYS LYS ASP HIS HIS SER HIS          
SEQRES   5 O   88  ARG GLY LEU LEU MET MET VAL GLY GLN ARG ARG ARG LEU          
SEQRES   6 O   88  LEU ARG TYR LEU GLN ARG GLU ASP PRO GLU ARG TYR ARG          
SEQRES   7 O   88  ALA LEU ILE GLU LYS LEU GLY ILE ARG GLY                      
SEQRES   1 P   83  MET VAL LYS ILE ARG LEU ALA ARG PHE GLY SER LYS HIS          
SEQRES   2 P   83  ASN PRO HIS TYR ARG ILE VAL VAL THR ASP ALA ARG ARG          
SEQRES   3 P   83  LYS ARG ASP GLY LYS TYR ILE GLU LYS ILE GLY TYR TYR          
SEQRES   4 P   83  ASP PRO ARG LYS THR THR PRO ASP TRP LEU LYS VAL ASP          
SEQRES   5 P   83  VAL GLU ARG ALA ARG TYR TRP LEU SER VAL GLY ALA GLN          
SEQRES   6 P   83  PRO THR ASP THR ALA ARG ARG LEU LEU ARG GLN ALA GLY          
SEQRES   7 P   83  VAL PHE ARG GLN GLU                                          
SEQRES   1 Q  104  PRO LYS LYS VAL LEU THR GLY VAL VAL VAL SER ASP LYS          
SEQRES   2 Q  104  MET GLN LYS THR VAL THR VAL LEU VAL GLU ARG GLN PHE          
SEQRES   3 Q  104  PRO HIS PRO LEU TYR GLY LYS VAL ILE LYS ARG SER LYS          
SEQRES   4 Q  104  LYS TYR LEU ALA HIS ASP PRO GLU GLU LYS TYR LYS LEU          
SEQRES   5 Q  104  GLY ASP VAL VAL GLU ILE ILE GLU SER ARG PRO ILE SER          
SEQRES   6 Q  104  LYS ARG LYS ARG PHE ARG VAL LEU ARG LEU VAL GLU SER          
SEQRES   7 Q  104  GLY ARG MET ASP LEU VAL GLU LYS TYR LEU ILE ARG ARG          
SEQRES   8 Q  104  GLN ASN TYR GLN SER LEU SER LYS ARG GLY GLY LYS ALA          
SEQRES   1 R   73  PRO SER ARG LYS ALA LYS VAL LYS ALA THR LEU GLY GLU          
SEQRES   2 R   73  PHE ASP LEU ARG ASP TYR ARG ASN VAL GLU VAL LEU LYS          
SEQRES   3 R   73  ARG PHE LEU SER GLU THR GLY LYS ILE LEU PRO ARG ARG          
SEQRES   4 R   73  ARG THR GLY LEU SER GLY LYS GLU GLN ARG ILE LEU ALA          
SEQRES   5 R   73  LYS THR ILE LYS ARG ALA ARG ILE LEU GLY LEU LEU PRO          
SEQRES   6 R   73  PHE THR GLU LYS LEU VAL ARG LYS                              
SEQRES   1 S   80  PRO ARG SER LEU LYS LYS GLY VAL PHE VAL ASP ASP HIS          
SEQRES   2 S   80  LEU LEU GLU LYS VAL LEU GLU LEU ASN ALA LYS GLY GLU          
SEQRES   3 S   80  LYS ARG LEU ILE LYS THR TRP SER ARG ARG SER THR ILE          
SEQRES   4 S   80  VAL PRO GLU MET VAL GLY HIS THR ILE ALA VAL TYR ASN          
SEQRES   5 S   80  GLY LYS GLN HIS VAL PRO VAL TYR ILE THR GLU ASN MET          
SEQRES   6 S   80  VAL GLY HIS LYS LEU GLY GLU PHE ALA PRO THR ARG THR          
SEQRES   7 S   80  TYR ARG                                                      
SEQRES   1 T   99  ARG ASN LEU SER ALA LEU LYS ARG HIS ARG GLN SER LEU          
SEQRES   2 T   99  LYS ARG ARG LEU ARG ASN LYS ALA LYS LYS SER ALA ILE          
SEQRES   3 T   99  LYS THR LEU SER LYS LYS ALA VAL GLN LEU ALA GLN GLU          
SEQRES   4 T   99  GLY LYS ALA GLU GLU ALA LEU LYS ILE MET ARG LYS ALA          
SEQRES   5 T   99  GLU SER LEU ILE ASP LYS ALA ALA LYS GLY SER THR LEU          
SEQRES   6 T   99  HIS LYS ASN ALA ALA ALA ARG ARG LYS SER ARG LEU MET          
SEQRES   7 T   99  ARG LYS VAL ARG GLN LEU LEU GLU ALA ALA GLY ALA PRO          
SEQRES   8 T   99  LEU ILE GLY GLY GLY LEU SER ALA                              
SEQRES   1 a   90  THR MET ASN ILE THR SER LYS GLN MET GLU ILE THR PRO          
SEQRES   2 a   90  ALA ILE ARG GLN HIS VAL ALA ASP ARG LEU ALA LYS LEU          
SEQRES   3 a   90  GLU LYS TRP GLN THR HIS LEU ILE ASN PRO HIS ILE ILE          
SEQRES   4 a   90  LEU SER LYS GLU PRO GLN GLY PHE VAL ALA ASP ALA THR          
SEQRES   5 a   90  ILE ASN THR PRO ASN GLY VAL LEU VAL ALA SER GLY LYS          
SEQRES   6 a   90  HIS GLU ASP MET TYR THR ALA ILE ASN GLU LEU ILE ASN          
SEQRES   7 a   90  LYS LEU GLU ARG GLN LEU ASN LYS LEU GLN HIS LYS              
CRYST1  687.900  687.900 1933.300  90.00  90.00  90.00 I 4 2 2      16          
ATOM  51850  N   THR a   1      -1.503  38.776   3.823  0.01  4.44           N  
ATOM  51851  CA  THR a   1      -1.902  37.747   2.828  0.01  4.44           C  
ATOM  51852  C   THR a   1      -1.848  38.303   1.409  0.01  4.44           C  
ATOM  51853  O   THR a   1      -1.571  37.572   0.456  0.01  4.44           O  
ATOM  51854  CB  THR a   1      -3.319  37.279   3.156  0.01  4.44           C  
ATOM  51855  OG1 THR a   1      -4.266  38.286   2.848  0.01  4.44           O  
ATOM  51856  CG2 THR a   1      -3.506  36.904   4.611  0.01  4.44           C  
ATOM  51857  N   MET a   2      -2.110  39.597   1.275  0.01  4.44           N  
ATOM  51858  CA  MET a   2      -2.092  40.252  -0.028  0.01  4.44           C  
ATOM  51859  C   MET a   2      -2.193  41.767   0.124  0.01  4.44           C  
ATOM  51860  O   MET a   2      -3.270  42.303   0.377  0.01  4.44           O  
ATOM  51861  CB  MET a   2      -3.239  39.736  -0.898  0.01  4.44           C  
ATOM  51862  CG  MET a   2      -3.270  40.349  -2.290  0.01  4.44           C  
ATOM  51863  SD  MET a   2      -4.948  40.627  -2.891  0.01  4.44           S  
ATOM  51864  CE  MET a   2      -5.364  42.149  -2.043  0.01  4.44           C  
ATOM  51865  N   ASN a   3      -1.063  42.449  -0.029  0.01  4.44           N  
ATOM  51866  CA  ASN a   3      -1.027  43.901   0.093  0.01  4.44           C  
ATOM  51867  C   ASN a   3      -0.553  44.549  -1.204  0.01  4.44           C  
ATOM  51868  O   ASN a   3       0.538  44.256  -1.693  0.01  4.44           O  
ATOM  51869  CB  ASN a   3      -0.109  44.312   1.248  0.01  4.44           C  
ATOM  51870  CG  ASN a   3      -0.876  44.575   2.532  0.01  4.44           C  
ATOM  51871  OD1 ASN a   3      -1.177  43.653   3.286  0.01  4.44           O  
ATOM  51872  ND2 ASN a   3      -1.195  45.841   2.779  0.01  4.44           N  
ATOM  51873  N   ILE a   4      -1.378  45.437  -1.751  0.01  4.44           N  
ATOM  51874  CA  ILE a   4      -1.045  46.133  -2.987  0.01  4.44           C  
ATOM  51875  C   ILE a   4      -1.021  47.642  -2.772  0.01  4.44           C  
ATOM  51876  O   ILE a   4      -1.996  48.225  -2.294  0.01  4.44           O  
ATOM  51877  CB  ILE a   4      -2.046  45.799  -4.112  0.01  4.44           C  
ATOM  51878  CG1 ILE a   4      -2.212  44.284  -4.250  0.01  4.44           C  
ATOM  51879  CG2 ILE a   4      -1.590  46.408  -5.430  0.01  4.44           C  
ATOM  51880  CD1 ILE a   4      -3.197  43.877  -5.327  0.01  4.44           C  
ATOM  51881  N   THR a   5       0.093  48.275  -3.126  0.01  4.44           N  
ATOM  51882  CA  THR a   5       0.237  49.718  -2.970  0.01  4.44           C  
ATOM  51883  C   THR a   5       0.825  50.350  -4.226  0.01  4.44           C  
ATOM  51884  O   THR a   5       1.428  49.666  -5.052  0.01  4.44           O  
ATOM  51885  CB  THR a   5       1.114  50.043  -1.764  0.01  4.44           C  
ATOM  51886  OG1 THR a   5       2.203  49.140  -1.674  0.01  4.44           O  
ATOM  51887  CG2 THR a   5       0.365  50.001  -0.451  0.01  4.44           C  
ATOM  51888  N   SER a   6       0.639  51.658  -4.363  0.01  4.44           N  
ATOM  51889  CA  SER a   6       1.140  52.385  -5.522  0.01  4.44           C  
ATOM  51890  C   SER a   6       1.158  53.886  -5.249  0.01  4.44           C  
ATOM  51891  O   SER a   6       0.266  54.417  -4.586  0.01  4.44           O  
ATOM  51892  CB  SER a   6       0.274  52.088  -6.747  0.01  4.44           C  
ATOM  51893  OG  SER a   6      -0.955  52.790  -6.685  0.01  4.44           O  
ATOM  51894  N   LYS a   7       2.184  54.563  -5.758  0.01  4.44           N  
ATOM  51895  CA  LYS a   7       2.325  56.001  -5.560  0.01  4.44           C  
ATOM  51896  C   LYS a   7       1.910  56.767  -6.812  0.01  4.44           C  
ATOM  51897  O   LYS a   7       2.439  57.843  -7.097  0.01  4.44           O  
ATOM  51898  CB  LYS a   7       3.769  56.345  -5.195  0.01  4.44           C  
ATOM  51899  CG  LYS a   7       4.369  55.422  -4.146  0.01  4.44           C  
ATOM  51900  CD  LYS a   7       5.198  56.189  -3.128  0.01  4.44           C  
ATOM  51901  CE  LYS a   7       4.596  56.100  -1.733  0.01  4.44           C  
ATOM  51902  NZ  LYS a   7       5.639  55.941  -0.685  0.01  4.44           N  
ATOM  51903  N   GLN a   8       0.960  56.210  -7.554  0.01  4.44           N  
ATOM  51904  CA  GLN a   8       0.470  56.838  -8.765  0.01  4.44           C  
ATOM  51905  C   GLN a   8      -1.038  56.660  -8.890  0.01  4.44           C  
ATOM  51906  O   GLN a   8      -1.767  57.617  -9.156  0.01  4.44           O  
ATOM  51907  CB  GLN a   8       1.177  56.259  -9.994  0.01  4.44           C  
ATOM  51908  CG  GLN a   8       1.610  57.314 -10.997  0.01  4.44           C  
ATOM  51909  CD  GLN a   8       2.868  58.044 -10.571  0.01  4.44           C  
ATOM  51910  OE1 GLN a   8       2.829  59.229 -10.242  0.01  4.44           O  
ATOM  51911  NE2 GLN a   8       3.994  57.337 -10.575  0.01  4.44           N  
ATOM  51912  N   MET a   9      -1.499  55.430  -8.693  0.01  4.44           N  
ATOM  51913  CA  MET a   9      -2.923  55.122  -8.777  0.01  4.44           C  
ATOM  51914  C   MET a   9      -3.433  54.578  -7.448  0.01  4.44           C  
ATOM  51915  O   MET a   9      -2.704  54.545  -6.457  0.01  4.44           O  
ATOM  51916  CB  MET a   9      -3.184  54.103  -9.891  0.01  4.44           C  
ATOM  51917  CG  MET a   9      -2.318  54.304 -11.123  0.01  4.44           C  
ATOM  51918  SD  MET a   9      -0.807  53.321 -11.075  0.01  4.44           S  
ATOM  51919  CE  MET a   9      -1.056  52.244 -12.484  0.01  4.44           C  
ATOM  51920  N   GLU a  10      -4.692  54.151  -7.433  0.01  4.44           N  
ATOM  51921  CA  GLU a  10      -5.299  53.607  -6.225  0.01  4.44           C  
ATOM  51922  C   GLU a  10      -5.622  52.128  -6.405  0.01  4.44           C  
ATOM  51923  O   GLU a  10      -5.575  51.605  -7.520  0.01  4.44           O  
ATOM  51924  CB  GLU a  10      -6.571  54.381  -5.871  0.01  4.44           C  
ATOM  51925  CG  GLU a  10      -7.516  54.563  -7.048  0.01  4.44           C  
ATOM  51926  CD  GLU a  10      -7.339  55.906  -7.735  0.01  4.44           C  
ATOM  51927  OE1 GLU a  10      -7.556  56.941  -7.073  0.01  4.44           O  
ATOM  51928  OE2 GLU a  10      -6.984  55.917  -8.931  0.01  4.44           O  
ATOM  51929  N   ILE a  11      -5.943  51.453  -5.305  0.01  4.44           N  
ATOM  51930  CA  ILE a  11      -6.263  50.035  -5.348  0.01  4.44           C  
ATOM  51931  C   ILE a  11      -7.759  49.815  -5.539  0.01  4.44           C  
ATOM  51932  O   ILE a  11      -8.568  50.168  -4.683  0.01  4.44           O  
ATOM  51933  CB  ILE a  11      -5.815  49.333  -4.055  0.01  4.44           C  
ATOM  51934  CG1 ILE a  11      -4.421  49.824  -3.652  0.01  4.44           C  
ATOM  51935  CG2 ILE a  11      -5.835  47.821  -4.234  0.01  4.44           C  
ATOM  51936  CD1 ILE a  11      -3.301  49.225  -4.477  0.01  4.44           C  
ATOM  51937  N   THR a  12      -8.113  49.222  -6.673  0.01  4.44           N  
ATOM  51938  CA  THR a  12      -9.508  48.943  -6.990  0.01  4.44           C  
ATOM  51939  C   THR a  12      -9.852  47.485  -6.695  0.01  4.44           C  
ATOM  51940  O   THR a  12      -9.001  46.604  -6.813  0.01  4.44           O  
ATOM  51941  CB  THR a  12      -9.793  49.257  -8.459  0.01  4.44           C  
ATOM  51942  OG1 THR a  12      -9.260  48.249  -9.299  0.01  4.44           O  
ATOM  51943  CG2 THR a  12      -9.220  50.583  -8.911  0.01  4.44           C  
ATOM  51944  N   PRO a  13     -11.113  47.205  -6.321  0.01  4.44           N  
ATOM  51945  CA  PRO a  13     -11.563  45.841  -6.030  0.01  4.44           C  
ATOM  51946  C   PRO a  13     -11.322  44.901  -7.205  0.01  4.44           C  
ATOM  51947  O   PRO a  13     -11.279  43.683  -7.035  0.01  4.44           O  
ATOM  51948  CB  PRO a  13     -13.062  45.999  -5.761  0.01  4.44           C  
ATOM  51949  CG  PRO a  13     -13.238  47.431  -5.393  0.01  4.44           C  
ATOM  51950  CD  PRO a  13     -12.200  48.189  -6.167  0.01  4.44           C  
ATOM  51951  N   ALA a  14     -11.151  45.471  -8.394  0.01  4.44           N  
ATOM  51952  CA  ALA a  14     -10.898  44.671  -9.582  0.01  4.44           C  
ATOM  51953  C   ALA a  14      -9.450  44.210  -9.610  0.01  4.44           C  
ATOM  51954  O   ALA a  14      -9.156  43.059  -9.930  0.01  4.44           O  
ATOM  51955  CB  ALA a  14     -11.229  45.467 -10.837  0.01  4.44           C  
ATOM  51956  N   ILE a  15      -8.551  45.119  -9.245  0.01  4.44           N  
ATOM  51957  CA  ILE a  15      -7.133  44.813  -9.200  0.01  4.44           C  
ATOM  51958  C   ILE a  15      -6.842  43.921  -8.005  0.01  4.44           C  
ATOM  51959  O   ILE a  15      -5.925  43.100  -8.031  0.01  4.44           O  
ATOM  51960  CB  ILE a  15      -6.278  46.092  -9.104  0.01  4.44           C  
ATOM  51961  CG1 ILE a  15      -6.654  47.068 -10.219  0.01  4.44           C  
ATOM  51962  CG2 ILE a  15      -4.796  45.748  -9.173  0.01  4.44           C  
ATOM  51963  CD1 ILE a  15      -6.292  48.504  -9.915  0.01  4.44           C  
ATOM  51964  N   ARG a  16      -7.656  44.073  -6.963  0.01  4.44           N  
ATOM  51965  CA  ARG a  16      -7.515  43.271  -5.764  0.01  4.44           C  
ATOM  51966  C   ARG a  16      -8.018  41.861  -6.044  0.01  4.44           C  
ATOM  51967  O   ARG a  16      -7.364  40.877  -5.704  0.01  4.44           O  
ATOM  51968  CB  ARG a  16      -8.293  43.916  -4.609  0.01  4.44           C  
ATOM  51969  CG  ARG a  16      -8.779  42.929  -3.558  0.01  4.44           C  
ATOM  51970  CD  ARG a  16      -9.041  43.616  -2.226  0.01  4.44           C  
ATOM  51971  NE  ARG a  16      -9.778  44.869  -2.390  0.01  4.44           N  
ATOM  51972  CZ  ARG a  16     -11.092  44.934  -2.588  0.01  4.44           C  
ATOM  51973  NH1 ARG a  16     -11.819  43.824  -2.650  0.01  4.44           N  
ATOM  51974  NH2 ARG a  16     -11.683  46.112  -2.727  0.01  4.44           N  
ATOM  51975  N   GLN a  17      -9.180  41.776  -6.688  0.01  4.44           N  
ATOM  51976  CA  GLN a  17      -9.773  40.494  -7.043  0.01  4.44           C  
ATOM  51977  C   GLN a  17      -8.927  39.790  -8.099  0.01  4.44           C  
ATOM  51978  O   GLN a  17      -8.763  38.572  -8.054  0.01  4.44           O  
ATOM  51979  CB  GLN a  17     -11.208  40.691  -7.538  0.01  4.44           C  
ATOM  51980  CG  GLN a  17     -11.833  39.445  -8.142  0.01  4.44           C  
ATOM  51981  CD  GLN a  17     -13.200  39.709  -8.740  0.01  4.44           C  
ATOM  51982  OE1 GLN a  17     -13.317  40.147  -9.885  0.01  4.44           O  
ATOM  51983  NE2 GLN a  17     -14.245  39.442  -7.965  0.01  4.44           N  
ATOM  51984  N   HIS a  18      -8.369  40.551  -9.031  0.01  4.44           N  
ATOM  51985  CA  HIS a  18      -7.525  39.964 -10.065  0.01  4.44           C  
ATOM  51986  C   HIS a  18      -6.339  39.247  -9.419  0.01  4.44           C  
ATOM  51987  O   HIS a  18      -6.201  38.023  -9.537  0.01  4.44           O  
ATOM  51988  CB  HIS a  18      -7.047  41.033 -11.054  0.01  4.44           C  
ATOM  51989  CG  HIS a  18      -5.998  40.555 -12.010  0.01  4.44           C  
ATOM  51990  ND1 HIS a  18      -6.258  39.656 -13.022  0.01  4.44           N  
ATOM  51991  CD2 HIS a  18      -4.682  40.855 -12.102  0.01  4.44           C  
ATOM  51992  CE1 HIS a  18      -5.145  39.424 -13.698  0.01  4.44           C  
ATOM  51993  NE2 HIS a  18      -4.176  40.139 -13.159  0.01  4.44           N  
ATOM  51994  N   VAL a  19      -5.503  39.997  -8.717  0.01  4.44           N  
ATOM  51995  CA  VAL a  19      -4.356  39.415  -8.040  0.01  4.44           C  
ATOM  51996  C   VAL a  19      -4.810  38.387  -7.011  0.01  4.44           C  
ATOM  51997  O   VAL a  19      -4.268  37.283  -6.949  0.01  4.44           O  
ATOM  51998  CB  VAL a  19      -3.509  40.495  -7.343  0.01  4.44           C  
ATOM  51999  CG1 VAL a  19      -2.224  39.893  -6.800  0.01  4.44           C  
ATOM  52000  CG2 VAL a  19      -3.212  41.643  -8.296  0.01  4.44           C  
ATOM  52001  N   ALA a  20      -5.805  38.751  -6.210  0.01  4.44           N  
ATOM  52002  CA  ALA a  20      -6.327  37.847  -5.186  0.01  4.44           C  
ATOM  52003  C   ALA a  20      -6.809  36.529  -5.786  0.01  4.44           C  
ATOM  52004  O   ALA a  20      -6.533  35.460  -5.241  0.01  4.44           O  
ATOM  52005  CB  ALA a  20      -7.437  38.511  -4.394  0.01  4.44           C  
ATOM  52006  N   ASP a  21      -7.530  36.595  -6.904  0.01  4.44           N  
ATOM  52007  CA  ASP a  21      -8.036  35.382  -7.543  0.01  4.44           C  
ATOM  52008  C   ASP a  21      -6.883  34.462  -7.933  0.01  4.44           C  
ATOM  52009  O   ASP a  21      -7.013  33.238  -7.902  0.01  4.44           O  
ATOM  52010  CB  ASP a  21      -8.892  35.718  -8.771  0.01  4.44           C  
ATOM  52011  CG  ASP a  21      -8.075  36.078 -10.001  0.01  4.44           C  
ATOM  52012  OD1 ASP a  21      -7.228  35.259 -10.417  0.01  4.44           O  
ATOM  52013  OD2 ASP a  21      -8.293  37.169 -10.559  0.01  4.44           O  
ATOM  52014  N   ARG a  22      -5.755  35.063  -8.296  0.01  4.44           N  
ATOM  52015  CA  ARG a  22      -4.576  34.298  -8.691  0.01  4.44           C  
ATOM  52016  C   ARG a  22      -3.893  33.676  -7.476  0.01  4.44           C  
ATOM  52017  O   ARG a  22      -3.257  32.628  -7.584  0.01  4.44           O  
ATOM  52018  CB  ARG a  22      -3.590  35.190  -9.444  0.01  4.44           C  
ATOM  52019  CG  ARG a  22      -4.161  35.790 -10.718  0.01  4.44           C  
ATOM  52020  CD  ARG a  22      -4.305  34.743 -11.810  0.01  4.44           C  
ATOM  52021  NE  ARG a  22      -5.473  34.988 -12.653  0.01  4.44           N  
ATOM  52022  CZ  ARG a  22      -5.945  34.115 -13.540  0.01  4.44           C  
ATOM  52023  NH1 ARG a  22      -5.351  32.939 -13.702  0.01  4.44           N  
ATOM  52024  NH2 ARG a  22      -7.014  34.417 -14.263  0.01  4.44           N  
ATOM  52025  N   LEU a  23      -4.031  34.310  -6.316  0.01  4.44           N  
ATOM  52026  CA  LEU a  23      -3.427  33.789  -5.096  0.01  4.44           C  
ATOM  52027  C   LEU a  23      -4.100  32.487  -4.687  0.01  4.44           C  
ATOM  52028  O   LEU a  23      -3.443  31.468  -4.475  0.01  4.44           O  
ATOM  52029  CB  LEU a  23      -3.526  34.804  -3.954  0.01  4.44           C  
ATOM  52030  CG  LEU a  23      -3.428  36.273  -4.371  0.01  4.44           C  
ATOM  52031  CD1 LEU a  23      -3.327  37.168  -3.143  0.01  4.44           C  
ATOM  52032  CD2 LEU a  23      -2.237  36.492  -5.291  0.01  4.44           C  
ATOM  52033  N   ALA a  24      -5.423  32.533  -4.585  0.01  4.44           N  
ATOM  52034  CA  ALA a  24      -6.210  31.365  -4.209  0.01  4.44           C  
ATOM  52035  C   ALA a  24      -6.024  30.227  -5.211  0.01  4.44           C  
ATOM  52036  O   ALA a  24      -6.193  29.055  -4.878  0.01  4.44           O  
ATOM  52037  CB  ALA a  24      -7.680  31.735  -4.101  0.01  4.44           C  
ATOM  52038  N   LYS a  25      -5.672  30.587  -6.443  0.01  4.44           N  
ATOM  52039  CA  LYS a  25      -5.459  29.608  -7.500  0.01  4.44           C  
ATOM  52040  C   LYS a  25      -4.093  28.946  -7.364  0.01  4.44           C  
ATOM  52041  O   LYS a  25      -3.901  27.803  -7.778  0.01  4.44           O  
ATOM  52042  CB  LYS a  25      -5.572  30.277  -8.867  0.01  4.44           C  
ATOM  52043  CG  LYS a  25      -5.521  29.299 -10.032  0.01  4.44           C  
ATOM  52044  CD  LYS a  25      -4.248  29.462 -10.849  0.01  4.44           C  
ATOM  52045  CE  LYS a  25      -4.541  30.008 -12.238  0.01  4.44           C  
ATOM  52046  NZ  LYS a  25      -5.156  28.978 -13.119  0.01  4.44           N  
ATOM  52047  N   LEU a  26      -3.144  29.675  -6.786  0.01  4.44           N  
ATOM  52048  CA  LEU a  26      -1.793  29.161  -6.601  0.01  4.44           C  
ATOM  52049  C   LEU a  26      -1.739  28.177  -5.434  0.01  4.44           C  
ATOM  52050  O   LEU a  26      -1.009  28.386  -4.462  0.01  4.44           O  
ATOM  52051  CB  LEU a  26      -0.817  30.313  -6.361  0.01  4.44           C  
ATOM  52052  CG  LEU a  26      -0.657  31.283  -7.533  0.01  4.44           C  
ATOM  52053  CD1 LEU a  26      -0.432  32.701  -7.030  0.01  4.44           C  
ATOM  52054  CD2 LEU a  26       0.493  30.846  -8.430  0.01  4.44           C  
ATOM  52055  N   GLU a  27      -2.516  27.104  -5.537  0.01  4.44           N  
ATOM  52056  CA  GLU a  27      -2.562  26.082  -4.497  0.01  4.44           C  
ATOM  52057  C   GLU a  27      -1.276  25.258  -4.488  0.01  4.44           C  
ATOM  52058  O   GLU a  27      -0.628  25.111  -3.451  0.01  4.44           O  
ATOM  52059  CB  GLU a  27      -3.771  25.167  -4.702  0.01  4.44           C  
ATOM  52060  CG  GLU a  27      -4.720  25.140  -3.514  0.01  4.44           C  
ATOM  52061  CD  GLU a  27      -4.621  23.852  -2.720  0.01  4.44           C  
ATOM  52062  OE1 GLU a  27      -4.650  22.769  -3.340  0.01  4.44           O  
ATOM  52063  OE2 GLU a  27      -4.516  23.928  -1.478  0.01  4.44           O  
ATOM  52064  N   LYS a  28      -0.908  24.728  -5.650  0.01  4.44           N  
ATOM  52065  CA  LYS a  28       0.307  23.922  -5.782  0.01  4.44           C  
ATOM  52066  C   LYS a  28       1.516  24.663  -5.218  0.01  4.44           C  
ATOM  52067  O   LYS a  28       2.501  24.058  -4.799  0.01  4.44           O  
ATOM  52068  CB  LYS a  28       0.538  23.555  -7.258  0.01  4.44           C  
ATOM  52069  CG  LYS a  28       1.275  24.617  -8.069  0.01  4.44           C  
ATOM  52070  CD  LYS a  28       2.645  24.128  -8.516  0.01  4.44           C  
ATOM  52071  CE  LYS a  28       2.656  23.778  -9.996  0.01  4.44           C  
ATOM  52072  NZ  LYS a  28       1.655  22.726 -10.329  0.01  4.44           N  
ATOM  52073  N   TRP a  29       1.418  25.982  -5.232  0.01  4.44           N  
ATOM  52074  CA  TRP a  29       2.473  26.858  -4.749  0.01  4.44           C  
ATOM  52075  C   TRP a  29       2.344  27.129  -3.254  0.01  4.44           C  
ATOM  52076  O   TRP a  29       3.332  27.426  -2.583  0.01  4.44           O  
ATOM  52077  CB  TRP a  29       2.414  28.160  -5.544  0.01  4.44           C  
ATOM  52078  CG  TRP a  29       2.454  27.897  -7.016  0.01  4.44           C  
ATOM  52079  CD1 TRP a  29       1.434  28.049  -7.909  0.01  4.44           C  
ATOM  52080  CD2 TRP a  29       3.569  27.394  -7.760  0.01  4.44           C  
ATOM  52081  NE1 TRP a  29       1.848  27.673  -9.164  0.01  4.44           N  
ATOM  52082  CE2 TRP a  29       3.157  27.272  -9.099  0.01  4.44           C  
ATOM  52083  CE3 TRP a  29       4.877  27.043  -7.419  0.01  4.44           C  
ATOM  52084  CZ2 TRP a  29       4.013  26.809 -10.098  0.01  4.44           C  
ATOM  52085  CZ3 TRP a  29       5.720  26.583  -8.409  0.01  4.44           C  
ATOM  52086  CH2 TRP a  29       5.288  26.471  -9.735  0.01  4.44           C  
ATOM  52087  N   GLN a  30       1.123  27.023  -2.739  0.01  4.44           N  
ATOM  52088  CA  GLN a  30       0.868  27.255  -1.322  0.01  4.44           C  
ATOM  52089  C   GLN a  30       1.769  26.379  -0.456  0.01  4.44           C  
ATOM  52090  O   GLN a  30       1.658  25.153  -0.469  0.01  4.44           O  
ATOM  52091  CB  GLN a  30      -0.601  26.977  -0.995  0.01  4.44           C  
ATOM  52092  CG  GLN a  30      -1.184  27.925   0.039  0.01  4.44           C  
ATOM  52093  CD  GLN a  30      -1.206  27.328   1.433  0.01  4.44           C  
ATOM  52094  OE1 GLN a  30      -0.390  27.678   2.283  0.01  4.44           O  
ATOM  52095  NE2 GLN a  30      -2.145  26.419   1.672  0.01  4.44           N  
ATOM  52096  N   THR a  31       2.665  27.018   0.288  0.01  4.44           N  
ATOM  52097  CA  THR a  31       3.588  26.298   1.155  0.01  4.44           C  
ATOM  52098  C   THR a  31       4.145  27.205   2.249  0.01  4.44           C  
ATOM  52099  O   THR a  31       4.290  26.784   3.398  0.01  4.44           O  
ATOM  52100  CB  THR a  31       4.724  25.701   0.322  0.01  4.44           C  
ATOM  52101  OG1 THR a  31       5.538  24.854   1.111  0.01  4.44           O  
ATOM  52102  CG2 THR a  31       5.620  26.744  -0.310  0.01  4.44           C  
ATOM  52103  N   HIS a  32       4.448  28.453   1.897  0.01  4.44           N  
ATOM  52104  CA  HIS a  32       4.977  29.407   2.865  0.01  4.44           C  
ATOM  52105  C   HIS a  32       4.431  30.818   2.600  0.01  4.44           C  
ATOM  52106  O   HIS a  32       3.218  31.024   2.638  0.01  4.44           O  
ATOM  52107  CB  HIS a  32       6.511  29.379   2.862  0.01  4.44           C  
ATOM  52108  CG  HIS a  32       7.114  29.270   1.497  0.01  4.44           C  
ATOM  52109  ND1 HIS a  32       6.709  30.038   0.425  0.01  4.44           N  
ATOM  52110  CD2 HIS a  32       8.100  28.467   1.029  0.01  4.44           C  
ATOM  52111  CE1 HIS a  32       7.420  29.715  -0.639  0.01  4.44           C  
ATOM  52112  NE2 HIS a  32       8.272  28.765  -0.299  0.01  4.44           N  
ATOM  52113  N   LEU a  33       5.311  31.788   2.335  0.01  4.44           N  
ATOM  52114  CA  LEU a  33       4.876  33.158   2.076  0.01  4.44           C  
ATOM  52115  C   LEU a  33       4.141  33.723   3.287  0.01  4.44           C  
ATOM  52116  O   LEU a  33       3.084  33.223   3.673  0.01  4.44           O  
ATOM  52117  CB  LEU a  33       3.969  33.205   0.843  0.01  4.44           C  
ATOM  52118  CG  LEU a  33       4.602  32.671  -0.446  0.01  4.44           C  
ATOM  52119  CD1 LEU a  33       3.966  31.348  -0.846  0.01  4.44           C  
ATOM  52120  CD2 LEU a  33       4.469  33.690  -1.568  0.01  4.44           C  
ATOM  52121  N   ILE a  34       4.705  34.766   3.890  0.01  4.44           N  
ATOM  52122  CA  ILE a  34       4.098  35.384   5.062  0.01  4.44           C  
ATOM  52123  C   ILE a  34       3.926  36.887   4.875  0.01  4.44           C  
ATOM  52124  O   ILE a  34       4.890  37.648   4.968  0.01  4.44           O  
ATOM  52125  CB  ILE a  34       4.936  35.127   6.329  0.01  4.44           C  
ATOM  52126  CG1 ILE a  34       5.266  33.638   6.461  0.01  4.44           C  
ATOM  52127  CG2 ILE a  34       4.200  35.624   7.564  0.01  4.44           C  
ATOM  52128  CD1 ILE a  34       6.732  33.365   6.720  0.01  4.44           C  
ATOM  52129  N   ASN a  35       2.691  37.308   4.627  0.01  4.44           N  
ATOM  52130  CA  ASN a  35       2.388  38.722   4.441  0.01  4.44           C  
ATOM  52131  C   ASN a  35       3.138  39.302   3.244  0.01  4.44           C  
ATOM  52132  O   ASN a  35       4.103  40.048   3.407  0.01  4.44           O  
ATOM  52133  CB  ASN a  35       2.741  39.507   5.706  0.01  4.44           C  
ATOM  52134  CG  ASN a  35       2.106  38.917   6.949  0.01  4.44           C  
ATOM  52135  OD1 ASN a  35       1.669  37.767   6.954  0.01  4.44           O  
ATOM  52136  ND2 ASN a  35       2.052  39.707   8.016  0.01  4.44           N  
ATOM  52137  N   PRO a  36       2.697  38.972   2.018  0.01  4.44           N  
ATOM  52138  CA  PRO a  36       3.321  39.471   0.793  0.01  4.44           C  
ATOM  52139  C   PRO a  36       2.933  40.918   0.502  0.01  4.44           C  
ATOM  52140  O   PRO a  36       1.884  41.388   0.941  0.01  4.44           O  
ATOM  52141  CB  PRO a  36       2.772  38.538  -0.281  0.01  4.44           C  
ATOM  52142  CG  PRO a  36       1.430  38.137   0.227  0.01  4.44           C  
ATOM  52143  CD  PRO a  36       1.543  38.094   1.731  0.01  4.44           C  
ATOM  52144  N   HIS a  37       3.788  41.618  -0.236  0.01  4.44           N  
ATOM  52145  CA  HIS a  37       3.535  43.013  -0.577  0.01  4.44           C  
ATOM  52146  C   HIS a  37       3.867  43.294  -2.038  0.01  4.44           C  
ATOM  52147  O   HIS a  37       4.948  42.952  -2.520  0.01  4.44           O  
ATOM  52148  CB  HIS a  37       4.354  43.937   0.329  0.01  4.44           C  
ATOM  52149  CG  HIS a  37       3.574  45.099   0.861  0.01  4.44           C  
ATOM  52150  ND1 HIS a  37       3.209  45.218   2.186  0.01  4.44           N  
ATOM  52151  CD2 HIS a  37       3.089  46.199   0.239  0.01  4.44           C  
ATOM  52152  CE1 HIS a  37       2.533  46.339   2.355  0.01  4.44           C  
ATOM  52153  NE2 HIS a  37       2.448  46.955   1.190  0.01  4.44           N  
ATOM  52154  N   ILE a  38       2.927  43.922  -2.737  0.01  4.44           N  
ATOM  52155  CA  ILE a  38       3.108  44.258  -4.144  0.01  4.44           C  
ATOM  52156  C   ILE a  38       2.977  45.762  -4.363  0.01  4.44           C  
ATOM  52157  O   ILE a  38       2.061  46.400  -3.842  0.01  4.44           O  
ATOM  52158  CB  ILE a  38       2.084  43.527  -5.033  0.01  4.44           C  
ATOM  52159  CG1 ILE a  38       2.120  42.022  -4.757  0.01  4.44           C  
ATOM  52160  CG2 ILE a  38       2.357  43.807  -6.506  0.01  4.44           C  
ATOM  52161  CD1 ILE a  38       1.417  41.624  -3.478  0.01  4.44           C  
ATOM  52162  N   ILE a  39       3.900  46.321  -5.136  0.01  4.44           N  
ATOM  52163  CA  ILE a  39       3.894  47.748  -5.429  0.01  4.44           C  
ATOM  52164  C   ILE a  39       3.697  47.999  -6.921  0.01  4.44           C  
ATOM  52165  O   ILE a  39       4.159  47.224  -7.758  0.01  4.44           O  
ATOM  52166  CB  ILE a  39       5.207  48.417  -4.979  0.01  4.44           C  
ATOM  52167  CG1 ILE a  39       5.522  48.047  -3.527  0.01  4.44           C  
ATOM  52168  CG2 ILE a  39       5.115  49.928  -5.139  0.01  4.44           C  
ATOM  52169  CD1 ILE a  39       6.440  46.854  -3.393  0.01  4.44           C  
ATOM  52170  N   LEU a  40       3.006  49.085  -7.246  0.01  4.44           N  
ATOM  52171  CA  LEU a  40       2.744  49.443  -8.636  0.01  4.44           C  
ATOM  52172  C   LEU a  40       3.284  50.831  -8.955  0.01  4.44           C  
ATOM  52173  O   LEU a  40       2.994  51.802  -8.256  0.01  4.44           O  
ATOM  52174  CB  LEU a  40       1.242  49.394  -8.923  0.01  4.44           C  
ATOM  52175  CG  LEU a  40       0.543  48.102  -8.495  0.01  4.44           C  
ATOM  52176  CD1 LEU a  40      -0.828  48.405  -7.909  0.01  4.44           C  
ATOM  52177  CD2 LEU a  40       0.421  47.147  -9.674  0.01  4.44           C  
ATOM  52178  N   SER a  41       4.067  50.917 -10.026  0.01  4.44           N  
ATOM  52179  CA  SER a  41       4.649  52.180 -10.458  0.01  4.44           C  
ATOM  52180  C   SER a  41       4.266  52.471 -11.903  0.01  4.44           C  
ATOM  52181  O   SER a  41       3.462  51.754 -12.498  0.01  4.44           O  
ATOM  52182  CB  SER a  41       6.171  52.145 -10.312  0.01  4.44           C  
ATOM  52183  OG  SER a  41       6.554  51.606  -9.060  0.01  4.44           O  
ATOM  52184  N   LYS a  42       4.839  53.530 -12.464  0.01  4.44           N  
ATOM  52185  CA  LYS a  42       4.545  53.911 -13.840  0.01  4.44           C  
ATOM  52186  C   LYS a  42       5.649  54.778 -14.426  0.01  4.44           C  
ATOM  52187  O   LYS a  42       6.207  55.647 -13.754  0.01  4.44           O  
ATOM  52188  CB  LYS a  42       3.208  54.654 -13.908  0.01  4.44           C  
ATOM  52189  CG  LYS a  42       2.804  55.061 -15.315  0.01  4.44           C  
ATOM  52190  CD  LYS a  42       2.074  56.394 -15.323  0.01  4.44           C  
ATOM  52191  CE  LYS a  42       0.804  56.333 -16.160  0.01  4.44           C  
ATOM  52192  NZ  LYS a  42      -0.418  56.271 -15.312  0.01  4.44           N  
ATOM  52193  N   GLU a  43       5.939  54.536 -15.694  0.01  4.44           N  
ATOM  52194  CA  GLU a  43       6.952  55.276 -16.421  0.01  4.44           C  
ATOM  52195  C   GLU a  43       6.381  55.722 -17.763  0.01  4.44           C  
ATOM  52196  O   GLU a  43       5.436  55.114 -18.267  0.01  4.44           O  
ATOM  52197  CB  GLU a  43       8.189  54.403 -16.647  0.01  4.44           C  
ATOM  52198  CG  GLU a  43       8.846  53.937 -15.360  0.01  4.44           C  
ATOM  52199  CD  GLU a  43      10.306  53.573 -15.550  0.01  4.44           C  
ATOM  52200  OE1 GLU a  43      11.115  54.482 -15.824  0.01  4.44           O  
ATOM  52201  OE2 GLU a  43      10.640  52.373 -15.423  0.01  4.44           O  
ATOM  52202  N   PRO a  44       6.929  56.781 -18.366  0.01  4.44           N  
ATOM  52203  CA  PRO a  44       6.442  57.277 -19.656  0.01  4.44           C  
ATOM  52204  C   PRO a  44       6.355  56.176 -20.704  0.01  4.44           C  
ATOM  52205  O   PRO a  44       5.598  56.276 -21.672  0.01  4.44           O  
ATOM  52206  CB  PRO a  44       7.489  58.313 -20.054  0.01  4.44           C  
ATOM  52207  CG  PRO a  44       8.073  58.776 -18.763  0.01  4.44           C  
ATOM  52208  CD  PRO a  44       8.057  57.580 -17.853  0.01  4.44           C  
ATOM  52209  N   GLN a  45       7.153  55.140 -20.507  0.01  4.44           N  
ATOM  52210  CA  GLN a  45       7.203  54.016 -21.429  0.01  4.44           C  
ATOM  52211  C   GLN a  45       6.198  52.913 -21.075  0.01  4.44           C  
ATOM  52212  O   GLN a  45       6.036  51.959 -21.834  0.01  4.44           O  
ATOM  52213  CB  GLN a  45       8.614  53.433 -21.471  0.01  4.44           C  
ATOM  52214  CG  GLN a  45       9.028  52.941 -22.848  0.01  4.44           C  
ATOM  52215  CD  GLN a  45      10.384  53.472 -23.275  0.01  4.44           C  
ATOM  52216  OE1 GLN a  45      11.394  52.778 -23.177  0.01  4.44           O  
ATOM  52217  NE2 GLN a  45      10.408  54.710 -23.755  0.01  4.44           N  
ATOM  52218  N   GLY a  46       5.526  53.039 -19.933  0.01  4.44           N  
ATOM  52219  CA  GLY a  46       4.557  52.028 -19.540  0.01  4.44           C  
ATOM  52220  C   GLY a  46       4.448  51.896 -18.037  0.01  4.44           C  
ATOM  52221  O   GLY a  46       4.895  52.770 -17.306  0.01  4.44           O  
ATOM  52222  N   PHE a  47       3.853  50.806 -17.567  0.01  4.44           N  
ATOM  52223  CA  PHE a  47       3.700  50.588 -16.131  0.01  4.44           C  
ATOM  52224  C   PHE a  47       4.616  49.490 -15.619  0.01  4.44           C  
ATOM  52225  O   PHE a  47       5.007  48.581 -16.355  0.01  4.44           O  
ATOM  52226  CB  PHE a  47       2.252  50.259 -15.797  0.01  4.44           C  
ATOM  52227  CG  PHE a  47       1.305  51.236 -16.408  0.01  4.44           C  
ATOM  52228  CD1 PHE a  47       0.750  52.246 -15.648  0.01  4.44           C  
ATOM  52229  CD2 PHE a  47       0.994  51.153 -17.748  0.01  4.44           C  
ATOM  52230  CE1 PHE a  47      -0.107  53.164 -16.220  0.01  4.44           C  
ATOM  52231  CE2 PHE a  47       0.138  52.061 -18.327  0.01  4.44           C  
ATOM  52232  CZ  PHE a  47      -0.415  53.071 -17.565  0.01  4.44           C  
ATOM  52233  N   VAL a  48       4.964  49.604 -14.344  0.01  4.44           N  
ATOM  52234  CA  VAL a  48       5.848  48.650 -13.694  0.01  4.44           C  
ATOM  52235  C   VAL a  48       5.225  48.114 -12.408  0.01  4.44           C  
ATOM  52236  O   VAL a  48       4.573  48.851 -11.669  0.01  4.44           O  
ATOM  52237  CB  VAL a  48       7.209  49.308 -13.378  0.01  4.44           C  
ATOM  52238  CG1 VAL a  48       8.054  48.428 -12.466  0.01  4.44           C  
ATOM  52239  CG2 VAL a  48       7.957  49.623 -14.665  0.01  4.44           C  
ATOM  52240  N   ALA a  49       5.431  46.829 -12.145  0.01  4.44           N  
ATOM  52241  CA  ALA a  49       4.895  46.200 -10.945  0.01  4.44           C  
ATOM  52242  C   ALA a  49       5.966  45.377 -10.235  0.01  4.44           C  
ATOM  52243  O   ALA a  49       6.577  44.494 -10.831  0.01  4.44           O  
ATOM  52244  CB  ALA a  49       3.701  45.325 -11.298  0.01  4.44           C  
ATOM  52245  N   ASP a  50       6.181  45.670  -8.956  0.01  4.44           N  
ATOM  52246  CA  ASP a  50       7.174  44.949  -8.165  0.01  4.44           C  
ATOM  52247  C   ASP a  50       6.504  44.219  -7.008  0.01  4.44           C  
ATOM  52248  O   ASP a  50       5.480  44.668  -6.494  0.01  4.44           O  
ATOM  52249  CB  ASP a  50       8.230  45.919  -7.627  0.01  4.44           C  
ATOM  52250  CG  ASP a  50       9.207  46.360  -8.700  0.01  4.44           C  
ATOM  52251  OD1 ASP a  50       8.783  47.077  -9.633  0.01  4.44           O  
ATOM  52252  OD2 ASP a  50      10.395  45.990  -8.608  0.01  4.44           O  
ATOM  52253  N   ALA a  51       7.076  43.093  -6.599  0.01  4.44           N  
ATOM  52254  CA  ALA a  51       6.508  42.318  -5.504  0.01  4.44           C  
ATOM  52255  C   ALA a  51       7.590  41.640  -4.671  0.01  4.44           C  
ATOM  52256  O   ALA a  51       8.591  41.158  -5.204  0.01  4.44           O  
ATOM  52257  CB  ALA a  51       5.531  41.285  -6.043  0.01  4.44           C  
ATOM  52258  N   THR a  52       7.375  41.599  -3.361  0.01  4.44           N  
ATOM  52259  CA  THR a  52       8.323  40.973  -2.448  0.01  4.44           C  
ATOM  52260  C   THR a  52       7.590  40.083  -1.452  0.01  4.44           C  
ATOM  52261  O   THR a  52       6.575  40.485  -0.884  0.01  4.44           O  
ATOM  52262  CB  THR a  52       9.128  42.040  -1.704  0.01  4.44           C  
ATOM  52263  OG1 THR a  52       9.517  43.080  -2.584  0.01  4.44           O  
ATOM  52264  CG2 THR a  52      10.381  41.497  -1.051  0.01  4.44           C  
ATOM  52265  N   ILE a  53       8.099  38.874  -1.245  0.01  4.44           N  
ATOM  52266  CA  ILE a  53       7.474  37.936  -0.317  0.01  4.44           C  
ATOM  52267  C   ILE a  53       8.507  37.315   0.616  0.01  4.44           C  
ATOM  52268  O   ILE a  53       9.562  36.854   0.178  0.01  4.44           O  
ATOM  52269  CB  ILE a  53       6.734  36.806  -1.063  0.01  4.44           C  
ATOM  52270  CG1 ILE a  53       6.146  37.320  -2.379  0.01  4.44           C  
ATOM  52271  CG2 ILE a  53       5.641  36.220  -0.181  0.01  4.44           C  
ATOM  52272  CD1 ILE a  53       5.070  38.368  -2.194  0.01  4.44           C  
ATOM  52273  N   ASN a  54       8.185  37.289   1.904  0.01  4.44           N  
ATOM  52274  CA  ASN a  54       9.064  36.706   2.911  0.01  4.44           C  
ATOM  52275  C   ASN a  54       8.559  35.331   3.327  0.01  4.44           C  
ATOM  52276  O   ASN a  54       7.381  35.161   3.640  0.01  4.44           O  
ATOM  52277  CB  ASN a  54       9.153  37.618   4.135  0.01  4.44           C  
ATOM  52278  CG  ASN a  54       9.362  39.074   3.764  0.01  4.44           C  
ATOM  52279  OD1 ASN a  54       9.971  39.384   2.741  0.01  4.44           O  
ATOM  52280  ND2 ASN a  54       8.852  39.976   4.595  0.01  4.44           N  
ATOM  52281  N   THR a  55       9.455  34.350   3.333  0.01  4.44           N  
ATOM  52282  CA  THR a  55       9.089  32.991   3.716  0.01  4.44           C  
ATOM  52283  C   THR a  55      10.040  32.453   4.781  0.01  4.44           C  
ATOM  52284  O   THR a  55      11.104  33.024   5.018  0.01  4.44           O  
ATOM  52285  CB  THR a  55       9.100  32.070   2.492  0.01  4.44           C  
ATOM  52286  OG1 THR a  55      10.425  31.689   2.161  0.01  4.44           O  
ATOM  52287  CG2 THR a  55       8.482  32.699   1.260  0.01  4.44           C  
ATOM  52288  N   PRO a  56       9.669  31.345   5.443  0.01  4.44           N  
ATOM  52289  CA  PRO a  56      10.493  30.735   6.489  0.01  4.44           C  
ATOM  52290  C   PRO a  56      11.762  30.089   5.935  0.01  4.44           C  
ATOM  52291  O   PRO a  56      12.636  29.673   6.693  0.01  4.44           O  
ATOM  52292  CB  PRO a  56       9.580  29.663   7.107  0.01  4.44           C  
ATOM  52293  CG  PRO a  56       8.214  29.929   6.561  0.01  4.44           C  
ATOM  52294  CD  PRO a  56       8.422  30.602   5.234  0.01  4.44           C  
ATOM  52295  N   ASN a  57      11.858  30.001   4.610  0.01  4.44           N  
ATOM  52296  CA  ASN a  57      13.022  29.395   3.971  0.01  4.44           C  
ATOM  52297  C   ASN a  57      13.694  30.359   2.995  0.01  4.44           C  
ATOM  52298  O   ASN a  57      14.401  29.934   2.081  0.01  4.44           O  
ATOM  52299  CB  ASN a  57      12.615  28.119   3.236  0.01  4.44           C  
ATOM  52300  CG  ASN a  57      12.212  27.009   4.188  0.01  4.44           C  
ATOM  52301  OD1 ASN a  57      12.899  25.995   4.306  0.01  4.44           O  
ATOM  52302  ND2 ASN a  57      11.089  27.196   4.872  0.01  4.44           N  
ATOM  52303  N   GLY a  58      13.478  31.657   3.192  0.01  4.44           N  
ATOM  52304  CA  GLY a  58      14.084  32.647   2.316  0.01  4.44           C  
ATOM  52305  C   GLY a  58      13.100  33.698   1.845  0.01  4.44           C  
ATOM  52306  O   GLY a  58      11.995  33.809   2.372  0.01  4.44           O  
ATOM  52307  N   VAL a  59      13.509  34.476   0.844  0.01  4.44           N  
ATOM  52308  CA  VAL a  59      12.663  35.530   0.299  0.01  4.44           C  
ATOM  52309  C   VAL a  59      12.717  35.537  -1.227  0.01  4.44           C  
ATOM  52310  O   VAL a  59      13.764  35.284  -1.823  0.01  4.44           O  
ATOM  52311  CB  VAL a  59      13.086  36.917   0.822  0.01  4.44           C  
ATOM  52312  CG1 VAL a  59      12.047  37.965   0.457  0.01  4.44           C  
ATOM  52313  CG2 VAL a  59      13.303  36.875   2.327  0.01  4.44           C  
ATOM  52314  N   LEU a  60      11.581  35.829  -1.856  0.01  4.44           N  
ATOM  52315  CA  LEU a  60      11.499  35.868  -3.311  0.01  4.44           C  
ATOM  52316  C   LEU a  60      11.185  37.278  -3.803  0.01  4.44           C  
ATOM  52317  O   LEU a  60      10.610  38.088  -3.071  0.01  4.44           O  
ATOM  52318  CB  LEU a  60      10.431  34.894  -3.811  0.01  4.44           C  
ATOM  52319  CG  LEU a  60      10.549  33.471  -3.263  0.01  4.44           C  
ATOM  52320  CD1 LEU a  60       9.170  32.895  -2.969  0.01  4.44           C  
ATOM  52321  CD2 LEU a  60      11.300  32.582  -4.243  0.01  4.44           C  
ATOM  52322  N   VAL a  61      11.564  37.567  -5.044  0.01  4.44           N  
ATOM  52323  CA  VAL a  61      11.322  38.876  -5.632  0.01  4.44           C  
ATOM  52324  C   VAL a  61      10.904  38.758  -7.095  0.01  4.44           C  
ATOM  52325  O   VAL a  61      11.329  37.846  -7.802  0.01  4.44           O  
ATOM  52326  CB  VAL a  61      12.573  39.773  -5.543  0.01  4.44           C  
ATOM  52327  CG1 VAL a  61      12.244  41.193  -5.974  0.01  4.44           C  
ATOM  52328  CG2 VAL a  61      13.142  39.754  -4.131  0.01  4.44           C  
ATOM  52329  N   ALA a  62      10.065  39.688  -7.541  0.01  4.44           N  
ATOM  52330  CA  ALA a  62       9.585  39.690  -8.919  0.01  4.44           C  
ATOM  52331  C   ALA a  62       9.205  41.100  -9.364  0.01  4.44           C  
ATOM  52332  O   ALA a  62       8.743  41.913  -8.564  0.01  4.44           O  
ATOM  52333  CB  ALA a  62       8.400  38.750  -9.069  0.01  4.44           C  
ATOM  52334  N   SER a  63       9.421  41.382 -10.645  0.01  4.44           N  
ATOM  52335  CA  SER a  63       9.113  42.698 -11.194  0.01  4.44           C  
ATOM  52336  C   SER a  63       8.638  42.611 -12.642  0.01  4.44           C  
ATOM  52337  O   SER a  63       8.964  41.663 -13.358  0.01  4.44           O  
ATOM  52338  CB  SER a  63      10.343  43.605 -11.108  0.01  4.44           C  
ATOM  52339  OG  SER a  63      11.122  43.300  -9.965  0.01  4.44           O  
ATOM  52340  N   GLY a  64       7.881  43.618 -13.065  0.01  4.44           N  
ATOM  52341  CA  GLY a  64       7.377  43.668 -14.425  0.01  4.44           C  
ATOM  52342  C   GLY a  64       7.373  45.089 -14.957  0.01  4.44           C  
ATOM  52343  O   GLY a  64       7.313  46.038 -14.178  0.01  4.44           O  
ATOM  52344  N   LYS a  65       7.449  45.247 -16.274  0.01  4.44           N  
ATOM  52345  CA  LYS a  65       7.466  46.578 -16.873  0.01  4.44           C  
ATOM  52346  C   LYS a  65       6.786  46.600 -18.237  0.01  4.44           C  
ATOM  52347  O   LYS a  65       7.275  47.230 -19.175  0.01  4.44           O  
ATOM  52348  CB  LYS a  65       8.906  47.080 -17.005  0.01  4.44           C  
ATOM  52349  CG  LYS a  65       9.659  47.129 -15.683  0.01  4.44           C  
ATOM  52350  CD  LYS a  65      10.747  48.190 -15.703  0.01  4.44           C  
ATOM  52351  CE  LYS a  65      11.446  48.297 -14.358  0.01  4.44           C  
ATOM  52352  NZ  LYS a  65      12.924  48.416 -14.508  0.01  4.44           N  
ATOM  52353  N   HIS a  66       5.648  45.925 -18.342  0.01  4.44           N  
ATOM  52354  CA  HIS a  66       4.901  45.896 -19.593  0.01  4.44           C  
ATOM  52355  C   HIS a  66       4.164  47.215 -19.800  0.01  4.44           C  
ATOM  52356  O   HIS a  66       3.855  47.922 -18.837  0.01  4.44           O  
ATOM  52357  CB  HIS a  66       3.909  44.733 -19.614  0.01  4.44           C  
ATOM  52358  CG  HIS a  66       3.475  44.347 -20.994  0.01  4.44           C  
ATOM  52359  ND1 HIS a  66       2.201  44.561 -21.477  0.01  4.44           N  
ATOM  52360  CD2 HIS a  66       4.160  43.752 -22.000  0.01  4.44           C  
ATOM  52361  CE1 HIS a  66       2.124  44.115 -22.721  0.01  4.44           C  
ATOM  52362  NE2 HIS a  66       3.298  43.621 -23.059  0.01  4.44           N  
ATOM  52363  N   GLU a  67       3.879  47.548 -21.052  0.01  4.44           N  
ATOM  52364  CA  GLU a  67       3.176  48.785 -21.372  0.01  4.44           C  
ATOM  52365  C   GLU a  67       1.789  48.813 -20.733  0.01  4.44           C  
ATOM  52366  O   GLU a  67       1.234  49.883 -20.481  0.01  4.44           O  
ATOM  52367  CB  GLU a  67       3.052  48.947 -22.889  0.01  4.44           C  
ATOM  52368  CG  GLU a  67       4.352  48.693 -23.635  0.01  4.44           C  
ATOM  52369  CD  GLU a  67       4.607  49.717 -24.725  0.01  4.44           C  
ATOM  52370  OE1 GLU a  67       4.735  49.316 -25.900  0.01  4.44           O  
ATOM  52371  OE2 GLU a  67       4.682  50.922 -24.402  0.01  4.44           O  
ATOM  52372  N   ASP a  68       1.230  47.633 -20.489  0.01  4.44           N  
ATOM  52373  CA  ASP a  68      -0.098  47.522 -19.893  0.01  4.44           C  
ATOM  52374  C   ASP a  68      -0.016  47.262 -18.390  0.01  4.44           C  
ATOM  52375  O   ASP a  68       0.578  46.279 -17.948  0.01  4.44           O  
ATOM  52376  CB  ASP a  68      -0.890  46.404 -20.571  0.01  4.44           C  
ATOM  52377  CG  ASP a  68      -2.308  46.298 -20.050  0.01  4.44           C  
ATOM  52378  OD1 ASP a  68      -2.832  45.166 -19.982  0.01  4.44           O  
ATOM  52379  OD2 ASP a  68      -2.894  47.346 -19.710  0.01  4.44           O  
ATOM  52380  N   MET a  69      -0.624  48.156 -17.613  0.01  4.44           N  
ATOM  52381  CA  MET a  69      -0.634  48.042 -16.154  0.01  4.44           C  
ATOM  52382  C   MET a  69      -1.031  46.639 -15.698  0.01  4.44           C  
ATOM  52383  O   MET a  69      -0.368  46.040 -14.851  0.01  4.44           O  
ATOM  52384  CB  MET a  69      -1.602  49.067 -15.560  0.01  4.44           C  
ATOM  52385  CG  MET a  69      -1.616  49.078 -14.040  0.01  4.44           C  
ATOM  52386  SD  MET a  69      -3.260  49.387 -13.364  0.01  4.44           S  
ATOM  52387  CE  MET a  69      -2.929  49.286 -11.607  0.01  4.44           C  
ATOM  52388  N   TYR a  70      -2.125  46.128 -16.256  0.01  4.44           N  
ATOM  52389  CA  TYR a  70      -2.622  44.802 -15.897  0.01  4.44           C  
ATOM  52390  C   TYR a  70      -1.650  43.709 -16.321  0.01  4.44           C  
ATOM  52391  O   TYR a  70      -1.467  42.719 -15.610  0.01  4.44           O  
ATOM  52392  CB  TYR a  70      -3.989  44.560 -16.537  0.01  4.44           C  
ATOM  52393  CG  TYR a  70      -5.134  45.206 -15.788  0.01  4.44           C  
ATOM  52394  CD1 TYR a  70      -5.895  44.480 -14.882  0.01  4.44           C  
ATOM  52395  CD2 TYR a  70      -5.450  46.544 -15.988  0.01  4.44           C  
ATOM  52396  CE1 TYR a  70      -6.940  45.067 -14.195  0.01  4.44           C  
ATOM  52397  CE2 TYR a  70      -6.494  47.140 -15.304  0.01  4.44           C  
ATOM  52398  CZ  TYR a  70      -7.235  46.398 -14.410  0.01  4.44           C  
ATOM  52399  OH  TYR a  70      -8.276  46.987 -13.729  0.01  4.44           O  
ATOM  52400  N   THR a  71      -1.024  43.887 -17.479  0.01  4.44           N  
ATOM  52401  CA  THR a  71      -0.071  42.904 -17.983  0.01  4.44           C  
ATOM  52402  C   THR a  71       1.143  42.815 -17.065  0.01  4.44           C  
ATOM  52403  O   THR a  71       1.648  41.726 -16.793  0.01  4.44           O  
ATOM  52404  CB  THR a  71       0.367  43.264 -19.402  0.01  4.44           C  
ATOM  52405  OG1 THR a  71      -0.746  43.300 -20.276  0.01  4.44           O  
ATOM  52406  CG2 THR a  71       1.376  42.297 -19.983  0.01  4.44           C  
ATOM  52407  N   ALA a  72       1.602  43.965 -16.581  0.01  4.44           N  
ATOM  52408  CA  ALA a  72       2.752  44.007 -15.687  0.01  4.44           C  
ATOM  52409  C   ALA a  72       2.459  43.242 -14.402  0.01  4.44           C  
ATOM  52410  O   ALA a  72       3.259  42.411 -13.972  0.01  4.44           O  
ATOM  52411  CB  ALA a  72       3.141  45.446 -15.378  0.01  4.44           C  
ATOM  52412  N   ILE a  73       1.307  43.511 -13.796  0.01  4.44           N  
ATOM  52413  CA  ILE a  73       0.923  42.824 -12.569  0.01  4.44           C  
ATOM  52414  C   ILE a  73       0.829  41.321 -12.813  0.01  4.44           C  
ATOM  52415  O   ILE a  73       1.301  40.520 -12.007  0.01  4.44           O  
ATOM  52416  CB  ILE a  73      -0.421  43.345 -12.019  0.01  4.44           C  
ATOM  52417  CG1 ILE a  73      -0.299  44.820 -11.631  0.01  4.44           C  
ATOM  52418  CG2 ILE a  73      -0.871  42.517 -10.825  0.01  4.44           C  
ATOM  52419  CD1 ILE a  73      -1.547  45.624 -11.912  0.01  4.44           C  
ATOM  52420  N   ASN a  74       0.232  40.947 -13.939  0.01  4.44           N  
ATOM  52421  CA  ASN a  74       0.095  39.542 -14.297  0.01  4.44           C  
ATOM  52422  C   ASN a  74       1.470  38.923 -14.541  0.01  4.44           C  
ATOM  52423  O   ASN a  74       1.731  37.784 -14.150  0.01  4.44           O  
ATOM  52424  CB  ASN a  74      -0.780  39.392 -15.544  0.01  4.44           C  
ATOM  52425  CG  ASN a  74      -2.107  38.726 -15.240  0.01  4.44           C  
ATOM  52426  OD1 ASN a  74      -3.161  39.180 -15.686  0.01  4.44           O  
ATOM  52427  ND2 ASN a  74      -2.064  37.638 -14.480  0.01  4.44           N  
ATOM  52428  N   GLU a  75       2.346  39.689 -15.183  0.01  4.44           N  
ATOM  52429  CA  GLU a  75       3.700  39.226 -15.477  0.01  4.44           C  
ATOM  52430  C   GLU a  75       4.501  39.047 -14.192  0.01  4.44           C  
ATOM  52431  O   GLU a  75       5.178  38.036 -14.010  0.01  4.44           O  
ATOM  52432  CB  GLU a  75       4.413  40.212 -16.408  0.01  4.44           C  
ATOM  52433  CG  GLU a  75       4.205  39.910 -17.884  0.01  4.44           C  
ATOM  52434  CD  GLU a  75       5.216  38.919 -18.425  0.01  4.44           C  
ATOM  52435  OE1 GLU a  75       4.921  38.269 -19.450  0.01  4.44           O  
ATOM  52436  OE2 GLU a  75       6.304  38.794 -17.825  0.01  4.44           O  
ATOM  52437  N   LEU a  76       4.418  40.029 -13.298  0.01  4.44           N  
ATOM  52438  CA  LEU a  76       5.132  39.960 -12.030  0.01  4.44           C  
ATOM  52439  C   LEU a  76       4.800  38.655 -11.305  0.01  4.44           C  
ATOM  52440  O   LEU a  76       5.682  37.835 -11.062  0.01  4.44           O  
ATOM  52441  CB  LEU a  76       4.791  41.174 -11.155  0.01  4.44           C  
ATOM  52442  CG  LEU a  76       5.069  41.007  -9.656  0.01  4.44           C  
ATOM  52443  CD1 LEU a  76       5.972  42.116  -9.151  0.01  4.44           C  
ATOM  52444  CD2 LEU a  76       3.766  40.978  -8.869  0.01  4.44           C  
ATOM  52445  N   ILE a  77       3.526  38.459 -10.979  0.01  4.44           N  
ATOM  52446  CA  ILE a  77       3.105  37.236 -10.304  0.01  4.44           C  
ATOM  52447  C   ILE a  77       3.535  36.015 -11.111  0.01  4.44           C  
ATOM  52448  O   ILE a  77       3.800  34.952 -10.545  0.01  4.44           O  
ATOM  52449  CB  ILE a  77       1.584  37.197 -10.063  0.01  4.44           C  
ATOM  52450  CG1 ILE a  77       1.132  38.448  -9.306  0.01  4.44           C  
ATOM  52451  CG2 ILE a  77       1.198  35.941  -9.294  0.01  4.44           C  
ATOM  52452  CD1 ILE a  77      -0.371  38.557  -9.166  0.01  4.44           C  
ATOM  52453  N   ASN a  78       3.645  36.176 -12.426  0.01  4.44           N  
ATOM  52454  CA  ASN a  78       4.091  35.087 -13.284  0.01  4.44           C  
ATOM  52455  C   ASN a  78       5.480  34.637 -12.842  0.01  4.44           C  
ATOM  52456  O   ASN a  78       5.798  33.449 -12.829  0.01  4.44           O  
ATOM  52457  CB  ASN a  78       4.093  35.536 -14.755  0.01  4.44           C  
ATOM  52458  CG  ASN a  78       5.443  35.389 -15.434  0.01  4.44           C  
ATOM  52459  OD1 ASN a  78       5.997  34.291 -15.512  0.01  4.44           O  
ATOM  52460  ND2 ASN a  78       5.981  36.496 -15.931  0.01  4.44           N  
ATOM  52461  N   LYS a  79       6.286  35.621 -12.457  0.01  4.44           N  
ATOM  52462  CA  LYS a  79       7.642  35.382 -11.975  0.01  4.44           C  
ATOM  52463  C   LYS a  79       7.597  34.780 -10.581  0.01  4.44           C  
ATOM  52464  O   LYS a  79       8.459  33.983 -10.218  0.01  4.44           O  
ATOM  52465  CB  LYS a  79       8.464  36.673 -11.965  0.01  4.44           C  
ATOM  52466  CG  LYS a  79       8.826  37.189 -13.350  0.01  4.44           C  
ATOM  52467  CD  LYS a  79       8.181  38.538 -13.631  0.01  4.44           C  
ATOM  52468  CE  LYS a  79       8.124  38.829 -15.121  0.01  4.44           C  
ATOM  52469  NZ  LYS a  79       9.381  39.455 -15.615  0.01  4.44           N  
ATOM  52470  N   LEU a  80       6.570  35.120  -9.812  0.01  4.44           N  
ATOM  52471  CA  LEU a  80       6.420  34.547  -8.482  0.01  4.44           C  
ATOM  52472  C   LEU a  80       6.223  33.046  -8.643  0.01  4.44           C  
ATOM  52473  O   LEU a  80       6.903  32.236  -8.010  0.01  4.44           O  
ATOM  52474  CB  LEU a  80       5.230  35.171  -7.752  0.01  4.44           C  
ATOM  52475  CG  LEU a  80       5.352  36.671  -7.478  0.01  4.44           C  
ATOM  52476  CD1 LEU a  80       4.133  37.179  -6.722  0.01  4.44           C  
ATOM  52477  CD2 LEU a  80       6.625  36.968  -6.698  0.01  4.44           C  
ATOM  52478  N   GLU a  81       5.309  32.699  -9.540  0.01  4.44           N  
ATOM  52479  CA  GLU a  81       5.012  31.318  -9.868  0.01  4.44           C  
ATOM  52480  C   GLU a  81       6.242  30.629 -10.443  0.01  4.44           C  
ATOM  52481  O   GLU a  81       6.616  29.536 -10.016  0.01  4.44           O  
ATOM  52482  CB  GLU a  81       3.875  31.276 -10.880  0.01  4.44           C  
ATOM  52483  CG  GLU a  81       2.971  30.067 -10.734  0.01  4.44           C  
ATOM  52484  CD  GLU a  81       1.939  29.972 -11.840  0.01  4.44           C  
ATOM  52485  OE1 GLU a  81       0.749  29.763 -11.525  0.01  4.44           O  
ATOM  52486  OE2 GLU a  81       2.320  30.104 -13.022  0.01  4.44           O  
ATOM  52487  N   ARG a  82       6.866  31.276 -11.419  0.01  4.44           N  
ATOM  52488  CA  ARG a  82       8.055  30.730 -12.064  0.01  4.44           C  
ATOM  52489  C   ARG a  82       9.206  30.589 -11.070  0.01  4.44           C  
ATOM  52490  O   ARG a  82      10.078  29.737 -11.234  0.01  4.44           O  
ATOM  52491  CB  ARG a  82       8.478  31.620 -13.237  0.01  4.44           C  
ATOM  52492  CG  ARG a  82       8.354  30.940 -14.591  0.01  4.44           C  
ATOM  52493  CD  ARG a  82       9.504  31.317 -15.513  0.01  4.44           C  
ATOM  52494  NE  ARG a  82      10.415  30.199 -15.739  0.01  4.44           N  
ATOM  52495  CZ  ARG a  82      10.170  29.201 -16.585  0.01  4.44           C  
ATOM  52496  NH1 ARG a  82       9.044  29.178 -17.287  0.01  4.44           N  
ATOM  52497  NH2 ARG a  82      11.053  28.222 -16.729  0.01  4.44           N  
ATOM  52498  N   GLN a  83       9.201  31.427 -10.040  0.01  4.44           N  
ATOM  52499  CA  GLN a  83      10.245  31.392  -9.021  0.01  4.44           C  
ATOM  52500  C   GLN a  83      10.044  30.205  -8.089  0.01  4.44           C  
ATOM  52501  O   GLN a  83      10.993  29.494  -7.758  0.01  4.44           O  
ATOM  52502  CB  GLN a  83      10.244  32.691  -8.216  0.01  4.44           C  
ATOM  52503  CG  GLN a  83      11.056  33.804  -8.854  0.01  4.44           C  
ATOM  52504  CD  GLN a  83      10.996  35.094  -8.059  0.01  4.44           C  
ATOM  52505  OE1 GLN a  83      11.971  35.489  -7.420  0.01  4.44           O  
ATOM  52506  NE2 GLN a  83       9.846  35.757  -8.094  0.01  4.44           N  
ATOM  52507  N   LEU a  84       8.801  29.996  -7.670  0.01  4.44           N  
ATOM  52508  CA  LEU a  84       8.472  28.893  -6.775  0.01  4.44           C  
ATOM  52509  C   LEU a  84       8.731  27.554  -7.456  0.01  4.44           C  
ATOM  52510  O   LEU a  84       8.994  26.551  -6.794  0.01  4.44           O  
ATOM  52511  CB  LEU a  84       7.011  28.988  -6.339  0.01  4.44           C  
ATOM  52512  CG  LEU a  84       6.665  30.216  -5.495  0.01  4.44           C  
ATOM  52513  CD1 LEU a  84       5.312  30.783  -5.899  0.01  4.44           C  
ATOM  52514  CD2 LEU a  84       6.678  29.867  -4.014  0.01  4.44           C  
ATOM  52515  N   ASN a  85       8.658  27.547  -8.784  0.01  4.44           N  
ATOM  52516  CA  ASN a  85       8.892  26.332  -9.556  0.01  4.44           C  
ATOM  52517  C   ASN a  85      10.326  25.856  -9.366  0.01  4.44           C  
ATOM  52518  O   ASN a  85      10.583  24.661  -9.220  0.01  4.44           O  
ATOM  52519  CB  ASN a  85       8.617  26.583 -11.038  0.01  4.44           C  
ATOM  52520  CG  ASN a  85       8.235  25.316 -11.779  0.01  4.44           C  
ATOM  52521  OD1 ASN a  85       7.103  25.170 -12.243  0.01  4.44           O  
ATOM  52522  ND2 ASN a  85       9.181  24.389 -11.891  0.01  4.44           N  
ATOM  52523  N   LYS a  86      11.255  26.807  -9.367  0.01  4.44           N  
ATOM  52524  CA  LYS a  86      12.668  26.498  -9.194  0.01  4.44           C  
ATOM  52525  C   LYS a  86      12.983  26.140  -7.743  0.01  4.44           C  
ATOM  52526  O   LYS a  86      14.011  25.524  -7.460  0.01  4.44           O  
ATOM  52527  CB  LYS a  86      13.527  27.687  -9.634  0.01  4.44           C  
ATOM  52528  CG  LYS a  86      13.539  27.902 -11.140  0.01  4.44           C  
ATOM  52529  CD  LYS a  86      14.618  27.066 -11.811  0.01  4.44           C  
ATOM  52530  CE  LYS a  86      14.310  26.840 -13.282  0.01  4.44           C  
ATOM  52531  NZ  LYS a  86      14.838  25.533 -13.762  0.01  4.44           N  
ATOM  52532  N   LEU a  87      12.097  26.526  -6.829  0.01  4.44           N  
ATOM  52533  CA  LEU a  87      12.296  26.234  -5.414  0.01  4.44           C  
ATOM  52534  C   LEU a  87      12.181  24.737  -5.159  0.01  4.44           C  
ATOM  52535  O   LEU a  87      12.933  24.171  -4.366  0.01  4.44           O  
ATOM  52536  CB  LEU a  87      11.275  26.994  -4.562  0.01  4.44           C  
ATOM  52537  CG  LEU a  87      11.644  28.444  -4.250  0.01  4.44           C  
ATOM  52538  CD1 LEU a  87      10.451  29.184  -3.665  0.01  4.44           C  
ATOM  52539  CD2 LEU a  87      12.827  28.499  -3.296  0.01  4.44           C  
ATOM  52540  N   GLN a  88      11.239  24.099  -5.845  0.01  4.44           N  
ATOM  52541  CA  GLN a  88      11.032  22.663  -5.703  0.01  4.44           C  
ATOM  52542  C   GLN a  88      12.080  21.883  -6.490  0.01  4.44           C  
ATOM  52543  O   GLN a  88      12.337  20.712  -6.213  0.01  4.44           O  
ATOM  52544  CB  GLN a  88       9.629  22.277  -6.175  0.01  4.44           C  
ATOM  52545  CG  GLN a  88       8.518  22.839  -5.302  0.01  4.44           C  
ATOM  52546  CD  GLN a  88       7.172  22.207  -5.594  0.01  4.44           C  
ATOM  52547  OE1 GLN a  88       6.435  21.840  -4.677  0.01  4.44           O  
ATOM  52548  NE2 GLN a  88       6.844  22.075  -6.875  0.01  4.44           N  
ATOM  52549  N   HIS a  89      12.684  22.546  -7.469  0.01  4.44           N  
ATOM  52550  CA  HIS a  89      13.709  21.927  -8.304  0.01  4.44           C  
ATOM  52551  C   HIS a  89      13.188  20.645  -8.951  0.01  4.44           C  
ATOM  52552  O   HIS a  89      11.981  20.414  -9.008  0.01  4.44           O  
ATOM  52553  CB  HIS a  89      14.957  21.618  -7.472  0.01  4.44           C  
ATOM  52554  CG  HIS a  89      15.300  22.683  -6.477  0.01  4.44           C  
ATOM  52555  ND1 HIS a  89      15.900  23.875  -6.826  0.01  4.44           N  
ATOM  52556  CD2 HIS a  89      15.126  22.731  -5.135  0.01  4.44           C  
ATOM  52557  CE1 HIS a  89      16.082  24.608  -5.742  0.01  4.44           C  
ATOM  52558  NE2 HIS a  89      15.620  23.937  -4.702  0.01  4.44           N  
ATOM  52559  N   LYS a  90      14.108  19.813  -9.431  0.01  4.44           N  
ATOM  52560  CA  LYS a  90      13.742  18.555 -10.069  0.01  4.44           C  
ATOM  52561  C   LYS a  90      14.970  17.674 -10.277  0.01  4.44           C  
ATOM  52562  O   LYS a  90      14.926  16.466 -10.040  0.01  4.44           O  
ATOM  52563  CB  LYS a  90      13.054  18.818 -11.410  0.01  4.44           C  
ATOM  52564  CG  LYS a  90      12.015  17.772 -11.777  0.01  4.44           C  
ATOM  52565  CD  LYS a  90      12.665  16.456 -12.175  0.01  4.44           C  
ATOM  52566  CE  LYS a  90      11.971  15.831 -13.375  0.01  4.44           C  
ATOM  52567  NZ  LYS a  90      12.510  16.356 -14.661  0.01  4.44           N  
ATOM  52568  OXT LYS a  90      15.994  18.236 -10.720  1.00  4.44           O  
TER   52569      LYS a  90                                                      
END
MOLECULE T0506_174_254.pdb
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
