
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  140 ( 1133),  selected  140 , name 2i02_A
# Molecule2: number of CA atoms  143 ( 1091),  selected  143 , name T0506_25_173.pdb
# PARAMETERS: 2i02_A.T0506_25_173.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_A      E      25           -
LGA    D     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    Q     9_A      -       -           -
LGA    E    10_A      A      26           #
LGA    I    11_A      -       -           -
LGA    Q    12_A      V      27           #
LGA    K    13_A      R      28          3.518
LGA    -       -      V      29           -
LGA    L    14_A      A      30          4.002
LGA    H    15_A      R      31          2.747
LGA    E    16_A      D      32          1.480
LGA    L    17_A      V      33          2.243
LGA    I    18_A      L      34          2.305
LGA    K    19_A      H      35          1.928
LGA    N    20_A      T      36          1.961
LGA    I    21_A      S      37          1.693
LGA    D    22_A      R      38          1.123
LGA    Y    23_A      T      39          0.483
LGA    G    24_A      A      40          0.528
LGA    X    25_A      A      41          0.482
LGA    F    26_A      L      42          0.262
LGA    T    27_A      A      43          0.130
LGA    T    28_A      T      44          0.709
LGA    V    29_A      L      45          0.896
LGA    D    30_A      D      46          0.599
LGA    D    31_A      P      47          1.584
LGA    D    32_A      V      48          2.837
LGA    -       -      S      49           -
LGA    G    33_A      G      50          0.506
LGA    S    34_A      Y      51          0.827
LGA    L    35_A      P      52          0.681
LGA    H    36_A      Y      53          0.896
LGA    S    37_A      T      54          0.654
LGA    Y    38_A      T      55          0.472
LGA    P    39_A      A      56          0.298
LGA    X    40_A      T      57          0.608
LGA    S    41_A      N      58          0.148
LGA    K    42_A      I      59          0.252
LGA    S    43_A      G      60          1.113
LGA    G    44_A      I      61          2.549
LGA    D    45_A      E      62          4.275
LGA    -       -      P      63           -
LGA    E    49_A      D      64          3.596
LGA    A    50_A      G      65           #
LGA    T    51_A      T      66          2.822
LGA    L    52_A      P      67          1.618
LGA    W    53_A      F      68          0.477
LGA    F    54_A      F      69          0.264
LGA    F    55_A      F      70          1.148
LGA    T    56_A      A      71          1.393
LGA    Y    57_A      A      72          1.972
LGA    A    58_A      G      73          2.806
LGA    G    59_A      L      74          3.402
LGA    S    60_A      T      75          2.559
LGA    H    61_A      L      76          2.096
LGA    K    62_A      H      77          1.367
LGA    V    63_A      A      78          2.144
LGA    T    64_A      R      79          1.951
LGA    E    65_A      N      80          0.999
LGA    I    66_A      M      81          1.526
LGA    E    67_A      E      82          2.195
LGA    H    68_A      T      83          2.196
LGA    H    69_A      D      84          1.789
LGA    E    70_A      A      85          1.342
LGA    Q    71_A      R      86          0.962
LGA    V    72_A      I      87          0.592
LGA    N    73_A      S      88          0.329
LGA    V    74_A      V      89          0.171
LGA    S    75_A      T      90          0.794
LGA    F    76_A      L      91          1.739
LGA    S    77_A      A      92          2.886
LGA    S    78_A      P      93          3.732
LGA    -       -      F      94           -
LGA    -       -      G      95           -
LGA    -       -      K      96           -
LGA    -       -      G      97           -
LGA    -       -      D      98           -
LGA    -       -      A      99           -
LGA    P    79_A      L     100          5.297
LGA    E    80_A      T     101          5.934
LGA    Q    81_A      -       -           -
LGA    Q    82_A      L     102          3.130
LGA    R    83_A      P     103          0.217
LGA    Y    84_A      R     104          1.174
LGA    V    85_A      L     105          1.254
LGA    S    86_A      T     106          0.917
LGA    I    87_A      L     107          0.656
LGA    S    88_A      V     108          0.367
LGA    G    89_A      G     109          0.868
LGA    T    90_A      R     110          0.575
LGA    S    91_A      A     111          0.773
LGA    Q    92_A      D     112          2.305
LGA    L    93_A      R     113          2.511
LGA    V    94_A      I     114          2.700
LGA    K    95_A      G     115          4.387
LGA    D    96_A      P     116          2.137
LGA    R    97_A      D     117          4.886
LGA    N    98_A      -       -           -
LGA    K    99_A      E     118          2.786
LGA    X   100_A      V     119          2.848
LGA    R   101_A      P     120          2.590
LGA    E   102_A      L     121          2.047
LGA    L   103_A      A     122          2.732
LGA    W   104_A      I     123          2.725
LGA    -       -      A     124           -
LGA    -       -      R     125           -
LGA    -       -      Y     126           -
LGA    K   105_A      I     127          0.857
LGA    -       -      A     128           -
LGA    -       -      R     129           -
LGA    -       -      Y     130           -
LGA    P   106_A      P     131          1.827
LGA    E   107_A      K     132          3.494
LGA    L   108_A      A     133          2.199
LGA    Q   109_A      K     134          3.712
LGA    T   110_A      -       -           -
LGA    W   111_A      -       -           -
LGA    F   112_A      -       -           -
LGA    P   113_A      L     135          2.098
LGA    K   114_A      Y     136          5.051
LGA    G   115_A      L     137          3.283
LGA    L   116_A      -       -           -
LGA    D   117_A      S     138          3.462
LGA    E   118_A      L     139          2.659
LGA    P   119_A      P     140          2.886
LGA    D   120_A      D     141          1.072
LGA    I   121_A      T     142          1.058
LGA    A   122_A      R     143          2.009
LGA    L   123_A      L     144          0.291
LGA    L   124_A      Y     145          1.400
LGA    K   125_A      R     146          1.523
LGA    V   126_A      L     147          1.103
LGA    N   127_A      R     148          0.202
LGA    I   128_A      T     149          0.403
LGA    N   129_A      E     150          0.701
LGA    Q   130_A      G     151          1.079
LGA    V   131_A      V     152          0.994
LGA    N   132_A      Q     153          0.314
LGA    Y   133_A      I     154          0.543
LGA    W   134_A      N     155          1.225
LGA    D   135_A      G     156          3.289
LGA    S   136_A      -       -           -
LGA    T   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    S   139_A      -       -           -
LGA    F   140_A      -       -           -
LGA    K   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    Q   143_A      S     163          1.464
LGA    T   144_A      N     164          3.110
LGA    I   145_A      I     165          2.069
LGA    S   146_A      T     166          2.301
LGA    F   147_A      P     167          3.345
LGA    -       -      A     168           -
LGA    -       -      D     169           -
LGA    -       -      L     170           -
LGA    -       -      R     171           -
LGA    -       -      T     172           -
LGA    -       -      D     173           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  140  143    5.0    118    2.20    12.71     61.176     5.136

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.957889 * X  +  -0.251690 * Y  +  -0.138203 * Z  +  47.707558
  Y_new =   0.048577 * X  +  -0.616422 * Y  +   0.785916 * Z  +  51.299847
  Z_new =  -0.282999 * X  +   0.746107 * Y  +   0.602691 * Z  +  -9.189363 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.891329   -2.250263  [ DEG:    51.0694   -128.9306 ]
  Theta =   0.286919    2.854674  [ DEG:    16.4393    163.5607 ]
  Phi   =   3.090924   -0.050669  [ DEG:   177.0969     -2.9031 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i02_A                                        
REMARK     2: T0506_25_173.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i02_A.T0506_25_173.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  140  143   5.0  118   2.20   12.71  61.176
REMARK  ---------------------------------------------------------- 
MOLECULE 2i02_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   09-AUG-06   2I02              
TITLE     CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN OF COG3871                
TITLE    2 (ZP_00108720.1) FROM NOSTOC PUNCTIFORME PCC 73102 AT 1.80            
TITLE    3 A RESOLUTION                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GENERAL STRESS PROTEIN OF COG3871;                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOSTOC PUNCTIFORME PCC 73102;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00108720.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00108720.1, GENERAL STRESS PROTEIN OF COG3871, ,                   
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-AUG-06 2I02    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN OF               
JRNL        TITL 2 COG3871 (ZP_00108720.1) FROM NOSTOC PUNCTIFORME              
JRNL        TITL 3 PCC 73102 AT 1.80 A RESOLUTION                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2I02 A    1   147  UNP    Q8YS45   Q8YS45_ANASP     1    128             
DBREF  2I02 B    1   147  UNP    Q8YS45   Q8YS45_ANASP     1    128             
SEQRES   1 A  148  GLY MSE ALA THR SER THR ASP ARG THR GLN GLU ILE GLN          
SEQRES   2 A  148  LYS LEU HIS GLU LEU ILE LYS ASN ILE ASP TYR GLY MSE          
SEQRES   3 A  148  PHE THR THR VAL ASP ASP ASP GLY SER LEU HIS SER TYR          
SEQRES   4 A  148  PRO MSE SER LYS SER GLY ASP ILE ASN SER GLU ALA THR          
SEQRES   5 A  148  LEU TRP PHE PHE THR TYR ALA GLY SER HIS LYS VAL THR          
SEQRES   6 A  148  GLU ILE GLU HIS HIS GLU GLN VAL ASN VAL SER PHE SER          
SEQRES   7 A  148  SER PRO GLU GLN GLN ARG TYR VAL SER ILE SER GLY THR          
SEQRES   8 A  148  SER GLN LEU VAL LYS ASP ARG ASN LYS MSE ARG GLU LEU          
SEQRES   9 A  148  TRP LYS PRO GLU LEU GLN THR TRP PHE PRO LYS GLY LEU          
SEQRES  10 A  148  ASP GLU PRO ASP ILE ALA LEU LEU LYS VAL ASN ILE ASN          
SEQRES  11 A  148  GLN VAL ASN TYR TRP ASP SER THR SER SER PHE LYS PRO          
SEQRES  12 A  148  GLN THR ILE SER PHE                                          
SEQRES   1 B  148  GLY MSE ALA THR SER THR ASP ARG THR GLN GLU ILE GLN          
SEQRES   2 B  148  LYS LEU HIS GLU LEU ILE LYS ASN ILE ASP TYR GLY MSE          
SEQRES   3 B  148  PHE THR THR VAL ASP ASP ASP GLY SER LEU HIS SER TYR          
SEQRES   4 B  148  PRO MSE SER LYS SER GLY ASP ILE ASN SER GLU ALA THR          
SEQRES   5 B  148  LEU TRP PHE PHE THR TYR ALA GLY SER HIS LYS VAL THR          
SEQRES   6 B  148  GLU ILE GLU HIS HIS GLU GLN VAL ASN VAL SER PHE SER          
SEQRES   7 B  148  SER PRO GLU GLN GLN ARG TYR VAL SER ILE SER GLY THR          
SEQRES   8 B  148  SER GLN LEU VAL LYS ASP ARG ASN LYS MSE ARG GLU LEU          
SEQRES   9 B  148  TRP LYS PRO GLU LEU GLN THR TRP PHE PRO LYS GLY LEU          
SEQRES  10 B  148  ASP GLU PRO ASP ILE ALA LEU LEU LYS VAL ASN ILE ASN          
SEQRES  11 B  148  GLN VAL ASN TYR TRP ASP SER THR SER SER PHE LYS PRO          
SEQRES  12 B  148  GLN THR ILE SER PHE                                          
HET    MSE  A  25       8                                                       
HET    MSE  A  40      13                                                       
HET    MSE  A 100       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  B  40      13                                                       
HET    MSE  B 100       8                                                       
HET     CL      3       1                                                       
HET    FMN  A 200      31                                                       
HET    P33      1      13                                                       
HET    P33      2       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     P33 3,6,9,12,15,18-HEXAOXAICOSANE-1,20-DIOL                          
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     P33 HEPTAETHYLENE GLYCOL, PEG330                                     
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  FMN    C17 H21 N4 O9 P                                              
FORMUL   5  P33    2(C14 H30 O8)                                                
FORMUL   7  HOH   *175(H2 O)                                                    
CRYST1  103.646  103.646  109.695  90.00  90.00 120.00 P 63 2 2     24          
ATOM      1  N   THR A   5       9.242  59.147  -9.324  1.00 60.68           N  
ATOM      2  CA  THR A   5      10.142  59.478 -10.476  1.00 61.62           C  
ATOM      3  C   THR A   5      11.508  58.788 -10.275  1.00 58.79           C  
ATOM      4  O   THR A   5      11.584  57.555 -10.240  1.00 57.66           O  
ATOM      5  CB  THR A   5      10.265  61.028 -10.626  1.00 63.56           C  
ATOM      6  OG1 THR A   5      11.304  61.365 -11.567  1.00 67.43           O  
ATOM      7  CG2 THR A   5      10.544  61.696  -9.255  1.00 63.26           C  
ATOM      8  N   ASP A   6      12.579  59.572 -10.157  1.00 55.96           N  
ATOM      9  CA  ASP A   6      13.761  59.121  -9.438  1.00 54.32           C  
ATOM     10  C   ASP A   6      13.312  58.635  -8.055  1.00 49.77           C  
ATOM     11  O   ASP A   6      13.824  57.645  -7.555  1.00 46.71           O  
ATOM     12  CB  ASP A   6      14.799  60.246  -9.312  1.00 55.93           C  
ATOM     13  CG  ASP A   6      16.152  59.753  -8.782  1.00 62.38           C  
ATOM     14  OD1 ASP A   6      16.703  58.786  -9.350  1.00 75.03           O  
ATOM     15  OD2 ASP A   6      16.673  60.328  -7.797  1.00 71.70           O  
ATOM     16  N   ARG A   7      12.332  59.323  -7.467  1.00 45.87           N  
ATOM     17  CA  ARG A   7      11.791  58.965  -6.159  1.00 44.78           C  
ATOM     18  C   ARG A   7      11.188  57.564  -6.140  1.00 44.52           C  
ATOM     19  O   ARG A   7      11.562  56.745  -5.318  1.00 42.10           O  
ATOM     20  CB  ARG A   7      10.731  59.978  -5.712  1.00 44.28           C  
ATOM     21  CG  ARG A   7      10.314  59.831  -4.265  1.00 44.27           C  
ATOM     22  CD  ARG A   7       9.570  61.066  -3.730  1.00 43.90           C  
ATOM     23  NE  ARG A   7       9.772  61.246  -2.286  1.00 43.75           N  
ATOM     24  CZ  ARG A   7       9.104  60.597  -1.336  1.00 34.27           C  
ATOM     25  NH1 ARG A   7       8.179  59.699  -1.640  1.00 39.29           N  
ATOM     26  NH2 ARG A   7       9.365  60.833  -0.067  1.00 44.20           N  
ATOM     27  N   THR A   8      10.256  57.284  -7.045  1.00 43.51           N  
ATOM     28  CA  THR A   8       9.636  55.958  -7.102  1.00 44.30           C  
ATOM     29  C   THR A   8      10.691  54.884  -7.301  1.00 42.51           C  
ATOM     30  O   THR A   8      10.574  53.792  -6.762  1.00 44.93           O  
ATOM     31  CB  THR A   8       8.611  55.847  -8.246  1.00 45.05           C  
ATOM     32  OG1 THR A   8       9.146  56.510  -9.397  1.00 48.56           O  
ATOM     33  CG2 THR A   8       7.281  56.470  -7.838  1.00 44.60           C  
ATOM     34  N   GLN A   9      11.723  55.214  -8.058  1.00 41.06           N  
ATOM     35  CA  GLN A   9      12.856  54.337  -8.260  1.00 42.13           C  
ATOM     36  C   GLN A   9      13.579  54.064  -6.942  1.00 42.62           C  
ATOM     37  O   GLN A   9      13.678  52.912  -6.506  1.00 42.41           O  
ATOM     38  CB  GLN A   9      13.822  54.976  -9.257  1.00 40.85           C  
ATOM     39  CG  GLN A   9      15.164  54.283  -9.398  1.00 48.95           C  
ATOM     40  N   GLU A  10      14.064  55.136  -6.313  1.00 39.65           N  
ATOM     41  CA  GLU A  10      14.698  55.056  -4.988  1.00 37.96           C  
ATOM     42  C   GLU A  10      13.897  54.188  -4.031  1.00 35.62           C  
ATOM     43  O   GLU A  10      14.458  53.357  -3.302  1.00 34.53           O  
ATOM     44  CB  GLU A  10      14.857  56.468  -4.428  1.00 37.47           C  
ATOM     45  CG  GLU A  10      15.930  57.285  -5.122  1.00 39.45           C  
ATOM     46  CD  GLU A  10      16.014  58.693  -4.564  1.00 42.21           C  
ATOM     47  OE1 GLU A  10      14.951  59.331  -4.388  1.00 53.76           O  
ATOM     48  OE2 GLU A  10      17.135  59.141  -4.263  1.00 52.83           O  
ATOM     49  N   ILE A  11      12.579  54.343  -4.035  1.00 34.90           N  
ATOM     50  CA  ILE A  11      11.745  53.531  -3.177  1.00 38.60           C  
ATOM     51  C   ILE A  11      11.850  52.047  -3.599  1.00 41.78           C  
ATOM     52  O   ILE A  11      11.843  51.155  -2.744  1.00 41.17           O  
ATOM     53  CB  ILE A  11      10.287  54.014  -3.152  1.00 40.38           C  
ATOM     54  CG1 ILE A  11      10.207  55.358  -2.411  1.00 36.75           C  
ATOM     55  CG2 ILE A  11       9.402  53.002  -2.431  1.00 42.84           C  
ATOM     56  CD1 ILE A  11       8.826  55.987  -2.372  1.00 38.45           C  
ATOM     57  N   GLN A  12      11.986  51.813  -4.905  1.00 44.61           N  
ATOM     58  CA  GLN A  12      12.206  50.471  -5.453  1.00 43.51           C  
ATOM     59  C   GLN A  12      13.580  49.879  -5.056  1.00 42.56           C  
ATOM     60  O   GLN A  12      13.642  48.716  -4.682  1.00 42.05           O  
ATOM     61  CB  GLN A  12      12.031  50.473  -6.979  1.00 46.57           C  
ATOM     62  N   LYS A  13      14.665  50.654  -5.129  1.00 39.93           N  
ATOM     63  CA  LYS A  13      15.976  50.171  -4.645  1.00 38.77           C  
ATOM     64  C   LYS A  13      15.887  49.790  -3.174  1.00 37.07           C  
ATOM     65  O   LYS A  13      16.383  48.740  -2.747  1.00 33.44           O  
ATOM     66  CB  LYS A  13      17.083  51.208  -4.862  1.00 38.49           C  
ATOM     67  CG  LYS A  13      18.519  50.784  -4.386  1.00 41.45           C  
ATOM     68  CD  LYS A  13      19.108  49.486  -5.027  1.00 36.24           C  
ATOM     69  CE  LYS A  13      20.498  49.161  -4.405  1.00 45.57           C  
ATOM     70  NZ  LYS A  13      21.273  47.919  -4.898  1.00 40.85           N  
ATOM     71  N   LEU A  14      15.241  50.644  -2.391  1.00 34.21           N  
ATOM     72  CA  LEU A  14      15.077  50.372  -0.979  1.00 33.67           C  
ATOM     73  C   LEU A  14      14.334  49.072  -0.786  1.00 33.59           C  
ATOM     74  O   LEU A  14      14.699  48.242   0.060  1.00 29.29           O  
ATOM     75  CB  LEU A  14      14.341  51.521  -0.298  1.00 32.84           C  
ATOM     76  CG  LEU A  14      13.895  51.346   1.142  1.00 37.42           C  
ATOM     77  CD1 LEU A  14      15.075  51.119   2.112  1.00 36.26           C  
ATOM     78  CD2 LEU A  14      13.015  52.552   1.496  1.00 38.84           C  
ATOM     79  N   HIS A  15      13.282  48.891  -1.583  1.00 36.55           N  
ATOM     80  CA  HIS A  15      12.545  47.618  -1.591  1.00 36.86           C  
ATOM     81  C   HIS A  15      13.438  46.414  -1.906  1.00 34.15           C  
ATOM     82  O   HIS A  15      13.408  45.445  -1.175  1.00 36.72           O  
ATOM     83  CB  HIS A  15      11.375  47.683  -2.578  1.00 37.80           C  
ATOM     84  CG  HIS A  15      10.553  46.432  -2.603  1.00 42.81           C  
ATOM     85  ND1 HIS A  15       9.912  45.945  -1.482  1.00 50.56           N  
ATOM     86  CD2 HIS A  15      10.281  45.561  -3.603  1.00 44.84           C  
ATOM     87  CE1 HIS A  15       9.281  44.825  -1.793  1.00 48.39           C  
ATOM     88  NE2 HIS A  15       9.495  44.568  -3.071  1.00 44.83           N  
ATOM     89  N   GLU A  16      14.229  46.500  -2.981  1.00 34.51           N  
ATOM     90  CA  GLU A  16      15.203  45.471  -3.367  1.00 36.05           C  
ATOM     91  C   GLU A  16      16.106  45.151  -2.179  1.00 33.93           C  
ATOM     92  O   GLU A  16      16.399  43.992  -1.903  1.00 33.23           O  
ATOM     93  CB  GLU A  16      16.054  45.945  -4.573  1.00 37.18           C  
ATOM     94  CG  GLU A  16      17.199  44.981  -5.102  1.00 40.75           C  
ATOM     95  CD  GLU A  16      18.605  45.162  -4.416  1.00 55.50           C  
ATOM     96  OE1 GLU A  16      19.137  46.298  -4.303  1.00 52.27           O  
ATOM     97  OE2 GLU A  16      19.197  44.135  -4.013  1.00 57.12           O  
ATOM     98  N   LEU A  17      16.525  46.188  -1.462  1.00 29.96           N  
ATOM     99  CA  LEU A  17      17.510  46.016  -0.405  1.00 28.22           C  
ATOM    100  C   LEU A  17      16.989  45.218   0.778  1.00 29.01           C  
ATOM    101  O   LEU A  17      17.668  44.306   1.226  1.00 27.75           O  
ATOM    102  CB  LEU A  17      18.038  47.370   0.080  1.00 29.10           C  
ATOM    103  CG  LEU A  17      19.052  48.056  -0.835  1.00 29.70           C  
ATOM    104  CD1 LEU A  17      19.161  49.504  -0.383  1.00 29.03           C  
ATOM    105  CD2 LEU A  17      20.442  47.355  -0.853  1.00 28.52           C  
ATOM    106  N   ILE A  18      15.794  45.533   1.305  1.00 26.75           N  
ATOM    107  CA  ILE A  18      15.393  44.954   2.593  1.00 25.34           C  
ATOM    108  C   ILE A  18      14.279  43.890   2.550  1.00 28.77           C  
ATOM    109  O   ILE A  18      13.980  43.274   3.566  1.00 28.28           O  
ATOM    110  CB  ILE A  18      15.069  46.094   3.580  1.00 27.67           C  
ATOM    111  CG1 ILE A  18      13.793  46.835   3.156  1.00 31.79           C  
ATOM    112  CG2 ILE A  18      16.286  47.053   3.634  1.00 27.24           C  
ATOM    113  CD1 ILE A  18      13.292  47.882   4.202  1.00 28.17           C  
ATOM    114  N   LYS A  19      13.746  43.658   1.357  1.00 28.82           N  
ATOM    115  CA  LYS A  19      12.638  42.740   1.093  1.00 34.97           C  
ATOM    116  C   LYS A  19      12.816  41.379   1.773  1.00 33.36           C  
ATOM    117  O   LYS A  19      11.888  40.846   2.381  1.00 33.82           O  
ATOM    118  CB  LYS A  19      12.557  42.591  -0.421  1.00 35.65           C  
ATOM    119  CG  LYS A  19      11.670  41.534  -0.987  1.00 45.47           C  
ATOM    120  CD  LYS A  19      11.598  41.698  -2.513  1.00 44.35           C  
ATOM    121  CE  LYS A  19      12.951  41.484  -3.207  1.00 53.16           C  
ATOM    122  NZ  LYS A  19      12.919  41.839  -4.656  1.00 54.06           N  
ATOM    123  N   ASN A  20      14.019  40.825   1.673  1.00 30.17           N  
ATOM    124  CA  ASN A  20      14.289  39.498   2.181  1.00 30.38           C  
ATOM    125  C   ASN A  20      15.096  39.487   3.479  1.00 29.97           C  
ATOM    126  O   ASN A  20      15.749  38.497   3.795  1.00 29.33           O  
ATOM    127  CB  ASN A  20      14.978  38.669   1.071  1.00 32.16           C  
ATOM    128  CG  ASN A  20      14.036  38.356  -0.076  1.00 33.75           C  
ATOM    129  OD1 ASN A  20      14.221  38.797  -1.212  1.00 35.83           O  
ATOM    130  ND2 ASN A  20      12.990  37.610   0.233  1.00 32.60           N  
ATOM    131  N   ILE A  21      15.046  40.576   4.256  1.00 27.90           N  
ATOM    132  CA  ILE A  21      15.676  40.589   5.572  1.00 26.97           C  
ATOM    133  C   ILE A  21      14.550  40.764   6.599  1.00 30.39           C  
ATOM    134  O   ILE A  21      13.791  41.723   6.503  1.00 35.04           O  
ATOM    135  CB  ILE A  21      16.732  41.712   5.699  1.00 27.52           C  
ATOM    136  CG1 ILE A  21      17.817  41.544   4.628  1.00 27.30           C  
ATOM    137  CG2 ILE A  21      17.369  41.709   7.091  1.00 27.44           C  
ATOM    138  CD1 ILE A  21      18.779  42.741   4.539  1.00 25.07           C  
ATOM    139  N   ASP A  22      14.470  39.835   7.550  1.00 32.04           N  
ATOM    140  CA  ASP A  22      13.307  39.681   8.440  1.00 35.22           C  
ATOM    141  C   ASP A  22      13.293  40.634   9.608  1.00 32.91           C  
ATOM    142  O   ASP A  22      12.259  41.236   9.867  1.00 40.23           O  
ATOM    143  CB  ASP A  22      13.230  38.249   9.003  1.00 36.83           C  
ATOM    144  N   TYR A  23      14.418  40.734  10.315  1.00 29.79           N  
ATOM    145  CA  TYR A  23      14.510  41.506  11.553  1.00 27.84           C  
ATOM    146  C   TYR A  23      15.514  42.647  11.323  1.00 28.51           C  
ATOM    147  O   TYR A  23      16.560  42.453  10.730  1.00 32.23           O  
ATOM    148  CB  TYR A  23      14.953  40.643  12.748  1.00 32.04           C  
ATOM    149  CG  TYR A  23      14.123  39.377  12.920  1.00 30.08           C  
ATOM    150  CD1 TYR A  23      12.792  39.442  13.310  1.00 43.65           C  
ATOM    151  CD2 TYR A  23      14.653  38.123  12.625  1.00 40.61           C  
ATOM    152  CE1 TYR A  23      12.022  38.300  13.434  1.00 40.63           C  
ATOM    153  CE2 TYR A  23      13.891  36.975  12.738  1.00 38.91           C  
ATOM    154  CZ  TYR A  23      12.574  37.066  13.147  1.00 44.32           C  
ATOM    155  OH  TYR A  23      11.798  35.920  13.274  1.00 42.57           O  
ATOM    156  N   GLY A  24      15.191  43.821  11.787  1.00 25.41           N  
ATOM    157  CA  GLY A  24      16.174  44.900  11.800  1.00 27.04           C  
ATOM    158  C   GLY A  24      16.482  45.199  13.256  1.00 25.67           C  
ATOM    159  O   GLY A  24      15.795  44.709  14.158  1.00 24.86           O  
HETATM  160  N   MSE A  25      17.532  45.981  13.480  1.00 21.54           N  
HETATM  161  CA  MSE A  25      17.857  46.464  14.802  1.00 21.59           C  
HETATM  162  C   MSE A  25      17.412  47.923  14.846  1.00 19.91           C  
HETATM  163  O   MSE A  25      17.859  48.750  14.029  1.00 22.75           O  
HETATM  164  CB  MSE A  25      19.349  46.325  15.095  1.00 20.56           C  
HETATM  165  CG  MSE A  25      19.901  44.927  15.193  1.00 21.68           C  
HETATM  166 SE   MSE A  25      19.085  43.918  16.604  0.75 27.35          SE  
HETATM  167  CE  MSE A  25      19.904  44.781  18.188  1.00 24.85           C  
ATOM    168  N   PHE A  26      16.485  48.210  15.754  1.00 20.76           N  
ATOM    169  CA  PHE A  26      15.794  49.487  15.908  1.00 20.86           C  
ATOM    170  C   PHE A  26      16.438  50.247  17.029  1.00 21.17           C  
ATOM    171  O   PHE A  26      16.450  49.764  18.169  1.00 22.50           O  
ATOM    172  CB  PHE A  26      14.325  49.202  16.233  1.00 23.38           C  
ATOM    173  CG  PHE A  26      13.408  50.381  16.137  1.00 22.24           C  
ATOM    174  CD1 PHE A  26      13.428  51.364  17.098  1.00 23.75           C  
ATOM    175  CD2 PHE A  26      12.467  50.483  15.113  1.00 22.12           C  
ATOM    176  CE1 PHE A  26      12.574  52.430  17.040  1.00 28.35           C  
ATOM    177  CE2 PHE A  26      11.563  51.580  15.068  1.00 24.78           C  
ATOM    178  CZ  PHE A  26      11.638  52.553  16.019  1.00 26.74           C  
ATOM    179  N   THR A  27      17.065  51.391  16.713  1.00 19.98           N  
ATOM    180  CA  THR A  27      17.812  52.149  17.698  1.00 22.64           C  
ATOM    181  C   THR A  27      17.173  53.495  18.045  1.00 22.93           C  
ATOM    182  O   THR A  27      16.799  54.276  17.155  1.00 22.58           O  
ATOM    183  CB  THR A  27      19.256  52.438  17.200  1.00 24.14           C  
ATOM    184  OG1 THR A  27      19.886  51.199  16.830  1.00 22.83           O  
ATOM    185  CG2 THR A  27      20.095  53.117  18.284  1.00 23.77           C  
ATOM    186  N   THR A  28      17.140  53.792  19.334  1.00 23.11           N  
ATOM    187  CA  THR A  28      16.589  55.025  19.882  1.00 23.42           C  
ATOM    188  C   THR A  28      17.592  55.687  20.807  1.00 25.29           C  
ATOM    189  O   THR A  28      18.580  55.076  21.193  1.00 24.92           O  
ATOM    190  CB  THR A  28      15.303  54.744  20.734  1.00 26.17           C  
ATOM    191  OG1 THR A  28      15.641  53.837  21.791  1.00 24.82           O  
ATOM    192  CG2 THR A  28      14.157  54.175  19.927  1.00 21.78           C  
ATOM    193  N   VAL A  29      17.300  56.930  21.185  1.00 23.86           N  
ATOM    194  CA  VAL A  29      18.080  57.697  22.138  1.00 25.28           C  
ATOM    195  C   VAL A  29      17.213  57.971  23.325  1.00 25.81           C  
ATOM    196  O   VAL A  29      16.054  58.381  23.188  1.00 26.65           O  
ATOM    197  CB  VAL A  29      18.519  59.092  21.610  1.00 27.20           C  
ATOM    198  CG1 VAL A  29      19.566  59.704  22.567  1.00 25.71           C  
ATOM    199  CG2 VAL A  29      19.040  59.027  20.222  1.00 27.93           C  
ATOM    200  N   ASP A  30      17.783  57.779  24.506  1.00 24.51           N  
ATOM    201  CA  ASP A  30      17.083  57.995  25.760  1.00 29.23           C  
ATOM    202  C   ASP A  30      17.342  59.383  26.310  1.00 28.74           C  
ATOM    203  O   ASP A  30      18.178  60.137  25.797  1.00 27.19           O  
ATOM    204  CB  ASP A  30      17.516  56.898  26.752  1.00 31.59           C  
ATOM    205  CG  ASP A  30      16.429  56.531  27.761  1.00 50.13           C  
ATOM    206  OD1 ASP A  30      15.476  57.334  27.968  1.00 60.25           O  
ATOM    207  OD2 ASP A  30      16.547  55.425  28.363  1.00 59.04           O  
ATOM    208  N   ASP A  31      16.619  59.749  27.362  1.00 30.34           N  
ATOM    209  CA  ASP A  31      16.756  61.094  27.951  1.00 31.23           C  
ATOM    210  C   ASP A  31      18.155  61.380  28.468  1.00 30.23           C  
ATOM    211  O   ASP A  31      18.576  62.530  28.491  1.00 36.39           O  
ATOM    212  CB  ASP A  31      15.772  61.274  29.106  1.00 34.30           C  
ATOM    213  CG  ASP A  31      14.351  61.553  28.656  1.00 40.55           C  
ATOM    214  OD1 ASP A  31      14.114  62.032  27.526  1.00 44.99           O  
ATOM    215  OD2 ASP A  31      13.449  61.327  29.489  1.00 44.73           O  
ATOM    216  N   ASP A  32      18.909  60.347  28.833  1.00 29.95           N  
ATOM    217  CA  ASP A  32      20.312  60.533  29.240  1.00 31.08           C  
ATOM    218  C   ASP A  32      21.305  60.550  28.090  1.00 30.02           C  
ATOM    219  O   ASP A  32      22.497  60.632  28.332  1.00 31.88           O  
ATOM    220  CB  ASP A  32      20.711  59.486  30.307  1.00 31.41           C  
ATOM    221  CG  ASP A  32      20.742  58.055  29.775  1.00 42.95           C  
ATOM    222  OD1 ASP A  32      20.492  57.808  28.566  1.00 40.25           O  
ATOM    223  OD2 ASP A  32      21.028  57.150  30.586  1.00 48.11           O  
ATOM    224  N   GLY A  33      20.830  60.509  26.844  1.00 26.77           N  
ATOM    225  CA  GLY A  33      21.711  60.534  25.702  1.00 28.09           C  
ATOM    226  C   GLY A  33      22.195  59.178  25.248  1.00 25.99           C  
ATOM    227  O   GLY A  33      22.830  59.092  24.222  1.00 22.96           O  
ATOM    228  N   SER A  34      21.873  58.117  25.986  1.00 24.92           N  
ATOM    229  CA  SER A  34      22.362  56.799  25.622  1.00 25.41           C  
ATOM    230  C   SER A  34      21.510  56.222  24.495  1.00 22.96           C  
ATOM    231  O   SER A  34      20.315  56.545  24.365  1.00 26.28           O  
ATOM    232  CB  SER A  34      22.414  55.906  26.866  1.00 27.81           C  
ATOM    233  OG  SER A  34      21.131  55.687  27.346  1.00 35.44           O  
ATOM    234  N   LEU A  35      22.121  55.346  23.690  1.00 21.76           N  
ATOM    235  CA  LEU A  35      21.457  54.752  22.542  1.00 21.38           C  
ATOM    236  C   LEU A  35      21.205  53.288  22.845  1.00 25.14           C  
ATOM    237  O   LEU A  35      22.098  52.616  23.342  1.00 26.68           O  
ATOM    238  CB  LEU A  35      22.276  54.843  21.283  1.00 21.49           C  
ATOM    239  CG  LEU A  35      22.258  56.144  20.514  1.00 24.55           C  
ATOM    240  CD1 LEU A  35      22.927  57.203  21.338  1.00 27.12           C  
ATOM    241  CD2 LEU A  35      22.928  55.970  19.140  1.00 22.00           C  
ATOM    242  N   HIS A  36      20.002  52.831  22.560  1.00 24.12           N  
ATOM    243  CA  HIS A  36      19.616  51.420  22.796  1.00 26.43           C  
ATOM    244  C   HIS A  36      19.021  50.869  21.520  1.00 23.62           C  
ATOM    245  O   HIS A  36      18.311  51.585  20.818  1.00 23.34           O  
ATOM    246  CB  HIS A  36      18.590  51.301  23.904  1.00 29.42           C  
ATOM    247  CG  HIS A  36      19.073  51.847  25.204  1.00 34.42           C  
ATOM    248  ND1 HIS A  36      18.491  52.932  25.815  1.00 49.44           N  
ATOM    249  CD2 HIS A  36      20.102  51.468  25.995  1.00 37.36           C  
ATOM    250  CE1 HIS A  36      19.142  53.199  26.935  1.00 50.51           C  
ATOM    251  NE2 HIS A  36      20.130  52.332  27.062  1.00 40.88           N  
ATOM    252  N   SER A  37      19.346  49.613  21.220  1.00 23.43           N  
ATOM    253  CA  SER A  37      18.813  48.958  20.013  0.50 22.57           C  
ATOM    255  C   SER A  37      18.076  47.685  20.391  1.00 22.51           C  
ATOM    256  O   SER A  37      18.374  47.034  21.416  1.00 22.02           O  
ATOM    257  CB  SER A  37      19.872  48.700  18.935  0.50 23.70           C  
ATOM    259  OG  SER A  37      20.868  47.781  19.326  0.50 23.36           O  
ATOM    261  N   TYR A  38      17.076  47.374  19.573  1.00 24.24           N  
ATOM    262  CA  TYR A  38      16.122  46.302  19.799  1.00 23.58           C  
ATOM    263  C   TYR A  38      15.818  45.573  18.498  1.00 20.90           C  
ATOM    264  O   TYR A  38      15.534  46.239  17.512  1.00 20.38           O  
ATOM    265  CB  TYR A  38      14.780  46.911  20.256  1.00 26.09           C  
ATOM    266  CG  TYR A  38      14.826  47.934  21.347  1.00 26.69           C  
ATOM    267  CD1 TYR A  38      15.008  49.285  21.075  1.00 29.13           C  
ATOM    268  CD2 TYR A  38      14.606  47.567  22.663  1.00 32.51           C  
ATOM    269  CE1 TYR A  38      15.053  50.223  22.104  1.00 25.00           C  
ATOM    270  CE2 TYR A  38      14.627  48.500  23.696  1.00 33.75           C  
ATOM    271  CZ  TYR A  38      14.849  49.825  23.423  1.00 30.42           C  
ATOM    272  OH  TYR A  38      14.855  50.725  24.490  1.00 30.85           O  
ATOM    273  N   PRO A  39      15.815  44.235  18.486  1.00 23.10           N  
ATOM    274  CA  PRO A  39      15.386  43.554  17.267  1.00 23.48           C  
ATOM    275  C   PRO A  39      13.907  43.730  17.037  1.00 23.33           C  
ATOM    276  O   PRO A  39      13.141  43.656  17.974  1.00 23.62           O  
ATOM    277  CB  PRO A  39      15.722  42.091  17.506  1.00 22.89           C  
ATOM    278  CG  PRO A  39      15.817  41.948  18.955  1.00 29.63           C  
ATOM    279  CD  PRO A  39      16.194  43.282  19.537  1.00 24.50           C  
HETATM  280  N   MSE A  40      13.525  43.998  15.804  1.00 24.89           N  
HETATM  281  CA  MSE A  40      12.127  44.240  15.445  0.50 25.55           C  
HETATM  283  C   MSE A  40      11.812  43.563  14.122  1.00 27.22           C  
HETATM  284  O   MSE A  40      12.594  43.647  13.193  1.00 27.23           O  
HETATM  285  CB  MSE A  40      11.848  45.745  15.328  0.50 24.37           C  
HETATM  287  CG  MSE A  40      12.080  46.568  16.595  0.50 22.47           C  
HETATM  289 SE   MSE A  40      10.873  46.126  18.052  0.38 25.34          SE  
HETATM  291  CE  MSE A  40       9.382  47.269  17.576  0.50 17.62           C  
ATOM    293  N   SER A  41      10.663  42.904  14.047  1.00 31.51           N  
ATOM    294  CA  SER A  41      10.223  42.263  12.830  1.00 34.49           C  
ATOM    295  C   SER A  41       9.533  43.293  11.954  1.00 33.06           C  
ATOM    296  O   SER A  41       8.579  43.889  12.389  1.00 32.24           O  
ATOM    297  CB  SER A  41       9.230  41.142  13.170  1.00 36.23           C  
ATOM    298  OG  SER A  41       8.908  40.404  12.001  1.00 42.70           O  
ATOM    299  N   LYS A  42       9.971  43.490  10.725  1.00 33.69           N  
ATOM    300  CA  LYS A  42       9.328  44.489   9.872  1.00 35.27           C  
ATOM    301  C   LYS A  42       8.033  43.927   9.265  1.00 35.93           C  
ATOM    302  O   LYS A  42       8.018  42.782   8.830  1.00 35.18           O  
ATOM    303  CB  LYS A  42      10.293  45.011   8.791  1.00 39.36           C  
ATOM    304  CG  LYS A  42      10.511  44.151   7.558  1.00 40.73           C  
ATOM    305  CD  LYS A  42      11.592  44.768   6.635  1.00 43.07           C  
ATOM    306  CE  LYS A  42      11.608  44.118   5.250  1.00 44.66           C  
ATOM    307  NZ  LYS A  42      11.684  42.636   5.348  1.00 54.45           N  
ATOM    308  N   SER A  43       6.980  44.743   9.242  1.00 37.31           N  
ATOM    309  CA  SER A  43       5.685  44.418   8.616  1.00 41.72           C  
ATOM    310  C   SER A  43       5.347  45.210   7.337  1.00 46.06           C  
ATOM    311  O   SER A  43       5.638  46.402   7.229  1.00 45.60           O  
ATOM    312  CB  SER A  43       4.575  44.701   9.614  1.00 41.26           C  
ATOM    313  OG  SER A  43       4.577  43.718  10.615  1.00 41.29           O  
ATOM    314  N   GLY A  44       4.659  44.564   6.401  1.00 48.46           N  
ATOM    315  CA  GLY A  44       4.284  45.215   5.135  1.00 49.56           C  
ATOM    316  C   GLY A  44       5.473  45.354   4.190  1.00 52.47           C  
ATOM    317  O   GLY A  44       6.623  45.063   4.570  1.00 52.84           O  
ATOM    318  N   ASP A  45       5.197  45.802   2.964  1.00 52.84           N  
ATOM    319  CA  ASP A  45       6.195  45.843   1.891  1.00 53.51           C  
ATOM    320  C   ASP A  45       6.563  47.281   1.557  1.00 53.86           C  
ATOM    321  O   ASP A  45       5.715  48.171   1.650  1.00 54.94           O  
ATOM    322  CB  ASP A  45       5.657  45.129   0.645  1.00 53.70           C  
ATOM    323  N   GLU A  49       5.277  53.647  -0.128  1.00 38.51           N  
ATOM    324  CA  GLU A  49       5.728  54.830   0.606  1.00 36.56           C  
ATOM    325  C   GLU A  49       7.116  54.618   1.206  1.00 34.97           C  
ATOM    326  O   GLU A  49       7.561  53.476   1.425  1.00 32.55           O  
ATOM    327  CB  GLU A  49       4.747  55.187   1.740  1.00 38.34           C  
ATOM    328  CG  GLU A  49       3.287  55.363   1.313  1.00 47.87           C  
ATOM    329  CD  GLU A  49       3.068  56.596   0.456  1.00 58.71           C  
ATOM    330  OE1 GLU A  49       4.023  57.396   0.293  1.00 70.92           O  
ATOM    331  OE2 GLU A  49       1.943  56.758  -0.070  1.00 64.08           O  
ATOM    332  N   ALA A  50       7.779  55.722   1.491  1.00 26.90           N  
ATOM    333  CA  ALA A  50       9.106  55.674   2.085  1.00 28.00           C  
ATOM    334  C   ALA A  50       8.892  55.561   3.564  1.00 25.75           C  
ATOM    335  O   ALA A  50       9.201  56.502   4.327  1.00 23.90           O  
ATOM    336  CB  ALA A  50       9.881  56.912   1.757  1.00 28.90           C  
ATOM    337  N   THR A  51       8.276  54.446   3.978  1.00 23.96           N  
ATOM    338  CA  THR A  51       7.817  54.274   5.378  1.00 23.19           C  
ATOM    339  C   THR A  51       8.050  52.831   5.773  1.00 25.01           C  
ATOM    340  O   THR A  51       7.964  51.934   4.922  1.00 28.47           O  
ATOM    341  CB  THR A  51       6.328  54.579   5.481  0.50 26.16           C  
ATOM    343  OG1 THR A  51       5.596  53.506   4.890  0.50 26.99           O  
ATOM    345  CG2 THR A  51       5.968  55.858   4.710  0.50 20.29           C  
ATOM    347  N   LEU A  52       8.402  52.602   7.024  1.00 22.64           N  
ATOM    348  CA  LEU A  52       8.468  51.269   7.572  1.00 23.11           C  
ATOM    349  C   LEU A  52       7.472  51.214   8.716  1.00 25.50           C  
ATOM    350  O   LEU A  52       7.174  52.240   9.336  1.00 25.40           O  
ATOM    351  CB  LEU A  52       9.824  50.932   8.141  1.00 23.47           C  
ATOM    352  CG  LEU A  52      11.124  51.030   7.342  1.00 30.53           C  
ATOM    353  CD1 LEU A  52      12.309  50.933   8.321  1.00 32.41           C  
ATOM    354  CD2 LEU A  52      11.146  49.986   6.312  1.00 34.46           C  
ATOM    355  N   TRP A  53       6.990  50.005   8.971  1.00 25.18           N  
ATOM    356  CA  TRP A  53       6.011  49.761  10.037  1.00 25.58           C  
ATOM    357  C   TRP A  53       6.438  48.597  10.918  1.00 25.63           C  
ATOM    358  O   TRP A  53       6.877  47.562  10.412  1.00 24.92           O  
ATOM    359  CB  TRP A  53       4.674  49.437   9.410  1.00 23.87           C  
ATOM    360  CG  TRP A  53       4.006  50.553   8.673  1.00 25.16           C  
ATOM    361  CD1 TRP A  53       4.111  50.841   7.344  1.00 28.85           C  
ATOM    362  CD2 TRP A  53       3.122  51.519   9.226  1.00 24.02           C  
ATOM    363  NE1 TRP A  53       3.338  51.933   7.045  1.00 28.26           N  
ATOM    364  CE2 TRP A  53       2.724  52.368   8.187  1.00 27.25           C  
ATOM    365  CE3 TRP A  53       2.607  51.738  10.499  1.00 26.17           C  
ATOM    366  CZ2 TRP A  53       1.850  53.426   8.388  1.00 24.93           C  
ATOM    367  CZ3 TRP A  53       1.759  52.805  10.696  1.00 30.84           C  
ATOM    368  CH2 TRP A  53       1.365  53.617   9.632  1.00 28.33           C  
ATOM    369  N   PHE A  54       6.274  48.752  12.235  1.00 24.92           N  
ATOM    370  CA  PHE A  54       6.551  47.685  13.205  1.00 24.92           C  
ATOM    371  C   PHE A  54       5.446  47.659  14.231  1.00 23.88           C  
ATOM    372  O   PHE A  54       4.950  48.719  14.623  1.00 24.59           O  
ATOM    373  CB  PHE A  54       7.864  47.920  13.958  1.00 26.28           C  
ATOM    374  CG  PHE A  54       9.043  48.113  13.063  1.00 25.26           C  
ATOM    375  CD1 PHE A  54       9.369  49.375  12.577  1.00 24.71           C  
ATOM    376  CD2 PHE A  54       9.826  47.029  12.701  1.00 24.02           C  
ATOM    377  CE1 PHE A  54      10.475  49.553  11.712  1.00 26.15           C  
ATOM    378  CE2 PHE A  54      10.941  47.194  11.867  1.00 28.10           C  
ATOM    379  CZ  PHE A  54      11.249  48.441  11.366  1.00 26.39           C  
ATOM    380  N   PHE A  55       5.070  46.462  14.659  1.00 25.01           N  
ATOM    381  CA  PHE A  55       4.189  46.317  15.816  1.00 22.71           C  
ATOM    382  C   PHE A  55       4.984  46.466  17.097  1.00 25.11           C  
ATOM    383  O   PHE A  55       6.138  46.024  17.176  1.00 23.89           O  
ATOM    384  CB  PHE A  55       3.484  44.957  15.762  1.00 23.29           C  
ATOM    385  CG  PHE A  55       2.365  44.901  14.793  1.00 23.06           C  
ATOM    386  CD1 PHE A  55       1.058  45.221  15.171  1.00 26.92           C  
ATOM    387  CD2 PHE A  55       2.596  44.475  13.480  1.00 26.63           C  
ATOM    388  CE1 PHE A  55       0.015  45.146  14.263  1.00 25.72           C  
ATOM    389  CE2 PHE A  55       1.554  44.412  12.570  1.00 26.59           C  
ATOM    390  CZ  PHE A  55       0.254  44.737  12.969  1.00 26.67           C  
ATOM    391  N   THR A  56       4.397  47.125  18.096  1.00 24.28           N  
ATOM    392  CA  THR A  56       5.019  47.302  19.406  1.00 25.10           C  
ATOM    393  C   THR A  56       3.926  47.316  20.484  1.00 26.64           C  
ATOM    394  O   THR A  56       2.736  47.171  20.152  1.00 27.70           O  
ATOM    395  CB  THR A  56       5.836  48.582  19.470  1.00 29.90           C  
ATOM    396  OG1 THR A  56       6.695  48.512  20.610  1.00 30.02           O  
ATOM    397  CG2 THR A  56       4.919  49.825  19.514  1.00 26.15           C  
ATOM    398  N   TYR A  57       4.319  47.400  21.754  1.00 23.96           N  
ATOM    399  CA  TYR A  57       3.376  47.633  22.852  1.00 22.49           C  
ATOM    400  C   TYR A  57       3.481  49.127  23.176  1.00 23.39           C  
ATOM    401  O   TYR A  57       4.588  49.659  23.283  1.00 24.01           O  
ATOM    402  CB  TYR A  57       3.703  46.775  24.069  1.00 22.60           C  
ATOM    403  CG  TYR A  57       3.469  45.311  23.823  1.00 25.35           C  
ATOM    404  CD1 TYR A  57       2.184  44.781  23.873  1.00 23.78           C  
ATOM    405  CD2 TYR A  57       4.524  44.456  23.525  1.00 29.94           C  
ATOM    406  CE1 TYR A  57       1.953  43.429  23.649  1.00 24.66           C  
ATOM    407  CE2 TYR A  57       4.302  43.092  23.281  1.00 25.04           C  
ATOM    408  CZ  TYR A  57       3.022  42.595  23.352  1.00 27.85           C  
ATOM    409  OH  TYR A  57       2.779  41.260  23.143  1.00 26.39           O  
ATOM    410  N   ALA A  58       2.347  49.776  23.348  1.00 22.65           N  
ATOM    411  CA  ALA A  58       2.299  51.248  23.526  1.00 24.34           C  
ATOM    412  C   ALA A  58       2.925  51.656  24.833  1.00 24.41           C  
ATOM    413  O   ALA A  58       3.402  52.804  24.973  1.00 24.43           O  
ATOM    414  CB  ALA A  58       0.881  51.779  23.428  1.00 20.81           C  
ATOM    415  N   GLY A  59       2.933  50.739  25.804  1.00 24.80           N  
ATOM    416  CA  GLY A  59       3.584  51.009  27.070  1.00 23.95           C  
ATOM    417  C   GLY A  59       5.062  50.673  27.144  1.00 24.75           C  
ATOM    418  O   GLY A  59       5.650  50.799  28.214  1.00 24.91           O  
ATOM    419  N   SER A  60       5.668  50.248  26.033  1.00 22.86           N  
ATOM    420  CA  SER A  60       7.068  49.883  26.000  1.00 25.62           C  
ATOM    421  C   SER A  60       8.021  51.071  26.225  1.00 24.95           C  
ATOM    422  O   SER A  60       7.688  52.242  25.979  1.00 24.14           O  
ATOM    423  CB  SER A  60       7.427  49.197  24.678  1.00 25.57           C  
ATOM    424  OG  SER A  60       7.330  50.122  23.614  1.00 28.18           O  
ATOM    425  N   HIS A  61       9.220  50.756  26.692  1.00 26.78           N  
ATOM    426  CA  HIS A  61      10.198  51.810  26.956  1.00 28.16           C  
ATOM    427  C   HIS A  61      10.603  52.490  25.646  1.00 25.49           C  
ATOM    428  O   HIS A  61      10.785  53.684  25.630  1.00 26.09           O  
ATOM    429  CB  HIS A  61      11.419  51.257  27.716  1.00 31.71           C  
ATOM    430  CG  HIS A  61      12.357  52.334  28.169  1.00 39.30           C  
ATOM    431  ND1 HIS A  61      11.968  53.342  29.023  1.00 43.74           N  
ATOM    432  CD2 HIS A  61      13.652  52.581  27.863  1.00 47.58           C  
ATOM    433  CE1 HIS A  61      12.979  54.167  29.222  1.00 46.91           C  
ATOM    434  NE2 HIS A  61      14.015  53.729  28.531  1.00 41.30           N  
ATOM    435  N   LYS A  62      10.711  51.759  24.546  1.00 26.02           N  
ATOM    436  CA  LYS A  62      11.101  52.369  23.280  1.00 25.57           C  
ATOM    437  C   LYS A  62      10.099  53.455  22.850  1.00 27.40           C  
ATOM    438  O   LYS A  62      10.456  54.425  22.212  1.00 24.96           O  
ATOM    439  CB  LYS A  62      11.310  51.323  22.171  1.00 24.51           C  
ATOM    440  CG  LYS A  62      10.052  50.670  21.574  1.00 27.99           C  
ATOM    441  CD  LYS A  62      10.416  49.594  20.554  1.00 30.96           C  
ATOM    442  CE  LYS A  62      10.956  48.301  21.216  1.00 37.17           C  
ATOM    443  NZ  LYS A  62       9.961  47.802  22.221  1.00 41.58           N  
ATOM    444  N   VAL A  63       8.823  53.271  23.171  1.00 25.72           N  
ATOM    445  CA  VAL A  63       7.821  54.273  22.848  1.00 22.08           C  
ATOM    446  C   VAL A  63       8.023  55.535  23.678  1.00 24.72           C  
ATOM    447  O   VAL A  63       7.932  56.652  23.171  1.00 26.71           O  
ATOM    448  CB  VAL A  63       6.363  53.665  23.004  1.00 22.38           C  
ATOM    449  CG1 VAL A  63       5.335  54.755  22.959  1.00 21.93           C  
ATOM    450  CG2 VAL A  63       6.091  52.647  21.924  1.00 22.85           C  
ATOM    451  N   THR A  64       8.354  55.379  24.955  1.00 23.86           N  
ATOM    452  CA  THR A  64       8.656  56.529  25.782  1.00 25.94           C  
ATOM    453  C   THR A  64       9.881  57.263  25.228  1.00 23.06           C  
ATOM    454  O   THR A  64       9.893  58.476  25.193  1.00 25.94           O  
ATOM    455  CB  THR A  64       8.822  56.201  27.305  1.00 29.09           C  
ATOM    456  OG1 THR A  64      10.133  55.709  27.569  1.00 41.07           O  
ATOM    457  CG2 THR A  64       7.801  55.187  27.715  1.00 22.18           C  
ATOM    458  N   GLU A  65      10.873  56.515  24.716  1.00 23.52           N  
ATOM    459  CA  GLU A  65      12.034  57.158  24.098  1.00 22.92           C  
ATOM    460  C   GLU A  65      11.635  57.961  22.876  1.00 25.10           C  
ATOM    461  O   GLU A  65      12.022  59.139  22.738  1.00 23.83           O  
ATOM    462  CB  GLU A  65      13.132  56.116  23.782  1.00 20.79           C  
ATOM    463  CG  GLU A  65      13.621  55.431  25.063  1.00 25.24           C  
ATOM    464  CD  GLU A  65      14.477  54.176  24.886  1.00 32.48           C  
ATOM    465  OE1 GLU A  65      14.287  53.381  23.918  1.00 29.38           O  
ATOM    466  OE2 GLU A  65      15.332  53.960  25.785  1.00 40.46           O  
ATOM    467  N   ILE A  66      10.876  57.345  21.977  1.00 23.32           N  
ATOM    468  CA  ILE A  66      10.589  58.023  20.704  0.50 25.00           C  
ATOM    470  C   ILE A  66       9.648  59.209  20.936  1.00 25.16           C  
ATOM    471  O   ILE A  66       9.685  60.188  20.183  1.00 26.35           O  
ATOM    472  CB  ILE A  66      10.117  57.075  19.568  0.50 24.57           C  
ATOM    474  CG1 ILE A  66       8.782  56.386  19.889  0.50 26.74           C  
ATOM    476  CG2 ILE A  66      11.222  56.050  19.216  0.50 27.71           C  
ATOM    478  CD1 ILE A  66       7.639  56.999  19.155  0.50 27.24           C  
ATOM    480  N   GLU A  67       8.861  59.174  21.999  1.00 24.37           N  
ATOM    481  CA  GLU A  67       8.032  60.290  22.310  1.00 27.01           C  
ATOM    482  C   GLU A  67       8.830  61.534  22.707  1.00 29.26           C  
ATOM    483  O   GLU A  67       8.361  62.634  22.485  1.00 31.55           O  
ATOM    484  CB  GLU A  67       7.012  59.889  23.365  1.00 28.52           C  
ATOM    485  CG  GLU A  67       6.025  58.850  22.819  1.00 33.28           C  
ATOM    486  CD  GLU A  67       4.749  59.438  22.255  1.00 46.76           C  
ATOM    487  OE1 GLU A  67       4.556  60.657  22.377  1.00 53.18           O  
ATOM    488  OE2 GLU A  67       3.922  58.667  21.711  1.00 46.06           O  
ATOM    489  N   HIS A  68      10.031  61.375  23.261  1.00 26.77           N  
ATOM    490  CA  HIS A  68      10.890  62.509  23.541  1.00 26.54           C  
ATOM    491  C   HIS A  68      11.903  62.785  22.419  1.00 28.45           C  
ATOM    492  O   HIS A  68      12.336  63.931  22.224  1.00 31.02           O  
ATOM    493  CB  HIS A  68      11.658  62.274  24.835  1.00 25.99           C  
ATOM    494  CG  HIS A  68      10.908  62.676  26.066  1.00 29.08           C  
ATOM    495  ND1 HIS A  68      11.472  62.620  27.320  1.00 36.11           N  
ATOM    496  CD2 HIS A  68       9.654  63.152  26.231  1.00 32.65           C  
ATOM    497  CE1 HIS A  68      10.585  63.032  28.212  1.00 38.64           C  
ATOM    498  NE2 HIS A  68       9.469  63.346  27.581  1.00 31.97           N  
ATOM    499  N   HIS A  69      12.354  61.741  21.735  1.00 24.75           N  
ATOM    500  CA  HIS A  69      13.302  61.917  20.633  1.00 21.52           C  
ATOM    501  C   HIS A  69      12.846  61.060  19.471  1.00 22.23           C  
ATOM    502  O   HIS A  69      13.124  59.877  19.435  1.00 22.00           O  
ATOM    503  CB  HIS A  69      14.729  61.557  21.043  1.00 22.49           C  
ATOM    504  CG  HIS A  69      15.766  62.037  20.076  1.00 21.43           C  
ATOM    505  ND1 HIS A  69      16.218  63.341  20.092  1.00 25.33           N  
ATOM    506  CD2 HIS A  69      16.398  61.432  19.043  1.00 24.55           C  
ATOM    507  CE1 HIS A  69      17.108  63.508  19.120  1.00 26.49           C  
ATOM    508  NE2 HIS A  69      17.226  62.372  18.457  1.00 23.10           N  
ATOM    509  N   GLU A  70      12.146  61.673  18.528  1.00 20.95           N  
ATOM    510  CA  GLU A  70      11.475  60.917  17.447  1.00 22.48           C  
ATOM    511  C   GLU A  70      12.420  60.301  16.436  1.00 20.62           C  
ATOM    512  O   GLU A  70      12.041  59.349  15.773  1.00 22.37           O  
ATOM    513  CB  GLU A  70      10.440  61.798  16.736  1.00 23.54           C  
ATOM    514  CG  GLU A  70      11.046  62.957  15.951  1.00 22.77           C  
ATOM    515  CD  GLU A  70      10.093  63.671  15.020  1.00 25.59           C  
ATOM    516  OE1 GLU A  70       8.899  63.283  14.920  1.00 25.36           O  
ATOM    517  OE2 GLU A  70      10.568  64.623  14.341  1.00 26.18           O  
ATOM    518  N   GLN A  71      13.629  60.859  16.270  1.00 21.67           N  
ATOM    519  CA  GLN A  71      14.575  60.306  15.339  1.00 22.61           C  
ATOM    520  C   GLN A  71      15.045  58.932  15.802  1.00 22.04           C  
ATOM    521  O   GLN A  71      15.419  58.741  16.968  1.00 22.63           O  
ATOM    522  CB  GLN A  71      15.778  61.208  15.163  1.00 22.64           C  
ATOM    523  CG  GLN A  71      15.423  62.600  14.680  1.00 24.27           C  
ATOM    524  CD  GLN A  71      15.410  63.591  15.804  1.00 27.35           C  
ATOM    525  OE1 GLN A  71      14.806  63.370  16.862  1.00 26.24           O  
ATOM    526  NE2 GLN A  71      16.081  64.699  15.588  1.00 23.71           N  
ATOM    527  N   VAL A  72      15.082  58.001  14.864  1.00 22.57           N  
ATOM    528  CA  VAL A  72      15.528  56.637  15.103  1.00 22.75           C  
ATOM    529  C   VAL A  72      16.392  56.155  13.964  1.00 23.30           C  
ATOM    530  O   VAL A  72      16.466  56.794  12.915  1.00 21.14           O  
ATOM    531  CB  VAL A  72      14.310  55.670  15.259  1.00 22.94           C  
ATOM    532  CG1 VAL A  72      13.426  56.089  16.473  1.00 21.94           C  
ATOM    533  CG2 VAL A  72      13.481  55.518  13.929  1.00 20.39           C  
ATOM    534  N   ASN A  73      17.012  55.008  14.155  1.00 21.84           N  
ATOM    535  CA  ASN A  73      17.659  54.307  13.051  1.00 21.25           C  
ATOM    536  C   ASN A  73      17.190  52.891  13.057  1.00 23.85           C  
ATOM    537  O   ASN A  73      17.024  52.297  14.107  1.00 23.78           O  
ATOM    538  CB  ASN A  73      19.201  54.342  13.241  1.00 25.40           C  
ATOM    539  CG  ASN A  73      19.966  53.680  12.094  1.00 22.66           C  
ATOM    540  OD1 ASN A  73      20.151  52.455  12.070  1.00 23.80           O  
ATOM    541  ND2 ASN A  73      20.358  54.486  11.120  1.00 21.91           N  
ATOM    542  N   VAL A  74      16.984  52.344  11.866  1.00 24.57           N  
ATOM    543  CA  VAL A  74      16.766  50.914  11.737  1.00 22.50           C  
ATOM    544  C   VAL A  74      17.823  50.372  10.815  1.00 21.52           C  
ATOM    545  O   VAL A  74      17.976  50.874   9.697  1.00 22.30           O  
ATOM    546  CB  VAL A  74      15.378  50.555  11.193  1.00 24.97           C  
ATOM    547  CG1 VAL A  74      15.176  49.040  11.371  1.00 26.97           C  
ATOM    548  CG2 VAL A  74      14.288  51.328  11.935  1.00 21.68           C  
ATOM    549  N   SER A  75      18.587  49.392  11.295  1.00 22.92           N  
ATOM    550  CA  SER A  75      19.591  48.779  10.458  1.00 24.37           C  
ATOM    551  C   SER A  75      19.176  47.363  10.052  1.00 23.92           C  
ATOM    552  O   SER A  75      18.596  46.609  10.834  1.00 22.22           O  
ATOM    553  CB  SER A  75      20.947  48.796  11.137  1.00 25.55           C  
ATOM    554  OG  SER A  75      20.992  47.960  12.279  1.00 29.94           O  
ATOM    555  N   PHE A  76      19.540  46.986   8.852  1.00 26.25           N  
ATOM    556  CA  PHE A  76      19.265  45.642   8.341  1.00 29.18           C  
ATOM    557  C   PHE A  76      20.567  45.076   7.835  1.00 32.56           C  
ATOM    558  O   PHE A  76      21.270  45.710   7.044  1.00 32.69           O  
ATOM    559  CB  PHE A  76      18.222  45.692   7.231  1.00 30.82           C  
ATOM    560  CG  PHE A  76      16.858  46.064   7.698  1.00 25.01           C  
ATOM    561  CD1 PHE A  76      15.988  45.113   8.169  1.00 26.20           C  
ATOM    562  CD2 PHE A  76      16.429  47.380   7.641  1.00 31.59           C  
ATOM    563  CE1 PHE A  76      14.704  45.459   8.589  1.00 34.12           C  
ATOM    564  CE2 PHE A  76      15.170  47.725   8.037  1.00 33.86           C  
ATOM    565  CZ  PHE A  76      14.300  46.755   8.533  1.00 31.44           C  
ATOM    566  N   SER A  77      20.961  43.906   8.326  1.00 30.44           N  
ATOM    567  CA  SER A  77      22.203  43.358   7.810  1.00 34.69           C  
ATOM    568  C   SER A  77      22.068  41.910   7.404  1.00 31.91           C  
ATOM    569  O   SER A  77      21.330  41.157   8.037  1.00 31.27           O  
ATOM    570  CB  SER A  77      23.351  43.596   8.773  1.00 34.85           C  
ATOM    571  OG  SER A  77      22.951  43.495  10.109  1.00 40.14           O  
ATOM    572  N   SER A  78      22.707  41.567   6.279  1.00 29.69           N  
ATOM    573  CA  SER A  78      22.746  40.203   5.795  1.00 29.72           C  
ATOM    574  C   SER A  78      24.066  39.969   5.080  1.00 26.83           C  
ATOM    575  O   SER A  78      24.208  40.292   3.903  1.00 23.70           O  
ATOM    576  CB  SER A  78      21.586  39.843   4.829  1.00 28.49           C  
ATOM    577  OG  SER A  78      21.727  38.479   4.415  1.00 32.30           O  
ATOM    578  N   PRO A  79      25.027  39.369   5.786  1.00 30.65           N  
ATOM    579  CA  PRO A  79      26.232  38.846   5.126  1.00 28.57           C  
ATOM    580  C   PRO A  79      25.930  37.941   3.948  1.00 26.85           C  
ATOM    581  O   PRO A  79      26.584  38.077   2.918  1.00 26.89           O  
ATOM    582  CB  PRO A  79      26.902  38.044   6.235  1.00 30.00           C  
ATOM    583  CG  PRO A  79      26.472  38.778   7.494  1.00 29.69           C  
ATOM    584  CD  PRO A  79      25.058  39.142   7.244  1.00 29.30           C  
ATOM    585  N   GLU A  80      24.969  37.024   4.089  1.00 23.99           N  
ATOM    586  CA  GLU A  80      24.662  36.063   3.022  1.00 25.84           C  
ATOM    587  C   GLU A  80      24.208  36.792   1.757  1.00 24.11           C  
ATOM    588  O   GLU A  80      24.487  36.347   0.645  1.00 23.34           O  
ATOM    589  CB  GLU A  80      23.566  35.060   3.450  1.00 27.87           C  
ATOM    590  CG  GLU A  80      24.038  33.906   4.339  1.00 35.41           C  
ATOM    591  CD  GLU A  80      22.985  32.782   4.545  1.00 34.19           C  
ATOM    592  OE1 GLU A  80      22.059  32.690   3.706  1.00 28.56           O  
ATOM    593  OE2 GLU A  80      23.110  31.985   5.531  1.00 35.98           O  
ATOM    594  N   GLN A  81      23.519  37.914   1.932  1.00 23.95           N  
ATOM    595  CA  GLN A  81      23.038  38.713   0.804  1.00 25.11           C  
ATOM    596  C   GLN A  81      23.993  39.843   0.494  1.00 24.62           C  
ATOM    597  O   GLN A  81      23.680  40.736  -0.316  1.00 27.08           O  
ATOM    598  CB  GLN A  81      21.623  39.275   1.083  1.00 24.45           C  
ATOM    599  CG  GLN A  81      20.573  38.222   1.360  1.00 25.10           C  
ATOM    600  CD  GLN A  81      19.237  38.827   1.751  1.00 29.10           C  
ATOM    601  OE1 GLN A  81      18.844  39.891   1.250  1.00 29.19           O  
ATOM    602  NE2 GLN A  81      18.533  38.157   2.658  1.00 32.98           N  
ATOM    603  N   GLN A  82      25.148  39.853   1.157  1.00 25.40           N  
ATOM    604  CA  GLN A  82      26.143  40.868   0.929  1.00 25.70           C  
ATOM    605  C   GLN A  82      25.583  42.301   1.021  1.00 26.36           C  
ATOM    606  O   GLN A  82      25.740  43.103   0.101  1.00 26.39           O  
ATOM    607  CB  GLN A  82      26.748  40.668  -0.456  1.00 27.51           C  
ATOM    608  CG  GLN A  82      27.391  39.305  -0.697  1.00 29.29           C  
ATOM    609  CD  GLN A  82      28.188  39.293  -1.997  1.00 32.71           C  
ATOM    610  OE1 GLN A  82      27.641  39.028  -3.075  1.00 41.26           O  
ATOM    611  NE2 GLN A  82      29.491  39.599  -1.898  1.00 34.47           N  
ATOM    612  N   ARG A  83      24.892  42.616   2.102  1.00 25.89           N  
ATOM    613  CA  ARG A  83      24.374  43.962   2.242  1.00 26.14           C  
ATOM    614  C   ARG A  83      24.103  44.401   3.670  1.00 20.82           C  
ATOM    615  O   ARG A  83      23.657  43.624   4.533  1.00 23.71           O  
ATOM    616  CB  ARG A  83      23.081  44.133   1.439  1.00 29.94           C  
ATOM    617  CG  ARG A  83      21.941  43.339   1.969  1.00 31.29           C  
ATOM    618  CD  ARG A  83      20.796  43.363   0.986  1.00 35.87           C  
ATOM    619  NE  ARG A  83      21.137  42.669  -0.225  1.00 34.54           N  
ATOM    620  CZ  ARG A  83      20.311  42.458  -1.245  1.00 35.14           C  
ATOM    621  NH1 ARG A  83      19.087  42.897  -1.218  1.00 37.77           N  
ATOM    622  NH2 ARG A  83      20.722  41.777  -2.298  1.00 38.79           N  
ATOM    623  N   TYR A  84      24.337  45.690   3.872  1.00 21.76           N  
ATOM    624  CA  TYR A  84      24.182  46.322   5.153  1.00 20.15           C  
ATOM    625  C   TYR A  84      23.441  47.606   4.863  1.00 22.39           C  
ATOM    626  O   TYR A  84      23.847  48.335   3.945  1.00 24.04           O  
ATOM    627  CB  TYR A  84      25.543  46.640   5.711  1.00 23.14           C  
ATOM    628  CG  TYR A  84      26.357  45.400   5.914  1.00 23.45           C  
ATOM    629  CD1 TYR A  84      27.128  44.886   4.887  1.00 32.24           C  
ATOM    630  CD2 TYR A  84      26.261  44.695   7.092  1.00 29.34           C  
ATOM    631  CE1 TYR A  84      27.809  43.723   5.056  1.00 35.42           C  
ATOM    632  CE2 TYR A  84      26.946  43.523   7.264  1.00 34.48           C  
ATOM    633  CZ  TYR A  84      27.700  43.054   6.249  1.00 31.40           C  
ATOM    634  OH  TYR A  84      28.405  41.888   6.420  1.00 42.96           O  
ATOM    635  N   VAL A  85      22.352  47.861   5.589  1.00 21.08           N  
ATOM    636  CA  VAL A  85      21.497  49.006   5.302  1.00 21.25           C  
ATOM    637  C   VAL A  85      21.242  49.788   6.583  1.00 22.80           C  
ATOM    638  O   VAL A  85      20.862  49.214   7.619  1.00 26.19           O  
ATOM    639  CB  VAL A  85      20.147  48.575   4.716  1.00 22.77           C  
ATOM    640  CG1 VAL A  85      19.283  49.817   4.325  1.00 21.37           C  
ATOM    641  CG2 VAL A  85      20.331  47.615   3.530  1.00 23.14           C  
ATOM    642  N   SER A  86      21.445  51.094   6.517  1.00 19.78           N  
ATOM    643  CA  SER A  86      21.114  51.985   7.630  1.00 18.85           C  
ATOM    644  C   SER A  86      19.963  52.899   7.212  1.00 19.87           C  
ATOM    645  O   SER A  86      20.103  53.656   6.250  1.00 24.14           O  
ATOM    646  CB  SER A  86      22.303  52.831   7.951  1.00 21.01           C  
ATOM    647  OG  SER A  86      22.021  53.881   8.859  1.00 23.82           O  
ATOM    648  N   ILE A  87      18.866  52.862   7.945  1.00 22.34           N  
ATOM    649  CA  ILE A  87      17.707  53.688   7.644  1.00 20.39           C  
ATOM    650  C   ILE A  87      17.514  54.720   8.738  1.00 23.09           C  
ATOM    651  O   ILE A  87      17.180  54.370   9.855  1.00 23.98           O  
ATOM    652  CB  ILE A  87      16.430  52.850   7.445  1.00 21.17           C  
ATOM    653  CG1 ILE A  87      16.655  51.864   6.287  1.00 22.19           C  
ATOM    654  CG2 ILE A  87      15.205  53.758   7.199  1.00 23.82           C  
ATOM    655  CD1 ILE A  87      15.540  50.859   6.020  1.00 23.98           C  
ATOM    656  N   SER A  88      17.717  55.988   8.401  1.00 20.19           N  
ATOM    657  CA  SER A  88      17.462  57.087   9.351  1.00 20.90           C  
ATOM    658  C   SER A  88      16.088  57.606   9.077  1.00 21.12           C  
ATOM    659  O   SER A  88      15.767  57.965   7.923  1.00 21.25           O  
ATOM    660  CB  SER A  88      18.449  58.242   9.179  1.00 24.07           C  
ATOM    661  OG  SER A  88      19.797  57.776   9.209  1.00 28.86           O  
ATOM    662  N   GLY A  89      15.287  57.711  10.130  1.00 22.18           N  
ATOM    663  CA  GLY A  89      13.934  58.213  10.018  1.00 24.17           C  
ATOM    664  C   GLY A  89      13.405  58.779  11.319  1.00 23.51           C  
ATOM    665  O   GLY A  89      14.120  58.846  12.334  1.00 23.39           O  
ATOM    666  N   THR A  90      12.128  59.132  11.290  1.00 22.51           N  
ATOM    667  CA  THR A  90      11.445  59.589  12.490  1.00 23.17           C  
ATOM    668  C   THR A  90      10.297  58.634  12.739  1.00 24.23           C  
ATOM    669  O   THR A  90       9.642  58.206  11.792  1.00 25.59           O  
ATOM    670  CB  THR A  90      10.930  61.040  12.378  1.00 24.64           C  
ATOM    671  OG1 THR A  90       9.954  61.149  11.338  1.00 22.71           O  
ATOM    672  CG2 THR A  90      12.095  62.047  12.134  1.00 23.93           C  
ATOM    673  N   SER A  91      10.020  58.377  14.008  1.00 23.16           N  
ATOM    674  CA  SER A  91       9.037  57.390  14.373  1.00 21.50           C  
ATOM    675  C   SER A  91       7.890  58.025  15.136  1.00 25.20           C  
ATOM    676  O   SER A  91       8.038  59.021  15.867  1.00 26.66           O  
ATOM    677  CB  SER A  91       9.733  56.284  15.201  1.00 24.11           C  
ATOM    678  OG  SER A  91       8.851  55.221  15.467  1.00 32.89           O  
ATOM    679  N   GLN A  92       6.707  57.436  14.974  1.00 26.28           N  
ATOM    680  CA  GLN A  92       5.556  57.899  15.697  1.00 26.95           C  
ATOM    681  C   GLN A  92       4.702  56.689  16.048  1.00 23.88           C  
ATOM    682  O   GLN A  92       4.616  55.713  15.290  1.00 24.21           O  
ATOM    683  CB  GLN A  92       4.746  58.875  14.867  1.00 29.83           C  
ATOM    684  CG  GLN A  92       4.228  58.356  13.594  1.00 35.36           C  
ATOM    685  CD  GLN A  92       3.388  59.393  12.822  1.00 40.99           C  
ATOM    686  OE1 GLN A  92       2.316  59.810  13.284  1.00 50.44           O  
ATOM    687  NE2 GLN A  92       3.872  59.794  11.639  1.00 40.30           N  
ATOM    688  N   LEU A  93       4.063  56.811  17.197  1.00 24.72           N  
ATOM    689  CA  LEU A  93       3.158  55.779  17.691  1.00 23.02           C  
ATOM    690  C   LEU A  93       1.828  55.937  16.957  1.00 25.26           C  
ATOM    691  O   LEU A  93       1.260  57.036  16.921  1.00 28.15           O  
ATOM    692  CB  LEU A  93       2.979  55.937  19.190  1.00 26.11           C  
ATOM    693  CG  LEU A  93       2.017  54.920  19.851  1.00 24.28           C  
ATOM    694  CD1 LEU A  93       2.618  53.554  19.854  1.00 23.39           C  
ATOM    695  CD2 LEU A  93       1.654  55.372  21.265  1.00 26.86           C  
ATOM    696  N   VAL A  94       1.328  54.848  16.392  1.00 26.39           N  
ATOM    697  CA  VAL A  94       0.086  54.856  15.641  1.00 24.54           C  
ATOM    698  C   VAL A  94      -0.852  53.813  16.265  1.00 25.59           C  
ATOM    699  O   VAL A  94      -0.447  52.672  16.490  1.00 23.53           O  
ATOM    700  CB  VAL A  94       0.335  54.574  14.164  1.00 22.89           C  
ATOM    701  CG1 VAL A  94      -1.006  54.359  13.375  1.00 22.50           C  
ATOM    702  CG2 VAL A  94       1.174  55.722  13.530  1.00 25.41           C  
ATOM    703  N   LYS A  95      -2.092  54.222  16.505  1.00 24.88           N  
ATOM    704  CA  LYS A  95      -3.103  53.364  17.147  1.00 25.65           C  
ATOM    705  C   LYS A  95      -4.275  52.956  16.238  1.00 27.35           C  
ATOM    706  O   LYS A  95      -5.268  52.449  16.690  1.00 33.24           O  
ATOM    707  CB  LYS A  95      -3.614  54.084  18.379  1.00 27.65           C  
ATOM    708  CG  LYS A  95      -2.522  54.337  19.377  1.00 26.73           C  
ATOM    709  CD  LYS A  95      -3.068  54.933  20.631  1.00 30.44           C  
ATOM    710  CE  LYS A  95      -1.981  55.217  21.613  1.00 34.26           C  
ATOM    711  NZ  LYS A  95      -2.460  56.064  22.745  1.00 32.85           N  
ATOM    712  N   ASP A  96      -4.101  53.131  14.956  1.00 29.49           N  
ATOM    713  CA  ASP A  96      -5.081  52.805  13.931  1.00 29.61           C  
ATOM    714  C   ASP A  96      -5.329  51.323  13.733  1.00 29.51           C  
ATOM    715  O   ASP A  96      -4.532  50.628  13.134  1.00 29.26           O  
ATOM    716  CB  ASP A  96      -4.597  53.391  12.607  1.00 30.32           C  
ATOM    717  CG  ASP A  96      -5.644  53.334  11.529  1.00 40.05           C  
ATOM    718  OD1 ASP A  96      -6.198  52.249  11.290  1.00 41.56           O  
ATOM    719  OD2 ASP A  96      -5.894  54.385  10.915  1.00 53.09           O  
ATOM    720  N   ARG A  97      -6.499  50.867  14.154  1.00 27.37           N  
ATOM    721  CA  ARG A  97      -6.854  49.447  14.071  1.00 29.41           C  
ATOM    722  C   ARG A  97      -6.921  48.885  12.644  1.00 28.38           C  
ATOM    723  O   ARG A  97      -6.571  47.732  12.425  1.00 28.23           O  
ATOM    724  CB  ARG A  97      -8.179  49.223  14.777  1.00 33.34           C  
ATOM    725  CG  ARG A  97      -8.106  49.558  16.270  1.00 40.59           C  
ATOM    726  CD  ARG A  97      -7.348  48.500  17.035  1.00 49.50           C  
ATOM    727  NE  ARG A  97      -8.023  47.209  16.956  1.00 54.50           N  
ATOM    728  CZ  ARG A  97      -7.507  46.064  17.398  1.00 56.82           C  
ATOM    729  NH1 ARG A  97      -6.298  46.047  17.958  1.00 51.23           N  
ATOM    730  NH2 ARG A  97      -8.213  44.935  17.287  1.00 57.19           N  
ATOM    731  N   ASN A  98      -7.356  49.703  11.685  1.00 31.03           N  
ATOM    732  CA  ASN A  98      -7.409  49.278  10.283  1.00 32.69           C  
ATOM    733  C   ASN A  98      -5.997  48.978   9.757  1.00 30.64           C  
ATOM    734  O   ASN A  98      -5.747  47.942   9.135  1.00 27.79           O  
ATOM    735  CB  ASN A  98      -8.074  50.344   9.405  1.00 35.75           C  
ATOM    736  CG  ASN A  98      -9.579  50.577   9.747  1.00 45.64           C  
ATOM    737  OD1 ASN A  98     -10.349  49.629   9.907  1.00 42.64           O  
ATOM    738  ND2 ASN A  98      -9.984  51.850   9.839  1.00 52.53           N  
ATOM    739  N   LYS A  99      -5.064  49.864  10.034  1.00 29.59           N  
ATOM    740  CA  LYS A  99      -3.678  49.629   9.607  1.00 29.07           C  
ATOM    741  C   LYS A  99      -3.085  48.380  10.252  1.00 29.13           C  
ATOM    742  O   LYS A  99      -2.384  47.586   9.601  1.00 28.13           O  
ATOM    743  CB  LYS A  99      -2.793  50.830   9.888  1.00 30.81           C  
ATOM    744  CG  LYS A  99      -1.439  50.709   9.198  1.00 36.03           C  
ATOM    745  CD  LYS A  99      -1.527  50.921   7.675  1.00 42.30           C  
ATOM    746  CE  LYS A  99      -0.234  50.477   6.980  1.00 45.85           C  
ATOM    747  NZ  LYS A  99      -0.108  51.034   5.596  1.00 53.03           N  
HETATM  748  N   MSE A 100      -3.383  48.175  11.526  1.00 27.26           N  
HETATM  749  CA  MSE A 100      -2.975  46.938  12.183  1.00 28.52           C  
HETATM  750  C   MSE A 100      -3.526  45.711  11.504  1.00 26.94           C  
HETATM  751  O   MSE A 100      -2.797  44.755  11.284  1.00 28.85           O  
HETATM  752  CB  MSE A 100      -3.364  46.967  13.650  1.00 28.18           C  
HETATM  753  CG  MSE A 100      -2.409  47.853  14.431  1.00 29.92           C  
HETATM  754 SE   MSE A 100      -2.802  47.760  16.355  0.75 40.39          SE  
HETATM  755  CE  MSE A 100      -3.731  49.410  16.475  1.00 29.18           C  
ATOM    756  N   ARG A 101      -4.813  45.716  11.175  1.00 27.74           N  
ATOM    757  CA  ARG A 101      -5.374  44.600  10.443  1.00 28.82           C  
ATOM    758  C   ARG A 101      -4.648  44.389   9.137  1.00 27.02           C  
ATOM    759  O   ARG A 101      -4.320  43.266   8.777  1.00 28.53           O  
ATOM    760  CB  ARG A 101      -6.855  44.822  10.163  1.00 27.64           C  
ATOM    761  CG  ARG A 101      -7.708  44.413  11.311  1.00 40.20           C  
ATOM    762  CD  ARG A 101      -9.197  44.580  11.027  1.00 48.48           C  
ATOM    763  NE  ARG A 101      -9.785  45.271  12.171  1.00 56.34           N  
ATOM    764  CZ  ARG A 101     -10.098  46.565  12.209  1.00 56.36           C  
ATOM    765  NH1 ARG A 101      -9.963  47.337  11.135  1.00 54.95           N  
ATOM    766  NH2 ARG A 101     -10.594  47.085  13.328  1.00 56.64           N  
ATOM    767  N   GLU A 102      -4.416  45.482   8.430  1.00 29.74           N  
ATOM    768  CA  GLU A 102      -3.772  45.422   7.126  0.50 30.08           C  
ATOM    770  C   GLU A 102      -2.367  44.823   7.232  1.00 31.33           C  
ATOM    771  O   GLU A 102      -1.958  44.040   6.388  1.00 31.40           O  
ATOM    772  CB  GLU A 102      -3.740  46.821   6.493  0.50 31.11           C  
ATOM    774  CG  GLU A 102      -5.119  47.310   6.088  0.50 31.67           C  
ATOM    776  CD  GLU A 102      -5.133  48.646   5.352  0.50 30.27           C  
ATOM    778  OE1 GLU A 102      -4.389  49.574   5.725  0.50 35.65           O  
ATOM    780  OE2 GLU A 102      -5.920  48.769   4.392  0.50 34.41           O  
ATOM    782  N   LEU A 103      -1.638  45.170   8.289  1.00 26.92           N  
ATOM    783  CA  LEU A 103      -0.232  44.774   8.426  1.00 30.63           C  
ATOM    784  C   LEU A 103       0.036  43.488   9.202  1.00 32.22           C  
ATOM    785  O   LEU A 103       1.136  42.944   9.127  1.00 33.61           O  
ATOM    786  CB  LEU A 103       0.528  45.896   9.122  1.00 30.41           C  
ATOM    787  CG  LEU A 103       0.667  47.205   8.358  1.00 32.90           C  
ATOM    788  CD1 LEU A 103       1.227  48.253   9.231  1.00 33.49           C  
ATOM    789  CD2 LEU A 103       1.546  47.025   7.132  1.00 38.03           C  
ATOM    790  N   TRP A 104      -0.932  43.027   9.985  1.00 31.20           N  
ATOM    791  CA  TRP A 104      -0.740  41.846  10.801  1.00 33.76           C  
ATOM    792  C   TRP A 104      -0.334  40.623   9.984  1.00 36.07           C  
ATOM    793  O   TRP A 104      -0.902  40.369   8.939  1.00 39.12           O  
ATOM    794  CB  TRP A 104      -2.029  41.514  11.565  1.00 32.84           C  
ATOM    795  CG  TRP A 104      -1.878  40.260  12.366  1.00 32.77           C  
ATOM    796  CD1 TRP A 104      -2.360  39.024  12.064  1.00 35.40           C  
ATOM    797  CD2 TRP A 104      -1.145  40.119  13.585  1.00 29.78           C  
ATOM    798  NE1 TRP A 104      -1.983  38.117  13.028  1.00 34.35           N  
ATOM    799  CE2 TRP A 104      -1.232  38.767  13.972  1.00 33.15           C  
ATOM    800  CE3 TRP A 104      -0.419  41.005  14.385  1.00 31.17           C  
ATOM    801  CZ2 TRP A 104      -0.635  38.286  15.127  1.00 32.96           C  
ATOM    802  CZ3 TRP A 104       0.180  40.520  15.533  1.00 29.79           C  
ATOM    803  CH2 TRP A 104       0.067  39.178  15.891  1.00 34.42           C  
ATOM    804  N   LYS A 105       0.629  39.855  10.482  1.00 38.32           N  
ATOM    805  CA  LYS A 105       0.945  38.541   9.926  1.00 41.54           C  
ATOM    806  C   LYS A 105       1.040  37.516  11.066  1.00 40.48           C  
ATOM    807  O   LYS A 105       1.478  37.862  12.168  1.00 39.84           O  
ATOM    808  CB  LYS A 105       2.249  38.597   9.111  1.00 41.48           C  
ATOM    809  CG  LYS A 105       3.501  38.880   9.943  1.00 44.94           C  
ATOM    810  CD  LYS A 105       4.666  39.461   9.132  1.00 45.46           C  
ATOM    811  CE  LYS A 105       5.998  39.264   9.862  1.00 52.92           C  
ATOM    812  NZ  LYS A 105       6.905  40.462   9.792  1.00 53.00           N  
ATOM    813  N   PRO A 106       0.644  36.254  10.809  1.00 40.71           N  
ATOM    814  CA  PRO A 106       0.609  35.202  11.841  1.00 39.71           C  
ATOM    815  C   PRO A 106       1.921  35.001  12.604  1.00 39.28           C  
ATOM    816  O   PRO A 106       1.906  34.646  13.780  1.00 39.17           O  
ATOM    817  CB  PRO A 106       0.280  33.942  11.036  1.00 39.95           C  
ATOM    818  CG  PRO A 106      -0.452  34.437   9.862  1.00 40.27           C  
ATOM    819  CD  PRO A 106       0.182  35.741   9.507  1.00 41.51           C  
ATOM    820  N   GLU A 107       3.044  35.240  11.949  1.00 38.11           N  
ATOM    821  CA  GLU A 107       4.347  35.081  12.578  1.00 39.41           C  
ATOM    822  C   GLU A 107       4.526  35.961  13.815  1.00 39.06           C  
ATOM    823  O   GLU A 107       5.293  35.632  14.731  1.00 39.65           O  
ATOM    824  CB  GLU A 107       5.462  35.398  11.574  1.00 42.03           C  
ATOM    825  CG  GLU A 107       5.351  34.624  10.258  1.00 47.50           C  
ATOM    826  CD  GLU A 107       4.462  35.310   9.226  1.00 50.60           C  
ATOM    827  OE1 GLU A 107       4.902  36.328   8.650  1.00 63.99           O  
ATOM    828  OE2 GLU A 107       3.334  34.827   8.991  1.00 58.79           O  
ATOM    829  N   LEU A 108       3.830  37.092  13.840  1.00 37.63           N  
ATOM    830  CA  LEU A 108       3.978  38.049  14.932  1.00 36.00           C  
ATOM    831  C   LEU A 108       3.395  37.550  16.258  1.00 34.10           C  
ATOM    832  O   LEU A 108       3.658  38.135  17.300  1.00 32.16           O  
ATOM    833  CB  LEU A 108       3.334  39.379  14.551  1.00 34.24           C  
ATOM    834  CG  LEU A 108       4.088  40.103  13.441  1.00 35.02           C  
ATOM    835  CD1 LEU A 108       3.361  41.377  13.069  1.00 33.19           C  
ATOM    836  CD2 LEU A 108       5.515  40.416  13.857  1.00 37.84           C  
ATOM    837  N   GLN A 109       2.626  36.470  16.216  1.00 33.66           N  
ATOM    838  CA  GLN A 109       2.061  35.906  17.439  1.00 35.04           C  
ATOM    839  C   GLN A 109       3.127  35.456  18.443  1.00 35.62           C  
ATOM    840  O   GLN A 109       2.865  35.386  19.632  1.00 33.18           O  
ATOM    841  CB  GLN A 109       1.150  34.748  17.115  1.00 34.78           C  
ATOM    842  CG  GLN A 109       0.329  34.345  18.298  1.00 42.89           C  
ATOM    843  CD  GLN A 109      -0.560  33.175  18.016  1.00 45.43           C  
ATOM    844  OE1 GLN A 109      -1.238  33.129  16.987  1.00 48.92           O  
ATOM    845  NE2 GLN A 109      -0.575  32.219  18.936  1.00 53.04           N  
ATOM    846  N   THR A 110       4.341  35.196  17.962  1.00 36.90           N  
ATOM    847  CA  THR A 110       5.478  34.936  18.837  1.00 35.49           C  
ATOM    848  C   THR A 110       5.702  36.037  19.864  1.00 33.61           C  
ATOM    849  O   THR A 110       6.016  35.745  21.017  1.00 32.50           O  
ATOM    850  CB  THR A 110       6.783  34.791  18.031  1.00 35.05           C  
ATOM    851  OG1 THR A 110       6.682  33.654  17.175  1.00 39.10           O  
ATOM    852  CG2 THR A 110       7.988  34.617  18.966  1.00 36.92           C  
ATOM    853  N   TRP A 111       5.602  37.294  19.441  1.00 32.30           N  
ATOM    854  CA  TRP A 111       5.838  38.412  20.357  1.00 33.00           C  
ATOM    855  C   TRP A 111       4.533  39.050  20.807  1.00 29.96           C  
ATOM    856  O   TRP A 111       4.551  39.842  21.751  1.00 29.52           O  
ATOM    857  CB  TRP A 111       6.772  39.462  19.728  1.00 36.44           C  
ATOM    858  CG  TRP A 111       8.045  38.837  19.319  1.00 40.66           C  
ATOM    859  CD1 TRP A 111       9.120  38.558  20.115  1.00 44.13           C  
ATOM    860  CD2 TRP A 111       8.350  38.315  18.031  1.00 38.95           C  
ATOM    861  NE1 TRP A 111      10.088  37.909  19.387  1.00 43.78           N  
ATOM    862  CE2 TRP A 111       9.640  37.749  18.103  1.00 41.57           C  
ATOM    863  CE3 TRP A 111       7.666  38.283  16.812  1.00 44.19           C  
ATOM    864  CZ2 TRP A 111      10.254  37.154  17.004  1.00 44.61           C  
ATOM    865  CZ3 TRP A 111       8.287  37.697  15.713  1.00 44.45           C  
ATOM    866  CH2 TRP A 111       9.564  37.142  15.817  1.00 44.30           C  
ATOM    867  N   PHE A 112       3.436  38.689  20.130  1.00 27.73           N  
ATOM    868  CA  PHE A 112       2.068  39.201  20.393  1.00 27.37           C  
ATOM    869  C   PHE A 112       1.066  38.041  20.467  1.00 25.92           C  
ATOM    870  O   PHE A 112       0.280  37.800  19.540  1.00 26.69           O  
ATOM    871  CB  PHE A 112       1.665  40.229  19.319  1.00 28.25           C  
ATOM    872  CG  PHE A 112       2.602  41.385  19.227  1.00 28.05           C  
ATOM    873  CD1 PHE A 112       2.467  42.474  20.071  1.00 23.23           C  
ATOM    874  CD2 PHE A 112       3.657  41.387  18.322  1.00 31.62           C  
ATOM    875  CE1 PHE A 112       3.354  43.538  20.012  1.00 29.98           C  
ATOM    876  CE2 PHE A 112       4.533  42.446  18.261  1.00 28.30           C  
ATOM    877  CZ  PHE A 112       4.391  43.518  19.104  1.00 31.89           C  
ATOM    878  N   PRO A 113       1.088  37.296  21.578  1.00 24.56           N  
ATOM    879  CA  PRO A 113       0.285  36.060  21.689  1.00 24.47           C  
ATOM    880  C   PRO A 113      -1.217  36.195  21.435  1.00 26.42           C  
ATOM    881  O   PRO A 113      -1.788  35.304  20.819  1.00 26.61           O  
ATOM    882  CB  PRO A 113       0.556  35.597  23.127  1.00 25.33           C  
ATOM    883  CG  PRO A 113       1.889  36.173  23.431  1.00 26.31           C  
ATOM    884  CD  PRO A 113       1.897  37.514  22.782  1.00 23.15           C  
ATOM    885  N   LYS A 114      -1.864  37.261  21.902  1.00 25.57           N  
ATOM    886  CA  LYS A 114      -3.295  37.441  21.627  1.00 26.94           C  
ATOM    887  C   LYS A 114      -3.512  38.157  20.291  1.00 24.86           C  
ATOM    888  O   LYS A 114      -4.634  38.557  19.962  1.00 23.60           O  
ATOM    889  CB  LYS A 114      -3.993  38.242  22.730  1.00 26.27           C  
ATOM    890  CG  LYS A 114      -3.861  37.682  24.131  1.00 29.80           C  
ATOM    891  CD  LYS A 114      -4.783  38.456  25.093  1.00 34.51           C  
ATOM    892  CE  LYS A 114      -4.324  38.375  26.577  1.00 45.49           C  
ATOM    893  NZ  LYS A 114      -4.583  39.657  27.370  1.00 39.73           N  
ATOM    894  N   GLY A 115      -2.444  38.321  19.518  1.00 25.12           N  
ATOM    895  CA  GLY A 115      -2.551  39.023  18.255  1.00 24.82           C  
ATOM    896  C   GLY A 115      -3.153  40.393  18.411  1.00 24.64           C  
ATOM    897  O   GLY A 115      -2.756  41.166  19.285  1.00 21.36           O  
ATOM    898  N   LEU A 116      -4.099  40.711  17.544  1.00 24.50           N  
ATOM    899  CA  LEU A 116      -4.683  42.041  17.534  1.00 24.36           C  
ATOM    900  C   LEU A 116      -5.618  42.251  18.732  1.00 25.28           C  
ATOM    901  O   LEU A 116      -6.079  43.349  18.963  1.00 27.32           O  
ATOM    902  CB  LEU A 116      -5.415  42.287  16.213  1.00 26.69           C  
ATOM    903  CG  LEU A 116      -4.487  42.351  14.970  1.00 29.65           C  
ATOM    904  CD1 LEU A 116      -5.304  42.640  13.729  1.00 36.89           C  
ATOM    905  CD2 LEU A 116      -3.430  43.374  15.126  1.00 32.44           C  
ATOM    906  N   ASP A 117      -5.907  41.191  19.482  1.00 24.95           N  
ATOM    907  CA  ASP A 117      -6.611  41.338  20.746  1.00 26.05           C  
ATOM    908  C   ASP A 117      -5.713  41.644  21.957  1.00 26.09           C  
ATOM    909  O   ASP A 117      -6.234  41.789  23.064  1.00 24.89           O  
ATOM    910  CB  ASP A 117      -7.430  40.082  21.033  1.00 24.85           C  
ATOM    911  CG  ASP A 117      -8.659  39.973  20.139  1.00 29.72           C  
ATOM    912  OD1 ASP A 117      -9.060  40.990  19.516  1.00 31.14           O  
ATOM    913  OD2 ASP A 117      -9.228  38.874  20.081  1.00 36.79           O  
ATOM    914  N   GLU A 118      -4.394  41.733  21.764  1.00 24.83           N  
ATOM    915  CA  GLU A 118      -3.494  42.230  22.822  1.00 22.56           C  
ATOM    916  C   GLU A 118      -3.989  43.622  23.237  1.00 23.44           C  
ATOM    917  O   GLU A 118      -4.158  44.474  22.387  1.00 23.19           O  
ATOM    918  CB  GLU A 118      -2.043  42.321  22.329  1.00 23.19           C  
ATOM    919  CG  GLU A 118      -1.277  40.997  22.315  1.00 24.31           C  
ATOM    920  CD  GLU A 118      -1.090  40.371  23.706  1.00 24.31           C  
ATOM    921  OE1 GLU A 118      -1.148  41.094  24.733  1.00 23.67           O  
ATOM    922  OE2 GLU A 118      -0.897  39.146  23.764  1.00 24.68           O  
ATOM    923  N   PRO A 119      -4.246  43.853  24.534  1.00 20.42           N  
ATOM    924  CA  PRO A 119      -4.767  45.160  24.943  1.00 19.98           C  
ATOM    925  C   PRO A 119      -3.839  46.317  24.670  1.00 18.81           C  
ATOM    926  O   PRO A 119      -4.295  47.436  24.485  1.00 21.65           O  
ATOM    927  CB  PRO A 119      -4.995  45.006  26.460  1.00 22.53           C  
ATOM    928  CG  PRO A 119      -4.194  43.824  26.857  1.00 21.75           C  
ATOM    929  CD  PRO A 119      -4.101  42.932  25.676  1.00 25.07           C  
ATOM    930  N   ASP A 120      -2.536  46.078  24.641  1.00 19.54           N  
ATOM    931  CA  ASP A 120      -1.602  47.164  24.516  1.00 19.03           C  
ATOM    932  C   ASP A 120      -0.869  47.228  23.172  1.00 19.98           C  
ATOM    933  O   ASP A 120       0.113  47.961  23.022  1.00 21.47           O  
ATOM    934  CB  ASP A 120      -0.591  47.076  25.657  1.00 19.04           C  
ATOM    935  CG  ASP A 120       0.058  48.413  25.941  1.00 22.56           C  
ATOM    936  OD1 ASP A 120      -0.706  49.400  25.948  1.00 24.44           O  
ATOM    937  OD2 ASP A 120       1.281  48.451  26.191  1.00 19.27           O  
ATOM    938  N   ILE A 121      -1.312  46.451  22.201  1.00 20.86           N  
ATOM    939  CA  ILE A 121      -0.590  46.386  20.944  1.00 21.61           C  
ATOM    940  C   ILE A 121      -0.869  47.670  20.130  1.00 20.36           C  
ATOM    941  O   ILE A 121      -1.994  48.175  20.123  1.00 20.26           O  
ATOM    942  CB  ILE A 121      -0.962  45.121  20.130  1.00 20.48           C  
ATOM    943  CG1 ILE A 121       0.017  44.954  18.946  1.00 23.27           C  
ATOM    944  CG2 ILE A 121      -2.425  45.152  19.686  1.00 22.19           C  
ATOM    945  CD1 ILE A 121      -0.207  43.633  18.138  1.00 23.34           C  
ATOM    946  N   ALA A 122       0.148  48.162  19.451  1.00 20.86           N  
ATOM    947  CA  ALA A 122       0.074  49.347  18.625  1.00 21.02           C  
ATOM    948  C   ALA A 122       1.142  49.233  17.519  1.00 23.57           C  
ATOM    949  O   ALA A 122       1.762  48.168  17.341  1.00 22.21           O  
ATOM    950  CB  ALA A 122       0.282  50.641  19.458  1.00 22.09           C  
ATOM    951  N   LEU A 123       1.270  50.304  16.741  1.00 22.73           N  
ATOM    952  CA  LEU A 123       2.244  50.382  15.656  1.00 23.84           C  
ATOM    953  C   LEU A 123       3.220  51.523  15.864  1.00 25.35           C  
ATOM    954  O   LEU A 123       2.891  52.576  16.444  1.00 24.25           O  
ATOM    955  CB  LEU A 123       1.556  50.569  14.284  1.00 25.19           C  
ATOM    956  CG  LEU A 123       0.785  49.415  13.656  1.00 24.65           C  
ATOM    957  CD1 LEU A 123      -0.202  49.968  12.579  1.00 25.59           C  
ATOM    958  CD2 LEU A 123       1.681  48.313  13.084  1.00 24.75           C  
ATOM    959  N   LEU A 124       4.450  51.287  15.412  1.00 25.15           N  
ATOM    960  CA  LEU A 124       5.404  52.352  15.165  1.00 26.22           C  
ATOM    961  C   LEU A 124       5.539  52.546  13.663  1.00 24.25           C  
ATOM    962  O   LEU A 124       5.858  51.603  12.903  1.00 26.58           O  
ATOM    963  CB  LEU A 124       6.762  52.006  15.746  1.00 27.28           C  
ATOM    964  CG  LEU A 124       6.862  52.011  17.262  1.00 26.20           C  
ATOM    965  CD1 LEU A 124       8.255  51.483  17.691  1.00 26.37           C  
ATOM    966  CD2 LEU A 124       6.581  53.371  17.854  1.00 31.95           C  
ATOM    967  N   LYS A 125       5.301  53.770  13.241  1.00 24.88           N  
ATOM    968  CA  LYS A 125       5.494  54.164  11.860  1.00 25.33           C  
ATOM    969  C   LYS A 125       6.835  54.864  11.798  1.00 28.27           C  
ATOM    970  O   LYS A 125       7.097  55.737  12.628  1.00 29.35           O  
ATOM    971  CB  LYS A 125       4.424  55.138  11.433  1.00 25.46           C  
ATOM    972  CG  LYS A 125       4.509  55.513   9.960  1.00 28.19           C  
ATOM    973  CD  LYS A 125       3.530  56.594   9.634  1.00 31.45           C  
ATOM    974  CE  LYS A 125       3.565  56.953   8.162  1.00 37.74           C  
ATOM    975  NZ  LYS A 125       2.547  57.989   7.864  1.00 42.49           N  
ATOM    976  N   VAL A 126       7.678  54.473  10.854  1.00 22.71           N  
ATOM    977  CA  VAL A 126       8.972  55.158  10.645  1.00 20.82           C  
ATOM    978  C   VAL A 126       8.929  55.841   9.271  1.00 22.74           C  
ATOM    979  O   VAL A 126       8.843  55.182   8.254  1.00 23.24           O  
ATOM    980  CB  VAL A 126      10.173  54.238  10.746  1.00 22.49           C  
ATOM    981  CG1 VAL A 126      11.469  55.052  10.541  1.00 20.99           C  
ATOM    982  CG2 VAL A 126      10.218  53.535  12.122  1.00 23.13           C  
ATOM    983  N   ASN A 127       8.921  57.178   9.291  1.00 22.58           N  
ATOM    984  CA  ASN A 127       9.075  58.006   8.097  1.00 22.78           C  
ATOM    985  C   ASN A 127      10.542  58.096   7.722  1.00 20.59           C  
ATOM    986  O   ASN A 127      11.339  58.624   8.466  1.00 22.93           O  
ATOM    987  CB  ASN A 127       8.560  59.420   8.312  1.00 24.37           C  
ATOM    988  CG  ASN A 127       7.096  59.543   7.987  1.00 42.95           C  
ATOM    989  OD1 ASN A 127       6.275  58.982   8.669  1.00 37.60           O  
ATOM    990  ND2 ASN A 127       6.775  60.237   6.894  1.00 54.67           N  
ATOM    991  N   ILE A 128      10.899  57.576   6.556  1.00 21.29           N  
ATOM    992  CA  ILE A 128      12.291  57.455   6.201  1.00 20.33           C  
ATOM    993  C   ILE A 128      12.831  58.769   5.668  1.00 23.08           C  
ATOM    994  O   ILE A 128      12.223  59.385   4.795  1.00 21.64           O  
ATOM    995  CB  ILE A 128      12.487  56.354   5.149  1.00 19.71           C  
ATOM    996  CG1 ILE A 128      12.051  55.005   5.710  1.00 22.47           C  
ATOM    997  CG2 ILE A 128      13.973  56.274   4.709  1.00 22.92           C  
ATOM    998  CD1 ILE A 128      12.124  53.858   4.704  1.00 22.95           C  
ATOM    999  N   ASN A 129      13.975  59.190   6.183  1.00 21.22           N  
ATOM   1000  CA  ASN A 129      14.608  60.400   5.716  1.00 22.64           C  
ATOM   1001  C   ASN A 129      15.799  60.079   4.808  1.00 23.82           C  
ATOM   1002  O   ASN A 129      16.052  60.745   3.803  1.00 23.67           O  
ATOM   1003  CB  ASN A 129      15.080  61.248   6.916  1.00 24.67           C  
ATOM   1004  CG  ASN A 129      13.974  61.586   7.893  1.00 24.14           C  
ATOM   1005  OD1 ASN A 129      14.162  61.440   9.093  1.00 27.69           O  
ATOM   1006  ND2 ASN A 129      12.822  62.041   7.396  1.00 22.87           N  
ATOM   1007  N   GLN A 130      16.597  59.117   5.229  1.00 22.67           N  
ATOM   1008  CA  GLN A 130      17.823  58.769   4.506  1.00 24.82           C  
ATOM   1009  C   GLN A 130      18.125  57.304   4.638  1.00 25.02           C  
ATOM   1010  O   GLN A 130      17.905  56.685   5.702  1.00 24.72           O  
ATOM   1011  CB  GLN A 130      18.984  59.582   5.083  1.00 24.75           C  
ATOM   1012  CG  GLN A 130      20.280  59.518   4.309  1.00 35.25           C  
ATOM   1013  CD  GLN A 130      21.414  60.272   5.011  1.00 37.12           C  
ATOM   1014  OE1 GLN A 130      22.443  59.686   5.393  1.00 50.78           O  
ATOM   1015  NE2 GLN A 130      21.222  61.558   5.196  1.00 36.22           N  
ATOM   1016  N   VAL A 131      18.607  56.717   3.557  1.00 21.46           N  
ATOM   1017  CA  VAL A 131      19.053  55.342   3.557  1.00 21.81           C  
ATOM   1018  C   VAL A 131      20.518  55.351   3.094  1.00 24.58           C  
ATOM   1019  O   VAL A 131      20.852  55.903   2.049  1.00 23.89           O  
ATOM   1020  CB  VAL A 131      18.252  54.459   2.606  1.00 23.54           C  
ATOM   1021  CG1 VAL A 131      18.763  53.004   2.663  1.00 22.33           C  
ATOM   1022  CG2 VAL A 131      16.762  54.473   2.970  1.00 24.31           C  
ATOM   1023  N   ASN A 132      21.386  54.759   3.902  1.00 22.11           N  
ATOM   1024  CA  ASN A 132      22.760  54.540   3.517  1.00 23.66           C  
ATOM   1025  C   ASN A 132      22.950  53.067   3.431  1.00 25.82           C  
ATOM   1026  O   ASN A 132      22.539  52.342   4.331  1.00 23.80           O  
ATOM   1027  CB  ASN A 132      23.668  55.163   4.546  1.00 24.96           C  
ATOM   1028  CG  ASN A 132      23.495  56.658   4.598  1.00 33.61           C  
ATOM   1029  OD1 ASN A 132      23.835  57.348   3.650  1.00 36.06           O  
ATOM   1030  ND2 ASN A 132      22.935  57.164   5.678  1.00 38.40           N  
ATOM   1031  N   TYR A 133      23.534  52.605   2.340  1.00 23.85           N  
ATOM   1032  CA  TYR A 133      23.750  51.159   2.199  1.00 24.31           C  
ATOM   1033  C   TYR A 133      25.100  50.806   1.594  1.00 24.98           C  
ATOM   1034  O   TYR A 133      25.745  51.622   0.918  1.00 24.39           O  
ATOM   1035  CB  TYR A 133      22.604  50.519   1.438  1.00 24.94           C  
ATOM   1036  CG  TYR A 133      22.500  50.951   0.004  1.00 26.37           C  
ATOM   1037  CD1 TYR A 133      21.782  52.088  -0.350  1.00 31.16           C  
ATOM   1038  CD2 TYR A 133      23.129  50.236  -1.003  1.00 32.56           C  
ATOM   1039  CE1 TYR A 133      21.679  52.471  -1.683  1.00 31.98           C  
ATOM   1040  CE2 TYR A 133      23.056  50.631  -2.311  1.00 38.07           C  
ATOM   1041  CZ  TYR A 133      22.325  51.734  -2.651  1.00 36.90           C  
ATOM   1042  OH  TYR A 133      22.287  52.107  -3.994  1.00 43.12           O  
ATOM   1043  N   TRP A 134      25.538  49.600   1.930  1.00 24.27           N  
ATOM   1044  CA  TRP A 134      26.782  49.039   1.480  1.00 23.21           C  
ATOM   1045  C   TRP A 134      26.410  47.672   0.946  1.00 24.81           C  
ATOM   1046  O   TRP A 134      25.886  46.860   1.671  1.00 25.59           O  
ATOM   1047  CB  TRP A 134      27.777  48.901   2.637  1.00 24.86           C  
ATOM   1048  CG  TRP A 134      28.204  50.177   3.301  1.00 24.17           C  
ATOM   1049  CD1 TRP A 134      29.407  50.824   3.155  1.00 30.07           C  
ATOM   1050  CD2 TRP A 134      27.447  50.966   4.232  1.00 23.04           C  
ATOM   1051  NE1 TRP A 134      29.435  51.960   3.944  1.00 27.99           N  
ATOM   1052  CE2 TRP A 134      28.246  52.067   4.603  1.00 25.96           C  
ATOM   1053  CE3 TRP A 134      26.182  50.832   4.809  1.00 23.68           C  
ATOM   1054  CZ2 TRP A 134      27.806  53.036   5.517  1.00 23.45           C  
ATOM   1055  CZ3 TRP A 134      25.743  51.823   5.704  1.00 26.52           C  
ATOM   1056  CH2 TRP A 134      26.560  52.891   6.034  1.00 24.50           C  
ATOM   1057  N   ASP A 135      26.659  47.438  -0.333  1.00 24.48           N  
ATOM   1058  CA  ASP A 135      26.352  46.134  -0.906  1.00 26.66           C  
ATOM   1059  C   ASP A 135      27.224  45.700  -2.061  1.00 27.61           C  
ATOM   1060  O   ASP A 135      28.061  46.445  -2.562  1.00 30.00           O  
ATOM   1061  CB  ASP A 135      24.857  46.069  -1.276  1.00 26.26           C  
ATOM   1062  CG  ASP A 135      24.492  46.880  -2.526  1.00 35.75           C  
ATOM   1063  OD1 ASP A 135      25.376  47.496  -3.157  1.00 37.56           O  
ATOM   1064  OD2 ASP A 135      23.276  46.901  -2.863  1.00 37.94           O  
ATOM   1065  N   SER A 136      27.039  44.466  -2.502  1.00 30.71           N  
ATOM   1066  CA  SER A 136      27.878  43.963  -3.601  1.00 35.91           C  
ATOM   1067  C   SER A 136      27.781  44.858  -4.862  1.00 35.36           C  
ATOM   1068  O   SER A 136      28.779  45.050  -5.541  1.00 35.00           O  
ATOM   1069  CB  SER A 136      27.511  42.517  -3.926  1.00 34.50           C  
ATOM   1070  OG  SER A 136      26.204  42.479  -4.462  1.00 45.38           O  
ATOM   1071  N   THR A 137      26.599  45.404  -5.165  1.00 37.24           N  
ATOM   1072  CA  THR A 137      26.445  46.368  -6.293  1.00 40.00           C  
ATOM   1073  C   THR A 137      27.333  47.613  -6.144  1.00 41.16           C  
ATOM   1074  O   THR A 137      27.881  48.108  -7.120  1.00 47.07           O  
ATOM   1075  CB  THR A 137      24.953  46.836  -6.546  1.00 41.53           C  
ATOM   1076  OG1 THR A 137      24.565  47.909  -5.631  1.00 44.38           O  
ATOM   1077  CG2 THR A 137      23.991  45.640  -6.469  1.00 43.87           C  
ATOM   1078  N   SER A 138      27.487  48.096  -4.922  1.00 40.77           N  
ATOM   1079  CA  SER A 138      28.270  49.288  -4.649  1.00 41.60           C  
ATOM   1080  C   SER A 138      29.741  48.966  -4.404  1.00 39.40           C  
ATOM   1081  O   SER A 138      30.489  49.834  -3.965  1.00 39.78           O  
ATOM   1082  CB  SER A 138      27.689  50.048  -3.421  1.00 43.98           C  
ATOM   1083  OG  SER A 138      28.098  49.549  -2.122  1.00 34.98           O  
ATOM   1084  N   SER A 139      30.150  47.721  -4.647  1.00 36.36           N  
ATOM   1085  CA  SER A 139      31.456  47.239  -4.184  1.00 35.18           C  
ATOM   1086  C   SER A 139      31.701  47.571  -2.706  1.00 35.89           C  
ATOM   1087  O   SER A 139      32.828  47.834  -2.294  1.00 33.69           O  
ATOM   1088  CB  SER A 139      32.553  47.824  -5.072  1.00 37.41           C  
ATOM   1089  OG  SER A 139      32.274  47.501  -6.430  1.00 36.61           O  
ATOM   1090  N   PHE A 140      30.623  47.553  -1.922  1.00 35.41           N  
ATOM   1091  CA  PHE A 140      30.632  47.849  -0.475  1.00 36.81           C  
ATOM   1092  C   PHE A 140      31.147  49.214  -0.070  1.00 38.35           C  
ATOM   1093  O   PHE A 140      31.577  49.402   1.067  1.00 40.69           O  
ATOM   1094  CB  PHE A 140      31.391  46.767   0.292  1.00 37.34           C  
ATOM   1095  CG  PHE A 140      30.791  45.430   0.135  1.00 41.07           C  
ATOM   1096  CD1 PHE A 140      29.621  45.111   0.796  1.00 41.27           C  
ATOM   1097  CD2 PHE A 140      31.359  44.503  -0.722  1.00 42.37           C  
ATOM   1098  CE1 PHE A 140      29.050  43.875   0.635  1.00 44.62           C  
ATOM   1099  CE2 PHE A 140      30.795  43.271  -0.890  1.00 45.92           C  
ATOM   1100  CZ  PHE A 140      29.636  42.953  -0.214  1.00 45.28           C  
ATOM   1101  N   LYS A 141      31.084  50.159  -0.995  1.00 37.73           N  
ATOM   1102  CA  LYS A 141      31.346  51.560  -0.699  1.00 38.25           C  
ATOM   1103  C   LYS A 141      29.986  52.212  -0.434  1.00 36.43           C  
ATOM   1104  O   LYS A 141      28.991  51.828  -1.052  1.00 36.86           O  
ATOM   1105  CB  LYS A 141      32.046  52.253  -1.866  1.00 38.22           C  
ATOM   1106  CG  LYS A 141      33.460  51.708  -2.140  1.00 37.07           C  
ATOM   1107  N   PRO A 142      29.954  53.218   0.447  1.00 35.83           N  
ATOM   1108  CA  PRO A 142      28.676  53.756   0.976  1.00 32.67           C  
ATOM   1109  C   PRO A 142      27.819  54.457  -0.108  1.00 32.09           C  
ATOM   1110  O   PRO A 142      28.353  55.292  -0.841  1.00 37.44           O  
ATOM   1111  CB  PRO A 142      29.140  54.752   2.053  1.00 33.36           C  
ATOM   1112  CG  PRO A 142      30.564  55.129   1.656  1.00 39.34           C  
ATOM   1113  CD  PRO A 142      31.135  53.918   0.986  1.00 37.79           C  
ATOM   1114  N   GLN A 143      26.557  54.055  -0.265  1.00 25.50           N  
ATOM   1115  CA  GLN A 143      25.633  54.670  -1.225  1.00 27.18           C  
ATOM   1116  C   GLN A 143      24.533  55.329  -0.427  1.00 29.71           C  
ATOM   1117  O   GLN A 143      24.262  54.897   0.691  1.00 27.06           O  
ATOM   1118  CB  GLN A 143      25.005  53.624  -2.123  1.00 30.17           C  
ATOM   1119  CG  GLN A 143      25.975  52.876  -2.961  1.00 41.37           C  
ATOM   1120  CD  GLN A 143      26.472  53.717  -4.084  1.00 47.08           C  
ATOM   1121  OE1 GLN A 143      27.448  54.457  -3.943  1.00 58.83           O  
ATOM   1122  NE2 GLN A 143      25.789  53.633  -5.215  1.00 59.11           N  
ATOM   1123  N   THR A 144      23.912  56.389  -0.949  1.00 28.06           N  
ATOM   1124  CA  THR A 144      22.884  57.091  -0.184  1.00 26.25           C  
ATOM   1125  C   THR A 144      21.643  57.407  -1.000  1.00 30.17           C  
ATOM   1126  O   THR A 144      21.734  57.755  -2.194  1.00 29.16           O  
ATOM   1127  CB  THR A 144      23.463  58.390   0.454  1.00 32.42           C  
ATOM   1128  OG1 THR A 144      24.672  58.078   1.142  1.00 40.63           O  
ATOM   1129  CG2 THR A 144      22.522  58.995   1.465  1.00 32.97           C  
ATOM   1130  N   ILE A 145      20.482  57.265  -0.365  1.00 26.37           N  
ATOM   1131  CA  ILE A 145      19.178  57.661  -0.939  1.00 27.59           C  
ATOM   1132  C   ILE A 145      18.607  58.635   0.074  1.00 26.69           C  
ATOM   1133  O   ILE A 145      18.648  58.318   1.251  1.00 24.89           O  
ATOM   1134  CB  ILE A 145      18.209  56.486  -1.059  1.00 27.05           C  
ATOM   1135  CG1 ILE A 145      18.696  55.447  -2.062  1.00 35.83           C  
ATOM   1136  CG2 ILE A 145      16.822  56.949  -1.481  1.00 32.40           C  
ATOM   1137  CD1 ILE A 145      17.949  54.101  -1.906  1.00 33.29           C  
ATOM   1138  N   SER A 146      18.124  59.797  -0.367  1.00 26.35           N  
ATOM   1139  CA  SER A 146      17.510  60.774   0.521  1.00 27.01           C  
ATOM   1140  C   SER A 146      16.098  61.107   0.080  1.00 29.20           C  
ATOM   1141  O   SER A 146      15.850  61.291  -1.106  1.00 26.81           O  
ATOM   1142  CB  SER A 146      18.342  62.057   0.594  1.00 32.93           C  
ATOM   1143  OG  SER A 146      19.394  61.900   1.508  1.00 44.55           O  
ATOM   1144  N   PHE A 147      15.188  61.172   1.040  1.00 24.18           N  
ATOM   1145  CA  PHE A 147      13.833  61.575   0.805  1.00 25.05           C  
ATOM   1146  C   PHE A 147      13.610  62.927   1.513  1.00 31.94           C  
ATOM   1147  O   PHE A 147      14.254  63.138   2.569  1.00 33.62           O  
ATOM   1148  CB  PHE A 147      12.866  60.540   1.340  1.00 26.66           C  
ATOM   1149  CG  PHE A 147      12.991  59.199   0.683  1.00 27.29           C  
ATOM   1150  CD1 PHE A 147      12.639  59.040  -0.644  1.00 29.97           C  
ATOM   1151  CD2 PHE A 147      13.497  58.125   1.368  1.00 26.31           C  
ATOM   1152  CE1 PHE A 147      12.794  57.797  -1.284  1.00 29.64           C  
ATOM   1153  CE2 PHE A 147      13.653  56.881   0.732  1.00 35.29           C  
ATOM   1154  CZ  PHE A 147      13.296  56.731  -0.587  1.00 29.71           C  
ATOM   1155  OXT PHE A 147      12.820  63.785   1.048  1.00 29.67           O  
TER    1156      PHE A 147                                                      
END
MOLECULE T0506_25_173.pdb
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
END
