
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  231 ( 1804),  selected  231 , name 1wr8_B
# Molecule2: number of CA atoms  275 ( 2161),  selected  275 , name T0505.pdb
# PARAMETERS: 1wr8_B.T0505.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_B      -       -           -
LGA    K     2_B      -       -           -
LGA    I     3_B      K       6          0.644
LGA    K     4_B      Q       7          0.916
LGA    A     5_B      L       8          1.654
LGA    I     6_B      L       9          0.741
LGA    S     7_B      A      10          0.760
LGA    I     8_B      L      11          0.876
LGA    D     9_B      N      12          0.751
LGA    I    10_B      I      13          0.681
LGA    D    11_B      D      14          0.545
LGA    G    12_B      G      15          0.639
LGA    T    13_B      A      16          0.384
LGA    I    14_B      L      17          1.188
LGA    T    15_B      L      18          1.058
LGA    Y    16_B      R      19          1.154
LGA    P    17_B      S      20          1.331
LGA    N    18_B      N      21          2.962
LGA    R    19_B      G      22          2.827
LGA    M    20_B      K      23          2.823
LGA    I    21_B      I      24          2.061
LGA    H    22_B      H      25          2.628
LGA    E    23_B      Q      26          2.604
LGA    K    24_B      A      27          2.149
LGA    A    25_B      T      28          1.549
LGA    L    26_B      K      29          2.039
LGA    E    27_B      D      30          2.009
LGA    A    28_B      A      31          1.218
LGA    I    29_B      I      32          1.093
LGA    R    30_B      E      33          1.760
LGA    R    31_B      Y      34          1.943
LGA    A    32_B      V      35          1.424
LGA    E    33_B      K      36          1.483
LGA    S    34_B      K      37          2.126
LGA    L    35_B      K      38          2.246
LGA    G    36_B      G      39          1.991
LGA    I    37_B      I      40          1.638
LGA    P    38_B      Y      41          1.999
LGA    I    39_B      V      42          0.931
LGA    M    40_B      T      43          0.879
LGA    L    41_B      L      44          0.843
LGA    V    42_B      V      45          0.975
LGA    T    43_B      T      46          0.431
LGA    G    44_B      N      47          0.570
LGA    N    45_B      R      48          0.837
LGA    T    46_B      H      49          1.051
LGA    V    47_B      F      50          1.724
LGA    Q    48_B      R      51          1.840
LGA    F    49_B      S      52          1.700
LGA    A    50_B      A      53          1.512
LGA    E    51_B      Q      54          1.512
LGA    A    52_B      K      55          1.574
LGA    A    53_B      I      56          1.334
LGA    S    54_B      A      57          0.794
LGA    I    55_B      K      58          0.830
LGA    L    56_B      S      59          1.512
LGA    I    57_B      L      60          1.811
LGA    G    58_B      K      61          1.605
LGA    T    59_B      L      62          1.670
LGA    S    60_B      D      63          3.347
LGA    G    61_B      A      64          2.927
LGA    P    62_B      K      65          1.793
LGA    V    63_B      L      66          0.953
LGA    V    64_B      I      67          0.820
LGA    A    65_B      T      68          0.849
LGA    E    66_B      H      69          1.402
LGA    D    67_B      S      70          1.533
LGA    G    68_B      G      71          1.545
LGA    G    69_B      A      72          1.628
LGA    A    70_B      Y      73          1.473
LGA    I    71_B      I      74          0.835
LGA    S    72_B      A      75          1.051
LGA    Y    73_B      E      76          2.902
LGA    K    74_B      K      77          5.814
LGA    K    75_B      I      78          5.982
LGA    -       -      D      79           -
LGA    K    76_B      A      80          3.580
LGA    R    77_B      P      81          1.279
LGA    I    78_B      F      82          3.077
LGA    F    79_B      F      83          3.457
LGA    L    80_B      E      84          4.259
LGA    A    81_B      K      85          2.281
LGA    S    82_B      R      86          1.975
LGA    M    83_B      I      87          0.390
LGA    D    84_B      S      88          2.800
LGA    -       -      D      89           -
LGA    -       -      D      90           -
LGA    E    85_B      H      91          3.148
LGA    E    86_B      T      92          3.814
LGA    W    87_B      F      93          3.079
LGA    I    88_B      N      94          1.573
LGA    L    89_B      I      95          1.375
LGA    W    90_B      V      96          1.066
LGA    N    91_B      Q      97          1.759
LGA    E    92_B      V      98          2.135
LGA    I    93_B      L      99          2.203
LGA    R    94_B      E     100          2.540
LGA    K    95_B      -       -           -
LGA    R    96_B      S     101          2.066
LGA    F    97_B      Y     102          3.929
LGA    P    98_B      -       -           -
LGA    N    99_B      Q     103          5.843
LGA    A   100_B      C     104          3.521
LGA    R   101_B      N     105          3.033
LGA    T   102_B      I     106          2.165
LGA    S   103_B      R     107          2.514
LGA    Y   104_B      L     108           #
LGA    T   105_B      -       -           -
LGA    M   106_B      -       -           -
LGA    P   107_B      L     109          5.435
LGA    D   108_B      H     110          2.247
LGA    R   109_B      E     111          4.174
LGA    R   110_B      K     112           -
LGA    -       -      Y     113           -
LGA    -       -      S     114           -
LGA    -       -      I     115           -
LGA    -       -      G     116           -
LGA    -       -      N     117           -
LGA    -       -      K     118           -
LGA    -       -      K     119           -
LGA    -       -      K     120           -
LGA    -       -      V     121           -
LGA    -       -      N     122           -
LGA    -       -      S     123           -
LGA    -       -      N     124           -
LGA    -       -      L     125           -
LGA    -       -      L     126           -
LGA    -       -      G     127           -
LGA    -       -      K     128           -
LGA    -       -      A     129           -
LGA    -       -      L     130           -
LGA    -       -      I     131           -
LGA    -       -      H     132           -
LGA    -       -      P     133           -
LGA    -       -      S     134           -
LGA    -       -      D     135           -
LGA    -       -      P     136           -
LGA    -       -      I     137           -
LGA    -       -      F     138           -
LGA    -       -      Y     139           -
LGA    -       -      P     140           -
LGA    -       -      V     141           -
LGA    -       -      Q     142           -
LGA    -       -      F     143           -
LGA    -       -      V     144           -
LGA    -       -      E     145           -
LGA    -       -      S     146           -
LGA    -       -      L     147           -
LGA    -       -      S     148           -
LGA    -       -      D     149           -
LGA    -       -      L     150           -
LGA    -       -      L     151           -
LGA    -       -      M     152           -
LGA    -       -      D     153           -
LGA    -       -      E     154           -
LGA    -       -      P     155           -
LGA    -       -      V     156           -
LGA    -       -      S     157           -
LGA    -       -      A     158           -
LGA    A   111_B      P     159          2.503
LGA    G   112_B      V     160          1.738
LGA    L   113_B      I     161          0.916
LGA    V   114_B      E     162          1.253
LGA    I   115_B      V     163          2.116
LGA    M   116_B      Y     164          3.189
LGA    R   117_B      -       -           -
LGA    E   118_B      -       -           -
LGA    T   119_B      -       -           -
LGA    I   120_B      T     165          3.335
LGA    N   121_B      E     166          4.254
LGA    -       -      H     167           -
LGA    -       -      D     168           -
LGA    -       -      I     169           -
LGA    V   122_B      Q     170          2.336
LGA    E   123_B      H     171          3.044
LGA    T   124_B      D     172          4.069
LGA    V   125_B      I     173          2.076
LGA    R   126_B      T     174          1.827
LGA    E   127_B      E     175          4.041
LGA    I   128_B      T     176          2.799
LGA    I   129_B      I     177          1.280
LGA    N   130_B      T     178          4.852
LGA    E   131_B      K     179          5.490
LGA    L   132_B      A     180          2.835
LGA    N   133_B      F     181           #
LGA    L   134_B      P     182          3.760
LGA    N   135_B      A     183          4.430
LGA    L   136_B      V     184          3.326
LGA    V   137_B      D     185          3.366
LGA    A   138_B      V     186          2.771
LGA    V   139_B      I     187          3.095
LGA    D   140_B      R     188          3.666
LGA    S   141_B      V     189          2.237
LGA    G   142_B      N     190          3.124
LGA    -       -      D     191           -
LGA    F   143_B      E     192           #
LGA    A   144_B      K     193          3.250
LGA    I   145_B      L     194          2.279
LGA    H   146_B      N     195          0.728
LGA    V   147_B      I     196          0.972
LGA    K   148_B      V     197          1.749
LGA    K   149_B      P     198          3.486
LGA    P   150_B      K     199          4.457
LGA    W   151_B      G     200          1.960
LGA    I   152_B      V     201          1.581
LGA    N   153_B      S     202          1.421
LGA    K   154_B      K     203          1.269
LGA    G   155_B      E     204          1.069
LGA    S   156_B      A     205          0.808
LGA    G   157_B      G     206          0.656
LGA    I   158_B      L     207          0.548
LGA    E   159_B      A     208          0.942
LGA    K   160_B      L     209          0.955
LGA    A   161_B      V     210          1.282
LGA    S   162_B      A     211          1.450
LGA    E   163_B      S     212          2.991
LGA    F   164_B      E     213          3.344
LGA    L   165_B      L     214          2.964
LGA    G   166_B      G     215          3.433
LGA    I   167_B      L     216          2.542
LGA    K   168_B      S     217          2.534
LGA    P   169_B      M     218          2.665
LGA    K   170_B      D     219          1.785
LGA    E   171_B      D     220          1.001
LGA    V   172_B      V     221          1.213
LGA    A   173_B      V     222          0.848
LGA    H   174_B      A     223          0.876
LGA    V   175_B      I     224          1.172
LGA    G   176_B      G     225          1.342
LGA    D   177_B      H     226          1.373
LGA    G   178_B      Q     227          1.648
LGA    E   179_B      Y     228          1.905
LGA    N   180_B      D     229          1.601
LGA    D   181_B      D     230          1.418
LGA    L   182_B      L     231          1.487
LGA    D   183_B      P     232          1.475
LGA    A   184_B      M     233          0.901
LGA    F   185_B      I     234          2.101
LGA    K   186_B      E     235          3.446
LGA    V   187_B      L     236          3.073
LGA    V   188_B      A     237          1.830
LGA    G   189_B      G     238          1.250
LGA    Y   190_B      L     239          1.252
LGA    K   191_B      G     240          1.459
LGA    V   192_B      V     241          1.398
LGA    A   193_B      A     242          1.383
LGA    V   194_B      M     243          1.483
LGA    A   195_B      G     244          1.208
LGA    Q   196_B      N     245          1.740
LGA    A   197_B      A     246          1.644
LGA    P   198_B      V     247          2.407
LGA    K   199_B      P     248          2.616
LGA    I   200_B      E     249          2.858
LGA    L   201_B      I     250          2.491
LGA    K   202_B      K     251          2.163
LGA    E   203_B      R     252          2.422
LGA    N   204_B      K     253          2.842
LGA    A   205_B      A     254          2.205
LGA    D   206_B      D     255          2.288
LGA    Y   207_B      W     256          1.637
LGA    V   208_B      V     257          1.118
LGA    T   209_B      T     258          1.348
LGA    K   210_B      R     259          3.663
LGA    K   211_B      S     260          4.101
LGA    E   212_B      N     261          4.165
LGA    Y   213_B      D     262          4.144
LGA    G   214_B      E     263           #
LGA    E   215_B      Q     264          0.542
LGA    G   216_B      G     265          0.642
LGA    G   217_B      V     266          1.329
LGA    A   218_B      A     267          1.265
LGA    E   219_B      Y     268          1.036
LGA    A   220_B      M     269          1.769
LGA    I   221_B      M     270          1.994
LGA    Y   222_B      K     271          1.822
LGA    H   223_B      E     272          2.246
LGA    I   224_B      Y     273          2.324
LGA    L   225_B      F     274          2.912
LGA    E   226_B      R     275          2.916
LGA    K   227_B      M     276          2.339
LGA    F   228_B      Q     277          3.295
LGA    G   229_B      -       -           -
LGA    Y   230_B      -       -           -
LGA    L   231_B      Q     278           #
LGA    -       -      R     279           -
LGA    -       -      K     280           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  231  275    5.0    214    2.37    18.22     54.483     8.664

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.183821 * X  +   0.971380 * Y  +   0.150437 * Z  + -16.950832
  Y_new =   0.980712 * X  +  -0.170894 * Y  +  -0.094868 * Z  +  -9.593873
  Z_new =  -0.066444 * X  +   0.164974 * Y  +  -0.984057 * Z  + 122.626976 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.975491   -0.166102  [ DEG:   170.4831     -9.5169 ]
  Theta =   0.066493    3.075100  [ DEG:     3.8098    176.1902 ]
  Phi   =   1.385510   -1.756082  [ DEG:    79.3839   -100.6161 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wr8_B                                        
REMARK     2: T0505.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wr8_B.T0505.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  231  275   5.0  214   2.37   18.22  54.483
REMARK  ---------------------------------------------------------- 
MOLECULE 1wr8_B
HEADER    HYDROLASE                               13-OCT-04   1WR8              
TITLE     CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN PH1421 FROM                 
TITLE    2 PYROCOCCUS HORIKOSHII.                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCOLATE PHOSPHATASE;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: PGP, HALOACID DEHALOGENASE-LIKE HYDROLASE;                  
COMPND   5 EC: 3.1.3.18;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: OT3;                                                         
SOURCE   5 GENE: PH1421;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET 11A                                   
KEYWDS    ALPHA / BETA CORE DOMAIN, HAD SUPERFAMILY, STRUCTURAL                 
KEYWDS   2 GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   3 RSGI                                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.YAMAMOTO,N.KUNISHIMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   2 INITIATIVE (RSGI)                                                    
REVDAT   1   26-OCT-04 1WR8    0                                                
JRNL        AUTH   H.YAMAMOTO,N.KUNISHIMA                                       
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN PH1421             
JRNL        TITL 2 FROM PYROCOCCUS HORIKOSHII.                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  1WR8 A    1   231  UNP    O50129   PGP_PYRHO        1    231             
DBREF  1WR8 B    1   231  UNP    O50129   PGP_PYRHO        1    231             
SEQRES   1 A  231  MET LYS ILE LYS ALA ILE SER ILE ASP ILE ASP GLY THR          
SEQRES   2 A  231  ILE THR TYR PRO ASN ARG MET ILE HIS GLU LYS ALA LEU          
SEQRES   3 A  231  GLU ALA ILE ARG ARG ALA GLU SER LEU GLY ILE PRO ILE          
SEQRES   4 A  231  MET LEU VAL THR GLY ASN THR VAL GLN PHE ALA GLU ALA          
SEQRES   5 A  231  ALA SER ILE LEU ILE GLY THR SER GLY PRO VAL VAL ALA          
SEQRES   6 A  231  GLU ASP GLY GLY ALA ILE SER TYR LYS LYS LYS ARG ILE          
SEQRES   7 A  231  PHE LEU ALA SER MET ASP GLU GLU TRP ILE LEU TRP ASN          
SEQRES   8 A  231  GLU ILE ARG LYS ARG PHE PRO ASN ALA ARG THR SER TYR          
SEQRES   9 A  231  THR MET PRO ASP ARG ARG ALA GLY LEU VAL ILE MET ARG          
SEQRES  10 A  231  GLU THR ILE ASN VAL GLU THR VAL ARG GLU ILE ILE ASN          
SEQRES  11 A  231  GLU LEU ASN LEU ASN LEU VAL ALA VAL ASP SER GLY PHE          
SEQRES  12 A  231  ALA ILE HIS VAL LYS LYS PRO TRP ILE ASN LYS GLY SER          
SEQRES  13 A  231  GLY ILE GLU LYS ALA SER GLU PHE LEU GLY ILE LYS PRO          
SEQRES  14 A  231  LYS GLU VAL ALA HIS VAL GLY ASP GLY GLU ASN ASP LEU          
SEQRES  15 A  231  ASP ALA PHE LYS VAL VAL GLY TYR LYS VAL ALA VAL ALA          
SEQRES  16 A  231  GLN ALA PRO LYS ILE LEU LYS GLU ASN ALA ASP TYR VAL          
SEQRES  17 A  231  THR LYS LYS GLU TYR GLY GLU GLY GLY ALA GLU ALA ILE          
SEQRES  18 A  231  TYR HIS ILE LEU GLU LYS PHE GLY TYR LEU                      
SEQRES   1 B  231  MET LYS ILE LYS ALA ILE SER ILE ASP ILE ASP GLY THR          
SEQRES   2 B  231  ILE THR TYR PRO ASN ARG MET ILE HIS GLU LYS ALA LEU          
SEQRES   3 B  231  GLU ALA ILE ARG ARG ALA GLU SER LEU GLY ILE PRO ILE          
SEQRES   4 B  231  MET LEU VAL THR GLY ASN THR VAL GLN PHE ALA GLU ALA          
SEQRES   5 B  231  ALA SER ILE LEU ILE GLY THR SER GLY PRO VAL VAL ALA          
SEQRES   6 B  231  GLU ASP GLY GLY ALA ILE SER TYR LYS LYS LYS ARG ILE          
SEQRES   7 B  231  PHE LEU ALA SER MET ASP GLU GLU TRP ILE LEU TRP ASN          
SEQRES   8 B  231  GLU ILE ARG LYS ARG PHE PRO ASN ALA ARG THR SER TYR          
SEQRES   9 B  231  THR MET PRO ASP ARG ARG ALA GLY LEU VAL ILE MET ARG          
SEQRES  10 B  231  GLU THR ILE ASN VAL GLU THR VAL ARG GLU ILE ILE ASN          
SEQRES  11 B  231  GLU LEU ASN LEU ASN LEU VAL ALA VAL ASP SER GLY PHE          
SEQRES  12 B  231  ALA ILE HIS VAL LYS LYS PRO TRP ILE ASN LYS GLY SER          
SEQRES  13 B  231  GLY ILE GLU LYS ALA SER GLU PHE LEU GLY ILE LYS PRO          
SEQRES  14 B  231  LYS GLU VAL ALA HIS VAL GLY ASP GLY GLU ASN ASP LEU          
SEQRES  15 B  231  ASP ALA PHE LYS VAL VAL GLY TYR LYS VAL ALA VAL ALA          
SEQRES  16 B  231  GLN ALA PRO LYS ILE LEU LYS GLU ASN ALA ASP TYR VAL          
SEQRES  17 B  231  THR LYS LYS GLU TYR GLY GLU GLY GLY ALA GLU ALA ILE          
SEQRES  18 B  231  TYR HIS ILE LEU GLU LYS PHE GLY TYR LEU                      
HET    ACT    600       4                                                       
HETNAM     ACT ACETATE ION                                                      
FORMUL   3  ACT    C2 H3 O2 1-                                                  
FORMUL   4  HOH   *568(H2 O)                                                    
CRYST1   63.795   81.772   86.949  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1798  N   MET B   1      32.963   0.956  56.814  1.00 44.91           N  
ATOM   1799  CA  MET B   1      31.996   1.985  56.344  1.00 44.30           C  
ATOM   1800  C   MET B   1      32.652   3.056  55.471  1.00 42.74           C  
ATOM   1801  O   MET B   1      33.664   2.804  54.818  1.00 42.78           O  
ATOM   1802  CB  MET B   1      31.305   2.620  57.551  1.00 46.25           C  
ATOM   1803  CG  MET B   1      32.243   2.970  58.689  1.00 48.27           C  
ATOM   1804  SD  MET B   1      31.376   2.984  60.269  1.00 51.90           S  
ATOM   1805  CE  MET B   1      31.256   1.214  60.583  1.00 49.41           C  
ATOM   1806  N   LYS B   2      32.070   4.251  55.464  1.00 40.13           N  
ATOM   1807  CA  LYS B   2      32.583   5.352  54.655  1.00 37.62           C  
ATOM   1808  C   LYS B   2      33.057   6.515  55.530  1.00 34.29           C  
ATOM   1809  O   LYS B   2      32.630   6.648  56.675  1.00 33.36           O  
ATOM   1810  CB  LYS B   2      31.480   5.818  53.697  1.00 39.32           C  
ATOM   1811  CG  LYS B   2      31.869   6.924  52.731  1.00 42.13           C  
ATOM   1812  CD  LYS B   2      30.718   7.232  51.777  1.00 43.52           C  
ATOM   1813  CE  LYS B   2      31.035   8.407  50.867  1.00 44.04           C  
ATOM   1814  NZ  LYS B   2      29.926   8.704  49.915  1.00 45.55           N  
ATOM   1815  N   ILE B   3      33.948   7.345  54.993  1.00 31.39           N  
ATOM   1816  CA  ILE B   3      34.462   8.504  55.727  1.00 27.80           C  
ATOM   1817  C   ILE B   3      33.637   9.724  55.343  1.00 25.00           C  
ATOM   1818  O   ILE B   3      33.498  10.038  54.161  1.00 24.26           O  
ATOM   1819  CB  ILE B   3      35.947   8.775  55.397  1.00 27.35           C  
ATOM   1820  CG1 ILE B   3      36.814   7.640  55.946  1.00 27.84           C  
ATOM   1821  CG2 ILE B   3      36.386  10.110  55.993  1.00 26.68           C  
ATOM   1822  CD1 ILE B   3      36.747   7.488  57.456  1.00 26.49           C  
ATOM   1823  N   LYS B   4      33.096  10.413  56.342  1.00 22.68           N  
ATOM   1824  CA  LYS B   4      32.259  11.579  56.090  1.00 20.83           C  
ATOM   1825  C   LYS B   4      32.805  12.879  56.665  1.00 20.52           C  
ATOM   1826  O   LYS B   4      32.262  13.951  56.401  1.00 22.70           O  
ATOM   1827  CB  LYS B   4      30.852  11.329  56.639  1.00 21.25           C  
ATOM   1828  CG  LYS B   4      30.173  10.119  56.021  1.00 23.52           C  
ATOM   1829  CD  LYS B   4      28.787   9.911  56.585  1.00 26.75           C  
ATOM   1830  CE  LYS B   4      28.117   8.721  55.921  1.00 28.45           C  
ATOM   1831  NZ  LYS B   4      26.725   8.536  56.414  1.00 30.39           N  
ATOM   1832  N   ALA B   5      33.869  12.785  57.455  1.00 17.55           N  
ATOM   1833  CA  ALA B   5      34.478  13.968  58.049  1.00 16.16           C  
ATOM   1834  C   ALA B   5      35.941  13.712  58.349  1.00 15.65           C  
ATOM   1835  O   ALA B   5      36.369  12.564  58.489  1.00 15.09           O  
ATOM   1836  CB  ALA B   5      33.751  14.356  59.333  1.00 16.19           C  
ATOM   1837  N   ILE B   6      36.711  14.791  58.441  1.00 14.67           N  
ATOM   1838  CA  ILE B   6      38.128  14.688  58.757  1.00 14.14           C  
ATOM   1839  C   ILE B   6      38.432  15.491  60.015  1.00 15.05           C  
ATOM   1840  O   ILE B   6      38.122  16.686  60.089  1.00 15.30           O  
ATOM   1841  CB  ILE B   6      39.017  15.250  57.616  1.00 13.10           C  
ATOM   1842  CG1 ILE B   6      38.866  14.394  56.358  1.00 15.40           C  
ATOM   1843  CG2 ILE B   6      40.476  15.287  58.068  1.00 15.70           C  
ATOM   1844  CD1 ILE B   6      39.523  14.995  55.117  1.00 12.95           C  
ATOM   1845  N   SER B   7      39.003  14.834  61.018  1.00 14.83           N  
ATOM   1846  CA  SER B   7      39.386  15.536  62.234  1.00 13.44           C  
ATOM   1847  C   SER B   7      40.884  15.740  62.051  1.00 14.19           C  
ATOM   1848  O   SER B   7      41.564  14.876  61.498  1.00 13.13           O  
ATOM   1849  CB  SER B   7      39.076  14.707  63.495  1.00 14.86           C  
ATOM   1850  OG  SER B   7      39.678  13.423  63.461  1.00 14.35           O  
ATOM   1851  N   ILE B   8      41.400  16.882  62.487  1.00 13.68           N  
ATOM   1852  CA  ILE B   8      42.818  17.160  62.302  1.00 13.61           C  
ATOM   1853  C   ILE B   8      43.363  18.106  63.365  1.00 13.10           C  
ATOM   1854  O   ILE B   8      42.711  19.080  63.738  1.00 13.77           O  
ATOM   1855  CB  ILE B   8      43.056  17.748  60.877  1.00 13.49           C  
ATOM   1856  CG1 ILE B   8      44.550  17.925  60.612  1.00 13.09           C  
ATOM   1857  CG2 ILE B   8      42.309  19.084  60.718  1.00 13.60           C  
ATOM   1858  CD1 ILE B   8      44.863  18.167  59.147  1.00 15.97           C  
ATOM   1859  N   ASP B   9      44.553  17.803  63.867  1.00 13.28           N  
ATOM   1860  CA  ASP B   9      45.184  18.639  64.882  1.00 15.15           C  
ATOM   1861  C   ASP B   9      45.548  19.986  64.281  1.00 13.87           C  
ATOM   1862  O   ASP B   9      45.655  20.123  63.060  1.00 13.83           O  
ATOM   1863  CB  ASP B   9      46.463  17.983  65.398  1.00 16.21           C  
ATOM   1864  CG  ASP B   9      46.195  16.753  66.227  1.00 20.99           C  
ATOM   1865  OD1 ASP B   9      47.082  15.878  66.268  1.00 20.33           O  
ATOM   1866  OD2 ASP B   9      45.112  16.667  66.846  1.00 21.73           O  
ATOM   1867  N   ILE B  10      45.732  20.984  65.136  1.00 14.36           N  
ATOM   1868  CA  ILE B  10      46.118  22.301  64.656  1.00 13.94           C  
ATOM   1869  C   ILE B  10      47.646  22.400  64.657  1.00 15.96           C  
ATOM   1870  O   ILE B  10      48.273  22.310  63.604  1.00 14.62           O  
ATOM   1871  CB  ILE B  10      45.512  23.419  65.528  1.00 14.04           C  
ATOM   1872  CG1 ILE B  10      43.984  23.347  65.459  1.00 13.95           C  
ATOM   1873  CG2 ILE B  10      45.991  24.783  65.032  1.00 14.09           C  
ATOM   1874  CD1 ILE B  10      43.279  24.372  66.335  1.00 13.34           C  
ATOM   1875  N   ASP B  11      48.246  22.552  65.833  1.00 17.06           N  
ATOM   1876  CA  ASP B  11      49.700  22.657  65.932  1.00 18.19           C  
ATOM   1877  C   ASP B  11      50.433  21.458  65.337  1.00 18.28           C  
ATOM   1878  O   ASP B  11      50.014  20.312  65.514  1.00 19.38           O  
ATOM   1879  CB  ASP B  11      50.114  22.842  67.394  1.00 20.33           C  
ATOM   1880  CG  ASP B  11      49.732  24.209  67.937  1.00 25.80           C  
ATOM   1881  OD1 ASP B  11      49.820  24.412  69.164  1.00 30.13           O  
ATOM   1882  OD2 ASP B  11      49.351  25.083  67.133  1.00 27.46           O  
ATOM   1883  N   GLY B  12      51.514  21.747  64.616  1.00 16.95           N  
ATOM   1884  CA  GLY B  12      52.331  20.718  63.991  1.00 16.92           C  
ATOM   1885  C   GLY B  12      51.681  19.938  62.861  1.00 16.18           C  
ATOM   1886  O   GLY B  12      52.325  19.085  62.242  1.00 15.09           O  
ATOM   1887  N   THR B  13      50.426  20.249  62.555  1.00 14.55           N  
ATOM   1888  CA  THR B  13      49.701  19.510  61.535  1.00 13.32           C  
ATOM   1889  C   THR B  13      49.183  20.380  60.392  1.00 12.98           C  
ATOM   1890  O   THR B  13      49.260  19.993  59.225  1.00 13.54           O  
ATOM   1891  CB  THR B  13      48.559  18.738  62.212  1.00 15.93           C  
ATOM   1892  OG1 THR B  13      49.087  18.059  63.362  1.00 18.79           O  
ATOM   1893  CG2 THR B  13      47.963  17.716  61.275  1.00 17.32           C  
ATOM   1894  N   ILE B  14      48.648  21.550  60.722  1.00 11.67           N  
ATOM   1895  CA  ILE B  14      48.185  22.464  59.684  1.00 12.55           C  
ATOM   1896  C   ILE B  14      48.957  23.775  59.811  1.00 11.99           C  
ATOM   1897  O   ILE B  14      48.600  24.782  59.204  1.00 12.28           O  
ATOM   1898  CB  ILE B  14      46.663  22.723  59.780  1.00 10.99           C  
ATOM   1899  CG1 ILE B  14      46.300  23.372  61.119  1.00 13.13           C  
ATOM   1900  CG2 ILE B  14      45.921  21.402  59.617  1.00 12.55           C  
ATOM   1901  CD1 ILE B  14      44.809  23.672  61.268  1.00 13.14           C  
ATOM   1902  N   THR B  15      50.033  23.739  60.590  1.00 11.87           N  
ATOM   1903  CA  THR B  15      50.864  24.916  60.821  1.00 13.27           C  
ATOM   1904  C   THR B  15      52.335  24.670  60.518  1.00 14.06           C  
ATOM   1905  O   THR B  15      52.760  23.545  60.258  1.00 13.67           O  
ATOM   1906  CB  THR B  15      50.809  25.353  62.294  1.00 13.64           C  
ATOM   1907  OG1 THR B  15      51.443  24.354  63.111  1.00 14.56           O  
ATOM   1908  CG2 THR B  15      49.369  25.532  62.747  1.00 15.19           C  
ATOM   1909  N   TYR B  16      53.096  25.757  60.543  1.00 13.42           N  
ATOM   1910  CA  TYR B  16      54.539  25.704  60.378  1.00 14.12           C  
ATOM   1911  C   TYR B  16      54.992  25.329  61.781  1.00 14.55           C  
ATOM   1912  O   TYR B  16      54.193  25.325  62.720  1.00 14.36           O  
ATOM   1913  CB  TYR B  16      55.092  27.092  60.055  1.00 13.04           C  
ATOM   1914  CG  TYR B  16      54.950  27.516  58.617  1.00 14.76           C  
ATOM   1915  CD1 TYR B  16      55.947  27.226  57.685  1.00 15.58           C  
ATOM   1916  CD2 TYR B  16      53.822  28.207  58.181  1.00 13.42           C  
ATOM   1917  CE1 TYR B  16      55.827  27.618  56.364  1.00 13.65           C  
ATOM   1918  CE2 TYR B  16      53.688  28.599  56.855  1.00 13.33           C  
ATOM   1919  CZ  TYR B  16      54.698  28.301  55.949  1.00 14.34           C  
ATOM   1920  OH  TYR B  16      54.576  28.680  54.630  1.00 15.68           O  
ATOM   1921  N   PRO B  17      56.280  25.011  61.950  1.00 15.27           N  
ATOM   1922  CA  PRO B  17      56.752  24.656  63.289  1.00 16.17           C  
ATOM   1923  C   PRO B  17      56.486  25.752  64.331  1.00 17.47           C  
ATOM   1924  O   PRO B  17      56.274  25.450  65.502  1.00 19.57           O  
ATOM   1925  CB  PRO B  17      58.240  24.406  63.064  1.00 15.63           C  
ATOM   1926  CG  PRO B  17      58.247  23.794  61.685  1.00 16.12           C  
ATOM   1927  CD  PRO B  17      57.295  24.698  60.928  1.00 16.10           C  
ATOM   1928  N   ASN B  18      56.481  27.018  63.904  1.00 16.23           N  
ATOM   1929  CA  ASN B  18      56.248  28.131  64.829  1.00 16.37           C  
ATOM   1930  C   ASN B  18      54.776  28.384  65.149  1.00 15.97           C  
ATOM   1931  O   ASN B  18      54.426  29.401  65.761  1.00 17.37           O  
ATOM   1932  CB  ASN B  18      56.884  29.423  64.306  1.00 17.77           C  
ATOM   1933  CG  ASN B  18      56.105  30.046  63.164  1.00 18.58           C  
ATOM   1934  OD1 ASN B  18      55.185  29.431  62.625  1.00 16.93           O  
ATOM   1935  ND2 ASN B  18      56.464  31.262  62.793  1.00 19.90           N  
ATOM   1936  N   ARG B  19      53.925  27.458  64.714  1.00 14.91           N  
ATOM   1937  CA  ARG B  19      52.484  27.495  64.965  1.00 16.28           C  
ATOM   1938  C   ARG B  19      51.613  28.389  64.090  1.00 14.42           C  
ATOM   1939  O   ARG B  19      50.399  28.441  64.288  1.00 13.81           O  
ATOM   1940  CB  ARG B  19      52.226  27.815  66.439  1.00 16.66           C  
ATOM   1941  CG  ARG B  19      52.873  26.827  67.398  1.00 22.39           C  
ATOM   1942  CD  ARG B  19      52.716  27.300  68.831  1.00 25.53           C  
ATOM   1943  NE  ARG B  19      51.312  27.354  69.229  1.00 30.37           N  
ATOM   1944  CZ  ARG B  19      50.855  28.057  70.261  1.00 32.10           C  
ATOM   1945  NH1 ARG B  19      51.690  28.772  70.999  1.00 33.61           N  
ATOM   1946  NH2 ARG B  19      49.563  28.039  70.558  1.00 33.41           N  
ATOM   1947  N   MET B  20      52.196  29.094  63.125  1.00 14.38           N  
ATOM   1948  CA  MET B  20      51.357  29.922  62.267  1.00 12.58           C  
ATOM   1949  C   MET B  20      50.764  29.035  61.173  1.00 11.84           C  
ATOM   1950  O   MET B  20      51.367  28.031  60.777  1.00 11.68           O  
ATOM   1951  CB  MET B  20      52.148  31.098  61.666  1.00 16.59           C  
ATOM   1952  CG  MET B  20      53.242  30.739  60.681  1.00 16.91           C  
ATOM   1953  SD  MET B  20      54.194  32.236  60.236  1.00 19.31           S  
ATOM   1954  CE  MET B  20      55.048  31.684  58.764  1.00 22.82           C  
ATOM   1955  N   ILE B  21      49.573  29.395  60.707  1.00 10.79           N  
ATOM   1956  CA  ILE B  21      48.873  28.625  59.683  1.00 13.05           C  
ATOM   1957  C   ILE B  21      49.716  28.414  58.440  1.00 13.18           C  
ATOM   1958  O   ILE B  21      50.371  29.336  57.959  1.00 11.86           O  
ATOM   1959  CB  ILE B  21      47.555  29.311  59.257  1.00 17.01           C  
ATOM   1960  CG1 ILE B  21      46.717  29.653  60.490  1.00 19.25           C  
ATOM   1961  CG2 ILE B  21      46.757  28.376  58.364  1.00 18.97           C  
ATOM   1962  CD1 ILE B  21      45.504  30.517  60.187  1.00 21.83           C  
ATOM   1963  N   HIS B  22      49.706  27.185  57.930  1.00 11.45           N  
ATOM   1964  CA  HIS B  22      50.452  26.870  56.724  1.00 11.90           C  
ATOM   1965  C   HIS B  22      49.487  26.999  55.543  1.00 12.56           C  
ATOM   1966  O   HIS B  22      48.418  26.387  55.528  1.00 11.67           O  
ATOM   1967  CB  HIS B  22      51.019  25.453  56.807  1.00 12.56           C  
ATOM   1968  CG  HIS B  22      52.070  25.176  55.780  1.00 11.18           C  
ATOM   1969  ND1 HIS B  22      51.801  25.151  54.428  1.00 14.85           N  
ATOM   1970  CD2 HIS B  22      53.402  24.965  55.903  1.00 13.03           C  
ATOM   1971  CE1 HIS B  22      52.923  24.939  53.763  1.00 15.22           C  
ATOM   1972  NE2 HIS B  22      53.909  24.825  54.635  1.00 15.71           N  
ATOM   1973  N   GLU B  23      49.867  27.809  54.559  1.00 12.68           N  
ATOM   1974  CA  GLU B  23      49.027  28.056  53.396  1.00 12.80           C  
ATOM   1975  C   GLU B  23      48.569  26.804  52.645  1.00 11.85           C  
ATOM   1976  O   GLU B  23      47.456  26.764  52.129  1.00 12.99           O  
ATOM   1977  CB  GLU B  23      49.746  29.009  52.430  1.00 14.61           C  
ATOM   1978  CG  GLU B  23      50.187  30.316  53.085  1.00 16.88           C  
ATOM   1979  CD  GLU B  23      51.650  30.321  53.497  1.00 21.66           C  
ATOM   1980  OE1 GLU B  23      52.117  29.335  54.101  1.00 18.56           O  
ATOM   1981  OE2 GLU B  23      52.337  31.327  53.223  1.00 22.46           O  
ATOM   1982  N   LYS B  24      49.419  25.786  52.564  1.00 12.90           N  
ATOM   1983  CA  LYS B  24      49.021  24.570  51.863  1.00 13.08           C  
ATOM   1984  C   LYS B  24      47.917  23.832  52.614  1.00 12.75           C  
ATOM   1985  O   LYS B  24      46.988  23.297  51.998  1.00 12.77           O  
ATOM   1986  CB  LYS B  24      50.230  23.663  51.642  1.00 14.91           C  
ATOM   1987  CG  LYS B  24      51.241  24.278  50.684  1.00 19.64           C  
ATOM   1988  CD  LYS B  24      52.323  23.287  50.294  1.00 24.89           C  
ATOM   1989  CE  LYS B  24      53.328  23.937  49.357  1.00 28.00           C  
ATOM   1990  NZ  LYS B  24      52.649  24.512  48.164  1.00 31.90           N  
ATOM   1991  N   ALA B  25      48.012  23.815  53.942  1.00 11.05           N  
ATOM   1992  CA  ALA B  25      46.997  23.167  54.764  1.00 12.23           C  
ATOM   1993  C   ALA B  25      45.708  23.988  54.698  1.00 12.37           C  
ATOM   1994  O   ALA B  25      44.611  23.434  54.626  1.00 11.83           O  
ATOM   1995  CB  ALA B  25      47.476  23.052  56.209  1.00 11.01           C  
ATOM   1996  N   LEU B  26      45.849  25.310  54.716  1.00 11.65           N  
ATOM   1997  CA  LEU B  26      44.702  26.211  54.643  1.00 11.49           C  
ATOM   1998  C   LEU B  26      43.905  25.931  53.370  1.00 10.99           C  
ATOM   1999  O   LEU B  26      42.680  25.798  53.393  1.00 10.75           O  
ATOM   2000  CB  LEU B  26      45.184  27.668  54.634  1.00 12.16           C  
ATOM   2001  CG  LEU B  26      44.142  28.783  54.478  1.00 10.61           C  
ATOM   2002  CD1 LEU B  26      43.198  28.775  55.673  1.00 13.48           C  
ATOM   2003  CD2 LEU B  26      44.847  30.137  54.381  1.00 10.94           C  
ATOM   2004  N   GLU B  27      44.611  25.824  52.252  1.00 11.26           N  
ATOM   2005  CA  GLU B  27      43.956  25.590  50.980  1.00 12.11           C  
ATOM   2006  C   GLU B  27      43.350  24.199  50.889  1.00 11.20           C  
ATOM   2007  O   GLU B  27      42.265  24.031  50.327  1.00 12.05           O  
ATOM   2008  CB  GLU B  27      44.952  25.857  49.840  1.00 12.50           C  
ATOM   2009  CG  GLU B  27      45.364  27.332  49.806  1.00 16.95           C  
ATOM   2010  CD  GLU B  27      46.516  27.639  48.874  1.00 23.41           C  
ATOM   2011  OE1 GLU B  27      47.047  26.708  48.233  1.00 25.86           O  
ATOM   2012  OE2 GLU B  27      46.892  28.829  48.786  1.00 24.69           O  
ATOM   2013  N   ALA B  28      44.034  23.208  51.461  1.00 11.35           N  
ATOM   2014  CA  ALA B  28      43.532  21.838  51.429  1.00 12.27           C  
ATOM   2015  C   ALA B  28      42.244  21.753  52.233  1.00 12.01           C  
ATOM   2016  O   ALA B  28      41.293  21.083  51.831  1.00 11.90           O  
ATOM   2017  CB  ALA B  28      44.571  20.879  51.993  1.00 13.41           C  
ATOM   2018  N   ILE B  29      42.208  22.455  53.363  1.00 11.21           N  
ATOM   2019  CA  ILE B  29      41.021  22.462  54.208  1.00 11.73           C  
ATOM   2020  C   ILE B  29      39.864  23.130  53.478  1.00 10.08           C  
ATOM   2021  O   ILE B  29      38.743  22.626  53.473  1.00 10.96           O  
ATOM   2022  CB  ILE B  29      41.292  23.200  55.538  1.00 11.43           C  
ATOM   2023  CG1 ILE B  29      42.142  22.307  56.449  1.00 13.26           C  
ATOM   2024  CG2 ILE B  29      39.973  23.588  56.218  1.00 12.63           C  
ATOM   2025  CD1 ILE B  29      42.617  22.983  57.717  1.00 13.00           C  
ATOM   2026  N   ARG B  30      40.132  24.264  52.845  1.00 11.38           N  
ATOM   2027  CA  ARG B  30      39.074  24.950  52.130  1.00  9.80           C  
ATOM   2028  C   ARG B  30      38.552  24.109  50.969  1.00 11.50           C  
ATOM   2029  O   ARG B  30      37.360  24.115  50.692  1.00 13.11           O  
ATOM   2030  CB  ARG B  30      39.569  26.322  51.673  1.00 11.31           C  
ATOM   2031  CG  ARG B  30      39.840  27.219  52.880  1.00 11.24           C  
ATOM   2032  CD  ARG B  30      40.350  28.597  52.519  1.00 11.89           C  
ATOM   2033  NE  ARG B  30      40.406  29.440  53.709  1.00 12.74           N  
ATOM   2034  CZ  ARG B  30      40.827  30.701  53.712  1.00 13.21           C  
ATOM   2035  NH1 ARG B  30      41.239  31.263  52.582  1.00 14.30           N  
ATOM   2036  NH2 ARG B  30      40.822  31.399  54.840  1.00 13.01           N  
ATOM   2037  N   ARG B  31      39.436  23.372  50.297  1.00 11.88           N  
ATOM   2038  CA  ARG B  31      38.984  22.531  49.194  1.00 11.54           C  
ATOM   2039  C   ARG B  31      38.125  21.391  49.741  1.00 13.06           C  
ATOM   2040  O   ARG B  31      37.086  21.065  49.175  1.00 13.35           O  
ATOM   2041  CB  ARG B  31      40.177  21.959  48.416  1.00 11.25           C  
ATOM   2042  CG  ARG B  31      39.761  21.185  47.168  1.00 14.30           C  
ATOM   2043  CD  ARG B  31      40.953  20.728  46.339  1.00 14.26           C  
ATOM   2044  NE  ARG B  31      40.511  20.247  45.030  1.00 16.26           N  
ATOM   2045  CZ  ARG B  31      41.321  19.981  44.009  1.00 15.82           C  
ATOM   2046  NH1 ARG B  31      42.632  20.141  44.131  1.00 15.34           N  
ATOM   2047  NH2 ARG B  31      40.813  19.578  42.853  1.00 18.60           N  
ATOM   2048  N   ALA B  32      38.563  20.784  50.841  1.00 11.68           N  
ATOM   2049  CA  ALA B  32      37.817  19.690  51.459  1.00 13.33           C  
ATOM   2050  C   ALA B  32      36.407  20.138  51.845  1.00 13.76           C  
ATOM   2051  O   ALA B  32      35.426  19.435  51.597  1.00 13.62           O  
ATOM   2052  CB  ALA B  32      38.556  19.180  52.695  1.00 12.57           C  
ATOM   2053  N   GLU B  33      36.303  21.314  52.455  1.00 13.07           N  
ATOM   2054  CA  GLU B  33      34.996  21.823  52.849  1.00 12.81           C  
ATOM   2055  C   GLU B  33      34.125  21.994  51.605  1.00 14.58           C  
ATOM   2056  O   GLU B  33      32.945  21.643  51.613  1.00 15.29           O  
ATOM   2057  CB  GLU B  33      35.141  23.167  53.577  1.00 13.50           C  
ATOM   2058  CG  GLU B  33      35.700  23.089  54.997  1.00 13.06           C  
ATOM   2059  CD  GLU B  33      34.697  22.554  56.013  1.00 13.32           C  
ATOM   2060  OE1 GLU B  33      33.503  22.413  55.673  1.00 15.30           O  
ATOM   2061  OE2 GLU B  33      35.105  22.286  57.162  1.00 12.73           O  
ATOM   2062  N   SER B  34      34.714  22.511  50.529  1.00 13.17           N  
ATOM   2063  CA  SER B  34      33.965  22.734  49.296  1.00 14.88           C  
ATOM   2064  C   SER B  34      33.502  21.427  48.667  1.00 15.66           C  
ATOM   2065  O   SER B  34      32.599  21.426  47.827  1.00 16.15           O  
ATOM   2066  CB  SER B  34      34.798  23.526  48.284  1.00 14.69           C  
ATOM   2067  OG  SER B  34      35.756  22.710  47.630  1.00 14.15           O  
ATOM   2068  N   LEU B  35      34.122  20.321  49.067  1.00 15.24           N  
ATOM   2069  CA  LEU B  35      33.746  19.011  48.542  1.00 17.46           C  
ATOM   2070  C   LEU B  35      32.694  18.359  49.436  1.00 18.60           C  
ATOM   2071  O   LEU B  35      32.295  17.213  49.214  1.00 19.66           O  
ATOM   2072  CB  LEU B  35      34.979  18.110  48.423  1.00 17.73           C  
ATOM   2073  CG  LEU B  35      35.962  18.497  47.313  1.00 17.28           C  
ATOM   2074  CD1 LEU B  35      37.239  17.692  47.446  1.00 18.82           C  
ATOM   2075  CD2 LEU B  35      35.315  18.269  45.954  1.00 20.78           C  
ATOM   2076  N   GLY B  36      32.246  19.102  50.445  1.00 17.25           N  
ATOM   2077  CA  GLY B  36      31.229  18.592  51.347  1.00 19.10           C  
ATOM   2078  C   GLY B  36      31.743  17.735  52.485  1.00 18.56           C  
ATOM   2079  O   GLY B  36      30.976  16.981  53.090  1.00 20.17           O  
ATOM   2080  N   ILE B  37      33.036  17.830  52.776  1.00 16.97           N  
ATOM   2081  CA  ILE B  37      33.628  17.064  53.866  1.00 17.07           C  
ATOM   2082  C   ILE B  37      34.002  18.031  54.982  1.00 17.18           C  
ATOM   2083  O   ILE B  37      34.969  18.780  54.870  1.00 17.58           O  
ATOM   2084  CB  ILE B  37      34.903  16.308  53.415  1.00 20.59           C  
ATOM   2085  CG1 ILE B  37      34.595  15.414  52.212  1.00 22.81           C  
ATOM   2086  CG2 ILE B  37      35.434  15.462  54.561  1.00 20.28           C  
ATOM   2087  CD1 ILE B  37      33.584  14.322  52.499  1.00 24.48           C  
ATOM   2088  N   PRO B  38      33.229  18.033  56.078  1.00 16.09           N  
ATOM   2089  CA  PRO B  38      33.514  18.931  57.201  1.00 15.09           C  
ATOM   2090  C   PRO B  38      34.834  18.607  57.876  1.00 14.47           C  
ATOM   2091  O   PRO B  38      35.211  17.444  58.009  1.00 15.36           O  
ATOM   2092  CB  PRO B  38      32.334  18.702  58.144  1.00 16.25           C  
ATOM   2093  CG  PRO B  38      31.239  18.215  57.229  1.00 19.56           C  
ATOM   2094  CD  PRO B  38      31.982  17.288  56.310  1.00 16.92           C  
ATOM   2095  N   ILE B  39      35.530  19.652  58.297  1.00 12.99           N  
ATOM   2096  CA  ILE B  39      36.796  19.509  58.988  1.00 12.51           C  
ATOM   2097  C   ILE B  39      36.583  19.841  60.467  1.00 13.83           C  
ATOM   2098  O   ILE B  39      36.019  20.887  60.806  1.00 13.71           O  
ATOM   2099  CB  ILE B  39      37.862  20.474  58.399  1.00 12.50           C  
ATOM   2100  CG1 ILE B  39      38.089  20.161  56.912  1.00 15.49           C  
ATOM   2101  CG2 ILE B  39      39.156  20.377  59.200  1.00 13.30           C  
ATOM   2102  CD1 ILE B  39      38.492  18.717  56.615  1.00 16.68           C  
ATOM   2103  N   MET B  40      37.003  18.929  61.343  1.00 12.56           N  
ATOM   2104  CA  MET B  40      36.892  19.141  62.780  1.00 13.85           C  
ATOM   2105  C   MET B  40      38.293  19.391  63.319  1.00 13.84           C  
ATOM   2106  O   MET B  40      39.141  18.499  63.291  1.00 14.08           O  
ATOM   2107  CB  MET B  40      36.288  17.913  63.472  1.00 17.22           C  
ATOM   2108  CG  MET B  40      34.822  17.680  63.155  1.00 18.83           C  
ATOM   2109  SD  MET B  40      34.104  16.356  64.152  1.00 24.29           S  
ATOM   2110  CE  MET B  40      34.656  14.936  63.261  1.00 21.58           C  
ATOM   2111  N   LEU B  41      38.543  20.606  63.791  1.00 14.35           N  
ATOM   2112  CA  LEU B  41      39.854  20.941  64.336  1.00 14.91           C  
ATOM   2113  C   LEU B  41      39.969  20.338  65.726  1.00 14.54           C  
ATOM   2114  O   LEU B  41      39.008  20.361  66.500  1.00 14.77           O  
ATOM   2115  CB  LEU B  41      40.040  22.457  64.410  1.00 16.08           C  
ATOM   2116  CG  LEU B  41      40.020  23.230  63.087  1.00 15.90           C  
ATOM   2117  CD1 LEU B  41      40.178  24.714  63.379  1.00 15.79           C  
ATOM   2118  CD2 LEU B  41      41.134  22.750  62.168  1.00 15.13           C  
ATOM   2119  N   VAL B  42      41.138  19.783  66.029  1.00 12.41           N  
ATOM   2120  CA  VAL B  42      41.386  19.162  67.329  1.00 14.88           C  
ATOM   2121  C   VAL B  42      42.621  19.804  67.946  1.00 15.03           C  
ATOM   2122  O   VAL B  42      43.632  20.001  67.270  1.00 14.24           O  
ATOM   2123  CB  VAL B  42      41.621  17.649  67.183  1.00 12.66           C  
ATOM   2124  CG1 VAL B  42      41.897  17.030  68.550  1.00 15.15           C  
ATOM   2125  CG2 VAL B  42      40.418  16.995  66.528  1.00 15.01           C  
ATOM   2126  N   THR B  43      42.551  20.119  69.235  1.00 14.40           N  
ATOM   2127  CA  THR B  43      43.676  20.777  69.877  1.00 16.28           C  
ATOM   2128  C   THR B  43      43.696  20.660  71.393  1.00 15.72           C  
ATOM   2129  O   THR B  43      42.673  20.396  72.033  1.00 16.14           O  
ATOM   2130  CB  THR B  43      43.681  22.290  69.529  1.00 15.60           C  
ATOM   2131  OG1 THR B  43      44.877  22.901  70.024  1.00 16.99           O  
ATOM   2132  CG2 THR B  43      42.478  22.984  70.170  1.00 16.65           C  
ATOM   2133  N   GLY B  44      44.884  20.869  71.949  1.00 16.93           N  
ATOM   2134  CA  GLY B  44      45.058  20.857  73.385  1.00 16.24           C  
ATOM   2135  C   GLY B  44      44.905  22.290  73.855  1.00 16.85           C  
ATOM   2136  O   GLY B  44      44.885  22.565  75.055  1.00 17.76           O  
ATOM   2137  N   ASN B  45      44.806  23.219  72.903  1.00 16.76           N  
ATOM   2138  CA  ASN B  45      44.643  24.620  73.255  1.00 15.72           C  
ATOM   2139  C   ASN B  45      43.210  24.836  73.728  1.00 15.16           C  
ATOM   2140  O   ASN B  45      42.407  23.904  73.752  1.00 13.57           O  
ATOM   2141  CB  ASN B  45      44.931  25.534  72.060  1.00 18.93           C  
ATOM   2142  CG  ASN B  45      45.604  26.836  72.474  1.00 23.39           C  
ATOM   2143  OD1 ASN B  45      45.134  27.542  73.375  1.00 22.61           O  
ATOM   2144  ND2 ASN B  45      46.715  27.158  71.816  1.00 24.01           N  
ATOM   2145  N   THR B  46      42.895  26.072  74.091  1.00 13.19           N  
ATOM   2146  CA  THR B  46      41.563  26.408  74.584  1.00 13.99           C  
ATOM   2147  C   THR B  46      40.469  26.286  73.529  1.00 13.61           C  
ATOM   2148  O   THR B  46      40.737  26.236  72.328  1.00 14.56           O  
ATOM   2149  CB  THR B  46      41.529  27.842  75.122  1.00 13.50           C  
ATOM   2150  OG1 THR B  46      41.692  28.759  74.031  1.00 14.41           O  
ATOM   2151  CG2 THR B  46      42.648  28.057  76.127  1.00 15.06           C  
ATOM   2152  N   VAL B  47      39.224  26.245  73.992  1.00 13.84           N  
ATOM   2153  CA  VAL B  47      38.095  26.148  73.083  1.00 13.56           C  
ATOM   2154  C   VAL B  47      37.970  27.484  72.344  1.00 14.06           C  
ATOM   2155  O   VAL B  47      37.507  27.527  71.205  1.00 14.57           O  
ATOM   2156  CB  VAL B  47      36.780  25.833  73.846  1.00 13.97           C  
ATOM   2157  CG1 VAL B  47      36.373  27.017  74.708  1.00 14.52           C  
ATOM   2158  CG2 VAL B  47      35.676  25.477  72.859  1.00 15.98           C  
ATOM   2159  N   GLN B  48      38.395  28.569  72.990  1.00 13.13           N  
ATOM   2160  CA  GLN B  48      38.334  29.891  72.371  1.00 13.77           C  
ATOM   2161  C   GLN B  48      39.322  29.951  71.215  1.00 13.78           C  
ATOM   2162  O   GLN B  48      39.038  30.527  70.162  1.00 13.97           O  
ATOM   2163  CB  GLN B  48      38.664  30.988  73.390  1.00 13.65           C  
ATOM   2164  CG  GLN B  48      37.643  31.114  74.514  1.00 14.59           C  
ATOM   2165  CD  GLN B  48      37.936  30.210  75.701  1.00 15.33           C  
ATOM   2166  OE1 GLN B  48      38.729  29.274  75.608  1.00 16.23           O  
ATOM   2167  NE2 GLN B  48      37.274  30.482  76.824  1.00 15.66           N  
ATOM   2168  N   PHE B  49      40.491  29.359  71.417  1.00 14.62           N  
ATOM   2169  CA  PHE B  49      41.505  29.339  70.372  1.00 12.80           C  
ATOM   2170  C   PHE B  49      40.968  28.518  69.207  1.00 13.35           C  
ATOM   2171  O   PHE B  49      41.035  28.941  68.049  1.00 13.47           O  
ATOM   2172  CB  PHE B  49      42.803  28.725  70.913  1.00 13.68           C  
ATOM   2173  CG  PHE B  49      43.905  28.628  69.895  1.00 13.63           C  
ATOM   2174  CD1 PHE B  49      43.896  27.627  68.927  1.00 15.79           C  
ATOM   2175  CD2 PHE B  49      44.947  29.549  69.894  1.00 14.25           C  
ATOM   2176  CE1 PHE B  49      44.908  27.548  67.973  1.00 16.17           C  
ATOM   2177  CE2 PHE B  49      45.962  29.478  68.946  1.00 16.94           C  
ATOM   2178  CZ  PHE B  49      45.941  28.476  67.983  1.00 17.00           C  
ATOM   2179  N   ALA B  50      40.415  27.350  69.520  1.00 11.50           N  
ATOM   2180  CA  ALA B  50      39.874  26.467  68.498  1.00 12.59           C  
ATOM   2181  C   ALA B  50      38.765  27.141  67.692  1.00 12.52           C  
ATOM   2182  O   ALA B  50      38.708  26.991  66.476  1.00 12.26           O  
ATOM   2183  CB  ALA B  50      39.352  25.179  69.141  1.00 13.54           C  
ATOM   2184  N   GLU B  51      37.883  27.875  68.367  1.00 12.09           N  
ATOM   2185  CA  GLU B  51      36.800  28.567  67.670  1.00 12.57           C  
ATOM   2186  C   GLU B  51      37.367  29.620  66.723  1.00 12.10           C  
ATOM   2187  O   GLU B  51      36.908  29.746  65.591  1.00 11.26           O  
ATOM   2188  CB  GLU B  51      35.856  29.249  68.662  1.00 12.32           C  
ATOM   2189  CG  GLU B  51      35.064  28.293  69.541  1.00 13.62           C  
ATOM   2190  CD  GLU B  51      34.320  29.020  70.640  1.00 14.32           C  
ATOM   2191  OE1 GLU B  51      34.695  30.172  70.941  1.00 13.57           O  
ATOM   2192  OE2 GLU B  51      33.373  28.438  71.217  1.00 14.78           O  
ATOM   2193  N   ALA B  52      38.354  30.377  67.195  1.00 12.33           N  
ATOM   2194  CA  ALA B  52      38.984  31.413  66.371  1.00 10.92           C  
ATOM   2195  C   ALA B  52      39.603  30.766  65.137  1.00 11.92           C  
ATOM   2196  O   ALA B  52      39.462  31.269  64.017  1.00 10.88           O  
ATOM   2197  CB  ALA B  52      40.057  32.147  67.175  1.00 11.38           C  
ATOM   2198  N   ALA B  53      40.284  29.643  65.348  1.00 11.31           N  
ATOM   2199  CA  ALA B  53      40.915  28.929  64.247  1.00 10.52           C  
ATOM   2200  C   ALA B  53      39.861  28.504  63.224  1.00 11.72           C  
ATOM   2201  O   ALA B  53      40.063  28.641  62.016  1.00 11.67           O  
ATOM   2202  CB  ALA B  53      41.669  27.710  64.781  1.00 12.49           C  
ATOM   2203  N   SER B  54      38.728  27.993  63.700  1.00 10.69           N  
ATOM   2204  CA  SER B  54      37.674  27.562  62.788  1.00 10.88           C  
ATOM   2205  C   SER B  54      37.166  28.728  61.953  1.00 11.95           C  
ATOM   2206  O   SER B  54      36.953  28.605  60.743  1.00 11.52           O  
ATOM   2207  CB  SER B  54      36.507  26.948  63.568  1.00 11.36           C  
ATOM   2208  OG  SER B  54      35.414  26.702  62.703  1.00 11.79           O  
ATOM   2209  N   ILE B  55      36.978  29.865  62.610  1.00 10.40           N  
ATOM   2210  CA  ILE B  55      36.479  31.055  61.935  1.00 10.37           C  
ATOM   2211  C   ILE B  55      37.454  31.574  60.877  1.00 10.67           C  
ATOM   2212  O   ILE B  55      37.058  31.828  59.736  1.00 11.33           O  
ATOM   2213  CB  ILE B  55      36.190  32.176  62.959  1.00 10.79           C  
ATOM   2214  CG1 ILE B  55      35.004  31.771  63.842  1.00 13.97           C  
ATOM   2215  CG2 ILE B  55      35.871  33.478  62.247  1.00 11.59           C  
ATOM   2216  CD1 ILE B  55      34.869  32.615  65.099  1.00 14.48           C  
ATOM   2217  N   LEU B  56      38.721  31.712  61.250  1.00 11.41           N  
ATOM   2218  CA  LEU B  56      39.730  32.231  60.333  1.00 11.27           C  
ATOM   2219  C   LEU B  56      40.049  31.286  59.182  1.00 12.27           C  
ATOM   2220  O   LEU B  56      40.177  31.715  58.030  1.00 12.21           O  
ATOM   2221  CB  LEU B  56      41.009  32.560  61.104  1.00 12.36           C  
ATOM   2222  CG  LEU B  56      40.866  33.710  62.101  1.00 11.49           C  
ATOM   2223  CD1 LEU B  56      42.087  33.764  62.996  1.00 13.25           C  
ATOM   2224  CD2 LEU B  56      40.688  35.030  61.350  1.00 14.23           C  
ATOM   2225  N   ILE B  57      40.186  30.003  59.491  1.00 11.67           N  
ATOM   2226  CA  ILE B  57      40.493  29.016  58.464  1.00 12.34           C  
ATOM   2227  C   ILE B  57      39.283  28.736  57.583  1.00 12.21           C  
ATOM   2228  O   ILE B  57      39.404  28.630  56.363  1.00 13.27           O  
ATOM   2229  CB  ILE B  57      40.972  27.698  59.109  1.00 11.49           C  
ATOM   2230  CG1 ILE B  57      42.328  27.929  59.777  1.00 12.46           C  
ATOM   2231  CG2 ILE B  57      41.062  26.585  58.063  1.00 11.71           C  
ATOM   2232  CD1 ILE B  57      42.771  26.800  60.687  1.00 13.98           C  
ATOM   2233  N   GLY B  58      38.117  28.617  58.208  1.00 11.13           N  
ATOM   2234  CA  GLY B  58      36.902  28.337  57.466  1.00 12.45           C  
ATOM   2235  C   GLY B  58      36.419  26.901  57.604  1.00 13.88           C  
ATOM   2236  O   GLY B  58      35.918  26.327  56.634  1.00 16.72           O  
ATOM   2237  N   THR B  59      36.559  26.311  58.789  1.00 13.90           N  
ATOM   2238  CA  THR B  59      36.098  24.932  58.995  1.00 12.61           C  
ATOM   2239  C   THR B  59      34.657  24.957  59.490  1.00 13.22           C  
ATOM   2240  O   THR B  59      34.254  25.881  60.195  1.00 14.00           O  
ATOM   2241  CB  THR B  59      36.980  24.167  60.021  1.00 12.85           C  
ATOM   2242  OG1 THR B  59      36.878  24.780  61.311  1.00 12.56           O  
ATOM   2243  CG2 THR B  59      38.443  24.182  59.579  1.00 12.11           C  
ATOM   2244  N   SER B  60      33.888  23.937  59.122  1.00 13.12           N  
ATOM   2245  CA  SER B  60      32.478  23.863  59.496  1.00 14.13           C  
ATOM   2246  C   SER B  60      32.138  22.781  60.513  1.00 14.68           C  
ATOM   2247  O   SER B  60      31.016  22.732  61.022  1.00 15.54           O  
ATOM   2248  CB  SER B  60      31.620  23.638  58.251  1.00 14.43           C  
ATOM   2249  OG  SER B  60      31.816  22.327  57.740  1.00 15.72           O  
ATOM   2250  N   GLY B  61      33.086  21.902  60.804  1.00 15.17           N  
ATOM   2251  CA  GLY B  61      32.800  20.860  61.768  1.00 15.92           C  
ATOM   2252  C   GLY B  61      33.007  21.357  63.184  1.00 14.55           C  
ATOM   2253  O   GLY B  61      33.563  22.436  63.398  1.00 14.63           O  
ATOM   2254  N   PRO B  62      32.539  20.602  64.182  1.00 14.34           N  
ATOM   2255  CA  PRO B  62      32.724  21.030  65.569  1.00 13.68           C  
ATOM   2256  C   PRO B  62      34.225  21.080  65.855  1.00 13.46           C  
ATOM   2257  O   PRO B  62      35.009  20.430  65.160  1.00 14.98           O  
ATOM   2258  CB  PRO B  62      32.063  19.906  66.368  1.00 14.21           C  
ATOM   2259  CG  PRO B  62      31.016  19.388  65.449  1.00 15.15           C  
ATOM   2260  CD  PRO B  62      31.706  19.389  64.102  1.00 14.42           C  
ATOM   2261  N   VAL B  63      34.633  21.859  66.848  1.00 13.93           N  
ATOM   2262  CA  VAL B  63      36.042  21.877  67.214  1.00 14.14           C  
ATOM   2263  C   VAL B  63      36.162  21.128  68.533  1.00 15.24           C  
ATOM   2264  O   VAL B  63      35.279  21.213  69.388  1.00 15.94           O  
ATOM   2265  CB  VAL B  63      36.615  23.307  67.376  1.00 14.49           C  
ATOM   2266  CG1 VAL B  63      36.589  24.021  66.035  1.00 13.25           C  
ATOM   2267  CG2 VAL B  63      35.838  24.084  68.422  1.00 15.71           C  
ATOM   2268  N   VAL B  64      37.241  20.369  68.670  1.00 15.05           N  
ATOM   2269  CA  VAL B  64      37.511  19.595  69.879  1.00 14.49           C  
ATOM   2270  C   VAL B  64      38.726  20.251  70.528  1.00 15.13           C  
ATOM   2271  O   VAL B  64      39.821  20.227  69.964  1.00 15.95           O  
ATOM   2272  CB  VAL B  64      37.835  18.129  69.527  1.00 14.67           C  
ATOM   2273  CG1 VAL B  64      38.152  17.346  70.790  1.00 14.52           C  
ATOM   2274  CG2 VAL B  64      36.661  17.497  68.785  1.00 13.30           C  
ATOM   2275  N   ALA B  65      38.536  20.844  71.705  1.00 14.49           N  
ATOM   2276  CA  ALA B  65      39.628  21.529  72.393  1.00 15.13           C  
ATOM   2277  C   ALA B  65      39.931  20.952  73.772  1.00 16.05           C  
ATOM   2278  O   ALA B  65      39.302  19.982  74.200  1.00 15.08           O  
ATOM   2279  CB  ALA B  65      39.319  23.020  72.502  1.00 14.00           C  
ATOM   2280  N   GLU B  66      40.894  21.558  74.462  1.00 15.86           N  
ATOM   2281  CA  GLU B  66      41.318  21.088  75.781  1.00 16.35           C  
ATOM   2282  C   GLU B  66      41.539  19.577  75.754  1.00 18.51           C  
ATOM   2283  O   GLU B  66      41.168  18.862  76.688  1.00 17.03           O  
ATOM   2284  CB  GLU B  66      40.278  21.453  76.849  1.00 15.45           C  
ATOM   2285  CG  GLU B  66      40.175  22.947  77.124  1.00 15.66           C  
ATOM   2286  CD  GLU B  66      39.468  23.249  78.434  1.00 16.66           C  
ATOM   2287  OE1 GLU B  66      39.923  22.740  79.479  1.00 17.72           O  
ATOM   2288  OE2 GLU B  66      38.470  23.999  78.427  1.00 16.03           O  
ATOM   2289  N   ASP B  67      42.152  19.105  74.672  1.00 16.32           N  
ATOM   2290  CA  ASP B  67      42.435  17.687  74.473  1.00 18.68           C  
ATOM   2291  C   ASP B  67      41.215  16.790  74.640  1.00 18.73           C  
ATOM   2292  O   ASP B  67      41.307  15.692  75.195  1.00 18.92           O  
ATOM   2293  CB  ASP B  67      43.561  17.222  75.407  1.00 21.84           C  
ATOM   2294  CG  ASP B  67      44.925  17.725  74.967  1.00 24.42           C  
ATOM   2295  OD1 ASP B  67      45.182  17.742  73.743  1.00 26.95           O  
ATOM   2296  OD2 ASP B  67      45.746  18.088  75.836  1.00 27.84           O  
ATOM   2297  N   GLY B  68      40.073  17.261  74.147  1.00 17.44           N  
ATOM   2298  CA  GLY B  68      38.851  16.483  74.225  1.00 19.19           C  
ATOM   2299  C   GLY B  68      37.930  16.869  75.363  1.00 19.43           C  
ATOM   2300  O   GLY B  68      36.854  16.294  75.513  1.00 22.47           O  
ATOM   2301  N   GLY B  69      38.347  17.849  76.157  1.00 18.91           N  
ATOM   2302  CA  GLY B  69      37.546  18.282  77.286  1.00 19.51           C  
ATOM   2303  C   GLY B  69      36.478  19.293  76.931  1.00 19.65           C  
ATOM   2304  O   GLY B  69      35.478  19.416  77.636  1.00 18.15           O  
ATOM   2305  N   ALA B  70      36.686  20.022  75.839  1.00 18.12           N  
ATOM   2306  CA  ALA B  70      35.732  21.034  75.409  1.00 18.18           C  
ATOM   2307  C   ALA B  70      35.391  20.866  73.938  1.00 18.72           C  
ATOM   2308  O   ALA B  70      36.239  20.494  73.129  1.00 18.56           O  
ATOM   2309  CB  ALA B  70      36.299  22.422  75.655  1.00 18.07           C  
ATOM   2310  N   ILE B  71      34.135  21.130  73.603  1.00 17.55           N  
ATOM   2311  CA  ILE B  71      33.677  21.024  72.230  1.00 18.05           C  
ATOM   2312  C   ILE B  71      32.832  22.244  71.924  1.00 17.85           C  
ATOM   2313  O   ILE B  71      32.083  22.720  72.772  1.00 16.68           O  
ATOM   2314  CB  ILE B  71      32.824  19.756  72.020  1.00 20.23           C  
ATOM   2315  CG1 ILE B  71      33.667  18.521  72.340  1.00 23.22           C  
ATOM   2316  CG2 ILE B  71      32.333  19.682  70.582  1.00 21.39           C  
ATOM   2317  CD1 ILE B  71      32.902  17.225  72.278  1.00 27.56           C  
ATOM   2318  N   SER B  72      32.975  22.782  70.722  1.00 16.33           N  
ATOM   2319  CA  SER B  72      32.167  23.931  70.348  1.00 16.36           C  
ATOM   2320  C   SER B  72      31.676  23.725  68.930  1.00 15.82           C  
ATOM   2321  O   SER B  72      32.441  23.319  68.057  1.00 16.35           O  
ATOM   2322  CB  SER B  72      32.972  25.225  70.437  1.00 14.75           C  
ATOM   2323  OG  SER B  72      32.114  26.346  70.297  1.00 16.00           O  
ATOM   2324  N   TYR B  73      30.400  24.011  68.701  1.00 14.45           N  
ATOM   2325  CA  TYR B  73      29.804  23.837  67.388  1.00 15.15           C  
ATOM   2326  C   TYR B  73      28.653  24.816  67.257  1.00 16.85           C  
ATOM   2327  O   TYR B  73      27.766  24.858  68.108  1.00 16.30           O  
ATOM   2328  CB  TYR B  73      29.316  22.402  67.228  1.00 15.35           C  
ATOM   2329  CG  TYR B  73      28.717  22.079  65.881  1.00 16.15           C  
ATOM   2330  CD1 TYR B  73      27.447  21.515  65.784  1.00 17.63           C  
ATOM   2331  CD2 TYR B  73      29.426  22.310  64.704  1.00 15.74           C  
ATOM   2332  CE1 TYR B  73      26.895  21.183  64.541  1.00 21.53           C  
ATOM   2333  CE2 TYR B  73      28.889  21.984  63.462  1.00 19.01           C  
ATOM   2334  CZ  TYR B  73      27.626  21.421  63.385  1.00 20.12           C  
ATOM   2335  OH  TYR B  73      27.088  21.076  62.163  1.00 22.39           O  
ATOM   2336  N   LYS B  74      28.669  25.619  66.204  1.00 16.74           N  
ATOM   2337  CA  LYS B  74      27.606  26.598  65.996  1.00 18.80           C  
ATOM   2338  C   LYS B  74      27.370  27.514  67.178  1.00 18.43           C  
ATOM   2339  O   LYS B  74      26.224  27.841  67.528  1.00 18.60           O  
ATOM   2340  CB  LYS B  74      26.303  25.914  65.602  1.00 21.56           C  
ATOM   2341  CG  LYS B  74      26.135  25.769  64.108  1.00 28.30           C  
ATOM   2342  CD  LYS B  74      25.706  24.375  63.721  1.00 31.46           C  
ATOM   2343  CE  LYS B  74      25.378  24.337  62.234  1.00 33.49           C  
ATOM   2344  NZ  LYS B  74      26.555  24.546  61.333  1.00 35.05           N  
ATOM   2345  N   LYS B  75      28.475  27.964  67.757  1.00 18.49           N  
ATOM   2346  CA  LYS B  75      28.435  28.870  68.896  1.00 18.47           C  
ATOM   2347  C   LYS B  75      27.929  28.278  70.211  1.00 18.50           C  
ATOM   2348  O   LYS B  75      27.633  29.013  71.162  1.00 21.03           O  
ATOM   2349  CB  LYS B  75      27.624  30.123  68.551  1.00 18.85           C  
ATOM   2350  CG  LYS B  75      28.162  30.866  67.345  1.00 21.44           C  
ATOM   2351  CD  LYS B  75      27.332  32.101  67.058  1.00 24.01           C  
ATOM   2352  CE  LYS B  75      27.802  32.784  65.789  1.00 27.32           C  
ATOM   2353  NZ  LYS B  75      26.652  33.089  64.895  1.00 32.18           N  
ATOM   2354  N   LYS B  76      27.860  26.955  70.279  1.00 17.32           N  
ATOM   2355  CA  LYS B  76      27.419  26.297  71.499  1.00 18.63           C  
ATOM   2356  C   LYS B  76      28.577  25.516  72.085  1.00 17.91           C  
ATOM   2357  O   LYS B  76      29.077  24.581  71.466  1.00 18.02           O  
ATOM   2358  CB  LYS B  76      26.248  25.352  71.224  1.00 20.69           C  
ATOM   2359  CG  LYS B  76      25.753  24.600  72.469  1.00 22.22           C  
ATOM   2360  CD  LYS B  76      25.251  25.556  73.550  1.00 23.35           C  
ATOM   2361  CE  LYS B  76      24.699  24.796  74.753  1.00 25.66           C  
ATOM   2362  NZ  LYS B  76      24.129  25.710  75.781  1.00 26.93           N  
ATOM   2363  N   ARG B  77      29.001  25.911  73.282  1.00 15.83           N  
ATOM   2364  CA  ARG B  77      30.100  25.248  73.964  1.00 17.38           C  
ATOM   2365  C   ARG B  77      29.607  24.163  74.909  1.00 17.86           C  
ATOM   2366  O   ARG B  77      28.619  24.347  75.625  1.00 19.41           O  
ATOM   2367  CB  ARG B  77      30.918  26.265  74.753  1.00 15.92           C  
ATOM   2368  CG  ARG B  77      31.608  27.289  73.889  1.00 17.48           C  
ATOM   2369  CD  ARG B  77      32.273  28.355  74.733  1.00 16.35           C  
ATOM   2370  NE  ARG B  77      32.969  29.331  73.898  1.00 15.62           N  
ATOM   2371  CZ  ARG B  77      33.547  30.437  74.351  1.00 14.80           C  
ATOM   2372  NH1 ARG B  77      33.522  30.728  75.647  1.00 16.21           N  
ATOM   2373  NH2 ARG B  77      34.162  31.253  73.508  1.00 15.46           N  
ATOM   2374  N   ILE B  78      30.303  23.035  74.908  1.00 17.26           N  
ATOM   2375  CA  ILE B  78      29.957  21.911  75.771  1.00 19.88           C  
ATOM   2376  C   ILE B  78      31.234  21.398  76.409  1.00 21.11           C  
ATOM   2377  O   ILE B  78      32.182  21.036  75.710  1.00 19.81           O  
ATOM   2378  CB  ILE B  78      29.311  20.754  74.975  1.00 21.41           C  
ATOM   2379  CG1 ILE B  78      27.976  21.206  74.381  1.00 22.17           C  
ATOM   2380  CG2 ILE B  78      29.099  19.540  75.887  1.00 23.06           C  
ATOM   2381  CD1 ILE B  78      26.949  21.604  75.423  1.00 24.78           C  
ATOM   2382  N   PHE B  79      31.263  21.372  77.737  1.00 20.56           N  
ATOM   2383  CA  PHE B  79      32.439  20.887  78.447  1.00 22.00           C  
ATOM   2384  C   PHE B  79      32.155  19.496  79.006  1.00 23.15           C  
ATOM   2385  O   PHE B  79      31.139  19.278  79.666  1.00 24.92           O  
ATOM   2386  CB  PHE B  79      32.817  21.865  79.557  1.00 21.25           C  
ATOM   2387  CG  PHE B  79      33.145  23.245  79.054  1.00 22.40           C  
ATOM   2388  CD1 PHE B  79      32.139  24.179  78.836  1.00 23.36           C  
ATOM   2389  CD2 PHE B  79      34.461  23.601  78.771  1.00 23.83           C  
ATOM   2390  CE1 PHE B  79      32.436  25.450  78.346  1.00 22.34           C  
ATOM   2391  CE2 PHE B  79      34.770  24.870  78.280  1.00 21.56           C  
ATOM   2392  CZ  PHE B  79      33.756  25.796  78.066  1.00 22.06           C  
ATOM   2393  N   LEU B  80      33.055  18.555  78.733  1.00 23.44           N  
ATOM   2394  CA  LEU B  80      32.873  17.177  79.170  1.00 23.58           C  
ATOM   2395  C   LEU B  80      33.420  16.857  80.554  1.00 23.67           C  
ATOM   2396  O   LEU B  80      33.448  15.693  80.965  1.00 23.64           O  
ATOM   2397  CB  LEU B  80      33.475  16.229  78.131  1.00 24.81           C  
ATOM   2398  CG  LEU B  80      32.849  16.389  76.740  1.00 26.19           C  
ATOM   2399  CD1 LEU B  80      33.446  15.368  75.781  1.00 27.37           C  
ATOM   2400  CD2 LEU B  80      31.335  16.208  76.839  1.00 26.79           C  
ATOM   2401  N   ALA B  81      33.842  17.890  81.271  1.00 22.16           N  
ATOM   2402  CA  ALA B  81      34.374  17.725  82.617  1.00 23.02           C  
ATOM   2403  C   ALA B  81      34.474  19.087  83.277  1.00 22.53           C  
ATOM   2404  O   ALA B  81      34.364  20.116  82.611  1.00 23.15           O  
ATOM   2405  CB  ALA B  81      35.753  17.071  82.566  1.00 23.04           C  
ATOM   2406  N   SER B  82      34.664  19.087  84.592  1.00 23.14           N  
ATOM   2407  CA  SER B  82      34.814  20.319  85.358  1.00 22.45           C  
ATOM   2408  C   SER B  82      36.018  20.119  86.274  1.00 23.36           C  
ATOM   2409  O   SER B  82      36.471  18.991  86.456  1.00 23.21           O  
ATOM   2410  CB  SER B  82      33.556  20.616  86.175  1.00 25.32           C  
ATOM   2411  OG  SER B  82      33.226  19.536  87.023  1.00 27.71           O  
ATOM   2412  N   MET B  83      36.528  21.200  86.853  1.00 21.25           N  
ATOM   2413  CA  MET B  83      37.709  21.106  87.706  1.00 21.98           C  
ATOM   2414  C   MET B  83      37.469  21.229  89.206  1.00 21.68           C  
ATOM   2415  O   MET B  83      36.620  21.997  89.648  1.00 21.88           O  
ATOM   2416  CB  MET B  83      38.733  22.148  87.259  1.00 21.75           C  
ATOM   2417  CG  MET B  83      39.275  21.853  85.870  1.00 23.51           C  
ATOM   2418  SD  MET B  83      40.344  23.124  85.190  1.00 26.48           S  
ATOM   2419  CE  MET B  83      41.868  22.731  85.946  1.00 19.59           C  
ATOM   2420  N   ASP B  84      38.243  20.458  89.972  1.00 19.87           N  
ATOM   2421  CA  ASP B  84      38.172  20.427  91.432  1.00 19.15           C  
ATOM   2422  C   ASP B  84      39.474  19.883  91.999  1.00 15.08           C  
ATOM   2423  O   ASP B  84      40.227  20.604  92.647  1.00 17.27           O  
ATOM   2424  CB  ASP B  84      37.011  19.543  91.905  1.00 21.82           C  
ATOM   2425  CG  ASP B  84      37.017  19.320  93.417  1.00 23.83           C  
ATOM   2426  OD1 ASP B  84      37.453  20.222  94.172  1.00 24.22           O  
ATOM   2427  OD2 ASP B  84      36.571  18.241  93.857  1.00 23.67           O  
ATOM   2428  N   GLU B  85      39.750  18.608  91.739  1.00 15.84           N  
ATOM   2429  CA  GLU B  85      40.971  18.023  92.267  1.00 14.90           C  
ATOM   2430  C   GLU B  85      42.195  18.714  91.700  1.00 13.88           C  
ATOM   2431  O   GLU B  85      43.246  18.739  92.334  1.00 14.34           O  
ATOM   2432  CB  GLU B  85      41.032  16.530  91.971  1.00 16.14           C  
ATOM   2433  CG  GLU B  85      39.833  15.773  92.507  1.00 18.17           C  
ATOM   2434  CD  GLU B  85      40.081  14.288  92.603  1.00 21.87           C  
ATOM   2435  OE1 GLU B  85      40.678  13.727  91.666  1.00 23.49           O  
ATOM   2436  OE2 GLU B  85      39.669  13.682  93.613  1.00 20.91           O  
ATOM   2437  N   GLU B  86      42.054  19.286  90.507  1.00 14.53           N  
ATOM   2438  CA  GLU B  86      43.161  19.993  89.881  1.00 13.00           C  
ATOM   2439  C   GLU B  86      43.617  21.174  90.739  1.00 12.43           C  
ATOM   2440  O   GLU B  86      44.796  21.527  90.738  1.00 14.12           O  
ATOM   2441  CB  GLU B  86      42.757  20.490  88.489  1.00 12.85           C  
ATOM   2442  CG  GLU B  86      42.516  19.371  87.487  1.00 15.57           C  
ATOM   2443  CD  GLU B  86      41.070  18.910  87.429  1.00 17.77           C  
ATOM   2444  OE1 GLU B  86      40.346  19.032  88.441  1.00 15.80           O  
ATOM   2445  OE2 GLU B  86      40.657  18.408  86.363  1.00 18.65           O  
ATOM   2446  N   TRP B  87      42.685  21.789  91.469  1.00 13.40           N  
ATOM   2447  CA  TRP B  87      43.032  22.921  92.326  1.00 14.23           C  
ATOM   2448  C   TRP B  87      43.740  22.416  93.580  1.00 13.85           C  
ATOM   2449  O   TRP B  87      44.595  23.104  94.140  1.00 15.21           O  
ATOM   2450  CB  TRP B  87      41.780  23.705  92.727  1.00 14.07           C  
ATOM   2451  CG  TRP B  87      40.917  24.108  91.569  1.00 14.81           C  
ATOM   2452  CD1 TRP B  87      39.562  23.969  91.481  1.00 17.31           C  
ATOM   2453  CD2 TRP B  87      41.340  24.709  90.335  1.00 16.17           C  
ATOM   2454  NE1 TRP B  87      39.113  24.440  90.269  1.00 16.13           N  
ATOM   2455  CE2 TRP B  87      40.181  24.900  89.548  1.00 17.03           C  
ATOM   2456  CE3 TRP B  87      42.581  25.104  89.818  1.00 17.00           C  
ATOM   2457  CZ2 TRP B  87      40.227  25.466  88.268  1.00 16.07           C  
ATOM   2458  CZ3 TRP B  87      42.626  25.670  88.540  1.00 17.65           C  
ATOM   2459  CH2 TRP B  87      41.453  25.844  87.783  1.00 16.83           C  
ATOM   2460  N   ILE B  88      43.365  21.223  94.034  1.00 14.23           N  
ATOM   2461  CA  ILE B  88      44.006  20.644  95.204  1.00 14.19           C  
ATOM   2462  C   ILE B  88      45.450  20.343  94.819  1.00 14.05           C  
ATOM   2463  O   ILE B  88      46.383  20.612  95.580  1.00 13.76           O  
ATOM   2464  CB  ILE B  88      43.308  19.342  95.638  1.00 14.57           C  
ATOM   2465  CG1 ILE B  88      41.850  19.645  95.994  1.00 16.49           C  
ATOM   2466  CG2 ILE B  88      44.041  18.719  96.822  1.00 15.50           C  
ATOM   2467  CD1 ILE B  88      41.047  18.430  96.443  1.00 16.64           C  
ATOM   2468  N   LEU B  89      45.622  19.801  93.618  1.00 14.29           N  
ATOM   2469  CA  LEU B  89      46.945  19.472  93.109  1.00 15.28           C  
ATOM   2470  C   LEU B  89      47.803  20.716  92.953  1.00 15.48           C  
ATOM   2471  O   LEU B  89      48.924  20.779  93.453  1.00 14.60           O  
ATOM   2472  CB  LEU B  89      46.830  18.769  91.753  1.00 14.82           C  
ATOM   2473  CG  LEU B  89      48.139  18.559  90.983  1.00 14.39           C  
ATOM   2474  CD1 LEU B  89      49.072  17.640  91.775  1.00 15.38           C  
ATOM   2475  CD2 LEU B  89      47.833  17.965  89.608  1.00 14.79           C  
ATOM   2476  N   TRP B  90      47.281  21.722  92.262  1.00 14.84           N  
ATOM   2477  CA  TRP B  90      48.081  22.912  92.058  1.00 15.09           C  
ATOM   2478  C   TRP B  90      48.448  23.623  93.344  1.00 15.89           C  
ATOM   2479  O   TRP B  90      49.544  24.158  93.466  1.00 15.09           O  
ATOM   2480  CB  TRP B  90      47.400  23.904  91.114  1.00 15.81           C  
ATOM   2481  CG  TRP B  90      48.332  25.043  90.818  1.00 16.28           C  
ATOM   2482  CD1 TRP B  90      48.264  26.317  91.312  1.00 17.35           C  
ATOM   2483  CD2 TRP B  90      49.556  24.969  90.075  1.00 14.63           C  
ATOM   2484  NE1 TRP B  90      49.376  27.032  90.932  1.00 16.79           N  
ATOM   2485  CE2 TRP B  90      50.186  26.228  90.176  1.00 16.08           C  
ATOM   2486  CE3 TRP B  90      50.188  23.950  89.347  1.00 16.59           C  
ATOM   2487  CZ2 TRP B  90      51.416  26.505  89.567  1.00 16.63           C  
ATOM   2488  CZ3 TRP B  90      51.416  24.225  88.739  1.00 16.49           C  
ATOM   2489  CH2 TRP B  90      52.015  25.491  88.859  1.00 17.46           C  
ATOM   2490  N   ASN B  91      47.555  23.630  94.326  1.00 15.80           N  
ATOM   2491  CA  ASN B  91      47.871  24.319  95.570  1.00 15.64           C  
ATOM   2492  C   ASN B  91      49.062  23.645  96.261  1.00 17.44           C  
ATOM   2493  O   ASN B  91      49.877  24.321  96.902  1.00 16.67           O  
ATOM   2494  CB  ASN B  91      46.661  24.344  96.510  1.00 15.73           C  
ATOM   2495  CG  ASN B  91      46.847  25.329  97.646  1.00 17.29           C  
ATOM   2496  OD1 ASN B  91      47.505  26.359  97.496  1.00 18.57           O  
ATOM   2497  ND2 ASN B  91      46.248  25.028  98.787  1.00 17.84           N  
ATOM   2498  N   GLU B  92      49.155  22.322  96.130  1.00 16.83           N  
ATOM   2499  CA  GLU B  92      50.262  21.591  96.740  1.00 18.93           C  
ATOM   2500  C   GLU B  92      51.545  21.948  96.008  1.00 19.21           C  
ATOM   2501  O   GLU B  92      52.577  22.167  96.636  1.00 18.73           O  
ATOM   2502  CB  GLU B  92      50.031  20.084  96.663  1.00 20.65           C  
ATOM   2503  CG  GLU B  92      51.121  19.259  97.384  1.00 25.48           C  
ATOM   2504  CD  GLU B  92      51.087  19.478  98.895  1.00 29.74           C  
ATOM   2505  OE1 GLU B  92      50.196  20.204  99.390  1.00 31.01           O  
ATOM   2506  OE2 GLU B  92      51.938  18.889  99.593  1.00 33.32           O  
ATOM   2507  N   ILE B  93      51.474  22.010  94.678  1.00 17.73           N  
ATOM   2508  CA  ILE B  93      52.639  22.350  93.859  1.00 17.65           C  
ATOM   2509  C   ILE B  93      53.119  23.761  94.175  1.00 19.48           C  
ATOM   2510  O   ILE B  93      54.321  24.022  94.246  1.00 19.64           O  
ATOM   2511  CB  ILE B  93      52.303  22.262  92.351  1.00 17.87           C  
ATOM   2512  CG1 ILE B  93      52.052  20.805  91.965  1.00 17.49           C  
ATOM   2513  CG2 ILE B  93      53.447  22.829  91.524  1.00 18.82           C  
ATOM   2514  CD1 ILE B  93      51.674  20.605  90.517  1.00 18.91           C  
ATOM   2515  N   ARG B  94      52.166  24.669  94.363  1.00 19.45           N  
ATOM   2516  CA  ARG B  94      52.476  26.059  94.678  1.00 21.45           C  
ATOM   2517  C   ARG B  94      53.315  26.140  95.947  1.00 22.66           C  
ATOM   2518  O   ARG B  94      54.343  26.815  95.985  1.00 23.06           O  
ATOM   2519  CB  ARG B  94      51.181  26.853  94.875  1.00 20.54           C  
ATOM   2520  CG  ARG B  94      51.389  28.273  95.394  1.00 23.14           C  
ATOM   2521  CD  ARG B  94      50.066  28.987  95.626  1.00 24.20           C  
ATOM   2522  NE  ARG B  94      49.338  28.472  96.782  1.00 24.53           N  
ATOM   2523  CZ  ARG B  94      49.658  28.732  98.046  1.00 24.83           C  
ATOM   2524  NH1 ARG B  94      50.698  29.507  98.322  1.00 26.37           N  
ATOM   2525  NH2 ARG B  94      48.937  28.220  99.035  1.00 23.61           N  
ATOM   2526  N   LYS B  95      52.873  25.437  96.984  1.00 23.74           N  
ATOM   2527  CA  LYS B  95      53.568  25.454  98.266  1.00 24.91           C  
ATOM   2528  C   LYS B  95      54.915  24.740  98.270  1.00 25.41           C  
ATOM   2529  O   LYS B  95      55.841  25.163  98.959  1.00 26.04           O  
ATOM   2530  CB  LYS B  95      52.691  24.833  99.355  1.00 25.22           C  
ATOM   2531  CG  LYS B  95      51.353  25.512  99.586  1.00 27.55           C  
ATOM   2532  CD  LYS B  95      50.680  24.890 100.797  1.00 29.21           C  
ATOM   2533  CE  LYS B  95      49.232  24.546 100.525  1.00 30.42           C  
ATOM   2534  NZ  LYS B  95      48.690  23.636 101.579  1.00 29.37           N  
ATOM   2535  N   ARG B  96      55.026  23.663  97.500  1.00 25.25           N  
ATOM   2536  CA  ARG B  96      56.258  22.881  97.468  1.00 25.93           C  
ATOM   2537  C   ARG B  96      57.240  23.219  96.352  1.00 26.21           C  
ATOM   2538  O   ARG B  96      58.440  22.976  96.481  1.00 25.96           O  
ATOM   2539  CB  ARG B  96      55.897  21.396  97.421  1.00 26.92           C  
ATOM   2540  CG  ARG B  96      55.129  20.948  98.659  1.00 30.58           C  
ATOM   2541  CD  ARG B  96      54.426  19.622  98.456  1.00 30.93           C  
ATOM   2542  NE  ARG B  96      55.348  18.572  98.044  1.00 33.31           N  
ATOM   2543  CZ  ARG B  96      55.027  17.285  97.980  1.00 34.14           C  
ATOM   2544  NH1 ARG B  96      53.803  16.887  98.304  1.00 33.69           N  
ATOM   2545  NH2 ARG B  96      55.929  16.395  97.589  1.00 35.70           N  
ATOM   2546  N   PHE B  97      56.735  23.782  95.262  1.00 25.74           N  
ATOM   2547  CA  PHE B  97      57.583  24.148  94.134  1.00 26.25           C  
ATOM   2548  C   PHE B  97      57.205  25.552  93.682  1.00 27.26           C  
ATOM   2549  O   PHE B  97      56.446  25.730  92.730  1.00 26.48           O  
ATOM   2550  CB  PHE B  97      57.393  23.137  93.008  1.00 27.48           C  
ATOM   2551  CG  PHE B  97      57.784  21.741  93.391  1.00 28.23           C  
ATOM   2552  CD1 PHE B  97      59.122  21.363  93.410  1.00 29.97           C  
ATOM   2553  CD2 PHE B  97      56.822  20.820  93.788  1.00 29.55           C  
ATOM   2554  CE1 PHE B  97      59.498  20.086  93.823  1.00 30.62           C  
ATOM   2555  CE2 PHE B  97      57.187  19.540  94.204  1.00 30.78           C  
ATOM   2556  CZ  PHE B  97      58.529  19.174  94.220  1.00 30.24           C  
ATOM   2557  N   PRO B  98      57.744  26.573  94.367  1.00 28.33           N  
ATOM   2558  CA  PRO B  98      57.498  27.992  94.096  1.00 28.84           C  
ATOM   2559  C   PRO B  98      57.834  28.499  92.695  1.00 28.76           C  
ATOM   2560  O   PRO B  98      57.408  29.588  92.318  1.00 28.83           O  
ATOM   2561  CB  PRO B  98      58.310  28.693  95.185  1.00 30.04           C  
ATOM   2562  CG  PRO B  98      59.450  27.752  95.408  1.00 29.73           C  
ATOM   2563  CD  PRO B  98      58.751  26.417  95.433  1.00 29.19           C  
ATOM   2564  N   ASN B  99      58.590  27.720  91.928  1.00 28.77           N  
ATOM   2565  CA  ASN B  99      58.953  28.132  90.576  1.00 28.25           C  
ATOM   2566  C   ASN B  99      58.016  27.555  89.518  1.00 27.32           C  
ATOM   2567  O   ASN B  99      58.027  27.990  88.366  1.00 25.86           O  
ATOM   2568  CB  ASN B  99      60.395  27.727  90.256  1.00 31.28           C  
ATOM   2569  CG  ASN B  99      61.401  28.364  91.196  1.00 34.23           C  
ATOM   2570  OD1 ASN B  99      61.312  29.553  91.510  1.00 34.72           O  
ATOM   2571  ND2 ASN B  99      62.373  27.576  91.642  1.00 35.76           N  
ATOM   2572  N   ALA B 100      57.209  26.575  89.911  1.00 24.58           N  
ATOM   2573  CA  ALA B 100      56.262  25.951  88.994  1.00 23.24           C  
ATOM   2574  C   ALA B 100      55.213  26.974  88.554  1.00 22.35           C  
ATOM   2575  O   ALA B 100      54.772  27.805  89.347  1.00 21.19           O  
ATOM   2576  CB  ALA B 100      55.588  24.767  89.668  1.00 21.83           C  
ATOM   2577  N   ARG B 101      54.820  26.908  87.285  1.00 21.69           N  
ATOM   2578  CA  ARG B 101      53.833  27.833  86.734  1.00 21.65           C  
ATOM   2579  C   ARG B 101      52.802  27.127  85.857  1.00 18.56           C  
ATOM   2580  O   ARG B 101      53.076  26.079  85.269  1.00 18.19           O  
ATOM   2581  CB  ARG B 101      54.533  28.899  85.887  1.00 21.44           C  
ATOM   2582  CG  ARG B 101      55.497  29.793  86.646  1.00 23.42           C  
ATOM   2583  CD  ARG B 101      54.753  30.810  87.486  1.00 24.89           C  
ATOM   2584  NE  ARG B 101      55.665  31.700  88.201  1.00 29.33           N  
ATOM   2585  CZ  ARG B 101      56.397  31.338  89.248  1.00 30.27           C  
ATOM   2586  NH1 ARG B 101      56.327  30.100  89.715  1.00 32.29           N  
ATOM   2587  NH2 ARG B 101      57.207  32.214  89.826  1.00 33.58           N  
ATOM   2588  N   THR B 102      51.612  27.715  85.776  1.00 19.14           N  
ATOM   2589  CA  THR B 102      50.549  27.178  84.939  1.00 18.00           C  
ATOM   2590  C   THR B 102      50.397  28.107  83.737  1.00 17.67           C  
ATOM   2591  O   THR B 102      50.869  29.247  83.759  1.00 17.65           O  
ATOM   2592  CB  THR B 102      49.200  27.107  85.686  1.00 18.90           C  
ATOM   2593  OG1 THR B 102      48.934  28.359  86.324  1.00 19.28           O  
ATOM   2594  CG2 THR B 102      49.225  25.997  86.725  1.00 18.60           C  
ATOM   2595  N   SER B 103      49.748  27.613  82.692  1.00 16.75           N  
ATOM   2596  CA  SER B 103      49.535  28.395  81.480  1.00 17.24           C  
ATOM   2597  C   SER B 103      48.720  29.669  81.707  1.00 17.09           C  
ATOM   2598  O   SER B 103      47.775  29.685  82.495  1.00 17.12           O  
ATOM   2599  CB  SER B 103      48.839  27.537  80.424  1.00 16.80           C  
ATOM   2600  OG  SER B 103      48.466  28.326  79.307  1.00 19.11           O  
ATOM   2601  N   TYR B 104      49.090  30.732  80.998  1.00 16.81           N  
ATOM   2602  CA  TYR B 104      48.382  32.003  81.102  1.00 16.93           C  
ATOM   2603  C   TYR B 104      46.931  31.850  80.639  1.00 16.06           C  
ATOM   2604  O   TYR B 104      46.091  32.710  80.908  1.00 15.09           O  
ATOM   2605  CB  TYR B 104      49.091  33.076  80.258  1.00 18.46           C  
ATOM   2606  CG  TYR B 104      48.901  32.941  78.756  1.00 20.40           C  
ATOM   2607  CD1 TYR B 104      48.002  33.762  78.069  1.00 20.92           C  
ATOM   2608  CD2 TYR B 104      49.622  31.999  78.024  1.00 20.28           C  
ATOM   2609  CE1 TYR B 104      47.830  33.646  76.691  1.00 22.11           C  
ATOM   2610  CE2 TYR B 104      49.457  31.876  76.644  1.00 22.41           C  
ATOM   2611  CZ  TYR B 104      48.560  32.701  75.986  1.00 22.99           C  
ATOM   2612  OH  TYR B 104      48.389  32.561  74.626  1.00 24.73           O  
ATOM   2613  N   THR B 105      46.634  30.748  79.955  1.00 16.57           N  
ATOM   2614  CA  THR B 105      45.277  30.506  79.462  1.00 15.24           C  
ATOM   2615  C   THR B 105      44.357  29.796  80.463  1.00 15.10           C  
ATOM   2616  O   THR B 105      43.216  29.482  80.138  1.00 13.65           O  
ATOM   2617  CB  THR B 105      45.283  29.664  78.165  1.00 16.96           C  
ATOM   2618  OG1 THR B 105      45.876  28.386  78.425  1.00 17.43           O  
ATOM   2619  CG2 THR B 105      46.063  30.374  77.070  1.00 18.35           C  
ATOM   2620  N   MET B 106      44.828  29.552  81.682  1.00 15.45           N  
ATOM   2621  CA  MET B 106      43.974  28.857  82.643  1.00 15.15           C  
ATOM   2622  C   MET B 106      42.586  29.469  82.873  1.00 15.63           C  
ATOM   2623  O   MET B 106      41.624  28.738  83.095  1.00 16.48           O  
ATOM   2624  CB  MET B 106      44.701  28.661  83.982  1.00 14.81           C  
ATOM   2625  CG  MET B 106      45.681  27.472  83.984  1.00 13.99           C  
ATOM   2626  SD  MET B 106      45.014  25.939  83.266  1.00 16.29           S  
ATOM   2627  CE  MET B 106      43.520  25.702  84.264  1.00 14.44           C  
ATOM   2628  N   PRO B 107      42.458  30.810  82.830  1.00 15.96           N  
ATOM   2629  CA  PRO B 107      41.136  31.417  83.040  1.00 16.70           C  
ATOM   2630  C   PRO B 107      40.099  30.950  82.006  1.00 16.16           C  
ATOM   2631  O   PRO B 107      38.898  30.934  82.279  1.00 17.12           O  
ATOM   2632  CB  PRO B 107      41.417  32.913  82.908  1.00 16.05           C  
ATOM   2633  CG  PRO B 107      42.843  33.037  83.352  1.00 18.81           C  
ATOM   2634  CD  PRO B 107      43.500  31.846  82.711  1.00 17.31           C  
ATOM   2635  N   ASP B 108      40.577  30.561  80.826  1.00 16.45           N  
ATOM   2636  CA  ASP B 108      39.712  30.121  79.733  1.00 15.39           C  
ATOM   2637  C   ASP B 108      39.315  28.652  79.769  1.00 15.43           C  
ATOM   2638  O   ASP B 108      38.365  28.252  79.100  1.00 15.39           O  
ATOM   2639  CB  ASP B 108      40.394  30.336  78.372  1.00 15.87           C  
ATOM   2640  CG  ASP B 108      41.091  31.671  78.250  1.00 15.02           C  
ATOM   2641  OD1 ASP B 108      40.639  32.649  78.871  1.00 16.67           O  
ATOM   2642  OD2 ASP B 108      42.098  31.736  77.502  1.00 15.65           O  
ATOM   2643  N   ARG B 109      40.053  27.853  80.533  1.00 15.95           N  
ATOM   2644  CA  ARG B 109      39.844  26.392  80.538  1.00 15.03           C  
ATOM   2645  C   ARG B 109      38.920  25.889  81.677  1.00 14.81           C  
ATOM   2646  O   ARG B 109      38.840  26.473  82.751  1.00 17.57           O  
ATOM   2647  CB  ARG B 109      41.211  25.712  80.652  1.00 15.30           C  
ATOM   2648  CG  ARG B 109      42.139  26.038  79.480  1.00 14.31           C  
ATOM   2649  CD  ARG B 109      43.555  25.496  79.712  1.00 13.14           C  
ATOM   2650  NE  ARG B 109      44.463  25.914  78.638  1.00 12.51           N  
ATOM   2651  CZ  ARG B 109      44.608  25.077  77.595  1.00 14.65           C  
ATOM   2652  NH1 ARG B 109      43.921  23.949  77.549  1.00 16.10           N  
ATOM   2653  NH2 ARG B 109      45.484  25.371  76.629  1.00 15.41           N  
ATOM   2654  N   ARG B 110      38.241  24.787  81.385  1.00 17.06           N  
ATOM   2655  CA  ARG B 110      37.329  24.187  82.351  1.00 18.83           C  
ATOM   2656  C   ARG B 110      37.480  22.674  82.496  1.00 19.26           C  
ATOM   2657  O   ARG B 110      36.849  22.073  83.367  1.00 19.27           O  
ATOM   2658  CB  ARG B 110      35.882  24.523  81.970  1.00 21.05           C  
ATOM   2659  CG  ARG B 110      35.575  26.015  81.992  1.00 23.61           C  
ATOM   2660  CD  ARG B 110      34.113  26.309  81.706  1.00 26.47           C  
ATOM   2661  NE  ARG B 110      33.846  27.745  81.728  1.00 30.96           N  
ATOM   2662  CZ  ARG B 110      32.647  28.293  81.551  1.00 33.98           C  
ATOM   2663  NH1 ARG B 110      31.586  27.526  81.337  1.00 34.50           N  
ATOM   2664  NH2 ARG B 110      32.509  29.612  81.585  1.00 35.51           N  
ATOM   2665  N   ALA B 111      38.317  22.055  81.665  1.00 18.15           N  
ATOM   2666  CA  ALA B 111      38.487  20.606  81.722  1.00 16.27           C  
ATOM   2667  C   ALA B 111      39.934  20.122  81.726  1.00 16.62           C  
ATOM   2668  O   ALA B 111      40.249  19.073  81.163  1.00 19.00           O  
ATOM   2669  CB  ALA B 111      37.724  19.953  80.567  1.00 16.48           C  
ATOM   2670  N   GLY B 112      40.815  20.880  82.363  1.00 15.75           N  
ATOM   2671  CA  GLY B 112      42.204  20.467  82.414  1.00 16.74           C  
ATOM   2672  C   GLY B 112      43.153  21.546  82.880  1.00 16.83           C  
ATOM   2673  O   GLY B 112      43.031  22.712  82.505  1.00 18.37           O  
ATOM   2674  N   LEU B 113      44.107  21.147  83.712  1.00 16.92           N  
ATOM   2675  CA  LEU B 113      45.108  22.059  84.235  1.00 17.02           C  
ATOM   2676  C   LEU B 113      46.321  21.980  83.316  1.00 17.21           C  
ATOM   2677  O   LEU B 113      46.827  20.892  83.049  1.00 20.63           O  
ATOM   2678  CB  LEU B 113      45.502  21.627  85.652  1.00 18.74           C  
ATOM   2679  CG  LEU B 113      46.522  22.497  86.382  1.00 19.37           C  
ATOM   2680  CD1 LEU B 113      45.926  23.870  86.658  1.00 20.40           C  
ATOM   2681  CD2 LEU B 113      46.923  21.814  87.681  1.00 19.31           C  
ATOM   2682  N   VAL B 114      46.785  23.125  82.825  1.00 15.44           N  
ATOM   2683  CA  VAL B 114      47.947  23.140  81.942  1.00 16.03           C  
ATOM   2684  C   VAL B 114      49.138  23.735  82.685  1.00 15.66           C  
ATOM   2685  O   VAL B 114      49.100  24.880  83.141  1.00 16.27           O  
ATOM   2686  CB  VAL B 114      47.665  23.941  80.652  1.00 14.86           C  
ATOM   2687  CG1 VAL B 114      48.910  23.972  79.772  1.00 17.43           C  
ATOM   2688  CG2 VAL B 114      46.507  23.304  79.900  1.00 17.05           C  
ATOM   2689  N   ILE B 115      50.189  22.931  82.804  1.00 16.80           N  
ATOM   2690  CA  ILE B 115      51.397  23.314  83.512  1.00 17.63           C  
ATOM   2691  C   ILE B 115      52.578  23.488  82.564  1.00 19.12           C  
ATOM   2692  O   ILE B 115      52.754  22.709  81.621  1.00 19.88           O  
ATOM   2693  CB  ILE B 115      51.745  22.242  84.571  1.00 18.29           C  
ATOM   2694  CG1 ILE B 115      50.553  22.043  85.513  1.00 18.82           C  
ATOM   2695  CG2 ILE B 115      52.978  22.657  85.361  1.00 19.24           C  
ATOM   2696  CD1 ILE B 115      50.715  20.886  86.493  1.00 16.76           C  
ATOM   2697  N   MET B 116      53.383  24.514  82.828  1.00 21.81           N  
ATOM   2698  CA  MET B 116      54.563  24.811  82.021  1.00 23.53           C  
ATOM   2699  C   MET B 116      55.639  23.771  82.324  1.00 23.89           C  
ATOM   2700  O   MET B 116      56.274  23.802  83.376  1.00 23.65           O  
ATOM   2701  CB  MET B 116      55.069  26.217  82.344  1.00 25.45           C  
ATOM   2702  CG  MET B 116      54.017  27.313  82.148  1.00 27.55           C  
ATOM   2703  SD  MET B 116      53.444  27.435  80.438  1.00 33.56           S  
ATOM   2704  CE  MET B 116      52.080  26.288  80.438  1.00 32.27           C  
ATOM   2705  N   ARG B 117      55.829  22.848  81.388  1.00 25.76           N  
ATOM   2706  CA  ARG B 117      56.791  21.764  81.542  1.00 27.12           C  
ATOM   2707  C   ARG B 117      58.224  22.240  81.827  1.00 28.28           C  
ATOM   2708  O   ARG B 117      59.053  21.452  82.300  1.00 29.38           O  
ATOM   2709  CB  ARG B 117      56.796  20.888  80.282  1.00 28.84           C  
ATOM   2710  CG  ARG B 117      57.373  21.530  79.020  1.00 29.70           C  
ATOM   2711  CD  ARG B 117      57.107  20.670  77.798  1.00 30.56           C  
ATOM   2712  NE  ARG B 117      57.608  19.312  77.972  1.00 30.74           N  
ATOM   2713  CZ  ARG B 117      58.890  18.976  77.891  1.00 32.20           C  
ATOM   2714  NH1 ARG B 117      59.803  19.899  77.632  1.00 31.79           N  
ATOM   2715  NH2 ARG B 117      59.262  17.717  78.069  1.00 33.09           N  
ATOM   2716  N   GLU B 118      58.527  23.504  81.538  1.00 28.97           N  
ATOM   2717  CA  GLU B 118      59.877  24.031  81.748  1.00 29.76           C  
ATOM   2718  C   GLU B 118      60.103  24.443  83.203  1.00 29.09           C  
ATOM   2719  O   GLU B 118      61.239  24.689  83.623  1.00 28.82           O  
ATOM   2720  CB  GLU B 118      60.121  25.225  80.828  1.00 32.72           C  
ATOM   2721  CG  GLU B 118      59.860  24.938  79.345  1.00 34.80           C  
ATOM   2722  CD  GLU B 118      58.417  25.205  78.937  1.00 37.41           C  
ATOM   2723  OE1 GLU B 118      57.576  25.465  79.826  1.00 36.29           O  
ATOM   2724  OE2 GLU B 118      58.121  25.158  77.723  1.00 40.03           O  
ATOM   2725  N   THR B 119      59.006  24.488  83.958  1.00 27.54           N  
ATOM   2726  CA  THR B 119      59.081  24.881  85.358  1.00 26.16           C  
ATOM   2727  C   THR B 119      58.969  23.728  86.351  1.00 25.61           C  
ATOM   2728  O   THR B 119      59.173  23.929  87.541  1.00 26.06           O  
ATOM   2729  CB  THR B 119      57.997  25.942  85.719  1.00 25.99           C  
ATOM   2730  OG1 THR B 119      56.675  25.384  85.614  1.00 24.48           O  
ATOM   2731  CG2 THR B 119      58.132  27.140  84.799  1.00 25.68           C  
ATOM   2732  N   ILE B 120      58.606  22.538  85.875  1.00 25.01           N  
ATOM   2733  CA  ILE B 120      58.472  21.361  86.736  1.00 24.92           C  
ATOM   2734  C   ILE B 120      58.260  20.151  85.831  1.00 25.10           C  
ATOM   2735  O   ILE B 120      57.615  20.263  84.795  1.00 25.90           O  
ATOM   2736  CB  ILE B 120      57.273  21.524  87.703  1.00 23.54           C  
ATOM   2737  CG1 ILE B 120      57.175  20.316  88.637  1.00 22.35           C  
ATOM   2738  CG2 ILE B 120      55.990  21.703  86.909  1.00 24.76           C  
ATOM   2739  CD1 ILE B 120      56.175  20.509  89.767  1.00 20.36           C  
ATOM   2740  N   ASN B 121      58.830  19.004  86.190  1.00 25.88           N  
ATOM   2741  CA  ASN B 121      58.645  17.840  85.338  1.00 28.06           C  
ATOM   2742  C   ASN B 121      57.359  17.109  85.665  1.00 25.79           C  
ATOM   2743  O   ASN B 121      56.833  17.190  86.784  1.00 25.98           O  
ATOM   2744  CB  ASN B 121      59.777  16.818  85.468  1.00 32.25           C  
ATOM   2745  CG  ASN B 121      60.947  17.323  86.287  1.00 36.59           C  
ATOM   2746  OD1 ASN B 121      60.839  17.545  87.492  1.00 40.52           O  
ATOM   2747  ND2 ASN B 121      62.088  17.495  85.627  1.00 38.33           N  
ATOM   2748  N   VAL B 122      56.865  16.368  84.684  1.00 26.09           N  
ATOM   2749  CA  VAL B 122      55.637  15.607  84.838  1.00 26.23           C  
ATOM   2750  C   VAL B 122      55.758  14.515  85.914  1.00 26.88           C  
ATOM   2751  O   VAL B 122      54.760  14.122  86.532  1.00 25.64           O  
ATOM   2752  CB  VAL B 122      55.215  14.980  83.480  1.00 26.06           C  
ATOM   2753  CG1 VAL B 122      56.256  13.965  83.023  1.00 27.27           C  
ATOM   2754  CG2 VAL B 122      53.828  14.333  83.599  1.00 26.13           C  
ATOM   2755  N   GLU B 123      56.974  14.014  86.125  1.00 27.19           N  
ATOM   2756  CA  GLU B 123      57.193  12.982  87.131  1.00 27.46           C  
ATOM   2757  C   GLU B 123      56.796  13.516  88.503  1.00 26.46           C  
ATOM   2758  O   GLU B 123      56.140  12.827  89.284  1.00 26.81           O  
ATOM   2759  CB  GLU B 123      58.665  12.560  87.176  1.00 29.17           C  
ATOM   2760  CG  GLU B 123      59.193  11.895  85.918  1.00 33.44           C  
ATOM   2761  CD  GLU B 123      59.257  12.843  84.737  1.00 34.83           C  
ATOM   2762  OE1 GLU B 123      59.639  14.016  84.937  1.00 34.51           O  
ATOM   2763  OE2 GLU B 123      58.941  12.411  83.607  1.00 38.53           O  
ATOM   2764  N   THR B 124      57.208  14.747  88.788  1.00 24.78           N  
ATOM   2765  CA  THR B 124      56.908  15.391  90.063  1.00 23.74           C  
ATOM   2766  C   THR B 124      55.409  15.618  90.211  1.00 21.86           C  
ATOM   2767  O   THR B 124      54.848  15.477  91.295  1.00 21.13           O  
ATOM   2768  CB  THR B 124      57.639  16.737  90.170  1.00 24.03           C  
ATOM   2769  OG1 THR B 124      59.043  16.523  89.986  1.00 26.86           O  
ATOM   2770  CG2 THR B 124      57.397  17.375  91.530  1.00 22.45           C  
ATOM   2771  N   VAL B 125      54.757  15.971  89.111  1.00 21.29           N  
ATOM   2772  CA  VAL B 125      53.322  16.198  89.140  1.00 20.57           C  
ATOM   2773  C   VAL B 125      52.601  14.896  89.486  1.00 20.54           C  
ATOM   2774  O   VAL B 125      51.712  14.872  90.337  1.00 20.59           O  
ATOM   2775  CB  VAL B 125      52.816  16.710  87.778  1.00 20.46           C  
ATOM   2776  CG1 VAL B 125      51.311  16.941  87.835  1.00 20.25           C  
ATOM   2777  CG2 VAL B 125      53.552  17.995  87.400  1.00 20.13           C  
ATOM   2778  N   ARG B 126      52.994  13.813  88.822  1.00 20.86           N  
ATOM   2779  CA  ARG B 126      52.383  12.511  89.058  1.00 22.37           C  
ATOM   2780  C   ARG B 126      52.599  12.018  90.481  1.00 22.47           C  
ATOM   2781  O   ARG B 126      51.736  11.351  91.044  1.00 23.22           O  
ATOM   2782  CB  ARG B 126      52.930  11.482  88.068  1.00 22.18           C  
ATOM   2783  CG  ARG B 126      52.446  11.689  86.644  1.00 22.90           C  
ATOM   2784  CD  ARG B 126      53.170  10.769  85.684  1.00 24.49           C  
ATOM   2785  NE  ARG B 126      52.731  10.974  84.311  1.00 25.82           N  
ATOM   2786  CZ  ARG B 126      53.493  10.745  83.248  1.00 26.99           C  
ATOM   2787  NH1 ARG B 126      54.735  10.306  83.410  1.00 26.74           N  
ATOM   2788  NH2 ARG B 126      53.016  10.954  82.027  1.00 28.66           N  
ATOM   2789  N   GLU B 127      53.756  12.333  91.054  1.00 24.26           N  
ATOM   2790  CA  GLU B 127      54.055  11.912  92.419  1.00 26.65           C  
ATOM   2791  C   GLU B 127      53.059  12.548  93.382  1.00 25.64           C  
ATOM   2792  O   GLU B 127      52.530  11.882  94.274  1.00 25.75           O  
ATOM   2793  CB  GLU B 127      55.482  12.318  92.804  1.00 28.00           C  
ATOM   2794  CG  GLU B 127      56.557  11.708  91.924  1.00 34.29           C  
ATOM   2795  CD  GLU B 127      57.959  12.056  92.383  1.00 37.11           C  
ATOM   2796  OE1 GLU B 127      58.234  13.254  92.612  1.00 38.85           O  
ATOM   2797  OE2 GLU B 127      58.792  11.132  92.508  1.00 39.63           O  
ATOM   2798  N   ILE B 128      52.801  13.838  93.195  1.00 26.16           N  
ATOM   2799  CA  ILE B 128      51.866  14.551  94.053  1.00 25.83           C  
ATOM   2800  C   ILE B 128      50.450  14.028  93.846  1.00 24.87           C  
ATOM   2801  O   ILE B 128      49.692  13.880  94.802  1.00 25.15           O  
ATOM   2802  CB  ILE B 128      51.910  16.065  93.783  1.00 27.26           C  
ATOM   2803  CG1 ILE B 128      53.334  16.579  94.010  1.00 28.83           C  
ATOM   2804  CG2 ILE B 128      50.932  16.788  94.703  1.00 27.92           C  
ATOM   2805  CD1 ILE B 128      53.516  18.052  93.740  1.00 30.70           C  
ATOM   2806  N   ILE B 129      50.091  13.747  92.596  1.00 22.11           N  
ATOM   2807  CA  ILE B 129      48.772  13.206  92.308  1.00 21.13           C  
ATOM   2808  C   ILE B 129      48.614  11.915  93.109  1.00 22.24           C  
ATOM   2809  O   ILE B 129      47.587  11.687  93.739  1.00 21.20           O  
ATOM   2810  CB  ILE B 129      48.603  12.889  90.802  1.00 20.11           C  
ATOM   2811  CG1 ILE B 129      48.422  14.186  90.011  1.00 19.00           C  
ATOM   2812  CG2 ILE B 129      47.412  11.968  90.593  1.00 19.99           C  
ATOM   2813  CD1 ILE B 129      48.404  13.983  88.497  1.00 17.76           C  
ATOM   2814  N   ASN B 130      49.645  11.073  93.086  1.00 23.47           N  
ATOM   2815  CA  ASN B 130      49.605   9.816  93.822  1.00 25.99           C  
ATOM   2816  C   ASN B 130      49.529  10.061  95.330  1.00 25.79           C  
ATOM   2817  O   ASN B 130      48.784   9.381  96.035  1.00 26.78           O  
ATOM   2818  CB  ASN B 130      50.842   8.973  93.501  1.00 27.23           C  
ATOM   2819  CG  ASN B 130      50.932   7.729  94.361  1.00 31.66           C  
ATOM   2820  OD1 ASN B 130      51.930   7.505  95.044  1.00 36.50           O  
ATOM   2821  ND2 ASN B 130      49.886   6.913  94.334  1.00 34.37           N  
ATOM   2822  N   GLU B 131      50.303  11.028  95.818  1.00 28.99           N  
ATOM   2823  CA  GLU B 131      50.317  11.365  97.243  1.00 31.43           C  
ATOM   2824  C   GLU B 131      48.936  11.773  97.735  1.00 32.66           C  
ATOM   2825  O   GLU B 131      48.305  11.057  98.519  1.00 32.25           O  
ATOM   2826  CB  GLU B 131      51.288  12.511  97.517  1.00 33.70           C  
ATOM   2827  CG  GLU B 131      52.753  12.154  97.396  1.00 37.33           C  
ATOM   2828  CD  GLU B 131      53.653  13.339  97.686  1.00 39.95           C  
ATOM   2829  OE1 GLU B 131      53.476  13.974  98.748  1.00 41.37           O  
ATOM   2830  OE2 GLU B 131      54.539  13.635  96.857  1.00 41.36           O  
ATOM   2831  N   LEU B 132      48.479  12.937  97.278  1.00 33.03           N  
ATOM   2832  CA  LEU B 132      47.172  13.459  97.664  1.00 33.53           C  
ATOM   2833  C   LEU B 132      46.065  12.512  97.237  1.00 31.50           C  
ATOM   2834  O   LEU B 132      44.899  12.715  97.572  1.00 33.63           O  
ATOM   2835  CB  LEU B 132      46.934  14.837  97.040  1.00 35.24           C  
ATOM   2836  CG  LEU B 132      47.591  16.050  97.706  1.00 37.56           C  
ATOM   2837  CD1 LEU B 132      49.095  15.854  97.791  1.00 38.87           C  
ATOM   2838  CD2 LEU B 132      47.260  17.301  96.911  1.00 39.92           C  
ATOM   2839  N   ASN B 133      46.439  11.478  96.491  1.00 30.13           N  
ATOM   2840  CA  ASN B 133      45.485  10.484  96.020  1.00 27.73           C  
ATOM   2841  C   ASN B 133      44.380  11.136  95.187  1.00 27.79           C  
ATOM   2842  O   ASN B 133      43.234  11.218  95.631  1.00 29.17           O  
ATOM   2843  CB  ASN B 133      44.857   9.764  97.217  1.00 30.48           C  
ATOM   2844  CG  ASN B 133      44.573   8.308  96.932  1.00 31.73           C  
ATOM   2845  OD1 ASN B 133      45.474   7.469  96.983  1.00 33.57           O  
ATOM   2846  ND2 ASN B 133      43.323   7.999  96.615  1.00 34.38           N  
ATOM   2847  N   LEU B 134      44.724  11.595  93.984  1.00 23.01           N  
ATOM   2848  CA  LEU B 134      43.754  12.247  93.101  1.00 20.61           C  
ATOM   2849  C   LEU B 134      43.467  11.432  91.841  1.00 18.64           C  
ATOM   2850  O   LEU B 134      44.357  10.766  91.307  1.00 19.85           O  
ATOM   2851  CB  LEU B 134      44.271  13.628  92.695  1.00 17.96           C  
ATOM   2852  CG  LEU B 134      44.755  14.527  93.836  1.00 16.46           C  
ATOM   2853  CD1 LEU B 134      45.324  15.824  93.271  1.00 18.41           C  
ATOM   2854  CD2 LEU B 134      43.599  14.806  94.791  1.00 15.61           C  
ATOM   2855  N   ASN B 135      42.227  11.494  91.365  1.00 18.87           N  
ATOM   2856  CA  ASN B 135      41.826  10.763  90.163  1.00 18.97           C  
ATOM   2857  C   ASN B 135      42.169  11.609  88.944  1.00 18.87           C  
ATOM   2858  O   ASN B 135      41.281  12.075  88.230  1.00 18.52           O  
ATOM   2859  CB  ASN B 135      40.323  10.482  90.177  1.00 22.36           C  
ATOM   2860  CG  ASN B 135      39.905   9.489  89.101  1.00 23.84           C  
ATOM   2861  OD1 ASN B 135      38.735   9.403  88.740  1.00 28.16           O  
ATOM   2862  ND2 ASN B 135      40.867   8.727  88.595  1.00 24.82           N  
ATOM   2863  N   LEU B 136      43.467  11.786  88.716  1.00 18.68           N  
ATOM   2864  CA  LEU B 136      43.961  12.598  87.609  1.00 17.77           C  
ATOM   2865  C   LEU B 136      45.128  11.938  86.898  1.00 18.95           C  
ATOM   2866  O   LEU B 136      45.844  11.126  87.480  1.00 19.59           O  
ATOM   2867  CB  LEU B 136      44.445  13.950  88.129  1.00 16.74           C  
ATOM   2868  CG  LEU B 136      43.461  14.876  88.846  1.00 14.14           C  
ATOM   2869  CD1 LEU B 136      44.220  16.026  89.479  1.00 13.52           C  
ATOM   2870  CD2 LEU B 136      42.421  15.377  87.862  1.00 14.35           C  
ATOM   2871  N   VAL B 137      45.316  12.302  85.634  1.00 18.36           N  
ATOM   2872  CA  VAL B 137      46.435  11.794  84.857  1.00 19.28           C  
ATOM   2873  C   VAL B 137      47.166  13.023  84.334  1.00 19.66           C  
ATOM   2874  O   VAL B 137      46.540  14.040  84.016  1.00 19.80           O  
ATOM   2875  CB  VAL B 137      45.981  10.912  83.667  1.00 19.24           C  
ATOM   2876  CG1 VAL B 137      45.315   9.646  84.182  1.00 21.25           C  
ATOM   2877  CG2 VAL B 137      45.042  11.681  82.767  1.00 21.65           C  
ATOM   2878  N   ALA B 138      48.488  12.941  84.281  1.00 18.61           N  
ATOM   2879  CA  ALA B 138      49.304  14.043  83.799  1.00 20.03           C  
ATOM   2880  C   ALA B 138      50.025  13.576  82.542  1.00 22.04           C  
ATOM   2881  O   ALA B 138      50.776  12.604  82.574  1.00 22.72           O  
ATOM   2882  CB  ALA B 138      50.307  14.457  84.863  1.00 19.80           C  
ATOM   2883  N   VAL B 139      49.783  14.271  81.437  1.00 22.31           N  
ATOM   2884  CA  VAL B 139      50.395  13.914  80.165  1.00 23.80           C  
ATOM   2885  C   VAL B 139      51.297  15.030  79.652  1.00 24.01           C  
ATOM   2886  O   VAL B 139      50.893  16.189  79.571  1.00 24.38           O  
ATOM   2887  CB  VAL B 139      49.313  13.609  79.107  1.00 24.16           C  
ATOM   2888  CG1 VAL B 139      49.961  13.290  77.767  1.00 26.70           C  
ATOM   2889  CG2 VAL B 139      48.448  12.443  79.574  1.00 25.74           C  
ATOM   2890  N   ASP B 140      52.523  14.662  79.303  1.00 25.53           N  
ATOM   2891  CA  ASP B 140      53.507  15.604  78.788  1.00 26.74           C  
ATOM   2892  C   ASP B 140      53.570  15.425  77.276  1.00 27.88           C  
ATOM   2893  O   ASP B 140      54.030  14.395  76.790  1.00 28.24           O  
ATOM   2894  CB  ASP B 140      54.875  15.303  79.403  1.00 27.39           C  
ATOM   2895  CG  ASP B 140      55.937  16.311  79.004  1.00 27.90           C  
ATOM   2896  OD1 ASP B 140      55.648  17.199  78.175  1.00 25.54           O  
ATOM   2897  OD2 ASP B 140      57.066  16.211  79.524  1.00 29.48           O  
ATOM   2898  N   SER B 141      53.100  16.426  76.541  1.00 29.51           N  
ATOM   2899  CA  SER B 141      53.102  16.365  75.082  1.00 31.41           C  
ATOM   2900  C   SER B 141      54.457  16.788  74.535  1.00 31.70           C  
ATOM   2901  O   SER B 141      54.684  16.761  73.325  1.00 32.52           O  
ATOM   2902  CB  SER B 141      52.024  17.286  74.511  1.00 31.43           C  
ATOM   2903  OG  SER B 141      52.340  18.646  74.758  1.00 32.54           O  
ATOM   2904  N   GLY B 142      55.356  17.176  75.435  1.00 31.27           N  
ATOM   2905  CA  GLY B 142      56.671  17.623  75.020  1.00 30.71           C  
ATOM   2906  C   GLY B 142      56.654  19.128  74.842  1.00 30.51           C  
ATOM   2907  O   GLY B 142      57.693  19.756  74.634  1.00 30.81           O  
ATOM   2908  N   PHE B 143      55.461  19.708  74.934  1.00 30.03           N  
ATOM   2909  CA  PHE B 143      55.290  21.147  74.787  1.00 30.40           C  
ATOM   2910  C   PHE B 143      54.659  21.772  76.029  1.00 29.01           C  
ATOM   2911  O   PHE B 143      54.867  22.949  76.323  1.00 28.71           O  
ATOM   2912  CB  PHE B 143      54.440  21.447  73.550  1.00 33.02           C  
ATOM   2913  CG  PHE B 143      55.057  20.963  72.268  1.00 35.62           C  
ATOM   2914  CD1 PHE B 143      54.945  19.630  71.880  1.00 37.00           C  
ATOM   2915  CD2 PHE B 143      55.801  21.829  71.476  1.00 36.99           C  
ATOM   2916  CE1 PHE B 143      55.568  19.169  70.720  1.00 37.69           C  
ATOM   2917  CE2 PHE B 143      56.427  21.379  70.317  1.00 37.70           C  
ATOM   2918  CZ  PHE B 143      56.311  20.046  69.939  1.00 37.50           C  
ATOM   2919  N   ALA B 144      53.889  20.973  76.758  1.00 27.61           N  
ATOM   2920  CA  ALA B 144      53.244  21.429  77.982  1.00 24.37           C  
ATOM   2921  C   ALA B 144      52.687  20.202  78.682  1.00 23.17           C  
ATOM   2922  O   ALA B 144      52.548  19.141  78.068  1.00 23.03           O  
ATOM   2923  CB  ALA B 144      52.121  22.414  77.666  1.00 25.68           C  
ATOM   2924  N   ILE B 145      52.382  20.343  79.966  1.00 21.08           N  
ATOM   2925  CA  ILE B 145      51.834  19.239  80.740  1.00 20.26           C  
ATOM   2926  C   ILE B 145      50.345  19.471  80.957  1.00 18.78           C  
ATOM   2927  O   ILE B 145      49.938  20.530  81.417  1.00 20.59           O  
ATOM   2928  CB  ILE B 145      52.526  19.126  82.114  1.00 19.33           C  
ATOM   2929  CG1 ILE B 145      53.994  18.741  81.920  1.00 21.46           C  
ATOM   2930  CG2 ILE B 145      51.813  18.089  82.979  1.00 22.31           C  
ATOM   2931  CD1 ILE B 145      54.822  18.806  83.183  1.00 20.31           C  
ATOM   2932  N   HIS B 146      49.535  18.478  80.610  1.00 17.81           N  
ATOM   2933  CA  HIS B 146      48.092  18.582  80.786  1.00 17.63           C  
ATOM   2934  C   HIS B 146      47.657  17.616  81.879  1.00 17.38           C  
ATOM   2935  O   HIS B 146      47.967  16.429  81.818  1.00 16.55           O  
ATOM   2936  CB  HIS B 146      47.369  18.225  79.481  1.00 18.40           C  
ATOM   2937  CG  HIS B 146      47.513  19.252  78.399  1.00 22.32           C  
ATOM   2938  ND1 HIS B 146      46.560  20.220  78.160  1.00 23.75           N  
ATOM   2939  CD2 HIS B 146      48.502  19.469  77.498  1.00 22.70           C  
ATOM   2940  CE1 HIS B 146      46.954  20.989  77.160  1.00 23.64           C  
ATOM   2941  NE2 HIS B 146      48.131  20.555  76.741  1.00 23.73           N  
ATOM   2942  N   VAL B 147      46.950  18.133  82.880  1.00 17.44           N  
ATOM   2943  CA  VAL B 147      46.448  17.321  83.981  1.00 17.71           C  
ATOM   2944  C   VAL B 147      44.931  17.309  83.832  1.00 17.35           C  
ATOM   2945  O   VAL B 147      44.281  18.356  83.817  1.00 18.53           O  
ATOM   2946  CB  VAL B 147      46.830  17.930  85.336  1.00 17.87           C  
ATOM   2947  CG1 VAL B 147      46.275  17.088  86.466  1.00 19.16           C  
ATOM   2948  CG2 VAL B 147      48.350  18.030  85.447  1.00 18.37           C  
ATOM   2949  N   LYS B 148      44.359  16.122  83.727  1.00 18.09           N  
ATOM   2950  CA  LYS B 148      42.920  16.008  83.524  1.00 18.25           C  
ATOM   2951  C   LYS B 148      42.353  14.695  84.070  1.00 17.19           C  
ATOM   2952  O   LYS B 148      43.083  13.844  84.573  1.00 16.60           O  
ATOM   2953  CB  LYS B 148      42.656  16.050  82.027  1.00 20.31           C  
ATOM   2954  CG  LYS B 148      43.353  14.891  81.351  1.00 24.74           C  
ATOM   2955  CD  LYS B 148      43.770  15.166  79.941  1.00 30.37           C  
ATOM   2956  CE  LYS B 148      44.363  13.896  79.374  1.00 30.62           C  
ATOM   2957  NZ  LYS B 148      44.146  13.835  77.912  1.00 33.72           N  
ATOM   2958  N   LYS B 149      41.043  14.527  83.912  1.00 17.67           N  
ATOM   2959  CA  LYS B 149      40.368  13.315  84.358  1.00 18.36           C  
ATOM   2960  C   LYS B 149      40.762  12.208  83.387  1.00 20.51           C  
ATOM   2961  O   LYS B 149      40.957  12.454  82.198  1.00 18.13           O  
ATOM   2962  CB  LYS B 149      38.852  13.516  84.341  1.00 20.01           C  
ATOM   2963  CG  LYS B 149      38.349  14.685  85.183  1.00 24.30           C  
ATOM   2964  CD  LYS B 149      38.802  14.590  86.627  1.00 28.70           C  
ATOM   2965  CE  LYS B 149      38.102  15.636  87.494  1.00 30.99           C  
ATOM   2966  NZ  LYS B 149      38.417  17.032  87.092  1.00 33.93           N  
ATOM   2967  N   PRO B 150      40.876  10.971  83.885  1.00 20.95           N  
ATOM   2968  CA  PRO B 150      41.251   9.787  83.107  1.00 22.88           C  
ATOM   2969  C   PRO B 150      40.435   9.500  81.852  1.00 23.82           C  
ATOM   2970  O   PRO B 150      40.956   8.916  80.902  1.00 25.17           O  
ATOM   2971  CB  PRO B 150      41.121   8.658  84.123  1.00 23.71           C  
ATOM   2972  CG  PRO B 150      41.426   9.327  85.418  1.00 24.46           C  
ATOM   2973  CD  PRO B 150      40.652  10.612  85.297  1.00 23.12           C  
ATOM   2974  N   TRP B 151      39.166   9.894  81.850  1.00 23.78           N  
ATOM   2975  CA  TRP B 151      38.282   9.635  80.715  1.00 24.79           C  
ATOM   2976  C   TRP B 151      38.282  10.716  79.638  1.00 24.74           C  
ATOM   2977  O   TRP B 151      37.654  10.553  78.587  1.00 25.40           O  
ATOM   2978  CB  TRP B 151      36.855   9.408  81.226  1.00 26.37           C  
ATOM   2979  CG  TRP B 151      36.331  10.532  82.070  1.00 27.23           C  
ATOM   2980  CD1 TRP B 151      35.700  11.661  81.634  1.00 26.53           C  
ATOM   2981  CD2 TRP B 151      36.416  10.644  83.496  1.00 26.84           C  
ATOM   2982  NE1 TRP B 151      35.385  12.469  82.701  1.00 27.14           N  
ATOM   2983  CE2 TRP B 151      35.813  11.869  83.855  1.00 27.17           C  
ATOM   2984  CE3 TRP B 151      36.943   9.828  84.505  1.00 27.99           C  
ATOM   2985  CZ2 TRP B 151      35.721  12.299  85.184  1.00 27.26           C  
ATOM   2986  CZ3 TRP B 151      36.852  10.257  85.829  1.00 28.28           C  
ATOM   2987  CH2 TRP B 151      36.245  11.483  86.154  1.00 28.71           C  
ATOM   2988  N   ILE B 152      38.989  11.810  79.893  1.00 22.57           N  
ATOM   2989  CA  ILE B 152      39.059  12.911  78.941  1.00 22.81           C  
ATOM   2990  C   ILE B 152      40.237  12.753  77.983  1.00 22.75           C  
ATOM   2991  O   ILE B 152      41.387  12.636  78.402  1.00 24.24           O  
ATOM   2992  CB  ILE B 152      39.180  14.266  79.677  1.00 21.63           C  
ATOM   2993  CG1 ILE B 152      37.925  14.510  80.521  1.00 21.47           C  
ATOM   2994  CG2 ILE B 152      39.372  15.403  78.670  1.00 23.53           C  
ATOM   2995  CD1 ILE B 152      36.640  14.631  79.719  1.00 20.93           C  
ATOM   2996  N   ASN B 153      39.939  12.746  76.690  1.00 22.42           N  
ATOM   2997  CA  ASN B 153      40.975  12.612  75.677  1.00 21.59           C  
ATOM   2998  C   ASN B 153      40.415  12.985  74.312  1.00 20.38           C  
ATOM   2999  O   ASN B 153      39.204  13.158  74.149  1.00 19.09           O  
ATOM   3000  CB  ASN B 153      41.529  11.178  75.667  1.00 22.68           C  
ATOM   3001  CG  ASN B 153      40.472  10.137  75.337  1.00 23.83           C  
ATOM   3002  OD1 ASN B 153      40.064   9.991  74.185  1.00 23.72           O  
ATOM   3003  ND2 ASN B 153      40.025   9.404  76.354  1.00 26.01           N  
ATOM   3004  N   LYS B 154      41.298  13.116  73.329  1.00 20.12           N  
ATOM   3005  CA  LYS B 154      40.873  13.487  71.987  1.00 19.58           C  
ATOM   3006  C   LYS B 154      39.873  12.507  71.389  1.00 19.67           C  
ATOM   3007  O   LYS B 154      39.010  12.898  70.603  1.00 18.09           O  
ATOM   3008  CB  LYS B 154      42.094  13.622  71.072  1.00 18.11           C  
ATOM   3009  CG  LYS B 154      42.983  14.803  71.424  1.00 19.90           C  
ATOM   3010  CD  LYS B 154      44.189  14.879  70.504  1.00 18.62           C  
ATOM   3011  CE  LYS B 154      45.006  16.132  70.778  1.00 21.06           C  
ATOM   3012  NZ  LYS B 154      46.205  16.198  69.891  1.00 21.71           N  
ATOM   3013  N   GLY B 155      39.988  11.236  71.769  1.00 20.52           N  
ATOM   3014  CA  GLY B 155      39.081  10.225  71.256  1.00 20.69           C  
ATOM   3015  C   GLY B 155      37.652  10.449  71.713  1.00 20.63           C  
ATOM   3016  O   GLY B 155      36.726  10.484  70.901  1.00 20.14           O  
ATOM   3017  N   SER B 156      37.467  10.600  73.019  1.00 20.41           N  
ATOM   3018  CA  SER B 156      36.134  10.818  73.565  1.00 22.25           C  
ATOM   3019  C   SER B 156      35.581  12.149  73.070  1.00 20.98           C  
ATOM   3020  O   SER B 156      34.374  12.297  72.877  1.00 20.79           O  
ATOM   3021  CB  SER B 156      36.170  10.788  75.098  1.00 22.71           C  
ATOM   3022  OG  SER B 156      37.032  11.779  75.628  1.00 27.62           O  
ATOM   3023  N   GLY B 157      36.474  13.110  72.850  1.00 20.65           N  
ATOM   3024  CA  GLY B 157      36.055  14.411  72.360  1.00 17.85           C  
ATOM   3025  C   GLY B 157      35.521  14.301  70.946  1.00 17.80           C  
ATOM   3026  O   GLY B 157      34.491  14.884  70.608  1.00 17.01           O  
ATOM   3027  N   ILE B 158      36.227  13.549  70.110  1.00 17.27           N  
ATOM   3028  CA  ILE B 158      35.817  13.353  68.728  1.00 18.11           C  
ATOM   3029  C   ILE B 158      34.510  12.562  68.644  1.00 18.87           C  
ATOM   3030  O   ILE B 158      33.683  12.815  67.772  1.00 19.31           O  
ATOM   3031  CB  ILE B 158      36.926  12.631  67.927  1.00 14.93           C  
ATOM   3032  CG1 ILE B 158      38.122  13.576  67.753  1.00 17.38           C  
ATOM   3033  CG2 ILE B 158      36.400  12.171  66.575  1.00 17.38           C  
ATOM   3034  CD1 ILE B 158      39.331  12.929  67.117  1.00 15.89           C  
ATOM   3035  N   GLU B 159      34.319  11.608  69.552  1.00 19.59           N  
ATOM   3036  CA  GLU B 159      33.089  10.823  69.542  1.00 21.15           C  
ATOM   3037  C   GLU B 159      31.904  11.747  69.804  1.00 21.15           C  
ATOM   3038  O   GLU B 159      30.868  11.649  69.146  1.00 20.18           O  
ATOM   3039  CB  GLU B 159      33.148   9.711  70.598  1.00 22.84           C  
ATOM   3040  CG  GLU B 159      34.182   8.636  70.284  1.00 25.70           C  
ATOM   3041  CD  GLU B 159      34.159   7.482  71.267  1.00 29.36           C  
ATOM   3042  OE1 GLU B 159      34.242   7.740  72.487  1.00 31.86           O  
ATOM   3043  OE2 GLU B 159      34.067   6.318  70.815  1.00 30.84           O  
ATOM   3044  N   LYS B 160      32.072  12.664  70.751  1.00 21.11           N  
ATOM   3045  CA  LYS B 160      31.015  13.607  71.079  1.00 22.55           C  
ATOM   3046  C   LYS B 160      30.812  14.599  69.934  1.00 21.89           C  
ATOM   3047  O   LYS B 160      29.683  14.953  69.600  1.00 23.05           O  
ATOM   3048  CB  LYS B 160      31.359  14.361  72.365  1.00 23.21           C  
ATOM   3049  CG  LYS B 160      30.212  15.196  72.907  1.00 27.84           C  
ATOM   3050  CD  LYS B 160      29.039  14.303  73.271  1.00 31.94           C  
ATOM   3051  CE  LYS B 160      27.877  15.096  73.830  1.00 34.08           C  
ATOM   3052  NZ  LYS B 160      26.762  14.192  74.219  1.00 36.59           N  
ATOM   3053  N   ALA B 161      31.912  15.046  69.333  1.00 20.01           N  
ATOM   3054  CA  ALA B 161      31.826  15.984  68.220  1.00 19.85           C  
ATOM   3055  C   ALA B 161      31.089  15.331  67.055  1.00 18.89           C  
ATOM   3056  O   ALA B 161      30.332  15.984  66.340  1.00 18.36           O  
ATOM   3057  CB  ALA B 161      33.229  16.410  67.783  1.00 18.05           C  
ATOM   3058  N   SER B 162      31.318  14.034  66.872  1.00 18.98           N  
ATOM   3059  CA  SER B 162      30.675  13.284  65.798  1.00 19.35           C  
ATOM   3060  C   SER B 162      29.164  13.281  65.974  1.00 20.24           C  
ATOM   3061  O   SER B 162      28.417  13.289  64.997  1.00 20.00           O  
ATOM   3062  CB  SER B 162      31.193  11.846  65.773  1.00 19.25           C  
ATOM   3063  OG  SER B 162      32.576  11.814  65.461  1.00 20.64           O  
ATOM   3064  N   GLU B 163      28.716  13.265  67.226  1.00 20.72           N  
ATOM   3065  CA  GLU B 163      27.289  13.281  67.512  1.00 23.37           C  
ATOM   3066  C   GLU B 163      26.645  14.561  66.999  1.00 24.00           C  
ATOM   3067  O   GLU B 163      25.572  14.527  66.402  1.00 22.75           O  
ATOM   3068  CB  GLU B 163      27.037  13.186  69.013  1.00 26.35           C  
ATOM   3069  CG  GLU B 163      27.356  11.852  69.636  1.00 31.04           C  
ATOM   3070  CD  GLU B 163      26.937  11.807  71.090  1.00 32.27           C  
ATOM   3071  OE1 GLU B 163      25.737  12.020  71.363  1.00 34.87           O  
ATOM   3072  OE2 GLU B 163      27.802  11.566  71.957  1.00 35.30           O  
ATOM   3073  N   PHE B 164      27.303  15.692  67.240  1.00 26.00           N  
ATOM   3074  CA  PHE B 164      26.767  16.974  66.805  1.00 27.88           C  
ATOM   3075  C   PHE B 164      26.684  17.069  65.289  1.00 26.88           C  
ATOM   3076  O   PHE B 164      25.825  17.765  64.750  1.00 26.34           O  
ATOM   3077  CB  PHE B 164      27.608  18.123  67.371  1.00 29.85           C  
ATOM   3078  CG  PHE B 164      27.759  18.083  68.870  1.00 33.52           C  
ATOM   3079  CD1 PHE B 164      26.771  17.506  69.670  1.00 35.22           C  
ATOM   3080  CD2 PHE B 164      28.878  18.633  69.484  1.00 34.97           C  
ATOM   3081  CE1 PHE B 164      26.899  17.475  71.061  1.00 35.70           C  
ATOM   3082  CE2 PHE B 164      29.016  18.610  70.873  1.00 36.01           C  
ATOM   3083  CZ  PHE B 164      28.024  18.030  71.662  1.00 36.35           C  
ATOM   3084  N   LEU B 165      27.578  16.367  64.600  1.00 26.85           N  
ATOM   3085  CA  LEU B 165      27.572  16.359  63.143  1.00 27.09           C  
ATOM   3086  C   LEU B 165      26.551  15.361  62.617  1.00 26.82           C  
ATOM   3087  O   LEU B 165      26.145  15.429  61.458  1.00 29.56           O  
ATOM   3088  CB  LEU B 165      28.950  15.991  62.593  1.00 28.32           C  
ATOM   3089  CG  LEU B 165      29.988  17.100  62.438  1.00 29.33           C  
ATOM   3090  CD1 LEU B 165      31.268  16.507  61.865  1.00 28.92           C  
ATOM   3091  CD2 LEU B 165      29.447  18.193  61.521  1.00 28.84           C  
ATOM   3092  N   GLY B 166      26.145  14.426  63.468  1.00 25.84           N  
ATOM   3093  CA  GLY B 166      25.180  13.427  63.052  1.00 24.98           C  
ATOM   3094  C   GLY B 166      25.819  12.274  62.303  1.00 23.80           C  
ATOM   3095  O   GLY B 166      25.195  11.673  61.428  1.00 25.26           O  
ATOM   3096  N   ILE B 167      27.068  11.965  62.636  1.00 22.85           N  
ATOM   3097  CA  ILE B 167      27.777  10.866  61.987  1.00 21.91           C  
ATOM   3098  C   ILE B 167      28.405   9.940  63.024  1.00 22.06           C  
ATOM   3099  O   ILE B 167      28.475  10.274  64.202  1.00 21.77           O  
ATOM   3100  CB  ILE B 167      28.898  11.383  61.055  1.00 21.28           C  
ATOM   3101  CG1 ILE B 167      29.991  12.067  61.878  1.00 20.82           C  
ATOM   3102  CG2 ILE B 167      28.318  12.344  60.028  1.00 20.48           C  
ATOM   3103  CD1 ILE B 167      31.202  12.503  61.058  1.00 22.79           C  
ATOM   3104  N   LYS B 168      28.850   8.769  62.581  1.00 22.09           N  
ATOM   3105  CA  LYS B 168      29.492   7.821  63.482  1.00 22.31           C  
ATOM   3106  C   LYS B 168      30.967   8.189  63.594  1.00 22.16           C  
ATOM   3107  O   LYS B 168      31.567   8.671  62.632  1.00 21.18           O  
ATOM   3108  CB  LYS B 168      29.383   6.393  62.935  1.00 23.95           C  
ATOM   3109  CG  LYS B 168      27.971   5.836  62.825  1.00 25.62           C  
ATOM   3110  CD  LYS B 168      28.018   4.398  62.311  1.00 28.16           C  
ATOM   3111  CE  LYS B 168      26.648   3.733  62.322  1.00 29.23           C  
ATOM   3112  NZ  LYS B 168      25.682   4.410  61.421  1.00 33.17           N  
ATOM   3113  N   PRO B 169      31.570   7.975  64.774  1.00 21.78           N  
ATOM   3114  CA  PRO B 169      32.987   8.288  64.980  1.00 21.52           C  
ATOM   3115  C   PRO B 169      33.849   7.487  64.007  1.00 22.19           C  
ATOM   3116  O   PRO B 169      34.927   7.926  63.609  1.00 21.03           O  
ATOM   3117  CB  PRO B 169      33.223   7.875  66.430  1.00 23.57           C  
ATOM   3118  CG  PRO B 169      31.892   8.099  67.060  1.00 24.75           C  
ATOM   3119  CD  PRO B 169      30.947   7.539  66.035  1.00 22.08           C  
ATOM   3120  N   LYS B 170      33.365   6.308  63.622  1.00 21.50           N  
ATOM   3121  CA  LYS B 170      34.096   5.454  62.693  1.00 21.24           C  
ATOM   3122  C   LYS B 170      34.020   5.974  61.261  1.00 19.86           C  
ATOM   3123  O   LYS B 170      34.649   5.423  60.354  1.00 21.53           O  
ATOM   3124  CB  LYS B 170      33.570   4.016  62.767  1.00 23.49           C  
ATOM   3125  CG  LYS B 170      33.988   3.267  64.029  1.00 24.57           C  
ATOM   3126  CD  LYS B 170      35.500   3.074  64.083  1.00 26.88           C  
ATOM   3127  CE  LYS B 170      35.928   2.283  65.311  1.00 29.50           C  
ATOM   3128  NZ  LYS B 170      37.408   2.126  65.376  1.00 32.62           N  
ATOM   3129  N   GLU B 171      33.244   7.035  61.060  1.00 17.47           N  
ATOM   3130  CA  GLU B 171      33.111   7.647  59.748  1.00 19.31           C  
ATOM   3131  C   GLU B 171      34.008   8.882  59.682  1.00 18.70           C  
ATOM   3132  O   GLU B 171      33.913   9.689  58.758  1.00 18.99           O  
ATOM   3133  CB  GLU B 171      31.653   8.028  59.482  1.00 21.53           C  
ATOM   3134  CG  GLU B 171      30.725   6.819  59.395  1.00 22.95           C  
ATOM   3135  CD  GLU B 171      29.274   7.206  59.209  1.00 25.05           C  
ATOM   3136  OE1 GLU B 171      28.790   8.069  59.969  1.00 26.30           O  
ATOM   3137  OE2 GLU B 171      28.613   6.643  58.310  1.00 27.37           O  
ATOM   3138  N   VAL B 172      34.884   9.007  60.674  1.00 18.60           N  
ATOM   3139  CA  VAL B 172      35.830  10.117  60.749  1.00 18.36           C  
ATOM   3140  C   VAL B 172      37.246   9.629  60.457  1.00 19.30           C  
ATOM   3141  O   VAL B 172      37.625   8.519  60.844  1.00 18.63           O  
ATOM   3142  CB  VAL B 172      35.848  10.758  62.156  1.00 17.91           C  
ATOM   3143  CG1 VAL B 172      36.940  11.831  62.229  1.00 15.93           C  
ATOM   3144  CG2 VAL B 172      34.489  11.348  62.484  1.00 18.12           C  
ATOM   3145  N   ALA B 173      38.019  10.462  59.768  1.00 17.45           N  
ATOM   3146  CA  ALA B 173      39.411  10.152  59.458  1.00 16.43           C  
ATOM   3147  C   ALA B 173      40.196  11.181  60.259  1.00 16.14           C  
ATOM   3148  O   ALA B 173      39.930  12.376  60.155  1.00 15.32           O  
ATOM   3149  CB  ALA B 173      39.681  10.323  57.973  1.00 15.68           C  
ATOM   3150  N   HIS B 174      41.145  10.725  61.067  1.00 15.46           N  
ATOM   3151  CA  HIS B 174      41.928  11.641  61.886  1.00 15.32           C  
ATOM   3152  C   HIS B 174      43.369  11.819  61.424  1.00 15.99           C  
ATOM   3153  O   HIS B 174      44.045  10.854  61.067  1.00 17.17           O  
ATOM   3154  CB  HIS B 174      41.939  11.168  63.340  1.00 16.44           C  
ATOM   3155  CG  HIS B 174      42.677  12.086  64.263  1.00 15.00           C  
ATOM   3156  ND1 HIS B 174      42.219  13.348  64.579  1.00 14.31           N  
ATOM   3157  CD2 HIS B 174      43.856  11.941  64.910  1.00 15.03           C  
ATOM   3158  CE1 HIS B 174      43.084  13.939  65.383  1.00 14.87           C  
ATOM   3159  NE2 HIS B 174      44.087  13.106  65.600  1.00 15.14           N  
ATOM   3160  N   VAL B 175      43.834  13.065  61.447  1.00 13.22           N  
ATOM   3161  CA  VAL B 175      45.202  13.385  61.064  1.00 13.89           C  
ATOM   3162  C   VAL B 175      45.903  13.964  62.292  1.00 14.70           C  
ATOM   3163  O   VAL B 175      45.483  14.993  62.827  1.00 14.50           O  
ATOM   3164  CB  VAL B 175      45.217  14.413  59.919  1.00 11.86           C  
ATOM   3165  CG1 VAL B 175      46.648  14.686  59.481  1.00 14.71           C  
ATOM   3166  CG2 VAL B 175      44.394  13.889  58.754  1.00 13.19           C  
ATOM   3167  N   GLY B 176      46.964  13.301  62.744  1.00 14.73           N  
ATOM   3168  CA  GLY B 176      47.668  13.771  63.925  1.00 14.02           C  
ATOM   3169  C   GLY B 176      49.179  13.799  63.809  1.00 15.22           C  
ATOM   3170  O   GLY B 176      49.746  13.269  62.851  1.00 15.32           O  
ATOM   3171  N   ASP B 177      49.832  14.401  64.802  1.00 16.47           N  
ATOM   3172  CA  ASP B 177      51.286  14.522  64.808  1.00 18.88           C  
ATOM   3173  C   ASP B 177      51.921  14.093  66.124  1.00 20.05           C  
ATOM   3174  O   ASP B 177      53.144  14.050  66.228  1.00 21.26           O  
ATOM   3175  CB  ASP B 177      51.709  15.974  64.548  1.00 18.89           C  
ATOM   3176  CG  ASP B 177      51.436  16.884  65.742  1.00 22.30           C  
ATOM   3177  OD1 ASP B 177      52.198  17.851  65.954  1.00 23.40           O  
ATOM   3178  OD2 ASP B 177      50.452  16.639  66.470  1.00 23.58           O  
ATOM   3179  N   GLY B 178      51.105  13.787  67.127  1.00 21.62           N  
ATOM   3180  CA  GLY B 178      51.664  13.415  68.413  1.00 23.10           C  
ATOM   3181  C   GLY B 178      51.210  12.100  69.011  1.00 23.24           C  
ATOM   3182  O   GLY B 178      50.340  11.410  68.479  1.00 23.02           O  
ATOM   3183  N   GLU B 179      51.810  11.763  70.147  1.00 24.67           N  
ATOM   3184  CA  GLU B 179      51.496  10.526  70.838  1.00 26.51           C  
ATOM   3185  C   GLU B 179      50.060  10.480  71.346  1.00 26.00           C  
ATOM   3186  O   GLU B 179      49.406   9.438  71.262  1.00 25.61           O  
ATOM   3187  CB  GLU B 179      52.476  10.319  71.996  1.00 29.84           C  
ATOM   3188  CG  GLU B 179      52.251   9.039  72.785  1.00 33.88           C  
ATOM   3189  CD  GLU B 179      53.403   8.718  73.717  1.00 36.18           C  
ATOM   3190  OE1 GLU B 179      53.248   7.810  74.560  1.00 38.50           O  
ATOM   3191  OE2 GLU B 179      54.465   9.367  73.601  1.00 38.26           O  
ATOM   3192  N   ASN B 180      49.553  11.599  71.860  1.00 25.14           N  
ATOM   3193  CA  ASN B 180      48.188  11.591  72.370  1.00 24.90           C  
ATOM   3194  C   ASN B 180      47.149  11.441  71.266  1.00 24.20           C  
ATOM   3195  O   ASN B 180      45.955  11.309  71.539  1.00 26.10           O  
ATOM   3196  CB  ASN B 180      47.903  12.829  73.240  1.00 24.50           C  
ATOM   3197  CG  ASN B 180      47.873  14.126  72.454  1.00 26.15           C  
ATOM   3198  OD1 ASN B 180      47.946  14.108  71.223  1.00 25.39           O  
ATOM   3199  ND2 ASN B 180      47.777  15.248  73.147  1.00 25.40           N  
ATOM   3200  N   ASP B 181      47.599  11.447  70.017  1.00 23.26           N  
ATOM   3201  CA  ASP B 181      46.670  11.267  68.913  1.00 22.09           C  
ATOM   3202  C   ASP B 181      46.287   9.796  68.829  1.00 22.13           C  
ATOM   3203  O   ASP B 181      45.409   9.415  68.058  1.00 21.85           O  
ATOM   3204  CB  ASP B 181      47.287  11.737  67.597  1.00 22.23           C  
ATOM   3205  CG  ASP B 181      47.341  13.241  67.500  1.00 20.56           C  
ATOM   3206  OD1 ASP B 181      48.454  13.804  67.488  1.00 22.11           O  
ATOM   3207  OD2 ASP B 181      46.260  13.863  67.447  1.00 20.55           O  
ATOM   3208  N   LEU B 182      46.953   8.967  69.629  1.00 23.25           N  
ATOM   3209  CA  LEU B 182      46.635   7.547  69.646  1.00 24.08           C  
ATOM   3210  C   LEU B 182      45.215   7.414  70.182  1.00 23.40           C  
ATOM   3211  O   LEU B 182      44.471   6.520  69.784  1.00 21.87           O  
ATOM   3212  CB  LEU B 182      47.601   6.774  70.550  1.00 28.65           C  
ATOM   3213  CG  LEU B 182      48.502   5.730  69.876  1.00 31.09           C  
ATOM   3214  CD1 LEU B 182      47.706   4.968  68.817  1.00 33.20           C  
ATOM   3215  CD2 LEU B 182      49.699   6.412  69.238  1.00 33.62           C  
ATOM   3216  N   ASP B 183      44.842   8.317  71.085  1.00 23.25           N  
ATOM   3217  CA  ASP B 183      43.501   8.304  71.662  1.00 24.29           C  
ATOM   3218  C   ASP B 183      42.458   8.538  70.572  1.00 22.77           C  
ATOM   3219  O   ASP B 183      41.380   7.948  70.594  1.00 22.13           O  
ATOM   3220  CB  ASP B 183      43.356   9.392  72.732  1.00 25.24           C  
ATOM   3221  CG  ASP B 183      44.283   9.184  73.913  1.00 29.45           C  
ATOM   3222  OD1 ASP B 183      44.303   8.066  74.471  1.00 31.82           O  
ATOM   3223  OD2 ASP B 183      44.986  10.144  74.292  1.00 31.87           O  
ATOM   3224  N   ALA B 184      42.779   9.409  69.623  1.00 22.16           N  
ATOM   3225  CA  ALA B 184      41.862   9.712  68.532  1.00 20.07           C  
ATOM   3226  C   ALA B 184      41.824   8.549  67.553  1.00 20.21           C  
ATOM   3227  O   ALA B 184      40.761   8.172  67.059  1.00 18.76           O  
ATOM   3228  CB  ALA B 184      42.302  10.990  67.815  1.00 19.15           C  
ATOM   3229  N   PHE B 185      42.997   7.990  67.272  1.00 20.33           N  
ATOM   3230  CA  PHE B 185      43.122   6.861  66.357  1.00 21.54           C  
ATOM   3231  C   PHE B 185      42.207   5.720  66.795  1.00 22.03           C  
ATOM   3232  O   PHE B 185      41.607   5.037  65.967  1.00 22.29           O  
ATOM   3233  CB  PHE B 185      44.573   6.364  66.335  1.00 21.37           C  
ATOM   3234  CG  PHE B 185      45.453   7.049  65.318  1.00 21.52           C  
ATOM   3235  CD1 PHE B 185      45.082   8.258  64.733  1.00 22.58           C  
ATOM   3236  CD2 PHE B 185      46.675   6.484  64.965  1.00 22.31           C  
ATOM   3237  CE1 PHE B 185      45.921   8.891  63.814  1.00 21.01           C  
ATOM   3238  CE2 PHE B 185      47.522   7.110  64.049  1.00 21.11           C  
ATOM   3239  CZ  PHE B 185      47.141   8.317  63.472  1.00 22.99           C  
ATOM   3240  N   LYS B 186      42.105   5.533  68.106  1.00 23.57           N  
ATOM   3241  CA  LYS B 186      41.294   4.466  68.682  1.00 26.59           C  
ATOM   3242  C   LYS B 186      39.806   4.528  68.355  1.00 25.61           C  
ATOM   3243  O   LYS B 186      39.159   3.491  68.203  1.00 26.60           O  
ATOM   3244  CB  LYS B 186      41.451   4.452  70.207  1.00 28.54           C  
ATOM   3245  CG  LYS B 186      42.830   4.078  70.720  1.00 32.96           C  
ATOM   3246  CD  LYS B 186      42.835   4.086  72.245  1.00 36.38           C  
ATOM   3247  CE  LYS B 186      44.171   3.647  72.820  1.00 39.04           C  
ATOM   3248  NZ  LYS B 186      44.139   3.650  74.313  1.00 40.64           N  
ATOM   3249  N   VAL B 187      39.263   5.736  68.240  1.00 24.96           N  
ATOM   3250  CA  VAL B 187      37.836   5.887  67.982  1.00 22.18           C  
ATOM   3251  C   VAL B 187      37.416   6.143  66.539  1.00 21.22           C  
ATOM   3252  O   VAL B 187      36.248   5.971  66.200  1.00 20.36           O  
ATOM   3253  CB  VAL B 187      37.239   7.019  68.853  1.00 21.96           C  
ATOM   3254  CG1 VAL B 187      37.604   6.804  70.307  1.00 21.54           C  
ATOM   3255  CG2 VAL B 187      37.747   8.372  68.376  1.00 22.35           C  
ATOM   3256  N   VAL B 188      38.354   6.545  65.685  1.00 20.66           N  
ATOM   3257  CA  VAL B 188      38.012   6.841  64.295  1.00 18.91           C  
ATOM   3258  C   VAL B 188      38.136   5.681  63.309  1.00 18.86           C  
ATOM   3259  O   VAL B 188      38.636   4.604  63.651  1.00 20.29           O  
ATOM   3260  CB  VAL B 188      38.855   8.022  63.767  1.00 18.24           C  
ATOM   3261  CG1 VAL B 188      38.631   9.247  64.640  1.00 17.64           C  
ATOM   3262  CG2 VAL B 188      40.328   7.644  63.744  1.00 18.99           C  
ATOM   3263  N   GLY B 189      37.682   5.920  62.081  1.00 18.49           N  
ATOM   3264  CA  GLY B 189      37.717   4.902  61.045  1.00 20.50           C  
ATOM   3265  C   GLY B 189      38.974   4.841  60.197  1.00 20.77           C  
ATOM   3266  O   GLY B 189      39.312   3.782  59.667  1.00 21.20           O  
ATOM   3267  N   TYR B 190      39.660   5.970  60.044  1.00 20.58           N  
ATOM   3268  CA  TYR B 190      40.889   6.009  59.257  1.00 19.89           C  
ATOM   3269  C   TYR B 190      41.907   6.844  60.030  1.00 20.18           C  
ATOM   3270  O   TYR B 190      41.552   7.849  60.648  1.00 18.98           O  
ATOM   3271  CB  TYR B 190      40.625   6.619  57.880  1.00 19.29           C  
ATOM   3272  CG  TYR B 190      41.712   6.317  56.878  1.00 20.58           C  
ATOM   3273  CD1 TYR B 190      41.881   5.026  56.377  1.00 21.47           C  
ATOM   3274  CD2 TYR B 190      42.590   7.309  56.452  1.00 20.32           C  
ATOM   3275  CE1 TYR B 190      42.898   4.729  55.477  1.00 21.02           C  
ATOM   3276  CE2 TYR B 190      43.615   7.024  55.551  1.00 22.13           C  
ATOM   3277  CZ  TYR B 190      43.762   5.731  55.069  1.00 21.16           C  
ATOM   3278  OH  TYR B 190      44.774   5.434  54.182  1.00 21.33           O  
ATOM   3279  N   LYS B 191      43.170   6.430  59.989  1.00 18.56           N  
ATOM   3280  CA  LYS B 191      44.217   7.103  60.745  1.00 18.04           C  
ATOM   3281  C   LYS B 191      45.424   7.552  59.922  1.00 17.79           C  
ATOM   3282  O   LYS B 191      46.057   6.751  59.237  1.00 16.48           O  
ATOM   3283  CB  LYS B 191      44.676   6.167  61.871  1.00 20.84           C  
ATOM   3284  CG  LYS B 191      43.519   5.652  62.734  1.00 21.81           C  
ATOM   3285  CD  LYS B 191      43.907   4.423  63.547  1.00 25.76           C  
ATOM   3286  CE  LYS B 191      44.179   3.225  62.647  1.00 26.00           C  
ATOM   3287  NZ  LYS B 191      44.542   2.007  63.425  1.00 29.26           N  
ATOM   3288  N   VAL B 192      45.739   8.841  59.991  1.00 16.76           N  
ATOM   3289  CA  VAL B 192      46.883   9.378  59.264  1.00 17.30           C  
ATOM   3290  C   VAL B 192      47.827  10.130  60.199  1.00 17.54           C  
ATOM   3291  O   VAL B 192      47.392  10.869  61.079  1.00 16.67           O  
ATOM   3292  CB  VAL B 192      46.436  10.341  58.139  1.00 16.68           C  
ATOM   3293  CG1 VAL B 192      47.657  10.832  57.360  1.00 17.92           C  
ATOM   3294  CG2 VAL B 192      45.451   9.635  57.209  1.00 18.58           C  
ATOM   3295  N   ALA B 193      49.126   9.925  60.012  1.00 18.46           N  
ATOM   3296  CA  ALA B 193      50.127  10.606  60.825  1.00 17.75           C  
ATOM   3297  C   ALA B 193      51.027  11.401  59.887  1.00 17.62           C  
ATOM   3298  O   ALA B 193      51.368  10.926  58.805  1.00 17.41           O  
ATOM   3299  CB  ALA B 193      50.959   9.589  61.611  1.00 19.15           C  
ATOM   3300  N   VAL B 194      51.388  12.617  60.286  1.00 17.46           N  
ATOM   3301  CA  VAL B 194      52.273  13.422  59.455  1.00 16.83           C  
ATOM   3302  C   VAL B 194      53.703  12.921  59.692  1.00 18.94           C  
ATOM   3303  O   VAL B 194      53.975  12.258  60.699  1.00 19.38           O  
ATOM   3304  CB  VAL B 194      52.127  14.937  59.763  1.00 17.66           C  
ATOM   3305  CG1 VAL B 194      50.758  15.418  59.287  1.00 18.13           C  
ATOM   3306  CG2 VAL B 194      52.285  15.201  61.243  1.00 19.13           C  
ATOM   3307  N   ALA B 195      54.603  13.236  58.764  1.00 19.28           N  
ATOM   3308  CA  ALA B 195      55.987  12.764  58.803  1.00 19.84           C  
ATOM   3309  C   ALA B 195      56.819  12.914  60.076  1.00 20.96           C  
ATOM   3310  O   ALA B 195      57.614  12.023  60.394  1.00 21.18           O  
ATOM   3311  CB  ALA B 195      56.753  13.353  57.622  1.00 19.43           C  
ATOM   3312  N   GLN B 196      56.662  14.011  60.811  1.00 19.95           N  
ATOM   3313  CA  GLN B 196      57.470  14.183  62.013  1.00 19.30           C  
ATOM   3314  C   GLN B 196      56.859  13.549  63.256  1.00 20.44           C  
ATOM   3315  O   GLN B 196      57.361  13.735  64.366  1.00 21.42           O  
ATOM   3316  CB  GLN B 196      57.760  15.672  62.271  1.00 20.32           C  
ATOM   3317  CG  GLN B 196      56.711  16.407  63.091  1.00 18.50           C  
ATOM   3318  CD  GLN B 196      55.545  16.897  62.260  1.00 16.12           C  
ATOM   3319  OE1 GLN B 196      55.377  16.511  61.105  1.00 17.34           O  
ATOM   3320  NE2 GLN B 196      54.720  17.748  62.857  1.00 17.50           N  
ATOM   3321  N   ALA B 197      55.786  12.788  63.068  1.00 19.77           N  
ATOM   3322  CA  ALA B 197      55.119  12.132  64.186  1.00 21.71           C  
ATOM   3323  C   ALA B 197      55.990  11.026  64.770  1.00 23.19           C  
ATOM   3324  O   ALA B 197      56.840  10.460  64.080  1.00 22.66           O  
ATOM   3325  CB  ALA B 197      53.783  11.556  63.737  1.00 23.07           C  
ATOM   3326  N   PRO B 198      55.786  10.707  66.057  1.00 24.15           N  
ATOM   3327  CA  PRO B 198      56.541   9.664  66.760  1.00 24.91           C  
ATOM   3328  C   PRO B 198      56.306   8.290  66.137  1.00 25.79           C  
ATOM   3329  O   PRO B 198      55.254   8.035  65.553  1.00 25.53           O  
ATOM   3330  CB  PRO B 198      55.997   9.743  68.187  1.00 26.30           C  
ATOM   3331  CG  PRO B 198      55.524  11.164  68.308  1.00 26.54           C  
ATOM   3332  CD  PRO B 198      54.859  11.385  66.979  1.00 23.85           C  
ATOM   3333  N   LYS B 199      57.289   7.405  66.270  1.00 25.89           N  
ATOM   3334  CA  LYS B 199      57.189   6.059  65.718  1.00 28.63           C  
ATOM   3335  C   LYS B 199      55.903   5.368  66.162  1.00 27.22           C  
ATOM   3336  O   LYS B 199      55.220   4.732  65.362  1.00 28.02           O  
ATOM   3337  CB  LYS B 199      58.404   5.229  66.150  1.00 30.31           C  
ATOM   3338  CG  LYS B 199      58.348   3.751  65.772  1.00 34.39           C  
ATOM   3339  CD  LYS B 199      58.319   3.528  64.263  1.00 37.40           C  
ATOM   3340  CE  LYS B 199      58.350   2.035  63.937  1.00 38.85           C  
ATOM   3341  NZ  LYS B 199      58.225   1.757  62.479  1.00 40.91           N  
ATOM   3342  N   ILE B 200      55.570   5.510  67.439  1.00 27.57           N  
ATOM   3343  CA  ILE B 200      54.379   4.877  67.986  1.00 28.59           C  
ATOM   3344  C   ILE B 200      53.093   5.267  67.251  1.00 28.07           C  
ATOM   3345  O   ILE B 200      52.199   4.439  67.078  1.00 28.34           O  
ATOM   3346  CB  ILE B 200      54.238   5.186  69.492  1.00 29.79           C  
ATOM   3347  CG1 ILE B 200      53.112   4.341  70.090  1.00 31.14           C  
ATOM   3348  CG2 ILE B 200      53.983   6.669  69.706  1.00 31.60           C  
ATOM   3349  CD1 ILE B 200      52.987   4.468  71.590  1.00 32.19           C  
ATOM   3350  N   LEU B 201      52.996   6.516  66.807  1.00 26.57           N  
ATOM   3351  CA  LEU B 201      51.802   6.943  66.087  1.00 24.33           C  
ATOM   3352  C   LEU B 201      51.849   6.399  64.664  1.00 23.80           C  
ATOM   3353  O   LEU B 201      50.849   5.903  64.144  1.00 23.29           O  
ATOM   3354  CB  LEU B 201      51.695   8.473  66.047  1.00 23.58           C  
ATOM   3355  CG  LEU B 201      50.346   8.969  65.513  1.00 22.45           C  
ATOM   3356  CD1 LEU B 201      49.262   8.678  66.542  1.00 22.19           C  
ATOM   3357  CD2 LEU B 201      50.403  10.459  65.231  1.00 21.00           C  
ATOM   3358  N   LYS B 202      53.016   6.490  64.036  1.00 23.11           N  
ATOM   3359  CA  LYS B 202      53.173   5.999  62.671  1.00 24.74           C  
ATOM   3360  C   LYS B 202      52.833   4.519  62.553  1.00 25.05           C  
ATOM   3361  O   LYS B 202      52.177   4.105  61.602  1.00 25.74           O  
ATOM   3362  CB  LYS B 202      54.600   6.227  62.179  1.00 25.35           C  
ATOM   3363  CG  LYS B 202      54.979   7.685  62.036  1.00 25.41           C  
ATOM   3364  CD  LYS B 202      56.342   7.827  61.381  1.00 26.58           C  
ATOM   3365  CE  LYS B 202      56.688   9.281  61.148  1.00 27.37           C  
ATOM   3366  NZ  LYS B 202      58.001   9.421  60.454  1.00 27.64           N  
ATOM   3367  N   GLU B 203      53.284   3.724  63.519  1.00 27.43           N  
ATOM   3368  CA  GLU B 203      53.023   2.286  63.506  1.00 30.07           C  
ATOM   3369  C   GLU B 203      51.530   1.980  63.519  1.00 29.70           C  
ATOM   3370  O   GLU B 203      51.088   0.968  62.969  1.00 31.25           O  
ATOM   3371  CB  GLU B 203      53.662   1.612  64.719  1.00 32.40           C  
ATOM   3372  CG  GLU B 203      55.143   1.867  64.879  1.00 36.72           C  
ATOM   3373  CD  GLU B 203      55.729   1.107  66.051  1.00 38.73           C  
ATOM   3374  OE1 GLU B 203      55.178   1.219  67.169  1.00 41.22           O  
ATOM   3375  OE2 GLU B 203      56.740   0.402  65.857  1.00 40.84           O  
ATOM   3376  N   ASN B 204      50.758   2.858  64.148  1.00 29.13           N  
ATOM   3377  CA  ASN B 204      49.318   2.670  64.258  1.00 27.70           C  
ATOM   3378  C   ASN B 204      48.495   3.367  63.179  1.00 25.80           C  
ATOM   3379  O   ASN B 204      47.278   3.220  63.135  1.00 23.90           O  
ATOM   3380  CB  ASN B 204      48.853   3.132  65.638  1.00 28.33           C  
ATOM   3381  CG  ASN B 204      49.306   2.198  66.745  1.00 31.48           C  
ATOM   3382  OD1 ASN B 204      48.816   1.074  66.860  1.00 32.31           O  
ATOM   3383  ND2 ASN B 204      50.249   2.655  67.560  1.00 30.84           N  
ATOM   3384  N   ALA B 205      49.159   4.106  62.299  1.00 24.63           N  
ATOM   3385  CA  ALA B 205      48.457   4.817  61.238  1.00 24.34           C  
ATOM   3386  C   ALA B 205      48.238   3.968  59.989  1.00 24.57           C  
ATOM   3387  O   ALA B 205      48.979   3.017  59.726  1.00 25.24           O  
ATOM   3388  CB  ALA B 205      49.223   6.084  60.874  1.00 23.75           C  
ATOM   3389  N   ASP B 206      47.209   4.316  59.226  1.00 23.48           N  
ATOM   3390  CA  ASP B 206      46.900   3.616  57.987  1.00 23.92           C  
ATOM   3391  C   ASP B 206      47.759   4.215  56.885  1.00 23.99           C  
ATOM   3392  O   ASP B 206      47.987   3.594  55.845  1.00 24.62           O  
ATOM   3393  CB  ASP B 206      45.427   3.792  57.626  1.00 23.42           C  
ATOM   3394  CG  ASP B 206      44.506   3.092  58.595  1.00 24.83           C  
ATOM   3395  OD1 ASP B 206      44.619   1.856  58.728  1.00 25.72           O  
ATOM   3396  OD2 ASP B 206      43.671   3.776  59.217  1.00 23.69           O  
ATOM   3397  N   TYR B 207      48.229   5.435  57.125  1.00 23.21           N  
ATOM   3398  CA  TYR B 207      49.059   6.143  56.162  1.00 21.81           C  
ATOM   3399  C   TYR B 207      49.914   7.189  56.863  1.00 21.36           C  
ATOM   3400  O   TYR B 207      49.453   7.877  57.778  1.00 20.25           O  
ATOM   3401  CB  TYR B 207      48.176   6.837  55.116  1.00 22.56           C  
ATOM   3402  CG  TYR B 207      48.945   7.423  53.951  1.00 24.36           C  
ATOM   3403  CD1 TYR B 207      49.522   6.595  52.987  1.00 26.46           C  
ATOM   3404  CD2 TYR B 207      49.105   8.803  53.816  1.00 26.78           C  
ATOM   3405  CE1 TYR B 207      50.238   7.125  51.917  1.00 28.17           C  
ATOM   3406  CE2 TYR B 207      49.823   9.343  52.749  1.00 28.12           C  
ATOM   3407  CZ  TYR B 207      50.386   8.496  51.805  1.00 29.38           C  
ATOM   3408  OH  TYR B 207      51.098   9.016  50.747  1.00 31.99           O  
ATOM   3409  N   VAL B 208      51.169   7.292  56.443  1.00 19.33           N  
ATOM   3410  CA  VAL B 208      52.085   8.280  56.996  1.00 19.23           C  
ATOM   3411  C   VAL B 208      52.484   9.149  55.813  1.00 18.23           C  
ATOM   3412  O   VAL B 208      53.004   8.648  54.820  1.00 20.20           O  
ATOM   3413  CB  VAL B 208      53.350   7.627  57.591  1.00 18.15           C  
ATOM   3414  CG1 VAL B 208      54.295   8.704  58.096  1.00 19.43           C  
ATOM   3415  CG2 VAL B 208      52.968   6.682  58.726  1.00 19.84           C  
ATOM   3416  N   THR B 209      52.229  10.447  55.908  1.00 18.82           N  
ATOM   3417  CA  THR B 209      52.553  11.345  54.807  1.00 17.34           C  
ATOM   3418  C   THR B 209      54.054  11.470  54.593  1.00 18.49           C  
ATOM   3419  O   THR B 209      54.847  11.187  55.490  1.00 19.61           O  
ATOM   3420  CB  THR B 209      51.976  12.751  55.053  1.00 17.03           C  
ATOM   3421  OG1 THR B 209      52.594  13.328  56.210  1.00 16.67           O  
ATOM   3422  CG2 THR B 209      50.474  12.670  55.266  1.00 16.38           C  
ATOM   3423  N   LYS B 210      54.432  11.899  53.394  1.00 20.35           N  
ATOM   3424  CA  LYS B 210      55.836  12.073  53.058  1.00 21.72           C  
ATOM   3425  C   LYS B 210      56.376  13.326  53.735  1.00 20.96           C  
ATOM   3426  O   LYS B 210      57.501  13.333  54.234  1.00 22.10           O  
ATOM   3427  CB  LYS B 210      56.009  12.197  51.544  1.00 24.50           C  
ATOM   3428  CG  LYS B 210      55.450  11.028  50.751  1.00 28.47           C  
ATOM   3429  CD  LYS B 210      55.546  11.293  49.257  1.00 30.55           C  
ATOM   3430  CE  LYS B 210      54.309  10.788  48.530  1.00 32.57           C  
ATOM   3431  NZ  LYS B 210      54.337  11.119  47.079  1.00 34.73           N  
ATOM   3432  N   LYS B 211      55.559  14.375  53.766  1.00 18.97           N  
ATOM   3433  CA  LYS B 211      55.963  15.640  54.366  1.00 19.87           C  
ATOM   3434  C   LYS B 211      55.528  15.847  55.812  1.00 19.01           C  
ATOM   3435  O   LYS B 211      54.579  15.221  56.286  1.00 18.08           O  
ATOM   3436  CB  LYS B 211      55.464  16.815  53.500  1.00 22.16           C  
ATOM   3437  CG  LYS B 211      56.043  16.865  52.064  1.00 26.34           C  
ATOM   3438  CD  LYS B 211      57.561  17.172  52.012  1.00 30.51           C  
ATOM   3439  CE  LYS B 211      58.268  16.754  53.305  1.00 33.15           C  
ATOM   3440  NZ  LYS B 211      59.755  16.804  53.386  1.00 37.96           N  
ATOM   3441  N   GLU B 212      56.237  16.728  56.511  1.00 19.08           N  
ATOM   3442  CA  GLU B 212      55.893  17.014  57.893  1.00 18.70           C  
ATOM   3443  C   GLU B 212      55.238  18.377  58.042  1.00 17.67           C  
ATOM   3444  O   GLU B 212      55.213  19.175  57.104  1.00 16.80           O  
ATOM   3445  CB  GLU B 212      57.121  16.903  58.801  1.00 25.24           C  
ATOM   3446  CG  GLU B 212      58.414  17.409  58.229  1.00 30.09           C  
ATOM   3447  CD  GLU B 212      59.589  17.074  59.126  1.00 31.78           C  
ATOM   3448  OE1 GLU B 212      59.943  15.878  59.240  1.00 35.17           O  
ATOM   3449  OE2 GLU B 212      60.150  18.010  59.727  1.00 32.80           O  
ATOM   3450  N   TYR B 213      54.686  18.620  59.224  1.00 15.78           N  
ATOM   3451  CA  TYR B 213      54.008  19.876  59.522  1.00 16.77           C  
ATOM   3452  C   TYR B 213      52.901  20.213  58.521  1.00 15.60           C  
ATOM   3453  O   TYR B 213      52.242  19.315  57.991  1.00 15.12           O  
ATOM   3454  CB  TYR B 213      55.046  20.998  59.628  1.00 17.34           C  
ATOM   3455  CG  TYR B 213      55.890  20.847  60.871  1.00 17.49           C  
ATOM   3456  CD1 TYR B 213      55.384  21.195  62.123  1.00 17.84           C  
ATOM   3457  CD2 TYR B 213      57.156  20.265  60.810  1.00 19.72           C  
ATOM   3458  CE1 TYR B 213      56.110  20.960  63.286  1.00 21.09           C  
ATOM   3459  CE2 TYR B 213      57.893  20.023  61.972  1.00 20.39           C  
ATOM   3460  CZ  TYR B 213      57.361  20.371  63.202  1.00 20.40           C  
ATOM   3461  OH  TYR B 213      58.069  20.106  64.351  1.00 26.41           O  
ATOM   3462  N   GLY B 214      52.694  21.505  58.271  1.00 14.73           N  
ATOM   3463  CA  GLY B 214      51.643  21.945  57.365  1.00 14.47           C  
ATOM   3464  C   GLY B 214      51.512  21.261  56.017  1.00 14.33           C  
ATOM   3465  O   GLY B 214      50.400  20.948  55.582  1.00 14.11           O  
ATOM   3466  N   GLU B 215      52.631  21.045  55.332  1.00 14.45           N  
ATOM   3467  CA  GLU B 215      52.576  20.387  54.031  1.00 16.15           C  
ATOM   3468  C   GLU B 215      52.067  18.970  54.233  1.00 13.53           C  
ATOM   3469  O   GLU B 215      51.365  18.423  53.382  1.00 14.71           O  
ATOM   3470  CB  GLU B 215      53.956  20.348  53.375  1.00 20.30           C  
ATOM   3471  CG  GLU B 215      54.584  21.703  53.136  1.00 26.92           C  
ATOM   3472  CD  GLU B 215      55.786  21.618  52.214  1.00 30.93           C  
ATOM   3473  OE1 GLU B 215      56.683  22.482  52.315  1.00 35.41           O  
ATOM   3474  OE2 GLU B 215      55.826  20.691  51.376  1.00 33.51           O  
ATOM   3475  N   GLY B 216      52.435  18.388  55.369  1.00 14.64           N  
ATOM   3476  CA  GLY B 216      51.995  17.043  55.695  1.00 15.11           C  
ATOM   3477  C   GLY B 216      50.495  17.013  55.920  1.00 14.54           C  
ATOM   3478  O   GLY B 216      49.810  16.102  55.460  1.00 13.43           O  
ATOM   3479  N   GLY B 217      49.979  18.007  56.638  1.00 13.38           N  
ATOM   3480  CA  GLY B 217      48.547  18.055  56.872  1.00 13.20           C  
ATOM   3481  C   GLY B 217      47.786  18.144  55.562  1.00 12.32           C  
ATOM   3482  O   GLY B 217      46.750  17.506  55.387  1.00 12.55           O  
ATOM   3483  N   ALA B 218      48.296  18.945  54.633  1.00 12.53           N  
ATOM   3484  CA  ALA B 218      47.656  19.094  53.334  1.00 12.55           C  
ATOM   3485  C   ALA B 218      47.694  17.758  52.591  1.00 12.44           C  
ATOM   3486  O   ALA B 218      46.694  17.325  52.014  1.00 12.74           O  
ATOM   3487  CB  ALA B 218      48.374  20.175  52.519  1.00 14.14           C  
ATOM   3488  N   GLU B 219      48.849  17.102  52.626  1.00 13.39           N  
ATOM   3489  CA  GLU B 219      49.020  15.814  51.961  1.00 14.84           C  
ATOM   3490  C   GLU B 219      48.046  14.790  52.539  1.00 14.77           C  
ATOM   3491  O   GLU B 219      47.447  14.004  51.803  1.00 15.62           O  
ATOM   3492  CB  GLU B 219      50.452  15.316  52.153  1.00 16.31           C  
ATOM   3493  CG  GLU B 219      50.813  14.114  51.300  1.00 20.66           C  
ATOM   3494  CD  GLU B 219      52.166  13.542  51.663  1.00 22.70           C  
ATOM   3495  OE1 GLU B 219      53.080  14.337  51.988  1.00 22.65           O  
ATOM   3496  OE2 GLU B 219      52.317  12.298  51.619  1.00 22.80           O  
ATOM   3497  N   ALA B 220      47.897  14.813  53.860  1.00 14.20           N  
ATOM   3498  CA  ALA B 220      47.006  13.894  54.561  1.00 13.68           C  
ATOM   3499  C   ALA B 220      45.563  14.070  54.117  1.00 13.58           C  
ATOM   3500  O   ALA B 220      44.841  13.094  53.903  1.00 13.90           O  
ATOM   3501  CB  ALA B 220      47.115  14.108  56.056  1.00 12.54           C  
ATOM   3502  N   ILE B 221      45.139  15.324  53.991  1.00 13.97           N  
ATOM   3503  CA  ILE B 221      43.779  15.615  53.567  1.00 13.90           C  
ATOM   3504  C   ILE B 221      43.555  15.123  52.140  1.00 14.24           C  
ATOM   3505  O   ILE B 221      42.531  14.515  51.839  1.00 13.87           O  
ATOM   3506  CB  ILE B 221      43.497  17.128  53.666  1.00 14.09           C  
ATOM   3507  CG1 ILE B 221      43.484  17.542  55.139  1.00 13.74           C  
ATOM   3508  CG2 ILE B 221      42.174  17.467  52.992  1.00 15.74           C  
ATOM   3509  CD1 ILE B 221      43.383  19.045  55.373  1.00 14.16           C  
ATOM   3510  N   TYR B 222      44.518  15.374  51.257  1.00 14.77           N  
ATOM   3511  CA  TYR B 222      44.387  14.929  49.874  1.00 15.63           C  
ATOM   3512  C   TYR B 222      44.336  13.408  49.802  1.00 15.51           C  
ATOM   3513  O   TYR B 222      43.557  12.842  49.033  1.00 17.25           O  
ATOM   3514  CB  TYR B 222      45.547  15.461  49.037  1.00 16.45           C  
ATOM   3515  CG  TYR B 222      45.233  16.777  48.363  1.00 18.82           C  
ATOM   3516  CD1 TYR B 222      44.642  16.807  47.103  1.00 21.58           C  
ATOM   3517  CD2 TYR B 222      45.486  17.989  49.003  1.00 20.97           C  
ATOM   3518  CE1 TYR B 222      44.308  18.009  46.492  1.00 21.63           C  
ATOM   3519  CE2 TYR B 222      45.152  19.204  48.403  1.00 20.98           C  
ATOM   3520  CZ  TYR B 222      44.563  19.204  47.145  1.00 22.87           C  
ATOM   3521  OH  TYR B 222      44.221  20.391  46.539  1.00 22.29           O  
ATOM   3522  N   HIS B 223      45.162  12.755  50.613  1.00 15.45           N  
ATOM   3523  CA  HIS B 223      45.193  11.298  50.648  1.00 16.15           C  
ATOM   3524  C   HIS B 223      43.813  10.753  51.011  1.00 17.04           C  
ATOM   3525  O   HIS B 223      43.306   9.839  50.360  1.00 16.91           O  
ATOM   3526  CB  HIS B 223      46.219  10.813  51.676  1.00 17.53           C  
ATOM   3527  CG  HIS B 223      46.177   9.335  51.913  1.00 19.91           C  
ATOM   3528  ND1 HIS B 223      46.627   8.418  50.988  1.00 21.43           N  
ATOM   3529  CD2 HIS B 223      45.688   8.612  52.949  1.00 20.36           C  
ATOM   3530  CE1 HIS B 223      46.416   7.195  51.441  1.00 20.54           C  
ATOM   3531  NE2 HIS B 223      45.846   7.285  52.630  1.00 21.18           N  
ATOM   3532  N   ILE B 224      43.210  11.328  52.048  1.00 15.40           N  
ATOM   3533  CA  ILE B 224      41.891  10.905  52.514  1.00 16.19           C  
ATOM   3534  C   ILE B 224      40.806  11.155  51.468  1.00 16.84           C  
ATOM   3535  O   ILE B 224      39.985  10.277  51.197  1.00 17.15           O  
ATOM   3536  CB  ILE B 224      41.519  11.628  53.835  1.00 14.01           C  
ATOM   3537  CG1 ILE B 224      42.493  11.212  54.941  1.00 15.28           C  
ATOM   3538  CG2 ILE B 224      40.085  11.289  54.247  1.00 14.98           C  
ATOM   3539  CD1 ILE B 224      42.385  12.044  56.210  1.00 13.18           C  
ATOM   3540  N   LEU B 225      40.799  12.350  50.878  1.00 14.75           N  
ATOM   3541  CA  LEU B 225      39.803  12.689  49.860  1.00 17.01           C  
ATOM   3542  C   LEU B 225      39.900  11.761  48.656  1.00 16.79           C  
ATOM   3543  O   LEU B 225      38.887  11.335  48.103  1.00 17.65           O  
ATOM   3544  CB  LEU B 225      39.994  14.133  49.383  1.00 16.73           C  
ATOM   3545  CG  LEU B 225      39.789  15.255  50.405  1.00 16.26           C  
ATOM   3546  CD1 LEU B 225      40.116  16.596  49.762  1.00 17.24           C  
ATOM   3547  CD2 LEU B 225      38.349  15.232  50.902  1.00 17.31           C  
ATOM   3548  N   GLU B 226      41.125  11.452  48.255  1.00 17.01           N  
ATOM   3549  CA  GLU B 226      41.348  10.588  47.106  1.00 20.26           C  
ATOM   3550  C   GLU B 226      41.016   9.129  47.377  1.00 21.97           C  
ATOM   3551  O   GLU B 226      40.385   8.465  46.551  1.00 23.32           O  
ATOM   3552  CB  GLU B 226      42.801  10.714  46.640  1.00 19.95           C  
ATOM   3553  CG  GLU B 226      43.100  12.041  45.955  1.00 22.81           C  
ATOM   3554  CD  GLU B 226      44.582  12.269  45.723  1.00 26.11           C  
ATOM   3555  OE1 GLU B 226      45.337  11.274  45.651  1.00 27.95           O  
ATOM   3556  OE2 GLU B 226      44.985  13.445  45.597  1.00 27.41           O  
ATOM   3557  N   LYS B 227      41.430   8.632  48.537  1.00 23.50           N  
ATOM   3558  CA  LYS B 227      41.189   7.238  48.887  1.00 26.29           C  
ATOM   3559  C   LYS B 227      39.711   6.909  49.064  1.00 27.54           C  
ATOM   3560  O   LYS B 227      39.279   5.793  48.769  1.00 29.42           O  
ATOM   3561  CB  LYS B 227      41.950   6.878  50.166  1.00 26.47           C  
ATOM   3562  CG  LYS B 227      41.998   5.382  50.464  1.00 28.35           C  
ATOM   3563  CD  LYS B 227      42.871   5.087  51.675  1.00 31.24           C  
ATOM   3564  CE  LYS B 227      42.894   3.602  52.014  1.00 32.16           C  
ATOM   3565  NZ  LYS B 227      43.506   2.784  50.934  1.00 34.56           N  
ATOM   3566  N   PHE B 228      38.933   7.877  49.532  1.00 27.54           N  
ATOM   3567  CA  PHE B 228      37.517   7.642  49.757  1.00 28.78           C  
ATOM   3568  C   PHE B 228      36.593   8.246  48.708  1.00 28.55           C  
ATOM   3569  O   PHE B 228      35.439   8.570  48.986  1.00 30.51           O  
ATOM   3570  CB  PHE B 228      37.156   8.100  51.171  1.00 28.84           C  
ATOM   3571  CG  PHE B 228      37.845   7.299  52.240  1.00 29.21           C  
ATOM   3572  CD1 PHE B 228      37.428   6.006  52.533  1.00 30.37           C  
ATOM   3573  CD2 PHE B 228      38.960   7.806  52.899  1.00 29.37           C  
ATOM   3574  CE1 PHE B 228      38.114   5.227  53.463  1.00 30.57           C  
ATOM   3575  CE2 PHE B 228      39.653   7.035  53.830  1.00 30.33           C  
ATOM   3576  CZ  PHE B 228      39.229   5.744  54.112  1.00 30.57           C  
ATOM   3577  N   GLY B 229      37.128   8.383  47.496  1.00 29.71           N  
ATOM   3578  CA  GLY B 229      36.372   8.884  46.359  1.00 28.49           C  
ATOM   3579  C   GLY B 229      35.769  10.275  46.341  1.00 28.62           C  
ATOM   3580  O   GLY B 229      34.789  10.499  45.633  1.00 30.92           O  
ATOM   3581  N   TYR B 230      36.332  11.213  47.092  1.00 26.34           N  
ATOM   3582  CA  TYR B 230      35.798  12.568  47.098  1.00 25.25           C  
ATOM   3583  C   TYR B 230      36.525  13.437  46.084  1.00 23.42           C  
ATOM   3584  O   TYR B 230      36.013  14.470  45.652  1.00 23.37           O  
ATOM   3585  CB  TYR B 230      35.902  13.171  48.497  1.00 26.60           C  
ATOM   3586  CG  TYR B 230      34.962  12.508  49.470  1.00 28.85           C  
ATOM   3587  CD1 TYR B 230      35.440  11.842  50.596  1.00 28.81           C  
ATOM   3588  CD2 TYR B 230      33.584  12.522  49.247  1.00 30.58           C  
ATOM   3589  CE1 TYR B 230      34.569  11.203  51.476  1.00 31.60           C  
ATOM   3590  CE2 TYR B 230      32.706  11.888  50.117  1.00 32.62           C  
ATOM   3591  CZ  TYR B 230      33.204  11.232  51.229  1.00 32.83           C  
ATOM   3592  OH  TYR B 230      32.334  10.616  52.095  1.00 35.25           O  
ATOM   3593  N   LEU B 231      37.719  13.000  45.695  1.00 22.18           N  
ATOM   3594  CA  LEU B 231      38.521  13.723  44.720  1.00 21.76           C  
ATOM   3595  C   LEU B 231      39.204  12.707  43.802  1.00 22.64           C  
ATOM   3596  O   LEU B 231      39.378  11.551  44.240  1.00 20.82           O  
ATOM   3597  CB  LEU B 231      39.568  14.577  45.443  1.00 23.64           C  
ATOM   3598  CG  LEU B 231      40.377  15.574  44.613  1.00 24.44           C  
ATOM   3599  CD1 LEU B 231      39.435  16.554  43.934  1.00 23.50           C  
ATOM   3600  CD2 LEU B 231      41.362  16.306  45.513  1.00 25.68           C  
ATOM   3601  OXT LEU B 231      39.565  13.078  42.664  1.00 22.71           O  
TER    3602      LEU B 231                                                      
END
MOLECULE T0505.pdb
ATOM      1  N   LYS     6      34.876   8.083  54.296  1.00 32.10           N  
ATOM      2  CA  LYS     6      35.022   8.794  55.595  1.00 30.60           C  
ATOM      3  C   LYS     6      34.171  10.050  55.575  1.00 30.04           C  
ATOM      4  O   LYS     6      33.987  10.662  54.513  1.00 31.08           O  
ATOM      5  CB  LYS     6      36.491   9.159  55.851  1.00 31.17           C  
ATOM      6  CG  LYS     6      37.392   7.952  56.020  1.00 33.54           C  
ATOM      7  CD  LYS     6      37.138   7.255  57.363  1.00 35.57           C  
ATOM      8  CE  LYS     6      38.133   6.150  57.642  1.00 36.27           C  
ATOM      9  NZ  LYS     6      37.853   4.949  56.798  1.00 38.14           N  
ATOM     10  N   GLN     7      33.690  10.451  56.753  1.00 27.59           N  
ATOM     11  CA  GLN     7      32.685  11.487  56.895  0.50 26.89           C  
ATOM     13  C   GLN     7      33.138  12.631  57.799  1.00 25.56           C  
ATOM     14  O   GLN     7      32.526  13.695  57.807  1.00 25.38           O  
ATOM     15  CB  GLN     7      31.426  10.868  57.485  0.50 26.93           C  
ATOM     17  CG  GLN     7      30.647  10.009  56.503  0.50 28.57           C  
ATOM     19  CD  GLN     7      29.661  10.836  55.717  0.50 29.35           C  
ATOM     21  OE1 GLN     7      29.854  11.087  54.530  0.50 30.06           O  
ATOM     23  NE2 GLN     7      28.612  11.308  56.395  0.50 29.45           N  
ATOM     25  N   LEU     8      34.200  12.400  58.577  0.50 24.45           N  
ATOM     27  CA  LEU     8      34.661  13.377  59.583  0.50 23.92           C  
ATOM     29  C   LEU     8      36.187  13.456  59.657  0.50 23.34           C  
ATOM     31  O   LEU     8      36.847  12.452  59.952  0.50 23.15           O  
ATOM     33  CB  LEU     8      34.101  13.028  60.972  0.50 24.05           C  
ATOM     35  CG  LEU     8      34.601  13.825  62.197  0.50 24.47           C  
ATOM     37  CD1 LEU     8      34.433  15.330  62.006  0.50 23.47           C  
ATOM     39  CD2 LEU     8      33.919  13.376  63.497  0.50 23.31           C  
ATOM     41  N   LEU     9      36.730  14.650  59.413  1.00 23.12           N  
ATOM     42  CA  LEU     9      38.176  14.891  59.468  1.00 23.12           C  
ATOM     43  C   LEU     9      38.484  15.724  60.712  1.00 22.53           C  
ATOM     44  O   LEU     9      37.954  16.839  60.871  1.00 23.46           O  
ATOM     45  CB  LEU     9      38.656  15.617  58.198  1.00 23.25           C  
ATOM     46  CG  LEU     9      40.093  16.142  58.238  1.00 25.00           C  
ATOM     47  CD1 LEU     9      41.072  14.935  58.280  1.00 26.13           C  
ATOM     48  CD2 LEU     9      40.418  17.054  57.039  1.00 24.10           C  
ATOM     49  N   ALA    10      39.282  15.171  61.620  1.00 22.09           N  
ATOM     50  CA  ALA    10      39.697  15.881  62.836  1.00 23.55           C  
ATOM     51  C   ALA    10      41.197  16.143  62.812  1.00 24.22           C  
ATOM     52  O   ALA    10      41.973  15.196  62.631  1.00 24.53           O  
ATOM     53  CB  ALA    10      39.325  15.052  64.049  1.00 25.36           C  
ATOM     54  N   LEU    11      41.581  17.415  62.969  1.00 23.75           N  
ATOM     55  CA  LEU    11      42.967  17.843  62.829  0.50 23.98           C  
ATOM     57  C   LEU    11      43.477  18.526  64.105  1.00 23.85           C  
ATOM     58  O   LEU    11      42.800  19.360  64.673  1.00 23.47           O  
ATOM     59  CB  LEU    11      43.102  18.860  61.664  0.50 24.46           C  
ATOM     61  CG  LEU    11      42.423  18.598  60.316  0.50 24.12           C  
ATOM     63  CD1 LEU    11      41.927  19.862  59.697  0.50 27.02           C  
ATOM     65  CD2 LEU    11      43.374  17.912  59.348  0.50 26.73           C  
ATOM     67  N   ASN    12      44.706  18.206  64.500  1.00 23.73           N  
ATOM     68  CA  ASN    12      45.425  19.070  65.448  1.00 23.73           C  
ATOM     69  C   ASN    12      45.664  20.434  64.786  1.00 23.97           C  
ATOM     70  O   ASN    12      45.753  20.542  63.562  1.00 23.62           O  
ATOM     71  CB  ASN    12      46.846  18.547  65.770  1.00 23.79           C  
ATOM     72  CG  ASN    12      46.888  17.356  66.714  1.00 25.38           C  
ATOM     73  OD1 ASN    12      47.905  16.688  66.770  1.00 26.57           O  
ATOM     74  ND2 ASN    12      45.834  17.118  67.483  1.00 25.65           N  
ATOM     75  N   ILE    13      45.828  21.453  65.605  1.00 23.30           N  
ATOM     76  CA  ILE    13      46.238  22.768  65.137  1.00 23.99           C  
ATOM     77  C   ILE    13      47.789  22.837  65.112  1.00 23.85           C  
ATOM     78  O   ILE    13      48.420  22.815  64.037  1.00 23.87           O  
ATOM     79  CB  ILE    13      45.632  23.862  66.060  1.00 22.93           C  
ATOM     80  CG1 ILE    13      44.086  23.825  65.985  1.00 24.81           C  
ATOM     81  CG2 ILE    13      46.199  25.239  65.708  1.00 23.98           C  
ATOM     82  CD1 ILE    13      43.379  24.872  66.896  1.00 24.97           C  
ATOM     83  N   ASP    14      48.402  22.882  66.293  1.00 24.30           N  
ATOM     84  CA  ASP    14      49.864  22.869  66.407  1.00 24.52           C  
ATOM     85  C   ASP    14      50.378  21.560  65.861  1.00 24.12           C  
ATOM     86  O   ASP    14      49.775  20.505  66.099  1.00 24.08           O  
ATOM     87  CB  ASP    14      50.303  23.017  67.872  1.00 25.34           C  
ATOM     88  CG  ASP    14      49.842  24.344  68.475  1.00 27.52           C  
ATOM     89  OD1 ASP    14      50.553  25.363  68.292  1.00 29.57           O  
ATOM     90  OD2 ASP    14      48.759  24.366  69.108  1.00 29.16           O  
ATOM     91  N   GLY    15      51.474  21.643  65.104  1.00 24.35           N  
ATOM     92  CA  GLY    15      52.109  20.442  64.523  1.00 24.03           C  
ATOM     93  C   GLY    15      51.370  19.759  63.375  1.00 24.06           C  
ATOM     94  O   GLY    15      51.829  18.728  62.915  1.00 24.44           O  
ATOM     95  N   ALA    16      50.237  20.303  62.919  1.00 24.06           N  
ATOM     96  CA  ALA    16      49.507  19.703  61.805  1.00 25.16           C  
ATOM     97  C   ALA    16      48.940  20.748  60.833  1.00 25.27           C  
ATOM     98  O   ALA    16      49.489  20.959  59.745  1.00 26.24           O  
ATOM     99  CB  ALA    16      48.424  18.744  62.299  1.00 25.08           C  
ATOM    100  N   LEU    17      47.865  21.415  61.239  1.00 24.72           N  
ATOM    101  CA  LEU    17      47.293  22.507  60.467  0.50 24.60           C  
ATOM    103  C   LEU    17      48.303  23.653  60.282  1.00 24.79           C  
ATOM    104  O   LEU    17      48.373  24.261  59.223  1.00 24.69           O  
ATOM    105  CB  LEU    17      46.048  23.045  61.188  0.50 24.67           C  
ATOM    107  CG  LEU    17      45.298  24.166  60.484  0.50 22.73           C  
ATOM    109  CD1 LEU    17      44.590  23.620  59.290  0.50 21.17           C  
ATOM    111  CD2 LEU    17      44.307  24.780  61.426  0.50 24.59           C  
ATOM    113  N   LEU    18      49.063  23.947  61.328  1.00 24.24           N  
ATOM    114  CA  LEU    18      49.948  25.112  61.313  1.00 24.06           C  
ATOM    115  C   LEU    18      51.362  24.684  61.027  1.00 23.97           C  
ATOM    116  O   LEU    18      51.832  23.682  61.581  1.00 23.46           O  
ATOM    117  CB  LEU    18      49.979  25.804  62.674  1.00 24.49           C  
ATOM    118  CG  LEU    18      48.695  26.396  63.242  1.00 26.89           C  
ATOM    119  CD1 LEU    18      49.022  27.243  64.441  1.00 28.82           C  
ATOM    120  CD2 LEU    18      47.977  27.204  62.171  1.00 30.68           C  
ATOM    121  N   ARG    19      52.048  25.466  60.196  1.00 22.83           N  
ATOM    122  CA  ARG    19      53.493  25.358  60.033  1.00 22.38           C  
ATOM    123  C   ARG    19      54.177  25.715  61.348  1.00 23.88           C  
ATOM    124  O   ARG    19      53.533  26.298  62.230  1.00 24.58           O  
ATOM    125  CB  ARG    19      53.948  26.318  58.936  1.00 21.76           C  
ATOM    126  CG  ARG    19      53.468  25.901  57.548  1.00 22.17           C  
ATOM    127  CD  ARG    19      53.934  26.920  56.486  1.00 22.97           C  
ATOM    128  NE  ARG    19      55.382  27.057  56.473  1.00 26.02           N  
ATOM    129  CZ  ARG    19      56.201  26.234  55.821  1.00 26.76           C  
ATOM    130  NH1 ARG    19      55.711  25.222  55.115  1.00 24.02           N  
ATOM    131  NH2 ARG    19      57.517  26.439  55.854  1.00 27.49           N  
ATOM    132  N   SER    20      55.474  25.442  61.480  1.00 23.98           N  
ATOM    133  CA  SER    20      56.170  25.724  62.749  0.50 24.69           C  
ATOM    135  C   SER    20      56.314  27.208  63.018  1.00 25.45           C  
ATOM    136  O   SER    20      56.571  27.609  64.158  1.00 27.08           O  
ATOM    137  CB  SER    20      57.532  25.038  62.816  0.50 24.83           C  
ATOM    139  OG  SER    20      58.378  25.470  61.782  0.50 22.79           O  
ATOM    141  N   ASN    21      56.145  28.033  61.990  1.00 25.31           N  
ATOM    142  CA  ASN    21      56.128  29.493  62.202  1.00 26.85           C  
ATOM    143  C   ASN    21      54.719  30.047  62.494  1.00 27.13           C  
ATOM    144  O   ASN    21      54.530  31.272  62.574  1.00 28.54           O  
ATOM    145  CB  ASN    21      56.766  30.217  61.013  1.00 27.65           C  
ATOM    146  CG  ASN    21      55.984  30.014  59.721  1.00 29.55           C  
ATOM    147  OD1 ASN    21      54.897  29.445  59.739  1.00 28.27           O  
ATOM    148  ND2 ASN    21      56.549  30.460  58.590  1.00 31.07           N  
ATOM    149  N   GLY    22      53.737  29.163  62.628  1.00 25.53           N  
ATOM    150  CA  GLY    22      52.387  29.527  63.002  1.00 25.70           C  
ATOM    151  C   GLY    22      51.485  29.910  61.853  1.00 25.79           C  
ATOM    152  O   GLY    22      50.292  30.178  62.058  1.00 27.47           O  
ATOM    153  N   LYS    23      52.021  29.911  60.645  1.00 24.24           N  
ATOM    154  CA  LYS    23      51.223  30.238  59.465  1.00 25.66           C  
ATOM    155  C   LYS    23      50.427  29.032  58.983  1.00 25.17           C  
ATOM    156  O   LYS    23      50.855  27.911  59.153  1.00 24.56           O  
ATOM    157  CB  LYS    23      52.117  30.762  58.330  1.00 25.43           C  
ATOM    158  CG  LYS    23      52.785  32.105  58.702  1.00 27.84           C  
ATOM    159  CD  LYS    23      53.244  32.848  57.454  1.00 30.68           C  
ATOM    160  CE  LYS    23      53.760  34.234  57.782  1.00 28.94           C  
ATOM    161  NZ  LYS    23      52.715  35.300  57.751  1.00 29.37           N  
ATOM    162  N   ILE    24      49.249  29.288  58.406  1.00 25.05           N  
ATOM    163  CA  ILE    24      48.492  28.250  57.692  1.00 24.61           C  
ATOM    164  C   ILE    24      48.836  28.392  56.223  1.00 24.55           C  
ATOM    165  O   ILE    24      48.561  29.435  55.618  1.00 23.98           O  
ATOM    166  CB  ILE    24      46.968  28.406  57.879  1.00 24.43           C  
ATOM    167  CG1 ILE    24      46.617  28.469  59.371  1.00 26.44           C  
ATOM    168  CG2 ILE    24      46.215  27.250  57.165  1.00 26.26           C  
ATOM    169  CD1 ILE    24      45.173  28.887  59.631  1.00 28.57           C  
ATOM    170  N   HIS    25      49.450  27.361  55.639  1.00 23.24           N  
ATOM    171  CA  HIS    25      49.853  27.392  54.219  1.00 23.46           C  
ATOM    172  C   HIS    25      48.615  27.448  53.296  1.00 23.13           C  
ATOM    173  O   HIS    25      47.581  26.857  53.600  1.00 22.32           O  
ATOM    174  CB  HIS    25      50.711  26.150  53.888  1.00 23.35           C  
ATOM    175  CG  HIS    25      51.489  26.271  52.617  1.00 24.93           C  
ATOM    176  ND1 HIS    25      50.970  25.915  51.391  1.00 25.91           N  
ATOM    177  CD2 HIS    25      52.750  26.707  52.383  1.00 25.47           C  
ATOM    178  CE1 HIS    25      51.877  26.134  50.452  1.00 29.41           C  
ATOM    179  NE2 HIS    25      52.966  26.617  51.029  1.00 27.47           N  
ATOM    180  N   GLN    26      48.711  28.178  52.186  1.00 23.33           N  
ATOM    181  CA  GLN    26      47.586  28.242  51.235  1.00 24.16           C  
ATOM    182  C   GLN    26      47.101  26.853  50.791  1.00 23.73           C  
ATOM    183  O   GLN    26      45.909  26.616  50.628  1.00 23.72           O  
ATOM    184  CB  GLN    26      47.951  29.079  50.005  1.00 25.56           C  
ATOM    185  CG  GLN    26      46.757  29.297  49.048  1.00 27.94           C  
ATOM    186  CD  GLN    26      45.643  30.104  49.695  1.00 29.07           C  
ATOM    187  OE1 GLN    26      45.884  31.167  50.253  1.00 31.50           O  
ATOM    188  NE2 GLN    26      44.424  29.598  49.627  1.00 31.03           N  
ATOM    189  N   ALA    27      48.026  25.925  50.620  1.00 23.38           N  
ATOM    190  CA  ALA    27      47.657  24.552  50.203  1.00 23.29           C  
ATOM    191  C   ALA    27      46.735  23.850  51.206  1.00 22.81           C  
ATOM    192  O   ALA    27      45.839  23.056  50.834  1.00 23.09           O  
ATOM    193  CB  ALA    27      48.915  23.708  49.930  1.00 22.66           C  
ATOM    194  N   THR    28      46.933  24.179  52.474  1.00 22.59           N  
ATOM    195  CA  THR    28      46.164  23.629  53.542  1.00 22.61           C  
ATOM    196  C   THR    28      44.731  24.189  53.494  1.00 22.57           C  
ATOM    197  O   THR    28      43.758  23.433  53.647  1.00 21.44           O  
ATOM    198  CB  THR    28      46.837  23.968  54.896  1.00 22.91           C  
ATOM    199  OG1 THR    28      48.216  23.533  54.845  1.00 24.83           O  
ATOM    200  CG2 THR    28      46.126  23.252  56.001  1.00 22.58           C  
ATOM    201  N   LYS    29      44.627  25.501  53.288  1.00 22.30           N  
ATOM    202  CA  LYS    29      43.359  26.181  53.109  1.00 23.06           C  
ATOM    203  C   LYS    29      42.612  25.581  51.924  1.00 23.15           C  
ATOM    204  O   LYS    29      41.420  25.279  52.029  1.00 22.86           O  
ATOM    205  CB  LYS    29      43.599  27.683  52.910  1.00 23.25           C  
ATOM    206  CG  LYS    29      44.128  28.315  54.166  1.00 26.35           C  
ATOM    207  CD  LYS    29      44.230  29.796  54.031  1.00 31.59           C  
ATOM    208  CE  LYS    29      44.681  30.363  55.349  1.00 34.35           C  
ATOM    209  NZ  LYS    29      44.844  31.817  55.183  1.00 37.71           N  
ATOM    210  N   ASP    30      43.318  25.381  50.805  1.00 23.81           N  
ATOM    211  CA  ASP    30      42.702  24.826  49.608  1.00 24.01           C  
ATOM    212  C   ASP    30      42.220  23.391  49.847  1.00 23.94           C  
ATOM    213  O   ASP    30      41.125  23.013  49.411  1.00 23.20           O  
ATOM    214  CB  ASP    30      43.652  24.895  48.400  1.00 24.83           C  
ATOM    215  CG  ASP    30      44.001  26.344  47.987  1.00 28.08           C  
ATOM    216  OD1 ASP    30      43.319  27.297  48.421  1.00 31.03           O  
ATOM    217  OD2 ASP    30      44.973  26.531  47.207  1.00 30.74           O  
ATOM    218  N   ALA    31      43.032  22.600  50.554  1.00 22.91           N  
ATOM    219  CA  ALA    31      42.656  21.219  50.851  1.00 23.25           C  
ATOM    220  C   ALA    31      41.406  21.159  51.735  1.00 22.86           C  
ATOM    221  O   ALA    31      40.491  20.378  51.456  1.00 23.53           O  
ATOM    222  CB  ALA    31      43.832  20.452  51.501  1.00 22.70           C  
ATOM    223  N   ILE    32      41.345  22.004  52.763  1.00 22.86           N  
ATOM    224  CA  ILE    32      40.174  22.022  53.676  1.00 24.08           C  
ATOM    225  C   ILE    32      38.897  22.482  52.960  1.00 24.09           C  
ATOM    226  O   ILE    32      37.834  21.899  53.157  1.00 23.39           O  
ATOM    227  CB  ILE    32      40.478  22.819  54.970  1.00 24.17           C  
ATOM    228  CG1 ILE    32      41.480  22.018  55.828  1.00 26.95           C  
ATOM    229  CG2 ILE    32      39.216  23.101  55.802  1.00 25.00           C  
ATOM    230  CD1 ILE    32      42.097  22.820  56.869  1.00 33.14           C  
ATOM    231  N   GLU    33      39.009  23.502  52.110  1.00 25.36           N  
ATOM    232  CA  GLU    33      37.880  23.960  51.299  1.00 27.05           C  
ATOM    233  C   GLU    33      37.351  22.819  50.425  1.00 26.16           C  
ATOM    234  O   GLU    33      36.147  22.583  50.344  1.00 26.64           O  
ATOM    235  CB  GLU    33      38.326  25.123  50.405  1.00 27.23           C  
ATOM    236  CG  GLU    33      37.236  25.620  49.481  1.00 29.62           C  
ATOM    237  CD  GLU    33      37.638  26.869  48.708  1.00 32.79           C  
ATOM    238  OE1 GLU    33      38.853  27.052  48.407  1.00 39.72           O  
ATOM    239  OE2 GLU    33      36.724  27.664  48.377  1.00 40.81           O  
ATOM    240  N   TYR    34      38.261  22.092  49.793  1.00 24.96           N  
ATOM    241  CA  TYR    34      37.861  20.961  48.968  1.00 25.67           C  
ATOM    242  C   TYR    34      37.136  19.878  49.790  1.00 25.32           C  
ATOM    243  O   TYR    34      36.093  19.371  49.368  1.00 26.28           O  
ATOM    244  CB  TYR    34      39.080  20.371  48.269  1.00 26.00           C  
ATOM    245  CG  TYR    34      38.715  19.304  47.255  1.00 27.85           C  
ATOM    246  CD1 TYR    34      38.370  19.649  45.954  1.00 28.71           C  
ATOM    247  CD2 TYR    34      38.702  17.955  47.609  1.00 28.41           C  
ATOM    248  CE1 TYR    34      38.040  18.675  45.016  1.00 30.02           C  
ATOM    249  CE2 TYR    34      38.376  16.967  46.676  1.00 30.06           C  
ATOM    250  CZ  TYR    34      38.041  17.339  45.392  1.00 29.85           C  
ATOM    251  OH  TYR    34      37.703  16.375  44.472  1.00 31.87           O  
ATOM    252  N   VAL    35      37.707  19.518  50.936  1.00 24.93           N  
ATOM    253  CA  VAL    35      37.145  18.495  51.844  1.00 25.76           C  
ATOM    254  C   VAL    35      35.690  18.832  52.214  1.00 26.68           C  
ATOM    255  O   VAL    35      34.787  17.983  52.122  1.00 26.22           O  
ATOM    256  CB  VAL    35      38.010  18.369  53.144  1.00 25.70           C  
ATOM    257  CG1 VAL    35      37.301  17.518  54.201  1.00 25.36           C  
ATOM    258  CG2 VAL    35      39.396  17.791  52.816  1.00 27.20           C  
ATOM    259  N   LYS    36      35.484  20.081  52.631  1.00 26.28           N  
ATOM    260  CA  LYS    36      34.158  20.606  52.971  1.00 27.35           C  
ATOM    261  C   LYS    36      33.184  20.574  51.782  1.00 28.31           C  
ATOM    262  O   LYS    36      32.012  20.256  51.950  1.00 28.21           O  
ATOM    263  CB  LYS    36      34.298  22.018  53.522  1.00 27.03           C  
ATOM    264  CG  LYS    36      34.806  22.052  54.954  1.00 28.56           C  
ATOM    265  CD  LYS    36      34.950  23.494  55.483  1.00 27.72           C  
ATOM    266  CE  LYS    36      33.587  24.133  55.783  1.00 32.60           C  
ATOM    267  NZ  LYS    36      32.768  23.365  56.795  1.00 34.40           N  
ATOM    268  N   LYS    37      33.679  20.892  50.589  1.00 29.26           N  
ATOM    269  CA  LYS    37      32.875  20.910  49.367  1.00 31.00           C  
ATOM    270  C   LYS    37      32.397  19.483  49.050  1.00 30.88           C  
ATOM    271  O   LYS    37      31.316  19.287  48.493  1.00 30.71           O  
ATOM    272  CB  LYS    37      33.714  21.498  48.216  1.00 30.85           C  
ATOM    273  CG  LYS    37      32.965  21.866  46.941  1.00 33.81           C  
ATOM    274  CD  LYS    37      33.954  22.296  45.849  1.00 33.63           C  
ATOM    275  CE  LYS    37      33.263  22.487  44.506  1.00 37.30           C  
ATOM    276  NZ  LYS    37      34.147  22.033  43.390  1.00 40.68           N  
ATOM    277  N   LYS    38      33.195  18.495  49.455  1.00 31.07           N  
ATOM    278  CA  LYS    38      32.858  17.080  49.266  1.00 31.54           C  
ATOM    279  C   LYS    38      31.920  16.521  50.339  1.00 31.64           C  
ATOM    280  O   LYS    38      31.583  15.336  50.311  1.00 32.09           O  
ATOM    281  CB  LYS    38      34.130  16.235  49.180  1.00 31.54           C  
ATOM    282  CG  LYS    38      34.977  16.547  47.962  1.00 33.50           C  
ATOM    283  CD  LYS    38      34.261  16.225  46.641  1.00 37.72           C  
ATOM    284  CE  LYS    38      34.129  14.711  46.450  1.00 41.39           C  
ATOM    285  NZ  LYS    38      33.660  14.331  45.082  1.00 42.99           N  
ATOM    286  N   GLY    39      31.523  17.364  51.288  1.00 30.54           N  
ATOM    287  CA  GLY    39      30.557  16.984  52.308  1.00 30.28           C  
ATOM    288  C   GLY    39      31.143  16.408  53.584  1.00 29.53           C  
ATOM    289  O   GLY    39      30.408  15.969  54.465  1.00 30.24           O  
ATOM    290  N   ILE    40      32.463  16.437  53.714  1.00 28.20           N  
ATOM    291  CA  ILE    40      33.113  15.914  54.912  1.00 27.30           C  
ATOM    292  C   ILE    40      33.134  16.977  56.021  1.00 26.53           C  
ATOM    293  O   ILE    40      33.489  18.126  55.766  1.00 25.76           O  
ATOM    294  CB  ILE    40      34.545  15.411  54.560  1.00 26.64           C  
ATOM    295  CG1 ILE    40      34.433  14.216  53.596  1.00 28.03           C  
ATOM    296  CG2 ILE    40      35.357  15.077  55.834  1.00 25.77           C  
ATOM    297  CD1 ILE    40      35.690  13.989  52.719  1.00 26.43           C  
ATOM    298  N   TYR    41      32.759  16.591  57.243  1.00 26.02           N  
ATOM    299  CA  TYR    41      32.716  17.522  58.373  1.00 25.38           C  
ATOM    300  C   TYR    41      34.156  17.697  58.843  1.00 25.27           C  
ATOM    301  O   TYR    41      34.865  16.693  59.047  1.00 24.68           O  
ATOM    302  CB  TYR    41      31.909  16.899  59.494  1.00 26.37           C  
ATOM    303  CG  TYR    41      31.554  17.785  60.700  1.00 27.48           C  
ATOM    304  CD1 TYR    41      30.309  18.382  60.786  1.00 28.59           C  
ATOM    305  CD2 TYR    41      32.450  17.970  61.775  1.00 28.27           C  
ATOM    306  CE1 TYR    41      29.947  19.155  61.889  1.00 29.47           C  
ATOM    307  CE2 TYR    41      32.092  18.754  62.897  1.00 29.43           C  
ATOM    308  CZ  TYR    41      30.827  19.332  62.936  1.00 29.11           C  
ATOM    309  OH  TYR    41      30.409  20.096  64.013  1.00 28.75           O  
ATOM    310  N   VAL    42      34.608  18.942  58.958  1.00 23.79           N  
ATOM    311  CA  VAL    42      36.002  19.208  59.371  1.00 23.71           C  
ATOM    312  C   VAL    42      36.002  19.914  60.731  1.00 24.94           C  
ATOM    313  O   VAL    42      35.384  20.981  60.907  1.00 25.46           O  
ATOM    314  CB  VAL    42      36.794  20.060  58.336  1.00 22.33           C  
ATOM    315  CG1 VAL    42      38.207  20.363  58.867  1.00 24.54           C  
ATOM    316  CG2 VAL    42      36.846  19.387  56.961  1.00 20.26           C  
ATOM    317  N   THR    43      36.712  19.341  61.692  1.00 25.37           N  
ATOM    318  CA  THR    43      36.816  19.992  62.990  1.00 26.04           C  
ATOM    319  C   THR    43      38.256  19.976  63.496  1.00 24.85           C  
ATOM    320  O   THR    43      39.131  19.283  62.926  1.00 25.08           O  
ATOM    321  CB  THR    43      35.881  19.367  64.023  1.00 26.77           C  
ATOM    322  OG1 THR    43      35.868  20.214  65.194  1.00 30.70           O  
ATOM    323  CG2 THR    43      36.333  17.945  64.392  1.00 26.35           C  
ATOM    324  N   LEU    44      38.480  20.721  64.568  1.00 23.09           N  
ATOM    325  CA  LEU    44      39.802  20.826  65.170  1.00 23.27           C  
ATOM    326  C   LEU    44      39.761  20.093  66.507  1.00 23.03           C  
ATOM    327  O   LEU    44      38.747  20.137  67.234  1.00 24.38           O  
ATOM    328  CB  LEU    44      40.193  22.306  65.365  1.00 22.31           C  
ATOM    329  CG  LEU    44      40.108  23.141  64.071  1.00 23.25           C  
ATOM    330  CD1 LEU    44      40.439  24.642  64.366  1.00 26.01           C  
ATOM    331  CD2 LEU    44      41.059  22.559  62.992  1.00 25.08           C  
ATOM    332  N   VAL    45      40.835  19.370  66.799  1.00 22.18           N  
ATOM    333  CA  VAL    45      40.983  18.659  68.061  0.50 22.15           C  
ATOM    335  C   VAL    45      42.315  19.106  68.647  1.00 22.54           C  
ATOM    336  O   VAL    45      43.365  18.795  68.091  1.00 23.44           O  
ATOM    337  CB  VAL    45      40.882  17.111  67.863  0.50 22.53           C  
ATOM    339  CG1 VAL    45      41.743  16.626  66.699  0.50 20.55           C  
ATOM    341  CG2 VAL    45      41.216  16.364  69.150  0.50 22.45           C  
ATOM    343  N   THR    46      42.268  19.832  69.763  1.00 21.76           N  
ATOM    344  CA  THR    46      43.431  20.613  70.192  1.00 21.81           C  
ATOM    345  C   THR    46      43.554  20.762  71.691  1.00 21.47           C  
ATOM    346  O   THR    46      42.546  20.719  72.425  1.00 21.29           O  
ATOM    347  CB  THR    46      43.389  22.038  69.512  1.00 23.35           C  
ATOM    348  OG1 THR    46      44.618  22.725  69.750  1.00 23.07           O  
ATOM    349  CG2 THR    46      42.189  22.914  70.046  1.00 24.16           C  
ATOM    350  N   ASN    47      44.793  20.935  72.130  1.00 21.21           N  
ATOM    351  CA  ASN    47      45.074  21.417  73.490  1.00 22.60           C  
ATOM    352  C   ASN    47      44.889  22.927  73.644  1.00 22.42           C  
ATOM    353  O   ASN    47      44.891  23.422  74.773  1.00 22.92           O  
ATOM    354  CB  ASN    47      46.514  21.061  73.901  1.00 22.46           C  
ATOM    355  CG  ASN    47      46.706  19.558  74.061  1.00 25.07           C  
ATOM    356  OD1 ASN    47      45.756  18.830  74.350  1.00 28.70           O  
ATOM    357  ND2 ASN    47      47.919  19.099  73.874  1.00 26.45           N  
ATOM    358  N   ARG    48      44.766  23.642  72.527  1.00 21.70           N  
ATOM    359  CA  ARG    48      44.621  25.128  72.590  1.00 22.31           C  
ATOM    360  C   ARG    48      43.334  25.546  73.281  1.00 21.33           C  
ATOM    361  O   ARG    48      42.367  24.793  73.281  1.00 21.43           O  
ATOM    362  CB  ARG    48      44.602  25.701  71.185  1.00 22.83           C  
ATOM    363  CG  ARG    48      46.020  25.748  70.580  1.00 26.34           C  
ATOM    364  CD  ARG    48      46.039  26.722  69.403  1.00 27.37           C  
ATOM    365  NE  ARG    48      47.403  26.804  68.879  1.00 28.67           N  
ATOM    366  CZ  ARG    48      47.886  27.842  68.223  1.00 30.50           C  
ATOM    367  NH1 ARG    48      47.106  28.904  68.015  1.00 30.63           N  
ATOM    368  NH2 ARG    48      49.151  27.813  67.782  1.00 28.11           N  
ATOM    369  N   HIS    49      43.340  26.753  73.837  1.00 20.28           N  
ATOM    370  CA  HIS    49      42.122  27.286  74.438  1.00 20.93           C  
ATOM    371  C   HIS    49      41.112  27.590  73.339  1.00 20.60           C  
ATOM    372  O   HIS    49      41.482  27.707  72.139  1.00 19.38           O  
ATOM    373  CB  HIS    49      42.432  28.486  75.362  1.00 20.36           C  
ATOM    374  CG  HIS    49      43.039  29.684  74.687  1.00 22.13           C  
ATOM    375  ND1 HIS    49      42.293  30.600  73.965  1.00 22.00           N  
ATOM    376  CD2 HIS    49      44.310  30.157  74.690  1.00 22.70           C  
ATOM    377  CE1 HIS    49      43.080  31.580  73.543  1.00 23.02           C  
ATOM    378  NE2 HIS    49      44.305  31.349  73.992  1.00 23.55           N  
ATOM    379  N   PHE    50      39.838  27.646  73.725  1.00 20.17           N  
ATOM    380  CA  PHE    50      38.758  27.704  72.750  1.00 20.73           C  
ATOM    381  C   PHE    50      38.892  28.914  71.799  1.00 21.11           C  
ATOM    382  O   PHE    50      38.740  28.799  70.551  1.00 21.34           O  
ATOM    383  CB  PHE    50      37.368  27.777  73.419  1.00 20.96           C  
ATOM    384  CG  PHE    50      36.269  27.807  72.391  1.00 21.48           C  
ATOM    385  CD1 PHE    50      35.951  26.638  71.710  1.00 21.51           C  
ATOM    386  CD2 PHE    50      35.669  29.013  72.009  1.00 22.59           C  
ATOM    387  CE1 PHE    50      34.993  26.646  70.684  1.00 23.30           C  
ATOM    388  CE2 PHE    50      34.695  29.024  70.990  1.00 20.94           C  
ATOM    389  CZ  PHE    50      34.356  27.834  70.344  1.00 20.08           C  
ATOM    390  N   ARG    51      39.145  30.075  72.377  1.00 20.54           N  
ATOM    391  CA  ARG    51      39.239  31.285  71.582  1.00 20.39           C  
ATOM    392  C   ARG    51      40.305  31.191  70.466  1.00 20.64           C  
ATOM    393  O   ARG    51      40.025  31.535  69.318  1.00 20.00           O  
ATOM    394  CB  ARG    51      39.476  32.492  72.485  1.00 21.15           C  
ATOM    395  CG  ARG    51      39.698  33.770  71.707  1.00 22.28           C  
ATOM    396  CD  ARG    51      39.879  34.931  72.698  1.00 21.76           C  
ATOM    397  NE  ARG    51      40.420  36.050  71.947  1.00 26.25           N  
ATOM    398  CZ  ARG    51      39.656  36.881  71.238  1.00 25.66           C  
ATOM    399  NH1 ARG    51      38.323  36.734  71.227  1.00 21.50           N  
ATOM    400  NH2 ARG    51      40.228  37.864  70.570  1.00 22.78           N  
ATOM    401  N   SER    52      41.501  30.708  70.784  1.00 20.61           N  
ATOM    402  CA  SER    52      42.523  30.554  69.758  1.00 22.63           C  
ATOM    403  C   SER    52      42.037  29.592  68.651  1.00 22.74           C  
ATOM    404  O   SER    52      42.141  29.902  67.431  1.00 21.96           O  
ATOM    405  CB  SER    52      43.832  30.074  70.387  1.00 22.87           C  
ATOM    406  OG  SER    52      44.788  29.862  69.357  1.00 26.87           O  
ATOM    407  N   ALA    53      41.493  28.437  69.060  1.00 20.89           N  
ATOM    408  CA  ALA    53      40.951  27.451  68.102  1.00 22.06           C  
ATOM    409  C   ALA    53      39.863  28.060  67.190  1.00 22.53           C  
ATOM    410  O   ALA    53      39.842  27.822  65.971  1.00 21.42           O  
ATOM    411  CB  ALA    53      40.381  26.209  68.844  1.00 20.73           C  
ATOM    412  N   GLN    54      38.972  28.852  67.784  1.00 21.77           N  
ATOM    413  CA  GLN    54      37.863  29.434  67.034  1.00 22.99           C  
ATOM    414  C   GLN    54      38.352  30.471  66.008  1.00 23.32           C  
ATOM    415  O   GLN    54      37.810  30.553  64.902  1.00 22.70           O  
ATOM    416  CB  GLN    54      36.818  30.043  67.983  1.00 23.51           C  
ATOM    417  CG  GLN    54      35.409  30.303  67.345  1.00 25.23           C  
ATOM    418  CD  GLN    54      35.338  31.586  66.526  1.00 29.86           C  
ATOM    419  OE1 GLN    54      36.043  32.576  66.813  1.00 25.97           O  
ATOM    420  NE2 GLN    54      34.484  31.573  65.470  1.00 31.74           N  
ATOM    421  N   LYS    55      39.360  31.270  66.354  1.00 22.59           N  
ATOM    422  CA  LYS    55      39.867  32.236  65.362  1.00 23.42           C  
ATOM    423  C   LYS    55      40.453  31.500  64.160  1.00 23.55           C  
ATOM    424  O   LYS    55      40.245  31.914  63.011  1.00 23.20           O  
ATOM    425  CB  LYS    55      40.909  33.165  65.993  1.00 23.58           C  
ATOM    426  CG  LYS    55      40.316  34.052  67.114  1.00 25.05           C  
ATOM    427  CD  LYS    55      39.268  35.041  66.621  1.00 27.47           C  
ATOM    428  CE  LYS    55      38.929  36.141  67.677  1.00 26.35           C  
ATOM    429  NZ  LYS    55      37.822  37.000  67.145  1.00 27.23           N  
ATOM    430  N   ILE    56      41.144  30.398  64.429  1.00 23.00           N  
ATOM    431  CA  ILE    56      41.709  29.540  63.366  1.00 24.02           C  
ATOM    432  C   ILE    56      40.572  28.924  62.527  1.00 23.51           C  
ATOM    433  O   ILE    56      40.601  28.985  61.296  1.00 22.40           O  
ATOM    434  CB  ILE    56      42.641  28.470  63.951  1.00 24.23           C  
ATOM    435  CG1 ILE    56      43.923  29.147  64.465  1.00 27.31           C  
ATOM    436  CG2 ILE    56      42.995  27.421  62.871  1.00 24.80           C  
ATOM    437  CD1 ILE    56      44.653  28.378  65.516  1.00 31.44           C  
ATOM    438  N   ALA    57      39.573  28.359  63.202  1.00 22.14           N  
ATOM    439  CA  ALA    57      38.357  27.865  62.520  1.00 22.65           C  
ATOM    440  C   ALA    57      37.681  28.943  61.649  1.00 23.56           C  
ATOM    441  O   ALA    57      37.234  28.665  60.517  1.00 24.43           O  
ATOM    442  CB  ALA    57      37.370  27.325  63.533  1.00 22.21           C  
ATOM    443  N   LYS    58      37.629  30.177  62.144  1.00 24.66           N  
ATOM    444  CA  LYS    58      37.056  31.275  61.381  1.00 26.83           C  
ATOM    445  C   LYS    58      37.842  31.502  60.081  1.00 26.21           C  
ATOM    446  O   LYS    58      37.247  31.711  59.014  1.00 26.97           O  
ATOM    447  CB  LYS    58      36.992  32.552  62.238  1.00 26.20           C  
ATOM    448  CG  LYS    58      36.160  33.654  61.624  1.00 28.89           C  
ATOM    449  CD  LYS    58      36.119  34.893  62.548  1.00 30.34           C  
ATOM    450  CE  LYS    58      35.429  36.020  61.816  1.00 36.90           C  
ATOM    451  NZ  LYS    58      35.490  37.304  62.544  1.00 39.28           N  
ATOM    452  N   SER    59      39.164  31.428  60.166  1.00 26.49           N  
ATOM    453  CA  SER    59      40.052  31.595  58.999  0.50 26.74           C  
ATOM    455  C   SER    59      39.793  30.531  57.939  1.00 27.28           C  
ATOM    456  O   SER    59      39.928  30.787  56.723  1.00 27.35           O  
ATOM    457  CB  SER    59      41.516  31.523  59.432  0.50 26.35           C  
ATOM    459  OG  SER    59      41.897  32.723  60.090  0.50 27.19           O  
ATOM    461  N   LEU    60      39.447  29.331  58.416  1.00 25.49           N  
ATOM    462  CA  LEU    60      39.179  28.172  57.546  1.00 26.35           C  
ATOM    463  C   LEU    60      37.705  28.037  57.199  1.00 26.59           C  
ATOM    464  O   LEU    60      37.310  27.069  56.526  1.00 26.80           O  
ATOM    465  CB  LEU    60      39.656  26.886  58.228  1.00 25.25           C  
ATOM    466  CG  LEU    60      41.138  26.779  58.538  1.00 27.58           C  
ATOM    467  CD1 LEU    60      41.387  25.562  59.387  1.00 28.20           C  
ATOM    468  CD2 LEU    60      41.902  26.711  57.211  1.00 28.42           C  
ATOM    469  N   LYS    61      36.897  28.989  57.665  1.00 27.23           N  
ATOM    470  CA  LYS    61      35.432  28.981  57.478  1.00 28.49           C  
ATOM    471  C   LYS    61      34.784  27.641  57.908  1.00 27.82           C  
ATOM    472  O   LYS    61      33.917  27.112  57.198  1.00 27.47           O  
ATOM    473  CB  LYS    61      35.076  29.295  56.004  1.00 28.70           C  
ATOM    474  CG  LYS    61      35.668  30.598  55.463  1.00 30.96           C  
ATOM    475  CD  LYS    61      35.543  30.753  53.935  1.00 32.09           C  
ATOM    476  CE  LYS    61      36.849  30.335  53.258  1.00 36.97           C  
ATOM    477  NZ  LYS    61      36.860  30.655  51.781  1.00 41.53           N  
ATOM    478  N   LEU    62      35.190  27.089  59.048  1.00 26.95           N  
ATOM    479  CA  LEU    62      34.717  25.753  59.448  1.00 27.46           C  
ATOM    480  C   LEU    62      33.252  25.648  59.899  1.00 29.60           C  
ATOM    481  O   LEU    62      32.591  24.655  59.602  1.00 30.44           O  
ATOM    482  CB  LEU    62      35.586  25.149  60.542  1.00 26.53           C  
ATOM    483  CG  LEU    62      37.049  24.843  60.217  1.00 26.51           C  
ATOM    484  CD1 LEU    62      37.672  24.005  61.374  1.00 25.49           C  
ATOM    485  CD2 LEU    62      37.160  24.116  58.867  1.00 25.94           C  
ATOM    486  N   ASP    63      32.775  26.618  60.661  1.00 31.37           N  
ATOM    487  CA  ASP    63      31.447  26.481  61.308  1.00 34.07           C  
ATOM    488  C   ASP    63      31.144  25.066  61.854  1.00 33.74           C  
ATOM    489  O   ASP    63      30.177  24.419  61.456  1.00 35.61           O  
ATOM    490  CB  ASP    63      30.357  26.950  60.343  1.00 35.41           C  
ATOM    491  CG  ASP    63      30.539  28.405  59.959  1.00 39.11           C  
ATOM    492  OD1 ASP    63      30.700  29.246  60.888  1.00 41.22           O  
ATOM    493  OD2 ASP    63      30.551  28.698  58.739  1.00 43.66           O  
ATOM    494  N   ALA    64      31.990  24.589  62.757  1.00 32.83           N  
ATOM    495  CA  ALA    64      31.909  23.216  63.257  1.00 30.86           C  
ATOM    496  C   ALA    64      32.060  23.248  64.770  1.00 29.07           C  
ATOM    497  O   ALA    64      32.556  24.223  65.310  1.00 29.36           O  
ATOM    498  CB  ALA    64      33.030  22.400  62.660  1.00 32.36           C  
ATOM    499  N   LYS    65      31.665  22.172  65.445  1.00 27.04           N  
ATOM    500  CA  LYS    65      31.967  22.001  66.873  1.00 25.79           C  
ATOM    501  C   LYS    65      33.456  21.687  67.034  1.00 24.88           C  
ATOM    502  O   LYS    65      33.943  20.690  66.483  1.00 26.80           O  
ATOM    503  CB  LYS    65      31.145  20.861  67.467  1.00 26.09           C  
ATOM    504  CG  LYS    65      29.645  21.189  67.709  1.00 24.81           C  
ATOM    505  CD  LYS    65      28.846  19.911  68.020  1.00 27.18           C  
ATOM    506  CE  LYS    65      27.327  20.155  68.132  1.00 30.13           C  
ATOM    507  NZ  LYS    65      26.732  20.900  66.973  1.00 31.93           N  
ATOM    508  N   LEU    66      34.169  22.513  67.793  1.00 22.23           N  
ATOM    509  CA  LEU    66      35.607  22.356  67.914  1.00 21.65           C  
ATOM    510  C   LEU    66      35.872  21.678  69.255  1.00 21.94           C  
ATOM    511  O   LEU    66      35.179  21.973  70.250  1.00 21.43           O  
ATOM    512  CB  LEU    66      36.280  23.737  67.899  1.00 21.77           C  
ATOM    513  CG  LEU    66      35.849  24.630  66.719  1.00 21.08           C  
ATOM    514  CD1 LEU    66      36.443  26.057  66.921  1.00 23.95           C  
ATOM    515  CD2 LEU    66      36.285  24.034  65.394  1.00 21.87           C  
ATOM    516  N   ILE    67      36.851  20.786  69.274  1.00 21.05           N  
ATOM    517  CA  ILE    67      37.226  20.056  70.494  1.00 21.79           C  
ATOM    518  C   ILE    67      38.489  20.699  71.055  1.00 21.05           C  
ATOM    519  O   ILE    67      39.567  20.585  70.479  1.00 20.88           O  
ATOM    520  CB  ILE    67      37.438  18.545  70.200  1.00 22.27           C  
ATOM    521  CG1 ILE    67      36.119  17.950  69.663  1.00 24.26           C  
ATOM    522  CG2 ILE    67      37.846  17.799  71.502  1.00 21.10           C  
ATOM    523  CD1 ILE    67      36.317  16.897  68.631  1.00 27.11           C  
ATOM    524  N   THR    68      38.335  21.429  72.157  1.00 19.41           N  
ATOM    525  CA  THR    68      39.412  22.313  72.640  1.00 19.84           C  
ATOM    526  C   THR    68      39.685  22.018  74.123  1.00 19.61           C  
ATOM    527  O   THR    68      38.961  21.215  74.761  1.00 20.40           O  
ATOM    528  CB  THR    68      39.033  23.825  72.394  1.00 19.80           C  
ATOM    529  OG1 THR    68      38.006  24.217  73.305  1.00 19.77           O  
ATOM    530  CG2 THR    68      38.499  23.997  70.973  1.00 21.02           C  
ATOM    531  N   HIS    69      40.721  22.659  74.663  1.00 19.41           N  
ATOM    532  CA  HIS    69      41.147  22.453  76.055  1.00 19.78           C  
ATOM    533  C   HIS    69      41.289  20.937  76.284  1.00 20.78           C  
ATOM    534  O   HIS    69      40.790  20.420  77.295  1.00 20.95           O  
ATOM    535  CB  HIS    69      40.138  23.082  77.062  1.00 19.33           C  
ATOM    536  CG  HIS    69      40.027  24.582  76.972  1.00 19.21           C  
ATOM    537  ND1 HIS    69      40.623  25.425  77.886  1.00 18.89           N  
ATOM    538  CD2 HIS    69      39.384  25.384  76.083  1.00 19.50           C  
ATOM    539  CE1 HIS    69      40.328  26.686  77.581  1.00 18.35           C  
ATOM    540  NE2 HIS    69      39.569  26.686  76.493  1.00 19.29           N  
ATOM    541  N   SER    70      41.930  20.221  75.335  1.00 20.83           N  
ATOM    542  CA  SER    70      42.220  18.789  75.517  0.50 21.41           C  
ATOM    544  C   SER    70      40.949  17.908  75.620  1.00 22.14           C  
ATOM    545  O   SER    70      40.992  16.797  76.208  1.00 22.78           O  
ATOM    546  CB  SER    70      43.086  18.618  76.773  0.50 21.80           C  
ATOM    548  OG  SER    70      43.785  17.398  76.758  0.50 21.52           O  
ATOM    550  N   GLY    71      39.823  18.399  75.087  1.00 21.30           N  
ATOM    551  CA  GLY    71      38.531  17.682  75.145  1.00 21.84           C  
ATOM    552  C   GLY    71      37.566  18.176  76.216  1.00 20.49           C  
ATOM    553  O   GLY    71      36.451  17.666  76.334  1.00 22.40           O  
ATOM    554  N   ALA    72      38.003  19.123  77.053  1.00 19.92           N  
ATOM    555  CA  ALA    72      37.170  19.600  78.164  1.00 20.96           C  
ATOM    556  C   ALA    72      36.155  20.646  77.731  1.00 21.33           C  
ATOM    557  O   ALA    72      35.248  20.972  78.484  1.00 22.16           O  
ATOM    558  CB  ALA    72      38.064  20.183  79.302  1.00 21.39           C  
ATOM    559  N   TYR    73      36.331  21.205  76.536  1.00 21.33           N  
ATOM    560  CA  TYR    73      35.467  22.316  76.085  1.00 21.67           C  
ATOM    561  C   TYR    73      35.156  22.166  74.603  1.00 21.49           C  
ATOM    562  O   TYR    73      36.061  22.265  73.755  1.00 21.48           O  
ATOM    563  CB  TYR    73      36.119  23.682  76.371  1.00 21.37           C  
ATOM    564  CG  TYR    73      35.080  24.761  76.456  1.00 21.71           C  
ATOM    565  CD1 TYR    73      34.381  24.960  77.663  1.00 23.03           C  
ATOM    566  CD2 TYR    73      34.778  25.582  75.357  1.00 23.35           C  
ATOM    567  CE1 TYR    73      33.374  25.928  77.776  1.00 26.01           C  
ATOM    568  CE2 TYR    73      33.747  26.588  75.461  1.00 21.42           C  
ATOM    569  CZ  TYR    73      33.081  26.748  76.670  1.00 25.65           C  
ATOM    570  OH  TYR    73      32.096  27.695  76.850  1.00 24.71           O  
ATOM    571  N   ILE    74      33.904  21.843  74.281  1.00 21.45           N  
ATOM    572  CA  ILE    74      33.530  21.515  72.889  1.00 21.25           C  
ATOM    573  C   ILE    74      32.403  22.451  72.530  1.00 21.83           C  
ATOM    574  O   ILE    74      31.382  22.491  73.221  1.00 21.41           O  
ATOM    575  CB  ILE    74      33.079  20.030  72.706  1.00 21.10           C  
ATOM    576  CG1 ILE    74      34.181  19.066  73.213  1.00 21.25           C  
ATOM    577  CG2 ILE    74      32.687  19.744  71.221  1.00 21.03           C  
ATOM    578  CD1 ILE    74      33.749  17.567  73.338  1.00 21.33           C  
ATOM    579  N   ALA    75      32.616  23.242  71.483  1.00 21.36           N  
ATOM    580  CA  ALA    75      31.686  24.331  71.193  1.00 21.45           C  
ATOM    581  C   ALA    75      31.867  24.891  69.799  1.00 21.63           C  
ATOM    582  O   ALA    75      32.903  24.688  69.162  1.00 20.86           O  
ATOM    583  CB  ALA    75      31.899  25.494  72.243  1.00 21.22           C  
ATOM    584  N   GLU    76      30.827  25.558  69.314  1.00 22.41           N  
ATOM    585  CA  GLU    76      30.984  26.384  68.125  0.50 22.73           C  
ATOM    587  C   GLU    76      31.083  27.854  68.505  1.00 23.14           C  
ATOM    588  O   GLU    76      31.827  28.629  67.858  1.00 23.26           O  
ATOM    589  CB  GLU    76      29.854  26.166  67.128  0.50 22.55           C  
ATOM    591  CG  GLU    76      30.171  26.782  65.765  0.50 23.11           C  
ATOM    593  CD  GLU    76      29.105  26.535  64.712  0.50 24.63           C  
ATOM    595  OE1 GLU    76      28.124  25.806  64.978  0.50 25.39           O  
ATOM    597  OE2 GLU    76      29.248  27.108  63.616  0.50 22.88           O  
ATOM    599  N   LYS    77      30.382  28.242  69.569  1.00 23.36           N  
ATOM    600  CA  LYS    77      30.450  29.622  70.066  1.00 24.10           C  
ATOM    601  C   LYS    77      30.680  29.580  71.569  1.00 22.97           C  
ATOM    602  O   LYS    77      30.090  28.767  72.269  1.00 22.29           O  
ATOM    603  CB  LYS    77      29.171  30.410  69.739  1.00 24.74           C  
ATOM    604  CG  LYS    77      28.963  30.705  68.229  1.00 25.92           C  
ATOM    605  CD  LYS    77      27.715  31.554  68.048  1.00 27.04           C  
ATOM    606  CE  LYS    77      27.350  31.768  66.560  1.00 30.16           C  
ATOM    607  NZ  LYS    77      26.213  32.750  66.465  1.00 32.73           N  
ATOM    608  N   ILE    78      31.583  30.435  72.043  1.00 22.60           N  
ATOM    609  CA  ILE    78      32.071  30.339  73.413  1.00 22.07           C  
ATOM    610  C   ILE    78      31.012  30.326  74.533  1.00 22.75           C  
ATOM    611  O   ILE    78      31.152  29.564  75.504  1.00 23.41           O  
ATOM    612  CB  ILE    78      33.171  31.402  73.697  1.00 21.45           C  
ATOM    613  CG1 ILE    78      33.998  30.962  74.928  1.00 23.92           C  
ATOM    614  CG2 ILE    78      32.562  32.812  73.824  1.00 21.51           C  
ATOM    615  CD1 ILE    78      35.292  31.689  75.027  1.00 24.33           C  
ATOM    616  N   ASP    79      29.970  31.146  74.440  1.00 23.59           N  
ATOM    617  CA  ASP    79      29.029  31.223  75.570  1.00 24.43           C  
ATOM    618  C   ASP    79      28.100  30.016  75.696  1.00 25.45           C  
ATOM    619  O   ASP    79      27.417  29.879  76.716  1.00 24.78           O  
ATOM    620  CB  ASP    79      28.210  32.536  75.557  1.00 24.23           C  
ATOM    621  CG  ASP    79      29.086  33.776  75.601  1.00 27.88           C  
ATOM    622  OD1 ASP    79      29.804  33.964  76.614  1.00 26.74           O  
ATOM    623  OD2 ASP    79      29.094  34.527  74.593  1.00 32.80           O  
ATOM    624  N   ALA    80      28.066  29.156  74.665  1.00 25.69           N  
ATOM    625  CA  ALA    80      27.047  28.111  74.563  1.00 26.54           C  
ATOM    626  C   ALA    80      27.682  26.765  74.211  1.00 26.30           C  
ATOM    627  O   ALA    80      27.503  26.249  73.096  1.00 27.12           O  
ATOM    628  CB  ALA    80      25.985  28.507  73.530  1.00 26.86           C  
ATOM    629  N   PRO    81      28.447  26.184  75.142  1.00 26.15           N  
ATOM    630  CA  PRO    81      29.122  24.949  74.732  1.00 24.68           C  
ATOM    631  C   PRO    81      28.218  23.743  74.545  1.00 24.12           C  
ATOM    632  O   PRO    81      27.161  23.624  75.174  1.00 22.35           O  
ATOM    633  CB  PRO    81      30.133  24.700  75.858  1.00 25.45           C  
ATOM    634  CG  PRO    81      29.445  25.319  77.098  1.00 26.62           C  
ATOM    635  CD  PRO    81      28.774  26.577  76.531  1.00 25.97           C  
ATOM    636  N   PHE    82      28.635  22.882  73.622  1.00 23.55           N  
ATOM    637  CA  PHE    82      28.009  21.589  73.410  1.00 23.30           C  
ATOM    638  C   PHE    82      28.340  20.635  74.570  1.00 23.67           C  
ATOM    639  O   PHE    82      27.463  19.880  75.036  1.00 22.81           O  
ATOM    640  CB  PHE    82      28.527  21.019  72.092  1.00 24.35           C  
ATOM    641  CG  PHE    82      28.172  19.587  71.875  1.00 25.21           C  
ATOM    642  CD1 PHE    82      26.838  19.213  71.728  1.00 28.92           C  
ATOM    643  CD2 PHE    82      29.165  18.615  71.831  1.00 27.78           C  
ATOM    644  CE1 PHE    82      26.501  17.867  71.539  1.00 30.70           C  
ATOM    645  CE2 PHE    82      28.833  17.275  71.630  1.00 31.51           C  
ATOM    646  CZ  PHE    82      27.502  16.912  71.485  1.00 30.20           C  
ATOM    647  N   PHE    83      29.607  20.662  75.011  1.00 22.68           N  
ATOM    648  CA  PHE    83      30.089  19.864  76.127  1.00 22.25           C  
ATOM    649  C   PHE    83      31.094  20.714  76.902  1.00 22.99           C  
ATOM    650  O   PHE    83      32.029  21.288  76.312  1.00 23.07           O  
ATOM    651  CB  PHE    83      30.776  18.557  75.645  1.00 23.52           C  
ATOM    652  CG  PHE    83      31.457  17.768  76.743  1.00 22.78           C  
ATOM    653  CD1 PHE    83      30.727  16.888  77.557  1.00 26.75           C  
ATOM    654  CD2 PHE    83      32.847  17.887  76.951  1.00 24.70           C  
ATOM    655  CE1 PHE    83      31.354  16.155  78.577  1.00 28.70           C  
ATOM    656  CE2 PHE    83      33.499  17.159  77.979  1.00 24.92           C  
ATOM    657  CZ  PHE    83      32.743  16.278  78.787  1.00 25.97           C  
ATOM    658  N   GLU    84      30.936  20.765  78.225  1.00 23.12           N  
ATOM    659  CA  GLU    84      31.992  21.343  79.050  1.00 23.53           C  
ATOM    660  C   GLU    84      32.175  20.569  80.340  1.00 23.50           C  
ATOM    661  O   GLU    84      31.204  20.097  80.934  1.00 23.03           O  
ATOM    662  CB  GLU    84      31.722  22.822  79.341  1.00 23.79           C  
ATOM    663  CG  GLU    84      30.401  23.073  80.119  1.00 26.04           C  
ATOM    664  CD  GLU    84      30.205  24.545  80.531  1.00 27.27           C  
ATOM    665  OE1 GLU    84      31.156  25.360  80.506  1.00 26.40           O  
ATOM    666  OE2 GLU    84      29.069  24.870  80.924  1.00 28.28           O  
ATOM    667  N   LYS    85      33.420  20.423  80.766  1.00 22.93           N  
ATOM    668  CA  LYS    85      33.724  19.846  82.086  0.50 23.87           C  
ATOM    670  C   LYS    85      34.910  20.625  82.634  1.00 23.56           C  
ATOM    671  O   LYS    85      35.825  20.950  81.895  1.00 23.95           O  
ATOM    672  CB  LYS    85      34.083  18.357  81.996  0.50 23.73           C  
ATOM    674  CG  LYS    85      32.957  17.384  82.336  0.50 24.82           C  
ATOM    676  CD  LYS    85      33.505  15.997  82.769  0.50 24.33           C  
ATOM    678  CE  LYS    85      33.555  15.811  84.294  0.50 25.99           C  
ATOM    680  NZ  LYS    85      33.861  14.401  84.745  0.50 26.26           N  
ATOM    682  N   ARG    86      34.903  20.903  83.919  1.00 23.57           N  
ATOM    683  CA  ARG    86      36.034  21.610  84.495  1.00 23.90           C  
ATOM    684  C   ARG    86      36.348  21.086  85.880  1.00 24.29           C  
ATOM    685  O   ARG    86      35.484  20.487  86.553  1.00 23.66           O  
ATOM    686  CB  ARG    86      35.786  23.128  84.490  1.00 24.99           C  
ATOM    687  CG  ARG    86      34.591  23.615  85.302  1.00 25.07           C  
ATOM    688  CD  ARG    86      34.303  25.123  85.038  1.00 25.14           C  
ATOM    689  NE  ARG    86      33.702  25.398  83.719  1.00 25.31           N  
ATOM    690  CZ  ARG    86      34.236  26.201  82.789  1.00 26.67           C  
ATOM    691  NH1 ARG    86      35.374  26.830  83.012  1.00 26.27           N  
ATOM    692  NH2 ARG    86      33.627  26.379  81.614  1.00 26.28           N  
ATOM    693  N   ILE    87      37.591  21.304  86.302  1.00 23.22           N  
ATOM    694  CA  ILE    87      38.047  20.923  87.641  1.00 23.10           C  
ATOM    695  C   ILE    87      37.449  21.940  88.647  1.00 24.10           C  
ATOM    696  O   ILE    87      37.432  23.160  88.378  1.00 24.17           O  
ATOM    697  CB  ILE    87      39.604  20.913  87.674  1.00 22.67           C  
ATOM    698  CG1 ILE    87      40.155  19.959  86.594  1.00 21.94           C  
ATOM    699  CG2 ILE    87      40.155  20.545  89.091  1.00 22.37           C  
ATOM    700  CD1 ILE    87      41.673  20.106  86.366  1.00 24.37           C  
ATOM    701  N   SER    88      36.896  21.460  89.764  1.00 23.35           N  
ATOM    702  CA  SER    88      36.274  22.367  90.747  1.00 23.33           C  
ATOM    703  C   SER    88      37.265  23.407  91.232  1.00 23.89           C  
ATOM    704  O   SER    88      38.486  23.190  91.140  1.00 22.80           O  
ATOM    705  CB  SER    88      35.722  21.610  91.964  1.00 23.72           C  
ATOM    706  OG  SER    88      36.795  21.101  92.744  1.00 23.82           O  
ATOM    707  N   ASP    89      36.763  24.531  91.735  1.00 23.87           N  
ATOM    708  CA  ASP    89      37.707  25.521  92.262  1.00 26.50           C  
ATOM    709  C   ASP    89      38.550  25.003  93.433  1.00 25.69           C  
ATOM    710  O   ASP    89      39.761  25.286  93.514  1.00 24.91           O  
ATOM    711  CB  ASP    89      37.099  26.927  92.521  1.00 27.17           C  
ATOM    712  CG  ASP    89      35.754  26.920  93.224  1.00 34.53           C  
ATOM    713  OD1 ASP    89      35.381  25.939  93.922  1.00 37.65           O  
ATOM    714  OD2 ASP    89      35.055  27.972  93.088  1.00 39.94           O  
ATOM    715  N   ASP    90      37.930  24.213  94.312  1.00 25.37           N  
ATOM    716  CA  ASP    90      38.670  23.688  95.451  0.50 25.31           C  
ATOM    718  C   ASP    90      39.719  22.673  95.024  1.00 24.86           C  
ATOM    719  O   ASP    90      40.851  22.735  95.504  1.00 24.95           O  
ATOM    720  CB  ASP    90      37.719  23.169  96.525  0.50 25.14           C  
ATOM    722  CG  ASP    90      36.780  24.263  97.018  0.50 26.90           C  
ATOM    724  OD1 ASP    90      37.266  25.386  97.275  0.50 26.76           O  
ATOM    726  OD2 ASP    90      35.561  24.010  97.107  0.50 28.34           O  
ATOM    728  N   HIS    91      39.370  21.771  94.104  1.00 24.96           N  
ATOM    729  CA  HIS    91      40.356  20.826  93.562  1.00 24.21           C  
ATOM    730  C   HIS    91      41.470  21.540  92.799  1.00 24.77           C  
ATOM    731  O   HIS    91      42.640  21.158  92.917  1.00 24.87           O  
ATOM    732  CB  HIS    91      39.685  19.793  92.654  1.00 24.69           C  
ATOM    733  CG  HIS    91      38.908  18.747  93.410  1.00 26.40           C  
ATOM    734  ND1 HIS    91      37.982  17.920  92.808  1.00 28.55           N  
ATOM    735  CD2 HIS    91      38.933  18.395  94.718  1.00 28.91           C  
ATOM    736  CE1 HIS    91      37.464  17.109  93.720  1.00 28.06           C  
ATOM    737  NE2 HIS    91      38.034  17.367  94.881  1.00 27.01           N  
ATOM    738  N   THR    92      41.117  22.567  92.019  1.00 23.57           N  
ATOM    739  CA  THR    92      42.132  23.372  91.320  1.00 23.55           C  
ATOM    740  C   THR    92      43.130  23.966  92.321  1.00 23.89           C  
ATOM    741  O   THR    92      44.352  23.837  92.148  1.00 23.39           O  
ATOM    742  CB  THR    92      41.464  24.477  90.469  1.00 24.44           C  
ATOM    743  OG1 THR    92      40.688  23.848  89.434  1.00 23.71           O  
ATOM    744  CG2 THR    92      42.491  25.426  89.820  1.00 23.99           C  
ATOM    745  N   PHE    93      42.619  24.555  93.399  1.00 23.98           N  
ATOM    746  CA  PHE    93      43.498  25.117  94.433  1.00 24.53           C  
ATOM    747  C   PHE    93      44.425  24.043  95.046  1.00 24.75           C  
ATOM    748  O   PHE    93      45.644  24.257  95.175  1.00 24.62           O  
ATOM    749  CB  PHE    93      42.656  25.808  95.518  1.00 24.20           C  
ATOM    750  CG  PHE    93      43.456  26.295  96.690  1.00 24.55           C  
ATOM    751  CD1 PHE    93      44.079  27.546  96.644  1.00 23.25           C  
ATOM    752  CD2 PHE    93      43.582  25.508  97.839  1.00 24.77           C  
ATOM    753  CE1 PHE    93      44.795  28.026  97.744  1.00 25.66           C  
ATOM    754  CE2 PHE    93      44.321  25.968  98.927  1.00 28.70           C  
ATOM    755  CZ  PHE    93      44.926  27.235  98.874  1.00 27.67           C  
ATOM    756  N   ASN    94      43.849  22.899  95.417  1.00 24.28           N  
ATOM    757  CA  ASN    94      44.615  21.821  96.053  1.00 25.00           C  
ATOM    758  C   ASN    94      45.670  21.242  95.113  1.00 24.16           C  
ATOM    759  O   ASN    94      46.787  20.912  95.540  1.00 23.37           O  
ATOM    760  CB  ASN    94      43.675  20.691  96.523  1.00 24.95           C  
ATOM    761  CG  ASN    94      42.833  21.082  97.717  1.00 28.63           C  
ATOM    762  OD1 ASN    94      43.170  21.988  98.466  1.00 30.96           O  
ATOM    763  ND2 ASN    94      41.726  20.374  97.908  1.00 33.96           N  
ATOM    764  N   ILE    95      45.301  21.098  93.838  1.00 23.11           N  
ATOM    765  CA  ILE    95      46.232  20.615  92.833  1.00 23.14           C  
ATOM    766  C   ILE    95      47.380  21.595  92.644  1.00 23.25           C  
ATOM    767  O   ILE    95      48.550  21.180  92.642  1.00 23.42           O  
ATOM    768  CB  ILE    95      45.539  20.303  91.496  1.00 22.15           C  
ATOM    769  CG1 ILE    95      44.625  19.059  91.666  1.00 23.25           C  
ATOM    770  CG2 ILE    95      46.600  20.110  90.374  1.00 22.80           C  
ATOM    771  CD1 ILE    95      43.608  18.920  90.526  1.00 22.98           C  
ATOM    772  N   VAL    96      47.060  22.888  92.545  1.00 22.69           N  
ATOM    773  CA  VAL    96      48.100  23.906  92.442  1.00 23.28           C  
ATOM    774  C   VAL    96      49.068  23.864  93.627  1.00 24.25           C  
ATOM    775  O   VAL    96      50.295  23.989  93.454  1.00 24.61           O  
ATOM    776  CB  VAL    96      47.488  25.317  92.278  1.00 23.65           C  
ATOM    777  CG1 VAL    96      48.516  26.412  92.512  1.00 24.35           C  
ATOM    778  CG2 VAL    96      46.859  25.471  90.874  1.00 23.57           C  
ATOM    779  N   GLN    97      48.541  23.709  94.838  1.00 25.36           N  
ATOM    780  CA  GLN    97      49.424  23.624  96.016  1.00 25.73           C  
ATOM    781  C   GLN    97      50.437  22.476  95.923  1.00 26.30           C  
ATOM    782  O   GLN    97      51.621  22.663  96.230  1.00 25.59           O  
ATOM    783  CB  GLN    97      48.607  23.465  97.284  1.00 26.58           C  
ATOM    784  CG  GLN    97      47.941  24.729  97.740  1.00 29.53           C  
ATOM    785  CD  GLN    97      47.556  24.621  99.202  1.00 34.30           C  
ATOM    786  OE1 GLN    97      46.953  23.630  99.634  1.00 38.22           O  
ATOM    787  NE2 GLN    97      47.909  25.625  99.965  1.00 33.95           N  
ATOM    788  N   VAL    98      49.975  21.294  95.507  1.00 25.44           N  
ATOM    789  CA  VAL    98      50.871  20.140  95.297  1.00 25.65           C  
ATOM    790  C   VAL    98      51.943  20.420  94.232  1.00 25.69           C  
ATOM    791  O   VAL    98      53.131  20.180  94.468  1.00 25.67           O  
ATOM    792  CB  VAL    98      50.074  18.830  94.944  1.00 25.00           C  
ATOM    793  CG1 VAL    98      51.016  17.668  94.604  1.00 25.34           C  
ATOM    794  CG2 VAL    98      49.144  18.437  96.107  1.00 25.98           C  
ATOM    795  N   LEU    99      51.514  20.923  93.074  1.00 24.55           N  
ATOM    796  CA  LEU    99      52.410  21.250  91.964  1.00 24.75           C  
ATOM    797  C   LEU    99      53.432  22.319  92.341  1.00 24.75           C  
ATOM    798  O   LEU    99      54.538  22.322  91.821  1.00 24.16           O  
ATOM    799  CB  LEU    99      51.590  21.751  90.771  1.00 24.18           C  
ATOM    800  CG  LEU    99      50.646  20.756  90.086  1.00 23.25           C  
ATOM    801  CD1 LEU    99      49.801  21.461  89.000  1.00 25.60           C  
ATOM    802  CD2 LEU    99      51.398  19.593  89.490  1.00 26.40           C  
ATOM    803  N   GLU   100      53.051  23.241  93.225  1.00 24.86           N  
ATOM    804  CA  GLU   100      53.987  24.257  93.719  1.00 25.62           C  
ATOM    805  C   GLU   100      55.195  23.703  94.483  1.00 25.99           C  
ATOM    806  O   GLU   100      56.229  24.373  94.588  1.00 26.50           O  
ATOM    807  CB  GLU   100      53.240  25.309  94.555  1.00 25.45           C  
ATOM    808  CG  GLU   100      52.480  26.276  93.656  1.00 25.86           C  
ATOM    809  CD  GLU   100      51.646  27.259  94.435  1.00 29.79           C  
ATOM    810  OE1 GLU   100      51.422  27.015  95.630  1.00 29.23           O  
ATOM    811  OE2 GLU   100      51.205  28.279  93.859  1.00 28.43           O  
ATOM    812  N   SER   101      55.070  22.491  95.008  1.00 26.91           N  
ATOM    813  CA  SER   101      56.191  21.837  95.686  1.00 27.88           C  
ATOM    814  C   SER   101      57.197  21.199  94.694  1.00 28.12           C  
ATOM    815  O   SER   101      58.288  20.756  95.101  1.00 27.43           O  
ATOM    816  CB  SER   101      55.663  20.827  96.693  1.00 27.76           C  
ATOM    817  OG  SER   101      55.126  19.698  96.013  1.00 30.42           O  
ATOM    818  N   TYR   102      56.848  21.171  93.404  1.00 27.81           N  
ATOM    819  CA  TYR   102      57.752  20.646  92.362  1.00 28.47           C  
ATOM    820  C   TYR   102      58.315  21.769  91.498  1.00 28.53           C  
ATOM    821  O   TYR   102      57.724  22.846  91.414  1.00 28.15           O  
ATOM    822  CB  TYR   102      57.016  19.689  91.419  1.00 29.44           C  
ATOM    823  CG  TYR   102      56.582  18.380  91.998  1.00 29.79           C  
ATOM    824  CD1 TYR   102      57.393  17.245  91.865  1.00 32.75           C  
ATOM    825  CD2 TYR   102      55.348  18.247  92.630  1.00 30.53           C  
ATOM    826  CE1 TYR   102      56.993  16.017  92.375  1.00 34.59           C  
ATOM    827  CE2 TYR   102      54.938  17.025  93.160  1.00 32.33           C  
ATOM    828  CZ  TYR   102      55.766  15.919  93.028  1.00 33.34           C  
ATOM    829  OH  TYR   102      55.399  14.694  93.536  1.00 34.62           O  
ATOM    830  N   GLN   103      59.435  21.501  90.825  1.00 27.96           N  
ATOM    831  CA  GLN   103      60.007  22.432  89.843  1.00 28.01           C  
ATOM    832  C   GLN   103      59.215  22.347  88.538  1.00 27.48           C  
ATOM    833  O   GLN   103      59.582  21.623  87.593  1.00 26.24           O  
ATOM    834  CB  GLN   103      61.508  22.149  89.606  1.00 28.39           C  
ATOM    835  CG  GLN   103      62.260  23.245  88.794  1.00 31.88           C  
ATOM    836  CD  GLN   103      62.241  24.634  89.443  1.00 35.99           C  
ATOM    837  OE1 GLN   103      62.423  24.784  90.658  1.00 37.49           O  
ATOM    838  NE2 GLN   103      62.026  25.659  88.623  1.00 36.64           N  
ATOM    839  N   CYS   104      58.102  23.073  88.490  1.00 26.82           N  
ATOM    840  CA  CYS   104      57.245  23.013  87.321  1.00 26.67           C  
ATOM    841  C   CYS   104      56.543  24.335  87.076  1.00 26.12           C  
ATOM    842  O   CYS   104      56.247  25.093  88.000  1.00 25.39           O  
ATOM    843  CB  CYS   104      56.246  21.858  87.427  1.00 27.15           C  
ATOM    844  SG  CYS   104      54.932  22.068  88.635  1.00 31.66           S  
ATOM    845  N   ASN   105      56.328  24.605  85.804  1.00 25.78           N  
ATOM    846  CA  ASN   105      55.584  25.768  85.366  1.00 25.96           C  
ATOM    847  C   ASN   105      54.135  25.312  85.218  1.00 25.15           C  
ATOM    848  O   ASN   105      53.872  24.277  84.611  1.00 23.84           O  
ATOM    849  CB  ASN   105      56.154  26.268  84.038  1.00 27.40           C  
ATOM    850  CG  ASN   105      55.475  27.535  83.579  1.00 33.06           C  
ATOM    851  OD1 ASN   105      54.409  27.486  82.956  1.00 38.49           O  
ATOM    852  ND2 ASN   105      56.038  28.681  83.963  1.00 30.86           N  
ATOM    853  N   ILE   106      53.219  26.056  85.828  1.00 24.15           N  
ATOM    854  CA  ILE   106      51.812  25.702  85.893  1.00 23.70           C  
ATOM    855  C   ILE   106      51.012  26.758  85.129  1.00 24.07           C  
ATOM    856  O   ILE   106      51.283  27.961  85.273  1.00 23.40           O  
ATOM    857  CB  ILE   106      51.315  25.707  87.370  1.00 23.94           C  
ATOM    858  CG1 ILE   106      52.172  24.822  88.287  1.00 24.39           C  
ATOM    859  CG2 ILE   106      49.812  25.278  87.470  1.00 25.84           C  
ATOM    860  CD1 ILE   106      51.981  25.208  89.792  1.00 23.01           C  
ATOM    861  N   ARG   107      50.028  26.325  84.338  0.50 24.04           N  
ATOM    863  CA  ARG   107      49.100  27.273  83.687  0.50 23.34           C  
ATOM    865  C   ARG   107      47.662  26.792  83.794  0.50 23.38           C  
ATOM    867  O   ARG   107      47.344  25.687  83.378  0.50 22.72           O  
ATOM    869  CB  ARG   107      49.456  27.488  82.218  0.50 24.11           C  
ATOM    871  CG  ARG   107      48.687  28.627  81.527  0.50 24.57           C  
ATOM    873  CD  ARG   107      49.311  28.860  80.166  0.50 31.13           C  
ATOM    875  NE  ARG   107      49.187  30.218  79.624  0.50 34.92           N  
ATOM    877  CZ  ARG   107      50.028  30.709  78.711  0.50 36.28           C  
ATOM    879  NH1 ARG   107      49.891  31.937  78.227  0.50 38.84           N  
ATOM    881  NH2 ARG   107      51.034  29.966  78.284  0.50 38.53           N  
ATOM    883  N   LEU   108      46.802  27.636  84.363  1.00 22.78           N  
ATOM    884  CA  LEU   108      45.371  27.345  84.442  1.00 23.07           C  
ATOM    885  C   LEU   108      44.784  27.829  83.126  1.00 23.31           C  
ATOM    886  O   LEU   108      44.761  29.032  82.856  1.00 23.84           O  
ATOM    887  CB  LEU   108      44.761  28.082  85.633  1.00 23.51           C  
ATOM    888  CG  LEU   108      45.548  27.835  86.936  1.00 23.62           C  
ATOM    889  CD1 LEU   108      44.924  28.674  88.092  1.00 27.25           C  
ATOM    890  CD2 LEU   108      45.526  26.358  87.255  1.00 24.88           C  
ATOM    891  N   LEU   109      44.350  26.895  82.290  1.00 23.14           N  
ATOM    892  CA  LEU   109      43.906  27.234  80.950  1.00 23.54           C  
ATOM    893  C   LEU   109      42.371  27.321  80.899  1.00 23.77           C  
ATOM    894  O   LEU   109      41.670  26.338  80.524  1.00 23.71           O  
ATOM    895  CB  LEU   109      44.483  26.250  79.911  1.00 23.98           C  
ATOM    896  CG  LEU   109      44.344  26.668  78.425  1.00 25.11           C  
ATOM    897  CD1 LEU   109      45.396  27.742  78.054  1.00 24.78           C  
ATOM    898  CD2 LEU   109      44.447  25.467  77.474  1.00 25.64           C  
ATOM    899  N   HIS   110      41.852  28.462  81.362  1.00 22.67           N  
ATOM    900  CA  HIS   110      40.377  28.713  81.353  1.00 22.13           C  
ATOM    901  C   HIS   110      39.998  29.153  79.949  1.00 21.73           C  
ATOM    902  O   HIS   110      40.876  29.580  79.174  1.00 22.49           O  
ATOM    903  CB  HIS   110      40.034  29.763  82.443  1.00 22.73           C  
ATOM    904  CG  HIS   110      38.567  29.938  82.715  1.00 22.61           C  
ATOM    905  ND1 HIS   110      37.757  30.759  81.963  1.00 24.29           N  
ATOM    906  CD2 HIS   110      37.790  29.454  83.719  1.00 23.03           C  
ATOM    907  CE1 HIS   110      36.528  30.753  82.469  1.00 25.00           C  
ATOM    908  NE2 HIS   110      36.522  29.962  83.538  1.00 25.22           N  
ATOM    909  N   GLU   111      38.716  29.037  79.575  1.00 21.19           N  
ATOM    910  CA  GLU   111      38.306  29.511  78.231  1.00 21.14           C  
ATOM    911  C   GLU   111      38.210  31.034  78.104  1.00 20.87           C  
ATOM    912  O   GLU   111      38.114  31.563  77.003  1.00 20.50           O  
ATOM    913  CB  GLU   111      37.042  28.786  77.746  1.00 23.05           C  
ATOM    914  CG  GLU   111      35.742  29.222  78.438  1.00 23.31           C  
ATOM    915  CD  GLU   111      35.458  28.586  79.810  1.00 26.37           C  
ATOM    916  OE1 GLU   111      36.334  27.994  80.494  1.00 24.08           O  
ATOM    917  OE2 GLU   111      34.280  28.711  80.238  1.00 27.05           O  
ATOM    918  N   LYS   112      38.245  31.721  79.250  0.50 20.92           N  
ATOM    920  CA  LYS   112      38.087  33.177  79.310  0.50 20.70           C  
ATOM    922  C   LYS   112      39.411  33.903  79.618  0.50 21.25           C  
ATOM    924  O   LYS   112      39.564  35.113  79.341  0.50 20.94           O  
ATOM    926  CB  LYS   112      36.999  33.550  80.361  0.50 20.26           C  
ATOM    928  CG  LYS   112      36.773  35.067  80.503  0.50 19.15           C  
ATOM    930  CD  LYS   112      36.331  35.672  79.152  0.50 20.20           C  
ATOM    932  CE  LYS   112      36.541  37.191  79.051  0.50 16.26           C  
ATOM    934  NZ  LYS   112      37.931  37.622  79.298  0.50  9.90           N  
ATOM    936  N   TYR   113      40.364  33.180  80.195  1.00 20.88           N  
ATOM    937  CA  TYR   113      41.644  33.777  80.572  1.00 21.91           C  
ATOM    938  C   TYR   113      42.609  32.662  80.866  1.00 22.49           C  
ATOM    939  O   TYR   113      42.204  31.497  81.013  1.00 21.81           O  
ATOM    940  CB  TYR   113      41.512  34.699  81.838  1.00 22.60           C  
ATOM    941  CG  TYR   113      40.792  33.962  82.959  1.00 24.25           C  
ATOM    942  CD1 TYR   113      41.488  33.060  83.770  1.00 25.82           C  
ATOM    943  CD2 TYR   113      39.435  34.120  83.174  1.00 27.52           C  
ATOM    944  CE1 TYR   113      40.835  32.355  84.794  1.00 26.93           C  
ATOM    945  CE2 TYR   113      38.768  33.403  84.192  1.00 28.33           C  
ATOM    946  CZ  TYR   113      39.482  32.520  84.966  1.00 27.71           C  
ATOM    947  OH  TYR   113      38.878  31.808  86.005  1.00 32.23           O  
ATOM    948  N   SER   114      43.889  33.007  80.988  1.00 22.58           N  
ATOM    949  CA  SER   114      44.862  32.027  81.438  1.00 23.73           C  
ATOM    950  C   SER   114      45.713  32.702  82.533  1.00 23.87           C  
ATOM    951  O   SER   114      46.090  33.887  82.417  1.00 22.05           O  
ATOM    952  CB  SER   114      45.689  31.562  80.243  1.00 25.99           C  
ATOM    953  OG  SER   114      46.805  30.826  80.655  1.00 34.48           O  
ATOM    954  N   ILE   115      46.051  31.937  83.572  1.00 23.45           N  
ATOM    955  CA  ILE   115      46.928  32.458  84.610  1.00 24.88           C  
ATOM    956  C   ILE   115      47.953  31.398  84.897  1.00 24.20           C  
ATOM    957  O   ILE   115      47.590  30.243  85.084  1.00 24.37           O  
ATOM    958  CB  ILE   115      46.165  32.731  85.930  1.00 25.11           C  
ATOM    959  CG1 ILE   115      44.833  33.404  85.669  1.00 26.95           C  
ATOM    960  CG2 ILE   115      47.031  33.614  86.880  1.00 26.89           C  
ATOM    961  CD1 ILE   115      43.951  33.559  86.953  1.00 28.56           C  
ATOM    962  N   GLY   116      49.216  31.791  84.969  1.00 24.03           N  
ATOM    963  CA  GLY   116      50.315  30.833  85.268  1.00 24.05           C  
ATOM    964  C   GLY   116      51.233  31.370  86.360  1.00 23.76           C  
ATOM    965  O   GLY   116      51.115  32.543  86.770  1.00 22.74           O  
ATOM    966  N   ASN   117      52.159  30.526  86.818  1.00 23.26           N  
ATOM    967  CA  ASN   117      53.212  30.957  87.726  1.00 23.63           C  
ATOM    968  C   ASN   117      54.449  31.425  86.946  1.00 23.90           C  
ATOM    969  O   ASN   117      54.405  31.524  85.722  1.00 23.64           O  
ATOM    970  CB  ASN   117      53.548  29.855  88.748  1.00 23.14           C  
ATOM    971  CG  ASN   117      54.198  28.612  88.122  1.00 24.21           C  
ATOM    972  OD1 ASN   117      54.250  28.447  86.896  1.00 25.61           O  
ATOM    973  ND2 ASN   117      54.696  27.728  88.977  1.00 26.73           N  
ATOM    974  N   LYS   118      55.529  31.724  87.650  1.00 23.62           N  
ATOM    975  CA  LYS   118      56.711  32.281  87.012  1.00 25.96           C  
ATOM    976  C   LYS   118      57.923  31.374  87.111  1.00 27.77           C  
ATOM    977  O   LYS   118      59.051  31.813  86.842  1.00 28.62           O  
ATOM    978  CB  LYS   118      57.034  33.653  87.623  1.00 25.98           C  
ATOM    979  CG  LYS   118      56.042  34.711  87.226  1.00 25.72           C  
ATOM    980  CD  LYS   118      56.415  36.069  87.807  1.00 28.58           C  
ATOM    981  CE  LYS   118      55.419  37.087  87.370  1.00 30.46           C  
ATOM    982  NZ  LYS   118      55.884  38.458  87.729  1.00 32.10           N  
ATOM    983  N   LYS   119      57.708  30.121  87.489  1.00 29.44           N  
ATOM    984  CA  LYS   119      58.841  29.200  87.654  1.00 32.60           C  
ATOM    985  C   LYS   119      59.461  28.888  86.300  1.00 33.59           C  
ATOM    986  O   LYS   119      58.738  28.571  85.338  1.00 33.10           O  
ATOM    987  CB  LYS   119      58.399  27.894  88.304  1.00 32.75           C  
ATOM    988  CG  LYS   119      58.288  27.960  89.798  1.00 35.91           C  
ATOM    989  CD  LYS   119      58.459  26.579  90.421  1.00 37.54           C  
ATOM    990  CE  LYS   119      58.129  26.650  91.897  1.00 39.43           C  
ATOM    991  NZ  LYS   119      57.866  25.305  92.472  1.00 40.56           N  
ATOM    992  N   LYS   120      60.790  29.007  86.240  1.00 36.02           N  
ATOM    993  CA  LYS   120      61.578  28.654  85.063  1.00 38.02           C  
ATOM    994  C   LYS   120      61.896  27.170  85.118  1.00 39.04           C  
ATOM    995  O   LYS   120      62.296  26.657  86.164  1.00 38.77           O  
ATOM    996  CB  LYS   120      62.886  29.453  85.030  1.00 38.32           C  
ATOM    997  CG  LYS   120      62.694  30.945  84.772  1.00 40.54           C  
ATOM    998  CD  LYS   120      63.861  31.747  85.335  1.00 44.73           C  
ATOM    999  CE  LYS   120      63.444  33.184  85.676  1.00 46.55           C  
ATOM   1000  NZ  LYS   120      62.821  33.882  84.512  1.00 48.28           N  
ATOM   1001  N   VAL   121      61.689  26.475  84.005  1.00 40.06           N  
ATOM   1002  CA  VAL   121      62.090  25.076  83.913  1.00 42.36           C  
ATOM   1003  C   VAL   121      63.024  24.879  82.729  1.00 43.96           C  
ATOM   1004  O   VAL   121      62.907  25.576  81.713  1.00 44.09           O  
ATOM   1005  CB  VAL   121      60.890  24.090  83.829  1.00 42.18           C  
ATOM   1006  CG1 VAL   121      60.113  24.078  85.145  1.00 42.37           C  
ATOM   1007  CG2 VAL   121      59.973  24.426  82.657  1.00 42.77           C  
ATOM   1008  N   ASN   122      63.956  23.942  82.881  1.00 46.08           N  
ATOM   1009  CA  ASN   122      64.798  23.497  81.784  1.00 48.39           C  
ATOM   1010  C   ASN   122      63.967  22.638  80.835  1.00 49.57           C  
ATOM   1011  O   ASN   122      63.999  21.405  80.907  1.00 50.16           O  
ATOM   1012  CB  ASN   122      66.000  22.705  82.317  1.00 48.37           C  
ATOM   1013  CG  ASN   122      66.775  23.462  83.391  1.00 50.19           C  
ATOM   1014  OD1 ASN   122      66.642  24.684  83.540  1.00 51.78           O  
ATOM   1015  ND2 ASN   122      67.594  22.733  84.150  1.00 51.79           N  
ATOM   1016  N   SER   123      63.204  23.306  79.970  1.00 50.84           N  
ATOM   1017  CA  SER   123      62.344  22.642  78.997  1.00 52.09           C  
ATOM   1018  C   SER   123      62.412  23.349  77.638  1.00 52.92           C  
ATOM   1019  O   SER   123      61.943  24.490  77.493  1.00 52.90           O  
ATOM   1020  CB  SER   123      60.897  22.581  79.517  1.00 51.99           C  
ATOM   1021  OG  SER   123      59.973  22.350  78.464  1.00 52.51           O  
ATOM   1022  N   ASN   124      62.996  22.661  76.655  1.00 54.00           N  
ATOM   1023  CA  ASN   124      63.103  23.175  75.284  1.00 55.02           C  
ATOM   1024  C   ASN   124      61.801  23.189  74.477  1.00 55.68           C  
ATOM   1025  O   ASN   124      61.641  24.014  73.570  1.00 55.59           O  
ATOM   1026  CB  ASN   124      64.182  22.418  74.520  1.00 55.34           C  
ATOM   1027  CG  ASN   124      65.570  22.887  74.882  1.00 56.21           C  
ATOM   1028  OD1 ASN   124      65.761  24.036  75.293  1.00 57.93           O  
ATOM   1029  ND2 ASN   124      66.551  22.002  74.740  1.00 57.10           N  
ATOM   1030  N   LEU   125      60.891  22.265  74.803  1.00 56.35           N  
ATOM   1031  CA  LEU   125      59.562  22.196  74.177  1.00 56.84           C  
ATOM   1032  C   LEU   125      58.695  23.350  74.654  1.00 57.24           C  
ATOM   1033  O   LEU   125      57.808  23.802  73.929  1.00 57.49           O  
ATOM   1034  CB  LEU   125      58.866  20.851  74.461  1.00 56.60           C  
ATOM   1035  CG  LEU   125      59.414  19.595  73.764  1.00 56.47           C  
ATOM   1036  CD1 LEU   125      58.959  18.320  74.476  1.00 54.67           C  
ATOM   1037  CD2 LEU   125      59.050  19.566  72.271  1.00 55.55           C  
ATOM   1038  N   LEU   126      58.945  23.818  75.876  1.00 57.73           N  
ATOM   1039  CA  LEU   126      58.324  25.055  76.352  1.00 58.17           C  
ATOM   1040  C   LEU   126      58.840  26.226  75.516  1.00 58.38           C  
ATOM   1041  O   LEU   126      58.062  27.066  75.082  1.00 58.75           O  
ATOM   1042  CB  LEU   126      58.581  25.290  77.852  1.00 58.02           C  
ATOM   1043  CG  LEU   126      57.955  26.537  78.497  1.00 57.92           C  
ATOM   1044  CD1 LEU   126      56.442  26.615  78.265  1.00 57.28           C  
ATOM   1045  CD2 LEU   126      58.279  26.613  79.991  1.00 58.15           C  
ATOM   1046  N   GLY   127      60.150  26.255  75.277  1.00 58.51           N  
ATOM   1047  CA  GLY   127      60.762  27.265  74.414  1.00 58.47           C  
ATOM   1048  C   GLY   127      60.290  27.216  72.967  1.00 58.45           C  
ATOM   1049  O   GLY   127      60.195  28.256  72.312  1.00 58.83           O  
ATOM   1050  N   LYS   128      59.991  26.014  72.469  1.00 57.98           N  
ATOM   1051  CA  LYS   128      59.581  25.817  71.069  1.00 57.26           C  
ATOM   1052  C   LYS   128      58.092  26.112  70.828  1.00 56.69           C  
ATOM   1053  O   LYS   128      57.711  26.555  69.737  1.00 56.67           O  
ATOM   1054  CB  LYS   128      59.929  24.404  70.605  1.00 57.30           C  
ATOM   1055  N   ALA   129      57.264  25.872  71.847  1.00 55.52           N  
ATOM   1056  CA  ALA   129      55.808  26.000  71.733  1.00 54.54           C  
ATOM   1057  C   ALA   129      55.388  27.394  71.249  1.00 53.82           C  
ATOM   1058  O   ALA   129      55.832  28.398  71.805  1.00 53.76           O  
ATOM   1059  CB  ALA   129      55.143  25.663  73.068  1.00 54.53           C  
ATOM   1060  N   LEU   130      54.543  27.440  70.211  1.00 52.88           N  
ATOM   1061  CA  LEU   130      54.035  28.707  69.641  1.00 51.94           C  
ATOM   1062  C   LEU   130      53.223  29.499  70.664  1.00 51.64           C  
ATOM   1063  O   LEU   130      52.291  28.969  71.270  1.00 51.01           O  
ATOM   1064  CB  LEU   130      53.172  28.455  68.392  1.00 51.60           C  
ATOM   1065  CG  LEU   130      53.828  27.999  67.081  1.00 51.08           C  
ATOM   1066  CD1 LEU   130      52.812  27.305  66.145  1.00 49.55           C  
ATOM   1067  CD2 LEU   130      54.536  29.169  66.372  1.00 50.62           C  
ATOM   1068  N   ILE   131      53.604  30.760  70.860  1.00 51.30           N  
ATOM   1069  CA  ILE   131      52.826  31.703  71.671  1.00 51.22           C  
ATOM   1070  C   ILE   131      51.834  32.416  70.748  1.00 50.60           C  
ATOM   1071  O   ILE   131      52.197  32.851  69.643  1.00 50.90           O  
ATOM   1072  CB  ILE   131      53.726  32.738  72.414  1.00 50.95           C  
ATOM   1073  CG1 ILE   131      54.705  32.021  73.351  1.00 51.52           C  
ATOM   1074  CG2 ILE   131      52.868  33.728  73.217  1.00 52.11           C  
ATOM   1075  CD1 ILE   131      55.385  32.932  74.394  1.00 52.02           C  
ATOM   1076  N   HIS   132      50.584  32.504  71.194  1.00 49.50           N  
ATOM   1077  CA  HIS   132      49.535  33.212  70.451  1.00 48.50           C  
ATOM   1078  C   HIS   132      48.919  34.304  71.336  1.00 47.17           C  
ATOM   1079  O   HIS   132      48.984  34.203  72.571  1.00 47.31           O  
ATOM   1080  CB  HIS   132      48.478  32.246  69.877  1.00 48.91           C  
ATOM   1081  CG  HIS   132      48.268  31.007  70.692  1.00 49.29           C  
ATOM   1082  ND1 HIS   132      47.175  30.834  71.514  1.00 49.90           N  
ATOM   1083  CD2 HIS   132      49.004  29.872  70.798  1.00 50.80           C  
ATOM   1084  CE1 HIS   132      47.246  29.647  72.095  1.00 51.14           C  
ATOM   1085  NE2 HIS   132      48.348  29.042  71.682  1.00 50.86           N  
ATOM   1086  N   PRO   133      48.316  35.336  70.708  1.00 45.46           N  
ATOM   1087  CA  PRO   133      47.994  36.583  71.396  1.00 43.38           C  
ATOM   1088  C   PRO   133      47.016  36.414  72.561  1.00 40.66           C  
ATOM   1089  O   PRO   133      46.119  35.565  72.520  1.00 41.64           O  
ATOM   1090  CB  PRO   133      47.329  37.423  70.302  1.00 43.53           C  
ATOM   1091  CG  PRO   133      47.768  36.811  69.009  1.00 45.34           C  
ATOM   1092  CD  PRO   133      47.876  35.365  69.296  1.00 45.87           C  
ATOM   1093  N   SER   134      47.199  37.212  73.596  1.00 36.90           N  
ATOM   1094  CA  SER   134      46.129  37.393  74.558  1.00 32.79           C  
ATOM   1095  C   SER   134      45.240  38.480  73.920  1.00 30.34           C  
ATOM   1096  O   SER   134      45.583  39.066  72.859  1.00 27.78           O  
ATOM   1097  CB  SER   134      46.681  37.865  75.905  1.00 32.87           C  
ATOM   1098  OG  SER   134      46.999  39.272  75.900  1.00 36.95           O  
ATOM   1099  N   ASP   135      44.110  38.758  74.562  1.00 26.67           N  
ATOM   1100  CA  ASP   135      43.355  39.956  74.228  1.00 24.35           C  
ATOM   1101  C   ASP   135      42.937  40.503  75.578  1.00 23.50           C  
ATOM   1102  O   ASP   135      42.429  39.743  76.426  1.00 22.77           O  
ATOM   1103  CB  ASP   135      42.143  39.649  73.336  1.00 25.82           C  
ATOM   1104  CG  ASP   135      41.363  40.911  72.984  1.00 25.41           C  
ATOM   1105  OD1 ASP   135      41.675  41.547  71.958  1.00 25.59           O  
ATOM   1106  OD2 ASP   135      40.490  41.331  73.771  1.00 24.43           O  
ATOM   1107  N   PRO   136      43.198  41.790  75.808  1.00 22.46           N  
ATOM   1108  CA  PRO   136      42.929  42.348  77.140  1.00 22.89           C  
ATOM   1109  C   PRO   136      41.455  42.294  77.548  1.00 22.23           C  
ATOM   1110  O   PRO   136      41.179  42.356  78.738  1.00 22.64           O  
ATOM   1111  CB  PRO   136      43.431  43.799  77.049  1.00 23.21           C  
ATOM   1112  CG  PRO   136      43.673  44.067  75.587  1.00 23.98           C  
ATOM   1113  CD  PRO   136      43.811  42.758  74.877  1.00 22.40           C  
ATOM   1114  N   ILE   137      40.524  42.184  76.591  1.00 20.68           N  
ATOM   1115  CA  ILE   137      39.112  41.996  76.964  1.00 19.92           C  
ATOM   1116  C   ILE   137      38.774  40.516  76.974  1.00 20.18           C  
ATOM   1117  O   ILE   137      38.279  40.006  77.986  1.00 20.43           O  
ATOM   1118  CB  ILE   137      38.137  42.764  76.029  1.00 20.48           C  
ATOM   1119  CG1 ILE   137      38.385  44.278  76.112  1.00 20.36           C  
ATOM   1120  CG2 ILE   137      36.627  42.411  76.341  1.00 22.15           C  
ATOM   1121  CD1 ILE   137      37.485  45.058  75.112  1.00 21.69           C  
ATOM   1122  N   PHE   138      39.016  39.836  75.853  1.00 18.81           N  
ATOM   1123  CA  PHE   138      38.439  38.488  75.650  1.00 19.03           C  
ATOM   1124  C   PHE   138      39.267  37.350  76.188  1.00 19.99           C  
ATOM   1125  O   PHE   138      38.754  36.210  76.400  1.00 19.78           O  
ATOM   1126  CB  PHE   138      38.096  38.292  74.155  1.00 19.06           C  
ATOM   1127  CG  PHE   138      37.009  39.214  73.704  1.00 19.34           C  
ATOM   1128  CD1 PHE   138      35.684  38.964  74.080  1.00 21.10           C  
ATOM   1129  CD2 PHE   138      37.302  40.382  73.015  1.00 16.73           C  
ATOM   1130  CE1 PHE   138      34.654  39.863  73.698  1.00 18.53           C  
ATOM   1131  CE2 PHE   138      36.335  41.269  72.634  1.00 18.95           C  
ATOM   1132  CZ  PHE   138      34.966  41.025  72.975  1.00 18.88           C  
ATOM   1133  N   TYR   139      40.574  37.598  76.353  1.00 19.75           N  
ATOM   1134  CA  TYR   139      41.473  36.518  76.824  1.00 20.53           C  
ATOM   1135  C   TYR   139      42.730  37.039  77.496  1.00 20.57           C  
ATOM   1136  O   TYR   139      43.808  36.972  76.900  1.00 21.22           O  
ATOM   1137  CB  TYR   139      41.863  35.509  75.694  1.00 20.94           C  
ATOM   1138  CG  TYR   139      42.222  34.171  76.296  1.00 21.08           C  
ATOM   1139  CD1 TYR   139      43.567  33.812  76.545  1.00 22.13           C  
ATOM   1140  CD2 TYR   139      41.214  33.276  76.683  1.00 20.13           C  
ATOM   1141  CE1 TYR   139      43.898  32.604  77.159  1.00 22.09           C  
ATOM   1142  CE2 TYR   139      41.532  32.055  77.296  1.00 21.50           C  
ATOM   1143  CZ  TYR   139      42.875  31.743  77.552  1.00 21.15           C  
ATOM   1144  OH  TYR   139      43.190  30.548  78.146  1.00 22.82           O  
ATOM   1145  N   PRO   140      42.597  37.619  78.700  1.00 21.01           N  
ATOM   1146  CA  PRO   140      43.777  38.101  79.413  1.00 22.31           C  
ATOM   1147  C   PRO   140      44.679  36.951  79.793  1.00 23.43           C  
ATOM   1148  O   PRO   140      44.191  35.850  80.126  1.00 23.59           O  
ATOM   1149  CB  PRO   140      43.192  38.797  80.681  1.00 21.99           C  
ATOM   1150  CG  PRO   140      41.750  38.988  80.419  1.00 21.63           C  
ATOM   1151  CD  PRO   140      41.343  37.925  79.415  1.00 20.43           C  
ATOM   1152  N   VAL   141      45.989  37.165  79.680  1.00 24.46           N  
ATOM   1153  CA  VAL   141      46.979  36.148  80.079  1.00 26.37           C  
ATOM   1154  C   VAL   141      47.938  36.813  81.087  1.00 27.37           C  
ATOM   1155  O   VAL   141      48.544  37.861  80.777  1.00 26.66           O  
ATOM   1156  CB  VAL   141      47.726  35.569  78.858  1.00 27.66           C  
ATOM   1157  CG1 VAL   141      48.822  34.571  79.312  1.00 28.57           C  
ATOM   1158  CG2 VAL   141      46.738  34.851  77.878  1.00 27.79           C  
ATOM   1159  N   GLN   142      48.012  36.276  82.304  1.00 26.50           N  
ATOM   1160  CA  GLN   142      48.876  36.842  83.335  0.50 27.56           C  
ATOM   1162  C   GLN   142      49.671  35.766  84.046  1.00 27.33           C  
ATOM   1163  O   GLN   142      49.246  34.621  84.121  1.00 27.54           O  
ATOM   1164  CB  GLN   142      48.087  37.634  84.385  0.50 28.43           C  
ATOM   1166  CG  GLN   142      48.949  37.900  85.613  0.50 30.06           C  
ATOM   1168  CD  GLN   142      48.548  39.080  86.480  0.50 30.99           C  
ATOM   1170  OE1 GLN   142      47.429  39.601  86.410  0.50 35.08           O  
ATOM   1172  NE2 GLN   142      49.482  39.516  87.299  0.50 32.11           N  
ATOM   1174  N   PHE   143      50.827  36.155  84.572  1.00 27.05           N  
ATOM   1175  CA  PHE   143      51.649  35.294  85.396  1.00 27.00           C  
ATOM   1176  C   PHE   143      51.794  35.938  86.762  1.00 27.02           C  
ATOM   1177  O   PHE   143      51.782  37.171  86.878  1.00 27.45           O  
ATOM   1178  CB  PHE   143      52.994  35.065  84.717  1.00 28.14           C  
ATOM   1179  CG  PHE   143      52.829  34.506  83.345  1.00 32.02           C  
ATOM   1180  CD1 PHE   143      52.469  33.192  83.179  1.00 35.41           C  
ATOM   1181  CD2 PHE   143      52.871  35.331  82.236  1.00 36.59           C  
ATOM   1182  CE1 PHE   143      52.244  32.657  81.901  1.00 39.26           C  
ATOM   1183  CE2 PHE   143      52.665  34.803  80.973  1.00 38.51           C  
ATOM   1184  CZ  PHE   143      52.362  33.463  80.808  1.00 36.64           C  
ATOM   1185  N   VAL   144      51.844  35.101  87.794  1.00 25.14           N  
ATOM   1186  CA  VAL   144      52.039  35.567  89.159  1.00 23.87           C  
ATOM   1187  C   VAL   144      53.121  34.715  89.777  1.00 23.62           C  
ATOM   1188  O   VAL   144      53.361  33.571  89.328  1.00 22.77           O  
ATOM   1189  CB  VAL   144      50.714  35.477  90.001  1.00 24.41           C  
ATOM   1190  CG1 VAL   144      49.709  36.495  89.505  1.00 25.17           C  
ATOM   1191  CG2 VAL   144      50.081  34.042  89.932  1.00 23.84           C  
ATOM   1192  N   GLU   145      53.765  35.250  90.813  1.00 22.68           N  
ATOM   1193  CA  GLU   145      54.763  34.491  91.551  0.50 22.85           C  
ATOM   1195  C   GLU   145      54.113  33.351  92.318  1.00 23.69           C  
ATOM   1196  O   GLU   145      54.665  32.250  92.375  1.00 23.67           O  
ATOM   1197  CB  GLU   145      55.522  35.400  92.504  0.50 22.64           C  
ATOM   1199  CG  GLU   145      56.665  34.738  93.232  0.50 20.07           C  
ATOM   1201  CD  GLU   145      57.330  35.678  94.201  0.50 20.81           C  
ATOM   1203  OE1 GLU   145      56.788  36.772  94.422  0.50 17.89           O  
ATOM   1205  OE2 GLU   145      58.399  35.328  94.737  0.50 20.29           O  
ATOM   1207  N   SER   146      52.933  33.608  92.906  1.00 23.58           N  
ATOM   1208  CA  SER   146      52.247  32.561  93.679  1.00 23.76           C  
ATOM   1209  C   SER   146      50.813  32.345  93.217  1.00 23.53           C  
ATOM   1210  O   SER   146      49.903  33.147  93.548  1.00 22.79           O  
ATOM   1211  CB  SER   146      52.261  32.844  95.188  1.00 25.42           C  
ATOM   1212  OG  SER   146      51.515  31.830  95.861  1.00 24.46           O  
ATOM   1213  N   LEU   147      50.606  31.269  92.467  1.00 22.89           N  
ATOM   1214  CA  LEU   147      49.248  30.958  91.999  1.00 23.97           C  
ATOM   1215  C   LEU   147      48.295  30.642  93.155  1.00 24.07           C  
ATOM   1216  O   LEU   147      47.162  31.144  93.202  1.00 24.91           O  
ATOM   1217  CB  LEU   147      49.252  29.761  91.056  1.00 24.97           C  
ATOM   1218  CG  LEU   147      49.391  30.006  89.573  1.00 28.73           C  
ATOM   1219  CD1 LEU   147      49.332  28.637  88.870  1.00 29.98           C  
ATOM   1220  CD2 LEU   147      48.277  30.946  89.055  1.00 29.01           C  
ATOM   1221  N   SER   148      48.743  29.812  94.089  1.00 23.93           N  
ATOM   1222  CA  SER   148      47.875  29.425  95.200  1.00 24.47           C  
ATOM   1223  C   SER   148      47.493  30.644  96.070  1.00 25.45           C  
ATOM   1224  O   SER   148      46.326  30.747  96.503  1.00 26.17           O  
ATOM   1225  CB  SER   148      48.506  28.300  96.018  1.00 24.85           C  
ATOM   1226  OG  SER   148      49.614  28.833  96.736  1.00 25.70           O  
ATOM   1227  N   ASP   149      48.400  31.608  96.265  1.00 24.13           N  
ATOM   1228  CA  ASP   149      48.009  32.829  96.992  1.00 25.46           C  
ATOM   1229  C   ASP   149      46.912  33.594  96.255  1.00 25.07           C  
ATOM   1230  O   ASP   149      45.987  34.094  96.886  1.00 24.95           O  
ATOM   1231  CB  ASP   149      49.182  33.792  97.289  1.00 25.22           C  
ATOM   1232  CG  ASP   149      50.063  33.338  98.455  1.00 27.73           C  
ATOM   1233  OD1 ASP   149      49.745  32.347  99.159  1.00 30.52           O  
ATOM   1234  OD2 ASP   149      51.114  33.988  98.674  1.00 28.84           O  
ATOM   1235  N   LEU   150      47.035  33.705  94.935  1.00 24.21           N  
ATOM   1236  CA  LEU   150      46.026  34.408  94.132  1.00 24.99           C  
ATOM   1237  C   LEU   150      44.669  33.736  94.275  1.00 23.83           C  
ATOM   1238  O   LEU   150      43.666  34.423  94.529  1.00 23.98           O  
ATOM   1239  CB  LEU   150      46.437  34.409  92.652  1.00 24.98           C  
ATOM   1240  CG  LEU   150      45.430  35.147  91.781  1.00 28.95           C  
ATOM   1241  CD1 LEU   150      45.747  36.615  91.911  1.00 33.55           C  
ATOM   1242  CD2 LEU   150      45.517  34.703  90.357  1.00 33.58           C  
ATOM   1243  N   LEU   151      44.661  32.402  94.155  1.00 23.37           N  
ATOM   1244  CA  LEU   151      43.430  31.578  94.210  1.00 24.42           C  
ATOM   1245  C   LEU   151      42.676  31.644  95.548  1.00 25.69           C  
ATOM   1246  O   LEU   151      41.456  31.361  95.610  1.00 24.99           O  
ATOM   1247  CB  LEU   151      43.743  30.109  93.857  1.00 24.38           C  
ATOM   1248  CG  LEU   151      44.292  29.812  92.448  1.00 25.82           C  
ATOM   1249  CD1 LEU   151      44.552  28.317  92.202  1.00 24.27           C  
ATOM   1250  CD2 LEU   151      43.390  30.322  91.365  1.00 27.53           C  
ATOM   1251  N   MET   152      43.384  32.015  96.608  1.00 27.18           N  
ATOM   1252  CA  MET   152      42.722  32.248  97.911  1.00 30.40           C  
ATOM   1253  C   MET   152      41.563  33.251  97.805  1.00 28.35           C  
ATOM   1254  O   MET   152      40.534  33.061  98.441  1.00 29.16           O  
ATOM   1255  CB  MET   152      43.714  32.773  98.945  1.00 29.91           C  
ATOM   1256  CG  MET   152      44.982  32.002  99.019  1.00 34.04           C  
ATOM   1257  SD  MET   152      45.240  31.124 100.702  0.40 39.80          SE  
ATOM   1258  CE  MET   152      43.660  29.981 100.571  1.00 36.69           C  
ATOM   1259  N   ASP   153      41.752  34.330  97.047  1.00 25.94           N  
ATOM   1260  CA  ASP   153      40.748  35.373  96.919  1.00 25.38           C  
ATOM   1261  C   ASP   153      40.095  35.363  95.539  1.00 24.78           C  
ATOM   1262  O   ASP   153      39.049  35.977  95.354  1.00 23.83           O  
ATOM   1263  CB  ASP   153      41.374  36.743  97.181  1.00 26.73           C  
ATOM   1264  CG  ASP   153      41.761  36.911  98.636  1.00 28.73           C  
ATOM   1265  OD1 ASP   153      40.846  36.873  99.479  1.00 32.78           O  
ATOM   1266  OD2 ASP   153      42.962  37.078  98.930  1.00 35.47           O  
ATOM   1267  N   GLU   154      40.729  34.673  94.587  1.00 23.72           N  
ATOM   1268  CA  GLU   154      40.212  34.586  93.214  1.00 23.81           C  
ATOM   1269  C   GLU   154      40.196  33.127  92.800  1.00 23.78           C  
ATOM   1270  O   GLU   154      41.078  32.679  92.090  1.00 24.78           O  
ATOM   1271  CB  GLU   154      41.075  35.402  92.234  1.00 24.00           C  
ATOM   1272  CG  GLU   154      41.017  36.942  92.468  1.00 24.87           C  
ATOM   1273  CD  GLU   154      39.622  37.565  92.203  1.00 26.70           C  
ATOM   1274  OE1 GLU   154      38.696  36.897  91.659  1.00 27.11           O  
ATOM   1275  OE2 GLU   154      39.454  38.759  92.527  1.00 28.82           O  
ATOM   1276  N   PRO   155      39.174  32.378  93.231  1.00 23.99           N  
ATOM   1277  CA  PRO   155      39.097  30.956  92.849  1.00 23.75           C  
ATOM   1278  C   PRO   155      39.028  30.812  91.328  1.00 23.44           C  
ATOM   1279  O   PRO   155      38.481  31.694  90.625  1.00 23.07           O  
ATOM   1280  CB  PRO   155      37.803  30.470  93.511  1.00 24.07           C  
ATOM   1281  CG  PRO   155      37.448  31.506  94.521  1.00 26.30           C  
ATOM   1282  CD  PRO   155      38.059  32.798  94.094  1.00 24.56           C  
ATOM   1283  N   VAL   156      39.615  29.740  90.817  1.00 21.71           N  
ATOM   1284  CA  VAL   156      39.513  29.441  89.369  1.00 23.19           C  
ATOM   1285  C   VAL   156      39.026  28.008  89.195  1.00 23.59           C  
ATOM   1286  O   VAL   156      39.521  27.102  89.864  1.00 23.15           O  
ATOM   1287  CB  VAL   156      40.891  29.621  88.672  1.00 22.90           C  
ATOM   1288  CG1 VAL   156      40.910  29.090  87.225  1.00 23.40           C  
ATOM   1289  CG2 VAL   156      41.298  31.112  88.662  1.00 22.77           C  
ATOM   1290  N   SER   157      38.051  27.804  88.307  1.00 24.28           N  
ATOM   1291  CA  SER   157      37.609  26.454  87.979  1.00 24.79           C  
ATOM   1292  C   SER   157      38.050  26.188  86.543  1.00 26.87           C  
ATOM   1293  O   SER   157      37.402  26.617  85.601  1.00 28.41           O  
ATOM   1294  CB  SER   157      36.087  26.321  88.133  1.00 24.36           C  
ATOM   1295  OG  SER   157      35.705  24.959  87.976  1.00 26.36           O  
ATOM   1296  N   ALA   158      39.170  25.495  86.443  1.00 28.06           N  
ATOM   1297  CA  ALA   158      39.968  25.298  85.239  1.00 29.72           C  
ATOM   1298  C   ALA   158      39.486  24.078  84.424  1.00 27.18           C  
ATOM   1299  O   ALA   158      39.467  23.000  84.980  1.00 28.44           O  
ATOM   1300  CB  ALA   158      41.404  25.023  85.736  1.00 30.50           C  
ATOM   1301  N   PRO   159      39.160  24.227  83.109  1.00 26.69           N  
ATOM   1302  CA  PRO   159      38.952  22.994  82.309  1.00 25.77           C  
ATOM   1303  C   PRO   159      40.219  22.126  82.200  1.00 25.72           C  
ATOM   1304  O   PRO   159      40.085  20.904  82.101  1.00 25.92           O  
ATOM   1305  CB  PRO   159      38.523  23.518  80.917  1.00 26.68           C  
ATOM   1306  CG  PRO   159      38.026  24.973  81.231  1.00 25.87           C  
ATOM   1307  CD  PRO   159      38.925  25.431  82.297  1.00 26.71           C  
ATOM   1308  N   VAL   160      41.406  22.760  82.177  1.00 25.07           N  
ATOM   1309  CA  VAL   160      42.715  22.083  82.031  0.50 24.81           C  
ATOM   1311  C   VAL   160      43.762  22.827  82.863  1.00 24.91           C  
ATOM   1312  O   VAL   160      43.764  24.069  82.888  1.00 24.66           O  
ATOM   1313  CB  VAL   160      43.206  22.066  80.553  0.50 25.24           C  
ATOM   1315  CG1 VAL   160      44.637  21.498  80.424  0.50 25.55           C  
ATOM   1317  CG2 VAL   160      42.258  21.266  79.680  0.50 23.82           C  
ATOM   1319  N   ILE   161      44.640  22.082  83.516  1.00 24.06           N  
ATOM   1320  CA  ILE   161      45.813  22.637  84.148  1.00 24.65           C  
ATOM   1321  C   ILE   161      47.008  22.055  83.368  1.00 24.59           C  
ATOM   1322  O   ILE   161      47.158  20.804  83.276  1.00 24.67           O  
ATOM   1323  CB  ILE   161      45.861  22.256  85.634  1.00 23.84           C  
ATOM   1324  CG1 ILE   161      44.647  22.865  86.383  1.00 23.65           C  
ATOM   1325  CG2 ILE   161      47.176  22.723  86.286  1.00 25.49           C  
ATOM   1326  CD1 ILE   161      44.449  22.316  87.832  1.00 24.81           C  
ATOM   1327  N   GLU   162      47.832  22.935  82.802  1.00 24.49           N  
ATOM   1328  CA  GLU   162      49.029  22.510  82.004  1.00 25.42           C  
ATOM   1329  C   GLU   162      50.263  22.550  82.886  1.00 25.47           C  
ATOM   1330  O   GLU   162      50.441  23.498  83.683  1.00 25.56           O  
ATOM   1331  CB  GLU   162      49.275  23.449  80.828  1.00 27.13           C  
ATOM   1332  CG  GLU   162      48.122  23.525  79.862  1.00 30.24           C  
ATOM   1333  CD  GLU   162      48.402  24.475  78.703  1.00 36.15           C  
ATOM   1334  OE1 GLU   162      48.943  25.589  78.935  1.00 38.12           O  
ATOM   1335  OE2 GLU   162      48.061  24.115  77.557  1.00 37.86           O  
ATOM   1336  N   VAL   163      51.086  21.519  82.791  1.00 24.32           N  
ATOM   1337  CA  VAL   163      52.240  21.381  83.679  1.00 24.67           C  
ATOM   1338  C   VAL   163      53.469  21.103  82.843  1.00 24.79           C  
ATOM   1339  O   VAL   163      53.529  20.071  82.175  1.00 23.66           O  
ATOM   1340  CB  VAL   163      52.047  20.224  84.669  1.00 24.67           C  
ATOM   1341  CG1 VAL   163      53.234  20.174  85.658  1.00 26.01           C  
ATOM   1342  CG2 VAL   163      50.701  20.365  85.407  1.00 25.37           C  
ATOM   1343  N   TYR   164      54.439  22.022  82.870  1.00 24.12           N  
ATOM   1344  CA  TYR   164      55.685  21.828  82.141  0.50 24.46           C  
ATOM   1346  C   TYR   164      56.800  21.548  83.121  1.00 25.01           C  
ATOM   1347  O   TYR   164      56.932  22.246  84.143  1.00 23.76           O  
ATOM   1348  CB  TYR   164      56.062  23.058  81.320  0.50 24.93           C  
ATOM   1350  CG  TYR   164      55.543  23.084  79.897  0.50 24.76           C  
ATOM   1352  CD1 TYR   164      56.242  22.459  78.865  0.50 25.67           C  
ATOM   1354  CD2 TYR   164      54.371  23.771  79.576  0.50 24.32           C  
ATOM   1356  CE1 TYR   164      55.777  22.495  77.549  0.50 25.23           C  
ATOM   1358  CE2 TYR   164      53.901  23.820  78.258  0.50 25.78           C  
ATOM   1360  CZ  TYR   164      54.618  23.179  77.255  0.50 24.58           C  
ATOM   1362  OH  TYR   164      54.183  23.205  75.955  0.50 26.05           O  
ATOM   1364  N   THR   165      57.598  20.524  82.810  1.00 24.60           N  
ATOM   1365  CA  THR   165      58.721  20.133  83.646  1.00 25.74           C  
ATOM   1366  C   THR   165      59.859  19.571  82.789  1.00 26.38           C  
ATOM   1367  O   THR   165      59.689  19.321  81.584  1.00 25.98           O  
ATOM   1368  CB  THR   165      58.308  19.026  84.664  1.00 26.13           C  
ATOM   1369  OG1 THR   165      58.062  17.796  83.970  1.00 28.08           O  
ATOM   1370  CG2 THR   165      57.063  19.407  85.423  1.00 27.71           C  
ATOM   1371  N   GLU   166      61.014  19.373  83.410  1.00 27.49           N  
ATOM   1372  CA  GLU   166      62.037  18.465  82.849  1.00 28.90           C  
ATOM   1373  C   GLU   166      61.443  17.041  82.813  1.00 28.62           C  
ATOM   1374  O   GLU   166      60.575  16.697  83.625  1.00 27.66           O  
ATOM   1375  CB  GLU   166      63.329  18.485  83.685  1.00 28.88           C  
ATOM   1376  CG  GLU   166      64.035  19.857  83.816  1.00 32.30           C  
ATOM   1377  CD  GLU   166      65.393  19.789  84.587  1.00 33.25           C  
ATOM   1378  OE1 GLU   166      66.261  18.938  84.260  1.00 38.60           O  
ATOM   1379  OE2 GLU   166      65.601  20.604  85.531  1.00 39.33           O  
ATOM   1380  N   HIS   167      61.925  16.187  81.909  1.00 28.85           N  
ATOM   1381  CA  HIS   167      61.309  14.868  81.797  1.00 30.00           C  
ATOM   1382  C   HIS   167      61.433  14.005  83.070  1.00 30.53           C  
ATOM   1383  O   HIS   167      60.535  13.219  83.379  1.00 31.01           O  
ATOM   1384  CB  HIS   167      61.812  14.113  80.568  1.00 30.10           C  
ATOM   1385  CG  HIS   167      61.131  12.793  80.364  1.00 31.45           C  
ATOM   1386  ND1 HIS   167      61.798  11.589  80.450  1.00 33.08           N  
ATOM   1387  CD2 HIS   167      59.834  12.489  80.126  1.00 30.79           C  
ATOM   1388  CE1 HIS   167      60.946  10.601  80.241  1.00 31.32           C  
ATOM   1389  NE2 HIS   167      59.748  11.120  80.042  1.00 34.30           N  
ATOM   1390  N   ASP   168      62.534  14.172  83.800  1.00 31.14           N  
ATOM   1391  CA  ASP   168      62.873  13.310  84.936  1.00 31.77           C  
ATOM   1392  C   ASP   168      61.814  13.207  86.061  1.00 30.99           C  
ATOM   1393  O   ASP   168      61.735  12.179  86.749  1.00 30.88           O  
ATOM   1394  CB  ASP   168      64.282  13.655  85.495  1.00 32.83           C  
ATOM   1395  CG  ASP   168      64.377  15.078  86.118  1.00 35.49           C  
ATOM   1396  OD1 ASP   168      63.511  15.957  85.887  1.00 39.03           O  
ATOM   1397  OD2 ASP   168      65.363  15.318  86.853  1.00 39.88           O  
ATOM   1398  N   ILE   169      60.998  14.248  86.229  1.00 30.06           N  
ATOM   1399  CA  ILE   169      59.994  14.280  87.299  1.00 29.13           C  
ATOM   1400  C   ILE   169      58.536  14.064  86.853  1.00 28.85           C  
ATOM   1401  O   ILE   169      57.628  14.071  87.691  1.00 28.39           O  
ATOM   1402  CB  ILE   169      60.120  15.563  88.179  1.00 29.06           C  
ATOM   1403  CG1 ILE   169      59.759  16.836  87.389  1.00 28.51           C  
ATOM   1404  CG2 ILE   169      61.539  15.629  88.828  1.00 29.06           C  
ATOM   1405  CD1 ILE   169      59.625  18.126  88.261  1.00 28.45           C  
ATOM   1406  N   GLN   170      58.302  13.860  85.554  1.00 28.77           N  
ATOM   1407  CA  GLN   170      56.925  13.670  85.046  1.00 28.63           C  
ATOM   1408  C   GLN   170      56.213  12.484  85.669  1.00 28.72           C  
ATOM   1409  O   GLN   170      55.042  12.559  85.992  1.00 28.16           O  
ATOM   1410  CB  GLN   170      56.906  13.423  83.545  1.00 29.18           C  
ATOM   1411  CG  GLN   170      56.876  14.606  82.707  1.00 28.65           C  
ATOM   1412  CD  GLN   170      56.437  14.259  81.310  1.00 30.21           C  
ATOM   1413  OE1 GLN   170      56.672  13.146  80.822  1.00 26.53           O  
ATOM   1414  NE2 GLN   170      55.799  15.208  80.653  1.00 28.23           N  
ATOM   1415  N   HIS   171      56.919  11.363  85.792  1.00 28.90           N  
ATOM   1416  CA  HIS   171      56.319  10.168  86.369  1.00 29.62           C  
ATOM   1417  C   HIS   171      55.887  10.394  87.832  1.00 29.02           C  
ATOM   1418  O   HIS   171      54.780  10.000  88.228  1.00 29.32           O  
ATOM   1419  CB  HIS   171      57.274   8.979  86.254  1.00 30.17           C  
ATOM   1420  CG  HIS   171      56.769   7.746  86.932  1.00 33.79           C  
ATOM   1421  ND1 HIS   171      55.731   6.993  86.424  1.00 36.44           N  
ATOM   1422  CD2 HIS   171      57.140   7.147  88.089  1.00 36.05           C  
ATOM   1423  CE1 HIS   171      55.503   5.966  87.225  1.00 37.12           C  
ATOM   1424  NE2 HIS   171      56.343   6.037  88.244  1.00 37.28           N  
ATOM   1425  N   ASP   172      56.759  11.031  88.617  1.00 28.48           N  
ATOM   1426  CA  ASP   172      56.457  11.347  90.008  0.50 28.54           C  
ATOM   1428  C   ASP   172      55.253  12.289  90.115  1.00 27.90           C  
ATOM   1429  O   ASP   172      54.340  12.065  90.929  1.00 27.33           O  
ATOM   1430  CB  ASP   172      57.686  11.961  90.689  0.50 29.24           C  
ATOM   1432  CG  ASP   172      57.489  12.207  92.190  0.50 31.34           C  
ATOM   1434  OD1 ASP   172      56.462  11.791  92.776  0.50 34.03           O  
ATOM   1436  OD2 ASP   172      58.388  12.823  92.797  0.50 33.97           O  
ATOM   1438  N   ILE   173      55.242  13.352  89.309  1.00 27.21           N  
ATOM   1439  CA  ILE   173      54.114  14.292  89.356  1.00 26.80           C  
ATOM   1440  C   ILE   173      52.846  13.543  88.987  1.00 27.04           C  
ATOM   1441  O   ILE   173      51.828  13.673  89.675  1.00 26.70           O  
ATOM   1442  CB  ILE   173      54.313  15.495  88.428  1.00 26.32           C  
ATOM   1443  CG1 ILE   173      55.455  16.353  88.959  1.00 28.14           C  
ATOM   1444  CG2 ILE   173      53.003  16.312  88.304  1.00 25.19           C  
ATOM   1445  CD1 ILE   173      55.732  17.600  88.138  1.00 31.54           C  
ATOM   1446  N   THR   174      52.931  12.744  87.921  1.00 27.34           N  
ATOM   1447  CA  THR   174      51.781  11.965  87.422  1.00 27.90           C  
ATOM   1448  C   THR   174      51.231  11.020  88.508  1.00 28.01           C  
ATOM   1449  O   THR   174      50.020  10.972  88.735  1.00 28.15           O  
ATOM   1450  CB  THR   174      52.132  11.156  86.143  1.00 27.98           C  
ATOM   1451  OG1 THR   174      52.556  12.050  85.099  1.00 28.20           O  
ATOM   1452  CG2 THR   174      50.933  10.338  85.675  1.00 27.86           C  
ATOM   1453  N   GLU   175      52.130  10.276  89.156  0.50 27.94           N  
ATOM   1455  CA  GLU   175      51.761   9.383  90.258  0.50 28.08           C  
ATOM   1457  C   GLU   175      51.100  10.168  91.392  0.50 27.46           C  
ATOM   1459  O   GLU   175      50.031   9.787  91.878  0.50 27.74           O  
ATOM   1461  CB  GLU   175      52.989   8.607  90.779  0.50 27.87           C  
ATOM   1463  CG  GLU   175      52.683   7.643  91.927  0.50 29.24           C  
ATOM   1465  CD  GLU   175      53.737   6.539  92.115  0.50 29.46           C  
ATOM   1467  OE1 GLU   175      54.903   6.858  92.439  0.50 31.34           O  
ATOM   1469  OE2 GLU   175      53.390   5.345  91.963  0.50 31.65           O  
ATOM   1471  N   THR   176      51.735  11.264  91.798  1.00 26.86           N  
ATOM   1472  CA  THR   176      51.290  12.040  92.961  1.00 26.79           C  
ATOM   1473  C   THR   176      49.898  12.629  92.753  1.00 26.75           C  
ATOM   1474  O   THR   176      49.036  12.510  93.620  1.00 26.04           O  
ATOM   1475  CB  THR   176      52.302  13.134  93.336  1.00 27.14           C  
ATOM   1476  OG1 THR   176      53.559  12.502  93.631  1.00 27.24           O  
ATOM   1477  CG2 THR   176      51.835  13.934  94.563  1.00 27.58           C  
ATOM   1478  N   ILE   177      49.688  13.240  91.588  1.00 25.71           N  
ATOM   1479  CA  ILE   177      48.384  13.785  91.234  1.00 26.22           C  
ATOM   1480  C   ILE   177      47.297  12.715  91.081  1.00 26.28           C  
ATOM   1481  O   ILE   177      46.218  12.859  91.651  1.00 26.63           O  
ATOM   1482  CB  ILE   177      48.468  14.681  89.955  1.00 25.48           C  
ATOM   1483  CG1 ILE   177      49.376  15.896  90.198  1.00 26.11           C  
ATOM   1484  CG2 ILE   177      47.074  15.098  89.477  1.00 25.45           C  
ATOM   1485  CD1 ILE   177      48.966  16.846  91.337  1.00 28.06           C  
ATOM   1486  N   THR   178      47.571  11.657  90.322  1.00 26.77           N  
ATOM   1487  CA  THR   178      46.582  10.592  90.107  1.00 27.62           C  
ATOM   1488  C   THR   178      46.105  10.020  91.439  1.00 28.01           C  
ATOM   1489  O   THR   178      44.894   9.869  91.655  1.00 28.34           O  
ATOM   1490  CB  THR   178      47.147   9.474  89.227  1.00 27.45           C  
ATOM   1491  OG1 THR   178      47.575  10.049  87.986  1.00 30.23           O  
ATOM   1492  CG2 THR   178      46.079   8.407  88.914  1.00 27.81           C  
ATOM   1493  N   LYS   179      47.056   9.726  92.329  1.00 28.10           N  
ATOM   1494  CA  LYS   179      46.759   9.198  93.667  1.00 29.30           C  
ATOM   1495  C   LYS   179      45.974  10.180  94.568  1.00 28.48           C  
ATOM   1496  O   LYS   179      45.034   9.781  95.254  1.00 28.59           O  
ATOM   1497  CB  LYS   179      48.072   8.748  94.344  1.00 28.31           C  
ATOM   1498  CG  LYS   179      47.945   7.921  95.595  1.00 32.52           C  
ATOM   1499  CD  LYS   179      49.318   7.282  95.904  1.00 31.76           C  
ATOM   1500  CE  LYS   179      49.357   6.506  97.228  1.00 36.71           C  
ATOM   1501  NZ  LYS   179      49.425   7.439  98.395  1.00 38.33           N  
ATOM   1502  N   ALA   180      46.353  11.455  94.583  1.00 28.41           N  
ATOM   1503  CA  ALA   180      45.706  12.417  95.473  1.00 28.03           C  
ATOM   1504  C   ALA   180      44.362  12.985  94.987  1.00 28.23           C  
ATOM   1505  O   ALA   180      43.579  13.493  95.802  1.00 26.75           O  
ATOM   1506  CB  ALA   180      46.671  13.569  95.819  1.00 28.73           C  
ATOM   1507  N   PHE   181      44.113  12.930  93.674  1.00 26.80           N  
ATOM   1508  CA  PHE   181      42.932  13.566  93.073  1.00 27.02           C  
ATOM   1509  C   PHE   181      42.165  12.637  92.124  1.00 26.89           C  
ATOM   1510  O   PHE   181      42.346  12.698  90.901  1.00 26.67           O  
ATOM   1511  CB  PHE   181      43.319  14.889  92.392  1.00 26.12           C  
ATOM   1512  CG  PHE   181      44.028  15.842  93.320  1.00 26.60           C  
ATOM   1513  CD1 PHE   181      43.305  16.619  94.221  1.00 26.91           C  
ATOM   1514  CD2 PHE   181      45.420  15.936  93.316  1.00 25.88           C  
ATOM   1515  CE1 PHE   181      43.960  17.502  95.105  1.00 26.01           C  
ATOM   1516  CE2 PHE   181      46.088  16.797  94.207  1.00 25.21           C  
ATOM   1517  CZ  PHE   181      45.350  17.580  95.101  1.00 26.35           C  
ATOM   1518  N   PRO   182      41.304  11.768  92.694  1.00 27.28           N  
ATOM   1519  CA  PRO   182      40.486  10.821  91.907  1.00 27.25           C  
ATOM   1520  C   PRO   182      39.524  11.513  90.933  1.00 26.41           C  
ATOM   1521  O   PRO   182      39.017  10.869  90.015  1.00 26.37           O  
ATOM   1522  CB  PRO   182      39.663  10.081  92.976  1.00 27.29           C  
ATOM   1523  CG  PRO   182      40.351  10.330  94.259  1.00 28.28           C  
ATOM   1524  CD  PRO   182      41.066  11.627  94.147  1.00 27.15           C  
ATOM   1525  N   ALA   183      39.257  12.803  91.146  1.00 25.54           N  
ATOM   1526  CA  ALA   183      38.359  13.520  90.247  1.00 24.99           C  
ATOM   1527  C   ALA   183      39.032  13.960  88.926  1.00 24.58           C  
ATOM   1528  O   ALA   183      38.354  14.481  88.032  1.00 24.53           O  
ATOM   1529  CB  ALA   183      37.714  14.717  90.954  1.00 24.64           C  
ATOM   1530  N   VAL   184      40.346  13.761  88.790  1.00 23.86           N  
ATOM   1531  CA  VAL   184      41.061  14.225  87.572  1.00 24.22           C  
ATOM   1532  C   VAL   184      41.838  13.083  86.933  1.00 23.90           C  
ATOM   1533  O   VAL   184      42.099  12.075  87.597  1.00 23.81           O  
ATOM   1534  CB  VAL   184      42.043  15.429  87.828  1.00 23.77           C  
ATOM   1535  CG1 VAL   184      41.318  16.626  88.477  1.00 26.01           C  
ATOM   1536  CG2 VAL   184      43.250  14.998  88.672  1.00 25.45           C  
ATOM   1537  N   ASP   185      42.204  13.253  85.654  1.00 23.63           N  
ATOM   1538  CA  ASP   185      43.120  12.365  84.960  1.00 24.73           C  
ATOM   1539  C   ASP   185      44.332  13.188  84.558  1.00 25.11           C  
ATOM   1540  O   ASP   185      44.217  14.401  84.317  1.00 24.08           O  
ATOM   1541  CB  ASP   185      42.485  11.796  83.673  1.00 24.93           C  
ATOM   1542  CG  ASP   185      41.478  10.655  83.947  1.00 29.15           C  
ATOM   1543  OD1 ASP   185      41.589  10.008  85.017  1.00 30.21           O  
ATOM   1544  OD2 ASP   185      40.571  10.410  83.105  1.00 28.23           O  
ATOM   1545  N   VAL   186      45.473  12.516  84.429  1.00 24.79           N  
ATOM   1546  CA  VAL   186      46.681  13.160  83.920  1.00 24.16           C  
ATOM   1547  C   VAL   186      46.963  12.609  82.524  1.00 24.33           C  
ATOM   1548  O   VAL   186      47.102  11.390  82.331  1.00 23.98           O  
ATOM   1549  CB  VAL   186      47.891  12.878  84.829  1.00 25.31           C  
ATOM   1550  CG1 VAL   186      49.156  13.472  84.224  1.00 25.57           C  
ATOM   1551  CG2 VAL   186      47.626  13.405  86.267  1.00 24.03           C  
ATOM   1552  N   ILE   187      47.088  13.510  81.564  1.00 23.30           N  
ATOM   1553  CA  ILE   187      47.397  13.144  80.183  1.00 23.86           C  
ATOM   1554  C   ILE   187      48.818  13.565  79.811  1.00 23.45           C  
ATOM   1555  O   ILE   187      49.156  14.734  79.908  1.00 22.45           O  
ATOM   1556  CB  ILE   187      46.362  13.718  79.202  1.00 23.85           C  
ATOM   1557  CG1 ILE   187      44.980  13.099  79.512  1.00 26.53           C  
ATOM   1558  CG2 ILE   187      46.795  13.383  77.735  1.00 25.15           C  
ATOM   1559  CD1 ILE   187      43.812  13.706  78.758  1.00 28.72           C  
ATOM   1560  N   ARG   188      49.652  12.602  79.416  1.00 22.73           N  
ATOM   1561  CA  ARG   188      50.999  12.938  78.990  1.00 23.62           C  
ATOM   1562  C   ARG   188      50.960  13.434  77.527  1.00 23.19           C  
ATOM   1563  O   ARG   188      50.550  12.714  76.631  1.00 23.50           O  
ATOM   1564  CB  ARG   188      51.935  11.739  79.166  1.00 24.18           C  
ATOM   1565  CG  ARG   188      53.358  12.066  78.854  1.00 29.11           C  
ATOM   1566  CD  ARG   188      54.182  10.781  78.804  1.00 36.71           C  
ATOM   1567  NE  ARG   188      55.594  11.107  78.671  1.00 41.91           N  
ATOM   1568  CZ  ARG   188      56.399  10.631  77.732  1.00 46.11           C  
ATOM   1569  NH1 ARG   188      55.964   9.748  76.826  1.00 48.26           N  
ATOM   1570  NH2 ARG   188      57.670  11.012  77.731  1.00 47.42           N  
ATOM   1571  N   VAL   189      51.380  14.676  77.296  1.00 22.79           N  
ATOM   1572  CA  VAL   189      51.366  15.243  75.939  1.00 22.54           C  
ATOM   1573  C   VAL   189      52.673  14.936  75.255  1.00 22.95           C  
ATOM   1574  O   VAL   189      52.687  14.427  74.133  1.00 23.11           O  
ATOM   1575  CB  VAL   189      51.084  16.775  75.951  1.00 21.83           C  
ATOM   1576  CG1 VAL   189      51.130  17.328  74.544  1.00 24.12           C  
ATOM   1577  CG2 VAL   189      49.723  17.084  76.638  1.00 22.40           C  
ATOM   1578  N   ASN   190      53.782  15.206  75.947  1.00 23.34           N  
ATOM   1579  CA  ASN   190      55.124  14.939  75.427  1.00 23.37           C  
ATOM   1580  C   ASN   190      56.065  14.813  76.613  1.00 24.01           C  
ATOM   1581  O   ASN   190      55.602  14.805  77.748  1.00 24.05           O  
ATOM   1582  CB  ASN   190      55.562  16.020  74.427  1.00 23.41           C  
ATOM   1583  CG  ASN   190      55.572  17.438  75.040  1.00 23.59           C  
ATOM   1584  OD1 ASN   190      56.091  17.629  76.121  1.00 23.01           O  
ATOM   1585  ND2 ASN   190      55.007  18.420  74.335  1.00 23.21           N  
ATOM   1586  N   ASP   191      57.373  14.735  76.367  1.00 24.18           N  
ATOM   1587  CA  ASP   191      58.333  14.466  77.451  1.00 25.89           C  
ATOM   1588  C   ASP   191      58.420  15.569  78.507  1.00 25.25           C  
ATOM   1589  O   ASP   191      58.990  15.354  79.577  1.00 24.90           O  
ATOM   1590  CB  ASP   191      59.735  14.205  76.873  1.00 26.80           C  
ATOM   1591  CG  ASP   191      59.851  12.841  76.208  1.00 30.70           C  
ATOM   1592  OD1 ASP   191      58.883  12.044  76.297  1.00 35.89           O  
ATOM   1593  OD2 ASP   191      60.898  12.564  75.580  1.00 33.80           O  
ATOM   1594  N   GLU   192      57.895  16.749  78.185  1.00 24.14           N  
ATOM   1595  CA  GLU   192      57.988  17.905  79.073  1.00 25.47           C  
ATOM   1596  C   GLU   192      56.658  18.541  79.432  1.00 24.52           C  
ATOM   1597  O   GLU   192      56.637  19.507  80.170  1.00 25.59           O  
ATOM   1598  CB  GLU   192      58.917  18.950  78.460  1.00 26.31           C  
ATOM   1599  CG  GLU   192      60.369  18.442  78.432  1.00 30.67           C  
ATOM   1600  CD  GLU   192      61.278  19.187  77.468  1.00 37.45           C  
ATOM   1601  OE1 GLU   192      60.932  20.300  77.012  1.00 39.13           O  
ATOM   1602  OE2 GLU   192      62.358  18.640  77.164  1.00 40.53           O  
ATOM   1603  N   LYS   193      55.557  18.003  78.926  1.00 22.75           N  
ATOM   1604  CA  LYS   193      54.232  18.578  79.189  1.00 22.40           C  
ATOM   1605  C   LYS   193      53.193  17.535  79.579  1.00 22.60           C  
ATOM   1606  O   LYS   193      53.074  16.511  78.890  1.00 22.61           O  
ATOM   1607  CB  LYS   193      53.727  19.351  77.963  1.00 21.34           C  
ATOM   1608  CG  LYS   193      52.448  20.175  78.282  1.00 23.45           C  
ATOM   1609  CD  LYS   193      51.908  20.848  77.041  1.00 27.98           C  
ATOM   1610  CE  LYS   193      50.708  21.741  77.436  1.00 32.37           C  
ATOM   1611  NZ  LYS   193      50.217  22.474  76.221  1.00 37.14           N  
ATOM   1612  N   LEU   194      52.478  17.808  80.677  1.00 23.12           N  
ATOM   1613  CA  LEU   194      51.277  17.062  81.118  1.00 23.93           C  
ATOM   1614  C   LEU   194      50.053  17.994  81.145  1.00 23.51           C  
ATOM   1615  O   LEU   194      50.155  19.187  81.476  1.00 25.01           O  
ATOM   1616  CB  LEU   194      51.435  16.505  82.562  1.00 24.36           C  
ATOM   1617  CG  LEU   194      52.599  15.609  82.915  1.00 26.27           C  
ATOM   1618  CD1 LEU   194      52.728  15.487  84.438  1.00 26.26           C  
ATOM   1619  CD2 LEU   194      52.383  14.244  82.252  1.00 29.88           C  
ATOM   1620  N   ASN   195      48.897  17.436  80.825  1.00 22.85           N  
ATOM   1621  CA  ASN   195      47.627  18.098  81.067  1.00 23.97           C  
ATOM   1622  C   ASN   195      46.917  17.373  82.192  1.00 23.50           C  
ATOM   1623  O   ASN   195      46.808  16.141  82.175  1.00 25.44           O  
ATOM   1624  CB  ASN   195      46.741  18.018  79.828  1.00 24.15           C  
ATOM   1625  CG  ASN   195      47.229  18.904  78.700  1.00 26.20           C  
ATOM   1626  OD1 ASN   195      47.997  19.823  78.923  1.00 27.66           O  
ATOM   1627  ND2 ASN   195      46.767  18.629  77.484  1.00 28.00           N  
ATOM   1628  N   ILE   196      46.410  18.127  83.152  1.00 22.67           N  
ATOM   1629  CA  ILE   196      45.526  17.574  84.157  1.00 22.84           C  
ATOM   1630  C   ILE   196      44.096  18.024  83.788  1.00 23.07           C  
ATOM   1631  O   ILE   196      43.841  19.242  83.650  1.00 23.10           O  
ATOM   1632  CB  ILE   196      45.883  18.079  85.550  1.00 22.56           C  
ATOM   1633  CG1 ILE   196      47.321  17.667  85.909  1.00 24.46           C  
ATOM   1634  CG2 ILE   196      44.854  17.574  86.572  1.00 24.19           C  
ATOM   1635  CD1 ILE   196      47.926  18.445  87.081  1.00 25.55           C  
ATOM   1636  N   VAL   197      43.189  17.055  83.641  1.00 22.22           N  
ATOM   1637  CA  VAL   197      41.827  17.312  83.118  1.00 21.63           C  
ATOM   1638  C   VAL   197      40.788  16.621  84.018  1.00 22.47           C  
ATOM   1639  O   VAL   197      41.141  15.737  84.810  1.00 22.16           O  
ATOM   1640  CB  VAL   197      41.641  16.791  81.641  1.00 20.72           C  
ATOM   1641  CG1 VAL   197      42.502  17.560  80.644  1.00 24.23           C  
ATOM   1642  CG2 VAL   197      41.948  15.267  81.541  1.00 19.32           C  
ATOM   1643  N   PRO   198      39.500  17.022  83.908  1.00 22.65           N  
ATOM   1644  CA  PRO   198      38.511  16.247  84.681  1.00 22.51           C  
ATOM   1645  C   PRO   198      38.528  14.774  84.265  1.00 22.53           C  
ATOM   1646  O   PRO   198      38.845  14.434  83.115  1.00 23.02           O  
ATOM   1647  CB  PRO   198      37.169  16.883  84.300  1.00 21.85           C  
ATOM   1648  CG  PRO   198      37.530  18.317  83.841  1.00 23.58           C  
ATOM   1649  CD  PRO   198      38.897  18.153  83.151  1.00 21.60           C  
ATOM   1650  N   LYS   199      38.157  13.897  85.186  1.00 22.88           N  
ATOM   1651  CA  LYS   199      38.168  12.474  84.881  1.00 22.86           C  
ATOM   1652  C   LYS   199      37.294  12.167  83.678  1.00 23.13           C  
ATOM   1653  O   LYS   199      36.173  12.663  83.556  1.00 23.11           O  
ATOM   1654  CB  LYS   199      37.757  11.642  86.114  1.00 23.14           C  
ATOM   1655  CG  LYS   199      37.963  10.141  85.884  1.00 26.25           C  
ATOM   1656  CD  LYS   199      38.082   9.393  87.188  1.00 31.96           C  
ATOM   1657  CE  LYS   199      38.436   7.907  86.975  1.00 36.76           C  
ATOM   1658  NZ  LYS   199      39.836   7.763  86.397  1.00 39.94           N  
ATOM   1659  N   GLY   200      37.830  11.360  82.770  1.00 23.34           N  
ATOM   1660  CA  GLY   200      37.103  10.945  81.573  1.00 24.15           C  
ATOM   1661  C   GLY   200      37.262  11.895  80.392  1.00 23.87           C  
ATOM   1662  O   GLY   200      36.852  11.566  79.278  1.00 24.98           O  
ATOM   1663  N   VAL   201      37.880  13.061  80.607  1.00 23.17           N  
ATOM   1664  CA  VAL   201      38.086  14.017  79.515  1.00 23.28           C  
ATOM   1665  C   VAL   201      39.338  13.660  78.712  1.00 23.78           C  
ATOM   1666  O   VAL   201      40.379  13.293  79.280  1.00 23.42           O  
ATOM   1667  CB  VAL   201      38.199  15.469  80.058  1.00 22.66           C  
ATOM   1668  CG1 VAL   201      38.784  16.473  79.002  1.00 23.26           C  
ATOM   1669  CG2 VAL   201      36.823  15.925  80.614  1.00 22.85           C  
ATOM   1670  N   SER   202      39.229  13.755  77.396  1.00 23.76           N  
ATOM   1671  CA  SER   202      40.381  13.594  76.515  1.00 23.73           C  
ATOM   1672  C   SER   202      40.013  14.008  75.100  1.00 23.53           C  
ATOM   1673  O   SER   202      38.820  14.117  74.756  1.00 23.55           O  
ATOM   1674  CB  SER   202      40.877  12.133  76.511  1.00 23.24           C  
ATOM   1675  OG  SER   202      39.953  11.270  75.866  1.00 25.09           O  
ATOM   1676  N   LYS   203      41.041  14.174  74.266  1.00 23.78           N  
ATOM   1677  CA  LYS   203      40.816  14.429  72.835  1.00 24.42           C  
ATOM   1678  C   LYS   203      39.967  13.338  72.193  1.00 24.78           C  
ATOM   1679  O   LYS   203      39.042  13.648  71.456  1.00 25.33           O  
ATOM   1680  CB  LYS   203      42.133  14.566  72.085  1.00 24.43           C  
ATOM   1681  CG  LYS   203      42.904  15.830  72.372  1.00 24.22           C  
ATOM   1682  CD  LYS   203      44.319  15.747  71.699  1.00 24.40           C  
ATOM   1683  CE  LYS   203      44.861  17.178  71.476  1.00 25.18           C  
ATOM   1684  NZ  LYS   203      46.372  17.189  71.101  1.00 27.07           N  
ATOM   1685  N   GLU   204      40.273  12.070  72.476  1.00 24.74           N  
ATOM   1686  CA  GLU   204      39.565  10.962  71.860  1.00 25.22           C  
ATOM   1687  C   GLU   204      38.110  10.856  72.355  1.00 25.34           C  
ATOM   1688  O   GLU   204      37.205  10.479  71.600  1.00 25.63           O  
ATOM   1689  CB  GLU   204      40.316   9.638  72.067  1.00 25.18           C  
ATOM   1690  CG  GLU   204      40.476   9.140  73.525  1.00 26.39           C  
ATOM   1691  CD  GLU   204      41.728   9.648  74.230  1.00 28.45           C  
ATOM   1692  OE1 GLU   204      42.320  10.686  73.810  1.00 27.42           O  
ATOM   1693  OE2 GLU   204      42.103   8.993  75.240  1.00 27.94           O  
ATOM   1694  N   ALA   205      37.896  11.155  73.633  1.00 25.21           N  
ATOM   1695  CA  ALA   205      36.551  11.140  74.178  1.00 25.48           C  
ATOM   1696  C   ALA   205      35.704  12.277  73.560  1.00 25.74           C  
ATOM   1697  O   ALA   205      34.506  12.085  73.256  1.00 24.87           O  
ATOM   1698  CB  ALA   205      36.602  11.262  75.696  1.00 26.78           C  
ATOM   1699  N   GLY   206      36.331  13.442  73.376  1.00 26.29           N  
ATOM   1700  CA  GLY   206      35.640  14.624  72.822  1.00 26.95           C  
ATOM   1701  C   GLY   206      35.268  14.331  71.360  1.00 27.05           C  
ATOM   1702  O   GLY   206      34.129  14.554  70.931  1.00 26.85           O  
ATOM   1703  N   LEU   207      36.233  13.798  70.615  1.00 27.18           N  
ATOM   1704  CA  LEU   207      36.010  13.370  69.240  1.00 28.57           C  
ATOM   1705  C   LEU   207      34.881  12.342  69.137  1.00 28.45           C  
ATOM   1706  O   LEU   207      34.008  12.481  68.286  1.00 29.73           O  
ATOM   1707  CB  LEU   207      37.306  12.843  68.603  1.00 28.40           C  
ATOM   1708  CG  LEU   207      37.299  12.573  67.080  1.00 30.73           C  
ATOM   1709  CD1 LEU   207      36.715  13.757  66.324  1.00 31.91           C  
ATOM   1710  CD2 LEU   207      38.732  12.337  66.627  1.00 29.73           C  
ATOM   1711  N   ALA   208      34.869  11.336  70.019  1.00 28.38           N  
ATOM   1712  CA  ALA   208      33.753  10.374  70.037  1.00 28.76           C  
ATOM   1713  C   ALA   208      32.393  11.036  70.262  1.00 28.80           C  
ATOM   1714  O   ALA   208      31.392  10.637  69.640  1.00 29.85           O  
ATOM   1715  CB  ALA   208      33.989   9.278  71.060  1.00 28.97           C  
ATOM   1716  N   LEU   209      32.341  12.038  71.147  1.00 28.07           N  
ATOM   1717  CA  LEU   209      31.084  12.727  71.442  0.50 27.57           C  
ATOM   1719  C   LEU   209      30.596  13.496  70.215  1.00 27.61           C  
ATOM   1720  O   LEU   209      29.392  13.520  69.912  1.00 26.72           O  
ATOM   1721  CB  LEU   209      31.220  13.676  72.640  0.50 27.41           C  
ATOM   1723  CG  LEU   209      31.416  13.169  74.076  0.50 27.68           C  
ATOM   1725  CD1 LEU   209      31.349  14.332  75.046  0.50 28.55           C  
ATOM   1727  CD2 LEU   209      30.382  12.113  74.470  0.50 28.32           C  
ATOM   1729  N   VAL   210      31.526  14.126  69.503  1.00 27.12           N  
ATOM   1730  CA  VAL   210      31.157  14.895  68.322  1.00 28.29           C  
ATOM   1731  C   VAL   210      30.689  13.954  67.202  1.00 28.23           C  
ATOM   1732  O   VAL   210      29.676  14.225  66.551  1.00 28.96           O  
ATOM   1733  CB  VAL   210      32.301  15.829  67.883  1.00 28.91           C  
ATOM   1734  CG1 VAL   210      32.044  16.463  66.500  1.00 30.73           C  
ATOM   1735  CG2 VAL   210      32.503  16.935  68.926  1.00 28.46           C  
ATOM   1736  N   ALA   211      31.405  12.855  67.008  1.00 27.53           N  
ATOM   1737  CA  ALA   211      31.037  11.889  65.955  1.00 29.77           C  
ATOM   1738  C   ALA   211      29.634  11.330  66.251  1.00 30.23           C  
ATOM   1739  O   ALA   211      28.777  11.275  65.357  1.00 31.50           O  
ATOM   1740  CB  ALA   211      32.052  10.785  65.874  1.00 28.32           C  
ATOM   1741  N   SER   212      29.389  10.948  67.507  1.00 31.44           N  
ATOM   1742  CA  SER   212      28.087  10.426  67.907  0.50 31.31           C  
ATOM   1744  C   SER   212      26.966  11.446  67.658  1.00 31.67           C  
ATOM   1745  O   SER   212      25.882  11.085  67.178  1.00 30.94           O  
ATOM   1746  CB  SER   212      28.103   9.983  69.378  0.50 31.80           C  
ATOM   1748  OG  SER   212      28.942   8.849  69.550  0.50 31.57           O  
ATOM   1750  N   GLU   213      27.228  12.714  67.983  1.00 31.98           N  
ATOM   1751  CA  GLU   213      26.271  13.804  67.745  1.00 32.98           C  
ATOM   1752  C   GLU   213      25.899  13.918  66.260  1.00 32.21           C  
ATOM   1753  O   GLU   213      24.760  14.240  65.919  1.00 31.44           O  
ATOM   1754  CB  GLU   213      26.815  15.143  68.288  1.00 33.71           C  
ATOM   1755  CG  GLU   213      25.921  16.357  68.005  1.00 36.91           C  
ATOM   1756  CD  GLU   213      24.602  16.358  68.767  1.00 41.90           C  
ATOM   1757  OE1 GLU   213      24.389  15.516  69.668  1.00 42.24           O  
ATOM   1758  OE2 GLU   213      23.759  17.233  68.466  1.00 44.94           O  
ATOM   1759  N   LEU   214      26.860  13.628  65.400  1.00 31.56           N  
ATOM   1760  CA  LEU   214      26.669  13.655  63.955  1.00 31.83           C  
ATOM   1761  C   LEU   214      26.129  12.349  63.367  1.00 31.36           C  
ATOM   1762  O   LEU   214      25.994  12.242  62.154  1.00 32.00           O  
ATOM   1763  CB  LEU   214      27.986  14.012  63.262  1.00 31.66           C  
ATOM   1764  CG  LEU   214      28.554  15.405  63.558  1.00 32.94           C  
ATOM   1765  CD1 LEU   214      29.941  15.500  62.964  1.00 32.27           C  
ATOM   1766  CD2 LEU   214      27.652  16.491  63.025  1.00 34.12           C  
ATOM   1767  N   GLY   215      25.837  11.363  64.211  1.00 30.66           N  
ATOM   1768  CA  GLY   215      25.340  10.066  63.730  1.00 31.52           C  
ATOM   1769  C   GLY   215      26.423   9.187  63.115  1.00 31.35           C  
ATOM   1770  O   GLY   215      26.134   8.258  62.348  1.00 30.33           O  
ATOM   1771  N   LEU   216      27.679   9.481  63.445  1.00 31.95           N  
ATOM   1772  CA  LEU   216      28.823   8.740  62.909  1.00 33.17           C  
ATOM   1773  C   LEU   216      29.469   7.892  63.993  1.00 34.61           C  
ATOM   1774  O   LEU   216      29.202   8.097  65.174  1.00 35.18           O  
ATOM   1775  CB  LEU   216      29.856   9.699  62.314  1.00 33.09           C  
ATOM   1776  CG  LEU   216      29.341  10.716  61.286  1.00 34.24           C  
ATOM   1777  CD1 LEU   216      30.383  11.781  61.015  1.00 35.51           C  
ATOM   1778  CD2 LEU   216      28.954  10.016  60.009  1.00 34.74           C  
ATOM   1779  N   SER   217      30.255   6.891  63.595  1.00 36.05           N  
ATOM   1780  CA  SER   217      31.118   6.198  64.550  1.00 37.27           C  
ATOM   1781  C   SER   217      32.572   6.603  64.317  1.00 37.16           C  
ATOM   1782  O   SER   217      32.890   7.227  63.295  1.00 37.08           O  
ATOM   1783  CB  SER   217      30.977   4.680  64.452  1.00 37.36           C  
ATOM   1784  OG  SER   217      31.434   4.162  63.207  1.00 39.38           O  
ATOM   1785  N   MET   218      33.450   6.241  65.252  1.00 36.89           N  
ATOM   1786  CA  MET   218      34.900   6.434  65.054  1.00 36.52           C  
ATOM   1787  C   MET   218      35.416   5.826  63.729  1.00 35.52           C  
ATOM   1788  O   MET   218      36.384   6.340  63.146  1.00 35.11           O  
ATOM   1789  CB  MET   218      35.699   5.948  66.279  1.00 36.94           C  
ATOM   1790  CG  MET   218      35.501   6.844  67.527  1.00 39.01           C  
ATOM   1791  SD  MET   218      35.943   8.725  67.266  0.50 41.58          SE  
ATOM   1792  CE  MET   218      37.884   8.654  67.325  1.00 41.87           C  
ATOM   1793  N   ASP   219      34.756   4.762  63.257  0.50 34.83           N  
ATOM   1795  CA  ASP   219      35.063   4.146  61.957  0.50 34.53           C  
ATOM   1797  C   ASP   219      35.023   5.116  60.772  0.50 34.07           C  
ATOM   1799  O   ASP   219      35.703   4.899  59.758  0.50 33.98           O  
ATOM   1801  CB  ASP   219      34.117   2.970  61.664  0.50 34.79           C  
ATOM   1803  CG  ASP   219      34.244   1.834  62.673  0.50 35.41           C  
ATOM   1805  OD1 ASP   219      35.291   1.713  63.352  0.50 35.59           O  
ATOM   1807  OD2 ASP   219      33.285   1.045  62.775  0.50 38.09           O  
ATOM   1809  N   ASP   220      34.222   6.167  60.910  1.00 33.45           N  
ATOM   1810  CA  ASP   220      33.965   7.135  59.846  1.00 33.21           C  
ATOM   1811  C   ASP   220      34.915   8.335  59.921  1.00 31.68           C  
ATOM   1812  O   ASP   220      34.766   9.296  59.152  1.00 31.82           O  
ATOM   1813  CB  ASP   220      32.513   7.654  59.956  1.00 33.38           C  
ATOM   1814  CG  ASP   220      31.467   6.539  59.830  1.00 36.94           C  
ATOM   1815  OD1 ASP   220      31.547   5.724  58.870  1.00 35.69           O  
ATOM   1816  OD2 ASP   220      30.552   6.495  60.694  1.00 39.56           O  
ATOM   1817  N   VAL   221      35.863   8.279  60.857  1.00 29.72           N  
ATOM   1818  CA  VAL   221      36.720   9.418  61.186  1.00 29.05           C  
ATOM   1819  C   VAL   221      38.148   9.248  60.657  1.00 28.17           C  
ATOM   1820  O   VAL   221      38.740   8.159  60.765  1.00 28.41           O  
ATOM   1821  CB  VAL   221      36.790   9.635  62.712  1.00 28.79           C  
ATOM   1822  CG1 VAL   221      37.689  10.800  63.041  1.00 30.06           C  
ATOM   1823  CG2 VAL   221      35.380   9.848  63.307  1.00 31.31           C  
ATOM   1824  N   VAL   222      38.672  10.319  60.057  1.00 27.83           N  
ATOM   1825  CA  VAL   222      40.110  10.473  59.815  1.00 28.23           C  
ATOM   1826  C   VAL   222      40.653  11.421  60.884  1.00 27.20           C  
ATOM   1827  O   VAL   222      40.133  12.543  61.058  1.00 27.97           O  
ATOM   1828  CB  VAL   222      40.425  11.042  58.399  1.00 28.20           C  
ATOM   1829  CG1 VAL   222      41.961  11.195  58.185  1.00 29.34           C  
ATOM   1830  CG2 VAL   222      39.803  10.172  57.328  1.00 30.60           C  
ATOM   1831  N   ALA   223      41.658  10.972  61.643  1.00 26.30           N  
ATOM   1832  CA  ALA   223      42.220  11.821  62.692  1.00 25.77           C  
ATOM   1833  C   ALA   223      43.707  12.042  62.431  1.00 26.13           C  
ATOM   1834  O   ALA   223      44.431  11.092  62.163  1.00 25.66           O  
ATOM   1835  CB  ALA   223      41.999  11.215  64.064  1.00 26.54           C  
ATOM   1836  N   ILE   224      44.157  13.296  62.469  1.00 24.89           N  
ATOM   1837  CA  ILE   224      45.565  13.598  62.158  1.00 24.93           C  
ATOM   1838  C   ILE   224      46.203  14.224  63.398  1.00 24.71           C  
ATOM   1839  O   ILE   224      45.780  15.324  63.837  1.00 24.37           O  
ATOM   1840  CB  ILE   224      45.690  14.545  60.947  1.00 24.68           C  
ATOM   1841  CG1 ILE   224      44.926  13.981  59.740  1.00 25.85           C  
ATOM   1842  CG2 ILE   224      47.177  14.741  60.567  1.00 25.43           C  
ATOM   1843  CD1 ILE   224      45.102  14.817  58.464  1.00 26.42           C  
ATOM   1844  N   GLY   225      47.193  13.531  63.976  1.00 24.29           N  
ATOM   1845  CA  GLY   225      47.828  13.965  65.243  1.00 24.00           C  
ATOM   1846  C   GLY   225      49.365  13.959  65.143  1.00 23.46           C  
ATOM   1847  O   GLY   225      49.934  13.514  64.134  1.00 23.07           O  
ATOM   1848  N   HIS   226      50.044  14.381  66.201  1.00 22.78           N  
ATOM   1849  CA  HIS   226      51.527  14.471  66.158  1.00 23.19           C  
ATOM   1850  C   HIS   226      52.239  14.197  67.489  1.00 23.03           C  
ATOM   1851  O   HIS   226      53.450  14.048  67.496  1.00 22.15           O  
ATOM   1852  CB  HIS   226      51.993  15.824  65.559  1.00 23.23           C  
ATOM   1853  CG  HIS   226      51.933  16.971  66.526  1.00 23.91           C  
ATOM   1854  ND1 HIS   226      50.743  17.456  67.032  1.00 25.13           N  
ATOM   1855  CD2 HIS   226      52.914  17.748  67.046  1.00 25.12           C  
ATOM   1856  CE1 HIS   226      50.996  18.472  67.844  1.00 25.61           C  
ATOM   1857  NE2 HIS   226      52.305  18.675  67.864  1.00 23.93           N  
ATOM   1858  N   GLN   227      51.500  14.155  68.608  1.00 22.83           N  
ATOM   1859  CA  GLN   227      52.134  13.879  69.923  1.00 23.45           C  
ATOM   1860  C   GLN   227      51.501  12.700  70.685  1.00 22.59           C  
ATOM   1861  O   GLN   227      50.537  12.093  70.215  1.00 22.33           O  
ATOM   1862  CB  GLN   227      52.113  15.133  70.801  1.00 22.88           C  
ATOM   1863  CG  GLN   227      52.760  16.301  70.143  1.00 25.56           C  
ATOM   1864  CD  GLN   227      52.962  17.441  71.109  1.00 28.03           C  
ATOM   1865  OE1 GLN   227      52.022  18.141  71.458  1.00 29.31           O  
ATOM   1866  NE2 GLN   227      54.190  17.623  71.539  1.00 25.63           N  
ATOM   1867  N   TYR   228      52.045  12.386  71.858  1.00 22.47           N  
ATOM   1868  CA  TYR   228      51.575  11.199  72.618  1.00 22.82           C  
ATOM   1869  C   TYR   228      50.096  11.257  72.947  1.00 23.18           C  
ATOM   1870  O   TYR   228      49.387  10.227  72.910  1.00 23.61           O  
ATOM   1871  CB  TYR   228      52.399  10.986  73.899  1.00 23.04           C  
ATOM   1872  CG  TYR   228      53.850  10.655  73.611  1.00 24.87           C  
ATOM   1873  CD1 TYR   228      54.202   9.458  72.991  1.00 28.27           C  
ATOM   1874  CD2 TYR   228      54.865  11.517  73.980  1.00 28.89           C  
ATOM   1875  CE1 TYR   228      55.549   9.121  72.725  1.00 28.17           C  
ATOM   1876  CE2 TYR   228      56.233  11.195  73.722  1.00 28.28           C  
ATOM   1877  CZ  TYR   228      56.546   9.999  73.091  1.00 28.51           C  
ATOM   1878  OH  TYR   228      57.875   9.681  72.846  1.00 27.14           O  
ATOM   1879  N   ASP   229      49.609  12.460  73.215  1.00 22.58           N  
ATOM   1880  CA  ASP   229      48.221  12.594  73.618  1.00 23.33           C  
ATOM   1881  C   ASP   229      47.262  12.372  72.454  1.00 23.38           C  
ATOM   1882  O   ASP   229      46.058  12.244  72.666  1.00 24.04           O  
ATOM   1883  CB  ASP   229      47.959  13.940  74.312  1.00 23.91           C  
ATOM   1884  CG  ASP   229      48.228  15.132  73.408  1.00 24.90           C  
ATOM   1885  OD1 ASP   229      49.172  15.064  72.593  1.00 27.32           O  
ATOM   1886  OD2 ASP   229      47.499  16.154  73.523  1.00 27.38           O  
ATOM   1887  N   ASP   230      47.799  12.378  71.231  1.00 23.48           N  
ATOM   1888  CA  ASP   230      47.022  12.092  70.011  1.00 24.70           C  
ATOM   1889  C   ASP   230      46.957  10.601  69.704  1.00 25.26           C  
ATOM   1890  O   ASP   230      46.155  10.143  68.863  1.00 25.79           O  
ATOM   1891  CB  ASP   230      47.652  12.817  68.831  1.00 23.62           C  
ATOM   1892  CG  ASP   230      47.716  14.333  69.056  1.00 25.09           C  
ATOM   1893  OD1 ASP   230      46.675  14.930  69.417  1.00 25.87           O  
ATOM   1894  OD2 ASP   230      48.804  14.916  68.925  1.00 25.09           O  
ATOM   1895  N   LEU   231      47.773   9.810  70.387  1.00 26.29           N  
ATOM   1896  CA  LEU   231      47.804   8.372  70.052  1.00 26.35           C  
ATOM   1897  C   LEU   231      46.455   7.652  70.147  1.00 27.21           C  
ATOM   1898  O   LEU   231      46.104   6.861  69.251  1.00 27.17           O  
ATOM   1899  CB  LEU   231      48.858   7.647  70.892  1.00 27.34           C  
ATOM   1900  CG  LEU   231      50.265   7.741  70.328  1.00 29.56           C  
ATOM   1901  CD1 LEU   231      51.271   7.174  71.343  1.00 30.37           C  
ATOM   1902  CD2 LEU   231      50.346   6.987  68.964  1.00 30.69           C  
ATOM   1903  N   PRO   232      45.690   7.874  71.236  1.00 27.17           N  
ATOM   1904  CA  PRO   232      44.395   7.182  71.317  1.00 27.16           C  
ATOM   1905  C   PRO   232      43.461   7.491  70.154  1.00 27.46           C  
ATOM   1906  O   PRO   232      42.847   6.575  69.619  1.00 27.80           O  
ATOM   1907  CB  PRO   232      43.804   7.699  72.642  1.00 27.75           C  
ATOM   1908  CG  PRO   232      45.047   8.054  73.455  1.00 27.55           C  
ATOM   1909  CD  PRO   232      45.981   8.650  72.458  1.00 26.76           C  
ATOM   1910  N   MET   233      43.371   8.751  69.722  1.00 27.42           N  
ATOM   1911  CA  MET   233      42.440   9.030  68.639  1.00 28.57           C  
ATOM   1912  C   MET   233      42.994   8.478  67.317  1.00 28.53           C  
ATOM   1913  O   MET   233      42.218   8.092  66.450  1.00 29.36           O  
ATOM   1914  CB  MET   233      42.101  10.519  68.529  1.00 29.13           C  
ATOM   1915  CG  MET   233      43.183  11.353  67.938  1.00 27.81           C  
ATOM   1916  SD  MET   233      42.680  13.240  67.696  0.50 30.15          SE  
ATOM   1917  CE  MET   233      44.251  13.669  66.592  1.00 32.01           C  
ATOM   1918  N   ILE   234      44.318   8.447  67.176  1.00 27.31           N  
ATOM   1919  CA  ILE   234      44.958   7.823  66.013  1.00 28.21           C  
ATOM   1920  C   ILE   234      44.637   6.325  65.959  1.00 28.21           C  
ATOM   1921  O   ILE   234      44.330   5.807  64.873  1.00 29.17           O  
ATOM   1922  CB  ILE   234      46.508   8.081  65.966  1.00 26.73           C  
ATOM   1923  CG1 ILE   234      46.783   9.530  65.567  1.00 28.11           C  
ATOM   1924  CG2 ILE   234      47.215   7.093  64.970  1.00 28.48           C  
ATOM   1925  CD1 ILE   234      48.201  10.011  65.865  1.00 28.72           C  
ATOM   1926  N   GLU   235      44.686   5.643  67.111  1.00 28.54           N  
ATOM   1927  CA  GLU   235      44.384   4.220  67.177  0.50 29.19           C  
ATOM   1929  C   GLU   235      42.883   3.938  66.985  1.00 29.62           C  
ATOM   1930  O   GLU   235      42.500   2.945  66.343  1.00 28.04           O  
ATOM   1931  CB  GLU   235      44.873   3.645  68.509  0.50 29.29           C  
ATOM   1933  CG  GLU   235      46.276   3.029  68.460  0.50 30.56           C  
ATOM   1935  CD  GLU   235      47.359   3.906  69.051  0.50 31.08           C  
ATOM   1937  OE1 GLU   235      47.777   3.650  70.211  0.50 30.84           O  
ATOM   1939  OE2 GLU   235      47.796   4.847  68.359  0.50 28.87           O  
ATOM   1941  N   LEU   236      42.044   4.813  67.537  1.00 28.58           N  
ATOM   1942  CA  LEU   236      40.593   4.605  67.535  1.00 29.29           C  
ATOM   1943  C   LEU   236      39.868   5.059  66.250  1.00 29.42           C  
ATOM   1944  O   LEU   236      38.822   4.498  65.889  1.00 28.58           O  
ATOM   1945  CB  LEU   236      39.966   5.252  68.792  1.00 30.15           C  
ATOM   1946  CG  LEU   236      40.315   4.638  70.158  1.00 31.75           C  
ATOM   1947  CD1 LEU   236      40.036   5.637  71.300  1.00 36.79           C  
ATOM   1948  CD2 LEU   236      39.595   3.318  70.423  1.00 37.77           C  
ATOM   1949  N   ALA   237      40.418   6.062  65.554  1.00 29.65           N  
ATOM   1950  CA  ALA   237      39.818   6.548  64.293  1.00 29.89           C  
ATOM   1951  C   ALA   237      39.876   5.488  63.196  1.00 29.89           C  
ATOM   1952  O   ALA   237      40.800   4.661  63.183  1.00 30.68           O  
ATOM   1953  CB  ALA   237      40.540   7.804  63.821  1.00 29.61           C  
ATOM   1954  N   GLY   238      38.918   5.519  62.265  1.00 28.95           N  
ATOM   1955  CA  GLY   238      38.940   4.646  61.085  1.00 29.07           C  
ATOM   1956  C   GLY   238      40.256   4.754  60.333  1.00 28.70           C  
ATOM   1957  O   GLY   238      40.816   3.742  59.864  1.00 28.91           O  
ATOM   1958  N   LEU   239      40.755   5.980  60.205  1.00 27.16           N  
ATOM   1959  CA  LEU   239      42.070   6.225  59.612  1.00 27.11           C  
ATOM   1960  C   LEU   239      42.861   7.191  60.525  1.00 26.00           C  
ATOM   1961  O   LEU   239      42.470   8.349  60.699  1.00 25.76           O  
ATOM   1962  CB  LEU   239      41.906   6.807  58.212  1.00 26.94           C  
ATOM   1963  CG  LEU   239      43.143   7.089  57.372  1.00 30.13           C  
ATOM   1964  CD1 LEU   239      44.072   5.828  57.356  1.00 31.29           C  
ATOM   1965  CD2 LEU   239      42.612   7.377  55.973  1.00 34.74           C  
ATOM   1966  N   GLY   240      43.945   6.698  61.120  1.00 24.72           N  
ATOM   1967  CA  GLY   240      44.729   7.483  62.057  1.00 24.42           C  
ATOM   1968  C   GLY   240      46.042   7.840  61.374  1.00 24.09           C  
ATOM   1969  O   GLY   240      46.785   6.949  60.937  1.00 23.99           O  
ATOM   1970  N   VAL   241      46.332   9.142  61.299  1.00 24.04           N  
ATOM   1971  CA  VAL   241      47.449   9.639  60.515  1.00 24.33           C  
ATOM   1972  C   VAL   241      48.455  10.346  61.447  1.00 23.63           C  
ATOM   1973  O   VAL   241      48.043  11.158  62.283  1.00 23.79           O  
ATOM   1974  CB  VAL   241      46.928  10.651  59.474  1.00 24.63           C  
ATOM   1975  CG1 VAL   241      48.129  11.281  58.676  1.00 25.61           C  
ATOM   1976  CG2 VAL   241      45.830   9.988  58.557  1.00 25.98           C  
ATOM   1977  N   ALA   242      49.743  10.018  61.317  1.00 22.72           N  
ATOM   1978  CA  ALA   242      50.804  10.750  62.022  1.00 23.21           C  
ATOM   1979  C   ALA   242      51.487  11.737  61.068  1.00 22.60           C  
ATOM   1980  O   ALA   242      51.840  11.384  59.944  1.00 22.15           O  
ATOM   1981  CB  ALA   242      51.846   9.767  62.625  1.00 23.54           C  
ATOM   1982  N   MET   243      51.630  12.988  61.524  1.00 22.05           N  
ATOM   1983  CA  MET   243      52.361  14.012  60.813  1.00 22.04           C  
ATOM   1984  C   MET   243      53.819  13.591  60.787  1.00 22.56           C  
ATOM   1985  O   MET   243      54.292  12.919  61.700  1.00 22.91           O  
ATOM   1986  CB  MET   243      52.199  15.376  61.527  1.00 20.21           C  
ATOM   1987  CG  MET   243      50.726  15.848  61.559  1.00 22.79           C  
ATOM   1988  SD  MET   243      50.166  16.341  59.759  0.70 26.56          SE  
ATOM   1989  CE  MET   243      51.564  17.566  59.227  1.00 24.96           C  
ATOM   1990  N   GLY   244      54.527  14.004  59.743  1.00 22.35           N  
ATOM   1991  CA  GLY   244      55.936  13.689  59.578  1.00 23.44           C  
ATOM   1992  C   GLY   244      56.833  14.174  60.708  1.00 24.47           C  
ATOM   1993  O   GLY   244      57.893  13.588  60.958  1.00 24.84           O  
ATOM   1994  N   ASN   245      56.422  15.250  61.373  1.00 24.06           N  
ATOM   1995  CA  ASN   245      57.198  15.842  62.460  1.00 22.95           C  
ATOM   1996  C   ASN   245      56.949  15.141  63.812  1.00 23.19           C  
ATOM   1997  O   ASN   245      57.580  15.509  64.827  1.00 23.42           O  
ATOM   1998  CB  ASN   245      56.876  17.341  62.571  1.00 21.83           C  
ATOM   1999  CG  ASN   245      55.377  17.622  62.450  1.00 22.80           C  
ATOM   2000  OD1 ASN   245      54.792  17.493  61.360  1.00 21.47           O  
ATOM   2001  ND2 ASN   245      54.739  17.947  63.576  1.00 21.39           N  
ATOM   2002  N   ALA   246      56.072  14.130  63.836  1.00 22.82           N  
ATOM   2003  CA  ALA   246      55.839  13.332  65.050  1.00 22.79           C  
ATOM   2004  C   ALA   246      57.073  12.480  65.367  1.00 23.93           C  
ATOM   2005  O   ALA   246      57.844  12.153  64.467  1.00 23.59           O  
ATOM   2006  CB  ALA   246      54.623  12.428  64.894  1.00 22.71           C  
ATOM   2007  N   VAL   247      57.269  12.103  66.638  1.00 24.77           N  
ATOM   2008  CA  VAL   247      58.391  11.192  66.956  1.00 25.24           C  
ATOM   2009  C   VAL   247      58.183   9.791  66.325  1.00 26.43           C  
ATOM   2010  O   VAL   247      57.052   9.408  66.064  1.00 26.31           O  
ATOM   2011  CB  VAL   247      58.661  11.093  68.485  1.00 25.73           C  
ATOM   2012  CG1 VAL   247      59.047  12.472  69.049  1.00 26.91           C  
ATOM   2013  CG2 VAL   247      57.456  10.490  69.236  1.00 25.18           C  
ATOM   2014  N   PRO   248      59.274   9.053  66.041  1.00 26.84           N  
ATOM   2015  CA  PRO   248      59.184   7.721  65.401  1.00 28.05           C  
ATOM   2016  C   PRO   248      58.164   6.752  66.010  1.00 28.51           C  
ATOM   2017  O   PRO   248      57.472   6.056  65.262  1.00 28.43           O  
ATOM   2018  CB  PRO   248      60.611   7.178  65.543  1.00 28.55           C  
ATOM   2019  CG  PRO   248      61.437   8.402  65.432  1.00 28.21           C  
ATOM   2020  CD  PRO   248      60.688   9.441  66.243  1.00 27.65           C  
ATOM   2021  N   GLU   249      58.045   6.714  67.336  1.00 29.47           N  
ATOM   2022  CA  GLU   249      57.081   5.809  67.977  1.00 31.60           C  
ATOM   2023  C   GLU   249      55.653   6.076  67.531  1.00 30.30           C  
ATOM   2024  O   GLU   249      54.891   5.145  67.255  1.00 30.56           O  
ATOM   2025  CB  GLU   249      57.137   5.920  69.496  1.00 32.47           C  
ATOM   2026  CG  GLU   249      56.068   5.031  70.201  1.00 36.08           C  
ATOM   2027  CD  GLU   249      56.011   5.273  71.694  1.00 36.27           C  
ATOM   2028  OE1 GLU   249      57.098   5.515  72.270  1.00 41.61           O  
ATOM   2029  OE2 GLU   249      54.892   5.224  72.281  1.00 40.09           O  
ATOM   2030  N   ILE   250      55.291   7.358  67.480  1.00 27.91           N  
ATOM   2031  CA  ILE   250      53.971   7.750  67.007  1.00 26.50           C  
ATOM   2032  C   ILE   250      53.788   7.397  65.539  1.00 26.00           C  
ATOM   2033  O   ILE   250      52.730   6.896  65.129  1.00 25.28           O  
ATOM   2034  CB  ILE   250      53.729   9.236  67.272  1.00 26.28           C  
ATOM   2035  CG1 ILE   250      53.754   9.446  68.802  1.00 27.05           C  
ATOM   2036  CG2 ILE   250      52.427   9.698  66.596  1.00 26.15           C  
ATOM   2037  CD1 ILE   250      53.726  10.881  69.239  1.00 30.28           C  
ATOM   2038  N   LYS   251      54.833   7.635  64.750  1.00 25.02           N  
ATOM   2039  CA  LYS   251      54.780   7.291  63.324  1.00 25.90           C  
ATOM   2040  C   LYS   251      54.607   5.792  63.105  1.00 26.34           C  
ATOM   2041  O   LYS   251      53.857   5.373  62.218  1.00 27.33           O  
ATOM   2042  CB  LYS   251      56.008   7.853  62.597  1.00 25.13           C  
ATOM   2043  CG  LYS   251      55.946   9.402  62.603  1.00 27.20           C  
ATOM   2044  CD  LYS   251      56.880  10.070  61.611  1.00 27.44           C  
ATOM   2045  CE  LYS   251      58.301  10.034  62.110  1.00 30.65           C  
ATOM   2046  NZ  LYS   251      59.127  11.048  61.390  1.00 27.07           N  
ATOM   2047  N   ARG   252      55.258   4.982  63.931  1.00 26.48           N  
ATOM   2048  CA  ARG   252      55.081   3.521  63.830  1.00 26.17           C  
ATOM   2049  C   ARG   252      53.658   3.088  64.172  1.00 27.38           C  
ATOM   2050  O   ARG   252      53.122   2.138  63.558  1.00 27.56           O  
ATOM   2051  CB  ARG   252      56.067   2.788  64.726  1.00 25.93           C  
ATOM   2052  CG  ARG   252      57.483   2.791  64.223  1.00 24.21           C  
ATOM   2053  CD  ARG   252      58.314   1.746  64.989  1.00 27.39           C  
ATOM   2054  NE  ARG   252      58.402   2.104  66.409  1.00 28.96           N  
ATOM   2055  CZ  ARG   252      59.325   2.912  66.926  1.00 29.93           C  
ATOM   2056  NH1 ARG   252      60.255   3.464  66.150  1.00 30.96           N  
ATOM   2057  NH2 ARG   252      59.301   3.185  68.223  1.00 31.28           N  
ATOM   2058  N   LYS   253      53.029   3.806  65.104  1.00 26.16           N  
ATOM   2059  CA  LYS   253      51.714   3.395  65.603  1.00 26.68           C  
ATOM   2060  C   LYS   253      50.532   3.801  64.737  1.00 25.93           C  
ATOM   2061  O   LYS   253      49.469   3.203  64.830  1.00 25.23           O  
ATOM   2062  CB  LYS   253      51.530   3.854  67.034  1.00 26.72           C  
ATOM   2063  CG  LYS   253      52.386   3.029  67.945  1.00 30.39           C  
ATOM   2064  CD  LYS   253      52.209   3.410  69.383  1.00 31.63           C  
ATOM   2065  CE  LYS   253      52.644   2.234  70.273  1.00 33.52           C  
ATOM   2066  NZ  LYS   253      52.440   2.596  71.683  1.00 36.24           N  
ATOM   2067  N   ALA   254      50.729   4.814  63.907  1.00 24.33           N  
ATOM   2068  CA  ALA   254      49.709   5.294  62.990  1.00 24.70           C  
ATOM   2069  C   ALA   254      49.421   4.318  61.839  1.00 26.07           C  
ATOM   2070  O   ALA   254      50.261   3.451  61.495  1.00 25.87           O  
ATOM   2071  CB  ALA   254      50.128   6.638  62.423  1.00 24.51           C  
ATOM   2072  N   ASP   255      48.266   4.483  61.207  1.00 25.57           N  
ATOM   2073  CA  ASP   255      47.956   3.693  60.015  1.00 27.11           C  
ATOM   2074  C   ASP   255      48.709   4.236  58.813  1.00 27.57           C  
ATOM   2075  O   ASP   255      49.010   3.523  57.870  1.00 26.36           O  
ATOM   2076  CB  ASP   255      46.465   3.750  59.727  1.00 27.08           C  
ATOM   2077  CG  ASP   255      45.630   3.348  60.935  1.00 28.43           C  
ATOM   2078  OD1 ASP   255      46.098   2.472  61.708  1.00 30.86           O  
ATOM   2079  OD2 ASP   255      44.525   3.911  61.114  1.00 27.78           O  
ATOM   2080  N   TRP   256      49.014   5.524  58.873  1.00 28.09           N  
ATOM   2081  CA  TRP   256      49.508   6.246  57.732  1.00 28.91           C  
ATOM   2082  C   TRP   256      50.416   7.359  58.225  1.00 27.48           C  
ATOM   2083  O   TRP   256      50.028   8.072  59.143  1.00 26.12           O  
ATOM   2084  CB  TRP   256      48.280   6.865  57.103  1.00 31.66           C  
ATOM   2085  CG  TRP   256      48.473   7.553  55.835  1.00 35.83           C  
ATOM   2086  CD1 TRP   256      49.530   8.360  55.467  1.00 39.27           C  
ATOM   2087  CD2 TRP   256      47.555   7.570  54.750  1.00 37.87           C  
ATOM   2088  NE1 TRP   256      49.330   8.846  54.196  1.00 40.18           N  
ATOM   2089  CE2 TRP   256      48.114   8.392  53.741  1.00 40.29           C  
ATOM   2090  CE3 TRP   256      46.304   6.976  54.529  1.00 39.44           C  
ATOM   2091  CZ2 TRP   256      47.465   8.627  52.523  1.00 39.24           C  
ATOM   2092  CZ3 TRP   256      45.653   7.213  53.317  1.00 38.57           C  
ATOM   2093  CH2 TRP   256      46.237   8.034  52.330  1.00 38.71           C  
ATOM   2094  N   VAL   257      51.592   7.522  57.616  1.00 25.70           N  
ATOM   2095  CA  VAL   257      52.486   8.651  57.971  1.00 26.11           C  
ATOM   2096  C   VAL   257      52.534   9.629  56.808  1.00 26.15           C  
ATOM   2097  O   VAL   257      52.800   9.222  55.658  1.00 25.71           O  
ATOM   2098  CB  VAL   257      53.926   8.165  58.276  1.00 25.53           C  
ATOM   2099  CG1 VAL   257      54.822   9.328  58.596  1.00 25.30           C  
ATOM   2100  CG2 VAL   257      53.931   7.181  59.453  1.00 27.38           C  
ATOM   2101  N   THR   258      52.256  10.903  57.078  1.00 24.62           N  
ATOM   2102  CA  THR   258      52.303  11.903  56.008  1.00 24.30           C  
ATOM   2103  C   THR   258      53.565  12.763  56.156  1.00 23.94           C  
ATOM   2104  O   THR   258      54.437  12.497  57.010  1.00 23.29           O  
ATOM   2105  CB  THR   258      50.963  12.710  55.940  1.00 24.99           C  
ATOM   2106  OG1 THR   258      50.926  13.539  54.768  1.00 24.74           O  
ATOM   2107  CG2 THR   258      50.718  13.567  57.201  1.00 23.24           C  
ATOM   2108  N   ARG   259      53.689  13.775  55.312  1.00 22.47           N  
ATOM   2109  CA  ARG   259      54.808  14.695  55.401  1.00 22.99           C  
ATOM   2110  C   ARG   259      54.673  15.618  56.633  1.00 22.86           C  
ATOM   2111  O   ARG   259      53.647  15.593  57.317  1.00 23.01           O  
ATOM   2112  CB  ARG   259      54.849  15.529  54.139  1.00 21.55           C  
ATOM   2113  CG  ARG   259      55.174  14.668  52.937  1.00 24.21           C  
ATOM   2114  CD  ARG   259      55.297  15.488  51.699  1.00 24.26           C  
ATOM   2115  NE  ARG   259      55.839  14.667  50.598  1.00 24.24           N  
ATOM   2116  CZ  ARG   259      56.083  15.144  49.382  1.00 27.53           C  
ATOM   2117  NH1 ARG   259      55.805  16.426  49.121  1.00 22.20           N  
ATOM   2118  NH2 ARG   259      56.564  14.331  48.426  1.00 25.32           N  
ATOM   2119  N   SER   260      55.706  16.405  56.917  1.00 23.28           N  
ATOM   2120  CA  SER   260      55.705  17.229  58.138  1.00 23.33           C  
ATOM   2121  C   SER   260      54.753  18.428  57.995  1.00 22.50           C  
ATOM   2122  O   SER   260      54.306  18.746  56.884  1.00 22.18           O  
ATOM   2123  CB  SER   260      57.131  17.734  58.409  1.00 25.09           C  
ATOM   2124  OG  SER   260      57.382  18.926  57.677  1.00 27.19           O  
ATOM   2125  N   ASN   261      54.516  19.142  59.105  1.00 22.48           N  
ATOM   2126  CA  ASN   261      53.738  20.376  59.074  1.00 22.26           C  
ATOM   2127  C   ASN   261      54.443  21.519  58.344  1.00 22.43           C  
ATOM   2128  O   ASN   261      53.813  22.519  58.003  1.00 22.77           O  
ATOM   2129  CB  ASN   261      53.318  20.802  60.502  1.00 21.69           C  
ATOM   2130  CG  ASN   261      54.498  21.144  61.391  1.00 22.89           C  
ATOM   2131  OD1 ASN   261      55.555  20.481  61.364  1.00 22.86           O  
ATOM   2132  ND2 ASN   261      54.307  22.171  62.227  1.00 22.44           N  
ATOM   2133  N   ASP   262      55.749  21.385  58.121  1.00 22.12           N  
ATOM   2134  CA  ASP   262      56.460  22.377  57.308  1.00 22.60           C  
ATOM   2135  C   ASP   262      56.566  21.958  55.830  1.00 21.47           C  
ATOM   2136  O   ASP   262      57.220  22.631  55.028  1.00 21.76           O  
ATOM   2137  CB  ASP   262      57.827  22.702  57.914  1.00 23.23           C  
ATOM   2138  CG  ASP   262      57.701  23.550  59.204  1.00 28.19           C  
ATOM   2139  OD1 ASP   262      56.796  24.403  59.290  1.00 27.66           O  
ATOM   2140  OD2 ASP   262      58.485  23.332  60.143  1.00 33.51           O  
ATOM   2141  N   GLU   263      55.935  20.842  55.488  1.00 20.80           N  
ATOM   2142  CA  GLU   263      55.899  20.352  54.103  1.00 20.78           C  
ATOM   2143  C   GLU   263      54.452  19.989  53.758  1.00 21.17           C  
ATOM   2144  O   GLU   263      54.193  19.045  53.025  1.00 22.36           O  
ATOM   2145  CB  GLU   263      56.830  19.147  53.922  1.00 21.19           C  
ATOM   2146  CG  GLU   263      57.305  18.969  52.469  1.00 23.89           C  
ATOM   2147  CD  GLU   263      58.305  20.051  52.082  1.00 26.49           C  
ATOM   2148  OE1 GLU   263      57.984  20.868  51.161  1.00 26.66           O  
ATOM   2149  OE2 GLU   263      59.402  20.108  52.732  1.00 27.13           O  
ATOM   2150  N   GLN   264      53.509  20.729  54.332  1.00 20.75           N  
ATOM   2151  CA  GLN   264      52.091  20.622  53.972  1.00 21.64           C  
ATOM   2152  C   GLN   264      51.573  19.180  54.046  1.00 21.50           C  
ATOM   2153  O   GLN   264      50.905  18.699  53.141  1.00 21.41           O  
ATOM   2154  CB  GLN   264      51.838  21.292  52.588  1.00 20.91           C  
ATOM   2155  CG  GLN   264      51.810  22.840  52.717  1.00 23.81           C  
ATOM   2156  CD  GLN   264      53.155  23.394  53.217  1.00 25.44           C  
ATOM   2157  OE1 GLN   264      53.308  23.782  54.413  1.00 22.26           O  
ATOM   2158  NE2 GLN   264      54.162  23.374  52.313  1.00 22.74           N  
ATOM   2159  N   GLY   265      51.851  18.519  55.166  1.00 20.55           N  
ATOM   2160  CA  GLY   265      51.471  17.127  55.333  1.00 21.09           C  
ATOM   2161  C   GLY   265      49.973  16.875  55.378  1.00 22.40           C  
ATOM   2162  O   GLY   265      49.515  15.828  54.922  1.00 21.89           O  
ATOM   2163  N   VAL   266      49.211  17.835  55.908  1.00 21.97           N  
ATOM   2164  CA  VAL   266      47.721  17.726  55.884  1.00 22.34           C  
ATOM   2165  C   VAL   266      47.177  17.692  54.434  1.00 22.44           C  
ATOM   2166  O   VAL   266      46.434  16.773  54.065  1.00 22.33           O  
ATOM   2167  CB  VAL   266      47.061  18.869  56.706  1.00 21.95           C  
ATOM   2168  CG1 VAL   266      45.535  18.928  56.427  1.00 23.91           C  
ATOM   2169  CG2 VAL   266      47.319  18.618  58.180  1.00 23.66           C  
ATOM   2170  N   ALA   267      47.548  18.697  53.632  1.00 21.52           N  
ATOM   2171  CA  ALA   267      47.176  18.747  52.217  1.00 22.29           C  
ATOM   2172  C   ALA   267      47.645  17.503  51.447  1.00 22.60           C  
ATOM   2173  O   ALA   267      46.916  16.959  50.594  1.00 22.47           O  
ATOM   2174  CB  ALA   267      47.726  20.014  51.562  1.00 22.47           C  
ATOM   2175  N   TYR   268      48.857  17.052  51.748  1.00 21.54           N  
ATOM   2176  CA  TYR   268      49.449  15.932  51.026  1.00 23.44           C  
ATOM   2177  C   TYR   268      48.621  14.669  51.301  1.00 24.29           C  
ATOM   2178  O   TYR   268      48.274  13.905  50.367  1.00 24.69           O  
ATOM   2179  CB  TYR   268      50.894  15.731  51.491  1.00 23.22           C  
ATOM   2180  CG  TYR   268      51.715  14.768  50.652  1.00 23.53           C  
ATOM   2181  CD1 TYR   268      52.211  15.146  49.413  1.00 23.71           C  
ATOM   2182  CD2 TYR   268      52.037  13.505  51.133  1.00 25.80           C  
ATOM   2183  CE1 TYR   268      53.010  14.275  48.643  1.00 24.92           C  
ATOM   2184  CE2 TYR   268      52.818  12.595  50.355  1.00 22.95           C  
ATOM   2185  CZ  TYR   268      53.302  13.009  49.117  1.00 23.37           C  
ATOM   2186  OH  TYR   268      54.091  12.152  48.347  1.00 27.35           O  
ATOM   2187  N   MET   269      48.306  14.468  52.581  1.00 25.17           N  
ATOM   2188  CA  MET   269      47.506  13.307  52.969  0.50 25.64           C  
ATOM   2190  C   MET   269      46.100  13.379  52.366  1.00 25.96           C  
ATOM   2191  O   MET   269      45.602  12.371  51.838  1.00 26.32           O  
ATOM   2192  CB  MET   269      47.481  13.137  54.495  0.50 26.22           C  
ATOM   2194  CG  MET   269      46.753  11.904  54.997  0.50 26.59           C  
ATOM   2196  SD  MET   269      44.912  12.282  55.331  0.40 30.28          SE  
ATOM   2198  CE  MET   269      44.208  10.481  55.334  0.50 26.85           C  
ATOM   2200  N   MET   270      45.450  14.538  52.412  1.00 25.78           N  
ATOM   2201  CA  MET   270      44.070  14.568  51.896  1.00 25.69           C  
ATOM   2202  C   MET   270      43.972  14.413  50.375  1.00 24.64           C  
ATOM   2203  O   MET   270      43.013  13.825  49.877  1.00 23.32           O  
ATOM   2204  CB  MET   270      43.268  15.755  52.440  1.00 26.63           C  
ATOM   2205  CG  MET   270      42.825  15.545  53.961  1.00 27.90           C  
ATOM   2206  SD  MET   270      41.981  13.811  54.467  0.50 33.51          SE  
ATOM   2207  CE  MET   270      40.197  14.101  53.788  1.00 31.19           C  
ATOM   2208  N   LYS   271      44.983  14.896  49.653  1.00 23.82           N  
ATOM   2209  CA  LYS   271      45.079  14.665  48.209  1.00 24.03           C  
ATOM   2210  C   LYS   271      45.081  13.154  47.917  1.00 24.38           C  
ATOM   2211  O   LYS   271      44.362  12.670  47.021  1.00 22.62           O  
ATOM   2212  CB  LYS   271      46.335  15.337  47.654  1.00 24.47           C  
ATOM   2213  CG  LYS   271      46.520  15.228  46.144  1.00 28.95           C  
ATOM   2214  CD  LYS   271      45.551  16.114  45.384  1.00 33.45           C  
ATOM   2215  CE  LYS   271      45.691  15.935  43.886  1.00 37.61           C  
ATOM   2216  NZ  LYS   271      44.779  16.886  43.204  1.00 39.47           N  
ATOM   2217  N   GLU   272      45.877  12.411  48.677  1.00 23.92           N  
ATOM   2218  CA  GLU   272      45.906  10.938  48.549  1.00 26.36           C  
ATOM   2219  C   GLU   272      44.581  10.270  48.930  1.00 26.60           C  
ATOM   2220  O   GLU   272      44.140   9.337  48.218  1.00 27.95           O  
ATOM   2221  CB  GLU   272      47.062  10.326  49.346  1.00 26.62           C  
ATOM   2222  CG  GLU   272      47.214   8.811  49.151  1.00 29.70           C  
ATOM   2223  CD  GLU   272      47.293   8.396  47.695  1.00 32.19           C  
ATOM   2224  OE1 GLU   272      47.910   9.137  46.883  1.00 34.53           O  
ATOM   2225  OE2 GLU   272      46.727   7.327  47.342  1.00 31.05           O  
ATOM   2226  N   TYR   273      43.962  10.730  50.018  1.00 27.42           N  
ATOM   2227  CA  TYR   273      42.645  10.244  50.417  1.00 29.11           C  
ATOM   2228  C   TYR   273      41.693  10.315  49.235  1.00 28.66           C  
ATOM   2229  O   TYR   273      40.979   9.347  48.960  1.00 28.96           O  
ATOM   2230  CB  TYR   273      42.071  10.981  51.636  1.00 30.66           C  
ATOM   2231  CG  TYR   273      40.606  10.658  51.859  1.00 33.11           C  
ATOM   2232  CD1 TYR   273      39.612  11.556  51.477  1.00 35.41           C  
ATOM   2233  CD2 TYR   273      40.211   9.410  52.383  1.00 37.23           C  
ATOM   2234  CE1 TYR   273      38.252  11.254  51.638  1.00 36.08           C  
ATOM   2235  CE2 TYR   273      38.848   9.091  52.547  1.00 35.87           C  
ATOM   2236  CZ  TYR   273      37.884  10.029  52.179  1.00 36.29           C  
ATOM   2237  OH  TYR   273      36.545   9.741  52.329  1.00 36.82           O  
ATOM   2238  N   PHE   274      41.701  11.436  48.511  1.00 27.89           N  
ATOM   2239  CA  PHE   274      40.801  11.576  47.361  1.00 27.82           C  
ATOM   2240  C   PHE   274      41.198  10.776  46.122  1.00 28.80           C  
ATOM   2241  O   PHE   274      40.331  10.270  45.398  1.00 27.67           O  
ATOM   2242  CB  PHE   274      40.536  13.035  47.045  1.00 28.07           C  
ATOM   2243  CG  PHE   274      39.715  13.705  48.098  1.00 29.10           C  
ATOM   2244  CD1 PHE   274      38.391  13.303  48.324  1.00 31.46           C  
ATOM   2245  CD2 PHE   274      40.262  14.696  48.889  1.00 29.57           C  
ATOM   2246  CE1 PHE   274      37.625  13.911  49.319  1.00 32.39           C  
ATOM   2247  CE2 PHE   274      39.508  15.316  49.883  1.00 30.78           C  
ATOM   2248  CZ  PHE   274      38.198  14.925  50.098  1.00 29.96           C  
ATOM   2249  N   ARG   275      42.492  10.670  45.869  1.00 29.47           N  
ATOM   2250  CA  ARG   275      42.956   9.764  44.817  1.00 32.37           C  
ATOM   2251  C   ARG   275      42.481   8.333  45.105  1.00 33.10           C  
ATOM   2252  O   ARG   275      42.013   7.642  44.205  1.00 33.20           O  
ATOM   2253  CB  ARG   275      44.478   9.860  44.643  1.00 31.99           C  
ATOM   2254  CG  ARG   275      44.897  11.083  43.793  1.00 34.08           C  
ATOM   2255  CD  ARG   275      46.361  11.045  43.328  1.00 34.50           C  
ATOM   2256  NE  ARG   275      47.193  11.008  44.498  1.00 36.44           N  
ATOM   2257  CZ  ARG   275      47.923  12.011  44.982  1.00 37.79           C  
ATOM   2258  NH1 ARG   275      48.059  13.173  44.338  1.00 39.78           N  
ATOM   2259  NH2 ARG   275      48.571  11.808  46.104  1.00 27.71           N  
ATOM   2260  N   MET   276      42.568   7.917  46.363  1.00 35.02           N  
ATOM   2261  CA  MET   276      42.074   6.605  46.816  1.00 38.13           C  
ATOM   2262  C   MET   276      40.580   6.439  46.522  1.00 38.01           C  
ATOM   2263  O   MET   276      40.161   5.423  45.963  1.00 38.25           O  
ATOM   2264  CB  MET   276      42.323   6.465  48.319  1.00 38.20           C  
ATOM   2265  CG  MET   276      43.023   5.196  48.773  1.00 40.53           C  
ATOM   2266  SD  MET   276      44.223   5.555  50.270  0.50 41.91          SE  
ATOM   2267  CE  MET   276      43.199   6.978  51.120  1.00 42.05           C  
ATOM   2268  N   GLN   277      39.793   7.443  46.899  1.00 38.41           N  
ATOM   2269  CA  GLN   277      38.355   7.535  46.572  1.00 39.20           C  
ATOM   2270  C   GLN   277      38.045   7.405  45.086  1.00 39.22           C  
ATOM   2271  O   GLN   277      37.153   6.650  44.691  1.00 38.94           O  
ATOM   2272  CB  GLN   277      37.792   8.870  47.074  1.00 39.68           C  
ATOM   2273  CG  GLN   277      37.736   8.976  48.580  1.00 42.29           C  
ATOM   2274  CD  GLN   277      36.893   7.873  49.186  1.00 46.38           C  
ATOM   2275  OE1 GLN   277      37.383   7.072  49.988  1.00 49.96           O  
ATOM   2276  NE2 GLN   277      35.626   7.810  48.790  1.00 46.50           N  
ATOM   2277  N   GLN   278      38.777   8.151  44.267  1.00 39.48           N  
ATOM   2278  CA  GLN   278      38.612   8.118  42.821  1.00 40.80           C  
ATOM   2279  C   GLN   278      38.903   6.717  42.258  1.00 40.52           C  
ATOM   2280  O   GLN   278      38.180   6.228  41.383  1.00 40.34           O  
ATOM   2281  CB  GLN   278      39.540   9.151  42.190  1.00 40.71           C  
ATOM   2282  CG  GLN   278      39.202   9.545  40.770  1.00 42.69           C  
ATOM   2283  CD  GLN   278      40.159  10.602  40.240  1.00 43.19           C  
ATOM   2284  OE1 GLN   278      40.382  11.636  40.889  1.00 46.36           O  
ATOM   2285  NE2 GLN   278      40.743  10.342  39.064  1.00 44.93           N  
ATOM   2286  N   ARG   279      39.954   6.074  42.772  1.00 40.61           N  
ATOM   2287  CA  ARG   279      40.327   4.713  42.359  1.00 40.81           C  
ATOM   2288  C   ARG   279      39.246   3.698  42.730  1.00 40.76           C  
ATOM   2289  O   ARG   279      38.869   2.854  41.910  1.00 40.29           O  
ATOM   2290  CB  ARG   279      41.671   4.317  42.969  1.00 41.24           C  
ATOM   2291  CG  ARG   279      42.856   5.053  42.346  1.00 41.88           C  
ATOM   2292  CD  ARG   279      44.163   4.348  42.653  1.00 42.99           C  
ATOM   2293  NE  ARG   279      44.582   4.612  44.016  1.00 43.79           N  
ATOM   2294  CZ  ARG   279      45.338   5.647  44.376  1.00 43.13           C  
ATOM   2295  NH1 ARG   279      45.777   6.518  43.463  1.00 42.82           N  
ATOM   2296  NH2 ARG   279      45.652   5.802  45.650  1.00 41.15           N  
ATOM   2297  N   LYS   280      38.754   3.792  43.965  1.00 40.64           N  
ATOM   2298  CA  LYS   280      37.587   3.026  44.395  1.00 40.87           C  
ATOM   2299  C   LYS   280      36.318   3.585  43.743  1.00 40.93           C  
ATOM   2300  O   LYS   280      35.798   3.009  42.779  1.00 41.19           O  
ATOM   2301  CB  LYS   280      37.465   3.046  45.922  1.00 40.47           C  
END
