
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  225 ( 1788),  selected  225 , name 1kyt_A
# Molecule2: number of CA atoms  275 ( 2161),  selected  275 , name T0505.pdb
# PARAMETERS: 1kyt_A.T0505.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    I     2_A      K       6          1.433
LGA    R     3_A      Q       7          1.413
LGA    L     4_A      L       8          1.055
LGA    A     5_A      L       9          0.305
LGA    A     6_A      A      10          0.816
LGA    I     7_A      L      11          0.884
LGA    D     8_A      N      12          1.373
LGA    V     9_A      I      13          1.367
LGA    D    10_A      D      14          1.546
LGA    G    11_A      G      15          2.936
LGA    N    12_A      A      16          1.093
LGA    L    13_A      L      17          1.555
LGA    T    14_A      L      18          2.219
LGA    D    15_A      R      19          2.189
LGA    R    16_A      S      20          2.746
LGA    D    17_A      N      21          3.453
LGA    R    18_A      -       -           -
LGA    L    19_A      G      22          0.641
LGA    I    20_A      K      23          3.275
LGA    S    21_A      I      24          2.613
LGA    T    22_A      H      25          1.808
LGA    K    23_A      Q      26          3.358
LGA    -       -      A      27           -
LGA    A    24_A      T      28          2.111
LGA    I    25_A      K      29          2.876
LGA    E    26_A      D      30          3.007
LGA    S    27_A      A      31          1.897
LGA    I    28_A      I      32          1.419
LGA    R    29_A      E      33          2.290
LGA    S    30_A      Y      34          2.781
LGA    A    31_A      V      35          1.946
LGA    E    32_A      K      36          1.555
LGA    K    33_A      K      37          2.614
LGA    K    34_A      K      38          2.797
LGA    G    35_A      G      39          1.930
LGA    L    36_A      I      40          1.880
LGA    T    37_A      Y      41          1.163
LGA    V    38_A      V      42          0.477
LGA    S    39_A      T      43          0.718
LGA    L    40_A      L      44          0.074
LGA    L    41_A      V      45          1.026
LGA    S    42_A      T      46          0.862
LGA    G    43_A      N      47          0.709
LGA    N    44_A      R      48          1.534
LGA    V    45_A      H      49          1.211
LGA    I    46_A      F      50          1.279
LGA    P    47_A      R      51          1.568
LGA    V    48_A      S      52          1.622
LGA    V    49_A      A      53          1.195
LGA    Y    50_A      Q      54          1.720
LGA    A    51_A      K      55          1.660
LGA    L    52_A      I      56          1.584
LGA    K    53_A      A      57          1.771
LGA    I    54_A      K      58          1.703
LGA    F    55_A      S      59          2.508
LGA    L    56_A      L      60          2.603
LGA    G    57_A      K      61          1.673
LGA    I    58_A      L      62          1.657
LGA    N    59_A      D      63          3.126
LGA    G    60_A      A      64          1.957
LGA    P    61_A      K      65          1.032
LGA    V    62_A      L      66          0.612
LGA    F    63_A      I      67          1.434
LGA    G    64_A      T      68          1.140
LGA    E    65_A      H      69          1.218
LGA    N    66_A      S      70          0.946
LGA    G    67_A      G      71          0.894
LGA    G    68_A      A      72          1.097
LGA    I    69_A      Y      73          0.583
LGA    X    70_A      I      74          0.858
LGA    F    71_A      A      75          1.191
LGA    D    72_A      E      76          2.973
LGA    N    73_A      -       -           -
LGA    D    74_A      -       -           -
LGA    G    75_A      K      77          3.333
LGA    S    76_A      I      78          5.602
LGA    -       -      D      79           -
LGA    I    77_A      A      80          3.431
LGA    K    78_A      P      81          2.610
LGA    -       -      F      82           -
LGA    K    79_A      F      83          3.861
LGA    F    80_A      E      84          3.498
LGA    F    81_A      K      85          2.115
LGA    S    82_A      R      86          1.607
LGA    N    83_A      I      87          1.768
LGA    E    84_A      S      88          1.720
LGA    -       -      D      89           -
LGA    G    85_A      D      90           #
LGA    T    86_A      H      91          5.446
LGA    N    87_A      T      92          1.827
LGA    K    88_A      F      93          2.682
LGA    F    89_A      N      94          4.097
LGA    L    90_A      I      95          3.386
LGA    E    91_A      V      96          1.962
LGA    E    92_A      Q      97          1.320
LGA    X    93_A      V      98          1.702
LGA    S    94_A      L      99          3.563
LGA    K    95_A      E     100          3.402
LGA    R    96_A      S     101          1.411
LGA    T    97_A      Y     102          1.343
LGA    S    98_A      Q     103          1.965
LGA    X    99_A      C     104          2.857
LGA    R   100_A      N     105          3.281
LGA    S   101_A      I     106          2.681
LGA    I   102_A      R     107          2.669
LGA    L   103_A      -       -           -
LGA    T   104_A      L     108          6.015
LGA    N   105_A      L     109          2.664
LGA    R   106_A      H     110          4.455
LGA    W   107_A      E     111          3.200
LGA    -       -      K     112           -
LGA    -       -      Y     113           -
LGA    -       -      S     114           -
LGA    -       -      I     115           -
LGA    -       -      G     116           -
LGA    -       -      N     117           -
LGA    -       -      K     118           -
LGA    -       -      K     119           -
LGA    -       -      K     120           -
LGA    -       -      V     121           -
LGA    -       -      N     122           -
LGA    -       -      S     123           -
LGA    -       -      N     124           -
LGA    -       -      L     125           -
LGA    -       -      L     126           -
LGA    -       -      G     127           -
LGA    -       -      K     128           -
LGA    -       -      A     129           -
LGA    -       -      L     130           -
LGA    -       -      I     131           -
LGA    -       -      H     132           -
LGA    -       -      P     133           -
LGA    -       -      S     134           -
LGA    -       -      D     135           -
LGA    -       -      P     136           -
LGA    -       -      I     137           -
LGA    -       -      F     138           -
LGA    -       -      Y     139           -
LGA    -       -      P     140           -
LGA    -       -      V     141           -
LGA    -       -      Q     142           -
LGA    -       -      F     143           -
LGA    -       -      V     144           -
LGA    -       -      E     145           -
LGA    -       -      S     146           -
LGA    -       -      L     147           -
LGA    -       -      S     148           -
LGA    -       -      D     149           -
LGA    -       -      L     150           -
LGA    -       -      L     151           -
LGA    -       -      M     152           -
LGA    -       -      D     153           -
LGA    -       -      E     154           -
LGA    -       -      P     155           -
LGA    -       -      V     156           -
LGA    -       -      S     157           -
LGA    R   108_A      A     158          4.622
LGA    E   109_A      P     159          3.148
LGA    A   110_A      -       -           -
LGA    S   111_A      V     160          1.886
LGA    T   112_A      I     161          1.165
LGA    G   113_A      E     162          1.805
LGA    F   114_A      V     163          2.899
LGA    D   115_A      Y     164          2.907
LGA    I   116_A      T     165          2.986
LGA    D   117_A      E     166          4.142
LGA    P   118_A      H     167          3.809
LGA    E   119_A      D     168          4.090
LGA    D   120_A      I     169          3.198
LGA    V   121_A      Q     170          2.127
LGA    D   122_A      H     171          2.544
LGA    Y   123_A      D     172          1.866
LGA    V   124_A      I     173          0.996
LGA    R   125_A      T     174          0.948
LGA    K   126_A      E     175          0.778
LGA    E   127_A      T     176          0.861
LGA    A   128_A      I     177          1.588
LGA    E   129_A      T     178          1.624
LGA    S   130_A      K     179          1.058
LGA    R   131_A      A     180          3.611
LGA    -       -      F     181           -
LGA    G   132_A      P     182          3.308
LGA    -       -      A     183           -
LGA    -       -      V     184           -
LGA    F   133_A      D     185          2.307
LGA    V   134_A      V     186          0.906
LGA    I   135_A      I     187          3.622
LGA    F   136_A      R     188          2.125
LGA    Y   137_A      V     189          2.948
LGA    S   138_A      N     190           #
LGA    G   139_A      D     191           -
LGA    Y   140_A      E     192           -
LGA    S   141_A      K     193          5.219
LGA    W   142_A      L     194          3.513
LGA    H   143_A      N     195          1.602
LGA    L   144_A      I     196          1.302
LGA    X   145_A      V     197          1.949
LGA    N   146_A      P     198          3.034
LGA    R   147_A      K     199          3.852
LGA    G   148_A      G     200          2.784
LGA    E   149_A      V     201          1.295
LGA    D   150_A      S     202          1.036
LGA    K   151_A      K     203          1.646
LGA    A   152_A      E     204          1.488
LGA    F   153_A      A     205          0.464
LGA    A   154_A      G     206          1.420
LGA    V   155_A      L     207          1.629
LGA    N   156_A      A     208          0.862
LGA    K   157_A      L     209          0.835
LGA    L   158_A      V     210          1.703
LGA    K   159_A      A     211          1.537
LGA    E   160_A      S     212          0.833
LGA    X   161_A      E     213          1.009
LGA    Y   162_A      L     214          0.741
LGA    S   163_A      G     215          0.334
LGA    L   164_A      L     216          1.300
LGA    E   165_A      S     217          3.392
LGA    Y   166_A      M     218          2.967
LGA    D   167_A      D     219          2.818
LGA    E   168_A      D     220          2.050
LGA    I   169_A      V     221          1.361
LGA    L   170_A      V     222          0.880
LGA    V   171_A      A     223          0.820
LGA    I   172_A      I     224          0.824
LGA    G   173_A      G     225          1.059
LGA    D   174_A      H     226          1.894
LGA    S   175_A      Q     227          2.810
LGA    N   176_A      Y     228          1.929
LGA    N   177_A      D     229          1.094
LGA    D   178_A      D     230          0.780
LGA    X   179_A      L     231          1.256
LGA    P   180_A      P     232          1.363
LGA    X   181_A      M     233          0.793
LGA    F   182_A      I     234          1.762
LGA    Q   183_A      E     235          2.100
LGA    L   184_A      L     236          1.324
LGA    P   185_A      A     237          4.803
LGA    V   186_A      G     238          1.731
LGA    R   187_A      L     239          1.749
LGA    K   188_A      G     240          2.063
LGA    A   189_A      V     241          2.179
LGA    C   190_A      A     242          2.433
LGA    P   191_A      M     243          2.234
LGA    A   192_A      G     244          2.436
LGA    N   193_A      N     245          3.131
LGA    A   194_A      A     246          2.979
LGA    T   195_A      V     247          3.646
LGA    D   196_A      P     248          3.770
LGA    -       -      E     249           -
LGA    -       -      I     250           -
LGA    -       -      K     251           -
LGA    N   197_A      R     252          3.267
LGA    I   198_A      K     253          2.916
LGA    K   199_A      A     254          3.165
LGA    A   200_A      -       -           -
LGA    V   201_A      -       -           -
LGA    S   202_A      D     255          1.024
LGA    D   203_A      -       -           -
LGA    F   204_A      W     256          2.939
LGA    V   205_A      V     257          2.207
LGA    S   206_A      T     258          1.808
LGA    D   207_A      R     259          3.763
LGA    Y   208_A      S     260          4.219
LGA    S   209_A      N     261          3.557
LGA    Y   210_A      D     262          3.312
LGA    G   211_A      E     263           #
LGA    E   212_A      Q     264          0.706
LGA    E   213_A      G     265          1.143
LGA    I   214_A      V     266          1.099
LGA    G   215_A      A     267          0.992
LGA    Q   216_A      Y     268          1.520
LGA    I   217_A      M     269          1.347
LGA    F   218_A      M     270          1.185
LGA    K   219_A      K     271          1.193
LGA    H   220_A      E     272          1.367
LGA    F   221_A      Y     273          1.448
LGA    E   222_A      F     274          1.045
LGA    -       -      R     275           -
LGA    -       -      M     276           -
LGA    L   223_A      Q     277           #
LGA    X   224_A      Q     278           -
LGA    -       -      R     279           -
LGA    -       -      K     280           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  225  275    5.0    208    2.35    13.46     50.282     8.485

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.962638 * X  +   0.247691 * Y  +  -0.109437 * Z  +  52.908016
  Y_new =   0.080537 * X  +  -0.123970 * Y  +  -0.989012 * Z  +   5.598163
  Z_new =  -0.258536 * X  +  -0.960875 * Y  +   0.099390 * Z  + 103.806816 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.467726    1.673867  [ DEG:   -84.0945     95.9055 ]
  Theta =   0.261507    2.880086  [ DEG:    14.9832    165.0168 ]
  Phi   =   3.058124   -0.083469  [ DEG:   175.2176     -4.7824 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1kyt_A                                        
REMARK     2: T0505.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1kyt_A.T0505.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  225  275   5.0  208   2.35   13.46  50.282
REMARK  ---------------------------------------------------------- 
MOLECULE 1kyt_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   05-FEB-02   1KYT              
TITLE     CRYSTAL STRUCTURE OF THERMOPLASMA ACIDOPHILUM 0175 (APC014)           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN TA0175;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOPLASMA ACIDOPHILUM;                       
SOURCE   3 GENE: TA0175;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    STRUCTURAL GENOMICS, PUTATIVE HYDROLASE, PSI, PROTEIN                 
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,A.JOACHIMIAK,A.EDWARDS,X.XU,M.PENNYCOOKE,J.GU,                  
AUTHOR   2 F.CHEUNG,D.CHRISTENDAT,MIDWEST CENTER FOR STRUCTURAL                 
AUTHOR   3 GENOMICS (MCSG)                                                      
REVDAT   2   18-JAN-05 1KYT    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   21-JAN-03 1KYT    0                                                
JRNL        AUTH   Y.KIM,A.JOACHIMIAK,A.EDWARDS,X.XU,M.PENNYCOOKE,              
JRNL        AUTH 2 J.GU,F.CHEUNG,D.CHRISTENDAT                                  
JRNL        TITL   CRYSTAL STRUCTURE OF THERMOPLASMA ACIDOPHILUM 0175           
JRNL        TITL 2 (APC014)                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1KYT A    1   224  UNP    Q9HLQ2   PGP_THEAC        1    224             
DBREF  1KYT B    1   224  UNP    Q9HLQ2   PGP_THEAC        1    224             
SEQRES   1 A  227  GLY SER HIS MSE ILE ARG LEU ALA ALA ILE ASP VAL ASP          
SEQRES   2 A  227  GLY ASN LEU THR ASP ARG ASP ARG LEU ILE SER THR LYS          
SEQRES   3 A  227  ALA ILE GLU SER ILE ARG SER ALA GLU LYS LYS GLY LEU          
SEQRES   4 A  227  THR VAL SER LEU LEU SER GLY ASN VAL ILE PRO VAL VAL          
SEQRES   5 A  227  TYR ALA LEU LYS ILE PHE LEU GLY ILE ASN GLY PRO VAL          
SEQRES   6 A  227  PHE GLY GLU ASN GLY GLY ILE MSE PHE ASP ASN ASP GLY          
SEQRES   7 A  227  SER ILE LYS LYS PHE PHE SER ASN GLU GLY THR ASN LYS          
SEQRES   8 A  227  PHE LEU GLU GLU MSE SER LYS ARG THR SER MSE ARG SER          
SEQRES   9 A  227  ILE LEU THR ASN ARG TRP ARG GLU ALA SER THR GLY PHE          
SEQRES  10 A  227  ASP ILE ASP PRO GLU ASP VAL ASP TYR VAL ARG LYS GLU          
SEQRES  11 A  227  ALA GLU SER ARG GLY PHE VAL ILE PHE TYR SER GLY TYR          
SEQRES  12 A  227  SER TRP HIS LEU MSE ASN ARG GLY GLU ASP LYS ALA PHE          
SEQRES  13 A  227  ALA VAL ASN LYS LEU LYS GLU MSE TYR SER LEU GLU TYR          
SEQRES  14 A  227  ASP GLU ILE LEU VAL ILE GLY ASP SER ASN ASN ASP MSE          
SEQRES  15 A  227  PRO MSE PHE GLN LEU PRO VAL ARG LYS ALA CYS PRO ALA          
SEQRES  16 A  227  ASN ALA THR ASP ASN ILE LYS ALA VAL SER ASP PHE VAL          
SEQRES  17 A  227  SER ASP TYR SER TYR GLY GLU GLU ILE GLY GLN ILE PHE          
SEQRES  18 A  227  LYS HIS PHE GLU LEU MSE                                      
SEQRES   1 B  227  GLY SER HIS MSE ILE ARG LEU ALA ALA ILE ASP VAL ASP          
SEQRES   2 B  227  GLY ASN LEU THR ASP ARG ASP ARG LEU ILE SER THR LYS          
SEQRES   3 B  227  ALA ILE GLU SER ILE ARG SER ALA GLU LYS LYS GLY LEU          
SEQRES   4 B  227  THR VAL SER LEU LEU SER GLY ASN VAL ILE PRO VAL VAL          
SEQRES   5 B  227  TYR ALA LEU LYS ILE PHE LEU GLY ILE ASN GLY PRO VAL          
SEQRES   6 B  227  PHE GLY GLU ASN GLY GLY ILE MSE PHE ASP ASN ASP GLY          
SEQRES   7 B  227  SER ILE LYS LYS PHE PHE SER ASN GLU GLY THR ASN LYS          
SEQRES   8 B  227  PHE LEU GLU GLU MSE SER LYS ARG THR SER MSE ARG SER          
SEQRES   9 B  227  ILE LEU THR ASN ARG TRP ARG GLU ALA SER THR GLY PHE          
SEQRES  10 B  227  ASP ILE ASP PRO GLU ASP VAL ASP TYR VAL ARG LYS GLU          
SEQRES  11 B  227  ALA GLU SER ARG GLY PHE VAL ILE PHE TYR SER GLY TYR          
SEQRES  12 B  227  SER TRP HIS LEU MSE ASN ARG GLY GLU ASP LYS ALA PHE          
SEQRES  13 B  227  ALA VAL ASN LYS LEU LYS GLU MSE TYR SER LEU GLU TYR          
SEQRES  14 B  227  ASP GLU ILE LEU VAL ILE GLY ASP SER ASN ASN ASP MSE          
SEQRES  15 B  227  PRO MSE PHE GLN LEU PRO VAL ARG LYS ALA CYS PRO ALA          
SEQRES  16 B  227  ASN ALA THR ASP ASN ILE LYS ALA VAL SER ASP PHE VAL          
SEQRES  17 B  227  SER ASP TYR SER TYR GLY GLU GLU ILE GLY GLN ILE PHE          
SEQRES  18 B  227  LYS HIS PHE GLU LEU MSE                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  70       8                                                       
HET    MSE  A  93       8                                                       
HET    MSE  A  99       8                                                       
HET    MSE  A 145       8                                                       
HET    MSE  A 161       8                                                       
HET    MSE  A 179       8                                                       
HET    MSE  A 181       8                                                       
HET    MSE  A 224       9                                                       
HET    MSE  B   1      16                                                       
HET    MSE  B  70       8                                                       
HET    MSE  B  93       8                                                       
HET    MSE  B  99       8                                                       
HET    MSE  B 145       8                                                       
HET    MSE  B 161       8                                                       
HET    MSE  B 179       8                                                       
HET    MSE  B 181       8                                                       
HET    MSE  B 224       9                                                       
HET     CA    501       1                                                       
HET     CA    502       1                                                       
HET     CA    503       1                                                       
HET     CA    504       1                                                       
HET     CA    505       1                                                       
HET     CA    506       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CA CALCIUM ION                                                      
FORMUL   1  MSE    18(C5 H11 N O2 SE)                                           
FORMUL   3   CA    6(CA 2+)                                                     
FORMUL   9  HOH   *437(H2 O)                                                    
CRYST1   88.526   99.316  113.886  90.00  90.00  90.00 I 2 2 2      16          
ATOM      1  N   HIS A   0      33.817   2.770  53.031  1.00 42.23           N  
ATOM      2  CA  HIS A   0      33.206   3.983  53.643  1.00 42.41           C  
ATOM      3  C   HIS A   0      33.841   5.287  53.170  1.00 40.32           C  
ATOM      4  O   HIS A   0      35.057   5.460  53.222  1.00 41.19           O  
ATOM      5  CB  HIS A   0      33.306   3.921  55.167  1.00 46.06           C  
ATOM      6  CG  HIS A   0      32.287   3.029  55.807  1.00 48.39           C  
ATOM      7  ND1 HIS A   0      32.626   1.975  56.630  1.00 49.74           N  
ATOM      8  CD2 HIS A   0      30.934   3.049  55.761  1.00 49.23           C  
ATOM      9  CE1 HIS A   0      31.527   1.385  57.063  1.00 51.72           C  
ATOM     10  NE2 HIS A   0      30.485   2.018  56.551  1.00 51.33           N  
HETATM   11  N   MSE A   1      33.007   6.212  52.718  1.00 37.38           N  
HETATM   12  CA  MSE A   1      33.509   7.493  52.271  1.00 36.79           C  
HETATM   13  C   MSE A   1      33.655   8.363  53.513  1.00 32.39           C  
HETATM   14  O   MSE A   1      32.783   8.376  54.371  1.00 33.34           O  
HETATM   15  CB  MSE A   1      32.535   8.118  51.288  1.00 47.18           C  
HETATM   16  CG  MSE A   1      32.157   7.169  50.164  1.00 57.95           C  
HETATM   17 SE   MSE A   1      31.360   8.078  48.666  1.00 75.08          SE  
HETATM   18  CE  MSE A   1      29.754   8.739  49.518  1.00 78.26           C  
ATOM     19  N   ILE A   2      34.775   9.069  53.607  1.00 26.91           N  
ATOM     20  CA  ILE A   2      35.042   9.943  54.740  1.00 20.35           C  
ATOM     21  C   ILE A   2      34.097  11.124  54.715  1.00 17.15           C  
ATOM     22  O   ILE A   2      33.980  11.790  53.706  1.00 16.87           O  
ATOM     23  CB  ILE A   2      36.491  10.477  54.703  1.00 18.58           C  
ATOM     24  CG1 ILE A   2      37.473   9.303  54.765  1.00 16.41           C  
ATOM     25  CG2 ILE A   2      36.708  11.474  55.837  1.00 17.33           C  
ATOM     26  CD1 ILE A   2      37.188   8.323  55.861  1.00 17.78           C  
ATOM     27  N   ARG A   3      33.429  11.379  55.836  0.50 17.05           N  
ATOM     29  CA  ARG A   3      32.495  12.497  55.925  0.50 16.85           C  
ATOM     31  C   ARG A   3      33.040  13.559  56.873  0.50 15.59           C  
ATOM     33  O   ARG A   3      32.772  14.740  56.715  0.50 17.11           O  
ATOM     35  CB  ARG A   3      31.132  11.998  56.420  0.50 18.80           C  
ATOM     37  CG  ARG A   3      30.429  11.044  55.457  0.50 21.49           C  
ATOM     39  CD  ARG A   3      29.061  10.619  55.984  0.50 24.73           C  
ATOM     41  NE  ARG A   3      28.353   9.729  55.065  0.50 28.11           N  
ATOM     43  CZ  ARG A   3      27.125   9.263  55.274  0.50 29.74           C  
ATOM     45  NH1 ARG A   3      26.465   9.605  56.374  0.50 30.38           N  
ATOM     47  NH2 ARG A   3      26.558   8.454  54.386  0.50 30.93           N  
ATOM     49  N   LEU A   4      33.814  13.130  57.863  1.00 14.80           N  
ATOM     50  CA  LEU A   4      34.385  14.059  58.827  1.00 12.73           C  
ATOM     51  C   LEU A   4      35.851  13.773  59.138  1.00 10.92           C  
ATOM     52  O   LEU A   4      36.278  12.620  59.179  1.00 12.69           O  
ATOM     53  CB  LEU A   4      33.553  14.036  60.123  1.00 12.29           C  
ATOM     54  CG  LEU A   4      33.885  15.016  61.250  1.00 15.55           C  
ATOM     55  CD1 LEU A   4      32.655  15.223  62.120  1.00 16.12           C  
ATOM     56  CD2 LEU A   4      35.018  14.487  62.094  1.00 15.04           C  
ATOM     57  N   ALA A   5      36.615  14.835  59.345  1.00 10.47           N  
ATOM     58  CA  ALA A   5      38.032  14.729  59.682  1.00 10.59           C  
ATOM     59  C   ALA A   5      38.282  15.466  60.995  1.00 10.14           C  
ATOM     60  O   ALA A   5      37.885  16.624  61.155  1.00  9.59           O  
ATOM     61  CB  ALA A   5      38.892  15.329  58.562  1.00 12.67           C  
ATOM     62  N   ALA A   6      38.912  14.778  61.944  1.00 10.22           N  
ATOM     63  CA  ALA A   6      39.204  15.376  63.245  1.00 10.10           C  
ATOM     64  C   ALA A   6      40.703  15.602  63.262  1.00 10.10           C  
ATOM     65  O   ALA A   6      41.465  14.645  63.234  1.00 11.61           O  
ATOM     66  CB  ALA A   6      38.786  14.429  64.357  1.00  5.16           C  
ATOM     67  N   ILE A   7      41.122  16.864  63.323  1.00 12.99           N  
ATOM     68  CA  ILE A   7      42.541  17.197  63.255  1.00 11.81           C  
ATOM     69  C   ILE A   7      43.173  17.822  64.498  1.00 12.75           C  
ATOM     70  O   ILE A   7      42.603  18.729  65.117  1.00 13.54           O  
ATOM     71  CB  ILE A   7      42.790  18.153  62.072  1.00 12.89           C  
ATOM     72  CG1 ILE A   7      42.139  17.593  60.810  1.00 11.42           C  
ATOM     73  CG2 ILE A   7      44.293  18.380  61.860  1.00  7.10           C  
ATOM     74  CD1 ILE A   7      42.271  18.535  59.582  1.00 14.96           C  
ATOM     75  N   ASP A   8      44.362  17.331  64.851  1.00 11.66           N  
ATOM     76  CA  ASP A   8      45.109  17.850  65.994  1.00 12.67           C  
ATOM     77  C   ASP A   8      45.763  19.140  65.509  1.00 12.51           C  
ATOM     78  O   ASP A   8      46.615  19.117  64.642  1.00 12.60           O  
ATOM     79  CB  ASP A   8      46.144  16.809  66.429  1.00 12.72           C  
ATOM     80  CG  ASP A   8      47.256  17.376  67.306  1.00 13.71           C  
ATOM     81  OD1 ASP A   8      47.111  18.428  67.967  1.00 11.42           O  
ATOM     82  OD2 ASP A   8      48.304  16.720  67.330  1.00 13.91           O  
ATOM     83  N   VAL A   9      45.335  20.269  66.065  1.00 11.35           N  
ATOM     84  CA  VAL A   9      45.858  21.561  65.653  1.00 11.70           C  
ATOM     85  C   VAL A   9      47.366  21.727  65.824  1.00 10.53           C  
ATOM     86  O   VAL A   9      48.087  21.929  64.848  1.00 12.84           O  
ATOM     87  CB  VAL A   9      45.125  22.703  66.402  1.00 12.32           C  
ATOM     88  CG1 VAL A   9      45.727  24.064  66.032  1.00 11.36           C  
ATOM     89  CG2 VAL A   9      43.648  22.684  66.042  1.00 11.25           C  
ATOM     90  N   ASP A  10      47.842  21.609  67.053  1.00  9.46           N  
ATOM     91  CA  ASP A  10      49.260  21.792  67.337  1.00 13.07           C  
ATOM     92  C   ASP A  10      50.180  20.742  66.730  1.00 12.47           C  
ATOM     93  O   ASP A  10      51.308  21.040  66.351  1.00 10.95           O  
ATOM     94  CB  ASP A  10      49.457  21.887  68.841  1.00 16.86           C  
ATOM     95  CG  ASP A  10      48.495  22.875  69.477  1.00 19.86           C  
ATOM     96  OD1 ASP A  10      47.385  22.461  69.874  1.00 22.84           O  
ATOM     97  OD2 ASP A  10      48.832  24.079  69.551  1.00 24.25           O  
ATOM     98  N   GLY A  11      49.706  19.509  66.639  1.00 11.02           N  
ATOM     99  CA  GLY A  11      50.546  18.488  66.059  1.00 11.49           C  
ATOM    100  C   GLY A  11      50.601  18.496  64.545  1.00 10.11           C  
ATOM    101  O   GLY A  11      51.636  18.186  63.951  1.00  9.79           O  
ATOM    102  N   ASN A  12      49.523  18.902  63.895  1.00  8.08           N  
ATOM    103  CA  ASN A  12      49.518  18.813  62.439  1.00  8.70           C  
ATOM    104  C   ASN A  12      49.288  20.038  61.579  1.00  9.35           C  
ATOM    105  O   ASN A  12      49.527  19.984  60.374  1.00 11.27           O  
ATOM    106  CB  ASN A  12      48.505  17.745  62.023  1.00  8.49           C  
ATOM    107  CG  ASN A  12      48.834  16.377  62.583  1.00  9.48           C  
ATOM    108  OD1 ASN A  12      49.552  15.591  61.970  1.00 10.26           O  
ATOM    109  ND2 ASN A  12      48.315  16.089  63.776  1.00 12.99           N  
ATOM    110  N   LEU A  13      48.827  21.133  62.162  1.00  9.56           N  
ATOM    111  CA  LEU A  13      48.552  22.311  61.358  1.00  8.95           C  
ATOM    112  C   LEU A  13      49.584  23.417  61.438  1.00 10.52           C  
ATOM    113  O   LEU A  13      49.387  24.483  60.847  1.00  9.07           O  
ATOM    114  CB  LEU A  13      47.184  22.878  61.745  1.00  8.82           C  
ATOM    115  CG  LEU A  13      46.005  21.923  61.537  1.00 11.16           C  
ATOM    116  CD1 LEU A  13      44.703  22.623  61.900  1.00 13.79           C  
ATOM    117  CD2 LEU A  13      45.987  21.472  60.073  1.00  9.97           C  
ATOM    118  N   THR A  14      50.687  23.166  62.142  1.00 10.97           N  
ATOM    119  CA  THR A  14      51.694  24.206  62.342  1.00 11.99           C  
ATOM    120  C   THR A  14      53.059  23.885  61.794  1.00 11.95           C  
ATOM    121  O   THR A  14      53.366  22.730  61.501  1.00 11.85           O  
ATOM    122  CB  THR A  14      51.856  24.525  63.860  1.00 11.45           C  
ATOM    123  OG1 THR A  14      52.329  23.359  64.546  1.00 14.18           O  
ATOM    124  CG2 THR A  14      50.517  24.932  64.484  1.00 13.21           C  
ATOM    125  N   ASP A  15      53.902  24.907  61.659  1.00 12.47           N  
ATOM    126  CA  ASP A  15      55.239  24.654  61.150  1.00 16.01           C  
ATOM    127  C   ASP A  15      56.233  24.525  62.289  1.00 16.14           C  
ATOM    128  O   ASP A  15      55.837  24.406  63.460  1.00 16.17           O  
ATOM    129  CB  ASP A  15      55.673  25.740  60.144  1.00 14.22           C  
ATOM    130  CG  ASP A  15      55.742  27.135  60.746  1.00 13.85           C  
ATOM    131  OD1 ASP A  15      55.941  27.270  61.964  1.00 13.70           O  
ATOM    132  OD2 ASP A  15      55.623  28.109  59.976  1.00 14.91           O  
ATOM    133  N   ARG A  16      57.513  24.566  61.945  0.50 18.01           N  
ATOM    135  CA  ARG A  16      58.590  24.438  62.913  0.50 19.36           C  
ATOM    137  C   ARG A  16      58.562  25.517  63.990  0.50 19.78           C  
ATOM    139  O   ARG A  16      59.000  25.291  65.126  0.50 19.51           O  
ATOM    141  CB  ARG A  16      59.934  24.464  62.189  0.50 21.82           C  
ATOM    143  CG  ARG A  16      61.130  24.259  63.088  0.50 25.64           C  
ATOM    145  CD  ARG A  16      62.408  24.332  62.279  0.50 28.49           C  
ATOM    147  NE  ARG A  16      63.366  25.272  62.850  0.50 32.46           N  
ATOM    149  CZ  ARG A  16      64.506  25.626  62.263  0.50 33.10           C  
ATOM    151  NH1 ARG A  16      64.838  25.116  61.084  0.50 33.30           N  
ATOM    153  NH2 ARG A  16      65.313  26.497  62.853  0.50 33.93           N  
ATOM    155  N   ASP A  17      58.052  26.690  63.638  1.00 18.23           N  
ATOM    156  CA  ASP A  17      57.963  27.798  64.585  1.00 19.10           C  
ATOM    157  C   ASP A  17      56.593  27.908  65.230  1.00 18.25           C  
ATOM    158  O   ASP A  17      56.257  28.938  65.826  1.00 18.21           O  
ATOM    159  CB  ASP A  17      58.336  29.101  63.877  1.00 19.65           C  
ATOM    160  CG  ASP A  17      59.730  29.044  63.282  1.00 19.13           C  
ATOM    161  OD1 ASP A  17      60.688  28.760  64.032  1.00 22.24           O  
ATOM    162  OD2 ASP A  17      59.871  29.271  62.069  1.00 24.16           O  
ATOM    163  N   ARG A  18      55.809  26.836  65.121  1.00 17.74           N  
ATOM    164  CA  ARG A  18      54.465  26.788  65.699  1.00 15.46           C  
ATOM    165  C   ARG A  18      53.464  27.742  65.050  1.00 13.15           C  
ATOM    166  O   ARG A  18      52.387  27.981  65.593  1.00 13.79           O  
ATOM    167  CB  ARG A  18      54.518  27.079  67.199  1.00 18.91           C  
ATOM    168  CG  ARG A  18      55.181  26.003  68.034  1.00 19.89           C  
ATOM    169  CD  ARG A  18      55.058  26.347  69.505  1.00 25.17           C  
ATOM    170  NE  ARG A  18      55.648  25.330  70.371  1.00 29.78           N  
ATOM    171  CZ  ARG A  18      55.702  25.427  71.696  1.00 32.04           C  
ATOM    172  NH1 ARG A  18      55.201  26.496  72.302  1.00 33.87           N  
ATOM    173  NH2 ARG A  18      56.260  24.461  72.416  1.00 29.46           N  
ATOM    174  N   LEU A  19      53.810  28.295  63.898  1.00 11.78           N  
ATOM    175  CA  LEU A  19      52.885  29.186  63.218  1.00 10.68           C  
ATOM    176  C   LEU A  19      51.913  28.351  62.384  1.00 13.20           C  
ATOM    177  O   LEU A  19      52.269  27.283  61.893  1.00 14.00           O  
ATOM    178  CB  LEU A  19      53.641  30.155  62.307  1.00 12.49           C  
ATOM    179  CG  LEU A  19      54.782  30.961  62.940  1.00 12.74           C  
ATOM    180  CD1 LEU A  19      55.382  31.897  61.889  1.00 11.44           C  
ATOM    181  CD2 LEU A  19      54.276  31.741  64.136  1.00 11.41           C  
ATOM    182  N   ILE A  20      50.686  28.837  62.212  1.00 13.54           N  
ATOM    183  CA  ILE A  20      49.710  28.098  61.429  1.00 12.51           C  
ATOM    184  C   ILE A  20      50.195  27.995  59.984  1.00 10.24           C  
ATOM    185  O   ILE A  20      50.711  28.952  59.430  1.00 12.60           O  
ATOM    186  CB  ILE A  20      48.314  28.793  61.486  1.00 11.88           C  
ATOM    187  CG1 ILE A  20      47.220  27.820  61.043  1.00 12.44           C  
ATOM    188  CG2 ILE A  20      48.310  30.059  60.668  1.00  9.86           C  
ATOM    189  CD1 ILE A  20      46.857  26.823  62.108  1.00 12.72           C  
ATOM    190  N   SER A  21      50.061  26.810  59.394  1.00 10.60           N  
ATOM    191  CA  SER A  21      50.467  26.568  58.007  1.00  9.08           C  
ATOM    192  C   SER A  21      49.385  27.058  57.035  1.00 10.76           C  
ATOM    193  O   SER A  21      48.240  26.621  57.098  1.00  9.02           O  
ATOM    194  CB  SER A  21      50.687  25.063  57.806  1.00 12.61           C  
ATOM    195  OG  SER A  21      50.678  24.735  56.438  1.00 12.19           O  
ATOM    196  N   THR A  22      49.746  27.936  56.105  1.00  9.64           N  
ATOM    197  CA  THR A  22      48.743  28.441  55.187  1.00 12.35           C  
ATOM    198  C   THR A  22      48.306  27.434  54.135  1.00 12.77           C  
ATOM    199  O   THR A  22      47.164  27.483  53.686  1.00 12.86           O  
ATOM    200  CB  THR A  22      49.215  29.735  54.506  1.00 14.27           C  
ATOM    201  OG1 THR A  22      50.416  29.483  53.770  1.00 14.79           O  
ATOM    202  CG2 THR A  22      49.472  30.806  55.569  1.00 12.89           C  
ATOM    203  N   LYS A  23      49.200  26.531  53.738  1.00 11.16           N  
ATOM    204  CA  LYS A  23      48.825  25.517  52.757  1.00 12.64           C  
ATOM    205  C   LYS A  23      47.774  24.625  53.433  1.00 13.45           C  
ATOM    206  O   LYS A  23      46.779  24.242  52.808  1.00 11.77           O  
ATOM    207  CB  LYS A  23      50.033  24.673  52.348  1.00 13.80           C  
ATOM    208  CG  LYS A  23      51.078  25.420  51.553  1.00 18.18           C  
ATOM    209  CD  LYS A  23      52.211  24.493  51.158  1.00 21.87           C  
ATOM    210  CE  LYS A  23      53.290  25.227  50.381  1.00 28.44           C  
ATOM    211  NZ  LYS A  23      54.457  24.337  50.117  1.00 30.42           N  
ATOM    212  N   ALA A  24      47.986  24.324  54.717  1.00 10.10           N  
ATOM    213  CA  ALA A  24      47.038  23.494  55.459  1.00 10.76           C  
ATOM    214  C   ALA A  24      45.670  24.173  55.505  1.00 11.42           C  
ATOM    215  O   ALA A  24      44.642  23.515  55.333  1.00 10.18           O  
ATOM    216  CB  ALA A  24      47.541  23.220  56.873  1.00  8.34           C  
ATOM    217  N   ILE A  25      45.658  25.484  55.749  1.00 11.22           N  
ATOM    218  CA  ILE A  25      44.411  26.228  55.785  1.00 11.42           C  
ATOM    219  C   ILE A  25      43.734  26.106  54.422  1.00 12.26           C  
ATOM    220  O   ILE A  25      42.540  25.835  54.345  1.00 12.84           O  
ATOM    221  CB  ILE A  25      44.633  27.747  56.094  1.00 12.09           C  
ATOM    222  CG1 ILE A  25      45.407  27.921  57.402  1.00 10.32           C  
ATOM    223  CG2 ILE A  25      43.286  28.440  56.248  1.00 11.31           C  
ATOM    224  CD1 ILE A  25      45.822  29.349  57.692  1.00  9.16           C  
ATOM    225  N   GLU A  26      44.488  26.294  53.339  1.00 12.53           N  
ATOM    226  CA  GLU A  26      43.880  26.193  52.013  1.00 14.34           C  
ATOM    227  C   GLU A  26      43.380  24.777  51.710  1.00 12.54           C  
ATOM    228  O   GLU A  26      42.359  24.614  51.058  1.00 12.63           O  
ATOM    229  CB  GLU A  26      44.850  26.658  50.924  1.00 13.90           C  
ATOM    230  CG  GLU A  26      45.207  28.159  50.982  1.00 16.39           C  
ATOM    231  CD  GLU A  26      44.006  29.091  50.884  1.00 15.81           C  
ATOM    232  OE1 GLU A  26      42.896  28.621  50.575  1.00 21.77           O  
ATOM    233  OE2 GLU A  26      44.166  30.311  51.105  1.00 16.66           O  
ATOM    234  N   SER A  27      44.086  23.760  52.194  1.00 12.69           N  
ATOM    235  CA  SER A  27      43.654  22.385  51.966  1.00 12.55           C  
ATOM    236  C   SER A  27      42.337  22.157  52.703  1.00 11.81           C  
ATOM    237  O   SER A  27      41.423  21.525  52.189  1.00 14.51           O  
ATOM    238  CB  SER A  27      44.706  21.396  52.476  1.00 11.29           C  
ATOM    239  OG  SER A  27      45.924  21.532  51.768  1.00 10.99           O  
ATOM    240  N   ILE A  28      42.238  22.681  53.918  1.00 10.83           N  
ATOM    241  CA  ILE A  28      41.024  22.515  54.700  1.00 10.03           C  
ATOM    242  C   ILE A  28      39.835  23.183  54.005  1.00  9.40           C  
ATOM    243  O   ILE A  28      38.769  22.584  53.838  1.00  8.75           O  
ATOM    244  CB  ILE A  28      41.225  23.076  56.114  1.00  8.59           C  
ATOM    245  CG1 ILE A  28      42.133  22.112  56.899  1.00 11.19           C  
ATOM    246  CG2 ILE A  28      39.893  23.252  56.825  1.00  9.97           C  
ATOM    247  CD1 ILE A  28      42.655  22.652  58.221  1.00  7.66           C  
ATOM    248  N   ARG A  29      40.028  24.425  53.590  1.00 11.43           N  
ATOM    249  CA  ARG A  29      38.968  25.148  52.926  1.00 13.15           C  
ATOM    250  C   ARG A  29      38.554  24.422  51.644  1.00 13.82           C  
ATOM    251  O   ARG A  29      37.367  24.230  51.402  1.00 14.75           O  
ATOM    252  CB  ARG A  29      39.425  26.575  52.620  1.00 12.45           C  
ATOM    253  CG  ARG A  29      39.713  27.381  53.879  1.00 13.91           C  
ATOM    254  CD  ARG A  29      40.212  28.778  53.574  1.00 13.11           C  
ATOM    255  NE  ARG A  29      40.289  29.545  54.814  1.00 12.02           N  
ATOM    256  CZ  ARG A  29      40.897  30.717  54.946  1.00 10.60           C  
ATOM    257  NH1 ARG A  29      41.496  31.278  53.910  1.00 12.37           N  
ATOM    258  NH2 ARG A  29      40.899  31.327  56.121  1.00  9.06           N  
ATOM    259  N   SER A  30      39.526  24.006  50.839  1.00 14.76           N  
ATOM    260  CA  SER A  30      39.214  23.307  49.597  1.00 16.39           C  
ATOM    261  C   SER A  30      38.417  22.032  49.847  1.00 17.20           C  
ATOM    262  O   SER A  30      37.470  21.731  49.125  1.00 19.12           O  
ATOM    263  CB  SER A  30      40.488  22.952  48.838  1.00 17.10           C  
ATOM    264  OG  SER A  30      41.090  24.099  48.275  1.00 21.43           O  
ATOM    265  N   ALA A  31      38.806  21.279  50.867  1.00 14.91           N  
ATOM    266  CA  ALA A  31      38.104  20.052  51.179  1.00 15.91           C  
ATOM    267  C   ALA A  31      36.712  20.357  51.725  1.00 14.97           C  
ATOM    268  O   ALA A  31      35.746  19.674  51.391  1.00 15.06           O  
ATOM    269  CB  ALA A  31      38.911  19.225  52.187  1.00 17.30           C  
ATOM    270  N   GLU A  32      36.584  21.378  52.566  1.00 15.48           N  
ATOM    271  CA  GLU A  32      35.264  21.690  53.104  1.00 17.09           C  
ATOM    272  C   GLU A  32      34.318  22.096  51.975  1.00 17.33           C  
ATOM    273  O   GLU A  32      33.138  21.776  52.014  1.00 16.95           O  
ATOM    274  CB  GLU A  32      35.346  22.805  54.163  1.00 14.67           C  
ATOM    275  CG  GLU A  32      36.031  22.363  55.464  1.00 13.93           C  
ATOM    276  CD  GLU A  32      36.208  23.496  56.442  1.00 14.75           C  
ATOM    277  OE1 GLU A  32      36.536  24.610  55.982  1.00 16.62           O  
ATOM    278  OE2 GLU A  32      36.038  23.281  57.663  1.00 14.10           O  
ATOM    279  N   LYS A  33      34.840  22.792  50.971  1.00 18.47           N  
ATOM    280  CA  LYS A  33      34.005  23.217  49.851  1.00 22.75           C  
ATOM    281  C   LYS A  33      33.431  22.003  49.134  1.00 21.59           C  
ATOM    282  O   LYS A  33      32.380  22.082  48.509  1.00 22.73           O  
ATOM    283  CB  LYS A  33      34.815  24.062  48.862  1.00 25.40           C  
ATOM    284  CG  LYS A  33      35.425  25.307  49.486  1.00 32.19           C  
ATOM    285  CD  LYS A  33      36.149  26.171  48.465  1.00 37.15           C  
ATOM    286  CE  LYS A  33      37.009  27.228  49.156  1.00 40.63           C  
ATOM    287  NZ  LYS A  33      36.232  28.091  50.091  1.00 42.42           N  
ATOM    288  N   LYS A  34      34.116  20.874  49.238  1.00 20.93           N  
ATOM    289  CA  LYS A  34      33.642  19.672  48.568  1.00 22.86           C  
ATOM    290  C   LYS A  34      32.775  18.756  49.434  1.00 22.35           C  
ATOM    291  O   LYS A  34      32.534  17.608  49.074  1.00 24.69           O  
ATOM    292  CB  LYS A  34      34.828  18.897  48.002  1.00 25.77           C  
ATOM    293  CG  LYS A  34      35.604  19.668  46.949  1.00 29.40           C  
ATOM    294  CD  LYS A  34      36.685  18.797  46.323  1.00 36.97           C  
ATOM    295  CE  LYS A  34      37.485  19.558  45.279  1.00 40.73           C  
ATOM    296  NZ  LYS A  34      38.537  18.700  44.663  1.00 44.38           N  
ATOM    297  N   GLY A  35      32.306  19.257  50.575  1.00 21.51           N  
ATOM    298  CA  GLY A  35      31.447  18.451  51.424  1.00 18.33           C  
ATOM    299  C   GLY A  35      32.009  17.881  52.718  1.00 17.87           C  
ATOM    300  O   GLY A  35      31.249  17.372  53.539  1.00 17.88           O  
ATOM    301  N   LEU A  36      33.322  17.950  52.912  1.00 15.58           N  
ATOM    302  CA  LEU A  36      33.928  17.421  54.137  1.00 13.00           C  
ATOM    303  C   LEU A  36      33.667  18.301  55.360  1.00 12.22           C  
ATOM    304  O   LEU A  36      33.732  19.523  55.270  1.00 12.28           O  
ATOM    305  CB  LEU A  36      35.441  17.288  53.956  1.00 13.97           C  
ATOM    306  CG  LEU A  36      36.225  16.868  55.206  1.00 10.67           C  
ATOM    307  CD1 LEU A  36      35.892  15.434  55.581  1.00  9.97           C  
ATOM    308  CD2 LEU A  36      37.714  17.031  54.937  1.00 13.57           C  
ATOM    309  N   THR A  37      33.361  17.675  56.493  1.00 11.70           N  
ATOM    310  CA  THR A  37      33.153  18.400  57.748  1.00 11.25           C  
ATOM    311  C   THR A  37      34.468  18.290  58.506  1.00 12.11           C  
ATOM    312  O   THR A  37      35.023  17.194  58.638  1.00 13.07           O  
ATOM    313  CB  THR A  37      32.037  17.770  58.598  1.00 12.33           C  
ATOM    314  OG1 THR A  37      30.777  17.984  57.953  1.00 14.88           O  
ATOM    315  CG2 THR A  37      31.994  18.385  59.989  1.00 10.39           C  
ATOM    316  N   VAL A  38      34.977  19.417  58.992  1.00 11.29           N  
ATOM    317  CA  VAL A  38      36.236  19.419  59.729  1.00  8.61           C  
ATOM    318  C   VAL A  38      36.072  19.843  61.171  1.00  8.27           C  
ATOM    319  O   VAL A  38      35.329  20.774  61.476  1.00 10.28           O  
ATOM    320  CB  VAL A  38      37.288  20.358  59.085  1.00  7.04           C  
ATOM    321  CG1 VAL A  38      38.563  20.418  59.962  1.00  4.27           C  
ATOM    322  CG2 VAL A  38      37.656  19.839  57.693  1.00  7.22           C  
ATOM    323  N   SER A  39      36.766  19.135  62.054  1.00  8.34           N  
ATOM    324  CA  SER A  39      36.757  19.466  63.475  1.00 10.43           C  
ATOM    325  C   SER A  39      38.198  19.592  63.944  1.00 11.85           C  
ATOM    326  O   SER A  39      39.049  18.748  63.626  1.00 10.09           O  
ATOM    327  CB  SER A  39      36.056  18.397  64.305  1.00 10.01           C  
ATOM    328  OG  SER A  39      36.132  18.726  65.690  1.00  9.49           O  
ATOM    329  N   LEU A  40      38.467  20.655  64.695  1.00 11.03           N  
ATOM    330  CA  LEU A  40      39.796  20.892  65.205  1.00 10.92           C  
ATOM    331  C   LEU A  40      39.827  20.557  66.682  1.00 10.08           C  
ATOM    332  O   LEU A  40      38.881  20.827  67.410  1.00 12.03           O  
ATOM    333  CB  LEU A  40      40.213  22.352  64.992  1.00 13.22           C  
ATOM    334  CG  LEU A  40      40.258  22.891  63.556  1.00 12.26           C  
ATOM    335  CD1 LEU A  40      41.014  24.232  63.562  1.00 15.45           C  
ATOM    336  CD2 LEU A  40      40.948  21.899  62.622  1.00 14.45           C  
ATOM    337  N   LEU A  41      40.923  19.950  67.109  1.00 10.87           N  
ATOM    338  CA  LEU A  41      41.098  19.580  68.498  1.00  9.03           C  
ATOM    339  C   LEU A  41      42.438  20.127  68.961  1.00 10.32           C  
ATOM    340  O   LEU A  41      43.434  20.053  68.240  1.00 11.19           O  
ATOM    341  CB  LEU A  41      41.050  18.057  68.662  1.00 12.70           C  
ATOM    342  CG  LEU A  41      39.744  17.359  68.258  1.00 10.40           C  
ATOM    343  CD1 LEU A  41      39.733  17.109  66.768  1.00 17.10           C  
ATOM    344  CD2 LEU A  41      39.642  16.049  68.985  1.00 19.31           C  
ATOM    345  N   SER A  42      42.458  20.685  70.162  1.00  9.86           N  
ATOM    346  CA  SER A  42      43.682  21.263  70.699  1.00 10.65           C  
ATOM    347  C   SER A  42      43.715  21.232  72.215  1.00 11.73           C  
ATOM    348  O   SER A  42      42.690  21.020  72.870  1.00 12.80           O  
ATOM    349  CB  SER A  42      43.810  22.716  70.236  1.00 10.77           C  
ATOM    350  OG  SER A  42      44.847  23.383  70.936  1.00 15.60           O  
ATOM    351  N   GLY A  43      44.908  21.447  72.764  1.00 11.03           N  
ATOM    352  CA  GLY A  43      45.062  21.495  74.194  1.00 11.01           C  
ATOM    353  C   GLY A  43      44.906  22.920  74.671  1.00 11.07           C  
ATOM    354  O   GLY A  43      44.867  23.160  75.878  1.00 13.29           O  
ATOM    355  N   ASN A  44      44.811  23.871  73.737  1.00 11.95           N  
ATOM    356  CA  ASN A  44      44.656  25.279  74.116  1.00 12.27           C  
ATOM    357  C   ASN A  44      43.221  25.581  74.554  1.00 11.36           C  
ATOM    358  O   ASN A  44      42.335  24.739  74.410  1.00  9.38           O  
ATOM    359  CB  ASN A  44      45.042  26.209  72.961  1.00 12.55           C  
ATOM    360  CG  ASN A  44      45.836  27.416  73.437  1.00 13.96           C  
ATOM    361  OD1 ASN A  44      45.556  27.975  74.501  1.00 12.67           O  
ATOM    362  ND2 ASN A  44      46.830  27.824  72.652  1.00 12.85           N  
ATOM    363  N   VAL A  45      43.004  26.784  75.085  1.00 10.68           N  
ATOM    364  CA  VAL A  45      41.690  27.184  75.564  1.00 11.68           C  
ATOM    365  C   VAL A  45      40.640  27.422  74.488  1.00 10.28           C  
ATOM    366  O   VAL A  45      40.963  27.739  73.344  1.00 10.77           O  
ATOM    367  CB  VAL A  45      41.789  28.408  76.489  1.00 12.48           C  
ATOM    368  CG1 VAL A  45      42.656  28.060  77.667  1.00 14.90           C  
ATOM    369  CG2 VAL A  45      42.351  29.594  75.748  1.00 13.02           C  
ATOM    370  N   ILE A  46      39.375  27.279  74.865  1.00  8.97           N  
ATOM    371  CA  ILE A  46      38.288  27.413  73.903  1.00  7.96           C  
ATOM    372  C   ILE A  46      38.250  28.746  73.130  1.00  9.09           C  
ATOM    373  O   ILE A  46      37.958  28.758  71.941  1.00  9.29           O  
ATOM    374  CB  ILE A  46      36.908  27.048  74.561  1.00 11.39           C  
ATOM    375  CG1 ILE A  46      35.903  26.697  73.470  1.00  9.29           C  
ATOM    376  CG2 ILE A  46      36.403  28.161  75.472  1.00 13.40           C  
ATOM    377  CD1 ILE A  46      36.315  25.471  72.637  1.00 10.58           C  
ATOM    378  N   PRO A  47      38.536  29.884  73.784  1.00  9.08           N  
ATOM    379  CA  PRO A  47      38.489  31.083  72.944  1.00 10.72           C  
ATOM    380  C   PRO A  47      39.593  31.027  71.871  1.00  7.75           C  
ATOM    381  O   PRO A  47      39.455  31.594  70.804  1.00  7.37           O  
ATOM    382  CB  PRO A  47      38.695  32.220  73.938  1.00 10.21           C  
ATOM    383  CG  PRO A  47      39.383  31.590  75.072  1.00 11.70           C  
ATOM    384  CD  PRO A  47      38.706  30.249  75.194  1.00 10.92           C  
ATOM    385  N   VAL A  48      40.692  30.336  72.153  1.00  8.06           N  
ATOM    386  CA  VAL A  48      41.739  30.254  71.146  1.00  8.58           C  
ATOM    387  C   VAL A  48      41.323  29.376  69.950  1.00 11.12           C  
ATOM    388  O   VAL A  48      41.538  29.745  68.787  1.00  9.21           O  
ATOM    389  CB  VAL A  48      43.054  29.761  71.771  1.00  8.70           C  
ATOM    390  CG1 VAL A  48      44.042  29.385  70.691  1.00  9.55           C  
ATOM    391  CG2 VAL A  48      43.637  30.868  72.652  1.00  6.48           C  
ATOM    392  N   VAL A  49      40.737  28.212  70.215  1.00  9.98           N  
ATOM    393  CA  VAL A  49      40.319  27.366  69.113  1.00 11.32           C  
ATOM    394  C   VAL A  49      39.097  28.008  68.431  1.00 10.54           C  
ATOM    395  O   VAL A  49      38.848  27.787  67.259  1.00 10.12           O  
ATOM    396  CB  VAL A  49      40.009  25.914  69.585  1.00 11.44           C  
ATOM    397  CG1 VAL A  49      38.681  25.841  70.310  1.00 14.71           C  
ATOM    398  CG2 VAL A  49      40.017  24.984  68.389  1.00 14.22           C  
ATOM    399  N   TYR A  50      38.345  28.809  69.178  1.00  8.87           N  
ATOM    400  CA  TYR A  50      37.181  29.494  68.612  1.00 10.83           C  
ATOM    401  C   TYR A  50      37.679  30.456  67.535  1.00  9.62           C  
ATOM    402  O   TYR A  50      37.095  30.577  66.452  1.00 10.82           O  
ATOM    403  CB  TYR A  50      36.449  30.264  69.724  1.00  7.62           C  
ATOM    404  CG  TYR A  50      35.514  31.344  69.238  1.00 10.52           C  
ATOM    405  CD1 TYR A  50      34.281  31.026  68.672  1.00  9.35           C  
ATOM    406  CD2 TYR A  50      35.856  32.691  69.355  1.00  8.90           C  
ATOM    407  CE1 TYR A  50      33.403  32.032  68.235  1.00 11.10           C  
ATOM    408  CE2 TYR A  50      34.985  33.698  68.922  1.00 10.54           C  
ATOM    409  CZ  TYR A  50      33.764  33.357  68.366  1.00  9.09           C  
ATOM    410  OH  TYR A  50      32.902  34.349  67.939  1.00 12.46           O  
ATOM    411  N   ALA A  51      38.777  31.134  67.848  1.00 11.04           N  
ATOM    412  CA  ALA A  51      39.382  32.082  66.942  1.00  8.60           C  
ATOM    413  C   ALA A  51      39.799  31.368  65.671  1.00  9.03           C  
ATOM    414  O   ALA A  51      39.663  31.908  64.588  1.00  9.03           O  
ATOM    415  CB  ALA A  51      40.600  32.745  67.609  1.00  9.69           C  
ATOM    416  N   LEU A  52      40.304  30.141  65.798  1.00  7.85           N  
ATOM    417  CA  LEU A  52      40.721  29.421  64.599  1.00 10.33           C  
ATOM    418  C   LEU A  52      39.500  29.055  63.783  1.00 10.86           C  
ATOM    419  O   LEU A  52      39.531  29.116  62.555  1.00 10.77           O  
ATOM    420  CB  LEU A  52      41.494  28.151  64.948  1.00  9.10           C  
ATOM    421  CG  LEU A  52      42.803  28.406  65.689  1.00  8.60           C  
ATOM    422  CD1 LEU A  52      43.442  27.074  66.039  1.00 11.21           C  
ATOM    423  CD2 LEU A  52      43.730  29.269  64.851  1.00 11.03           C  
ATOM    424  N   LYS A  53      38.417  28.694  64.467  1.00 12.15           N  
ATOM    425  CA  LYS A  53      37.187  28.302  63.775  1.00  9.59           C  
ATOM    426  C   LYS A  53      36.672  29.408  62.865  1.00 10.06           C  
ATOM    427  O   LYS A  53      36.412  29.183  61.674  1.00 11.62           O  
ATOM    428  CB  LYS A  53      36.098  27.905  64.785  1.00  6.61           C  
ATOM    429  CG  LYS A  53      34.726  27.577  64.145  1.00  7.10           C  
ATOM    430  CD  LYS A  53      33.744  26.996  65.157  1.00  4.45           C  
ATOM    431  CE  LYS A  53      32.357  26.815  64.572  1.00  7.47           C  
ATOM    432  NZ  LYS A  53      32.331  25.877  63.377  1.00 10.74           N  
ATOM    433  N   ILE A  54      36.560  30.609  63.415  1.00  9.92           N  
ATOM    434  CA  ILE A  54      36.042  31.748  62.665  1.00 11.60           C  
ATOM    435  C   ILE A  54      37.007  32.340  61.631  1.00 10.45           C  
ATOM    436  O   ILE A  54      36.579  32.752  60.568  1.00  9.98           O  
ATOM    437  CB  ILE A  54      35.548  32.873  63.617  1.00 13.35           C  
ATOM    438  CG1 ILE A  54      36.700  33.403  64.470  1.00 14.95           C  
ATOM    439  CG2 ILE A  54      34.455  32.325  64.555  1.00 13.54           C  
ATOM    440  CD1 ILE A  54      36.264  34.443  65.474  1.00 15.99           C  
ATOM    441  N   PHE A  55      38.300  32.368  61.925  1.00  8.85           N  
ATOM    442  CA  PHE A  55      39.260  32.922  60.974  1.00 11.15           C  
ATOM    443  C   PHE A  55      39.723  31.927  59.904  1.00  9.90           C  
ATOM    444  O   PHE A  55      39.899  32.300  58.742  1.00 12.18           O  
ATOM    445  CB  PHE A  55      40.468  33.509  61.715  1.00 10.32           C  
ATOM    446  CG  PHE A  55      40.179  34.823  62.384  1.00 10.28           C  
ATOM    447  CD1 PHE A  55      39.895  35.955  61.625  1.00 15.21           C  
ATOM    448  CD2 PHE A  55      40.141  34.922  63.772  1.00 13.90           C  
ATOM    449  CE1 PHE A  55      39.573  37.167  62.234  1.00 15.84           C  
ATOM    450  CE2 PHE A  55      39.822  36.123  64.389  1.00 15.20           C  
ATOM    451  CZ  PHE A  55      39.537  37.247  63.622  1.00 17.17           C  
ATOM    452  N   LEU A  56      39.924  30.671  60.288  1.00 11.04           N  
ATOM    453  CA  LEU A  56      40.346  29.667  59.328  1.00 12.37           C  
ATOM    454  C   LEU A  56      39.138  29.214  58.513  1.00 11.44           C  
ATOM    455  O   LEU A  56      39.256  28.914  57.321  1.00 13.84           O  
ATOM    456  CB  LEU A  56      40.992  28.468  60.040  1.00 11.63           C  
ATOM    457  CG  LEU A  56      42.243  28.699  60.895  1.00 12.81           C  
ATOM    458  CD1 LEU A  56      42.857  27.342  61.250  1.00 14.26           C  
ATOM    459  CD2 LEU A  56      43.270  29.537  60.141  1.00 14.42           C  
ATOM    460  N   GLY A  57      37.979  29.179  59.160  1.00 12.10           N  
ATOM    461  CA  GLY A  57      36.742  28.787  58.499  1.00 12.99           C  
ATOM    462  C   GLY A  57      36.434  27.319  58.678  1.00 11.79           C  
ATOM    463  O   GLY A  57      36.227  26.610  57.702  1.00 16.26           O  
ATOM    464  N   ILE A  58      36.404  26.863  59.924  1.00 13.13           N  
ATOM    465  CA  ILE A  58      36.145  25.459  60.237  1.00 11.29           C  
ATOM    466  C   ILE A  58      34.622  25.297  60.316  1.00 11.58           C  
ATOM    467  O   ILE A  58      33.960  26.071  60.991  1.00 12.74           O  
ATOM    468  CB  ILE A  58      36.843  25.099  61.580  1.00 11.28           C  
ATOM    469  CG1 ILE A  58      38.357  25.362  61.468  1.00 11.53           C  
ATOM    470  CG2 ILE A  58      36.530  23.665  61.995  1.00 10.86           C  
ATOM    471  CD1 ILE A  58      39.017  24.925  60.149  1.00 13.02           C  
ATOM    472  N   ASN A  59      34.062  24.324  59.600  1.00 12.74           N  
ATOM    473  CA  ASN A  59      32.607  24.138  59.593  1.00 11.52           C  
ATOM    474  C   ASN A  59      32.093  23.160  60.633  1.00 13.32           C  
ATOM    475  O   ASN A  59      30.883  22.987  60.793  1.00 14.57           O  
ATOM    476  CB  ASN A  59      32.120  23.706  58.208  1.00 13.91           C  
ATOM    477  CG  ASN A  59      32.772  22.425  57.739  1.00 11.41           C  
ATOM    478  OD1 ASN A  59      33.355  21.691  58.535  1.00 11.35           O  
ATOM    479  ND2 ASN A  59      32.668  22.142  56.439  1.00 14.10           N  
ATOM    480  N   GLY A  60      33.002  22.519  61.354  1.00 13.45           N  
ATOM    481  CA  GLY A  60      32.558  21.593  62.376  1.00 13.26           C  
ATOM    482  C   GLY A  60      32.825  22.161  63.752  1.00 13.80           C  
ATOM    483  O   GLY A  60      33.357  23.256  63.882  1.00 15.05           O  
ATOM    484  N   PRO A  61      32.475  21.431  64.813  1.00 14.82           N  
ATOM    485  CA  PRO A  61      32.716  21.940  66.166  1.00 10.22           C  
ATOM    486  C   PRO A  61      34.220  21.941  66.439  1.00  9.14           C  
ATOM    487  O   PRO A  61      34.976  21.261  65.758  1.00 13.57           O  
ATOM    488  CB  PRO A  61      31.995  20.923  67.050  1.00 14.49           C  
ATOM    489  CG  PRO A  61      31.023  20.211  66.094  1.00 13.70           C  
ATOM    490  CD  PRO A  61      31.819  20.113  64.849  1.00 14.84           C  
ATOM    491  N   VAL A  62      34.673  22.715  67.405  1.00 10.34           N  
ATOM    492  CA  VAL A  62      36.097  22.673  67.731  1.00  9.01           C  
ATOM    493  C   VAL A  62      36.238  22.401  69.221  1.00  9.09           C  
ATOM    494  O   VAL A  62      35.374  22.788  70.021  1.00 11.72           O  
ATOM    495  CB  VAL A  62      36.854  23.975  67.341  1.00  7.85           C  
ATOM    496  CG1 VAL A  62      36.968  24.084  65.824  1.00  8.60           C  
ATOM    497  CG2 VAL A  62      36.175  25.168  67.919  1.00  7.46           C  
ATOM    498  N   PHE A  63      37.311  21.706  69.589  1.00  9.67           N  
ATOM    499  CA  PHE A  63      37.563  21.362  70.980  1.00  8.64           C  
ATOM    500  C   PHE A  63      38.854  21.965  71.526  1.00  8.66           C  
ATOM    501  O   PHE A  63      39.857  22.102  70.816  1.00 10.80           O  
ATOM    502  CB  PHE A  63      37.651  19.838  71.172  1.00  7.76           C  
ATOM    503  CG  PHE A  63      36.400  19.080  70.783  1.00  8.79           C  
ATOM    504  CD1 PHE A  63      36.143  18.767  69.456  1.00 10.85           C  
ATOM    505  CD2 PHE A  63      35.511  18.640  71.752  1.00  6.50           C  
ATOM    506  CE1 PHE A  63      35.010  18.016  69.094  1.00 12.06           C  
ATOM    507  CE2 PHE A  63      34.380  17.893  71.404  1.00  9.10           C  
ATOM    508  CZ  PHE A  63      34.133  17.581  70.069  1.00 11.60           C  
ATOM    509  N   GLY A  64      38.812  22.315  72.804  1.00  7.81           N  
ATOM    510  CA  GLY A  64      39.978  22.844  73.475  1.00  9.30           C  
ATOM    511  C   GLY A  64      40.194  21.963  74.692  1.00 10.48           C  
ATOM    512  O   GLY A  64      39.402  21.047  74.958  1.00  8.62           O  
ATOM    513  N   GLU A  65      41.260  22.226  75.431  1.00  9.83           N  
ATOM    514  CA  GLU A  65      41.563  21.462  76.627  1.00  9.19           C  
ATOM    515  C   GLU A  65      41.521  19.960  76.384  1.00  8.82           C  
ATOM    516  O   GLU A  65      41.038  19.187  77.211  1.00  9.15           O  
ATOM    517  CB  GLU A  65      40.607  21.878  77.751  1.00  8.06           C  
ATOM    518  CG  GLU A  65      40.701  23.365  78.086  1.00  7.82           C  
ATOM    519  CD  GLU A  65      39.927  23.748  79.349  1.00  8.89           C  
ATOM    520  OE1 GLU A  65      40.128  23.114  80.398  1.00 11.41           O  
ATOM    521  OE2 GLU A  65      39.119  24.691  79.293  1.00 10.46           O  
ATOM    522  N   ASN A  66      42.047  19.574  75.228  1.00  9.65           N  
ATOM    523  CA  ASN A  66      42.169  18.198  74.780  1.00 12.09           C  
ATOM    524  C   ASN A  66      40.872  17.399  74.641  1.00 10.86           C  
ATOM    525  O   ASN A  66      40.890  16.172  74.683  1.00 11.64           O  
ATOM    526  CB  ASN A  66      43.177  17.463  75.677  1.00 11.89           C  
ATOM    527  CG  ASN A  66      44.586  18.024  75.543  1.00 14.41           C  
ATOM    528  OD1 ASN A  66      45.224  17.916  74.487  1.00 14.28           O  
ATOM    529  ND2 ASN A  66      45.072  18.639  76.604  1.00 15.72           N  
ATOM    530  N   GLY A  67      39.756  18.103  74.455  1.00  8.73           N  
ATOM    531  CA  GLY A  67      38.473  17.429  74.290  1.00 11.43           C  
ATOM    532  C   GLY A  67      37.488  17.671  75.428  1.00 11.42           C  
ATOM    533  O   GLY A  67      36.330  17.237  75.362  1.00 11.58           O  
ATOM    534  N   GLY A  68      37.947  18.371  76.461  1.00  9.16           N  
ATOM    535  CA  GLY A  68      37.111  18.653  77.613  1.00 10.05           C  
ATOM    536  C   GLY A  68      36.121  19.790  77.451  1.00 10.96           C  
ATOM    537  O   GLY A  68      35.193  19.915  78.248  1.00 11.34           O  
ATOM    538  N   ILE A  69      36.314  20.614  76.430  1.00  8.54           N  
ATOM    539  CA  ILE A  69      35.420  21.742  76.172  1.00  8.99           C  
ATOM    540  C   ILE A  69      35.275  21.903  74.673  1.00 10.26           C  
ATOM    541  O   ILE A  69      36.251  21.742  73.923  1.00  8.01           O  
ATOM    542  CB  ILE A  69      35.963  23.030  76.813  1.00 10.52           C  
ATOM    543  CG1 ILE A  69      34.912  24.143  76.730  1.00 11.00           C  
ATOM    544  CG2 ILE A  69      37.260  23.405  76.177  1.00  6.40           C  
ATOM    545  CD1 ILE A  69      35.201  25.339  77.650  1.00 12.80           C  
HETATM  546  N   MSE A  70      34.057  22.224  74.241  1.00  7.50           N  
HETATM  547  CA  MSE A  70      33.768  22.336  72.820  1.00  9.74           C  
HETATM  548  C   MSE A  70      32.932  23.541  72.450  1.00 11.52           C  
HETATM  549  O   MSE A  70      32.081  23.968  73.226  1.00 10.87           O  
HETATM  550  CB  MSE A  70      33.041  21.051  72.383  1.00 11.74           C  
HETATM  551  CG  MSE A  70      32.260  21.116  71.085  1.00 11.41           C  
HETATM  552 SE   MSE A  70      31.156  19.538  70.710  1.00 16.97          SE  
HETATM  553  CE  MSE A  70      29.679  20.155  71.793  1.00 18.57           C  
ATOM    554  N   PHE A  71      33.175  24.084  71.261  1.00  8.13           N  
ATOM    555  CA  PHE A  71      32.381  25.203  70.775  1.00 11.29           C  
ATOM    556  C   PHE A  71      31.530  24.606  69.672  1.00 14.08           C  
ATOM    557  O   PHE A  71      32.059  24.048  68.693  1.00 12.78           O  
ATOM    558  CB  PHE A  71      33.262  26.341  70.254  1.00 12.22           C  
ATOM    559  CG  PHE A  71      32.478  27.508  69.701  1.00 14.97           C  
ATOM    560  CD1 PHE A  71      32.016  27.492  68.389  1.00 15.52           C  
ATOM    561  CD2 PHE A  71      32.201  28.607  70.493  1.00 13.49           C  
ATOM    562  CE1 PHE A  71      31.293  28.559  67.866  1.00 17.36           C  
ATOM    563  CE2 PHE A  71      31.481  29.678  69.987  1.00 17.80           C  
ATOM    564  CZ  PHE A  71      31.024  29.657  68.666  1.00 16.20           C  
ATOM    565  N   ASP A  72      30.217  24.719  69.856  1.00 18.81           N  
ATOM    566  CA  ASP A  72      29.197  24.162  68.968  1.00 25.79           C  
ATOM    567  C   ASP A  72      28.894  24.867  67.652  1.00 27.48           C  
ATOM    568  O   ASP A  72      29.351  25.977  67.392  1.00 27.95           O  
ATOM    569  CB  ASP A  72      27.873  24.035  69.732  1.00 30.51           C  
ATOM    570  CG  ASP A  72      27.373  22.611  69.803  1.00 34.10           C  
ATOM    571  OD1 ASP A  72      27.429  21.914  68.762  1.00 37.01           O  
ATOM    572  OD2 ASP A  72      26.914  22.196  70.889  1.00 37.79           O  
ATOM    573  N   ASN A  73      28.084  24.190  66.842  1.00 30.55           N  
ATOM    574  CA  ASN A  73      27.654  24.688  65.546  1.00 31.50           C  
ATOM    575  C   ASN A  73      26.532  25.713  65.733  1.00 30.56           C  
ATOM    576  O   ASN A  73      26.182  26.440  64.807  1.00 31.21           O  
ATOM    577  CB  ASN A  73      27.147  23.525  64.682  1.00 36.37           C  
ATOM    578  CG  ASN A  73      28.244  22.532  64.317  1.00 38.78           C  
ATOM    579  OD1 ASN A  73      29.161  22.845  63.551  1.00 39.52           O  
ATOM    580  ND2 ASN A  73      28.147  21.320  64.864  1.00 41.04           N  
ATOM    581  N   ASP A  74      25.971  25.752  66.939  1.00 28.29           N  
ATOM    582  CA  ASP A  74      24.893  26.675  67.272  1.00 27.13           C  
ATOM    583  C   ASP A  74      25.467  27.834  68.084  1.00 24.06           C  
ATOM    584  O   ASP A  74      24.737  28.573  68.733  1.00 22.90           O  
ATOM    585  CB  ASP A  74      23.809  25.960  68.083  1.00 27.76           C  
ATOM    586  CG  ASP A  74      24.287  25.558  69.459  1.00 29.34           C  
ATOM    587  OD1 ASP A  74      25.503  25.668  69.709  1.00 31.43           O  
ATOM    588  OD2 ASP A  74      23.461  25.130  70.291  1.00 30.81           O  
ATOM    589  N   GLY A  75      26.791  27.957  68.073  1.00 22.63           N  
ATOM    590  CA  GLY A  75      27.428  29.053  68.779  1.00 20.76           C  
ATOM    591  C   GLY A  75      27.472  28.987  70.288  1.00 18.38           C  
ATOM    592  O   GLY A  75      27.758  29.982  70.932  1.00 20.96           O  
ATOM    593  N   SER A  76      27.211  27.826  70.863  1.00 17.14           N  
ATOM    594  CA  SER A  76      27.252  27.702  72.312  1.00 15.67           C  
ATOM    595  C   SER A  76      28.511  26.950  72.736  1.00 16.30           C  
ATOM    596  O   SER A  76      29.155  26.302  71.914  1.00 15.84           O  
ATOM    597  CB  SER A  76      26.029  26.944  72.807  1.00 16.97           C  
ATOM    598  OG  SER A  76      26.099  25.588  72.411  1.00 18.80           O  
ATOM    599  N   ILE A  77      28.841  27.037  74.023  1.00 13.83           N  
ATOM    600  CA  ILE A  77      29.997  26.359  74.587  1.00 14.50           C  
ATOM    601  C   ILE A  77      29.557  25.357  75.636  1.00 14.04           C  
ATOM    602  O   ILE A  77      28.777  25.666  76.535  1.00 16.85           O  
ATOM    603  CB  ILE A  77      30.986  27.335  75.272  1.00 14.02           C  
ATOM    604  CG1 ILE A  77      31.614  28.267  74.245  1.00 13.00           C  
ATOM    605  CG2 ILE A  77      32.089  26.547  75.966  1.00 14.70           C  
ATOM    606  CD1 ILE A  77      32.420  29.374  74.857  1.00 10.52           C  
ATOM    607  N   LYS A  78      30.079  24.150  75.525  1.00 14.77           N  
ATOM    608  CA  LYS A  78      29.748  23.098  76.463  1.00 14.82           C  
ATOM    609  C   LYS A  78      31.030  22.454  76.943  1.00 14.51           C  
ATOM    610  O   LYS A  78      31.925  22.174  76.146  1.00 13.21           O  
ATOM    611  CB  LYS A  78      28.874  22.038  75.791  1.00 18.57           C  
ATOM    612  CG  LYS A  78      27.530  22.556  75.301  1.00 21.26           C  
ATOM    613  CD  LYS A  78      26.781  21.481  74.536  1.00 29.58           C  
ATOM    614  CE  LYS A  78      25.408  21.968  74.112  1.00 33.17           C  
ATOM    615  NZ  LYS A  78      24.647  20.916  73.382  1.00 37.24           N  
ATOM    616  N   LYS A  79      31.131  22.245  78.249  1.00 13.89           N  
ATOM    617  CA  LYS A  79      32.300  21.574  78.791  1.00 15.47           C  
ATOM    618  C   LYS A  79      31.784  20.281  79.402  1.00 16.41           C  
ATOM    619  O   LYS A  79      30.617  20.183  79.808  1.00 16.03           O  
ATOM    620  CB  LYS A  79      33.030  22.438  79.819  1.00 17.74           C  
ATOM    621  CG  LYS A  79      32.369  22.577  81.158  1.00 20.11           C  
ATOM    622  CD  LYS A  79      33.220  23.476  82.010  1.00 22.48           C  
ATOM    623  CE  LYS A  79      32.807  23.450  83.453  1.00 25.14           C  
ATOM    624  NZ  LYS A  79      33.721  24.326  84.236  1.00 31.79           N  
ATOM    625  N   PHE A  80      32.649  19.282  79.452  1.00 15.93           N  
ATOM    626  CA  PHE A  80      32.264  17.972  79.943  1.00 15.18           C  
ATOM    627  C   PHE A  80      33.011  17.531  81.194  1.00 14.65           C  
ATOM    628  O   PHE A  80      32.781  16.440  81.704  1.00 15.18           O  
ATOM    629  CB  PHE A  80      32.472  16.994  78.788  1.00 15.60           C  
ATOM    630  CG  PHE A  80      31.886  17.490  77.491  1.00 13.13           C  
ATOM    631  CD1 PHE A  80      30.507  17.516  77.309  1.00 15.81           C  
ATOM    632  CD2 PHE A  80      32.708  17.979  76.474  1.00 15.66           C  
ATOM    633  CE1 PHE A  80      29.954  18.027  76.136  1.00 14.75           C  
ATOM    634  CE2 PHE A  80      32.171  18.487  75.298  1.00 13.24           C  
ATOM    635  CZ  PHE A  80      30.794  18.515  75.128  1.00 14.42           C  
ATOM    636  N   PHE A  81      33.900  18.396  81.673  1.00 12.84           N  
ATOM    637  CA  PHE A  81      34.707  18.145  82.868  1.00 13.63           C  
ATOM    638  C   PHE A  81      34.956  19.477  83.564  1.00 14.45           C  
ATOM    639  O   PHE A  81      34.912  20.535  82.923  1.00 13.03           O  
ATOM    640  CB  PHE A  81      36.049  17.503  82.490  1.00 12.17           C  
ATOM    641  CG  PHE A  81      35.915  16.167  81.822  1.00 10.11           C  
ATOM    642  CD1 PHE A  81      35.692  16.075  80.452  1.00 13.95           C  
ATOM    643  CD2 PHE A  81      36.025  14.990  82.565  1.00 12.10           C  
ATOM    644  CE1 PHE A  81      35.577  14.827  79.831  1.00 16.10           C  
ATOM    645  CE2 PHE A  81      35.915  13.742  81.964  1.00 12.18           C  
ATOM    646  CZ  PHE A  81      35.692  13.656  80.587  1.00 15.77           C  
ATOM    647  N   SER A  82      35.241  19.423  84.861  1.00 14.09           N  
ATOM    648  CA  SER A  82      35.464  20.637  85.640  1.00 17.96           C  
ATOM    649  C   SER A  82      36.921  20.781  86.076  1.00 15.15           C  
ATOM    650  O   SER A  82      37.643  19.795  86.210  1.00 15.29           O  
ATOM    651  CB  SER A  82      34.548  20.642  86.858  1.00 19.67           C  
ATOM    652  OG  SER A  82      34.668  21.862  87.570  1.00 29.37           O  
ATOM    653  N   ASN A  83      37.347  22.016  86.301  1.00 12.39           N  
ATOM    654  CA  ASN A  83      38.716  22.249  86.682  1.00 16.11           C  
ATOM    655  C   ASN A  83      38.910  22.519  88.165  1.00 14.25           C  
ATOM    656  O   ASN A  83      40.014  22.827  88.590  1.00 13.90           O  
ATOM    657  CB  ASN A  83      39.315  23.411  85.870  1.00 16.55           C  
ATOM    658  CG  ASN A  83      38.670  24.752  86.183  1.00 15.71           C  
ATOM    659  OD1 ASN A  83      37.772  24.856  87.018  1.00 16.82           O  
ATOM    660  ND2 ASN A  83      39.138  25.793  85.507  1.00 17.39           N  
ATOM    661  N   GLU A  84      37.846  22.386  88.946  0.50 17.04           N  
ATOM    663  CA  GLU A  84      37.934  22.633  90.384  0.50 19.13           C  
ATOM    665  C   GLU A  84      38.999  21.773  91.057  0.50 18.60           C  
ATOM    667  O   GLU A  84      39.753  22.251  91.901  0.50 20.89           O  
ATOM    669  CB  GLU A  84      36.569  22.386  91.043  0.50 22.99           C  
ATOM    671  CG  GLU A  84      35.484  23.368  90.619  0.50 28.13           C  
ATOM    673  CD  GLU A  84      35.891  24.811  90.848  0.50 32.52           C  
ATOM    675  OE1 GLU A  84      36.355  25.123  91.964  0.50 36.17           O  
ATOM    677  OE2 GLU A  84      35.747  25.633  89.918  0.50 36.21           O  
ATOM    679  N   GLY A  85      39.063  20.504  90.664  1.00 17.34           N  
ATOM    680  CA  GLY A  85      40.039  19.592  91.251  1.00 15.58           C  
ATOM    681  C   GLY A  85      41.439  19.754  90.689  1.00 14.16           C  
ATOM    682  O   GLY A  85      42.425  19.805  91.421  1.00 13.22           O  
ATOM    683  N   THR A  86      41.553  19.824  89.368  1.00 13.84           N  
ATOM    684  CA  THR A  86      42.871  20.001  88.802  1.00 13.51           C  
ATOM    685  C   THR A  86      43.476  21.327  89.292  1.00 12.98           C  
ATOM    686  O   THR A  86      44.652  21.380  89.611  1.00 11.42           O  
ATOM    687  CB  THR A  86      42.828  19.963  87.274  1.00 10.13           C  
ATOM    688  OG1 THR A  86      41.842  20.895  86.796  1.00 11.66           O  
ATOM    689  CG2 THR A  86      42.496  18.560  86.798  1.00  9.21           C  
ATOM    690  N   ASN A  87      42.665  22.383  89.387  1.00 14.69           N  
ATOM    691  CA  ASN A  87      43.187  23.662  89.857  1.00 15.11           C  
ATOM    692  C   ASN A  87      43.713  23.560  91.282  1.00 14.40           C  
ATOM    693  O   ASN A  87      44.736  24.157  91.614  1.00 14.29           O  
ATOM    694  CB  ASN A  87      42.125  24.781  89.766  1.00 16.20           C  
ATOM    695  CG  ASN A  87      42.039  25.409  88.369  1.00 17.50           C  
ATOM    696  OD1 ASN A  87      42.917  25.225  87.532  1.00 17.43           O  
ATOM    697  ND2 ASN A  87      40.975  26.164  88.125  1.00 18.67           N  
ATOM    698  N   LYS A  88      43.028  22.786  92.114  1.00 18.02           N  
ATOM    699  CA  LYS A  88      43.429  22.602  93.506  1.00 20.24           C  
ATOM    700  C   LYS A  88      44.730  21.805  93.600  1.00 20.28           C  
ATOM    701  O   LYS A  88      45.566  22.049  94.474  1.00 18.83           O  
ATOM    702  CB  LYS A  88      42.337  21.869  94.287  1.00 22.70           C  
ATOM    703  CG  LYS A  88      42.779  21.433  95.683  1.00 30.59           C  
ATOM    704  CD  LYS A  88      41.699  20.647  96.409  1.00 34.37           C  
ATOM    705  CE  LYS A  88      42.184  20.176  97.777  1.00 37.58           C  
ATOM    706  NZ  LYS A  88      42.660  21.306  98.622  1.00 39.81           N  
ATOM    707  N   PHE A  89      44.885  20.838  92.704  1.00 18.38           N  
ATOM    708  CA  PHE A  89      46.086  20.016  92.681  1.00 18.55           C  
ATOM    709  C   PHE A  89      47.267  20.916  92.353  1.00 17.29           C  
ATOM    710  O   PHE A  89      48.331  20.801  92.951  1.00 18.62           O  
ATOM    711  CB  PHE A  89      45.953  18.921  91.621  1.00 19.52           C  
ATOM    712  CG  PHE A  89      47.133  17.983  91.556  1.00 18.41           C  
ATOM    713  CD1 PHE A  89      47.232  16.902  92.424  1.00 16.01           C  
ATOM    714  CD2 PHE A  89      48.137  18.176  90.615  1.00 17.21           C  
ATOM    715  CE1 PHE A  89      48.319  16.021  92.350  1.00 16.21           C  
ATOM    716  CE2 PHE A  89      49.229  17.301  90.530  1.00 16.23           C  
ATOM    717  CZ  PHE A  89      49.318  16.224  91.399  1.00 16.71           C  
ATOM    718  N   LEU A  90      47.085  21.810  91.389  1.00 17.67           N  
ATOM    719  CA  LEU A  90      48.166  22.719  91.016  1.00 17.40           C  
ATOM    720  C   LEU A  90      48.541  23.635  92.182  1.00 18.01           C  
ATOM    721  O   LEU A  90      49.722  23.820  92.483  1.00 16.28           O  
ATOM    722  CB  LEU A  90      47.778  23.553  89.785  1.00 17.61           C  
ATOM    723  CG  LEU A  90      48.716  24.711  89.419  1.00 17.35           C  
ATOM    724  CD1 LEU A  90      50.155  24.214  89.345  1.00 18.58           C  
ATOM    725  CD2 LEU A  90      48.290  25.323  88.086  1.00 18.37           C  
ATOM    726  N   GLU A  91      47.532  24.191  92.844  1.00 21.08           N  
ATOM    727  CA  GLU A  91      47.759  25.076  93.979  1.00 27.12           C  
ATOM    728  C   GLU A  91      48.650  24.401  95.017  1.00 27.57           C  
ATOM    729  O   GLU A  91      49.614  24.996  95.486  1.00 30.04           O  
ATOM    730  CB  GLU A  91      46.426  25.475  94.612  1.00 30.74           C  
ATOM    731  CG  GLU A  91      46.559  26.367  95.837  1.00 39.20           C  
ATOM    732  CD  GLU A  91      45.213  26.795  96.399  1.00 44.62           C  
ATOM    733  OE1 GLU A  91      44.193  26.164  96.045  1.00 49.25           O  
ATOM    734  OE2 GLU A  91      45.175  27.753  97.206  1.00 49.37           O  
ATOM    735  N   GLU A  92      48.331  23.155  95.357  1.00 29.59           N  
ATOM    736  CA  GLU A  92      49.100  22.387  96.343  1.00 30.49           C  
ATOM    737  C   GLU A  92      50.513  22.024  95.886  1.00 27.78           C  
ATOM    738  O   GLU A  92      51.492  22.321  96.570  1.00 26.60           O  
ATOM    739  CB  GLU A  92      48.365  21.094  96.697  1.00 35.91           C  
ATOM    740  CG  GLU A  92      46.990  21.296  97.293  1.00 43.48           C  
ATOM    741  CD  GLU A  92      46.322  19.983  97.659  1.00 48.65           C  
ATOM    742  OE1 GLU A  92      46.933  18.915  97.425  1.00 52.64           O  
ATOM    743  OE2 GLU A  92      45.185  20.020  98.179  1.00 53.22           O  
HETATM  744  N   MSE A  93      50.611  21.364  94.736  1.00 24.33           N  
HETATM  745  CA  MSE A  93      51.899  20.947  94.206  1.00 23.50           C  
HETATM  746  C   MSE A  93      52.863  22.098  94.018  1.00 22.55           C  
HETATM  747  O   MSE A  93      54.061  21.932  94.210  1.00 23.57           O  
HETATM  748  CB  MSE A  93      51.731  20.236  92.864  1.00 24.11           C  
HETATM  749  CG  MSE A  93      51.252  18.809  92.953  1.00 25.06           C  
HETATM  750 SE   MSE A  93      52.422  17.677  94.011  1.00 26.45          SE  
HETATM  751  CE  MSE A  93      51.342  17.712  95.590  1.00 27.36           C  
ATOM    752  N   SER A  94      52.351  23.262  93.632  1.00 21.47           N  
ATOM    753  CA  SER A  94      53.226  24.407  93.402  1.00 23.50           C  
ATOM    754  C   SER A  94      53.883  24.864  94.686  1.00 24.79           C  
ATOM    755  O   SER A  94      54.792  25.691  94.666  1.00 25.18           O  
ATOM    756  CB  SER A  94      52.448  25.574  92.792  1.00 22.57           C  
ATOM    757  OG  SER A  94      51.509  26.079  93.720  1.00 24.66           O  
ATOM    758  N   LYS A  95      53.414  24.335  95.811  1.00 27.08           N  
ATOM    759  CA  LYS A  95      53.981  24.709  97.091  1.00 29.27           C  
ATOM    760  C   LYS A  95      55.273  23.954  97.372  1.00 28.71           C  
ATOM    761  O   LYS A  95      56.118  24.435  98.124  1.00 31.70           O  
ATOM    762  CB  LYS A  95      52.968  24.462  98.211  1.00 33.30           C  
ATOM    763  CG  LYS A  95      51.678  25.257  98.056  1.00 37.80           C  
ATOM    764  CD  LYS A  95      51.961  26.748  97.899  1.00 41.98           C  
ATOM    765  CE  LYS A  95      50.690  27.533  97.592  1.00 44.71           C  
ATOM    766  NZ  LYS A  95      49.674  27.416  98.677  1.00 45.85           N  
ATOM    767  N   ARG A  96      55.445  22.785  96.764  1.00 27.25           N  
ATOM    768  CA  ARG A  96      56.659  22.018  97.004  1.00 25.51           C  
ATOM    769  C   ARG A  96      57.325  21.430  95.767  1.00 24.00           C  
ATOM    770  O   ARG A  96      58.071  20.454  95.865  1.00 24.58           O  
ATOM    771  CB  ARG A  96      56.375  20.907  98.008  1.00 26.09           C  
ATOM    772  CG  ARG A  96      55.338  19.899  97.569  1.00 28.07           C  
ATOM    773  CD  ARG A  96      55.216  18.829  98.633  1.00 31.42           C  
ATOM    774  NE  ARG A  96      54.599  17.596  98.156  1.00 31.44           N  
ATOM    775  CZ  ARG A  96      53.306  17.446  97.907  1.00 31.99           C  
ATOM    776  NH1 ARG A  96      52.473  18.460  98.082  1.00 33.83           N  
ATOM    777  NH2 ARG A  96      52.844  16.268  97.503  1.00 32.00           N  
ATOM    778  N   THR A  97      57.061  22.020  94.606  1.00 19.85           N  
ATOM    779  CA  THR A  97      57.653  21.551  93.349  1.00 17.74           C  
ATOM    780  C   THR A  97      57.751  22.723  92.408  1.00 16.02           C  
ATOM    781  O   THR A  97      57.305  23.821  92.727  1.00 17.56           O  
ATOM    782  CB  THR A  97      56.794  20.469  92.616  1.00 17.04           C  
ATOM    783  OG1 THR A  97      55.636  21.081  92.028  1.00 12.90           O  
ATOM    784  CG2 THR A  97      56.363  19.370  93.568  1.00 17.62           C  
ATOM    785  N   SER A  98      58.330  22.491  91.239  1.00 15.48           N  
ATOM    786  CA  SER A  98      58.438  23.544  90.246  1.00 13.96           C  
ATOM    787  C   SER A  98      57.124  23.685  89.468  1.00 12.55           C  
ATOM    788  O   SER A  98      56.990  24.586  88.644  1.00 15.37           O  
ATOM    789  CB  SER A  98      59.567  23.233  89.254  1.00 15.50           C  
ATOM    790  OG  SER A  98      59.341  22.011  88.576  1.00 12.19           O  
HETATM  791  N   MSE A  99      56.159  22.806  89.717  1.00 11.89           N  
HETATM  792  CA  MSE A  99      54.908  22.879  88.958  1.00 11.92           C  
HETATM  793  C   MSE A  99      54.317  24.266  89.066  1.00 12.34           C  
HETATM  794  O   MSE A  99      54.091  24.755  90.181  1.00 12.07           O  
HETATM  795  CB  MSE A  99      53.893  21.858  89.447  1.00 13.26           C  
HETATM  796  CG  MSE A  99      52.596  21.885  88.644  1.00 14.03           C  
HETATM  797 SE   MSE A  99      51.377  20.561  89.325  1.00 22.09          SE  
HETATM  798  CE  MSE A  99      50.621  19.886  87.675  1.00 20.41           C  
ATOM    799  N   ARG A 100      54.063  24.888  87.909  1.00 11.92           N  
ATOM    800  CA  ARG A 100      53.521  26.246  87.871  1.00 15.00           C  
ATOM    801  C   ARG A 100      52.386  26.515  86.904  1.00 12.53           C  
ATOM    802  O   ARG A 100      52.290  25.893  85.835  1.00 11.30           O  
ATOM    803  CB  ARG A 100      54.639  27.249  87.570  1.00 18.81           C  
ATOM    804  CG  ARG A 100      55.665  27.411  88.672  1.00 25.09           C  
ATOM    805  CD  ARG A 100      55.071  28.057  89.916  1.00 29.58           C  
ATOM    806  NE  ARG A 100      56.065  28.178  90.981  1.00 33.91           N  
ATOM    807  CZ  ARG A 100      56.607  27.145  91.617  1.00 34.71           C  
ATOM    808  NH1 ARG A 100      56.249  25.909  91.300  1.00 31.21           N  
ATOM    809  NH2 ARG A 100      57.517  27.346  92.563  1.00 36.61           N  
ATOM    810  N   SER A 101      51.556  27.488  87.277  1.00 12.17           N  
ATOM    811  CA  SER A 101      50.417  27.919  86.467  1.00 11.51           C  
ATOM    812  C   SER A 101      50.904  28.695  85.232  1.00 12.94           C  
ATOM    813  O   SER A 101      52.023  29.222  85.222  1.00 11.92           O  
ATOM    814  CB  SER A 101      49.503  28.825  87.296  1.00 12.32           C  
ATOM    815  OG  SER A 101      48.336  29.176  86.572  1.00 14.48           O  
ATOM    816  N   ILE A 102      50.070  28.753  84.193  1.00 10.49           N  
ATOM    817  CA  ILE A 102      50.416  29.484  82.977  1.00 10.09           C  
ATOM    818  C   ILE A 102      49.309  30.501  82.712  1.00 10.29           C  
ATOM    819  O   ILE A 102      48.192  30.344  83.197  1.00 10.32           O  
ATOM    820  CB  ILE A 102      50.559  28.568  81.728  1.00  6.81           C  
ATOM    821  CG1 ILE A 102      49.276  27.761  81.508  1.00  7.84           C  
ATOM    822  CG2 ILE A 102      51.775  27.636  81.870  1.00  7.20           C  
ATOM    823  CD1 ILE A 102      49.352  26.817  80.321  1.00 11.46           C  
ATOM    824  N   LEU A 103      49.633  31.533  81.938  1.00 10.50           N  
ATOM    825  CA  LEU A 103      48.696  32.602  81.603  1.00 12.13           C  
ATOM    826  C   LEU A 103      47.329  32.105  81.129  1.00 13.52           C  
ATOM    827  O   LEU A 103      46.304  32.464  81.699  1.00 12.51           O  
ATOM    828  CB  LEU A 103      49.308  33.494  80.522  1.00 16.60           C  
ATOM    829  CG  LEU A 103      48.483  34.696  80.048  1.00 20.28           C  
ATOM    830  CD1 LEU A 103      48.341  35.695  81.178  1.00 20.27           C  
ATOM    831  CD2 LEU A 103      49.176  35.344  78.855  1.00 23.90           C  
ATOM    832  N   THR A 104      47.319  31.267  80.091  1.00 10.77           N  
ATOM    833  CA  THR A 104      46.075  30.754  79.536  1.00  9.40           C  
ATOM    834  C   THR A 104      45.155  30.017  80.502  1.00 10.43           C  
ATOM    835  O   THR A 104      44.038  29.676  80.140  1.00 12.39           O  
ATOM    836  CB  THR A 104      46.345  29.839  78.318  1.00 12.40           C  
ATOM    837  OG1 THR A 104      47.263  28.808  78.694  1.00 10.04           O  
ATOM    838  CG2 THR A 104      46.922  30.656  77.177  1.00 10.09           C  
ATOM    839  N   ASN A 105      45.588  29.786  81.732  1.00 10.01           N  
ATOM    840  CA  ASN A 105      44.702  29.110  82.665  1.00  8.96           C  
ATOM    841  C   ASN A 105      43.497  29.992  82.992  1.00  8.28           C  
ATOM    842  O   ASN A 105      42.448  29.502  83.423  1.00 10.04           O  
ATOM    843  CB  ASN A 105      45.454  28.719  83.938  1.00 10.01           C  
ATOM    844  CG  ASN A 105      46.188  27.398  83.795  1.00  7.82           C  
ATOM    845  OD1 ASN A 105      46.020  26.675  82.799  1.00 11.36           O  
ATOM    846  ND2 ASN A 105      47.005  27.070  84.792  1.00 12.22           N  
ATOM    847  N   ARG A 106      43.639  31.295  82.779  1.00  8.58           N  
ATOM    848  CA  ARG A 106      42.546  32.210  83.058  1.00  9.04           C  
ATOM    849  C   ARG A 106      41.343  31.953  82.152  1.00  9.91           C  
ATOM    850  O   ARG A 106      40.248  32.403  82.441  1.00  9.61           O  
ATOM    851  CB  ARG A 106      43.020  33.658  82.911  1.00  9.62           C  
ATOM    852  CG  ARG A 106      43.591  34.002  81.554  1.00  7.30           C  
ATOM    853  CD  ARG A 106      44.181  35.404  81.576  1.00 14.42           C  
ATOM    854  NE  ARG A 106      43.136  36.396  81.775  1.00 19.79           N  
ATOM    855  CZ  ARG A 106      43.349  37.704  81.828  1.00 23.56           C  
ATOM    856  NH1 ARG A 106      44.586  38.178  81.704  1.00 25.80           N  
ATOM    857  NH2 ARG A 106      42.326  38.533  81.980  1.00 22.40           N  
ATOM    858  N   TRP A 107      41.555  31.248  81.041  1.00 11.56           N  
ATOM    859  CA  TRP A 107      40.464  30.930  80.119  1.00 11.02           C  
ATOM    860  C   TRP A 107      40.122  29.429  80.111  1.00 11.18           C  
ATOM    861  O   TRP A 107      39.296  28.980  79.313  1.00 12.30           O  
ATOM    862  CB  TRP A 107      40.813  31.388  78.702  1.00  8.42           C  
ATOM    863  CG  TRP A 107      41.101  32.860  78.631  1.00 10.83           C  
ATOM    864  CD1 TRP A 107      40.304  33.870  79.077  1.00 10.69           C  
ATOM    865  CD2 TRP A 107      42.274  33.485  78.080  1.00  9.85           C  
ATOM    866  NE1 TRP A 107      40.905  35.092  78.839  1.00  8.62           N  
ATOM    867  CE2 TRP A 107      42.113  34.879  78.226  1.00  9.20           C  
ATOM    868  CE3 TRP A 107      43.446  32.995  77.476  1.00 11.03           C  
ATOM    869  CZ2 TRP A 107      43.082  35.799  77.789  1.00  6.92           C  
ATOM    870  CZ3 TRP A 107      44.412  33.909  77.038  1.00  9.91           C  
ATOM    871  CH2 TRP A 107      44.218  35.294  77.200  1.00  9.48           C  
ATOM    872  N   ARG A 108      40.764  28.657  80.984  1.00 10.68           N  
ATOM    873  CA  ARG A 108      40.469  27.226  81.068  1.00 10.99           C  
ATOM    874  C   ARG A 108      39.251  27.018  81.945  1.00 10.27           C  
ATOM    875  O   ARG A 108      38.998  27.798  82.856  1.00  9.51           O  
ATOM    876  CB  ARG A 108      41.667  26.425  81.618  1.00 10.90           C  
ATOM    877  CG  ARG A 108      42.692  26.087  80.533  1.00 12.57           C  
ATOM    878  CD  ARG A 108      43.607  24.904  80.858  1.00 13.19           C  
ATOM    879  NE  ARG A 108      44.401  24.610  79.671  1.00 12.76           N  
ATOM    880  CZ  ARG A 108      45.357  25.404  79.198  1.00 12.65           C  
ATOM    881  NH1 ARG A 108      45.681  26.533  79.829  1.00 10.51           N  
ATOM    882  NH2 ARG A 108      45.911  25.128  78.024  1.00 10.66           N  
ATOM    883  N   GLU A 109      38.488  25.974  81.649  1.00 11.22           N  
ATOM    884  CA  GLU A 109      37.286  25.663  82.407  1.00 12.26           C  
ATOM    885  C   GLU A 109      37.176  24.185  82.778  1.00 13.51           C  
ATOM    886  O   GLU A 109      36.478  23.818  83.741  1.00 12.41           O  
ATOM    887  CB  GLU A 109      36.045  26.061  81.595  1.00 14.71           C  
ATOM    888  CG  GLU A 109      35.772  27.556  81.509  1.00 18.42           C  
ATOM    889  CD  GLU A 109      34.585  27.872  80.604  1.00 22.79           C  
ATOM    890  OE1 GLU A 109      33.464  27.382  80.876  1.00 24.46           O  
ATOM    891  OE2 GLU A 109      34.772  28.606  79.610  1.00 27.10           O  
ATOM    892  N   ALA A 110      37.868  23.331  82.033  1.00 11.73           N  
ATOM    893  CA  ALA A 110      37.759  21.896  82.276  1.00 11.02           C  
ATOM    894  C   ALA A 110      39.031  21.131  82.625  1.00 10.15           C  
ATOM    895  O   ALA A 110      38.992  19.900  82.768  1.00 12.73           O  
ATOM    896  CB  ALA A 110      37.098  21.248  81.079  1.00 11.61           C  
ATOM    897  N   SER A 111      40.137  21.845  82.787  1.00  9.78           N  
ATOM    898  CA  SER A 111      41.426  21.218  83.102  1.00 10.55           C  
ATOM    899  C   SER A 111      42.393  22.312  83.496  1.00 10.11           C  
ATOM    900  O   SER A 111      42.010  23.482  83.520  1.00 12.10           O  
ATOM    901  CB  SER A 111      41.965  20.524  81.865  1.00 11.54           C  
ATOM    902  OG  SER A 111      42.212  21.509  80.875  1.00 10.77           O  
ATOM    903  N   THR A 112      43.649  21.939  83.763  1.00  9.64           N  
ATOM    904  CA  THR A 112      44.678  22.901  84.165  1.00 10.51           C  
ATOM    905  C   THR A 112      46.007  22.712  83.438  1.00  9.46           C  
ATOM    906  O   THR A 112      46.598  21.624  83.450  1.00 12.10           O  
ATOM    907  CB  THR A 112      44.940  22.821  85.675  1.00  8.27           C  
ATOM    908  OG1 THR A 112      43.692  22.787  86.358  1.00  5.96           O  
ATOM    909  CG2 THR A 112      45.694  24.044  86.174  1.00  8.86           C  
ATOM    910  N   GLY A 113      46.458  23.779  82.790  1.00 11.45           N  
ATOM    911  CA  GLY A 113      47.719  23.751  82.076  1.00 11.50           C  
ATOM    912  C   GLY A 113      48.846  24.142  83.014  1.00  9.07           C  
ATOM    913  O   GLY A 113      48.615  24.819  84.014  1.00 11.36           O  
ATOM    914  N   PHE A 114      50.068  23.718  82.723  1.00 10.15           N  
ATOM    915  CA  PHE A 114      51.162  24.071  83.614  1.00 11.14           C  
ATOM    916  C   PHE A 114      52.550  23.875  83.036  1.00  9.48           C  
ATOM    917  O   PHE A 114      52.723  23.189  82.032  1.00 11.61           O  
ATOM    918  CB  PHE A 114      51.058  23.264  84.930  1.00 10.81           C  
ATOM    919  CG  PHE A 114      51.293  21.766  84.764  1.00  9.91           C  
ATOM    920  CD1 PHE A 114      50.274  20.930  84.314  1.00  8.80           C  
ATOM    921  CD2 PHE A 114      52.537  21.204  85.061  1.00  9.11           C  
ATOM    922  CE1 PHE A 114      50.486  19.561  84.163  1.00 10.11           C  
ATOM    923  CE2 PHE A 114      52.761  19.844  84.917  1.00  7.87           C  
ATOM    924  CZ  PHE A 114      51.736  19.015  84.468  1.00  8.75           C  
ATOM    925  N   ASP A 115      53.522  24.535  83.659  1.00 10.07           N  
ATOM    926  CA  ASP A 115      54.932  24.382  83.308  1.00 10.34           C  
ATOM    927  C   ASP A 115      55.530  23.645  84.502  1.00 12.39           C  
ATOM    928  O   ASP A 115      55.077  23.819  85.645  1.00 11.89           O  
ATOM    929  CB  ASP A 115      55.666  25.721  83.177  1.00 11.41           C  
ATOM    930  CG  ASP A 115      55.161  26.562  82.038  1.00 15.28           C  
ATOM    931  OD1 ASP A 115      54.698  25.981  81.043  1.00 13.26           O  
ATOM    932  OD2 ASP A 115      55.255  27.812  82.139  1.00 15.41           O  
ATOM    933  N   ILE A 116      56.567  22.855  84.251  1.00 13.49           N  
ATOM    934  CA  ILE A 116      57.215  22.100  85.313  1.00 13.76           C  
ATOM    935  C   ILE A 116      58.650  21.747  84.909  1.00 15.57           C  
ATOM    936  O   ILE A 116      58.932  21.537  83.727  1.00 16.22           O  
ATOM    937  CB  ILE A 116      56.414  20.801  85.611  1.00 11.56           C  
ATOM    938  CG1 ILE A 116      56.952  20.115  86.867  1.00 12.19           C  
ATOM    939  CG2 ILE A 116      56.516  19.837  84.455  1.00 10.62           C  
ATOM    940  CD1 ILE A 116      56.059  18.980  87.330  1.00 15.06           C  
ATOM    941  N   ASP A 117      59.557  21.721  85.880  1.00 14.94           N  
ATOM    942  CA  ASP A 117      60.941  21.350  85.612  1.00 18.04           C  
ATOM    943  C   ASP A 117      60.924  19.845  85.318  1.00 18.14           C  
ATOM    944  O   ASP A 117      60.218  19.084  85.985  1.00 17.64           O  
ATOM    945  CB  ASP A 117      61.820  21.644  86.825  1.00 24.49           C  
ATOM    946  CG  ASP A 117      62.021  23.131  87.053  1.00 30.17           C  
ATOM    947  OD1 ASP A 117      61.353  23.944  86.375  1.00 34.03           O  
ATOM    948  OD2 ASP A 117      62.849  23.492  87.918  1.00 34.91           O  
ATOM    949  N   PRO A 118      61.687  19.402  84.305  1.00 18.13           N  
ATOM    950  CA  PRO A 118      61.736  17.988  83.940  1.00 19.13           C  
ATOM    951  C   PRO A 118      61.982  17.053  85.117  1.00 19.05           C  
ATOM    952  O   PRO A 118      61.466  15.945  85.146  1.00 20.32           O  
ATOM    953  CB  PRO A 118      62.855  17.937  82.910  1.00 21.38           C  
ATOM    954  CG  PRO A 118      62.735  19.283  82.236  1.00 16.71           C  
ATOM    955  CD  PRO A 118      62.559  20.198  83.422  1.00 18.25           C  
ATOM    956  N   GLU A 119      62.745  17.516  86.098  1.00 19.36           N  
ATOM    957  CA  GLU A 119      63.055  16.681  87.245  1.00 19.38           C  
ATOM    958  C   GLU A 119      61.847  16.343  88.105  1.00 18.29           C  
ATOM    959  O   GLU A 119      61.823  15.297  88.738  1.00 18.92           O  
ATOM    960  CB  GLU A 119      64.097  17.352  88.136  1.00 21.80           C  
ATOM    961  CG  GLU A 119      65.249  17.961  87.399  1.00 27.13           C  
ATOM    962  CD  GLU A 119      65.071  19.451  87.182  1.00 30.25           C  
ATOM    963  OE1 GLU A 119      64.165  19.865  86.425  1.00 29.08           O  
ATOM    964  OE2 GLU A 119      65.847  20.210  87.787  1.00 32.57           O  
ATOM    965  N   ASP A 120      60.857  17.228  88.143  1.00 16.42           N  
ATOM    966  CA  ASP A 120      59.680  16.987  88.973  1.00 16.80           C  
ATOM    967  C   ASP A 120      58.560  16.240  88.276  1.00 14.94           C  
ATOM    968  O   ASP A 120      57.544  15.951  88.879  1.00 18.70           O  
ATOM    969  CB  ASP A 120      59.124  18.300  89.507  1.00 15.96           C  
ATOM    970  CG  ASP A 120      60.092  19.012  90.411  1.00 16.10           C  
ATOM    971  OD1 ASP A 120      60.875  18.311  91.084  1.00 19.36           O  
ATOM    972  OD2 ASP A 120      60.062  20.260  90.459  1.00 12.97           O  
ATOM    973  N   VAL A 121      58.736  15.924  87.006  1.00 14.74           N  
ATOM    974  CA  VAL A 121      57.694  15.229  86.271  1.00 12.57           C  
ATOM    975  C   VAL A 121      57.270  13.881  86.849  1.00 12.73           C  
ATOM    976  O   VAL A 121      56.077  13.624  87.019  1.00 10.98           O  
ATOM    977  CB  VAL A 121      58.113  15.037  84.818  1.00 11.56           C  
ATOM    978  CG1 VAL A 121      57.104  14.177  84.094  1.00 12.06           C  
ATOM    979  CG2 VAL A 121      58.250  16.399  84.149  1.00 10.79           C  
ATOM    980  N   ASP A 122      58.231  13.010  87.143  1.00 13.26           N  
ATOM    981  CA  ASP A 122      57.873  11.700  87.678  1.00 14.80           C  
ATOM    982  C   ASP A 122      57.044  11.781  88.957  1.00 14.51           C  
ATOM    983  O   ASP A 122      56.042  11.078  89.093  1.00 16.55           O  
ATOM    984  CB  ASP A 122      59.128  10.839  87.899  1.00 15.05           C  
ATOM    985  CG  ASP A 122      59.792  10.441  86.589  1.00 17.05           C  
ATOM    986  OD1 ASP A 122      59.082  10.419  85.571  1.00 17.12           O  
ATOM    987  OD2 ASP A 122      61.007  10.141  86.567  1.00 15.23           O  
ATOM    988  N   TYR A 123      57.446  12.640  89.884  1.00 14.30           N  
ATOM    989  CA  TYR A 123      56.733  12.800  91.146  1.00 13.83           C  
ATOM    990  C   TYR A 123      55.319  13.356  90.949  1.00 13.57           C  
ATOM    991  O   TYR A 123      54.344  12.816  91.476  1.00 15.35           O  
ATOM    992  CB  TYR A 123      57.509  13.738  92.068  1.00 16.36           C  
ATOM    993  CG  TYR A 123      56.809  14.036  93.377  1.00 20.63           C  
ATOM    994  CD1 TYR A 123      56.637  13.043  94.339  1.00 21.05           C  
ATOM    995  CD2 TYR A 123      56.331  15.316  93.660  1.00 20.65           C  
ATOM    996  CE1 TYR A 123      56.012  13.315  95.550  1.00 23.10           C  
ATOM    997  CE2 TYR A 123      55.697  15.596  94.872  1.00 22.08           C  
ATOM    998  CZ  TYR A 123      55.546  14.588  95.809  1.00 22.39           C  
ATOM    999  OH  TYR A 123      54.928  14.847  97.005  1.00 25.27           O  
ATOM   1000  N   VAL A 124      55.207  14.438  90.196  1.00 13.01           N  
ATOM   1001  CA  VAL A 124      53.892  15.041  89.974  1.00 12.31           C  
ATOM   1002  C   VAL A 124      52.956  14.069  89.250  1.00 12.36           C  
ATOM   1003  O   VAL A 124      51.762  14.014  89.542  1.00 13.00           O  
ATOM   1004  CB  VAL A 124      54.027  16.395  89.221  1.00  9.93           C  
ATOM   1005  CG1 VAL A 124      52.705  16.859  88.685  1.00 10.48           C  
ATOM   1006  CG2 VAL A 124      54.560  17.449  90.174  1.00 11.24           C  
ATOM   1007  N   ARG A 125      53.491  13.273  88.333  1.00 13.47           N  
ATOM   1008  CA  ARG A 125      52.634  12.327  87.621  1.00 15.17           C  
ATOM   1009  C   ARG A 125      52.013  11.294  88.574  1.00 13.46           C  
ATOM   1010  O   ARG A 125      50.840  10.932  88.425  1.00 15.63           O  
ATOM   1011  CB  ARG A 125      53.403  11.604  86.522  1.00 13.09           C  
ATOM   1012  CG  ARG A 125      52.559  10.536  85.835  1.00 14.88           C  
ATOM   1013  CD  ARG A 125      53.202  10.065  84.550  1.00 14.57           C  
ATOM   1014  NE  ARG A 125      52.979  10.998  83.451  1.00 19.95           N  
ATOM   1015  CZ  ARG A 125      53.901  11.314  82.553  1.00 17.43           C  
ATOM   1016  NH1 ARG A 125      55.099  10.773  82.638  1.00 19.09           N  
ATOM   1017  NH2 ARG A 125      53.630  12.163  81.582  1.00 19.60           N  
ATOM   1018  N   LYS A 126      52.801  10.817  89.531  1.00 16.05           N  
ATOM   1019  CA  LYS A 126      52.334   9.841  90.518  1.00 18.33           C  
ATOM   1020  C   LYS A 126      51.288  10.473  91.431  1.00 18.98           C  
ATOM   1021  O   LYS A 126      50.295   9.844  91.794  1.00 20.84           O  
ATOM   1022  CB  LYS A 126      53.503   9.335  91.366  1.00 22.71           C  
ATOM   1023  CG  LYS A 126      54.541   8.539  90.595  1.00 30.10           C  
ATOM   1024  CD  LYS A 126      55.609   7.978  91.532  1.00 35.17           C  
ATOM   1025  CE  LYS A 126      56.621   7.118  90.778  1.00 40.45           C  
ATOM   1026  NZ  LYS A 126      57.606   6.481  91.703  1.00 42.09           N  
ATOM   1027  N   GLU A 127      51.523  11.712  91.832  1.00 18.28           N  
ATOM   1028  CA  GLU A 127      50.558  12.394  92.676  1.00 16.91           C  
ATOM   1029  C   GLU A 127      49.284  12.616  91.851  1.00 15.80           C  
ATOM   1030  O   GLU A 127      48.179  12.362  92.315  1.00 15.58           O  
ATOM   1031  CB  GLU A 127      51.132  13.723  93.170  1.00 17.51           C  
ATOM   1032  CG  GLU A 127      52.246  13.553  94.197  1.00 22.11           C  
ATOM   1033  CD  GLU A 127      51.801  12.764  95.422  1.00 23.24           C  
ATOM   1034  OE1 GLU A 127      52.551  11.878  95.860  1.00 25.76           O  
ATOM   1035  OE2 GLU A 127      50.707  13.024  95.955  1.00 24.95           O  
ATOM   1036  N   ALA A 128      49.450  13.053  90.610  1.00 15.16           N  
ATOM   1037  CA  ALA A 128      48.315  13.292  89.727  1.00 15.80           C  
ATOM   1038  C   ALA A 128      47.462  12.031  89.539  1.00 14.50           C  
ATOM   1039  O   ALA A 128      46.251  12.063  89.716  1.00 17.01           O  
ATOM   1040  CB  ALA A 128      48.812  13.805  88.361  1.00 12.95           C  
ATOM   1041  N   GLU A 129      48.087  10.914  89.191  1.00 13.44           N  
ATOM   1042  CA  GLU A 129      47.320   9.689  88.976  1.00 13.34           C  
ATOM   1043  C   GLU A 129      46.643   9.180  90.263  1.00 14.30           C  
ATOM   1044  O   GLU A 129      45.540   8.640  90.219  1.00 12.88           O  
ATOM   1045  CB  GLU A 129      48.210   8.605  88.355  1.00 12.98           C  
ATOM   1046  CG  GLU A 129      48.961   9.102  87.149  1.00 17.09           C  
ATOM   1047  CD  GLU A 129      49.503   8.000  86.251  1.00 15.80           C  
ATOM   1048  OE1 GLU A 129      49.835   6.894  86.748  1.00 18.72           O  
ATOM   1049  OE2 GLU A 129      49.611   8.256  85.035  1.00 16.95           O  
ATOM   1050  N   SER A 130      47.298   9.345  91.404  1.00 15.13           N  
ATOM   1051  CA  SER A 130      46.691   8.900  92.654  1.00 19.18           C  
ATOM   1052  C   SER A 130      45.440   9.732  92.911  1.00 18.49           C  
ATOM   1053  O   SER A 130      44.640   9.411  93.787  1.00 20.56           O  
ATOM   1054  CB  SER A 130      47.656   9.087  93.823  1.00 18.03           C  
ATOM   1055  OG  SER A 130      47.794  10.457  94.129  1.00 20.28           O  
ATOM   1056  N   ARG A 131      45.275  10.805  92.142  1.00 18.02           N  
ATOM   1057  CA  ARG A 131      44.131  11.689  92.306  1.00 18.86           C  
ATOM   1058  C   ARG A 131      43.116  11.544  91.175  1.00 17.63           C  
ATOM   1059  O   ARG A 131      42.172  12.313  91.078  1.00 16.92           O  
ATOM   1060  CB  ARG A 131      44.616  13.136  92.394  1.00 26.88           C  
ATOM   1061  CG  ARG A 131      45.604  13.372  93.525  1.00 31.74           C  
ATOM   1062  CD  ARG A 131      44.907  13.704  94.832  1.00 39.95           C  
ATOM   1063  NE  ARG A 131      44.715  15.144  94.989  1.00 46.91           N  
ATOM   1064  CZ  ARG A 131      45.703  16.010  95.208  1.00 49.65           C  
ATOM   1065  NH1 ARG A 131      46.957  15.584  95.300  1.00 51.01           N  
ATOM   1066  NH2 ARG A 131      45.438  17.307  95.328  1.00 50.53           N  
ATOM   1067  N   GLY A 132      43.302  10.545  90.325  1.00 16.87           N  
ATOM   1068  CA  GLY A 132      42.374  10.364  89.229  1.00 16.45           C  
ATOM   1069  C   GLY A 132      42.634  11.305  88.067  1.00 13.70           C  
ATOM   1070  O   GLY A 132      41.765  11.501  87.215  1.00 15.49           O  
ATOM   1071  N   PHE A 133      43.828  11.896  88.035  1.00 11.66           N  
ATOM   1072  CA  PHE A 133      44.210  12.799  86.946  1.00 11.40           C  
ATOM   1073  C   PHE A 133      45.361  12.178  86.187  1.00 11.20           C  
ATOM   1074  O   PHE A 133      45.948  11.199  86.640  1.00 10.17           O  
ATOM   1075  CB  PHE A 133      44.677  14.157  87.479  1.00  8.65           C  
ATOM   1076  CG  PHE A 133      43.700  14.826  88.423  1.00 10.14           C  
ATOM   1077  CD1 PHE A 133      42.355  14.952  88.095  1.00 10.85           C  
ATOM   1078  CD2 PHE A 133      44.145  15.363  89.629  1.00 11.22           C  
ATOM   1079  CE1 PHE A 133      41.462  15.608  88.960  1.00 10.47           C  
ATOM   1080  CE2 PHE A 133      43.266  16.021  90.501  1.00 12.54           C  
ATOM   1081  CZ  PHE A 133      41.919  16.147  90.162  1.00  9.28           C  
ATOM   1082  N   VAL A 134      45.680  12.758  85.031  1.00 12.34           N  
ATOM   1083  CA  VAL A 134      46.804  12.310  84.209  1.00 12.17           C  
ATOM   1084  C   VAL A 134      47.507  13.577  83.699  1.00 11.36           C  
ATOM   1085  O   VAL A 134      46.912  14.655  83.689  1.00 12.43           O  
ATOM   1086  CB  VAL A 134      46.347  11.493  82.956  1.00 11.45           C  
ATOM   1087  CG1 VAL A 134      45.617  10.214  83.371  1.00 11.68           C  
ATOM   1088  CG2 VAL A 134      45.483  12.348  82.084  1.00  8.07           C  
ATOM   1089  N   ILE A 135      48.769  13.461  83.291  1.00 12.40           N  
ATOM   1090  CA  ILE A 135      49.478  14.621  82.754  1.00 10.55           C  
ATOM   1091  C   ILE A 135      50.264  14.250  81.506  1.00 12.51           C  
ATOM   1092  O   ILE A 135      50.765  13.137  81.375  1.00 11.97           O  
ATOM   1093  CB  ILE A 135      50.490  15.253  83.737  1.00  9.62           C  
ATOM   1094  CG1 ILE A 135      51.617  14.265  84.040  1.00  9.11           C  
ATOM   1095  CG2 ILE A 135      49.810  15.697  85.005  1.00  7.06           C  
ATOM   1096  CD1 ILE A 135      52.751  14.901  84.784  1.00 10.57           C  
ATOM   1097  N   PHE A 136      50.365  15.207  80.596  1.00 10.71           N  
ATOM   1098  CA  PHE A 136      51.104  15.027  79.366  1.00 11.72           C  
ATOM   1099  C   PHE A 136      51.326  16.408  78.775  1.00 11.75           C  
ATOM   1100  O   PHE A 136      50.730  17.398  79.228  1.00 10.83           O  
ATOM   1101  CB  PHE A 136      50.332  14.146  78.384  1.00 13.42           C  
ATOM   1102  CG  PHE A 136      48.962  14.662  78.044  1.00 13.04           C  
ATOM   1103  CD1 PHE A 136      47.892  14.426  78.886  1.00 14.38           C  
ATOM   1104  CD2 PHE A 136      48.743  15.363  76.865  1.00 15.17           C  
ATOM   1105  CE1 PHE A 136      46.607  14.879  78.558  1.00 16.71           C  
ATOM   1106  CE2 PHE A 136      47.471  15.818  76.526  1.00 15.40           C  
ATOM   1107  CZ  PHE A 136      46.398  15.570  77.379  1.00 15.13           C  
ATOM   1108  N   TYR A 137      52.177  16.462  77.752  1.00  8.80           N  
ATOM   1109  CA  TYR A 137      52.509  17.701  77.097  1.00  9.57           C  
ATOM   1110  C   TYR A 137      51.894  17.771  75.703  1.00  8.53           C  
ATOM   1111  O   TYR A 137      51.727  16.755  75.044  1.00  9.57           O  
ATOM   1112  CB  TYR A 137      54.027  17.826  76.980  1.00  8.04           C  
ATOM   1113  CG  TYR A 137      54.469  19.177  76.469  1.00 10.65           C  
ATOM   1114  CD1 TYR A 137      54.487  19.465  75.099  1.00 10.26           C  
ATOM   1115  CD2 TYR A 137      54.795  20.191  77.356  1.00  8.99           C  
ATOM   1116  CE1 TYR A 137      54.817  20.750  74.642  1.00 13.31           C  
ATOM   1117  CE2 TYR A 137      55.120  21.467  76.909  1.00  9.51           C  
ATOM   1118  CZ  TYR A 137      55.125  21.741  75.569  1.00 10.45           C  
ATOM   1119  OH  TYR A 137      55.408  23.017  75.165  1.00 12.06           O  
ATOM   1120  N   SER A 138      51.536  18.975  75.289  1.00  8.12           N  
ATOM   1121  CA  SER A 138      50.992  19.202  73.965  1.00 11.02           C  
ATOM   1122  C   SER A 138      50.943  20.700  73.674  1.00  9.96           C  
ATOM   1123  O   SER A 138      50.515  21.494  74.507  1.00  8.71           O  
ATOM   1124  CB  SER A 138      49.596  18.597  73.847  1.00 11.56           C  
ATOM   1125  OG  SER A 138      49.099  18.757  72.540  1.00 14.27           O  
ATOM   1126  N   GLY A 139      51.401  21.085  72.491  1.00  6.03           N  
ATOM   1127  CA  GLY A 139      51.371  22.483  72.130  1.00  8.91           C  
ATOM   1128  C   GLY A 139      52.299  23.390  72.916  1.00 10.81           C  
ATOM   1129  O   GLY A 139      53.524  23.324  72.769  1.00 10.05           O  
ATOM   1130  N   TYR A 140      51.708  24.251  73.740  1.00  8.82           N  
ATOM   1131  CA  TYR A 140      52.475  25.195  74.531  1.00  9.81           C  
ATOM   1132  C   TYR A 140      52.803  24.774  75.950  1.00 11.23           C  
ATOM   1133  O   TYR A 140      53.580  25.451  76.614  1.00 11.30           O  
ATOM   1134  CB  TYR A 140      51.740  26.543  74.595  1.00 11.41           C  
ATOM   1135  CG  TYR A 140      51.821  27.323  73.317  1.00  9.25           C  
ATOM   1136  CD1 TYR A 140      50.912  27.102  72.279  1.00 10.38           C  
ATOM   1137  CD2 TYR A 140      52.859  28.222  73.104  1.00 14.56           C  
ATOM   1138  CE1 TYR A 140      51.044  27.754  71.055  1.00 11.60           C  
ATOM   1139  CE2 TYR A 140      53.004  28.881  71.871  1.00 16.05           C  
ATOM   1140  CZ  TYR A 140      52.095  28.637  70.856  1.00 16.04           C  
ATOM   1141  OH  TYR A 140      52.262  29.258  69.630  1.00 16.45           O  
ATOM   1142  N   SER A 141      52.236  23.668  76.425  1.00  9.07           N  
ATOM   1143  CA  SER A 141      52.480  23.298  77.818  1.00 11.88           C  
ATOM   1144  C   SER A 141      52.094  21.889  78.172  1.00 10.69           C  
ATOM   1145  O   SER A 141      51.728  21.087  77.318  1.00 11.24           O  
ATOM   1146  CB  SER A 141      51.656  24.204  78.730  1.00 12.79           C  
ATOM   1147  OG  SER A 141      50.264  23.989  78.492  1.00 13.91           O  
ATOM   1148  N   TRP A 142      52.187  21.624  79.467  1.00 10.44           N  
ATOM   1149  CA  TRP A 142      51.775  20.371  80.049  1.00  9.27           C  
ATOM   1150  C   TRP A 142      50.311  20.608  80.381  1.00 10.10           C  
ATOM   1151  O   TRP A 142      49.888  21.752  80.543  1.00 11.97           O  
ATOM   1152  CB  TRP A 142      52.513  20.095  81.356  1.00 10.47           C  
ATOM   1153  CG  TRP A 142      53.897  19.656  81.179  1.00  7.38           C  
ATOM   1154  CD1 TRP A 142      55.010  20.440  81.035  1.00  9.18           C  
ATOM   1155  CD2 TRP A 142      54.343  18.306  81.108  1.00  9.13           C  
ATOM   1156  NE1 TRP A 142      56.122  19.650  80.882  1.00  6.74           N  
ATOM   1157  CE2 TRP A 142      55.741  18.336  80.920  1.00  6.88           C  
ATOM   1158  CE3 TRP A 142      53.694  17.068  81.183  1.00  8.05           C  
ATOM   1159  CZ2 TRP A 142      56.506  17.171  80.807  1.00  7.89           C  
ATOM   1160  CZ3 TRP A 142      54.458  15.909  81.071  1.00 10.70           C  
ATOM   1161  CH2 TRP A 142      55.848  15.973  80.883  1.00  9.68           C  
ATOM   1162  N   HIS A 143      49.556  19.528  80.485  1.00  8.52           N  
ATOM   1163  CA  HIS A 143      48.147  19.592  80.813  1.00 11.94           C  
ATOM   1164  C   HIS A 143      47.822  18.546  81.877  1.00 12.09           C  
ATOM   1165  O   HIS A 143      48.226  17.388  81.746  1.00 11.88           O  
ATOM   1166  CB  HIS A 143      47.308  19.301  79.582  1.00 12.94           C  
ATOM   1167  CG  HIS A 143      47.561  20.227  78.445  1.00 14.61           C  
ATOM   1168  ND1 HIS A 143      48.650  20.093  77.611  1.00 13.61           N  
ATOM   1169  CD2 HIS A 143      46.847  21.275  77.971  1.00 11.02           C  
ATOM   1170  CE1 HIS A 143      48.589  21.014  76.667  1.00 10.60           C  
ATOM   1171  NE2 HIS A 143      47.505  21.742  76.863  1.00 13.87           N  
ATOM   1172  N   LEU A 144      47.128  18.991  82.931  1.00 10.40           N  
ATOM   1173  CA  LEU A 144      46.677  18.172  84.045  1.00 11.69           C  
ATOM   1174  C   LEU A 144      45.214  17.939  83.756  1.00 13.97           C  
ATOM   1175  O   LEU A 144      44.378  18.857  83.816  1.00 13.72           O  
ATOM   1176  CB  LEU A 144      46.825  18.913  85.367  1.00 13.85           C  
ATOM   1177  CG  LEU A 144      46.280  18.168  86.601  1.00 12.32           C  
ATOM   1178  CD1 LEU A 144      47.094  16.900  86.841  1.00 12.76           C  
ATOM   1179  CD2 LEU A 144      46.325  19.074  87.813  1.00 13.31           C  
HETATM 1180  N   MSE A 145      44.890  16.699  83.452  1.00 16.29           N  
HETATM 1181  CA  MSE A 145      43.542  16.389  83.050  1.00 17.78           C  
HETATM 1182  C   MSE A 145      42.854  15.298  83.831  1.00 19.56           C  
HETATM 1183  O   MSE A 145      43.490  14.532  84.560  1.00 22.59           O  
HETATM 1184  CB  MSE A 145      43.586  16.011  81.576  1.00 16.77           C  
HETATM 1185  CG  MSE A 145      44.538  16.881  80.770  1.00 22.75           C  
HETATM 1186 SE   MSE A 145      43.553  18.064  79.684  1.00 19.04          SE  
HETATM 1187  CE  MSE A 145      44.456  19.716  79.967  1.00 39.90           C  
ATOM   1188  N   ASN A 146      41.537  15.250  83.684  1.00 19.12           N  
ATOM   1189  CA  ASN A 146      40.742  14.220  84.328  1.00 18.38           C  
ATOM   1190  C   ASN A 146      40.902  12.982  83.457  1.00 15.47           C  
ATOM   1191  O   ASN A 146      40.962  13.090  82.229  1.00 15.25           O  
ATOM   1192  CB  ASN A 146      39.280  14.643  84.384  1.00 18.30           C  
ATOM   1193  CG  ASN A 146      39.034  15.713  85.417  1.00 16.81           C  
ATOM   1194  OD1 ASN A 146      39.112  15.447  86.605  1.00 20.34           O  
ATOM   1195  ND2 ASN A 146      38.757  16.935  84.968  1.00 16.74           N  
ATOM   1196  N   ARG A 147      41.006  11.815  84.087  1.00 13.67           N  
ATOM   1197  CA  ARG A 147      41.147  10.561  83.364  1.00 11.02           C  
ATOM   1198  C   ARG A 147      39.987  10.408  82.373  1.00 12.06           C  
ATOM   1199  O   ARG A 147      38.828  10.605  82.731  1.00 11.75           O  
ATOM   1200  CB  ARG A 147      41.159   9.390  84.353  1.00 12.73           C  
ATOM   1201  CG  ARG A 147      41.129   8.008  83.718  1.00 12.35           C  
ATOM   1202  CD  ARG A 147      42.420   7.646  82.976  1.00 16.56           C  
ATOM   1203  NE  ARG A 147      43.547   7.443  83.886  1.00 13.70           N  
ATOM   1204  CZ  ARG A 147      44.668   6.811  83.565  1.00 13.82           C  
ATOM   1205  NH1 ARG A 147      44.839   6.308  82.345  1.00 15.79           N  
ATOM   1206  NH2 ARG A 147      45.630   6.679  84.469  1.00 14.32           N  
ATOM   1207  N   GLY A 148      40.298  10.078  81.120  1.00  9.72           N  
ATOM   1208  CA  GLY A 148      39.246   9.912  80.128  1.00 10.15           C  
ATOM   1209  C   GLY A 148      38.905  11.189  79.375  1.00 11.49           C  
ATOM   1210  O   GLY A 148      38.127  11.177  78.414  1.00 11.78           O  
ATOM   1211  N   GLU A 149      39.490  12.297  79.817  1.00  9.70           N  
ATOM   1212  CA  GLU A 149      39.263  13.589  79.186  1.00 12.16           C  
ATOM   1213  C   GLU A 149      40.320  13.686  78.094  1.00 12.27           C  
ATOM   1214  O   GLU A 149      41.392  14.264  78.303  1.00 12.87           O  
ATOM   1215  CB  GLU A 149      39.440  14.689  80.233  1.00 12.57           C  
ATOM   1216  CG  GLU A 149      39.148  16.097  79.752  1.00 13.96           C  
ATOM   1217  CD  GLU A 149      39.178  17.101  80.884  1.00 12.69           C  
ATOM   1218  OE1 GLU A 149      39.596  16.737  82.024  1.00 11.65           O  
ATOM   1219  OE2 GLU A 149      38.782  18.253  80.636  1.00 10.49           O  
ATOM   1220  N   ASP A 150      40.005  13.122  76.928  1.00 13.27           N  
ATOM   1221  CA  ASP A 150      40.944  13.094  75.802  1.00 11.58           C  
ATOM   1222  C   ASP A 150      40.311  13.170  74.403  1.00 12.22           C  
ATOM   1223  O   ASP A 150      39.115  13.412  74.237  1.00  9.50           O  
ATOM   1224  CB  ASP A 150      41.812  11.826  75.875  1.00 14.79           C  
ATOM   1225  CG  ASP A 150      40.993  10.540  75.767  1.00 16.94           C  
ATOM   1226  OD1 ASP A 150      39.928  10.554  75.116  1.00 15.30           O  
ATOM   1227  OD2 ASP A 150      41.420   9.510  76.323  1.00 19.07           O  
ATOM   1228  N   LYS A 151      41.145  12.952  73.395  1.00 10.47           N  
ATOM   1229  CA  LYS A 151      40.708  13.009  72.009  1.00 13.49           C  
ATOM   1230  C   LYS A 151      39.718  11.910  71.622  1.00 13.85           C  
ATOM   1231  O   LYS A 151      38.885  12.109  70.722  1.00 11.94           O  
ATOM   1232  CB  LYS A 151      41.927  12.980  71.077  1.00 12.85           C  
ATOM   1233  CG  LYS A 151      42.844  14.190  71.199  1.00 11.77           C  
ATOM   1234  CD  LYS A 151      43.780  14.277  69.995  1.00 10.88           C  
ATOM   1235  CE  LYS A 151      44.685  15.473  70.067  1.00 11.29           C  
ATOM   1236  NZ  LYS A 151      45.753  15.368  71.098  1.00 11.46           N  
ATOM   1237  N   ALA A 152      39.819  10.750  72.281  1.00 12.31           N  
ATOM   1238  CA  ALA A 152      38.894   9.643  72.021  1.00 13.16           C  
ATOM   1239  C   ALA A 152      37.499  10.126  72.427  1.00 12.79           C  
ATOM   1240  O   ALA A 152      36.510   9.900  71.726  1.00 10.60           O  
ATOM   1241  CB  ALA A 152      39.290   8.413  72.836  1.00 10.85           C  
ATOM   1242  N   PHE A 153      37.429  10.808  73.565  1.00 13.67           N  
ATOM   1243  CA  PHE A 153      36.165  11.360  74.044  1.00 11.55           C  
ATOM   1244  C   PHE A 153      35.571  12.297  72.971  1.00 11.78           C  
ATOM   1245  O   PHE A 153      34.397  12.185  72.583  1.00  8.89           O  
ATOM   1246  CB  PHE A 153      36.415  12.144  75.335  1.00 12.19           C  
ATOM   1247  CG  PHE A 153      35.195  12.811  75.897  1.00 14.09           C  
ATOM   1248  CD1 PHE A 153      34.308  12.104  76.697  1.00 12.35           C  
ATOM   1249  CD2 PHE A 153      34.910  14.145  75.594  1.00 12.38           C  
ATOM   1250  CE1 PHE A 153      33.157  12.705  77.187  1.00 15.64           C  
ATOM   1251  CE2 PHE A 153      33.747  14.757  76.086  1.00 16.23           C  
ATOM   1252  CZ  PHE A 153      32.874  14.042  76.877  1.00 11.60           C  
ATOM   1253  N   ALA A 154      36.394  13.225  72.505  1.00 10.52           N  
ATOM   1254  CA  ALA A 154      35.964  14.197  71.507  1.00 11.36           C  
ATOM   1255  C   ALA A 154      35.538  13.561  70.199  1.00 11.61           C  
ATOM   1256  O   ALA A 154      34.531  13.966  69.624  1.00 12.68           O  
ATOM   1257  CB  ALA A 154      37.061  15.211  71.249  1.00  8.27           C  
ATOM   1258  N   VAL A 155      36.288  12.572  69.718  1.00 11.77           N  
ATOM   1259  CA  VAL A 155      35.912  11.949  68.451  1.00 11.34           C  
ATOM   1260  C   VAL A 155      34.625  11.138  68.604  1.00 12.71           C  
ATOM   1261  O   VAL A 155      33.788  11.140  67.699  1.00 11.89           O  
ATOM   1262  CB  VAL A 155      37.052  11.060  67.879  1.00  8.33           C  
ATOM   1263  CG1 VAL A 155      36.561  10.306  66.642  1.00  9.63           C  
ATOM   1264  CG2 VAL A 155      38.236  11.939  67.491  1.00 13.82           C  
ATOM   1265  N   ASN A 156      34.448  10.471  69.751  1.00  9.78           N  
ATOM   1266  CA  ASN A 156      33.233   9.689  69.975  1.00 11.64           C  
ATOM   1267  C   ASN A 156      32.030  10.643  70.014  1.00 12.41           C  
ATOM   1268  O   ASN A 156      30.924  10.288  69.587  1.00 11.28           O  
ATOM   1269  CB  ASN A 156      33.302   8.893  71.294  1.00 13.74           C  
ATOM   1270  CG  ASN A 156      34.025   7.543  71.147  1.00 14.66           C  
ATOM   1271  OD1 ASN A 156      33.921   6.870  70.123  1.00 14.90           O  
ATOM   1272  ND2 ASN A 156      34.745   7.143  72.188  1.00 15.49           N  
ATOM   1273  N   LYS A 157      32.264  11.851  70.523  1.00 12.06           N  
ATOM   1274  CA  LYS A 157      31.230  12.875  70.633  1.00 14.58           C  
ATOM   1275  C   LYS A 157      30.800  13.321  69.243  1.00 14.08           C  
ATOM   1276  O   LYS A 157      29.610  13.481  68.971  1.00 16.96           O  
ATOM   1277  CB  LYS A 157      31.760  14.082  71.411  1.00 15.52           C  
ATOM   1278  CG  LYS A 157      30.668  14.978  71.954  1.00 18.66           C  
ATOM   1279  CD  LYS A 157      30.588  14.839  73.467  1.00 22.61           C  
ATOM   1280  CE  LYS A 157      29.171  14.972  73.973  1.00 20.64           C  
ATOM   1281  NZ  LYS A 157      29.132  14.748  75.445  1.00 26.02           N  
ATOM   1282  N   LEU A 158      31.780  13.513  68.364  1.00 13.75           N  
ATOM   1283  CA  LEU A 158      31.541  13.923  66.977  1.00 11.73           C  
ATOM   1284  C   LEU A 158      30.754  12.845  66.226  1.00 13.31           C  
ATOM   1285  O   LEU A 158      29.793  13.140  65.495  1.00 11.13           O  
ATOM   1286  CB  LEU A 158      32.889  14.183  66.305  1.00 12.91           C  
ATOM   1287  CG  LEU A 158      33.600  15.423  66.868  1.00 10.98           C  
ATOM   1288  CD1 LEU A 158      35.078  15.423  66.483  1.00 12.39           C  
ATOM   1289  CD2 LEU A 158      32.903  16.676  66.350  1.00 12.20           C  
ATOM   1290  N   LYS A 159      31.168  11.596  66.416  1.00 10.38           N  
ATOM   1291  CA  LYS A 159      30.498  10.457  65.814  1.00 12.20           C  
ATOM   1292  C   LYS A 159      29.001  10.484  66.149  1.00 13.05           C  
ATOM   1293  O   LYS A 159      28.159  10.350  65.264  1.00 13.55           O  
ATOM   1294  CB  LYS A 159      31.133   9.173  66.334  1.00 11.88           C  
ATOM   1295  CG  LYS A 159      30.396   7.905  65.969  1.00 14.66           C  
ATOM   1296  CD  LYS A 159      31.189   6.687  66.418  1.00 17.56           C  
ATOM   1297  CE  LYS A 159      30.469   5.394  66.064  1.00 22.17           C  
ATOM   1298  NZ  LYS A 159      29.172   5.308  66.773  1.00 26.54           N  
ATOM   1299  N   GLU A 160      28.686  10.674  67.431  1.00 15.44           N  
ATOM   1300  CA  GLU A 160      27.308  10.721  67.917  1.00 17.07           C  
ATOM   1301  C   GLU A 160      26.542  11.950  67.396  1.00 17.38           C  
ATOM   1302  O   GLU A 160      25.372  11.855  66.993  1.00 16.52           O  
ATOM   1303  CB  GLU A 160      27.310  10.733  69.444  1.00 22.38           C  
ATOM   1304  CG  GLU A 160      25.945  10.597  70.080  1.00 32.88           C  
ATOM   1305  CD  GLU A 160      25.299   9.247  69.802  1.00 40.10           C  
ATOM   1306  OE1 GLU A 160      26.024   8.305  69.409  1.00 45.82           O  
ATOM   1307  OE2 GLU A 160      24.069   9.123  69.991  1.00 44.57           O  
HETATM 1308  N   MSE A 161      27.200  13.103  67.415  1.00 15.57           N  
HETATM 1309  CA  MSE A 161      26.583  14.339  66.949  1.00 16.84           C  
HETATM 1310  C   MSE A 161      26.236  14.254  65.471  1.00 16.16           C  
HETATM 1311  O   MSE A 161      25.206  14.754  65.046  1.00 18.55           O  
HETATM 1312  CB  MSE A 161      27.521  15.532  67.181  1.00 13.51           C  
HETATM 1313  CG  MSE A 161      27.835  15.819  68.641  1.00 13.42           C  
HETATM 1314 SE   MSE A 161      29.161  17.230  68.839  1.00 16.60          SE  
HETATM 1315  CE  MSE A 161      28.078  18.665  68.117  1.00 15.19           C  
ATOM   1316  N   TYR A 162      27.082  13.595  64.691  1.00 14.73           N  
ATOM   1317  CA  TYR A 162      26.845  13.494  63.254  1.00 13.50           C  
ATOM   1318  C   TYR A 162      26.294  12.136  62.795  1.00 13.49           C  
ATOM   1319  O   TYR A 162      26.161  11.892  61.590  1.00 14.75           O  
ATOM   1320  CB  TYR A 162      28.141  13.818  62.504  1.00 15.03           C  
ATOM   1321  CG  TYR A 162      28.525  15.291  62.496  1.00 14.95           C  
ATOM   1322  CD1 TYR A 162      28.040  16.151  61.513  1.00 13.59           C  
ATOM   1323  CD2 TYR A 162      29.365  15.820  63.472  1.00 14.41           C  
ATOM   1324  CE1 TYR A 162      28.384  17.496  61.497  1.00 14.91           C  
ATOM   1325  CE2 TYR A 162      29.713  17.170  63.472  1.00 15.36           C  
ATOM   1326  CZ  TYR A 162      29.218  18.000  62.477  1.00 16.85           C  
ATOM   1327  OH  TYR A 162      29.562  19.331  62.457  1.00 17.10           O  
ATOM   1328  N   SER A 163      25.971  11.266  63.746  1.00 13.28           N  
ATOM   1329  CA  SER A 163      25.445   9.929  63.443  1.00 14.78           C  
ATOM   1330  C   SER A 163      26.270   9.244  62.372  1.00 15.61           C  
ATOM   1331  O   SER A 163      25.745   8.811  61.346  1.00 16.10           O  
ATOM   1332  CB  SER A 163      23.992  10.026  62.980  1.00 14.71           C  
ATOM   1333  OG  SER A 163      23.215  10.721  63.939  1.00 22.05           O  
ATOM   1334  N   LEU A 164      27.569   9.145  62.618  1.00 17.27           N  
ATOM   1335  CA  LEU A 164      28.480   8.531  61.673  1.00 18.19           C  
ATOM   1336  C   LEU A 164      28.940   7.155  62.140  1.00 18.21           C  
ATOM   1337  O   LEU A 164      28.749   6.769  63.294  1.00 19.95           O  
ATOM   1338  CB  LEU A 164      29.713   9.420  61.483  1.00 22.46           C  
ATOM   1339  CG  LEU A 164      29.501  10.838  60.937  1.00 24.38           C  
ATOM   1340  CD1 LEU A 164      30.844  11.564  60.837  1.00 26.66           C  
ATOM   1341  CD2 LEU A 164      28.836  10.762  59.577  1.00 24.43           C  
ATOM   1342  N   GLU A 165      29.522   6.415  61.209  1.00 16.87           N  
ATOM   1343  CA  GLU A 165      30.101   5.116  61.500  1.00 16.81           C  
ATOM   1344  C   GLU A 165      31.551   5.524  61.685  1.00 14.76           C  
ATOM   1345  O   GLU A 165      31.974   6.535  61.126  1.00 12.80           O  
ATOM   1346  CB  GLU A 165      29.975   4.190  60.294  1.00 25.15           C  
ATOM   1347  CG  GLU A 165      28.546   3.867  59.894  1.00 33.23           C  
ATOM   1348  CD  GLU A 165      27.786   3.144  60.990  1.00 39.47           C  
ATOM   1349  OE1 GLU A 165      28.335   2.172  61.557  1.00 44.90           O  
ATOM   1350  OE2 GLU A 165      26.637   3.542  61.281  1.00 45.64           O  
ATOM   1351  N   TYR A 166      32.304   4.777  62.480  1.00 13.50           N  
ATOM   1352  CA  TYR A 166      33.714   5.090  62.690  1.00 14.73           C  
ATOM   1353  C   TYR A 166      34.484   5.213  61.374  1.00 15.54           C  
ATOM   1354  O   TYR A 166      35.344   6.079  61.229  1.00 15.58           O  
ATOM   1355  CB  TYR A 166      34.382   4.003  63.539  1.00 12.30           C  
ATOM   1356  CG  TYR A 166      34.158   4.137  65.026  1.00 11.21           C  
ATOM   1357  CD1 TYR A 166      34.573   5.275  65.711  1.00 13.34           C  
ATOM   1358  CD2 TYR A 166      33.565   3.109  65.754  1.00 10.27           C  
ATOM   1359  CE1 TYR A 166      34.406   5.384  67.101  1.00 13.02           C  
ATOM   1360  CE2 TYR A 166      33.391   3.203  67.135  1.00 11.95           C  
ATOM   1361  CZ  TYR A 166      33.817   4.342  67.800  1.00 13.10           C  
ATOM   1362  OH  TYR A 166      33.661   4.426  69.165  1.00 12.14           O  
ATOM   1363  N   ASP A 167      34.182   4.345  60.415  1.00 15.77           N  
ATOM   1364  CA  ASP A 167      34.899   4.390  59.154  1.00 18.94           C  
ATOM   1365  C   ASP A 167      34.547   5.565  58.259  1.00 17.44           C  
ATOM   1366  O   ASP A 167      35.065   5.672  57.156  1.00 17.23           O  
ATOM   1367  CB  ASP A 167      34.739   3.092  58.369  1.00 20.60           C  
ATOM   1368  CG  ASP A 167      35.838   2.915  57.339  1.00 24.93           C  
ATOM   1369  OD1 ASP A 167      35.572   2.354  56.259  1.00 29.46           O  
ATOM   1370  OD2 ASP A 167      36.982   3.343  57.618  1.00 27.67           O  
ATOM   1371  N   GLU A 168      33.654   6.441  58.727  1.00 16.70           N  
ATOM   1372  CA  GLU A 168      33.310   7.638  57.969  1.00 13.81           C  
ATOM   1373  C   GLU A 168      34.110   8.790  58.572  1.00 13.76           C  
ATOM   1374  O   GLU A 168      34.021   9.929  58.125  1.00 10.98           O  
ATOM   1375  CB  GLU A 168      31.814   7.936  58.078  1.00 16.34           C  
ATOM   1376  CG  GLU A 168      30.937   6.887  57.420  1.00 18.31           C  
ATOM   1377  CD  GLU A 168      29.466   7.195  57.554  1.00 17.32           C  
ATOM   1378  OE1 GLU A 168      28.951   7.218  58.691  1.00 19.41           O  
ATOM   1379  OE2 GLU A 168      28.820   7.421  56.513  1.00 23.86           O  
ATOM   1380  N   ILE A 169      34.895   8.471  59.595  1.00 13.52           N  
ATOM   1381  CA  ILE A 169      35.694   9.468  60.293  1.00 12.67           C  
ATOM   1382  C   ILE A 169      37.171   9.248  60.043  1.00 12.94           C  
ATOM   1383  O   ILE A 169      37.662   8.118  60.104  1.00  9.86           O  
ATOM   1384  CB  ILE A 169      35.469   9.417  61.823  1.00 13.15           C  
ATOM   1385  CG1 ILE A 169      34.042   9.850  62.163  1.00 13.65           C  
ATOM   1386  CG2 ILE A 169      36.515  10.306  62.552  1.00 13.38           C  
ATOM   1387  CD1 ILE A 169      33.698   9.615  63.612  1.00 11.39           C  
ATOM   1388  N   LEU A 170      37.862  10.340  59.733  1.00 11.89           N  
ATOM   1389  CA  LEU A 170      39.299  10.317  59.511  1.00 11.70           C  
ATOM   1390  C   LEU A 170      39.944  11.126  60.640  1.00 12.98           C  
ATOM   1391  O   LEU A 170      39.477  12.221  60.968  1.00 12.40           O  
ATOM   1392  CB  LEU A 170      39.635  10.962  58.161  1.00 12.84           C  
ATOM   1393  CG  LEU A 170      41.097  11.349  57.919  1.00 13.83           C  
ATOM   1394  CD1 LEU A 170      41.984  10.106  58.010  1.00 11.69           C  
ATOM   1395  CD2 LEU A 170      41.226  12.023  56.555  1.00 11.08           C  
ATOM   1396  N   VAL A 171      40.993  10.588  61.253  1.00 11.70           N  
ATOM   1397  CA  VAL A 171      41.688  11.336  62.299  1.00 11.19           C  
ATOM   1398  C   VAL A 171      43.120  11.595  61.862  1.00  9.72           C  
ATOM   1399  O   VAL A 171      43.765  10.716  61.283  1.00 11.23           O  
ATOM   1400  CB  VAL A 171      41.722  10.583  63.656  1.00  9.86           C  
ATOM   1401  CG1 VAL A 171      40.310  10.409  64.191  1.00  8.56           C  
ATOM   1402  CG2 VAL A 171      42.422   9.264  63.498  1.00 10.09           C  
ATOM   1403  N   ILE A 172      43.593  12.811  62.105  1.00  9.08           N  
ATOM   1404  CA  ILE A 172      44.956  13.200  61.770  1.00 11.22           C  
ATOM   1405  C   ILE A 172      45.666  13.634  63.060  1.00 11.38           C  
ATOM   1406  O   ILE A 172      45.219  14.538  63.772  1.00  8.95           O  
ATOM   1407  CB  ILE A 172      44.967  14.334  60.715  1.00 13.54           C  
ATOM   1408  CG1 ILE A 172      44.242  13.850  59.451  1.00 15.57           C  
ATOM   1409  CG2 ILE A 172      46.393  14.740  60.368  1.00 13.05           C  
ATOM   1410  CD1 ILE A 172      43.996  14.924  58.404  1.00 18.20           C  
ATOM   1411  N   GLY A 173      46.772  12.951  63.354  1.00 11.03           N  
ATOM   1412  CA  GLY A 173      47.547  13.225  64.540  1.00 11.16           C  
ATOM   1413  C   GLY A 173      49.029  13.015  64.297  1.00 11.17           C  
ATOM   1414  O   GLY A 173      49.473  12.797  63.160  1.00  8.50           O  
ATOM   1415  N   ASP A 174      49.822  13.052  65.358  1.00  9.51           N  
ATOM   1416  CA  ASP A 174      51.231  12.899  65.144  1.00 10.62           C  
ATOM   1417  C   ASP A 174      52.018  12.197  66.218  1.00  8.43           C  
ATOM   1418  O   ASP A 174      53.115  11.755  65.953  1.00  9.12           O  
ATOM   1419  CB  ASP A 174      51.850  14.278  64.873  1.00 10.43           C  
ATOM   1420  CG  ASP A 174      51.838  15.164  66.095  1.00 15.20           C  
ATOM   1421  OD1 ASP A 174      50.940  14.997  66.926  1.00 12.84           O  
ATOM   1422  OD2 ASP A 174      52.714  16.038  66.238  1.00 14.95           O  
ATOM   1423  N   SER A 175      51.469  12.087  67.425  1.00 12.67           N  
ATOM   1424  CA  SER A 175      52.213  11.458  68.499  1.00 11.35           C  
ATOM   1425  C   SER A 175      51.383  10.674  69.510  1.00 12.89           C  
ATOM   1426  O   SER A 175      50.200  10.391  69.295  1.00 10.26           O  
ATOM   1427  CB  SER A 175      53.048  12.523  69.225  1.00 13.82           C  
ATOM   1428  OG  SER A 175      52.235  13.606  69.646  1.00 15.43           O  
ATOM   1429  N   ASN A 176      52.015  10.348  70.636  1.00 12.99           N  
ATOM   1430  CA  ASN A 176      51.358   9.548  71.645  1.00 12.01           C  
ATOM   1431  C   ASN A 176      50.116  10.193  72.230  1.00 13.76           C  
ATOM   1432  O   ASN A 176      49.152   9.497  72.547  1.00 12.56           O  
ATOM   1433  CB  ASN A 176      52.351   9.183  72.747  1.00 13.67           C  
ATOM   1434  CG  ASN A 176      51.683   8.510  73.924  1.00 16.43           C  
ATOM   1435  OD1 ASN A 176      51.265   9.172  74.870  1.00 15.98           O  
ATOM   1436  ND2 ASN A 176      51.561   7.189  73.862  1.00 16.16           N  
ATOM   1437  N   ASN A 177      50.113  11.513  72.353  1.00 13.02           N  
ATOM   1438  CA  ASN A 177      48.942  12.158  72.921  1.00 15.20           C  
ATOM   1439  C   ASN A 177      47.774  12.136  71.930  1.00 13.07           C  
ATOM   1440  O   ASN A 177      46.708  12.668  72.217  1.00 13.61           O  
ATOM   1441  CB  ASN A 177      49.265  13.586  73.406  1.00 12.14           C  
ATOM   1442  CG  ASN A 177      49.801  14.461  72.312  1.00 16.94           C  
ATOM   1443  OD1 ASN A 177      49.454  14.270  71.153  1.00 14.37           O  
ATOM   1444  ND2 ASN A 177      50.638  15.434  72.665  1.00  9.53           N  
ATOM   1445  N   ASP A 178      47.985  11.516  70.765  1.00 12.06           N  
ATOM   1446  CA  ASP A 178      46.916  11.355  69.779  1.00  8.52           C  
ATOM   1447  C   ASP A 178      46.492   9.884  69.734  1.00 11.22           C  
ATOM   1448  O   ASP A 178      45.511   9.528  69.059  1.00  9.87           O  
ATOM   1449  CB  ASP A 178      47.366  11.734  68.374  1.00 10.71           C  
ATOM   1450  CG  ASP A 178      47.816  13.151  68.277  1.00 12.61           C  
ATOM   1451  OD1 ASP A 178      47.025  14.054  68.638  1.00 13.86           O  
ATOM   1452  OD2 ASP A 178      48.967  13.353  67.832  1.00 12.14           O  
HETATM 1453  N   MSE A 179      47.215   9.019  70.438  1.00 11.76           N  
HETATM 1454  CA  MSE A 179      46.867   7.602  70.377  1.00 12.80           C  
HETATM 1455  C   MSE A 179      45.440   7.310  70.822  1.00 12.51           C  
HETATM 1456  O   MSE A 179      44.792   6.427  70.274  1.00 12.05           O  
HETATM 1457  CB  MSE A 179      47.874   6.745  71.157  1.00 12.76           C  
HETATM 1458  CG  MSE A 179      47.668   5.234  70.976  1.00 14.42           C  
HETATM 1459 SE   MSE A 179      47.669   4.567  69.125  1.00 21.34          SE  
HETATM 1460  CE  MSE A 179      49.574   4.346  68.923  1.00 19.59           C  
ATOM   1461  N   PRO A 180      44.923   8.039  71.827  1.00 15.28           N  
ATOM   1462  CA  PRO A 180      43.544   7.741  72.223  1.00 14.12           C  
ATOM   1463  C   PRO A 180      42.561   7.754  71.040  1.00 14.92           C  
ATOM   1464  O   PRO A 180      41.655   6.927  70.988  1.00 16.10           O  
ATOM   1465  CB  PRO A 180      43.242   8.827  73.256  1.00 17.76           C  
ATOM   1466  CG  PRO A 180      44.566   8.997  73.930  1.00 16.93           C  
ATOM   1467  CD  PRO A 180      45.533   9.014  72.750  1.00 15.50           C  
HETATM 1468  N   MSE A 181      42.730   8.664  70.085  1.00 13.30           N  
HETATM 1469  CA  MSE A 181      41.813   8.668  68.963  1.00 13.15           C  
HETATM 1470  C   MSE A 181      42.294   7.760  67.832  1.00 11.64           C  
HETATM 1471  O   MSE A 181      41.502   7.351  66.995  1.00 12.42           O  
HETATM 1472  CB  MSE A 181      41.522  10.096  68.447  1.00 13.30           C  
HETATM 1473  CG  MSE A 181      42.673  10.882  67.835  1.00 12.91           C  
HETATM 1474 SE   MSE A 181      42.021  12.558  67.058  1.00 13.45          SE  
HETATM 1475  CE  MSE A 181      43.728  13.291  66.510  1.00 17.82           C  
ATOM   1476  N   PHE A 182      43.573   7.408  67.816  1.00 13.70           N  
ATOM   1477  CA  PHE A 182      44.036   6.514  66.748  1.00 14.42           C  
ATOM   1478  C   PHE A 182      43.687   5.054  67.050  1.00 13.26           C  
ATOM   1479  O   PHE A 182      43.601   4.224  66.147  1.00 15.66           O  
ATOM   1480  CB  PHE A 182      45.549   6.649  66.524  1.00 10.96           C  
ATOM   1481  CG  PHE A 182      45.914   7.681  65.498  1.00 10.99           C  
ATOM   1482  CD1 PHE A 182      45.697   9.041  65.744  1.00  7.65           C  
ATOM   1483  CD2 PHE A 182      46.417   7.293  64.263  1.00  6.58           C  
ATOM   1484  CE1 PHE A 182      45.971   9.994  64.771  1.00 10.23           C  
ATOM   1485  CE2 PHE A 182      46.695   8.244  63.282  1.00  8.45           C  
ATOM   1486  CZ  PHE A 182      46.468   9.596  63.538  1.00  9.75           C  
ATOM   1487  N   GLN A 183      43.483   4.730  68.317  1.00 15.44           N  
ATOM   1488  CA  GLN A 183      43.151   3.356  68.641  1.00 12.62           C  
ATOM   1489  C   GLN A 183      41.674   3.057  68.399  1.00 12.58           C  
ATOM   1490  O   GLN A 183      41.232   1.926  68.577  1.00 15.87           O  
ATOM   1491  CB  GLN A 183      43.582   3.014  70.077  1.00 13.58           C  
ATOM   1492  CG  GLN A 183      43.062   3.923  71.184  1.00 16.80           C  
ATOM   1493  CD  GLN A 183      41.693   3.511  71.723  1.00 19.16           C  
ATOM   1494  OE1 GLN A 183      41.500   2.377  72.172  1.00 18.41           O  
ATOM   1495  NE2 GLN A 183      40.743   4.442  71.699  1.00 19.66           N  
ATOM   1496  N   LEU A 184      40.910   4.070  67.988  1.00 11.47           N  
ATOM   1497  CA  LEU A 184      39.495   3.876  67.668  1.00  9.81           C  
ATOM   1498  C   LEU A 184      39.412   3.272  66.267  1.00 10.98           C  
ATOM   1499  O   LEU A 184      40.372   3.338  65.508  1.00 11.76           O  
ATOM   1500  CB  LEU A 184      38.729   5.204  67.701  1.00 10.38           C  
ATOM   1501  CG  LEU A 184      38.636   5.924  69.044  1.00 11.66           C  
ATOM   1502  CD1 LEU A 184      38.004   7.290  68.843  1.00 11.79           C  
ATOM   1503  CD2 LEU A 184      37.820   5.091  70.021  1.00 10.58           C  
ATOM   1504  N   PRO A 185      38.251   2.703  65.890  1.00 10.61           N  
ATOM   1505  CA  PRO A 185      38.070   2.083  64.572  1.00 12.56           C  
ATOM   1506  C   PRO A 185      37.883   3.064  63.425  1.00 12.49           C  
ATOM   1507  O   PRO A 185      37.255   2.743  62.415  1.00 14.27           O  
ATOM   1508  CB  PRO A 185      36.833   1.192  64.768  1.00  9.36           C  
ATOM   1509  CG  PRO A 185      36.671   1.103  66.265  1.00  7.95           C  
ATOM   1510  CD  PRO A 185      37.071   2.460  66.723  1.00 10.73           C  
ATOM   1511  N   VAL A 186      38.450   4.255  63.580  1.00 12.39           N  
ATOM   1512  CA  VAL A 186      38.344   5.296  62.575  1.00 12.51           C  
ATOM   1513  C   VAL A 186      39.415   5.149  61.502  1.00 12.71           C  
ATOM   1514  O   VAL A 186      40.287   4.281  61.597  1.00 13.58           O  
ATOM   1515  CB  VAL A 186      38.514   6.667  63.224  1.00 11.67           C  
ATOM   1516  CG1 VAL A 186      37.397   6.918  64.211  1.00 12.80           C  
ATOM   1517  CG2 VAL A 186      39.873   6.715  63.954  1.00 11.14           C  
ATOM   1518  N   ARG A 187      39.341   5.998  60.480  1.00 12.24           N  
ATOM   1519  CA  ARG A 187      40.346   6.000  59.424  1.00 11.69           C  
ATOM   1520  C   ARG A 187      41.460   6.882  59.995  1.00 12.21           C  
ATOM   1521  O   ARG A 187      41.188   7.840  60.721  1.00 11.64           O  
ATOM   1522  CB  ARG A 187      39.803   6.610  58.134  1.00 13.62           C  
ATOM   1523  CG  ARG A 187      40.593   6.202  56.900  1.00 15.03           C  
ATOM   1524  CD  ARG A 187      40.340   4.736  56.552  1.00 18.58           C  
ATOM   1525  NE  ARG A 187      38.946   4.499  56.176  1.00 19.21           N  
ATOM   1526  CZ  ARG A 187      38.407   4.884  55.023  1.00 20.63           C  
ATOM   1527  NH1 ARG A 187      39.143   5.517  54.128  1.00 21.36           N  
ATOM   1528  NH2 ARG A 187      37.125   4.656  54.772  1.00 21.55           N  
ATOM   1529  N   LYS A 188      42.705   6.563  59.655  1.00 12.00           N  
ATOM   1530  CA  LYS A 188      43.856   7.278  60.198  1.00 10.85           C  
ATOM   1531  C   LYS A 188      44.901   7.716  59.189  1.00 13.48           C  
ATOM   1532  O   LYS A 188      45.220   6.979  58.251  1.00 11.47           O  
ATOM   1533  CB  LYS A 188      44.545   6.379  61.223  1.00 12.42           C  
ATOM   1534  CG  LYS A 188      43.664   5.921  62.363  1.00 10.99           C  
ATOM   1535  CD  LYS A 188      44.353   4.812  63.136  1.00 17.27           C  
ATOM   1536  CE  LYS A 188      43.565   3.536  63.083  1.00 18.44           C  
ATOM   1537  NZ  LYS A 188      42.341   3.660  63.905  1.00 21.90           N  
ATOM   1538  N   ALA A 189      45.461   8.900  59.413  1.00 13.93           N  
ATOM   1539  CA  ALA A 189      46.512   9.433  58.558  1.00 12.99           C  
ATOM   1540  C   ALA A 189      47.444  10.234  59.445  1.00 14.73           C  
ATOM   1541  O   ALA A 189      47.014  10.800  60.456  1.00 13.12           O  
ATOM   1542  CB  ALA A 189      45.932  10.315  57.466  1.00 13.85           C  
ATOM   1543  N   CYS A 190      48.721  10.264  59.081  1.00 12.25           N  
ATOM   1544  CA  CYS A 190      49.718  10.993  59.858  1.00 10.57           C  
ATOM   1545  C   CYS A 190      50.817  11.587  58.976  1.00 10.04           C  
ATOM   1546  O   CYS A 190      50.933  11.245  57.804  1.00 12.17           O  
ATOM   1547  CB  CYS A 190      50.340  10.057  60.894  1.00 10.97           C  
ATOM   1548  SG  CYS A 190      51.262   8.695  60.177  1.00 12.90           S  
ATOM   1549  N   PRO A 191      51.622  12.510  59.529  1.00  8.88           N  
ATOM   1550  CA  PRO A 191      52.716  13.150  58.782  1.00 10.28           C  
ATOM   1551  C   PRO A 191      53.995  12.306  58.765  1.00 12.59           C  
ATOM   1552  O   PRO A 191      54.101  11.297  59.476  1.00 11.62           O  
ATOM   1553  CB  PRO A 191      52.894  14.478  59.506  1.00  9.86           C  
ATOM   1554  CG  PRO A 191      52.605  14.100  60.958  1.00  6.95           C  
ATOM   1555  CD  PRO A 191      51.368  13.206  60.806  1.00  8.20           C  
ATOM   1556  N   ALA A 192      54.969  12.738  57.973  1.00 13.17           N  
ATOM   1557  CA  ALA A 192      56.224  12.008  57.839  1.00 14.37           C  
ATOM   1558  C   ALA A 192      57.037  11.974  59.113  1.00 13.04           C  
ATOM   1559  O   ALA A 192      57.854  11.073  59.296  1.00 12.39           O  
ATOM   1560  CB  ALA A 192      57.063  12.603  56.706  1.00 15.66           C  
ATOM   1561  N   ASN A 193      56.826  12.951  59.991  1.00 10.68           N  
ATOM   1562  CA  ASN A 193      57.559  12.979  61.246  1.00 11.03           C  
ATOM   1563  C   ASN A 193      56.731  12.473  62.418  1.00 13.41           C  
ATOM   1564  O   ASN A 193      57.029  12.770  63.575  1.00 10.89           O  
ATOM   1565  CB  ASN A 193      58.109  14.398  61.526  1.00 13.09           C  
ATOM   1566  CG  ASN A 193      57.023  15.401  61.934  1.00 13.01           C  
ATOM   1567  OD1 ASN A 193      55.844  15.213  61.648  1.00 13.37           O  
ATOM   1568  ND2 ASN A 193      57.433  16.480  62.596  1.00 13.43           N  
ATOM   1569  N   ALA A 194      55.690  11.692  62.137  1.00 12.79           N  
ATOM   1570  CA  ALA A 194      54.881  11.171  63.237  1.00 12.74           C  
ATOM   1571  C   ALA A 194      55.663  10.041  63.907  1.00 12.60           C  
ATOM   1572  O   ALA A 194      56.568   9.468  63.298  1.00 13.68           O  
ATOM   1573  CB  ALA A 194      53.561  10.657  62.725  1.00 11.70           C  
ATOM   1574  N   THR A 195      55.318   9.734  65.154  1.00 12.89           N  
ATOM   1575  CA  THR A 195      55.986   8.665  65.896  1.00 11.76           C  
ATOM   1576  C   THR A 195      55.760   7.338  65.179  1.00 11.72           C  
ATOM   1577  O   THR A 195      54.783   7.178  64.458  1.00 12.88           O  
ATOM   1578  CB  THR A 195      55.464   8.533  67.364  1.00 12.58           C  
ATOM   1579  OG1 THR A 195      54.049   8.280  67.364  1.00 10.20           O  
ATOM   1580  CG2 THR A 195      55.762   9.806  68.184  1.00 10.74           C  
ATOM   1581  N   ASP A 196      56.672   6.393  65.380  1.00 10.60           N  
ATOM   1582  CA  ASP A 196      56.574   5.077  64.759  1.00 11.09           C  
ATOM   1583  C   ASP A 196      55.258   4.358  65.081  1.00 10.56           C  
ATOM   1584  O   ASP A 196      54.677   3.733  64.208  1.00  9.06           O  
ATOM   1585  CB  ASP A 196      57.729   4.179  65.215  1.00 10.80           C  
ATOM   1586  CG  ASP A 196      59.055   4.553  64.587  1.00 11.74           C  
ATOM   1587  OD1 ASP A 196      59.061   5.337  63.619  1.00 12.74           O  
ATOM   1588  OD2 ASP A 196      60.095   4.031  65.048  1.00 15.18           O  
ATOM   1589  N   ASN A 197      54.802   4.433  66.333  1.00  9.37           N  
ATOM   1590  CA  ASN A 197      53.565   3.741  66.716  1.00  9.35           C  
ATOM   1591  C   ASN A 197      52.326   4.272  66.024  1.00 10.83           C  
ATOM   1592  O   ASN A 197      51.414   3.508  65.728  1.00 11.31           O  
ATOM   1593  CB  ASN A 197      53.358   3.762  68.235  1.00 11.72           C  
ATOM   1594  CG  ASN A 197      54.187   2.699  68.950  1.00 12.16           C  
ATOM   1595  OD1 ASN A 197      55.066   2.076  68.351  1.00 12.05           O  
ATOM   1596  ND2 ASN A 197      53.911   2.490  70.237  1.00 11.17           N  
ATOM   1597  N   ILE A 198      52.287   5.583  65.791  1.00 12.16           N  
ATOM   1598  CA  ILE A 198      51.173   6.215  65.093  1.00 10.55           C  
ATOM   1599  C   ILE A 198      51.249   5.810  63.621  1.00 11.08           C  
ATOM   1600  O   ILE A 198      50.238   5.479  63.012  1.00 10.52           O  
ATOM   1601  CB  ILE A 198      51.239   7.752  65.208  1.00 10.63           C  
ATOM   1602  CG1 ILE A 198      50.767   8.189  66.602  1.00 12.15           C  
ATOM   1603  CG2 ILE A 198      50.425   8.410  64.075  1.00 10.15           C  
ATOM   1604  CD1 ILE A 198      49.273   7.933  66.893  1.00 14.32           C  
ATOM   1605  N   LYS A 199      52.449   5.816  63.047  1.00 10.58           N  
ATOM   1606  CA  LYS A 199      52.573   5.411  61.649  1.00 10.11           C  
ATOM   1607  C   LYS A 199      52.109   3.957  61.481  1.00  9.40           C  
ATOM   1608  O   LYS A 199      51.394   3.626  60.545  1.00 11.55           O  
ATOM   1609  CB  LYS A 199      54.024   5.524  61.183  1.00  9.00           C  
ATOM   1610  CG  LYS A 199      54.556   6.940  61.072  1.00 10.50           C  
ATOM   1611  CD  LYS A 199      55.974   6.904  60.534  1.00 13.30           C  
ATOM   1612  CE  LYS A 199      56.570   8.297  60.408  1.00 16.51           C  
ATOM   1613  NZ  LYS A 199      57.808   8.249  59.609  1.00 18.16           N  
ATOM   1614  N   ALA A 200      52.513   3.108  62.412  1.00 10.15           N  
ATOM   1615  CA  ALA A 200      52.192   1.680  62.390  1.00 10.23           C  
ATOM   1616  C   ALA A 200      50.712   1.352  62.246  1.00 11.35           C  
ATOM   1617  O   ALA A 200      50.356   0.349  61.624  1.00 12.21           O  
ATOM   1618  CB  ALA A 200      52.735   1.021  63.646  1.00  7.27           C  
ATOM   1619  N   VAL A 201      49.849   2.167  62.846  1.00 12.55           N  
ATOM   1620  CA  VAL A 201      48.409   1.930  62.770  1.00 12.64           C  
ATOM   1621  C   VAL A 201      47.670   2.858  61.789  1.00 13.17           C  
ATOM   1622  O   VAL A 201      46.457   2.749  61.625  1.00 15.89           O  
ATOM   1623  CB  VAL A 201      47.754   2.052  64.177  1.00 13.37           C  
ATOM   1624  CG1 VAL A 201      48.373   1.035  65.125  1.00 11.27           C  
ATOM   1625  CG2 VAL A 201      47.940   3.454  64.730  1.00 12.30           C  
ATOM   1626  N   SER A 202      48.393   3.753  61.120  1.00 13.20           N  
ATOM   1627  CA  SER A 202      47.770   4.687  60.176  1.00 11.37           C  
ATOM   1628  C   SER A 202      47.465   4.026  58.836  1.00 12.99           C  
ATOM   1629  O   SER A 202      48.185   3.122  58.418  1.00 15.18           O  
ATOM   1630  CB  SER A 202      48.689   5.902  59.938  1.00 14.51           C  
ATOM   1631  OG  SER A 202      48.859   6.685  61.117  1.00 13.26           O  
ATOM   1632  N   ASP A 203      46.393   4.473  58.181  1.00 11.20           N  
ATOM   1633  CA  ASP A 203      45.996   3.960  56.865  1.00 14.08           C  
ATOM   1634  C   ASP A 203      46.814   4.653  55.798  1.00 11.93           C  
ATOM   1635  O   ASP A 203      46.979   4.137  54.710  1.00 15.78           O  
ATOM   1636  CB  ASP A 203      44.519   4.226  56.573  1.00 11.49           C  
ATOM   1637  CG  ASP A 203      43.602   3.385  57.422  1.00 17.27           C  
ATOM   1638  OD1 ASP A 203      43.638   2.145  57.280  1.00 19.00           O  
ATOM   1639  OD2 ASP A 203      42.854   3.956  58.240  1.00 16.64           O  
ATOM   1640  N   PHE A 204      47.302   5.844  56.113  1.00 11.47           N  
ATOM   1641  CA  PHE A 204      48.112   6.592  55.169  1.00 12.98           C  
ATOM   1642  C   PHE A 204      49.156   7.411  55.925  1.00 12.60           C  
ATOM   1643  O   PHE A 204      48.842   8.150  56.860  1.00 12.93           O  
ATOM   1644  CB  PHE A 204      47.227   7.520  54.307  1.00 14.10           C  
ATOM   1645  CG  PHE A 204      47.995   8.303  53.259  1.00 15.61           C  
ATOM   1646  CD1 PHE A 204      48.550   7.665  52.162  1.00 16.06           C  
ATOM   1647  CD2 PHE A 204      48.188   9.672  53.395  1.00 14.62           C  
ATOM   1648  CE1 PHE A 204      49.293   8.375  51.211  1.00 17.26           C  
ATOM   1649  CE2 PHE A 204      48.926  10.392  52.457  1.00 16.61           C  
ATOM   1650  CZ  PHE A 204      49.485   9.743  51.358  1.00 16.05           C  
ATOM   1651  N   VAL A 205      50.403   7.249  55.520  1.00 12.08           N  
ATOM   1652  CA  VAL A 205      51.523   7.979  56.102  1.00 11.75           C  
ATOM   1653  C   VAL A 205      52.006   8.902  54.993  1.00 11.48           C  
ATOM   1654  O   VAL A 205      52.446   8.454  53.928  1.00  8.29           O  
ATOM   1655  CB  VAL A 205      52.668   7.038  56.518  1.00 14.43           C  
ATOM   1656  CG1 VAL A 205      53.857   7.871  57.007  1.00 13.14           C  
ATOM   1657  CG2 VAL A 205      52.192   6.093  57.614  1.00  9.73           C  
ATOM   1658  N   SER A 206      51.895  10.191  55.257  1.00 12.15           N  
ATOM   1659  CA  SER A 206      52.266  11.239  54.327  1.00 11.02           C  
ATOM   1660  C   SER A 206      53.778  11.368  54.159  1.00 13.64           C  
ATOM   1661  O   SER A 206      54.559  10.963  55.036  1.00 13.11           O  
ATOM   1662  CB  SER A 206      51.698  12.568  54.837  1.00 11.89           C  
ATOM   1663  OG  SER A 206      51.898  13.631  53.924  1.00 11.31           O  
ATOM   1664  N   ASP A 207      54.167  11.932  53.017  1.00 12.41           N  
ATOM   1665  CA  ASP A 207      55.558  12.198  52.688  1.00 13.67           C  
ATOM   1666  C   ASP A 207      55.908  13.592  53.208  1.00 12.94           C  
ATOM   1667  O   ASP A 207      57.059  14.000  53.123  1.00 15.44           O  
ATOM   1668  CB  ASP A 207      55.766  12.179  51.165  1.00 15.89           C  
ATOM   1669  CG  ASP A 207      55.404  10.843  50.534  1.00 18.31           C  
ATOM   1670  OD1 ASP A 207      56.028   9.825  50.901  1.00 21.99           O  
ATOM   1671  OD2 ASP A 207      54.500  10.813  49.673  1.00 18.23           O  
ATOM   1672  N   TYR A 208      54.912  14.315  53.737  1.00 13.83           N  
ATOM   1673  CA  TYR A 208      55.106  15.682  54.259  1.00 11.11           C  
ATOM   1674  C   TYR A 208      54.759  15.826  55.740  1.00 11.94           C  
ATOM   1675  O   TYR A 208      54.133  14.937  56.342  1.00 10.82           O  
ATOM   1676  CB  TYR A 208      54.238  16.689  53.484  1.00 11.53           C  
ATOM   1677  CG  TYR A 208      54.413  16.649  51.984  1.00 12.08           C  
ATOM   1678  CD1 TYR A 208      55.412  17.390  51.359  1.00 13.69           C  
ATOM   1679  CD2 TYR A 208      53.622  15.816  51.201  1.00 13.27           C  
ATOM   1680  CE1 TYR A 208      55.624  17.292  49.973  1.00 16.58           C  
ATOM   1681  CE2 TYR A 208      53.825  15.709  49.828  1.00 14.94           C  
ATOM   1682  CZ  TYR A 208      54.830  16.445  49.226  1.00 15.97           C  
ATOM   1683  OH  TYR A 208      55.064  16.288  47.880  1.00 21.02           O  
ATOM   1684  N   SER A 209      55.140  16.973  56.302  1.00  9.36           N  
ATOM   1685  CA  SER A 209      54.889  17.300  57.707  1.00 10.89           C  
ATOM   1686  C   SER A 209      54.698  18.817  57.839  1.00 11.00           C  
ATOM   1687  O   SER A 209      54.711  19.539  56.852  1.00 13.59           O  
ATOM   1688  CB  SER A 209      56.092  16.914  58.572  1.00  9.21           C  
ATOM   1689  OG  SER A 209      56.401  15.548  58.463  1.00 11.11           O  
ATOM   1690  N   TYR A 210      54.548  19.297  59.071  1.00 12.58           N  
ATOM   1691  CA  TYR A 210      54.400  20.728  59.310  1.00 11.45           C  
ATOM   1692  C   TYR A 210      53.274  21.398  58.538  1.00 10.18           C  
ATOM   1693  O   TYR A 210      53.400  22.551  58.124  1.00 11.41           O  
ATOM   1694  CB  TYR A 210      55.722  21.439  58.999  1.00 14.48           C  
ATOM   1695  CG  TYR A 210      56.809  21.105  59.990  1.00 16.13           C  
ATOM   1696  CD1 TYR A 210      56.632  21.358  61.354  1.00 16.35           C  
ATOM   1697  CD2 TYR A 210      58.003  20.507  59.576  1.00 18.68           C  
ATOM   1698  CE1 TYR A 210      57.610  21.026  62.284  1.00 15.14           C  
ATOM   1699  CE2 TYR A 210      58.996  20.168  60.503  1.00 18.88           C  
ATOM   1700  CZ  TYR A 210      58.789  20.431  61.854  1.00 17.07           C  
ATOM   1701  OH  TYR A 210      59.756  20.100  62.770  1.00 15.18           O  
ATOM   1702  N   GLY A 211      52.174  20.675  58.349  1.00  8.19           N  
ATOM   1703  CA  GLY A 211      51.034  21.238  57.655  1.00  7.56           C  
ATOM   1704  C   GLY A 211      50.872  20.790  56.216  1.00  9.25           C  
ATOM   1705  O   GLY A 211      49.755  20.786  55.707  1.00 11.08           O  
ATOM   1706  N   GLU A 212      51.966  20.413  55.565  1.00 11.23           N  
ATOM   1707  CA  GLU A 212      51.894  19.975  54.173  1.00 11.82           C  
ATOM   1708  C   GLU A 212      51.355  18.546  54.001  1.00 10.94           C  
ATOM   1709  O   GLU A 212      51.129  18.092  52.880  1.00 12.97           O  
ATOM   1710  CB  GLU A 212      53.263  20.127  53.486  1.00 17.65           C  
ATOM   1711  CG  GLU A 212      53.722  21.587  53.364  1.00 20.18           C  
ATOM   1712  CD  GLU A 212      54.866  21.811  52.371  1.00 22.65           C  
ATOM   1713  OE1 GLU A 212      55.505  22.885  52.440  1.00 20.80           O  
ATOM   1714  OE2 GLU A 212      55.120  20.934  51.515  1.00 23.97           O  
ATOM   1715  N   GLU A 213      51.139  17.837  55.102  1.00 11.41           N  
ATOM   1716  CA  GLU A 213      50.579  16.487  55.018  1.00 11.37           C  
ATOM   1717  C   GLU A 213      49.048  16.558  54.809  1.00 11.83           C  
ATOM   1718  O   GLU A 213      48.440  15.628  54.292  1.00 13.96           O  
ATOM   1719  CB  GLU A 213      50.875  15.696  56.309  1.00 10.84           C  
ATOM   1720  CG  GLU A 213      50.102  16.173  57.548  1.00  9.31           C  
ATOM   1721  CD  GLU A 213      50.892  17.137  58.423  1.00 12.42           C  
ATOM   1722  OE1 GLU A 213      51.515  18.060  57.863  1.00 15.18           O  
ATOM   1723  OE2 GLU A 213      50.891  16.978  59.669  1.00 10.60           O  
ATOM   1724  N   ILE A 214      48.418  17.657  55.222  1.00 13.15           N  
ATOM   1725  CA  ILE A 214      46.968  17.787  55.086  1.00 10.24           C  
ATOM   1726  C   ILE A 214      46.521  17.696  53.626  1.00 12.00           C  
ATOM   1727  O   ILE A 214      45.633  16.904  53.287  1.00 11.41           O  
ATOM   1728  CB  ILE A 214      46.462  19.124  55.699  1.00 11.88           C  
ATOM   1729  CG1 ILE A 214      46.942  19.263  57.153  1.00 10.03           C  
ATOM   1730  CG2 ILE A 214      44.963  19.190  55.613  1.00  8.14           C  
ATOM   1731  CD1 ILE A 214      46.592  18.071  58.071  1.00 13.58           C  
ATOM   1732  N   GLY A 215      47.144  18.490  52.763  1.00 12.37           N  
ATOM   1733  CA  GLY A 215      46.790  18.461  51.349  1.00 13.18           C  
ATOM   1734  C   GLY A 215      46.970  17.089  50.712  1.00 11.66           C  
ATOM   1735  O   GLY A 215      46.126  16.618  49.962  1.00 13.13           O  
ATOM   1736  N   GLN A 216      48.077  16.424  51.010  1.00 15.07           N  
ATOM   1737  CA  GLN A 216      48.316  15.114  50.427  1.00 11.44           C  
ATOM   1738  C   GLN A 216      47.373  14.073  51.036  1.00 11.05           C  
ATOM   1739  O   GLN A 216      46.924  13.159  50.353  1.00 10.85           O  
ATOM   1740  CB  GLN A 216      49.774  14.696  50.629  1.00 11.07           C  
ATOM   1741  CG  GLN A 216      50.133  13.423  49.882  1.00 13.05           C  
ATOM   1742  CD  GLN A 216      51.498  12.871  50.279  1.00 15.85           C  
ATOM   1743  OE1 GLN A 216      51.850  12.835  51.464  1.00 12.47           O  
ATOM   1744  NE2 GLN A 216      52.260  12.419  49.291  1.00 12.02           N  
ATOM   1745  N   ILE A 217      47.068  14.205  52.326  1.00 12.20           N  
ATOM   1746  CA  ILE A 217      46.160  13.268  52.970  1.00 11.21           C  
ATOM   1747  C   ILE A 217      44.788  13.360  52.300  1.00 12.69           C  
ATOM   1748  O   ILE A 217      44.237  12.357  51.859  1.00 15.74           O  
ATOM   1749  CB  ILE A 217      46.028  13.564  54.497  1.00 10.52           C  
ATOM   1750  CG1 ILE A 217      47.323  13.151  55.211  1.00 10.57           C  
ATOM   1751  CG2 ILE A 217      44.805  12.863  55.066  1.00 11.19           C  
ATOM   1752  CD1 ILE A 217      47.385  13.477  56.736  1.00 12.06           C  
ATOM   1753  N   PHE A 218      44.245  14.568  52.213  1.00 13.09           N  
ATOM   1754  CA  PHE A 218      42.944  14.780  51.594  1.00 13.23           C  
ATOM   1755  C   PHE A 218      42.921  14.308  50.141  1.00 17.04           C  
ATOM   1756  O   PHE A 218      41.924  13.758  49.675  1.00 18.33           O  
ATOM   1757  CB  PHE A 218      42.558  16.266  51.674  1.00 13.41           C  
ATOM   1758  CG  PHE A 218      42.271  16.756  53.078  1.00 14.37           C  
ATOM   1759  CD1 PHE A 218      41.909  15.866  54.083  1.00 11.91           C  
ATOM   1760  CD2 PHE A 218      42.306  18.120  53.377  1.00 14.77           C  
ATOM   1761  CE1 PHE A 218      41.586  16.314  55.357  1.00 11.65           C  
ATOM   1762  CE2 PHE A 218      41.982  18.581  54.652  1.00 13.50           C  
ATOM   1763  CZ  PHE A 218      41.621  17.679  55.644  1.00 13.25           C  
ATOM   1764  N   LYS A 219      44.014  14.514  49.420  1.00 18.44           N  
ATOM   1765  CA  LYS A 219      44.055  14.080  48.033  1.00 20.95           C  
ATOM   1766  C   LYS A 219      44.029  12.552  47.981  1.00 20.15           C  
ATOM   1767  O   LYS A 219      43.409  11.968  47.103  1.00 22.84           O  
ATOM   1768  CB  LYS A 219      45.298  14.639  47.328  1.00 24.99           C  
ATOM   1769  CG  LYS A 219      45.240  16.157  47.121  1.00 32.27           C  
ATOM   1770  CD  LYS A 219      46.385  16.691  46.259  1.00 38.10           C  
ATOM   1771  CE  LYS A 219      47.735  16.522  46.947  1.00 42.59           C  
ATOM   1772  NZ  LYS A 219      48.822  17.252  46.225  1.00 45.20           N  
ATOM   1773  N   HIS A 220      44.680  11.906  48.941  1.00 18.20           N  
ATOM   1774  CA  HIS A 220      44.705  10.447  48.979  1.00 17.39           C  
ATOM   1775  C   HIS A 220      43.321   9.848  49.225  1.00 17.31           C  
ATOM   1776  O   HIS A 220      42.934   8.862  48.596  1.00 18.38           O  
ATOM   1777  CB  HIS A 220      45.696   9.970  50.039  1.00 17.57           C  
ATOM   1778  CG  HIS A 220      45.684   8.491  50.258  1.00 16.14           C  
ATOM   1779  ND1 HIS A 220      44.820   7.879  51.141  1.00 18.80           N  
ATOM   1780  CD2 HIS A 220      46.398   7.498  49.679  1.00 14.81           C  
ATOM   1781  CE1 HIS A 220      45.005   6.571  51.099  1.00 16.18           C  
ATOM   1782  NE2 HIS A 220      45.957   6.315  50.221  1.00 16.12           N  
ATOM   1783  N   PHE A 221      42.560  10.447  50.130  1.00 17.79           N  
ATOM   1784  CA  PHE A 221      41.227   9.952  50.422  1.00 17.24           C  
ATOM   1785  C   PHE A 221      40.183  10.557  49.489  1.00 18.64           C  
ATOM   1786  O   PHE A 221      38.979  10.427  49.719  1.00 18.99           O  
ATOM   1787  CB  PHE A 221      40.893  10.234  51.886  1.00 16.45           C  
ATOM   1788  CG  PHE A 221      41.694   9.398  52.847  1.00 13.78           C  
ATOM   1789  CD1 PHE A 221      41.479   8.020  52.931  1.00 15.26           C  
ATOM   1790  CD2 PHE A 221      42.683   9.971  53.637  1.00 11.42           C  
ATOM   1791  CE1 PHE A 221      42.238   7.230  53.782  1.00 15.68           C  
ATOM   1792  CE2 PHE A 221      43.447   9.198  54.495  1.00 12.23           C  
ATOM   1793  CZ  PHE A 221      43.229   7.817  54.574  1.00 15.61           C  
ATOM   1794  N   GLU A 222      40.660  11.210  48.434  1.00 19.39           N  
ATOM   1795  CA  GLU A 222      39.794  11.843  47.439  1.00 24.25           C  
ATOM   1796  C   GLU A 222      38.842  12.874  48.032  1.00 23.76           C  
ATOM   1797  O   GLU A 222      37.698  12.984  47.606  1.00 23.88           O  
ATOM   1798  CB  GLU A 222      38.984  10.784  46.690  1.00 29.18           C  
ATOM   1799  CG  GLU A 222      39.833   9.778  45.942  1.00 36.09           C  
ATOM   1800  CD  GLU A 222      39.039   9.016  44.900  1.00 41.49           C  
ATOM   1801  OE1 GLU A 222      38.008   8.406  45.260  1.00 45.64           O  
ATOM   1802  OE2 GLU A 222      39.447   9.029  43.717  1.00 45.70           O  
ATOM   1803  N   LEU A 223      39.324  13.638  49.009  1.00 23.53           N  
ATOM   1804  CA  LEU A 223      38.498  14.642  49.667  1.00 23.19           C  
ATOM   1805  C   LEU A 223      38.781  16.024  49.125  1.00 25.99           C  
ATOM   1806  O   LEU A 223      38.094  16.987  49.452  1.00 23.19           O  
ATOM   1807  CB  LEU A 223      38.762  14.632  51.174  1.00 20.43           C  
ATOM   1808  CG  LEU A 223      38.494  13.295  51.860  1.00 17.71           C  
ATOM   1809  CD1 LEU A 223      38.882  13.352  53.320  1.00 17.71           C  
ATOM   1810  CD2 LEU A 223      37.035  12.957  51.705  1.00 13.37           C  
HETATM 1811  N   MSE A 224      39.772  16.120  48.255  1.00 31.80           N  
HETATM 1812  CA  MSE A 224      40.138  17.422  47.750  1.00 36.69           C  
HETATM 1813  C   MSE A 224      40.936  17.331  46.457  1.00 38.82           C  
HETATM 1814  O   MSE A 224      40.327  17.010  45.411  1.00 41.35           O  
HETATM 1815  OXT MSE A 224      42.158  17.574  46.506  1.00 41.58           O  
HETATM 1816  CB  MSE A 224      40.944  18.099  48.851  1.00 35.67           C  
HETATM 1817  CG  MSE A 224      41.470  19.454  48.565  1.00 38.02           C  
HETATM 1818 SE   MSE A 224      43.104  19.521  49.536  1.00 38.13          SE  
HETATM 1819  CE  MSE A 224      44.270  20.046  48.092  1.00 38.87           C  
TER    1820      MSE A 224                                                      
END
MOLECULE T0505.pdb
ATOM      1  N   LYS     6      34.876   8.083  54.296  1.00 32.10           N  
ATOM      2  CA  LYS     6      35.022   8.794  55.595  1.00 30.60           C  
ATOM      3  C   LYS     6      34.171  10.050  55.575  1.00 30.04           C  
ATOM      4  O   LYS     6      33.987  10.662  54.513  1.00 31.08           O  
ATOM      5  CB  LYS     6      36.491   9.159  55.851  1.00 31.17           C  
ATOM      6  CG  LYS     6      37.392   7.952  56.020  1.00 33.54           C  
ATOM      7  CD  LYS     6      37.138   7.255  57.363  1.00 35.57           C  
ATOM      8  CE  LYS     6      38.133   6.150  57.642  1.00 36.27           C  
ATOM      9  NZ  LYS     6      37.853   4.949  56.798  1.00 38.14           N  
ATOM     10  N   GLN     7      33.690  10.451  56.753  1.00 27.59           N  
ATOM     11  CA  GLN     7      32.685  11.487  56.895  0.50 26.89           C  
ATOM     13  C   GLN     7      33.138  12.631  57.799  1.00 25.56           C  
ATOM     14  O   GLN     7      32.526  13.695  57.807  1.00 25.38           O  
ATOM     15  CB  GLN     7      31.426  10.868  57.485  0.50 26.93           C  
ATOM     17  CG  GLN     7      30.647  10.009  56.503  0.50 28.57           C  
ATOM     19  CD  GLN     7      29.661  10.836  55.717  0.50 29.35           C  
ATOM     21  OE1 GLN     7      29.854  11.087  54.530  0.50 30.06           O  
ATOM     23  NE2 GLN     7      28.612  11.308  56.395  0.50 29.45           N  
ATOM     25  N   LEU     8      34.200  12.400  58.577  0.50 24.45           N  
ATOM     27  CA  LEU     8      34.661  13.377  59.583  0.50 23.92           C  
ATOM     29  C   LEU     8      36.187  13.456  59.657  0.50 23.34           C  
ATOM     31  O   LEU     8      36.847  12.452  59.952  0.50 23.15           O  
ATOM     33  CB  LEU     8      34.101  13.028  60.972  0.50 24.05           C  
ATOM     35  CG  LEU     8      34.601  13.825  62.197  0.50 24.47           C  
ATOM     37  CD1 LEU     8      34.433  15.330  62.006  0.50 23.47           C  
ATOM     39  CD2 LEU     8      33.919  13.376  63.497  0.50 23.31           C  
ATOM     41  N   LEU     9      36.730  14.650  59.413  1.00 23.12           N  
ATOM     42  CA  LEU     9      38.176  14.891  59.468  1.00 23.12           C  
ATOM     43  C   LEU     9      38.484  15.724  60.712  1.00 22.53           C  
ATOM     44  O   LEU     9      37.954  16.839  60.871  1.00 23.46           O  
ATOM     45  CB  LEU     9      38.656  15.617  58.198  1.00 23.25           C  
ATOM     46  CG  LEU     9      40.093  16.142  58.238  1.00 25.00           C  
ATOM     47  CD1 LEU     9      41.072  14.935  58.280  1.00 26.13           C  
ATOM     48  CD2 LEU     9      40.418  17.054  57.039  1.00 24.10           C  
ATOM     49  N   ALA    10      39.282  15.171  61.620  1.00 22.09           N  
ATOM     50  CA  ALA    10      39.697  15.881  62.836  1.00 23.55           C  
ATOM     51  C   ALA    10      41.197  16.143  62.812  1.00 24.22           C  
ATOM     52  O   ALA    10      41.973  15.196  62.631  1.00 24.53           O  
ATOM     53  CB  ALA    10      39.325  15.052  64.049  1.00 25.36           C  
ATOM     54  N   LEU    11      41.581  17.415  62.969  1.00 23.75           N  
ATOM     55  CA  LEU    11      42.967  17.843  62.829  0.50 23.98           C  
ATOM     57  C   LEU    11      43.477  18.526  64.105  1.00 23.85           C  
ATOM     58  O   LEU    11      42.800  19.360  64.673  1.00 23.47           O  
ATOM     59  CB  LEU    11      43.102  18.860  61.664  0.50 24.46           C  
ATOM     61  CG  LEU    11      42.423  18.598  60.316  0.50 24.12           C  
ATOM     63  CD1 LEU    11      41.927  19.862  59.697  0.50 27.02           C  
ATOM     65  CD2 LEU    11      43.374  17.912  59.348  0.50 26.73           C  
ATOM     67  N   ASN    12      44.706  18.206  64.500  1.00 23.73           N  
ATOM     68  CA  ASN    12      45.425  19.070  65.448  1.00 23.73           C  
ATOM     69  C   ASN    12      45.664  20.434  64.786  1.00 23.97           C  
ATOM     70  O   ASN    12      45.753  20.542  63.562  1.00 23.62           O  
ATOM     71  CB  ASN    12      46.846  18.547  65.770  1.00 23.79           C  
ATOM     72  CG  ASN    12      46.888  17.356  66.714  1.00 25.38           C  
ATOM     73  OD1 ASN    12      47.905  16.688  66.770  1.00 26.57           O  
ATOM     74  ND2 ASN    12      45.834  17.118  67.483  1.00 25.65           N  
ATOM     75  N   ILE    13      45.828  21.453  65.605  1.00 23.30           N  
ATOM     76  CA  ILE    13      46.238  22.768  65.137  1.00 23.99           C  
ATOM     77  C   ILE    13      47.789  22.837  65.112  1.00 23.85           C  
ATOM     78  O   ILE    13      48.420  22.815  64.037  1.00 23.87           O  
ATOM     79  CB  ILE    13      45.632  23.862  66.060  1.00 22.93           C  
ATOM     80  CG1 ILE    13      44.086  23.825  65.985  1.00 24.81           C  
ATOM     81  CG2 ILE    13      46.199  25.239  65.708  1.00 23.98           C  
ATOM     82  CD1 ILE    13      43.379  24.872  66.896  1.00 24.97           C  
ATOM     83  N   ASP    14      48.402  22.882  66.293  1.00 24.30           N  
ATOM     84  CA  ASP    14      49.864  22.869  66.407  1.00 24.52           C  
ATOM     85  C   ASP    14      50.378  21.560  65.861  1.00 24.12           C  
ATOM     86  O   ASP    14      49.775  20.505  66.099  1.00 24.08           O  
ATOM     87  CB  ASP    14      50.303  23.017  67.872  1.00 25.34           C  
ATOM     88  CG  ASP    14      49.842  24.344  68.475  1.00 27.52           C  
ATOM     89  OD1 ASP    14      50.553  25.363  68.292  1.00 29.57           O  
ATOM     90  OD2 ASP    14      48.759  24.366  69.108  1.00 29.16           O  
ATOM     91  N   GLY    15      51.474  21.643  65.104  1.00 24.35           N  
ATOM     92  CA  GLY    15      52.109  20.442  64.523  1.00 24.03           C  
ATOM     93  C   GLY    15      51.370  19.759  63.375  1.00 24.06           C  
ATOM     94  O   GLY    15      51.829  18.728  62.915  1.00 24.44           O  
ATOM     95  N   ALA    16      50.237  20.303  62.919  1.00 24.06           N  
ATOM     96  CA  ALA    16      49.507  19.703  61.805  1.00 25.16           C  
ATOM     97  C   ALA    16      48.940  20.748  60.833  1.00 25.27           C  
ATOM     98  O   ALA    16      49.489  20.959  59.745  1.00 26.24           O  
ATOM     99  CB  ALA    16      48.424  18.744  62.299  1.00 25.08           C  
ATOM    100  N   LEU    17      47.865  21.415  61.239  1.00 24.72           N  
ATOM    101  CA  LEU    17      47.293  22.507  60.467  0.50 24.60           C  
ATOM    103  C   LEU    17      48.303  23.653  60.282  1.00 24.79           C  
ATOM    104  O   LEU    17      48.373  24.261  59.223  1.00 24.69           O  
ATOM    105  CB  LEU    17      46.048  23.045  61.188  0.50 24.67           C  
ATOM    107  CG  LEU    17      45.298  24.166  60.484  0.50 22.73           C  
ATOM    109  CD1 LEU    17      44.590  23.620  59.290  0.50 21.17           C  
ATOM    111  CD2 LEU    17      44.307  24.780  61.426  0.50 24.59           C  
ATOM    113  N   LEU    18      49.063  23.947  61.328  1.00 24.24           N  
ATOM    114  CA  LEU    18      49.948  25.112  61.313  1.00 24.06           C  
ATOM    115  C   LEU    18      51.362  24.684  61.027  1.00 23.97           C  
ATOM    116  O   LEU    18      51.832  23.682  61.581  1.00 23.46           O  
ATOM    117  CB  LEU    18      49.979  25.804  62.674  1.00 24.49           C  
ATOM    118  CG  LEU    18      48.695  26.396  63.242  1.00 26.89           C  
ATOM    119  CD1 LEU    18      49.022  27.243  64.441  1.00 28.82           C  
ATOM    120  CD2 LEU    18      47.977  27.204  62.171  1.00 30.68           C  
ATOM    121  N   ARG    19      52.048  25.466  60.196  1.00 22.83           N  
ATOM    122  CA  ARG    19      53.493  25.358  60.033  1.00 22.38           C  
ATOM    123  C   ARG    19      54.177  25.715  61.348  1.00 23.88           C  
ATOM    124  O   ARG    19      53.533  26.298  62.230  1.00 24.58           O  
ATOM    125  CB  ARG    19      53.948  26.318  58.936  1.00 21.76           C  
ATOM    126  CG  ARG    19      53.468  25.901  57.548  1.00 22.17           C  
ATOM    127  CD  ARG    19      53.934  26.920  56.486  1.00 22.97           C  
ATOM    128  NE  ARG    19      55.382  27.057  56.473  1.00 26.02           N  
ATOM    129  CZ  ARG    19      56.201  26.234  55.821  1.00 26.76           C  
ATOM    130  NH1 ARG    19      55.711  25.222  55.115  1.00 24.02           N  
ATOM    131  NH2 ARG    19      57.517  26.439  55.854  1.00 27.49           N  
ATOM    132  N   SER    20      55.474  25.442  61.480  1.00 23.98           N  
ATOM    133  CA  SER    20      56.170  25.724  62.749  0.50 24.69           C  
ATOM    135  C   SER    20      56.314  27.208  63.018  1.00 25.45           C  
ATOM    136  O   SER    20      56.571  27.609  64.158  1.00 27.08           O  
ATOM    137  CB  SER    20      57.532  25.038  62.816  0.50 24.83           C  
ATOM    139  OG  SER    20      58.378  25.470  61.782  0.50 22.79           O  
ATOM    141  N   ASN    21      56.145  28.033  61.990  1.00 25.31           N  
ATOM    142  CA  ASN    21      56.128  29.493  62.202  1.00 26.85           C  
ATOM    143  C   ASN    21      54.719  30.047  62.494  1.00 27.13           C  
ATOM    144  O   ASN    21      54.530  31.272  62.574  1.00 28.54           O  
ATOM    145  CB  ASN    21      56.766  30.217  61.013  1.00 27.65           C  
ATOM    146  CG  ASN    21      55.984  30.014  59.721  1.00 29.55           C  
ATOM    147  OD1 ASN    21      54.897  29.445  59.739  1.00 28.27           O  
ATOM    148  ND2 ASN    21      56.549  30.460  58.590  1.00 31.07           N  
ATOM    149  N   GLY    22      53.737  29.163  62.628  1.00 25.53           N  
ATOM    150  CA  GLY    22      52.387  29.527  63.002  1.00 25.70           C  
ATOM    151  C   GLY    22      51.485  29.910  61.853  1.00 25.79           C  
ATOM    152  O   GLY    22      50.292  30.178  62.058  1.00 27.47           O  
ATOM    153  N   LYS    23      52.021  29.911  60.645  1.00 24.24           N  
ATOM    154  CA  LYS    23      51.223  30.238  59.465  1.00 25.66           C  
ATOM    155  C   LYS    23      50.427  29.032  58.983  1.00 25.17           C  
ATOM    156  O   LYS    23      50.855  27.911  59.153  1.00 24.56           O  
ATOM    157  CB  LYS    23      52.117  30.762  58.330  1.00 25.43           C  
ATOM    158  CG  LYS    23      52.785  32.105  58.702  1.00 27.84           C  
ATOM    159  CD  LYS    23      53.244  32.848  57.454  1.00 30.68           C  
ATOM    160  CE  LYS    23      53.760  34.234  57.782  1.00 28.94           C  
ATOM    161  NZ  LYS    23      52.715  35.300  57.751  1.00 29.37           N  
ATOM    162  N   ILE    24      49.249  29.288  58.406  1.00 25.05           N  
ATOM    163  CA  ILE    24      48.492  28.250  57.692  1.00 24.61           C  
ATOM    164  C   ILE    24      48.836  28.392  56.223  1.00 24.55           C  
ATOM    165  O   ILE    24      48.561  29.435  55.618  1.00 23.98           O  
ATOM    166  CB  ILE    24      46.968  28.406  57.879  1.00 24.43           C  
ATOM    167  CG1 ILE    24      46.617  28.469  59.371  1.00 26.44           C  
ATOM    168  CG2 ILE    24      46.215  27.250  57.165  1.00 26.26           C  
ATOM    169  CD1 ILE    24      45.173  28.887  59.631  1.00 28.57           C  
ATOM    170  N   HIS    25      49.450  27.361  55.639  1.00 23.24           N  
ATOM    171  CA  HIS    25      49.853  27.392  54.219  1.00 23.46           C  
ATOM    172  C   HIS    25      48.615  27.448  53.296  1.00 23.13           C  
ATOM    173  O   HIS    25      47.581  26.857  53.600  1.00 22.32           O  
ATOM    174  CB  HIS    25      50.711  26.150  53.888  1.00 23.35           C  
ATOM    175  CG  HIS    25      51.489  26.271  52.617  1.00 24.93           C  
ATOM    176  ND1 HIS    25      50.970  25.915  51.391  1.00 25.91           N  
ATOM    177  CD2 HIS    25      52.750  26.707  52.383  1.00 25.47           C  
ATOM    178  CE1 HIS    25      51.877  26.134  50.452  1.00 29.41           C  
ATOM    179  NE2 HIS    25      52.966  26.617  51.029  1.00 27.47           N  
ATOM    180  N   GLN    26      48.711  28.178  52.186  1.00 23.33           N  
ATOM    181  CA  GLN    26      47.586  28.242  51.235  1.00 24.16           C  
ATOM    182  C   GLN    26      47.101  26.853  50.791  1.00 23.73           C  
ATOM    183  O   GLN    26      45.909  26.616  50.628  1.00 23.72           O  
ATOM    184  CB  GLN    26      47.951  29.079  50.005  1.00 25.56           C  
ATOM    185  CG  GLN    26      46.757  29.297  49.048  1.00 27.94           C  
ATOM    186  CD  GLN    26      45.643  30.104  49.695  1.00 29.07           C  
ATOM    187  OE1 GLN    26      45.884  31.167  50.253  1.00 31.50           O  
ATOM    188  NE2 GLN    26      44.424  29.598  49.627  1.00 31.03           N  
ATOM    189  N   ALA    27      48.026  25.925  50.620  1.00 23.38           N  
ATOM    190  CA  ALA    27      47.657  24.552  50.203  1.00 23.29           C  
ATOM    191  C   ALA    27      46.735  23.850  51.206  1.00 22.81           C  
ATOM    192  O   ALA    27      45.839  23.056  50.834  1.00 23.09           O  
ATOM    193  CB  ALA    27      48.915  23.708  49.930  1.00 22.66           C  
ATOM    194  N   THR    28      46.933  24.179  52.474  1.00 22.59           N  
ATOM    195  CA  THR    28      46.164  23.629  53.542  1.00 22.61           C  
ATOM    196  C   THR    28      44.731  24.189  53.494  1.00 22.57           C  
ATOM    197  O   THR    28      43.758  23.433  53.647  1.00 21.44           O  
ATOM    198  CB  THR    28      46.837  23.968  54.896  1.00 22.91           C  
ATOM    199  OG1 THR    28      48.216  23.533  54.845  1.00 24.83           O  
ATOM    200  CG2 THR    28      46.126  23.252  56.001  1.00 22.58           C  
ATOM    201  N   LYS    29      44.627  25.501  53.288  1.00 22.30           N  
ATOM    202  CA  LYS    29      43.359  26.181  53.109  1.00 23.06           C  
ATOM    203  C   LYS    29      42.612  25.581  51.924  1.00 23.15           C  
ATOM    204  O   LYS    29      41.420  25.279  52.029  1.00 22.86           O  
ATOM    205  CB  LYS    29      43.599  27.683  52.910  1.00 23.25           C  
ATOM    206  CG  LYS    29      44.128  28.315  54.166  1.00 26.35           C  
ATOM    207  CD  LYS    29      44.230  29.796  54.031  1.00 31.59           C  
ATOM    208  CE  LYS    29      44.681  30.363  55.349  1.00 34.35           C  
ATOM    209  NZ  LYS    29      44.844  31.817  55.183  1.00 37.71           N  
ATOM    210  N   ASP    30      43.318  25.381  50.805  1.00 23.81           N  
ATOM    211  CA  ASP    30      42.702  24.826  49.608  1.00 24.01           C  
ATOM    212  C   ASP    30      42.220  23.391  49.847  1.00 23.94           C  
ATOM    213  O   ASP    30      41.125  23.013  49.411  1.00 23.20           O  
ATOM    214  CB  ASP    30      43.652  24.895  48.400  1.00 24.83           C  
ATOM    215  CG  ASP    30      44.001  26.344  47.987  1.00 28.08           C  
ATOM    216  OD1 ASP    30      43.319  27.297  48.421  1.00 31.03           O  
ATOM    217  OD2 ASP    30      44.973  26.531  47.207  1.00 30.74           O  
ATOM    218  N   ALA    31      43.032  22.600  50.554  1.00 22.91           N  
ATOM    219  CA  ALA    31      42.656  21.219  50.851  1.00 23.25           C  
ATOM    220  C   ALA    31      41.406  21.159  51.735  1.00 22.86           C  
ATOM    221  O   ALA    31      40.491  20.378  51.456  1.00 23.53           O  
ATOM    222  CB  ALA    31      43.832  20.452  51.501  1.00 22.70           C  
ATOM    223  N   ILE    32      41.345  22.004  52.763  1.00 22.86           N  
ATOM    224  CA  ILE    32      40.174  22.022  53.676  1.00 24.08           C  
ATOM    225  C   ILE    32      38.897  22.482  52.960  1.00 24.09           C  
ATOM    226  O   ILE    32      37.834  21.899  53.157  1.00 23.39           O  
ATOM    227  CB  ILE    32      40.478  22.819  54.970  1.00 24.17           C  
ATOM    228  CG1 ILE    32      41.480  22.018  55.828  1.00 26.95           C  
ATOM    229  CG2 ILE    32      39.216  23.101  55.802  1.00 25.00           C  
ATOM    230  CD1 ILE    32      42.097  22.820  56.869  1.00 33.14           C  
ATOM    231  N   GLU    33      39.009  23.502  52.110  1.00 25.36           N  
ATOM    232  CA  GLU    33      37.880  23.960  51.299  1.00 27.05           C  
ATOM    233  C   GLU    33      37.351  22.819  50.425  1.00 26.16           C  
ATOM    234  O   GLU    33      36.147  22.583  50.344  1.00 26.64           O  
ATOM    235  CB  GLU    33      38.326  25.123  50.405  1.00 27.23           C  
ATOM    236  CG  GLU    33      37.236  25.620  49.481  1.00 29.62           C  
ATOM    237  CD  GLU    33      37.638  26.869  48.708  1.00 32.79           C  
ATOM    238  OE1 GLU    33      38.853  27.052  48.407  1.00 39.72           O  
ATOM    239  OE2 GLU    33      36.724  27.664  48.377  1.00 40.81           O  
ATOM    240  N   TYR    34      38.261  22.092  49.793  1.00 24.96           N  
ATOM    241  CA  TYR    34      37.861  20.961  48.968  1.00 25.67           C  
ATOM    242  C   TYR    34      37.136  19.878  49.790  1.00 25.32           C  
ATOM    243  O   TYR    34      36.093  19.371  49.368  1.00 26.28           O  
ATOM    244  CB  TYR    34      39.080  20.371  48.269  1.00 26.00           C  
ATOM    245  CG  TYR    34      38.715  19.304  47.255  1.00 27.85           C  
ATOM    246  CD1 TYR    34      38.370  19.649  45.954  1.00 28.71           C  
ATOM    247  CD2 TYR    34      38.702  17.955  47.609  1.00 28.41           C  
ATOM    248  CE1 TYR    34      38.040  18.675  45.016  1.00 30.02           C  
ATOM    249  CE2 TYR    34      38.376  16.967  46.676  1.00 30.06           C  
ATOM    250  CZ  TYR    34      38.041  17.339  45.392  1.00 29.85           C  
ATOM    251  OH  TYR    34      37.703  16.375  44.472  1.00 31.87           O  
ATOM    252  N   VAL    35      37.707  19.518  50.936  1.00 24.93           N  
ATOM    253  CA  VAL    35      37.145  18.495  51.844  1.00 25.76           C  
ATOM    254  C   VAL    35      35.690  18.832  52.214  1.00 26.68           C  
ATOM    255  O   VAL    35      34.787  17.983  52.122  1.00 26.22           O  
ATOM    256  CB  VAL    35      38.010  18.369  53.144  1.00 25.70           C  
ATOM    257  CG1 VAL    35      37.301  17.518  54.201  1.00 25.36           C  
ATOM    258  CG2 VAL    35      39.396  17.791  52.816  1.00 27.20           C  
ATOM    259  N   LYS    36      35.484  20.081  52.631  1.00 26.28           N  
ATOM    260  CA  LYS    36      34.158  20.606  52.971  1.00 27.35           C  
ATOM    261  C   LYS    36      33.184  20.574  51.782  1.00 28.31           C  
ATOM    262  O   LYS    36      32.012  20.256  51.950  1.00 28.21           O  
ATOM    263  CB  LYS    36      34.298  22.018  53.522  1.00 27.03           C  
ATOM    264  CG  LYS    36      34.806  22.052  54.954  1.00 28.56           C  
ATOM    265  CD  LYS    36      34.950  23.494  55.483  1.00 27.72           C  
ATOM    266  CE  LYS    36      33.587  24.133  55.783  1.00 32.60           C  
ATOM    267  NZ  LYS    36      32.768  23.365  56.795  1.00 34.40           N  
ATOM    268  N   LYS    37      33.679  20.892  50.589  1.00 29.26           N  
ATOM    269  CA  LYS    37      32.875  20.910  49.367  1.00 31.00           C  
ATOM    270  C   LYS    37      32.397  19.483  49.050  1.00 30.88           C  
ATOM    271  O   LYS    37      31.316  19.287  48.493  1.00 30.71           O  
ATOM    272  CB  LYS    37      33.714  21.498  48.216  1.00 30.85           C  
ATOM    273  CG  LYS    37      32.965  21.866  46.941  1.00 33.81           C  
ATOM    274  CD  LYS    37      33.954  22.296  45.849  1.00 33.63           C  
ATOM    275  CE  LYS    37      33.263  22.487  44.506  1.00 37.30           C  
ATOM    276  NZ  LYS    37      34.147  22.033  43.390  1.00 40.68           N  
ATOM    277  N   LYS    38      33.195  18.495  49.455  1.00 31.07           N  
ATOM    278  CA  LYS    38      32.858  17.080  49.266  1.00 31.54           C  
ATOM    279  C   LYS    38      31.920  16.521  50.339  1.00 31.64           C  
ATOM    280  O   LYS    38      31.583  15.336  50.311  1.00 32.09           O  
ATOM    281  CB  LYS    38      34.130  16.235  49.180  1.00 31.54           C  
ATOM    282  CG  LYS    38      34.977  16.547  47.962  1.00 33.50           C  
ATOM    283  CD  LYS    38      34.261  16.225  46.641  1.00 37.72           C  
ATOM    284  CE  LYS    38      34.129  14.711  46.450  1.00 41.39           C  
ATOM    285  NZ  LYS    38      33.660  14.331  45.082  1.00 42.99           N  
ATOM    286  N   GLY    39      31.523  17.364  51.288  1.00 30.54           N  
ATOM    287  CA  GLY    39      30.557  16.984  52.308  1.00 30.28           C  
ATOM    288  C   GLY    39      31.143  16.408  53.584  1.00 29.53           C  
ATOM    289  O   GLY    39      30.408  15.969  54.465  1.00 30.24           O  
ATOM    290  N   ILE    40      32.463  16.437  53.714  1.00 28.20           N  
ATOM    291  CA  ILE    40      33.113  15.914  54.912  1.00 27.30           C  
ATOM    292  C   ILE    40      33.134  16.977  56.021  1.00 26.53           C  
ATOM    293  O   ILE    40      33.489  18.126  55.766  1.00 25.76           O  
ATOM    294  CB  ILE    40      34.545  15.411  54.560  1.00 26.64           C  
ATOM    295  CG1 ILE    40      34.433  14.216  53.596  1.00 28.03           C  
ATOM    296  CG2 ILE    40      35.357  15.077  55.834  1.00 25.77           C  
ATOM    297  CD1 ILE    40      35.690  13.989  52.719  1.00 26.43           C  
ATOM    298  N   TYR    41      32.759  16.591  57.243  1.00 26.02           N  
ATOM    299  CA  TYR    41      32.716  17.522  58.373  1.00 25.38           C  
ATOM    300  C   TYR    41      34.156  17.697  58.843  1.00 25.27           C  
ATOM    301  O   TYR    41      34.865  16.693  59.047  1.00 24.68           O  
ATOM    302  CB  TYR    41      31.909  16.899  59.494  1.00 26.37           C  
ATOM    303  CG  TYR    41      31.554  17.785  60.700  1.00 27.48           C  
ATOM    304  CD1 TYR    41      30.309  18.382  60.786  1.00 28.59           C  
ATOM    305  CD2 TYR    41      32.450  17.970  61.775  1.00 28.27           C  
ATOM    306  CE1 TYR    41      29.947  19.155  61.889  1.00 29.47           C  
ATOM    307  CE2 TYR    41      32.092  18.754  62.897  1.00 29.43           C  
ATOM    308  CZ  TYR    41      30.827  19.332  62.936  1.00 29.11           C  
ATOM    309  OH  TYR    41      30.409  20.096  64.013  1.00 28.75           O  
ATOM    310  N   VAL    42      34.608  18.942  58.958  1.00 23.79           N  
ATOM    311  CA  VAL    42      36.002  19.208  59.371  1.00 23.71           C  
ATOM    312  C   VAL    42      36.002  19.914  60.731  1.00 24.94           C  
ATOM    313  O   VAL    42      35.384  20.981  60.907  1.00 25.46           O  
ATOM    314  CB  VAL    42      36.794  20.060  58.336  1.00 22.33           C  
ATOM    315  CG1 VAL    42      38.207  20.363  58.867  1.00 24.54           C  
ATOM    316  CG2 VAL    42      36.846  19.387  56.961  1.00 20.26           C  
ATOM    317  N   THR    43      36.712  19.341  61.692  1.00 25.37           N  
ATOM    318  CA  THR    43      36.816  19.992  62.990  1.00 26.04           C  
ATOM    319  C   THR    43      38.256  19.976  63.496  1.00 24.85           C  
ATOM    320  O   THR    43      39.131  19.283  62.926  1.00 25.08           O  
ATOM    321  CB  THR    43      35.881  19.367  64.023  1.00 26.77           C  
ATOM    322  OG1 THR    43      35.868  20.214  65.194  1.00 30.70           O  
ATOM    323  CG2 THR    43      36.333  17.945  64.392  1.00 26.35           C  
ATOM    324  N   LEU    44      38.480  20.721  64.568  1.00 23.09           N  
ATOM    325  CA  LEU    44      39.802  20.826  65.170  1.00 23.27           C  
ATOM    326  C   LEU    44      39.761  20.093  66.507  1.00 23.03           C  
ATOM    327  O   LEU    44      38.747  20.137  67.234  1.00 24.38           O  
ATOM    328  CB  LEU    44      40.193  22.306  65.365  1.00 22.31           C  
ATOM    329  CG  LEU    44      40.108  23.141  64.071  1.00 23.25           C  
ATOM    330  CD1 LEU    44      40.439  24.642  64.366  1.00 26.01           C  
ATOM    331  CD2 LEU    44      41.059  22.559  62.992  1.00 25.08           C  
ATOM    332  N   VAL    45      40.835  19.370  66.799  1.00 22.18           N  
ATOM    333  CA  VAL    45      40.983  18.659  68.061  0.50 22.15           C  
ATOM    335  C   VAL    45      42.315  19.106  68.647  1.00 22.54           C  
ATOM    336  O   VAL    45      43.365  18.795  68.091  1.00 23.44           O  
ATOM    337  CB  VAL    45      40.882  17.111  67.863  0.50 22.53           C  
ATOM    339  CG1 VAL    45      41.743  16.626  66.699  0.50 20.55           C  
ATOM    341  CG2 VAL    45      41.216  16.364  69.150  0.50 22.45           C  
ATOM    343  N   THR    46      42.268  19.832  69.763  1.00 21.76           N  
ATOM    344  CA  THR    46      43.431  20.613  70.192  1.00 21.81           C  
ATOM    345  C   THR    46      43.554  20.762  71.691  1.00 21.47           C  
ATOM    346  O   THR    46      42.546  20.719  72.425  1.00 21.29           O  
ATOM    347  CB  THR    46      43.389  22.038  69.512  1.00 23.35           C  
ATOM    348  OG1 THR    46      44.618  22.725  69.750  1.00 23.07           O  
ATOM    349  CG2 THR    46      42.189  22.914  70.046  1.00 24.16           C  
ATOM    350  N   ASN    47      44.793  20.935  72.130  1.00 21.21           N  
ATOM    351  CA  ASN    47      45.074  21.417  73.490  1.00 22.60           C  
ATOM    352  C   ASN    47      44.889  22.927  73.644  1.00 22.42           C  
ATOM    353  O   ASN    47      44.891  23.422  74.773  1.00 22.92           O  
ATOM    354  CB  ASN    47      46.514  21.061  73.901  1.00 22.46           C  
ATOM    355  CG  ASN    47      46.706  19.558  74.061  1.00 25.07           C  
ATOM    356  OD1 ASN    47      45.756  18.830  74.350  1.00 28.70           O  
ATOM    357  ND2 ASN    47      47.919  19.099  73.874  1.00 26.45           N  
ATOM    358  N   ARG    48      44.766  23.642  72.527  1.00 21.70           N  
ATOM    359  CA  ARG    48      44.621  25.128  72.590  1.00 22.31           C  
ATOM    360  C   ARG    48      43.334  25.546  73.281  1.00 21.33           C  
ATOM    361  O   ARG    48      42.367  24.793  73.281  1.00 21.43           O  
ATOM    362  CB  ARG    48      44.602  25.701  71.185  1.00 22.83           C  
ATOM    363  CG  ARG    48      46.020  25.748  70.580  1.00 26.34           C  
ATOM    364  CD  ARG    48      46.039  26.722  69.403  1.00 27.37           C  
ATOM    365  NE  ARG    48      47.403  26.804  68.879  1.00 28.67           N  
ATOM    366  CZ  ARG    48      47.886  27.842  68.223  1.00 30.50           C  
ATOM    367  NH1 ARG    48      47.106  28.904  68.015  1.00 30.63           N  
ATOM    368  NH2 ARG    48      49.151  27.813  67.782  1.00 28.11           N  
ATOM    369  N   HIS    49      43.340  26.753  73.837  1.00 20.28           N  
ATOM    370  CA  HIS    49      42.122  27.286  74.438  1.00 20.93           C  
ATOM    371  C   HIS    49      41.112  27.590  73.339  1.00 20.60           C  
ATOM    372  O   HIS    49      41.482  27.707  72.139  1.00 19.38           O  
ATOM    373  CB  HIS    49      42.432  28.486  75.362  1.00 20.36           C  
ATOM    374  CG  HIS    49      43.039  29.684  74.687  1.00 22.13           C  
ATOM    375  ND1 HIS    49      42.293  30.600  73.965  1.00 22.00           N  
ATOM    376  CD2 HIS    49      44.310  30.157  74.690  1.00 22.70           C  
ATOM    377  CE1 HIS    49      43.080  31.580  73.543  1.00 23.02           C  
ATOM    378  NE2 HIS    49      44.305  31.349  73.992  1.00 23.55           N  
ATOM    379  N   PHE    50      39.838  27.646  73.725  1.00 20.17           N  
ATOM    380  CA  PHE    50      38.758  27.704  72.750  1.00 20.73           C  
ATOM    381  C   PHE    50      38.892  28.914  71.799  1.00 21.11           C  
ATOM    382  O   PHE    50      38.740  28.799  70.551  1.00 21.34           O  
ATOM    383  CB  PHE    50      37.368  27.777  73.419  1.00 20.96           C  
ATOM    384  CG  PHE    50      36.269  27.807  72.391  1.00 21.48           C  
ATOM    385  CD1 PHE    50      35.951  26.638  71.710  1.00 21.51           C  
ATOM    386  CD2 PHE    50      35.669  29.013  72.009  1.00 22.59           C  
ATOM    387  CE1 PHE    50      34.993  26.646  70.684  1.00 23.30           C  
ATOM    388  CE2 PHE    50      34.695  29.024  70.990  1.00 20.94           C  
ATOM    389  CZ  PHE    50      34.356  27.834  70.344  1.00 20.08           C  
ATOM    390  N   ARG    51      39.145  30.075  72.377  1.00 20.54           N  
ATOM    391  CA  ARG    51      39.239  31.285  71.582  1.00 20.39           C  
ATOM    392  C   ARG    51      40.305  31.191  70.466  1.00 20.64           C  
ATOM    393  O   ARG    51      40.025  31.535  69.318  1.00 20.00           O  
ATOM    394  CB  ARG    51      39.476  32.492  72.485  1.00 21.15           C  
ATOM    395  CG  ARG    51      39.698  33.770  71.707  1.00 22.28           C  
ATOM    396  CD  ARG    51      39.879  34.931  72.698  1.00 21.76           C  
ATOM    397  NE  ARG    51      40.420  36.050  71.947  1.00 26.25           N  
ATOM    398  CZ  ARG    51      39.656  36.881  71.238  1.00 25.66           C  
ATOM    399  NH1 ARG    51      38.323  36.734  71.227  1.00 21.50           N  
ATOM    400  NH2 ARG    51      40.228  37.864  70.570  1.00 22.78           N  
ATOM    401  N   SER    52      41.501  30.708  70.784  1.00 20.61           N  
ATOM    402  CA  SER    52      42.523  30.554  69.758  1.00 22.63           C  
ATOM    403  C   SER    52      42.037  29.592  68.651  1.00 22.74           C  
ATOM    404  O   SER    52      42.141  29.902  67.431  1.00 21.96           O  
ATOM    405  CB  SER    52      43.832  30.074  70.387  1.00 22.87           C  
ATOM    406  OG  SER    52      44.788  29.862  69.357  1.00 26.87           O  
ATOM    407  N   ALA    53      41.493  28.437  69.060  1.00 20.89           N  
ATOM    408  CA  ALA    53      40.951  27.451  68.102  1.00 22.06           C  
ATOM    409  C   ALA    53      39.863  28.060  67.190  1.00 22.53           C  
ATOM    410  O   ALA    53      39.842  27.822  65.971  1.00 21.42           O  
ATOM    411  CB  ALA    53      40.381  26.209  68.844  1.00 20.73           C  
ATOM    412  N   GLN    54      38.972  28.852  67.784  1.00 21.77           N  
ATOM    413  CA  GLN    54      37.863  29.434  67.034  1.00 22.99           C  
ATOM    414  C   GLN    54      38.352  30.471  66.008  1.00 23.32           C  
ATOM    415  O   GLN    54      37.810  30.553  64.902  1.00 22.70           O  
ATOM    416  CB  GLN    54      36.818  30.043  67.983  1.00 23.51           C  
ATOM    417  CG  GLN    54      35.409  30.303  67.345  1.00 25.23           C  
ATOM    418  CD  GLN    54      35.338  31.586  66.526  1.00 29.86           C  
ATOM    419  OE1 GLN    54      36.043  32.576  66.813  1.00 25.97           O  
ATOM    420  NE2 GLN    54      34.484  31.573  65.470  1.00 31.74           N  
ATOM    421  N   LYS    55      39.360  31.270  66.354  1.00 22.59           N  
ATOM    422  CA  LYS    55      39.867  32.236  65.362  1.00 23.42           C  
ATOM    423  C   LYS    55      40.453  31.500  64.160  1.00 23.55           C  
ATOM    424  O   LYS    55      40.245  31.914  63.011  1.00 23.20           O  
ATOM    425  CB  LYS    55      40.909  33.165  65.993  1.00 23.58           C  
ATOM    426  CG  LYS    55      40.316  34.052  67.114  1.00 25.05           C  
ATOM    427  CD  LYS    55      39.268  35.041  66.621  1.00 27.47           C  
ATOM    428  CE  LYS    55      38.929  36.141  67.677  1.00 26.35           C  
ATOM    429  NZ  LYS    55      37.822  37.000  67.145  1.00 27.23           N  
ATOM    430  N   ILE    56      41.144  30.398  64.429  1.00 23.00           N  
ATOM    431  CA  ILE    56      41.709  29.540  63.366  1.00 24.02           C  
ATOM    432  C   ILE    56      40.572  28.924  62.527  1.00 23.51           C  
ATOM    433  O   ILE    56      40.601  28.985  61.296  1.00 22.40           O  
ATOM    434  CB  ILE    56      42.641  28.470  63.951  1.00 24.23           C  
ATOM    435  CG1 ILE    56      43.923  29.147  64.465  1.00 27.31           C  
ATOM    436  CG2 ILE    56      42.995  27.421  62.871  1.00 24.80           C  
ATOM    437  CD1 ILE    56      44.653  28.378  65.516  1.00 31.44           C  
ATOM    438  N   ALA    57      39.573  28.359  63.202  1.00 22.14           N  
ATOM    439  CA  ALA    57      38.357  27.865  62.520  1.00 22.65           C  
ATOM    440  C   ALA    57      37.681  28.943  61.649  1.00 23.56           C  
ATOM    441  O   ALA    57      37.234  28.665  60.517  1.00 24.43           O  
ATOM    442  CB  ALA    57      37.370  27.325  63.533  1.00 22.21           C  
ATOM    443  N   LYS    58      37.629  30.177  62.144  1.00 24.66           N  
ATOM    444  CA  LYS    58      37.056  31.275  61.381  1.00 26.83           C  
ATOM    445  C   LYS    58      37.842  31.502  60.081  1.00 26.21           C  
ATOM    446  O   LYS    58      37.247  31.711  59.014  1.00 26.97           O  
ATOM    447  CB  LYS    58      36.992  32.552  62.238  1.00 26.20           C  
ATOM    448  CG  LYS    58      36.160  33.654  61.624  1.00 28.89           C  
ATOM    449  CD  LYS    58      36.119  34.893  62.548  1.00 30.34           C  
ATOM    450  CE  LYS    58      35.429  36.020  61.816  1.00 36.90           C  
ATOM    451  NZ  LYS    58      35.490  37.304  62.544  1.00 39.28           N  
ATOM    452  N   SER    59      39.164  31.428  60.166  1.00 26.49           N  
ATOM    453  CA  SER    59      40.052  31.595  58.999  0.50 26.74           C  
ATOM    455  C   SER    59      39.793  30.531  57.939  1.00 27.28           C  
ATOM    456  O   SER    59      39.928  30.787  56.723  1.00 27.35           O  
ATOM    457  CB  SER    59      41.516  31.523  59.432  0.50 26.35           C  
ATOM    459  OG  SER    59      41.897  32.723  60.090  0.50 27.19           O  
ATOM    461  N   LEU    60      39.447  29.331  58.416  1.00 25.49           N  
ATOM    462  CA  LEU    60      39.179  28.172  57.546  1.00 26.35           C  
ATOM    463  C   LEU    60      37.705  28.037  57.199  1.00 26.59           C  
ATOM    464  O   LEU    60      37.310  27.069  56.526  1.00 26.80           O  
ATOM    465  CB  LEU    60      39.656  26.886  58.228  1.00 25.25           C  
ATOM    466  CG  LEU    60      41.138  26.779  58.538  1.00 27.58           C  
ATOM    467  CD1 LEU    60      41.387  25.562  59.387  1.00 28.20           C  
ATOM    468  CD2 LEU    60      41.902  26.711  57.211  1.00 28.42           C  
ATOM    469  N   LYS    61      36.897  28.989  57.665  1.00 27.23           N  
ATOM    470  CA  LYS    61      35.432  28.981  57.478  1.00 28.49           C  
ATOM    471  C   LYS    61      34.784  27.641  57.908  1.00 27.82           C  
ATOM    472  O   LYS    61      33.917  27.112  57.198  1.00 27.47           O  
ATOM    473  CB  LYS    61      35.076  29.295  56.004  1.00 28.70           C  
ATOM    474  CG  LYS    61      35.668  30.598  55.463  1.00 30.96           C  
ATOM    475  CD  LYS    61      35.543  30.753  53.935  1.00 32.09           C  
ATOM    476  CE  LYS    61      36.849  30.335  53.258  1.00 36.97           C  
ATOM    477  NZ  LYS    61      36.860  30.655  51.781  1.00 41.53           N  
ATOM    478  N   LEU    62      35.190  27.089  59.048  1.00 26.95           N  
ATOM    479  CA  LEU    62      34.717  25.753  59.448  1.00 27.46           C  
ATOM    480  C   LEU    62      33.252  25.648  59.899  1.00 29.60           C  
ATOM    481  O   LEU    62      32.591  24.655  59.602  1.00 30.44           O  
ATOM    482  CB  LEU    62      35.586  25.149  60.542  1.00 26.53           C  
ATOM    483  CG  LEU    62      37.049  24.843  60.217  1.00 26.51           C  
ATOM    484  CD1 LEU    62      37.672  24.005  61.374  1.00 25.49           C  
ATOM    485  CD2 LEU    62      37.160  24.116  58.867  1.00 25.94           C  
ATOM    486  N   ASP    63      32.775  26.618  60.661  1.00 31.37           N  
ATOM    487  CA  ASP    63      31.447  26.481  61.308  1.00 34.07           C  
ATOM    488  C   ASP    63      31.144  25.066  61.854  1.00 33.74           C  
ATOM    489  O   ASP    63      30.177  24.419  61.456  1.00 35.61           O  
ATOM    490  CB  ASP    63      30.357  26.950  60.343  1.00 35.41           C  
ATOM    491  CG  ASP    63      30.539  28.405  59.959  1.00 39.11           C  
ATOM    492  OD1 ASP    63      30.700  29.246  60.888  1.00 41.22           O  
ATOM    493  OD2 ASP    63      30.551  28.698  58.739  1.00 43.66           O  
ATOM    494  N   ALA    64      31.990  24.589  62.757  1.00 32.83           N  
ATOM    495  CA  ALA    64      31.909  23.216  63.257  1.00 30.86           C  
ATOM    496  C   ALA    64      32.060  23.248  64.770  1.00 29.07           C  
ATOM    497  O   ALA    64      32.556  24.223  65.310  1.00 29.36           O  
ATOM    498  CB  ALA    64      33.030  22.400  62.660  1.00 32.36           C  
ATOM    499  N   LYS    65      31.665  22.172  65.445  1.00 27.04           N  
ATOM    500  CA  LYS    65      31.967  22.001  66.873  1.00 25.79           C  
ATOM    501  C   LYS    65      33.456  21.687  67.034  1.00 24.88           C  
ATOM    502  O   LYS    65      33.943  20.690  66.483  1.00 26.80           O  
ATOM    503  CB  LYS    65      31.145  20.861  67.467  1.00 26.09           C  
ATOM    504  CG  LYS    65      29.645  21.189  67.709  1.00 24.81           C  
ATOM    505  CD  LYS    65      28.846  19.911  68.020  1.00 27.18           C  
ATOM    506  CE  LYS    65      27.327  20.155  68.132  1.00 30.13           C  
ATOM    507  NZ  LYS    65      26.732  20.900  66.973  1.00 31.93           N  
ATOM    508  N   LEU    66      34.169  22.513  67.793  1.00 22.23           N  
ATOM    509  CA  LEU    66      35.607  22.356  67.914  1.00 21.65           C  
ATOM    510  C   LEU    66      35.872  21.678  69.255  1.00 21.94           C  
ATOM    511  O   LEU    66      35.179  21.973  70.250  1.00 21.43           O  
ATOM    512  CB  LEU    66      36.280  23.737  67.899  1.00 21.77           C  
ATOM    513  CG  LEU    66      35.849  24.630  66.719  1.00 21.08           C  
ATOM    514  CD1 LEU    66      36.443  26.057  66.921  1.00 23.95           C  
ATOM    515  CD2 LEU    66      36.285  24.034  65.394  1.00 21.87           C  
ATOM    516  N   ILE    67      36.851  20.786  69.274  1.00 21.05           N  
ATOM    517  CA  ILE    67      37.226  20.056  70.494  1.00 21.79           C  
ATOM    518  C   ILE    67      38.489  20.699  71.055  1.00 21.05           C  
ATOM    519  O   ILE    67      39.567  20.585  70.479  1.00 20.88           O  
ATOM    520  CB  ILE    67      37.438  18.545  70.200  1.00 22.27           C  
ATOM    521  CG1 ILE    67      36.119  17.950  69.663  1.00 24.26           C  
ATOM    522  CG2 ILE    67      37.846  17.799  71.502  1.00 21.10           C  
ATOM    523  CD1 ILE    67      36.317  16.897  68.631  1.00 27.11           C  
ATOM    524  N   THR    68      38.335  21.429  72.157  1.00 19.41           N  
ATOM    525  CA  THR    68      39.412  22.313  72.640  1.00 19.84           C  
ATOM    526  C   THR    68      39.685  22.018  74.123  1.00 19.61           C  
ATOM    527  O   THR    68      38.961  21.215  74.761  1.00 20.40           O  
ATOM    528  CB  THR    68      39.033  23.825  72.394  1.00 19.80           C  
ATOM    529  OG1 THR    68      38.006  24.217  73.305  1.00 19.77           O  
ATOM    530  CG2 THR    68      38.499  23.997  70.973  1.00 21.02           C  
ATOM    531  N   HIS    69      40.721  22.659  74.663  1.00 19.41           N  
ATOM    532  CA  HIS    69      41.147  22.453  76.055  1.00 19.78           C  
ATOM    533  C   HIS    69      41.289  20.937  76.284  1.00 20.78           C  
ATOM    534  O   HIS    69      40.790  20.420  77.295  1.00 20.95           O  
ATOM    535  CB  HIS    69      40.138  23.082  77.062  1.00 19.33           C  
ATOM    536  CG  HIS    69      40.027  24.582  76.972  1.00 19.21           C  
ATOM    537  ND1 HIS    69      40.623  25.425  77.886  1.00 18.89           N  
ATOM    538  CD2 HIS    69      39.384  25.384  76.083  1.00 19.50           C  
ATOM    539  CE1 HIS    69      40.328  26.686  77.581  1.00 18.35           C  
ATOM    540  NE2 HIS    69      39.569  26.686  76.493  1.00 19.29           N  
ATOM    541  N   SER    70      41.930  20.221  75.335  1.00 20.83           N  
ATOM    542  CA  SER    70      42.220  18.789  75.517  0.50 21.41           C  
ATOM    544  C   SER    70      40.949  17.908  75.620  1.00 22.14           C  
ATOM    545  O   SER    70      40.992  16.797  76.208  1.00 22.78           O  
ATOM    546  CB  SER    70      43.086  18.618  76.773  0.50 21.80           C  
ATOM    548  OG  SER    70      43.785  17.398  76.758  0.50 21.52           O  
ATOM    550  N   GLY    71      39.823  18.399  75.087  1.00 21.30           N  
ATOM    551  CA  GLY    71      38.531  17.682  75.145  1.00 21.84           C  
ATOM    552  C   GLY    71      37.566  18.176  76.216  1.00 20.49           C  
ATOM    553  O   GLY    71      36.451  17.666  76.334  1.00 22.40           O  
ATOM    554  N   ALA    72      38.003  19.123  77.053  1.00 19.92           N  
ATOM    555  CA  ALA    72      37.170  19.600  78.164  1.00 20.96           C  
ATOM    556  C   ALA    72      36.155  20.646  77.731  1.00 21.33           C  
ATOM    557  O   ALA    72      35.248  20.972  78.484  1.00 22.16           O  
ATOM    558  CB  ALA    72      38.064  20.183  79.302  1.00 21.39           C  
ATOM    559  N   TYR    73      36.331  21.205  76.536  1.00 21.33           N  
ATOM    560  CA  TYR    73      35.467  22.316  76.085  1.00 21.67           C  
ATOM    561  C   TYR    73      35.156  22.166  74.603  1.00 21.49           C  
ATOM    562  O   TYR    73      36.061  22.265  73.755  1.00 21.48           O  
ATOM    563  CB  TYR    73      36.119  23.682  76.371  1.00 21.37           C  
ATOM    564  CG  TYR    73      35.080  24.761  76.456  1.00 21.71           C  
ATOM    565  CD1 TYR    73      34.381  24.960  77.663  1.00 23.03           C  
ATOM    566  CD2 TYR    73      34.778  25.582  75.357  1.00 23.35           C  
ATOM    567  CE1 TYR    73      33.374  25.928  77.776  1.00 26.01           C  
ATOM    568  CE2 TYR    73      33.747  26.588  75.461  1.00 21.42           C  
ATOM    569  CZ  TYR    73      33.081  26.748  76.670  1.00 25.65           C  
ATOM    570  OH  TYR    73      32.096  27.695  76.850  1.00 24.71           O  
ATOM    571  N   ILE    74      33.904  21.843  74.281  1.00 21.45           N  
ATOM    572  CA  ILE    74      33.530  21.515  72.889  1.00 21.25           C  
ATOM    573  C   ILE    74      32.403  22.451  72.530  1.00 21.83           C  
ATOM    574  O   ILE    74      31.382  22.491  73.221  1.00 21.41           O  
ATOM    575  CB  ILE    74      33.079  20.030  72.706  1.00 21.10           C  
ATOM    576  CG1 ILE    74      34.181  19.066  73.213  1.00 21.25           C  
ATOM    577  CG2 ILE    74      32.687  19.744  71.221  1.00 21.03           C  
ATOM    578  CD1 ILE    74      33.749  17.567  73.338  1.00 21.33           C  
ATOM    579  N   ALA    75      32.616  23.242  71.483  1.00 21.36           N  
ATOM    580  CA  ALA    75      31.686  24.331  71.193  1.00 21.45           C  
ATOM    581  C   ALA    75      31.867  24.891  69.799  1.00 21.63           C  
ATOM    582  O   ALA    75      32.903  24.688  69.162  1.00 20.86           O  
ATOM    583  CB  ALA    75      31.899  25.494  72.243  1.00 21.22           C  
ATOM    584  N   GLU    76      30.827  25.558  69.314  1.00 22.41           N  
ATOM    585  CA  GLU    76      30.984  26.384  68.125  0.50 22.73           C  
ATOM    587  C   GLU    76      31.083  27.854  68.505  1.00 23.14           C  
ATOM    588  O   GLU    76      31.827  28.629  67.858  1.00 23.26           O  
ATOM    589  CB  GLU    76      29.854  26.166  67.128  0.50 22.55           C  
ATOM    591  CG  GLU    76      30.171  26.782  65.765  0.50 23.11           C  
ATOM    593  CD  GLU    76      29.105  26.535  64.712  0.50 24.63           C  
ATOM    595  OE1 GLU    76      28.124  25.806  64.978  0.50 25.39           O  
ATOM    597  OE2 GLU    76      29.248  27.108  63.616  0.50 22.88           O  
ATOM    599  N   LYS    77      30.382  28.242  69.569  1.00 23.36           N  
ATOM    600  CA  LYS    77      30.450  29.622  70.066  1.00 24.10           C  
ATOM    601  C   LYS    77      30.680  29.580  71.569  1.00 22.97           C  
ATOM    602  O   LYS    77      30.090  28.767  72.269  1.00 22.29           O  
ATOM    603  CB  LYS    77      29.171  30.410  69.739  1.00 24.74           C  
ATOM    604  CG  LYS    77      28.963  30.705  68.229  1.00 25.92           C  
ATOM    605  CD  LYS    77      27.715  31.554  68.048  1.00 27.04           C  
ATOM    606  CE  LYS    77      27.350  31.768  66.560  1.00 30.16           C  
ATOM    607  NZ  LYS    77      26.213  32.750  66.465  1.00 32.73           N  
ATOM    608  N   ILE    78      31.583  30.435  72.043  1.00 22.60           N  
ATOM    609  CA  ILE    78      32.071  30.339  73.413  1.00 22.07           C  
ATOM    610  C   ILE    78      31.012  30.326  74.533  1.00 22.75           C  
ATOM    611  O   ILE    78      31.152  29.564  75.504  1.00 23.41           O  
ATOM    612  CB  ILE    78      33.171  31.402  73.697  1.00 21.45           C  
ATOM    613  CG1 ILE    78      33.998  30.962  74.928  1.00 23.92           C  
ATOM    614  CG2 ILE    78      32.562  32.812  73.824  1.00 21.51           C  
ATOM    615  CD1 ILE    78      35.292  31.689  75.027  1.00 24.33           C  
ATOM    616  N   ASP    79      29.970  31.146  74.440  1.00 23.59           N  
ATOM    617  CA  ASP    79      29.029  31.223  75.570  1.00 24.43           C  
ATOM    618  C   ASP    79      28.100  30.016  75.696  1.00 25.45           C  
ATOM    619  O   ASP    79      27.417  29.879  76.716  1.00 24.78           O  
ATOM    620  CB  ASP    79      28.210  32.536  75.557  1.00 24.23           C  
ATOM    621  CG  ASP    79      29.086  33.776  75.601  1.00 27.88           C  
ATOM    622  OD1 ASP    79      29.804  33.964  76.614  1.00 26.74           O  
ATOM    623  OD2 ASP    79      29.094  34.527  74.593  1.00 32.80           O  
ATOM    624  N   ALA    80      28.066  29.156  74.665  1.00 25.69           N  
ATOM    625  CA  ALA    80      27.047  28.111  74.563  1.00 26.54           C  
ATOM    626  C   ALA    80      27.682  26.765  74.211  1.00 26.30           C  
ATOM    627  O   ALA    80      27.503  26.249  73.096  1.00 27.12           O  
ATOM    628  CB  ALA    80      25.985  28.507  73.530  1.00 26.86           C  
ATOM    629  N   PRO    81      28.447  26.184  75.142  1.00 26.15           N  
ATOM    630  CA  PRO    81      29.122  24.949  74.732  1.00 24.68           C  
ATOM    631  C   PRO    81      28.218  23.743  74.545  1.00 24.12           C  
ATOM    632  O   PRO    81      27.161  23.624  75.174  1.00 22.35           O  
ATOM    633  CB  PRO    81      30.133  24.700  75.858  1.00 25.45           C  
ATOM    634  CG  PRO    81      29.445  25.319  77.098  1.00 26.62           C  
ATOM    635  CD  PRO    81      28.774  26.577  76.531  1.00 25.97           C  
ATOM    636  N   PHE    82      28.635  22.882  73.622  1.00 23.55           N  
ATOM    637  CA  PHE    82      28.009  21.589  73.410  1.00 23.30           C  
ATOM    638  C   PHE    82      28.340  20.635  74.570  1.00 23.67           C  
ATOM    639  O   PHE    82      27.463  19.880  75.036  1.00 22.81           O  
ATOM    640  CB  PHE    82      28.527  21.019  72.092  1.00 24.35           C  
ATOM    641  CG  PHE    82      28.172  19.587  71.875  1.00 25.21           C  
ATOM    642  CD1 PHE    82      26.838  19.213  71.728  1.00 28.92           C  
ATOM    643  CD2 PHE    82      29.165  18.615  71.831  1.00 27.78           C  
ATOM    644  CE1 PHE    82      26.501  17.867  71.539  1.00 30.70           C  
ATOM    645  CE2 PHE    82      28.833  17.275  71.630  1.00 31.51           C  
ATOM    646  CZ  PHE    82      27.502  16.912  71.485  1.00 30.20           C  
ATOM    647  N   PHE    83      29.607  20.662  75.011  1.00 22.68           N  
ATOM    648  CA  PHE    83      30.089  19.864  76.127  1.00 22.25           C  
ATOM    649  C   PHE    83      31.094  20.714  76.902  1.00 22.99           C  
ATOM    650  O   PHE    83      32.029  21.288  76.312  1.00 23.07           O  
ATOM    651  CB  PHE    83      30.776  18.557  75.645  1.00 23.52           C  
ATOM    652  CG  PHE    83      31.457  17.768  76.743  1.00 22.78           C  
ATOM    653  CD1 PHE    83      30.727  16.888  77.557  1.00 26.75           C  
ATOM    654  CD2 PHE    83      32.847  17.887  76.951  1.00 24.70           C  
ATOM    655  CE1 PHE    83      31.354  16.155  78.577  1.00 28.70           C  
ATOM    656  CE2 PHE    83      33.499  17.159  77.979  1.00 24.92           C  
ATOM    657  CZ  PHE    83      32.743  16.278  78.787  1.00 25.97           C  
ATOM    658  N   GLU    84      30.936  20.765  78.225  1.00 23.12           N  
ATOM    659  CA  GLU    84      31.992  21.343  79.050  1.00 23.53           C  
ATOM    660  C   GLU    84      32.175  20.569  80.340  1.00 23.50           C  
ATOM    661  O   GLU    84      31.204  20.097  80.934  1.00 23.03           O  
ATOM    662  CB  GLU    84      31.722  22.822  79.341  1.00 23.79           C  
ATOM    663  CG  GLU    84      30.401  23.073  80.119  1.00 26.04           C  
ATOM    664  CD  GLU    84      30.205  24.545  80.531  1.00 27.27           C  
ATOM    665  OE1 GLU    84      31.156  25.360  80.506  1.00 26.40           O  
ATOM    666  OE2 GLU    84      29.069  24.870  80.924  1.00 28.28           O  
ATOM    667  N   LYS    85      33.420  20.423  80.766  1.00 22.93           N  
ATOM    668  CA  LYS    85      33.724  19.846  82.086  0.50 23.87           C  
ATOM    670  C   LYS    85      34.910  20.625  82.634  1.00 23.56           C  
ATOM    671  O   LYS    85      35.825  20.950  81.895  1.00 23.95           O  
ATOM    672  CB  LYS    85      34.083  18.357  81.996  0.50 23.73           C  
ATOM    674  CG  LYS    85      32.957  17.384  82.336  0.50 24.82           C  
ATOM    676  CD  LYS    85      33.505  15.997  82.769  0.50 24.33           C  
ATOM    678  CE  LYS    85      33.555  15.811  84.294  0.50 25.99           C  
ATOM    680  NZ  LYS    85      33.861  14.401  84.745  0.50 26.26           N  
ATOM    682  N   ARG    86      34.903  20.903  83.919  1.00 23.57           N  
ATOM    683  CA  ARG    86      36.034  21.610  84.495  1.00 23.90           C  
ATOM    684  C   ARG    86      36.348  21.086  85.880  1.00 24.29           C  
ATOM    685  O   ARG    86      35.484  20.487  86.553  1.00 23.66           O  
ATOM    686  CB  ARG    86      35.786  23.128  84.490  1.00 24.99           C  
ATOM    687  CG  ARG    86      34.591  23.615  85.302  1.00 25.07           C  
ATOM    688  CD  ARG    86      34.303  25.123  85.038  1.00 25.14           C  
ATOM    689  NE  ARG    86      33.702  25.398  83.719  1.00 25.31           N  
ATOM    690  CZ  ARG    86      34.236  26.201  82.789  1.00 26.67           C  
ATOM    691  NH1 ARG    86      35.374  26.830  83.012  1.00 26.27           N  
ATOM    692  NH2 ARG    86      33.627  26.379  81.614  1.00 26.28           N  
ATOM    693  N   ILE    87      37.591  21.304  86.302  1.00 23.22           N  
ATOM    694  CA  ILE    87      38.047  20.923  87.641  1.00 23.10           C  
ATOM    695  C   ILE    87      37.449  21.940  88.647  1.00 24.10           C  
ATOM    696  O   ILE    87      37.432  23.160  88.378  1.00 24.17           O  
ATOM    697  CB  ILE    87      39.604  20.913  87.674  1.00 22.67           C  
ATOM    698  CG1 ILE    87      40.155  19.959  86.594  1.00 21.94           C  
ATOM    699  CG2 ILE    87      40.155  20.545  89.091  1.00 22.37           C  
ATOM    700  CD1 ILE    87      41.673  20.106  86.366  1.00 24.37           C  
ATOM    701  N   SER    88      36.896  21.460  89.764  1.00 23.35           N  
ATOM    702  CA  SER    88      36.274  22.367  90.747  1.00 23.33           C  
ATOM    703  C   SER    88      37.265  23.407  91.232  1.00 23.89           C  
ATOM    704  O   SER    88      38.486  23.190  91.140  1.00 22.80           O  
ATOM    705  CB  SER    88      35.722  21.610  91.964  1.00 23.72           C  
ATOM    706  OG  SER    88      36.795  21.101  92.744  1.00 23.82           O  
ATOM    707  N   ASP    89      36.763  24.531  91.735  1.00 23.87           N  
ATOM    708  CA  ASP    89      37.707  25.521  92.262  1.00 26.50           C  
ATOM    709  C   ASP    89      38.550  25.003  93.433  1.00 25.69           C  
ATOM    710  O   ASP    89      39.761  25.286  93.514  1.00 24.91           O  
ATOM    711  CB  ASP    89      37.099  26.927  92.521  1.00 27.17           C  
ATOM    712  CG  ASP    89      35.754  26.920  93.224  1.00 34.53           C  
ATOM    713  OD1 ASP    89      35.381  25.939  93.922  1.00 37.65           O  
ATOM    714  OD2 ASP    89      35.055  27.972  93.088  1.00 39.94           O  
ATOM    715  N   ASP    90      37.930  24.213  94.312  1.00 25.37           N  
ATOM    716  CA  ASP    90      38.670  23.688  95.451  0.50 25.31           C  
ATOM    718  C   ASP    90      39.719  22.673  95.024  1.00 24.86           C  
ATOM    719  O   ASP    90      40.851  22.735  95.504  1.00 24.95           O  
ATOM    720  CB  ASP    90      37.719  23.169  96.525  0.50 25.14           C  
ATOM    722  CG  ASP    90      36.780  24.263  97.018  0.50 26.90           C  
ATOM    724  OD1 ASP    90      37.266  25.386  97.275  0.50 26.76           O  
ATOM    726  OD2 ASP    90      35.561  24.010  97.107  0.50 28.34           O  
ATOM    728  N   HIS    91      39.370  21.771  94.104  1.00 24.96           N  
ATOM    729  CA  HIS    91      40.356  20.826  93.562  1.00 24.21           C  
ATOM    730  C   HIS    91      41.470  21.540  92.799  1.00 24.77           C  
ATOM    731  O   HIS    91      42.640  21.158  92.917  1.00 24.87           O  
ATOM    732  CB  HIS    91      39.685  19.793  92.654  1.00 24.69           C  
ATOM    733  CG  HIS    91      38.908  18.747  93.410  1.00 26.40           C  
ATOM    734  ND1 HIS    91      37.982  17.920  92.808  1.00 28.55           N  
ATOM    735  CD2 HIS    91      38.933  18.395  94.718  1.00 28.91           C  
ATOM    736  CE1 HIS    91      37.464  17.109  93.720  1.00 28.06           C  
ATOM    737  NE2 HIS    91      38.034  17.367  94.881  1.00 27.01           N  
ATOM    738  N   THR    92      41.117  22.567  92.019  1.00 23.57           N  
ATOM    739  CA  THR    92      42.132  23.372  91.320  1.00 23.55           C  
ATOM    740  C   THR    92      43.130  23.966  92.321  1.00 23.89           C  
ATOM    741  O   THR    92      44.352  23.837  92.148  1.00 23.39           O  
ATOM    742  CB  THR    92      41.464  24.477  90.469  1.00 24.44           C  
ATOM    743  OG1 THR    92      40.688  23.848  89.434  1.00 23.71           O  
ATOM    744  CG2 THR    92      42.491  25.426  89.820  1.00 23.99           C  
ATOM    745  N   PHE    93      42.619  24.555  93.399  1.00 23.98           N  
ATOM    746  CA  PHE    93      43.498  25.117  94.433  1.00 24.53           C  
ATOM    747  C   PHE    93      44.425  24.043  95.046  1.00 24.75           C  
ATOM    748  O   PHE    93      45.644  24.257  95.175  1.00 24.62           O  
ATOM    749  CB  PHE    93      42.656  25.808  95.518  1.00 24.20           C  
ATOM    750  CG  PHE    93      43.456  26.295  96.690  1.00 24.55           C  
ATOM    751  CD1 PHE    93      44.079  27.546  96.644  1.00 23.25           C  
ATOM    752  CD2 PHE    93      43.582  25.508  97.839  1.00 24.77           C  
ATOM    753  CE1 PHE    93      44.795  28.026  97.744  1.00 25.66           C  
ATOM    754  CE2 PHE    93      44.321  25.968  98.927  1.00 28.70           C  
ATOM    755  CZ  PHE    93      44.926  27.235  98.874  1.00 27.67           C  
ATOM    756  N   ASN    94      43.849  22.899  95.417  1.00 24.28           N  
ATOM    757  CA  ASN    94      44.615  21.821  96.053  1.00 25.00           C  
ATOM    758  C   ASN    94      45.670  21.242  95.113  1.00 24.16           C  
ATOM    759  O   ASN    94      46.787  20.912  95.540  1.00 23.37           O  
ATOM    760  CB  ASN    94      43.675  20.691  96.523  1.00 24.95           C  
ATOM    761  CG  ASN    94      42.833  21.082  97.717  1.00 28.63           C  
ATOM    762  OD1 ASN    94      43.170  21.988  98.466  1.00 30.96           O  
ATOM    763  ND2 ASN    94      41.726  20.374  97.908  1.00 33.96           N  
ATOM    764  N   ILE    95      45.301  21.098  93.838  1.00 23.11           N  
ATOM    765  CA  ILE    95      46.232  20.615  92.833  1.00 23.14           C  
ATOM    766  C   ILE    95      47.380  21.595  92.644  1.00 23.25           C  
ATOM    767  O   ILE    95      48.550  21.180  92.642  1.00 23.42           O  
ATOM    768  CB  ILE    95      45.539  20.303  91.496  1.00 22.15           C  
ATOM    769  CG1 ILE    95      44.625  19.059  91.666  1.00 23.25           C  
ATOM    770  CG2 ILE    95      46.600  20.110  90.374  1.00 22.80           C  
ATOM    771  CD1 ILE    95      43.608  18.920  90.526  1.00 22.98           C  
ATOM    772  N   VAL    96      47.060  22.888  92.545  1.00 22.69           N  
ATOM    773  CA  VAL    96      48.100  23.906  92.442  1.00 23.28           C  
ATOM    774  C   VAL    96      49.068  23.864  93.627  1.00 24.25           C  
ATOM    775  O   VAL    96      50.295  23.989  93.454  1.00 24.61           O  
ATOM    776  CB  VAL    96      47.488  25.317  92.278  1.00 23.65           C  
ATOM    777  CG1 VAL    96      48.516  26.412  92.512  1.00 24.35           C  
ATOM    778  CG2 VAL    96      46.859  25.471  90.874  1.00 23.57           C  
ATOM    779  N   GLN    97      48.541  23.709  94.838  1.00 25.36           N  
ATOM    780  CA  GLN    97      49.424  23.624  96.016  1.00 25.73           C  
ATOM    781  C   GLN    97      50.437  22.476  95.923  1.00 26.30           C  
ATOM    782  O   GLN    97      51.621  22.663  96.230  1.00 25.59           O  
ATOM    783  CB  GLN    97      48.607  23.465  97.284  1.00 26.58           C  
ATOM    784  CG  GLN    97      47.941  24.729  97.740  1.00 29.53           C  
ATOM    785  CD  GLN    97      47.556  24.621  99.202  1.00 34.30           C  
ATOM    786  OE1 GLN    97      46.953  23.630  99.634  1.00 38.22           O  
ATOM    787  NE2 GLN    97      47.909  25.625  99.965  1.00 33.95           N  
ATOM    788  N   VAL    98      49.975  21.294  95.507  1.00 25.44           N  
ATOM    789  CA  VAL    98      50.871  20.140  95.297  1.00 25.65           C  
ATOM    790  C   VAL    98      51.943  20.420  94.232  1.00 25.69           C  
ATOM    791  O   VAL    98      53.131  20.180  94.468  1.00 25.67           O  
ATOM    792  CB  VAL    98      50.074  18.830  94.944  1.00 25.00           C  
ATOM    793  CG1 VAL    98      51.016  17.668  94.604  1.00 25.34           C  
ATOM    794  CG2 VAL    98      49.144  18.437  96.107  1.00 25.98           C  
ATOM    795  N   LEU    99      51.514  20.923  93.074  1.00 24.55           N  
ATOM    796  CA  LEU    99      52.410  21.250  91.964  1.00 24.75           C  
ATOM    797  C   LEU    99      53.432  22.319  92.341  1.00 24.75           C  
ATOM    798  O   LEU    99      54.538  22.322  91.821  1.00 24.16           O  
ATOM    799  CB  LEU    99      51.590  21.751  90.771  1.00 24.18           C  
ATOM    800  CG  LEU    99      50.646  20.756  90.086  1.00 23.25           C  
ATOM    801  CD1 LEU    99      49.801  21.461  89.000  1.00 25.60           C  
ATOM    802  CD2 LEU    99      51.398  19.593  89.490  1.00 26.40           C  
ATOM    803  N   GLU   100      53.051  23.241  93.225  1.00 24.86           N  
ATOM    804  CA  GLU   100      53.987  24.257  93.719  1.00 25.62           C  
ATOM    805  C   GLU   100      55.195  23.703  94.483  1.00 25.99           C  
ATOM    806  O   GLU   100      56.229  24.373  94.588  1.00 26.50           O  
ATOM    807  CB  GLU   100      53.240  25.309  94.555  1.00 25.45           C  
ATOM    808  CG  GLU   100      52.480  26.276  93.656  1.00 25.86           C  
ATOM    809  CD  GLU   100      51.646  27.259  94.435  1.00 29.79           C  
ATOM    810  OE1 GLU   100      51.422  27.015  95.630  1.00 29.23           O  
ATOM    811  OE2 GLU   100      51.205  28.279  93.859  1.00 28.43           O  
ATOM    812  N   SER   101      55.070  22.491  95.008  1.00 26.91           N  
ATOM    813  CA  SER   101      56.191  21.837  95.686  1.00 27.88           C  
ATOM    814  C   SER   101      57.197  21.199  94.694  1.00 28.12           C  
ATOM    815  O   SER   101      58.288  20.756  95.101  1.00 27.43           O  
ATOM    816  CB  SER   101      55.663  20.827  96.693  1.00 27.76           C  
ATOM    817  OG  SER   101      55.126  19.698  96.013  1.00 30.42           O  
ATOM    818  N   TYR   102      56.848  21.171  93.404  1.00 27.81           N  
ATOM    819  CA  TYR   102      57.752  20.646  92.362  1.00 28.47           C  
ATOM    820  C   TYR   102      58.315  21.769  91.498  1.00 28.53           C  
ATOM    821  O   TYR   102      57.724  22.846  91.414  1.00 28.15           O  
ATOM    822  CB  TYR   102      57.016  19.689  91.419  1.00 29.44           C  
ATOM    823  CG  TYR   102      56.582  18.380  91.998  1.00 29.79           C  
ATOM    824  CD1 TYR   102      57.393  17.245  91.865  1.00 32.75           C  
ATOM    825  CD2 TYR   102      55.348  18.247  92.630  1.00 30.53           C  
ATOM    826  CE1 TYR   102      56.993  16.017  92.375  1.00 34.59           C  
ATOM    827  CE2 TYR   102      54.938  17.025  93.160  1.00 32.33           C  
ATOM    828  CZ  TYR   102      55.766  15.919  93.028  1.00 33.34           C  
ATOM    829  OH  TYR   102      55.399  14.694  93.536  1.00 34.62           O  
ATOM    830  N   GLN   103      59.435  21.501  90.825  1.00 27.96           N  
ATOM    831  CA  GLN   103      60.007  22.432  89.843  1.00 28.01           C  
ATOM    832  C   GLN   103      59.215  22.347  88.538  1.00 27.48           C  
ATOM    833  O   GLN   103      59.582  21.623  87.593  1.00 26.24           O  
ATOM    834  CB  GLN   103      61.508  22.149  89.606  1.00 28.39           C  
ATOM    835  CG  GLN   103      62.260  23.245  88.794  1.00 31.88           C  
ATOM    836  CD  GLN   103      62.241  24.634  89.443  1.00 35.99           C  
ATOM    837  OE1 GLN   103      62.423  24.784  90.658  1.00 37.49           O  
ATOM    838  NE2 GLN   103      62.026  25.659  88.623  1.00 36.64           N  
ATOM    839  N   CYS   104      58.102  23.073  88.490  1.00 26.82           N  
ATOM    840  CA  CYS   104      57.245  23.013  87.321  1.00 26.67           C  
ATOM    841  C   CYS   104      56.543  24.335  87.076  1.00 26.12           C  
ATOM    842  O   CYS   104      56.247  25.093  88.000  1.00 25.39           O  
ATOM    843  CB  CYS   104      56.246  21.858  87.427  1.00 27.15           C  
ATOM    844  SG  CYS   104      54.932  22.068  88.635  1.00 31.66           S  
ATOM    845  N   ASN   105      56.328  24.605  85.804  1.00 25.78           N  
ATOM    846  CA  ASN   105      55.584  25.768  85.366  1.00 25.96           C  
ATOM    847  C   ASN   105      54.135  25.312  85.218  1.00 25.15           C  
ATOM    848  O   ASN   105      53.872  24.277  84.611  1.00 23.84           O  
ATOM    849  CB  ASN   105      56.154  26.268  84.038  1.00 27.40           C  
ATOM    850  CG  ASN   105      55.475  27.535  83.579  1.00 33.06           C  
ATOM    851  OD1 ASN   105      54.409  27.486  82.956  1.00 38.49           O  
ATOM    852  ND2 ASN   105      56.038  28.681  83.963  1.00 30.86           N  
ATOM    853  N   ILE   106      53.219  26.056  85.828  1.00 24.15           N  
ATOM    854  CA  ILE   106      51.812  25.702  85.893  1.00 23.70           C  
ATOM    855  C   ILE   106      51.012  26.758  85.129  1.00 24.07           C  
ATOM    856  O   ILE   106      51.283  27.961  85.273  1.00 23.40           O  
ATOM    857  CB  ILE   106      51.315  25.707  87.370  1.00 23.94           C  
ATOM    858  CG1 ILE   106      52.172  24.822  88.287  1.00 24.39           C  
ATOM    859  CG2 ILE   106      49.812  25.278  87.470  1.00 25.84           C  
ATOM    860  CD1 ILE   106      51.981  25.208  89.792  1.00 23.01           C  
ATOM    861  N   ARG   107      50.028  26.325  84.338  0.50 24.04           N  
ATOM    863  CA  ARG   107      49.100  27.273  83.687  0.50 23.34           C  
ATOM    865  C   ARG   107      47.662  26.792  83.794  0.50 23.38           C  
ATOM    867  O   ARG   107      47.344  25.687  83.378  0.50 22.72           O  
ATOM    869  CB  ARG   107      49.456  27.488  82.218  0.50 24.11           C  
ATOM    871  CG  ARG   107      48.687  28.627  81.527  0.50 24.57           C  
ATOM    873  CD  ARG   107      49.311  28.860  80.166  0.50 31.13           C  
ATOM    875  NE  ARG   107      49.187  30.218  79.624  0.50 34.92           N  
ATOM    877  CZ  ARG   107      50.028  30.709  78.711  0.50 36.28           C  
ATOM    879  NH1 ARG   107      49.891  31.937  78.227  0.50 38.84           N  
ATOM    881  NH2 ARG   107      51.034  29.966  78.284  0.50 38.53           N  
ATOM    883  N   LEU   108      46.802  27.636  84.363  1.00 22.78           N  
ATOM    884  CA  LEU   108      45.371  27.345  84.442  1.00 23.07           C  
ATOM    885  C   LEU   108      44.784  27.829  83.126  1.00 23.31           C  
ATOM    886  O   LEU   108      44.761  29.032  82.856  1.00 23.84           O  
ATOM    887  CB  LEU   108      44.761  28.082  85.633  1.00 23.51           C  
ATOM    888  CG  LEU   108      45.548  27.835  86.936  1.00 23.62           C  
ATOM    889  CD1 LEU   108      44.924  28.674  88.092  1.00 27.25           C  
ATOM    890  CD2 LEU   108      45.526  26.358  87.255  1.00 24.88           C  
ATOM    891  N   LEU   109      44.350  26.895  82.290  1.00 23.14           N  
ATOM    892  CA  LEU   109      43.906  27.234  80.950  1.00 23.54           C  
ATOM    893  C   LEU   109      42.371  27.321  80.899  1.00 23.77           C  
ATOM    894  O   LEU   109      41.670  26.338  80.524  1.00 23.71           O  
ATOM    895  CB  LEU   109      44.483  26.250  79.911  1.00 23.98           C  
ATOM    896  CG  LEU   109      44.344  26.668  78.425  1.00 25.11           C  
ATOM    897  CD1 LEU   109      45.396  27.742  78.054  1.00 24.78           C  
ATOM    898  CD2 LEU   109      44.447  25.467  77.474  1.00 25.64           C  
ATOM    899  N   HIS   110      41.852  28.462  81.362  1.00 22.67           N  
ATOM    900  CA  HIS   110      40.377  28.713  81.353  1.00 22.13           C  
ATOM    901  C   HIS   110      39.998  29.153  79.949  1.00 21.73           C  
ATOM    902  O   HIS   110      40.876  29.580  79.174  1.00 22.49           O  
ATOM    903  CB  HIS   110      40.034  29.763  82.443  1.00 22.73           C  
ATOM    904  CG  HIS   110      38.567  29.938  82.715  1.00 22.61           C  
ATOM    905  ND1 HIS   110      37.757  30.759  81.963  1.00 24.29           N  
ATOM    906  CD2 HIS   110      37.790  29.454  83.719  1.00 23.03           C  
ATOM    907  CE1 HIS   110      36.528  30.753  82.469  1.00 25.00           C  
ATOM    908  NE2 HIS   110      36.522  29.962  83.538  1.00 25.22           N  
ATOM    909  N   GLU   111      38.716  29.037  79.575  1.00 21.19           N  
ATOM    910  CA  GLU   111      38.306  29.511  78.231  1.00 21.14           C  
ATOM    911  C   GLU   111      38.210  31.034  78.104  1.00 20.87           C  
ATOM    912  O   GLU   111      38.114  31.563  77.003  1.00 20.50           O  
ATOM    913  CB  GLU   111      37.042  28.786  77.746  1.00 23.05           C  
ATOM    914  CG  GLU   111      35.742  29.222  78.438  1.00 23.31           C  
ATOM    915  CD  GLU   111      35.458  28.586  79.810  1.00 26.37           C  
ATOM    916  OE1 GLU   111      36.334  27.994  80.494  1.00 24.08           O  
ATOM    917  OE2 GLU   111      34.280  28.711  80.238  1.00 27.05           O  
ATOM    918  N   LYS   112      38.245  31.721  79.250  0.50 20.92           N  
ATOM    920  CA  LYS   112      38.087  33.177  79.310  0.50 20.70           C  
ATOM    922  C   LYS   112      39.411  33.903  79.618  0.50 21.25           C  
ATOM    924  O   LYS   112      39.564  35.113  79.341  0.50 20.94           O  
ATOM    926  CB  LYS   112      36.999  33.550  80.361  0.50 20.26           C  
ATOM    928  CG  LYS   112      36.773  35.067  80.503  0.50 19.15           C  
ATOM    930  CD  LYS   112      36.331  35.672  79.152  0.50 20.20           C  
ATOM    932  CE  LYS   112      36.541  37.191  79.051  0.50 16.26           C  
ATOM    934  NZ  LYS   112      37.931  37.622  79.298  0.50  9.90           N  
ATOM    936  N   TYR   113      40.364  33.180  80.195  1.00 20.88           N  
ATOM    937  CA  TYR   113      41.644  33.777  80.572  1.00 21.91           C  
ATOM    938  C   TYR   113      42.609  32.662  80.866  1.00 22.49           C  
ATOM    939  O   TYR   113      42.204  31.497  81.013  1.00 21.81           O  
ATOM    940  CB  TYR   113      41.512  34.699  81.838  1.00 22.60           C  
ATOM    941  CG  TYR   113      40.792  33.962  82.959  1.00 24.25           C  
ATOM    942  CD1 TYR   113      41.488  33.060  83.770  1.00 25.82           C  
ATOM    943  CD2 TYR   113      39.435  34.120  83.174  1.00 27.52           C  
ATOM    944  CE1 TYR   113      40.835  32.355  84.794  1.00 26.93           C  
ATOM    945  CE2 TYR   113      38.768  33.403  84.192  1.00 28.33           C  
ATOM    946  CZ  TYR   113      39.482  32.520  84.966  1.00 27.71           C  
ATOM    947  OH  TYR   113      38.878  31.808  86.005  1.00 32.23           O  
ATOM    948  N   SER   114      43.889  33.007  80.988  1.00 22.58           N  
ATOM    949  CA  SER   114      44.862  32.027  81.438  1.00 23.73           C  
ATOM    950  C   SER   114      45.713  32.702  82.533  1.00 23.87           C  
ATOM    951  O   SER   114      46.090  33.887  82.417  1.00 22.05           O  
ATOM    952  CB  SER   114      45.689  31.562  80.243  1.00 25.99           C  
ATOM    953  OG  SER   114      46.805  30.826  80.655  1.00 34.48           O  
ATOM    954  N   ILE   115      46.051  31.937  83.572  1.00 23.45           N  
ATOM    955  CA  ILE   115      46.928  32.458  84.610  1.00 24.88           C  
ATOM    956  C   ILE   115      47.953  31.398  84.897  1.00 24.20           C  
ATOM    957  O   ILE   115      47.590  30.243  85.084  1.00 24.37           O  
ATOM    958  CB  ILE   115      46.165  32.731  85.930  1.00 25.11           C  
ATOM    959  CG1 ILE   115      44.833  33.404  85.669  1.00 26.95           C  
ATOM    960  CG2 ILE   115      47.031  33.614  86.880  1.00 26.89           C  
ATOM    961  CD1 ILE   115      43.951  33.559  86.953  1.00 28.56           C  
ATOM    962  N   GLY   116      49.216  31.791  84.969  1.00 24.03           N  
ATOM    963  CA  GLY   116      50.315  30.833  85.268  1.00 24.05           C  
ATOM    964  C   GLY   116      51.233  31.370  86.360  1.00 23.76           C  
ATOM    965  O   GLY   116      51.115  32.543  86.770  1.00 22.74           O  
ATOM    966  N   ASN   117      52.159  30.526  86.818  1.00 23.26           N  
ATOM    967  CA  ASN   117      53.212  30.957  87.726  1.00 23.63           C  
ATOM    968  C   ASN   117      54.449  31.425  86.946  1.00 23.90           C  
ATOM    969  O   ASN   117      54.405  31.524  85.722  1.00 23.64           O  
ATOM    970  CB  ASN   117      53.548  29.855  88.748  1.00 23.14           C  
ATOM    971  CG  ASN   117      54.198  28.612  88.122  1.00 24.21           C  
ATOM    972  OD1 ASN   117      54.250  28.447  86.896  1.00 25.61           O  
ATOM    973  ND2 ASN   117      54.696  27.728  88.977  1.00 26.73           N  
ATOM    974  N   LYS   118      55.529  31.724  87.650  1.00 23.62           N  
ATOM    975  CA  LYS   118      56.711  32.281  87.012  1.00 25.96           C  
ATOM    976  C   LYS   118      57.923  31.374  87.111  1.00 27.77           C  
ATOM    977  O   LYS   118      59.051  31.813  86.842  1.00 28.62           O  
ATOM    978  CB  LYS   118      57.034  33.653  87.623  1.00 25.98           C  
ATOM    979  CG  LYS   118      56.042  34.711  87.226  1.00 25.72           C  
ATOM    980  CD  LYS   118      56.415  36.069  87.807  1.00 28.58           C  
ATOM    981  CE  LYS   118      55.419  37.087  87.370  1.00 30.46           C  
ATOM    982  NZ  LYS   118      55.884  38.458  87.729  1.00 32.10           N  
ATOM    983  N   LYS   119      57.708  30.121  87.489  1.00 29.44           N  
ATOM    984  CA  LYS   119      58.841  29.200  87.654  1.00 32.60           C  
ATOM    985  C   LYS   119      59.461  28.888  86.300  1.00 33.59           C  
ATOM    986  O   LYS   119      58.738  28.571  85.338  1.00 33.10           O  
ATOM    987  CB  LYS   119      58.399  27.894  88.304  1.00 32.75           C  
ATOM    988  CG  LYS   119      58.288  27.960  89.798  1.00 35.91           C  
ATOM    989  CD  LYS   119      58.459  26.579  90.421  1.00 37.54           C  
ATOM    990  CE  LYS   119      58.129  26.650  91.897  1.00 39.43           C  
ATOM    991  NZ  LYS   119      57.866  25.305  92.472  1.00 40.56           N  
ATOM    992  N   LYS   120      60.790  29.007  86.240  1.00 36.02           N  
ATOM    993  CA  LYS   120      61.578  28.654  85.063  1.00 38.02           C  
ATOM    994  C   LYS   120      61.896  27.170  85.118  1.00 39.04           C  
ATOM    995  O   LYS   120      62.296  26.657  86.164  1.00 38.77           O  
ATOM    996  CB  LYS   120      62.886  29.453  85.030  1.00 38.32           C  
ATOM    997  CG  LYS   120      62.694  30.945  84.772  1.00 40.54           C  
ATOM    998  CD  LYS   120      63.861  31.747  85.335  1.00 44.73           C  
ATOM    999  CE  LYS   120      63.444  33.184  85.676  1.00 46.55           C  
ATOM   1000  NZ  LYS   120      62.821  33.882  84.512  1.00 48.28           N  
ATOM   1001  N   VAL   121      61.689  26.475  84.005  1.00 40.06           N  
ATOM   1002  CA  VAL   121      62.090  25.076  83.913  1.00 42.36           C  
ATOM   1003  C   VAL   121      63.024  24.879  82.729  1.00 43.96           C  
ATOM   1004  O   VAL   121      62.907  25.576  81.713  1.00 44.09           O  
ATOM   1005  CB  VAL   121      60.890  24.090  83.829  1.00 42.18           C  
ATOM   1006  CG1 VAL   121      60.113  24.078  85.145  1.00 42.37           C  
ATOM   1007  CG2 VAL   121      59.973  24.426  82.657  1.00 42.77           C  
ATOM   1008  N   ASN   122      63.956  23.942  82.881  1.00 46.08           N  
ATOM   1009  CA  ASN   122      64.798  23.497  81.784  1.00 48.39           C  
ATOM   1010  C   ASN   122      63.967  22.638  80.835  1.00 49.57           C  
ATOM   1011  O   ASN   122      63.999  21.405  80.907  1.00 50.16           O  
ATOM   1012  CB  ASN   122      66.000  22.705  82.317  1.00 48.37           C  
ATOM   1013  CG  ASN   122      66.775  23.462  83.391  1.00 50.19           C  
ATOM   1014  OD1 ASN   122      66.642  24.684  83.540  1.00 51.78           O  
ATOM   1015  ND2 ASN   122      67.594  22.733  84.150  1.00 51.79           N  
ATOM   1016  N   SER   123      63.204  23.306  79.970  1.00 50.84           N  
ATOM   1017  CA  SER   123      62.344  22.642  78.997  1.00 52.09           C  
ATOM   1018  C   SER   123      62.412  23.349  77.638  1.00 52.92           C  
ATOM   1019  O   SER   123      61.943  24.490  77.493  1.00 52.90           O  
ATOM   1020  CB  SER   123      60.897  22.581  79.517  1.00 51.99           C  
ATOM   1021  OG  SER   123      59.973  22.350  78.464  1.00 52.51           O  
ATOM   1022  N   ASN   124      62.996  22.661  76.655  1.00 54.00           N  
ATOM   1023  CA  ASN   124      63.103  23.175  75.284  1.00 55.02           C  
ATOM   1024  C   ASN   124      61.801  23.189  74.477  1.00 55.68           C  
ATOM   1025  O   ASN   124      61.641  24.014  73.570  1.00 55.59           O  
ATOM   1026  CB  ASN   124      64.182  22.418  74.520  1.00 55.34           C  
ATOM   1027  CG  ASN   124      65.570  22.887  74.882  1.00 56.21           C  
ATOM   1028  OD1 ASN   124      65.761  24.036  75.293  1.00 57.93           O  
ATOM   1029  ND2 ASN   124      66.551  22.002  74.740  1.00 57.10           N  
ATOM   1030  N   LEU   125      60.891  22.265  74.803  1.00 56.35           N  
ATOM   1031  CA  LEU   125      59.562  22.196  74.177  1.00 56.84           C  
ATOM   1032  C   LEU   125      58.695  23.350  74.654  1.00 57.24           C  
ATOM   1033  O   LEU   125      57.808  23.802  73.929  1.00 57.49           O  
ATOM   1034  CB  LEU   125      58.866  20.851  74.461  1.00 56.60           C  
ATOM   1035  CG  LEU   125      59.414  19.595  73.764  1.00 56.47           C  
ATOM   1036  CD1 LEU   125      58.959  18.320  74.476  1.00 54.67           C  
ATOM   1037  CD2 LEU   125      59.050  19.566  72.271  1.00 55.55           C  
ATOM   1038  N   LEU   126      58.945  23.818  75.876  1.00 57.73           N  
ATOM   1039  CA  LEU   126      58.324  25.055  76.352  1.00 58.17           C  
ATOM   1040  C   LEU   126      58.840  26.226  75.516  1.00 58.38           C  
ATOM   1041  O   LEU   126      58.062  27.066  75.082  1.00 58.75           O  
ATOM   1042  CB  LEU   126      58.581  25.290  77.852  1.00 58.02           C  
ATOM   1043  CG  LEU   126      57.955  26.537  78.497  1.00 57.92           C  
ATOM   1044  CD1 LEU   126      56.442  26.615  78.265  1.00 57.28           C  
ATOM   1045  CD2 LEU   126      58.279  26.613  79.991  1.00 58.15           C  
ATOM   1046  N   GLY   127      60.150  26.255  75.277  1.00 58.51           N  
ATOM   1047  CA  GLY   127      60.762  27.265  74.414  1.00 58.47           C  
ATOM   1048  C   GLY   127      60.290  27.216  72.967  1.00 58.45           C  
ATOM   1049  O   GLY   127      60.195  28.256  72.312  1.00 58.83           O  
ATOM   1050  N   LYS   128      59.991  26.014  72.469  1.00 57.98           N  
ATOM   1051  CA  LYS   128      59.581  25.817  71.069  1.00 57.26           C  
ATOM   1052  C   LYS   128      58.092  26.112  70.828  1.00 56.69           C  
ATOM   1053  O   LYS   128      57.711  26.555  69.737  1.00 56.67           O  
ATOM   1054  CB  LYS   128      59.929  24.404  70.605  1.00 57.30           C  
ATOM   1055  N   ALA   129      57.264  25.872  71.847  1.00 55.52           N  
ATOM   1056  CA  ALA   129      55.808  26.000  71.733  1.00 54.54           C  
ATOM   1057  C   ALA   129      55.388  27.394  71.249  1.00 53.82           C  
ATOM   1058  O   ALA   129      55.832  28.398  71.805  1.00 53.76           O  
ATOM   1059  CB  ALA   129      55.143  25.663  73.068  1.00 54.53           C  
ATOM   1060  N   LEU   130      54.543  27.440  70.211  1.00 52.88           N  
ATOM   1061  CA  LEU   130      54.035  28.707  69.641  1.00 51.94           C  
ATOM   1062  C   LEU   130      53.223  29.499  70.664  1.00 51.64           C  
ATOM   1063  O   LEU   130      52.291  28.969  71.270  1.00 51.01           O  
ATOM   1064  CB  LEU   130      53.172  28.455  68.392  1.00 51.60           C  
ATOM   1065  CG  LEU   130      53.828  27.999  67.081  1.00 51.08           C  
ATOM   1066  CD1 LEU   130      52.812  27.305  66.145  1.00 49.55           C  
ATOM   1067  CD2 LEU   130      54.536  29.169  66.372  1.00 50.62           C  
ATOM   1068  N   ILE   131      53.604  30.760  70.860  1.00 51.30           N  
ATOM   1069  CA  ILE   131      52.826  31.703  71.671  1.00 51.22           C  
ATOM   1070  C   ILE   131      51.834  32.416  70.748  1.00 50.60           C  
ATOM   1071  O   ILE   131      52.197  32.851  69.643  1.00 50.90           O  
ATOM   1072  CB  ILE   131      53.726  32.738  72.414  1.00 50.95           C  
ATOM   1073  CG1 ILE   131      54.705  32.021  73.351  1.00 51.52           C  
ATOM   1074  CG2 ILE   131      52.868  33.728  73.217  1.00 52.11           C  
ATOM   1075  CD1 ILE   131      55.385  32.932  74.394  1.00 52.02           C  
ATOM   1076  N   HIS   132      50.584  32.504  71.194  1.00 49.50           N  
ATOM   1077  CA  HIS   132      49.535  33.212  70.451  1.00 48.50           C  
ATOM   1078  C   HIS   132      48.919  34.304  71.336  1.00 47.17           C  
ATOM   1079  O   HIS   132      48.984  34.203  72.571  1.00 47.31           O  
ATOM   1080  CB  HIS   132      48.478  32.246  69.877  1.00 48.91           C  
ATOM   1081  CG  HIS   132      48.268  31.007  70.692  1.00 49.29           C  
ATOM   1082  ND1 HIS   132      47.175  30.834  71.514  1.00 49.90           N  
ATOM   1083  CD2 HIS   132      49.004  29.872  70.798  1.00 50.80           C  
ATOM   1084  CE1 HIS   132      47.246  29.647  72.095  1.00 51.14           C  
ATOM   1085  NE2 HIS   132      48.348  29.042  71.682  1.00 50.86           N  
ATOM   1086  N   PRO   133      48.316  35.336  70.708  1.00 45.46           N  
ATOM   1087  CA  PRO   133      47.994  36.583  71.396  1.00 43.38           C  
ATOM   1088  C   PRO   133      47.016  36.414  72.561  1.00 40.66           C  
ATOM   1089  O   PRO   133      46.119  35.565  72.520  1.00 41.64           O  
ATOM   1090  CB  PRO   133      47.329  37.423  70.302  1.00 43.53           C  
ATOM   1091  CG  PRO   133      47.768  36.811  69.009  1.00 45.34           C  
ATOM   1092  CD  PRO   133      47.876  35.365  69.296  1.00 45.87           C  
ATOM   1093  N   SER   134      47.199  37.212  73.596  1.00 36.90           N  
ATOM   1094  CA  SER   134      46.129  37.393  74.558  1.00 32.79           C  
ATOM   1095  C   SER   134      45.240  38.480  73.920  1.00 30.34           C  
ATOM   1096  O   SER   134      45.583  39.066  72.859  1.00 27.78           O  
ATOM   1097  CB  SER   134      46.681  37.865  75.905  1.00 32.87           C  
ATOM   1098  OG  SER   134      46.999  39.272  75.900  1.00 36.95           O  
ATOM   1099  N   ASP   135      44.110  38.758  74.562  1.00 26.67           N  
ATOM   1100  CA  ASP   135      43.355  39.956  74.228  1.00 24.35           C  
ATOM   1101  C   ASP   135      42.937  40.503  75.578  1.00 23.50           C  
ATOM   1102  O   ASP   135      42.429  39.743  76.426  1.00 22.77           O  
ATOM   1103  CB  ASP   135      42.143  39.649  73.336  1.00 25.82           C  
ATOM   1104  CG  ASP   135      41.363  40.911  72.984  1.00 25.41           C  
ATOM   1105  OD1 ASP   135      41.675  41.547  71.958  1.00 25.59           O  
ATOM   1106  OD2 ASP   135      40.490  41.331  73.771  1.00 24.43           O  
ATOM   1107  N   PRO   136      43.198  41.790  75.808  1.00 22.46           N  
ATOM   1108  CA  PRO   136      42.929  42.348  77.140  1.00 22.89           C  
ATOM   1109  C   PRO   136      41.455  42.294  77.548  1.00 22.23           C  
ATOM   1110  O   PRO   136      41.179  42.356  78.738  1.00 22.64           O  
ATOM   1111  CB  PRO   136      43.431  43.799  77.049  1.00 23.21           C  
ATOM   1112  CG  PRO   136      43.673  44.067  75.587  1.00 23.98           C  
ATOM   1113  CD  PRO   136      43.811  42.758  74.877  1.00 22.40           C  
ATOM   1114  N   ILE   137      40.524  42.184  76.591  1.00 20.68           N  
ATOM   1115  CA  ILE   137      39.112  41.996  76.964  1.00 19.92           C  
ATOM   1116  C   ILE   137      38.774  40.516  76.974  1.00 20.18           C  
ATOM   1117  O   ILE   137      38.279  40.006  77.986  1.00 20.43           O  
ATOM   1118  CB  ILE   137      38.137  42.764  76.029  1.00 20.48           C  
ATOM   1119  CG1 ILE   137      38.385  44.278  76.112  1.00 20.36           C  
ATOM   1120  CG2 ILE   137      36.627  42.411  76.341  1.00 22.15           C  
ATOM   1121  CD1 ILE   137      37.485  45.058  75.112  1.00 21.69           C  
ATOM   1122  N   PHE   138      39.016  39.836  75.853  1.00 18.81           N  
ATOM   1123  CA  PHE   138      38.439  38.488  75.650  1.00 19.03           C  
ATOM   1124  C   PHE   138      39.267  37.350  76.188  1.00 19.99           C  
ATOM   1125  O   PHE   138      38.754  36.210  76.400  1.00 19.78           O  
ATOM   1126  CB  PHE   138      38.096  38.292  74.155  1.00 19.06           C  
ATOM   1127  CG  PHE   138      37.009  39.214  73.704  1.00 19.34           C  
ATOM   1128  CD1 PHE   138      35.684  38.964  74.080  1.00 21.10           C  
ATOM   1129  CD2 PHE   138      37.302  40.382  73.015  1.00 16.73           C  
ATOM   1130  CE1 PHE   138      34.654  39.863  73.698  1.00 18.53           C  
ATOM   1131  CE2 PHE   138      36.335  41.269  72.634  1.00 18.95           C  
ATOM   1132  CZ  PHE   138      34.966  41.025  72.975  1.00 18.88           C  
ATOM   1133  N   TYR   139      40.574  37.598  76.353  1.00 19.75           N  
ATOM   1134  CA  TYR   139      41.473  36.518  76.824  1.00 20.53           C  
ATOM   1135  C   TYR   139      42.730  37.039  77.496  1.00 20.57           C  
ATOM   1136  O   TYR   139      43.808  36.972  76.900  1.00 21.22           O  
ATOM   1137  CB  TYR   139      41.863  35.509  75.694  1.00 20.94           C  
ATOM   1138  CG  TYR   139      42.222  34.171  76.296  1.00 21.08           C  
ATOM   1139  CD1 TYR   139      43.567  33.812  76.545  1.00 22.13           C  
ATOM   1140  CD2 TYR   139      41.214  33.276  76.683  1.00 20.13           C  
ATOM   1141  CE1 TYR   139      43.898  32.604  77.159  1.00 22.09           C  
ATOM   1142  CE2 TYR   139      41.532  32.055  77.296  1.00 21.50           C  
ATOM   1143  CZ  TYR   139      42.875  31.743  77.552  1.00 21.15           C  
ATOM   1144  OH  TYR   139      43.190  30.548  78.146  1.00 22.82           O  
ATOM   1145  N   PRO   140      42.597  37.619  78.700  1.00 21.01           N  
ATOM   1146  CA  PRO   140      43.777  38.101  79.413  1.00 22.31           C  
ATOM   1147  C   PRO   140      44.679  36.951  79.793  1.00 23.43           C  
ATOM   1148  O   PRO   140      44.191  35.850  80.126  1.00 23.59           O  
ATOM   1149  CB  PRO   140      43.192  38.797  80.681  1.00 21.99           C  
ATOM   1150  CG  PRO   140      41.750  38.988  80.419  1.00 21.63           C  
ATOM   1151  CD  PRO   140      41.343  37.925  79.415  1.00 20.43           C  
ATOM   1152  N   VAL   141      45.989  37.165  79.680  1.00 24.46           N  
ATOM   1153  CA  VAL   141      46.979  36.148  80.079  1.00 26.37           C  
ATOM   1154  C   VAL   141      47.938  36.813  81.087  1.00 27.37           C  
ATOM   1155  O   VAL   141      48.544  37.861  80.777  1.00 26.66           O  
ATOM   1156  CB  VAL   141      47.726  35.569  78.858  1.00 27.66           C  
ATOM   1157  CG1 VAL   141      48.822  34.571  79.312  1.00 28.57           C  
ATOM   1158  CG2 VAL   141      46.738  34.851  77.878  1.00 27.79           C  
ATOM   1159  N   GLN   142      48.012  36.276  82.304  1.00 26.50           N  
ATOM   1160  CA  GLN   142      48.876  36.842  83.335  0.50 27.56           C  
ATOM   1162  C   GLN   142      49.671  35.766  84.046  1.00 27.33           C  
ATOM   1163  O   GLN   142      49.246  34.621  84.121  1.00 27.54           O  
ATOM   1164  CB  GLN   142      48.087  37.634  84.385  0.50 28.43           C  
ATOM   1166  CG  GLN   142      48.949  37.900  85.613  0.50 30.06           C  
ATOM   1168  CD  GLN   142      48.548  39.080  86.480  0.50 30.99           C  
ATOM   1170  OE1 GLN   142      47.429  39.601  86.410  0.50 35.08           O  
ATOM   1172  NE2 GLN   142      49.482  39.516  87.299  0.50 32.11           N  
ATOM   1174  N   PHE   143      50.827  36.155  84.572  1.00 27.05           N  
ATOM   1175  CA  PHE   143      51.649  35.294  85.396  1.00 27.00           C  
ATOM   1176  C   PHE   143      51.794  35.938  86.762  1.00 27.02           C  
ATOM   1177  O   PHE   143      51.782  37.171  86.878  1.00 27.45           O  
ATOM   1178  CB  PHE   143      52.994  35.065  84.717  1.00 28.14           C  
ATOM   1179  CG  PHE   143      52.829  34.506  83.345  1.00 32.02           C  
ATOM   1180  CD1 PHE   143      52.469  33.192  83.179  1.00 35.41           C  
ATOM   1181  CD2 PHE   143      52.871  35.331  82.236  1.00 36.59           C  
ATOM   1182  CE1 PHE   143      52.244  32.657  81.901  1.00 39.26           C  
ATOM   1183  CE2 PHE   143      52.665  34.803  80.973  1.00 38.51           C  
ATOM   1184  CZ  PHE   143      52.362  33.463  80.808  1.00 36.64           C  
ATOM   1185  N   VAL   144      51.844  35.101  87.794  1.00 25.14           N  
ATOM   1186  CA  VAL   144      52.039  35.567  89.159  1.00 23.87           C  
ATOM   1187  C   VAL   144      53.121  34.715  89.777  1.00 23.62           C  
ATOM   1188  O   VAL   144      53.361  33.571  89.328  1.00 22.77           O  
ATOM   1189  CB  VAL   144      50.714  35.477  90.001  1.00 24.41           C  
ATOM   1190  CG1 VAL   144      49.709  36.495  89.505  1.00 25.17           C  
ATOM   1191  CG2 VAL   144      50.081  34.042  89.932  1.00 23.84           C  
ATOM   1192  N   GLU   145      53.765  35.250  90.813  1.00 22.68           N  
ATOM   1193  CA  GLU   145      54.763  34.491  91.551  0.50 22.85           C  
ATOM   1195  C   GLU   145      54.113  33.351  92.318  1.00 23.69           C  
ATOM   1196  O   GLU   145      54.665  32.250  92.375  1.00 23.67           O  
ATOM   1197  CB  GLU   145      55.522  35.400  92.504  0.50 22.64           C  
ATOM   1199  CG  GLU   145      56.665  34.738  93.232  0.50 20.07           C  
ATOM   1201  CD  GLU   145      57.330  35.678  94.201  0.50 20.81           C  
ATOM   1203  OE1 GLU   145      56.788  36.772  94.422  0.50 17.89           O  
ATOM   1205  OE2 GLU   145      58.399  35.328  94.737  0.50 20.29           O  
ATOM   1207  N   SER   146      52.933  33.608  92.906  1.00 23.58           N  
ATOM   1208  CA  SER   146      52.247  32.561  93.679  1.00 23.76           C  
ATOM   1209  C   SER   146      50.813  32.345  93.217  1.00 23.53           C  
ATOM   1210  O   SER   146      49.903  33.147  93.548  1.00 22.79           O  
ATOM   1211  CB  SER   146      52.261  32.844  95.188  1.00 25.42           C  
ATOM   1212  OG  SER   146      51.515  31.830  95.861  1.00 24.46           O  
ATOM   1213  N   LEU   147      50.606  31.269  92.467  1.00 22.89           N  
ATOM   1214  CA  LEU   147      49.248  30.958  91.999  1.00 23.97           C  
ATOM   1215  C   LEU   147      48.295  30.642  93.155  1.00 24.07           C  
ATOM   1216  O   LEU   147      47.162  31.144  93.202  1.00 24.91           O  
ATOM   1217  CB  LEU   147      49.252  29.761  91.056  1.00 24.97           C  
ATOM   1218  CG  LEU   147      49.391  30.006  89.573  1.00 28.73           C  
ATOM   1219  CD1 LEU   147      49.332  28.637  88.870  1.00 29.98           C  
ATOM   1220  CD2 LEU   147      48.277  30.946  89.055  1.00 29.01           C  
ATOM   1221  N   SER   148      48.743  29.812  94.089  1.00 23.93           N  
ATOM   1222  CA  SER   148      47.875  29.425  95.200  1.00 24.47           C  
ATOM   1223  C   SER   148      47.493  30.644  96.070  1.00 25.45           C  
ATOM   1224  O   SER   148      46.326  30.747  96.503  1.00 26.17           O  
ATOM   1225  CB  SER   148      48.506  28.300  96.018  1.00 24.85           C  
ATOM   1226  OG  SER   148      49.614  28.833  96.736  1.00 25.70           O  
ATOM   1227  N   ASP   149      48.400  31.608  96.265  1.00 24.13           N  
ATOM   1228  CA  ASP   149      48.009  32.829  96.992  1.00 25.46           C  
ATOM   1229  C   ASP   149      46.912  33.594  96.255  1.00 25.07           C  
ATOM   1230  O   ASP   149      45.987  34.094  96.886  1.00 24.95           O  
ATOM   1231  CB  ASP   149      49.182  33.792  97.289  1.00 25.22           C  
ATOM   1232  CG  ASP   149      50.063  33.338  98.455  1.00 27.73           C  
ATOM   1233  OD1 ASP   149      49.745  32.347  99.159  1.00 30.52           O  
ATOM   1234  OD2 ASP   149      51.114  33.988  98.674  1.00 28.84           O  
ATOM   1235  N   LEU   150      47.035  33.705  94.935  1.00 24.21           N  
ATOM   1236  CA  LEU   150      46.026  34.408  94.132  1.00 24.99           C  
ATOM   1237  C   LEU   150      44.669  33.736  94.275  1.00 23.83           C  
ATOM   1238  O   LEU   150      43.666  34.423  94.529  1.00 23.98           O  
ATOM   1239  CB  LEU   150      46.437  34.409  92.652  1.00 24.98           C  
ATOM   1240  CG  LEU   150      45.430  35.147  91.781  1.00 28.95           C  
ATOM   1241  CD1 LEU   150      45.747  36.615  91.911  1.00 33.55           C  
ATOM   1242  CD2 LEU   150      45.517  34.703  90.357  1.00 33.58           C  
ATOM   1243  N   LEU   151      44.661  32.402  94.155  1.00 23.37           N  
ATOM   1244  CA  LEU   151      43.430  31.578  94.210  1.00 24.42           C  
ATOM   1245  C   LEU   151      42.676  31.644  95.548  1.00 25.69           C  
ATOM   1246  O   LEU   151      41.456  31.361  95.610  1.00 24.99           O  
ATOM   1247  CB  LEU   151      43.743  30.109  93.857  1.00 24.38           C  
ATOM   1248  CG  LEU   151      44.292  29.812  92.448  1.00 25.82           C  
ATOM   1249  CD1 LEU   151      44.552  28.317  92.202  1.00 24.27           C  
ATOM   1250  CD2 LEU   151      43.390  30.322  91.365  1.00 27.53           C  
ATOM   1251  N   MET   152      43.384  32.015  96.608  1.00 27.18           N  
ATOM   1252  CA  MET   152      42.722  32.248  97.911  1.00 30.40           C  
ATOM   1253  C   MET   152      41.563  33.251  97.805  1.00 28.35           C  
ATOM   1254  O   MET   152      40.534  33.061  98.441  1.00 29.16           O  
ATOM   1255  CB  MET   152      43.714  32.773  98.945  1.00 29.91           C  
ATOM   1256  CG  MET   152      44.982  32.002  99.019  1.00 34.04           C  
ATOM   1257  SD  MET   152      45.240  31.124 100.702  0.40 39.80          SE  
ATOM   1258  CE  MET   152      43.660  29.981 100.571  1.00 36.69           C  
ATOM   1259  N   ASP   153      41.752  34.330  97.047  1.00 25.94           N  
ATOM   1260  CA  ASP   153      40.748  35.373  96.919  1.00 25.38           C  
ATOM   1261  C   ASP   153      40.095  35.363  95.539  1.00 24.78           C  
ATOM   1262  O   ASP   153      39.049  35.977  95.354  1.00 23.83           O  
ATOM   1263  CB  ASP   153      41.374  36.743  97.181  1.00 26.73           C  
ATOM   1264  CG  ASP   153      41.761  36.911  98.636  1.00 28.73           C  
ATOM   1265  OD1 ASP   153      40.846  36.873  99.479  1.00 32.78           O  
ATOM   1266  OD2 ASP   153      42.962  37.078  98.930  1.00 35.47           O  
ATOM   1267  N   GLU   154      40.729  34.673  94.587  1.00 23.72           N  
ATOM   1268  CA  GLU   154      40.212  34.586  93.214  1.00 23.81           C  
ATOM   1269  C   GLU   154      40.196  33.127  92.800  1.00 23.78           C  
ATOM   1270  O   GLU   154      41.078  32.679  92.090  1.00 24.78           O  
ATOM   1271  CB  GLU   154      41.075  35.402  92.234  1.00 24.00           C  
ATOM   1272  CG  GLU   154      41.017  36.942  92.468  1.00 24.87           C  
ATOM   1273  CD  GLU   154      39.622  37.565  92.203  1.00 26.70           C  
ATOM   1274  OE1 GLU   154      38.696  36.897  91.659  1.00 27.11           O  
ATOM   1275  OE2 GLU   154      39.454  38.759  92.527  1.00 28.82           O  
ATOM   1276  N   PRO   155      39.174  32.378  93.231  1.00 23.99           N  
ATOM   1277  CA  PRO   155      39.097  30.956  92.849  1.00 23.75           C  
ATOM   1278  C   PRO   155      39.028  30.812  91.328  1.00 23.44           C  
ATOM   1279  O   PRO   155      38.481  31.694  90.625  1.00 23.07           O  
ATOM   1280  CB  PRO   155      37.803  30.470  93.511  1.00 24.07           C  
ATOM   1281  CG  PRO   155      37.448  31.506  94.521  1.00 26.30           C  
ATOM   1282  CD  PRO   155      38.059  32.798  94.094  1.00 24.56           C  
ATOM   1283  N   VAL   156      39.615  29.740  90.817  1.00 21.71           N  
ATOM   1284  CA  VAL   156      39.513  29.441  89.369  1.00 23.19           C  
ATOM   1285  C   VAL   156      39.026  28.008  89.195  1.00 23.59           C  
ATOM   1286  O   VAL   156      39.521  27.102  89.864  1.00 23.15           O  
ATOM   1287  CB  VAL   156      40.891  29.621  88.672  1.00 22.90           C  
ATOM   1288  CG1 VAL   156      40.910  29.090  87.225  1.00 23.40           C  
ATOM   1289  CG2 VAL   156      41.298  31.112  88.662  1.00 22.77           C  
ATOM   1290  N   SER   157      38.051  27.804  88.307  1.00 24.28           N  
ATOM   1291  CA  SER   157      37.609  26.454  87.979  1.00 24.79           C  
ATOM   1292  C   SER   157      38.050  26.188  86.543  1.00 26.87           C  
ATOM   1293  O   SER   157      37.402  26.617  85.601  1.00 28.41           O  
ATOM   1294  CB  SER   157      36.087  26.321  88.133  1.00 24.36           C  
ATOM   1295  OG  SER   157      35.705  24.959  87.976  1.00 26.36           O  
ATOM   1296  N   ALA   158      39.170  25.495  86.443  1.00 28.06           N  
ATOM   1297  CA  ALA   158      39.968  25.298  85.239  1.00 29.72           C  
ATOM   1298  C   ALA   158      39.486  24.078  84.424  1.00 27.18           C  
ATOM   1299  O   ALA   158      39.467  23.000  84.980  1.00 28.44           O  
ATOM   1300  CB  ALA   158      41.404  25.023  85.736  1.00 30.50           C  
ATOM   1301  N   PRO   159      39.160  24.227  83.109  1.00 26.69           N  
ATOM   1302  CA  PRO   159      38.952  22.994  82.309  1.00 25.77           C  
ATOM   1303  C   PRO   159      40.219  22.126  82.200  1.00 25.72           C  
ATOM   1304  O   PRO   159      40.085  20.904  82.101  1.00 25.92           O  
ATOM   1305  CB  PRO   159      38.523  23.518  80.917  1.00 26.68           C  
ATOM   1306  CG  PRO   159      38.026  24.973  81.231  1.00 25.87           C  
ATOM   1307  CD  PRO   159      38.925  25.431  82.297  1.00 26.71           C  
ATOM   1308  N   VAL   160      41.406  22.760  82.177  1.00 25.07           N  
ATOM   1309  CA  VAL   160      42.715  22.083  82.031  0.50 24.81           C  
ATOM   1311  C   VAL   160      43.762  22.827  82.863  1.00 24.91           C  
ATOM   1312  O   VAL   160      43.764  24.069  82.888  1.00 24.66           O  
ATOM   1313  CB  VAL   160      43.206  22.066  80.553  0.50 25.24           C  
ATOM   1315  CG1 VAL   160      44.637  21.498  80.424  0.50 25.55           C  
ATOM   1317  CG2 VAL   160      42.258  21.266  79.680  0.50 23.82           C  
ATOM   1319  N   ILE   161      44.640  22.082  83.516  1.00 24.06           N  
ATOM   1320  CA  ILE   161      45.813  22.637  84.148  1.00 24.65           C  
ATOM   1321  C   ILE   161      47.008  22.055  83.368  1.00 24.59           C  
ATOM   1322  O   ILE   161      47.158  20.804  83.276  1.00 24.67           O  
ATOM   1323  CB  ILE   161      45.861  22.256  85.634  1.00 23.84           C  
ATOM   1324  CG1 ILE   161      44.647  22.865  86.383  1.00 23.65           C  
ATOM   1325  CG2 ILE   161      47.176  22.723  86.286  1.00 25.49           C  
ATOM   1326  CD1 ILE   161      44.449  22.316  87.832  1.00 24.81           C  
ATOM   1327  N   GLU   162      47.832  22.935  82.802  1.00 24.49           N  
ATOM   1328  CA  GLU   162      49.029  22.510  82.004  1.00 25.42           C  
ATOM   1329  C   GLU   162      50.263  22.550  82.886  1.00 25.47           C  
ATOM   1330  O   GLU   162      50.441  23.498  83.683  1.00 25.56           O  
ATOM   1331  CB  GLU   162      49.275  23.449  80.828  1.00 27.13           C  
ATOM   1332  CG  GLU   162      48.122  23.525  79.862  1.00 30.24           C  
ATOM   1333  CD  GLU   162      48.402  24.475  78.703  1.00 36.15           C  
ATOM   1334  OE1 GLU   162      48.943  25.589  78.935  1.00 38.12           O  
ATOM   1335  OE2 GLU   162      48.061  24.115  77.557  1.00 37.86           O  
ATOM   1336  N   VAL   163      51.086  21.519  82.791  1.00 24.32           N  
ATOM   1337  CA  VAL   163      52.240  21.381  83.679  1.00 24.67           C  
ATOM   1338  C   VAL   163      53.469  21.103  82.843  1.00 24.79           C  
ATOM   1339  O   VAL   163      53.529  20.071  82.175  1.00 23.66           O  
ATOM   1340  CB  VAL   163      52.047  20.224  84.669  1.00 24.67           C  
ATOM   1341  CG1 VAL   163      53.234  20.174  85.658  1.00 26.01           C  
ATOM   1342  CG2 VAL   163      50.701  20.365  85.407  1.00 25.37           C  
ATOM   1343  N   TYR   164      54.439  22.022  82.870  1.00 24.12           N  
ATOM   1344  CA  TYR   164      55.685  21.828  82.141  0.50 24.46           C  
ATOM   1346  C   TYR   164      56.800  21.548  83.121  1.00 25.01           C  
ATOM   1347  O   TYR   164      56.932  22.246  84.143  1.00 23.76           O  
ATOM   1348  CB  TYR   164      56.062  23.058  81.320  0.50 24.93           C  
ATOM   1350  CG  TYR   164      55.543  23.084  79.897  0.50 24.76           C  
ATOM   1352  CD1 TYR   164      56.242  22.459  78.865  0.50 25.67           C  
ATOM   1354  CD2 TYR   164      54.371  23.771  79.576  0.50 24.32           C  
ATOM   1356  CE1 TYR   164      55.777  22.495  77.549  0.50 25.23           C  
ATOM   1358  CE2 TYR   164      53.901  23.820  78.258  0.50 25.78           C  
ATOM   1360  CZ  TYR   164      54.618  23.179  77.255  0.50 24.58           C  
ATOM   1362  OH  TYR   164      54.183  23.205  75.955  0.50 26.05           O  
ATOM   1364  N   THR   165      57.598  20.524  82.810  1.00 24.60           N  
ATOM   1365  CA  THR   165      58.721  20.133  83.646  1.00 25.74           C  
ATOM   1366  C   THR   165      59.859  19.571  82.789  1.00 26.38           C  
ATOM   1367  O   THR   165      59.689  19.321  81.584  1.00 25.98           O  
ATOM   1368  CB  THR   165      58.308  19.026  84.664  1.00 26.13           C  
ATOM   1369  OG1 THR   165      58.062  17.796  83.970  1.00 28.08           O  
ATOM   1370  CG2 THR   165      57.063  19.407  85.423  1.00 27.71           C  
ATOM   1371  N   GLU   166      61.014  19.373  83.410  1.00 27.49           N  
ATOM   1372  CA  GLU   166      62.037  18.465  82.849  1.00 28.90           C  
ATOM   1373  C   GLU   166      61.443  17.041  82.813  1.00 28.62           C  
ATOM   1374  O   GLU   166      60.575  16.697  83.625  1.00 27.66           O  
ATOM   1375  CB  GLU   166      63.329  18.485  83.685  1.00 28.88           C  
ATOM   1376  CG  GLU   166      64.035  19.857  83.816  1.00 32.30           C  
ATOM   1377  CD  GLU   166      65.393  19.789  84.587  1.00 33.25           C  
ATOM   1378  OE1 GLU   166      66.261  18.938  84.260  1.00 38.60           O  
ATOM   1379  OE2 GLU   166      65.601  20.604  85.531  1.00 39.33           O  
ATOM   1380  N   HIS   167      61.925  16.187  81.909  1.00 28.85           N  
ATOM   1381  CA  HIS   167      61.309  14.868  81.797  1.00 30.00           C  
ATOM   1382  C   HIS   167      61.433  14.005  83.070  1.00 30.53           C  
ATOM   1383  O   HIS   167      60.535  13.219  83.379  1.00 31.01           O  
ATOM   1384  CB  HIS   167      61.812  14.113  80.568  1.00 30.10           C  
ATOM   1385  CG  HIS   167      61.131  12.793  80.364  1.00 31.45           C  
ATOM   1386  ND1 HIS   167      61.798  11.589  80.450  1.00 33.08           N  
ATOM   1387  CD2 HIS   167      59.834  12.489  80.126  1.00 30.79           C  
ATOM   1388  CE1 HIS   167      60.946  10.601  80.241  1.00 31.32           C  
ATOM   1389  NE2 HIS   167      59.748  11.120  80.042  1.00 34.30           N  
ATOM   1390  N   ASP   168      62.534  14.172  83.800  1.00 31.14           N  
ATOM   1391  CA  ASP   168      62.873  13.310  84.936  1.00 31.77           C  
ATOM   1392  C   ASP   168      61.814  13.207  86.061  1.00 30.99           C  
ATOM   1393  O   ASP   168      61.735  12.179  86.749  1.00 30.88           O  
ATOM   1394  CB  ASP   168      64.282  13.655  85.495  1.00 32.83           C  
ATOM   1395  CG  ASP   168      64.377  15.078  86.118  1.00 35.49           C  
ATOM   1396  OD1 ASP   168      63.511  15.957  85.887  1.00 39.03           O  
ATOM   1397  OD2 ASP   168      65.363  15.318  86.853  1.00 39.88           O  
ATOM   1398  N   ILE   169      60.998  14.248  86.229  1.00 30.06           N  
ATOM   1399  CA  ILE   169      59.994  14.280  87.299  1.00 29.13           C  
ATOM   1400  C   ILE   169      58.536  14.064  86.853  1.00 28.85           C  
ATOM   1401  O   ILE   169      57.628  14.071  87.691  1.00 28.39           O  
ATOM   1402  CB  ILE   169      60.120  15.563  88.179  1.00 29.06           C  
ATOM   1403  CG1 ILE   169      59.759  16.836  87.389  1.00 28.51           C  
ATOM   1404  CG2 ILE   169      61.539  15.629  88.828  1.00 29.06           C  
ATOM   1405  CD1 ILE   169      59.625  18.126  88.261  1.00 28.45           C  
ATOM   1406  N   GLN   170      58.302  13.860  85.554  1.00 28.77           N  
ATOM   1407  CA  GLN   170      56.925  13.670  85.046  1.00 28.63           C  
ATOM   1408  C   GLN   170      56.213  12.484  85.669  1.00 28.72           C  
ATOM   1409  O   GLN   170      55.042  12.559  85.992  1.00 28.16           O  
ATOM   1410  CB  GLN   170      56.906  13.423  83.545  1.00 29.18           C  
ATOM   1411  CG  GLN   170      56.876  14.606  82.707  1.00 28.65           C  
ATOM   1412  CD  GLN   170      56.437  14.259  81.310  1.00 30.21           C  
ATOM   1413  OE1 GLN   170      56.672  13.146  80.822  1.00 26.53           O  
ATOM   1414  NE2 GLN   170      55.799  15.208  80.653  1.00 28.23           N  
ATOM   1415  N   HIS   171      56.919  11.363  85.792  1.00 28.90           N  
ATOM   1416  CA  HIS   171      56.319  10.168  86.369  1.00 29.62           C  
ATOM   1417  C   HIS   171      55.887  10.394  87.832  1.00 29.02           C  
ATOM   1418  O   HIS   171      54.780  10.000  88.228  1.00 29.32           O  
ATOM   1419  CB  HIS   171      57.274   8.979  86.254  1.00 30.17           C  
ATOM   1420  CG  HIS   171      56.769   7.746  86.932  1.00 33.79           C  
ATOM   1421  ND1 HIS   171      55.731   6.993  86.424  1.00 36.44           N  
ATOM   1422  CD2 HIS   171      57.140   7.147  88.089  1.00 36.05           C  
ATOM   1423  CE1 HIS   171      55.503   5.966  87.225  1.00 37.12           C  
ATOM   1424  NE2 HIS   171      56.343   6.037  88.244  1.00 37.28           N  
ATOM   1425  N   ASP   172      56.759  11.031  88.617  1.00 28.48           N  
ATOM   1426  CA  ASP   172      56.457  11.347  90.008  0.50 28.54           C  
ATOM   1428  C   ASP   172      55.253  12.289  90.115  1.00 27.90           C  
ATOM   1429  O   ASP   172      54.340  12.065  90.929  1.00 27.33           O  
ATOM   1430  CB  ASP   172      57.686  11.961  90.689  0.50 29.24           C  
ATOM   1432  CG  ASP   172      57.489  12.207  92.190  0.50 31.34           C  
ATOM   1434  OD1 ASP   172      56.462  11.791  92.776  0.50 34.03           O  
ATOM   1436  OD2 ASP   172      58.388  12.823  92.797  0.50 33.97           O  
ATOM   1438  N   ILE   173      55.242  13.352  89.309  1.00 27.21           N  
ATOM   1439  CA  ILE   173      54.114  14.292  89.356  1.00 26.80           C  
ATOM   1440  C   ILE   173      52.846  13.543  88.987  1.00 27.04           C  
ATOM   1441  O   ILE   173      51.828  13.673  89.675  1.00 26.70           O  
ATOM   1442  CB  ILE   173      54.313  15.495  88.428  1.00 26.32           C  
ATOM   1443  CG1 ILE   173      55.455  16.353  88.959  1.00 28.14           C  
ATOM   1444  CG2 ILE   173      53.003  16.312  88.304  1.00 25.19           C  
ATOM   1445  CD1 ILE   173      55.732  17.600  88.138  1.00 31.54           C  
ATOM   1446  N   THR   174      52.931  12.744  87.921  1.00 27.34           N  
ATOM   1447  CA  THR   174      51.781  11.965  87.422  1.00 27.90           C  
ATOM   1448  C   THR   174      51.231  11.020  88.508  1.00 28.01           C  
ATOM   1449  O   THR   174      50.020  10.972  88.735  1.00 28.15           O  
ATOM   1450  CB  THR   174      52.132  11.156  86.143  1.00 27.98           C  
ATOM   1451  OG1 THR   174      52.556  12.050  85.099  1.00 28.20           O  
ATOM   1452  CG2 THR   174      50.933  10.338  85.675  1.00 27.86           C  
ATOM   1453  N   GLU   175      52.130  10.276  89.156  0.50 27.94           N  
ATOM   1455  CA  GLU   175      51.761   9.383  90.258  0.50 28.08           C  
ATOM   1457  C   GLU   175      51.100  10.168  91.392  0.50 27.46           C  
ATOM   1459  O   GLU   175      50.031   9.787  91.878  0.50 27.74           O  
ATOM   1461  CB  GLU   175      52.989   8.607  90.779  0.50 27.87           C  
ATOM   1463  CG  GLU   175      52.683   7.643  91.927  0.50 29.24           C  
ATOM   1465  CD  GLU   175      53.737   6.539  92.115  0.50 29.46           C  
ATOM   1467  OE1 GLU   175      54.903   6.858  92.439  0.50 31.34           O  
ATOM   1469  OE2 GLU   175      53.390   5.345  91.963  0.50 31.65           O  
ATOM   1471  N   THR   176      51.735  11.264  91.798  1.00 26.86           N  
ATOM   1472  CA  THR   176      51.290  12.040  92.961  1.00 26.79           C  
ATOM   1473  C   THR   176      49.898  12.629  92.753  1.00 26.75           C  
ATOM   1474  O   THR   176      49.036  12.510  93.620  1.00 26.04           O  
ATOM   1475  CB  THR   176      52.302  13.134  93.336  1.00 27.14           C  
ATOM   1476  OG1 THR   176      53.559  12.502  93.631  1.00 27.24           O  
ATOM   1477  CG2 THR   176      51.835  13.934  94.563  1.00 27.58           C  
ATOM   1478  N   ILE   177      49.688  13.240  91.588  1.00 25.71           N  
ATOM   1479  CA  ILE   177      48.384  13.785  91.234  1.00 26.22           C  
ATOM   1480  C   ILE   177      47.297  12.715  91.081  1.00 26.28           C  
ATOM   1481  O   ILE   177      46.218  12.859  91.651  1.00 26.63           O  
ATOM   1482  CB  ILE   177      48.468  14.681  89.955  1.00 25.48           C  
ATOM   1483  CG1 ILE   177      49.376  15.896  90.198  1.00 26.11           C  
ATOM   1484  CG2 ILE   177      47.074  15.098  89.477  1.00 25.45           C  
ATOM   1485  CD1 ILE   177      48.966  16.846  91.337  1.00 28.06           C  
ATOM   1486  N   THR   178      47.571  11.657  90.322  1.00 26.77           N  
ATOM   1487  CA  THR   178      46.582  10.592  90.107  1.00 27.62           C  
ATOM   1488  C   THR   178      46.105  10.020  91.439  1.00 28.01           C  
ATOM   1489  O   THR   178      44.894   9.869  91.655  1.00 28.34           O  
ATOM   1490  CB  THR   178      47.147   9.474  89.227  1.00 27.45           C  
ATOM   1491  OG1 THR   178      47.575  10.049  87.986  1.00 30.23           O  
ATOM   1492  CG2 THR   178      46.079   8.407  88.914  1.00 27.81           C  
ATOM   1493  N   LYS   179      47.056   9.726  92.329  1.00 28.10           N  
ATOM   1494  CA  LYS   179      46.759   9.198  93.667  1.00 29.30           C  
ATOM   1495  C   LYS   179      45.974  10.180  94.568  1.00 28.48           C  
ATOM   1496  O   LYS   179      45.034   9.781  95.254  1.00 28.59           O  
ATOM   1497  CB  LYS   179      48.072   8.748  94.344  1.00 28.31           C  
ATOM   1498  CG  LYS   179      47.945   7.921  95.595  1.00 32.52           C  
ATOM   1499  CD  LYS   179      49.318   7.282  95.904  1.00 31.76           C  
ATOM   1500  CE  LYS   179      49.357   6.506  97.228  1.00 36.71           C  
ATOM   1501  NZ  LYS   179      49.425   7.439  98.395  1.00 38.33           N  
ATOM   1502  N   ALA   180      46.353  11.455  94.583  1.00 28.41           N  
ATOM   1503  CA  ALA   180      45.706  12.417  95.473  1.00 28.03           C  
ATOM   1504  C   ALA   180      44.362  12.985  94.987  1.00 28.23           C  
ATOM   1505  O   ALA   180      43.579  13.493  95.802  1.00 26.75           O  
ATOM   1506  CB  ALA   180      46.671  13.569  95.819  1.00 28.73           C  
ATOM   1507  N   PHE   181      44.113  12.930  93.674  1.00 26.80           N  
ATOM   1508  CA  PHE   181      42.932  13.566  93.073  1.00 27.02           C  
ATOM   1509  C   PHE   181      42.165  12.637  92.124  1.00 26.89           C  
ATOM   1510  O   PHE   181      42.346  12.698  90.901  1.00 26.67           O  
ATOM   1511  CB  PHE   181      43.319  14.889  92.392  1.00 26.12           C  
ATOM   1512  CG  PHE   181      44.028  15.842  93.320  1.00 26.60           C  
ATOM   1513  CD1 PHE   181      43.305  16.619  94.221  1.00 26.91           C  
ATOM   1514  CD2 PHE   181      45.420  15.936  93.316  1.00 25.88           C  
ATOM   1515  CE1 PHE   181      43.960  17.502  95.105  1.00 26.01           C  
ATOM   1516  CE2 PHE   181      46.088  16.797  94.207  1.00 25.21           C  
ATOM   1517  CZ  PHE   181      45.350  17.580  95.101  1.00 26.35           C  
ATOM   1518  N   PRO   182      41.304  11.768  92.694  1.00 27.28           N  
ATOM   1519  CA  PRO   182      40.486  10.821  91.907  1.00 27.25           C  
ATOM   1520  C   PRO   182      39.524  11.513  90.933  1.00 26.41           C  
ATOM   1521  O   PRO   182      39.017  10.869  90.015  1.00 26.37           O  
ATOM   1522  CB  PRO   182      39.663  10.081  92.976  1.00 27.29           C  
ATOM   1523  CG  PRO   182      40.351  10.330  94.259  1.00 28.28           C  
ATOM   1524  CD  PRO   182      41.066  11.627  94.147  1.00 27.15           C  
ATOM   1525  N   ALA   183      39.257  12.803  91.146  1.00 25.54           N  
ATOM   1526  CA  ALA   183      38.359  13.520  90.247  1.00 24.99           C  
ATOM   1527  C   ALA   183      39.032  13.960  88.926  1.00 24.58           C  
ATOM   1528  O   ALA   183      38.354  14.481  88.032  1.00 24.53           O  
ATOM   1529  CB  ALA   183      37.714  14.717  90.954  1.00 24.64           C  
ATOM   1530  N   VAL   184      40.346  13.761  88.790  1.00 23.86           N  
ATOM   1531  CA  VAL   184      41.061  14.225  87.572  1.00 24.22           C  
ATOM   1532  C   VAL   184      41.838  13.083  86.933  1.00 23.90           C  
ATOM   1533  O   VAL   184      42.099  12.075  87.597  1.00 23.81           O  
ATOM   1534  CB  VAL   184      42.043  15.429  87.828  1.00 23.77           C  
ATOM   1535  CG1 VAL   184      41.318  16.626  88.477  1.00 26.01           C  
ATOM   1536  CG2 VAL   184      43.250  14.998  88.672  1.00 25.45           C  
ATOM   1537  N   ASP   185      42.204  13.253  85.654  1.00 23.63           N  
ATOM   1538  CA  ASP   185      43.120  12.365  84.960  1.00 24.73           C  
ATOM   1539  C   ASP   185      44.332  13.188  84.558  1.00 25.11           C  
ATOM   1540  O   ASP   185      44.217  14.401  84.317  1.00 24.08           O  
ATOM   1541  CB  ASP   185      42.485  11.796  83.673  1.00 24.93           C  
ATOM   1542  CG  ASP   185      41.478  10.655  83.947  1.00 29.15           C  
ATOM   1543  OD1 ASP   185      41.589  10.008  85.017  1.00 30.21           O  
ATOM   1544  OD2 ASP   185      40.571  10.410  83.105  1.00 28.23           O  
ATOM   1545  N   VAL   186      45.473  12.516  84.429  1.00 24.79           N  
ATOM   1546  CA  VAL   186      46.681  13.160  83.920  1.00 24.16           C  
ATOM   1547  C   VAL   186      46.963  12.609  82.524  1.00 24.33           C  
ATOM   1548  O   VAL   186      47.102  11.390  82.331  1.00 23.98           O  
ATOM   1549  CB  VAL   186      47.891  12.878  84.829  1.00 25.31           C  
ATOM   1550  CG1 VAL   186      49.156  13.472  84.224  1.00 25.57           C  
ATOM   1551  CG2 VAL   186      47.626  13.405  86.267  1.00 24.03           C  
ATOM   1552  N   ILE   187      47.088  13.510  81.564  1.00 23.30           N  
ATOM   1553  CA  ILE   187      47.397  13.144  80.183  1.00 23.86           C  
ATOM   1554  C   ILE   187      48.818  13.565  79.811  1.00 23.45           C  
ATOM   1555  O   ILE   187      49.156  14.734  79.908  1.00 22.45           O  
ATOM   1556  CB  ILE   187      46.362  13.718  79.202  1.00 23.85           C  
ATOM   1557  CG1 ILE   187      44.980  13.099  79.512  1.00 26.53           C  
ATOM   1558  CG2 ILE   187      46.795  13.383  77.735  1.00 25.15           C  
ATOM   1559  CD1 ILE   187      43.812  13.706  78.758  1.00 28.72           C  
ATOM   1560  N   ARG   188      49.652  12.602  79.416  1.00 22.73           N  
ATOM   1561  CA  ARG   188      50.999  12.938  78.990  1.00 23.62           C  
ATOM   1562  C   ARG   188      50.960  13.434  77.527  1.00 23.19           C  
ATOM   1563  O   ARG   188      50.550  12.714  76.631  1.00 23.50           O  
ATOM   1564  CB  ARG   188      51.935  11.739  79.166  1.00 24.18           C  
ATOM   1565  CG  ARG   188      53.358  12.066  78.854  1.00 29.11           C  
ATOM   1566  CD  ARG   188      54.182  10.781  78.804  1.00 36.71           C  
ATOM   1567  NE  ARG   188      55.594  11.107  78.671  1.00 41.91           N  
ATOM   1568  CZ  ARG   188      56.399  10.631  77.732  1.00 46.11           C  
ATOM   1569  NH1 ARG   188      55.964   9.748  76.826  1.00 48.26           N  
ATOM   1570  NH2 ARG   188      57.670  11.012  77.731  1.00 47.42           N  
ATOM   1571  N   VAL   189      51.380  14.676  77.296  1.00 22.79           N  
ATOM   1572  CA  VAL   189      51.366  15.243  75.939  1.00 22.54           C  
ATOM   1573  C   VAL   189      52.673  14.936  75.255  1.00 22.95           C  
ATOM   1574  O   VAL   189      52.687  14.427  74.133  1.00 23.11           O  
ATOM   1575  CB  VAL   189      51.084  16.775  75.951  1.00 21.83           C  
ATOM   1576  CG1 VAL   189      51.130  17.328  74.544  1.00 24.12           C  
ATOM   1577  CG2 VAL   189      49.723  17.084  76.638  1.00 22.40           C  
ATOM   1578  N   ASN   190      53.782  15.206  75.947  1.00 23.34           N  
ATOM   1579  CA  ASN   190      55.124  14.939  75.427  1.00 23.37           C  
ATOM   1580  C   ASN   190      56.065  14.813  76.613  1.00 24.01           C  
ATOM   1581  O   ASN   190      55.602  14.805  77.748  1.00 24.05           O  
ATOM   1582  CB  ASN   190      55.562  16.020  74.427  1.00 23.41           C  
ATOM   1583  CG  ASN   190      55.572  17.438  75.040  1.00 23.59           C  
ATOM   1584  OD1 ASN   190      56.091  17.629  76.121  1.00 23.01           O  
ATOM   1585  ND2 ASN   190      55.007  18.420  74.335  1.00 23.21           N  
ATOM   1586  N   ASP   191      57.373  14.735  76.367  1.00 24.18           N  
ATOM   1587  CA  ASP   191      58.333  14.466  77.451  1.00 25.89           C  
ATOM   1588  C   ASP   191      58.420  15.569  78.507  1.00 25.25           C  
ATOM   1589  O   ASP   191      58.990  15.354  79.577  1.00 24.90           O  
ATOM   1590  CB  ASP   191      59.735  14.205  76.873  1.00 26.80           C  
ATOM   1591  CG  ASP   191      59.851  12.841  76.208  1.00 30.70           C  
ATOM   1592  OD1 ASP   191      58.883  12.044  76.297  1.00 35.89           O  
ATOM   1593  OD2 ASP   191      60.898  12.564  75.580  1.00 33.80           O  
ATOM   1594  N   GLU   192      57.895  16.749  78.185  1.00 24.14           N  
ATOM   1595  CA  GLU   192      57.988  17.905  79.073  1.00 25.47           C  
ATOM   1596  C   GLU   192      56.658  18.541  79.432  1.00 24.52           C  
ATOM   1597  O   GLU   192      56.637  19.507  80.170  1.00 25.59           O  
ATOM   1598  CB  GLU   192      58.917  18.950  78.460  1.00 26.31           C  
ATOM   1599  CG  GLU   192      60.369  18.442  78.432  1.00 30.67           C  
ATOM   1600  CD  GLU   192      61.278  19.187  77.468  1.00 37.45           C  
ATOM   1601  OE1 GLU   192      60.932  20.300  77.012  1.00 39.13           O  
ATOM   1602  OE2 GLU   192      62.358  18.640  77.164  1.00 40.53           O  
ATOM   1603  N   LYS   193      55.557  18.003  78.926  1.00 22.75           N  
ATOM   1604  CA  LYS   193      54.232  18.578  79.189  1.00 22.40           C  
ATOM   1605  C   LYS   193      53.193  17.535  79.579  1.00 22.60           C  
ATOM   1606  O   LYS   193      53.074  16.511  78.890  1.00 22.61           O  
ATOM   1607  CB  LYS   193      53.727  19.351  77.963  1.00 21.34           C  
ATOM   1608  CG  LYS   193      52.448  20.175  78.282  1.00 23.45           C  
ATOM   1609  CD  LYS   193      51.908  20.848  77.041  1.00 27.98           C  
ATOM   1610  CE  LYS   193      50.708  21.741  77.436  1.00 32.37           C  
ATOM   1611  NZ  LYS   193      50.217  22.474  76.221  1.00 37.14           N  
ATOM   1612  N   LEU   194      52.478  17.808  80.677  1.00 23.12           N  
ATOM   1613  CA  LEU   194      51.277  17.062  81.118  1.00 23.93           C  
ATOM   1614  C   LEU   194      50.053  17.994  81.145  1.00 23.51           C  
ATOM   1615  O   LEU   194      50.155  19.187  81.476  1.00 25.01           O  
ATOM   1616  CB  LEU   194      51.435  16.505  82.562  1.00 24.36           C  
ATOM   1617  CG  LEU   194      52.599  15.609  82.915  1.00 26.27           C  
ATOM   1618  CD1 LEU   194      52.728  15.487  84.438  1.00 26.26           C  
ATOM   1619  CD2 LEU   194      52.383  14.244  82.252  1.00 29.88           C  
ATOM   1620  N   ASN   195      48.897  17.436  80.825  1.00 22.85           N  
ATOM   1621  CA  ASN   195      47.627  18.098  81.067  1.00 23.97           C  
ATOM   1622  C   ASN   195      46.917  17.373  82.192  1.00 23.50           C  
ATOM   1623  O   ASN   195      46.808  16.141  82.175  1.00 25.44           O  
ATOM   1624  CB  ASN   195      46.741  18.018  79.828  1.00 24.15           C  
ATOM   1625  CG  ASN   195      47.229  18.904  78.700  1.00 26.20           C  
ATOM   1626  OD1 ASN   195      47.997  19.823  78.923  1.00 27.66           O  
ATOM   1627  ND2 ASN   195      46.767  18.629  77.484  1.00 28.00           N  
ATOM   1628  N   ILE   196      46.410  18.127  83.152  1.00 22.67           N  
ATOM   1629  CA  ILE   196      45.526  17.574  84.157  1.00 22.84           C  
ATOM   1630  C   ILE   196      44.096  18.024  83.788  1.00 23.07           C  
ATOM   1631  O   ILE   196      43.841  19.242  83.650  1.00 23.10           O  
ATOM   1632  CB  ILE   196      45.883  18.079  85.550  1.00 22.56           C  
ATOM   1633  CG1 ILE   196      47.321  17.667  85.909  1.00 24.46           C  
ATOM   1634  CG2 ILE   196      44.854  17.574  86.572  1.00 24.19           C  
ATOM   1635  CD1 ILE   196      47.926  18.445  87.081  1.00 25.55           C  
ATOM   1636  N   VAL   197      43.189  17.055  83.641  1.00 22.22           N  
ATOM   1637  CA  VAL   197      41.827  17.312  83.118  1.00 21.63           C  
ATOM   1638  C   VAL   197      40.788  16.621  84.018  1.00 22.47           C  
ATOM   1639  O   VAL   197      41.141  15.737  84.810  1.00 22.16           O  
ATOM   1640  CB  VAL   197      41.641  16.791  81.641  1.00 20.72           C  
ATOM   1641  CG1 VAL   197      42.502  17.560  80.644  1.00 24.23           C  
ATOM   1642  CG2 VAL   197      41.948  15.267  81.541  1.00 19.32           C  
ATOM   1643  N   PRO   198      39.500  17.022  83.908  1.00 22.65           N  
ATOM   1644  CA  PRO   198      38.511  16.247  84.681  1.00 22.51           C  
ATOM   1645  C   PRO   198      38.528  14.774  84.265  1.00 22.53           C  
ATOM   1646  O   PRO   198      38.845  14.434  83.115  1.00 23.02           O  
ATOM   1647  CB  PRO   198      37.169  16.883  84.300  1.00 21.85           C  
ATOM   1648  CG  PRO   198      37.530  18.317  83.841  1.00 23.58           C  
ATOM   1649  CD  PRO   198      38.897  18.153  83.151  1.00 21.60           C  
ATOM   1650  N   LYS   199      38.157  13.897  85.186  1.00 22.88           N  
ATOM   1651  CA  LYS   199      38.168  12.474  84.881  1.00 22.86           C  
ATOM   1652  C   LYS   199      37.294  12.167  83.678  1.00 23.13           C  
ATOM   1653  O   LYS   199      36.173  12.663  83.556  1.00 23.11           O  
ATOM   1654  CB  LYS   199      37.757  11.642  86.114  1.00 23.14           C  
ATOM   1655  CG  LYS   199      37.963  10.141  85.884  1.00 26.25           C  
ATOM   1656  CD  LYS   199      38.082   9.393  87.188  1.00 31.96           C  
ATOM   1657  CE  LYS   199      38.436   7.907  86.975  1.00 36.76           C  
ATOM   1658  NZ  LYS   199      39.836   7.763  86.397  1.00 39.94           N  
ATOM   1659  N   GLY   200      37.830  11.360  82.770  1.00 23.34           N  
ATOM   1660  CA  GLY   200      37.103  10.945  81.573  1.00 24.15           C  
ATOM   1661  C   GLY   200      37.262  11.895  80.392  1.00 23.87           C  
ATOM   1662  O   GLY   200      36.852  11.566  79.278  1.00 24.98           O  
ATOM   1663  N   VAL   201      37.880  13.061  80.607  1.00 23.17           N  
ATOM   1664  CA  VAL   201      38.086  14.017  79.515  1.00 23.28           C  
ATOM   1665  C   VAL   201      39.338  13.660  78.712  1.00 23.78           C  
ATOM   1666  O   VAL   201      40.379  13.293  79.280  1.00 23.42           O  
ATOM   1667  CB  VAL   201      38.199  15.469  80.058  1.00 22.66           C  
ATOM   1668  CG1 VAL   201      38.784  16.473  79.002  1.00 23.26           C  
ATOM   1669  CG2 VAL   201      36.823  15.925  80.614  1.00 22.85           C  
ATOM   1670  N   SER   202      39.229  13.755  77.396  1.00 23.76           N  
ATOM   1671  CA  SER   202      40.381  13.594  76.515  1.00 23.73           C  
ATOM   1672  C   SER   202      40.013  14.008  75.100  1.00 23.53           C  
ATOM   1673  O   SER   202      38.820  14.117  74.756  1.00 23.55           O  
ATOM   1674  CB  SER   202      40.877  12.133  76.511  1.00 23.24           C  
ATOM   1675  OG  SER   202      39.953  11.270  75.866  1.00 25.09           O  
ATOM   1676  N   LYS   203      41.041  14.174  74.266  1.00 23.78           N  
ATOM   1677  CA  LYS   203      40.816  14.429  72.835  1.00 24.42           C  
ATOM   1678  C   LYS   203      39.967  13.338  72.193  1.00 24.78           C  
ATOM   1679  O   LYS   203      39.042  13.648  71.456  1.00 25.33           O  
ATOM   1680  CB  LYS   203      42.133  14.566  72.085  1.00 24.43           C  
ATOM   1681  CG  LYS   203      42.904  15.830  72.372  1.00 24.22           C  
ATOM   1682  CD  LYS   203      44.319  15.747  71.699  1.00 24.40           C  
ATOM   1683  CE  LYS   203      44.861  17.178  71.476  1.00 25.18           C  
ATOM   1684  NZ  LYS   203      46.372  17.189  71.101  1.00 27.07           N  
ATOM   1685  N   GLU   204      40.273  12.070  72.476  1.00 24.74           N  
ATOM   1686  CA  GLU   204      39.565  10.962  71.860  1.00 25.22           C  
ATOM   1687  C   GLU   204      38.110  10.856  72.355  1.00 25.34           C  
ATOM   1688  O   GLU   204      37.205  10.479  71.600  1.00 25.63           O  
ATOM   1689  CB  GLU   204      40.316   9.638  72.067  1.00 25.18           C  
ATOM   1690  CG  GLU   204      40.476   9.140  73.525  1.00 26.39           C  
ATOM   1691  CD  GLU   204      41.728   9.648  74.230  1.00 28.45           C  
ATOM   1692  OE1 GLU   204      42.320  10.686  73.810  1.00 27.42           O  
ATOM   1693  OE2 GLU   204      42.103   8.993  75.240  1.00 27.94           O  
ATOM   1694  N   ALA   205      37.896  11.155  73.633  1.00 25.21           N  
ATOM   1695  CA  ALA   205      36.551  11.140  74.178  1.00 25.48           C  
ATOM   1696  C   ALA   205      35.704  12.277  73.560  1.00 25.74           C  
ATOM   1697  O   ALA   205      34.506  12.085  73.256  1.00 24.87           O  
ATOM   1698  CB  ALA   205      36.602  11.262  75.696  1.00 26.78           C  
ATOM   1699  N   GLY   206      36.331  13.442  73.376  1.00 26.29           N  
ATOM   1700  CA  GLY   206      35.640  14.624  72.822  1.00 26.95           C  
ATOM   1701  C   GLY   206      35.268  14.331  71.360  1.00 27.05           C  
ATOM   1702  O   GLY   206      34.129  14.554  70.931  1.00 26.85           O  
ATOM   1703  N   LEU   207      36.233  13.798  70.615  1.00 27.18           N  
ATOM   1704  CA  LEU   207      36.010  13.370  69.240  1.00 28.57           C  
ATOM   1705  C   LEU   207      34.881  12.342  69.137  1.00 28.45           C  
ATOM   1706  O   LEU   207      34.008  12.481  68.286  1.00 29.73           O  
ATOM   1707  CB  LEU   207      37.306  12.843  68.603  1.00 28.40           C  
ATOM   1708  CG  LEU   207      37.299  12.573  67.080  1.00 30.73           C  
ATOM   1709  CD1 LEU   207      36.715  13.757  66.324  1.00 31.91           C  
ATOM   1710  CD2 LEU   207      38.732  12.337  66.627  1.00 29.73           C  
ATOM   1711  N   ALA   208      34.869  11.336  70.019  1.00 28.38           N  
ATOM   1712  CA  ALA   208      33.753  10.374  70.037  1.00 28.76           C  
ATOM   1713  C   ALA   208      32.393  11.036  70.262  1.00 28.80           C  
ATOM   1714  O   ALA   208      31.392  10.637  69.640  1.00 29.85           O  
ATOM   1715  CB  ALA   208      33.989   9.278  71.060  1.00 28.97           C  
ATOM   1716  N   LEU   209      32.341  12.038  71.147  1.00 28.07           N  
ATOM   1717  CA  LEU   209      31.084  12.727  71.442  0.50 27.57           C  
ATOM   1719  C   LEU   209      30.596  13.496  70.215  1.00 27.61           C  
ATOM   1720  O   LEU   209      29.392  13.520  69.912  1.00 26.72           O  
ATOM   1721  CB  LEU   209      31.220  13.676  72.640  0.50 27.41           C  
ATOM   1723  CG  LEU   209      31.416  13.169  74.076  0.50 27.68           C  
ATOM   1725  CD1 LEU   209      31.349  14.332  75.046  0.50 28.55           C  
ATOM   1727  CD2 LEU   209      30.382  12.113  74.470  0.50 28.32           C  
ATOM   1729  N   VAL   210      31.526  14.126  69.503  1.00 27.12           N  
ATOM   1730  CA  VAL   210      31.157  14.895  68.322  1.00 28.29           C  
ATOM   1731  C   VAL   210      30.689  13.954  67.202  1.00 28.23           C  
ATOM   1732  O   VAL   210      29.676  14.225  66.551  1.00 28.96           O  
ATOM   1733  CB  VAL   210      32.301  15.829  67.883  1.00 28.91           C  
ATOM   1734  CG1 VAL   210      32.044  16.463  66.500  1.00 30.73           C  
ATOM   1735  CG2 VAL   210      32.503  16.935  68.926  1.00 28.46           C  
ATOM   1736  N   ALA   211      31.405  12.855  67.008  1.00 27.53           N  
ATOM   1737  CA  ALA   211      31.037  11.889  65.955  1.00 29.77           C  
ATOM   1738  C   ALA   211      29.634  11.330  66.251  1.00 30.23           C  
ATOM   1739  O   ALA   211      28.777  11.275  65.357  1.00 31.50           O  
ATOM   1740  CB  ALA   211      32.052  10.785  65.874  1.00 28.32           C  
ATOM   1741  N   SER   212      29.389  10.948  67.507  1.00 31.44           N  
ATOM   1742  CA  SER   212      28.087  10.426  67.907  0.50 31.31           C  
ATOM   1744  C   SER   212      26.966  11.446  67.658  1.00 31.67           C  
ATOM   1745  O   SER   212      25.882  11.085  67.178  1.00 30.94           O  
ATOM   1746  CB  SER   212      28.103   9.983  69.378  0.50 31.80           C  
ATOM   1748  OG  SER   212      28.942   8.849  69.550  0.50 31.57           O  
ATOM   1750  N   GLU   213      27.228  12.714  67.983  1.00 31.98           N  
ATOM   1751  CA  GLU   213      26.271  13.804  67.745  1.00 32.98           C  
ATOM   1752  C   GLU   213      25.899  13.918  66.260  1.00 32.21           C  
ATOM   1753  O   GLU   213      24.760  14.240  65.919  1.00 31.44           O  
ATOM   1754  CB  GLU   213      26.815  15.143  68.288  1.00 33.71           C  
ATOM   1755  CG  GLU   213      25.921  16.357  68.005  1.00 36.91           C  
ATOM   1756  CD  GLU   213      24.602  16.358  68.767  1.00 41.90           C  
ATOM   1757  OE1 GLU   213      24.389  15.516  69.668  1.00 42.24           O  
ATOM   1758  OE2 GLU   213      23.759  17.233  68.466  1.00 44.94           O  
ATOM   1759  N   LEU   214      26.860  13.628  65.400  1.00 31.56           N  
ATOM   1760  CA  LEU   214      26.669  13.655  63.955  1.00 31.83           C  
ATOM   1761  C   LEU   214      26.129  12.349  63.367  1.00 31.36           C  
ATOM   1762  O   LEU   214      25.994  12.242  62.154  1.00 32.00           O  
ATOM   1763  CB  LEU   214      27.986  14.012  63.262  1.00 31.66           C  
ATOM   1764  CG  LEU   214      28.554  15.405  63.558  1.00 32.94           C  
ATOM   1765  CD1 LEU   214      29.941  15.500  62.964  1.00 32.27           C  
ATOM   1766  CD2 LEU   214      27.652  16.491  63.025  1.00 34.12           C  
ATOM   1767  N   GLY   215      25.837  11.363  64.211  1.00 30.66           N  
ATOM   1768  CA  GLY   215      25.340  10.066  63.730  1.00 31.52           C  
ATOM   1769  C   GLY   215      26.423   9.187  63.115  1.00 31.35           C  
ATOM   1770  O   GLY   215      26.134   8.258  62.348  1.00 30.33           O  
ATOM   1771  N   LEU   216      27.679   9.481  63.445  1.00 31.95           N  
ATOM   1772  CA  LEU   216      28.823   8.740  62.909  1.00 33.17           C  
ATOM   1773  C   LEU   216      29.469   7.892  63.993  1.00 34.61           C  
ATOM   1774  O   LEU   216      29.202   8.097  65.174  1.00 35.18           O  
ATOM   1775  CB  LEU   216      29.856   9.699  62.314  1.00 33.09           C  
ATOM   1776  CG  LEU   216      29.341  10.716  61.286  1.00 34.24           C  
ATOM   1777  CD1 LEU   216      30.383  11.781  61.015  1.00 35.51           C  
ATOM   1778  CD2 LEU   216      28.954  10.016  60.009  1.00 34.74           C  
ATOM   1779  N   SER   217      30.255   6.891  63.595  1.00 36.05           N  
ATOM   1780  CA  SER   217      31.118   6.198  64.550  1.00 37.27           C  
ATOM   1781  C   SER   217      32.572   6.603  64.317  1.00 37.16           C  
ATOM   1782  O   SER   217      32.890   7.227  63.295  1.00 37.08           O  
ATOM   1783  CB  SER   217      30.977   4.680  64.452  1.00 37.36           C  
ATOM   1784  OG  SER   217      31.434   4.162  63.207  1.00 39.38           O  
ATOM   1785  N   MET   218      33.450   6.241  65.252  1.00 36.89           N  
ATOM   1786  CA  MET   218      34.900   6.434  65.054  1.00 36.52           C  
ATOM   1787  C   MET   218      35.416   5.826  63.729  1.00 35.52           C  
ATOM   1788  O   MET   218      36.384   6.340  63.146  1.00 35.11           O  
ATOM   1789  CB  MET   218      35.699   5.948  66.279  1.00 36.94           C  
ATOM   1790  CG  MET   218      35.501   6.844  67.527  1.00 39.01           C  
ATOM   1791  SD  MET   218      35.943   8.725  67.266  0.50 41.58          SE  
ATOM   1792  CE  MET   218      37.884   8.654  67.325  1.00 41.87           C  
ATOM   1793  N   ASP   219      34.756   4.762  63.257  0.50 34.83           N  
ATOM   1795  CA  ASP   219      35.063   4.146  61.957  0.50 34.53           C  
ATOM   1797  C   ASP   219      35.023   5.116  60.772  0.50 34.07           C  
ATOM   1799  O   ASP   219      35.703   4.899  59.758  0.50 33.98           O  
ATOM   1801  CB  ASP   219      34.117   2.970  61.664  0.50 34.79           C  
ATOM   1803  CG  ASP   219      34.244   1.834  62.673  0.50 35.41           C  
ATOM   1805  OD1 ASP   219      35.291   1.713  63.352  0.50 35.59           O  
ATOM   1807  OD2 ASP   219      33.285   1.045  62.775  0.50 38.09           O  
ATOM   1809  N   ASP   220      34.222   6.167  60.910  1.00 33.45           N  
ATOM   1810  CA  ASP   220      33.965   7.135  59.846  1.00 33.21           C  
ATOM   1811  C   ASP   220      34.915   8.335  59.921  1.00 31.68           C  
ATOM   1812  O   ASP   220      34.766   9.296  59.152  1.00 31.82           O  
ATOM   1813  CB  ASP   220      32.513   7.654  59.956  1.00 33.38           C  
ATOM   1814  CG  ASP   220      31.467   6.539  59.830  1.00 36.94           C  
ATOM   1815  OD1 ASP   220      31.547   5.724  58.870  1.00 35.69           O  
ATOM   1816  OD2 ASP   220      30.552   6.495  60.694  1.00 39.56           O  
ATOM   1817  N   VAL   221      35.863   8.279  60.857  1.00 29.72           N  
ATOM   1818  CA  VAL   221      36.720   9.418  61.186  1.00 29.05           C  
ATOM   1819  C   VAL   221      38.148   9.248  60.657  1.00 28.17           C  
ATOM   1820  O   VAL   221      38.740   8.159  60.765  1.00 28.41           O  
ATOM   1821  CB  VAL   221      36.790   9.635  62.712  1.00 28.79           C  
ATOM   1822  CG1 VAL   221      37.689  10.800  63.041  1.00 30.06           C  
ATOM   1823  CG2 VAL   221      35.380   9.848  63.307  1.00 31.31           C  
ATOM   1824  N   VAL   222      38.672  10.319  60.057  1.00 27.83           N  
ATOM   1825  CA  VAL   222      40.110  10.473  59.815  1.00 28.23           C  
ATOM   1826  C   VAL   222      40.653  11.421  60.884  1.00 27.20           C  
ATOM   1827  O   VAL   222      40.133  12.543  61.058  1.00 27.97           O  
ATOM   1828  CB  VAL   222      40.425  11.042  58.399  1.00 28.20           C  
ATOM   1829  CG1 VAL   222      41.961  11.195  58.185  1.00 29.34           C  
ATOM   1830  CG2 VAL   222      39.803  10.172  57.328  1.00 30.60           C  
ATOM   1831  N   ALA   223      41.658  10.972  61.643  1.00 26.30           N  
ATOM   1832  CA  ALA   223      42.220  11.821  62.692  1.00 25.77           C  
ATOM   1833  C   ALA   223      43.707  12.042  62.431  1.00 26.13           C  
ATOM   1834  O   ALA   223      44.431  11.092  62.163  1.00 25.66           O  
ATOM   1835  CB  ALA   223      41.999  11.215  64.064  1.00 26.54           C  
ATOM   1836  N   ILE   224      44.157  13.296  62.469  1.00 24.89           N  
ATOM   1837  CA  ILE   224      45.565  13.598  62.158  1.00 24.93           C  
ATOM   1838  C   ILE   224      46.203  14.224  63.398  1.00 24.71           C  
ATOM   1839  O   ILE   224      45.780  15.324  63.837  1.00 24.37           O  
ATOM   1840  CB  ILE   224      45.690  14.545  60.947  1.00 24.68           C  
ATOM   1841  CG1 ILE   224      44.926  13.981  59.740  1.00 25.85           C  
ATOM   1842  CG2 ILE   224      47.177  14.741  60.567  1.00 25.43           C  
ATOM   1843  CD1 ILE   224      45.102  14.817  58.464  1.00 26.42           C  
ATOM   1844  N   GLY   225      47.193  13.531  63.976  1.00 24.29           N  
ATOM   1845  CA  GLY   225      47.828  13.965  65.243  1.00 24.00           C  
ATOM   1846  C   GLY   225      49.365  13.959  65.143  1.00 23.46           C  
ATOM   1847  O   GLY   225      49.934  13.514  64.134  1.00 23.07           O  
ATOM   1848  N   HIS   226      50.044  14.381  66.201  1.00 22.78           N  
ATOM   1849  CA  HIS   226      51.527  14.471  66.158  1.00 23.19           C  
ATOM   1850  C   HIS   226      52.239  14.197  67.489  1.00 23.03           C  
ATOM   1851  O   HIS   226      53.450  14.048  67.496  1.00 22.15           O  
ATOM   1852  CB  HIS   226      51.993  15.824  65.559  1.00 23.23           C  
ATOM   1853  CG  HIS   226      51.933  16.971  66.526  1.00 23.91           C  
ATOM   1854  ND1 HIS   226      50.743  17.456  67.032  1.00 25.13           N  
ATOM   1855  CD2 HIS   226      52.914  17.748  67.046  1.00 25.12           C  
ATOM   1856  CE1 HIS   226      50.996  18.472  67.844  1.00 25.61           C  
ATOM   1857  NE2 HIS   226      52.305  18.675  67.864  1.00 23.93           N  
ATOM   1858  N   GLN   227      51.500  14.155  68.608  1.00 22.83           N  
ATOM   1859  CA  GLN   227      52.134  13.879  69.923  1.00 23.45           C  
ATOM   1860  C   GLN   227      51.501  12.700  70.685  1.00 22.59           C  
ATOM   1861  O   GLN   227      50.537  12.093  70.215  1.00 22.33           O  
ATOM   1862  CB  GLN   227      52.113  15.133  70.801  1.00 22.88           C  
ATOM   1863  CG  GLN   227      52.760  16.301  70.143  1.00 25.56           C  
ATOM   1864  CD  GLN   227      52.962  17.441  71.109  1.00 28.03           C  
ATOM   1865  OE1 GLN   227      52.022  18.141  71.458  1.00 29.31           O  
ATOM   1866  NE2 GLN   227      54.190  17.623  71.539  1.00 25.63           N  
ATOM   1867  N   TYR   228      52.045  12.386  71.858  1.00 22.47           N  
ATOM   1868  CA  TYR   228      51.575  11.199  72.618  1.00 22.82           C  
ATOM   1869  C   TYR   228      50.096  11.257  72.947  1.00 23.18           C  
ATOM   1870  O   TYR   228      49.387  10.227  72.910  1.00 23.61           O  
ATOM   1871  CB  TYR   228      52.399  10.986  73.899  1.00 23.04           C  
ATOM   1872  CG  TYR   228      53.850  10.655  73.611  1.00 24.87           C  
ATOM   1873  CD1 TYR   228      54.202   9.458  72.991  1.00 28.27           C  
ATOM   1874  CD2 TYR   228      54.865  11.517  73.980  1.00 28.89           C  
ATOM   1875  CE1 TYR   228      55.549   9.121  72.725  1.00 28.17           C  
ATOM   1876  CE2 TYR   228      56.233  11.195  73.722  1.00 28.28           C  
ATOM   1877  CZ  TYR   228      56.546   9.999  73.091  1.00 28.51           C  
ATOM   1878  OH  TYR   228      57.875   9.681  72.846  1.00 27.14           O  
ATOM   1879  N   ASP   229      49.609  12.460  73.215  1.00 22.58           N  
ATOM   1880  CA  ASP   229      48.221  12.594  73.618  1.00 23.33           C  
ATOM   1881  C   ASP   229      47.262  12.372  72.454  1.00 23.38           C  
ATOM   1882  O   ASP   229      46.058  12.244  72.666  1.00 24.04           O  
ATOM   1883  CB  ASP   229      47.959  13.940  74.312  1.00 23.91           C  
ATOM   1884  CG  ASP   229      48.228  15.132  73.408  1.00 24.90           C  
ATOM   1885  OD1 ASP   229      49.172  15.064  72.593  1.00 27.32           O  
ATOM   1886  OD2 ASP   229      47.499  16.154  73.523  1.00 27.38           O  
ATOM   1887  N   ASP   230      47.799  12.378  71.231  1.00 23.48           N  
ATOM   1888  CA  ASP   230      47.022  12.092  70.011  1.00 24.70           C  
ATOM   1889  C   ASP   230      46.957  10.601  69.704  1.00 25.26           C  
ATOM   1890  O   ASP   230      46.155  10.143  68.863  1.00 25.79           O  
ATOM   1891  CB  ASP   230      47.652  12.817  68.831  1.00 23.62           C  
ATOM   1892  CG  ASP   230      47.716  14.333  69.056  1.00 25.09           C  
ATOM   1893  OD1 ASP   230      46.675  14.930  69.417  1.00 25.87           O  
ATOM   1894  OD2 ASP   230      48.804  14.916  68.925  1.00 25.09           O  
ATOM   1895  N   LEU   231      47.773   9.810  70.387  1.00 26.29           N  
ATOM   1896  CA  LEU   231      47.804   8.372  70.052  1.00 26.35           C  
ATOM   1897  C   LEU   231      46.455   7.652  70.147  1.00 27.21           C  
ATOM   1898  O   LEU   231      46.104   6.861  69.251  1.00 27.17           O  
ATOM   1899  CB  LEU   231      48.858   7.647  70.892  1.00 27.34           C  
ATOM   1900  CG  LEU   231      50.265   7.741  70.328  1.00 29.56           C  
ATOM   1901  CD1 LEU   231      51.271   7.174  71.343  1.00 30.37           C  
ATOM   1902  CD2 LEU   231      50.346   6.987  68.964  1.00 30.69           C  
ATOM   1903  N   PRO   232      45.690   7.874  71.236  1.00 27.17           N  
ATOM   1904  CA  PRO   232      44.395   7.182  71.317  1.00 27.16           C  
ATOM   1905  C   PRO   232      43.461   7.491  70.154  1.00 27.46           C  
ATOM   1906  O   PRO   232      42.847   6.575  69.619  1.00 27.80           O  
ATOM   1907  CB  PRO   232      43.804   7.699  72.642  1.00 27.75           C  
ATOM   1908  CG  PRO   232      45.047   8.054  73.455  1.00 27.55           C  
ATOM   1909  CD  PRO   232      45.981   8.650  72.458  1.00 26.76           C  
ATOM   1910  N   MET   233      43.371   8.751  69.722  1.00 27.42           N  
ATOM   1911  CA  MET   233      42.440   9.030  68.639  1.00 28.57           C  
ATOM   1912  C   MET   233      42.994   8.478  67.317  1.00 28.53           C  
ATOM   1913  O   MET   233      42.218   8.092  66.450  1.00 29.36           O  
ATOM   1914  CB  MET   233      42.101  10.519  68.529  1.00 29.13           C  
ATOM   1915  CG  MET   233      43.183  11.353  67.938  1.00 27.81           C  
ATOM   1916  SD  MET   233      42.680  13.240  67.696  0.50 30.15          SE  
ATOM   1917  CE  MET   233      44.251  13.669  66.592  1.00 32.01           C  
ATOM   1918  N   ILE   234      44.318   8.447  67.176  1.00 27.31           N  
ATOM   1919  CA  ILE   234      44.958   7.823  66.013  1.00 28.21           C  
ATOM   1920  C   ILE   234      44.637   6.325  65.959  1.00 28.21           C  
ATOM   1921  O   ILE   234      44.330   5.807  64.873  1.00 29.17           O  
ATOM   1922  CB  ILE   234      46.508   8.081  65.966  1.00 26.73           C  
ATOM   1923  CG1 ILE   234      46.783   9.530  65.567  1.00 28.11           C  
ATOM   1924  CG2 ILE   234      47.215   7.093  64.970  1.00 28.48           C  
ATOM   1925  CD1 ILE   234      48.201  10.011  65.865  1.00 28.72           C  
ATOM   1926  N   GLU   235      44.686   5.643  67.111  1.00 28.54           N  
ATOM   1927  CA  GLU   235      44.384   4.220  67.177  0.50 29.19           C  
ATOM   1929  C   GLU   235      42.883   3.938  66.985  1.00 29.62           C  
ATOM   1930  O   GLU   235      42.500   2.945  66.343  1.00 28.04           O  
ATOM   1931  CB  GLU   235      44.873   3.645  68.509  0.50 29.29           C  
ATOM   1933  CG  GLU   235      46.276   3.029  68.460  0.50 30.56           C  
ATOM   1935  CD  GLU   235      47.359   3.906  69.051  0.50 31.08           C  
ATOM   1937  OE1 GLU   235      47.777   3.650  70.211  0.50 30.84           O  
ATOM   1939  OE2 GLU   235      47.796   4.847  68.359  0.50 28.87           O  
ATOM   1941  N   LEU   236      42.044   4.813  67.537  1.00 28.58           N  
ATOM   1942  CA  LEU   236      40.593   4.605  67.535  1.00 29.29           C  
ATOM   1943  C   LEU   236      39.868   5.059  66.250  1.00 29.42           C  
ATOM   1944  O   LEU   236      38.822   4.498  65.889  1.00 28.58           O  
ATOM   1945  CB  LEU   236      39.966   5.252  68.792  1.00 30.15           C  
ATOM   1946  CG  LEU   236      40.315   4.638  70.158  1.00 31.75           C  
ATOM   1947  CD1 LEU   236      40.036   5.637  71.300  1.00 36.79           C  
ATOM   1948  CD2 LEU   236      39.595   3.318  70.423  1.00 37.77           C  
ATOM   1949  N   ALA   237      40.418   6.062  65.554  1.00 29.65           N  
ATOM   1950  CA  ALA   237      39.818   6.548  64.293  1.00 29.89           C  
ATOM   1951  C   ALA   237      39.876   5.488  63.196  1.00 29.89           C  
ATOM   1952  O   ALA   237      40.800   4.661  63.183  1.00 30.68           O  
ATOM   1953  CB  ALA   237      40.540   7.804  63.821  1.00 29.61           C  
ATOM   1954  N   GLY   238      38.918   5.519  62.265  1.00 28.95           N  
ATOM   1955  CA  GLY   238      38.940   4.646  61.085  1.00 29.07           C  
ATOM   1956  C   GLY   238      40.256   4.754  60.333  1.00 28.70           C  
ATOM   1957  O   GLY   238      40.816   3.742  59.864  1.00 28.91           O  
ATOM   1958  N   LEU   239      40.755   5.980  60.205  1.00 27.16           N  
ATOM   1959  CA  LEU   239      42.070   6.225  59.612  1.00 27.11           C  
ATOM   1960  C   LEU   239      42.861   7.191  60.525  1.00 26.00           C  
ATOM   1961  O   LEU   239      42.470   8.349  60.699  1.00 25.76           O  
ATOM   1962  CB  LEU   239      41.906   6.807  58.212  1.00 26.94           C  
ATOM   1963  CG  LEU   239      43.143   7.089  57.372  1.00 30.13           C  
ATOM   1964  CD1 LEU   239      44.072   5.828  57.356  1.00 31.29           C  
ATOM   1965  CD2 LEU   239      42.612   7.377  55.973  1.00 34.74           C  
ATOM   1966  N   GLY   240      43.945   6.698  61.120  1.00 24.72           N  
ATOM   1967  CA  GLY   240      44.729   7.483  62.057  1.00 24.42           C  
ATOM   1968  C   GLY   240      46.042   7.840  61.374  1.00 24.09           C  
ATOM   1969  O   GLY   240      46.785   6.949  60.937  1.00 23.99           O  
ATOM   1970  N   VAL   241      46.332   9.142  61.299  1.00 24.04           N  
ATOM   1971  CA  VAL   241      47.449   9.639  60.515  1.00 24.33           C  
ATOM   1972  C   VAL   241      48.455  10.346  61.447  1.00 23.63           C  
ATOM   1973  O   VAL   241      48.043  11.158  62.283  1.00 23.79           O  
ATOM   1974  CB  VAL   241      46.928  10.651  59.474  1.00 24.63           C  
ATOM   1975  CG1 VAL   241      48.129  11.281  58.676  1.00 25.61           C  
ATOM   1976  CG2 VAL   241      45.830   9.988  58.557  1.00 25.98           C  
ATOM   1977  N   ALA   242      49.743  10.018  61.317  1.00 22.72           N  
ATOM   1978  CA  ALA   242      50.804  10.750  62.022  1.00 23.21           C  
ATOM   1979  C   ALA   242      51.487  11.737  61.068  1.00 22.60           C  
ATOM   1980  O   ALA   242      51.840  11.384  59.944  1.00 22.15           O  
ATOM   1981  CB  ALA   242      51.846   9.767  62.625  1.00 23.54           C  
ATOM   1982  N   MET   243      51.630  12.988  61.524  1.00 22.05           N  
ATOM   1983  CA  MET   243      52.361  14.012  60.813  1.00 22.04           C  
ATOM   1984  C   MET   243      53.819  13.591  60.787  1.00 22.56           C  
ATOM   1985  O   MET   243      54.292  12.919  61.700  1.00 22.91           O  
ATOM   1986  CB  MET   243      52.199  15.376  61.527  1.00 20.21           C  
ATOM   1987  CG  MET   243      50.726  15.848  61.559  1.00 22.79           C  
ATOM   1988  SD  MET   243      50.166  16.341  59.759  0.70 26.56          SE  
ATOM   1989  CE  MET   243      51.564  17.566  59.227  1.00 24.96           C  
ATOM   1990  N   GLY   244      54.527  14.004  59.743  1.00 22.35           N  
ATOM   1991  CA  GLY   244      55.936  13.689  59.578  1.00 23.44           C  
ATOM   1992  C   GLY   244      56.833  14.174  60.708  1.00 24.47           C  
ATOM   1993  O   GLY   244      57.893  13.588  60.958  1.00 24.84           O  
ATOM   1994  N   ASN   245      56.422  15.250  61.373  1.00 24.06           N  
ATOM   1995  CA  ASN   245      57.198  15.842  62.460  1.00 22.95           C  
ATOM   1996  C   ASN   245      56.949  15.141  63.812  1.00 23.19           C  
ATOM   1997  O   ASN   245      57.580  15.509  64.827  1.00 23.42           O  
ATOM   1998  CB  ASN   245      56.876  17.341  62.571  1.00 21.83           C  
ATOM   1999  CG  ASN   245      55.377  17.622  62.450  1.00 22.80           C  
ATOM   2000  OD1 ASN   245      54.792  17.493  61.360  1.00 21.47           O  
ATOM   2001  ND2 ASN   245      54.739  17.947  63.576  1.00 21.39           N  
ATOM   2002  N   ALA   246      56.072  14.130  63.836  1.00 22.82           N  
ATOM   2003  CA  ALA   246      55.839  13.332  65.050  1.00 22.79           C  
ATOM   2004  C   ALA   246      57.073  12.480  65.367  1.00 23.93           C  
ATOM   2005  O   ALA   246      57.844  12.153  64.467  1.00 23.59           O  
ATOM   2006  CB  ALA   246      54.623  12.428  64.894  1.00 22.71           C  
ATOM   2007  N   VAL   247      57.269  12.103  66.638  1.00 24.77           N  
ATOM   2008  CA  VAL   247      58.391  11.192  66.956  1.00 25.24           C  
ATOM   2009  C   VAL   247      58.183   9.791  66.325  1.00 26.43           C  
ATOM   2010  O   VAL   247      57.052   9.408  66.064  1.00 26.31           O  
ATOM   2011  CB  VAL   247      58.661  11.093  68.485  1.00 25.73           C  
ATOM   2012  CG1 VAL   247      59.047  12.472  69.049  1.00 26.91           C  
ATOM   2013  CG2 VAL   247      57.456  10.490  69.236  1.00 25.18           C  
ATOM   2014  N   PRO   248      59.274   9.053  66.041  1.00 26.84           N  
ATOM   2015  CA  PRO   248      59.184   7.721  65.401  1.00 28.05           C  
ATOM   2016  C   PRO   248      58.164   6.752  66.010  1.00 28.51           C  
ATOM   2017  O   PRO   248      57.472   6.056  65.262  1.00 28.43           O  
ATOM   2018  CB  PRO   248      60.611   7.178  65.543  1.00 28.55           C  
ATOM   2019  CG  PRO   248      61.437   8.402  65.432  1.00 28.21           C  
ATOM   2020  CD  PRO   248      60.688   9.441  66.243  1.00 27.65           C  
ATOM   2021  N   GLU   249      58.045   6.714  67.336  1.00 29.47           N  
ATOM   2022  CA  GLU   249      57.081   5.809  67.977  1.00 31.60           C  
ATOM   2023  C   GLU   249      55.653   6.076  67.531  1.00 30.30           C  
ATOM   2024  O   GLU   249      54.891   5.145  67.255  1.00 30.56           O  
ATOM   2025  CB  GLU   249      57.137   5.920  69.496  1.00 32.47           C  
ATOM   2026  CG  GLU   249      56.068   5.031  70.201  1.00 36.08           C  
ATOM   2027  CD  GLU   249      56.011   5.273  71.694  1.00 36.27           C  
ATOM   2028  OE1 GLU   249      57.098   5.515  72.270  1.00 41.61           O  
ATOM   2029  OE2 GLU   249      54.892   5.224  72.281  1.00 40.09           O  
ATOM   2030  N   ILE   250      55.291   7.358  67.480  1.00 27.91           N  
ATOM   2031  CA  ILE   250      53.971   7.750  67.007  1.00 26.50           C  
ATOM   2032  C   ILE   250      53.788   7.397  65.539  1.00 26.00           C  
ATOM   2033  O   ILE   250      52.730   6.896  65.129  1.00 25.28           O  
ATOM   2034  CB  ILE   250      53.729   9.236  67.272  1.00 26.28           C  
ATOM   2035  CG1 ILE   250      53.754   9.446  68.802  1.00 27.05           C  
ATOM   2036  CG2 ILE   250      52.427   9.698  66.596  1.00 26.15           C  
ATOM   2037  CD1 ILE   250      53.726  10.881  69.239  1.00 30.28           C  
ATOM   2038  N   LYS   251      54.833   7.635  64.750  1.00 25.02           N  
ATOM   2039  CA  LYS   251      54.780   7.291  63.324  1.00 25.90           C  
ATOM   2040  C   LYS   251      54.607   5.792  63.105  1.00 26.34           C  
ATOM   2041  O   LYS   251      53.857   5.373  62.218  1.00 27.33           O  
ATOM   2042  CB  LYS   251      56.008   7.853  62.597  1.00 25.13           C  
ATOM   2043  CG  LYS   251      55.946   9.402  62.603  1.00 27.20           C  
ATOM   2044  CD  LYS   251      56.880  10.070  61.611  1.00 27.44           C  
ATOM   2045  CE  LYS   251      58.301  10.034  62.110  1.00 30.65           C  
ATOM   2046  NZ  LYS   251      59.127  11.048  61.390  1.00 27.07           N  
ATOM   2047  N   ARG   252      55.258   4.982  63.931  1.00 26.48           N  
ATOM   2048  CA  ARG   252      55.081   3.521  63.830  1.00 26.17           C  
ATOM   2049  C   ARG   252      53.658   3.088  64.172  1.00 27.38           C  
ATOM   2050  O   ARG   252      53.122   2.138  63.558  1.00 27.56           O  
ATOM   2051  CB  ARG   252      56.067   2.788  64.726  1.00 25.93           C  
ATOM   2052  CG  ARG   252      57.483   2.791  64.223  1.00 24.21           C  
ATOM   2053  CD  ARG   252      58.314   1.746  64.989  1.00 27.39           C  
ATOM   2054  NE  ARG   252      58.402   2.104  66.409  1.00 28.96           N  
ATOM   2055  CZ  ARG   252      59.325   2.912  66.926  1.00 29.93           C  
ATOM   2056  NH1 ARG   252      60.255   3.464  66.150  1.00 30.96           N  
ATOM   2057  NH2 ARG   252      59.301   3.185  68.223  1.00 31.28           N  
ATOM   2058  N   LYS   253      53.029   3.806  65.104  1.00 26.16           N  
ATOM   2059  CA  LYS   253      51.714   3.395  65.603  1.00 26.68           C  
ATOM   2060  C   LYS   253      50.532   3.801  64.737  1.00 25.93           C  
ATOM   2061  O   LYS   253      49.469   3.203  64.830  1.00 25.23           O  
ATOM   2062  CB  LYS   253      51.530   3.854  67.034  1.00 26.72           C  
ATOM   2063  CG  LYS   253      52.386   3.029  67.945  1.00 30.39           C  
ATOM   2064  CD  LYS   253      52.209   3.410  69.383  1.00 31.63           C  
ATOM   2065  CE  LYS   253      52.644   2.234  70.273  1.00 33.52           C  
ATOM   2066  NZ  LYS   253      52.440   2.596  71.683  1.00 36.24           N  
ATOM   2067  N   ALA   254      50.729   4.814  63.907  1.00 24.33           N  
ATOM   2068  CA  ALA   254      49.709   5.294  62.990  1.00 24.70           C  
ATOM   2069  C   ALA   254      49.421   4.318  61.839  1.00 26.07           C  
ATOM   2070  O   ALA   254      50.261   3.451  61.495  1.00 25.87           O  
ATOM   2071  CB  ALA   254      50.128   6.638  62.423  1.00 24.51           C  
ATOM   2072  N   ASP   255      48.266   4.483  61.207  1.00 25.57           N  
ATOM   2073  CA  ASP   255      47.956   3.693  60.015  1.00 27.11           C  
ATOM   2074  C   ASP   255      48.709   4.236  58.813  1.00 27.57           C  
ATOM   2075  O   ASP   255      49.010   3.523  57.870  1.00 26.36           O  
ATOM   2076  CB  ASP   255      46.465   3.750  59.727  1.00 27.08           C  
ATOM   2077  CG  ASP   255      45.630   3.348  60.935  1.00 28.43           C  
ATOM   2078  OD1 ASP   255      46.098   2.472  61.708  1.00 30.86           O  
ATOM   2079  OD2 ASP   255      44.525   3.911  61.114  1.00 27.78           O  
ATOM   2080  N   TRP   256      49.014   5.524  58.873  1.00 28.09           N  
ATOM   2081  CA  TRP   256      49.508   6.246  57.732  1.00 28.91           C  
ATOM   2082  C   TRP   256      50.416   7.359  58.225  1.00 27.48           C  
ATOM   2083  O   TRP   256      50.028   8.072  59.143  1.00 26.12           O  
ATOM   2084  CB  TRP   256      48.280   6.865  57.103  1.00 31.66           C  
ATOM   2085  CG  TRP   256      48.473   7.553  55.835  1.00 35.83           C  
ATOM   2086  CD1 TRP   256      49.530   8.360  55.467  1.00 39.27           C  
ATOM   2087  CD2 TRP   256      47.555   7.570  54.750  1.00 37.87           C  
ATOM   2088  NE1 TRP   256      49.330   8.846  54.196  1.00 40.18           N  
ATOM   2089  CE2 TRP   256      48.114   8.392  53.741  1.00 40.29           C  
ATOM   2090  CE3 TRP   256      46.304   6.976  54.529  1.00 39.44           C  
ATOM   2091  CZ2 TRP   256      47.465   8.627  52.523  1.00 39.24           C  
ATOM   2092  CZ3 TRP   256      45.653   7.213  53.317  1.00 38.57           C  
ATOM   2093  CH2 TRP   256      46.237   8.034  52.330  1.00 38.71           C  
ATOM   2094  N   VAL   257      51.592   7.522  57.616  1.00 25.70           N  
ATOM   2095  CA  VAL   257      52.486   8.651  57.971  1.00 26.11           C  
ATOM   2096  C   VAL   257      52.534   9.629  56.808  1.00 26.15           C  
ATOM   2097  O   VAL   257      52.800   9.222  55.658  1.00 25.71           O  
ATOM   2098  CB  VAL   257      53.926   8.165  58.276  1.00 25.53           C  
ATOM   2099  CG1 VAL   257      54.822   9.328  58.596  1.00 25.30           C  
ATOM   2100  CG2 VAL   257      53.931   7.181  59.453  1.00 27.38           C  
ATOM   2101  N   THR   258      52.256  10.903  57.078  1.00 24.62           N  
ATOM   2102  CA  THR   258      52.303  11.903  56.008  1.00 24.30           C  
ATOM   2103  C   THR   258      53.565  12.763  56.156  1.00 23.94           C  
ATOM   2104  O   THR   258      54.437  12.497  57.010  1.00 23.29           O  
ATOM   2105  CB  THR   258      50.963  12.710  55.940  1.00 24.99           C  
ATOM   2106  OG1 THR   258      50.926  13.539  54.768  1.00 24.74           O  
ATOM   2107  CG2 THR   258      50.718  13.567  57.201  1.00 23.24           C  
ATOM   2108  N   ARG   259      53.689  13.775  55.312  1.00 22.47           N  
ATOM   2109  CA  ARG   259      54.808  14.695  55.401  1.00 22.99           C  
ATOM   2110  C   ARG   259      54.673  15.618  56.633  1.00 22.86           C  
ATOM   2111  O   ARG   259      53.647  15.593  57.317  1.00 23.01           O  
ATOM   2112  CB  ARG   259      54.849  15.529  54.139  1.00 21.55           C  
ATOM   2113  CG  ARG   259      55.174  14.668  52.937  1.00 24.21           C  
ATOM   2114  CD  ARG   259      55.297  15.488  51.699  1.00 24.26           C  
ATOM   2115  NE  ARG   259      55.839  14.667  50.598  1.00 24.24           N  
ATOM   2116  CZ  ARG   259      56.083  15.144  49.382  1.00 27.53           C  
ATOM   2117  NH1 ARG   259      55.805  16.426  49.121  1.00 22.20           N  
ATOM   2118  NH2 ARG   259      56.564  14.331  48.426  1.00 25.32           N  
ATOM   2119  N   SER   260      55.706  16.405  56.917  1.00 23.28           N  
ATOM   2120  CA  SER   260      55.705  17.229  58.138  1.00 23.33           C  
ATOM   2121  C   SER   260      54.753  18.428  57.995  1.00 22.50           C  
ATOM   2122  O   SER   260      54.306  18.746  56.884  1.00 22.18           O  
ATOM   2123  CB  SER   260      57.131  17.734  58.409  1.00 25.09           C  
ATOM   2124  OG  SER   260      57.382  18.926  57.677  1.00 27.19           O  
ATOM   2125  N   ASN   261      54.516  19.142  59.105  1.00 22.48           N  
ATOM   2126  CA  ASN   261      53.738  20.376  59.074  1.00 22.26           C  
ATOM   2127  C   ASN   261      54.443  21.519  58.344  1.00 22.43           C  
ATOM   2128  O   ASN   261      53.813  22.519  58.003  1.00 22.77           O  
ATOM   2129  CB  ASN   261      53.318  20.802  60.502  1.00 21.69           C  
ATOM   2130  CG  ASN   261      54.498  21.144  61.391  1.00 22.89           C  
ATOM   2131  OD1 ASN   261      55.555  20.481  61.364  1.00 22.86           O  
ATOM   2132  ND2 ASN   261      54.307  22.171  62.227  1.00 22.44           N  
ATOM   2133  N   ASP   262      55.749  21.385  58.121  1.00 22.12           N  
ATOM   2134  CA  ASP   262      56.460  22.377  57.308  1.00 22.60           C  
ATOM   2135  C   ASP   262      56.566  21.958  55.830  1.00 21.47           C  
ATOM   2136  O   ASP   262      57.220  22.631  55.028  1.00 21.76           O  
ATOM   2137  CB  ASP   262      57.827  22.702  57.914  1.00 23.23           C  
ATOM   2138  CG  ASP   262      57.701  23.550  59.204  1.00 28.19           C  
ATOM   2139  OD1 ASP   262      56.796  24.403  59.290  1.00 27.66           O  
ATOM   2140  OD2 ASP   262      58.485  23.332  60.143  1.00 33.51           O  
ATOM   2141  N   GLU   263      55.935  20.842  55.488  1.00 20.80           N  
ATOM   2142  CA  GLU   263      55.899  20.352  54.103  1.00 20.78           C  
ATOM   2143  C   GLU   263      54.452  19.989  53.758  1.00 21.17           C  
ATOM   2144  O   GLU   263      54.193  19.045  53.025  1.00 22.36           O  
ATOM   2145  CB  GLU   263      56.830  19.147  53.922  1.00 21.19           C  
ATOM   2146  CG  GLU   263      57.305  18.969  52.469  1.00 23.89           C  
ATOM   2147  CD  GLU   263      58.305  20.051  52.082  1.00 26.49           C  
ATOM   2148  OE1 GLU   263      57.984  20.868  51.161  1.00 26.66           O  
ATOM   2149  OE2 GLU   263      59.402  20.108  52.732  1.00 27.13           O  
ATOM   2150  N   GLN   264      53.509  20.729  54.332  1.00 20.75           N  
ATOM   2151  CA  GLN   264      52.091  20.622  53.972  1.00 21.64           C  
ATOM   2152  C   GLN   264      51.573  19.180  54.046  1.00 21.50           C  
ATOM   2153  O   GLN   264      50.905  18.699  53.141  1.00 21.41           O  
ATOM   2154  CB  GLN   264      51.838  21.292  52.588  1.00 20.91           C  
ATOM   2155  CG  GLN   264      51.810  22.840  52.717  1.00 23.81           C  
ATOM   2156  CD  GLN   264      53.155  23.394  53.217  1.00 25.44           C  
ATOM   2157  OE1 GLN   264      53.308  23.782  54.413  1.00 22.26           O  
ATOM   2158  NE2 GLN   264      54.162  23.374  52.313  1.00 22.74           N  
ATOM   2159  N   GLY   265      51.851  18.519  55.166  1.00 20.55           N  
ATOM   2160  CA  GLY   265      51.471  17.127  55.333  1.00 21.09           C  
ATOM   2161  C   GLY   265      49.973  16.875  55.378  1.00 22.40           C  
ATOM   2162  O   GLY   265      49.515  15.828  54.922  1.00 21.89           O  
ATOM   2163  N   VAL   266      49.211  17.835  55.908  1.00 21.97           N  
ATOM   2164  CA  VAL   266      47.721  17.726  55.884  1.00 22.34           C  
ATOM   2165  C   VAL   266      47.177  17.692  54.434  1.00 22.44           C  
ATOM   2166  O   VAL   266      46.434  16.773  54.065  1.00 22.33           O  
ATOM   2167  CB  VAL   266      47.061  18.869  56.706  1.00 21.95           C  
ATOM   2168  CG1 VAL   266      45.535  18.928  56.427  1.00 23.91           C  
ATOM   2169  CG2 VAL   266      47.319  18.618  58.180  1.00 23.66           C  
ATOM   2170  N   ALA   267      47.548  18.697  53.632  1.00 21.52           N  
ATOM   2171  CA  ALA   267      47.176  18.747  52.217  1.00 22.29           C  
ATOM   2172  C   ALA   267      47.645  17.503  51.447  1.00 22.60           C  
ATOM   2173  O   ALA   267      46.916  16.959  50.594  1.00 22.47           O  
ATOM   2174  CB  ALA   267      47.726  20.014  51.562  1.00 22.47           C  
ATOM   2175  N   TYR   268      48.857  17.052  51.748  1.00 21.54           N  
ATOM   2176  CA  TYR   268      49.449  15.932  51.026  1.00 23.44           C  
ATOM   2177  C   TYR   268      48.621  14.669  51.301  1.00 24.29           C  
ATOM   2178  O   TYR   268      48.274  13.905  50.367  1.00 24.69           O  
ATOM   2179  CB  TYR   268      50.894  15.731  51.491  1.00 23.22           C  
ATOM   2180  CG  TYR   268      51.715  14.768  50.652  1.00 23.53           C  
ATOM   2181  CD1 TYR   268      52.211  15.146  49.413  1.00 23.71           C  
ATOM   2182  CD2 TYR   268      52.037  13.505  51.133  1.00 25.80           C  
ATOM   2183  CE1 TYR   268      53.010  14.275  48.643  1.00 24.92           C  
ATOM   2184  CE2 TYR   268      52.818  12.595  50.355  1.00 22.95           C  
ATOM   2185  CZ  TYR   268      53.302  13.009  49.117  1.00 23.37           C  
ATOM   2186  OH  TYR   268      54.091  12.152  48.347  1.00 27.35           O  
ATOM   2187  N   MET   269      48.306  14.468  52.581  1.00 25.17           N  
ATOM   2188  CA  MET   269      47.506  13.307  52.969  0.50 25.64           C  
ATOM   2190  C   MET   269      46.100  13.379  52.366  1.00 25.96           C  
ATOM   2191  O   MET   269      45.602  12.371  51.838  1.00 26.32           O  
ATOM   2192  CB  MET   269      47.481  13.137  54.495  0.50 26.22           C  
ATOM   2194  CG  MET   269      46.753  11.904  54.997  0.50 26.59           C  
ATOM   2196  SD  MET   269      44.912  12.282  55.331  0.40 30.28          SE  
ATOM   2198  CE  MET   269      44.208  10.481  55.334  0.50 26.85           C  
ATOM   2200  N   MET   270      45.450  14.538  52.412  1.00 25.78           N  
ATOM   2201  CA  MET   270      44.070  14.568  51.896  1.00 25.69           C  
ATOM   2202  C   MET   270      43.972  14.413  50.375  1.00 24.64           C  
ATOM   2203  O   MET   270      43.013  13.825  49.877  1.00 23.32           O  
ATOM   2204  CB  MET   270      43.268  15.755  52.440  1.00 26.63           C  
ATOM   2205  CG  MET   270      42.825  15.545  53.961  1.00 27.90           C  
ATOM   2206  SD  MET   270      41.981  13.811  54.467  0.50 33.51          SE  
ATOM   2207  CE  MET   270      40.197  14.101  53.788  1.00 31.19           C  
ATOM   2208  N   LYS   271      44.983  14.896  49.653  1.00 23.82           N  
ATOM   2209  CA  LYS   271      45.079  14.665  48.209  1.00 24.03           C  
ATOM   2210  C   LYS   271      45.081  13.154  47.917  1.00 24.38           C  
ATOM   2211  O   LYS   271      44.362  12.670  47.021  1.00 22.62           O  
ATOM   2212  CB  LYS   271      46.335  15.337  47.654  1.00 24.47           C  
ATOM   2213  CG  LYS   271      46.520  15.228  46.144  1.00 28.95           C  
ATOM   2214  CD  LYS   271      45.551  16.114  45.384  1.00 33.45           C  
ATOM   2215  CE  LYS   271      45.691  15.935  43.886  1.00 37.61           C  
ATOM   2216  NZ  LYS   271      44.779  16.886  43.204  1.00 39.47           N  
ATOM   2217  N   GLU   272      45.877  12.411  48.677  1.00 23.92           N  
ATOM   2218  CA  GLU   272      45.906  10.938  48.549  1.00 26.36           C  
ATOM   2219  C   GLU   272      44.581  10.270  48.930  1.00 26.60           C  
ATOM   2220  O   GLU   272      44.140   9.337  48.218  1.00 27.95           O  
ATOM   2221  CB  GLU   272      47.062  10.326  49.346  1.00 26.62           C  
ATOM   2222  CG  GLU   272      47.214   8.811  49.151  1.00 29.70           C  
ATOM   2223  CD  GLU   272      47.293   8.396  47.695  1.00 32.19           C  
ATOM   2224  OE1 GLU   272      47.910   9.137  46.883  1.00 34.53           O  
ATOM   2225  OE2 GLU   272      46.727   7.327  47.342  1.00 31.05           O  
ATOM   2226  N   TYR   273      43.962  10.730  50.018  1.00 27.42           N  
ATOM   2227  CA  TYR   273      42.645  10.244  50.417  1.00 29.11           C  
ATOM   2228  C   TYR   273      41.693  10.315  49.235  1.00 28.66           C  
ATOM   2229  O   TYR   273      40.979   9.347  48.960  1.00 28.96           O  
ATOM   2230  CB  TYR   273      42.071  10.981  51.636  1.00 30.66           C  
ATOM   2231  CG  TYR   273      40.606  10.658  51.859  1.00 33.11           C  
ATOM   2232  CD1 TYR   273      39.612  11.556  51.477  1.00 35.41           C  
ATOM   2233  CD2 TYR   273      40.211   9.410  52.383  1.00 37.23           C  
ATOM   2234  CE1 TYR   273      38.252  11.254  51.638  1.00 36.08           C  
ATOM   2235  CE2 TYR   273      38.848   9.091  52.547  1.00 35.87           C  
ATOM   2236  CZ  TYR   273      37.884  10.029  52.179  1.00 36.29           C  
ATOM   2237  OH  TYR   273      36.545   9.741  52.329  1.00 36.82           O  
ATOM   2238  N   PHE   274      41.701  11.436  48.511  1.00 27.89           N  
ATOM   2239  CA  PHE   274      40.801  11.576  47.361  1.00 27.82           C  
ATOM   2240  C   PHE   274      41.198  10.776  46.122  1.00 28.80           C  
ATOM   2241  O   PHE   274      40.331  10.270  45.398  1.00 27.67           O  
ATOM   2242  CB  PHE   274      40.536  13.035  47.045  1.00 28.07           C  
ATOM   2243  CG  PHE   274      39.715  13.705  48.098  1.00 29.10           C  
ATOM   2244  CD1 PHE   274      38.391  13.303  48.324  1.00 31.46           C  
ATOM   2245  CD2 PHE   274      40.262  14.696  48.889  1.00 29.57           C  
ATOM   2246  CE1 PHE   274      37.625  13.911  49.319  1.00 32.39           C  
ATOM   2247  CE2 PHE   274      39.508  15.316  49.883  1.00 30.78           C  
ATOM   2248  CZ  PHE   274      38.198  14.925  50.098  1.00 29.96           C  
ATOM   2249  N   ARG   275      42.492  10.670  45.869  1.00 29.47           N  
ATOM   2250  CA  ARG   275      42.956   9.764  44.817  1.00 32.37           C  
ATOM   2251  C   ARG   275      42.481   8.333  45.105  1.00 33.10           C  
ATOM   2252  O   ARG   275      42.013   7.642  44.205  1.00 33.20           O  
ATOM   2253  CB  ARG   275      44.478   9.860  44.643  1.00 31.99           C  
ATOM   2254  CG  ARG   275      44.897  11.083  43.793  1.00 34.08           C  
ATOM   2255  CD  ARG   275      46.361  11.045  43.328  1.00 34.50           C  
ATOM   2256  NE  ARG   275      47.193  11.008  44.498  1.00 36.44           N  
ATOM   2257  CZ  ARG   275      47.923  12.011  44.982  1.00 37.79           C  
ATOM   2258  NH1 ARG   275      48.059  13.173  44.338  1.00 39.78           N  
ATOM   2259  NH2 ARG   275      48.571  11.808  46.104  1.00 27.71           N  
ATOM   2260  N   MET   276      42.568   7.917  46.363  1.00 35.02           N  
ATOM   2261  CA  MET   276      42.074   6.605  46.816  1.00 38.13           C  
ATOM   2262  C   MET   276      40.580   6.439  46.522  1.00 38.01           C  
ATOM   2263  O   MET   276      40.161   5.423  45.963  1.00 38.25           O  
ATOM   2264  CB  MET   276      42.323   6.465  48.319  1.00 38.20           C  
ATOM   2265  CG  MET   276      43.023   5.196  48.773  1.00 40.53           C  
ATOM   2266  SD  MET   276      44.223   5.555  50.270  0.50 41.91          SE  
ATOM   2267  CE  MET   276      43.199   6.978  51.120  1.00 42.05           C  
ATOM   2268  N   GLN   277      39.793   7.443  46.899  1.00 38.41           N  
ATOM   2269  CA  GLN   277      38.355   7.535  46.572  1.00 39.20           C  
ATOM   2270  C   GLN   277      38.045   7.405  45.086  1.00 39.22           C  
ATOM   2271  O   GLN   277      37.153   6.650  44.691  1.00 38.94           O  
ATOM   2272  CB  GLN   277      37.792   8.870  47.074  1.00 39.68           C  
ATOM   2273  CG  GLN   277      37.736   8.976  48.580  1.00 42.29           C  
ATOM   2274  CD  GLN   277      36.893   7.873  49.186  1.00 46.38           C  
ATOM   2275  OE1 GLN   277      37.383   7.072  49.988  1.00 49.96           O  
ATOM   2276  NE2 GLN   277      35.626   7.810  48.790  1.00 46.50           N  
ATOM   2277  N   GLN   278      38.777   8.151  44.267  1.00 39.48           N  
ATOM   2278  CA  GLN   278      38.612   8.118  42.821  1.00 40.80           C  
ATOM   2279  C   GLN   278      38.903   6.717  42.258  1.00 40.52           C  
ATOM   2280  O   GLN   278      38.180   6.228  41.383  1.00 40.34           O  
ATOM   2281  CB  GLN   278      39.540   9.151  42.190  1.00 40.71           C  
ATOM   2282  CG  GLN   278      39.202   9.545  40.770  1.00 42.69           C  
ATOM   2283  CD  GLN   278      40.159  10.602  40.240  1.00 43.19           C  
ATOM   2284  OE1 GLN   278      40.382  11.636  40.889  1.00 46.36           O  
ATOM   2285  NE2 GLN   278      40.743  10.342  39.064  1.00 44.93           N  
ATOM   2286  N   ARG   279      39.954   6.074  42.772  1.00 40.61           N  
ATOM   2287  CA  ARG   279      40.327   4.713  42.359  1.00 40.81           C  
ATOM   2288  C   ARG   279      39.246   3.698  42.730  1.00 40.76           C  
ATOM   2289  O   ARG   279      38.869   2.854  41.910  1.00 40.29           O  
ATOM   2290  CB  ARG   279      41.671   4.317  42.969  1.00 41.24           C  
ATOM   2291  CG  ARG   279      42.856   5.053  42.346  1.00 41.88           C  
ATOM   2292  CD  ARG   279      44.163   4.348  42.653  1.00 42.99           C  
ATOM   2293  NE  ARG   279      44.582   4.612  44.016  1.00 43.79           N  
ATOM   2294  CZ  ARG   279      45.338   5.647  44.376  1.00 43.13           C  
ATOM   2295  NH1 ARG   279      45.777   6.518  43.463  1.00 42.82           N  
ATOM   2296  NH2 ARG   279      45.652   5.802  45.650  1.00 41.15           N  
ATOM   2297  N   LYS   280      38.754   3.792  43.965  1.00 40.64           N  
ATOM   2298  CA  LYS   280      37.587   3.026  44.395  1.00 40.87           C  
ATOM   2299  C   LYS   280      36.318   3.585  43.743  1.00 40.93           C  
ATOM   2300  O   LYS   280      35.798   3.009  42.779  1.00 41.19           O  
ATOM   2301  CB  LYS   280      37.465   3.046  45.922  1.00 40.47           C  
END
