
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  113 (  869),  selected  113 , name 2ns1_B
# Molecule2: number of CA atoms  116 (  926),  selected  116 , name T0505_85_200.pdb
# PARAMETERS: 2ns1_B.T0505_85_200.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     0_B      K      85           -
LGA    M     1_B      -       -           -
LGA    K     2_B      -       -           -
LGA    L     3_B      -       -           -
LGA    V     4_B      -       -           -
LGA    T     5_B      -       -           -
LGA    V     6_B      -       -           -
LGA    I     7_B      R      86          6.085
LGA    I     8_B      I      87          2.808
LGA    K     9_B      S      88          2.638
LGA    P    10_B      D      89          2.640
LGA    F    11_B      D      90          1.538
LGA    K    12_B      X      91          0.702
LGA    L    13_B      T      92          1.330
LGA    E    14_B      F      93          1.607
LGA    D    15_B      N      94          1.102
LGA    V    16_B      I      95          0.834
LGA    R    17_B      V      96          1.285
LGA    E    18_B      Q      97          1.383
LGA    A    19_B      V      98          0.951
LGA    L    20_B      L      99          1.217
LGA    S    21_B      E     100          1.687
LGA    S    22_B      S     101          1.847
LGA    I    23_B      Y     102          2.739
LGA    G    24_B      Q     103          3.169
LGA    I    25_B      C     104          3.083
LGA    Q    26_B      -       -           -
LGA    G    27_B      N     105          2.638
LGA    L    28_B      I     106          1.150
LGA    T    29_B      R     107          0.755
LGA    V    30_B      L     108          0.416
LGA    T    31_B      L     109          1.809
LGA    E    32_B      X     110          2.250
LGA    V    33_B      E     111          5.026
LGA    K    34_B      K     112           -
LGA    G    35_B      Y     113           -
LGA    F    36_B      S     114           -
LGA    G    37_B      I     115           -
LGA    R    38_B      G     116           -
LGA    Q    39_B      N     117           -
LGA    K    40_B      K     118           -
LGA    G    41_B      K     119           -
LGA    H    42_B      K     120           -
LGA    A    43_B      V     121           -
LGA    E    44_B      N     122           -
LGA    L    45_B      S     123           -
LGA    Y    46_B      N     124           -
LGA    R    47_B      L     125           -
LGA    G    48_B      L     126           -
LGA    A    49_B      G     127           -
LGA    E    50_B      K     128           -
LGA    F    51_B      A     129           -
LGA    S    52_B      L     130           -
LGA    V    53_B      I     131           -
LGA    N    54_B      X     132           -
LGA    F    55_B      P     133           -
LGA    L    56_B      S     134           -
LGA    P    57_B      D     135           -
LGA    -       -      P     136           -
LGA    -       -      I     137           -
LGA    -       -      F     138           -
LGA    -       -      Y     139           -
LGA    -       -      P     140           -
LGA    -       -      V     141           -
LGA    -       -      Q     142           -
LGA    -       -      F     143           -
LGA    -       -      V     144           -
LGA    -       -      E     145           -
LGA    -       -      S     146           -
LGA    -       -      L     147           -
LGA    -       -      S     148           -
LGA    -       -      D     149           -
LGA    -       -      L     150           -
LGA    -       -      L     151           -
LGA    -       -      M     152           -
LGA    -       -      D     153           -
LGA    -       -      E     154           -
LGA    -       -      P     155           -
LGA    -       -      V     156           -
LGA    K    58_B      S     157          4.877
LGA    V    59_B      A     158          1.350
LGA    -       -      P     159           -
LGA    K    60_B      V     160          1.292
LGA    I    61_B      I     161          0.613
LGA    D    62_B      E     162          0.612
LGA    V    63_B      V     163          1.201
LGA    A    64_B      Y     164          1.034
LGA    I    65_B      T     165          1.169
LGA    A    66_B      E     166          1.575
LGA    D    67_B      X     167          1.492
LGA    D    68_B      D     168          0.926
LGA    Q    69_B      I     169          0.767
LGA    L    70_B      Q     170          0.982
LGA    D    71_B      X     171          1.021
LGA    E    72_B      D     172          0.744
LGA    V    73_B      I     173          0.692
LGA    I    74_B      T     174          0.733
LGA    D    75_B      E     175          1.645
LGA    I    76_B      T     176          1.801
LGA    V    77_B      I     177          1.626
LGA    S    78_B      T     178          1.991
LGA    K    79_B      K     179          3.327
LGA    A    80_B      A     180          3.599
LGA    A    81_B      F     181          2.611
LGA    Y    82_B      P     182          3.034
LGA    T    83_B      -       -           -
LGA    G    84_B      -       -           -
LGA    K    85_B      -       -           -
LGA    I    86_B      -       -           -
LGA    G    87_B      -       -           -
LGA    D    88_B      A     183          1.663
LGA    G    89_B      V     184          2.919
LGA    K    90_B      D     185          2.206
LGA    I    91_B      V     186          1.517
LGA    F    92_B      I     187          1.178
LGA    V    93_B      R     188          1.029
LGA    A    94_B      V     189          1.129
LGA    E    95_B      N     190          1.580
LGA    -       -      D     191           -
LGA    L    96_B      E     192          5.419
LGA    Q    97_B      K     193           -
LGA    R    98_B      L     194           -
LGA    V    99_B      N     195           -
LGA    I   100_B      I     196           -
LGA    R   101_B      V     197           -
LGA    I   102_B      P     198           -
LGA    R   103_B      K     199           -
LGA    T   104_B      G     200           -
LGA    G   105_B      -       -           -
LGA    E   106_B      -       -           -
LGA    A   107_B      -       -           -
LGA    D   108_B      -       -           -
LGA    E   109_B      -       -           -
LGA    A   110_B      -       -           -
LGA    A   111_B      -       -           -
LGA    L   112_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  113  116    5.0     60    2.23    13.33     45.110     2.576

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.249909 * X  +  -0.740205 * Y  +   0.624214 * Z  + -34.382904
  Y_new =  -0.629480 * X  +  -0.365646 * Y  +  -0.685607 * Z  + 111.479507
  Z_new =   0.735731 * X  +  -0.564270 * Y  +  -0.374566 * Z  + 122.668724 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.156816    0.984776  [ DEG:  -123.5765     56.4235 ]
  Theta =  -0.826745   -2.314847  [ DEG:   -47.3690   -132.6310 ]
  Phi   =  -1.948721    1.192872  [ DEG:  -111.6535     68.3465 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ns1_B                                        
REMARK     2: T0505_85_200.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ns1_B.T0505_85_200.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  113  116   5.0   60   2.23   13.33  45.110
REMARK  ---------------------------------------------------------- 
MOLECULE 2ns1_B
HEADER    TRANSPORT PROTEIN/SIGNALING PROTEIN     02-NOV-06   2NS1              
TITLE     CRYSTAL STRUCTURE OF THE E. COLI AMMONIA CHANNEL AMTB                 
TITLE    2 COMPLEXED WITH THE SIGNAL TRANSDUCTION PROTEIN GLNK                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AMMONIA CHANNEL;                                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 23-428;                                           
COMPND   5 SYNONYM: AMMONIA TRANSPORTER;                                        
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: NITROGEN REGULATORY PROTEIN P-II 2;                        
COMPND   9 CHAIN: B;                                                            
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12;                                                         
SOURCE   5 GENE: AMTB;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: C43;                                       
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET29B;                                   
SOURCE  11 MOL_ID: 2;                                                           
SOURCE  12 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  13 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  14 STRAIN: K12;                                                         
SOURCE  15 GENE: GLNK;                                                          
SOURCE  16 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  17 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  18 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  19 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  20 EXPRESSION_SYSTEM_PLASMID: PET47B                                    
KEYWDS    PROTEIN-PROTEIN COMPLEX, MEMBRANE PROTEIN, AMMONIA, CHANNEL,          
KEYWDS   2 REGULATORY, INHIBITOR, SIGNAL PROTEIN, ADP, BOG, STRUCTURAL          
KEYWDS   3 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, CENTER FOR            
KEYWDS   4 STRUCTURES OF MEMBRANE PROTEINS, CSMP                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.GRUSWITZ,J.O'CONNELL III,R.M.STROUD,CENTER FOR STRUCTURES           
AUTHOR   2 OF MEMBRANE PROTEINS (CSMP)                                          
REVDAT   3   16-JAN-07 2NS1    1       HEADER                                   
REVDAT   2   09-JAN-07 2NS1    1       DBREF                                    
REVDAT   1   26-DEC-06 2NS1    0                                                
JRNL        AUTH   F.GRUSWITZ,J.O'CONNELL III,R.M.STROUD                        
JRNL        TITL   INHIBITORY COMPLEX OF THE TRANSMEMBRANE AMMONIA              
JRNL        TITL 2 CHANNEL, AMTB, AND THE CYTOSOLIC REGULATORY                  
JRNL        TITL 3 PROTEIN, GLNK, AT 1.96                                       
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 104    42 2007              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 1.96 ANGSTROMS.                                          
DBREF  2NS1 A    1   406  UNP    P69681   AMTB_ECOLI      23    428             
DBREF  2NS1 B    1   112  UNP    P0AC55   GLNK_ECOLI       1    112             
SEQRES   1 A  412  ALA PRO ALA VAL ALA ASP LYS ALA ASP ASN ALA PHE MET          
SEQRES   2 A  412  MET ILE CYS THR ALA LEU VAL LEU PHE MET THR ILE PRO          
SEQRES   3 A  412  GLY ILE ALA LEU PHE TYR GLY GLY LEU ILE ARG GLY LYS          
SEQRES   4 A  412  ASN VAL LEU SER MET LEU THR GLN VAL THR VAL THR PHE          
SEQRES   5 A  412  ALA LEU VAL CYS ILE LEU TRP VAL VAL TYR GLY TYR SER          
SEQRES   6 A  412  LEU ALA PHE GLY GLU GLY ASN ASN PHE PHE GLY ASN ILE          
SEQRES   7 A  412  ASN TRP LEU MET LEU LYS ASN ILE GLU LEU THR ALA VAL          
SEQRES   8 A  412  MET GLY SER ILE TYR GLN TYR ILE HIS VAL ALA PHE GLN          
SEQRES   9 A  412  GLY SER PHE ALA CYS ILE THR VAL GLY LEU ILE VAL GLY          
SEQRES  10 A  412  ALA LEU ALA GLU ARG ILE ARG PHE SER ALA VAL LEU ILE          
SEQRES  11 A  412  PHE VAL VAL VAL TRP LEU THR LEU SER TYR ILE PRO ILE          
SEQRES  12 A  412  ALA HIS MET VAL TRP GLY GLY GLY LEU LEU ALA SER HIS          
SEQRES  13 A  412  GLY ALA LEU ASP PHE ALA GLY GLY THR VAL VAL HIS ILE          
SEQRES  14 A  412  ASN ALA ALA ILE ALA GLY LEU VAL GLY ALA TYR LEU ILE          
SEQRES  15 A  412  GLY LYS ARG VAL GLY PHE GLY LYS GLU ALA PHE LYS PRO          
SEQRES  16 A  412  HIS ASN LEU PRO MET VAL PHE THR GLY THR ALA ILE LEU          
SEQRES  17 A  412  TYR ILE GLY TRP PHE GLY PHE ASN ALA GLY SER ALA GLY          
SEQRES  18 A  412  THR ALA ASN GLU ILE ALA ALA LEU ALA PHE VAL ASN THR          
SEQRES  19 A  412  VAL VAL ALA THR ALA ALA ALA ILE LEU GLY TRP ILE PHE          
SEQRES  20 A  412  GLY GLU TRP ALA LEU ARG GLY LYS PRO SER LEU LEU GLY          
SEQRES  21 A  412  ALA CYS SER GLY ALA ILE ALA GLY LEU VAL GLY VAL THR          
SEQRES  22 A  412  PRO ALA CYS GLY TYR ILE GLY VAL GLY GLY ALA LEU ILE          
SEQRES  23 A  412  ILE GLY VAL VAL ALA GLY LEU ALA GLY LEU TRP GLY VAL          
SEQRES  24 A  412  THR MET LEU LYS ARG LEU LEU ARG VAL ASP ASP PRO CYS          
SEQRES  25 A  412  ASP VAL PHE GLY VAL HIS GLY VAL CYS GLY ILE VAL GLY          
SEQRES  26 A  412  CYS ILE MET THR GLY ILE PHE ALA ALA SER SER LEU GLY          
SEQRES  27 A  412  GLY VAL GLY PHE ALA GLU GLY VAL THR MET GLY HIS GLN          
SEQRES  28 A  412  LEU LEU VAL GLN LEU GLU SER ILE ALA ILE THR ILE VAL          
SEQRES  29 A  412  TRP SER GLY VAL VAL ALA PHE ILE GLY TYR LYS LEU ALA          
SEQRES  30 A  412  ASP LEU THR VAL GLY LEU ARG VAL PRO GLU GLU GLN GLU          
SEQRES  31 A  412  ARG GLU GLY LEU ASP VAL ASN SER HIS GLY GLU ASN ALA          
SEQRES  32 A  412  TYR ASN ALA GLY THR LEU VAL PRO ARG                          
SEQRES   1 B  116  GLY PRO GLY SER MET LYS LEU VAL THR VAL ILE ILE LYS          
SEQRES   2 B  116  PRO PHE LYS LEU GLU ASP VAL ARG GLU ALA LEU SER SER          
SEQRES   3 B  116  ILE GLY ILE GLN GLY LEU THR VAL THR GLU VAL LYS GLY          
SEQRES   4 B  116  PHE GLY ARG GLN LYS GLY HIS ALA GLU LEU TYR ARG GLY          
SEQRES   5 B  116  ALA GLU PHE SER VAL ASN PHE LEU PRO LYS VAL LYS ILE          
SEQRES   6 B  116  ASP VAL ALA ILE ALA ASP ASP GLN LEU ASP GLU VAL ILE          
SEQRES   7 B  116  ASP ILE VAL SER LYS ALA ALA TYR THR GLY LYS ILE GLY          
SEQRES   8 B  116  ASP GLY LYS ILE PHE VAL ALA GLU LEU GLN ARG VAL ILE          
SEQRES   9 B  116  ARG ILE ARG THR GLY GLU ALA ASP GLU ALA ALA LEU              
HET    BOG    601      20                                                       
HET    BOG    602      20                                                       
HET    BOG    603      20                                                       
HET    BOG    604      20                                                       
HET    BOG    605      20                                                       
HET    BOG    606      20                                                       
HET    BOG    607      20                                                       
HET    BOG    608      20                                                       
HET    ADP  B 200      27                                                       
HET    TRS    701       8                                                       
HET    TRS    702       8                                                       
HETNAM     BOG B-OCTYLGLUCOSIDE                                                 
HETNAM     ADP ADENOSINE-5'-DIPHOSPHATE                                         
HETNAM     TRS 2-AMINO-2-HYDROXYMETHYL-PROPANE-1,3-DIOL                         
HETSYN     TRS TRIS BUFFER                                                      
FORMUL   3  BOG    8(C14 H28 O6)                                                
FORMUL  11  ADP    C10 H15 N5 O10 P2                                            
FORMUL  12  TRS    2(C4 H12 N O3 1+)                                            
FORMUL  14  HOH   *498(H2 O)                                                    
CRYST1  102.032  102.032  363.849  90.00  90.00 120.00 H 3 2        18          
ATOM   3024  N   SER B   0      62.057  14.627  75.563  1.00 67.14           N  
ATOM   3025  CA  SER B   0      62.351  14.532  77.025  1.00 64.86           C  
ATOM   3026  C   SER B   0      61.785  15.708  77.837  1.00 61.47           C  
ATOM   3027  O   SER B   0      61.981  15.766  79.052  1.00 65.84           O  
ATOM   3028  CB  SER B   0      63.857  14.418  77.267  1.00 64.12           C  
ATOM   3029  OG  SER B   0      64.457  15.699  77.420  1.00 70.68           O  
ATOM   3030  N   MET B   1      61.130  16.657  77.166  1.00 52.88           N  
ATOM   3031  CA  MET B   1      60.240  17.607  77.840  1.00 49.58           C  
ATOM   3032  C   MET B   1      58.802  17.100  77.591  1.00 46.02           C  
ATOM   3033  O   MET B   1      58.497  16.575  76.520  1.00 38.21           O  
ATOM   3034  CB  MET B   1      60.412  19.031  77.289  1.00 53.73           C  
ATOM   3035  CG  MET B   1      61.796  19.669  77.479  1.00 50.05           C  
ATOM   3036  SD  MET B   1      62.418  19.584  79.183  1.00 58.45           S  
ATOM   3037  CE  MET B   1      61.397  20.841  79.980  1.00 53.98           C  
ATOM   3038  N   LYS B   2      57.939  17.223  78.598  1.00 42.20           N  
ATOM   3039  CA  LYS B   2      56.536  16.817  78.476  1.00 41.46           C  
ATOM   3040  C   LYS B   2      55.618  17.991  78.826  1.00 38.88           C  
ATOM   3041  O   LYS B   2      55.930  18.812  79.697  1.00 36.23           O  
ATOM   3042  CB  LYS B   2      56.226  15.653  79.419  1.00 42.92           C  
ATOM   3043  CG  LYS B   2      57.137  14.455  79.253  1.00 43.02           C  
ATOM   3044  CD  LYS B   2      56.896  13.731  77.948  1.00 45.26           C  
ATOM   3045  CE  LYS B   2      57.617  12.381  77.957  1.00 47.19           C  
ATOM   3046  NZ  LYS B   2      58.266  12.114  76.653  1.00 50.17           N  
ATOM   3047  N   LEU B   3      54.483  18.060  78.144  1.00 40.32           N  
ATOM   3048  CA  LEU B   3      53.401  18.916  78.584  1.00 37.74           C  
ATOM   3049  C   LEU B   3      52.370  18.022  79.256  1.00 31.75           C  
ATOM   3050  O   LEU B   3      51.812  17.131  78.621  1.00 38.72           O  
ATOM   3051  CB  LEU B   3      52.746  19.654  77.413  1.00 40.51           C  
ATOM   3052  CG  LEU B   3      51.667  20.667  77.831  1.00 36.77           C  
ATOM   3053  CD1 LEU B   3      52.346  21.807  78.623  1.00 42.34           C  
ATOM   3054  CD2 LEU B   3      50.941  21.202  76.594  1.00 40.79           C  
ATOM   3055  N   VAL B   4      52.123  18.287  80.534  1.00 31.86           N  
ATOM   3056  CA  VAL B   4      51.095  17.604  81.278  1.00 34.26           C  
ATOM   3057  C   VAL B   4      49.885  18.516  81.368  1.00 36.71           C  
ATOM   3058  O   VAL B   4      50.002  19.645  81.837  1.00 36.84           O  
ATOM   3059  CB  VAL B   4      51.599  17.221  82.665  1.00 33.28           C  
ATOM   3060  CG1 VAL B   4      50.470  16.556  83.498  1.00 36.37           C  
ATOM   3061  CG2 VAL B   4      52.796  16.293  82.526  1.00 35.06           C  
ATOM   3062  N   THR B   5      48.737  18.022  80.899  1.00 35.33           N  
ATOM   3063  CA  THR B   5      47.462  18.718  81.000  1.00 32.88           C  
ATOM   3064  C   THR B   5      46.605  17.987  82.005  1.00 34.94           C  
ATOM   3065  O   THR B   5      46.484  16.764  81.940  1.00 39.11           O  
ATOM   3066  CB  THR B   5      46.703  18.706  79.650  1.00 40.27           C  
ATOM   3067  OG1 THR B   5      47.498  19.346  78.667  1.00 39.43           O  
ATOM   3068  CG2 THR B   5      45.348  19.413  79.753  1.00 39.16           C  
ATOM   3069  N   VAL B   6      46.003  18.740  82.920  1.00 32.94           N  
ATOM   3070  CA  VAL B   6      45.145  18.185  83.951  1.00 37.97           C  
ATOM   3071  C   VAL B   6      43.812  18.927  83.936  1.00 38.69           C  
ATOM   3072  O   VAL B   6      43.783  20.143  84.036  1.00 37.07           O  
ATOM   3073  CB  VAL B   6      45.798  18.342  85.348  1.00 42.04           C  
ATOM   3074  CG1 VAL B   6      45.027  17.544  86.382  1.00 50.32           C  
ATOM   3075  CG2 VAL B   6      47.237  17.886  85.326  1.00 41.34           C  
ATOM   3076  N   ILE B   7      42.718  18.191  83.819  1.00 36.48           N  
ATOM   3077  CA  ILE B   7      41.375  18.765  83.856  1.00 36.88           C  
ATOM   3078  C   ILE B   7      40.744  18.316  85.165  1.00 41.72           C  
ATOM   3079  O   ILE B   7      40.570  17.122  85.393  1.00 36.90           O  
ATOM   3080  CB  ILE B   7      40.540  18.308  82.672  1.00 36.49           C  
ATOM   3081  CG1 ILE B   7      41.186  18.802  81.374  1.00 40.96           C  
ATOM   3082  CG2 ILE B   7      39.116  18.834  82.786  1.00 40.50           C  
ATOM   3083  CD1 ILE B   7      40.722  18.043  80.144  1.00 47.17           C  
ATOM   3084  N   ILE B   8      40.430  19.271  86.033  1.00 35.53           N  
ATOM   3085  CA  ILE B   8      40.023  18.942  87.397  1.00 39.04           C  
ATOM   3086  C   ILE B   8      38.842  19.777  87.828  1.00 42.71           C  
ATOM   3087  O   ILE B   8      38.450  20.734  87.155  1.00 39.42           O  
ATOM   3088  CB  ILE B   8      41.185  19.151  88.416  1.00 40.95           C  
ATOM   3089  CG1 ILE B   8      41.810  20.546  88.256  1.00 45.04           C  
ATOM   3090  CG2 ILE B   8      42.220  18.084  88.249  1.00 44.57           C  
ATOM   3091  CD1 ILE B   8      42.562  21.068  89.487  1.00 47.13           C  
ATOM   3092  N   LYS B   9      38.270  19.388  88.962  1.00 43.01           N  
ATOM   3093  CA  LYS B   9      37.260  20.195  89.620  1.00 40.40           C  
ATOM   3094  C   LYS B   9      37.924  21.495  90.109  1.00 39.82           C  
ATOM   3095  O   LYS B   9      39.037  21.471  90.647  1.00 38.32           O  
ATOM   3096  CB  LYS B   9      36.630  19.395  90.773  1.00 44.69           C  
ATOM   3097  CG  LYS B   9      35.551  18.428  90.289  1.00 49.92           C  
ATOM   3098  CD  LYS B   9      35.188  17.335  91.317  1.00 50.15           C  
ATOM   3099  CE  LYS B   9      34.219  16.298  90.712  1.00 47.83           C  
ATOM   3100  NZ  LYS B   9      34.128  15.043  91.520  1.00 52.91           N  
ATOM   3101  N   PRO B  10      37.274  22.639  89.871  1.00 37.81           N  
ATOM   3102  CA  PRO B  10      37.956  23.888  90.203  1.00 49.17           C  
ATOM   3103  C   PRO B  10      38.431  24.028  91.662  1.00 51.42           C  
ATOM   3104  O   PRO B  10      39.470  24.644  91.890  1.00 50.41           O  
ATOM   3105  CB  PRO B  10      36.925  24.954  89.844  1.00 43.76           C  
ATOM   3106  CG  PRO B  10      36.027  24.296  88.854  1.00 47.52           C  
ATOM   3107  CD  PRO B  10      35.957  22.874  89.261  1.00 46.66           C  
ATOM   3108  N   PHE B  11      37.711  23.440  92.621  1.00 51.46           N  
ATOM   3109  CA  PHE B  11      38.104  23.528  94.030  1.00 54.04           C  
ATOM   3110  C   PHE B  11      39.343  22.702  94.366  1.00 59.85           C  
ATOM   3111  O   PHE B  11      39.928  22.884  95.441  1.00 60.62           O  
ATOM   3112  CB  PHE B  11      36.939  23.225  95.000  1.00 62.14           C  
ATOM   3113  CG  PHE B  11      36.305  21.858  94.838  1.00 60.87           C  
ATOM   3114  CD1 PHE B  11      35.107  21.713  94.159  1.00 64.28           C  
ATOM   3115  CD2 PHE B  11      36.874  20.738  95.415  1.00 64.44           C  
ATOM   3116  CE1 PHE B  11      34.504  20.468  94.017  1.00 65.79           C  
ATOM   3117  CE2 PHE B  11      36.279  19.490  95.285  1.00 64.73           C  
ATOM   3118  CZ  PHE B  11      35.088  19.358  94.584  1.00 66.23           C  
ATOM   3119  N   LYS B  12      39.771  21.825  93.457  1.00 47.37           N  
ATOM   3120  CA  LYS B  12      41.000  21.074  93.691  1.00 46.19           C  
ATOM   3121  C   LYS B  12      42.235  21.795  93.212  1.00 37.58           C  
ATOM   3122  O   LYS B  12      43.342  21.305  93.408  1.00 50.40           O  
ATOM   3123  CB  LYS B  12      40.930  19.683  93.059  1.00 43.30           C  
ATOM   3124  CG  LYS B  12      39.708  18.861  93.471  1.00 54.01           C  
ATOM   3125  CD  LYS B  12      39.552  18.696  94.984  1.00 55.55           C  
ATOM   3126  CE  LYS B  12      40.698  17.944  95.609  1.00 56.77           C  
ATOM   3127  NZ  LYS B  12      40.360  17.449  96.980  1.00 57.07           N  
ATOM   3128  N   LEU B  13      42.071  22.969  92.605  1.00 47.75           N  
ATOM   3129  CA  LEU B  13      43.214  23.688  92.026  1.00 46.32           C  
ATOM   3130  C   LEU B  13      44.303  24.025  93.040  1.00 36.66           C  
ATOM   3131  O   LEU B  13      45.490  23.829  92.766  1.00 46.86           O  
ATOM   3132  CB  LEU B  13      42.752  24.976  91.325  1.00 47.25           C  
ATOM   3133  CG  LEU B  13      43.869  25.862  90.735  1.00 48.53           C  
ATOM   3134  CD1 LEU B  13      44.820  25.071  89.851  1.00 45.10           C  
ATOM   3135  CD2 LEU B  13      43.278  27.029  89.948  1.00 49.59           C  
ATOM   3136  N   GLU B  14      43.910  24.549  94.198  1.00 54.85           N  
ATOM   3137  CA  GLU B  14      44.885  24.933  95.224  1.00 54.66           C  
ATOM   3138  C   GLU B  14      45.655  23.704  95.712  1.00 55.05           C  
ATOM   3139  O   GLU B  14      46.882  23.706  95.746  1.00 56.56           O  
ATOM   3140  CB  GLU B  14      44.197  25.654  96.391  1.00 66.35           C  
ATOM   3141  CG  GLU B  14      45.146  26.140  97.506  1.00 71.23           C  
ATOM   3142  CD  GLU B  14      45.870  27.427  97.157  1.00 80.31           C  
ATOM   3143  OE1 GLU B  14      46.266  27.590  95.983  1.00 82.74           O  
ATOM   3144  OE2 GLU B  14      46.045  28.278  98.064  1.00 84.64           O  
ATOM   3145  N   ASP B  15      44.925  22.646  96.053  1.00 56.77           N  
ATOM   3146  CA  ASP B  15      45.551  21.391  96.445  1.00 52.06           C  
ATOM   3147  C   ASP B  15      46.529  20.902  95.386  1.00 50.82           C  
ATOM   3148  O   ASP B  15      47.647  20.503  95.707  1.00 47.77           O  
ATOM   3149  CB  ASP B  15      44.491  20.322  96.710  1.00 53.42           C  
ATOM   3150  CG  ASP B  15      43.701  20.581  97.992  1.00 60.18           C  
ATOM   3151  OD1 ASP B  15      44.142  21.416  98.819  1.00 67.27           O  
ATOM   3152  OD2 ASP B  15      42.646  19.938  98.173  1.00 60.43           O  
ATOM   3153  N   VAL B  16      46.128  20.946  94.118  1.00 49.46           N  
ATOM   3154  CA  VAL B  16      47.026  20.494  93.058  1.00 46.91           C  
ATOM   3155  C   VAL B  16      48.280  21.392  92.952  1.00 45.02           C  
ATOM   3156  O   VAL B  16      49.398  20.895  92.787  1.00 48.72           O  
ATOM   3157  CB  VAL B  16      46.293  20.383  91.713  1.00 48.77           C  
ATOM   3158  CG1 VAL B  16      47.269  20.036  90.598  1.00 36.60           C  
ATOM   3159  CG2 VAL B  16      45.174  19.339  91.816  1.00 38.66           C  
ATOM   3160  N   ARG B  17      48.092  22.700  93.088  1.00 53.34           N  
ATOM   3161  CA  ARG B  17      49.202  23.652  93.051  0.50 55.09           C  
ATOM   3163  C   ARG B  17      50.198  23.408  94.190  1.00 49.32           C  
ATOM   3164  O   ARG B  17      51.415  23.396  93.980  1.00 47.89           O  
ATOM   3165  CB  ARG B  17      48.675  25.091  93.136  0.50 58.83           C  
ATOM   3167  CG  ARG B  17      49.640  26.125  92.575  0.50 59.20           C  
ATOM   3169  CD  ARG B  17      49.540  27.480  93.271  0.50 62.54           C  
ATOM   3171  NE  ARG B  17      50.554  27.634  94.321  0.50 65.65           N  
ATOM   3173  CZ  ARG B  17      50.351  27.478  95.631  0.50 63.20           C  
ATOM   3175  NH1 ARG B  17      49.154  27.165  96.116  0.50 61.64           N  
ATOM   3177  NH2 ARG B  17      51.365  27.646  96.466  0.50 65.41           N  
ATOM   3179  N   GLU B  18      49.670  23.226  95.396  1.00 58.19           N  
ATOM   3180  CA  GLU B  18      50.520  22.986  96.567  1.00 59.22           C  
ATOM   3181  C   GLU B  18      51.304  21.686  96.417  1.00 56.36           C  
ATOM   3182  O   GLU B  18      52.503  21.646  96.693  1.00 56.87           O  
ATOM   3183  CB  GLU B  18      49.696  23.012  97.856  1.00 67.35           C  
ATOM   3184  CG  GLU B  18      49.160  24.411  98.167  1.00 77.42           C  
ATOM   3185  CD  GLU B  18      49.114  24.736  99.651  1.00 80.84           C  
ATOM   3186  OE1 GLU B  18      48.896  23.808 100.463  1.00 92.19           O  
ATOM   3187  OE2 GLU B  18      49.291  25.927 100.002  1.00 86.10           O  
ATOM   3188  N   ALA B  19      50.641  20.635  95.930  1.00 54.59           N  
ATOM   3189  CA  ALA B  19      51.318  19.374  95.640  1.00 50.90           C  
ATOM   3190  C   ALA B  19      52.430  19.556  94.622  1.00 52.20           C  
ATOM   3191  O   ALA B  19      53.518  18.990  94.775  1.00 53.53           O  
ATOM   3192  CB  ALA B  19      50.317  18.330  95.151  1.00 52.21           C  
ATOM   3193  N   LEU B  20      52.178  20.336  93.574  1.00 51.77           N  
ATOM   3194  CA  LEU B  20      53.225  20.580  92.570  1.00 51.23           C  
ATOM   3195  C   LEU B  20      54.387  21.407  93.137  1.00 43.64           C  
ATOM   3196  O   LEU B  20      55.555  21.110  92.887  1.00 46.51           O  
ATOM   3197  CB  LEU B  20      52.627  21.246  91.325  1.00 49.87           C  
ATOM   3198  CG  LEU B  20      51.702  20.330  90.507  1.00 42.38           C  
ATOM   3199  CD1 LEU B  20      50.910  21.139  89.475  1.00 42.94           C  
ATOM   3200  CD2 LEU B  20      52.491  19.220  89.856  1.00 46.40           C  
ATOM   3201  N   SER B  21      54.074  22.442  93.902  1.00 53.20           N  
ATOM   3202  CA  SER B  21      55.127  23.277  94.484  1.00 61.57           C  
ATOM   3203  C   SER B  21      55.995  22.449  95.422  1.00 62.20           C  
ATOM   3204  O   SER B  21      57.212  22.608  95.418  1.00 57.81           O  
ATOM   3205  CB  SER B  21      54.556  24.499  95.205  1.00 60.76           C  
ATOM   3206  OG  SER B  21      53.255  24.234  95.673  1.00 69.79           O  
ATOM   3207  N   SER B  22      55.369  21.525  96.158  1.00 62.24           N  
ATOM   3208  CA  SER B  22      56.084  20.619  97.071  1.00 62.84           C  
ATOM   3209  C   SER B  22      57.182  19.783  96.403  1.00 65.67           C  
ATOM   3210  O   SER B  22      58.091  19.325  97.089  1.00 75.24           O  
ATOM   3211  CB  SER B  22      55.108  19.672  97.772  1.00 64.75           C  
ATOM   3212  OG  SER B  22      54.870  18.514  96.980  1.00 66.75           O  
ATOM   3213  N   ILE B  23      57.101  19.562  95.089  1.00 57.81           N  
ATOM   3214  CA  ILE B  23      58.159  18.835  94.376  1.00 57.32           C  
ATOM   3215  C   ILE B  23      58.972  19.744  93.442  1.00 56.60           C  
ATOM   3216  O   ILE B  23      59.644  19.271  92.513  1.00 61.78           O  
ATOM   3217  CB  ILE B  23      57.597  17.589  93.634  1.00 59.91           C  
ATOM   3218  CG1 ILE B  23      56.687  17.982  92.462  1.00 63.21           C  
ATOM   3219  CG2 ILE B  23      56.818  16.718  94.623  1.00 63.12           C  
ATOM   3220  CD1 ILE B  23      56.309  16.820  91.557  1.00 58.63           C  
ATOM   3221  N   GLY B  24      58.930  21.048  93.714  1.00 56.79           N  
ATOM   3222  CA  GLY B  24      59.722  22.029  92.974  1.00 58.86           C  
ATOM   3223  C   GLY B  24      59.096  22.519  91.674  1.00 59.11           C  
ATOM   3224  O   GLY B  24      59.820  22.955  90.770  1.00 57.42           O  
ATOM   3225  N   ILE B  25      57.764  22.454  91.582  1.00 55.41           N  
ATOM   3226  CA  ILE B  25      57.036  22.934  90.396  1.00 55.03           C  
ATOM   3227  C   ILE B  25      56.029  24.007  90.806  1.00 51.45           C  
ATOM   3228  O   ILE B  25      54.929  23.710  91.291  1.00 57.11           O  
ATOM   3229  CB  ILE B  25      56.327  21.787  89.612  1.00 53.29           C  
ATOM   3230  CG1 ILE B  25      57.285  20.632  89.329  1.00 51.29           C  
ATOM   3231  CG2 ILE B  25      55.794  22.304  88.275  1.00 49.46           C  
ATOM   3232  CD1 ILE B  25      56.648  19.457  88.584  1.00 47.57           C  
ATOM   3233  N   GLN B  26      56.421  25.265  90.618  1.00 53.26           N  
ATOM   3234  CA  GLN B  26      55.550  26.410  90.919  1.00 62.81           C  
ATOM   3235  C   GLN B  26      55.041  27.146  89.671  1.00 56.33           C  
ATOM   3236  O   GLN B  26      54.104  27.954  89.750  1.00 57.96           O  
ATOM   3237  CB  GLN B  26      56.299  27.393  91.810  1.00 72.63           C  
ATOM   3238  CG  GLN B  26      56.905  26.738  93.044  1.00 78.42           C  
ATOM   3239  CD  GLN B  26      57.095  27.723  94.168  1.00 80.71           C  
ATOM   3240  OE1 GLN B  26      58.005  28.555  94.131  1.00 86.57           O  
ATOM   3241  NE2 GLN B  26      56.226  27.647  95.177  1.00 89.35           N  
ATOM   3242  N   GLY B  27      55.661  26.875  88.530  1.00 43.73           N  
ATOM   3243  CA  GLY B  27      55.302  27.549  87.291  1.00 44.89           C  
ATOM   3244  C   GLY B  27      54.270  26.731  86.548  1.00 40.19           C  
ATOM   3245  O   GLY B  27      54.469  25.538  86.316  1.00 40.65           O  
ATOM   3246  N   LEU B  28      53.159  27.366  86.188  1.00 38.72           N  
ATOM   3247  CA  LEU B  28      52.124  26.689  85.393  1.00 37.28           C  
ATOM   3248  C   LEU B  28      51.057  27.641  84.887  1.00 35.55           C  
ATOM   3249  O   LEU B  28      50.983  28.797  85.312  1.00 33.30           O  
ATOM   3250  CB  LEU B  28      51.467  25.588  86.202  1.00 38.47           C  
ATOM   3251  CG  LEU B  28      50.899  25.950  87.560  1.00 43.81           C  
ATOM   3252  CD1 LEU B  28      49.467  26.357  87.417  1.00 43.01           C  
ATOM   3253  CD2 LEU B  28      51.013  24.733  88.473  1.00 49.76           C  
ATOM   3254  N   THR B  29      50.217  27.126  83.994  1.00 33.67           N  
ATOM   3255  CA  THR B  29      49.196  27.937  83.340  1.00 31.54           C  
ATOM   3256  C   THR B  29      47.837  27.274  83.497  1.00 34.95           C  
ATOM   3257  O   THR B  29      47.699  26.058  83.325  1.00 36.11           O  
ATOM   3258  CB  THR B  29      49.524  28.096  81.857  1.00 35.56           C  
ATOM   3259  OG1 THR B  29      50.797  28.746  81.715  1.00 38.71           O  
ATOM   3260  CG2 THR B  29      48.440  28.925  81.165  1.00 31.63           C  
ATOM   3261  N   VAL B  30      46.843  28.082  83.828  1.00 32.20           N  
ATOM   3262  CA  VAL B  30      45.509  27.597  84.141  1.00 29.24           C  
ATOM   3263  C   VAL B  30      44.482  28.215  83.209  1.00 32.83           C  
ATOM   3264  O   VAL B  30      44.541  29.406  82.926  1.00 33.38           O  
ATOM   3265  CB  VAL B  30      45.170  27.945  85.591  1.00 32.92           C  
ATOM   3266  CG1 VAL B  30      43.708  27.657  85.878  1.00 39.43           C  
ATOM   3267  CG2 VAL B  30      46.083  27.171  86.544  1.00 38.94           C  
ATOM   3268  N   THR B  31      43.542  27.397  82.738  1.00 35.54           N  
ATOM   3269  CA  THR B  31      42.470  27.856  81.856  1.00 32.94           C  
ATOM   3270  C   THR B  31      41.133  27.404  82.426  1.00 33.20           C  
ATOM   3271  O   THR B  31      40.996  26.274  82.893  1.00 32.08           O  
ATOM   3272  CB  THR B  31      42.630  27.288  80.422  1.00 33.20           C  
ATOM   3273  OG1 THR B  31      43.977  27.477  79.980  1.00 42.22           O  
ATOM   3274  CG2 THR B  31      41.640  27.977  79.432  1.00 32.11           C  
ATOM   3275  N   GLU B  32      40.145  28.288  82.388  1.00 30.68           N  
ATOM   3276  CA  GLU B  32      38.760  27.924  82.704  1.00 32.62           C  
ATOM   3277  C   GLU B  32      38.179  27.229  81.501  1.00 32.37           C  
ATOM   3278  O   GLU B  32      38.219  27.770  80.391  1.00 36.95           O  
ATOM   3279  CB  GLU B  32      37.909  29.174  82.959  1.00 42.20           C  
ATOM   3280  CG  GLU B  32      38.264  29.942  84.229  1.00 52.66           C  
ATOM   3281  CD  GLU B  32      37.422  31.212  84.381  1.00 59.27           C  
ATOM   3282  OE1 GLU B  32      37.979  32.324  84.218  1.00 74.40           O  
ATOM   3283  OE2 GLU B  32      36.198  31.099  84.641  1.00 65.90           O  
ATOM   3284  N   VAL B  33      37.652  26.026  81.701  1.00 30.69           N  
ATOM   3285  CA  VAL B  33      37.083  25.247  80.592  1.00 33.17           C  
ATOM   3286  C   VAL B  33      35.720  24.706  81.020  1.00 37.18           C  
ATOM   3287  O   VAL B  33      35.356  24.837  82.182  1.00 32.39           O  
ATOM   3288  CB  VAL B  33      38.024  24.100  80.136  1.00 31.22           C  
ATOM   3289  CG1 VAL B  33      39.353  24.676  79.579  1.00 35.95           C  
ATOM   3290  CG2 VAL B  33      38.302  23.130  81.264  1.00 35.59           C  
ATOM   3291  N   LYS B  34      34.967  24.156  80.069  1.00 31.25           N  
ATOM   3292  CA  LYS B  34      33.671  23.565  80.334  1.00 33.03           C  
ATOM   3293  C   LYS B  34      33.790  22.089  79.990  1.00 33.57           C  
ATOM   3294  O   LYS B  34      34.297  21.713  78.914  1.00 34.73           O  
ATOM   3295  CB  LYS B  34      32.546  24.217  79.519  1.00 44.28           C  
ATOM   3296  CG  LYS B  34      32.596  25.749  79.407  1.00 55.44           C  
ATOM   3297  CD  LYS B  34      32.578  26.468  80.768  1.00 62.76           C  
ATOM   3298  CE  LYS B  34      32.697  28.013  80.631  1.00 66.30           C  
ATOM   3299  NZ  LYS B  34      34.044  28.493  80.137  1.00 68.61           N  
ATOM   3300  N   GLY B  35      33.330  21.250  80.902  1.00 34.35           N  
ATOM   3301  CA  GLY B  35      33.464  19.794  80.756  1.00 41.81           C  
ATOM   3302  C   GLY B  35      32.138  19.070  80.558  1.00 41.99           C  
ATOM   3303  O   GLY B  35      31.103  19.432  81.145  1.00 45.88           O  
ATOM   3304  N   PHE B  36      32.175  18.062  79.697  1.00 39.62           N  
ATOM   3305  CA  PHE B  36      31.059  17.151  79.446  1.00 44.56           C  
ATOM   3306  C   PHE B  36      31.613  15.734  79.635  1.00 39.38           C  
ATOM   3307  O   PHE B  36      32.715  15.442  79.188  1.00 34.71           O  
ATOM   3308  CB  PHE B  36      30.583  17.263  77.986  1.00 56.60           C  
ATOM   3309  CG  PHE B  36      30.089  18.640  77.581  1.00 59.57           C  
ATOM   3310  CD1 PHE B  36      28.724  18.906  77.497  1.00 59.29           C  
ATOM   3311  CD2 PHE B  36      30.988  19.662  77.250  1.00 59.71           C  
ATOM   3312  CE1 PHE B  36      28.268  20.168  77.115  1.00 58.07           C  
ATOM   3313  CE2 PHE B  36      30.529  20.927  76.868  1.00 54.84           C  
ATOM   3314  CZ  PHE B  36      29.168  21.174  76.801  1.00 58.70           C  
ATOM   3315  N   GLY B  37      30.870  14.855  80.295  1.00 47.44           N  
ATOM   3316  CA  GLY B  37      31.281  13.452  80.374  1.00 46.72           C  
ATOM   3317  C   GLY B  37      30.286  12.621  81.163  1.00 49.34           C  
ATOM   3318  O   GLY B  37      29.082  12.818  81.050  1.00 42.10           O  
ATOM   3319  N   ARG B  38      30.802  11.699  81.969  1.00 46.12           N  
ATOM   3320  CA  ARG B  38      29.963  10.881  82.844  1.00 57.13           C  
ATOM   3321  C   ARG B  38      29.206  11.776  83.820  1.00 53.64           C  
ATOM   3322  O   ARG B  38      28.007  11.609  84.031  1.00 57.35           O  
ATOM   3323  CB  ARG B  38      30.826   9.851  83.590  1.00 60.66           C  
ATOM   3324  CG  ARG B  38      31.514   8.871  82.644  1.00 66.90           C  
ATOM   3325  CD  ARG B  38      32.395   7.854  83.356  1.00 72.33           C  
ATOM   3326  NE  ARG B  38      32.846   6.809  82.430  1.00 73.34           N  
ATOM   3327  CZ  ARG B  38      33.594   5.754  82.767  1.00 78.47           C  
ATOM   3328  NH1 ARG B  38      34.001   5.570  84.023  1.00 74.75           N  
ATOM   3329  NH2 ARG B  38      33.939   4.872  81.831  1.00 78.20           N  
ATOM   3330  N   GLN B  39      29.919  12.723  84.416  1.00 50.91           N  
ATOM   3331  CA  GLN B  39      29.299  13.760  85.218  1.00 53.70           C  
ATOM   3332  C   GLN B  39      28.647  14.802  84.277  1.00 60.38           C  
ATOM   3333  O   GLN B  39      29.309  15.391  83.386  1.00 57.13           O  
ATOM   3334  CB  GLN B  39      30.342  14.420  86.117  1.00 47.97           C  
ATOM   3335  CG  GLN B  39      29.775  15.133  87.348  1.00 54.25           C  
ATOM   3336  CD  GLN B  39      30.688  16.236  87.874  1.00 56.77           C  
ATOM   3337  OE1 GLN B  39      31.654  16.634  87.216  1.00 58.67           O  
ATOM   3338  NE2 GLN B  39      30.377  16.739  89.061  1.00 61.62           N  
ATOM   3339  N   LYS B  40      27.350  15.021  84.477  1.00 57.36           N  
ATOM   3340  CA  LYS B  40      26.571  15.958  83.660  1.00 64.53           C  
ATOM   3341  C   LYS B  40      25.847  17.020  84.512  1.00 64.44           C  
ATOM   3342  O   LYS B  40      25.508  16.781  85.680  1.00 60.14           O  
ATOM   3343  CB  LYS B  40      25.557  15.183  82.804  1.00 70.98           C  
ATOM   3344  CG  LYS B  40      26.133  13.908  82.181  1.00 73.39           C  
ATOM   3345  CD  LYS B  40      25.300  13.406  81.012  1.00 73.99           C  
ATOM   3346  CE  LYS B  40      25.875  12.105  80.448  1.00 77.14           C  
ATOM   3347  NZ  LYS B  40      25.345  11.800  79.089  1.00 79.44           N  
ATOM   3348  N   GLY B  41      25.620  18.190  83.909  1.00 61.96           N  
ATOM   3349  CA  GLY B  41      24.991  19.320  84.589  1.00 59.67           C  
ATOM   3350  C   GLY B  41      23.522  19.085  84.919  1.00 62.10           C  
ATOM   3351  O   GLY B  41      22.817  18.352  84.210  1.00 56.15           O  
ATOM   3352  N   HIS B  42      23.055  19.704  86.003  1.00 56.12           N  
ATOM   3353  CA  HIS B  42      21.632  19.665  86.350  1.00 47.69           C  
ATOM   3354  C   HIS B  42      20.865  20.318  85.205  1.00 46.90           C  
ATOM   3355  O   HIS B  42      21.443  21.095  84.447  1.00 52.51           O  
ATOM   3356  CB  HIS B  42      21.357  20.456  87.639  1.00 54.18           C  
ATOM   3357  CG  HIS B  42      21.908  19.833  88.884  1.00 64.18           C  
ATOM   3358  ND1 HIS B  42      23.258  19.666  89.103  1.00 72.04           N  
ATOM   3359  CD2 HIS B  42      21.291  19.389  90.005  1.00 69.52           C  
ATOM   3360  CE1 HIS B  42      23.448  19.118  90.291  1.00 68.99           C  
ATOM   3361  NE2 HIS B  42      22.270  18.940  90.861  1.00 68.56           N  
ATOM   3362  N   ALA B  43      19.568  20.028  85.089  1.00 39.95           N  
ATOM   3363  CA  ALA B  43      18.700  20.753  84.169  1.00 34.49           C  
ATOM   3364  C   ALA B  43      18.581  22.206  84.652  1.00 36.02           C  
ATOM   3365  O   ALA B  43      18.696  22.489  85.850  1.00 36.10           O  
ATOM   3366  CB  ALA B  43      17.320  20.127  84.102  1.00 42.17           C  
ATOM   3367  N   GLU B  44      18.360  23.108  83.712  1.00 37.69           N  
ATOM   3368  CA  GLU B  44      18.117  24.516  84.024  1.00 31.53           C  
ATOM   3369  C   GLU B  44      16.819  24.907  83.345  1.00 35.51           C  
ATOM   3370  O   GLU B  44      16.498  24.415  82.267  1.00 37.37           O  
ATOM   3371  CB  GLU B  44      19.255  25.374  83.500  1.00 30.06           C  
ATOM   3372  CG  GLU B  44      20.583  25.130  84.181  1.00 30.24           C  
ATOM   3373  CD  GLU B  44      21.747  25.876  83.534  1.00 37.84           C  
ATOM   3374  OE1 GLU B  44      21.522  26.795  82.702  1.00 37.93           O  
ATOM   3375  OE2 GLU B  44      22.907  25.525  83.866  1.00 41.58           O  
ATOM   3376  N   LEU B  45      16.074  25.794  83.978  1.00 33.21           N  
ATOM   3377  CA  LEU B  45      14.815  26.259  83.439  1.00 27.54           C  
ATOM   3378  C   LEU B  45      14.752  27.754  83.507  1.00 29.99           C  
ATOM   3379  O   LEU B  45      15.074  28.325  84.541  1.00 29.22           O  
ATOM   3380  CB  LEU B  45      13.665  25.708  84.260  1.00 40.02           C  
ATOM   3381  CG  LEU B  45      13.377  24.226  84.227  1.00 50.79           C  
ATOM   3382  CD1 LEU B  45      12.089  23.991  85.002  1.00 56.92           C  
ATOM   3383  CD2 LEU B  45      13.231  23.759  82.804  1.00 60.83           C  
ATOM   3384  N   TYR B  46      14.341  28.373  82.405  1.00 29.20           N  
ATOM   3385  CA  TYR B  46      14.208  29.817  82.319  1.00 29.03           C  
ATOM   3386  C   TYR B  46      12.850  30.107  81.705  1.00 28.04           C  
ATOM   3387  O   TYR B  46      12.644  29.900  80.494  1.00 32.94           O  
ATOM   3388  CB  TYR B  46      15.330  30.381  81.452  1.00 30.64           C  
ATOM   3389  CG  TYR B  46      16.704  30.044  81.970  1.00 27.11           C  
ATOM   3390  CD1 TYR B  46      17.303  30.810  82.971  1.00 32.46           C  
ATOM   3391  CD2 TYR B  46      17.406  28.950  81.477  1.00 29.65           C  
ATOM   3392  CE1 TYR B  46      18.567  30.509  83.432  1.00 28.51           C  
ATOM   3393  CE2 TYR B  46      18.667  28.634  81.949  1.00 32.54           C  
ATOM   3394  CZ  TYR B  46      19.240  29.420  82.930  1.00 32.84           C  
ATOM   3395  OH  TYR B  46      20.475  29.092  83.429  1.00 29.12           O  
ATOM   3396  N   ARG B  47      11.897  30.504  82.543  1.00 29.34           N  
ATOM   3397  CA  ARG B  47      10.501  30.636  82.098  1.00 29.27           C  
ATOM   3398  C   ARG B  47      10.085  29.350  81.346  1.00 27.84           C  
ATOM   3399  O   ARG B  47      10.229  28.249  81.899  1.00 32.95           O  
ATOM   3400  CB  ARG B  47      10.343  31.917  81.285  1.00 33.22           C  
ATOM   3401  CG  ARG B  47      10.433  33.193  82.164  1.00 32.11           C  
ATOM   3402  CD  ARG B  47      10.573  34.442  81.311  1.00 31.09           C  
ATOM   3403  NE  ARG B  47      10.129  35.627  82.031  1.00 35.25           N  
ATOM   3404  CZ  ARG B  47      10.009  36.827  81.482  1.00 34.38           C  
ATOM   3405  NH1 ARG B  47      10.302  37.012  80.212  1.00 36.78           N  
ATOM   3406  NH2 ARG B  47       9.598  37.863  82.214  1.00 39.52           N  
ATOM   3407  N   GLY B  48       9.614  29.452  80.112  1.00 31.28           N  
ATOM   3408  CA  GLY B  48       9.198  28.262  79.367  1.00 39.88           C  
ATOM   3409  C   GLY B  48      10.314  27.386  78.829  1.00 45.29           C  
ATOM   3410  O   GLY B  48      10.046  26.278  78.368  1.00 55.47           O  
ATOM   3411  N   ALA B  49      11.554  27.867  78.874  1.00 40.25           N  
ATOM   3412  CA  ALA B  49      12.692  27.172  78.239  1.00 42.56           C  
ATOM   3413  C   ALA B  49      13.357  26.209  79.198  1.00 39.68           C  
ATOM   3414  O   ALA B  49      13.718  26.577  80.311  1.00 40.92           O  
ATOM   3415  CB  ALA B  49      13.724  28.176  77.702  1.00 37.12           C  
ATOM   3416  N   GLU B  50      13.531  24.965  78.748  1.00 38.49           N  
ATOM   3417  CA  GLU B  50      14.110  23.898  79.551  1.00 42.68           C  
ATOM   3418  C   GLU B  50      15.415  23.485  78.892  1.00 42.68           C  
ATOM   3419  O   GLU B  50      15.469  23.370  77.662  1.00 36.94           O  
ATOM   3420  CB  GLU B  50      13.128  22.735  79.600  1.00 50.30           C  
ATOM   3421  CG  GLU B  50      13.592  21.501  80.335  1.00 60.68           C  
ATOM   3422  CD  GLU B  50      12.449  20.502  80.532  1.00 68.97           C  
ATOM   3423  OE1 GLU B  50      11.798  20.134  79.524  1.00 77.34           O  
ATOM   3424  OE2 GLU B  50      12.198  20.099  81.694  1.00 78.03           O  
ATOM   3425  N   PHE B  51      16.468  23.315  79.693  1.00 36.61           N  
ATOM   3426  CA  PHE B  51      17.787  22.909  79.179  1.00 41.50           C  
ATOM   3427  C   PHE B  51      18.263  21.734  79.996  1.00 44.15           C  
ATOM   3428  O   PHE B  51      18.601  21.877  81.170  1.00 41.84           O  
ATOM   3429  CB  PHE B  51      18.802  24.047  79.247  1.00 38.76           C  
ATOM   3430  CG  PHE B  51      18.399  25.238  78.458  1.00 40.04           C  
ATOM   3431  CD1 PHE B  51      18.768  25.358  77.135  1.00 46.21           C  
ATOM   3432  CD2 PHE B  51      17.592  26.211  79.009  1.00 39.83           C  
ATOM   3433  CE1 PHE B  51      18.345  26.432  76.394  1.00 43.73           C  
ATOM   3434  CE2 PHE B  51      17.176  27.290  78.262  1.00 40.76           C  
ATOM   3435  CZ  PHE B  51      17.560  27.402  76.959  1.00 41.09           C  
ATOM   3436  N   SER B  52      18.271  20.561  79.378  1.00 49.84           N  
ATOM   3437  CA  SER B  52      18.541  19.325  80.099  1.00 57.07           C  
ATOM   3438  C   SER B  52      19.988  18.905  79.911  1.00 59.20           C  
ATOM   3439  O   SER B  52      20.478  18.038  80.628  1.00 62.61           O  
ATOM   3440  CB  SER B  52      17.596  18.220  79.619  1.00 61.42           C  
ATOM   3441  OG  SER B  52      17.730  18.029  78.226  1.00 69.49           O  
ATOM   3442  N   VAL B  53      20.663  19.515  78.938  1.00 63.53           N  
ATOM   3443  CA  VAL B  53      22.073  19.239  78.669  1.00 64.51           C  
ATOM   3444  C   VAL B  53      22.847  20.484  79.048  1.00 64.98           C  
ATOM   3445  O   VAL B  53      22.644  21.530  78.431  1.00 64.26           O  
ATOM   3446  CB  VAL B  53      22.338  18.910  77.162  1.00 67.93           C  
ATOM   3447  CG1 VAL B  53      23.816  18.610  76.919  1.00 62.39           C  
ATOM   3448  CG2 VAL B  53      21.468  17.743  76.689  1.00 66.24           C  
ATOM   3449  N   ASN B  54      23.706  20.382  80.068  1.00 61.33           N  
ATOM   3450  CA  ASN B  54      24.545  21.501  80.483  1.00 55.94           C  
ATOM   3451  C   ASN B  54      25.977  21.058  80.799  1.00 56.85           C  
ATOM   3452  O   ASN B  54      26.198  19.962  81.323  1.00 48.18           O  
ATOM   3453  CB  ASN B  54      23.905  22.230  81.678  1.00 51.43           C  
ATOM   3454  CG  ASN B  54      22.552  22.836  81.326  1.00 50.15           C  
ATOM   3455  OD1 ASN B  54      22.426  23.587  80.355  1.00 50.22           O  
ATOM   3456  ND2 ASN B  54      21.539  22.484  82.082  1.00 50.41           N  
ATOM   3457  N   PHE B  55      26.944  21.913  80.455  1.00 48.93           N  
ATOM   3458  CA  PHE B  55      28.364  21.666  80.769  1.00 55.23           C  
ATOM   3459  C   PHE B  55      28.606  21.775  82.274  1.00 50.87           C  
ATOM   3460  O   PHE B  55      27.784  22.346  82.987  1.00 50.83           O  
ATOM   3461  CB  PHE B  55      29.241  22.712  80.074  1.00 66.99           C  
ATOM   3462  CG  PHE B  55      29.109  24.118  80.671  1.00 75.64           C  
ATOM   3463  CD1 PHE B  55      28.381  25.107  80.011  1.00 79.65           C  
ATOM   3464  CD2 PHE B  55      29.707  24.450  81.893  1.00 76.38           C  
ATOM   3465  CE1 PHE B  55      28.250  26.401  80.555  1.00 77.00           C  
ATOM   3466  CE2 PHE B  55      29.577  25.741  82.445  1.00 75.91           C  
ATOM   3467  CZ  PHE B  55      28.846  26.713  81.770  1.00 75.80           C  
ATOM   3468  N   LEU B  56      29.751  21.277  82.747  1.00 48.72           N  
ATOM   3469  CA  LEU B  56      30.260  21.628  84.080  1.00 45.61           C  
ATOM   3470  C   LEU B  56      31.548  22.463  84.000  1.00 50.06           C  
ATOM   3471  O   LEU B  56      32.419  22.155  83.194  1.00 41.89           O  
ATOM   3472  CB  LEU B  56      30.551  20.367  84.883  1.00 44.13           C  
ATOM   3473  CG  LEU B  56      29.314  19.567  85.280  1.00 48.72           C  
ATOM   3474  CD1 LEU B  56      29.715  18.145  85.590  1.00 46.32           C  
ATOM   3475  CD2 LEU B  56      28.587  20.220  86.458  1.00 43.49           C  
ATOM   3476  N   PRO B  57      31.681  23.500  84.855  1.00 42.19           N  
ATOM   3477  CA  PRO B  57      32.934  24.239  84.886  1.00 39.54           C  
ATOM   3478  C   PRO B  57      34.060  23.324  85.355  1.00 37.36           C  
ATOM   3479  O   PRO B  57      33.866  22.511  86.249  1.00 33.83           O  
ATOM   3480  CB  PRO B  57      32.679  25.326  85.928  1.00 47.43           C  
ATOM   3481  CG  PRO B  57      31.607  24.757  86.808  1.00 52.39           C  
ATOM   3482  CD  PRO B  57      30.725  24.010  85.853  1.00 48.45           C  
ATOM   3483  N   LYS B  58      35.211  23.426  84.709  1.00 36.15           N  
ATOM   3484  CA  LYS B  58      36.396  22.701  85.109  1.00 32.27           C  
ATOM   3485  C   LYS B  58      37.555  23.647  84.973  1.00 32.19           C  
ATOM   3486  O   LYS B  58      37.430  24.710  84.371  1.00 33.24           O  
ATOM   3487  CB  LYS B  58      36.649  21.479  84.209  1.00 40.37           C  
ATOM   3488  CG  LYS B  58      35.540  20.448  84.216  1.00 43.35           C  
ATOM   3489  CD  LYS B  58      35.404  19.708  85.536  1.00 41.56           C  
ATOM   3490  CE  LYS B  58      34.278  18.663  85.446  1.00 42.94           C  
ATOM   3491  NZ  LYS B  58      34.041  17.947  86.725  1.00 47.65           N  
ATOM   3492  N   VAL B  59      38.676  23.256  85.554  1.00 29.36           N  
ATOM   3493  CA  VAL B  59      39.940  23.963  85.438  0.50 32.07           C  
ATOM   3495  C   VAL B  59      40.911  23.067  84.687  1.00 34.65           C  
ATOM   3496  O   VAL B  59      40.987  21.881  84.975  1.00 35.65           O  
ATOM   3497  CB  VAL B  59      40.524  24.289  86.834  0.50 35.45           C  
ATOM   3499  CG1 VAL B  59      42.038  24.427  86.779  0.50 34.91           C  
ATOM   3501  CG2 VAL B  59      39.897  25.550  87.389  0.50 36.41           C  
ATOM   3503  N   LYS B  60      41.641  23.635  83.742  1.00 34.07           N  
ATOM   3504  CA  LYS B  60      42.645  22.919  83.013  1.00 33.02           C  
ATOM   3505  C   LYS B  60      43.990  23.526  83.357  1.00 35.93           C  
ATOM   3506  O   LYS B  60      44.208  24.722  83.146  1.00 38.26           O  
ATOM   3507  CB  LYS B  60      42.363  23.054  81.525  1.00 34.11           C  
ATOM   3508  CG  LYS B  60      43.461  22.548  80.620  1.00 39.92           C  
ATOM   3509  CD  LYS B  60      42.945  22.512  79.186  1.00 44.97           C  
ATOM   3510  CE  LYS B  60      44.002  22.917  78.185  1.00 56.11           C  
ATOM   3511  NZ  LYS B  60      43.514  22.668  76.779  1.00 64.71           N  
ATOM   3512  N   ILE B  61      44.884  22.691  83.868  1.00 30.36           N  
ATOM   3513  CA  ILE B  61      46.244  23.071  84.183  1.00 33.96           C  
ATOM   3514  C   ILE B  61      47.107  22.540  83.064  1.00 35.19           C  
ATOM   3515  O   ILE B  61      46.964  21.397  82.663  1.00 36.72           O  
ATOM   3516  CB  ILE B  61      46.684  22.424  85.501  1.00 38.87           C  
ATOM   3517  CG1 ILE B  61      45.696  22.779  86.615  1.00 37.15           C  
ATOM   3518  CG2 ILE B  61      48.101  22.840  85.876  1.00 34.71           C  
ATOM   3519  CD1 ILE B  61      45.976  22.037  87.910  1.00 44.41           C  
ATOM   3520  N   ASP B  62      47.966  23.387  82.522  1.00 36.32           N  
ATOM   3521  CA  ASP B  62      48.991  22.959  81.590  1.00 34.41           C  
ATOM   3522  C   ASP B  62      50.316  23.235  82.314  1.00 39.54           C  
ATOM   3523  O   ASP B  62      50.558  24.348  82.781  1.00 36.20           O  
ATOM   3524  CB  ASP B  62      48.907  23.747  80.275  1.00 37.46           C  
ATOM   3525  CG  ASP B  62      47.723  23.315  79.398  1.00 47.68           C  
ATOM   3526  OD1 ASP B  62      47.688  22.137  78.976  1.00 52.41           O  
ATOM   3527  OD2 ASP B  62      46.831  24.157  79.112  1.00 61.36           O  
ATOM   3528  N   VAL B  63      51.145  22.209  82.461  1.00 37.93           N  
ATOM   3529  CA  VAL B  63      52.461  22.384  83.057  1.00 40.00           C  
ATOM   3530  C   VAL B  63      53.519  21.627  82.243  1.00 34.38           C  
ATOM   3531  O   VAL B  63      53.397  20.422  81.990  1.00 37.38           O  
ATOM   3532  CB  VAL B  63      52.477  21.979  84.553  1.00 44.03           C  
ATOM   3533  CG1 VAL B  63      52.055  20.556  84.736  1.00 39.01           C  
ATOM   3534  CG2 VAL B  63      53.869  22.223  85.163  1.00 45.52           C  
ATOM   3535  N   ALA B  64      54.517  22.365  81.788  1.00 35.56           N  
ATOM   3536  CA  ALA B  64      55.659  21.780  81.109  1.00 37.39           C  
ATOM   3537  C   ALA B  64      56.660  21.306  82.169  1.00 37.63           C  
ATOM   3538  O   ALA B  64      56.963  22.027  83.118  1.00 36.02           O  
ATOM   3539  CB  ALA B  64      56.300  22.788  80.188  1.00 36.99           C  
ATOM   3540  N   ILE B  65      57.162  20.095  81.991  1.00 38.59           N  
ATOM   3541  CA  ILE B  65      58.077  19.464  82.935  1.00 41.98           C  
ATOM   3542  C   ILE B  65      59.138  18.662  82.175  1.00 44.59           C  
ATOM   3543  O   ILE B  65      59.018  18.435  80.965  1.00 39.99           O  
ATOM   3544  CB  ILE B  65      57.329  18.494  83.883  1.00 39.94           C  
ATOM   3545  CG1 ILE B  65      56.712  17.327  83.090  1.00 40.51           C  
ATOM   3546  CG2 ILE B  65      56.274  19.245  84.697  1.00 38.42           C  
ATOM   3547  CD1 ILE B  65      56.098  16.250  83.955  1.00 39.75           C  
ATOM   3548  N   ALA B  66      60.177  18.235  82.888  1.00 46.86           N  
ATOM   3549  CA  ALA B  66      61.137  17.277  82.339  1.00 44.10           C  
ATOM   3550  C   ALA B  66      60.573  15.870  82.453  1.00 38.83           C  
ATOM   3551  O   ALA B  66      59.776  15.584  83.347  1.00 43.29           O  
ATOM   3552  CB  ALA B  66      62.479  17.383  83.065  1.00 47.14           C  
ATOM   3553  N   ASP B  67      61.004  14.992  81.553  1.00 39.59           N  
ATOM   3554  CA  ASP B  67      60.577  13.595  81.529  1.00 44.81           C  
ATOM   3555  C   ASP B  67      60.818  12.875  82.870  1.00 51.47           C  
ATOM   3556  O   ASP B  67      60.039  11.987  83.241  1.00 48.71           O  
ATOM   3557  CB  ASP B  67      61.302  12.843  80.420  1.00 51.09           C  
ATOM   3558  CG  ASP B  67      60.656  11.508  80.092  1.00 58.93           C  
ATOM   3559  OD1 ASP B  67      59.495  11.255  80.485  1.00 69.62           O  
ATOM   3560  OD2 ASP B  67      61.316  10.701  79.410  1.00 77.54           O  
ATOM   3561  N   ASP B  68      61.863  13.277  83.596  1.00 48.92           N  
ATOM   3562  CA  ASP B  68      62.222  12.653  84.882  0.50 49.04           C  
ATOM   3564  C   ASP B  68      61.241  12.972  86.007  1.00 54.20           C  
ATOM   3565  O   ASP B  68      61.261  12.312  87.052  1.00 50.05           O  
ATOM   3566  CB  ASP B  68      63.636  13.066  85.317  0.50 51.35           C  
ATOM   3568  CG  ASP B  68      63.697  14.492  85.857  0.50 53.91           C  
ATOM   3570  OD1 ASP B  68      64.181  14.693  86.987  0.50 58.24           O  
ATOM   3572  OD2 ASP B  68      63.257  15.415  85.150  0.50 61.10           O  
ATOM   3574  N   GLN B  69      60.397  13.988  85.804  1.00 46.37           N  
ATOM   3575  CA  GLN B  69      59.421  14.402  86.805  1.00 46.02           C  
ATOM   3576  C   GLN B  69      58.042  13.792  86.569  1.00 36.65           C  
ATOM   3577  O   GLN B  69      57.162  13.863  87.441  1.00 43.44           O  
ATOM   3578  CB  GLN B  69      59.283  15.931  86.812  1.00 51.17           C  
ATOM   3579  CG  GLN B  69      60.570  16.735  87.059  1.00 53.70           C  
ATOM   3580  CD  GLN B  69      60.385  18.244  86.789  1.00 55.76           C  
ATOM   3581  OE1 GLN B  69      60.565  18.726  85.663  1.00 50.71           O  
ATOM   3582  NE2 GLN B  69      60.041  18.987  87.832  1.00 58.33           N  
ATOM   3583  N   LEU B  70      57.859  13.177  85.407  1.00 40.25           N  
ATOM   3584  CA  LEU B  70      56.521  12.783  84.928  1.00 43.33           C  
ATOM   3585  C   LEU B  70      55.761  11.858  85.871  1.00 45.64           C  
ATOM   3586  O   LEU B  70      54.631  12.153  86.279  1.00 42.27           O  
ATOM   3587  CB  LEU B  70      56.641  12.153  83.545  1.00 42.85           C  
ATOM   3588  CG  LEU B  70      55.335  11.621  82.964  1.00 38.96           C  
ATOM   3589  CD1 LEU B  70      54.216  12.669  82.986  1.00 30.90           C  
ATOM   3590  CD2 LEU B  70      55.571  11.082  81.576  1.00 40.11           C  
ATOM   3591  N   ASP B  71      56.395  10.757  86.261  1.00 44.70           N  
ATOM   3592  CA  ASP B  71      55.724   9.770  87.096  1.00 43.18           C  
ATOM   3593  C   ASP B  71      55.304  10.329  88.437  1.00 40.79           C  
ATOM   3594  O   ASP B  71      54.197  10.070  88.903  1.00 44.34           O  
ATOM   3595  CB  ASP B  71      56.630   8.558  87.300  1.00 50.44           C  
ATOM   3596  CG  ASP B  71      56.711   7.696  86.076  1.00 59.64           C  
ATOM   3597  OD1 ASP B  71      55.687   7.606  85.364  1.00 62.71           O  
ATOM   3598  OD2 ASP B  71      57.783   7.097  85.839  1.00 61.56           O  
ATOM   3599  N   GLU B  72      56.197  11.107  89.044  1.00 38.32           N  
ATOM   3600  CA  GLU B  72      55.926  11.776  90.305  1.00 42.27           C  
ATOM   3601  C   GLU B  72      54.814  12.817  90.173  1.00 43.87           C  
ATOM   3602  O   GLU B  72      53.969  12.935  91.058  1.00 40.60           O  
ATOM   3603  CB  GLU B  72      57.210  12.444  90.823  1.00 41.78           C  
ATOM   3604  CG  GLU B  72      57.067  13.136  92.183  1.00 48.10           C  
ATOM   3605  CD  GLU B  72      58.394  13.647  92.745  1.00 53.65           C  
ATOM   3606  OE1 GLU B  72      59.363  13.829  91.975  1.00 59.80           O  
ATOM   3607  OE2 GLU B  72      58.460  13.870  93.974  1.00 69.40           O  
ATOM   3608  N   VAL B  73      54.832  13.581  89.078  1.00 43.32           N  
ATOM   3609  CA  VAL B  73      53.803  14.594  88.817  1.00 38.66           C  
ATOM   3610  C   VAL B  73      52.452  13.908  88.755  1.00 32.97           C  
ATOM   3611  O   VAL B  73      51.531  14.291  89.479  1.00 41.27           O  
ATOM   3612  CB  VAL B  73      54.093  15.378  87.502  1.00 40.31           C  
ATOM   3613  CG1 VAL B  73      52.879  16.228  87.081  1.00 37.64           C  
ATOM   3614  CG2 VAL B  73      55.285  16.279  87.700  1.00 38.36           C  
ATOM   3615  N   ILE B  74      52.369  12.864  87.931  1.00 39.79           N  
ATOM   3616  CA  ILE B  74      51.145  12.087  87.765  1.00 43.06           C  
ATOM   3617  C   ILE B  74      50.618  11.620  89.123  1.00 46.19           C  
ATOM   3618  O   ILE B  74      49.447  11.836  89.454  1.00 46.67           O  
ATOM   3619  CB  ILE B  74      51.370  10.898  86.805  1.00 43.25           C  
ATOM   3620  CG1 ILE B  74      51.567  11.421  85.380  1.00 44.77           C  
ATOM   3621  CG2 ILE B  74      50.179   9.954  86.831  1.00 45.08           C  
ATOM   3622  CD1 ILE B  74      52.060  10.418  84.393  1.00 43.77           C  
ATOM   3623  N   ASP B  75      51.498  11.025  89.923  1.00 45.59           N  
ATOM   3624  CA  ASP B  75      51.115  10.531  91.243  1.00 45.34           C  
ATOM   3625  C   ASP B  75      50.670  11.636  92.187  1.00 45.02           C  
ATOM   3626  O   ASP B  75      49.605  11.531  92.801  1.00 45.56           O  
ATOM   3627  CB  ASP B  75      52.271   9.745  91.872  1.00 50.75           C  
ATOM   3628  CG  ASP B  75      52.498   8.413  91.186  1.00 58.32           C  
ATOM   3629  OD1 ASP B  75      51.578   7.965  90.462  1.00 52.06           O  
ATOM   3630  OD2 ASP B  75      53.587   7.812  91.372  1.00 59.36           O  
ATOM   3631  N   ILE B  76      51.467  12.696  92.288  1.00 45.17           N  
ATOM   3632  CA  ILE B  76      51.170  13.823  93.183  0.50 50.08           C  
ATOM   3634  C   ILE B  76      49.899  14.566  92.766  1.00 49.35           C  
ATOM   3635  O   ILE B  76      49.111  15.023  93.602  1.00 43.70           O  
ATOM   3636  CB  ILE B  76      52.371  14.822  93.243  0.50 53.79           C  
ATOM   3638  CG1 ILE B  76      53.279  14.506  94.436  0.50 55.79           C  
ATOM   3640  CG2 ILE B  76      51.892  16.267  93.328  0.50 58.58           C  
ATOM   3642  CD1 ILE B  76      52.673  14.847  95.793  0.50 58.33           C  
ATOM   3644  N   VAL B  77      49.696  14.701  91.462  1.00 48.40           N  
ATOM   3645  CA  VAL B  77      48.495  15.387  90.980  1.00 46.49           C  
ATOM   3646  C   VAL B  77      47.251  14.515  91.202  1.00 42.36           C  
ATOM   3647  O   VAL B  77      46.221  14.999  91.673  1.00 43.81           O  
ATOM   3648  CB  VAL B  77      48.650  15.811  89.505  1.00 48.61           C  
ATOM   3649  CG1 VAL B  77      47.323  16.263  88.925  1.00 45.27           C  
ATOM   3650  CG2 VAL B  77      49.708  16.910  89.410  1.00 38.87           C  
ATOM   3651  N   SER B  78      47.350  13.230  90.878  1.00 46.15           N  
ATOM   3652  CA  SER B  78      46.228  12.303  91.062  1.00 44.55           C  
ATOM   3653  C   SER B  78      45.700  12.306  92.500  1.00 46.88           C  
ATOM   3654  O   SER B  78      44.493  12.393  92.719  1.00 47.43           O  
ATOM   3655  CB  SER B  78      46.646  10.889  90.676  1.00 45.01           C  
ATOM   3656  OG  SER B  78      46.978  10.825  89.299  1.00 43.72           O  
ATOM   3657  N   LYS B  79      46.607  12.202  93.466  1.00 46.62           N  
ATOM   3658  CA  LYS B  79      46.252  12.251  94.888  0.50 52.02           C  
ATOM   3660  C   LYS B  79      45.552  13.555  95.246  1.00 51.32           C  
ATOM   3661  O   LYS B  79      44.494  13.555  95.885  1.00 49.10           O  
ATOM   3662  CB  LYS B  79      47.508  12.135  95.763  0.50 56.97           C  
ATOM   3664  CG  LYS B  79      48.069  10.735  95.913  0.50 61.70           C  
ATOM   3666  CD  LYS B  79      49.200  10.718  96.934  0.50 59.97           C  
ATOM   3668  CE  LYS B  79      49.520   9.313  97.402  0.50 62.46           C  
ATOM   3670  NZ  LYS B  79      50.474   9.328  98.547  0.50 65.57           N  
ATOM   3672  N   ALA B  80      46.164  14.667  94.838  1.00 48.37           N  
ATOM   3673  CA  ALA B  80      45.678  16.005  95.195  1.00 48.52           C  
ATOM   3674  C   ALA B  80      44.342  16.354  94.569  1.00 49.53           C  
ATOM   3675  O   ALA B  80      43.554  17.073  95.181  1.00 44.92           O  
ATOM   3676  CB  ALA B  80      46.721  17.068  94.830  1.00 48.30           C  
ATOM   3677  N   ALA B  81      44.089  15.853  93.356  1.00 43.55           N  
ATOM   3678  CA  ALA B  81      42.840  16.136  92.623  1.00 45.84           C  
ATOM   3679  C   ALA B  81      41.714  15.163  92.980  1.00 47.59           C  
ATOM   3680  O   ALA B  81      40.554  15.376  92.617  1.00 43.75           O  
ATOM   3681  CB  ALA B  81      43.099  16.079  91.127  1.00 43.43           C  
ATOM   3682  N   TYR B  82      42.063  14.084  93.677  1.00 47.21           N  
ATOM   3683  CA  TYR B  82      41.128  12.997  93.922  1.00 48.77           C  
ATOM   3684  C   TYR B  82      40.040  13.395  94.906  1.00 47.83           C  
ATOM   3685  O   TYR B  82      40.326  14.009  95.933  1.00 51.82           O  
ATOM   3686  CB  TYR B  82      41.882  11.770  94.456  1.00 55.16           C  
ATOM   3687  CG  TYR B  82      41.004  10.600  94.824  1.00 54.04           C  
ATOM   3688  CD1 TYR B  82      40.635   9.651  93.874  1.00 53.93           C  
ATOM   3689  CD2 TYR B  82      40.547  10.434  96.130  1.00 59.89           C  
ATOM   3690  CE1 TYR B  82      39.827   8.577  94.213  1.00 59.71           C  
ATOM   3691  CE2 TYR B  82      39.742   9.350  96.482  1.00 61.79           C  
ATOM   3692  CZ  TYR B  82      39.389   8.431  95.520  1.00 60.66           C  
ATOM   3693  OH  TYR B  82      38.595   7.369  95.859  1.00 63.03           O  
ATOM   3694  N   THR B  83      38.796  13.054  94.561  1.00 55.26           N  
ATOM   3695  CA  THR B  83      37.668  13.038  95.508  1.00 59.38           C  
ATOM   3696  C   THR B  83      36.920  11.690  95.508  1.00 63.21           C  
ATOM   3697  O   THR B  83      36.192  11.388  96.447  1.00 62.81           O  
ATOM   3698  CB  THR B  83      36.635  14.157  95.220  1.00 59.07           C  
ATOM   3699  OG1 THR B  83      35.792  13.777  94.122  1.00 58.12           O  
ATOM   3700  CG2 THR B  83      37.325  15.503  94.936  1.00 50.94           C  
ATOM   3701  N   GLY B  84      37.079  10.897  94.448  1.00 66.23           N  
ATOM   3702  CA  GLY B  84      36.408   9.607  94.343  1.00 64.68           C  
ATOM   3703  C   GLY B  84      35.038   9.677  93.690  1.00 64.29           C  
ATOM   3704  O   GLY B  84      34.496   8.640  93.302  1.00 60.28           O  
ATOM   3705  N   LYS B  85      34.473  10.883  93.573  1.00 62.62           N  
ATOM   3706  CA  LYS B  85      33.188  11.082  92.903  1.00 60.99           C  
ATOM   3707  C   LYS B  85      33.397  11.305  91.404  1.00 64.13           C  
ATOM   3708  O   LYS B  85      34.451  11.800  90.976  1.00 59.52           O  
ATOM   3709  CB  LYS B  85      32.441  12.269  93.511  1.00 65.08           C  
ATOM   3710  CG  LYS B  85      32.189  12.127  95.007  1.00 73.08           C  
ATOM   3711  CD  LYS B  85      31.197  13.163  95.537  1.00 75.17           C  
ATOM   3712  CE  LYS B  85      29.764  12.853  95.118  1.00 81.64           C  
ATOM   3713  NZ  LYS B  85      28.757  13.560  95.980  1.00 81.41           N  
ATOM   3714  N   ILE B  86      32.390  10.948  90.609  1.00 55.75           N  
ATOM   3715  CA  ILE B  86      32.503  11.051  89.155  1.00 60.72           C  
ATOM   3716  C   ILE B  86      32.775  12.510  88.797  1.00 57.32           C  
ATOM   3717  O   ILE B  86      32.175  13.415  89.382  1.00 56.22           O  
ATOM   3718  CB  ILE B  86      31.234  10.585  88.410  1.00 60.93           C  
ATOM   3719  CG1 ILE B  86      30.832   9.165  88.818  1.00 67.94           C  
ATOM   3720  CG2 ILE B  86      31.451  10.638  86.896  1.00 61.48           C  
ATOM   3721  CD1 ILE B  86      31.860   8.103  88.486  1.00 70.11           C  
ATOM   3722  N   GLY B  87      33.703  12.728  87.867  1.00 56.22           N  
ATOM   3723  CA  GLY B  87      34.007  14.077  87.376  1.00 55.32           C  
ATOM   3724  C   GLY B  87      35.351  14.619  87.807  1.00 48.76           C  
ATOM   3725  O   GLY B  87      35.673  15.758  87.474  1.00 47.64           O  
ATOM   3726  N   ASP B  88      36.109  13.836  88.585  1.00 43.86           N  
ATOM   3727  CA  ASP B  88      37.446  14.232  89.054  1.00 49.51           C  
ATOM   3728  C   ASP B  88      38.423  14.603  87.936  1.00 45.90           C  
ATOM   3729  O   ASP B  88      39.309  15.420  88.134  1.00 49.56           O  
ATOM   3730  CB  ASP B  88      38.074  13.123  89.893  1.00 49.59           C  
ATOM   3731  CG  ASP B  88      37.532  13.082  91.301  1.00 54.05           C  
ATOM   3732  OD1 ASP B  88      36.572  13.830  91.612  1.00 56.93           O  
ATOM   3733  OD2 ASP B  88      38.085  12.300  92.099  1.00 47.76           O  
ATOM   3734  N   GLY B  89      38.270  13.974  86.779  1.00 43.38           N  
ATOM   3735  CA  GLY B  89      38.943  14.419  85.572  1.00 41.31           C  
ATOM   3736  C   GLY B  89      40.084  13.548  85.115  1.00 44.30           C  
ATOM   3737  O   GLY B  89      40.223  12.385  85.523  1.00 40.70           O  
ATOM   3738  N   LYS B  90      40.922  14.144  84.270  1.00 34.64           N  
ATOM   3739  CA  LYS B  90      41.859  13.402  83.476  1.00 34.71           C  
ATOM   3740  C   LYS B  90      43.222  14.033  83.543  1.00 35.12           C  
ATOM   3741  O   LYS B  90      43.351  15.251  83.737  1.00 36.17           O  
ATOM   3742  CB  LYS B  90      41.445  13.392  81.997  1.00 42.60           C  
ATOM   3743  CG  LYS B  90      39.986  13.136  81.706  1.00 42.80           C  
ATOM   3744  CD  LYS B  90      39.595  11.702  81.914  1.00 48.94           C  
ATOM   3745  CE  LYS B  90      38.131  11.516  81.517  1.00 52.01           C  
ATOM   3746  NZ  LYS B  90      37.544  10.283  82.064  1.00 45.31           N  
ATOM   3747  N   ILE B  91      44.230  13.202  83.342  1.00 32.31           N  
ATOM   3748  CA  ILE B  91      45.582  13.686  83.016  1.00 35.87           C  
ATOM   3749  C   ILE B  91      45.915  13.270  81.590  1.00 37.16           C  
ATOM   3750  O   ILE B  91      45.666  12.125  81.208  1.00 39.60           O  
ATOM   3751  CB  ILE B  91      46.647  13.138  84.005  1.00 35.48           C  
ATOM   3752  CG1 ILE B  91      46.305  13.550  85.442  1.00 39.03           C  
ATOM   3753  CG2 ILE B  91      48.012  13.647  83.644  1.00 34.53           C  
ATOM   3754  CD1 ILE B  91      47.199  12.919  86.473  1.00 44.18           C  
ATOM   3755  N   PHE B  92      46.420  14.216  80.798  1.00 34.40           N  
ATOM   3756  CA  PHE B  92      46.951  13.960  79.459  1.00 34.28           C  
ATOM   3757  C   PHE B  92      48.441  14.312  79.433  1.00 34.21           C  
ATOM   3758  O   PHE B  92      48.872  15.274  80.068  1.00 33.54           O  
ATOM   3759  CB  PHE B  92      46.262  14.809  78.390  1.00 40.88           C  
ATOM   3760  CG  PHE B  92      44.766  14.719  78.409  1.00 40.33           C  
ATOM   3761  CD1 PHE B  92      44.129  13.494  78.438  1.00 47.83           C  
ATOM   3762  CD2 PHE B  92      43.997  15.852  78.354  1.00 53.42           C  
ATOM   3763  CE1 PHE B  92      42.743  13.407  78.454  1.00 43.45           C  
ATOM   3764  CE2 PHE B  92      42.610  15.764  78.368  1.00 55.32           C  
ATOM   3765  CZ  PHE B  92      41.994  14.530  78.418  1.00 46.63           C  
ATOM   3766  N   VAL B  93      49.220  13.534  78.690  1.00 34.63           N  
ATOM   3767  CA  VAL B  93      50.637  13.793  78.546  1.00 32.71           C  
ATOM   3768  C   VAL B  93      50.998  13.758  77.076  1.00 33.27           C  
ATOM   3769  O   VAL B  93      50.605  12.846  76.362  1.00 36.93           O  
ATOM   3770  CB  VAL B  93      51.491  12.782  79.315  1.00 37.82           C  
ATOM   3771  CG1 VAL B  93      52.959  13.189  79.253  1.00 34.49           C  
ATOM   3772  CG2 VAL B  93      51.015  12.696  80.757  1.00 36.42           C  
ATOM   3773  N   ALA B  94      51.736  14.774  76.642  1.00 34.94           N  
ATOM   3774  CA  ALA B  94      52.207  14.881  75.278  1.00 38.39           C  
ATOM   3775  C   ALA B  94      53.665  15.299  75.313  1.00 42.32           C  
ATOM   3776  O   ALA B  94      54.121  15.848  76.312  1.00 38.49           O  
ATOM   3777  CB  ALA B  94      51.385  15.922  74.536  1.00 40.16           C  
ATOM   3778  N   GLU B  95      54.385  15.032  74.230  1.00 42.45           N  
ATOM   3779  CA  GLU B  95      55.774  15.478  74.091  1.00 49.98           C  
ATOM   3780  C   GLU B  95      55.847  16.947  73.726  1.00 44.55           C  
ATOM   3781  O   GLU B  95      55.039  17.423  72.934  1.00 43.18           O  
ATOM   3782  CB  GLU B  95      56.492  14.703  72.972  1.00 58.02           C  
ATOM   3783  CG  GLU B  95      56.848  13.268  73.314  1.00 68.05           C  
ATOM   3784  CD  GLU B  95      58.214  12.833  72.769  1.00 71.44           C  
ATOM   3785  OE1 GLU B  95      58.677  13.393  71.747  1.00 78.72           O  
ATOM   3786  OE2 GLU B  95      58.825  11.924  73.378  1.00 78.57           O  
ATOM   3787  N   LEU B  96      56.820  17.656  74.291  1.00 40.89           N  
ATOM   3788  CA  LEU B  96      57.165  18.993  73.828  1.00 47.81           C  
ATOM   3789  C   LEU B  96      58.489  18.897  73.115  1.00 51.94           C  
ATOM   3790  O   LEU B  96      59.462  18.417  73.690  1.00 51.00           O  
ATOM   3791  CB  LEU B  96      57.322  19.974  74.985  1.00 46.83           C  
ATOM   3792  CG  LEU B  96      56.039  20.528  75.582  1.00 49.08           C  
ATOM   3793  CD1 LEU B  96      56.413  21.524  76.656  1.00 50.85           C  
ATOM   3794  CD2 LEU B  96      55.131  21.149  74.492  1.00 45.31           C  
ATOM   3795  N   GLN B  97      58.523  19.349  71.868  1.00 44.96           N  
ATOM   3796  CA  GLN B  97      59.755  19.360  71.097  1.00 48.93           C  
ATOM   3797  C   GLN B  97      60.676  20.461  71.574  1.00 45.31           C  
ATOM   3798  O   GLN B  97      61.888  20.276  71.607  1.00 50.44           O  
ATOM   3799  CB  GLN B  97      59.461  19.515  69.616  1.00 49.58           C  
ATOM   3800  CG  GLN B  97      58.680  18.350  69.056  1.00 57.16           C  
ATOM   3801  CD  GLN B  97      58.851  18.207  67.556  1.00 62.71           C  
ATOM   3802  OE1 GLN B  97      58.773  19.190  66.816  1.00 71.85           O  
ATOM   3803  NE2 GLN B  97      59.093  16.978  67.098  1.00 68.19           N  
ATOM   3804  N   ARG B  98      60.096  21.588  71.969  1.00 42.64           N  
ATOM   3805  CA  ARG B  98      60.859  22.723  72.461  1.00 45.35           C  
ATOM   3806  C   ARG B  98      60.082  23.523  73.489  1.00 43.82           C  
ATOM   3807  O   ARG B  98      58.849  23.636  73.422  1.00 38.74           O  
ATOM   3808  CB  ARG B  98      61.283  23.622  71.291  1.00 46.93           C  
ATOM   3809  CG  ARG B  98      62.580  23.165  70.633  1.00 61.52           C  
ATOM   3810  CD  ARG B  98      62.485  23.024  69.133  1.00 70.06           C  
ATOM   3811  NE  ARG B  98      62.830  24.271  68.463  1.00 75.06           N  
ATOM   3812  CZ  ARG B  98      63.342  24.366  67.235  1.00 74.51           C  
ATOM   3813  NH1 ARG B  98      63.583  23.287  66.498  1.00 75.14           N  
ATOM   3814  NH2 ARG B  98      63.615  25.560  66.738  1.00 71.95           N  
ATOM   3815  N   VAL B  99      60.831  24.039  74.457  1.00 40.28           N  
ATOM   3816  CA  VAL B  99      60.331  24.932  75.481  1.00 43.60           C  
ATOM   3817  C   VAL B  99      61.352  26.053  75.587  1.00 44.07           C  
ATOM   3818  O   VAL B  99      62.532  25.781  75.836  1.00 42.32           O  
ATOM   3819  CB  VAL B  99      60.215  24.217  76.833  1.00 44.49           C  
ATOM   3820  CG1 VAL B  99      59.767  25.198  77.908  1.00 47.72           C  
ATOM   3821  CG2 VAL B  99      59.263  23.025  76.717  1.00 50.26           C  
ATOM   3822  N   ILE B 100      60.924  27.293  75.350  1.00 42.70           N  
ATOM   3823  CA  ILE B 100      61.828  28.448  75.388  1.00 41.34           C  
ATOM   3824  C   ILE B 100      61.323  29.507  76.352  1.00 49.11           C  
ATOM   3825  O   ILE B 100      60.128  29.792  76.386  1.00 47.45           O  
ATOM   3826  CB  ILE B 100      61.965  29.100  74.014  1.00 48.51           C  
ATOM   3827  CG1 ILE B 100      62.525  28.101  73.000  1.00 49.89           C  
ATOM   3828  CG2 ILE B 100      62.864  30.351  74.085  1.00 41.33           C  
ATOM   3829  CD1 ILE B 100      62.265  28.483  71.587  1.00 49.09           C  
ATOM   3830  N   ARG B 101      62.235  30.082  77.136  1.00 40.12           N  
ATOM   3831  CA  ARG B 101      61.933  31.224  77.987  1.00 41.03           C  
ATOM   3832  C   ARG B 101      62.216  32.461  77.157  1.00 41.97           C  
ATOM   3833  O   ARG B 101      63.362  32.710  76.802  1.00 48.60           O  
ATOM   3834  CB  ARG B 101      62.796  31.228  79.262  1.00 42.63           C  
ATOM   3835  CG  ARG B 101      62.240  32.177  80.327  1.00 49.07           C  
ATOM   3836  CD  ARG B 101      63.241  32.565  81.390  1.00 50.16           C  
ATOM   3837  NE  ARG B 101      63.856  31.396  81.994  1.00 55.53           N  
ATOM   3838  CZ  ARG B 101      63.325  30.674  82.974  1.00 50.83           C  
ATOM   3839  NH1 ARG B 101      62.138  30.965  83.486  1.00 49.89           N  
ATOM   3840  NH2 ARG B 101      63.992  29.638  83.433  1.00 54.71           N  
ATOM   3841  N   ILE B 102      61.169  33.222  76.835  1.00 44.30           N  
ATOM   3842  CA  ILE B 102      61.265  34.341  75.891  1.00 45.66           C  
ATOM   3843  C   ILE B 102      62.313  35.377  76.323  1.00 51.61           C  
ATOM   3844  O   ILE B 102      63.076  35.894  75.507  1.00 63.88           O  
ATOM   3845  CB  ILE B 102      59.889  35.070  75.736  1.00 45.45           C  
ATOM   3846  CG1 ILE B 102      58.869  34.204  74.979  1.00 39.46           C  
ATOM   3847  CG2 ILE B 102      60.047  36.404  74.980  1.00 42.54           C  
ATOM   3848  CD1 ILE B 102      57.396  34.652  75.201  1.00 37.92           C  
ATOM   3849  N   ARG B 103      62.306  35.676  77.617  1.00 54.65           N  
ATOM   3850  CA  ARG B 103      63.141  36.708  78.220  1.00 58.13           C  
ATOM   3851  C   ARG B 103      64.638  36.450  78.047  1.00 59.67           C  
ATOM   3852  O   ARG B 103      65.386  37.352  77.684  1.00 62.92           O  
ATOM   3853  CB  ARG B 103      62.794  36.788  79.708  1.00 54.46           C  
ATOM   3854  CG  ARG B 103      63.670  37.695  80.515  1.00 65.20           C  
ATOM   3855  CD  ARG B 103      62.984  38.081  81.817  1.00 66.89           C  
ATOM   3856  NE  ARG B 103      62.500  36.926  82.578  1.00 66.09           N  
ATOM   3857  CZ  ARG B 103      63.271  36.100  83.286  1.00 70.04           C  
ATOM   3858  NH1 ARG B 103      64.594  36.258  83.333  1.00 72.76           N  
ATOM   3859  NH2 ARG B 103      62.719  35.101  83.954  1.00 69.55           N  
ATOM   3860  N   THR B 104      65.055  35.211  78.309  1.00 59.58           N  
ATOM   3861  CA  THR B 104      66.476  34.825  78.338  1.00 55.79           C  
ATOM   3862  C   THR B 104      66.929  33.956  77.172  1.00 54.86           C  
ATOM   3863  O   THR B 104      68.128  33.818  76.947  1.00 60.20           O  
ATOM   3864  CB  THR B 104      66.768  33.991  79.576  1.00 54.95           C  
ATOM   3865  OG1 THR B 104      65.998  32.784  79.510  1.00 52.69           O  
ATOM   3866  CG2 THR B 104      66.415  34.760  80.845  1.00 55.31           C  
ATOM   3867  N   GLY B 105      65.990  33.329  76.468  1.00 50.33           N  
ATOM   3868  CA  GLY B 105      66.316  32.369  75.423  1.00 46.29           C  
ATOM   3869  C   GLY B 105      66.746  30.996  75.935  1.00 43.22           C  
ATOM   3870  O   GLY B 105      67.082  30.126  75.151  1.00 43.78           O  
ATOM   3871  N   GLU B 106      66.706  30.780  77.242  1.00 45.17           N  
ATOM   3872  CA  GLU B 106      67.023  29.467  77.778  1.00 49.17           C  
ATOM   3873  C   GLU B 106      66.048  28.455  77.203  1.00 49.83           C  
ATOM   3874  O   GLU B 106      64.905  28.804  76.882  1.00 48.11           O  
ATOM   3875  CB  GLU B 106      66.924  29.473  79.288  1.00 50.48           C  
ATOM   3876  CG  GLU B 106      68.030  30.269  79.968  1.00 58.95           C  
ATOM   3877  CD  GLU B 106      67.689  30.604  81.411  1.00 60.23           C  
ATOM   3878  OE1 GLU B 106      66.894  31.548  81.635  1.00 65.11           O  
ATOM   3879  OE2 GLU B 106      68.223  29.928  82.316  1.00 66.68           O  
ATOM   3880  N   ALA B 107      66.503  27.212  77.090  1.00 43.47           N  
ATOM   3881  CA  ALA B 107      65.713  26.135  76.520  1.00 46.91           C  
ATOM   3882  C   ALA B 107      65.529  24.970  77.512  1.00 54.71           C  
ATOM   3883  O   ALA B 107      66.279  24.831  78.490  1.00 49.03           O  
ATOM   3884  CB  ALA B 107      66.360  25.650  75.237  1.00 51.70           C  
ATOM   3885  N   ASP B 108      64.496  24.165  77.261  1.00 50.75           N  
ATOM   3886  CA  ASP B 108      64.235  22.941  78.006  1.00 53.71           C  
ATOM   3887  C   ASP B 108      64.246  23.170  79.508  1.00 55.19           C  
ATOM   3888  O   ASP B 108      63.598  24.104  79.980  1.00 47.87           O  
ATOM   3889  CB  ASP B 108      65.227  21.868  77.573  1.00 60.39           C  
ATOM   3890  CG  ASP B 108      65.278  21.720  76.079  1.00 65.42           C  
ATOM   3891  OD1 ASP B 108      64.244  21.977  75.431  1.00 72.33           O  
ATOM   3892  OD2 ASP B 108      66.350  21.366  75.545  1.00 77.72           O  
ATOM   3893  N   GLU B 109      64.971  22.342  80.265  1.00 53.29           N  
ATOM   3894  CA  GLU B 109      64.900  22.400  81.721  1.00 54.22           C  
ATOM   3895  C   GLU B 109      65.224  23.802  82.221  1.00 45.96           C  
ATOM   3896  O   GLU B 109      64.616  24.291  83.179  1.00 52.46           O  
ATOM   3897  CB  GLU B 109      65.838  21.364  82.364  1.00 66.59           C  
ATOM   3898  CG  GLU B 109      65.458  19.894  82.100  1.00 68.81           C  
ATOM   3899  CD  GLU B 109      66.014  19.330  80.789  1.00 72.38           C  
ATOM   3900  OE1 GLU B 109      66.630  20.090  80.003  1.00 68.96           O  
ATOM   3901  OE2 GLU B 109      65.831  18.116  80.544  1.00 74.15           O  
ATOM   3902  N   ALA B 110      66.156  24.464  81.539  1.00 48.49           N  
ATOM   3903  CA  ALA B 110      66.568  25.819  81.903  1.00 48.92           C  
ATOM   3904  C   ALA B 110      65.518  26.888  81.606  1.00 49.54           C  
ATOM   3905  O   ALA B 110      65.661  28.003  82.077  1.00 49.43           O  
ATOM   3906  CB  ALA B 110      67.880  26.179  81.202  1.00 52.29           C  
ATOM   3907  N   ALA B 111      64.492  26.565  80.810  1.00 49.00           N  
ATOM   3908  CA  ALA B 111      63.403  27.516  80.506  1.00 44.79           C  
ATOM   3909  C   ALA B 111      62.274  27.521  81.541  1.00 47.24           C  
ATOM   3910  O   ALA B 111      61.342  28.320  81.428  1.00 47.23           O  
ATOM   3911  CB  ALA B 111      62.819  27.213  79.140  1.00 43.84           C  
ATOM   3912  N   LEU B 112      62.348  26.639  82.537  1.00 49.54           N  
ATOM   3913  CA  LEU B 112      61.259  26.455  83.497  1.00 56.14           C  
ATOM   3914  C   LEU B 112      61.613  27.016  84.883  1.00 64.05           C  
ATOM   3915  O   LEU B 112      62.700  27.536  85.128  1.00 63.75           O  
ATOM   3916  CB  LEU B 112      60.923  24.964  83.613  1.00 61.13           C  
ATOM   3917  CG  LEU B 112      60.730  24.217  82.293  1.00 63.71           C  
ATOM   3918  CD1 LEU B 112      60.603  22.724  82.533  1.00 65.54           C  
ATOM   3919  CD2 LEU B 112      59.515  24.764  81.558  1.00 68.46           C  
ATOM   3920  OXT LEU B 112      60.811  26.972  85.819  1.00 66.53           O  
TER    3921      LEU B 112                                                      
END
MOLECULE T0505_85_200.pdb
ATOM    667  N   LYS    85      33.420  20.423  80.766  1.00 22.93          
ATOM    668  CA  LYS    85      33.724  19.846  82.086  0.50 23.87          
ATOM    670  C   LYS    85      34.910  20.625  82.634  1.00 23.56          
ATOM    671  O   LYS    85      35.825  20.950  81.895  1.00 23.95          
ATOM    672  CB  LYS    85      34.083  18.357  81.996  0.50 23.73          
ATOM    674  CG  LYS    85      32.957  17.384  82.336  0.50 24.82          
ATOM    676  CD  LYS    85      33.505  15.997  82.769  0.50 24.33          
ATOM    678  CE  LYS    85      33.555  15.811  84.294  0.50 25.99          
ATOM    680  NZ  LYS    85      33.861  14.401  84.745  0.50 26.26          
ATOM    682  N   ARG    86      34.903  20.903  83.919  1.00 23.57          
ATOM    683  CA  ARG    86      36.034  21.610  84.495  1.00 23.90          
ATOM    684  C   ARG    86      36.348  21.086  85.880  1.00 24.29          
ATOM    685  O   ARG    86      35.484  20.487  86.553  1.00 23.66          
ATOM    686  CB  ARG    86      35.786  23.128  84.490  1.00 24.99          
ATOM    687  CG  ARG    86      34.591  23.615  85.302  1.00 25.07          
ATOM    688  CD  ARG    86      34.303  25.123  85.038  1.00 25.14          
ATOM    689  NE  ARG    86      33.702  25.398  83.719  1.00 25.31          
ATOM    690  CZ  ARG    86      34.236  26.201  82.789  1.00 26.67          
ATOM    691  NH1 ARG    86      35.374  26.830  83.012  1.00 26.27          
ATOM    692  NH2 ARG    86      33.627  26.379  81.614  1.00 26.28          
ATOM    693  N   ILE    87      37.591  21.304  86.302  1.00 23.22          
ATOM    694  CA  ILE    87      38.047  20.923  87.641  1.00 23.10          
ATOM    695  C   ILE    87      37.449  21.940  88.647  1.00 24.10          
ATOM    696  O   ILE    87      37.432  23.160  88.378  1.00 24.17          
ATOM    697  CB  ILE    87      39.604  20.913  87.674  1.00 22.67          
ATOM    698  CG1 ILE    87      40.155  19.959  86.594  1.00 21.94          
ATOM    699  CG2 ILE    87      40.155  20.545  89.091  1.00 22.37          
ATOM    700  CD  ILE    87      41.673  20.106  86.366  1.00 24.37          
ATOM    701  N   SER    88      36.896  21.460  89.764  1.00 23.35          
ATOM    702  CA  SER    88      36.274  22.367  90.747  1.00 23.33          
ATOM    703  C   SER    88      37.265  23.407  91.232  1.00 23.89          
ATOM    704  O   SER    88      38.486  23.190  91.140  1.00 22.80          
ATOM    705  CB  SER    88      35.722  21.610  91.964  1.00 23.72          
ATOM    706  OG  SER    88      36.795  21.101  92.744  1.00 23.82          
ATOM    707  N   ASP    89      36.763  24.531  91.735  1.00 23.87          
ATOM    708  CA  ASP    89      37.707  25.521  92.262  1.00 26.50          
ATOM    709  C   ASP    89      38.550  25.003  93.433  1.00 25.69          
ATOM    710  O   ASP    89      39.761  25.286  93.514  1.00 24.91          
ATOM    711  CB  ASP    89      37.099  26.927  92.521  1.00 27.17          
ATOM    712  CG  ASP    89      35.754  26.920  93.224  1.00 34.53          
ATOM    713  OD1 ASP    89      35.381  25.939  93.922  1.00 37.65          
ATOM    714  OD2 ASP    89      35.055  27.972  93.088  1.00 39.94          
ATOM    715  N   ASP    90      37.930  24.213  94.312  1.00 25.37          
ATOM    716  CA  ASP    90      38.670  23.688  95.451  0.50 25.31          
ATOM    718  C   ASP    90      39.719  22.673  95.024  1.00 24.86          
ATOM    719  O   ASP    90      40.851  22.735  95.504  1.00 24.95          
ATOM    720  CB  ASP    90      37.719  23.169  96.525  0.50 25.14          
ATOM    722  CG  ASP    90      36.780  24.263  97.018  0.50 26.90          
ATOM    724  OD1 ASP    90      37.266  25.386  97.275  0.50 26.76          
ATOM    726  OD2 ASP    90      35.561  24.010  97.107  0.50 28.34          
ATOM    728  N   HSD    91      39.370  21.771  94.104  1.00 24.96          
ATOM    729  CA  HSD    91      40.356  20.826  93.562  1.00 24.21          
ATOM    730  C   HSD    91      41.470  21.540  92.799  1.00 24.77          
ATOM    731  O   HSD    91      42.640  21.158  92.917  1.00 24.87          
ATOM    732  CB  HSD    91      39.685  19.793  92.654  1.00 24.69          
ATOM    733  CG  HSD    91      38.908  18.747  93.410  1.00 26.40          
ATOM    734  ND1 HSD    91      37.982  17.920  92.808  1.00 28.55          
ATOM    735  CD2 HSD    91      38.933  18.395  94.718  1.00 28.91          
ATOM    736  CE1 HSD    91      37.464  17.109  93.720  1.00 28.06          
ATOM    737  NE2 HSD    91      38.034  17.367  94.881  1.00 27.01          
ATOM    738  N   THR    92      41.117  22.567  92.019  1.00 23.57          
ATOM    739  CA  THR    92      42.132  23.372  91.320  1.00 23.55          
ATOM    740  C   THR    92      43.130  23.966  92.321  1.00 23.89          
ATOM    741  O   THR    92      44.352  23.837  92.148  1.00 23.39          
ATOM    742  CB  THR    92      41.464  24.477  90.469  1.00 24.44          
ATOM    743  OG1 THR    92      40.688  23.848  89.434  1.00 23.71          
ATOM    744  CG2 THR    92      42.491  25.426  89.820  1.00 23.99          
ATOM    745  N   PHE    93      42.619  24.555  93.399  1.00 23.98          
ATOM    746  CA  PHE    93      43.498  25.117  94.433  1.00 24.53          
ATOM    747  C   PHE    93      44.425  24.043  95.046  1.00 24.75          
ATOM    748  O   PHE    93      45.644  24.257  95.175  1.00 24.62          
ATOM    749  CB  PHE    93      42.656  25.808  95.518  1.00 24.20          
ATOM    750  CG  PHE    93      43.456  26.295  96.690  1.00 24.55          
ATOM    751  CD1 PHE    93      44.079  27.546  96.644  1.00 23.25          
ATOM    752  CD2 PHE    93      43.582  25.508  97.839  1.00 24.77          
ATOM    753  CE1 PHE    93      44.795  28.026  97.744  1.00 25.66          
ATOM    754  CE2 PHE    93      44.321  25.968  98.927  1.00 28.70          
ATOM    755  CZ  PHE    93      44.926  27.235  98.874  1.00 27.67          
ATOM    756  N   ASN    94      43.849  22.899  95.417  1.00 24.28          
ATOM    757  CA  ASN    94      44.615  21.821  96.053  1.00 25.00          
ATOM    758  C   ASN    94      45.670  21.242  95.113  1.00 24.16          
ATOM    759  O   ASN    94      46.787  20.912  95.540  1.00 23.37          
ATOM    760  CB  ASN    94      43.675  20.691  96.523  1.00 24.95          
ATOM    761  CG  ASN    94      42.833  21.082  97.717  1.00 28.63          
ATOM    762  OD1 ASN    94      43.170  21.988  98.466  1.00 30.96          
ATOM    763  ND2 ASN    94      41.726  20.374  97.908  1.00 33.96          
ATOM    764  N   ILE    95      45.301  21.098  93.838  1.00 23.11          
ATOM    765  CA  ILE    95      46.232  20.615  92.833  1.00 23.14          
ATOM    766  C   ILE    95      47.380  21.595  92.644  1.00 23.25          
ATOM    767  O   ILE    95      48.550  21.180  92.642  1.00 23.42          
ATOM    768  CB  ILE    95      45.539  20.303  91.496  1.00 22.15          
ATOM    769  CG1 ILE    95      44.625  19.059  91.666  1.00 23.25          
ATOM    770  CG2 ILE    95      46.600  20.110  90.374  1.00 22.80          
ATOM    771  CD  ILE    95      43.608  18.920  90.526  1.00 22.98          
ATOM    772  N   VAL    96      47.060  22.888  92.545  1.00 22.69          
ATOM    773  CA  VAL    96      48.100  23.906  92.442  1.00 23.28          
ATOM    774  C   VAL    96      49.068  23.864  93.627  1.00 24.25          
ATOM    775  O   VAL    96      50.295  23.989  93.454  1.00 24.61          
ATOM    776  CB  VAL    96      47.488  25.317  92.278  1.00 23.65          
ATOM    777  CG1 VAL    96      48.516  26.412  92.512  1.00 24.35          
ATOM    778  CG2 VAL    96      46.859  25.471  90.874  1.00 23.57          
ATOM    779  N   GLN    97      48.541  23.709  94.838  1.00 25.36          
ATOM    780  CA  GLN    97      49.424  23.624  96.016  1.00 25.73          
ATOM    781  C   GLN    97      50.437  22.476  95.923  1.00 26.30          
ATOM    782  O   GLN    97      51.621  22.663  96.230  1.00 25.59          
ATOM    783  CB  GLN    97      48.607  23.465  97.284  1.00 26.58          
ATOM    784  CG  GLN    97      47.941  24.729  97.740  1.00 29.53          
ATOM    785  CD  GLN    97      47.556  24.621  99.202  1.00 34.30          
ATOM    786  OE1 GLN    97      46.953  23.630  99.634  1.00 38.22          
ATOM    787  NE2 GLN    97      47.909  25.625  99.965  1.00 33.95          
ATOM    788  N   VAL    98      49.975  21.294  95.507  1.00 25.44          
ATOM    789  CA  VAL    98      50.871  20.140  95.297  1.00 25.65          
ATOM    790  C   VAL    98      51.943  20.420  94.232  1.00 25.69          
ATOM    791  O   VAL    98      53.131  20.180  94.468  1.00 25.67          
ATOM    792  CB  VAL    98      50.074  18.830  94.944  1.00 25.00          
ATOM    793  CG1 VAL    98      51.016  17.668  94.604  1.00 25.34          
ATOM    794  CG2 VAL    98      49.144  18.437  96.107  1.00 25.98          
ATOM    795  N   LEU    99      51.514  20.923  93.074  1.00 24.55          
ATOM    796  CA  LEU    99      52.410  21.250  91.964  1.00 24.75          
ATOM    797  C   LEU    99      53.432  22.319  92.341  1.00 24.75          
ATOM    798  O   LEU    99      54.538  22.322  91.821  1.00 24.16          
ATOM    799  CB  LEU    99      51.590  21.751  90.771  1.00 24.18          
ATOM    800  CG  LEU    99      50.646  20.756  90.086  1.00 23.25          
ATOM    801  CD1 LEU    99      49.801  21.461  89.000  1.00 25.60          
ATOM    802  CD2 LEU    99      51.398  19.593  89.490  1.00 26.40          
ATOM    803  N   GLU   100      53.051  23.241  93.225  1.00 24.86          
ATOM    804  CA  GLU   100      53.987  24.257  93.719  1.00 25.62          
ATOM    805  C   GLU   100      55.195  23.703  94.483  1.00 25.99          
ATOM    806  O   GLU   100      56.229  24.373  94.588  1.00 26.50          
ATOM    807  CB  GLU   100      53.240  25.309  94.555  1.00 25.45          
ATOM    808  CG  GLU   100      52.480  26.276  93.656  1.00 25.86          
ATOM    809  CD  GLU   100      51.646  27.259  94.435  1.00 29.79          
ATOM    810  OE1 GLU   100      51.422  27.015  95.630  1.00 29.23          
ATOM    811  OE2 GLU   100      51.205  28.279  93.859  1.00 28.43          
ATOM    812  N   SER   101      55.070  22.491  95.008  1.00 26.91          
ATOM    813  CA  SER   101      56.191  21.837  95.686  1.00 27.88          
ATOM    814  C   SER   101      57.197  21.199  94.694  1.00 28.12          
ATOM    815  O   SER   101      58.288  20.756  95.101  1.00 27.43          
ATOM    816  CB  SER   101      55.663  20.827  96.693  1.00 27.76          
ATOM    817  OG  SER   101      55.126  19.698  96.013  1.00 30.42          
ATOM    818  N   TYR   102      56.848  21.171  93.404  1.00 27.81          
ATOM    819  CA  TYR   102      57.752  20.646  92.362  1.00 28.47          
ATOM    820  C   TYR   102      58.315  21.769  91.498  1.00 28.53          
ATOM    821  O   TYR   102      57.724  22.846  91.414  1.00 28.15          
ATOM    822  CB  TYR   102      57.016  19.689  91.419  1.00 29.44          
ATOM    823  CG  TYR   102      56.582  18.380  91.998  1.00 29.79          
ATOM    824  CD1 TYR   102      57.393  17.245  91.865  1.00 32.75          
ATOM    825  CD2 TYR   102      55.348  18.247  92.630  1.00 30.53          
ATOM    826  CE1 TYR   102      56.993  16.017  92.375  1.00 34.59          
ATOM    827  CE2 TYR   102      54.938  17.025  93.160  1.00 32.33          
ATOM    828  CZ  TYR   102      55.766  15.919  93.028  1.00 33.34          
ATOM    829  OH  TYR   102      55.399  14.694  93.536  1.00 34.62          
ATOM    830  N   GLN   103      59.435  21.501  90.825  1.00 27.96          
ATOM    831  CA  GLN   103      60.007  22.432  89.843  1.00 28.01          
ATOM    832  C   GLN   103      59.215  22.347  88.538  1.00 27.48          
ATOM    833  O   GLN   103      59.582  21.623  87.593  1.00 26.24          
ATOM    834  CB  GLN   103      61.508  22.149  89.606  1.00 28.39          
ATOM    835  CG  GLN   103      62.260  23.245  88.794  1.00 31.88          
ATOM    836  CD  GLN   103      62.241  24.634  89.443  1.00 35.99          
ATOM    837  OE1 GLN   103      62.423  24.784  90.658  1.00 37.49          
ATOM    838  NE2 GLN   103      62.026  25.659  88.623  1.00 36.64          
ATOM    839  N   CYS   104      58.102  23.073  88.490  1.00 26.82          
ATOM    840  CA  CYS   104      57.245  23.013  87.321  1.00 26.67          
ATOM    841  C   CYS   104      56.543  24.335  87.076  1.00 26.12          
ATOM    842  O   CYS   104      56.247  25.093  88.000  1.00 25.39          
ATOM    843  CB  CYS   104      56.246  21.858  87.427  1.00 27.15          
ATOM    844  SG  CYS   104      54.932  22.068  88.635  1.00 31.66          
ATOM    845  N   ASN   105      56.328  24.605  85.804  1.00 25.78          
ATOM    846  CA  ASN   105      55.584  25.768  85.366  1.00 25.96          
ATOM    847  C   ASN   105      54.135  25.312  85.218  1.00 25.15          
ATOM    848  O   ASN   105      53.872  24.277  84.611  1.00 23.84          
ATOM    849  CB  ASN   105      56.154  26.268  84.038  1.00 27.40          
ATOM    850  CG  ASN   105      55.475  27.535  83.579  1.00 33.06          
ATOM    851  OD1 ASN   105      54.409  27.486  82.956  1.00 38.49          
ATOM    852  ND2 ASN   105      56.038  28.681  83.963  1.00 30.86          
ATOM    853  N   ILE   106      53.219  26.056  85.828  1.00 24.15          
ATOM    854  CA  ILE   106      51.812  25.702  85.893  1.00 23.70          
ATOM    855  C   ILE   106      51.012  26.758  85.129  1.00 24.07          
ATOM    856  O   ILE   106      51.283  27.961  85.273  1.00 23.40          
ATOM    857  CB  ILE   106      51.315  25.707  87.370  1.00 23.94          
ATOM    858  CG1 ILE   106      52.172  24.822  88.287  1.00 24.39          
ATOM    859  CG2 ILE   106      49.812  25.278  87.470  1.00 25.84          
ATOM    860  CD  ILE   106      51.981  25.208  89.792  1.00 23.01          
ATOM    861  N   ARG   107      50.028  26.325  84.338  0.50 24.04          
ATOM    863  CA  ARG   107      49.100  27.273  83.687  0.50 23.34          
ATOM    865  C   ARG   107      47.662  26.792  83.794  0.50 23.38          
ATOM    867  O   ARG   107      47.344  25.687  83.378  0.50 22.72          
ATOM    869  CB  ARG   107      49.456  27.488  82.218  0.50 24.11          
ATOM    871  CG  ARG   107      48.687  28.627  81.527  0.50 24.57          
ATOM    873  CD  ARG   107      49.311  28.860  80.166  0.50 31.13          
ATOM    875  NE  ARG   107      49.187  30.218  79.624  0.50 34.92          
ATOM    877  CZ  ARG   107      50.028  30.709  78.711  0.50 36.28          
ATOM    879  NH1 ARG   107      49.891  31.937  78.227  0.50 38.84          
ATOM    881  NH2 ARG   107      51.034  29.966  78.284  0.50 38.53          
ATOM    883  N   LEU   108      46.802  27.636  84.363  1.00 22.78          
ATOM    884  CA  LEU   108      45.371  27.345  84.442  1.00 23.07          
ATOM    885  C   LEU   108      44.784  27.829  83.126  1.00 23.31          
ATOM    886  O   LEU   108      44.761  29.032  82.856  1.00 23.84          
ATOM    887  CB  LEU   108      44.761  28.082  85.633  1.00 23.51          
ATOM    888  CG  LEU   108      45.548  27.835  86.936  1.00 23.62          
ATOM    889  CD1 LEU   108      44.924  28.674  88.092  1.00 27.25          
ATOM    890  CD2 LEU   108      45.526  26.358  87.255  1.00 24.88          
ATOM    891  N   LEU   109      44.350  26.895  82.290  1.00 23.14          
ATOM    892  CA  LEU   109      43.906  27.234  80.950  1.00 23.54          
ATOM    893  C   LEU   109      42.371  27.321  80.899  1.00 23.77          
ATOM    894  O   LEU   109      41.670  26.338  80.524  1.00 23.71          
ATOM    895  CB  LEU   109      44.483  26.250  79.911  1.00 23.98          
ATOM    896  CG  LEU   109      44.344  26.668  78.425  1.00 25.11          
ATOM    897  CD1 LEU   109      45.396  27.742  78.054  1.00 24.78          
ATOM    898  CD2 LEU   109      44.447  25.467  77.474  1.00 25.64          
ATOM    899  N   HSD   110      41.852  28.462  81.362  1.00 22.67          
ATOM    900  CA  HSD   110      40.377  28.713  81.353  1.00 22.13          
ATOM    901  C   HSD   110      39.998  29.153  79.949  1.00 21.73          
ATOM    902  O   HSD   110      40.876  29.580  79.174  1.00 22.49          
ATOM    903  CB  HSD   110      40.034  29.763  82.443  1.00 22.73          
ATOM    904  CG  HSD   110      38.567  29.938  82.715  1.00 22.61          
ATOM    905  ND1 HSD   110      37.757  30.759  81.963  1.00 24.29          
ATOM    906  CD2 HSD   110      37.790  29.454  83.719  1.00 23.03          
ATOM    907  CE1 HSD   110      36.528  30.753  82.469  1.00 25.00          
ATOM    908  NE2 HSD   110      36.522  29.962  83.538  1.00 25.22          
ATOM    909  N   GLU   111      38.716  29.037  79.575  1.00 21.19          
ATOM    910  CA  GLU   111      38.306  29.511  78.231  1.00 21.14          
ATOM    911  C   GLU   111      38.210  31.034  78.104  1.00 20.87          
ATOM    912  O   GLU   111      38.114  31.563  77.003  1.00 20.50          
ATOM    913  CB  GLU   111      37.042  28.786  77.746  1.00 23.05          
ATOM    914  CG  GLU   111      35.742  29.222  78.438  1.00 23.31          
ATOM    915  CD  GLU   111      35.458  28.586  79.810  1.00 26.37          
ATOM    916  OE1 GLU   111      36.334  27.994  80.494  1.00 24.08          
ATOM    917  OE2 GLU   111      34.280  28.711  80.238  1.00 27.05          
ATOM    918  N   LYS   112      38.245  31.721  79.250  0.50 20.92          
ATOM    920  CA  LYS   112      38.087  33.177  79.310  0.50 20.70          
ATOM    922  C   LYS   112      39.411  33.903  79.618  0.50 21.25          
ATOM    924  O   LYS   112      39.564  35.113  79.341  0.50 20.94          
ATOM    926  CB  LYS   112      36.999  33.550  80.361  0.50 20.26          
ATOM    928  CG  LYS   112      36.773  35.067  80.503  0.50 19.15          
ATOM    930  CD  LYS   112      36.331  35.672  79.152  0.50 20.20          
ATOM    932  CE  LYS   112      36.541  37.191  79.051  0.50 16.26          
ATOM    934  NZ  LYS   112      37.931  37.622  79.298  0.50  9.90          
ATOM    936  N   TYR   113      40.364  33.180  80.195  1.00 20.88          
ATOM    937  CA  TYR   113      41.644  33.777  80.572  1.00 21.91          
ATOM    938  C   TYR   113      42.609  32.662  80.866  1.00 22.49          
ATOM    939  O   TYR   113      42.204  31.497  81.013  1.00 21.81          
ATOM    940  CB  TYR   113      41.512  34.699  81.838  1.00 22.60          
ATOM    941  CG  TYR   113      40.792  33.962  82.959  1.00 24.25          
ATOM    942  CD1 TYR   113      41.488  33.060  83.770  1.00 25.82          
ATOM    943  CD2 TYR   113      39.435  34.120  83.174  1.00 27.52          
ATOM    944  CE1 TYR   113      40.835  32.355  84.794  1.00 26.93          
ATOM    945  CE2 TYR   113      38.768  33.403  84.192  1.00 28.33          
ATOM    946  CZ  TYR   113      39.482  32.520  84.966  1.00 27.71          
ATOM    947  OH  TYR   113      38.878  31.808  86.005  1.00 32.23          
ATOM    948  N   SER   114      43.889  33.007  80.988  1.00 22.58          
ATOM    949  CA  SER   114      44.862  32.027  81.438  1.00 23.73          
ATOM    950  C   SER   114      45.713  32.702  82.533  1.00 23.87          
ATOM    951  O   SER   114      46.090  33.887  82.417  1.00 22.05          
ATOM    952  CB  SER   114      45.689  31.562  80.243  1.00 25.99          
ATOM    953  OG  SER   114      46.805  30.826  80.655  1.00 34.48          
ATOM    954  N   ILE   115      46.051  31.937  83.572  1.00 23.45          
ATOM    955  CA  ILE   115      46.928  32.458  84.610  1.00 24.88          
ATOM    956  C   ILE   115      47.953  31.398  84.897  1.00 24.20          
ATOM    957  O   ILE   115      47.590  30.243  85.084  1.00 24.37          
ATOM    958  CB  ILE   115      46.165  32.731  85.930  1.00 25.11          
ATOM    959  CG1 ILE   115      44.833  33.404  85.669  1.00 26.95          
ATOM    960  CG2 ILE   115      47.031  33.614  86.880  1.00 26.89          
ATOM    961  CD  ILE   115      43.951  33.559  86.953  1.00 28.56          
ATOM    962  N   GLY   116      49.216  31.791  84.969  1.00 24.03          
ATOM    963  CA  GLY   116      50.315  30.833  85.268  1.00 24.05          
ATOM    964  C   GLY   116      51.233  31.370  86.360  1.00 23.76          
ATOM    965  O   GLY   116      51.115  32.543  86.770  1.00 22.74          
ATOM    966  N   ASN   117      52.159  30.526  86.818  1.00 23.26          
ATOM    967  CA  ASN   117      53.212  30.957  87.726  1.00 23.63          
ATOM    968  C   ASN   117      54.449  31.425  86.946  1.00 23.90          
ATOM    969  O   ASN   117      54.405  31.524  85.722  1.00 23.64          
ATOM    970  CB  ASN   117      53.548  29.855  88.748  1.00 23.14          
ATOM    971  CG  ASN   117      54.198  28.612  88.122  1.00 24.21          
ATOM    972  OD1 ASN   117      54.250  28.447  86.896  1.00 25.61          
ATOM    973  ND2 ASN   117      54.696  27.728  88.977  1.00 26.73          
ATOM    974  N   LYS   118      55.529  31.724  87.650  1.00 23.62          
ATOM    975  CA  LYS   118      56.711  32.281  87.012  1.00 25.96          
ATOM    976  C   LYS   118      57.923  31.374  87.111  1.00 27.77          
ATOM    977  O   LYS   118      59.051  31.813  86.842  1.00 28.62          
ATOM    978  CB  LYS   118      57.034  33.653  87.623  1.00 25.98          
ATOM    979  CG  LYS   118      56.042  34.711  87.226  1.00 25.72          
ATOM    980  CD  LYS   118      56.415  36.069  87.807  1.00 28.58          
ATOM    981  CE  LYS   118      55.419  37.087  87.370  1.00 30.46          
ATOM    982  NZ  LYS   118      55.884  38.458  87.729  1.00 32.10          
ATOM    983  N   LYS   119      57.708  30.121  87.489  1.00 29.44          
ATOM    984  CA  LYS   119      58.841  29.200  87.654  1.00 32.60          
ATOM    985  C   LYS   119      59.461  28.888  86.300  1.00 33.59          
ATOM    986  O   LYS   119      58.738  28.571  85.338  1.00 33.10          
ATOM    987  CB  LYS   119      58.399  27.894  88.304  1.00 32.75          
ATOM    988  CG  LYS   119      58.288  27.960  89.798  1.00 35.91          
ATOM    989  CD  LYS   119      58.459  26.579  90.421  1.00 37.54          
ATOM    990  CE  LYS   119      58.129  26.650  91.897  1.00 39.43          
ATOM    991  NZ  LYS   119      57.866  25.305  92.472  1.00 40.56          
ATOM    992  N   LYS   120      60.790  29.007  86.240  1.00 36.02          
ATOM    993  CA  LYS   120      61.578  28.654  85.063  1.00 38.02          
ATOM    994  C   LYS   120      61.896  27.170  85.118  1.00 39.04          
ATOM    995  O   LYS   120      62.296  26.657  86.164  1.00 38.77          
ATOM    996  CB  LYS   120      62.886  29.453  85.030  1.00 38.32          
ATOM    997  CG  LYS   120      62.694  30.945  84.772  1.00 40.54          
ATOM    998  CD  LYS   120      63.861  31.747  85.335  1.00 44.73          
ATOM    999  CE  LYS   120      63.444  33.184  85.676  1.00 46.55          
ATOM   1000  NZ  LYS   120      62.821  33.882  84.512  1.00 48.28          
ATOM   1001  N   VAL   121      61.689  26.475  84.005  1.00 40.06          
ATOM   1002  CA  VAL   121      62.090  25.076  83.913  1.00 42.36          
ATOM   1003  C   VAL   121      63.024  24.879  82.729  1.00 43.96          
ATOM   1004  O   VAL   121      62.907  25.576  81.713  1.00 44.09          
ATOM   1005  CB  VAL   121      60.890  24.090  83.829  1.00 42.18          
ATOM   1006  CG1 VAL   121      60.113  24.078  85.145  1.00 42.37          
ATOM   1007  CG2 VAL   121      59.973  24.426  82.657  1.00 42.77          
ATOM   1008  N   ASN   122      63.956  23.942  82.881  1.00 46.08          
ATOM   1009  CA  ASN   122      64.798  23.497  81.784  1.00 48.39          
ATOM   1010  C   ASN   122      63.967  22.638  80.835  1.00 49.57          
ATOM   1011  O   ASN   122      63.999  21.405  80.907  1.00 50.16          
ATOM   1012  CB  ASN   122      66.000  22.705  82.317  1.00 48.37          
ATOM   1013  CG  ASN   122      66.775  23.462  83.391  1.00 50.19          
ATOM   1014  OD1 ASN   122      66.642  24.684  83.540  1.00 51.78          
ATOM   1015  ND2 ASN   122      67.594  22.733  84.150  1.00 51.79          
ATOM   1016  N   SER   123      63.204  23.306  79.970  1.00 50.84          
ATOM   1017  CA  SER   123      62.344  22.642  78.997  1.00 52.09          
ATOM   1018  C   SER   123      62.412  23.349  77.638  1.00 52.92          
ATOM   1019  O   SER   123      61.943  24.490  77.493  1.00 52.90          
ATOM   1020  CB  SER   123      60.897  22.581  79.517  1.00 51.99          
ATOM   1021  OG  SER   123      59.973  22.350  78.464  1.00 52.51          
ATOM   1022  N   ASN   124      62.996  22.661  76.655  1.00 54.00          
ATOM   1023  CA  ASN   124      63.103  23.175  75.284  1.00 55.02          
ATOM   1024  C   ASN   124      61.801  23.189  74.477  1.00 55.68          
ATOM   1025  O   ASN   124      61.641  24.014  73.570  1.00 55.59          
ATOM   1026  CB  ASN   124      64.182  22.418  74.520  1.00 55.34          
ATOM   1027  CG  ASN   124      65.570  22.887  74.882  1.00 56.21          
ATOM   1028  OD1 ASN   124      65.761  24.036  75.293  1.00 57.93          
ATOM   1029  ND2 ASN   124      66.551  22.002  74.740  1.00 57.10          
ATOM   1030  N   LEU   125      60.891  22.265  74.803  1.00 56.35          
ATOM   1031  CA  LEU   125      59.562  22.196  74.177  1.00 56.84          
ATOM   1032  C   LEU   125      58.695  23.350  74.654  1.00 57.24          
ATOM   1033  O   LEU   125      57.808  23.802  73.929  1.00 57.49          
ATOM   1034  CB  LEU   125      58.866  20.851  74.461  1.00 56.60          
ATOM   1035  CG  LEU   125      59.414  19.595  73.764  1.00 56.47          
ATOM   1036  CD1 LEU   125      58.959  18.320  74.476  1.00 54.67          
ATOM   1037  CD2 LEU   125      59.050  19.566  72.271  1.00 55.55          
ATOM   1038  N   LEU   126      58.945  23.818  75.876  1.00 57.73          
ATOM   1039  CA  LEU   126      58.324  25.055  76.352  1.00 58.17          
ATOM   1040  C   LEU   126      58.840  26.226  75.516  1.00 58.38          
ATOM   1041  O   LEU   126      58.062  27.066  75.082  1.00 58.75          
ATOM   1042  CB  LEU   126      58.581  25.290  77.852  1.00 58.02          
ATOM   1043  CG  LEU   126      57.955  26.537  78.497  1.00 57.92          
ATOM   1044  CD1 LEU   126      56.442  26.615  78.265  1.00 57.28          
ATOM   1045  CD2 LEU   126      58.279  26.613  79.991  1.00 58.15          
ATOM   1046  N   GLY   127      60.150  26.255  75.277  1.00 58.51          
ATOM   1047  CA  GLY   127      60.762  27.265  74.414  1.00 58.47          
ATOM   1048  C   GLY   127      60.290  27.216  72.967  1.00 58.45          
ATOM   1049  O   GLY   127      60.195  28.256  72.312  1.00 58.83          
ATOM   1050  N   LYS   128      59.991  26.014  72.469  1.00 57.98          
ATOM   1051  CA  LYS   128      59.581  25.817  71.069  1.00 57.26          
ATOM   1052  C   LYS   128      58.092  26.112  70.828  1.00 56.69          
ATOM   1053  O   LYS   128      57.711  26.555  69.737  1.00 56.67          
ATOM   1054  CB  LYS   128      59.929  24.404  70.605  1.00 57.30          
ATOM   1055  N   ALA   129      57.264  25.872  71.847  1.00 55.52          
ATOM   1056  CA  ALA   129      55.808  26.000  71.733  1.00 54.54          
ATOM   1057  C   ALA   129      55.388  27.394  71.249  1.00 53.82          
ATOM   1058  O   ALA   129      55.832  28.398  71.805  1.00 53.76          
ATOM   1059  CB  ALA   129      55.143  25.663  73.068  1.00 54.53          
ATOM   1060  N   LEU   130      54.543  27.440  70.211  1.00 52.88          
ATOM   1061  CA  LEU   130      54.035  28.707  69.641  1.00 51.94          
ATOM   1062  C   LEU   130      53.223  29.499  70.664  1.00 51.64          
ATOM   1063  O   LEU   130      52.291  28.969  71.270  1.00 51.01          
ATOM   1064  CB  LEU   130      53.172  28.455  68.392  1.00 51.60          
ATOM   1065  CG  LEU   130      53.828  27.999  67.081  1.00 51.08          
ATOM   1066  CD1 LEU   130      52.812  27.305  66.145  1.00 49.55          
ATOM   1067  CD2 LEU   130      54.536  29.169  66.372  1.00 50.62          
ATOM   1068  N   ILE   131      53.604  30.760  70.860  1.00 51.30          
ATOM   1069  CA  ILE   131      52.826  31.703  71.671  1.00 51.22          
ATOM   1070  C   ILE   131      51.834  32.416  70.748  1.00 50.60          
ATOM   1071  O   ILE   131      52.197  32.851  69.643  1.00 50.90          
ATOM   1072  CB  ILE   131      53.726  32.738  72.414  1.00 50.95          
ATOM   1073  CG1 ILE   131      54.705  32.021  73.351  1.00 51.52          
ATOM   1074  CG2 ILE   131      52.868  33.728  73.217  1.00 52.11          
ATOM   1075  CD  ILE   131      55.385  32.932  74.394  1.00 52.02          
ATOM   1076  N   HSD   132      50.584  32.504  71.194  1.00 49.50          
ATOM   1077  CA  HSD   132      49.535  33.212  70.451  1.00 48.50          
ATOM   1078  C   HSD   132      48.919  34.304  71.336  1.00 47.17          
ATOM   1079  O   HSD   132      48.984  34.203  72.571  1.00 47.31          
ATOM   1080  CB  HSD   132      48.478  32.246  69.877  1.00 48.91          
ATOM   1081  CG  HSD   132      48.268  31.007  70.692  1.00 49.29          
ATOM   1082  ND1 HSD   132      47.175  30.834  71.514  1.00 49.90          
ATOM   1083  CD2 HSD   132      49.004  29.872  70.798  1.00 50.80          
ATOM   1084  CE1 HSD   132      47.246  29.647  72.095  1.00 51.14          
ATOM   1085  NE2 HSD   132      48.348  29.042  71.682  1.00 50.86          
ATOM   1086  N   PRO   133      48.316  35.336  70.708  1.00 45.46          
ATOM   1087  CA  PRO   133      47.994  36.583  71.396  1.00 43.38          
ATOM   1088  C   PRO   133      47.016  36.414  72.561  1.00 40.66          
ATOM   1089  O   PRO   133      46.119  35.565  72.520  1.00 41.64          
ATOM   1090  CB  PRO   133      47.329  37.423  70.302  1.00 43.53          
ATOM   1091  CG  PRO   133      47.768  36.811  69.009  1.00 45.34          
ATOM   1092  CD  PRO   133      47.876  35.365  69.296  1.00 45.87          
ATOM   1093  N   SER   134      47.199  37.212  73.596  1.00 36.90          
ATOM   1094  CA  SER   134      46.129  37.393  74.558  1.00 32.79          
ATOM   1095  C   SER   134      45.240  38.480  73.920  1.00 30.34          
ATOM   1096  O   SER   134      45.583  39.066  72.859  1.00 27.78          
ATOM   1097  CB  SER   134      46.681  37.865  75.905  1.00 32.87          
ATOM   1098  OG  SER   134      46.999  39.272  75.900  1.00 36.95          
ATOM   1099  N   ASP   135      44.110  38.758  74.562  1.00 26.67          
ATOM   1100  CA  ASP   135      43.355  39.956  74.228  1.00 24.35          
ATOM   1101  C   ASP   135      42.937  40.503  75.578  1.00 23.50          
ATOM   1102  O   ASP   135      42.429  39.743  76.426  1.00 22.77          
ATOM   1103  CB  ASP   135      42.143  39.649  73.336  1.00 25.82          
ATOM   1104  CG  ASP   135      41.363  40.911  72.984  1.00 25.41          
ATOM   1105  OD1 ASP   135      41.675  41.547  71.958  1.00 25.59          
ATOM   1106  OD2 ASP   135      40.490  41.331  73.771  1.00 24.43          
ATOM   1107  N   PRO   136      43.198  41.790  75.808  1.00 22.46          
ATOM   1108  CA  PRO   136      42.929  42.348  77.140  1.00 22.89          
ATOM   1109  C   PRO   136      41.455  42.294  77.548  1.00 22.23          
ATOM   1110  O   PRO   136      41.179  42.356  78.738  1.00 22.64          
ATOM   1111  CB  PRO   136      43.431  43.799  77.049  1.00 23.21          
ATOM   1112  CG  PRO   136      43.673  44.067  75.587  1.00 23.98          
ATOM   1113  CD  PRO   136      43.811  42.758  74.877  1.00 22.40          
ATOM   1114  N   ILE   137      40.524  42.184  76.591  1.00 20.68          
ATOM   1115  CA  ILE   137      39.112  41.996  76.964  1.00 19.92          
ATOM   1116  C   ILE   137      38.774  40.516  76.974  1.00 20.18          
ATOM   1117  O   ILE   137      38.279  40.006  77.986  1.00 20.43          
ATOM   1118  CB  ILE   137      38.137  42.764  76.029  1.00 20.48          
ATOM   1119  CG1 ILE   137      38.385  44.278  76.112  1.00 20.36          
ATOM   1120  CG2 ILE   137      36.627  42.411  76.341  1.00 22.15          
ATOM   1121  CD  ILE   137      37.485  45.058  75.112  1.00 21.69          
ATOM   1122  N   PHE   138      39.016  39.836  75.853  1.00 18.81          
ATOM   1123  CA  PHE   138      38.439  38.488  75.650  1.00 19.03          
ATOM   1124  C   PHE   138      39.267  37.350  76.188  1.00 19.99          
ATOM   1125  O   PHE   138      38.754  36.210  76.400  1.00 19.78          
ATOM   1126  CB  PHE   138      38.096  38.292  74.155  1.00 19.06          
ATOM   1127  CG  PHE   138      37.009  39.214  73.704  1.00 19.34          
ATOM   1128  CD1 PHE   138      35.684  38.964  74.080  1.00 21.10          
ATOM   1129  CD2 PHE   138      37.302  40.382  73.015  1.00 16.73          
ATOM   1130  CE1 PHE   138      34.654  39.863  73.698  1.00 18.53          
ATOM   1131  CE2 PHE   138      36.335  41.269  72.634  1.00 18.95          
ATOM   1132  CZ  PHE   138      34.966  41.025  72.975  1.00 18.88          
ATOM   1133  N   TYR   139      40.574  37.598  76.353  1.00 19.75          
ATOM   1134  CA  TYR   139      41.473  36.518  76.824  1.00 20.53          
ATOM   1135  C   TYR   139      42.730  37.039  77.496  1.00 20.57          
ATOM   1136  O   TYR   139      43.808  36.972  76.900  1.00 21.22          
ATOM   1137  CB  TYR   139      41.863  35.509  75.694  1.00 20.94          
ATOM   1138  CG  TYR   139      42.222  34.171  76.296  1.00 21.08          
ATOM   1139  CD1 TYR   139      43.567  33.812  76.545  1.00 22.13          
ATOM   1140  CD2 TYR   139      41.214  33.276  76.683  1.00 20.13          
ATOM   1141  CE1 TYR   139      43.898  32.604  77.159  1.00 22.09          
ATOM   1142  CE2 TYR   139      41.532  32.055  77.296  1.00 21.50          
ATOM   1143  CZ  TYR   139      42.875  31.743  77.552  1.00 21.15          
ATOM   1144  OH  TYR   139      43.190  30.548  78.146  1.00 22.82          
ATOM   1145  N   PRO   140      42.597  37.619  78.700  1.00 21.01          
ATOM   1146  CA  PRO   140      43.777  38.101  79.413  1.00 22.31          
ATOM   1147  C   PRO   140      44.679  36.951  79.793  1.00 23.43          
ATOM   1148  O   PRO   140      44.191  35.850  80.126  1.00 23.59          
ATOM   1149  CB  PRO   140      43.192  38.797  80.681  1.00 21.99          
ATOM   1150  CG  PRO   140      41.750  38.988  80.419  1.00 21.63          
ATOM   1151  CD  PRO   140      41.343  37.925  79.415  1.00 20.43          
ATOM   1152  N   VAL   141      45.989  37.165  79.680  1.00 24.46          
ATOM   1153  CA  VAL   141      46.979  36.148  80.079  1.00 26.37          
ATOM   1154  C   VAL   141      47.938  36.813  81.087  1.00 27.37          
ATOM   1155  O   VAL   141      48.544  37.861  80.777  1.00 26.66          
ATOM   1156  CB  VAL   141      47.726  35.569  78.858  1.00 27.66          
ATOM   1157  CG1 VAL   141      48.822  34.571  79.312  1.00 28.57          
ATOM   1158  CG2 VAL   141      46.738  34.851  77.878  1.00 27.79          
ATOM   1159  N   GLN   142      48.012  36.276  82.304  1.00 26.50          
ATOM   1160  CA  GLN   142      48.876  36.842  83.335  0.50 27.56          
ATOM   1162  C   GLN   142      49.671  35.766  84.046  1.00 27.33          
ATOM   1163  O   GLN   142      49.246  34.621  84.121  1.00 27.54          
ATOM   1164  CB  GLN   142      48.087  37.634  84.385  0.50 28.43          
ATOM   1166  CG  GLN   142      48.949  37.900  85.613  0.50 30.06          
ATOM   1168  CD  GLN   142      48.548  39.080  86.480  0.50 30.99          
ATOM   1170  OE1 GLN   142      47.429  39.601  86.410  0.50 35.08          
ATOM   1172  NE2 GLN   142      49.482  39.516  87.299  0.50 32.11          
ATOM   1174  N   PHE   143      50.827  36.155  84.572  1.00 27.05          
ATOM   1175  CA  PHE   143      51.649  35.294  85.396  1.00 27.00          
ATOM   1176  C   PHE   143      51.794  35.938  86.762  1.00 27.02          
ATOM   1177  O   PHE   143      51.782  37.171  86.878  1.00 27.45          
ATOM   1178  CB  PHE   143      52.994  35.065  84.717  1.00 28.14          
ATOM   1179  CG  PHE   143      52.829  34.506  83.345  1.00 32.02          
ATOM   1180  CD1 PHE   143      52.469  33.192  83.179  1.00 35.41          
ATOM   1181  CD2 PHE   143      52.871  35.331  82.236  1.00 36.59          
ATOM   1182  CE1 PHE   143      52.244  32.657  81.901  1.00 39.26          
ATOM   1183  CE2 PHE   143      52.665  34.803  80.973  1.00 38.51          
ATOM   1184  CZ  PHE   143      52.362  33.463  80.808  1.00 36.64          
ATOM   1185  N   VAL   144      51.844  35.101  87.794  1.00 25.14          
ATOM   1186  CA  VAL   144      52.039  35.567  89.159  1.00 23.87          
ATOM   1187  C   VAL   144      53.121  34.715  89.777  1.00 23.62          
ATOM   1188  O   VAL   144      53.361  33.571  89.328  1.00 22.77          
ATOM   1189  CB  VAL   144      50.714  35.477  90.001  1.00 24.41          
ATOM   1190  CG1 VAL   144      49.709  36.495  89.505  1.00 25.17          
ATOM   1191  CG2 VAL   144      50.081  34.042  89.932  1.00 23.84          
ATOM   1192  N   GLU   145      53.765  35.250  90.813  1.00 22.68          
ATOM   1193  CA  GLU   145      54.763  34.491  91.551  0.50 22.85          
ATOM   1195  C   GLU   145      54.113  33.351  92.318  1.00 23.69          
ATOM   1196  O   GLU   145      54.665  32.250  92.375  1.00 23.67          
ATOM   1197  CB  GLU   145      55.522  35.400  92.504  0.50 22.64          
ATOM   1199  CG  GLU   145      56.665  34.738  93.232  0.50 20.07          
ATOM   1201  CD  GLU   145      57.330  35.678  94.201  0.50 20.81          
ATOM   1203  OE1 GLU   145      56.788  36.772  94.422  0.50 17.89          
ATOM   1205  OE2 GLU   145      58.399  35.328  94.737  0.50 20.29          
ATOM   1207  N   SER   146      52.933  33.608  92.906  1.00 23.58          
ATOM   1208  CA  SER   146      52.247  32.561  93.679  1.00 23.76          
ATOM   1209  C   SER   146      50.813  32.345  93.217  1.00 23.53          
ATOM   1210  O   SER   146      49.903  33.147  93.548  1.00 22.79          
ATOM   1211  CB  SER   146      52.261  32.844  95.188  1.00 25.42          
ATOM   1212  OG  SER   146      51.515  31.830  95.861  1.00 24.46          
ATOM   1213  N   LEU   147      50.606  31.269  92.467  1.00 22.89          
ATOM   1214  CA  LEU   147      49.248  30.958  91.999  1.00 23.97          
ATOM   1215  C   LEU   147      48.295  30.642  93.155  1.00 24.07          
ATOM   1216  O   LEU   147      47.162  31.144  93.202  1.00 24.91          
ATOM   1217  CB  LEU   147      49.252  29.761  91.056  1.00 24.97          
ATOM   1218  CG  LEU   147      49.391  30.006  89.573  1.00 28.73          
ATOM   1219  CD1 LEU   147      49.332  28.637  88.870  1.00 29.98          
ATOM   1220  CD2 LEU   147      48.277  30.946  89.055  1.00 29.01          
ATOM   1221  N   SER   148      48.743  29.812  94.089  1.00 23.93          
ATOM   1222  CA  SER   148      47.875  29.425  95.200  1.00 24.47          
ATOM   1223  C   SER   148      47.493  30.644  96.070  1.00 25.45          
ATOM   1224  O   SER   148      46.326  30.747  96.503  1.00 26.17          
ATOM   1225  CB  SER   148      48.506  28.300  96.018  1.00 24.85          
ATOM   1226  OG  SER   148      49.614  28.833  96.736  1.00 25.70          
ATOM   1227  N   ASP   149      48.400  31.608  96.265  1.00 24.13          
ATOM   1228  CA  ASP   149      48.009  32.829  96.992  1.00 25.46          
ATOM   1229  C   ASP   149      46.912  33.594  96.255  1.00 25.07          
ATOM   1230  O   ASP   149      45.987  34.094  96.886  1.00 24.95          
ATOM   1231  CB  ASP   149      49.182  33.792  97.289  1.00 25.22          
ATOM   1232  CG  ASP   149      50.063  33.338  98.455  1.00 27.73          
ATOM   1233  OD1 ASP   149      49.745  32.347  99.159  1.00 30.52          
ATOM   1234  OD2 ASP   149      51.114  33.988  98.674  1.00 28.84          
ATOM   1235  N   LEU   150      47.035  33.705  94.935  1.00 24.21          
ATOM   1236  CA  LEU   150      46.026  34.408  94.132  1.00 24.99          
ATOM   1237  C   LEU   150      44.669  33.736  94.275  1.00 23.83          
ATOM   1238  O   LEU   150      43.666  34.423  94.529  1.00 23.98          
ATOM   1239  CB  LEU   150      46.437  34.409  92.652  1.00 24.98          
ATOM   1240  CG  LEU   150      45.430  35.147  91.781  1.00 28.95          
ATOM   1241  CD1 LEU   150      45.747  36.615  91.911  1.00 33.55          
ATOM   1242  CD2 LEU   150      45.517  34.703  90.357  1.00 33.58          
ATOM   1243  N   LEU   151      44.661  32.402  94.155  1.00 23.37          
ATOM   1244  CA  LEU   151      43.430  31.578  94.210  1.00 24.42          
ATOM   1245  C   LEU   151      42.676  31.644  95.548  1.00 25.69          
ATOM   1246  O   LEU   151      41.456  31.361  95.610  1.00 24.99          
ATOM   1247  CB  LEU   151      43.743  30.109  93.857  1.00 24.38          
ATOM   1248  CG  LEU   151      44.292  29.812  92.448  1.00 25.82          
ATOM   1249  CD1 LEU   151      44.552  28.317  92.202  1.00 24.27          
ATOM   1250  CD2 LEU   151      43.390  30.322  91.365  1.00 27.53          
ATOM   1251  N   MET   152      43.384  32.015  96.608  1.00 27.18          
ATOM   1252  CA  MET   152      42.722  32.248  97.911  1.00 30.40          
ATOM   1253  C   MET   152      41.563  33.251  97.805  1.00 28.35          
ATOM   1254  O   MET   152      40.534  33.061  98.441  1.00 29.16          
ATOM   1255  CB  MET   152      43.714  32.773  98.945  1.00 29.91          
ATOM   1256  CG  MET   152      44.982  32.002  99.019  1.00 34.04          
ATOM   1257  SD  MET   152      45.240  31.124 100.702  0.40 39.80          
ATOM   1258  CE  MET   152      43.660  29.981 100.571  1.00 36.69          
ATOM   1259  N   ASP   153      41.752  34.330  97.047  1.00 25.94          
ATOM   1260  CA  ASP   153      40.748  35.373  96.919  1.00 25.38          
ATOM   1261  C   ASP   153      40.095  35.363  95.539  1.00 24.78          
ATOM   1262  O   ASP   153      39.049  35.977  95.354  1.00 23.83          
ATOM   1263  CB  ASP   153      41.374  36.743  97.181  1.00 26.73          
ATOM   1264  CG  ASP   153      41.761  36.911  98.636  1.00 28.73          
ATOM   1265  OD1 ASP   153      40.846  36.873  99.479  1.00 32.78          
ATOM   1266  OD2 ASP   153      42.962  37.078  98.930  1.00 35.47          
ATOM   1267  N   GLU   154      40.729  34.673  94.587  1.00 23.72          
ATOM   1268  CA  GLU   154      40.212  34.586  93.214  1.00 23.81          
ATOM   1269  C   GLU   154      40.196  33.127  92.800  1.00 23.78          
ATOM   1270  O   GLU   154      41.078  32.679  92.090  1.00 24.78          
ATOM   1271  CB  GLU   154      41.075  35.402  92.234  1.00 24.00          
ATOM   1272  CG  GLU   154      41.017  36.942  92.468  1.00 24.87          
ATOM   1273  CD  GLU   154      39.622  37.565  92.203  1.00 26.70          
ATOM   1274  OE1 GLU   154      38.696  36.897  91.659  1.00 27.11          
ATOM   1275  OE2 GLU   154      39.454  38.759  92.527  1.00 28.82          
ATOM   1276  N   PRO   155      39.174  32.378  93.231  1.00 23.99          
ATOM   1277  CA  PRO   155      39.097  30.956  92.849  1.00 23.75          
ATOM   1278  C   PRO   155      39.028  30.812  91.328  1.00 23.44          
ATOM   1279  O   PRO   155      38.481  31.694  90.625  1.00 23.07          
ATOM   1280  CB  PRO   155      37.803  30.470  93.511  1.00 24.07          
ATOM   1281  CG  PRO   155      37.448  31.506  94.521  1.00 26.30          
ATOM   1282  CD  PRO   155      38.059  32.798  94.094  1.00 24.56          
ATOM   1283  N   VAL   156      39.615  29.740  90.817  1.00 21.71          
ATOM   1284  CA  VAL   156      39.513  29.441  89.369  1.00 23.19          
ATOM   1285  C   VAL   156      39.026  28.008  89.195  1.00 23.59          
ATOM   1286  O   VAL   156      39.521  27.102  89.864  1.00 23.15          
ATOM   1287  CB  VAL   156      40.891  29.621  88.672  1.00 22.90          
ATOM   1288  CG1 VAL   156      40.910  29.090  87.225  1.00 23.40          
ATOM   1289  CG2 VAL   156      41.298  31.112  88.662  1.00 22.77          
ATOM   1290  N   SER   157      38.051  27.804  88.307  1.00 24.28          
ATOM   1291  CA  SER   157      37.609  26.454  87.979  1.00 24.79          
ATOM   1292  C   SER   157      38.050  26.188  86.543  1.00 26.87          
ATOM   1293  O   SER   157      37.402  26.617  85.601  1.00 28.41          
ATOM   1294  CB  SER   157      36.087  26.321  88.133  1.00 24.36          
ATOM   1295  OG  SER   157      35.705  24.959  87.976  1.00 26.36          
ATOM   1296  N   ALA   158      39.170  25.495  86.443  1.00 28.06          
ATOM   1297  CA  ALA   158      39.968  25.298  85.239  1.00 29.72          
ATOM   1298  C   ALA   158      39.486  24.078  84.424  1.00 27.18          
ATOM   1299  O   ALA   158      39.467  23.000  84.980  1.00 28.44          
ATOM   1300  CB  ALA   158      41.404  25.023  85.736  1.00 30.50          
ATOM   1301  N   PRO   159      39.160  24.227  83.109  1.00 26.69          
ATOM   1302  CA  PRO   159      38.952  22.994  82.309  1.00 25.77          
ATOM   1303  C   PRO   159      40.219  22.126  82.200  1.00 25.72          
ATOM   1304  O   PRO   159      40.085  20.904  82.101  1.00 25.92          
ATOM   1305  CB  PRO   159      38.523  23.518  80.917  1.00 26.68          
ATOM   1306  CG  PRO   159      38.026  24.973  81.231  1.00 25.87          
ATOM   1307  CD  PRO   159      38.925  25.431  82.297  1.00 26.71          
ATOM   1308  N   VAL   160      41.406  22.760  82.177  1.00 25.07          
ATOM   1309  CA  VAL   160      42.715  22.083  82.031  0.50 24.81          
ATOM   1311  C   VAL   160      43.762  22.827  82.863  1.00 24.91          
ATOM   1312  O   VAL   160      43.764  24.069  82.888  1.00 24.66          
ATOM   1313  CB  VAL   160      43.206  22.066  80.553  0.50 25.24          
ATOM   1315  CG1 VAL   160      44.637  21.498  80.424  0.50 25.55          
ATOM   1317  CG2 VAL   160      42.258  21.266  79.680  0.50 23.82          
ATOM   1319  N   ILE   161      44.640  22.082  83.516  1.00 24.06          
ATOM   1320  CA  ILE   161      45.813  22.637  84.148  1.00 24.65          
ATOM   1321  C   ILE   161      47.008  22.055  83.368  1.00 24.59          
ATOM   1322  O   ILE   161      47.158  20.804  83.276  1.00 24.67          
ATOM   1323  CB  ILE   161      45.861  22.256  85.634  1.00 23.84          
ATOM   1324  CG1 ILE   161      44.647  22.865  86.383  1.00 23.65          
ATOM   1325  CG2 ILE   161      47.176  22.723  86.286  1.00 25.49          
ATOM   1326  CD  ILE   161      44.449  22.316  87.832  1.00 24.81          
ATOM   1327  N   GLU   162      47.832  22.935  82.802  1.00 24.49          
ATOM   1328  CA  GLU   162      49.029  22.510  82.004  1.00 25.42          
ATOM   1329  C   GLU   162      50.263  22.550  82.886  1.00 25.47          
ATOM   1330  O   GLU   162      50.441  23.498  83.683  1.00 25.56          
ATOM   1331  CB  GLU   162      49.275  23.449  80.828  1.00 27.13          
ATOM   1332  CG  GLU   162      48.122  23.525  79.862  1.00 30.24          
ATOM   1333  CD  GLU   162      48.402  24.475  78.703  1.00 36.15          
ATOM   1334  OE1 GLU   162      48.943  25.589  78.935  1.00 38.12          
ATOM   1335  OE2 GLU   162      48.061  24.115  77.557  1.00 37.86          
ATOM   1336  N   VAL   163      51.086  21.519  82.791  1.00 24.32          
ATOM   1337  CA  VAL   163      52.240  21.381  83.679  1.00 24.67          
ATOM   1338  C   VAL   163      53.469  21.103  82.843  1.00 24.79          
ATOM   1339  O   VAL   163      53.529  20.071  82.175  1.00 23.66          
ATOM   1340  CB  VAL   163      52.047  20.224  84.669  1.00 24.67          
ATOM   1341  CG1 VAL   163      53.234  20.174  85.658  1.00 26.01          
ATOM   1342  CG2 VAL   163      50.701  20.365  85.407  1.00 25.37          
ATOM   1343  N   TYR   164      54.439  22.022  82.870  1.00 24.12          
ATOM   1344  CA  TYR   164      55.685  21.828  82.141  0.50 24.46          
ATOM   1346  C   TYR   164      56.800  21.548  83.121  1.00 25.01          
ATOM   1347  O   TYR   164      56.932  22.246  84.143  1.00 23.76          
ATOM   1348  CB  TYR   164      56.062  23.058  81.320  0.50 24.93          
ATOM   1350  CG  TYR   164      55.543  23.084  79.897  0.50 24.76          
ATOM   1352  CD1 TYR   164      56.242  22.459  78.865  0.50 25.67          
ATOM   1354  CD2 TYR   164      54.371  23.771  79.576  0.50 24.32          
ATOM   1356  CE1 TYR   164      55.777  22.495  77.549  0.50 25.23          
ATOM   1358  CE2 TYR   164      53.901  23.820  78.258  0.50 25.78          
ATOM   1360  CZ  TYR   164      54.618  23.179  77.255  0.50 24.58          
ATOM   1362  OH  TYR   164      54.183  23.205  75.955  0.50 26.05          
ATOM   1364  N   THR   165      57.598  20.524  82.810  1.00 24.60          
ATOM   1365  CA  THR   165      58.721  20.133  83.646  1.00 25.74          
ATOM   1366  C   THR   165      59.859  19.571  82.789  1.00 26.38          
ATOM   1367  O   THR   165      59.689  19.321  81.584  1.00 25.98          
ATOM   1368  CB  THR   165      58.308  19.026  84.664  1.00 26.13          
ATOM   1369  OG1 THR   165      58.062  17.796  83.970  1.00 28.08          
ATOM   1370  CG2 THR   165      57.063  19.407  85.423  1.00 27.71          
ATOM   1371  N   GLU   166      61.014  19.373  83.410  1.00 27.49          
ATOM   1372  CA  GLU   166      62.037  18.465  82.849  1.00 28.90          
ATOM   1373  C   GLU   166      61.443  17.041  82.813  1.00 28.62          
ATOM   1374  O   GLU   166      60.575  16.697  83.625  1.00 27.66          
ATOM   1375  CB  GLU   166      63.329  18.485  83.685  1.00 28.88          
ATOM   1376  CG  GLU   166      64.035  19.857  83.816  1.00 32.30          
ATOM   1377  CD  GLU   166      65.393  19.789  84.587  1.00 33.25          
ATOM   1378  OE1 GLU   166      66.261  18.938  84.260  1.00 38.60          
ATOM   1379  OE2 GLU   166      65.601  20.604  85.531  1.00 39.33          
ATOM   1380  N   HSD   167      61.925  16.187  81.909  1.00 28.85          
ATOM   1381  CA  HSD   167      61.309  14.868  81.797  1.00 30.00          
ATOM   1382  C   HSD   167      61.433  14.005  83.070  1.00 30.53          
ATOM   1383  O   HSD   167      60.535  13.219  83.379  1.00 31.01          
ATOM   1384  CB  HSD   167      61.812  14.113  80.568  1.00 30.10          
ATOM   1385  CG  HSD   167      61.131  12.793  80.364  1.00 31.45          
ATOM   1386  ND1 HSD   167      61.798  11.589  80.450  1.00 33.08          
ATOM   1387  CD2 HSD   167      59.834  12.489  80.126  1.00 30.79          
ATOM   1388  CE1 HSD   167      60.946  10.601  80.241  1.00 31.32          
ATOM   1389  NE2 HSD   167      59.748  11.120  80.042  1.00 34.30          
ATOM   1390  N   ASP   168      62.534  14.172  83.800  1.00 31.14          
ATOM   1391  CA  ASP   168      62.873  13.310  84.936  1.00 31.77          
ATOM   1392  C   ASP   168      61.814  13.207  86.061  1.00 30.99          
ATOM   1393  O   ASP   168      61.735  12.179  86.749  1.00 30.88          
ATOM   1394  CB  ASP   168      64.282  13.655  85.495  1.00 32.83          
ATOM   1395  CG  ASP   168      64.377  15.078  86.118  1.00 35.49          
ATOM   1396  OD1 ASP   168      63.511  15.957  85.887  1.00 39.03          
ATOM   1397  OD2 ASP   168      65.363  15.318  86.853  1.00 39.88          
ATOM   1398  N   ILE   169      60.998  14.248  86.229  1.00 30.06          
ATOM   1399  CA  ILE   169      59.994  14.280  87.299  1.00 29.13          
ATOM   1400  C   ILE   169      58.536  14.064  86.853  1.00 28.85          
ATOM   1401  O   ILE   169      57.628  14.071  87.691  1.00 28.39          
ATOM   1402  CB  ILE   169      60.120  15.563  88.179  1.00 29.06          
ATOM   1403  CG1 ILE   169      59.759  16.836  87.389  1.00 28.51          
ATOM   1404  CG2 ILE   169      61.539  15.629  88.828  1.00 29.06          
ATOM   1405  CD  ILE   169      59.625  18.126  88.261  1.00 28.45          
ATOM   1406  N   GLN   170      58.302  13.860  85.554  1.00 28.77          
ATOM   1407  CA  GLN   170      56.925  13.670  85.046  1.00 28.63          
ATOM   1408  C   GLN   170      56.213  12.484  85.669  1.00 28.72          
ATOM   1409  O   GLN   170      55.042  12.559  85.992  1.00 28.16          
ATOM   1410  CB  GLN   170      56.906  13.423  83.545  1.00 29.18          
ATOM   1411  CG  GLN   170      56.876  14.606  82.707  1.00 28.65          
ATOM   1412  CD  GLN   170      56.437  14.259  81.310  1.00 30.21          
ATOM   1413  OE1 GLN   170      56.672  13.146  80.822  1.00 26.53          
ATOM   1414  NE2 GLN   170      55.799  15.208  80.653  1.00 28.23          
ATOM   1415  N   HSD   171      56.919  11.363  85.792  1.00 28.90          
ATOM   1416  CA  HSD   171      56.319  10.168  86.369  1.00 29.62          
ATOM   1417  C   HSD   171      55.887  10.394  87.832  1.00 29.02          
ATOM   1418  O   HSD   171      54.780  10.000  88.228  1.00 29.32          
ATOM   1419  CB  HSD   171      57.274   8.979  86.254  1.00 30.17          
ATOM   1420  CG  HSD   171      56.769   7.746  86.932  1.00 33.79          
ATOM   1421  ND1 HSD   171      55.731   6.993  86.424  1.00 36.44          
ATOM   1422  CD2 HSD   171      57.140   7.147  88.089  1.00 36.05          
ATOM   1423  CE1 HSD   171      55.503   5.966  87.225  1.00 37.12          
ATOM   1424  NE2 HSD   171      56.343   6.037  88.244  1.00 37.28          
ATOM   1425  N   ASP   172      56.759  11.031  88.617  1.00 28.48          
ATOM   1426  CA  ASP   172      56.457  11.347  90.008  0.50 28.54          
ATOM   1428  C   ASP   172      55.253  12.289  90.115  1.00 27.90          
ATOM   1429  O   ASP   172      54.340  12.065  90.929  1.00 27.33          
ATOM   1430  CB  ASP   172      57.686  11.961  90.689  0.50 29.24          
ATOM   1432  CG  ASP   172      57.489  12.207  92.190  0.50 31.34          
ATOM   1434  OD1 ASP   172      56.462  11.791  92.776  0.50 34.03          
ATOM   1436  OD2 ASP   172      58.388  12.823  92.797  0.50 33.97          
ATOM   1438  N   ILE   173      55.242  13.352  89.309  1.00 27.21          
ATOM   1439  CA  ILE   173      54.114  14.292  89.356  1.00 26.80          
ATOM   1440  C   ILE   173      52.846  13.543  88.987  1.00 27.04          
ATOM   1441  O   ILE   173      51.828  13.673  89.675  1.00 26.70          
ATOM   1442  CB  ILE   173      54.313  15.495  88.428  1.00 26.32          
ATOM   1443  CG1 ILE   173      55.455  16.353  88.959  1.00 28.14          
ATOM   1444  CG2 ILE   173      53.003  16.312  88.304  1.00 25.19          
ATOM   1445  CD  ILE   173      55.732  17.600  88.138  1.00 31.54          
ATOM   1446  N   THR   174      52.931  12.744  87.921  1.00 27.34          
ATOM   1447  CA  THR   174      51.781  11.965  87.422  1.00 27.90          
ATOM   1448  C   THR   174      51.231  11.020  88.508  1.00 28.01          
ATOM   1449  O   THR   174      50.020  10.972  88.735  1.00 28.15          
ATOM   1450  CB  THR   174      52.132  11.156  86.143  1.00 27.98          
ATOM   1451  OG1 THR   174      52.556  12.050  85.099  1.00 28.20          
ATOM   1452  CG2 THR   174      50.933  10.338  85.675  1.00 27.86          
ATOM   1453  N   GLU   175      52.130  10.276  89.156  0.50 27.94          
ATOM   1455  CA  GLU   175      51.761   9.383  90.258  0.50 28.08          
ATOM   1457  C   GLU   175      51.100  10.168  91.392  0.50 27.46          
ATOM   1459  O   GLU   175      50.031   9.787  91.878  0.50 27.74          
ATOM   1461  CB  GLU   175      52.989   8.607  90.779  0.50 27.87          
ATOM   1463  CG  GLU   175      52.683   7.643  91.927  0.50 29.24          
ATOM   1465  CD  GLU   175      53.737   6.539  92.115  0.50 29.46          
ATOM   1467  OE1 GLU   175      54.903   6.858  92.439  0.50 31.34          
ATOM   1469  OE2 GLU   175      53.390   5.345  91.963  0.50 31.65          
ATOM   1471  N   THR   176      51.735  11.264  91.798  1.00 26.86          
ATOM   1472  CA  THR   176      51.290  12.040  92.961  1.00 26.79          
ATOM   1473  C   THR   176      49.898  12.629  92.753  1.00 26.75          
ATOM   1474  O   THR   176      49.036  12.510  93.620  1.00 26.04          
ATOM   1475  CB  THR   176      52.302  13.134  93.336  1.00 27.14          
ATOM   1476  OG1 THR   176      53.559  12.502  93.631  1.00 27.24          
ATOM   1477  CG2 THR   176      51.835  13.934  94.563  1.00 27.58          
ATOM   1478  N   ILE   177      49.688  13.240  91.588  1.00 25.71          
ATOM   1479  CA  ILE   177      48.384  13.785  91.234  1.00 26.22          
ATOM   1480  C   ILE   177      47.297  12.715  91.081  1.00 26.28          
ATOM   1481  O   ILE   177      46.218  12.859  91.651  1.00 26.63          
ATOM   1482  CB  ILE   177      48.468  14.681  89.955  1.00 25.48          
ATOM   1483  CG1 ILE   177      49.376  15.896  90.198  1.00 26.11          
ATOM   1484  CG2 ILE   177      47.074  15.098  89.477  1.00 25.45          
ATOM   1485  CD  ILE   177      48.966  16.846  91.337  1.00 28.06          
ATOM   1486  N   THR   178      47.571  11.657  90.322  1.00 26.77          
ATOM   1487  CA  THR   178      46.582  10.592  90.107  1.00 27.62          
ATOM   1488  C   THR   178      46.105  10.020  91.439  1.00 28.01          
ATOM   1489  O   THR   178      44.894   9.869  91.655  1.00 28.34          
ATOM   1490  CB  THR   178      47.147   9.474  89.227  1.00 27.45          
ATOM   1491  OG1 THR   178      47.575  10.049  87.986  1.00 30.23          
ATOM   1492  CG2 THR   178      46.079   8.407  88.914  1.00 27.81          
ATOM   1493  N   LYS   179      47.056   9.726  92.329  1.00 28.10          
ATOM   1494  CA  LYS   179      46.759   9.198  93.667  1.00 29.30          
ATOM   1495  C   LYS   179      45.974  10.180  94.568  1.00 28.48          
ATOM   1496  O   LYS   179      45.034   9.781  95.254  1.00 28.59          
ATOM   1497  CB  LYS   179      48.072   8.748  94.344  1.00 28.31          
ATOM   1498  CG  LYS   179      47.945   7.921  95.595  1.00 32.52          
ATOM   1499  CD  LYS   179      49.318   7.282  95.904  1.00 31.76          
ATOM   1500  CE  LYS   179      49.357   6.506  97.228  1.00 36.71          
ATOM   1501  NZ  LYS   179      49.425   7.439  98.395  1.00 38.33          
ATOM   1502  N   ALA   180      46.353  11.455  94.583  1.00 28.41          
ATOM   1503  CA  ALA   180      45.706  12.417  95.473  1.00 28.03          
ATOM   1504  C   ALA   180      44.362  12.985  94.987  1.00 28.23          
ATOM   1505  O   ALA   180      43.579  13.493  95.802  1.00 26.75          
ATOM   1506  CB  ALA   180      46.671  13.569  95.819  1.00 28.73          
ATOM   1507  N   PHE   181      44.113  12.930  93.674  1.00 26.80          
ATOM   1508  CA  PHE   181      42.932  13.566  93.073  1.00 27.02          
ATOM   1509  C   PHE   181      42.165  12.637  92.124  1.00 26.89          
ATOM   1510  O   PHE   181      42.346  12.698  90.901  1.00 26.67          
ATOM   1511  CB  PHE   181      43.319  14.889  92.392  1.00 26.12          
ATOM   1512  CG  PHE   181      44.028  15.842  93.320  1.00 26.60          
ATOM   1513  CD1 PHE   181      43.305  16.619  94.221  1.00 26.91          
ATOM   1514  CD2 PHE   181      45.420  15.936  93.316  1.00 25.88          
ATOM   1515  CE1 PHE   181      43.960  17.502  95.105  1.00 26.01          
ATOM   1516  CE2 PHE   181      46.088  16.797  94.207  1.00 25.21          
ATOM   1517  CZ  PHE   181      45.350  17.580  95.101  1.00 26.35          
ATOM   1518  N   PRO   182      41.304  11.768  92.694  1.00 27.28          
ATOM   1519  CA  PRO   182      40.486  10.821  91.907  1.00 27.25          
ATOM   1520  C   PRO   182      39.524  11.513  90.933  1.00 26.41          
ATOM   1521  O   PRO   182      39.017  10.869  90.015  1.00 26.37          
ATOM   1522  CB  PRO   182      39.663  10.081  92.976  1.00 27.29          
ATOM   1523  CG  PRO   182      40.351  10.330  94.259  1.00 28.28          
ATOM   1524  CD  PRO   182      41.066  11.627  94.147  1.00 27.15          
ATOM   1525  N   ALA   183      39.257  12.803  91.146  1.00 25.54          
ATOM   1526  CA  ALA   183      38.359  13.520  90.247  1.00 24.99          
ATOM   1527  C   ALA   183      39.032  13.960  88.926  1.00 24.58          
ATOM   1528  O   ALA   183      38.354  14.481  88.032  1.00 24.53          
ATOM   1529  CB  ALA   183      37.714  14.717  90.954  1.00 24.64          
ATOM   1530  N   VAL   184      40.346  13.761  88.790  1.00 23.86          
ATOM   1531  CA  VAL   184      41.061  14.225  87.572  1.00 24.22          
ATOM   1532  C   VAL   184      41.838  13.083  86.933  1.00 23.90          
ATOM   1533  O   VAL   184      42.099  12.075  87.597  1.00 23.81          
ATOM   1534  CB  VAL   184      42.043  15.429  87.828  1.00 23.77          
ATOM   1535  CG1 VAL   184      41.318  16.626  88.477  1.00 26.01          
ATOM   1536  CG2 VAL   184      43.250  14.998  88.672  1.00 25.45          
ATOM   1537  N   ASP   185      42.204  13.253  85.654  1.00 23.63          
ATOM   1538  CA  ASP   185      43.120  12.365  84.960  1.00 24.73          
ATOM   1539  C   ASP   185      44.332  13.188  84.558  1.00 25.11          
ATOM   1540  O   ASP   185      44.217  14.401  84.317  1.00 24.08          
ATOM   1541  CB  ASP   185      42.485  11.796  83.673  1.00 24.93          
ATOM   1542  CG  ASP   185      41.478  10.655  83.947  1.00 29.15          
ATOM   1543  OD1 ASP   185      41.589  10.008  85.017  1.00 30.21          
ATOM   1544  OD2 ASP   185      40.571  10.410  83.105  1.00 28.23          
ATOM   1545  N   VAL   186      45.473  12.516  84.429  1.00 24.79          
ATOM   1546  CA  VAL   186      46.681  13.160  83.920  1.00 24.16          
ATOM   1547  C   VAL   186      46.963  12.609  82.524  1.00 24.33          
ATOM   1548  O   VAL   186      47.102  11.390  82.331  1.00 23.98          
ATOM   1549  CB  VAL   186      47.891  12.878  84.829  1.00 25.31          
ATOM   1550  CG1 VAL   186      49.156  13.472  84.224  1.00 25.57          
ATOM   1551  CG2 VAL   186      47.626  13.405  86.267  1.00 24.03          
ATOM   1552  N   ILE   187      47.088  13.510  81.564  1.00 23.30          
ATOM   1553  CA  ILE   187      47.397  13.144  80.183  1.00 23.86          
ATOM   1554  C   ILE   187      48.818  13.565  79.811  1.00 23.45          
ATOM   1555  O   ILE   187      49.156  14.734  79.908  1.00 22.45          
ATOM   1556  CB  ILE   187      46.362  13.718  79.202  1.00 23.85          
ATOM   1557  CG1 ILE   187      44.980  13.099  79.512  1.00 26.53          
ATOM   1558  CG2 ILE   187      46.795  13.383  77.735  1.00 25.15          
ATOM   1559  CD  ILE   187      43.812  13.706  78.758  1.00 28.72          
ATOM   1560  N   ARG   188      49.652  12.602  79.416  1.00 22.73          
ATOM   1561  CA  ARG   188      50.999  12.938  78.990  1.00 23.62          
ATOM   1562  C   ARG   188      50.960  13.434  77.527  1.00 23.19          
ATOM   1563  O   ARG   188      50.550  12.714  76.631  1.00 23.50          
ATOM   1564  CB  ARG   188      51.935  11.739  79.166  1.00 24.18          
ATOM   1565  CG  ARG   188      53.358  12.066  78.854  1.00 29.11          
ATOM   1566  CD  ARG   188      54.182  10.781  78.804  1.00 36.71          
ATOM   1567  NE  ARG   188      55.594  11.107  78.671  1.00 41.91          
ATOM   1568  CZ  ARG   188      56.399  10.631  77.732  1.00 46.11          
ATOM   1569  NH1 ARG   188      55.964   9.748  76.826  1.00 48.26          
ATOM   1570  NH2 ARG   188      57.670  11.012  77.731  1.00 47.42          
ATOM   1571  N   VAL   189      51.380  14.676  77.296  1.00 22.79          
ATOM   1572  CA  VAL   189      51.366  15.243  75.939  1.00 22.54          
ATOM   1573  C   VAL   189      52.673  14.936  75.255  1.00 22.95          
ATOM   1574  O   VAL   189      52.687  14.427  74.133  1.00 23.11          
ATOM   1575  CB  VAL   189      51.084  16.775  75.951  1.00 21.83          
ATOM   1576  CG1 VAL   189      51.130  17.328  74.544  1.00 24.12          
ATOM   1577  CG2 VAL   189      49.723  17.084  76.638  1.00 22.40          
ATOM   1578  N   ASN   190      53.782  15.206  75.947  1.00 23.34          
ATOM   1579  CA  ASN   190      55.124  14.939  75.427  1.00 23.37          
ATOM   1580  C   ASN   190      56.065  14.813  76.613  1.00 24.01          
ATOM   1581  O   ASN   190      55.602  14.805  77.748  1.00 24.05          
ATOM   1582  CB  ASN   190      55.562  16.020  74.427  1.00 23.41          
ATOM   1583  CG  ASN   190      55.572  17.438  75.040  1.00 23.59          
ATOM   1584  OD1 ASN   190      56.091  17.629  76.121  1.00 23.01          
ATOM   1585  ND2 ASN   190      55.007  18.420  74.335  1.00 23.21          
ATOM   1586  N   ASP   191      57.373  14.735  76.367  1.00 24.18          
ATOM   1587  CA  ASP   191      58.333  14.466  77.451  1.00 25.89          
ATOM   1588  C   ASP   191      58.420  15.569  78.507  1.00 25.25          
ATOM   1589  O   ASP   191      58.990  15.354  79.577  1.00 24.90          
ATOM   1590  CB  ASP   191      59.735  14.205  76.873  1.00 26.80          
ATOM   1591  CG  ASP   191      59.851  12.841  76.208  1.00 30.70          
ATOM   1592  OD1 ASP   191      58.883  12.044  76.297  1.00 35.89          
ATOM   1593  OD2 ASP   191      60.898  12.564  75.580  1.00 33.80          
ATOM   1594  N   GLU   192      57.895  16.749  78.185  1.00 24.14          
ATOM   1595  CA  GLU   192      57.988  17.905  79.073  1.00 25.47          
ATOM   1596  C   GLU   192      56.658  18.541  79.432  1.00 24.52          
ATOM   1597  O   GLU   192      56.637  19.507  80.170  1.00 25.59          
ATOM   1598  CB  GLU   192      58.917  18.950  78.460  1.00 26.31          
ATOM   1599  CG  GLU   192      60.369  18.442  78.432  1.00 30.67          
ATOM   1600  CD  GLU   192      61.278  19.187  77.468  1.00 37.45          
ATOM   1601  OE1 GLU   192      60.932  20.300  77.012  1.00 39.13          
ATOM   1602  OE2 GLU   192      62.358  18.640  77.164  1.00 40.53          
ATOM   1603  N   LYS   193      55.557  18.003  78.926  1.00 22.75          
ATOM   1604  CA  LYS   193      54.232  18.578  79.189  1.00 22.40          
ATOM   1605  C   LYS   193      53.193  17.535  79.579  1.00 22.60          
ATOM   1606  O   LYS   193      53.074  16.511  78.890  1.00 22.61          
ATOM   1607  CB  LYS   193      53.727  19.351  77.963  1.00 21.34          
ATOM   1608  CG  LYS   193      52.448  20.175  78.282  1.00 23.45          
ATOM   1609  CD  LYS   193      51.908  20.848  77.041  1.00 27.98          
ATOM   1610  CE  LYS   193      50.708  21.741  77.436  1.00 32.37          
ATOM   1611  NZ  LYS   193      50.217  22.474  76.221  1.00 37.14          
ATOM   1612  N   LEU   194      52.478  17.808  80.677  1.00 23.12          
ATOM   1613  CA  LEU   194      51.277  17.062  81.118  1.00 23.93          
ATOM   1614  C   LEU   194      50.053  17.994  81.145  1.00 23.51          
ATOM   1615  O   LEU   194      50.155  19.187  81.476  1.00 25.01          
ATOM   1616  CB  LEU   194      51.435  16.505  82.562  1.00 24.36          
ATOM   1617  CG  LEU   194      52.599  15.609  82.915  1.00 26.27          
ATOM   1618  CD1 LEU   194      52.728  15.487  84.438  1.00 26.26          
ATOM   1619  CD2 LEU   194      52.383  14.244  82.252  1.00 29.88          
ATOM   1620  N   ASN   195      48.897  17.436  80.825  1.00 22.85          
ATOM   1621  CA  ASN   195      47.627  18.098  81.067  1.00 23.97          
ATOM   1622  C   ASN   195      46.917  17.373  82.192  1.00 23.50          
ATOM   1623  O   ASN   195      46.808  16.141  82.175  1.00 25.44          
ATOM   1624  CB  ASN   195      46.741  18.018  79.828  1.00 24.15          
ATOM   1625  CG  ASN   195      47.229  18.904  78.700  1.00 26.20          
ATOM   1626  OD1 ASN   195      47.997  19.823  78.923  1.00 27.66          
ATOM   1627  ND2 ASN   195      46.767  18.629  77.484  1.00 28.00          
ATOM   1628  N   ILE   196      46.410  18.127  83.152  1.00 22.67          
ATOM   1629  CA  ILE   196      45.526  17.574  84.157  1.00 22.84          
ATOM   1630  C   ILE   196      44.096  18.024  83.788  1.00 23.07          
ATOM   1631  O   ILE   196      43.841  19.242  83.650  1.00 23.10          
ATOM   1632  CB  ILE   196      45.883  18.079  85.550  1.00 22.56          
ATOM   1633  CG1 ILE   196      47.321  17.667  85.909  1.00 24.46          
ATOM   1634  CG2 ILE   196      44.854  17.574  86.572  1.00 24.19          
ATOM   1635  CD  ILE   196      47.926  18.445  87.081  1.00 25.55          
ATOM   1636  N   VAL   197      43.189  17.055  83.641  1.00 22.22          
ATOM   1637  CA  VAL   197      41.827  17.312  83.118  1.00 21.63          
ATOM   1638  C   VAL   197      40.788  16.621  84.018  1.00 22.47          
ATOM   1639  O   VAL   197      41.141  15.737  84.810  1.00 22.16          
ATOM   1640  CB  VAL   197      41.641  16.791  81.641  1.00 20.72          
ATOM   1641  CG1 VAL   197      42.502  17.560  80.644  1.00 24.23          
ATOM   1642  CG2 VAL   197      41.948  15.267  81.541  1.00 19.32          
ATOM   1643  N   PRO   198      39.500  17.022  83.908  1.00 22.65          
ATOM   1644  CA  PRO   198      38.511  16.247  84.681  1.00 22.51          
ATOM   1645  C   PRO   198      38.528  14.774  84.265  1.00 22.53          
ATOM   1646  O   PRO   198      38.845  14.434  83.115  1.00 23.02          
ATOM   1647  CB  PRO   198      37.169  16.883  84.300  1.00 21.85          
ATOM   1648  CG  PRO   198      37.530  18.317  83.841  1.00 23.58          
ATOM   1649  CD  PRO   198      38.897  18.153  83.151  1.00 21.60          
ATOM   1650  N   LYS   199      38.157  13.897  85.186  1.00 22.88          
ATOM   1651  CA  LYS   199      38.168  12.474  84.881  1.00 22.86          
ATOM   1652  C   LYS   199      37.294  12.167  83.678  1.00 23.13          
ATOM   1653  O   LYS   199      36.173  12.663  83.556  1.00 23.11          
ATOM   1654  CB  LYS   199      37.757  11.642  86.114  1.00 23.14          
ATOM   1655  CG  LYS   199      37.963  10.141  85.884  1.00 26.25          
ATOM   1656  CD  LYS   199      38.082   9.393  87.188  1.00 31.96          
ATOM   1657  CE  LYS   199      38.436   7.907  86.975  1.00 36.76          
ATOM   1658  NZ  LYS   199      39.836   7.763  86.397  1.00 39.94          
ATOM   1659  N   GLY   200      37.830  11.360  82.770  1.00 23.34          
ATOM   1660  CA  GLY   200      37.103  10.945  81.573  1.00 24.15          
ATOM   1661  C   GLY   200      37.262  11.895  80.392  1.00 23.87          
ATOM   1662  O   GLY   200      36.852  11.566  79.278  1.00 24.98          
END
