
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1434),  selected   92 , name 2bud_A
# Molecule2: number of CA atoms  208 ( 1702),  selected  208 , name T0504.pdb
# PARAMETERS: 2bud_A.T0504.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   363_A      E       1           -
LGA    S   364_A      N       2           -
LGA    H   365_A      L       3           -
LGA    M   366_A      Y       4           -
LGA    D   367_A      -       -           -
LGA    P   368_A      -       -           -
LGA    L   369_A      -       -           -
LGA    M   370_A      -       -           -
LGA    Q   371_A      F       5           #
LGA    K   372_A      Q       6          2.793
LGA    -       -      G       7           -
LGA    I   373_A      D       8          3.881
LGA    D   374_A      L       9          3.442
LGA    I   375_A      I      10          1.583
LGA    S   376_A      V      11          5.277
LGA    E   377_A      -       -           -
LGA    N   378_A      -       -           -
LGA    P   379_A      -       -           -
LGA    D   380_A      S      12          4.746
LGA    K   381_A      M      13          3.177
LGA    I   382_A      R      14          1.242
LGA    Y   383_A      I      15          0.596
LGA    F   384_A      L      16          0.386
LGA    I   385_A      G      17          0.859
LGA    R   386_A      K      18          1.879
LGA    R   387_A      K      19          2.259
LGA    E   388_A      R      20          3.685
LGA    D   389_A      T      21          3.205
LGA    G   390_A      K      22          1.945
LGA    T   391_A      T      23          0.512
LGA    V   392_A      W      24          0.578
LGA    H   393_A      H      25          0.659
LGA    R   394_A      K      26          0.860
LGA    G   395_A      G      27          1.138
LGA    Q   396_A      T      28          0.513
LGA    V   397_A      L      29          0.764
LGA    L   398_A      I      30          1.180
LGA    Q   399_A      A      31          0.867
LGA    S   400_A      I      32          1.017
LGA    R   401_A      Q      33          0.924
LGA    T   402_A      T      34          1.062
LGA    T   403_A      V      35          0.706
LGA    E   404_A      G      36          3.607
LGA    N   405_A      -       -           -
LGA    A   406_A      -       -           -
LGA    A   407_A      P      37          2.836
LGA    A   408_A      -       -           -
LGA    P   409_A      G      38          0.454
LGA    D   410_A      K      39          0.412
LGA    E   411_A      K      40          0.415
LGA    Y   412_A      Y      41          0.935
LGA    Y   413_A      K      42          0.931
LGA    V   414_A      V      43          0.510
LGA    H   415_A      K      44          0.106
LGA    Y   416_A      F      45          0.298
LGA    V   417_A      D      46          0.537
LGA    G   418_A      N      47          1.796
LGA    L   419_A      K      48          2.027
LGA    N   420_A      -       -           -
LGA    R   421_A      -       -           -
LGA    R   422_A      -       -           -
LGA    L   423_A      G      49          2.769
LGA    D   424_A      K      50          0.795
LGA    G   425_A      S      51          2.381
LGA    W   426_A      L      52          0.866
LGA    V   427_A      L      53          0.862
LGA    G   428_A      S      54          0.856
LGA    R   429_A      G      55          0.871
LGA    H   430_A      N      56          0.805
LGA    R   431_A      H      57          0.519
LGA    I   432_A      I      58          0.959
LGA    S   433_A      A      59          1.630
LGA    D   434_A      Y      60          0.670
LGA    N   435_A      D      61          4.215
LGA    A   436_A      Y      62           #
LGA    D   437_A      H      63           #
LGA    -       -      P      64           -
LGA    -       -      P      65           -
LGA    -       -      A      66           -
LGA    -       -      D      67           -
LGA    -       -      K      68           -
LGA    -       -      L      69           -
LGA    -       -      Y      70           -
LGA    -       -      V      71           -
LGA    -       -      G      72           -
LGA    -       -      S      73           -
LGA    D   438_A      R      74          4.629
LGA    L   439_A      V      75          4.187
LGA    G   440_A      V      76          2.758
LGA    G   441_A      A      77          0.632
LGA    I   442_A      K      78          3.398
LGA    -       -      Y      79           -
LGA    -       -      K      80           -
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    -       -      Q      84           -
LGA    -       -      V      85           -
LGA    -       -      W      86           -
LGA    T   443_A      L      87          1.437
LGA    V   444_A      Y      88          3.377
LGA    -       -      A      89           -
LGA    -       -      G      90           -
LGA    -       -      I      91           -
LGA    -       -      V      92           -
LGA    -       -      A      93           -
LGA    -       -      E      94           -
LGA    -       -      T      95           -
LGA    -       -      P      96           -
LGA    -       -      N      97           -
LGA    -       -      V      98           -
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    -       -      K     101           -
LGA    -       -      L     102           -
LGA    -       -      R     103           -
LGA    -       -      F     104           -
LGA    -       -      L     105           -
LGA    -       -      I     106           -
LGA    L   445_A      F     107           #
LGA    P   446_A      F     108          1.113
LGA    -       -      D     109           -
LGA    -       -      D     110           -
LGA    -       -      G     111           -
LGA    A   447_A      Y     112          2.540
LGA    -       -      A     113           -
LGA    -       -      S     114           -
LGA    -       -      Y     115           -
LGA    -       -      V     116           -
LGA    -       -      T     117           -
LGA    -       -      Q     118           -
LGA    -       -      S     119           -
LGA    -       -      E     120           -
LGA    -       -      L     121           -
LGA    -       -      Y     122           -
LGA    -       -      P     123           -
LGA    -       -      I     124           -
LGA    -       -      C     125           -
LGA    -       -      R     126           -
LGA    -       -      P     127           -
LGA    -       -      L     128           -
LGA    -       -      K     129           -
LGA    -       -      K     130           -
LGA    -       -      T     131           -
LGA    -       -      W     132           -
LGA    -       -      E     133           -
LGA    -       -      D     134           -
LGA    -       -      I     135           -
LGA    -       -      E     136           -
LGA    -       -      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    P   448_A      C     140          4.361
LGA    P   449_A      R     141           #
LGA    L   450_A      D     142           #
LGA    A   451_A      F     143          1.933
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    P   452_A      Y     147          1.866
LGA    -       -      V     148           -
LGA    D   453_A      T     149          5.153
LGA    Q   454_A      A     150          2.845
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -
LGA    -       -      M     156           -
LGA    -       -      V     157           -
LGA    -       -      L     158           -
LGA    -       -      L     159           -
LGA    -       -      K     160           -
LGA    -       -      S     161           -
LGA    -       -      G     162           -
LGA    -       -      Q     163           -
LGA    -       -      L     164           -
LGA    -       -      I     165           -
LGA    -       -      K     166           -
LGA    -       -      T     167           -
LGA    -       -      E     168           -
LGA    -       -      W     169           -
LGA    -       -      E     170           -
LGA    -       -      G     171           -
LGA    -       -      T     172           -
LGA    -       -      W     173           -
LGA    -       -      W     174           -
LGA    -       -      K     175           -
LGA    -       -      S     176           -
LGA    -       -      R     177           -
LGA    -       -      V     178           -
LGA    -       -      E     179           -
LGA    -       -      E     180           -
LGA    -       -      V     181           -
LGA    -       -      D     182           -
LGA    -       -      G     183           -
LGA    -       -      S     184           -
LGA    -       -      L     185           -
LGA    -       -      V     186           -
LGA    -       -      R     187           -
LGA    -       -      I     188           -
LGA    -       -      L     189           -
LGA    -       -      F     190           -
LGA    -       -      L     191           -
LGA    -       -      D     192           -
LGA    -       -      D     193           -
LGA    -       -      K     194           -
LGA    -       -      R     195           -
LGA    -       -      C     196           -
LGA    -       -      E     197           -
LGA    -       -      W     198           -
LGA    -       -      I     199           -
LGA    -       -      Y     200           -
LGA    -       -      R     201           -
LGA    -       -      G     202           -
LGA    -       -      S     203           -
LGA    -       -      T     204           -
LGA    -       -      R     205           -
LGA    -       -      L     206           -
LGA    -       -      E     207           -
LGA    -       -      P     208           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92  208    5.0     69    2.28    11.59     26.089     2.902

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.763323 * X  +   0.635638 * Y  +   0.115332 * Z  +  37.039948
  Y_new =  -0.501167 * X  +  -0.695309 * Y  +   0.515148 * Z  +  67.879990
  Z_new =   0.407639 * X  +   0.335424 * Y  +   0.849306 * Z  +  -0.957832 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.376136   -2.765457  [ DEG:    21.5510   -158.4490 ]
  Theta =  -0.419867   -2.721725  [ DEG:   -24.0566   -155.9434 ]
  Phi   =  -2.560620    0.580972  [ DEG:  -146.7127     33.2873 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bud_A                                        
REMARK     2: T0504.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bud_A.T0504.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92  208   5.0   69   2.28   11.59  26.089
REMARK  ---------------------------------------------------------- 
MOLECULE 2bud_A
HEADER    TRANSFERASE                             09-JUN-05   2BUD              
TITLE     THE SOLUTION STRUCTURE OF THE CHROMO BARREL DOMAIN FROM THE           
TITLE    2 MALES-ABSENT ON THE FIRST (MOF) PROTEIN                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MALES-ABSENT ON THE FIRST PROTEIN;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CHROMO BARREL DOMAIN, RESIDUES 367-454;                    
COMPND   5 SYNONYM: PUTATIVE ACETYL TRANSFERASE MOF;                            
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DROSOPHILA MELANOGASTER;                        
SOURCE   3 ORGANISM_COMMON: FRUIT FLY;                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   6 EXPRESSION_SYSTEM_VARIANT: TUNER(DE3) PLACI;                         
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    MOF,HAT,ACETYL-TRANSFER,DOSAGE COMPENSATION COMPLEX,DCC,              
KEYWDS   2 ROYAL FAMILY,CHROMODOMAIN LIKE,BETA BARREL,TRANSFERASE               
KEYWDS   3 ACYLTRANSFERASE, METAL-BINDING                                       
EXPDTA    NMR, 25 STRUCTURES                                                    
AUTHOR    P.R.NIELSEN,D.NIETLISPACH,A.BUSCAINO,R.J.WARNER,A.AKHTAR,             
AUTHOR   2 A.G.MURZIN,N.V.MURZINA,E.D.LAUE                                      
REVDAT   2   15-SEP-05 2BUD    1       JRNL                                     
REVDAT   1   24-JUN-05 2BUD    0                                                
JRNL        AUTH   P.R.NIELSEN,D.NIETLISPACH,A.BUSCAINO,R.J.WARNER,             
JRNL        AUTH 2 A.AKHTAR,A.G.MURZIN,N.V.MURZINA,E.D.LAUE                     
JRNL        TITL   STRUCTURE OF THE CHROMO BARREL DOMAIN FROM THE MOF           
JRNL        TITL 2 ACETYLTRANSFERASE.                                           
JRNL        REF    J.BIOL.CHEM.                  V. 280 32326 2005              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2BUD A  363   366  UNP    O02193   MOF_DROME      363    366             
DBREF  2BUD A  367   454  UNP    O02193   MOF_DROME      367    454             
SEQRES   1 A   92  GLY SER HIS MET ASP PRO LEU MET GLN LYS ILE ASP ILE          
SEQRES   2 A   92  SER GLU ASN PRO ASP LYS ILE TYR PHE ILE ARG ARG GLU          
SEQRES   3 A   92  ASP GLY THR VAL HIS ARG GLY GLN VAL LEU GLN SER ARG          
SEQRES   4 A   92  THR THR GLU ASN ALA ALA ALA PRO ASP GLU TYR TYR VAL          
SEQRES   5 A   92  HIS TYR VAL GLY LEU ASN ARG ARG LEU ASP GLY TRP VAL          
SEQRES   6 A   92  GLY ARG HIS ARG ILE SER ASP ASN ALA ASP ASP LEU GLY          
SEQRES   7 A   92  GLY ILE THR VAL LEU PRO ALA PRO PRO LEU ALA PRO ASP          
SEQRES   8 A   92  GLN                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 363      22.960  80.781  -7.482  1.00 11.64           N  
ATOM      2  CA  GLY A 363      23.427  80.397  -8.845  1.00 11.03           C  
ATOM      3  C   GLY A 363      23.449  81.572  -9.803  1.00 10.23           C  
ATOM      4  O   GLY A 363      23.012  81.454 -10.948  1.00 10.21           O  
ATOM      5  H2  GLY A 363      22.800  79.929  -6.907  1.00 11.91           H  
ATOM      6  HA2 GLY A 363      24.424  79.990  -8.768  1.00 11.23           H  
ATOM      7  HA3 GLY A 363      22.768  79.638  -9.238  1.00 11.16           H  
ATOM      8  H1  GLY A 363      22.070  81.313  -7.546  1.00 11.74           H  
ATOM      9  H3  GLY A 363      23.674  81.375  -7.014  1.00 11.90           H  
ATOM     10  N   SER A 364      23.960  82.708  -9.334  1.00  9.80           N  
ATOM     11  CA  SER A 364      24.040  83.912 -10.155  1.00  9.25           C  
ATOM     12  C   SER A 364      24.829  85.003  -9.438  1.00  8.36           C  
ATOM     13  O   SER A 364      24.571  85.300  -8.272  1.00  8.24           O  
ATOM     14  CB  SER A 364      22.637  84.422 -10.490  1.00  9.60           C  
ATOM     15  OG  SER A 364      21.914  84.734  -9.312  1.00  9.86           O  
ATOM     16  H   SER A 364      24.292  82.736  -8.413  1.00 10.02           H  
ATOM     17  HA  SER A 364      24.550  83.657 -11.072  1.00  9.49           H  
ATOM     18  HB2 SER A 364      22.714  85.312 -11.096  1.00  9.79           H  
ATOM     19  HB3 SER A 364      22.100  83.660 -11.037  1.00  9.74           H  
ATOM     20  HG  SER A 364      21.254  84.056  -9.152  1.00 10.13           H  
ATOM     21  N   HIS A 365      25.788  85.591 -10.149  1.00  7.98           N  
ATOM     22  CA  HIS A 365      26.627  86.650  -9.592  1.00  7.35           C  
ATOM     23  C   HIS A 365      27.388  86.159  -8.363  1.00  6.30           C  
ATOM     24  O   HIS A 365      26.800  85.931  -7.306  1.00  6.44           O  
ATOM     25  CB  HIS A 365      25.777  87.871  -9.228  1.00  7.88           C  
ATOM     26  CG  HIS A 365      26.550  88.963  -8.554  1.00  7.65           C  
ATOM     27  ND1 HIS A 365      27.627  89.596  -9.137  1.00  7.18           N  
ATOM     28  CD2 HIS A 365      26.395  89.532  -7.334  1.00  8.07           C  
ATOM     29  CE1 HIS A 365      28.102  90.507  -8.306  1.00  7.26           C  
ATOM     30  NE2 HIS A 365      27.372  90.489  -7.206  1.00  7.79           N  
ATOM     31  H   HIS A 365      25.940  85.304 -11.074  1.00  8.31           H  
ATOM     32  HA  HIS A 365      27.342  86.936 -10.349  1.00  7.51           H  
ATOM     33  HB2 HIS A 365      25.345  88.280 -10.129  1.00  8.26           H  
ATOM     34  HB3 HIS A 365      24.985  87.562  -8.563  1.00  8.33           H  
ATOM     35  HD1 HIS A 365      27.990  89.405 -10.026  1.00  7.00           H  
ATOM     36  HD2 HIS A 365      25.643  89.280  -6.599  1.00  8.67           H  
ATOM     37  HE1 HIS A 365      28.943  91.158  -8.495  1.00  7.11           H  
ATOM     38  HE2 HIS A 365      27.568  90.995  -6.390  1.00  8.09           H  
ATOM     39  N   MET A 366      28.701  86.009  -8.508  1.00  5.51           N  
ATOM     40  CA  MET A 366      29.539  85.554  -7.407  1.00  4.67           C  
ATOM     41  C   MET A 366      29.682  86.642  -6.350  1.00  4.56           C  
ATOM     42  O   MET A 366      29.997  87.790  -6.665  1.00  4.71           O  
ATOM     43  CB  MET A 366      30.919  85.140  -7.925  1.00  4.15           C  
ATOM     44  CG  MET A 366      30.877  84.000  -8.930  1.00  3.72           C  
ATOM     45  SD  MET A 366      30.188  82.484  -8.234  1.00  3.31           S  
ATOM     46  CE  MET A 366      30.290  81.381  -9.643  1.00  2.76           C  
ATOM     47  H   MET A 366      29.113  86.214  -9.373  1.00  5.70           H  
ATOM     48  HA  MET A 366      29.061  84.695  -6.959  1.00  4.86           H  
ATOM     49  HB2 MET A 366      31.383  85.993  -8.400  1.00  4.39           H  
ATOM     50  HB3 MET A 366      31.527  84.831  -7.089  1.00  4.31           H  
ATOM     51  HG2 MET A 366      30.268  84.299  -9.770  1.00  4.07           H  
ATOM     52  HG3 MET A 366      31.881  83.799  -9.270  1.00  3.90           H  
ATOM     53  HE1 MET A 366      30.955  81.801 -10.383  1.00  2.90           H  
ATOM     54  HE2 MET A 366      30.670  80.421  -9.323  1.00  2.96           H  
ATOM     55  HE3 MET A 366      29.307  81.255 -10.073  1.00  2.91           H  
ATOM     56  N   ASP A 367      29.452  86.273  -5.094  1.00  4.67           N  
ATOM     57  CA  ASP A 367      29.557  87.215  -3.984  1.00  4.80           C  
ATOM     58  C   ASP A 367      30.970  87.791  -3.901  1.00  4.50           C  
ATOM     59  O   ASP A 367      31.934  87.138  -4.299  1.00  4.10           O  
ATOM     60  CB  ASP A 367      29.188  86.529  -2.668  1.00  4.92           C  
ATOM     61  CG  ASP A 367      27.757  86.030  -2.657  1.00  5.55           C  
ATOM     62  OD1 ASP A 367      26.838  86.863  -2.806  1.00  6.06           O  
ATOM     63  OD2 ASP A 367      27.555  84.808  -2.501  1.00  5.80           O  
ATOM     64  H   ASP A 367      29.206  85.342  -4.908  1.00  4.91           H  
ATOM     65  HA  ASP A 367      28.863  88.021  -4.168  1.00  5.35           H  
ATOM     66  HB2 ASP A 367      29.845  85.685  -2.513  1.00  4.64           H  
ATOM     67  HB3 ASP A 367      29.313  87.231  -1.857  1.00  5.17           H  
ATOM     68  N   PRO A 368      31.110  89.032  -3.392  1.00  4.98           N  
ATOM     69  CA  PRO A 368      32.415  89.693  -3.266  1.00  5.12           C  
ATOM     70  C   PRO A 368      33.273  89.104  -2.147  1.00  5.15           C  
ATOM     71  O   PRO A 368      33.974  89.830  -1.443  1.00  5.66           O  
ATOM     72  CB  PRO A 368      32.045  91.142  -2.948  1.00  5.90           C  
ATOM     73  CG  PRO A 368      30.725  91.050  -2.267  1.00  6.16           C  
ATOM     74  CD  PRO A 368      30.011  89.888  -2.904  1.00  5.69           C  
ATOM     75  HA  PRO A 368      32.966  89.657  -4.195  1.00  4.98           H  
ATOM     76  HB2 PRO A 368      32.795  91.574  -2.303  1.00  6.24           H  
ATOM     77  HB3 PRO A 368      31.977  91.710  -3.864  1.00  6.10           H  
ATOM     78  HG2 PRO A 368      30.868  90.869  -1.212  1.00  6.43           H  
ATOM     79  HG3 PRO A 368      30.167  91.962  -2.420  1.00  6.59           H  
ATOM     80  HD2 PRO A 368      29.413  89.366  -2.171  1.00  5.88           H  
ATOM     81  HD3 PRO A 368      29.393  90.226  -3.722  1.00  5.87           H  
ATOM     82  N   LEU A 369      33.213  87.785  -1.994  1.00  4.84           N  
ATOM     83  CA  LEU A 369      33.978  87.089  -0.970  1.00  5.12           C  
ATOM     84  C   LEU A 369      33.903  85.584  -1.181  1.00  4.61           C  
ATOM     85  O   LEU A 369      34.898  84.876  -1.028  1.00  4.91           O  
ATOM     86  CB  LEU A 369      33.462  87.462   0.423  1.00  5.80           C  
ATOM     87  CG  LEU A 369      34.180  86.799   1.610  1.00  6.34           C  
ATOM     88  CD1 LEU A 369      33.645  85.394   1.852  1.00  6.73           C  
ATOM     89  CD2 LEU A 369      35.685  86.754   1.376  1.00  6.94           C  
ATOM     90  H   LEU A 369      32.638  87.265  -2.583  1.00  4.61           H  
ATOM     91  HA  LEU A 369      35.008  87.401  -1.057  1.00  5.45           H  
ATOM     92  HB2 LEU A 369      33.544  88.532   0.532  1.00  6.13           H  
ATOM     93  HB3 LEU A 369      32.417  87.196   0.474  1.00  5.89           H  
ATOM     94  HG  LEU A 369      33.998  87.380   2.503  1.00  6.42           H  
ATOM     95 HD11 LEU A 369      32.671  85.297   1.396  1.00  7.08           H  
ATOM     96 HD12 LEU A 369      34.320  84.672   1.415  1.00  6.77           H  
ATOM     97 HD13 LEU A 369      33.565  85.216   2.914  1.00  6.95           H  
ATOM     98 HD21 LEU A 369      35.984  87.613   0.795  1.00  7.21           H  
ATOM     99 HD22 LEU A 369      36.198  86.765   2.327  1.00  7.21           H  
ATOM    100 HD23 LEU A 369      35.938  85.850   0.840  1.00  7.18           H  
ATOM    101  N   MET A 370      32.717  85.102  -1.536  1.00  4.12           N  
ATOM    102  CA  MET A 370      32.513  83.678  -1.772  1.00  3.87           C  
ATOM    103  C   MET A 370      33.065  83.275  -3.143  1.00  3.02           C  
ATOM    104  O   MET A 370      32.518  82.402  -3.816  1.00  3.06           O  
ATOM    105  CB  MET A 370      31.021  83.341  -1.672  1.00  4.63           C  
ATOM    106  CG  MET A 370      30.718  81.850  -1.670  1.00  5.03           C  
ATOM    107  SD  MET A 370      31.507  80.981  -0.301  1.00  5.63           S  
ATOM    108  CE  MET A 370      30.927  79.310  -0.580  1.00  5.52           C  
ATOM    109  H   MET A 370      31.962  85.717  -1.644  1.00  4.15           H  
ATOM    110  HA  MET A 370      33.050  83.137  -1.006  1.00  4.18           H  
ATOM    111  HB2 MET A 370      30.630  83.765  -0.757  1.00  5.14           H  
ATOM    112  HB3 MET A 370      30.507  83.788  -2.510  1.00  4.81           H  
ATOM    113  HG2 MET A 370      29.649  81.713  -1.595  1.00  5.22           H  
ATOM    114  HG3 MET A 370      31.069  81.424  -2.599  1.00  5.24           H  
ATOM    115  HE1 MET A 370      30.740  79.164  -1.634  1.00  5.67           H  
ATOM    116  HE2 MET A 370      31.678  78.608  -0.246  1.00  5.67           H  
ATOM    117  HE3 MET A 370      30.012  79.149  -0.028  1.00  5.59           H  
ATOM    118  N   GLN A 371      34.156  83.920  -3.546  1.00  2.80           N  
ATOM    119  CA  GLN A 371      34.792  83.633  -4.828  1.00  2.63           C  
ATOM    120  C   GLN A 371      35.675  82.395  -4.723  1.00  2.21           C  
ATOM    121  O   GLN A 371      36.890  82.485  -4.890  1.00  2.80           O  
ATOM    122  CB  GLN A 371      35.621  84.830  -5.295  1.00  3.46           C  
ATOM    123  CG  GLN A 371      34.802  86.096  -5.491  1.00  3.91           C  
ATOM    124  CD  GLN A 371      35.627  87.274  -5.984  1.00  4.54           C  
ATOM    125  OE1 GLN A 371      35.099  88.369  -6.186  1.00  4.97           O  
ATOM    126  NE2 GLN A 371      36.924  87.061  -6.184  1.00  5.04           N  
ATOM    127  H   GLN A 371      34.549  84.604  -2.967  1.00  3.22           H  
ATOM    128  HA  GLN A 371      34.011  83.442  -5.549  1.00  2.81           H  
ATOM    129  HB2 GLN A 371      36.386  85.032  -4.559  1.00  3.90           H  
ATOM    130  HB3 GLN A 371      36.093  84.582  -6.234  1.00  3.78           H  
ATOM    131  HG2 GLN A 371      34.025  85.896  -6.214  1.00  3.97           H  
ATOM    132  HG3 GLN A 371      34.350  86.365  -4.547  1.00  4.18           H  
ATOM    133 HE21 GLN A 371      37.281  86.167  -6.006  1.00  5.03           H  
ATOM    134 HE22 GLN A 371      37.471  87.808  -6.504  1.00  5.61           H  
ATOM    135  N   LYS A 372      35.042  81.254  -4.431  1.00  1.82           N  
ATOM    136  CA  LYS A 372      35.724  79.961  -4.277  1.00  1.77           C  
ATOM    137  C   LYS A 372      36.880  80.030  -3.275  1.00  1.50           C  
ATOM    138  O   LYS A 372      37.644  80.994  -3.241  1.00  1.89           O  
ATOM    139  CB  LYS A 372      36.196  79.393  -5.628  1.00  2.26           C  
ATOM    140  CG  LYS A 372      37.200  80.251  -6.379  1.00  2.93           C  
ATOM    141  CD  LYS A 372      37.663  79.570  -7.656  1.00  3.98           C  
ATOM    142  CE  LYS A 372      38.650  80.434  -8.426  1.00  4.77           C  
ATOM    143  NZ  LYS A 372      39.119  79.763  -9.671  1.00  5.39           N  
ATOM    144  H   LYS A 372      34.072  81.282  -4.305  1.00  2.14           H  
ATOM    145  HA  LYS A 372      34.990  79.279  -3.870  1.00  2.10           H  
ATOM    146  HB2 LYS A 372      36.651  78.430  -5.453  1.00  2.35           H  
ATOM    147  HB3 LYS A 372      35.332  79.255  -6.262  1.00  2.71           H  
ATOM    148  HG2 LYS A 372      36.733  81.191  -6.635  1.00  3.14           H  
ATOM    149  HG3 LYS A 372      38.054  80.432  -5.744  1.00  3.02           H  
ATOM    150  HD2 LYS A 372      38.142  78.635  -7.401  1.00  4.25           H  
ATOM    151  HD3 LYS A 372      36.805  79.375  -8.282  1.00  4.37           H  
ATOM    152  HE2 LYS A 372      38.167  81.362  -8.689  1.00  5.03           H  
ATOM    153  HE3 LYS A 372      39.500  80.635  -7.794  1.00  5.07           H  
ATOM    154  HZ1 LYS A 372      38.485  78.974  -9.913  1.00  5.55           H  
ATOM    155  HZ2 LYS A 372      39.130  80.439 -10.460  1.00  5.68           H  
ATOM    156  HZ3 LYS A 372      40.081  79.389  -9.536  1.00  5.78           H  
ATOM    157  N   ILE A 373      36.983  78.996  -2.442  1.00  1.42           N  
ATOM    158  CA  ILE A 373      38.021  78.921  -1.417  1.00  1.22           C  
ATOM    159  C   ILE A 373      39.407  79.229  -1.977  1.00  1.13           C  
ATOM    160  O   ILE A 373      39.832  78.646  -2.975  1.00  1.20           O  
ATOM    161  CB  ILE A 373      38.049  77.527  -0.755  1.00  1.16           C  
ATOM    162  CG1 ILE A 373      36.733  77.261  -0.021  1.00  1.40           C  
ATOM    163  CG2 ILE A 373      39.231  77.407   0.198  1.00  1.26           C  
ATOM    164  CD1 ILE A 373      36.667  75.898   0.637  1.00  1.48           C  
ATOM    165  H   ILE A 373      36.335  78.265  -2.515  1.00  1.86           H  
ATOM    166  HA  ILE A 373      37.785  79.649  -0.654  1.00  1.44           H  
ATOM    167  HB  ILE A 373      38.172  76.788  -1.532  1.00  1.17           H  
ATOM    168 HG12 ILE A 373      36.601  78.006   0.751  1.00  1.60           H  
ATOM    169 HG13 ILE A 373      35.916  77.331  -0.723  1.00  1.77           H  
ATOM    170 HG21 ILE A 373      39.866  78.274   0.093  1.00  1.69           H  
ATOM    171 HG22 ILE A 373      38.869  77.345   1.213  1.00  1.62           H  
ATOM    172 HG23 ILE A 373      39.794  76.517  -0.038  1.00  1.63           H  
ATOM    173 HD11 ILE A 373      37.545  75.328   0.374  1.00  1.86           H  
ATOM    174 HD12 ILE A 373      36.622  76.017   1.709  1.00  1.77           H  
ATOM    175 HD13 ILE A 373      35.785  75.376   0.296  1.00  1.93           H  
ATOM    176  N   ASP A 374      40.109  80.143  -1.310  1.00  1.16           N  
ATOM    177  CA  ASP A 374      41.456  80.528  -1.717  1.00  1.17           C  
ATOM    178  C   ASP A 374      42.497  79.642  -1.041  1.00  1.03           C  
ATOM    179  O   ASP A 374      42.460  79.445   0.172  1.00  1.25           O  
ATOM    180  CB  ASP A 374      41.719  81.994  -1.365  1.00  1.40           C  
ATOM    181  CG  ASP A 374      40.834  82.945  -2.146  1.00  1.77           C  
ATOM    182  OD1 ASP A 374      40.913  82.939  -3.393  1.00  2.04           O  
ATOM    183  OD2 ASP A 374      40.065  83.698  -1.512  1.00  2.17           O  
ATOM    184  H   ASP A 374      39.714  80.562  -0.517  1.00  1.29           H  
ATOM    185  HA  ASP A 374      41.531  80.404  -2.786  1.00  1.24           H  
ATOM    186  HB2 ASP A 374      41.530  82.142  -0.313  1.00  1.49           H  
ATOM    187  HB3 ASP A 374      42.751  82.230  -1.577  1.00  1.43           H  
ATOM    188  N   ILE A 375      43.421  79.111  -1.830  1.00  0.84           N  
ATOM    189  CA  ILE A 375      44.469  78.250  -1.297  1.00  0.76           C  
ATOM    190  C   ILE A 375      45.609  79.066  -0.703  1.00  0.76           C  
ATOM    191  O   ILE A 375      46.119  78.743   0.368  1.00  0.79           O  
ATOM    192  CB  ILE A 375      45.036  77.311  -2.374  1.00  0.77           C  
ATOM    193  CG1 ILE A 375      43.942  76.368  -2.878  1.00  0.82           C  
ATOM    194  CG2 ILE A 375      46.217  76.530  -1.816  1.00  0.84           C  
ATOM    195  CD1 ILE A 375      44.388  75.467  -4.009  1.00  0.92           C  
ATOM    196  H   ILE A 375      43.401  79.304  -2.790  1.00  0.92           H  
ATOM    197  HA  ILE A 375      44.033  77.645  -0.518  1.00  0.81           H  
ATOM    198  HB  ILE A 375      45.391  77.915  -3.197  1.00  0.83           H  
ATOM    199 HG12 ILE A 375      43.615  75.738  -2.064  1.00  0.98           H  
ATOM    200 HG13 ILE A 375      43.104  76.954  -3.231  1.00  1.01           H  
ATOM    201 HG21 ILE A 375      46.789  77.169  -1.155  1.00  1.34           H  
ATOM    202 HG22 ILE A 375      45.857  75.676  -1.261  1.00  1.37           H  
ATOM    203 HG23 ILE A 375      46.846  76.196  -2.626  1.00  1.30           H  
ATOM    204 HD11 ILE A 375      45.280  74.935  -3.714  1.00  1.43           H  
ATOM    205 HD12 ILE A 375      43.605  74.758  -4.235  1.00  1.35           H  
ATOM    206 HD13 ILE A 375      44.596  76.063  -4.883  1.00  1.44           H  
ATOM    207  N   SER A 376      46.009  80.113  -1.416  1.00  0.79           N  
ATOM    208  CA  SER A 376      47.097  80.980  -0.976  1.00  0.87           C  
ATOM    209  C   SER A 376      46.726  81.727   0.299  1.00  0.96           C  
ATOM    210  O   SER A 376      46.451  82.926   0.277  1.00  1.54           O  
ATOM    211  CB  SER A 376      47.464  81.969  -2.078  1.00  0.95           C  
ATOM    212  OG  SER A 376      46.348  82.757  -2.456  1.00  1.71           O  
ATOM    213  H   SER A 376      45.562  80.306  -2.267  1.00  0.81           H  
ATOM    214  HA  SER A 376      47.952  80.354  -0.772  1.00  0.88           H  
ATOM    215  HB2 SER A 376      48.248  82.625  -1.726  1.00  1.35           H  
ATOM    216  HB3 SER A 376      47.812  81.423  -2.937  1.00  1.34           H  
ATOM    217  HG  SER A 376      46.533  83.198  -3.288  1.00  2.20           H  
ATOM    218  N   GLU A 377      46.726  81.000   1.408  1.00  0.93           N  
ATOM    219  CA  GLU A 377      46.394  81.565   2.704  1.00  1.03           C  
ATOM    220  C   GLU A 377      46.627  80.532   3.796  1.00  0.87           C  
ATOM    221  O   GLU A 377      46.901  80.871   4.947  1.00  0.93           O  
ATOM    222  CB  GLU A 377      44.941  82.041   2.732  1.00  1.18           C  
ATOM    223  CG  GLU A 377      43.924  80.926   2.550  1.00  1.28           C  
ATOM    224  CD  GLU A 377      42.498  81.408   2.734  1.00  1.54           C  
ATOM    225  OE1 GLU A 377      42.169  81.874   3.846  1.00  1.90           O  
ATOM    226  OE2 GLU A 377      41.711  81.321   1.769  1.00  1.92           O  
ATOM    227  H   GLU A 377      46.959  80.051   1.353  1.00  1.26           H  
ATOM    228  HA  GLU A 377      47.047  82.404   2.873  1.00  1.21           H  
ATOM    229  HB2 GLU A 377      44.749  82.522   3.677  1.00  1.72           H  
ATOM    230  HB3 GLU A 377      44.798  82.759   1.939  1.00  1.51           H  
ATOM    231  HG2 GLU A 377      44.026  80.521   1.554  1.00  1.35           H  
ATOM    232  HG3 GLU A 377      44.125  80.152   3.275  1.00  1.79           H  
ATOM    233  N   ASN A 378      46.516  79.266   3.414  1.00  0.71           N  
ATOM    234  CA  ASN A 378      46.713  78.160   4.346  1.00  0.61           C  
ATOM    235  C   ASN A 378      46.880  76.830   3.608  1.00  0.58           C  
ATOM    236  O   ASN A 378      46.124  75.886   3.839  1.00  0.59           O  
ATOM    237  CB  ASN A 378      45.541  78.076   5.338  1.00  0.62           C  
ATOM    238  CG  ASN A 378      44.181  78.022   4.660  1.00  1.15           C  
ATOM    239  OD1 ASN A 378      43.154  78.235   5.301  1.00  1.16           O  
ATOM    240  ND2 ASN A 378      44.165  77.712   3.370  1.00  2.14           N  
ATOM    241  H   ASN A 378      46.297  79.072   2.476  1.00  0.72           H  
ATOM    242  HA  ASN A 378      47.620  78.359   4.899  1.00  0.66           H  
ATOM    243  HB2 ASN A 378      45.654  77.185   5.937  1.00  1.18           H  
ATOM    244  HB3 ASN A 378      45.566  78.938   5.986  1.00  1.15           H  
ATOM    245 HD21 ASN A 378      45.016  77.530   2.926  1.00  2.14           H  
ATOM    246 HD22 ASN A 378      43.298  77.680   2.915  1.00  2.89           H  
ATOM    247  N   PRO A 379      47.879  76.729   2.709  1.00  0.62           N  
ATOM    248  CA  PRO A 379      48.130  75.498   1.952  1.00  0.65           C  
ATOM    249  C   PRO A 379      48.283  74.294   2.874  1.00  0.61           C  
ATOM    250  O   PRO A 379      47.803  73.200   2.572  1.00  0.62           O  
ATOM    251  CB  PRO A 379      49.444  75.784   1.221  1.00  0.77           C  
ATOM    252  CG  PRO A 379      49.515  77.269   1.129  1.00  0.85           C  
ATOM    253  CD  PRO A 379      48.841  77.793   2.367  1.00  0.75           C  
ATOM    254  HA  PRO A 379      47.346  75.306   1.234  1.00  0.67           H  
ATOM    255  HB2 PRO A 379      50.271  75.382   1.792  1.00  0.80           H  
ATOM    256  HB3 PRO A 379      49.421  75.329   0.243  1.00  0.85           H  
ATOM    257  HG2 PRO A 379      50.546  77.587   1.100  1.00  0.98           H  
ATOM    258  HG3 PRO A 379      48.991  77.608   0.247  1.00  0.95           H  
ATOM    259  HD2 PRO A 379      49.562  77.930   3.159  1.00  0.80           H  
ATOM    260  HD3 PRO A 379      48.331  78.721   2.155  1.00  0.80           H  
ATOM    261  N   ASP A 380      48.951  74.512   4.000  1.00  0.62           N  
ATOM    262  CA  ASP A 380      49.171  73.459   4.983  1.00  0.64           C  
ATOM    263  C   ASP A 380      47.846  72.972   5.566  1.00  0.55           C  
ATOM    264  O   ASP A 380      47.709  71.800   5.916  1.00  0.55           O  
ATOM    265  CB  ASP A 380      50.079  73.966   6.104  1.00  0.75           C  
ATOM    266  CG  ASP A 380      51.452  74.359   5.600  1.00  0.86           C  
ATOM    267  OD1 ASP A 380      52.154  73.485   5.045  1.00  1.21           O  
ATOM    268  OD2 ASP A 380      51.828  75.539   5.758  1.00  1.20           O  
ATOM    269  H   ASP A 380      49.302  75.410   4.179  1.00  0.65           H  
ATOM    270  HA  ASP A 380      49.655  72.635   4.485  1.00  0.68           H  
ATOM    271  HB2 ASP A 380      49.623  74.830   6.564  1.00  0.73           H  
ATOM    272  HB3 ASP A 380      50.194  73.187   6.846  1.00  0.79           H  
ATOM    273  N   LYS A 381      46.879  73.881   5.672  1.00  0.51           N  
ATOM    274  CA  LYS A 381      45.566  73.545   6.219  1.00  0.47           C  
ATOM    275  C   LYS A 381      44.991  72.304   5.544  1.00  0.39           C  
ATOM    276  O   LYS A 381      44.901  72.236   4.319  1.00  0.37           O  
ATOM    277  CB  LYS A 381      44.598  74.719   6.049  1.00  0.50           C  
ATOM    278  CG  LYS A 381      43.200  74.433   6.573  1.00  0.52           C  
ATOM    279  CD  LYS A 381      42.234  75.559   6.247  1.00  0.59           C  
ATOM    280  CE  LYS A 381      40.828  75.240   6.728  1.00  0.67           C  
ATOM    281  NZ  LYS A 381      39.845  76.273   6.297  1.00  1.66           N  
ATOM    282  H   LYS A 381      47.052  74.801   5.380  1.00  0.53           H  
ATOM    283  HA  LYS A 381      45.689  73.346   7.271  1.00  0.51           H  
ATOM    284  HB2 LYS A 381      44.991  75.574   6.579  1.00  0.56           H  
ATOM    285  HB3 LYS A 381      44.525  74.961   4.999  1.00  0.50           H  
ATOM    286  HG2 LYS A 381      42.841  73.525   6.119  1.00  0.48           H  
ATOM    287  HG3 LYS A 381      43.246  74.307   7.645  1.00  0.55           H  
ATOM    288  HD2 LYS A 381      42.573  76.462   6.732  1.00  0.64           H  
ATOM    289  HD3 LYS A 381      42.214  75.706   5.177  1.00  0.60           H  
ATOM    290  HE2 LYS A 381      40.531  74.284   6.325  1.00  1.17           H  
ATOM    291  HE3 LYS A 381      40.833  75.189   7.806  1.00  1.04           H  
ATOM    292  HZ1 LYS A 381      40.340  77.143   6.017  1.00  2.16           H  
ATOM    293  HZ2 LYS A 381      39.293  75.925   5.487  1.00  2.27           H  
ATOM    294  HZ3 LYS A 381      39.193  76.493   7.078  1.00  2.11           H  
ATOM    295  N   ILE A 382      44.597  71.325   6.355  1.00  0.40           N  
ATOM    296  CA  ILE A 382      44.025  70.088   5.838  1.00  0.35           C  
ATOM    297  C   ILE A 382      42.536  70.258   5.557  1.00  0.34           C  
ATOM    298  O   ILE A 382      41.780  70.684   6.429  1.00  0.41           O  
ATOM    299  CB  ILE A 382      44.213  68.923   6.831  1.00  0.37           C  
ATOM    300  CG1 ILE A 382      45.695  68.751   7.184  1.00  0.38           C  
ATOM    301  CG2 ILE A 382      43.644  67.633   6.258  1.00  0.41           C  
ATOM    302  CD1 ILE A 382      46.579  68.459   5.990  1.00  0.37           C  
ATOM    303  H   ILE A 382      44.693  71.439   7.323  1.00  0.47           H  
ATOM    304  HA  ILE A 382      44.533  69.839   4.918  1.00  0.35           H  
ATOM    305  HB  ILE A 382      43.665  69.158   7.731  1.00  0.41           H  
ATOM    306 HG12 ILE A 382      46.056  69.659   7.644  1.00  0.40           H  
ATOM    307 HG13 ILE A 382      45.798  67.934   7.882  1.00  0.42           H  
ATOM    308 HG21 ILE A 382      42.950  67.868   5.465  1.00  1.13           H  
ATOM    309 HG22 ILE A 382      44.447  67.027   5.865  1.00  1.07           H  
ATOM    310 HG23 ILE A 382      43.130  67.088   7.036  1.00  1.06           H  
ATOM    311 HD11 ILE A 382      45.963  68.171   5.149  1.00  1.05           H  
ATOM    312 HD12 ILE A 382      47.145  69.342   5.735  1.00  1.03           H  
ATOM    313 HD13 ILE A 382      47.256  67.654   6.232  1.00  1.10           H  
ATOM    314  N   TYR A 383      42.113  69.916   4.343  1.00  0.30           N  
ATOM    315  CA  TYR A 383      40.708  70.031   3.978  1.00  0.30           C  
ATOM    316  C   TYR A 383      40.030  68.667   4.008  1.00  0.28           C  
ATOM    317  O   TYR A 383      40.632  67.657   3.650  1.00  0.25           O  
ATOM    318  CB  TYR A 383      40.551  70.671   2.593  1.00  0.32           C  
ATOM    319  CG  TYR A 383      41.006  72.111   2.533  1.00  0.36           C  
ATOM    320  CD1 TYR A 383      42.344  72.445   2.696  1.00  0.40           C  
ATOM    321  CD2 TYR A 383      40.094  73.137   2.313  1.00  0.48           C  
ATOM    322  CE1 TYR A 383      42.762  73.761   2.640  1.00  0.48           C  
ATOM    323  CE2 TYR A 383      40.505  74.455   2.256  1.00  0.55           C  
ATOM    324  CZ  TYR A 383      41.838  74.761   2.419  1.00  0.52           C  
ATOM    325  OH  TYR A 383      42.250  76.072   2.361  1.00  0.63           O  
ATOM    326  H   TYR A 383      42.756  69.573   3.684  1.00  0.31           H  
ATOM    327  HA  TYR A 383      40.231  70.666   4.710  1.00  0.34           H  
ATOM    328  HB2 TYR A 383      41.135  70.115   1.873  1.00  0.31           H  
ATOM    329  HB3 TYR A 383      39.511  70.639   2.304  1.00  0.35           H  
ATOM    330  HD1 TYR A 383      43.065  71.658   2.868  1.00  0.44           H  
ATOM    331  HD2 TYR A 383      39.049  72.895   2.189  1.00  0.58           H  
ATOM    332  HE1 TYR A 383      43.807  74.003   2.768  1.00  0.58           H  
ATOM    333  HE2 TYR A 383      39.782  75.238   2.084  1.00  0.68           H  
ATOM    334  HH  TYR A 383      41.683  76.611   2.918  1.00  1.10           H  
ATOM    335  N   PHE A 384      38.775  68.644   4.440  1.00  0.31           N  
ATOM    336  CA  PHE A 384      38.016  67.401   4.515  1.00  0.30           C  
ATOM    337  C   PHE A 384      37.233  67.181   3.225  1.00  0.28           C  
ATOM    338  O   PHE A 384      36.685  68.126   2.658  1.00  0.33           O  
ATOM    339  CB  PHE A 384      37.060  67.420   5.713  1.00  0.40           C  
ATOM    340  CG  PHE A 384      37.742  67.590   7.044  1.00  0.48           C  
ATOM    341  CD1 PHE A 384      38.479  68.729   7.329  1.00  0.83           C  
ATOM    342  CD2 PHE A 384      37.637  66.607   8.015  1.00  0.57           C  
ATOM    343  CE1 PHE A 384      39.099  68.882   8.556  1.00  0.96           C  
ATOM    344  CE2 PHE A 384      38.253  66.755   9.244  1.00  0.64           C  
ATOM    345  CZ  PHE A 384      38.986  67.894   9.513  1.00  0.74           C  
ATOM    346  H   PHE A 384      38.347  69.483   4.714  1.00  0.35           H  
ATOM    347  HA  PHE A 384      38.719  66.591   4.637  1.00  0.30           H  
ATOM    348  HB2 PHE A 384      36.358  68.232   5.590  1.00  0.45           H  
ATOM    349  HB3 PHE A 384      36.516  66.487   5.736  1.00  0.44           H  
ATOM    350  HD1 PHE A 384      38.569  69.503   6.582  1.00  1.11           H  
ATOM    351  HD2 PHE A 384      37.066  65.714   7.806  1.00  0.82           H  
ATOM    352  HE1 PHE A 384      39.671  69.775   8.766  1.00  1.32           H  
ATOM    353  HE2 PHE A 384      38.162  65.982   9.992  1.00  0.86           H  
ATOM    354  HZ  PHE A 384      39.468  68.012  10.473  1.00  0.86           H  
ATOM    355  N   ILE A 385      37.186  65.937   2.758  1.00  0.26           N  
ATOM    356  CA  ILE A 385      36.468  65.620   1.528  1.00  0.27           C  
ATOM    357  C   ILE A 385      35.591  64.388   1.708  1.00  0.24           C  
ATOM    358  O   ILE A 385      36.063  63.333   2.127  1.00  0.30           O  
ATOM    359  CB  ILE A 385      37.425  65.362   0.343  1.00  0.33           C  
ATOM    360  CG1 ILE A 385      38.601  66.342   0.353  1.00  0.32           C  
ATOM    361  CG2 ILE A 385      36.666  65.461  -0.973  1.00  0.49           C  
ATOM    362  CD1 ILE A 385      39.658  66.010   1.382  1.00  0.32           C  
ATOM    363  H   ILE A 385      37.644  65.221   3.247  1.00  0.28           H  
ATOM    364  HA  ILE A 385      35.841  66.465   1.281  1.00  0.31           H  
ATOM    365  HB  ILE A 385      37.806  64.355   0.432  1.00  0.37           H  
ATOM    366 HG12 ILE A 385      39.074  66.338  -0.617  1.00  0.41           H  
ATOM    367 HG13 ILE A 385      38.236  67.335   0.565  1.00  0.43           H  
ATOM    368 HG21 ILE A 385      35.777  66.059  -0.834  1.00  1.12           H  
ATOM    369 HG22 ILE A 385      37.297  65.922  -1.719  1.00  1.12           H  
ATOM    370 HG23 ILE A 385      36.385  64.471  -1.302  1.00  1.20           H  
ATOM    371 HD11 ILE A 385      39.181  65.725   2.308  1.00  0.98           H  
ATOM    372 HD12 ILE A 385      40.266  65.194   1.022  1.00  1.10           H  
ATOM    373 HD13 ILE A 385      40.281  66.877   1.550  1.00  1.08           H  
ATOM    374  N   ARG A 386      34.314  64.530   1.376  1.00  0.29           N  
ATOM    375  CA  ARG A 386      33.368  63.430   1.487  1.00  0.30           C  
ATOM    376  C   ARG A 386      33.504  62.489   0.296  1.00  0.33           C  
ATOM    377  O   ARG A 386      33.258  62.885  -0.843  1.00  0.42           O  
ATOM    378  CB  ARG A 386      31.942  63.983   1.548  1.00  0.38           C  
ATOM    379  CG  ARG A 386      30.870  62.919   1.720  1.00  0.50           C  
ATOM    380  CD  ARG A 386      29.479  63.533   1.691  1.00  1.02           C  
ATOM    381  NE  ARG A 386      28.428  62.536   1.887  1.00  1.40           N  
ATOM    382  CZ  ARG A 386      28.260  61.848   3.013  1.00  1.86           C  
ATOM    383  NH1 ARG A 386      29.067  62.045   4.046  1.00  2.42           N  
ATOM    384  NH2 ARG A 386      27.277  60.962   3.108  1.00  2.39           N  
ATOM    385  H   ARG A 386      34.003  65.396   1.040  1.00  0.37           H  
ATOM    386  HA  ARG A 386      33.580  62.889   2.396  1.00  0.35           H  
ATOM    387  HB2 ARG A 386      31.871  64.669   2.379  1.00  0.45           H  
ATOM    388  HB3 ARG A 386      31.741  64.520   0.632  1.00  0.42           H  
ATOM    389  HG2 ARG A 386      30.955  62.202   0.917  1.00  1.01           H  
ATOM    390  HG3 ARG A 386      31.017  62.423   2.669  1.00  0.98           H  
ATOM    391  HD2 ARG A 386      29.410  64.271   2.475  1.00  1.53           H  
ATOM    392  HD3 ARG A 386      29.334  64.013   0.734  1.00  1.53           H  
ATOM    393  HE  ARG A 386      27.815  62.371   1.140  1.00  1.90           H  
ATOM    394 HH11 ARG A 386      29.808  62.713   3.983  1.00  2.37           H  
ATOM    395 HH12 ARG A 386      28.937  61.524   4.889  1.00  3.17           H  
ATOM    396 HH21 ARG A 386      26.663  60.811   2.333  1.00  2.55           H  
ATOM    397 HH22 ARG A 386      27.149  60.447   3.954  1.00  2.93           H  
ATOM    398  N   ARG A 387      33.890  61.242   0.555  1.00  0.41           N  
ATOM    399  CA  ARG A 387      34.040  60.271  -0.521  1.00  0.51           C  
ATOM    400  C   ARG A 387      32.676  59.895  -1.084  1.00  0.49           C  
ATOM    401  O   ARG A 387      31.659  60.029  -0.406  1.00  0.47           O  
ATOM    402  CB  ARG A 387      34.784  59.026  -0.044  1.00  0.63           C  
ATOM    403  CG  ARG A 387      36.182  59.316   0.477  1.00  0.84           C  
ATOM    404  CD  ARG A 387      37.026  58.053   0.533  1.00  0.94           C  
ATOM    405  NE  ARG A 387      36.377  56.986   1.286  1.00  1.32           N  
ATOM    406  CZ  ARG A 387      36.903  55.775   1.451  1.00  1.79           C  
ATOM    407  NH1 ARG A 387      38.089  55.487   0.928  1.00  2.30           N  
ATOM    408  NH2 ARG A 387      36.247  54.851   2.138  1.00  2.25           N  
ATOM    409  H   ARG A 387      34.070  60.969   1.482  1.00  0.46           H  
ATOM    410  HA  ARG A 387      34.615  60.741  -1.305  1.00  0.58           H  
ATOM    411  HB2 ARG A 387      34.216  58.562   0.751  1.00  0.63           H  
ATOM    412  HB3 ARG A 387      34.867  58.331  -0.867  1.00  0.77           H  
ATOM    413  HG2 ARG A 387      36.660  60.028  -0.179  1.00  1.24           H  
ATOM    414  HG3 ARG A 387      36.107  59.731   1.472  1.00  1.17           H  
ATOM    415  HD2 ARG A 387      37.204  57.712  -0.476  1.00  1.21           H  
ATOM    416  HD3 ARG A 387      37.972  58.289   1.001  1.00  1.21           H  
ATOM    417  HE  ARG A 387      35.502  57.177   1.683  1.00  1.73           H  
ATOM    418 HH11 ARG A 387      38.588  56.180   0.409  1.00  2.22           H  
ATOM    419 HH12 ARG A 387      38.482  54.577   1.053  1.00  2.99           H  
ATOM    420 HH21 ARG A 387      35.354  55.061   2.535  1.00  2.35           H  
ATOM    421 HH22 ARG A 387      36.645  53.941   2.261  1.00  2.76           H  
ATOM    422  N   GLU A 388      32.658  59.446  -2.335  1.00  0.64           N  
ATOM    423  CA  GLU A 388      31.411  59.074  -2.994  1.00  0.69           C  
ATOM    424  C   GLU A 388      30.595  58.109  -2.144  1.00  0.61           C  
ATOM    425  O   GLU A 388      29.389  58.293  -1.983  1.00  0.63           O  
ATOM    426  CB  GLU A 388      31.692  58.459  -4.367  1.00  0.88           C  
ATOM    427  CG  GLU A 388      32.414  59.399  -5.321  1.00  1.58           C  
ATOM    428  CD  GLU A 388      32.674  58.771  -6.677  1.00  2.20           C  
ATOM    429  OE1 GLU A 388      32.296  57.597  -6.872  1.00  2.82           O  
ATOM    430  OE2 GLU A 388      33.256  59.454  -7.547  1.00  2.65           O  
ATOM    431  H   GLU A 388      33.500  59.379  -2.832  1.00  0.79           H  
ATOM    432  HA  GLU A 388      30.833  59.976  -3.125  1.00  0.72           H  
ATOM    433  HB2 GLU A 388      32.303  57.578  -4.235  1.00  1.18           H  
ATOM    434  HB3 GLU A 388      30.755  58.171  -4.820  1.00  1.27           H  
ATOM    435  HG2 GLU A 388      31.809  60.283  -5.460  1.00  2.17           H  
ATOM    436  HG3 GLU A 388      33.360  59.679  -4.882  1.00  2.04           H  
ATOM    437  N   ASP A 389      31.249  57.095  -1.584  1.00  0.65           N  
ATOM    438  CA  ASP A 389      30.549  56.137  -0.738  1.00  0.69           C  
ATOM    439  C   ASP A 389      29.870  56.882   0.403  1.00  0.64           C  
ATOM    440  O   ASP A 389      28.778  56.520   0.840  1.00  0.91           O  
ATOM    441  CB  ASP A 389      31.505  55.074  -0.191  1.00  0.81           C  
ATOM    442  CG  ASP A 389      32.581  55.654   0.703  1.00  0.80           C  
ATOM    443  OD1 ASP A 389      33.375  56.481   0.214  1.00  1.06           O  
ATOM    444  OD2 ASP A 389      32.627  55.281   1.893  1.00  1.23           O  
ATOM    445  H   ASP A 389      32.213  56.999  -1.730  1.00  0.72           H  
ATOM    446  HA  ASP A 389      29.791  55.658  -1.339  1.00  0.76           H  
ATOM    447  HB2 ASP A 389      30.940  54.354   0.382  1.00  0.89           H  
ATOM    448  HB3 ASP A 389      31.983  54.570  -1.018  1.00  0.90           H  
ATOM    449  N   GLY A 390      30.526  57.945   0.863  1.00  0.55           N  
ATOM    450  CA  GLY A 390      29.978  58.757   1.928  1.00  0.53           C  
ATOM    451  C   GLY A 390      30.987  59.059   3.022  1.00  0.55           C  
ATOM    452  O   GLY A 390      30.986  60.149   3.593  1.00  1.03           O  
ATOM    453  H   GLY A 390      31.384  58.189   0.458  1.00  0.70           H  
ATOM    454  HA2 GLY A 390      29.636  59.691   1.501  1.00  0.51           H  
ATOM    455  HA3 GLY A 390      29.134  58.241   2.363  1.00  0.62           H  
ATOM    456  N   THR A 391      31.840  58.083   3.321  1.00  0.57           N  
ATOM    457  CA  THR A 391      32.852  58.234   4.364  1.00  0.54           C  
ATOM    458  C   THR A 391      33.803  59.393   4.081  1.00  0.41           C  
ATOM    459  O   THR A 391      34.593  59.353   3.136  1.00  0.44           O  
ATOM    460  CB  THR A 391      33.673  56.944   4.543  1.00  0.71           C  
ATOM    461  OG1 THR A 391      34.354  56.620   3.327  1.00  0.98           O  
ATOM    462  CG2 THR A 391      32.776  55.785   4.953  1.00  0.88           C  
ATOM    463  H   THR A 391      31.780  57.235   2.835  1.00  0.95           H  
ATOM    464  HA  THR A 391      32.336  58.431   5.293  1.00  0.58           H  
ATOM    465  HB  THR A 391      34.403  57.105   5.323  1.00  0.81           H  
ATOM    466  HG1 THR A 391      34.000  57.151   2.609  1.00  1.19           H  
ATOM    467 HG21 THR A 391      31.741  56.063   4.809  1.00  1.34           H  
ATOM    468 HG22 THR A 391      33.004  54.920   4.347  1.00  1.30           H  
ATOM    469 HG23 THR A 391      32.943  55.550   5.993  1.00  1.46           H  
ATOM    470  N   VAL A 392      33.723  60.424   4.918  1.00  0.37           N  
ATOM    471  CA  VAL A 392      34.577  61.599   4.783  1.00  0.33           C  
ATOM    472  C   VAL A 392      36.006  61.282   5.219  1.00  0.32           C  
ATOM    473  O   VAL A 392      36.219  60.539   6.177  1.00  0.41           O  
ATOM    474  CB  VAL A 392      34.041  62.778   5.618  1.00  0.45           C  
ATOM    475  CG1 VAL A 392      34.936  63.999   5.469  1.00  0.55           C  
ATOM    476  CG2 VAL A 392      32.611  63.103   5.216  1.00  0.52           C  
ATOM    477  H   VAL A 392      33.075  60.390   5.653  1.00  0.45           H  
ATOM    478  HA  VAL A 392      34.583  61.893   3.743  1.00  0.35           H  
ATOM    479  HB  VAL A 392      34.041  62.485   6.659  1.00  0.53           H  
ATOM    480 HG11 VAL A 392      35.953  63.734   5.717  1.00  1.13           H  
ATOM    481 HG12 VAL A 392      34.894  64.352   4.449  1.00  1.12           H  
ATOM    482 HG13 VAL A 392      34.596  64.779   6.133  1.00  1.24           H  
ATOM    483 HG21 VAL A 392      32.328  62.494   4.370  1.00  1.14           H  
ATOM    484 HG22 VAL A 392      31.948  62.898   6.045  1.00  1.14           H  
ATOM    485 HG23 VAL A 392      32.541  64.146   4.949  1.00  1.13           H  
ATOM    486  N   HIS A 393      36.981  61.848   4.513  1.00  0.29           N  
ATOM    487  CA  HIS A 393      38.390  61.618   4.829  1.00  0.31           C  
ATOM    488  C   HIS A 393      39.238  62.845   4.502  1.00  0.27           C  
ATOM    489  O   HIS A 393      38.979  63.552   3.526  1.00  0.26           O  
ATOM    490  CB  HIS A 393      38.916  60.400   4.066  1.00  0.37           C  
ATOM    491  CG  HIS A 393      38.362  59.098   4.556  1.00  0.92           C  
ATOM    492  ND1 HIS A 393      38.557  58.633   5.840  1.00  1.92           N  
ATOM    493  CD2 HIS A 393      37.611  58.162   3.930  1.00  0.94           C  
ATOM    494  CE1 HIS A 393      37.950  57.467   5.981  1.00  2.43           C  
ATOM    495  NE2 HIS A 393      37.370  57.159   4.837  1.00  1.82           N  
ATOM    496  H   HIS A 393      36.751  62.430   3.759  1.00  0.32           H  
ATOM    497  HA  HIS A 393      38.458  61.424   5.889  1.00  0.37           H  
ATOM    498  HB2 HIS A 393      38.656  60.498   3.023  1.00  0.68           H  
ATOM    499  HB3 HIS A 393      39.992  60.361   4.160  1.00  0.71           H  
ATOM    500  HD1 HIS A 393      39.066  59.089   6.543  1.00  2.24           H  
ATOM    501  HD2 HIS A 393      37.266  58.197   2.905  1.00  0.73           H  
ATOM    502  HE1 HIS A 393      37.932  56.869   6.880  1.00  3.24           H  
ATOM    503  HE2 HIS A 393      36.797  56.379   4.684  1.00  2.04           H  
ATOM    504  N   ARG A 394      40.246  63.094   5.334  1.00  0.29           N  
ATOM    505  CA  ARG A 394      41.138  64.237   5.154  1.00  0.28           C  
ATOM    506  C   ARG A 394      41.787  64.238   3.773  1.00  0.26           C  
ATOM    507  O   ARG A 394      41.938  63.191   3.143  1.00  0.32           O  
ATOM    508  CB  ARG A 394      42.227  64.242   6.228  1.00  0.35           C  
ATOM    509  CG  ARG A 394      41.696  64.423   7.637  1.00  0.42           C  
ATOM    510  CD  ARG A 394      42.828  64.518   8.647  1.00  0.52           C  
ATOM    511  NE  ARG A 394      43.632  63.297   8.687  1.00  1.34           N  
ATOM    512  CZ  ARG A 394      44.681  63.130   9.488  1.00  2.01           C  
ATOM    513  NH1 ARG A 394      45.057  64.102  10.308  1.00  2.41           N  
ATOM    514  NH2 ARG A 394      45.357  61.989   9.468  1.00  2.96           N  
ATOM    515  H   ARG A 394      40.392  62.495   6.096  1.00  0.34           H  
ATOM    516  HA  ARG A 394      40.547  65.135   5.257  1.00  0.27           H  
ATOM    517  HB2 ARG A 394      42.762  63.304   6.185  1.00  0.41           H  
ATOM    518  HB3 ARG A 394      42.916  65.048   6.020  1.00  0.38           H  
ATOM    519  HG2 ARG A 394      41.114  65.331   7.679  1.00  0.45           H  
ATOM    520  HG3 ARG A 394      41.071  63.578   7.889  1.00  0.44           H  
ATOM    521  HD2 ARG A 394      43.467  65.346   8.373  1.00  1.07           H  
ATOM    522  HD3 ARG A 394      42.408  64.695   9.626  1.00  1.04           H  
ATOM    523  HE  ARG A 394      43.375  62.565   8.089  1.00  2.01           H  
ATOM    524 HH11 ARG A 394      44.552  64.964  10.326  1.00  2.28           H  
ATOM    525 HH12 ARG A 394      45.845  63.972  10.909  1.00  3.24           H  
ATOM    526 HH21 ARG A 394      45.079  61.253   8.851  1.00  3.32           H  
ATOM    527 HH22 ARG A 394      46.146  61.865  10.071  1.00  3.56           H  
ATOM    528  N   GLY A 395      42.168  65.428   3.316  1.00  0.23           N  
ATOM    529  CA  GLY A 395      42.802  65.570   2.018  1.00  0.25           C  
ATOM    530  C   GLY A 395      43.340  66.970   1.789  1.00  0.23           C  
ATOM    531  O   GLY A 395      42.626  67.955   1.985  1.00  0.26           O  
ATOM    532  H   GLY A 395      42.021  66.221   3.871  1.00  0.24           H  
ATOM    533  HA2 GLY A 395      43.613  64.864   1.945  1.00  0.32           H  
ATOM    534  HA3 GLY A 395      42.076  65.346   1.251  1.00  0.27           H  
ATOM    535  N   GLN A 396      44.601  67.063   1.377  1.00  0.29           N  
ATOM    536  CA  GLN A 396      45.222  68.358   1.124  1.00  0.34           C  
ATOM    537  C   GLN A 396      44.906  68.842  -0.287  1.00  0.35           C  
ATOM    538  O   GLN A 396      45.117  68.122  -1.261  1.00  0.46           O  
ATOM    539  CB  GLN A 396      46.738  68.262   1.308  1.00  0.43           C  
ATOM    540  CG  GLN A 396      47.158  67.800   2.694  1.00  0.50           C  
ATOM    541  CD  GLN A 396      48.661  67.700   2.843  1.00  0.64           C  
ATOM    542  OE1 GLN A 396      49.343  67.083   2.024  1.00  1.28           O  
ATOM    543  NE2 GLN A 396      49.178  68.292   3.907  1.00  0.61           N  
ATOM    544  H   GLN A 396      45.123  66.246   1.239  1.00  0.34           H  
ATOM    545  HA  GLN A 396      44.824  69.065   1.835  1.00  0.36           H  
ATOM    546  HB2 GLN A 396      47.133  67.564   0.585  1.00  0.44           H  
ATOM    547  HB3 GLN A 396      47.172  69.235   1.130  1.00  0.50           H  
ATOM    548  HG2 GLN A 396      46.789  68.507   3.420  1.00  0.53           H  
ATOM    549  HG3 GLN A 396      46.730  66.833   2.888  1.00  0.48           H  
ATOM    550 HE21 GLN A 396      48.564  68.745   4.520  1.00  0.99           H  
ATOM    551 HE22 GLN A 396      50.149  68.250   4.038  1.00  0.64           H  
ATOM    552  N   VAL A 397      44.417  70.070  -0.395  1.00  0.33           N  
ATOM    553  CA  VAL A 397      44.088  70.646  -1.691  1.00  0.33           C  
ATOM    554  C   VAL A 397      45.234  71.525  -2.190  1.00  0.33           C  
ATOM    555  O   VAL A 397      45.807  72.303  -1.426  1.00  0.37           O  
ATOM    556  CB  VAL A 397      42.754  71.430  -1.624  1.00  0.38           C  
ATOM    557  CG1 VAL A 397      42.926  72.898  -1.971  1.00  0.73           C  
ATOM    558  CG2 VAL A 397      41.724  70.786  -2.535  1.00  0.83           C  
ATOM    559  H   VAL A 397      44.280  70.604   0.416  1.00  0.40           H  
ATOM    560  HA  VAL A 397      43.960  69.827  -2.385  1.00  0.36           H  
ATOM    561  HB  VAL A 397      42.383  71.370  -0.616  1.00  0.82           H  
ATOM    562 HG11 VAL A 397      43.910  73.226  -1.675  1.00  1.27           H  
ATOM    563 HG12 VAL A 397      42.803  73.034  -3.036  1.00  1.42           H  
ATOM    564 HG13 VAL A 397      42.181  73.476  -1.446  1.00  1.31           H  
ATOM    565 HG21 VAL A 397      41.570  69.760  -2.234  1.00  1.42           H  
ATOM    566 HG22 VAL A 397      40.793  71.326  -2.464  1.00  1.22           H  
ATOM    567 HG23 VAL A 397      42.080  70.812  -3.555  1.00  1.58           H  
ATOM    568  N   LEU A 398      45.594  71.368  -3.464  1.00  0.36           N  
ATOM    569  CA  LEU A 398      46.704  72.126  -4.036  1.00  0.40           C  
ATOM    570  C   LEU A 398      46.286  72.994  -5.226  1.00  0.41           C  
ATOM    571  O   LEU A 398      46.717  74.141  -5.337  1.00  0.47           O  
ATOM    572  CB  LEU A 398      47.811  71.164  -4.470  1.00  0.46           C  
ATOM    573  CG  LEU A 398      48.361  70.264  -3.361  1.00  0.49           C  
ATOM    574  CD1 LEU A 398      49.352  69.261  -3.929  1.00  1.16           C  
ATOM    575  CD2 LEU A 398      49.015  71.100  -2.269  1.00  1.45           C  
ATOM    576  H   LEU A 398      45.122  70.714  -4.019  1.00  0.40           H  
ATOM    577  HA  LEU A 398      47.093  72.768  -3.263  1.00  0.43           H  
ATOM    578  HB2 LEU A 398      47.423  70.534  -5.259  1.00  0.48           H  
ATOM    579  HB3 LEU A 398      48.629  71.747  -4.869  1.00  0.54           H  
ATOM    580  HG  LEU A 398      47.544  69.712  -2.917  1.00  0.90           H  
ATOM    581 HD11 LEU A 398      48.981  68.882  -4.871  1.00  1.63           H  
ATOM    582 HD12 LEU A 398      50.305  69.743  -4.086  1.00  1.74           H  
ATOM    583 HD13 LEU A 398      49.473  68.442  -3.234  1.00  1.81           H  
ATOM    584 HD21 LEU A 398      49.076  72.128  -2.593  1.00  2.01           H  
ATOM    585 HD22 LEU A 398      48.423  71.040  -1.368  1.00  1.95           H  
ATOM    586 HD23 LEU A 398      50.007  70.722  -2.075  1.00  2.04           H  
ATOM    587  N   GLN A 399      45.476  72.441  -6.126  1.00  0.39           N  
ATOM    588  CA  GLN A 399      45.050  73.184  -7.314  1.00  0.43           C  
ATOM    589  C   GLN A 399      43.532  73.285  -7.417  1.00  0.38           C  
ATOM    590  O   GLN A 399      42.800  72.697  -6.622  1.00  0.35           O  
ATOM    591  CB  GLN A 399      45.602  72.519  -8.575  1.00  0.49           C  
ATOM    592  CG  GLN A 399      47.119  72.407  -8.591  1.00  0.60           C  
ATOM    593  CD  GLN A 399      47.658  71.735  -9.844  1.00  1.36           C  
ATOM    594  OE1 GLN A 399      48.869  71.592 -10.008  1.00  2.08           O  
ATOM    595  NE2 GLN A 399      46.764  71.317 -10.736  1.00  2.04           N  
ATOM    596  H   GLN A 399      45.178  71.515  -6.004  1.00  0.39           H  
ATOM    597  HA  GLN A 399      45.458  74.179  -7.242  1.00  0.49           H  
ATOM    598  HB2 GLN A 399      45.187  71.526  -8.655  1.00  0.46           H  
ATOM    599  HB3 GLN A 399      45.297  73.097  -9.434  1.00  0.53           H  
ATOM    600  HG2 GLN A 399      47.540  73.398  -8.527  1.00  0.92           H  
ATOM    601  HG3 GLN A 399      47.432  71.830  -7.731  1.00  1.00           H  
ATOM    602 HE21 GLN A 399      45.814  71.460 -10.546  1.00  2.28           H  
ATOM    603 HE22 GLN A 399      47.093  70.880 -11.550  1.00  2.64           H  
ATOM    604  N   SER A 400      43.074  74.039  -8.414  1.00  0.42           N  
ATOM    605  CA  SER A 400      41.647  74.231  -8.652  1.00  0.41           C  
ATOM    606  C   SER A 400      41.410  74.846 -10.030  1.00  0.47           C  
ATOM    607  O   SER A 400      42.205  75.662 -10.496  1.00  0.54           O  
ATOM    608  CB  SER A 400      41.039  75.122  -7.567  1.00  0.47           C  
ATOM    609  OG  SER A 400      41.621  76.413  -7.580  1.00  0.56           O  
ATOM    610  H   SER A 400      43.716  74.477  -9.012  1.00  0.47           H  
ATOM    611  HA  SER A 400      41.173  73.262  -8.617  1.00  0.38           H  
ATOM    612  HB2 SER A 400      39.978  75.218  -7.736  1.00  0.49           H  
ATOM    613  HB3 SER A 400      41.209  74.674  -6.599  1.00  0.48           H  
ATOM    614  HG  SER A 400      42.492  76.368  -7.981  1.00  1.13           H  
ATOM    615  N   ARG A 401      40.318  74.450 -10.682  1.00  0.51           N  
ATOM    616  CA  ARG A 401      39.991  74.970 -12.010  1.00  0.60           C  
ATOM    617  C   ARG A 401      38.480  75.144 -12.169  1.00  0.73           C  
ATOM    618  O   ARG A 401      37.702  74.268 -11.794  1.00  0.86           O  
ATOM    619  CB  ARG A 401      40.526  74.031 -13.095  1.00  0.65           C  
ATOM    620  CG  ARG A 401      39.795  72.701 -13.167  1.00  0.72           C  
ATOM    621  CD  ARG A 401      40.332  71.829 -14.291  1.00  0.91           C  
ATOM    622  NE  ARG A 401      39.594  70.574 -14.402  1.00  1.02           N  
ATOM    623  CZ  ARG A 401      39.862  69.638 -15.308  1.00  1.25           C  
ATOM    624  NH1 ARG A 401      40.848  69.815 -16.176  1.00  1.55           N  
ATOM    625  NH2 ARG A 401      39.142  68.526 -15.346  1.00  1.43           N  
ATOM    626  H   ARG A 401      39.719  73.796 -10.264  1.00  0.53           H  
ATOM    627  HA  ARG A 401      40.465  75.934 -12.114  1.00  0.64           H  
ATOM    628  HB2 ARG A 401      40.439  74.516 -14.055  1.00  0.72           H  
ATOM    629  HB3 ARG A 401      41.569  73.832 -12.899  1.00  0.66           H  
ATOM    630  HG2 ARG A 401      39.923  72.181 -12.230  1.00  0.74           H  
ATOM    631  HG3 ARG A 401      38.746  72.888 -13.338  1.00  0.85           H  
ATOM    632  HD2 ARG A 401      40.246  72.371 -15.221  1.00  1.06           H  
ATOM    633  HD3 ARG A 401      41.371  71.611 -14.095  1.00  1.07           H  
ATOM    634  HE  ARG A 401      38.860  70.422 -13.770  1.00  1.14           H  
ATOM    635 HH11 ARG A 401      41.394  70.653 -16.150  1.00  1.56           H  
ATOM    636 HH12 ARG A 401      41.047  69.110 -16.856  1.00  1.88           H  
ATOM    637 HH21 ARG A 401      38.396  68.389 -14.693  1.00  1.47           H  
ATOM    638 HH22 ARG A 401      39.343  67.822 -16.029  1.00  1.68           H  
ATOM    639  N   THR A 402      38.072  76.287 -12.717  1.00  0.82           N  
ATOM    640  CA  THR A 402      36.657  76.581 -12.916  1.00  0.99           C  
ATOM    641  C   THR A 402      36.209  76.301 -14.348  1.00  1.16           C  
ATOM    642  O   THR A 402      35.388  77.036 -14.901  1.00  1.79           O  
ATOM    643  CB  THR A 402      36.342  78.045 -12.566  1.00  1.14           C  
ATOM    644  OG1 THR A 402      37.302  78.914 -13.179  1.00  1.38           O  
ATOM    645  CG2 THR A 402      36.339  78.250 -11.059  1.00  1.29           C  
ATOM    646  H   THR A 402      38.739  76.951 -12.989  1.00  0.85           H  
ATOM    647  HA  THR A 402      36.091  75.948 -12.247  1.00  1.02           H  
ATOM    648  HB  THR A 402      35.361  78.285 -12.947  1.00  1.29           H  
ATOM    649  HG1 THR A 402      38.072  78.406 -13.445  1.00  1.65           H  
ATOM    650 HG21 THR A 402      35.662  77.541 -10.604  1.00  1.62           H  
ATOM    651 HG22 THR A 402      37.336  78.095 -10.672  1.00  1.72           H  
ATOM    652 HG23 THR A 402      36.016  79.254 -10.832  1.00  1.77           H  
ATOM    653  N   THR A 403      36.737  75.230 -14.932  1.00  1.43           N  
ATOM    654  CA  THR A 403      36.392  74.834 -16.299  1.00  1.62           C  
ATOM    655  C   THR A 403      36.452  76.033 -17.258  1.00  1.84           C  
ATOM    656  O   THR A 403      36.884  77.122 -16.881  1.00  1.85           O  
ATOM    657  CB  THR A 403      34.989  74.191 -16.343  1.00  1.77           C  
ATOM    658  OG1 THR A 403      34.813  73.347 -15.199  1.00  1.78           O  
ATOM    659  CG2 THR A 403      34.801  73.351 -17.599  1.00  1.95           C  
ATOM    660  H   THR A 403      37.368  74.679 -14.425  1.00  1.94           H  
ATOM    661  HA  THR A 403      37.112  74.096 -16.621  1.00  1.60           H  
ATOM    662  HB  THR A 403      34.245  74.972 -16.330  1.00  1.85           H  
ATOM    663  HG1 THR A 403      35.325  73.691 -14.464  1.00  1.98           H  
ATOM    664 HG21 THR A 403      35.757  73.202 -18.079  1.00  2.13           H  
ATOM    665 HG22 THR A 403      34.378  72.394 -17.334  1.00  2.29           H  
ATOM    666 HG23 THR A 403      34.134  73.864 -18.277  1.00  2.30           H  
ATOM    667  N   GLU A 404      36.031  75.824 -18.503  1.00  2.08           N  
ATOM    668  CA  GLU A 404      36.045  76.882 -19.508  1.00  2.34           C  
ATOM    669  C   GLU A 404      35.021  77.968 -19.188  1.00  2.30           C  
ATOM    670  O   GLU A 404      35.293  79.158 -19.348  1.00  2.37           O  
ATOM    671  CB  GLU A 404      35.757  76.299 -20.893  1.00  2.72           C  
ATOM    672  CG  GLU A 404      36.762  75.249 -21.334  1.00  2.91           C  
ATOM    673  CD  GLU A 404      36.447  74.677 -22.704  1.00  3.42           C  
ATOM    674  OE1 GLU A 404      35.439  75.100 -23.308  1.00  3.79           O  
ATOM    675  OE2 GLU A 404      37.209  73.804 -23.172  1.00  3.87           O  
ATOM    676  H   GLU A 404      35.708  74.937 -18.753  1.00  2.11           H  
ATOM    677  HA  GLU A 404      37.030  77.323 -19.513  1.00  2.36           H  
ATOM    678  HB2 GLU A 404      34.777  75.848 -20.883  1.00  2.90           H  
ATOM    679  HB3 GLU A 404      35.767  77.101 -21.616  1.00  2.84           H  
ATOM    680  HG2 GLU A 404      37.743  75.697 -21.366  1.00  3.03           H  
ATOM    681  HG3 GLU A 404      36.759  74.442 -20.614  1.00  3.07           H  
ATOM    682  N   ASN A 405      33.835  77.547 -18.752  1.00  2.26           N  
ATOM    683  CA  ASN A 405      32.758  78.478 -18.425  1.00  2.30           C  
ATOM    684  C   ASN A 405      33.217  79.526 -17.410  1.00  2.07           C  
ATOM    685  O   ASN A 405      33.068  80.726 -17.639  1.00  2.40           O  
ATOM    686  CB  ASN A 405      31.550  77.710 -17.882  1.00  2.43           C  
ATOM    687  CG  ASN A 405      30.357  78.609 -17.626  1.00  2.67           C  
ATOM    688  OD1 ASN A 405      30.421  79.526 -16.810  1.00  3.16           O  
ATOM    689  ND2 ASN A 405      29.259  78.351 -18.326  1.00  2.73           N  
ATOM    690  H   ASN A 405      33.679  76.585 -18.658  1.00  2.26           H  
ATOM    691  HA  ASN A 405      32.471  78.981 -19.335  1.00  2.52           H  
ATOM    692  HB2 ASN A 405      31.260  76.957 -18.598  1.00  2.67           H  
ATOM    693  HB3 ASN A 405      31.824  77.231 -16.953  1.00  2.30           H  
ATOM    694 HD21 ASN A 405      29.279  77.604 -18.961  1.00  2.82           H  
ATOM    695 HD22 ASN A 405      28.473  78.917 -18.181  1.00  2.96           H  
ATOM    696  N   ALA A 406      33.780  79.064 -16.299  1.00  1.82           N  
ATOM    697  CA  ALA A 406      34.271  79.961 -15.253  1.00  1.67           C  
ATOM    698  C   ALA A 406      33.178  80.912 -14.763  1.00  1.85           C  
ATOM    699  O   ALA A 406      33.317  82.133 -14.849  1.00  2.18           O  
ATOM    700  CB  ALA A 406      35.475  80.742 -15.752  1.00  1.72           C  
ATOM    701  H   ALA A 406      33.875  78.096 -16.178  1.00  2.00           H  
ATOM    702  HA  ALA A 406      34.592  79.349 -14.423  1.00  1.53           H  
ATOM    703  HB1 ALA A 406      35.209  81.782 -15.864  1.00  1.91           H  
ATOM    704  HB2 ALA A 406      35.793  80.346 -16.704  1.00  2.07           H  
ATOM    705  HB3 ALA A 406      36.281  80.653 -15.037  1.00  2.10           H  
ATOM    706  N   ALA A 407      32.098  80.339 -14.247  1.00  1.91           N  
ATOM    707  CA  ALA A 407      30.977  81.119 -13.733  1.00  2.19           C  
ATOM    708  C   ALA A 407      30.094  80.246 -12.856  1.00  2.37           C  
ATOM    709  O   ALA A 407      28.987  80.627 -12.478  1.00  2.77           O  
ATOM    710  CB  ALA A 407      30.171  81.708 -14.877  1.00  2.38           C  
ATOM    711  H   ALA A 407      32.053  79.362 -14.206  1.00  1.96           H  
ATOM    712  HA  ALA A 407      31.374  81.930 -13.140  1.00  2.22           H  
ATOM    713  HB1 ALA A 407      30.817  81.868 -15.726  1.00  2.52           H  
ATOM    714  HB2 ALA A 407      29.740  82.649 -14.567  1.00  2.76           H  
ATOM    715  HB3 ALA A 407      29.381  81.022 -15.148  1.00  2.63           H  
ATOM    716  N   ALA A 408      30.612  79.065 -12.544  1.00  2.15           N  
ATOM    717  CA  ALA A 408      29.917  78.089 -11.717  1.00  2.35           C  
ATOM    718  C   ALA A 408      30.801  76.859 -11.493  1.00  2.05           C  
ATOM    719  O   ALA A 408      30.982  76.423 -10.356  1.00  1.99           O  
ATOM    720  CB  ALA A 408      28.590  77.688 -12.350  1.00  2.76           C  
ATOM    721  H   ALA A 408      31.503  78.840 -12.885  1.00  1.90           H  
ATOM    722  HA  ALA A 408      29.711  78.549 -10.761  1.00  2.50           H  
ATOM    723  HB1 ALA A 408      27.780  78.177 -11.828  1.00  3.28           H  
ATOM    724  HB2 ALA A 408      28.582  77.984 -13.387  1.00  3.03           H  
ATOM    725  HB3 ALA A 408      28.466  76.617 -12.279  1.00  2.78           H  
ATOM    726  N   PRO A 409      31.376  76.285 -12.574  1.00  1.99           N  
ATOM    727  CA  PRO A 409      32.251  75.113 -12.470  1.00  1.80           C  
ATOM    728  C   PRO A 409      33.499  75.394 -11.652  1.00  1.41           C  
ATOM    729  O   PRO A 409      34.030  76.499 -11.682  1.00  1.86           O  
ATOM    730  CB  PRO A 409      32.620  74.795 -13.921  1.00  2.10           C  
ATOM    731  CG  PRO A 409      32.389  76.064 -14.662  1.00  2.49           C  
ATOM    732  CD  PRO A 409      31.234  76.728 -13.977  1.00  2.27           C  
ATOM    733  HA  PRO A 409      31.737  74.279 -12.040  1.00  1.94           H  
ATOM    734  HB2 PRO A 409      33.654  74.489 -13.972  1.00  2.00           H  
ATOM    735  HB3 PRO A 409      31.985  74.003 -14.290  1.00  2.29           H  
ATOM    736  HG2 PRO A 409      33.270  76.687 -14.606  1.00  2.74           H  
ATOM    737  HG3 PRO A 409      32.144  75.849 -15.691  1.00  2.87           H  
ATOM    738  HD2 PRO A 409      31.316  77.801 -14.055  1.00  2.22           H  
ATOM    739  HD3 PRO A 409      30.299  76.387 -14.395  1.00  2.54           H  
ATOM    740  N   ASP A 410      33.958  74.380 -10.919  1.00  0.92           N  
ATOM    741  CA  ASP A 410      35.151  74.507 -10.089  1.00  0.79           C  
ATOM    742  C   ASP A 410      35.467  73.187  -9.392  1.00  0.68           C  
ATOM    743  O   ASP A 410      34.627  72.625  -8.688  1.00  0.93           O  
ATOM    744  CB  ASP A 410      34.970  75.616  -9.048  1.00  1.18           C  
ATOM    745  CG  ASP A 410      33.824  75.339  -8.096  1.00  1.62           C  
ATOM    746  OD1 ASP A 410      32.678  75.200  -8.571  1.00  1.99           O  
ATOM    747  OD2 ASP A 410      34.075  75.261  -6.875  1.00  2.14           O  
ATOM    748  H   ASP A 410      33.482  73.525 -10.942  1.00  1.11           H  
ATOM    749  HA  ASP A 410      35.976  74.764 -10.736  1.00  0.99           H  
ATOM    750  HB2 ASP A 410      35.878  75.709  -8.472  1.00  1.50           H  
ATOM    751  HB3 ASP A 410      34.774  76.549  -9.558  1.00  1.35           H  
ATOM    752  N   GLU A 411      36.687  72.701  -9.593  1.00  0.54           N  
ATOM    753  CA  GLU A 411      37.132  71.450  -8.986  1.00  0.45           C  
ATOM    754  C   GLU A 411      38.475  71.651  -8.295  1.00  0.40           C  
ATOM    755  O   GLU A 411      39.356  72.326  -8.826  1.00  0.42           O  
ATOM    756  CB  GLU A 411      37.249  70.343 -10.039  1.00  0.49           C  
ATOM    757  CG  GLU A 411      35.919  69.899 -10.632  1.00  0.58           C  
ATOM    758  CD  GLU A 411      35.239  70.982 -11.447  1.00  1.47           C  
ATOM    759  OE1 GLU A 411      35.854  71.471 -12.418  1.00  2.10           O  
ATOM    760  OE2 GLU A 411      34.088  71.340 -11.115  1.00  2.08           O  
ATOM    761  H   GLU A 411      37.309  73.199 -10.162  1.00  0.68           H  
ATOM    762  HA  GLU A 411      36.399  71.161  -8.246  1.00  0.49           H  
ATOM    763  HB2 GLU A 411      37.874  70.699 -10.846  1.00  0.55           H  
ATOM    764  HB3 GLU A 411      37.721  69.483  -9.585  1.00  0.51           H  
ATOM    765  HG2 GLU A 411      36.093  69.048 -11.274  1.00  0.98           H  
ATOM    766  HG3 GLU A 411      35.262  69.609  -9.826  1.00  1.09           H  
ATOM    767  N   TYR A 412      38.623  71.076  -7.108  1.00  0.38           N  
ATOM    768  CA  TYR A 412      39.860  71.211  -6.347  1.00  0.35           C  
ATOM    769  C   TYR A 412      40.635  69.898  -6.294  1.00  0.33           C  
ATOM    770  O   TYR A 412      40.072  68.844  -6.005  1.00  0.34           O  
ATOM    771  CB  TYR A 412      39.563  71.674  -4.919  1.00  0.39           C  
ATOM    772  CG  TYR A 412      38.975  73.065  -4.814  1.00  0.45           C  
ATOM    773  CD1 TYR A 412      37.861  73.438  -5.557  1.00  0.50           C  
ATOM    774  CD2 TYR A 412      39.535  74.004  -3.956  1.00  0.53           C  
ATOM    775  CE1 TYR A 412      37.324  74.705  -5.449  1.00  0.58           C  
ATOM    776  CE2 TYR A 412      39.004  75.274  -3.843  1.00  0.61           C  
ATOM    777  CZ  TYR A 412      37.899  75.619  -4.590  1.00  0.62           C  
ATOM    778  OH  TYR A 412      37.366  76.881  -4.476  1.00  0.72           O  
ATOM    779  H   TYR A 412      37.883  70.557  -6.730  1.00  0.41           H  
ATOM    780  HA  TYR A 412      40.470  71.956  -6.836  1.00  0.36           H  
ATOM    781  HB2 TYR A 412      38.863  70.989  -4.470  1.00  0.41           H  
ATOM    782  HB3 TYR A 412      40.482  71.661  -4.352  1.00  0.40           H  
ATOM    783  HD1 TYR A 412      37.415  72.720  -6.230  1.00  0.52           H  
ATOM    784  HD2 TYR A 412      40.401  73.731  -3.372  1.00  0.58           H  
ATOM    785  HE1 TYR A 412      36.459  74.976  -6.034  1.00  0.66           H  
ATOM    786  HE2 TYR A 412      39.453  75.988  -3.171  1.00  0.70           H  
ATOM    787  HH  TYR A 412      38.025  77.531  -4.732  1.00  1.06           H  
ATOM    788  N   TYR A 413      41.937  69.977  -6.550  1.00  0.33           N  
ATOM    789  CA  TYR A 413      42.798  68.802  -6.501  1.00  0.32           C  
ATOM    790  C   TYR A 413      43.011  68.390  -5.051  1.00  0.32           C  
ATOM    791  O   TYR A 413      43.509  69.177  -4.248  1.00  0.40           O  
ATOM    792  CB  TYR A 413      44.146  69.114  -7.150  1.00  0.36           C  
ATOM    793  CG  TYR A 413      45.064  67.916  -7.258  1.00  0.38           C  
ATOM    794  CD1 TYR A 413      44.643  66.744  -7.877  1.00  0.40           C  
ATOM    795  CD2 TYR A 413      46.353  67.959  -6.744  1.00  0.44           C  
ATOM    796  CE1 TYR A 413      45.482  65.650  -7.978  1.00  0.44           C  
ATOM    797  CE2 TYR A 413      47.197  66.869  -6.841  1.00  0.48           C  
ATOM    798  CZ  TYR A 413      46.757  65.717  -7.458  1.00  0.46           C  
ATOM    799  OH  TYR A 413      47.595  64.631  -7.556  1.00  0.51           O  
ATOM    800  H   TYR A 413      42.331  70.849  -6.756  1.00  0.35           H  
ATOM    801  HA  TYR A 413      42.314  68.001  -7.038  1.00  0.33           H  
ATOM    802  HB2 TYR A 413      43.981  69.496  -8.146  1.00  0.38           H  
ATOM    803  HB3 TYR A 413      44.651  69.866  -6.559  1.00  0.37           H  
ATOM    804  HD1 TYR A 413      43.645  66.694  -8.285  1.00  0.42           H  
ATOM    805  HD2 TYR A 413      46.695  68.862  -6.259  1.00  0.49           H  
ATOM    806  HE1 TYR A 413      45.137  64.748  -8.461  1.00  0.49           H  
ATOM    807  HE2 TYR A 413      48.197  66.925  -6.435  1.00  0.55           H  
ATOM    808  HH  TYR A 413      47.100  63.871  -7.872  1.00  1.05           H  
ATOM    809  N   VAL A 414      42.626  67.167  -4.708  1.00  0.33           N  
ATOM    810  CA  VAL A 414      42.773  66.695  -3.336  1.00  0.33           C  
ATOM    811  C   VAL A 414      43.803  65.578  -3.208  1.00  0.29           C  
ATOM    812  O   VAL A 414      43.860  64.662  -4.030  1.00  0.38           O  
ATOM    813  CB  VAL A 414      41.430  66.207  -2.762  1.00  0.39           C  
ATOM    814  CG1 VAL A 414      40.877  65.059  -3.588  1.00  1.09           C  
ATOM    815  CG2 VAL A 414      41.592  65.798  -1.307  1.00  1.15           C  
ATOM    816  H   VAL A 414      42.225  66.579  -5.380  1.00  0.40           H  
ATOM    817  HA  VAL A 414      43.102  67.532  -2.738  1.00  0.36           H  
ATOM    818  HB  VAL A 414      40.724  67.024  -2.806  1.00  1.07           H  
ATOM    819 HG11 VAL A 414      41.662  64.641  -4.199  1.00  1.58           H  
ATOM    820 HG12 VAL A 414      40.490  64.296  -2.928  1.00  1.65           H  
ATOM    821 HG13 VAL A 414      40.082  65.422  -4.223  1.00  1.74           H  
ATOM    822 HG21 VAL A 414      42.628  65.567  -1.111  1.00  1.84           H  
ATOM    823 HG22 VAL A 414      41.278  66.611  -0.668  1.00  1.58           H  
ATOM    824 HG23 VAL A 414      40.984  64.929  -1.107  1.00  1.76           H  
ATOM    825  N   HIS A 415      44.599  65.660  -2.147  1.00  0.33           N  
ATOM    826  CA  HIS A 415      45.618  64.663  -1.856  1.00  0.32           C  
ATOM    827  C   HIS A 415      45.349  64.047  -0.488  1.00  0.32           C  
ATOM    828  O   HIS A 415      45.837  64.539   0.530  1.00  0.34           O  
ATOM    829  CB  HIS A 415      47.010  65.301  -1.883  1.00  0.37           C  
ATOM    830  CG  HIS A 415      48.124  64.325  -1.663  1.00  0.44           C  
ATOM    831  ND1 HIS A 415      48.395  63.286  -2.528  1.00  0.50           N  
ATOM    832  CD2 HIS A 415      49.038  64.231  -0.668  1.00  0.54           C  
ATOM    833  CE1 HIS A 415      49.427  62.595  -2.075  1.00  0.60           C  
ATOM    834  NE2 HIS A 415      49.834  63.148  -0.949  1.00  0.62           N  
ATOM    835  H   HIS A 415      44.481  66.407  -1.527  1.00  0.43           H  
ATOM    836  HA  HIS A 415      45.563  63.892  -2.611  1.00  0.33           H  
ATOM    837  HB2 HIS A 415      47.167  65.772  -2.842  1.00  0.40           H  
ATOM    838  HB3 HIS A 415      47.067  66.051  -1.106  1.00  0.39           H  
ATOM    839  HD1 HIS A 415      47.905  63.086  -3.353  1.00  0.52           H  
ATOM    840  HD2 HIS A 415      49.124  64.884   0.187  1.00  0.59           H  
ATOM    841  HE1 HIS A 415      49.860  61.726  -2.548  1.00  0.68           H  
ATOM    842  HE2 HIS A 415      50.544  62.796  -0.372  1.00  0.71           H  
ATOM    843  N   TYR A 416      44.552  62.982  -0.467  1.00  0.37           N  
ATOM    844  CA  TYR A 416      44.198  62.316   0.781  1.00  0.40           C  
ATOM    845  C   TYR A 416      45.439  61.951   1.586  1.00  0.45           C  
ATOM    846  O   TYR A 416      46.265  61.148   1.149  1.00  0.57           O  
ATOM    847  CB  TYR A 416      43.366  61.061   0.502  1.00  0.46           C  
ATOM    848  CG  TYR A 416      42.090  61.335  -0.263  1.00  0.47           C  
ATOM    849  CD1 TYR A 416      42.107  61.510  -1.642  1.00  0.53           C  
ATOM    850  CD2 TYR A 416      40.866  61.407   0.391  1.00  0.51           C  
ATOM    851  CE1 TYR A 416      40.942  61.753  -2.345  1.00  0.59           C  
ATOM    852  CE2 TYR A 416      39.696  61.649  -0.306  1.00  0.54           C  
ATOM    853  CZ  TYR A 416      39.741  61.821  -1.673  1.00  0.57           C  
ATOM    854  OH  TYR A 416      38.579  62.063  -2.369  1.00  0.65           O  
ATOM    855  H   TYR A 416      44.182  62.647  -1.310  1.00  0.42           H  
ATOM    856  HA  TYR A 416      43.602  63.004   1.361  1.00  0.39           H  
ATOM    857  HB2 TYR A 416      43.957  60.368  -0.076  1.00  0.51           H  
ATOM    858  HB3 TYR A 416      43.098  60.601   1.443  1.00  0.50           H  
ATOM    859  HD1 TYR A 416      43.050  61.455  -2.167  1.00  0.59           H  
ATOM    860  HD2 TYR A 416      40.837  61.273   1.462  1.00  0.56           H  
ATOM    861  HE1 TYR A 416      40.976  61.887  -3.416  1.00  0.69           H  
ATOM    862  HE2 TYR A 416      38.756  61.703   0.222  1.00  0.61           H  
ATOM    863  HH  TYR A 416      37.953  62.516  -1.801  1.00  1.13           H  
ATOM    864  N   VAL A 417      45.565  62.553   2.765  1.00  0.45           N  
ATOM    865  CA  VAL A 417      46.703  62.303   3.639  1.00  0.55           C  
ATOM    866  C   VAL A 417      46.759  60.845   4.074  1.00  0.66           C  
ATOM    867  O   VAL A 417      45.777  60.295   4.568  1.00  1.34           O  
ATOM    868  CB  VAL A 417      46.657  63.198   4.892  1.00  0.68           C  
ATOM    869  CG1 VAL A 417      47.853  62.926   5.795  1.00  1.10           C  
ATOM    870  CG2 VAL A 417      46.608  64.662   4.493  1.00  1.01           C  
ATOM    871  H   VAL A 417      44.872  63.185   3.054  1.00  0.45           H  
ATOM    872  HA  VAL A 417      47.603  62.537   3.089  1.00  0.55           H  
ATOM    873  HB  VAL A 417      45.758  62.967   5.443  1.00  0.84           H  
ATOM    874 HG11 VAL A 417      47.902  61.871   6.018  1.00  1.53           H  
ATOM    875 HG12 VAL A 417      48.758  63.231   5.293  1.00  1.70           H  
ATOM    876 HG13 VAL A 417      47.745  63.484   6.713  1.00  1.57           H  
ATOM    877 HG21 VAL A 417      45.972  64.776   3.628  1.00  1.48           H  
ATOM    878 HG22 VAL A 417      46.214  65.247   5.312  1.00  1.56           H  
ATOM    879 HG23 VAL A 417      47.606  64.999   4.254  1.00  1.54           H  
ATOM    880  N   GLY A 418      47.923  60.235   3.897  1.00  0.71           N  
ATOM    881  CA  GLY A 418      48.105  58.845   4.281  1.00  0.82           C  
ATOM    882  C   GLY A 418      47.496  57.862   3.293  1.00  0.72           C  
ATOM    883  O   GLY A 418      48.104  56.839   2.978  1.00  0.76           O  
ATOM    884  H   GLY A 418      48.669  60.737   3.507  1.00  1.17           H  
ATOM    885  HA2 GLY A 418      49.164  58.643   4.357  1.00  0.94           H  
ATOM    886  HA3 GLY A 418      47.653  58.691   5.248  1.00  0.94           H  
ATOM    887  N   LEU A 419      46.293  58.165   2.811  1.00  0.66           N  
ATOM    888  CA  LEU A 419      45.604  57.290   1.863  1.00  0.60           C  
ATOM    889  C   LEU A 419      46.419  57.092   0.587  1.00  0.59           C  
ATOM    890  O   LEU A 419      47.325  57.869   0.285  1.00  0.76           O  
ATOM    891  CB  LEU A 419      44.223  57.850   1.511  1.00  0.58           C  
ATOM    892  CG  LEU A 419      43.166  57.732   2.614  1.00  0.78           C  
ATOM    893  CD1 LEU A 419      43.492  58.645   3.783  1.00  1.60           C  
ATOM    894  CD2 LEU A 419      41.783  58.041   2.058  1.00  1.40           C  
ATOM    895  H   LEU A 419      45.854  58.988   3.103  1.00  0.72           H  
ATOM    896  HA  LEU A 419      45.476  56.330   2.339  1.00  0.67           H  
ATOM    897  HB2 LEU A 419      44.335  58.894   1.263  1.00  0.73           H  
ATOM    898  HB3 LEU A 419      43.860  57.327   0.639  1.00  0.65           H  
ATOM    899  HG  LEU A 419      43.157  56.716   2.980  1.00  1.43           H  
ATOM    900 HD11 LEU A 419      43.712  59.636   3.416  1.00  2.09           H  
ATOM    901 HD12 LEU A 419      42.645  58.690   4.453  1.00  2.15           H  
ATOM    902 HD13 LEU A 419      44.350  58.260   4.313  1.00  2.14           H  
ATOM    903 HD21 LEU A 419      41.783  59.029   1.622  1.00  1.98           H  
ATOM    904 HD22 LEU A 419      41.529  57.313   1.300  1.00  1.92           H  
ATOM    905 HD23 LEU A 419      41.056  57.998   2.854  1.00  1.94           H  
ATOM    906  N   ASN A 420      46.084  56.034  -0.150  1.00  0.61           N  
ATOM    907  CA  ASN A 420      46.766  55.701  -1.397  1.00  0.63           C  
ATOM    908  C   ASN A 420      46.870  56.904  -2.328  1.00  0.56           C  
ATOM    909  O   ASN A 420      45.935  57.698  -2.442  1.00  0.56           O  
ATOM    910  CB  ASN A 420      46.028  54.569  -2.113  1.00  0.75           C  
ATOM    911  CG  ASN A 420      46.100  53.258  -1.360  1.00  1.57           C  
ATOM    912  OD1 ASN A 420      45.704  53.170  -0.197  1.00  2.53           O  
ATOM    913  ND2 ASN A 420      46.601  52.228  -2.027  1.00  1.98           N  
ATOM    914  H   ASN A 420      45.352  55.458   0.157  1.00  0.75           H  
ATOM    915  HA  ASN A 420      47.763  55.367  -1.149  1.00  0.71           H  
ATOM    916  HB2 ASN A 420      44.990  54.841  -2.224  1.00  1.30           H  
ATOM    917  HB3 ASN A 420      46.465  54.426  -3.088  1.00  1.19           H  
ATOM    918 HD21 ASN A 420      46.893  52.374  -2.950  1.00  1.91           H  
ATOM    919 HD22 ASN A 420      46.657  51.362  -1.572  1.00  2.76           H  
ATOM    920  N   ARG A 421      48.013  57.024  -2.996  1.00  0.62           N  
ATOM    921  CA  ARG A 421      48.248  58.120  -3.929  1.00  0.67           C  
ATOM    922  C   ARG A 421      47.302  58.028  -5.124  1.00  0.66           C  
ATOM    923  O   ARG A 421      46.837  59.045  -5.637  1.00  0.69           O  
ATOM    924  CB  ARG A 421      49.701  58.113  -4.404  1.00  0.87           C  
ATOM    925  CG  ARG A 421      50.701  58.397  -3.293  1.00  1.09           C  
ATOM    926  CD  ARG A 421      52.129  58.380  -3.811  1.00  1.51           C  
ATOM    927  NE  ARG A 421      52.509  57.070  -4.328  1.00  2.25           N  
ATOM    928  CZ  ARG A 421      53.707  56.796  -4.837  1.00  3.00           C  
ATOM    929  NH1 ARG A 421      54.635  57.742  -4.903  1.00  3.28           N  
ATOM    930  NH2 ARG A 421      53.978  55.576  -5.279  1.00  3.98           N  
ATOM    931  H   ARG A 421      48.714  56.353  -2.864  1.00  0.68           H  
ATOM    932  HA  ARG A 421      48.055  59.043  -3.406  1.00  0.66           H  
ATOM    933  HB2 ARG A 421      49.928  57.144  -4.823  1.00  1.30           H  
ATOM    934  HB3 ARG A 421      49.822  58.866  -5.169  1.00  1.29           H  
ATOM    935  HG2 ARG A 421      50.492  59.370  -2.875  1.00  1.61           H  
ATOM    936  HG3 ARG A 421      50.596  57.643  -2.527  1.00  1.39           H  
ATOM    937  HD2 ARG A 421      52.221  59.108  -4.603  1.00  1.91           H  
ATOM    938  HD3 ARG A 421      52.795  58.646  -3.003  1.00  1.94           H  
ATOM    939  HE  ARG A 421      51.839  56.355  -4.292  1.00  2.72           H  
ATOM    940 HH11 ARG A 421      54.436  58.663  -4.571  1.00  2.99           H  
ATOM    941 HH12 ARG A 421      55.535  57.532  -5.286  1.00  4.12           H  
ATOM    942 HH21 ARG A 421      53.281  54.860  -5.231  1.00  4.27           H  
ATOM    943 HH22 ARG A 421      54.880  55.372  -5.661  1.00  4.65           H  
ATOM    944  N   ARG A 422      47.020  56.802  -5.559  1.00  0.71           N  
ATOM    945  CA  ARG A 422      46.126  56.577  -6.691  1.00  0.83           C  
ATOM    946  C   ARG A 422      44.772  57.239  -6.447  1.00  0.72           C  
ATOM    947  O   ARG A 422      44.140  57.746  -7.374  1.00  0.77           O  
ATOM    948  CB  ARG A 422      45.944  55.074  -6.932  1.00  1.01           C  
ATOM    949  CG  ARG A 422      45.300  54.340  -5.767  1.00  1.19           C  
ATOM    950  CD  ARG A 422      45.165  52.843  -6.035  1.00  1.49           C  
ATOM    951  NE  ARG A 422      44.260  52.549  -7.148  1.00  2.09           N  
ATOM    952  CZ  ARG A 422      44.619  52.572  -8.430  1.00  2.79           C  
ATOM    953  NH1 ARG A 422      45.879  52.810  -8.769  1.00  3.07           N  
ATOM    954  NH2 ARG A 422      43.720  52.336  -9.375  1.00  3.71           N  
ATOM    955  H   ARG A 422      47.422  56.031  -5.108  1.00  0.72           H  
ATOM    956  HA  ARG A 422      46.579  57.022  -7.565  1.00  0.93           H  
ATOM    957  HB2 ARG A 422      45.323  54.935  -7.804  1.00  1.40           H  
ATOM    958  HB3 ARG A 422      46.913  54.631  -7.116  1.00  1.63           H  
ATOM    959  HG2 ARG A 422      45.910  54.481  -4.890  1.00  1.77           H  
ATOM    960  HG3 ARG A 422      44.319  54.754  -5.595  1.00  1.59           H  
ATOM    961  HD2 ARG A 422      46.142  52.446  -6.267  1.00  1.85           H  
ATOM    962  HD3 ARG A 422      44.791  52.367  -5.142  1.00  1.98           H  
ATOM    963  HE  ARG A 422      43.330  52.336  -6.926  1.00  2.50           H  
ATOM    964 HH11 ARG A 422      46.566  52.971  -8.061  1.00  2.89           H  
ATOM    965 HH12 ARG A 422      46.142  52.828  -9.734  1.00  3.81           H  
ATOM    966 HH21 ARG A 422      42.771  52.138  -9.125  1.00  4.01           H  
ATOM    967 HH22 ARG A 422      43.988  52.355 -10.338  1.00  4.32           H  
ATOM    968  N   LEU A 423      44.340  57.226  -5.191  1.00  0.65           N  
ATOM    969  CA  LEU A 423      43.062  57.819  -4.802  1.00  0.62           C  
ATOM    970  C   LEU A 423      43.012  59.307  -5.145  1.00  0.52           C  
ATOM    971  O   LEU A 423      41.957  59.837  -5.494  1.00  0.53           O  
ATOM    972  CB  LEU A 423      42.837  57.631  -3.300  1.00  0.69           C  
ATOM    973  CG  LEU A 423      42.850  56.180  -2.813  1.00  0.89           C  
ATOM    974  CD1 LEU A 423      42.757  56.124  -1.296  1.00  1.31           C  
ATOM    975  CD2 LEU A 423      41.709  55.394  -3.442  1.00  1.49           C  
ATOM    976  H   LEU A 423      44.894  56.805  -4.502  1.00  0.67           H  
ATOM    977  HA  LEU A 423      42.279  57.309  -5.342  1.00  0.70           H  
ATOM    978  HB2 LEU A 423      43.609  58.172  -2.772  1.00  0.84           H  
ATOM    979  HB3 LEU A 423      41.881  58.063  -3.045  1.00  0.96           H  
ATOM    980  HG  LEU A 423      43.779  55.715  -3.108  1.00  1.73           H  
ATOM    981 HD11 LEU A 423      42.782  57.128  -0.897  1.00  1.89           H  
ATOM    982 HD12 LEU A 423      41.832  55.645  -1.008  1.00  1.84           H  
ATOM    983 HD13 LEU A 423      43.591  55.560  -0.906  1.00  1.77           H  
ATOM    984 HD21 LEU A 423      41.555  55.733  -4.456  1.00  2.04           H  
ATOM    985 HD22 LEU A 423      41.954  54.342  -3.445  1.00  1.97           H  
ATOM    986 HD23 LEU A 423      40.806  55.552  -2.870  1.00  2.03           H  
ATOM    987  N   ASP A 424      44.155  59.976  -5.023  1.00  0.49           N  
ATOM    988  CA  ASP A 424      44.247  61.408  -5.298  1.00  0.50           C  
ATOM    989  C   ASP A 424      43.737  61.754  -6.695  1.00  0.45           C  
ATOM    990  O   ASP A 424      43.996  61.040  -7.663  1.00  0.49           O  
ATOM    991  CB  ASP A 424      45.690  61.887  -5.145  1.00  0.66           C  
ATOM    992  CG  ASP A 424      46.277  61.527  -3.795  1.00  0.81           C  
ATOM    993  OD1 ASP A 424      45.640  61.840  -2.769  1.00  0.97           O  
ATOM    994  OD2 ASP A 424      47.376  60.938  -3.766  1.00  1.20           O  
ATOM    995  H   ASP A 424      44.957  59.497  -4.728  1.00  0.54           H  
ATOM    996  HA  ASP A 424      43.634  61.920  -4.572  1.00  0.53           H  
ATOM    997  HB2 ASP A 424      46.299  61.433  -5.913  1.00  0.64           H  
ATOM    998  HB3 ASP A 424      45.719  62.960  -5.255  1.00  0.77           H  
ATOM    999  N   GLY A 425      43.015  62.869  -6.781  1.00  0.44           N  
ATOM   1000  CA  GLY A 425      42.476  63.323  -8.050  1.00  0.50           C  
ATOM   1001  C   GLY A 425      41.680  64.605  -7.899  1.00  0.45           C  
ATOM   1002  O   GLY A 425      41.920  65.383  -6.978  1.00  0.70           O  
ATOM   1003  H   GLY A 425      42.852  63.394  -5.971  1.00  0.44           H  
ATOM   1004  HA2 GLY A 425      43.291  63.494  -8.738  1.00  0.64           H  
ATOM   1005  HA3 GLY A 425      41.831  62.556  -8.452  1.00  0.55           H  
ATOM   1006  N   TRP A 426      40.724  64.823  -8.796  1.00  0.50           N  
ATOM   1007  CA  TRP A 426      39.890  66.018  -8.741  1.00  0.44           C  
ATOM   1008  C   TRP A 426      38.587  65.745  -7.997  1.00  0.45           C  
ATOM   1009  O   TRP A 426      37.987  64.680  -8.146  1.00  0.57           O  
ATOM   1010  CB  TRP A 426      39.591  66.549 -10.144  1.00  0.47           C  
ATOM   1011  CG  TRP A 426      40.798  67.111 -10.837  1.00  0.49           C  
ATOM   1012  CD1 TRP A 426      41.767  66.413 -11.496  1.00  0.57           C  
ATOM   1013  CD2 TRP A 426      41.171  68.492 -10.917  1.00  0.48           C  
ATOM   1014  NE1 TRP A 426      42.710  67.278 -12.000  1.00  0.61           N  
ATOM   1015  CE2 TRP A 426      42.368  68.559 -11.655  1.00  0.55           C  
ATOM   1016  CE3 TRP A 426      40.606  69.679 -10.443  1.00  0.50           C  
ATOM   1017  CZ2 TRP A 426      43.007  69.767 -11.928  1.00  0.59           C  
ATOM   1018  CZ3 TRP A 426      41.242  70.876 -10.713  1.00  0.56           C  
ATOM   1019  CH2 TRP A 426      42.432  70.912 -11.450  1.00  0.59           C  
ATOM   1020  H   TRP A 426      40.571  64.164  -9.506  1.00  0.76           H  
ATOM   1021  HA  TRP A 426      40.440  66.771  -8.196  1.00  0.40           H  
ATOM   1022  HB2 TRP A 426      39.204  65.745 -10.751  1.00  0.54           H  
ATOM   1023  HB3 TRP A 426      38.852  67.333 -10.075  1.00  0.48           H  
ATOM   1024  HD1 TRP A 426      41.774  65.339 -11.610  1.00  0.64           H  
ATOM   1025  HE1 TRP A 426      43.500  67.019 -12.517  1.00  0.69           H  
ATOM   1026  HE3 TRP A 426      39.689  69.671  -9.871  1.00  0.51           H  
ATOM   1027  HZ2 TRP A 426      43.921  69.816 -12.498  1.00  0.66           H  
ATOM   1028  HZ3 TRP A 426      40.821  71.801 -10.350  1.00  0.62           H  
ATOM   1029  HH2 TRP A 426      42.895  71.868 -11.636  1.00  0.66           H  
ATOM   1030  N   VAL A 427      38.159  66.714  -7.195  1.00  0.39           N  
ATOM   1031  CA  VAL A 427      36.931  66.583  -6.421  1.00  0.46           C  
ATOM   1032  C   VAL A 427      36.129  67.879  -6.428  1.00  0.51           C  
ATOM   1033  O   VAL A 427      36.684  68.969  -6.286  1.00  0.70           O  
ATOM   1034  CB  VAL A 427      37.225  66.187  -4.964  1.00  0.64           C  
ATOM   1035  CG1 VAL A 427      37.740  64.762  -4.886  1.00  0.89           C  
ATOM   1036  CG2 VAL A 427      38.226  67.147  -4.348  1.00  0.85           C  
ATOM   1037  H   VAL A 427      38.685  67.538  -7.120  1.00  0.36           H  
ATOM   1038  HA  VAL A 427      36.336  65.801  -6.871  1.00  0.51           H  
ATOM   1039  HB  VAL A 427      36.306  66.248  -4.400  1.00  0.82           H  
ATOM   1040 HG11 VAL A 427      38.188  64.488  -5.831  1.00  1.39           H  
ATOM   1041 HG12 VAL A 427      38.480  64.691  -4.103  1.00  1.37           H  
ATOM   1042 HG13 VAL A 427      36.921  64.093  -4.668  1.00  1.44           H  
ATOM   1043 HG21 VAL A 427      37.836  68.153  -4.391  1.00  1.41           H  
ATOM   1044 HG22 VAL A 427      38.402  66.873  -3.318  1.00  1.32           H  
ATOM   1045 HG23 VAL A 427      39.157  67.099  -4.895  1.00  1.42           H  
ATOM   1046  N   GLY A 428      34.817  67.747  -6.588  1.00  0.52           N  
ATOM   1047  CA  GLY A 428      33.947  68.905  -6.610  1.00  0.65           C  
ATOM   1048  C   GLY A 428      33.971  69.676  -5.305  1.00  0.79           C  
ATOM   1049  O   GLY A 428      34.188  69.100  -4.239  1.00  1.72           O  
ATOM   1050  H   GLY A 428      34.435  66.850  -6.695  1.00  0.55           H  
ATOM   1051  HA2 GLY A 428      34.258  69.563  -7.408  1.00  0.70           H  
ATOM   1052  HA3 GLY A 428      32.937  68.578  -6.802  1.00  0.71           H  
ATOM   1053  N   ARG A 429      33.748  70.983  -5.394  1.00  0.54           N  
ATOM   1054  CA  ARG A 429      33.742  71.849  -4.221  1.00  0.54           C  
ATOM   1055  C   ARG A 429      32.780  71.330  -3.153  1.00  0.49           C  
ATOM   1056  O   ARG A 429      33.064  71.411  -1.958  1.00  0.53           O  
ATOM   1057  CB  ARG A 429      33.357  73.275  -4.629  1.00  0.68           C  
ATOM   1058  CG  ARG A 429      33.212  74.238  -3.459  1.00  0.83           C  
ATOM   1059  CD  ARG A 429      34.510  74.383  -2.680  1.00  0.85           C  
ATOM   1060  NE  ARG A 429      34.381  75.329  -1.573  1.00  1.20           N  
ATOM   1061  CZ  ARG A 429      33.636  75.108  -0.491  1.00  1.26           C  
ATOM   1062  NH1 ARG A 429      33.011  73.949  -0.335  1.00  1.73           N  
ATOM   1063  NH2 ARG A 429      33.535  76.040   0.445  1.00  1.65           N  
ATOM   1064  H   ARG A 429      33.582  71.378  -6.275  1.00  1.16           H  
ATOM   1065  HA  ARG A 429      34.741  71.860  -3.812  1.00  0.54           H  
ATOM   1066  HB2 ARG A 429      34.117  73.662  -5.291  1.00  0.75           H  
ATOM   1067  HB3 ARG A 429      32.417  73.243  -5.158  1.00  0.75           H  
ATOM   1068  HG2 ARG A 429      32.926  75.207  -3.841  1.00  1.02           H  
ATOM   1069  HG3 ARG A 429      32.442  73.871  -2.799  1.00  0.96           H  
ATOM   1070  HD2 ARG A 429      34.788  73.417  -2.283  1.00  0.83           H  
ATOM   1071  HD3 ARG A 429      35.281  74.731  -3.351  1.00  0.95           H  
ATOM   1072  HE  ARG A 429      34.859  76.182  -1.648  1.00  1.83           H  
ATOM   1073 HH11 ARG A 429      33.098  73.235  -1.029  1.00  1.78           H  
ATOM   1074 HH12 ARG A 429      32.453  73.789   0.480  1.00  2.32           H  
ATOM   1075 HH21 ARG A 429      34.018  76.910   0.339  1.00  2.00           H  
ATOM   1076 HH22 ARG A 429      32.976  75.874   1.259  1.00  1.92           H  
ATOM   1077  N   HIS A 430      31.638  70.805  -3.588  1.00  0.49           N  
ATOM   1078  CA  HIS A 430      30.634  70.281  -2.666  1.00  0.53           C  
ATOM   1079  C   HIS A 430      31.197  69.175  -1.780  1.00  0.47           C  
ATOM   1080  O   HIS A 430      30.746  68.987  -0.650  1.00  0.49           O  
ATOM   1081  CB  HIS A 430      29.416  69.762  -3.430  1.00  0.65           C  
ATOM   1082  CG  HIS A 430      29.743  68.785  -4.516  1.00  0.77           C  
ATOM   1083  ND1 HIS A 430      30.486  69.116  -5.630  1.00  1.20           N  
ATOM   1084  CD2 HIS A 430      29.412  67.480  -4.662  1.00  1.47           C  
ATOM   1085  CE1 HIS A 430      30.596  68.058  -6.415  1.00  1.31           C  
ATOM   1086  NE2 HIS A 430      29.953  67.053  -5.850  1.00  1.46           N  
ATOM   1087  H   HIS A 430      31.464  70.772  -4.553  1.00  0.54           H  
ATOM   1088  HA  HIS A 430      30.321  71.098  -2.033  1.00  0.60           H  
ATOM   1089  HB2 HIS A 430      28.755  69.266  -2.734  1.00  0.79           H  
ATOM   1090  HB3 HIS A 430      28.897  70.597  -3.877  1.00  0.84           H  
ATOM   1091  HD1 HIS A 430      30.877  69.996  -5.817  1.00  1.81           H  
ATOM   1092  HD2 HIS A 430      28.829  66.885  -3.973  1.00  2.23           H  
ATOM   1093  HE1 HIS A 430      31.117  68.023  -7.359  1.00  1.79           H  
ATOM   1094  HE2 HIS A 430      29.783  66.186  -6.273  1.00  1.93           H  
ATOM   1095  N   ARG A 431      32.173  68.439  -2.296  1.00  0.43           N  
ATOM   1096  CA  ARG A 431      32.780  67.346  -1.544  1.00  0.41           C  
ATOM   1097  C   ARG A 431      33.771  67.871  -0.509  1.00  0.37           C  
ATOM   1098  O   ARG A 431      33.885  67.320   0.585  1.00  0.57           O  
ATOM   1099  CB  ARG A 431      33.478  66.367  -2.489  1.00  0.44           C  
ATOM   1100  CG  ARG A 431      32.542  65.736  -3.507  1.00  0.53           C  
ATOM   1101  CD  ARG A 431      33.267  64.727  -4.380  1.00  0.64           C  
ATOM   1102  NE  ARG A 431      32.387  64.153  -5.396  1.00  1.39           N  
ATOM   1103  CZ  ARG A 431      32.788  63.275  -6.312  1.00  2.05           C  
ATOM   1104  NH1 ARG A 431      34.053  62.877  -6.348  1.00  2.55           N  
ATOM   1105  NH2 ARG A 431      31.922  62.798  -7.197  1.00  2.84           N  
ATOM   1106  H   ARG A 431      32.488  68.628  -3.205  1.00  0.44           H  
ATOM   1107  HA  ARG A 431      31.986  66.825  -1.028  1.00  0.45           H  
ATOM   1108  HB2 ARG A 431      34.254  66.893  -3.023  1.00  0.44           H  
ATOM   1109  HB3 ARG A 431      33.926  65.577  -1.906  1.00  0.48           H  
ATOM   1110  HG2 ARG A 431      31.742  65.235  -2.983  1.00  0.79           H  
ATOM   1111  HG3 ARG A 431      32.132  66.514  -4.135  1.00  0.68           H  
ATOM   1112  HD2 ARG A 431      34.094  65.220  -4.869  1.00  1.04           H  
ATOM   1113  HD3 ARG A 431      33.644  63.932  -3.754  1.00  1.03           H  
ATOM   1114  HE  ARG A 431      31.449  64.434  -5.394  1.00  1.96           H  
ATOM   1115 HH11 ARG A 431      34.710  63.236  -5.686  1.00  2.45           H  
ATOM   1116 HH12 ARG A 431      34.349  62.216  -7.038  1.00  3.35           H  
ATOM   1117 HH21 ARG A 431      30.969  63.098  -7.176  1.00  3.11           H  
ATOM   1118 HH22 ARG A 431      32.224  62.138  -7.886  1.00  3.42           H  
ATOM   1119  N   ILE A 432      34.487  68.934  -0.857  1.00  0.39           N  
ATOM   1120  CA  ILE A 432      35.462  69.524   0.053  1.00  0.36           C  
ATOM   1121  C   ILE A 432      34.822  70.586   0.940  1.00  0.38           C  
ATOM   1122  O   ILE A 432      33.994  71.376   0.485  1.00  0.44           O  
ATOM   1123  CB  ILE A 432      36.649  70.140  -0.712  1.00  0.38           C  
ATOM   1124  CG1 ILE A 432      37.359  69.060  -1.530  1.00  0.40           C  
ATOM   1125  CG2 ILE A 432      37.616  70.812   0.256  1.00  0.42           C  
ATOM   1126  CD1 ILE A 432      38.576  69.557  -2.278  1.00  0.46           C  
ATOM   1127  H   ILE A 432      34.353  69.333  -1.743  1.00  0.58           H  
ATOM   1128  HA  ILE A 432      35.844  68.733   0.682  1.00  0.36           H  
ATOM   1129  HB  ILE A 432      36.265  70.897  -1.381  1.00  0.42           H  
ATOM   1130 HG12 ILE A 432      37.681  68.271  -0.866  1.00  0.45           H  
ATOM   1131 HG13 ILE A 432      36.667  68.655  -2.253  1.00  0.41           H  
ATOM   1132 HG21 ILE A 432      37.531  70.349   1.228  1.00  1.14           H  
ATOM   1133 HG22 ILE A 432      38.627  70.699  -0.109  1.00  1.08           H  
ATOM   1134 HG23 ILE A 432      37.377  71.862   0.334  1.00  1.07           H  
ATOM   1135 HD11 ILE A 432      39.257  70.025  -1.584  1.00  1.14           H  
ATOM   1136 HD12 ILE A 432      39.065  68.723  -2.760  1.00  1.11           H  
ATOM   1137 HD13 ILE A 432      38.270  70.276  -3.023  1.00  1.08           H  
ATOM   1138  N   SER A 433      35.216  70.599   2.209  1.00  0.34           N  
ATOM   1139  CA  SER A 433      34.689  71.560   3.173  1.00  0.38           C  
ATOM   1140  C   SER A 433      35.613  71.670   4.381  1.00  0.36           C  
ATOM   1141  O   SER A 433      36.146  70.670   4.861  1.00  0.34           O  
ATOM   1142  CB  SER A 433      33.288  71.150   3.630  1.00  0.41           C  
ATOM   1143  OG  SER A 433      32.375  71.152   2.548  1.00  0.53           O  
ATOM   1144  H   SER A 433      35.881  69.943   2.507  1.00  0.31           H  
ATOM   1145  HA  SER A 433      34.633  72.522   2.686  1.00  0.46           H  
ATOM   1146  HB2 SER A 433      33.327  70.155   4.048  1.00  0.39           H  
ATOM   1147  HB3 SER A 433      32.939  71.841   4.381  1.00  0.44           H  
ATOM   1148  HG  SER A 433      32.017  72.036   2.434  1.00  0.96           H  
ATOM   1149  N   ASP A 434      35.801  72.894   4.861  1.00  0.43           N  
ATOM   1150  CA  ASP A 434      36.665  73.140   6.009  1.00  0.48           C  
ATOM   1151  C   ASP A 434      36.122  72.465   7.266  1.00  0.48           C  
ATOM   1152  O   ASP A 434      36.879  72.133   8.177  1.00  0.74           O  
ATOM   1153  CB  ASP A 434      36.808  74.643   6.244  1.00  0.60           C  
ATOM   1154  CG  ASP A 434      35.477  75.314   6.521  1.00  0.83           C  
ATOM   1155  OD1 ASP A 434      34.587  75.252   5.648  1.00  1.12           O  
ATOM   1156  OD2 ASP A 434      35.324  75.900   7.613  1.00  1.35           O  
ATOM   1157  H   ASP A 434      35.351  73.651   4.432  1.00  0.48           H  
ATOM   1158  HA  ASP A 434      37.636  72.727   5.787  1.00  0.50           H  
ATOM   1159  HB2 ASP A 434      37.458  74.809   7.090  1.00  0.63           H  
ATOM   1160  HB3 ASP A 434      37.245  75.095   5.364  1.00  0.77           H  
ATOM   1161  N   ASN A 435      34.808  72.263   7.311  1.00  0.43           N  
ATOM   1162  CA  ASN A 435      34.177  71.623   8.461  1.00  0.47           C  
ATOM   1163  C   ASN A 435      33.681  70.226   8.097  1.00  0.39           C  
ATOM   1164  O   ASN A 435      33.067  70.026   7.049  1.00  0.38           O  
ATOM   1165  CB  ASN A 435      33.017  72.476   8.981  1.00  0.59           C  
ATOM   1166  CG  ASN A 435      32.511  71.997  10.328  1.00  1.26           C  
ATOM   1167  OD1 ASN A 435      33.261  71.951  11.304  1.00  2.16           O  
ATOM   1168  ND2 ASN A 435      31.235  71.641  10.390  1.00  1.81           N  
ATOM   1169  H   ASN A 435      34.251  72.548   6.555  1.00  0.58           H  
ATOM   1170  HA  ASN A 435      34.923  71.536   9.237  1.00  0.57           H  
ATOM   1171  HB2 ASN A 435      33.348  73.499   9.083  1.00  1.33           H  
ATOM   1172  HB3 ASN A 435      32.203  72.433   8.275  1.00  1.18           H  
ATOM   1173 HD21 ASN A 435      30.697  71.705   9.575  1.00  1.92           H  
ATOM   1174 HD22 ASN A 435      30.881  71.332  11.251  1.00  2.53           H  
ATOM   1175  N   ALA A 436      33.968  69.262   8.965  1.00  0.49           N  
ATOM   1176  CA  ALA A 436      33.573  67.877   8.739  1.00  0.55           C  
ATOM   1177  C   ALA A 436      32.074  67.662   8.941  1.00  0.55           C  
ATOM   1178  O   ALA A 436      31.445  66.908   8.197  1.00  0.54           O  
ATOM   1179  CB  ALA A 436      34.362  66.955   9.657  1.00  0.75           C  
ATOM   1180  H   ALA A 436      34.471  69.487   9.776  1.00  0.58           H  
ATOM   1181  HA  ALA A 436      33.825  67.623   7.720  1.00  0.55           H  
ATOM   1182  HB1 ALA A 436      35.036  67.542  10.263  1.00  1.33           H  
ATOM   1183  HB2 ALA A 436      34.930  66.254   9.062  1.00  1.30           H  
ATOM   1184  HB3 ALA A 436      33.680  66.415  10.297  1.00  1.23           H  
ATOM   1185  N   ASP A 437      31.511  68.309   9.959  1.00  0.65           N  
ATOM   1186  CA  ASP A 437      30.087  68.168  10.269  1.00  0.75           C  
ATOM   1187  C   ASP A 437      29.215  68.367   9.031  1.00  0.71           C  
ATOM   1188  O   ASP A 437      28.241  67.641   8.830  1.00  0.78           O  
ATOM   1189  CB  ASP A 437      29.679  69.164  11.356  1.00  0.92           C  
ATOM   1190  CG  ASP A 437      30.447  68.959  12.648  1.00  1.02           C  
ATOM   1191  OD1 ASP A 437      30.357  67.854  13.223  1.00  1.34           O  
ATOM   1192  OD2 ASP A 437      31.138  69.903  13.085  1.00  1.34           O  
ATOM   1193  H   ASP A 437      32.068  68.882  10.526  1.00  0.70           H  
ATOM   1194  HA  ASP A 437      29.933  67.168  10.641  1.00  0.80           H  
ATOM   1195  HB2 ASP A 437      29.864  70.167  11.005  1.00  0.91           H  
ATOM   1196  HB3 ASP A 437      28.625  69.048  11.564  1.00  1.02           H  
ATOM   1197  N   ASP A 438      29.568  69.345   8.204  1.00  0.68           N  
ATOM   1198  CA  ASP A 438      28.810  69.622   6.987  1.00  0.73           C  
ATOM   1199  C   ASP A 438      28.905  68.457   6.007  1.00  0.73           C  
ATOM   1200  O   ASP A 438      27.920  68.088   5.368  1.00  1.35           O  
ATOM   1201  CB  ASP A 438      29.309  70.907   6.322  1.00  0.88           C  
ATOM   1202  CG  ASP A 438      28.960  72.147   7.120  1.00  1.08           C  
ATOM   1203  OD1 ASP A 438      29.372  72.233   8.294  1.00  1.56           O  
ATOM   1204  OD2 ASP A 438      28.273  73.033   6.570  1.00  1.36           O  
ATOM   1205  H   ASP A 438      30.355  69.890   8.412  1.00  0.69           H  
ATOM   1206  HA  ASP A 438      27.775  69.753   7.269  1.00  0.83           H  
ATOM   1207  HB2 ASP A 438      30.382  70.857   6.221  1.00  0.89           H  
ATOM   1208  HB3 ASP A 438      28.862  70.992   5.342  1.00  0.96           H  
ATOM   1209  N   LEU A 439      30.099  67.886   5.891  1.00  0.54           N  
ATOM   1210  CA  LEU A 439      30.332  66.768   4.986  1.00  0.53           C  
ATOM   1211  C   LEU A 439      29.540  65.530   5.408  1.00  0.61           C  
ATOM   1212  O   LEU A 439      28.454  65.274   4.884  1.00  0.86           O  
ATOM   1213  CB  LEU A 439      31.823  66.446   4.911  1.00  0.52           C  
ATOM   1214  CG  LEU A 439      32.707  67.579   4.389  1.00  0.63           C  
ATOM   1215  CD1 LEU A 439      34.159  67.144   4.365  1.00  1.12           C  
ATOM   1216  CD2 LEU A 439      32.264  68.011   3.002  1.00  1.10           C  
ATOM   1217  H   LEU A 439      30.846  68.230   6.427  1.00  0.93           H  
ATOM   1218  HA  LEU A 439      29.994  67.070   4.006  1.00  0.63           H  
ATOM   1219  HB2 LEU A 439      32.166  66.182   5.900  1.00  0.73           H  
ATOM   1220  HB3 LEU A 439      31.954  65.594   4.263  1.00  0.76           H  
ATOM   1221  HG  LEU A 439      32.623  68.428   5.051  1.00  1.38           H  
ATOM   1222 HD11 LEU A 439      34.260  66.257   3.758  1.00  1.76           H  
ATOM   1223 HD12 LEU A 439      34.765  67.936   3.948  1.00  1.65           H  
ATOM   1224 HD13 LEU A 439      34.488  66.930   5.371  1.00  1.66           H  
ATOM   1225 HD21 LEU A 439      31.912  67.153   2.451  1.00  1.65           H  
ATOM   1226 HD22 LEU A 439      31.470  68.738   3.087  1.00  1.70           H  
ATOM   1227 HD23 LEU A 439      33.103  68.454   2.482  1.00  1.63           H  
ATOM   1228  N   GLY A 440      30.088  64.756   6.346  1.00  0.59           N  
ATOM   1229  CA  GLY A 440      29.410  63.554   6.798  1.00  0.77           C  
ATOM   1230  C   GLY A 440      29.489  63.356   8.301  1.00  0.96           C  
ATOM   1231  O   GLY A 440      29.549  62.224   8.775  1.00  1.36           O  
ATOM   1232  H   GLY A 440      30.956  64.998   6.726  1.00  0.62           H  
ATOM   1233  HA2 GLY A 440      28.370  63.607   6.507  1.00  0.83           H  
ATOM   1234  HA3 GLY A 440      29.861  62.700   6.313  1.00  0.91           H  
ATOM   1235  N   GLY A 441      29.472  64.461   9.047  1.00  0.93           N  
ATOM   1236  CA  GLY A 441      29.524  64.393  10.502  1.00  1.24           C  
ATOM   1237  C   GLY A 441      30.540  63.398  11.031  1.00  1.14           C  
ATOM   1238  O   GLY A 441      30.252  62.649  11.963  1.00  1.83           O  
ATOM   1239  H   GLY A 441      29.410  65.333   8.606  1.00  0.91           H  
ATOM   1240  HA2 GLY A 441      29.770  65.371  10.886  1.00  1.44           H  
ATOM   1241  HA3 GLY A 441      28.551  64.117  10.867  1.00  1.56           H  
ATOM   1242  N   ILE A 442      31.725  63.407  10.443  1.00  1.10           N  
ATOM   1243  CA  ILE A 442      32.804  62.516  10.847  1.00  1.03           C  
ATOM   1244  C   ILE A 442      32.513  61.064  10.447  1.00  1.05           C  
ATOM   1245  O   ILE A 442      32.219  60.211  11.286  1.00  1.39           O  
ATOM   1246  CB  ILE A 442      33.050  62.614  12.361  1.00  1.26           C  
ATOM   1247  CG1 ILE A 442      33.448  64.043  12.748  1.00  1.41           C  
ATOM   1248  CG2 ILE A 442      34.116  61.621  12.813  1.00  1.38           C  
ATOM   1249  CD1 ILE A 442      34.732  64.518  12.102  1.00  1.48           C  
ATOM   1250  H   ILE A 442      31.881  64.036   9.726  1.00  1.64           H  
ATOM   1251  HA  ILE A 442      33.701  62.839  10.339  1.00  0.97           H  
ATOM   1252  HB  ILE A 442      32.126  62.368  12.850  1.00  1.41           H  
ATOM   1253 HG12 ILE A 442      32.659  64.720  12.452  1.00  1.56           H  
ATOM   1254 HG13 ILE A 442      33.575  64.095  13.819  1.00  1.74           H  
ATOM   1255 HG21 ILE A 442      35.007  61.755  12.217  1.00  1.61           H  
ATOM   1256 HG22 ILE A 442      34.349  61.790  13.854  1.00  1.81           H  
ATOM   1257 HG23 ILE A 442      33.747  60.614  12.686  1.00  1.80           H  
ATOM   1258 HD11 ILE A 442      34.859  64.029  11.148  1.00  1.92           H  
ATOM   1259 HD12 ILE A 442      34.687  65.587  11.956  1.00  1.89           H  
ATOM   1260 HD13 ILE A 442      35.568  64.278  12.742  1.00  1.76           H  
ATOM   1261  N   THR A 443      32.626  60.803   9.147  1.00  1.13           N  
ATOM   1262  CA  THR A 443      32.419  59.476   8.580  1.00  1.36           C  
ATOM   1263  C   THR A 443      31.173  58.772   9.112  1.00  1.47           C  
ATOM   1264  O   THR A 443      31.246  57.675   9.669  1.00  2.20           O  
ATOM   1265  CB  THR A 443      33.654  58.598   8.809  1.00  2.21           C  
ATOM   1266  OG1 THR A 443      34.821  59.262   8.311  1.00  3.05           O  
ATOM   1267  CG2 THR A 443      33.512  57.244   8.126  1.00  2.78           C  
ATOM   1268  H   THR A 443      32.885  61.525   8.549  1.00  1.32           H  
ATOM   1269  HA  THR A 443      32.293  59.597   7.519  1.00  1.77           H  
ATOM   1270  HB  THR A 443      33.760  58.450   9.868  1.00  2.55           H  
ATOM   1271  HG1 THR A 443      34.815  60.179   8.594  1.00  3.42           H  
ATOM   1272 HG21 THR A 443      32.481  57.089   7.843  1.00  3.13           H  
ATOM   1273 HG22 THR A 443      34.135  57.217   7.245  1.00  3.23           H  
ATOM   1274 HG23 THR A 443      33.819  56.462   8.807  1.00  3.10           H  
ATOM   1275  N   VAL A 444      30.027  59.401   8.910  1.00  1.90           N  
ATOM   1276  CA  VAL A 444      28.763  58.846   9.325  1.00  2.70           C  
ATOM   1277  C   VAL A 444      27.646  59.351   8.418  1.00  3.02           C  
ATOM   1278  O   VAL A 444      27.500  60.555   8.209  1.00  3.60           O  
ATOM   1279  CB  VAL A 444      28.434  59.211  10.771  1.00  3.53           C  
ATOM   1280  CG1 VAL A 444      29.356  58.498  11.747  1.00  4.18           C  
ATOM   1281  CG2 VAL A 444      28.480  60.712  10.980  1.00  4.02           C  
ATOM   1282  H   VAL A 444      30.029  60.255   8.457  1.00  2.21           H  
ATOM   1283  HA  VAL A 444      28.825  57.771   9.247  1.00  3.01           H  
ATOM   1284  HB  VAL A 444      27.443  58.886  10.949  1.00  3.88           H  
ATOM   1285 HG11 VAL A 444      29.676  57.559  11.321  1.00  4.32           H  
ATOM   1286 HG12 VAL A 444      30.221  59.116  11.942  1.00  4.55           H  
ATOM   1287 HG13 VAL A 444      28.828  58.313  12.670  1.00  4.64           H  
ATOM   1288 HG21 VAL A 444      29.359  61.116  10.501  1.00  4.34           H  
ATOM   1289 HG22 VAL A 444      27.597  61.162  10.552  1.00  4.35           H  
ATOM   1290 HG23 VAL A 444      28.516  60.927  12.039  1.00  4.27           H  
ATOM   1291  N   LEU A 445      26.867  58.427   7.871  1.00  3.13           N  
ATOM   1292  CA  LEU A 445      25.775  58.792   6.978  1.00  3.83           C  
ATOM   1293  C   LEU A 445      24.580  59.338   7.757  1.00  4.75           C  
ATOM   1294  O   LEU A 445      24.077  58.688   8.672  1.00  4.99           O  
ATOM   1295  CB  LEU A 445      25.350  57.586   6.139  1.00  3.87           C  
ATOM   1296  CG  LEU A 445      26.448  56.992   5.255  1.00  3.48           C  
ATOM   1297  CD1 LEU A 445      25.907  55.821   4.449  1.00  3.82           C  
ATOM   1298  CD2 LEU A 445      27.027  58.054   4.332  1.00  3.70           C  
ATOM   1299  H   LEU A 445      27.034  57.481   8.064  1.00  3.04           H  
ATOM   1300  HA  LEU A 445      26.140  59.563   6.316  1.00  4.04           H  
ATOM   1301  HB2 LEU A 445      24.998  56.815   6.808  1.00  4.14           H  
ATOM   1302  HB3 LEU A 445      24.532  57.887   5.502  1.00  4.36           H  
ATOM   1303  HG  LEU A 445      27.247  56.623   5.884  1.00  3.46           H  
ATOM   1304 HD11 LEU A 445      24.936  55.543   4.828  1.00  4.26           H  
ATOM   1305 HD12 LEU A 445      25.822  56.108   3.411  1.00  4.01           H  
ATOM   1306 HD13 LEU A 445      26.582  54.982   4.535  1.00  3.98           H  
ATOM   1307 HD21 LEU A 445      27.084  58.996   4.857  1.00  3.88           H  
ATOM   1308 HD22 LEU A 445      28.016  57.757   4.015  1.00  3.91           H  
ATOM   1309 HD23 LEU A 445      26.391  58.163   3.465  1.00  4.11           H  
ATOM   1310  N   PRO A 446      24.103  60.546   7.396  1.00  5.56           N  
ATOM   1311  CA  PRO A 446      22.958  61.175   8.063  1.00  6.59           C  
ATOM   1312  C   PRO A 446      21.644  60.482   7.719  1.00  7.07           C  
ATOM   1313  O   PRO A 446      21.426  60.084   6.574  1.00  7.26           O  
ATOM   1314  CB  PRO A 446      22.970  62.602   7.517  1.00  7.40           C  
ATOM   1315  CG  PRO A 446      23.620  62.489   6.181  1.00  6.97           C  
ATOM   1316  CD  PRO A 446      24.639  61.391   6.308  1.00  5.82           C  
ATOM   1317  HA  PRO A 446      23.085  61.193   9.136  1.00  6.67           H  
ATOM   1318  HB2 PRO A 446      21.956  62.969   7.435  1.00  8.01           H  
ATOM   1319  HB3 PRO A 446      23.538  63.239   8.178  1.00  7.82           H  
ATOM   1320  HG2 PRO A 446      22.882  62.232   5.436  1.00  7.47           H  
ATOM   1321  HG3 PRO A 446      24.103  63.421   5.928  1.00  7.18           H  
ATOM   1322  HD2 PRO A 446      24.709  60.832   5.387  1.00  5.90           H  
ATOM   1323  HD3 PRO A 446      25.602  61.799   6.579  1.00  5.41           H  
ATOM   1324  N   ALA A 447      20.773  60.340   8.714  1.00  7.52           N  
ATOM   1325  CA  ALA A 447      19.482  59.692   8.509  1.00  8.19           C  
ATOM   1326  C   ALA A 447      18.711  60.358   7.369  1.00  8.83           C  
ATOM   1327  O   ALA A 447      18.542  61.577   7.355  1.00  9.06           O  
ATOM   1328  CB  ALA A 447      18.666  59.726   9.793  1.00  8.42           C  
ATOM   1329  H   ALA A 447      21.004  60.676   9.606  1.00  7.56           H  
ATOM   1330  HA  ALA A 447      19.665  58.659   8.254  1.00  8.35           H  
ATOM   1331  HB1 ALA A 447      18.028  58.856   9.836  1.00  8.54           H  
ATOM   1332  HB2 ALA A 447      18.057  60.619   9.809  1.00  8.56           H  
ATOM   1333  HB3 ALA A 447      19.331  59.728  10.643  1.00  8.62           H  
ATOM   1334  N   PRO A 448      18.237  59.562   6.390  1.00  9.38           N  
ATOM   1335  CA  PRO A 448      17.489  60.086   5.240  1.00 10.23           C  
ATOM   1336  C   PRO A 448      16.206  60.802   5.657  1.00 10.87           C  
ATOM   1337  O   PRO A 448      15.419  60.276   6.444  1.00 11.06           O  
ATOM   1338  CB  PRO A 448      17.154  58.834   4.421  1.00 10.80           C  
ATOM   1339  CG  PRO A 448      18.123  57.799   4.876  1.00 10.31           C  
ATOM   1340  CD  PRO A 448      18.399  58.101   6.321  1.00  9.48           C  
ATOM   1341  HA  PRO A 448      18.095  60.754   4.648  1.00 10.21           H  
ATOM   1342  HB2 PRO A 448      16.134  58.535   4.620  1.00 11.42           H  
ATOM   1343  HB3 PRO A 448      17.271  59.049   3.370  1.00 11.10           H  
ATOM   1344  HG2 PRO A 448      17.686  56.816   4.775  1.00 10.69           H  
ATOM   1345  HG3 PRO A 448      19.033  57.868   4.297  1.00 10.36           H  
ATOM   1346  HD2 PRO A 448      17.683  57.600   6.955  1.00  9.62           H  
ATOM   1347  HD3 PRO A 448      19.406  57.812   6.580  1.00  9.08           H  
ATOM   1348  N   PRO A 449      15.972  62.018   5.128  1.00 11.41           N  
ATOM   1349  CA  PRO A 449      14.776  62.803   5.448  1.00 12.23           C  
ATOM   1350  C   PRO A 449      13.498  62.128   4.965  1.00 13.10           C  
ATOM   1351  O   PRO A 449      13.421  61.671   3.823  1.00 13.50           O  
ATOM   1352  CB  PRO A 449      14.992  64.128   4.701  1.00 12.72           C  
ATOM   1353  CG  PRO A 449      16.442  64.155   4.352  1.00 12.39           C  
ATOM   1354  CD  PRO A 449      16.851  62.722   4.182  1.00 11.49           C  
ATOM   1355  HA  PRO A 449      14.702  62.994   6.509  1.00 12.04           H  
ATOM   1356  HB2 PRO A 449      14.374  64.146   3.815  1.00 13.53           H  
ATOM   1357  HB3 PRO A 449      14.728  64.952   5.346  1.00 12.61           H  
ATOM   1358  HG2 PRO A 449      16.589  64.699   3.430  1.00 13.04           H  
ATOM   1359  HG3 PRO A 449      17.004  64.613   5.154  1.00 12.30           H  
ATOM   1360  HD2 PRO A 449      16.673  62.394   3.169  1.00 11.77           H  
ATOM   1361  HD3 PRO A 449      17.889  62.589   4.448  1.00 10.85           H  
ATOM   1362  N   LEU A 450      12.497  62.072   5.837  1.00 13.55           N  
ATOM   1363  CA  LEU A 450      11.218  61.456   5.496  1.00 14.50           C  
ATOM   1364  C   LEU A 450      10.341  62.421   4.699  1.00 14.96           C  
ATOM   1365  O   LEU A 450       9.157  62.587   4.996  1.00 15.17           O  
ATOM   1366  CB  LEU A 450      10.488  61.013   6.768  1.00 15.07           C  
ATOM   1367  CG  LEU A 450      11.228  59.977   7.620  1.00 15.25           C  
ATOM   1368  CD1 LEU A 450      10.440  59.667   8.883  1.00 15.76           C  
ATOM   1369  CD2 LEU A 450      11.475  58.705   6.822  1.00 15.35           C  
ATOM   1370  H   LEU A 450      12.619  62.457   6.730  1.00 13.32           H  
ATOM   1371  HA  LEU A 450      11.421  60.588   4.889  1.00 14.63           H  
ATOM   1372  HB2 LEU A 450      10.308  61.886   7.378  1.00 15.17           H  
ATOM   1373  HB3 LEU A 450       9.534  60.594   6.482  1.00 15.44           H  
ATOM   1374  HG  LEU A 450      12.186  60.382   7.914  1.00 15.14           H  
ATOM   1375 HD11 LEU A 450       9.584  60.321   8.944  1.00 16.01           H  
ATOM   1376 HD12 LEU A 450      10.108  58.640   8.856  1.00 15.88           H  
ATOM   1377 HD13 LEU A 450      11.072  59.818   9.747  1.00 15.90           H  
ATOM   1378 HD21 LEU A 450      10.677  58.566   6.109  1.00 15.59           H  
ATOM   1379 HD22 LEU A 450      12.415  58.785   6.298  1.00 15.19           H  
ATOM   1380 HD23 LEU A 450      11.510  57.860   7.494  1.00 15.50           H  
ATOM   1381  N   ALA A 451      10.931  63.058   3.688  1.00 15.28           N  
ATOM   1382  CA  ALA A 451      10.204  64.010   2.852  1.00 15.91           C  
ATOM   1383  C   ALA A 451       9.614  65.138   3.696  1.00 16.47           C  
ATOM   1384  O   ALA A 451       8.395  65.300   3.769  1.00 16.74           O  
ATOM   1385  CB  ALA A 451       9.110  63.303   2.064  1.00 16.18           C  
ATOM   1386  H   ALA A 451      11.876  62.887   3.504  1.00 15.21           H  
ATOM   1387  HA  ALA A 451      10.907  64.433   2.150  1.00 15.94           H  
ATOM   1388  HB1 ALA A 451       8.447  64.035   1.632  1.00 16.28           H  
ATOM   1389  HB2 ALA A 451       8.553  62.655   2.723  1.00 16.27           H  
ATOM   1390  HB3 ALA A 451       9.558  62.714   1.276  1.00 16.32           H  
ATOM   1391  N   PRO A 452      10.477  65.935   4.354  1.00 16.82           N  
ATOM   1392  CA  PRO A 452      10.035  67.047   5.202  1.00 17.52           C  
ATOM   1393  C   PRO A 452       9.349  68.153   4.409  1.00 18.21           C  
ATOM   1394  O   PRO A 452       9.827  68.563   3.350  1.00 18.53           O  
ATOM   1395  CB  PRO A 452      11.333  67.565   5.831  1.00 17.79           C  
ATOM   1396  CG  PRO A 452      12.417  67.112   4.916  1.00 17.36           C  
ATOM   1397  CD  PRO A 452      11.946  65.813   4.323  1.00 16.73           C  
ATOM   1398  HA  PRO A 452       9.370  66.704   5.981  1.00 17.50           H  
ATOM   1399  HB2 PRO A 452      11.297  68.642   5.896  1.00 18.40           H  
ATOM   1400  HB3 PRO A 452      11.450  67.144   6.818  1.00 17.78           H  
ATOM   1401  HG2 PRO A 452      12.570  67.844   4.137  1.00 17.76           H  
ATOM   1402  HG3 PRO A 452      13.328  66.959   5.474  1.00 17.23           H  
ATOM   1403  HD2 PRO A 452      12.303  65.710   3.309  1.00 16.84           H  
ATOM   1404  HD3 PRO A 452      12.275  64.980   4.925  1.00 16.27           H  
ATOM   1405  N   ASP A 453       8.227  68.635   4.936  1.00 18.57           N  
ATOM   1406  CA  ASP A 453       7.465  69.699   4.291  1.00 19.36           C  
ATOM   1407  C   ASP A 453       6.347  70.187   5.209  1.00 19.52           C  
ATOM   1408  O   ASP A 453       5.558  69.391   5.719  1.00 19.55           O  
ATOM   1409  CB  ASP A 453       6.874  69.203   2.967  1.00 19.71           C  
ATOM   1410  CG  ASP A 453       6.123  70.290   2.220  1.00 20.25           C  
ATOM   1411  OD1 ASP A 453       5.116  70.798   2.760  1.00 20.55           O  
ATOM   1412  OD2 ASP A 453       6.542  70.636   1.095  1.00 20.48           O  
ATOM   1413  H   ASP A 453       7.905  68.266   5.785  1.00 18.38           H  
ATOM   1414  HA  ASP A 453       8.139  70.518   4.093  1.00 19.73           H  
ATOM   1415  HB2 ASP A 453       7.675  68.849   2.334  1.00 19.66           H  
ATOM   1416  HB3 ASP A 453       6.191  68.392   3.166  1.00 19.75           H  
ATOM   1417  N   GLN A 454       6.289  71.498   5.416  1.00 19.77           N  
ATOM   1418  CA  GLN A 454       5.270  72.093   6.273  1.00 20.09           C  
ATOM   1419  C   GLN A 454       3.891  71.992   5.628  1.00 20.37           C  
ATOM   1420  O   GLN A 454       3.730  72.496   4.497  1.00 20.63           O  
ATOM   1421  CB  GLN A 454       5.608  73.555   6.568  1.00 20.30           C  
ATOM   1422  CG  GLN A 454       6.945  73.741   7.269  1.00 20.53           C  
ATOM   1423  CD  GLN A 454       7.253  75.194   7.596  1.00 20.93           C  
ATOM   1424  OE1 GLN A 454       8.307  75.503   8.151  1.00 21.22           O  
ATOM   1425  NE2 GLN A 454       6.334  76.094   7.260  1.00 21.08           N  
ATOM   1426  OXT GLN A 454       2.983  71.413   6.261  1.00 20.45           O  
ATOM   1427  H   GLN A 454       6.948  72.081   4.982  1.00 19.82           H  
ATOM   1428  HA  GLN A 454       5.259  71.541   7.201  1.00 20.12           H  
ATOM   1429  HB2 GLN A 454       5.635  74.102   5.637  1.00 20.31           H  
ATOM   1430  HB3 GLN A 454       4.837  73.972   7.197  1.00 20.42           H  
ATOM   1431  HG2 GLN A 454       6.934  73.178   8.189  1.00 20.46           H  
ATOM   1432  HG3 GLN A 454       7.727  73.361   6.626  1.00 20.59           H  
ATOM   1433 HE21 GLN A 454       5.515  75.783   6.821  1.00 20.91           H  
ATOM   1434 HE22 GLN A 454       6.514  77.035   7.465  1.00 21.41           H  
TER    1435      GLN A 454                                                      
END
MOLECULE T0504.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37      A    N   
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83      A    C   
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78      A    C   
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39      A    C   
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16      A    C   
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97      A    O   
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44      A    O   
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49      A    C   
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06      A    O   
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86      A    N   
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98      A    C   
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58      A    C   
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84      A    C   
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71      A    O   
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97      A    N   
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53      A    C   
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15      A    O   
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85      A    N   
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02      A    C   
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25      A    C   
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02      A    C   
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09      A    C   
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44      A    C   
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19      A    C   
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84      A    O   
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57      A    N   
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42      A    C   
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98      A    C   
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50      A    C   
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82      A    C   
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45      A    C   
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13      A    C   
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65      A    O   
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20      A    C   
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73      A    C   
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61      A    C   
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26      A    O   
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30      A    N   
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43      A    C   
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10      A    C   
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27      A    C   
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53      A    C   
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63      A    C   
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66      A    C   
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69      A    C   
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08      A    C   
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65      A    C   
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56      A    O   
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36      A    N   
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14      A    C   
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23      A    C   
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69      A    C   
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80      A    C   
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70      A    O   
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90      A    N   
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19      A    C   
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02      A    O   
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63      A    N   
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46      A    C   
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41      A    C   
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44      A    O   
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77      A    N   
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30      A    C   
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54      A    C   
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43      A    C   
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86      A    O   
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63      A    O   
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60      A    C   
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73      A    O   
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56      A    N   
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77      A    C   
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79      A    C   
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44      A    C   
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81      A    C   
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75      A    C   
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16      A    C   
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21      A    O   
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94      A    N   
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76      A    C   
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23      A    C   
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89      A    C   
ATOM     82  CD1 ILE    10      43.756  81.529   2.264  1.00 19.82      A    C   
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10      A    C   
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82      A    C   
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77      A    O   
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59      A    N   
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06      A    C   
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08      A    C   
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60      A    C   
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92      A    C   
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05      A    C   
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69      A    O   
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61      A    N   
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09      A    C   
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98      A    C   
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77      A    O   
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91      A    C   
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32      A    O   
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08      A    N   
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70      A    C   
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79      A    C   
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89      A    C   
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11      A    S   
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35      A    C   
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22      A    C   
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56      A    O   
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80      A    N   
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49      A    C   
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73      A    C   
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59      A    C   
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95      A    C   
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61      A    N   
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50      A    C   
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44      A    N   
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31      A    N   
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43      A    C   
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04      A    O   
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91      A    N   
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92      A    C   
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59      A    C   
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51      A    C   
ATOM    122  CD1 ILE    15      39.996  70.306   0.585  1.00 27.05      A    C   
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98      A    C   
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96      A    C   
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85      A    O   
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39      A    N   
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24      A    C   
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17      A    C   
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85      A    C   
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99      A    C   
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18      A    C   
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28      A    C   
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31      A    O   
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22      A    N   
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80      A    C   
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12      A    C   
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61      A    O   
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83      A    N   
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17      A    C   
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50      A    C   
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64      A    C   
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12      A    C   
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74      A    C   
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73      A    N   
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38      A    C   
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23      A    O   
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11      A    N   
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79      A    C   
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26      A    C   
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88      A    C   
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99      A    C   
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04      A    C   
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94      A    N   
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81      A    C   
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30      A    O   
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76      A    N   
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24      A    C   
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99      A    C   
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44      A    C   
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93      A    C   
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65      A    N   
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27      A    C   
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35      A    N   
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75      A    N   
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01      A    C   
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04      A    O   
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23      A    N   
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54      A    C   
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45      A    C   
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78      A    O   
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28      A    C   
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38      A    C   
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92      A    O   
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59      A    N   
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14      A    C   
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57      A    C   
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45      A    C   
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60      A    C   
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60      A    C   
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41      A    N   
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65      A    C   
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29      A    O   
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11      A    N   
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84      A    C   
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56      A    C   
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85      A    O   
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10      A    C   
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11      A    C   
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72      A    O   
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67      A    N   
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31      A    C   
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09      A    C   
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47      A    C   
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88      A    C   
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63      A    N   
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14      A    C   
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29      A    C   
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05      A    C   
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65      A    C   
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25      A    C   
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47      A    C   
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55      A    C   
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75      A    O   
ATOM    204  N   HIS    25      37.463  62.079   4.725  1.00 21.41      A    N   
ATOM    205  CA  HIS    25      38.827  61.919   5.220  1.00 21.79      A    C   
ATOM    206  CB  HIS    25      39.499  60.706   4.534  1.00 22.01      A    C   
ATOM    207  CG  HIS    25      38.761  59.428   4.754  1.00 21.78      A    C   
ATOM    208  ND1 HIS    25      37.736  59.007   3.930  1.00 24.64      A    N   
ATOM    209  CE1 HIS    25      37.239  57.871   4.392  1.00 21.18      A    C   
ATOM    210  NE2 HIS    25      37.889  57.555   5.498  1.00 25.69      A    N   
ATOM    211  CD2 HIS    25      38.845  58.514   5.748  1.00 20.97      A    C   
ATOM    212  C   HIS    25      39.676  63.161   5.020  1.00 22.34      A    C   
ATOM    213  O   HIS    25      39.459  63.941   4.095  1.00 22.06      A    O   
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29      A    N   
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67      A    C   
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03      A    C   
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30      A    C   
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62      A    C   
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11      A    C   
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57      A    N   
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07      A    C   
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59      A    O   
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33      A    N   
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34      A    C   
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08      A    C   
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58      A    O   
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74      A    N   
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93      A    C   
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06      A    C   
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73      A    O   
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50      A    C   
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32      A    C   
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70      A    O   
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17      A    N   
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39      A    C   
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00      A    C   
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05      A    C   
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84      A    C   
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24      A    C   
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77      A    C   
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81      A    O   
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86      A    N   
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29      A    C   
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12      A    C   
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65      A    C   
ATOM    246  CD1 ILE    30      47.190  67.505  -5.529  1.00 23.75      A    C   
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13      A    C   
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92      A    C   
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81      A    O   
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57      A    N   
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70      A    C   
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85      A    C   
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21      A    C   
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86      A    O   
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51      A    N   
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06      A    C   
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62      A    C   
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72      A    C   
ATOM    259  CD1 ILE    32      41.312  76.990  -4.538  1.00 21.43      A    C   
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89      A    C   
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59      A    C   
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54      A    O   
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30      A    N   
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55      A    C   
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71      A    C   
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65      A    C   
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37      A    C   
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45      A    O   
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01      A    N   
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54      A    C   
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76      A    O   
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78      A    N   
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41      A    C   
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30      A    C   
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81      A    O   
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36      A    C   
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52      A    C   
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01      A    O   
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56      A    N   
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84      A    C   
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18      A    C   
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09      A    C   
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61      A    C   
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94      A    C   
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63      A    O   
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84      A    N   
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85      A    C   
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67      A    C   
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99      A    O   
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19      A    N   
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16      A    C   
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59      A    C   
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83      A    C   
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32      A    C   
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79      A    C   
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51      A    O   
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42      A    N   
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23      A    C   
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59      A    C   
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97      A    O   
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52      A    N   
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99      A    C   
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28      A    C   
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73      A    C   
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93      A    C   
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28      A    C   
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24      A    N   
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68      A    C   
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89      A    O   
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54      A    N   
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74      A    C   
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45      A    C   
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21      A    C   
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42      A    C   
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38      A    C   
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30      A    N   
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98      A    C   
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60      A    O   
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67      A    N   
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61      A    C   
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74      A    C   
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37      A    C   
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43      A    C   
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08      A    C   
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70      A    C   
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71      A    O   
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29      A    C   
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84      A    C   
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85      A    C   
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49      A    O   
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94      A    N   
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02      A    C   
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22      A    C   
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67      A    C   
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84      A    C   
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36      A    C   
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81      A    N   
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53      A    C   
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05      A    O   
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35      A    N   
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92      A    C   
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50      A    C   
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28      A    C   
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88      A    C   
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25      A    C   
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86      A    O   
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74      A    N   
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81      A    C   
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63      A    C   
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17      A    C   
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45      A    C   
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65      A    C   
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07      A    N   
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00      A    C   
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51      A    O   
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53      A    N   
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40      A    C   
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65      A    C   
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24      A    C   
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75      A    C   
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50      A    C   
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86      A    C   
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89      A    C   
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72      A    C   
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99      A    C   
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81      A    O   
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71      A    N   
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20      A    C   
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20      A    C   
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31      A    C   
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82      A    O   
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86      A    O   
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51      A    C   
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78      A    O   
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36      A    N   
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07      A    C   
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82      A    C   
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15      A    O   
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00           N   
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00           C   
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00           C   
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00           C   
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89      A    O   
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66      A    N   
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00      A    C   
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62      A    C   
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03      A    O   
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46      A    N   
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65      A    C   
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92      A    C   
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50      A    C   
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70      A    C   
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53      A    C   
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89      A    N   
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83      A    C   
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32      A    O   
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37      A    N   
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75      A    C   
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54      A    C   
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38      A    O   
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54      A    C   
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69      A    O   
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75      A    N   
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31      A    C   
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47      A    C   
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39      A    C   
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20      A    C   
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52      A    C   
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65      A    C   
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95      A    O   
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72      A    N   
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96      A    C   
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56      A    C   
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20      A    C   
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98      A    C   
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46      A    C   
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06      A    C   
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74      A    O   
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72      A    N   
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06      A    C   
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95      A    C   
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54      A    O   
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42      A    C   
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57      A    O   
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72      A    N   
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16      A    C   
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50      A    C   
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73      A    O   
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83      A    N   
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79      A    C   
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23      A    C   
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56      A    C   
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74      A    O   
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32      A    N   
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90      A    C   
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34      A    O   
ATOM    437  N   HIS    57      31.698  68.348  -2.203  1.00 18.92      A    N   
ATOM    438  CA  HIS    57      32.361  67.115  -1.745  1.00 19.22      A    C   
ATOM    439  CB  HIS    57      32.520  66.145  -2.914  1.00 19.81      A    C   
ATOM    440  CG  HIS    57      31.219  65.568  -3.378  1.00 20.14      A    C   
ATOM    441  ND1 HIS    57      31.049  65.028  -4.633  1.00 22.60      A    N   
ATOM    442  CE1 HIS    57      29.809  64.583  -4.748  1.00 22.65      A    C   
ATOM    443  NE2 HIS    57      29.171  64.824  -3.616  1.00 21.53      A    N   
ATOM    444  CD2 HIS    57      30.028  65.448  -2.747  1.00 20.42      A    C   
ATOM    445  C   HIS    57      33.680  67.336  -0.975  1.00 19.11      A    C   
ATOM    446  O   HIS    57      34.538  66.434  -0.828  1.00 18.12      A    O   
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70      A    N   
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51      A    C   
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69      A    C   
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12      A    C   
ATOM    451  CD1 ILE    58      36.427  72.053  -1.279  1.00 20.43      A    C   
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86      A    C   
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50      A    C   
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32      A    O   
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26      A    N   
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14      A    C   
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64      A    C   
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13      A    C   
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21      A    O   
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54      A    N   
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93      A    C   
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71      A    C   
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24      A    C   
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29      A    C   
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49      A    C   
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43      A    C   
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41      A    O   
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82      A    C   
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93      A    C   
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12      A    C   
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61      A    O   
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95      A    N   
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35      A    C   
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77      A    C   
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11      A    C   
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02      A    O   
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95      A    O   
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08      A    C   
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03      A    O   
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41      A    N   
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63      A    C   
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27      A    C   
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13      A    C   
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54      A    C   
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38      A    C   
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74      A    C   
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51      A    O   
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91      A    C   
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32      A    C   
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84      A    C   
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97      A    O   
ATOM    492  N   HIS    63      35.010  73.105  13.440  1.00 24.32      A    N   
ATOM    493  CA  HIS    63      33.615  73.111  13.872  1.00 25.56      A    C   
ATOM    494  CB  HIS    63      33.519  72.477  15.263  1.00 24.97      A    C   
ATOM    495  CG  HIS    63      34.160  71.127  15.321  1.00 24.22      A    C   
ATOM    496  ND1 HIS    63      35.270  70.847  16.088  1.00 28.07      A    N   
ATOM    497  CE1 HIS    63      35.632  69.590  15.888  1.00 26.20      A    C   
ATOM    498  NE2 HIS    63      34.807  69.053  15.003  1.00 26.25      A    N   
ATOM    499  CD2 HIS    63      33.881  69.993  14.634  1.00 22.43      A    C   
ATOM    500  C   HIS    63      33.056  74.547  13.817  1.00 27.28      A    C   
ATOM    501  O   HIS    63      33.586  75.443  14.467  1.00 29.56      A    O   
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66      A    N   
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40      A    C   
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92      A    C   
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74      A    C   
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41      A    C   
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53      A    C   
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81      A    O   
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51      A    N   
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90      A    C   
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10      A    C   
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99      A    C   
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84      A    C   
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20      A    C   
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73      A    O   
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87      A    N   
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85      A    C   
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88      A    C   
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29      A    C   
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66      A    O   
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76      A    N   
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53      A    C   
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00      A    C   
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77      A    C   
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49      A    O   
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84      A    O   
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00      A    C   
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51      A    O   
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05      A    N   
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09      A    C   
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00      A    C   
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64      A    C   
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82      A    C   
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10      A    C   
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28      A    N   
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41      A    C   
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19      A    O   
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13      A    N   
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80      A    C   
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60      A    C   
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76      A    C   
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41      A    C   
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04      A    C   
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41      A    C   
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95      A    O   
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13      A    N   
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67      A    C   
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50      A    C   
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84      A    C   
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92      A    C   
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60      A    C   
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62      A    C   
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75      A    O   
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82      A    C   
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32      A    C   
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40      A    C   
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25      A    O   
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95      A    N   
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52      A    C   
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43      A    C   
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15      A    C   
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14      A    C   
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13      A    C   
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79      A    O   
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52      A    N   
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27      A    C   
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65      A    C   
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42      A    O   
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32      A    N   
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94      A    C   
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83      A    C   
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16      A    O   
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98      A    C   
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46      A    O   
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33      A    N   
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00      A    C   
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66      A    C   
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27      A    C   
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00      A    C   
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45      A    N   
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96      A    C   
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65      A    N   
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44      A    N   
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93      A    C   
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89      A    O   
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79      A    N   
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83      A    C   
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62      A    C   
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43      A    C   
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70      A    C   
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62      A    C   
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18      A    O   
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40      A    N   
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21      A    C   
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42      A    C   
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77      A    C   
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22      A    C   
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24      A    C   
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16      A    O   
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51      A    N   
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54      A    C   
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86      A    C   
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89      A    C   
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43      A    O   
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68      A    N   
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04      A    C   
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30      A    C   
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63      A    C   
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97      A    C   
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00      A    C   
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09      A    N   
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29      A    C   
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83      A    O   
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82      A    N   
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33      A    C   
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99      A    C   
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73      A    C   
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64      A    C   
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11      A    C   
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97      A    C   
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65      A    O   
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25      A    C   
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71      A    C   
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65      A    C   
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57      A    O   
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32      A    N   
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27      A    C   
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32      A    C   
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72      A    C   
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04      A    C   
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43      A    C   
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93      A    N   
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48      A    C   
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81      A    O   
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78      A    N   
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62      A    C   
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24      A    C   
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99      A    C   
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44      A    O   
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57      A    O   
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52      A    C   
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39      A    O   
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60      A    N   
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72      A    C   
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07      A    C   
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78      A    O   
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49      A    N   
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85      A    C   
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92      A    C   
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01      A    C   
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64      A    O   
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43      A    N   
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94      A    C   
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99      A    O   
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49      A    N   
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91      A    C   
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50      A    C   
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10      A    C   
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73      A    C   
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41      A    O   
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20      A    N   
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46      A    C   
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29      A    O   
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39      A    N   
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91      A    C   
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56      A    C   
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69      A    C   
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70      A    C   
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15      A    C   
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90      A    O   
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99      A    N   
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21      A    C   
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50      A    C   
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34      A    C   
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51      A    C   
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04      A    N   
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89      A    C   
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94      A    C   
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27      A    C   
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48      A    C   
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06      A    C   
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81      A    C   
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19      A    C   
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63      A    O   
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91      A    N   
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62      A    C   
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68      A    C   
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51      A    C   
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55      A    C   
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57      A    C   
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15      A    C   
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15      A    O   
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09      A    N   
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91      A    C   
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64      A    C   
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36      A    C   
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44      A    C   
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12      A    C   
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12      A    C   
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59      A    O   
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18      A    C   
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61      A    C   
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17      A    C   
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43      A    O   
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08      A    N   
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00      A    C   
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19      A    C   
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22      A    C   
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28      A    O   
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54      A    N   
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43      A    C   
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72      A    C   
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00      A    O   
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87      A    N   
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36      A    C   
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32      A    C   
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77      A    C   
ATOM    718  CD1 ILE    91      21.004  68.804   3.522  1.00 26.35      A    C   
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37      A    C   
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40      A    C   
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69      A    O   
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01      A    N   
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58      A    C   
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01      A    C   
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99      A    C   
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64      A    C   
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26      A    C   
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42      A    O   
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59      A    N   
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19      A    C   
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13      A    C   
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92      A    C   
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56      A    O   
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37      A    N   
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21      A    C   
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92      A    C   
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03      A    C   
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98      A    C   
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90      A    O   
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28      A    O   
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23      A    C   
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59      A    O   
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37      A    N   
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74      A    C   
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84      A    C   
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78      A    O   
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52      A    C   
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60      A    C   
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69      A    O   
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69      A    N   
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59      A    C   
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22      A    C   
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67      A    C   
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43      A    C   
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84      A    C   
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06      A    O   
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07      A    N   
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93      A    C   
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42      A    C   
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70      A    C   
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18      A    O   
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03      A    N   
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34      A    C   
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04      A    O   
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73      A    N   
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02      A    C   
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18      A    C   
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17      A    C   
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25      A    C   
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86      A    C   
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40      A    O   
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93      A    N   
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74      A    C   
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01      A    C   
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21      A    C   
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77      A    C   
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90      A    C   
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85      A    N   
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32      A    C   
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38      A    O   
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61      A    N   
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96      A    C   
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58      A    C   
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24      A    C   
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88      A    O   
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73      A    N   
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87      A    C   
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07      A    O   
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69      A    N   
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96      A    C   
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57      A    C   
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38      A    C   
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44      A    C   
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30      A    C   
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55      A    N   
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33      A    C   
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46      A    O   
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23      A    N   
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59      A    C   
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55      A    C   
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10      A    C   
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70      A    C   
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74      A    C   
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80      A    C   
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60      A    O   
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82      A    N   
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44      A    C   
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22      A    C   
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32      A    C   
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56      A    C   
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24      A    N   
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25      A    C   
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17      A    N   
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74      A    N   
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49      A    C   
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66      A    O   
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03      A    N   
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77      A    C   
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90      A    C   
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91      A    C   
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77      A    C   
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30      A    C   
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62      A    C   
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79      A    C   
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41      A    C   
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73      A    C   
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07      A    O   
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95      A    N   
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90      A    C   
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16      A    C   
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79      A    C   
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70      A    C   
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00      A    C   
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31      A    C   
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80      A    O   
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01      A    N   
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24      A    C   
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24      A    C   
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43      A    C   
ATOM    840  CD1 ILE   106      23.603  67.212  12.165  1.00 20.23      A    C   
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52      A    C   
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58      A    C   
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61      A    O   
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23      A    N   
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45      A    C   
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44      A    C   
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93      A    C   
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99      A    C   
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41      A    C   
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32      A    C   
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50      A    C   
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35      A    C   
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80      A    C   
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67      A    O   
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44      A    N   
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55      A    C   
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60      A    C   
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49      A    C   
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81      A    C   
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08      A    C   
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48      A    C   
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72      A    C   
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79      A    C   
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19      A    C   
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68      A    O   
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03      A    N   
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13      A    C   
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75      A    C   
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93      A    C   
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78      A    O   
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40      A    O   
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28      A    C   
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96      A    O   
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54      A    N   
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57      A    C   
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39      A    C   
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68      A    C   
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45      A    O   
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92      A    O   
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52      A    C   
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49      A    O   
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29      A    N   
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31      A    C   
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94      A    C   
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78      A    O   
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27      A    N   
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81      A    C   
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78      A    C   
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13      A    C   
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13      A    C   
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46      A    C   
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51      A    C   
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35      A    O   
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49      A    C   
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42      A    C   
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38      A    C   
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60      A    O   
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28      A    N   
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48      A    C   
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94      A    C   
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88      A    C   
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02      A    O   
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78      A    N   
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51      A    C   
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32      A    C   
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59      A    O   
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14      A    C   
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10      A    O   
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88      A    N   
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97      A    C   
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23      A    C   
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98      A    C   
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69      A    C   
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06      A    C   
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17      A    C   
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32      A    O   
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57      A    C   
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00      A    C   
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83      A    C   
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57      A    O   
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72      A    N   
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52      A    C   
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69      A    C   
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00      A    C   
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31      A    C   
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61      A    C   
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30      A    O   
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89      A    N   
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98      A    C   
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31      A    C   
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79      A    O   
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61      A    C   
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21      A    C   
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79      A    O   
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01      A    N   
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28      A    C   
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49      A    C   
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99      A    C   
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55      A    C   
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72      A    O   
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57      A    N   
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10      A    C   
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56      A    O   
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49      A    N   
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07      A    C   
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47      A    C   
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78      A    O   
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32      A    C   
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85      A    O   
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18      A    N   
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24      A    C   
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92      A    C   
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83      A    C   
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58      A    C   
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17      A    O   
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52      A    O   
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67      A    C   
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73      A    O   
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86      A    N   
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32      A    C   
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01      A    C   
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02      A    C   
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23      A    C   
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86      A    C   
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96      A    C   
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86      A    O   
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66      A    N   
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39      A    C   
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52      A    C   
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82      A    C   
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09      A    C   
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95      A    C   
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50      A    C   
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88      A    O   
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16      A    C   
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29      A    C   
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68      A    C   
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71      A    O   
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87      A    N   
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79      A    C   
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35      A    C   
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92      A    C   
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87      A    C   
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69      A    C   
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01      A    O   
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52      A    N   
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49      A    C   
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21      A    C   
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81      A    C   
ATOM    990  CD1 ILE   124      28.803  68.039   3.091  1.00 25.49      A    C   
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25      A    C   
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92      A    C   
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39      A    O   
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68      A    N   
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92      A    C   
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66      A    C   
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72      A    S   
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26      A    C   
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07      A    O   
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14      A    N   
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10      A    C   
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44      A    C   
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05      A    C   
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38      A    C   
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14      A    N   
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93      A    C   
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80      A    N   
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37      A    N   
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61      A    C   
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58      A    O   
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84      A    N   
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55      A    C   
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73      A    C   
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71      A    C   
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69      A    C   
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20      A    C   
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13      A    O   
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93      A    N   
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11      A    C   
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11      A    C   
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78      A    C   
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21      A    C   
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11      A    C   
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10      A    C   
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50      A    O   
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83      A    N   
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96      A    C   
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23      A    C   
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25      A    C   
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12      A    C   
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73      A    C   
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80      A    N   
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59      A    C   
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18      A    O   
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19      A    N   
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79      A    C   
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69      A    C   
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99      A    C   
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29      A    C   
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81      A    C   
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82      A    N   
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63      A    C   
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95      A    O   
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22      A    N   
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50      A    C   
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06      A    C   
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82      A    O   
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04      A    C   
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62      A    C   
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97      A    O   
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04      A    N   
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89      A    C   
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11      A    C   
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44      A    C   
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59      A    C   
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49      A    N   
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16      A    C   
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91      A    C   
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11      A    C   
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36      A    C   
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08      A    C   
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78      A    C   
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73      A    C   
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50      A    O   
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66      A    N   
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34      A    C   
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61      A    C   
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64      A    C   
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80      A    C   
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45      A    O   
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15      A    O   
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32      A    C   
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86      A    O   
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24      A    N   
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25      A    C   
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54      A    C   
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08      A    C   
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87      A    O   
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84      A    O   
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00      A    C   
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24      A    O   
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19      A    N   
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87      A    C   
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06      A    C   
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49      A    C   
ATOM   1086  CD1 ILE   135      19.824  64.761   1.305  1.00 23.82      A    C   
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41      A    C   
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62      A    C   
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83      A    O   
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22      A    N   
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84      A    C   
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33      A    C   
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07      A    C   
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16      A    C   
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64      A    O   
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16      A    O   
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21      A    C   
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43      A    O   
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97      A    N   
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33      A    C   
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96      A    C   
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40      A    C   
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12      A    O   
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44      A    O   
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22      A    C   
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47      A    O   
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01      A    N   
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20      A    C   
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03      A    C   
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30      A    C   
ATOM   1111  CD1 ILE   138      16.726  60.053  -7.522  1.00 39.39      A    C   
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48      A    C   
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36      A    C   
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12      A    O   
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01      A    N   
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00      A    C   
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18      A    C   
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34      A    O   
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51      A    C   
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97      A    O   
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81      A    N   
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88      A    C   
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25      A    C   
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11      A    S   
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83      A    C   
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62      A    O   
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66      A    N   
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46      A    C   
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64      A    C   
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59      A    C   
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60      A    C   
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75      A    N   
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41      A    C   
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78      A    N   
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62      A    N   
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45      A    C   
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66      A    O   
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96      A    N   
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71      A    C   
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78      A    C   
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65      A    C   
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59      A    O   
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79      A    O   
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31      A    C   
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37      A    O   
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25      A    N   
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37      A    C   
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32      A    C   
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89      A    C   
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74      A    C   
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27      A    C   
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23      A    C   
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99      A    C   
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83      A    C   
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84      A    C   
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22      A    O   
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15      A    N   
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71      A    C   
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41      A    C   
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65      A    C   
ATOM   1161  CD1 ILE   144      16.433  64.307   5.309  1.00 32.59      A    C   
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38      A    C   
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23      A    C   
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99      A    O   
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54      A    N   
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22      A    C   
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83      A    C   
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06      A    C   
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55      A    C   
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48      A    O   
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38      A    O   
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02      A    C   
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51      A    O   
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22      A    N   
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31      A    C   
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99      A    C   
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93      A    C   
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96      A    C   
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56      A    O   
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44      A    O   
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30      A    C   
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67      A    O   
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95      A    N   
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26      A    C   
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62      A    C   
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42      A    C   
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78      A    C   
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51      A    C   
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34      A    C   
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94      A    O   
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26      A    C   
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68      A    C   
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42      A    C   
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71      A    O   
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89      A    N   
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22      A    C   
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51      A    C   
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81      A    C   
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91      A    C   
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19      A    C   
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11      A    O   
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28      A    N   
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60      A    C   
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71      A    C   
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07      A    O   
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99      A    C   
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95      A    C   
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70      A    O   
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59      A    N   
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60      A    C   
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85      A    C   
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59      A    C   
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80      A    O   
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51      A    N   
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02      A    C   
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25      A    C   
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64      A    C   
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89      A    C   
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64      A    C   
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96      A    C   
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53      A    O   
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39      A    C   
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63      A    C   
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26      A    C   
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36      A    O   
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02      A    N   
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87      A    C   
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97      A    C   
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14      A    C   
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10      A    C   
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49      A    C   
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95      A    O   
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00           N   
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00           C   
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00           C   
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00           C   
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11      A    O   
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24      A    N   
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67      A    C   
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22      A    C   
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95      A    C   
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24      A    C   
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56      A    N   
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65      A    C   
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10      A    N   
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91      A    N   
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48      A    C   
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60      A    O   
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81      A    N   
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57      A    C   
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30      A    C   
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91      A    C   
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74      A    C   
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68      A    C   
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45      A    O   
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58      A    N   
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91      A    C   
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72      A    C   
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80      A    C   
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27      A    S   
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73      A    C   
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88      A    C   
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77      A    O   
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68      A    N   
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94      A    C   
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31      A    C   
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02      A    C   
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19      A    C   
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70      A    C   
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12      A    O   
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86      A    N   
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34      A    C   
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76      A    C   
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71      A    C   
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52      A    C   
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91      A    C   
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36      A    C   
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38      A    O   
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39      A    N   
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82      A    C   
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48      A    C   
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98      A    C   
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19      A    C   
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71      A    C   
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84      A    C   
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14      A    O   
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05      A    N   
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85      A    C   
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53      A    C   
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66      A    C   
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77      A    C   
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29      A    C   
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32      A    N   
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60      A    C   
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59      A    O   
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08      A    N   
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57      A    C   
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74      A    C   
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20      A    O   
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82      A    C   
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39      A    O   
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79      A    N   
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54      A    C   
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96      A    C   
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12      A    O   
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51      A    N   
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64      A    C   
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76      A    C   
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65      A    C   
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28      A    C   
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12      A    O   
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38      A    N   
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12      A    C   
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39      A    O   
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12      A    N   
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66      A    C   
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46      A    C   
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68      A    C   
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83      A    C   
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29      A    C   
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79      A    C   
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92      A    O   
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19      A    N   
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22      A    C   
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55      A    C   
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94      A    C   
ATOM   1327  CD1 ILE   165       6.209  52.315  15.886  1.00 31.23      A    C   
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32      A    C   
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55      A    C   
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72      A    O   
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69      A    N   
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62      A    C   
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02      A    C   
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39      A    C   
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70      A    C   
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81      A    C   
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59      A    N   
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66      A    C   
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59      A    O   
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49      A    N   
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44      A    C   
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65      A    C   
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70      A    O   
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83      A    C   
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50      A    C   
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37      A    O   
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23      A    N   
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42      A    C   
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75      A    C   
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02      A    C   
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37      A    C   
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81      A    O   
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83      A    O   
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47      A    C   
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48      A    O   
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67      A    N   
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31      A    C   
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92      A    C   
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33      A    C   
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61      A    C   
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22      A    N   
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95      A    C   
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43      A    C   
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18      A    C   
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32      A    C   
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82      A    C   
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67      A    C   
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81      A    C   
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65      A    O   
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53      A    N   
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22      A    C   
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81      A    C   
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48      A    C   
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91      A    C   
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38      A    O   
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53      A    O   
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91      A    C   
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93      A    O   
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29      A    N   
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97      A    C   
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96      A    C   
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58      A    O   
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03      A    N   
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14      A    C   
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39      A    C   
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72      A    O   
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96      A    C   
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58      A    C   
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06      A    O   
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62      A    N   
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25      A    C   
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07      A    C   
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76      A    C   
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53      A    C   
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95      A    N   
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13      A    C   
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72      A    C   
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76      A    C   
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92      A    C   
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47      A    C   
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94      A    C   
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59      A    C   
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02      A    O   
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27      A    N   
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02      A    C   
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07      A    C   
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96      A    C   
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25      A    C   
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15      A    N   
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78      A    C   
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29      A    C   
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76      A    C   
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16      A    C   
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08      A    C   
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93      A    C   
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03      A    C   
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12      A    O   
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58      A    N   
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08      A    C   
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32      A    C   
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83      A    C   
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01      A    C   
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96      A    C   
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78      A    N   
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65      A    C   
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82      A    O   
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57      A    N   
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13      A    C   
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30      A    C   
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50      A    O   
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23      A    C   
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69      A    O   
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37      A    N   
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78      A    C   
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90      A    C   
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76      A    C   
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41      A    C   
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84      A    N   
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54      A    C   
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82      A    N   
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67      A    N   
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14      A    C   
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15      A    O   
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17      A    N   
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26      A    C   
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41      A    C   
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74      A    C   
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77      A    C   
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35      A    C   
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94      A    O   
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10      A    N   
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30      A    C   
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27      A    C   
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60      A    C   
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02      A    C   
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04      A    O   
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81      A    O   
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78      A    C   
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10      A    O   
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01      A    N   
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48      A    C   
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67      A    C   
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28      A    C   
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92      A    C   
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88      A    O   
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40      A    O   
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39      A    C   
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18      A    O   
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81      A    N   
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39      A    C   
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32      A    C   
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58      A    C   
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76      A    C   
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51      A    C   
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24      A    O   
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81      A    N   
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85      A    C   
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36      A    C   
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04      A    C   
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46      A    O   
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63      A    O   
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34      A    C   
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28      A    O   
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60      A    N   
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82      A    C   
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12      A    C   
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15      A    O   
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45      A    N   
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55      A    C   
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99      A    C   
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01      A    O   
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84      A    C   
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91      A    O   
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02      A    N   
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76      A    C   
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01      A    C   
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62      A    C   
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91      A    C   
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03      A    C   
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69      A    C   
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74      A    O   
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00      A    N   
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67      A    C   
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49      A    C   
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21      A    C   
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37      A    C   
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33      A    C   
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21      A    O   
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88      A    N   
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64      A    C   
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81      A    C   
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28      A    C   
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49      A    C   
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90      A    N   
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02      A    C   
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12      A    N   
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09      A    N   
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66      A    C   
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30      A    O   
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33      A    N   
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61      A    C   
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16      A    C   
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49      A    C   
ATOM   1524  CD1 ILE   188      10.070  52.171  17.195  1.00 22.12      A    C   
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97      A    C   
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24      A    C   
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98      A    O   
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53      A    N   
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66      A    C   
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05      A    C   
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76      A    C   
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44      A    C   
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56      A    C   
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30      A    C   
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61      A    O   
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27      A    N   
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14      A    C   
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24      A    C   
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90      A    C   
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65      A    C   
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09      A    C   
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22      A    C   
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07      A    C   
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13      A    C   
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23      A    C   
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45      A    O   
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88      A    N   
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39      A    C   
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37      A    C   
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18      A    C   
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11      A    C   
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76      A    C   
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98      A    C   
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06      A    O   
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15      A    N   
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12      A    C   
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35      A    C   
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17      A    C   
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49      A    O   
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48      A    O   
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20      A    C   
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84      A    O   
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46      A    N   
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90      A    C   
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22      A    C   
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81      A    C   
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17      A    O   
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73      A    O   
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40      A    C   
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81      A    O   
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79      A    N   
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00      A    C   
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11      A    C   
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34      A    C   
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22      A    C   
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08      A    C   
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25      A    N   
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17      A    C   
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60      A    O   
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73      A    N   
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18      A    C   
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44      A    C   
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65      A    C   
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06      A    C   
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18      A    N   
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07      A    C   
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04      A    N   
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77      A    N   
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81      A    C   
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67      A    O   
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17      A    N   
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89      A    C   
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26      A    C   
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76      A    S   
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18      A    C   
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50      A    O   
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36      A    N   
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74      A    C   
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30      A    C   
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31      A    C   
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51      A    C   
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61      A    O   
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47      A    O   
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94      A    C   
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12      A    O   
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46      A    N   
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05      A    C   
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37      A    C   
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69      A    C   
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54      A    C   
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80      A    N   
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60      A    C   
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83      A    C   
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73      A    C   
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65      A    C   
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44      A    C   
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23      A    C   
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26      A    C   
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58      A    O   
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43      A    N   
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27      A    C   
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13      A    C   
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58      A    C   
ATOM   1624  CD1 ILE   199      12.999  52.559  12.729  1.00 20.55      A    C   
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51      A    C   
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19      A    C   
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92      A    O   
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19      A    N   
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38      A    C   
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91      A    C   
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47      A    C   
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20      A    C   
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57      A    C   
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44      A    C   
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50      A    O   
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12      A    C   
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97      A    C   
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26      A    C   
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54      A    O   
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69      A    N   
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36      A    C   
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88      A    C   
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58      A    C   
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28      A    C   
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92      A    N   
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45      A    C   
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56      A    N   
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01      A    N   
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86      A    C   
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26      A    O   
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88      A    N   
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49      A    C   
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20      A    C   
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50      A    O   
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52      A    N   
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94      A    C   
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80      A    C   
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15      A    O   
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74      A    C   
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11      A    O   
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13      A    N   
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63      A    C   
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86      A    C   
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83      A    O   
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24      A    C   
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93      A    C   
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95      A    O   
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76      A    N   
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56      A    C   
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52      A    C   
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50      A    C   
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97      A    C   
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21      A    N   
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11      A    C   
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43      A    N   
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70      A    N   
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63      A    C   
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00      A    O   
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37      A    N   
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66      A    C   
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91      A    C   
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37      A    C   
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02      A    C   
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72      A    C   
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09      A    C   
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64      A    O   
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26      A    N   
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27      A    C   
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33      A    C   
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61      A    C   
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10      A    C   
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09      A    O   
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83      A    O   
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60      A    C   
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76      A    O   
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26      A    N   
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94      A    C   
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04      A    C   
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06      A    C   
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74      A    C   
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96      A    C   
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24      A    O   
END
