
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   88 ( 1462),  selected   88 , name 2eqm_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2eqm_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      X      63           -
LGA    S     2_A      P      64           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    K    10_A      -       -           -
LGA    K    11_A      -       -           -
LGA    P    12_A      P      65          2.727
LGA    P    13_A      A      66          5.492
LGA    N    14_A      D      67           -
LGA    R    15_A      -       -           -
LGA    P    16_A      -       -           -
LGA    G    17_A      -       -           -
LGA    I    18_A      -       -           -
LGA    T    19_A      K      68          2.948
LGA    F    20_A      L      69          2.066
LGA    E    21_A      Y      70          1.361
LGA    I    22_A      V      71          1.035
LGA    G    23_A      G      72          0.928
LGA    A    24_A      S      73          0.587
LGA    R    25_A      R      74          0.696
LGA    L    26_A      V      75          0.515
LGA    E    27_A      V      76          0.644
LGA    A    28_A      A      77          0.702
LGA    L    29_A      K      78          1.415
LGA    D    30_A      Y      79          1.671
LGA    Y    31_A      K      80          3.125
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    L    32_A      Q      84          3.777
LGA    Q    33_A      V      85          3.957
LGA    K    34_A      W      86          1.694
LGA    W    35_A      L      87          1.861
LGA    Y    36_A      Y      88          1.389
LGA    P    37_A      A      89          0.934
LGA    S    38_A      G      90          0.439
LGA    R    39_A      I      91          0.563
LGA    I    40_A      V      92          1.002
LGA    E    41_A      A      93          1.203
LGA    K    42_A      E      94          1.597
LGA    I    43_A      T      95          1.908
LGA    D    44_A      P      96          2.898
LGA    Y    45_A      N      97          2.485
LGA    E    46_A      V      98          2.543
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    E    47_A      K     101          2.411
LGA    G    48_A      L     102          0.854
LGA    K    49_A      R     103          1.153
LGA    M    50_A      F     104          1.873
LGA    L    51_A      L     105          1.543
LGA    V    52_A      I     106          0.847
LGA    H    53_A      F     107          0.577
LGA    F    54_A      F     108          0.781
LGA    E    55_A      D     109          0.872
LGA    R    56_A      D     110          3.100
LGA    W    57_A      -       -           -
LGA    S    58_A      -       -           -
LGA    H    59_A      -       -           -
LGA    R    60_A      G     111          2.289
LGA    Y    61_A      Y     112          1.722
LGA    D    62_A      A     113          1.123
LGA    E    63_A      S     114          1.699
LGA    W    64_A      Y     115          1.939
LGA    I    65_A      V     116          1.762
LGA    Y    66_A      T     117          2.611
LGA    W    67_A      Q     118          2.916
LGA    D    68_A      -       -           -
LGA    S    69_A      -       -           -
LGA    N    70_A      S     119          0.959
LGA    R    71_A      E     120          1.535
LGA    L    72_A      L     121          1.632
LGA    R    73_A      Y     122          1.598
LGA    P    74_A      P     123          1.917
LGA    L    75_A      I     124          1.574
LGA    E    76_A      C     125          3.080
LGA    R    77_A      R     126          1.420
LGA    P    78_A      P     127          3.036
LGA    -       -      L     128           -
LGA    A    79_A      K     129           #
LGA    L    80_A      K     130           -
LGA    R    81_A      T     131           -
LGA    K    82_A      W     132           -
LGA    E    83_A      E     133           -
LGA    G    84_A      D     134           -
LGA    L    85_A      I     135           -
LGA    K    86_A      E     136           -
LGA    D    87_A      D     137           -
LGA    E    88_A      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   88   93    5.0     57    2.03    21.05     53.628     2.671

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.406389 * X  +  -0.518949 * Y  +   0.752024 * Z  +  25.963903
  Y_new =   0.810254 * X  +   0.175721 * Y  +   0.559116 * Z  +  69.260353
  Z_new =  -0.422299 * X  +   0.836549 * Y  +   0.349070 * Z  +   9.847744 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.175488   -1.966105  [ DEG:    67.3505   -112.6495 ]
  Theta =   0.435980    2.705612  [ DEG:    24.9798    155.0202 ]
  Phi   =   2.035689   -1.105904  [ DEG:   116.6364    -63.3636 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eqm_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eqm_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   88   93   5.0   57   2.03   21.05  53.628
REMARK  ---------------------------------------------------------- 
MOLECULE 2eqm_A
HEADER    TRANSCRIPTION                           30-MAR-07   2EQM              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD FINGER                  
TITLE    2 PROTEIN 20-LIKE 1 [HOMO SAPIENS]                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHD FINGER PROTEIN 20-LIKE 1;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PHF20L1;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060911-19;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, TUDOR DOMAIN,PHD FINGER PROTEIN 20-LIKE 1, HOMO                  
KEYWDS   2 SAPIENS, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON            
KEYWDS   3 PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                    
KEYWDS   4 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,                     
KEYWDS   5 TRANSCRIPTION                                                        
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TARADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   02-OCT-07 2EQM    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TARADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD                
JRNL        TITL 2 FINGER PROTEIN 20-LIKE 1 [HOMO SAPIENS]                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EQM A    8    88  UNP    Q96BT0   Q96BT0_HUMAN     1     81             
SEQRES   1 A   88  GLY SER SER GLY SER SER GLY MET SER LYS LYS PRO PRO          
SEQRES   2 A   88  ASN ARG PRO GLY ILE THR PHE GLU ILE GLY ALA ARG LEU          
SEQRES   3 A   88  GLU ALA LEU ASP TYR LEU GLN LYS TRP TYR PRO SER ARG          
SEQRES   4 A   88  ILE GLU LYS ILE ASP TYR GLU GLU GLY LYS MET LEU VAL          
SEQRES   5 A   88  HIS PHE GLU ARG TRP SER HIS ARG TYR ASP GLU TRP ILE          
SEQRES   6 A   88  TYR TRP ASP SER ASN ARG LEU ARG PRO LEU GLU ARG PRO          
SEQRES   7 A   88  ALA LEU ARG LYS GLU GLY LEU LYS ASP GLU                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      46.824  71.846  29.887  1.00  0.00           N  
ATOM      2  CA  GLY A   1      45.584  71.750  29.139  1.00  0.00           C  
ATOM      3  C   GLY A   1      44.752  73.014  29.230  1.00  0.00           C  
ATOM      4  O   GLY A   1      44.987  73.858  30.095  1.00  0.00           O  
ATOM      5  H1  GLY A   1      47.271  72.713  29.982  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      45.815  71.557  28.103  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      45.006  70.924  29.528  1.00  0.00           H  
ATOM      8  N   SER A   2      43.779  73.146  28.335  1.00  0.00           N  
ATOM      9  CA  SER A   2      42.913  74.319  28.315  1.00  0.00           C  
ATOM     10  C   SER A   2      41.505  73.948  27.859  1.00  0.00           C  
ATOM     11  O   SER A   2      41.321  73.369  26.788  1.00  0.00           O  
ATOM     12  CB  SER A   2      43.494  75.391  27.391  1.00  0.00           C  
ATOM     13  OG  SER A   2      42.798  76.618  27.534  1.00  0.00           O  
ATOM     14  H   SER A   2      43.641  72.438  27.671  1.00  0.00           H  
ATOM     15  HA  SER A   2      42.862  74.711  29.320  1.00  0.00           H  
ATOM     16  HB2 SER A   2      44.533  75.551  27.637  1.00  0.00           H  
ATOM     17  HB3 SER A   2      43.413  75.061  26.365  1.00  0.00           H  
ATOM     18  HG  SER A   2      42.401  76.662  28.407  1.00  0.00           H  
ATOM     19  N   SER A   3      40.516  74.284  28.680  1.00  0.00           N  
ATOM     20  CA  SER A   3      39.124  73.983  28.364  1.00  0.00           C  
ATOM     21  C   SER A   3      38.350  75.260  28.052  1.00  0.00           C  
ATOM     22  O   SER A   3      38.548  76.292  28.691  1.00  0.00           O  
ATOM     23  CB  SER A   3      38.464  73.245  29.529  1.00  0.00           C  
ATOM     24  OG  SER A   3      38.393  74.067  30.681  1.00  0.00           O  
ATOM     25  H   SER A   3      40.727  74.744  29.519  1.00  0.00           H  
ATOM     26  HA  SER A   3      39.113  73.346  27.492  1.00  0.00           H  
ATOM     27  HB2 SER A   3      37.463  72.955  29.248  1.00  0.00           H  
ATOM     28  HB3 SER A   3      39.040  72.362  29.767  1.00  0.00           H  
ATOM     29  HG  SER A   3      37.822  73.656  31.334  1.00  0.00           H  
ATOM     30  N   GLY A   4      37.465  75.180  27.062  1.00  0.00           N  
ATOM     31  CA  GLY A   4      36.673  76.335  26.680  1.00  0.00           C  
ATOM     32  C   GLY A   4      35.185  76.053  26.709  1.00  0.00           C  
ATOM     33  O   GLY A   4      34.609  75.832  27.774  1.00  0.00           O  
ATOM     34  H   GLY A   4      37.349  74.330  26.587  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      36.889  77.146  27.360  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      36.952  76.634  25.680  1.00  0.00           H  
ATOM     37  N   SER A   5      34.559  76.061  25.537  1.00  0.00           N  
ATOM     38  CA  SER A   5      33.127  75.809  25.431  1.00  0.00           C  
ATOM     39  C   SER A   5      32.366  76.531  26.540  1.00  0.00           C  
ATOM     40  O   SER A   5      31.462  75.967  27.157  1.00  0.00           O  
ATOM     41  CB  SER A   5      32.845  74.307  25.499  1.00  0.00           C  
ATOM     42  OG  SER A   5      33.513  73.615  24.458  1.00  0.00           O  
ATOM     43  H   SER A   5      35.074  76.244  24.722  1.00  0.00           H  
ATOM     44  HA  SER A   5      32.793  76.187  24.477  1.00  0.00           H  
ATOM     45  HB2 SER A   5      33.188  73.922  26.448  1.00  0.00           H  
ATOM     46  HB3 SER A   5      31.783  74.138  25.404  1.00  0.00           H  
ATOM     47  HG  SER A   5      34.388  73.356  24.755  1.00  0.00           H  
ATOM     48  N   SER A   6      32.739  77.783  26.787  1.00  0.00           N  
ATOM     49  CA  SER A   6      32.095  78.582  27.822  1.00  0.00           C  
ATOM     50  C   SER A   6      31.301  79.731  27.207  1.00  0.00           C  
ATOM     51  O   SER A   6      30.245  80.111  27.712  1.00  0.00           O  
ATOM     52  CB  SER A   6      33.140  79.133  28.794  1.00  0.00           C  
ATOM     53  OG  SER A   6      32.524  79.796  29.885  1.00  0.00           O  
ATOM     54  H   SER A   6      33.466  78.178  26.259  1.00  0.00           H  
ATOM     55  HA  SER A   6      31.416  77.940  28.362  1.00  0.00           H  
ATOM     56  HB2 SER A   6      33.738  78.320  29.175  1.00  0.00           H  
ATOM     57  HB3 SER A   6      33.776  79.835  28.275  1.00  0.00           H  
ATOM     58  HG  SER A   6      33.126  79.812  30.631  1.00  0.00           H  
ATOM     59  N   GLY A   7      31.817  80.279  26.112  1.00  0.00           N  
ATOM     60  CA  GLY A   7      31.145  81.379  25.445  1.00  0.00           C  
ATOM     61  C   GLY A   7      29.871  80.943  24.749  1.00  0.00           C  
ATOM     62  O   GLY A   7      29.867  80.700  23.543  1.00  0.00           O  
ATOM     63  H   GLY A   7      32.662  79.935  25.754  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      30.902  82.135  26.177  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      31.815  81.804  24.711  1.00  0.00           H  
ATOM     66  N   MET A   8      28.787  80.843  25.510  1.00  0.00           N  
ATOM     67  CA  MET A   8      27.501  80.432  24.959  1.00  0.00           C  
ATOM     68  C   MET A   8      27.668  79.244  24.017  1.00  0.00           C  
ATOM     69  O   MET A   8      27.202  79.273  22.878  1.00  0.00           O  
ATOM     70  CB  MET A   8      26.845  81.597  24.217  1.00  0.00           C  
ATOM     71  CG  MET A   8      26.364  82.710  25.136  1.00  0.00           C  
ATOM     72  SD  MET A   8      24.815  82.305  25.965  1.00  0.00           S  
ATOM     73  CE  MET A   8      25.418  81.733  27.550  1.00  0.00           C  
ATOM     74  H   MET A   8      28.852  81.050  26.466  1.00  0.00           H  
ATOM     75  HA  MET A   8      26.867  80.138  25.781  1.00  0.00           H  
ATOM     76  HB2 MET A   8      27.559  82.017  23.524  1.00  0.00           H  
ATOM     77  HB3 MET A   8      25.995  81.225  23.664  1.00  0.00           H  
ATOM     78  HG2 MET A   8      27.119  82.891  25.885  1.00  0.00           H  
ATOM     79  HG3 MET A   8      26.220  83.604  24.549  1.00  0.00           H  
ATOM     80  HE1 MET A   8      24.791  80.928  27.906  1.00  0.00           H  
ATOM     81  HE2 MET A   8      26.433  81.379  27.444  1.00  0.00           H  
ATOM     82  HE3 MET A   8      25.393  82.548  28.259  1.00  0.00           H  
ATOM     83  N   SER A   9      28.335  78.200  24.500  1.00  0.00           N  
ATOM     84  CA  SER A   9      28.566  77.004  23.700  1.00  0.00           C  
ATOM     85  C   SER A   9      27.361  76.701  22.815  1.00  0.00           C  
ATOM     86  O   SER A   9      27.505  76.421  21.624  1.00  0.00           O  
ATOM     87  CB  SER A   9      28.862  75.808  24.606  1.00  0.00           C  
ATOM     88  OG  SER A   9      27.863  75.661  25.599  1.00  0.00           O  
ATOM     89  H   SER A   9      28.681  78.237  25.416  1.00  0.00           H  
ATOM     90  HA  SER A   9      29.423  77.188  23.069  1.00  0.00           H  
ATOM     91  HB2 SER A   9      28.895  74.908  24.010  1.00  0.00           H  
ATOM     92  HB3 SER A   9      29.817  75.954  25.090  1.00  0.00           H  
ATOM     93  HG  SER A   9      27.932  76.379  26.232  1.00  0.00           H  
ATOM     94  N   LYS A  10      26.172  76.758  23.405  1.00  0.00           N  
ATOM     95  CA  LYS A  10      24.940  76.491  22.673  1.00  0.00           C  
ATOM     96  C   LYS A  10      25.046  76.984  21.233  1.00  0.00           C  
ATOM     97  O   LYS A  10      25.196  76.191  20.303  1.00  0.00           O  
ATOM     98  CB  LYS A  10      23.754  77.163  23.368  1.00  0.00           C  
ATOM     99  CG  LYS A  10      23.574  76.735  24.814  1.00  0.00           C  
ATOM    100  CD  LYS A  10      23.148  75.280  24.917  1.00  0.00           C  
ATOM    101  CE  LYS A  10      23.510  74.687  26.270  1.00  0.00           C  
ATOM    102  NZ  LYS A  10      22.470  74.973  27.297  1.00  0.00           N  
ATOM    103  H   LYS A  10      26.122  76.986  24.358  1.00  0.00           H  
ATOM    104  HA  LYS A  10      24.784  75.423  22.664  1.00  0.00           H  
ATOM    105  HB2 LYS A  10      23.898  78.233  23.346  1.00  0.00           H  
ATOM    106  HB3 LYS A  10      22.850  76.920  22.828  1.00  0.00           H  
ATOM    107  HG2 LYS A  10      24.510  76.862  25.337  1.00  0.00           H  
ATOM    108  HG3 LYS A  10      22.816  77.355  25.272  1.00  0.00           H  
ATOM    109  HD2 LYS A  10      22.079  75.217  24.782  1.00  0.00           H  
ATOM    110  HD3 LYS A  10      23.644  74.714  24.141  1.00  0.00           H  
ATOM    111  HE2 LYS A  10      23.614  73.619  26.163  1.00  0.00           H  
ATOM    112  HE3 LYS A  10      24.449  75.110  26.594  1.00  0.00           H  
ATOM    113  HZ1 LYS A  10      21.817  75.705  26.950  1.00  0.00           H  
ATOM    114  HZ2 LYS A  10      22.916  75.309  28.174  1.00  0.00           H  
ATOM    115  HZ3 LYS A  10      21.927  74.111  27.505  1.00  0.00           H  
ATOM    116  N   LYS A  11      24.966  78.298  21.056  1.00  0.00           N  
ATOM    117  CA  LYS A  11      25.055  78.898  19.730  1.00  0.00           C  
ATOM    118  C   LYS A  11      26.353  78.495  19.036  1.00  0.00           C  
ATOM    119  O   LYS A  11      27.349  78.161  19.677  1.00  0.00           O  
ATOM    120  CB  LYS A  11      24.970  80.423  19.830  1.00  0.00           C  
ATOM    121  CG  LYS A  11      26.319  81.096  20.006  1.00  0.00           C  
ATOM    122  CD  LYS A  11      26.167  82.579  20.303  1.00  0.00           C  
ATOM    123  CE  LYS A  11      26.115  83.401  19.024  1.00  0.00           C  
ATOM    124  NZ  LYS A  11      25.819  84.835  19.299  1.00  0.00           N  
ATOM    125  H   LYS A  11      24.846  78.880  21.836  1.00  0.00           H  
ATOM    126  HA  LYS A  11      24.222  78.537  19.145  1.00  0.00           H  
ATOM    127  HB2 LYS A  11      24.514  80.806  18.929  1.00  0.00           H  
ATOM    128  HB3 LYS A  11      24.349  80.681  20.676  1.00  0.00           H  
ATOM    129  HG2 LYS A  11      26.841  80.628  20.826  1.00  0.00           H  
ATOM    130  HG3 LYS A  11      26.892  80.978  19.097  1.00  0.00           H  
ATOM    131  HD2 LYS A  11      25.252  82.735  20.855  1.00  0.00           H  
ATOM    132  HD3 LYS A  11      27.009  82.907  20.897  1.00  0.00           H  
ATOM    133  HE2 LYS A  11      27.070  83.329  18.526  1.00  0.00           H  
ATOM    134  HE3 LYS A  11      25.344  82.999  18.384  1.00  0.00           H  
ATOM    135  HZ1 LYS A  11      26.302  85.439  18.603  1.00  0.00           H  
ATOM    136  HZ2 LYS A  11      26.146  85.091  20.252  1.00  0.00           H  
ATOM    137  HZ3 LYS A  11      24.794  85.006  19.239  1.00  0.00           H  
ATOM    138  N   PRO A  12      26.344  78.529  17.695  1.00  0.00           N  
ATOM    139  CA  PRO A  12      27.513  78.172  16.886  1.00  0.00           C  
ATOM    140  C   PRO A  12      28.632  79.201  17.002  1.00  0.00           C  
ATOM    141  O   PRO A  12      28.525  80.328  16.518  1.00  0.00           O  
ATOM    142  CB  PRO A  12      26.961  78.141  15.459  1.00  0.00           C  
ATOM    143  CG  PRO A  12      25.781  79.051  15.489  1.00  0.00           C  
ATOM    144  CD  PRO A  12      25.191  78.918  16.865  1.00  0.00           C  
ATOM    145  HA  PRO A  12      27.894  77.196  17.148  1.00  0.00           H  
ATOM    146  HB2 PRO A  12      27.716  78.495  14.771  1.00  0.00           H  
ATOM    147  HB3 PRO A  12      26.675  77.133  15.201  1.00  0.00           H  
ATOM    148  HG2 PRO A  12      26.097  80.068  15.313  1.00  0.00           H  
ATOM    149  HG3 PRO A  12      25.064  78.745  14.743  1.00  0.00           H  
ATOM    150  HD2 PRO A  12      24.781  79.862  17.193  1.00  0.00           H  
ATOM    151  HD3 PRO A  12      24.432  78.150  16.877  1.00  0.00           H  
ATOM    152  N   PRO A  13      29.735  78.806  17.658  1.00  0.00           N  
ATOM    153  CA  PRO A  13      30.896  79.679  17.851  1.00  0.00           C  
ATOM    154  C   PRO A  13      31.646  79.943  16.550  1.00  0.00           C  
ATOM    155  O   PRO A  13      31.365  79.324  15.524  1.00  0.00           O  
ATOM    156  CB  PRO A  13      31.774  78.890  18.824  1.00  0.00           C  
ATOM    157  CG  PRO A  13      31.393  77.466  18.609  1.00  0.00           C  
ATOM    158  CD  PRO A  13      29.931  77.477  18.260  1.00  0.00           C  
ATOM    159  HA  PRO A  13      30.615  80.620  18.300  1.00  0.00           H  
ATOM    160  HB2 PRO A  13      32.817  79.060  18.591  1.00  0.00           H  
ATOM    161  HB3 PRO A  13      31.570  79.205  19.836  1.00  0.00           H  
ATOM    162  HG2 PRO A  13      31.970  77.049  17.797  1.00  0.00           H  
ATOM    163  HG3 PRO A  13      31.558  76.901  19.515  1.00  0.00           H  
ATOM    164  HD2 PRO A  13      29.706  76.695  17.551  1.00  0.00           H  
ATOM    165  HD3 PRO A  13      29.330  77.365  19.150  1.00  0.00           H  
ATOM    166  N   ASN A  14      32.602  80.864  16.599  1.00  0.00           N  
ATOM    167  CA  ASN A  14      33.393  81.209  15.424  1.00  0.00           C  
ATOM    168  C   ASN A  14      33.930  79.956  14.741  1.00  0.00           C  
ATOM    169  O   ASN A  14      34.932  79.384  15.171  1.00  0.00           O  
ATOM    170  CB  ASN A  14      34.553  82.127  15.815  1.00  0.00           C  
ATOM    171  CG  ASN A  14      35.445  82.466  14.636  1.00  0.00           C  
ATOM    172  OD1 ASN A  14      36.435  81.782  14.376  1.00  0.00           O  
ATOM    173  ND2 ASN A  14      35.098  83.527  13.918  1.00  0.00           N  
ATOM    174  H   ASN A  14      32.781  81.325  17.446  1.00  0.00           H  
ATOM    175  HA  ASN A  14      32.749  81.734  14.734  1.00  0.00           H  
ATOM    176  HB2 ASN A  14      34.156  83.048  16.217  1.00  0.00           H  
ATOM    177  HB3 ASN A  14      35.152  81.639  16.568  1.00  0.00           H  
ATOM    178 HD21 ASN A  14      34.298  84.026  14.185  1.00  0.00           H  
ATOM    179 HD22 ASN A  14      35.657  83.769  13.150  1.00  0.00           H  
ATOM    180  N   ARG A  15      33.256  79.533  13.677  1.00  0.00           N  
ATOM    181  CA  ARG A  15      33.665  78.346  12.935  1.00  0.00           C  
ATOM    182  C   ARG A  15      33.625  78.603  11.432  1.00  0.00           C  
ATOM    183  O   ARG A  15      32.570  78.570  10.799  1.00  0.00           O  
ATOM    184  CB  ARG A  15      32.761  77.164  13.285  1.00  0.00           C  
ATOM    185  CG  ARG A  15      33.447  75.813  13.159  1.00  0.00           C  
ATOM    186  CD  ARG A  15      32.886  74.807  14.152  1.00  0.00           C  
ATOM    187  NE  ARG A  15      33.455  74.978  15.485  1.00  0.00           N  
ATOM    188  CZ  ARG A  15      32.927  74.449  16.584  1.00  0.00           C  
ATOM    189  NH1 ARG A  15      31.823  73.720  16.507  1.00  0.00           N  
ATOM    190  NH2 ARG A  15      33.504  74.649  17.761  1.00  0.00           N  
ATOM    191  H   ARG A  15      32.465  80.031  13.383  1.00  0.00           H  
ATOM    192  HA  ARG A  15      34.679  78.109  13.221  1.00  0.00           H  
ATOM    193  HB2 ARG A  15      32.419  77.274  14.304  1.00  0.00           H  
ATOM    194  HB3 ARG A  15      31.907  77.172  12.626  1.00  0.00           H  
ATOM    195  HG2 ARG A  15      33.297  75.436  12.158  1.00  0.00           H  
ATOM    196  HG3 ARG A  15      34.503  75.938  13.344  1.00  0.00           H  
ATOM    197  HD2 ARG A  15      31.815  74.938  14.209  1.00  0.00           H  
ATOM    198  HD3 ARG A  15      33.109  73.811  13.800  1.00  0.00           H  
ATOM    199  HE  ARG A  15      34.272  75.514  15.565  1.00  0.00           H  
ATOM    200 HH11 ARG A  15      31.386  73.566  15.621  1.00  0.00           H  
ATOM    201 HH12 ARG A  15      31.428  73.321  17.335  1.00  0.00           H  
ATOM    202 HH21 ARG A  15      34.337  75.198  17.823  1.00  0.00           H  
ATOM    203 HH22 ARG A  15      33.106  74.250  18.587  1.00  0.00           H  
ATOM    204  N   PRO A  16      34.802  78.867  10.845  1.00  0.00           N  
ATOM    205  CA  PRO A  16      34.928  79.135   9.408  1.00  0.00           C  
ATOM    206  C   PRO A  16      34.673  77.893   8.562  1.00  0.00           C  
ATOM    207  O   PRO A  16      35.609  77.238   8.107  1.00  0.00           O  
ATOM    208  CB  PRO A  16      36.380  79.596   9.260  1.00  0.00           C  
ATOM    209  CG  PRO A  16      37.094  78.973  10.410  1.00  0.00           C  
ATOM    210  CD  PRO A  16      36.100  78.923  11.537  1.00  0.00           C  
ATOM    211  HA  PRO A  16      34.264  79.927   9.094  1.00  0.00           H  
ATOM    212  HB2 PRO A  16      36.774  79.250   8.315  1.00  0.00           H  
ATOM    213  HB3 PRO A  16      36.427  80.673   9.303  1.00  0.00           H  
ATOM    214  HG2 PRO A  16      37.414  77.976  10.147  1.00  0.00           H  
ATOM    215  HG3 PRO A  16      37.944  79.580  10.686  1.00  0.00           H  
ATOM    216  HD2 PRO A  16      36.256  78.040  12.138  1.00  0.00           H  
ATOM    217  HD3 PRO A  16      36.175  79.813  12.145  1.00  0.00           H  
ATOM    218  N   GLY A  17      33.399  77.574   8.356  1.00  0.00           N  
ATOM    219  CA  GLY A  17      33.044  76.411   7.564  1.00  0.00           C  
ATOM    220  C   GLY A  17      31.716  75.809   7.979  1.00  0.00           C  
ATOM    221  O   GLY A  17      30.759  75.804   7.203  1.00  0.00           O  
ATOM    222  H   GLY A  17      32.693  78.134   8.744  1.00  0.00           H  
ATOM    223  HA2 GLY A  17      32.988  76.700   6.525  1.00  0.00           H  
ATOM    224  HA3 GLY A  17      33.815  75.664   7.677  1.00  0.00           H  
ATOM    225  N   ILE A  18      31.656  75.302   9.206  1.00  0.00           N  
ATOM    226  CA  ILE A  18      30.436  74.696   9.722  1.00  0.00           C  
ATOM    227  C   ILE A  18      29.500  75.750  10.303  1.00  0.00           C  
ATOM    228  O   ILE A  18      29.946  76.731  10.901  1.00  0.00           O  
ATOM    229  CB  ILE A  18      30.744  73.646  10.806  1.00  0.00           C  
ATOM    230  CG1 ILE A  18      31.992  72.845  10.432  1.00  0.00           C  
ATOM    231  CG2 ILE A  18      29.552  72.720  11.000  1.00  0.00           C  
ATOM    232  CD1 ILE A  18      32.280  71.698  11.376  1.00  0.00           C  
ATOM    233  H   ILE A  18      32.451  75.337   9.777  1.00  0.00           H  
ATOM    234  HA  ILE A  18      29.937  74.200   8.901  1.00  0.00           H  
ATOM    235  HB  ILE A  18      30.922  74.163  11.737  1.00  0.00           H  
ATOM    236 HG12 ILE A  18      31.866  72.435   9.442  1.00  0.00           H  
ATOM    237 HG13 ILE A  18      32.848  73.504  10.438  1.00  0.00           H  
ATOM    238 HG21 ILE A  18      28.691  73.300  11.297  1.00  0.00           H  
ATOM    239 HG22 ILE A  18      29.340  72.208  10.075  1.00  0.00           H  
ATOM    240 HG23 ILE A  18      29.780  71.996  11.769  1.00  0.00           H  
ATOM    241 HD11 ILE A  18      32.038  71.995  12.386  1.00  0.00           H  
ATOM    242 HD12 ILE A  18      31.680  70.844  11.098  1.00  0.00           H  
ATOM    243 HD13 ILE A  18      33.326  71.439  11.318  1.00  0.00           H  
ATOM    244  N   THR A  19      28.199  75.543  10.124  1.00  0.00           N  
ATOM    245  CA  THR A  19      27.200  76.475  10.630  1.00  0.00           C  
ATOM    246  C   THR A  19      25.941  75.742  11.081  1.00  0.00           C  
ATOM    247  O   THR A  19      25.171  75.248  10.257  1.00  0.00           O  
ATOM    248  CB  THR A  19      26.818  77.521   9.567  1.00  0.00           C  
ATOM    249  OG1 THR A  19      27.953  78.335   9.251  1.00  0.00           O  
ATOM    250  CG2 THR A  19      25.678  78.402  10.059  1.00  0.00           C  
ATOM    251  H   THR A  19      27.905  74.743   9.640  1.00  0.00           H  
ATOM    252  HA  THR A  19      27.626  76.992  11.478  1.00  0.00           H  
ATOM    253  HB  THR A  19      26.495  77.004   8.675  1.00  0.00           H  
ATOM    254  HG1 THR A  19      28.758  77.837   9.408  1.00  0.00           H  
ATOM    255 HG21 THR A  19      24.751  77.852  10.004  1.00  0.00           H  
ATOM    256 HG22 THR A  19      25.610  79.283   9.438  1.00  0.00           H  
ATOM    257 HG23 THR A  19      25.864  78.694  11.081  1.00  0.00           H  
ATOM    258  N   PHE A  20      25.738  75.674  12.391  1.00  0.00           N  
ATOM    259  CA  PHE A  20      24.572  75.000  12.951  1.00  0.00           C  
ATOM    260  C   PHE A  20      23.294  75.767  12.628  1.00  0.00           C  
ATOM    261  O   PHE A  20      23.010  76.802  13.230  1.00  0.00           O  
ATOM    262  CB  PHE A  20      24.721  74.850  14.467  1.00  0.00           C  
ATOM    263  CG  PHE A  20      26.081  74.373  14.891  1.00  0.00           C  
ATOM    264  CD1 PHE A  20      26.730  73.373  14.183  1.00  0.00           C  
ATOM    265  CD2 PHE A  20      26.710  74.923  15.996  1.00  0.00           C  
ATOM    266  CE1 PHE A  20      27.981  72.931  14.573  1.00  0.00           C  
ATOM    267  CE2 PHE A  20      27.960  74.485  16.389  1.00  0.00           C  
ATOM    268  CZ  PHE A  20      28.597  73.489  15.676  1.00  0.00           C  
ATOM    269  H   PHE A  20      26.389  76.087  12.999  1.00  0.00           H  
ATOM    270  HA  PHE A  20      24.511  74.019  12.505  1.00  0.00           H  
ATOM    271  HB2 PHE A  20      24.546  75.807  14.935  1.00  0.00           H  
ATOM    272  HB3 PHE A  20      23.992  74.139  14.824  1.00  0.00           H  
ATOM    273  HD1 PHE A  20      26.250  72.937  13.320  1.00  0.00           H  
ATOM    274  HD2 PHE A  20      26.212  75.703  16.555  1.00  0.00           H  
ATOM    275  HE1 PHE A  20      28.477  72.152  14.012  1.00  0.00           H  
ATOM    276  HE2 PHE A  20      28.440  74.924  17.252  1.00  0.00           H  
ATOM    277  HZ  PHE A  20      29.574  73.145  15.981  1.00  0.00           H  
ATOM    278  N   GLU A  21      22.526  75.252  11.673  1.00  0.00           N  
ATOM    279  CA  GLU A  21      21.279  75.889  11.269  1.00  0.00           C  
ATOM    280  C   GLU A  21      20.242  74.846  10.862  1.00  0.00           C  
ATOM    281  O   GLU A  21      20.498  73.644  10.923  1.00  0.00           O  
ATOM    282  CB  GLU A  21      21.527  76.857  10.110  1.00  0.00           C  
ATOM    283  CG  GLU A  21      21.861  78.270  10.557  1.00  0.00           C  
ATOM    284  CD  GLU A  21      21.413  79.320   9.559  1.00  0.00           C  
ATOM    285  OE1 GLU A  21      21.348  79.002   8.353  1.00  0.00           O  
ATOM    286  OE2 GLU A  21      21.127  80.459   9.984  1.00  0.00           O  
ATOM    287  H   GLU A  21      22.806  74.424  11.229  1.00  0.00           H  
ATOM    288  HA  GLU A  21      20.901  76.444  12.114  1.00  0.00           H  
ATOM    289  HB2 GLU A  21      22.348  76.486   9.516  1.00  0.00           H  
ATOM    290  HB3 GLU A  21      20.640  76.898   9.495  1.00  0.00           H  
ATOM    291  HG2 GLU A  21      21.371  78.461  11.501  1.00  0.00           H  
ATOM    292  HG3 GLU A  21      22.931  78.350  10.687  1.00  0.00           H  
ATOM    293  N   ILE A  22      19.070  75.316  10.448  1.00  0.00           N  
ATOM    294  CA  ILE A  22      17.994  74.426  10.030  1.00  0.00           C  
ATOM    295  C   ILE A  22      18.062  74.146   8.533  1.00  0.00           C  
ATOM    296  O   ILE A  22      17.797  75.025   7.714  1.00  0.00           O  
ATOM    297  CB  ILE A  22      16.612  75.014  10.370  1.00  0.00           C  
ATOM    298  CG1 ILE A  22      16.446  75.140  11.885  1.00  0.00           C  
ATOM    299  CG2 ILE A  22      15.509  74.147   9.782  1.00  0.00           C  
ATOM    300  CD1 ILE A  22      16.807  73.881  12.640  1.00  0.00           C  
ATOM    301  H   ILE A  22      18.926  76.285  10.422  1.00  0.00           H  
ATOM    302  HA  ILE A  22      18.108  73.493  10.565  1.00  0.00           H  
ATOM    303  HB  ILE A  22      16.544  75.994   9.923  1.00  0.00           H  
ATOM    304 HG12 ILE A  22      17.080  75.936  12.245  1.00  0.00           H  
ATOM    305 HG13 ILE A  22      15.416  75.378  12.108  1.00  0.00           H  
ATOM    306 HG21 ILE A  22      14.803  73.888  10.556  1.00  0.00           H  
ATOM    307 HG22 ILE A  22      15.000  74.693   9.001  1.00  0.00           H  
ATOM    308 HG23 ILE A  22      15.939  73.247   9.370  1.00  0.00           H  
ATOM    309 HD11 ILE A  22      17.871  73.706  12.560  1.00  0.00           H  
ATOM    310 HD12 ILE A  22      16.540  73.996  13.681  1.00  0.00           H  
ATOM    311 HD13 ILE A  22      16.273  73.043  12.221  1.00  0.00           H  
ATOM    312  N   GLY A  23      18.417  72.913   8.181  1.00  0.00           N  
ATOM    313  CA  GLY A  23      18.512  72.539   6.782  1.00  0.00           C  
ATOM    314  C   GLY A  23      19.930  72.619   6.255  1.00  0.00           C  
ATOM    315  O   GLY A  23      20.197  72.244   5.114  1.00  0.00           O  
ATOM    316  H   GLY A  23      18.617  72.254   8.877  1.00  0.00           H  
ATOM    317  HA2 GLY A  23      18.151  71.527   6.667  1.00  0.00           H  
ATOM    318  HA3 GLY A  23      17.886  73.202   6.201  1.00  0.00           H  
ATOM    319  N   ALA A  24      20.842  73.112   7.087  1.00  0.00           N  
ATOM    320  CA  ALA A  24      22.241  73.240   6.698  1.00  0.00           C  
ATOM    321  C   ALA A  24      22.821  71.892   6.281  1.00  0.00           C  
ATOM    322  O   ALA A  24      22.498  70.859   6.868  1.00  0.00           O  
ATOM    323  CB  ALA A  24      23.053  73.836   7.838  1.00  0.00           C  
ATOM    324  H   ALA A  24      20.567  73.394   7.984  1.00  0.00           H  
ATOM    325  HA  ALA A  24      22.293  73.918   5.858  1.00  0.00           H  
ATOM    326  HB1 ALA A  24      22.717  74.844   8.031  1.00  0.00           H  
ATOM    327  HB2 ALA A  24      22.919  73.236   8.727  1.00  0.00           H  
ATOM    328  HB3 ALA A  24      24.098  73.851   7.566  1.00  0.00           H  
ATOM    329  N   ARG A  25      23.677  71.910   5.265  1.00  0.00           N  
ATOM    330  CA  ARG A  25      24.299  70.689   4.769  1.00  0.00           C  
ATOM    331  C   ARG A  25      25.738  70.573   5.264  1.00  0.00           C  
ATOM    332  O   ARG A  25      26.583  71.413   4.952  1.00  0.00           O  
ATOM    333  CB  ARG A  25      24.270  70.661   3.240  1.00  0.00           C  
ATOM    334  CG  ARG A  25      22.881  70.850   2.653  1.00  0.00           C  
ATOM    335  CD  ARG A  25      22.945  71.381   1.230  1.00  0.00           C  
ATOM    336  NE  ARG A  25      21.628  71.769   0.731  1.00  0.00           N  
ATOM    337  CZ  ARG A  25      21.440  72.444  -0.398  1.00  0.00           C  
ATOM    338  NH1 ARG A  25      22.478  72.802  -1.141  1.00  0.00           N  
ATOM    339  NH2 ARG A  25      20.211  72.760  -0.785  1.00  0.00           N  
ATOM    340  H   ARG A  25      23.894  72.765   4.838  1.00  0.00           H  
ATOM    341  HA  ARG A  25      23.732  69.851   5.146  1.00  0.00           H  
ATOM    342  HB2 ARG A  25      24.905  71.451   2.865  1.00  0.00           H  
ATOM    343  HB3 ARG A  25      24.654  69.710   2.902  1.00  0.00           H  
ATOM    344  HG2 ARG A  25      22.371  69.898   2.648  1.00  0.00           H  
ATOM    345  HG3 ARG A  25      22.334  71.550   3.266  1.00  0.00           H  
ATOM    346  HD2 ARG A  25      23.595  72.243   1.210  1.00  0.00           H  
ATOM    347  HD3 ARG A  25      23.349  70.611   0.590  1.00  0.00           H  
ATOM    348  HE  ARG A  25      20.847  71.514   1.265  1.00  0.00           H  
ATOM    349 HH11 ARG A  25      23.405  72.565  -0.852  1.00  0.00           H  
ATOM    350 HH12 ARG A  25      22.332  73.309  -1.991  1.00  0.00           H  
ATOM    351 HH21 ARG A  25      19.426  72.492  -0.228  1.00  0.00           H  
ATOM    352 HH22 ARG A  25      20.069  73.268  -1.634  1.00  0.00           H  
ATOM    353  N   LEU A  26      26.009  69.527   6.037  1.00  0.00           N  
ATOM    354  CA  LEU A  26      27.346  69.301   6.576  1.00  0.00           C  
ATOM    355  C   LEU A  26      27.630  67.810   6.721  1.00  0.00           C  
ATOM    356  O   LEU A  26      26.814  66.973   6.334  1.00  0.00           O  
ATOM    357  CB  LEU A  26      27.495  69.994   7.932  1.00  0.00           C  
ATOM    358  CG  LEU A  26      26.457  69.623   8.992  1.00  0.00           C  
ATOM    359  CD1 LEU A  26      25.100  70.213   8.641  1.00  0.00           C  
ATOM    360  CD2 LEU A  26      26.361  68.112   9.140  1.00  0.00           C  
ATOM    361  H   LEU A  26      25.295  68.892   6.252  1.00  0.00           H  
ATOM    362  HA  LEU A  26      28.058  69.725   5.884  1.00  0.00           H  
ATOM    363  HB2 LEU A  26      28.470  69.748   8.324  1.00  0.00           H  
ATOM    364  HB3 LEU A  26      27.434  71.060   7.766  1.00  0.00           H  
ATOM    365  HG  LEU A  26      26.762  70.034   9.945  1.00  0.00           H  
ATOM    366 HD11 LEU A  26      25.183  70.790   7.732  1.00  0.00           H  
ATOM    367 HD12 LEU A  26      24.768  70.854   9.444  1.00  0.00           H  
ATOM    368 HD13 LEU A  26      24.387  69.415   8.499  1.00  0.00           H  
ATOM    369 HD21 LEU A  26      25.912  67.871  10.092  1.00  0.00           H  
ATOM    370 HD22 LEU A  26      27.351  67.682   9.089  1.00  0.00           H  
ATOM    371 HD23 LEU A  26      25.753  67.710   8.342  1.00  0.00           H  
ATOM    372  N   GLU A  27      28.789  67.484   7.282  1.00  0.00           N  
ATOM    373  CA  GLU A  27      29.179  66.093   7.479  1.00  0.00           C  
ATOM    374  C   GLU A  27      29.219  65.744   8.963  1.00  0.00           C  
ATOM    375  O   GLU A  27      29.404  66.616   9.812  1.00  0.00           O  
ATOM    376  CB  GLU A  27      30.546  65.828   6.844  1.00  0.00           C  
ATOM    377  CG  GLU A  27      30.547  65.952   5.329  1.00  0.00           C  
ATOM    378  CD  GLU A  27      31.574  65.050   4.672  1.00  0.00           C  
ATOM    379  OE1 GLU A  27      31.394  63.816   4.713  1.00  0.00           O  
ATOM    380  OE2 GLU A  27      32.558  65.581   4.114  1.00  0.00           O  
ATOM    381  H   GLU A  27      29.398  68.196   7.570  1.00  0.00           H  
ATOM    382  HA  GLU A  27      28.441  65.470   6.995  1.00  0.00           H  
ATOM    383  HB2 GLU A  27      31.258  66.534   7.244  1.00  0.00           H  
ATOM    384  HB3 GLU A  27      30.860  64.827   7.102  1.00  0.00           H  
ATOM    385  HG2 GLU A  27      29.569  65.689   4.958  1.00  0.00           H  
ATOM    386  HG3 GLU A  27      30.768  66.976   5.066  1.00  0.00           H  
ATOM    387  N   ALA A  28      29.046  64.462   9.270  1.00  0.00           N  
ATOM    388  CA  ALA A  28      29.064  63.996  10.651  1.00  0.00           C  
ATOM    389  C   ALA A  28      29.933  62.752  10.799  1.00  0.00           C  
ATOM    390  O   ALA A  28      29.996  61.915   9.898  1.00  0.00           O  
ATOM    391  CB  ALA A  28      27.648  63.715  11.131  1.00  0.00           C  
ATOM    392  H   ALA A  28      28.903  63.814   8.549  1.00  0.00           H  
ATOM    393  HA  ALA A  28      29.475  64.786  11.263  1.00  0.00           H  
ATOM    394  HB1 ALA A  28      27.583  62.696  11.484  1.00  0.00           H  
ATOM    395  HB2 ALA A  28      27.400  64.392  11.936  1.00  0.00           H  
ATOM    396  HB3 ALA A  28      26.955  63.858  10.315  1.00  0.00           H  
ATOM    397  N   LEU A  29      30.600  62.636  11.942  1.00  0.00           N  
ATOM    398  CA  LEU A  29      31.466  61.493  12.209  1.00  0.00           C  
ATOM    399  C   LEU A  29      30.692  60.371  12.893  1.00  0.00           C  
ATOM    400  O   LEU A  29      30.371  60.460  14.079  1.00  0.00           O  
ATOM    401  CB  LEU A  29      32.650  61.917  13.080  1.00  0.00           C  
ATOM    402  CG  LEU A  29      33.815  60.930  13.158  1.00  0.00           C  
ATOM    403  CD1 LEU A  29      34.729  61.086  11.953  1.00  0.00           C  
ATOM    404  CD2 LEU A  29      34.594  61.125  14.450  1.00  0.00           C  
ATOM    405  H   LEU A  29      30.509  63.335  12.622  1.00  0.00           H  
ATOM    406  HA  LEU A  29      31.838  61.131  11.262  1.00  0.00           H  
ATOM    407  HB2 LEU A  29      33.031  62.848  12.688  1.00  0.00           H  
ATOM    408  HB3 LEU A  29      32.281  62.076  14.084  1.00  0.00           H  
ATOM    409  HG  LEU A  29      33.424  59.921  13.151  1.00  0.00           H  
ATOM    410 HD11 LEU A  29      34.183  60.846  11.054  1.00  0.00           H  
ATOM    411 HD12 LEU A  29      35.572  60.419  12.051  1.00  0.00           H  
ATOM    412 HD13 LEU A  29      35.082  62.107  11.899  1.00  0.00           H  
ATOM    413 HD21 LEU A  29      34.002  61.703  15.144  1.00  0.00           H  
ATOM    414 HD22 LEU A  29      35.515  61.648  14.238  1.00  0.00           H  
ATOM    415 HD23 LEU A  29      34.820  60.161  14.883  1.00  0.00           H  
ATOM    416  N   ASP A  30      30.398  59.318  12.141  1.00  0.00           N  
ATOM    417  CA  ASP A  30      29.664  58.176  12.676  1.00  0.00           C  
ATOM    418  C   ASP A  30      30.549  57.348  13.601  1.00  0.00           C  
ATOM    419  O   ASP A  30      31.774  57.469  13.579  1.00  0.00           O  
ATOM    420  CB  ASP A  30      29.137  57.302  11.537  1.00  0.00           C  
ATOM    421  CG  ASP A  30      30.248  56.591  10.790  1.00  0.00           C  
ATOM    422  OD1 ASP A  30      31.370  56.509  11.333  1.00  0.00           O  
ATOM    423  OD2 ASP A  30      29.995  56.117   9.663  1.00  0.00           O  
ATOM    424  H   ASP A  30      30.681  59.307  11.202  1.00  0.00           H  
ATOM    425  HA  ASP A  30      28.828  58.556  13.243  1.00  0.00           H  
ATOM    426  HB2 ASP A  30      28.467  56.558  11.944  1.00  0.00           H  
ATOM    427  HB3 ASP A  30      28.595  57.922  10.837  1.00  0.00           H  
ATOM    428  N   TYR A  31      29.921  56.506  14.415  1.00  0.00           N  
ATOM    429  CA  TYR A  31      30.651  55.659  15.351  1.00  0.00           C  
ATOM    430  C   TYR A  31      31.796  54.935  14.651  1.00  0.00           C  
ATOM    431  O   TYR A  31      32.756  54.500  15.291  1.00  0.00           O  
ATOM    432  CB  TYR A  31      29.707  54.642  15.994  1.00  0.00           C  
ATOM    433  CG  TYR A  31      28.838  53.908  14.999  1.00  0.00           C  
ATOM    434  CD1 TYR A  31      27.645  54.460  14.548  1.00  0.00           C  
ATOM    435  CD2 TYR A  31      29.209  52.662  14.508  1.00  0.00           C  
ATOM    436  CE1 TYR A  31      26.847  53.792  13.639  1.00  0.00           C  
ATOM    437  CE2 TYR A  31      28.419  51.987  13.598  1.00  0.00           C  
ATOM    438  CZ  TYR A  31      27.239  52.556  13.166  1.00  0.00           C  
ATOM    439  OH  TYR A  31      26.448  51.888  12.260  1.00  0.00           O  
ATOM    440  H   TYR A  31      28.943  56.454  14.387  1.00  0.00           H  
ATOM    441  HA  TYR A  31      31.061  56.294  16.123  1.00  0.00           H  
ATOM    442  HB2 TYR A  31      30.289  53.909  16.530  1.00  0.00           H  
ATOM    443  HB3 TYR A  31      29.057  55.155  16.689  1.00  0.00           H  
ATOM    444  HD1 TYR A  31      27.341  55.427  14.920  1.00  0.00           H  
ATOM    445  HD2 TYR A  31      30.135  52.219  14.849  1.00  0.00           H  
ATOM    446  HE1 TYR A  31      25.924  54.237  13.300  1.00  0.00           H  
ATOM    447  HE2 TYR A  31      28.726  51.021  13.229  1.00  0.00           H  
ATOM    448  HH  TYR A  31      26.845  51.943  11.388  1.00  0.00           H  
ATOM    449  N   LEU A  32      31.689  54.807  13.333  1.00  0.00           N  
ATOM    450  CA  LEU A  32      32.716  54.136  12.543  1.00  0.00           C  
ATOM    451  C   LEU A  32      33.829  55.105  12.160  1.00  0.00           C  
ATOM    452  O   LEU A  32      34.623  54.829  11.261  1.00  0.00           O  
ATOM    453  CB  LEU A  32      32.099  53.525  11.283  1.00  0.00           C  
ATOM    454  CG  LEU A  32      30.934  52.560  11.505  1.00  0.00           C  
ATOM    455  CD1 LEU A  32      30.287  52.191  10.180  1.00  0.00           C  
ATOM    456  CD2 LEU A  32      31.407  51.312  12.237  1.00  0.00           C  
ATOM    457  H   LEU A  32      30.902  55.173  12.879  1.00  0.00           H  
ATOM    458  HA  LEU A  32      33.134  53.345  13.148  1.00  0.00           H  
ATOM    459  HB2 LEU A  32      31.745  54.334  10.663  1.00  0.00           H  
ATOM    460  HB3 LEU A  32      32.880  52.989  10.761  1.00  0.00           H  
ATOM    461  HG  LEU A  32      30.186  53.045  12.118  1.00  0.00           H  
ATOM    462 HD11 LEU A  32      29.637  51.341  10.321  1.00  0.00           H  
ATOM    463 HD12 LEU A  32      31.053  51.943   9.461  1.00  0.00           H  
ATOM    464 HD13 LEU A  32      29.709  53.029   9.815  1.00  0.00           H  
ATOM    465 HD21 LEU A  32      30.758  51.121  13.078  1.00  0.00           H  
ATOM    466 HD22 LEU A  32      32.417  51.462  12.587  1.00  0.00           H  
ATOM    467 HD23 LEU A  32      31.381  50.469  11.561  1.00  0.00           H  
ATOM    468  N   GLN A  33      33.883  56.240  12.850  1.00  0.00           N  
ATOM    469  CA  GLN A  33      34.900  57.250  12.582  1.00  0.00           C  
ATOM    470  C   GLN A  33      34.966  57.575  11.094  1.00  0.00           C  
ATOM    471  O   GLN A  33      36.011  57.974  10.581  1.00  0.00           O  
ATOM    472  CB  GLN A  33      36.267  56.768  13.073  1.00  0.00           C  
ATOM    473  CG  GLN A  33      36.312  56.482  14.565  1.00  0.00           C  
ATOM    474  CD  GLN A  33      37.700  56.646  15.149  1.00  0.00           C  
ATOM    475  OE1 GLN A  33      38.499  57.452  14.666  1.00  0.00           O  
ATOM    476  NE2 GLN A  33      37.998  55.883  16.194  1.00  0.00           N  
ATOM    477  H   GLN A  33      33.221  56.402  13.554  1.00  0.00           H  
ATOM    478  HA  GLN A  33      34.629  58.144  13.122  1.00  0.00           H  
ATOM    479  HB2 GLN A  33      36.526  55.862  12.546  1.00  0.00           H  
ATOM    480  HB3 GLN A  33      37.002  57.527  12.851  1.00  0.00           H  
ATOM    481  HG2 GLN A  33      35.643  57.165  15.070  1.00  0.00           H  
ATOM    482  HG3 GLN A  33      35.983  55.468  14.735  1.00  0.00           H  
ATOM    483 HE21 GLN A  33      37.312  55.264  16.524  1.00  0.00           H  
ATOM    484 HE22 GLN A  33      38.889  55.968  16.591  1.00  0.00           H  
ATOM    485  N   LYS A  34      33.844  57.399  10.404  1.00  0.00           N  
ATOM    486  CA  LYS A  34      33.772  57.674   8.974  1.00  0.00           C  
ATOM    487  C   LYS A  34      33.106  59.021   8.711  1.00  0.00           C  
ATOM    488  O   LYS A  34      32.281  59.480   9.502  1.00  0.00           O  
ATOM    489  CB  LYS A  34      33.001  56.564   8.258  1.00  0.00           C  
ATOM    490  CG  LYS A  34      33.774  55.261   8.147  1.00  0.00           C  
ATOM    491  CD  LYS A  34      34.882  55.356   7.111  1.00  0.00           C  
ATOM    492  CE  LYS A  34      34.365  55.054   5.713  1.00  0.00           C  
ATOM    493  NZ  LYS A  34      35.476  54.824   4.748  1.00  0.00           N  
ATOM    494  H   LYS A  34      33.042  57.077  10.870  1.00  0.00           H  
ATOM    495  HA  LYS A  34      34.781  57.704   8.592  1.00  0.00           H  
ATOM    496  HB2 LYS A  34      32.087  56.370   8.799  1.00  0.00           H  
ATOM    497  HB3 LYS A  34      32.755  56.898   7.261  1.00  0.00           H  
ATOM    498  HG2 LYS A  34      34.212  55.029   9.106  1.00  0.00           H  
ATOM    499  HG3 LYS A  34      33.093  54.472   7.860  1.00  0.00           H  
ATOM    500  HD2 LYS A  34      35.288  56.356   7.123  1.00  0.00           H  
ATOM    501  HD3 LYS A  34      35.658  54.647   7.359  1.00  0.00           H  
ATOM    502  HE2 LYS A  34      33.748  54.169   5.754  1.00  0.00           H  
ATOM    503  HE3 LYS A  34      33.771  55.890   5.374  1.00  0.00           H  
ATOM    504  HZ1 LYS A  34      36.290  54.399   5.235  1.00  0.00           H  
ATOM    505  HZ2 LYS A  34      35.772  55.727   4.324  1.00  0.00           H  
ATOM    506  HZ3 LYS A  34      35.165  54.184   3.990  1.00  0.00           H  
ATOM    507  N   TRP A  35      33.467  59.647   7.598  1.00  0.00           N  
ATOM    508  CA  TRP A  35      32.902  60.941   7.232  1.00  0.00           C  
ATOM    509  C   TRP A  35      31.814  60.780   6.176  1.00  0.00           C  
ATOM    510  O   TRP A  35      31.992  60.064   5.191  1.00  0.00           O  
ATOM    511  CB  TRP A  35      34.000  61.871   6.713  1.00  0.00           C  
ATOM    512  CG  TRP A  35      34.899  62.389   7.793  1.00  0.00           C  
ATOM    513  CD1 TRP A  35      36.226  62.113   7.959  1.00  0.00           C  
ATOM    514  CD2 TRP A  35      34.536  63.272   8.861  1.00  0.00           C  
ATOM    515  NE1 TRP A  35      36.710  62.771   9.063  1.00  0.00           N  
ATOM    516  CE2 TRP A  35      35.693  63.489   9.635  1.00  0.00           C  
ATOM    517  CE3 TRP A  35      33.346  63.902   9.238  1.00  0.00           C  
ATOM    518  CZ2 TRP A  35      35.693  64.308  10.761  1.00  0.00           C  
ATOM    519  CZ3 TRP A  35      33.347  64.713  10.355  1.00  0.00           C  
ATOM    520  CH2 TRP A  35      34.513  64.911  11.106  1.00  0.00           C  
ATOM    521  H   TRP A  35      34.129  59.230   7.007  1.00  0.00           H  
ATOM    522  HA  TRP A  35      32.466  61.374   8.119  1.00  0.00           H  
ATOM    523  HB2 TRP A  35      34.609  61.336   6.000  1.00  0.00           H  
ATOM    524  HB3 TRP A  35      33.541  62.718   6.224  1.00  0.00           H  
ATOM    525  HD1 TRP A  35      36.798  61.469   7.308  1.00  0.00           H  
ATOM    526  HE1 TRP A  35      37.635  62.733   9.389  1.00  0.00           H  
ATOM    527  HE3 TRP A  35      32.437  63.762   8.671  1.00  0.00           H  
ATOM    528  HZ2 TRP A  35      36.583  64.471  11.349  1.00  0.00           H  
ATOM    529  HZ3 TRP A  35      32.437  65.208  10.662  1.00  0.00           H  
ATOM    530  HH2 TRP A  35      34.468  65.553  11.973  1.00  0.00           H  
ATOM    531  N   TYR A  36      30.687  61.452   6.386  1.00  0.00           N  
ATOM    532  CA  TYR A  36      29.569  61.381   5.454  1.00  0.00           C  
ATOM    533  C   TYR A  36      28.711  62.639   5.535  1.00  0.00           C  
ATOM    534  O   TYR A  36      28.672  63.330   6.554  1.00  0.00           O  
ATOM    535  CB  TYR A  36      28.713  60.147   5.743  1.00  0.00           C  
ATOM    536  CG  TYR A  36      29.408  58.841   5.430  1.00  0.00           C  
ATOM    537  CD1 TYR A  36      29.837  58.551   4.141  1.00  0.00           C  
ATOM    538  CD2 TYR A  36      29.635  57.896   6.424  1.00  0.00           C  
ATOM    539  CE1 TYR A  36      30.472  57.359   3.850  1.00  0.00           C  
ATOM    540  CE2 TYR A  36      30.269  56.702   6.142  1.00  0.00           C  
ATOM    541  CZ  TYR A  36      30.685  56.438   4.854  1.00  0.00           C  
ATOM    542  OH  TYR A  36      31.318  55.249   4.569  1.00  0.00           O  
ATOM    543  H   TYR A  36      30.604  62.006   7.190  1.00  0.00           H  
ATOM    544  HA  TYR A  36      29.975  61.300   4.456  1.00  0.00           H  
ATOM    545  HB2 TYR A  36      28.448  60.137   6.789  1.00  0.00           H  
ATOM    546  HB3 TYR A  36      27.812  60.195   5.149  1.00  0.00           H  
ATOM    547  HD1 TYR A  36      29.669  59.276   3.357  1.00  0.00           H  
ATOM    548  HD2 TYR A  36      29.308  58.107   7.432  1.00  0.00           H  
ATOM    549  HE1 TYR A  36      30.798  57.153   2.842  1.00  0.00           H  
ATOM    550  HE2 TYR A  36      30.438  55.980   6.928  1.00  0.00           H  
ATOM    551  HH  TYR A  36      31.957  55.054   5.258  1.00  0.00           H  
ATOM    552  N   PRO A  37      28.006  62.946   4.436  1.00  0.00           N  
ATOM    553  CA  PRO A  37      27.134  64.121   4.358  1.00  0.00           C  
ATOM    554  C   PRO A  37      25.893  63.983   5.234  1.00  0.00           C  
ATOM    555  O   PRO A  37      25.468  62.873   5.553  1.00  0.00           O  
ATOM    556  CB  PRO A  37      26.741  64.173   2.879  1.00  0.00           C  
ATOM    557  CG  PRO A  37      26.869  62.767   2.404  1.00  0.00           C  
ATOM    558  CD  PRO A  37      28.005  62.168   3.186  1.00  0.00           C  
ATOM    559  HA  PRO A  37      27.662  65.026   4.623  1.00  0.00           H  
ATOM    560  HB2 PRO A  37      25.725  64.531   2.787  1.00  0.00           H  
ATOM    561  HB3 PRO A  37      27.411  64.832   2.348  1.00  0.00           H  
ATOM    562  HG2 PRO A  37      25.954  62.229   2.598  1.00  0.00           H  
ATOM    563  HG3 PRO A  37      27.096  62.757   1.348  1.00  0.00           H  
ATOM    564  HD2 PRO A  37      27.817  61.122   3.383  1.00  0.00           H  
ATOM    565  HD3 PRO A  37      28.937  62.292   2.655  1.00  0.00           H  
ATOM    566  N   SER A  38      25.318  65.117   5.620  1.00  0.00           N  
ATOM    567  CA  SER A  38      24.128  65.123   6.463  1.00  0.00           C  
ATOM    568  C   SER A  38      23.494  66.510   6.499  1.00  0.00           C  
ATOM    569  O   SER A  38      24.057  67.475   5.982  1.00  0.00           O  
ATOM    570  CB  SER A  38      24.481  64.673   7.882  1.00  0.00           C  
ATOM    571  OG  SER A  38      24.864  63.310   7.905  1.00  0.00           O  
ATOM    572  H   SER A  38      25.705  65.971   5.332  1.00  0.00           H  
ATOM    573  HA  SER A  38      23.419  64.427   6.039  1.00  0.00           H  
ATOM    574  HB2 SER A  38      25.299  65.271   8.253  1.00  0.00           H  
ATOM    575  HB3 SER A  38      23.620  64.804   8.522  1.00  0.00           H  
ATOM    576  HG  SER A  38      25.775  63.228   7.613  1.00  0.00           H  
ATOM    577  N   ARG A  39      22.319  66.600   7.113  1.00  0.00           N  
ATOM    578  CA  ARG A  39      21.607  67.868   7.216  1.00  0.00           C  
ATOM    579  C   ARG A  39      21.013  68.046   8.610  1.00  0.00           C  
ATOM    580  O   ARG A  39      20.905  67.089   9.377  1.00  0.00           O  
ATOM    581  CB  ARG A  39      20.498  67.941   6.165  1.00  0.00           C  
ATOM    582  CG  ARG A  39      20.941  68.568   4.853  1.00  0.00           C  
ATOM    583  CD  ARG A  39      19.817  68.572   3.829  1.00  0.00           C  
ATOM    584  NE  ARG A  39      20.324  68.498   2.461  1.00  0.00           N  
ATOM    585  CZ  ARG A  39      20.944  67.434   1.963  1.00  0.00           C  
ATOM    586  NH1 ARG A  39      21.132  66.360   2.716  1.00  0.00           N  
ATOM    587  NH2 ARG A  39      21.376  67.443   0.708  1.00  0.00           N  
ATOM    588  H   ARG A  39      21.920  65.795   7.505  1.00  0.00           H  
ATOM    589  HA  ARG A  39      22.314  68.663   7.034  1.00  0.00           H  
ATOM    590  HB2 ARG A  39      20.146  66.940   5.958  1.00  0.00           H  
ATOM    591  HB3 ARG A  39      19.681  68.526   6.561  1.00  0.00           H  
ATOM    592  HG2 ARG A  39      21.247  69.588   5.038  1.00  0.00           H  
ATOM    593  HG3 ARG A  39      21.774  68.006   4.460  1.00  0.00           H  
ATOM    594  HD2 ARG A  39      19.179  67.720   4.011  1.00  0.00           H  
ATOM    595  HD3 ARG A  39      19.246  69.480   3.943  1.00  0.00           H  
ATOM    596  HE  ARG A  39      20.195  69.281   1.887  1.00  0.00           H  
ATOM    597 HH11 ARG A  39      20.806  66.349   3.661  1.00  0.00           H  
ATOM    598 HH12 ARG A  39      21.598  65.559   2.338  1.00  0.00           H  
ATOM    599 HH21 ARG A  39      21.235  68.251   0.137  1.00  0.00           H  
ATOM    600 HH22 ARG A  39      21.842  66.642   0.335  1.00  0.00           H  
ATOM    601  N   ILE A  40      20.632  69.278   8.932  1.00  0.00           N  
ATOM    602  CA  ILE A  40      20.049  69.581  10.233  1.00  0.00           C  
ATOM    603  C   ILE A  40      18.534  69.732  10.136  1.00  0.00           C  
ATOM    604  O   ILE A  40      18.032  70.766   9.697  1.00  0.00           O  
ATOM    605  CB  ILE A  40      20.645  70.870  10.830  1.00  0.00           C  
ATOM    606  CG1 ILE A  40      22.082  70.626  11.295  1.00  0.00           C  
ATOM    607  CG2 ILE A  40      19.786  71.365  11.984  1.00  0.00           C  
ATOM    608  CD1 ILE A  40      22.887  71.896  11.462  1.00  0.00           C  
ATOM    609  H   ILE A  40      20.743  69.999   8.278  1.00  0.00           H  
ATOM    610  HA  ILE A  40      20.277  68.761  10.899  1.00  0.00           H  
ATOM    611  HB  ILE A  40      20.646  71.628  10.063  1.00  0.00           H  
ATOM    612 HG12 ILE A  40      22.065  70.117  12.246  1.00  0.00           H  
ATOM    613 HG13 ILE A  40      22.586  70.005  10.569  1.00  0.00           H  
ATOM    614 HG21 ILE A  40      20.419  71.809  12.739  1.00  0.00           H  
ATOM    615 HG22 ILE A  40      19.087  72.104  11.621  1.00  0.00           H  
ATOM    616 HG23 ILE A  40      19.243  70.535  12.412  1.00  0.00           H  
ATOM    617 HD11 ILE A  40      23.719  71.709  12.126  1.00  0.00           H  
ATOM    618 HD12 ILE A  40      23.261  72.214  10.500  1.00  0.00           H  
ATOM    619 HD13 ILE A  40      22.260  72.668  11.879  1.00  0.00           H  
ATOM    620  N   GLU A  41      17.814  68.695  10.551  1.00  0.00           N  
ATOM    621  CA  GLU A  41      16.356  68.713  10.510  1.00  0.00           C  
ATOM    622  C   GLU A  41      15.795  69.644  11.581  1.00  0.00           C  
ATOM    623  O   GLU A  41      14.872  70.417  11.326  1.00  0.00           O  
ATOM    624  CB  GLU A  41      15.801  67.301  10.704  1.00  0.00           C  
ATOM    625  CG  GLU A  41      16.029  66.388   9.511  1.00  0.00           C  
ATOM    626  CD  GLU A  41      15.466  66.958   8.224  1.00  0.00           C  
ATOM    627  OE1 GLU A  41      14.237  67.174   8.160  1.00  0.00           O  
ATOM    628  OE2 GLU A  41      16.252  67.186   7.281  1.00  0.00           O  
ATOM    629  H   GLU A  41      18.273  67.898  10.889  1.00  0.00           H  
ATOM    630  HA  GLU A  41      16.055  69.078   9.539  1.00  0.00           H  
ATOM    631  HB2 GLU A  41      16.274  66.856  11.568  1.00  0.00           H  
ATOM    632  HB3 GLU A  41      14.737  67.366  10.881  1.00  0.00           H  
ATOM    633  HG2 GLU A  41      17.092  66.238   9.386  1.00  0.00           H  
ATOM    634  HG3 GLU A  41      15.555  65.438   9.705  1.00  0.00           H  
ATOM    635  N   LYS A  42      16.358  69.562  12.782  1.00  0.00           N  
ATOM    636  CA  LYS A  42      15.916  70.396  13.893  1.00  0.00           C  
ATOM    637  C   LYS A  42      17.081  70.734  14.818  1.00  0.00           C  
ATOM    638  O   LYS A  42      18.139  70.107  14.753  1.00  0.00           O  
ATOM    639  CB  LYS A  42      14.814  69.686  14.684  1.00  0.00           C  
ATOM    640  CG  LYS A  42      13.440  69.799  14.047  1.00  0.00           C  
ATOM    641  CD  LYS A  42      12.451  68.833  14.678  1.00  0.00           C  
ATOM    642  CE  LYS A  42      11.266  68.572  13.762  1.00  0.00           C  
ATOM    643  NZ  LYS A  42      10.428  69.788  13.578  1.00  0.00           N  
ATOM    644  H   LYS A  42      17.090  68.926  12.924  1.00  0.00           H  
ATOM    645  HA  LYS A  42      15.519  71.313  13.483  1.00  0.00           H  
ATOM    646  HB2 LYS A  42      15.064  68.639  14.767  1.00  0.00           H  
ATOM    647  HB3 LYS A  42      14.765  70.115  15.674  1.00  0.00           H  
ATOM    648  HG2 LYS A  42      13.074  70.807  14.178  1.00  0.00           H  
ATOM    649  HG3 LYS A  42      13.522  69.578  12.992  1.00  0.00           H  
ATOM    650  HD2 LYS A  42      12.953  67.897  14.875  1.00  0.00           H  
ATOM    651  HD3 LYS A  42      12.092  69.254  15.607  1.00  0.00           H  
ATOM    652  HE2 LYS A  42      11.634  68.250  12.799  1.00  0.00           H  
ATOM    653  HE3 LYS A  42      10.659  67.789  14.194  1.00  0.00           H  
ATOM    654  HZ1 LYS A  42      10.745  70.541  14.221  1.00  0.00           H  
ATOM    655  HZ2 LYS A  42       9.431  69.571  13.782  1.00  0.00           H  
ATOM    656  HZ3 LYS A  42      10.503  70.130  12.598  1.00  0.00           H  
ATOM    657  N   ILE A  43      16.880  71.728  15.676  1.00  0.00           N  
ATOM    658  CA  ILE A  43      17.915  72.147  16.615  1.00  0.00           C  
ATOM    659  C   ILE A  43      17.313  72.514  17.967  1.00  0.00           C  
ATOM    660  O   ILE A  43      16.355  73.282  18.044  1.00  0.00           O  
ATOM    661  CB  ILE A  43      18.710  73.351  16.076  1.00  0.00           C  
ATOM    662  CG1 ILE A  43      19.398  72.986  14.759  1.00  0.00           C  
ATOM    663  CG2 ILE A  43      19.731  73.813  17.103  1.00  0.00           C  
ATOM    664  CD1 ILE A  43      20.128  74.146  14.117  1.00  0.00           C  
ATOM    665  H   ILE A  43      16.017  72.190  15.679  1.00  0.00           H  
ATOM    666  HA  ILE A  43      18.598  71.321  16.748  1.00  0.00           H  
ATOM    667  HB  ILE A  43      18.019  74.161  15.900  1.00  0.00           H  
ATOM    668 HG12 ILE A  43      20.118  72.202  14.940  1.00  0.00           H  
ATOM    669 HG13 ILE A  43      18.655  72.632  14.059  1.00  0.00           H  
ATOM    670 HG21 ILE A  43      20.034  74.826  16.880  1.00  0.00           H  
ATOM    671 HG22 ILE A  43      19.291  73.780  18.088  1.00  0.00           H  
ATOM    672 HG23 ILE A  43      20.594  73.164  17.072  1.00  0.00           H  
ATOM    673 HD11 ILE A  43      19.514  74.569  13.336  1.00  0.00           H  
ATOM    674 HD12 ILE A  43      20.331  74.901  14.862  1.00  0.00           H  
ATOM    675 HD13 ILE A  43      21.058  73.797  13.694  1.00  0.00           H  
ATOM    676  N   ASP A  44      17.884  71.960  19.031  1.00  0.00           N  
ATOM    677  CA  ASP A  44      17.408  72.232  20.382  1.00  0.00           C  
ATOM    678  C   ASP A  44      18.396  73.110  21.142  1.00  0.00           C  
ATOM    679  O   ASP A  44      19.457  72.647  21.563  1.00  0.00           O  
ATOM    680  CB  ASP A  44      17.183  70.922  21.140  1.00  0.00           C  
ATOM    681  CG  ASP A  44      16.269  71.093  22.337  1.00  0.00           C  
ATOM    682  OD1 ASP A  44      16.218  72.212  22.889  1.00  0.00           O  
ATOM    683  OD2 ASP A  44      15.602  70.109  22.719  1.00  0.00           O  
ATOM    684  H   ASP A  44      18.646  71.356  18.905  1.00  0.00           H  
ATOM    685  HA  ASP A  44      16.467  72.755  20.303  1.00  0.00           H  
ATOM    686  HB2 ASP A  44      16.739  70.198  20.471  1.00  0.00           H  
ATOM    687  HB3 ASP A  44      18.135  70.547  21.487  1.00  0.00           H  
ATOM    688  N   TYR A  45      18.043  74.378  21.314  1.00  0.00           N  
ATOM    689  CA  TYR A  45      18.900  75.323  22.019  1.00  0.00           C  
ATOM    690  C   TYR A  45      18.702  75.215  23.528  1.00  0.00           C  
ATOM    691  O   TYR A  45      19.555  75.638  24.308  1.00  0.00           O  
ATOM    692  CB  TYR A  45      18.611  76.752  21.555  1.00  0.00           C  
ATOM    693  CG  TYR A  45      19.113  77.049  20.160  1.00  0.00           C  
ATOM    694  CD1 TYR A  45      18.513  76.471  19.048  1.00  0.00           C  
ATOM    695  CD2 TYR A  45      20.185  77.908  19.954  1.00  0.00           C  
ATOM    696  CE1 TYR A  45      18.968  76.738  17.771  1.00  0.00           C  
ATOM    697  CE2 TYR A  45      20.645  78.182  18.681  1.00  0.00           C  
ATOM    698  CZ  TYR A  45      20.034  77.595  17.593  1.00  0.00           C  
ATOM    699  OH  TYR A  45      20.490  77.865  16.323  1.00  0.00           O  
ATOM    700  H   TYR A  45      17.185  74.688  20.956  1.00  0.00           H  
ATOM    701  HA  TYR A  45      19.926  75.079  21.784  1.00  0.00           H  
ATOM    702  HB2 TYR A  45      17.545  76.918  21.567  1.00  0.00           H  
ATOM    703  HB3 TYR A  45      19.086  77.446  22.234  1.00  0.00           H  
ATOM    704  HD1 TYR A  45      17.678  75.801  19.192  1.00  0.00           H  
ATOM    705  HD2 TYR A  45      20.662  78.366  20.808  1.00  0.00           H  
ATOM    706  HE1 TYR A  45      18.489  76.279  16.919  1.00  0.00           H  
ATOM    707  HE2 TYR A  45      21.481  78.852  18.541  1.00  0.00           H  
ATOM    708  HH  TYR A  45      21.183  77.242  16.092  1.00  0.00           H  
ATOM    709  N   GLU A  46      17.570  74.648  23.931  1.00  0.00           N  
ATOM    710  CA  GLU A  46      17.259  74.485  25.346  1.00  0.00           C  
ATOM    711  C   GLU A  46      17.988  73.278  25.928  1.00  0.00           C  
ATOM    712  O   GLU A  46      18.278  73.232  27.123  1.00  0.00           O  
ATOM    713  CB  GLU A  46      15.750  74.329  25.545  1.00  0.00           C  
ATOM    714  CG  GLU A  46      14.984  75.639  25.454  1.00  0.00           C  
ATOM    715  CD  GLU A  46      15.446  76.657  26.478  1.00  0.00           C  
ATOM    716  OE1 GLU A  46      15.106  76.496  27.668  1.00  0.00           O  
ATOM    717  OE2 GLU A  46      16.148  77.614  26.089  1.00  0.00           O  
ATOM    718  H   GLU A  46      16.928  74.332  23.261  1.00  0.00           H  
ATOM    719  HA  GLU A  46      17.590  75.373  25.863  1.00  0.00           H  
ATOM    720  HB2 GLU A  46      15.367  73.659  24.790  1.00  0.00           H  
ATOM    721  HB3 GLU A  46      15.570  73.899  26.520  1.00  0.00           H  
ATOM    722  HG2 GLU A  46      15.125  76.055  24.468  1.00  0.00           H  
ATOM    723  HG3 GLU A  46      13.935  75.439  25.614  1.00  0.00           H  
ATOM    724  N   GLU A  47      18.279  72.301  25.074  1.00  0.00           N  
ATOM    725  CA  GLU A  47      18.971  71.093  25.504  1.00  0.00           C  
ATOM    726  C   GLU A  47      20.398  71.063  24.963  1.00  0.00           C  
ATOM    727  O   GLU A  47      21.338  70.721  25.681  1.00  0.00           O  
ATOM    728  CB  GLU A  47      18.212  69.850  25.038  1.00  0.00           C  
ATOM    729  CG  GLU A  47      17.001  69.519  25.895  1.00  0.00           C  
ATOM    730  CD  GLU A  47      17.273  69.687  27.378  1.00  0.00           C  
ATOM    731  OE1 GLU A  47      18.131  68.952  27.909  1.00  0.00           O  
ATOM    732  OE2 GLU A  47      16.628  70.551  28.006  1.00  0.00           O  
ATOM    733  H   GLU A  47      18.020  72.396  24.133  1.00  0.00           H  
ATOM    734  HA  GLU A  47      19.008  71.097  26.583  1.00  0.00           H  
ATOM    735  HB2 GLU A  47      17.877  70.005  24.023  1.00  0.00           H  
ATOM    736  HB3 GLU A  47      18.883  69.003  25.060  1.00  0.00           H  
ATOM    737  HG2 GLU A  47      16.190  70.175  25.617  1.00  0.00           H  
ATOM    738  HG3 GLU A  47      16.714  68.495  25.711  1.00  0.00           H  
ATOM    739  N   GLY A  48      20.552  71.422  23.692  1.00  0.00           N  
ATOM    740  CA  GLY A  48      21.866  71.429  23.076  1.00  0.00           C  
ATOM    741  C   GLY A  48      22.050  70.290  22.092  1.00  0.00           C  
ATOM    742  O   GLY A  48      23.175  69.876  21.813  1.00  0.00           O  
ATOM    743  H   GLY A  48      19.766  71.685  23.168  1.00  0.00           H  
ATOM    744  HA2 GLY A  48      22.003  72.365  22.557  1.00  0.00           H  
ATOM    745  HA3 GLY A  48      22.613  71.343  23.851  1.00  0.00           H  
ATOM    746  N   LYS A  49      20.942  69.780  21.565  1.00  0.00           N  
ATOM    747  CA  LYS A  49      20.984  68.683  20.607  1.00  0.00           C  
ATOM    748  C   LYS A  49      20.234  69.045  19.330  1.00  0.00           C  
ATOM    749  O   LYS A  49      19.199  69.711  19.375  1.00  0.00           O  
ATOM    750  CB  LYS A  49      20.385  67.417  21.223  1.00  0.00           C  
ATOM    751  CG  LYS A  49      19.019  67.635  21.852  1.00  0.00           C  
ATOM    752  CD  LYS A  49      18.175  66.373  21.805  1.00  0.00           C  
ATOM    753  CE  LYS A  49      16.689  66.695  21.795  1.00  0.00           C  
ATOM    754  NZ  LYS A  49      15.856  65.472  21.625  1.00  0.00           N  
ATOM    755  H   LYS A  49      20.073  70.152  21.827  1.00  0.00           H  
ATOM    756  HA  LYS A  49      22.020  68.497  20.360  1.00  0.00           H  
ATOM    757  HB2 LYS A  49      20.287  66.667  20.451  1.00  0.00           H  
ATOM    758  HB3 LYS A  49      21.055  67.050  21.986  1.00  0.00           H  
ATOM    759  HG2 LYS A  49      19.151  67.929  22.883  1.00  0.00           H  
ATOM    760  HG3 LYS A  49      18.507  68.420  21.314  1.00  0.00           H  
ATOM    761  HD2 LYS A  49      18.418  65.821  20.908  1.00  0.00           H  
ATOM    762  HD3 LYS A  49      18.399  65.768  22.673  1.00  0.00           H  
ATOM    763  HE2 LYS A  49      16.431  67.170  22.730  1.00  0.00           H  
ATOM    764  HE3 LYS A  49      16.487  67.375  20.980  1.00  0.00           H  
ATOM    765  HZ1 LYS A  49      14.937  65.598  22.095  1.00  0.00           H  
ATOM    766  HZ2 LYS A  49      16.338  64.652  22.044  1.00  0.00           H  
ATOM    767  HZ3 LYS A  49      15.696  65.287  20.614  1.00  0.00           H  
ATOM    768  N   MET A  50      20.759  68.601  18.192  1.00  0.00           N  
ATOM    769  CA  MET A  50      20.135  68.878  16.904  1.00  0.00           C  
ATOM    770  C   MET A  50      19.848  67.583  16.150  1.00  0.00           C  
ATOM    771  O   MET A  50      20.650  66.648  16.174  1.00  0.00           O  
ATOM    772  CB  MET A  50      21.035  69.784  16.062  1.00  0.00           C  
ATOM    773  CG  MET A  50      22.516  69.620  16.364  1.00  0.00           C  
ATOM    774  SD  MET A  50      23.568  70.410  15.131  1.00  0.00           S  
ATOM    775  CE  MET A  50      24.517  69.007  14.548  1.00  0.00           C  
ATOM    776  H   MET A  50      21.585  68.075  18.220  1.00  0.00           H  
ATOM    777  HA  MET A  50      19.201  69.386  17.090  1.00  0.00           H  
ATOM    778  HB2 MET A  50      20.877  69.558  15.017  1.00  0.00           H  
ATOM    779  HB3 MET A  50      20.764  70.813  16.244  1.00  0.00           H  
ATOM    780  HG2 MET A  50      22.723  70.061  17.328  1.00  0.00           H  
ATOM    781  HG3 MET A  50      22.749  68.567  16.396  1.00  0.00           H  
ATOM    782  HE1 MET A  50      23.843  68.234  14.208  1.00  0.00           H  
ATOM    783  HE2 MET A  50      25.152  69.316  13.731  1.00  0.00           H  
ATOM    784  HE3 MET A  50      25.127  68.625  15.354  1.00  0.00           H  
ATOM    785  N   LEU A  51      18.701  67.535  15.482  1.00  0.00           N  
ATOM    786  CA  LEU A  51      18.309  66.354  14.720  1.00  0.00           C  
ATOM    787  C   LEU A  51      18.996  66.330  13.358  1.00  0.00           C  
ATOM    788  O   LEU A  51      18.577  67.019  12.428  1.00  0.00           O  
ATOM    789  CB  LEU A  51      16.790  66.321  14.538  1.00  0.00           C  
ATOM    790  CG  LEU A  51      16.162  64.936  14.380  1.00  0.00           C  
ATOM    791  CD1 LEU A  51      14.759  65.049  13.805  1.00  0.00           C  
ATOM    792  CD2 LEU A  51      17.033  64.054  13.497  1.00  0.00           C  
ATOM    793  H   LEU A  51      18.104  68.311  15.499  1.00  0.00           H  
ATOM    794  HA  LEU A  51      18.615  65.482  15.280  1.00  0.00           H  
ATOM    795  HB2 LEU A  51      16.344  66.790  15.402  1.00  0.00           H  
ATOM    796  HB3 LEU A  51      16.552  66.897  13.656  1.00  0.00           H  
ATOM    797  HG  LEU A  51      16.088  64.468  15.352  1.00  0.00           H  
ATOM    798 HD11 LEU A  51      14.340  64.062  13.681  1.00  0.00           H  
ATOM    799 HD12 LEU A  51      14.801  65.545  12.847  1.00  0.00           H  
ATOM    800 HD13 LEU A  51      14.138  65.621  14.479  1.00  0.00           H  
ATOM    801 HD21 LEU A  51      16.929  64.361  12.467  1.00  0.00           H  
ATOM    802 HD22 LEU A  51      16.722  63.025  13.598  1.00  0.00           H  
ATOM    803 HD23 LEU A  51      18.065  64.150  13.800  1.00  0.00           H  
ATOM    804  N   VAL A  52      20.053  65.531  13.249  1.00  0.00           N  
ATOM    805  CA  VAL A  52      20.796  65.415  12.001  1.00  0.00           C  
ATOM    806  C   VAL A  52      20.463  64.111  11.281  1.00  0.00           C  
ATOM    807  O   VAL A  52      20.329  63.061  11.910  1.00  0.00           O  
ATOM    808  CB  VAL A  52      22.316  65.480  12.243  1.00  0.00           C  
ATOM    809  CG1 VAL A  52      22.750  64.386  13.206  1.00  0.00           C  
ATOM    810  CG2 VAL A  52      23.071  65.374  10.927  1.00  0.00           C  
ATOM    811  H   VAL A  52      20.339  65.007  14.026  1.00  0.00           H  
ATOM    812  HA  VAL A  52      20.518  66.245  11.367  1.00  0.00           H  
ATOM    813  HB  VAL A  52      22.548  66.436  12.691  1.00  0.00           H  
ATOM    814 HG11 VAL A  52      22.152  63.502  13.039  1.00  0.00           H  
ATOM    815 HG12 VAL A  52      23.792  64.154  13.042  1.00  0.00           H  
ATOM    816 HG13 VAL A  52      22.612  64.725  14.222  1.00  0.00           H  
ATOM    817 HG21 VAL A  52      22.457  64.864  10.200  1.00  0.00           H  
ATOM    818 HG22 VAL A  52      23.308  66.365  10.568  1.00  0.00           H  
ATOM    819 HG23 VAL A  52      23.985  64.818  11.080  1.00  0.00           H  
ATOM    820  N   HIS A  53      20.332  64.187   9.961  1.00  0.00           N  
ATOM    821  CA  HIS A  53      20.017  63.013   9.156  1.00  0.00           C  
ATOM    822  C   HIS A  53      21.219  62.589   8.318  1.00  0.00           C  
ATOM    823  O   HIS A  53      21.938  63.429   7.777  1.00  0.00           O  
ATOM    824  CB  HIS A  53      18.822  63.299   8.246  1.00  0.00           C  
ATOM    825  CG  HIS A  53      19.208  63.806   6.891  1.00  0.00           C  
ATOM    826  ND1 HIS A  53      19.990  63.087   6.013  1.00  0.00           N  
ATOM    827  CD2 HIS A  53      18.915  64.971   6.265  1.00  0.00           C  
ATOM    828  CE1 HIS A  53      20.162  63.787   4.905  1.00  0.00           C  
ATOM    829  NE2 HIS A  53      19.519  64.933   5.033  1.00  0.00           N  
ATOM    830  H   HIS A  53      20.452  65.053   9.518  1.00  0.00           H  
ATOM    831  HA  HIS A  53      19.761  62.209   9.829  1.00  0.00           H  
ATOM    832  HB2 HIS A  53      18.256  62.389   8.110  1.00  0.00           H  
ATOM    833  HB3 HIS A  53      18.191  64.042   8.713  1.00  0.00           H  
ATOM    834  HD1 HIS A  53      20.364  62.196   6.177  1.00  0.00           H  
ATOM    835  HD2 HIS A  53      18.316  65.779   6.661  1.00  0.00           H  
ATOM    836  HE1 HIS A  53      20.731  63.474   4.042  1.00  0.00           H  
ATOM    837  N   PHE A  54      21.432  61.282   8.216  1.00  0.00           N  
ATOM    838  CA  PHE A  54      22.548  60.746   7.445  1.00  0.00           C  
ATOM    839  C   PHE A  54      22.085  60.280   6.068  1.00  0.00           C  
ATOM    840  O   PHE A  54      20.959  59.811   5.907  1.00  0.00           O  
ATOM    841  CB  PHE A  54      23.202  59.584   8.195  1.00  0.00           C  
ATOM    842  CG  PHE A  54      23.915  60.005   9.449  1.00  0.00           C  
ATOM    843  CD1 PHE A  54      23.225  60.133  10.644  1.00  0.00           C  
ATOM    844  CD2 PHE A  54      25.274  60.272   9.432  1.00  0.00           C  
ATOM    845  CE1 PHE A  54      23.878  60.521  11.799  1.00  0.00           C  
ATOM    846  CE2 PHE A  54      25.933  60.660  10.584  1.00  0.00           C  
ATOM    847  CZ  PHE A  54      25.234  60.784  11.769  1.00  0.00           C  
ATOM    848  H   PHE A  54      20.823  60.661   8.670  1.00  0.00           H  
ATOM    849  HA  PHE A  54      23.273  61.536   7.320  1.00  0.00           H  
ATOM    850  HB2 PHE A  54      22.442  58.869   8.471  1.00  0.00           H  
ATOM    851  HB3 PHE A  54      23.923  59.107   7.548  1.00  0.00           H  
ATOM    852  HD1 PHE A  54      22.165  59.927  10.668  1.00  0.00           H  
ATOM    853  HD2 PHE A  54      25.822  60.176   8.506  1.00  0.00           H  
ATOM    854  HE1 PHE A  54      23.329  60.617  12.723  1.00  0.00           H  
ATOM    855  HE2 PHE A  54      26.993  60.866  10.558  1.00  0.00           H  
ATOM    856  HZ  PHE A  54      25.746  61.088  12.670  1.00  0.00           H  
ATOM    857  N   GLU A  55      22.962  60.415   5.079  1.00  0.00           N  
ATOM    858  CA  GLU A  55      22.642  60.009   3.715  1.00  0.00           C  
ATOM    859  C   GLU A  55      23.089  58.573   3.455  1.00  0.00           C  
ATOM    860  O   GLU A  55      22.313  57.748   2.973  1.00  0.00           O  
ATOM    861  CB  GLU A  55      23.307  60.952   2.709  1.00  0.00           C  
ATOM    862  CG  GLU A  55      23.367  62.397   3.177  1.00  0.00           C  
ATOM    863  CD  GLU A  55      23.320  63.383   2.027  1.00  0.00           C  
ATOM    864  OE1 GLU A  55      23.011  62.959   0.893  1.00  0.00           O  
ATOM    865  OE2 GLU A  55      23.593  64.580   2.259  1.00  0.00           O  
ATOM    866  H   GLU A  55      23.844  60.795   5.270  1.00  0.00           H  
ATOM    867  HA  GLU A  55      21.571  60.067   3.595  1.00  0.00           H  
ATOM    868  HB2 GLU A  55      24.317  60.611   2.528  1.00  0.00           H  
ATOM    869  HB3 GLU A  55      22.754  60.918   1.782  1.00  0.00           H  
ATOM    870  HG2 GLU A  55      22.527  62.586   3.828  1.00  0.00           H  
ATOM    871  HG3 GLU A  55      24.286  62.547   3.724  1.00  0.00           H  
ATOM    872  N   ARG A  56      24.345  58.283   3.777  1.00  0.00           N  
ATOM    873  CA  ARG A  56      24.897  56.949   3.577  1.00  0.00           C  
ATOM    874  C   ARG A  56      23.831  55.880   3.806  1.00  0.00           C  
ATOM    875  O   ARG A  56      23.392  55.217   2.866  1.00  0.00           O  
ATOM    876  CB  ARG A  56      26.078  56.715   4.522  1.00  0.00           C  
ATOM    877  CG  ARG A  56      27.076  55.691   4.006  1.00  0.00           C  
ATOM    878  CD  ARG A  56      26.679  54.277   4.404  1.00  0.00           C  
ATOM    879  NE  ARG A  56      25.807  53.655   3.412  1.00  0.00           N  
ATOM    880  CZ  ARG A  56      26.249  53.121   2.278  1.00  0.00           C  
ATOM    881  NH1 ARG A  56      27.544  53.134   1.995  1.00  0.00           N  
ATOM    882  NH2 ARG A  56      25.394  52.572   1.424  1.00  0.00           N  
ATOM    883  H   ARG A  56      24.916  58.985   4.157  1.00  0.00           H  
ATOM    884  HA  ARG A  56      25.244  56.882   2.558  1.00  0.00           H  
ATOM    885  HB2 ARG A  56      26.598  57.650   4.666  1.00  0.00           H  
ATOM    886  HB3 ARG A  56      25.700  56.371   5.473  1.00  0.00           H  
ATOM    887  HG2 ARG A  56      27.117  55.752   2.929  1.00  0.00           H  
ATOM    888  HG3 ARG A  56      28.049  55.912   4.419  1.00  0.00           H  
ATOM    889  HD2 ARG A  56      27.574  53.683   4.508  1.00  0.00           H  
ATOM    890  HD3 ARG A  56      26.161  54.317   5.351  1.00  0.00           H  
ATOM    891  HE  ARG A  56      24.847  53.633   3.601  1.00  0.00           H  
ATOM    892 HH11 ARG A  56      28.191  53.548   2.637  1.00  0.00           H  
ATOM    893 HH12 ARG A  56      27.873  52.731   1.141  1.00  0.00           H  
ATOM    894 HH21 ARG A  56      24.416  52.559   1.635  1.00  0.00           H  
ATOM    895 HH22 ARG A  56      25.726  52.171   0.572  1.00  0.00           H  
ATOM    896  N   TRP A  57      23.419  55.720   5.058  1.00  0.00           N  
ATOM    897  CA  TRP A  57      22.406  54.732   5.409  1.00  0.00           C  
ATOM    898  C   TRP A  57      21.199  54.838   4.483  1.00  0.00           C  
ATOM    899  O   TRP A  57      20.348  55.711   4.653  1.00  0.00           O  
ATOM    900  CB  TRP A  57      21.967  54.916   6.862  1.00  0.00           C  
ATOM    901  CG  TRP A  57      22.940  54.352   7.853  1.00  0.00           C  
ATOM    902  CD1 TRP A  57      22.963  53.079   8.345  1.00  0.00           C  
ATOM    903  CD2 TRP A  57      24.029  55.044   8.473  1.00  0.00           C  
ATOM    904  NE1 TRP A  57      24.001  52.937   9.234  1.00  0.00           N  
ATOM    905  CE2 TRP A  57      24.671  54.129   9.329  1.00  0.00           C  
ATOM    906  CE3 TRP A  57      24.526  56.348   8.387  1.00  0.00           C  
ATOM    907  CZ2 TRP A  57      25.782  54.477  10.093  1.00  0.00           C  
ATOM    908  CZ3 TRP A  57      25.628  56.691   9.145  1.00  0.00           C  
ATOM    909  CH2 TRP A  57      26.247  55.760   9.989  1.00  0.00           C  
ATOM    910  H   TRP A  57      23.807  56.279   5.764  1.00  0.00           H  
ATOM    911  HA  TRP A  57      22.846  53.752   5.297  1.00  0.00           H  
ATOM    912  HB2 TRP A  57      21.855  55.971   7.067  1.00  0.00           H  
ATOM    913  HB3 TRP A  57      21.016  54.422   7.009  1.00  0.00           H  
ATOM    914  HD1 TRP A  57      22.261  52.307   8.068  1.00  0.00           H  
ATOM    915  HE1 TRP A  57      24.226  52.115   9.719  1.00  0.00           H  
ATOM    916  HE3 TRP A  57      24.063  57.081   7.742  1.00  0.00           H  
ATOM    917  HZ2 TRP A  57      26.270  53.769  10.747  1.00  0.00           H  
ATOM    918  HZ3 TRP A  57      26.026  57.695   9.093  1.00  0.00           H  
ATOM    919  HH2 TRP A  57      27.105  56.072  10.563  1.00  0.00           H  
ATOM    920  N   SER A  58      21.132  53.943   3.501  1.00  0.00           N  
ATOM    921  CA  SER A  58      20.030  53.940   2.546  1.00  0.00           C  
ATOM    922  C   SER A  58      18.729  54.371   3.215  1.00  0.00           C  
ATOM    923  O   SER A  58      18.159  55.410   2.880  1.00  0.00           O  
ATOM    924  CB  SER A  58      19.865  52.547   1.933  1.00  0.00           C  
ATOM    925  OG  SER A  58      20.870  52.293   0.968  1.00  0.00           O  
ATOM    926  H   SER A  58      21.841  53.273   3.418  1.00  0.00           H  
ATOM    927  HA  SER A  58      20.269  54.643   1.762  1.00  0.00           H  
ATOM    928  HB2 SER A  58      19.933  51.803   2.711  1.00  0.00           H  
ATOM    929  HB3 SER A  58      18.898  52.481   1.455  1.00  0.00           H  
ATOM    930  HG  SER A  58      20.474  52.253   0.094  1.00  0.00           H  
ATOM    931  N   HIS A  59      18.263  53.564   4.164  1.00  0.00           N  
ATOM    932  CA  HIS A  59      17.028  53.862   4.882  1.00  0.00           C  
ATOM    933  C   HIS A  59      17.165  55.152   5.684  1.00  0.00           C  
ATOM    934  O   HIS A  59      17.973  55.238   6.608  1.00  0.00           O  
ATOM    935  CB  HIS A  59      16.664  52.705   5.813  1.00  0.00           C  
ATOM    936  CG  HIS A  59      15.492  52.996   6.699  1.00  0.00           C  
ATOM    937  ND1 HIS A  59      15.563  53.839   7.787  1.00  0.00           N  
ATOM    938  CD2 HIS A  59      14.215  52.552   6.652  1.00  0.00           C  
ATOM    939  CE1 HIS A  59      14.381  53.900   8.373  1.00  0.00           C  
ATOM    940  NE2 HIS A  59      13.544  53.128   7.703  1.00  0.00           N  
ATOM    941  H   HIS A  59      18.761  52.750   4.386  1.00  0.00           H  
ATOM    942  HA  HIS A  59      16.243  53.987   4.153  1.00  0.00           H  
ATOM    943  HB2 HIS A  59      16.421  51.836   5.219  1.00  0.00           H  
ATOM    944  HB3 HIS A  59      17.511  52.479   6.445  1.00  0.00           H  
ATOM    945  HD1 HIS A  59      16.363  54.320   8.088  1.00  0.00           H  
ATOM    946  HD2 HIS A  59      13.798  51.870   5.924  1.00  0.00           H  
ATOM    947  HE1 HIS A  59      14.138  54.482   9.250  1.00  0.00           H  
ATOM    948  N   ARG A  60      16.368  56.153   5.324  1.00  0.00           N  
ATOM    949  CA  ARG A  60      16.401  57.440   6.009  1.00  0.00           C  
ATOM    950  C   ARG A  60      16.695  57.257   7.495  1.00  0.00           C  
ATOM    951  O   ARG A  60      15.786  57.025   8.293  1.00  0.00           O  
ATOM    952  CB  ARG A  60      15.070  58.173   5.826  1.00  0.00           C  
ATOM    953  CG  ARG A  60      13.854  57.306   6.106  1.00  0.00           C  
ATOM    954  CD  ARG A  60      13.383  56.587   4.852  1.00  0.00           C  
ATOM    955  NE  ARG A  60      11.942  56.347   4.868  1.00  0.00           N  
ATOM    956  CZ  ARG A  60      11.320  55.551   4.006  1.00  0.00           C  
ATOM    957  NH1 ARG A  60      12.009  54.921   3.063  1.00  0.00           N  
ATOM    958  NH2 ARG A  60      10.006  55.382   4.084  1.00  0.00           N  
ATOM    959  H   ARG A  60      15.744  56.025   4.579  1.00  0.00           H  
ATOM    960  HA  ARG A  60      17.190  58.031   5.569  1.00  0.00           H  
ATOM    961  HB2 ARG A  60      15.044  59.019   6.498  1.00  0.00           H  
ATOM    962  HB3 ARG A  60      15.006  58.529   4.809  1.00  0.00           H  
ATOM    963  HG2 ARG A  60      14.112  56.570   6.854  1.00  0.00           H  
ATOM    964  HG3 ARG A  60      13.055  57.932   6.475  1.00  0.00           H  
ATOM    965  HD2 ARG A  60      13.626  57.193   3.993  1.00  0.00           H  
ATOM    966  HD3 ARG A  60      13.896  55.640   4.783  1.00  0.00           H  
ATOM    967  HE  ARG A  60      11.414  56.801   5.556  1.00  0.00           H  
ATOM    968 HH11 ARG A  60      12.999  55.046   3.001  1.00  0.00           H  
ATOM    969 HH12 ARG A  60      11.539  54.322   2.415  1.00  0.00           H  
ATOM    970 HH21 ARG A  60       9.484  55.855   4.793  1.00  0.00           H  
ATOM    971 HH22 ARG A  60       9.539  54.783   3.434  1.00  0.00           H  
ATOM    972  N   TYR A  61      17.967  57.365   7.859  1.00  0.00           N  
ATOM    973  CA  TYR A  61      18.381  57.207   9.248  1.00  0.00           C  
ATOM    974  C   TYR A  61      18.790  58.549   9.849  1.00  0.00           C  
ATOM    975  O   TYR A  61      19.810  59.125   9.471  1.00  0.00           O  
ATOM    976  CB  TYR A  61      19.540  56.216   9.349  1.00  0.00           C  
ATOM    977  CG  TYR A  61      20.429  56.443  10.551  1.00  0.00           C  
ATOM    978  CD1 TYR A  61      19.974  56.176  11.836  1.00  0.00           C  
ATOM    979  CD2 TYR A  61      21.724  56.926  10.401  1.00  0.00           C  
ATOM    980  CE1 TYR A  61      20.782  56.382  12.938  1.00  0.00           C  
ATOM    981  CE2 TYR A  61      22.539  57.134  11.497  1.00  0.00           C  
ATOM    982  CZ  TYR A  61      22.064  56.861  12.763  1.00  0.00           C  
ATOM    983  OH  TYR A  61      22.872  57.069  13.857  1.00  0.00           O  
ATOM    984  H   TYR A  61      18.646  57.551   7.177  1.00  0.00           H  
ATOM    985  HA  TYR A  61      17.539  56.819   9.804  1.00  0.00           H  
ATOM    986  HB2 TYR A  61      19.144  55.215   9.414  1.00  0.00           H  
ATOM    987  HB3 TYR A  61      20.153  56.298   8.462  1.00  0.00           H  
ATOM    988  HD1 TYR A  61      18.969  55.800  11.970  1.00  0.00           H  
ATOM    989  HD2 TYR A  61      22.092  57.140   9.409  1.00  0.00           H  
ATOM    990  HE1 TYR A  61      20.411  56.168  13.929  1.00  0.00           H  
ATOM    991  HE2 TYR A  61      23.543  57.509  11.360  1.00  0.00           H  
ATOM    992  HH  TYR A  61      22.696  56.395  14.518  1.00  0.00           H  
ATOM    993  N   ASP A  62      17.988  59.039  10.787  1.00  0.00           N  
ATOM    994  CA  ASP A  62      18.266  60.311  11.443  1.00  0.00           C  
ATOM    995  C   ASP A  62      18.480  60.116  12.940  1.00  0.00           C  
ATOM    996  O   ASP A  62      17.863  59.247  13.556  1.00  0.00           O  
ATOM    997  CB  ASP A  62      17.119  61.295  11.204  1.00  0.00           C  
ATOM    998  CG  ASP A  62      15.759  60.665  11.433  1.00  0.00           C  
ATOM    999  OD1 ASP A  62      15.638  59.834  12.359  1.00  0.00           O  
ATOM   1000  OD2 ASP A  62      14.815  61.003  10.690  1.00  0.00           O  
ATOM   1001  H   ASP A  62      17.189  58.533  11.046  1.00  0.00           H  
ATOM   1002  HA  ASP A  62      19.170  60.716  11.013  1.00  0.00           H  
ATOM   1003  HB2 ASP A  62      17.224  62.132  11.878  1.00  0.00           H  
ATOM   1004  HB3 ASP A  62      17.164  61.649  10.184  1.00  0.00           H  
ATOM   1005  N   GLU A  63      19.360  60.928  13.519  1.00  0.00           N  
ATOM   1006  CA  GLU A  63      19.656  60.842  14.944  1.00  0.00           C  
ATOM   1007  C   GLU A  63      20.155  62.182  15.478  1.00  0.00           C  
ATOM   1008  O   GLU A  63      20.948  62.863  14.830  1.00  0.00           O  
ATOM   1009  CB  GLU A  63      20.701  59.756  15.205  1.00  0.00           C  
ATOM   1010  CG  GLU A  63      21.410  59.901  16.542  1.00  0.00           C  
ATOM   1011  CD  GLU A  63      22.170  58.651  16.938  1.00  0.00           C  
ATOM   1012  OE1 GLU A  63      21.518  57.631  17.245  1.00  0.00           O  
ATOM   1013  OE2 GLU A  63      23.419  58.692  16.940  1.00  0.00           O  
ATOM   1014  H   GLU A  63      19.820  61.600  12.974  1.00  0.00           H  
ATOM   1015  HA  GLU A  63      18.743  60.580  15.458  1.00  0.00           H  
ATOM   1016  HB2 GLU A  63      20.215  58.791  15.182  1.00  0.00           H  
ATOM   1017  HB3 GLU A  63      21.444  59.793  14.423  1.00  0.00           H  
ATOM   1018  HG2 GLU A  63      22.107  60.723  16.478  1.00  0.00           H  
ATOM   1019  HG3 GLU A  63      20.674  60.113  17.303  1.00  0.00           H  
ATOM   1020  N   TRP A  64      19.682  62.552  16.664  1.00  0.00           N  
ATOM   1021  CA  TRP A  64      20.079  63.810  17.285  1.00  0.00           C  
ATOM   1022  C   TRP A  64      21.538  63.763  17.725  1.00  0.00           C  
ATOM   1023  O   TRP A  64      21.948  62.855  18.448  1.00  0.00           O  
ATOM   1024  CB  TRP A  64      19.181  64.115  18.485  1.00  0.00           C  
ATOM   1025  CG  TRP A  64      17.762  64.415  18.105  1.00  0.00           C  
ATOM   1026  CD1 TRP A  64      16.775  63.509  17.845  1.00  0.00           C  
ATOM   1027  CD2 TRP A  64      17.176  65.710  17.938  1.00  0.00           C  
ATOM   1028  NE1 TRP A  64      15.608  64.162  17.528  1.00  0.00           N  
ATOM   1029  CE2 TRP A  64      15.827  65.514  17.579  1.00  0.00           C  
ATOM   1030  CE3 TRP A  64      17.655  67.016  18.061  1.00  0.00           C  
ATOM   1031  CZ2 TRP A  64      14.958  66.574  17.340  1.00  0.00           C  
ATOM   1032  CZ3 TRP A  64      16.792  68.069  17.823  1.00  0.00           C  
ATOM   1033  CH2 TRP A  64      15.456  67.844  17.467  1.00  0.00           C  
ATOM   1034  H   TRP A  64      19.052  61.965  17.131  1.00  0.00           H  
ATOM   1035  HA  TRP A  64      19.961  64.593  16.550  1.00  0.00           H  
ATOM   1036  HB2 TRP A  64      19.175  63.263  19.149  1.00  0.00           H  
ATOM   1037  HB3 TRP A  64      19.574  64.973  19.010  1.00  0.00           H  
ATOM   1038  HD1 TRP A  64      16.906  62.438  17.885  1.00  0.00           H  
ATOM   1039  HE1 TRP A  64      14.757  63.730  17.303  1.00  0.00           H  
ATOM   1040  HE3 TRP A  64      18.682  67.211  18.334  1.00  0.00           H  
ATOM   1041  HZ2 TRP A  64      13.925  66.418  17.066  1.00  0.00           H  
ATOM   1042  HZ3 TRP A  64      17.146  69.085  17.913  1.00  0.00           H  
ATOM   1043  HH2 TRP A  64      14.817  68.695  17.291  1.00  0.00           H  
ATOM   1044  N   ILE A  65      22.315  64.747  17.285  1.00  0.00           N  
ATOM   1045  CA  ILE A  65      23.728  64.817  17.635  1.00  0.00           C  
ATOM   1046  C   ILE A  65      24.073  66.165  18.260  1.00  0.00           C  
ATOM   1047  O   ILE A  65      23.966  67.206  17.612  1.00  0.00           O  
ATOM   1048  CB  ILE A  65      24.626  64.589  16.405  1.00  0.00           C  
ATOM   1049  CG1 ILE A  65      24.339  63.221  15.783  1.00  0.00           C  
ATOM   1050  CG2 ILE A  65      26.093  64.705  16.790  1.00  0.00           C  
ATOM   1051  CD1 ILE A  65      25.184  62.921  14.565  1.00  0.00           C  
ATOM   1052  H   ILE A  65      21.930  65.441  16.711  1.00  0.00           H  
ATOM   1053  HA  ILE A  65      23.933  64.037  18.354  1.00  0.00           H  
ATOM   1054  HB  ILE A  65      24.408  65.359  15.680  1.00  0.00           H  
ATOM   1055 HG12 ILE A  65      24.530  62.453  16.516  1.00  0.00           H  
ATOM   1056 HG13 ILE A  65      23.301  63.180  15.486  1.00  0.00           H  
ATOM   1057 HG21 ILE A  65      26.247  65.615  17.352  1.00  0.00           H  
ATOM   1058 HG22 ILE A  65      26.373  63.857  17.396  1.00  0.00           H  
ATOM   1059 HG23 ILE A  65      26.700  64.726  15.897  1.00  0.00           H  
ATOM   1060 HD11 ILE A  65      26.073  62.385  14.867  1.00  0.00           H  
ATOM   1061 HD12 ILE A  65      24.618  62.316  13.873  1.00  0.00           H  
ATOM   1062 HD13 ILE A  65      25.468  63.847  14.087  1.00  0.00           H  
ATOM   1063  N   TYR A  66      24.490  66.138  19.521  1.00  0.00           N  
ATOM   1064  CA  TYR A  66      24.851  67.357  20.233  1.00  0.00           C  
ATOM   1065  C   TYR A  66      25.704  68.269  19.356  1.00  0.00           C  
ATOM   1066  O   TYR A  66      26.800  67.897  18.937  1.00  0.00           O  
ATOM   1067  CB  TYR A  66      25.604  67.018  21.520  1.00  0.00           C  
ATOM   1068  CG  TYR A  66      24.750  66.323  22.556  1.00  0.00           C  
ATOM   1069  CD1 TYR A  66      23.494  66.814  22.892  1.00  0.00           C  
ATOM   1070  CD2 TYR A  66      25.199  65.177  23.201  1.00  0.00           C  
ATOM   1071  CE1 TYR A  66      22.711  66.183  23.839  1.00  0.00           C  
ATOM   1072  CE2 TYR A  66      24.422  64.539  24.148  1.00  0.00           C  
ATOM   1073  CZ  TYR A  66      23.178  65.046  24.464  1.00  0.00           C  
ATOM   1074  OH  TYR A  66      22.402  64.414  25.408  1.00  0.00           O  
ATOM   1075  H   TYR A  66      24.555  65.276  19.984  1.00  0.00           H  
ATOM   1076  HA  TYR A  66      23.938  67.875  20.489  1.00  0.00           H  
ATOM   1077  HB2 TYR A  66      26.432  66.367  21.283  1.00  0.00           H  
ATOM   1078  HB3 TYR A  66      25.984  67.929  21.958  1.00  0.00           H  
ATOM   1079  HD1 TYR A  66      23.130  67.705  22.401  1.00  0.00           H  
ATOM   1080  HD2 TYR A  66      26.174  64.782  22.951  1.00  0.00           H  
ATOM   1081  HE1 TYR A  66      21.736  66.579  24.086  1.00  0.00           H  
ATOM   1082  HE2 TYR A  66      24.788  63.649  24.638  1.00  0.00           H  
ATOM   1083  HH  TYR A  66      21.818  63.787  24.974  1.00  0.00           H  
ATOM   1084  N   TRP A  67      25.194  69.465  19.084  1.00  0.00           N  
ATOM   1085  CA  TRP A  67      25.908  70.430  18.258  1.00  0.00           C  
ATOM   1086  C   TRP A  67      27.236  70.817  18.899  1.00  0.00           C  
ATOM   1087  O   TRP A  67      28.054  71.505  18.286  1.00  0.00           O  
ATOM   1088  CB  TRP A  67      25.051  71.678  18.038  1.00  0.00           C  
ATOM   1089  CG  TRP A  67      24.567  72.298  19.314  1.00  0.00           C  
ATOM   1090  CD1 TRP A  67      24.696  71.787  20.574  1.00  0.00           C  
ATOM   1091  CD2 TRP A  67      23.874  73.542  19.452  1.00  0.00           C  
ATOM   1092  NE1 TRP A  67      24.126  72.640  21.488  1.00  0.00           N  
ATOM   1093  CE2 TRP A  67      23.615  73.725  20.826  1.00  0.00           C  
ATOM   1094  CE3 TRP A  67      23.449  74.522  18.552  1.00  0.00           C  
ATOM   1095  CZ2 TRP A  67      22.950  74.846  21.314  1.00  0.00           C  
ATOM   1096  CZ3 TRP A  67      22.788  75.635  19.039  1.00  0.00           C  
ATOM   1097  CH2 TRP A  67      22.544  75.789  20.410  1.00  0.00           C  
ATOM   1098  H   TRP A  67      24.315  69.703  19.447  1.00  0.00           H  
ATOM   1099  HA  TRP A  67      26.104  69.966  17.302  1.00  0.00           H  
ATOM   1100  HB2 TRP A  67      25.632  72.417  17.508  1.00  0.00           H  
ATOM   1101  HB3 TRP A  67      24.186  71.412  17.448  1.00  0.00           H  
ATOM   1102  HD1 TRP A  67      25.178  70.849  20.803  1.00  0.00           H  
ATOM   1103  HE1 TRP A  67      24.093  72.496  22.457  1.00  0.00           H  
ATOM   1104  HE3 TRP A  67      23.626  74.422  17.491  1.00  0.00           H  
ATOM   1105  HZ2 TRP A  67      22.755  74.980  22.369  1.00  0.00           H  
ATOM   1106  HZ3 TRP A  67      22.451  76.401  18.357  1.00  0.00           H  
ATOM   1107  HH2 TRP A  67      22.025  76.673  20.745  1.00  0.00           H  
ATOM   1108  N   ASP A  68      27.445  70.371  20.132  1.00  0.00           N  
ATOM   1109  CA  ASP A  68      28.676  70.670  20.855  1.00  0.00           C  
ATOM   1110  C   ASP A  68      29.552  69.429  20.973  1.00  0.00           C  
ATOM   1111  O   ASP A  68      30.426  69.352  21.837  1.00  0.00           O  
ATOM   1112  CB  ASP A  68      28.354  71.217  22.247  1.00  0.00           C  
ATOM   1113  CG  ASP A  68      29.600  71.433  23.085  1.00  0.00           C  
ATOM   1114  OD1 ASP A  68      30.593  71.967  22.547  1.00  0.00           O  
ATOM   1115  OD2 ASP A  68      29.580  71.071  24.280  1.00  0.00           O  
ATOM   1116  H   ASP A  68      26.755  69.827  20.567  1.00  0.00           H  
ATOM   1117  HA  ASP A  68      29.213  71.424  20.299  1.00  0.00           H  
ATOM   1118  HB2 ASP A  68      27.842  72.163  22.147  1.00  0.00           H  
ATOM   1119  HB3 ASP A  68      27.713  70.517  22.762  1.00  0.00           H  
ATOM   1120  N   SER A  69      29.313  68.457  20.099  1.00  0.00           N  
ATOM   1121  CA  SER A  69      30.078  67.215  20.107  1.00  0.00           C  
ATOM   1122  C   SER A  69      31.428  67.403  19.420  1.00  0.00           C  
ATOM   1123  O   SER A  69      32.403  66.729  19.749  1.00  0.00           O  
ATOM   1124  CB  SER A  69      29.291  66.102  19.414  1.00  0.00           C  
ATOM   1125  OG  SER A  69      29.645  64.830  19.929  1.00  0.00           O  
ATOM   1126  H   SER A  69      28.604  68.577  19.434  1.00  0.00           H  
ATOM   1127  HA  SER A  69      30.247  66.937  21.137  1.00  0.00           H  
ATOM   1128  HB2 SER A  69      28.235  66.259  19.571  1.00  0.00           H  
ATOM   1129  HB3 SER A  69      29.504  66.120  18.354  1.00  0.00           H  
ATOM   1130  HG  SER A  69      29.217  64.698  20.778  1.00  0.00           H  
ATOM   1131  N   ASN A  70      31.474  68.325  18.464  1.00  0.00           N  
ATOM   1132  CA  ASN A  70      32.702  68.602  17.728  1.00  0.00           C  
ATOM   1133  C   ASN A  70      33.085  67.421  16.842  1.00  0.00           C  
ATOM   1134  O   ASN A  70      34.265  67.164  16.607  1.00  0.00           O  
ATOM   1135  CB  ASN A  70      33.843  68.915  18.700  1.00  0.00           C  
ATOM   1136  CG  ASN A  70      33.458  69.964  19.724  1.00  0.00           C  
ATOM   1137  OD1 ASN A  70      33.011  71.056  19.372  1.00  0.00           O  
ATOM   1138  ND2 ASN A  70      33.632  69.639  20.999  1.00  0.00           N  
ATOM   1139  H   ASN A  70      30.662  68.830  18.246  1.00  0.00           H  
ATOM   1140  HA  ASN A  70      32.527  69.465  17.104  1.00  0.00           H  
ATOM   1141  HB2 ASN A  70      34.118  68.011  19.226  1.00  0.00           H  
ATOM   1142  HB3 ASN A  70      34.694  69.276  18.142  1.00  0.00           H  
ATOM   1143 HD21 ASN A  70      33.994  68.752  21.206  1.00  0.00           H  
ATOM   1144 HD22 ASN A  70      33.392  70.299  21.682  1.00  0.00           H  
ATOM   1145  N   ARG A  71      32.077  66.706  16.351  1.00  0.00           N  
ATOM   1146  CA  ARG A  71      32.307  65.552  15.490  1.00  0.00           C  
ATOM   1147  C   ARG A  71      31.789  65.815  14.079  1.00  0.00           C  
ATOM   1148  O   ARG A  71      31.555  64.882  13.308  1.00  0.00           O  
ATOM   1149  CB  ARG A  71      31.626  64.312  16.072  1.00  0.00           C  
ATOM   1150  CG  ARG A  71      32.025  64.016  17.509  1.00  0.00           C  
ATOM   1151  CD  ARG A  71      31.064  63.035  18.162  1.00  0.00           C  
ATOM   1152  NE  ARG A  71      31.432  62.749  19.547  1.00  0.00           N  
ATOM   1153  CZ  ARG A  71      31.027  61.669  20.206  1.00  0.00           C  
ATOM   1154  NH1 ARG A  71      30.246  60.778  19.611  1.00  0.00           N  
ATOM   1155  NH2 ARG A  71      31.404  61.479  21.464  1.00  0.00           N  
ATOM   1156  H   ARG A  71      31.157  66.960  16.573  1.00  0.00           H  
ATOM   1157  HA  ARG A  71      33.372  65.380  15.444  1.00  0.00           H  
ATOM   1158  HB2 ARG A  71      30.556  64.454  16.041  1.00  0.00           H  
ATOM   1159  HB3 ARG A  71      31.885  63.456  15.466  1.00  0.00           H  
ATOM   1160  HG2 ARG A  71      33.018  63.591  17.517  1.00  0.00           H  
ATOM   1161  HG3 ARG A  71      32.021  64.938  18.071  1.00  0.00           H  
ATOM   1162  HD2 ARG A  71      30.071  63.457  18.144  1.00  0.00           H  
ATOM   1163  HD3 ARG A  71      31.075  62.113  17.599  1.00  0.00           H  
ATOM   1164  HE  ARG A  71      32.008  63.394  20.005  1.00  0.00           H  
ATOM   1165 HH11 ARG A  71      29.961  60.919  18.663  1.00  0.00           H  
ATOM   1166 HH12 ARG A  71      29.944  59.966  20.110  1.00  0.00           H  
ATOM   1167 HH21 ARG A  71      31.992  62.148  21.917  1.00  0.00           H  
ATOM   1168 HH22 ARG A  71      31.098  60.666  21.960  1.00  0.00           H  
ATOM   1169  N   LEU A  72      31.613  67.089  13.747  1.00  0.00           N  
ATOM   1170  CA  LEU A  72      31.121  67.474  12.429  1.00  0.00           C  
ATOM   1171  C   LEU A  72      32.143  68.342  11.700  1.00  0.00           C  
ATOM   1172  O   LEU A  72      32.886  69.101  12.325  1.00  0.00           O  
ATOM   1173  CB  LEU A  72      29.795  68.226  12.556  1.00  0.00           C  
ATOM   1174  CG  LEU A  72      28.821  67.695  13.608  1.00  0.00           C  
ATOM   1175  CD1 LEU A  72      27.968  68.823  14.164  1.00  0.00           C  
ATOM   1176  CD2 LEU A  72      27.944  66.599  13.019  1.00  0.00           C  
ATOM   1177  H   LEU A  72      31.816  67.787  14.403  1.00  0.00           H  
ATOM   1178  HA  LEU A  72      30.962  66.572  11.857  1.00  0.00           H  
ATOM   1179  HB2 LEU A  72      30.019  69.253  12.801  1.00  0.00           H  
ATOM   1180  HB3 LEU A  72      29.300  68.185  11.596  1.00  0.00           H  
ATOM   1181  HG  LEU A  72      29.384  67.268  14.428  1.00  0.00           H  
ATOM   1182 HD11 LEU A  72      28.060  69.691  13.528  1.00  0.00           H  
ATOM   1183 HD12 LEU A  72      28.301  69.071  15.160  1.00  0.00           H  
ATOM   1184 HD13 LEU A  72      26.933  68.510  14.198  1.00  0.00           H  
ATOM   1185 HD21 LEU A  72      27.968  65.733  13.663  1.00  0.00           H  
ATOM   1186 HD22 LEU A  72      28.313  66.331  12.041  1.00  0.00           H  
ATOM   1187 HD23 LEU A  72      26.928  66.958  12.935  1.00  0.00           H  
ATOM   1188  N   ARG A  73      32.173  68.229  10.376  1.00  0.00           N  
ATOM   1189  CA  ARG A  73      33.101  69.004   9.563  1.00  0.00           C  
ATOM   1190  C   ARG A  73      32.354  69.813   8.507  1.00  0.00           C  
ATOM   1191  O   ARG A  73      31.260  69.453   8.073  1.00  0.00           O  
ATOM   1192  CB  ARG A  73      34.117  68.079   8.890  1.00  0.00           C  
ATOM   1193  CG  ARG A  73      33.481  67.002   8.027  1.00  0.00           C  
ATOM   1194  CD  ARG A  73      34.511  65.989   7.552  1.00  0.00           C  
ATOM   1195  NE  ARG A  73      35.278  66.480   6.411  1.00  0.00           N  
ATOM   1196  CZ  ARG A  73      36.354  67.250   6.525  1.00  0.00           C  
ATOM   1197  NH1 ARG A  73      36.790  67.613   7.724  1.00  0.00           N  
ATOM   1198  NH2 ARG A  73      36.998  67.658   5.439  1.00  0.00           N  
ATOM   1199  H   ARG A  73      31.556  67.608   9.936  1.00  0.00           H  
ATOM   1200  HA  ARG A  73      33.626  69.685  10.216  1.00  0.00           H  
ATOM   1201  HB2 ARG A  73      34.768  68.673   8.265  1.00  0.00           H  
ATOM   1202  HB3 ARG A  73      34.707  67.596   9.654  1.00  0.00           H  
ATOM   1203  HG2 ARG A  73      32.727  66.489   8.606  1.00  0.00           H  
ATOM   1204  HG3 ARG A  73      33.023  67.467   7.167  1.00  0.00           H  
ATOM   1205  HD2 ARG A  73      35.190  65.778   8.365  1.00  0.00           H  
ATOM   1206  HD3 ARG A  73      33.999  65.082   7.267  1.00  0.00           H  
ATOM   1207  HE  ARG A  73      34.974  66.224   5.516  1.00  0.00           H  
ATOM   1208 HH11 ARG A  73      36.306  67.307   8.544  1.00  0.00           H  
ATOM   1209 HH12 ARG A  73      37.601  68.192   7.808  1.00  0.00           H  
ATOM   1210 HH21 ARG A  73      36.673  67.386   4.534  1.00  0.00           H  
ATOM   1211 HH22 ARG A  73      37.808  68.238   5.527  1.00  0.00           H  
ATOM   1212  N   PRO A  74      32.959  70.931   8.081  1.00  0.00           N  
ATOM   1213  CA  PRO A  74      32.369  71.814   7.070  1.00  0.00           C  
ATOM   1214  C   PRO A  74      32.354  71.179   5.684  1.00  0.00           C  
ATOM   1215  O   PRO A  74      33.354  71.205   4.966  1.00  0.00           O  
ATOM   1216  CB  PRO A  74      33.289  73.037   7.087  1.00  0.00           C  
ATOM   1217  CG  PRO A  74      34.596  72.522   7.584  1.00  0.00           C  
ATOM   1218  CD  PRO A  74      34.265  71.421   8.554  1.00  0.00           C  
ATOM   1219  HA  PRO A  74      31.367  72.112   7.340  1.00  0.00           H  
ATOM   1220  HB2 PRO A  74      33.377  73.440   6.088  1.00  0.00           H  
ATOM   1221  HB3 PRO A  74      32.884  73.788   7.749  1.00  0.00           H  
ATOM   1222  HG2 PRO A  74      35.175  72.134   6.760  1.00  0.00           H  
ATOM   1223  HG3 PRO A  74      35.135  73.312   8.085  1.00  0.00           H  
ATOM   1224  HD2 PRO A  74      35.009  70.641   8.507  1.00  0.00           H  
ATOM   1225  HD3 PRO A  74      34.188  71.813   9.558  1.00  0.00           H  
ATOM   1226  N   LEU A  75      31.213  70.609   5.312  1.00  0.00           N  
ATOM   1227  CA  LEU A  75      31.066  69.967   4.011  1.00  0.00           C  
ATOM   1228  C   LEU A  75      31.367  70.949   2.882  1.00  0.00           C  
ATOM   1229  O   LEU A  75      31.181  72.156   3.032  1.00  0.00           O  
ATOM   1230  CB  LEU A  75      29.651  69.408   3.852  1.00  0.00           C  
ATOM   1231  CG  LEU A  75      29.282  68.902   2.458  1.00  0.00           C  
ATOM   1232  CD1 LEU A  75      29.769  67.474   2.261  1.00  0.00           C  
ATOM   1233  CD2 LEU A  75      27.778  68.989   2.239  1.00  0.00           C  
ATOM   1234  H   LEU A  75      30.450  70.620   5.927  1.00  0.00           H  
ATOM   1235  HA  LEU A  75      31.774  69.154   3.962  1.00  0.00           H  
ATOM   1236  HB2 LEU A  75      29.542  68.585   4.542  1.00  0.00           H  
ATOM   1237  HB3 LEU A  75      28.955  70.191   4.117  1.00  0.00           H  
ATOM   1238  HG  LEU A  75      29.765  69.523   1.716  1.00  0.00           H  
ATOM   1239 HD11 LEU A  75      29.190  67.001   1.484  1.00  0.00           H  
ATOM   1240 HD12 LEU A  75      29.651  66.924   3.183  1.00  0.00           H  
ATOM   1241 HD13 LEU A  75      30.811  67.485   1.979  1.00  0.00           H  
ATOM   1242 HD21 LEU A  75      27.395  69.875   2.723  1.00  0.00           H  
ATOM   1243 HD22 LEU A  75      27.303  68.115   2.659  1.00  0.00           H  
ATOM   1244 HD23 LEU A  75      27.571  69.038   1.180  1.00  0.00           H  
ATOM   1245  N   GLU A  76      31.830  70.421   1.754  1.00  0.00           N  
ATOM   1246  CA  GLU A  76      32.155  71.252   0.600  1.00  0.00           C  
ATOM   1247  C   GLU A  76      31.086  72.320   0.381  1.00  0.00           C  
ATOM   1248  O   GLU A  76      29.896  72.015   0.299  1.00  0.00           O  
ATOM   1249  CB  GLU A  76      32.293  70.387  -0.656  1.00  0.00           C  
ATOM   1250  CG  GLU A  76      33.538  69.517  -0.661  1.00  0.00           C  
ATOM   1251  CD  GLU A  76      34.815  70.324  -0.529  1.00  0.00           C  
ATOM   1252  OE1 GLU A  76      35.177  71.022  -1.499  1.00  0.00           O  
ATOM   1253  OE2 GLU A  76      35.451  70.257   0.542  1.00  0.00           O  
ATOM   1254  H   GLU A  76      31.957  69.451   1.696  1.00  0.00           H  
ATOM   1255  HA  GLU A  76      33.098  71.739   0.797  1.00  0.00           H  
ATOM   1256  HB2 GLU A  76      31.429  69.745  -0.733  1.00  0.00           H  
ATOM   1257  HB3 GLU A  76      32.327  71.034  -1.520  1.00  0.00           H  
ATOM   1258  HG2 GLU A  76      33.481  68.825   0.166  1.00  0.00           H  
ATOM   1259  HG3 GLU A  76      33.571  68.965  -1.589  1.00  0.00           H  
ATOM   1260  N   ARG A  77      31.520  73.571   0.288  1.00  0.00           N  
ATOM   1261  CA  ARG A  77      30.603  74.685   0.080  1.00  0.00           C  
ATOM   1262  C   ARG A  77      30.036  74.666  -1.336  1.00  0.00           C  
ATOM   1263  O   ARG A  77      30.699  74.260  -2.291  1.00  0.00           O  
ATOM   1264  CB  ARG A  77      31.313  76.015   0.338  1.00  0.00           C  
ATOM   1265  CG  ARG A  77      32.130  76.509  -0.845  1.00  0.00           C  
ATOM   1266  CD  ARG A  77      32.896  77.778  -0.502  1.00  0.00           C  
ATOM   1267  NE  ARG A  77      33.460  78.413  -1.690  1.00  0.00           N  
ATOM   1268  CZ  ARG A  77      34.581  78.007  -2.278  1.00  0.00           C  
ATOM   1269  NH1 ARG A  77      35.252  76.974  -1.791  1.00  0.00           N  
ATOM   1270  NH2 ARG A  77      35.032  78.637  -3.355  1.00  0.00           N  
ATOM   1271  H   ARG A  77      32.481  73.752   0.362  1.00  0.00           H  
ATOM   1272  HA  ARG A  77      29.790  74.580   0.783  1.00  0.00           H  
ATOM   1273  HB2 ARG A  77      30.574  76.766   0.574  1.00  0.00           H  
ATOM   1274  HB3 ARG A  77      31.978  75.897   1.182  1.00  0.00           H  
ATOM   1275  HG2 ARG A  77      32.836  75.742  -1.128  1.00  0.00           H  
ATOM   1276  HG3 ARG A  77      31.464  76.712  -1.670  1.00  0.00           H  
ATOM   1277  HD2 ARG A  77      32.221  78.471  -0.023  1.00  0.00           H  
ATOM   1278  HD3 ARG A  77      33.697  77.527   0.175  1.00  0.00           H  
ATOM   1279  HE  ARG A  77      32.980  79.179  -2.068  1.00  0.00           H  
ATOM   1280 HH11 ARG A  77      34.915  76.497  -0.979  1.00  0.00           H  
ATOM   1281 HH12 ARG A  77      36.095  76.670  -2.236  1.00  0.00           H  
ATOM   1282 HH21 ARG A  77      34.528  79.417  -3.726  1.00  0.00           H  
ATOM   1283 HH22 ARG A  77      35.875  78.331  -3.796  1.00  0.00           H  
ATOM   1284  N   PRO A  78      28.779  75.113  -1.477  1.00  0.00           N  
ATOM   1285  CA  PRO A  78      28.095  75.157  -2.773  1.00  0.00           C  
ATOM   1286  C   PRO A  78      28.681  76.215  -3.702  1.00  0.00           C  
ATOM   1287  O   PRO A  78      29.707  76.823  -3.397  1.00  0.00           O  
ATOM   1288  CB  PRO A  78      26.653  75.511  -2.401  1.00  0.00           C  
ATOM   1289  CG  PRO A  78      26.762  76.229  -1.101  1.00  0.00           C  
ATOM   1290  CD  PRO A  78      27.930  75.611  -0.382  1.00  0.00           C  
ATOM   1291  HA  PRO A  78      28.117  74.196  -3.266  1.00  0.00           H  
ATOM   1292  HB2 PRO A  78      26.226  76.142  -3.168  1.00  0.00           H  
ATOM   1293  HB3 PRO A  78      26.071  74.607  -2.304  1.00  0.00           H  
ATOM   1294  HG2 PRO A  78      26.943  77.279  -1.276  1.00  0.00           H  
ATOM   1295  HG3 PRO A  78      25.857  76.094  -0.530  1.00  0.00           H  
ATOM   1296  HD2 PRO A  78      28.451  76.356   0.202  1.00  0.00           H  
ATOM   1297  HD3 PRO A  78      27.598  74.799   0.247  1.00  0.00           H  
ATOM   1298  N   ALA A  79      28.021  76.431  -4.836  1.00  0.00           N  
ATOM   1299  CA  ALA A  79      28.476  77.418  -5.807  1.00  0.00           C  
ATOM   1300  C   ALA A  79      27.731  78.739  -5.638  1.00  0.00           C  
ATOM   1301  O   ALA A  79      26.521  78.814  -5.859  1.00  0.00           O  
ATOM   1302  CB  ALA A  79      28.297  76.888  -7.222  1.00  0.00           C  
ATOM   1303  H   ALA A  79      27.210  75.915  -5.022  1.00  0.00           H  
ATOM   1304  HA  ALA A  79      29.530  77.588  -5.643  1.00  0.00           H  
ATOM   1305  HB1 ALA A  79      29.153  77.162  -7.819  1.00  0.00           H  
ATOM   1306  HB2 ALA A  79      28.208  75.811  -7.192  1.00  0.00           H  
ATOM   1307  HB3 ALA A  79      27.404  77.312  -7.656  1.00  0.00           H  
ATOM   1308  N   LEU A  80      28.460  79.777  -5.244  1.00  0.00           N  
ATOM   1309  CA  LEU A  80      27.868  81.095  -5.044  1.00  0.00           C  
ATOM   1310  C   LEU A  80      27.410  81.693  -6.371  1.00  0.00           C  
ATOM   1311  O   LEU A  80      28.228  82.091  -7.199  1.00  0.00           O  
ATOM   1312  CB  LEU A  80      28.873  82.031  -4.370  1.00  0.00           C  
ATOM   1313  CG  LEU A  80      30.032  82.512  -5.245  1.00  0.00           C  
ATOM   1314  CD1 LEU A  80      29.673  83.821  -5.931  1.00  0.00           C  
ATOM   1315  CD2 LEU A  80      31.297  82.673  -4.415  1.00  0.00           C  
ATOM   1316  H   LEU A  80      29.419  79.655  -5.084  1.00  0.00           H  
ATOM   1317  HA  LEU A  80      27.010  80.978  -4.399  1.00  0.00           H  
ATOM   1318  HB2 LEU A  80      28.337  82.900  -4.025  1.00  0.00           H  
ATOM   1319  HB3 LEU A  80      29.293  81.508  -3.522  1.00  0.00           H  
ATOM   1320  HG  LEU A  80      30.226  81.776  -6.013  1.00  0.00           H  
ATOM   1321 HD11 LEU A  80      30.007  83.793  -6.958  1.00  0.00           H  
ATOM   1322 HD12 LEU A  80      30.156  84.641  -5.418  1.00  0.00           H  
ATOM   1323 HD13 LEU A  80      28.602  83.961  -5.904  1.00  0.00           H  
ATOM   1324 HD21 LEU A  80      31.233  82.045  -3.538  1.00  0.00           H  
ATOM   1325 HD22 LEU A  80      31.401  83.704  -4.113  1.00  0.00           H  
ATOM   1326 HD23 LEU A  80      32.154  82.381  -5.005  1.00  0.00           H  
ATOM   1327  N   ARG A  81      26.096  81.753  -6.562  1.00  0.00           N  
ATOM   1328  CA  ARG A  81      25.528  82.304  -7.788  1.00  0.00           C  
ATOM   1329  C   ARG A  81      26.427  82.007  -8.985  1.00  0.00           C  
ATOM   1330  O   ARG A  81      26.819  82.913  -9.720  1.00  0.00           O  
ATOM   1331  CB  ARG A  81      25.327  83.814  -7.649  1.00  0.00           C  
ATOM   1332  CG  ARG A  81      26.615  84.578  -7.383  1.00  0.00           C  
ATOM   1333  CD  ARG A  81      26.556  85.985  -7.956  1.00  0.00           C  
ATOM   1334  NE  ARG A  81      26.952  86.022  -9.360  1.00  0.00           N  
ATOM   1335  CZ  ARG A  81      28.216  86.002  -9.769  1.00  0.00           C  
ATOM   1336  NH1 ARG A  81      29.201  85.945  -8.883  1.00  0.00           N  
ATOM   1337  NH2 ARG A  81      28.497  86.038 -11.065  1.00  0.00           N  
ATOM   1338  H   ARG A  81      25.494  81.420  -5.865  1.00  0.00           H  
ATOM   1339  HA  ARG A  81      24.568  81.836  -7.949  1.00  0.00           H  
ATOM   1340  HB2 ARG A  81      24.892  84.193  -8.561  1.00  0.00           H  
ATOM   1341  HB3 ARG A  81      24.648  84.001  -6.832  1.00  0.00           H  
ATOM   1342  HG2 ARG A  81      26.771  84.641  -6.317  1.00  0.00           H  
ATOM   1343  HG3 ARG A  81      27.437  84.046  -7.839  1.00  0.00           H  
ATOM   1344  HD2 ARG A  81      25.545  86.353  -7.867  1.00  0.00           H  
ATOM   1345  HD3 ARG A  81      27.220  86.619  -7.386  1.00  0.00           H  
ATOM   1346  HE  ARG A  81      26.240  86.064 -10.032  1.00  0.00           H  
ATOM   1347 HH11 ARG A  81      28.992  85.916  -7.905  1.00  0.00           H  
ATOM   1348 HH12 ARG A  81      30.153  85.929  -9.193  1.00  0.00           H  
ATOM   1349 HH21 ARG A  81      27.757  86.081 -11.735  1.00  0.00           H  
ATOM   1350 HH22 ARG A  81      29.448  86.023 -11.371  1.00  0.00           H  
ATOM   1351  N   LYS A  82      26.750  80.732  -9.173  1.00  0.00           N  
ATOM   1352  CA  LYS A  82      27.602  80.314 -10.281  1.00  0.00           C  
ATOM   1353  C   LYS A  82      27.255  81.081 -11.553  1.00  0.00           C  
ATOM   1354  O   LYS A  82      26.087  81.346 -11.829  1.00  0.00           O  
ATOM   1355  CB  LYS A  82      27.455  78.810 -10.524  1.00  0.00           C  
ATOM   1356  CG  LYS A  82      28.326  78.289 -11.654  1.00  0.00           C  
ATOM   1357  CD  LYS A  82      29.767  78.106 -11.209  1.00  0.00           C  
ATOM   1358  CE  LYS A  82      30.732  78.219 -12.380  1.00  0.00           C  
ATOM   1359  NZ  LYS A  82      32.120  77.847 -11.993  1.00  0.00           N  
ATOM   1360  H   LYS A  82      26.406  80.056  -8.553  1.00  0.00           H  
ATOM   1361  HA  LYS A  82      28.624  80.529 -10.012  1.00  0.00           H  
ATOM   1362  HB2 LYS A  82      27.723  78.284  -9.620  1.00  0.00           H  
ATOM   1363  HB3 LYS A  82      26.424  78.595 -10.764  1.00  0.00           H  
ATOM   1364  HG2 LYS A  82      27.939  77.337 -11.986  1.00  0.00           H  
ATOM   1365  HG3 LYS A  82      28.299  78.996 -12.472  1.00  0.00           H  
ATOM   1366  HD2 LYS A  82      30.011  78.868 -10.484  1.00  0.00           H  
ATOM   1367  HD3 LYS A  82      29.875  77.130 -10.759  1.00  0.00           H  
ATOM   1368  HE2 LYS A  82      30.398  77.562 -13.169  1.00  0.00           H  
ATOM   1369  HE3 LYS A  82      30.726  79.239 -12.737  1.00  0.00           H  
ATOM   1370  HZ1 LYS A  82      32.345  76.892 -12.339  1.00  0.00           H  
ATOM   1371  HZ2 LYS A  82      32.219  77.861 -10.957  1.00  0.00           H  
ATOM   1372  HZ3 LYS A  82      32.798  78.520 -12.403  1.00  0.00           H  
ATOM   1373  N   GLU A  83      28.280  81.434 -12.323  1.00  0.00           N  
ATOM   1374  CA  GLU A  83      28.082  82.170 -13.566  1.00  0.00           C  
ATOM   1375  C   GLU A  83      27.593  81.243 -14.676  1.00  0.00           C  
ATOM   1376  O   GLU A  83      28.250  80.260 -15.014  1.00  0.00           O  
ATOM   1377  CB  GLU A  83      29.385  82.851 -13.994  1.00  0.00           C  
ATOM   1378  CG  GLU A  83      29.883  83.888 -13.002  1.00  0.00           C  
ATOM   1379  CD  GLU A  83      31.009  84.736 -13.560  1.00  0.00           C  
ATOM   1380  OE1 GLU A  83      30.824  85.327 -14.644  1.00  0.00           O  
ATOM   1381  OE2 GLU A  83      32.076  84.807 -12.914  1.00  0.00           O  
ATOM   1382  H   GLU A  83      29.189  81.193 -12.049  1.00  0.00           H  
ATOM   1383  HA  GLU A  83      27.333  82.926 -13.389  1.00  0.00           H  
ATOM   1384  HB2 GLU A  83      30.149  82.098 -14.112  1.00  0.00           H  
ATOM   1385  HB3 GLU A  83      29.225  83.341 -14.943  1.00  0.00           H  
ATOM   1386  HG2 GLU A  83      29.063  84.538 -12.736  1.00  0.00           H  
ATOM   1387  HG3 GLU A  83      30.240  83.379 -12.118  1.00  0.00           H  
ATOM   1388  N   GLY A  84      26.431  81.564 -15.238  1.00  0.00           N  
ATOM   1389  CA  GLY A  84      25.872  80.752 -16.301  1.00  0.00           C  
ATOM   1390  C   GLY A  84      25.967  79.267 -16.008  1.00  0.00           C  
ATOM   1391  O   GLY A  84      26.741  78.550 -16.643  1.00  0.00           O  
ATOM   1392  H   GLY A  84      25.950  82.360 -14.927  1.00  0.00           H  
ATOM   1393  HA2 GLY A  84      24.834  81.016 -16.433  1.00  0.00           H  
ATOM   1394  HA3 GLY A  84      26.405  80.960 -17.217  1.00  0.00           H  
ATOM   1395  N   LEU A  85      25.180  78.805 -15.044  1.00  0.00           N  
ATOM   1396  CA  LEU A  85      25.180  77.395 -14.665  1.00  0.00           C  
ATOM   1397  C   LEU A  85      24.949  76.506 -15.883  1.00  0.00           C  
ATOM   1398  O   LEU A  85      25.736  75.602 -16.163  1.00  0.00           O  
ATOM   1399  CB  LEU A  85      24.103  77.130 -13.613  1.00  0.00           C  
ATOM   1400  CG  LEU A  85      24.320  75.905 -12.725  1.00  0.00           C  
ATOM   1401  CD1 LEU A  85      23.473  76.002 -11.465  1.00  0.00           C  
ATOM   1402  CD2 LEU A  85      23.999  74.629 -13.489  1.00  0.00           C  
ATOM   1403  H   LEU A  85      24.585  79.424 -14.574  1.00  0.00           H  
ATOM   1404  HA  LEU A  85      26.148  77.166 -14.245  1.00  0.00           H  
ATOM   1405  HB2 LEU A  85      24.045  77.997 -12.972  1.00  0.00           H  
ATOM   1406  HB3 LEU A  85      23.161  77.003 -14.129  1.00  0.00           H  
ATOM   1407  HG  LEU A  85      25.358  75.864 -12.426  1.00  0.00           H  
ATOM   1408 HD11 LEU A  85      23.956  76.657 -10.757  1.00  0.00           H  
ATOM   1409 HD12 LEU A  85      23.362  75.019 -11.030  1.00  0.00           H  
ATOM   1410 HD13 LEU A  85      22.499  76.396 -11.716  1.00  0.00           H  
ATOM   1411 HD21 LEU A  85      24.721  74.493 -14.281  1.00  0.00           H  
ATOM   1412 HD22 LEU A  85      23.008  74.702 -13.912  1.00  0.00           H  
ATOM   1413 HD23 LEU A  85      24.041  73.785 -12.815  1.00  0.00           H  
ATOM   1414  N   LYS A  86      23.864  76.769 -16.604  1.00  0.00           N  
ATOM   1415  CA  LYS A  86      23.530  75.995 -17.794  1.00  0.00           C  
ATOM   1416  C   LYS A  86      24.067  76.671 -19.051  1.00  0.00           C  
ATOM   1417  O   LYS A  86      24.643  77.757 -18.986  1.00  0.00           O  
ATOM   1418  CB  LYS A  86      22.013  75.821 -17.904  1.00  0.00           C  
ATOM   1419  CG  LYS A  86      21.256  77.133 -18.011  1.00  0.00           C  
ATOM   1420  CD  LYS A  86      21.131  77.589 -19.456  1.00  0.00           C  
ATOM   1421  CE  LYS A  86      20.237  78.813 -19.578  1.00  0.00           C  
ATOM   1422  NZ  LYS A  86      19.929  79.135 -20.998  1.00  0.00           N  
ATOM   1423  H   LYS A  86      23.275  77.502 -16.330  1.00  0.00           H  
ATOM   1424  HA  LYS A  86      23.989  75.023 -17.697  1.00  0.00           H  
ATOM   1425  HB2 LYS A  86      21.794  75.230 -18.782  1.00  0.00           H  
ATOM   1426  HB3 LYS A  86      21.659  75.296 -17.029  1.00  0.00           H  
ATOM   1427  HG2 LYS A  86      20.267  77.003 -17.598  1.00  0.00           H  
ATOM   1428  HG3 LYS A  86      21.786  77.890 -17.450  1.00  0.00           H  
ATOM   1429  HD2 LYS A  86      22.112  77.834 -19.833  1.00  0.00           H  
ATOM   1430  HD3 LYS A  86      20.707  76.785 -20.041  1.00  0.00           H  
ATOM   1431  HE2 LYS A  86      19.314  78.624 -19.051  1.00  0.00           H  
ATOM   1432  HE3 LYS A  86      20.742  79.656 -19.128  1.00  0.00           H  
ATOM   1433  HZ1 LYS A  86      20.809  79.252 -21.538  1.00  0.00           H  
ATOM   1434  HZ2 LYS A  86      19.380  80.017 -21.054  1.00  0.00           H  
ATOM   1435  HZ3 LYS A  86      19.372  78.368 -21.425  1.00  0.00           H  
ATOM   1436  N   ASP A  87      23.875  76.022 -20.194  1.00  0.00           N  
ATOM   1437  CA  ASP A  87      24.339  76.561 -21.467  1.00  0.00           C  
ATOM   1438  C   ASP A  87      23.183  76.697 -22.453  1.00  0.00           C  
ATOM   1439  O   ASP A  87      23.023  77.732 -23.097  1.00  0.00           O  
ATOM   1440  CB  ASP A  87      25.428  75.665 -22.059  1.00  0.00           C  
ATOM   1441  CG  ASP A  87      26.700  75.678 -21.234  1.00  0.00           C  
ATOM   1442  OD1 ASP A  87      26.607  75.524 -19.998  1.00  0.00           O  
ATOM   1443  OD2 ASP A  87      27.788  75.841 -21.825  1.00  0.00           O  
ATOM   1444  H   ASP A  87      23.410  75.159 -20.182  1.00  0.00           H  
ATOM   1445  HA  ASP A  87      24.754  77.540 -21.281  1.00  0.00           H  
ATOM   1446  HB2 ASP A  87      25.063  74.649 -22.107  1.00  0.00           H  
ATOM   1447  HB3 ASP A  87      25.663  76.006 -23.056  1.00  0.00           H  
ATOM   1448  N   GLU A  88      22.381  75.642 -22.565  1.00  0.00           N  
ATOM   1449  CA  GLU A  88      21.240  75.644 -23.475  1.00  0.00           C  
ATOM   1450  C   GLU A  88      20.404  76.907 -23.296  1.00  0.00           C  
ATOM   1451  O   GLU A  88      20.290  77.722 -24.211  1.00  0.00           O  
ATOM   1452  CB  GLU A  88      20.371  74.407 -23.241  1.00  0.00           C  
ATOM   1453  CG  GLU A  88      19.055  74.435 -23.998  1.00  0.00           C  
ATOM   1454  CD  GLU A  88      18.025  73.487 -23.416  1.00  0.00           C  
ATOM   1455  OE1 GLU A  88      18.238  72.259 -23.494  1.00  0.00           O  
ATOM   1456  OE2 GLU A  88      17.007  73.973 -22.881  1.00  0.00           O  
ATOM   1457  H   GLU A  88      22.560  74.845 -22.025  1.00  0.00           H  
ATOM   1458  HA  GLU A  88      21.622  75.619 -24.485  1.00  0.00           H  
ATOM   1459  HB2 GLU A  88      20.922  73.530 -23.550  1.00  0.00           H  
ATOM   1460  HB3 GLU A  88      20.153  74.329 -22.185  1.00  0.00           H  
ATOM   1461  HG2 GLU A  88      18.657  75.439 -23.967  1.00  0.00           H  
ATOM   1462  HG3 GLU A  88      19.239  74.156 -25.025  1.00  0.00           H  
TER    1463      GLU A  88                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
