
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   68 ( 1015),  selected   68 , name 2e5p_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2e5p_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      L       3           -
LGA    G     4_A      Y       4           -
LGA    S     5_A      F       5           -
LGA    S     6_A      Q       6           #
LGA    G     7_A      G       7          4.982
LGA    P     8_A      -       -           -
LGA    R     9_A      D       8          2.635
LGA    L    10_A      L       9          2.617
LGA    W    11_A      I      10          1.522
LGA    E    12_A      V      11          0.681
LGA    G    13_A      S      12          0.711
LGA    Q    14_A      M      13          0.852
LGA    D    15_A      R      14          0.791
LGA    V    16_A      I      15          0.556
LGA    L    17_A      L      16          0.201
LGA    A    18_A      G      17          0.279
LGA    R    19_A      K      18          1.355
LGA    W    20_A      K      19          2.124
LGA    T    21_A      R      20          2.979
LGA    D    22_A      T      21          3.249
LGA    G    23_A      K      22          2.919
LGA    L    24_A      T      23          2.560
LGA    L    25_A      W      24          1.531
LGA    Y    26_A      X      25          0.632
LGA    L    27_A      K      26          0.522
LGA    G    28_A      G      27          1.192
LGA    T    29_A      T      28          0.478
LGA    I    30_A      L      29          0.272
LGA    K    31_A      I      30          0.432
LGA    K    32_A      A      31          0.419
LGA    V    33_A      I      32          0.493
LGA    D    34_A      Q      33          0.801
LGA    S    35_A      T      34          2.397
LGA    A    36_A      V      35          2.147
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    R    37_A      G      38          3.486
LGA    E    38_A      K      39          0.267
LGA    V    39_A      K      40          0.727
LGA    C    40_A      Y      41          0.806
LGA    L    41_A      K      42          0.620
LGA    V    42_A      V      43          0.421
LGA    Q    43_A      K      44          0.193
LGA    F    44_A      F      45          1.187
LGA    E    45_A      D      46          2.120
LGA    D    46_A      N      47          3.321
LGA    D    47_A      K      48          5.249
LGA    S    48_A      G      49          1.217
LGA    Q    49_A      K      50          1.791
LGA    F    50_A      S      51          2.140
LGA    L    51_A      L      52          0.888
LGA    V    52_A      L      53          1.392
LGA    L    53_A      S      54          1.315
LGA    W    54_A      G      55          1.059
LGA    K    55_A      N      56          1.083
LGA    D    56_A      X      57          0.667
LGA    I    57_A      I      58          0.730
LGA    S    58_A      A      59          1.028
LGA    P    59_A      Y      60          1.594
LGA    A    60_A      D      61          1.212
LGA    A    61_A      Y      62          0.680
LGA    L    62_A      -       -           -
LGA    S    63_A      -       -           -
LGA    G    64_A      -       -           -
LGA    P    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    G    68_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   68   62    5.0     54    1.84    16.67     79.863     2.790

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.623509 * X  +   0.321551 * Y  +  -0.712630 * Z  +  38.189587
  Y_new =  -0.190187 * X  +  -0.821741 * Y  +  -0.537187 * Z  +  70.131950
  Z_new =  -0.758331 * X  +   0.470474 * Y  +  -0.451208 * Z  +  -0.289234 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.335294   -0.806298  [ DEG:   133.8025    -46.1975 ]
  Theta =   0.860749    2.280844  [ DEG:    49.3173    130.6827 ]
  Phi   =  -0.296063    2.845530  [ DEG:   -16.9632    163.0368 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e5p_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e5p_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   68   62   5.0   54   1.84   16.67  79.863
REMARK  ---------------------------------------------------------- 
MOLECULE 2e5p_A
HEADER    TRANSCRIPTION                           22-DEC-06   2E5P              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD FINGER                  
TITLE    2 PROTEIN 1 (PHF1 PROTEIN)                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHD FINGER PROTEIN 1;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN, RESIDUES 8-62;                               
COMPND   5 SYNONYM: PROTEIN PHF1;                                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PHF1;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050822-22;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, TUDOR DOMAIN, PHD FINGER PROTEIN 1, PHF1 PROTEIN,                
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   26-JUN-07 2E5P    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD                
JRNL        TITL 2 FINGER PROTEIN 1 (PHF1 PROTEIN)                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E5P A    8    62  UNP    O43189   PHF1_HUMAN      29     83             
SEQRES   1 A   68  GLY SER SER GLY SER SER GLY PRO ARG LEU TRP GLU GLY          
SEQRES   2 A   68  GLN ASP VAL LEU ALA ARG TRP THR ASP GLY LEU LEU TYR          
SEQRES   3 A   68  LEU GLY THR ILE LYS LYS VAL ASP SER ALA ARG GLU VAL          
SEQRES   4 A   68  CYS LEU VAL GLN PHE GLU ASP ASP SER GLN PHE LEU VAL          
SEQRES   5 A   68  LEU TRP LYS ASP ILE SER PRO ALA ALA LEU SER GLY PRO          
SEQRES   6 A   68  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      19.256  91.711   2.796  1.00  0.00           N  
ATOM      2  CA  GLY A   1      20.607  92.239   2.796  1.00  0.00           C  
ATOM      3  C   GLY A   1      21.640  91.188   2.438  1.00  0.00           C  
ATOM      4  O   GLY A   1      22.331  90.664   3.312  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      20.668  93.046   2.082  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      20.830  92.625   3.780  1.00  0.00           H  
ATOM      7  H1  GLY A   1      18.947  91.161   2.046  1.00  0.00           H  
ATOM      8  N   SER A   2      21.746  90.879   1.150  1.00  0.00           N  
ATOM      9  CA  SER A   2      22.698  89.880   0.678  1.00  0.00           C  
ATOM     10  C   SER A   2      23.160  90.197  -0.740  1.00  0.00           C  
ATOM     11  O   SER A   2      22.365  90.602  -1.588  1.00  0.00           O  
ATOM     12  CB  SER A   2      22.071  88.485   0.724  1.00  0.00           C  
ATOM     13  OG  SER A   2      22.112  87.950   2.035  1.00  0.00           O  
ATOM     14  H   SER A   2      21.167  91.332   0.501  1.00  0.00           H  
ATOM     15  HA  SER A   2      23.554  89.902   1.337  1.00  0.00           H  
ATOM     16  HB2 SER A   2      21.041  88.546   0.405  1.00  0.00           H  
ATOM     17  HB3 SER A   2      22.615  87.827   0.062  1.00  0.00           H  
ATOM     18  HG  SER A   2      21.309  87.452   2.204  1.00  0.00           H  
ATOM     19  N   SER A   3      24.452  90.009  -0.991  1.00  0.00           N  
ATOM     20  CA  SER A   3      25.023  90.278  -2.306  1.00  0.00           C  
ATOM     21  C   SER A   3      25.907  89.121  -2.760  1.00  0.00           C  
ATOM     22  O   SER A   3      26.181  88.196  -1.997  1.00  0.00           O  
ATOM     23  CB  SER A   3      25.833  91.575  -2.277  1.00  0.00           C  
ATOM     24  OG  SER A   3      26.856  91.516  -1.299  1.00  0.00           O  
ATOM     25  H   SER A   3      25.035  89.684  -0.273  1.00  0.00           H  
ATOM     26  HA  SER A   3      24.206  90.388  -3.005  1.00  0.00           H  
ATOM     27  HB2 SER A   3      26.285  91.735  -3.244  1.00  0.00           H  
ATOM     28  HB3 SER A   3      25.177  92.402  -2.046  1.00  0.00           H  
ATOM     29  HG  SER A   3      27.098  90.600  -1.143  1.00  0.00           H  
ATOM     30  N   GLY A   4      26.353  89.182  -4.012  1.00  0.00           N  
ATOM     31  CA  GLY A   4      27.202  88.134  -4.548  1.00  0.00           C  
ATOM     32  C   GLY A   4      28.576  88.116  -3.906  1.00  0.00           C  
ATOM     33  O   GLY A   4      29.368  89.039  -4.093  1.00  0.00           O  
ATOM     34  H   GLY A   4      26.103  89.943  -4.575  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      26.727  87.180  -4.383  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      27.317  88.289  -5.611  1.00  0.00           H  
ATOM     37  N   SER A   5      28.857  87.063  -3.147  1.00  0.00           N  
ATOM     38  CA  SER A   5      30.143  86.930  -2.470  1.00  0.00           C  
ATOM     39  C   SER A   5      30.527  85.462  -2.316  1.00  0.00           C  
ATOM     40  O   SER A   5      29.675  84.607  -2.075  1.00  0.00           O  
ATOM     41  CB  SER A   5      30.092  87.603  -1.096  1.00  0.00           C  
ATOM     42  OG  SER A   5      31.379  87.658  -0.508  1.00  0.00           O  
ATOM     43  H   SER A   5      28.184  86.359  -3.037  1.00  0.00           H  
ATOM     44  HA  SER A   5      30.889  87.424  -3.075  1.00  0.00           H  
ATOM     45  HB2 SER A   5      29.714  88.607  -1.205  1.00  0.00           H  
ATOM     46  HB3 SER A   5      29.436  87.040  -0.448  1.00  0.00           H  
ATOM     47  HG  SER A   5      31.889  86.893  -0.781  1.00  0.00           H  
ATOM     48  N   SER A   6      31.817  85.176  -2.458  1.00  0.00           N  
ATOM     49  CA  SER A   6      32.316  83.812  -2.339  1.00  0.00           C  
ATOM     50  C   SER A   6      32.508  83.430  -0.874  1.00  0.00           C  
ATOM     51  O   SER A   6      33.203  84.118  -0.127  1.00  0.00           O  
ATOM     52  CB  SER A   6      33.637  83.661  -3.095  1.00  0.00           C  
ATOM     53  OG  SER A   6      34.646  84.479  -2.529  1.00  0.00           O  
ATOM     54  H   SER A   6      32.448  85.902  -2.649  1.00  0.00           H  
ATOM     55  HA  SER A   6      31.583  83.151  -2.777  1.00  0.00           H  
ATOM     56  HB2 SER A   6      33.959  82.631  -3.050  1.00  0.00           H  
ATOM     57  HB3 SER A   6      33.493  83.948  -4.127  1.00  0.00           H  
ATOM     58  HG  SER A   6      35.490  84.025  -2.573  1.00  0.00           H  
ATOM     59  N   GLY A   7      31.887  82.325  -0.470  1.00  0.00           N  
ATOM     60  CA  GLY A   7      32.002  81.869   0.902  1.00  0.00           C  
ATOM     61  C   GLY A   7      33.261  81.058   1.141  1.00  0.00           C  
ATOM     62  O   GLY A   7      34.178  81.486   1.841  1.00  0.00           O  
ATOM     63  H   GLY A   7      31.347  81.815  -1.110  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      32.012  82.729   1.556  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      31.143  81.258   1.140  1.00  0.00           H  
ATOM     66  N   PRO A   8      33.313  79.855   0.551  1.00  0.00           N  
ATOM     67  CA  PRO A   8      34.463  78.955   0.690  1.00  0.00           C  
ATOM     68  C   PRO A   8      35.697  79.476  -0.039  1.00  0.00           C  
ATOM     69  O   PRO A   8      35.587  80.222  -1.012  1.00  0.00           O  
ATOM     70  CB  PRO A   8      33.974  77.653   0.050  1.00  0.00           C  
ATOM     71  CG  PRO A   8      32.918  78.076  -0.911  1.00  0.00           C  
ATOM     72  CD  PRO A   8      32.256  79.279  -0.296  1.00  0.00           C  
ATOM     73  HA  PRO A   8      34.707  78.779   1.727  1.00  0.00           H  
ATOM     74  HB2 PRO A   8      34.797  77.165  -0.454  1.00  0.00           H  
ATOM     75  HB3 PRO A   8      33.575  77.001   0.812  1.00  0.00           H  
ATOM     76  HG2 PRO A   8      33.367  78.338  -1.857  1.00  0.00           H  
ATOM     77  HG3 PRO A   8      32.200  77.280  -1.042  1.00  0.00           H  
ATOM     78  HD2 PRO A   8      31.954  79.976  -1.064  1.00  0.00           H  
ATOM     79  HD3 PRO A   8      31.406  78.978   0.299  1.00  0.00           H  
ATOM     80  N   ARG A   9      36.872  79.077   0.438  1.00  0.00           N  
ATOM     81  CA  ARG A   9      38.127  79.505  -0.168  1.00  0.00           C  
ATOM     82  C   ARG A   9      38.811  78.341  -0.881  1.00  0.00           C  
ATOM     83  O   ARG A   9      39.220  78.461  -2.036  1.00  0.00           O  
ATOM     84  CB  ARG A   9      39.061  80.085   0.895  1.00  0.00           C  
ATOM     85  CG  ARG A   9      38.710  81.506   1.304  1.00  0.00           C  
ATOM     86  CD  ARG A   9      39.233  82.519   0.297  1.00  0.00           C  
ATOM     87  NE  ARG A   9      39.549  83.800   0.924  1.00  0.00           N  
ATOM     88  CZ  ARG A   9      40.410  84.674   0.416  1.00  0.00           C  
ATOM     89  NH1 ARG A   9      41.038  84.407  -0.720  1.00  0.00           N  
ATOM     90  NH2 ARG A   9      40.644  85.819   1.045  1.00  0.00           N  
ATOM     91  H   ARG A   9      36.895  78.483   1.216  1.00  0.00           H  
ATOM     92  HA  ARG A   9      37.901  80.272  -0.893  1.00  0.00           H  
ATOM     93  HB2 ARG A   9      39.017  79.459   1.776  1.00  0.00           H  
ATOM     94  HB3 ARG A   9      40.070  80.081   0.512  1.00  0.00           H  
ATOM     95  HG2 ARG A   9      37.636  81.598   1.366  1.00  0.00           H  
ATOM     96  HG3 ARG A   9      39.148  81.711   2.270  1.00  0.00           H  
ATOM     97  HD2 ARG A   9      40.127  82.124  -0.161  1.00  0.00           H  
ATOM     98  HD3 ARG A   9      38.479  82.675  -0.460  1.00  0.00           H  
ATOM     99  HE  ARG A   9      39.095  84.018   1.765  1.00  0.00           H  
ATOM    100 HH11 ARG A   9      40.863  83.546  -1.197  1.00  0.00           H  
ATOM    101 HH12 ARG A   9      41.685  85.067  -1.101  1.00  0.00           H  
ATOM    102 HH21 ARG A   9      40.172  86.024   1.902  1.00  0.00           H  
ATOM    103 HH22 ARG A   9      41.292  86.476   0.662  1.00  0.00           H  
ATOM    104  N   LEU A  10      38.933  77.216  -0.184  1.00  0.00           N  
ATOM    105  CA  LEU A  10      39.567  76.031  -0.749  1.00  0.00           C  
ATOM    106  C   LEU A  10      40.835  76.403  -1.510  1.00  0.00           C  
ATOM    107  O   LEU A  10      41.078  75.906  -2.610  1.00  0.00           O  
ATOM    108  CB  LEU A  10      38.595  75.302  -1.679  1.00  0.00           C  
ATOM    109  CG  LEU A  10      37.650  74.303  -1.012  1.00  0.00           C  
ATOM    110  CD1 LEU A  10      36.826  74.986   0.069  1.00  0.00           C  
ATOM    111  CD2 LEU A  10      36.742  73.653  -2.047  1.00  0.00           C  
ATOM    112  H   LEU A  10      38.587  77.182   0.732  1.00  0.00           H  
ATOM    113  HA  LEU A  10      39.830  75.375   0.068  1.00  0.00           H  
ATOM    114  HB2 LEU A  10      37.992  76.046  -2.175  1.00  0.00           H  
ATOM    115  HB3 LEU A  10      39.180  74.767  -2.414  1.00  0.00           H  
ATOM    116  HG  LEU A  10      38.234  73.523  -0.542  1.00  0.00           H  
ATOM    117 HD11 LEU A  10      36.070  75.603  -0.392  1.00  0.00           H  
ATOM    118 HD12 LEU A  10      37.471  75.601   0.678  1.00  0.00           H  
ATOM    119 HD13 LEU A  10      36.352  74.237   0.687  1.00  0.00           H  
ATOM    120 HD21 LEU A  10      36.221  74.422  -2.600  1.00  0.00           H  
ATOM    121 HD22 LEU A  10      36.024  73.019  -1.549  1.00  0.00           H  
ATOM    122 HD23 LEU A  10      37.338  73.062  -2.727  1.00  0.00           H  
ATOM    123  N   TRP A  11      41.640  77.277  -0.917  1.00  0.00           N  
ATOM    124  CA  TRP A  11      42.886  77.712  -1.539  1.00  0.00           C  
ATOM    125  C   TRP A  11      43.962  76.641  -1.411  1.00  0.00           C  
ATOM    126  O   TRP A  11      43.857  75.740  -0.580  1.00  0.00           O  
ATOM    127  CB  TRP A  11      43.368  79.017  -0.901  1.00  0.00           C  
ATOM    128  CG  TRP A  11      43.648  78.893   0.566  1.00  0.00           C  
ATOM    129  CD1 TRP A  11      44.443  77.962   1.173  1.00  0.00           C  
ATOM    130  CD2 TRP A  11      43.134  79.726   1.610  1.00  0.00           C  
ATOM    131  NE1 TRP A  11      44.453  78.168   2.532  1.00  0.00           N  
ATOM    132  CE2 TRP A  11      43.659  79.244   2.824  1.00  0.00           C  
ATOM    133  CE3 TRP A  11      42.282  80.835   1.636  1.00  0.00           C  
ATOM    134  CZ2 TRP A  11      43.358  79.832   4.050  1.00  0.00           C  
ATOM    135  CZ3 TRP A  11      41.985  81.417   2.854  1.00  0.00           C  
ATOM    136  CH2 TRP A  11      42.522  80.916   4.047  1.00  0.00           C  
ATOM    137  H   TRP A  11      41.392  77.637  -0.040  1.00  0.00           H  
ATOM    138  HA  TRP A  11      42.689  77.886  -2.587  1.00  0.00           H  
ATOM    139  HB2 TRP A  11      44.278  79.333  -1.389  1.00  0.00           H  
ATOM    140  HB3 TRP A  11      42.610  79.775  -1.034  1.00  0.00           H  
ATOM    141  HD1 TRP A  11      44.976  77.185   0.649  1.00  0.00           H  
ATOM    142  HE1 TRP A  11      44.951  77.630   3.183  1.00  0.00           H  
ATOM    143  HE3 TRP A  11      41.859  81.235   0.727  1.00  0.00           H  
ATOM    144  HZ2 TRP A  11      43.764  79.457   4.979  1.00  0.00           H  
ATOM    145  HZ3 TRP A  11      41.329  82.274   2.894  1.00  0.00           H  
ATOM    146  HH2 TRP A  11      42.262  81.401   4.975  1.00  0.00           H  
ATOM    147  N   GLU A  12      44.996  76.746  -2.239  1.00  0.00           N  
ATOM    148  CA  GLU A  12      46.092  75.784  -2.218  1.00  0.00           C  
ATOM    149  C   GLU A  12      46.779  75.772  -0.855  1.00  0.00           C  
ATOM    150  O   GLU A  12      47.333  76.780  -0.418  1.00  0.00           O  
ATOM    151  CB  GLU A  12      47.111  76.113  -3.311  1.00  0.00           C  
ATOM    152  CG  GLU A  12      46.604  75.841  -4.718  1.00  0.00           C  
ATOM    153  CD  GLU A  12      47.543  76.361  -5.788  1.00  0.00           C  
ATOM    154  OE1 GLU A  12      48.732  75.978  -5.771  1.00  0.00           O  
ATOM    155  OE2 GLU A  12      47.091  77.152  -6.642  1.00  0.00           O  
ATOM    156  H   GLU A  12      45.024  77.487  -2.880  1.00  0.00           H  
ATOM    157  HA  GLU A  12      45.679  74.806  -2.407  1.00  0.00           H  
ATOM    158  HB2 GLU A  12      47.372  77.159  -3.240  1.00  0.00           H  
ATOM    159  HB3 GLU A  12      47.999  75.518  -3.150  1.00  0.00           H  
ATOM    160  HG2 GLU A  12      46.493  74.775  -4.846  1.00  0.00           H  
ATOM    161  HG3 GLU A  12      45.643  76.318  -4.838  1.00  0.00           H  
ATOM    162  N   GLY A  13      46.737  74.623  -0.188  1.00  0.00           N  
ATOM    163  CA  GLY A  13      47.358  74.500   1.119  1.00  0.00           C  
ATOM    164  C   GLY A  13      46.362  74.658   2.250  1.00  0.00           C  
ATOM    165  O   GLY A  13      46.731  75.040   3.361  1.00  0.00           O  
ATOM    166  H   GLY A  13      46.280  73.851  -0.585  1.00  0.00           H  
ATOM    167  HA2 GLY A  13      47.822  73.528   1.194  1.00  0.00           H  
ATOM    168  HA3 GLY A  13      48.118  75.260   1.216  1.00  0.00           H  
ATOM    169  N   GLN A  14      45.096  74.367   1.968  1.00  0.00           N  
ATOM    170  CA  GLN A  14      44.044  74.481   2.972  1.00  0.00           C  
ATOM    171  C   GLN A  14      43.561  73.104   3.413  1.00  0.00           C  
ATOM    172  O   GLN A  14      43.033  72.333   2.611  1.00  0.00           O  
ATOM    173  CB  GLN A  14      42.872  75.294   2.422  1.00  0.00           C  
ATOM    174  CG  GLN A  14      41.572  75.079   3.181  1.00  0.00           C  
ATOM    175  CD  GLN A  14      40.415  75.858   2.588  1.00  0.00           C  
ATOM    176  OE1 GLN A  14      39.383  75.287   2.234  1.00  0.00           O  
ATOM    177  NE2 GLN A  14      40.579  77.171   2.479  1.00  0.00           N  
ATOM    178  H   GLN A  14      44.864  74.068   1.065  1.00  0.00           H  
ATOM    179  HA  GLN A  14      44.457  74.996   3.827  1.00  0.00           H  
ATOM    180  HB2 GLN A  14      43.122  76.343   2.469  1.00  0.00           H  
ATOM    181  HB3 GLN A  14      42.710  75.017   1.390  1.00  0.00           H  
ATOM    182  HG2 GLN A  14      41.327  74.028   3.158  1.00  0.00           H  
ATOM    183  HG3 GLN A  14      41.713  75.394   4.204  1.00  0.00           H  
ATOM    184 HE21 GLN A  14      41.428  77.558   2.780  1.00  0.00           H  
ATOM    185 HE22 GLN A  14      39.847  77.700   2.099  1.00  0.00           H  
ATOM    186  N   ASP A  15      43.744  72.801   4.693  1.00  0.00           N  
ATOM    187  CA  ASP A  15      43.325  71.516   5.243  1.00  0.00           C  
ATOM    188  C   ASP A  15      41.809  71.364   5.174  1.00  0.00           C  
ATOM    189  O   ASP A  15      41.072  72.078   5.855  1.00  0.00           O  
ATOM    190  CB  ASP A  15      43.800  71.376   6.690  1.00  0.00           C  
ATOM    191  CG  ASP A  15      45.278  71.678   6.845  1.00  0.00           C  
ATOM    192  OD1 ASP A  15      45.666  72.851   6.662  1.00  0.00           O  
ATOM    193  OD2 ASP A  15      46.045  70.743   7.152  1.00  0.00           O  
ATOM    194  H   ASP A  15      44.170  73.457   5.284  1.00  0.00           H  
ATOM    195  HA  ASP A  15      43.779  70.738   4.648  1.00  0.00           H  
ATOM    196  HB2 ASP A  15      43.244  72.063   7.312  1.00  0.00           H  
ATOM    197  HB3 ASP A  15      43.620  70.366   7.025  1.00  0.00           H  
ATOM    198  N   VAL A  16      41.349  70.430   4.349  1.00  0.00           N  
ATOM    199  CA  VAL A  16      39.920  70.184   4.192  1.00  0.00           C  
ATOM    200  C   VAL A  16      39.595  68.704   4.363  1.00  0.00           C  
ATOM    201  O   VAL A  16      40.490  67.878   4.548  1.00  0.00           O  
ATOM    202  CB  VAL A  16      39.418  70.652   2.814  1.00  0.00           C  
ATOM    203  CG1 VAL A  16      39.780  72.112   2.581  1.00  0.00           C  
ATOM    204  CG2 VAL A  16      39.986  69.771   1.712  1.00  0.00           C  
ATOM    205  H   VAL A  16      41.985  69.892   3.833  1.00  0.00           H  
ATOM    206  HA  VAL A  16      39.399  70.748   4.953  1.00  0.00           H  
ATOM    207  HB  VAL A  16      38.341  70.565   2.797  1.00  0.00           H  
ATOM    208 HG11 VAL A  16      39.259  72.477   1.708  1.00  0.00           H  
ATOM    209 HG12 VAL A  16      39.495  72.696   3.443  1.00  0.00           H  
ATOM    210 HG13 VAL A  16      40.846  72.196   2.424  1.00  0.00           H  
ATOM    211 HG21 VAL A  16      39.487  69.993   0.781  1.00  0.00           H  
ATOM    212 HG22 VAL A  16      41.044  69.962   1.608  1.00  0.00           H  
ATOM    213 HG23 VAL A  16      39.832  68.732   1.966  1.00  0.00           H  
ATOM    214  N   LEU A  17      38.310  68.376   4.300  1.00  0.00           N  
ATOM    215  CA  LEU A  17      37.865  66.994   4.448  1.00  0.00           C  
ATOM    216  C   LEU A  17      37.076  66.543   3.222  1.00  0.00           C  
ATOM    217  O   LEU A  17      35.978  67.035   2.964  1.00  0.00           O  
ATOM    218  CB  LEU A  17      37.007  66.845   5.705  1.00  0.00           C  
ATOM    219  CG  LEU A  17      37.604  67.404   6.996  1.00  0.00           C  
ATOM    220  CD1 LEU A  17      36.608  67.291   8.139  1.00  0.00           C  
ATOM    221  CD2 LEU A  17      38.900  66.683   7.340  1.00  0.00           C  
ATOM    222  H   LEU A  17      37.643  69.078   4.152  1.00  0.00           H  
ATOM    223  HA  LEU A  17      38.742  66.372   4.544  1.00  0.00           H  
ATOM    224  HB2 LEU A  17      36.070  67.352   5.528  1.00  0.00           H  
ATOM    225  HB3 LEU A  17      36.821  65.791   5.855  1.00  0.00           H  
ATOM    226  HG  LEU A  17      37.832  68.453   6.855  1.00  0.00           H  
ATOM    227 HD11 LEU A  17      36.126  66.326   8.102  1.00  0.00           H  
ATOM    228 HD12 LEU A  17      35.864  68.068   8.047  1.00  0.00           H  
ATOM    229 HD13 LEU A  17      37.127  67.399   9.080  1.00  0.00           H  
ATOM    230 HD21 LEU A  17      39.519  66.615   6.458  1.00  0.00           H  
ATOM    231 HD22 LEU A  17      38.673  65.689   7.699  1.00  0.00           H  
ATOM    232 HD23 LEU A  17      39.425  67.232   8.108  1.00  0.00           H  
ATOM    233  N   ALA A  18      37.642  65.602   2.475  1.00  0.00           N  
ATOM    234  CA  ALA A  18      36.989  65.081   1.280  1.00  0.00           C  
ATOM    235  C   ALA A  18      36.178  63.829   1.598  1.00  0.00           C  
ATOM    236  O   ALA A  18      36.703  62.861   2.149  1.00  0.00           O  
ATOM    237  CB  ALA A  18      38.021  64.782   0.202  1.00  0.00           C  
ATOM    238  H   ALA A  18      38.518  65.249   2.732  1.00  0.00           H  
ATOM    239  HA  ALA A  18      36.323  65.843   0.904  1.00  0.00           H  
ATOM    240  HB1 ALA A  18      38.932  65.322   0.418  1.00  0.00           H  
ATOM    241  HB2 ALA A  18      38.225  63.723   0.183  1.00  0.00           H  
ATOM    242  HB3 ALA A  18      37.637  65.093  -0.759  1.00  0.00           H  
ATOM    243  N   ARG A  19      34.895  63.856   1.250  1.00  0.00           N  
ATOM    244  CA  ARG A  19      34.011  62.724   1.501  1.00  0.00           C  
ATOM    245  C   ARG A  19      34.373  61.544   0.605  1.00  0.00           C  
ATOM    246  O   ARG A  19      34.988  61.715  -0.447  1.00  0.00           O  
ATOM    247  CB  ARG A  19      32.554  63.127   1.270  1.00  0.00           C  
ATOM    248  CG  ARG A  19      31.555  62.055   1.676  1.00  0.00           C  
ATOM    249  CD  ARG A  19      30.173  62.644   1.912  1.00  0.00           C  
ATOM    250  NE  ARG A  19      29.611  63.229   0.697  1.00  0.00           N  
ATOM    251  CZ  ARG A  19      28.566  64.048   0.691  1.00  0.00           C  
ATOM    252  NH1 ARG A  19      27.972  64.379   1.829  1.00  0.00           N  
ATOM    253  NH2 ARG A  19      28.114  64.540  -0.455  1.00  0.00           N  
ATOM    254  H   ARG A  19      34.535  64.656   0.814  1.00  0.00           H  
ATOM    255  HA  ARG A  19      34.135  62.429   2.533  1.00  0.00           H  
ATOM    256  HB2 ARG A  19      32.344  64.018   1.843  1.00  0.00           H  
ATOM    257  HB3 ARG A  19      32.415  63.341   0.221  1.00  0.00           H  
ATOM    258  HG2 ARG A  19      31.491  61.319   0.887  1.00  0.00           H  
ATOM    259  HG3 ARG A  19      31.897  61.584   2.584  1.00  0.00           H  
ATOM    260  HD2 ARG A  19      29.517  61.859   2.258  1.00  0.00           H  
ATOM    261  HD3 ARG A  19      30.248  63.410   2.668  1.00  0.00           H  
ATOM    262  HE  ARG A  19      30.035  62.998  -0.156  1.00  0.00           H  
ATOM    263 HH11 ARG A  19      28.312  64.011   2.695  1.00  0.00           H  
ATOM    264 HH12 ARG A  19      27.186  64.997   1.823  1.00  0.00           H  
ATOM    265 HH21 ARG A  19      28.559  64.293  -1.316  1.00  0.00           H  
ATOM    266 HH22 ARG A  19      27.327  65.157  -0.459  1.00  0.00           H  
ATOM    267  N   TRP A  20      33.986  60.345   1.030  1.00  0.00           N  
ATOM    268  CA  TRP A  20      34.270  59.136   0.266  1.00  0.00           C  
ATOM    269  C   TRP A  20      32.978  58.445  -0.159  1.00  0.00           C  
ATOM    270  O   TRP A  20      31.902  58.746   0.358  1.00  0.00           O  
ATOM    271  CB  TRP A  20      35.128  58.176   1.092  1.00  0.00           C  
ATOM    272  CG  TRP A  20      36.011  57.300   0.255  1.00  0.00           C  
ATOM    273  CD1 TRP A  20      35.761  56.015  -0.131  1.00  0.00           C  
ATOM    274  CD2 TRP A  20      37.287  57.646  -0.296  1.00  0.00           C  
ATOM    275  NE1 TRP A  20      36.804  55.540  -0.890  1.00  0.00           N  
ATOM    276  CE2 TRP A  20      37.752  56.522  -1.006  1.00  0.00           C  
ATOM    277  CE3 TRP A  20      38.080  58.795  -0.261  1.00  0.00           C  
ATOM    278  CZ2 TRP A  20      38.976  56.516  -1.672  1.00  0.00           C  
ATOM    279  CZ3 TRP A  20      39.293  58.788  -0.922  1.00  0.00           C  
ATOM    280  CH2 TRP A  20      39.732  57.655  -1.621  1.00  0.00           C  
ATOM    281  H   TRP A  20      33.498  60.272   1.878  1.00  0.00           H  
ATOM    282  HA  TRP A  20      34.817  59.425  -0.619  1.00  0.00           H  
ATOM    283  HB2 TRP A  20      35.759  58.748   1.755  1.00  0.00           H  
ATOM    284  HB3 TRP A  20      34.481  57.538   1.675  1.00  0.00           H  
ATOM    285  HD1 TRP A  20      34.871  55.464   0.129  1.00  0.00           H  
ATOM    286  HE1 TRP A  20      36.859  54.644  -1.284  1.00  0.00           H  
ATOM    287  HE3 TRP A  20      37.760  59.679   0.273  1.00  0.00           H  
ATOM    288  HZ2 TRP A  20      39.326  55.651  -2.215  1.00  0.00           H  
ATOM    289  HZ3 TRP A  20      39.920  59.668  -0.906  1.00  0.00           H  
ATOM    290  HH2 TRP A  20      40.686  57.694  -2.122  1.00  0.00           H  
ATOM    291  N   THR A  21      33.092  57.518  -1.105  1.00  0.00           N  
ATOM    292  CA  THR A  21      31.933  56.784  -1.599  1.00  0.00           C  
ATOM    293  C   THR A  21      31.073  56.275  -0.448  1.00  0.00           C  
ATOM    294  O   THR A  21      29.862  56.110  -0.592  1.00  0.00           O  
ATOM    295  CB  THR A  21      32.356  55.592  -2.477  1.00  0.00           C  
ATOM    296  OG1 THR A  21      33.335  54.802  -1.794  1.00  0.00           O  
ATOM    297  CG2 THR A  21      32.920  56.072  -3.806  1.00  0.00           C  
ATOM    298  H   THR A  21      33.976  57.322  -1.478  1.00  0.00           H  
ATOM    299  HA  THR A  21      31.345  57.459  -2.203  1.00  0.00           H  
ATOM    300  HB  THR A  21      31.486  54.982  -2.672  1.00  0.00           H  
ATOM    301  HG1 THR A  21      33.076  54.694  -0.875  1.00  0.00           H  
ATOM    302 HG21 THR A  21      32.695  55.348  -4.575  1.00  0.00           H  
ATOM    303 HG22 THR A  21      33.991  56.186  -3.721  1.00  0.00           H  
ATOM    304 HG23 THR A  21      32.476  57.021  -4.064  1.00  0.00           H  
ATOM    305  N   ASP A  22      31.707  56.025   0.692  1.00  0.00           N  
ATOM    306  CA  ASP A  22      30.999  55.535   1.869  1.00  0.00           C  
ATOM    307  C   ASP A  22      30.080  56.612   2.437  1.00  0.00           C  
ATOM    308  O   ASP A  22      28.947  56.331   2.831  1.00  0.00           O  
ATOM    309  CB  ASP A  22      31.995  55.081   2.937  1.00  0.00           C  
ATOM    310  CG  ASP A  22      31.441  53.972   3.811  1.00  0.00           C  
ATOM    311  OD1 ASP A  22      30.268  54.076   4.228  1.00  0.00           O  
ATOM    312  OD2 ASP A  22      32.180  53.003   4.078  1.00  0.00           O  
ATOM    313  H   ASP A  22      32.674  56.176   0.745  1.00  0.00           H  
ATOM    314  HA  ASP A  22      30.399  54.690   1.566  1.00  0.00           H  
ATOM    315  HB2 ASP A  22      32.891  54.719   2.454  1.00  0.00           H  
ATOM    316  HB3 ASP A  22      32.244  55.922   3.568  1.00  0.00           H  
ATOM    317  N   GLY A  23      30.575  57.844   2.479  1.00  0.00           N  
ATOM    318  CA  GLY A  23      29.786  58.944   3.002  1.00  0.00           C  
ATOM    319  C   GLY A  23      30.545  59.771   4.021  1.00  0.00           C  
ATOM    320  O   GLY A  23      30.389  60.991   4.081  1.00  0.00           O  
ATOM    321  H   GLY A  23      31.484  58.009   2.151  1.00  0.00           H  
ATOM    322  HA2 GLY A  23      29.490  59.583   2.183  1.00  0.00           H  
ATOM    323  HA3 GLY A  23      28.898  58.544   3.471  1.00  0.00           H  
ATOM    324  N   LEU A  24      31.369  59.106   4.822  1.00  0.00           N  
ATOM    325  CA  LEU A  24      32.155  59.788   5.845  1.00  0.00           C  
ATOM    326  C   LEU A  24      33.138  60.768   5.213  1.00  0.00           C  
ATOM    327  O   LEU A  24      33.376  60.733   4.005  1.00  0.00           O  
ATOM    328  CB  LEU A  24      32.913  58.767   6.697  1.00  0.00           C  
ATOM    329  CG  LEU A  24      32.075  57.988   7.713  1.00  0.00           C  
ATOM    330  CD1 LEU A  24      31.524  58.923   8.779  1.00  0.00           C  
ATOM    331  CD2 LEU A  24      30.945  57.246   7.015  1.00  0.00           C  
ATOM    332  H   LEU A  24      31.451  58.135   4.727  1.00  0.00           H  
ATOM    333  HA  LEU A  24      31.474  60.337   6.477  1.00  0.00           H  
ATOM    334  HB2 LEU A  24      33.371  58.054   6.031  1.00  0.00           H  
ATOM    335  HB3 LEU A  24      33.683  59.298   7.240  1.00  0.00           H  
ATOM    336  HG  LEU A  24      32.704  57.258   8.203  1.00  0.00           H  
ATOM    337 HD11 LEU A  24      30.901  59.671   8.314  1.00  0.00           H  
ATOM    338 HD12 LEU A  24      32.342  59.404   9.294  1.00  0.00           H  
ATOM    339 HD13 LEU A  24      30.938  58.354   9.487  1.00  0.00           H  
ATOM    340 HD21 LEU A  24      30.317  57.955   6.496  1.00  0.00           H  
ATOM    341 HD22 LEU A  24      30.358  56.713   7.748  1.00  0.00           H  
ATOM    342 HD23 LEU A  24      31.360  56.545   6.306  1.00  0.00           H  
ATOM    343  N   LEU A  25      33.708  61.640   6.036  1.00  0.00           N  
ATOM    344  CA  LEU A  25      34.668  62.630   5.559  1.00  0.00           C  
ATOM    345  C   LEU A  25      36.099  62.139   5.755  1.00  0.00           C  
ATOM    346  O   LEU A  25      36.431  61.558   6.788  1.00  0.00           O  
ATOM    347  CB  LEU A  25      34.468  63.958   6.290  1.00  0.00           C  
ATOM    348  CG  LEU A  25      33.068  64.568   6.201  1.00  0.00           C  
ATOM    349  CD1 LEU A  25      32.983  65.833   7.042  1.00  0.00           C  
ATOM    350  CD2 LEU A  25      32.705  64.863   4.754  1.00  0.00           C  
ATOM    351  H   LEU A  25      33.480  61.619   6.989  1.00  0.00           H  
ATOM    352  HA  LEU A  25      34.493  62.778   4.504  1.00  0.00           H  
ATOM    353  HB2 LEU A  25      34.694  63.799   7.333  1.00  0.00           H  
ATOM    354  HB3 LEU A  25      35.167  64.672   5.877  1.00  0.00           H  
ATOM    355  HG  LEU A  25      32.349  63.861   6.590  1.00  0.00           H  
ATOM    356 HD11 LEU A  25      33.361  66.669   6.474  1.00  0.00           H  
ATOM    357 HD12 LEU A  25      33.575  65.709   7.938  1.00  0.00           H  
ATOM    358 HD13 LEU A  25      31.953  66.015   7.314  1.00  0.00           H  
ATOM    359 HD21 LEU A  25      31.828  65.493   4.724  1.00  0.00           H  
ATOM    360 HD22 LEU A  25      32.499  63.936   4.238  1.00  0.00           H  
ATOM    361 HD23 LEU A  25      33.529  65.368   4.272  1.00  0.00           H  
ATOM    362  N   TYR A  26      36.943  62.380   4.758  1.00  0.00           N  
ATOM    363  CA  TYR A  26      38.339  61.962   4.821  1.00  0.00           C  
ATOM    364  C   TYR A  26      39.270  63.170   4.808  1.00  0.00           C  
ATOM    365  O   TYR A  26      38.953  64.208   4.224  1.00  0.00           O  
ATOM    366  CB  TYR A  26      38.670  61.037   3.649  1.00  0.00           C  
ATOM    367  CG  TYR A  26      38.045  59.665   3.765  1.00  0.00           C  
ATOM    368  CD1 TYR A  26      36.691  59.516   4.037  1.00  0.00           C  
ATOM    369  CD2 TYR A  26      38.811  58.516   3.603  1.00  0.00           C  
ATOM    370  CE1 TYR A  26      36.117  58.264   4.145  1.00  0.00           C  
ATOM    371  CE2 TYR A  26      38.244  57.261   3.708  1.00  0.00           C  
ATOM    372  CZ  TYR A  26      36.897  57.140   3.980  1.00  0.00           C  
ATOM    373  OH  TYR A  26      36.329  55.891   4.085  1.00  0.00           O  
ATOM    374  H   TYR A  26      36.620  62.847   3.961  1.00  0.00           H  
ATOM    375  HA  TYR A  26      38.482  61.421   5.745  1.00  0.00           H  
ATOM    376  HB2 TYR A  26      38.314  61.486   2.733  1.00  0.00           H  
ATOM    377  HB3 TYR A  26      39.741  60.911   3.589  1.00  0.00           H  
ATOM    378  HD1 TYR A  26      36.083  60.401   4.165  1.00  0.00           H  
ATOM    379  HD2 TYR A  26      39.865  58.614   3.390  1.00  0.00           H  
ATOM    380  HE1 TYR A  26      35.062  58.170   4.358  1.00  0.00           H  
ATOM    381  HE2 TYR A  26      38.856  56.379   3.578  1.00  0.00           H  
ATOM    382  HH  TYR A  26      36.928  55.306   4.556  1.00  0.00           H  
ATOM    383  N   LEU A  27      40.421  63.029   5.455  1.00  0.00           N  
ATOM    384  CA  LEU A  27      41.401  64.108   5.518  1.00  0.00           C  
ATOM    385  C   LEU A  27      42.037  64.348   4.153  1.00  0.00           C  
ATOM    386  O   LEU A  27      42.653  63.452   3.578  1.00  0.00           O  
ATOM    387  CB  LEU A  27      42.485  63.779   6.547  1.00  0.00           C  
ATOM    388  CG  LEU A  27      43.129  64.975   7.249  1.00  0.00           C  
ATOM    389  CD1 LEU A  27      43.908  64.521   8.473  1.00  0.00           C  
ATOM    390  CD2 LEU A  27      44.035  65.732   6.288  1.00  0.00           C  
ATOM    391  H   LEU A  27      40.619  62.180   5.901  1.00  0.00           H  
ATOM    392  HA  LEU A  27      40.886  65.005   5.824  1.00  0.00           H  
ATOM    393  HB2 LEU A  27      42.041  63.152   7.305  1.00  0.00           H  
ATOM    394  HB3 LEU A  27      43.267  63.231   6.040  1.00  0.00           H  
ATOM    395  HG  LEU A  27      42.353  65.652   7.579  1.00  0.00           H  
ATOM    396 HD11 LEU A  27      43.415  63.670   8.918  1.00  0.00           H  
ATOM    397 HD12 LEU A  27      43.954  65.327   9.191  1.00  0.00           H  
ATOM    398 HD13 LEU A  27      44.910  64.244   8.178  1.00  0.00           H  
ATOM    399 HD21 LEU A  27      43.676  65.603   5.278  1.00  0.00           H  
ATOM    400 HD22 LEU A  27      45.042  65.347   6.364  1.00  0.00           H  
ATOM    401 HD23 LEU A  27      44.031  66.782   6.540  1.00  0.00           H  
ATOM    402  N   GLY A  28      41.884  65.564   3.640  1.00  0.00           N  
ATOM    403  CA  GLY A  28      42.451  65.901   2.346  1.00  0.00           C  
ATOM    404  C   GLY A  28      43.085  67.278   2.332  1.00  0.00           C  
ATOM    405  O   GLY A  28      42.660  68.174   3.061  1.00  0.00           O  
ATOM    406  H   GLY A  28      41.383  66.240   4.144  1.00  0.00           H  
ATOM    407  HA2 GLY A  28      43.201  65.167   2.092  1.00  0.00           H  
ATOM    408  HA3 GLY A  28      41.666  65.871   1.604  1.00  0.00           H  
ATOM    409  N   THR A  29      44.106  67.448   1.498  1.00  0.00           N  
ATOM    410  CA  THR A  29      44.803  68.724   1.394  1.00  0.00           C  
ATOM    411  C   THR A  29      44.607  69.345   0.015  1.00  0.00           C  
ATOM    412  O   THR A  29      44.890  68.717  -1.005  1.00  0.00           O  
ATOM    413  CB  THR A  29      46.311  68.565   1.664  1.00  0.00           C  
ATOM    414  OG1 THR A  29      46.523  68.099   3.000  1.00  0.00           O  
ATOM    415  CG2 THR A  29      47.039  69.884   1.458  1.00  0.00           C  
ATOM    416  H   THR A  29      44.399  66.696   0.943  1.00  0.00           H  
ATOM    417  HA  THR A  29      44.394  69.389   2.139  1.00  0.00           H  
ATOM    418  HB  THR A  29      46.711  67.838   0.969  1.00  0.00           H  
ATOM    419  HG1 THR A  29      45.753  67.608   3.295  1.00  0.00           H  
ATOM    420 HG21 THR A  29      47.632  70.107   2.333  1.00  0.00           H  
ATOM    421 HG22 THR A  29      46.318  70.673   1.302  1.00  0.00           H  
ATOM    422 HG23 THR A  29      47.684  69.809   0.596  1.00  0.00           H  
ATOM    423  N   ILE A  30      44.122  70.582  -0.008  1.00  0.00           N  
ATOM    424  CA  ILE A  30      43.891  71.288  -1.261  1.00  0.00           C  
ATOM    425  C   ILE A  30      45.180  71.420  -2.064  1.00  0.00           C  
ATOM    426  O   ILE A  30      46.011  72.286  -1.787  1.00  0.00           O  
ATOM    427  CB  ILE A  30      43.305  72.692  -1.017  1.00  0.00           C  
ATOM    428  CG1 ILE A  30      41.980  72.590  -0.258  1.00  0.00           C  
ATOM    429  CG2 ILE A  30      43.110  73.422  -2.338  1.00  0.00           C  
ATOM    430  CD1 ILE A  30      40.860  71.985  -1.075  1.00  0.00           C  
ATOM    431  H   ILE A  30      43.916  71.030   0.839  1.00  0.00           H  
ATOM    432  HA  ILE A  30      43.177  70.717  -1.838  1.00  0.00           H  
ATOM    433  HB  ILE A  30      44.010  73.254  -0.424  1.00  0.00           H  
ATOM    434 HG12 ILE A  30      42.121  71.976   0.617  1.00  0.00           H  
ATOM    435 HG13 ILE A  30      41.673  73.580   0.047  1.00  0.00           H  
ATOM    436 HG21 ILE A  30      43.610  74.378  -2.298  1.00  0.00           H  
ATOM    437 HG22 ILE A  30      43.529  72.832  -3.140  1.00  0.00           H  
ATOM    438 HG23 ILE A  30      42.056  73.573  -2.514  1.00  0.00           H  
ATOM    439 HD11 ILE A  30      40.560  71.045  -0.635  1.00  0.00           H  
ATOM    440 HD12 ILE A  30      40.019  72.661  -1.090  1.00  0.00           H  
ATOM    441 HD13 ILE A  30      41.203  71.815  -2.085  1.00  0.00           H  
ATOM    442  N   LYS A  31      45.341  70.557  -3.061  1.00  0.00           N  
ATOM    443  CA  LYS A  31      46.528  70.578  -3.908  1.00  0.00           C  
ATOM    444  C   LYS A  31      46.348  71.545  -5.074  1.00  0.00           C  
ATOM    445  O   LYS A  31      47.257  72.302  -5.412  1.00  0.00           O  
ATOM    446  CB  LYS A  31      46.827  69.174  -4.437  1.00  0.00           C  
ATOM    447  CG  LYS A  31      46.620  68.078  -3.406  1.00  0.00           C  
ATOM    448  CD  LYS A  31      47.418  68.345  -2.141  1.00  0.00           C  
ATOM    449  CE  LYS A  31      48.822  67.768  -2.235  1.00  0.00           C  
ATOM    450  NZ  LYS A  31      49.368  67.413  -0.896  1.00  0.00           N  
ATOM    451  H   LYS A  31      44.643  69.890  -3.233  1.00  0.00           H  
ATOM    452  HA  LYS A  31      47.360  70.910  -3.306  1.00  0.00           H  
ATOM    453  HB2 LYS A  31      46.180  68.974  -5.279  1.00  0.00           H  
ATOM    454  HB3 LYS A  31      47.855  69.138  -4.768  1.00  0.00           H  
ATOM    455  HG2 LYS A  31      45.571  68.027  -3.152  1.00  0.00           H  
ATOM    456  HG3 LYS A  31      46.936  67.134  -3.828  1.00  0.00           H  
ATOM    457  HD2 LYS A  31      47.490  69.412  -1.989  1.00  0.00           H  
ATOM    458  HD3 LYS A  31      46.909  67.893  -1.302  1.00  0.00           H  
ATOM    459  HE2 LYS A  31      48.792  66.880  -2.849  1.00  0.00           H  
ATOM    460  HE3 LYS A  31      49.469  68.501  -2.696  1.00  0.00           H  
ATOM    461  HZ1 LYS A  31      49.599  68.277  -0.365  1.00  0.00           H  
ATOM    462  HZ2 LYS A  31      50.231  66.844  -1.001  1.00  0.00           H  
ATOM    463  HZ3 LYS A  31      48.667  66.866  -0.358  1.00  0.00           H  
ATOM    464  N   LYS A  32      45.168  71.514  -5.685  1.00  0.00           N  
ATOM    465  CA  LYS A  32      44.867  72.389  -6.811  1.00  0.00           C  
ATOM    466  C   LYS A  32      43.433  72.904  -6.732  1.00  0.00           C  
ATOM    467  O   LYS A  32      42.579  72.294  -6.089  1.00  0.00           O  
ATOM    468  CB  LYS A  32      45.080  71.647  -8.133  1.00  0.00           C  
ATOM    469  CG  LYS A  32      45.367  72.565  -9.307  1.00  0.00           C  
ATOM    470  CD  LYS A  32      45.128  71.864 -10.634  1.00  0.00           C  
ATOM    471  CE  LYS A  32      46.387  71.172 -11.134  1.00  0.00           C  
ATOM    472  NZ  LYS A  32      47.348  72.136 -11.736  1.00  0.00           N  
ATOM    473  H   LYS A  32      44.483  70.888  -5.369  1.00  0.00           H  
ATOM    474  HA  LYS A  32      45.541  73.230  -6.768  1.00  0.00           H  
ATOM    475  HB2 LYS A  32      45.914  70.969  -8.020  1.00  0.00           H  
ATOM    476  HB3 LYS A  32      44.191  71.075  -8.357  1.00  0.00           H  
ATOM    477  HG2 LYS A  32      44.720  73.426  -9.246  1.00  0.00           H  
ATOM    478  HG3 LYS A  32      46.399  72.884  -9.260  1.00  0.00           H  
ATOM    479  HD2 LYS A  32      44.351  71.125 -10.507  1.00  0.00           H  
ATOM    480  HD3 LYS A  32      44.816  72.595 -11.366  1.00  0.00           H  
ATOM    481  HE2 LYS A  32      46.863  70.674 -10.303  1.00  0.00           H  
ATOM    482  HE3 LYS A  32      46.108  70.441 -11.878  1.00  0.00           H  
ATOM    483  HZ1 LYS A  32      48.220  71.642 -12.018  1.00  0.00           H  
ATOM    484  HZ2 LYS A  32      47.589  72.877 -11.049  1.00  0.00           H  
ATOM    485  HZ3 LYS A  32      46.928  72.581 -12.577  1.00  0.00           H  
ATOM    486  N   VAL A  33      43.176  74.031  -7.390  1.00  0.00           N  
ATOM    487  CA  VAL A  33      41.845  74.626  -7.395  1.00  0.00           C  
ATOM    488  C   VAL A  33      41.470  75.119  -8.788  1.00  0.00           C  
ATOM    489  O   VAL A  33      42.050  76.079  -9.296  1.00  0.00           O  
ATOM    490  CB  VAL A  33      41.752  75.801  -6.404  1.00  0.00           C  
ATOM    491  CG1 VAL A  33      42.932  76.744  -6.581  1.00  0.00           C  
ATOM    492  CG2 VAL A  33      40.436  76.543  -6.581  1.00  0.00           C  
ATOM    493  H   VAL A  33      43.899  74.471  -7.884  1.00  0.00           H  
ATOM    494  HA  VAL A  33      41.139  73.868  -7.089  1.00  0.00           H  
ATOM    495  HB  VAL A  33      41.786  75.403  -5.401  1.00  0.00           H  
ATOM    496 HG11 VAL A  33      42.970  77.434  -5.750  1.00  0.00           H  
ATOM    497 HG12 VAL A  33      43.848  76.173  -6.618  1.00  0.00           H  
ATOM    498 HG13 VAL A  33      42.816  77.298  -7.501  1.00  0.00           H  
ATOM    499 HG21 VAL A  33      40.270  77.187  -5.728  1.00  0.00           H  
ATOM    500 HG22 VAL A  33      40.475  77.139  -7.479  1.00  0.00           H  
ATOM    501 HG23 VAL A  33      39.628  75.831  -6.656  1.00  0.00           H  
ATOM    502  N   ASP A  34      40.495  74.457  -9.401  1.00  0.00           N  
ATOM    503  CA  ASP A  34      40.040  74.828 -10.735  1.00  0.00           C  
ATOM    504  C   ASP A  34      38.687  75.530 -10.672  1.00  0.00           C  
ATOM    505  O   ASP A  34      37.715  74.980 -10.156  1.00  0.00           O  
ATOM    506  CB  ASP A  34      39.946  73.590 -11.628  1.00  0.00           C  
ATOM    507  CG  ASP A  34      41.238  73.312 -12.369  1.00  0.00           C  
ATOM    508  OD1 ASP A  34      41.721  74.216 -13.085  1.00  0.00           O  
ATOM    509  OD2 ASP A  34      41.769  72.190 -12.235  1.00  0.00           O  
ATOM    510  H   ASP A  34      40.071  73.700  -8.944  1.00  0.00           H  
ATOM    511  HA  ASP A  34      40.765  75.509 -11.155  1.00  0.00           H  
ATOM    512  HB2 ASP A  34      39.711  72.731 -11.018  1.00  0.00           H  
ATOM    513  HB3 ASP A  34      39.160  73.737 -12.355  1.00  0.00           H  
ATOM    514  N   SER A  35      38.632  76.748 -11.202  1.00  0.00           N  
ATOM    515  CA  SER A  35      37.399  77.527 -11.202  1.00  0.00           C  
ATOM    516  C   SER A  35      36.483  77.094 -12.343  1.00  0.00           C  
ATOM    517  O   SER A  35      35.264  77.026 -12.183  1.00  0.00           O  
ATOM    518  CB  SER A  35      37.713  79.019 -11.322  1.00  0.00           C  
ATOM    519  OG  SER A  35      37.976  79.377 -12.668  1.00  0.00           O  
ATOM    520  H   SER A  35      39.441  77.133 -11.600  1.00  0.00           H  
ATOM    521  HA  SER A  35      36.895  77.348 -10.264  1.00  0.00           H  
ATOM    522  HB2 SER A  35      36.870  79.592 -10.968  1.00  0.00           H  
ATOM    523  HB3 SER A  35      38.582  79.251 -10.723  1.00  0.00           H  
ATOM    524  HG  SER A  35      37.241  79.889 -13.013  1.00  0.00           H  
ATOM    525  N   ALA A  36      37.079  76.805 -13.494  1.00  0.00           N  
ATOM    526  CA  ALA A  36      36.319  76.376 -14.662  1.00  0.00           C  
ATOM    527  C   ALA A  36      35.340  75.264 -14.303  1.00  0.00           C  
ATOM    528  O   ALA A  36      34.136  75.390 -14.519  1.00  0.00           O  
ATOM    529  CB  ALA A  36      37.260  75.919 -15.766  1.00  0.00           C  
ATOM    530  H   ALA A  36      38.054  76.879 -13.560  1.00  0.00           H  
ATOM    531  HA  ALA A  36      35.762  77.228 -15.027  1.00  0.00           H  
ATOM    532  HB1 ALA A  36      36.802  76.102 -16.728  1.00  0.00           H  
ATOM    533  HB2 ALA A  36      38.187  76.468 -15.699  1.00  0.00           H  
ATOM    534  HB3 ALA A  36      37.456  74.864 -15.656  1.00  0.00           H  
ATOM    535  N   ARG A  37      35.867  74.174 -13.754  1.00  0.00           N  
ATOM    536  CA  ARG A  37      35.040  73.038 -13.367  1.00  0.00           C  
ATOM    537  C   ARG A  37      34.599  73.157 -11.911  1.00  0.00           C  
ATOM    538  O   ARG A  37      33.951  72.260 -11.374  1.00  0.00           O  
ATOM    539  CB  ARG A  37      35.806  71.729 -13.574  1.00  0.00           C  
ATOM    540  CG  ARG A  37      35.774  71.225 -15.007  1.00  0.00           C  
ATOM    541  CD  ARG A  37      36.075  69.736 -15.081  1.00  0.00           C  
ATOM    542  NE  ARG A  37      34.975  68.929 -14.560  1.00  0.00           N  
ATOM    543  CZ  ARG A  37      34.902  67.609 -14.696  1.00  0.00           C  
ATOM    544  NH1 ARG A  37      35.862  66.952 -15.333  1.00  0.00           N  
ATOM    545  NH2 ARG A  37      33.869  66.945 -14.194  1.00  0.00           N  
ATOM    546  H   ARG A  37      36.836  74.132 -13.607  1.00  0.00           H  
ATOM    547  HA  ARG A  37      34.164  73.035 -13.997  1.00  0.00           H  
ATOM    548  HB2 ARG A  37      36.837  71.880 -13.291  1.00  0.00           H  
ATOM    549  HB3 ARG A  37      35.374  70.970 -12.938  1.00  0.00           H  
ATOM    550  HG2 ARG A  37      34.792  71.403 -15.420  1.00  0.00           H  
ATOM    551  HG3 ARG A  37      36.512  71.762 -15.583  1.00  0.00           H  
ATOM    552  HD2 ARG A  37      36.248  69.468 -16.113  1.00  0.00           H  
ATOM    553  HD3 ARG A  37      36.964  69.533 -14.502  1.00  0.00           H  
ATOM    554  HE  ARG A  37      34.255  69.395 -14.085  1.00  0.00           H  
ATOM    555 HH11 ARG A  37      36.642  67.451 -15.711  1.00  0.00           H  
ATOM    556 HH12 ARG A  37      35.806  65.958 -15.434  1.00  0.00           H  
ATOM    557 HH21 ARG A  37      33.145  67.437 -13.713  1.00  0.00           H  
ATOM    558 HH22 ARG A  37      33.816  65.952 -14.298  1.00  0.00           H  
ATOM    559  N   GLU A  38      34.959  74.270 -11.279  1.00  0.00           N  
ATOM    560  CA  GLU A  38      34.601  74.505  -9.885  1.00  0.00           C  
ATOM    561  C   GLU A  38      34.953  73.297  -9.021  1.00  0.00           C  
ATOM    562  O   GLU A  38      34.106  72.764  -8.305  1.00  0.00           O  
ATOM    563  CB  GLU A  38      33.107  74.814  -9.763  1.00  0.00           C  
ATOM    564  CG  GLU A  38      32.738  76.220 -10.207  1.00  0.00           C  
ATOM    565  CD  GLU A  38      31.423  76.692  -9.616  1.00  0.00           C  
ATOM    566  OE1 GLU A  38      30.376  76.098  -9.948  1.00  0.00           O  
ATOM    567  OE2 GLU A  38      31.442  77.655  -8.822  1.00  0.00           O  
ATOM    568  H   GLU A  38      35.475  74.949 -11.761  1.00  0.00           H  
ATOM    569  HA  GLU A  38      35.163  75.358  -9.537  1.00  0.00           H  
ATOM    570  HB2 GLU A  38      32.556  74.110 -10.370  1.00  0.00           H  
ATOM    571  HB3 GLU A  38      32.810  74.696  -8.732  1.00  0.00           H  
ATOM    572  HG2 GLU A  38      33.518  76.897  -9.898  1.00  0.00           H  
ATOM    573  HG3 GLU A  38      32.656  76.233 -11.285  1.00  0.00           H  
ATOM    574  N   VAL A  39      36.210  72.870  -9.096  1.00  0.00           N  
ATOM    575  CA  VAL A  39      36.676  71.727  -8.321  1.00  0.00           C  
ATOM    576  C   VAL A  39      37.998  72.034  -7.628  1.00  0.00           C  
ATOM    577  O   VAL A  39      38.549  73.126  -7.776  1.00  0.00           O  
ATOM    578  CB  VAL A  39      36.853  70.482  -9.211  1.00  0.00           C  
ATOM    579  CG1 VAL A  39      35.745  70.404 -10.249  1.00  0.00           C  
ATOM    580  CG2 VAL A  39      38.220  70.495  -9.879  1.00  0.00           C  
ATOM    581  H   VAL A  39      36.839  73.338  -9.685  1.00  0.00           H  
ATOM    582  HA  VAL A  39      35.930  71.505  -7.572  1.00  0.00           H  
ATOM    583  HB  VAL A  39      36.791  69.604  -8.585  1.00  0.00           H  
ATOM    584 HG11 VAL A  39      35.729  69.417 -10.686  1.00  0.00           H  
ATOM    585 HG12 VAL A  39      34.794  70.606  -9.777  1.00  0.00           H  
ATOM    586 HG13 VAL A  39      35.925  71.136 -11.024  1.00  0.00           H  
ATOM    587 HG21 VAL A  39      38.990  70.457  -9.123  1.00  0.00           H  
ATOM    588 HG22 VAL A  39      38.312  69.637 -10.530  1.00  0.00           H  
ATOM    589 HG23 VAL A  39      38.329  71.399 -10.459  1.00  0.00           H  
ATOM    590  N   CYS A  40      38.501  71.067  -6.870  1.00  0.00           N  
ATOM    591  CA  CYS A  40      39.760  71.234  -6.152  1.00  0.00           C  
ATOM    592  C   CYS A  40      40.487  69.900  -6.011  1.00  0.00           C  
ATOM    593  O   CYS A  40      39.975  68.962  -5.400  1.00  0.00           O  
ATOM    594  CB  CYS A  40      39.507  71.838  -4.771  1.00  0.00           C  
ATOM    595  SG  CYS A  40      38.825  73.513  -4.811  1.00  0.00           S  
ATOM    596  H   CYS A  40      38.016  70.219  -6.791  1.00  0.00           H  
ATOM    597  HA  CYS A  40      40.379  71.909  -6.723  1.00  0.00           H  
ATOM    598  HB2 CYS A  40      38.806  71.213  -4.235  1.00  0.00           H  
ATOM    599  HB3 CYS A  40      40.437  71.872  -4.225  1.00  0.00           H  
ATOM    600  HG  CYS A  40      39.753  74.342  -4.358  1.00  0.00           H  
ATOM    601  N   LEU A  41      41.684  69.822  -6.583  1.00  0.00           N  
ATOM    602  CA  LEU A  41      42.482  68.602  -6.524  1.00  0.00           C  
ATOM    603  C   LEU A  41      43.039  68.385  -5.121  1.00  0.00           C  
ATOM    604  O   LEU A  41      43.968  69.072  -4.697  1.00  0.00           O  
ATOM    605  CB  LEU A  41      43.628  68.670  -7.535  1.00  0.00           C  
ATOM    606  CG  LEU A  41      44.432  67.384  -7.724  1.00  0.00           C  
ATOM    607  CD1 LEU A  41      43.822  66.528  -8.824  1.00  0.00           C  
ATOM    608  CD2 LEU A  41      45.885  67.705  -8.041  1.00  0.00           C  
ATOM    609  H   LEU A  41      42.040  70.603  -7.057  1.00  0.00           H  
ATOM    610  HA  LEU A  41      41.838  67.773  -6.776  1.00  0.00           H  
ATOM    611  HB2 LEU A  41      43.209  68.941  -8.491  1.00  0.00           H  
ATOM    612  HB3 LEU A  41      44.310  69.443  -7.210  1.00  0.00           H  
ATOM    613  HG  LEU A  41      44.408  66.813  -6.806  1.00  0.00           H  
ATOM    614 HD11 LEU A  41      44.441  66.582  -9.706  1.00  0.00           H  
ATOM    615 HD12 LEU A  41      42.832  66.893  -9.055  1.00  0.00           H  
ATOM    616 HD13 LEU A  41      43.758  65.503  -8.488  1.00  0.00           H  
ATOM    617 HD21 LEU A  41      46.388  66.809  -8.373  1.00  0.00           H  
ATOM    618 HD22 LEU A  41      46.373  68.083  -7.153  1.00  0.00           H  
ATOM    619 HD23 LEU A  41      45.927  68.451  -8.820  1.00  0.00           H  
ATOM    620  N   VAL A  42      42.466  67.422  -4.405  1.00  0.00           N  
ATOM    621  CA  VAL A  42      42.907  67.110  -3.050  1.00  0.00           C  
ATOM    622  C   VAL A  42      43.695  65.807  -3.016  1.00  0.00           C  
ATOM    623  O   VAL A  42      43.455  64.903  -3.817  1.00  0.00           O  
ATOM    624  CB  VAL A  42      41.714  67.002  -2.083  1.00  0.00           C  
ATOM    625  CG1 VAL A  42      42.197  66.716  -0.669  1.00  0.00           C  
ATOM    626  CG2 VAL A  42      40.879  68.272  -2.123  1.00  0.00           C  
ATOM    627  H   VAL A  42      41.730  66.909  -4.798  1.00  0.00           H  
ATOM    628  HA  VAL A  42      43.544  67.915  -2.714  1.00  0.00           H  
ATOM    629  HB  VAL A  42      41.093  66.177  -2.400  1.00  0.00           H  
ATOM    630 HG11 VAL A  42      43.173  67.157  -0.527  1.00  0.00           H  
ATOM    631 HG12 VAL A  42      41.503  67.140   0.042  1.00  0.00           H  
ATOM    632 HG13 VAL A  42      42.260  65.648  -0.519  1.00  0.00           H  
ATOM    633 HG21 VAL A  42      40.898  68.685  -3.121  1.00  0.00           H  
ATOM    634 HG22 VAL A  42      39.858  68.043  -1.850  1.00  0.00           H  
ATOM    635 HG23 VAL A  42      41.283  68.993  -1.428  1.00  0.00           H  
ATOM    636  N   GLN A  43      44.637  65.715  -2.082  1.00  0.00           N  
ATOM    637  CA  GLN A  43      45.461  64.520  -1.944  1.00  0.00           C  
ATOM    638  C   GLN A  43      45.118  63.768  -0.662  1.00  0.00           C  
ATOM    639  O   GLN A  43      44.694  64.366   0.327  1.00  0.00           O  
ATOM    640  CB  GLN A  43      46.944  64.895  -1.946  1.00  0.00           C  
ATOM    641  CG  GLN A  43      47.859  63.761  -1.512  1.00  0.00           C  
ATOM    642  CD  GLN A  43      49.251  64.241  -1.149  1.00  0.00           C  
ATOM    643  OE1 GLN A  43      49.488  64.709  -0.035  1.00  0.00           O  
ATOM    644  NE2 GLN A  43      50.181  64.126  -2.089  1.00  0.00           N  
ATOM    645  H   GLN A  43      44.781  66.468  -1.473  1.00  0.00           H  
ATOM    646  HA  GLN A  43      45.260  63.879  -2.788  1.00  0.00           H  
ATOM    647  HB2 GLN A  43      47.226  65.194  -2.945  1.00  0.00           H  
ATOM    648  HB3 GLN A  43      47.094  65.727  -1.273  1.00  0.00           H  
ATOM    649  HG2 GLN A  43      47.426  63.276  -0.649  1.00  0.00           H  
ATOM    650  HG3 GLN A  43      47.939  63.051  -2.321  1.00  0.00           H  
ATOM    651 HE21 GLN A  43      49.920  63.744  -2.955  1.00  0.00           H  
ATOM    652 HE22 GLN A  43      51.089  64.429  -1.883  1.00  0.00           H  
ATOM    653  N   PHE A  44      45.301  62.451  -0.688  1.00  0.00           N  
ATOM    654  CA  PHE A  44      45.009  61.616   0.471  1.00  0.00           C  
ATOM    655  C   PHE A  44      46.293  61.051   1.072  1.00  0.00           C  
ATOM    656  O   PHE A  44      47.338  61.029   0.422  1.00  0.00           O  
ATOM    657  CB  PHE A  44      44.071  60.473   0.079  1.00  0.00           C  
ATOM    658  CG  PHE A  44      42.854  60.928  -0.674  1.00  0.00           C  
ATOM    659  CD1 PHE A  44      42.128  62.027  -0.245  1.00  0.00           C  
ATOM    660  CD2 PHE A  44      42.436  60.257  -1.814  1.00  0.00           C  
ATOM    661  CE1 PHE A  44      41.008  62.447  -0.937  1.00  0.00           C  
ATOM    662  CE2 PHE A  44      41.318  60.673  -2.510  1.00  0.00           C  
ATOM    663  CZ  PHE A  44      40.603  61.770  -2.071  1.00  0.00           C  
ATOM    664  H   PHE A  44      45.642  62.032  -1.506  1.00  0.00           H  
ATOM    665  HA  PHE A  44      44.522  62.234   1.209  1.00  0.00           H  
ATOM    666  HB2 PHE A  44      44.606  59.776  -0.547  1.00  0.00           H  
ATOM    667  HB3 PHE A  44      43.739  59.967   0.973  1.00  0.00           H  
ATOM    668  HD1 PHE A  44      42.444  62.559   0.639  1.00  0.00           H  
ATOM    669  HD2 PHE A  44      42.996  59.398  -2.158  1.00  0.00           H  
ATOM    670  HE1 PHE A  44      40.450  63.306  -0.593  1.00  0.00           H  
ATOM    671  HE2 PHE A  44      41.004  60.141  -3.395  1.00  0.00           H  
ATOM    672  HZ  PHE A  44      39.727  62.097  -2.613  1.00  0.00           H  
ATOM    673  N   GLU A  45      46.206  60.597   2.319  1.00  0.00           N  
ATOM    674  CA  GLU A  45      47.361  60.034   3.008  1.00  0.00           C  
ATOM    675  C   GLU A  45      48.032  58.959   2.158  1.00  0.00           C  
ATOM    676  O   GLU A  45      49.194  58.616   2.375  1.00  0.00           O  
ATOM    677  CB  GLU A  45      46.941  59.446   4.356  1.00  0.00           C  
ATOM    678  CG  GLU A  45      46.243  60.442   5.265  1.00  0.00           C  
ATOM    679  CD  GLU A  45      46.034  59.907   6.668  1.00  0.00           C  
ATOM    680  OE1 GLU A  45      45.733  58.702   6.806  1.00  0.00           O  
ATOM    681  OE2 GLU A  45      46.173  60.693   7.629  1.00  0.00           O  
ATOM    682  H   GLU A  45      45.346  60.642   2.786  1.00  0.00           H  
ATOM    683  HA  GLU A  45      48.066  60.833   3.179  1.00  0.00           H  
ATOM    684  HB2 GLU A  45      46.269  58.617   4.181  1.00  0.00           H  
ATOM    685  HB3 GLU A  45      47.821  59.081   4.865  1.00  0.00           H  
ATOM    686  HG2 GLU A  45      46.842  61.338   5.324  1.00  0.00           H  
ATOM    687  HG3 GLU A  45      45.279  60.684   4.841  1.00  0.00           H  
ATOM    688  N   ASP A  46      47.291  58.432   1.190  1.00  0.00           N  
ATOM    689  CA  ASP A  46      47.812  57.396   0.306  1.00  0.00           C  
ATOM    690  C   ASP A  46      48.318  58.001  -1.001  1.00  0.00           C  
ATOM    691  O   ASP A  46      48.044  57.483  -2.084  1.00  0.00           O  
ATOM    692  CB  ASP A  46      46.733  56.353   0.015  1.00  0.00           C  
ATOM    693  CG  ASP A  46      47.257  55.190  -0.806  1.00  0.00           C  
ATOM    694  OD1 ASP A  46      48.371  54.710  -0.509  1.00  0.00           O  
ATOM    695  OD2 ASP A  46      46.554  54.762  -1.745  1.00  0.00           O  
ATOM    696  H   ASP A  46      46.371  58.747   1.066  1.00  0.00           H  
ATOM    697  HA  ASP A  46      48.638  56.915   0.808  1.00  0.00           H  
ATOM    698  HB2 ASP A  46      46.353  55.967   0.949  1.00  0.00           H  
ATOM    699  HB3 ASP A  46      45.926  56.821  -0.531  1.00  0.00           H  
ATOM    700  N   ASP A  47      49.056  59.099  -0.891  1.00  0.00           N  
ATOM    701  CA  ASP A  47      49.601  59.775  -2.063  1.00  0.00           C  
ATOM    702  C   ASP A  47      48.597  59.765  -3.211  1.00  0.00           C  
ATOM    703  O   ASP A  47      48.976  59.826  -4.381  1.00  0.00           O  
ATOM    704  CB  ASP A  47      50.905  59.108  -2.504  1.00  0.00           C  
ATOM    705  CG  ASP A  47      51.984  59.192  -1.443  1.00  0.00           C  
ATOM    706  OD1 ASP A  47      52.177  60.289  -0.877  1.00  0.00           O  
ATOM    707  OD2 ASP A  47      52.638  58.160  -1.179  1.00  0.00           O  
ATOM    708  H   ASP A  47      49.241  59.464   0.000  1.00  0.00           H  
ATOM    709  HA  ASP A  47      49.806  60.800  -1.790  1.00  0.00           H  
ATOM    710  HB2 ASP A  47      50.715  58.065  -2.715  1.00  0.00           H  
ATOM    711  HB3 ASP A  47      51.265  59.592  -3.398  1.00  0.00           H  
ATOM    712  N   SER A  48      47.315  59.685  -2.869  1.00  0.00           N  
ATOM    713  CA  SER A  48      46.256  59.662  -3.871  1.00  0.00           C  
ATOM    714  C   SER A  48      45.760  61.074  -4.170  1.00  0.00           C  
ATOM    715  O   SER A  48      45.031  61.667  -3.377  1.00  0.00           O  
ATOM    716  CB  SER A  48      45.093  58.791  -3.395  1.00  0.00           C  
ATOM    717  OG  SER A  48      45.360  57.417  -3.615  1.00  0.00           O  
ATOM    718  H   SER A  48      47.076  59.640  -1.919  1.00  0.00           H  
ATOM    719  HA  SER A  48      46.665  59.238  -4.776  1.00  0.00           H  
ATOM    720  HB2 SER A  48      44.936  58.950  -2.338  1.00  0.00           H  
ATOM    721  HB3 SER A  48      44.198  59.063  -3.936  1.00  0.00           H  
ATOM    722  HG  SER A  48      45.541  56.988  -2.776  1.00  0.00           H  
ATOM    723  N   GLN A  49      46.162  61.603  -5.322  1.00  0.00           N  
ATOM    724  CA  GLN A  49      45.759  62.946  -5.726  1.00  0.00           C  
ATOM    725  C   GLN A  49      44.750  62.891  -6.868  1.00  0.00           C  
ATOM    726  O   GLN A  49      45.055  62.399  -7.956  1.00  0.00           O  
ATOM    727  CB  GLN A  49      46.981  63.762  -6.148  1.00  0.00           C  
ATOM    728  CG  GLN A  49      48.222  63.473  -5.319  1.00  0.00           C  
ATOM    729  CD  GLN A  49      49.468  64.128  -5.885  1.00  0.00           C  
ATOM    730  OE1 GLN A  49      49.391  64.952  -6.796  1.00  0.00           O  
ATOM    731  NE2 GLN A  49      50.626  63.762  -5.346  1.00  0.00           N  
ATOM    732  H   GLN A  49      46.743  61.081  -5.912  1.00  0.00           H  
ATOM    733  HA  GLN A  49      45.295  63.423  -4.876  1.00  0.00           H  
ATOM    734  HB2 GLN A  49      47.206  63.544  -7.181  1.00  0.00           H  
ATOM    735  HB3 GLN A  49      46.748  64.812  -6.052  1.00  0.00           H  
ATOM    736  HG2 GLN A  49      48.065  63.841  -4.317  1.00  0.00           H  
ATOM    737  HG3 GLN A  49      48.377  62.404  -5.289  1.00  0.00           H  
ATOM    738 HE21 GLN A  49      50.610  63.099  -4.624  1.00  0.00           H  
ATOM    739 HE22 GLN A  49      51.446  64.168  -5.693  1.00  0.00           H  
ATOM    740  N   PHE A  50      43.548  63.396  -6.615  1.00  0.00           N  
ATOM    741  CA  PHE A  50      42.494  63.404  -7.622  1.00  0.00           C  
ATOM    742  C   PHE A  50      41.723  64.720  -7.594  1.00  0.00           C  
ATOM    743  O   PHE A  50      41.967  65.577  -6.743  1.00  0.00           O  
ATOM    744  CB  PHE A  50      41.535  62.233  -7.396  1.00  0.00           C  
ATOM    745  CG  PHE A  50      40.838  61.778  -8.646  1.00  0.00           C  
ATOM    746  CD1 PHE A  50      41.549  61.173  -9.670  1.00  0.00           C  
ATOM    747  CD2 PHE A  50      39.473  61.953  -8.797  1.00  0.00           C  
ATOM    748  CE1 PHE A  50      40.910  60.754 -10.822  1.00  0.00           C  
ATOM    749  CE2 PHE A  50      38.828  61.536  -9.946  1.00  0.00           C  
ATOM    750  CZ  PHE A  50      39.548  60.934 -10.959  1.00  0.00           C  
ATOM    751  H   PHE A  50      43.366  63.774  -5.729  1.00  0.00           H  
ATOM    752  HA  PHE A  50      42.959  63.293  -8.590  1.00  0.00           H  
ATOM    753  HB2 PHE A  50      42.088  61.394  -7.001  1.00  0.00           H  
ATOM    754  HB3 PHE A  50      40.780  62.529  -6.682  1.00  0.00           H  
ATOM    755  HD1 PHE A  50      42.614  61.031  -9.562  1.00  0.00           H  
ATOM    756  HD2 PHE A  50      38.907  62.424  -8.004  1.00  0.00           H  
ATOM    757  HE1 PHE A  50      41.477  60.283 -11.612  1.00  0.00           H  
ATOM    758  HE2 PHE A  50      37.763  61.678 -10.051  1.00  0.00           H  
ATOM    759  HZ  PHE A  50      39.047  60.608 -11.858  1.00  0.00           H  
ATOM    760  N   LEU A  51      40.792  64.874  -8.530  1.00  0.00           N  
ATOM    761  CA  LEU A  51      39.985  66.086  -8.613  1.00  0.00           C  
ATOM    762  C   LEU A  51      38.698  65.940  -7.808  1.00  0.00           C  
ATOM    763  O   LEU A  51      37.811  65.168  -8.170  1.00  0.00           O  
ATOM    764  CB  LEU A  51      39.653  66.402 -10.073  1.00  0.00           C  
ATOM    765  CG  LEU A  51      40.791  66.991 -10.908  1.00  0.00           C  
ATOM    766  CD1 LEU A  51      40.433  66.972 -12.386  1.00  0.00           C  
ATOM    767  CD2 LEU A  51      41.109  68.407 -10.452  1.00  0.00           C  
ATOM    768  H   LEU A  51      40.643  64.156  -9.179  1.00  0.00           H  
ATOM    769  HA  LEU A  51      40.564  66.899  -8.201  1.00  0.00           H  
ATOM    770  HB2 LEU A  51      39.337  65.484 -10.546  1.00  0.00           H  
ATOM    771  HB3 LEU A  51      38.836  67.109 -10.080  1.00  0.00           H  
ATOM    772  HG  LEU A  51      41.678  66.387 -10.772  1.00  0.00           H  
ATOM    773 HD11 LEU A  51      40.465  67.978 -12.777  1.00  0.00           H  
ATOM    774 HD12 LEU A  51      39.439  66.569 -12.510  1.00  0.00           H  
ATOM    775 HD13 LEU A  51      41.141  66.354 -12.920  1.00  0.00           H  
ATOM    776 HD21 LEU A  51      40.199  68.986 -10.416  1.00  0.00           H  
ATOM    777 HD22 LEU A  51      41.798  68.862 -11.148  1.00  0.00           H  
ATOM    778 HD23 LEU A  51      41.556  68.376  -9.470  1.00  0.00           H  
ATOM    779  N   VAL A  52      38.603  66.690  -6.713  1.00  0.00           N  
ATOM    780  CA  VAL A  52      37.423  66.646  -5.858  1.00  0.00           C  
ATOM    781  C   VAL A  52      36.570  67.898  -6.035  1.00  0.00           C  
ATOM    782  O   VAL A  52      37.034  69.016  -5.810  1.00  0.00           O  
ATOM    783  CB  VAL A  52      37.812  66.509  -4.373  1.00  0.00           C  
ATOM    784  CG1 VAL A  52      36.578  66.256  -3.520  1.00  0.00           C  
ATOM    785  CG2 VAL A  52      38.834  65.397  -4.191  1.00  0.00           C  
ATOM    786  H   VAL A  52      39.344  67.287  -6.477  1.00  0.00           H  
ATOM    787  HA  VAL A  52      36.839  65.781  -6.137  1.00  0.00           H  
ATOM    788  HB  VAL A  52      38.260  67.438  -4.052  1.00  0.00           H  
ATOM    789 HG11 VAL A  52      36.678  66.778  -2.579  1.00  0.00           H  
ATOM    790 HG12 VAL A  52      35.701  66.613  -4.040  1.00  0.00           H  
ATOM    791 HG13 VAL A  52      36.480  65.196  -3.335  1.00  0.00           H  
ATOM    792 HG21 VAL A  52      38.497  64.724  -3.417  1.00  0.00           H  
ATOM    793 HG22 VAL A  52      38.944  64.854  -5.118  1.00  0.00           H  
ATOM    794 HG23 VAL A  52      39.784  65.825  -3.910  1.00  0.00           H  
ATOM    795  N   LEU A  53      35.320  67.701  -6.440  1.00  0.00           N  
ATOM    796  CA  LEU A  53      34.400  68.814  -6.648  1.00  0.00           C  
ATOM    797  C   LEU A  53      34.417  69.765  -5.456  1.00  0.00           C  
ATOM    798  O   LEU A  53      34.970  69.446  -4.403  1.00  0.00           O  
ATOM    799  CB  LEU A  53      32.980  68.291  -6.877  1.00  0.00           C  
ATOM    800  CG  LEU A  53      32.765  67.466  -8.146  1.00  0.00           C  
ATOM    801  CD1 LEU A  53      31.416  66.765  -8.105  1.00  0.00           C  
ATOM    802  CD2 LEU A  53      32.871  68.350  -9.380  1.00  0.00           C  
ATOM    803  H   LEU A  53      35.007  66.787  -6.605  1.00  0.00           H  
ATOM    804  HA  LEU A  53      34.722  69.352  -7.527  1.00  0.00           H  
ATOM    805  HB2 LEU A  53      32.716  67.673  -6.033  1.00  0.00           H  
ATOM    806  HB3 LEU A  53      32.317  69.144  -6.919  1.00  0.00           H  
ATOM    807  HG  LEU A  53      33.533  66.708  -8.209  1.00  0.00           H  
ATOM    808 HD11 LEU A  53      30.766  67.274  -7.410  1.00  0.00           H  
ATOM    809 HD12 LEU A  53      31.553  65.742  -7.787  1.00  0.00           H  
ATOM    810 HD13 LEU A  53      30.973  66.779  -9.090  1.00  0.00           H  
ATOM    811 HD21 LEU A  53      31.890  68.718  -9.645  1.00  0.00           H  
ATOM    812 HD22 LEU A  53      33.273  67.774 -10.202  1.00  0.00           H  
ATOM    813 HD23 LEU A  53      33.525  69.184  -9.172  1.00  0.00           H  
ATOM    814  N   TRP A  54      33.807  70.932  -5.628  1.00  0.00           N  
ATOM    815  CA  TRP A  54      33.751  71.929  -4.565  1.00  0.00           C  
ATOM    816  C   TRP A  54      32.736  71.531  -3.498  1.00  0.00           C  
ATOM    817  O   TRP A  54      32.973  71.710  -2.304  1.00  0.00           O  
ATOM    818  CB  TRP A  54      33.394  73.300  -5.141  1.00  0.00           C  
ATOM    819  CG  TRP A  54      34.559  74.001  -5.772  1.00  0.00           C  
ATOM    820  CD1 TRP A  54      35.803  73.484  -5.998  1.00  0.00           C  
ATOM    821  CD2 TRP A  54      34.588  75.348  -6.254  1.00  0.00           C  
ATOM    822  NE1 TRP A  54      36.604  74.429  -6.592  1.00  0.00           N  
ATOM    823  CE2 TRP A  54      35.882  75.581  -6.762  1.00  0.00           C  
ATOM    824  CE3 TRP A  54      33.648  76.380  -6.311  1.00  0.00           C  
ATOM    825  CZ2 TRP A  54      36.256  76.802  -7.314  1.00  0.00           C  
ATOM    826  CZ3 TRP A  54      34.021  77.593  -6.859  1.00  0.00           C  
ATOM    827  CH2 TRP A  54      35.316  77.795  -7.356  1.00  0.00           C  
ATOM    828  H   TRP A  54      33.385  71.128  -6.490  1.00  0.00           H  
ATOM    829  HA  TRP A  54      34.730  71.984  -4.111  1.00  0.00           H  
ATOM    830  HB2 TRP A  54      32.631  73.178  -5.894  1.00  0.00           H  
ATOM    831  HB3 TRP A  54      33.015  73.927  -4.347  1.00  0.00           H  
ATOM    832  HD1 TRP A  54      36.098  72.479  -5.740  1.00  0.00           H  
ATOM    833  HE1 TRP A  54      37.539  74.298  -6.854  1.00  0.00           H  
ATOM    834  HE3 TRP A  54      32.645  76.244  -5.932  1.00  0.00           H  
ATOM    835  HZ2 TRP A  54      37.250  76.974  -7.702  1.00  0.00           H  
ATOM    836  HZ3 TRP A  54      33.307  78.402  -6.910  1.00  0.00           H  
ATOM    837  HH2 TRP A  54      35.563  78.758  -7.776  1.00  0.00           H  
ATOM    838  N   LYS A  55      31.604  70.992  -3.938  1.00  0.00           N  
ATOM    839  CA  LYS A  55      30.553  70.568  -3.021  1.00  0.00           C  
ATOM    840  C   LYS A  55      30.970  69.314  -2.258  1.00  0.00           C  
ATOM    841  O   LYS A  55      30.710  69.190  -1.061  1.00  0.00           O  
ATOM    842  CB  LYS A  55      29.256  70.302  -3.789  1.00  0.00           C  
ATOM    843  CG  LYS A  55      29.426  69.354  -4.963  1.00  0.00           C  
ATOM    844  CD  LYS A  55      28.089  68.818  -5.446  1.00  0.00           C  
ATOM    845  CE  LYS A  55      28.271  67.694  -6.455  1.00  0.00           C  
ATOM    846  NZ  LYS A  55      28.388  68.212  -7.846  1.00  0.00           N  
ATOM    847  H   LYS A  55      31.473  70.875  -4.903  1.00  0.00           H  
ATOM    848  HA  LYS A  55      30.386  71.366  -2.314  1.00  0.00           H  
ATOM    849  HB2 LYS A  55      28.531  69.876  -3.111  1.00  0.00           H  
ATOM    850  HB3 LYS A  55      28.875  71.242  -4.164  1.00  0.00           H  
ATOM    851  HG2 LYS A  55      29.904  69.883  -5.774  1.00  0.00           H  
ATOM    852  HG3 LYS A  55      30.047  68.524  -4.657  1.00  0.00           H  
ATOM    853  HD2 LYS A  55      27.535  68.441  -4.599  1.00  0.00           H  
ATOM    854  HD3 LYS A  55      27.536  69.621  -5.911  1.00  0.00           H  
ATOM    855  HE2 LYS A  55      29.167  67.147  -6.206  1.00  0.00           H  
ATOM    856  HE3 LYS A  55      27.418  67.034  -6.396  1.00  0.00           H  
ATOM    857  HZ1 LYS A  55      29.300  68.695  -7.971  1.00  0.00           H  
ATOM    858  HZ2 LYS A  55      27.621  68.885  -8.043  1.00  0.00           H  
ATOM    859  HZ3 LYS A  55      28.328  67.427  -8.526  1.00  0.00           H  
ATOM    860  N   ASP A  56      31.617  68.389  -2.958  1.00  0.00           N  
ATOM    861  CA  ASP A  56      32.072  67.146  -2.345  1.00  0.00           C  
ATOM    862  C   ASP A  56      33.001  67.429  -1.169  1.00  0.00           C  
ATOM    863  O   ASP A  56      33.019  66.687  -0.187  1.00  0.00           O  
ATOM    864  CB  ASP A  56      32.788  66.275  -3.378  1.00  0.00           C  
ATOM    865  CG  ASP A  56      31.850  65.767  -4.456  1.00  0.00           C  
ATOM    866  OD1 ASP A  56      31.040  66.570  -4.965  1.00  0.00           O  
ATOM    867  OD2 ASP A  56      31.926  64.566  -4.790  1.00  0.00           O  
ATOM    868  H   ASP A  56      31.795  68.546  -3.909  1.00  0.00           H  
ATOM    869  HA  ASP A  56      31.203  66.618  -1.982  1.00  0.00           H  
ATOM    870  HB2 ASP A  56      33.568  66.855  -3.851  1.00  0.00           H  
ATOM    871  HB3 ASP A  56      33.229  65.425  -2.879  1.00  0.00           H  
ATOM    872  N   ILE A  57      33.773  68.506  -1.276  1.00  0.00           N  
ATOM    873  CA  ILE A  57      34.704  68.886  -0.221  1.00  0.00           C  
ATOM    874  C   ILE A  57      33.967  69.460   0.983  1.00  0.00           C  
ATOM    875  O   ILE A  57      33.008  70.217   0.834  1.00  0.00           O  
ATOM    876  CB  ILE A  57      35.730  69.920  -0.722  1.00  0.00           C  
ATOM    877  CG1 ILE A  57      36.541  69.345  -1.886  1.00  0.00           C  
ATOM    878  CG2 ILE A  57      36.650  70.345   0.413  1.00  0.00           C  
ATOM    879  CD1 ILE A  57      37.012  70.393  -2.870  1.00  0.00           C  
ATOM    880  H   ILE A  57      33.713  69.058  -2.083  1.00  0.00           H  
ATOM    881  HA  ILE A  57      35.238  67.998   0.086  1.00  0.00           H  
ATOM    882  HB  ILE A  57      35.192  70.792  -1.063  1.00  0.00           H  
ATOM    883 HG12 ILE A  57      37.411  68.841  -1.496  1.00  0.00           H  
ATOM    884 HG13 ILE A  57      35.929  68.635  -2.424  1.00  0.00           H  
ATOM    885 HG21 ILE A  57      36.140  71.063   1.039  1.00  0.00           H  
ATOM    886 HG22 ILE A  57      36.917  69.481   1.001  1.00  0.00           H  
ATOM    887 HG23 ILE A  57      37.543  70.794   0.004  1.00  0.00           H  
ATOM    888 HD11 ILE A  57      37.363  69.910  -3.770  1.00  0.00           H  
ATOM    889 HD12 ILE A  57      36.195  71.057  -3.109  1.00  0.00           H  
ATOM    890 HD13 ILE A  57      37.819  70.961  -2.429  1.00  0.00           H  
ATOM    891  N   SER A  58      34.422  69.095   2.178  1.00  0.00           N  
ATOM    892  CA  SER A  58      33.803  69.572   3.409  1.00  0.00           C  
ATOM    893  C   SER A  58      34.775  70.439   4.204  1.00  0.00           C  
ATOM    894  O   SER A  58      35.979  70.187   4.246  1.00  0.00           O  
ATOM    895  CB  SER A  58      33.340  68.390   4.264  1.00  0.00           C  
ATOM    896  OG  SER A  58      32.219  68.742   5.056  1.00  0.00           O  
ATOM    897  H   SER A  58      35.189  68.488   2.232  1.00  0.00           H  
ATOM    898  HA  SER A  58      32.945  70.170   3.140  1.00  0.00           H  
ATOM    899  HB2 SER A  58      33.066  67.570   3.619  1.00  0.00           H  
ATOM    900  HB3 SER A  58      34.145  68.084   4.915  1.00  0.00           H  
ATOM    901  HG  SER A  58      32.043  68.044   5.691  1.00  0.00           H  
ATOM    902  N   PRO A  59      34.240  71.485   4.851  1.00  0.00           N  
ATOM    903  CA  PRO A  59      35.042  72.410   5.658  1.00  0.00           C  
ATOM    904  C   PRO A  59      35.565  71.762   6.935  1.00  0.00           C  
ATOM    905  O   PRO A  59      34.817  71.111   7.664  1.00  0.00           O  
ATOM    906  CB  PRO A  59      34.056  73.533   5.993  1.00  0.00           C  
ATOM    907  CG  PRO A  59      32.713  72.893   5.919  1.00  0.00           C  
ATOM    908  CD  PRO A  59      32.812  71.844   4.846  1.00  0.00           C  
ATOM    909  HA  PRO A  59      35.871  72.812   5.095  1.00  0.00           H  
ATOM    910  HB2 PRO A  59      34.262  73.911   6.985  1.00  0.00           H  
ATOM    911  HB3 PRO A  59      34.154  74.330   5.271  1.00  0.00           H  
ATOM    912  HG2 PRO A  59      32.472  72.437   6.868  1.00  0.00           H  
ATOM    913  HG3 PRO A  59      31.970  73.630   5.655  1.00  0.00           H  
ATOM    914  HD2 PRO A  59      32.200  70.991   5.095  1.00  0.00           H  
ATOM    915  HD3 PRO A  59      32.523  72.254   3.890  1.00  0.00           H  
ATOM    916  N   ALA A  60      36.854  71.946   7.201  1.00  0.00           N  
ATOM    917  CA  ALA A  60      37.476  71.381   8.393  1.00  0.00           C  
ATOM    918  C   ALA A  60      37.770  72.465   9.425  1.00  0.00           C  
ATOM    919  O   ALA A  60      38.658  73.294   9.233  1.00  0.00           O  
ATOM    920  CB  ALA A  60      38.754  70.644   8.021  1.00  0.00           C  
ATOM    921  H   ALA A  60      37.399  72.475   6.583  1.00  0.00           H  
ATOM    922  HA  ALA A  60      36.789  70.666   8.822  1.00  0.00           H  
ATOM    923  HB1 ALA A  60      39.596  71.315   8.113  1.00  0.00           H  
ATOM    924  HB2 ALA A  60      38.890  69.802   8.685  1.00  0.00           H  
ATOM    925  HB3 ALA A  60      38.684  70.292   7.003  1.00  0.00           H  
ATOM    926  N   ALA A  61      37.016  72.452  10.520  1.00  0.00           N  
ATOM    927  CA  ALA A  61      37.196  73.432  11.583  1.00  0.00           C  
ATOM    928  C   ALA A  61      38.473  73.159  12.372  1.00  0.00           C  
ATOM    929  O   ALA A  61      38.745  72.022  12.758  1.00  0.00           O  
ATOM    930  CB  ALA A  61      35.991  73.433  12.511  1.00  0.00           C  
ATOM    931  H   ALA A  61      36.324  71.765  10.615  1.00  0.00           H  
ATOM    932  HA  ALA A  61      37.270  74.409  11.126  1.00  0.00           H  
ATOM    933  HB1 ALA A  61      35.527  74.408  12.496  1.00  0.00           H  
ATOM    934  HB2 ALA A  61      35.280  72.691  12.178  1.00  0.00           H  
ATOM    935  HB3 ALA A  61      36.310  73.200  13.516  1.00  0.00           H  
ATOM    936  N   LEU A  62      39.255  74.208  12.606  1.00  0.00           N  
ATOM    937  CA  LEU A  62      40.504  74.081  13.348  1.00  0.00           C  
ATOM    938  C   LEU A  62      40.268  74.258  14.844  1.00  0.00           C  
ATOM    939  O   LEU A  62      40.626  73.395  15.646  1.00  0.00           O  
ATOM    940  CB  LEU A  62      41.520  75.111  12.855  1.00  0.00           C  
ATOM    941  CG  LEU A  62      42.351  74.705  11.637  1.00  0.00           C  
ATOM    942  CD1 LEU A  62      43.097  75.905  11.075  1.00  0.00           C  
ATOM    943  CD2 LEU A  62      43.323  73.593  12.001  1.00  0.00           C  
ATOM    944  H   LEU A  62      38.985  75.089  12.273  1.00  0.00           H  
ATOM    945  HA  LEU A  62      40.894  73.089  13.173  1.00  0.00           H  
ATOM    946  HB2 LEU A  62      40.982  76.012  12.602  1.00  0.00           H  
ATOM    947  HB3 LEU A  62      42.202  75.317  13.667  1.00  0.00           H  
ATOM    948  HG  LEU A  62      41.689  74.333  10.866  1.00  0.00           H  
ATOM    949 HD11 LEU A  62      43.803  76.265  11.807  1.00  0.00           H  
ATOM    950 HD12 LEU A  62      42.393  76.688  10.838  1.00  0.00           H  
ATOM    951 HD13 LEU A  62      43.625  75.613  10.178  1.00  0.00           H  
ATOM    952 HD21 LEU A  62      42.769  72.715  12.301  1.00  0.00           H  
ATOM    953 HD22 LEU A  62      43.952  73.918  12.817  1.00  0.00           H  
ATOM    954 HD23 LEU A  62      43.937  73.356  11.145  1.00  0.00           H  
ATOM    955  N   SER A  63      39.663  75.383  15.215  1.00  0.00           N  
ATOM    956  CA  SER A  63      39.381  75.674  16.615  1.00  0.00           C  
ATOM    957  C   SER A  63      38.250  74.792  17.136  1.00  0.00           C  
ATOM    958  O   SER A  63      38.443  73.989  18.048  1.00  0.00           O  
ATOM    959  CB  SER A  63      39.014  77.149  16.787  1.00  0.00           C  
ATOM    960  OG  SER A  63      38.708  77.444  18.139  1.00  0.00           O  
ATOM    961  H   SER A  63      39.402  76.032  14.528  1.00  0.00           H  
ATOM    962  HA  SER A  63      40.275  75.466  17.183  1.00  0.00           H  
ATOM    963  HB2 SER A  63      39.845  77.763  16.477  1.00  0.00           H  
ATOM    964  HB3 SER A  63      38.152  77.376  16.177  1.00  0.00           H  
ATOM    965  HG  SER A  63      38.392  76.650  18.577  1.00  0.00           H  
ATOM    966  N   GLY A  64      37.068  74.949  16.550  1.00  0.00           N  
ATOM    967  CA  GLY A  64      35.922  74.162  16.967  1.00  0.00           C  
ATOM    968  C   GLY A  64      34.674  75.003  17.146  1.00  0.00           C  
ATOM    969  O   GLY A  64      34.556  76.100  16.598  1.00  0.00           O  
ATOM    970  H   GLY A  64      36.972  75.604  15.827  1.00  0.00           H  
ATOM    971  HA2 GLY A  64      35.728  73.404  16.222  1.00  0.00           H  
ATOM    972  HA3 GLY A  64      36.154  73.680  17.905  1.00  0.00           H  
ATOM    973  N   PRO A  65      33.713  74.486  17.926  1.00  0.00           N  
ATOM    974  CA  PRO A  65      32.450  75.181  18.192  1.00  0.00           C  
ATOM    975  C   PRO A  65      32.640  76.412  19.072  1.00  0.00           C  
ATOM    976  O   PRO A  65      32.523  76.336  20.295  1.00  0.00           O  
ATOM    977  CB  PRO A  65      31.612  74.127  18.920  1.00  0.00           C  
ATOM    978  CG  PRO A  65      32.611  73.215  19.545  1.00  0.00           C  
ATOM    979  CD  PRO A  65      33.787  73.185  18.609  1.00  0.00           C  
ATOM    980  HA  PRO A  65      31.954  75.468  17.276  1.00  0.00           H  
ATOM    981  HB2 PRO A  65      30.993  74.607  19.665  1.00  0.00           H  
ATOM    982  HB3 PRO A  65      30.990  73.603  18.209  1.00  0.00           H  
ATOM    983  HG2 PRO A  65      32.908  73.602  20.509  1.00  0.00           H  
ATOM    984  HG3 PRO A  65      32.189  72.227  19.650  1.00  0.00           H  
ATOM    985  HD2 PRO A  65      34.708  73.092  19.165  1.00  0.00           H  
ATOM    986  HD3 PRO A  65      33.687  72.373  17.904  1.00  0.00           H  
ATOM    987  N   SER A  66      32.933  77.545  18.442  1.00  0.00           N  
ATOM    988  CA  SER A  66      33.142  78.792  19.169  1.00  0.00           C  
ATOM    989  C   SER A  66      31.944  79.109  20.059  1.00  0.00           C  
ATOM    990  O   SER A  66      30.899  79.548  19.580  1.00  0.00           O  
ATOM    991  CB  SER A  66      33.384  79.943  18.191  1.00  0.00           C  
ATOM    992  OG  SER A  66      34.128  80.982  18.800  1.00  0.00           O  
ATOM    993  H   SER A  66      33.013  77.541  17.466  1.00  0.00           H  
ATOM    994  HA  SER A  66      34.016  78.670  19.791  1.00  0.00           H  
ATOM    995  HB2 SER A  66      33.932  79.577  17.336  1.00  0.00           H  
ATOM    996  HB3 SER A  66      32.433  80.341  17.865  1.00  0.00           H  
ATOM    997  HG  SER A  66      33.973  80.976  19.748  1.00  0.00           H  
ATOM    998  N   SER A  67      32.105  78.883  21.359  1.00  0.00           N  
ATOM    999  CA  SER A  67      31.036  79.141  22.318  1.00  0.00           C  
ATOM   1000  C   SER A  67      31.296  80.431  23.087  1.00  0.00           C  
ATOM   1001  O   SER A  67      32.444  80.800  23.333  1.00  0.00           O  
ATOM   1002  CB  SER A  67      30.904  77.969  23.293  1.00  0.00           C  
ATOM   1003  OG  SER A  67      30.203  76.889  22.701  1.00  0.00           O  
ATOM   1004  H   SER A  67      32.962  78.532  21.681  1.00  0.00           H  
ATOM   1005  HA  SER A  67      30.114  79.244  21.766  1.00  0.00           H  
ATOM   1006  HB2 SER A  67      31.888  77.630  23.579  1.00  0.00           H  
ATOM   1007  HB3 SER A  67      30.366  78.294  24.171  1.00  0.00           H  
ATOM   1008  HG  SER A  67      29.443  76.665  23.244  1.00  0.00           H  
ATOM   1009  N   GLY A  68      30.221  81.115  23.465  1.00  0.00           N  
ATOM   1010  CA  GLY A  68      30.353  82.358  24.203  1.00  0.00           C  
ATOM   1011  C   GLY A  68      29.526  83.478  23.604  1.00  0.00           C  
ATOM   1012  O   GLY A  68      29.249  84.478  24.267  1.00  0.00           O  
ATOM   1013  H   GLY A  68      29.330  80.774  23.241  1.00  0.00           H  
ATOM   1014  HA2 GLY A  68      30.034  82.194  25.222  1.00  0.00           H  
ATOM   1015  HA3 GLY A  68      31.392  82.654  24.204  1.00  0.00           H  
TER    1016      GLY A  68                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
