
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1058),  selected  138 , name 2z69_C
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 2z69_C.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     7_C      M       1           #
LGA    Q     8_C      H       2          2.569
LGA    Q     9_C      T       3          2.568
LGA    L    10_C      A       4          1.695
LGA    L    11_C      L       5          0.995
LGA    Q    12_C      I       6          0.569
LGA    S    13_C      N       7          1.660
LGA    H    14_C      H       8          2.057
LGA    H    15_C      -       -           -
LGA    L    16_C      I       9           #
LGA    F    17_C      R      10           #
LGA    E    18_C      K      11           #
LGA    -       -      F      12           -
LGA    P    19_C      I      13          4.526
LGA    L    20_C      F      14           -
LGA    -       -      L      15           -
LGA    -       -      T      16           -
LGA    -       -      D      17           -
LGA    -       -      E      18           -
LGA    S    21_C      D      19          2.116
LGA    P    22_C      A      20          2.518
LGA    V    23_C      G      21          4.785
LGA    Q    24_C      T      22          3.162
LGA    L    25_C      L      23          1.230
LGA    Q    26_C      S      24          3.874
LGA    E    27_C      -       -           -
LGA    L    28_C      -       -           -
LGA    L    29_C      -       -           -
LGA    A    30_C      A      25          3.225
LGA    S    31_C      F      26          4.575
LGA    S    32_C      F      27          3.062
LGA    D    33_C      Q      28          2.496
LGA    L    34_C      L      29          2.307
LGA    V    35_C      K      30          2.234
LGA    N    36_C      K      31          2.428
LGA    L    37_C      V      32          1.743
LGA    D    38_C      R      33          2.175
LGA    K    39_C      K      34          2.258
LGA    G    40_C      K      35          1.627
LGA    A    41_C      E      36          1.172
LGA    Y    42_C      T      37          0.930
LGA    V    43_C      L      38          1.527
LGA    F    44_C      L      39          1.398
LGA    R    45_C      K      40          1.214
LGA    Q    46_C      T      41          1.689
LGA    G    47_C      G      42          1.399
LGA    E    48_C      E      43          1.162
LGA    P    49_C      I      44          1.132
LGA    A    50_C      C      45          1.209
LGA    H    51_C      R      46          1.184
LGA    A    52_C      I      47          1.111
LGA    F    53_C      N      48          1.178
LGA    Y    54_C      Y      49          1.180
LGA    Y    55_C      F      50          1.906
LGA    L    56_C      V      51          1.833
LGA    I    57_C      V      52          2.241
LGA    S    58_C      K      53          2.144
LGA    G    59_C      G      54          2.382
LGA    C    60_C      C      55          2.162
LGA    V    61_C      L      56          1.778
LGA    K    62_C      R      57          1.565
LGA    I    63_C      L      58          1.048
LGA    Y    64_C      F      59          0.386
LGA    R    65_C      F      60          2.233
LGA    L    66_C      I      61          3.618
LGA    Q    71_C      D      62          1.725
LGA    -       -      E      63           -
LGA    -       -      K      64           -
LGA    -       -      G      65           -
LGA    -       -      I      66           -
LGA    E    72_C      E      67          3.029
LGA    K    73_C      Q      68          2.117
LGA    I    74_C      T      69          0.923
LGA    L    75_C      T      70          1.062
LGA    E    76_C      Q      71          0.996
LGA    V    77_C      F      72          1.781
LGA    T    78_C      A      73          1.895
LGA    N    79_C      I      74          1.222
LGA    E    80_C      E      75          2.390
LGA    R    81_C      N      76          3.159
LGA    N    82_C      W      77          2.273
LGA    T    83_C      W      78          2.058
LGA    F    84_C      L      79          1.265
LGA    A    85_C      S      80          1.183
LGA    E    86_C      D      81           #
LGA    A    87_C      Y      82          3.146
LGA    M    88_C      M      83          4.416
LGA    M    89_C      A      84           #
LGA    F    90_C      F      85           #
LGA    M    91_C      Q      86          3.885
LGA    D    92_C      K      87          2.979
LGA    T    93_C      Q      88           #
LGA    P    94_C      Q      89          1.652
LGA    N    95_C      P      90          2.495
LGA    Y    96_C      A      91          2.489
LGA    V    97_C      D      92          2.321
LGA    A    98_C      F      93          0.978
LGA    T    99_C      Y      94          0.495
LGA    A   100_C      I      95          1.147
LGA    Q   101_C      Q      96          1.255
LGA    A   102_C      S      97          1.526
LGA    V   103_C      V      98          2.398
LGA    V   104_C      E      99          2.439
LGA    P   105_C      N     100          2.311
LGA    S   106_C      C     101          2.298
LGA    Q   107_C      E     102          2.317
LGA    L   108_C      L     103          1.547
LGA    F   109_C      L     104          2.095
LGA    R   110_C      S     105          1.931
LGA    F   111_C      I     106          1.714
LGA    S   112_C      T     107          2.107
LGA    N   113_C      Y     108          2.065
LGA    K   114_C      T     109          1.321
LGA    A   115_C      E     110          1.283
LGA    Y   116_C      Q     111          1.495
LGA    L   117_C      E     112          1.078
LGA    R   118_C      N     113          0.400
LGA    Q   119_C      L     114          1.522
LGA    L   120_C      F     115          0.528
LGA    Q   121_C      E     116          1.725
LGA    D   122_C      R     117          3.648
LGA    N   123_C      I     118          3.674
LGA    T   124_C      P     119          3.698
LGA    P   125_C      A     120          3.025
LGA    L   126_C      L     121          2.044
LGA    A   127_C      E     122          1.561
LGA    L   128_C      R     123          2.745
LGA    A   129_C      Y     124          3.330
LGA    L   130_C      F     125          2.680
LGA    L   131_C      R     126          2.872
LGA    A   132_C      L     127          4.117
LGA    K   133_C      V     128          4.320
LGA    L   134_C      Y     129          3.746
LGA    S   135_C      Q     130          4.579
LGA    -       -      K     131           -
LGA    -       -      S     132           -
LGA    T   136_C      F     133          4.430
LGA    R   137_C      A     134          5.546
LGA    L   138_C      A     135           -
LGA    -       -      A     136           -
LGA    H   139_C      Q     137          6.000
LGA    Q   140_C      L     138           -
LGA    R   141_C      R     139           -
LGA    E   144_C      S     140           -
LGA    I   145_C      K     141           -
LGA    E   146_C      F     142           -
LGA    T   147_C      Q     143           -
LGA    L   148_C      H     144           -
LGA    S   149_C      M     145           -
LGA    L   150_C      Y     146           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  146    5.0    115    2.47    15.65     61.044     4.468

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.277132 * X  +  -0.857001 * Y  +  -0.434451 * Z  +  42.992043
  Y_new =  -0.931773 * X  +   0.129348 * Y  +   0.339216 * Z  +  72.429222
  Z_new =  -0.234513 * X  +   0.498818 * Y  +  -0.834377 * Z  +   8.020510 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.602768   -0.538824  [ DEG:   149.1276    -30.8724 ]
  Theta =   0.236718    2.904875  [ DEG:    13.5629    166.4371 ]
  Phi   =  -1.859889    1.281704  [ DEG:  -106.5638     73.4362 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2z69_C                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2z69_C.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  146   5.0  115   2.47   15.65  61.044
REMARK  ---------------------------------------------------------- 
MOLECULE 2z69_C
HEADER    TRANSCRIPTION REGULATOR                 24-JUL-07   2Z69              
TITLE     CRYSTAL STRUCTURE OF THE SENSOR DOMAIN OF THE                         
TITLE    2 TRANSCRIPTIONAL REGULATOR DNR FROM PSEUDOMONAS AERUGINOSA            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DNR PROTEIN;                                               
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: SENSOR DOMAIN;                                             
COMPND   5 SYNONYM: TRANSCRIPTIONAL REGULATOR DNR, DNR DISSIMILATIVE            
COMPND   6 NITRATE RESPIRATION REGULATOR;                                       
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 STRAIN: PAO1;                                                        
SOURCE   4 GENE: DNR;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B                                    
KEYWDS    BETA BARREL, DIMERIZATION HELIX, TRANSCRIPTION REGULATOR              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    G.GIARDINA,K.A.JOHNSON,A.DI MATTEO                                    
REVDAT   2   03-JUN-08 2Z69    1       JRNL                                     
REVDAT   1   18-MAR-08 2Z69    0                                                
JRNL        AUTH   G.GIARDINA,S.RINALDO,K.A.JOHNSON,A.DI MATTEO,                
JRNL        AUTH 2 M.BRUNORI,F.CUTRUZZOLA                                       
JRNL        TITL   NO SENSING IN PSEUDOMONAS AERUGINOSA: STRUCTURE OF           
JRNL        TITL 2 THE TRANSCRIPTIONAL REGULATOR DNR.                           
JRNL        REF    J.MOL.BIOL.                   V. 378  1002 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2Z69 A    1   151  UNP    Q51441   Q51441_PSEAE     1    151             
DBREF  2Z69 B    1   151  UNP    Q51441   Q51441_PSEAE     1    151             
DBREF  2Z69 C    1   151  UNP    Q51441   Q51441_PSEAE     1    151             
SEQRES   1 A  154  GLY SER HIS MET GLU PHE GLN ARG VAL HIS GLN GLN LEU          
SEQRES   2 A  154  LEU GLN SER HIS HIS LEU PHE GLU PRO LEU SER PRO VAL          
SEQRES   3 A  154  GLN LEU GLN GLU LEU LEU ALA SER SER ASP LEU VAL ASN          
SEQRES   4 A  154  LEU ASP LYS GLY ALA TYR VAL PHE ARG GLN GLY GLU PRO          
SEQRES   5 A  154  ALA HIS ALA PHE TYR TYR LEU ILE SER GLY CYS VAL LYS          
SEQRES   6 A  154  ILE TYR ARG LEU THR PRO GLU GLY GLN GLU LYS ILE LEU          
SEQRES   7 A  154  GLU VAL THR ASN GLU ARG ASN THR PHE ALA GLU ALA MET          
SEQRES   8 A  154  MET PHE MET ASP THR PRO ASN TYR VAL ALA THR ALA GLN          
SEQRES   9 A  154  ALA VAL VAL PRO SER GLN LEU PHE ARG PHE SER ASN LYS          
SEQRES  10 A  154  ALA TYR LEU ARG GLN LEU GLN ASP ASN THR PRO LEU ALA          
SEQRES  11 A  154  LEU ALA LEU LEU ALA LYS LEU SER THR ARG LEU HIS GLN          
SEQRES  12 A  154  ARG ILE ASP GLU ILE GLU THR LEU SER LEU LYS                  
SEQRES   1 B  154  GLY SER HIS MET GLU PHE GLN ARG VAL HIS GLN GLN LEU          
SEQRES   2 B  154  LEU GLN SER HIS HIS LEU PHE GLU PRO LEU SER PRO VAL          
SEQRES   3 B  154  GLN LEU GLN GLU LEU LEU ALA SER SER ASP LEU VAL ASN          
SEQRES   4 B  154  LEU ASP LYS GLY ALA TYR VAL PHE ARG GLN GLY GLU PRO          
SEQRES   5 B  154  ALA HIS ALA PHE TYR TYR LEU ILE SER GLY CYS VAL LYS          
SEQRES   6 B  154  ILE TYR ARG LEU THR PRO GLU GLY GLN GLU LYS ILE LEU          
SEQRES   7 B  154  GLU VAL THR ASN GLU ARG ASN THR PHE ALA GLU ALA MET          
SEQRES   8 B  154  MET PHE MET ASP THR PRO ASN TYR VAL ALA THR ALA GLN          
SEQRES   9 B  154  ALA VAL VAL PRO SER GLN LEU PHE ARG PHE SER ASN LYS          
SEQRES  10 B  154  ALA TYR LEU ARG GLN LEU GLN ASP ASN THR PRO LEU ALA          
SEQRES  11 B  154  LEU ALA LEU LEU ALA LYS LEU SER THR ARG LEU HIS GLN          
SEQRES  12 B  154  ARG ILE ASP GLU ILE GLU THR LEU SER LEU LYS                  
SEQRES   1 C  154  GLY SER HIS MET GLU PHE GLN ARG VAL HIS GLN GLN LEU          
SEQRES   2 C  154  LEU GLN SER HIS HIS LEU PHE GLU PRO LEU SER PRO VAL          
SEQRES   3 C  154  GLN LEU GLN GLU LEU LEU ALA SER SER ASP LEU VAL ASN          
SEQRES   4 C  154  LEU ASP LYS GLY ALA TYR VAL PHE ARG GLN GLY GLU PRO          
SEQRES   5 C  154  ALA HIS ALA PHE TYR TYR LEU ILE SER GLY CYS VAL LYS          
SEQRES   6 C  154  ILE TYR ARG LEU THR PRO GLU GLY GLN GLU LYS ILE LEU          
SEQRES   7 C  154  GLU VAL THR ASN GLU ARG ASN THR PHE ALA GLU ALA MET          
SEQRES   8 C  154  MET PHE MET ASP THR PRO ASN TYR VAL ALA THR ALA GLN          
SEQRES   9 C  154  ALA VAL VAL PRO SER GLN LEU PHE ARG PHE SER ASN LYS          
SEQRES  10 C  154  ALA TYR LEU ARG GLN LEU GLN ASP ASN THR PRO LEU ALA          
SEQRES  11 C  154  LEU ALA LEU LEU ALA LYS LEU SER THR ARG LEU HIS GLN          
SEQRES  12 C  154  ARG ILE ASP GLU ILE GLU THR LEU SER LEU LYS                  
FORMUL   4  HOH   *103(H2 O)                                                    
CRYST1   56.145  105.534   74.838  90.00  97.97  90.00 C 1 2 1      12          
ATOM   2310  N   HIS C   7       0.506  83.262   4.374  1.00 23.84           N  
ATOM   2311  CA  HIS C   7       1.267  84.305   5.111  1.00 23.66           C  
ATOM   2312  C   HIS C   7       0.974  84.248   6.611  1.00 23.97           C  
ATOM   2313  O   HIS C   7       1.837  84.560   7.425  1.00 23.90           O  
ATOM   2314  CB  HIS C   7       0.966  85.702   4.554  1.00 23.52           C  
ATOM   2315  CG  HIS C   7       1.038  85.795   3.057  1.00 22.90           C  
ATOM   2316  ND1 HIS C   7       0.130  86.522   2.315  1.00 21.26           N  
ATOM   2317  CD2 HIS C   7       1.900  85.250   2.165  1.00 20.77           C  
ATOM   2318  CE1 HIS C   7       0.433  86.426   1.033  1.00 20.47           C  
ATOM   2319  NE2 HIS C   7       1.504  85.662   0.915  1.00 20.22           N  
ATOM   2320  N   GLN C   8      -0.246  83.856   6.970  1.00 24.52           N  
ATOM   2321  CA  GLN C   8      -0.621  83.663   8.378  1.00 24.99           C  
ATOM   2322  C   GLN C   8      -0.753  82.173   8.715  1.00 25.35           C  
ATOM   2323  O   GLN C   8      -1.092  81.806   9.846  1.00 25.54           O  
ATOM   2324  CB  GLN C   8      -1.915  84.416   8.705  1.00 24.76           C  
ATOM   2325  N   GLN C   9      -0.481  81.332   7.715  1.00 25.66           N  
ATOM   2326  CA  GLN C   9      -0.525  79.869   7.829  1.00 25.92           C  
ATOM   2327  C   GLN C   9       0.432  79.229   6.817  1.00 26.02           C  
ATOM   2328  O   GLN C   9       0.916  78.108   7.027  1.00 26.61           O  
ATOM   2329  CB  GLN C   9      -1.957  79.337   7.638  1.00 25.58           C  
ATOM   2330  N   LEU C  10       0.685  79.947   5.718  1.00 25.53           N  
ATOM   2331  CA  LEU C  10       1.706  79.571   4.743  1.00 24.89           C  
ATOM   2332  C   LEU C  10       3.070  79.622   5.427  1.00 24.41           C  
ATOM   2333  O   LEU C  10       3.903  78.730   5.249  1.00 24.14           O  
ATOM   2334  CB  LEU C  10       1.671  80.522   3.538  1.00 25.05           C  
ATOM   2335  CG  LEU C  10       2.623  80.307   2.354  1.00 25.43           C  
ATOM   2336  CD1 LEU C  10       2.153  79.146   1.461  1.00 22.32           C  
ATOM   2337  CD2 LEU C  10       2.774  81.598   1.546  1.00 24.31           C  
ATOM   2338  N   LEU C  11       3.275  80.673   6.215  1.00 23.65           N  
ATOM   2339  CA  LEU C  11       4.451  80.804   7.055  1.00 23.25           C  
ATOM   2340  C   LEU C  11       4.356  79.889   8.269  1.00 24.33           C  
ATOM   2341  O   LEU C  11       5.377  79.454   8.790  1.00 25.09           O  
ATOM   2342  CB  LEU C  11       4.611  82.251   7.546  1.00 23.10           C  
ATOM   2343  CG  LEU C  11       4.813  83.418   6.578  1.00 19.36           C  
ATOM   2344  CD1 LEU C  11       4.955  84.718   7.366  1.00 21.02           C  
ATOM   2345  CD2 LEU C  11       6.016  83.203   5.700  1.00 10.39           C  
ATOM   2346  N   GLN C  12       3.136  79.601   8.721  1.00 24.64           N  
ATOM   2347  CA  GLN C  12       2.938  78.851   9.964  1.00 25.40           C  
ATOM   2348  C   GLN C  12       3.102  77.337   9.788  1.00 24.71           C  
ATOM   2349  O   GLN C  12       3.099  76.593  10.769  1.00 24.35           O  
ATOM   2350  CB  GLN C  12       1.584  79.192  10.608  1.00 25.59           C  
ATOM   2351  CG  GLN C  12       1.556  79.072  12.148  1.00 27.15           C  
ATOM   2352  CD  GLN C  12       0.200  79.434  12.767  1.00 27.32           C  
ATOM   2353  OE1 GLN C  12       0.138  79.991  13.867  1.00 31.42           O  
ATOM   2354  NE2 GLN C  12      -0.886  79.113  12.063  1.00 30.50           N  
ATOM   2355  N   SER C  13       3.238  76.891   8.541  1.00 24.43           N  
ATOM   2356  CA  SER C  13       3.635  75.510   8.258  1.00 24.24           C  
ATOM   2357  C   SER C  13       5.154  75.324   8.424  1.00 23.86           C  
ATOM   2358  O   SER C  13       5.633  74.221   8.723  1.00 24.02           O  
ATOM   2359  CB  SER C  13       3.178  75.087   6.854  1.00 23.96           C  
ATOM   2360  N   HIS C  14       5.898  76.415   8.246  1.00 23.28           N  
ATOM   2361  CA  HIS C  14       7.360  76.400   8.299  1.00 22.45           C  
ATOM   2362  C   HIS C  14       7.880  76.231   9.725  1.00 22.18           C  
ATOM   2363  O   HIS C  14       7.400  76.882  10.653  1.00 21.77           O  
ATOM   2364  CB  HIS C  14       7.934  77.666   7.647  1.00 22.31           C  
ATOM   2365  CG  HIS C  14       9.426  77.665   7.520  1.00 22.40           C  
ATOM   2366  ND1 HIS C  14      10.262  78.021   8.554  1.00 23.12           N  
ATOM   2367  CD2 HIS C  14      10.230  77.374   6.472  1.00 22.34           C  
ATOM   2368  CE1 HIS C  14      11.518  77.938   8.155  1.00 23.03           C  
ATOM   2369  NE2 HIS C  14      11.526  77.556   6.892  1.00 20.96           N  
ATOM   2370  N   HIS C  15       8.885  75.370   9.871  1.00 21.50           N  
ATOM   2371  CA  HIS C  15       9.423  74.991  11.179  1.00 21.92           C  
ATOM   2372  C   HIS C  15       9.796  76.128  12.129  1.00 22.13           C  
ATOM   2373  O   HIS C  15       9.908  75.897  13.330  1.00 22.81           O  
ATOM   2374  CB  HIS C  15      10.598  74.014  11.029  1.00 20.81           C  
ATOM   2375  CG  HIS C  15      11.658  74.483  10.083  1.00 22.78           C  
ATOM   2376  ND1 HIS C  15      12.799  75.131  10.505  1.00 22.94           N  
ATOM   2377  CD2 HIS C  15      11.751  74.395   8.733  1.00 20.96           C  
ATOM   2378  CE1 HIS C  15      13.551  75.418   9.457  1.00 23.68           C  
ATOM   2379  NE2 HIS C  15      12.937  74.985   8.370  1.00 21.43           N  
ATOM   2380  N   LEU C  16      10.029  77.333  11.604  1.00 22.26           N  
ATOM   2381  CA  LEU C  16      10.457  78.449  12.455  1.00 22.41           C  
ATOM   2382  C   LEU C  16       9.289  79.258  13.023  1.00 21.75           C  
ATOM   2383  O   LEU C  16       9.460  79.985  14.005  1.00 21.48           O  
ATOM   2384  CB  LEU C  16      11.469  79.374  11.731  1.00 22.76           C  
ATOM   2385  CG  LEU C  16      12.880  78.781  11.570  1.00 24.84           C  
ATOM   2386  CD1 LEU C  16      13.742  79.604  10.638  1.00 27.90           C  
ATOM   2387  CD2 LEU C  16      13.591  78.567  12.900  1.00 24.78           C  
ATOM   2388  N   PHE C  17       8.121  79.122  12.391  1.00 20.75           N  
ATOM   2389  CA  PHE C  17       6.908  79.843  12.759  1.00 20.80           C  
ATOM   2390  C   PHE C  17       5.832  78.893  13.293  1.00 20.59           C  
ATOM   2391  O   PHE C  17       4.992  79.282  14.112  1.00 20.35           O  
ATOM   2392  CB  PHE C  17       6.374  80.616  11.551  1.00 20.55           C  
ATOM   2393  CG  PHE C  17       7.428  81.400  10.822  1.00 22.88           C  
ATOM   2394  CD1 PHE C  17       7.900  80.971   9.580  1.00 21.65           C  
ATOM   2395  CD2 PHE C  17       7.966  82.558  11.383  1.00 22.84           C  
ATOM   2396  CE1 PHE C  17       8.861  81.683   8.898  1.00 21.59           C  
ATOM   2397  CE2 PHE C  17       8.959  83.281  10.703  1.00 23.24           C  
ATOM   2398  CZ  PHE C  17       9.404  82.835   9.458  1.00 21.21           C  
ATOM   2399  N   GLU C  18       5.872  77.653  12.804  1.00 20.32           N  
ATOM   2400  CA  GLU C  18       5.012  76.548  13.255  1.00 20.16           C  
ATOM   2401  C   GLU C  18       4.669  76.581  14.749  1.00 20.54           C  
ATOM   2402  O   GLU C  18       3.484  76.594  15.107  1.00 21.10           O  
ATOM   2403  CB  GLU C  18       5.646  75.196  12.865  1.00 19.38           C  
ATOM   2404  CG  GLU C  18       5.209  73.973  13.691  1.00 21.47           C  
ATOM   2405  CD  GLU C  18       3.805  73.500  13.366  1.00 24.65           C  
ATOM   2406  OE1 GLU C  18       3.185  74.067  12.439  1.00 26.14           O  
ATOM   2407  OE2 GLU C  18       3.319  72.558  14.036  1.00 24.55           O  
ATOM   2408  N   PRO C  19       5.692  76.578  15.630  1.00 20.79           N  
ATOM   2409  CA  PRO C  19       5.328  76.504  17.045  1.00 20.97           C  
ATOM   2410  C   PRO C  19       4.648  77.770  17.605  1.00 19.96           C  
ATOM   2411  O   PRO C  19       4.079  77.718  18.702  1.00 19.43           O  
ATOM   2412  CB  PRO C  19       6.673  76.223  17.740  1.00 21.54           C  
ATOM   2413  CG  PRO C  19       7.624  75.801  16.625  1.00 21.54           C  
ATOM   2414  CD  PRO C  19       7.157  76.587  15.456  1.00 21.33           C  
ATOM   2415  N   LEU C  20       4.677  78.877  16.857  1.00 19.24           N  
ATOM   2416  CA  LEU C  20       4.061  80.131  17.324  1.00 18.32           C  
ATOM   2417  C   LEU C  20       2.539  80.005  17.481  1.00 18.17           C  
ATOM   2418  O   LEU C  20       1.845  79.553  16.570  1.00 18.63           O  
ATOM   2419  CB  LEU C  20       4.397  81.314  16.398  1.00 17.69           C  
ATOM   2420  CG  LEU C  20       5.865  81.686  16.143  1.00 16.17           C  
ATOM   2421  CD1 LEU C  20       5.975  82.711  15.039  1.00  7.81           C  
ATOM   2422  CD2 LEU C  20       6.547  82.189  17.395  1.00 18.37           C  
ATOM   2423  N   SER C  21       2.037  80.385  18.652  1.00 17.55           N  
ATOM   2424  CA  SER C  21       0.604  80.585  18.840  1.00 17.46           C  
ATOM   2425  C   SER C  21       0.183  81.692  17.865  1.00 17.61           C  
ATOM   2426  O   SER C  21       1.019  82.516  17.482  1.00 17.60           O  
ATOM   2427  CB  SER C  21       0.314  81.001  20.282  1.00 17.17           C  
ATOM   2428  OG  SER C  21       0.726  82.338  20.533  1.00 16.96           O  
ATOM   2429  N   PRO C  22      -1.097  81.708  17.442  1.00 17.74           N  
ATOM   2430  CA  PRO C  22      -1.545  82.756  16.515  1.00 17.64           C  
ATOM   2431  C   PRO C  22      -1.334  84.187  17.035  1.00 17.79           C  
ATOM   2432  O   PRO C  22      -1.096  85.093  16.234  1.00 16.85           O  
ATOM   2433  CB  PRO C  22      -3.032  82.452  16.331  1.00 17.41           C  
ATOM   2434  CG  PRO C  22      -3.162  81.005  16.656  1.00 17.93           C  
ATOM   2435  CD  PRO C  22      -2.177  80.756  17.753  1.00 17.52           C  
ATOM   2436  N   VAL C  23      -1.430  84.378  18.353  1.00 18.10           N  
ATOM   2437  CA  VAL C  23      -1.129  85.671  18.983  1.00 18.16           C  
ATOM   2438  C   VAL C  23       0.312  86.063  18.653  1.00 18.48           C  
ATOM   2439  O   VAL C  23       0.563  87.150  18.113  1.00 17.93           O  
ATOM   2440  CB  VAL C  23      -1.304  85.624  20.524  1.00 18.26           C  
ATOM   2441  CG1 VAL C  23      -0.839  86.950  21.171  1.00 17.38           C  
ATOM   2442  CG2 VAL C  23      -2.750  85.305  20.899  1.00 18.93           C  
ATOM   2443  N   GLN C  24       1.241  85.154  18.968  1.00 17.88           N  
ATOM   2444  CA  GLN C  24       2.676  85.325  18.678  1.00 17.05           C  
ATOM   2445  C   GLN C  24       2.978  85.553  17.196  1.00 16.05           C  
ATOM   2446  O   GLN C  24       3.829  86.386  16.856  1.00 16.54           O  
ATOM   2447  CB  GLN C  24       3.483  84.141  19.238  1.00 15.85           C  
ATOM   2448  CG  GLN C  24       3.583  84.144  20.762  1.00 17.41           C  
ATOM   2449  CD  GLN C  24       3.955  82.779  21.347  1.00 17.56           C  
ATOM   2450  OE1 GLN C  24       4.363  81.859  20.630  1.00 20.50           O  
ATOM   2451  NE2 GLN C  24       3.818  82.649  22.648  1.00 10.67           N  
ATOM   2452  N   LEU C  25       2.278  84.836  16.315  1.00 15.46           N  
ATOM   2453  CA  LEU C  25       2.459  85.039  14.882  1.00 15.44           C  
ATOM   2454  C   LEU C  25       1.991  86.418  14.445  1.00 15.47           C  
ATOM   2455  O   LEU C  25       2.637  87.065  13.625  1.00 15.06           O  
ATOM   2456  CB  LEU C  25       1.773  83.963  14.044  1.00 15.79           C  
ATOM   2457  CG  LEU C  25       2.106  83.991  12.532  1.00 15.57           C  
ATOM   2458  CD1 LEU C  25       3.600  84.003  12.267  1.00 15.83           C  
ATOM   2459  CD2 LEU C  25       1.459  82.843  11.781  1.00 15.70           C  
ATOM   2460  N   GLN C  26       0.866  86.870  14.987  1.00 15.57           N  
ATOM   2461  CA  GLN C  26       0.384  88.191  14.600  1.00 16.62           C  
ATOM   2462  C   GLN C  26       1.355  89.262  15.084  1.00 16.33           C  
ATOM   2463  O   GLN C  26       1.719  90.163  14.324  1.00 15.22           O  
ATOM   2464  CB  GLN C  26      -1.063  88.437  15.057  1.00 15.99           C  
ATOM   2465  CG  GLN C  26      -2.116  87.732  14.180  1.00 16.62           C  
ATOM   2466  CD  GLN C  26      -1.778  87.731  12.681  1.00 19.12           C  
ATOM   2467  OE1 GLN C  26      -1.649  86.665  12.072  1.00 24.88           O  
ATOM   2468  NE2 GLN C  26      -1.634  88.923  12.087  1.00 15.12           N  
ATOM   2469  N   GLU C  27       1.819  89.113  16.326  1.00 17.19           N  
ATOM   2470  CA  GLU C  27       2.829  90.012  16.889  1.00 18.91           C  
ATOM   2471  C   GLU C  27       4.070  90.129  15.989  1.00 18.45           C  
ATOM   2472  O   GLU C  27       4.526  91.229  15.706  1.00 18.98           O  
ATOM   2473  CB  GLU C  27       3.221  89.578  18.311  1.00 18.61           C  
ATOM   2474  CG  GLU C  27       2.504  90.311  19.439  1.00 23.01           C  
ATOM   2475  CD  GLU C  27       2.835  91.812  19.512  1.00 32.72           C  
ATOM   2476  OE1 GLU C  27       3.862  92.251  18.940  1.00 37.14           O  
ATOM   2477  OE2 GLU C  27       2.058  92.561  20.148  1.00 37.18           O  
ATOM   2478  N   LEU C  28       4.588  88.983  15.537  1.00 19.22           N  
ATOM   2479  CA  LEU C  28       5.764  88.921  14.669  1.00 19.25           C  
ATOM   2480  C   LEU C  28       5.497  89.541  13.302  1.00 19.23           C  
ATOM   2481  O   LEU C  28       6.318  90.295  12.775  1.00 19.71           O  
ATOM   2482  CB  LEU C  28       6.216  87.468  14.493  1.00 18.47           C  
ATOM   2483  CG  LEU C  28       7.461  87.210  13.628  1.00 20.88           C  
ATOM   2484  CD1 LEU C  28       8.709  87.896  14.200  1.00 24.27           C  
ATOM   2485  CD2 LEU C  28       7.726  85.717  13.490  1.00 20.23           C  
ATOM   2486  N   LEU C  29       4.358  89.199  12.711  1.00 18.87           N  
ATOM   2487  CA  LEU C  29       4.009  89.743  11.407  1.00 19.01           C  
ATOM   2488  C   LEU C  29       3.776  91.259  11.459  1.00 18.05           C  
ATOM   2489  O   LEU C  29       3.933  91.936  10.443  1.00 18.18           O  
ATOM   2490  CB  LEU C  29       2.808  88.998  10.815  1.00 19.95           C  
ATOM   2491  CG  LEU C  29       3.125  87.684  10.095  1.00 21.00           C  
ATOM   2492  CD1 LEU C  29       1.952  86.713  10.173  1.00 21.16           C  
ATOM   2493  CD2 LEU C  29       3.496  87.970   8.641  1.00 24.77           C  
ATOM   2494  N   ALA C  30       3.441  91.802  12.632  1.00 16.96           N  
ATOM   2495  CA  ALA C  30       3.271  93.270  12.749  1.00 17.73           C  
ATOM   2496  C   ALA C  30       4.543  94.061  12.385  1.00 17.96           C  
ATOM   2497  O   ALA C  30       4.462  95.204  11.973  1.00 17.88           O  
ATOM   2498  CB  ALA C  30       2.767  93.666  14.135  1.00 16.31           C  
ATOM   2499  N   SER C  31       5.713  93.447  12.534  1.00 19.21           N  
ATOM   2500  CA  SER C  31       6.975  94.135  12.234  1.00 20.11           C  
ATOM   2501  C   SER C  31       7.630  93.610  10.966  1.00 20.83           C  
ATOM   2502  O   SER C  31       8.693  94.081  10.591  1.00 22.86           O  
ATOM   2503  CB  SER C  31       7.940  94.063  13.430  1.00 21.42           C  
ATOM   2504  OG  SER C  31       7.867  92.799  14.098  1.00 18.83           O  
ATOM   2505  N   SER C  32       6.982  92.654  10.304  1.00 21.02           N  
ATOM   2506  CA  SER C  32       7.471  92.042   9.061  1.00 21.82           C  
ATOM   2507  C   SER C  32       7.118  92.878   7.828  1.00 22.00           C  
ATOM   2508  O   SER C  32       6.260  93.756   7.897  1.00 21.95           O  
ATOM   2509  CB  SER C  32       6.853  90.671   8.866  1.00 20.73           C  
ATOM   2510  OG  SER C  32       7.052  89.888  10.013  1.00 26.58           O  
ATOM   2511  N   ASP C  33       7.752  92.568   6.697  1.00 22.51           N  
ATOM   2512  CA  ASP C  33       7.452  93.253   5.433  1.00 22.47           C  
ATOM   2513  C   ASP C  33       7.472  92.281   4.267  1.00 21.40           C  
ATOM   2514  O   ASP C  33       8.229  91.310   4.260  1.00 18.84           O  
ATOM   2515  CB  ASP C  33       8.461  94.369   5.158  1.00 22.86           C  
ATOM   2516  CG  ASP C  33       8.943  95.033   6.422  1.00 31.87           C  
ATOM   2517  OD1 ASP C  33       8.450  96.151   6.716  1.00 38.11           O  
ATOM   2518  OD2 ASP C  33       9.775  94.416   7.141  1.00 36.82           O  
ATOM   2519  N   LEU C  34       6.630  92.590   3.285  1.00 20.82           N  
ATOM   2520  CA  LEU C  34       6.630  91.994   1.961  1.00 21.29           C  
ATOM   2521  C   LEU C  34       7.552  92.822   1.050  1.00 21.42           C  
ATOM   2522  O   LEU C  34       7.336  94.021   0.857  1.00 20.92           O  
ATOM   2523  CB  LEU C  34       5.184  91.972   1.430  1.00 21.19           C  
ATOM   2524  CG  LEU C  34       4.722  91.167   0.210  1.00 22.52           C  
ATOM   2525  CD1 LEU C  34       4.845  91.985  -1.074  1.00 26.54           C  
ATOM   2526  CD2 LEU C  34       5.452  89.838   0.098  1.00 21.08           C  
ATOM   2527  N   VAL C  35       8.592  92.179   0.521  1.00 22.78           N  
ATOM   2528  CA  VAL C  35       9.557  92.822  -0.387  1.00 23.66           C  
ATOM   2529  C   VAL C  35       9.582  92.137  -1.771  1.00 23.44           C  
ATOM   2530  O   VAL C  35       9.559  90.913  -1.867  1.00 22.92           O  
ATOM   2531  CB  VAL C  35      11.018  92.859   0.201  1.00 24.13           C  
ATOM   2532  CG1 VAL C  35      11.844  93.917  -0.498  1.00 26.74           C  
ATOM   2533  CG2 VAL C  35      11.022  93.131   1.685  1.00 24.49           C  
ATOM   2534  N   ASN C  36       9.605  92.950  -2.828  1.00 23.72           N  
ATOM   2535  CA  ASN C  36       9.847  92.483  -4.194  1.00 24.98           C  
ATOM   2536  C   ASN C  36      11.265  92.773  -4.601  1.00 25.18           C  
ATOM   2537  O   ASN C  36      11.759  93.886  -4.414  1.00 25.45           O  
ATOM   2538  CB  ASN C  36       8.921  93.176  -5.203  1.00 24.63           C  
ATOM   2539  CG  ASN C  36       7.538  92.575  -5.225  1.00 28.54           C  
ATOM   2540  OD1 ASN C  36       7.338  91.434  -4.782  1.00 31.61           O  
ATOM   2541  ND2 ASN C  36       6.562  93.336  -5.738  1.00 29.66           N  
ATOM   2542  N   LEU C  37      11.907  91.770  -5.182  1.00 25.86           N  
ATOM   2543  CA  LEU C  37      13.266  91.925  -5.675  1.00 25.84           C  
ATOM   2544  C   LEU C  37      13.400  91.628  -7.163  1.00 26.24           C  
ATOM   2545  O   LEU C  37      12.894  90.624  -7.657  1.00 26.60           O  
ATOM   2546  CB  LEU C  37      14.221  91.069  -4.851  1.00 26.80           C  
ATOM   2547  CG  LEU C  37      14.517  91.592  -3.439  1.00 24.64           C  
ATOM   2548  CD1 LEU C  37      15.729  90.887  -2.909  1.00 28.85           C  
ATOM   2549  CD2 LEU C  37      14.736  93.119  -3.407  1.00 28.81           C  
ATOM   2550  N   ASP C  38      14.065  92.528  -7.874  1.00 25.89           N  
ATOM   2551  CA  ASP C  38      14.398  92.298  -9.269  1.00 25.73           C  
ATOM   2552  C   ASP C  38      15.585  91.339  -9.297  1.00 25.03           C  
ATOM   2553  O   ASP C  38      16.330  91.249  -8.322  1.00 23.56           O  
ATOM   2554  CB  ASP C  38      14.734  93.615  -9.971  1.00 25.72           C  
ATOM   2555  CG  ASP C  38      13.618  94.650  -9.848  1.00 27.56           C  
ATOM   2556  OD1 ASP C  38      13.270  95.051  -8.715  1.00 31.83           O  
ATOM   2557  OD2 ASP C  38      13.089  95.074 -10.885  1.00 25.09           O  
ATOM   2558  N   LYS C  39      15.722  90.599 -10.398  1.00 24.19           N  
ATOM   2559  CA  LYS C  39      16.876  89.728 -10.642  1.00 23.81           C  
ATOM   2560  C   LYS C  39      18.162  90.547 -10.508  1.00 22.25           C  
ATOM   2561  O   LYS C  39      18.303  91.592 -11.135  1.00 22.85           O  
ATOM   2562  CB  LYS C  39      16.748  89.082 -12.037  1.00 23.65           C  
ATOM   2563  CG  LYS C  39      18.039  88.605 -12.717  1.00 23.87           C  
ATOM   2564  CD  LYS C  39      17.727  88.155 -14.159  1.00 25.63           C  
ATOM   2565  CE  LYS C  39      18.924  88.321 -15.113  1.00 31.43           C  
ATOM   2566  NZ  LYS C  39      18.519  88.526 -16.558  1.00 31.56           N  
ATOM   2567  N   GLY C  40      19.081  90.079  -9.673  1.00 20.85           N  
ATOM   2568  CA  GLY C  40      20.335  90.784  -9.418  1.00 19.23           C  
ATOM   2569  C   GLY C  40      20.309  91.671  -8.194  1.00 18.43           C  
ATOM   2570  O   GLY C  40      21.359  92.140  -7.751  1.00 18.11           O  
ATOM   2571  N   ALA C  41      19.116  91.901  -7.643  1.00 17.78           N  
ATOM   2572  CA  ALA C  41      18.959  92.785  -6.488  1.00 18.24           C  
ATOM   2573  C   ALA C  41      19.554  92.187  -5.212  1.00 18.94           C  
ATOM   2574  O   ALA C  41      19.622  90.950  -5.044  1.00 19.63           O  
ATOM   2575  CB  ALA C  41      17.475  93.173  -6.280  1.00 17.88           C  
ATOM   2576  N   TYR C  42      20.013  93.063  -4.323  1.00 18.77           N  
ATOM   2577  CA  TYR C  42      20.579  92.618  -3.056  1.00 18.72           C  
ATOM   2578  C   TYR C  42      19.562  92.616  -1.938  1.00 19.82           C  
ATOM   2579  O   TYR C  42      18.803  93.576  -1.761  1.00 19.90           O  
ATOM   2580  CB  TYR C  42      21.816  93.412  -2.649  1.00 18.12           C  
ATOM   2581  CG  TYR C  42      22.987  93.232  -3.588  1.00 16.53           C  
ATOM   2582  CD1 TYR C  42      23.415  94.272  -4.423  1.00 17.66           C  
ATOM   2583  CD2 TYR C  42      23.662  92.029  -3.630  1.00 16.62           C  
ATOM   2584  CE1 TYR C  42      24.505  94.105  -5.286  1.00 16.77           C  
ATOM   2585  CE2 TYR C  42      24.727  91.822  -4.482  1.00 18.86           C  
ATOM   2586  CZ  TYR C  42      25.157  92.851  -5.305  1.00 25.22           C  
ATOM   2587  OH  TYR C  42      26.231  92.584  -6.128  1.00 23.33           O  
ATOM   2588  N   VAL C  43      19.556  91.509  -1.200  1.00 20.55           N  
ATOM   2589  CA  VAL C  43      18.781  91.382   0.027  1.00 22.26           C  
ATOM   2590  C   VAL C  43      19.581  92.064   1.119  1.00 22.66           C  
ATOM   2591  O   VAL C  43      19.136  93.074   1.704  1.00 23.54           O  
ATOM   2592  CB  VAL C  43      18.552  89.904   0.376  1.00 22.24           C  
ATOM   2593  CG1 VAL C  43      17.540  89.782   1.534  1.00 24.94           C  
ATOM   2594  CG2 VAL C  43      18.064  89.182  -0.846  1.00 22.66           C  
ATOM   2595  N   PHE C  44      20.780  91.535   1.359  1.00 21.79           N  
ATOM   2596  CA  PHE C  44      21.720  92.157   2.293  1.00 21.20           C  
ATOM   2597  C   PHE C  44      23.154  91.976   1.839  1.00 21.38           C  
ATOM   2598  O   PHE C  44      23.413  91.207   0.914  1.00 20.57           O  
ATOM   2599  CB  PHE C  44      21.526  91.639   3.717  1.00 21.68           C  
ATOM   2600  CG  PHE C  44      21.603  90.128   3.870  1.00 18.29           C  
ATOM   2601  CD1 PHE C  44      20.453  89.382   4.110  1.00 13.17           C  
ATOM   2602  CD2 PHE C  44      22.834  89.471   3.851  1.00 14.60           C  
ATOM   2603  CE1 PHE C  44      20.545  88.026   4.317  1.00 20.22           C  
ATOM   2604  CE2 PHE C  44      22.932  88.117   4.045  1.00 17.23           C  
ATOM   2605  CZ  PHE C  44      21.792  87.376   4.258  1.00 18.64           C  
ATOM   2606  N   ARG C  45      24.073  92.682   2.496  1.00 22.33           N  
ATOM   2607  CA  ARG C  45      25.503  92.679   2.132  1.00 22.39           C  
ATOM   2608  C   ARG C  45      26.363  92.240   3.297  1.00 21.72           C  
ATOM   2609  O   ARG C  45      26.020  92.495   4.439  1.00 22.01           O  
ATOM   2610  CB  ARG C  45      25.954  94.063   1.667  1.00 22.62           C  
ATOM   2611  CG  ARG C  45      25.849  94.282   0.176  1.00 24.80           C  
ATOM   2612  CD  ARG C  45      24.764  95.275  -0.165  1.00 28.68           C  
ATOM   2613  NE  ARG C  45      25.127  96.072  -1.341  1.00 34.02           N  
ATOM   2614  CZ  ARG C  45      24.288  96.865  -1.998  1.00 33.06           C  
ATOM   2615  NH1 ARG C  45      23.027  96.959  -1.599  1.00 29.98           N  
ATOM   2616  NH2 ARG C  45      24.703  97.555  -3.057  1.00 32.94           N  
ATOM   2617  N   GLN C  46      27.478  91.570   3.012  1.00 21.80           N  
ATOM   2618  CA  GLN C  46      28.432  91.252   4.059  1.00 21.45           C  
ATOM   2619  C   GLN C  46      28.925  92.588   4.553  1.00 22.31           C  
ATOM   2620  O   GLN C  46      29.149  93.505   3.755  1.00 22.47           O  
ATOM   2621  CB  GLN C  46      29.611  90.436   3.525  1.00 21.26           C  
ATOM   2622  CG  GLN C  46      30.481  89.794   4.610  1.00 20.07           C  
ATOM   2623  CD  GLN C  46      31.736  89.140   4.057  1.00 22.30           C  
ATOM   2624  OE1 GLN C  46      32.530  89.777   3.363  1.00 26.11           O  
ATOM   2625  NE2 GLN C  46      31.933  87.866   4.383  1.00 25.79           N  
ATOM   2626  N   GLY C  47      29.085  92.696   5.866  1.00 23.01           N  
ATOM   2627  CA  GLY C  47      29.427  93.966   6.493  1.00 23.49           C  
ATOM   2628  C   GLY C  47      28.207  94.690   7.030  1.00 23.49           C  
ATOM   2629  O   GLY C  47      28.274  95.297   8.080  1.00 24.89           O  
ATOM   2630  N   GLU C  48      27.093  94.620   6.303  1.00 24.23           N  
ATOM   2631  CA  GLU C  48      25.848  95.310   6.659  1.00 25.17           C  
ATOM   2632  C   GLU C  48      25.318  94.920   8.049  1.00 24.15           C  
ATOM   2633  O   GLU C  48      25.352  93.735   8.407  1.00 25.19           O  
ATOM   2634  CB  GLU C  48      24.781  95.044   5.585  1.00 24.85           C  
ATOM   2635  CG  GLU C  48      23.443  95.744   5.833  1.00 25.99           C  
ATOM   2636  CD  GLU C  48      22.418  95.455   4.760  1.00 28.41           C  
ATOM   2637  OE1 GLU C  48      22.803  94.994   3.668  1.00 33.40           O  
ATOM   2638  OE2 GLU C  48      21.217  95.697   5.002  1.00 37.71           O  
ATOM   2639  N   PRO C  49      24.828  95.911   8.831  1.00 23.00           N  
ATOM   2640  CA  PRO C  49      24.241  95.611  10.147  1.00 22.30           C  
ATOM   2641  C   PRO C  49      23.090  94.601  10.042  1.00 21.62           C  
ATOM   2642  O   PRO C  49      22.192  94.792   9.217  1.00 20.97           O  
ATOM   2643  CB  PRO C  49      23.730  96.979  10.622  1.00 22.77           C  
ATOM   2644  CG  PRO C  49      24.595  97.980   9.894  1.00 22.74           C  
ATOM   2645  CD  PRO C  49      24.804  97.360   8.539  1.00 23.36           C  
ATOM   2646  N   ALA C  50      23.134  93.555  10.873  1.00 20.86           N  
ATOM   2647  CA  ALA C  50      22.296  92.345  10.716  1.00 20.04           C  
ATOM   2648  C   ALA C  50      21.102  92.330  11.640  1.00 20.44           C  
ATOM   2649  O   ALA C  50      21.237  91.948  12.792  1.00 20.98           O  
ATOM   2650  CB  ALA C  50      23.137  91.097  10.954  1.00 20.02           C  
ATOM   2651  N   HIS C  51      19.932  92.729  11.134  1.00 20.04           N  
ATOM   2652  CA  HIS C  51      18.748  92.930  11.985  1.00 19.38           C  
ATOM   2653  C   HIS C  51      17.558  92.136  11.547  1.00 18.52           C  
ATOM   2654  O   HIS C  51      16.527  92.161  12.205  1.00 18.97           O  
ATOM   2655  CB  HIS C  51      18.363  94.399  12.050  1.00 19.24           C  
ATOM   2656  CG  HIS C  51      19.352  95.225  12.796  1.00 22.90           C  
ATOM   2657  ND1 HIS C  51      19.615  95.033  14.136  1.00 27.46           N  
ATOM   2658  CD2 HIS C  51      20.166  96.228  12.388  1.00 22.58           C  
ATOM   2659  CE1 HIS C  51      20.553  95.880  14.519  1.00 22.91           C  
ATOM   2660  NE2 HIS C  51      20.909  96.608  13.474  1.00 19.68           N  
ATOM   2661  N   ALA C  52      17.711  91.415  10.447  1.00 17.00           N  
ATOM   2662  CA  ALA C  52      16.581  90.765   9.831  1.00 17.41           C  
ATOM   2663  C   ALA C  52      17.010  89.421   9.339  1.00 17.38           C  
ATOM   2664  O   ALA C  52      18.206  89.226   9.056  1.00 16.79           O  
ATOM   2665  CB  ALA C  52      16.083  91.600   8.680  1.00 18.01           C  
ATOM   2666  N   PHE C  53      16.050  88.488   9.300  1.00 17.39           N  
ATOM   2667  CA  PHE C  53      16.159  87.286   8.502  1.00 17.46           C  
ATOM   2668  C   PHE C  53      14.963  87.234   7.551  1.00 18.07           C  
ATOM   2669  O   PHE C  53      14.098  88.122   7.591  1.00 17.10           O  
ATOM   2670  CB  PHE C  53      16.279  86.031   9.372  1.00 18.88           C  
ATOM   2671  CG  PHE C  53      15.028  85.681  10.133  1.00 22.61           C  
ATOM   2672  CD1 PHE C  53      14.673  86.379  11.288  1.00 23.32           C  
ATOM   2673  CD2 PHE C  53      14.228  84.624   9.720  1.00 26.06           C  
ATOM   2674  CE1 PHE C  53      13.538  86.028  12.010  1.00 24.79           C  
ATOM   2675  CE2 PHE C  53      13.090  84.284  10.438  1.00 23.58           C  
ATOM   2676  CZ  PHE C  53      12.754  84.983  11.588  1.00 22.61           C  
ATOM   2677  N   TYR C  54      14.896  86.206   6.701  1.00 16.87           N  
ATOM   2678  CA  TYR C  54      14.047  86.301   5.515  1.00 17.55           C  
ATOM   2679  C   TYR C  54      13.393  85.002   5.186  1.00 18.29           C  
ATOM   2680  O   TYR C  54      13.971  83.970   5.409  1.00 18.94           O  
ATOM   2681  CB  TYR C  54      14.903  86.726   4.306  1.00 16.67           C  
ATOM   2682  CG  TYR C  54      15.390  88.124   4.422  1.00 17.88           C  
ATOM   2683  CD1 TYR C  54      16.610  88.427   5.036  1.00 21.79           C  
ATOM   2684  CD2 TYR C  54      14.605  89.172   3.948  1.00 16.68           C  
ATOM   2685  CE1 TYR C  54      17.026  89.762   5.154  1.00 18.27           C  
ATOM   2686  CE2 TYR C  54      15.012  90.475   4.054  1.00 14.88           C  
ATOM   2687  CZ  TYR C  54      16.204  90.768   4.652  1.00 17.73           C  
ATOM   2688  OH  TYR C  54      16.534  92.099   4.725  1.00 23.16           O  
ATOM   2689  N   TYR C  55      12.176  85.083   4.662  1.00 18.50           N  
ATOM   2690  CA  TYR C  55      11.469  83.942   4.137  1.00 19.10           C  
ATOM   2691  C   TYR C  55      11.276  84.145   2.662  1.00 18.31           C  
ATOM   2692  O   TYR C  55      10.659  85.115   2.254  1.00 17.02           O  
ATOM   2693  CB  TYR C  55      10.098  83.806   4.762  1.00 17.67           C  
ATOM   2694  CG  TYR C  55       9.328  82.624   4.236  1.00 20.62           C  
ATOM   2695  CD1 TYR C  55       8.438  82.751   3.160  1.00 22.28           C  
ATOM   2696  CD2 TYR C  55       9.468  81.368   4.822  1.00 17.76           C  
ATOM   2697  CE1 TYR C  55       7.717  81.637   2.682  1.00 20.40           C  
ATOM   2698  CE2 TYR C  55       8.745  80.282   4.367  1.00 20.51           C  
ATOM   2699  CZ  TYR C  55       7.881  80.414   3.305  1.00 18.73           C  
ATOM   2700  OH  TYR C  55       7.189  79.290   2.884  1.00 21.19           O  
ATOM   2701  N   LEU C  56      11.780  83.200   1.881  1.00 19.11           N  
ATOM   2702  CA  LEU C  56      11.686  83.278   0.432  1.00 19.50           C  
ATOM   2703  C   LEU C  56      10.365  82.653  -0.030  1.00 19.80           C  
ATOM   2704  O   LEU C  56      10.147  81.466   0.164  1.00 19.46           O  
ATOM   2705  CB  LEU C  56      12.898  82.588  -0.203  1.00 19.34           C  
ATOM   2706  CG  LEU C  56      12.985  82.550  -1.738  1.00 19.63           C  
ATOM   2707  CD1 LEU C  56      13.209  83.950  -2.295  1.00 19.90           C  
ATOM   2708  CD2 LEU C  56      14.136  81.666  -2.115  1.00 21.51           C  
ATOM   2709  N   ILE C  57       9.485  83.469  -0.610  1.00 21.14           N  
ATOM   2710  CA  ILE C  57       8.153  83.027  -1.059  1.00 20.30           C  
ATOM   2711  C   ILE C  57       8.285  82.468  -2.469  1.00 20.98           C  
ATOM   2712  O   ILE C  57       7.651  81.457  -2.825  1.00 20.78           O  
ATOM   2713  CB  ILE C  57       7.101  84.194  -1.060  1.00 19.91           C  
ATOM   2714  CG1 ILE C  57       6.997  84.890   0.302  1.00 20.76           C  
ATOM   2715  CG2 ILE C  57       5.711  83.692  -1.457  1.00 21.73           C  
ATOM   2716  CD1 ILE C  57       6.569  86.375   0.207  1.00 20.01           C  
ATOM   2717  N   SER C  58       9.101  83.146  -3.276  1.00 21.01           N  
ATOM   2718  CA  SER C  58       9.359  82.746  -4.659  1.00 20.09           C  
ATOM   2719  C   SER C  58      10.622  83.415  -5.168  1.00 19.32           C  
ATOM   2720  O   SER C  58      10.924  84.551  -4.811  1.00 18.32           O  
ATOM   2721  CB  SER C  58       8.176  83.107  -5.574  1.00 20.87           C  
ATOM   2722  OG  SER C  58       8.115  84.503  -5.853  1.00 22.01           O  
ATOM   2723  N   GLY C  59      11.333  82.697  -6.027  1.00 19.91           N  
ATOM   2724  CA  GLY C  59      12.568  83.160  -6.639  1.00 19.78           C  
ATOM   2725  C   GLY C  59      13.698  82.269  -6.157  1.00 19.51           C  
ATOM   2726  O   GLY C  59      13.476  81.108  -5.808  1.00 20.42           O  
ATOM   2727  N   CYS C  60      14.902  82.819  -6.141  1.00 18.34           N  
ATOM   2728  CA  CYS C  60      16.111  82.094  -5.768  1.00 18.33           C  
ATOM   2729  C   CYS C  60      17.160  83.095  -5.317  1.00 17.73           C  
ATOM   2730  O   CYS C  60      17.384  84.110  -5.985  1.00 16.95           O  
ATOM   2731  CB  CYS C  60      16.650  81.262  -6.953  1.00 19.25           C  
ATOM   2732  SG  CYS C  60      18.242  80.424  -6.615  1.00 18.58           S  
ATOM   2733  N   VAL C  61      17.772  82.816  -4.161  1.00 17.92           N  
ATOM   2734  CA  VAL C  61      18.792  83.675  -3.569  1.00 16.62           C  
ATOM   2735  C   VAL C  61      20.100  82.897  -3.328  1.00 18.25           C  
ATOM   2736  O   VAL C  61      20.093  81.766  -2.816  1.00 18.29           O  
ATOM   2737  CB  VAL C  61      18.304  84.335  -2.248  1.00 18.56           C  
ATOM   2738  CG1 VAL C  61      19.444  85.126  -1.525  1.00 13.39           C  
ATOM   2739  CG2 VAL C  61      17.084  85.243  -2.474  1.00 14.31           C  
ATOM   2740  N   LYS C  62      21.220  83.499  -3.704  1.00 17.27           N  
ATOM   2741  CA  LYS C  62      22.508  82.918  -3.402  1.00 17.25           C  
ATOM   2742  C   LYS C  62      23.202  83.685  -2.290  1.00 19.22           C  
ATOM   2743  O   LYS C  62      23.072  84.921  -2.172  1.00 19.69           O  
ATOM   2744  CB  LYS C  62      23.395  82.817  -4.644  1.00 17.36           C  
ATOM   2745  CG  LYS C  62      23.950  84.104  -5.185  1.00 14.23           C  
ATOM   2746  CD  LYS C  62      25.073  83.802  -6.200  1.00 17.11           C  
ATOM   2747  CE  LYS C  62      25.460  85.054  -7.006  1.00 22.03           C  
ATOM   2748  NZ  LYS C  62      26.620  84.816  -7.927  1.00 21.15           N  
ATOM   2749  N   ILE C  63      23.931  82.947  -1.467  1.00 19.71           N  
ATOM   2750  CA  ILE C  63      24.595  83.543  -0.308  1.00 20.94           C  
ATOM   2751  C   ILE C  63      26.072  83.227  -0.469  1.00 21.85           C  
ATOM   2752  O   ILE C  63      26.455  82.052  -0.567  1.00 21.56           O  
ATOM   2753  CB  ILE C  63      24.034  82.979   1.040  1.00 21.83           C  
ATOM   2754  CG1 ILE C  63      22.552  83.346   1.219  1.00 18.25           C  
ATOM   2755  CG2 ILE C  63      24.897  83.447   2.250  1.00 18.84           C  
ATOM   2756  CD1 ILE C  63      21.871  82.539   2.291  1.00 26.90           C  
ATOM   2757  N   TYR C  64      26.881  84.275  -0.571  1.00 22.02           N  
ATOM   2758  CA  TYR C  64      28.300  84.102  -0.808  1.00 23.85           C  
ATOM   2759  C   TYR C  64      29.158  84.908   0.202  1.00 25.39           C  
ATOM   2760  O   TYR C  64      28.884  86.086   0.456  1.00 26.08           O  
ATOM   2761  CB  TYR C  64      28.673  84.360  -2.298  1.00 22.71           C  
ATOM   2762  CG  TYR C  64      28.298  85.718  -2.884  1.00 23.58           C  
ATOM   2763  CD1 TYR C  64      27.003  85.979  -3.343  1.00 24.35           C  
ATOM   2764  CD2 TYR C  64      29.252  86.746  -2.990  1.00 26.64           C  
ATOM   2765  CE1 TYR C  64      26.649  87.251  -3.878  1.00 20.41           C  
ATOM   2766  CE2 TYR C  64      28.916  88.014  -3.526  1.00 25.64           C  
ATOM   2767  CZ  TYR C  64      27.614  88.250  -3.971  1.00 25.24           C  
ATOM   2768  OH  TYR C  64      27.284  89.477  -4.505  1.00 24.39           O  
ATOM   2769  N   ARG C  65      30.137  84.229   0.807  1.00 26.22           N  
ATOM   2770  CA  ARG C  65      31.118  84.824   1.731  1.00 28.14           C  
ATOM   2771  C   ARG C  65      32.287  85.490   0.976  1.00 28.36           C  
ATOM   2772  O   ARG C  65      32.373  85.393  -0.248  1.00 28.01           O  
ATOM   2773  CB  ARG C  65      31.665  83.750   2.691  1.00 28.08           C  
ATOM   2774  CG  ARG C  65      31.845  84.224   4.143  1.00 28.72           C  
ATOM   2775  CD  ARG C  65      32.977  83.509   4.904  1.00 30.14           C  
ATOM   2776  NE  ARG C  65      33.207  84.149   6.208  1.00 35.25           N  
ATOM   2777  CZ  ARG C  65      34.326  84.065   6.930  1.00 37.51           C  
ATOM   2778  NH1 ARG C  65      35.369  83.354   6.503  1.00 37.57           N  
ATOM   2779  NH2 ARG C  65      34.405  84.702   8.093  1.00 38.17           N  
ATOM   2780  N   LEU C  66      33.172  86.152   1.731  1.00 29.47           N  
ATOM   2781  CA  LEU C  66      34.360  86.908   1.235  1.00 30.85           C  
ATOM   2782  C   LEU C  66      34.343  87.364  -0.235  1.00 31.44           C  
ATOM   2783  O   LEU C  66      33.544  88.220  -0.637  1.00 32.01           O  
ATOM   2784  CB  LEU C  66      35.685  86.151   1.557  1.00 30.37           C  
ATOM   2785  N   GLN C  71      37.728  87.091  -4.541  1.00 33.00           N  
ATOM   2786  CA  GLN C  71      37.375  86.089  -3.541  1.00 33.24           C  
ATOM   2787  C   GLN C  71      35.873  86.099  -3.224  1.00 33.23           C  
ATOM   2788  O   GLN C  71      35.344  87.103  -2.743  1.00 34.34           O  
ATOM   2789  CB  GLN C  71      38.200  86.295  -2.263  1.00 32.71           C  
ATOM   2790  N   GLU C  72      35.196  84.991  -3.526  1.00 32.82           N  
ATOM   2791  CA  GLU C  72      33.799  84.758  -3.100  1.00 32.46           C  
ATOM   2792  C   GLU C  72      33.450  83.271  -3.094  1.00 30.64           C  
ATOM   2793  O   GLU C  72      33.415  82.612  -4.142  1.00 30.86           O  
ATOM   2794  CB  GLU C  72      32.765  85.557  -3.928  1.00 32.45           C  
ATOM   2795  CG  GLU C  72      32.554  85.092  -5.380  1.00 33.70           C  
ATOM   2796  CD  GLU C  72      31.144  85.379  -5.902  1.00 34.48           C  
ATOM   2797  OE1 GLU C  72      30.414  84.393  -6.220  1.00 37.11           O  
ATOM   2798  OE2 GLU C  72      30.768  86.582  -5.987  1.00 32.83           O  
ATOM   2799  N   LYS C  73      33.209  82.740  -1.904  1.00 28.21           N  
ATOM   2800  CA  LYS C  73      32.730  81.381  -1.793  1.00 26.18           C  
ATOM   2801  C   LYS C  73      31.207  81.369  -1.655  1.00 23.94           C  
ATOM   2802  O   LYS C  73      30.647  82.081  -0.815  1.00 22.59           O  
ATOM   2803  CB  LYS C  73      33.416  80.647  -0.641  1.00 26.27           C  
ATOM   2804  CG  LYS C  73      34.767  80.052  -1.038  1.00 28.56           C  
ATOM   2805  CD  LYS C  73      34.875  78.593  -0.600  1.00 34.40           C  
ATOM   2806  CE  LYS C  73      33.970  77.692  -1.443  1.00 36.64           C  
ATOM   2807  NZ  LYS C  73      33.079  76.834  -0.605  1.00 37.26           N  
ATOM   2808  N   ILE C  74      30.535  80.585  -2.502  1.00 21.30           N  
ATOM   2809  CA  ILE C  74      29.084  80.440  -2.377  1.00 18.30           C  
ATOM   2810  C   ILE C  74      28.754  79.499  -1.230  1.00 17.91           C  
ATOM   2811  O   ILE C  74      29.186  78.356  -1.208  1.00 17.44           O  
ATOM   2812  CB  ILE C  74      28.387  79.978  -3.669  1.00 17.73           C  
ATOM   2813  CG1 ILE C  74      28.791  80.873  -4.853  1.00 17.47           C  
ATOM   2814  CG2 ILE C  74      26.869  79.998  -3.439  1.00 16.74           C  
ATOM   2815  CD1 ILE C  74      28.065  80.610  -6.156  0.50 16.13           C  
ATOM   2816  N   LEU C  75      27.988  80.003  -0.272  1.00 18.67           N  
ATOM   2817  CA  LEU C  75      27.656  79.234   0.920  1.00 19.90           C  
ATOM   2818  C   LEU C  75      26.451  78.327   0.694  1.00 19.59           C  
ATOM   2819  O   LEU C  75      26.422  77.189   1.129  1.00 19.17           O  
ATOM   2820  CB  LEU C  75      27.381  80.175   2.108  1.00 19.68           C  
ATOM   2821  CG  LEU C  75      28.585  80.810   2.805  1.00 20.11           C  
ATOM   2822  CD1 LEU C  75      28.100  81.537   4.049  1.00 17.87           C  
ATOM   2823  CD2 LEU C  75      29.596  79.743   3.175  1.00 21.07           C  
ATOM   2824  N   GLU C  76      25.462  78.860   0.002  1.00 19.01           N  
ATOM   2825  CA  GLU C  76      24.169  78.245  -0.063  1.00 20.82           C  
ATOM   2826  C   GLU C  76      23.406  78.918  -1.193  1.00 17.61           C  
ATOM   2827  O   GLU C  76      23.614  80.116  -1.500  1.00 15.24           O  
ATOM   2828  CB  GLU C  76      23.466  78.393   1.309  1.00 21.57           C  
ATOM   2829  CG  GLU C  76      22.001  78.857   1.319  1.00 25.89           C  
ATOM   2830  CD  GLU C  76      21.253  78.510   2.641  1.00 29.06           C  
ATOM   2831  OE1 GLU C  76      21.746  77.641   3.424  1.00 31.17           O  
ATOM   2832  OE2 GLU C  76      20.163  79.114   2.876  1.00 41.23           O  
ATOM   2833  N   VAL C  77      22.561  78.127  -1.848  1.00 15.57           N  
ATOM   2834  CA  VAL C  77      21.552  78.668  -2.747  1.00 16.62           C  
ATOM   2835  C   VAL C  77      20.171  78.375  -2.178  1.00 17.51           C  
ATOM   2836  O   VAL C  77      19.754  77.207  -2.123  1.00 16.42           O  
ATOM   2837  CB  VAL C  77      21.690  78.124  -4.174  1.00 16.01           C  
ATOM   2838  CG1 VAL C  77      20.572  78.638  -5.049  1.00 15.29           C  
ATOM   2839  CG2 VAL C  77      23.051  78.508  -4.751  1.00 15.16           C  
ATOM   2840  N   THR C  78      19.471  79.432  -1.767  1.00 17.55           N  
ATOM   2841  CA  THR C  78      18.180  79.275  -1.100  1.00 21.70           C  
ATOM   2842  C   THR C  78      17.061  78.885  -2.058  1.00 23.13           C  
ATOM   2843  O   THR C  78      16.807  79.568  -3.046  1.00 24.45           O  
ATOM   2844  CB  THR C  78      17.746  80.549  -0.373  1.00 21.90           C  
ATOM   2845  OG1 THR C  78      18.866  81.124   0.324  1.00 26.26           O  
ATOM   2846  CG2 THR C  78      16.628  80.237   0.617  1.00 23.92           C  
ATOM   2847  N   ASN C  79      16.392  77.790  -1.732  1.00 25.48           N  
ATOM   2848  CA  ASN C  79      15.188  77.345  -2.428  1.00 26.59           C  
ATOM   2849  C   ASN C  79      13.944  78.100  -1.956  1.00 26.49           C  
ATOM   2850  O   ASN C  79      13.875  78.498  -0.796  1.00 25.24           O  
ATOM   2851  CB  ASN C  79      15.008  75.844  -2.212  1.00 27.07           C  
ATOM   2852  CG  ASN C  79      15.912  75.025  -3.103  1.00 29.86           C  
ATOM   2853  OD1 ASN C  79      16.062  75.325  -4.290  1.00 29.72           O  
ATOM   2854  ND2 ASN C  79      16.526  73.993  -2.539  1.00 32.03           N  
ATOM   2855  N   GLU C  80      12.960  78.272  -2.844  1.00 26.89           N  
ATOM   2856  CA  GLU C  80      11.719  78.986  -2.489  1.00 26.92           C  
ATOM   2857  C   GLU C  80      10.943  78.277  -1.378  1.00 25.98           C  
ATOM   2858  O   GLU C  80      11.046  77.054  -1.212  1.00 24.97           O  
ATOM   2859  CB  GLU C  80      10.837  79.297  -3.714  1.00 26.75           C  
ATOM   2860  CG  GLU C  80      10.969  78.332  -4.882  1.00 27.74           C  
ATOM   2861  CD  GLU C  80       9.835  78.456  -5.899  1.00 29.99           C  
ATOM   2862  OE1 GLU C  80       9.488  79.601  -6.274  1.00 35.17           O  
ATOM   2863  OE2 GLU C  80       9.302  77.402  -6.334  1.00 32.94           O  
ATOM   2864  N   ARG C  81      10.201  79.069  -0.604  1.00 24.90           N  
ATOM   2865  CA  ARG C  81       9.507  78.607   0.614  1.00 24.41           C  
ATOM   2866  C   ARG C  81      10.467  78.173   1.750  1.00 24.01           C  
ATOM   2867  O   ARG C  81      10.115  77.376   2.615  1.00 23.88           O  
ATOM   2868  CB  ARG C  81       8.439  77.526   0.302  1.00 25.11           C  
ATOM   2869  CG  ARG C  81       7.555  77.831  -0.908  1.00 24.27           C  
ATOM   2870  CD  ARG C  81       6.198  78.409  -0.556  1.00 29.05           C  
ATOM   2871  NE  ARG C  81       5.265  78.202  -1.676  1.00 33.33           N  
ATOM   2872  CZ  ARG C  81       4.881  79.157  -2.520  1.00 34.17           C  
ATOM   2873  NH1 ARG C  81       5.317  80.403  -2.365  1.00 38.88           N  
ATOM   2874  NH2 ARG C  81       4.051  78.876  -3.511  1.00 29.92           N  
ATOM   2875  N   ASN C  82      11.675  78.729   1.751  1.00 23.65           N  
ATOM   2876  CA  ASN C  82      12.642  78.486   2.819  1.00 23.14           C  
ATOM   2877  C   ASN C  82      13.129  79.824   3.390  1.00 21.39           C  
ATOM   2878  O   ASN C  82      13.096  80.833   2.704  1.00 22.20           O  
ATOM   2879  CB  ASN C  82      13.854  77.709   2.298  1.00 21.88           C  
ATOM   2880  CG  ASN C  82      13.545  76.272   2.000  1.00 25.82           C  
ATOM   2881  OD1 ASN C  82      13.806  75.401   2.825  1.00 25.23           O  
ATOM   2882  ND2 ASN C  82      12.998  76.001   0.805  1.00 25.36           N  
ATOM   2883  N   THR C  83      13.563  79.822   4.646  1.00 20.16           N  
ATOM   2884  CA  THR C  83      14.115  81.028   5.284  1.00 20.45           C  
ATOM   2885  C   THR C  83      15.609  81.065   5.055  1.00 20.11           C  
ATOM   2886  O   THR C  83      16.237  80.028   4.763  1.00 19.83           O  
ATOM   2887  CB  THR C  83      13.866  81.014   6.795  1.00 21.04           C  
ATOM   2888  OG1 THR C  83      14.204  79.710   7.318  1.00 21.63           O  
ATOM   2889  CG2 THR C  83      12.389  81.339   7.083  1.00 20.82           C  
ATOM   2890  N   PHE C  84      16.188  82.247   5.164  1.00 18.67           N  
ATOM   2891  CA  PHE C  84      17.641  82.344   5.242  1.00 17.68           C  
ATOM   2892  C   PHE C  84      18.132  83.435   6.205  1.00 16.78           C  
ATOM   2893  O   PHE C  84      17.407  84.383   6.495  1.00 15.23           O  
ATOM   2894  CB  PHE C  84      18.249  82.476   3.834  1.00 18.32           C  
ATOM   2895  CG  PHE C  84      17.774  83.683   3.070  1.00 21.68           C  
ATOM   2896  CD1 PHE C  84      16.588  83.641   2.325  1.00 18.40           C  
ATOM   2897  CD2 PHE C  84      18.530  84.853   3.067  1.00 16.77           C  
ATOM   2898  CE1 PHE C  84      16.157  84.752   1.629  1.00 22.54           C  
ATOM   2899  CE2 PHE C  84      18.112  85.962   2.350  1.00 21.84           C  
ATOM   2900  CZ  PHE C  84      16.923  85.908   1.620  1.00 17.90           C  
ATOM   2901  N   ALA C  85      19.348  83.247   6.726  1.00 15.77           N  
ATOM   2902  CA  ALA C  85      20.043  84.169   7.629  1.00 16.70           C  
ATOM   2903  C   ALA C  85      19.544  84.161   9.086  1.00 17.30           C  
ATOM   2904  O   ALA C  85      19.969  85.000   9.879  1.00 15.95           O  
ATOM   2905  CB  ALA C  85      20.079  85.635   7.058  1.00 15.38           C  
ATOM   2906  N   GLU C  86      18.639  83.235   9.420  1.00 17.65           N  
ATOM   2907  CA  GLU C  86      18.195  83.041  10.813  1.00 19.54           C  
ATOM   2908  C   GLU C  86      19.340  82.691  11.753  1.00 19.62           C  
ATOM   2909  O   GLU C  86      19.199  82.840  12.968  1.00 20.14           O  
ATOM   2910  CB  GLU C  86      17.141  81.928  10.939  1.00 20.58           C  
ATOM   2911  CG  GLU C  86      16.373  81.605   9.652  1.00 28.81           C  
ATOM   2912  CD  GLU C  86      17.065  80.569   8.807  1.00 34.32           C  
ATOM   2913  OE1 GLU C  86      16.880  79.346   9.033  1.00 36.68           O  
ATOM   2914  OE2 GLU C  86      17.809  80.989   7.911  1.00 34.02           O  
ATOM   2915  N   ALA C  87      20.454  82.177  11.228  1.00 18.80           N  
ATOM   2916  CA  ALA C  87      21.565  81.819  12.122  1.00 19.65           C  
ATOM   2917  C   ALA C  87      22.279  83.043  12.732  1.00 19.44           C  
ATOM   2918  O   ALA C  87      22.884  82.941  13.797  1.00 19.15           O  
ATOM   2919  CB  ALA C  87      22.541  80.871  11.451  1.00 18.74           C  
ATOM   2920  N   MET C  88      22.200  84.191  12.061  1.00 20.57           N  
ATOM   2921  CA  MET C  88      22.825  85.424  12.562  1.00 22.29           C  
ATOM   2922  C   MET C  88      22.310  85.798  13.940  1.00 23.15           C  
ATOM   2923  O   MET C  88      23.006  86.487  14.681  1.00 24.35           O  
ATOM   2924  CB  MET C  88      22.623  86.610  11.614  1.00 22.81           C  
ATOM   2925  CG  MET C  88      23.220  86.459  10.196  1.00 22.20           C  
ATOM   2926  SD  MET C  88      25.026  86.382  10.103  1.00 21.60           S  
ATOM   2927  CE  MET C  88      25.529  87.678  11.236  1.00 25.07           C  
ATOM   2928  N   MET C  89      21.103  85.345  14.284  1.00 24.07           N  
ATOM   2929  CA  MET C  89      20.514  85.576  15.616  1.00 26.03           C  
ATOM   2930  C   MET C  89      21.250  84.879  16.749  1.00 25.26           C  
ATOM   2931  O   MET C  89      21.209  85.326  17.895  1.00 26.03           O  
ATOM   2932  CB  MET C  89      19.056  85.123  15.648  1.00 24.88           C  
ATOM   2933  CG  MET C  89      18.093  86.211  15.338  1.00 27.15           C  
ATOM   2934  SD  MET C  89      16.399  85.695  14.958  1.00 28.79           S  
ATOM   2935  CE  MET C  89      16.593  84.819  13.412  1.00 30.72           C  
ATOM   2936  N   PHE C  90      21.900  83.772  16.421  1.00 26.03           N  
ATOM   2937  CA  PHE C  90      22.473  82.881  17.419  1.00 25.88           C  
ATOM   2938  C   PHE C  90      23.979  82.743  17.290  1.00 27.18           C  
ATOM   2939  O   PHE C  90      24.582  81.857  17.894  1.00 27.88           O  
ATOM   2940  CB  PHE C  90      21.794  81.512  17.335  1.00 25.20           C  
ATOM   2941  CG  PHE C  90      20.315  81.581  17.485  1.00 23.53           C  
ATOM   2942  CD1 PHE C  90      19.495  81.712  16.368  1.00 23.53           C  
ATOM   2943  CD2 PHE C  90      19.735  81.561  18.741  1.00 20.95           C  
ATOM   2944  CE1 PHE C  90      18.122  81.799  16.509  1.00 20.68           C  
ATOM   2945  CE2 PHE C  90      18.362  81.643  18.883  1.00 21.35           C  
ATOM   2946  CZ  PHE C  90      17.555  81.761  17.769  1.00 18.59           C  
ATOM   2947  N   MET C  91      24.594  83.604  16.489  1.00 28.09           N  
ATOM   2948  CA  MET C  91      26.037  83.795  16.595  1.00 29.69           C  
ATOM   2949  C   MET C  91      26.294  85.181  17.167  1.00 29.48           C  
ATOM   2950  O   MET C  91      25.436  86.071  17.087  1.00 30.36           O  
ATOM   2951  CB  MET C  91      26.769  83.543  15.275  1.00 29.43           C  
ATOM   2952  CG  MET C  91      26.184  84.181  14.042  1.00 30.18           C  
ATOM   2953  SD  MET C  91      26.399  83.112  12.584  1.00 32.28           S  
ATOM   2954  CE  MET C  91      28.174  82.808  12.552  1.00 36.37           C  
ATOM   2955  N   ASP C  92      27.458  85.358  17.766  1.00 29.20           N  
ATOM   2956  CA  ASP C  92      27.700  86.553  18.561  1.00 29.09           C  
ATOM   2957  C   ASP C  92      28.113  87.775  17.733  1.00 28.51           C  
ATOM   2958  O   ASP C  92      28.267  88.875  18.275  1.00 28.27           O  
ATOM   2959  CB  ASP C  92      28.691  86.249  19.694  1.00 29.51           C  
ATOM   2960  CG  ASP C  92      28.185  85.157  20.638  1.00 29.68           C  
ATOM   2961  OD1 ASP C  92      26.980  84.747  20.463  1.00 28.92           O  
ATOM   2962  OD2 ASP C  92      28.993  84.706  21.542  1.00 25.19           O  
ATOM   2963  N   THR C  93      28.237  87.587  16.419  1.00 27.24           N  
ATOM   2964  CA  THR C  93      28.718  88.638  15.521  1.00 26.25           C  
ATOM   2965  C   THR C  93      27.581  89.503  14.938  1.00 25.46           C  
ATOM   2966  O   THR C  93      26.623  88.978  14.375  1.00 26.40           O  
ATOM   2967  CB  THR C  93      29.591  88.049  14.396  1.00 25.83           C  
ATOM   2968  OG1 THR C  93      28.947  86.892  13.861  1.00 24.02           O  
ATOM   2969  CG2 THR C  93      30.955  87.639  14.945  1.00 27.15           C  
ATOM   2970  N   PRO C  94      27.700  90.843  15.069  1.00 24.84           N  
ATOM   2971  CA  PRO C  94      26.611  91.779  14.739  1.00 23.68           C  
ATOM   2972  C   PRO C  94      26.363  92.119  13.257  1.00 22.76           C  
ATOM   2973  O   PRO C  94      25.351  92.742  12.942  1.00 22.47           O  
ATOM   2974  CB  PRO C  94      27.000  93.040  15.522  1.00 22.92           C  
ATOM   2975  CG  PRO C  94      28.492  93.003  15.538  1.00 23.01           C  
ATOM   2976  CD  PRO C  94      28.897  91.552  15.574  1.00 23.37           C  
ATOM   2977  N   ASN C  95      27.263  91.745  12.353  1.00 22.49           N  
ATOM   2978  CA  ASN C  95      27.056  92.058  10.931  1.00 21.80           C  
ATOM   2979  C   ASN C  95      27.020  90.812  10.050  1.00 21.97           C  
ATOM   2980  O   ASN C  95      27.717  89.825  10.329  1.00 22.03           O  
ATOM   2981  CB  ASN C  95      28.116  93.043  10.413  1.00 22.11           C  
ATOM   2982  CG  ASN C  95      28.150  94.347  11.199  1.00 22.53           C  
ATOM   2983  OD1 ASN C  95      28.467  94.357  12.390  1.00 25.99           O  
ATOM   2984  ND2 ASN C  95      27.842  95.460  10.528  1.00 17.34           N  
ATOM   2985  N   TYR C  96      26.212  90.860   8.989  1.00 20.87           N  
ATOM   2986  CA  TYR C  96      26.050  89.706   8.101  1.00 20.52           C  
ATOM   2987  C   TYR C  96      27.408  89.251   7.619  1.00 20.63           C  
ATOM   2988  O   TYR C  96      28.193  90.054   7.142  1.00 21.11           O  
ATOM   2989  CB  TYR C  96      25.180  90.040   6.896  1.00 18.30           C  
ATOM   2990  CG  TYR C  96      23.729  90.305   7.205  1.00 15.81           C  
ATOM   2991  CD1 TYR C  96      22.865  89.275   7.585  1.00  7.04           C  
ATOM   2992  CD2 TYR C  96      23.221  91.595   7.107  1.00  9.55           C  
ATOM   2993  CE1 TYR C  96      21.530  89.524   7.835  1.00 12.88           C  
ATOM   2994  CE2 TYR C  96      21.910  91.862   7.358  1.00 15.10           C  
ATOM   2995  CZ  TYR C  96      21.053  90.825   7.715  1.00 16.94           C  
ATOM   2996  OH  TYR C  96      19.740  91.144   7.972  1.00 17.10           O  
ATOM   2997  N   VAL C  97      27.664  87.960   7.767  1.00 21.45           N  
ATOM   2998  CA  VAL C  97      28.916  87.328   7.342  1.00 22.32           C  
ATOM   2999  C   VAL C  97      28.893  86.890   5.853  1.00 21.78           C  
ATOM   3000  O   VAL C  97      29.845  86.274   5.375  1.00 20.66           O  
ATOM   3001  CB  VAL C  97      29.272  86.135   8.279  1.00 22.64           C  
ATOM   3002  CG1 VAL C  97      28.362  84.929   7.993  1.00 21.50           C  
ATOM   3003  CG2 VAL C  97      30.735  85.751   8.150  1.00 25.20           C  
ATOM   3004  N   ALA C  98      27.817  87.229   5.133  1.00 21.57           N  
ATOM   3005  CA  ALA C  98      27.738  87.030   3.689  1.00 21.25           C  
ATOM   3006  C   ALA C  98      26.872  88.079   3.017  1.00 20.61           C  
ATOM   3007  O   ALA C  98      26.188  88.820   3.692  1.00 22.56           O  
ATOM   3008  CB  ALA C  98      27.202  85.648   3.384  1.00 22.63           C  
ATOM   3009  N   THR C  99      26.924  88.140   1.690  1.00 20.21           N  
ATOM   3010  CA  THR C  99      25.992  88.904   0.866  1.00 19.74           C  
ATOM   3011  C   THR C  99      24.911  87.929   0.387  1.00 20.45           C  
ATOM   3012  O   THR C  99      25.209  86.773   0.098  1.00 19.97           O  
ATOM   3013  CB  THR C  99      26.728  89.491  -0.370  1.00 21.08           C  
ATOM   3014  OG1 THR C  99      27.820  90.324   0.060  1.00 18.77           O  
ATOM   3015  CG2 THR C  99      25.806  90.316  -1.279  1.00 20.91           C  
ATOM   3016  N   ALA C 100      23.663  88.374   0.313  1.00 19.72           N  
ATOM   3017  CA  ALA C 100      22.632  87.586  -0.331  1.00 18.94           C  
ATOM   3018  C   ALA C 100      22.113  88.395  -1.499  1.00 18.85           C  
ATOM   3019  O   ALA C 100      21.849  89.597  -1.359  1.00 17.69           O  
ATOM   3020  CB  ALA C 100      21.514  87.223   0.631  1.00 18.88           C  
ATOM   3021  N   GLN C 101      21.980  87.726  -2.648  1.00 18.09           N  
ATOM   3022  CA  GLN C 101      21.564  88.349  -3.905  1.00 17.32           C  
ATOM   3023  C   GLN C 101      20.509  87.486  -4.557  1.00 17.33           C  
ATOM   3024  O   GLN C 101      20.655  86.238  -4.613  1.00 15.75           O  
ATOM   3025  CB  GLN C 101      22.748  88.472  -4.848  1.00 17.87           C  
ATOM   3026  CG  GLN C 101      22.492  89.381  -6.037  1.00 17.99           C  
ATOM   3027  CD  GLN C 101      23.693  89.524  -6.963  1.00 20.15           C  
ATOM   3028  OE1 GLN C 101      23.817  90.520  -7.696  1.00 24.03           O  
ATOM   3029  NE2 GLN C 101      24.585  88.533  -6.938  1.00 24.85           N  
ATOM   3030  N   ALA C 102      19.440  88.125  -5.016  1.00 15.57           N  
ATOM   3031  CA  ALA C 102      18.465  87.419  -5.836  1.00 16.96           C  
ATOM   3032  C   ALA C 102      19.060  87.210  -7.216  1.00 17.09           C  
ATOM   3033  O   ALA C 102      19.545  88.160  -7.842  1.00 17.00           O  
ATOM   3034  CB  ALA C 102      17.151  88.182  -5.919  1.00 17.98           C  
ATOM   3035  N   VAL C 103      19.044  85.970  -7.691  1.00 16.06           N  
ATOM   3036  CA  VAL C 103      19.664  85.667  -8.974  1.00 16.10           C  
ATOM   3037  C   VAL C 103      18.584  85.558 -10.056  1.00 16.90           C  
ATOM   3038  O   VAL C 103      18.874  85.557 -11.251  1.00 16.71           O  
ATOM   3039  CB  VAL C 103      20.525  84.378  -8.895  1.00 17.36           C  
ATOM   3040  CG1 VAL C 103      21.667  84.559  -7.894  1.00 18.18           C  
ATOM   3041  CG2 VAL C 103      19.663  83.176  -8.549  1.00 12.83           C  
ATOM   3042  N   VAL C 104      17.339  85.475  -9.590  1.00 17.88           N  
ATOM   3043  CA  VAL C 104      16.141  85.418 -10.408  1.00 18.91           C  
ATOM   3044  C   VAL C 104      15.100  86.360  -9.728  1.00 19.32           C  
ATOM   3045  O   VAL C 104      15.233  86.656  -8.542  1.00 19.25           O  
ATOM   3046  CB  VAL C 104      15.656  83.935 -10.491  1.00 19.35           C  
ATOM   3047  CG1 VAL C 104      14.776  83.561  -9.288  1.00 17.89           C  
ATOM   3048  CG2 VAL C 104      14.950  83.664 -11.777  1.00 19.88           C  
ATOM   3049  N   PRO C 105      14.083  86.852 -10.468  1.00 20.04           N  
ATOM   3050  CA  PRO C 105      13.093  87.709  -9.776  1.00 20.21           C  
ATOM   3051  C   PRO C 105      12.410  87.015  -8.587  1.00 20.62           C  
ATOM   3052  O   PRO C 105      11.866  85.912  -8.735  1.00 20.06           O  
ATOM   3053  CB  PRO C 105      12.075  88.032 -10.880  1.00 20.87           C  
ATOM   3054  CG  PRO C 105      12.847  87.868 -12.176  1.00 19.05           C  
ATOM   3055  CD  PRO C 105      13.781  86.719 -11.909  1.00 19.88           C  
ATOM   3056  N   SER C 106      12.441  87.674  -7.427  1.00 20.28           N  
ATOM   3057  CA  SER C 106      12.101  87.042  -6.167  1.00 20.93           C  
ATOM   3058  C   SER C 106      11.240  87.876  -5.221  1.00 21.94           C  
ATOM   3059  O   SER C 106      11.288  89.108  -5.220  1.00 22.88           O  
ATOM   3060  CB  SER C 106      13.379  86.648  -5.430  1.00 20.55           C  
ATOM   3061  OG  SER C 106      14.157  85.799  -6.237  1.00 19.17           O  
ATOM   3062  N   GLN C 107      10.472  87.168  -4.396  1.00 23.10           N  
ATOM   3063  CA  GLN C 107       9.645  87.774  -3.362  1.00 22.71           C  
ATOM   3064  C   GLN C 107       9.875  87.053  -2.062  1.00 22.32           C  
ATOM   3065  O   GLN C 107       9.896  85.820  -2.012  1.00 21.48           O  
ATOM   3066  CB  GLN C 107       8.171  87.669  -3.735  1.00 24.01           C  
ATOM   3067  CG  GLN C 107       7.256  88.651  -3.005  1.00 25.50           C  
ATOM   3068  CD  GLN C 107       5.847  88.644  -3.558  1.00 28.43           C  
ATOM   3069  OE1 GLN C 107       5.486  87.788  -4.380  1.00 30.02           O  
ATOM   3070  NE2 GLN C 107       5.039  89.602  -3.118  1.00 29.93           N  
ATOM   3071  N   LEU C 108      10.024  87.842  -1.002  1.00 21.50           N  
ATOM   3072  CA  LEU C 108      10.233  87.324   0.342  1.00 21.23           C  
ATOM   3073  C   LEU C 108       9.467  88.133   1.374  1.00 19.91           C  
ATOM   3074  O   LEU C 108       8.910  89.188   1.064  1.00 20.18           O  
ATOM   3075  CB  LEU C 108      11.734  87.289   0.678  1.00 20.16           C  
ATOM   3076  CG  LEU C 108      12.611  88.447   0.208  1.00 25.28           C  
ATOM   3077  CD1 LEU C 108      12.553  89.604   1.202  1.00 29.92           C  
ATOM   3078  CD2 LEU C 108      14.043  88.000  -0.027  1.00 26.94           C  
ATOM   3079  N   PHE C 109       9.396  87.594   2.583  1.00 19.54           N  
ATOM   3080  CA  PHE C 109       9.073  88.369   3.762  1.00 18.66           C  
ATOM   3081  C   PHE C 109      10.362  88.647   4.533  1.00 19.12           C  
ATOM   3082  O   PHE C 109      11.239  87.773   4.641  1.00 18.61           O  
ATOM   3083  CB  PHE C 109       8.175  87.591   4.713  1.00 19.54           C  
ATOM   3084  CG  PHE C 109       6.752  87.483   4.274  1.00 18.55           C  
ATOM   3085  CD1 PHE C 109       6.233  86.258   3.929  1.00 13.73           C  
ATOM   3086  CD2 PHE C 109       5.933  88.603   4.238  1.00 18.80           C  
ATOM   3087  CE1 PHE C 109       4.925  86.138   3.546  1.00 20.63           C  
ATOM   3088  CE2 PHE C 109       4.627  88.503   3.856  1.00 23.42           C  
ATOM   3089  CZ  PHE C 109       4.113  87.269   3.503  1.00 23.61           C  
ATOM   3090  N   ARG C 110      10.438  89.838   5.111  1.00 17.15           N  
ATOM   3091  CA  ARG C 110      11.479  90.164   6.046  1.00 18.47           C  
ATOM   3092  C   ARG C 110      10.900  90.231   7.452  1.00 18.97           C  
ATOM   3093  O   ARG C 110       9.813  90.782   7.673  1.00 19.42           O  
ATOM   3094  CB  ARG C 110      12.119  91.509   5.700  1.00 17.73           C  
ATOM   3095  CG  ARG C 110      13.115  91.947   6.739  1.00 21.11           C  
ATOM   3096  CD  ARG C 110      13.948  93.135   6.307  1.00 28.03           C  
ATOM   3097  NE  ARG C 110      13.142  94.208   5.768  1.00 32.24           N  
ATOM   3098  CZ  ARG C 110      13.182  94.624   4.504  1.00 34.52           C  
ATOM   3099  NH1 ARG C 110      13.997  94.053   3.622  1.00 36.86           N  
ATOM   3100  NH2 ARG C 110      12.400  95.622   4.125  1.00 31.51           N  
ATOM   3101  N   PHE C 111      11.679  89.718   8.384  1.00 19.36           N  
ATOM   3102  CA  PHE C 111      11.321  89.577   9.777  1.00 19.76           C  
ATOM   3103  C   PHE C 111      12.414  90.198  10.605  1.00 20.87           C  
ATOM   3104  O   PHE C 111      13.582  90.010  10.303  1.00 21.43           O  
ATOM   3105  CB  PHE C 111      11.257  88.076  10.127  1.00 18.54           C  
ATOM   3106  CG  PHE C 111      10.181  87.349   9.398  1.00 19.27           C  
ATOM   3107  CD1 PHE C 111      10.494  86.463   8.365  1.00 21.61           C  
ATOM   3108  CD2 PHE C 111       8.845  87.591   9.698  1.00 20.47           C  
ATOM   3109  CE1 PHE C 111       9.481  85.792   7.671  1.00 25.54           C  
ATOM   3110  CE2 PHE C 111       7.815  86.930   8.996  1.00 24.78           C  
ATOM   3111  CZ  PHE C 111       8.139  86.025   7.983  1.00 20.54           C  
ATOM   3112  N   SER C 112      12.025  90.930  11.651  1.00 20.33           N  
ATOM   3113  CA  SER C 112      12.977  91.539  12.567  1.00 19.83           C  
ATOM   3114  C   SER C 112      13.541  90.459  13.522  1.00 19.86           C  
ATOM   3115  O   SER C 112      12.770  89.650  14.059  1.00 19.42           O  
ATOM   3116  CB  SER C 112      12.279  92.659  13.343  1.00 19.03           C  
ATOM   3117  OG  SER C 112      12.695  92.673  14.693  1.00 20.16           O  
ATOM   3118  N   ASN C 113      14.871  90.423  13.702  1.00 18.85           N  
ATOM   3119  CA  ASN C 113      15.491  89.459  14.625  1.00 18.67           C  
ATOM   3120  C   ASN C 113      14.980  89.686  16.049  1.00 20.04           C  
ATOM   3121  O   ASN C 113      14.677  88.738  16.790  1.00 20.97           O  
ATOM   3122  CB  ASN C 113      17.004  89.632  14.631  1.00 18.29           C  
ATOM   3123  CG  ASN C 113      17.671  89.016  13.414  1.00 19.81           C  
ATOM   3124  OD1 ASN C 113      17.018  88.692  12.408  1.00 24.02           O  
ATOM   3125  ND2 ASN C 113      18.969  88.858  13.493  1.00 15.62           N  
ATOM   3126  N   LYS C 114      14.899  90.962  16.414  1.00 19.21           N  
ATOM   3127  CA  LYS C 114      14.488  91.372  17.741  1.00 19.67           C  
ATOM   3128  C   LYS C 114      13.052  90.948  18.006  1.00 19.45           C  
ATOM   3129  O   LYS C 114      12.764  90.469  19.089  1.00 19.17           O  
ATOM   3130  CB  LYS C 114      14.666  92.866  17.908  1.00 20.58           C  
ATOM   3131  N   ALA C 115      12.171  91.101  17.006  1.00 19.67           N  
ATOM   3132  CA  ALA C 115      10.761  90.720  17.133  1.00 19.58           C  
ATOM   3133  C   ALA C 115      10.631  89.245  17.393  1.00 19.10           C  
ATOM   3134  O   ALA C 115       9.854  88.803  18.245  1.00 18.96           O  
ATOM   3135  CB  ALA C 115       9.973  91.103  15.881  1.00 20.01           C  
ATOM   3136  N   TYR C 116      11.439  88.490  16.668  1.00 19.84           N  
ATOM   3137  CA  TYR C 116      11.449  87.061  16.737  1.00 19.65           C  
ATOM   3138  C   TYR C 116      11.965  86.546  18.063  1.00 20.04           C  
ATOM   3139  O   TYR C 116      11.336  85.705  18.678  1.00 19.99           O  
ATOM   3140  CB  TYR C 116      12.292  86.504  15.622  1.00 19.14           C  
ATOM   3141  CG  TYR C 116      12.129  85.027  15.505  1.00 16.38           C  
ATOM   3142  CD1 TYR C 116      11.013  84.488  14.878  1.00 20.94           C  
ATOM   3143  CD2 TYR C 116      13.069  84.160  16.041  1.00 17.62           C  
ATOM   3144  CE1 TYR C 116      10.839  83.101  14.758  1.00 19.12           C  
ATOM   3145  CE2 TYR C 116      12.911  82.767  15.929  1.00 20.73           C  
ATOM   3146  CZ  TYR C 116      11.794  82.249  15.281  1.00 19.92           C  
ATOM   3147  OH  TYR C 116      11.620  80.881  15.183  1.00 18.21           O  
ATOM   3148  N   LEU C 117      13.119  87.052  18.488  1.00 21.38           N  
ATOM   3149  CA  LEU C 117      13.711  86.673  19.773  1.00 21.52           C  
ATOM   3150  C   LEU C 117      12.752  86.967  20.907  1.00 21.25           C  
ATOM   3151  O   LEU C 117      12.690  86.219  21.884  1.00 21.22           O  
ATOM   3152  CB  LEU C 117      15.040  87.401  20.006  1.00 22.61           C  
ATOM   3153  CG  LEU C 117      16.255  87.062  19.112  1.00 23.02           C  
ATOM   3154  CD1 LEU C 117      17.555  87.649  19.679  1.00 24.06           C  
ATOM   3155  CD2 LEU C 117      16.425  85.561  18.850  1.00 28.57           C  
ATOM   3156  N   ARG C 118      11.998  88.051  20.750  1.00 20.32           N  
ATOM   3157  CA  ARG C 118      10.980  88.464  21.711  1.00 21.55           C  
ATOM   3158  C   ARG C 118       9.919  87.371  21.934  1.00 20.09           C  
ATOM   3159  O   ARG C 118       9.577  87.080  23.075  1.00 19.62           O  
ATOM   3160  CB  ARG C 118      10.322  89.785  21.269  1.00 18.98           C  
ATOM   3161  CG  ARG C 118      10.002  90.726  22.403  1.00 23.12           C  
ATOM   3162  CD  ARG C 118       9.214  91.989  21.948  1.00 24.31           C  
ATOM   3163  NE  ARG C 118       9.927  92.763  20.925  1.00 33.61           N  
ATOM   3164  CZ  ARG C 118       9.463  93.042  19.708  1.00 37.00           C  
ATOM   3165  NH1 ARG C 118       8.250  92.645  19.329  1.00 40.88           N  
ATOM   3166  NH2 ARG C 118      10.211  93.745  18.867  1.00 35.65           N  
ATOM   3167  N   GLN C 119       9.434  86.760  20.851  1.00 20.07           N  
ATOM   3168  CA  GLN C 119       8.398  85.697  20.918  1.00 19.75           C  
ATOM   3169  C   GLN C 119       8.933  84.371  21.458  1.00 19.49           C  
ATOM   3170  O   GLN C 119       8.188  83.594  22.077  1.00 17.40           O  
ATOM   3171  CB  GLN C 119       7.763  85.434  19.537  1.00 20.73           C  
ATOM   3172  CG  GLN C 119       7.435  86.676  18.721  1.00 20.74           C  
ATOM   3173  CD  GLN C 119       6.467  87.608  19.414  1.00 24.41           C  
ATOM   3174  OE1 GLN C 119       5.555  87.177  20.128  1.00 28.53           O  
ATOM   3175  NE2 GLN C 119       6.652  88.900  19.195  1.00 25.64           N  
ATOM   3176  N   LEU C 120      10.216  84.118  21.202  1.00 19.76           N  
ATOM   3177  CA  LEU C 120      10.863  82.855  21.580  1.00 20.16           C  
ATOM   3178  C   LEU C 120      11.021  82.806  23.083  1.00 20.39           C  
ATOM   3179  O   LEU C 120      11.020  81.735  23.678  1.00 21.30           O  
ATOM   3180  CB  LEU C 120      12.209  82.699  20.840  1.00 20.29           C  
ATOM   3181  CG  LEU C 120      13.474  82.162  21.524  1.00 21.23           C  
ATOM   3182  CD1 LEU C 120      13.465  80.649  21.605  1.00 24.22           C  
ATOM   3183  CD2 LEU C 120      14.722  82.622  20.793  1.00 20.39           C  
ATOM   3184  N   GLN C 121      11.129  83.990  23.683  1.00 20.50           N  
ATOM   3185  CA  GLN C 121      11.164  84.184  25.129  1.00 20.19           C  
ATOM   3186  C   GLN C 121       9.982  83.480  25.808  1.00 20.24           C  
ATOM   3187  O   GLN C 121      10.096  82.985  26.937  1.00 20.83           O  
ATOM   3188  CB  GLN C 121      11.119  85.689  25.421  1.00 20.05           C  
ATOM   3189  CG  GLN C 121      12.091  86.183  26.478  1.00 20.88           C  
ATOM   3190  CD  GLN C 121      13.534  86.207  25.998  1.00 23.29           C  
ATOM   3191  OE1 GLN C 121      13.825  86.638  24.885  1.00 21.82           O  
ATOM   3192  NE2 GLN C 121      14.447  85.741  26.844  1.00 26.46           N  
ATOM   3193  N   ASP C 122       8.866  83.405  25.088  1.00 19.97           N  
ATOM   3194  CA  ASP C 122       7.609  82.879  25.600  1.00 20.16           C  
ATOM   3195  C   ASP C 122       7.352  81.430  25.184  1.00 19.77           C  
ATOM   3196  O   ASP C 122       6.474  80.776  25.740  1.00 20.12           O  
ATOM   3197  CB  ASP C 122       6.457  83.763  25.093  1.00 20.82           C  
ATOM   3198  CG  ASP C 122       5.276  83.839  26.066  1.00 23.28           C  
ATOM   3199  OD1 ASP C 122       5.124  82.955  26.944  1.00 26.93           O  
ATOM   3200  OD2 ASP C 122       4.484  84.809  25.944  1.00 28.93           O  
ATOM   3201  N   ASN C 123       8.124  80.919  24.226  1.00 19.80           N  
ATOM   3202  CA  ASN C 123       7.767  79.673  23.535  1.00 19.03           C  
ATOM   3203  C   ASN C 123       8.734  78.504  23.749  1.00 19.46           C  
ATOM   3204  O   ASN C 123       9.857  78.516  23.234  1.00 19.13           O  
ATOM   3205  CB  ASN C 123       7.613  79.947  22.032  1.00 18.77           C  
ATOM   3206  CG  ASN C 123       6.656  78.989  21.352  1.00 18.55           C  
ATOM   3207  OD1 ASN C 123       5.836  79.402  20.535  1.00 15.59           O  
ATOM   3208  ND2 ASN C 123       6.744  77.702  21.692  1.00 26.56           N  
ATOM   3209  N   THR C 124       8.267  77.490  24.483  1.00 19.58           N  
ATOM   3210  CA  THR C 124       9.046  76.302  24.809  1.00 19.30           C  
ATOM   3211  C   THR C 124       9.190  75.341  23.624  1.00 19.49           C  
ATOM   3212  O   THR C 124      10.309  75.058  23.233  1.00 18.76           O  
ATOM   3213  CB  THR C 124       8.466  75.586  26.047  1.00 19.80           C  
ATOM   3214  N   PRO C 125       8.067  74.839  23.054  1.00 20.36           N  
ATOM   3215  CA  PRO C 125       8.091  74.090  21.791  1.00 21.30           C  
ATOM   3216  C   PRO C 125       8.947  74.707  20.663  1.00 21.96           C  
ATOM   3217  O   PRO C 125       9.569  73.957  19.901  1.00 22.84           O  
ATOM   3218  CB  PRO C 125       6.618  74.093  21.369  1.00 21.64           C  
ATOM   3219  CG  PRO C 125       5.886  74.071  22.633  1.00 21.67           C  
ATOM   3220  CD  PRO C 125       6.693  74.912  23.591  1.00 20.80           C  
ATOM   3221  N   LEU C 126       8.965  76.036  20.539  1.00 21.11           N  
ATOM   3222  CA  LEU C 126       9.800  76.672  19.515  1.00 21.55           C  
ATOM   3223  C   LEU C 126      11.267  76.544  19.899  1.00 21.42           C  
ATOM   3224  O   LEU C 126      12.078  76.084  19.091  1.00 22.35           O  
ATOM   3225  CB  LEU C 126       9.433  78.150  19.255  1.00 20.40           C  
ATOM   3226  CG  LEU C 126       9.482  78.728  17.824  1.00 21.33           C  
ATOM   3227  CD1 LEU C 126       9.629  80.249  17.846  1.00 16.00           C  
ATOM   3228  CD2 LEU C 126      10.560  78.131  16.926  1.00 16.00           C  
ATOM   3229  N   ALA C 127      11.601  76.920  21.130  1.00 20.46           N  
ATOM   3230  CA  ALA C 127      12.980  76.859  21.578  1.00 20.47           C  
ATOM   3231  C   ALA C 127      13.467  75.409  21.656  1.00 21.45           C  
ATOM   3232  O   ALA C 127      14.649  75.171  21.916  1.00 22.98           O  
ATOM   3233  CB  ALA C 127      13.139  77.556  22.917  1.00 19.47           C  
ATOM   3234  N   LEU C 128      12.560  74.455  21.425  1.00 20.91           N  
ATOM   3235  CA  LEU C 128      12.908  73.024  21.437  1.00 21.65           C  
ATOM   3236  C   LEU C 128      13.037  72.439  20.022  1.00 21.82           C  
ATOM   3237  O   LEU C 128      13.816  71.510  19.796  1.00 21.67           O  
ATOM   3238  CB  LEU C 128      11.919  72.198  22.278  1.00 20.97           C  
ATOM   3239  CG  LEU C 128      11.742  72.407  23.798  1.00 19.91           C  
ATOM   3240  CD1 LEU C 128      10.525  71.619  24.293  1.00 16.32           C  
ATOM   3241  CD2 LEU C 128      12.984  72.065  24.643  1.00 14.87           C  
ATOM   3242  N   ALA C 129      12.265  72.988  19.082  1.00 23.12           N  
ATOM   3243  CA  ALA C 129      12.413  72.686  17.657  1.00 22.81           C  
ATOM   3244  C   ALA C 129      13.748  73.223  17.169  1.00 22.98           C  
ATOM   3245  O   ALA C 129      14.465  72.536  16.425  1.00 23.26           O  
ATOM   3246  CB  ALA C 129      11.257  73.294  16.840  1.00 23.48           C  
ATOM   3247  N   LEU C 130      14.056  74.457  17.589  1.00 22.74           N  
ATOM   3248  CA  LEU C 130      15.339  75.125  17.325  1.00 22.65           C  
ATOM   3249  C   LEU C 130      16.490  74.283  17.835  1.00 22.51           C  
ATOM   3250  O   LEU C 130      17.493  74.079  17.152  1.00 23.64           O  
ATOM   3251  CB  LEU C 130      15.387  76.496  18.020  1.00 22.35           C  
ATOM   3252  CG  LEU C 130      15.123  77.815  17.281  1.00 23.87           C  
ATOM   3253  CD1 LEU C 130      13.753  77.853  16.627  1.00 25.13           C  
ATOM   3254  CD2 LEU C 130      15.293  79.004  18.228  1.00 21.97           C  
ATOM   3255  N   LEU C 131      16.321  73.801  19.049  1.00 21.84           N  
ATOM   3256  CA  LEU C 131      17.347  73.069  19.756  1.00 22.01           C  
ATOM   3257  C   LEU C 131      17.658  71.732  19.061  1.00 22.42           C  
ATOM   3258  O   LEU C 131      18.821  71.368  18.908  1.00 21.45           O  
ATOM   3259  CB  LEU C 131      16.926  72.885  21.217  1.00 20.36           C  
ATOM   3260  CG  LEU C 131      18.044  72.744  22.256  1.00 21.67           C  
ATOM   3261  CD1 LEU C 131      18.949  73.970  22.338  1.00 19.50           C  
ATOM   3262  CD2 LEU C 131      17.422  72.477  23.600  1.00 19.25           C  
ATOM   3263  N   ALA C 132      16.608  71.032  18.633  1.00 23.32           N  
ATOM   3264  CA  ALA C 132      16.734  69.864  17.763  1.00 24.16           C  
ATOM   3265  C   ALA C 132      17.517  70.204  16.476  1.00 24.31           C  
ATOM   3266  O   ALA C 132      18.461  69.481  16.122  1.00 23.87           O  
ATOM   3267  CB  ALA C 132      15.343  69.292  17.434  1.00 24.54           C  
ATOM   3268  N   LYS C 133      17.142  71.312  15.813  1.00 23.86           N  
ATOM   3269  CA  LYS C 133      17.854  71.828  14.625  1.00 23.64           C  
ATOM   3270  C   LYS C 133      19.337  72.179  14.858  1.00 23.61           C  
ATOM   3271  O   LYS C 133      20.215  71.664  14.156  1.00 23.54           O  
ATOM   3272  CB  LYS C 133      17.093  73.036  13.993  1.00 23.82           C  
ATOM   3273  N   LEU C 134      19.607  73.041  15.840  1.00 23.48           N  
ATOM   3274  CA  LEU C 134      20.961  73.515  16.145  1.00 23.45           C  
ATOM   3275  C   LEU C 134      21.880  72.429  16.709  1.00 24.66           C  
ATOM   3276  O   LEU C 134      23.104  72.569  16.658  1.00 25.00           O  
ATOM   3277  CB  LEU C 134      20.899  74.682  17.126  1.00 23.26           C  
ATOM   3278  CG  LEU C 134      21.851  75.860  16.928  1.00 22.45           C  
ATOM   3279  CD1 LEU C 134      21.226  77.183  17.420  1.00 20.17           C  
ATOM   3280  CD2 LEU C 134      23.140  75.604  17.621  1.00 16.01           C  
ATOM   3281  N   SER C 135      21.302  71.350  17.245  1.00 24.63           N  
ATOM   3282  CA  SER C 135      22.102  70.223  17.736  1.00 25.01           C  
ATOM   3283  C   SER C 135      22.898  69.603  16.588  1.00 25.70           C  
ATOM   3284  O   SER C 135      23.919  68.954  16.812  1.00 25.63           O  
ATOM   3285  CB  SER C 135      21.221  69.177  18.424  1.00 24.32           C  
ATOM   3286  N   THR C 136      22.417  69.825  15.363  1.00 25.98           N  
ATOM   3287  CA  THR C 136      23.075  69.359  14.144  1.00 27.46           C  
ATOM   3288  C   THR C 136      24.358  70.149  13.817  1.00 28.67           C  
ATOM   3289  O   THR C 136      25.364  69.560  13.391  1.00 28.38           O  
ATOM   3290  CB  THR C 136      22.097  69.416  12.967  1.00 27.43           C  
ATOM   3291  N   ARG C 137      24.307  71.469  14.038  1.00 29.72           N  
ATOM   3292  CA  ARG C 137      25.386  72.417  13.690  1.00 30.24           C  
ATOM   3293  C   ARG C 137      26.712  72.221  14.438  1.00 30.91           C  
ATOM   3294  O   ARG C 137      27.766  72.674  13.974  1.00 29.97           O  
ATOM   3295  CB  ARG C 137      24.905  73.866  13.872  1.00 30.48           C  
ATOM   3296  CG  ARG C 137      25.795  74.894  13.187  1.00 28.74           C  
ATOM   3297  CD  ARG C 137      25.456  76.310  13.591  1.00 25.24           C  
ATOM   3298  NE  ARG C 137      25.922  77.267  12.587  1.00 19.64           N  
ATOM   3299  CZ  ARG C 137      25.202  77.658  11.535  1.00 18.23           C  
ATOM   3300  NH1 ARG C 137      25.706  78.533  10.667  1.00  6.56           N  
ATOM   3301  NH2 ARG C 137      23.973  77.181  11.352  1.00 20.03           N  
ATOM   3302  N   LEU C 138      26.657  71.563  15.594  1.00 32.18           N  
ATOM   3303  CA  LEU C 138      27.866  71.276  16.360  1.00 33.25           C  
ATOM   3304  C   LEU C 138      28.626  70.144  15.669  1.00 33.57           C  
ATOM   3305  O   LEU C 138      28.408  68.965  15.974  1.00 33.33           O  
ATOM   3306  CB  LEU C 138      27.552  70.896  17.818  1.00 33.48           C  
ATOM   3307  CG  LEU C 138      26.160  70.842  18.467  1.00 35.08           C  
ATOM   3308  CD1 LEU C 138      26.311  70.365  19.902  1.00 36.39           C  
ATOM   3309  CD2 LEU C 138      25.415  72.158  18.456  1.00 36.32           C  
ATOM   3310  N   HIS C 139      29.501  70.518  14.731  1.00 34.12           N  
ATOM   3311  CA  HIS C 139      30.277  69.566  13.926  1.00 34.75           C  
ATOM   3312  C   HIS C 139      31.439  68.950  14.719  1.00 35.21           C  
ATOM   3313  O   HIS C 139      31.651  67.726  14.690  1.00 35.40           O  
ATOM   3314  CB  HIS C 139      30.828  70.230  12.655  1.00 34.61           C  
ATOM   3315  CG  HIS C 139      29.794  70.930  11.822  1.00 35.63           C  
ATOM   3316  ND1 HIS C 139      30.071  72.076  11.105  1.00 36.94           N  
ATOM   3317  CD2 HIS C 139      28.491  70.645  11.582  1.00 36.41           C  
ATOM   3318  CE1 HIS C 139      28.985  72.468  10.464  1.00 35.46           C  
ATOM   3319  NE2 HIS C 139      28.011  71.619  10.737  1.00 34.53           N  
ATOM   3320  N   GLN C 140      32.189  69.811  15.412  1.00 35.30           N  
ATOM   3321  CA  GLN C 140      33.354  69.414  16.215  1.00 35.07           C  
ATOM   3322  C   GLN C 140      34.427  68.635  15.425  1.00 35.07           C  
ATOM   3323  O   GLN C 140      34.866  69.084  14.367  1.00 34.93           O  
ATOM   3324  CB  GLN C 140      32.912  68.660  17.487  1.00 35.18           C  
ATOM   3325  N   ARG C 141      34.846  67.479  15.942  1.00 35.32           N  
ATOM   3326  CA  ARG C 141      35.926  66.699  15.337  1.00 35.26           C  
ATOM   3327  C   ARG C 141      35.565  65.220  15.267  1.00 35.24           C  
ATOM   3328  O   ARG C 141      36.396  64.383  14.911  1.00 35.36           O  
ATOM   3329  CB  ARG C 141      37.232  66.901  16.113  1.00 35.22           C  
ATOM   3330  N   GLU C 144      38.300  70.246  16.002  1.00 16.70           N  
ATOM   3331  CA  GLU C 144      37.395  71.334  16.364  1.00 16.89           C  
ATOM   3332  C   GLU C 144      36.530  71.002  17.585  1.00 16.98           C  
ATOM   3333  O   GLU C 144      35.736  71.838  18.037  1.00 17.50           O  
ATOM   3334  CB  GLU C 144      36.522  71.730  15.167  1.00 16.75           C  
ATOM   3335  N   ILE C 145      36.676  69.782  18.107  1.00 16.80           N  
ATOM   3336  CA  ILE C 145      36.059  69.408  19.386  1.00 16.72           C  
ATOM   3337  C   ILE C 145      36.800  70.119  20.511  1.00 16.46           C  
ATOM   3338  O   ILE C 145      37.852  69.652  20.962  1.00 16.56           O  
ATOM   3339  CB  ILE C 145      36.090  67.886  19.596  1.00 16.40           C  
ATOM   3340  N   GLU C 146      36.261  71.264  20.936  1.00 16.04           N  
ATOM   3341  CA  GLU C 146      36.840  72.038  22.040  1.00 15.41           C  
ATOM   3342  C   GLU C 146      36.576  71.352  23.382  1.00 14.72           C  
ATOM   3343  O   GLU C 146      37.418  70.593  23.860  1.00 14.49           O  
ATOM   3344  CB  GLU C 146      36.311  73.471  22.041  1.00 15.83           C  
ATOM   3345  N   THR C 147      35.403  71.613  23.960  1.00 13.96           N  
ATOM   3346  CA  THR C 147      34.986  71.028  25.227  1.00 13.21           C  
ATOM   3347  C   THR C 147      33.843  70.046  24.998  1.00 13.67           C  
ATOM   3348  O   THR C 147      33.369  69.883  23.869  1.00 13.59           O  
ATOM   3349  CB  THR C 147      34.540  72.122  26.184  1.00 12.80           C  
ATOM   3350  N   LEU C 148      33.422  69.372  26.069  1.00 13.65           N  
ATOM   3351  CA  LEU C 148      32.156  68.653  26.092  1.00 13.77           C  
ATOM   3352  C   LEU C 148      31.248  69.343  27.102  1.00 14.43           C  
ATOM   3353  O   LEU C 148      30.315  68.738  27.618  1.00 13.55           O  
ATOM   3354  CB  LEU C 148      32.342  67.189  26.485  1.00 13.51           C  
ATOM   3355  CG  LEU C 148      33.406  66.296  25.857  1.00 13.19           C  
ATOM   3356  CD1 LEU C 148      33.027  64.846  26.102  1.00 12.54           C  
ATOM   3357  CD2 LEU C 148      33.559  66.557  24.368  1.00 18.21           C  
ATOM   3358  N   SER C 149      31.560  70.605  27.400  1.00 15.48           N  
ATOM   3359  CA  SER C 149      30.761  71.432  28.292  1.00 17.09           C  
ATOM   3360  C   SER C 149      29.914  72.394  27.464  1.00 18.70           C  
ATOM   3361  O   SER C 149      30.270  72.722  26.328  1.00 17.54           O  
ATOM   3362  CB  SER C 149      31.658  72.195  29.253  1.00 17.35           C  
ATOM   3363  N   LEU C 150      28.781  72.817  28.034  1.00 21.17           N  
ATOM   3364  CA  LEU C 150      27.776  73.668  27.351  1.00 22.80           C  
ATOM   3365  C   LEU C 150      27.018  72.962  26.219  1.00 23.50           C  
ATOM   3366  O   LEU C 150      26.002  72.293  26.469  1.00 24.49           O  
ATOM   3367  CB  LEU C 150      28.388  74.993  26.860  1.00 23.34           C  
TER    3368      LEU C 150                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
