
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1122),  selected  147 , name 2pqq_A
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 2pqq_A.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -1_A      M       1           -
LGA    H     0_A      H       2           -
LGA    X     1_A      T       3          3.795
LGA    -       -      A       4           -
LGA    -       -      L       5           -
LGA    D     2_A      I       6          1.543
LGA    D     3_A      N       7          1.237
LGA    V     4_A      H       8          3.431
LGA    L     5_A      I       9          4.468
LGA    R     6_A      R      10           #
LGA    R     7_A      K      11           #
LGA    N     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    F    11_A      -       -           -
LGA    A    12_A      F      12          3.322
LGA    A    13_A      I      13          2.629
LGA    L    14_A      F      14          5.063
LGA    D    15_A      L      15          1.793
LGA    D    16_A      T      16          3.704
LGA    E    17_A      D      17          3.979
LGA    -       -      E      18           -
LGA    Q    18_A      D      19          3.523
LGA    S    19_A      A      20          3.518
LGA    A    20_A      G      21          3.237
LGA    E    21_A      T      22          2.295
LGA    L    22_A      L      23          2.025
LGA    R    23_A      S      24          1.640
LGA    A    24_A      A      25          2.037
LGA    S    25_A      F      26          1.373
LGA    X    26_A      F      27          0.363
LGA    S    27_A      Q      28          0.375
LGA    E    28_A      L      29          0.908
LGA    V    29_A      K      30          1.050
LGA    T    30_A      K      31          1.314
LGA    L    31_A      V      32          1.003
LGA    A    32_A      R      33          1.222
LGA    R    33_A      K      34          1.645
LGA    G    34_A      K      35          1.557
LGA    D    35_A      E      36          0.883
LGA    T    36_A      T      37          0.551
LGA    L    37_A      L      38          1.276
LGA    F    38_A      L      39          0.943
LGA    H    39_A      K      40          0.927
LGA    E    40_A      T      41          1.970
LGA    G    41_A      G      42          2.237
LGA    D    42_A      E      43          1.423
LGA    P    43_A      I      44          0.784
LGA    G    44_A      C      45          1.054
LGA    D    45_A      R      46          2.067
LGA    R    46_A      I      47          1.755
LGA    L    47_A      N      48          1.117
LGA    Y    48_A      Y      49          0.771
LGA    V    49_A      F      50          0.144
LGA    V    50_A      V      51          0.725
LGA    T    51_A      V      52          0.728
LGA    E    52_A      K      53          0.953
LGA    G    53_A      G      54          1.356
LGA    K    54_A      C      55          1.441
LGA    V    55_A      L      56          1.352
LGA    K    56_A      R      57          1.915
LGA    L    57_A      L      58          1.528
LGA    H    58_A      F      59          0.966
LGA    R    59_A      F      60          0.930
LGA    T    60_A      I      61          1.305
LGA    S    61_A      D      62          1.587
LGA    P    62_A      E      63          3.321
LGA    D    63_A      K      64          2.422
LGA    G    64_A      G      65          2.035
LGA    R    65_A      I      66          0.799
LGA    E    66_A      E      67          0.619
LGA    N    67_A      Q      68          0.480
LGA    X    68_A      T      69          1.297
LGA    L    69_A      T      70          1.160
LGA    A    70_A      Q      71          1.775
LGA    V    71_A      F      72          2.132
LGA    V    72_A      A      73          1.626
LGA    G    73_A      I      74          1.370
LGA    P    74_A      E      75          0.845
LGA    S    75_A      N      76          0.735
LGA    E    76_A      W      77          0.945
LGA    L    77_A      W      78          0.192
LGA    I    78_A      L      79          0.727
LGA    G    79_A      S      80          1.653
LGA    E    80_A      D      81           -
LGA    -       -      Y      82           -
LGA    -       -      M      83           -
LGA    -       -      A      84           -
LGA    L    81_A      F      85           #
LGA    S    82_A      Q      86          3.713
LGA    L    83_A      -       -           -
LGA    F    84_A      -       -           -
LGA    D    85_A      K      87          4.142
LGA    P    86_A      Q      88          2.519
LGA    G    87_A      Q      89          2.863
LGA    P    88_A      P      90          2.687
LGA    R    89_A      A      91          2.292
LGA    T    90_A      D      92          2.575
LGA    A    91_A      F      93          1.552
LGA    T    92_A      Y      94          0.874
LGA    G    93_A      I      95          1.363
LGA    T    94_A      Q      96          1.461
LGA    A    95_A      S      97          1.388
LGA    L    96_A      V      98          1.802
LGA    T    97_A      E      99          1.845
LGA    E    98_A      N     100          1.231
LGA    V    99_A      C     101          1.023
LGA    K   100_A      E     102          1.272
LGA    L   101_A      L     103          0.449
LGA    L   102_A      L     104          0.227
LGA    A   103_A      S     105          0.595
LGA    L   104_A      I     106          1.091
LGA    G   105_A      T     107          1.094
LGA    H   106_A      Y     108          2.197
LGA    G   107_A      T     109          2.793
LGA    D   108_A      E     110          1.980
LGA    L   109_A      Q     111          3.753
LGA    Q   110_A      E     112           #
LGA    P   111_A      N     113          4.935
LGA    W   112_A      L     114          3.664
LGA    -       -      F     115           -
LGA    L   113_A      E     116          2.776
LGA    N   114_A      R     117          4.644
LGA    V   115_A      -       -           -
LGA    R   116_A      -       -           -
LGA    P   117_A      -       -           -
LGA    E   118_A      I     118          5.031
LGA    V   119_A      P     119          1.328
LGA    A   120_A      -       -           -
LGA    T   121_A      A     120           #
LGA    A   122_A      L     121          4.725
LGA    L   123_A      E     122          1.837
LGA    L   124_A      -       -           -
LGA    R   125_A      R     123          5.182
LGA    A   126_A      Y     124           #
LGA    -       -      F     125           -
LGA    V   127_A      R     126          4.031
LGA    A   128_A      L     127           -
LGA    R   129_A      V     128           -
LGA    -       -      Y     129           -
LGA    R   130_A      Q     130          4.007
LGA    L   131_A      K     131           -
LGA    R   132_A      S     132           -
LGA    K   133_A      -       -           -
LGA    T   134_A      F     133           #
LGA    N   135_A      A     134           -
LGA    D   136_A      A     135           -
LGA    A   137_A      A     136           -
LGA    X   138_A      Q     137           -
LGA    L   141_A      L     138           -
LGA    V   142_A      R     139           -
LGA    F   143_A      S     140           -
LGA    S   144_A      K     141           -
LGA    D   145_A      F     142           -
LGA    G   146_A      Q     143           -
LGA    S   147_A      H     144           -
LGA    -       -      M     145           -
LGA    -       -      Y     146           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  146    5.0    110    2.29    13.64     62.490     4.600

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.422123 * X  +  -0.464246 * Y  +  -0.778645 * Z  +  49.035938
  Y_new =  -0.627792 * X  +  -0.469925 * Y  +   0.620522 * Z  + 125.402298
  Z_new =  -0.653980 * X  +   0.750764 * Y  +  -0.093083 * Z  +  -3.300655 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.694152   -1.447441  [ DEG:    97.0677    -82.9323 ]
  Theta =   0.712833    2.428760  [ DEG:    40.8423    139.1577 ]
  Phi   =  -2.162754    0.978839  [ DEG:  -123.9166     56.0834 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pqq_A                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pqq_A.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  146   5.0  110   2.29   13.64  62.490
REMARK  ---------------------------------------------------------- 
MOLECULE 2pqq_A
HEADER    TRANSCRIPTION                           02-MAY-07   2PQQ              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF THE N-                  
TITLE    2 TERMINAL DOMAIN OF A TRANSCRIPTIONAL REGULATOR FROM                  
TITLE    3 STREPTOMYCES COELICOLOR A3(2)                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE TRANSCRIPTIONAL REGULATOR;                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN;                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES COELICOLOR;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: A3(2), M145;                                                 
SOURCE   5 ATCC: BAA-471;                                                       
SOURCE   6 GENE: SCO3571, SCH17.05;                                             
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: P15TV LIC                                 
KEYWDS    APC7345, TRANSCRIPTIONAL REGULATOR, STREPTOMYCES COELICOLOR           
KEYWDS   2 A3(2), STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE                 
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,                
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   05-JUN-07 2PQQ    0                                                
JRNL        AUTH   K.TAN,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                    
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE N-TERMINAL DOMAIN OF            
JRNL        TITL 2 A TRANSCRIPTIONAL REGULATOR FROM STREPTOMYCES                
JRNL        TITL 3 COELICOLOR A3(2)                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2PQQ A    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
DBREF  2PQQ B    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
DBREF  2PQQ C    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
DBREF  2PQQ D    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
SEQRES   1 A  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 A  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 A  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 A  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 A  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 A  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 A  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 A  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 A  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 A  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 A  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 A  149  VAL PHE SER ASP GLY SER                                      
SEQRES   1 B  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 B  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 B  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 B  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 B  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 B  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 B  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 B  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 B  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 B  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 B  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 B  149  VAL PHE SER ASP GLY SER                                      
SEQRES   1 C  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 C  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 C  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 C  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 C  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 C  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 C  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 C  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 C  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 C  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 C  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 C  149  VAL PHE SER ASP GLY SER                                      
SEQRES   1 D  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 D  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 D  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 D  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 D  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 D  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 D  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 D  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 D  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 D  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 D  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 D  149  VAL PHE SER ASP GLY SER                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  26       8                                                       
HET    MSE  A  68       8                                                       
HET    MSE  A 138       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  26       8                                                       
HET    MSE  B  68       8                                                       
HET    MSE  B 138       8                                                       
HET    MSE  C  26       8                                                       
HET    MSE  C  68       8                                                       
HET    MSE  C 138       8                                                       
HET    MSE  D  26       8                                                       
HET    MSE  D  68       8                                                       
HET    MSE  D 138       8                                                       
HET    FMT    301       3                                                       
HET    FMT    302       3                                                       
HET    FMT    303       3                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     FMT FORMIC ACID                                                      
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   5  FMT    3(C H2 O2)                                                   
FORMUL   8  HOH   *251(H2 O)                                                    
CRYST1   39.852  100.946  144.119  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   GLY A  -1      -4.475  74.714   9.953  1.00 44.83           N  
ATOM      2  CA  GLY A  -1      -3.227  73.909  10.111  1.00 45.08           C  
ATOM      3  C   GLY A  -1      -2.156  74.249   9.090  1.00 45.19           C  
ATOM      4  O   GLY A  -1      -1.036  74.622   9.456  1.00 44.67           O  
ATOM      5  N   HIS A   0      -2.496  74.116   7.807  1.00 45.56           N  
ATOM      6  CA  HIS A   0      -1.537  74.350   6.711  1.00 46.10           C  
ATOM      7  C   HIS A   0      -1.273  75.830   6.430  1.00 45.92           C  
ATOM      8  O   HIS A   0      -0.420  76.192   5.602  1.00 46.10           O  
ATOM      9  CB  HIS A   0      -1.938  73.573   5.450  1.00 46.91           C  
ATOM     10  CG  HIS A   0      -1.074  72.372   5.203  1.00 48.80           C  
ATOM     11  ND1 HIS A   0      -0.152  72.317   4.179  1.00 50.49           N  
ATOM     12  CD2 HIS A   0      -0.939  71.216   5.893  1.00 49.51           C  
ATOM     13  CE1 HIS A   0       0.485  71.162   4.224  1.00 51.54           C  
ATOM     14  NE2 HIS A   0       0.024  70.473   5.253  1.00 51.71           N  
HETATM   15  N   MSE A   1      -1.982  76.667   7.180  1.00 45.48           N  
HETATM   16  CA  MSE A   1      -1.844  78.117   7.161  1.00 45.18           C  
HETATM   17  C   MSE A   1      -0.385  78.586   7.103  1.00 43.92           C  
HETATM   18  O   MSE A   1       0.038  79.257   6.149  1.00 44.50           O  
HETATM   19  CB  MSE A   1      -2.545  78.679   8.409  1.00 45.83           C  
HETATM   20  CG  MSE A   1      -2.526  80.174   8.514  1.00 48.17           C  
HETATM   21 SE   MSE A   1      -2.965  80.890   6.771  0.30 52.97          SE  
HETATM   22  CE  MSE A   1      -4.910  80.842   6.960  1.00 53.52           C  
ATOM     23  N   ASP A   2       0.381  78.214   8.117  1.00 42.16           N  
ATOM     24  CA  ASP A   2       1.737  78.719   8.280  1.00 40.87           C  
ATOM     25  C   ASP A   2       2.783  77.602   8.187  1.00 39.80           C  
ATOM     26  O   ASP A   2       3.849  77.669   8.799  1.00 38.35           O  
ATOM     27  CB  ASP A   2       1.845  79.515   9.590  1.00 40.86           C  
ATOM     28  CG  ASP A   2       0.926  80.741   9.606  1.00 41.87           C  
ATOM     29  OD1 ASP A   2       0.912  81.479   8.594  1.00 42.46           O  
ATOM     30  OD2 ASP A   2       0.222  80.964  10.622  1.00 42.27           O  
ATOM     31  N   ASP A   3       2.471  76.599   7.377  1.00 38.91           N  
ATOM     32  CA  ASP A   3       3.339  75.455   7.208  1.00 39.14           C  
ATOM     33  C   ASP A   3       4.671  75.919   6.671  1.00 38.29           C  
ATOM     34  O   ASP A   3       5.699  75.401   7.093  1.00 38.45           O  
ATOM     35  CB  ASP A   3       2.709  74.382   6.293  1.00 39.37           C  
ATOM     36  CG  ASP A   3       3.611  73.151   6.114  1.00 42.11           C  
ATOM     37  OD1 ASP A   3       3.569  72.535   5.032  1.00 44.01           O  
ATOM     38  OD2 ASP A   3       4.372  72.791   7.047  1.00 45.76           O  
ATOM     39  N   VAL A   4       4.655  76.920   5.781  1.00 37.70           N  
ATOM     40  CA  VAL A   4       5.908  77.493   5.242  1.00 37.56           C  
ATOM     41  C   VAL A   4       6.878  77.945   6.327  1.00 37.77           C  
ATOM     42  O   VAL A   4       8.101  77.934   6.116  1.00 37.56           O  
ATOM     43  CB  VAL A   4       5.654  78.630   4.206  1.00 38.09           C  
ATOM     44  CG1 VAL A   4       5.247  79.937   4.883  1.00 36.58           C  
ATOM     45  CG2 VAL A   4       6.887  78.831   3.264  1.00 37.84           C  
ATOM     46  N   LEU A   5       6.344  78.341   7.489  1.00 36.95           N  
ATOM     47  CA  LEU A   5       7.194  78.858   8.551  1.00 37.27           C  
ATOM     48  C   LEU A   5       7.763  77.758   9.433  1.00 37.39           C  
ATOM     49  O   LEU A   5       8.625  78.021  10.262  1.00 38.14           O  
ATOM     50  CB  LEU A   5       6.450  79.892   9.400  1.00 36.61           C  
ATOM     51  CG  LEU A   5       5.883  81.111   8.664  1.00 37.22           C  
ATOM     52  CD1 LEU A   5       5.150  82.014   9.658  1.00 36.33           C  
ATOM     53  CD2 LEU A   5       6.978  81.891   7.893  1.00 37.03           C  
ATOM     54  N   ARG A   6       7.296  76.530   9.248  1.00 37.42           N  
ATOM     55  CA  ARG A   6       7.667  75.449  10.153  1.00 37.62           C  
ATOM     56  C   ARG A   6       8.601  74.389   9.558  1.00 37.66           C  
ATOM     57  O   ARG A   6       8.988  73.446  10.255  1.00 37.48           O  
ATOM     58  CB  ARG A   6       6.406  74.798  10.708  1.00 37.75           C  
ATOM     59  CG  ARG A   6       5.618  75.730  11.639  1.00 37.33           C  
ATOM     60  CD  ARG A   6       4.562  74.912  12.404  1.00 36.03           C  
ATOM     61  NE  ARG A   6       3.606  74.238  11.528  1.00 36.82           N  
ATOM     62  CZ  ARG A   6       2.446  74.757  11.136  1.00 37.62           C  
ATOM     63  NH1 ARG A   6       2.105  75.989  11.511  1.00 36.61           N  
ATOM     64  NH2 ARG A   6       1.643  74.053  10.349  1.00 34.73           N  
ATOM     65  N   ARG A   7       8.971  74.547   8.290  1.00 37.82           N  
ATOM     66  CA  ARG A   7       9.878  73.600   7.623  1.00 38.31           C  
ATOM     67  C   ARG A   7      11.350  73.936   7.878  1.00 38.29           C  
ATOM     68  O   ARG A   7      12.146  74.152   6.953  1.00 38.25           O  
ATOM     69  CB  ARG A   7       9.541  73.472   6.134  1.00 38.34           C  
ATOM     70  CG  ARG A   7       8.150  72.885   5.879  1.00 39.89           C  
ATOM     71  CD  ARG A   7       8.027  71.462   6.473  1.00 44.09           C  
ATOM     72  NE  ARG A   7       6.775  70.785   6.120  1.00 45.45           N  
ATOM     73  CZ  ARG A   7       6.576  69.468   6.218  1.00 48.24           C  
ATOM     74  NH1 ARG A   7       7.546  68.667   6.656  1.00 49.03           N  
ATOM     75  NH2 ARG A   7       5.405  68.938   5.868  1.00 47.09           N  
ATOM     76  N   ASN A   8      11.707  73.957   9.156  1.00 38.24           N  
ATOM     77  CA  ASN A   8      13.027  74.378   9.595  1.00 38.66           C  
ATOM     78  C   ASN A   8      13.216  73.997  11.070  1.00 39.47           C  
ATOM     79  O   ASN A   8      12.234  73.871  11.805  1.00 39.66           O  
ATOM     80  CB  ASN A   8      13.180  75.884   9.392  1.00 38.66           C  
ATOM     81  CG  ASN A   8      12.293  76.701  10.336  1.00 38.01           C  
ATOM     82  OD1 ASN A   8      12.659  76.928  11.487  1.00 37.67           O  
ATOM     83  ND2 ASN A   8      11.149  77.188   9.833  1.00 36.54           N  
ATOM     84  N   PRO A   9      14.471  73.808  11.507  1.00 39.72           N  
ATOM     85  CA  PRO A   9      14.819  73.358  12.858  1.00 40.04           C  
ATOM     86  C   PRO A   9      14.522  74.361  13.989  1.00 39.65           C  
ATOM     87  O   PRO A   9      14.672  74.017  15.166  1.00 40.70           O  
ATOM     88  CB  PRO A   9      16.341  73.144  12.767  1.00 40.22           C  
ATOM     89  CG  PRO A   9      16.617  73.000  11.288  1.00 40.62           C  
ATOM     90  CD  PRO A   9      15.675  73.984  10.682  1.00 40.64           C  
ATOM     91  N   LEU A  10      14.126  75.579  13.660  1.00 38.31           N  
ATOM     92  CA  LEU A  10      13.865  76.554  14.716  1.00 37.57           C  
ATOM     93  C   LEU A  10      12.405  76.566  15.123  1.00 36.82           C  
ATOM     94  O   LEU A  10      12.096  76.524  16.326  1.00 35.94           O  
ATOM     95  CB  LEU A  10      14.284  77.975  14.309  1.00 37.10           C  
ATOM     96  CG  LEU A  10      14.080  79.047  15.388  1.00 37.93           C  
ATOM     97  CD1 LEU A  10      14.723  78.660  16.748  1.00 34.66           C  
ATOM     98  CD2 LEU A  10      14.599  80.449  14.912  1.00 37.32           C  
ATOM     99  N   PHE A  11      11.516  76.638  14.122  1.00 36.13           N  
ATOM    100  CA  PHE A  11      10.077  76.844  14.371  1.00 35.49           C  
ATOM    101  C   PHE A  11       9.249  75.579  14.158  1.00 35.41           C  
ATOM    102  O   PHE A  11       8.017  75.635  14.169  1.00 35.14           O  
ATOM    103  CB  PHE A  11       9.528  77.948  13.472  1.00 34.96           C  
ATOM    104  CG  PHE A  11      10.172  79.284  13.672  1.00 36.90           C  
ATOM    105  CD1 PHE A  11      10.295  79.845  14.949  1.00 35.02           C  
ATOM    106  CD2 PHE A  11      10.623  80.011  12.573  1.00 36.29           C  
ATOM    107  CE1 PHE A  11      10.864  81.113  15.116  1.00 36.96           C  
ATOM    108  CE2 PHE A  11      11.176  81.265  12.732  1.00 36.92           C  
ATOM    109  CZ  PHE A  11      11.315  81.824  13.998  1.00 35.81           C  
ATOM    110  N   ALA A  12       9.927  74.444  13.962  1.00 35.30           N  
ATOM    111  CA  ALA A  12       9.255  73.195  13.609  1.00 35.05           C  
ATOM    112  C   ALA A  12       8.209  72.766  14.635  1.00 34.64           C  
ATOM    113  O   ALA A  12       7.184  72.194  14.266  1.00 33.95           O  
ATOM    114  CB  ALA A  12      10.273  72.057  13.364  1.00 35.48           C  
ATOM    115  N   ALA A  13       8.453  73.052  15.916  1.00 34.37           N  
ATOM    116  CA  ALA A  13       7.575  72.534  16.977  1.00 34.56           C  
ATOM    117  C   ALA A  13       6.466  73.496  17.400  1.00 34.96           C  
ATOM    118  O   ALA A  13       5.644  73.164  18.256  1.00 35.14           O  
ATOM    119  CB  ALA A  13       8.387  72.092  18.191  1.00 34.68           C  
ATOM    120  N   LEU A  14       6.434  74.674  16.793  1.00 34.57           N  
ATOM    121  CA  LEU A  14       5.443  75.688  17.143  1.00 34.93           C  
ATOM    122  C   LEU A  14       4.068  75.157  16.831  1.00 34.93           C  
ATOM    123  O   LEU A  14       3.871  74.491  15.784  1.00 33.19           O  
ATOM    124  CB  LEU A  14       5.694  76.989  16.364  1.00 35.11           C  
ATOM    125  CG  LEU A  14       6.898  77.908  16.666  1.00 36.23           C  
ATOM    126  CD1 LEU A  14       6.644  79.258  16.018  1.00 35.20           C  
ATOM    127  CD2 LEU A  14       7.188  78.096  18.180  1.00 37.24           C  
ATOM    128  N   ASP A  15       3.125  75.414  17.743  1.00 35.76           N  
ATOM    129  CA  ASP A  15       1.715  75.102  17.483  1.00 36.80           C  
ATOM    130  C   ASP A  15       1.108  76.120  16.504  1.00 37.62           C  
ATOM    131  O   ASP A  15       1.788  77.075  16.093  1.00 36.82           O  
ATOM    132  CB  ASP A  15       0.884  74.937  18.783  1.00 37.24           C  
ATOM    133  CG  ASP A  15       0.803  76.211  19.629  1.00 38.83           C  
ATOM    134  OD1 ASP A  15       0.951  77.335  19.090  1.00 39.07           O  
ATOM    135  OD2 ASP A  15       0.568  76.075  20.860  1.00 38.50           O  
ATOM    136  N   ASP A  16      -0.151  75.902  16.122  1.00 38.17           N  
ATOM    137  CA  ASP A  16      -0.833  76.771  15.162  1.00 39.44           C  
ATOM    138  C   ASP A  16      -0.968  78.210  15.683  1.00 40.09           C  
ATOM    139  O   ASP A  16      -0.809  79.171  14.915  1.00 40.22           O  
ATOM    140  CB  ASP A  16      -2.202  76.197  14.773  1.00 39.30           C  
ATOM    141  CG  ASP A  16      -2.102  74.927  13.913  1.00 40.60           C  
ATOM    142  OD1 ASP A  16      -0.973  74.517  13.535  1.00 41.36           O  
ATOM    143  OD2 ASP A  16      -3.163  74.341  13.601  1.00 38.88           O  
ATOM    144  N   GLU A  17      -1.236  78.366  16.981  1.00 40.58           N  
ATOM    145  CA  GLU A  17      -1.389  79.708  17.546  1.00 41.72           C  
ATOM    146  C   GLU A  17      -0.054  80.442  17.545  1.00 40.59           C  
ATOM    147  O   GLU A  17      -0.002  81.609  17.169  1.00 41.16           O  
ATOM    148  CB  GLU A  17      -2.028  79.715  18.954  1.00 41.32           C  
ATOM    149  CG  GLU A  17      -1.552  80.914  19.828  1.00 43.94           C  
ATOM    150  CD  GLU A  17      -2.554  81.437  20.868  1.00 45.02           C  
ATOM    151  OE1 GLU A  17      -2.129  81.627  22.040  1.00 50.54           O  
ATOM    152  OE2 GLU A  17      -3.746  81.692  20.532  1.00 48.55           O  
ATOM    153  N   GLN A  18       1.018  79.767  17.961  1.00 39.78           N  
ATOM    154  CA  GLN A  18       2.341  80.387  18.000  1.00 38.82           C  
ATOM    155  C   GLN A  18       2.802  80.746  16.587  1.00 38.26           C  
ATOM    156  O   GLN A  18       3.391  81.804  16.378  1.00 38.94           O  
ATOM    157  CB  GLN A  18       3.363  79.501  18.716  1.00 39.06           C  
ATOM    158  CG  GLN A  18       3.065  79.263  20.208  1.00 39.27           C  
ATOM    159  CD  GLN A  18       3.723  78.007  20.749  1.00 41.46           C  
ATOM    160  OE1 GLN A  18       4.036  77.056  20.002  1.00 41.76           O  
ATOM    161  NE2 GLN A  18       3.932  77.987  22.057  1.00 38.83           N  
ATOM    162  N   SER A  19       2.511  79.877  15.630  1.00 37.70           N  
ATOM    163  CA  SER A  19       2.817  80.120  14.217  1.00 37.78           C  
ATOM    164  C   SER A  19       2.048  81.348  13.687  1.00 38.05           C  
ATOM    165  O   SER A  19       2.572  82.102  12.867  1.00 37.69           O  
ATOM    166  CB  SER A  19       2.451  78.897  13.378  1.00 37.22           C  
ATOM    167  OG  SER A  19       3.178  77.745  13.789  1.00 36.74           O  
ATOM    168  N   ALA A  20       0.799  81.520  14.131  1.00 37.67           N  
ATOM    169  CA  ALA A  20       0.027  82.711  13.777  1.00 37.58           C  
ATOM    170  C   ALA A  20       0.681  84.005  14.326  1.00 37.89           C  
ATOM    171  O   ALA A  20       0.774  85.014  13.608  1.00 38.01           O  
ATOM    172  CB  ALA A  20      -1.427  82.559  14.247  1.00 38.28           C  
ATOM    173  N   GLU A  21       1.164  83.957  15.570  1.00 36.90           N  
ATOM    174  CA  GLU A  21       1.812  85.105  16.213  1.00 37.85           C  
ATOM    175  C   GLU A  21       3.106  85.483  15.492  1.00 36.83           C  
ATOM    176  O   GLU A  21       3.352  86.654  15.226  1.00 36.90           O  
ATOM    177  CB  GLU A  21       2.142  84.811  17.677  1.00 37.69           C  
ATOM    178  CG  GLU A  21       0.935  84.466  18.561  1.00 40.44           C  
ATOM    179  CD  GLU A  21       1.353  83.873  19.918  1.00 40.10           C  
ATOM    180  OE1 GLU A  21       2.471  83.326  20.025  1.00 40.93           O  
ATOM    181  OE2 GLU A  21       0.567  83.969  20.877  1.00 43.46           O  
ATOM    182  N   LEU A  22       3.923  84.469  15.221  1.00 36.24           N  
ATOM    183  CA  LEU A  22       5.120  84.565  14.378  1.00 35.87           C  
ATOM    184  C   LEU A  22       4.810  85.264  13.059  1.00 35.56           C  
ATOM    185  O   LEU A  22       5.484  86.234  12.702  1.00 35.67           O  
ATOM    186  CB  LEU A  22       5.679  83.170  14.110  1.00 35.22           C  
ATOM    187  CG  LEU A  22       6.898  83.084  13.180  1.00 35.70           C  
ATOM    188  CD1 LEU A  22       8.108  84.024  13.610  1.00 37.13           C  
ATOM    189  CD2 LEU A  22       7.307  81.610  13.054  1.00 35.86           C  
ATOM    190  N   ARG A  23       3.800  84.775  12.344  1.00 34.74           N  
ATOM    191  CA  ARG A  23       3.411  85.352  11.056  1.00 34.76           C  
ATOM    192  C   ARG A  23       2.988  86.810  11.159  1.00 34.09           C  
ATOM    193  O   ARG A  23       3.437  87.635  10.364  1.00 34.17           O  
ATOM    194  CB  ARG A  23       2.307  84.527  10.378  1.00 35.26           C  
ATOM    195  CG  ARG A  23       1.813  85.100   9.058  1.00 36.50           C  
ATOM    196  CD  ARG A  23       2.957  85.302   8.083  1.00 38.72           C  
ATOM    197  NE  ARG A  23       2.547  85.954   6.836  1.00 39.80           N  
ATOM    198  CZ  ARG A  23       2.704  87.244   6.573  1.00 39.37           C  
ATOM    199  NH1 ARG A  23       3.238  88.057   7.485  1.00 40.69           N  
ATOM    200  NH2 ARG A  23       2.326  87.724   5.400  1.00 37.80           N  
ATOM    201  N   ALA A  24       2.158  87.141  12.153  1.00 33.57           N  
ATOM    202  CA  ALA A  24       1.708  88.533  12.334  1.00 33.25           C  
ATOM    203  C   ALA A  24       2.890  89.453  12.674  1.00 33.21           C  
ATOM    204  O   ALA A  24       2.887  90.638  12.335  1.00 32.93           O  
ATOM    205  CB  ALA A  24       0.657  88.618  13.419  1.00 33.29           C  
ATOM    206  N   SER A  25       3.897  88.883  13.331  1.00 33.66           N  
ATOM    207  CA  SER A  25       5.081  89.652  13.767  1.00 34.40           C  
ATOM    208  C   SER A  25       6.047  89.965  12.652  1.00 35.06           C  
ATOM    209  O   SER A  25       6.866  90.875  12.781  1.00 34.25           O  
ATOM    210  CB  SER A  25       5.804  88.894  14.865  1.00 34.71           C  
ATOM    211  OG  SER A  25       5.010  88.932  16.029  1.00 33.36           O  
HETATM  212  N   MSE A  26       5.942  89.227  11.542  1.00 35.42           N  
HETATM  213  CA  MSE A  26       6.926  89.335  10.463  1.00 38.24           C  
HETATM  214  C   MSE A  26       6.603  90.436   9.454  1.00 38.48           C  
HETATM  215  O   MSE A  26       5.450  90.866   9.327  1.00 37.67           O  
HETATM  216  CB  MSE A  26       7.102  87.990   9.744  1.00 37.30           C  
HETATM  217  CG  MSE A  26       7.710  86.916  10.648  1.00 38.75           C  
HETATM  218 SE   MSE A  26       7.673  85.134   9.846  0.90 43.36          SE  
HETATM  219  CE  MSE A  26       9.602  84.980   9.538  1.00 36.54           C  
ATOM    220  N   SER A  27       7.634  90.897   8.753  1.00 39.19           N  
ATOM    221  CA  SER A  27       7.439  91.847   7.666  1.00 41.00           C  
ATOM    222  C   SER A  27       7.761  91.254   6.299  1.00 41.56           C  
ATOM    223  O   SER A  27       8.644  90.382   6.170  1.00 41.44           O  
ATOM    224  CB  SER A  27       8.195  93.153   7.924  1.00 41.50           C  
ATOM    225  OG  SER A  27       9.387  92.915   8.639  1.00 44.75           O  
ATOM    226  N   GLU A  28       7.003  91.690   5.295  1.00 41.08           N  
ATOM    227  CA  GLU A  28       7.154  91.231   3.922  1.00 41.63           C  
ATOM    228  C   GLU A  28       8.309  91.987   3.282  1.00 41.02           C  
ATOM    229  O   GLU A  28       8.442  93.191   3.470  1.00 40.79           O  
ATOM    230  CB  GLU A  28       5.882  91.531   3.124  1.00 42.73           C  
ATOM    231  CG  GLU A  28       4.995  90.332   2.845  1.00 46.72           C  
ATOM    232  CD  GLU A  28       5.453  89.573   1.606  1.00 52.06           C  
ATOM    233  OE1 GLU A  28       6.439  88.797   1.718  1.00 52.87           O  
ATOM    234  OE2 GLU A  28       4.825  89.761   0.527  1.00 52.49           O  
ATOM    235  N   VAL A  29       9.156  91.266   2.560  1.00 40.27           N  
ATOM    236  CA  VAL A  29      10.232  91.859   1.771  1.00 39.81           C  
ATOM    237  C   VAL A  29      10.093  91.296   0.333  1.00 39.38           C  
ATOM    238  O   VAL A  29       9.801  90.118   0.160  1.00 39.18           O  
ATOM    239  CB  VAL A  29      11.634  91.537   2.400  1.00 39.69           C  
ATOM    240  CG1 VAL A  29      12.751  92.080   1.545  1.00 40.11           C  
ATOM    241  CG2 VAL A  29      11.748  92.110   3.816  1.00 40.71           C  
ATOM    242  N   THR A  30      10.254  92.134  -0.689  1.00 38.34           N  
ATOM    243  CA  THR A  30      10.273  91.628  -2.063  1.00 38.70           C  
ATOM    244  C   THR A  30      11.466  92.206  -2.819  1.00 37.55           C  
ATOM    245  O   THR A  30      11.745  93.401  -2.759  1.00 38.29           O  
ATOM    246  CB  THR A  30       8.894  91.825  -2.810  1.00 39.06           C  
ATOM    247  OG1 THR A  30       9.056  91.714  -4.239  1.00 41.20           O  
ATOM    248  CG2 THR A  30       8.297  93.173  -2.478  1.00 39.94           C  
ATOM    249  N   LEU A  31      12.192  91.321  -3.483  1.00 36.17           N  
ATOM    250  CA  LEU A  31      13.383  91.680  -4.213  1.00 34.80           C  
ATOM    251  C   LEU A  31      13.127  91.441  -5.690  1.00 34.18           C  
ATOM    252  O   LEU A  31      12.484  90.466  -6.041  1.00 34.44           O  
ATOM    253  CB  LEU A  31      14.538  90.782  -3.781  1.00 34.11           C  
ATOM    254  CG  LEU A  31      14.919  90.673  -2.325  1.00 33.35           C  
ATOM    255  CD1 LEU A  31      16.029  89.633  -2.181  1.00 31.03           C  
ATOM    256  CD2 LEU A  31      15.370  92.034  -1.872  1.00 34.04           C  
ATOM    257  N   ALA A  32      13.623  92.337  -6.535  1.00 33.88           N  
ATOM    258  CA  ALA A  32      13.751  92.070  -7.966  1.00 34.13           C  
ATOM    259  C   ALA A  32      15.046  91.296  -8.214  1.00 33.93           C  
ATOM    260  O   ALA A  32      15.974  91.334  -7.402  1.00 33.77           O  
ATOM    261  CB  ALA A  32      13.770  93.366  -8.757  1.00 34.40           C  
ATOM    262  N   ARG A  33      15.113  90.607  -9.342  1.00 33.85           N  
ATOM    263  CA  ARG A  33      16.319  89.881  -9.741  0.50 34.03           C  
ATOM    265  C   ARG A  33      17.548  90.798  -9.731  1.00 33.76           C  
ATOM    266  O   ARG A  33      17.508  91.930 -10.245  1.00 33.91           O  
ATOM    267  CB  ARG A  33      16.109  89.250 -11.120  0.50 33.75           C  
ATOM    269  CG  ARG A  33      17.318  88.537 -11.702  0.50 34.68           C  
ATOM    271  CD  ARG A  33      17.037  88.039 -13.126  0.50 35.09           C  
ATOM    273  NE  ARG A  33      16.784  86.598 -13.165  0.50 38.14           N  
ATOM    275  CZ  ARG A  33      15.595  86.026 -13.353  0.50 39.18           C  
ATOM    277  NH1 ARG A  33      14.506  86.761 -13.537  0.50 39.77           N  
ATOM    279  NH2 ARG A  33      15.498  84.703 -13.367  0.50 39.28           N  
ATOM    281  N   GLY A  34      18.637  90.313  -9.139  1.00 33.26           N  
ATOM    282  CA  GLY A  34      19.854  91.094  -9.024  1.00 33.73           C  
ATOM    283  C   GLY A  34      19.859  92.064  -7.845  1.00 33.76           C  
ATOM    284  O   GLY A  34      20.871  92.720  -7.587  1.00 33.73           O  
ATOM    285  N   ASP A  35      18.731  92.186  -7.148  1.00 34.20           N  
ATOM    286  CA  ASP A  35      18.689  92.928  -5.878  1.00 34.98           C  
ATOM    287  C   ASP A  35      19.531  92.195  -4.853  1.00 34.95           C  
ATOM    288  O   ASP A  35      19.588  90.966  -4.876  1.00 35.37           O  
ATOM    289  CB  ASP A  35      17.260  93.034  -5.341  1.00 35.02           C  
ATOM    290  CG  ASP A  35      16.488  94.220  -5.924  1.00 36.55           C  
ATOM    291  OD1 ASP A  35      17.026  94.936  -6.784  1.00 32.95           O  
ATOM    292  OD2 ASP A  35      15.330  94.434  -5.498  1.00 39.47           O  
ATOM    293  N   THR A  36      20.188  92.936  -3.963  1.00 34.85           N  
ATOM    294  CA  THR A  36      20.894  92.306  -2.867  1.00 34.97           C  
ATOM    295  C   THR A  36      20.049  92.395  -1.604  1.00 34.25           C  
ATOM    296  O   THR A  36      19.551  93.469  -1.250  1.00 32.84           O  
ATOM    297  CB  THR A  36      22.313  92.892  -2.611  1.00 35.64           C  
ATOM    298  OG1 THR A  36      22.216  94.029  -1.745  1.00 39.50           O  
ATOM    299  CG2 THR A  36      23.010  93.289  -3.899  1.00 34.86           C  
ATOM    300  N   LEU A  37      19.863  91.250  -0.944  1.00 33.55           N  
ATOM    301  CA  LEU A  37      19.170  91.193   0.349  1.00 32.49           C  
ATOM    302  C   LEU A  37      19.977  91.875   1.462  1.00 33.04           C  
ATOM    303  O   LEU A  37      19.447  92.654   2.286  1.00 33.84           O  
ATOM    304  CB  LEU A  37      18.911  89.728   0.736  1.00 32.08           C  
ATOM    305  CG  LEU A  37      18.111  89.451   2.004  1.00 30.30           C  
ATOM    306  CD1 LEU A  37      16.727  90.080   1.893  1.00 31.55           C  
ATOM    307  CD2 LEU A  37      17.992  87.953   2.230  1.00 31.90           C  
ATOM    308  N   PHE A  38      21.237  91.497   1.551  1.00 32.09           N  
ATOM    309  CA  PHE A  38      22.172  92.186   2.412  1.00 32.55           C  
ATOM    310  C   PHE A  38      23.565  91.952   1.877  1.00 32.34           C  
ATOM    311  O   PHE A  38      23.777  91.059   1.062  1.00 32.59           O  
ATOM    312  CB  PHE A  38      22.046  91.753   3.902  1.00 32.05           C  
ATOM    313  CG  PHE A  38      22.049  90.242   4.116  1.00 32.19           C  
ATOM    314  CD1 PHE A  38      20.879  89.579   4.485  1.00 32.17           C  
ATOM    315  CD2 PHE A  38      23.215  89.494   3.946  1.00 32.21           C  
ATOM    316  CE1 PHE A  38      20.879  88.193   4.707  1.00 32.28           C  
ATOM    317  CE2 PHE A  38      23.223  88.125   4.150  1.00 30.52           C  
ATOM    318  CZ  PHE A  38      22.051  87.462   4.512  1.00 30.86           C  
ATOM    319  N   HIS A  39      24.511  92.779   2.313  1.00 33.48           N  
ATOM    320  CA  HIS A  39      25.897  92.649   1.888  1.00 33.88           C  
ATOM    321  C   HIS A  39      26.711  92.007   2.980  1.00 34.45           C  
ATOM    322  O   HIS A  39      26.500  92.304   4.147  1.00 35.19           O  
ATOM    323  CB  HIS A  39      26.496  94.027   1.600  1.00 34.24           C  
ATOM    324  CG  HIS A  39      26.023  94.633   0.316  1.00 34.80           C  
ATOM    325  ND1 HIS A  39      24.955  95.502   0.251  1.00 37.15           N  
ATOM    326  CD2 HIS A  39      26.457  94.474  -0.956  1.00 35.89           C  
ATOM    327  CE1 HIS A  39      24.769  95.877  -1.001  1.00 36.38           C  
ATOM    328  NE2 HIS A  39      25.661  95.258  -1.757  1.00 37.27           N  
ATOM    329  N   GLU A  40      27.673  91.168   2.615  1.00 34.68           N  
ATOM    330  CA  GLU A  40      28.617  90.651   3.610  1.00 35.31           C  
ATOM    331  C   GLU A  40      29.266  91.806   4.385  1.00 35.56           C  
ATOM    332  O   GLU A  40      29.681  92.817   3.791  1.00 35.08           O  
ATOM    333  CB  GLU A  40      29.672  89.783   2.926  1.00 35.41           C  
ATOM    334  CG  GLU A  40      30.669  89.132   3.861  1.00 35.64           C  
ATOM    335  CD  GLU A  40      31.791  88.439   3.124  1.00 37.89           C  
ATOM    336  OE1 GLU A  40      31.743  88.312   1.865  1.00 37.44           O  
ATOM    337  OE2 GLU A  40      32.742  88.031   3.810  1.00 38.66           O  
ATOM    338  N   GLY A  41      29.324  91.667   5.708  1.00 35.97           N  
ATOM    339  CA  GLY A  41      29.813  92.739   6.576  1.00 37.05           C  
ATOM    340  C   GLY A  41      28.755  93.678   7.160  1.00 37.67           C  
ATOM    341  O   GLY A  41      29.012  94.333   8.177  1.00 37.61           O  
ATOM    342  N   ASP A  42      27.591  93.758   6.512  1.00 37.71           N  
ATOM    343  CA  ASP A  42      26.448  94.532   7.002  1.00 38.62           C  
ATOM    344  C   ASP A  42      26.041  94.105   8.413  1.00 38.89           C  
ATOM    345  O   ASP A  42      26.090  92.914   8.741  1.00 38.99           O  
ATOM    346  CB  ASP A  42      25.223  94.298   6.109  1.00 39.23           C  
ATOM    347  CG  ASP A  42      25.220  95.144   4.836  1.00 40.28           C  
ATOM    348  OD1 ASP A  42      26.133  95.979   4.633  1.00 37.73           O  
ATOM    349  OD2 ASP A  42      24.257  94.956   4.048  1.00 42.69           O  
ATOM    350  N   PRO A  43      25.622  95.069   9.254  1.00 38.98           N  
ATOM    351  CA  PRO A  43      24.990  94.644  10.509  1.00 38.66           C  
ATOM    352  C   PRO A  43      23.806  93.747  10.186  1.00 38.30           C  
ATOM    353  O   PRO A  43      23.077  94.042   9.239  1.00 38.45           O  
ATOM    354  CB  PRO A  43      24.523  95.967  11.129  1.00 39.17           C  
ATOM    355  CG  PRO A  43      25.523  97.022  10.554  1.00 39.64           C  
ATOM    356  CD  PRO A  43      25.728  96.542   9.134  1.00 39.10           C  
ATOM    357  N   GLY A  44      23.649  92.639  10.911  1.00 37.44           N  
ATOM    358  CA  GLY A  44      22.533  91.710  10.670  1.00 38.27           C  
ATOM    359  C   GLY A  44      21.812  91.343  11.951  1.00 38.38           C  
ATOM    360  O   GLY A  44      22.443  90.996  12.949  1.00 38.96           O  
ATOM    361  N   ASP A  45      20.496  91.480  11.955  1.00 39.09           N  
ATOM    362  CA  ASP A  45      19.714  91.197  13.174  1.00 40.15           C  
ATOM    363  C   ASP A  45      18.336  90.671  12.811  1.00 39.64           C  
ATOM    364  O   ASP A  45      17.400  90.774  13.608  1.00 39.62           O  
ATOM    365  CB  ASP A  45      19.636  92.437  14.115  1.00 40.88           C  
ATOM    366  CG  ASP A  45      18.610  93.499  13.655  1.00 44.32           C  
ATOM    367  OD1 ASP A  45      18.429  93.697  12.431  1.00 47.22           O  
ATOM    368  OD2 ASP A  45      17.972  94.143  14.538  1.00 47.37           O  
ATOM    369  N   ARG A  46      18.233  90.105  11.604  1.00 39.07           N  
ATOM    370  CA  ARG A  46      16.980  89.581  11.067  1.00 39.20           C  
ATOM    371  C   ARG A  46      17.181  88.186  10.545  1.00 37.61           C  
ATOM    372  O   ARG A  46      18.205  87.899   9.937  1.00 37.28           O  
ATOM    373  CB  ARG A  46      16.506  90.402   9.852  1.00 40.49           C  
ATOM    374  CG  ARG A  46      15.908  91.726  10.128  1.00 44.97           C  
ATOM    375  CD  ARG A  46      15.623  92.408   8.803  1.00 50.00           C  
ATOM    376  NE  ARG A  46      14.256  92.930   8.739  1.00 56.75           N  
ATOM    377  CZ  ARG A  46      13.696  93.460   7.644  1.00 58.31           C  
ATOM    378  NH1 ARG A  46      14.380  93.544   6.503  1.00 58.12           N  
ATOM    379  NH2 ARG A  46      12.444  93.896   7.687  1.00 59.52           N  
ATOM    380  N   LEU A  47      16.185  87.367  10.728  1.00 35.37           N  
ATOM    381  CA  LEU A  47      16.008  86.095  10.093  1.00 35.48           C  
ATOM    382  C   LEU A  47      15.027  86.254   8.958  1.00 33.57           C  
ATOM    383  O   LEU A  47      14.168  87.059   9.061  1.00 33.33           O  
ATOM    384  CB  LEU A  47      15.422  85.184  11.138  1.00 35.51           C  
ATOM    385  CG  LEU A  47      14.616  83.945  10.897  1.00 40.16           C  
ATOM    386  CD1 LEU A  47      14.583  83.163  12.143  1.00 37.73           C  
ATOM    387  CD2 LEU A  47      13.276  84.259  10.451  1.00 39.75           C  
ATOM    388  N   TYR A  48      15.183  85.501   7.881  1.00 32.39           N  
ATOM    389  CA  TYR A  48      14.221  85.536   6.776  1.00 32.62           C  
ATOM    390  C   TYR A  48      13.760  84.116   6.492  1.00 32.53           C  
ATOM    391  O   TYR A  48      14.522  83.164   6.671  1.00 33.69           O  
ATOM    392  CB  TYR A  48      14.838  86.110   5.484  1.00 33.24           C  
ATOM    393  CG  TYR A  48      15.414  87.509   5.568  1.00 33.36           C  
ATOM    394  CD1 TYR A  48      14.672  88.624   5.158  1.00 34.56           C  
ATOM    395  CD2 TYR A  48      16.721  87.717   6.031  1.00 33.25           C  
ATOM    396  CE1 TYR A  48      15.216  89.936   5.263  1.00 35.06           C  
ATOM    397  CE2 TYR A  48      17.277  89.011   6.113  1.00 33.97           C  
ATOM    398  CZ  TYR A  48      16.517  90.105   5.744  1.00 35.34           C  
ATOM    399  OH  TYR A  48      17.099  91.366   5.793  1.00 36.67           O  
ATOM    400  N   VAL A  49      12.555  83.951   6.009  1.00 32.66           N  
ATOM    401  CA  VAL A  49      12.103  82.706   5.429  1.00 32.78           C  
ATOM    402  C   VAL A  49      11.750  83.061   4.016  1.00 33.11           C  
ATOM    403  O   VAL A  49      11.011  83.962   3.803  1.00 32.89           O  
ATOM    404  CB  VAL A  49      10.873  82.165   6.167  1.00 32.90           C  
ATOM    405  CG1 VAL A  49      10.292  81.020   5.457  1.00 30.50           C  
ATOM    406  CG2 VAL A  49      11.212  81.783   7.580  1.00 34.26           C  
ATOM    407  N   VAL A  50      12.405  82.437   3.056  1.00 33.61           N  
ATOM    408  CA  VAL A  50      12.076  82.709   1.659  1.00 34.10           C  
ATOM    409  C   VAL A  50      10.702  82.086   1.374  1.00 34.35           C  
ATOM    410  O   VAL A  50      10.493  80.897   1.648  1.00 35.23           O  
ATOM    411  CB  VAL A  50      13.142  82.104   0.672  1.00 33.80           C  
ATOM    412  CG1 VAL A  50      12.672  82.207  -0.772  1.00 34.87           C  
ATOM    413  CG2 VAL A  50      14.462  82.799   0.826  1.00 33.20           C  
ATOM    414  N   THR A  51       9.782  82.853   0.792  1.00 34.31           N  
ATOM    415  CA  THR A  51       8.481  82.276   0.427  1.00 34.86           C  
ATOM    416  C   THR A  51       8.302  82.040  -1.092  1.00 35.95           C  
ATOM    417  O   THR A  51       7.440  81.256  -1.512  1.00 35.53           O  
ATOM    418  CB  THR A  51       7.306  83.077   1.023  1.00 34.51           C  
ATOM    419  OG1 THR A  51       7.250  84.366   0.414  1.00 35.73           O  
ATOM    420  CG2 THR A  51       7.502  83.270   2.540  1.00 31.76           C  
ATOM    421  N   GLU A  52       9.110  82.712  -1.901  1.00 36.69           N  
ATOM    422  CA  GLU A  52       9.187  82.419  -3.343  1.00 38.66           C  
ATOM    423  C   GLU A  52      10.458  83.003  -3.935  1.00 38.23           C  
ATOM    424  O   GLU A  52      10.984  84.009  -3.437  1.00 38.08           O  
ATOM    425  CB  GLU A  52       7.958  82.923  -4.115  1.00 38.94           C  
ATOM    426  CG  GLU A  52       7.670  84.415  -4.025  1.00 40.03           C  
ATOM    427  CD  GLU A  52       6.357  84.799  -4.723  1.00 41.79           C  
ATOM    428  OE1 GLU A  52       5.264  84.404  -4.240  1.00 45.10           O  
ATOM    429  OE2 GLU A  52       6.416  85.509  -5.751  1.00 44.44           O  
ATOM    430  N   GLY A  53      10.942  82.353  -4.987  1.00 37.73           N  
ATOM    431  CA  GLY A  53      12.165  82.758  -5.662  1.00 36.90           C  
ATOM    432  C   GLY A  53      13.381  82.112  -5.030  1.00 36.48           C  
ATOM    433  O   GLY A  53      13.265  81.300  -4.111  1.00 36.36           O  
ATOM    434  N   LYS A  54      14.553  82.487  -5.534  1.00 36.02           N  
ATOM    435  CA  LYS A  54      15.822  81.949  -5.073  1.00 35.62           C  
ATOM    436  C   LYS A  54      16.785  83.075  -4.726  1.00 34.78           C  
ATOM    437  O   LYS A  54      16.917  84.044  -5.483  1.00 34.07           O  
ATOM    438  CB  LYS A  54      16.434  81.074  -6.174  1.00 35.24           C  
ATOM    439  CG  LYS A  54      15.551  79.885  -6.540  1.00 35.96           C  
ATOM    440  CD  LYS A  54      16.108  79.062  -7.702  1.00 37.02           C  
ATOM    441  CE  LYS A  54      15.260  77.814  -7.889  1.00 40.58           C  
ATOM    442  NZ  LYS A  54      14.678  77.373  -6.570  1.00 42.38           N  
ATOM    443  N   VAL A  55      17.451  82.921  -3.583  1.00 34.16           N  
ATOM    444  CA  VAL A  55      18.512  83.802  -3.134  1.00 33.88           C  
ATOM    445  C   VAL A  55      19.839  83.024  -3.100  1.00 33.93           C  
ATOM    446  O   VAL A  55      19.960  82.018  -2.400  1.00 34.04           O  
ATOM    447  CB  VAL A  55      18.221  84.360  -1.715  1.00 33.29           C  
ATOM    448  CG1 VAL A  55      19.345  85.238  -1.249  1.00 34.31           C  
ATOM    449  CG2 VAL A  55      16.912  85.141  -1.706  1.00 34.74           C  
ATOM    450  N   LYS A  56      20.831  83.497  -3.855  1.00 33.41           N  
ATOM    451  CA  LYS A  56      22.176  82.933  -3.790  1.00 33.44           C  
ATOM    452  C   LYS A  56      22.973  83.630  -2.686  1.00 33.28           C  
ATOM    453  O   LYS A  56      23.059  84.852  -2.668  1.00 32.77           O  
ATOM    454  CB  LYS A  56      22.901  83.108  -5.132  1.00 33.47           C  
ATOM    455  CG  LYS A  56      24.345  82.657  -5.125  1.00 34.43           C  
ATOM    456  CD  LYS A  56      25.097  83.323  -6.261  1.00 39.74           C  
ATOM    457  CE  LYS A  56      26.584  83.313  -5.998  1.00 41.38           C  
ATOM    458  NZ  LYS A  56      27.322  82.243  -6.716  1.00 43.46           N  
ATOM    459  N   LEU A  57      23.536  82.854  -1.769  1.00 32.90           N  
ATOM    460  CA  LEU A  57      24.438  83.402  -0.764  1.00 34.23           C  
ATOM    461  C   LEU A  57      25.886  83.237  -1.242  1.00 34.26           C  
ATOM    462  O   LEU A  57      26.238  82.179  -1.767  1.00 33.50           O  
ATOM    463  CB  LEU A  57      24.216  82.731   0.598  1.00 33.91           C  
ATOM    464  CG  LEU A  57      22.900  83.004   1.342  1.00 35.54           C  
ATOM    465  CD1 LEU A  57      22.773  82.090   2.535  1.00 33.57           C  
ATOM    466  CD2 LEU A  57      22.835  84.447   1.792  1.00 36.20           C  
ATOM    467  N   HIS A  58      26.694  84.300  -1.127  1.00 34.98           N  
ATOM    468  CA  HIS A  58      28.110  84.267  -1.567  1.00 35.97           C  
ATOM    469  C   HIS A  58      29.050  85.140  -0.708  1.00 37.28           C  
ATOM    470  O   HIS A  58      28.618  86.095  -0.053  1.00 36.83           O  
ATOM    471  CB  HIS A  58      28.257  84.599  -3.063  1.00 35.08           C  
ATOM    472  CG  HIS A  58      27.558  85.855  -3.475  1.00 36.10           C  
ATOM    473  ND1 HIS A  58      28.198  87.074  -3.557  1.00 34.94           N  
ATOM    474  CD2 HIS A  58      26.263  86.090  -3.795  1.00 36.59           C  
ATOM    475  CE1 HIS A  58      27.335  88.000  -3.927  1.00 35.27           C  
ATOM    476  NE2 HIS A  58      26.149  87.433  -4.064  1.00 36.62           N  
ATOM    477  N   ARG A  59      30.344  84.811  -0.757  1.00 38.88           N  
ATOM    478  CA  ARG A  59      31.364  85.389   0.114  1.00 41.04           C  
ATOM    479  C   ARG A  59      32.607  85.736  -0.721  1.00 41.63           C  
ATOM    480  O   ARG A  59      32.940  85.026  -1.680  1.00 41.54           O  
ATOM    481  CB  ARG A  59      31.690  84.384   1.227  1.00 41.18           C  
ATOM    482  CG  ARG A  59      32.658  84.857   2.309  1.00 42.83           C  
ATOM    483  CD  ARG A  59      32.688  83.871   3.488  1.00 42.32           C  
ATOM    484  NE  ARG A  59      31.373  83.719   4.114  1.00 43.91           N  
ATOM    485  CZ  ARG A  59      30.931  82.609   4.706  1.00 43.31           C  
ATOM    486  NH1 ARG A  59      31.693  81.526   4.759  1.00 44.75           N  
ATOM    487  NH2 ARG A  59      29.712  82.580   5.231  1.00 43.91           N  
ATOM    488  N   THR A  60      33.276  86.836  -0.375  1.00 42.38           N  
ATOM    489  CA  THR A  60      34.376  87.337  -1.184  1.00 43.39           C  
ATOM    490  C   THR A  60      35.649  86.539  -0.931  1.00 44.12           C  
ATOM    491  O   THR A  60      36.118  86.451   0.205  1.00 43.98           O  
ATOM    492  CB  THR A  60      34.635  88.837  -0.942  1.00 43.74           C  
ATOM    493  OG1 THR A  60      33.400  89.557  -1.036  1.00 43.07           O  
ATOM    494  CG2 THR A  60      35.638  89.395  -1.972  1.00 42.99           C  
ATOM    495  N   SER A  61      36.198  85.971  -2.006  1.00 45.01           N  
ATOM    496  CA  SER A  61      37.408  85.148  -1.950  1.00 45.92           C  
ATOM    497  C   SER A  61      38.653  85.969  -1.614  1.00 46.32           C  
ATOM    498  O   SER A  61      38.704  87.163  -1.933  1.00 46.47           O  
ATOM    499  CB  SER A  61      37.615  84.431  -3.289  1.00 45.77           C  
ATOM    500  OG  SER A  61      36.593  83.474  -3.504  1.00 47.93           O  
ATOM    501  N   PRO A  62      39.660  85.333  -0.967  1.00 46.79           N  
ATOM    502  CA  PRO A  62      41.006  85.906  -0.808  1.00 46.96           C  
ATOM    503  C   PRO A  62      41.596  86.477  -2.099  1.00 47.32           C  
ATOM    504  O   PRO A  62      42.610  87.174  -2.056  1.00 47.42           O  
ATOM    505  CB  PRO A  62      41.832  84.708  -0.337  1.00 46.75           C  
ATOM    506  CG  PRO A  62      40.856  83.902   0.454  1.00 47.13           C  
ATOM    507  CD  PRO A  62      39.549  84.025  -0.287  1.00 46.71           C  
ATOM    508  N   ASP A  63      40.956  86.187  -3.229  1.00 47.75           N  
ATOM    509  CA  ASP A  63      41.413  86.648  -4.537  1.00 48.22           C  
ATOM    510  C   ASP A  63      40.465  87.671  -5.185  1.00 48.19           C  
ATOM    511  O   ASP A  63      40.674  88.084  -6.329  1.00 48.22           O  
ATOM    512  CB  ASP A  63      41.674  85.452  -5.471  1.00 48.50           C  
ATOM    513  CG  ASP A  63      40.719  84.286  -5.221  1.00 49.51           C  
ATOM    514  OD1 ASP A  63      39.899  83.985  -6.121  1.00 50.00           O  
ATOM    515  OD2 ASP A  63      40.789  83.680  -4.120  1.00 49.61           O  
ATOM    516  N   GLY A  64      39.428  88.079  -4.454  1.00 48.25           N  
ATOM    517  CA  GLY A  64      38.553  89.166  -4.900  1.00 48.06           C  
ATOM    518  C   GLY A  64      37.244  88.769  -5.564  1.00 48.02           C  
ATOM    519  O   GLY A  64      36.372  89.620  -5.782  1.00 47.94           O  
ATOM    520  N   ARG A  65      37.097  87.486  -5.886  1.00 47.79           N  
ATOM    521  CA  ARG A  65      35.871  86.987  -6.504  1.00 47.72           C  
ATOM    522  C   ARG A  65      34.828  86.581  -5.450  1.00 47.29           C  
ATOM    523  O   ARG A  65      35.144  86.465  -4.262  1.00 47.09           O  
ATOM    524  CB  ARG A  65      36.179  85.817  -7.453  1.00 48.06           C  
ATOM    525  CG  ARG A  65      36.025  84.410  -6.848  1.00 49.07           C  
ATOM    526  CD  ARG A  65      35.234  83.512  -7.811  1.00 49.99           C  
ATOM    527  NE  ARG A  65      34.510  82.418  -7.150  1.00 49.87           N  
ATOM    528  CZ  ARG A  65      34.883  81.139  -7.183  1.00 50.16           C  
ATOM    529  NH1 ARG A  65      34.151  80.219  -6.568  1.00 49.47           N  
ATOM    530  NH2 ARG A  65      35.983  80.771  -7.842  1.00 50.10           N  
ATOM    531  N   GLU A  66      33.587  86.369  -5.890  1.00 46.88           N  
ATOM    532  CA  GLU A  66      32.536  85.864  -5.007  1.00 46.35           C  
ATOM    533  C   GLU A  66      32.436  84.351  -5.143  1.00 46.54           C  
ATOM    534  O   GLU A  66      32.225  83.832  -6.248  1.00 46.87           O  
ATOM    535  CB  GLU A  66      31.187  86.512  -5.335  1.00 45.93           C  
ATOM    536  CG  GLU A  66      31.159  88.015  -5.145  1.00 43.96           C  
ATOM    537  CD  GLU A  66      31.413  88.414  -3.704  1.00 42.06           C  
ATOM    538  OE1 GLU A  66      32.363  89.193  -3.465  1.00 39.57           O  
ATOM    539  OE2 GLU A  66      30.677  87.926  -2.814  1.00 39.47           O  
ATOM    540  N   ASN A  67      32.609  83.646  -4.030  1.00 46.17           N  
ATOM    541  CA  ASN A  67      32.391  82.204  -4.003  1.00 46.23           C  
ATOM    542  C   ASN A  67      30.955  81.895  -3.609  1.00 46.35           C  
ATOM    543  O   ASN A  67      30.458  82.429  -2.625  1.00 45.19           O  
ATOM    544  CB  ASN A  67      33.345  81.521  -3.020  1.00 46.43           C  
ATOM    545  CG  ASN A  67      33.353  80.001  -3.160  1.00 46.78           C  
ATOM    546  OD1 ASN A  67      33.639  79.459  -4.230  1.00 47.49           O  
ATOM    547  ND2 ASN A  67      33.066  79.309  -2.066  1.00 47.08           N  
HETATM  548  N   MSE A  68      30.315  81.020  -4.381  1.00 46.53           N  
HETATM  549  CA  MSE A  68      28.976  80.522  -4.093  1.00 47.44           C  
HETATM  550  C   MSE A  68      28.952  79.747  -2.770  1.00 46.80           C  
HETATM  551  O   MSE A  68      29.788  78.887  -2.522  1.00 46.60           O  
HETATM  552  CB  MSE A  68      28.490  79.648  -5.263  1.00 48.53           C  
HETATM  553  CG  MSE A  68      26.999  79.285  -5.256  1.00 51.15           C  
HETATM  554 SE   MSE A  68      26.636  77.944  -3.901  0.85 59.55          SE  
HETATM  555  CE  MSE A  68      25.052  77.088  -4.599  1.00 53.97           C  
ATOM    556  N   LEU A  69      27.969  80.054  -1.931  1.00 46.17           N  
ATOM    557  CA  LEU A  69      27.851  79.442  -0.611  1.00 45.60           C  
ATOM    558  C   LEU A  69      26.600  78.566  -0.465  1.00 44.89           C  
ATOM    559  O   LEU A  69      26.656  77.481   0.118  1.00 44.88           O  
ATOM    560  CB  LEU A  69      27.849  80.549   0.437  1.00 46.03           C  
ATOM    561  CG  LEU A  69      28.453  80.281   1.801  1.00 47.33           C  
ATOM    562  CD1 LEU A  69      29.305  81.478   2.138  1.00 48.88           C  
ATOM    563  CD2 LEU A  69      27.360  80.058   2.837  1.00 49.15           C  
ATOM    564  N   ALA A  70      25.473  79.051  -0.991  1.00 43.91           N  
ATOM    565  CA  ALA A  70      24.197  78.330  -0.976  1.00 42.69           C  
ATOM    566  C   ALA A  70      23.222  78.962  -1.963  1.00 42.02           C  
ATOM    567  O   ALA A  70      23.399  80.113  -2.368  1.00 41.93           O  
ATOM    568  CB  ALA A  70      23.596  78.329   0.439  1.00 42.39           C  
ATOM    569  N   VAL A  71      22.205  78.206  -2.361  1.00 41.43           N  
ATOM    570  CA  VAL A  71      21.047  78.771  -3.065  1.00 41.15           C  
ATOM    571  C   VAL A  71      19.807  78.449  -2.235  1.00 40.91           C  
ATOM    572  O   VAL A  71      19.471  77.280  -2.018  1.00 41.19           O  
ATOM    573  CB  VAL A  71      20.887  78.255  -4.522  1.00 41.42           C  
ATOM    574  CG1 VAL A  71      19.570  78.750  -5.126  1.00 41.25           C  
ATOM    575  CG2 VAL A  71      22.051  78.706  -5.391  1.00 41.65           C  
ATOM    576  N   VAL A  72      19.134  79.490  -1.766  1.00 39.87           N  
ATOM    577  CA  VAL A  72      18.053  79.328  -0.809  1.00 39.51           C  
ATOM    578  C   VAL A  72      16.719  79.579  -1.485  1.00 39.65           C  
ATOM    579  O   VAL A  72      16.513  80.633  -2.086  1.00 40.24           O  
ATOM    580  CB  VAL A  72      18.231  80.280   0.407  1.00 39.05           C  
ATOM    581  CG1 VAL A  72      17.088  80.104   1.415  1.00 38.92           C  
ATOM    582  CG2 VAL A  72      19.587  80.077   1.074  1.00 38.46           C  
ATOM    583  N   GLY A  73      15.811  78.607  -1.391  1.00 39.85           N  
ATOM    584  CA  GLY A  73      14.497  78.726  -2.015  1.00 39.10           C  
ATOM    585  C   GLY A  73      13.334  78.660  -1.042  1.00 38.76           C  
ATOM    586  O   GLY A  73      13.528  78.747   0.172  1.00 38.81           O  
ATOM    587  N   PRO A  74      12.112  78.466  -1.567  1.00 38.90           N  
ATOM    588  CA  PRO A  74      10.921  78.574  -0.726  1.00 39.22           C  
ATOM    589  C   PRO A  74      10.990  77.686   0.525  1.00 39.21           C  
ATOM    590  O   PRO A  74      11.385  76.522   0.439  1.00 39.13           O  
ATOM    591  CB  PRO A  74       9.789  78.154  -1.666  1.00 38.98           C  
ATOM    592  CG  PRO A  74      10.314  78.465  -3.036  1.00 38.55           C  
ATOM    593  CD  PRO A  74      11.763  78.096  -2.953  1.00 39.31           C  
ATOM    594  N   SER A  75      10.652  78.281   1.669  1.00 38.79           N  
ATOM    595  CA  SER A  75      10.564  77.610   2.980  1.00 38.50           C  
ATOM    596  C   SER A  75      11.896  77.456   3.712  1.00 38.00           C  
ATOM    597  O   SER A  75      11.932  76.885   4.794  1.00 37.98           O  
ATOM    598  CB  SER A  75       9.830  76.251   2.873  1.00 39.25           C  
ATOM    599  OG  SER A  75      10.759  75.180   2.816  1.00 39.64           O  
ATOM    600  N   GLU A  76      12.986  77.958   3.127  1.00 36.87           N  
ATOM    601  CA  GLU A  76      14.302  77.865   3.754  1.00 37.11           C  
ATOM    602  C   GLU A  76      14.709  79.188   4.417  1.00 36.44           C  
ATOM    603  O   GLU A  76      14.284  80.269   3.994  1.00 34.77           O  
ATOM    604  CB  GLU A  76      15.359  77.454   2.735  1.00 37.61           C  
ATOM    605  CG  GLU A  76      15.164  76.037   2.166  1.00 38.10           C  
ATOM    606  CD  GLU A  76      16.085  75.737   1.009  1.00 39.44           C  
ATOM    607  OE1 GLU A  76      15.566  75.480  -0.098  1.00 45.44           O  
ATOM    608  OE2 GLU A  76      17.321  75.728   1.197  1.00 42.28           O  
ATOM    609  N   LEU A  77      15.562  79.089   5.437  1.00 36.69           N  
ATOM    610  CA  LEU A  77      15.909  80.231   6.257  1.00 37.40           C  
ATOM    611  C   LEU A  77      17.222  80.894   5.849  1.00 36.61           C  
ATOM    612  O   LEU A  77      18.143  80.232   5.378  1.00 36.00           O  
ATOM    613  CB  LEU A  77      15.978  79.812   7.730  1.00 37.53           C  
ATOM    614  CG  LEU A  77      14.675  79.768   8.536  1.00 39.44           C  
ATOM    615  CD1 LEU A  77      13.553  79.082   7.775  1.00 41.50           C  
ATOM    616  CD2 LEU A  77      14.950  79.057   9.856  1.00 39.12           C  
ATOM    617  N   ILE A  78      17.289  82.204   6.068  1.00 35.25           N  
ATOM    618  CA  ILE A  78      18.513  82.984   5.897  1.00 34.75           C  
ATOM    619  C   ILE A  78      18.711  83.754   7.186  1.00 34.37           C  
ATOM    620  O   ILE A  78      17.740  84.351   7.717  1.00 34.06           O  
ATOM    621  CB  ILE A  78      18.412  83.949   4.662  1.00 34.76           C  
ATOM    622  CG1 ILE A  78      17.978  83.181   3.396  1.00 35.80           C  
ATOM    623  CG2 ILE A  78      19.728  84.668   4.415  1.00 34.14           C  
ATOM    624  CD1 ILE A  78      17.768  84.068   2.119  1.00 35.16           C  
ATOM    625  N   GLY A  79      19.932  83.702   7.728  1.00 33.85           N  
ATOM    626  CA  GLY A  79      20.326  84.518   8.891  1.00 34.13           C  
ATOM    627  C   GLY A  79      19.643  84.142  10.200  1.00 34.43           C  
ATOM    628  O   GLY A  79      19.433  84.984  11.070  1.00 34.79           O  
ATOM    629  N   GLU A  80      19.333  82.860  10.345  1.00 35.28           N  
ATOM    630  CA  GLU A  80      18.573  82.323  11.485  1.00 36.02           C  
ATOM    631  C   GLU A  80      19.054  82.815  12.846  1.00 36.43           C  
ATOM    632  O   GLU A  80      18.263  83.359  13.616  1.00 35.66           O  
ATOM    633  CB  GLU A  80      18.621  80.792  11.478  1.00 35.88           C  
ATOM    634  CG  GLU A  80      17.799  80.191  12.595  1.00 38.08           C  
ATOM    635  CD  GLU A  80      18.135  78.747  12.894  1.00 41.19           C  
ATOM    636  OE1 GLU A  80      18.679  78.024  12.012  1.00 41.20           O  
ATOM    637  OE2 GLU A  80      17.813  78.349  14.031  1.00 42.58           O  
ATOM    638  N   LEU A  81      20.340  82.599  13.149  1.00 36.32           N  
ATOM    639  CA  LEU A  81      20.827  82.888  14.505  1.00 37.76           C  
ATOM    640  C   LEU A  81      20.979  84.397  14.772  1.00 37.40           C  
ATOM    641  O   LEU A  81      21.043  84.830  15.923  1.00 37.62           O  
ATOM    642  CB  LEU A  81      22.118  82.104  14.819  1.00 38.22           C  
ATOM    643  CG  LEU A  81      21.935  80.572  14.858  1.00 39.27           C  
ATOM    644  CD1 LEU A  81      23.202  79.851  15.246  1.00 40.59           C  
ATOM    645  CD2 LEU A  81      20.813  80.187  15.803  1.00 42.59           C  
ATOM    646  N   SER A  82      20.979  85.189  13.706  1.00 37.36           N  
ATOM    647  CA  SER A  82      21.039  86.643  13.825  1.00 37.92           C  
ATOM    648  C   SER A  82      19.799  87.230  14.487  1.00 37.88           C  
ATOM    649  O   SER A  82      19.857  88.305  15.041  1.00 38.22           O  
ATOM    650  CB  SER A  82      21.323  87.296  12.461  1.00 38.50           C  
ATOM    651  OG  SER A  82      20.136  87.452  11.727  1.00 40.59           O  
ATOM    652  N   LEU A  83      18.683  86.502  14.467  1.00 37.33           N  
ATOM    653  CA  LEU A  83      17.526  86.854  15.277  1.00 37.34           C  
ATOM    654  C   LEU A  83      17.883  86.917  16.789  1.00 37.14           C  
ATOM    655  O   LEU A  83      17.400  87.770  17.508  1.00 36.31           O  
ATOM    656  CB  LEU A  83      16.406  85.829  15.017  1.00 37.69           C  
ATOM    657  CG  LEU A  83      15.129  85.844  15.861  1.00 38.60           C  
ATOM    658  CD1 LEU A  83      14.313  87.137  15.715  1.00 35.83           C  
ATOM    659  CD2 LEU A  83      14.275  84.624  15.534  1.00 37.75           C  
ATOM    660  N   PHE A  84      18.737  86.009  17.252  1.00 36.70           N  
ATOM    661  CA  PHE A  84      19.054  85.911  18.661  1.00 37.20           C  
ATOM    662  C   PHE A  84      20.375  86.578  19.008  1.00 37.67           C  
ATOM    663  O   PHE A  84      20.541  87.094  20.105  1.00 37.93           O  
ATOM    664  CB  PHE A  84      19.101  84.444  19.066  1.00 37.28           C  
ATOM    665  CG  PHE A  84      17.820  83.696  18.770  1.00 37.60           C  
ATOM    666  CD1 PHE A  84      16.634  84.048  19.409  1.00 36.11           C  
ATOM    667  CD2 PHE A  84      17.807  82.659  17.847  1.00 37.07           C  
ATOM    668  CE1 PHE A  84      15.424  83.366  19.147  1.00 37.83           C  
ATOM    669  CE2 PHE A  84      16.608  81.966  17.570  1.00 38.39           C  
ATOM    670  CZ  PHE A  84      15.409  82.328  18.234  1.00 36.99           C  
ATOM    671  N   ASP A  85      21.310  86.550  18.065  1.00 37.67           N  
ATOM    672  CA  ASP A  85      22.643  87.047  18.288  1.00 37.93           C  
ATOM    673  C   ASP A  85      23.043  87.920  17.091  1.00 37.71           C  
ATOM    674  O   ASP A  85      23.816  87.477  16.249  1.00 37.51           O  
ATOM    675  CB  ASP A  85      23.600  85.861  18.476  1.00 37.74           C  
ATOM    676  CG  ASP A  85      25.008  86.287  18.878  1.00 39.69           C  
ATOM    677  OD1 ASP A  85      25.169  87.317  19.571  1.00 41.16           O  
ATOM    678  OD2 ASP A  85      25.964  85.577  18.496  1.00 42.21           O  
ATOM    679  N   PRO A  86      22.502  89.157  17.008  1.00 37.60           N  
ATOM    680  CA  PRO A  86      22.863  90.101  15.951  1.00 37.29           C  
ATOM    681  C   PRO A  86      24.379  90.251  15.806  1.00 37.24           C  
ATOM    682  O   PRO A  86      25.098  90.275  16.798  1.00 36.64           O  
ATOM    683  CB  PRO A  86      22.260  91.420  16.450  1.00 37.46           C  
ATOM    684  CG  PRO A  86      21.048  90.980  17.230  1.00 38.03           C  
ATOM    685  CD  PRO A  86      21.499  89.735  17.934  1.00 37.80           C  
ATOM    686  N   GLY A  87      24.858  90.335  14.570  1.00 37.10           N  
ATOM    687  CA  GLY A  87      26.284  90.471  14.305  1.00 35.83           C  
ATOM    688  C   GLY A  87      26.478  90.633  12.809  1.00 36.15           C  
ATOM    689  O   GLY A  87      25.529  90.516  12.057  1.00 36.17           O  
ATOM    690  N   PRO A  88      27.703  90.942  12.365  1.00 36.37           N  
ATOM    691  CA  PRO A  88      27.833  91.245  10.932  1.00 36.04           C  
ATOM    692  C   PRO A  88      27.520  90.046  10.022  1.00 35.77           C  
ATOM    693  O   PRO A  88      27.840  88.906  10.370  1.00 35.56           O  
ATOM    694  CB  PRO A  88      29.286  91.721  10.785  1.00 35.82           C  
ATOM    695  CG  PRO A  88      30.003  91.279  12.010  1.00 36.97           C  
ATOM    696  CD  PRO A  88      28.972  91.065  13.108  1.00 36.02           C  
ATOM    697  N   ARG A  89      26.877  90.305   8.884  1.00 35.08           N  
ATOM    698  CA  ARG A  89      26.636  89.251   7.886  1.00 35.45           C  
ATOM    699  C   ARG A  89      27.944  88.642   7.372  1.00 35.83           C  
ATOM    700  O   ARG A  89      28.929  89.357   7.115  1.00 35.99           O  
ATOM    701  CB  ARG A  89      25.809  89.766   6.710  1.00 35.20           C  
ATOM    702  CG  ARG A  89      24.465  90.315   7.088  1.00 35.39           C  
ATOM    703  CD  ARG A  89      23.546  89.235   7.646  1.00 35.13           C  
ATOM    704  NE  ARG A  89      22.173  89.736   7.760  1.00 34.13           N  
ATOM    705  CZ  ARG A  89      21.194  89.109   8.411  1.00 34.78           C  
ATOM    706  NH1 ARG A  89      21.423  87.961   9.029  1.00 34.76           N  
ATOM    707  NH2 ARG A  89      19.989  89.654   8.460  1.00 35.82           N  
ATOM    708  N   THR A  90      27.940  87.326   7.235  1.00 35.84           N  
ATOM    709  CA  THR A  90      29.121  86.574   6.796  1.00 37.19           C  
ATOM    710  C   THR A  90      29.028  86.288   5.292  1.00 36.28           C  
ATOM    711  O   THR A  90      29.985  85.815   4.684  1.00 36.34           O  
ATOM    712  CB  THR A  90      29.247  85.243   7.570  1.00 37.38           C  
ATOM    713  OG1 THR A  90      28.008  84.537   7.486  1.00 39.22           O  
ATOM    714  CG2 THR A  90      29.553  85.485   9.035  1.00 39.42           C  
ATOM    715  N   ALA A  91      27.882  86.610   4.701  1.00 35.42           N  
ATOM    716  CA  ALA A  91      27.676  86.459   3.264  1.00 34.99           C  
ATOM    717  C   ALA A  91      26.831  87.581   2.634  1.00 34.68           C  
ATOM    718  O   ALA A  91      26.122  88.309   3.333  1.00 34.95           O  
ATOM    719  CB  ALA A  91      27.044  85.102   2.971  1.00 35.04           C  
ATOM    720  N   THR A  92      26.929  87.715   1.305  1.00 33.94           N  
ATOM    721  CA  THR A  92      26.021  88.553   0.528  1.00 33.08           C  
ATOM    722  C   THR A  92      24.906  87.671  -0.042  1.00 32.92           C  
ATOM    723  O   THR A  92      25.158  86.569  -0.493  1.00 32.88           O  
ATOM    724  CB  THR A  92      26.777  89.286  -0.610  1.00 33.06           C  
ATOM    725  OG1 THR A  92      27.745  90.160  -0.022  1.00 31.73           O  
ATOM    726  CG2 THR A  92      25.817  90.119  -1.471  1.00 31.98           C  
ATOM    727  N   GLY A  93      23.671  88.154   0.027  1.00 32.13           N  
ATOM    728  CA  GLY A  93      22.543  87.436  -0.510  1.00 31.20           C  
ATOM    729  C   GLY A  93      22.063  88.217  -1.702  1.00 31.23           C  
ATOM    730  O   GLY A  93      21.757  89.396  -1.586  1.00 30.49           O  
ATOM    731  N   THR A  94      22.042  87.554  -2.852  1.00 30.50           N  
ATOM    732  CA  THR A  94      21.651  88.167  -4.111  1.00 31.38           C  
ATOM    733  C   THR A  94      20.455  87.418  -4.720  1.00 30.26           C  
ATOM    734  O   THR A  94      20.473  86.210  -4.850  1.00 29.61           O  
ATOM    735  CB  THR A  94      22.844  88.201  -5.071  1.00 30.99           C  
ATOM    736  OG1 THR A  94      23.887  88.975  -4.467  1.00 33.83           O  
ATOM    737  CG2 THR A  94      22.475  88.818  -6.421  1.00 31.92           C  
ATOM    738  N   ALA A  95      19.411  88.160  -5.050  1.00 30.48           N  
ATOM    739  CA  ALA A  95      18.210  87.595  -5.633  1.00 31.29           C  
ATOM    740  C   ALA A  95      18.545  87.086  -7.038  1.00 31.66           C  
ATOM    741  O   ALA A  95      19.084  87.823  -7.875  1.00 32.09           O  
ATOM    742  CB  ALA A  95      17.092  88.649  -5.691  1.00 30.96           C  
ATOM    743  N   LEU A  96      18.257  85.821  -7.293  1.00 32.45           N  
ATOM    744  CA  LEU A  96      18.446  85.271  -8.645  1.00 33.62           C  
ATOM    745  C   LEU A  96      17.203  85.409  -9.491  1.00 34.35           C  
ATOM    746  O   LEU A  96      17.248  85.261 -10.735  1.00 34.47           O  
ATOM    747  CB  LEU A  96      18.827  83.800  -8.577  1.00 33.75           C  
ATOM    748  CG  LEU A  96      20.151  83.550  -7.891  1.00 34.37           C  
ATOM    749  CD1 LEU A  96      20.248  82.061  -7.512  1.00 36.71           C  
ATOM    750  CD2 LEU A  96      21.310  84.006  -8.793  1.00 35.06           C  
ATOM    751  N   THR A  97      16.088  85.667  -8.813  1.00 35.15           N  
ATOM    752  CA  THR A  97      14.782  85.792  -9.452  1.00 35.83           C  
ATOM    753  C   THR A  97      14.018  86.879  -8.706  1.00 36.40           C  
ATOM    754  O   THR A  97      14.570  87.555  -7.830  1.00 37.17           O  
ATOM    755  CB  THR A  97      13.967  84.478  -9.319  1.00 35.89           C  
ATOM    756  OG1 THR A  97      13.817  84.164  -7.931  1.00 35.03           O  
ATOM    757  CG2 THR A  97      14.665  83.320  -9.990  1.00 35.16           C  
ATOM    758  N   GLU A  98      12.752  87.063  -9.065  1.00 36.70           N  
ATOM    759  CA  GLU A  98      11.813  87.740  -8.191  1.00 37.04           C  
ATOM    760  C   GLU A  98      11.774  86.928  -6.900  1.00 36.54           C  
ATOM    761  O   GLU A  98      11.587  85.714  -6.933  1.00 36.19           O  
ATOM    762  CB  GLU A  98      10.418  87.777  -8.813  1.00 37.47           C  
ATOM    763  CG  GLU A  98       9.408  88.547  -7.971  1.00 39.95           C  
ATOM    764  CD  GLU A  98       8.132  87.774  -7.730  1.00 44.26           C  
ATOM    765  OE1 GLU A  98       7.285  87.679  -8.656  1.00 46.21           O  
ATOM    766  OE2 GLU A  98       7.966  87.275  -6.597  1.00 45.52           O  
ATOM    767  N   VAL A  99      11.991  87.591  -5.771  1.00 36.08           N  
ATOM    768  CA  VAL A  99      11.966  86.912  -4.482  1.00 35.80           C  
ATOM    769  C   VAL A  99      11.012  87.619  -3.515  1.00 35.73           C  
ATOM    770  O   VAL A  99      10.941  88.847  -3.481  1.00 35.43           O  
ATOM    771  CB  VAL A  99      13.379  86.846  -3.820  1.00 36.26           C  
ATOM    772  CG1 VAL A  99      13.342  86.044  -2.516  1.00 34.77           C  
ATOM    773  CG2 VAL A  99      14.415  86.229  -4.786  1.00 35.30           C  
ATOM    774  N   LYS A 100      10.289  86.827  -2.736  1.00 35.12           N  
ATOM    775  CA  LYS A 100       9.547  87.339  -1.591  1.00 34.95           C  
ATOM    776  C   LYS A 100      10.011  86.577  -0.362  1.00 34.07           C  
ATOM    777  O   LYS A 100      10.318  85.368  -0.438  1.00 33.74           O  
ATOM    778  CB  LYS A 100       8.042  87.182  -1.793  1.00 34.46           C  
ATOM    779  CG  LYS A 100       7.456  88.130  -2.829  1.00 36.37           C  
ATOM    780  CD  LYS A 100       5.950  87.913  -3.011  1.00 36.16           C  
ATOM    781  CE  LYS A 100       5.429  88.520  -4.310  1.00 40.58           C  
ATOM    782  NZ  LYS A 100       5.596  90.015  -4.369  1.00 42.49           N  
ATOM    783  N   LEU A 101      10.107  87.306   0.750  1.00 33.27           N  
ATOM    784  CA  LEU A 101      10.567  86.766   2.023  1.00 33.30           C  
ATOM    785  C   LEU A 101       9.721  87.329   3.166  1.00 32.83           C  
ATOM    786  O   LEU A 101       9.112  88.394   3.030  1.00 32.77           O  
ATOM    787  CB  LEU A 101      12.034  87.141   2.306  1.00 32.99           C  
ATOM    788  CG  LEU A 101      13.110  87.099   1.213  1.00 33.94           C  
ATOM    789  CD1 LEU A 101      13.339  88.488   0.685  1.00 34.49           C  
ATOM    790  CD2 LEU A 101      14.394  86.560   1.783  1.00 33.68           C  
ATOM    791  N   LEU A 102       9.711  86.614   4.284  1.00 31.80           N  
ATOM    792  CA  LEU A 102       9.153  87.143   5.524  1.00 32.73           C  
ATOM    793  C   LEU A 102      10.321  87.318   6.484  1.00 32.00           C  
ATOM    794  O   LEU A 102      11.129  86.410   6.611  1.00 31.08           O  
ATOM    795  CB  LEU A 102       8.141  86.152   6.092  1.00 32.36           C  
ATOM    796  CG  LEU A 102       6.828  86.129   5.298  1.00 34.65           C  
ATOM    797  CD1 LEU A 102       5.918  84.991   5.785  1.00 34.58           C  
ATOM    798  CD2 LEU A 102       6.123  87.483   5.386  1.00 37.91           C  
ATOM    799  N   ALA A 103      10.414  88.459   7.141  1.00 32.91           N  
ATOM    800  CA  ALA A 103      11.562  88.751   8.006  1.00 33.06           C  
ATOM    801  C   ALA A 103      11.140  88.893   9.457  1.00 33.81           C  
ATOM    802  O   ALA A 103      10.100  89.490   9.748  1.00 33.64           O  
ATOM    803  CB  ALA A 103      12.232  90.038   7.537  1.00 33.73           C  
ATOM    804  N   LEU A 104      11.937  88.366  10.381  1.00 34.74           N  
ATOM    805  CA  LEU A 104      11.706  88.640  11.812  1.00 34.65           C  
ATOM    806  C   LEU A 104      12.984  89.240  12.388  1.00 35.01           C  
ATOM    807  O   LEU A 104      14.045  88.643  12.256  1.00 34.06           O  
ATOM    808  CB  LEU A 104      11.303  87.352  12.559  1.00 35.41           C  
ATOM    809  CG  LEU A 104      10.840  87.478  14.033  1.00 34.84           C  
ATOM    810  CD1 LEU A 104       9.455  88.165  14.180  1.00 34.03           C  
ATOM    811  CD2 LEU A 104      10.862  86.133  14.771  1.00 34.64           C  
ATOM    812  N   GLY A 105      12.884  90.419  13.008  1.00 35.18           N  
ATOM    813  CA  GLY A 105      14.043  91.095  13.587  1.00 34.90           C  
ATOM    814  C   GLY A 105      14.207  90.781  15.065  1.00 36.17           C  
ATOM    815  O   GLY A 105      13.231  90.481  15.772  1.00 34.21           O  
ATOM    816  N   HIS A 106      15.453  90.845  15.532  1.00 36.72           N  
ATOM    817  CA  HIS A 106      15.723  90.779  16.960  1.00 37.60           C  
ATOM    818  C   HIS A 106      14.753  91.647  17.793  1.00 37.20           C  
ATOM    819  O   HIS A 106      14.238  91.192  18.821  1.00 37.32           O  
ATOM    820  CB  HIS A 106      17.180  91.160  17.274  1.00 37.88           C  
ATOM    821  CG  HIS A 106      17.562  90.876  18.684  1.00 37.80           C  
ATOM    822  ND1 HIS A 106      17.687  91.868  19.629  1.00 40.76           N  
ATOM    823  CD2 HIS A 106      17.752  89.704  19.339  1.00 39.78           C  
ATOM    824  CE1 HIS A 106      17.988  91.326  20.797  1.00 40.56           C  
ATOM    825  NE2 HIS A 106      18.030  90.014  20.651  1.00 42.67           N  
ATOM    826  N   GLY A 107      14.498  92.866  17.318  1.00 37.42           N  
ATOM    827  CA  GLY A 107      13.616  93.845  17.968  1.00 37.82           C  
ATOM    828  C   GLY A 107      12.170  93.380  18.135  1.00 38.28           C  
ATOM    829  O   GLY A 107      11.447  93.895  18.991  1.00 38.02           O  
ATOM    830  N   ASP A 108      11.750  92.407  17.328  1.00 38.23           N  
ATOM    831  CA  ASP A 108      10.375  91.896  17.356  1.00 39.23           C  
ATOM    832  C   ASP A 108      10.190  90.730  18.306  1.00 39.05           C  
ATOM    833  O   ASP A 108       9.070  90.221  18.497  1.00 39.16           O  
ATOM    834  CB  ASP A 108       9.977  91.399  15.970  1.00 39.94           C  
ATOM    835  CG  ASP A 108      10.096  92.452  14.924  1.00 42.53           C  
ATOM    836  OD1 ASP A 108       9.755  93.623  15.206  1.00 41.84           O  
ATOM    837  OD2 ASP A 108      10.523  92.089  13.803  1.00 45.19           O  
ATOM    838  N   LEU A 109      11.290  90.268  18.869  1.00 39.11           N  
ATOM    839  CA  LEU A 109      11.265  89.096  19.717  1.00 39.02           C  
ATOM    840  C   LEU A 109      10.641  89.381  21.069  1.00 38.03           C  
ATOM    841  O   LEU A 109       9.779  88.639  21.540  1.00 38.28           O  
ATOM    842  CB  LEU A 109      12.706  88.600  19.894  1.00 39.23           C  
ATOM    843  CG  LEU A 109      13.013  87.143  20.177  1.00 41.91           C  
ATOM    844  CD1 LEU A 109      12.204  86.183  19.277  1.00 40.35           C  
ATOM    845  CD2 LEU A 109      14.562  86.965  20.030  1.00 38.54           C  
ATOM    846  N   GLN A 110      11.106  90.432  21.735  1.00 37.32           N  
ATOM    847  CA  GLN A 110      10.569  90.769  23.047  1.00 36.95           C  
ATOM    848  C   GLN A 110       9.041  90.960  23.089  1.00 35.58           C  
ATOM    849  O   GLN A 110       8.380  90.434  23.998  1.00 35.32           O  
ATOM    850  CB  GLN A 110      11.255  92.021  23.641  1.00 38.39           C  
ATOM    851  CG  GLN A 110      11.206  92.001  25.127  1.00 41.35           C  
ATOM    852  CD  GLN A 110      11.547  90.616  25.655  1.00 44.90           C  
ATOM    853  OE1 GLN A 110      10.691  89.910  26.193  1.00 50.08           O  
ATOM    854  NE2 GLN A 110      12.781  90.207  25.468  1.00 46.45           N  
ATOM    855  N   PRO A 111       8.473  91.728  22.136  1.00 34.52           N  
ATOM    856  CA  PRO A 111       7.013  91.855  22.169  1.00 34.32           C  
ATOM    857  C   PRO A 111       6.323  90.501  21.991  1.00 34.58           C  
ATOM    858  O   PRO A 111       5.279  90.275  22.565  1.00 33.91           O  
ATOM    859  CB  PRO A 111       6.717  92.749  20.968  1.00 34.44           C  
ATOM    860  CG  PRO A 111       7.993  93.543  20.788  1.00 34.95           C  
ATOM    861  CD  PRO A 111       9.050  92.518  21.038  1.00 33.88           C  
ATOM    862  N   TRP A 112       6.885  89.631  21.161  1.00 35.69           N  
ATOM    863  CA  TRP A 112       6.275  88.328  20.965  1.00 36.96           C  
ATOM    864  C   TRP A 112       6.348  87.514  22.249  1.00 37.56           C  
ATOM    865  O   TRP A 112       5.332  87.010  22.715  1.00 37.19           O  
ATOM    866  CB  TRP A 112       6.898  87.615  19.773  1.00 37.67           C  
ATOM    867  CG  TRP A 112       6.331  86.258  19.476  1.00 38.05           C  
ATOM    868  CD1 TRP A 112       5.089  85.741  19.857  1.00 38.87           C  
ATOM    869  CD2 TRP A 112       6.966  85.246  18.708  1.00 37.73           C  
ATOM    870  NE1 TRP A 112       4.957  84.456  19.369  1.00 39.01           N  
ATOM    871  CE2 TRP A 112       6.080  84.142  18.646  1.00 38.07           C  
ATOM    872  CE3 TRP A 112       8.204  85.164  18.054  1.00 38.18           C  
ATOM    873  CZ2 TRP A 112       6.407  82.967  17.968  1.00 40.02           C  
ATOM    874  CZ3 TRP A 112       8.524  83.988  17.378  1.00 39.24           C  
ATOM    875  CH2 TRP A 112       7.630  82.904  17.356  1.00 37.76           C  
ATOM    876  N   LEU A 113       7.531  87.445  22.861  1.00 39.04           N  
ATOM    877  CA  LEU A 113       7.678  86.734  24.148  1.00 40.19           C  
ATOM    878  C   LEU A 113       6.779  87.295  25.246  1.00 40.63           C  
ATOM    879  O   LEU A 113       6.263  86.535  26.059  1.00 40.52           O  
ATOM    880  CB  LEU A 113       9.135  86.692  24.624  1.00 40.53           C  
ATOM    881  CG  LEU A 113      10.192  86.175  23.644  1.00 43.31           C  
ATOM    882  CD1 LEU A 113      11.554  86.019  24.375  1.00 44.66           C  
ATOM    883  CD2 LEU A 113       9.774  84.870  22.954  1.00 43.59           C  
ATOM    884  N   ASN A 114       6.578  88.610  25.250  1.00 40.96           N  
ATOM    885  CA  ASN A 114       5.673  89.269  26.201  1.00 41.83           C  
ATOM    886  C   ASN A 114       4.213  88.878  26.023  1.00 41.64           C  
ATOM    887  O   ASN A 114       3.476  88.787  26.988  1.00 42.59           O  
ATOM    888  CB  ASN A 114       5.792  90.792  26.089  1.00 42.21           C  
ATOM    889  CG  ASN A 114       7.125  91.314  26.599  1.00 44.29           C  
ATOM    890  OD1 ASN A 114       7.316  92.525  26.775  1.00 45.48           O  
ATOM    891  ND2 ASN A 114       8.064  90.402  26.821  1.00 45.21           N  
ATOM    892  N   VAL A 115       3.797  88.669  24.783  1.00 40.82           N  
ATOM    893  CA  VAL A 115       2.434  88.235  24.480  1.00 40.75           C  
ATOM    894  C   VAL A 115       2.247  86.734  24.763  1.00 40.57           C  
ATOM    895  O   VAL A 115       1.160  86.288  25.159  1.00 38.59           O  
ATOM    896  CB  VAL A 115       2.105  88.571  22.996  1.00 40.70           C  
ATOM    897  CG1 VAL A 115       0.950  87.762  22.472  1.00 41.16           C  
ATOM    898  CG2 VAL A 115       1.847  90.070  22.848  1.00 39.08           C  
ATOM    899  N   ARG A 116       3.315  85.965  24.553  1.00 40.51           N  
ATOM    900  CA  ARG A 116       3.233  84.499  24.571  1.00 41.34           C  
ATOM    901  C   ARG A 116       4.512  83.914  25.179  1.00 41.61           C  
ATOM    902  O   ARG A 116       5.430  83.481  24.466  1.00 41.32           O  
ATOM    903  CB  ARG A 116       2.991  83.977  23.161  1.00 41.66           C  
ATOM    904  CG  ARG A 116       2.702  82.448  23.030  1.00 45.12           C  
ATOM    905  CD  ARG A 116       1.555  81.956  23.888  1.00 49.03           C  
ATOM    906  NE  ARG A 116       0.408  82.866  23.891  1.00 54.49           N  
ATOM    907  CZ  ARG A 116      -0.381  83.071  24.951  1.00 56.70           C  
ATOM    908  NH1 ARG A 116      -0.136  82.452  26.106  1.00 57.26           N  
ATOM    909  NH2 ARG A 116      -1.407  83.911  24.859  1.00 58.03           N  
ATOM    910  N   PRO A 117       4.557  83.879  26.512  1.00 42.22           N  
ATOM    911  CA  PRO A 117       5.768  83.556  27.265  1.00 42.91           C  
ATOM    912  C   PRO A 117       6.276  82.129  27.034  1.00 42.77           C  
ATOM    913  O   PRO A 117       7.468  81.875  27.229  1.00 42.80           O  
ATOM    914  CB  PRO A 117       5.336  83.742  28.724  1.00 43.16           C  
ATOM    915  CG  PRO A 117       4.042  84.483  28.672  1.00 43.99           C  
ATOM    916  CD  PRO A 117       3.398  84.082  27.398  1.00 42.12           C  
ATOM    917  N   GLU A 118       5.381  81.218  26.635  1.00 42.30           N  
ATOM    918  CA  GLU A 118       5.746  79.832  26.315  1.00 42.16           C  
ATOM    919  C   GLU A 118       6.706  79.720  25.135  1.00 41.06           C  
ATOM    920  O   GLU A 118       7.389  78.701  24.974  1.00 40.06           O  
ATOM    921  CB  GLU A 118       4.499  78.990  26.000  1.00 43.02           C  
ATOM    922  CG  GLU A 118       3.647  78.651  27.204  1.00 46.03           C  
ATOM    923  CD  GLU A 118       2.726  77.457  26.961  1.00 51.59           C  
ATOM    924  OE1 GLU A 118       1.516  77.564  27.273  1.00 51.93           O  
ATOM    925  OE2 GLU A 118       3.218  76.404  26.474  1.00 54.56           O  
ATOM    926  N   VAL A 119       6.722  80.754  24.294  1.00 39.89           N  
ATOM    927  CA  VAL A 119       7.560  80.792  23.111  1.00 38.92           C  
ATOM    928  C   VAL A 119       9.035  80.801  23.504  1.00 38.58           C  
ATOM    929  O   VAL A 119       9.830  80.195  22.810  1.00 37.52           O  
ATOM    930  CB  VAL A 119       7.205  81.983  22.180  1.00 39.50           C  
ATOM    931  CG1 VAL A 119       8.276  82.218  21.093  1.00 39.79           C  
ATOM    932  CG2 VAL A 119       5.856  81.749  21.508  1.00 41.06           C  
ATOM    933  N   ALA A 120       9.391  81.482  24.600  1.00 37.71           N  
ATOM    934  CA  ALA A 120      10.795  81.581  25.031  1.00 38.03           C  
ATOM    935  C   ALA A 120      11.338  80.202  25.321  1.00 38.16           C  
ATOM    936  O   ALA A 120      12.404  79.831  24.845  1.00 38.42           O  
ATOM    937  CB  ALA A 120      10.947  82.505  26.287  1.00 37.95           C  
ATOM    938  N   THR A 121      10.558  79.427  26.069  1.00 38.17           N  
ATOM    939  CA  THR A 121      10.863  78.055  26.384  1.00 37.98           C  
ATOM    940  C   THR A 121      10.979  77.181  25.128  1.00 37.27           C  
ATOM    941  O   THR A 121      11.913  76.375  25.008  1.00 35.70           O  
ATOM    942  CB  THR A 121       9.790  77.535  27.349  1.00 38.47           C  
ATOM    943  OG1 THR A 121       9.875  78.317  28.541  1.00 41.72           O  
ATOM    944  CG2 THR A 121      10.019  76.090  27.700  1.00 40.51           C  
ATOM    945  N   ALA A 122      10.046  77.357  24.194  1.00 36.10           N  
ATOM    946  CA  ALA A 122      10.063  76.604  22.935  1.00 34.97           C  
ATOM    947  C   ALA A 122      11.266  76.982  22.056  1.00 34.37           C  
ATOM    948  O   ALA A 122      11.926  76.109  21.475  1.00 33.58           O  
ATOM    949  CB  ALA A 122       8.754  76.798  22.188  1.00 35.38           C  
ATOM    950  N   LEU A 123      11.583  78.274  21.973  1.00 33.57           N  
ATOM    951  CA  LEU A 123      12.762  78.675  21.214  1.00 32.97           C  
ATOM    952  C   LEU A 123      14.041  78.182  21.867  1.00 32.36           C  
ATOM    953  O   LEU A 123      14.920  77.683  21.177  1.00 33.07           O  
ATOM    954  CB  LEU A 123      12.792  80.184  20.977  1.00 33.81           C  
ATOM    955  CG  LEU A 123      11.598  80.662  20.135  1.00 34.21           C  
ATOM    956  CD1 LEU A 123      11.663  82.154  20.011  1.00 36.53           C  
ATOM    957  CD2 LEU A 123      11.515  79.971  18.757  1.00 33.50           C  
ATOM    958  N   LEU A 124      14.131  78.284  23.190  1.00 31.65           N  
ATOM    959  CA  LEU A 124      15.293  77.773  23.925  1.00 32.19           C  
ATOM    960  C   LEU A 124      15.477  76.271  23.719  1.00 32.40           C  
ATOM    961  O   LEU A 124      16.603  75.798  23.547  1.00 32.19           O  
ATOM    962  CB  LEU A 124      15.180  78.108  25.422  1.00 31.55           C  
ATOM    963  CG  LEU A 124      15.513  79.560  25.801  1.00 31.85           C  
ATOM    964  CD1 LEU A 124      14.977  79.864  27.209  1.00 31.10           C  
ATOM    965  CD2 LEU A 124      17.019  79.810  25.712  1.00 30.23           C  
ATOM    966  N   ARG A 125      14.369  75.528  23.769  1.00 32.57           N  
ATOM    967  CA  ARG A 125      14.365  74.094  23.467  1.00 34.08           C  
ATOM    968  C   ARG A 125      14.971  73.815  22.108  1.00 33.89           C  
ATOM    969  O   ARG A 125      15.889  73.026  22.009  1.00 35.24           O  
ATOM    970  CB  ARG A 125      12.944  73.516  23.524  1.00 33.66           C  
ATOM    971  CG  ARG A 125      12.862  72.012  23.281  1.00 36.28           C  
ATOM    972  CD  ARG A 125      11.454  71.446  23.530  1.00 36.05           C  
ATOM    973  NE  ARG A 125      11.357  70.768  24.826  1.00 42.44           N  
ATOM    974  CZ  ARG A 125      10.835  71.305  25.924  1.00 43.48           C  
ATOM    975  NH1 ARG A 125      10.338  72.539  25.895  1.00 46.87           N  
ATOM    976  NH2 ARG A 125      10.798  70.608  27.051  1.00 43.17           N  
ATOM    977  N   ALA A 126      14.464  74.476  21.071  1.00 34.35           N  
ATOM    978  CA  ALA A 126      14.883  74.234  19.691  1.00 34.37           C  
ATOM    979  C   ALA A 126      16.373  74.476  19.500  1.00 35.08           C  
ATOM    980  O   ALA A 126      17.076  73.631  18.962  1.00 34.54           O  
ATOM    981  CB  ALA A 126      14.079  75.115  18.742  1.00 34.78           C  
ATOM    982  N   VAL A 127      16.855  75.632  19.957  1.00 35.46           N  
ATOM    983  CA  VAL A 127      18.276  75.969  19.852  1.00 36.75           C  
ATOM    984  C   VAL A 127      19.151  75.006  20.674  1.00 36.77           C  
ATOM    985  O   VAL A 127      20.194  74.538  20.188  1.00 36.41           O  
ATOM    986  CB  VAL A 127      18.530  77.472  20.209  1.00 36.50           C  
ATOM    987  CG1 VAL A 127      20.009  77.785  20.186  1.00 38.98           C  
ATOM    988  CG2 VAL A 127      17.815  78.371  19.220  1.00 37.83           C  
ATOM    989  N   ALA A 128      18.719  74.682  21.898  1.00 37.44           N  
ATOM    990  CA  ALA A 128      19.463  73.738  22.756  1.00 38.19           C  
ATOM    991  C   ALA A 128      19.591  72.369  22.110  1.00 39.18           C  
ATOM    992  O   ALA A 128      20.628  71.703  22.249  1.00 38.98           O  
ATOM    993  CB  ALA A 128      18.804  73.591  24.117  1.00 37.61           C  
ATOM    994  N   ARG A 129      18.524  71.949  21.430  1.00 40.36           N  
ATOM    995  CA  ARG A 129      18.473  70.638  20.772  1.00 41.66           C  
ATOM    996  C   ARG A 129      19.582  70.505  19.731  1.00 42.13           C  
ATOM    997  O   ARG A 129      20.363  69.547  19.741  1.00 42.69           O  
ATOM    998  CB  ARG A 129      17.098  70.426  20.149  1.00 41.71           C  
ATOM    999  CG  ARG A 129      16.868  69.060  19.522  1.00 44.69           C  
ATOM   1000  CD  ARG A 129      15.488  68.531  19.889  1.00 47.25           C  
ATOM   1001  NE  ARG A 129      15.583  67.515  20.935  1.00 51.06           N  
ATOM   1002  CZ  ARG A 129      14.708  67.346  21.926  1.00 51.96           C  
ATOM   1003  NH1 ARG A 129      13.650  68.148  22.053  1.00 51.09           N  
ATOM   1004  NH2 ARG A 129      14.916  66.377  22.816  1.00 51.72           N  
ATOM   1005  N   ARG A 130      19.668  71.486  18.849  1.00 42.72           N  
ATOM   1006  CA  ARG A 130      20.686  71.491  17.818  1.00 43.34           C  
ATOM   1007  C   ARG A 130      22.113  71.582  18.343  1.00 43.33           C  
ATOM   1008  O   ARG A 130      23.010  70.893  17.852  1.00 42.61           O  
ATOM   1009  CB  ARG A 130      20.407  72.620  16.865  1.00 43.57           C  
ATOM   1010  CG  ARG A 130      19.679  72.140  15.653  1.00 46.68           C  
ATOM   1011  CD  ARG A 130      19.716  73.188  14.619  1.00 48.33           C  
ATOM   1012  NE  ARG A 130      18.815  74.250  15.013  1.00 50.64           N  
ATOM   1013  CZ  ARG A 130      18.832  75.472  14.510  1.00 50.14           C  
ATOM   1014  NH1 ARG A 130      17.951  76.352  14.954  1.00 50.70           N  
ATOM   1015  NH2 ARG A 130      19.721  75.807  13.575  1.00 49.34           N  
ATOM   1016  N   LEU A 131      22.315  72.447  19.334  1.00 43.87           N  
ATOM   1017  CA  LEU A 131      23.617  72.602  19.977  1.00 44.37           C  
ATOM   1018  C   LEU A 131      24.024  71.280  20.640  1.00 44.77           C  
ATOM   1019  O   LEU A 131      25.212  70.897  20.649  1.00 44.93           O  
ATOM   1020  CB  LEU A 131      23.583  73.775  20.967  1.00 43.95           C  
ATOM   1021  CG  LEU A 131      24.897  74.174  21.638  1.00 44.45           C  
ATOM   1022  CD1 LEU A 131      25.921  74.655  20.634  1.00 42.90           C  
ATOM   1023  CD2 LEU A 131      24.638  75.235  22.696  1.00 44.21           C  
ATOM   1024  N   ARG A 132      23.020  70.563  21.137  1.00 45.51           N  
ATOM   1025  CA  ARG A 132      23.191  69.221  21.681  1.00 46.27           C  
ATOM   1026  C   ARG A 132      23.656  68.216  20.630  1.00 46.94           C  
ATOM   1027  O   ARG A 132      24.646  67.509  20.845  1.00 47.17           O  
ATOM   1028  CB  ARG A 132      21.894  68.756  22.362  1.00 46.47           C  
ATOM   1029  CG  ARG A 132      21.691  67.242  22.431  1.00 47.92           C  
ATOM   1030  CD  ARG A 132      21.148  66.818  23.784  1.00 50.93           C  
ATOM   1031  NE  ARG A 132      19.690  66.701  23.820  1.00 52.91           N  
ATOM   1032  CZ  ARG A 132      19.000  66.317  24.896  1.00 53.93           C  
ATOM   1033  NH1 ARG A 132      19.629  66.026  26.031  1.00 53.77           N  
ATOM   1034  NH2 ARG A 132      17.674  66.230  24.845  1.00 54.41           N  
ATOM   1035  N   LYS A 133      22.943  68.132  19.508  1.00 47.89           N  
ATOM   1036  CA  LYS A 133      23.306  67.199  18.432  1.00 48.51           C  
ATOM   1037  C   LYS A 133      24.723  67.487  17.929  1.00 49.33           C  
ATOM   1038  O   LYS A 133      25.554  66.573  17.848  1.00 49.59           O  
ATOM   1039  CB  LYS A 133      22.303  67.254  17.270  1.00 48.48           C  
ATOM   1040  CG  LYS A 133      20.832  67.056  17.656  1.00 48.50           C  
ATOM   1041  CD  LYS A 133      20.444  65.586  17.763  1.00 50.00           C  
ATOM   1042  CE  LYS A 133      18.969  65.431  18.127  1.00 50.06           C  
ATOM   1043  NZ  LYS A 133      18.598  64.003  18.343  1.00 50.56           N  
ATOM   1044  N   THR A 134      24.998  68.756  17.626  1.00 50.38           N  
ATOM   1045  CA  THR A 134      26.332  69.178  17.210  1.00 51.78           C  
ATOM   1046  C   THR A 134      27.397  68.659  18.171  1.00 52.68           C  
ATOM   1047  O   THR A 134      28.293  67.944  17.764  1.00 53.04           O  
ATOM   1048  CB  THR A 134      26.474  70.713  17.097  1.00 51.72           C  
ATOM   1049  OG1 THR A 134      25.859  71.180  15.883  1.00 52.65           O  
ATOM   1050  CG2 THR A 134      27.961  71.106  17.089  1.00 51.83           C  
ATOM   1051  N   ASN A 135      27.288  69.009  19.448  1.00 53.87           N  
ATOM   1052  CA  ASN A 135      28.328  68.654  20.399  1.00 54.99           C  
ATOM   1053  C   ASN A 135      28.325  67.181  20.814  1.00 55.35           C  
ATOM   1054  O   ASN A 135      29.388  66.565  20.891  1.00 55.41           O  
ATOM   1055  CB  ASN A 135      28.326  69.615  21.599  1.00 55.21           C  
ATOM   1056  CG  ASN A 135      28.874  71.018  21.240  1.00 56.57           C  
ATOM   1057  OD1 ASN A 135      28.300  72.046  21.636  1.00 57.87           O  
ATOM   1058  ND2 ASN A 135      29.988  71.058  20.486  1.00 57.47           N  
ATOM   1059  N   ASP A 136      27.136  66.613  21.029  1.00 56.12           N  
ATOM   1060  CA  ASP A 136      26.994  65.300  21.689  1.00 56.73           C  
ATOM   1061  C   ASP A 136      26.757  64.103  20.775  1.00 57.00           C  
ATOM   1062  O   ASP A 136      27.555  63.162  20.773  1.00 57.34           O  
ATOM   1063  CB  ASP A 136      25.913  65.347  22.773  1.00 56.87           C  
ATOM   1064  CG  ASP A 136      26.430  65.899  24.083  1.00 57.41           C  
ATOM   1065  OD1 ASP A 136      27.273  65.227  24.722  1.00 58.14           O  
ATOM   1066  OD2 ASP A 136      25.986  66.998  24.477  1.00 57.59           O  
ATOM   1067  N   ALA A 137      25.649  64.114  20.035  1.00 57.28           N  
ATOM   1068  CA  ALA A 137      25.363  63.055  19.057  1.00 57.49           C  
ATOM   1069  C   ALA A 137      26.548  62.862  18.096  1.00 57.61           C  
ATOM   1070  O   ALA A 137      26.757  61.777  17.546  1.00 57.49           O  
ATOM   1071  CB  ALA A 137      24.082  63.383  18.281  1.00 57.51           C  
HETATM 1072  N   MSE A 138      27.318  63.936  17.923  1.00 57.76           N  
HETATM 1073  CA  MSE A 138      28.504  63.958  17.083  1.00 57.82           C  
HETATM 1074  C   MSE A 138      29.731  63.470  17.856  1.00 57.64           C  
HETATM 1075  O   MSE A 138      29.951  63.849  19.006  1.00 57.38           O  
HETATM 1076  CB  MSE A 138      28.713  65.375  16.534  1.00 57.87           C  
HETATM 1077  CG  MSE A 138      30.116  65.697  16.053  1.00 58.86           C  
HETATM 1078 SE   MSE A 138      31.336  66.471  17.386  0.80 60.92          SE  
HETATM 1079  CE  MSE A 138      31.072  68.387  17.067  1.00 57.39           C  
ATOM   1080  N   LEU A 141      34.090  62.510  17.559  1.00 57.05           N  
ATOM   1081  CA  LEU A 141      35.265  63.031  16.821  1.00 57.10           C  
ATOM   1082  C   LEU A 141      36.530  62.968  17.666  1.00 57.78           C  
ATOM   1083  O   LEU A 141      37.609  62.683  17.142  1.00 57.63           O  
ATOM   1084  CB  LEU A 141      35.027  64.493  16.389  1.00 56.75           C  
ATOM   1085  CG  LEU A 141      35.543  65.052  15.009  1.00 55.42           C  
ATOM   1086  CD1 LEU A 141      34.546  66.179  14.618  1.00 50.78           C  
ATOM   1087  CD2 LEU A 141      36.985  65.513  15.086  1.00 53.57           C  
ATOM   1088  N   VAL A 142      36.384  63.270  18.957  1.00 58.43           N  
ATOM   1089  CA  VAL A 142      37.438  63.118  19.986  1.00 59.06           C  
ATOM   1090  C   VAL A 142      38.841  63.689  19.623  1.00 59.57           C  
ATOM   1091  O   VAL A 142      38.954  64.877  19.315  1.00 59.55           O  
ATOM   1092  CB  VAL A 142      37.435  61.667  20.626  1.00 59.01           C  
ATOM   1093  CG1 VAL A 142      38.005  60.595  19.677  1.00 59.08           C  
ATOM   1094  CG2 VAL A 142      38.130  61.650  21.995  1.00 59.05           C  
ATOM   1095  N   PHE A 143      39.883  62.848  19.643  1.00 60.56           N  
ATOM   1096  CA  PHE A 143      41.294  63.285  19.628  1.00 61.28           C  
ATOM   1097  C   PHE A 143      41.546  64.341  20.714  1.00 62.04           C  
ATOM   1098  O   PHE A 143      41.987  65.461  20.427  1.00 62.13           O  
ATOM   1099  CB  PHE A 143      41.760  63.803  18.249  1.00 61.07           C  
ATOM   1100  CG  PHE A 143      41.623  62.805  17.130  1.00 60.83           C  
ATOM   1101  CD1 PHE A 143      40.460  62.754  16.364  1.00 60.30           C  
ATOM   1102  CD2 PHE A 143      42.664  61.940  16.819  1.00 60.00           C  
ATOM   1103  CE1 PHE A 143      40.324  61.838  15.323  1.00 60.09           C  
ATOM   1104  CE2 PHE A 143      42.535  61.029  15.779  1.00 59.74           C  
ATOM   1105  CZ  PHE A 143      41.365  60.976  15.031  1.00 59.93           C  
ATOM   1106  N   SER A 144      41.222  63.989  21.956  1.00 62.99           N  
ATOM   1107  CA  SER A 144      41.685  64.754  23.115  1.00 63.78           C  
ATOM   1108  C   SER A 144      43.006  64.097  23.508  1.00 64.15           C  
ATOM   1109  O   SER A 144      43.096  63.450  24.556  1.00 64.49           O  
ATOM   1110  CB  SER A 144      40.691  64.672  24.286  1.00 63.83           C  
ATOM   1111  OG  SER A 144      39.336  64.698  23.864  1.00 64.44           O  
ATOM   1112  N   ASP A 145      44.014  64.232  22.644  1.00 64.35           N  
ATOM   1113  CA  ASP A 145      45.281  63.510  22.819  1.00 64.34           C  
ATOM   1114  C   ASP A 145      46.564  64.355  22.711  1.00 64.39           C  
ATOM   1115  O   ASP A 145      47.662  63.801  22.718  1.00 64.87           O  
ATOM   1116  CB  ASP A 145      45.331  62.253  21.922  1.00 63.26           C  
ATOM   1117  CG  ASP A 145      45.651  62.569  20.463  1.00 63.48           C  
ATOM   1118  OD1 ASP A 145      45.678  61.616  19.627  1.00 56.59           O  
ATOM   1119  OD2 ASP A 145      45.894  63.763  20.152  1.00 64.53           O  
ATOM   1120  N   GLY A 146      46.424  65.679  22.591  1.00 64.34           N  
ATOM   1121  CA  GLY A 146      47.568  66.594  22.653  1.00 63.86           C  
ATOM   1122  C   GLY A 146      48.193  67.157  21.374  1.00 63.90           C  
ATOM   1123  O   GLY A 146      48.625  68.314  21.367  1.00 63.71           O  
ATOM   1124  N   SER A 147      48.216  66.366  20.296  1.00 63.18           N  
ATOM   1125  CA  SER A 147      49.124  66.584  19.132  1.00 62.94           C  
ATOM   1126  C   SER A 147      49.496  68.018  18.684  1.00 63.33           C  
ATOM   1127  O   SER A 147      50.599  68.220  18.129  1.00 62.94           O  
ATOM   1128  CB  SER A 147      48.737  65.705  17.904  1.00 62.50           C  
ATOM   1129  OG  SER A 147      47.544  64.966  18.074  1.00 61.11           O  
ATOM   1130  OXT SER A 147      48.740  68.995  18.844  1.00 63.47           O  
TER    1131      SER A 147                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
