
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  237 ( 1930),  selected  237 , name 2bgc_E
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 2bgc_E.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_E      M       1           -
LGA    N     2_E      H       2           -
LGA    A     3_E      T       3           -
LGA    Q     4_E      A       4           #
LGA    A     5_E      L       5          3.555
LGA    -       -      I       6           -
LGA    -       -      N       7           -
LGA    E     6_E      H       8          4.410
LGA    -       -      I       9           -
LGA    -       -      R      10           -
LGA    -       -      K      11           -
LGA    -       -      F      12           -
LGA    -       -      I      13           -
LGA    -       -      F      14           -
LGA    E     7_E      L      15          6.699
LGA    F     8_E      T      16           -
LGA    K     9_E      D      17           -
LGA    -       -      E      18           -
LGA    -       -      D      19           -
LGA    K    10_E      A      20          4.689
LGA    Y    11_E      G      21          4.560
LGA    L    12_E      T      22          6.478
LGA    E    13_E      L      23           #
LGA    T    14_E      S      24           #
LGA    N    15_E      A      25          2.249
LGA    G    16_E      F      26          4.647
LGA    I    17_E      F      27          2.669
LGA    K    18_E      Q      28          2.377
LGA    P    19_E      L      29          0.644
LGA    K    20_E      K      30          0.810
LGA    Q    21_E      K      31          0.536
LGA    F    22_E      V      32          0.738
LGA    H    23_E      R      33          0.834
LGA    K    24_E      K      34          0.757
LGA    K    25_E      K      35          0.625
LGA    E    26_E      E      36          0.876
LGA    L    27_E      T      37          1.819
LGA    I    28_E      L      38          2.526
LGA    F    29_E      L      39          2.113
LGA    N    30_E      K      40          2.148
LGA    Q    31_E      T      41          1.862
LGA    W    32_E      G      42          2.581
LGA    D    33_E      E      43          1.171
LGA    P    34_E      I      44          1.424
LGA    Q    35_E      C      45          3.735
LGA    E    36_E      R      46          2.399
LGA    Y    37_E      I      47          1.955
LGA    C    38_E      N      48          1.700
LGA    I    39_E      Y      49          1.659
LGA    F    40_E      F      50          1.976
LGA    L    41_E      V      51          2.051
LGA    Y    42_E      V      52          2.122
LGA    D    43_E      K      53          1.861
LGA    G    44_E      G      54          1.296
LGA    I    45_E      C      55          1.152
LGA    T    46_E      L      56          1.556
LGA    K    47_E      R      57          1.047
LGA    L    48_E      L      58          0.815
LGA    T    49_E      F      59          0.683
LGA    S    50_E      F      60          0.492
LGA    I    51_E      I      61          0.731
LGA    S    52_E      D      62          2.223
LGA    E    53_E      E      63          3.407
LGA    N    54_E      K      64          2.894
LGA    G    55_E      G      65          0.762
LGA    T    56_E      I      66          1.895
LGA    I    57_E      E      67          1.325
LGA    M    58_E      Q      68          0.492
LGA    N    59_E      T      69          0.778
LGA    L    60_E      T      70          0.317
LGA    Q    61_E      Q      71          1.266
LGA    Y    62_E      F      72          1.386
LGA    Y    63_E      A      73          1.013
LGA    K    64_E      I      74          0.313
LGA    G    65_E      E      75          0.850
LGA    A    66_E      N      76          1.022
LGA    F    67_E      W      77          1.244
LGA    V    68_E      W      78          1.797
LGA    I    69_E      L      79          1.898
LGA    M    70_E      S      80          2.994
LGA    S    71_E      D      81          2.980
LGA    -       -      Y      82           -
LGA    -       -      M      83           -
LGA    G    72_E      A      84          2.845
LGA    F    73_E      F      85          4.434
LGA    I    74_E      Q      86          3.622
LGA    D    75_E      -       -           -
LGA    T    76_E      -       -           -
LGA    E    77_E      -       -           -
LGA    T    78_E      K      87          2.288
LGA    S    79_E      Q      88          4.914
LGA    V    80_E      Q      89           #
LGA    -       -      P      90           -
LGA    G    81_E      A      91          4.805
LGA    Y    82_E      D      92          1.096
LGA    Y    83_E      F      93          0.868
LGA    N    84_E      Y      94          1.382
LGA    L    85_E      I      95          1.495
LGA    E    86_E      Q      96          1.327
LGA    V    87_E      S      97          1.019
LGA    I    88_E      V      98          1.512
LGA    S    89_E      E      99          1.829
LGA    E    90_E      N     100          2.982
LGA    Q    91_E      -       -           -
LGA    A    92_E      C     101          0.940
LGA    T    93_E      E     102          1.400
LGA    A    94_E      L     103          1.305
LGA    Y    95_E      L     104          1.969
LGA    V    96_E      S     105          2.141
LGA    I    97_E      I     106          1.703
LGA    K    98_E      T     107          1.694
LGA    I    99_E      Y     108          0.867
LGA    N   100_E      T     109          1.281
LGA    E   101_E      E     110          1.394
LGA    L   102_E      Q     111          0.990
LGA    K   103_E      E     112          0.500
LGA    E   104_E      N     113          0.596
LGA    L   105_E      L     114          0.473
LGA    L   106_E      F     115          1.203
LGA    S   107_E      E     116          1.340
LGA    K   108_E      R     117          1.137
LGA    N   109_E      I     118          0.973
LGA    L   110_E      P     119          1.867
LGA    T   111_E      A     120          1.994
LGA    H   112_E      L     121          1.788
LGA    F   113_E      E     122          2.169
LGA    F   114_E      R     123          1.477
LGA    Y   115_E      Y     124          0.959
LGA    V   116_E      F     125          1.640
LGA    F   117_E      R     126          2.054
LGA    Q   118_E      L     127          1.039
LGA    T   119_E      V     128          0.777
LGA    L   120_E      Y     129          1.011
LGA    Q   121_E      Q     130          0.892
LGA    K   122_E      K     131          0.843
LGA    Q   123_E      S     132          1.013
LGA    V   124_E      F     133          0.617
LGA    S   125_E      A     134          0.424
LGA    Y   126_E      A     135          0.554
LGA    S   127_E      A     136          1.112
LGA    L   128_E      Q     137          0.796
LGA    A   129_E      L     138          1.077
LGA    K   130_E      R     139          1.487
LGA    F   131_E      S     140          1.194
LGA    N   132_E      K     141          1.615
LGA    D   133_E      F     142          2.382
LGA    F   134_E      Q     143          2.561
LGA    S   135_E      H     144          2.491
LGA    I   136_E      -       -           -
LGA    N   137_E      -       -           -
LGA    G   138_E      -       -           -
LGA    K   139_E      -       -           -
LGA    L   140_E      -       -           -
LGA    G   141_E      M     145          3.449
LGA    S   142_E      Y     146          2.647
LGA    I   143_E      -       -           -
LGA    C   144_E      -       -           -
LGA    S   145_E      -       -           -
LGA    Q   146_E      -       -           -
LGA    L   147_E      -       -           -
LGA    L   148_E      -       -           -
LGA    I   149_E      -       -           -
LGA    L   150_E      -       -           -
LGA    T   151_E      -       -           -
LGA    Y   152_E      -       -           -
LGA    V   153_E      -       -           -
LGA    Y   154_E      -       -           -
LGA    G   155_E      -       -           -
LGA    K   156_E      -       -           -
LGA    E   157_E      -       -           -
LGA    T   158_E      -       -           -
LGA    P   159_E      -       -           -
LGA    D   160_E      -       -           -
LGA    G   161_E      -       -           -
LGA    I   162_E      -       -           -
LGA    K   163_E      -       -           -
LGA    I   164_E      -       -           -
LGA    T   165_E      -       -           -
LGA    L   166_E      -       -           -
LGA    D   167_E      -       -           -
LGA    N   168_E      -       -           -
LGA    L   169_E      -       -           -
LGA    T   170_E      -       -           -
LGA    M   171_E      -       -           -
LGA    Q   172_E      -       -           -
LGA    E   173_E      -       -           -
LGA    L   174_E      -       -           -
LGA    G   175_E      -       -           -
LGA    Y   176_E      -       -           -
LGA    S   177_E      -       -           -
LGA    S   178_E      -       -           -
LGA    G   179_E      -       -           -
LGA    I   180_E      -       -           -
LGA    A   181_E      -       -           -
LGA    H   182_E      -       -           -
LGA    S   183_E      -       -           -
LGA    S   184_E      -       -           -
LGA    A   185_E      -       -           -
LGA    V   186_E      -       -           -
LGA    S   187_E      -       -           -
LGA    R   188_E      -       -           -
LGA    I   189_E      -       -           -
LGA    I   190_E      -       -           -
LGA    S   191_E      -       -           -
LGA    K   192_E      -       -           -
LGA    L   193_E      -       -           -
LGA    K   194_E      -       -           -
LGA    Q   195_E      -       -           -
LGA    E   196_E      -       -           -
LGA    K   197_E      -       -           -
LGA    V   198_E      -       -           -
LGA    I   199_E      -       -           -
LGA    V   200_E      -       -           -
LGA    Y   201_E      -       -           -
LGA    K   202_E      -       -           -
LGA    N   203_E      -       -           -
LGA    S   204_E      -       -           -
LGA    C   205_E      -       -           -
LGA    F   206_E      -       -           -
LGA    Y   207_E      -       -           -
LGA    V   208_E      -       -           -
LGA    Q   209_E      -       -           -
LGA    N   210_E      -       -           -
LGA    L   211_E      -       -           -
LGA    D   212_E      -       -           -
LGA    Y   213_E      -       -           -
LGA    L   214_E      -       -           -
LGA    K   215_E      -       -           -
LGA    R   216_E      -       -           -
LGA    Y   217_E      -       -           -
LGA    A   218_E      -       -           -
LGA    P   219_E      -       -           -
LGA    K   220_E      -       -           -
LGA    L   221_E      -       -           -
LGA    D   222_E      -       -           -
LGA    E   223_E      -       -           -
LGA    W   224_E      -       -           -
LGA    F   225_E      -       -           -
LGA    Y   226_E      -       -           -
LGA    L   227_E      -       -           -
LGA    A   228_E      -       -           -
LGA    X   229_E      -       -           -
LGA    P   230_E      -       -           -
LGA    A   231_E      -       -           -
LGA    T   232_E      -       -           -
LGA    W   233_E      -       -           -
LGA    G   234_E      -       -           -
LGA    K   235_E      -       -           -
LGA    L   236_E      -       -           -
LGA    N   237_E      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  237  146    5.0    124    2.16    14.52     72.637     5.475

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.785066 * X  +  -0.020279 * Y  +   0.619081 * Z  +  31.040337
  Y_new =  -0.119559 * X  +   0.985630 * Y  +  -0.119328 * Z  +  13.291465
  Z_new =  -0.607764 * X  +  -0.167697 * Y  +  -0.776209 * Z  +  52.538113 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.928817    0.212776  [ DEG:  -167.8088     12.1912 ]
  Theta =   0.653242    2.488350  [ DEG:    37.4280    142.5720 ]
  Phi   =  -2.990462    0.151131  [ DEG:  -171.3409      8.6591 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bgc_E                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bgc_E.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  237  146   5.0  124   2.16   14.52  72.637
REMARK  ---------------------------------------------------------- 
MOLECULE 2bgc_E
HEADER    TRANSCRIPTION                           16-DEC-04   2BGC              
TITLE     PRFA-G145S, A CONSTITUTIVE ACTIVE MUTANT OF THE                       
TITLE    2 TRANSCRIPTIONAL REGULATOR IN L.MONOCYTOGENES                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRFA;                                                      
COMPND   3 CHAIN: A, B, D, E, F, G, H, I;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: LISTERIA MONOCYTOGENES;                         
SOURCE   3 STRAIN: EGD-E;                                                       
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: M15;                                       
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PQE-30                                    
KEYWDS    BACTERIAL INFECTION,HUMAN PATHOGEN,TRANSCRIPTIONAL                    
KEYWDS   2 REGULATOR,TRANSCRIPTION                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.EITING,G.HAGELUEKEN,W.-D.SCHUBERT,D.W.HEINZ                         
REVDAT   1   14-APR-05 2BGC    0                                                
JRNL        AUTH   M.EITING,G.HAGELUKEN,W.D.SCHUBERT,D.W.HEINZ                  
JRNL        TITL   THE MUTATION G145S IN PRFA, A KEY VIRULENCE                  
JRNL        TITL 2 REGULATOR OF LISTERIA MONOCYTOGENES, INCREASES               
JRNL        TITL 3 DNA-BINDING AFFINITY BY STABILIZING THE HTH MOTIF.           
JRNL        REF    MOL.MICROBIOL.                V.  56   433 2005              
JRNL        REFN   ASTM MOMIEE  UK ISSN 0950-382X                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2BGC A    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC A    2   237  UNP    P22262   PRFA_LISMO       2    237             
DBREF  2BGC B    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC B    2   237  UNP    P22262   PRFA_LISMO       2    237             
DBREF  2BGC D    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC D    2   237  UNP    P22262   PRFA_LISMO       2    237             
DBREF  2BGC E    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC E    2   237  UNP    P22262   PRFA_LISMO       2    237             
DBREF  2BGC F    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC F    2   237  UNP    P22262   PRFA_LISMO       2    237             
DBREF  2BGC G    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC G    2   237  UNP    P22262   PRFA_LISMO       2    237             
DBREF  2BGC H    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC H    2   237  UNP    P22262   PRFA_LISMO       2    237             
DBREF  2BGC I    0     1  UNP    P22262   PRFA_LISMO       0      1             
DBREF  2BGC I    2   237  UNP    P22262   PRFA_LISMO       2    237             
SEQRES   1 A  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 A  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 A  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 A  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 A  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 A  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 A  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 A  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 A  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 A  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 A  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 A  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 A  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 A  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 A  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 A  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 A  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 A  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 A  238  GLY LYS LEU ASN                                              
SEQRES   1 B  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 B  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 B  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 B  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 B  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 B  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 B  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 B  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 B  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 B  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 B  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 B  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 B  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 B  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 B  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 B  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 B  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 B  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 B  238  GLY LYS LEU ASN                                              
SEQRES   1 D  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 D  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 D  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 D  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 D  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 D  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 D  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 D  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 D  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 D  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 D  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 D  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 D  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 D  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 D  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 D  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 D  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 D  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 D  238  GLY LYS LEU ASN                                              
SEQRES   1 E  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 E  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 E  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 E  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 E  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 E  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 E  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 E  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 E  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 E  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 E  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 E  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 E  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 E  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 E  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 E  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 E  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 E  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 E  238  GLY LYS LEU ASN                                              
SEQRES   1 F  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 F  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 F  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 F  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 F  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 F  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 F  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 F  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 F  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 F  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 F  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 F  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 F  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 F  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 F  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 F  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 F  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 F  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 F  238  GLY LYS LEU ASN                                              
SEQRES   1 G  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 G  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 G  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 G  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 G  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 G  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 G  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 G  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 G  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 G  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 G  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 G  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 G  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 G  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 G  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 G  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 G  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 G  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 G  238  GLY LYS LEU ASN                                              
SEQRES   1 H  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 H  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 H  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 H  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 H  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 H  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 H  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 H  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 H  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 H  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 H  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 H  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 H  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 H  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 H  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 H  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 H  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 H  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 H  238  GLY LYS LEU ASN                                              
SEQRES   1 I  238  GLY SER ASN ALA GLN ALA GLU GLU PHE LYS LYS TYR LEU          
SEQRES   2 I  238  GLU THR ASN GLY ILE LYS PRO LYS GLN PHE HIS LYS LYS          
SEQRES   3 I  238  GLU LEU ILE PHE ASN GLN TRP ASP PRO GLN GLU TYR CYS          
SEQRES   4 I  238  ILE PHE LEU TYR ASP GLY ILE THR LYS LEU THR SER ILE          
SEQRES   5 I  238  SER GLU ASN GLY THR ILE MET ASN LEU GLN TYR TYR LYS          
SEQRES   6 I  238  GLY ALA PHE VAL ILE MET SER GLY PHE ILE ASP THR GLU          
SEQRES   7 I  238  THR SER VAL GLY TYR TYR ASN LEU GLU VAL ILE SER GLU          
SEQRES   8 I  238  GLN ALA THR ALA TYR VAL ILE LYS ILE ASN GLU LEU LYS          
SEQRES   9 I  238  GLU LEU LEU SER LYS ASN LEU THR HIS PHE PHE TYR VAL          
SEQRES  10 I  238  PHE GLN THR LEU GLN LYS GLN VAL SER TYR SER LEU ALA          
SEQRES  11 I  238  LYS PHE ASN ASP PHE SER ILE ASN GLY LYS LEU GLY SER          
SEQRES  12 I  238  ILE CYS SER GLN LEU LEU ILE LEU THR TYR VAL TYR GLY          
SEQRES  13 I  238  LYS GLU THR PRO ASP GLY ILE LYS ILE THR LEU ASP ASN          
SEQRES  14 I  238  LEU THR MET GLN GLU LEU GLY TYR SER SER GLY ILE ALA          
SEQRES  15 I  238  HIS SER SER ALA VAL SER ARG ILE ILE SER LYS LEU LYS          
SEQRES  16 I  238  GLN GLU LYS VAL ILE VAL TYR LYS ASN SER CYS PHE TYR          
SEQRES  17 I  238  VAL GLN ASN LEU ASP TYR LEU LYS ARG TYR ALA PRO LYS          
SEQRES  18 I  238  LEU ASP GLU TRP PHE TYR LEU ALA PR3 PRO ALA THR TRP          
SEQRES  19 I  238  GLY LYS LEU ASN                                              
HET    PR3  A 229       8                                                       
HET    PR3  B 229      10                                                       
HET    PR3  D 229       8                                                       
HET    PR3  E 229       8                                                       
HET    PR3  F 229       8                                                       
HET    PR3  G 229       8                                                       
HET    PR3  H 229       8                                                       
HET    PR3  I 229       8                                                       
HET    DTU  A1238       8                                                       
HET    DTT  F1238       8                                                       
HETNAM     PR3 S,S-PROPYLTHIOCYSTEINE                                           
HETNAM     DTU (2R,3S)-1,4-DIMERCAPTOBUTANE-2,3-DIOL                            
HETNAM     DTT 2,3-DIHYDROXY-1,4-DITHIOBUTANE                                   
HETSYN     DTT 1,4-DITHIOTHREITOL                                               
FORMUL   1  PR3    8(C6 H13 N O S2)                                             
FORMUL   9  DTU    C4 H10 O2 S2                                                 
FORMUL  10  DTT    C4 H10 O2 S2                                                 
FORMUL  11  HOH   *389(H2 O)                                                    
CRYST1  117.247  100.243  189.563  90.00  90.33  90.00 C 1 2 1      32          
ATOM   5711  N   SER E   1       6.686  72.154   2.130  1.00 76.76           N  
ATOM   5712  CA  SER E   1       5.204  72.225   2.313  1.00 76.38           C  
ATOM   5713  C   SER E   1       4.792  71.986   3.773  1.00 73.53           C  
ATOM   5714  O   SER E   1       3.733  71.395   4.033  1.00 74.41           O  
ATOM   5715  CB  SER E   1       4.517  71.193   1.396  1.00 77.79           C  
ATOM   5716  OG  SER E   1       5.103  71.189   0.097  1.00 79.72           O  
ATOM   5717  N   ASN E   2       5.621  72.437   4.722  1.00 69.21           N  
ATOM   5718  CA  ASN E   2       5.389  72.138   6.130  1.00 63.93           C  
ATOM   5719  C   ASN E   2       4.279  73.059   6.599  1.00 59.22           C  
ATOM   5720  O   ASN E   2       4.201  74.249   6.198  1.00 54.65           O  
ATOM   5721  CB  ASN E   2       6.661  72.328   7.004  1.00 65.94           C  
ATOM   5722  CG  ASN E   2       7.085  71.035   7.774  1.00 68.06           C  
ATOM   5723  OD1 ASN E   2       8.296  70.753   7.881  1.00 69.34           O  
ATOM   5724  ND2 ASN E   2       6.103  70.261   8.313  1.00 66.82           N  
ATOM   5725  N   ALA E   3       3.406  72.485   7.434  1.00 55.12           N  
ATOM   5726  CA  ALA E   3       2.412  73.254   8.180  1.00 50.47           C  
ATOM   5727  C   ALA E   3       3.111  74.123   9.281  1.00 45.98           C  
ATOM   5728  O   ALA E   3       2.617  75.176   9.660  1.00 45.67           O  
ATOM   5729  CB  ALA E   3       1.390  72.340   8.760  1.00 47.66           C  
ATOM   5730  N   GLN E   4       4.261  73.698   9.762  1.00 43.97           N  
ATOM   5731  CA  GLN E   4       4.991  74.462  10.790  1.00 45.03           C  
ATOM   5732  C   GLN E   4       5.422  75.849  10.259  1.00 40.88           C  
ATOM   5733  O   GLN E   4       5.315  76.889  10.937  1.00 38.24           O  
ATOM   5734  CB  GLN E   4       6.232  73.687  11.213  1.00 46.89           C  
ATOM   5735  CG  GLN E   4       6.005  72.586  12.214  1.00 50.62           C  
ATOM   5736  CD  GLN E   4       7.321  71.913  12.570  1.00 53.67           C  
ATOM   5737  OE1 GLN E   4       7.955  72.196  13.613  1.00 57.21           O  
ATOM   5738  NE2 GLN E   4       7.783  71.052  11.664  1.00 58.39           N  
ATOM   5739  N   ALA E   5       5.898  75.823   9.024  1.00 38.18           N  
ATOM   5740  CA  ALA E   5       6.299  77.001   8.285  1.00 39.93           C  
ATOM   5741  C   ALA E   5       5.170  77.957   8.101  1.00 37.81           C  
ATOM   5742  O   ALA E   5       5.358  79.146   8.298  1.00 34.65           O  
ATOM   5743  CB  ALA E   5       6.862  76.606   6.876  1.00 41.11           C  
ATOM   5744  N   GLU E   6       3.997  77.445   7.704  1.00 43.59           N  
ATOM   5745  CA  GLU E   6       2.820  78.305   7.408  1.00 43.90           C  
ATOM   5746  C   GLU E   6       2.295  78.883   8.712  1.00 40.78           C  
ATOM   5747  O   GLU E   6       1.915  80.045   8.784  1.00 36.90           O  
ATOM   5748  CB  GLU E   6       1.707  77.504   6.673  1.00 48.84           C  
ATOM   5749  CG  GLU E   6       0.970  78.300   5.525  1.00 54.45           C  
ATOM   5750  CD  GLU E   6      -0.149  79.266   6.038  1.00 59.84           C  
ATOM   5751  OE1 GLU E   6      -1.104  78.803   6.719  1.00 64.51           O  
ATOM   5752  OE2 GLU E   6      -0.098  80.488   5.738  1.00 62.04           O  
ATOM   5753  N   GLU E   7       2.272  78.059   9.756  1.00 39.75           N  
ATOM   5754  CA  GLU E   7       1.998  78.583  11.119  1.00 42.89           C  
ATOM   5755  C   GLU E   7       2.922  79.709  11.568  1.00 37.52           C  
ATOM   5756  O   GLU E   7       2.461  80.595  12.214  1.00 35.35           O  
ATOM   5757  CB  GLU E   7       2.084  77.475  12.172  1.00 43.98           C  
ATOM   5758  CG  GLU E   7       0.984  76.429  12.089  1.00 49.08           C  
ATOM   5759  CD  GLU E   7       1.329  75.144  12.865  1.00 51.98           C  
ATOM   5760  OE1 GLU E   7       2.322  75.143  13.692  1.00 57.66           O  
ATOM   5761  OE2 GLU E   7       0.595  74.139  12.648  1.00 55.96           O  
ATOM   5762  N   PHE E   8       4.234  79.620  11.268  1.00 36.98           N  
ATOM   5763  CA  PHE E   8       5.240  80.625  11.694  1.00 33.76           C  
ATOM   5764  C   PHE E   8       4.952  81.959  10.986  1.00 35.07           C  
ATOM   5765  O   PHE E   8       4.988  83.062  11.615  1.00 31.76           O  
ATOM   5766  CB  PHE E   8       6.660  80.097  11.399  1.00 35.19           C  
ATOM   5767  CG  PHE E   8       7.790  80.960  11.939  1.00 36.41           C  
ATOM   5768  CD1 PHE E   8       7.786  81.438  13.247  1.00 35.32           C  
ATOM   5769  CD2 PHE E   8       8.864  81.281  11.139  1.00 37.52           C  
ATOM   5770  CE1 PHE E   8       8.779  82.230  13.710  1.00 36.94           C  
ATOM   5771  CE2 PHE E   8       9.900  82.085  11.622  1.00 37.77           C  
ATOM   5772  CZ  PHE E   8       9.850  82.547  12.915  1.00 36.60           C  
ATOM   5773  N   LYS E   9       4.625  81.843   9.697  1.00 32.32           N  
ATOM   5774  CA  LYS E   9       4.258  82.959   8.863  1.00 37.36           C  
ATOM   5775  C   LYS E   9       3.065  83.740   9.457  1.00 39.64           C  
ATOM   5776  O   LYS E   9       3.210  84.940   9.765  1.00 38.80           O  
ATOM   5777  CB  LYS E   9       3.851  82.434   7.465  1.00 39.36           C  
ATOM   5778  CG  LYS E   9       3.596  83.524   6.465  1.00 39.21           C  
ATOM   5779  CD  LYS E   9       2.949  83.047   5.224  1.00 42.15           C  
ATOM   5780  CE  LYS E   9       1.450  83.356   5.211  1.00 44.00           C  
ATOM   5781  NZ  LYS E   9       0.903  82.990   3.895  1.00 45.06           N  
ATOM   5782  N   LYS E  10       1.907  83.062   9.602  1.00 37.33           N  
ATOM   5783  CA  LYS E  10       0.776  83.621  10.346  1.00 41.92           C  
ATOM   5784  C   LYS E  10       1.201  84.234  11.689  1.00 40.36           C  
ATOM   5785  O   LYS E  10       0.775  85.338  12.026  1.00 41.85           O  
ATOM   5786  CB  LYS E  10      -0.341  82.582  10.573  1.00 45.03           C  
ATOM   5787  CG  LYS E  10      -1.497  82.669   9.494  1.00 47.59           C  
ATOM   5788  CD  LYS E  10      -2.588  81.567   9.612  1.00 47.64           C  
ATOM   5789  CE  LYS E  10      -4.023  81.972   8.993  1.00 49.80           C  
ATOM   5790  NZ  LYS E  10      -3.970  82.784   7.710  1.00 49.48           N  
ATOM   5791  N   TYR E  11       2.052  83.545  12.448  1.00 37.45           N  
ATOM   5792  CA  TYR E  11       2.515  84.107  13.736  1.00 35.73           C  
ATOM   5793  C   TYR E  11       3.198  85.446  13.541  1.00 34.34           C  
ATOM   5794  O   TYR E  11       2.819  86.443  14.137  1.00 37.03           O  
ATOM   5795  CB  TYR E  11       3.422  83.143  14.461  1.00 34.04           C  
ATOM   5796  CG  TYR E  11       3.949  83.651  15.823  1.00 34.73           C  
ATOM   5797  CD1 TYR E  11       3.099  83.861  16.909  1.00 32.17           C  
ATOM   5798  CD2 TYR E  11       5.302  83.897  16.005  1.00 34.05           C  
ATOM   5799  CE1 TYR E  11       3.607  84.312  18.159  1.00 33.78           C  
ATOM   5800  CE2 TYR E  11       5.821  84.356  17.253  1.00 35.88           C  
ATOM   5801  CZ  TYR E  11       4.951  84.560  18.316  1.00 33.54           C  
ATOM   5802  OH  TYR E  11       5.474  84.979  19.502  1.00 34.55           O  
ATOM   5803  N   LEU E  12       4.177  85.477  12.659  1.00 34.75           N  
ATOM   5804  CA  LEU E  12       4.826  86.719  12.289  1.00 35.64           C  
ATOM   5805  C   LEU E  12       3.908  87.834  11.876  1.00 38.40           C  
ATOM   5806  O   LEU E  12       4.134  88.986  12.281  1.00 37.80           O  
ATOM   5807  CB  LEU E  12       5.818  86.471  11.157  1.00 36.71           C  
ATOM   5808  CG  LEU E  12       6.988  85.580  11.600  1.00 38.60           C  
ATOM   5809  CD1 LEU E  12       7.961  85.317  10.432  1.00 40.39           C  
ATOM   5810  CD2 LEU E  12       7.692  86.206  12.783  1.00 38.07           C  
ATOM   5811  N   GLU E  13       2.905  87.502  11.036  1.00 38.18           N  
ATOM   5812  CA  GLU E  13       1.970  88.469  10.522  1.00 37.85           C  
ATOM   5813  C   GLU E  13       1.024  89.017  11.606  1.00 40.10           C  
ATOM   5814  O   GLU E  13       0.715  90.216  11.608  1.00 35.74           O  
ATOM   5815  CB  GLU E  13       1.144  87.873   9.363  1.00 37.70           C  
ATOM   5816  CG  GLU E  13       1.950  87.784   8.104  1.00 40.28           C  
ATOM   5817  CD  GLU E  13       1.161  87.352   6.876  1.00 41.73           C  
ATOM   5818  OE1 GLU E  13      -0.033  86.967   6.978  1.00 45.45           O  
ATOM   5819  OE2 GLU E  13       1.758  87.421   5.788  1.00 45.35           O  
ATOM   5820  N   THR E  14       0.564  88.144  12.502  1.00 42.30           N  
ATOM   5821  CA  THR E  14      -0.256  88.577  13.641  1.00 45.49           C  
ATOM   5822  C   THR E  14       0.533  89.537  14.533  1.00 45.34           C  
ATOM   5823  O   THR E  14      -0.051  90.450  15.122  1.00 46.02           O  
ATOM   5824  CB  THR E  14      -0.780  87.406  14.513  1.00 48.06           C  
ATOM   5825  OG1 THR E  14      -1.368  86.389  13.693  1.00 47.70           O  
ATOM   5826  CG2 THR E  14      -1.874  87.905  15.462  1.00 49.83           C  
ATOM   5827  N   ASN E  15       1.853  89.349  14.614  1.00 41.63           N  
ATOM   5828  CA  ASN E  15       2.717  90.224  15.407  1.00 40.09           C  
ATOM   5829  C   ASN E  15       3.317  91.357  14.603  1.00 43.43           C  
ATOM   5830  O   ASN E  15       4.343  91.899  14.985  1.00 42.35           O  
ATOM   5831  CB  ASN E  15       3.808  89.401  16.078  1.00 39.28           C  
ATOM   5832  CG  ASN E  15       3.230  88.496  17.146  1.00 39.91           C  
ATOM   5833  OD1 ASN E  15       2.840  87.355  16.884  1.00 39.33           O  
ATOM   5834  ND2 ASN E  15       3.099  89.035  18.344  1.00 36.28           N  
ATOM   5835  N   GLY E  16       2.674  91.723  13.483  1.00 46.41           N  
ATOM   5836  CA  GLY E  16       3.073  92.927  12.727  1.00 47.83           C  
ATOM   5837  C   GLY E  16       4.432  92.906  12.003  1.00 48.86           C  
ATOM   5838  O   GLY E  16       4.989  93.956  11.752  1.00 50.85           O  
ATOM   5839  N   ILE E  17       4.964  91.728  11.662  1.00 49.44           N  
ATOM   5840  CA  ILE E  17       6.074  91.616  10.686  1.00 49.49           C  
ATOM   5841  C   ILE E  17       5.454  91.468   9.299  1.00 47.54           C  
ATOM   5842  O   ILE E  17       4.692  90.542   9.066  1.00 49.62           O  
ATOM   5843  CB  ILE E  17       7.031  90.380  10.933  1.00 48.83           C  
ATOM   5844  CG1 ILE E  17       7.313  90.123  12.420  1.00 49.43           C  
ATOM   5845  CG2 ILE E  17       8.304  90.565  10.144  1.00 49.41           C  
ATOM   5846  CD1 ILE E  17       7.839  91.330  13.197  1.00 50.80           C  
ATOM   5847  N   LYS E  18       5.763  92.360   8.374  1.00 48.18           N  
ATOM   5848  CA  LYS E  18       5.068  92.347   7.069  1.00 49.51           C  
ATOM   5849  C   LYS E  18       5.931  91.623   6.067  1.00 46.94           C  
ATOM   5850  O   LYS E  18       7.135  91.779   6.131  1.00 41.54           O  
ATOM   5851  CB  LYS E  18       4.805  93.779   6.548  1.00 53.47           C  
ATOM   5852  CG  LYS E  18       3.504  94.442   7.065  1.00 56.91           C  
ATOM   5853  CD  LYS E  18       2.192  93.825   6.482  1.00 58.87           C  
ATOM   5854  CE  LYS E  18       2.074  93.845   4.906  1.00 61.11           C  
ATOM   5855  NZ  LYS E  18       1.912  95.208   4.242  1.00 62.40           N  
ATOM   5856  N   PRO E  19       5.311  90.874   5.106  1.00 43.27           N  
ATOM   5857  CA  PRO E  19       6.090  90.216   4.074  1.00 41.72           C  
ATOM   5858  C   PRO E  19       6.682  91.187   3.055  1.00 41.97           C  
ATOM   5859  O   PRO E  19       6.011  92.141   2.686  1.00 40.48           O  
ATOM   5860  CB  PRO E  19       5.077  89.312   3.386  1.00 42.22           C  
ATOM   5861  CG  PRO E  19       3.727  89.981   3.647  1.00 42.69           C  
ATOM   5862  CD  PRO E  19       3.866  90.634   4.965  1.00 42.03           C  
ATOM   5863  N   LYS E  20       7.909  90.914   2.597  1.00 39.62           N  
ATOM   5864  CA  LYS E  20       8.552  91.693   1.541  1.00 40.67           C  
ATOM   5865  C   LYS E  20       8.789  90.859   0.302  1.00 39.67           C  
ATOM   5866  O   LYS E  20       9.293  89.744   0.385  1.00 34.26           O  
ATOM   5867  CB  LYS E  20       9.887  92.261   2.001  1.00 43.77           C  
ATOM   5868  CG  LYS E  20       9.732  93.353   3.063  1.00 48.99           C  
ATOM   5869  CD  LYS E  20      10.985  93.479   3.927  1.00 52.16           C  
ATOM   5870  CE  LYS E  20      11.044  94.797   4.687  1.00 54.68           C  
ATOM   5871  NZ  LYS E  20      12.436  95.371   4.678  1.00 57.44           N  
ATOM   5872  N   GLN E  21       8.412  91.436  -0.845  1.00 39.63           N  
ATOM   5873  CA  GLN E  21       8.701  90.897  -2.157  1.00 40.93           C  
ATOM   5874  C   GLN E  21      10.049  91.404  -2.675  1.00 38.08           C  
ATOM   5875  O   GLN E  21      10.374  92.568  -2.545  1.00 41.27           O  
ATOM   5876  CB  GLN E  21       7.620  91.303  -3.175  1.00 42.16           C  
ATOM   5877  CG  GLN E  21       6.181  91.259  -2.667  1.00 44.17           C  
ATOM   5878  CD  GLN E  21       5.809  89.900  -2.099  1.00 46.88           C  
ATOM   5879  OE1 GLN E  21       5.176  89.812  -1.034  1.00 48.17           O  
ATOM   5880  NE2 GLN E  21       6.212  88.833  -2.797  1.00 45.72           N  
ATOM   5881  N   PHE E  22      10.782  90.506  -3.299  1.00 35.87           N  
ATOM   5882  CA  PHE E  22      12.033  90.767  -3.972  1.00 37.26           C  
ATOM   5883  C   PHE E  22      11.989  90.186  -5.378  1.00 41.69           C  
ATOM   5884  O   PHE E  22      11.138  89.321  -5.718  1.00 45.09           O  
ATOM   5885  CB  PHE E  22      13.168  90.114  -3.189  1.00 34.52           C  
ATOM   5886  CG  PHE E  22      13.345  90.690  -1.866  1.00 32.50           C  
ATOM   5887  CD1 PHE E  22      12.579  90.232  -0.776  1.00 35.83           C  
ATOM   5888  CD2 PHE E  22      14.257  91.717  -1.663  1.00 30.86           C  
ATOM   5889  CE1 PHE E  22      12.745  90.813   0.526  1.00 31.98           C  
ATOM   5890  CE2 PHE E  22      14.426  92.269  -0.393  1.00 31.47           C  
ATOM   5891  CZ  PHE E  22      13.661  91.831   0.684  1.00 32.93           C  
ATOM   5892  N   HIS E  23      12.885  90.688  -6.209  1.00 44.13           N  
ATOM   5893  CA  HIS E  23      12.971  90.276  -7.606  1.00 45.88           C  
ATOM   5894  C   HIS E  23      14.358  89.739  -7.859  1.00 42.13           C  
ATOM   5895  O   HIS E  23      15.307  90.012  -7.085  1.00 38.52           O  
ATOM   5896  CB  HIS E  23      12.632  91.470  -8.545  1.00 52.68           C  
ATOM   5897  CG  HIS E  23      11.469  92.279  -8.060  1.00 56.13           C  
ATOM   5898  ND1 HIS E  23      10.159  91.929  -8.317  1.00 59.53           N  
ATOM   5899  CD2 HIS E  23      11.415  93.373  -7.261  1.00 57.25           C  
ATOM   5900  CE1 HIS E  23       9.348  92.788  -7.723  1.00 59.54           C  
ATOM   5901  NE2 HIS E  23      10.086  93.676  -7.077  1.00 58.57           N  
ATOM   5902  N   LYS E  24      14.455  88.954  -8.930  1.00 41.27           N  
ATOM   5903  CA  LYS E  24      15.739  88.380  -9.407  1.00 42.49           C  
ATOM   5904  C   LYS E  24      16.922  89.392  -9.384  1.00 41.19           C  
ATOM   5905  O   LYS E  24      16.774  90.527  -9.878  1.00 44.60           O  
ATOM   5906  CB  LYS E  24      15.558  87.781 -10.805  1.00 43.78           C  
ATOM   5907  CG  LYS E  24      16.860  87.475 -11.485  1.00 47.56           C  
ATOM   5908  CD  LYS E  24      16.850  86.208 -12.273  1.00 52.19           C  
ATOM   5909  CE  LYS E  24      15.901  86.236 -13.439  1.00 55.15           C  
ATOM   5910  NZ  LYS E  24      15.520  84.805 -13.709  1.00 56.69           N  
ATOM   5911  N   LYS E  25      18.058  88.985  -8.791  1.00 38.62           N  
ATOM   5912  CA  LYS E  25      19.261  89.852  -8.543  1.00 40.32           C  
ATOM   5913  C   LYS E  25      19.270  90.730  -7.322  1.00 38.53           C  
ATOM   5914  O   LYS E  25      20.363  91.103  -6.843  1.00 37.75           O  
ATOM   5915  CB  LYS E  25      19.652  90.751  -9.738  1.00 46.51           C  
ATOM   5916  CG  LYS E  25      20.602  90.127 -10.698  1.00 51.29           C  
ATOM   5917  CD  LYS E  25      19.899  89.008 -11.445  1.00 55.32           C  
ATOM   5918  CE  LYS E  25      20.782  88.455 -12.578  1.00 58.32           C  
ATOM   5919  NZ  LYS E  25      21.553  87.236 -12.144  1.00 59.43           N  
ATOM   5920  N   GLU E  26      18.101  91.098  -6.794  1.00 39.18           N  
ATOM   5921  CA  GLU E  26      18.081  91.837  -5.541  1.00 38.69           C  
ATOM   5922  C   GLU E  26      18.748  91.039  -4.388  1.00 38.16           C  
ATOM   5923  O   GLU E  26      18.656  89.823  -4.308  1.00 38.19           O  
ATOM   5924  CB  GLU E  26      16.656  92.234  -5.154  1.00 40.97           C  
ATOM   5925  CG  GLU E  26      15.984  93.118  -6.255  1.00 42.90           C  
ATOM   5926  CD  GLU E  26      14.709  93.810  -5.783  1.00 38.87           C  
ATOM   5927  OE1 GLU E  26      13.872  93.137  -5.183  1.00 34.90           O  
ATOM   5928  OE2 GLU E  26      14.571  95.026  -6.014  1.00 37.94           O  
ATOM   5929  N   LEU E  27      19.400  91.779  -3.502  1.00 36.66           N  
ATOM   5930  CA  LEU E  27      19.999  91.296  -2.289  1.00 35.61           C  
ATOM   5931  C   LEU E  27      19.000  91.460  -1.169  1.00 38.98           C  
ATOM   5932  O   LEU E  27      18.466  92.545  -0.992  1.00 39.92           O  
ATOM   5933  CB  LEU E  27      21.257  92.141  -1.972  1.00 34.77           C  
ATOM   5934  CG  LEU E  27      22.616  91.539  -2.374  1.00 38.64           C  
ATOM   5935  CD1 LEU E  27      22.570  90.809  -3.745  1.00 37.14           C  
ATOM   5936  CD2 LEU E  27      23.788  92.591  -2.257  1.00 37.16           C  
ATOM   5937  N   ILE E  28      18.737  90.401  -0.395  1.00 42.23           N  
ATOM   5938  CA  ILE E  28      17.884  90.541   0.829  1.00 39.11           C  
ATOM   5939  C   ILE E  28      18.669  91.203   1.998  1.00 38.11           C  
ATOM   5940  O   ILE E  28      18.094  91.934   2.794  1.00 36.62           O  
ATOM   5941  CB  ILE E  28      17.324  89.181   1.278  1.00 37.33           C  
ATOM   5942  CG1 ILE E  28      16.298  88.707   0.248  1.00 38.92           C  
ATOM   5943  CG2 ILE E  28      16.708  89.281   2.706  1.00 37.96           C  
ATOM   5944  CD1 ILE E  28      15.672  87.349   0.544  1.00 38.09           C  
ATOM   5945  N   PHE E  29      19.974  90.901   2.090  1.00 37.29           N  
ATOM   5946  CA  PHE E  29      20.947  91.613   2.949  1.00 33.64           C  
ATOM   5947  C   PHE E  29      22.322  91.484   2.289  1.00 33.69           C  
ATOM   5948  O   PHE E  29      22.505  90.621   1.415  1.00 33.37           O  
ATOM   5949  CB  PHE E  29      20.951  91.102   4.423  1.00 35.81           C  
ATOM   5950  CG  PHE E  29      21.425  89.668   4.622  1.00 36.63           C  
ATOM   5951  CD1 PHE E  29      22.779  89.321   4.510  1.00 36.85           C  
ATOM   5952  CD2 PHE E  29      20.509  88.660   4.983  1.00 38.73           C  
ATOM   5953  CE1 PHE E  29      23.193  88.031   4.697  1.00 36.39           C  
ATOM   5954  CE2 PHE E  29      20.911  87.355   5.199  1.00 36.01           C  
ATOM   5955  CZ  PHE E  29      22.256  87.019   5.038  1.00 36.24           C  
ATOM   5956  N   ASN E  30      23.282  92.323   2.706  1.00 35.17           N  
ATOM   5957  CA  ASN E  30      24.591  92.454   2.054  1.00 34.10           C  
ATOM   5958  C   ASN E  30      25.733  92.350   3.053  1.00 34.27           C  
ATOM   5959  O   ASN E  30      25.526  92.586   4.251  1.00 34.84           O  
ATOM   5960  CB  ASN E  30      24.714  93.775   1.211  1.00 36.25           C  
ATOM   5961  CG  ASN E  30      24.832  95.049   2.060  1.00 36.87           C  
ATOM   5962  OD1 ASN E  30      25.781  95.235   2.830  1.00 36.80           O  
ATOM   5963  ND2 ASN E  30      23.859  95.942   1.899  1.00 36.96           N  
ATOM   5964  N   GLN E  31      26.939  92.024   2.568  1.00 31.55           N  
ATOM   5965  CA  GLN E  31      28.057  91.703   3.520  1.00 35.45           C  
ATOM   5966  C   GLN E  31      28.670  92.927   4.280  1.00 33.99           C  
ATOM   5967  O   GLN E  31      29.443  92.720   5.175  1.00 32.28           O  
ATOM   5968  CB  GLN E  31      29.148  90.886   2.833  1.00 34.05           C  
ATOM   5969  CG  GLN E  31      29.957  91.677   1.786  1.00 35.43           C  
ATOM   5970  CD  GLN E  31      31.000  90.814   1.114  1.00 35.96           C  
ATOM   5971  OE1 GLN E  31      32.216  91.000   1.328  1.00 36.49           O  
ATOM   5972  NE2 GLN E  31      30.546  89.860   0.310  1.00 33.40           N  
ATOM   5973  N   TRP E  32      28.294  94.169   3.931  1.00 33.36           N  
ATOM   5974  CA  TRP E  32      28.815  95.349   4.592  1.00 35.21           C  
ATOM   5975  C   TRP E  32      27.915  95.817   5.721  1.00 37.52           C  
ATOM   5976  O   TRP E  32      28.362  96.577   6.575  1.00 37.19           O  
ATOM   5977  CB  TRP E  32      29.089  96.477   3.561  1.00 36.08           C  
ATOM   5978  CG  TRP E  32      30.072  96.009   2.582  1.00 36.60           C  
ATOM   5979  CD1 TRP E  32      31.414  95.879   2.773  1.00 37.31           C  
ATOM   5980  CD2 TRP E  32      29.789  95.448   1.282  1.00 36.62           C  
ATOM   5981  NE1 TRP E  32      31.997  95.306   1.652  1.00 37.55           N  
ATOM   5982  CE2 TRP E  32      31.025  95.043   0.723  1.00 36.95           C  
ATOM   5983  CE3 TRP E  32      28.610  95.262   0.543  1.00 36.07           C  
ATOM   5984  CZ2 TRP E  32      31.128  94.448  -0.570  1.00 37.97           C  
ATOM   5985  CZ3 TRP E  32      28.687  94.692  -0.720  1.00 37.21           C  
ATOM   5986  CH2 TRP E  32      29.955  94.280  -1.276  1.00 38.80           C  
ATOM   5987  N   ASP E  33      26.667  95.354   5.751  1.00 40.08           N  
ATOM   5988  CA  ASP E  33      25.670  95.847   6.732  1.00 43.36           C  
ATOM   5989  C   ASP E  33      25.996  95.423   8.165  1.00 44.54           C  
ATOM   5990  O   ASP E  33      25.997  94.230   8.482  1.00 44.67           O  
ATOM   5991  CB  ASP E  33      24.245  95.402   6.315  1.00 46.36           C  
ATOM   5992  CG  ASP E  33      23.124  96.138   7.081  1.00 49.57           C  
ATOM   5993  OD1 ASP E  33      23.424  96.911   8.041  1.00 50.44           O  
ATOM   5994  OD2 ASP E  33      21.934  95.924   6.712  1.00 48.81           O  
ATOM   5995  N   PRO E  34      26.307  96.400   9.042  1.00 50.97           N  
ATOM   5996  CA  PRO E  34      26.556  96.019  10.449  1.00 53.73           C  
ATOM   5997  C   PRO E  34      25.273  95.511  11.172  1.00 56.51           C  
ATOM   5998  O   PRO E  34      25.356  94.558  11.964  1.00 57.45           O  
ATOM   5999  CB  PRO E  34      27.114  97.303  11.088  1.00 53.01           C  
ATOM   6000  CG  PRO E  34      26.803  98.430  10.162  1.00 51.85           C  
ATOM   6001  CD  PRO E  34      26.441  97.862   8.810  1.00 51.52           C  
ATOM   6002  N   GLN E  35      24.104  96.086  10.869  1.00 56.51           N  
ATOM   6003  CA  GLN E  35      22.847  95.553  11.437  1.00 58.54           C  
ATOM   6004  C   GLN E  35      22.598  94.067  11.097  1.00 58.71           C  
ATOM   6005  O   GLN E  35      22.674  93.645   9.920  1.00 62.31           O  
ATOM   6006  CB  GLN E  35      21.643  96.379  11.018  1.00 59.12           C  
ATOM   6007  CG  GLN E  35      20.307  95.742  11.423  1.00 60.53           C  
ATOM   6008  CD  GLN E  35      20.025  95.870  12.907  1.00 60.77           C  
ATOM   6009  OE1 GLN E  35      19.929  96.996  13.410  1.00 62.35           O  
ATOM   6010  NE2 GLN E  35      19.880  94.734  13.615  1.00 56.01           N  
ATOM   6011  N   GLU E  36      22.289  93.297  12.139  1.00 56.23           N  
ATOM   6012  CA  GLU E  36      22.038  91.855  12.039  1.00 54.77           C  
ATOM   6013  C   GLU E  36      20.522  91.432  11.960  1.00 50.47           C  
ATOM   6014  O   GLU E  36      19.635  92.042  12.565  1.00 43.36           O  
ATOM   6015  CB  GLU E  36      22.708  91.159  13.213  1.00 58.01           C  
ATOM   6016  CG  GLU E  36      24.236  91.463  13.319  1.00 61.54           C  
ATOM   6017  CD  GLU E  36      24.554  92.762  14.095  1.00 66.33           C  
ATOM   6018  OE1 GLU E  36      23.577  93.504  14.421  1.00 69.09           O  
ATOM   6019  OE2 GLU E  36      25.772  93.041  14.387  1.00 68.28           O  
ATOM   6020  N   TYR E  37      20.274  90.355  11.218  1.00 46.66           N  
ATOM   6021  CA  TYR E  37      18.938  89.913  10.854  1.00 45.16           C  
ATOM   6022  C   TYR E  37      18.747  88.427  11.017  1.00 42.04           C  
ATOM   6023  O   TYR E  37      19.685  87.620  10.907  1.00 37.59           O  
ATOM   6024  CB  TYR E  37      18.638  90.228   9.387  1.00 45.28           C  
ATOM   6025  CG  TYR E  37      18.737  91.671   9.029  1.00 46.30           C  
ATOM   6026  CD1 TYR E  37      17.726  92.585   9.396  1.00 45.74           C  
ATOM   6027  CD2 TYR E  37      19.844  92.140   8.290  1.00 46.39           C  
ATOM   6028  CE1 TYR E  37      17.837  93.919   9.054  1.00 45.56           C  
ATOM   6029  CE2 TYR E  37      19.953  93.459   7.948  1.00 47.05           C  
ATOM   6030  CZ  TYR E  37      18.955  94.337   8.327  1.00 45.90           C  
ATOM   6031  OH  TYR E  37      19.096  95.626   7.945  1.00 48.42           O  
ATOM   6032  N   CYS E  38      17.491  88.086  11.239  1.00 41.48           N  
ATOM   6033  CA  CYS E  38      16.995  86.759  10.957  1.00 41.78           C  
ATOM   6034  C   CYS E  38      15.977  86.904   9.790  1.00 39.12           C  
ATOM   6035  O   CYS E  38      15.022  87.693   9.856  1.00 40.77           O  
ATOM   6036  CB  CYS E  38      16.407  86.135  12.242  1.00 44.21           C  
ATOM   6037  SG  CYS E  38      15.292  84.752  11.992  1.00 46.26           S  
ATOM   6038  N   ILE E  39      16.236  86.156   8.723  1.00 37.65           N  
ATOM   6039  CA  ILE E  39      15.420  86.117   7.533  1.00 35.92           C  
ATOM   6040  C   ILE E  39      14.635  84.816   7.531  1.00 37.11           C  
ATOM   6041  O   ILE E  39      15.201  83.736   7.553  1.00 35.08           O  
ATOM   6042  CB  ILE E  39      16.295  86.173   6.240  1.00 34.47           C  
ATOM   6043  CG1 ILE E  39      17.262  87.357   6.266  1.00 34.07           C  
ATOM   6044  CG2 ILE E  39      15.433  86.227   4.946  1.00 33.49           C  
ATOM   6045  CD1 ILE E  39      16.630  88.675   6.543  1.00 35.24           C  
ATOM   6046  N   PHE E  40      13.314  84.938   7.536  1.00 37.93           N  
ATOM   6047  CA  PHE E  40      12.445  83.825   7.190  1.00 37.83           C  
ATOM   6048  C   PHE E  40      12.124  83.896   5.701  1.00 34.48           C  
ATOM   6049  O   PHE E  40      11.274  84.684   5.290  1.00 33.21           O  
ATOM   6050  CB  PHE E  40      11.159  83.893   8.005  1.00 37.22           C  
ATOM   6051  CG  PHE E  40      10.258  82.723   7.811  1.00 36.69           C  
ATOM   6052  CD1 PHE E  40      10.709  81.447   8.037  1.00 35.89           C  
ATOM   6053  CD2 PHE E  40       8.926  82.903   7.401  1.00 38.90           C  
ATOM   6054  CE1 PHE E  40       9.851  80.352   7.858  1.00 38.51           C  
ATOM   6055  CE2 PHE E  40       8.060  81.813   7.236  1.00 37.26           C  
ATOM   6056  CZ  PHE E  40       8.514  80.548   7.459  1.00 36.82           C  
ATOM   6057  N   LEU E  41      12.809  83.081   4.906  1.00 31.44           N  
ATOM   6058  CA  LEU E  41      12.479  82.940   3.515  1.00 31.16           C  
ATOM   6059  C   LEU E  41      11.309  81.998   3.364  1.00 33.97           C  
ATOM   6060  O   LEU E  41      11.424  80.810   3.629  1.00 32.27           O  
ATOM   6061  CB  LEU E  41      13.616  82.390   2.717  1.00 32.99           C  
ATOM   6062  CG  LEU E  41      13.490  82.258   1.206  1.00 31.19           C  
ATOM   6063  CD1 LEU E  41      13.309  83.578   0.556  1.00 30.44           C  
ATOM   6064  CD2 LEU E  41      14.776  81.561   0.643  1.00 33.37           C  
ATOM   6065  N   TYR E  42      10.196  82.544   2.884  1.00 35.49           N  
ATOM   6066  CA  TYR E  42       8.981  81.800   2.748  1.00 38.12           C  
ATOM   6067  C   TYR E  42       8.854  81.172   1.371  1.00 40.69           C  
ATOM   6068  O   TYR E  42       8.678  79.979   1.273  1.00 44.58           O  
ATOM   6069  CB  TYR E  42       7.792  82.712   3.068  1.00 40.88           C  
ATOM   6070  CG  TYR E  42       6.467  82.006   2.937  1.00 42.38           C  
ATOM   6071  CD1 TYR E  42       6.086  81.029   3.855  1.00 40.65           C  
ATOM   6072  CD2 TYR E  42       5.610  82.311   1.889  1.00 42.34           C  
ATOM   6073  CE1 TYR E  42       4.906  80.380   3.748  1.00 40.89           C  
ATOM   6074  CE2 TYR E  42       4.424  81.655   1.757  1.00 43.15           C  
ATOM   6075  CZ  TYR E  42       4.080  80.686   2.688  1.00 43.32           C  
ATOM   6076  OH  TYR E  42       2.874  80.064   2.571  1.00 45.42           O  
ATOM   6077  N   ASP E  43       8.965  81.958   0.309  1.00 40.26           N  
ATOM   6078  CA  ASP E  43       8.743  81.455  -1.040  1.00 41.22           C  
ATOM   6079  C   ASP E  43       9.878  81.956  -1.922  1.00 35.74           C  
ATOM   6080  O   ASP E  43      10.189  83.108  -1.864  1.00 34.78           O  
ATOM   6081  CB  ASP E  43       7.378  81.982  -1.575  1.00 45.85           C  
ATOM   6082  CG  ASP E  43       7.173  81.707  -3.076  1.00 51.81           C  
ATOM   6083  OD1 ASP E  43       7.221  80.519  -3.493  1.00 55.18           O  
ATOM   6084  OD2 ASP E  43       6.952  82.680  -3.861  1.00 57.59           O  
ATOM   6085  N   GLY E  44      10.475  81.108  -2.743  1.00 33.09           N  
ATOM   6086  CA  GLY E  44      11.543  81.562  -3.651  1.00 35.82           C  
ATOM   6087  C   GLY E  44      12.897  80.882  -3.455  1.00 36.33           C  
ATOM   6088  O   GLY E  44      13.080  80.070  -2.562  1.00 39.72           O  
ATOM   6089  N   ILE E  45      13.837  81.227  -4.309  1.00 35.54           N  
ATOM   6090  CA  ILE E  45      15.145  80.585  -4.332  1.00 38.25           C  
ATOM   6091  C   ILE E  45      16.263  81.611  -4.229  1.00 37.55           C  
ATOM   6092  O   ILE E  45      16.252  82.576  -4.987  1.00 35.19           O  
ATOM   6093  CB  ILE E  45      15.346  79.802  -5.688  1.00 37.84           C  
ATOM   6094  CG1 ILE E  45      14.196  78.828  -5.915  1.00 34.83           C  
ATOM   6095  CG2 ILE E  45      16.726  79.085  -5.731  1.00 38.01           C  
ATOM   6096  CD1 ILE E  45      14.283  78.152  -7.342  1.00 37.97           C  
ATOM   6097  N   THR E  46      17.247  81.350  -3.344  1.00 37.30           N  
ATOM   6098  CA  THR E  46      18.322  82.307  -3.022  1.00 36.80           C  
ATOM   6099  C   THR E  46      19.694  81.639  -2.913  1.00 38.81           C  
ATOM   6100  O   THR E  46      19.806  80.391  -2.937  1.00 38.09           O  
ATOM   6101  CB  THR E  46      18.064  83.034  -1.695  1.00 36.94           C  
ATOM   6102  OG1 THR E  46      18.006  82.085  -0.640  1.00 38.41           O  
ATOM   6103  CG2 THR E  46      16.737  83.772  -1.729  1.00 39.79           C  
ATOM   6104  N   LYS E  47      20.742  82.471  -2.821  1.00 37.56           N  
ATOM   6105  CA  LYS E  47      22.111  81.976  -2.565  1.00 38.20           C  
ATOM   6106  C   LYS E  47      22.852  82.896  -1.593  1.00 37.43           C  
ATOM   6107  O   LYS E  47      22.723  84.142  -1.638  1.00 37.98           O  
ATOM   6108  CB  LYS E  47      22.948  81.789  -3.852  1.00 36.64           C  
ATOM   6109  CG  LYS E  47      23.118  83.076  -4.661  1.00 39.59           C  
ATOM   6110  CD  LYS E  47      24.137  82.946  -5.789  1.00 40.39           C  
ATOM   6111  CE  LYS E  47      23.909  84.021  -6.837  1.00 41.38           C  
ATOM   6112  NZ  LYS E  47      24.676  83.873  -8.086  1.00 40.97           N  
ATOM   6113  N   LEU E  48      23.626  82.253  -0.726  1.00 33.77           N  
ATOM   6114  CA  LEU E  48      24.479  82.929   0.230  1.00 33.06           C  
ATOM   6115  C   LEU E  48      25.909  83.009  -0.367  1.00 31.21           C  
ATOM   6116  O   LEU E  48      26.461  82.010  -0.744  1.00 28.96           O  
ATOM   6117  CB  LEU E  48      24.460  82.174   1.571  1.00 34.28           C  
ATOM   6118  CG  LEU E  48      25.031  83.001   2.762  1.00 37.86           C  
ATOM   6119  CD1 LEU E  48      24.029  83.990   3.340  1.00 34.60           C  
ATOM   6120  CD2 LEU E  48      25.531  82.065   3.863  1.00 37.86           C  
ATOM   6121  N   THR E  49      26.481  84.213  -0.425  1.00 31.75           N  
ATOM   6122  CA  THR E  49      27.730  84.460  -1.071  1.00 32.55           C  
ATOM   6123  C   THR E  49      28.660  85.264  -0.144  1.00 34.20           C  
ATOM   6124  O   THR E  49      28.196  85.867   0.845  1.00 33.47           O  
ATOM   6125  CB  THR E  49      27.542  85.254  -2.412  1.00 33.26           C  
ATOM   6126  OG1 THR E  49      27.145  86.587  -2.129  1.00 31.14           O  
ATOM   6127  CG2 THR E  49      26.478  84.633  -3.337  1.00 31.43           C  
ATOM   6128  N   SER E  50      29.952  85.229  -0.488  1.00 33.94           N  
ATOM   6129  CA  SER E  50      31.024  86.035   0.119  1.00 36.32           C  
ATOM   6130  C   SER E  50      32.031  86.484  -0.978  1.00 35.44           C  
ATOM   6131  O   SER E  50      32.443  85.728  -1.828  1.00 36.81           O  
ATOM   6132  CB  SER E  50      31.783  85.219   1.175  1.00 39.73           C  
ATOM   6133  OG  SER E  50      32.769  86.016   1.846  1.00 41.25           O  
ATOM   6134  N   ILE E  51      32.409  87.744  -0.940  1.00 37.35           N  
ATOM   6135  CA  ILE E  51      33.289  88.363  -1.907  1.00 34.84           C  
ATOM   6136  C   ILE E  51      34.510  88.780  -1.130  1.00 35.87           C  
ATOM   6137  O   ILE E  51      34.413  89.507  -0.148  1.00 35.50           O  
ATOM   6138  CB  ILE E  51      32.622  89.594  -2.609  1.00 36.22           C  
ATOM   6139  CG1 ILE E  51      31.250  89.197  -3.204  1.00 37.65           C  
ATOM   6140  CG2 ILE E  51      33.520  90.088  -3.757  1.00 34.82           C  
ATOM   6141  CD1 ILE E  51      30.383  90.364  -3.633  1.00 39.11           C  
ATOM   6142  N   SER E  52      35.660  88.335  -1.588  1.00 36.92           N  
ATOM   6143  CA  SER E  52      36.922  88.639  -0.935  1.00 40.94           C  
ATOM   6144  C   SER E  52      37.472  90.025  -1.349  1.00 40.82           C  
ATOM   6145  O   SER E  52      37.011  90.635  -2.316  1.00 39.67           O  
ATOM   6146  CB  SER E  52      37.941  87.566  -1.304  1.00 40.66           C  
ATOM   6147  OG  SER E  52      38.289  87.718  -2.686  1.00 42.41           O  
ATOM   6148  N   GLU E  53      38.461  90.499  -0.598  1.00 42.41           N  
ATOM   6149  CA  GLU E  53      39.160  91.741  -0.894  1.00 45.72           C  
ATOM   6150  C   GLU E  53      39.490  91.928  -2.393  1.00 43.89           C  
ATOM   6151  O   GLU E  53      39.392  93.059  -2.888  1.00 40.85           O  
ATOM   6152  CB  GLU E  53      40.473  91.822  -0.119  1.00 50.25           C  
ATOM   6153  CG  GLU E  53      40.581  93.020   0.813  1.00 55.12           C  
ATOM   6154  CD  GLU E  53      40.175  92.666   2.260  1.00 59.01           C  
ATOM   6155  OE1 GLU E  53      39.086  92.054   2.427  1.00 60.43           O  
ATOM   6156  OE2 GLU E  53      40.959  92.979   3.210  1.00 60.31           O  
ATOM   6157  N   ASN E  54      39.890  90.844  -3.086  1.00 40.85           N  
ATOM   6158  CA  ASN E  54      40.271  90.906  -4.502  1.00 39.88           C  
ATOM   6159  C   ASN E  54      39.130  90.658  -5.512  1.00 40.25           C  
ATOM   6160  O   ASN E  54      39.376  90.649  -6.752  1.00 36.73           O  
ATOM   6161  CB  ASN E  54      41.522  90.057  -4.813  1.00 39.11           C  
ATOM   6162  CG  ASN E  54      41.257  88.530  -4.873  1.00 41.82           C  
ATOM   6163  OD1 ASN E  54      42.174  87.774  -5.197  1.00 39.34           O  
ATOM   6164  ND2 ASN E  54      40.041  88.086  -4.560  1.00 40.11           N  
ATOM   6165  N   GLY E  55      37.902  90.503  -4.987  1.00 37.72           N  
ATOM   6166  CA  GLY E  55      36.706  90.366  -5.807  1.00 37.42           C  
ATOM   6167  C   GLY E  55      36.391  88.914  -6.106  1.00 40.72           C  
ATOM   6168  O   GLY E  55      35.521  88.625  -6.931  1.00 42.99           O  
ATOM   6169  N   THR E  56      37.082  87.993  -5.420  1.00 44.00           N  
ATOM   6170  CA  THR E  56      36.840  86.531  -5.560  1.00 43.28           C  
ATOM   6171  C   THR E  56      35.511  86.110  -4.918  1.00 40.74           C  
ATOM   6172  O   THR E  56      35.277  86.385  -3.745  1.00 38.18           O  
ATOM   6173  CB  THR E  56      38.011  85.678  -4.973  1.00 43.72           C  
ATOM   6174  OG1 THR E  56      39.231  86.018  -5.641  1.00 47.08           O  
ATOM   6175  CG2 THR E  56      37.783  84.168  -5.182  1.00 45.71           C  
ATOM   6176  N   ILE E  57      34.684  85.412  -5.710  1.00 40.27           N  
ATOM   6177  CA  ILE E  57      33.308  85.063  -5.356  1.00 41.16           C  
ATOM   6178  C   ILE E  57      33.154  83.591  -4.945  1.00 40.23           C  
ATOM   6179  O   ILE E  57      33.620  82.666  -5.634  1.00 38.74           O  
ATOM   6180  CB  ILE E  57      32.325  85.403  -6.478  1.00 44.02           C  
ATOM   6181  CG1 ILE E  57      32.372  86.894  -6.770  1.00 46.80           C  
ATOM   6182  CG2 ILE E  57      30.848  85.015  -6.077  1.00 44.64           C  
ATOM   6183  CD1 ILE E  57      31.764  87.257  -8.072  1.00 49.39           C  
ATOM   6184  N   MET E  58      32.524  83.413  -3.784  1.00 37.44           N  
ATOM   6185  CA  MET E  58      32.275  82.114  -3.178  1.00 39.57           C  
ATOM   6186  C   MET E  58      30.759  81.972  -3.047  1.00 37.83           C  
ATOM   6187  O   MET E  58      30.133  82.829  -2.382  1.00 30.66           O  
ATOM   6188  CB  MET E  58      32.895  82.079  -1.778  1.00 40.26           C  
ATOM   6189  CG  MET E  58      32.821  80.743  -1.077  1.00 43.15           C  
ATOM   6190  SD  MET E  58      33.773  79.388  -1.891  1.00 50.22           S  
ATOM   6191  CE  MET E  58      32.575  78.061  -1.693  1.00 45.90           C  
ATOM   6192  N   ASN E  59      30.193  80.934  -3.693  1.00 37.84           N  
ATOM   6193  CA  ASN E  59      28.795  80.475  -3.444  1.00 39.31           C  
ATOM   6194  C   ASN E  59      28.801  79.403  -2.327  1.00 39.52           C  
ATOM   6195  O   ASN E  59      29.207  78.251  -2.528  1.00 36.11           O  
ATOM   6196  CB  ASN E  59      28.131  79.888  -4.706  1.00 41.09           C  
ATOM   6197  CG  ASN E  59      27.787  80.941  -5.761  1.00 41.09           C  
ATOM   6198  OD1 ASN E  59      27.346  80.617  -6.863  1.00 42.99           O  
ATOM   6199  ND2 ASN E  59      28.029  82.170  -5.452  1.00 36.59           N  
ATOM   6200  N   LEU E  60      28.322  79.794  -1.152  1.00 40.18           N  
ATOM   6201  CA  LEU E  60      28.380  78.945   0.052  1.00 40.29           C  
ATOM   6202  C   LEU E  60      27.260  77.936   0.084  1.00 34.65           C  
ATOM   6203  O   LEU E  60      27.470  76.824   0.452  1.00 36.88           O  
ATOM   6204  CB  LEU E  60      28.411  79.809   1.339  1.00 42.22           C  
ATOM   6205  CG  LEU E  60      29.761  80.557   1.425  1.00 44.46           C  
ATOM   6206  CD1 LEU E  60      29.604  81.953   0.905  1.00 45.21           C  
ATOM   6207  CD2 LEU E  60      30.393  80.603   2.784  1.00 45.31           C  
ATOM   6208  N   GLN E  61      26.072  78.316  -0.351  1.00 36.52           N  
ATOM   6209  CA  GLN E  61      24.893  77.480  -0.215  1.00 34.01           C  
ATOM   6210  C   GLN E  61      23.677  78.108  -0.937  1.00 35.40           C  
ATOM   6211  O   GLN E  61      23.564  79.325  -1.031  1.00 36.82           O  
ATOM   6212  CB  GLN E  61      24.594  77.235   1.277  1.00 35.04           C  
ATOM   6213  CG  GLN E  61      23.484  76.306   1.560  1.00 36.71           C  
ATOM   6214  CD  GLN E  61      23.457  75.774   2.960  1.00 38.34           C  
ATOM   6215  OE1 GLN E  61      24.496  75.678   3.648  1.00 42.02           O  
ATOM   6216  NE2 GLN E  61      22.249  75.389   3.406  1.00 40.47           N  
ATOM   6217  N   TYR E  62      22.814  77.260  -1.477  1.00 32.70           N  
ATOM   6218  CA  TYR E  62      21.499  77.663  -1.990  1.00 37.16           C  
ATOM   6219  C   TYR E  62      20.412  77.426  -0.928  1.00 38.56           C  
ATOM   6220  O   TYR E  62      20.472  76.446  -0.171  1.00 36.73           O  
ATOM   6221  CB  TYR E  62      21.107  76.846  -3.206  1.00 36.13           C  
ATOM   6222  CG  TYR E  62      21.947  77.109  -4.448  1.00 38.80           C  
ATOM   6223  CD1 TYR E  62      21.606  78.092  -5.334  1.00 41.00           C  
ATOM   6224  CD2 TYR E  62      23.062  76.360  -4.725  1.00 39.53           C  
ATOM   6225  CE1 TYR E  62      22.347  78.333  -6.459  1.00 41.20           C  
ATOM   6226  CE2 TYR E  62      23.832  76.601  -5.834  1.00 41.15           C  
ATOM   6227  CZ  TYR E  62      23.467  77.581  -6.718  1.00 40.97           C  
ATOM   6228  OH  TYR E  62      24.212  77.811  -7.862  1.00 38.44           O  
ATOM   6229  N   TYR E  63      19.447  78.336  -0.875  1.00 38.32           N  
ATOM   6230  CA  TYR E  63      18.248  78.144  -0.046  1.00 38.61           C  
ATOM   6231  C   TYR E  63      16.957  78.319  -0.838  1.00 39.30           C  
ATOM   6232  O   TYR E  63      16.822  79.208  -1.652  1.00 45.27           O  
ATOM   6233  CB  TYR E  63      18.192  79.133   1.095  1.00 38.45           C  
ATOM   6234  CG  TYR E  63      19.342  79.057   2.074  1.00 37.62           C  
ATOM   6235  CD1 TYR E  63      20.508  79.748   1.835  1.00 37.65           C  
ATOM   6236  CD2 TYR E  63      19.245  78.332   3.218  1.00 35.82           C  
ATOM   6237  CE1 TYR E  63      21.557  79.709   2.705  1.00 38.51           C  
ATOM   6238  CE2 TYR E  63      20.296  78.295   4.138  1.00 39.23           C  
ATOM   6239  CZ  TYR E  63      21.460  78.989   3.860  1.00 39.86           C  
ATOM   6240  OH  TYR E  63      22.549  78.970   4.705  1.00 39.21           O  
ATOM   6241  N   LYS E  64      15.987  77.493  -0.535  1.00 37.51           N  
ATOM   6242  CA  LYS E  64      14.718  77.586  -1.131  1.00 41.96           C  
ATOM   6243  C   LYS E  64      13.650  77.475  -0.051  1.00 41.45           C  
ATOM   6244  O   LYS E  64      13.910  76.974   1.032  1.00 39.92           O  
ATOM   6245  CB  LYS E  64      14.581  76.382  -2.084  1.00 42.76           C  
ATOM   6246  CG  LYS E  64      13.217  76.154  -2.698  1.00 45.47           C  
ATOM   6247  CD  LYS E  64      13.141  74.761  -3.277  1.00 49.11           C  
ATOM   6248  CE  LYS E  64      11.753  74.458  -3.733  1.00 51.86           C  
ATOM   6249  NZ  LYS E  64      11.449  75.287  -4.912  1.00 53.53           N  
ATOM   6250  N   GLY E  65      12.433  77.900  -0.403  1.00 44.34           N  
ATOM   6251  CA  GLY E  65      11.152  77.097  -0.051  1.00 42.00           C  
ATOM   6252  C   GLY E  65      10.970  77.876   1.133  1.00 41.52           C  
ATOM   6253  O   GLY E  65      11.462  79.027   1.099  1.00 43.10           O  
ATOM   6254  N   ALA E  66      10.408  77.272   2.186  1.00 39.80           N  
ATOM   6255  CA  ALA E  66      10.510  77.854   3.545  1.00 37.22           C  
ATOM   6256  C   ALA E  66      11.818  77.435   4.299  1.00 34.01           C  
ATOM   6257  O   ALA E  66      12.074  76.276   4.554  1.00 31.24           O  
ATOM   6258  CB  ALA E  66       9.273  77.564   4.366  1.00 35.91           C  
ATOM   6259  N   PHE E  67      12.614  78.411   4.685  1.00 34.69           N  
ATOM   6260  CA  PHE E  67      13.796  78.185   5.529  1.00 34.68           C  
ATOM   6261  C   PHE E  67      14.110  79.451   6.321  1.00 35.71           C  
ATOM   6262  O   PHE E  67      13.584  80.514   6.014  1.00 37.89           O  
ATOM   6263  CB  PHE E  67      15.041  77.793   4.688  1.00 37.16           C  
ATOM   6264  CG  PHE E  67      15.988  76.859   5.399  1.00 38.87           C  
ATOM   6265  CD1 PHE E  67      15.613  75.548   5.677  1.00 41.28           C  
ATOM   6266  CD2 PHE E  67      17.217  77.290   5.843  1.00 40.34           C  
ATOM   6267  CE1 PHE E  67      16.488  74.654   6.351  1.00 39.21           C  
ATOM   6268  CE2 PHE E  67      18.104  76.415   6.529  1.00 41.52           C  
ATOM   6269  CZ  PHE E  67      17.723  75.092   6.785  1.00 38.44           C  
ATOM   6270  N   VAL E  68      15.034  79.339   7.281  1.00 34.67           N  
ATOM   6271  CA  VAL E  68      15.507  80.473   8.081  1.00 37.33           C  
ATOM   6272  C   VAL E  68      17.026  80.719   7.970  1.00 38.40           C  
ATOM   6273  O   VAL E  68      17.807  79.777   8.067  1.00 39.20           O  
ATOM   6274  CB  VAL E  68      15.144  80.242   9.586  1.00 37.72           C  
ATOM   6275  CG1 VAL E  68      15.751  81.333  10.453  1.00 39.62           C  
ATOM   6276  CG2 VAL E  68      13.580  80.158   9.759  1.00 38.20           C  
ATOM   6277  N   ILE E  69      17.424  81.981   7.765  1.00 41.54           N  
ATOM   6278  CA  ILE E  69      18.839  82.374   7.591  1.00 43.58           C  
ATOM   6279  C   ILE E  69      19.222  83.578   8.495  1.00 44.02           C  
ATOM   6280  O   ILE E  69      18.626  84.663   8.420  1.00 42.01           O  
ATOM   6281  CB  ILE E  69      19.200  82.699   6.095  1.00 42.68           C  
ATOM   6282  CG1 ILE E  69      18.765  81.575   5.151  1.00 39.57           C  
ATOM   6283  CG2 ILE E  69      20.740  82.918   5.932  1.00 41.61           C  
ATOM   6284  CD1 ILE E  69      17.553  81.900   4.348  1.00 42.13           C  
ATOM   6285  N   MET E  70      20.226  83.364   9.335  1.00 47.01           N  
ATOM   6286  CA  MET E  70      20.671  84.359  10.324  1.00 51.40           C  
ATOM   6287  C   MET E  70      21.813  85.197   9.779  1.00 54.57           C  
ATOM   6288  O   MET E  70      22.611  84.696   8.958  1.00 53.37           O  
ATOM   6289  CB  MET E  70      21.169  83.659  11.592  1.00 54.06           C  
ATOM   6290  CG  MET E  70      20.176  82.725  12.273  1.00 54.94           C  
ATOM   6291  SD  MET E  70      18.787  83.586  12.962  1.00 57.76           S  
ATOM   6292  CE  MET E  70      19.355  84.053  14.570  1.00 60.91           C  
ATOM   6293  N   SER E  71      21.884  86.457  10.244  1.00 58.84           N  
ATOM   6294  CA  SER E  71      23.005  87.399   9.965  1.00 61.88           C  
ATOM   6295  C   SER E  71      23.854  87.803  11.189  1.00 65.68           C  
ATOM   6296  O   SER E  71      24.937  88.383  11.044  1.00 63.41           O  
ATOM   6297  CB  SER E  71      22.441  88.686   9.390  1.00 60.70           C  
ATOM   6298  OG  SER E  71      22.988  88.863   8.131  1.00 64.50           O  
ATOM   6299  N   GLY E  72      23.327  87.563  12.394  1.00 70.01           N  
ATOM   6300  CA  GLY E  72      24.023  87.922  13.634  1.00 71.92           C  
ATOM   6301  C   GLY E  72      23.527  87.158  14.855  1.00 73.14           C  
ATOM   6302  O   GLY E  72      22.444  86.568  14.823  1.00 72.60           O  
ATOM   6303  N   PHE E  73      24.321  87.182  15.930  1.00 73.94           N  
ATOM   6304  CA  PHE E  73      24.021  86.412  17.148  1.00 76.33           C  
ATOM   6305  C   PHE E  73      22.887  87.080  17.931  1.00 80.00           C  
ATOM   6306  O   PHE E  73      22.792  88.303  17.969  1.00 81.67           O  
ATOM   6307  CB  PHE E  73      25.262  86.298  18.044  1.00 74.33           C  
ATOM   6308  CG  PHE E  73      26.420  85.540  17.418  1.00 73.99           C  
ATOM   6309  CD1 PHE E  73      26.414  84.145  17.370  1.00 73.76           C  
ATOM   6310  CD2 PHE E  73      27.529  86.217  16.905  1.00 72.83           C  
ATOM   6311  CE1 PHE E  73      27.495  83.438  16.797  1.00 73.58           C  
ATOM   6312  CE2 PHE E  73      28.608  85.511  16.336  1.00 72.95           C  
ATOM   6313  CZ  PHE E  73      28.588  84.129  16.280  1.00 72.81           C  
ATOM   6314  N   ILE E  74      22.034  86.275  18.549  1.00 83.48           N  
ATOM   6315  CA  ILE E  74      20.911  86.786  19.363  1.00 86.92           C  
ATOM   6316  C   ILE E  74      21.328  87.175  20.796  1.00 88.04           C  
ATOM   6317  O   ILE E  74      20.641  87.968  21.458  1.00 88.91           O  
ATOM   6318  CB  ILE E  74      19.705  85.772  19.391  1.00 87.37           C  
ATOM   6319  CG1 ILE E  74      18.520  86.339  20.178  1.00 88.11           C  
ATOM   6320  CG2 ILE E  74      20.107  84.444  20.017  1.00 87.85           C  
ATOM   6321  CD1 ILE E  74      17.263  85.537  19.981  1.00 88.37           C  
ATOM   6322  N   ASP E  75      22.440  86.625  21.280  1.00 90.22           N  
ATOM   6323  CA  ASP E  75      22.945  86.990  22.604  1.00 92.49           C  
ATOM   6324  C   ASP E  75      23.717  88.304  22.497  1.00 92.40           C  
ATOM   6325  O   ASP E  75      23.339  89.321  23.110  1.00 92.14           O  
ATOM   6326  CB  ASP E  75      23.829  85.870  23.173  1.00 94.74           C  
ATOM   6327  CG  ASP E  75      24.299  86.142  24.620  1.00 96.82           C  
ATOM   6328  OD1 ASP E  75      25.234  86.963  24.818  1.00 97.35           O  
ATOM   6329  OD2 ASP E  75      23.751  85.501  25.554  1.00 98.00           O  
ATOM   6330  N   THR E  76      24.784  88.280  21.698  1.00 91.59           N  
ATOM   6331  CA  THR E  76      25.652  89.439  21.547  1.00 91.78           C  
ATOM   6332  C   THR E  76      25.038  90.481  20.607  1.00 91.45           C  
ATOM   6333  O   THR E  76      25.438  91.661  20.643  1.00 92.32           O  
ATOM   6334  CB  THR E  76      27.077  89.057  21.036  1.00 92.17           C  
ATOM   6335  OG1 THR E  76      27.024  88.622  19.668  1.00 91.50           O  
ATOM   6336  CG2 THR E  76      27.707  87.966  21.914  1.00 92.48           C  
ATOM   6337  N   GLU E  77      24.081  90.042  19.775  1.00 88.72           N  
ATOM   6338  CA  GLU E  77      23.498  90.860  18.703  1.00 87.10           C  
ATOM   6339  C   GLU E  77      24.572  91.394  17.720  1.00 85.16           C  
ATOM   6340  O   GLU E  77      24.372  92.409  17.060  1.00 86.01           O  
ATOM   6341  CB  GLU E  77      22.602  91.959  19.297  1.00 87.18           C  
ATOM   6342  CG  GLU E  77      21.426  91.367  20.090  1.00 87.97           C  
ATOM   6343  CD  GLU E  77      20.385  92.404  20.552  1.00 89.02           C  
ATOM   6344  OE1 GLU E  77      20.792  93.479  21.064  1.00 89.99           O  
ATOM   6345  OE2 GLU E  77      19.162  92.126  20.423  1.00 87.87           O  
ATOM   6346  N   THR E  78      25.688  90.666  17.617  1.00 82.56           N  
ATOM   6347  CA  THR E  78      26.838  91.022  16.779  1.00 79.46           C  
ATOM   6348  C   THR E  78      26.856  90.131  15.547  1.00 76.28           C  
ATOM   6349  O   THR E  78      26.098  89.154  15.469  1.00 75.53           O  
ATOM   6350  CB  THR E  78      28.157  90.801  17.547  1.00 79.72           C  
ATOM   6351  OG1 THR E  78      27.964  91.144  18.922  1.00 79.17           O  
ATOM   6352  CG2 THR E  78      29.297  91.643  16.957  1.00 80.23           C  
ATOM   6353  N   SER E  79      27.706  90.467  14.579  1.00 73.31           N  
ATOM   6354  CA  SER E  79      27.783  89.687  13.341  1.00 70.06           C  
ATOM   6355  C   SER E  79      28.217  88.251  13.602  1.00 67.55           C  
ATOM   6356  O   SER E  79      29.000  87.959  14.500  1.00 64.96           O  
ATOM   6357  CB  SER E  79      28.720  90.312  12.296  1.00 68.80           C  
ATOM   6358  OG  SER E  79      28.907  89.413  11.203  1.00 65.47           O  
ATOM   6359  N   VAL E  80      27.669  87.369  12.783  1.00 66.18           N  
ATOM   6360  CA  VAL E  80      28.106  85.997  12.708  1.00 65.99           C  
ATOM   6361  C   VAL E  80      29.166  85.829  11.614  1.00 63.86           C  
ATOM   6362  O   VAL E  80      29.590  84.707  11.330  1.00 64.79           O  
ATOM   6363  CB  VAL E  80      26.905  85.067  12.436  1.00 66.02           C  
ATOM   6364  CG1 VAL E  80      25.892  85.165  13.599  1.00 66.73           C  
ATOM   6365  CG2 VAL E  80      26.255  85.355  11.048  1.00 66.01           C  
ATOM   6366  N   GLY E  81      29.584  86.936  10.995  1.00 61.04           N  
ATOM   6367  CA  GLY E  81      30.460  86.875   9.828  1.00 58.87           C  
ATOM   6368  C   GLY E  81      29.674  87.330   8.641  1.00 56.31           C  
ATOM   6369  O   GLY E  81      28.449  87.286   8.661  1.00 60.66           O  
ATOM   6370  N   TYR E  82      30.368  87.731   7.589  1.00 52.45           N  
ATOM   6371  CA  TYR E  82      29.807  88.637   6.622  1.00 49.53           C  
ATOM   6372  C   TYR E  82      29.532  88.048   5.242  1.00 45.89           C  
ATOM   6373  O   TYR E  82      30.449  87.584   4.589  1.00 42.94           O  
ATOM   6374  CB  TYR E  82      30.744  89.822   6.508  1.00 53.47           C  
ATOM   6375  CG  TYR E  82      30.605  90.808   7.640  1.00 53.29           C  
ATOM   6376  CD1 TYR E  82      29.360  91.392   7.923  1.00 53.00           C  
ATOM   6377  CD2 TYR E  82      31.709  91.169   8.425  1.00 54.79           C  
ATOM   6378  CE1 TYR E  82      29.205  92.315   8.962  1.00 53.48           C  
ATOM   6379  CE2 TYR E  82      31.569  92.110   9.484  1.00 54.88           C  
ATOM   6380  CZ  TYR E  82      30.303  92.679   9.729  1.00 54.02           C  
ATOM   6381  OH  TYR E  82      30.129  93.607  10.729  1.00 54.49           O  
ATOM   6382  N   TYR E  83      28.248  88.098   4.826  1.00 44.12           N  
ATOM   6383  CA  TYR E  83      27.721  87.395   3.643  1.00 40.91           C  
ATOM   6384  C   TYR E  83      26.623  88.228   2.938  1.00 40.15           C  
ATOM   6385  O   TYR E  83      26.111  89.221   3.478  1.00 39.08           O  
ATOM   6386  CB  TYR E  83      27.129  86.034   4.049  1.00 44.25           C  
ATOM   6387  CG  TYR E  83      28.113  85.136   4.771  1.00 44.81           C  
ATOM   6388  CD1 TYR E  83      29.205  84.645   4.088  1.00 46.64           C  
ATOM   6389  CD2 TYR E  83      27.965  84.792   6.132  1.00 44.41           C  
ATOM   6390  CE1 TYR E  83      30.140  83.825   4.705  1.00 48.97           C  
ATOM   6391  CE2 TYR E  83      28.900  83.971   6.765  1.00 43.00           C  
ATOM   6392  CZ  TYR E  83      29.993  83.485   6.043  1.00 46.82           C  
ATOM   6393  OH  TYR E  83      31.015  82.673   6.567  1.00 46.54           O  
ATOM   6394  N   ASN E  84      26.252  87.798   1.741  1.00 35.50           N  
ATOM   6395  CA  ASN E  84      25.129  88.350   1.039  1.00 36.38           C  
ATOM   6396  C   ASN E  84      24.134  87.249   0.802  1.00 37.72           C  
ATOM   6397  O   ASN E  84      24.507  86.067   0.684  1.00 37.44           O  
ATOM   6398  CB  ASN E  84      25.482  88.986  -0.343  1.00 37.10           C  
ATOM   6399  CG  ASN E  84      26.815  89.795  -0.345  1.00 36.21           C  
ATOM   6400  OD1 ASN E  84      26.862  90.960   0.066  1.00 39.96           O  
ATOM   6401  ND2 ASN E  84      27.870  89.176  -0.835  1.00 32.29           N  
ATOM   6402  N   LEU E  85      22.862  87.644   0.725  1.00 36.80           N  
ATOM   6403  CA  LEU E  85      21.786  86.721   0.397  1.00 35.75           C  
ATOM   6404  C   LEU E  85      21.079  87.284  -0.863  1.00 34.06           C  
ATOM   6405  O   LEU E  85      20.358  88.312  -0.790  1.00 34.17           O  
ATOM   6406  CB  LEU E  85      20.817  86.596   1.587  1.00 34.04           C  
ATOM   6407  CG  LEU E  85      19.655  85.600   1.396  1.00 37.05           C  
ATOM   6408  CD1 LEU E  85      20.119  84.146   0.968  1.00 35.63           C  
ATOM   6409  CD2 LEU E  85      18.877  85.564   2.693  1.00 37.40           C  
ATOM   6410  N   GLU E  86      21.267  86.572  -1.973  1.00 33.11           N  
ATOM   6411  CA  GLU E  86      20.904  87.052  -3.319  1.00 34.85           C  
ATOM   6412  C   GLU E  86      19.742  86.251  -3.912  1.00 33.57           C  
ATOM   6413  O   GLU E  86      19.736  85.041  -3.786  1.00 32.81           O  
ATOM   6414  CB  GLU E  86      22.100  86.963  -4.276  1.00 33.27           C  
ATOM   6415  CG  GLU E  86      21.763  87.561  -5.655  1.00 35.92           C  
ATOM   6416  CD  GLU E  86      22.974  87.602  -6.594  1.00 38.91           C  
ATOM   6417  OE1 GLU E  86      24.154  87.590  -6.111  1.00 36.04           O  
ATOM   6418  OE2 GLU E  86      22.703  87.659  -7.825  1.00 44.44           O  
ATOM   6419  N   VAL E  87      18.769  86.935  -4.521  1.00 32.82           N  
ATOM   6420  CA  VAL E  87      17.637  86.300  -5.135  1.00 36.87           C  
ATOM   6421  C   VAL E  87      17.941  85.790  -6.568  1.00 38.82           C  
ATOM   6422  O   VAL E  87      18.386  86.558  -7.391  1.00 33.96           O  
ATOM   6423  CB  VAL E  87      16.402  87.262  -5.183  1.00 37.69           C  
ATOM   6424  CG1 VAL E  87      15.201  86.594  -5.829  1.00 36.18           C  
ATOM   6425  CG2 VAL E  87      16.000  87.762  -3.758  1.00 38.92           C  
ATOM   6426  N   ILE E  88      17.629  84.494  -6.824  1.00 42.36           N  
ATOM   6427  CA  ILE E  88      17.800  83.765  -8.111  1.00 40.84           C  
ATOM   6428  C   ILE E  88      16.475  83.475  -8.840  1.00 40.21           C  
ATOM   6429  O   ILE E  88      16.397  83.531 -10.073  1.00 40.23           O  
ATOM   6430  CB  ILE E  88      18.357  82.339  -7.875  1.00 45.54           C  
ATOM   6431  CG1 ILE E  88      19.738  82.336  -7.263  1.00 45.06           C  
ATOM   6432  CG2 ILE E  88      18.332  81.515  -9.197  1.00 47.63           C  
ATOM   6433  CD1 ILE E  88      20.155  80.941  -6.894  1.00 46.55           C  
ATOM   6434  N   SER E  89      15.431  83.103  -8.106  1.00 38.66           N  
ATOM   6435  CA  SER E  89      14.122  82.930  -8.752  1.00 38.16           C  
ATOM   6436  C   SER E  89      13.648  84.291  -9.290  1.00 39.52           C  
ATOM   6437  O   SER E  89      14.248  85.332  -8.976  1.00 38.60           O  
ATOM   6438  CB  SER E  89      13.078  82.349  -7.775  1.00 36.94           C  
ATOM   6439  OG  SER E  89      12.915  83.200  -6.649  1.00 35.89           O  
ATOM   6440  N   GLU E  90      12.574  84.288 -10.083  1.00 41.70           N  
ATOM   6441  CA  GLU E  90      11.988  85.538 -10.590  1.00 46.99           C  
ATOM   6442  C   GLU E  90      11.400  86.385  -9.435  1.00 46.07           C  
ATOM   6443  O   GLU E  90      11.488  87.610  -9.442  1.00 45.67           O  
ATOM   6444  CB  GLU E  90      10.901  85.265 -11.657  1.00 50.50           C  
ATOM   6445  CG  GLU E  90      11.195  85.888 -13.051  1.00 55.76           C  
ATOM   6446  CD  GLU E  90      12.197  85.063 -13.900  1.00 58.64           C  
ATOM   6447  OE1 GLU E  90      11.969  83.844 -14.101  1.00 62.88           O  
ATOM   6448  OE2 GLU E  90      13.205  85.632 -14.394  1.00 58.99           O  
ATOM   6449  N   GLN E  91      10.798  85.717  -8.456  1.00 44.72           N  
ATOM   6450  CA  GLN E  91      10.243  86.380  -7.283  1.00 45.55           C  
ATOM   6451  C   GLN E  91      10.619  85.633  -6.005  1.00 40.56           C  
ATOM   6452  O   GLN E  91      10.899  84.451  -6.033  1.00 34.49           O  
ATOM   6453  CB  GLN E  91       8.704  86.414  -7.375  1.00 50.76           C  
ATOM   6454  CG  GLN E  91       8.150  87.421  -8.347  1.00 55.33           C  
ATOM   6455  CD  GLN E  91       8.298  88.875  -7.836  1.00 62.05           C  
ATOM   6456  OE1 GLN E  91       7.824  89.254  -6.727  1.00 65.00           O  
ATOM   6457  NE2 GLN E  91       8.954  89.701  -8.660  1.00 63.69           N  
ATOM   6458  N   ALA E  92      10.559  86.341  -4.880  1.00 40.20           N  
ATOM   6459  CA  ALA E  92      10.811  85.792  -3.567  1.00 38.08           C  
ATOM   6460  C   ALA E  92      10.022  86.611  -2.564  1.00 39.22           C  
ATOM   6461  O   ALA E  92       9.819  87.780  -2.768  1.00 39.31           O  
ATOM   6462  CB  ALA E  92      12.300  85.857  -3.259  1.00 36.92           C  
ATOM   6463  N   THR E  93       9.557  85.969  -1.487  1.00 42.08           N  
ATOM   6464  CA  THR E  93       8.861  86.612  -0.364  1.00 38.08           C  
ATOM   6465  C   THR E  93       9.640  86.286   0.881  1.00 34.99           C  
ATOM   6466  O   THR E  93       9.913  85.143   1.134  1.00 38.32           O  
ATOM   6467  CB  THR E  93       7.469  86.034  -0.165  1.00 39.86           C  
ATOM   6468  OG1 THR E  93       6.696  86.199  -1.360  1.00 40.21           O  
ATOM   6469  CG2 THR E  93       6.755  86.703   1.019  1.00 37.68           C  
ATOM   6470  N   ALA E  94       9.988  87.275   1.683  1.00 35.62           N  
ATOM   6471  CA  ALA E  94      10.757  87.014   2.876  1.00 35.79           C  
ATOM   6472  C   ALA E  94      10.329  87.917   4.018  1.00 38.62           C  
ATOM   6473  O   ALA E  94       9.911  89.054   3.787  1.00 37.09           O  
ATOM   6474  CB  ALA E  94      12.221  87.238   2.567  1.00 35.97           C  
ATOM   6475  N   TYR E  95      10.450  87.417   5.255  1.00 36.92           N  
ATOM   6476  CA  TYR E  95      10.247  88.248   6.462  1.00 35.43           C  
ATOM   6477  C   TYR E  95      11.630  88.536   7.083  1.00 35.69           C  
ATOM   6478  O   TYR E  95      12.388  87.627   7.320  1.00 39.39           O  
ATOM   6479  CB  TYR E  95       9.322  87.511   7.436  1.00 37.59           C  
ATOM   6480  CG  TYR E  95       7.972  87.184   6.850  1.00 38.17           C  
ATOM   6481  CD1 TYR E  95       7.817  86.176   5.874  1.00 39.53           C  
ATOM   6482  CD2 TYR E  95       6.855  87.893   7.229  1.00 39.19           C  
ATOM   6483  CE1 TYR E  95       6.555  85.910   5.291  1.00 38.81           C  
ATOM   6484  CE2 TYR E  95       5.615  87.628   6.669  1.00 37.39           C  
ATOM   6485  CZ  TYR E  95       5.474  86.644   5.705  1.00 37.94           C  
ATOM   6486  OH  TYR E  95       4.215  86.413   5.169  1.00 38.56           O  
ATOM   6487  N   VAL E  96      11.929  89.814   7.321  1.00 37.87           N  
ATOM   6488  CA  VAL E  96      13.247  90.371   7.692  1.00 39.97           C  
ATOM   6489  C   VAL E  96      13.131  90.935   9.114  1.00 39.92           C  
ATOM   6490  O   VAL E  96      12.574  92.008   9.314  1.00 42.32           O  
ATOM   6491  CB  VAL E  96      13.646  91.539   6.679  1.00 43.27           C  
ATOM   6492  CG1 VAL E  96      14.955  92.220   7.036  1.00 44.33           C  
ATOM   6493  CG2 VAL E  96      13.683  91.028   5.188  1.00 44.05           C  
ATOM   6494  N   ILE E  97      13.601  90.176  10.104  1.00 43.38           N  
ATOM   6495  CA  ILE E  97      13.429  90.511  11.540  1.00 42.46           C  
ATOM   6496  C   ILE E  97      14.797  90.910  12.058  1.00 42.64           C  
ATOM   6497  O   ILE E  97      15.771  90.142  11.925  1.00 43.69           O  
ATOM   6498  CB  ILE E  97      12.954  89.250  12.366  1.00 43.47           C  
ATOM   6499  CG1 ILE E  97      11.808  88.517  11.662  1.00 41.56           C  
ATOM   6500  CG2 ILE E  97      12.503  89.629  13.765  1.00 44.91           C  
ATOM   6501  CD1 ILE E  97      11.797  86.996  11.809  1.00 41.14           C  
ATOM   6502  N   LYS E  98      14.904  92.101  12.630  1.00 43.99           N  
ATOM   6503  CA  LYS E  98      16.129  92.454  13.383  1.00 47.92           C  
ATOM   6504  C   LYS E  98      16.333  91.520  14.558  1.00 48.83           C  
ATOM   6505  O   LYS E  98      15.380  91.115  15.238  1.00 47.83           O  
ATOM   6506  CB  LYS E  98      16.082  93.899  13.868  1.00 52.61           C  
ATOM   6507  CG  LYS E  98      16.179  94.914  12.741  1.00 54.82           C  
ATOM   6508  CD  LYS E  98      15.258  96.101  12.969  1.00 57.56           C  
ATOM   6509  CE  LYS E  98      14.979  96.834  11.644  1.00 60.18           C  
ATOM   6510  NZ  LYS E  98      14.405  95.938  10.546  1.00 61.26           N  
ATOM   6511  N   ILE E  99      17.588  91.169  14.787  1.00 51.65           N  
ATOM   6512  CA  ILE E  99      17.946  90.117  15.737  1.00 54.93           C  
ATOM   6513  C   ILE E  99      17.376  90.375  17.176  1.00 54.60           C  
ATOM   6514  O   ILE E  99      16.887  89.447  17.852  1.00 54.91           O  
ATOM   6515  CB  ILE E  99      19.495  89.882  15.680  1.00 57.56           C  
ATOM   6516  CG1 ILE E  99      19.887  88.547  16.305  1.00 60.27           C  
ATOM   6517  CG2 ILE E  99      20.294  91.077  16.300  1.00 59.20           C  
ATOM   6518  CD1 ILE E  99      19.594  87.327  15.429  1.00 61.89           C  
ATOM   6519  N   ASN E 100      17.439  91.634  17.604  1.00 56.60           N  
ATOM   6520  CA  ASN E 100      16.697  92.151  18.787  1.00 60.45           C  
ATOM   6521  C   ASN E 100      15.185  91.730  18.911  1.00 60.00           C  
ATOM   6522  O   ASN E 100      14.776  91.138  19.928  1.00 62.52           O  
ATOM   6523  CB  ASN E 100      16.913  93.705  18.984  1.00 61.31           C  
ATOM   6524  CG  ASN E 100      17.061  94.524  17.639  1.00 61.80           C  
ATOM   6525  OD1 ASN E 100      16.166  95.321  17.293  1.00 58.75           O  
ATOM   6526  ND2 ASN E 100      18.208  94.362  16.929  1.00 60.11           N  
ATOM   6527  N   GLU E 101      14.388  91.982  17.873  1.00 58.40           N  
ATOM   6528  CA  GLU E 101      12.953  91.637  17.871  1.00 58.69           C  
ATOM   6529  C   GLU E 101      12.683  90.131  18.019  1.00 55.28           C  
ATOM   6530  O   GLU E 101      11.617  89.735  18.505  1.00 50.92           O  
ATOM   6531  CB  GLU E 101      12.257  92.149  16.596  1.00 59.01           C  
ATOM   6532  CG  GLU E 101      12.561  93.638  16.216  1.00 62.22           C  
ATOM   6533  CD  GLU E 101      11.920  94.069  14.844  1.00 64.01           C  
ATOM   6534  OE1 GLU E 101      12.250  93.499  13.745  1.00 63.04           O  
ATOM   6535  OE2 GLU E 101      11.089  95.008  14.881  1.00 65.87           O  
ATOM   6536  N   LEU E 102      13.647  89.301  17.615  1.00 52.73           N  
ATOM   6537  CA  LEU E 102      13.441  87.830  17.473  1.00 52.95           C  
ATOM   6538  C   LEU E 102      13.374  87.069  18.833  1.00 49.85           C  
ATOM   6539  O   LEU E 102      12.587  86.140  19.007  1.00 46.38           O  
ATOM   6540  CB  LEU E 102      14.551  87.265  16.541  1.00 51.73           C  
ATOM   6541  CG  LEU E 102      14.599  85.848  15.984  1.00 52.83           C  
ATOM   6542  CD1 LEU E 102      15.390  84.955  16.892  1.00 55.32           C  
ATOM   6543  CD2 LEU E 102      13.203  85.227  15.663  1.00 53.29           C  
ATOM   6544  N   LYS E 103      14.214  87.484  19.767  1.00 47.08           N  
ATOM   6545  CA  LYS E 103      14.214  86.969  21.111  1.00 50.83           C  
ATOM   6546  C   LYS E 103      12.831  87.080  21.762  1.00 49.38           C  
ATOM   6547  O   LYS E 103      12.311  86.126  22.380  1.00 45.26           O  
ATOM   6548  CB  LYS E 103      15.236  87.747  21.953  1.00 53.03           C  
ATOM   6549  CG  LYS E 103      15.608  87.076  23.281  1.00 54.81           C  
ATOM   6550  CD  LYS E 103      16.803  87.748  23.972  1.00 55.24           C  
ATOM   6551  CE  LYS E 103      17.244  87.015  25.277  1.00 57.34           C  
ATOM   6552  NZ  LYS E 103      18.772  86.890  25.394  1.00 56.88           N  
ATOM   6553  N   GLU E 104      12.250  88.255  21.621  1.00 47.24           N  
ATOM   6554  CA  GLU E 104      10.963  88.512  22.204  1.00 49.55           C  
ATOM   6555  C   GLU E 104       9.869  87.674  21.502  1.00 46.68           C  
ATOM   6556  O   GLU E 104       9.024  87.101  22.195  1.00 45.47           O  
ATOM   6557  CB  GLU E 104      10.665  90.015  22.179  1.00 54.76           C  
ATOM   6558  CG  GLU E 104       9.465  90.442  23.024  1.00 60.53           C  
ATOM   6559  CD  GLU E 104       9.743  90.415  24.525  1.00 64.46           C  
ATOM   6560  OE1 GLU E 104       9.915  89.311  25.094  1.00 67.38           O  
ATOM   6561  OE2 GLU E 104       9.756  91.500  25.142  1.00 67.05           O  
ATOM   6562  N   LEU E 105       9.891  87.596  20.160  1.00 41.82           N  
ATOM   6563  CA  LEU E 105       8.994  86.680  19.406  1.00 40.90           C  
ATOM   6564  C   LEU E 105       9.088  85.243  19.856  1.00 37.02           C  
ATOM   6565  O   LEU E 105       8.059  84.590  20.132  1.00 39.28           O  
ATOM   6566  CB  LEU E 105       9.296  86.682  17.921  1.00 40.04           C  
ATOM   6567  CG  LEU E 105       8.925  88.014  17.239  1.00 42.08           C  
ATOM   6568  CD1 LEU E 105       9.786  88.236  15.989  1.00 41.79           C  
ATOM   6569  CD2 LEU E 105       7.408  88.152  16.919  1.00 39.45           C  
ATOM   6570  N   LEU E 106      10.314  84.746  19.952  1.00 32.19           N  
ATOM   6571  CA  LEU E 106      10.520  83.331  20.266  1.00 34.56           C  
ATOM   6572  C   LEU E 106      10.200  83.017  21.725  1.00 33.17           C  
ATOM   6573  O   LEU E 106       9.732  81.928  22.008  1.00 36.28           O  
ATOM   6574  CB  LEU E 106      11.948  82.843  19.922  1.00 31.14           C  
ATOM   6575  CG  LEU E 106      12.333  82.829  18.468  1.00 34.50           C  
ATOM   6576  CD1 LEU E 106      13.636  81.979  18.304  1.00 38.66           C  
ATOM   6577  CD2 LEU E 106      11.201  82.324  17.509  1.00 33.94           C  
ATOM   6578  N   SER E 107      10.493  83.952  22.612  1.00 30.96           N  
ATOM   6579  CA  SER E 107      10.149  83.863  24.010  1.00 36.33           C  
ATOM   6580  C   SER E 107       8.667  83.710  24.297  1.00 34.14           C  
ATOM   6581  O   SER E 107       8.307  83.036  25.237  1.00 34.36           O  
ATOM   6582  CB  SER E 107      10.588  85.138  24.760  1.00 37.96           C  
ATOM   6583  OG  SER E 107      11.969  85.193  24.902  1.00 40.10           O  
ATOM   6584  N   LYS E 108       7.830  84.377  23.522  1.00 36.24           N  
ATOM   6585  CA  LYS E 108       6.393  84.405  23.767  1.00 37.21           C  
ATOM   6586  C   LYS E 108       5.685  83.257  23.068  1.00 35.87           C  
ATOM   6587  O   LYS E 108       4.472  83.149  23.183  1.00 35.84           O  
ATOM   6588  CB  LYS E 108       5.759  85.741  23.303  1.00 41.48           C  
ATOM   6589  CG  LYS E 108       6.251  87.022  23.981  1.00 42.57           C  
ATOM   6590  CD  LYS E 108       5.119  87.919  24.437  1.00 44.44           C  
ATOM   6591  CE  LYS E 108       5.620  89.263  25.033  1.00 47.05           C  
ATOM   6592  NZ  LYS E 108       4.584  90.409  25.240  1.00 45.60           N  
ATOM   6593  N   ASN E 109       6.424  82.411  22.337  1.00 33.63           N  
ATOM   6594  CA  ASN E 109       5.876  81.176  21.744  1.00 27.98           C  
ATOM   6595  C   ASN E 109       6.966  80.118  21.560  1.00 28.40           C  
ATOM   6596  O   ASN E 109       7.724  80.149  20.612  1.00 27.63           O  
ATOM   6597  CB  ASN E 109       5.159  81.528  20.436  1.00 29.52           C  
ATOM   6598  CG  ASN E 109       4.284  80.417  19.906  1.00 29.95           C  
ATOM   6599  OD1 ASN E 109       4.728  79.297  19.747  1.00 35.74           O  
ATOM   6600  ND2 ASN E 109       3.031  80.731  19.625  1.00 27.89           N  
ATOM   6601  N   LEU E 110       7.052  79.169  22.487  1.00 29.56           N  
ATOM   6602  CA  LEU E 110       8.084  78.138  22.418  1.00 33.08           C  
ATOM   6603  C   LEU E 110       7.955  77.120  21.276  1.00 33.19           C  
ATOM   6604  O   LEU E 110       8.958  76.527  20.840  1.00 29.93           O  
ATOM   6605  CB  LEU E 110       8.213  77.387  23.753  1.00 33.02           C  
ATOM   6606  CG  LEU E 110       8.461  78.289  24.968  1.00 32.75           C  
ATOM   6607  CD1 LEU E 110       8.744  77.486  26.220  1.00 33.33           C  
ATOM   6608  CD2 LEU E 110       9.528  79.284  24.702  1.00 31.33           C  
ATOM   6609  N   THR E 111       6.731  76.904  20.817  1.00 33.23           N  
ATOM   6610  CA  THR E 111       6.515  76.068  19.628  1.00 33.39           C  
ATOM   6611  C   THR E 111       7.267  76.646  18.432  1.00 31.82           C  
ATOM   6612  O   THR E 111       7.981  75.922  17.727  1.00 31.39           O  
ATOM   6613  CB  THR E 111       5.013  75.937  19.308  1.00 32.86           C  
ATOM   6614  OG1 THR E 111       4.351  75.367  20.449  1.00 34.13           O  
ATOM   6615  CG2 THR E 111       4.809  75.033  18.118  1.00 29.63           C  
ATOM   6616  N   HIS E 112       7.125  77.949  18.207  1.00 29.49           N  
ATOM   6617  CA  HIS E 112       7.894  78.573  17.149  1.00 30.92           C  
ATOM   6618  C   HIS E 112       9.407  78.641  17.446  1.00 30.90           C  
ATOM   6619  O   HIS E 112      10.203  78.529  16.520  1.00 32.94           O  
ATOM   6620  CB  HIS E 112       7.276  79.933  16.713  1.00 32.90           C  
ATOM   6621  CG  HIS E 112       5.855  79.808  16.252  1.00 30.18           C  
ATOM   6622  ND1 HIS E 112       5.465  78.892  15.316  1.00 32.63           N  
ATOM   6623  CD2 HIS E 112       4.724  80.428  16.664  1.00 33.09           C  
ATOM   6624  CE1 HIS E 112       4.150  78.955  15.158  1.00 36.35           C  
ATOM   6625  NE2 HIS E 112       3.674  79.880  15.973  1.00 33.82           N  
ATOM   6626  N   PHE E 113       9.823  78.743  18.708  1.00 31.76           N  
ATOM   6627  CA  PHE E 113      11.276  78.708  19.063  1.00 29.84           C  
ATOM   6628  C   PHE E 113      11.858  77.360  18.657  1.00 33.05           C  
ATOM   6629  O   PHE E 113      12.971  77.283  18.137  1.00 32.76           O  
ATOM   6630  CB  PHE E 113      11.472  78.915  20.576  1.00 30.96           C  
ATOM   6631  CG  PHE E 113      12.895  79.319  21.039  1.00 30.41           C  
ATOM   6632  CD1 PHE E 113      14.026  79.134  20.291  1.00 32.14           C  
ATOM   6633  CD2 PHE E 113      13.058  79.890  22.316  1.00 31.94           C  
ATOM   6634  CE1 PHE E 113      15.319  79.566  20.776  1.00 33.33           C  
ATOM   6635  CE2 PHE E 113      14.343  80.284  22.803  1.00 33.10           C  
ATOM   6636  CZ  PHE E 113      15.458  80.134  22.026  1.00 30.67           C  
ATOM   6637  N   PHE E 114      11.118  76.299  18.939  1.00 31.91           N  
ATOM   6638  CA  PHE E 114      11.518  74.931  18.592  1.00 34.92           C  
ATOM   6639  C   PHE E 114      11.636  74.619  17.088  1.00 34.06           C  
ATOM   6640  O   PHE E 114      12.580  73.921  16.653  1.00 35.16           O  
ATOM   6641  CB  PHE E 114      10.559  73.926  19.265  1.00 38.56           C  
ATOM   6642  CG  PHE E 114      10.895  73.683  20.702  1.00 40.83           C  
ATOM   6643  CD1 PHE E 114      12.194  73.305  21.065  1.00 42.47           C  
ATOM   6644  CD2 PHE E 114       9.969  73.887  21.699  1.00 40.75           C  
ATOM   6645  CE1 PHE E 114      12.525  73.094  22.406  1.00 43.40           C  
ATOM   6646  CE2 PHE E 114      10.293  73.679  23.053  1.00 40.60           C  
ATOM   6647  CZ  PHE E 114      11.554  73.277  23.405  1.00 41.80           C  
ATOM   6648  N   TYR E 115      10.672  75.109  16.321  1.00 33.01           N  
ATOM   6649  CA  TYR E 115      10.748  75.129  14.875  1.00 35.68           C  
ATOM   6650  C   TYR E 115      12.055  75.797  14.353  1.00 35.80           C  
ATOM   6651  O   TYR E 115      12.778  75.190  13.593  1.00 34.91           O  
ATOM   6652  CB  TYR E 115       9.491  75.809  14.298  1.00 36.63           C  
ATOM   6653  CG  TYR E 115       9.625  76.084  12.808  1.00 37.30           C  
ATOM   6654  CD1 TYR E 115       9.648  75.042  11.874  1.00 37.40           C  
ATOM   6655  CD2 TYR E 115       9.755  77.389  12.338  1.00 36.96           C  
ATOM   6656  CE1 TYR E 115       9.774  75.311  10.475  1.00 35.50           C  
ATOM   6657  CE2 TYR E 115       9.901  77.647  10.998  1.00 37.05           C  
ATOM   6658  CZ  TYR E 115       9.913  76.599  10.075  1.00 37.32           C  
ATOM   6659  OH  TYR E 115      10.095  76.940   8.752  1.00 41.12           O  
ATOM   6660  N   VAL E 116      12.343  77.029  14.795  1.00 35.94           N  
ATOM   6661  CA  VAL E 116      13.594  77.768  14.449  1.00 34.79           C  
ATOM   6662  C   VAL E 116      14.888  77.057  14.853  1.00 35.34           C  
ATOM   6663  O   VAL E 116      15.822  76.983  14.053  1.00 33.03           O  
ATOM   6664  CB  VAL E 116      13.633  79.221  15.061  1.00 33.75           C  
ATOM   6665  CG1 VAL E 116      15.032  79.928  14.806  1.00 33.28           C  
ATOM   6666  CG2 VAL E 116      12.450  80.105  14.504  1.00 30.26           C  
ATOM   6667  N   PHE E 117      14.925  76.537  16.085  1.00 33.31           N  
ATOM   6668  CA  PHE E 117      16.006  75.716  16.602  1.00 32.27           C  
ATOM   6669  C   PHE E 117      16.237  74.444  15.700  1.00 34.13           C  
ATOM   6670  O   PHE E 117      17.373  74.181  15.224  1.00 30.17           O  
ATOM   6671  CB  PHE E 117      15.651  75.360  18.042  1.00 34.24           C  
ATOM   6672  CG  PHE E 117      16.768  74.680  18.846  1.00 34.71           C  
ATOM   6673  CD1 PHE E 117      17.143  73.374  18.592  1.00 32.67           C  
ATOM   6674  CD2 PHE E 117      17.363  75.337  19.937  1.00 37.11           C  
ATOM   6675  CE1 PHE E 117      18.132  72.758  19.336  1.00 34.28           C  
ATOM   6676  CE2 PHE E 117      18.363  74.700  20.721  1.00 36.41           C  
ATOM   6677  CZ  PHE E 117      18.757  73.429  20.395  1.00 36.02           C  
ATOM   6678  N   GLN E 118      15.176  73.704  15.408  1.00 32.46           N  
ATOM   6679  CA  GLN E 118      15.306  72.541  14.495  1.00 36.11           C  
ATOM   6680  C   GLN E 118      15.717  72.865  13.028  1.00 32.56           C  
ATOM   6681  O   GLN E 118      16.394  72.057  12.385  1.00 30.28           O  
ATOM   6682  CB  GLN E 118      14.028  71.721  14.535  1.00 38.29           C  
ATOM   6683  CG  GLN E 118      13.935  70.460  13.626  1.00 40.00           C  
ATOM   6684  CD  GLN E 118      12.781  69.495  14.066  1.00 41.96           C  
ATOM   6685  OE1 GLN E 118      11.698  69.494  13.493  1.00 48.38           O  
ATOM   6686  NE2 GLN E 118      13.037  68.674  15.077  1.00 43.21           N  
ATOM   6687  N   THR E 119      15.347  74.050  12.520  1.00 29.50           N  
ATOM   6688  CA  THR E 119      15.808  74.504  11.233  1.00 32.28           C  
ATOM   6689  C   THR E 119      17.344  74.740  11.243  1.00 34.28           C  
ATOM   6690  O   THR E 119      18.063  74.369  10.298  1.00 35.35           O  
ATOM   6691  CB  THR E 119      15.005  75.774  10.807  1.00 37.25           C  
ATOM   6692  OG1 THR E 119      13.583  75.514  10.890  1.00 35.61           O  
ATOM   6693  CG2 THR E 119      15.344  76.209   9.394  1.00 38.43           C  
ATOM   6694  N   LEU E 120      17.861  75.321  12.320  1.00 35.70           N  
ATOM   6695  CA  LEU E 120      19.307  75.504  12.475  1.00 34.83           C  
ATOM   6696  C   LEU E 120      20.099  74.199  12.664  1.00 34.65           C  
ATOM   6697  O   LEU E 120      21.172  74.057  12.128  1.00 34.68           O  
ATOM   6698  CB  LEU E 120      19.618  76.504  13.582  1.00 37.68           C  
ATOM   6699  CG  LEU E 120      19.869  77.954  13.097  1.00 42.36           C  
ATOM   6700  CD1 LEU E 120      18.830  78.479  12.057  1.00 44.16           C  
ATOM   6701  CD2 LEU E 120      19.926  78.905  14.279  1.00 41.77           C  
ATOM   6702  N   GLN E 121      19.583  73.246  13.424  1.00 34.14           N  
ATOM   6703  CA  GLN E 121      20.137  71.890  13.417  1.00 33.67           C  
ATOM   6704  C   GLN E 121      20.215  71.244  12.018  1.00 31.75           C  
ATOM   6705  O   GLN E 121      21.172  70.551  11.747  1.00 31.13           O  
ATOM   6706  CB  GLN E 121      19.374  70.941  14.328  1.00 34.93           C  
ATOM   6707  CG  GLN E 121      19.246  71.377  15.735  1.00 34.87           C  
ATOM   6708  CD  GLN E 121      18.711  70.259  16.582  1.00 36.34           C  
ATOM   6709  OE1 GLN E 121      17.537  70.241  16.896  1.00 41.56           O  
ATOM   6710  NE2 GLN E 121      19.565  69.302  16.938  1.00 35.24           N  
ATOM   6711  N   LYS E 122      19.214  71.446  11.158  1.00 32.46           N  
ATOM   6712  CA  LYS E 122      19.260  70.936   9.764  1.00 37.90           C  
ATOM   6713  C   LYS E 122      20.396  71.568   8.949  1.00 35.07           C  
ATOM   6714  O   LYS E 122      21.046  70.890   8.182  1.00 32.41           O  
ATOM   6715  CB  LYS E 122      17.901  71.148   9.001  1.00 39.97           C  
ATOM   6716  CG  LYS E 122      16.806  70.102   9.309  1.00 40.97           C  
ATOM   6717  CD  LYS E 122      15.491  70.508   8.598  1.00 44.51           C  
ATOM   6718  CE  LYS E 122      14.314  69.436   8.625  1.00 45.77           C  
ATOM   6719  NZ  LYS E 122      13.117  69.717   7.618  1.00 46.86           N  
ATOM   6720  N   GLN E 123      20.607  72.869   9.136  1.00 34.47           N  
ATOM   6721  CA  GLN E 123      21.780  73.574   8.618  1.00 33.65           C  
ATOM   6722  C   GLN E 123      23.112  72.997   9.038  1.00 31.75           C  
ATOM   6723  O   GLN E 123      24.014  72.835   8.198  1.00 29.36           O  
ATOM   6724  CB  GLN E 123      21.705  75.034   9.068  1.00 36.07           C  
ATOM   6725  CG  GLN E 123      22.799  75.948   8.646  1.00 37.70           C  
ATOM   6726  CD  GLN E 123      22.817  76.217   7.171  1.00 39.95           C  
ATOM   6727  OE1 GLN E 123      23.742  75.815   6.450  1.00 40.50           O  
ATOM   6728  NE2 GLN E 123      21.818  76.916   6.712  1.00 41.89           N  
ATOM   6729  N   VAL E 124      23.249  72.733  10.344  1.00 32.80           N  
ATOM   6730  CA  VAL E 124      24.495  72.194  10.907  1.00 35.09           C  
ATOM   6731  C   VAL E 124      24.819  70.832  10.305  1.00 36.38           C  
ATOM   6732  O   VAL E 124      25.964  70.552   9.950  1.00 39.02           O  
ATOM   6733  CB  VAL E 124      24.449  72.051  12.456  1.00 35.50           C  
ATOM   6734  CG1 VAL E 124      25.586  71.079  13.002  1.00 34.63           C  
ATOM   6735  CG2 VAL E 124      24.535  73.436  13.132  1.00 35.63           C  
ATOM   6736  N   SER E 125      23.829  69.958  10.243  1.00 34.02           N  
ATOM   6737  CA  SER E 125      24.078  68.633   9.702  1.00 33.85           C  
ATOM   6738  C   SER E 125      24.383  68.696   8.216  1.00 34.49           C  
ATOM   6739  O   SER E 125      25.262  68.001   7.750  1.00 31.79           O  
ATOM   6740  CB  SER E 125      22.888  67.722   9.972  1.00 32.68           C  
ATOM   6741  OG  SER E 125      21.682  68.244   9.464  1.00 32.96           O  
ATOM   6742  N   TYR E 126      23.646  69.538   7.470  1.00 34.62           N  
ATOM   6743  CA  TYR E 126      23.907  69.739   6.047  1.00 32.12           C  
ATOM   6744  C   TYR E 126      25.320  70.198   5.675  1.00 32.74           C  
ATOM   6745  O   TYR E 126      25.951  69.641   4.760  1.00 32.29           O  
ATOM   6746  CB  TYR E 126      22.929  70.734   5.524  1.00 35.85           C  
ATOM   6747  CG  TYR E 126      23.008  70.945   4.047  1.00 34.64           C  
ATOM   6748  CD1 TYR E 126      22.490  70.010   3.161  1.00 33.96           C  
ATOM   6749  CD2 TYR E 126      23.629  72.081   3.533  1.00 33.73           C  
ATOM   6750  CE1 TYR E 126      22.560  70.239   1.738  1.00 36.92           C  
ATOM   6751  CE2 TYR E 126      23.727  72.314   2.184  1.00 35.85           C  
ATOM   6752  CZ  TYR E 126      23.178  71.412   1.286  1.00 37.03           C  
ATOM   6753  OH  TYR E 126      23.296  71.721  -0.043  1.00 39.53           O  
ATOM   6754  N   SER E 127      25.796  71.224   6.375  1.00 36.10           N  
ATOM   6755  CA  SER E 127      27.171  71.724   6.293  1.00 37.56           C  
ATOM   6756  C   SER E 127      28.271  70.715   6.574  1.00 40.30           C  
ATOM   6757  O   SER E 127      29.370  70.748   5.931  1.00 38.99           O  
ATOM   6758  CB  SER E 127      27.388  72.809   7.334  1.00 38.13           C  
ATOM   6759  OG  SER E 127      26.980  74.089   6.946  1.00 37.86           O  
ATOM   6760  N   LEU E 128      28.034  69.898   7.607  1.00 37.67           N  
ATOM   6761  CA  LEU E 128      28.934  68.801   7.907  1.00 36.78           C  
ATOM   6762  C   LEU E 128      29.034  67.772   6.758  1.00 35.60           C  
ATOM   6763  O   LEU E 128      30.139  67.384   6.353  1.00 33.35           O  
ATOM   6764  CB  LEU E 128      28.500  68.117   9.197  1.00 37.42           C  
ATOM   6765  CG  LEU E 128      28.725  68.893  10.503  1.00 40.05           C  
ATOM   6766  CD1 LEU E 128      28.225  68.034  11.705  1.00 38.94           C  
ATOM   6767  CD2 LEU E 128      30.187  69.284  10.727  1.00 38.85           C  
ATOM   6768  N   ALA E 129      27.878  67.344   6.229  1.00 33.99           N  
ATOM   6769  CA  ALA E 129      27.829  66.385   5.135  1.00 32.59           C  
ATOM   6770  C   ALA E 129      28.547  66.968   3.923  1.00 37.77           C  
ATOM   6771  O   ALA E 129      29.359  66.268   3.297  1.00 34.98           O  
ATOM   6772  CB  ALA E 129      26.419  66.038   4.793  1.00 33.21           C  
ATOM   6773  N   LYS E 130      28.210  68.230   3.591  1.00 39.30           N  
ATOM   6774  CA  LYS E 130      28.772  68.953   2.436  1.00 39.48           C  
ATOM   6775  C   LYS E 130      30.297  69.060   2.570  1.00 41.53           C  
ATOM   6776  O   LYS E 130      31.027  68.820   1.618  1.00 41.25           O  
ATOM   6777  CB  LYS E 130      28.096  70.342   2.309  1.00 38.79           C  
ATOM   6778  CG  LYS E 130      28.444  71.181   1.049  1.00 40.06           C  
ATOM   6779  CD  LYS E 130      27.521  72.394   0.843  1.00 40.92           C  
ATOM   6780  CE  LYS E 130      27.780  73.095  -0.469  1.00 41.39           C  
ATOM   6781  NZ  LYS E 130      26.795  74.189  -0.843  1.00 43.53           N  
ATOM   6782  N   PHE E 131      30.787  69.364   3.760  1.00 43.03           N  
ATOM   6783  CA  PHE E 131      32.243  69.510   3.960  1.00 44.72           C  
ATOM   6784  C   PHE E 131      32.972  68.190   3.757  1.00 42.15           C  
ATOM   6785  O   PHE E 131      33.998  68.154   3.094  1.00 43.15           O  
ATOM   6786  CB  PHE E 131      32.605  70.165   5.331  1.00 46.70           C  
ATOM   6787  CG  PHE E 131      34.083  70.418   5.502  1.00 46.95           C  
ATOM   6788  CD1 PHE E 131      34.642  71.604   5.130  1.00 49.10           C  
ATOM   6789  CD2 PHE E 131      34.913  69.445   6.015  1.00 49.97           C  
ATOM   6790  CE1 PHE E 131      36.040  71.826   5.268  1.00 50.93           C  
ATOM   6791  CE2 PHE E 131      36.296  69.645   6.138  1.00 51.00           C  
ATOM   6792  CZ  PHE E 131      36.853  70.843   5.760  1.00 49.87           C  
ATOM   6793  N   ASN E 132      32.462  67.105   4.312  1.00 41.84           N  
ATOM   6794  CA  ASN E 132      33.069  65.782   4.057  1.00 41.32           C  
ATOM   6795  C   ASN E 132      33.169  65.494   2.572  1.00 37.60           C  
ATOM   6796  O   ASN E 132      34.224  65.226   2.070  1.00 37.88           O  
ATOM   6797  CB  ASN E 132      32.241  64.662   4.747  1.00 45.46           C  
ATOM   6798  CG  ASN E 132      32.686  63.207   4.362  1.00 45.59           C  
ATOM   6799  OD1 ASN E 132      32.363  62.670   3.275  1.00 51.78           O  
ATOM   6800  ND2 ASN E 132      33.372  62.578   5.266  1.00 44.76           N  
ATOM   6801  N   ASP E 133      32.043  65.542   1.882  1.00 37.25           N  
ATOM   6802  CA  ASP E 133      31.974  65.193   0.465  1.00 37.01           C  
ATOM   6803  C   ASP E 133      32.926  66.084  -0.400  1.00 37.50           C  
ATOM   6804  O   ASP E 133      33.545  65.584  -1.342  1.00 36.22           O  
ATOM   6805  CB  ASP E 133      30.508  65.266   0.001  1.00 36.36           C  
ATOM   6806  CG  ASP E 133      29.637  64.069   0.511  1.00 38.59           C  
ATOM   6807  OD1 ASP E 133      30.138  63.098   1.172  1.00 37.86           O  
ATOM   6808  OD2 ASP E 133      28.430  64.093   0.171  1.00 38.14           O  
ATOM   6809  N   PHE E 134      33.042  67.382  -0.065  1.00 36.54           N  
ATOM   6810  CA  PHE E 134      33.851  68.337  -0.850  1.00 36.52           C  
ATOM   6811  C   PHE E 134      35.363  68.179  -0.567  1.00 39.21           C  
ATOM   6812  O   PHE E 134      36.196  68.511  -1.396  1.00 40.86           O  
ATOM   6813  CB  PHE E 134      33.453  69.784  -0.544  1.00 36.40           C  
ATOM   6814  CG  PHE E 134      32.311  70.323  -1.362  1.00 34.84           C  
ATOM   6815  CD1 PHE E 134      31.054  69.722  -1.346  1.00 35.98           C  
ATOM   6816  CD2 PHE E 134      32.482  71.455  -2.126  1.00 36.57           C  
ATOM   6817  CE1 PHE E 134      29.999  70.241  -2.106  1.00 35.85           C  
ATOM   6818  CE2 PHE E 134      31.405  71.974  -2.917  1.00 36.72           C  
ATOM   6819  CZ  PHE E 134      30.177  71.373  -2.875  1.00 35.44           C  
ATOM   6820  N   SER E 135      35.687  67.676   0.610  1.00 40.70           N  
ATOM   6821  CA  SER E 135      37.056  67.475   1.046  1.00 44.78           C  
ATOM   6822  C   SER E 135      37.749  66.263   0.426  1.00 44.50           C  
ATOM   6823  O   SER E 135      38.889  66.354   0.012  1.00 45.56           O  
ATOM   6824  CB  SER E 135      37.089  67.335   2.577  1.00 46.69           C  
ATOM   6825  OG  SER E 135      36.335  68.378   3.197  1.00 49.69           O  
ATOM   6826  N   ILE E 136      37.071  65.132   0.353  1.00 46.45           N  
ATOM   6827  CA  ILE E 136      37.752  63.883   0.015  1.00 47.04           C  
ATOM   6828  C   ILE E 136      38.333  63.798  -1.407  1.00 46.80           C  
ATOM   6829  O   ILE E 136      39.456  63.280  -1.557  1.00 46.60           O  
ATOM   6830  CB  ILE E 136      36.844  62.620   0.207  1.00 49.43           C  
ATOM   6831  CG1 ILE E 136      36.133  62.625   1.545  1.00 50.55           C  
ATOM   6832  CG2 ILE E 136      37.682  61.338   0.115  1.00 50.54           C  
ATOM   6833  CD1 ILE E 136      37.021  63.078   2.725  1.00 51.73           C  
ATOM   6834  N   ASN E 137      37.605  64.248  -2.444  1.00 41.85           N  
ATOM   6835  CA  ASN E 137      38.008  63.864  -3.826  1.00 39.40           C  
ATOM   6836  C   ASN E 137      38.332  65.045  -4.723  1.00 38.61           C  
ATOM   6837  O   ASN E 137      37.979  65.108  -5.925  1.00 37.15           O  
ATOM   6838  CB  ASN E 137      36.949  62.952  -4.436  1.00 37.45           C  
ATOM   6839  CG  ASN E 137      36.991  61.551  -3.869  1.00 36.78           C  
ATOM   6840  OD1 ASN E 137      37.984  60.823  -4.056  1.00 38.68           O  
ATOM   6841  ND2 ASN E 137      35.907  61.141  -3.193  1.00 32.35           N  
ATOM   6842  N   GLY E 138      39.001  66.004  -4.100  1.00 38.78           N  
ATOM   6843  CA  GLY E 138      39.328  67.257  -4.733  1.00 38.05           C  
ATOM   6844  C   GLY E 138      38.129  67.927  -5.374  1.00 38.98           C  
ATOM   6845  O   GLY E 138      36.982  67.763  -4.929  1.00 36.01           O  
ATOM   6846  N   LYS E 139      38.439  68.707  -6.404  1.00 37.50           N  
ATOM   6847  CA  LYS E 139      37.489  69.502  -7.159  1.00 39.52           C  
ATOM   6848  C   LYS E 139      36.450  68.671  -7.974  1.00 36.81           C  
ATOM   6849  O   LYS E 139      35.339  69.143  -8.227  1.00 34.69           O  
ATOM   6850  CB  LYS E 139      38.285  70.475  -8.060  1.00 40.13           C  
ATOM   6851  CG  LYS E 139      39.084  71.590  -7.290  1.00 41.64           C  
ATOM   6852  CD  LYS E 139      38.292  72.242  -6.101  1.00 42.47           C  
ATOM   6853  CE  LYS E 139      39.090  73.403  -5.469  1.00 41.28           C  
ATOM   6854  NZ  LYS E 139      38.280  74.276  -4.548  1.00 41.89           N  
ATOM   6855  N   LEU E 140      36.836  67.455  -8.373  1.00 38.03           N  
ATOM   6856  CA  LEU E 140      35.967  66.478  -9.059  1.00 36.80           C  
ATOM   6857  C   LEU E 140      34.835  66.095  -8.150  1.00 35.51           C  
ATOM   6858  O   LEU E 140      33.699  66.066  -8.581  1.00 37.63           O  
ATOM   6859  CB  LEU E 140      36.738  65.204  -9.420  1.00 39.41           C  
ATOM   6860  CG  LEU E 140      36.318  64.270 -10.571  1.00 40.34           C  
ATOM   6861  CD1 LEU E 140      36.700  62.774 -10.332  1.00 40.51           C  
ATOM   6862  CD2 LEU E 140      34.867  64.361 -10.990  1.00 41.23           C  
ATOM   6863  N   GLY E 141      35.156  65.757  -6.903  1.00 33.29           N  
ATOM   6864  CA  GLY E 141      34.158  65.461  -5.923  1.00 34.20           C  
ATOM   6865  C   GLY E 141      33.255  66.615  -5.590  1.00 34.75           C  
ATOM   6866  O   GLY E 141      32.040  66.416  -5.344  1.00 34.96           O  
ATOM   6867  N   SER E 142      33.851  67.815  -5.562  1.00 32.42           N  
ATOM   6868  CA  SER E 142      33.142  69.066  -5.313  1.00 36.17           C  
ATOM   6869  C   SER E 142      32.074  69.418  -6.338  1.00 35.55           C  
ATOM   6870  O   SER E 142      30.944  69.770  -5.966  1.00 33.98           O  
ATOM   6871  CB  SER E 142      34.126  70.245  -5.246  1.00 36.15           C  
ATOM   6872  OG  SER E 142      34.845  70.148  -4.057  1.00 40.80           O  
ATOM   6873  N   ILE E 143      32.427  69.342  -7.615  1.00 35.99           N  
ATOM   6874  CA  ILE E 143      31.443  69.582  -8.705  1.00 35.92           C  
ATOM   6875  C   ILE E 143      30.373  68.455  -8.723  1.00 37.53           C  
ATOM   6876  O   ILE E 143      29.147  68.739  -8.882  1.00 38.85           O  
ATOM   6877  CB  ILE E 143      32.155  69.680 -10.081  1.00 39.10           C  
ATOM   6878  CG1 ILE E 143      33.024  70.943 -10.177  1.00 38.70           C  
ATOM   6879  CG2 ILE E 143      31.147  69.550 -11.260  1.00 40.27           C  
ATOM   6880  CD1 ILE E 143      32.258  72.233 -10.349  1.00 39.86           C  
ATOM   6881  N   CYS E 144      30.813  67.192  -8.575  1.00 33.78           N  
ATOM   6882  CA  CYS E 144      29.866  66.061  -8.480  1.00 35.63           C  
ATOM   6883  C   CYS E 144      28.801  66.189  -7.344  1.00 34.09           C  
ATOM   6884  O   CYS E 144      27.618  65.880  -7.531  1.00 34.70           O  
ATOM   6885  CB  CYS E 144      30.617  64.731  -8.379  1.00 36.98           C  
ATOM   6886  SG  CYS E 144      31.398  64.191  -9.937  1.00 43.53           S  
ATOM   6887  N   SER E 145      29.241  66.626  -6.175  1.00 35.07           N  
ATOM   6888  CA  SER E 145      28.388  66.806  -4.985  1.00 33.94           C  
ATOM   6889  C   SER E 145      27.495  68.012  -5.161  1.00 32.11           C  
ATOM   6890  O   SER E 145      26.358  67.976  -4.747  1.00 33.66           O  
ATOM   6891  CB  SER E 145      29.232  67.062  -3.688  1.00 33.90           C  
ATOM   6892  OG  SER E 145      30.247  66.086  -3.429  1.00 34.05           O  
ATOM   6893  N   GLN E 146      27.995  69.103  -5.749  1.00 34.24           N  
ATOM   6894  CA  GLN E 146      27.070  70.218  -6.087  1.00 33.49           C  
ATOM   6895  C   GLN E 146      26.017  69.832  -7.119  1.00 33.52           C  
ATOM   6896  O   GLN E 146      24.842  70.104  -6.946  1.00 32.56           O  
ATOM   6897  CB  GLN E 146      27.794  71.485  -6.493  1.00 33.64           C  
ATOM   6898  CG  GLN E 146      26.884  72.750  -6.422  1.00 34.57           C  
ATOM   6899  CD  GLN E 146      26.413  73.131  -5.026  1.00 32.54           C  
ATOM   6900  OE1 GLN E 146      25.210  73.390  -4.799  1.00 40.53           O  
ATOM   6901  NE2 GLN E 146      27.325  73.165  -4.088  1.00 34.90           N  
ATOM   6902  N   LEU E 147      26.412  69.125  -8.154  1.00 34.00           N  
ATOM   6903  CA  LEU E 147      25.393  68.514  -9.057  1.00 35.36           C  
ATOM   6904  C   LEU E 147      24.376  67.591  -8.371  1.00 35.94           C  
ATOM   6905  O   LEU E 147      23.244  67.731  -8.686  1.00 34.74           O  
ATOM   6906  CB  LEU E 147      26.025  67.784 -10.267  1.00 33.47           C  
ATOM   6907  CG  LEU E 147      26.903  68.641 -11.211  1.00 32.50           C  
ATOM   6908  CD1 LEU E 147      27.768  67.745 -12.092  1.00 29.69           C  
ATOM   6909  CD2 LEU E 147      26.069  69.564 -12.033  1.00 35.37           C  
ATOM   6910  N   LEU E 148      24.774  66.667  -7.477  1.00 34.82           N  
ATOM   6911  CA  LEU E 148      23.797  65.860  -6.711  1.00 35.51           C  
ATOM   6912  C   LEU E 148      22.780  66.707  -5.896  1.00 32.76           C  
ATOM   6913  O   LEU E 148      21.541  66.483  -5.962  1.00 31.50           O  
ATOM   6914  CB  LEU E 148      24.520  64.804  -5.804  1.00 37.28           C  
ATOM   6915  CG  LEU E 148      23.692  63.896  -4.838  1.00 39.57           C  
ATOM   6916  CD1 LEU E 148      24.061  62.385  -4.841  1.00 38.28           C  
ATOM   6917  CD2 LEU E 148      23.810  64.352  -3.361  1.00 42.15           C  
ATOM   6918  N   ILE E 149      23.291  67.668  -5.122  1.00 32.73           N  
ATOM   6919  CA  ILE E 149      22.432  68.625  -4.438  1.00 31.85           C  
ATOM   6920  C   ILE E 149      21.395  69.240  -5.392  1.00 31.36           C  
ATOM   6921  O   ILE E 149      20.222  69.270  -5.112  1.00 32.92           O  
ATOM   6922  CB  ILE E 149      23.256  69.768  -3.812  1.00 33.13           C  
ATOM   6923  CG1 ILE E 149      23.964  69.282  -2.536  1.00 34.21           C  
ATOM   6924  CG2 ILE E 149      22.298  70.987  -3.483  1.00 34.45           C  
ATOM   6925  CD1 ILE E 149      25.213  70.016  -2.140  1.00 32.61           C  
ATOM   6926  N   LEU E 150      21.840  69.781  -6.513  1.00 35.37           N  
ATOM   6927  CA  LEU E 150      20.916  70.507  -7.383  1.00 38.50           C  
ATOM   6928  C   LEU E 150      19.901  69.551  -8.008  1.00 37.12           C  
ATOM   6929  O   LEU E 150      18.781  69.927  -8.300  1.00 37.68           O  
ATOM   6930  CB  LEU E 150      21.690  71.261  -8.450  1.00 38.58           C  
ATOM   6931  CG  LEU E 150      22.169  72.703  -8.187  1.00 40.77           C  
ATOM   6932  CD1 LEU E 150      21.943  73.292  -6.782  1.00 42.07           C  
ATOM   6933  CD2 LEU E 150      23.588  72.861  -8.635  1.00 42.18           C  
ATOM   6934  N   THR E 151      20.317  68.309  -8.212  1.00 36.65           N  
ATOM   6935  CA  THR E 151      19.455  67.301  -8.773  1.00 37.92           C  
ATOM   6936  C   THR E 151      18.292  66.963  -7.810  1.00 38.02           C  
ATOM   6937  O   THR E 151      17.154  66.895  -8.244  1.00 39.39           O  
ATOM   6938  CB  THR E 151      20.278  66.017  -9.150  1.00 37.36           C  
ATOM   6939  OG1 THR E 151      21.325  66.386 -10.019  1.00 35.69           O  
ATOM   6940  CG2 THR E 151      19.439  65.024  -9.899  1.00 38.12           C  
ATOM   6941  N   TYR E 152      18.571  66.756  -6.522  1.00 37.17           N  
ATOM   6942  CA  TYR E 152      17.503  66.413  -5.567  1.00 38.96           C  
ATOM   6943  C   TYR E 152      16.631  67.601  -5.366  1.00 40.10           C  
ATOM   6944  O   TYR E 152      15.410  67.472  -5.369  1.00 37.90           O  
ATOM   6945  CB  TYR E 152      18.033  65.978  -4.196  1.00 37.78           C  
ATOM   6946  CG  TYR E 152      18.447  64.556  -4.165  1.00 36.94           C  
ATOM   6947  CD1 TYR E 152      17.509  63.538  -4.371  1.00 40.02           C  
ATOM   6948  CD2 TYR E 152      19.773  64.205  -3.942  1.00 34.84           C  
ATOM   6949  CE1 TYR E 152      17.900  62.192  -4.360  1.00 39.46           C  
ATOM   6950  CE2 TYR E 152      20.159  62.902  -3.925  1.00 37.13           C  
ATOM   6951  CZ  TYR E 152      19.236  61.886  -4.132  1.00 37.75           C  
ATOM   6952  OH  TYR E 152      19.653  60.565  -4.075  1.00 37.95           O  
ATOM   6953  N   VAL E 153      17.255  68.782  -5.229  1.00 39.90           N  
ATOM   6954  CA  VAL E 153      16.434  69.972  -4.961  1.00 36.36           C  
ATOM   6955  C   VAL E 153      15.695  70.501  -6.183  1.00 33.44           C  
ATOM   6956  O   VAL E 153      14.562  70.973  -6.029  1.00 31.71           O  
ATOM   6957  CB  VAL E 153      17.191  71.095  -4.258  1.00 36.10           C  
ATOM   6958  CG1 VAL E 153      16.211  72.123  -3.797  1.00 35.66           C  
ATOM   6959  CG2 VAL E 153      17.973  70.585  -2.990  1.00 38.99           C  
ATOM   6960  N   TYR E 154      16.296  70.471  -7.378  1.00 34.43           N  
ATOM   6961  CA  TYR E 154      15.667  71.132  -8.567  1.00 37.37           C  
ATOM   6962  C   TYR E 154      15.397  70.271  -9.820  1.00 37.46           C  
ATOM   6963  O   TYR E 154      15.039  70.819 -10.884  1.00 38.01           O  
ATOM   6964  CB  TYR E 154      16.514  72.345  -8.996  1.00 39.50           C  
ATOM   6965  CG  TYR E 154      16.602  73.338  -7.907  1.00 40.45           C  
ATOM   6966  CD1 TYR E 154      15.492  74.104  -7.557  1.00 38.94           C  
ATOM   6967  CD2 TYR E 154      17.787  73.474  -7.160  1.00 40.60           C  
ATOM   6968  CE1 TYR E 154      15.563  75.008  -6.481  1.00 41.72           C  
ATOM   6969  CE2 TYR E 154      17.873  74.370  -6.107  1.00 41.03           C  
ATOM   6970  CZ  TYR E 154      16.773  75.141  -5.775  1.00 40.71           C  
ATOM   6971  OH  TYR E 154      16.896  75.991  -4.715  1.00 40.89           O  
ATOM   6972  N   GLY E 155      15.566  68.960  -9.682  1.00 37.03           N  
ATOM   6973  CA  GLY E 155      15.481  68.016 -10.785  1.00 38.70           C  
ATOM   6974  C   GLY E 155      14.076  67.620 -11.204  1.00 40.27           C  
ATOM   6975  O   GLY E 155      13.212  67.415 -10.369  1.00 40.27           O  
ATOM   6976  N   LYS E 156      13.849  67.504 -12.507  1.00 41.33           N  
ATOM   6977  CA  LYS E 156      12.656  66.853 -13.021  1.00 44.86           C  
ATOM   6978  C   LYS E 156      12.973  65.773 -14.068  1.00 43.10           C  
ATOM   6979  O   LYS E 156      13.821  65.939 -14.943  1.00 39.65           O  
ATOM   6980  CB  LYS E 156      11.725  67.917 -13.641  1.00 48.64           C  
ATOM   6981  CG  LYS E 156      11.196  68.955 -12.641  1.00 50.46           C  
ATOM   6982  CD  LYS E 156       9.973  69.744 -13.191  1.00 52.81           C  
ATOM   6983  CE  LYS E 156       9.295  70.574 -12.081  1.00 53.51           C  
ATOM   6984  NZ  LYS E 156       8.887  69.702 -10.919  1.00 54.28           N  
ATOM   6985  N   GLU E 157      12.229  64.684 -14.016  1.00 44.78           N  
ATOM   6986  CA  GLU E 157      12.389  63.595 -14.961  1.00 47.68           C  
ATOM   6987  C   GLU E 157      11.929  63.976 -16.394  1.00 45.22           C  
ATOM   6988  O   GLU E 157      10.819  64.452 -16.627  1.00 42.25           O  
ATOM   6989  CB  GLU E 157      11.638  62.355 -14.463  1.00 52.63           C  
ATOM   6990  CG  GLU E 157      12.133  61.825 -13.091  1.00 57.39           C  
ATOM   6991  CD  GLU E 157      11.384  62.426 -11.827  1.00 62.22           C  
ATOM   6992  OE1 GLU E 157      10.438  63.278 -11.928  1.00 63.55           O  
ATOM   6993  OE2 GLU E 157      11.760  62.019 -10.697  1.00 65.29           O  
ATOM   6994  N   THR E 158      12.825  63.758 -17.341  1.00 44.05           N  
ATOM   6995  CA  THR E 158      12.553  63.931 -18.762  1.00 45.27           C  
ATOM   6996  C   THR E 158      12.973  62.648 -19.487  1.00 44.12           C  
ATOM   6997  O   THR E 158      13.696  61.834 -18.935  1.00 43.49           O  
ATOM   6998  CB  THR E 158      13.351  65.127 -19.324  1.00 43.91           C  
ATOM   6999  OG1 THR E 158      14.747  64.833 -19.238  1.00 46.44           O  
ATOM   7000  CG2 THR E 158      13.080  66.386 -18.526  1.00 43.12           C  
ATOM   7001  N   PRO E 159      12.541  62.461 -20.732  1.00 44.00           N  
ATOM   7002  CA  PRO E 159      13.118  61.279 -21.398  1.00 44.49           C  
ATOM   7003  C   PRO E 159      14.669  61.332 -21.613  1.00 45.65           C  
ATOM   7004  O   PRO E 159      15.279  60.303 -21.875  1.00 43.88           O  
ATOM   7005  CB  PRO E 159      12.326  61.178 -22.737  1.00 44.87           C  
ATOM   7006  CG  PRO E 159      11.136  62.161 -22.624  1.00 43.80           C  
ATOM   7007  CD  PRO E 159      11.563  63.192 -21.571  1.00 44.82           C  
ATOM   7008  N   ASP E 160      15.294  62.496 -21.452  1.00 46.60           N  
ATOM   7009  CA  ASP E 160      16.748  62.639 -21.617  1.00 47.45           C  
ATOM   7010  C   ASP E 160      17.588  62.710 -20.306  1.00 47.18           C  
ATOM   7011  O   ASP E 160      18.773  63.120 -20.315  1.00 42.18           O  
ATOM   7012  CB  ASP E 160      17.013  63.862 -22.480  1.00 49.89           C  
ATOM   7013  CG  ASP E 160      16.199  63.849 -23.785  1.00 53.72           C  
ATOM   7014  OD1 ASP E 160      15.942  62.743 -24.338  1.00 56.91           O  
ATOM   7015  OD2 ASP E 160      15.815  64.949 -24.253  1.00 53.76           O  
ATOM   7016  N   GLY E 161      16.958  62.296 -19.201  1.00 46.21           N  
ATOM   7017  CA  GLY E 161      17.579  62.260 -17.891  1.00 43.71           C  
ATOM   7018  C   GLY E 161      16.916  63.210 -16.903  1.00 42.85           C  
ATOM   7019  O   GLY E 161      15.775  63.641 -17.102  1.00 40.98           O  
ATOM   7020  N   ILE E 162      17.628  63.539 -15.825  1.00 41.02           N  
ATOM   7021  CA  ILE E 162      17.056  64.411 -14.800  1.00 43.54           C  
ATOM   7022  C   ILE E 162      17.476  65.863 -15.053  1.00 44.20           C  
ATOM   7023  O   ILE E 162      18.632  66.223 -14.809  1.00 44.78           O  
ATOM   7024  CB  ILE E 162      17.442  63.967 -13.370  1.00 42.75           C  
ATOM   7025  CG1 ILE E 162      17.048  62.497 -13.139  1.00 40.50           C  
ATOM   7026  CG2 ILE E 162      16.727  64.868 -12.347  1.00 43.04           C  
ATOM   7027  CD1 ILE E 162      17.893  61.794 -12.088  1.00 39.06           C  
ATOM   7028  N   LYS E 163      16.529  66.679 -15.525  1.00 42.23           N  
ATOM   7029  CA  LYS E 163      16.796  68.076 -15.869  1.00 42.41           C  
ATOM   7030  C   LYS E 163      16.889  68.969 -14.642  1.00 39.52           C  
ATOM   7031  O   LYS E 163      15.933  69.056 -13.860  1.00 39.51           O  
ATOM   7032  CB  LYS E 163      15.706  68.623 -16.814  1.00 42.03           C  
ATOM   7033  CG  LYS E 163      15.833  70.128 -17.060  1.00 44.58           C  
ATOM   7034  CD  LYS E 163      15.037  70.629 -18.283  1.00 47.01           C  
ATOM   7035  CE  LYS E 163      13.632  71.064 -17.924  1.00 48.76           C  
ATOM   7036  NZ  LYS E 163      13.147  72.138 -18.842  1.00 52.43           N  
ATOM   7037  N   ILE E 164      18.009  69.670 -14.501  1.00 37.62           N  
ATOM   7038  CA  ILE E 164      18.178  70.623 -13.415  1.00 39.42           C  
ATOM   7039  C   ILE E 164      17.520  71.946 -13.845  1.00 41.69           C  
ATOM   7040  O   ILE E 164      18.060  72.704 -14.677  1.00 38.32           O  
ATOM   7041  CB  ILE E 164      19.654  70.843 -13.003  1.00 38.67           C  
ATOM   7042  CG1 ILE E 164      20.195  69.605 -12.307  1.00 41.23           C  
ATOM   7043  CG2 ILE E 164      19.770  72.018 -12.023  1.00 36.98           C  
ATOM   7044  CD1 ILE E 164      21.720  69.656 -12.002  1.00 41.91           C  
ATOM   7045  N   THR E 165      16.359  72.207 -13.259  1.00 45.45           N  
ATOM   7046  CA  THR E 165      15.477  73.280 -13.760  1.00 50.93           C  
ATOM   7047  C   THR E 165      15.777  74.561 -13.008  1.00 53.20           C  
ATOM   7048  O   THR E 165      14.923  75.381 -12.877  1.00 54.09           O  
ATOM   7049  CB  THR E 165      13.978  72.949 -13.553  1.00 50.01           C  
ATOM   7050  OG1 THR E 165      13.710  72.872 -12.153  1.00 50.51           O  
ATOM   7051  CG2 THR E 165      13.626  71.628 -14.177  1.00 49.49           C  
ATOM   7052  N   LEU E 166      16.995  74.677 -12.492  1.00 57.19           N  
ATOM   7053  CA  LEU E 166      17.504  75.894 -11.892  1.00 58.73           C  
ATOM   7054  C   LEU E 166      17.722  76.917 -13.007  1.00 62.57           C  
ATOM   7055  O   LEU E 166      18.193  76.591 -14.118  1.00 62.19           O  
ATOM   7056  CB  LEU E 166      18.826  75.609 -11.155  1.00 58.36           C  
ATOM   7057  CG  LEU E 166      19.124  76.214  -9.790  1.00 58.34           C  
ATOM   7058  CD1 LEU E 166      20.600  76.354  -9.656  1.00 58.99           C  
ATOM   7059  CD2 LEU E 166      18.516  77.554  -9.598  1.00 59.79           C  
ATOM   7060  N   ASP E 167      17.375  78.158 -12.674  1.00 64.93           N  
ATOM   7061  CA  ASP E 167      17.152  79.233 -13.628  1.00 66.12           C  
ATOM   7062  C   ASP E 167      18.384  79.534 -14.496  1.00 64.14           C  
ATOM   7063  O   ASP E 167      18.342  79.398 -15.731  1.00 65.24           O  
ATOM   7064  CB  ASP E 167      16.718  80.526 -12.877  1.00 68.83           C  
ATOM   7065  CG  ASP E 167      15.439  80.348 -11.994  1.00 70.09           C  
ATOM   7066  OD1 ASP E 167      15.224  79.278 -11.332  1.00 68.45           O  
ATOM   7067  OD2 ASP E 167      14.645  81.323 -11.981  1.00 71.03           O  
ATOM   7068  N   ASN E 168      19.472  79.959 -13.859  1.00 59.86           N  
ATOM   7069  CA  ASN E 168      20.598  80.548 -14.609  1.00 58.84           C  
ATOM   7070  C   ASN E 168      21.967  79.841 -14.276  1.00 56.84           C  
ATOM   7071  O   ASN E 168      22.985  80.464 -13.859  1.00 54.05           O  
ATOM   7072  CB  ASN E 168      20.546  82.091 -14.404  1.00 58.74           C  
ATOM   7073  CG  ASN E 168      19.223  82.745 -15.054  1.00 60.50           C  
ATOM   7074  OD1 ASN E 168      19.125  82.889 -16.301  1.00 56.97           O  
ATOM   7075  ND2 ASN E 168      18.222  83.088 -14.204  1.00 54.92           N  
ATOM   7076  N   LEU E 169      21.956  78.508 -14.429  1.00 53.57           N  
ATOM   7077  CA  LEU E 169      23.076  77.690 -13.985  1.00 50.92           C  
ATOM   7078  C   LEU E 169      24.078  77.531 -15.129  1.00 50.64           C  
ATOM   7079  O   LEU E 169      23.838  76.832 -16.091  1.00 51.47           O  
ATOM   7080  CB  LEU E 169      22.615  76.324 -13.452  1.00 50.36           C  
ATOM   7081  CG  LEU E 169      23.710  75.426 -12.872  1.00 47.67           C  
ATOM   7082  CD1 LEU E 169      24.298  76.012 -11.561  1.00 47.78           C  
ATOM   7083  CD2 LEU E 169      23.134  74.062 -12.624  1.00 48.97           C  
ATOM   7084  N   THR E 170      25.200  78.203 -14.968  1.00 50.79           N  
ATOM   7085  CA  THR E 170      26.276  78.243 -15.890  1.00 51.64           C  
ATOM   7086  C   THR E 170      27.496  77.590 -15.222  1.00 52.26           C  
ATOM   7087  O   THR E 170      27.507  77.347 -14.016  1.00 49.86           O  
ATOM   7088  CB  THR E 170      26.604  79.731 -16.198  1.00 53.26           C  
ATOM   7089  OG1 THR E 170      27.128  80.390 -15.027  1.00 51.12           O  
ATOM   7090  CG2 THR E 170      25.341  80.485 -16.663  1.00 54.50           C  
ATOM   7091  N   MET E 171      28.520  77.355 -16.024  1.00 52.85           N  
ATOM   7092  CA  MET E 171      29.841  76.902 -15.588  1.00 53.68           C  
ATOM   7093  C   MET E 171      30.501  77.772 -14.514  1.00 52.41           C  
ATOM   7094  O   MET E 171      31.113  77.241 -13.589  1.00 50.94           O  
ATOM   7095  CB  MET E 171      30.788  76.956 -16.808  1.00 57.36           C  
ATOM   7096  CG  MET E 171      31.994  76.062 -16.778  1.00 58.84           C  
ATOM   7097  SD  MET E 171      31.486  74.540 -17.573  1.00 63.70           S  
ATOM   7098  CE  MET E 171      31.597  74.986 -19.296  1.00 63.22           C  
ATOM   7099  N   GLN E 172      30.457  79.101 -14.700  1.00 49.38           N  
ATOM   7100  CA  GLN E 172      31.029  80.041 -13.733  1.00 48.30           C  
ATOM   7101  C   GLN E 172      30.303  79.959 -12.370  1.00 47.15           C  
ATOM   7102  O   GLN E 172      30.958  79.976 -11.326  1.00 45.24           O  
ATOM   7103  CB  GLN E 172      31.070  81.506 -14.265  1.00 49.40           C  
ATOM   7104  CG  GLN E 172      31.917  82.531 -13.367  1.00 51.15           C  
ATOM   7105  CD  GLN E 172      33.422  82.719 -13.836  1.00 54.09           C  
ATOM   7106  OE1 GLN E 172      33.705  82.816 -15.026  1.00 56.94           O  
ATOM   7107  NE2 GLN E 172      34.357  82.775 -12.887  1.00 55.41           N  
ATOM   7108  N   GLU E 173      28.967  79.863 -12.366  1.00 46.98           N  
ATOM   7109  CA  GLU E 173      28.222  79.675 -11.095  1.00 45.16           C  
ATOM   7110  C   GLU E 173      28.618  78.354 -10.396  1.00 45.48           C  
ATOM   7111  O   GLU E 173      28.995  78.351  -9.244  1.00 41.75           O  
ATOM   7112  CB  GLU E 173      26.723  79.726 -11.355  1.00 46.36           C  
ATOM   7113  CG  GLU E 173      26.214  81.127 -11.647  1.00 46.54           C  
ATOM   7114  CD  GLU E 173      26.341  82.032 -10.464  1.00 47.71           C  
ATOM   7115  OE1 GLU E 173      26.137  81.581  -9.295  1.00 50.32           O  
ATOM   7116  OE2 GLU E 173      26.671  83.195 -10.691  1.00 51.04           O  
ATOM   7117  N   LEU E 174      28.582  77.233 -11.131  1.00 47.25           N  
ATOM   7118  CA  LEU E 174      29.106  75.948 -10.631  1.00 47.86           C  
ATOM   7119  C   LEU E 174      30.483  76.056 -10.015  1.00 46.62           C  
ATOM   7120  O   LEU E 174      30.739  75.419  -9.026  1.00 51.56           O  
ATOM   7121  CB  LEU E 174      29.190  74.904 -11.756  1.00 49.74           C  
ATOM   7122  CG  LEU E 174      27.945  74.081 -11.979  1.00 52.05           C  
ATOM   7123  CD1 LEU E 174      28.087  73.341 -13.302  1.00 55.08           C  
ATOM   7124  CD2 LEU E 174      27.737  73.095 -10.815  1.00 52.06           C  
ATOM   7125  N   GLY E 175      31.373  76.836 -10.617  1.00 47.28           N  
ATOM   7126  CA  GLY E 175      32.730  77.059 -10.081  1.00 45.15           C  
ATOM   7127  C   GLY E 175      32.798  77.918  -8.832  1.00 44.08           C  
ATOM   7128  O   GLY E 175      33.708  77.731  -8.004  1.00 44.23           O  
ATOM   7129  N   TYR E 176      31.877  78.889  -8.702  1.00 41.67           N  
ATOM   7130  CA  TYR E 176      31.759  79.678  -7.462  1.00 40.68           C  
ATOM   7131  C   TYR E 176      31.365  78.785  -6.254  1.00 38.13           C  
ATOM   7132  O   TYR E 176      31.779  79.009  -5.067  1.00 34.62           O  
ATOM   7133  CB  TYR E 176      30.740  80.820  -7.628  1.00 43.25           C  
ATOM   7134  CG  TYR E 176      31.118  81.927  -8.590  1.00 44.01           C  
ATOM   7135  CD1 TYR E 176      32.441  82.116  -9.025  1.00 46.95           C  
ATOM   7136  CD2 TYR E 176      30.153  82.830  -9.044  1.00 45.74           C  
ATOM   7137  CE1 TYR E 176      32.796  83.167  -9.940  1.00 44.52           C  
ATOM   7138  CE2 TYR E 176      30.486  83.885  -9.948  1.00 44.93           C  
ATOM   7139  CZ  TYR E 176      31.801  84.044 -10.379  1.00 45.25           C  
ATOM   7140  OH  TYR E 176      32.116  85.083 -11.241  1.00 47.13           O  
ATOM   7141  N   SER E 177      30.578  77.764  -6.547  1.00 35.77           N  
ATOM   7142  CA  SER E 177      30.117  76.859  -5.495  1.00 41.91           C  
ATOM   7143  C   SER E 177      31.193  75.896  -5.029  1.00 43.18           C  
ATOM   7144  O   SER E 177      31.175  75.401  -3.896  1.00 39.23           O  
ATOM   7145  CB  SER E 177      28.879  76.084  -5.968  1.00 43.42           C  
ATOM   7146  OG  SER E 177      27.758  76.957  -6.077  1.00 46.01           O  
ATOM   7147  N   SER E 178      32.138  75.638  -5.918  1.00 45.65           N  
ATOM   7148  CA  SER E 178      33.144  74.639  -5.669  1.00 49.69           C  
ATOM   7149  C   SER E 178      34.522  75.243  -5.348  1.00 49.65           C  
ATOM   7150  O   SER E 178      35.456  74.479  -5.146  1.00 51.49           O  
ATOM   7151  CB  SER E 178      33.258  73.720  -6.899  1.00 51.14           C  
ATOM   7152  OG  SER E 178      33.966  74.399  -7.936  1.00 53.95           O  
ATOM   7153  N   GLY E 179      34.662  76.566  -5.302  1.00 46.58           N  
ATOM   7154  CA  GLY E 179      35.989  77.157  -5.092  1.00 50.78           C  
ATOM   7155  C   GLY E 179      36.966  77.172  -6.307  1.00 52.96           C  
ATOM   7156  O   GLY E 179      38.178  77.185  -6.132  1.00 54.22           O  
ATOM   7157  N   ILE E 180      36.444  77.188  -7.537  1.00 52.90           N  
ATOM   7158  CA  ILE E 180      37.265  77.303  -8.747  1.00 50.99           C  
ATOM   7159  C   ILE E 180      37.047  78.729  -9.360  1.00 49.39           C  
ATOM   7160  O   ILE E 180      35.966  79.078  -9.837  1.00 48.68           O  
ATOM   7161  CB  ILE E 180      36.926  76.102  -9.701  1.00 51.23           C  
ATOM   7162  CG1 ILE E 180      37.224  74.772  -8.999  1.00 49.94           C  
ATOM   7163  CG2 ILE E 180      37.735  76.127 -11.026  1.00 51.37           C  
ATOM   7164  CD1 ILE E 180      36.432  73.569  -9.552  1.00 48.89           C  
ATOM   7165  N   ALA E 181      38.055  79.591  -9.294  1.00 50.26           N  
ATOM   7166  CA  ALA E 181      37.899  80.951  -9.866  1.00 47.93           C  
ATOM   7167  C   ALA E 181      38.058  81.028 -11.416  1.00 46.93           C  
ATOM   7168  O   ALA E 181      37.695  82.038 -12.024  1.00 49.20           O  
ATOM   7169  CB  ALA E 181      38.837  81.915  -9.192  1.00 48.08           C  
ATOM   7170  N   HIS E 182      38.578  79.966 -12.043  1.00 41.79           N  
ATOM   7171  CA  HIS E 182      38.716  79.926 -13.489  1.00 38.43           C  
ATOM   7172  C   HIS E 182      37.657  79.014 -14.145  1.00 39.47           C  
ATOM   7173  O   HIS E 182      37.690  77.779 -14.057  1.00 37.38           O  
ATOM   7174  CB  HIS E 182      40.148  79.523 -13.877  1.00 35.29           C  
ATOM   7175  CG  HIS E 182      41.226  80.460 -13.362  1.00 32.73           C  
ATOM   7176  ND1 HIS E 182      40.975  81.755 -12.946  1.00 35.24           N  
ATOM   7177  CD2 HIS E 182      42.566  80.289 -13.236  1.00 31.30           C  
ATOM   7178  CE1 HIS E 182      42.110  82.328 -12.577  1.00 33.81           C  
ATOM   7179  NE2 HIS E 182      43.094  81.465 -12.753  1.00 32.11           N  
ATOM   7180  N   SER E 183      36.709  79.658 -14.796  1.00 42.43           N  
ATOM   7181  CA  SER E 183      35.771  79.013 -15.737  1.00 47.47           C  
ATOM   7182  C   SER E 183      36.418  77.975 -16.680  1.00 43.95           C  
ATOM   7183  O   SER E 183      35.812  76.909 -16.911  1.00 41.31           O  
ATOM   7184  CB  SER E 183      35.111  80.092 -16.634  1.00 52.10           C  
ATOM   7185  OG  SER E 183      33.787  79.724 -17.032  1.00 56.90           O  
ATOM   7186  N   SER E 184      37.610  78.305 -17.219  1.00 38.99           N  
ATOM   7187  CA  SER E 184      38.420  77.370 -18.018  1.00 37.40           C  
ATOM   7188  C   SER E 184      38.651  76.027 -17.289  1.00 38.98           C  
ATOM   7189  O   SER E 184      38.404  74.976 -17.881  1.00 38.93           O  
ATOM   7190  CB  SER E 184      39.769  77.996 -18.456  1.00 39.54           C  
ATOM   7191  OG  SER E 184      40.537  78.579 -17.383  1.00 37.09           O  
ATOM   7192  N   ALA E 185      39.082  76.057 -16.014  1.00 37.94           N  
ATOM   7193  CA  ALA E 185      39.290  74.822 -15.204  1.00 37.79           C  
ATOM   7194  C   ALA E 185      37.992  74.057 -14.893  1.00 37.75           C  
ATOM   7195  O   ALA E 185      37.966  72.835 -15.004  1.00 39.61           O  
ATOM   7196  CB  ALA E 185      40.007  75.126 -13.915  1.00 35.93           C  
ATOM   7197  N   VAL E 186      36.923  74.749 -14.508  1.00 34.82           N  
ATOM   7198  CA  VAL E 186      35.638  74.048 -14.285  1.00 35.51           C  
ATOM   7199  C   VAL E 186      35.239  73.271 -15.539  1.00 33.55           C  
ATOM   7200  O   VAL E 186      34.782  72.157 -15.408  1.00 32.72           O  
ATOM   7201  CB  VAL E 186      34.429  74.973 -13.935  1.00 38.45           C  
ATOM   7202  CG1 VAL E 186      33.153  74.124 -13.673  1.00 40.94           C  
ATOM   7203  CG2 VAL E 186      34.728  75.843 -12.733  1.00 39.37           C  
ATOM   7204  N   SER E 187      35.447  73.869 -16.726  1.00 33.58           N  
ATOM   7205  CA  SER E 187      35.156  73.258 -18.008  1.00 34.61           C  
ATOM   7206  C   SER E 187      35.837  71.929 -18.225  1.00 35.03           C  
ATOM   7207  O   SER E 187      35.246  71.077 -18.898  1.00 32.42           O  
ATOM   7208  CB  SER E 187      35.438  74.212 -19.203  1.00 35.33           C  
ATOM   7209  OG  SER E 187      36.767  74.108 -19.748  1.00 37.05           O  
ATOM   7210  N   ARG E 188      37.047  71.752 -17.656  1.00 31.92           N  
ATOM   7211  CA  ARG E 188      37.770  70.475 -17.719  1.00 30.87           C  
ATOM   7212  C   ARG E 188      37.099  69.384 -16.924  1.00 31.59           C  
ATOM   7213  O   ARG E 188      37.132  68.223 -17.298  1.00 31.18           O  
ATOM   7214  CB  ARG E 188      39.220  70.608 -17.238  1.00 32.51           C  
ATOM   7215  CG  ARG E 188      40.069  71.419 -18.132  1.00 33.41           C  
ATOM   7216  CD  ARG E 188      40.362  70.701 -19.460  1.00 35.49           C  
ATOM   7217  NE  ARG E 188      41.084  69.482 -19.192  1.00 36.90           N  
ATOM   7218  CZ  ARG E 188      42.336  69.450 -18.738  1.00 39.19           C  
ATOM   7219  NH1 ARG E 188      43.052  70.577 -18.547  1.00 41.63           N  
ATOM   7220  NH2 ARG E 188      42.891  68.286 -18.497  1.00 36.89           N  
ATOM   7221  N   ILE E 189      36.463  69.735 -15.830  1.00 37.00           N  
ATOM   7222  CA  ILE E 189      35.674  68.736 -15.067  1.00 40.62           C  
ATOM   7223  C   ILE E 189      34.333  68.418 -15.743  1.00 38.79           C  
ATOM   7224  O   ILE E 189      33.952  67.263 -15.854  1.00 37.87           O  
ATOM   7225  CB  ILE E 189      35.472  69.179 -13.624  1.00 41.38           C  
ATOM   7226  CG1 ILE E 189      36.855  69.275 -12.940  1.00 42.71           C  
ATOM   7227  CG2 ILE E 189      34.618  68.173 -12.915  1.00 41.59           C  
ATOM   7228  CD1 ILE E 189      36.827  70.087 -11.633  1.00 44.56           C  
ATOM   7229  N   ILE E 190      33.638  69.439 -16.223  1.00 38.43           N  
ATOM   7230  CA  ILE E 190      32.372  69.212 -16.955  1.00 38.43           C  
ATOM   7231  C   ILE E 190      32.620  68.349 -18.221  1.00 39.22           C  
ATOM   7232  O   ILE E 190      31.797  67.513 -18.573  1.00 40.88           O  
ATOM   7233  CB  ILE E 190      31.699  70.558 -17.251  1.00 36.81           C  
ATOM   7234  CG1 ILE E 190      31.274  71.255 -15.935  1.00 38.04           C  
ATOM   7235  CG2 ILE E 190      30.545  70.436 -18.174  1.00 36.07           C  
ATOM   7236  CD1 ILE E 190      30.240  70.495 -15.057  1.00 39.59           C  
ATOM   7237  N   SER E 191      33.784  68.524 -18.858  1.00 37.32           N  
ATOM   7238  CA  SER E 191      34.164  67.775 -20.076  1.00 34.39           C  
ATOM   7239  C   SER E 191      34.350  66.269 -19.796  1.00 33.89           C  
ATOM   7240  O   SER E 191      33.809  65.408 -20.511  1.00 32.56           O  
ATOM   7241  CB  SER E 191      35.424  68.434 -20.664  1.00 32.39           C  
ATOM   7242  OG  SER E 191      35.991  67.748 -21.753  1.00 31.08           O  
ATOM   7243  N   LYS E 192      35.085  65.973 -18.727  1.00 35.09           N  
ATOM   7244  CA  LYS E 192      35.251  64.622 -18.211  1.00 37.06           C  
ATOM   7245  C   LYS E 192      33.901  63.949 -17.967  1.00 37.21           C  
ATOM   7246  O   LYS E 192      33.669  62.819 -18.400  1.00 31.03           O  
ATOM   7247  CB  LYS E 192      36.081  64.679 -16.920  1.00 42.84           C  
ATOM   7248  CG  LYS E 192      36.314  63.364 -16.158  1.00 46.21           C  
ATOM   7249  CD  LYS E 192      37.205  62.418 -16.915  1.00 51.61           C  
ATOM   7250  CE  LYS E 192      38.184  61.527 -15.981  1.00 52.57           C  
ATOM   7251  NZ  LYS E 192      39.646  61.435 -16.551  1.00 50.84           N  
ATOM   7252  N   LEU E 193      33.014  64.640 -17.255  1.00 37.05           N  
ATOM   7253  CA  LEU E 193      31.744  64.049 -16.919  1.00 36.82           C  
ATOM   7254  C   LEU E 193      30.868  63.824 -18.141  1.00 36.22           C  
ATOM   7255  O   LEU E 193      30.162  62.845 -18.169  1.00 36.33           O  
ATOM   7256  CB  LEU E 193      30.992  64.891 -15.896  1.00 36.18           C  
ATOM   7257  CG  LEU E 193      31.613  64.974 -14.500  1.00 37.13           C  
ATOM   7258  CD1 LEU E 193      30.830  65.949 -13.656  1.00 36.89           C  
ATOM   7259  CD2 LEU E 193      31.771  63.664 -13.787  1.00 36.67           C  
ATOM   7260  N   LYS E 194      30.888  64.737 -19.122  1.00 37.40           N  
ATOM   7261  CA  LYS E 194      30.125  64.546 -20.377  1.00 38.92           C  
ATOM   7262  C   LYS E 194      30.666  63.330 -21.140  1.00 37.27           C  
ATOM   7263  O   LYS E 194      29.910  62.545 -21.731  1.00 37.44           O  
ATOM   7264  CB  LYS E 194      30.184  65.776 -21.282  1.00 40.05           C  
ATOM   7265  CG  LYS E 194      29.257  66.955 -20.920  1.00 43.45           C  
ATOM   7266  CD  LYS E 194      29.435  68.192 -21.924  1.00 43.52           C  
ATOM   7267  CE  LYS E 194      28.386  69.350 -21.650  1.00 44.82           C  
ATOM   7268  NZ  LYS E 194      28.167  70.314 -22.818  1.00 45.28           N  
ATOM   7269  N   GLN E 195      31.985  63.204 -21.164  1.00 36.45           N  
ATOM   7270  CA  GLN E 195      32.641  62.142 -21.933  1.00 35.59           C  
ATOM   7271  C   GLN E 195      32.303  60.789 -21.296  1.00 36.94           C  
ATOM   7272  O   GLN E 195      32.204  59.782 -21.982  1.00 39.04           O  
ATOM   7273  CB  GLN E 195      34.156  62.419 -22.021  1.00 35.47           C  
ATOM   7274  CG  GLN E 195      35.068  61.298 -22.474  1.00 34.77           C  
ATOM   7275  CD  GLN E 195      34.809  60.756 -23.873  1.00 37.62           C  
ATOM   7276  OE1 GLN E 195      34.950  59.549 -24.082  1.00 40.80           O  
ATOM   7277  NE2 GLN E 195      34.443  61.620 -24.828  1.00 35.42           N  
ATOM   7278  N   GLU E 196      32.070  60.761 -19.994  1.00 39.23           N  
ATOM   7279  CA  GLU E 196      31.727  59.499 -19.326  1.00 43.09           C  
ATOM   7280  C   GLU E 196      30.239  59.252 -19.241  1.00 41.63           C  
ATOM   7281  O   GLU E 196      29.820  58.297 -18.591  1.00 41.25           O  
ATOM   7282  CB  GLU E 196      32.375  59.432 -17.935  1.00 47.53           C  
ATOM   7283  CG  GLU E 196      33.799  58.977 -18.050  1.00 52.48           C  
ATOM   7284  CD  GLU E 196      34.649  59.352 -16.905  1.00 56.74           C  
ATOM   7285  OE1 GLU E 196      34.127  59.426 -15.775  1.00 60.32           O  
ATOM   7286  OE2 GLU E 196      35.864  59.561 -17.144  1.00 62.93           O  
ATOM   7287  N   LYS E 197      29.460  60.101 -19.901  1.00 38.82           N  
ATOM   7288  CA  LYS E 197      28.013  59.961 -20.002  1.00 41.20           C  
ATOM   7289  C   LYS E 197      27.276  60.174 -18.685  1.00 38.38           C  
ATOM   7290  O   LYS E 197      26.188  59.662 -18.526  1.00 34.05           O  
ATOM   7291  CB  LYS E 197      27.675  58.611 -20.621  1.00 43.19           C  
ATOM   7292  CG  LYS E 197      28.278  58.448 -22.026  1.00 45.59           C  
ATOM   7293  CD  LYS E 197      28.092  57.007 -22.545  1.00 48.49           C  
ATOM   7294  CE  LYS E 197      28.580  56.797 -24.008  1.00 49.87           C  
ATOM   7295  NZ  LYS E 197      27.479  57.122 -25.011  1.00 53.59           N  
ATOM   7296  N   VAL E 198      27.877  60.932 -17.753  1.00 37.94           N  
ATOM   7297  CA  VAL E 198      27.277  61.231 -16.432  1.00 37.96           C  
ATOM   7298  C   VAL E 198      26.287  62.403 -16.571  1.00 39.35           C  
ATOM   7299  O   VAL E 198      25.152  62.375 -16.027  1.00 35.96           O  
ATOM   7300  CB  VAL E 198      28.365  61.519 -15.353  1.00 35.75           C  
ATOM   7301  CG1 VAL E 198      27.756  61.853 -14.021  1.00 36.26           C  
ATOM   7302  CG2 VAL E 198      29.318  60.331 -15.242  1.00 35.83           C  
ATOM   7303  N   ILE E 199      26.703  63.404 -17.348  1.00 40.98           N  
ATOM   7304  CA  ILE E 199      25.806  64.493 -17.753  1.00 40.01           C  
ATOM   7305  C   ILE E 199      25.765  64.774 -19.275  1.00 41.13           C  
ATOM   7306  O   ILE E 199      26.685  64.382 -20.009  1.00 36.97           O  
ATOM   7307  CB  ILE E 199      26.156  65.775 -17.014  1.00 41.36           C  
ATOM   7308  CG1 ILE E 199      27.620  66.184 -17.251  1.00 40.02           C  
ATOM   7309  CG2 ILE E 199      25.860  65.598 -15.495  1.00 43.32           C  
ATOM   7310  CD1 ILE E 199      27.980  67.518 -16.614  1.00 40.00           C  
ATOM   7311  N   VAL E 200      24.662  65.425 -19.701  1.00 39.85           N  
ATOM   7312  CA  VAL E 200      24.525  66.185 -20.951  1.00 41.36           C  
ATOM   7313  C   VAL E 200      24.165  67.690 -20.663  1.00 41.80           C  
ATOM   7314  O   VAL E 200      23.642  68.058 -19.582  1.00 40.22           O  
ATOM   7315  CB  VAL E 200      23.397  65.536 -21.846  1.00 43.37           C  
ATOM   7316  CG1 VAL E 200      23.116  66.352 -23.034  1.00 45.92           C  
ATOM   7317  CG2 VAL E 200      23.780  64.157 -22.343  1.00 42.96           C  
ATOM   7318  N   TYR E 201      24.423  68.577 -21.622  1.00 47.78           N  
ATOM   7319  CA  TYR E 201      23.863  69.985 -21.590  1.00 47.77           C  
ATOM   7320  C   TYR E 201      23.041  70.287 -22.825  1.00 49.60           C  
ATOM   7321  O   TYR E 201      23.499  70.034 -23.917  1.00 49.91           O  
ATOM   7322  CB  TYR E 201      24.968  71.046 -21.530  1.00 50.63           C  
ATOM   7323  CG  TYR E 201      24.450  72.467 -21.305  1.00 50.82           C  
ATOM   7324  CD1 TYR E 201      24.187  72.913 -20.036  1.00 50.69           C  
ATOM   7325  CD2 TYR E 201      24.235  73.356 -22.378  1.00 53.35           C  
ATOM   7326  CE1 TYR E 201      23.720  74.172 -19.802  1.00 53.08           C  
ATOM   7327  CE2 TYR E 201      23.756  74.661 -22.161  1.00 50.83           C  
ATOM   7328  CZ  TYR E 201      23.504  75.039 -20.863  1.00 53.54           C  
ATOM   7329  OH  TYR E 201      23.034  76.279 -20.554  1.00 54.81           O  
ATOM   7330  N   LYS E 202      21.843  70.856 -22.654  1.00 52.84           N  
ATOM   7331  CA  LYS E 202      21.024  71.337 -23.772  1.00 52.84           C  
ATOM   7332  C   LYS E 202      19.812  72.109 -23.258  1.00 55.14           C  
ATOM   7333  O   LYS E 202      19.481  72.033 -22.079  1.00 54.52           O  
ATOM   7334  CB  LYS E 202      20.587  70.170 -24.654  1.00 53.03           C  
ATOM   7335  CG  LYS E 202      19.462  69.306 -24.112  1.00 54.47           C  
ATOM   7336  CD  LYS E 202      19.402  67.956 -24.863  1.00 55.00           C  
ATOM   7337  CE  LYS E 202      18.167  67.139 -24.515  1.00 55.14           C  
ATOM   7338  NZ  LYS E 202      16.980  67.544 -25.374  1.00 57.78           N  
ATOM   7339  N   ASN E 203      19.135  72.850 -24.139  1.00 58.13           N  
ATOM   7340  CA  ASN E 203      17.991  73.718 -23.739  1.00 58.09           C  
ATOM   7341  C   ASN E 203      18.380  74.700 -22.614  1.00 57.69           C  
ATOM   7342  O   ASN E 203      17.541  75.084 -21.793  1.00 59.16           O  
ATOM   7343  CB  ASN E 203      16.753  72.884 -23.287  1.00 58.84           C  
ATOM   7344  CG  ASN E 203      16.221  71.925 -24.379  1.00 60.22           C  
ATOM   7345  OD1 ASN E 203      15.960  70.738 -24.109  1.00 60.83           O  
ATOM   7346  ND2 ASN E 203      16.029  72.446 -25.603  1.00 58.16           N  
ATOM   7347  N   SER E 204      19.645  75.105 -22.564  1.00 55.90           N  
ATOM   7348  CA  SER E 204      20.119  75.937 -21.472  1.00 55.57           C  
ATOM   7349  C   SER E 204      20.032  75.250 -20.076  1.00 55.55           C  
ATOM   7350  O   SER E 204      19.953  75.943 -19.078  1.00 55.56           O  
ATOM   7351  CB  SER E 204      19.365  77.288 -21.443  1.00 57.53           C  
ATOM   7352  OG  SER E 204      19.672  78.097 -22.574  1.00 58.22           O  
ATOM   7353  N   CYS E 205      20.049  73.910 -20.011  1.00 54.98           N  
ATOM   7354  CA  CYS E 205      20.058  73.170 -18.724  1.00 52.36           C  
ATOM   7355  C   CYS E 205      21.055  72.003 -18.708  1.00 46.40           C  
ATOM   7356  O   CYS E 205      21.306  71.413 -19.725  1.00 46.14           O  
ATOM   7357  CB  CYS E 205      18.668  72.602 -18.435  1.00 53.99           C  
ATOM   7358  SG  CYS E 205      17.370  73.823 -18.085  1.00 55.33           S  
ATOM   7359  N   PHE E 206      21.615  71.689 -17.542  1.00 43.56           N  
ATOM   7360  CA  PHE E 206      22.231  70.376 -17.271  1.00 42.08           C  
ATOM   7361  C   PHE E 206      21.224  69.266 -17.026  1.00 41.47           C  
ATOM   7362  O   PHE E 206      20.251  69.456 -16.302  1.00 42.11           O  
ATOM   7363  CB  PHE E 206      23.182  70.452 -16.062  1.00 42.10           C  
ATOM   7364  CG  PHE E 206      24.406  71.277 -16.325  1.00 43.09           C  
ATOM   7365  CD1 PHE E 206      25.457  70.749 -17.021  1.00 41.08           C  
ATOM   7366  CD2 PHE E 206      24.450  72.638 -15.950  1.00 44.68           C  
ATOM   7367  CE1 PHE E 206      26.588  71.530 -17.292  1.00 43.70           C  
ATOM   7368  CE2 PHE E 206      25.537  73.420 -16.223  1.00 42.79           C  
ATOM   7369  CZ  PHE E 206      26.639  72.855 -16.878  1.00 42.80           C  
ATOM   7370  N   TYR E 207      21.471  68.106 -17.634  1.00 40.80           N  
ATOM   7371  CA  TYR E 207      20.639  66.906 -17.462  1.00 41.40           C  
ATOM   7372  C   TYR E 207      21.500  65.779 -16.887  1.00 39.98           C  
ATOM   7373  O   TYR E 207      22.522  65.413 -17.515  1.00 36.09           O  
ATOM   7374  CB  TYR E 207      20.110  66.401 -18.798  1.00 44.49           C  
ATOM   7375  CG  TYR E 207      18.956  67.164 -19.438  1.00 46.35           C  
ATOM   7376  CD1 TYR E 207      19.169  68.415 -20.057  1.00 46.27           C  
ATOM   7377  CD2 TYR E 207      17.668  66.607 -19.491  1.00 44.56           C  
ATOM   7378  CE1 TYR E 207      18.129  69.110 -20.670  1.00 45.57           C  
ATOM   7379  CE2 TYR E 207      16.617  67.302 -20.112  1.00 47.28           C  
ATOM   7380  CZ  TYR E 207      16.860  68.563 -20.699  1.00 46.74           C  
ATOM   7381  OH  TYR E 207      15.835  69.252 -21.326  1.00 46.94           O  
ATOM   7382  N   VAL E 208      21.095  65.225 -15.735  1.00 36.74           N  
ATOM   7383  CA  VAL E 208      21.818  64.105 -15.124  1.00 36.28           C  
ATOM   7384  C   VAL E 208      21.316  62.750 -15.635  1.00 34.03           C  
ATOM   7385  O   VAL E 208      20.153  62.448 -15.512  1.00 39.16           O  
ATOM   7386  CB  VAL E 208      21.745  64.177 -13.552  1.00 35.90           C  
ATOM   7387  CG1 VAL E 208      22.459  63.018 -12.897  1.00 34.83           C  
ATOM   7388  CG2 VAL E 208      22.299  65.482 -13.056  1.00 36.88           C  
ATOM   7389  N   GLN E 209      22.214  61.947 -16.209  1.00 35.02           N  
ATOM   7390  CA  GLN E 209      21.931  60.646 -16.825  1.00 31.76           C  
ATOM   7391  C   GLN E 209      22.494  59.449 -16.061  1.00 33.54           C  
ATOM   7392  O   GLN E 209      22.106  58.315 -16.304  1.00 30.57           O  
ATOM   7393  CB  GLN E 209      22.489  60.651 -18.239  1.00 37.81           C  
ATOM   7394  CG  GLN E 209      21.914  61.820 -19.047  1.00 41.39           C  
ATOM   7395  CD  GLN E 209      21.945  61.627 -20.547  1.00 46.43           C  
ATOM   7396  OE1 GLN E 209      22.925  61.131 -21.125  1.00 47.63           O  
ATOM   7397  NE2 GLN E 209      20.871  62.075 -21.203  1.00 50.41           N  
ATOM   7398  N   ASN E 210      23.404  59.699 -15.118  1.00 35.03           N  
ATOM   7399  CA  ASN E 210      23.937  58.654 -14.232  1.00 34.56           C  
ATOM   7400  C   ASN E 210      24.047  59.187 -12.792  1.00 35.29           C  
ATOM   7401  O   ASN E 210      25.116  59.659 -12.342  1.00 35.23           O  
ATOM   7402  CB  ASN E 210      25.282  58.125 -14.746  1.00 32.68           C  
ATOM   7403  CG  ASN E 210      25.751  56.914 -13.966  1.00 33.96           C  
ATOM   7404  OD1 ASN E 210      25.145  56.540 -12.963  1.00 34.72           O  
ATOM   7405  ND2 ASN E 210      26.814  56.282 -14.425  1.00 31.13           N  
ATOM   7406  N   LEU E 211      22.916  59.109 -12.091  1.00 36.04           N  
ATOM   7407  CA  LEU E 211      22.814  59.557 -10.711  1.00 37.53           C  
ATOM   7408  C   LEU E 211      23.765  58.830  -9.758  1.00 34.13           C  
ATOM   7409  O   LEU E 211      24.373  59.460  -8.882  1.00 35.67           O  
ATOM   7410  CB  LEU E 211      21.334  59.466 -10.237  1.00 39.13           C  
ATOM   7411  CG  LEU E 211      21.054  59.933  -8.809  1.00 38.59           C  
ATOM   7412  CD1 LEU E 211      21.289  61.359  -8.692  1.00 38.62           C  
ATOM   7413  CD2 LEU E 211      19.579  59.627  -8.373  1.00 39.55           C  
ATOM   7414  N   ASP E 212      23.916  57.527  -9.922  1.00 35.51           N  
ATOM   7415  CA  ASP E 212      24.821  56.743  -9.063  1.00 36.26           C  
ATOM   7416  C   ASP E 212      26.313  57.080  -9.133  1.00 36.94           C  
ATOM   7417  O   ASP E 212      27.046  56.785  -8.188  1.00 35.14           O  
ATOM   7418  CB  ASP E 212      24.683  55.265  -9.355  1.00 39.44           C  
ATOM   7419  CG  ASP E 212      23.278  54.737  -9.088  1.00 43.21           C  
ATOM   7420  OD1 ASP E 212      22.628  55.133  -8.093  1.00 41.27           O  
ATOM   7421  OD2 ASP E 212      22.822  53.914  -9.903  1.00 44.88           O  
ATOM   7422  N   TYR E 213      26.773  57.646 -10.244  1.00 39.28           N  
ATOM   7423  CA  TYR E 213      28.156  58.123 -10.384  1.00 38.27           C  
ATOM   7424  C   TYR E 213      28.322  59.271  -9.383  1.00 36.94           C  
ATOM   7425  O   TYR E 213      29.310  59.356  -8.644  1.00 35.18           O  
ATOM   7426  CB  TYR E 213      28.382  58.616 -11.808  1.00 40.99           C  
ATOM   7427  CG  TYR E 213      29.816  58.999 -12.154  1.00 42.83           C  
ATOM   7428  CD1 TYR E 213      30.371  60.217 -11.707  1.00 43.14           C  
ATOM   7429  CD2 TYR E 213      30.613  58.170 -12.951  1.00 41.77           C  
ATOM   7430  CE1 TYR E 213      31.671  60.591 -12.011  1.00 42.46           C  
ATOM   7431  CE2 TYR E 213      31.945  58.553 -13.268  1.00 44.38           C  
ATOM   7432  CZ  TYR E 213      32.450  59.765 -12.787  1.00 43.61           C  
ATOM   7433  OH  TYR E 213      33.743  60.149 -13.094  1.00 45.70           O  
ATOM   7434  N   LEU E 214      27.317  60.133  -9.333  1.00 36.32           N  
ATOM   7435  CA  LEU E 214      27.375  61.300  -8.448  1.00 37.48           C  
ATOM   7436  C   LEU E 214      27.329  60.907  -6.980  1.00 37.06           C  
ATOM   7437  O   LEU E 214      28.109  61.456  -6.181  1.00 34.30           O  
ATOM   7438  CB  LEU E 214      26.267  62.294  -8.766  1.00 36.58           C  
ATOM   7439  CG  LEU E 214      26.236  62.915 -10.164  1.00 34.59           C  
ATOM   7440  CD1 LEU E 214      25.099  63.908 -10.219  1.00 32.77           C  
ATOM   7441  CD2 LEU E 214      27.510  63.583 -10.551  1.00 33.82           C  
ATOM   7442  N   LYS E 215      26.464  59.940  -6.660  1.00 38.48           N  
ATOM   7443  CA  LYS E 215      26.311  59.409  -5.292  1.00 41.35           C  
ATOM   7444  C   LYS E 215      27.605  58.849  -4.749  1.00 42.35           C  
ATOM   7445  O   LYS E 215      27.874  58.964  -3.551  1.00 44.55           O  
ATOM   7446  CB  LYS E 215      25.288  58.281  -5.220  1.00 40.92           C  
ATOM   7447  CG  LYS E 215      23.838  58.618  -5.589  1.00 41.09           C  
ATOM   7448  CD  LYS E 215      22.959  57.375  -5.257  1.00 40.81           C  
ATOM   7449  CE  LYS E 215      21.479  57.710  -5.164  1.00 42.16           C  
ATOM   7450  NZ  LYS E 215      20.663  56.669  -4.460  1.00 40.81           N  
ATOM   7451  N   ARG E 216      28.404  58.238  -5.625  1.00 41.79           N  
ATOM   7452  CA  ARG E 216      29.679  57.688  -5.227  1.00 44.71           C  
ATOM   7453  C   ARG E 216      30.656  58.779  -4.677  1.00 41.13           C  
ATOM   7454  O   ARG E 216      31.445  58.522  -3.770  1.00 40.79           O  
ATOM   7455  CB  ARG E 216      30.259  56.876  -6.386  1.00 47.47           C  
ATOM   7456  CG  ARG E 216      31.530  56.141  -6.026  1.00 52.85           C  
ATOM   7457  CD  ARG E 216      31.876  54.941  -6.968  1.00 57.55           C  
ATOM   7458  NE  ARG E 216      31.951  55.339  -8.383  1.00 62.58           N  
ATOM   7459  CZ  ARG E 216      32.856  56.185  -8.888  1.00 65.27           C  
ATOM   7460  NH1 ARG E 216      33.804  56.733  -8.091  1.00 68.26           N  
ATOM   7461  NH2 ARG E 216      32.819  56.488 -10.192  1.00 63.64           N  
ATOM   7462  N   TYR E 217      30.549  59.996  -5.210  1.00 41.24           N  
ATOM   7463  CA  TYR E 217      31.315  61.155  -4.781  1.00 39.94           C  
ATOM   7464  C   TYR E 217      30.689  61.976  -3.685  1.00 38.08           C  
ATOM   7465  O   TYR E 217      31.401  62.732  -3.057  1.00 43.70           O  
ATOM   7466  CB  TYR E 217      31.641  62.081  -5.963  1.00 43.81           C  
ATOM   7467  CG  TYR E 217      32.715  61.502  -6.797  1.00 44.51           C  
ATOM   7468  CD1 TYR E 217      34.053  61.687  -6.478  1.00 44.21           C  
ATOM   7469  CD2 TYR E 217      32.394  60.721  -7.885  1.00 45.30           C  
ATOM   7470  CE1 TYR E 217      35.063  61.109  -7.263  1.00 45.63           C  
ATOM   7471  CE2 TYR E 217      33.355  60.172  -8.671  1.00 46.95           C  
ATOM   7472  CZ  TYR E 217      34.690  60.355  -8.373  1.00 45.98           C  
ATOM   7473  OH  TYR E 217      35.607  59.731  -9.190  1.00 46.25           O  
ATOM   7474  N   ALA E 218      29.411  61.771  -3.393  1.00 37.77           N  
ATOM   7475  CA  ALA E 218      28.686  62.517  -2.365  1.00 36.05           C  
ATOM   7476  C   ALA E 218      27.883  61.587  -1.456  1.00 34.31           C  
ATOM   7477  O   ALA E 218      26.660  61.735  -1.326  1.00 34.26           O  
ATOM   7478  CB  ALA E 218      27.748  63.538  -3.029  1.00 38.97           C  
ATOM   7479  N   PRO E 219      28.561  60.622  -0.838  1.00 32.26           N  
ATOM   7480  CA  PRO E 219      27.917  59.646   0.011  1.00 34.33           C  
ATOM   7481  C   PRO E 219      27.193  60.256   1.218  1.00 40.18           C  
ATOM   7482  O   PRO E 219      26.057  59.798   1.588  1.00 38.46           O  
ATOM   7483  CB  PRO E 219      29.064  58.713   0.431  1.00 33.07           C  
ATOM   7484  CG  PRO E 219      30.389  59.484   0.149  1.00 30.84           C  
ATOM   7485  CD  PRO E 219      30.025  60.409  -0.973  1.00 35.13           C  
ATOM   7486  N   LYS E 220      27.811  61.283   1.816  1.00 40.48           N  
ATOM   7487  CA  LYS E 220      27.202  61.932   2.973  1.00 40.98           C  
ATOM   7488  C   LYS E 220      26.021  62.845   2.658  1.00 39.15           C  
ATOM   7489  O   LYS E 220      25.098  62.972   3.451  1.00 35.75           O  
ATOM   7490  CB  LYS E 220      28.247  62.655   3.790  1.00 44.09           C  
ATOM   7491  CG  LYS E 220      28.644  61.908   5.018  1.00 48.43           C  
ATOM   7492  CD  LYS E 220      29.474  60.720   4.632  1.00 52.83           C  
ATOM   7493  CE  LYS E 220      29.875  59.864   5.847  1.00 54.74           C  
ATOM   7494  NZ  LYS E 220      28.752  59.648   6.843  1.00 57.47           N  
ATOM   7495  N   LEU E 221      26.051  63.509   1.514  1.00 37.27           N  
ATOM   7496  CA  LEU E 221      24.926  64.301   1.109  1.00 35.08           C  
ATOM   7497  C   LEU E 221      23.789  63.382   0.681  1.00 36.35           C  
ATOM   7498  O   LEU E 221      22.640  63.670   0.993  1.00 34.42           O  
ATOM   7499  CB  LEU E 221      25.316  65.259  -0.009  1.00 38.26           C  
ATOM   7500  CG  LEU E 221      26.119  66.529   0.446  1.00 38.97           C  
ATOM   7501  CD1 LEU E 221      26.896  67.162  -0.704  1.00 36.50           C  
ATOM   7502  CD2 LEU E 221      25.165  67.517   1.121  1.00 38.05           C  
ATOM   7503  N   ASP E 222      24.081  62.266  -0.005  1.00 36.37           N  
ATOM   7504  CA  ASP E 222      23.006  61.337  -0.321  1.00 35.81           C  
ATOM   7505  C   ASP E 222      22.276  60.912   0.964  1.00 37.24           C  
ATOM   7506  O   ASP E 222      21.049  61.018   1.050  1.00 33.95           O  
ATOM   7507  CB  ASP E 222      23.422  60.158  -1.163  1.00 33.54           C  
ATOM   7508  CG  ASP E 222      22.216  59.460  -1.762  1.00 36.40           C  
ATOM   7509  OD1 ASP E 222      21.618  59.943  -2.742  1.00 36.69           O  
ATOM   7510  OD2 ASP E 222      21.811  58.417  -1.224  1.00 44.36           O  
ATOM   7511  N   GLU E 223      23.039  60.546   1.984  1.00 37.77           N  
ATOM   7512  CA  GLU E 223      22.471  60.198   3.292  1.00 41.78           C  
ATOM   7513  C   GLU E 223      21.631  61.341   3.890  1.00 37.53           C  
ATOM   7514  O   GLU E 223      20.555  61.095   4.401  1.00 36.85           O  
ATOM   7515  CB  GLU E 223      23.610  59.737   4.211  1.00 43.78           C  
ATOM   7516  CG  GLU E 223      23.240  59.514   5.635  1.00 48.66           C  
ATOM   7517  CD  GLU E 223      24.464  59.105   6.510  1.00 50.74           C  
ATOM   7518  OE1 GLU E 223      25.193  60.017   6.990  1.00 48.23           O  
ATOM   7519  OE2 GLU E 223      24.642  57.869   6.733  1.00 55.24           O  
ATOM   7520  N   TRP E 224      22.104  62.581   3.778  1.00 36.60           N  
ATOM   7521  CA  TRP E 224      21.456  63.741   4.359  1.00 38.70           C  
ATOM   7522  C   TRP E 224      20.060  63.959   3.772  1.00 40.18           C  
ATOM   7523  O   TRP E 224      19.090  64.161   4.490  1.00 38.78           O  
ATOM   7524  CB  TRP E 224      22.301  65.036   4.209  1.00 38.98           C  
ATOM   7525  CG  TRP E 224      21.629  66.234   4.950  1.00 39.64           C  
ATOM   7526  CD1 TRP E 224      21.749  66.548   6.276  1.00 37.69           C  
ATOM   7527  CD2 TRP E 224      20.689  67.186   4.408  1.00 39.94           C  
ATOM   7528  NE1 TRP E 224      20.999  67.644   6.569  1.00 37.85           N  
ATOM   7529  CE2 TRP E 224      20.316  68.044   5.456  1.00 39.48           C  
ATOM   7530  CE3 TRP E 224      20.115  67.394   3.130  1.00 40.76           C  
ATOM   7531  CZ2 TRP E 224      19.408  69.125   5.263  1.00 40.31           C  
ATOM   7532  CZ3 TRP E 224      19.239  68.480   2.931  1.00 37.15           C  
ATOM   7533  CH2 TRP E 224      18.906  69.328   3.989  1.00 38.35           C  
ATOM   7534  N   PHE E 225      19.974  63.884   2.458  1.00 40.29           N  
ATOM   7535  CA  PHE E 225      18.701  63.973   1.799  1.00 39.00           C  
ATOM   7536  C   PHE E 225      17.695  62.948   2.296  1.00 42.88           C  
ATOM   7537  O   PHE E 225      16.544  63.313   2.551  1.00 43.85           O  
ATOM   7538  CB  PHE E 225      18.911  63.989   0.287  1.00 35.29           C  
ATOM   7539  CG  PHE E 225      19.332  65.345  -0.216  1.00 34.98           C  
ATOM   7540  CD1 PHE E 225      18.417  66.383  -0.287  1.00 32.39           C  
ATOM   7541  CD2 PHE E 225      20.635  65.596  -0.596  1.00 34.18           C  
ATOM   7542  CE1 PHE E 225      18.816  67.639  -0.747  1.00 34.27           C  
ATOM   7543  CE2 PHE E 225      21.013  66.830  -1.068  1.00 35.17           C  
ATOM   7544  CZ  PHE E 225      20.097  67.863  -1.122  1.00 33.82           C  
ATOM   7545  N   TYR E 226      18.148  61.713   2.530  1.00 44.71           N  
ATOM   7546  CA  TYR E 226      17.351  60.617   3.179  1.00 44.53           C  
ATOM   7547  C   TYR E 226      16.817  60.965   4.625  1.00 43.36           C  
ATOM   7548  O   TYR E 226      15.635  60.879   4.889  1.00 46.24           O  
ATOM   7549  CB  TYR E 226      18.178  59.270   3.118  1.00 46.03           C  
ATOM   7550  CG  TYR E 226      17.395  58.005   3.547  1.00 45.32           C  
ATOM   7551  CD1 TYR E 226      17.362  57.607   4.885  1.00 43.95           C  
ATOM   7552  CD2 TYR E 226      16.671  57.234   2.611  1.00 45.41           C  
ATOM   7553  CE1 TYR E 226      16.616  56.477   5.302  1.00 44.66           C  
ATOM   7554  CE2 TYR E 226      15.912  56.098   3.017  1.00 45.97           C  
ATOM   7555  CZ  TYR E 226      15.896  55.732   4.376  1.00 46.32           C  
ATOM   7556  OH  TYR E 226      15.165  54.627   4.817  1.00 47.02           O  
ATOM   7557  N   LEU E 227      17.673  61.429   5.523  1.00 45.94           N  
ATOM   7558  CA  LEU E 227      17.317  61.715   6.917  1.00 47.02           C  
ATOM   7559  C   LEU E 227      16.729  63.079   7.179  1.00 51.20           C  
ATOM   7560  O   LEU E 227      16.099  63.276   8.233  1.00 48.14           O  
ATOM   7561  CB  LEU E 227      18.551  61.641   7.820  1.00 48.03           C  
ATOM   7562  CG  LEU E 227      19.299  60.323   7.903  1.00 47.53           C  
ATOM   7563  CD1 LEU E 227      20.620  60.452   8.663  1.00 47.04           C  
ATOM   7564  CD2 LEU E 227      18.363  59.348   8.531  1.00 48.39           C  
ATOM   7565  N   ALA E 228      16.962  64.039   6.282  1.00 55.17           N  
ATOM   7566  CA  ALA E 228      16.435  65.380   6.502  1.00 57.55           C  
ATOM   7567  C   ALA E 228      15.373  65.812   5.480  1.00 59.33           C  
ATOM   7568  O   ALA E 228      14.529  66.649   5.816  1.00 62.65           O  
ATOM   7569  CB  ALA E 228      17.562  66.391   6.640  1.00 56.82           C  
HETATM 7570  N   PR3 E 229      15.360  65.227   4.279  1.00 61.10           N  
HETATM 7571  CA  PR3 E 229      14.270  65.485   3.284  1.00 60.73           C  
HETATM 7572  C   PR3 E 229      13.691  64.239   2.670  1.00 57.33           C  
HETATM 7573  O   PR3 E 229      13.709  64.083   1.438  1.00 50.51           O  
HETATM 7574  CB  PR3 E 229      14.747  66.350   2.108  1.00 65.82           C  
HETATM 7575  SG  PR3 E 229      15.423  67.827   2.765  1.00 72.97           S  
HETATM 7576  SD  PR3 E 229      14.177  69.403   2.295  1.00 82.02           S  
HETATM 7577  CE  PR3 E 229      12.602  69.768   3.018  1.00 80.39           C  
ATOM   7578  N   PRO E 230      13.141  63.336   3.518  1.00 58.04           N  
ATOM   7579  CA  PRO E 230      12.544  62.081   3.034  1.00 57.07           C  
ATOM   7580  C   PRO E 230      11.842  62.213   1.699  1.00 54.19           C  
ATOM   7581  O   PRO E 230      12.238  61.578   0.744  1.00 52.24           O  
ATOM   7582  CB  PRO E 230      11.553  61.707   4.145  1.00 56.79           C  
ATOM   7583  CG  PRO E 230      12.100  62.338   5.399  1.00 57.12           C  
ATOM   7584  CD  PRO E 230      13.034  63.455   4.991  1.00 58.70           C  
ATOM   7585  N   ALA E 231      10.821  63.058   1.657  1.00 56.97           N  
ATOM   7586  CA  ALA E 231       9.982  63.279   0.452  1.00 59.33           C  
ATOM   7587  C   ALA E 231      10.805  63.606  -0.824  1.00 62.02           C  
ATOM   7588  O   ALA E 231      10.634  62.965  -1.897  1.00 62.77           O  
ATOM   7589  CB  ALA E 231       8.969  64.386   0.734  1.00 56.59           C  
ATOM   7590  N   THR E 232      11.698  64.592  -0.687  1.00 63.26           N  
ATOM   7591  CA  THR E 232      12.654  64.973  -1.744  1.00 62.45           C  
ATOM   7592  C   THR E 232      13.481  63.764  -2.326  1.00 61.82           C  
ATOM   7593  O   THR E 232      13.571  63.636  -3.579  1.00 59.22           O  
ATOM   7594  CB  THR E 232      13.578  66.155  -1.248  1.00 63.88           C  
ATOM   7595  OG1 THR E 232      12.775  67.300  -0.900  1.00 64.99           O  
ATOM   7596  CG2 THR E 232      14.601  66.582  -2.320  1.00 64.57           C  
ATOM   7597  N   TRP E 233      14.014  62.886  -1.441  1.00 58.38           N  
ATOM   7598  CA  TRP E 233      14.835  61.658  -1.843  1.00 57.93           C  
ATOM   7599  C   TRP E 233      14.076  60.499  -2.475  1.00 55.45           C  
ATOM   7600  O   TRP E 233      14.585  59.836  -3.372  1.00 51.17           O  
ATOM   7601  CB  TRP E 233      15.592  61.090  -0.644  1.00 57.02           C  
ATOM   7602  CG  TRP E 233      16.687  60.050  -0.900  1.00 58.14           C  
ATOM   7603  CD1 TRP E 233      18.036  60.291  -0.994  1.00 57.44           C  
ATOM   7604  CD2 TRP E 233      16.545  58.613  -0.992  1.00 58.20           C  
ATOM   7605  NE1 TRP E 233      18.724  59.126  -1.164  1.00 56.46           N  
ATOM   7606  CE2 TRP E 233      17.846  58.077  -1.174  1.00 57.15           C  
ATOM   7607  CE3 TRP E 233      15.447  57.729  -0.935  1.00 58.45           C  
ATOM   7608  CZ2 TRP E 233      18.088  56.695  -1.311  1.00 57.63           C  
ATOM   7609  CZ3 TRP E 233      15.685  56.340  -1.076  1.00 58.01           C  
ATOM   7610  CH2 TRP E 233      17.001  55.842  -1.258  1.00 57.91           C  
ATOM   7611  N   GLY E 234      12.869  60.225  -1.977  1.00 59.55           N  
ATOM   7612  CA  GLY E 234      12.024  59.161  -2.535  1.00 59.35           C  
ATOM   7613  C   GLY E 234      11.743  59.386  -4.005  1.00 60.40           C  
ATOM   7614  O   GLY E 234      11.701  58.442  -4.787  1.00 60.69           O  
ATOM   7615  N   LYS E 235      11.582  60.657  -4.376  1.00 62.23           N  
ATOM   7616  CA  LYS E 235      11.223  61.057  -5.749  1.00 62.85           C  
ATOM   7617  C   LYS E 235      12.158  60.489  -6.836  1.00 59.17           C  
ATOM   7618  O   LYS E 235      11.701  60.031  -7.889  1.00 52.76           O  
ATOM   7619  CB  LYS E 235      11.155  62.595  -5.847  1.00 65.40           C  
ATOM   7620  CG  LYS E 235       9.900  63.121  -6.561  1.00 67.20           C  
ATOM   7621  CD  LYS E 235       8.631  63.093  -5.666  1.00 68.37           C  
ATOM   7622  CE  LYS E 235       7.328  63.159  -6.508  1.00 68.52           C  
ATOM   7623  NZ  LYS E 235       6.133  63.800  -5.828  1.00 68.65           N  
ATOM   7624  N   LEU E 236      13.464  60.526  -6.580  1.00 57.75           N  
ATOM   7625  CA  LEU E 236      14.448  60.022  -7.557  1.00 57.14           C  
ATOM   7626  C   LEU E 236      15.038  58.666  -7.160  1.00 58.93           C  
ATOM   7627  O   LEU E 236      15.946  58.149  -7.842  1.00 56.63           O  
ATOM   7628  CB  LEU E 236      15.556  61.053  -7.744  1.00 56.17           C  
ATOM   7629  CG  LEU E 236      15.048  62.420  -8.211  1.00 55.77           C  
ATOM   7630  CD1 LEU E 236      16.151  63.473  -8.014  1.00 57.10           C  
ATOM   7631  CD2 LEU E 236      14.537  62.386  -9.653  1.00 53.80           C  
ATOM   7632  N   ASN E 237      14.519  58.119  -6.046  1.00 59.74           N  
ATOM   7633  CA  ASN E 237      14.891  56.806  -5.536  1.00 61.02           C  
ATOM   7634  C   ASN E 237      13.604  55.938  -5.344  1.00 64.18           C  
ATOM   7635  O   ASN E 237      13.590  54.851  -4.731  1.00 65.88           O  
ATOM   7636  CB  ASN E 237      15.725  56.953  -4.233  1.00 60.28           C  
ATOM   7637  CG  ASN E 237      17.177  57.469  -4.487  1.00 59.44           C  
ATOM   7638  OD1 ASN E 237      18.032  56.726  -4.979  1.00 57.81           O  
ATOM   7639  ND2 ASN E 237      17.443  58.740  -4.138  1.00 56.99           N  
ATOM   7640  OXT ASN E 237      12.505  56.285  -5.828  1.00 65.29           O  
TER    7641      ASN E 237                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
