
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  150 ( 2305),  selected  150 , name 2i2y_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 2i2y_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      T       1          1.893
LGA    Q     2_A      T       2          1.596
LGA    Y     3_A      Y       3          0.895
LGA    K     4_A      K       4          0.596
LGA    L     5_A      L       5          0.483
LGA    I     6_A      I       6          0.584
LGA    L     7_A      L       7          0.598
LGA    N     8_A      N       8          1.282
LGA    G     9_A      L       9          1.470
LGA    K    10_A      K      10          1.510
LGA    T    11_A      Q      11          1.254
LGA    L    12_A      A      12          3.057
LGA    K    13_A      K      13          2.417
LGA    G    14_A      E      14          1.259
LGA    E    15_A      E      15          0.724
LGA    T    16_A      A      16          1.812
LGA    T    17_A      I      17          0.607
LGA    T    18_A      K      18          0.508
LGA    E    19_A      E      19          1.478
LGA    A    20_A      A      20          2.153
LGA    V    21_A      V      21          2.634
LGA    D    22_A      D      22          3.001
LGA    A    23_A      A      23          2.597
LGA    A    24_A      G      24          2.073
LGA    T    25_A      T      25          1.866
LGA    A    26_A      A      26          1.284
LGA    E    27_A      E      27          1.384
LGA    K    28_A      K      28          0.848
LGA    V    29_A      Y      29          0.840
LGA    F    30_A      F      30          0.765
LGA    K    31_A      K      31          0.781
LGA    Q    32_A      L      32          0.981
LGA    Y    33_A      I      33          0.530
LGA    A    34_A      A      34          0.984
LGA    N    35_A      N      35          1.749
LGA    D    36_A      A      36          2.046
LGA    N    37_A      K      37          1.662
LGA    G    38_A      T      38          1.579
LGA    V    39_A      V      39          4.074
LGA    D    40_A      E      40          3.464
LGA    G    41_A      G      41          1.661
LGA    E    42_A      V      42          1.624
LGA    W    43_A      W      43          1.665
LGA    T    44_A      T      44          1.428
LGA    Y    45_A      Y      45          1.207
LGA    D    46_A      K      46          1.208
LGA    D    47_A      D      47          1.733
LGA    A    48_A      E      48          0.712
LGA    T    49_A      I      49          2.345
LGA    K    50_A      K      50          1.313
LGA    T    51_A      T      51          1.392
LGA    F    52_A      F      52          1.078
LGA    T    53_A      T      53          0.581
LGA    V    54_A      V      54          0.940
LGA    T    55_A      T      55          0.988
LGA    E    56_A      E      56          1.892
LGA    G    57_A      -       -           -
LGA    S    58_A      -       -           -
LGA    H    59_A      -       -           -
LGA    H    60_A      -       -           -
LGA    H    61_A      -       -           -
LGA    H    62_A      -       -           -
LGA    H    63_A      -       -           -
LGA    H    64_A      -       -           -
LGA    M    65_A      -       -           -
LGA    H    66_A      -       -           -
LGA    R    67_A      -       -           -
LGA    D    68_A      -       -           -
LGA    S    69_A      -       -           -
LGA    C    70_A      -       -           -
LGA    P    71_A      -       -           -
LGA    L    72_A      -       -           -
LGA    D    73_A      -       -           -
LGA    C    74_A      -       -           -
LGA    K    75_A      -       -           -
LGA    V    76_A      -       -           -
LGA    Y    77_A      -       -           -
LGA    V    78_A      -       -           -
LGA    G    79_A      -       -           -
LGA    N    80_A      -       -           -
LGA    L    81_A      -       -           -
LGA    G    82_A      -       -           -
LGA    N    83_A      -       -           -
LGA    N    84_A      -       -           -
LGA    G    85_A      -       -           -
LGA    N    86_A      -       -           -
LGA    K    87_A      -       -           -
LGA    T    88_A      -       -           -
LGA    E    89_A      -       -           -
LGA    L    90_A      -       -           -
LGA    E    91_A      -       -           -
LGA    R    92_A      -       -           -
LGA    A    93_A      -       -           -
LGA    F    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    Y    96_A      -       -           -
LGA    Y    97_A      -       -           -
LGA    G    98_A      -       -           -
LGA    P    99_A      -       -           -
LGA    L   100_A      -       -           -
LGA    R   101_A      -       -           -
LGA    S   102_A      -       -           -
LGA    V   103_A      -       -           -
LGA    W   104_A      -       -           -
LGA    V   105_A      -       -           -
LGA    A   106_A      -       -           -
LGA    R   107_A      -       -           -
LGA    N   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    P   110_A      -       -           -
LGA    G   111_A      -       -           -
LGA    F   112_A      -       -           -
LGA    A   113_A      -       -           -
LGA    F   114_A      -       -           -
LGA    V   115_A      -       -           -
LGA    E   116_A      -       -           -
LGA    F   117_A      -       -           -
LGA    E   118_A      -       -           -
LGA    D   119_A      -       -           -
LGA    P   120_A      -       -           -
LGA    R   121_A      -       -           -
LGA    D   122_A      -       -           -
LGA    A   123_A      -       -           -
LGA    A   124_A      -       -           -
LGA    D   125_A      -       -           -
LGA    A   126_A      -       -           -
LGA    V   127_A      -       -           -
LGA    R   128_A      -       -           -
LGA    E   129_A      -       -           -
LGA    L   130_A      -       -           -
LGA    D   131_A      -       -           -
LGA    G   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    T   134_A      -       -           -
LGA    L   135_A      -       -           -
LGA    C   136_A      -       -           -
LGA    G   137_A      -       -           -
LGA    C   138_A      -       -           -
LGA    R   139_A      -       -           -
LGA    V   140_A      -       -           -
LGA    R   141_A      -       -           -
LGA    V   142_A      -       -           -
LGA    E   143_A      -       -           -
LGA    L   144_A      -       -           -
LGA    S   145_A      -       -           -
LGA    N   146_A      -       -           -
LGA    G   147_A      -       -           -
LGA    E   148_A      -       -           -
LGA    K   149_A      -       -           -
LGA    R   150_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  150   56    5.0     56    1.67    62.50     92.403     3.160

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.133811 * X  +  -0.924413 * Y  +   0.357149 * Z  + -58.998753
  Y_new =   0.802998 * X  +   0.312340 * Y  +   0.507580 * Z  +  11.577022
  Z_new =  -0.580766 * X  +   0.218870 * Y  +   0.784096 * Z  + -33.699234 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.272208   -2.869384  [ DEG:    15.5964   -164.4036 ]
  Theta =   0.619669    2.521924  [ DEG:    35.5044    144.4956 ]
  Phi   =   1.405675   -1.735918  [ DEG:    80.5392    -99.4608 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i2y_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i2y_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  150   56   5.0   56   1.67   62.50  92.403
REMARK  ---------------------------------------------------------- 
MOLECULE 2i2y_A
HEADER    RNA BINDING PROTEIN/CHIMERA/RNA         17-AUG-06   2I2Y              
TITLE     SOLUTION STRUCTURE OF THE RRM OF SRP20 BOUND TO THE RNA CAUC          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FUSION PROTEIN CONSISTS OF IMMUNOGLOBIN G-                 
COMPND   3 BINDING PROTEIN G AND SPLICING FACTOR, ARGININE/SERINE-              
COMPND   4 RICH 3;                                                              
COMPND   5 CHAIN: A;                                                            
COMPND   6 FRAGMENT: RRM DOMAIN;                                                
COMPND   7 SYNONYM: PRE-MRNA-SPLICING FACTOR SRP20;                             
COMPND   8 ENGINEERED: YES;                                                     
COMPND   9 MOL_ID: 2;                                                           
COMPND  10 MOLECULE: (5'-R(*CP*AP*UP*C)-3');                                    
COMPND  11 CHAIN: B;                                                            
COMPND  12 ENGINEERED: YES;                                                     
COMPND  13 OTHER_DETAILS: CORE SEQUENCE OF EXONIC SPLICING ENHANCERS            
COMPND  14 RECOGNISED BY SRP20                                                  
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP. GROUP G AND HOMO              
SOURCE   3 SAPIENS;                                                             
SOURCE   4 ORGANISM_COMMON: BACTERIA AND HUMAN;                                 
SOURCE   5 GENE: SPG AND SFRS3;                                                 
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)CODON+ RIL;                       
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_VECTOR: PET-28;                                    
SOURCE  11 MOL_ID: 2;                                                           
SOURCE  12 SYNTHETIC: YES                                                       
KEYWDS    PROTEIN-RNA COMPLEX RRM ALPHA-BETA SANDWICH BETA1-ALPHA1-             
KEYWDS   2 BETA2-BETA3-ALPHA2-BETA4                                             
EXPDTA    NMR, 28 STRUCTURES                                                    
AUTHOR    Y.F.HARGOUS,F.H.ALLAIN                                                
REVDAT   1   12-DEC-06 2I2Y    0                                                
JRNL        AUTH   Y.HARGOUS,G.M.HAUTBERGUE,A.M.TINTARU,L.SKRISOVSKA,           
JRNL        AUTH 2 A.P.GOLOVANOV,J.STEVENIN,L.Y.LIAN,S.A.WILSON,                
JRNL        AUTH 3 F.H.ALLAIN                                                   
JRNL        TITL   MOLECULAR BASIS OF RNA RECOGNITION AND TAP BINDING           
JRNL        TITL 2 BY THE SR PROTEINS SRP20 AND 9G8.                            
JRNL        REF    EMBO J.                       V.  25  5126 2006              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2I2Y A    3    56  UNP    P19909   SPG2_STRSG     304    357             
DBREF  2I2Y A   65   150  UNP    P84103   SFRS3_HUMAN      1     86             
SEQRES   1 A  150  MET GLN TYR LYS LEU ILE LEU ASN GLY LYS THR LEU LYS          
SEQRES   2 A  150  GLY GLU THR THR THR GLU ALA VAL ASP ALA ALA THR ALA          
SEQRES   3 A  150  GLU LYS VAL PHE LYS GLN TYR ALA ASN ASP ASN GLY VAL          
SEQRES   4 A  150  ASP GLY GLU TRP THR TYR ASP ASP ALA THR LYS THR PHE          
SEQRES   5 A  150  THR VAL THR GLU GLY SER HIS HIS HIS HIS HIS HIS MET          
SEQRES   6 A  150  HIS ARG ASP SER CYS PRO LEU ASP CYS LYS VAL TYR VAL          
SEQRES   7 A  150  GLY ASN LEU GLY ASN ASN GLY ASN LYS THR GLU LEU GLU          
SEQRES   8 A  150  ARG ALA PHE GLY TYR TYR GLY PRO LEU ARG SER VAL TRP          
SEQRES   9 A  150  VAL ALA ARG ASN PRO PRO GLY PHE ALA PHE VAL GLU PHE          
SEQRES  10 A  150  GLU ASP PRO ARG ASP ALA ALA ASP ALA VAL ARG GLU LEU          
SEQRES  11 A  150  ASP GLY ARG THR LEU CYS GLY CYS ARG VAL ARG VAL GLU          
SEQRES  12 A  150  LEU SER ASN GLY GLU LYS ARG                                  
SEQRES   1 B    4    C   A   U   C                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       6.562 -12.572   6.069  0.00  0.00           N  
ATOM      2  CA  MET A   1       6.535 -12.600   4.587  0.00  0.00           C  
ATOM      3  C   MET A   1       6.384 -11.178   4.059  0.00  0.00           C  
ATOM      4  O   MET A   1       5.660 -10.383   4.652  0.00  0.00           O  
ATOM      5  CB  MET A   1       5.397 -13.494   4.058  0.00  0.00           C  
ATOM      6  CG  MET A   1       5.636 -14.979   4.372  0.00  0.00           C  
ATOM      7  SD  MET A   1       4.343 -16.112   3.786  0.00  0.00           S  
ATOM      8  CE  MET A   1       3.040 -15.793   5.009  0.00  0.00           C  
ATOM      9  HA  MET A   1       7.484 -12.993   4.222  0.00  0.00           H  
ATOM     10  HB2 MET A   1       4.449 -13.175   4.494  0.00  0.00           H  
ATOM     11  HB3 MET A   1       5.329 -13.382   2.975  0.00  0.00           H  
ATOM     12  HG2 MET A   1       6.576 -15.278   3.907  0.00  0.00           H  
ATOM     13  HG3 MET A   1       5.739 -15.115   5.448  0.00  0.00           H  
ATOM     14  HE1 MET A   1       3.409 -16.015   6.012  0.00  0.00           H  
ATOM     15  HE2 MET A   1       2.735 -14.748   4.964  0.00  0.00           H  
ATOM     16  HE3 MET A   1       2.177 -16.423   4.798  0.00  0.00           H  
ATOM     17  H1  MET A   1       7.363 -12.041   6.397  0.00  0.00           H  
ATOM     18  H2  MET A   1       6.622 -13.500   6.455  0.00  0.00           H  
ATOM     19  H3  MET A   1       5.732 -12.112   6.423  0.00  0.00           H  
ATOM     20  N   GLN A   2       7.055 -10.809   2.966  0.00  0.00           N  
ATOM     21  CA  GLN A   2       6.934  -9.453   2.418  0.00  0.00           C  
ATOM     22  C   GLN A   2       5.694  -9.307   1.507  0.00  0.00           C  
ATOM     23  O   GLN A   2       5.343 -10.225   0.762  0.00  0.00           O  
ATOM     24  CB  GLN A   2       8.253  -9.067   1.728  0.00  0.00           C  
ATOM     25  CG  GLN A   2       8.190  -7.822   0.828  0.00  0.00           C  
ATOM     26  CD  GLN A   2       9.570  -7.396   0.331  0.00  0.00           C  
ATOM     27  OE1 GLN A   2      10.055  -6.312   0.625  0.00  0.00           O  
ATOM     28  NE2 GLN A   2      10.260  -8.217  -0.436  0.00  0.00           N  
ATOM     29  H   GLN A   2       7.638 -11.477   2.482  0.00  0.00           H  
ATOM     30  HA  GLN A   2       6.816  -8.780   3.266  0.00  0.00           H  
ATOM     31  HB2 GLN A   2       8.983  -8.865   2.511  0.00  0.00           H  
ATOM     32  HB3 GLN A   2       8.602  -9.912   1.138  0.00  0.00           H  
ATOM     33  HG2 GLN A   2       7.559  -8.026  -0.039  0.00  0.00           H  
ATOM     34  HG3 GLN A   2       7.752  -6.998   1.394  0.00  0.00           H  
ATOM     35 HE21 GLN A   2       9.895  -9.121  -0.691  0.00  0.00           H  
ATOM     36 HE22 GLN A   2      11.174  -7.924  -0.744  0.00  0.00           H  
ATOM     37  N   TYR A   3       5.071  -8.125   1.533  0.00  0.00           N  
ATOM     38  CA  TYR A   3       3.889  -7.724   0.767  0.00  0.00           C  
ATOM     39  C   TYR A   3       4.163  -6.374   0.091  0.00  0.00           C  
ATOM     40  O   TYR A   3       5.033  -5.629   0.548  0.00  0.00           O  
ATOM     41  CB  TYR A   3       2.710  -7.636   1.750  0.00  0.00           C  
ATOM     42  CG  TYR A   3       2.325  -8.985   2.317  0.00  0.00           C  
ATOM     43  CD1 TYR A   3       1.414  -9.804   1.631  0.00  0.00           C  
ATOM     44  CD2 TYR A   3       2.923  -9.446   3.501  0.00  0.00           C  
ATOM     45  CE1 TYR A   3       1.130 -11.096   2.115  0.00  0.00           C  
ATOM     46  CE2 TYR A   3       2.584 -10.701   4.036  0.00  0.00           C  
ATOM     47  CZ  TYR A   3       1.712 -11.550   3.315  0.00  0.00           C  
ATOM     48  OH  TYR A   3       1.383 -12.784   3.779  0.00  0.00           O  
ATOM     49  H   TYR A   3       5.399  -7.423   2.193  0.00  0.00           H  
ATOM     50  HA  TYR A   3       3.659  -8.461  -0.005  0.00  0.00           H  
ATOM     51  HB2 TYR A   3       2.977  -6.968   2.571  0.00  0.00           H  
ATOM     52  HB3 TYR A   3       1.839  -7.204   1.268  0.00  0.00           H  
ATOM     53  HD1 TYR A   3       0.963  -9.446   0.716  0.00  0.00           H  
ATOM     54  HD2 TYR A   3       3.667  -8.833   3.989  0.00  0.00           H  
ATOM     55  HE1 TYR A   3       0.451 -11.746   1.585  0.00  0.00           H  
ATOM     56  HE2 TYR A   3       3.010 -11.009   4.981  0.00  0.00           H  
ATOM     57  HH  TYR A   3       1.691 -12.939   4.687  0.00  0.00           H  
ATOM     58  N   LYS A   4       3.436  -6.034  -0.978  0.00  0.00           N  
ATOM     59  CA  LYS A   4       3.621  -4.804  -1.778  0.00  0.00           C  
ATOM     60  C   LYS A   4       2.435  -3.846  -1.625  0.00  0.00           C  
ATOM     61  O   LYS A   4       1.371  -4.281  -1.198  0.00  0.00           O  
ATOM     62  CB  LYS A   4       3.885  -5.229  -3.235  0.00  0.00           C  
ATOM     63  CG  LYS A   4       4.283  -4.080  -4.164  0.00  0.00           C  
ATOM     64  CD  LYS A   4       4.606  -4.552  -5.584  0.00  0.00           C  
ATOM     65  CE  LYS A   4       5.261  -3.351  -6.259  0.00  0.00           C  
ATOM     66  NZ  LYS A   4       5.576  -3.567  -7.690  0.00  0.00           N  
ATOM     67  H   LYS A   4       2.729  -6.692  -1.282  0.00  0.00           H  
ATOM     68  HA  LYS A   4       4.490  -4.258  -1.423  0.00  0.00           H  
ATOM     69  HB2 LYS A   4       4.708  -5.943  -3.249  0.00  0.00           H  
ATOM     70  HB3 LYS A   4       3.003  -5.725  -3.626  0.00  0.00           H  
ATOM     71  HG2 LYS A   4       3.479  -3.353  -4.233  0.00  0.00           H  
ATOM     72  HG3 LYS A   4       5.165  -3.597  -3.746  0.00  0.00           H  
ATOM     73  HD2 LYS A   4       5.300  -5.394  -5.558  0.00  0.00           H  
ATOM     74  HD3 LYS A   4       3.688  -4.836  -6.102  0.00  0.00           H  
ATOM     75  HE2 LYS A   4       4.600  -2.489  -6.154  0.00  0.00           H  
ATOM     76  HE3 LYS A   4       6.172  -3.135  -5.699  0.00  0.00           H  
ATOM     77  HZ1 LYS A   4       6.185  -4.359  -7.824  0.00  0.00           H  
ATOM     78  HZ2 LYS A   4       4.741  -3.701  -8.242  0.00  0.00           H  
ATOM     79  HZ3 LYS A   4       6.056  -2.736  -8.041  0.00  0.00           H  
ATOM     80  N   LEU A   5       2.598  -2.571  -1.986  0.00  0.00           N  
ATOM     81  CA  LEU A   5       1.560  -1.537  -2.014  0.00  0.00           C  
ATOM     82  C   LEU A   5       1.810  -0.541  -3.155  0.00  0.00           C  
ATOM     83  O   LEU A   5       2.942  -0.097  -3.320  0.00  0.00           O  
ATOM     84  CB  LEU A   5       1.537  -0.856  -0.639  0.00  0.00           C  
ATOM     85  CG  LEU A   5       0.695   0.417  -0.460  0.00  0.00           C  
ATOM     86  CD1 LEU A   5       1.300   1.675  -0.995  0.00  0.00           C  
ATOM     87  CD2 LEU A   5      -0.763   0.344  -0.893  0.00  0.00           C  
ATOM     88  H   LEU A   5       3.528  -2.276  -2.273  0.00  0.00           H  
ATOM     89  HA  LEU A   5       0.603  -2.012  -2.159  0.00  0.00           H  
ATOM     90  HB2 LEU A   5       1.154  -1.590   0.067  0.00  0.00           H  
ATOM     91  HB3 LEU A   5       2.563  -0.627  -0.341  0.00  0.00           H  
ATOM     92  HG  LEU A   5       0.692   0.640   0.586  0.00  0.00           H  
ATOM     93 HD11 LEU A   5       1.043   1.808  -2.040  0.00  0.00           H  
ATOM     94 HD12 LEU A   5       0.884   2.480  -0.389  0.00  0.00           H  
ATOM     95 HD13 LEU A   5       2.376   1.649  -0.860  0.00  0.00           H  
ATOM     96 HD21 LEU A   5      -1.255   1.287  -0.660  0.00  0.00           H  
ATOM     97 HD22 LEU A   5      -0.861   0.161  -1.958  0.00  0.00           H  
ATOM     98 HD23 LEU A   5      -1.251  -0.441  -0.333  0.00  0.00           H  
ATOM     99  N   ILE A   6       0.766  -0.151  -3.897  0.00  0.00           N  
ATOM    100  CA  ILE A   6       0.774   0.891  -4.947  0.00  0.00           C  
ATOM    101  C   ILE A   6      -0.131   2.067  -4.554  0.00  0.00           C  
ATOM    102  O   ILE A   6      -1.290   1.877  -4.208  0.00  0.00           O  
ATOM    103  CB  ILE A   6       0.327   0.287  -6.303  0.00  0.00           C  
ATOM    104  CG1 ILE A   6       1.380  -0.571  -7.032  0.00  0.00           C  
ATOM    105  CG2 ILE A   6      -0.053   1.383  -7.316  0.00  0.00           C  
ATOM    106  CD1 ILE A   6       1.997  -1.728  -6.253  0.00  0.00           C  
ATOM    107  H   ILE A   6      -0.109  -0.632  -3.742  0.00  0.00           H  
ATOM    108  HA  ILE A   6       1.770   1.303  -5.064  0.00  0.00           H  
ATOM    109  HB  ILE A   6      -0.551  -0.334  -6.122  0.00  0.00           H  
ATOM    110 HG12 ILE A   6       0.912  -0.993  -7.915  0.00  0.00           H  
ATOM    111 HG13 ILE A   6       2.175   0.074  -7.388  0.00  0.00           H  
ATOM    112 HG21 ILE A   6      -0.953   1.903  -6.997  0.00  0.00           H  
ATOM    113 HG22 ILE A   6       0.768   2.097  -7.428  0.00  0.00           H  
ATOM    114 HG23 ILE A   6      -0.267   0.940  -8.289  0.00  0.00           H  
ATOM    115 HD11 ILE A   6       1.223  -2.261  -5.701  0.00  0.00           H  
ATOM    116 HD12 ILE A   6       2.476  -2.414  -6.953  0.00  0.00           H  
ATOM    117 HD13 ILE A   6       2.759  -1.344  -5.577  0.00  0.00           H  
ATOM    118  N   LEU A   7       0.375   3.291  -4.678  0.00  0.00           N  
ATOM    119  CA  LEU A   7      -0.239   4.565  -4.305  0.00  0.00           C  
ATOM    120  C   LEU A   7      -0.672   5.355  -5.558  0.00  0.00           C  
ATOM    121  O   LEU A   7      -0.200   6.465  -5.784  0.00  0.00           O  
ATOM    122  CB  LEU A   7       0.745   5.395  -3.442  0.00  0.00           C  
ATOM    123  CG  LEU A   7       1.444   4.758  -2.244  0.00  0.00           C  
ATOM    124  CD1 LEU A   7       2.725   4.030  -2.652  0.00  0.00           C  
ATOM    125  CD2 LEU A   7       1.897   5.862  -1.296  0.00  0.00           C  
ATOM    126  H   LEU A   7       1.329   3.345  -5.011  0.00  0.00           H  
ATOM    127  HA  LEU A   7      -1.137   4.373  -3.720  0.00  0.00           H  
ATOM    128  HB2 LEU A   7       1.516   5.805  -4.080  0.00  0.00           H  
ATOM    129  HB3 LEU A   7       0.194   6.232  -3.043  0.00  0.00           H  
ATOM    130  HG  LEU A   7       0.779   4.045  -1.756  0.00  0.00           H  
ATOM    131 HD11 LEU A   7       3.161   3.553  -1.782  0.00  0.00           H  
ATOM    132 HD12 LEU A   7       2.495   3.242  -3.354  0.00  0.00           H  
ATOM    133 HD13 LEU A   7       3.443   4.722  -3.092  0.00  0.00           H  
ATOM    134 HD21 LEU A   7       2.396   5.421  -0.436  0.00  0.00           H  
ATOM    135 HD22 LEU A   7       2.592   6.525  -1.810  0.00  0.00           H  
ATOM    136 HD23 LEU A   7       1.035   6.444  -0.975  0.00  0.00           H  
ATOM    137  N   ASN A   8      -1.494   4.769  -6.431  0.00  0.00           N  
ATOM    138  CA  ASN A   8      -1.970   5.399  -7.680  0.00  0.00           C  
ATOM    139  C   ASN A   8      -2.697   6.758  -7.472  0.00  0.00           C  
ATOM    140  O   ASN A   8      -3.927   6.782  -7.405  0.00  0.00           O  
ATOM    141  CB  ASN A   8      -2.906   4.426  -8.433  0.00  0.00           C  
ATOM    142  CG  ASN A   8      -2.259   3.259  -9.143  0.00  0.00           C  
ATOM    143  OD1 ASN A   8      -1.165   3.338  -9.682  0.00  0.00           O  
ATOM    144  ND2 ASN A   8      -2.959   2.148  -9.190  0.00  0.00           N  
ATOM    145  H   ASN A   8      -1.789   3.827  -6.218  0.00  0.00           H  
ATOM    146  HA  ASN A   8      -1.105   5.599  -8.314  0.00  0.00           H  
ATOM    147  HB2 ASN A   8      -3.639   4.033  -7.736  0.00  0.00           H  
ATOM    148  HB3 ASN A   8      -3.445   4.976  -9.205  0.00  0.00           H  
ATOM    149 HD21 ASN A   8      -3.871   2.103  -8.757  0.00  0.00           H  
ATOM    150 HD22 ASN A   8      -2.599   1.370  -9.714  0.00  0.00           H  
ATOM    151  N   GLY A   9      -1.985   7.893  -7.411  0.00  0.00           N  
ATOM    152  CA  GLY A   9      -2.582   9.239  -7.396  0.00  0.00           C  
ATOM    153  C   GLY A   9      -2.219  10.131  -8.583  0.00  0.00           C  
ATOM    154  O   GLY A   9      -1.394   9.777  -9.429  0.00  0.00           O  
ATOM    155  H   GLY A   9      -0.984   7.822  -7.272  0.00  0.00           H  
ATOM    156  HA2 GLY A   9      -3.661   9.152  -7.432  0.00  0.00           H  
ATOM    157  HA3 GLY A   9      -2.311   9.747  -6.470  0.00  0.00           H  
ATOM    158  N   LYS A  10      -2.862  11.301  -8.673  0.00  0.00           N  
ATOM    159  CA  LYS A  10      -2.757  12.204  -9.838  0.00  0.00           C  
ATOM    160  C   LYS A  10      -1.327  12.718 -10.066  0.00  0.00           C  
ATOM    161  O   LYS A  10      -0.839  12.661 -11.194  0.00  0.00           O  
ATOM    162  CB  LYS A  10      -3.779  13.345  -9.665  0.00  0.00           C  
ATOM    163  CG  LYS A  10      -3.811  14.403 -10.782  0.00  0.00           C  
ATOM    164  CD  LYS A  10      -4.234  13.876 -12.162  0.00  0.00           C  
ATOM    165  CE  LYS A  10      -4.187  15.047 -13.153  0.00  0.00           C  
ATOM    166  NZ  LYS A  10      -4.588  14.658 -14.531  0.00  0.00           N  
ATOM    167  H   LYS A  10      -3.527  11.532  -7.939  0.00  0.00           H  
ATOM    168  HA  LYS A  10      -3.026  11.634 -10.729  0.00  0.00           H  
ATOM    169  HB2 LYS A  10      -4.776  12.916  -9.564  0.00  0.00           H  
ATOM    170  HB3 LYS A  10      -3.553  13.861  -8.738  0.00  0.00           H  
ATOM    171  HG2 LYS A  10      -4.515  15.179 -10.479  0.00  0.00           H  
ATOM    172  HG3 LYS A  10      -2.828  14.869 -10.866  0.00  0.00           H  
ATOM    173  HD2 LYS A  10      -3.546  13.095 -12.488  0.00  0.00           H  
ATOM    174  HD3 LYS A  10      -5.246  13.471 -12.106  0.00  0.00           H  
ATOM    175  HE2 LYS A  10      -4.839  15.843 -12.786  0.00  0.00           H  
ATOM    176  HE3 LYS A  10      -3.167  15.442 -13.169  0.00  0.00           H  
ATOM    177  HZ1 LYS A  10      -4.022  13.895 -14.881  0.00  0.00           H  
ATOM    178  HZ2 LYS A  10      -5.567  14.384 -14.590  0.00  0.00           H  
ATOM    179  HZ3 LYS A  10      -4.473  15.444 -15.159  0.00  0.00           H  
ATOM    180  N   THR A  11      -0.626  13.137  -9.007  0.00  0.00           N  
ATOM    181  CA  THR A  11       0.682  13.836  -9.104  0.00  0.00           C  
ATOM    182  C   THR A  11       1.830  13.154  -8.345  0.00  0.00           C  
ATOM    183  O   THR A  11       2.969  13.150  -8.810  0.00  0.00           O  
ATOM    184  CB  THR A  11       0.575  15.280  -8.571  0.00  0.00           C  
ATOM    185  OG1 THR A  11       0.363  15.273  -7.176  0.00  0.00           O  
ATOM    186  CG2 THR A  11      -0.543  16.105  -9.208  0.00  0.00           C  
ATOM    187  H   THR A  11      -1.119  13.167  -8.126  0.00  0.00           H  
ATOM    188  HA  THR A  11       0.990  13.903 -10.148  0.00  0.00           H  
ATOM    189  HB  THR A  11       1.521  15.781  -8.769  0.00  0.00           H  
ATOM    190  HG1 THR A  11      -0.557  15.549  -6.994  0.00  0.00           H  
ATOM    191 HG21 THR A  11      -0.498  17.125  -8.828  0.00  0.00           H  
ATOM    192 HG22 THR A  11      -0.410  16.128 -10.290  0.00  0.00           H  
ATOM    193 HG23 THR A  11      -1.521  15.686  -8.972  0.00  0.00           H  
ATOM    194  N   LEU A  12       1.518  12.526  -7.208  0.00  0.00           N  
ATOM    195  CA  LEU A  12       2.458  12.008  -6.204  0.00  0.00           C  
ATOM    196  C   LEU A  12       2.749  10.499  -6.253  0.00  0.00           C  
ATOM    197  O   LEU A  12       3.519   9.994  -5.433  0.00  0.00           O  
ATOM    198  CB  LEU A  12       1.876  12.357  -4.818  0.00  0.00           C  
ATOM    199  CG  LEU A  12       0.606  11.565  -4.417  0.00  0.00           C  
ATOM    200  CD1 LEU A  12       0.397  11.718  -2.919  0.00  0.00           C  
ATOM    201  CD2 LEU A  12      -0.676  11.998  -5.136  0.00  0.00           C  
ATOM    202  H   LEU A  12       0.566  12.635  -6.900  0.00  0.00           H  
ATOM    203  HA  LEU A  12       3.415  12.521  -6.321  0.00  0.00           H  
ATOM    204  HB2 LEU A  12       2.652  12.155  -4.078  0.00  0.00           H  
ATOM    205  HB3 LEU A  12       1.665  13.428  -4.772  0.00  0.00           H  
ATOM    206  HG  LEU A  12       0.745  10.504  -4.619  0.00  0.00           H  
ATOM    207 HD11 LEU A  12       1.165  11.134  -2.415  0.00  0.00           H  
ATOM    208 HD12 LEU A  12       0.459  12.766  -2.630  0.00  0.00           H  
ATOM    209 HD13 LEU A  12      -0.577  11.330  -2.639  0.00  0.00           H  
ATOM    210 HD21 LEU A  12      -0.674  11.615  -6.154  0.00  0.00           H  
ATOM    211 HD22 LEU A  12      -1.547  11.566  -4.643  0.00  0.00           H  
ATOM    212 HD23 LEU A  12      -0.763  13.085  -5.121  0.00  0.00           H  
ATOM    213  N   LYS A  13       2.071   9.782  -7.156  0.00  0.00           N  
ATOM    214  CA  LYS A  13       2.015   8.318  -7.224  0.00  0.00           C  
ATOM    215  C   LYS A  13       3.319   7.556  -7.001  0.00  0.00           C  
ATOM    216  O   LYS A  13       4.400   7.965  -7.435  0.00  0.00           O  
ATOM    217  CB  LYS A  13       1.329   7.851  -8.520  0.00  0.00           C  
ATOM    218  CG  LYS A  13       2.206   7.824  -9.784  0.00  0.00           C  
ATOM    219  CD  LYS A  13       2.799   9.164 -10.264  0.00  0.00           C  
ATOM    220  CE  LYS A  13       1.829  10.341 -10.480  0.00  0.00           C  
ATOM    221  NZ  LYS A  13       0.694  10.033 -11.391  0.00  0.00           N  
ATOM    222  H   LYS A  13       1.417  10.297  -7.720  0.00  0.00           H  
ATOM    223  HA  LYS A  13       1.371   8.038  -6.396  0.00  0.00           H  
ATOM    224  HB2 LYS A  13       0.974   6.833  -8.359  0.00  0.00           H  
ATOM    225  HB3 LYS A  13       0.457   8.463  -8.701  0.00  0.00           H  
ATOM    226  HG2 LYS A  13       3.029   7.127  -9.598  0.00  0.00           H  
ATOM    227  HG3 LYS A  13       1.609   7.402 -10.592  0.00  0.00           H  
ATOM    228  HD2 LYS A  13       3.551   9.488  -9.542  0.00  0.00           H  
ATOM    229  HD3 LYS A  13       3.327   8.978 -11.201  0.00  0.00           H  
ATOM    230  HE2 LYS A  13       1.441  10.667  -9.515  0.00  0.00           H  
ATOM    231  HE3 LYS A  13       2.410  11.173 -10.892  0.00  0.00           H  
ATOM    232  HZ1 LYS A  13       1.002   9.578 -12.239  0.00  0.00           H  
ATOM    233  HZ2 LYS A  13       0.001   9.451 -10.930  0.00  0.00           H  
ATOM    234  HZ3 LYS A  13       0.209  10.886 -11.653  0.00  0.00           H  
ATOM    235  N   GLY A  14       3.168   6.372  -6.414  0.00  0.00           N  
ATOM    236  CA  GLY A  14       4.264   5.403  -6.321  0.00  0.00           C  
ATOM    237  C   GLY A  14       3.921   3.993  -5.837  0.00  0.00           C  
ATOM    238  O   GLY A  14       2.794   3.535  -5.998  0.00  0.00           O  
ATOM    239  H   GLY A  14       2.250   6.167  -6.035  0.00  0.00           H  
ATOM    240  HA2 GLY A  14       4.671   5.284  -7.315  0.00  0.00           H  
ATOM    241  HA3 GLY A  14       5.045   5.828  -5.704  0.00  0.00           H  
ATOM    242  N   GLU A  15       4.906   3.286  -5.279  0.00  0.00           N  
ATOM    243  CA  GLU A  15       4.797   1.936  -4.702  0.00  0.00           C  
ATOM    244  C   GLU A  15       5.901   1.656  -3.667  0.00  0.00           C  
ATOM    245  O   GLU A  15       6.950   2.307  -3.662  0.00  0.00           O  
ATOM    246  CB  GLU A  15       4.769   0.843  -5.792  0.00  0.00           C  
ATOM    247  CG  GLU A  15       5.768   1.002  -6.940  0.00  0.00           C  
ATOM    248  CD  GLU A  15       5.826  -0.269  -7.805  0.00  0.00           C  
ATOM    249  OE1 GLU A  15       4.871  -0.555  -8.565  0.00  0.00           O  
ATOM    250  OE2 GLU A  15       6.822  -1.027  -7.721  0.00  0.00           O  
ATOM    251  H   GLU A  15       5.798   3.738  -5.149  0.00  0.00           H  
ATOM    252  HA  GLU A  15       3.857   1.855  -4.165  0.00  0.00           H  
ATOM    253  HB2 GLU A  15       4.912  -0.134  -5.326  0.00  0.00           H  
ATOM    254  HB3 GLU A  15       3.774   0.855  -6.226  0.00  0.00           H  
ATOM    255  HG2 GLU A  15       5.441   1.839  -7.559  0.00  0.00           H  
ATOM    256  HG3 GLU A  15       6.750   1.224  -6.527  0.00  0.00           H  
ATOM    257  N   THR A  16       5.659   0.682  -2.786  0.00  0.00           N  
ATOM    258  CA  THR A  16       6.582   0.215  -1.744  0.00  0.00           C  
ATOM    259  C   THR A  16       6.232  -1.221  -1.335  0.00  0.00           C  
ATOM    260  O   THR A  16       5.326  -1.834  -1.900  0.00  0.00           O  
ATOM    261  CB  THR A  16       6.568   1.163  -0.527  0.00  0.00           C  
ATOM    262  OG1 THR A  16       7.695   0.922   0.290  0.00  0.00           O  
ATOM    263  CG2 THR A  16       5.309   1.061   0.342  0.00  0.00           C  
ATOM    264  H   THR A  16       4.790   0.160  -2.873  0.00  0.00           H  
ATOM    265  HA  THR A  16       7.596   0.201  -2.146  0.00  0.00           H  
ATOM    266  HB  THR A  16       6.647   2.185  -0.897  0.00  0.00           H  
ATOM    267  HG1 THR A  16       7.738   1.636   0.948  0.00  0.00           H  
ATOM    268 HG21 THR A  16       4.460   1.454  -0.213  0.00  0.00           H  
ATOM    269 HG22 THR A  16       5.102   0.036   0.642  0.00  0.00           H  
ATOM    270 HG23 THR A  16       5.443   1.649   1.246  0.00  0.00           H  
ATOM    271  N   THR A  17       6.920  -1.756  -0.333  0.00  0.00           N  
ATOM    272  CA  THR A  17       6.694  -3.084   0.252  0.00  0.00           C  
ATOM    273  C   THR A  17       6.908  -3.052   1.772  0.00  0.00           C  
ATOM    274  O   THR A  17       7.394  -2.062   2.328  0.00  0.00           O  
ATOM    275  CB  THR A  17       7.657  -4.122  -0.360  0.00  0.00           C  
ATOM    276  OG1 THR A  17       9.002  -3.717  -0.185  0.00  0.00           O  
ATOM    277  CG2 THR A  17       7.446  -4.370  -1.854  0.00  0.00           C  
ATOM    278  H   THR A  17       7.611  -1.166   0.119  0.00  0.00           H  
ATOM    279  HA  THR A  17       5.654  -3.382   0.072  0.00  0.00           H  
ATOM    280  HB  THR A  17       7.518  -5.070   0.154  0.00  0.00           H  
ATOM    281  HG1 THR A  17       9.530  -4.524  -0.039  0.00  0.00           H  
ATOM    282 HG21 THR A  17       7.491  -3.435  -2.416  0.00  0.00           H  
ATOM    283 HG22 THR A  17       8.212  -5.049  -2.227  0.00  0.00           H  
ATOM    284 HG23 THR A  17       6.476  -4.838  -2.006  0.00  0.00           H  
ATOM    285  N   THR A  18       6.554  -4.138   2.465  0.00  0.00           N  
ATOM    286  CA  THR A  18       6.840  -4.325   3.894  0.00  0.00           C  
ATOM    287  C   THR A  18       6.840  -5.796   4.277  0.00  0.00           C  
ATOM    288  O   THR A  18       6.138  -6.598   3.669  0.00  0.00           O  
ATOM    289  CB  THR A  18       5.793  -3.621   4.783  0.00  0.00           C  
ATOM    290  OG1 THR A  18       6.319  -3.513   6.092  0.00  0.00           O  
ATOM    291  CG2 THR A  18       4.435  -4.339   4.874  0.00  0.00           C  
ATOM    292  H   THR A  18       6.149  -4.924   1.963  0.00  0.00           H  
ATOM    293  HA  THR A  18       7.823  -3.905   4.118  0.00  0.00           H  
ATOM    294  HB  THR A  18       5.626  -2.613   4.404  0.00  0.00           H  
ATOM    295  HG1 THR A  18       6.102  -4.326   6.579  0.00  0.00           H  
ATOM    296 HG21 THR A  18       3.702  -3.692   5.351  0.00  0.00           H  
ATOM    297 HG22 THR A  18       4.081  -4.584   3.876  0.00  0.00           H  
ATOM    298 HG23 THR A  18       4.517  -5.269   5.445  0.00  0.00           H  
ATOM    299  N   GLU A  19       7.591  -6.149   5.315  0.00  0.00           N  
ATOM    300  CA  GLU A  19       7.483  -7.449   5.970  0.00  0.00           C  
ATOM    301  C   GLU A  19       6.209  -7.410   6.844  0.00  0.00           C  
ATOM    302  O   GLU A  19       6.081  -6.548   7.720  0.00  0.00           O  
ATOM    303  CB  GLU A  19       8.751  -7.681   6.807  0.00  0.00           C  
ATOM    304  CG  GLU A  19       8.683  -8.900   7.740  0.00  0.00           C  
ATOM    305  CD  GLU A  19       8.621 -10.272   7.048  0.00  0.00           C  
ATOM    306  OE1 GLU A  19       8.737 -10.380   5.808  0.00  0.00           O  
ATOM    307  OE2 GLU A  19       8.398 -11.285   7.752  0.00  0.00           O  
ATOM    308  H   GLU A  19       8.131  -5.430   5.780  0.00  0.00           H  
ATOM    309  HA  GLU A  19       7.406  -8.244   5.231  0.00  0.00           H  
ATOM    310  HB2 GLU A  19       9.610  -7.784   6.142  0.00  0.00           H  
ATOM    311  HB3 GLU A  19       8.925  -6.800   7.429  0.00  0.00           H  
ATOM    312  HG2 GLU A  19       9.569  -8.871   8.370  0.00  0.00           H  
ATOM    313  HG3 GLU A  19       7.809  -8.792   8.382  0.00  0.00           H  
ATOM    314  N   ALA A  20       5.269  -8.328   6.613  0.00  0.00           N  
ATOM    315  CA  ALA A  20       4.052  -8.515   7.404  0.00  0.00           C  
ATOM    316  C   ALA A  20       3.727 -10.007   7.623  0.00  0.00           C  
ATOM    317  O   ALA A  20       4.437 -10.890   7.132  0.00  0.00           O  
ATOM    318  CB  ALA A  20       2.896  -7.761   6.720  0.00  0.00           C  
ATOM    319  H   ALA A  20       5.403  -8.962   5.836  0.00  0.00           H  
ATOM    320  HA  ALA A  20       4.193  -8.091   8.391  0.00  0.00           H  
ATOM    321  HB1 ALA A  20       1.967  -7.926   7.257  0.00  0.00           H  
ATOM    322  HB2 ALA A  20       3.108  -6.692   6.695  0.00  0.00           H  
ATOM    323  HB3 ALA A  20       2.744  -8.107   5.705  0.00  0.00           H  
ATOM    324  N   VAL A  21       2.655 -10.317   8.366  0.00  0.00           N  
ATOM    325  CA  VAL A  21       2.142 -11.698   8.432  0.00  0.00           C  
ATOM    326  C   VAL A  21       1.204 -11.987   7.255  0.00  0.00           C  
ATOM    327  O   VAL A  21       1.304 -13.043   6.633  0.00  0.00           O  
ATOM    328  CB  VAL A  21       1.503 -12.020   9.798  0.00  0.00           C  
ATOM    329  CG1 VAL A  21       0.259 -11.196  10.143  0.00  0.00           C  
ATOM    330  CG2 VAL A  21       1.148 -13.507   9.907  0.00  0.00           C  
ATOM    331  H   VAL A  21       2.122  -9.578   8.803  0.00  0.00           H  
ATOM    332  HA  VAL A  21       2.993 -12.364   8.326  0.00  0.00           H  
ATOM    333  HB  VAL A  21       2.254 -11.813  10.562  0.00  0.00           H  
ATOM    334 HG11 VAL A  21      -0.551 -11.401   9.444  0.00  0.00           H  
ATOM    335 HG12 VAL A  21      -0.076 -11.446  11.148  0.00  0.00           H  
ATOM    336 HG13 VAL A  21       0.499 -10.140  10.120  0.00  0.00           H  
ATOM    337 HG21 VAL A  21       0.345 -13.760   9.214  0.00  0.00           H  
ATOM    338 HG22 VAL A  21       2.023 -14.115   9.681  0.00  0.00           H  
ATOM    339 HG23 VAL A  21       0.819 -13.732  10.923  0.00  0.00           H  
ATOM    340  N   ASP A  22       0.373 -11.002   6.908  0.00  0.00           N  
ATOM    341  CA  ASP A  22      -0.644 -10.957   5.847  0.00  0.00           C  
ATOM    342  C   ASP A  22      -1.345  -9.591   5.918  0.00  0.00           C  
ATOM    343  O   ASP A  22      -0.843  -8.671   6.580  0.00  0.00           O  
ATOM    344  CB  ASP A  22      -1.611 -12.165   5.889  0.00  0.00           C  
ATOM    345  CG  ASP A  22      -2.478 -12.247   7.153  0.00  0.00           C  
ATOM    346  OD1 ASP A  22      -3.469 -11.488   7.236  0.00  0.00           O  
ATOM    347  OD2 ASP A  22      -2.205 -13.090   8.039  0.00  0.00           O  
ATOM    348  H   ASP A  22       0.467 -10.132   7.420  0.00  0.00           H  
ATOM    349  HA  ASP A  22      -0.157 -10.975   4.881  0.00  0.00           H  
ATOM    350  HB2 ASP A  22      -2.265 -12.111   5.017  0.00  0.00           H  
ATOM    351  HB3 ASP A  22      -1.051 -13.091   5.772  0.00  0.00           H  
ATOM    352  N   ALA A  23      -2.511  -9.439   5.284  0.00  0.00           N  
ATOM    353  CA  ALA A  23      -3.367  -8.265   5.434  0.00  0.00           C  
ATOM    354  C   ALA A  23      -3.578  -7.818   6.907  0.00  0.00           C  
ATOM    355  O   ALA A  23      -3.725  -6.628   7.168  0.00  0.00           O  
ATOM    356  CB  ALA A  23      -4.702  -8.542   4.733  0.00  0.00           C  
ATOM    357  H   ALA A  23      -2.878 -10.220   4.761  0.00  0.00           H  
ATOM    358  HA  ALA A  23      -2.883  -7.453   4.898  0.00  0.00           H  
ATOM    359  HB1 ALA A  23      -5.215  -9.371   5.222  0.00  0.00           H  
ATOM    360  HB2 ALA A  23      -5.333  -7.654   4.788  0.00  0.00           H  
ATOM    361  HB3 ALA A  23      -4.530  -8.787   3.685  0.00  0.00           H  
ATOM    362  N   ALA A  24      -3.493  -8.723   7.891  0.00  0.00           N  
ATOM    363  CA  ALA A  24      -3.636  -8.444   9.327  0.00  0.00           C  
ATOM    364  C   ALA A  24      -2.480  -7.615   9.920  0.00  0.00           C  
ATOM    365  O   ALA A  24      -2.527  -7.221  11.087  0.00  0.00           O  
ATOM    366  CB  ALA A  24      -3.788  -9.783  10.060  0.00  0.00           C  
ATOM    367  H   ALA A  24      -3.217  -9.663   7.628  0.00  0.00           H  
ATOM    368  HA  ALA A  24      -4.554  -7.868   9.471  0.00  0.00           H  
ATOM    369  HB1 ALA A  24      -2.886 -10.385   9.937  0.00  0.00           H  
ATOM    370  HB2 ALA A  24      -3.952  -9.603  11.124  0.00  0.00           H  
ATOM    371  HB3 ALA A  24      -4.645 -10.332   9.661  0.00  0.00           H  
ATOM    372  N   THR A  25      -1.443  -7.341   9.121  0.00  0.00           N  
ATOM    373  CA  THR A  25      -0.327  -6.455   9.464  0.00  0.00           C  
ATOM    374  C   THR A  25       0.014  -5.483   8.328  0.00  0.00           C  
ATOM    375  O   THR A  25       0.308  -4.318   8.588  0.00  0.00           O  
ATOM    376  CB  THR A  25       0.884  -7.300   9.886  0.00  0.00           C  
ATOM    377  OG1 THR A  25       0.656  -7.810  11.181  0.00  0.00           O  
ATOM    378  CG2 THR A  25       2.227  -6.580   9.973  0.00  0.00           C  
ATOM    379  H   THR A  25      -1.445  -7.768   8.202  0.00  0.00           H  
ATOM    380  HA  THR A  25      -0.627  -5.855  10.310  0.00  0.00           H  
ATOM    381  HB  THR A  25       0.990  -8.125   9.179  0.00  0.00           H  
ATOM    382  HG1 THR A  25      -0.288  -8.035  11.260  0.00  0.00           H  
ATOM    383 HG21 THR A  25       2.986  -7.300  10.282  0.00  0.00           H  
ATOM    384 HG22 THR A  25       2.508  -6.185   9.000  0.00  0.00           H  
ATOM    385 HG23 THR A  25       2.175  -5.768  10.697  0.00  0.00           H  
ATOM    386  N   ALA A  26      -0.107  -5.909   7.067  0.00  0.00           N  
ATOM    387  CA  ALA A  26       0.085  -5.054   5.899  0.00  0.00           C  
ATOM    388  C   ALA A  26      -0.984  -3.937   5.853  0.00  0.00           C  
ATOM    389  O   ALA A  26      -0.655  -2.773   5.608  0.00  0.00           O  
ATOM    390  CB  ALA A  26       0.108  -5.978   4.676  0.00  0.00           C  
ATOM    391  H   ALA A  26      -0.440  -6.850   6.897  0.00  0.00           H  
ATOM    392  HA  ALA A  26       1.059  -4.564   5.943  0.00  0.00           H  
ATOM    393  HB1 ALA A  26       0.972  -6.648   4.731  0.00  0.00           H  
ATOM    394  HB2 ALA A  26      -0.799  -6.577   4.628  0.00  0.00           H  
ATOM    395  HB3 ALA A  26       0.197  -5.387   3.769  0.00  0.00           H  
ATOM    396  N   GLU A  27      -2.238  -4.236   6.231  0.00  0.00           N  
ATOM    397  CA  GLU A  27      -3.343  -3.261   6.266  0.00  0.00           C  
ATOM    398  C   GLU A  27      -3.285  -2.257   7.442  0.00  0.00           C  
ATOM    399  O   GLU A  27      -4.189  -1.440   7.621  0.00  0.00           O  
ATOM    400  CB  GLU A  27      -4.712  -3.973   6.247  0.00  0.00           C  
ATOM    401  CG  GLU A  27      -5.834  -3.089   5.680  0.00  0.00           C  
ATOM    402  CD  GLU A  27      -7.146  -3.145   6.483  0.00  0.00           C  
ATOM    403  OE1 GLU A  27      -7.657  -4.253   6.781  0.00  0.00           O  
ATOM    404  OE2 GLU A  27      -7.696  -2.056   6.778  0.00  0.00           O  
ATOM    405  H   GLU A  27      -2.460  -5.193   6.482  0.00  0.00           H  
ATOM    406  HA  GLU A  27      -3.238  -2.692   5.348  0.00  0.00           H  
ATOM    407  HB2 GLU A  27      -4.657  -4.860   5.616  0.00  0.00           H  
ATOM    408  HB3 GLU A  27      -4.957  -4.283   7.264  0.00  0.00           H  
ATOM    409  HG2 GLU A  27      -5.478  -2.060   5.652  0.00  0.00           H  
ATOM    410  HG3 GLU A  27      -6.037  -3.382   4.650  0.00  0.00           H  
ATOM    411  N   LYS A  28      -2.224  -2.277   8.253  0.00  0.00           N  
ATOM    412  CA  LYS A  28      -1.974  -1.316   9.334  0.00  0.00           C  
ATOM    413  C   LYS A  28      -0.535  -0.805   9.315  0.00  0.00           C  
ATOM    414  O   LYS A  28      -0.066  -0.247  10.303  0.00  0.00           O  
ATOM    415  CB  LYS A  28      -2.431  -1.891  10.691  0.00  0.00           C  
ATOM    416  CG  LYS A  28      -2.038  -3.349  11.009  0.00  0.00           C  
ATOM    417  CD  LYS A  28      -0.959  -3.542  12.084  0.00  0.00           C  
ATOM    418  CE  LYS A  28       0.456  -3.179  11.619  0.00  0.00           C  
ATOM    419  NZ  LYS A  28       0.960  -1.936  12.265  0.00  0.00           N  
ATOM    420  H   LYS A  28      -1.522  -2.991   8.116  0.00  0.00           H  
ATOM    421  HA  LYS A  28      -2.591  -0.436   9.136  0.00  0.00           H  
ATOM    422  HB2 LYS A  28      -2.100  -1.231  11.494  0.00  0.00           H  
ATOM    423  HB3 LYS A  28      -3.521  -1.852  10.690  0.00  0.00           H  
ATOM    424  HG2 LYS A  28      -2.932  -3.850  11.370  0.00  0.00           H  
ATOM    425  HG3 LYS A  28      -1.745  -3.884  10.112  0.00  0.00           H  
ATOM    426  HD2 LYS A  28      -1.233  -2.989  12.983  0.00  0.00           H  
ATOM    427  HD3 LYS A  28      -0.956  -4.601  12.345  0.00  0.00           H  
ATOM    428  HE2 LYS A  28       1.117  -4.011  11.878  0.00  0.00           H  
ATOM    429  HE3 LYS A  28       0.465  -3.087  10.523  0.00  0.00           H  
ATOM    430  HZ1 LYS A  28       0.465  -1.120  11.915  0.00  0.00           H  
ATOM    431  HZ2 LYS A  28       0.860  -1.969  13.271  0.00  0.00           H  
ATOM    432  HZ3 LYS A  28       1.941  -1.791  12.066  0.00  0.00           H  
ATOM    433  N   VAL A  29       0.154  -0.959   8.184  0.00  0.00           N  
ATOM    434  CA  VAL A  29       1.535  -0.488   7.954  0.00  0.00           C  
ATOM    435  C   VAL A  29       1.561   0.502   6.803  0.00  0.00           C  
ATOM    436  O   VAL A  29       1.999   1.641   6.962  0.00  0.00           O  
ATOM    437  CB  VAL A  29       2.483  -1.674   7.695  0.00  0.00           C  
ATOM    438  CG1 VAL A  29       3.750  -1.291   6.918  0.00  0.00           C  
ATOM    439  CG2 VAL A  29       2.948  -2.257   9.017  0.00  0.00           C  
ATOM    440  H   VAL A  29      -0.334  -1.411   7.417  0.00  0.00           H  
ATOM    441  HA  VAL A  29       1.899   0.044   8.825  0.00  0.00           H  
ATOM    442  HB  VAL A  29       1.941  -2.464   7.176  0.00  0.00           H  
ATOM    443 HG11 VAL A  29       3.520  -1.111   5.868  0.00  0.00           H  
ATOM    444 HG12 VAL A  29       4.212  -0.405   7.356  0.00  0.00           H  
ATOM    445 HG13 VAL A  29       4.465  -2.105   6.972  0.00  0.00           H  
ATOM    446 HG21 VAL A  29       2.074  -2.557   9.574  0.00  0.00           H  
ATOM    447 HG22 VAL A  29       3.564  -3.136   8.822  0.00  0.00           H  
ATOM    448 HG23 VAL A  29       3.518  -1.513   9.570  0.00  0.00           H  
ATOM    449  N   PHE A  30       0.989   0.099   5.677  0.00  0.00           N  
ATOM    450  CA  PHE A  30       0.857   0.935   4.491  0.00  0.00           C  
ATOM    451  C   PHE A  30       0.023   2.190   4.731  0.00  0.00           C  
ATOM    452  O   PHE A  30       0.275   3.213   4.102  0.00  0.00           O  
ATOM    453  CB  PHE A  30       0.246   0.086   3.381  0.00  0.00           C  
ATOM    454  CG  PHE A  30       1.098  -1.087   2.923  0.00  0.00           C  
ATOM    455  CD1 PHE A  30       2.495  -0.958   2.776  0.00  0.00           C  
ATOM    456  CD2 PHE A  30       0.485  -2.319   2.637  0.00  0.00           C  
ATOM    457  CE1 PHE A  30       3.262  -2.037   2.302  0.00  0.00           C  
ATOM    458  CE2 PHE A  30       1.255  -3.402   2.177  0.00  0.00           C  
ATOM    459  CZ  PHE A  30       2.640  -3.256   1.990  0.00  0.00           C  
ATOM    460  H   PHE A  30       0.655  -0.853   5.629  0.00  0.00           H  
ATOM    461  HA  PHE A  30       1.845   1.285   4.184  0.00  0.00           H  
ATOM    462  HB2 PHE A  30      -0.730  -0.281   3.696  0.00  0.00           H  
ATOM    463  HB3 PHE A  30       0.056   0.747   2.544  0.00  0.00           H  
ATOM    464  HD1 PHE A  30       2.993  -0.034   3.030  0.00  0.00           H  
ATOM    465  HD2 PHE A  30      -0.582  -2.437   2.771  0.00  0.00           H  
ATOM    466  HE1 PHE A  30       4.330  -1.926   2.182  0.00  0.00           H  
ATOM    467  HE2 PHE A  30       0.783  -4.347   1.961  0.00  0.00           H  
ATOM    468  HZ  PHE A  30       3.225  -4.086   1.623  0.00  0.00           H  
ATOM    469  N   LYS A  31      -0.908   2.151   5.690  0.00  0.00           N  
ATOM    470  CA  LYS A  31      -1.723   3.303   6.114  0.00  0.00           C  
ATOM    471  C   LYS A  31      -0.879   4.506   6.546  0.00  0.00           C  
ATOM    472  O   LYS A  31      -1.295   5.647   6.347  0.00  0.00           O  
ATOM    473  CB  LYS A  31      -2.673   2.885   7.252  0.00  0.00           C  
ATOM    474  CG  LYS A  31      -3.493   1.612   6.964  0.00  0.00           C  
ATOM    475  CD  LYS A  31      -4.364   1.752   5.707  0.00  0.00           C  
ATOM    476  CE  LYS A  31      -5.262   0.538   5.460  0.00  0.00           C  
ATOM    477  NZ  LYS A  31      -6.208   0.301   6.584  0.00  0.00           N  
ATOM    478  H   LYS A  31      -1.039   1.268   6.164  0.00  0.00           H  
ATOM    479  HA  LYS A  31      -2.315   3.647   5.266  0.00  0.00           H  
ATOM    480  HB2 LYS A  31      -2.091   2.713   8.159  0.00  0.00           H  
ATOM    481  HB3 LYS A  31      -3.351   3.719   7.441  0.00  0.00           H  
ATOM    482  HG2 LYS A  31      -2.808   0.771   6.852  0.00  0.00           H  
ATOM    483  HG3 LYS A  31      -4.134   1.388   7.816  0.00  0.00           H  
ATOM    484  HD2 LYS A  31      -4.979   2.650   5.778  0.00  0.00           H  
ATOM    485  HD3 LYS A  31      -3.707   1.846   4.846  0.00  0.00           H  
ATOM    486  HE2 LYS A  31      -5.815   0.693   4.529  0.00  0.00           H  
ATOM    487  HE3 LYS A  31      -4.609  -0.334   5.326  0.00  0.00           H  
ATOM    488  HZ1 LYS A  31      -6.757   1.118   6.803  0.00  0.00           H  
ATOM    489  HZ2 LYS A  31      -6.847  -0.471   6.393  0.00  0.00           H  
ATOM    490  HZ3 LYS A  31      -5.691   0.004   7.406  0.00  0.00           H  
ATOM    491  N   GLN A  32       0.316   4.247   7.085  0.00  0.00           N  
ATOM    492  CA  GLN A  32       1.259   5.294   7.489  0.00  0.00           C  
ATOM    493  C   GLN A  32       2.035   5.798   6.266  0.00  0.00           C  
ATOM    494  O   GLN A  32       2.004   6.989   5.958  0.00  0.00           O  
ATOM    495  CB  GLN A  32       2.240   4.773   8.556  0.00  0.00           C  
ATOM    496  CG  GLN A  32       1.624   4.587   9.955  0.00  0.00           C  
ATOM    497  CD  GLN A  32       0.502   3.552  10.044  0.00  0.00           C  
ATOM    498  OE1 GLN A  32      -0.548   3.780  10.628  0.00  0.00           O  
ATOM    499  NE2 GLN A  32       0.670   2.378   9.475  0.00  0.00           N  
ATOM    500  H   GLN A  32       0.609   3.278   7.135  0.00  0.00           H  
ATOM    501  HA  GLN A  32       0.706   6.125   7.922  0.00  0.00           H  
ATOM    502  HB2 GLN A  32       2.699   3.841   8.224  0.00  0.00           H  
ATOM    503  HB3 GLN A  32       3.044   5.505   8.657  0.00  0.00           H  
ATOM    504  HG2 GLN A  32       2.420   4.278  10.634  0.00  0.00           H  
ATOM    505  HG3 GLN A  32       1.245   5.550  10.301  0.00  0.00           H  
ATOM    506 HE21 GLN A  32       1.520   2.168   8.974  0.00  0.00           H  
ATOM    507 HE22 GLN A  32      -0.027   1.663   9.633  0.00  0.00           H  
ATOM    508  N   TYR A  33       2.665   4.880   5.523  0.00  0.00           N  
ATOM    509  CA  TYR A  33       3.502   5.191   4.359  0.00  0.00           C  
ATOM    510  C   TYR A  33       2.722   5.923   3.258  0.00  0.00           C  
ATOM    511  O   TYR A  33       3.202   6.892   2.668  0.00  0.00           O  
ATOM    512  CB  TYR A  33       4.097   3.880   3.826  0.00  0.00           C  
ATOM    513  CG  TYR A  33       4.974   4.081   2.605  0.00  0.00           C  
ATOM    514  CD1 TYR A  33       4.392   4.104   1.323  0.00  0.00           C  
ATOM    515  CD2 TYR A  33       6.355   4.311   2.755  0.00  0.00           C  
ATOM    516  CE1 TYR A  33       5.184   4.396   0.192  0.00  0.00           C  
ATOM    517  CE2 TYR A  33       7.154   4.572   1.626  0.00  0.00           C  
ATOM    518  CZ  TYR A  33       6.571   4.623   0.342  0.00  0.00           C  
ATOM    519  OH  TYR A  33       7.345   4.921  -0.736  0.00  0.00           O  
ATOM    520  H   TYR A  33       2.569   3.910   5.787  0.00  0.00           H  
ATOM    521  HA  TYR A  33       4.321   5.840   4.673  0.00  0.00           H  
ATOM    522  HB2 TYR A  33       4.685   3.412   4.616  0.00  0.00           H  
ATOM    523  HB3 TYR A  33       3.286   3.195   3.574  0.00  0.00           H  
ATOM    524  HD1 TYR A  33       3.331   3.911   1.215  0.00  0.00           H  
ATOM    525  HD2 TYR A  33       6.801   4.299   3.742  0.00  0.00           H  
ATOM    526  HE1 TYR A  33       4.725   4.493  -0.781  0.00  0.00           H  
ATOM    527  HE2 TYR A  33       8.213   4.754   1.736  0.00  0.00           H  
ATOM    528  HH  TYR A  33       6.848   4.914  -1.572  0.00  0.00           H  
ATOM    529  N   ALA A  34       1.490   5.492   2.997  0.00  0.00           N  
ATOM    530  CA  ALA A  34       0.600   6.129   2.044  0.00  0.00           C  
ATOM    531  C   ALA A  34       0.315   7.581   2.420  0.00  0.00           C  
ATOM    532  O   ALA A  34       0.546   8.464   1.599  0.00  0.00           O  
ATOM    533  CB  ALA A  34      -0.663   5.290   1.913  0.00  0.00           C  
ATOM    534  H   ALA A  34       1.150   4.679   3.493  0.00  0.00           H  
ATOM    535  HA  ALA A  34       1.096   6.149   1.088  0.00  0.00           H  
ATOM    536  HB1 ALA A  34      -0.388   4.308   1.532  0.00  0.00           H  
ATOM    537  HB2 ALA A  34      -1.140   5.193   2.890  0.00  0.00           H  
ATOM    538  HB3 ALA A  34      -1.355   5.755   1.212  0.00  0.00           H  
ATOM    539  N   ASN A  35      -0.059   7.841   3.675  0.00  0.00           N  
ATOM    540  CA  ASN A  35      -0.239   9.196   4.197  0.00  0.00           C  
ATOM    541  C   ASN A  35       1.066  10.018   4.255  0.00  0.00           C  
ATOM    542  O   ASN A  35       0.995  11.248   4.225  0.00  0.00           O  
ATOM    543  CB  ASN A  35      -0.937   9.122   5.564  0.00  0.00           C  
ATOM    544  CG  ASN A  35      -2.445   9.023   5.404  0.00  0.00           C  
ATOM    545  OD1 ASN A  35      -3.117  10.002   5.104  0.00  0.00           O  
ATOM    546  ND2 ASN A  35      -3.025   7.861   5.586  0.00  0.00           N  
ATOM    547  H   ASN A  35      -0.186   7.063   4.307  0.00  0.00           H  
ATOM    548  HA  ASN A  35      -0.902   9.736   3.520  0.00  0.00           H  
ATOM    549  HB2 ASN A  35      -0.554   8.281   6.144  0.00  0.00           H  
ATOM    550  HB3 ASN A  35      -0.730  10.037   6.119  0.00  0.00           H  
ATOM    551 HD21 ASN A  35      -2.475   7.052   5.852  0.00  0.00           H  
ATOM    552 HD22 ASN A  35      -4.026   7.802   5.403  0.00  0.00           H  
ATOM    553  N   ASP A  36       2.247   9.387   4.287  0.00  0.00           N  
ATOM    554  CA  ASP A  36       3.533  10.099   4.232  0.00  0.00           C  
ATOM    555  C   ASP A  36       3.891  10.567   2.813  0.00  0.00           C  
ATOM    556  O   ASP A  36       4.555  11.595   2.656  0.00  0.00           O  
ATOM    557  CB  ASP A  36       4.678   9.239   4.802  0.00  0.00           C  
ATOM    558  CG  ASP A  36       4.568   8.935   6.307  0.00  0.00           C  
ATOM    559  OD1 ASP A  36       4.115   9.810   7.085  0.00  0.00           O  
ATOM    560  OD2 ASP A  36       5.013   7.841   6.736  0.00  0.00           O  
ATOM    561  H   ASP A  36       2.260   8.377   4.358  0.00  0.00           H  
ATOM    562  HA  ASP A  36       3.426  11.023   4.800  0.00  0.00           H  
ATOM    563  HB2 ASP A  36       4.730   8.308   4.240  0.00  0.00           H  
ATOM    564  HB3 ASP A  36       5.616   9.771   4.638  0.00  0.00           H  
ATOM    565  N   ASN A  37       3.437   9.848   1.778  0.00  0.00           N  
ATOM    566  CA  ASN A  37       3.504  10.351   0.401  0.00  0.00           C  
ATOM    567  C   ASN A  37       2.366  11.361   0.199  0.00  0.00           C  
ATOM    568  O   ASN A  37       2.553  12.426  -0.392  0.00  0.00           O  
ATOM    569  CB  ASN A  37       3.376   9.190  -0.595  0.00  0.00           C  
ATOM    570  CG  ASN A  37       4.615   8.319  -0.586  0.00  0.00           C  
ATOM    571  OD1 ASN A  37       5.575   8.546  -1.309  0.00  0.00           O  
ATOM    572  ND2 ASN A  37       4.635   7.308   0.244  0.00  0.00           N  
ATOM    573  H   ASN A  37       2.893   9.014   1.982  0.00  0.00           H  
ATOM    574  HA  ASN A  37       4.452  10.866   0.228  0.00  0.00           H  
ATOM    575  HB2 ASN A  37       2.497   8.588  -0.363  0.00  0.00           H  
ATOM    576  HB3 ASN A  37       3.257   9.591  -1.603  0.00  0.00           H  
ATOM    577 HD21 ASN A  37       3.849   7.115   0.854  0.00  0.00           H  
ATOM    578 HD22 ASN A  37       5.465   6.746   0.307  0.00  0.00           H  
ATOM    579  N   GLY A  38       1.198  11.005   0.742  0.00  0.00           N  
ATOM    580  CA  GLY A  38      -0.010  11.777   0.883  0.00  0.00           C  
ATOM    581  C   GLY A  38      -1.263  11.114   0.296  0.00  0.00           C  
ATOM    582  O   GLY A  38      -2.350  11.685   0.394  0.00  0.00           O  
ATOM    583  H   GLY A  38       1.151  10.109   1.182  0.00  0.00           H  
ATOM    584  HA2 GLY A  38      -0.184  11.990   1.938  0.00  0.00           H  
ATOM    585  HA3 GLY A  38       0.202  12.681   0.377  0.00  0.00           H  
ATOM    586  N   VAL A  39      -1.142   9.926  -0.315  0.00  0.00           N  
ATOM    587  CA  VAL A  39      -2.292   9.174  -0.841  0.00  0.00           C  
ATOM    588  C   VAL A  39      -3.096   8.556   0.288  0.00  0.00           C  
ATOM    589  O   VAL A  39      -2.537   8.095   1.283  0.00  0.00           O  
ATOM    590  CB  VAL A  39      -1.854   8.045  -1.785  0.00  0.00           C  
ATOM    591  CG1 VAL A  39      -3.000   7.293  -2.452  0.00  0.00           C  
ATOM    592  CG2 VAL A  39      -1.078   8.653  -2.937  0.00  0.00           C  
ATOM    593  H   VAL A  39      -0.235   9.468  -0.326  0.00  0.00           H  
ATOM    594  HA  VAL A  39      -2.931   9.864  -1.389  0.00  0.00           H  
ATOM    595  HB  VAL A  39      -1.250   7.317  -1.250  0.00  0.00           H  
ATOM    596 HG11 VAL A  39      -2.571   6.615  -3.195  0.00  0.00           H  
ATOM    597 HG12 VAL A  39      -3.540   6.706  -1.717  0.00  0.00           H  
ATOM    598 HG13 VAL A  39      -3.678   7.985  -2.937  0.00  0.00           H  
ATOM    599 HG21 VAL A  39      -0.931   7.930  -3.731  0.00  0.00           H  
ATOM    600 HG22 VAL A  39      -1.666   9.477  -3.333  0.00  0.00           H  
ATOM    601 HG23 VAL A  39      -0.110   8.984  -2.572  0.00  0.00           H  
ATOM    602  N   ASP A  40      -4.413   8.483   0.093  0.00  0.00           N  
ATOM    603  CA  ASP A  40      -5.289   7.717   0.978  0.00  0.00           C  
ATOM    604  C   ASP A  40      -6.660   7.397   0.330  0.00  0.00           C  
ATOM    605  O   ASP A  40      -7.721   7.768   0.838  0.00  0.00           O  
ATOM    606  CB  ASP A  40      -5.421   8.405   2.361  0.00  0.00           C  
ATOM    607  CG  ASP A  40      -5.861   7.452   3.490  0.00  0.00           C  
ATOM    608  OD1 ASP A  40      -6.292   6.310   3.215  0.00  0.00           O  
ATOM    609  OD2 ASP A  40      -5.740   7.829   4.680  0.00  0.00           O  
ATOM    610  H   ASP A  40      -4.766   8.770  -0.808  0.00  0.00           H  
ATOM    611  HA  ASP A  40      -4.728   6.786   1.052  0.00  0.00           H  
ATOM    612  HB2 ASP A  40      -4.465   8.833   2.655  0.00  0.00           H  
ATOM    613  HB3 ASP A  40      -6.120   9.238   2.286  0.00  0.00           H  
ATOM    614  N   GLY A  41      -6.624   6.794  -0.862  0.00  0.00           N  
ATOM    615  CA  GLY A  41      -7.797   6.401  -1.661  0.00  0.00           C  
ATOM    616  C   GLY A  41      -8.305   4.965  -1.429  0.00  0.00           C  
ATOM    617  O   GLY A  41      -8.434   4.522  -0.288  0.00  0.00           O  
ATOM    618  H   GLY A  41      -5.708   6.546  -1.218  0.00  0.00           H  
ATOM    619  HA2 GLY A  41      -8.625   7.081  -1.460  0.00  0.00           H  
ATOM    620  HA3 GLY A  41      -7.546   6.517  -2.707  0.00  0.00           H  
ATOM    621  N   GLU A  42      -8.666   4.246  -2.503  0.00  0.00           N  
ATOM    622  CA  GLU A  42      -9.324   2.923  -2.450  0.00  0.00           C  
ATOM    623  C   GLU A  42      -8.388   1.802  -1.942  0.00  0.00           C  
ATOM    624  O   GLU A  42      -7.617   1.211  -2.697  0.00  0.00           O  
ATOM    625  CB  GLU A  42     -10.054   2.606  -3.785  0.00  0.00           C  
ATOM    626  CG  GLU A  42      -9.247   1.931  -4.911  0.00  0.00           C  
ATOM    627  CD  GLU A  42      -9.940   1.921  -6.292  0.00  0.00           C  
ATOM    628  OE1 GLU A  42     -11.149   2.243  -6.403  0.00  0.00           O  
ATOM    629  OE2 GLU A  42      -9.273   1.560  -7.294  0.00  0.00           O  
ATOM    630  H   GLU A  42      -8.519   4.658  -3.419  0.00  0.00           H  
ATOM    631  HA  GLU A  42     -10.120   3.008  -1.709  0.00  0.00           H  
ATOM    632  HB2 GLU A  42     -10.895   1.950  -3.552  0.00  0.00           H  
ATOM    633  HB3 GLU A  42     -10.468   3.543  -4.165  0.00  0.00           H  
ATOM    634  HG2 GLU A  42      -8.278   2.424  -4.986  0.00  0.00           H  
ATOM    635  HG3 GLU A  42      -9.075   0.890  -4.635  0.00  0.00           H  
ATOM    636  N   TRP A  43      -8.405   1.511  -0.640  0.00  0.00           N  
ATOM    637  CA  TRP A  43      -7.583   0.454  -0.048  0.00  0.00           C  
ATOM    638  C   TRP A  43      -7.998  -0.915  -0.582  0.00  0.00           C  
ATOM    639  O   TRP A  43      -9.107  -1.399  -0.336  0.00  0.00           O  
ATOM    640  CB  TRP A  43      -7.623   0.522   1.481  0.00  0.00           C  
ATOM    641  CG  TRP A  43      -6.753   1.610   2.018  0.00  0.00           C  
ATOM    642  CD1 TRP A  43      -7.172   2.804   2.487  0.00  0.00           C  
ATOM    643  CD2 TRP A  43      -5.293   1.656   2.045  0.00  0.00           C  
ATOM    644  NE1 TRP A  43      -6.078   3.583   2.800  0.00  0.00           N  
ATOM    645  CE2 TRP A  43      -4.894   2.935   2.535  0.00  0.00           C  
ATOM    646  CE3 TRP A  43      -4.266   0.759   1.675  0.00  0.00           C  
ATOM    647  CZ2 TRP A  43      -3.548   3.309   2.647  0.00  0.00           C  
ATOM    648  CZ3 TRP A  43      -2.910   1.120   1.796  0.00  0.00           C  
ATOM    649  CH2 TRP A  43      -2.554   2.388   2.279  0.00  0.00           C  
ATOM    650  H   TRP A  43      -9.039   2.006  -0.034  0.00  0.00           H  
ATOM    651  HA  TRP A  43      -6.547   0.614  -0.353  0.00  0.00           H  
ATOM    652  HB2 TRP A  43      -8.651   0.658   1.823  0.00  0.00           H  
ATOM    653  HB3 TRP A  43      -7.257  -0.424   1.885  0.00  0.00           H  
ATOM    654  HD1 TRP A  43      -8.207   3.123   2.554  0.00  0.00           H  
ATOM    655  HE1 TRP A  43      -6.159   4.566   3.082  0.00  0.00           H  
ATOM    656  HE3 TRP A  43      -4.529  -0.210   1.275  0.00  0.00           H  
ATOM    657  HZ2 TRP A  43      -3.282   4.286   3.016  0.00  0.00           H  
ATOM    658  HZ3 TRP A  43      -2.129   0.436   1.502  0.00  0.00           H  
ATOM    659  HH2 TRP A  43      -1.511   2.648   2.361  0.00  0.00           H  
ATOM    660  N   THR A  44      -7.082  -1.523  -1.329  0.00  0.00           N  
ATOM    661  CA  THR A  44      -7.275  -2.758  -2.091  0.00  0.00           C  
ATOM    662  C   THR A  44      -6.167  -3.765  -1.802  0.00  0.00           C  
ATOM    663  O   THR A  44      -5.100  -3.400  -1.309  0.00  0.00           O  
ATOM    664  CB  THR A  44      -7.317  -2.506  -3.618  0.00  0.00           C  
ATOM    665  OG1 THR A  44      -6.874  -1.228  -4.029  0.00  0.00           O  
ATOM    666  CG2 THR A  44      -8.723  -2.723  -4.151  0.00  0.00           C  
ATOM    667  H   THR A  44      -6.209  -1.029  -1.490  0.00  0.00           H  
ATOM    668  HA  THR A  44      -8.220  -3.199  -1.777  0.00  0.00           H  
ATOM    669  HB  THR A  44      -6.678  -3.235  -4.118  0.00  0.00           H  
ATOM    670  HG1 THR A  44      -7.297  -0.552  -3.469  0.00  0.00           H  
ATOM    671 HG21 THR A  44      -9.424  -2.063  -3.639  0.00  0.00           H  
ATOM    672 HG22 THR A  44      -8.737  -2.527  -5.223  0.00  0.00           H  
ATOM    673 HG23 THR A  44      -8.993  -3.766  -3.976  0.00  0.00           H  
ATOM    674  N   TYR A  45      -6.406  -5.026  -2.163  0.00  0.00           N  
ATOM    675  CA  TYR A  45      -5.448  -6.131  -2.070  0.00  0.00           C  
ATOM    676  C   TYR A  45      -5.678  -7.128  -3.214  0.00  0.00           C  
ATOM    677  O   TYR A  45      -6.820  -7.348  -3.628  0.00  0.00           O  
ATOM    678  CB  TYR A  45      -5.626  -6.819  -0.707  0.00  0.00           C  
ATOM    679  CG  TYR A  45      -4.614  -7.894  -0.342  0.00  0.00           C  
ATOM    680  CD1 TYR A  45      -3.232  -7.638  -0.460  0.00  0.00           C  
ATOM    681  CD2 TYR A  45      -5.049  -9.103   0.239  0.00  0.00           C  
ATOM    682  CE1 TYR A  45      -2.295  -8.532   0.090  0.00  0.00           C  
ATOM    683  CE2 TYR A  45      -4.112 -10.004   0.778  0.00  0.00           C  
ATOM    684  CZ  TYR A  45      -2.741  -9.695   0.752  0.00  0.00           C  
ATOM    685  OH  TYR A  45      -1.868 -10.504   1.404  0.00  0.00           O  
ATOM    686  H   TYR A  45      -7.306  -5.248  -2.567  0.00  0.00           H  
ATOM    687  HA  TYR A  45      -4.439  -5.738  -2.136  0.00  0.00           H  
ATOM    688  HB2 TYR A  45      -5.565  -6.054   0.070  0.00  0.00           H  
ATOM    689  HB3 TYR A  45      -6.630  -7.242  -0.662  0.00  0.00           H  
ATOM    690  HD1 TYR A  45      -2.890  -6.718  -0.904  0.00  0.00           H  
ATOM    691  HD2 TYR A  45      -6.107  -9.321   0.317  0.00  0.00           H  
ATOM    692  HE1 TYR A  45      -1.241  -8.304   0.060  0.00  0.00           H  
ATOM    693  HE2 TYR A  45      -4.423 -10.916   1.261  0.00  0.00           H  
ATOM    694  HH  TYR A  45      -0.975 -10.131   1.438  0.00  0.00           H  
ATOM    695  N   ASP A  46      -4.612  -7.760  -3.702  0.00  0.00           N  
ATOM    696  CA  ASP A  46      -4.676  -8.867  -4.656  0.00  0.00           C  
ATOM    697  C   ASP A  46      -4.202 -10.146  -3.964  0.00  0.00           C  
ATOM    698  O   ASP A  46      -3.074 -10.213  -3.477  0.00  0.00           O  
ATOM    699  CB  ASP A  46      -3.805  -8.565  -5.880  0.00  0.00           C  
ATOM    700  CG  ASP A  46      -4.007  -9.651  -6.946  0.00  0.00           C  
ATOM    701  OD1 ASP A  46      -3.522 -10.785  -6.725  0.00  0.00           O  
ATOM    702  OD2 ASP A  46      -4.659  -9.379  -7.981  0.00  0.00           O  
ATOM    703  H   ASP A  46      -3.695  -7.510  -3.354  0.00  0.00           H  
ATOM    704  HA  ASP A  46      -5.700  -9.012  -5.000  0.00  0.00           H  
ATOM    705  HB2 ASP A  46      -4.069  -7.594  -6.291  0.00  0.00           H  
ATOM    706  HB3 ASP A  46      -2.757  -8.524  -5.583  0.00  0.00           H  
ATOM    707  N   ASP A  47      -5.051 -11.170  -3.913  0.00  0.00           N  
ATOM    708  CA  ASP A  47      -4.759 -12.391  -3.159  0.00  0.00           C  
ATOM    709  C   ASP A  47      -3.876 -13.424  -3.891  0.00  0.00           C  
ATOM    710  O   ASP A  47      -3.539 -14.453  -3.300  0.00  0.00           O  
ATOM    711  CB  ASP A  47      -6.068 -12.999  -2.624  0.00  0.00           C  
ATOM    712  CG  ASP A  47      -6.322 -12.564  -1.172  0.00  0.00           C  
ATOM    713  OD1 ASP A  47      -5.487 -12.916  -0.303  0.00  0.00           O  
ATOM    714  OD2 ASP A  47      -7.342 -11.888  -0.898  0.00  0.00           O  
ATOM    715  H   ASP A  47      -5.965 -11.073  -4.333  0.00  0.00           H  
ATOM    716  HA  ASP A  47      -4.155 -12.076  -2.310  0.00  0.00           H  
ATOM    717  HB2 ASP A  47      -6.906 -12.710  -3.263  0.00  0.00           H  
ATOM    718  HB3 ASP A  47      -6.011 -14.088  -2.642  0.00  0.00           H  
ATOM    719  N   ALA A  48      -3.437 -13.142  -5.123  0.00  0.00           N  
ATOM    720  CA  ALA A  48      -2.603 -14.022  -5.942  0.00  0.00           C  
ATOM    721  C   ALA A  48      -1.187 -13.466  -6.152  0.00  0.00           C  
ATOM    722  O   ALA A  48      -0.236 -14.245  -6.267  0.00  0.00           O  
ATOM    723  CB  ALA A  48      -3.286 -14.194  -7.297  0.00  0.00           C  
ATOM    724  H   ALA A  48      -3.684 -12.246  -5.536  0.00  0.00           H  
ATOM    725  HA  ALA A  48      -2.513 -15.003  -5.473  0.00  0.00           H  
ATOM    726  HB1 ALA A  48      -3.338 -13.223  -7.793  0.00  0.00           H  
ATOM    727  HB2 ALA A  48      -2.698 -14.875  -7.912  0.00  0.00           H  
ATOM    728  HB3 ALA A  48      -4.290 -14.594  -7.158  0.00  0.00           H  
ATOM    729  N   THR A  49      -1.029 -12.133  -6.145  0.00  0.00           N  
ATOM    730  CA  THR A  49       0.285 -11.463  -6.190  0.00  0.00           C  
ATOM    731  C   THR A  49       0.600 -10.703  -4.896  0.00  0.00           C  
ATOM    732  O   THR A  49       1.644 -10.059  -4.780  0.00  0.00           O  
ATOM    733  CB  THR A  49       0.427 -10.601  -7.454  0.00  0.00           C  
ATOM    734  OG1 THR A  49       1.750 -10.130  -7.629  0.00  0.00           O  
ATOM    735  CG2 THR A  49      -0.531  -9.413  -7.499  0.00  0.00           C  
ATOM    736  H   THR A  49      -1.868 -11.550  -6.131  0.00  0.00           H  
ATOM    737  HA  THR A  49       1.035 -12.243  -6.268  0.00  0.00           H  
ATOM    738  HB  THR A  49       0.201 -11.238  -8.305  0.00  0.00           H  
ATOM    739  HG1 THR A  49       1.999  -9.651  -6.818  0.00  0.00           H  
ATOM    740 HG21 THR A  49      -0.664  -8.983  -6.508  0.00  0.00           H  
ATOM    741 HG22 THR A  49      -0.167  -8.653  -8.188  0.00  0.00           H  
ATOM    742 HG23 THR A  49      -1.492  -9.764  -7.864  0.00  0.00           H  
ATOM    743  N   LYS A  50      -0.293 -10.801  -3.900  0.00  0.00           N  
ATOM    744  CA  LYS A  50      -0.100 -10.336  -2.513  0.00  0.00           C  
ATOM    745  C   LYS A  50       0.298  -8.853  -2.438  0.00  0.00           C  
ATOM    746  O   LYS A  50       1.167  -8.440  -1.665  0.00  0.00           O  
ATOM    747  CB  LYS A  50       0.864 -11.289  -1.774  0.00  0.00           C  
ATOM    748  CG  LYS A  50       0.621 -12.802  -1.959  0.00  0.00           C  
ATOM    749  CD  LYS A  50      -0.423 -13.430  -1.020  0.00  0.00           C  
ATOM    750  CE  LYS A  50      -1.794 -12.752  -0.996  0.00  0.00           C  
ATOM    751  NZ  LYS A  50      -2.827 -13.681  -0.470  0.00  0.00           N  
ATOM    752  H   LYS A  50      -1.177 -11.245  -4.124  0.00  0.00           H  
ATOM    753  HA  LYS A  50      -1.071 -10.388  -2.025  0.00  0.00           H  
ATOM    754  HB2 LYS A  50       1.874 -11.064  -2.111  0.00  0.00           H  
ATOM    755  HB3 LYS A  50       0.829 -11.075  -0.712  0.00  0.00           H  
ATOM    756  HG2 LYS A  50       0.361 -13.030  -2.994  0.00  0.00           H  
ATOM    757  HG3 LYS A  50       1.566 -13.310  -1.767  0.00  0.00           H  
ATOM    758  HD2 LYS A  50      -0.572 -14.459  -1.330  0.00  0.00           H  
ATOM    759  HD3 LYS A  50      -0.022 -13.453  -0.005  0.00  0.00           H  
ATOM    760  HE2 LYS A  50      -1.724 -11.857  -0.375  0.00  0.00           H  
ATOM    761  HE3 LYS A  50      -2.054 -12.430  -2.008  0.00  0.00           H  
ATOM    762  HZ1 LYS A  50      -2.555 -14.075   0.418  0.00  0.00           H  
ATOM    763  HZ2 LYS A  50      -3.726 -13.219  -0.331  0.00  0.00           H  
ATOM    764  HZ3 LYS A  50      -2.990 -14.437  -1.126  0.00  0.00           H  
ATOM    765  N   THR A  51      -0.342  -8.054  -3.290  0.00  0.00           N  
ATOM    766  CA  THR A  51      -0.009  -6.651  -3.564  0.00  0.00           C  
ATOM    767  C   THR A  51      -1.218  -5.780  -3.255  0.00  0.00           C  
ATOM    768  O   THR A  51      -2.269  -5.904  -3.887  0.00  0.00           O  
ATOM    769  CB  THR A  51       0.442  -6.482  -5.027  0.00  0.00           C  
ATOM    770  OG1 THR A  51       1.655  -7.173  -5.244  0.00  0.00           O  
ATOM    771  CG2 THR A  51       0.709  -5.027  -5.418  0.00  0.00           C  
ATOM    772  H   THR A  51      -1.086  -8.472  -3.832  0.00  0.00           H  
ATOM    773  HA  THR A  51       0.813  -6.331  -2.926  0.00  0.00           H  
ATOM    774  HB  THR A  51      -0.317  -6.889  -5.695  0.00  0.00           H  
ATOM    775  HG1 THR A  51       1.529  -8.105  -4.991  0.00  0.00           H  
ATOM    776 HG21 THR A  51       1.320  -4.533  -4.663  0.00  0.00           H  
ATOM    777 HG22 THR A  51       1.227  -4.989  -6.376  0.00  0.00           H  
ATOM    778 HG23 THR A  51      -0.235  -4.494  -5.520  0.00  0.00           H  
ATOM    779  N   PHE A  52      -1.085  -4.925  -2.246  0.00  0.00           N  
ATOM    780  CA  PHE A  52      -2.042  -3.869  -1.943  0.00  0.00           C  
ATOM    781  C   PHE A  52      -2.042  -2.790  -3.032  0.00  0.00           C  
ATOM    782  O   PHE A  52      -1.084  -2.620  -3.790  0.00  0.00           O  
ATOM    783  CB  PHE A  52      -1.741  -3.207  -0.589  0.00  0.00           C  
ATOM    784  CG  PHE A  52      -2.224  -3.923   0.649  0.00  0.00           C  
ATOM    785  CD1 PHE A  52      -1.749  -5.203   0.980  0.00  0.00           C  
ATOM    786  CD2 PHE A  52      -3.143  -3.279   1.495  0.00  0.00           C  
ATOM    787  CE1 PHE A  52      -2.231  -5.855   2.128  0.00  0.00           C  
ATOM    788  CE2 PHE A  52      -3.618  -3.922   2.644  0.00  0.00           C  
ATOM    789  CZ  PHE A  52      -3.175  -5.219   2.952  0.00  0.00           C  
ATOM    790  H   PHE A  52      -0.196  -4.884  -1.763  0.00  0.00           H  
ATOM    791  HA  PHE A  52      -3.028  -4.307  -1.899  0.00  0.00           H  
ATOM    792  HB2 PHE A  52      -0.678  -3.001  -0.491  0.00  0.00           H  
ATOM    793  HB3 PHE A  52      -2.256  -2.251  -0.592  0.00  0.00           H  
ATOM    794  HD1 PHE A  52      -1.043  -5.696   0.331  0.00  0.00           H  
ATOM    795  HD2 PHE A  52      -3.494  -2.286   1.258  0.00  0.00           H  
ATOM    796  HE1 PHE A  52      -1.890  -6.852   2.368  0.00  0.00           H  
ATOM    797  HE2 PHE A  52      -4.330  -3.414   3.277  0.00  0.00           H  
ATOM    798  HZ  PHE A  52      -3.565  -5.731   3.814  0.00  0.00           H  
ATOM    799  N   THR A  53      -3.098  -1.988  -3.056  0.00  0.00           N  
ATOM    800  CA  THR A  53      -3.201  -0.768  -3.861  0.00  0.00           C  
ATOM    801  C   THR A  53      -4.026   0.256  -3.069  0.00  0.00           C  
ATOM    802  O   THR A  53      -4.756  -0.094  -2.138  0.00  0.00           O  
ATOM    803  CB  THR A  53      -3.783  -1.098  -5.251  0.00  0.00           C  
ATOM    804  OG1 THR A  53      -2.816  -1.805  -6.004  0.00  0.00           O  
ATOM    805  CG2 THR A  53      -4.153   0.107  -6.114  0.00  0.00           C  
ATOM    806  H   THR A  53      -3.842  -2.156  -2.382  0.00  0.00           H  
ATOM    807  HA  THR A  53      -2.206  -0.349  -4.018  0.00  0.00           H  
ATOM    808  HB  THR A  53      -4.655  -1.736  -5.136  0.00  0.00           H  
ATOM    809  HG1 THR A  53      -2.331  -2.385  -5.390  0.00  0.00           H  
ATOM    810 HG21 THR A  53      -5.014   0.619  -5.686  0.00  0.00           H  
ATOM    811 HG22 THR A  53      -3.309   0.794  -6.187  0.00  0.00           H  
ATOM    812 HG23 THR A  53      -4.427  -0.231  -7.114  0.00  0.00           H  
ATOM    813  N   VAL A  54      -3.860   1.535  -3.391  0.00  0.00           N  
ATOM    814  CA  VAL A  54      -4.571   2.670  -2.811  0.00  0.00           C  
ATOM    815  C   VAL A  54      -4.742   3.760  -3.870  0.00  0.00           C  
ATOM    816  O   VAL A  54      -4.050   4.771  -3.895  0.00  0.00           O  
ATOM    817  CB  VAL A  54      -3.950   3.094  -1.457  0.00  0.00           C  
ATOM    818  CG1 VAL A  54      -2.550   3.716  -1.457  0.00  0.00           C  
ATOM    819  CG2 VAL A  54      -4.896   4.058  -0.753  0.00  0.00           C  
ATOM    820  H   VAL A  54      -3.126   1.745  -4.057  0.00  0.00           H  
ATOM    821  HA  VAL A  54      -5.587   2.345  -2.606  0.00  0.00           H  
ATOM    822  HB  VAL A  54      -3.892   2.201  -0.835  0.00  0.00           H  
ATOM    823 HG11 VAL A  54      -2.197   3.805  -0.430  0.00  0.00           H  
ATOM    824 HG12 VAL A  54      -1.863   3.087  -2.012  0.00  0.00           H  
ATOM    825 HG13 VAL A  54      -2.575   4.714  -1.884  0.00  0.00           H  
ATOM    826 HG21 VAL A  54      -5.052   4.911  -1.398  0.00  0.00           H  
ATOM    827 HG22 VAL A  54      -5.844   3.560  -0.553  0.00  0.00           H  
ATOM    828 HG23 VAL A  54      -4.464   4.388   0.189  0.00  0.00           H  
ATOM    829  N   THR A  55      -5.636   3.509  -4.826  0.00  0.00           N  
ATOM    830  CA  THR A  55      -5.947   4.444  -5.920  0.00  0.00           C  
ATOM    831  C   THR A  55      -6.640   5.690  -5.369  0.00  0.00           C  
ATOM    832  O   THR A  55      -7.767   5.631  -4.876  0.00  0.00           O  
ATOM    833  CB  THR A  55      -6.808   3.781  -6.996  0.00  0.00           C  
ATOM    834  OG1 THR A  55      -6.332   2.486  -7.297  0.00  0.00           O  
ATOM    835  CG2 THR A  55      -6.795   4.551  -8.316  0.00  0.00           C  
ATOM    836  H   THR A  55      -6.135   2.630  -4.804  0.00  0.00           H  
ATOM    837  HA  THR A  55      -5.013   4.756  -6.372  0.00  0.00           H  
ATOM    838  HB  THR A  55      -7.818   3.711  -6.602  0.00  0.00           H  
ATOM    839  HG1 THR A  55      -7.112   1.962  -7.557  0.00  0.00           H  
ATOM    840 HG21 THR A  55      -7.033   5.602  -8.150  0.00  0.00           H  
ATOM    841 HG22 THR A  55      -5.812   4.467  -8.785  0.00  0.00           H  
ATOM    842 HG23 THR A  55      -7.538   4.123  -8.989  0.00  0.00           H  
ATOM    843  N   GLU A  56      -5.927   6.809  -5.410  0.00  0.00           N  
ATOM    844  CA  GLU A  56      -6.223   8.092  -4.770  0.00  0.00           C  
ATOM    845  C   GLU A  56      -7.577   8.731  -5.145  0.00  0.00           C  
ATOM    846  O   GLU A  56      -8.038   8.672  -6.288  0.00  0.00           O  
ATOM    847  CB  GLU A  56      -5.067   9.031  -5.134  0.00  0.00           C  
ATOM    848  CG  GLU A  56      -4.882  10.254  -4.228  0.00  0.00           C  
ATOM    849  CD  GLU A  56      -5.385  11.530  -4.917  0.00  0.00           C  
ATOM    850  OE1 GLU A  56      -4.768  11.962  -5.919  0.00  0.00           O  
ATOM    851  OE2 GLU A  56      -6.393  12.088  -4.427  0.00  0.00           O  
ATOM    852  H   GLU A  56      -5.048   6.761  -5.915  0.00  0.00           H  
ATOM    853  HA  GLU A  56      -6.200   7.932  -3.694  0.00  0.00           H  
ATOM    854  HB2 GLU A  56      -4.135   8.466  -5.102  0.00  0.00           H  
ATOM    855  HB3 GLU A  56      -5.228   9.359  -6.158  0.00  0.00           H  
ATOM    856  HG2 GLU A  56      -5.384  10.089  -3.268  0.00  0.00           H  
ATOM    857  HG3 GLU A  56      -3.817  10.370  -4.012  0.00  0.00           H  
ATOM    858  N   GLY A  57      -8.163   9.418  -4.163  0.00  0.00           N  
ATOM    859  CA  GLY A  57      -9.335  10.296  -4.291  0.00  0.00           C  
ATOM    860  C   GLY A  57      -9.513  11.149  -3.026  0.00  0.00           C  
ATOM    861  O   GLY A  57     -10.636  11.346  -2.557  0.00  0.00           O  
ATOM    862  H   GLY A  57      -7.744   9.370  -3.247  0.00  0.00           H  
ATOM    863  HA2 GLY A  57      -9.194  10.964  -5.140  0.00  0.00           H  
ATOM    864  HA3 GLY A  57     -10.231   9.695  -4.452  0.00  0.00           H  
ATOM    865  N   SER A  58      -8.387  11.603  -2.459  0.00  0.00           N  
ATOM    866  CA  SER A  58      -8.279  12.229  -1.126  0.00  0.00           C  
ATOM    867  C   SER A  58      -7.212  13.331  -1.016  0.00  0.00           C  
ATOM    868  O   SER A  58      -7.251  14.126  -0.075  0.00  0.00           O  
ATOM    869  CB  SER A  58      -7.950  11.147  -0.083  0.00  0.00           C  
ATOM    870  OG  SER A  58      -8.950  10.140  -0.066  0.00  0.00           O  
ATOM    871  H   SER A  58      -7.545  11.520  -3.023  0.00  0.00           H  
ATOM    872  HA  SER A  58      -9.235  12.679  -0.860  0.00  0.00           H  
ATOM    873  HB2 SER A  58      -6.986  10.697  -0.326  0.00  0.00           H  
ATOM    874  HB3 SER A  58      -7.882  11.603   0.906  0.00  0.00           H  
ATOM    875  HG  SER A  58      -8.595   9.361   0.411  0.00  0.00           H  
ATOM    876  N   HIS A  59      -6.294  13.448  -1.981  0.00  0.00           N  
ATOM    877  CA  HIS A  59      -5.299  14.529  -2.065  0.00  0.00           C  
ATOM    878  C   HIS A  59      -5.865  15.787  -2.778  0.00  0.00           C  
ATOM    879  O   HIS A  59      -5.138  16.746  -3.044  0.00  0.00           O  
ATOM    880  CB  HIS A  59      -4.023  13.968  -2.721  0.00  0.00           C  
ATOM    881  CG  HIS A  59      -2.751  14.681  -2.323  0.00  0.00           C  
ATOM    882  ND1 HIS A  59      -1.906  15.382  -3.153  0.00  0.00           N  
ATOM    883  CD2 HIS A  59      -2.183  14.695  -1.077  0.00  0.00           C  
ATOM    884  CE1 HIS A  59      -0.859  15.811  -2.430  0.00  0.00           C  
ATOM    885  NE2 HIS A  59      -0.984  15.418  -1.149  0.00  0.00           N  
ATOM    886  H   HIS A  59      -6.342  12.819  -2.778  0.00  0.00           H  
ATOM    887  HA  HIS A  59      -5.042  14.829  -1.049  0.00  0.00           H  
ATOM    888  HB2 HIS A  59      -3.900  12.924  -2.425  0.00  0.00           H  
ATOM    889  HB3 HIS A  59      -4.137  13.990  -3.803  0.00  0.00           H  
ATOM    890  HD1 HIS A  59      -2.045  15.559  -4.146  0.00  0.00           H  
ATOM    891  HD2 HIS A  59      -2.589  14.216  -0.195  0.00  0.00           H  
ATOM    892  HE1 HIS A  59      -0.031  16.392  -2.825  0.00  0.00           H  
ATOM    893  N   HIS A  60      -7.181  15.798  -3.045  0.00  0.00           N  
ATOM    894  CA  HIS A  60      -7.986  16.935  -3.518  0.00  0.00           C  
ATOM    895  C   HIS A  60      -7.518  17.560  -4.852  0.00  0.00           C  
ATOM    896  O   HIS A  60      -7.617  18.774  -5.060  0.00  0.00           O  
ATOM    897  CB  HIS A  60      -8.202  17.936  -2.364  0.00  0.00           C  
ATOM    898  CG  HIS A  60      -9.157  17.443  -1.299  0.00  0.00           C  
ATOM    899  ND1 HIS A  60      -8.934  16.449  -0.369  0.00  0.00           N  
ATOM    900  CD2 HIS A  60     -10.427  17.910  -1.084  0.00  0.00           C  
ATOM    901  CE1 HIS A  60     -10.041  16.316   0.380  0.00  0.00           C  
ATOM    902  NE2 HIS A  60     -10.984  17.191  -0.017  0.00  0.00           N  
ATOM    903  H   HIS A  60      -7.690  14.951  -2.833  0.00  0.00           H  
ATOM    904  HA  HIS A  60      -8.973  16.532  -3.752  0.00  0.00           H  
ATOM    905  HB2 HIS A  60      -7.246  18.189  -1.904  0.00  0.00           H  
ATOM    906  HB3 HIS A  60      -8.623  18.860  -2.763  0.00  0.00           H  
ATOM    907  HD1 HIS A  60      -8.096  15.879  -0.266  0.00  0.00           H  
ATOM    908  HD2 HIS A  60     -10.914  18.696  -1.648  0.00  0.00           H  
ATOM    909  HE1 HIS A  60     -10.158  15.600   1.189  0.00  0.00           H  
ATOM    910  N   HIS A  61      -7.045  16.725  -5.786  0.00  0.00           N  
ATOM    911  CA  HIS A  61      -6.722  17.125  -7.162  0.00  0.00           C  
ATOM    912  C   HIS A  61      -7.046  16.024  -8.193  0.00  0.00           C  
ATOM    913  O   HIS A  61      -6.678  14.860  -8.020  0.00  0.00           O  
ATOM    914  CB  HIS A  61      -5.250  17.580  -7.246  0.00  0.00           C  
ATOM    915  CG  HIS A  61      -4.196  16.610  -6.751  0.00  0.00           C  
ATOM    916  ND1 HIS A  61      -4.306  15.244  -6.616  0.00  0.00           N  
ATOM    917  CD2 HIS A  61      -2.915  16.937  -6.399  0.00  0.00           C  
ATOM    918  CE1 HIS A  61      -3.129  14.757  -6.207  0.00  0.00           C  
ATOM    919  NE2 HIS A  61      -2.242  15.755  -6.060  0.00  0.00           N  
ATOM    920  H   HIS A  61      -6.966  15.746  -5.551  0.00  0.00           H  
ATOM    921  HA  HIS A  61      -7.337  17.986  -7.424  0.00  0.00           H  
ATOM    922  HB2 HIS A  61      -5.023  17.830  -8.283  0.00  0.00           H  
ATOM    923  HB3 HIS A  61      -5.151  18.499  -6.666  0.00  0.00           H  
ATOM    924  HD1 HIS A  61      -5.119  14.682  -6.865  0.00  0.00           H  
ATOM    925  HD2 HIS A  61      -2.493  17.933  -6.410  0.00  0.00           H  
ATOM    926  HE1 HIS A  61      -2.924  13.707  -6.034  0.00  0.00           H  
ATOM    927  N   HIS A  62      -7.729  16.402  -9.278  0.00  0.00           N  
ATOM    928  CA  HIS A  62      -7.972  15.573 -10.465  0.00  0.00           C  
ATOM    929  C   HIS A  62      -8.450  16.434 -11.652  0.00  0.00           C  
ATOM    930  O   HIS A  62      -9.176  17.415 -11.468  0.00  0.00           O  
ATOM    931  CB  HIS A  62      -9.040  14.503 -10.157  0.00  0.00           C  
ATOM    932  CG  HIS A  62      -9.310  13.586 -11.326  0.00  0.00           C  
ATOM    933  ND1 HIS A  62      -8.558  12.490 -11.692  0.00  0.00           N  
ATOM    934  CD2 HIS A  62     -10.295  13.731 -12.268  0.00  0.00           C  
ATOM    935  CE1 HIS A  62      -9.073  11.989 -12.827  0.00  0.00           C  
ATOM    936  NE2 HIS A  62     -10.131  12.721 -13.224  0.00  0.00           N  
ATOM    937  H   HIS A  62      -8.039  17.364  -9.331  0.00  0.00           H  
ATOM    938  HA  HIS A  62      -7.045  15.072 -10.744  0.00  0.00           H  
ATOM    939  HB2 HIS A  62      -8.717  13.890  -9.315  0.00  0.00           H  
ATOM    940  HB3 HIS A  62      -9.972  14.994  -9.870  0.00  0.00           H  
ATOM    941  HD1 HIS A  62      -7.779  12.095 -11.176  0.00  0.00           H  
ATOM    942  HD2 HIS A  62     -11.042  14.514 -12.285  0.00  0.00           H  
ATOM    943  HE1 HIS A  62      -8.692  11.116 -13.347  0.00  0.00           H  
ATOM    944  N   HIS A  63      -8.073  16.040 -12.872  0.00  0.00           N  
ATOM    945  CA  HIS A  63      -8.601  16.565 -14.137  0.00  0.00           C  
ATOM    946  C   HIS A  63      -8.351  15.555 -15.271  0.00  0.00           C  
ATOM    947  O   HIS A  63      -7.411  14.753 -15.199  0.00  0.00           O  
ATOM    948  CB  HIS A  63      -7.995  17.941 -14.483  0.00  0.00           C  
ATOM    949  CG  HIS A  63      -6.598  17.894 -15.054  0.00  0.00           C  
ATOM    950  ND1 HIS A  63      -6.270  17.782 -16.389  0.00  0.00           N  
ATOM    951  CD2 HIS A  63      -5.424  17.936 -14.353  0.00  0.00           C  
ATOM    952  CE1 HIS A  63      -4.932  17.738 -16.491  0.00  0.00           C  
ATOM    953  NE2 HIS A  63      -4.371  17.808 -15.270  0.00  0.00           N  
ATOM    954  H   HIS A  63      -7.513  15.203 -12.941  0.00  0.00           H  
ATOM    955  HA  HIS A  63      -9.681  16.691 -14.029  0.00  0.00           H  
ATOM    956  HB2 HIS A  63      -8.639  18.423 -15.220  0.00  0.00           H  
ATOM    957  HB3 HIS A  63      -7.994  18.580 -13.597  0.00  0.00           H  
ATOM    958  HD1 HIS A  63      -6.918  17.766 -17.169  0.00  0.00           H  
ATOM    959  HD2 HIS A  63      -5.333  18.032 -13.279  0.00  0.00           H  
ATOM    960  HE1 HIS A  63      -4.384  17.653 -17.424  0.00  0.00           H  
ATOM    961  N   HIS A  64      -9.153  15.635 -16.335  0.00  0.00           N  
ATOM    962  CA  HIS A  64      -8.967  14.919 -17.603  0.00  0.00           C  
ATOM    963  C   HIS A  64      -9.687  15.662 -18.752  0.00  0.00           C  
ATOM    964  O   HIS A  64     -10.162  16.786 -18.567  0.00  0.00           O  
ATOM    965  CB  HIS A  64      -9.406  13.446 -17.454  0.00  0.00           C  
ATOM    966  CG  HIS A  64     -10.867  13.224 -17.161  0.00  0.00           C  
ATOM    967  ND1 HIS A  64     -11.423  13.003 -15.919  0.00  0.00           N  
ATOM    968  CD2 HIS A  64     -11.876  13.099 -18.081  0.00  0.00           C  
ATOM    969  CE1 HIS A  64     -12.730  12.751 -16.079  0.00  0.00           C  
ATOM    970  NE2 HIS A  64     -13.061  12.827 -17.382  0.00  0.00           N  
ATOM    971  H   HIS A  64      -9.877  16.340 -16.328  0.00  0.00           H  
ATOM    972  HA  HIS A  64      -7.905  14.918 -17.849  0.00  0.00           H  
ATOM    973  HB2 HIS A  64      -9.150  12.903 -18.362  0.00  0.00           H  
ATOM    974  HB3 HIS A  64      -8.825  12.988 -16.651  0.00  0.00           H  
ATOM    975  HD1 HIS A  64     -10.920  12.954 -15.032  0.00  0.00           H  
ATOM    976  HD2 HIS A  64     -11.772  13.177 -19.154  0.00  0.00           H  
ATOM    977  HE1 HIS A  64     -13.421  12.524 -15.274  0.00  0.00           H  
ATOM    978  N   MET A  65      -9.738  15.061 -19.947  0.00  0.00           N  
ATOM    979  CA  MET A  65     -10.285  15.606 -21.203  0.00  0.00           C  
ATOM    980  C   MET A  65     -11.823  15.819 -21.238  0.00  0.00           C  
ATOM    981  O   MET A  65     -12.523  15.296 -22.108  0.00  0.00           O  
ATOM    982  CB  MET A  65      -9.752  14.777 -22.396  0.00  0.00           C  
ATOM    983  CG  MET A  65     -10.126  13.284 -22.412  0.00  0.00           C  
ATOM    984  SD  MET A  65      -9.231  12.218 -21.246  0.00  0.00           S  
ATOM    985  CE  MET A  65     -10.070  10.645 -21.578  0.00  0.00           C  
ATOM    986  H   MET A  65      -9.316  14.142 -20.012  0.00  0.00           H  
ATOM    987  HA  MET A  65      -9.858  16.604 -21.318  0.00  0.00           H  
ATOM    988  HB2 MET A  65     -10.119  15.231 -23.317  0.00  0.00           H  
ATOM    989  HB3 MET A  65      -8.664  14.855 -22.417  0.00  0.00           H  
ATOM    990  HG2 MET A  65     -11.196  13.176 -22.231  0.00  0.00           H  
ATOM    991  HG3 MET A  65      -9.929  12.907 -23.415  0.00  0.00           H  
ATOM    992  HE1 MET A  65      -9.937  10.370 -22.625  0.00  0.00           H  
ATOM    993  HE2 MET A  65      -9.649   9.865 -20.945  0.00  0.00           H  
ATOM    994  HE3 MET A  65     -11.135  10.744 -21.363  0.00  0.00           H  
ATOM    995  N   HIS A  66     -12.359  16.616 -20.308  0.00  0.00           N  
ATOM    996  CA  HIS A  66     -13.763  17.048 -20.246  0.00  0.00           C  
ATOM    997  C   HIS A  66     -13.873  18.574 -20.075  0.00  0.00           C  
ATOM    998  O   HIS A  66     -12.957  19.205 -19.530  0.00  0.00           O  
ATOM    999  CB  HIS A  66     -14.474  16.323 -19.084  0.00  0.00           C  
ATOM   1000  CG  HIS A  66     -13.948  16.660 -17.702  0.00  0.00           C  
ATOM   1001  ND1 HIS A  66     -13.191  15.836 -16.901  0.00  0.00           N  
ATOM   1002  CD2 HIS A  66     -14.149  17.817 -16.995  0.00  0.00           C  
ATOM   1003  CE1 HIS A  66     -12.925  16.481 -15.754  0.00  0.00           C  
ATOM   1004  NE2 HIS A  66     -13.482  17.705 -15.767  0.00  0.00           N  
ATOM   1005  H   HIS A  66     -11.728  17.001 -19.613  0.00  0.00           H  
ATOM   1006  HA  HIS A  66     -14.269  16.781 -21.174  0.00  0.00           H  
ATOM   1007  HB2 HIS A  66     -15.537  16.572 -19.114  0.00  0.00           H  
ATOM   1008  HB3 HIS A  66     -14.391  15.247 -19.240  0.00  0.00           H  
ATOM   1009  HD1 HIS A  66     -12.947  14.869 -17.103  0.00  0.00           H  
ATOM   1010  HD2 HIS A  66     -14.719  18.673 -17.332  0.00  0.00           H  
ATOM   1011  HE1 HIS A  66     -12.362  16.065 -14.925  0.00  0.00           H  
ATOM   1012  N   ARG A  67     -15.008  19.173 -20.488  0.00  0.00           N  
ATOM   1013  CA  ARG A  67     -15.360  20.580 -20.186  0.00  0.00           C  
ATOM   1014  C   ARG A  67     -16.847  20.892 -20.355  0.00  0.00           C  
ATOM   1015  O   ARG A  67     -17.549  21.027 -19.360  0.00  0.00           O  
ATOM   1016  CB  ARG A  67     -14.467  21.544 -21.014  0.00  0.00           C  
ATOM   1017  CG  ARG A  67     -14.336  22.962 -20.421  0.00  0.00           C  
ATOM   1018  CD  ARG A  67     -13.940  23.035 -18.931  0.00  0.00           C  
ATOM   1019  NE  ARG A  67     -13.002  21.965 -18.531  0.00  0.00           N  
ATOM   1020  CZ  ARG A  67     -12.680  21.607 -17.303  0.00  0.00           C  
ATOM   1021  NH1 ARG A  67     -12.955  22.342 -16.262  0.00  0.00           N  
ATOM   1022  NH2 ARG A  67     -12.094  20.464 -17.112  0.00  0.00           N  
ATOM   1023  H   ARG A  67     -15.699  18.591 -20.943  0.00  0.00           H  
ATOM   1024  HA  ARG A  67     -15.153  20.728 -19.125  0.00  0.00           H  
ATOM   1025  HB2 ARG A  67     -13.457  21.137 -21.097  0.00  0.00           H  
ATOM   1026  HB3 ARG A  67     -14.834  21.620 -22.037  0.00  0.00           H  
ATOM   1027  HG2 ARG A  67     -13.580  23.493 -20.999  0.00  0.00           H  
ATOM   1028  HG3 ARG A  67     -15.281  23.487 -20.550  0.00  0.00           H  
ATOM   1029  HD2 ARG A  67     -13.498  24.013 -18.734  0.00  0.00           H  
ATOM   1030  HD3 ARG A  67     -14.850  22.947 -18.334  0.00  0.00           H  
ATOM   1031  HE  ARG A  67     -12.729  21.303 -19.247  0.00  0.00           H  
ATOM   1032 HH11 ARG A  67     -13.400  23.235 -16.395  0.00  0.00           H  
ATOM   1033 HH12 ARG A  67     -12.702  22.035 -15.339  0.00  0.00           H  
ATOM   1034 HH21 ARG A  67     -12.024  19.831 -17.900  0.00  0.00           H  
ATOM   1035 HH22 ARG A  67     -11.937  20.117 -16.182  0.00  0.00           H  
ATOM   1036  N   ASP A  68     -17.351  20.933 -21.585  0.00  0.00           N  
ATOM   1037  CA  ASP A  68     -18.744  21.285 -21.926  0.00  0.00           C  
ATOM   1038  C   ASP A  68     -19.720  20.084 -21.780  0.00  0.00           C  
ATOM   1039  O   ASP A  68     -20.605  19.847 -22.613  0.00  0.00           O  
ATOM   1040  CB  ASP A  68     -18.781  21.904 -23.334  0.00  0.00           C  
ATOM   1041  CG  ASP A  68     -17.907  23.165 -23.436  0.00  0.00           C  
ATOM   1042  OD1 ASP A  68     -18.412  24.267 -23.112  0.00  0.00           O  
ATOM   1043  OD2 ASP A  68     -16.725  23.063 -23.840  0.00  0.00           O  
ATOM   1044  H   ASP A  68     -16.706  20.808 -22.353  0.00  0.00           H  
ATOM   1045  HA  ASP A  68     -19.094  22.037 -21.221  0.00  0.00           H  
ATOM   1046  HB2 ASP A  68     -18.450  21.165 -24.062  0.00  0.00           H  
ATOM   1047  HB3 ASP A  68     -19.813  22.176 -23.577  0.00  0.00           H  
ATOM   1048  N   SER A  69     -19.511  19.270 -20.738  0.00  0.00           N  
ATOM   1049  CA  SER A  69     -20.257  18.044 -20.407  0.00  0.00           C  
ATOM   1050  C   SER A  69     -20.240  17.802 -18.883  0.00  0.00           C  
ATOM   1051  O   SER A  69     -20.076  16.673 -18.416  0.00  0.00           O  
ATOM   1052  CB  SER A  69     -19.675  16.878 -21.219  0.00  0.00           C  
ATOM   1053  OG  SER A  69     -20.497  15.718 -21.114  0.00  0.00           O  
ATOM   1054  H   SER A  69     -18.809  19.582 -20.075  0.00  0.00           H  
ATOM   1055  HA  SER A  69     -21.299  18.190 -20.698  0.00  0.00           H  
ATOM   1056  HB2 SER A  69     -19.609  17.176 -22.262  0.00  0.00           H  
ATOM   1057  HB3 SER A  69     -18.677  16.649 -20.856  0.00  0.00           H  
ATOM   1058  HG  SER A  69     -20.445  15.386 -20.190  0.00  0.00           H  
ATOM   1059  N   CYS A  70     -20.354  18.879 -18.095  0.00  0.00           N  
ATOM   1060  CA  CYS A  70     -20.226  18.899 -16.633  0.00  0.00           C  
ATOM   1061  C   CYS A  70     -21.575  19.192 -15.941  0.00  0.00           C  
ATOM   1062  O   CYS A  70     -22.540  19.560 -16.615  0.00  0.00           O  
ATOM   1063  CB  CYS A  70     -19.168  19.960 -16.274  0.00  0.00           C  
ATOM   1064  SG  CYS A  70     -17.503  19.321 -16.618  0.00  0.00           S  
ATOM   1065  H   CYS A  70     -20.575  19.764 -18.549  0.00  0.00           H  
ATOM   1066  HA  CYS A  70     -19.878  17.929 -16.277  0.00  0.00           H  
ATOM   1067  HB2 CYS A  70     -19.340  20.872 -16.851  0.00  0.00           H  
ATOM   1068  HB3 CYS A  70     -19.226  20.218 -15.216  0.00  0.00           H  
ATOM   1069  HG  CYS A  70     -17.535  19.549 -17.939  0.00  0.00           H  
ATOM   1070  N   PRO A  71     -21.670  19.083 -14.598  0.00  0.00           N  
ATOM   1071  CA  PRO A  71     -22.842  19.487 -13.804  0.00  0.00           C  
ATOM   1072  C   PRO A  71     -23.438  20.884 -14.070  0.00  0.00           C  
ATOM   1073  O   PRO A  71     -24.554  21.152 -13.630  0.00  0.00           O  
ATOM   1074  CB  PRO A  71     -22.417  19.328 -12.341  0.00  0.00           C  
ATOM   1075  CG  PRO A  71     -21.431  18.168 -12.406  0.00  0.00           C  
ATOM   1076  CD  PRO A  71     -20.703  18.422 -13.725  0.00  0.00           C  
ATOM   1077  HA  PRO A  71     -23.630  18.762 -13.994  0.00  0.00           H  
ATOM   1078  HB2 PRO A  71     -21.901  20.228 -11.999  0.00  0.00           H  
ATOM   1079  HB3 PRO A  71     -23.263  19.097 -11.694  0.00  0.00           H  
ATOM   1080  HG2 PRO A  71     -20.746  18.165 -11.559  0.00  0.00           H  
ATOM   1081  HG3 PRO A  71     -21.977  17.224 -12.464  0.00  0.00           H  
ATOM   1082  HD2 PRO A  71     -19.855  19.081 -13.541  0.00  0.00           H  
ATOM   1083  HD3 PRO A  71     -20.362  17.476 -14.147  0.00  0.00           H  
ATOM   1084  N   LEU A  72     -22.740  21.784 -14.773  0.00  0.00           N  
ATOM   1085  CA  LEU A  72     -23.287  23.072 -15.226  0.00  0.00           C  
ATOM   1086  C   LEU A  72     -24.216  22.944 -16.452  0.00  0.00           C  
ATOM   1087  O   LEU A  72     -25.112  23.768 -16.631  0.00  0.00           O  
ATOM   1088  CB  LEU A  72     -22.125  24.028 -15.563  0.00  0.00           C  
ATOM   1089  CG  LEU A  72     -21.142  24.316 -14.410  0.00  0.00           C  
ATOM   1090  CD1 LEU A  72     -20.062  25.287 -14.888  0.00  0.00           C  
ATOM   1091  CD2 LEU A  72     -21.826  24.927 -13.185  0.00  0.00           C  
ATOM   1092  H   LEU A  72     -21.819  21.526 -15.090  0.00  0.00           H  
ATOM   1093  HA  LEU A  72     -23.882  23.511 -14.425  0.00  0.00           H  
ATOM   1094  HB2 LEU A  72     -21.564  23.609 -16.399  0.00  0.00           H  
ATOM   1095  HB3 LEU A  72     -22.552  24.977 -15.893  0.00  0.00           H  
ATOM   1096  HG  LEU A  72     -20.654  23.389 -14.110  0.00  0.00           H  
ATOM   1097 HD11 LEU A  72     -19.338  25.455 -14.092  0.00  0.00           H  
ATOM   1098 HD12 LEU A  72     -19.542  24.864 -15.749  0.00  0.00           H  
ATOM   1099 HD13 LEU A  72     -20.513  26.239 -15.174  0.00  0.00           H  
ATOM   1100 HD21 LEU A  72     -21.079  25.171 -12.429  0.00  0.00           H  
ATOM   1101 HD22 LEU A  72     -22.362  25.833 -13.467  0.00  0.00           H  
ATOM   1102 HD23 LEU A  72     -22.525  24.212 -12.752  0.00  0.00           H  
ATOM   1103  N   ASP A  73     -24.028  21.931 -17.299  0.00  0.00           N  
ATOM   1104  CA  ASP A  73     -24.683  21.787 -18.613  0.00  0.00           C  
ATOM   1105  C   ASP A  73     -26.086  21.148 -18.560  0.00  0.00           C  
ATOM   1106  O   ASP A  73     -26.772  21.056 -19.580  0.00  0.00           O  
ATOM   1107  CB  ASP A  73     -23.769  20.954 -19.526  0.00  0.00           C  
ATOM   1108  CG  ASP A  73     -22.466  21.697 -19.818  0.00  0.00           C  
ATOM   1109  OD1 ASP A  73     -22.522  22.703 -20.562  0.00  0.00           O  
ATOM   1110  OD2 ASP A  73     -21.397  21.299 -19.304  0.00  0.00           O  
ATOM   1111  H   ASP A  73     -23.323  21.241 -17.063  0.00  0.00           H  
ATOM   1112  HA  ASP A  73     -24.801  22.776 -19.058  0.00  0.00           H  
ATOM   1113  HB2 ASP A  73     -23.567  19.987 -19.065  0.00  0.00           H  
ATOM   1114  HB3 ASP A  73     -24.277  20.771 -20.474  0.00  0.00           H  
ATOM   1115  N   CYS A  74     -26.526  20.710 -17.381  0.00  0.00           N  
ATOM   1116  CA  CYS A  74     -27.712  19.883 -17.136  0.00  0.00           C  
ATOM   1117  C   CYS A  74     -29.094  20.497 -17.443  0.00  0.00           C  
ATOM   1118  O   CYS A  74     -30.099  19.892 -17.065  0.00  0.00           O  
ATOM   1119  CB  CYS A  74     -27.666  19.443 -15.668  0.00  0.00           C  
ATOM   1120  SG  CYS A  74     -26.069  18.704 -15.251  0.00  0.00           S  
ATOM   1121  H   CYS A  74     -25.888  20.812 -16.602  0.00  0.00           H  
ATOM   1122  HA  CYS A  74     -27.627  18.992 -17.760  0.00  0.00           H  
ATOM   1123  HB2 CYS A  74     -27.846  20.303 -15.021  0.00  0.00           H  
ATOM   1124  HB3 CYS A  74     -28.448  18.703 -15.493  0.00  0.00           H  
ATOM   1125  HG  CYS A  74     -26.333  18.438 -13.962  0.00  0.00           H  
ATOM   1126  N   LYS A  75     -29.191  21.683 -18.064  0.00  0.00           N  
ATOM   1127  CA  LYS A  75     -30.482  22.287 -18.443  0.00  0.00           C  
ATOM   1128  C   LYS A  75     -31.083  21.614 -19.684  0.00  0.00           C  
ATOM   1129  O   LYS A  75     -30.390  21.291 -20.651  0.00  0.00           O  
ATOM   1130  CB  LYS A  75     -30.376  23.809 -18.654  0.00  0.00           C  
ATOM   1131  CG  LYS A  75     -30.381  24.627 -17.353  0.00  0.00           C  
ATOM   1132  CD  LYS A  75     -29.038  24.747 -16.626  0.00  0.00           C  
ATOM   1133  CE  LYS A  75     -28.067  25.644 -17.396  0.00  0.00           C  
ATOM   1134  NZ  LYS A  75     -26.865  25.936 -16.584  0.00  0.00           N  
ATOM   1135  H   LYS A  75     -28.339  22.080 -18.436  0.00  0.00           H  
ATOM   1136  HA  LYS A  75     -31.191  22.121 -17.635  0.00  0.00           H  
ATOM   1137  HB2 LYS A  75     -29.515  24.056 -19.278  0.00  0.00           H  
ATOM   1138  HB3 LYS A  75     -31.274  24.122 -19.185  0.00  0.00           H  
ATOM   1139  HG2 LYS A  75     -30.725  25.635 -17.588  0.00  0.00           H  
ATOM   1140  HG3 LYS A  75     -31.113  24.194 -16.671  0.00  0.00           H  
ATOM   1141  HD2 LYS A  75     -29.229  25.205 -15.655  0.00  0.00           H  
ATOM   1142  HD3 LYS A  75     -28.595  23.764 -16.464  0.00  0.00           H  
ATOM   1143  HE2 LYS A  75     -27.779  25.155 -18.331  0.00  0.00           H  
ATOM   1144  HE3 LYS A  75     -28.576  26.579 -17.645  0.00  0.00           H  
ATOM   1145  HZ1 LYS A  75     -26.308  25.101 -16.436  0.00  0.00           H  
ATOM   1146  HZ2 LYS A  75     -26.262  26.596 -17.079  0.00  0.00           H  
ATOM   1147  HZ3 LYS A  75     -27.100  26.345 -15.692  0.00  0.00           H  
ATOM   1148  N   VAL A  76     -32.404  21.462 -19.672  0.00  0.00           N  
ATOM   1149  CA  VAL A  76     -33.206  20.677 -20.620  0.00  0.00           C  
ATOM   1150  C   VAL A  76     -34.486  21.447 -20.977  0.00  0.00           C  
ATOM   1151  O   VAL A  76     -34.957  22.318 -20.241  0.00  0.00           O  
ATOM   1152  CB  VAL A  76     -33.540  19.284 -20.022  0.00  0.00           C  
ATOM   1153  CG1 VAL A  76     -34.149  18.275 -21.004  0.00  0.00           C  
ATOM   1154  CG2 VAL A  76     -32.335  18.588 -19.386  0.00  0.00           C  
ATOM   1155  H   VAL A  76     -32.894  21.818 -18.857  0.00  0.00           H  
ATOM   1156  HA  VAL A  76     -32.640  20.520 -21.534  0.00  0.00           H  
ATOM   1157  HB  VAL A  76     -34.250  19.436 -19.227  0.00  0.00           H  
ATOM   1158 HG11 VAL A  76     -33.452  18.087 -21.819  0.00  0.00           H  
ATOM   1159 HG12 VAL A  76     -34.356  17.334 -20.494  0.00  0.00           H  
ATOM   1160 HG13 VAL A  76     -35.095  18.634 -21.399  0.00  0.00           H  
ATOM   1161 HG21 VAL A  76     -32.053  19.121 -18.481  0.00  0.00           H  
ATOM   1162 HG22 VAL A  76     -32.605  17.574 -19.094  0.00  0.00           H  
ATOM   1163 HG23 VAL A  76     -31.502  18.559 -20.088  0.00  0.00           H  
ATOM   1164  N   TYR A  77     -35.057  21.092 -22.117  0.00  0.00           N  
ATOM   1165  CA  TYR A  77     -36.283  21.609 -22.707  0.00  0.00           C  
ATOM   1166  C   TYR A  77     -37.277  20.471 -22.944  0.00  0.00           C  
ATOM   1167  O   TYR A  77     -36.875  19.375 -23.344  0.00  0.00           O  
ATOM   1168  CB  TYR A  77     -35.931  22.223 -24.072  0.00  0.00           C  
ATOM   1169  CG  TYR A  77     -37.103  22.788 -24.861  0.00  0.00           C  
ATOM   1170  CD1 TYR A  77     -38.208  23.356 -24.203  0.00  0.00           C  
ATOM   1171  CD2 TYR A  77     -37.124  22.674 -26.263  0.00  0.00           C  
ATOM   1172  CE1 TYR A  77     -39.356  23.724 -24.915  0.00  0.00           C  
ATOM   1173  CE2 TYR A  77     -38.251  23.099 -26.992  0.00  0.00           C  
ATOM   1174  CZ  TYR A  77     -39.387  23.593 -26.319  0.00  0.00           C  
ATOM   1175  OH  TYR A  77     -40.509  23.924 -27.016  0.00  0.00           O  
ATOM   1176  H   TYR A  77     -34.585  20.370 -22.651  0.00  0.00           H  
ATOM   1177  HA  TYR A  77     -36.731  22.355 -22.051  0.00  0.00           H  
ATOM   1178  HB2 TYR A  77     -35.168  22.978 -23.944  0.00  0.00           H  
ATOM   1179  HB3 TYR A  77     -35.474  21.441 -24.678  0.00  0.00           H  
ATOM   1180  HD1 TYR A  77     -38.213  23.475 -23.134  0.00  0.00           H  
ATOM   1181  HD2 TYR A  77     -36.278  22.252 -26.783  0.00  0.00           H  
ATOM   1182  HE1 TYR A  77     -40.211  24.088 -24.368  0.00  0.00           H  
ATOM   1183  HE2 TYR A  77     -38.249  23.027 -28.067  0.00  0.00           H  
ATOM   1184  HH  TYR A  77     -40.408  23.780 -27.969  0.00  0.00           H  
ATOM   1185  N   VAL A  78     -38.574  20.735 -22.776  0.00  0.00           N  
ATOM   1186  CA  VAL A  78     -39.632  19.812 -23.187  0.00  0.00           C  
ATOM   1187  C   VAL A  78     -40.840  20.577 -23.721  0.00  0.00           C  
ATOM   1188  O   VAL A  78     -41.312  21.536 -23.110  0.00  0.00           O  
ATOM   1189  CB  VAL A  78     -39.998  18.843 -22.042  0.00  0.00           C  
ATOM   1190  CG1 VAL A  78     -40.161  19.545 -20.690  0.00  0.00           C  
ATOM   1191  CG2 VAL A  78     -41.287  18.050 -22.314  0.00  0.00           C  
ATOM   1192  H   VAL A  78     -38.866  21.641 -22.417  0.00  0.00           H  
ATOM   1193  HA  VAL A  78     -39.243  19.223 -24.013  0.00  0.00           H  
ATOM   1194  HB  VAL A  78     -39.174  18.133 -21.958  0.00  0.00           H  
ATOM   1195 HG11 VAL A  78     -40.571  18.858 -19.950  0.00  0.00           H  
ATOM   1196 HG12 VAL A  78     -39.198  19.907 -20.338  0.00  0.00           H  
ATOM   1197 HG13 VAL A  78     -40.830  20.389 -20.805  0.00  0.00           H  
ATOM   1198 HG21 VAL A  78     -42.160  18.697 -22.224  0.00  0.00           H  
ATOM   1199 HG22 VAL A  78     -41.269  17.623 -23.316  0.00  0.00           H  
ATOM   1200 HG23 VAL A  78     -41.377  17.239 -21.590  0.00  0.00           H  
ATOM   1201  N   GLY A  79     -41.374  20.132 -24.856  0.00  0.00           N  
ATOM   1202  CA  GLY A  79     -42.618  20.693 -25.402  0.00  0.00           C  
ATOM   1203  C   GLY A  79     -43.447  19.740 -26.256  0.00  0.00           C  
ATOM   1204  O   GLY A  79     -43.021  18.628 -26.558  0.00  0.00           O  
ATOM   1205  H   GLY A  79     -40.883  19.376 -25.347  0.00  0.00           H  
ATOM   1206  HA2 GLY A  79     -43.262  20.960 -24.569  0.00  0.00           H  
ATOM   1207  HA3 GLY A  79     -42.410  21.607 -25.956  0.00  0.00           H  
ATOM   1208  N   ASN A  80     -44.648  20.188 -26.646  0.00  0.00           N  
ATOM   1209  CA  ASN A  80     -45.691  19.351 -27.258  0.00  0.00           C  
ATOM   1210  C   ASN A  80     -45.998  18.134 -26.357  0.00  0.00           C  
ATOM   1211  O   ASN A  80     -45.888  16.983 -26.777  0.00  0.00           O  
ATOM   1212  CB  ASN A  80     -45.367  19.014 -28.731  0.00  0.00           C  
ATOM   1213  CG  ASN A  80     -45.661  20.156 -29.690  0.00  0.00           C  
ATOM   1214  OD1 ASN A  80     -46.502  20.045 -30.571  0.00  0.00           O  
ATOM   1215  ND2 ASN A  80     -44.991  21.278 -29.566  0.00  0.00           N  
ATOM   1216  H   ASN A  80     -44.938  21.093 -26.294  0.00  0.00           H  
ATOM   1217  HA  ASN A  80     -46.617  19.931 -27.262  0.00  0.00           H  
ATOM   1218  HB2 ASN A  80     -44.327  18.712 -28.836  0.00  0.00           H  
ATOM   1219  HB3 ASN A  80     -45.985  18.171 -29.044  0.00  0.00           H  
ATOM   1220 HD21 ASN A  80     -44.318  21.386 -28.826  0.00  0.00           H  
ATOM   1221 HD22 ASN A  80     -45.213  22.039 -30.189  0.00  0.00           H  
ATOM   1222  N   LEU A  81     -46.322  18.406 -25.088  0.00  0.00           N  
ATOM   1223  CA  LEU A  81     -46.560  17.424 -24.016  0.00  0.00           C  
ATOM   1224  C   LEU A  81     -48.043  17.069 -23.793  0.00  0.00           C  
ATOM   1225  O   LEU A  81     -48.358  15.943 -23.400  0.00  0.00           O  
ATOM   1226  CB  LEU A  81     -45.950  18.033 -22.734  0.00  0.00           C  
ATOM   1227  CG  LEU A  81     -46.184  17.232 -21.442  0.00  0.00           C  
ATOM   1228  CD1 LEU A  81     -45.619  15.820 -21.554  0.00  0.00           C  
ATOM   1229  CD2 LEU A  81     -45.516  17.928 -20.263  0.00  0.00           C  
ATOM   1230  H   LEU A  81     -46.302  19.385 -24.819  0.00  0.00           H  
ATOM   1231  HA  LEU A  81     -46.047  16.493 -24.252  0.00  0.00           H  
ATOM   1232  HB2 LEU A  81     -44.875  18.153 -22.884  0.00  0.00           H  
ATOM   1233  HB3 LEU A  81     -46.379  19.024 -22.582  0.00  0.00           H  
ATOM   1234  HG  LEU A  81     -47.251  17.176 -21.231  0.00  0.00           H  
ATOM   1235 HD11 LEU A  81     -45.763  15.297 -20.612  0.00  0.00           H  
ATOM   1236 HD12 LEU A  81     -46.131  15.282 -22.354  0.00  0.00           H  
ATOM   1237 HD13 LEU A  81     -44.552  15.870 -21.768  0.00  0.00           H  
ATOM   1238 HD21 LEU A  81     -45.706  17.365 -19.350  0.00  0.00           H  
ATOM   1239 HD22 LEU A  81     -44.441  17.998 -20.431  0.00  0.00           H  
ATOM   1240 HD23 LEU A  81     -45.931  18.931 -20.146  0.00  0.00           H  
ATOM   1241  N   GLY A  82     -48.945  18.007 -24.076  0.00  0.00           N  
ATOM   1242  CA  GLY A  82     -50.371  17.951 -23.725  0.00  0.00           C  
ATOM   1243  C   GLY A  82     -50.678  19.020 -22.669  0.00  0.00           C  
ATOM   1244  O   GLY A  82     -49.760  19.511 -22.013  0.00  0.00           O  
ATOM   1245  H   GLY A  82     -48.596  18.887 -24.424  0.00  0.00           H  
ATOM   1246  HA2 GLY A  82     -50.974  18.139 -24.613  0.00  0.00           H  
ATOM   1247  HA3 GLY A  82     -50.641  16.974 -23.322  0.00  0.00           H  
ATOM   1248  N   ASN A  83     -51.944  19.414 -22.509  0.00  0.00           N  
ATOM   1249  CA  ASN A  83     -52.332  20.535 -21.638  0.00  0.00           C  
ATOM   1250  C   ASN A  83     -52.092  20.235 -20.139  0.00  0.00           C  
ATOM   1251  O   ASN A  83     -52.945  19.659 -19.458  0.00  0.00           O  
ATOM   1252  CB  ASN A  83     -53.776  20.970 -21.945  0.00  0.00           C  
ATOM   1253  CG  ASN A  83     -53.929  21.498 -23.363  0.00  0.00           C  
ATOM   1254  OD1 ASN A  83     -54.444  20.829 -24.247  0.00  0.00           O  
ATOM   1255  ND2 ASN A  83     -53.469  22.700 -23.639  0.00  0.00           N  
ATOM   1256  H   ASN A  83     -52.664  18.964 -23.056  0.00  0.00           H  
ATOM   1257  HA  ASN A  83     -51.692  21.379 -21.893  0.00  0.00           H  
ATOM   1258  HB2 ASN A  83     -54.456  20.128 -21.802  0.00  0.00           H  
ATOM   1259  HB3 ASN A  83     -54.066  21.760 -21.254  0.00  0.00           H  
ATOM   1260 HD21 ASN A  83     -53.021  23.262 -22.931  0.00  0.00           H  
ATOM   1261 HD22 ASN A  83     -53.563  23.041 -24.584  0.00  0.00           H  
ATOM   1262  N   ASN A  84     -50.914  20.616 -19.634  0.00  0.00           N  
ATOM   1263  CA  ASN A  84     -50.436  20.400 -18.268  0.00  0.00           C  
ATOM   1264  C   ASN A  84     -49.422  21.497 -17.882  0.00  0.00           C  
ATOM   1265  O   ASN A  84     -48.404  21.685 -18.553  0.00  0.00           O  
ATOM   1266  CB  ASN A  84     -49.803  18.993 -18.184  0.00  0.00           C  
ATOM   1267  CG  ASN A  84     -49.421  18.565 -16.771  0.00  0.00           C  
ATOM   1268  OD1 ASN A  84     -49.080  19.356 -15.901  0.00  0.00           O  
ATOM   1269  ND2 ASN A  84     -49.480  17.285 -16.488  0.00  0.00           N  
ATOM   1270  H   ASN A  84     -50.280  21.092 -20.268  0.00  0.00           H  
ATOM   1271  HA  ASN A  84     -51.283  20.447 -17.580  0.00  0.00           H  
ATOM   1272  HB2 ASN A  84     -50.518  18.270 -18.575  0.00  0.00           H  
ATOM   1273  HB3 ASN A  84     -48.912  18.949 -18.810  0.00  0.00           H  
ATOM   1274 HD21 ASN A  84     -49.762  16.622 -17.196  0.00  0.00           H  
ATOM   1275 HD22 ASN A  84     -49.266  16.995 -15.550  0.00  0.00           H  
ATOM   1276  N   GLY A  85     -49.686  22.183 -16.767  0.00  0.00           N  
ATOM   1277  CA  GLY A  85     -48.812  23.193 -16.154  0.00  0.00           C  
ATOM   1278  C   GLY A  85     -48.729  23.036 -14.634  0.00  0.00           C  
ATOM   1279  O   GLY A  85     -48.726  24.025 -13.902  0.00  0.00           O  
ATOM   1280  H   GLY A  85     -50.551  21.972 -16.287  0.00  0.00           H  
ATOM   1281  HA2 GLY A  85     -47.801  23.092 -16.553  0.00  0.00           H  
ATOM   1282  HA3 GLY A  85     -49.186  24.190 -16.384  0.00  0.00           H  
ATOM   1283  N   ASN A  86     -48.684  21.785 -14.163  0.00  0.00           N  
ATOM   1284  CA  ASN A  86     -48.691  21.412 -12.739  0.00  0.00           C  
ATOM   1285  C   ASN A  86     -47.331  20.835 -12.279  0.00  0.00           C  
ATOM   1286  O   ASN A  86     -47.187  20.460 -11.116  0.00  0.00           O  
ATOM   1287  CB  ASN A  86     -49.857  20.418 -12.528  0.00  0.00           C  
ATOM   1288  CG  ASN A  86     -50.497  20.483 -11.144  0.00  0.00           C  
ATOM   1289  OD1 ASN A  86     -51.672  20.792 -10.997  0.00  0.00           O  
ATOM   1290  ND2 ASN A  86     -49.774  20.194 -10.087  0.00  0.00           N  
ATOM   1291  H   ASN A  86     -48.708  21.030 -14.842  0.00  0.00           H  
ATOM   1292  HA  ASN A  86     -48.880  22.303 -12.137  0.00  0.00           H  
ATOM   1293  HB2 ASN A  86     -50.647  20.631 -13.249  0.00  0.00           H  
ATOM   1294  HB3 ASN A  86     -49.511  19.401 -12.711  0.00  0.00           H  
ATOM   1295 HD21 ASN A  86     -48.779  20.008 -10.190  0.00  0.00           H  
ATOM   1296 HD22 ASN A  86     -50.206  20.232  -9.177  0.00  0.00           H  
ATOM   1297  N   LYS A  87     -46.356  20.741 -13.199  0.00  0.00           N  
ATOM   1298  CA  LYS A  87     -45.019  20.100 -13.154  0.00  0.00           C  
ATOM   1299  C   LYS A  87     -44.899  18.658 -12.639  0.00  0.00           C  
ATOM   1300  O   LYS A  87     -44.020  17.952 -13.107  0.00  0.00           O  
ATOM   1301  CB  LYS A  87     -43.968  21.038 -12.525  0.00  0.00           C  
ATOM   1302  CG  LYS A  87     -43.967  21.123 -10.988  0.00  0.00           C  
ATOM   1303  CD  LYS A  87     -42.835  22.044 -10.503  0.00  0.00           C  
ATOM   1304  CE  LYS A  87     -42.853  22.241  -8.981  0.00  0.00           C  
ATOM   1305  NZ  LYS A  87     -42.344  21.055  -8.247  0.00  0.00           N  
ATOM   1306  H   LYS A  87     -46.611  21.119 -14.100  0.00  0.00           H  
ATOM   1307  HA  LYS A  87     -44.718  20.010 -14.198  0.00  0.00           H  
ATOM   1308  HB2 LYS A  87     -42.987  20.686 -12.839  0.00  0.00           H  
ATOM   1309  HB3 LYS A  87     -44.105  22.042 -12.929  0.00  0.00           H  
ATOM   1310  HG2 LYS A  87     -44.916  21.534 -10.647  0.00  0.00           H  
ATOM   1311  HG3 LYS A  87     -43.831  20.130 -10.563  0.00  0.00           H  
ATOM   1312  HD2 LYS A  87     -41.868  21.641 -10.810  0.00  0.00           H  
ATOM   1313  HD3 LYS A  87     -42.959  23.023 -10.972  0.00  0.00           H  
ATOM   1314  HE2 LYS A  87     -42.233  23.108  -8.739  0.00  0.00           H  
ATOM   1315  HE3 LYS A  87     -43.876  22.471  -8.664  0.00  0.00           H  
ATOM   1316  HZ1 LYS A  87     -42.884  20.215  -8.433  0.00  0.00           H  
ATOM   1317  HZ2 LYS A  87     -41.403  20.797  -8.544  0.00  0.00           H  
ATOM   1318  HZ3 LYS A  87     -42.330  21.207  -7.250  0.00  0.00           H  
ATOM   1319  N   THR A  88     -45.764  18.184 -11.753  0.00  0.00           N  
ATOM   1320  CA  THR A  88     -45.659  16.910 -11.017  0.00  0.00           C  
ATOM   1321  C   THR A  88     -45.372  15.705 -11.904  0.00  0.00           C  
ATOM   1322  O   THR A  88     -44.486  14.907 -11.593  0.00  0.00           O  
ATOM   1323  CB  THR A  88     -46.963  16.667 -10.239  0.00  0.00           C  
ATOM   1324  OG1 THR A  88     -47.075  17.597  -9.182  0.00  0.00           O  
ATOM   1325  CG2 THR A  88     -47.086  15.257  -9.661  0.00  0.00           C  
ATOM   1326  H   THR A  88     -46.469  18.828 -11.445  0.00  0.00           H  
ATOM   1327  HA  THR A  88     -44.840  16.983 -10.302  0.00  0.00           H  
ATOM   1328  HB  THR A  88     -47.805  16.821 -10.917  0.00  0.00           H  
ATOM   1329  HG1 THR A  88     -46.387  17.388  -8.526  0.00  0.00           H  
ATOM   1330 HG21 THR A  88     -47.956  15.202  -9.011  0.00  0.00           H  
ATOM   1331 HG22 THR A  88     -47.215  14.540 -10.478  0.00  0.00           H  
ATOM   1332 HG23 THR A  88     -46.184  15.005  -9.102  0.00  0.00           H  
ATOM   1333  N   GLU A  89     -46.111  15.560 -13.008  0.00  0.00           N  
ATOM   1334  CA  GLU A  89     -45.933  14.430 -13.911  0.00  0.00           C  
ATOM   1335  C   GLU A  89     -44.539  14.474 -14.529  0.00  0.00           C  
ATOM   1336  O   GLU A  89     -43.781  13.508 -14.408  0.00  0.00           O  
ATOM   1337  CB  GLU A  89     -47.025  14.456 -14.993  0.00  0.00           C  
ATOM   1338  CG  GLU A  89     -46.681  13.530 -16.168  0.00  0.00           C  
ATOM   1339  CD  GLU A  89     -47.786  12.504 -16.450  0.00  0.00           C  
ATOM   1340  OE1 GLU A  89     -48.860  12.876 -16.977  0.00  0.00           O  
ATOM   1341  OE2 GLU A  89     -47.560  11.316 -16.103  0.00  0.00           O  
ATOM   1342  H   GLU A  89     -46.773  16.275 -13.267  0.00  0.00           H  
ATOM   1343  HA  GLU A  89     -46.019  13.496 -13.354  0.00  0.00           H  
ATOM   1344  HB2 GLU A  89     -47.972  14.164 -14.539  0.00  0.00           H  
ATOM   1345  HB3 GLU A  89     -47.133  15.474 -15.377  0.00  0.00           H  
ATOM   1346  HG2 GLU A  89     -46.418  14.148 -17.030  0.00  0.00           H  
ATOM   1347  HG3 GLU A  89     -45.783  12.966 -15.936  0.00  0.00           H  
ATOM   1348  N   LEU A  90     -44.215  15.577 -15.208  0.00  0.00           N  
ATOM   1349  CA  LEU A  90     -42.940  15.679 -15.897  0.00  0.00           C  
ATOM   1350  C   LEU A  90     -41.766  15.650 -14.907  0.00  0.00           C  
ATOM   1351  O   LEU A  90     -40.730  15.076 -15.199  0.00  0.00           O  
ATOM   1352  CB  LEU A  90     -42.925  16.874 -16.861  0.00  0.00           C  
ATOM   1353  CG  LEU A  90     -43.188  18.299 -16.323  0.00  0.00           C  
ATOM   1354  CD1 LEU A  90     -42.057  18.914 -15.500  0.00  0.00           C  
ATOM   1355  CD2 LEU A  90     -43.230  19.193 -17.555  0.00  0.00           C  
ATOM   1356  H   LEU A  90     -44.870  16.342 -15.256  0.00  0.00           H  
ATOM   1357  HA  LEU A  90     -42.884  14.783 -16.520  0.00  0.00           H  
ATOM   1358  HB2 LEU A  90     -41.962  16.866 -17.376  0.00  0.00           H  
ATOM   1359  HB3 LEU A  90     -43.682  16.661 -17.617  0.00  0.00           H  
ATOM   1360  HG  LEU A  90     -44.132  18.349 -15.764  0.00  0.00           H  
ATOM   1361 HD11 LEU A  90     -42.028  18.486 -14.511  0.00  0.00           H  
ATOM   1362 HD12 LEU A  90     -41.097  18.763 -15.987  0.00  0.00           H  
ATOM   1363 HD13 LEU A  90     -42.229  19.984 -15.376  0.00  0.00           H  
ATOM   1364 HD21 LEU A  90     -44.004  18.854 -18.233  0.00  0.00           H  
ATOM   1365 HD22 LEU A  90     -43.450  20.213 -17.265  0.00  0.00           H  
ATOM   1366 HD23 LEU A  90     -42.253  19.151 -18.046  0.00  0.00           H  
ATOM   1367  N   GLU A  91     -41.949  16.182 -13.701  0.00  0.00           N  
ATOM   1368  CA  GLU A  91     -40.957  16.212 -12.627  0.00  0.00           C  
ATOM   1369  C   GLU A  91     -40.618  14.799 -12.143  0.00  0.00           C  
ATOM   1370  O   GLU A  91     -39.442  14.437 -12.101  0.00  0.00           O  
ATOM   1371  CB  GLU A  91     -41.494  17.107 -11.499  0.00  0.00           C  
ATOM   1372  CG  GLU A  91     -40.569  17.240 -10.288  0.00  0.00           C  
ATOM   1373  CD  GLU A  91     -41.067  18.367  -9.366  0.00  0.00           C  
ATOM   1374  OE1 GLU A  91     -42.200  18.283  -8.833  0.00  0.00           O  
ATOM   1375  OE2 GLU A  91     -40.350  19.380  -9.186  0.00  0.00           O  
ATOM   1376  H   GLU A  91     -42.821  16.678 -13.550  0.00  0.00           H  
ATOM   1377  HA  GLU A  91     -40.039  16.657 -13.011  0.00  0.00           H  
ATOM   1378  HB2 GLU A  91     -41.653  18.105 -11.909  0.00  0.00           H  
ATOM   1379  HB3 GLU A  91     -42.455  16.720 -11.160  0.00  0.00           H  
ATOM   1380  HG2 GLU A  91     -40.537  16.292  -9.747  0.00  0.00           H  
ATOM   1381  HG3 GLU A  91     -39.562  17.464 -10.638  0.00  0.00           H  
ATOM   1382  N   ARG A  92     -41.623  13.955 -11.860  0.00  0.00           N  
ATOM   1383  CA  ARG A  92     -41.354  12.540 -11.556  0.00  0.00           C  
ATOM   1384  C   ARG A  92     -40.874  11.764 -12.782  0.00  0.00           C  
ATOM   1385  O   ARG A  92     -40.059  10.862 -12.622  0.00  0.00           O  
ATOM   1386  CB  ARG A  92     -42.515  11.881 -10.788  0.00  0.00           C  
ATOM   1387  CG  ARG A  92     -43.740  11.403 -11.581  0.00  0.00           C  
ATOM   1388  CD  ARG A  92     -43.518  10.078 -12.333  0.00  0.00           C  
ATOM   1389  NE  ARG A  92     -44.799   9.522 -12.823  0.00  0.00           N  
ATOM   1390  CZ  ARG A  92     -45.517   9.948 -13.849  0.00  0.00           C  
ATOM   1391  NH1 ARG A  92     -45.151  10.919 -14.626  0.00  0.00           N  
ATOM   1392  NH2 ARG A  92     -46.671   9.435 -14.146  0.00  0.00           N  
ATOM   1393  H   ARG A  92     -42.582  14.290 -11.909  0.00  0.00           H  
ATOM   1394  HA  ARG A  92     -40.506  12.516 -10.872  0.00  0.00           H  
ATOM   1395  HB2 ARG A  92     -42.115  11.025 -10.244  0.00  0.00           H  
ATOM   1396  HB3 ARG A  92     -42.861  12.597 -10.042  0.00  0.00           H  
ATOM   1397  HG2 ARG A  92     -44.547  11.246 -10.865  0.00  0.00           H  
ATOM   1398  HG3 ARG A  92     -44.059  12.184 -12.267  0.00  0.00           H  
ATOM   1399  HD2 ARG A  92     -42.827  10.208 -13.165  0.00  0.00           H  
ATOM   1400  HD3 ARG A  92     -43.040   9.363 -11.655  0.00  0.00           H  
ATOM   1401  HE  ARG A  92     -45.188   8.751 -12.300  0.00  0.00           H  
ATOM   1402 HH11 ARG A  92     -44.331  11.474 -14.432  0.00  0.00           H  
ATOM   1403 HH12 ARG A  92     -45.799  11.182 -15.362  0.00  0.00           H  
ATOM   1404 HH21 ARG A  92     -47.065   8.688 -13.600  0.00  0.00           H  
ATOM   1405 HH22 ARG A  92     -47.203   9.871 -14.899  0.00  0.00           H  
ATOM   1406  N   ALA A  93     -41.323  12.113 -13.993  0.00  0.00           N  
ATOM   1407  CA  ALA A  93     -40.837  11.492 -15.231  0.00  0.00           C  
ATOM   1408  C   ALA A  93     -39.342  11.737 -15.431  0.00  0.00           C  
ATOM   1409  O   ALA A  93     -38.595  10.812 -15.711  0.00  0.00           O  
ATOM   1410  CB  ALA A  93     -41.589  12.039 -16.445  0.00  0.00           C  
ATOM   1411  H   ALA A  93     -42.025  12.845 -14.054  0.00  0.00           H  
ATOM   1412  HA  ALA A  93     -41.003  10.414 -15.175  0.00  0.00           H  
ATOM   1413  HB1 ALA A  93     -41.271  11.484 -17.327  0.00  0.00           H  
ATOM   1414  HB2 ALA A  93     -42.662  11.928 -16.305  0.00  0.00           H  
ATOM   1415  HB3 ALA A  93     -41.327  13.084 -16.609  0.00  0.00           H  
ATOM   1416  N   PHE A  94     -38.894  12.975 -15.254  0.00  0.00           N  
ATOM   1417  CA  PHE A  94     -37.497  13.369 -15.283  0.00  0.00           C  
ATOM   1418  C   PHE A  94     -36.708  12.700 -14.166  0.00  0.00           C  
ATOM   1419  O   PHE A  94     -35.840  11.869 -14.447  0.00  0.00           O  
ATOM   1420  CB  PHE A  94     -37.458  14.910 -15.214  0.00  0.00           C  
ATOM   1421  CG  PHE A  94     -37.790  15.647 -16.504  0.00  0.00           C  
ATOM   1422  CD1 PHE A  94     -37.163  15.267 -17.703  0.00  0.00           C  
ATOM   1423  CD2 PHE A  94     -38.696  16.730 -16.523  0.00  0.00           C  
ATOM   1424  CE1 PHE A  94     -37.425  15.951 -18.896  0.00  0.00           C  
ATOM   1425  CE2 PHE A  94     -39.026  17.354 -17.737  0.00  0.00           C  
ATOM   1426  CZ  PHE A  94     -38.399  16.955 -18.928  0.00  0.00           C  
ATOM   1427  H   PHE A  94     -39.577  13.705 -15.075  0.00  0.00           H  
ATOM   1428  HA  PHE A  94     -37.011  12.985 -16.179  0.00  0.00           H  
ATOM   1429  HB2 PHE A  94     -38.153  15.236 -14.443  0.00  0.00           H  
ATOM   1430  HB3 PHE A  94     -36.472  15.222 -14.891  0.00  0.00           H  
ATOM   1431  HD1 PHE A  94     -36.490  14.429 -17.722  0.00  0.00           H  
ATOM   1432  HD2 PHE A  94     -39.180  17.067 -15.617  0.00  0.00           H  
ATOM   1433  HE1 PHE A  94     -36.907  15.668 -19.801  0.00  0.00           H  
ATOM   1434  HE2 PHE A  94     -39.752  18.152 -17.756  0.00  0.00           H  
ATOM   1435  HZ  PHE A  94     -38.628  17.444 -19.859  0.00  0.00           H  
ATOM   1436  N   GLY A  95     -37.040  12.989 -12.909  0.00  0.00           N  
ATOM   1437  CA  GLY A  95     -36.338  12.413 -11.774  0.00  0.00           C  
ATOM   1438  C   GLY A  95     -36.331  10.868 -11.697  0.00  0.00           C  
ATOM   1439  O   GLY A  95     -35.441  10.304 -11.058  0.00  0.00           O  
ATOM   1440  H   GLY A  95     -37.736  13.708 -12.720  0.00  0.00           H  
ATOM   1441  HA2 GLY A  95     -35.318  12.764 -11.803  0.00  0.00           H  
ATOM   1442  HA3 GLY A  95     -36.756  12.856 -10.895  0.00  0.00           H  
ATOM   1443  N   TYR A  96     -37.258  10.172 -12.375  0.00  0.00           N  
ATOM   1444  CA  TYR A  96     -37.242   8.713 -12.578  0.00  0.00           C  
ATOM   1445  C   TYR A  96     -35.958   8.215 -13.278  0.00  0.00           C  
ATOM   1446  O   TYR A  96     -35.312   7.292 -12.773  0.00  0.00           O  
ATOM   1447  CB  TYR A  96     -38.461   8.305 -13.410  0.00  0.00           C  
ATOM   1448  CG  TYR A  96     -38.370   6.949 -14.090  0.00  0.00           C  
ATOM   1449  CD1 TYR A  96     -38.483   5.763 -13.338  0.00  0.00           C  
ATOM   1450  CD2 TYR A  96     -38.123   6.885 -15.477  0.00  0.00           C  
ATOM   1451  CE1 TYR A  96     -38.340   4.513 -13.972  0.00  0.00           C  
ATOM   1452  CE2 TYR A  96     -37.977   5.639 -16.111  0.00  0.00           C  
ATOM   1453  CZ  TYR A  96     -38.081   4.447 -15.360  0.00  0.00           C  
ATOM   1454  OH  TYR A  96     -37.925   3.244 -15.980  0.00  0.00           O  
ATOM   1455  H   TYR A  96     -38.039  10.680 -12.780  0.00  0.00           H  
ATOM   1456  HA  TYR A  96     -37.338   8.223 -11.609  0.00  0.00           H  
ATOM   1457  HB2 TYR A  96     -39.354   8.332 -12.784  0.00  0.00           H  
ATOM   1458  HB3 TYR A  96     -38.560   9.048 -14.189  0.00  0.00           H  
ATOM   1459  HD1 TYR A  96     -38.669   5.814 -12.273  0.00  0.00           H  
ATOM   1460  HD2 TYR A  96     -38.028   7.799 -16.057  0.00  0.00           H  
ATOM   1461  HE1 TYR A  96     -38.420   3.602 -13.395  0.00  0.00           H  
ATOM   1462  HE2 TYR A  96     -37.772   5.587 -17.172  0.00  0.00           H  
ATOM   1463  HH  TYR A  96     -38.007   2.498 -15.361  0.00  0.00           H  
ATOM   1464  N   TYR A  97     -35.565   8.817 -14.419  0.00  0.00           N  
ATOM   1465  CA  TYR A  97     -34.296   8.486 -15.098  0.00  0.00           C  
ATOM   1466  C   TYR A  97     -33.112   8.835 -14.196  0.00  0.00           C  
ATOM   1467  O   TYR A  97     -32.124   8.095 -14.132  0.00  0.00           O  
ATOM   1468  CB  TYR A  97     -34.130   9.227 -16.429  0.00  0.00           C  
ATOM   1469  CG  TYR A  97     -35.273   9.018 -17.399  0.00  0.00           C  
ATOM   1470  CD1 TYR A  97     -35.318   7.902 -18.263  0.00  0.00           C  
ATOM   1471  CD2 TYR A  97     -36.321   9.948 -17.402  0.00  0.00           C  
ATOM   1472  CE1 TYR A  97     -36.435   7.698 -19.095  0.00  0.00           C  
ATOM   1473  CE2 TYR A  97     -37.444   9.733 -18.218  0.00  0.00           C  
ATOM   1474  CZ  TYR A  97     -37.515   8.604 -19.059  0.00  0.00           C  
ATOM   1475  OH  TYR A  97     -38.624   8.414 -19.826  0.00  0.00           O  
ATOM   1476  H   TYR A  97     -36.120   9.578 -14.785  0.00  0.00           H  
ATOM   1477  HA  TYR A  97     -34.270   7.414 -15.293  0.00  0.00           H  
ATOM   1478  HB2 TYR A  97     -34.033  10.291 -16.238  0.00  0.00           H  
ATOM   1479  HB3 TYR A  97     -33.215   8.891 -16.910  0.00  0.00           H  
ATOM   1480  HD1 TYR A  97     -34.495   7.195 -18.271  0.00  0.00           H  
ATOM   1481  HD2 TYR A  97     -36.277  10.816 -16.747  0.00  0.00           H  
ATOM   1482  HE1 TYR A  97     -36.479   6.845 -19.743  0.00  0.00           H  
ATOM   1483  HE2 TYR A  97     -38.256  10.441 -18.186  0.00  0.00           H  
ATOM   1484  HH  TYR A  97     -38.556   7.666 -20.451  0.00  0.00           H  
ATOM   1485  N   GLY A  98     -33.232   9.953 -13.473  0.00  0.00           N  
ATOM   1486  CA  GLY A  98     -32.288  10.274 -12.388  0.00  0.00           C  
ATOM   1487  C   GLY A  98     -32.495  11.647 -11.747  0.00  0.00           C  
ATOM   1488  O   GLY A  98     -33.145  12.482 -12.353  0.00  0.00           O  
ATOM   1489  H   GLY A  98     -34.052  10.551 -13.665  0.00  0.00           H  
ATOM   1490  HA2 GLY A  98     -32.408   9.515 -11.617  0.00  0.00           H  
ATOM   1491  HA3 GLY A  98     -31.271  10.211 -12.756  0.00  0.00           H  
ATOM   1492  N   PRO A  99     -31.992  11.930 -10.536  0.00  0.00           N  
ATOM   1493  CA  PRO A  99     -32.356  13.138  -9.792  0.00  0.00           C  
ATOM   1494  C   PRO A  99     -32.173  14.484 -10.510  0.00  0.00           C  
ATOM   1495  O   PRO A  99     -31.106  14.863 -11.004  0.00  0.00           O  
ATOM   1496  CB  PRO A  99     -31.535  13.088  -8.497  0.00  0.00           C  
ATOM   1497  CG  PRO A  99     -31.231  11.602  -8.311  0.00  0.00           C  
ATOM   1498  CD  PRO A  99     -31.134  11.073  -9.740  0.00  0.00           C  
ATOM   1499  HA  PRO A  99     -33.433  13.057  -9.580  0.00  0.00           H  
ATOM   1500  HB2 PRO A  99     -30.594  13.626  -8.628  0.00  0.00           H  
ATOM   1501  HB3 PRO A  99     -32.089  13.498  -7.652  0.00  0.00           H  
ATOM   1502  HG2 PRO A  99     -30.305  11.446  -7.758  0.00  0.00           H  
ATOM   1503  HG3 PRO A  99     -32.067  11.121  -7.802  0.00  0.00           H  
ATOM   1504  HD2 PRO A  99     -30.111  11.167 -10.105  0.00  0.00           H  
ATOM   1505  HD3 PRO A  99     -31.454  10.032  -9.777  0.00  0.00           H  
ATOM   1506  N   LEU A 100     -33.271  15.234 -10.489  0.00  0.00           N  
ATOM   1507  CA  LEU A 100     -33.381  16.628 -10.891  0.00  0.00           C  
ATOM   1508  C   LEU A 100     -32.616  17.594  -9.959  0.00  0.00           C  
ATOM   1509  O   LEU A 100     -32.228  17.243  -8.840  0.00  0.00           O  
ATOM   1510  CB  LEU A 100     -34.876  16.962 -10.878  0.00  0.00           C  
ATOM   1511  CG  LEU A 100     -35.635  16.482 -12.128  0.00  0.00           C  
ATOM   1512  CD1 LEU A 100     -37.105  16.459 -11.741  0.00  0.00           C  
ATOM   1513  CD2 LEU A 100     -35.403  17.446 -13.288  0.00  0.00           C  
ATOM   1514  H   LEU A 100     -34.085  14.826 -10.057  0.00  0.00           H  
ATOM   1515  HA  LEU A 100     -33.006  16.739 -11.903  0.00  0.00           H  
ATOM   1516  HB2 LEU A 100     -35.321  16.523  -9.980  0.00  0.00           H  
ATOM   1517  HB3 LEU A 100     -35.017  18.040 -10.788  0.00  0.00           H  
ATOM   1518  HG  LEU A 100     -35.346  15.473 -12.444  0.00  0.00           H  
ATOM   1519 HD11 LEU A 100     -37.278  15.619 -11.065  0.00  0.00           H  
ATOM   1520 HD12 LEU A 100     -37.369  17.381 -11.230  0.00  0.00           H  
ATOM   1521 HD13 LEU A 100     -37.724  16.348 -12.622  0.00  0.00           H  
ATOM   1522 HD21 LEU A 100     -36.104  17.246 -14.093  0.00  0.00           H  
ATOM   1523 HD22 LEU A 100     -35.536  18.477 -12.964  0.00  0.00           H  
ATOM   1524 HD23 LEU A 100     -34.390  17.323 -13.670  0.00  0.00           H  
ATOM   1525  N   ARG A 101     -32.500  18.847 -10.409  0.00  0.00           N  
ATOM   1526  CA  ARG A 101     -32.021  20.015  -9.650  0.00  0.00           C  
ATOM   1527  C   ARG A 101     -33.062  21.146  -9.654  0.00  0.00           C  
ATOM   1528  O   ARG A 101     -33.251  21.798  -8.628  0.00  0.00           O  
ATOM   1529  CB  ARG A 101     -30.677  20.480 -10.237  0.00  0.00           C  
ATOM   1530  CG  ARG A 101     -30.027  21.599  -9.402  0.00  0.00           C  
ATOM   1531  CD  ARG A 101     -28.815  22.214 -10.106  0.00  0.00           C  
ATOM   1532  NE  ARG A 101     -27.698  21.266 -10.243  0.00  0.00           N  
ATOM   1533  CZ  ARG A 101     -26.811  21.236 -11.220  0.00  0.00           C  
ATOM   1534  NH1 ARG A 101     -26.840  22.015 -12.260  0.00  0.00           N  
ATOM   1535  NH2 ARG A 101     -25.816  20.408 -11.181  0.00  0.00           N  
ATOM   1536  H   ARG A 101     -32.810  19.012 -11.362  0.00  0.00           H  
ATOM   1537  HA  ARG A 101     -31.865  19.732  -8.607  0.00  0.00           H  
ATOM   1538  HB2 ARG A 101     -29.992  19.630 -10.276  0.00  0.00           H  
ATOM   1539  HB3 ARG A 101     -30.839  20.838 -11.254  0.00  0.00           H  
ATOM   1540  HG2 ARG A 101     -30.743  22.404  -9.243  0.00  0.00           H  
ATOM   1541  HG3 ARG A 101     -29.728  21.206  -8.429  0.00  0.00           H  
ATOM   1542  HD2 ARG A 101     -29.141  22.560 -11.084  0.00  0.00           H  
ATOM   1543  HD3 ARG A 101     -28.480  23.079  -9.533  0.00  0.00           H  
ATOM   1544  HE  ARG A 101     -27.586  20.567  -9.510  0.00  0.00           H  
ATOM   1545 HH11 ARG A 101     -27.596  22.683 -12.411  0.00  0.00           H  
ATOM   1546 HH12 ARG A 101     -26.114  21.909 -12.955  0.00  0.00           H  
ATOM   1547 HH21 ARG A 101     -25.682  19.789 -10.381  0.00  0.00           H  
ATOM   1548 HH22 ARG A 101     -25.193  20.374 -11.974  0.00  0.00           H  
ATOM   1549  N   SER A 102     -33.765  21.350 -10.773  0.00  0.00           N  
ATOM   1550  CA  SER A 102     -34.874  22.307 -10.903  0.00  0.00           C  
ATOM   1551  C   SER A 102     -35.846  21.897 -12.016  0.00  0.00           C  
ATOM   1552  O   SER A 102     -35.479  21.175 -12.943  0.00  0.00           O  
ATOM   1553  CB  SER A 102     -34.320  23.710 -11.193  0.00  0.00           C  
ATOM   1554  OG  SER A 102     -35.337  24.683 -11.021  0.00  0.00           O  
ATOM   1555  H   SER A 102     -33.549  20.782 -11.584  0.00  0.00           H  
ATOM   1556  HA  SER A 102     -35.426  22.342  -9.962  0.00  0.00           H  
ATOM   1557  HB2 SER A 102     -33.503  23.927 -10.503  0.00  0.00           H  
ATOM   1558  HB3 SER A 102     -33.940  23.752 -12.215  0.00  0.00           H  
ATOM   1559  HG  SER A 102     -34.953  25.564 -11.190  0.00  0.00           H  
ATOM   1560  N   VAL A 103     -37.090  22.373 -11.946  0.00  0.00           N  
ATOM   1561  CA  VAL A 103     -38.146  22.163 -12.951  0.00  0.00           C  
ATOM   1562  C   VAL A 103     -39.008  23.428 -13.035  0.00  0.00           C  
ATOM   1563  O   VAL A 103     -39.297  24.064 -12.017  0.00  0.00           O  
ATOM   1564  CB  VAL A 103     -39.004  20.920 -12.608  0.00  0.00           C  
ATOM   1565  CG1 VAL A 103     -40.191  20.759 -13.557  0.00  0.00           C  
ATOM   1566  CG2 VAL A 103     -38.206  19.618 -12.695  0.00  0.00           C  
ATOM   1567  H   VAL A 103     -37.297  23.013 -11.191  0.00  0.00           H  
ATOM   1568  HA  VAL A 103     -37.694  22.004 -13.929  0.00  0.00           H  
ATOM   1569  HB  VAL A 103     -39.393  21.025 -11.596  0.00  0.00           H  
ATOM   1570 HG11 VAL A 103     -40.871  21.606 -13.478  0.00  0.00           H  
ATOM   1571 HG12 VAL A 103     -39.841  20.666 -14.587  0.00  0.00           H  
ATOM   1572 HG13 VAL A 103     -40.744  19.867 -13.275  0.00  0.00           H  
ATOM   1573 HG21 VAL A 103     -37.439  19.610 -11.923  0.00  0.00           H  
ATOM   1574 HG22 VAL A 103     -38.863  18.768 -12.530  0.00  0.00           H  
ATOM   1575 HG23 VAL A 103     -37.741  19.526 -13.676  0.00  0.00           H  
ATOM   1576  N   TRP A 104     -39.438  23.783 -14.247  0.00  0.00           N  
ATOM   1577  CA  TRP A 104     -40.265  24.951 -14.552  0.00  0.00           C  
ATOM   1578  C   TRP A 104     -41.332  24.593 -15.579  0.00  0.00           C  
ATOM   1579  O   TRP A 104     -41.086  23.836 -16.511  0.00  0.00           O  
ATOM   1580  CB  TRP A 104     -39.372  26.056 -15.133  0.00  0.00           C  
ATOM   1581  CG  TRP A 104     -40.019  27.395 -15.352  0.00  0.00           C  
ATOM   1582  CD1 TRP A 104     -40.019  28.384 -14.429  0.00  0.00           C  
ATOM   1583  CD2 TRP A 104     -40.698  27.952 -16.536  0.00  0.00           C  
ATOM   1584  NE1 TRP A 104     -40.604  29.514 -14.955  0.00  0.00           N  
ATOM   1585  CE2 TRP A 104     -40.966  29.328 -16.268  0.00  0.00           C  
ATOM   1586  CE3 TRP A 104     -41.114  27.476 -17.809  0.00  0.00           C  
ATOM   1587  CZ2 TRP A 104     -41.496  30.196 -17.228  0.00  0.00           C  
ATOM   1588  CZ3 TRP A 104     -41.674  28.353 -18.771  0.00  0.00           C  
ATOM   1589  CH2 TRP A 104     -41.825  29.712 -18.495  0.00  0.00           C  
ATOM   1590  H   TRP A 104     -39.183  23.196 -15.037  0.00  0.00           H  
ATOM   1591  HA  TRP A 104     -40.749  25.322 -13.648  0.00  0.00           H  
ATOM   1592  HB2 TRP A 104     -38.526  26.202 -14.461  0.00  0.00           H  
ATOM   1593  HB3 TRP A 104     -38.969  25.714 -16.084  0.00  0.00           H  
ATOM   1594  HD1 TRP A 104     -39.584  28.306 -13.436  0.00  0.00           H  
ATOM   1595  HE1 TRP A 104     -40.730  30.380 -14.443  0.00  0.00           H  
ATOM   1596  HE3 TRP A 104     -40.977  26.431 -18.050  0.00  0.00           H  
ATOM   1597  HZ2 TRP A 104     -41.681  31.226 -16.988  0.00  0.00           H  
ATOM   1598  HZ3 TRP A 104     -42.013  28.034 -19.745  0.00  0.00           H  
ATOM   1599  HH2 TRP A 104     -42.235  30.368 -19.248  0.00  0.00           H  
ATOM   1600  N   VAL A 105     -42.509  25.188 -15.461  0.00  0.00           N  
ATOM   1601  CA  VAL A 105     -43.575  25.125 -16.468  0.00  0.00           C  
ATOM   1602  C   VAL A 105     -44.242  26.498 -16.549  0.00  0.00           C  
ATOM   1603  O   VAL A 105     -44.220  27.270 -15.584  0.00  0.00           O  
ATOM   1604  CB  VAL A 105     -44.594  24.012 -16.156  0.00  0.00           C  
ATOM   1605  CG1 VAL A 105     -43.944  22.642 -15.956  0.00  0.00           C  
ATOM   1606  CG2 VAL A 105     -45.328  24.295 -14.858  0.00  0.00           C  
ATOM   1607  H   VAL A 105     -42.667  25.791 -14.669  0.00  0.00           H  
ATOM   1608  HA  VAL A 105     -43.139  24.912 -17.443  0.00  0.00           H  
ATOM   1609  HB  VAL A 105     -45.314  23.946 -16.971  0.00  0.00           H  
ATOM   1610 HG11 VAL A 105     -43.330  22.643 -15.056  0.00  0.00           H  
ATOM   1611 HG12 VAL A 105     -44.707  21.868 -15.890  0.00  0.00           H  
ATOM   1612 HG13 VAL A 105     -43.299  22.429 -16.794  0.00  0.00           H  
ATOM   1613 HG21 VAL A 105     -44.587  24.439 -14.074  0.00  0.00           H  
ATOM   1614 HG22 VAL A 105     -45.930  25.192 -14.982  0.00  0.00           H  
ATOM   1615 HG23 VAL A 105     -45.968  23.452 -14.610  0.00  0.00           H  
ATOM   1616  N   ALA A 106     -44.808  26.818 -17.709  0.00  0.00           N  
ATOM   1617  CA  ALA A 106     -45.286  28.174 -17.987  0.00  0.00           C  
ATOM   1618  C   ALA A 106     -46.684  28.487 -17.388  0.00  0.00           C  
ATOM   1619  O   ALA A 106     -47.237  27.689 -16.624  0.00  0.00           O  
ATOM   1620  CB  ALA A 106     -45.128  28.448 -19.481  0.00  0.00           C  
ATOM   1621  H   ALA A 106     -44.793  26.135 -18.454  0.00  0.00           H  
ATOM   1622  HA  ALA A 106     -44.596  28.862 -17.493  0.00  0.00           H  
ATOM   1623  HB1 ALA A 106     -46.048  28.219 -20.018  0.00  0.00           H  
ATOM   1624  HB2 ALA A 106     -44.844  29.494 -19.584  0.00  0.00           H  
ATOM   1625  HB3 ALA A 106     -44.313  27.856 -19.892  0.00  0.00           H  
ATOM   1626  N   ARG A 107     -47.270  29.650 -17.729  0.00  0.00           N  
ATOM   1627  CA  ARG A 107     -48.471  30.216 -17.066  0.00  0.00           C  
ATOM   1628  C   ARG A 107     -49.785  30.237 -17.862  0.00  0.00           C  
ATOM   1629  O   ARG A 107     -50.844  30.413 -17.259  0.00  0.00           O  
ATOM   1630  CB  ARG A 107     -48.126  31.637 -16.572  0.00  0.00           C  
ATOM   1631  CG  ARG A 107     -47.998  32.668 -17.714  0.00  0.00           C  
ATOM   1632  CD  ARG A 107     -49.001  33.821 -17.598  0.00  0.00           C  
ATOM   1633  NE  ARG A 107     -48.526  34.828 -16.638  0.00  0.00           N  
ATOM   1634  CZ  ARG A 107     -49.210  35.562 -15.789  0.00  0.00           C  
ATOM   1635  NH1 ARG A 107     -50.501  35.462 -15.633  0.00  0.00           N  
ATOM   1636  NH2 ARG A 107     -48.557  36.432 -15.079  0.00  0.00           N  
ATOM   1637  H   ARG A 107     -46.806  30.210 -18.433  0.00  0.00           H  
ATOM   1638  HA  ARG A 107     -48.687  29.620 -16.179  0.00  0.00           H  
ATOM   1639  HB2 ARG A 107     -48.893  31.956 -15.865  0.00  0.00           H  
ATOM   1640  HB3 ARG A 107     -47.183  31.602 -16.021  0.00  0.00           H  
ATOM   1641  HG2 ARG A 107     -46.990  33.072 -17.715  0.00  0.00           H  
ATOM   1642  HG3 ARG A 107     -48.147  32.195 -18.681  0.00  0.00           H  
ATOM   1643  HD2 ARG A 107     -49.094  34.297 -18.577  0.00  0.00           H  
ATOM   1644  HD3 ARG A 107     -49.979  33.425 -17.316  0.00  0.00           H  
ATOM   1645  HE  ARG A 107     -47.529  35.040 -16.651  0.00  0.00           H  
ATOM   1646 HH11 ARG A 107     -51.012  34.798 -16.190  0.00  0.00           H  
ATOM   1647 HH12 ARG A 107     -50.984  36.048 -14.974  0.00  0.00           H  
ATOM   1648 HH21 ARG A 107     -47.555  36.502 -15.253  0.00  0.00           H  
ATOM   1649 HH22 ARG A 107     -49.020  37.030 -14.418  0.00  0.00           H  
ATOM   1650  N   ASN A 108     -49.741  30.076 -19.185  0.00  0.00           N  
ATOM   1651  CA  ASN A 108     -50.886  30.237 -20.091  0.00  0.00           C  
ATOM   1652  C   ASN A 108     -51.139  28.902 -20.819  0.00  0.00           C  
ATOM   1653  O   ASN A 108     -50.266  28.507 -21.598  0.00  0.00           O  
ATOM   1654  CB  ASN A 108     -50.562  31.395 -21.058  0.00  0.00           C  
ATOM   1655  CG  ASN A 108     -51.657  31.624 -22.085  0.00  0.00           C  
ATOM   1656  OD1 ASN A 108     -52.541  32.452 -21.912  0.00  0.00           O  
ATOM   1657  ND2 ASN A 108     -51.650  30.887 -23.175  0.00  0.00           N  
ATOM   1658  H   ASN A 108     -48.829  29.960 -19.610  0.00  0.00           H  
ATOM   1659  HA  ASN A 108     -51.771  30.515 -19.520  0.00  0.00           H  
ATOM   1660  HB2 ASN A 108     -50.424  32.313 -20.486  0.00  0.00           H  
ATOM   1661  HB3 ASN A 108     -49.631  31.186 -21.585  0.00  0.00           H  
ATOM   1662 HD21 ASN A 108     -50.937  30.183 -23.305  0.00  0.00           H  
ATOM   1663 HD22 ASN A 108     -52.366  31.042 -23.868  0.00  0.00           H  
ATOM   1664  N   PRO A 109     -52.293  28.225 -20.580  0.00  0.00           N  
ATOM   1665  CA  PRO A 109     -52.637  26.849 -20.976  0.00  0.00           C  
ATOM   1666  C   PRO A 109     -51.515  26.009 -21.615  0.00  0.00           C  
ATOM   1667  O   PRO A 109     -51.612  25.625 -22.788  0.00  0.00           O  
ATOM   1668  CB  PRO A 109     -53.911  27.013 -21.801  0.00  0.00           C  
ATOM   1669  CG  PRO A 109     -54.660  28.036 -20.940  0.00  0.00           C  
ATOM   1670  CD  PRO A 109     -53.558  28.902 -20.313  0.00  0.00           C  
ATOM   1671  HA  PRO A 109     -52.921  26.319 -20.065  0.00  0.00           H  
ATOM   1672  HB2 PRO A 109     -53.681  27.439 -22.779  0.00  0.00           H  
ATOM   1673  HB3 PRO A 109     -54.464  26.078 -21.894  0.00  0.00           H  
ATOM   1674  HG2 PRO A 109     -55.343  28.634 -21.545  0.00  0.00           H  
ATOM   1675  HG3 PRO A 109     -55.211  27.519 -20.152  0.00  0.00           H  
ATOM   1676  HD2 PRO A 109     -53.573  29.886 -20.785  0.00  0.00           H  
ATOM   1677  HD3 PRO A 109     -53.724  29.002 -19.239  0.00  0.00           H  
ATOM   1678  N   PRO A 110     -50.431  25.730 -20.861  0.00  0.00           N  
ATOM   1679  CA  PRO A 110     -49.202  25.175 -21.413  0.00  0.00           C  
ATOM   1680  C   PRO A 110     -49.252  23.675 -21.714  0.00  0.00           C  
ATOM   1681  O   PRO A 110     -50.010  22.904 -21.129  0.00  0.00           O  
ATOM   1682  CB  PRO A 110     -48.134  25.481 -20.356  0.00  0.00           C  
ATOM   1683  CG  PRO A 110     -48.918  25.373 -19.052  0.00  0.00           C  
ATOM   1684  CD  PRO A 110     -50.274  25.966 -19.426  0.00  0.00           C  
ATOM   1685  HA  PRO A 110     -48.947  25.709 -22.331  0.00  0.00           H  
ATOM   1686  HB2 PRO A 110     -47.298  24.780 -20.383  0.00  0.00           H  
ATOM   1687  HB3 PRO A 110     -47.775  26.504 -20.483  0.00  0.00           H  
ATOM   1688  HG2 PRO A 110     -49.042  24.325 -18.788  0.00  0.00           H  
ATOM   1689  HG3 PRO A 110     -48.442  25.923 -18.242  0.00  0.00           H  
ATOM   1690  HD2 PRO A 110     -51.067  25.481 -18.856  0.00  0.00           H  
ATOM   1691  HD3 PRO A 110     -50.258  27.033 -19.214  0.00  0.00           H  
ATOM   1692  N   GLY A 111     -48.349  23.285 -22.608  0.00  0.00           N  
ATOM   1693  CA  GLY A 111     -47.953  21.917 -22.964  0.00  0.00           C  
ATOM   1694  C   GLY A 111     -46.474  21.931 -23.368  0.00  0.00           C  
ATOM   1695  O   GLY A 111     -46.048  21.255 -24.304  0.00  0.00           O  
ATOM   1696  H   GLY A 111     -47.842  24.028 -23.071  0.00  0.00           H  
ATOM   1697  HA2 GLY A 111     -48.058  21.271 -22.094  0.00  0.00           H  
ATOM   1698  HA3 GLY A 111     -48.560  21.544 -23.789  0.00  0.00           H  
ATOM   1699  N   PHE A 112     -45.729  22.794 -22.675  0.00  0.00           N  
ATOM   1700  CA  PHE A 112     -44.367  23.255 -22.914  0.00  0.00           C  
ATOM   1701  C   PHE A 112     -43.782  23.696 -21.555  0.00  0.00           C  
ATOM   1702  O   PHE A 112     -44.495  24.274 -20.727  0.00  0.00           O  
ATOM   1703  CB  PHE A 112     -44.471  24.385 -23.955  0.00  0.00           C  
ATOM   1704  CG  PHE A 112     -43.530  25.546 -23.771  0.00  0.00           C  
ATOM   1705  CD1 PHE A 112     -43.843  26.587 -22.875  0.00  0.00           C  
ATOM   1706  CD2 PHE A 112     -42.338  25.573 -24.501  0.00  0.00           C  
ATOM   1707  CE1 PHE A 112     -42.933  27.640 -22.691  0.00  0.00           C  
ATOM   1708  CE2 PHE A 112     -41.418  26.610 -24.300  0.00  0.00           C  
ATOM   1709  CZ  PHE A 112     -41.722  27.642 -23.401  0.00  0.00           C  
ATOM   1710  H   PHE A 112     -46.181  23.225 -21.878  0.00  0.00           H  
ATOM   1711  HA  PHE A 112     -43.745  22.458 -23.318  0.00  0.00           H  
ATOM   1712  HB2 PHE A 112     -44.277  23.945 -24.936  0.00  0.00           H  
ATOM   1713  HB3 PHE A 112     -45.484  24.794 -23.975  0.00  0.00           H  
ATOM   1714  HD1 PHE A 112     -44.772  26.571 -22.321  0.00  0.00           H  
ATOM   1715  HD2 PHE A 112     -42.120  24.783 -25.203  0.00  0.00           H  
ATOM   1716  HE1 PHE A 112     -43.154  28.437 -21.998  0.00  0.00           H  
ATOM   1717  HE2 PHE A 112     -40.474  26.594 -24.820  0.00  0.00           H  
ATOM   1718  HZ  PHE A 112     -41.015  28.433 -23.248  0.00  0.00           H  
ATOM   1719  N   ALA A 113     -42.508  23.391 -21.305  0.00  0.00           N  
ATOM   1720  CA  ALA A 113     -41.876  23.503 -19.995  0.00  0.00           C  
ATOM   1721  C   ALA A 113     -40.333  23.461 -20.069  0.00  0.00           C  
ATOM   1722  O   ALA A 113     -39.751  23.190 -21.124  0.00  0.00           O  
ATOM   1723  CB  ALA A 113     -42.404  22.300 -19.203  0.00  0.00           C  
ATOM   1724  H   ALA A 113     -41.954  22.934 -22.021  0.00  0.00           H  
ATOM   1725  HA  ALA A 113     -42.185  24.430 -19.504  0.00  0.00           H  
ATOM   1726  HB1 ALA A 113     -41.802  22.131 -18.312  0.00  0.00           H  
ATOM   1727  HB2 ALA A 113     -43.445  22.480 -18.934  0.00  0.00           H  
ATOM   1728  HB3 ALA A 113     -42.382  21.396 -19.804  0.00  0.00           H  
ATOM   1729  N   PHE A 114     -39.667  23.656 -18.924  0.00  0.00           N  
ATOM   1730  CA  PHE A 114     -38.195  23.557 -18.811  0.00  0.00           C  
ATOM   1731  C   PHE A 114     -37.741  22.758 -17.570  0.00  0.00           C  
ATOM   1732  O   PHE A 114     -38.511  22.493 -16.646  0.00  0.00           O  
ATOM   1733  CB  PHE A 114     -37.545  24.955 -18.873  0.00  0.00           C  
ATOM   1734  CG  PHE A 114     -37.782  25.707 -20.173  0.00  0.00           C  
ATOM   1735  CD1 PHE A 114     -37.133  25.310 -21.360  0.00  0.00           C  
ATOM   1736  CD2 PHE A 114     -38.672  26.798 -20.215  0.00  0.00           C  
ATOM   1737  CE1 PHE A 114     -37.384  25.982 -22.568  0.00  0.00           C  
ATOM   1738  CE2 PHE A 114     -38.978  27.411 -21.432  0.00  0.00           C  
ATOM   1739  CZ  PHE A 114     -38.329  27.017 -22.610  0.00  0.00           C  
ATOM   1740  H   PHE A 114     -40.226  23.772 -18.068  0.00  0.00           H  
ATOM   1741  HA  PHE A 114     -37.820  22.995 -19.669  0.00  0.00           H  
ATOM   1742  HB2 PHE A 114     -37.910  25.556 -18.042  0.00  0.00           H  
ATOM   1743  HB3 PHE A 114     -36.466  24.849 -18.746  0.00  0.00           H  
ATOM   1744  HD1 PHE A 114     -36.446  24.480 -21.360  0.00  0.00           H  
ATOM   1745  HD2 PHE A 114     -39.128  27.194 -19.326  0.00  0.00           H  
ATOM   1746  HE1 PHE A 114     -36.876  25.678 -23.470  0.00  0.00           H  
ATOM   1747  HE2 PHE A 114     -39.697  28.210 -21.445  0.00  0.00           H  
ATOM   1748  HZ  PHE A 114     -38.544  27.527 -23.536  0.00  0.00           H  
ATOM   1749  N   VAL A 115     -36.476  22.339 -17.554  0.00  0.00           N  
ATOM   1750  CA  VAL A 115     -35.926  21.378 -16.576  0.00  0.00           C  
ATOM   1751  C   VAL A 115     -34.417  21.586 -16.400  0.00  0.00           C  
ATOM   1752  O   VAL A 115     -33.732  22.078 -17.293  0.00  0.00           O  
ATOM   1753  CB  VAL A 115     -36.280  19.907 -16.977  0.00  0.00           C  
ATOM   1754  CG1 VAL A 115     -36.720  19.724 -18.440  0.00  0.00           C  
ATOM   1755  CG2 VAL A 115     -35.247  18.834 -16.609  0.00  0.00           C  
ATOM   1756  H   VAL A 115     -35.879  22.585 -18.338  0.00  0.00           H  
ATOM   1757  HA  VAL A 115     -36.374  21.563 -15.602  0.00  0.00           H  
ATOM   1758  HB  VAL A 115     -37.139  19.620 -16.385  0.00  0.00           H  
ATOM   1759 HG11 VAL A 115     -36.167  20.369 -19.109  0.00  0.00           H  
ATOM   1760 HG12 VAL A 115     -36.561  18.700 -18.764  0.00  0.00           H  
ATOM   1761 HG13 VAL A 115     -37.779  19.967 -18.524  0.00  0.00           H  
ATOM   1762 HG21 VAL A 115     -35.642  17.848 -16.851  0.00  0.00           H  
ATOM   1763 HG22 VAL A 115     -34.306  18.983 -17.128  0.00  0.00           H  
ATOM   1764 HG23 VAL A 115     -35.065  18.860 -15.538  0.00  0.00           H  
ATOM   1765  N   GLU A 116     -33.883  21.183 -15.251  0.00  0.00           N  
ATOM   1766  CA  GLU A 116     -32.454  21.089 -14.965  0.00  0.00           C  
ATOM   1767  C   GLU A 116     -32.187  19.861 -14.082  0.00  0.00           C  
ATOM   1768  O   GLU A 116     -32.822  19.694 -13.040  0.00  0.00           O  
ATOM   1769  CB  GLU A 116     -31.991  22.376 -14.268  0.00  0.00           C  
ATOM   1770  CG  GLU A 116     -30.468  22.428 -14.104  0.00  0.00           C  
ATOM   1771  CD  GLU A 116     -29.966  23.718 -13.419  0.00  0.00           C  
ATOM   1772  OE1 GLU A 116     -30.765  24.629 -13.102  0.00  0.00           O  
ATOM   1773  OE2 GLU A 116     -28.738  23.809 -13.186  0.00  0.00           O  
ATOM   1774  H   GLU A 116     -34.508  20.867 -14.514  0.00  0.00           H  
ATOM   1775  HA  GLU A 116     -31.912  20.978 -15.900  0.00  0.00           H  
ATOM   1776  HB2 GLU A 116     -32.313  23.232 -14.864  0.00  0.00           H  
ATOM   1777  HB3 GLU A 116     -32.461  22.437 -13.287  0.00  0.00           H  
ATOM   1778  HG2 GLU A 116     -30.148  21.573 -13.509  0.00  0.00           H  
ATOM   1779  HG3 GLU A 116     -30.009  22.337 -15.090  0.00  0.00           H  
ATOM   1780  N   PHE A 117     -31.244  19.007 -14.478  0.00  0.00           N  
ATOM   1781  CA  PHE A 117     -30.828  17.822 -13.713  0.00  0.00           C  
ATOM   1782  C   PHE A 117     -29.559  18.070 -12.874  0.00  0.00           C  
ATOM   1783  O   PHE A 117     -28.942  19.132 -12.967  0.00  0.00           O  
ATOM   1784  CB  PHE A 117     -30.671  16.643 -14.678  0.00  0.00           C  
ATOM   1785  CG  PHE A 117     -31.976  15.988 -15.107  0.00  0.00           C  
ATOM   1786  CD1 PHE A 117     -32.491  14.934 -14.333  0.00  0.00           C  
ATOM   1787  CD2 PHE A 117     -32.672  16.382 -16.271  0.00  0.00           C  
ATOM   1788  CE1 PHE A 117     -33.624  14.235 -14.763  0.00  0.00           C  
ATOM   1789  CE2 PHE A 117     -33.799  15.657 -16.709  0.00  0.00           C  
ATOM   1790  CZ  PHE A 117     -34.251  14.554 -15.964  0.00  0.00           C  
ATOM   1791  H   PHE A 117     -30.760  19.202 -15.347  0.00  0.00           H  
ATOM   1792  HA  PHE A 117     -31.606  17.560 -13.008  0.00  0.00           H  
ATOM   1793  HB2 PHE A 117     -30.111  16.971 -15.551  0.00  0.00           H  
ATOM   1794  HB3 PHE A 117     -30.067  15.875 -14.198  0.00  0.00           H  
ATOM   1795  HD1 PHE A 117     -32.020  14.638 -13.407  0.00  0.00           H  
ATOM   1796  HD2 PHE A 117     -32.351  17.237 -16.844  0.00  0.00           H  
ATOM   1797  HE1 PHE A 117     -34.026  13.435 -14.172  0.00  0.00           H  
ATOM   1798  HE2 PHE A 117     -34.320  15.957 -17.607  0.00  0.00           H  
ATOM   1799  HZ  PHE A 117     -35.111  13.959 -16.251  0.00  0.00           H  
ATOM   1800  N   GLU A 118     -29.156  17.110 -12.033  0.00  0.00           N  
ATOM   1801  CA  GLU A 118     -27.918  17.222 -11.246  0.00  0.00           C  
ATOM   1802  C   GLU A 118     -26.695  16.645 -11.986  0.00  0.00           C  
ATOM   1803  O   GLU A 118     -25.718  17.359 -12.211  0.00  0.00           O  
ATOM   1804  CB  GLU A 118     -28.125  16.566  -9.870  0.00  0.00           C  
ATOM   1805  CG  GLU A 118     -26.950  16.793  -8.906  0.00  0.00           C  
ATOM   1806  CD  GLU A 118     -26.610  18.288  -8.741  0.00  0.00           C  
ATOM   1807  OE1 GLU A 118     -27.499  19.100  -8.402  0.00  0.00           O  
ATOM   1808  OE2 GLU A 118     -25.457  18.688  -9.027  0.00  0.00           O  
ATOM   1809  H   GLU A 118     -29.717  16.269 -11.933  0.00  0.00           H  
ATOM   1810  HA  GLU A 118     -27.715  18.279 -11.078  0.00  0.00           H  
ATOM   1811  HB2 GLU A 118     -29.028  16.981  -9.416  0.00  0.00           H  
ATOM   1812  HB3 GLU A 118     -28.278  15.492  -9.995  0.00  0.00           H  
ATOM   1813  HG2 GLU A 118     -27.207  16.369  -7.933  0.00  0.00           H  
ATOM   1814  HG3 GLU A 118     -26.080  16.249  -9.281  0.00  0.00           H  
ATOM   1815  N   ASP A 119     -26.756  15.384 -12.423  0.00  0.00           N  
ATOM   1816  CA  ASP A 119     -25.761  14.763 -13.310  0.00  0.00           C  
ATOM   1817  C   ASP A 119     -26.151  15.045 -14.781  0.00  0.00           C  
ATOM   1818  O   ASP A 119     -27.301  14.780 -15.150  0.00  0.00           O  
ATOM   1819  CB  ASP A 119     -25.741  13.249 -13.011  0.00  0.00           C  
ATOM   1820  CG  ASP A 119     -24.707  12.403 -13.775  0.00  0.00           C  
ATOM   1821  OD1 ASP A 119     -24.074  12.902 -14.728  0.00  0.00           O  
ATOM   1822  OD2 ASP A 119     -24.568  11.198 -13.454  0.00  0.00           O  
ATOM   1823  H   ASP A 119     -27.590  14.848 -12.226  0.00  0.00           H  
ATOM   1824  HA  ASP A 119     -24.775  15.173 -13.097  0.00  0.00           H  
ATOM   1825  HB2 ASP A 119     -25.572  13.116 -11.940  0.00  0.00           H  
ATOM   1826  HB3 ASP A 119     -26.719  12.847 -13.252  0.00  0.00           H  
ATOM   1827  N   PRO A 120     -25.249  15.525 -15.664  0.00  0.00           N  
ATOM   1828  CA  PRO A 120     -25.575  15.706 -17.082  0.00  0.00           C  
ATOM   1829  C   PRO A 120     -25.940  14.384 -17.776  0.00  0.00           C  
ATOM   1830  O   PRO A 120     -26.665  14.392 -18.771  0.00  0.00           O  
ATOM   1831  CB  PRO A 120     -24.350  16.383 -17.706  0.00  0.00           C  
ATOM   1832  CG  PRO A 120     -23.207  15.963 -16.786  0.00  0.00           C  
ATOM   1833  CD  PRO A 120     -23.871  15.921 -15.412  0.00  0.00           C  
ATOM   1834  HA  PRO A 120     -26.431  16.376 -17.172  0.00  0.00           H  
ATOM   1835  HB2 PRO A 120     -24.180  16.065 -18.736  0.00  0.00           H  
ATOM   1836  HB3 PRO A 120     -24.472  17.467 -17.662  0.00  0.00           H  
ATOM   1837  HG2 PRO A 120     -22.864  14.964 -17.058  0.00  0.00           H  
ATOM   1838  HG3 PRO A 120     -22.380  16.671 -16.814  0.00  0.00           H  
ATOM   1839  HD2 PRO A 120     -23.345  15.228 -14.761  0.00  0.00           H  
ATOM   1840  HD3 PRO A 120     -23.858  16.914 -14.970  0.00  0.00           H  
ATOM   1841  N   ARG A 121     -25.510  13.236 -17.232  0.00  0.00           N  
ATOM   1842  CA  ARG A 121     -25.924  11.897 -17.674  0.00  0.00           C  
ATOM   1843  C   ARG A 121     -27.376  11.559 -17.291  0.00  0.00           C  
ATOM   1844  O   ARG A 121     -28.020  10.809 -18.022  0.00  0.00           O  
ATOM   1845  CB  ARG A 121     -24.918  10.879 -17.115  0.00  0.00           C  
ATOM   1846  CG  ARG A 121     -24.957   9.482 -17.761  0.00  0.00           C  
ATOM   1847  CD  ARG A 121     -25.161   8.363 -16.727  0.00  0.00           C  
ATOM   1848  NE  ARG A 121     -26.579   8.224 -16.363  0.00  0.00           N  
ATOM   1849  CZ  ARG A 121     -27.231   8.739 -15.342  0.00  0.00           C  
ATOM   1850  NH1 ARG A 121     -26.702   9.447 -14.388  0.00  0.00           N  
ATOM   1851  NH2 ARG A 121     -28.512   8.569 -15.275  0.00  0.00           N  
ATOM   1852  H   ARG A 121     -24.906  13.296 -16.411  0.00  0.00           H  
ATOM   1853  HA  ARG A 121     -25.868  11.865 -18.762  0.00  0.00           H  
ATOM   1854  HB2 ARG A 121     -23.910  11.273 -17.262  0.00  0.00           H  
ATOM   1855  HB3 ARG A 121     -25.071  10.794 -16.043  0.00  0.00           H  
ATOM   1856  HG2 ARG A 121     -25.736   9.425 -18.522  0.00  0.00           H  
ATOM   1857  HG3 ARG A 121     -24.002   9.312 -18.259  0.00  0.00           H  
ATOM   1858  HD2 ARG A 121     -24.834   7.423 -17.175  0.00  0.00           H  
ATOM   1859  HD3 ARG A 121     -24.542   8.545 -15.847  0.00  0.00           H  
ATOM   1860  HE  ARG A 121     -27.184   7.752 -17.032  0.00  0.00           H  
ATOM   1861 HH11 ARG A 121     -25.727   9.707 -14.365  0.00  0.00           H  
ATOM   1862 HH12 ARG A 121     -27.360   9.890 -13.750  0.00  0.00           H  
ATOM   1863 HH21 ARG A 121     -28.966   8.088 -16.050  0.00  0.00           H  
ATOM   1864 HH22 ARG A 121     -29.024   9.076 -14.559  0.00  0.00           H  
ATOM   1865  N   ASP A 122     -27.931  12.141 -16.218  0.00  0.00           N  
ATOM   1866  CA  ASP A 122     -29.373  12.028 -15.923  0.00  0.00           C  
ATOM   1867  C   ASP A 122     -30.193  12.763 -16.990  0.00  0.00           C  
ATOM   1868  O   ASP A 122     -31.125  12.185 -17.549  0.00  0.00           O  
ATOM   1869  CB  ASP A 122     -29.762  12.593 -14.544  0.00  0.00           C  
ATOM   1870  CG  ASP A 122     -29.205  11.833 -13.334  0.00  0.00           C  
ATOM   1871  OD1 ASP A 122     -28.985  10.604 -13.430  0.00  0.00           O  
ATOM   1872  OD2 ASP A 122     -29.029  12.460 -12.265  0.00  0.00           O  
ATOM   1873  H   ASP A 122     -27.388  12.824 -15.705  0.00  0.00           H  
ATOM   1874  HA  ASP A 122     -29.667  10.978 -15.955  0.00  0.00           H  
ATOM   1875  HB2 ASP A 122     -29.469  13.639 -14.488  0.00  0.00           H  
ATOM   1876  HB3 ASP A 122     -30.850  12.559 -14.471  0.00  0.00           H  
ATOM   1877  N   ALA A 123     -29.799  14.000 -17.332  0.00  0.00           N  
ATOM   1878  CA  ALA A 123     -30.392  14.739 -18.445  0.00  0.00           C  
ATOM   1879  C   ALA A 123     -30.256  13.983 -19.774  0.00  0.00           C  
ATOM   1880  O   ALA A 123     -31.233  13.874 -20.508  0.00  0.00           O  
ATOM   1881  CB  ALA A 123     -29.765  16.134 -18.543  0.00  0.00           C  
ATOM   1882  H   ALA A 123     -29.030  14.418 -16.826  0.00  0.00           H  
ATOM   1883  HA  ALA A 123     -31.460  14.858 -18.252  0.00  0.00           H  
ATOM   1884  HB1 ALA A 123     -28.680  16.067 -18.592  0.00  0.00           H  
ATOM   1885  HB2 ALA A 123     -30.129  16.629 -19.445  0.00  0.00           H  
ATOM   1886  HB3 ALA A 123     -30.056  16.735 -17.687  0.00  0.00           H  
ATOM   1887  N   ALA A 124     -29.079  13.425 -20.075  0.00  0.00           N  
ATOM   1888  CA  ALA A 124     -28.852  12.662 -21.301  0.00  0.00           C  
ATOM   1889  C   ALA A 124     -29.753  11.419 -21.399  0.00  0.00           C  
ATOM   1890  O   ALA A 124     -30.425  11.242 -22.415  0.00  0.00           O  
ATOM   1891  CB  ALA A 124     -27.374  12.279 -21.389  0.00  0.00           C  
ATOM   1892  H   ALA A 124     -28.288  13.598 -19.464  0.00  0.00           H  
ATOM   1893  HA  ALA A 124     -29.089  13.306 -22.149  0.00  0.00           H  
ATOM   1894  HB1 ALA A 124     -26.750  13.169 -21.308  0.00  0.00           H  
ATOM   1895  HB2 ALA A 124     -27.126  11.578 -20.593  0.00  0.00           H  
ATOM   1896  HB3 ALA A 124     -27.185  11.799 -22.351  0.00  0.00           H  
ATOM   1897  N   ASP A 125     -29.823  10.589 -20.351  0.00  0.00           N  
ATOM   1898  CA  ASP A 125     -30.700   9.406 -20.317  0.00  0.00           C  
ATOM   1899  C   ASP A 125     -32.181   9.795 -20.449  0.00  0.00           C  
ATOM   1900  O   ASP A 125     -32.929   9.175 -21.214  0.00  0.00           O  
ATOM   1901  CB  ASP A 125     -30.504   8.623 -19.007  0.00  0.00           C  
ATOM   1902  CG  ASP A 125     -29.189   7.832 -18.907  0.00  0.00           C  
ATOM   1903  OD1 ASP A 125     -28.503   7.595 -19.931  0.00  0.00           O  
ATOM   1904  OD2 ASP A 125     -28.865   7.393 -17.778  0.00  0.00           O  
ATOM   1905  H   ASP A 125     -29.244  10.780 -19.539  0.00  0.00           H  
ATOM   1906  HA  ASP A 125     -30.459   8.754 -21.159  0.00  0.00           H  
ATOM   1907  HB2 ASP A 125     -30.581   9.313 -18.164  0.00  0.00           H  
ATOM   1908  HB3 ASP A 125     -31.323   7.906 -18.917  0.00  0.00           H  
ATOM   1909  N   ALA A 126     -32.591  10.855 -19.742  0.00  0.00           N  
ATOM   1910  CA  ALA A 126     -33.948  11.377 -19.801  0.00  0.00           C  
ATOM   1911  C   ALA A 126     -34.285  11.829 -21.227  0.00  0.00           C  
ATOM   1912  O   ALA A 126     -35.212  11.296 -21.826  0.00  0.00           O  
ATOM   1913  CB  ALA A 126     -34.101  12.501 -18.770  0.00  0.00           C  
ATOM   1914  H   ALA A 126     -31.913  11.349 -19.172  0.00  0.00           H  
ATOM   1915  HA  ALA A 126     -34.639  10.576 -19.540  0.00  0.00           H  
ATOM   1916  HB1 ALA A 126     -33.859  12.126 -17.776  0.00  0.00           H  
ATOM   1917  HB2 ALA A 126     -33.439  13.335 -19.007  0.00  0.00           H  
ATOM   1918  HB3 ALA A 126     -35.129  12.851 -18.765  0.00  0.00           H  
ATOM   1919  N   VAL A 127     -33.482  12.720 -21.819  0.00  0.00           N  
ATOM   1920  CA  VAL A 127     -33.617  13.177 -23.213  0.00  0.00           C  
ATOM   1921  C   VAL A 127     -33.681  12.000 -24.197  0.00  0.00           C  
ATOM   1922  O   VAL A 127     -34.506  12.018 -25.114  0.00  0.00           O  
ATOM   1923  CB  VAL A 127     -32.462  14.143 -23.560  0.00  0.00           C  
ATOM   1924  CG1 VAL A 127     -32.318  14.433 -25.060  0.00  0.00           C  
ATOM   1925  CG2 VAL A 127     -32.651  15.502 -22.870  0.00  0.00           C  
ATOM   1926  H   VAL A 127     -32.694  13.075 -21.283  0.00  0.00           H  
ATOM   1927  HA  VAL A 127     -34.555  13.723 -23.312  0.00  0.00           H  
ATOM   1928  HB  VAL A 127     -31.529  13.701 -23.208  0.00  0.00           H  
ATOM   1929 HG11 VAL A 127     -31.547  15.188 -25.220  0.00  0.00           H  
ATOM   1930 HG12 VAL A 127     -32.020  13.531 -25.594  0.00  0.00           H  
ATOM   1931 HG13 VAL A 127     -33.263  14.797 -25.464  0.00  0.00           H  
ATOM   1932 HG21 VAL A 127     -33.470  16.051 -23.331  0.00  0.00           H  
ATOM   1933 HG22 VAL A 127     -32.871  15.372 -21.811  0.00  0.00           H  
ATOM   1934 HG23 VAL A 127     -31.739  16.090 -22.963  0.00  0.00           H  
ATOM   1935  N   ARG A 128     -32.863  10.954 -23.999  0.00  0.00           N  
ATOM   1936  CA  ARG A 128     -32.827   9.778 -24.885  0.00  0.00           C  
ATOM   1937  C   ARG A 128     -34.046   8.857 -24.786  0.00  0.00           C  
ATOM   1938  O   ARG A 128     -34.276   8.111 -25.738  0.00  0.00           O  
ATOM   1939  CB  ARG A 128     -31.531   8.957 -24.715  0.00  0.00           C  
ATOM   1940  CG  ARG A 128     -30.568   9.060 -25.910  0.00  0.00           C  
ATOM   1941  CD  ARG A 128     -31.148   8.555 -27.250  0.00  0.00           C  
ATOM   1942  NE  ARG A 128     -31.589   9.663 -28.130  0.00  0.00           N  
ATOM   1943  CZ  ARG A 128     -32.814   9.952 -28.538  0.00  0.00           C  
ATOM   1944  NH1 ARG A 128     -33.860   9.258 -28.209  0.00  0.00           N  
ATOM   1945  NH2 ARG A 128     -33.046  10.995 -29.276  0.00  0.00           N  
ATOM   1946  H   ARG A 128     -32.219  10.998 -23.217  0.00  0.00           H  
ATOM   1947  HA  ARG A 128     -32.858  10.167 -25.896  0.00  0.00           H  
ATOM   1948  HB2 ARG A 128     -31.004   9.266 -23.815  0.00  0.00           H  
ATOM   1949  HB3 ARG A 128     -31.777   7.903 -24.575  0.00  0.00           H  
ATOM   1950  HG2 ARG A 128     -30.225  10.091 -26.018  0.00  0.00           H  
ATOM   1951  HG3 ARG A 128     -29.695   8.448 -25.676  0.00  0.00           H  
ATOM   1952  HD2 ARG A 128     -30.360   8.012 -27.774  0.00  0.00           H  
ATOM   1953  HD3 ARG A 128     -31.954   7.843 -27.061  0.00  0.00           H  
ATOM   1954  HE  ARG A 128     -30.863  10.276 -28.468  0.00  0.00           H  
ATOM   1955 HH11 ARG A 128     -33.786   8.541 -27.501  0.00  0.00           H  
ATOM   1956 HH12 ARG A 128     -34.783   9.656 -28.375  0.00  0.00           H  
ATOM   1957 HH21 ARG A 128     -32.302  11.605 -29.569  0.00  0.00           H  
ATOM   1958 HH22 ARG A 128     -34.021  11.226 -29.467  0.00  0.00           H  
ATOM   1959  N   GLU A 129     -34.825   8.888 -23.703  0.00  0.00           N  
ATOM   1960  CA  GLU A 129     -36.010   8.021 -23.540  0.00  0.00           C  
ATOM   1961  C   GLU A 129     -37.322   8.753 -23.177  0.00  0.00           C  
ATOM   1962  O   GLU A 129     -38.317   8.116 -22.824  0.00  0.00           O  
ATOM   1963  CB  GLU A 129     -35.662   6.821 -22.633  0.00  0.00           C  
ATOM   1964  CG  GLU A 129     -34.917   5.702 -23.385  0.00  0.00           C  
ATOM   1965  CD  GLU A 129     -35.809   5.061 -24.470  0.00  0.00           C  
ATOM   1966  OE1 GLU A 129     -36.686   4.225 -24.151  0.00  0.00           O  
ATOM   1967  OE2 GLU A 129     -35.705   5.428 -25.663  0.00  0.00           O  
ATOM   1968  H   GLU A 129     -34.491   9.422 -22.902  0.00  0.00           H  
ATOM   1969  HA  GLU A 129     -36.247   7.612 -24.514  0.00  0.00           H  
ATOM   1970  HB2 GLU A 129     -35.050   7.164 -21.792  0.00  0.00           H  
ATOM   1971  HB3 GLU A 129     -36.571   6.387 -22.222  0.00  0.00           H  
ATOM   1972  HG2 GLU A 129     -33.999   6.103 -23.822  0.00  0.00           H  
ATOM   1973  HG3 GLU A 129     -34.622   4.938 -22.661  0.00  0.00           H  
ATOM   1974  N   LEU A 130     -37.358  10.076 -23.368  0.00  0.00           N  
ATOM   1975  CA  LEU A 130     -38.538  10.941 -23.231  0.00  0.00           C  
ATOM   1976  C   LEU A 130     -39.032  11.542 -24.564  0.00  0.00           C  
ATOM   1977  O   LEU A 130     -40.088  12.169 -24.589  0.00  0.00           O  
ATOM   1978  CB  LEU A 130     -38.178  12.120 -22.305  0.00  0.00           C  
ATOM   1979  CG  LEU A 130     -38.231  11.870 -20.792  0.00  0.00           C  
ATOM   1980  CD1 LEU A 130     -37.711  13.101 -20.084  0.00  0.00           C  
ATOM   1981  CD2 LEU A 130     -39.670  11.696 -20.302  0.00  0.00           C  
ATOM   1982  H   LEU A 130     -36.480  10.533 -23.576  0.00  0.00           H  
ATOM   1983  HA  LEU A 130     -39.368  10.382 -22.803  0.00  0.00           H  
ATOM   1984  HB2 LEU A 130     -37.187  12.484 -22.577  0.00  0.00           H  
ATOM   1985  HB3 LEU A 130     -38.866  12.942 -22.495  0.00  0.00           H  
ATOM   1986  HG  LEU A 130     -37.590  11.045 -20.492  0.00  0.00           H  
ATOM   1987 HD11 LEU A 130     -36.706  13.331 -20.430  0.00  0.00           H  
ATOM   1988 HD12 LEU A 130     -38.371  13.941 -20.295  0.00  0.00           H  
ATOM   1989 HD13 LEU A 130     -37.688  12.905 -19.013  0.00  0.00           H  
ATOM   1990 HD21 LEU A 130     -40.070  10.745 -20.648  0.00  0.00           H  
ATOM   1991 HD22 LEU A 130     -39.698  11.728 -19.215  0.00  0.00           H  
ATOM   1992 HD23 LEU A 130     -40.285  12.516 -20.674  0.00  0.00           H  
ATOM   1993  N   ASP A 131     -38.294  11.383 -25.666  0.00  0.00           N  
ATOM   1994  CA  ASP A 131     -38.529  12.113 -26.917  0.00  0.00           C  
ATOM   1995  C   ASP A 131     -39.427  11.433 -27.972  0.00  0.00           C  
ATOM   1996  O   ASP A 131     -39.471  10.211 -28.101  0.00  0.00           O  
ATOM   1997  CB  ASP A 131     -37.167  12.445 -27.544  0.00  0.00           C  
ATOM   1998  CG  ASP A 131     -36.439  11.228 -28.144  0.00  0.00           C  
ATOM   1999  OD1 ASP A 131     -36.464  10.115 -27.567  0.00  0.00           O  
ATOM   2000  OD2 ASP A 131     -35.778  11.379 -29.196  0.00  0.00           O  
ATOM   2001  H   ASP A 131     -37.472  10.797 -25.619  0.00  0.00           H  
ATOM   2002  HA  ASP A 131     -38.989  13.064 -26.656  0.00  0.00           H  
ATOM   2003  HB2 ASP A 131     -37.331  13.184 -28.331  0.00  0.00           H  
ATOM   2004  HB3 ASP A 131     -36.530  12.915 -26.793  0.00  0.00           H  
ATOM   2005  N   GLY A 132     -40.098  12.262 -28.776  0.00  0.00           N  
ATOM   2006  CA  GLY A 132     -40.830  11.908 -30.001  0.00  0.00           C  
ATOM   2007  C   GLY A 132     -41.956  10.870 -29.904  0.00  0.00           C  
ATOM   2008  O   GLY A 132     -42.277  10.252 -30.923  0.00  0.00           O  
ATOM   2009  H   GLY A 132     -40.091  13.244 -28.520  0.00  0.00           H  
ATOM   2010  HA2 GLY A 132     -41.273  12.820 -30.401  0.00  0.00           H  
ATOM   2011  HA3 GLY A 132     -40.110  11.544 -30.733  0.00  0.00           H  
ATOM   2012  N   ARG A 133     -42.544  10.645 -28.717  0.00  0.00           N  
ATOM   2013  CA  ARG A 133     -43.468   9.523 -28.462  0.00  0.00           C  
ATOM   2014  C   ARG A 133     -44.806   9.926 -27.831  0.00  0.00           C  
ATOM   2015  O   ARG A 133     -45.822   9.880 -28.519  0.00  0.00           O  
ATOM   2016  CB  ARG A 133     -42.718   8.483 -27.609  0.00  0.00           C  
ATOM   2017  CG  ARG A 133     -41.705   7.674 -28.434  0.00  0.00           C  
ATOM   2018  CD  ARG A 133     -40.781   6.864 -27.517  0.00  0.00           C  
ATOM   2019  NE  ARG A 133     -39.459   7.501 -27.340  0.00  0.00           N  
ATOM   2020  CZ  ARG A 133     -38.373   6.919 -26.866  0.00  0.00           C  
ATOM   2021  NH1 ARG A 133     -38.388   5.714 -26.375  0.00  0.00           N  
ATOM   2022  NH2 ARG A 133     -37.218   7.510 -26.862  0.00  0.00           N  
ATOM   2023  H   ARG A 133     -42.199  11.174 -27.929  0.00  0.00           H  
ATOM   2024  HA  ARG A 133     -43.740   9.043 -29.405  0.00  0.00           H  
ATOM   2025  HB2 ARG A 133     -42.202   8.990 -26.791  0.00  0.00           H  
ATOM   2026  HB3 ARG A 133     -43.435   7.782 -27.176  0.00  0.00           H  
ATOM   2027  HG2 ARG A 133     -42.255   6.987 -29.077  0.00  0.00           H  
ATOM   2028  HG3 ARG A 133     -41.106   8.322 -29.071  0.00  0.00           H  
ATOM   2029  HD2 ARG A 133     -41.262   6.745 -26.546  0.00  0.00           H  
ATOM   2030  HD3 ARG A 133     -40.643   5.882 -27.969  0.00  0.00           H  
ATOM   2031  HE  ARG A 133     -39.359   8.461 -27.657  0.00  0.00           H  
ATOM   2032 HH11 ARG A 133     -39.249   5.206 -26.309  0.00  0.00           H  
ATOM   2033 HH12 ARG A 133     -37.517   5.324 -26.017  0.00  0.00           H  
ATOM   2034 HH21 ARG A 133     -37.098   8.469 -27.199  0.00  0.00           H  
ATOM   2035 HH22 ARG A 133     -36.418   6.980 -26.526  0.00  0.00           H  
ATOM   2036  N   THR A 134     -44.796  10.290 -26.546  0.00  0.00           N  
ATOM   2037  CA  THR A 134     -45.923  10.532 -25.607  0.00  0.00           C  
ATOM   2038  C   THR A 134     -45.350  10.560 -24.182  0.00  0.00           C  
ATOM   2039  O   THR A 134     -44.424   9.804 -23.881  0.00  0.00           O  
ATOM   2040  CB  THR A 134     -47.010   9.420 -25.659  0.00  0.00           C  
ATOM   2041  OG1 THR A 134     -47.810   9.520 -26.812  0.00  0.00           O  
ATOM   2042  CG2 THR A 134     -48.035   9.451 -24.517  0.00  0.00           C  
ATOM   2043  H   THR A 134     -43.882  10.392 -26.135  0.00  0.00           H  
ATOM   2044  HA  THR A 134     -46.382  11.494 -25.824  0.00  0.00           H  
ATOM   2045  HB  THR A 134     -46.518   8.445 -25.654  0.00  0.00           H  
ATOM   2046  HG1 THR A 134     -47.202   9.686 -27.560  0.00  0.00           H  
ATOM   2047 HG21 THR A 134     -48.825   8.723 -24.712  0.00  0.00           H  
ATOM   2048 HG22 THR A 134     -47.565   9.179 -23.572  0.00  0.00           H  
ATOM   2049 HG23 THR A 134     -48.480  10.442 -24.437  0.00  0.00           H  
ATOM   2050  N   LEU A 135     -45.908  11.392 -23.292  0.00  0.00           N  
ATOM   2051  CA  LEU A 135     -45.612  11.324 -21.847  0.00  0.00           C  
ATOM   2052  C   LEU A 135     -46.863  11.651 -21.017  0.00  0.00           C  
ATOM   2053  O   LEU A 135     -47.403  10.758 -20.364  0.00  0.00           O  
ATOM   2054  CB  LEU A 135     -44.387  12.202 -21.503  0.00  0.00           C  
ATOM   2055  CG  LEU A 135     -43.746  12.033 -20.108  0.00  0.00           C  
ATOM   2056  CD1 LEU A 135     -44.605  12.571 -18.962  0.00  0.00           C  
ATOM   2057  CD2 LEU A 135     -43.375  10.580 -19.805  0.00  0.00           C  
ATOM   2058  H   LEU A 135     -46.644  12.009 -23.615  0.00  0.00           H  
ATOM   2059  HA  LEU A 135     -45.356  10.292 -21.613  0.00  0.00           H  
ATOM   2060  HB2 LEU A 135     -43.606  11.979 -22.231  0.00  0.00           H  
ATOM   2061  HB3 LEU A 135     -44.650  13.248 -21.631  0.00  0.00           H  
ATOM   2062  HG  LEU A 135     -42.823  12.613 -20.113  0.00  0.00           H  
ATOM   2063 HD11 LEU A 135     -44.006  12.615 -18.055  0.00  0.00           H  
ATOM   2064 HD12 LEU A 135     -44.945  13.578 -19.192  0.00  0.00           H  
ATOM   2065 HD13 LEU A 135     -45.460  11.924 -18.776  0.00  0.00           H  
ATOM   2066 HD21 LEU A 135     -42.775  10.178 -20.621  0.00  0.00           H  
ATOM   2067 HD22 LEU A 135     -42.792  10.535 -18.888  0.00  0.00           H  
ATOM   2068 HD23 LEU A 135     -44.270   9.972 -19.680  0.00  0.00           H  
ATOM   2069  N   CYS A 136     -47.374  12.887 -21.100  0.00  0.00           N  
ATOM   2070  CA  CYS A 136     -48.673  13.248 -20.520  0.00  0.00           C  
ATOM   2071  C   CYS A 136     -49.817  12.907 -21.494  0.00  0.00           C  
ATOM   2072  O   CYS A 136     -50.786  12.251 -21.100  0.00  0.00           O  
ATOM   2073  CB  CYS A 136     -48.657  14.729 -20.116  0.00  0.00           C  
ATOM   2074  SG  CYS A 136     -50.100  15.113 -19.086  0.00  0.00           S  
ATOM   2075  H   CYS A 136     -46.871  13.584 -21.627  0.00  0.00           H  
ATOM   2076  HA  CYS A 136     -48.835  12.659 -19.615  0.00  0.00           H  
ATOM   2077  HB2 CYS A 136     -47.760  14.931 -19.529  0.00  0.00           H  
ATOM   2078  HB3 CYS A 136     -48.657  15.362 -21.003  0.00  0.00           H  
ATOM   2079  HG  CYS A 136     -49.831  14.210 -18.124  0.00  0.00           H  
ATOM   2080  N   GLY A 137     -49.681  13.266 -22.782  0.00  0.00           N  
ATOM   2081  CA  GLY A 137     -50.654  12.866 -23.810  0.00  0.00           C  
ATOM   2082  C   GLY A 137     -50.493  13.539 -25.177  0.00  0.00           C  
ATOM   2083  O   GLY A 137     -51.465  14.072 -25.716  0.00  0.00           O  
ATOM   2084  H   GLY A 137     -48.945  13.921 -23.030  0.00  0.00           H  
ATOM   2085  HA2 GLY A 137     -50.581  11.788 -23.959  0.00  0.00           H  
ATOM   2086  HA3 GLY A 137     -51.650  13.083 -23.442  0.00  0.00           H  
ATOM   2087  N   CYS A 138     -49.269  13.571 -25.715  0.00  0.00           N  
ATOM   2088  CA  CYS A 138     -48.931  14.282 -26.956  0.00  0.00           C  
ATOM   2089  C   CYS A 138     -47.712  13.640 -27.664  0.00  0.00           C  
ATOM   2090  O   CYS A 138     -47.688  12.418 -27.800  0.00  0.00           O  
ATOM   2091  CB  CYS A 138     -48.742  15.752 -26.581  0.00  0.00           C  
ATOM   2092  SG  CYS A 138     -48.916  16.832 -28.033  0.00  0.00           S  
ATOM   2093  H   CYS A 138     -48.532  13.070 -25.246  0.00  0.00           H  
ATOM   2094  HA  CYS A 138     -49.773  14.210 -27.647  0.00  0.00           H  
ATOM   2095  HB2 CYS A 138     -49.476  16.036 -25.827  0.00  0.00           H  
ATOM   2096  HB3 CYS A 138     -47.770  15.862 -26.115  0.00  0.00           H  
ATOM   2097  HG  CYS A 138     -50.226  16.610 -28.245  0.00  0.00           H  
ATOM   2098  N   ARG A 139     -46.711  14.413 -28.131  0.00  0.00           N  
ATOM   2099  CA  ARG A 139     -45.606  13.924 -28.997  0.00  0.00           C  
ATOM   2100  C   ARG A 139     -44.185  14.215 -28.500  0.00  0.00           C  
ATOM   2101  O   ARG A 139     -43.214  13.747 -29.086  0.00  0.00           O  
ATOM   2102  CB  ARG A 139     -45.788  14.452 -30.432  0.00  0.00           C  
ATOM   2103  CG  ARG A 139     -47.225  14.311 -30.971  0.00  0.00           C  
ATOM   2104  CD  ARG A 139     -47.383  14.732 -32.441  0.00  0.00           C  
ATOM   2105  NE  ARG A 139     -46.668  15.977 -32.806  0.00  0.00           N  
ATOM   2106  CZ  ARG A 139     -46.815  17.193 -32.306  0.00  0.00           C  
ATOM   2107  NH1 ARG A 139     -47.695  17.496 -31.399  0.00  0.00           N  
ATOM   2108  NH2 ARG A 139     -46.044  18.163 -32.699  0.00  0.00           N  
ATOM   2109  H   ARG A 139     -46.813  15.418 -28.017  0.00  0.00           H  
ATOM   2110  HA  ARG A 139     -45.653  12.840 -29.022  0.00  0.00           H  
ATOM   2111  HB2 ARG A 139     -45.506  15.506 -30.439  0.00  0.00           H  
ATOM   2112  HB3 ARG A 139     -45.109  13.913 -31.095  0.00  0.00           H  
ATOM   2113  HG2 ARG A 139     -47.541  13.272 -30.875  0.00  0.00           H  
ATOM   2114  HG3 ARG A 139     -47.899  14.922 -30.374  0.00  0.00           H  
ATOM   2115  HD2 ARG A 139     -46.999  13.920 -33.060  0.00  0.00           H  
ATOM   2116  HD3 ARG A 139     -48.447  14.839 -32.657  0.00  0.00           H  
ATOM   2117  HE  ARG A 139     -45.962  15.883 -33.519  0.00  0.00           H  
ATOM   2118 HH11 ARG A 139     -48.340  16.799 -31.072  0.00  0.00           H  
ATOM   2119 HH12 ARG A 139     -47.713  18.435 -31.026  0.00  0.00           H  
ATOM   2120 HH21 ARG A 139     -45.339  18.011 -33.401  0.00  0.00           H  
ATOM   2121 HH22 ARG A 139     -46.143  19.067 -32.256  0.00  0.00           H  
ATOM   2122  N   VAL A 140     -44.091  14.939 -27.394  0.00  0.00           N  
ATOM   2123  CA  VAL A 140     -42.919  15.283 -26.573  0.00  0.00           C  
ATOM   2124  C   VAL A 140     -41.591  15.489 -27.303  0.00  0.00           C  
ATOM   2125  O   VAL A 140     -40.735  14.606 -27.343  0.00  0.00           O  
ATOM   2126  CB  VAL A 140     -42.767  14.356 -25.351  0.00  0.00           C  
ATOM   2127  CG1 VAL A 140     -43.819  14.717 -24.303  0.00  0.00           C  
ATOM   2128  CG2 VAL A 140     -42.920  12.868 -25.678  0.00  0.00           C  
ATOM   2129  H   VAL A 140     -44.974  15.276 -27.055  0.00  0.00           H  
ATOM   2130  HA  VAL A 140     -43.138  16.262 -26.152  0.00  0.00           H  
ATOM   2131  HB  VAL A 140     -41.793  14.521 -24.895  0.00  0.00           H  
ATOM   2132 HG11 VAL A 140     -43.617  14.150 -23.399  0.00  0.00           H  
ATOM   2133 HG12 VAL A 140     -43.746  15.778 -24.060  0.00  0.00           H  
ATOM   2134 HG13 VAL A 140     -44.820  14.489 -24.666  0.00  0.00           H  
ATOM   2135 HG21 VAL A 140     -42.765  12.277 -24.776  0.00  0.00           H  
ATOM   2136 HG22 VAL A 140     -43.918  12.680 -26.063  0.00  0.00           H  
ATOM   2137 HG23 VAL A 140     -42.175  12.578 -26.419  0.00  0.00           H  
ATOM   2138  N   ARG A 141     -41.398  16.675 -27.888  0.00  0.00           N  
ATOM   2139  CA  ARG A 141     -40.068  17.087 -28.363  0.00  0.00           C  
ATOM   2140  C   ARG A 141     -39.280  17.489 -27.113  0.00  0.00           C  
ATOM   2141  O   ARG A 141     -39.755  18.300 -26.318  0.00  0.00           O  
ATOM   2142  CB  ARG A 141     -40.131  18.206 -29.419  0.00  0.00           C  
ATOM   2143  CG  ARG A 141     -40.966  19.442 -29.034  0.00  0.00           C  
ATOM   2144  CD  ARG A 141     -40.793  20.589 -30.045  0.00  0.00           C  
ATOM   2145  NE  ARG A 141     -39.410  21.122 -30.071  0.00  0.00           N  
ATOM   2146  CZ  ARG A 141     -38.970  22.172 -30.739  0.00  0.00           C  
ATOM   2147  NH1 ARG A 141     -39.747  22.929 -31.462  0.00  0.00           N  
ATOM   2148  NH2 ARG A 141     -37.709  22.478 -30.676  0.00  0.00           N  
ATOM   2149  H   ARG A 141     -42.098  17.395 -27.727  0.00  0.00           H  
ATOM   2150  HA  ARG A 141     -39.562  16.233 -28.820  0.00  0.00           H  
ATOM   2151  HB2 ARG A 141     -39.106  18.511 -29.634  0.00  0.00           H  
ATOM   2152  HB3 ARG A 141     -40.547  17.790 -30.338  0.00  0.00           H  
ATOM   2153  HG2 ARG A 141     -42.017  19.141 -28.992  0.00  0.00           H  
ATOM   2154  HG3 ARG A 141     -40.679  19.809 -28.051  0.00  0.00           H  
ATOM   2155  HD2 ARG A 141     -41.065  20.228 -31.038  0.00  0.00           H  
ATOM   2156  HD3 ARG A 141     -41.482  21.389 -29.768  0.00  0.00           H  
ATOM   2157  HE  ARG A 141     -38.687  20.621 -29.559  0.00  0.00           H  
ATOM   2158 HH11 ARG A 141     -40.724  22.703 -31.534  0.00  0.00           H  
ATOM   2159 HH12 ARG A 141     -39.375  23.725 -31.949  0.00  0.00           H  
ATOM   2160 HH21 ARG A 141     -37.100  21.862 -30.133  0.00  0.00           H  
ATOM   2161 HH22 ARG A 141     -37.329  23.256 -31.186  0.00  0.00           H  
ATOM   2162  N   VAL A 142     -38.123  16.877 -26.882  0.00  0.00           N  
ATOM   2163  CA  VAL A 142     -37.363  17.027 -25.630  0.00  0.00           C  
ATOM   2164  C   VAL A 142     -35.888  17.178 -26.001  0.00  0.00           C  
ATOM   2165  O   VAL A 142     -35.342  16.315 -26.692  0.00  0.00           O  
ATOM   2166  CB  VAL A 142     -37.573  15.804 -24.707  0.00  0.00           C  
ATOM   2167  CG1 VAL A 142     -36.735  15.877 -23.423  0.00  0.00           C  
ATOM   2168  CG2 VAL A 142     -39.035  15.688 -24.273  0.00  0.00           C  
ATOM   2169  H   VAL A 142     -37.776  16.227 -27.571  0.00  0.00           H  
ATOM   2170  HA  VAL A 142     -37.730  17.925 -25.118  0.00  0.00           H  
ATOM   2171  HB  VAL A 142     -37.303  14.894 -25.245  0.00  0.00           H  
ATOM   2172 HG11 VAL A 142     -35.678  15.905 -23.669  0.00  0.00           H  
ATOM   2173 HG12 VAL A 142     -36.994  16.770 -22.852  0.00  0.00           H  
ATOM   2174 HG13 VAL A 142     -36.919  14.997 -22.807  0.00  0.00           H  
ATOM   2175 HG21 VAL A 142     -39.340  16.610 -23.791  0.00  0.00           H  
ATOM   2176 HG22 VAL A 142     -39.666  15.502 -25.137  0.00  0.00           H  
ATOM   2177 HG23 VAL A 142     -39.162  14.861 -23.579  0.00  0.00           H  
ATOM   2178  N   GLU A 143     -35.237  18.269 -25.588  0.00  0.00           N  
ATOM   2179  CA  GLU A 143     -33.891  18.644 -26.065  0.00  0.00           C  
ATOM   2180  C   GLU A 143     -33.062  19.250 -24.928  0.00  0.00           C  
ATOM   2181  O   GLU A 143     -33.618  19.583 -23.887  0.00  0.00           O  
ATOM   2182  CB  GLU A 143     -34.050  19.726 -27.153  0.00  0.00           C  
ATOM   2183  CG  GLU A 143     -34.747  19.285 -28.451  0.00  0.00           C  
ATOM   2184  CD  GLU A 143     -35.532  20.452 -29.072  0.00  0.00           C  
ATOM   2185  OE1 GLU A 143     -34.919  21.466 -29.477  0.00  0.00           O  
ATOM   2186  OE2 GLU A 143     -36.781  20.372 -29.157  0.00  0.00           O  
ATOM   2187  H   GLU A 143     -35.694  18.913 -24.938  0.00  0.00           H  
ATOM   2188  HA  GLU A 143     -33.353  17.786 -26.472  0.00  0.00           H  
ATOM   2189  HB2 GLU A 143     -34.615  20.548 -26.716  0.00  0.00           H  
ATOM   2190  HB3 GLU A 143     -33.066  20.115 -27.420  0.00  0.00           H  
ATOM   2191  HG2 GLU A 143     -33.995  18.919 -29.152  0.00  0.00           H  
ATOM   2192  HG3 GLU A 143     -35.438  18.466 -28.261  0.00  0.00           H  
ATOM   2193  N   LEU A 144     -31.744  19.432 -25.077  0.00  0.00           N  
ATOM   2194  CA  LEU A 144     -31.009  20.255 -24.102  0.00  0.00           C  
ATOM   2195  C   LEU A 144     -31.430  21.726 -24.287  0.00  0.00           C  
ATOM   2196  O   LEU A 144     -31.754  22.142 -25.404  0.00  0.00           O  
ATOM   2197  CB  LEU A 144     -29.488  20.013 -24.187  0.00  0.00           C  
ATOM   2198  CG  LEU A 144     -28.758  20.468 -25.471  0.00  0.00           C  
ATOM   2199  CD1 LEU A 144     -28.373  21.954 -25.468  0.00  0.00           C  
ATOM   2200  CD2 LEU A 144     -27.450  19.686 -25.610  0.00  0.00           C  
ATOM   2201  H   LEU A 144     -31.292  19.160 -25.938  0.00  0.00           H  
ATOM   2202  HA  LEU A 144     -31.333  19.955 -23.104  0.00  0.00           H  
ATOM   2203  HB2 LEU A 144     -29.015  20.497 -23.331  0.00  0.00           H  
ATOM   2204  HB3 LEU A 144     -29.337  18.941 -24.061  0.00  0.00           H  
ATOM   2205  HG  LEU A 144     -29.377  20.257 -26.344  0.00  0.00           H  
ATOM   2206 HD11 LEU A 144     -27.774  22.181 -26.348  0.00  0.00           H  
ATOM   2207 HD12 LEU A 144     -29.256  22.584 -25.504  0.00  0.00           H  
ATOM   2208 HD13 LEU A 144     -27.797  22.193 -24.573  0.00  0.00           H  
ATOM   2209 HD21 LEU A 144     -27.662  18.616 -25.663  0.00  0.00           H  
ATOM   2210 HD22 LEU A 144     -26.936  19.979 -26.525  0.00  0.00           H  
ATOM   2211 HD23 LEU A 144     -26.802  19.880 -24.755  0.00  0.00           H  
ATOM   2212  N   SER A 145     -31.448  22.516 -23.208  0.00  0.00           N  
ATOM   2213  CA  SER A 145     -31.843  23.928 -23.303  0.00  0.00           C  
ATOM   2214  C   SER A 145     -30.707  24.779 -23.877  0.00  0.00           C  
ATOM   2215  O   SER A 145     -29.586  24.770 -23.358  0.00  0.00           O  
ATOM   2216  CB  SER A 145     -32.276  24.494 -21.952  0.00  0.00           C  
ATOM   2217  OG  SER A 145     -32.621  25.865 -22.079  0.00  0.00           O  
ATOM   2218  H   SER A 145     -31.100  22.152 -22.328  0.00  0.00           H  
ATOM   2219  HA  SER A 145     -32.703  23.994 -23.962  0.00  0.00           H  
ATOM   2220  HB2 SER A 145     -33.134  23.936 -21.580  0.00  0.00           H  
ATOM   2221  HB3 SER A 145     -31.447  24.395 -21.256  0.00  0.00           H  
ATOM   2222  HG  SER A 145     -33.384  25.944 -22.689  0.00  0.00           H  
ATOM   2223  N   ASN A 146     -31.001  25.543 -24.929  0.00  0.00           N  
ATOM   2224  CA  ASN A 146     -30.073  26.506 -25.535  0.00  0.00           C  
ATOM   2225  C   ASN A 146     -29.943  27.845 -24.761  0.00  0.00           C  
ATOM   2226  O   ASN A 146     -29.233  28.748 -25.212  0.00  0.00           O  
ATOM   2227  CB  ASN A 146     -30.450  26.697 -27.018  0.00  0.00           C  
ATOM   2228  CG  ASN A 146     -31.777  27.402 -27.276  0.00  0.00           C  
ATOM   2229  OD1 ASN A 146     -32.457  27.902 -26.394  0.00  0.00           O  
ATOM   2230  ND2 ASN A 146     -32.191  27.466 -28.522  0.00  0.00           N  
ATOM   2231  H   ASN A 146     -31.943  25.485 -25.301  0.00  0.00           H  
ATOM   2232  HA  ASN A 146     -29.077  26.056 -25.514  0.00  0.00           H  
ATOM   2233  HB2 ASN A 146     -29.666  27.274 -27.506  0.00  0.00           H  
ATOM   2234  HB3 ASN A 146     -30.482  25.719 -27.501  0.00  0.00           H  
ATOM   2235 HD21 ASN A 146     -31.641  27.064 -29.263  0.00  0.00           H  
ATOM   2236 HD22 ASN A 146     -33.055  27.949 -28.712  0.00  0.00           H  
ATOM   2237  N   GLY A 147     -30.606  27.993 -23.607  0.00  0.00           N  
ATOM   2238  CA  GLY A 147     -30.720  29.237 -22.833  0.00  0.00           C  
ATOM   2239  C   GLY A 147     -29.504  29.616 -21.969  0.00  0.00           C  
ATOM   2240  O   GLY A 147     -29.677  29.945 -20.794  0.00  0.00           O  
ATOM   2241  H   GLY A 147     -31.172  27.212 -23.294  0.00  0.00           H  
ATOM   2242  HA2 GLY A 147     -30.905  30.060 -23.523  0.00  0.00           H  
ATOM   2243  HA3 GLY A 147     -31.589  29.157 -22.178  0.00  0.00           H  
ATOM   2244  N   GLU A 148     -28.280  29.569 -22.507  0.00  0.00           N  
ATOM   2245  CA  GLU A 148     -27.049  29.999 -21.808  0.00  0.00           C  
ATOM   2246  C   GLU A 148     -25.988  30.591 -22.767  0.00  0.00           C  
ATOM   2247  O   GLU A 148     -25.994  30.318 -23.971  0.00  0.00           O  
ATOM   2248  CB  GLU A 148     -26.459  28.810 -21.014  0.00  0.00           C  
ATOM   2249  CG  GLU A 148     -25.598  29.265 -19.825  0.00  0.00           C  
ATOM   2250  CD  GLU A 148     -24.902  28.085 -19.137  0.00  0.00           C  
ATOM   2251  OE1 GLU A 148     -23.885  27.582 -19.671  0.00  0.00           O  
ATOM   2252  OE2 GLU A 148     -25.355  27.671 -18.047  0.00  0.00           O  
ATOM   2253  H   GLU A 148     -28.204  29.315 -23.488  0.00  0.00           H  
ATOM   2254  HA  GLU A 148     -27.318  30.783 -21.097  0.00  0.00           H  
ATOM   2255  HB2 GLU A 148     -27.270  28.195 -20.620  0.00  0.00           H  
ATOM   2256  HB3 GLU A 148     -25.864  28.191 -21.688  0.00  0.00           H  
ATOM   2257  HG2 GLU A 148     -24.831  29.961 -20.154  0.00  0.00           H  
ATOM   2258  HG3 GLU A 148     -26.236  29.796 -19.114  0.00  0.00           H  
ATOM   2259  N   LYS A 149     -25.048  31.377 -22.216  0.00  0.00           N  
ATOM   2260  CA  LYS A 149     -23.912  32.023 -22.915  0.00  0.00           C  
ATOM   2261  C   LYS A 149     -22.597  31.970 -22.102  0.00  0.00           C  
ATOM   2262  O   LYS A 149     -21.720  32.826 -22.263  0.00  0.00           O  
ATOM   2263  CB  LYS A 149     -24.325  33.466 -23.292  0.00  0.00           C  
ATOM   2264  CG  LYS A 149     -24.372  34.447 -22.095  0.00  0.00           C  
ATOM   2265  CD  LYS A 149     -23.361  35.606 -22.231  0.00  0.00           C  
ATOM   2266  CE  LYS A 149     -22.766  36.077 -20.895  0.00  0.00           C  
ATOM   2267  NZ  LYS A 149     -21.828  35.077 -20.329  0.00  0.00           N  
ATOM   2268  H   LYS A 149     -25.148  31.573 -21.227  0.00  0.00           H  
ATOM   2269  HA  LYS A 149     -23.713  31.468 -23.833  0.00  0.00           H  
ATOM   2270  HB2 LYS A 149     -23.639  33.833 -24.055  0.00  0.00           H  
ATOM   2271  HB3 LYS A 149     -25.311  33.438 -23.757  0.00  0.00           H  
ATOM   2272  HG2 LYS A 149     -25.374  34.873 -22.025  0.00  0.00           H  
ATOM   2273  HG3 LYS A 149     -24.197  33.908 -21.164  0.00  0.00           H  
ATOM   2274  HD2 LYS A 149     -22.532  35.320 -22.880  0.00  0.00           H  
ATOM   2275  HD3 LYS A 149     -23.867  36.449 -22.707  0.00  0.00           H  
ATOM   2276  HE2 LYS A 149     -22.222  37.007 -21.083  0.00  0.00           H  
ATOM   2277  HE3 LYS A 149     -23.571  36.299 -20.187  0.00  0.00           H  
ATOM   2278  HZ1 LYS A 149     -21.273  34.639 -21.054  0.00  0.00           H  
ATOM   2279  HZ2 LYS A 149     -21.204  35.485 -19.649  0.00  0.00           H  
ATOM   2280  HZ3 LYS A 149     -22.319  34.317 -19.860  0.00  0.00           H  
ATOM   2281  N   ARG A 150     -22.478  30.978 -21.207  0.00  0.00           N  
ATOM   2282  CA  ARG A 150     -21.443  30.852 -20.153  0.00  0.00           C  
ATOM   2283  C   ARG A 150     -21.344  32.118 -19.285  0.00  0.00           C  
ATOM   2284  O   ARG A 150     -20.234  32.534 -18.889  0.00  0.00           O  
ATOM   2285  CB  ARG A 150     -20.090  30.401 -20.747  0.00  0.00           C  
ATOM   2286  CG  ARG A 150     -20.112  29.145 -21.632  0.00  0.00           C  
ATOM   2287  CD  ARG A 150     -20.979  28.026 -21.042  0.00  0.00           C  
ATOM   2288  NE  ARG A 150     -20.628  26.705 -21.578  0.00  0.00           N  
ATOM   2289  CZ  ARG A 150     -21.222  25.576 -21.257  0.00  0.00           C  
ATOM   2290  NH1 ARG A 150     -22.272  25.486 -20.503  0.00  0.00           N  
ATOM   2291  NH2 ARG A 150     -20.761  24.450 -21.691  0.00  0.00           N  
ATOM   2292  OXT ARG A 150     -22.411  32.719 -19.015  0.00  0.00           O  
ATOM   2293  H   ARG A 150     -23.237  30.312 -21.190  0.00  0.00           H  
ATOM   2294  HA  ARG A 150     -21.774  30.080 -19.459  0.00  0.00           H  
ATOM   2295  HB2 ARG A 150     -19.660  31.219 -21.328  0.00  0.00           H  
ATOM   2296  HB3 ARG A 150     -19.412  30.200 -19.915  0.00  0.00           H  
ATOM   2297  HG2 ARG A 150     -20.489  29.400 -22.624  0.00  0.00           H  
ATOM   2298  HG3 ARG A 150     -19.085  28.790 -21.738  0.00  0.00           H  
ATOM   2299  HD2 ARG A 150     -20.853  28.006 -19.957  0.00  0.00           H  
ATOM   2300  HD3 ARG A 150     -22.021  28.242 -21.282  0.00  0.00           H  
ATOM   2301  HE  ARG A 150     -19.824  26.636 -22.180  0.00  0.00           H  
ATOM   2302 HH11 ARG A 150     -22.759  26.322 -20.173  0.00  0.00           H  
ATOM   2303 HH12 ARG A 150     -22.634  24.553 -20.334  0.00  0.00           H  
ATOM   2304 HH21 ARG A 150     -19.917  24.423 -22.257  0.00  0.00           H  
ATOM   2305 HH22 ARG A 150     -21.255  23.607 -21.402  0.00  0.00           H  
TER    2306      ARG A 150                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
