
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   70 (  529),  selected   70 , name 1pgx_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1pgx_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    A    12_A      -       -           -
LGA    V    13_A      -       -           -
LGA    T    14_A      T       1          1.199
LGA    T    15_A      T       2          1.125
LGA    Y    16_A      Y       3          0.730
LGA    K    17_A      K       4          0.708
LGA    L    18_A      L       5          0.740
LGA    V    19_A      I       6          0.905
LGA    I    20_A      L       7          0.986
LGA    N    21_A      N       8          1.339
LGA    G    22_A      L       9          1.207
LGA    K    23_A      K      10          1.249
LGA    T    24_A      Q      11          2.961
LGA    L    25_A      A      12          3.204
LGA    K    26_A      K      13          0.681
LGA    G    27_A      E      14          2.779
LGA    E    28_A      E      15          1.727
LGA    T    29_A      A      16          2.669
LGA    T    30_A      I      17          1.288
LGA    T    31_A      K      18          0.805
LGA    K    32_A      E      19          0.983
LGA    A    33_A      A      20          1.558
LGA    V    34_A      V      21          1.764
LGA    D    35_A      D      22          0.976
LGA    A    36_A      A      23          1.552
LGA    E    37_A      G      24          2.243
LGA    T    38_A      T      25          1.736
LGA    A    39_A      A      26          0.614
LGA    E    40_A      E      27          1.163
LGA    K    41_A      K      28          1.286
LGA    A    42_A      Y      29          1.050
LGA    F    43_A      F      30          0.964
LGA    K    44_A      K      31          1.375
LGA    Q    45_A      L      32          1.451
LGA    Y    46_A      I      33          0.742
LGA    A    47_A      A      34          1.052
LGA    N    48_A      N      35          0.858
LGA    D    49_A      A      36          0.830
LGA    N    50_A      K      37          1.288
LGA    G    51_A      T      38          2.445
LGA    V    52_A      V      39          3.315
LGA    D    53_A      E      40          2.502
LGA    G    54_A      G      41          1.958
LGA    V    55_A      V      42          1.647
LGA    W    56_A      W      43          0.760
LGA    T    57_A      T      44          0.762
LGA    Y    58_A      Y      45          1.077
LGA    D    59_A      K      46          2.114
LGA    D    60_A      D      47          3.380
LGA    A    61_A      E      48          1.631
LGA    T    62_A      I      49          2.090
LGA    K    63_A      K      50          1.049
LGA    T    64_A      T      51          1.084
LGA    F    65_A      F      52          0.745
LGA    T    66_A      T      53          0.796
LGA    V    67_A      V      54          0.713
LGA    T    68_A      T      55          0.803
LGA    E    69_A      E      56          2.067
LGA    M    70_A      -       -           -
LGA    V    71_A      -       -           -
LGA    T    72_A      -       -           -
LGA    E    73_A      -       -           -
LGA    V    74_A      -       -           -
LGA    P    75_A      -       -           -
LGA    V    76_A      -       -           -
LGA    A    77_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   70   56    5.0     56    1.62    62.50     91.988     3.261

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.350014 * X  +   0.934857 * Y  +  -0.059442 * Z  + -13.494861
  Y_new =  -0.893111 * X  +   0.313897 * Y  +  -0.322213 * Z  +  28.896330
  Z_new =  -0.282564 * X  +   0.165867 * Y  +   0.944799 * Z  + -52.237995 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.173787   -2.967806  [ DEG:     9.9573   -170.0428 ]
  Theta =   0.286466    2.855126  [ DEG:    16.4133    163.5867 ]
  Phi   =  -1.197289    1.944304  [ DEG:   -68.5996    111.4004 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1pgx_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1pgx_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   70   56   5.0   56   1.62   62.50  91.988
REMARK  ---------------------------------------------------------- 
MOLECULE 1pgx_A
HEADER    IMMUNOGLOBULIN BINDING PROTEIN          03-APR-92   1PGX              
TITLE     THE 1.66 ANGSTROMS X-RAY STRUCTURE OF THE B2 IMMUNOGLOBULIN-          
TITLE    2 BINDING DOMAIN OF STREPTOCOCCAL PROTEIN G AND COMPARISON             
TITLE    3 TO THE NMR STRUCTURE OF THE B1 DOMAIN                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN G;                                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS;                                  
SOURCE   3 EXPRESSION_SYSTEM_VECTOR_TYPE: BACTERIAL                             
KEYWDS    IMMUNOGLOBULIN BINDING PROTEIN                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.WHITLOW,A.ACHARI,A.J.HOWARD                                         
REVDAT   1   15-JUL-92 1PGX    0                                                
JRNL        AUTH   A.ACHARI,S.P.HALE,A.J.HOWARD,G.M.CLORE,                      
JRNL        AUTH 2 A.M.GRONENBORN,K.D.HARDMAN,M.WHITLOW                         
JRNL        TITL   1.67-A X-RAY STRUCTURE OF THE B2                             
JRNL        TITL 2 IMMUNOGLOBULIN-BINDING DOMAIN OF STREPTOCOCCAL               
JRNL        TITL 3 PROTEIN G AND COMPARISON TO THE NMR STRUCTURE OF             
JRNL        TITL 4 THE B1 DOMAIN.                                               
JRNL        REF    BIOCHEMISTRY                  V.  31 10449 1992              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 1.66 ANGSTROMS.                                          
DBREF  1PGX A    3    82  UNP    P06654   SPG1_STRSG     284    366             
SEQRES   1 A   83  MET ASP PRO GLY ASP ALA SER GLU LEU THR PRO ALA VAL          
SEQRES   2 A   83  THR THR TYR LYS LEU VAL ILE ASN GLY LYS THR LEU LYS          
SEQRES   3 A   83  GLY GLU THR THR THR LYS ALA VAL ASP ALA GLU THR ALA          
SEQRES   4 A   83  GLU LYS ALA PHE LYS GLN TYR ALA ASN ASP ASN GLY VAL          
SEQRES   5 A   83  ASP GLY VAL TRP THR TYR ASP ASP ALA THR LYS THR PHE          
SEQRES   6 A   83  THR VAL THR GLU MET VAL THR GLU VAL PRO VAL ALA SER          
SEQRES   7 A   83  LYS ARG LYS GLU ASP                                          
FORMUL   2  HOH   *61(H2 O)                                                     
CRYST1   26.040   34.500   35.950  90.00 100.84  90.00 P 1 21 1      2          
ATOM      1  N   GLU A   8       9.411 -23.851  12.418  0.50 47.32           N  
ATOM      2  CA  GLU A   8       9.716 -22.420  12.367  0.50 42.87           C  
ATOM      3  C   GLU A   8       9.863 -21.916  13.829  1.00 33.63           C  
ATOM      4  O   GLU A   8       8.891 -21.834  14.602  1.00 40.17           O  
ATOM      5  CB  GLU A   8       8.610 -21.605  11.769  0.50 44.92           C  
ATOM      6  CG  GLU A   8       7.676 -22.118  10.688  0.50 70.36           C  
ATOM      7  CD  GLU A   8       6.491 -21.213  10.457  0.50 50.86           C  
ATOM      8  OE1 GLU A   8       5.862 -20.675  11.365  0.50 51.00           O  
ATOM      9  OE2 GLU A   8       6.254 -21.068   9.246  0.50 52.47           O  
ATOM     10  N   LEU A   9      11.112 -21.631  14.158  1.00 24.03           N  
ATOM     11  CA  LEU A   9      11.389 -21.116  15.540  1.00 21.89           C  
ATOM     12  C   LEU A   9      11.093 -19.615  15.513  1.00 31.06           C  
ATOM     13  O   LEU A   9      10.540 -19.058  16.479  1.00 20.03           O  
ATOM     14  CB  LEU A   9      12.820 -21.529  15.807  1.00 31.99           C  
ATOM     15  CG  LEU A   9      13.285 -21.920  17.165  1.00 22.00           C  
ATOM     16  CD1 LEU A   9      12.537 -23.033  17.819  1.00 22.76           C  
ATOM     17  CD2 LEU A   9      14.787 -22.229  17.076  1.00 13.23           C  
ATOM     18  N   THR A  10      11.387 -19.041  14.365  1.00 20.30           N  
ATOM     19  CA  THR A  10      11.217 -17.595  14.187  1.00 34.65           C  
ATOM     20  C   THR A  10      10.036 -17.188  13.352  1.00 32.39           C  
ATOM     21  O   THR A  10       9.525 -17.926  12.486  1.00 28.70           O  
ATOM     22  CB  THR A  10      12.573 -16.943  13.711  1.00 32.81           C  
ATOM     23  OG1 THR A  10      12.849 -17.462  12.374  1.00 33.64           O  
ATOM     24  CG2 THR A  10      13.735 -17.150  14.681  1.00 26.48           C  
ATOM     25  N   PRO A  11       9.581 -15.957  13.615  1.00 46.25           N  
ATOM     26  CA  PRO A  11       8.438 -15.384  12.887  1.00 30.33           C  
ATOM     27  C   PRO A  11       8.709 -15.458  11.374  1.00 41.59           C  
ATOM     28  O   PRO A  11       9.790 -15.076  10.896  1.00 62.84           O  
ATOM     29  CB  PRO A  11       8.345 -13.964  13.404  1.00 29.83           C  
ATOM     30  CG  PRO A  11       9.055 -13.941  14.727  1.00 48.03           C  
ATOM     31  CD  PRO A  11      10.122 -15.016  14.618  1.00 38.75           C  
ATOM     32  N   ALA A  12       7.739 -15.984  10.667  1.00 35.94           N  
ATOM     33  CA  ALA A  12       7.765 -16.138   9.195  1.00 43.98           C  
ATOM     34  C   ALA A  12       7.128 -14.892   8.588  1.00 44.26           C  
ATOM     35  O   ALA A  12       5.931 -14.633   8.841  1.00 63.63           O  
ATOM     36  CB  ALA A  12       6.950 -17.376   8.819  1.00 50.42           C  
ATOM     37  N   VAL A  13       7.931 -14.154   7.842  1.00 39.74           N  
ATOM     38  CA  VAL A  13       7.455 -12.913   7.237  1.00 33.01           C  
ATOM     39  C   VAL A  13       7.248 -13.087   5.736  1.00 31.83           C  
ATOM     40  O   VAL A  13       8.006 -13.775   5.039  1.00 28.06           O  
ATOM     41  CB  VAL A  13       8.320 -11.715   7.622  1.00 28.50           C  
ATOM     42  CG1 VAL A  13       8.438 -11.459   9.121  1.00 38.34           C  
ATOM     43  CG2 VAL A  13       9.671 -11.663   6.925  1.00 37.55           C  
ATOM     44  N   THR A  14       6.240 -12.383   5.250  1.00 20.81           N  
ATOM     45  CA  THR A  14       5.877 -12.378   3.837  1.00 13.45           C  
ATOM     46  C   THR A  14       6.164 -10.972   3.277  1.00 16.43           C  
ATOM     47  O   THR A  14       6.099 -10.007   4.078  1.00 17.02           O  
ATOM     48  CB  THR A  14       4.334 -12.710   3.688  1.00 14.44           C  
ATOM     49  OG1 THR A  14       4.145 -14.051   4.251  1.00 23.93           O  
ATOM     50  CG2 THR A  14       3.740 -12.570   2.297  1.00 15.62           C  
ATOM     51  N   THR A  15       6.473 -10.932   2.016  1.00  9.68           N  
ATOM     52  CA  THR A  15       6.699  -9.628   1.359  1.00 13.35           C  
ATOM     53  C   THR A  15       5.367  -9.232   0.726  1.00 12.82           C  
ATOM     54  O   THR A  15       4.761  -9.955  -0.049  1.00 12.12           O  
ATOM     55  CB  THR A  15       7.840  -9.692   0.302  1.00 15.49           C  
ATOM     56  OG1 THR A  15       9.069 -10.011   1.067  1.00 17.33           O  
ATOM     57  CG2 THR A  15       8.037  -8.391  -0.474  1.00 14.88           C  
ATOM     58  N   TYR A  16       4.984  -7.945   1.067  1.00 10.46           N  
ATOM     59  CA  TYR A  16       3.745  -7.430   0.427  1.00 11.42           C  
ATOM     60  C   TYR A  16       4.140  -6.220  -0.415  1.00  5.96           C  
ATOM     61  O   TYR A  16       5.190  -5.613  -0.125  1.00  9.72           O  
ATOM     62  CB  TYR A  16       2.720  -7.029   1.510  1.00 11.29           C  
ATOM     63  CG  TYR A  16       2.226  -8.185   2.343  1.00 12.21           C  
ATOM     64  CD1 TYR A  16       2.968  -8.630   3.433  1.00 14.49           C  
ATOM     65  CD2 TYR A  16       1.064  -8.863   1.984  1.00 15.50           C  
ATOM     66  CE1 TYR A  16       2.503  -9.690   4.199  1.00 14.30           C  
ATOM     67  CE2 TYR A  16       0.599  -9.913   2.748  1.00 16.59           C  
ATOM     68  CZ  TYR A  16       1.332 -10.326   3.834  1.00 14.00           C  
ATOM     69  OH  TYR A  16       0.854 -11.382   4.560  1.00 19.19           O  
ATOM     70  N   LYS A  17       3.337  -5.933  -1.395  1.00  8.76           N  
ATOM     71  CA  LYS A  17       3.647  -4.842  -2.321  1.00  6.96           C  
ATOM     72  C   LYS A  17       2.431  -3.829  -2.246  1.00  7.65           C  
ATOM     73  O   LYS A  17       1.348  -4.238  -1.953  1.00  8.42           O  
ATOM     74  CB  LYS A  17       3.698  -5.369  -3.743  1.00 13.43           C  
ATOM     75  CG  LYS A  17       4.957  -6.292  -3.901  1.00 19.15           C  
ATOM     76  CD  LYS A  17       4.808  -7.414  -4.908  1.00 33.55           C  
ATOM     77  CE  LYS A  17       3.955  -8.536  -4.418  1.00 20.63           C  
ATOM     78  NZ  LYS A  17       4.303  -8.971  -3.048  0.50 26.13           N  
ATOM     80  N   LEU A  18       2.853  -2.615  -2.554  1.00  8.23           N  
ATOM     81  CA  LEU A  18       1.826  -1.536  -2.623  1.00 12.84           C  
ATOM     82  C   LEU A  18       2.076  -0.794  -3.926  1.00  7.25           C  
ATOM     83  O   LEU A  18       3.194  -0.328  -4.183  1.00  9.62           O  
ATOM     84  CB  LEU A  18       1.986  -0.579  -1.404  1.00 11.24           C  
ATOM     85  CG  LEU A  18       1.051   0.690  -1.581  1.00 14.97           C  
ATOM     86  CD1 LEU A  18      -0.393   0.319  -1.388  1.00 14.45           C  
ATOM     87  CD2 LEU A  18       1.557   1.752  -0.647  1.00 12.31           C  
ATOM     88  N   VAL A  19       1.005  -0.630  -4.670  1.00  7.73           N  
ATOM     89  CA  VAL A  19       1.045   0.116  -5.909  1.00  7.04           C  
ATOM     90  C   VAL A  19       0.273   1.458  -5.543  1.00  8.29           C  
ATOM     91  O   VAL A  19      -0.854   1.290  -5.105  1.00 10.50           O  
ATOM     92  CB  VAL A  19       0.374  -0.592  -7.076  1.00 20.32           C  
ATOM     93  CG1 VAL A  19       0.293   0.272  -8.339  1.00 18.07           C  
ATOM     94  CG2 VAL A  19       1.064  -1.923  -7.390  1.00 19.89           C  
ATOM     95  N   ILE A  20       0.949   2.526  -5.850  1.00 12.98           N  
ATOM     96  CA  ILE A  20       0.326   3.853  -5.513  1.00 11.53           C  
ATOM     97  C   ILE A  20      -0.025   4.519  -6.843  1.00  5.72           C  
ATOM     98  O   ILE A  20       0.797   4.874  -7.658  1.00 11.61           O  
ATOM     99  CB  ILE A  20       1.262   4.789  -4.694  1.00 15.51           C  
ATOM    100  CG1 ILE A  20       1.968   4.131  -3.503  1.00 22.89           C  
ATOM    101  CG2 ILE A  20       0.516   6.090  -4.193  1.00 13.05           C  
ATOM    102  CD1 ILE A  20       3.399   3.609  -3.832  1.00 23.15           C  
ATOM    103  N   ASN A  21      -1.332   4.760  -6.939  1.00 19.40           N  
ATOM    104  CA  ASN A  21      -1.848   5.470  -8.132  1.00 18.60           C  
ATOM    105  C   ASN A  21      -2.391   6.800  -7.587  1.00 18.05           C  
ATOM    106  O   ASN A  21      -3.613   6.916  -7.392  1.00 17.61           O  
ATOM    107  CB  ASN A  21      -2.826   4.564  -8.850  1.00 21.41           C  
ATOM    108  CG  ASN A  21      -3.477   5.143 -10.081  1.00 30.00           C  
ATOM    109  OD1 ASN A  21      -4.615   4.756 -10.417  1.00 41.31           O  
ATOM    110  ND2 ASN A  21      -2.838   6.076 -10.765  1.00 28.60           N  
ATOM    111  N   GLY A  22      -1.503   7.735  -7.296  1.00 24.61           N  
ATOM    112  CA  GLY A  22      -1.859   9.023  -6.676  1.00 22.46           C  
ATOM    113  C   GLY A  22      -1.733  10.202  -7.619  1.00 16.93           C  
ATOM    114  O   GLY A  22      -1.321  10.098  -8.764  1.00 19.99           O  
ATOM    115  N   LYS A  23      -2.197  11.352  -7.071  1.00 23.51           N  
ATOM    116  CA  LYS A  23      -2.194  12.587  -7.849  1.00 36.55           C  
ATOM    117  C   LYS A  23      -0.739  12.968  -8.151  1.00 21.19           C  
ATOM    118  O   LYS A  23      -0.414  13.212  -9.322  1.00 31.13           O  
ATOM    119  CB  LYS A  23      -2.957  13.724  -7.197  1.00 25.72           C  
ATOM    120  CG  LYS A  23      -3.124  14.936  -8.118  1.00 44.15           C  
ATOM    121  CD  LYS A  23      -3.456  16.182  -7.303  1.00 49.97           C  
ATOM    122  CE  LYS A  23      -3.643  17.397  -8.161  1.00 52.54           C  
ATOM    123  NZ  LYS A  23      -4.815  17.238  -9.060  1.00 52.24           N  
ATOM    124  N   THR A  24       0.078  12.983  -7.088  1.00 14.25           N  
ATOM    125  CA  THR A  24       1.475  13.326  -7.279  1.00 21.36           C  
ATOM    126  C   THR A  24       2.439  12.210  -6.865  1.00 15.59           C  
ATOM    127  O   THR A  24       3.497  12.238  -7.571  1.00 16.70           O  
ATOM    128  CB  THR A  24       1.935  14.684  -6.628  1.00 16.43           C  
ATOM    129  OG1 THR A  24       1.690  14.604  -5.210  1.00 18.62           O  
ATOM    130  CG2 THR A  24       1.173  15.856  -7.280  1.00 21.78           C  
ATOM    131  N   LEU A  25       1.968  11.359  -5.994  1.00 23.11           N  
ATOM    132  CA  LEU A  25       2.863  10.201  -5.625  1.00 10.34           C  
ATOM    133  C   LEU A  25       2.407   8.999  -6.521  1.00 12.49           C  
ATOM    134  O   LEU A  25       1.245   8.616  -6.475  1.00 13.25           O  
ATOM    135  CB  LEU A  25       2.690   9.898  -4.169  1.00 13.62           C  
ATOM    136  CG  LEU A  25       3.655   9.144  -3.320  0.50 27.98           C  
ATOM    138  CD1 LEU A  25       2.982   8.682  -2.015  0.50 25.26           C  
ATOM    140  CD2 LEU A  25       4.329   7.967  -4.001  0.50 30.58           C  
ATOM    142  N   LYS A  26       3.474   8.420  -7.117  1.00 10.00           N  
ATOM    143  CA  LYS A  26       3.178   7.265  -8.037  1.00  8.34           C  
ATOM    144  C   LYS A  26       4.317   6.241  -7.825  1.00 10.49           C  
ATOM    145  O   LYS A  26       5.434   6.607  -7.519  1.00 11.46           O  
ATOM    146  CB  LYS A  26       3.250   7.706  -9.470  1.00 16.95           C  
ATOM    147  CG  LYS A  26       2.163   8.656  -9.963  1.00 20.48           C  
ATOM    148  CD  LYS A  26       2.430   8.962 -11.447  1.00 29.85           C  
ATOM    149  N   GLY A  27       3.905   4.973  -8.039  1.00 13.00           N  
ATOM    150  CA  GLY A  27       5.008   3.949  -7.959  1.00 13.55           C  
ATOM    151  C   GLY A  27       4.611   2.749  -7.176  1.00  8.69           C  
ATOM    152  O   GLY A  27       3.451   2.392  -7.014  1.00 11.49           O  
ATOM    153  N   GLU A  28       5.678   2.096  -6.686  1.00  8.48           N  
ATOM    154  CA  GLU A  28       5.510   0.893  -5.887  1.00 11.70           C  
ATOM    155  C   GLU A  28       6.538   0.767  -4.774  1.00  6.11           C  
ATOM    156  O   GLU A  28       7.713   1.234  -4.967  1.00 10.63           O  
ATOM    157  CB  GLU A  28       5.716  -0.332  -6.816  1.00 14.56           C  
ATOM    158  CG  GLU A  28       5.281  -1.676  -6.307  0.50 15.55           C  
ATOM    159  CD  GLU A  28       5.415  -2.847  -7.254  1.00 39.86           C  
ATOM    160  OE1 GLU A  28       5.435  -2.560  -8.474  1.00 27.37           O  
ATOM    161  OE2 GLU A  28       5.479  -3.978  -6.822  1.00 39.30           O  
ATOM    162  N   THR A  29       6.130   0.222  -3.707  1.00  9.81           N  
ATOM    163  CA  THR A  29       6.973  -0.027  -2.541  1.00 13.73           C  
ATOM    164  C   THR A  29       6.618  -1.373  -1.957  1.00 10.69           C  
ATOM    165  O   THR A  29       5.612  -1.958  -2.443  1.00 11.78           O  
ATOM    166  CB  THR A  29       6.867   1.173  -1.494  1.00 12.85           C  
ATOM    167  OG1 THR A  29       7.994   0.943  -0.609  1.00 16.58           O  
ATOM    168  CG2 THR A  29       5.531   1.175  -0.739  1.00 11.44           C  
ATOM    169  N   THR A  30       7.388  -1.786  -0.988  1.00 14.04           N  
ATOM    170  CA  THR A  30       7.093  -3.090  -0.340  1.00 10.56           C  
ATOM    171  C   THR A  30       7.291  -2.988   1.158  1.00 16.74           C  
ATOM    172  O   THR A  30       7.901  -2.008   1.670  1.00 16.37           O  
ATOM    173  CB  THR A  30       8.150  -4.156  -0.943  1.00 11.19           C  
ATOM    174  OG1 THR A  30       9.454  -3.693  -0.535  1.00 19.22           O  
ATOM    175  CG2 THR A  30       7.993  -4.402  -2.429  1.00 18.36           C  
ATOM    176  N   THR A  31       6.863  -4.000   1.865  1.00 10.68           N  
ATOM    177  CA  THR A  31       7.059  -4.163   3.291  1.00 11.63           C  
ATOM    178  C   THR A  31       7.050  -5.666   3.617  1.00 13.68           C  
ATOM    179  O   THR A  31       6.447  -6.403   2.787  1.00 15.51           O  
ATOM    180  CB  THR A  31       6.000  -3.386   4.192  1.00 16.27           C  
ATOM    181  OG1 THR A  31       6.654  -3.241   5.473  1.00 23.84           O  
ATOM    182  CG2 THR A  31       4.636  -4.038   4.320  1.00 12.50           C  
ATOM    183  N   LYS A  32       7.657  -6.003   4.707  1.00 15.29           N  
ATOM    184  CA  LYS A  32       7.584  -7.442   5.130  1.00 15.92           C  
ATOM    185  C   LYS A  32       6.769  -7.423   6.414  1.00 17.50           C  
ATOM    186  O   LYS A  32       7.004  -6.548   7.291  1.00 23.03           O  
ATOM    187  CB  LYS A  32       8.962  -8.014   5.392  1.00 22.72           C  
ATOM    188  CG  LYS A  32       9.799  -8.209   4.120  1.00 17.18           C  
ATOM    189  CD  LYS A  32      11.129  -8.867   4.403  1.00 29.11           C  
ATOM    190  CE  LYS A  32      12.150  -7.973   5.063  1.00 50.89           C  
ATOM    191  N   ALA A  33       5.810  -8.300   6.545  1.00 14.62           N  
ATOM    192  CA  ALA A  33       4.938  -8.434   7.698  1.00 19.20           C  
ATOM    193  C   ALA A  33       4.551  -9.899   7.900  1.00 22.64           C  
ATOM    194  O   ALA A  33       4.669 -10.684   6.960  1.00 18.82           O  
ATOM    195  CB  ALA A  33       3.626  -7.642   7.512  1.00 19.75           C  
ATOM    196  N   VAL A  34       4.076 -10.148   9.090  1.00 24.87           N  
ATOM    197  CA  VAL A  34       3.642 -11.467   9.493  1.00 20.85           C  
ATOM    198  C   VAL A  34       2.349 -11.863   8.828  1.00 35.20           C  
ATOM    199  O   VAL A  34       2.106 -13.069   8.635  1.00 28.09           O  
ATOM    200  CB  VAL A  34       3.692 -11.645  11.016  1.00 28.41           C  
ATOM    201  CG1 VAL A  34       5.094 -11.438  11.583  1.00 36.39           C  
ATOM    202  CG2 VAL A  34       2.672 -10.779  11.754  1.00 34.84           C  
ATOM    203  N   ASP A  35       1.516 -10.874   8.512  1.00 19.35           N  
ATOM    204  CA  ASP A  35       0.216 -11.186   7.872  1.00 14.91           C  
ATOM    205  C   ASP A  35      -0.277  -9.983   7.071  1.00 15.23           C  
ATOM    206  O   ASP A  35       0.358  -8.913   7.152  1.00 20.83           O  
ATOM    207  CB  ASP A  35      -0.780 -11.697   8.884  1.00 20.16           C  
ATOM    208  CG  ASP A  35      -1.147 -10.773  10.034  1.00 35.85           C  
ATOM    209  OD1 ASP A  35      -0.833  -9.575   9.980  1.00 25.44           O  
ATOM    210  OD2 ASP A  35      -1.790 -11.222  10.998  1.00 39.20           O  
ATOM    211  N   ALA A  36      -1.339 -10.218   6.326  1.00 19.66           N  
ATOM    212  CA  ALA A  36      -1.904  -9.206   5.450  1.00 14.93           C  
ATOM    213  C   ALA A  36      -2.459  -8.019   6.256  1.00 12.02           C  
ATOM    214  O   ALA A  36      -2.402  -6.912   5.711  1.00 20.27           O  
ATOM    215  CB  ALA A  36      -3.009  -9.763   4.555  1.00 19.26           C  
ATOM    216  N   GLU A  37      -3.008  -8.298   7.405  1.00 20.61           N  
ATOM    217  CA  GLU A  37      -3.621  -7.238   8.254  1.00 25.48           C  
ATOM    218  C   GLU A  37      -2.542  -6.258   8.699  1.00 26.80           C  
ATOM    219  O   GLU A  37      -2.751  -5.042   8.655  1.00 23.15           O  
ATOM    220  CB  GLU A  37      -4.320  -7.750   9.469  1.00 34.79           C  
ATOM    221  CG  GLU A  37      -5.553  -8.563   9.486  1.00 42.48           C  
ATOM    222  CD  GLU A  37      -6.923  -8.045   9.346  1.00 57.10           C  
ATOM    223  OE1 GLU A  37      -7.142  -6.981   9.997  1.00 52.70           O  
ATOM    224  OE2 GLU A  37      -7.811  -8.604   8.693  1.00 50.75           O  
ATOM    225  N   THR A  38      -1.416  -6.806   9.107  1.00 18.48           N  
ATOM    226  CA  THR A  38      -0.287  -5.947   9.542  1.00 14.92           C  
ATOM    227  C   THR A  38       0.203  -5.087   8.404  1.00 21.77           C  
ATOM    228  O   THR A  38       0.538  -3.896   8.568  1.00 21.36           O  
ATOM    229  CB  THR A  38       0.854  -6.832  10.157  1.00 22.34           C  
ATOM    230  OG1 THR A  38       0.187  -7.535  11.265  1.00 33.28           O  
ATOM    231  CG2 THR A  38       2.097  -6.102  10.613  1.00 25.44           C  
ATOM    232  N   ALA A  39       0.298  -5.694   7.214  1.00 14.79           N  
ATOM    233  CA  ALA A  39       0.790  -5.028   5.996  1.00 15.37           C  
ATOM    234  C   ALA A  39      -0.173  -3.904   5.601  1.00 14.12           C  
ATOM    235  O   ALA A  39       0.319  -2.837   5.205  1.00 15.64           O  
ATOM    236  CB  ALA A  39       0.997  -5.985   4.847  1.00 21.13           C  
ATOM    237  N   GLU A  40      -1.443  -4.175   5.757  1.00 15.03           N  
ATOM    238  CA  GLU A  40      -2.488  -3.190   5.413  1.00 15.59           C  
ATOM    239  C   GLU A  40      -2.316  -1.943   6.315  1.00 11.52           C  
ATOM    240  O   GLU A  40      -2.336  -0.819   5.800  1.00 13.81           O  
ATOM    241  CB  GLU A  40      -3.859  -3.764   5.671  1.00 16.26           C  
ATOM    242  CG  GLU A  40      -5.069  -2.868   5.280  1.00 16.31           C  
ATOM    243  CD  GLU A  40      -6.401  -3.459   5.614  1.00 25.92           C  
ATOM    244  OE1 GLU A  40      -6.583  -4.555   6.101  1.00 29.68           O  
ATOM    245  OE2 GLU A  40      -7.342  -2.685   5.325  1.00 26.43           O  
ATOM    246  N   LYS A  41      -2.152  -2.181   7.571  1.00 21.42           N  
ATOM    247  CA  LYS A  41      -1.965  -1.061   8.565  1.00 13.85           C  
ATOM    248  C   LYS A  41      -0.742  -0.275   8.236  1.00 25.32           C  
ATOM    249  O   LYS A  41      -0.760   0.989   8.219  1.00 19.15           O  
ATOM    250  CB  LYS A  41      -2.117  -1.606   9.951  1.00 20.21           C  
ATOM    251  CG  LYS A  41      -3.470  -2.054  10.450  1.00 28.35           C  
ATOM    252  CD  LYS A  41      -4.496  -2.638   9.550  1.00 42.01           C  
ATOM    253  CE  LYS A  41      -5.538  -3.556  10.067  1.00 35.76           C  
ATOM    254  N   ALA A  42       0.370  -0.920   7.872  1.00 13.07           N  
ATOM    255  CA  ALA A  42       1.612  -0.208   7.535  1.00 12.65           C  
ATOM    256  C   ALA A  42       1.484   0.630   6.299  1.00 13.52           C  
ATOM    257  O   ALA A  42       2.074   1.736   6.165  1.00 17.22           O  
ATOM    258  CB  ALA A  42       2.778  -1.214   7.404  1.00 17.43           C  
ATOM    259  N   PHE A  43       0.793   0.108   5.310  1.00 10.42           N  
ATOM    260  CA  PHE A  43       0.560   0.715   4.033  1.00  9.64           C  
ATOM    261  C   PHE A  43      -0.403   1.915   4.167  1.00 10.30           C  
ATOM    262  O   PHE A  43      -0.126   2.898   3.447  1.00 13.23           O  
ATOM    263  CB  PHE A  43       0.215  -0.206   2.876  1.00 12.30           C  
ATOM    264  CG  PHE A  43       1.352  -1.108   2.395  1.00  8.35           C  
ATOM    265  CD1 PHE A  43       2.604  -0.632   2.143  1.00  9.01           C  
ATOM    266  CD2 PHE A  43       0.971  -2.398   1.971  1.00 11.48           C  
ATOM    267  CE1 PHE A  43       3.630  -1.444   1.656  1.00 15.17           C  
ATOM    268  CE2 PHE A  43       1.974  -3.217   1.392  1.00 11.10           C  
ATOM    269  CZ  PHE A  43       3.251  -2.730   1.241  1.00 13.64           C  
ATOM    270  N   LYS A  44      -1.417   1.703   4.958  1.00 13.77           N  
ATOM    271  CA  LYS A  44      -2.405   2.835   5.140  1.00  9.49           C  
ATOM    272  C   LYS A  44      -1.699   3.969   5.834  1.00 14.26           C  
ATOM    273  O   LYS A  44      -1.936   5.142   5.458  1.00 16.54           O  
ATOM    274  CB  LYS A  44      -3.671   2.368   5.770  1.00 15.84           C  
ATOM    275  CG  LYS A  44      -4.530   1.621   4.731  1.00 19.71           C  
ATOM    276  CD  LYS A  44      -5.840   1.140   5.264  1.00 20.66           C  
ATOM    277  CE  LYS A  44      -6.702   0.534   4.166  1.00 24.08           C  
ATOM    278  NZ  LYS A  44      -7.973   0.033   4.725  1.00 26.95           N  
ATOM    279  N   GLN A  45      -0.881   3.665   6.795  1.00 13.01           N  
ATOM    280  CA  GLN A  45      -0.119   4.720   7.556  1.00 14.05           C  
ATOM    281  C   GLN A  45       0.819   5.437   6.629  1.00 18.30           C  
ATOM    282  O   GLN A  45       0.899   6.690   6.559  1.00 18.58           O  
ATOM    283  CB  GLN A  45       0.527   4.160   8.790  1.00 20.21           C  
ATOM    284  CG  GLN A  45       1.225   5.226   9.670  1.00 16.68           C  
ATOM    285  CD  GLN A  45       2.029   4.560  10.761  1.00 53.74           C  
ATOM    286  OE1 GLN A  45       3.243   4.725  10.854  1.00 54.34           O  
ATOM    287  NE2 GLN A  45       1.337   3.768  11.569  1.00 48.24           N  
ATOM    288  N   TYR A  46       1.627   4.687   5.849  1.00 14.28           N  
ATOM    289  CA  TYR A  46       2.522   5.258   4.842  1.00 12.17           C  
ATOM    290  C   TYR A  46       1.761   6.148   3.894  1.00  9.89           C  
ATOM    291  O   TYR A  46       2.250   7.280   3.606  1.00 13.02           O  
ATOM    292  CB  TYR A  46       3.167   4.020   4.039  1.00 10.12           C  
ATOM    293  CG  TYR A  46       3.788   4.337   2.734  1.00 11.07           C  
ATOM    294  CD1 TYR A  46       5.056   4.919   2.631  1.00 16.85           C  
ATOM    295  CD2 TYR A  46       3.060   4.224   1.521  1.00 15.89           C  
ATOM    296  CE1 TYR A  46       5.627   5.239   1.405  1.00 18.83           C  
ATOM    297  CE2 TYR A  46       3.607   4.550   0.302  1.00 15.83           C  
ATOM    298  CZ  TYR A  46       4.908   5.083   0.246  1.00 17.38           C  
ATOM    299  OH  TYR A  46       5.454   5.415  -0.954  1.00 21.74           O  
ATOM    300  N   ALA A  47       0.644   5.703   3.349  1.00 13.37           N  
ATOM    301  CA  ALA A  47      -0.075   6.490   2.348  1.00 14.84           C  
ATOM    302  C   ALA A  47      -0.492   7.863   3.007  1.00  8.76           C  
ATOM    303  O   ALA A  47      -0.125   8.869   2.371  1.00 15.52           O  
ATOM    304  CB  ALA A  47      -1.233   5.798   1.726  1.00 14.41           C  
ATOM    305  N   ASN A  48      -1.140   7.729   4.096  1.00 12.34           N  
ATOM    306  CA  ASN A  48      -1.624   9.002   4.808  1.00 11.92           C  
ATOM    307  C   ASN A  48      -0.447   9.894   5.113  1.00 18.77           C  
ATOM    308  O   ASN A  48      -0.606  11.110   4.890  1.00 17.38           O  
ATOM    309  CB  ASN A  48      -2.504   8.622   5.952  1.00 12.80           C  
ATOM    310  CG  ASN A  48      -2.914   9.894   6.815  1.00  8.35           C  
ATOM    311  OD1 ASN A  48      -2.304  10.028   7.840  1.00 10.85           O  
ATOM    312  ND2 ASN A  48      -3.851  10.605   6.183  1.00 12.04           N  
ATOM    313  N   ASP A  49       0.627   9.390   5.664  1.00 14.00           N  
ATOM    314  CA  ASP A  49       1.809  10.209   5.987  1.00 16.69           C  
ATOM    315  C   ASP A  49       2.314  10.987   4.800  1.00 18.74           C  
ATOM    316  O   ASP A  49       2.904  12.092   4.956  1.00 23.15           O  
ATOM    317  CB  ASP A  49       2.941   9.342   6.551  1.00 14.94           C  
ATOM    318  CG  ASP A  49       2.737   8.792   7.904  1.00 19.86           C  
ATOM    319  OD1 ASP A  49       1.793   9.119   8.660  1.00 28.99           O  
ATOM    320  OD2 ASP A  49       3.520   7.905   8.312  1.00 28.71           O  
ATOM    321  N   ASN A  50       2.200  10.433   3.612  1.00 13.98           N  
ATOM    322  CA  ASN A  50       2.636  10.963   2.366  1.00 14.64           C  
ATOM    323  C   ASN A  50       1.552  11.736   1.650  1.00 15.52           C  
ATOM    324  O   ASN A  50       1.758  12.104   0.486  1.00 27.61           O  
ATOM    325  CB  ASN A  50       3.277   9.864   1.456  1.00 18.31           C  
ATOM    326  CG  ASN A  50       4.643   9.468   1.985  1.00 22.42           C  
ATOM    327  OD1 ASN A  50       5.572  10.278   1.969  1.00 31.83           O  
ATOM    328  ND2 ASN A  50       4.744   8.248   2.441  1.00 20.63           N  
ATOM    329  N   GLY A  51       0.457  11.991   2.325  1.00 23.61           N  
ATOM    330  CA  GLY A  51      -0.667  12.744   1.792  1.00 27.07           C  
ATOM    331  C   GLY A  51      -1.504  12.080   0.740  1.00 32.99           C  
ATOM    332  O   GLY A  51      -2.165  12.775  -0.065  1.00 24.13           O  
ATOM    333  N   VAL A  52      -1.551  10.764   0.688  1.00 16.52           N  
ATOM    334  CA  VAL A  52      -2.340   9.988  -0.244  1.00 14.73           C  
ATOM    335  C   VAL A  52      -3.399   9.256   0.574  1.00 15.76           C  
ATOM    336  O   VAL A  52      -3.090   8.552   1.532  1.00 22.22           O  
ATOM    337  CB  VAL A  52      -1.463   9.059  -1.124  1.00 22.77           C  
ATOM    338  CG1 VAL A  52      -2.291   8.116  -1.996  1.00 20.49           C  
ATOM    339  CG2 VAL A  52      -0.481   9.830  -1.976  1.00 23.87           C  
ATOM    340  N   ASP A  53      -4.630   9.528   0.248  1.00 14.97           N  
ATOM    341  CA  ASP A  53      -5.796   8.898   0.919  1.00 14.62           C  
ATOM    342  C   ASP A  53      -6.725   8.616  -0.263  1.00 13.40           C  
ATOM    343  O   ASP A  53      -6.789   9.447  -1.169  1.00 14.33           O  
ATOM    344  CB  ASP A  53      -6.419   9.780   2.016  1.00 17.55           C  
ATOM    345  CG  ASP A  53      -5.449  10.102   3.164  1.00 14.29           C  
ATOM    346  OD1 ASP A  53      -5.323   9.277   4.035  1.00 18.82           O  
ATOM    347  OD2 ASP A  53      -4.842  11.192   3.126  1.00 29.62           O  
ATOM    348  N   GLY A  54      -7.331   7.433  -0.247  1.00 13.22           N  
ATOM    349  CA  GLY A  54      -8.188   7.056  -1.367  1.00 12.57           C  
ATOM    350  C   GLY A  54      -8.874   5.707  -1.106  1.00  8.43           C  
ATOM    351  O   GLY A  54      -9.178   5.362   0.013  1.00 19.45           O  
ATOM    352  N   VAL A  55      -9.116   5.086  -2.253  1.00 10.48           N  
ATOM    353  CA  VAL A  55      -9.820   3.773  -2.265  1.00  7.97           C  
ATOM    354  C   VAL A  55      -8.720   2.652  -2.514  1.00  7.08           C  
ATOM    355  O   VAL A  55      -7.797   2.935  -3.220  1.00 10.48           O  
ATOM    356  CB  VAL A  55     -10.850   3.784  -3.380  1.00 10.96           C  
ATOM    357  CG1 VAL A  55     -12.085   4.615  -2.913  1.00 27.14           C  
ATOM    358  CG2 VAL A  55     -10.434   4.138  -4.746  1.00  8.72           C  
ATOM    359  N   TRP A  56      -9.034   1.572  -1.821  1.00 10.45           N  
ATOM    360  CA  TRP A  56      -7.980   0.491  -1.859  1.00  9.54           C  
ATOM    361  C   TRP A  56      -8.539  -0.855  -2.381  1.00  8.98           C  
ATOM    362  O   TRP A  56      -9.664  -1.181  -2.199  1.00  9.33           O  
ATOM    363  CB  TRP A  56      -7.644   0.244  -0.379  1.00 12.00           C  
ATOM    364  CG  TRP A  56      -6.856   1.343   0.247  1.00 16.82           C  
ATOM    365  CD1 TRP A  56      -7.337   2.561   0.700  1.00 18.63           C  
ATOM    366  CD2 TRP A  56      -5.470   1.329   0.570  1.00 13.85           C  
ATOM    367  NE1 TRP A  56      -6.325   3.294   1.218  1.00 13.47           N  
ATOM    368  CE2 TRP A  56      -5.150   2.568   1.169  1.00  9.74           C  
ATOM    369  CE3 TRP A  56      -4.450   0.381   0.376  1.00 13.63           C  
ATOM    370  CZ2 TRP A  56      -3.873   2.933   1.525  1.00 13.82           C  
ATOM    371  CZ3 TRP A  56      -3.182   0.717   0.796  1.00 10.55           C  
ATOM    372  CH2 TRP A  56      -2.878   1.965   1.376  1.00 17.35           C  
ATOM    373  N   THR A  57      -7.496  -1.582  -2.833  1.00 12.30           N  
ATOM    374  CA  THR A  57      -7.792  -3.028  -3.204  1.00  7.74           C  
ATOM    375  C   THR A  57      -6.621  -3.822  -2.584  1.00 11.88           C  
ATOM    376  O   THR A  57      -5.534  -3.326  -2.374  1.00 10.41           O  
ATOM    377  CB  THR A  57      -7.844  -3.297  -4.706  1.00  7.14           C  
ATOM    378  OG1 THR A  57      -6.501  -3.075  -5.300  1.00 11.05           O  
ATOM    379  CG2 THR A  57      -8.880  -2.586  -5.576  1.00 11.90           C  
ATOM    380  N   TYR A  58      -6.928  -5.106  -2.405  1.00  9.95           N  
ATOM    381  CA  TYR A  58      -5.867  -6.028  -1.959  1.00  6.57           C  
ATOM    382  C   TYR A  58      -6.094  -7.375  -2.718  1.00 12.83           C  
ATOM    383  O   TYR A  58      -7.241  -7.808  -2.695  1.00 11.86           O  
ATOM    384  CB  TYR A  58      -5.954  -6.299  -0.442  1.00  8.76           C  
ATOM    385  CG  TYR A  58      -4.993  -7.414  -0.002  1.00  8.73           C  
ATOM    386  CD1 TYR A  58      -3.625  -7.254  -0.247  1.00 11.75           C  
ATOM    387  CD2 TYR A  58      -5.480  -8.569   0.532  1.00 17.90           C  
ATOM    388  CE1 TYR A  58      -2.725  -8.263   0.121  1.00 15.75           C  
ATOM    389  CE2 TYR A  58      -4.587  -9.575   0.914  1.00 15.20           C  
ATOM    390  CZ  TYR A  58      -3.239  -9.413   0.687  1.00 22.51           C  
ATOM    391  OH  TYR A  58      -2.380 -10.430   1.046  1.00 20.20           O  
ATOM    392  N   ASP A  59      -4.956  -7.912  -3.208  1.00 10.25           N  
ATOM    393  CA  ASP A  59      -5.134  -9.290  -3.831  1.00 10.54           C  
ATOM    394  C   ASP A  59      -4.265 -10.239  -2.990  1.00 12.34           C  
ATOM    395  O   ASP A  59      -3.035 -10.117  -3.048  1.00 15.22           O  
ATOM    396  CB  ASP A  59      -4.780  -9.305  -5.282  1.00 14.51           C  
ATOM    397  CG  ASP A  59      -5.187 -10.638  -5.982  1.00 16.86           C  
ATOM    398  OD1 ASP A  59      -5.495 -11.601  -5.278  1.00 20.92           O  
ATOM    399  OD2 ASP A  59      -5.318 -10.592  -7.194  1.00 25.94           O  
ATOM    400  N   ASP A  60      -4.938 -11.172  -2.355  1.00 12.83           N  
ATOM    401  CA  ASP A  60      -4.225 -12.119  -1.491  1.00 11.91           C  
ATOM    402  C   ASP A  60      -3.402 -13.100  -2.367  1.00 16.66           C  
ATOM    403  O   ASP A  60      -2.424 -13.684  -1.845  1.00 19.70           O  
ATOM    404  CB  ASP A  60      -5.136 -12.797  -0.505  1.00 18.11           C  
ATOM    405  CG  ASP A  60      -4.405 -13.472   0.623  1.00 23.06           C  
ATOM    406  OD1 ASP A  60      -3.615 -12.806   1.336  1.00 27.28           O  
ATOM    407  OD2 ASP A  60      -4.598 -14.687   0.783  1.00 33.81           O  
ATOM    408  N   ALA A  61      -3.826 -13.235  -3.590  1.00 15.81           N  
ATOM    409  CA  ALA A  61      -3.082 -14.144  -4.525  1.00 21.92           C  
ATOM    410  C   ALA A  61      -1.729 -13.563  -4.869  1.00 24.48           C  
ATOM    411  O   ALA A  61      -0.716 -14.293  -4.949  1.00 21.40           O  
ATOM    412  CB  ALA A  61      -3.926 -14.472  -5.729  1.00 23.08           C  
ATOM    413  N   THR A  62      -1.629 -12.263  -5.048  1.00 19.20           N  
ATOM    414  CA  THR A  62      -0.420 -11.565  -5.432  1.00 15.23           C  
ATOM    415  C   THR A  62       0.242 -10.775  -4.291  1.00 13.58           C  
ATOM    416  O   THR A  62       1.280 -10.120  -4.553  1.00 17.11           O  
ATOM    417  CB  THR A  62      -0.688 -10.620  -6.664  1.00 28.36           C  
ATOM    418  OG1 THR A  62      -1.587  -9.557  -6.166  1.00 19.30           O  
ATOM    419  CG2 THR A  62      -1.302 -11.341  -7.885  1.00 23.90           C  
ATOM    420  N   LYS A  63      -0.352 -10.762  -3.132  1.00 11.86           N  
ATOM    421  CA  LYS A  63       0.117 -10.067  -1.928  1.00 10.98           C  
ATOM    422  C   LYS A  63       0.363  -8.584  -2.324  1.00  9.95           C  
ATOM    423  O   LYS A  63       1.322  -7.961  -1.877  1.00 13.67           O  
ATOM    424  CB  LYS A  63       1.386 -10.679  -1.371  1.00 12.61           C  
ATOM    425  CG  LYS A  63       1.289 -12.173  -1.060  1.00 18.95           C  
ATOM    426  CD  LYS A  63       0.418 -12.503   0.084  1.00 21.61           C  
ATOM    427  CE  LYS A  63       0.292 -13.967   0.431  1.00 24.56           C  
ATOM    428  NZ  LYS A  63      -0.280 -14.752  -0.696  1.00 33.75           N  
ATOM    429  N   THR A  64      -0.607  -8.083  -3.070  1.00 11.52           N  
ATOM    430  CA  THR A  64      -0.495  -6.679  -3.514  1.00 11.49           C  
ATOM    431  C   THR A  64      -1.754  -5.845  -3.119  1.00  7.83           C  
ATOM    432  O   THR A  64      -2.855  -6.196  -3.476  1.00  9.59           O  
ATOM    433  CB  THR A  64      -0.276  -6.549  -5.047  1.00 15.41           C  
ATOM    434  OG1 THR A  64       0.866  -7.417  -5.392  1.00 14.57           O  
ATOM    435  CG2 THR A  64       0.039  -5.104  -5.511  1.00 11.47           C  
ATOM    436  N   PHE A  65      -1.378  -4.690  -2.541  1.00  9.16           N  
ATOM    437  CA  PHE A  65      -2.394  -3.631  -2.245  1.00 12.41           C  
ATOM    438  C   PHE A  65      -2.201  -2.538  -3.304  1.00  6.62           C  
ATOM    439  O   PHE A  65      -1.121  -2.287  -3.820  1.00 10.40           O  
ATOM    440  CB  PHE A  65      -2.066  -3.000  -0.872  1.00  5.98           C  
ATOM    441  CG  PHE A  65      -2.261  -3.865   0.312  1.00 12.50           C  
ATOM    442  CD1 PHE A  65      -1.243  -4.732   0.739  1.00 11.85           C  
ATOM    443  CD2 PHE A  65      -3.474  -3.845   0.991  1.00 12.34           C  
ATOM    444  CE1 PHE A  65      -1.466  -5.490   1.895  1.00  8.62           C  
ATOM    445  CE2 PHE A  65      -3.711  -4.571   2.120  1.00 14.10           C  
ATOM    446  CZ  PHE A  65      -2.688  -5.432   2.568  1.00 20.27           C  
ATOM    447  N   THR A  66      -3.352  -1.898  -3.626  1.00  9.98           N  
ATOM    448  CA  THR A  66      -3.285  -0.758  -4.546  1.00  8.94           C  
ATOM    449  C   THR A  66      -4.113   0.392  -3.816  1.00  6.92           C  
ATOM    450  O   THR A  66      -5.149   0.079  -3.287  1.00 11.30           O  
ATOM    451  CB  THR A  66      -3.931  -0.977  -5.950  1.00 13.87           C  
ATOM    452  OG1 THR A  66      -3.258  -2.187  -6.541  1.00 14.57           O  
ATOM    453  CG2 THR A  66      -3.803   0.190  -6.908  1.00 22.27           C  
ATOM    454  N   VAL A  67      -3.525   1.554  -3.966  1.00  7.88           N  
ATOM    455  CA  VAL A  67      -4.371   2.741  -3.409  1.00  9.66           C  
ATOM    456  C   VAL A  67      -4.510   3.660  -4.593  1.00  6.94           C  
ATOM    457  O   VAL A  67      -3.561   3.951  -5.326  1.00 10.55           O  
ATOM    458  CB  VAL A  67      -3.749   3.329  -2.164  1.00 10.09           C  
ATOM    459  CG1 VAL A  67      -2.352   3.915  -2.384  1.00 13.76           C  
ATOM    460  CG2 VAL A  67      -4.680   4.452  -1.599  1.00 12.34           C  
ATOM    461  N   THR A  68      -5.769   4.148  -4.769  1.00  8.38           N  
ATOM    462  CA  THR A  68      -6.027   5.070  -5.873  1.00  8.03           C  
ATOM    463  C   THR A  68      -6.449   6.377  -5.097  1.00 10.26           C  
ATOM    464  O   THR A  68      -7.392   6.297  -4.340  1.00 13.95           O  
ATOM    465  CB  THR A  68      -7.171   4.630  -6.836  1.00 16.42           C  
ATOM    466  OG1 THR A  68      -6.724   3.331  -7.395  1.00 21.74           O  
ATOM    467  CG2 THR A  68      -7.357   5.596  -8.024  1.00 18.21           C  
ATOM    468  N   GLU A  69      -5.654   7.396  -5.359  1.00 16.11           N  
ATOM    469  CA  GLU A  69      -5.951   8.644  -4.579  1.00 18.75           C  
ATOM    470  C   GLU A  69      -7.210   9.269  -5.148  1.00 15.61           C  
ATOM    471  O   GLU A  69      -7.435   9.271  -6.373  1.00 16.94           O  
ATOM    472  CB  GLU A  69      -4.818   9.637  -4.710  1.00 21.30           C  
ATOM    473  CG  GLU A  69      -4.927  10.904  -3.833  1.00 22.73           C  
ATOM    474  CD  GLU A  69      -3.803  11.870  -3.848  1.00 32.96           C  
ATOM    475  OE1 GLU A  69      -2.920  11.657  -4.697  1.00 24.92           O  
ATOM    476  OE2 GLU A  69      -3.777  12.838  -3.075  1.00 38.73           O  
ATOM    477  N   MET A  70      -7.951   9.836  -4.181  1.00 21.20           N  
ATOM    478  CA  MET A  70      -9.200  10.555  -4.534  1.00 20.05           C  
ATOM    479  C   MET A  70      -8.896  12.052  -4.396  1.00 31.57           C  
ATOM    480  O   MET A  70      -8.472  12.514  -3.334  1.00 31.95           O  
ATOM    481  CB  MET A  70     -10.348  10.078  -3.680  1.00 32.64           C  
ATOM    482  CG  MET A  70     -10.679   8.649  -4.110  0.50 36.46           C  
ATOM    484  SD  MET A  70     -12.364   8.264  -3.578  0.50 47.82           S  
ATOM    486  CE  MET A  70     -12.172   8.230  -1.796  0.50 14.06           C  
ATOM    488  N   VAL A  71      -9.100  12.718  -5.498  1.00 42.38           N  
ATOM    489  CA  VAL A  71      -8.870  14.153  -5.626  1.00 48.21           C  
ATOM    490  C   VAL A  71      -9.955  14.957  -4.892  1.00 25.72           C  
ATOM    491  O   VAL A  71     -11.142  14.598  -4.906  1.00 45.41           O  
ATOM    492  CB  VAL A  71      -8.734  14.499  -7.119  1.00 49.57           C  
ATOM    493  CG1 VAL A  71      -7.605  13.732  -7.819  1.00 52.39           C  
ATOM    494  CG2 VAL A  71     -10.034  14.366  -7.899  1.00 48.64           C  
ATOM    495  N   THR A  72      -9.498  16.030  -4.252  1.00 31.74           N  
ATOM    496  CA  THR A  72     -10.441  16.940  -3.520  1.00 38.06           C  
ATOM    497  C   THR A  72     -10.542  18.202  -4.348  1.00 45.12           C  
ATOM    498  O   THR A  72      -9.597  19.015  -4.338  1.00 58.73           O  
ATOM    499  CB  THR A  72     -10.054  17.130  -2.024  1.00 54.77           C  
ATOM    500  OG1 THR A  72     -10.569  15.957  -1.299  1.00 46.17           O  
ATOM    501  CG2 THR A  72     -10.483  18.429  -1.326  1.00 51.40           C  
ATOM    502  N   GLU A  73     -11.663  18.319  -5.060  1.00 27.12           N  
ATOM    503  CA  GLU A  73     -11.842  19.510  -5.898  1.00 32.13           C  
ATOM    504  C   GLU A  73     -12.913  20.424  -5.275  1.00 28.28           C  
ATOM    505  O   GLU A  73     -13.743  19.955  -4.486  1.00 33.11           O  
ATOM    506  CB  GLU A  73     -12.226  19.219  -7.329  1.00 30.00           C  
ATOM    507  CG  GLU A  73     -13.637  18.895  -7.779  1.00 42.96           C  
ATOM    508  CD  GLU A  73     -14.219  19.684  -8.895  1.00 47.55           C  
ATOM    509  OE1 GLU A  73     -13.399  20.067  -9.764  1.00 64.75           O  
ATOM    510  OE2 GLU A  73     -15.423  19.928  -9.030  1.00 42.76           O  
ATOM    511  N   VAL A  74     -12.900  21.654  -5.711  1.00 28.37           N  
ATOM    512  CA  VAL A  74     -13.915  22.669  -5.308  1.00 30.71           C  
ATOM    513  C   VAL A  74     -14.756  22.933  -6.558  1.00 32.30           C  
ATOM    514  O   VAL A  74     -14.279  22.680  -7.687  1.00 32.70           O  
ATOM    515  CB  VAL A  74     -13.242  23.899  -4.690  1.00 36.58           C  
ATOM    516  CG1 VAL A  74     -12.519  23.625  -3.381  1.00 29.36           C  
ATOM    517  CG2 VAL A  74     -12.287  24.603  -5.642  1.00 35.85           C  
ATOM    518  N   PRO A  75     -15.968  23.440  -6.344  1.00 25.70           N  
ATOM    519  CA  PRO A  75     -16.881  23.705  -7.465  1.00 23.29           C  
ATOM    520  C   PRO A  75     -16.385  24.768  -8.409  1.00 32.34           C  
ATOM    521  O   PRO A  75     -15.574  25.627  -8.024  1.00 35.43           O  
ATOM    522  CB  PRO A  75     -18.224  24.023  -6.819  1.00 18.74           C  
ATOM    523  CG  PRO A  75     -18.086  23.749  -5.357  1.00 19.57           C  
ATOM    524  CD  PRO A  75     -16.581  23.744  -5.045  1.00 26.36           C  
ATOM    525  N   VAL A  76     -16.899  24.722  -9.636  0.50 23.36           N  
ATOM    526  CA  VAL A  76     -16.509  25.635 -10.702  0.50 38.10           C  
ATOM    527  C   VAL A  76     -17.584  26.161 -11.586  0.50 45.57           C  
ATOM    528  O   VAL A  76     -17.516  26.064 -12.852  0.50 52.62           O  
ATOM    529  CB  VAL A  76     -15.218  25.082 -11.354  0.50 52.85           C  
ATOM    530  CG1 VAL A  76     -15.326  23.665 -11.912  0.50 37.46           C  
ATOM    531  CG2 VAL A  76     -14.503  25.977 -12.334  0.50 53.07           C  
ATOM    532  N   ALA A  77     -18.606  26.824 -11.003  0.50 53.92           N  
ATOM    533  CA  ALA A  77     -19.661  27.428 -11.833  0.50 44.53           C  
ATOM    534  C   ALA A  77     -19.080  28.697 -12.466  0.50 50.12           C  
ATOM    535  O   ALA A  77     -19.365  28.966 -13.641  0.50 55.49           O  
ATOM    536  CB  ALA A  77     -20.972  27.677 -11.162  0.50 49.04           C  
TER     537      ALA A  77                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
