
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  866),  selected   56 , name 1fcl_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1fcl_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     1_A      T       1          3.047
LGA    T     2_A      T       2          0.832
LGA    F     3_A      Y       3          0.581
LGA    K     4_A      K       4          0.576
LGA    L     5_A      L       5          0.603
LGA    I     6_A      I       6          0.530
LGA    I     7_A      L       7          0.425
LGA    N     8_A      N       8          1.226
LGA    G     9_A      L       9          1.131
LGA    K    10_A      K      10          1.349
LGA    T    11_A      Q      11          2.035
LGA    L    12_A      A      12          2.856
LGA    K    13_A      K      13          1.406
LGA    G    14_A      E      14          2.077
LGA    E    15_A      E      15          1.264
LGA    T    16_A      A      16          1.810
LGA    T    17_A      I      17          1.084
LGA    T    18_A      K      18          0.536
LGA    E    19_A      E      19          1.489
LGA    A    20_A      A      20          1.836
LGA    V    21_A      V      21          2.585
LGA    D    22_A      D      22          1.599
LGA    A    23_A      A      23          2.035
LGA    A    24_A      G      24          2.978
LGA    T    25_A      T      25          2.382
LGA    A    26_A      A      26          1.106
LGA    E    27_A      E      27          1.475
LGA    K    28_A      K      28          1.403
LGA    V    29_A      Y      29          1.209
LGA    L    30_A      F      30          0.933
LGA    K    31_A      K      31          1.196
LGA    Q    32_A      L      32          1.030
LGA    Y    33_A      I      33          0.756
LGA    I    34_A      A      34          1.514
LGA    N    35_A      N      35          1.886
LGA    D    36_A      A      36          2.156
LGA    N    37_A      K      37          1.793
LGA    G    38_A      T      38          1.791
LGA    I    39_A      V      39          3.865
LGA    D    40_A      E      40          3.065
LGA    G    41_A      G      41          2.510
LGA    E    42_A      V      42          1.837
LGA    W    43_A      W      43          1.213
LGA    T    44_A      T      44          0.916
LGA    Y    45_A      Y      45          1.095
LGA    D    46_A      K      46          1.255
LGA    D    47_A      D      47          1.322
LGA    A    48_A      E      48          1.532
LGA    T    49_A      I      49          0.691
LGA    K    50_A      K      50          0.509
LGA    T    51_A      T      51          1.067
LGA    W    52_A      F      52          0.953
LGA    T    53_A      T      53          0.224
LGA    V    54_A      V      54          0.703
LGA    T    55_A      T      55          1.343
LGA    E    56_A      E      56          2.252

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   56    5.0     56    1.67    55.36     91.009     3.170

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.272378 * X  +  -0.151521 * Y  +   0.950185 * Z  +  -0.281806
  Y_new =  -0.884922 * X  +  -0.427183 * Y  +   0.185549 * Z  +  -0.365845
  Z_new =   0.377788 * X  +  -0.891379 * Y  +  -0.250439 * Z  +   0.322630 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.844692    1.296901  [ DEG:  -105.6931     74.3069 ]
  Theta =  -0.387406   -2.754186  [ DEG:   -22.1968   -157.8033 ]
  Phi   =  -1.272200    1.869392  [ DEG:   -72.8917    107.1083 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1fcl_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1fcl_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   56   5.0   56   1.67   55.36  91.009
REMARK  ---------------------------------------------------------- 
MOLECULE 1fcl_A
HEADER    PROTEIN BINDING                         18-JUL-00   1FCL              
TITLE     DELTA1.5: A COMPUTATIONALLY DESIGNED CORE VARIANT OF THE B1           
TITLE    2 DOMAIN OF STREPTOCOCCAL PROTEIN G                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: IMMUNOGLOBULIN G BINDING PROTEIN G;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: GB1_DELTA1.5;                                              
COMPND   5 SYNONYM: IGG BINDING PROTEIN G;                                      
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP.;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    DESIGNED CORE MUTANT, STREPTOCOCCAL PROTEIN G                         
EXPDTA    NMR, 40 STRUCTURES                                                    
AUTHOR    S.A.ROSS,C.A.SARISKY,A.SU,S.L.MAYO                                    
REVDAT   1   19-SEP-01 1FCL    0                                                
JRNL        AUTH   S.A.ROSS,C.A.SARISKY,A.SU,S.L.MAYO                           
JRNL        TITL   DESIGNED PROTEIN G CORE VARIANTS FOLD TO                     
JRNL        TITL 2 NATIVE-LIKE STRUCTURES: SEQUENCE SELECTION BY                
JRNL        TITL 3 ORBIT TOLERATES VARIATION IN BACKBONE                        
JRNL        TITL 4 SPECIFICATION.                                               
JRNL        REF    PROTEIN SCI.                  V.  10   450 2001              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1FCL A    1    56  UNP    P19909   SPG2_STRSG     302    357             
SEQRES   1 A   56  THR THR PHE LYS LEU ILE ILE ASN GLY LYS THR LEU LYS          
SEQRES   2 A   56  GLY GLU THR THR THR GLU ALA VAL ASP ALA ALA THR ALA          
SEQRES   3 A   56  GLU LYS VAL LEU LYS GLN TYR ILE ASN ASP ASN GLY ILE          
SEQRES   4 A   56  ASP GLY GLU TRP THR TYR ASP ASP ALA THR LYS THR TRP          
SEQRES   5 A   56  THR VAL THR GLU                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   THR A   1       7.708 -14.597   1.828  0.00  0.00           N  
ATOM      2  CA  THR A   1       6.743 -13.793   1.024  0.00  0.00           C  
ATOM      3  C   THR A   1       6.595 -12.391   1.623  0.00  0.00           C  
ATOM      4  O   THR A   1       6.494 -12.229   2.825  0.00  0.00           O  
ATOM      5  CB  THR A   1       5.420 -14.556   1.112  0.00  0.00           C  
ATOM      6  OG1 THR A   1       5.617 -15.893   0.679  0.00  0.00           O  
ATOM      7  CG2 THR A   1       4.377 -13.877   0.224  0.00  0.00           C  
ATOM      8  HA  THR A   1       7.066 -13.732  -0.003  0.00  0.00           H  
ATOM      9  HB  THR A   1       5.071 -14.555   2.134  0.00  0.00           H  
ATOM     10  HG1 THR A   1       5.839 -16.425   1.446  0.00  0.00           H  
ATOM     11 HG21 THR A   1       4.040 -12.966   0.695  0.00  0.00           H  
ATOM     12 HG22 THR A   1       3.536 -14.541   0.082  0.00  0.00           H  
ATOM     13 HG23 THR A   1       4.817 -13.645  -0.735  0.00  0.00           H  
ATOM     14  H1  THR A   1       8.646 -14.152   1.791  0.00  0.00           H  
ATOM     15  H2  THR A   1       7.764 -15.561   1.438  0.00  0.00           H  
ATOM     16  H3  THR A   1       7.385 -14.640   2.816  0.00  0.00           H  
ATOM     17  N   THR A   2       6.582 -11.380   0.792  0.00  0.00           N  
ATOM     18  CA  THR A   2       6.441  -9.984   1.302  0.00  0.00           C  
ATOM     19  C   THR A   2       5.206  -9.319   0.692  0.00  0.00           C  
ATOM     20  O   THR A   2       4.908  -9.496  -0.475  0.00  0.00           O  
ATOM     21  CB  THR A   2       7.715  -9.267   0.853  0.00  0.00           C  
ATOM     22  OG1 THR A   2       8.844 -10.070   1.164  0.00  0.00           O  
ATOM     23  CG2 THR A   2       7.827  -7.922   1.574  0.00  0.00           C  
ATOM     24  H   THR A   2       6.666 -11.540  -0.172  0.00  0.00           H  
ATOM     25  HA  THR A   2       6.378  -9.981   2.379  0.00  0.00           H  
ATOM     26  HB  THR A   2       7.675  -9.096  -0.213  0.00  0.00           H  
ATOM     27  HG1 THR A   2       9.633  -9.588   0.905  0.00  0.00           H  
ATOM     28 HG21 THR A   2       8.648  -7.357   1.156  0.00  0.00           H  
ATOM     29 HG22 THR A   2       8.005  -8.092   2.625  0.00  0.00           H  
ATOM     30 HG23 THR A   2       6.909  -7.369   1.448  0.00  0.00           H  
ATOM     31  N   PHE A   3       4.487  -8.555   1.473  0.00  0.00           N  
ATOM     32  CA  PHE A   3       3.266  -7.871   0.946  0.00  0.00           C  
ATOM     33  C   PHE A   3       3.671  -6.756  -0.025  0.00  0.00           C  
ATOM     34  O   PHE A   3       4.810  -6.331  -0.048  0.00  0.00           O  
ATOM     35  CB  PHE A   3       2.563  -7.287   2.179  0.00  0.00           C  
ATOM     36  CG  PHE A   3       2.204  -8.402   3.139  0.00  0.00           C  
ATOM     37  CD1 PHE A   3       1.472  -9.507   2.687  0.00  0.00           C  
ATOM     38  CD2 PHE A   3       2.606  -8.332   4.479  0.00  0.00           C  
ATOM     39  CE1 PHE A   3       1.142 -10.539   3.572  0.00  0.00           C  
ATOM     40  CE2 PHE A   3       2.275  -9.364   5.365  0.00  0.00           C  
ATOM     41  CZ  PHE A   3       1.544 -10.469   4.910  0.00  0.00           C  
ATOM     42  H   PHE A   3       4.753  -8.430   2.409  0.00  0.00           H  
ATOM     43  HA  PHE A   3       2.619  -8.581   0.455  0.00  0.00           H  
ATOM     44  HB2 PHE A   3       3.224  -6.589   2.672  0.00  0.00           H  
ATOM     45  HB3 PHE A   3       1.664  -6.775   1.871  0.00  0.00           H  
ATOM     46  HD1 PHE A   3       1.162  -9.562   1.653  0.00  0.00           H  
ATOM     47  HD2 PHE A   3       3.170  -7.479   4.832  0.00  0.00           H  
ATOM     48  HE1 PHE A   3       0.577 -11.391   3.222  0.00  0.00           H  
ATOM     49  HE2 PHE A   3       2.585  -9.310   6.398  0.00  0.00           H  
ATOM     50  HZ  PHE A   3       1.290 -11.266   5.593  0.00  0.00           H  
ATOM     51  N   LYS A   4       2.747  -6.284  -0.827  0.00  0.00           N  
ATOM     52  CA  LYS A   4       3.081  -5.198  -1.799  0.00  0.00           C  
ATOM     53  C   LYS A   4       1.915  -4.218  -1.936  0.00  0.00           C  
ATOM     54  O   LYS A   4       0.765  -4.587  -1.801  0.00  0.00           O  
ATOM     55  CB  LYS A   4       3.324  -5.907  -3.132  0.00  0.00           C  
ATOM     56  CG  LYS A   4       3.936  -4.919  -4.128  0.00  0.00           C  
ATOM     57  CD  LYS A   4       4.187  -5.625  -5.462  0.00  0.00           C  
ATOM     58  CE  LYS A   4       3.906  -4.659  -6.619  0.00  0.00           C  
ATOM     59  NZ  LYS A   4       5.248  -4.292  -7.152  0.00  0.00           N  
ATOM     60  H   LYS A   4       1.837  -6.645  -0.791  0.00  0.00           H  
ATOM     61  HA  LYS A   4       3.975  -4.678  -1.492  0.00  0.00           H  
ATOM     62  HB2 LYS A   4       3.993  -6.738  -2.983  0.00  0.00           H  
ATOM     63  HB3 LYS A   4       2.389  -6.268  -3.522  0.00  0.00           H  
ATOM     64  HG2 LYS A   4       3.255  -4.094  -4.279  0.00  0.00           H  
ATOM     65  HG3 LYS A   4       4.870  -4.546  -3.739  0.00  0.00           H  
ATOM     66  HD2 LYS A   4       5.216  -5.953  -5.506  0.00  0.00           H  
ATOM     67  HD3 LYS A   4       3.535  -6.482  -5.544  0.00  0.00           H  
ATOM     68  HE2 LYS A   4       3.318  -5.151  -7.383  0.00  0.00           H  
ATOM     69  HE3 LYS A   4       3.396  -3.776  -6.262  0.00  0.00           H  
ATOM     70  HZ1 LYS A   4       5.864  -3.999  -6.368  0.00  0.00           H  
ATOM     71  HZ2 LYS A   4       5.149  -3.508  -7.830  0.00  0.00           H  
ATOM     72  HZ3 LYS A   4       5.668  -5.113  -7.631  0.00  0.00           H  
ATOM     73  N   LEU A   5       2.210  -2.976  -2.220  0.00  0.00           N  
ATOM     74  CA  LEU A   5       1.135  -1.956  -2.387  0.00  0.00           C  
ATOM     75  C   LEU A   5       1.557  -0.932  -3.441  0.00  0.00           C  
ATOM     76  O   LEU A   5       2.692  -0.495  -3.473  0.00  0.00           O  
ATOM     77  CB  LEU A   5       0.986  -1.284  -1.018  0.00  0.00           C  
ATOM     78  CG  LEU A   5      -0.459  -0.781  -0.842  0.00  0.00           C  
ATOM     79  CD1 LEU A   5      -1.019  -1.255   0.506  0.00  0.00           C  
ATOM     80  CD2 LEU A   5      -0.481   0.750  -0.890  0.00  0.00           C  
ATOM     81  H   LEU A   5       3.148  -2.715  -2.333  0.00  0.00           H  
ATOM     82  HA  LEU A   5       0.209  -2.429  -2.673  0.00  0.00           H  
ATOM     83  HB2 LEU A   5       1.226  -1.995  -0.242  0.00  0.00           H  
ATOM     84  HB3 LEU A   5       1.666  -0.448  -0.957  0.00  0.00           H  
ATOM     85  HG  LEU A   5      -1.077  -1.171  -1.638  0.00  0.00           H  
ATOM     86 HD11 LEU A   5      -2.104  -1.267   0.461  0.00  0.00           H  
ATOM     87 HD12 LEU A   5      -0.695  -0.584   1.289  0.00  0.00           H  
ATOM     88 HD13 LEU A   5      -0.659  -2.254   0.712  0.00  0.00           H  
ATOM     89 HD21 LEU A   5       0.183   1.146  -0.135  0.00  0.00           H  
ATOM     90 HD22 LEU A   5      -1.486   1.103  -0.705  0.00  0.00           H  
ATOM     91 HD23 LEU A   5      -0.156   1.084  -1.865  0.00  0.00           H  
ATOM     92  N   ILE A   6       0.652  -0.555  -4.304  0.00  0.00           N  
ATOM     93  CA  ILE A   6       0.990   0.436  -5.366  0.00  0.00           C  
ATOM     94  C   ILE A   6       0.335   1.785  -5.052  0.00  0.00           C  
ATOM     95  O   ILE A   6      -0.846   1.861  -4.766  0.00  0.00           O  
ATOM     96  CB  ILE A   6       0.424  -0.178  -6.650  0.00  0.00           C  
ATOM     97  CG1 ILE A   6       1.164  -1.496  -6.943  0.00  0.00           C  
ATOM     98  CG2 ILE A   6       0.595   0.793  -7.828  0.00  0.00           C  
ATOM     99  CD1 ILE A   6       2.655  -1.230  -7.192  0.00  0.00           C  
ATOM    100  H   ILE A   6      -0.253  -0.928  -4.256  0.00  0.00           H  
ATOM    101  HA  ILE A   6       2.059   0.546  -5.450  0.00  0.00           H  
ATOM    102  HB  ILE A   6      -0.624  -0.384  -6.509  0.00  0.00           H  
ATOM    103 HG12 ILE A   6       1.060  -2.157  -6.095  0.00  0.00           H  
ATOM    104 HG13 ILE A   6       0.734  -1.962  -7.817  0.00  0.00           H  
ATOM    105 HG21 ILE A   6      -0.344   1.293  -8.020  0.00  0.00           H  
ATOM    106 HG22 ILE A   6       0.895   0.244  -8.709  0.00  0.00           H  
ATOM    107 HG23 ILE A   6       1.350   1.526  -7.586  0.00  0.00           H  
ATOM    108 HD11 ILE A   6       2.954  -1.704  -8.116  0.00  0.00           H  
ATOM    109 HD12 ILE A   6       3.234  -1.637  -6.376  0.00  0.00           H  
ATOM    110 HD13 ILE A   6       2.828  -0.167  -7.260  0.00  0.00           H  
ATOM    111  N   ILE A   7       1.099   2.846  -5.103  0.00  0.00           N  
ATOM    112  CA  ILE A   7       0.537   4.197  -4.808  0.00  0.00           C  
ATOM    113  C   ILE A   7      -0.130   4.775  -6.059  0.00  0.00           C  
ATOM    114  O   ILE A   7       0.515   5.013  -7.062  0.00  0.00           O  
ATOM    115  CB  ILE A   7       1.742   5.050  -4.394  0.00  0.00           C  
ATOM    116  CG1 ILE A   7       2.413   4.428  -3.164  0.00  0.00           C  
ATOM    117  CG2 ILE A   7       1.278   6.468  -4.050  0.00  0.00           C  
ATOM    118  CD1 ILE A   7       3.758   5.113  -2.916  0.00  0.00           C  
ATOM    119  H   ILE A   7       2.047   2.752  -5.335  0.00  0.00           H  
ATOM    120  HA  ILE A   7      -0.170   4.141  -3.996  0.00  0.00           H  
ATOM    121  HB  ILE A   7       2.449   5.091  -5.209  0.00  0.00           H  
ATOM    122 HG12 ILE A   7       1.775   4.561  -2.302  0.00  0.00           H  
ATOM    123 HG13 ILE A   7       2.574   3.376  -3.336  0.00  0.00           H  
ATOM    124 HG21 ILE A   7       0.961   6.971  -4.951  0.00  0.00           H  
ATOM    125 HG22 ILE A   7       2.093   7.014  -3.600  0.00  0.00           H  
ATOM    126 HG23 ILE A   7       0.452   6.418  -3.356  0.00  0.00           H  
ATOM    127 HD11 ILE A   7       3.614   5.963  -2.264  0.00  0.00           H  
ATOM    128 HD12 ILE A   7       4.171   5.446  -3.856  0.00  0.00           H  
ATOM    129 HD13 ILE A   7       4.437   4.415  -2.451  0.00  0.00           H  
ATOM    130  N   ASN A   8      -1.416   5.004  -6.000  0.00  0.00           N  
ATOM    131  CA  ASN A   8      -2.136   5.573  -7.178  0.00  0.00           C  
ATOM    132  C   ASN A   8      -2.556   7.013  -6.883  0.00  0.00           C  
ATOM    133  O   ASN A   8      -3.706   7.379  -7.033  0.00  0.00           O  
ATOM    134  CB  ASN A   8      -3.361   4.678  -7.368  0.00  0.00           C  
ATOM    135  CG  ASN A   8      -2.950   3.398  -8.099  0.00  0.00           C  
ATOM    136  OD1 ASN A   8      -1.809   2.989  -8.036  0.00  0.00           O  
ATOM    137  ND2 ASN A   8      -3.840   2.743  -8.793  0.00  0.00           N  
ATOM    138  H   ASN A   8      -1.910   4.806  -5.177  0.00  0.00           H  
ATOM    139  HA  ASN A   8      -1.509   5.536  -8.056  0.00  0.00           H  
ATOM    140  HB2 ASN A   8      -3.775   4.425  -6.402  0.00  0.00           H  
ATOM    141  HB3 ASN A   8      -4.101   5.201  -7.953  0.00  0.00           H  
ATOM    142 HD21 ASN A   8      -4.765   3.075  -8.843  0.00  0.00           H  
ATOM    143 HD22 ASN A   8      -3.585   1.919  -9.266  0.00  0.00           H  
ATOM    144  N   GLY A   9      -1.625   7.828  -6.459  0.00  0.00           N  
ATOM    145  CA  GLY A   9      -1.951   9.249  -6.144  0.00  0.00           C  
ATOM    146  C   GLY A   9      -1.900  10.082  -7.425  0.00  0.00           C  
ATOM    147  O   GLY A   9      -1.136   9.800  -8.329  0.00  0.00           O  
ATOM    148  H   GLY A   9      -0.708   7.503  -6.347  0.00  0.00           H  
ATOM    149  HA2 GLY A   9      -2.944   9.302  -5.718  0.00  0.00           H  
ATOM    150  HA3 GLY A   9      -1.231   9.637  -5.437  0.00  0.00           H  
ATOM    151  N   LYS A  10      -2.713  11.106  -7.508  0.00  0.00           N  
ATOM    152  CA  LYS A  10      -2.728  11.968  -8.728  0.00  0.00           C  
ATOM    153  C   LYS A  10      -1.331  12.532  -9.012  0.00  0.00           C  
ATOM    154  O   LYS A  10      -0.957  12.737 -10.152  0.00  0.00           O  
ATOM    155  CB  LYS A  10      -3.705  13.102  -8.407  0.00  0.00           C  
ATOM    156  CG  LYS A  10      -5.099  12.520  -8.159  0.00  0.00           C  
ATOM    157  CD  LYS A  10      -6.143  13.633  -8.262  0.00  0.00           C  
ATOM    158  CE  LYS A  10      -7.440  13.066  -8.843  0.00  0.00           C  
ATOM    159  NZ  LYS A  10      -8.280  12.735  -7.659  0.00  0.00           N  
ATOM    160  H   LYS A  10      -3.318  11.304  -6.767  0.00  0.00           H  
ATOM    161  HA  LYS A  10      -3.086  11.405  -9.571  0.00  0.00           H  
ATOM    162  HB2 LYS A  10      -3.370  13.626  -7.524  0.00  0.00           H  
ATOM    163  HB3 LYS A  10      -3.747  13.787  -9.240  0.00  0.00           H  
ATOM    164  HG2 LYS A  10      -5.308  11.759  -8.898  0.00  0.00           H  
ATOM    165  HG3 LYS A  10      -5.137  12.082  -7.171  0.00  0.00           H  
ATOM    166  HD2 LYS A  10      -6.334  14.038  -7.278  0.00  0.00           H  
ATOM    167  HD3 LYS A  10      -5.774  14.415  -8.907  0.00  0.00           H  
ATOM    168  HE2 LYS A  10      -7.930  13.807  -9.461  0.00  0.00           H  
ATOM    169  HE3 LYS A  10      -7.238  12.173  -9.414  0.00  0.00           H  
ATOM    170  HZ1 LYS A  10      -8.540  13.611  -7.163  0.00  0.00           H  
ATOM    171  HZ2 LYS A  10      -7.744  12.118  -7.016  0.00  0.00           H  
ATOM    172  HZ3 LYS A  10      -9.142  12.247  -7.971  0.00  0.00           H  
ATOM    173  N   THR A  11      -0.562  12.785  -7.983  0.00  0.00           N  
ATOM    174  CA  THR A  11       0.811  13.339  -8.185  0.00  0.00           C  
ATOM    175  C   THR A  11       1.864  12.364  -7.650  0.00  0.00           C  
ATOM    176  O   THR A  11       2.950  12.257  -8.190  0.00  0.00           O  
ATOM    177  CB  THR A  11       0.834  14.642  -7.385  0.00  0.00           C  
ATOM    178  OG1 THR A  11      -0.270  15.451  -7.769  0.00  0.00           O  
ATOM    179  CG2 THR A  11       2.138  15.391  -7.664  0.00  0.00           C  
ATOM    180  H   THR A  11      -0.890  12.613  -7.076  0.00  0.00           H  
ATOM    181  HA  THR A  11       0.984  13.545  -9.229  0.00  0.00           H  
ATOM    182  HB  THR A  11       0.770  14.421  -6.331  0.00  0.00           H  
ATOM    183  HG1 THR A  11      -0.317  16.196  -7.165  0.00  0.00           H  
ATOM    184 HG21 THR A  11       2.351  15.360  -8.722  0.00  0.00           H  
ATOM    185 HG22 THR A  11       2.945  14.923  -7.120  0.00  0.00           H  
ATOM    186 HG23 THR A  11       2.038  16.418  -7.347  0.00  0.00           H  
ATOM    187  N   LEU A  12       1.553  11.656  -6.594  0.00  0.00           N  
ATOM    188  CA  LEU A  12       2.534  10.688  -6.019  0.00  0.00           C  
ATOM    189  C   LEU A  12       2.148   9.253  -6.393  0.00  0.00           C  
ATOM    190  O   LEU A  12       1.002   8.860  -6.271  0.00  0.00           O  
ATOM    191  CB  LEU A  12       2.450  10.888  -4.505  0.00  0.00           C  
ATOM    192  CG  LEU A  12       2.957  12.288  -4.141  0.00  0.00           C  
ATOM    193  CD1 LEU A  12       1.768  13.235  -3.965  0.00  0.00           C  
ATOM    194  CD2 LEU A  12       3.748  12.222  -2.832  0.00  0.00           C  
ATOM    195  H   LEU A  12       0.672  11.763  -6.178  0.00  0.00           H  
ATOM    196  HA  LEU A  12       3.531  10.911  -6.366  0.00  0.00           H  
ATOM    197  HB2 LEU A  12       1.424  10.779  -4.186  0.00  0.00           H  
ATOM    198  HB3 LEU A  12       3.060  10.146  -4.011  0.00  0.00           H  
ATOM    199  HG  LEU A  12       3.595  12.657  -4.931  0.00  0.00           H  
ATOM    200 HD11 LEU A  12       2.126  14.250  -3.875  0.00  0.00           H  
ATOM    201 HD12 LEU A  12       1.221  12.965  -3.073  0.00  0.00           H  
ATOM    202 HD13 LEU A  12       1.117  13.159  -4.823  0.00  0.00           H  
ATOM    203 HD21 LEU A  12       3.141  11.761  -2.067  0.00  0.00           H  
ATOM    204 HD22 LEU A  12       4.018  13.221  -2.523  0.00  0.00           H  
ATOM    205 HD23 LEU A  12       4.644  11.637  -2.981  0.00  0.00           H  
ATOM    206  N   LYS A  13       3.096   8.472  -6.844  0.00  0.00           N  
ATOM    207  CA  LYS A  13       2.793   7.061  -7.228  0.00  0.00           C  
ATOM    208  C   LYS A  13       4.017   6.171  -6.987  0.00  0.00           C  
ATOM    209  O   LYS A  13       5.020   6.612  -6.457  0.00  0.00           O  
ATOM    210  CB  LYS A  13       2.458   7.119  -8.719  0.00  0.00           C  
ATOM    211  CG  LYS A  13       1.032   7.639  -8.905  0.00  0.00           C  
ATOM    212  CD  LYS A  13       0.686   7.663 -10.394  0.00  0.00           C  
ATOM    213  CE  LYS A  13       0.101   6.310 -10.805  0.00  0.00           C  
ATOM    214  NZ  LYS A  13       0.458   6.157 -12.243  0.00  0.00           N  
ATOM    215  H   LYS A  13       4.010   8.815  -6.931  0.00  0.00           H  
ATOM    216  HA  LYS A  13       1.945   6.694  -6.674  0.00  0.00           H  
ATOM    217  HB2 LYS A  13       3.152   7.781  -9.218  0.00  0.00           H  
ATOM    218  HB3 LYS A  13       2.536   6.129  -9.145  0.00  0.00           H  
ATOM    219  HG2 LYS A  13       0.342   6.992  -8.383  0.00  0.00           H  
ATOM    220  HG3 LYS A  13       0.959   8.640  -8.504  0.00  0.00           H  
ATOM    221  HD2 LYS A  13      -0.040   8.442 -10.582  0.00  0.00           H  
ATOM    222  HD3 LYS A  13       1.578   7.856 -10.969  0.00  0.00           H  
ATOM    223  HE2 LYS A  13       0.545   5.516 -10.217  0.00  0.00           H  
ATOM    224  HE3 LYS A  13      -0.971   6.311 -10.687  0.00  0.00           H  
ATOM    225  HZ1 LYS A  13      -0.029   5.327 -12.635  0.00  0.00           H  
ATOM    226  HZ2 LYS A  13       1.487   6.032 -12.333  0.00  0.00           H  
ATOM    227  HZ3 LYS A  13       0.164   7.007 -12.765  0.00  0.00           H  
ATOM    228  N   GLY A  14       3.939   4.922  -7.376  0.00  0.00           N  
ATOM    229  CA  GLY A  14       5.091   3.997  -7.177  0.00  0.00           C  
ATOM    230  C   GLY A  14       4.601   2.691  -6.546  0.00  0.00           C  
ATOM    231  O   GLY A  14       3.449   2.324  -6.678  0.00  0.00           O  
ATOM    232  H   GLY A  14       3.121   4.595  -7.801  0.00  0.00           H  
ATOM    233  HA2 GLY A  14       5.549   3.785  -8.132  0.00  0.00           H  
ATOM    234  HA3 GLY A  14       5.815   4.458  -6.523  0.00  0.00           H  
ATOM    235  N   GLU A  15       5.470   1.992  -5.861  0.00  0.00           N  
ATOM    236  CA  GLU A  15       5.065   0.706  -5.214  0.00  0.00           C  
ATOM    237  C   GLU A  15       5.791   0.537  -3.875  0.00  0.00           C  
ATOM    238  O   GLU A  15       6.723   1.260  -3.574  0.00  0.00           O  
ATOM    239  CB  GLU A  15       5.474  -0.393  -6.203  0.00  0.00           C  
ATOM    240  CG  GLU A  15       6.985  -0.342  -6.455  0.00  0.00           C  
ATOM    241  CD  GLU A  15       7.691  -1.334  -5.527  0.00  0.00           C  
ATOM    242  OE1 GLU A  15       7.334  -2.500  -5.558  0.00  0.00           O  
ATOM    243  OE2 GLU A  15       8.577  -0.910  -4.803  0.00  0.00           O  
ATOM    244  H   GLU A  15       6.390   2.314  -5.770  0.00  0.00           H  
ATOM    245  HA  GLU A  15       3.998   0.685  -5.063  0.00  0.00           H  
ATOM    246  HB2 GLU A  15       5.210  -1.357  -5.794  0.00  0.00           H  
ATOM    247  HB3 GLU A  15       4.952  -0.244  -7.137  0.00  0.00           H  
ATOM    248  HG2 GLU A  15       7.187  -0.605  -7.483  0.00  0.00           H  
ATOM    249  HG3 GLU A  15       7.353   0.653  -6.260  0.00  0.00           H  
ATOM    250  N   THR A  16       5.369  -0.408  -3.071  0.00  0.00           N  
ATOM    251  CA  THR A  16       6.037  -0.618  -1.749  0.00  0.00           C  
ATOM    252  C   THR A  16       5.670  -1.986  -1.165  0.00  0.00           C  
ATOM    253  O   THR A  16       4.591  -2.495  -1.387  0.00  0.00           O  
ATOM    254  CB  THR A  16       5.509   0.507  -0.851  0.00  0.00           C  
ATOM    255  OG1 THR A  16       6.074   0.379   0.446  0.00  0.00           O  
ATOM    256  CG2 THR A  16       3.980   0.431  -0.751  0.00  0.00           C  
ATOM    257  H   THR A  16       4.614  -0.976  -3.337  0.00  0.00           H  
ATOM    258  HA  THR A  16       7.106  -0.531  -1.852  0.00  0.00           H  
ATOM    259  HB  THR A  16       5.788   1.462  -1.271  0.00  0.00           H  
ATOM    260  HG1 THR A  16       6.195   1.260   0.806  0.00  0.00           H  
ATOM    261 HG21 THR A  16       3.678  -0.595  -0.580  0.00  0.00           H  
ATOM    262 HG22 THR A  16       3.541   0.785  -1.672  0.00  0.00           H  
ATOM    263 HG23 THR A  16       3.641   1.047   0.068  0.00  0.00           H  
ATOM    264  N   THR A  17       6.561  -2.575  -0.407  0.00  0.00           N  
ATOM    265  CA  THR A  17       6.268  -3.903   0.208  0.00  0.00           C  
ATOM    266  C   THR A  17       6.687  -3.902   1.677  0.00  0.00           C  
ATOM    267  O   THR A  17       7.518  -3.116   2.092  0.00  0.00           O  
ATOM    268  CB  THR A  17       7.107  -4.913  -0.574  0.00  0.00           C  
ATOM    269  OG1 THR A  17       8.459  -4.481  -0.603  0.00  0.00           O  
ATOM    270  CG2 THR A  17       6.574  -5.032  -2.001  0.00  0.00           C  
ATOM    271  H   THR A  17       7.421  -2.137  -0.237  0.00  0.00           H  
ATOM    272  HA  THR A  17       5.220  -4.140   0.113  0.00  0.00           H  
ATOM    273  HB  THR A  17       7.044  -5.876  -0.089  0.00  0.00           H  
ATOM    274  HG1 THR A  17       8.506  -3.687  -1.141  0.00  0.00           H  
ATOM    275 HG21 THR A  17       6.370  -4.046  -2.392  0.00  0.00           H  
ATOM    276 HG22 THR A  17       5.664  -5.615  -1.998  0.00  0.00           H  
ATOM    277 HG23 THR A  17       7.312  -5.520  -2.621  0.00  0.00           H  
ATOM    278  N   THR A  18       6.117  -4.776   2.466  0.00  0.00           N  
ATOM    279  CA  THR A  18       6.475  -4.832   3.904  0.00  0.00           C  
ATOM    280  C   THR A  18       6.512  -6.304   4.364  0.00  0.00           C  
ATOM    281  O   THR A  18       6.056  -7.193   3.671  0.00  0.00           O  
ATOM    282  CB  THR A  18       5.371  -3.988   4.599  0.00  0.00           C  
ATOM    283  OG1 THR A  18       5.940  -2.762   5.036  0.00  0.00           O  
ATOM    284  CG2 THR A  18       4.770  -4.711   5.808  0.00  0.00           C  
ATOM    285  H   THR A  18       5.449  -5.397   2.111  0.00  0.00           H  
ATOM    286  HA  THR A  18       7.439  -4.373   4.062  0.00  0.00           H  
ATOM    287  HB  THR A  18       4.572  -3.773   3.889  0.00  0.00           H  
ATOM    288  HG1 THR A  18       6.186  -2.255   4.259  0.00  0.00           H  
ATOM    289 HG21 THR A  18       5.540  -4.885   6.544  0.00  0.00           H  
ATOM    290 HG22 THR A  18       4.362  -5.656   5.479  0.00  0.00           H  
ATOM    291 HG23 THR A  18       3.985  -4.107   6.237  0.00  0.00           H  
ATOM    292  N   GLU A  19       7.038  -6.548   5.536  0.00  0.00           N  
ATOM    293  CA  GLU A  19       7.098  -7.941   6.066  0.00  0.00           C  
ATOM    294  C   GLU A  19       6.384  -8.001   7.418  0.00  0.00           C  
ATOM    295  O   GLU A  19       6.774  -7.339   8.362  0.00  0.00           O  
ATOM    296  CB  GLU A  19       8.586  -8.244   6.227  0.00  0.00           C  
ATOM    297  CG  GLU A  19       8.765  -9.682   6.726  0.00  0.00           C  
ATOM    298  CD  GLU A  19      10.020 -10.290   6.097  0.00  0.00           C  
ATOM    299  OE1 GLU A  19      11.035  -9.613   6.075  0.00  0.00           O  
ATOM    300  OE2 GLU A  19       9.945 -11.422   5.650  0.00  0.00           O  
ATOM    301  H   GLU A  19       7.386  -5.808   6.076  0.00  0.00           H  
ATOM    302  HA  GLU A  19       6.650  -8.632   5.368  0.00  0.00           H  
ATOM    303  HB2 GLU A  19       9.082  -8.129   5.274  0.00  0.00           H  
ATOM    304  HB3 GLU A  19       9.018  -7.561   6.942  0.00  0.00           H  
ATOM    305  HG2 GLU A  19       8.865  -9.678   7.802  0.00  0.00           H  
ATOM    306  HG3 GLU A  19       7.904 -10.269   6.446  0.00  0.00           H  
ATOM    307  N   ALA A  20       5.335  -8.779   7.515  0.00  0.00           N  
ATOM    308  CA  ALA A  20       4.587  -8.871   8.805  0.00  0.00           C  
ATOM    309  C   ALA A  20       3.845 -10.207   8.905  0.00  0.00           C  
ATOM    310  O   ALA A  20       3.863 -11.009   7.991  0.00  0.00           O  
ATOM    311  CB  ALA A  20       3.592  -7.712   8.756  0.00  0.00           C  
ATOM    312  H   ALA A  20       5.036  -9.296   6.737  0.00  0.00           H  
ATOM    313  HA  ALA A  20       5.256  -8.746   9.639  0.00  0.00           H  
ATOM    314  HB1 ALA A  20       4.075  -6.808   9.096  0.00  0.00           H  
ATOM    315  HB2 ALA A  20       2.751  -7.933   9.396  0.00  0.00           H  
ATOM    316  HB3 ALA A  20       3.248  -7.577   7.741  0.00  0.00           H  
ATOM    317  N   VAL A  21       3.195 -10.444  10.017  0.00  0.00           N  
ATOM    318  CA  VAL A  21       2.444 -11.727  10.198  0.00  0.00           C  
ATOM    319  C   VAL A  21       1.385 -11.887   9.100  0.00  0.00           C  
ATOM    320  O   VAL A  21       1.180 -12.965   8.575  0.00  0.00           O  
ATOM    321  CB  VAL A  21       1.784 -11.625  11.580  0.00  0.00           C  
ATOM    322  CG1 VAL A  21       2.866 -11.466  12.650  0.00  0.00           C  
ATOM    323  CG2 VAL A  21       0.841 -10.415  11.630  0.00  0.00           C  
ATOM    324  H   VAL A  21       3.205  -9.778  10.735  0.00  0.00           H  
ATOM    325  HA  VAL A  21       3.127 -12.563  10.180  0.00  0.00           H  
ATOM    326  HB  VAL A  21       1.223 -12.528  11.774  0.00  0.00           H  
ATOM    327 HG11 VAL A  21       3.178 -10.433  12.696  0.00  0.00           H  
ATOM    328 HG12 VAL A  21       3.713 -12.087  12.402  0.00  0.00           H  
ATOM    329 HG13 VAL A  21       2.469 -11.763  13.610  0.00  0.00           H  
ATOM    330 HG21 VAL A  21      -0.102 -10.675  11.172  0.00  0.00           H  
ATOM    331 HG22 VAL A  21       1.281  -9.585  11.097  0.00  0.00           H  
ATOM    332 HG23 VAL A  21       0.672 -10.132  12.659  0.00  0.00           H  
ATOM    333  N   ASP A  22       0.716 -10.817   8.752  0.00  0.00           N  
ATOM    334  CA  ASP A  22      -0.330 -10.886   7.689  0.00  0.00           C  
ATOM    335  C   ASP A  22      -0.424  -9.539   6.971  0.00  0.00           C  
ATOM    336  O   ASP A  22       0.016  -8.526   7.483  0.00  0.00           O  
ATOM    337  CB  ASP A  22      -1.640 -11.189   8.424  0.00  0.00           C  
ATOM    338  CG  ASP A  22      -1.526 -12.524   9.162  0.00  0.00           C  
ATOM    339  OD1 ASP A  22      -1.746 -13.547   8.533  0.00  0.00           O  
ATOM    340  OD2 ASP A  22      -1.222 -12.502  10.343  0.00  0.00           O  
ATOM    341  H   ASP A  22       0.905  -9.963   9.188  0.00  0.00           H  
ATOM    342  HA  ASP A  22      -0.107 -11.675   6.988  0.00  0.00           H  
ATOM    343  HB2 ASP A  22      -1.841 -10.401   9.135  0.00  0.00           H  
ATOM    344  HB3 ASP A  22      -2.448 -11.243   7.710  0.00  0.00           H  
ATOM    345  N   ALA A  23      -0.992  -9.519   5.793  0.00  0.00           N  
ATOM    346  CA  ALA A  23      -1.114  -8.232   5.042  0.00  0.00           C  
ATOM    347  C   ALA A  23      -1.971  -7.242   5.831  0.00  0.00           C  
ATOM    348  O   ALA A  23      -1.809  -6.042   5.717  0.00  0.00           O  
ATOM    349  CB  ALA A  23      -1.788  -8.596   3.717  0.00  0.00           C  
ATOM    350  H   ALA A  23      -1.338 -10.350   5.404  0.00  0.00           H  
ATOM    351  HA  ALA A  23      -0.137  -7.813   4.858  0.00  0.00           H  
ATOM    352  HB1 ALA A  23      -1.036  -8.879   2.996  0.00  0.00           H  
ATOM    353  HB2 ALA A  23      -2.338  -7.743   3.348  0.00  0.00           H  
ATOM    354  HB3 ALA A  23      -2.466  -9.421   3.874  0.00  0.00           H  
ATOM    355  N   ALA A  24      -2.876  -7.736   6.642  0.00  0.00           N  
ATOM    356  CA  ALA A  24      -3.738  -6.822   7.454  0.00  0.00           C  
ATOM    357  C   ALA A  24      -2.859  -5.976   8.378  0.00  0.00           C  
ATOM    358  O   ALA A  24      -3.028  -4.776   8.485  0.00  0.00           O  
ATOM    359  CB  ALA A  24      -4.649  -7.740   8.271  0.00  0.00           C  
ATOM    360  H   ALA A  24      -2.981  -8.709   6.722  0.00  0.00           H  
ATOM    361  HA  ALA A  24      -4.329  -6.190   6.809  0.00  0.00           H  
ATOM    362  HB1 ALA A  24      -5.378  -8.197   7.619  0.00  0.00           H  
ATOM    363  HB2 ALA A  24      -5.156  -7.163   9.030  0.00  0.00           H  
ATOM    364  HB3 ALA A  24      -4.055  -8.511   8.741  0.00  0.00           H  
ATOM    365  N   THR A  25      -1.912  -6.600   9.033  0.00  0.00           N  
ATOM    366  CA  THR A  25      -1.001  -5.843   9.944  0.00  0.00           C  
ATOM    367  C   THR A  25      -0.109  -4.909   9.117  0.00  0.00           C  
ATOM    368  O   THR A  25       0.029  -3.734   9.422  0.00  0.00           O  
ATOM    369  CB  THR A  25      -0.166  -6.921  10.664  0.00  0.00           C  
ATOM    370  OG1 THR A  25      -0.998  -7.624  11.575  0.00  0.00           O  
ATOM    371  CG2 THR A  25       0.997  -6.276  11.432  0.00  0.00           C  
ATOM    372  H   THR A  25      -1.795  -7.565   8.915  0.00  0.00           H  
ATOM    373  HA  THR A  25      -1.573  -5.279  10.661  0.00  0.00           H  
ATOM    374  HB  THR A  25       0.231  -7.613   9.936  0.00  0.00           H  
ATOM    375  HG1 THR A  25      -1.349  -6.991  12.205  0.00  0.00           H  
ATOM    376 HG21 THR A  25       0.604  -5.624  12.199  0.00  0.00           H  
ATOM    377 HG22 THR A  25       1.606  -5.700  10.745  0.00  0.00           H  
ATOM    378 HG23 THR A  25       1.599  -7.048  11.888  0.00  0.00           H  
ATOM    379  N   ALA A  26       0.503  -5.423   8.078  0.00  0.00           N  
ATOM    380  CA  ALA A  26       1.393  -4.568   7.240  0.00  0.00           C  
ATOM    381  C   ALA A  26       0.605  -3.392   6.666  0.00  0.00           C  
ATOM    382  O   ALA A  26       0.950  -2.249   6.873  0.00  0.00           O  
ATOM    383  CB  ALA A  26       1.896  -5.468   6.108  0.00  0.00           C  
ATOM    384  H   ALA A  26       0.378  -6.371   7.853  0.00  0.00           H  
ATOM    385  HA  ALA A  26       2.225  -4.214   7.829  0.00  0.00           H  
ATOM    386  HB1 ALA A  26       2.345  -4.857   5.331  0.00  0.00           H  
ATOM    387  HB2 ALA A  26       1.068  -6.024   5.695  0.00  0.00           H  
ATOM    388  HB3 ALA A  26       2.634  -6.154   6.494  0.00  0.00           H  
ATOM    389  N   GLU A  27      -0.453  -3.676   5.942  0.00  0.00           N  
ATOM    390  CA  GLU A  27      -1.288  -2.592   5.318  0.00  0.00           C  
ATOM    391  C   GLU A  27      -1.519  -1.414   6.277  0.00  0.00           C  
ATOM    392  O   GLU A  27      -1.537  -0.269   5.861  0.00  0.00           O  
ATOM    393  CB  GLU A  27      -2.615  -3.269   4.968  0.00  0.00           C  
ATOM    394  CG  GLU A  27      -3.521  -2.282   4.227  0.00  0.00           C  
ATOM    395  CD  GLU A  27      -4.983  -2.581   4.562  0.00  0.00           C  
ATOM    396  OE1 GLU A  27      -5.470  -2.037   5.539  0.00  0.00           O  
ATOM    397  OE2 GLU A  27      -5.592  -3.349   3.835  0.00  0.00           O  
ATOM    398  H   GLU A  27      -0.695  -4.615   5.796  0.00  0.00           H  
ATOM    399  HA  GLU A  27      -0.807  -2.243   4.418  0.00  0.00           H  
ATOM    400  HB2 GLU A  27      -2.425  -4.126   4.338  0.00  0.00           H  
ATOM    401  HB3 GLU A  27      -3.105  -3.591   5.874  0.00  0.00           H  
ATOM    402  HG2 GLU A  27      -3.282  -1.274   4.531  0.00  0.00           H  
ATOM    403  HG3 GLU A  27      -3.370  -2.382   3.162  0.00  0.00           H  
ATOM    404  N   LYS A  28      -1.666  -1.678   7.554  0.00  0.00           N  
ATOM    405  CA  LYS A  28      -1.861  -0.555   8.527  0.00  0.00           C  
ATOM    406  C   LYS A  28      -0.607   0.320   8.508  0.00  0.00           C  
ATOM    407  O   LYS A  28      -0.681   1.533   8.462  0.00  0.00           O  
ATOM    408  CB  LYS A  28      -2.036  -1.218   9.896  0.00  0.00           C  
ATOM    409  CG  LYS A  28      -3.254  -2.141   9.874  0.00  0.00           C  
ATOM    410  CD  LYS A  28      -3.078  -3.240  10.926  0.00  0.00           C  
ATOM    411  CE  LYS A  28      -3.746  -2.807  12.233  0.00  0.00           C  
ATOM    412  NZ  LYS A  28      -4.061  -4.078  12.943  0.00  0.00           N  
ATOM    413  H   LYS A  28      -1.627  -2.604   7.872  0.00  0.00           H  
ATOM    414  HA  LYS A  28      -2.734   0.026   8.269  0.00  0.00           H  
ATOM    415  HB2 LYS A  28      -1.152  -1.792  10.132  0.00  0.00           H  
ATOM    416  HB3 LYS A  28      -2.179  -0.455  10.648  0.00  0.00           H  
ATOM    417  HG2 LYS A  28      -4.145  -1.570  10.095  0.00  0.00           H  
ATOM    418  HG3 LYS A  28      -3.348  -2.594   8.898  0.00  0.00           H  
ATOM    419  HD2 LYS A  28      -3.534  -4.154  10.574  0.00  0.00           H  
ATOM    420  HD3 LYS A  28      -2.026  -3.405  11.100  0.00  0.00           H  
ATOM    421  HE2 LYS A  28      -3.065  -2.203  12.820  0.00  0.00           H  
ATOM    422  HE3 LYS A  28      -4.654  -2.262  12.030  0.00  0.00           H  
ATOM    423  HZ1 LYS A  28      -4.595  -3.869  13.809  0.00  0.00           H  
ATOM    424  HZ2 LYS A  28      -3.174  -4.565  13.190  0.00  0.00           H  
ATOM    425  HZ3 LYS A  28      -4.632  -4.688  12.325  0.00  0.00           H  
ATOM    426  N   VAL A  29       0.542  -0.304   8.505  0.00  0.00           N  
ATOM    427  CA  VAL A  29       1.820   0.467   8.442  0.00  0.00           C  
ATOM    428  C   VAL A  29       1.929   1.111   7.057  0.00  0.00           C  
ATOM    429  O   VAL A  29       2.417   2.214   6.915  0.00  0.00           O  
ATOM    430  CB  VAL A  29       2.929  -0.583   8.670  0.00  0.00           C  
ATOM    431  CG1 VAL A  29       4.296  -0.053   8.207  0.00  0.00           C  
ATOM    432  CG2 VAL A  29       3.002  -0.919  10.162  0.00  0.00           C  
ATOM    433  H   VAL A  29       0.562  -1.285   8.514  0.00  0.00           H  
ATOM    434  HA  VAL A  29       1.849   1.224   9.213  0.00  0.00           H  
ATOM    435  HB  VAL A  29       2.689  -1.477   8.116  0.00  0.00           H  
ATOM    436 HG11 VAL A  29       5.046  -0.816   8.353  0.00  0.00           H  
ATOM    437 HG12 VAL A  29       4.557   0.824   8.781  0.00  0.00           H  
ATOM    438 HG13 VAL A  29       4.243   0.206   7.155  0.00  0.00           H  
ATOM    439 HG21 VAL A  29       2.739  -0.045  10.741  0.00  0.00           H  
ATOM    440 HG22 VAL A  29       4.005  -1.230  10.412  0.00  0.00           H  
ATOM    441 HG23 VAL A  29       2.310  -1.718  10.385  0.00  0.00           H  
ATOM    442  N   LEU A  30       1.487   0.422   6.036  0.00  0.00           N  
ATOM    443  CA  LEU A  30       1.573   0.998   4.666  0.00  0.00           C  
ATOM    444  C   LEU A  30       0.664   2.221   4.599  0.00  0.00           C  
ATOM    445  O   LEU A  30       0.964   3.193   3.938  0.00  0.00           O  
ATOM    446  CB  LEU A  30       1.100  -0.118   3.719  0.00  0.00           C  
ATOM    447  CG  LEU A  30       2.190  -1.203   3.480  0.00  0.00           C  
ATOM    448  CD1 LEU A  30       3.108  -0.795   2.333  0.00  0.00           C  
ATOM    449  CD2 LEU A  30       3.059  -1.461   4.716  0.00  0.00           C  
ATOM    450  H   LEU A  30       1.105  -0.474   6.168  0.00  0.00           H  
ATOM    451  HA  LEU A  30       2.592   1.272   4.448  0.00  0.00           H  
ATOM    452  HB2 LEU A  30       0.227  -0.588   4.146  0.00  0.00           H  
ATOM    453  HB3 LEU A  30       0.829   0.321   2.770  0.00  0.00           H  
ATOM    454  HG  LEU A  30       1.696  -2.125   3.214  0.00  0.00           H  
ATOM    455 HD11 LEU A  30       2.563  -0.833   1.401  0.00  0.00           H  
ATOM    456 HD12 LEU A  30       3.945  -1.484   2.292  0.00  0.00           H  
ATOM    457 HD13 LEU A  30       3.472   0.207   2.500  0.00  0.00           H  
ATOM    458 HD21 LEU A  30       3.386  -0.528   5.145  0.00  0.00           H  
ATOM    459 HD22 LEU A  30       3.919  -2.030   4.427  0.00  0.00           H  
ATOM    460 HD23 LEU A  30       2.490  -2.015   5.439  0.00  0.00           H  
ATOM    461  N   LYS A  31      -0.426   2.193   5.327  0.00  0.00           N  
ATOM    462  CA  LYS A  31      -1.341   3.375   5.359  0.00  0.00           C  
ATOM    463  C   LYS A  31      -0.574   4.552   5.946  0.00  0.00           C  
ATOM    464  O   LYS A  31      -0.612   5.659   5.445  0.00  0.00           O  
ATOM    465  CB  LYS A  31      -2.473   2.983   6.309  0.00  0.00           C  
ATOM    466  CG  LYS A  31      -3.742   3.771   5.959  0.00  0.00           C  
ATOM    467  CD  LYS A  31      -3.619   5.217   6.463  0.00  0.00           C  
ATOM    468  CE  LYS A  31      -3.384   5.225   7.980  0.00  0.00           C  
ATOM    469  NZ  LYS A  31      -4.436   6.118   8.540  0.00  0.00           N  
ATOM    470  H   LYS A  31      -0.622   1.408   5.879  0.00  0.00           H  
ATOM    471  HA  LYS A  31      -1.721   3.607   4.372  0.00  0.00           H  
ATOM    472  HB2 LYS A  31      -2.668   1.931   6.239  0.00  0.00           H  
ATOM    473  HB3 LYS A  31      -2.176   3.213   7.318  0.00  0.00           H  
ATOM    474  HG2 LYS A  31      -3.875   3.775   4.887  0.00  0.00           H  
ATOM    475  HG3 LYS A  31      -4.595   3.303   6.425  0.00  0.00           H  
ATOM    476  HD2 LYS A  31      -2.789   5.700   5.969  0.00  0.00           H  
ATOM    477  HD3 LYS A  31      -4.530   5.752   6.239  0.00  0.00           H  
ATOM    478  HE2 LYS A  31      -3.487   4.218   8.374  0.00  0.00           H  
ATOM    479  HE3 LYS A  31      -2.401   5.617   8.205  0.00  0.00           H  
ATOM    480  HZ1 LYS A  31      -4.276   7.091   8.212  0.00  0.00           H  
ATOM    481  HZ2 LYS A  31      -4.398   6.091   9.579  0.00  0.00           H  
ATOM    482  HZ3 LYS A  31      -5.372   5.797   8.218  0.00  0.00           H  
ATOM    483  N   GLN A  32       0.148   4.295   7.008  0.00  0.00           N  
ATOM    484  CA  GLN A  32       0.961   5.370   7.652  0.00  0.00           C  
ATOM    485  C   GLN A  32       1.911   5.981   6.616  0.00  0.00           C  
ATOM    486  O   GLN A  32       2.091   7.182   6.553  0.00  0.00           O  
ATOM    487  CB  GLN A  32       1.745   4.672   8.756  0.00  0.00           C  
ATOM    488  CG  GLN A  32       0.977   4.776  10.075  0.00  0.00           C  
ATOM    489  CD  GLN A  32       1.702   3.968  11.153  0.00  0.00           C  
ATOM    490  OE1 GLN A  32       1.313   2.859  11.462  0.00  0.00           O  
ATOM    491  NE2 GLN A  32       2.749   4.479  11.742  0.00  0.00           N  
ATOM    492  H   GLN A  32       0.162   3.383   7.371  0.00  0.00           H  
ATOM    493  HA  GLN A  32       0.324   6.123   8.076  0.00  0.00           H  
ATOM    494  HB2 GLN A  32       1.882   3.631   8.498  0.00  0.00           H  
ATOM    495  HB3 GLN A  32       2.702   5.150   8.861  0.00  0.00           H  
ATOM    496  HG2 GLN A  32       0.921   5.812  10.377  0.00  0.00           H  
ATOM    497  HG3 GLN A  32      -0.020   4.384   9.943  0.00  0.00           H  
ATOM    498 HE21 GLN A  32       3.063   5.377  11.491  0.00  0.00           H  
ATOM    499 HE22 GLN A  32       3.220   3.967  12.437  0.00  0.00           H  
ATOM    500  N   TYR A  33       2.487   5.153   5.776  0.00  0.00           N  
ATOM    501  CA  TYR A  33       3.394   5.671   4.707  0.00  0.00           C  
ATOM    502  C   TYR A  33       2.574   6.556   3.760  0.00  0.00           C  
ATOM    503  O   TYR A  33       3.016   7.600   3.321  0.00  0.00           O  
ATOM    504  CB  TYR A  33       3.909   4.421   3.982  0.00  0.00           C  
ATOM    505  CG  TYR A  33       4.754   4.831   2.808  0.00  0.00           C  
ATOM    506  CD1 TYR A  33       6.075   5.220   3.013  0.00  0.00           C  
ATOM    507  CD2 TYR A  33       4.210   4.834   1.519  0.00  0.00           C  
ATOM    508  CE1 TYR A  33       6.864   5.614   1.933  0.00  0.00           C  
ATOM    509  CE2 TYR A  33       4.998   5.227   0.434  0.00  0.00           C  
ATOM    510  CZ  TYR A  33       6.328   5.618   0.640  0.00  0.00           C  
ATOM    511  OH  TYR A  33       7.107   6.008  -0.430  0.00  0.00           O  
ATOM    512  H   TYR A  33       2.298   4.190   5.836  0.00  0.00           H  
ATOM    513  HA  TYR A  33       4.219   6.225   5.129  0.00  0.00           H  
ATOM    514  HB2 TYR A  33       4.509   3.835   4.663  0.00  0.00           H  
ATOM    515  HB3 TYR A  33       3.075   3.832   3.637  0.00  0.00           H  
ATOM    516  HD1 TYR A  33       6.489   5.214   4.011  0.00  0.00           H  
ATOM    517  HD2 TYR A  33       3.182   4.532   1.361  0.00  0.00           H  
ATOM    518  HE1 TYR A  33       7.883   5.916   2.100  0.00  0.00           H  
ATOM    519  HE2 TYR A  33       4.581   5.229  -0.561  0.00  0.00           H  
ATOM    520  HH  TYR A  33       6.885   6.918  -0.643  0.00  0.00           H  
ATOM    521  N   ILE A  34       1.372   6.137   3.467  0.00  0.00           N  
ATOM    522  CA  ILE A  34       0.485   6.934   2.567  0.00  0.00           C  
ATOM    523  C   ILE A  34       0.096   8.241   3.268  0.00  0.00           C  
ATOM    524  O   ILE A  34      -0.153   9.249   2.632  0.00  0.00           O  
ATOM    525  CB  ILE A  34      -0.749   6.047   2.345  0.00  0.00           C  
ATOM    526  CG1 ILE A  34      -0.313   4.716   1.682  0.00  0.00           C  
ATOM    527  CG2 ILE A  34      -1.787   6.787   1.483  0.00  0.00           C  
ATOM    528  CD1 ILE A  34      -0.095   4.881   0.174  0.00  0.00           C  
ATOM    529  H   ILE A  34       1.049   5.295   3.851  0.00  0.00           H  
ATOM    530  HA  ILE A  34       0.975   7.134   1.627  0.00  0.00           H  
ATOM    531  HB  ILE A  34      -1.194   5.829   3.302  0.00  0.00           H  
ATOM    532 HG12 ILE A  34       0.613   4.388   2.127  0.00  0.00           H  
ATOM    533 HG13 ILE A  34      -1.072   3.967   1.855  0.00  0.00           H  
ATOM    534 HG21 ILE A  34      -2.536   7.231   2.124  0.00  0.00           H  
ATOM    535 HG22 ILE A  34      -2.259   6.088   0.809  0.00  0.00           H  
ATOM    536 HG23 ILE A  34      -1.296   7.561   0.913  0.00  0.00           H  
ATOM    537 HD11 ILE A  34       0.553   4.096  -0.186  0.00  0.00           H  
ATOM    538 HD12 ILE A  34       0.358   5.841  -0.020  0.00  0.00           H  
ATOM    539 HD13 ILE A  34      -1.048   4.824  -0.330  0.00  0.00           H  
ATOM    540  N   ASN A  35       0.043   8.224   4.578  0.00  0.00           N  
ATOM    541  CA  ASN A  35      -0.327   9.456   5.341  0.00  0.00           C  
ATOM    542  C   ASN A  35       0.665  10.585   5.041  0.00  0.00           C  
ATOM    543  O   ASN A  35       0.326  11.751   5.103  0.00  0.00           O  
ATOM    544  CB  ASN A  35      -0.248   9.054   6.816  0.00  0.00           C  
ATOM    545  CG  ASN A  35      -0.873  10.151   7.678  0.00  0.00           C  
ATOM    546  OD1 ASN A  35      -1.984  10.576   7.431  0.00  0.00           O  
ATOM    547  ND2 ASN A  35      -0.200  10.633   8.689  0.00  0.00           N  
ATOM    548  H   ASN A  35       0.248   7.396   5.060  0.00  0.00           H  
ATOM    549  HA  ASN A  35      -1.331   9.762   5.097  0.00  0.00           H  
ATOM    550  HB2 ASN A  35      -0.785   8.128   6.964  0.00  0.00           H  
ATOM    551  HB3 ASN A  35       0.785   8.920   7.098  0.00  0.00           H  
ATOM    552 HD21 ASN A  35       0.696  10.290   8.888  0.00  0.00           H  
ATOM    553 HD22 ASN A  35      -0.592  11.336   9.247  0.00  0.00           H  
ATOM    554  N   ASP A  36       1.886  10.241   4.716  0.00  0.00           N  
ATOM    555  CA  ASP A  36       2.909  11.288   4.411  0.00  0.00           C  
ATOM    556  C   ASP A  36       2.709  11.822   2.990  0.00  0.00           C  
ATOM    557  O   ASP A  36       2.828  13.007   2.742  0.00  0.00           O  
ATOM    558  CB  ASP A  36       4.258  10.577   4.530  0.00  0.00           C  
ATOM    559  CG  ASP A  36       4.584  10.347   6.006  0.00  0.00           C  
ATOM    560  OD1 ASP A  36       4.806  11.323   6.704  0.00  0.00           O  
ATOM    561  OD2 ASP A  36       4.608   9.198   6.416  0.00  0.00           O  
ATOM    562  H   ASP A  36       2.131   9.293   4.674  0.00  0.00           H  
ATOM    563  HA  ASP A  36       2.851  12.091   5.127  0.00  0.00           H  
ATOM    564  HB2 ASP A  36       4.210   9.626   4.019  0.00  0.00           H  
ATOM    565  HB3 ASP A  36       5.028  11.188   4.084  0.00  0.00           H  
ATOM    566  N   ASN A  37       2.405  10.953   2.059  0.00  0.00           N  
ATOM    567  CA  ASN A  37       2.194  11.402   0.649  0.00  0.00           C  
ATOM    568  C   ASN A  37       0.826  12.075   0.510  0.00  0.00           C  
ATOM    569  O   ASN A  37       0.634  12.942  -0.322  0.00  0.00           O  
ATOM    570  CB  ASN A  37       2.250  10.125  -0.191  0.00  0.00           C  
ATOM    571  CG  ASN A  37       3.660   9.537  -0.132  0.00  0.00           C  
ATOM    572  OD1 ASN A  37       4.342   9.660   0.867  0.00  0.00           O  
ATOM    573  ND2 ASN A  37       4.131   8.897  -1.167  0.00  0.00           N  
ATOM    574  H   ASN A  37       2.315  10.005   2.290  0.00  0.00           H  
ATOM    575  HA  ASN A  37       2.979  12.077   0.347  0.00  0.00           H  
ATOM    576  HB2 ASN A  37       1.542   9.406   0.200  0.00  0.00           H  
ATOM    577  HB3 ASN A  37       2.002  10.357  -1.217  0.00  0.00           H  
ATOM    578 HD21 ASN A  37       3.580   8.797  -1.975  0.00  0.00           H  
ATOM    579 HD22 ASN A  37       5.038   8.515  -1.137  0.00  0.00           H  
ATOM    580  N   GLY A  38      -0.124  11.681   1.320  0.00  0.00           N  
ATOM    581  CA  GLY A  38      -1.483  12.291   1.243  0.00  0.00           C  
ATOM    582  C   GLY A  38      -2.282  11.622   0.123  0.00  0.00           C  
ATOM    583  O   GLY A  38      -3.111  12.242  -0.515  0.00  0.00           O  
ATOM    584  H   GLY A  38       0.059  10.980   1.980  0.00  0.00           H  
ATOM    585  HA2 GLY A  38      -1.993  12.152   2.185  0.00  0.00           H  
ATOM    586  HA3 GLY A  38      -1.392  13.346   1.034  0.00  0.00           H  
ATOM    587  N   ILE A  39      -2.036  10.359  -0.118  0.00  0.00           N  
ATOM    588  CA  ILE A  39      -2.778   9.638  -1.197  0.00  0.00           C  
ATOM    589  C   ILE A  39      -3.636   8.524  -0.590  0.00  0.00           C  
ATOM    590  O   ILE A  39      -3.327   7.354  -0.715  0.00  0.00           O  
ATOM    591  CB  ILE A  39      -1.692   9.053  -2.110  0.00  0.00           C  
ATOM    592  CG1 ILE A  39      -0.802  10.181  -2.663  0.00  0.00           C  
ATOM    593  CG2 ILE A  39      -2.345   8.299  -3.274  0.00  0.00           C  
ATOM    594  CD1 ILE A  39      -1.645  11.185  -3.463  0.00  0.00           C  
ATOM    595  H   ILE A  39      -1.362   9.883   0.411  0.00  0.00           H  
ATOM    596  HA  ILE A  39      -3.394  10.328  -1.753  0.00  0.00           H  
ATOM    597  HB  ILE A  39      -1.084   8.365  -1.540  0.00  0.00           H  
ATOM    598 HG12 ILE A  39      -0.324  10.693  -1.840  0.00  0.00           H  
ATOM    599 HG13 ILE A  39      -0.049   9.755  -3.310  0.00  0.00           H  
ATOM    600 HG21 ILE A  39      -2.824   7.406  -2.900  0.00  0.00           H  
ATOM    601 HG22 ILE A  39      -1.589   8.027  -3.996  0.00  0.00           H  
ATOM    602 HG23 ILE A  39      -3.081   8.932  -3.746  0.00  0.00           H  
ATOM    603 HD11 ILE A  39      -1.801  12.075  -2.872  0.00  0.00           H  
ATOM    604 HD12 ILE A  39      -2.600  10.743  -3.706  0.00  0.00           H  
ATOM    605 HD13 ILE A  39      -1.125  11.444  -4.374  0.00  0.00           H  
ATOM    606  N   ASP A  40      -4.711   8.880   0.065  0.00  0.00           N  
ATOM    607  CA  ASP A  40      -5.597   7.849   0.682  0.00  0.00           C  
ATOM    608  C   ASP A  40      -7.005   7.941   0.090  0.00  0.00           C  
ATOM    609  O   ASP A  40      -7.649   8.971   0.162  0.00  0.00           O  
ATOM    610  CB  ASP A  40      -5.619   8.186   2.173  0.00  0.00           C  
ATOM    611  CG  ASP A  40      -5.862   6.910   2.982  0.00  0.00           C  
ATOM    612  OD1 ASP A  40      -5.085   5.982   2.836  0.00  0.00           O  
ATOM    613  OD2 ASP A  40      -6.822   6.884   3.734  0.00  0.00           O  
ATOM    614  H   ASP A  40      -4.937   9.830   0.150  0.00  0.00           H  
ATOM    615  HA  ASP A  40      -5.188   6.862   0.533  0.00  0.00           H  
ATOM    616  HB2 ASP A  40      -4.668   8.618   2.458  0.00  0.00           H  
ATOM    617  HB3 ASP A  40      -6.412   8.893   2.371  0.00  0.00           H  
ATOM    618  N   GLY A  41      -7.485   6.873  -0.496  0.00  0.00           N  
ATOM    619  CA  GLY A  41      -8.851   6.895  -1.098  0.00  0.00           C  
ATOM    620  C   GLY A  41      -9.453   5.489  -1.072  0.00  0.00           C  
ATOM    621  O   GLY A  41     -10.191   5.139  -0.170  0.00  0.00           O  
ATOM    622  H   GLY A  41      -6.945   6.056  -0.542  0.00  0.00           H  
ATOM    623  HA2 GLY A  41      -9.481   7.567  -0.530  0.00  0.00           H  
ATOM    624  HA3 GLY A  41      -8.787   7.236  -2.121  0.00  0.00           H  
ATOM    625  N   GLU A  42      -9.149   4.683  -2.059  0.00  0.00           N  
ATOM    626  CA  GLU A  42      -9.709   3.298  -2.101  0.00  0.00           C  
ATOM    627  C   GLU A  42      -8.602   2.277  -2.377  0.00  0.00           C  
ATOM    628  O   GLU A  42      -7.958   2.313  -3.408  0.00  0.00           O  
ATOM    629  CB  GLU A  42     -10.719   3.314  -3.256  0.00  0.00           C  
ATOM    630  CG  GLU A  42     -12.144   3.336  -2.696  0.00  0.00           C  
ATOM    631  CD  GLU A  42     -13.041   4.173  -3.610  0.00  0.00           C  
ATOM    632  OE1 GLU A  42     -13.474   3.650  -4.623  0.00  0.00           O  
ATOM    633  OE2 GLU A  42     -13.277   5.324  -3.281  0.00  0.00           O  
ATOM    634  H   GLU A  42      -8.556   4.991  -2.776  0.00  0.00           H  
ATOM    635  HA  GLU A  42     -10.208   3.067  -1.174  0.00  0.00           H  
ATOM    636  HB2 GLU A  42     -10.556   4.194  -3.863  0.00  0.00           H  
ATOM    637  HB3 GLU A  42     -10.588   2.430  -3.862  0.00  0.00           H  
ATOM    638  HG2 GLU A  42     -12.524   2.325  -2.645  0.00  0.00           H  
ATOM    639  HG3 GLU A  42     -12.137   3.768  -1.707  0.00  0.00           H  
ATOM    640  N   TRP A  43      -8.385   1.365  -1.462  0.00  0.00           N  
ATOM    641  CA  TRP A  43      -7.327   0.333  -1.667  0.00  0.00           C  
ATOM    642  C   TRP A  43      -7.963  -0.957  -2.185  0.00  0.00           C  
ATOM    643  O   TRP A  43      -9.163  -1.141  -2.107  0.00  0.00           O  
ATOM    644  CB  TRP A  43      -6.719   0.069  -0.285  0.00  0.00           C  
ATOM    645  CG  TRP A  43      -5.921   1.237   0.213  0.00  0.00           C  
ATOM    646  CD1 TRP A  43      -6.140   2.549  -0.059  0.00  0.00           C  
ATOM    647  CD2 TRP A  43      -4.765   1.198   1.090  0.00  0.00           C  
ATOM    648  NE1 TRP A  43      -5.207   3.306   0.619  0.00  0.00           N  
ATOM    649  CE2 TRP A  43      -4.331   2.518   1.332  0.00  0.00           C  
ATOM    650  CE3 TRP A  43      -4.064   0.146   1.694  0.00  0.00           C  
ATOM    651  CZ2 TRP A  43      -3.236   2.789   2.147  0.00  0.00           C  
ATOM    652  CZ3 TRP A  43      -2.955   0.411   2.514  0.00  0.00           C  
ATOM    653  CH2 TRP A  43      -2.543   1.730   2.740  0.00  0.00           C  
ATOM    654  H   TRP A  43      -8.923   1.357  -0.643  0.00  0.00           H  
ATOM    655  HA  TRP A  43      -6.569   0.690  -2.347  0.00  0.00           H  
ATOM    656  HB2 TRP A  43      -7.508  -0.137   0.419  0.00  0.00           H  
ATOM    657  HB3 TRP A  43      -6.075  -0.795  -0.348  0.00  0.00           H  
ATOM    658  HD1 TRP A  43      -6.915   2.943  -0.689  0.00  0.00           H  
ATOM    659  HE1 TRP A  43      -5.153   4.284   0.604  0.00  0.00           H  
ATOM    660  HE3 TRP A  43      -4.380  -0.873   1.524  0.00  0.00           H  
ATOM    661  HZ2 TRP A  43      -2.928   3.808   2.317  0.00  0.00           H  
ATOM    662  HZ3 TRP A  43      -2.415  -0.403   2.969  0.00  0.00           H  
ATOM    663  HH2 TRP A  43      -1.688   1.925   3.367  0.00  0.00           H  
ATOM    664  N   THR A  44      -7.163  -1.861  -2.687  0.00  0.00           N  
ATOM    665  CA  THR A  44      -7.705  -3.160  -3.185  0.00  0.00           C  
ATOM    666  C   THR A  44      -6.643  -4.247  -3.025  0.00  0.00           C  
ATOM    667  O   THR A  44      -5.499  -4.067  -3.400  0.00  0.00           O  
ATOM    668  CB  THR A  44      -8.040  -2.947  -4.663  0.00  0.00           C  
ATOM    669  OG1 THR A  44      -6.863  -2.589  -5.370  0.00  0.00           O  
ATOM    670  CG2 THR A  44      -9.084  -1.838  -4.805  0.00  0.00           C  
ATOM    671  H   THR A  44      -6.198  -1.694  -2.717  0.00  0.00           H  
ATOM    672  HA  THR A  44      -8.597  -3.427  -2.639  0.00  0.00           H  
ATOM    673  HB  THR A  44      -8.439  -3.863  -5.069  0.00  0.00           H  
ATOM    674  HG1 THR A  44      -7.113  -2.378  -6.273  0.00  0.00           H  
ATOM    675 HG21 THR A  44      -9.516  -1.874  -5.794  0.00  0.00           H  
ATOM    676 HG22 THR A  44      -8.614  -0.877  -4.654  0.00  0.00           H  
ATOM    677 HG23 THR A  44      -9.862  -1.977  -4.068  0.00  0.00           H  
ATOM    678  N   TYR A  45      -7.013  -5.366  -2.466  0.00  0.00           N  
ATOM    679  CA  TYR A  45      -6.029  -6.471  -2.268  0.00  0.00           C  
ATOM    680  C   TYR A  45      -6.012  -7.385  -3.501  0.00  0.00           C  
ATOM    681  O   TYR A  45      -6.935  -7.384  -4.295  0.00  0.00           O  
ATOM    682  CB  TYR A  45      -6.535  -7.229  -1.036  0.00  0.00           C  
ATOM    683  CG  TYR A  45      -5.631  -8.405  -0.745  0.00  0.00           C  
ATOM    684  CD1 TYR A  45      -4.267  -8.200  -0.505  0.00  0.00           C  
ATOM    685  CD2 TYR A  45      -6.158  -9.702  -0.718  0.00  0.00           C  
ATOM    686  CE1 TYR A  45      -3.431  -9.289  -0.238  0.00  0.00           C  
ATOM    687  CE2 TYR A  45      -5.322 -10.793  -0.451  0.00  0.00           C  
ATOM    688  CZ  TYR A  45      -3.958 -10.586  -0.211  0.00  0.00           C  
ATOM    689  OH  TYR A  45      -3.134 -11.661   0.053  0.00  0.00           O  
ATOM    690  H   TYR A  45      -7.941  -5.479  -2.173  0.00  0.00           H  
ATOM    691  HA  TYR A  45      -5.046  -6.065  -2.075  0.00  0.00           H  
ATOM    692  HB2 TYR A  45      -6.543  -6.565  -0.184  0.00  0.00           H  
ATOM    693  HB3 TYR A  45      -7.537  -7.586  -1.221  0.00  0.00           H  
ATOM    694  HD1 TYR A  45      -3.861  -7.200  -0.526  0.00  0.00           H  
ATOM    695  HD2 TYR A  45      -7.210  -9.861  -0.904  0.00  0.00           H  
ATOM    696  HE1 TYR A  45      -2.380  -9.130  -0.052  0.00  0.00           H  
ATOM    697  HE2 TYR A  45      -5.729 -11.792  -0.432  0.00  0.00           H  
ATOM    698  HH  TYR A  45      -2.786 -11.557   0.941  0.00  0.00           H  
ATOM    699  N   ASP A  46      -4.976  -8.171  -3.659  0.00  0.00           N  
ATOM    700  CA  ASP A  46      -4.902  -9.096  -4.833  0.00  0.00           C  
ATOM    701  C   ASP A  46      -4.380 -10.463  -4.388  0.00  0.00           C  
ATOM    702  O   ASP A  46      -3.352 -10.562  -3.745  0.00  0.00           O  
ATOM    703  CB  ASP A  46      -3.921  -8.452  -5.822  0.00  0.00           C  
ATOM    704  CG  ASP A  46      -4.363  -7.022  -6.148  0.00  0.00           C  
ATOM    705  OD1 ASP A  46      -5.494  -6.854  -6.572  0.00  0.00           O  
ATOM    706  OD2 ASP A  46      -3.561  -6.119  -5.967  0.00  0.00           O  
ATOM    707  H   ASP A  46      -4.249  -8.158  -3.002  0.00  0.00           H  
ATOM    708  HA  ASP A  46      -5.874  -9.196  -5.292  0.00  0.00           H  
ATOM    709  HB2 ASP A  46      -2.931  -8.437  -5.390  0.00  0.00           H  
ATOM    710  HB3 ASP A  46      -3.902  -9.033  -6.732  0.00  0.00           H  
ATOM    711  N   ASP A  47      -5.079 -11.515  -4.731  0.00  0.00           N  
ATOM    712  CA  ASP A  47      -4.624 -12.884  -4.335  0.00  0.00           C  
ATOM    713  C   ASP A  47      -3.410 -13.319  -5.174  0.00  0.00           C  
ATOM    714  O   ASP A  47      -2.822 -14.354  -4.923  0.00  0.00           O  
ATOM    715  CB  ASP A  47      -5.820 -13.797  -4.608  0.00  0.00           C  
ATOM    716  CG  ASP A  47      -5.491 -15.220  -4.154  0.00  0.00           C  
ATOM    717  OD1 ASP A  47      -5.213 -15.397  -2.980  0.00  0.00           O  
ATOM    718  OD2 ASP A  47      -5.524 -16.110  -4.988  0.00  0.00           O  
ATOM    719  H   ASP A  47      -5.901 -11.403  -5.254  0.00  0.00           H  
ATOM    720  HA  ASP A  47      -4.380 -12.906  -3.284  0.00  0.00           H  
ATOM    721  HB2 ASP A  47      -6.680 -13.435  -4.064  0.00  0.00           H  
ATOM    722  HB3 ASP A  47      -6.037 -13.800  -5.665  0.00  0.00           H  
ATOM    723  N   ALA A  48      -3.028 -12.542  -6.165  0.00  0.00           N  
ATOM    724  CA  ALA A  48      -1.851 -12.916  -7.013  0.00  0.00           C  
ATOM    725  C   ALA A  48      -0.603 -13.110  -6.143  0.00  0.00           C  
ATOM    726  O   ALA A  48      -0.150 -14.218  -5.928  0.00  0.00           O  
ATOM    727  CB  ALA A  48      -1.658 -11.732  -7.965  0.00  0.00           C  
ATOM    728  H   ALA A  48      -3.513 -11.713  -6.351  0.00  0.00           H  
ATOM    729  HA  ALA A  48      -2.062 -13.811  -7.576  0.00  0.00           H  
ATOM    730  HB1 ALA A  48      -2.281 -11.865  -8.837  0.00  0.00           H  
ATOM    731  HB2 ALA A  48      -0.623 -11.677  -8.266  0.00  0.00           H  
ATOM    732  HB3 ALA A  48      -1.936 -10.815  -7.460  0.00  0.00           H  
ATOM    733  N   THR A  49      -0.053 -12.035  -5.642  0.00  0.00           N  
ATOM    734  CA  THR A  49       1.162 -12.133  -4.781  0.00  0.00           C  
ATOM    735  C   THR A  49       0.961 -11.298  -3.513  0.00  0.00           C  
ATOM    736  O   THR A  49       1.874 -10.659  -3.027  0.00  0.00           O  
ATOM    737  CB  THR A  49       2.300 -11.558  -5.633  0.00  0.00           C  
ATOM    738  OG1 THR A  49       3.514 -11.610  -4.896  0.00  0.00           O  
ATOM    739  CG2 THR A  49       1.987 -10.103  -6.003  0.00  0.00           C  
ATOM    740  H   THR A  49      -0.444 -11.156  -5.833  0.00  0.00           H  
ATOM    741  HA  THR A  49       1.368 -13.161  -4.530  0.00  0.00           H  
ATOM    742  HB  THR A  49       2.403 -12.139  -6.537  0.00  0.00           H  
ATOM    743  HG1 THR A  49       3.708 -12.530  -4.710  0.00  0.00           H  
ATOM    744 HG21 THR A  49       2.834  -9.670  -6.514  0.00  0.00           H  
ATOM    745 HG22 THR A  49       1.782  -9.544  -5.101  0.00  0.00           H  
ATOM    746 HG23 THR A  49       1.121 -10.075  -6.649  0.00  0.00           H  
ATOM    747  N   LYS A  50      -0.240 -11.288  -2.991  0.00  0.00           N  
ATOM    748  CA  LYS A  50      -0.540 -10.486  -1.761  0.00  0.00           C  
ATOM    749  C   LYS A  50      -0.171  -9.014  -1.981  0.00  0.00           C  
ATOM    750  O   LYS A  50       0.540  -8.419  -1.195  0.00  0.00           O  
ATOM    751  CB  LYS A  50       0.303 -11.098  -0.638  0.00  0.00           C  
ATOM    752  CG  LYS A  50      -0.080 -12.569  -0.451  0.00  0.00           C  
ATOM    753  CD  LYS A  50       0.965 -13.266   0.425  0.00  0.00           C  
ATOM    754  CE  LYS A  50       0.269 -14.244   1.376  0.00  0.00           C  
ATOM    755  NZ  LYS A  50       1.355 -14.763   2.255  0.00  0.00           N  
ATOM    756  H   LYS A  50      -0.956 -11.804  -3.416  0.00  0.00           H  
ATOM    757  HA  LYS A  50      -1.585 -10.569  -1.519  0.00  0.00           H  
ATOM    758  HB2 LYS A  50       1.351 -11.029  -0.892  0.00  0.00           H  
ATOM    759  HB3 LYS A  50       0.120 -10.563   0.282  0.00  0.00           H  
ATOM    760  HG2 LYS A  50      -1.050 -12.628   0.023  0.00  0.00           H  
ATOM    761  HG3 LYS A  50      -0.122 -13.054  -1.415  0.00  0.00           H  
ATOM    762  HD2 LYS A  50       1.657 -13.808  -0.205  0.00  0.00           H  
ATOM    763  HD3 LYS A  50       1.505 -12.530   1.001  0.00  0.00           H  
ATOM    764  HE2 LYS A  50      -0.478 -13.727   1.962  0.00  0.00           H  
ATOM    765  HE3 LYS A  50      -0.178 -15.054   0.823  0.00  0.00           H  
ATOM    766  HZ1 LYS A  50       2.085 -15.218   1.672  0.00  0.00           H  
ATOM    767  HZ2 LYS A  50       0.958 -15.456   2.920  0.00  0.00           H  
ATOM    768  HZ3 LYS A  50       1.779 -13.976   2.785  0.00  0.00           H  
ATOM    769  N   THR A  51      -0.659  -8.429  -3.046  0.00  0.00           N  
ATOM    770  CA  THR A  51      -0.351  -6.994  -3.330  0.00  0.00           C  
ATOM    771  C   THR A  51      -1.464  -6.108  -2.764  0.00  0.00           C  
ATOM    772  O   THR A  51      -2.319  -6.566  -2.028  0.00  0.00           O  
ATOM    773  CB  THR A  51      -0.302  -6.871  -4.863  0.00  0.00           C  
ATOM    774  OG1 THR A  51       0.116  -8.102  -5.438  0.00  0.00           O  
ATOM    775  CG2 THR A  51       0.680  -5.766  -5.267  0.00  0.00           C  
ATOM    776  H   THR A  51      -1.232  -8.935  -3.659  0.00  0.00           H  
ATOM    777  HA  THR A  51       0.603  -6.722  -2.905  0.00  0.00           H  
ATOM    778  HB  THR A  51      -1.285  -6.620  -5.232  0.00  0.00           H  
ATOM    779  HG1 THR A  51       0.198  -7.974  -6.386  0.00  0.00           H  
ATOM    780 HG21 THR A  51       1.563  -6.213  -5.699  0.00  0.00           H  
ATOM    781 HG22 THR A  51       0.958  -5.187  -4.399  0.00  0.00           H  
ATOM    782 HG23 THR A  51       0.213  -5.120  -5.996  0.00  0.00           H  
ATOM    783  N   TRP A  52      -1.460  -4.845  -3.104  0.00  0.00           N  
ATOM    784  CA  TRP A  52      -2.514  -3.922  -2.592  0.00  0.00           C  
ATOM    785  C   TRP A  52      -2.671  -2.724  -3.531  0.00  0.00           C  
ATOM    786  O   TRP A  52      -2.107  -2.690  -4.608  0.00  0.00           O  
ATOM    787  CB  TRP A  52      -2.004  -3.444  -1.239  0.00  0.00           C  
ATOM    788  CG  TRP A  52      -2.270  -4.472  -0.193  0.00  0.00           C  
ATOM    789  CD1 TRP A  52      -1.379  -5.377   0.263  0.00  0.00           C  
ATOM    790  CD2 TRP A  52      -3.496  -4.695   0.544  0.00  0.00           C  
ATOM    791  NE1 TRP A  52      -1.993  -6.157   1.229  0.00  0.00           N  
ATOM    792  CE2 TRP A  52      -3.303  -5.771   1.437  0.00  0.00           C  
ATOM    793  CE3 TRP A  52      -4.747  -4.070   0.512  0.00  0.00           C  
ATOM    794  CZ2 TRP A  52      -4.327  -6.213   2.277  0.00  0.00           C  
ATOM    795  CZ3 TRP A  52      -5.782  -4.506   1.354  0.00  0.00           C  
ATOM    796  CH2 TRP A  52      -5.572  -5.578   2.235  0.00  0.00           C  
ATOM    797  H   TRP A  52      -0.762  -4.502  -3.696  0.00  0.00           H  
ATOM    798  HA  TRP A  52      -3.451  -4.441  -2.473  0.00  0.00           H  
ATOM    799  HB2 TRP A  52      -0.944  -3.258  -1.297  0.00  0.00           H  
ATOM    800  HB3 TRP A  52      -2.514  -2.532  -0.979  0.00  0.00           H  
ATOM    801  HD1 TRP A  52      -0.359  -5.477  -0.074  0.00  0.00           H  
ATOM    802  HE1 TRP A  52      -1.568  -6.894   1.716  0.00  0.00           H  
ATOM    803  HE3 TRP A  52      -4.906  -3.242  -0.164  0.00  0.00           H  
ATOM    804  HZ2 TRP A  52      -4.159  -7.038   2.952  0.00  0.00           H  
ATOM    805  HZ3 TRP A  52      -6.744  -4.017   1.322  0.00  0.00           H  
ATOM    806  HH2 TRP A  52      -6.371  -5.912   2.881  0.00  0.00           H  
ATOM    807  N   THR A  53      -3.429  -1.735  -3.122  0.00  0.00           N  
ATOM    808  CA  THR A  53      -3.621  -0.525  -3.978  0.00  0.00           C  
ATOM    809  C   THR A  53      -4.067   0.666  -3.122  0.00  0.00           C  
ATOM    810  O   THR A  53      -4.367   0.524  -1.951  0.00  0.00           O  
ATOM    811  CB  THR A  53      -4.711  -0.905  -4.983  0.00  0.00           C  
ATOM    812  OG1 THR A  53      -4.423  -2.178  -5.543  0.00  0.00           O  
ATOM    813  CG2 THR A  53      -4.767   0.139  -6.099  0.00  0.00           C  
ATOM    814  H   THR A  53      -3.865  -1.787  -2.246  0.00  0.00           H  
ATOM    815  HA  THR A  53      -2.706  -0.290  -4.495  0.00  0.00           H  
ATOM    816  HB  THR A  53      -5.665  -0.937  -4.482  0.00  0.00           H  
ATOM    817  HG1 THR A  53      -5.161  -2.761  -5.350  0.00  0.00           H  
ATOM    818 HG21 THR A  53      -5.305  -0.266  -6.944  0.00  0.00           H  
ATOM    819 HG22 THR A  53      -3.764   0.398  -6.402  0.00  0.00           H  
ATOM    820 HG23 THR A  53      -5.275   1.023  -5.742  0.00  0.00           H  
ATOM    821  N   VAL A  54      -4.100   1.840  -3.700  0.00  0.00           N  
ATOM    822  CA  VAL A  54      -4.512   3.062  -2.932  0.00  0.00           C  
ATOM    823  C   VAL A  54      -4.662   4.250  -3.896  0.00  0.00           C  
ATOM    824  O   VAL A  54      -3.733   5.004  -4.117  0.00  0.00           O  
ATOM    825  CB  VAL A  54      -3.384   3.301  -1.898  0.00  0.00           C  
ATOM    826  CG1 VAL A  54      -2.020   3.250  -2.582  0.00  0.00           C  
ATOM    827  CG2 VAL A  54      -3.545   4.670  -1.223  0.00  0.00           C  
ATOM    828  H   VAL A  54      -3.843   1.925  -4.642  0.00  0.00           H  
ATOM    829  HA  VAL A  54      -5.445   2.880  -2.423  0.00  0.00           H  
ATOM    830  HB  VAL A  54      -3.429   2.526  -1.145  0.00  0.00           H  
ATOM    831 HG11 VAL A  54      -1.340   3.924  -2.084  0.00  0.00           H  
ATOM    832 HG12 VAL A  54      -2.128   3.541  -3.614  0.00  0.00           H  
ATOM    833 HG13 VAL A  54      -1.635   2.245  -2.529  0.00  0.00           H  
ATOM    834 HG21 VAL A  54      -4.591   4.934  -1.185  0.00  0.00           H  
ATOM    835 HG22 VAL A  54      -3.006   5.415  -1.789  0.00  0.00           H  
ATOM    836 HG23 VAL A  54      -3.146   4.624  -0.216  0.00  0.00           H  
ATOM    837  N   THR A  55      -5.830   4.415  -4.463  0.00  0.00           N  
ATOM    838  CA  THR A  55      -6.058   5.547  -5.411  0.00  0.00           C  
ATOM    839  C   THR A  55      -6.583   6.773  -4.659  0.00  0.00           C  
ATOM    840  O   THR A  55      -7.483   6.672  -3.848  0.00  0.00           O  
ATOM    841  CB  THR A  55      -7.111   5.030  -6.392  0.00  0.00           C  
ATOM    842  OG1 THR A  55      -6.779   3.706  -6.785  0.00  0.00           O  
ATOM    843  CG2 THR A  55      -7.150   5.936  -7.624  0.00  0.00           C  
ATOM    844  H   THR A  55      -6.560   3.793  -4.264  0.00  0.00           H  
ATOM    845  HA  THR A  55      -5.149   5.788  -5.939  0.00  0.00           H  
ATOM    846  HB  THR A  55      -8.081   5.033  -5.917  0.00  0.00           H  
ATOM    847  HG1 THR A  55      -7.553   3.316  -7.198  0.00  0.00           H  
ATOM    848 HG21 THR A  55      -6.161   6.004  -8.052  0.00  0.00           H  
ATOM    849 HG22 THR A  55      -7.487   6.921  -7.336  0.00  0.00           H  
ATOM    850 HG23 THR A  55      -7.831   5.522  -8.353  0.00  0.00           H  
ATOM    851  N   GLU A  56      -6.027   7.929  -4.926  0.00  0.00           N  
ATOM    852  CA  GLU A  56      -6.492   9.168  -4.230  0.00  0.00           C  
ATOM    853  C   GLU A  56      -7.940   9.480  -4.619  0.00  0.00           C  
ATOM    854  O   GLU A  56      -8.270   9.305  -5.780  0.00  0.00           O  
ATOM    855  CB  GLU A  56      -5.557  10.281  -4.710  0.00  0.00           C  
ATOM    856  CG  GLU A  56      -5.680  11.496  -3.784  0.00  0.00           C  
ATOM    857  CD  GLU A  56      -6.601  12.541  -4.421  0.00  0.00           C  
ATOM    858  OE1 GLU A  56      -7.527  12.146  -5.111  0.00  0.00           O  
ATOM    859  OE2 GLU A  56      -6.365  13.719  -4.207  0.00  0.00           O  
ATOM    860  OXT GLU A  56      -8.692   9.887  -3.748  0.00  0.00           O  
ATOM    861  H   GLU A  56      -5.303   7.979  -5.586  0.00  0.00           H  
ATOM    862  HA  GLU A  56      -6.407   9.052  -3.160  0.00  0.00           H  
ATOM    863  HB2 GLU A  56      -4.538   9.922  -4.696  0.00  0.00           H  
ATOM    864  HB3 GLU A  56      -5.823  10.567  -5.717  0.00  0.00           H  
ATOM    865  HG2 GLU A  56      -6.091  11.186  -2.834  0.00  0.00           H  
ATOM    866  HG3 GLU A  56      -4.704  11.930  -3.628  0.00  0.00           H  
TER     867      GLU A  56                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
