
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  160 ( 1191),  selected  160 , name 2qea_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2qea_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      A       2           -
LGA    G     0_A      D       3          1.627
LGA    X     1_A      P       4          1.348
LGA    A     2_A      K       5          2.359
LGA    D     3_A      E       6          2.340
LGA    L     4_A      L       7          1.227
LGA    T     5_A      Q       8          1.301
LGA    H     6_A      D       9          2.163
LGA    E     7_A      K      10          1.968
LGA    F     8_A      F      11          1.000
LGA    W     9_A      W      12          0.944
LGA    D    10_A      K      13          1.815
LGA    R    11_A      A      14          1.675
LGA    L    12_A      L      15          0.809
LGA    E    13_A      K      16          0.590
LGA    D    14_A      S      17          1.033
LGA    V    15_A      D      18          1.246
LGA    R    16_A      R      19          3.594
LGA    S    17_A      T      20          1.560
LGA    G    18_A      V      21          1.563
LGA    X    19_A      M      22          0.224
LGA    L    20_A      L      23          0.702
LGA    G    21_A      G      24          1.788
LGA    I    22_A      L      25          1.637
LGA    K    23_A      D      26          1.416
LGA    G    24_A      G      27          3.004
LGA    Q    25_A      V      28          3.953
LGA    -       -      E      29           -
LGA    G    26_A      D      30          1.757
LGA    R    27_A      G      31          3.113
LGA    -       -      H      32           -
LGA    L    28_A      A      33          1.244
LGA    I    29_A      R      34          0.793
LGA    P    30_A      P      35          1.115
LGA    X    31_A      M      36          0.856
LGA    S    32_A      T      37          1.001
LGA    P    33_A      A      38          1.053
LGA    Q    34_A      Q      39          1.244
LGA    T    35_A      I      40          2.104
LGA    D    36_A      E      41          3.920
LGA    D    37_A      G      42          4.312
LGA    D    38_A      D      43          3.402
LGA    A    39_A      S      44          4.880
LGA    P    40_A      G      45          1.152
LGA    G    41_A      G      46          2.078
LGA    A    42_A      P      47          1.758
LGA    I    43_A      I      48          1.139
LGA    W    44_A      W      49          0.750
LGA    F    45_A      F      50          0.181
LGA    I    46_A      F      51          0.442
LGA    T    47_A      T      52          0.636
LGA    A    48_A      S      53          0.913
LGA    K    49_A      K      54          1.029
LGA    G    50_A      D      55          1.286
LGA    T    51_A      N      56          1.291
LGA    D    52_A      A      57          1.115
LGA    L    53_A      L      58          1.428
LGA    A    54_A      I      59          1.463
LGA    K    55_A      A      60          1.289
LGA    G    56_A      M      61          1.564
LGA    V    57_A      L      62          1.684
LGA    A    58_A      G      63          3.906
LGA    A    59_A      -       -           -
LGA    G    60_A      Q      64          1.524
LGA    P    61_A      G      65          0.883
LGA    Q    62_A      R      66          0.852
LGA    P    63_A      R      67          0.681
LGA    A    64_A      V      68          0.845
LGA    Q    65_A      I      69          1.063
LGA    F    66_A      G      70          0.529
LGA    V    67_A      A      71          0.514
LGA    V    68_A      F      72          0.579
LGA    S    69_A      S      73          1.932
LGA    D    70_A      S      74          2.625
LGA    D    71_A      K      75          3.786
LGA    G    72_A      G      76          2.228
LGA    E    73_A      H      77          6.211
LGA    G    74_A      D      78          2.248
LGA    L    75_A      L      79          2.444
LGA    Y    76_A      F      80          0.693
LGA    A    77_A      A      81          0.841
LGA    D    78_A      S      82          1.205
LGA    L    79_A      I      83          1.523
LGA    D    80_A      S      84          1.319
LGA    G    81_A      G      85          0.765
LGA    T    82_A      S      86          0.438
LGA    L    83_A      L      87          0.312
LGA    E    84_A      R      88          0.955
LGA    R    85_A      E      89          1.225
LGA    S    86_A      D      90          1.142
LGA    T    87_A      T      91          3.367
LGA    D    88_A      D      92          2.861
LGA    R    89_A      P      93          2.762
LGA    E    90_A      A      94          3.289
LGA    A    91_A      V      95          2.535
LGA    L    92_A      V      96          1.590
LGA    D    93_A      D      97          2.010
LGA    E    94_A      R      98          2.577
LGA    F    95_A      L      99          2.284
LGA    W    96_A      W     100          2.279
LGA    S    97_A      N     101          2.959
LGA    F    98_A      P     102          2.683
LGA    V    99_A      Y     103          3.499
LGA    A   100_A      V     104          2.731
LGA    D   101_A      A     105          2.775
LGA    A   102_A      A     106          3.318
LGA    W   103_A      W     107          2.790
LGA    F   104_A      Y     108          1.899
LGA    D   105_A      E     109          1.268
LGA    G   106_A      G     110          1.026
LGA    G   107_A      G     111          0.501
LGA    Q   108_A      K     112          1.535
LGA    H   109_A      D     113          2.162
LGA    D   110_A      D     114          1.468
LGA    P   111_A      P     115          1.099
LGA    D   112_A      K     116          1.261
LGA    V   113_A      L     117          0.709
LGA    C   114_A      A     118          0.616
LGA    L   115_A      L     119          0.651
LGA    L   116_A      L     120          0.434
LGA    K   117_A      R     121          0.579
LGA    F   118_A      L     122          0.678
LGA    T   119_A      D     123          1.693
LGA    P   120_A      A     124          1.753
LGA    A   121_A      D     125          1.411
LGA    S   122_A      H     126          1.986
LGA    G   123_A      A     127          2.398
LGA    E   124_A      Q     128          1.578
LGA    I   125_A      I     129          0.582
LGA    S   126_A      W     130          1.900
LGA    I   127_A      L     131          3.252
LGA    T   128_A      N     132          4.444
LGA    E   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    G   131_A      -       -           -
LGA    G   132_A      -       -           -
LGA    A   133_A      -       -           -
LGA    R   134_A      -       -           -
LGA    F   135_A      -       -           -
LGA    L   136_A      -       -           -
LGA    Y   137_A      -       -           -
LGA    E   138_A      -       -           -
LGA    I   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    K   141_A      -       -           -
LGA    A   142_A      -       -           -
LGA    H   143_A      -       -           -
LGA    L   144_A      -       -           -
LGA    T   145_A      -       -           -
LGA    D   146_A      -       -           -
LGA    E   147_A      -       -           -
LGA    T   148_A      -       -           -
LGA    P   149_A      -       -           -
LGA    D   150_A      G     133          5.080
LGA    X   151_A      S     134          4.359
LGA    G   152_A      S     135           -
LGA    E   153_A      L     136           -
LGA    Q   154_A      L     137           -
LGA    A   155_A      A     138           -
LGA    T   156_A      G     139           -
LGA    V   157_A      I     140           -
LGA    T   158_A      K     141           -
LGA    F   159_A      V     142           -
LGA    -       -      L     143           -
LGA    -       -      L     144           -
LGA    -       -      G     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  160  145    5.0    130    2.11    28.46     77.679     5.895

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.812754 * X  +   0.030966 * Y  +  -0.581783 * Z  + 132.390244
  Y_new =   0.560326 * X  +   0.315064 * Y  +  -0.766009 * Z  + 107.177994
  Z_new =   0.159579 * X  +  -0.948565 * Y  +  -0.273421 * Z  +  94.836838 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.851436    1.290157  [ DEG:  -106.0795     73.9205 ]
  Theta =  -0.160264   -2.981329  [ DEG:    -9.1824   -170.8176 ]
  Phi   =   2.538006   -0.603587  [ DEG:   145.4170    -34.5830 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qea_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qea_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  160  145   5.0  130   2.11   28.46  77.679
REMARK  ---------------------------------------------------------- 
MOLECULE 2qea_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JUN-07   2QEA              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE GENERAL STRESS PROTEIN 26               
TITLE    2 (YP_508897.1) FROM JANNASCHIA SP. CCS1 AT 2.46 A RESOLUTION          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE GENERAL STRESS PROTEIN 26;                        
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: JANNASCHIA SP. CCS1;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: CCS1;                                                        
SOURCE   5 GENE: YP_508897.1, JANN_0955;                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_508897.1, PUTATIVE GENERAL STRESS PROTEIN 26, STRUCTURAL           
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   10-JUL-07 2QEA    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE GENERAL STRESS                 
JRNL        TITL 2 PROTEIN 26 (YP_508897.1) FROM JANNASCHIA SP. CCS1            
JRNL        TITL 3 AT 2.46 A RESOLUTION                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.46 ANGSTROMS.                                          
DBREF  2QEA A    1   159  UNP    Q28TU0   Q28TU0_JANSC     1    159             
DBREF  2QEA B    1   159  UNP    Q28TU0   Q28TU0_JANSC     1    159             
DBREF  2QEA C    1   159  UNP    Q28TU0   Q28TU0_JANSC     1    159             
SEQRES   1 A  160  GLY MSE ALA ASP LEU THR HIS GLU PHE TRP ASP ARG LEU          
SEQRES   2 A  160  GLU ASP VAL ARG SER GLY MSE LEU GLY ILE LYS GLY GLN          
SEQRES   3 A  160  GLY ARG LEU ILE PRO MSE SER PRO GLN THR ASP ASP ASP          
SEQRES   4 A  160  ALA PRO GLY ALA ILE TRP PHE ILE THR ALA LYS GLY THR          
SEQRES   5 A  160  ASP LEU ALA LYS GLY VAL ALA ALA GLY PRO GLN PRO ALA          
SEQRES   6 A  160  GLN PHE VAL VAL SER ASP ASP GLY GLU GLY LEU TYR ALA          
SEQRES   7 A  160  ASP LEU ASP GLY THR LEU GLU ARG SER THR ASP ARG GLU          
SEQRES   8 A  160  ALA LEU ASP GLU PHE TRP SER PHE VAL ALA ASP ALA TRP          
SEQRES   9 A  160  PHE ASP GLY GLY GLN HIS ASP PRO ASP VAL CYS LEU LEU          
SEQRES  10 A  160  LYS PHE THR PRO ALA SER GLY GLU ILE SER ILE THR GLU          
SEQRES  11 A  160  GLY GLY GLY ALA ARG PHE LEU TYR GLU ILE ALA LYS ALA          
SEQRES  12 A  160  HIS LEU THR ASP GLU THR PRO ASP MSE GLY GLU GLN ALA          
SEQRES  13 A  160  THR VAL THR PHE                                              
SEQRES   1 B  160  GLY MSE ALA ASP LEU THR HIS GLU PHE TRP ASP ARG LEU          
SEQRES   2 B  160  GLU ASP VAL ARG SER GLY MSE LEU GLY ILE LYS GLY GLN          
SEQRES   3 B  160  GLY ARG LEU ILE PRO MSE SER PRO GLN THR ASP ASP ASP          
SEQRES   4 B  160  ALA PRO GLY ALA ILE TRP PHE ILE THR ALA LYS GLY THR          
SEQRES   5 B  160  ASP LEU ALA LYS GLY VAL ALA ALA GLY PRO GLN PRO ALA          
SEQRES   6 B  160  GLN PHE VAL VAL SER ASP ASP GLY GLU GLY LEU TYR ALA          
SEQRES   7 B  160  ASP LEU ASP GLY THR LEU GLU ARG SER THR ASP ARG GLU          
SEQRES   8 B  160  ALA LEU ASP GLU PHE TRP SER PHE VAL ALA ASP ALA TRP          
SEQRES   9 B  160  PHE ASP GLY GLY GLN HIS ASP PRO ASP VAL CYS LEU LEU          
SEQRES  10 B  160  LYS PHE THR PRO ALA SER GLY GLU ILE SER ILE THR GLU          
SEQRES  11 B  160  GLY GLY GLY ALA ARG PHE LEU TYR GLU ILE ALA LYS ALA          
SEQRES  12 B  160  HIS LEU THR ASP GLU THR PRO ASP MSE GLY GLU GLN ALA          
SEQRES  13 B  160  THR VAL THR PHE                                              
SEQRES   1 C  160  GLY MSE ALA ASP LEU THR HIS GLU PHE TRP ASP ARG LEU          
SEQRES   2 C  160  GLU ASP VAL ARG SER GLY MSE LEU GLY ILE LYS GLY GLN          
SEQRES   3 C  160  GLY ARG LEU ILE PRO MSE SER PRO GLN THR ASP ASP ASP          
SEQRES   4 C  160  ALA PRO GLY ALA ILE TRP PHE ILE THR ALA LYS GLY THR          
SEQRES   5 C  160  ASP LEU ALA LYS GLY VAL ALA ALA GLY PRO GLN PRO ALA          
SEQRES   6 C  160  GLN PHE VAL VAL SER ASP ASP GLY GLU GLY LEU TYR ALA          
SEQRES   7 C  160  ASP LEU ASP GLY THR LEU GLU ARG SER THR ASP ARG GLU          
SEQRES   8 C  160  ALA LEU ASP GLU PHE TRP SER PHE VAL ALA ASP ALA TRP          
SEQRES   9 C  160  PHE ASP GLY GLY GLN HIS ASP PRO ASP VAL CYS LEU LEU          
SEQRES  10 C  160  LYS PHE THR PRO ALA SER GLY GLU ILE SER ILE THR GLU          
SEQRES  11 C  160  GLY GLY GLY ALA ARG PHE LEU TYR GLU ILE ALA LYS ALA          
SEQRES  12 C  160  HIS LEU THR ASP GLU THR PRO ASP MSE GLY GLU GLN ALA          
SEQRES  13 C  160  THR VAL THR PHE                                              
HET    MSE  A   1       5                                                       
HET    MSE  A  19       8                                                       
HET    MSE  A  31       8                                                       
HET    MSE  A 151       5                                                       
HET    MSE  B   1       5                                                       
HET    MSE  B  19       8                                                       
HET    MSE  B  31       8                                                       
HET    MSE  B 151       8                                                       
HET    MSE  C   1       5                                                       
HET    MSE  C  19       8                                                       
HET    MSE  C  31       8                                                       
HET    MSE  C 151       8                                                       
HET     CA      1       1                                                       
HET     CA      2       1                                                       
HET     CA      3       1                                                       
HET     CA      4       1                                                       
HET     CA      5       1                                                       
HET     CA      6       1                                                       
HET     CA      7       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CA CALCIUM ION                                                      
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   4   CA    7(CA 2+)                                                     
FORMUL  11  HOH   *115(H2 O)                                                    
CRYST1   73.673   73.673  367.524  90.00  90.00 120.00 P 61 2 2     36          
ATOM      1  N   GLY A   0      10.775  44.502  21.246  1.00 67.83           N  
ATOM      2  CA  GLY A   0       9.745  44.064  22.235  1.00 67.67           C  
ATOM      3  C   GLY A   0       9.641  42.551  22.359  1.00 67.58           C  
ATOM      4  O   GLY A   0      10.032  41.817  21.444  1.00 67.79           O  
HETATM    5  N   MSE A   1       9.119  42.092  23.501  1.00 67.06           N  
HETATM    6  CA  MSE A   1       8.917  40.656  23.774  1.00 66.39           C  
HETATM    7  C   MSE A   1       7.750  40.107  22.943  1.00 65.79           C  
HETATM    8  O   MSE A   1       7.859  39.024  22.359  1.00 65.29           O  
HETATM    9  CB  MSE A   1       8.663  40.409  25.267  1.00 66.27           C  
ATOM     10  N   ALA A   2       6.642  40.859  22.912  1.00 64.99           N  
ATOM     11  CA  ALA A   2       5.449  40.515  22.112  1.00 64.18           C  
ATOM     12  C   ALA A   2       5.732  40.506  20.599  1.00 63.24           C  
ATOM     13  O   ALA A   2       5.208  39.650  19.882  1.00 63.17           O  
ATOM     14  CB  ALA A   2       4.289  41.472  22.428  1.00 63.75           C  
ATOM     15  N   ASP A   3       6.561  41.450  20.134  1.00 61.99           N  
ATOM     16  CA  ASP A   3       6.957  41.549  18.712  1.00 60.96           C  
ATOM     17  C   ASP A   3       7.778  40.338  18.253  1.00 59.61           C  
ATOM     18  O   ASP A   3       7.581  39.844  17.136  1.00 59.07           O  
ATOM     19  CB  ASP A   3       7.754  42.839  18.440  1.00 60.98           C  
ATOM     20  CG  ASP A   3       6.948  44.114  18.705  1.00 62.84           C  
ATOM     21  OD1 ASP A   3       7.519  45.211  18.531  1.00 66.08           O  
ATOM     22  OD2 ASP A   3       5.758  44.033  19.092  1.00 63.97           O  
ATOM     23  N   LEU A   4       8.690  39.878  19.116  1.00 58.30           N  
ATOM     24  CA  LEU A   4       9.512  38.683  18.847  1.00 57.17           C  
ATOM     25  C   LEU A   4       8.643  37.410  18.889  1.00 56.00           C  
ATOM     26  O   LEU A   4       8.908  36.467  18.139  1.00 55.70           O  
ATOM     27  CB  LEU A   4      10.702  38.605  19.822  1.00 57.59           C  
ATOM     28  CG  LEU A   4      11.863  37.641  19.521  1.00 58.14           C  
ATOM     29  CD1 LEU A   4      13.140  38.080  20.230  1.00 59.45           C  
ATOM     30  CD2 LEU A   4      11.537  36.199  19.876  1.00 60.35           C  
ATOM     31  N   THR A   5       7.617  37.395  19.753  1.00 54.79           N  
ATOM     32  CA  THR A   5       6.656  36.280  19.844  1.00 54.06           C  
ATOM     33  C   THR A   5       5.808  36.196  18.566  1.00 52.99           C  
ATOM     34  O   THR A   5       5.637  35.107  18.020  1.00 52.37           O  
ATOM     35  CB  THR A   5       5.692  36.417  21.055  1.00 54.06           C  
ATOM     36  OG1 THR A   5       6.435  36.701  22.244  1.00 54.79           O  
ATOM     37  CG2 THR A   5       4.886  35.135  21.256  1.00 54.58           C  
ATOM     38  N   HIS A   6       5.269  37.339  18.120  1.00 52.02           N  
ATOM     39  CA  HIS A   6       4.481  37.411  16.871  1.00 51.40           C  
ATOM     40  C   HIS A   6       5.287  36.920  15.662  1.00 49.87           C  
ATOM     41  O   HIS A   6       4.760  36.176  14.838  1.00 49.09           O  
ATOM     42  CB  HIS A   6       3.946  38.830  16.596  1.00 51.64           C  
ATOM     43  CG  HIS A   6       2.810  39.239  17.484  1.00 55.08           C  
ATOM     44  ND1 HIS A   6       2.947  40.171  18.492  1.00 58.59           N  
ATOM     45  CD2 HIS A   6       1.513  38.848  17.509  1.00 57.35           C  
ATOM     46  CE1 HIS A   6       1.786  40.334  19.101  1.00 57.37           C  
ATOM     47  NE2 HIS A   6       0.899  39.542  18.524  1.00 58.49           N  
ATOM     48  N   GLU A   7       6.560  37.320  15.592  1.00 48.64           N  
ATOM     49  CA  GLU A   7       7.472  36.917  14.508  1.00 48.06           C  
ATOM     50  C   GLU A   7       7.818  35.419  14.537  1.00 47.43           C  
ATOM     51  O   GLU A   7       8.086  34.836  13.483  1.00 47.01           O  
ATOM     52  CB  GLU A   7       8.756  37.767  14.538  1.00 48.25           C  
ATOM     53  CG  GLU A   7       9.684  37.648  13.314  1.00 48.32           C  
ATOM     54  CD  GLU A   7       9.070  38.145  12.008  1.00 48.23           C  
ATOM     55  OE1 GLU A   7       7.996  38.778  12.020  1.00 43.75           O  
ATOM     56  OE2 GLU A   7       9.679  37.918  10.947  1.00 51.40           O  
ATOM     57  N   PHE A   8       7.842  34.816  15.732  1.00 47.04           N  
ATOM     58  CA  PHE A   8       8.055  33.366  15.881  1.00 46.51           C  
ATOM     59  C   PHE A   8       6.926  32.600  15.166  1.00 46.07           C  
ATOM     60  O   PHE A   8       7.202  31.731  14.335  1.00 46.34           O  
ATOM     61  CB  PHE A   8       8.174  32.953  17.367  1.00 46.91           C  
ATOM     62  CG  PHE A   8       8.012  31.472  17.608  1.00 47.17           C  
ATOM     63  CD1 PHE A   8       9.095  30.603  17.474  1.00 47.83           C  
ATOM     64  CD2 PHE A   8       6.760  30.945  17.958  1.00 46.50           C  
ATOM     65  CE1 PHE A   8       8.940  29.227  17.691  1.00 49.79           C  
ATOM     66  CE2 PHE A   8       6.590  29.576  18.170  1.00 48.22           C  
ATOM     67  CZ  PHE A   8       7.678  28.714  18.041  1.00 49.48           C  
ATOM     68  N   TRP A   9       5.675  32.938  15.495  1.00 45.38           N  
ATOM     69  CA  TRP A   9       4.488  32.320  14.865  1.00 45.29           C  
ATOM     70  C   TRP A   9       4.395  32.658  13.376  1.00 45.11           C  
ATOM     71  O   TRP A   9       3.911  31.849  12.582  1.00 44.55           O  
ATOM     72  CB  TRP A   9       3.185  32.749  15.550  1.00 45.24           C  
ATOM     73  CG  TRP A   9       3.073  32.309  16.968  1.00 45.90           C  
ATOM     74  CD1 TRP A   9       3.126  33.101  18.075  1.00 44.93           C  
ATOM     75  CD2 TRP A   9       2.915  30.968  17.437  1.00 46.42           C  
ATOM     76  NE1 TRP A   9       2.994  32.341  19.208  1.00 46.31           N  
ATOM     77  CE2 TRP A   9       2.863  31.026  18.851  1.00 45.59           C  
ATOM     78  CE3 TRP A   9       2.803  29.719  16.804  1.00 45.80           C  
ATOM     79  CZ2 TRP A   9       2.706  29.880  19.648  1.00 44.84           C  
ATOM     80  CZ3 TRP A   9       2.642  28.574  17.596  1.00 45.55           C  
ATOM     81  CH2 TRP A   9       2.600  28.667  19.006  1.00 45.69           C  
ATOM     82  N   ASP A  10       4.850  33.861  13.024  1.00 45.07           N  
ATOM     83  CA  ASP A  10       4.885  34.339  11.645  1.00 44.90           C  
ATOM     84  C   ASP A  10       5.756  33.419  10.779  1.00 45.13           C  
ATOM     85  O   ASP A  10       5.308  32.977   9.721  1.00 43.85           O  
ATOM     86  CB  ASP A  10       5.422  35.784  11.612  1.00 44.75           C  
ATOM     87  CG  ASP A  10       5.249  36.469  10.276  1.00 44.37           C  
ATOM     88  OD1 ASP A  10       4.694  35.901   9.316  1.00 44.45           O  
ATOM     89  OD2 ASP A  10       5.670  37.638  10.165  1.00 43.36           O  
ATOM     90  N   ARG A  11       6.963  33.112  11.247  1.00 46.21           N  
ATOM     91  CA  ARG A  11       7.910  32.274  10.492  1.00 46.85           C  
ATOM     92  C   ARG A  11       7.761  30.761  10.664  1.00 46.90           C  
ATOM     93  O   ARG A  11       8.158  30.019   9.759  1.00 46.70           O  
ATOM     94  CB  ARG A  11       9.339  32.694  10.809  1.00 47.30           C  
ATOM     95  CG  ARG A  11       9.617  34.115  10.396  1.00 48.82           C  
ATOM     96  CD  ARG A  11      11.037  34.459  10.658  1.00 51.10           C  
ATOM     97  NE  ARG A  11      11.356  35.830  10.265  1.00 51.52           N  
ATOM     98  CZ  ARG A  11      12.540  36.412  10.452  1.00 50.87           C  
ATOM     99  NH1 ARG A  11      13.561  35.744  10.989  1.00 52.04           N  
ATOM    100  NH2 ARG A  11      12.714  37.677  10.071  1.00 51.82           N  
ATOM    101  N   LEU A  12       7.193  30.310  11.789  1.00 47.09           N  
ATOM    102  CA  LEU A  12       7.020  28.867  12.075  1.00 47.48           C  
ATOM    103  C   LEU A  12       6.198  28.084  11.032  1.00 47.77           C  
ATOM    104  O   LEU A  12       6.410  26.883  10.863  1.00 47.99           O  
ATOM    105  CB  LEU A  12       6.445  28.648  13.489  1.00 47.94           C  
ATOM    106  CG  LEU A  12       6.286  27.218  14.030  1.00 47.23           C  
ATOM    107  CD1 LEU A  12       7.596  26.453  13.973  1.00 47.78           C  
ATOM    108  CD2 LEU A  12       5.760  27.252  15.452  1.00 46.99           C  
ATOM    109  N   GLU A  13       5.287  28.769  10.339  1.00 48.22           N  
ATOM    110  CA  GLU A  13       4.466  28.178   9.260  1.00 48.97           C  
ATOM    111  C   GLU A  13       5.285  27.570   8.125  1.00 49.23           C  
ATOM    112  O   GLU A  13       4.974  26.473   7.652  1.00 49.47           O  
ATOM    113  CB  GLU A  13       3.584  29.240   8.622  1.00 49.01           C  
ATOM    114  CG  GLU A  13       2.509  29.786   9.507  1.00 48.89           C  
ATOM    115  CD  GLU A  13       1.737  30.860   8.810  1.00 47.81           C  
ATOM    116  OE1 GLU A  13       2.355  31.839   8.335  1.00 46.10           O  
ATOM    117  OE2 GLU A  13       0.495  30.757   8.736  1.00 46.34           O  
ATOM    118  N   ASP A  14       6.306  28.309   7.687  1.00 49.33           N  
ATOM    119  CA  ASP A  14       7.214  27.866   6.615  1.00 50.02           C  
ATOM    120  C   ASP A  14       8.304  26.867   7.060  1.00 49.30           C  
ATOM    121  O   ASP A  14       9.065  26.389   6.214  1.00 49.64           O  
ATOM    122  CB  ASP A  14       7.855  29.083   5.923  1.00 50.75           C  
ATOM    123  CG  ASP A  14       6.846  29.936   5.152  1.00 52.74           C  
ATOM    124  OD1 ASP A  14       5.628  29.860   5.423  1.00 55.51           O  
ATOM    125  OD2 ASP A  14       7.286  30.700   4.267  1.00 58.31           O  
ATOM    126  N   VAL A  15       8.380  26.554   8.359  1.00 48.90           N  
ATOM    127  CA  VAL A  15       9.349  25.589   8.898  1.00 48.32           C  
ATOM    128  C   VAL A  15       8.786  24.181   8.646  1.00 48.02           C  
ATOM    129  O   VAL A  15       7.766  23.806   9.227  1.00 48.86           O  
ATOM    130  CB  VAL A  15       9.615  25.822  10.409  1.00 48.13           C  
ATOM    131  CG1 VAL A  15      10.632  24.835  10.942  1.00 48.37           C  
ATOM    132  CG2 VAL A  15      10.108  27.252  10.651  1.00 48.10           C  
ATOM    133  N   ARG A  16       9.445  23.423   7.768  1.00 47.68           N  
ATOM    134  CA  ARG A  16       9.004  22.068   7.398  1.00 47.49           C  
ATOM    135  C   ARG A  16       9.218  21.017   8.487  1.00 47.44           C  
ATOM    136  O   ARG A  16       8.401  20.098   8.614  1.00 47.56           O  
ATOM    137  CB  ARG A  16       9.701  21.600   6.111  1.00 46.80           C  
ATOM    138  N   SER A  17      10.301  21.151   9.259  1.00 47.26           N  
ATOM    139  CA  SER A  17      10.667  20.178  10.294  1.00 47.27           C  
ATOM    140  C   SER A  17      11.048  20.798  11.638  1.00 47.11           C  
ATOM    141  O   SER A  17      11.441  21.964  11.723  1.00 46.53           O  
ATOM    142  CB  SER A  17      11.841  19.321   9.809  1.00 46.97           C  
ATOM    143  OG  SER A  17      11.530  18.661   8.594  1.00 49.62           O  
ATOM    144  N   GLY A  18      10.927  19.977  12.678  1.00 46.87           N  
ATOM    145  CA  GLY A  18      11.280  20.335  14.051  1.00 46.96           C  
ATOM    146  C   GLY A  18      11.544  19.072  14.855  1.00 46.79           C  
ATOM    147  O   GLY A  18      11.127  17.985  14.450  1.00 46.23           O  
HETATM  148  N   MSE A  19      12.229  19.222  15.987  1.00 46.70           N  
HETATM  149  CA  MSE A  19      12.621  18.096  16.843  1.00 46.84           C  
HETATM  150  C   MSE A  19      11.748  18.094  18.098  1.00 46.59           C  
HETATM  151  O   MSE A  19      11.910  18.959  18.964  1.00 46.38           O  
HETATM  152  CB  MSE A  19      14.108  18.207  17.183  1.00 47.25           C  
HETATM  153  CG  MSE A  19      15.025  18.207  15.963  1.00 47.38           C  
HETATM  154 SE   MSE A  19      15.099  16.499  15.051  0.75 52.55          SE  
HETATM  155  CE  MSE A  19      16.025  15.459  16.422  1.00 48.61           C  
ATOM    156  N   LEU A  20      10.834  17.120  18.181  1.00 46.08           N  
ATOM    157  CA  LEU A  20       9.845  17.012  19.269  1.00 45.77           C  
ATOM    158  C   LEU A  20      10.134  15.859  20.228  1.00 45.79           C  
ATOM    159  O   LEU A  20      10.677  14.828  19.827  1.00 45.78           O  
ATOM    160  CB  LEU A  20       8.453  16.818  18.659  1.00 45.41           C  
ATOM    161  CG  LEU A  20       7.209  16.794  19.558  1.00 46.32           C  
ATOM    162  CD1 LEU A  20       7.053  18.090  20.344  1.00 44.30           C  
ATOM    163  CD2 LEU A  20       5.977  16.535  18.702  1.00 45.76           C  
ATOM    164  N   GLY A  21       9.735  16.035  21.488  1.00 45.88           N  
ATOM    165  CA  GLY A  21       9.929  15.012  22.515  1.00 46.20           C  
ATOM    166  C   GLY A  21       9.276  15.320  23.853  1.00 46.30           C  
ATOM    167  O   GLY A  21       9.047  16.488  24.184  1.00 45.60           O  
ATOM    168  N   ILE A  22       8.971  14.258  24.603  1.00 46.83           N  
ATOM    169  CA  ILE A  22       8.388  14.344  25.949  1.00 47.12           C  
ATOM    170  C   ILE A  22       9.573  14.377  26.912  1.00 48.07           C  
ATOM    171  O   ILE A  22      10.506  13.585  26.757  1.00 48.27           O  
ATOM    172  CB  ILE A  22       7.467  13.131  26.258  1.00 46.84           C  
ATOM    173  CG1 ILE A  22       6.324  13.051  25.236  1.00 46.64           C  
ATOM    174  CG2 ILE A  22       6.897  13.225  27.671  1.00 44.46           C  
ATOM    175  CD1 ILE A  22       5.413  11.861  25.407  1.00 46.78           C  
ATOM    176  N   LYS A  23       9.538  15.283  27.894  1.00 49.56           N  
ATOM    177  CA  LYS A  23      10.648  15.444  28.858  1.00 50.67           C  
ATOM    178  C   LYS A  23      10.872  14.199  29.717  1.00 50.86           C  
ATOM    179  O   LYS A  23       9.920  13.648  30.274  1.00 50.97           O  
ATOM    180  CB  LYS A  23      10.446  16.670  29.753  1.00 50.40           C  
ATOM    181  CG  LYS A  23      10.577  17.985  29.013  1.00 52.08           C  
ATOM    182  CD  LYS A  23      10.513  19.165  29.970  1.00 52.79           C  
ATOM    183  CE  LYS A  23      10.750  20.485  29.255  1.00 57.12           C  
ATOM    184  NZ  LYS A  23      12.128  20.579  28.672  1.00 59.24           N  
ATOM    185  N   GLY A  24      12.132  13.767  29.799  1.00 51.34           N  
ATOM    186  CA  GLY A  24      12.516  12.571  30.552  1.00 51.99           C  
ATOM    187  C   GLY A  24      12.168  11.233  29.912  1.00 52.30           C  
ATOM    188  O   GLY A  24      12.206  10.209  30.599  1.00 52.50           O  
ATOM    189  N   GLN A  25      11.835  11.237  28.614  1.00 52.83           N  
ATOM    190  CA  GLN A  25      11.479  10.028  27.855  1.00 54.02           C  
ATOM    191  C   GLN A  25      12.174  10.030  26.490  1.00 53.34           C  
ATOM    192  O   GLN A  25      11.711  10.680  25.551  1.00 53.43           O  
ATOM    193  CB  GLN A  25       9.959   9.925  27.678  1.00 53.97           C  
ATOM    194  CG  GLN A  25       9.193   9.690  28.982  1.00 56.25           C  
ATOM    195  CD  GLN A  25       7.680   9.591  28.795  1.00 56.19           C  
ATOM    196  OE1 GLN A  25       7.166   9.608  27.674  1.00 60.34           O  
ATOM    197  NE2 GLN A  25       6.960   9.488  29.906  1.00 60.88           N  
ATOM    198  N   GLY A  26      13.300   9.320  26.406  1.00 53.37           N  
ATOM    199  CA  GLY A  26      14.074   9.194  25.172  1.00 53.38           C  
ATOM    200  C   GLY A  26      14.691  10.491  24.679  1.00 53.24           C  
ATOM    201  O   GLY A  26      14.874  11.439  25.451  1.00 53.92           O  
ATOM    202  N   ARG A  27      15.001  10.516  23.385  1.00 52.56           N  
ATOM    203  CA  ARG A  27      15.578  11.679  22.710  1.00 51.71           C  
ATOM    204  C   ARG A  27      14.557  12.340  21.787  1.00 50.38           C  
ATOM    205  O   ARG A  27      13.472  11.800  21.553  1.00 49.82           O  
ATOM    206  CB  ARG A  27      16.817  11.258  21.918  1.00 52.27           C  
ATOM    207  CG  ARG A  27      17.952  10.747  22.794  1.00 53.42           C  
ATOM    208  CD  ARG A  27      19.255  10.706  22.020  1.00 57.31           C  
ATOM    209  NE  ARG A  27      20.370  10.215  22.830  1.00 58.14           N  
ATOM    210  CZ  ARG A  27      20.683   8.932  23.050  1.00 59.04           C  
ATOM    211  NH1 ARG A  27      19.966   7.921  22.539  1.00 59.98           N  
ATOM    212  NH2 ARG A  27      21.738   8.650  23.815  1.00 60.19           N  
ATOM    213  N   LEU A  28      14.911  13.523  21.284  1.00 49.55           N  
ATOM    214  CA  LEU A  28      14.058  14.277  20.358  1.00 48.77           C  
ATOM    215  C   LEU A  28      14.111  13.617  18.972  1.00 47.83           C  
ATOM    216  O   LEU A  28      15.184  13.177  18.545  1.00 47.53           O  
ATOM    217  CB  LEU A  28      14.514  15.738  20.250  1.00 48.75           C  
ATOM    218  CG  LEU A  28      14.575  16.587  21.526  1.00 48.17           C  
ATOM    219  CD1 LEU A  28      15.301  17.901  21.253  1.00 46.68           C  
ATOM    220  CD2 LEU A  28      13.183  16.842  22.087  1.00 44.86           C  
ATOM    221  N   ILE A  29      12.957  13.547  18.297  1.00 46.95           N  
ATOM    222  CA  ILE A  29      12.828  12.959  16.946  1.00 46.16           C  
ATOM    223  C   ILE A  29      12.242  13.988  15.965  1.00 46.02           C  
ATOM    224  O   ILE A  29      11.480  14.866  16.395  1.00 45.58           O  
ATOM    225  CB  ILE A  29      11.973  11.652  16.950  1.00 46.15           C  
ATOM    226  CG1 ILE A  29      10.522  11.900  17.410  1.00 46.70           C  
ATOM    227  CG2 ILE A  29      12.644  10.597  17.829  1.00 42.92           C  
ATOM    228  CD1 ILE A  29       9.636  10.665  17.323  1.00 45.85           C  
ATOM    229  N   PRO A  30      12.571  13.875  14.653  1.00 45.63           N  
ATOM    230  CA  PRO A  30      12.035  14.832  13.674  1.00 45.41           C  
ATOM    231  C   PRO A  30      10.523  14.676  13.428  1.00 45.52           C  
ATOM    232  O   PRO A  30      10.046  13.553  13.235  1.00 45.45           O  
ATOM    233  CB  PRO A  30      12.835  14.518  12.403  1.00 45.07           C  
ATOM    234  CG  PRO A  30      13.196  13.099  12.536  1.00 45.63           C  
ATOM    235  CD  PRO A  30      13.446  12.880  13.997  1.00 45.58           C  
HETATM  236  N   MSE A  31       9.798  15.798  13.474  1.00 45.73           N  
HETATM  237  CA  MSE A  31       8.342  15.869  13.239  1.00 45.97           C  
HETATM  238  C   MSE A  31       8.017  17.080  12.355  1.00 46.24           C  
HETATM  239  O   MSE A  31       8.815  18.014  12.280  1.00 46.03           O  
HETATM  240  CB  MSE A  31       7.591  16.013  14.565  1.00 45.95           C  
HETATM  241  CG  MSE A  31       7.792  14.875  15.549  1.00 46.51           C  
HETATM  242 SE   MSE A  31       7.033  13.197  14.937  0.75 51.78          SE  
HETATM  243  CE  MSE A  31       5.146  13.657  15.127  1.00 42.01           C  
ATOM    244  N   SER A  32       6.846  17.058  11.713  1.00 46.42           N  
ATOM    245  CA  SER A  32       6.391  18.141  10.822  1.00 46.74           C  
ATOM    246  C   SER A  32       5.395  19.068  11.535  1.00 46.50           C  
ATOM    247  O   SER A  32       4.225  18.699  11.673  1.00 45.72           O  
ATOM    248  CB  SER A  32       5.748  17.561   9.556  1.00 46.74           C  
ATOM    249  OG  SER A  32       6.703  16.858   8.784  1.00 48.28           O  
ATOM    250  N   PRO A  33       5.844  20.273  11.982  1.00 47.16           N  
ATOM    251  CA  PRO A  33       4.909  21.179  12.661  1.00 47.40           C  
ATOM    252  C   PRO A  33       3.931  21.832  11.676  1.00 47.82           C  
ATOM    253  O   PRO A  33       4.349  22.311  10.614  1.00 48.14           O  
ATOM    254  CB  PRO A  33       5.833  22.227  13.288  1.00 47.19           C  
ATOM    255  CG  PRO A  33       6.983  22.293  12.361  1.00 47.79           C  
ATOM    256  CD  PRO A  33       7.190  20.880  11.889  1.00 47.39           C  
ATOM    257  N   GLN A  34       2.645  21.812  12.024  1.00 47.94           N  
ATOM    258  CA  GLN A  34       1.588  22.403  11.210  1.00 48.96           C  
ATOM    259  C   GLN A  34       0.971  23.526  12.033  1.00 49.76           C  
ATOM    260  O   GLN A  34       0.468  23.277  13.131  1.00 50.01           O  
ATOM    261  CB  GLN A  34       0.533  21.355  10.849  1.00 48.88           C  
ATOM    262  CG  GLN A  34       1.071  20.083  10.175  1.00 49.97           C  
ATOM    263  CD  GLN A  34       1.762  20.343   8.841  1.00 50.37           C  
ATOM    264  OE1 GLN A  34       1.268  21.099   8.005  1.00 50.62           O  
ATOM    265  NE2 GLN A  34       2.901  19.694   8.632  1.00 53.27           N  
ATOM    266  N   THR A  35       1.061  24.759  11.531  1.00 50.23           N  
ATOM    267  CA  THR A  35       0.513  25.941  12.211  1.00 50.65           C  
ATOM    268  C   THR A  35      -0.124  26.921  11.228  1.00 51.13           C  
ATOM    269  O   THR A  35       0.014  26.783  10.006  1.00 51.41           O  
ATOM    270  CB  THR A  35       1.602  26.696  13.025  1.00 50.54           C  
ATOM    271  OG1 THR A  35       2.606  27.218  12.143  1.00 51.73           O  
ATOM    272  CG2 THR A  35       2.264  25.786  14.053  1.00 50.39           C  
ATOM    273  N   ASP A  36      -0.846  27.884  11.790  1.00 51.51           N  
ATOM    274  CA  ASP A  36      -1.487  28.961  11.038  1.00 51.93           C  
ATOM    275  C   ASP A  36      -1.343  30.211  11.907  1.00 51.77           C  
ATOM    276  O   ASP A  36      -1.825  30.221  13.041  1.00 51.19           O  
ATOM    277  CB  ASP A  36      -2.959  28.616  10.770  1.00 52.19           C  
ATOM    278  CG  ASP A  36      -3.608  29.506   9.707  1.00 52.94           C  
ATOM    279  OD1 ASP A  36      -3.192  30.670   9.502  1.00 55.08           O  
ATOM    280  OD2 ASP A  36      -4.570  29.025   9.071  1.00 52.25           O  
ATOM    281  N   ASP A  37      -0.686  31.251  11.377  1.00 51.95           N  
ATOM    282  CA  ASP A  37      -0.464  32.507  12.136  1.00 52.00           C  
ATOM    283  C   ASP A  37      -1.729  33.364  12.357  1.00 51.86           C  
ATOM    284  O   ASP A  37      -1.665  34.362  13.070  1.00 52.08           O  
ATOM    285  CB  ASP A  37       0.745  33.330  11.620  1.00 51.88           C  
ATOM    286  CG  ASP A  37       0.609  33.806  10.178  1.00 51.53           C  
ATOM    287  OD1 ASP A  37      -0.408  33.535   9.500  1.00 52.51           O  
ATOM    288  OD2 ASP A  37       1.574  34.443   9.706  1.00 49.85           O  
ATOM    289  N   ASP A  38      -2.845  32.996  11.715  1.00 52.08           N  
ATOM    290  CA  ASP A  38      -4.159  33.599  11.995  1.00 52.80           C  
ATOM    291  C   ASP A  38      -4.661  33.118  13.368  1.00 52.27           C  
ATOM    292  O   ASP A  38      -5.307  33.883  14.083  1.00 52.73           O  
ATOM    293  CB  ASP A  38      -5.194  33.245  10.912  1.00 53.25           C  
ATOM    294  CG  ASP A  38      -4.865  33.850   9.547  1.00 55.59           C  
ATOM    295  OD1 ASP A  38      -3.752  34.396   9.354  1.00 59.03           O  
ATOM    296  OD2 ASP A  38      -5.738  33.772   8.654  1.00 58.06           O  
ATOM    297  N   ALA A  39      -4.359  31.859  13.713  1.00 52.23           N  
ATOM    298  CA  ALA A  39      -4.715  31.238  14.998  1.00 51.82           C  
ATOM    299  C   ALA A  39      -3.453  30.714  15.722  1.00 51.40           C  
ATOM    300  O   ALA A  39      -3.225  29.499  15.775  1.00 51.56           O  
ATOM    301  CB  ALA A  39      -5.722  30.107  14.765  1.00 51.47           C  
ATOM    302  N   PRO A  40      -2.614  31.629  16.265  1.00 51.02           N  
ATOM    303  CA  PRO A  40      -1.408  31.212  16.991  1.00 50.61           C  
ATOM    304  C   PRO A  40      -1.727  30.710  18.403  1.00 50.34           C  
ATOM    305  O   PRO A  40      -2.823  30.959  18.917  1.00 50.78           O  
ATOM    306  CB  PRO A  40      -0.588  32.500  17.059  1.00 50.66           C  
ATOM    307  CG  PRO A  40      -1.605  33.566  17.127  1.00 50.25           C  
ATOM    308  CD  PRO A  40      -2.740  33.100  16.251  1.00 50.97           C  
ATOM    309  N   GLY A  41      -0.762  30.023  19.012  1.00 49.91           N  
ATOM    310  CA  GLY A  41      -0.889  29.485  20.373  1.00 49.02           C  
ATOM    311  C   GLY A  41      -0.481  28.032  20.521  1.00 48.19           C  
ATOM    312  O   GLY A  41       0.040  27.657  21.572  1.00 48.26           O  
ATOM    313  N   ALA A  42      -0.737  27.220  19.488  1.00 47.44           N  
ATOM    314  CA  ALA A  42      -0.413  25.785  19.485  1.00 47.00           C  
ATOM    315  C   ALA A  42       0.271  25.332  18.185  1.00 46.72           C  
ATOM    316  O   ALA A  42       0.015  25.891  17.112  1.00 46.62           O  
ATOM    317  CB  ALA A  42      -1.677  24.974  19.715  1.00 46.25           C  
ATOM    318  N   ILE A  43       1.138  24.319  18.309  1.00 46.13           N  
ATOM    319  CA  ILE A  43       1.852  23.696  17.185  1.00 45.47           C  
ATOM    320  C   ILE A  43       1.271  22.285  17.059  1.00 45.32           C  
ATOM    321  O   ILE A  43       1.310  21.514  18.023  1.00 45.15           O  
ATOM    322  CB  ILE A  43       3.379  23.631  17.412  1.00 45.29           C  
ATOM    323  CG1 ILE A  43       3.952  25.026  17.720  1.00 45.61           C  
ATOM    324  CG2 ILE A  43       4.064  23.037  16.179  1.00 42.64           C  
ATOM    325  CD1 ILE A  43       5.452  25.044  18.003  1.00 45.06           C  
ATOM    326  N   TRP A  44       0.756  21.955  15.871  1.00 44.91           N  
ATOM    327  CA  TRP A  44       0.061  20.683  15.616  1.00 44.86           C  
ATOM    328  C   TRP A  44       0.919  19.670  14.852  1.00 44.93           C  
ATOM    329  O   TRP A  44       1.691  20.057  13.968  1.00 45.11           O  
ATOM    330  CB  TRP A  44      -1.233  20.953  14.845  1.00 44.47           C  
ATOM    331  CG  TRP A  44      -2.129  21.954  15.525  1.00 44.25           C  
ATOM    332  CD1 TRP A  44      -2.056  23.318  15.443  1.00 44.86           C  
ATOM    333  CD2 TRP A  44      -3.220  21.666  16.399  1.00 43.70           C  
ATOM    334  NE1 TRP A  44      -3.044  23.896  16.201  1.00 45.14           N  
ATOM    335  CE2 TRP A  44      -3.774  22.906  16.803  1.00 44.32           C  
ATOM    336  CE3 TRP A  44      -3.791  20.479  16.880  1.00 43.27           C  
ATOM    337  CZ2 TRP A  44      -4.877  22.994  17.668  1.00 44.35           C  
ATOM    338  CZ3 TRP A  44      -4.886  20.563  17.740  1.00 44.12           C  
ATOM    339  CH2 TRP A  44      -5.419  21.815  18.126  1.00 44.49           C  
ATOM    340  N   PHE A  45       0.775  18.386  15.207  1.00 44.61           N  
ATOM    341  CA  PHE A  45       1.502  17.271  14.571  1.00 44.52           C  
ATOM    342  C   PHE A  45       0.568  16.087  14.302  1.00 44.55           C  
ATOM    343  O   PHE A  45      -0.249  15.744  15.158  1.00 44.52           O  
ATOM    344  CB  PHE A  45       2.650  16.773  15.460  1.00 44.57           C  
ATOM    345  CG  PHE A  45       3.605  17.847  15.895  1.00 45.08           C  
ATOM    346  CD1 PHE A  45       4.725  18.166  15.122  1.00 44.59           C  
ATOM    347  CD2 PHE A  45       3.391  18.536  17.096  1.00 45.34           C  
ATOM    348  CE1 PHE A  45       5.621  19.170  15.533  1.00 45.32           C  
ATOM    349  CE2 PHE A  45       4.271  19.536  17.517  1.00 45.75           C  
ATOM    350  CZ  PHE A  45       5.389  19.858  16.738  1.00 45.84           C  
ATOM    351  N   ILE A  46       0.698  15.478  13.120  1.00 45.02           N  
ATOM    352  CA  ILE A  46      -0.058  14.284  12.726  1.00 45.42           C  
ATOM    353  C   ILE A  46       0.927  13.114  12.835  1.00 45.91           C  
ATOM    354  O   ILE A  46       1.960  13.119  12.158  1.00 45.76           O  
ATOM    355  CB  ILE A  46      -0.612  14.395  11.284  1.00 45.22           C  
ATOM    356  CG1 ILE A  46      -1.564  15.592  11.164  1.00 45.72           C  
ATOM    357  CG2 ILE A  46      -1.345  13.113  10.886  1.00 44.30           C  
ATOM    358  CD1 ILE A  46      -2.125  15.807   9.767  1.00 45.73           C  
ATOM    359  N   THR A  47       0.610  12.136  13.689  1.00 46.31           N  
ATOM    360  CA  THR A  47       1.460  10.956  13.922  1.00 46.60           C  
ATOM    361  C   THR A  47       0.638   9.663  14.061  1.00 46.44           C  
ATOM    362  O   THR A  47      -0.595   9.695  14.035  1.00 46.45           O  
ATOM    363  CB  THR A  47       2.346  11.169  15.177  1.00 46.80           C  
ATOM    364  OG1 THR A  47       3.281  10.089  15.313  1.00 47.92           O  
ATOM    365  CG2 THR A  47       1.495  11.291  16.445  1.00 47.56           C  
ATOM    366  N   ALA A  48       1.342   8.534  14.172  1.00 46.42           N  
ATOM    367  CA  ALA A  48       0.729   7.208  14.320  1.00 46.51           C  
ATOM    368  C   ALA A  48       0.447   6.903  15.797  1.00 46.83           C  
ATOM    369  O   ALA A  48       1.214   7.326  16.665  1.00 47.03           O  
ATOM    370  CB  ALA A  48       1.637   6.136  13.725  1.00 46.13           C  
ATOM    371  N   LYS A  49      -0.646   6.180  16.072  1.00 47.12           N  
ATOM    372  CA  LYS A  49      -1.010   5.778  17.455  1.00 47.22           C  
ATOM    373  C   LYS A  49       0.017   4.838  18.111  1.00 46.92           C  
ATOM    374  O   LYS A  49       0.193   4.876  19.330  1.00 46.58           O  
ATOM    375  CB  LYS A  49      -2.405   5.131  17.529  1.00 47.18           C  
ATOM    376  CG  LYS A  49      -3.569   6.092  17.337  1.00 48.21           C  
ATOM    377  CD  LYS A  49      -4.898   5.425  17.692  1.00 47.87           C  
ATOM    378  CE  LYS A  49      -6.083   6.363  17.471  1.00 48.24           C  
ATOM    379  NZ  LYS A  49      -7.387   5.682  17.692  1.00 46.64           N  
ATOM    380  N   GLY A  50       0.681   4.009  17.301  1.00 47.15           N  
ATOM    381  CA  GLY A  50       1.717   3.088  17.780  1.00 47.30           C  
ATOM    382  C   GLY A  50       3.065   3.698  18.157  1.00 47.41           C  
ATOM    383  O   GLY A  50       3.901   2.995  18.732  1.00 47.72           O  
ATOM    384  N   THR A  51       3.289   4.980  17.836  1.00 47.34           N  
ATOM    385  CA  THR A  51       4.555   5.671  18.155  1.00 47.33           C  
ATOM    386  C   THR A  51       4.690   5.974  19.652  1.00 47.32           C  
ATOM    387  O   THR A  51       3.700   5.965  20.390  1.00 46.98           O  
ATOM    388  CB  THR A  51       4.723   6.999  17.364  1.00 47.11           C  
ATOM    389  OG1 THR A  51       3.654   7.901  17.682  1.00 48.09           O  
ATOM    390  CG2 THR A  51       4.743   6.744  15.864  1.00 46.03           C  
ATOM    391  N   ASP A  52       5.921   6.258  20.077  1.00 47.56           N  
ATOM    392  CA  ASP A  52       6.225   6.558  21.487  1.00 47.87           C  
ATOM    393  C   ASP A  52       5.595   7.869  21.969  1.00 47.82           C  
ATOM    394  O   ASP A  52       5.127   7.935  23.111  1.00 47.90           O  
ATOM    395  CB  ASP A  52       7.743   6.567  21.746  1.00 48.19           C  
ATOM    396  CG  ASP A  52       8.406   5.209  21.492  1.00 48.81           C  
ATOM    397  OD1 ASP A  52       7.721   4.239  21.099  1.00 49.84           O  
ATOM    398  OD2 ASP A  52       9.635   5.116  21.686  1.00 52.42           O  
ATOM    399  N   LEU A  53       5.584   8.892  21.106  1.00 47.71           N  
ATOM    400  CA  LEU A  53       4.942  10.185  21.425  1.00 48.11           C  
ATOM    401  C   LEU A  53       3.426  10.046  21.636  1.00 48.17           C  
ATOM    402  O   LEU A  53       2.875  10.678  22.540  1.00 48.40           O  
ATOM    403  CB  LEU A  53       5.218  11.243  20.341  1.00 47.92           C  
ATOM    404  CG  LEU A  53       6.652  11.752  20.186  1.00 48.37           C  
ATOM    405  CD1 LEU A  53       6.758  12.648  18.960  1.00 49.72           C  
ATOM    406  CD2 LEU A  53       7.124  12.489  21.439  1.00 48.12           C  
ATOM    407  N   ALA A  54       2.774   9.224  20.805  1.00 48.08           N  
ATOM    408  CA  ALA A  54       1.329   8.958  20.915  1.00 48.07           C  
ATOM    409  C   ALA A  54       1.009   8.212  22.211  1.00 47.93           C  
ATOM    410  O   ALA A  54       0.136   8.637  22.974  1.00 47.54           O  
ATOM    411  CB  ALA A  54       0.825   8.166  19.712  1.00 48.14           C  
ATOM    412  N   LYS A  55       1.727   7.112  22.450  1.00 47.93           N  
ATOM    413  CA  LYS A  55       1.566   6.313  23.681  1.00 48.12           C  
ATOM    414  C   LYS A  55       1.948   7.094  24.948  1.00 47.76           C  
ATOM    415  O   LYS A  55       1.334   6.895  25.994  1.00 47.84           O  
ATOM    416  CB  LYS A  55       2.362   5.000  23.608  1.00 48.10           C  
ATOM    417  CG  LYS A  55       1.853   4.019  22.547  1.00 48.38           C  
ATOM    418  CD  LYS A  55       2.577   2.668  22.570  1.00 49.17           C  
ATOM    419  CE  LYS A  55       4.063   2.775  22.224  1.00 52.29           C  
ATOM    420  NZ  LYS A  55       4.701   1.431  22.091  1.00 53.78           N  
ATOM    421  N   GLY A  56       2.950   7.971  24.841  1.00 48.23           N  
ATOM    422  CA  GLY A  56       3.400   8.812  25.956  1.00 48.20           C  
ATOM    423  C   GLY A  56       2.377   9.824  26.456  1.00 48.59           C  
ATOM    424  O   GLY A  56       2.370  10.150  27.644  1.00 49.24           O  
ATOM    425  N   VAL A  57       1.527  10.319  25.548  1.00 48.67           N  
ATOM    426  CA  VAL A  57       0.460  11.288  25.864  1.00 48.38           C  
ATOM    427  C   VAL A  57      -0.959  10.672  25.854  1.00 48.55           C  
ATOM    428  O   VAL A  57      -1.946  11.416  25.875  1.00 48.44           O  
ATOM    429  CB  VAL A  57       0.513  12.522  24.902  1.00 48.67           C  
ATOM    430  CG1 VAL A  57       1.887  13.179  24.953  1.00 47.92           C  
ATOM    431  CG2 VAL A  57       0.146  12.140  23.463  1.00 47.72           C  
ATOM    432  N   ALA A  58      -1.057   9.334  25.847  1.00 48.75           N  
ATOM    433  CA  ALA A  58      -2.352   8.620  25.834  1.00 49.08           C  
ATOM    434  C   ALA A  58      -3.131   8.797  27.142  1.00 49.22           C  
ATOM    435  O   ALA A  58      -4.341   9.029  27.112  1.00 49.33           O  
ATOM    436  CB  ALA A  58      -2.147   7.130  25.539  1.00 48.89           C  
ATOM    437  N   ALA A  59      -2.431   8.680  28.273  1.00 49.61           N  
ATOM    438  CA  ALA A  59      -3.027   8.875  29.607  1.00 49.77           C  
ATOM    439  C   ALA A  59      -3.429  10.336  29.879  1.00 49.90           C  
ATOM    440  O   ALA A  59      -4.416  10.579  30.575  1.00 50.50           O  
ATOM    441  CB  ALA A  59      -2.081   8.377  30.700  1.00 49.54           C  
ATOM    442  N   GLY A  60      -2.668  11.291  29.336  1.00 49.80           N  
ATOM    443  CA  GLY A  60      -2.955  12.729  29.501  1.00 49.50           C  
ATOM    444  C   GLY A  60      -1.807  13.647  29.085  1.00 49.46           C  
ATOM    445  O   GLY A  60      -0.776  13.154  28.613  1.00 49.88           O  
ATOM    446  N   PRO A  61      -1.980  14.986  29.231  1.00 49.14           N  
ATOM    447  CA  PRO A  61      -0.923  15.960  28.893  1.00 49.04           C  
ATOM    448  C   PRO A  61       0.395  15.753  29.660  1.00 49.28           C  
ATOM    449  O   PRO A  61       0.363  15.465  30.866  1.00 50.00           O  
ATOM    450  CB  PRO A  61      -1.551  17.312  29.263  1.00 49.09           C  
ATOM    451  CG  PRO A  61      -3.003  17.083  29.224  1.00 49.07           C  
ATOM    452  CD  PRO A  61      -3.207  15.673  29.682  1.00 49.07           C  
ATOM    453  N   GLN A  62       1.522  15.890  28.953  1.00 48.56           N  
ATOM    454  CA  GLN A  62       2.873  15.706  29.507  1.00 48.62           C  
ATOM    455  C   GLN A  62       3.795  16.880  29.153  1.00 48.33           C  
ATOM    456  O   GLN A  62       3.661  17.431  28.056  1.00 48.31           O  
ATOM    457  CB  GLN A  62       3.499  14.428  28.931  1.00 48.50           C  
ATOM    458  CG  GLN A  62       2.828  13.125  29.358  1.00 49.58           C  
ATOM    459  CD  GLN A  62       2.993  12.799  30.834  1.00 48.01           C  
ATOM    460  OE1 GLN A  62       3.926  13.260  31.497  1.00 48.03           O  
ATOM    461  NE2 GLN A  62       2.087  11.984  31.352  1.00 50.59           N  
ATOM    462  N   PRO A  63       4.723  17.273  30.072  1.00 47.89           N  
ATOM    463  CA  PRO A  63       5.718  18.305  29.726  1.00 47.67           C  
ATOM    464  C   PRO A  63       6.573  17.857  28.533  1.00 47.80           C  
ATOM    465  O   PRO A  63       7.024  16.706  28.499  1.00 47.65           O  
ATOM    466  CB  PRO A  63       6.575  18.421  30.996  1.00 47.57           C  
ATOM    467  CG  PRO A  63       5.718  17.918  32.082  1.00 47.57           C  
ATOM    468  CD  PRO A  63       4.881  16.840  31.477  1.00 47.73           C  
ATOM    469  N   ALA A  64       6.760  18.752  27.563  1.00 47.65           N  
ATOM    470  CA  ALA A  64       7.477  18.433  26.331  1.00 47.56           C  
ATOM    471  C   ALA A  64       8.405  19.543  25.862  1.00 47.16           C  
ATOM    472  O   ALA A  64       8.310  20.690  26.314  1.00 47.35           O  
ATOM    473  CB  ALA A  64       6.474  18.103  25.238  1.00 47.33           C  
ATOM    474  N   GLN A  65       9.293  19.166  24.943  1.00 46.81           N  
ATOM    475  CA  GLN A  65      10.265  20.064  24.330  1.00 46.09           C  
ATOM    476  C   GLN A  65      10.098  20.022  22.812  1.00 46.08           C  
ATOM    477  O   GLN A  65       9.849  18.954  22.248  1.00 46.26           O  
ATOM    478  CB  GLN A  65      11.688  19.637  24.694  1.00 45.59           C  
ATOM    479  CG  GLN A  65      12.785  20.598  24.217  1.00 44.61           C  
ATOM    480  CD  GLN A  65      14.190  20.136  24.558  1.00 45.67           C  
ATOM    481  OE1 GLN A  65      14.404  19.028  25.054  1.00 47.58           O  
ATOM    482  NE2 GLN A  65      15.163  20.992  24.284  1.00 43.22           N  
ATOM    483  N   PHE A  66      10.234  21.184  22.174  1.00 46.03           N  
ATOM    484  CA  PHE A  66      10.194  21.303  20.716  1.00 46.11           C  
ATOM    485  C   PHE A  66      11.300  22.261  20.283  1.00 46.09           C  
ATOM    486  O   PHE A  66      11.254  23.446  20.613  1.00 45.63           O  
ATOM    487  CB  PHE A  66       8.825  21.768  20.226  1.00 46.50           C  
ATOM    488  CG  PHE A  66       8.701  21.806  18.725  1.00 46.50           C  
ATOM    489  CD1 PHE A  66       8.838  20.630  17.976  1.00 46.94           C  
ATOM    490  CD2 PHE A  66       8.424  23.005  18.055  1.00 46.97           C  
ATOM    491  CE1 PHE A  66       8.727  20.650  16.576  1.00 46.73           C  
ATOM    492  CE2 PHE A  66       8.299  23.037  16.656  1.00 46.46           C  
ATOM    493  CZ  PHE A  66       8.446  21.857  15.918  1.00 46.10           C  
ATOM    494  N   VAL A  67      12.287  21.728  19.561  1.00 46.95           N  
ATOM    495  CA  VAL A  67      13.447  22.485  19.101  1.00 46.83           C  
ATOM    496  C   VAL A  67      13.315  22.749  17.600  1.00 47.59           C  
ATOM    497  O   VAL A  67      12.991  21.831  16.839  1.00 48.86           O  
ATOM    498  CB  VAL A  67      14.755  21.726  19.411  1.00 46.76           C  
ATOM    499  CG1 VAL A  67      15.971  22.497  18.921  1.00 47.12           C  
ATOM    500  CG2 VAL A  67      14.872  21.468  20.907  1.00 46.81           C  
ATOM    501  N   VAL A  68      13.559  23.999  17.198  1.00 47.76           N  
ATOM    502  CA  VAL A  68      13.512  24.438  15.797  1.00 47.65           C  
ATOM    503  C   VAL A  68      14.865  25.056  15.418  1.00 48.17           C  
ATOM    504  O   VAL A  68      15.489  25.742  16.234  1.00 48.15           O  
ATOM    505  CB  VAL A  68      12.378  25.482  15.568  1.00 48.14           C  
ATOM    506  CG1 VAL A  68      12.351  25.973  14.112  1.00 46.17           C  
ATOM    507  CG2 VAL A  68      11.031  24.895  15.940  1.00 46.31           C  
ATOM    508  N   SER A  69      15.314  24.777  14.193  1.00 48.44           N  
ATOM    509  CA  SER A  69      16.551  25.336  13.629  1.00 48.96           C  
ATOM    510  C   SER A  69      16.388  25.337  12.108  1.00 49.25           C  
ATOM    511  O   SER A  69      16.534  24.293  11.477  1.00 50.41           O  
ATOM    512  CB  SER A  69      17.771  24.520  14.065  1.00 49.45           C  
ATOM    513  OG  SER A  69      18.975  25.056  13.531  1.00 49.09           O  
ATOM    514  N   ASP A  70      16.047  26.497  11.547  1.00 49.60           N  
ATOM    515  CA  ASP A  70      15.759  26.648  10.112  1.00 49.96           C  
ATOM    516  C   ASP A  70      16.513  27.859   9.539  1.00 50.31           C  
ATOM    517  O   ASP A  70      16.204  29.004   9.882  1.00 50.28           O  
ATOM    518  CB  ASP A  70      14.237  26.791   9.941  1.00 50.03           C  
ATOM    519  CG  ASP A  70      13.768  26.597   8.502  1.00 50.35           C  
ATOM    520  OD1 ASP A  70      14.210  27.339   7.599  1.00 52.10           O  
ATOM    521  OD2 ASP A  70      12.903  25.721   8.284  1.00 49.16           O  
ATOM    522  N   ASP A  71      17.495  27.590   8.671  1.00 50.77           N  
ATOM    523  CA  ASP A  71      18.306  28.636   8.019  1.00 51.03           C  
ATOM    524  C   ASP A  71      17.530  29.430   6.964  1.00 51.52           C  
ATOM    525  O   ASP A  71      17.737  30.641   6.838  1.00 52.87           O  
ATOM    526  CB  ASP A  71      19.578  28.043   7.376  1.00 50.95           C  
ATOM    527  CG  ASP A  71      20.532  27.416   8.394  1.00 50.04           C  
ATOM    528  OD1 ASP A  71      20.587  27.856   9.559  1.00 48.02           O  
ATOM    529  OD2 ASP A  71      21.261  26.482   8.009  1.00 54.42           O  
ATOM    530  N   GLY A  72      16.665  28.749   6.204  1.00 51.41           N  
ATOM    531  CA  GLY A  72      15.832  29.381   5.166  1.00 51.56           C  
ATOM    532  C   GLY A  72      14.939  30.490   5.699  1.00 51.76           C  
ATOM    533  O   GLY A  72      14.805  31.540   5.063  1.00 52.45           O  
ATOM    534  N   GLU A  73      14.346  30.246   6.869  1.00 51.33           N  
ATOM    535  CA  GLU A  73      13.500  31.220   7.576  1.00 51.19           C  
ATOM    536  C   GLU A  73      14.251  32.035   8.632  1.00 50.43           C  
ATOM    537  O   GLU A  73      13.792  33.115   8.998  1.00 50.57           O  
ATOM    538  CB  GLU A  73      12.298  30.510   8.223  1.00 51.56           C  
ATOM    539  CG  GLU A  73      11.326  29.901   7.210  1.00 53.41           C  
ATOM    540  CD  GLU A  73      10.674  30.953   6.317  1.00 55.49           C  
ATOM    541  OE1 GLU A  73      10.096  31.924   6.860  1.00 56.77           O  
ATOM    542  OE2 GLU A  73      10.724  30.799   5.078  1.00 56.64           O  
ATOM    543  N   GLY A  74      15.394  31.536   9.105  1.00 49.95           N  
ATOM    544  CA  GLY A  74      16.169  32.212  10.147  1.00 49.65           C  
ATOM    545  C   GLY A  74      15.456  32.205  11.491  1.00 49.27           C  
ATOM    546  O   GLY A  74      15.495  33.202  12.213  1.00 49.13           O  
ATOM    547  N   LEU A  75      14.790  31.086  11.799  1.00 48.68           N  
ATOM    548  CA  LEU A  75      14.058  30.887  13.048  1.00 48.23           C  
ATOM    549  C   LEU A  75      14.738  29.755  13.800  1.00 47.96           C  
ATOM    550  O   LEU A  75      14.826  28.635  13.289  1.00 47.67           O  
ATOM    551  CB  LEU A  75      12.594  30.526  12.775  1.00 48.03           C  
ATOM    552  CG  LEU A  75      11.676  30.299  13.985  1.00 47.99           C  
ATOM    553  CD1 LEU A  75      11.622  31.527  14.890  1.00 44.34           C  
ATOM    554  CD2 LEU A  75      10.284  29.920  13.520  1.00 48.28           C  
ATOM    555  N   TYR A  76      15.234  30.066  14.997  1.00 47.88           N  
ATOM    556  CA  TYR A  76      15.903  29.105  15.877  1.00 47.58           C  
ATOM    557  C   TYR A  76      15.215  29.242  17.229  1.00 47.96           C  
ATOM    558  O   TYR A  76      15.033  30.367  17.706  1.00 48.32           O  
ATOM    559  CB  TYR A  76      17.401  29.411  15.973  1.00 47.14           C  
ATOM    560  CG  TYR A  76      18.062  29.594  14.623  1.00 46.32           C  
ATOM    561  CD1 TYR A  76      18.601  28.506  13.929  1.00 45.11           C  
ATOM    562  CD2 TYR A  76      18.121  30.860  14.017  1.00 47.01           C  
ATOM    563  CE1 TYR A  76      19.201  28.674  12.664  1.00 45.89           C  
ATOM    564  CE2 TYR A  76      18.714  31.039  12.756  1.00 46.08           C  
ATOM    565  CZ  TYR A  76      19.251  29.943  12.086  1.00 46.64           C  
ATOM    566  OH  TYR A  76      19.835  30.118  10.853  1.00 45.75           O  
ATOM    567  N   ALA A  77      14.811  28.122  17.829  1.00 47.76           N  
ATOM    568  CA  ALA A  77      14.077  28.158  19.097  1.00 47.45           C  
ATOM    569  C   ALA A  77      14.100  26.844  19.864  1.00 47.21           C  
ATOM    570  O   ALA A  77      13.894  25.793  19.271  1.00 48.20           O  
ATOM    571  CB  ALA A  77      12.628  28.558  18.835  1.00 47.34           C  
ATOM    572  N   ASP A  78      14.377  26.923  21.167  1.00 46.45           N  
ATOM    573  CA  ASP A  78      14.306  25.788  22.084  1.00 45.94           C  
ATOM    574  C   ASP A  78      13.101  26.137  22.959  1.00 45.94           C  
ATOM    575  O   ASP A  78      13.178  27.069  23.759  1.00 45.44           O  
ATOM    576  CB  ASP A  78      15.595  25.651  22.909  1.00 45.81           C  
ATOM    577  CG  ASP A  78      15.580  24.452  23.864  1.00 44.51           C  
ATOM    578  OD1 ASP A  78      14.640  23.626  23.831  1.00 45.69           O  
ATOM    579  OD2 ASP A  78      16.532  24.325  24.661  1.00 44.83           O  
ATOM    580  N   LEU A  79      12.005  25.390  22.793  1.00 46.27           N  
ATOM    581  CA  LEU A  79      10.734  25.661  23.473  1.00 46.80           C  
ATOM    582  C   LEU A  79      10.336  24.605  24.500  1.00 47.56           C  
ATOM    583  O   LEU A  79      10.414  23.419  24.206  1.00 47.58           O  
ATOM    584  CB  LEU A  79       9.611  25.710  22.436  1.00 46.96           C  
ATOM    585  CG  LEU A  79       9.770  26.629  21.224  1.00 46.92           C  
ATOM    586  CD1 LEU A  79       8.639  26.353  20.259  1.00 45.68           C  
ATOM    587  CD2 LEU A  79       9.806  28.085  21.636  1.00 44.69           C  
ATOM    588  N   ASP A  80       9.912  25.053  25.685  1.00 48.28           N  
ATOM    589  CA  ASP A  80       9.324  24.190  26.719  1.00 49.06           C  
ATOM    590  C   ASP A  80       7.816  24.365  26.578  1.00 48.66           C  
ATOM    591  O   ASP A  80       7.338  25.474  26.307  1.00 48.41           O  
ATOM    592  CB  ASP A  80       9.760  24.589  28.139  1.00 49.57           C  
ATOM    593  CG  ASP A  80      11.210  24.238  28.441  1.00 53.43           C  
ATOM    594  OD1 ASP A  80      11.716  23.202  27.953  1.00 59.61           O  
ATOM    595  OD2 ASP A  80      11.848  24.994  29.200  1.00 60.01           O  
ATOM    596  N   GLY A  81       7.070  23.280  26.774  1.00 48.60           N  
ATOM    597  CA  GLY A  81       5.615  23.312  26.644  1.00 48.12           C  
ATOM    598  C   GLY A  81       4.908  22.073  27.152  1.00 47.82           C  
ATOM    599  O   GLY A  81       5.425  21.378  28.025  1.00 48.28           O  
ATOM    600  N   THR A  82       3.720  21.817  26.598  1.00 47.69           N  
ATOM    601  CA  THR A  82       2.878  20.676  26.962  1.00 47.89           C  
ATOM    602  C   THR A  82       2.387  19.979  25.690  1.00 48.21           C  
ATOM    603  O   THR A  82       1.794  20.633  24.831  1.00 49.02           O  
ATOM    604  CB  THR A  82       1.650  21.142  27.774  1.00 47.84           C  
ATOM    605  OG1 THR A  82       2.083  21.911  28.905  1.00 49.80           O  
ATOM    606  CG2 THR A  82       0.818  19.951  28.258  1.00 47.91           C  
ATOM    607  N   LEU A  83       2.644  18.671  25.581  1.00 47.89           N  
ATOM    608  CA  LEU A  83       2.189  17.845  24.451  1.00 47.73           C  
ATOM    609  C   LEU A  83       0.983  17.024  24.922  1.00 48.07           C  
ATOM    610  O   LEU A  83       0.974  16.526  26.051  1.00 47.66           O  
ATOM    611  CB  LEU A  83       3.305  16.914  23.963  1.00 47.34           C  
ATOM    612  CG  LEU A  83       3.069  16.126  22.669  1.00 47.51           C  
ATOM    613  CD1 LEU A  83       2.933  17.060  21.473  1.00 44.45           C  
ATOM    614  CD2 LEU A  83       4.204  15.139  22.434  1.00 46.96           C  
ATOM    615  N   GLU A  84      -0.018  16.883  24.051  1.00 48.54           N  
ATOM    616  CA  GLU A  84      -1.242  16.135  24.367  1.00 48.83           C  
ATOM    617  C   GLU A  84      -2.000  15.657  23.131  1.00 49.08           C  
ATOM    618  O   GLU A  84      -1.765  16.152  22.025  1.00 48.62           O  
ATOM    619  CB  GLU A  84      -2.188  17.012  25.205  1.00 48.56           C  
ATOM    620  CG  GLU A  84      -2.622  18.322  24.528  1.00 49.61           C  
ATOM    621  CD  GLU A  84      -3.512  19.184  25.408  1.00 49.44           C  
ATOM    622  OE1 GLU A  84      -4.515  18.666  25.945  1.00 50.88           O  
ATOM    623  OE2 GLU A  84      -3.225  20.393  25.532  1.00 50.95           O  
ATOM    624  N   ARG A  85      -2.908  14.700  23.354  1.00 49.61           N  
ATOM    625  CA  ARG A  85      -3.807  14.156  22.332  0.50 49.76           C  
ATOM    627  C   ARG A  85      -4.857  15.237  22.033  1.00 49.70           C  
ATOM    628  O   ARG A  85      -5.252  15.963  22.950  1.00 49.77           O  
ATOM    629  CB  ARG A  85      -4.543  12.919  22.891  0.50 50.21           C  
ATOM    631  CG  ARG A  85      -4.983  11.858  21.884  0.50 51.06           C  
ATOM    633  CD  ARG A  85      -3.863  10.855  21.610  0.50 52.10           C  
ATOM    635  NE  ARG A  85      -4.362   9.589  21.066  0.50 52.47           N  
ATOM    637  CZ  ARG A  85      -3.637   8.476  20.891  0.50 51.07           C  
ATOM    639  NH1 ARG A  85      -2.334   8.433  21.192  0.50 50.58           N  
ATOM    641  NH2 ARG A  85      -4.222   7.384  20.403  0.50 50.93           N  
ATOM    643  N   SER A  86      -5.330  15.306  20.791  1.00 49.88           N  
ATOM    644  CA  SER A  86      -6.396  16.232  20.410  1.00 49.56           C  
ATOM    645  C   SER A  86      -7.423  15.480  19.568  1.00 50.17           C  
ATOM    646  O   SER A  86      -7.048  14.784  18.621  1.00 50.57           O  
ATOM    647  CB  SER A  86      -5.851  17.423  19.631  1.00 49.23           C  
ATOM    648  OG  SER A  86      -6.889  18.355  19.378  1.00 47.38           O  
ATOM    649  N   THR A  87      -8.699  15.615  19.939  1.00 50.73           N  
ATOM    650  CA  THR A  87      -9.832  15.037  19.202  1.00 50.90           C  
ATOM    651  C   THR A  87     -10.595  16.165  18.468  1.00 51.28           C  
ATOM    652  O   THR A  87     -11.805  16.064  18.251  1.00 51.42           O  
ATOM    653  CB  THR A  87     -10.771  14.262  20.162  1.00 50.96           C  
ATOM    654  OG1 THR A  87     -11.326  15.164  21.128  1.00 50.71           O  
ATOM    655  CG2 THR A  87     -10.012  13.150  20.882  1.00 49.69           C  
ATOM    656  N   ASP A  88      -9.868  17.214  18.067  1.00 51.73           N  
ATOM    657  CA  ASP A  88     -10.426  18.387  17.399  1.00 51.93           C  
ATOM    658  C   ASP A  88     -10.448  18.087  15.898  1.00 51.93           C  
ATOM    659  O   ASP A  88      -9.405  18.132  15.235  1.00 52.19           O  
ATOM    660  CB  ASP A  88      -9.569  19.631  17.734  1.00 52.14           C  
ATOM    661  CG  ASP A  88     -10.145  20.947  17.190  1.00 53.35           C  
ATOM    662  OD1 ASP A  88     -11.287  20.986  16.678  1.00 56.95           O  
ATOM    663  OD2 ASP A  88      -9.433  21.969  17.294  1.00 52.93           O  
ATOM    664  N   ARG A  89     -11.635  17.757  15.382  1.00 52.00           N  
ATOM    665  CA  ARG A  89     -11.836  17.466  13.949  1.00 51.74           C  
ATOM    666  C   ARG A  89     -11.593  18.681  13.035  1.00 51.89           C  
ATOM    667  O   ARG A  89     -11.231  18.502  11.869  1.00 51.52           O  
ATOM    668  CB  ARG A  89     -13.241  16.903  13.698  1.00 51.50           C  
ATOM    669  N   GLU A  90     -11.788  19.895  13.567  1.00 52.46           N  
ATOM    670  CA  GLU A  90     -11.555  21.152  12.829  1.00 52.95           C  
ATOM    671  C   GLU A  90     -10.062  21.331  12.546  1.00 52.34           C  
ATOM    672  O   GLU A  90      -9.678  21.653  11.420  1.00 52.74           O  
ATOM    673  CB  GLU A  90     -12.065  22.380  13.608  1.00 53.65           C  
ATOM    674  CG  GLU A  90     -13.570  22.388  13.963  1.00 55.77           C  
ATOM    675  CD  GLU A  90     -14.504  22.416  12.755  1.00 59.58           C  
ATOM    676  OE1 GLU A  90     -14.079  22.823  11.649  1.00 63.75           O  
ATOM    677  OE2 GLU A  90     -15.687  22.043  12.921  1.00 59.76           O  
ATOM    678  N   ALA A  91      -9.238  21.125  13.575  1.00 51.85           N  
ATOM    679  CA  ALA A  91      -7.772  21.209  13.461  1.00 51.48           C  
ATOM    680  C   ALA A  91      -7.198  20.090  12.583  1.00 50.79           C  
ATOM    681  O   ALA A  91      -6.296  20.342  11.783  1.00 50.31           O  
ATOM    682  CB  ALA A  91      -7.116  21.184  14.846  1.00 51.74           C  
ATOM    683  N   LEU A  92      -7.728  18.871  12.741  1.00 50.45           N  
ATOM    684  CA  LEU A  92      -7.316  17.696  11.943  1.00 50.20           C  
ATOM    685  C   LEU A  92      -7.492  17.933  10.440  1.00 50.07           C  
ATOM    686  O   LEU A  92      -6.566  17.697   9.673  1.00 49.59           O  
ATOM    687  CB  LEU A  92      -8.105  16.444  12.369  1.00 50.18           C  
ATOM    688  CG  LEU A  92      -7.831  15.093  11.688  1.00 50.26           C  
ATOM    689  CD1 LEU A  92      -6.362  14.698  11.777  1.00 48.85           C  
ATOM    690  CD2 LEU A  92      -8.710  14.012  12.302  1.00 49.97           C  
ATOM    691  N   ASP A  93      -8.666  18.432  10.050  1.00 50.80           N  
ATOM    692  CA  ASP A  93      -8.993  18.714   8.639  1.00 51.47           C  
ATOM    693  C   ASP A  93      -8.212  19.910   8.052  1.00 51.67           C  
ATOM    694  O   ASP A  93      -7.872  19.896   6.864  1.00 51.63           O  
ATOM    695  CB  ASP A  93     -10.514  18.932   8.480  1.00 51.59           C  
ATOM    696  CG  ASP A  93     -10.973  19.001   7.017  1.00 53.23           C  
ATOM    697  OD1 ASP A  93     -10.344  18.381   6.130  1.00 56.08           O  
ATOM    698  OD2 ASP A  93     -11.998  19.667   6.760  1.00 55.43           O  
ATOM    699  N   GLU A  94      -7.946  20.930   8.873  1.00 51.89           N  
ATOM    700  CA  GLU A  94      -7.200  22.129   8.440  1.00 52.31           C  
ATOM    701  C   GLU A  94      -5.736  21.820   8.099  1.00 51.90           C  
ATOM    702  O   GLU A  94      -5.227  22.297   7.080  1.00 51.73           O  
ATOM    703  CB  GLU A  94      -7.244  23.224   9.522  1.00 52.65           C  
ATOM    704  CG  GLU A  94      -6.637  24.594   9.116  1.00 52.81           C  
ATOM    705  CD  GLU A  94      -6.473  25.555  10.291  1.00 53.71           C  
ATOM    706  OE1 GLU A  94      -7.214  25.438  11.290  1.00 57.06           O  
ATOM    707  OE2 GLU A  94      -5.592  26.437  10.205  1.00 56.47           O  
ATOM    708  N   PHE A  95      -5.077  21.037   8.958  1.00 51.74           N  
ATOM    709  CA  PHE A  95      -3.653  20.680   8.796  1.00 51.55           C  
ATOM    710  C   PHE A  95      -3.357  19.364   8.049  1.00 51.41           C  
ATOM    711  O   PHE A  95      -2.191  18.957   7.967  1.00 51.47           O  
ATOM    712  CB  PHE A  95      -2.968  20.707  10.171  1.00 51.37           C  
ATOM    713  CG  PHE A  95      -3.083  22.040  10.866  1.00 51.32           C  
ATOM    714  CD1 PHE A  95      -2.559  23.196  10.270  1.00 51.12           C  
ATOM    715  CD2 PHE A  95      -3.716  22.155  12.108  1.00 52.24           C  
ATOM    716  CE1 PHE A  95      -2.670  24.447  10.893  1.00 52.17           C  
ATOM    717  CE2 PHE A  95      -3.835  23.403  12.747  1.00 52.85           C  
ATOM    718  CZ  PHE A  95      -3.306  24.552  12.141  1.00 53.19           C  
ATOM    719  N   TRP A  96      -4.387  18.727   7.481  1.00 50.91           N  
ATOM    720  CA  TRP A  96      -4.221  17.489   6.711  1.00 50.62           C  
ATOM    721  C   TRP A  96      -3.681  17.844   5.318  1.00 51.05           C  
ATOM    722  O   TRP A  96      -4.113  18.839   4.723  1.00 51.62           O  
ATOM    723  CB  TRP A  96      -5.549  16.735   6.596  1.00 49.95           C  
ATOM    724  CG  TRP A  96      -5.407  15.353   6.080  1.00 49.77           C  
ATOM    725  CD1 TRP A  96      -5.626  14.932   4.806  1.00 48.77           C  
ATOM    726  CD2 TRP A  96      -4.994  14.199   6.823  1.00 50.00           C  
ATOM    727  NE1 TRP A  96      -5.391  13.586   4.706  1.00 49.11           N  
ATOM    728  CE2 TRP A  96      -5.000  13.105   5.927  1.00 49.26           C  
ATOM    729  CE3 TRP A  96      -4.630  13.978   8.164  1.00 49.55           C  
ATOM    730  CZ2 TRP A  96      -4.643  11.800   6.322  1.00 49.00           C  
ATOM    731  CZ3 TRP A  96      -4.276  12.673   8.564  1.00 49.08           C  
ATOM    732  CH2 TRP A  96      -4.283  11.604   7.637  1.00 48.59           C  
ATOM    733  N   SER A  97      -2.758  17.022   4.810  1.00 51.01           N  
ATOM    734  CA  SER A  97      -2.102  17.242   3.508  1.00 50.45           C  
ATOM    735  C   SER A  97      -1.966  15.965   2.671  1.00 50.21           C  
ATOM    736  O   SER A  97      -2.307  14.869   3.129  1.00 50.18           O  
ATOM    737  CB  SER A  97      -0.712  17.851   3.744  1.00 50.52           C  
ATOM    738  OG  SER A  97       0.120  16.970   4.481  1.00 50.24           O  
ATOM    739  N   PHE A  98      -1.490  16.140   1.432  1.00 49.73           N  
ATOM    740  CA  PHE A  98      -1.205  15.033   0.493  1.00 49.33           C  
ATOM    741  C   PHE A  98      -0.143  14.052   1.040  1.00 48.86           C  
ATOM    742  O   PHE A  98      -0.165  12.869   0.696  1.00 48.92           O  
ATOM    743  CB  PHE A  98      -0.789  15.564  -0.905  1.00 49.57           C  
ATOM    744  CG  PHE A  98       0.602  16.174  -0.956  1.00 50.17           C  
ATOM    745  CD1 PHE A  98       1.697  15.415  -1.397  1.00 50.07           C  
ATOM    746  CD2 PHE A  98       0.823  17.499  -0.562  1.00 51.35           C  
ATOM    747  CE1 PHE A  98       2.994  15.968  -1.440  1.00 51.01           C  
ATOM    748  CE2 PHE A  98       2.115  18.061  -0.598  1.00 52.35           C  
ATOM    749  CZ  PHE A  98       3.203  17.294  -1.041  1.00 51.28           C  
ATOM    750  N   VAL A  99       0.786  14.565   1.857  1.00 48.51           N  
ATOM    751  CA  VAL A  99       1.815  13.748   2.523  1.00 48.22           C  
ATOM    752  C   VAL A  99       1.147  12.815   3.545  1.00 48.32           C  
ATOM    753  O   VAL A  99       1.472  11.627   3.587  1.00 48.91           O  
ATOM    754  CB  VAL A  99       2.917  14.622   3.210  1.00 47.69           C  
ATOM    755  CG1 VAL A  99       3.925  13.757   3.963  1.00 45.86           C  
ATOM    756  CG2 VAL A  99       3.642  15.477   2.179  1.00 47.73           C  
ATOM    757  N   ALA A 100       0.218  13.357   4.343  1.00 48.06           N  
ATOM    758  CA  ALA A 100      -0.554  12.571   5.332  1.00 47.84           C  
ATOM    759  C   ALA A 100      -1.362  11.419   4.701  1.00 47.53           C  
ATOM    760  O   ALA A 100      -1.539  10.382   5.337  1.00 47.62           O  
ATOM    761  CB  ALA A 100      -1.474  13.479   6.156  1.00 47.69           C  
ATOM    762  N   ASP A 101      -1.853  11.615   3.471  1.00 47.69           N  
ATOM    763  CA  ASP A 101      -2.551  10.554   2.706  1.00 48.22           C  
ATOM    764  C   ASP A 101      -1.639   9.369   2.357  1.00 48.50           C  
ATOM    765  O   ASP A 101      -2.114   8.235   2.276  1.00 49.06           O  
ATOM    766  CB  ASP A 101      -3.177  11.104   1.409  1.00 48.37           C  
ATOM    767  CG  ASP A 101      -4.445  11.894   1.656  1.00 49.05           C  
ATOM    768  OD1 ASP A 101      -5.415  11.307   2.179  1.00 49.52           O  
ATOM    769  OD2 ASP A 101      -4.493  13.087   1.293  1.00 52.76           O  
ATOM    770  N   ALA A 102      -0.351   9.643   2.130  1.00 48.97           N  
ATOM    771  CA  ALA A 102       0.646   8.608   1.822  1.00 49.60           C  
ATOM    772  C   ALA A 102       0.918   7.703   3.031  1.00 50.36           C  
ATOM    773  O   ALA A 102       0.923   6.475   2.896  1.00 50.47           O  
ATOM    774  CB  ALA A 102       1.949   9.244   1.329  1.00 49.36           C  
ATOM    775  N   TRP A 103       1.138   8.317   4.197  1.00 51.15           N  
ATOM    776  CA  TRP A 103       1.388   7.581   5.452  1.00 52.09           C  
ATOM    777  C   TRP A 103       0.167   6.816   5.987  1.00 52.26           C  
ATOM    778  O   TRP A 103       0.321   5.696   6.484  1.00 52.35           O  
ATOM    779  CB  TRP A 103       1.939   8.514   6.547  1.00 52.71           C  
ATOM    780  CG  TRP A 103       3.372   8.887   6.341  1.00 53.50           C  
ATOM    781  CD1 TRP A 103       3.859   9.921   5.593  1.00 54.46           C  
ATOM    782  CD2 TRP A 103       4.510   8.219   6.893  1.00 54.72           C  
ATOM    783  NE1 TRP A 103       5.236   9.940   5.644  1.00 55.01           N  
ATOM    784  CE2 TRP A 103       5.663   8.906   6.437  1.00 55.66           C  
ATOM    785  CE3 TRP A 103       4.671   7.101   7.734  1.00 55.29           C  
ATOM    786  CZ2 TRP A 103       6.970   8.512   6.794  1.00 55.47           C  
ATOM    787  CZ3 TRP A 103       5.973   6.704   8.093  1.00 54.88           C  
ATOM    788  CH2 TRP A 103       7.104   7.412   7.619  1.00 55.08           C  
ATOM    789  N   PHE A 104      -1.019   7.424   5.884  1.00 52.54           N  
ATOM    790  CA  PHE A 104      -2.282   6.839   6.366  1.00 52.73           C  
ATOM    791  C   PHE A 104      -3.234   6.600   5.185  1.00 53.45           C  
ATOM    792  O   PHE A 104      -3.922   7.522   4.733  1.00 54.10           O  
ATOM    793  CB  PHE A 104      -2.903   7.755   7.428  1.00 52.24           C  
ATOM    794  CG  PHE A 104      -1.978   8.037   8.577  1.00 51.51           C  
ATOM    795  CD1 PHE A 104      -1.850   7.122   9.624  1.00 51.39           C  
ATOM    796  CD2 PHE A 104      -1.206   9.204   8.601  1.00 50.89           C  
ATOM    797  CE1 PHE A 104      -0.974   7.370  10.692  1.00 51.00           C  
ATOM    798  CE2 PHE A 104      -0.327   9.465   9.660  1.00 50.20           C  
ATOM    799  CZ  PHE A 104      -0.212   8.545  10.707  1.00 51.29           C  
ATOM    800  N   ASP A 105      -3.251   5.357   4.694  1.00 53.79           N  
ATOM    801  CA  ASP A 105      -4.085   4.948   3.535  1.00 54.39           C  
ATOM    802  C   ASP A 105      -5.608   5.166   3.659  1.00 54.59           C  
ATOM    803  O   ASP A 105      -6.289   5.287   2.634  1.00 54.77           O  
ATOM    804  CB  ASP A 105      -3.792   3.486   3.107  1.00 54.54           C  
ATOM    805  CG  ASP A 105      -4.080   2.457   4.207  1.00 55.16           C  
ATOM    806  OD1 ASP A 105      -4.069   2.814   5.407  1.00 55.39           O  
ATOM    807  OD2 ASP A 105      -4.290   1.275   3.864  1.00 55.94           O  
ATOM    808  N   GLY A 106      -6.124   5.225   4.892  1.00 54.69           N  
ATOM    809  CA  GLY A 106      -7.552   5.453   5.167  1.00 54.79           C  
ATOM    810  C   GLY A 106      -7.994   6.896   5.390  1.00 54.89           C  
ATOM    811  O   GLY A 106      -9.000   7.122   6.069  1.00 54.46           O  
ATOM    812  N   GLY A 107      -7.264   7.866   4.827  1.00 55.29           N  
ATOM    813  CA  GLY A 107      -7.586   9.293   4.978  1.00 55.65           C  
ATOM    814  C   GLY A 107      -7.359   9.811   6.389  1.00 56.27           C  
ATOM    815  O   GLY A 107      -6.605   9.207   7.161  1.00 56.35           O  
ATOM    816  N   GLN A 108      -7.994  10.939   6.719  1.00 56.77           N  
ATOM    817  CA  GLN A 108      -7.897  11.525   8.072  1.00 57.34           C  
ATOM    818  C   GLN A 108      -8.692  10.732   9.124  1.00 57.96           C  
ATOM    819  O   GLN A 108      -8.378  10.819  10.315  1.00 58.18           O  
ATOM    820  CB  GLN A 108      -8.249  13.022   8.082  1.00 57.24           C  
ATOM    821  CG  GLN A 108      -9.698  13.404   7.808  1.00 57.66           C  
ATOM    822  CD  GLN A 108      -9.890  14.914   7.722  1.00 57.80           C  
ATOM    823  OE1 GLN A 108     -10.697  15.489   8.453  1.00 61.06           O  
ATOM    824  NE2 GLN A 108      -9.128  15.563   6.846  1.00 55.46           N  
ATOM    825  N   HIS A 109      -9.702   9.974   8.681  1.00 58.70           N  
ATOM    826  CA  HIS A 109     -10.490   9.082   9.539  1.00 59.25           C  
ATOM    827  C   HIS A 109      -9.944   7.658   9.329  1.00 59.06           C  
ATOM    828  O   HIS A 109     -10.608   6.790   8.749  1.00 59.68           O  
ATOM    829  CB  HIS A 109     -11.990   9.189   9.224  1.00 59.75           C  
ATOM    830  CG  HIS A 109     -12.559  10.556   9.461  1.00 61.81           C  
ATOM    831  ND1 HIS A 109     -12.820  11.045  10.723  1.00 62.78           N  
ATOM    832  CD2 HIS A 109     -12.924  11.533   8.597  1.00 63.01           C  
ATOM    833  CE1 HIS A 109     -13.314  12.267  10.626  1.00 62.78           C  
ATOM    834  NE2 HIS A 109     -13.388  12.586   9.347  1.00 63.32           N  
ATOM    835  N   ASP A 110      -8.703   7.470   9.784  1.00 58.33           N  
ATOM    836  CA  ASP A 110      -7.952   6.205   9.733  1.00 57.55           C  
ATOM    837  C   ASP A 110      -7.715   5.811  11.207  1.00 56.88           C  
ATOM    838  O   ASP A 110      -7.460   6.701  12.027  1.00 56.94           O  
ATOM    839  CB  ASP A 110      -6.637   6.448   8.965  1.00 57.42           C  
ATOM    840  CG  ASP A 110      -5.748   5.205   8.832  1.00 57.32           C  
ATOM    841  OD1 ASP A 110      -5.246   4.681   9.848  1.00 57.34           O  
ATOM    842  OD2 ASP A 110      -5.487   4.792   7.682  1.00 58.33           O  
ATOM    843  N   PRO A 111      -7.799   4.499  11.551  1.00 56.22           N  
ATOM    844  CA  PRO A 111      -7.604   4.087  12.960  1.00 55.56           C  
ATOM    845  C   PRO A 111      -6.252   4.446  13.583  1.00 54.72           C  
ATOM    846  O   PRO A 111      -6.206   4.739  14.773  1.00 54.51           O  
ATOM    847  CB  PRO A 111      -7.775   2.561  12.914  1.00 55.53           C  
ATOM    848  CG  PRO A 111      -7.527   2.191  11.502  1.00 56.16           C  
ATOM    849  CD  PRO A 111      -8.074   3.324  10.702  1.00 56.16           C  
ATOM    850  N   ASP A 112      -5.185   4.431  12.781  1.00 53.92           N  
ATOM    851  CA  ASP A 112      -3.829   4.753  13.256  1.00 53.57           C  
ATOM    852  C   ASP A 112      -3.530   6.254  13.399  1.00 52.39           C  
ATOM    853  O   ASP A 112      -2.547   6.596  14.048  1.00 52.21           O  
ATOM    854  CB  ASP A 112      -2.766   4.107  12.347  1.00 54.04           C  
ATOM    855  CG  ASP A 112      -2.884   2.580  12.273  1.00 56.25           C  
ATOM    856  OD1 ASP A 112      -3.695   1.978  13.015  1.00 59.70           O  
ATOM    857  OD2 ASP A 112      -2.154   1.977  11.455  1.00 58.32           O  
ATOM    858  N   VAL A 113      -4.348   7.135  12.805  1.00 51.50           N  
ATOM    859  CA  VAL A 113      -4.118   8.595  12.876  1.00 50.96           C  
ATOM    860  C   VAL A 113      -4.278   9.131  14.306  1.00 50.48           C  
ATOM    861  O   VAL A 113      -5.188   8.721  15.026  1.00 50.42           O  
ATOM    862  CB  VAL A 113      -5.027   9.384  11.880  1.00 50.74           C  
ATOM    863  CG1 VAL A 113      -4.967  10.896  12.117  1.00 50.71           C  
ATOM    864  CG2 VAL A 113      -4.615   9.085  10.464  1.00 50.83           C  
ATOM    865  N   CYS A 114      -3.370  10.036  14.685  1.00 50.59           N  
ATOM    866  CA  CYS A 114      -3.324  10.654  16.012  1.00 49.89           C  
ATOM    867  C   CYS A 114      -2.847  12.109  15.909  1.00 49.02           C  
ATOM    868  O   CYS A 114      -1.697  12.352  15.530  1.00 50.09           O  
ATOM    869  CB  CYS A 114      -2.372   9.849  16.902  1.00 49.63           C  
ATOM    870  SG  CYS A 114      -2.053  10.547  18.521  1.00 52.53           S  
ATOM    871  N   LEU A 115      -3.729  13.058  16.234  1.00 47.60           N  
ATOM    872  CA  LEU A 115      -3.407  14.492  16.209  1.00 46.84           C  
ATOM    873  C   LEU A 115      -2.812  14.886  17.565  1.00 46.41           C  
ATOM    874  O   LEU A 115      -3.452  14.674  18.599  1.00 46.24           O  
ATOM    875  CB  LEU A 115      -4.665  15.327  15.924  1.00 46.56           C  
ATOM    876  CG  LEU A 115      -4.551  16.855  15.807  1.00 47.20           C  
ATOM    877  CD1 LEU A 115      -3.627  17.266  14.667  1.00 46.39           C  
ATOM    878  CD2 LEU A 115      -5.928  17.475  15.613  1.00 46.91           C  
ATOM    879  N   LEU A 116      -1.593  15.436  17.546  1.00 46.09           N  
ATOM    880  CA  LEU A 116      -0.896  15.919  18.746  1.00 45.84           C  
ATOM    881  C   LEU A 116      -0.866  17.453  18.743  1.00 45.68           C  
ATOM    882  O   LEU A 116      -0.671  18.065  17.689  1.00 45.57           O  
ATOM    883  CB  LEU A 116       0.529  15.367  18.821  1.00 45.56           C  
ATOM    884  CG  LEU A 116       0.722  13.852  18.955  1.00 45.77           C  
ATOM    885  CD1 LEU A 116       2.205  13.531  19.006  1.00 42.47           C  
ATOM    886  CD2 LEU A 116       0.017  13.285  20.187  1.00 44.15           C  
ATOM    887  N   LYS A 117      -1.062  18.051  19.924  1.00 45.04           N  
ATOM    888  CA  LYS A 117      -1.087  19.505  20.121  1.00 44.63           C  
ATOM    889  C   LYS A 117       0.004  19.891  21.123  1.00 44.66           C  
ATOM    890  O   LYS A 117      -0.030  19.442  22.274  1.00 44.52           O  
ATOM    891  CB  LYS A 117      -2.463  19.928  20.656  1.00 44.54           C  
ATOM    892  CG  LYS A 117      -2.670  21.439  20.857  1.00 44.53           C  
ATOM    893  CD  LYS A 117      -4.035  21.739  21.471  1.00 44.82           C  
ATOM    894  CE  LYS A 117      -4.256  23.238  21.642  1.00 44.44           C  
ATOM    895  NZ  LYS A 117      -5.593  23.562  22.209  1.00 42.71           N  
ATOM    896  N   PHE A 118       0.961  20.708  20.674  1.00 44.62           N  
ATOM    897  CA  PHE A 118       2.049  21.218  21.512  1.00 44.62           C  
ATOM    898  C   PHE A 118       1.776  22.695  21.792  1.00 44.48           C  
ATOM    899  O   PHE A 118       1.766  23.503  20.860  1.00 45.17           O  
ATOM    900  CB  PHE A 118       3.408  21.055  20.823  1.00 44.70           C  
ATOM    901  CG  PHE A 118       4.564  21.571  21.639  1.00 45.58           C  
ATOM    902  CD1 PHE A 118       5.154  20.769  22.617  1.00 45.49           C  
ATOM    903  CD2 PHE A 118       5.053  22.872  21.448  1.00 45.81           C  
ATOM    904  CE1 PHE A 118       6.219  21.251  23.390  1.00 46.33           C  
ATOM    905  CE2 PHE A 118       6.117  23.364  22.215  1.00 43.76           C  
ATOM    906  CZ  PHE A 118       6.705  22.552  23.188  1.00 45.78           C  
ATOM    907  N   THR A 119       1.556  23.033  23.063  1.00 43.91           N  
ATOM    908  CA  THR A 119       1.320  24.413  23.493  1.00 43.47           C  
ATOM    909  C   THR A 119       2.633  24.917  24.101  1.00 44.16           C  
ATOM    910  O   THR A 119       3.045  24.397  25.139  1.00 44.42           O  
ATOM    911  CB  THR A 119       0.189  24.501  24.552  1.00 42.80           C  
ATOM    912  OG1 THR A 119      -1.029  23.980  24.005  1.00 41.15           O  
ATOM    913  CG2 THR A 119      -0.035  25.946  24.989  1.00 39.26           C  
ATOM    914  N   PRO A 120       3.323  25.883  23.442  1.00 45.04           N  
ATOM    915  CA  PRO A 120       4.542  26.420  24.054  1.00 44.85           C  
ATOM    916  C   PRO A 120       4.252  27.262  25.305  1.00 45.32           C  
ATOM    917  O   PRO A 120       3.281  28.029  25.325  1.00 44.50           O  
ATOM    918  CB  PRO A 120       5.143  27.298  22.942  1.00 44.84           C  
ATOM    919  CG  PRO A 120       4.480  26.869  21.699  1.00 45.37           C  
ATOM    920  CD  PRO A 120       3.101  26.503  22.121  1.00 45.65           C  
ATOM    921  N   ALA A 121       5.080  27.075  26.332  1.00 45.72           N  
ATOM    922  CA  ALA A 121       5.009  27.814  27.595  1.00 46.00           C  
ATOM    923  C   ALA A 121       6.041  28.937  27.569  1.00 46.57           C  
ATOM    924  O   ALA A 121       5.725  30.087  27.883  1.00 46.55           O  
ATOM    925  CB  ALA A 121       5.279  26.885  28.760  1.00 45.85           C  
ATOM    926  N   SER A 122       7.277  28.579  27.217  1.00 47.26           N  
ATOM    927  CA  SER A 122       8.391  29.528  27.099  1.00 48.13           C  
ATOM    928  C   SER A 122       9.515  28.970  26.226  1.00 48.02           C  
ATOM    929  O   SER A 122       9.482  27.802  25.835  1.00 47.78           O  
ATOM    930  CB  SER A 122       8.935  29.867  28.485  1.00 48.44           C  
ATOM    931  OG  SER A 122       9.328  28.690  29.170  1.00 50.78           O  
ATOM    932  N   GLY A 123      10.499  29.811  25.923  1.00 48.64           N  
ATOM    933  CA  GLY A 123      11.645  29.383  25.120  1.00 49.48           C  
ATOM    934  C   GLY A 123      12.613  30.484  24.735  1.00 50.07           C  
ATOM    935  O   GLY A 123      12.242  31.660  24.746  1.00 50.86           O  
ATOM    936  N   GLU A 124      13.851  30.093  24.414  1.00 50.31           N  
ATOM    937  CA  GLU A 124      14.881  31.029  23.967  1.00 51.53           C  
ATOM    938  C   GLU A 124      14.828  30.991  22.445  1.00 51.65           C  
ATOM    939  O   GLU A 124      15.139  29.958  21.848  1.00 52.31           O  
ATOM    940  CB  GLU A 124      16.265  30.667  24.508  1.00 51.47           C  
ATOM    941  CG  GLU A 124      17.296  31.785  24.284  1.00 52.44           C  
ATOM    942  CD  GLU A 124      18.614  31.605  25.037  1.00 53.59           C  
ATOM    943  OE1 GLU A 124      18.731  30.709  25.904  1.00 55.64           O  
ATOM    944  OE2 GLU A 124      19.546  32.397  24.765  1.00 58.79           O  
ATOM    945  N   ILE A 125      14.422  32.115  21.844  1.00 51.11           N  
ATOM    946  CA  ILE A 125      14.197  32.253  20.402  1.00 50.90           C  
ATOM    947  C   ILE A 125      15.178  33.235  19.759  1.00 50.49           C  
ATOM    948  O   ILE A 125      15.445  34.290  20.330  1.00 50.53           O  
ATOM    949  CB  ILE A 125      12.751  32.803  20.143  1.00 51.28           C  
ATOM    950  CG1 ILE A 125      11.680  31.866  20.728  1.00 51.56           C  
ATOM    951  CG2 ILE A 125      12.486  33.025  18.645  1.00 49.54           C  
ATOM    952  CD1 ILE A 125      10.273  32.435  20.668  1.00 51.56           C  
ATOM    953  N   SER A 126      15.699  32.876  18.581  1.00 50.47           N  
ATOM    954  CA  SER A 126      16.550  33.751  17.760  1.00 50.76           C  
ATOM    955  C   SER A 126      15.868  33.949  16.400  1.00 50.71           C  
ATOM    956  O   SER A 126      15.401  32.983  15.789  1.00 50.28           O  
ATOM    957  CB  SER A 126      17.949  33.182  17.555  1.00 50.65           C  
ATOM    958  OG  SER A 126      18.658  33.115  18.773  1.00 53.98           O  
ATOM    959  N   ILE A 127      15.800  35.207  15.966  1.00 51.12           N  
ATOM    960  CA  ILE A 127      15.211  35.628  14.696  1.00 51.66           C  
ATOM    961  C   ILE A 127      16.349  36.299  13.924  1.00 51.78           C  
ATOM    962  O   ILE A 127      16.920  37.262  14.434  1.00 51.47           O  
ATOM    963  CB  ILE A 127      14.058  36.641  14.956  1.00 51.97           C  
ATOM    964  CG1 ILE A 127      12.924  36.007  15.779  1.00 54.13           C  
ATOM    965  CG2 ILE A 127      13.484  37.195  13.669  1.00 53.12           C  
ATOM    966  CD1 ILE A 127      12.220  34.845  15.109  1.00 54.28           C  
ATOM    967  N   THR A 128      16.694  35.786  12.737  1.00 52.50           N  
ATOM    968  CA  THR A 128      17.785  36.347  11.902  1.00 53.60           C  
ATOM    969  C   THR A 128      17.363  36.588  10.454  1.00 55.25           C  
ATOM    970  O   THR A 128      16.366  36.045   9.987  1.00 55.00           O  
ATOM    971  CB  THR A 128      19.041  35.432  11.873  1.00 53.41           C  
ATOM    972  OG1 THR A 128      18.776  34.250  11.105  1.00 53.65           O  
ATOM    973  CG2 THR A 128      19.488  35.053  13.284  1.00 52.76           C  
ATOM    974  N   GLU A 129      18.187  37.344   9.730  1.00 57.49           N  
ATOM    975  CA  GLU A 129      17.933  37.682   8.313  1.00 59.57           C  
ATOM    976  C   GLU A 129      18.009  36.504   7.306  1.00 59.91           C  
ATOM    977  O   GLU A 129      17.679  36.692   6.129  1.00 60.19           O  
ATOM    978  CB  GLU A 129      18.836  38.853   7.878  1.00 59.37           C  
ATOM    979  CG  GLU A 129      18.505  40.163   8.631  1.00 61.45           C  
ATOM    980  CD  GLU A 129      19.491  41.313   8.402  1.00 61.61           C  
ATOM    981  OE1 GLU A 129      19.114  42.463   8.713  1.00 64.47           O  
ATOM    982  OE2 GLU A 129      20.630  41.092   7.936  1.00 67.88           O  
ATOM    983  N   GLY A 130      18.440  35.318   7.760  1.00 60.39           N  
ATOM    984  CA  GLY A 130      18.489  34.093   6.949  1.00 60.69           C  
ATOM    985  C   GLY A 130      19.903  33.723   6.543  1.00 61.43           C  
ATOM    986  O   GLY A 130      20.860  34.053   7.251  1.00 62.27           O  
ATOM    987  N   GLY A 131      20.019  33.011   5.418  1.00 61.55           N  
ATOM    988  CA  GLY A 131      21.312  32.599   4.842  1.00 61.56           C  
ATOM    989  C   GLY A 131      21.380  32.758   3.330  1.00 61.61           C  
ATOM    990  O   GLY A 131      22.097  32.002   2.664  1.00 61.76           O  
ATOM    991  N   GLY A 132      20.659  33.755   2.800  1.00 61.33           N  
ATOM    992  CA  GLY A 132      20.579  34.040   1.366  1.00 60.93           C  
ATOM    993  C   GLY A 132      21.290  35.334   1.007  1.00 60.72           C  
ATOM    994  O   GLY A 132      22.374  35.608   1.525  1.00 60.88           O  
ATOM    995  N   ALA A 133      20.665  36.127   0.130  1.00 60.40           N  
ATOM    996  CA  ALA A 133      21.224  37.399  -0.367  1.00 60.00           C  
ATOM    997  C   ALA A 133      21.585  38.418   0.718  1.00 59.50           C  
ATOM    998  O   ALA A 133      22.646  39.046   0.641  1.00 60.02           O  
ATOM    999  CB  ALA A 133      20.268  38.042  -1.381  1.00 59.83           C  
ATOM   1000  N   ARG A 134      20.715  38.570   1.718  1.00 58.67           N  
ATOM   1001  CA  ARG A 134      20.939  39.538   2.806  1.00 57.66           C  
ATOM   1002  C   ARG A 134      22.070  39.126   3.765  1.00 55.84           C  
ATOM   1003  O   ARG A 134      22.792  39.999   4.256  1.00 55.90           O  
ATOM   1004  CB  ARG A 134      19.633  39.844   3.571  1.00 58.40           C  
ATOM   1005  CG  ARG A 134      19.740  40.920   4.682  1.00 59.53           C  
ATOM   1006  CD  ARG A 134      20.237  42.290   4.183  1.00 63.67           C  
ATOM   1007  NE  ARG A 134      20.554  43.199   5.287  1.00 64.90           N  
ATOM   1008  CZ  ARG A 134      19.686  43.967   5.961  1.00 68.00           C  
ATOM   1009  NH1 ARG A 134      18.375  43.978   5.681  1.00 68.76           N  
ATOM   1010  NH2 ARG A 134      20.142  44.747   6.947  1.00 68.00           N  
ATOM   1011  N   PHE A 135      22.209  37.823   4.035  1.00 53.42           N  
ATOM   1012  CA  PHE A 135      23.289  37.304   4.901  1.00 51.53           C  
ATOM   1013  C   PHE A 135      24.675  37.534   4.277  1.00 50.02           C  
ATOM   1014  O   PHE A 135      25.599  37.961   4.974  1.00 49.69           O  
ATOM   1015  CB  PHE A 135      23.080  35.815   5.216  1.00 51.28           C  
ATOM   1016  CG  PHE A 135      24.175  35.206   6.059  1.00 50.80           C  
ATOM   1017  CD1 PHE A 135      24.234  35.450   7.434  1.00 51.80           C  
ATOM   1018  CD2 PHE A 135      25.153  34.385   5.480  1.00 50.05           C  
ATOM   1019  CE1 PHE A 135      25.254  34.884   8.229  1.00 51.23           C  
ATOM   1020  CE2 PHE A 135      26.179  33.815   6.261  1.00 50.00           C  
ATOM   1021  CZ  PHE A 135      26.227  34.065   7.639  1.00 50.35           C  
ATOM   1022  N   LEU A 136      24.807  37.239   2.981  1.00 48.32           N  
ATOM   1023  CA  LEU A 136      26.064  37.460   2.241  1.00 47.27           C  
ATOM   1024  C   LEU A 136      26.435  38.950   2.208  1.00 46.29           C  
ATOM   1025  O   LEU A 136      27.610  39.295   2.361  1.00 46.22           O  
ATOM   1026  CB  LEU A 136      25.983  36.909   0.808  1.00 46.97           C  
ATOM   1027  CG  LEU A 136      25.754  35.404   0.626  1.00 47.06           C  
ATOM   1028  CD1 LEU A 136      25.576  35.085  -0.853  1.00 45.39           C  
ATOM   1029  CD2 LEU A 136      26.882  34.572   1.227  1.00 46.34           C  
ATOM   1030  N   TYR A 137      25.430  39.812   2.015  1.00 45.42           N  
ATOM   1031  CA  TYR A 137      25.619  41.272   2.030  1.00 44.40           C  
ATOM   1032  C   TYR A 137      26.055  41.772   3.416  1.00 43.69           C  
ATOM   1033  O   TYR A 137      26.963  42.600   3.511  1.00 43.33           O  
ATOM   1034  CB  TYR A 137      24.341  42.020   1.577  1.00 44.21           C  
ATOM   1035  CG  TYR A 137      24.425  43.527   1.770  1.00 44.46           C  
ATOM   1036  CD1 TYR A 137      25.058  44.339   0.823  1.00 44.23           C  
ATOM   1037  CD2 TYR A 137      23.908  44.140   2.927  1.00 44.88           C  
ATOM   1038  CE1 TYR A 137      25.162  45.728   1.012  1.00 44.62           C  
ATOM   1039  CE2 TYR A 137      24.011  45.528   3.128  1.00 45.13           C  
ATOM   1040  CZ  TYR A 137      24.637  46.315   2.164  1.00 44.86           C  
ATOM   1041  OH  TYR A 137      24.743  47.675   2.350  1.00 45.68           O  
ATOM   1042  N   GLU A 138      25.397  41.277   4.469  1.00 43.26           N  
ATOM   1043  CA  GLU A 138      25.674  41.715   5.849  1.00 43.13           C  
ATOM   1044  C   GLU A 138      27.091  41.345   6.324  1.00 41.43           C  
ATOM   1045  O   GLU A 138      27.729  42.144   7.016  1.00 41.10           O  
ATOM   1046  CB  GLU A 138      24.601  41.191   6.825  1.00 43.45           C  
ATOM   1047  CG  GLU A 138      24.549  41.914   8.184  1.00 47.56           C  
ATOM   1048  CD  GLU A 138      24.173  43.396   8.097  1.00 51.09           C  
ATOM   1049  OE1 GLU A 138      23.515  43.812   7.116  1.00 53.24           O  
ATOM   1050  OE2 GLU A 138      24.536  44.150   9.026  1.00 55.15           O  
ATOM   1051  N   ILE A 139      27.565  40.152   5.955  1.00 40.12           N  
ATOM   1052  CA  ILE A 139      28.941  39.710   6.270  1.00 39.28           C  
ATOM   1053  C   ILE A 139      29.948  40.556   5.481  1.00 38.47           C  
ATOM   1054  O   ILE A 139      30.927  41.022   6.053  1.00 38.39           O  
ATOM   1055  CB  ILE A 139      29.164  38.176   6.041  1.00 39.27           C  
ATOM   1056  CG1 ILE A 139      28.687  37.363   7.253  1.00 40.36           C  
ATOM   1057  CG2 ILE A 139      30.645  37.833   5.897  1.00 37.84           C  
ATOM   1058  CD1 ILE A 139      27.248  37.554   7.645  1.00 42.47           C  
ATOM   1059  N   ALA A 140      29.692  40.750   4.185  1.00 38.08           N  
ATOM   1060  CA  ALA A 140      30.537  41.598   3.323  1.00 38.01           C  
ATOM   1061  C   ALA A 140      30.569  43.065   3.790  1.00 38.30           C  
ATOM   1062  O   ALA A 140      31.622  43.711   3.722  1.00 38.03           O  
ATOM   1063  CB  ALA A 140      30.075  41.522   1.870  1.00 37.80           C  
ATOM   1064  N   LYS A 141      29.421  43.573   4.253  1.00 38.41           N  
ATOM   1065  CA  LYS A 141      29.314  44.948   4.776  1.00 38.88           C  
ATOM   1066  C   LYS A 141      30.067  45.102   6.105  1.00 38.47           C  
ATOM   1067  O   LYS A 141      30.655  46.160   6.352  1.00 37.52           O  
ATOM   1068  CB  LYS A 141      27.841  45.386   4.903  1.00 39.12           C  
ATOM   1069  CG  LYS A 141      27.631  46.879   5.209  1.00 41.26           C  
ATOM   1070  CD  LYS A 141      27.433  47.204   6.698  1.00 43.72           C  
ATOM   1071  CE  LYS A 141      26.012  46.900   7.163  1.00 44.68           C  
ATOM   1072  NZ  LYS A 141      25.007  47.830   6.559  1.00 44.49           N  
ATOM   1073  N   ALA A 142      30.038  44.054   6.941  1.00 38.44           N  
ATOM   1074  CA  ALA A 142      30.761  44.015   8.228  1.00 38.33           C  
ATOM   1075  C   ALA A 142      32.271  44.187   8.034  1.00 38.67           C  
ATOM   1076  O   ALA A 142      32.902  44.954   8.763  1.00 39.52           O  
ATOM   1077  CB  ALA A 142      30.469  42.717   8.974  1.00 38.28           C  
ATOM   1078  N   HIS A 143      32.831  43.469   7.055  1.00 38.66           N  
ATOM   1079  CA  HIS A 143      34.257  43.594   6.676  1.00 38.54           C  
ATOM   1080  C   HIS A 143      34.615  44.981   6.125  1.00 39.08           C  
ATOM   1081  O   HIS A 143      35.685  45.520   6.434  1.00 39.42           O  
ATOM   1082  CB  HIS A 143      34.653  42.547   5.617  1.00 38.30           C  
ATOM   1083  CG  HIS A 143      34.980  41.199   6.174  1.00 37.10           C  
ATOM   1084  ND1 HIS A 143      36.278  40.768   6.327  1.00 35.95           N  
ATOM   1085  CD2 HIS A 143      34.194  40.184   6.597  1.00 35.38           C  
ATOM   1086  CE1 HIS A 143      36.278  39.546   6.822  1.00 36.15           C  
ATOM   1087  NE2 HIS A 143      35.025  39.169   7.001  1.00 36.13           N  
ATOM   1088  N   LEU A 144      33.724  45.534   5.303  1.00 39.53           N  
ATOM   1089  CA  LEU A 144      33.937  46.836   4.657  1.00 40.05           C  
ATOM   1090  C   LEU A 144      33.816  48.053   5.600  1.00 40.86           C  
ATOM   1091  O   LEU A 144      34.399  49.093   5.310  1.00 40.96           O  
ATOM   1092  CB  LEU A 144      32.970  46.986   3.468  1.00 39.65           C  
ATOM   1093  CG  LEU A 144      33.214  48.073   2.421  1.00 40.43           C  
ATOM   1094  CD1 LEU A 144      34.528  47.838   1.683  1.00 39.70           C  
ATOM   1095  CD2 LEU A 144      32.062  48.112   1.430  1.00 39.97           C  
ATOM   1096  N   THR A 145      33.100  47.914   6.722  1.00 42.38           N  
ATOM   1097  CA  THR A 145      32.845  49.021   7.666  1.00 43.59           C  
ATOM   1098  C   THR A 145      33.448  48.916   9.085  1.00 44.42           C  
ATOM   1099  O   THR A 145      33.331  49.882   9.844  1.00 45.00           O  
ATOM   1100  CB  THR A 145      31.314  49.218   7.818  1.00 43.30           C  
ATOM   1101  OG1 THR A 145      30.718  48.011   8.316  1.00 43.39           O  
ATOM   1102  CG2 THR A 145      30.684  49.577   6.478  1.00 42.28           C  
ATOM   1103  N   ASP A 146      34.115  47.804   9.431  1.00 45.31           N  
ATOM   1104  CA  ASP A 146      34.646  47.560  10.807  1.00 46.05           C  
ATOM   1105  C   ASP A 146      33.540  47.625  11.881  1.00 47.50           C  
ATOM   1106  O   ASP A 146      33.663  48.296  12.912  1.00 48.03           O  
ATOM   1107  CB  ASP A 146      35.875  48.458  11.152  1.00 46.50           C  
ATOM   1108  CG  ASP A 146      37.216  47.825  10.781  1.00 47.12           C  
ATOM   1109  OD1 ASP A 146      37.266  46.854   9.992  1.00 50.06           O  
ATOM   1110  OD2 ASP A 146      38.240  48.304  11.313  1.00 45.29           O  
ATOM   1111  N   GLU A 147      32.450  46.922  11.589  1.00 48.94           N  
ATOM   1112  CA  GLU A 147      31.286  46.800  12.467  1.00 50.61           C  
ATOM   1113  C   GLU A 147      30.867  45.340  12.455  1.00 51.45           C  
ATOM   1114  O   GLU A 147      30.994  44.675  11.420  1.00 51.53           O  
ATOM   1115  CB  GLU A 147      30.137  47.663  11.949  1.00 50.43           C  
ATOM   1116  CG  GLU A 147      30.433  49.165  11.924  1.00 51.71           C  
ATOM   1117  CD  GLU A 147      29.294  50.017  11.360  1.00 51.92           C  
ATOM   1118  OE1 GLU A 147      29.357  51.255  11.517  1.00 53.93           O  
ATOM   1119  OE2 GLU A 147      28.339  49.468  10.762  1.00 55.16           O  
ATOM   1120  N   THR A 148      30.381  44.838  13.592  1.00 52.69           N  
ATOM   1121  CA  THR A 148      29.908  43.451  13.675  1.00 54.07           C  
ATOM   1122  C   THR A 148      28.567  43.355  12.919  1.00 54.70           C  
ATOM   1123  O   THR A 148      27.817  44.338  12.906  1.00 54.91           O  
ATOM   1124  CB  THR A 148      29.748  42.960  15.129  1.00 54.23           C  
ATOM   1125  OG1 THR A 148      28.810  43.789  15.824  1.00 56.47           O  
ATOM   1126  CG2 THR A 148      31.092  42.989  15.853  1.00 54.02           C  
ATOM   1127  N   PRO A 149      28.271  42.199  12.273  1.00 55.70           N  
ATOM   1128  CA  PRO A 149      27.006  42.057  11.532  1.00 56.34           C  
ATOM   1129  C   PRO A 149      25.743  42.183  12.397  1.00 57.11           C  
ATOM   1130  O   PRO A 149      25.730  41.694  13.529  1.00 57.22           O  
ATOM   1131  CB  PRO A 149      27.091  40.631  10.957  1.00 56.46           C  
ATOM   1132  CG  PRO A 149      28.496  40.270  10.999  1.00 56.22           C  
ATOM   1133  CD  PRO A 149      29.079  40.969  12.168  1.00 55.76           C  
ATOM   1134  N   ASP A 150      24.718  42.848  11.861  1.00 58.27           N  
ATOM   1135  CA  ASP A 150      23.420  42.992  12.526  1.00 59.19           C  
ATOM   1136  C   ASP A 150      22.596  41.793  12.065  1.00 60.08           C  
ATOM   1137  O   ASP A 150      21.811  41.896  11.113  1.00 60.83           O  
ATOM   1138  CB  ASP A 150      22.740  44.316  12.154  1.00 59.17           C  
HETATM 1139  N   MSE A 151      22.815  40.653  12.726  1.00 60.56           N  
HETATM 1140  CA  MSE A 151      22.130  39.391  12.390  1.00 61.05           C  
HETATM 1141  C   MSE A 151      20.632  39.475  12.694  1.00 60.88           C  
HETATM 1142  O   MSE A 151      19.805  39.242  11.803  1.00 61.67           O  
HETATM 1143  CB  MSE A 151      22.755  38.202  13.136  1.00 61.15           C  
ATOM   1144  N   GLY A 152      20.302  39.825  13.939  1.00 59.30           N  
ATOM   1145  CA  GLY A 152      18.906  39.975  14.368  1.00 58.19           C  
ATOM   1146  C   GLY A 152      18.704  40.036  15.874  1.00 57.06           C  
ATOM   1147  O   GLY A 152      19.600  40.473  16.600  1.00 57.75           O  
ATOM   1148  N   GLU A 153      17.528  39.597  16.331  1.00 55.59           N  
ATOM   1149  CA  GLU A 153      17.140  39.618  17.751  1.00 54.58           C  
ATOM   1150  C   GLU A 153      17.197  38.233  18.402  1.00 53.71           C  
ATOM   1151  O   GLU A 153      16.942  37.228  17.743  1.00 53.03           O  
ATOM   1152  CB  GLU A 153      15.719  40.173  17.896  1.00 54.26           C  
ATOM   1153  N   GLN A 154      17.549  38.208  19.690  1.00 53.50           N  
ATOM   1154  CA  GLN A 154      17.583  36.993  20.523  1.00 53.56           C  
ATOM   1155  C   GLN A 154      16.961  37.324  21.884  1.00 52.42           C  
ATOM   1156  O   GLN A 154      17.270  38.371  22.461  1.00 52.85           O  
ATOM   1157  CB  GLN A 154      19.013  36.471  20.709  1.00 53.34           C  
ATOM   1158  CG  GLN A 154      19.098  35.128  21.472  1.00 55.13           C  
ATOM   1159  CD  GLN A 154      20.497  34.516  21.479  1.00 55.91           C  
ATOM   1160  OE1 GLN A 154      21.501  35.221  21.611  1.00 62.41           O  
ATOM   1161  NE2 GLN A 154      20.563  33.191  21.362  1.00 58.10           N  
ATOM   1162  N   ALA A 155      16.093  36.445  22.387  1.00 51.33           N  
ATOM   1163  CA  ALA A 155      15.441  36.656  23.691  1.00 50.56           C  
ATOM   1164  C   ALA A 155      14.761  35.409  24.252  1.00 49.55           C  
ATOM   1165  O   ALA A 155      14.429  34.484  23.504  1.00 48.37           O  
ATOM   1166  CB  ALA A 155      14.420  37.795  23.596  1.00 50.24           C  
ATOM   1167  N   THR A 156      14.581  35.406  25.575  1.00 49.05           N  
ATOM   1168  CA  THR A 156      13.866  34.353  26.297  1.00 48.68           C  
ATOM   1169  C   THR A 156      12.451  34.908  26.448  1.00 48.43           C  
ATOM   1170  O   THR A 156      12.251  35.926  27.113  1.00 48.31           O  
ATOM   1171  CB  THR A 156      14.524  34.028  27.649  1.00 48.85           C  
ATOM   1172  OG1 THR A 156      15.808  33.439  27.407  1.00 49.40           O  
ATOM   1173  CG2 THR A 156      13.674  33.045  28.461  1.00 46.79           C  
ATOM   1174  N   VAL A 157      11.492  34.226  25.819  1.00 48.26           N  
ATOM   1175  CA  VAL A 157      10.087  34.642  25.742  1.00 47.97           C  
ATOM   1176  C   VAL A 157       9.173  33.757  26.594  1.00 46.93           C  
ATOM   1177  O   VAL A 157       9.445  32.565  26.749  1.00 46.72           O  
ATOM   1178  CB  VAL A 157       9.618  34.552  24.253  1.00 47.90           C  
ATOM   1179  CG1 VAL A 157       8.142  34.872  24.093  1.00 49.43           C  
ATOM   1180  CG2 VAL A 157      10.454  35.477  23.376  1.00 48.26           C  
ATOM   1181  N   THR A 158       8.110  34.360  27.140  1.00 45.60           N  
ATOM   1182  CA  THR A 158       7.051  33.655  27.870  1.00 44.42           C  
ATOM   1183  C   THR A 158       5.790  33.799  27.006  1.00 44.74           C  
ATOM   1184  O   THR A 158       5.344  34.920  26.748  1.00 44.45           O  
ATOM   1185  CB  THR A 158       6.790  34.253  29.265  1.00 44.03           C  
ATOM   1186  OG1 THR A 158       8.005  34.266  30.021  1.00 43.99           O  
ATOM   1187  CG2 THR A 158       5.742  33.435  30.012  1.00 41.79           C  
ATOM   1188  N   PHE A 159       5.239  32.672  26.552  1.00 45.06           N  
ATOM   1189  CA  PHE A 159       4.028  32.671  25.718  1.00 45.45           C  
ATOM   1190  C   PHE A 159       2.771  32.928  26.556  1.00 45.96           C  
ATOM   1191  O   PHE A 159       2.702  32.615  27.747  1.00 46.13           O  
ATOM   1192  CB  PHE A 159       3.898  31.360  24.934  1.00 45.02           C  
ATOM   1193  CG  PHE A 159       4.949  31.184  23.864  1.00 45.65           C  
ATOM   1194  CD1 PHE A 159       6.200  30.642  24.175  1.00 45.45           C  
ATOM   1195  CD2 PHE A 159       4.685  31.550  22.537  1.00 43.98           C  
ATOM   1196  CE1 PHE A 159       7.183  30.469  23.183  1.00 44.68           C  
ATOM   1197  CE2 PHE A 159       5.659  31.383  21.534  1.00 44.52           C  
ATOM   1198  CZ  PHE A 159       6.911  30.843  21.858  1.00 44.07           C  
ATOM   1199  OXT PHE A 159       1.786  33.470  26.057  1.00 46.97           O  
TER    1200      PHE A 159                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
