
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  143 ( 1138),  selected  143 , name 2ig6_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2ig6_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   -11_A      M       1           -
LGA    H   -10_A      A       2           -
LGA    H    -9_A      D       3           -
LGA    H    -8_A      P       4           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      -       -           -
LGA    F    -2_A      -       -           -
LGA    Q    -1_A      K       5           #
LGA    -       -      E       6           -
LGA    -       -      L       7           -
LGA    G     0_A      Q       8          5.238
LGA    X     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    R     3_A      -       -           -
LGA    A     4_A      D       9           #
LGA    -       -      K      10           -
LGA    -       -      F      11           -
LGA    L     5_A      W      12          3.623
LGA    E     6_A      K      13          2.193
LGA    F     7_A      A      14          2.348
LGA    L     8_A      L      15          1.669
LGA    K     9_A      K      16          3.049
LGA    E    10_A      S      17          4.331
LGA    C    11_A      D      18          3.701
LGA    G    12_A      R      19          3.786
LGA    V    13_A      T      20          2.407
LGA    F    14_A      V      21          2.226
LGA    Y    15_A      M      22          0.603
LGA    L    16_A      L      23          0.757
LGA    A    17_A      G      24          1.027
LGA    T    18_A      L      25          1.422
LGA    N    19_A      D      26          5.029
LGA    E    20_A      -       -           -
LGA    G    21_A      G      27           #
LGA    D    22_A      V      28          3.040
LGA    Q    23_A      E      29          1.458
LGA    P    24_A      D      30          3.466
LGA    R    25_A      G      31          2.207
LGA    -       -      H      32           -
LGA    V    26_A      A      33          0.657
LGA    R    27_A      R      34          0.786
LGA    P    28_A      P      35          1.001
LGA    F    29_A      M      36          1.042
LGA    G    30_A      T      37          2.015
LGA    A    31_A      A      38          3.576
LGA    V    32_A      Q      39          1.608
LGA    F    33_A      I      40          2.463
LGA    E    34_A      E      41          2.069
LGA    Y    35_A      G      42           #
LGA    E    36_A      D      43           -
LGA    -       -      S      44           -
LGA    G    37_A      G      45          5.475
LGA    K    38_A      G      46          3.219
LGA    L    39_A      P      47          2.376
LGA    Y    40_A      I      48          2.881
LGA    -       -      W      49           -
LGA    I    41_A      F      50          1.857
LGA    V    42_A      F      51          1.973
LGA    S    43_A      T      52          1.632
LGA    N    44_A      S      53          1.736
LGA    N    45_A      K      54          1.733
LGA    T    46_A      D      55          1.599
LGA    K    47_A      N      56          1.375
LGA    K    48_A      A      57          0.573
LGA    C    49_A      L      58          2.130
LGA    F    50_A      I      59          1.957
LGA    K    51_A      A      60          2.000
LGA    Q    52_A      M      61          2.884
LGA    X    53_A      L      62          3.090
LGA    I    54_A      G      63          3.308
LGA    Q    55_A      Q      64           #
LGA    N    56_A      G      65          5.361
LGA    P    57_A      R      66          1.513
LGA    K    58_A      R      67          0.809
LGA    V    59_A      V      68          0.726
LGA    E    60_A      I      69          0.825
LGA    I    61_A      G      70          0.565
LGA    S    62_A      A      71          0.954
LGA    G    63_A      F      72          1.727
LGA    X    64_A      S      73          1.418
LGA    N    65_A      S      74          1.773
LGA    -       -      K      75           -
LGA    K    66_A      G      76          0.411
LGA    K    67_A      H      77          3.590
LGA    G    68_A      D      78          3.464
LGA    Q    69_A      L      79          1.770
LGA    W    70_A      F      80          0.351
LGA    I    71_A      A      81          0.571
LGA    R    72_A      S      82          0.631
LGA    L    73_A      I      83          0.494
LGA    T    74_A      S      84          0.386
LGA    G    75_A      G      85          0.444
LGA    E    76_A      S      86          0.407
LGA    V    77_A      L      87          2.065
LGA    A    78_A      R      88          2.902
LGA    N    79_A      E      89          2.008
LGA    D    80_A      D      90          1.715
LGA    D    81_A      T      91          3.033
LGA    R    82_A      D      92          1.840
LGA    R    83_A      P      93          0.829
LGA    E    84_A      A      94          1.092
LGA    V    85_A      V      95          0.857
LGA    K    86_A      V      96          0.959
LGA    E    87_A      D      97          1.431
LGA    L    88_A      R      98          1.558
LGA    A    89_A      L      99          1.853
LGA    L    90_A      W     100          1.400
LGA    E    91_A      N     101          2.926
LGA    A    92_A      -       -           -
LGA    V    93_A      -       -           -
LGA    P    94_A      P     102          2.247
LGA    S    95_A      Y     103          0.725
LGA    L    96_A      V     104          1.021
LGA    K    97_A      A     105          0.740
LGA    N    98_A      A     106          1.269
LGA    X    99_A      W     107          1.839
LGA    Y   100_A      Y     108          2.437
LGA    -       -      E     109           -
LGA    -       -      G     110           -
LGA    S   101_A      G     111          1.784
LGA    V   102_A      K     112          1.234
LGA    D   103_A      D     113          1.036
LGA    D   104_A      D     114          0.972
LGA    G   105_A      P     115          1.747
LGA    I   106_A      K     116          2.308
LGA    F   107_A      L     117          1.535
LGA    A   108_A      A     118          1.663
LGA    V   109_A      L     119          1.683
LGA    L   110_A      L     120          2.277
LGA    Y   111_A      R     121          2.047
LGA    F   112_A      L     122          2.755
LGA    T   113_A      D     123          2.889
LGA    K   114_A      A     124          3.997
LGA    G   115_A      D     125          1.248
LGA    E   116_A      H     126          0.440
LGA    G   117_A      A     127          0.654
LGA    T   118_A      Q     128          1.949
LGA    I   119_A      I     129          1.601
LGA    C   120_A      W     130          0.565
LGA    S   121_A      L     131          1.138
LGA    F   122_A      N     132          2.830
LGA    K   123_A      G     133          3.128
LGA    G   124_A      S     134           -
LGA    E   125_A      S     135           -
LGA    N   126_A      L     136           -
LGA    E   127_A      L     137           -
LGA    T   128_A      A     138           -
LGA    F   129_A      G     139           -
LGA    S   130_A      I     140           -
LGA    L   131_A      K     141           -
LGA    -       -      V     142           -
LGA    -       -      L     143           -
LGA    -       -      L     144           -
LGA    -       -      G     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  143  145    5.0    113    2.23    16.81     55.133     4.842

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.160528 * X  +  -0.188227 * Y  +  -0.968918 * Z  +  34.699257
  Y_new =  -0.804037 * X  +   0.544439 * Y  +  -0.238977 * Z  +  21.165014
  Z_new =   0.572499 * X  +   0.817408 * Y  +  -0.063944 * Z  + -47.511139 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.648865   -1.492727  [ DEG:    94.4730    -85.5270 ]
  Theta =  -0.609550   -2.532043  [ DEG:   -34.9247   -145.0753 ]
  Phi   =  -1.373736    1.767857  [ DEG:   -78.7092    101.2908 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ig6_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ig6_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  143  145   5.0  113   2.23   16.81  55.133
REMARK  ---------------------------------------------------------- 
MOLECULE 2ig6_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   22-SEP-06   2IG6              
TITLE     CRYSTAL STRUCTURE OF NIMC/NIMA FAMILY PROTEIN (NP_349178.1)           
TITLE    2 FROM CLOSTRIDIUM ACETOBUTYLICUM AT 1.80 A RESOLUTION                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NIMC/NIMA FAMILY PROTEIN;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CLOSTRIDIUM ACETOBUTYLICUM;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_349178.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_349178.1, NIMC/NIMA FAMILY PROTEIN, STRUCTURAL GENOMICS,           
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, JOINT CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, JCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   10-OCT-06 2IG6    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF NIMC/NIMA FAMILY PROTEIN                
JRNL        TITL 2 (NP_349178.1) FROM CLOSTRIDIUM ACETOBUTYLICUM AT             
JRNL        TITL 3 1.80 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2IG6 A    1   131  UNP    Q97G05   Q97G05_CLOAB     1    131             
DBREF  2IG6 B    1   131  UNP    Q97G05   Q97G05_CLOAB     1    131             
SEQRES   1 A  150  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  150  ASN LEU TYR PHE GLN GLY MSE LYS ARG ALA LEU GLU PHE          
SEQRES   3 A  150  LEU LYS GLU CYS GLY VAL PHE TYR LEU ALA THR ASN GLU          
SEQRES   4 A  150  GLY ASP GLN PRO ARG VAL ARG PRO PHE GLY ALA VAL PHE          
SEQRES   5 A  150  GLU TYR GLU GLY LYS LEU TYR ILE VAL SER ASN ASN THR          
SEQRES   6 A  150  LYS LYS CYS PHE LYS GLN MSE ILE GLN ASN PRO LYS VAL          
SEQRES   7 A  150  GLU ILE SER GLY MSE ASN LYS LYS GLY GLN TRP ILE ARG          
SEQRES   8 A  150  LEU THR GLY GLU VAL ALA ASN ASP ASP ARG ARG GLU VAL          
SEQRES   9 A  150  LYS GLU LEU ALA LEU GLU ALA VAL PRO SER LEU LYS ASN          
SEQRES  10 A  150  MSE TYR SER VAL ASP ASP GLY ILE PHE ALA VAL LEU TYR          
SEQRES  11 A  150  PHE THR LYS GLY GLU GLY THR ILE CYS SER PHE LYS GLY          
SEQRES  12 A  150  GLU ASN GLU THR PHE SER LEU                                  
SEQRES   1 B  150  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  150  ASN LEU TYR PHE GLN GLY MSE LYS ARG ALA LEU GLU PHE          
SEQRES   3 B  150  LEU LYS GLU CYS GLY VAL PHE TYR LEU ALA THR ASN GLU          
SEQRES   4 B  150  GLY ASP GLN PRO ARG VAL ARG PRO PHE GLY ALA VAL PHE          
SEQRES   5 B  150  GLU TYR GLU GLY LYS LEU TYR ILE VAL SER ASN ASN THR          
SEQRES   6 B  150  LYS LYS CYS PHE LYS GLN MSE ILE GLN ASN PRO LYS VAL          
SEQRES   7 B  150  GLU ILE SER GLY MSE ASN LYS LYS GLY GLN TRP ILE ARG          
SEQRES   8 B  150  LEU THR GLY GLU VAL ALA ASN ASP ASP ARG ARG GLU VAL          
SEQRES   9 B  150  LYS GLU LEU ALA LEU GLU ALA VAL PRO SER LEU LYS ASN          
SEQRES  10 B  150  MSE TYR SER VAL ASP ASP GLY ILE PHE ALA VAL LEU TYR          
SEQRES  11 B  150  PHE THR LYS GLY GLU GLY THR ILE CYS SER PHE LYS GLY          
SEQRES  12 B  150  GLU ASN GLU THR PHE SER LEU                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  64       8                                                       
HET    MSE  A  99       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B  64       8                                                       
HET    MSE  B  99       8                                                       
HET    SO4      2       5                                                       
HET    SO4      3       5                                                       
HET    SO4      4       5                                                       
HET    FMN  A 339      31                                                       
HET    UNL  A 340       9                                                       
HET    EDO      1       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  SO4    3(O4 S 2-)                                                   
FORMUL   6  FMN    C17 H21 N4 O9 P                                              
FORMUL   8  EDO    C2 H6 O2                                                     
FORMUL   9  HOH   *275(H2 O)                                                    
CRYST1   52.431   65.305  108.788  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   HIS A -11      -1.187  29.259  32.242  1.00 64.96           N  
ATOM      2  CA  HIS A -11      -2.131  29.609  31.131  1.00 63.97           C  
ATOM      3  C   HIS A -11      -3.512  29.990  31.689  1.00 61.87           C  
ATOM      4  O   HIS A -11      -4.060  29.278  32.526  1.00 62.75           O  
ATOM      5  CB  HIS A -11      -2.252  28.443  30.153  1.00 64.03           C  
ATOM      6  CG  HIS A -11      -2.896  28.798  28.848  1.00 67.24           C  
ATOM      7  ND1 HIS A -11      -2.197  28.841  27.658  1.00 65.54           N  
ATOM      8  CD2 HIS A -11      -4.185  29.092  28.539  1.00 68.35           C  
ATOM      9  CE1 HIS A -11      -3.024  29.158  26.678  1.00 67.62           C  
ATOM     10  NE2 HIS A -11      -4.236  29.320  27.186  1.00 68.16           N  
ATOM     11  N   HIS A -10      -4.044  31.120  31.226  1.00 59.13           N  
ATOM     12  CA  HIS A -10      -5.357  31.620  31.623  1.00 55.85           C  
ATOM     13  C   HIS A -10      -6.192  31.968  30.399  1.00 53.63           C  
ATOM     14  O   HIS A -10      -5.757  32.766  29.568  1.00 47.93           O  
ATOM     15  CB  HIS A -10      -5.209  32.881  32.458  1.00 57.28           C  
ATOM     16  CG  HIS A -10      -4.292  32.729  33.626  1.00 58.94           C  
ATOM     17  ND1 HIS A -10      -2.937  32.955  33.539  1.00 60.61           N  
ATOM     18  CD2 HIS A -10      -4.538  32.386  34.912  1.00 61.92           C  
ATOM     19  CE1 HIS A -10      -2.385  32.755  34.721  1.00 62.89           C  
ATOM     20  NE2 HIS A -10      -3.335  32.409  35.572  1.00 61.44           N  
ATOM     21  N   HIS A  -9      -7.413  31.422  30.327  1.00 52.51           N  
ATOM     22  CA  HIS A  -9      -8.291  31.594  29.148  1.00 52.04           C  
ATOM     23  C   HIS A  -9      -8.531  33.052  28.741  1.00 49.09           C  
ATOM     24  O   HIS A  -9      -8.664  33.346  27.557  1.00 48.91           O  
ATOM     25  CB  HIS A  -9      -9.656  30.903  29.358  1.00 53.30           C  
ATOM     26  CG  HIS A  -9      -9.615  29.418  29.172  1.00 57.00           C  
ATOM     27  ND1 HIS A  -9      -9.715  28.533  30.225  1.00 60.59           N  
ATOM     28  CD2 HIS A  -9      -9.477  28.662  28.058  1.00 58.58           C  
ATOM     29  CE1 HIS A  -9      -9.640  27.296  29.765  1.00 60.82           C  
ATOM     30  NE2 HIS A  -9      -9.497  27.346  28.453  1.00 59.90           N  
ATOM     31  N   HIS A  -8      -8.588  33.951  29.719  1.00 46.82           N  
ATOM     32  CA  HIS A  -8      -8.879  35.374  29.463  1.00 45.08           C  
ATOM     33  C   HIS A  -8      -7.672  36.169  28.927  1.00 43.82           C  
ATOM     34  O   HIS A  -8      -7.825  37.348  28.547  1.00 42.92           O  
ATOM     35  CB  HIS A  -8      -9.402  36.039  30.735  1.00 46.48           C  
ATOM     36  CG  HIS A  -8      -8.361  36.218  31.798  1.00 50.05           C  
ATOM     37  ND1 HIS A  -8      -8.031  35.223  32.696  1.00 49.99           N  
ATOM     38  CD2 HIS A  -8      -7.584  37.283  32.111  1.00 50.90           C  
ATOM     39  CE1 HIS A  -8      -7.093  35.669  33.513  1.00 56.84           C  
ATOM     40  NE2 HIS A  -8      -6.802  36.914  33.178  1.00 54.29           N  
ATOM     41  N   HIS A  -7      -6.485  35.541  28.936  1.00 40.54           N  
ATOM     42  CA  HIS A  -7      -5.306  36.078  28.250  1.00 39.73           C  
ATOM     43  C   HIS A  -7      -5.145  35.469  26.865  1.00 39.50           C  
ATOM     44  O   HIS A  -7      -4.091  35.594  26.256  1.00 37.50           O  
ATOM     45  CB  HIS A  -7      -4.027  35.861  29.075  1.00 39.04           C  
ATOM     46  CG  HIS A  -7      -3.997  36.659  30.341  1.00 38.72           C  
ATOM     47  ND1 HIS A  -7      -3.376  36.215  31.486  1.00 38.31           N  
ATOM     48  CD2 HIS A  -7      -4.548  37.856  30.650  1.00 39.54           C  
ATOM     49  CE1 HIS A  -7      -3.542  37.110  32.445  1.00 36.55           C  
ATOM     50  NE2 HIS A  -7      -4.254  38.114  31.966  1.00 41.11           N  
ATOM     51  N   GLU A  -6      -6.211  34.853  26.344  1.00 42.08           N  
ATOM     52  CA  GLU A  -6      -6.143  34.186  25.043  1.00 43.48           C  
ATOM     53  C   GLU A  -6      -5.781  35.163  23.903  1.00 41.88           C  
ATOM     54  O   GLU A  -6      -5.140  34.762  22.927  1.00 40.85           O  
ATOM     55  CB  GLU A  -6      -7.463  33.441  24.750  1.00 45.53           C  
ATOM     56  CG  GLU A  -6      -7.370  32.352  23.679  1.00 51.35           C  
ATOM     57  CD  GLU A  -6      -6.524  31.141  24.092  1.00 53.62           C  
ATOM     58  OE1 GLU A  -6      -6.639  30.675  25.251  1.00 56.84           O  
ATOM     59  OE2 GLU A  -6      -5.763  30.639  23.235  1.00 57.67           O  
ATOM     60  N   ASN A  -5      -6.168  36.433  24.027  1.00 41.17           N  
ATOM     61  CA  ASN A  -5      -5.775  37.452  23.037  1.00 43.54           C  
ATOM     62  C   ASN A  -5      -4.258  37.623  22.923  1.00 43.98           C  
ATOM     63  O   ASN A  -5      -3.711  37.789  21.820  1.00 46.63           O  
ATOM     64  CB  ASN A  -5      -6.442  38.810  23.299  1.00 46.44           C  
ATOM     65  CG  ASN A  -5      -6.307  39.301  24.747  1.00 51.08           C  
ATOM     66  OD1 ASN A  -5      -6.047  38.530  25.675  1.00 52.29           O  
ATOM     67  ND2 ASN A  -5      -6.518  40.601  24.936  1.00 52.90           N  
ATOM     68  N   LEU A  -4      -3.592  37.599  24.074  1.00 42.14           N  
ATOM     69  CA  LEU A  -4      -2.122  37.637  24.132  1.00 41.73           C  
ATOM     70  C   LEU A  -4      -1.502  36.349  23.607  1.00 41.85           C  
ATOM     71  O   LEU A  -4      -0.605  36.372  22.747  1.00 41.59           O  
ATOM     72  CB  LEU A  -4      -1.670  37.900  25.571  1.00 39.89           C  
ATOM     73  CG  LEU A  -4      -1.944  39.310  26.083  1.00 41.23           C  
ATOM     74  CD1 LEU A  -4      -1.825  39.385  27.594  1.00 39.89           C  
ATOM     75  CD2 LEU A  -4      -0.994  40.313  25.420  1.00 41.42           C  
ATOM     76  N   TYR A  -3      -1.985  35.218  24.114  1.00 41.43           N  
ATOM     77  CA  TYR A  -3      -1.484  33.928  23.669  1.00 40.53           C  
ATOM     78  C   TYR A  -3      -1.631  33.759  22.161  1.00 41.21           C  
ATOM     79  O   TYR A  -3      -0.800  33.116  21.545  1.00 39.78           O  
ATOM     80  CB  TYR A  -3      -2.204  32.775  24.360  1.00 38.93           C  
ATOM     81  CG  TYR A  -3      -2.062  32.735  25.859  1.00 38.94           C  
ATOM     82  CD1 TYR A  -3      -0.837  32.978  26.481  1.00 37.29           C  
ATOM     83  CD2 TYR A  -3      -3.150  32.397  26.657  1.00 39.97           C  
ATOM     84  CE1 TYR A  -3      -0.719  32.917  27.855  1.00 40.86           C  
ATOM     85  CE2 TYR A  -3      -3.040  32.339  28.017  1.00 41.76           C  
ATOM     86  CZ  TYR A  -3      -1.836  32.610  28.616  1.00 40.92           C  
ATOM     87  OH  TYR A  -3      -1.749  32.548  29.979  1.00 44.55           O  
ATOM     88  N   PHE A  -2      -2.686  34.328  21.569  1.00 37.88           N  
ATOM     89  CA  PHE A  -2      -2.900  34.139  20.143  1.00 39.61           C  
ATOM     90  C   PHE A  -2      -1.740  34.728  19.350  1.00 37.67           C  
ATOM     91  O   PHE A  -2      -1.318  34.141  18.375  1.00 38.01           O  
ATOM     92  CB  PHE A  -2      -4.236  34.755  19.689  1.00 40.76           C  
ATOM     93  CG  PHE A  -2      -4.454  34.703  18.198  1.00 44.47           C  
ATOM     94  CD1 PHE A  -2      -4.974  33.561  17.597  1.00 51.00           C  
ATOM     95  CD2 PHE A  -2      -4.141  35.793  17.398  1.00 46.12           C  
ATOM     96  CE1 PHE A  -2      -5.185  33.503  16.218  1.00 49.42           C  
ATOM     97  CE2 PHE A  -2      -4.354  35.749  16.025  1.00 48.53           C  
ATOM     98  CZ  PHE A  -2      -4.875  34.596  15.435  1.00 50.13           C  
ATOM     99  N   GLN A  -1      -1.243  35.889  19.772  1.00 36.61           N  
ATOM    100  CA  GLN A  -1      -0.136  36.538  19.083  1.00 39.85           C  
ATOM    101  C   GLN A  -1       1.152  35.706  19.175  1.00 38.20           C  
ATOM    102  O   GLN A  -1       1.899  35.595  18.207  1.00 38.78           O  
ATOM    103  CB  GLN A  -1       0.102  37.930  19.655  1.00 38.88           C  
ATOM    104  CG  GLN A  -1      -1.097  38.862  19.508  1.00 43.63           C  
ATOM    105  CD  GLN A  -1      -0.828  40.209  20.100  1.00 45.43           C  
ATOM    106  OE1 GLN A  -1       0.217  40.813  19.853  1.00 59.12           O  
ATOM    107  NE2 GLN A  -1      -1.783  40.709  20.888  1.00 60.82           N  
ATOM    108  N   GLY A   0       1.394  35.113  20.337  1.00 37.47           N  
ATOM    109  CA  GLY A   0       2.533  34.190  20.507  1.00 37.55           C  
ATOM    110  C   GLY A   0       2.383  32.909  19.708  1.00 37.78           C  
ATOM    111  O   GLY A   0       3.358  32.407  19.118  1.00 38.01           O  
HETATM  112  N   MSE A   1       1.167  32.369  19.674  1.00 37.61           N  
HETATM  113  CA  MSE A   1       0.895  31.202  18.839  1.00 36.52           C  
HETATM  114  C   MSE A   1       1.211  31.528  17.371  1.00 35.63           C  
HETATM  115  O   MSE A   1       1.913  30.768  16.713  1.00 35.13           O  
HETATM  116  CB  MSE A   1      -0.560  30.749  18.992  1.00 37.34           C  
HETATM  117  CG  MSE A   1      -0.944  29.456  18.241  1.00 39.32           C  
HETATM  118 SE   MSE A   1      -1.272  29.678  16.333  0.70 42.25          SE  
HETATM  119  CE  MSE A   1      -2.735  30.617  16.468  1.00 43.75           C  
ATOM    120  N   LYS A   2       0.724  32.664  16.865  1.00 35.60           N  
ATOM    121  CA  LYS A   2       0.921  32.975  15.449  1.00 36.93           C  
ATOM    122  C   LYS A   2       2.400  33.121  15.115  1.00 36.34           C  
ATOM    123  O   LYS A   2       2.839  32.721  14.037  1.00 36.24           O  
ATOM    124  CB  LYS A   2       0.121  34.211  15.030  1.00 38.44           C  
ATOM    125  CG  LYS A   2      -1.403  33.947  14.965  1.00 44.05           C  
ATOM    126  CD  LYS A   2      -1.819  32.979  13.820  1.00 49.14           C  
ATOM    127  CE  LYS A   2      -1.957  33.685  12.464  1.00 51.02           C  
ATOM    128  NZ  LYS A   2      -1.480  32.847  11.320  1.00 48.40           N  
ATOM    129  N   ARG A   3       3.168  33.675  16.046  1.00 38.21           N  
ATOM    130  CA  ARG A   3       4.604  33.841  15.859  1.00 37.51           C  
ATOM    131  C   ARG A   3       5.319  32.499  15.822  1.00 35.75           C  
ATOM    132  O   ARG A   3       6.163  32.259  14.962  1.00 36.25           O  
ATOM    133  CB  ARG A   3       5.197  34.746  16.953  1.00 39.18           C  
ATOM    134  CG  ARG A   3       6.703  35.016  16.813  1.00 40.19           C  
ATOM    135  CD  ARG A   3       7.090  35.476  15.388  1.00 43.44           C  
ATOM    136  NE  ARG A   3       8.520  35.753  15.279  1.00 45.28           N  
ATOM    137  CZ  ARG A   3       9.270  35.531  14.201  1.00 45.98           C  
ATOM    138  NH1 ARG A   3       8.758  35.003  13.092  1.00 50.76           N  
ATOM    139  NH2 ARG A   3      10.571  35.816  14.248  1.00 49.27           N  
ATOM    140  N   ALA A   4       4.956  31.618  16.743  1.00 35.98           N  
ATOM    141  CA  ALA A   4       5.496  30.262  16.767  1.00 36.63           C  
ATOM    142  C   ALA A   4       5.151  29.491  15.472  1.00 36.62           C  
ATOM    143  O   ALA A   4       6.011  28.856  14.882  1.00 37.64           O  
ATOM    144  CB  ALA A   4       5.007  29.517  17.989  1.00 37.43           C  
ATOM    145  N   LEU A   5       3.906  29.597  15.021  1.00 37.12           N  
ATOM    146  CA  LEU A   5       3.463  28.923  13.811  1.00 36.24           C  
ATOM    147  C   LEU A   5       4.275  29.424  12.623  1.00 34.89           C  
ATOM    148  O   LEU A   5       4.811  28.629  11.848  1.00 37.54           O  
ATOM    149  CB  LEU A   5       1.972  29.182  13.583  1.00 36.86           C  
ATOM    150  CG  LEU A   5       1.342  28.562  12.333  1.00 35.94           C  
ATOM    151  CD1 LEU A   5       1.315  27.037  12.439  1.00 40.74           C  
ATOM    152  CD2 LEU A   5      -0.038  29.134  12.131  1.00 36.28           C  
ATOM    153  N   GLU A   6       4.364  30.746  12.499  1.00 34.64           N  
ATOM    154  CA  GLU A   6       5.112  31.404  11.422  1.00 38.06           C  
ATOM    155  C   GLU A   6       6.556  30.945  11.428  1.00 35.73           C  
ATOM    156  O   GLU A   6       7.091  30.583  10.386  1.00 32.43           O  
ATOM    157  CB  GLU A   6       5.062  32.919  11.600  1.00 37.91           C  
ATOM    158  CG  GLU A   6       5.828  33.728  10.566  1.00 42.05           C  
ATOM    159  CD  GLU A   6       5.810  35.215  10.893  1.00 44.24           C  
ATOM    160  OE1 GLU A   6       6.238  35.591  12.003  1.00 47.63           O  
ATOM    161  OE2 GLU A   6       5.341  36.004  10.047  1.00 55.81           O  
ATOM    162  N   PHE A   7       7.181  30.993  12.604  1.00 34.88           N  
ATOM    163  CA  PHE A   7       8.585  30.645  12.698  1.00 36.60           C  
ATOM    164  C   PHE A   7       8.824  29.162  12.380  1.00 36.94           C  
ATOM    165  O   PHE A   7       9.763  28.823  11.644  1.00 37.01           O  
ATOM    166  CB  PHE A   7       9.196  31.038  14.053  1.00 37.79           C  
ATOM    167  CG  PHE A   7      10.704  30.938  14.044  1.00 35.11           C  
ATOM    168  CD1 PHE A   7      11.468  31.996  13.597  1.00 36.43           C  
ATOM    169  CD2 PHE A   7      11.325  29.751  14.364  1.00 37.27           C  
ATOM    170  CE1 PHE A   7      12.854  31.887  13.520  1.00 38.55           C  
ATOM    171  CE2 PHE A   7      12.714  29.632  14.295  1.00 37.19           C  
ATOM    172  CZ  PHE A   7      13.464  30.690  13.877  1.00 37.02           C  
ATOM    173  N   LEU A   8       7.981  28.280  12.912  1.00 37.23           N  
ATOM    174  CA  LEU A   8       8.109  26.846  12.630  1.00 37.19           C  
ATOM    175  C   LEU A   8       7.919  26.531  11.151  1.00 39.53           C  
ATOM    176  O   LEU A   8       8.607  25.664  10.618  1.00 40.88           O  
ATOM    177  CB  LEU A   8       7.144  26.019  13.490  1.00 37.43           C  
ATOM    178  CG  LEU A   8       7.558  25.955  14.976  1.00 38.73           C  
ATOM    179  CD1 LEU A   8       6.502  25.276  15.839  1.00 37.95           C  
ATOM    180  CD2 LEU A   8       8.906  25.263  15.154  1.00 36.55           C  
ATOM    181  N   LYS A   9       6.997  27.245  10.488  1.00 39.08           N  
ATOM    182  CA  LYS A   9       6.894  27.187   9.031  1.00 39.53           C  
ATOM    183  C   LYS A   9       8.175  27.617   8.313  1.00 41.27           C  
ATOM    184  O   LYS A   9       8.558  26.988   7.340  1.00 44.12           O  
ATOM    185  CB  LYS A   9       5.666  27.980   8.549  1.00 37.92           C  
ATOM    186  CG  LYS A   9       4.386  27.274   8.886  1.00 41.54           C  
ATOM    187  CD  LYS A   9       3.184  27.998   8.326  1.00 43.96           C  
ATOM    188  CE  LYS A   9       1.934  27.196   8.542  1.00 53.98           C  
ATOM    189  NZ  LYS A   9       0.911  27.627   7.573  1.00 54.84           N  
ATOM    190  N   GLU A  10       8.863  28.642   8.809  1.00 40.52           N  
ATOM    191  CA  GLU A  10      10.143  29.061   8.249  1.00 41.80           C  
ATOM    192  C   GLU A  10      11.202  27.978   8.413  1.00 40.76           C  
ATOM    193  O   GLU A  10      12.055  27.812   7.537  1.00 41.56           O  
ATOM    194  CB  GLU A  10      10.671  30.342   8.916  1.00 42.37           C  
ATOM    195  CG  GLU A  10       9.872  31.599   8.659  1.00 44.74           C  
ATOM    196  CD  GLU A  10      10.357  32.802   9.487  1.00 48.14           C  
ATOM    197  OE1 GLU A  10      11.548  32.826   9.885  1.00 45.31           O  
ATOM    198  OE2 GLU A  10       9.547  33.732   9.741  1.00 54.82           O  
ATOM    199  N   CYS A  11      11.171  27.279   9.549  1.00 39.60           N  
ATOM    200  CA  CYS A  11      12.142  26.219   9.835  1.00 37.27           C  
ATOM    201  C   CYS A  11      11.907  25.047   8.889  1.00 39.57           C  
ATOM    202  O   CYS A  11      12.858  24.449   8.410  1.00 41.57           O  
ATOM    203  CB  CYS A  11      12.031  25.752  11.287  1.00 37.79           C  
ATOM    204  SG  CYS A  11      12.552  26.982  12.440  1.00 41.48           S  
ATOM    205  N   GLY A  12      10.643  24.729   8.643  1.00 40.21           N  
ATOM    206  CA  GLY A  12      10.246  23.566   7.875  1.00 41.30           C  
ATOM    207  C   GLY A  12      10.302  22.352   8.761  1.00 40.64           C  
ATOM    208  O   GLY A  12       9.302  21.966   9.367  1.00 43.29           O  
ATOM    209  N   VAL A  13      11.467  21.738   8.839  1.00 38.59           N  
ATOM    210  CA  VAL A  13      11.644  20.638   9.767  0.50 36.95           C  
ATOM    212  C   VAL A  13      11.992  21.225  11.129  1.00 37.63           C  
ATOM    213  O   VAL A  13      12.712  22.238  11.231  1.00 37.37           O  
ATOM    214  CB  VAL A  13      12.704  19.603   9.282  0.50 38.38           C  
ATOM    216  CG1 VAL A  13      14.112  20.193   9.245  0.50 38.41           C  
ATOM    218  CG2 VAL A  13      12.666  18.378  10.160  0.50 37.81           C  
ATOM    220  N   PHE A  14      11.445  20.622  12.173  1.00 35.08           N  
ATOM    221  CA  PHE A  14      11.794  20.997  13.510  1.00 36.47           C  
ATOM    222  C   PHE A  14      11.914  19.712  14.333  1.00 36.86           C  
ATOM    223  O   PHE A  14      11.625  18.610  13.849  1.00 39.09           O  
ATOM    224  CB  PHE A  14      10.819  22.019  14.106  1.00 37.65           C  
ATOM    225  CG  PHE A  14       9.388  21.571  14.086  1.00 35.23           C  
ATOM    226  CD1 PHE A  14       8.572  21.882  13.014  1.00 38.30           C  
ATOM    227  CD2 PHE A  14       8.858  20.851  15.160  1.00 36.88           C  
ATOM    228  CE1 PHE A  14       7.224  21.466  12.997  1.00 39.97           C  
ATOM    229  CE2 PHE A  14       7.521  20.442  15.156  1.00 37.75           C  
ATOM    230  CZ  PHE A  14       6.706  20.756  14.084  1.00 38.09           C  
ATOM    231  N   TYR A  15      12.429  19.850  15.545  1.00 35.19           N  
ATOM    232  CA  TYR A  15      12.767  18.697  16.368  1.00 35.32           C  
ATOM    233  C   TYR A  15      11.951  18.689  17.655  1.00 36.10           C  
ATOM    234  O   TYR A  15      11.969  19.651  18.415  1.00 35.89           O  
ATOM    235  CB  TYR A  15      14.271  18.656  16.618  1.00 33.67           C  
ATOM    236  CG  TYR A  15      14.971  18.391  15.303  1.00 33.99           C  
ATOM    237  CD1 TYR A  15      15.198  19.408  14.384  1.00 34.67           C  
ATOM    238  CD2 TYR A  15      15.346  17.100  14.955  1.00 36.40           C  
ATOM    239  CE1 TYR A  15      15.803  19.143  13.170  1.00 37.13           C  
ATOM    240  CE2 TYR A  15      15.948  16.832  13.766  1.00 36.45           C  
ATOM    241  CZ  TYR A  15      16.182  17.854  12.867  1.00 36.46           C  
ATOM    242  OH  TYR A  15      16.772  17.544  11.655  1.00 39.43           O  
ATOM    243  N   LEU A  16      11.253  17.577  17.872  1.00 34.52           N  
ATOM    244  CA  LEU A  16      10.350  17.412  19.006  1.00 35.24           C  
ATOM    245  C   LEU A  16      11.002  16.514  20.048  1.00 34.00           C  
ATOM    246  O   LEU A  16      11.360  15.351  19.751  1.00 33.51           O  
ATOM    247  CB  LEU A  16       9.059  16.756  18.550  1.00 35.28           C  
ATOM    248  CG  LEU A  16       8.090  16.380  19.679  1.00 37.69           C  
ATOM    249  CD1 LEU A  16       7.586  17.609  20.352  1.00 37.99           C  
ATOM    250  CD2 LEU A  16       6.948  15.528  19.127  1.00 41.57           C  
ATOM    251  N   ALA A  17      11.229  17.074  21.230  1.00 32.42           N  
ATOM    252  CA  ALA A  17      11.808  16.314  22.326  1.00 33.28           C  
ATOM    253  C   ALA A  17      10.740  15.920  23.344  1.00 34.79           C  
ATOM    254  O   ALA A  17       9.926  16.744  23.771  1.00 35.52           O  
ATOM    255  CB  ALA A  17      12.922  17.098  23.009  1.00 33.66           C  
ATOM    256  N   THR A  18      10.758  14.634  23.698  1.00 33.78           N  
ATOM    257  CA  THR A  18       9.933  14.043  24.735  1.00 35.03           C  
ATOM    258  C   THR A  18      10.853  13.298  25.710  1.00 34.97           C  
ATOM    259  O   THR A  18      12.066  13.279  25.540  1.00 36.22           O  
ATOM    260  CB  THR A  18       8.951  13.003  24.135  1.00 35.55           C  
ATOM    261  OG1 THR A  18       9.712  12.053  23.379  1.00 34.89           O  
ATOM    262  CG2 THR A  18       7.998  13.663  23.190  1.00 35.19           C  
ATOM    263  N   ASN A  19      10.242  12.707  26.730  1.00 36.21           N  
ATOM    264  CA  ASN A  19      10.882  11.799  27.682  1.00 38.04           C  
ATOM    265  C   ASN A  19      10.268  10.420  27.534  1.00 36.47           C  
ATOM    266  O   ASN A  19       9.054  10.298  27.286  1.00 34.92           O  
ATOM    267  CB  ASN A  19      10.546  12.232  29.139  1.00 42.89           C  
ATOM    268  CG  ASN A  19      11.549  13.172  29.703  1.00 47.84           C  
ATOM    269  OD1 ASN A  19      11.296  13.852  30.684  1.00 50.37           O  
ATOM    270  ND2 ASN A  19      12.715  13.203  29.100  1.00 53.08           N  
ATOM    271  N   GLU A  20      11.090   9.403  27.757  1.00 34.57           N  
ATOM    272  CA  GLU A  20      10.658   8.035  28.012  1.00 38.36           C  
ATOM    273  C   GLU A  20      11.294   7.683  29.346  1.00 39.48           C  
ATOM    274  O   GLU A  20      12.444   7.207  29.419  1.00 35.22           O  
ATOM    275  CB  GLU A  20      11.118   7.103  26.895  1.00 38.53           C  
ATOM    276  CG  GLU A  20      10.487   5.750  26.928  1.00 39.28           C  
ATOM    277  CD  GLU A  20      10.963   4.837  25.808  1.00 42.36           C  
ATOM    278  OE1 GLU A  20      11.813   5.238  24.990  1.00 44.32           O  
ATOM    279  OE2 GLU A  20      10.491   3.692  25.747  1.00 51.82           O  
ATOM    280  N   GLY A  21      10.572   7.998  30.416  1.00 39.11           N  
ATOM    281  CA  GLY A  21      11.158   7.994  31.747  1.00 40.01           C  
ATOM    282  C   GLY A  21      12.332   8.949  31.820  1.00 40.82           C  
ATOM    283  O   GLY A  21      12.204  10.118  31.464  1.00 42.89           O  
ATOM    284  N   ASP A  22      13.490   8.445  32.243  1.00 38.22           N  
ATOM    285  CA  ASP A  22      14.690   9.278  32.362  1.00 37.92           C  
ATOM    286  C   ASP A  22      15.481   9.389  31.059  1.00 36.81           C  
ATOM    287  O   ASP A  22      16.527   9.983  31.058  1.00 36.18           O  
ATOM    288  CB  ASP A  22      15.584   8.815  33.520  1.00 39.08           C  
ATOM    289  CG  ASP A  22      16.237   7.470  33.287  1.00 39.29           C  
ATOM    290  OD1 ASP A  22      15.916   6.789  32.300  1.00 40.91           O  
ATOM    291  OD2 ASP A  22      17.113   7.101  34.093  1.00 51.71           O  
ATOM    292  N   GLN A  23      14.964   8.826  29.966  1.00 35.12           N  
ATOM    293  CA  GLN A  23      15.618   8.889  28.658  1.00 33.36           C  
ATOM    294  C   GLN A  23      14.993   9.954  27.760  1.00 32.43           C  
ATOM    295  O   GLN A  23      13.854   9.815  27.316  1.00 33.77           O  
ATOM    296  CB  GLN A  23      15.551   7.517  27.968  1.00 34.47           C  
ATOM    297  CG  GLN A  23      16.108   7.488  26.555  1.00 33.56           C  
ATOM    298  CD  GLN A  23      17.595   7.710  26.508  1.00 33.30           C  
ATOM    299  OE1 GLN A  23      18.371   6.889  27.035  1.00 32.11           O  
ATOM    300  NE2 GLN A  23      18.019   8.812  25.861  1.00 32.44           N  
ATOM    301  N   PRO A  24      15.731  11.039  27.483  1.00 34.78           N  
ATOM    302  CA  PRO A  24      15.258  11.977  26.467  1.00 34.56           C  
ATOM    303  C   PRO A  24      15.190  11.315  25.111  1.00 33.93           C  
ATOM    304  O   PRO A  24      16.010  10.466  24.789  1.00 33.19           O  
ATOM    305  CB  PRO A  24      16.307  13.083  26.458  1.00 38.00           C  
ATOM    306  CG  PRO A  24      17.176  12.843  27.620  1.00 38.09           C  
ATOM    307  CD  PRO A  24      16.995  11.460  28.103  1.00 34.96           C  
ATOM    308  N   ARG A  25      14.204  11.732  24.337  1.00 33.43           N  
ATOM    309  CA  ARG A  25      14.013  11.314  22.960  1.00 33.32           C  
ATOM    310  C   ARG A  25      13.789  12.545  22.089  1.00 35.13           C  
ATOM    311  O   ARG A  25      13.141  13.498  22.518  1.00 37.13           O  
ATOM    312  CB  ARG A  25      12.782  10.426  22.871  1.00 33.29           C  
ATOM    313  CG  ARG A  25      12.845   9.121  23.633  1.00 33.54           C  
ATOM    314  CD  ARG A  25      13.921   8.200  23.108  1.00 33.11           C  
ATOM    315  NE  ARG A  25      13.823   6.877  23.693  1.00 34.93           N  
ATOM    316  CZ  ARG A  25      14.706   5.910  23.493  1.00 34.65           C  
ATOM    317  NH1 ARG A  25      15.735   6.103  22.688  1.00 37.32           N  
ATOM    318  NH2 ARG A  25      14.546   4.720  24.065  1.00 39.43           N  
ATOM    319  N   VAL A  26      14.325  12.511  20.870  1.00 35.16           N  
ATOM    320  CA  VAL A  26      14.144  13.584  19.901  1.00 34.46           C  
ATOM    321  C   VAL A  26      14.121  13.038  18.493  1.00 34.06           C  
ATOM    322  O   VAL A  26      14.843  12.085  18.161  1.00 34.14           O  
ATOM    323  CB  VAL A  26      15.221  14.704  20.073  1.00 33.80           C  
ATOM    324  CG1 VAL A  26      16.633  14.188  19.889  1.00 35.08           C  
ATOM    325  CG2 VAL A  26      14.968  15.889  19.144  1.00 37.60           C  
ATOM    326  N   ARG A  27      13.283  13.647  17.667  1.00 33.21           N  
ATOM    327  CA  ARG A  27      13.116  13.226  16.275  1.00 33.16           C  
ATOM    328  C   ARG A  27      12.600  14.400  15.463  1.00 35.69           C  
ATOM    329  O   ARG A  27      12.011  15.313  16.033  1.00 35.42           O  
ATOM    330  CB  ARG A  27      12.156  12.032  16.171  1.00 33.31           C  
ATOM    331  CG  ARG A  27      10.674  12.374  16.238  1.00 33.99           C  
ATOM    332  CD  ARG A  27      10.258  12.697  17.653  1.00 35.07           C  
ATOM    333  NE  ARG A  27      10.284  11.518  18.507  1.00 34.28           N  
ATOM    334  CZ  ARG A  27      10.277  11.506  19.841  1.00 34.33           C  
ATOM    335  NH1 ARG A  27      10.295  12.622  20.548  1.00 35.16           N  
ATOM    336  NH2 ARG A  27      10.214  10.356  20.471  1.00 35.45           N  
ATOM    337  N   PRO A  28      12.826  14.381  14.139  1.00 34.60           N  
ATOM    338  CA  PRO A  28      12.290  15.445  13.293  1.00 35.44           C  
ATOM    339  C   PRO A  28      10.769  15.349  13.138  1.00 35.41           C  
ATOM    340  O   PRO A  28      10.204  14.249  13.022  1.00 37.47           O  
ATOM    341  CB  PRO A  28      12.992  15.219  11.952  1.00 35.24           C  
ATOM    342  CG  PRO A  28      13.396  13.817  11.934  1.00 37.39           C  
ATOM    343  CD  PRO A  28      13.614  13.405  13.358  1.00 34.86           C  
ATOM    344  N   PHE A  29      10.120  16.507  13.206  1.00 36.81           N  
ATOM    345  CA  PHE A  29       8.697  16.682  12.908  1.00 37.07           C  
ATOM    346  C   PHE A  29       8.599  17.766  11.827  1.00 39.32           C  
ATOM    347  O   PHE A  29       9.528  18.542  11.615  1.00 37.13           O  
ATOM    348  CB  PHE A  29       7.919  17.121  14.167  1.00 37.75           C  
ATOM    349  CG  PHE A  29       7.176  16.006  14.873  1.00 38.36           C  
ATOM    350  CD1 PHE A  29       7.725  14.748  15.042  1.00 39.18           C  
ATOM    351  CD2 PHE A  29       5.909  16.236  15.394  1.00 37.49           C  
ATOM    352  CE1 PHE A  29       7.018  13.737  15.697  1.00 42.43           C  
ATOM    353  CE2 PHE A  29       5.233  15.258  16.076  1.00 35.74           C  
ATOM    354  CZ  PHE A  29       5.762  13.993  16.204  1.00 39.74           C  
ATOM    355  N   GLY A  30       7.483  17.854  11.130  1.00 40.11           N  
ATOM    356  CA  GLY A  30       7.443  18.799  10.019  1.00 40.42           C  
ATOM    357  C   GLY A  30       6.100  19.348   9.601  1.00 41.03           C  
ATOM    358  O   GLY A  30       6.006  19.948   8.555  1.00 43.77           O  
ATOM    359  N   ALA A  31       5.078  19.152  10.408  1.00 38.31           N  
ATOM    360  CA  ALA A  31       3.731  19.596  10.027  1.00 40.22           C  
ATOM    361  C   ALA A  31       3.243  20.381  11.212  1.00 40.71           C  
ATOM    362  O   ALA A  31       3.389  19.939  12.354  1.00 44.73           O  
ATOM    363  CB  ALA A  31       2.827  18.414   9.744  1.00 39.52           C  
ATOM    364  N   VAL A  32       2.766  21.582  10.952  1.00 39.44           N  
ATOM    365  CA  VAL A  32       2.101  22.379  11.963  1.00 37.97           C  
ATOM    366  C   VAL A  32       0.948  23.073  11.308  1.00 36.83           C  
ATOM    367  O   VAL A  32       0.985  23.402  10.113  1.00 36.28           O  
ATOM    368  CB  VAL A  32       3.023  23.464  12.643  1.00 39.34           C  
ATOM    369  CG1 VAL A  32       4.022  22.815  13.539  1.00 45.25           C  
ATOM    370  CG2 VAL A  32       3.721  24.339  11.596  1.00 38.18           C  
ATOM    371  N   PHE A  33      -0.098  23.296  12.089  1.00 35.48           N  
ATOM    372  CA  PHE A  33      -1.236  24.071  11.622  1.00 34.10           C  
ATOM    373  C   PHE A  33      -1.907  24.695  12.841  1.00 34.89           C  
ATOM    374  O   PHE A  33      -1.585  24.334  13.986  1.00 35.17           O  
ATOM    375  CB  PHE A  33      -2.226  23.205  10.820  1.00 35.67           C  
ATOM    376  CG  PHE A  33      -2.922  22.157  11.630  1.00 32.30           C  
ATOM    377  CD1 PHE A  33      -2.327  20.931  11.870  1.00 37.40           C  
ATOM    378  CD2 PHE A  33      -4.188  22.393  12.157  1.00 35.77           C  
ATOM    379  CE1 PHE A  33      -2.961  19.965  12.621  1.00 36.79           C  
ATOM    380  CE2 PHE A  33      -4.834  21.417  12.911  1.00 37.03           C  
ATOM    381  CZ  PHE A  33      -4.213  20.208  13.137  1.00 33.84           C  
ATOM    382  N   GLU A  34      -2.790  25.653  12.588  1.00 36.45           N  
ATOM    383  CA  GLU A  34      -3.560  26.285  13.647  1.00 36.61           C  
ATOM    384  C   GLU A  34      -5.036  25.925  13.540  1.00 37.17           C  
ATOM    385  O   GLU A  34      -5.591  25.768  12.433  1.00 36.99           O  
ATOM    386  CB  GLU A  34      -3.391  27.803  13.614  1.00 38.61           C  
ATOM    387  CG  GLU A  34      -4.142  28.504  12.505  1.00 45.39           C  
ATOM    388  CD  GLU A  34      -4.009  30.016  12.564  1.00 42.37           C  
ATOM    389  OE1 GLU A  34      -4.607  30.632  13.477  1.00 46.14           O  
ATOM    390  OE2 GLU A  34      -3.317  30.572  11.681  1.00 42.04           O  
ATOM    391  N   TYR A  35      -5.684  25.839  14.700  1.00 35.66           N  
ATOM    392  CA  TYR A  35      -7.107  25.674  14.760  1.00 36.35           C  
ATOM    393  C   TYR A  35      -7.629  26.258  16.070  1.00 36.78           C  
ATOM    394  O   TYR A  35      -7.095  25.956  17.128  1.00 34.79           O  
ATOM    395  CB  TYR A  35      -7.483  24.201  14.648  1.00 36.53           C  
ATOM    396  CG  TYR A  35      -8.976  23.971  14.601  1.00 38.27           C  
ATOM    397  CD1 TYR A  35      -9.582  23.119  15.497  1.00 41.29           C  
ATOM    398  CD2 TYR A  35      -9.778  24.596  13.652  1.00 42.43           C  
ATOM    399  CE1 TYR A  35     -10.947  22.907  15.471  1.00 42.55           C  
ATOM    400  CE2 TYR A  35     -11.139  24.380  13.613  1.00 36.94           C  
ATOM    401  CZ  TYR A  35     -11.718  23.541  14.528  1.00 39.88           C  
ATOM    402  OH  TYR A  35     -13.078  23.301  14.523  1.00 42.69           O  
ATOM    403  N   GLU A  36      -8.681  27.075  15.981  1.00 38.26           N  
ATOM    404  CA  GLU A  36      -9.264  27.762  17.150  1.00 38.39           C  
ATOM    405  C   GLU A  36      -8.216  28.437  18.036  1.00 37.69           C  
ATOM    406  O   GLU A  36      -8.298  28.373  19.269  1.00 35.77           O  
ATOM    407  CB  GLU A  36     -10.072  26.783  17.998  1.00 38.99           C  
ATOM    408  CG  GLU A  36     -11.248  26.170  17.293  1.00 40.69           C  
ATOM    409  CD  GLU A  36     -11.802  24.960  18.050  1.00 43.44           C  
ATOM    410  OE1 GLU A  36     -11.049  24.344  18.855  1.00 44.28           O  
ATOM    411  OE2 GLU A  36     -12.975  24.627  17.813  1.00 46.01           O  
ATOM    412  N   GLY A  37      -7.208  29.051  17.413  1.00 36.79           N  
ATOM    413  CA  GLY A  37      -6.189  29.789  18.144  1.00 36.67           C  
ATOM    414  C   GLY A  37      -5.099  28.952  18.793  1.00 37.66           C  
ATOM    415  O   GLY A  37      -4.275  29.494  19.527  1.00 37.57           O  
ATOM    416  N   LYS A  38      -5.095  27.644  18.521  1.00 37.19           N  
ATOM    417  CA  LYS A  38      -4.129  26.705  19.094  1.00 35.95           C  
ATOM    418  C   LYS A  38      -3.157  26.192  18.031  1.00 35.52           C  
ATOM    419  O   LYS A  38      -3.502  26.048  16.853  1.00 34.74           O  
ATOM    420  CB  LYS A  38      -4.846  25.508  19.732  1.00 36.85           C  
ATOM    421  CG  LYS A  38      -5.873  25.854  20.802  1.00 35.74           C  
ATOM    422  CD  LYS A  38      -5.237  26.493  22.024  1.00 40.77           C  
ATOM    423  CE  LYS A  38      -6.245  26.707  23.130  1.00 44.80           C  
ATOM    424  NZ  LYS A  38      -5.857  27.795  24.075  1.00 49.80           N  
ATOM    425  N   LEU A  39      -1.945  25.908  18.480  1.00 35.06           N  
ATOM    426  CA  LEU A  39      -0.897  25.360  17.641  1.00 34.35           C  
ATOM    427  C   LEU A  39      -0.908  23.837  17.718  1.00 34.80           C  
ATOM    428  O   LEU A  39      -0.733  23.248  18.805  1.00 34.10           O  
ATOM    429  CB  LEU A  39       0.463  25.900  18.090  1.00 35.97           C  
ATOM    430  CG  LEU A  39       1.671  25.349  17.324  1.00 33.78           C  
ATOM    431  CD1 LEU A  39       1.673  25.827  15.879  1.00 39.79           C  
ATOM    432  CD2 LEU A  39       2.970  25.699  18.024  1.00 37.16           C  
ATOM    433  N   TYR A  40      -1.094  23.207  16.561  1.00 33.44           N  
ATOM    434  CA  TYR A  40      -1.164  21.750  16.457  1.00 33.42           C  
ATOM    435  C   TYR A  40       0.047  21.151  15.745  1.00 34.93           C  
ATOM    436  O   TYR A  40       0.600  21.763  14.827  1.00 33.96           O  
ATOM    437  CB  TYR A  40      -2.401  21.325  15.659  1.00 35.50           C  
ATOM    438  CG  TYR A  40      -3.698  21.385  16.438  1.00 35.23           C  
ATOM    439  CD1 TYR A  40      -4.361  22.589  16.606  1.00 36.04           C  
ATOM    440  CD2 TYR A  40      -4.261  20.226  16.990  1.00 33.94           C  
ATOM    441  CE1 TYR A  40      -5.557  22.652  17.307  1.00 33.97           C  
ATOM    442  CE2 TYR A  40      -5.435  20.283  17.698  1.00 38.02           C  
ATOM    443  CZ  TYR A  40      -6.080  21.499  17.852  1.00 36.15           C  
ATOM    444  OH  TYR A  40      -7.279  21.562  18.526  1.00 35.92           O  
ATOM    445  N   ILE A  41       0.415  19.953  16.199  1.00 34.42           N  
ATOM    446  CA  ILE A  41       1.341  19.044  15.542  1.00 36.17           C  
ATOM    447  C   ILE A  41       0.576  17.760  15.254  1.00 35.72           C  
ATOM    448  O   ILE A  41      -0.536  17.578  15.753  1.00 35.53           O  
ATOM    449  CB  ILE A  41       2.588  18.774  16.406  1.00 36.04           C  
ATOM    450  CG1 ILE A  41       2.228  18.172  17.778  1.00 35.99           C  
ATOM    451  CG2 ILE A  41       3.351  20.083  16.576  1.00 37.27           C  
ATOM    452  CD1 ILE A  41       3.386  17.706  18.623  1.00 41.60           C  
ATOM    453  N   VAL A  42       1.140  16.891  14.426  1.00 34.47           N  
ATOM    454  CA  VAL A  42       0.461  15.664  14.077  1.00 35.12           C  
ATOM    455  C   VAL A  42       1.365  14.487  14.369  1.00 35.10           C  
ATOM    456  O   VAL A  42       2.600  14.604  14.381  1.00 35.14           O  
ATOM    457  CB  VAL A  42      -0.033  15.651  12.580  1.00 36.72           C  
ATOM    458  CG1 VAL A  42      -0.803  16.918  12.249  1.00 40.65           C  
ATOM    459  CG2 VAL A  42       1.110  15.468  11.614  1.00 40.75           C  
ATOM    460  N   SER A  43       0.747  13.346  14.617  1.00 33.34           N  
ATOM    461  CA  SER A  43       1.471  12.103  14.752  1.00 35.23           C  
ATOM    462  C   SER A  43       0.525  10.929  14.482  1.00 35.84           C  
ATOM    463  O   SER A  43      -0.466  11.064  13.793  1.00 36.90           O  
ATOM    464  CB  SER A  43       2.158  11.985  16.136  1.00 38.57           C  
ATOM    465  OG  SER A  43       3.266  11.099  16.070  1.00 40.97           O  
ATOM    466  N   ASN A  44       0.915   9.778  14.992  1.00 36.67           N  
ATOM    467  CA  ASN A  44       0.307   8.476  14.711  1.00 39.22           C  
ATOM    468  C   ASN A  44       0.222   7.777  16.075  1.00 37.65           C  
ATOM    469  O   ASN A  44       1.237   7.684  16.771  1.00 35.98           O  
ATOM    470  CB  ASN A  44       1.322   7.825  13.764  1.00 45.63           C  
ATOM    471  CG  ASN A  44       1.121   6.387  13.521  1.00 40.15           C  
ATOM    472  OD1 ASN A  44       0.634   5.646  14.350  1.00 39.77           O  
ATOM    473  ND2 ASN A  44       1.593   5.955  12.368  1.00 45.59           N  
ATOM    474  N   ASN A  45      -0.960   7.298  16.450  1.00 36.46           N  
ATOM    475  CA  ASN A  45      -1.170   6.775  17.804  1.00 38.43           C  
ATOM    476  C   ASN A  45      -0.516   5.427  18.085  1.00 37.00           C  
ATOM    477  O   ASN A  45      -0.594   4.921  19.204  1.00 37.06           O  
ATOM    478  CB  ASN A  45      -2.652   6.756  18.175  1.00 39.84           C  
ATOM    479  CG  ASN A  45      -3.476   5.834  17.289  1.00 39.01           C  
ATOM    480  OD1 ASN A  45      -2.973   4.839  16.757  1.00 35.77           O  
ATOM    481  ND2 ASN A  45      -4.747   6.177  17.115  1.00 39.20           N  
ATOM    482  N   THR A  46       0.151   4.861  17.079  1.00 35.21           N  
ATOM    483  CA  THR A  46       0.920   3.641  17.250  1.00 37.32           C  
ATOM    484  C   THR A  46       2.390   3.914  17.554  1.00 36.86           C  
ATOM    485  O   THR A  46       3.115   2.994  17.891  1.00 38.82           O  
ATOM    486  CB  THR A  46       0.839   2.728  15.992  1.00 38.83           C  
ATOM    487  OG1 THR A  46       1.550   3.321  14.894  1.00 40.89           O  
ATOM    488  CG2 THR A  46      -0.609   2.474  15.602  1.00 40.62           C  
ATOM    489  N   LYS A  47       2.837   5.161  17.417  1.00 38.12           N  
ATOM    490  CA  LYS A  47       4.261   5.493  17.550  1.00 39.91           C  
ATOM    491  C   LYS A  47       4.690   5.728  18.991  1.00 38.16           C  
ATOM    492  O   LYS A  47       3.907   6.209  19.817  1.00 36.97           O  
ATOM    493  CB  LYS A  47       4.594   6.761  16.768  1.00 41.56           C  
ATOM    494  CG  LYS A  47       4.511   6.629  15.260  1.00 42.94           C  
ATOM    495  CD  LYS A  47       4.951   7.968  14.664  1.00 44.29           C  
ATOM    496  CE  LYS A  47       4.895   8.028  13.152  1.00 48.70           C  
ATOM    497  NZ  LYS A  47       5.530   9.300  12.672  1.00 44.42           N  
ATOM    498  N   LYS A  48       5.956   5.425  19.278  1.00 35.81           N  
ATOM    499  CA  LYS A  48       6.532   5.677  20.591  1.00 36.62           C  
ATOM    500  C   LYS A  48       6.431   7.159  20.982  1.00 35.06           C  
ATOM    501  O   LYS A  48       6.137   7.484  22.133  1.00 34.96           O  
ATOM    502  CB  LYS A  48       8.014   5.209  20.649  1.00 37.48           C  
ATOM    503  CG  LYS A  48       8.183   3.697  20.588  1.00 37.66           C  
ATOM    504  CD  LYS A  48       9.663   3.253  20.610  1.00 40.10           C  
ATOM    505  N   CYS A  49       6.665   8.054  20.034  1.00 34.89           N  
ATOM    506  CA  CYS A  49       6.625   9.480  20.331  0.70 34.58           C  
ATOM    508  C   CYS A  49       5.242   9.901  20.842  1.00 35.73           C  
ATOM    509  O   CYS A  49       5.149  10.672  21.789  1.00 34.59           O  
ATOM    510  CB  CYS A  49       7.069  10.337  19.136  0.70 36.21           C  
ATOM    512  SG  CYS A  49       6.069  10.229  17.626  0.70 36.06           S  
ATOM    514  N   PHE A  50       4.186   9.374  20.231  1.00 33.07           N  
ATOM    515  CA  PHE A  50       2.824   9.669  20.669  1.00 33.84           C  
ATOM    516  C   PHE A  50       2.593   9.142  22.084  1.00 35.21           C  
ATOM    517  O   PHE A  50       2.102   9.848  22.964  1.00 35.49           O  
ATOM    518  CB  PHE A  50       1.808   9.020  19.732  1.00 34.38           C  
ATOM    519  CG  PHE A  50       0.389   9.249  20.151  1.00 34.10           C  
ATOM    520  CD1 PHE A  50      -0.257  10.420  19.807  1.00 36.20           C  
ATOM    521  CD2 PHE A  50      -0.293   8.315  20.895  1.00 35.65           C  
ATOM    522  CE1 PHE A  50      -1.549  10.643  20.205  1.00 34.73           C  
ATOM    523  CE2 PHE A  50      -1.602   8.543  21.308  1.00 35.87           C  
ATOM    524  CZ  PHE A  50      -2.226   9.707  20.957  1.00 35.03           C  
ATOM    525  N   LYS A  51       2.968   7.889  22.313  1.00 35.60           N  
ATOM    526  CA  LYS A  51       2.753   7.265  23.614  1.00 36.27           C  
ATOM    527  C   LYS A  51       3.518   8.047  24.696  1.00 35.99           C  
ATOM    528  O   LYS A  51       3.030   8.230  25.820  1.00 35.45           O  
ATOM    529  CB  LYS A  51       3.188   5.801  23.573  1.00 37.31           C  
ATOM    530  CG  LYS A  51       2.305   4.955  22.659  1.00 41.52           C  
ATOM    531  CD  LYS A  51       2.922   3.614  22.268  1.00 43.03           C  
ATOM    532  CE  LYS A  51       1.914   2.808  21.439  1.00 47.57           C  
ATOM    533  NZ  LYS A  51       2.451   1.501  20.957  1.00 54.06           N  
ATOM    534  N   GLN A  52       4.700   8.524  24.344  1.00 34.83           N  
ATOM    535  CA  GLN A  52       5.502   9.345  25.272  1.00 34.72           C  
ATOM    536  C   GLN A  52       4.787  10.640  25.628  1.00 34.69           C  
ATOM    537  O   GLN A  52       4.823  11.069  26.778  1.00 36.42           O  
ATOM    538  CB  GLN A  52       6.887   9.621  24.686  1.00 36.90           C  
ATOM    539  CG  GLN A  52       7.756   8.355  24.667  1.00 33.65           C  
ATOM    540  CD  GLN A  52       8.892   8.405  23.689  1.00 34.58           C  
ATOM    541  OE1 GLN A  52       9.287   9.470  23.211  1.00 35.19           O  
ATOM    542  NE2 GLN A  52       9.442   7.227  23.376  1.00 34.46           N  
HETATM  543  N   MSE A  53       4.117  11.252  24.644  1.00 34.18           N  
HETATM  544  CA  MSE A  53       3.433  12.547  24.873  1.00 34.47           C  
HETATM  545  C   MSE A  53       2.183  12.374  25.718  1.00 36.42           C  
HETATM  546  O   MSE A  53       1.779  13.299  26.433  1.00 36.41           O  
HETATM  547  CB  MSE A  53       3.088  13.220  23.555  1.00 37.45           C  
HETATM  548  CG  MSE A  53       4.321  13.791  22.846  1.00 34.72           C  
HETATM  549 SE   MSE A  53       3.841  14.782  21.256  0.70 35.79          SE  
HETATM  550  CE  MSE A  53       3.398  13.460  20.131  1.00 38.56           C  
ATOM    551  N   ILE A  54       1.570  11.193  25.624  1.00 36.47           N  
ATOM    552  CA  ILE A  54       0.420  10.842  26.479  1.00 36.30           C  
ATOM    553  C   ILE A  54       0.895  10.600  27.903  1.00 37.56           C  
ATOM    554  O   ILE A  54       0.291  11.104  28.850  1.00 36.39           O  
ATOM    555  CB  ILE A  54      -0.329   9.614  25.940  1.00 36.81           C  
ATOM    556  CG1 ILE A  54      -0.869   9.881  24.528  1.00 35.46           C  
ATOM    557  CG2 ILE A  54      -1.462   9.203  26.886  1.00 37.83           C  
ATOM    558  CD1 ILE A  54      -1.682  11.171  24.390  1.00 41.51           C  
ATOM    559  N   GLN A  55       1.995   9.868  28.054  1.00 35.31           N  
ATOM    560  CA  GLN A  55       2.513   9.512  29.365  1.00 35.65           C  
ATOM    561  C   GLN A  55       3.102  10.731  30.094  1.00 37.11           C  
ATOM    562  O   GLN A  55       2.979  10.841  31.312  1.00 38.87           O  
ATOM    563  CB  GLN A  55       3.525   8.352  29.227  1.00 36.33           C  
ATOM    564  CG  GLN A  55       4.315   7.979  30.466  1.00 41.39           C  
ATOM    565  CD  GLN A  55       3.446   7.482  31.588  1.00 52.55           C  
ATOM    566  OE1 GLN A  55       2.297   7.054  31.373  1.00 54.15           O  
ATOM    567  NE2 GLN A  55       3.992   7.511  32.803  1.00 56.43           N  
ATOM    568  N   ASN A  56       3.711  11.643  29.342  1.00 34.69           N  
ATOM    569  CA  ASN A  56       4.293  12.885  29.887  1.00 34.56           C  
ATOM    570  C   ASN A  56       4.070  13.994  28.882  1.00 34.14           C  
ATOM    571  O   ASN A  56       4.728  14.019  27.843  1.00 34.31           O  
ATOM    572  CB  ASN A  56       5.780  12.720  30.171  1.00 36.20           C  
ATOM    573  CG  ASN A  56       6.418  13.986  30.758  1.00 37.11           C  
ATOM    574  OD1 ASN A  56       5.759  15.015  30.936  1.00 39.08           O  
ATOM    575  ND2 ASN A  56       7.709  13.894  31.078  1.00 36.08           N  
ATOM    576  N   PRO A  57       3.106  14.885  29.155  1.00 34.92           N  
ATOM    577  CA  PRO A  57       2.736  15.922  28.202  1.00 36.41           C  
ATOM    578  C   PRO A  57       3.782  17.014  28.015  1.00 35.27           C  
ATOM    579  O   PRO A  57       3.653  17.814  27.100  1.00 34.41           O  
ATOM    580  CB  PRO A  57       1.459  16.510  28.807  1.00 35.92           C  
ATOM    581  CG  PRO A  57       1.577  16.263  30.216  1.00 40.85           C  
ATOM    582  CD  PRO A  57       2.261  14.944  30.361  1.00 38.39           C  
ATOM    583  N   LYS A  58       4.808  17.053  28.853  1.00 35.40           N  
ATOM    584  CA  LYS A  58       5.834  18.067  28.721  1.00 33.63           C  
ATOM    585  C   LYS A  58       6.741  17.737  27.556  1.00 34.66           C  
ATOM    586  O   LYS A  58       7.330  16.638  27.483  1.00 35.20           O  
ATOM    587  CB  LYS A  58       6.678  18.157  29.978  1.00 34.51           C  
ATOM    588  CG  LYS A  58       5.955  18.695  31.157  1.00 33.35           C  
ATOM    589  CD  LYS A  58       6.882  18.800  32.348  1.00 36.52           C  
ATOM    590  CE  LYS A  58       6.147  19.325  33.556  1.00 39.73           C  
ATOM    591  NZ  LYS A  58       7.100  19.639  34.652  1.00 40.27           N  
ATOM    592  N   VAL A  59       6.890  18.718  26.672  1.00 34.87           N  
ATOM    593  CA  VAL A  59       7.756  18.603  25.519  1.00 33.92           C  
ATOM    594  C   VAL A  59       8.597  19.860  25.324  1.00 34.32           C  
ATOM    595  O   VAL A  59       8.343  20.894  25.941  1.00 34.65           O  
ATOM    596  CB  VAL A  59       6.919  18.345  24.236  1.00 32.50           C  
ATOM    597  CG1 VAL A  59       6.023  17.147  24.425  1.00 36.78           C  
ATOM    598  CG2 VAL A  59       6.090  19.598  23.847  1.00 33.42           C  
ATOM    599  N   GLU A  60       9.609  19.766  24.464  1.00 35.23           N  
ATOM    600  CA  GLU A  60      10.268  20.962  23.944  1.00 34.37           C  
ATOM    601  C   GLU A  60      10.514  20.788  22.446  1.00 34.41           C  
ATOM    602  O   GLU A  60      10.811  19.687  21.986  1.00 33.89           O  
ATOM    603  CB  GLU A  60      11.538  21.292  24.743  1.00 34.25           C  
ATOM    604  CG  GLU A  60      12.193  22.638  24.372  1.00 35.59           C  
ATOM    605  CD  GLU A  60      13.172  23.143  25.431  1.00 36.53           C  
ATOM    606  OE1 GLU A  60      12.727  23.826  26.390  1.00 39.94           O  
ATOM    607  OE2 GLU A  60      14.387  22.854  25.320  1.00 39.45           O  
ATOM    608  N   ILE A  61      10.365  21.882  21.696  1.00 35.27           N  
ATOM    609  CA  ILE A  61      10.660  21.914  20.272  1.00 35.83           C  
ATOM    610  C   ILE A  61      11.810  22.874  19.990  1.00 33.85           C  
ATOM    611  O   ILE A  61      11.880  23.964  20.567  1.00 34.97           O  
ATOM    612  CB  ILE A  61       9.401  22.341  19.480  1.00 36.58           C  
ATOM    613  CG1 ILE A  61       8.382  21.173  19.478  1.00 37.61           C  
ATOM    614  CG2 ILE A  61       9.768  22.778  18.071  1.00 37.72           C  
ATOM    615  CD1 ILE A  61       7.073  21.471  18.811  1.00 38.77           C  
ATOM    616  N   SER A  62      12.720  22.485  19.095  1.00 34.06           N  
ATOM    617  CA  SER A  62      13.699  23.414  18.578  1.00 34.86           C  
ATOM    618  C   SER A  62      13.860  23.244  17.074  1.00 34.52           C  
ATOM    619  O   SER A  62      13.553  22.189  16.504  1.00 35.80           O  
ATOM    620  CB  SER A  62      15.030  23.262  19.321  1.00 34.40           C  
ATOM    621  OG  SER A  62      15.960  24.238  18.884  1.00 36.63           O  
ATOM    622  N   GLY A  63      14.243  24.335  16.416  1.00 35.07           N  
ATOM    623  CA  GLY A  63      14.459  24.329  14.998  1.00 35.75           C  
ATOM    624  C   GLY A  63      15.153  25.608  14.562  1.00 35.60           C  
ATOM    625  O   GLY A  63      15.265  26.542  15.357  1.00 35.21           O  
HETATM  626  N   MSE A  64      15.645  25.617  13.324  1.00 36.25           N  
HETATM  627  CA  MSE A  64      16.438  26.723  12.784  1.00 36.72           C  
HETATM  628  C   MSE A  64      15.974  27.064  11.365  1.00 36.48           C  
HETATM  629  O   MSE A  64      15.634  26.185  10.586  1.00 37.48           O  
HETATM  630  CB  MSE A  64      17.921  26.348  12.767  1.00 36.07           C  
HETATM  631  CG  MSE A  64      18.846  27.442  12.303  1.00 36.67           C  
HETATM  632 SE   MSE A  64      20.693  26.851  12.243  0.70 37.65          SE  
HETATM  633  CE  MSE A  64      20.808  26.699  14.088  1.00 41.71           C  
ATOM    634  N   ASN A  65      16.015  28.343  11.016  1.00 35.79           N  
ATOM    635  CA  ASN A  65      15.619  28.767   9.673  1.00 35.43           C  
ATOM    636  C   ASN A  65      16.866  29.041   8.828  1.00 37.48           C  
ATOM    637  O   ASN A  65      17.965  28.826   9.293  1.00 35.22           O  
ATOM    638  CB  ASN A  65      14.649  29.938   9.722  1.00 35.61           C  
ATOM    639  CG  ASN A  65      15.267  31.232  10.209  1.00 39.14           C  
ATOM    640  OD1 ASN A  65      16.485  31.375  10.313  1.00 37.11           O  
ATOM    641  ND2 ASN A  65      14.400  32.210  10.494  1.00 40.60           N  
ATOM    642  N   LYS A  66      16.687  29.500   7.592  1.00 38.88           N  
ATOM    643  CA  LYS A  66      17.809  29.626   6.647  1.00 41.55           C  
ATOM    644  C   LYS A  66      18.807  30.712   7.029  1.00 42.99           C  
ATOM    645  O   LYS A  66      19.987  30.636   6.663  1.00 42.75           O  
ATOM    646  CB  LYS A  66      17.275  29.840   5.224  1.00 42.60           C  
ATOM    647  CG  LYS A  66      16.557  28.614   4.702  1.00 47.10           C  
ATOM    648  N   LYS A  67      18.351  31.686   7.809  1.00 42.64           N  
ATOM    649  CA  LYS A  67      19.201  32.749   8.316  1.00 43.63           C  
ATOM    650  C   LYS A  67      19.965  32.353   9.579  1.00 41.12           C  
ATOM    651  O   LYS A  67      20.678  33.176  10.154  1.00 41.27           O  
ATOM    652  CB  LYS A  67      18.347  33.995   8.628  1.00 46.13           C  
ATOM    653  CG  LYS A  67      17.489  34.497   7.474  1.00 50.60           C  
ATOM    654  N   GLY A  68      19.785  31.131  10.070  1.00 39.61           N  
ATOM    655  CA  GLY A  68      20.452  30.720  11.309  1.00 39.75           C  
ATOM    656  C   GLY A  68      19.752  31.155  12.603  1.00 38.96           C  
ATOM    657  O   GLY A  68      20.295  30.998  13.690  1.00 40.82           O  
ATOM    658  N   GLN A  69      18.556  31.710  12.507  1.00 38.13           N  
ATOM    659  CA  GLN A  69      17.779  32.014  13.704  1.00 35.87           C  
ATOM    660  C   GLN A  69      17.186  30.709  14.196  1.00 35.76           C  
ATOM    661  O   GLN A  69      16.881  29.811  13.399  1.00 35.15           O  
ATOM    662  CB  GLN A  69      16.636  32.965  13.407  1.00 36.63           C  
ATOM    663  CG  GLN A  69      16.988  34.295  12.797  1.00 38.89           C  
ATOM    664  CD  GLN A  69      15.727  35.116  12.586  1.00 41.70           C  
ATOM    665  OE1 GLN A  69      14.817  34.704  11.852  1.00 45.01           O  
ATOM    666  NE2 GLN A  69      15.638  36.257  13.261  1.00 53.85           N  
ATOM    667  N   TRP A  70      17.023  30.583  15.505  1.00 35.13           N  
ATOM    668  CA  TRP A  70      16.469  29.351  16.037  1.00 33.79           C  
ATOM    669  C   TRP A  70      15.447  29.585  17.143  1.00 33.20           C  
ATOM    670  O   TRP A  70      15.413  30.642  17.771  1.00 34.47           O  
ATOM    671  CB  TRP A  70      17.583  28.410  16.474  1.00 36.73           C  
ATOM    672  CG  TRP A  70      18.306  28.774  17.708  1.00 40.15           C  
ATOM    673  CD1 TRP A  70      18.075  28.291  18.960  1.00 44.74           C  
ATOM    674  CD2 TRP A  70      19.426  29.635  17.807  1.00 43.15           C  
ATOM    675  NE1 TRP A  70      18.970  28.820  19.840  1.00 47.14           N  
ATOM    676  CE2 TRP A  70      19.815  29.654  19.161  1.00 46.11           C  
ATOM    677  CE3 TRP A  70      20.136  30.403  16.883  1.00 42.95           C  
ATOM    678  CZ2 TRP A  70      20.881  30.409  19.618  1.00 45.82           C  
ATOM    679  CZ3 TRP A  70      21.209  31.162  17.335  1.00 47.52           C  
ATOM    680  CH2 TRP A  70      21.568  31.157  18.696  1.00 47.99           C  
ATOM    681  N   ILE A  71      14.592  28.598  17.332  1.00 33.29           N  
ATOM    682  CA  ILE A  71      13.536  28.674  18.328  1.00 33.19           C  
ATOM    683  C   ILE A  71      13.729  27.608  19.399  1.00 35.67           C  
ATOM    684  O   ILE A  71      14.268  26.518  19.142  1.00 34.18           O  
ATOM    685  CB  ILE A  71      12.140  28.519  17.672  1.00 34.01           C  
ATOM    686  CG1 ILE A  71      11.007  28.770  18.680  1.00 34.19           C  
ATOM    687  CG2 ILE A  71      11.975  27.139  17.004  1.00 33.04           C  
ATOM    688  CD1 ILE A  71       9.690  29.007  18.022  1.00 35.06           C  
ATOM    689  N   ARG A  72      13.293  27.926  20.611  1.00 35.41           N  
ATOM    690  CA  ARG A  72      13.062  26.899  21.601  1.00 36.27           C  
ATOM    691  C   ARG A  72      11.682  27.120  22.178  1.00 33.97           C  
ATOM    692  O   ARG A  72      11.376  28.183  22.669  1.00 35.94           O  
ATOM    693  CB  ARG A  72      14.142  26.903  22.659  1.00 37.01           C  
ATOM    694  CG  ARG A  72      15.456  26.341  22.055  1.00 43.00           C  
ATOM    695  CD  ARG A  72      16.515  26.208  23.077  1.00 45.36           C  
ATOM    696  NE  ARG A  72      16.268  25.161  24.055  1.00 40.47           N  
ATOM    697  CZ  ARG A  72      16.939  25.087  25.201  1.00 42.90           C  
ATOM    698  NH1 ARG A  72      17.838  26.018  25.481  1.00 44.43           N  
ATOM    699  NH2 ARG A  72      16.716  24.124  26.069  1.00 42.63           N  
ATOM    700  N   LEU A  73      10.838  26.112  22.071  1.00 32.71           N  
ATOM    701  CA  LEU A  73       9.446  26.246  22.491  1.00 33.27           C  
ATOM    702  C   LEU A  73       9.204  25.137  23.502  1.00 34.62           C  
ATOM    703  O   LEU A  73       9.233  23.962  23.165  1.00 35.30           O  
ATOM    704  CB  LEU A  73       8.520  26.126  21.280  1.00 33.27           C  
ATOM    705  CG  LEU A  73       7.020  26.030  21.506  1.00 37.98           C  
ATOM    706  CD1 LEU A  73       6.539  27.246  22.255  1.00 42.98           C  
ATOM    707  CD2 LEU A  73       6.271  25.891  20.179  1.00 43.17           C  
ATOM    708  N   THR A  74       8.982  25.533  24.746  1.00 35.32           N  
ATOM    709  CA  THR A  74       8.718  24.617  25.840  1.00 34.69           C  
ATOM    710  C   THR A  74       7.218  24.614  26.117  1.00 36.37           C  
ATOM    711  O   THR A  74       6.610  25.673  26.146  1.00 36.48           O  
ATOM    712  CB  THR A  74       9.454  25.112  27.103  1.00 33.11           C  
ATOM    713  OG1 THR A  74      10.824  25.403  26.782  1.00 37.47           O  
ATOM    714  CG2 THR A  74       9.397  24.075  28.214  1.00 37.05           C  
ATOM    715  N   GLY A  75       6.614  23.447  26.334  1.00 33.57           N  
ATOM    716  CA  GLY A  75       5.199  23.445  26.686  1.00 35.11           C  
ATOM    717  C   GLY A  75       4.622  22.081  26.971  1.00 33.39           C  
ATOM    718  O   GLY A  75       5.355  21.111  27.164  1.00 34.28           O  
ATOM    719  N   GLU A  76       3.298  22.022  26.974  1.00 34.43           N  
ATOM    720  CA  GLU A  76       2.565  20.777  27.165  1.00 34.66           C  
ATOM    721  C   GLU A  76       1.598  20.552  26.017  1.00 35.44           C  
ATOM    722  O   GLU A  76       1.006  21.494  25.494  1.00 34.72           O  
ATOM    723  CB  GLU A  76       1.812  20.811  28.482  1.00 35.69           C  
ATOM    724  CG  GLU A  76       2.733  20.692  29.670  1.00 38.00           C  
ATOM    725  CD  GLU A  76       2.032  20.467  31.009  1.00 41.76           C  
ATOM    726  OE1 GLU A  76       0.804  20.196  31.054  1.00 44.16           O  
ATOM    727  OE2 GLU A  76       2.740  20.554  32.030  1.00 43.97           O  
ATOM    728  N   VAL A  77       1.427  19.296  25.639  1.00 33.35           N  
ATOM    729  CA  VAL A  77       0.529  18.956  24.538  1.00 34.02           C  
ATOM    730  C   VAL A  77      -0.610  18.090  25.036  1.00 34.73           C  
ATOM    731  O   VAL A  77      -0.468  17.373  26.030  1.00 32.68           O  
ATOM    732  CB  VAL A  77       1.288  18.287  23.364  1.00 36.85           C  
ATOM    733  CG1 VAL A  77       2.317  19.253  22.783  1.00 38.15           C  
ATOM    734  CG2 VAL A  77       1.983  17.022  23.820  1.00 36.97           C  
ATOM    735  N   ALA A  78      -1.746  18.191  24.339  1.00 34.18           N  
ATOM    736  CA  ALA A  78      -2.914  17.364  24.590  1.00 34.43           C  
ATOM    737  C   ALA A  78      -3.369  16.786  23.259  1.00 34.41           C  
ATOM    738  O   ALA A  78      -3.402  17.479  22.256  1.00 36.74           O  
ATOM    739  CB  ALA A  78      -4.007  18.187  25.204  1.00 35.29           C  
ATOM    740  N   ASN A  79      -3.685  15.502  23.254  1.00 33.90           N  
ATOM    741  CA  ASN A  79      -4.313  14.866  22.119  1.00 34.00           C  
ATOM    742  C   ASN A  79      -5.758  15.367  21.931  1.00 34.79           C  
ATOM    743  O   ASN A  79      -6.507  15.409  22.873  1.00 35.17           O  
ATOM    744  CB  ASN A  79      -4.322  13.353  22.337  1.00 35.45           C  
ATOM    745  CG  ASN A  79      -4.885  12.617  21.166  1.00 35.24           C  
ATOM    746  OD1 ASN A  79      -4.430  12.816  20.047  1.00 38.86           O  
ATOM    747  ND2 ASN A  79      -5.947  11.846  21.394  1.00 44.87           N  
ATOM    748  N   ASP A  80      -6.130  15.734  20.709  1.00 34.16           N  
ATOM    749  CA  ASP A  80      -7.494  16.238  20.414  1.00 34.20           C  
ATOM    750  C   ASP A  80      -8.177  15.178  19.546  1.00 34.14           C  
ATOM    751  O   ASP A  80      -7.802  14.974  18.399  1.00 34.74           O  
ATOM    752  CB  ASP A  80      -7.385  17.590  19.689  1.00 33.68           C  
ATOM    753  CG  ASP A  80      -8.722  18.277  19.496  1.00 34.29           C  
ATOM    754  OD1 ASP A  80      -9.760  17.620  19.597  1.00 32.83           O  
ATOM    755  OD2 ASP A  80      -8.734  19.495  19.229  1.00 35.86           O  
ATOM    756  N   ASP A  81      -9.163  14.496  20.110  1.00 31.70           N  
ATOM    757  CA  ASP A  81      -9.831  13.370  19.439  1.00 34.06           C  
ATOM    758  C   ASP A  81     -10.979  13.760  18.509  1.00 35.73           C  
ATOM    759  O   ASP A  81     -11.664  12.883  18.015  1.00 38.46           O  
ATOM    760  CB  ASP A  81     -10.391  12.402  20.489  1.00 37.88           C  
ATOM    761  CG  ASP A  81      -9.394  11.354  20.937  1.00 45.47           C  
ATOM    762  OD1 ASP A  81      -8.440  11.042  20.190  1.00 48.27           O  
ATOM    763  OD2 ASP A  81      -9.609  10.797  22.045  1.00 56.30           O  
ATOM    764  N   ARG A  82     -11.240  15.052  18.333  1.00 34.74           N  
ATOM    765  CA  ARG A  82     -12.332  15.510  17.480  1.00 35.91           C  
ATOM    766  C   ARG A  82     -12.071  15.233  16.012  1.00 35.59           C  
ATOM    767  O   ARG A  82     -11.052  15.636  15.459  1.00 34.68           O  
ATOM    768  CB  ARG A  82     -12.553  17.003  17.644  1.00 35.95           C  
ATOM    769  CG  ARG A  82     -13.075  17.406  18.992  1.00 37.87           C  
ATOM    770  CD  ARG A  82     -13.308  18.899  19.016  1.00 38.62           C  
ATOM    771  NE  ARG A  82     -12.059  19.634  18.931  1.00 36.75           N  
ATOM    772  CZ  ARG A  82     -11.961  20.953  18.822  1.00 37.77           C  
ATOM    773  NH1 ARG A  82     -13.060  21.700  18.763  1.00 39.39           N  
ATOM    774  NH2 ARG A  82     -10.776  21.522  18.772  1.00 36.79           N  
ATOM    775  N   ARG A  83     -13.037  14.590  15.369  1.00 36.89           N  
ATOM    776  CA  ARG A  83     -12.926  14.241  13.964  1.00 38.03           C  
ATOM    777  C   ARG A  83     -12.704  15.471  13.088  1.00 37.34           C  
ATOM    778  O   ARG A  83     -11.922  15.415  12.126  1.00 37.09           O  
ATOM    779  CB  ARG A  83     -14.181  13.491  13.521  1.00 37.57           C  
ATOM    780  CG  ARG A  83     -14.067  12.794  12.198  1.00 39.38           C  
ATOM    781  CD  ARG A  83     -15.339  11.968  11.940  1.00 44.40           C  
ATOM    782  NE  ARG A  83     -15.245  11.145  10.739  1.00 47.39           N  
ATOM    783  CZ  ARG A  83     -15.395  11.609   9.500  1.00 53.99           C  
ATOM    784  NH1 ARG A  83     -15.641  12.899   9.274  1.00 55.93           N  
ATOM    785  NH2 ARG A  83     -15.303  10.778   8.472  1.00 54.73           N  
ATOM    786  N   GLU A  84     -13.372  16.575  13.433  1.00 37.26           N  
ATOM    787  CA  GLU A  84     -13.296  17.824  12.658  1.00 40.26           C  
ATOM    788  C   GLU A  84     -11.865  18.383  12.594  1.00 38.11           C  
ATOM    789  O   GLU A  84     -11.472  19.008  11.609  1.00 38.23           O  
ATOM    790  CB  GLU A  84     -14.251  18.901  13.229  1.00 39.46           C  
ATOM    791  CG  GLU A  84     -13.664  19.655  14.453  1.00 43.24           C  
ATOM    792  CD  GLU A  84     -14.725  20.273  15.354  1.00 45.77           C  
ATOM    793  OE1 GLU A  84     -15.550  19.491  15.875  1.00 48.73           O  
ATOM    794  OE2 GLU A  84     -14.729  21.525  15.555  1.00 46.91           O  
ATOM    795  N   VAL A  85     -11.083  18.163  13.642  1.00 38.14           N  
ATOM    796  CA  VAL A  85      -9.710  18.667  13.654  1.00 38.88           C  
ATOM    797  C   VAL A  85      -8.835  17.846  12.713  1.00 38.71           C  
ATOM    798  O   VAL A  85      -7.985  18.404  12.015  1.00 35.72           O  
ATOM    799  CB  VAL A  85      -9.085  18.707  15.067  1.00 40.27           C  
ATOM    800  CG1 VAL A  85      -7.793  19.461  15.026  1.00 39.96           C  
ATOM    801  CG2 VAL A  85     -10.018  19.379  16.043  1.00 45.89           C  
ATOM    802  N   LYS A  86      -9.059  16.532  12.685  1.00 37.03           N  
ATOM    803  CA  LYS A  86      -8.362  15.662  11.752  1.00 37.97           C  
ATOM    804  C   LYS A  86      -8.663  16.040  10.312  1.00 37.87           C  
ATOM    805  O   LYS A  86      -7.747  16.078   9.482  1.00 37.47           O  
ATOM    806  CB  LYS A  86      -8.716  14.196  12.002  1.00 38.30           C  
ATOM    807  CG  LYS A  86      -8.199  13.688  13.326  1.00 39.93           C  
ATOM    808  CD  LYS A  86      -8.839  12.360  13.697  1.00 43.25           C  
ATOM    809  CE  LYS A  86      -8.510  12.012  15.141  1.00 48.00           C  
ATOM    810  NZ  LYS A  86      -9.272  10.847  15.606  1.00 44.56           N  
ATOM    811  N   GLU A  87      -9.936  16.320  10.017  1.00 37.50           N  
ATOM    812  CA  GLU A  87     -10.322  16.787   8.688  1.00 39.50           C  
ATOM    813  C   GLU A  87      -9.599  18.069   8.301  1.00 38.74           C  
ATOM    814  O   GLU A  87      -9.105  18.196   7.182  1.00 38.61           O  
ATOM    815  CB  GLU A  87     -11.839  17.009   8.601  1.00 41.05           C  
ATOM    816  CG  GLU A  87     -12.608  15.714   8.684  1.00 41.14           C  
ATOM    817  CD  GLU A  87     -14.095  15.889   8.582  1.00 46.74           C  
ATOM    818  OE1 GLU A  87     -14.654  16.699   9.358  1.00 57.44           O  
ATOM    819  OE2 GLU A  87     -14.702  15.208   7.724  1.00 51.84           O  
ATOM    820  N   LEU A  88      -9.560  19.016   9.230  1.00 38.33           N  
ATOM    821  CA  LEU A  88      -8.911  20.293   8.992  1.00 41.93           C  
ATOM    822  C   LEU A  88      -7.411  20.121   8.773  1.00 39.12           C  
ATOM    823  O   LEU A  88      -6.826  20.802   7.930  1.00 41.80           O  
ATOM    824  CB  LEU A  88      -9.155  21.260  10.151  1.00 41.90           C  
ATOM    825  CG  LEU A  88      -8.365  22.570  10.011  1.00 50.30           C  
ATOM    826  CD1 LEU A  88      -8.898  23.420   8.862  1.00 51.28           C  
ATOM    827  CD2 LEU A  88      -8.401  23.334  11.297  1.00 49.33           C  
ATOM    828  N   ALA A  89      -6.785  19.237   9.540  1.00 36.92           N  
ATOM    829  CA  ALA A  89      -5.353  18.984   9.399  1.00 36.70           C  
ATOM    830  C   ALA A  89      -5.016  18.551   7.981  1.00 36.25           C  
ATOM    831  O   ALA A  89      -4.018  18.998   7.408  1.00 36.84           O  
ATOM    832  CB  ALA A  89      -4.891  17.928  10.377  1.00 37.07           C  
ATOM    833  N   LEU A  90      -5.845  17.660   7.431  1.00 36.52           N  
ATOM    834  CA  LEU A  90      -5.594  17.094   6.110  1.00 38.84           C  
ATOM    835  C   LEU A  90      -5.835  18.117   4.995  1.00 39.63           C  
ATOM    836  O   LEU A  90      -5.212  18.032   3.943  1.00 42.39           O  
ATOM    837  CB  LEU A  90      -6.419  15.812   5.905  1.00 39.58           C  
ATOM    838  CG  LEU A  90      -6.075  14.707   6.913  1.00 38.43           C  
ATOM    839  CD1 LEU A  90      -7.066  13.573   6.860  1.00 43.12           C  
ATOM    840  CD2 LEU A  90      -4.645  14.167   6.708  1.00 40.52           C  
ATOM    841  N   GLU A  91      -6.717  19.081   5.236  1.00 39.78           N  
ATOM    842  CA  GLU A  91      -6.881  20.219   4.339  1.00 41.59           C  
ATOM    843  C   GLU A  91      -5.778  21.267   4.499  1.00 40.58           C  
ATOM    844  O   GLU A  91      -5.329  21.824   3.507  1.00 42.88           O  
ATOM    845  CB  GLU A  91      -8.261  20.852   4.520  1.00 43.65           C  
ATOM    846  CG  GLU A  91      -9.389  19.888   4.200  1.00 50.53           C  
ATOM    847  CD  GLU A  91      -9.223  19.181   2.836  1.00 58.95           C  
ATOM    848  OE1 GLU A  91      -9.167  19.888   1.800  1.00 59.92           O  
ATOM    849  OE2 GLU A  91      -9.160  17.924   2.806  1.00 60.39           O  
ATOM    850  N   ALA A  92      -5.346  21.536   5.727  1.00 39.52           N  
ATOM    851  CA  ALA A  92      -4.293  22.527   5.976  1.00 40.37           C  
ATOM    852  C   ALA A  92      -2.927  22.063   5.471  1.00 39.58           C  
ATOM    853  O   ALA A  92      -2.160  22.869   4.957  1.00 41.47           O  
ATOM    854  CB  ALA A  92      -4.204  22.860   7.451  1.00 40.90           C  
ATOM    855  N   VAL A  93      -2.626  20.778   5.648  1.00 39.12           N  
ATOM    856  CA  VAL A  93      -1.357  20.163   5.230  1.00 37.75           C  
ATOM    857  C   VAL A  93      -1.692  18.936   4.357  1.00 37.88           C  
ATOM    858  O   VAL A  93      -1.597  17.789   4.810  1.00 37.75           O  
ATOM    859  CB  VAL A  93      -0.501  19.736   6.457  1.00 38.40           C  
ATOM    860  CG1 VAL A  93       0.910  19.349   6.042  1.00 40.62           C  
ATOM    861  CG2 VAL A  93      -0.422  20.851   7.491  1.00 38.95           C  
ATOM    862  N   PRO A  94      -2.113  19.172   3.101  1.00 37.82           N  
ATOM    863  CA  PRO A  94      -2.648  18.078   2.287  1.00 37.96           C  
ATOM    864  C   PRO A  94      -1.633  16.985   1.972  1.00 37.95           C  
ATOM    865  O   PRO A  94      -2.024  15.858   1.740  1.00 40.46           O  
ATOM    866  CB  PRO A  94      -3.185  18.780   1.026  1.00 39.26           C  
ATOM    867  CG  PRO A  94      -2.569  20.112   0.992  1.00 39.54           C  
ATOM    868  CD  PRO A  94      -2.168  20.467   2.405  1.00 39.03           C  
ATOM    869  N   SER A  95      -0.343  17.281   2.058  1.00 36.54           N  
ATOM    870  CA  SER A  95       0.668  16.234   1.936  1.00 36.19           C  
ATOM    871  C   SER A  95       0.478  15.094   2.969  1.00 36.58           C  
ATOM    872  O   SER A  95       0.895  13.959   2.742  1.00 37.12           O  
ATOM    873  CB  SER A  95       2.074  16.835   2.001  1.00 37.11           C  
ATOM    874  OG  SER A  95       2.309  17.554   3.188  1.00 43.63           O  
ATOM    875  N   LEU A  96      -0.172  15.389   4.088  1.00 34.10           N  
ATOM    876  CA  LEU A  96      -0.484  14.363   5.099  1.00 35.96           C  
ATOM    877  C   LEU A  96      -1.355  13.248   4.548  1.00 34.15           C  
ATOM    878  O   LEU A  96      -1.323  12.127   5.046  1.00 33.82           O  
ATOM    879  CB  LEU A  96      -1.193  14.992   6.301  1.00 37.93           C  
ATOM    880  CG  LEU A  96      -0.271  15.854   7.189  1.00 38.85           C  
ATOM    881  CD1 LEU A  96      -1.112  16.519   8.274  1.00 38.42           C  
ATOM    882  CD2 LEU A  96       0.871  15.071   7.795  1.00 41.16           C  
ATOM    883  N   LYS A  97      -2.149  13.559   3.532  1.00 34.08           N  
ATOM    884  CA  LYS A  97      -3.022  12.558   2.932  1.00 36.39           C  
ATOM    885  C   LYS A  97      -2.235  11.419   2.309  1.00 34.73           C  
ATOM    886  O   LYS A  97      -2.801  10.352   2.085  1.00 34.36           O  
ATOM    887  CB  LYS A  97      -3.945  13.188   1.901  1.00 37.63           C  
ATOM    888  CG  LYS A  97      -4.963  14.149   2.522  1.00 40.90           C  
ATOM    889  CD  LYS A  97      -6.062  14.504   1.539  1.00 40.40           C  
ATOM    890  CE  LYS A  97      -6.870  15.719   1.993  1.00 43.68           C  
ATOM    891  NZ  LYS A  97      -7.455  16.451   0.831  1.00 50.46           N  
ATOM    892  N   ASN A  98      -0.941  11.631   2.037  1.00 34.74           N  
ATOM    893  CA  ASN A  98      -0.087  10.555   1.530  1.00 35.65           C  
ATOM    894  C   ASN A  98       0.095   9.436   2.542  1.00 38.82           C  
ATOM    895  O   ASN A  98       0.397   8.310   2.148  1.00 40.60           O  
ATOM    896  CB  ASN A  98       1.271  11.073   1.068  1.00 35.28           C  
ATOM    897  CG  ASN A  98       1.171  11.985  -0.153  1.00 38.02           C  
ATOM    898  OD1 ASN A  98       0.398  11.735  -1.053  1.00 42.93           O  
ATOM    899  ND2 ASN A  98       1.945  13.047  -0.165  1.00 42.94           N  
HETATM  900  N   MSE A  99      -0.088   9.733   3.833  1.00 38.48           N  
HETATM  901  CA  MSE A  99       0.012   8.711   4.892  1.00 39.31           C  
HETATM  902  C   MSE A  99      -1.251   8.485   5.729  1.00 38.21           C  
HETATM  903  O   MSE A  99      -1.447   7.393   6.267  1.00 40.28           O  
HETATM  904  CB  MSE A  99       1.143   9.085   5.842  1.00 39.78           C  
HETATM  905  CG  MSE A  99       2.508   8.835   5.274  1.00 46.06           C  
HETATM  906 SE   MSE A  99       3.840   9.409   6.545  0.70 50.63          SE  
HETATM  907  CE  MSE A  99       3.047   8.850   8.047  1.00 51.66           C  
ATOM    908  N   TYR A 100      -2.102   9.506   5.851  1.00 35.23           N  
ATOM    909  CA  TYR A 100      -3.192   9.486   6.810  1.00 36.08           C  
ATOM    910  C   TYR A 100      -4.522   9.762   6.145  1.00 36.01           C  
ATOM    911  O   TYR A 100      -4.567  10.385   5.097  1.00 33.86           O  
ATOM    912  CB  TYR A 100      -2.948  10.527   7.898  1.00 37.58           C  
ATOM    913  CG  TYR A 100      -1.702  10.219   8.706  1.00 34.01           C  
ATOM    914  CD1 TYR A 100      -1.620   9.051   9.450  1.00 35.60           C  
ATOM    915  CD2 TYR A 100      -0.602  11.071   8.686  1.00 37.82           C  
ATOM    916  CE1 TYR A 100      -0.489   8.737  10.172  1.00 36.36           C  
ATOM    917  CE2 TYR A 100       0.533  10.773   9.409  1.00 39.30           C  
ATOM    918  CZ  TYR A 100       0.583   9.605  10.155  1.00 38.79           C  
ATOM    919  OH  TYR A 100       1.707   9.277  10.860  1.00 42.38           O  
ATOM    920  N   SER A 101      -5.595   9.291   6.768  1.00 36.22           N  
ATOM    921  CA  SER A 101      -6.946   9.637   6.377  1.00 37.98           C  
ATOM    922  C   SER A 101      -7.797   9.723   7.640  1.00 37.27           C  
ATOM    923  O   SER A 101      -7.451   9.141   8.657  1.00 34.07           O  
ATOM    924  CB  SER A 101      -7.514   8.619   5.376  1.00 39.75           C  
ATOM    925  OG  SER A 101      -7.522   7.310   5.907  1.00 41.13           O  
ATOM    926  N   VAL A 102      -8.909  10.443   7.571  1.00 38.02           N  
ATOM    927  CA  VAL A 102      -9.715  10.776   8.764  0.50 38.48           C  
ATOM    929  C   VAL A 102     -10.106   9.552   9.590  1.00 39.18           C  
ATOM    930  O   VAL A 102     -10.148   9.614  10.814  1.00 42.11           O  
ATOM    931  CB  VAL A 102     -11.057  11.508   8.435  0.50 38.01           C  
ATOM    933  CG1 VAL A 102     -11.619  12.174   9.698  0.50 33.79           C  
ATOM    935  CG2 VAL A 102     -10.902  12.542   7.320  0.50 41.29           C  
ATOM    937  N   ASP A 103     -10.432   8.454   8.919  1.00 40.13           N  
ATOM    938  CA  ASP A 103     -10.970   7.287   9.618  1.00 40.84           C  
ATOM    939  C   ASP A 103      -9.996   6.132   9.625  1.00 40.64           C  
ATOM    940  O   ASP A 103     -10.406   4.968   9.724  1.00 41.09           O  
ATOM    941  CB  ASP A 103     -12.283   6.840   8.973  1.00 42.04           C  
ATOM    942  CG  ASP A 103     -13.400   7.832   9.187  1.00 46.71           C  
ATOM    943  OD1 ASP A 103     -13.539   8.358  10.313  1.00 54.70           O  
ATOM    944  OD2 ASP A 103     -14.151   8.081   8.224  1.00 49.14           O  
ATOM    945  N   ASP A 104      -8.710   6.436   9.552  1.00 38.03           N  
ATOM    946  CA  ASP A 104      -7.718   5.372   9.499  1.00 37.81           C  
ATOM    947  C   ASP A 104      -7.412   4.746  10.856  1.00 37.15           C  
ATOM    948  O   ASP A 104      -6.707   3.749  10.911  1.00 36.85           O  
ATOM    949  CB  ASP A 104      -6.440   5.821   8.786  1.00 37.53           C  
ATOM    950  CG  ASP A 104      -5.648   6.877   9.553  1.00 38.26           C  
ATOM    951  OD1 ASP A 104      -5.968   7.182  10.731  1.00 32.86           O  
ATOM    952  OD2 ASP A 104      -4.700   7.400   8.940  1.00 36.36           O  
ATOM    953  N   GLY A 105      -7.942   5.315  11.937  1.00 36.77           N  
ATOM    954  CA  GLY A 105      -7.743   4.761  13.274  1.00 37.92           C  
ATOM    955  C   GLY A 105      -6.354   4.986  13.878  1.00 37.11           C  
ATOM    956  O   GLY A 105      -6.095   4.593  15.016  1.00 37.93           O  
ATOM    957  N   ILE A 106      -5.447   5.609  13.137  1.00 37.56           N  
ATOM    958  CA  ILE A 106      -4.094   5.882  13.666  1.00 36.98           C  
ATOM    959  C   ILE A 106      -3.720   7.363  13.730  1.00 37.29           C  
ATOM    960  O   ILE A 106      -2.921   7.760  14.584  1.00 37.63           O  
ATOM    961  CB  ILE A 106      -3.003   5.083  12.909  1.00 36.83           C  
ATOM    962  CG1 ILE A 106      -2.955   5.442  11.422  1.00 39.19           C  
ATOM    963  CG2 ILE A 106      -3.245   3.570  13.075  1.00 39.18           C  
ATOM    964  CD1 ILE A 106      -1.740   4.902  10.729  1.00 40.03           C  
ATOM    965  N   PHE A 107      -4.288   8.168  12.834  1.00 35.75           N  
ATOM    966  CA  PHE A 107      -3.933   9.603  12.718  1.00 34.00           C  
ATOM    967  C   PHE A 107      -4.256  10.343  14.022  1.00 33.13           C  
ATOM    968  O   PHE A 107      -5.347  10.186  14.560  1.00 33.55           O  
ATOM    969  CB  PHE A 107      -4.724  10.213  11.537  1.00 33.44           C  
ATOM    970  CG  PHE A 107      -4.349  11.640  11.193  1.00 35.11           C  
ATOM    971  CD1 PHE A 107      -3.016  12.031  11.112  1.00 35.41           C  
ATOM    972  CD2 PHE A 107      -5.338  12.578  10.880  1.00 39.39           C  
ATOM    973  CE1 PHE A 107      -2.668  13.345  10.772  1.00 33.93           C  
ATOM    974  CE2 PHE A 107      -4.996  13.890  10.549  1.00 37.13           C  
ATOM    975  CZ  PHE A 107      -3.656  14.269  10.495  1.00 38.08           C  
ATOM    976  N   ALA A 108      -3.317  11.149  14.511  1.00 34.33           N  
ATOM    977  CA  ALA A 108      -3.479  11.889  15.756  1.00 33.88           C  
ATOM    978  C   ALA A 108      -3.066  13.334  15.523  1.00 34.42           C  
ATOM    979  O   ALA A 108      -2.065  13.632  14.824  1.00 32.79           O  
ATOM    980  CB  ALA A 108      -2.629  11.260  16.893  1.00 35.61           C  
ATOM    981  N   VAL A 109      -3.829  14.241  16.115  1.00 34.57           N  
ATOM    982  CA  VAL A 109      -3.465  15.654  16.126  1.00 36.54           C  
ATOM    983  C   VAL A 109      -3.408  16.096  17.586  1.00 35.34           C  
ATOM    984  O   VAL A 109      -4.291  15.752  18.381  1.00 36.54           O  
ATOM    985  CB  VAL A 109      -4.416  16.529  15.285  1.00 36.81           C  
ATOM    986  CG1 VAL A 109      -4.346  16.129  13.826  1.00 39.54           C  
ATOM    987  CG2 VAL A 109      -5.847  16.444  15.787  1.00 40.05           C  
ATOM    988  N   LEU A 110      -2.349  16.819  17.938  1.00 35.22           N  
ATOM    989  CA  LEU A 110      -2.140  17.277  19.307  1.00 33.79           C  
ATOM    990  C   LEU A 110      -1.858  18.765  19.332  1.00 34.03           C  
ATOM    991  O   LEU A 110      -1.218  19.288  18.427  1.00 37.16           O  
ATOM    992  CB  LEU A 110      -0.964  16.549  19.940  1.00 32.97           C  
ATOM    993  CG  LEU A 110      -1.002  15.025  19.863  1.00 35.58           C  
ATOM    994  CD1 LEU A 110      -0.171  14.543  18.672  1.00 35.43           C  
ATOM    995  CD2 LEU A 110      -0.476  14.468  21.158  1.00 39.12           C  
ATOM    996  N   TYR A 111      -2.322  19.456  20.368  1.00 33.20           N  
ATOM    997  CA  TYR A 111      -2.086  20.900  20.448  1.00 33.31           C  
ATOM    998  C   TYR A 111      -1.391  21.297  21.735  1.00 33.19           C  
ATOM    999  O   TYR A 111      -1.444  20.587  22.739  1.00 33.07           O  
ATOM   1000  CB  TYR A 111      -3.379  21.711  20.282  1.00 35.24           C  
ATOM   1001  CG  TYR A 111      -4.307  21.601  21.457  1.00 33.64           C  
ATOM   1002  CD1 TYR A 111      -5.101  20.490  21.623  1.00 31.16           C  
ATOM   1003  CD2 TYR A 111      -4.348  22.589  22.437  1.00 36.28           C  
ATOM   1004  CE1 TYR A 111      -5.955  20.363  22.721  1.00 33.61           C  
ATOM   1005  CE2 TYR A 111      -5.179  22.475  23.536  1.00 30.81           C  
ATOM   1006  CZ  TYR A 111      -5.979  21.350  23.675  1.00 32.12           C  
ATOM   1007  OH  TYR A 111      -6.816  21.210  24.749  1.00 36.59           O  
ATOM   1008  N   PHE A 112      -0.764  22.467  21.693  1.00 34.26           N  
ATOM   1009  CA  PHE A 112      -0.107  23.018  22.873  1.00 34.55           C  
ATOM   1010  C   PHE A 112      -1.143  23.659  23.770  1.00 34.25           C  
ATOM   1011  O   PHE A 112      -1.808  24.633  23.371  1.00 33.40           O  
ATOM   1012  CB  PHE A 112       0.946  24.046  22.478  1.00 34.77           C  
ATOM   1013  CG  PHE A 112       2.257  23.437  22.125  1.00 32.90           C  
ATOM   1014  CD1 PHE A 112       2.505  22.985  20.841  1.00 37.10           C  
ATOM   1015  CD2 PHE A 112       3.232  23.289  23.088  1.00 35.07           C  
ATOM   1016  CE1 PHE A 112       3.733  22.370  20.520  1.00 36.92           C  
ATOM   1017  CE2 PHE A 112       4.441  22.697  22.785  1.00 36.26           C  
ATOM   1018  CZ  PHE A 112       4.704  22.250  21.496  1.00 38.35           C  
ATOM   1019  N   THR A 113      -1.297  23.105  24.968  1.00 34.28           N  
ATOM   1020  CA  THR A 113      -2.253  23.654  25.942  1.00 36.27           C  
ATOM   1021  C   THR A 113      -1.682  24.907  26.591  1.00 36.49           C  
ATOM   1022  O   THR A 113      -2.426  25.795  27.057  1.00 34.88           O  
ATOM   1023  CB  THR A 113      -2.551  22.646  27.058  1.00 35.71           C  
ATOM   1024  OG1 THR A 113      -1.334  22.316  27.741  1.00 35.98           O  
ATOM   1025  CG2 THR A 113      -3.198  21.396  26.484  1.00 37.07           C  
ATOM   1026  N   LYS A 114      -0.360  24.923  26.663  1.00 35.35           N  
ATOM   1027  CA  LYS A 114       0.406  26.074  27.102  1.00 36.65           C  
ATOM   1028  C   LYS A 114       1.851  25.954  26.630  1.00 35.77           C  
ATOM   1029  O   LYS A 114       2.320  24.878  26.292  1.00 35.44           O  
ATOM   1030  CB  LYS A 114       0.389  26.198  28.618  1.00 36.34           C  
ATOM   1031  CG  LYS A 114       0.912  24.987  29.353  1.00 39.47           C  
ATOM   1032  CD  LYS A 114       0.575  25.097  30.835  1.00 43.75           C  
ATOM   1033  CE  LYS A 114       1.195  23.960  31.630  1.00 53.11           C  
ATOM   1034  NZ  LYS A 114       0.892  24.045  33.092  1.00 51.56           N  
ATOM   1035  N   GLY A 115       2.569  27.061  26.644  1.00 34.12           N  
ATOM   1036  CA  GLY A 115       3.955  27.014  26.247  1.00 35.63           C  
ATOM   1037  C   GLY A 115       4.594  28.374  26.318  1.00 36.33           C  
ATOM   1038  O   GLY A 115       3.892  29.392  26.398  1.00 37.07           O  
ATOM   1039  N   GLU A 116       5.923  28.365  26.343  1.00 37.58           N  
ATOM   1040  CA  GLU A 116       6.727  29.586  26.313  1.00 38.57           C  
ATOM   1041  C   GLU A 116       7.889  29.355  25.385  1.00 39.06           C  
ATOM   1042  O   GLU A 116       8.502  28.279  25.386  1.00 35.30           O  
ATOM   1043  CB  GLU A 116       7.217  29.975  27.702  1.00 43.35           C  
ATOM   1044  CG  GLU A 116       8.134  28.984  28.359  1.00 49.46           C  
ATOM   1045  N   GLY A 117       8.178  30.375  24.591  1.00 38.10           N  
ATOM   1046  CA  GLY A 117       9.188  30.261  23.570  1.00 38.51           C  
ATOM   1047  C   GLY A 117      10.145  31.429  23.534  1.00 36.58           C  
ATOM   1048  O   GLY A 117       9.871  32.514  24.054  1.00 35.92           O  
ATOM   1049  N   THR A 118      11.267  31.173  22.891  1.00 35.89           N  
ATOM   1050  CA  THR A 118      12.276  32.173  22.618  1.00 35.44           C  
ATOM   1051  C   THR A 118      12.754  31.946  21.211  1.00 34.56           C  
ATOM   1052  O   THR A 118      12.995  30.792  20.827  1.00 34.35           O  
ATOM   1053  CB  THR A 118      13.459  32.041  23.589  1.00 39.78           C  
ATOM   1054  OG1 THR A 118      12.972  32.122  24.930  1.00 45.14           O  
ATOM   1055  CG2 THR A 118      14.443  33.152  23.383  1.00 45.15           C  
ATOM   1056  N   ILE A 119      12.857  33.024  20.437  1.00 33.10           N  
ATOM   1057  CA  ILE A 119      13.498  32.990  19.128  1.00 36.09           C  
ATOM   1058  C   ILE A 119      14.793  33.763  19.248  1.00 38.11           C  
ATOM   1059  O   ILE A 119      14.805  34.937  19.673  1.00 39.49           O  
ATOM   1060  CB  ILE A 119      12.623  33.566  18.034  1.00 36.58           C  
ATOM   1061  CG1 ILE A 119      11.401  32.673  17.848  1.00 36.62           C  
ATOM   1062  CG2 ILE A 119      13.417  33.706  16.732  1.00 37.33           C  
ATOM   1063  CD1 ILE A 119      10.264  33.352  17.051  1.00 39.74           C  
ATOM   1064  N   CYS A 120      15.881  33.100  18.862  1.00 38.99           N  
ATOM   1065  CA  CYS A 120      17.219  33.636  19.058  1.00 40.16           C  
ATOM   1066  C   CYS A 120      17.832  33.938  17.715  1.00 42.18           C  
ATOM   1067  O   CYS A 120      17.647  33.204  16.746  1.00 39.01           O  
ATOM   1068  CB  CYS A 120      18.117  32.639  19.789  1.00 42.50           C  
ATOM   1069  SG  CYS A 120      17.519  32.177  21.438  1.00 52.18           S  
ATOM   1070  N   SER A 121      18.547  35.040  17.674  1.00 44.17           N  
ATOM   1071  CA  SER A 121      19.216  35.484  16.463  1.00 49.57           C  
ATOM   1072  C   SER A 121      20.674  35.649  16.817  1.00 52.80           C  
ATOM   1073  O   SER A 121      21.038  35.882  17.979  1.00 50.94           O  
ATOM   1074  CB  SER A 121      18.636  36.824  15.980  1.00 50.94           C  
ATOM   1075  OG  SER A 121      17.210  36.807  15.893  1.00 58.32           O  
ATOM   1076  N   PHE A 122      21.521  35.529  15.810  1.00 54.96           N  
ATOM   1077  CA  PHE A 122      22.919  35.801  16.001  1.00 54.11           C  
ATOM   1078  C   PHE A 122      23.082  37.234  16.534  1.00 54.01           C  
ATOM   1079  O   PHE A 122      23.695  37.454  17.576  1.00 51.10           O  
ATOM   1080  CB  PHE A 122      23.679  35.657  14.684  1.00 53.95           C  
ATOM   1081  CG  PHE A 122      25.048  36.217  14.749  1.00 52.50           C  
ATOM   1082  CD1 PHE A 122      25.999  35.594  15.529  1.00 56.86           C  
ATOM   1083  CD2 PHE A 122      25.385  37.384  14.073  1.00 52.62           C  
ATOM   1084  CE1 PHE A 122      27.253  36.095  15.617  1.00 55.41           C  
ATOM   1085  CE2 PHE A 122      26.636  37.888  14.161  1.00 47.85           C  
ATOM   1086  CZ  PHE A 122      27.581  37.249  14.936  1.00 52.61           C  
ATOM   1087  N   LYS A 123      22.537  38.197  15.796  1.00 56.25           N  
ATOM   1088  CA  LYS A 123      22.577  39.597  16.199  1.00 59.58           C  
ATOM   1089  C   LYS A 123      21.179  39.996  16.651  1.00 63.10           C  
ATOM   1090  O   LYS A 123      20.200  39.759  15.931  1.00 65.78           O  
ATOM   1091  N   GLY A 124      21.084  40.572  17.849  1.00 63.29           N  
ATOM   1092  CA  GLY A 124      19.813  41.110  18.363  1.00 61.79           C  
ATOM   1093  C   GLY A 124      19.299  40.393  19.601  1.00 59.06           C  
ATOM   1094  O   GLY A 124      19.713  39.268  19.895  1.00 58.97           O  
ATOM   1095  N   GLU A 125      18.390  41.055  20.319  1.00 56.26           N  
ATOM   1096  CA  GLU A 125      17.818  40.515  21.555  1.00 52.91           C  
ATOM   1097  C   GLU A 125      16.916  39.332  21.243  1.00 48.87           C  
ATOM   1098  O   GLU A 125      16.307  39.261  20.178  1.00 48.30           O  
ATOM   1099  CB  GLU A 125      17.013  41.579  22.310  1.00 53.02           C  
ATOM   1100  N   ASN A 126      16.847  38.400  22.180  1.00 46.87           N  
ATOM   1101  CA  ASN A 126      15.920  37.295  22.079  1.00 45.86           C  
ATOM   1102  C   ASN A 126      14.511  37.828  22.004  1.00 43.61           C  
ATOM   1103  O   ASN A 126      14.189  38.836  22.620  1.00 43.03           O  
ATOM   1104  CB  ASN A 126      16.013  36.400  23.305  1.00 46.74           C  
ATOM   1105  CG  ASN A 126      17.296  35.621  23.360  1.00 52.35           C  
ATOM   1106  OD1 ASN A 126      18.095  35.625  22.416  1.00 53.40           O  
ATOM   1107  ND2 ASN A 126      17.505  34.931  24.478  1.00 57.10           N  
ATOM   1108  N   GLU A 127      13.682  37.146  21.235  1.00 41.55           N  
ATOM   1109  CA  GLU A 127      12.263  37.402  21.180  1.00 42.29           C  
ATOM   1110  C   GLU A 127      11.586  36.343  22.019  1.00 41.02           C  
ATOM   1111  O   GLU A 127      11.783  35.165  21.769  1.00 40.88           O  
ATOM   1112  CB  GLU A 127      11.817  37.274  19.737  1.00 43.21           C  
ATOM   1113  CG  GLU A 127      10.369  37.510  19.501  1.00 46.78           C  
ATOM   1114  CD  GLU A 127       9.981  37.277  18.062  1.00 48.50           C  
ATOM   1115  OE1 GLU A 127      10.886  37.100  17.205  1.00 53.54           O  
ATOM   1116  OE2 GLU A 127       8.758  37.272  17.802  1.00 55.66           O  
ATOM   1117  N   THR A 128      10.812  36.734  23.022  1.00 38.68           N  
ATOM   1118  CA  THR A 128      10.134  35.750  23.854  1.00 40.40           C  
ATOM   1119  C   THR A 128       8.645  35.866  23.662  1.00 41.03           C  
ATOM   1120  O   THR A 128       8.131  36.942  23.373  1.00 41.39           O  
ATOM   1121  CB  THR A 128      10.500  35.860  25.342  1.00 42.70           C  
ATOM   1122  OG1 THR A 128      10.211  37.168  25.815  1.00 50.65           O  
ATOM   1123  CG2 THR A 128      11.985  35.577  25.544  1.00 47.41           C  
ATOM   1124  N   PHE A 129       7.954  34.747  23.823  1.00 38.89           N  
ATOM   1125  CA  PHE A 129       6.530  34.726  23.643  1.00 39.68           C  
ATOM   1126  C   PHE A 129       5.930  33.584  24.468  1.00 38.87           C  
ATOM   1127  O   PHE A 129       6.642  32.687  24.914  1.00 35.53           O  
ATOM   1128  CB  PHE A 129       6.202  34.575  22.153  1.00 43.26           C  
ATOM   1129  CG  PHE A 129       6.663  33.282  21.568  1.00 43.72           C  
ATOM   1130  CD1 PHE A 129       7.846  33.217  20.841  1.00 49.82           C  
ATOM   1131  CD2 PHE A 129       5.892  32.131  21.702  1.00 53.21           C  
ATOM   1132  CE1 PHE A 129       8.268  32.037  20.275  1.00 49.68           C  
ATOM   1133  CE2 PHE A 129       6.310  30.956  21.149  1.00 50.83           C  
ATOM   1134  CZ  PHE A 129       7.502  30.903  20.431  1.00 54.22           C  
ATOM   1135  N   SER A 130       4.618  33.646  24.648  1.00 37.80           N  
ATOM   1136  CA  SER A 130       3.843  32.660  25.393  1.00 40.76           C  
ATOM   1137  C   SER A 130       2.730  32.195  24.488  1.00 41.63           C  
ATOM   1138  O   SER A 130       2.187  32.997  23.722  1.00 40.10           O  
ATOM   1139  CB  SER A 130       3.141  33.333  26.591  1.00 41.18           C  
ATOM   1140  OG  SER A 130       4.065  33.929  27.462  1.00 55.62           O  
ATOM   1141  N   LEU A 131       2.302  30.951  24.643  1.00 42.92           N  
ATOM   1142  CA  LEU A 131       1.045  30.539  24.059  1.00 47.18           C  
ATOM   1143  C   LEU A 131       0.165  29.726  25.026  1.00 50.20           C  
ATOM   1144  O   LEU A 131       0.508  29.524  26.214  1.00 50.55           O  
ATOM   1145  CB  LEU A 131       1.279  29.816  22.732  1.00 49.47           C  
ATOM   1146  CG  LEU A 131       2.389  28.777  22.620  1.00 48.51           C  
ATOM   1147  CD1 LEU A 131       1.937  27.471  23.221  1.00 56.60           C  
ATOM   1148  CD2 LEU A 131       2.728  28.576  21.172  1.00 48.73           C  
ATOM   1149  OXT LEU A 131      -0.933  29.296  24.627  1.00 51.39           O  
TER    1150      LEU A 131                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
