
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  172 ( 1347),  selected  172 , name 1xhn_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 1xhn_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    P    14_A      -       -           -
LGA    P    15_A      -       -           -
LGA    R    16_A      M       1          3.989
LGA    E    17_A      A       2          3.058
LGA    -       -      D       3           -
LGA    -       -      P       4           -
LGA    -       -      K       5           -
LGA    D    18_A      E       6          1.138
LGA    A    19_A      L       7          0.798
LGA    A    20_A      Q       8          0.997
LGA    R    21_A      D       9          0.441
LGA    V    22_A      K      10          1.064
LGA    A    23_A      F      11          1.274
LGA    R    24_A      W      12          0.872
LGA    F    25_A      K      13          0.919
LGA    V    26_A      A      14          1.717
LGA    T    27_A      L      15          1.625
LGA    H    28_A      K      16          0.663
LGA    V    29_A      S      17          1.052
LGA    S    30_A      D      18          2.321
LGA    D    31_A      R      19          3.238
LGA    W    32_A      T      20          2.577
LGA    G    33_A      V      21          1.832
LGA    A    34_A      M      22          0.941
LGA    L    35_A      L      23          0.574
LGA    A    36_A      G      24          0.815
LGA    T    37_A      L      25          1.362
LGA    I    38_A      D      26           #
LGA    S    39_A      G      27           -
LGA    T    40_A      -       -           -
LGA    L    41_A      -       -           -
LGA    E    42_A      -       -           -
LGA    A    43_A      -       -           -
LGA    V    44_A      -       -           -
LGA    R    45_A      V      28           #
LGA    G    46_A      E      29          2.566
LGA    R    47_A      D      30          3.196
LGA    P    48_A      G      31          2.967
LGA    F    49_A      H      32          3.084
LGA    A    50_A      A      33          0.794
LGA    D    51_A      R      34          0.824
LGA    V    52_A      P      35          1.703
LGA    L    53_A      M      36          1.567
LGA    S    54_A      T      37          2.382
LGA    L    55_A      A      38          2.617
LGA    S    56_A      Q      39          1.300
LGA    D    57_A      I      40          1.334
LGA    G    58_A      E      41          3.589
LGA    P    59_A      -       -           -
LGA    P    60_A      -       -           -
LGA    G    61_A      -       -           -
LGA    A    62_A      G      42          2.807
LGA    G    63_A      D      43          2.849
LGA    S    64_A      S      44          3.966
LGA    G    65_A      G      45          3.490
LGA    V    66_A      G      46          2.581
LGA    -       -      P      47           -
LGA    P    67_A      I      48          1.412
LGA    Y    68_A      W      49          0.807
LGA    F    69_A      F      50          1.302
LGA    Y    70_A      F      51          1.805
LGA    L    71_A      T      52          2.646
LGA    S    72_A      S      53          2.960
LGA    P    73_A      K      54          3.257
LGA    L    74_A      D      55          1.099
LGA    Q    75_A      N      56          1.112
LGA    L    76_A      A      57          1.461
LGA    S    77_A      L      58          2.127
LGA    V    78_A      I      59          1.725
LGA    S    79_A      A      60          2.880
LGA    N    80_A      M      61          3.343
LGA    L    81_A      L      62          2.581
LGA    Q    82_A      G      63          4.101
LGA    E    83_A      Q      64           -
LGA    N    84_A      G      65           #
LGA    P    85_A      R      66          1.679
LGA    Y    86_A      R      67          1.511
LGA    A    87_A      V      68          1.127
LGA    T    88_A      I      69          1.576
LGA    L    89_A      G      70          1.604
LGA    T    90_A      A      71          2.126
LGA    X    91_A      F      72          1.890
LGA    T    92_A      S      73          1.064
LGA    L    93_A      S      74          1.285
LGA    A    94_A      K      75          2.928
LGA    Q    95_A      -       -           -
LGA    T    96_A      -       -           -
LGA    N    97_A      -       -           -
LGA    F    98_A      G      76          2.796
LGA    C    99_A      H      77          4.167
LGA    K   100_A      -       -           -
LGA    K   101_A      -       -           -
LGA    H   102_A      -       -           -
LGA    G   103_A      -       -           -
LGA    F   104_A      -       -           -
LGA    D   105_A      -       -           -
LGA    P   106_A      -       -           -
LGA    Q   107_A      -       -           -
LGA    S   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    L   110_A      -       -           -
LGA    C   111_A      D      78          2.211
LGA    V   112_A      L      79          0.698
LGA    H   113_A      F      80          1.459
LGA    I   114_A      A      81          1.160
LGA    X   115_A      S      82          1.786
LGA    L   116_A      I      83          1.496
LGA    S   117_A      S      84          1.192
LGA    G   118_A      G      85          0.918
LGA    T   119_A      S      86          1.036
LGA    V   120_A      L      87          1.116
LGA    T   121_A      R      88          1.817
LGA    K   122_A      E      89          2.560
LGA    V   123_A      D      90          2.515
LGA    N   124_A      T      91           -
LGA    E   125_A      -       -           -
LGA    T   126_A      -       -           -
LGA    E   127_A      D      92          5.835
LGA    X   128_A      P      93          4.055
LGA    D   129_A      A      94          2.230
LGA    I   130_A      V      95          3.550
LGA    A   131_A      V      96          4.414
LGA    K   132_A      D      97          3.582
LGA    H   133_A      R      98          2.309
LGA    S   134_A      L      99          2.011
LGA    L   135_A      W     100          4.378
LGA    F   136_A      N     101          2.915
LGA    I   137_A      P     102          4.843
LGA    R   138_A      Y     103          4.800
LGA    H   139_A      V     104          2.432
LGA    P   140_A      A     105          2.927
LGA    E   141_A      A     106          0.984
LGA    X   142_A      W     107          3.294
LGA    K   143_A      Y     108          4.138
LGA    T   144_A      E     109          2.143
LGA    W   145_A      G     110          5.284
LGA    P   146_A      G     111           -
LGA    -       -      K     112           -
LGA    S   147_A      D     113           #
LGA    S   148_A      D     114           #
LGA    H   149_A      P     115          4.959
LGA    N   150_A      K     116          3.149
LGA    W   151_A      L     117          1.396
LGA    F   152_A      A     118          2.311
LGA    F   153_A      L     119          2.089
LGA    A   154_A      L     120          2.012
LGA    K   155_A      R     121          0.854
LGA    L   156_A      L     122          0.389
LGA    N   157_A      D     123          0.461
LGA    I   158_A      A     124          0.857
LGA    T   159_A      D     125          1.184
LGA    N   160_A      H     126          1.990
LGA    I   161_A      A     127          1.056
LGA    W   162_A      Q     128          1.036
LGA    V   163_A      I     129          0.796
LGA    L   164_A      W     130          1.051
LGA    D   165_A      L     131          1.334
LGA    Y   166_A      N     132          4.520
LGA    F   167_A      G     133          5.389
LGA    G   168_A      S     134           -
LGA    G   169_A      S     135           -
LGA    P   170_A      L     136           -
LGA    K   171_A      L     137           -
LGA    I   172_A      A     138           -
LGA    V   173_A      G     139           -
LGA    T   174_A      I     140           -
LGA    P   175_A      K     141           -
LGA    E   176_A      V     142           -
LGA    E   177_A      L     143           -
LGA    Y   178_A      L     144           -
LGA    Y   179_A      G     145           -
LGA    N   180_A      -       -           -
LGA    V   181_A      -       -           -
LGA    T   182_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  172  145    5.0    119    2.50     8.40     54.204     4.579

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.665644 * X  +   0.284518 * Y  +  -0.689904 * Z  +  20.501659
  Y_new =  -0.359671 * X  +  -0.932327 * Y  +  -0.037471 * Z  + 122.030251
  Z_new =  -0.653877 * X  +   0.223196 * Y  +   0.722931 * Z  +  23.804373 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.299453   -2.842139  [ DEG:    17.1574   -162.8426 ]
  Theta =   0.712697    2.428896  [ DEG:    40.8345    139.1655 ]
  Phi   =  -2.646200    0.495392  [ DEG:  -151.6161     28.3839 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xhn_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xhn_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  172  145   5.0  119   2.50    8.40  54.204
REMARK  ---------------------------------------------------------- 
MOLECULE 1xhn_A
HEADER    UNKNOWN FUNCTION                        20-SEP-04   1XHN              
TITLE     THE CRYSTAL STRUCTURE OF CELLULAR REPRESSOR OF E1A-                   
TITLE    2 STIMULATED GENES (CREG)                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CELLULAR REPRESSOR OF E1A-STIMULATED GENES;                
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: RESIDUES 13-184;                                           
COMPND   5 SYNONYM: CREG;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    BETA-BARREL                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.SACHER,V.V.LUNIN,M.CYGLER                                           
REVDAT   2   10-JAN-06 1XHN    1       JRNL                                     
REVDAT   1   15-NOV-05 1XHN    0                                                
JRNL        AUTH   M.SACHER,A.DI BACCO,V.V.LUNIN,Z.YE,J.WAGNER,G.GILL,          
JRNL        AUTH 2 M.CYGLER                                                     
JRNL        TITL   THE CRYSTAL STRUCTURE OF CREG, A SECRETED                    
JRNL        TITL 2 GLYCOPROTEIN INVOLVED IN CELLULAR GROWTH AND                 
JRNL        TITL 3 DIFFERENTIATION                                              
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 102 18326 2005              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  1XHN A   13   184  UNP    O75629   CREG1_HUMAN     49    220             
DBREF  1XHN B   13   184  UNP    O75629   CREG1_HUMAN     49    220             
DBREF  1XHN C   13   184  UNP    O75629   CREG1_HUMAN     49    220             
DBREF  1XHN D   13   184  UNP    O75629   CREG1_HUMAN     49    220             
SEQRES   1 A  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 A  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 A  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 A  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 A  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 A  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 A  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 A  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 A  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 A  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 A  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 A  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 A  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 A  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 A  184  VAL GLN                                                      
SEQRES   1 B  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 B  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 B  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 B  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 B  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 B  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 B  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 B  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 B  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 B  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 B  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 B  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 B  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 B  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 B  184  VAL GLN                                                      
SEQRES   1 C  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 C  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 C  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 C  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 C  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 C  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 C  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 C  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 C  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 C  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 C  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 C  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 C  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 C  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 C  184  VAL GLN                                                      
SEQRES   1 D  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 D  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 D  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 D  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 D  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 D  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 D  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 D  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 D  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 D  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 D  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 D  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 D  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 D  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 D  184  VAL GLN                                                      
HET    MSE  A  91       8                                                       
HET    MSE  A 115       8                                                       
HET    MSE  A 128      12                                                       
HET    MSE  A 142       8                                                       
HET    MSE  B  91       8                                                       
HET    MSE  B 115       8                                                       
HET    MSE  B 128      11                                                       
HET    MSE  B 142       8                                                       
HET    MSE  C  91       8                                                       
HET    MSE  C 115       8                                                       
HET    MSE  C 128      12                                                       
HET    MSE  C 142       8                                                       
HET    MSE  D  91       8                                                       
HET    MSE  D 115       8                                                       
HET    MSE  D 128       8                                                       
HET    MSE  D 142       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5  HOH   *892(H2 O)                                                    
CRYST1  106.130  121.260   55.920  90.00  90.00  90.00 P 21 21 2    16          
ATOM      1  N   GLY A  11       5.909  36.912   1.887  1.00 33.92           N  
ATOM      2  CA  GLY A  11       6.227  35.987   3.036  1.00 32.27           C  
ATOM      3  C   GLY A  11       7.628  36.200   3.585  1.00 31.41           C  
ATOM      4  O   GLY A  11       8.465  35.276   3.561  1.00 32.68           O  
ATOM      5  N   SER A  12       7.918  37.409   4.063  1.00 29.73           N  
ATOM      6  CA  SER A  12       9.276  37.700   4.567  1.00 27.90           C  
ATOM      7  C   SER A  12       9.399  37.752   6.105  1.00 24.80           C  
ATOM      8  O   SER A  12       8.413  37.915   6.819  1.00 23.13           O  
ATOM      9  CB  SER A  12       9.876  38.960   3.918  1.00 28.33           C  
ATOM     10  OG  SER A  12       8.916  39.993   3.801  1.00 32.42           O  
ATOM     11  N   LEU A  13      10.633  37.602   6.591  1.00 22.37           N  
ATOM     12  CA  LEU A  13      10.888  37.523   8.029  1.00 20.39           C  
ATOM     13  C   LEU A  13      10.483  38.823   8.719  1.00 18.51           C  
ATOM     14  O   LEU A  13      10.881  39.900   8.278  1.00 18.09           O  
ATOM     15  CB  LEU A  13      12.380  37.237   8.298  1.00 19.27           C  
ATOM     16  CG  LEU A  13      12.793  36.972   9.741  1.00 19.41           C  
ATOM     17  CD1 LEU A  13      12.269  35.657  10.239  1.00 16.84           C  
ATOM     18  CD2 LEU A  13      14.315  37.070   9.922  1.00 19.52           C  
ATOM     19  N   PRO A  14       9.706  38.734   9.793  1.00 17.20           N  
ATOM     20  CA  PRO A  14       9.359  39.943  10.552  1.00 17.11           C  
ATOM     21  C   PRO A  14      10.566  40.592  11.240  1.00 15.27           C  
ATOM     22  O   PRO A  14      11.641  39.955  11.299  1.00 14.54           O  
ATOM     23  CB  PRO A  14       8.362  39.430  11.612  1.00 16.99           C  
ATOM     24  CG  PRO A  14       7.844  38.124  11.034  1.00 18.23           C  
ATOM     25  CD  PRO A  14       9.079  37.528  10.377  1.00 16.97           C  
ATOM     26  N   PRO A  15      10.398  41.800  11.780  1.00 14.97           N  
ATOM     27  CA  PRO A  15      11.490  42.465  12.533  1.00 14.88           C  
ATOM     28  C   PRO A  15      11.947  41.572  13.653  1.00 13.94           C  
ATOM     29  O   PRO A  15      11.119  41.062  14.413  1.00 13.45           O  
ATOM     30  CB  PRO A  15      10.836  43.772  13.058  1.00 14.67           C  
ATOM     31  CG  PRO A  15       9.753  44.070  12.041  1.00 16.30           C  
ATOM     32  CD  PRO A  15       9.188  42.652  11.725  1.00 15.15           C  
ATOM     33  N   ARG A  16      13.258  41.363  13.741  1.00 13.91           N  
ATOM     34  CA  ARG A  16      13.822  40.437  14.694  1.00 13.21           C  
ATOM     35  C   ARG A  16      13.543  40.834  16.151  1.00 13.50           C  
ATOM     36  O   ARG A  16      13.404  39.945  17.021  1.00 13.25           O  
ATOM     37  CB  ARG A  16      15.307  40.261  14.407  1.00 12.46           C  
ATOM     38  CG  ARG A  16      15.537  39.441  13.103  1.00 14.15           C  
ATOM     39  CD  ARG A  16      17.003  39.370  12.757  1.00 10.35           C  
ATOM     40  NE  ARG A  16      17.337  38.736  11.479  1.00 13.99           N  
ATOM     41  CZ  ARG A  16      17.549  37.426  11.304  1.00 14.14           C  
ATOM     42  NH1 ARG A  16      17.382  36.564  12.327  1.00 10.25           N  
ATOM     43  NH2 ARG A  16      17.901  36.976  10.085  1.00 10.87           N  
ATOM     44  N   GLU A  17      13.382  42.129  16.410  1.00 11.99           N  
ATOM     45  CA  GLU A  17      13.010  42.581  17.777  1.00 14.18           C  
ATOM     46  C   GLU A  17      11.617  42.060  18.188  1.00 13.82           C  
ATOM     47  O   GLU A  17      11.328  41.914  19.381  1.00 14.36           O  
ATOM     48  CB  GLU A  17      12.999  44.122  17.809  0.50 14.46           C  
ATOM     50  CG  GLU A  17      12.740  44.772  19.156  0.50 18.19           C  
ATOM     52  CD  GLU A  17      11.266  45.087  19.402  0.50 22.21           C  
ATOM     54  OE1 GLU A  17      10.536  45.407  18.433  0.50 22.82           O  
ATOM     56  OE2 GLU A  17      10.830  45.009  20.586  0.50 26.13           O  
ATOM     58  N   ASP A  18      10.760  41.782  17.207  1.00 13.52           N  
ATOM     59  CA  ASP A  18       9.418  41.308  17.525  1.00 15.18           C  
ATOM     60  C   ASP A  18       9.505  39.798  17.544  1.00 14.29           C  
ATOM     61  O   ASP A  18       9.200  39.124  16.556  1.00 13.71           O  
ATOM     62  CB  ASP A  18       8.390  41.815  16.523  1.00 16.75           C  
ATOM     63  CG  ASP A  18       6.940  41.685  17.049  1.00 21.33           C  
ATOM     64  OD1 ASP A  18       6.564  40.716  17.751  1.00 20.10           O  
ATOM     65  OD2 ASP A  18       6.094  42.547  16.799  1.00 28.07           O  
ATOM     66  N   ALA A  19      10.009  39.288  18.663  1.00 13.82           N  
ATOM     67  CA  ALA A  19      10.265  37.859  18.779  1.00 13.96           C  
ATOM     68  C   ALA A  19       8.921  37.081  18.702  1.00 12.84           C  
ATOM     69  O   ALA A  19       8.902  35.995  18.173  1.00 13.70           O  
ATOM     70  CB  ALA A  19      11.046  37.524  20.040  1.00 13.09           C  
ATOM     71  N   ALA A  20       7.820  37.647  19.210  1.00 12.09           N  
ATOM     72  CA  ALA A  20       6.514  36.978  19.089  1.00 11.48           C  
ATOM     73  C   ALA A  20       6.119  36.768  17.607  1.00 10.79           C  
ATOM     74  O   ALA A  20       5.722  35.652  17.194  1.00  8.72           O  
ATOM     75  CB  ALA A  20       5.410  37.779  19.844  1.00 11.88           C  
ATOM     76  N   ARG A  21       6.235  37.833  16.818  1.00 11.81           N  
ATOM     77  CA  ARG A  21       5.932  37.721  15.378  1.00 12.77           C  
ATOM     78  C   ARG A  21       6.850  36.728  14.654  1.00 11.61           C  
ATOM     79  O   ARG A  21       6.395  35.954  13.790  1.00 12.01           O  
ATOM     80  CB  ARG A  21       6.058  39.074  14.685  1.00 12.99           C  
ATOM     81  CG  ARG A  21       4.963  40.048  14.983  1.00 20.29           C  
ATOM     82  CD  ARG A  21       5.089  41.325  14.132  1.00 24.48           C  
ATOM     83  NE  ARG A  21       4.927  41.038  12.715  1.00 26.88           N  
ATOM     84  CZ  ARG A  21       5.227  41.901  11.737  1.00 32.74           C  
ATOM     85  NH1 ARG A  21       5.719  43.120  12.031  1.00 31.90           N  
ATOM     86  NH2 ARG A  21       5.034  41.551  10.463  1.00 33.94           N  
ATOM     87  N   VAL A  22       8.152  36.816  14.947  1.00 10.20           N  
ATOM     88  CA  VAL A  22       9.135  35.894  14.390  1.00  9.24           C  
ATOM     89  C   VAL A  22       8.822  34.448  14.753  1.00  9.79           C  
ATOM     90  O   VAL A  22       8.854  33.556  13.914  1.00  9.07           O  
ATOM     91  CB  VAL A  22      10.578  36.261  14.846  1.00  9.82           C  
ATOM     92  CG1 VAL A  22      11.594  35.192  14.404  1.00  8.25           C  
ATOM     93  CG2 VAL A  22      10.976  37.617  14.263  1.00 10.42           C  
ATOM     94  N   ALA A  23       8.437  34.208  16.006  1.00  9.16           N  
ATOM     95  CA  ALA A  23       8.115  32.853  16.389  1.00  9.44           C  
ATOM     96  C   ALA A  23       6.920  32.341  15.580  1.00  9.68           C  
ATOM     97  O   ALA A  23       6.918  31.205  15.096  1.00  9.67           O  
ATOM     98  CB  ALA A  23       7.798  32.789  17.919  1.00  8.19           C  
ATOM     99  N   ARG A  24       5.893  33.171  15.433  1.00 10.03           N  
ATOM    100  CA  ARG A  24       4.747  32.763  14.662  1.00  9.87           C  
ATOM    101  C   ARG A  24       5.125  32.542  13.184  1.00  9.93           C  
ATOM    102  O   ARG A  24       4.613  31.629  12.518  1.00 10.17           O  
ATOM    103  CB  ARG A  24       3.662  33.837  14.737  1.00 10.13           C  
ATOM    104  CG  ARG A  24       2.844  33.839  16.114  1.00  8.84           C  
ATOM    105  CD  ARG A  24       1.845  32.638  16.313  1.00 10.51           C  
ATOM    106  NE  ARG A  24       0.769  32.674  15.310  1.00 16.47           N  
ATOM    107  CZ  ARG A  24      -0.329  33.414  15.454  1.00 17.26           C  
ATOM    108  NH1 ARG A  24      -0.472  34.159  16.540  1.00 19.82           N  
ATOM    109  NH2 ARG A  24      -1.286  33.414  14.523  1.00 19.87           N  
ATOM    110  N   PHE A  25       5.966  33.419  12.647  1.00  7.49           N  
ATOM    111  CA  PHE A  25       6.493  33.171  11.263  1.00  8.49           C  
ATOM    112  C   PHE A  25       7.165  31.785  11.044  1.00  8.74           C  
ATOM    113  O   PHE A  25       6.837  31.027  10.085  1.00  9.28           O  
ATOM    114  CB  PHE A  25       7.418  34.311  10.872  1.00  8.05           C  
ATOM    115  CG  PHE A  25       8.054  34.149   9.513  1.00 10.60           C  
ATOM    116  CD1 PHE A  25       7.380  34.554   8.358  1.00 14.80           C  
ATOM    117  CD2 PHE A  25       9.284  33.513   9.412  1.00 13.42           C  
ATOM    118  CE1 PHE A  25       7.946  34.345   7.071  1.00 15.12           C  
ATOM    119  CE2 PHE A  25       9.901  33.305   8.136  1.00 16.05           C  
ATOM    120  CZ  PHE A  25       9.221  33.739   6.970  1.00 14.62           C  
ATOM    121  N   VAL A  26       8.134  31.474  11.885  1.00  9.89           N  
ATOM    122  CA  VAL A  26       8.767  30.154  11.912  1.00  9.70           C  
ATOM    123  C   VAL A  26       7.779  28.999  12.077  1.00 10.97           C  
ATOM    124  O   VAL A  26       7.860  28.043  11.327  1.00 11.27           O  
ATOM    125  CB  VAL A  26       9.838  30.088  12.994  1.00  9.71           C  
ATOM    126  CG1 VAL A  26      10.449  28.663  13.098  1.00  8.34           C  
ATOM    127  CG2 VAL A  26      10.955  31.148  12.670  1.00 10.95           C  
ATOM    128  N   THR A  27       6.888  29.065  13.075  1.00 10.95           N  
ATOM    129  CA  THR A  27       5.909  27.980  13.224  1.00 12.03           C  
ATOM    130  C   THR A  27       5.119  27.741  11.933  1.00 11.23           C  
ATOM    131  O   THR A  27       4.953  26.592  11.481  1.00 12.20           O  
ATOM    132  CB  THR A  27       4.963  28.262  14.389  1.00 10.64           C  
ATOM    133  OG1 THR A  27       5.698  28.173  15.619  1.00  9.03           O  
ATOM    134  CG2 THR A  27       3.898  27.163  14.500  1.00 11.71           C  
ATOM    135  N   HIS A  28       4.600  28.809  11.369  1.00 12.07           N  
ATOM    136  CA  HIS A  28       3.814  28.708  10.138  1.00 12.89           C  
ATOM    137  C   HIS A  28       4.611  28.218   8.917  1.00 13.09           C  
ATOM    138  O   HIS A  28       4.086  27.408   8.150  1.00 13.87           O  
ATOM    139  CB  HIS A  28       3.018  30.021   9.853  1.00 13.93           C  
ATOM    140  CG  HIS A  28       2.074  29.904   8.683  1.00 13.41           C  
ATOM    141  ND1 HIS A  28       1.015  29.016   8.665  1.00 18.30           N  
ATOM    142  CD2 HIS A  28       2.048  30.541   7.488  1.00 16.99           C  
ATOM    143  CE1 HIS A  28       0.374  29.113   7.513  1.00 15.93           C  
ATOM    144  NE2 HIS A  28       0.990  30.025   6.776  1.00 18.50           N  
ATOM    145  N   VAL A  29       5.864  28.663   8.707  1.00 13.47           N  
ATOM    146  CA  VAL A  29       6.633  28.160   7.527  1.00 13.93           C  
ATOM    147  C   VAL A  29       7.171  26.746   7.669  1.00 12.73           C  
ATOM    148  O   VAL A  29       7.681  26.176   6.703  1.00 13.83           O  
ATOM    149  CB  VAL A  29       7.820  29.089   7.030  1.00 14.06           C  
ATOM    150  CG1 VAL A  29       7.341  30.448   6.667  1.00 16.45           C  
ATOM    151  CG2 VAL A  29       8.933  29.190   8.052  1.00 12.85           C  
ATOM    152  N   SER A  30       7.086  26.180   8.859  1.00 11.41           N  
ATOM    153  CA  SER A  30       7.635  24.842   9.138  1.00 11.04           C  
ATOM    154  C   SER A  30       6.621  23.758   8.796  1.00 11.77           C  
ATOM    155  O   SER A  30       5.478  23.857   9.227  1.00 11.88           O  
ATOM    156  CB  SER A  30       7.995  24.761  10.643  1.00 11.30           C  
ATOM    157  OG  SER A  30       9.084  25.696  10.942  1.00  8.34           O  
ATOM    158  N   ASP A  31       7.018  22.749   8.022  1.00 10.77           N  
ATOM    159  CA  ASP A  31       6.141  21.586   7.778  1.00 11.50           C  
ATOM    160  C   ASP A  31       6.415  20.426   8.720  1.00 11.81           C  
ATOM    161  O   ASP A  31       5.654  19.446   8.746  1.00 12.13           O  
ATOM    162  CB  ASP A  31       6.245  21.083   6.328  1.00 11.31           C  
ATOM    163  CG  ASP A  31       5.833  22.151   5.298  1.00 16.35           C  
ATOM    164  OD1 ASP A  31       4.973  22.999   5.623  1.00 16.18           O  
ATOM    165  OD2 ASP A  31       6.399  22.251   4.174  1.00 20.63           O  
ATOM    166  N   TRP A  32       7.522  20.524   9.468  1.00  9.29           N  
ATOM    167  CA  TRP A  32       7.939  19.506  10.388  1.00  9.07           C  
ATOM    168  C   TRP A  32       8.819  20.178  11.458  1.00  9.30           C  
ATOM    169  O   TRP A  32       9.222  21.370  11.328  1.00  9.24           O  
ATOM    170  CB  TRP A  32       8.694  18.376   9.677  1.00  9.11           C  
ATOM    171  CG  TRP A  32      10.000  18.808   9.000  1.00 11.44           C  
ATOM    172  CD1 TRP A  32      10.128  19.291   7.716  1.00 13.37           C  
ATOM    173  CD2 TRP A  32      11.354  18.747   9.533  1.00 10.84           C  
ATOM    174  NE1 TRP A  32      11.453  19.579   7.454  1.00  9.17           N  
ATOM    175  CE2 TRP A  32      12.215  19.265   8.558  1.00  8.85           C  
ATOM    176  CE3 TRP A  32      11.902  18.379  10.770  1.00 13.29           C  
ATOM    177  CZ2 TRP A  32      13.630  19.350   8.744  1.00 11.79           C  
ATOM    178  CZ3 TRP A  32      13.287  18.500  10.986  1.00 14.15           C  
ATOM    179  CH2 TRP A  32      14.144  18.976   9.955  1.00 11.96           C  
ATOM    180  N   GLY A  33       9.094  19.414  12.511  1.00  9.95           N  
ATOM    181  CA  GLY A  33       9.995  19.829  13.577  1.00  9.62           C  
ATOM    182  C   GLY A  33      10.529  18.642  14.340  1.00  9.38           C  
ATOM    183  O   GLY A  33      10.220  17.479  14.012  1.00  9.15           O  
ATOM    184  N   ALA A  34      11.375  18.930  15.337  1.00  8.93           N  
ATOM    185  CA  ALA A  34      11.944  17.904  16.162  1.00  8.94           C  
ATOM    186  C   ALA A  34      11.260  18.022  17.531  1.00  9.85           C  
ATOM    187  O   ALA A  34      11.285  19.086  18.158  1.00 10.56           O  
ATOM    188  CB  ALA A  34      13.507  18.063  16.288  1.00  8.21           C  
ATOM    189  N   LEU A  35      10.634  16.933  17.980  1.00 10.11           N  
ATOM    190  CA  LEU A  35      10.033  16.913  19.318  1.00  9.75           C  
ATOM    191  C   LEU A  35      10.892  16.150  20.300  1.00  9.68           C  
ATOM    192  O   LEU A  35      11.308  15.038  20.017  1.00  9.70           O  
ATOM    193  CB  LEU A  35       8.641  16.286  19.234  1.00  9.85           C  
ATOM    194  CG  LEU A  35       7.797  16.504  20.482  1.00  9.12           C  
ATOM    195  CD1 LEU A  35       7.202  17.919  20.409  1.00  8.34           C  
ATOM    196  CD2 LEU A  35       6.700  15.430  20.516  1.00 10.55           C  
ATOM    197  N   ALA A  36      11.148  16.760  21.458  1.00 12.22           N  
ATOM    198  CA  ALA A  36      11.934  16.133  22.536  1.00 11.33           C  
ATOM    199  C   ALA A  36      10.952  15.645  23.606  1.00 11.93           C  
ATOM    200  O   ALA A  36      10.062  16.401  24.003  1.00 11.99           O  
ATOM    201  CB  ALA A  36      12.891  17.158  23.163  1.00 10.41           C  
ATOM    202  N   THR A  37      11.109  14.377  24.003  1.00 11.43           N  
ATOM    203  CA  THR A  37      10.285  13.697  24.997  1.00 13.04           C  
ATOM    204  C   THR A  37      11.236  12.986  25.966  1.00 13.61           C  
ATOM    205  O   THR A  37      12.473  13.002  25.768  1.00 13.36           O  
ATOM    206  CB  THR A  37       9.279  12.702  24.383  1.00 12.13           C  
ATOM    207  OG1 THR A  37       9.933  11.770  23.506  1.00 11.52           O  
ATOM    208  CG2 THR A  37       8.222  13.418  23.542  1.00 14.92           C  
ATOM    209  N   ILE A  38      10.678  12.422  27.032  1.00 14.60           N  
ATOM    210  CA  ILE A  38      11.464  11.591  27.912  1.00 14.09           C  
ATOM    211  C   ILE A  38      11.220  10.144  27.543  1.00 14.45           C  
ATOM    212  O   ILE A  38      10.081   9.708  27.465  1.00 14.05           O  
ATOM    213  CB  ILE A  38      11.069  11.796  29.398  1.00 14.10           C  
ATOM    214  CG1 ILE A  38      11.145  13.286  29.856  1.00 15.88           C  
ATOM    215  CG2 ILE A  38      11.916  10.848  30.271  1.00 13.58           C  
ATOM    216  CD1 ILE A  38      12.461  13.935  29.807  1.00 16.29           C  
ATOM    217  N   SER A  39      12.283   9.390  27.319  1.00 16.15           N  
ATOM    218  CA  SER A  39      12.140   8.027  26.829  1.00 16.83           C  
ATOM    219  C   SER A  39      11.600   7.100  27.903  1.00 17.73           C  
ATOM    220  O   SER A  39      12.065   7.133  29.062  1.00 16.36           O  
ATOM    221  CB  SER A  39      13.473   7.477  26.307  1.00 16.23           C  
ATOM    222  OG  SER A  39      13.216   6.254  25.643  1.00 19.61           O  
ATOM    223  N   THR A  40      10.643   6.266  27.480  1.00 18.70           N  
ATOM    224  CA  THR A  40      10.105   5.184  28.309  1.00 19.89           C  
ATOM    225  C   THR A  40      10.585   3.818  27.812  1.00 20.40           C  
ATOM    226  O   THR A  40      10.092   2.804  28.278  1.00 21.43           O  
ATOM    227  CB  THR A  40       8.545   5.136  28.315  1.00 20.57           C  
ATOM    228  OG1 THR A  40       8.061   4.932  26.989  1.00 19.08           O  
ATOM    229  CG2 THR A  40       7.900   6.424  28.816  1.00 21.14           C  
ATOM    230  N   LEU A  41      11.510   3.792  26.855  1.00 20.37           N  
ATOM    231  CA  LEU A  41      12.145   2.539  26.440  1.00 21.38           C  
ATOM    232  C   LEU A  41      13.038   1.989  27.571  1.00 21.45           C  
ATOM    233  O   LEU A  41      13.874   2.710  28.101  1.00 20.28           O  
ATOM    234  CB  LEU A  41      13.017   2.742  25.202  1.00 20.55           C  
ATOM    235  CG  LEU A  41      12.362   3.019  23.839  1.00 23.71           C  
ATOM    236  CD1 LEU A  41      13.431   3.545  22.872  1.00 23.52           C  
ATOM    237  CD2 LEU A  41      11.634   1.758  23.245  1.00 23.48           C  
ATOM    238  N   GLU A  42      12.879   0.702  27.896  1.00 21.91           N  
ATOM    239  CA  GLU A  42      13.700   0.054  28.927  1.00 21.32           C  
ATOM    240  C   GLU A  42      15.184   0.358  28.748  1.00 20.36           C  
ATOM    241  O   GLU A  42      15.867   0.715  29.715  1.00 19.58           O  
ATOM    242  CB  GLU A  42      13.487  -1.480  28.886  1.00 23.24           C  
ATOM    243  CG  GLU A  42      14.326  -2.281  29.890  1.00 22.80           C  
ATOM    244  CD  GLU A  42      13.724  -2.151  31.290  1.00 28.88           C  
ATOM    245  OE1 GLU A  42      12.843  -1.263  31.464  1.00 29.69           O  
ATOM    246  OE2 GLU A  42      14.098  -2.934  32.199  1.00 30.38           O  
ATOM    247  N   ALA A  43      15.677   0.227  27.516  1.00 20.00           N  
ATOM    248  CA  ALA A  43      17.122   0.402  27.236  1.00 20.39           C  
ATOM    249  C   ALA A  43      17.673   1.753  27.641  1.00 19.62           C  
ATOM    250  O   ALA A  43      18.888   1.877  27.958  1.00 20.22           O  
ATOM    251  CB  ALA A  43      17.424   0.135  25.758  1.00 20.97           C  
ATOM    252  N   VAL A  44      16.814   2.781  27.566  1.00 18.72           N  
ATOM    253  CA  VAL A  44      17.234   4.170  27.765  1.00 16.60           C  
ATOM    254  C   VAL A  44      16.258   4.979  28.612  1.00 17.01           C  
ATOM    255  O   VAL A  44      16.160   6.185  28.449  1.00 16.45           O  
ATOM    256  CB  VAL A  44      17.498   4.915  26.404  1.00 18.16           C  
ATOM    257  CG1 VAL A  44      18.772   4.414  25.755  1.00 18.28           C  
ATOM    258  CG2 VAL A  44      16.262   4.859  25.435  1.00 14.08           C  
ATOM    259  N   ARG A  45      15.553   4.314  29.531  1.00 14.94           N  
ATOM    260  CA  ARG A  45      14.484   4.977  30.262  1.00 15.99           C  
ATOM    261  C   ARG A  45      14.978   6.186  31.009  1.00 14.37           C  
ATOM    262  O   ARG A  45      15.998   6.123  31.644  1.00 14.50           O  
ATOM    263  CB  ARG A  45      13.793   3.985  31.200  1.00 15.86           C  
ATOM    264  CG  ARG A  45      12.560   4.501  31.916  1.00 15.81           C  
ATOM    265  CD  ARG A  45      11.911   3.416  32.814  1.00 24.23           C  
ATOM    266  NE  ARG A  45      11.731   2.114  32.142  1.00 28.04           N  
ATOM    267  CZ  ARG A  45      10.606   1.700  31.542  1.00 30.31           C  
ATOM    268  NH1 ARG A  45       9.531   2.493  31.490  1.00 33.21           N  
ATOM    269  NH2 ARG A  45      10.565   0.497  30.953  1.00 27.84           N  
ATOM    270  N   GLY A  46      14.251   7.290  30.880  1.00 13.68           N  
ATOM    271  CA  GLY A  46      14.598   8.543  31.518  1.00 13.13           C  
ATOM    272  C   GLY A  46      15.455   9.473  30.662  1.00 13.33           C  
ATOM    273  O   GLY A  46      15.538  10.657  30.977  1.00 12.89           O  
ATOM    274  N   ARG A  47      16.062   8.949  29.592  1.00 13.00           N  
ATOM    275  CA  ARG A  47      16.891   9.778  28.691  1.00 14.62           C  
ATOM    276  C   ARG A  47      16.043  10.722  27.792  1.00 13.75           C  
ATOM    277  O   ARG A  47      14.897  10.373  27.421  1.00 14.03           O  
ATOM    278  CB  ARG A  47      17.813   8.898  27.822  1.00 16.18           C  
ATOM    279  CG  ARG A  47      19.170   8.637  28.478  1.00 20.21           C  
ATOM    280  CD  ARG A  47      19.849   7.337  28.180  1.00 27.71           C  
ATOM    281  NE  ARG A  47      20.527   7.390  26.910  1.00 31.45           N  
ATOM    282  CZ  ARG A  47      21.625   6.717  26.557  1.00 29.11           C  
ATOM    283  NH1 ARG A  47      22.265   5.885  27.372  1.00 27.45           N  
ATOM    284  NH2 ARG A  47      22.078   6.889  25.323  1.00 27.11           N  
ATOM    285  N   PRO A  48      16.559  11.921  27.508  1.00 12.70           N  
ATOM    286  CA  PRO A  48      15.871  12.830  26.580  1.00 14.06           C  
ATOM    287  C   PRO A  48      15.949  12.191  25.218  1.00 13.97           C  
ATOM    288  O   PRO A  48      16.953  11.550  24.905  1.00 14.86           O  
ATOM    289  CB  PRO A  48      16.686  14.139  26.649  1.00 12.94           C  
ATOM    290  CG  PRO A  48      17.988  13.750  27.206  1.00 14.85           C  
ATOM    291  CD  PRO A  48      17.813  12.509  28.035  1.00 12.66           C  
ATOM    292  N   PHE A  49      14.838  12.218  24.500  1.00 13.24           N  
ATOM    293  CA  PHE A  49      14.712  11.545  23.212  1.00 12.87           C  
ATOM    294  C   PHE A  49      14.272  12.621  22.241  1.00 13.10           C  
ATOM    295  O   PHE A  49      13.541  13.523  22.661  1.00 12.06           O  
ATOM    296  CB  PHE A  49      13.601  10.479  23.282  1.00 12.70           C  
ATOM    297  CG  PHE A  49      13.586   9.543  22.097  1.00 15.36           C  
ATOM    298  CD1 PHE A  49      14.605   8.607  21.928  1.00 13.69           C  
ATOM    299  CD2 PHE A  49      12.543   9.593  21.167  1.00 15.87           C  
ATOM    300  CE1 PHE A  49      14.586   7.704  20.833  1.00 17.04           C  
ATOM    301  CE2 PHE A  49      12.527   8.709  20.048  1.00 18.31           C  
ATOM    302  CZ  PHE A  49      13.556   7.757  19.900  1.00 14.43           C  
ATOM    303  N   ALA A  50      14.753  12.549  20.984  1.00 13.21           N  
ATOM    304  CA  ALA A  50      14.366  13.472  19.916  1.00 13.25           C  
ATOM    305  C   ALA A  50      13.825  12.672  18.754  1.00 13.33           C  
ATOM    306  O   ALA A  50      14.194  11.546  18.544  1.00 14.97           O  
ATOM    307  CB  ALA A  50      15.552  14.321  19.446  1.00 12.69           C  
ATOM    308  N   ASP A  51      12.958  13.282  17.970  1.00 14.24           N  
ATOM    309  CA  ASP A  51      12.264  12.590  16.880  1.00 14.83           C  
ATOM    310  C   ASP A  51      11.628  13.628  15.934  1.00 13.50           C  
ATOM    311  O   ASP A  51      11.309  14.756  16.354  1.00 13.72           O  
ATOM    312  CB  ASP A  51      11.202  11.664  17.497  1.00 15.78           C  
ATOM    313  CG  ASP A  51      10.474  10.790  16.468  1.00 20.92           C  
ATOM    314  OD1 ASP A  51      11.038  10.401  15.396  1.00 24.06           O  
ATOM    315  OD2 ASP A  51       9.286  10.454  16.678  1.00 28.07           O  
ATOM    316  N   VAL A  52      11.444  13.245  14.675  1.00 12.37           N  
ATOM    317  CA  VAL A  52      10.995  14.120  13.593  1.00 11.82           C  
ATOM    318  C   VAL A  52       9.493  13.928  13.396  1.00 13.13           C  
ATOM    319  O   VAL A  52       9.044  12.796  13.181  1.00 12.90           O  
ATOM    320  CB  VAL A  52      11.810  13.807  12.267  1.00 12.84           C  
ATOM    321  CG1 VAL A  52      11.242  14.567  11.079  1.00 12.40           C  
ATOM    322  CG2 VAL A  52      13.274  14.218  12.464  1.00 12.96           C  
ATOM    323  N   LEU A  53       8.705  14.999  13.566  1.00 11.65           N  
ATOM    324  CA  LEU A  53       7.268  14.944  13.303  1.00 11.45           C  
ATOM    325  C   LEU A  53       6.845  15.953  12.253  1.00 11.13           C  
ATOM    326  O   LEU A  53       7.300  17.075  12.263  1.00 12.21           O  
ATOM    327  CB  LEU A  53       6.476  15.214  14.611  1.00 11.51           C  
ATOM    328  CG  LEU A  53       6.715  14.282  15.807  1.00 11.78           C  
ATOM    329  CD1 LEU A  53       5.884  14.839  16.986  1.00 17.65           C  
ATOM    330  CD2 LEU A  53       6.214  12.880  15.389  1.00 16.49           C  
ATOM    331  N   SER A  54       5.901  15.573  11.396  1.00 11.39           N  
ATOM    332  CA  SER A  54       5.219  16.545  10.535  1.00 11.15           C  
ATOM    333  C   SER A  54       4.257  17.397  11.424  1.00 10.52           C  
ATOM    334  O   SER A  54       3.821  16.975  12.468  1.00 10.81           O  
ATOM    335  CB  SER A  54       4.431  15.812   9.441  1.00 11.04           C  
ATOM    336  OG  SER A  54       5.252  15.502   8.343  1.00 12.49           O  
ATOM    337  N   LEU A  55       4.018  18.629  11.033  1.00  9.89           N  
ATOM    338  CA  LEU A  55       3.130  19.528  11.752  1.00 10.08           C  
ATOM    339  C   LEU A  55       2.503  20.541  10.814  1.00  9.31           C  
ATOM    340  O   LEU A  55       2.954  20.696   9.678  1.00 10.97           O  
ATOM    341  CB  LEU A  55       3.871  20.248  12.885  1.00  8.88           C  
ATOM    342  CG  LEU A  55       5.094  21.111  12.519  1.00 11.42           C  
ATOM    343  CD1 LEU A  55       4.650  22.540  12.563  1.00 10.40           C  
ATOM    344  CD2 LEU A  55       6.129  20.897  13.630  1.00 10.58           C  
ATOM    345  N   SER A  56       1.469  21.226  11.318  1.00 10.79           N  
ATOM    346  CA  SER A  56       0.857  22.339  10.646  1.00 12.44           C  
ATOM    347  C   SER A  56       0.145  23.204  11.645  1.00 13.14           C  
ATOM    348  O   SER A  56      -0.528  22.693  12.576  1.00 12.14           O  
ATOM    349  CB  SER A  56      -0.180  21.863   9.609  1.00 12.77           C  
ATOM    350  OG  SER A  56      -0.706  22.985   8.932  1.00 13.17           O  
ATOM    351  N   ASP A  57       0.226  24.513  11.442  1.00 12.63           N  
ATOM    352  CA  ASP A  57      -0.628  25.401  12.228  1.00 12.20           C  
ATOM    353  C   ASP A  57      -1.778  25.999  11.426  1.00 14.49           C  
ATOM    354  O   ASP A  57      -2.395  26.935  11.886  1.00 15.51           O  
ATOM    355  CB  ASP A  57       0.183  26.536  12.912  1.00 12.31           C  
ATOM    356  CG  ASP A  57       0.612  27.615  11.952  1.00 10.28           C  
ATOM    357  OD1 ASP A  57       0.727  27.349  10.720  1.00  7.20           O  
ATOM    358  OD2 ASP A  57       0.811  28.786  12.330  1.00 13.94           O  
ATOM    359  N   GLY A  58      -2.060  25.492  10.232  1.00 14.81           N  
ATOM    360  CA  GLY A  58      -3.084  26.108   9.439  1.00 18.46           C  
ATOM    361  C   GLY A  58      -2.770  26.062   7.968  1.00 21.46           C  
ATOM    362  O   GLY A  58      -1.618  25.811   7.566  1.00 20.55           O  
ATOM    363  N   PRO A  59      -3.798  26.321   7.156  1.00 23.77           N  
ATOM    364  CA  PRO A  59      -3.613  26.457   5.710  1.00 26.38           C  
ATOM    365  C   PRO A  59      -2.943  27.785   5.364  1.00 28.47           C  
ATOM    366  O   PRO A  59      -2.725  28.617   6.258  1.00 28.04           O  
ATOM    367  CB  PRO A  59      -5.050  26.444   5.158  1.00 26.50           C  
ATOM    368  CG  PRO A  59      -5.885  26.909   6.264  1.00 25.75           C  
ATOM    369  CD  PRO A  59      -5.204  26.506   7.568  1.00 23.86           C  
ATOM    370  N   PRO A  60      -2.650  27.995   4.076  1.00 30.73           N  
ATOM    371  CA  PRO A  60      -1.928  29.201   3.601  1.00 31.58           C  
ATOM    372  C   PRO A  60      -2.615  30.588   3.711  1.00 33.04           C  
ATOM    373  O   PRO A  60      -2.945  31.227   2.677  1.00 35.16           O  
ATOM    374  CB  PRO A  60      -1.608  28.855   2.130  1.00 31.81           C  
ATOM    375  CG  PRO A  60      -1.704  27.305   2.076  1.00 30.60           C  
ATOM    376  CD  PRO A  60      -2.934  27.056   2.969  1.00 30.88           C  
ATOM    377  N   GLY A  61      -2.774  31.079   4.941  1.00 32.45           N  
ATOM    378  CA  GLY A  61      -3.261  32.420   5.204  1.00 30.21           C  
ATOM    379  C   GLY A  61      -4.054  32.372   6.491  1.00 29.52           C  
ATOM    380  O   GLY A  61      -4.802  33.305   6.843  1.00 29.41           O  
ATOM    381  N   ALA A  62      -3.888  31.260   7.200  1.00 27.10           N  
ATOM    382  CA  ALA A  62      -4.599  31.036   8.437  1.00 24.90           C  
ATOM    383  C   ALA A  62      -3.741  30.243   9.440  1.00 22.98           C  
ATOM    384  O   ALA A  62      -4.235  29.316  10.136  1.00 20.61           O  
ATOM    385  CB  ALA A  62      -5.934  30.340   8.150  1.00 24.91           C  
ATOM    386  N   GLY A  63      -2.454  30.621   9.537  1.00 21.35           N  
ATOM    387  CA  GLY A  63      -1.589  29.986  10.524  1.00 17.92           C  
ATOM    388  C   GLY A  63      -1.894  30.526  11.886  1.00 17.46           C  
ATOM    389  O   GLY A  63      -1.677  31.720  12.145  1.00 17.94           O  
ATOM    390  N   SER A  64      -2.359  29.662  12.775  1.00 16.09           N  
ATOM    391  CA  SER A  64      -2.812  30.090  14.085  1.00 15.08           C  
ATOM    392  C   SER A  64      -1.685  30.038  15.079  1.00 13.31           C  
ATOM    393  O   SER A  64      -1.860  30.464  16.186  1.00 12.19           O  
ATOM    394  CB  SER A  64      -3.934  29.178  14.580  1.00 14.34           C  
ATOM    395  OG  SER A  64      -3.406  27.892  14.914  1.00 16.34           O  
ATOM    396  N   GLY A  65      -0.529  29.495  14.701  1.00 12.46           N  
ATOM    397  CA  GLY A  65       0.521  29.299  15.678  1.00 12.00           C  
ATOM    398  C   GLY A  65       0.411  28.002  16.466  1.00 11.96           C  
ATOM    399  O   GLY A  65       1.347  27.626  17.135  1.00 11.28           O  
ATOM    400  N   VAL A  66      -0.723  27.294  16.388  1.00 11.63           N  
ATOM    401  CA  VAL A  66      -0.909  26.106  17.240  1.00 11.86           C  
ATOM    402  C   VAL A  66      -0.297  24.918  16.511  1.00 11.39           C  
ATOM    403  O   VAL A  66      -0.740  24.653  15.412  1.00 10.68           O  
ATOM    404  CB  VAL A  66      -2.416  25.723  17.417  1.00 11.80           C  
ATOM    405  CG1 VAL A  66      -2.498  24.375  18.134  1.00 11.35           C  
ATOM    406  CG2 VAL A  66      -3.224  26.841  18.199  1.00 11.70           C  
ATOM    407  N   PRO A  67       0.725  24.238  17.053  1.00 11.97           N  
ATOM    408  CA  PRO A  67       1.305  23.121  16.314  1.00 12.23           C  
ATOM    409  C   PRO A  67       0.358  21.902  16.411  1.00 11.68           C  
ATOM    410  O   PRO A  67       0.245  21.379  17.494  1.00 13.16           O  
ATOM    411  CB  PRO A  67       2.635  22.847  17.059  1.00 11.62           C  
ATOM    412  CG  PRO A  67       2.896  24.130  17.940  1.00 13.07           C  
ATOM    413  CD  PRO A  67       1.440  24.460  18.335  1.00 12.93           C  
ATOM    414  N   TYR A  68      -0.249  21.468  15.306  1.00 11.59           N  
ATOM    415  CA  TYR A  68      -1.045  20.237  15.305  1.00 12.06           C  
ATOM    416  C   TYR A  68      -0.175  19.118  14.778  1.00 11.51           C  
ATOM    417  O   TYR A  68       0.651  19.362  13.916  1.00 12.32           O  
ATOM    418  CB  TYR A  68      -2.270  20.353  14.387  1.00 10.61           C  
ATOM    419  CG  TYR A  68      -3.280  21.373  14.895  1.00 13.98           C  
ATOM    420  CD1 TYR A  68      -3.994  21.149  16.093  1.00 13.35           C  
ATOM    421  CD2 TYR A  68      -3.491  22.570  14.199  1.00 16.02           C  
ATOM    422  CE1 TYR A  68      -4.895  22.091  16.568  1.00 14.94           C  
ATOM    423  CE2 TYR A  68      -4.412  23.537  14.682  1.00 15.98           C  
ATOM    424  CZ  TYR A  68      -5.084  23.276  15.863  1.00 15.37           C  
ATOM    425  OH  TYR A  68      -5.968  24.220  16.334  1.00 17.29           O  
ATOM    426  N   PHE A  69      -0.391  17.911  15.294  1.00 11.64           N  
ATOM    427  CA  PHE A  69       0.341  16.724  14.859  1.00 11.88           C  
ATOM    428  C   PHE A  69      -0.686  15.635  14.504  1.00 12.91           C  
ATOM    429  O   PHE A  69      -1.783  15.592  15.110  1.00 10.73           O  
ATOM    430  CB  PHE A  69       1.198  16.179  16.012  1.00 11.14           C  
ATOM    431  CG  PHE A  69       2.135  17.202  16.646  1.00 12.53           C  
ATOM    432  CD1 PHE A  69       3.238  17.691  15.943  1.00 13.41           C  
ATOM    433  CD2 PHE A  69       1.897  17.670  17.938  1.00 14.40           C  
ATOM    434  CE1 PHE A  69       4.104  18.643  16.514  1.00 14.54           C  
ATOM    435  CE2 PHE A  69       2.761  18.610  18.522  1.00 14.33           C  
ATOM    436  CZ  PHE A  69       3.866  19.092  17.822  1.00 14.27           C  
ATOM    437  N   TYR A  70      -0.289  14.714  13.617  1.00 11.77           N  
ATOM    438  CA  TYR A  70      -1.057  13.487  13.405  1.00 12.53           C  
ATOM    439  C   TYR A  70      -0.212  12.279  13.814  1.00 12.43           C  
ATOM    440  O   TYR A  70       0.781  11.942  13.130  1.00 12.93           O  
ATOM    441  CB  TYR A  70      -1.378  13.410  11.924  1.00 11.14           C  
ATOM    442  CG  TYR A  70      -2.513  12.496  11.496  1.00 14.49           C  
ATOM    443  CD1 TYR A  70      -3.730  12.508  12.138  1.00 14.82           C  
ATOM    444  CD2 TYR A  70      -2.374  11.697  10.352  1.00 13.47           C  
ATOM    445  CE1 TYR A  70      -4.772  11.676  11.705  1.00 15.38           C  
ATOM    446  CE2 TYR A  70      -3.414  10.898   9.909  1.00 15.02           C  
ATOM    447  CZ  TYR A  70      -4.605  10.900  10.580  1.00 18.72           C  
ATOM    448  OH  TYR A  70      -5.629  10.074  10.123  1.00 19.24           O  
ATOM    449  N   LEU A  71      -0.625  11.633  14.894  1.00 12.20           N  
ATOM    450  CA  LEU A  71       0.198  10.700  15.635  1.00 12.92           C  
ATOM    451  C   LEU A  71      -0.435   9.324  15.776  1.00 14.90           C  
ATOM    452  O   LEU A  71      -1.672   9.206  15.806  1.00 15.75           O  
ATOM    453  CB  LEU A  71       0.443  11.276  17.043  1.00 12.65           C  
ATOM    454  CG  LEU A  71       1.111  12.669  17.095  1.00 13.06           C  
ATOM    455  CD1 LEU A  71       1.277  13.065  18.557  1.00 14.50           C  
ATOM    456  CD2 LEU A  71       2.493  12.632  16.381  1.00 13.55           C  
ATOM    457  N   SER A  72       0.404   8.305  15.981  1.00 15.45           N  
ATOM    458  CA  SER A  72      -0.079   6.938  16.191  1.00 15.62           C  
ATOM    459  C   SER A  72       0.485   6.402  17.502  1.00 16.26           C  
ATOM    460  O   SER A  72       1.623   6.750  17.839  1.00 14.97           O  
ATOM    461  CB  SER A  72       0.396   6.072  15.026  1.00 15.56           C  
ATOM    462  OG  SER A  72       0.400   4.717  15.403  1.00 16.71           O  
ATOM    463  N   PRO A  73      -0.301   5.627  18.272  1.00 17.88           N  
ATOM    464  CA  PRO A  73       0.221   4.950  19.473  1.00 19.24           C  
ATOM    465  C   PRO A  73       1.454   4.077  19.193  1.00 19.84           C  
ATOM    466  O   PRO A  73       2.219   3.831  20.121  1.00 21.41           O  
ATOM    467  CB  PRO A  73      -0.943   4.067  19.922  1.00 19.83           C  
ATOM    468  CG  PRO A  73      -2.149   4.778  19.460  1.00 19.61           C  
ATOM    469  CD  PRO A  73      -1.745   5.370  18.100  1.00 18.03           C  
ATOM    470  N   LEU A  74       1.642   3.613  17.958  1.00 19.63           N  
ATOM    471  CA  LEU A  74       2.848   2.869  17.589  1.00 19.85           C  
ATOM    472  C   LEU A  74       4.164   3.700  17.615  1.00 19.85           C  
ATOM    473  O   LEU A  74       5.272   3.131  17.629  1.00 20.00           O  
ATOM    474  CB  LEU A  74       2.665   2.214  16.218  1.00 20.52           C  
ATOM    475  CG  LEU A  74       1.486   1.233  16.099  1.00 22.86           C  
ATOM    476  CD1 LEU A  74       1.470   0.789  14.661  1.00 22.17           C  
ATOM    477  CD2 LEU A  74       1.654   0.032  17.056  1.00 24.58           C  
ATOM    478  N   GLN A  75       4.065   5.024  17.618  1.00 17.90           N  
ATOM    479  CA  GLN A  75       5.297   5.830  17.552  1.00 16.84           C  
ATOM    480  C   GLN A  75       6.013   5.920  18.892  1.00 16.57           C  
ATOM    481  O   GLN A  75       5.370   6.009  19.958  1.00 15.27           O  
ATOM    482  CB  GLN A  75       5.013   7.239  17.066  1.00 15.54           C  
ATOM    483  CG  GLN A  75       4.676   7.357  15.596  1.00 16.63           C  
ATOM    484  CD  GLN A  75       4.222   8.786  15.286  1.00 20.08           C  
ATOM    485  OE1 GLN A  75       3.056   9.087  15.423  1.00 17.67           O  
ATOM    486  NE2 GLN A  75       5.173   9.682  14.960  1.00 18.62           N  
ATOM    487  N   LEU A  76       7.347   5.896  18.838  1.00 15.05           N  
ATOM    488  CA  LEU A  76       8.180   6.064  20.049  1.00 15.38           C  
ATOM    489  C   LEU A  76       7.814   7.356  20.785  1.00 14.75           C  
ATOM    490  O   LEU A  76       7.742   7.370  22.023  1.00 13.00           O  
ATOM    491  CB  LEU A  76       9.668   6.095  19.656  1.00 16.78           C  
ATOM    492  CG  LEU A  76      10.262   4.714  19.242  1.00 19.38           C  
ATOM    493  CD1 LEU A  76      11.770   4.769  19.060  1.00 22.26           C  
ATOM    494  CD2 LEU A  76       9.936   3.646  20.260  1.00 22.90           C  
ATOM    495  N   SER A  77       7.569   8.457  20.052  1.00 13.54           N  
ATOM    496  CA  SER A  77       7.260   9.705  20.765  1.00 14.67           C  
ATOM    497  C   SER A  77       5.965   9.599  21.564  1.00 13.75           C  
ATOM    498  O   SER A  77       5.879  10.152  22.668  1.00 14.19           O  
ATOM    499  CB  SER A  77       7.228  10.936  19.868  1.00 13.48           C  
ATOM    500  OG  SER A  77       8.542  11.189  19.345  1.00 21.24           O  
ATOM    501  N   VAL A  78       4.983   8.896  21.000  1.00 13.76           N  
ATOM    502  CA  VAL A  78       3.629   8.786  21.585  1.00 14.75           C  
ATOM    503  C   VAL A  78       3.671   7.863  22.822  1.00 15.36           C  
ATOM    504  O   VAL A  78       3.095   8.170  23.887  1.00 15.52           O  
ATOM    505  CB  VAL A  78       2.563   8.295  20.521  1.00 14.53           C  
ATOM    506  CG1 VAL A  78       1.203   8.033  21.144  1.00 13.25           C  
ATOM    507  CG2 VAL A  78       2.369   9.329  19.403  1.00 14.87           C  
ATOM    508  N   SER A  79       4.377   6.736  22.713  1.00 16.33           N  
ATOM    509  CA  SER A  79       4.569   5.919  23.910  1.00 16.89           C  
ATOM    510  C   SER A  79       5.235   6.741  25.061  1.00 16.93           C  
ATOM    511  O   SER A  79       4.821   6.646  26.219  1.00 17.21           O  
ATOM    512  CB  SER A  79       5.197   4.564  23.602  1.00 16.23           C  
ATOM    513  OG  SER A  79       6.527   4.747  23.143  0.50 20.86           O  
ATOM    515  N   ASN A  80       6.171   7.618  24.727  1.00 16.84           N  
ATOM    516  CA  ASN A  80       6.747   8.526  25.745  1.00 16.53           C  
ATOM    517  C   ASN A  80       5.691   9.508  26.326  1.00 15.62           C  
ATOM    518  O   ASN A  80       5.596   9.718  27.550  1.00 16.64           O  
ATOM    519  CB  ASN A  80       7.917   9.304  25.132  1.00 13.30           C  
ATOM    520  CG  ASN A  80       9.091   8.416  24.733  1.00 15.36           C  
ATOM    521  OD1 ASN A  80       9.213   7.267  25.163  1.00 11.16           O  
ATOM    522  ND2 ASN A  80       9.981   8.960  23.906  1.00 11.35           N  
ATOM    523  N   LEU A  81       4.872  10.084  25.461  1.00 16.67           N  
ATOM    524  CA  LEU A  81       3.876  11.095  25.907  1.00 17.65           C  
ATOM    525  C   LEU A  81       2.745  10.566  26.759  1.00 19.18           C  
ATOM    526  O   LEU A  81       2.154  11.317  27.546  1.00 19.40           O  
ATOM    527  CB  LEU A  81       3.264  11.866  24.749  1.00 17.06           C  
ATOM    528  CG  LEU A  81       4.267  12.715  23.937  1.00 15.22           C  
ATOM    529  CD1 LEU A  81       3.615  13.053  22.551  1.00 13.99           C  
ATOM    530  CD2 LEU A  81       4.745  13.941  24.648  1.00 10.66           C  
ATOM    531  N   GLN A  82       2.480   9.272  26.630  1.00 20.17           N  
ATOM    532  CA  GLN A  82       1.463   8.594  27.429  1.00 22.07           C  
ATOM    533  C   GLN A  82       1.895   8.537  28.883  1.00 22.32           C  
ATOM    534  O   GLN A  82       1.045   8.665  29.787  1.00 22.48           O  
ATOM    535  CB  GLN A  82       1.224   7.180  26.900  1.00 23.02           C  
ATOM    536  CG  GLN A  82       0.422   7.153  25.580  1.00 27.41           C  
ATOM    537  CD  GLN A  82       0.229   5.727  25.003  1.00 33.90           C  
ATOM    538  OE1 GLN A  82      -0.325   5.563  23.895  1.00 36.22           O  
ATOM    539  NE2 GLN A  82       0.663   4.700  25.761  1.00 36.12           N  
ATOM    540  N   GLU A  83       3.211   8.380  29.096  1.00 21.32           N  
ATOM    541  CA  GLU A  83       3.833   8.408  30.416  1.00 22.45           C  
ATOM    542  C   GLU A  83       4.195   9.779  30.969  1.00 21.71           C  
ATOM    543  O   GLU A  83       4.084   9.971  32.188  1.00 22.32           O  
ATOM    544  CB  GLU A  83       5.074   7.496  30.533  1.00 23.51           C  
ATOM    545  CG  GLU A  83       4.893   6.014  30.212  1.00 29.46           C  
ATOM    546  CD  GLU A  83       3.601   5.394  30.736  1.00 36.29           C  
ATOM    547  OE1 GLU A  83       3.357   5.394  31.965  1.00 39.51           O  
ATOM    548  OE2 GLU A  83       2.830   4.865  29.897  1.00 41.34           O  
ATOM    549  N   ASN A  84       4.671  10.688  30.115  1.00 19.68           N  
ATOM    550  CA  ASN A  84       4.982  12.077  30.481  1.00 19.08           C  
ATOM    551  C   ASN A  84       4.647  12.993  29.268  1.00 18.14           C  
ATOM    552  O   ASN A  84       5.318  12.912  28.248  1.00 17.40           O  
ATOM    553  CB  ASN A  84       6.464  12.188  30.912  1.00 18.68           C  
ATOM    554  CG  ASN A  84       6.869  13.586  31.325  1.00 19.16           C  
ATOM    555  OD1 ASN A  84       6.147  14.558  31.101  1.00 17.78           O  
ATOM    556  ND2 ASN A  84       8.034  13.693  31.955  1.00 20.06           N  
ATOM    557  N   PRO A  85       3.596  13.820  29.375  1.00 17.26           N  
ATOM    558  CA  PRO A  85       3.115  14.600  28.234  1.00 16.92           C  
ATOM    559  C   PRO A  85       3.949  15.846  27.989  1.00 16.31           C  
ATOM    560  O   PRO A  85       3.666  16.514  27.001  1.00 15.33           O  
ATOM    561  CB  PRO A  85       1.673  14.974  28.630  1.00 17.54           C  
ATOM    562  CG  PRO A  85       1.735  15.078  30.193  1.00 17.33           C  
ATOM    563  CD  PRO A  85       2.786  14.065  30.601  1.00 17.49           C  
ATOM    564  N   TYR A  86       4.956  16.117  28.822  1.00 16.05           N  
ATOM    565  CA  TYR A  86       5.829  17.278  28.608  1.00 17.59           C  
ATOM    566  C   TYR A  86       6.723  17.068  27.394  1.00 16.45           C  
ATOM    567  O   TYR A  86       7.312  16.010  27.186  1.00 16.25           O  
ATOM    568  CB  TYR A  86       6.688  17.608  29.819  1.00 18.08           C  
ATOM    569  CG  TYR A  86       5.899  18.177  30.967  1.00 23.45           C  
ATOM    570  CD1 TYR A  86       5.213  19.399  30.827  1.00 24.18           C  
ATOM    571  CD2 TYR A  86       5.830  17.495  32.199  1.00 27.46           C  
ATOM    572  CE1 TYR A  86       4.491  19.924  31.864  1.00 28.25           C  
ATOM    573  CE2 TYR A  86       5.094  18.000  33.238  1.00 29.97           C  
ATOM    574  CZ  TYR A  86       4.432  19.227  33.069  1.00 31.84           C  
ATOM    575  OH  TYR A  86       3.689  19.748  34.108  1.00 36.57           O  
ATOM    576  N   ALA A  87       6.823  18.119  26.600  1.00 16.03           N  
ATOM    577  CA  ALA A  87       7.635  18.056  25.387  1.00 14.20           C  
ATOM    578  C   ALA A  87       8.093  19.448  25.004  1.00 13.43           C  
ATOM    579  O   ALA A  87       7.475  20.435  25.419  1.00 12.33           O  
ATOM    580  CB  ALA A  87       6.819  17.433  24.257  1.00 11.70           C  
ATOM    581  N   THR A  88       9.143  19.496  24.161  1.00 10.91           N  
ATOM    582  CA  THR A  88       9.634  20.737  23.547  1.00 10.64           C  
ATOM    583  C   THR A  88       9.809  20.465  22.071  1.00  9.87           C  
ATOM    584  O   THR A  88      10.399  19.446  21.687  1.00 10.42           O  
ATOM    585  CB  THR A  88      10.987  21.181  24.160  1.00  8.75           C  
ATOM    586  OG1 THR A  88      10.778  21.549  25.535  1.00 13.33           O  
ATOM    587  CG2 THR A  88      11.408  22.477  23.558  1.00  7.23           C  
ATOM    588  N   LEU A  89       9.221  21.327  21.259  1.00  9.19           N  
ATOM    589  CA  LEU A  89       9.342  21.269  19.796  1.00 10.20           C  
ATOM    590  C   LEU A  89      10.367  22.343  19.329  1.00 10.12           C  
ATOM    591  O   LEU A  89      10.288  23.503  19.776  1.00 10.20           O  
ATOM    592  CB  LEU A  89       7.954  21.573  19.196  1.00  9.24           C  
ATOM    593  CG  LEU A  89       7.771  21.692  17.687  1.00  9.37           C  
ATOM    594  CD1 LEU A  89       7.965  20.282  17.138  1.00 12.56           C  
ATOM    595  CD2 LEU A  89       6.428  22.316  17.201  1.00  7.36           C  
ATOM    596  N   THR A  90      11.314  21.984  18.451  1.00  9.85           N  
ATOM    597  CA  THR A  90      12.156  23.019  17.852  1.00  8.52           C  
ATOM    598  C   THR A  90      12.055  23.006  16.353  1.00  8.98           C  
ATOM    599  O   THR A  90      11.924  21.940  15.760  1.00  8.35           O  
ATOM    600  CB  THR A  90      13.652  22.920  18.260  0.50  9.62           C  
ATOM    602  OG1 THR A  90      14.208  21.650  17.861  0.50 10.12           O  
ATOM    604  CG2 THR A  90      13.735  22.887  19.707  0.50 12.65           C  
HETATM  606  N   MSE A  91      12.154  24.199  15.758  1.00  9.10           N  
HETATM  607  CA  MSE A  91      12.020  24.395  14.333  1.00 10.49           C  
HETATM  608  C   MSE A  91      13.041  25.457  13.955  1.00 10.83           C  
HETATM  609  O   MSE A  91      13.268  26.371  14.744  1.00 11.90           O  
HETATM  610  CB  MSE A  91      10.594  24.870  14.009  1.00  9.14           C  
HETATM  611  CG  MSE A  91       9.559  23.745  14.164  1.00  9.57           C  
HETATM  612 SE   MSE A  91       7.798  24.620  14.207  1.00 20.72          SE  
HETATM  613  CE  MSE A  91       7.980  25.548  15.942  1.00 11.39           C  
ATOM    614  N   THR A  92      13.635  25.327  12.769  1.00 10.21           N  
ATOM    615  CA  THR A  92      14.674  26.272  12.302  1.00  9.47           C  
ATOM    616  C   THR A  92      14.399  26.700  10.854  1.00 10.21           C  
ATOM    617  O   THR A  92      13.911  25.910  10.046  1.00  9.47           O  
ATOM    618  CB  THR A  92      16.084  25.653  12.418  1.00  9.80           C  
ATOM    619  OG1 THR A  92      17.043  26.418  11.665  1.00 11.09           O  
ATOM    620  CG2 THR A  92      16.150  24.266  11.721  1.00  7.97           C  
ATOM    621  N   LEU A  93      14.755  27.943  10.511  1.00  9.24           N  
ATOM    622  CA  LEU A  93      14.632  28.361   9.133  1.00  9.22           C  
ATOM    623  C   LEU A  93      15.625  27.626   8.197  1.00  9.53           C  
ATOM    624  O   LEU A  93      15.514  27.754   6.973  1.00 10.19           O  
ATOM    625  CB  LEU A  93      14.779  29.904   9.015  1.00  8.62           C  
ATOM    626  CG  LEU A  93      13.656  30.698   9.701  1.00 10.66           C  
ATOM    627  CD1 LEU A  93      13.796  32.197   9.551  1.00  7.68           C  
ATOM    628  CD2 LEU A  93      12.249  30.242   9.213  1.00 11.77           C  
ATOM    629  N   ALA A  94      16.562  26.872   8.785  1.00 10.31           N  
ATOM    630  CA  ALA A  94      17.486  26.009   8.050  1.00 10.39           C  
ATOM    631  C   ALA A  94      16.706  24.867   7.375  1.00 11.35           C  
ATOM    632  O   ALA A  94      17.209  24.173   6.517  1.00 12.09           O  
ATOM    633  CB  ALA A  94      18.582  25.483   8.982  1.00 10.57           C  
ATOM    634  N   GLN A  95      15.426  24.710   7.733  1.00 11.38           N  
ATOM    635  CA  GLN A  95      14.511  23.818   7.003  1.00 10.49           C  
ATOM    636  C   GLN A  95      14.092  24.343   5.614  1.00 12.93           C  
ATOM    637  O   GLN A  95      13.596  23.572   4.767  1.00 11.40           O  
ATOM    638  CB  GLN A  95      13.241  23.582   7.875  1.00 10.98           C  
ATOM    639  CG  GLN A  95      13.589  22.711   9.095  1.00  8.40           C  
ATOM    640  CD  GLN A  95      12.508  22.721  10.190  1.00 12.11           C  
ATOM    641  OE1 GLN A  95      12.831  22.880  11.355  1.00 10.62           O  
ATOM    642  NE2 GLN A  95      11.251  22.454   9.810  1.00 10.53           N  
ATOM    643  N   THR A  96      14.211  25.660   5.420  1.00 13.62           N  
ATOM    644  CA  THR A  96      14.059  26.298   4.106  1.00 15.31           C  
ATOM    645  C   THR A  96      15.415  26.672   3.537  1.00 16.11           C  
ATOM    646  O   THR A  96      16.457  26.323   4.103  1.00 15.40           O  
ATOM    647  CB  THR A  96      13.222  27.590   4.217  1.00 15.27           C  
ATOM    648  OG1 THR A  96      13.926  28.578   4.966  1.00 15.26           O  
ATOM    649  CG2 THR A  96      11.949  27.395   5.066  1.00 15.68           C  
ATOM    650  N   ASN A  97      15.418  27.411   2.427  1.00 16.18           N  
ATOM    651  CA  ASN A  97      16.700  27.863   1.861  1.00 18.87           C  
ATOM    652  C   ASN A  97      17.128  29.210   2.471  1.00 17.98           C  
ATOM    653  O   ASN A  97      18.147  29.791   2.073  1.00 18.62           O  
ATOM    654  CB  ASN A  97      16.587  27.968   0.327  1.00 19.50           C  
ATOM    655  CG  ASN A  97      17.939  28.230  -0.358  1.00 26.52           C  
ATOM    656  OD1 ASN A  97      18.946  27.525  -0.120  1.00 31.52           O  
ATOM    657  ND2 ASN A  97      17.960  29.245  -1.243  1.00 30.69           N  
ATOM    658  N   PHE A  98      16.348  29.703   3.430  1.00 16.08           N  
ATOM    659  CA  PHE A  98      16.639  31.015   4.007  1.00 16.48           C  
ATOM    660  C   PHE A  98      18.086  31.168   4.508  1.00 14.92           C  
ATOM    661  O   PHE A  98      18.726  32.187   4.237  1.00 14.89           O  
ATOM    662  CB  PHE A  98      15.654  31.326   5.124  1.00 16.48           C  
ATOM    663  CG  PHE A  98      15.913  32.638   5.845  1.00 16.41           C  
ATOM    664  CD1 PHE A  98      15.307  33.820   5.408  1.00 15.01           C  
ATOM    665  CD2 PHE A  98      16.682  32.660   6.988  1.00 13.89           C  
ATOM    666  CE1 PHE A  98      15.502  35.018   6.079  1.00 17.26           C  
ATOM    667  CE2 PHE A  98      16.860  33.840   7.681  1.00 15.18           C  
ATOM    668  CZ  PHE A  98      16.266  35.024   7.240  1.00 16.24           C  
ATOM    669  N   CYS A  99      18.577  30.201   5.271  1.00 14.35           N  
ATOM    670  CA  CYS A  99      19.872  30.373   5.924  1.00 14.61           C  
ATOM    671  C   CYS A  99      21.037  30.249   4.930  1.00 17.41           C  
ATOM    672  O   CYS A  99      22.057  30.985   5.032  1.00 18.07           O  
ATOM    673  CB  CYS A  99      20.029  29.431   7.118  1.00 14.54           C  
ATOM    674  SG  CYS A  99      18.688  29.718   8.322  1.00 13.25           S  
ATOM    675  N   LYS A 100      20.869  29.337   3.970  1.00 17.48           N  
ATOM    676  CA  LYS A 100      21.874  29.148   2.936  1.00 20.23           C  
ATOM    677  C   LYS A 100      21.964  30.409   2.070  1.00 20.02           C  
ATOM    678  O   LYS A 100      23.027  30.909   1.872  1.00 21.45           O  
ATOM    679  CB  LYS A 100      21.551  27.904   2.100  1.00 20.26           C  
ATOM    680  CG  LYS A 100      21.870  26.579   2.837  1.00 24.82           C  
ATOM    681  CD  LYS A 100      22.916  25.756   2.086  1.00 30.39           C  
ATOM    682  CE  LYS A 100      23.266  24.439   2.820  1.00 32.31           C  
ATOM    683  NZ  LYS A 100      24.713  24.346   3.265  1.00 35.26           N  
ATOM    684  N   LYS A 101      20.836  30.948   1.617  1.00 20.58           N  
ATOM    685  CA  LYS A 101      20.823  32.113   0.724  1.00 20.97           C  
ATOM    686  C   LYS A 101      21.444  33.387   1.340  1.00 21.30           C  
ATOM    687  O   LYS A 101      22.112  34.181   0.654  1.00 19.92           O  
ATOM    688  CB  LYS A 101      19.392  32.341   0.174  0.50 21.96           C  
ATOM    690  CG  LYS A 101      18.582  33.540   0.750  0.50 22.41           C  
ATOM    692  CD  LYS A 101      17.724  34.247  -0.319  0.50 23.81           C  
ATOM    694  CE  LYS A 101      18.572  35.131  -1.296  0.50 25.27           C  
ATOM    696  NZ  LYS A 101      18.140  36.570  -1.339  0.50 24.61           N  
ATOM    698  N   HIS A 102      21.257  33.546   2.648  1.00 20.03           N  
ATOM    699  CA  HIS A 102      21.756  34.690   3.380  1.00 19.62           C  
ATOM    700  C   HIS A 102      23.114  34.436   4.012  1.00 19.08           C  
ATOM    701  O   HIS A 102      23.699  35.339   4.590  1.00 19.88           O  
ATOM    702  CB  HIS A 102      20.761  35.057   4.476  1.00 18.46           C  
ATOM    703  CG  HIS A 102      19.500  35.669   3.951  1.00 22.15           C  
ATOM    704  ND1 HIS A 102      19.472  36.898   3.316  1.00 24.46           N  
ATOM    705  CD2 HIS A 102      18.223  35.211   3.941  1.00 23.27           C  
ATOM    706  CE1 HIS A 102      18.229  37.175   2.954  1.00 24.54           C  
ATOM    707  NE2 HIS A 102      17.455  36.165   3.312  1.00 22.48           N  
ATOM    708  N   GLY A 103      23.617  33.214   3.929  1.00 18.27           N  
ATOM    709  CA  GLY A 103      24.925  32.941   4.500  1.00 17.63           C  
ATOM    710  C   GLY A 103      24.894  32.975   6.030  1.00 17.24           C  
ATOM    711  O   GLY A 103      25.854  33.456   6.675  1.00 17.42           O  
ATOM    712  N   PHE A 104      23.817  32.434   6.612  1.00 14.11           N  
ATOM    713  CA  PHE A 104      23.778  32.269   8.065  1.00 13.66           C  
ATOM    714  C   PHE A 104      23.962  30.781   8.378  1.00 13.81           C  
ATOM    715  O   PHE A 104      23.115  29.944   7.989  1.00 13.13           O  
ATOM    716  CB  PHE A 104      22.435  32.690   8.647  1.00 11.71           C  
ATOM    717  CG  PHE A 104      21.989  34.096   8.302  1.00 13.59           C  
ATOM    718  CD1 PHE A 104      22.908  35.160   8.170  1.00 12.40           C  
ATOM    719  CD2 PHE A 104      20.618  34.378   8.201  1.00 10.47           C  
ATOM    720  CE1 PHE A 104      22.445  36.485   7.925  1.00 14.32           C  
ATOM    721  CE2 PHE A 104      20.168  35.674   7.945  1.00 10.44           C  
ATOM    722  CZ  PHE A 104      21.099  36.730   7.807  1.00 15.17           C  
ATOM    723  N   ASP A 105      25.034  30.447   9.095  1.00 12.99           N  
ATOM    724  CA  ASP A 105      25.224  29.063   9.569  1.00 12.94           C  
ATOM    725  C   ASP A 105      23.991  28.617  10.340  1.00 11.97           C  
ATOM    726  O   ASP A 105      23.367  29.448  11.038  1.00 10.87           O  
ATOM    727  CB  ASP A 105      26.400  29.003  10.542  1.00 13.11           C  
ATOM    728  CG  ASP A 105      26.838  27.586  10.822  1.00 12.76           C  
ATOM    729  OD1 ASP A 105      26.495  27.097  11.901  1.00 11.20           O  
ATOM    730  OD2 ASP A 105      27.560  26.897  10.017  1.00 15.92           O  
ATOM    731  N   PRO A 106      23.611  27.334  10.251  1.00 11.13           N  
ATOM    732  CA  PRO A 106      22.430  26.873  10.998  1.00 10.96           C  
ATOM    733  C   PRO A 106      22.445  27.185  12.496  1.00 10.31           C  
ATOM    734  O   PRO A 106      21.367  27.270  13.061  1.00 11.50           O  
ATOM    735  CB  PRO A 106      22.416  25.369  10.770  1.00 10.30           C  
ATOM    736  CG  PRO A 106      23.093  25.182   9.392  1.00 12.00           C  
ATOM    737  CD  PRO A 106      24.130  26.296   9.339  1.00 11.82           C  
ATOM    738  N   GLN A 107      23.612  27.309  13.127  1.00  9.86           N  
ATOM    739  CA  GLN A 107      23.716  27.595  14.564  1.00  8.79           C  
ATOM    740  C   GLN A 107      23.902  29.093  14.870  1.00  9.64           C  
ATOM    741  O   GLN A 107      23.868  29.524  16.052  1.00  8.72           O  
ATOM    742  CB  GLN A 107      24.835  26.750  15.202  1.00  8.86           C  
ATOM    743  CG  GLN A 107      24.797  26.635  16.730  1.00 11.64           C  
ATOM    744  CD  GLN A 107      25.906  25.748  17.267  1.00 10.91           C  
ATOM    745  OE1 GLN A 107      26.157  24.635  16.740  1.00  9.25           O  
ATOM    746  NE2 GLN A 107      26.554  26.204  18.342  1.00 11.79           N  
ATOM    747  N   SER A 108      24.062  29.923  13.838  1.00  9.68           N  
ATOM    748  CA  SER A 108      23.959  31.374  14.053  1.00 10.83           C  
ATOM    749  C   SER A 108      22.504  31.754  14.426  1.00 11.10           C  
ATOM    750  O   SER A 108      21.575  31.296  13.740  1.00 11.76           O  
ATOM    751  CB  SER A 108      24.280  32.134  12.802  1.00 11.85           C  
ATOM    752  OG  SER A 108      24.017  33.510  13.033  1.00 11.59           O  
ATOM    753  N   PRO A 109      22.307  32.604  15.442  1.00 10.95           N  
ATOM    754  CA  PRO A 109      20.936  33.042  15.799  1.00 10.95           C  
ATOM    755  C   PRO A 109      20.301  33.776  14.639  1.00 10.89           C  
ATOM    756  O   PRO A 109      19.084  33.893  14.581  1.00 11.16           O  
ATOM    757  CB  PRO A 109      21.139  33.982  17.006  1.00 11.06           C  
ATOM    758  CG  PRO A 109      22.627  34.454  16.936  1.00 10.63           C  
ATOM    759  CD  PRO A 109      23.349  33.218  16.301  1.00 10.93           C  
ATOM    760  N   LEU A 110      21.105  34.246  13.676  1.00 11.04           N  
ATOM    761  CA  LEU A 110      20.496  34.848  12.488  1.00 11.01           C  
ATOM    762  C   LEU A 110      19.750  33.817  11.658  1.00 10.91           C  
ATOM    763  O   LEU A 110      18.817  34.163  10.948  1.00 10.74           O  
ATOM    764  CB  LEU A 110      21.520  35.611  11.616  1.00 11.12           C  
ATOM    765  CG  LEU A 110      21.923  37.019  12.103  1.00 10.70           C  
ATOM    766  CD1 LEU A 110      20.756  38.003  12.143  1.00 16.09           C  
ATOM    767  CD2 LEU A 110      22.605  36.944  13.458  1.00 16.44           C  
ATOM    768  N   CYS A 111      20.174  32.549  11.747  1.00 10.81           N  
ATOM    769  CA  CYS A 111      19.397  31.463  11.156  1.00 10.59           C  
ATOM    770  C   CYS A 111      18.339  31.107  12.202  1.00  9.48           C  
ATOM    771  O   CYS A 111      18.563  30.251  13.102  1.00  9.75           O  
ATOM    772  CB  CYS A 111      20.268  30.245  10.809  1.00 10.64           C  
ATOM    773  SG  CYS A 111      19.251  28.929  10.088  1.00 10.50           S  
ATOM    774  N   VAL A 112      17.211  31.804  12.118  1.00  8.75           N  
ATOM    775  CA  VAL A 112      16.259  31.743  13.226  1.00  8.19           C  
ATOM    776  C   VAL A 112      15.865  30.322  13.624  1.00  8.17           C  
ATOM    777  O   VAL A 112      15.502  29.484  12.781  1.00  8.28           O  
ATOM    778  CB  VAL A 112      14.983  32.614  12.966  1.00  9.21           C  
ATOM    779  CG1 VAL A 112      14.060  32.558  14.204  1.00  6.28           C  
ATOM    780  CG2 VAL A 112      15.381  34.068  12.667  1.00  6.56           C  
ATOM    781  N   HIS A 113      16.009  30.003  14.909  1.00  9.42           N  
ATOM    782  CA  HIS A 113      15.330  28.855  15.417  1.00  9.99           C  
ATOM    783  C   HIS A 113      14.571  29.186  16.724  1.00 10.12           C  
ATOM    784  O   HIS A 113      14.918  30.118  17.489  1.00  9.28           O  
ATOM    785  CB  HIS A 113      16.269  27.647  15.611  0.50 10.57           C  
ATOM    787  CG  HIS A 113      17.222  27.782  16.767  0.50 12.15           C  
ATOM    789  ND1 HIS A 113      18.335  28.597  16.725  0.50 13.73           N  
ATOM    791  CD2 HIS A 113      17.243  27.183  17.981  0.50 14.75           C  
ATOM    793  CE1 HIS A 113      18.999  28.490  17.862  0.50 15.73           C  
ATOM    795  NE2 HIS A 113      18.349  27.652  18.649  0.50 14.57           N  
ATOM    797  N   ILE A 114      13.507  28.432  16.937  1.00  9.09           N  
ATOM    798  CA  ILE A 114      12.664  28.649  18.122  1.00  7.92           C  
ATOM    799  C   ILE A 114      12.457  27.321  18.856  1.00 10.45           C  
ATOM    800  O   ILE A 114      12.576  26.239  18.256  1.00  8.79           O  
ATOM    801  CB  ILE A 114      11.323  29.334  17.763  1.00  9.28           C  
ATOM    802  CG1 ILE A 114      10.306  28.367  17.148  1.00  7.87           C  
ATOM    803  CG2 ILE A 114      11.507  30.609  16.812  1.00  6.20           C  
ATOM    804  CD1 ILE A 114       8.938  29.025  16.882  1.00  9.43           C  
HETATM  805  N   MSE A 115      12.139  27.407  20.144  1.00  9.01           N  
HETATM  806  CA  MSE A 115      11.753  26.242  20.914  1.00 11.10           C  
HETATM  807  C   MSE A 115      10.426  26.566  21.583  1.00 10.24           C  
HETATM  808  O   MSE A 115      10.298  27.636  22.162  1.00 11.36           O  
HETATM  809  CB  MSE A 115      12.806  25.889  21.978  1.00 11.71           C  
HETATM  810  CG  MSE A 115      14.154  25.516  21.404  1.00 18.66           C  
HETATM  811 SE   MSE A 115      15.196  27.140  21.082  1.00 35.76          SE  
HETATM  812  CE  MSE A 115      16.709  26.636  22.252  1.00 28.60           C  
ATOM    813  N   LEU A 116       9.450  25.661  21.453  1.00 11.54           N  
ATOM    814  CA  LEU A 116       8.125  25.800  22.073  1.00 12.23           C  
ATOM    815  C   LEU A 116       7.963  24.632  22.976  1.00 13.35           C  
ATOM    816  O   LEU A 116       7.997  23.485  22.526  1.00 13.64           O  
ATOM    817  CB  LEU A 116       6.976  25.788  21.042  1.00 12.72           C  
ATOM    818  CG  LEU A 116       7.128  26.708  19.849  1.00 12.05           C  
ATOM    819  CD1 LEU A 116       6.013  26.377  18.887  1.00 11.79           C  
ATOM    820  CD2 LEU A 116       7.085  28.189  20.262  1.00 12.12           C  
ATOM    821  N   SER A 117       7.825  24.934  24.268  1.00 13.87           N  
ATOM    822  CA  SER A 117       7.770  23.918  25.290  1.00 14.73           C  
ATOM    823  C   SER A 117       6.385  23.918  25.950  1.00 15.12           C  
ATOM    824  O   SER A 117       5.752  24.980  26.082  1.00 14.37           O  
ATOM    825  CB  SER A 117       8.884  24.149  26.327  1.00 13.97           C  
ATOM    826  OG  SER A 117       9.047  22.963  27.107  1.00 20.35           O  
ATOM    827  N   GLY A 118       5.917  22.729  26.359  1.00 15.42           N  
ATOM    828  CA  GLY A 118       4.578  22.578  26.912  1.00 15.87           C  
ATOM    829  C   GLY A 118       4.194  21.095  27.068  1.00 16.15           C  
ATOM    830  O   GLY A 118       5.091  20.254  27.338  1.00 16.33           O  
ATOM    831  N   THR A 119       2.916  20.776  26.830  1.00 14.23           N  
ATOM    832  CA  THR A 119       2.455  19.402  26.763  1.00 14.07           C  
ATOM    833  C   THR A 119       1.813  19.069  25.436  1.00 14.64           C  
ATOM    834  O   THR A 119       1.184  19.906  24.789  1.00 16.14           O  
ATOM    835  CB  THR A 119       1.460  19.044  27.924  1.00 13.27           C  
ATOM    836  OG1 THR A 119       0.341  19.925  27.859  1.00 17.97           O  
ATOM    837  CG2 THR A 119       2.122  19.358  29.291  1.00  9.28           C  
ATOM    838  N   VAL A 120       1.933  17.808  25.046  1.00 14.37           N  
ATOM    839  CA  VAL A 120       1.210  17.355  23.875  1.00 14.58           C  
ATOM    840  C   VAL A 120      -0.019  16.608  24.365  1.00 15.43           C  
ATOM    841  O   VAL A 120       0.111  15.687  25.179  1.00 15.53           O  
ATOM    842  CB  VAL A 120       2.036  16.451  22.975  1.00 15.19           C  
ATOM    843  CG1 VAL A 120       1.174  15.993  21.799  1.00 11.66           C  
ATOM    844  CG2 VAL A 120       3.273  17.191  22.475  1.00 12.90           C  
ATOM    845  N   THR A 121      -1.185  16.991  23.864  1.00 16.71           N  
ATOM    846  CA  THR A 121      -2.433  16.281  24.215  1.00 17.89           C  
ATOM    847  C   THR A 121      -3.232  15.959  22.966  1.00 18.22           C  
ATOM    848  O   THR A 121      -3.004  16.525  21.872  1.00 18.83           O  
ATOM    849  CB  THR A 121      -3.334  17.128  25.125  1.00 17.90           C  
ATOM    850  OG1 THR A 121      -3.470  18.430  24.548  1.00 18.53           O  
ATOM    851  CG2 THR A 121      -2.743  17.351  26.534  1.00 19.86           C  
ATOM    852  N   LYS A 122      -4.188  15.047  23.132  1.00 19.26           N  
ATOM    853  CA  LYS A 122      -5.166  14.741  22.094  1.00 20.69           C  
ATOM    854  C   LYS A 122      -6.085  15.943  21.939  1.00 21.22           C  
ATOM    855  O   LYS A 122      -6.448  16.570  22.913  1.00 21.32           O  
ATOM    856  CB  LYS A 122      -5.985  13.489  22.458  1.00 21.67           C  
ATOM    857  CG  LYS A 122      -5.150  12.191  22.525  1.00 24.50           C  
ATOM    858  CD  LYS A 122      -6.037  10.931  22.529  1.00 28.85           C  
ATOM    859  CE  LYS A 122      -5.202   9.656  22.416  1.00 33.34           C  
ATOM    860  NZ  LYS A 122      -6.042   8.499  21.869  1.00 36.64           N  
ATOM    861  N   VAL A 123      -6.405  16.279  20.701  1.00 21.97           N  
ATOM    862  CA  VAL A 123      -7.261  17.407  20.400  1.00 23.58           C  
ATOM    863  C   VAL A 123      -8.728  17.079  20.792  1.00 25.89           C  
ATOM    864  O   VAL A 123      -9.192  15.942  20.602  1.00 25.87           O  
ATOM    865  CB  VAL A 123      -7.092  17.788  18.914  1.00 22.60           C  
ATOM    866  CG1 VAL A 123      -8.181  18.659  18.441  1.00 22.45           C  
ATOM    867  CG2 VAL A 123      -5.681  18.494  18.672  1.00 19.69           C  
ATOM    868  N   ASN A 124      -9.410  18.076  21.366  1.00 27.97           N  
ATOM    869  CA  ASN A 124     -10.870  18.072  21.586  1.00 30.15           C  
ATOM    870  C   ASN A 124     -11.735  17.810  20.384  1.00 29.99           C  
ATOM    871  O   ASN A 124     -11.375  18.187  19.270  1.00 29.63           O  
ATOM    872  CB  ASN A 124     -11.316  19.455  22.111  1.00 31.61           C  
ATOM    873  CG  ASN A 124     -11.128  19.580  23.593  1.00 34.03           C  
ATOM    874  OD1 ASN A 124     -10.911  18.570  24.276  1.00 39.08           O  
ATOM    875  ND2 ASN A 124     -11.151  20.817  24.106  1.00 36.17           N  
ATOM    876  N   GLU A 125     -12.929  17.242  20.632  1.00 30.92           N  
ATOM    877  CA  GLU A 125     -13.962  17.101  19.603  1.00 30.62           C  
ATOM    878  C   GLU A 125     -14.176  18.386  18.823  1.00 29.63           C  
ATOM    879  O   GLU A 125     -14.155  18.357  17.591  1.00 28.98           O  
ATOM    880  CB  GLU A 125     -15.314  16.647  20.202  1.00 32.54           C  
ATOM    881  CG  GLU A 125     -15.674  15.209  19.858  1.00 36.29           C  
ATOM    882  CD  GLU A 125     -17.140  15.038  19.475  1.00 42.91           C  
ATOM    883  OE1 GLU A 125     -18.035  15.390  20.295  1.00 46.83           O  
ATOM    884  OE2 GLU A 125     -17.406  14.539  18.356  1.00 44.82           O  
ATOM    885  N   THR A 126     -14.355  19.512  19.525  1.00 28.39           N  
ATOM    886  CA  THR A 126     -14.632  20.792  18.840  1.00 28.36           C  
ATOM    887  C   THR A 126     -13.466  21.323  17.979  1.00 27.43           C  
ATOM    888  O   THR A 126     -13.680  22.116  17.050  1.00 27.17           O  
ATOM    889  CB  THR A 126     -15.175  21.898  19.835  1.00 29.10           C  
ATOM    890  OG1 THR A 126     -14.324  22.017  20.986  1.00 29.02           O  
ATOM    891  CG2 THR A 126     -16.570  21.455  20.447  1.00 29.68           C  
ATOM    892  N   GLU A 127     -12.243  20.873  18.272  1.00 26.86           N  
ATOM    893  CA  GLU A 127     -11.041  21.333  17.556  1.00 24.99           C  
ATOM    894  C   GLU A 127     -10.478  20.315  16.542  1.00 25.03           C  
ATOM    895  O   GLU A 127      -9.565  20.630  15.761  1.00 21.81           O  
ATOM    896  CB  GLU A 127      -9.991  21.822  18.568  1.00 25.67           C  
ATOM    897  CG  GLU A 127      -8.734  22.441  17.969  1.00 25.21           C  
ATOM    898  CD  GLU A 127      -7.798  23.036  18.994  1.00 27.51           C  
ATOM    899  OE1 GLU A 127      -7.982  22.777  20.208  1.00 26.82           O  
ATOM    900  OE2 GLU A 127      -6.864  23.778  18.565  1.00 24.50           O  
HETATM  901  N   MSE A 128     -11.041  19.099  16.514  1.00 25.25           N  
HETATM  902  CA  MSE A 128     -10.576  18.076  15.549  1.00 25.51           C  
HETATM  903  C   MSE A 128     -10.606  18.542  14.091  1.00 23.80           C  
HETATM  904  O   MSE A 128      -9.673  18.242  13.304  1.00 22.24           O  
HETATM  905  CB  MSE A 128     -11.392  16.791  15.701  0.50 26.35           C  
HETATM  907  CG  MSE A 128     -11.554  15.960  14.446  0.50 30.48           C  
HETATM  909 SE   MSE A 128     -12.041  14.132  14.891  0.50 45.46          SE  
HETATM  911  CE  MSE A 128     -11.721  13.289  13.121  0.50 41.18           C  
ATOM    913  N   ASP A 129     -11.662  19.273  13.714  1.00 21.42           N  
ATOM    914  CA  ASP A 129     -11.810  19.616  12.320  1.00 20.52           C  
ATOM    915  C   ASP A 129     -10.758  20.622  11.881  1.00 19.12           C  
ATOM    916  O   ASP A 129     -10.190  20.480  10.805  1.00 18.89           O  
ATOM    917  CB  ASP A 129     -13.211  20.133  11.942  1.00 20.65           C  
ATOM    918  CG  ASP A 129     -13.465  20.016  10.468  1.00 22.54           C  
ATOM    919  OD1 ASP A 129     -13.537  18.843   9.998  1.00 26.37           O  
ATOM    920  OD2 ASP A 129     -13.570  21.004   9.683  1.00 17.28           O  
ATOM    921  N   ILE A 130     -10.525  21.639  12.712  1.00 18.76           N  
ATOM    922  CA  ILE A 130      -9.496  22.615  12.389  1.00 18.06           C  
ATOM    923  C   ILE A 130      -8.093  21.934  12.332  1.00 16.43           C  
ATOM    924  O   ILE A 130      -7.354  22.177  11.395  1.00 16.57           O  
ATOM    925  CB  ILE A 130      -9.604  23.931  13.272  1.00 18.97           C  
ATOM    926  CG1 ILE A 130      -8.699  25.043  12.734  1.00 21.59           C  
ATOM    927  CG2 ILE A 130      -9.275  23.722  14.705  1.00 17.89           C  
ATOM    928  CD1 ILE A 130      -8.823  26.395  13.613  1.00 21.51           C  
ATOM    929  N   ALA A 131      -7.803  21.022  13.262  1.00 16.36           N  
ATOM    930  CA  ALA A 131      -6.534  20.253  13.238  1.00 16.57           C  
ATOM    931  C   ALA A 131      -6.408  19.445  11.954  1.00 15.53           C  
ATOM    932  O   ALA A 131      -5.356  19.435  11.270  1.00 15.73           O  
ATOM    933  CB  ALA A 131      -6.484  19.344  14.426  1.00 16.26           C  
ATOM    934  N   LYS A 132      -7.512  18.787  11.592  1.00 15.26           N  
ATOM    935  CA  LYS A 132      -7.555  17.954  10.409  1.00 14.83           C  
ATOM    936  C   LYS A 132      -7.370  18.761   9.174  1.00 15.71           C  
ATOM    937  O   LYS A 132      -6.563  18.412   8.282  1.00 14.17           O  
ATOM    938  CB  LYS A 132      -8.891  17.189  10.329  1.00 15.36           C  
ATOM    939  CG  LYS A 132      -8.976  16.277   9.112  1.00 18.33           C  
ATOM    940  CD  LYS A 132     -10.234  15.407   9.068  1.00 22.03           C  
ATOM    941  CE  LYS A 132     -10.371  14.815   7.637  1.00 26.82           C  
ATOM    942  NZ  LYS A 132     -11.783  14.400   7.195  1.00 31.94           N  
ATOM    943  N   HIS A 133      -8.131  19.843   9.075  1.00 15.01           N  
ATOM    944  CA  HIS A 133      -8.003  20.704   7.916  1.00 16.44           C  
ATOM    945  C   HIS A 133      -6.547  21.280   7.832  1.00 16.09           C  
ATOM    946  O   HIS A 133      -5.926  21.260   6.768  1.00 17.23           O  
ATOM    947  CB  HIS A 133      -9.093  21.819   8.000  1.00 17.53           C  
ATOM    948  CG  HIS A 133      -9.092  22.763   6.840  1.00 21.50           C  
ATOM    949  ND1 HIS A 133      -9.259  22.343   5.533  1.00 24.85           N  
ATOM    950  CD2 HIS A 133      -8.976  24.118   6.791  1.00 22.54           C  
ATOM    951  CE1 HIS A 133      -9.250  23.396   4.732  1.00 23.07           C  
ATOM    952  NE2 HIS A 133      -9.072  24.482   5.467  1.00 25.06           N  
ATOM    953  N   SER A 134      -6.029  21.784   8.955  1.00 15.47           N  
ATOM    954  CA  SER A 134      -4.663  22.331   9.017  1.00 15.40           C  
ATOM    955  C   SER A 134      -3.628  21.307   8.514  1.00 15.08           C  
ATOM    956  O   SER A 134      -2.825  21.603   7.592  1.00 15.53           O  
ATOM    957  CB  SER A 134      -4.341  22.795  10.454  1.00 15.09           C  
ATOM    958  OG  SER A 134      -5.166  23.898  10.820  1.00 17.40           O  
ATOM    959  N   LEU A 135      -3.699  20.091   9.061  1.00 13.70           N  
ATOM    960  CA  LEU A 135      -2.728  19.025   8.748  1.00 14.06           C  
ATOM    961  C   LEU A 135      -2.880  18.462   7.316  1.00 14.31           C  
ATOM    962  O   LEU A 135      -1.927  18.408   6.548  1.00 13.52           O  
ATOM    963  CB  LEU A 135      -2.843  17.918   9.808  1.00 13.16           C  
ATOM    964  CG  LEU A 135      -2.161  18.216  11.167  1.00 13.03           C  
ATOM    965  CD1 LEU A 135      -2.771  17.356  12.236  1.00 10.08           C  
ATOM    966  CD2 LEU A 135      -0.619  18.000  11.196  1.00 12.51           C  
ATOM    967  N   PHE A 136      -4.114  18.127   6.929  1.00 13.55           N  
ATOM    968  CA  PHE A 136      -4.335  17.412   5.660  1.00 14.16           C  
ATOM    969  C   PHE A 136      -4.074  18.296   4.434  1.00 13.75           C  
ATOM    970  O   PHE A 136      -3.617  17.847   3.405  1.00 14.54           O  
ATOM    971  CB  PHE A 136      -5.755  16.777   5.648  1.00 14.65           C  
ATOM    972  CG  PHE A 136      -5.864  15.481   6.465  1.00 16.15           C  
ATOM    973  CD1 PHE A 136      -6.965  14.621   6.284  1.00 17.70           C  
ATOM    974  CD2 PHE A 136      -4.890  15.130   7.417  1.00 15.87           C  
ATOM    975  CE1 PHE A 136      -7.099  13.435   7.034  1.00 20.17           C  
ATOM    976  CE2 PHE A 136      -5.013  13.941   8.210  1.00 16.08           C  
ATOM    977  CZ  PHE A 136      -6.107  13.077   7.996  1.00 19.68           C  
ATOM    978  N   ILE A 137      -4.343  19.582   4.555  1.00 15.02           N  
ATOM    979  CA  ILE A 137      -4.008  20.528   3.521  1.00 15.81           C  
ATOM    980  C   ILE A 137      -2.467  20.692   3.388  1.00 15.69           C  
ATOM    981  O   ILE A 137      -1.919  20.710   2.271  1.00 15.14           O  
ATOM    982  CB  ILE A 137      -4.741  21.885   3.822  1.00 16.53           C  
ATOM    983  CG1 ILE A 137      -6.192  21.820   3.345  1.00 20.37           C  
ATOM    984  CG2 ILE A 137      -4.030  23.090   3.205  1.00 18.22           C  
ATOM    985  CD1 ILE A 137      -6.347  21.674   1.845  1.00 23.47           C  
ATOM    986  N   ARG A 138      -1.777  20.785   4.517  1.00 14.40           N  
ATOM    987  CA  ARG A 138      -0.312  20.924   4.469  1.00 14.72           C  
ATOM    988  C   ARG A 138       0.334  19.588   4.105  1.00 14.64           C  
ATOM    989  O   ARG A 138       1.379  19.578   3.475  1.00 14.80           O  
ATOM    990  CB  ARG A 138       0.261  21.416   5.821  1.00 14.45           C  
ATOM    991  CG  ARG A 138       1.769  21.894   5.700  1.00 16.21           C  
ATOM    992  CD  ARG A 138       1.906  23.341   5.090  1.00 19.35           C  
ATOM    993  NE  ARG A 138       1.302  24.258   6.044  1.00 13.97           N  
ATOM    994  CZ  ARG A 138       1.932  24.751   7.123  1.00 14.38           C  
ATOM    995  NH1 ARG A 138       3.227  24.474   7.354  1.00 13.53           N  
ATOM    996  NH2 ARG A 138       1.265  25.538   7.978  1.00 12.57           N  
ATOM    997  N   HIS A 139      -0.269  18.470   4.540  1.00 12.85           N  
ATOM    998  CA  HIS A 139       0.345  17.167   4.353  1.00 14.70           C  
ATOM    999  C   HIS A 139      -0.605  16.190   3.660  1.00 15.39           C  
ATOM   1000  O   HIS A 139      -1.123  15.309   4.322  1.00 16.29           O  
ATOM   1001  CB  HIS A 139       0.813  16.579   5.691  1.00 14.45           C  
ATOM   1002  CG  HIS A 139       1.855  17.401   6.376  1.00 14.87           C  
ATOM   1003  ND1 HIS A 139       3.205  17.218   6.169  1.00 11.99           N  
ATOM   1004  CD2 HIS A 139       1.738  18.408   7.275  1.00 12.39           C  
ATOM   1005  CE1 HIS A 139       3.880  18.092   6.900  1.00 15.27           C  
ATOM   1006  NE2 HIS A 139       3.013  18.817   7.592  1.00 15.76           N  
ATOM   1007  N   PRO A 140      -0.831  16.336   2.340  1.00 16.33           N  
ATOM   1008  CA  PRO A 140      -1.813  15.477   1.630  1.00 16.63           C  
ATOM   1009  C   PRO A 140      -1.569  13.959   1.716  1.00 15.72           C  
ATOM   1010  O   PRO A 140      -2.518  13.185   1.643  1.00 15.72           O  
ATOM   1011  CB  PRO A 140      -1.789  15.987   0.156  1.00 17.10           C  
ATOM   1012  CG  PRO A 140      -0.465  16.790   0.009  1.00 18.41           C  
ATOM   1013  CD  PRO A 140      -0.235  17.349   1.448  1.00 16.15           C  
ATOM   1014  N   GLU A 141      -0.337  13.535   1.951  1.00 16.08           N  
ATOM   1015  CA  GLU A 141      -0.037  12.102   2.083  1.00 15.54           C  
ATOM   1016  C   GLU A 141      -0.755  11.444   3.279  1.00 15.02           C  
ATOM   1017  O   GLU A 141      -1.040  10.229   3.269  1.00 15.13           O  
ATOM   1018  CB  GLU A 141       1.494  11.895   2.130  1.00 14.85           C  
ATOM   1019  CG  GLU A 141       1.953  10.459   2.029  1.00 16.76           C  
ATOM   1020  CD  GLU A 141       3.348  10.210   2.566  1.00 17.08           C  
ATOM   1021  OE1 GLU A 141       4.353  10.506   1.844  1.00 17.19           O  
ATOM   1022  OE2 GLU A 141       3.433   9.715   3.714  1.00 16.74           O  
HETATM 1023  N   MSE A 142      -1.063  12.227   4.312  1.00 14.94           N  
HETATM 1024  CA  MSE A 142      -1.673  11.683   5.537  1.00 14.15           C  
HETATM 1025  C   MSE A 142      -3.058  11.006   5.268  1.00 16.24           C  
HETATM 1026  O   MSE A 142      -3.432  10.059   5.963  1.00 15.46           O  
HETATM 1027  CB  MSE A 142      -1.838  12.780   6.579  1.00 14.37           C  
HETATM 1028  CG  MSE A 142      -0.516  13.256   7.228  1.00 13.87           C  
HETATM 1029 SE   MSE A 142      -0.892  14.704   8.512  1.00 20.80          SE  
HETATM 1030  CE  MSE A 142       1.073  14.982   8.972  1.00 16.54           C  
ATOM   1031  N   LYS A 143      -3.782  11.504   4.265  1.00 17.42           N  
ATOM   1032  CA  LYS A 143      -5.055  10.889   3.788  1.00 19.40           C  
ATOM   1033  C   LYS A 143      -4.867   9.412   3.404  1.00 18.97           C  
ATOM   1034  O   LYS A 143      -5.796   8.605   3.584  1.00 19.84           O  
ATOM   1035  CB  LYS A 143      -5.636  11.681   2.609  1.00 18.46           C  
ATOM   1036  CG  LYS A 143      -6.191  13.053   3.039  1.00 23.60           C  
ATOM   1037  CD  LYS A 143      -6.965  13.766   1.918  1.00 29.78           C  
ATOM   1038  CE  LYS A 143      -6.018  14.404   0.908  1.00 34.66           C  
ATOM   1039  NZ  LYS A 143      -6.662  15.377  -0.086  1.00 38.77           N  
ATOM   1040  N   THR A 144      -3.653   9.047   2.969  1.00 18.43           N  
ATOM   1041  CA  THR A 144      -3.362   7.660   2.578  1.00 17.71           C  
ATOM   1042  C   THR A 144      -2.721   6.774   3.659  1.00 18.46           C  
ATOM   1043  O   THR A 144      -2.505   5.590   3.422  1.00 17.69           O  
ATOM   1044  CB  THR A 144      -2.444   7.578   1.367  1.00 17.07           C  
ATOM   1045  OG1 THR A 144      -1.110   8.010   1.720  1.00 16.50           O  
ATOM   1046  CG2 THR A 144      -2.871   8.478   0.205  1.00 19.25           C  
ATOM   1047  N   TRP A 145      -2.387   7.336   4.822  1.00 18.92           N  
ATOM   1048  CA  TRP A 145      -1.751   6.567   5.888  1.00 18.43           C  
ATOM   1049  C   TRP A 145      -2.674   5.465   6.414  1.00 18.53           C  
ATOM   1050  O   TRP A 145      -3.882   5.670   6.553  1.00 18.94           O  
ATOM   1051  CB  TRP A 145      -1.342   7.512   7.023  1.00 18.25           C  
ATOM   1052  CG  TRP A 145      -0.151   8.447   6.671  1.00 16.83           C  
ATOM   1053  CD1 TRP A 145       0.475   8.576   5.466  1.00 17.80           C  
ATOM   1054  CD2 TRP A 145       0.513   9.361   7.552  1.00 13.77           C  
ATOM   1055  NE1 TRP A 145       1.500   9.492   5.553  1.00 15.15           N  
ATOM   1056  CE2 TRP A 145       1.533   9.999   6.820  1.00 13.69           C  
ATOM   1057  CE3 TRP A 145       0.333   9.721   8.891  1.00 15.83           C  
ATOM   1058  CZ2 TRP A 145       2.357  10.984   7.368  1.00 14.07           C  
ATOM   1059  CZ3 TRP A 145       1.152  10.683   9.444  1.00 13.72           C  
ATOM   1060  CH2 TRP A 145       2.157  11.309   8.680  1.00 15.50           C  
ATOM   1061  N   PRO A 146      -2.103   4.330   6.812  1.00 19.02           N  
ATOM   1062  CA  PRO A 146      -2.910   3.158   7.237  1.00 18.29           C  
ATOM   1063  C   PRO A 146      -3.845   3.327   8.461  1.00 18.62           C  
ATOM   1064  O   PRO A 146      -3.352   3.630   9.549  1.00 17.62           O  
ATOM   1065  CB  PRO A 146      -1.831   2.080   7.542  1.00 18.75           C  
ATOM   1066  CG  PRO A 146      -0.514   2.837   7.743  1.00 19.10           C  
ATOM   1067  CD  PRO A 146      -0.646   4.070   6.863  1.00 17.96           C  
ATOM   1068  N   SER A 147      -5.165   3.104   8.323  1.00 17.51           N  
ATOM   1069  CA  SER A 147      -6.082   3.216   9.492  1.00 18.87           C  
ATOM   1070  C   SER A 147      -5.713   2.311  10.678  1.00 17.87           C  
ATOM   1071  O   SER A 147      -6.052   2.594  11.842  1.00 19.39           O  
ATOM   1072  CB  SER A 147      -7.567   2.965   9.080  1.00 18.82           C  
ATOM   1073  OG  SER A 147      -7.716   1.660   8.515  1.00 22.97           O  
ATOM   1074  N   SER A 148      -5.024   1.219  10.376  1.00 16.96           N  
ATOM   1075  CA  SER A 148      -4.562   0.249  11.353  1.00 16.24           C  
ATOM   1076  C   SER A 148      -3.588   0.838  12.389  1.00 17.27           C  
ATOM   1077  O   SER A 148      -3.404   0.254  13.449  1.00 17.40           O  
ATOM   1078  CB  SER A 148      -3.956  -0.980  10.649  1.00 16.54           C  
ATOM   1079  OG  SER A 148      -2.732  -0.663   9.943  1.00 15.74           O  
ATOM   1080  N   HIS A 149      -3.028   2.014  12.100  1.00 16.66           N  
ATOM   1081  CA  HIS A 149      -2.108   2.693  13.018  1.00 18.08           C  
ATOM   1082  C   HIS A 149      -2.856   3.586  14.016  1.00 17.74           C  
ATOM   1083  O   HIS A 149      -2.226   4.187  14.925  1.00 17.71           O  
ATOM   1084  CB  HIS A 149      -1.006   3.477  12.248  1.00 18.33           C  
ATOM   1085  CG  HIS A 149       0.024   2.590  11.587  1.00 22.88           C  
ATOM   1086  ND1 HIS A 149       1.378   2.861  11.622  1.00 24.97           N  
ATOM   1087  CD2 HIS A 149      -0.103   1.420  10.912  1.00 25.09           C  
ATOM   1088  CE1 HIS A 149       2.039   1.916  10.974  1.00 25.23           C  
ATOM   1089  NE2 HIS A 149       1.165   1.025  10.534  1.00 29.01           N  
ATOM   1090  N   ASN A 150      -4.186   3.661  13.867  1.00 16.65           N  
ATOM   1091  CA  ASN A 150      -5.022   4.381  14.839  1.00 17.29           C  
ATOM   1092  C   ASN A 150      -4.567   5.848  15.051  1.00 17.25           C  
ATOM   1093  O   ASN A 150      -4.284   6.279  16.165  1.00 17.40           O  
ATOM   1094  CB  ASN A 150      -5.033   3.594  16.132  1.00 16.64           C  
ATOM   1095  CG  ASN A 150      -5.763   2.245  15.966  1.00 19.76           C  
ATOM   1096  OD1 ASN A 150      -6.703   2.122  15.158  1.00 21.89           O  
ATOM   1097  ND2 ASN A 150      -5.313   1.244  16.683  1.00 21.24           N  
ATOM   1098  N   TRP A 151      -4.424   6.572  13.949  1.00 17.48           N  
ATOM   1099  CA  TRP A 151      -3.986   7.986  13.963  1.00 16.96           C  
ATOM   1100  C   TRP A 151      -4.925   8.837  14.804  1.00 17.96           C  
ATOM   1101  O   TRP A 151      -6.137   8.596  14.811  1.00 18.80           O  
ATOM   1102  CB  TRP A 151      -3.912   8.511  12.520  1.00 17.12           C  
ATOM   1103  CG  TRP A 151      -2.978   7.699  11.670  1.00 17.52           C  
ATOM   1104  CD1 TRP A 151      -3.308   6.732  10.719  1.00 16.29           C  
ATOM   1105  CD2 TRP A 151      -1.564   7.730  11.730  1.00 16.57           C  
ATOM   1106  NE1 TRP A 151      -2.159   6.184  10.192  1.00 16.60           N  
ATOM   1107  CE2 TRP A 151      -1.073   6.764  10.801  1.00 16.46           C  
ATOM   1108  CE3 TRP A 151      -0.637   8.490  12.466  1.00 16.87           C  
ATOM   1109  CZ2 TRP A 151       0.281   6.544  10.598  1.00 16.27           C  
ATOM   1110  CZ3 TRP A 151       0.706   8.267  12.278  1.00 13.71           C  
ATOM   1111  CH2 TRP A 151       1.168   7.300  11.330  1.00 17.76           C  
ATOM   1112  N   PHE A 152      -4.376   9.765  15.585  1.00 15.90           N  
ATOM   1113  CA  PHE A 152      -5.193  10.779  16.234  1.00 15.62           C  
ATOM   1114  C   PHE A 152      -4.554  12.157  16.074  1.00 15.33           C  
ATOM   1115  O   PHE A 152      -3.332  12.277  15.875  1.00 14.75           O  
ATOM   1116  CB  PHE A 152      -5.416  10.475  17.717  1.00 14.93           C  
ATOM   1117  CG  PHE A 152      -4.151  10.365  18.502  1.00 16.43           C  
ATOM   1118  CD1 PHE A 152      -3.425   9.167  18.520  1.00 15.50           C  
ATOM   1119  CD2 PHE A 152      -3.677  11.457  19.248  1.00 17.60           C  
ATOM   1120  CE1 PHE A 152      -2.258   9.026  19.260  1.00 17.07           C  
ATOM   1121  CE2 PHE A 152      -2.505  11.332  20.006  1.00 18.02           C  
ATOM   1122  CZ  PHE A 152      -1.789  10.090  20.014  1.00 16.59           C  
ATOM   1123  N   PHE A 153      -5.401  13.179  16.156  1.00 15.66           N  
ATOM   1124  CA  PHE A 153      -4.982  14.590  16.124  1.00 16.59           C  
ATOM   1125  C   PHE A 153      -4.551  15.046  17.479  1.00 16.74           C  
ATOM   1126  O   PHE A 153      -5.266  14.840  18.479  1.00 17.39           O  
ATOM   1127  CB  PHE A 153      -6.099  15.469  15.566  1.00 16.61           C  
ATOM   1128  CG  PHE A 153      -6.516  15.069  14.177  1.00 20.14           C  
ATOM   1129  CD1 PHE A 153      -5.694  15.374  13.089  1.00 18.39           C  
ATOM   1130  CD2 PHE A 153      -7.724  14.376  13.961  1.00 20.84           C  
ATOM   1131  CE1 PHE A 153      -6.051  15.013  11.814  1.00 21.96           C  
ATOM   1132  CE2 PHE A 153      -8.104  14.013  12.669  1.00 19.61           C  
ATOM   1133  CZ  PHE A 153      -7.272  14.323  11.601  1.00 22.55           C  
ATOM   1134  N   ALA A 154      -3.340  15.606  17.530  1.00 15.71           N  
ATOM   1135  CA  ALA A 154      -2.742  16.047  18.769  1.00 14.88           C  
ATOM   1136  C   ALA A 154      -2.335  17.538  18.629  1.00 14.71           C  
ATOM   1137  O   ALA A 154      -2.265  18.066  17.529  1.00 13.63           O  
ATOM   1138  CB  ALA A 154      -1.525  15.155  19.089  1.00 14.51           C  
ATOM   1139  N   LYS A 155      -2.127  18.220  19.745  1.00 14.37           N  
ATOM   1140  CA  LYS A 155      -1.552  19.554  19.667  1.00 15.00           C  
ATOM   1141  C   LYS A 155      -0.529  19.787  20.767  1.00 14.27           C  
ATOM   1142  O   LYS A 155      -0.565  19.137  21.810  1.00 15.35           O  
ATOM   1143  CB  LYS A 155      -2.675  20.636  19.742  1.00 13.98           C  
ATOM   1144  CG  LYS A 155      -3.348  20.679  21.127  1.00 18.38           C  
ATOM   1145  CD  LYS A 155      -4.645  21.530  21.065  1.00 20.45           C  
ATOM   1146  CE  LYS A 155      -4.466  22.823  21.811  1.00 25.29           C  
ATOM   1147  NZ  LYS A 155      -5.639  23.738  21.661  1.00 27.32           N  
ATOM   1148  N   LEU A 156       0.329  20.785  20.552  1.00 14.11           N  
ATOM   1149  CA  LEU A 156       1.226  21.274  21.579  1.00 13.81           C  
ATOM   1150  C   LEU A 156       0.539  22.485  22.226  1.00 14.09           C  
ATOM   1151  O   LEU A 156       0.158  23.478  21.538  1.00 13.68           O  
ATOM   1152  CB  LEU A 156       2.600  21.672  20.974  1.00 14.05           C  
ATOM   1153  CG  LEU A 156       3.659  22.123  22.001  1.00 14.87           C  
ATOM   1154  CD1 LEU A 156       4.087  20.990  22.987  1.00 12.13           C  
ATOM   1155  CD2 LEU A 156       4.900  22.757  21.275  1.00  8.90           C  
ATOM   1156  N   ASN A 157       0.332  22.336  23.514  1.00 12.01           N  
ATOM   1157  CA  ASN A 157      -0.128  23.403  24.421  1.00 15.31           C  
ATOM   1158  C   ASN A 157       1.091  24.156  24.930  1.00 14.77           C  
ATOM   1159  O   ASN A 157       1.858  23.616  25.728  1.00 16.52           O  
ATOM   1160  CB  ASN A 157      -0.878  22.771  25.606  1.00 15.41           C  
ATOM   1161  CG  ASN A 157      -2.018  21.839  25.155  1.00 18.06           C  
ATOM   1162  OD1 ASN A 157      -3.000  22.295  24.597  1.00 17.90           O  
ATOM   1163  ND2 ASN A 157      -1.885  20.521  25.410  1.00 21.16           N  
ATOM   1164  N   ILE A 158       1.290  25.395  24.488  1.00 14.19           N  
ATOM   1165  CA  ILE A 158       2.574  26.049  24.741  1.00 14.43           C  
ATOM   1166  C   ILE A 158       2.555  26.827  26.060  1.00 15.85           C  
ATOM   1167  O   ILE A 158       1.755  27.716  26.231  1.00 16.19           O  
ATOM   1168  CB  ILE A 158       2.936  26.986  23.603  1.00 15.31           C  
ATOM   1169  CG1 ILE A 158       2.985  26.214  22.284  1.00 12.48           C  
ATOM   1170  CG2 ILE A 158       4.283  27.673  23.889  1.00 13.19           C  
ATOM   1171  CD1 ILE A 158       2.646  27.040  21.078  1.00 14.31           C  
ATOM   1172  N   THR A 159       3.458  26.507  26.973  1.00 15.80           N  
ATOM   1173  CA  THR A 159       3.610  27.346  28.134  1.00 16.70           C  
ATOM   1174  C   THR A 159       4.871  28.182  28.139  1.00 17.55           C  
ATOM   1175  O   THR A 159       4.906  29.200  28.838  1.00 16.75           O  
ATOM   1176  CB  THR A 159       3.468  26.538  29.428  1.00 16.55           C  
ATOM   1177  OG1 THR A 159       4.460  25.522  29.448  1.00 18.12           O  
ATOM   1178  CG2 THR A 159       2.152  25.728  29.438  1.00 16.69           C  
ATOM   1179  N   ASN A 160       5.906  27.754  27.405  1.00 17.43           N  
ATOM   1180  CA  ASN A 160       7.180  28.496  27.356  1.00 18.54           C  
ATOM   1181  C   ASN A 160       7.715  28.556  25.922  1.00 17.86           C  
ATOM   1182  O   ASN A 160       7.554  27.589  25.130  1.00 17.18           O  
ATOM   1183  CB  ASN A 160       8.240  27.850  28.274  1.00 18.47           C  
ATOM   1184  CG  ASN A 160       7.828  27.845  29.753  1.00 21.70           C  
ATOM   1185  OD1 ASN A 160       8.291  28.693  30.526  1.00 25.08           O  
ATOM   1186  ND2 ASN A 160       6.959  26.911  30.145  1.00 20.14           N  
ATOM   1187  N   ILE A 161       8.291  29.707  25.587  1.00 15.93           N  
ATOM   1188  CA  ILE A 161       8.809  29.974  24.255  1.00 14.23           C  
ATOM   1189  C   ILE A 161      10.162  30.708  24.337  1.00 14.41           C  
ATOM   1190  O   ILE A 161      10.282  31.702  25.053  1.00 14.06           O  
ATOM   1191  CB  ILE A 161       7.819  30.846  23.436  1.00 12.64           C  
ATOM   1192  CG1 ILE A 161       6.423  30.184  23.328  1.00 11.59           C  
ATOM   1193  CG2 ILE A 161       8.390  31.177  22.038  1.00 14.70           C  
ATOM   1194  CD1 ILE A 161       5.423  31.115  22.693  1.00  5.83           C  
ATOM   1195  N   TRP A 162      11.167  30.178  23.619  1.00 12.83           N  
ATOM   1196  CA  TRP A 162      12.471  30.834  23.430  1.00 12.46           C  
ATOM   1197  C   TRP A 162      12.688  31.087  21.940  1.00 11.54           C  
ATOM   1198  O   TRP A 162      12.364  30.218  21.112  1.00 11.17           O  
ATOM   1199  CB  TRP A 162      13.643  29.953  23.908  1.00 12.99           C  
ATOM   1200  CG  TRP A 162      13.642  29.673  25.384  1.00 17.12           C  
ATOM   1201  CD1 TRP A 162      14.369  30.313  26.361  1.00 19.06           C  
ATOM   1202  CD2 TRP A 162      12.897  28.642  26.045  1.00 17.63           C  
ATOM   1203  NE1 TRP A 162      14.119  29.735  27.585  1.00 19.97           N  
ATOM   1204  CE2 TRP A 162      13.198  28.725  27.429  1.00 20.66           C  
ATOM   1205  CE3 TRP A 162      11.977  27.672  25.611  1.00 17.33           C  
ATOM   1206  CZ2 TRP A 162      12.631  27.850  28.383  1.00 18.23           C  
ATOM   1207  CZ3 TRP A 162      11.399  26.796  26.573  1.00 16.50           C  
ATOM   1208  CH2 TRP A 162      11.748  26.890  27.929  1.00 19.83           C  
ATOM   1209  N   VAL A 163      13.226  32.271  21.604  1.00 10.71           N  
ATOM   1210  CA  VAL A 163      13.447  32.653  20.220  1.00  9.79           C  
ATOM   1211  C   VAL A 163      14.914  33.018  20.094  1.00 10.29           C  
ATOM   1212  O   VAL A 163      15.422  33.865  20.849  1.00 10.12           O  
ATOM   1213  CB  VAL A 163      12.513  33.802  19.754  1.00 10.43           C  
ATOM   1214  CG1 VAL A 163      12.863  34.310  18.317  1.00  9.60           C  
ATOM   1215  CG2 VAL A 163      11.027  33.321  19.736  1.00  8.24           C  
ATOM   1216  N   LEU A 164      15.591  32.344  19.170  1.00  9.46           N  
ATOM   1217  CA  LEU A 164      16.964  32.713  18.844  1.00  9.61           C  
ATOM   1218  C   LEU A 164      16.924  33.361  17.486  1.00 10.35           C  
ATOM   1219  O   LEU A 164      16.872  32.677  16.456  1.00  9.67           O  
ATOM   1220  CB  LEU A 164      17.904  31.490  18.841  1.00  7.89           C  
ATOM   1221  CG  LEU A 164      18.612  31.159  20.173  1.00 11.45           C  
ATOM   1222  CD1 LEU A 164      19.527  32.249  20.719  1.00 11.48           C  
ATOM   1223  CD2 LEU A 164      17.552  30.764  21.228  1.00 13.13           C  
ATOM   1224  N   ASP A 165      16.918  34.691  17.463  1.00  9.74           N  
ATOM   1225  CA  ASP A 165      16.827  35.365  16.158  1.00  9.77           C  
ATOM   1226  C   ASP A 165      17.844  36.503  16.003  1.00 10.36           C  
ATOM   1227  O   ASP A 165      17.913  37.182  14.965  1.00 11.42           O  
ATOM   1228  CB  ASP A 165      15.413  35.788  15.815  1.00  9.72           C  
ATOM   1229  CG  ASP A 165      14.927  36.992  16.622  1.00  7.57           C  
ATOM   1230  OD1 ASP A 165      15.657  37.504  17.510  1.00  9.43           O  
ATOM   1231  OD2 ASP A 165      13.812  37.523  16.348  1.00  8.74           O  
ATOM   1232  N   TYR A 166      18.696  36.656  17.006  1.00 10.92           N  
ATOM   1233  CA  TYR A 166      19.757  37.693  16.958  1.00 11.35           C  
ATOM   1234  C   TYR A 166      20.855  37.396  17.953  1.00 12.23           C  
ATOM   1235  O   TYR A 166      20.726  36.492  18.790  1.00 12.60           O  
ATOM   1236  CB  TYR A 166      19.202  39.101  17.221  1.00  9.79           C  
ATOM   1237  CG  TYR A 166      19.964  40.243  16.513  1.00 11.59           C  
ATOM   1238  CD1 TYR A 166      20.729  41.160  17.258  1.00 13.71           C  
ATOM   1239  CD2 TYR A 166      19.945  40.376  15.119  1.00 11.09           C  
ATOM   1240  CE1 TYR A 166      21.445  42.180  16.633  1.00 12.74           C  
ATOM   1241  CE2 TYR A 166      20.660  41.402  14.460  1.00 13.20           C  
ATOM   1242  CZ  TYR A 166      21.413  42.298  15.244  1.00 10.88           C  
ATOM   1243  OH  TYR A 166      22.107  43.315  14.646  1.00 11.24           O  
ATOM   1244  N   PHE A 167      21.969  38.137  17.835  1.00 13.37           N  
ATOM   1245  CA  PHE A 167      22.946  38.158  18.900  1.00 14.68           C  
ATOM   1246  C   PHE A 167      22.312  38.639  20.233  1.00 15.60           C  
ATOM   1247  O   PHE A 167      21.270  39.309  20.271  1.00 13.35           O  
ATOM   1248  CB  PHE A 167      24.141  39.055  18.502  1.00 14.97           C  
ATOM   1249  CG  PHE A 167      24.709  38.748  17.122  1.00 15.12           C  
ATOM   1250  CD1 PHE A 167      25.193  37.456  16.791  1.00 16.84           C  
ATOM   1251  CD2 PHE A 167      24.761  39.741  16.154  1.00 15.89           C  
ATOM   1252  CE1 PHE A 167      25.728  37.202  15.479  1.00 17.96           C  
ATOM   1253  CE2 PHE A 167      25.288  39.511  14.870  1.00 12.39           C  
ATOM   1254  CZ  PHE A 167      25.769  38.260  14.519  1.00 15.22           C  
ATOM   1255  N   GLY A 168      22.953  38.256  21.330  1.00 16.66           N  
ATOM   1256  CA  GLY A 168      22.563  38.724  22.648  1.00 19.11           C  
ATOM   1257  C   GLY A 168      21.809  37.662  23.439  1.00 20.35           C  
ATOM   1258  O   GLY A 168      21.316  37.945  24.543  1.00 21.90           O  
ATOM   1259  N   GLY A 169      21.717  36.445  22.913  1.00 20.20           N  
ATOM   1260  CA  GLY A 169      20.990  35.399  23.630  1.00 19.40           C  
ATOM   1261  C   GLY A 169      19.477  35.246  23.315  1.00 18.06           C  
ATOM   1262  O   GLY A 169      18.918  36.013  22.539  1.00 17.63           O  
ATOM   1263  N   PRO A 170      18.841  34.239  23.941  1.00 18.52           N  
ATOM   1264  CA  PRO A 170      17.432  33.906  23.700  1.00 18.16           C  
ATOM   1265  C   PRO A 170      16.486  35.011  24.129  1.00 18.51           C  
ATOM   1266  O   PRO A 170      16.735  35.730  25.107  1.00 18.34           O  
ATOM   1267  CB  PRO A 170      17.206  32.646  24.555  1.00 17.63           C  
ATOM   1268  CG  PRO A 170      18.542  32.109  24.842  1.00 18.16           C  
ATOM   1269  CD  PRO A 170      19.449  33.338  24.952  1.00 17.33           C  
ATOM   1270  N   LYS A 171      15.413  35.175  23.367  1.00 17.96           N  
ATOM   1271  CA  LYS A 171      14.367  36.130  23.721  1.00 17.08           C  
ATOM   1272  C   LYS A 171      13.194  35.287  24.157  1.00 17.92           C  
ATOM   1273  O   LYS A 171      12.842  34.317  23.489  1.00 16.94           O  
ATOM   1274  CB  LYS A 171      14.018  37.032  22.555  1.00 17.12           C  
ATOM   1275  CG  LYS A 171      15.233  37.776  22.028  1.00 16.82           C  
ATOM   1276  CD  LYS A 171      14.856  38.610  20.851  1.00 20.33           C  
ATOM   1277  CE  LYS A 171      16.117  39.219  20.199  1.00 17.70           C  
ATOM   1278  NZ  LYS A 171      15.573  39.997  19.153  1.00 24.18           N  
ATOM   1279  N   ILE A 172      12.640  35.639  25.314  1.00 15.90           N  
ATOM   1280  CA  ILE A 172      11.559  34.877  25.948  1.00 16.99           C  
ATOM   1281  C   ILE A 172      10.300  35.516  25.429  1.00 17.23           C  
ATOM   1282  O   ILE A 172      10.231  36.745  25.382  1.00 15.12           O  
ATOM   1283  CB  ILE A 172      11.601  35.072  27.498  1.00 18.14           C  
ATOM   1284  CG1 ILE A 172      12.932  34.632  28.099  1.00 19.77           C  
ATOM   1285  CG2 ILE A 172      10.362  34.389  28.205  1.00 17.31           C  
ATOM   1286  CD1 ILE A 172      13.336  33.256  27.697  1.00 22.04           C  
ATOM   1287  N   VAL A 173       9.303  34.694  25.072  1.00 15.96           N  
ATOM   1288  CA  VAL A 173       8.045  35.193  24.538  1.00 16.20           C  
ATOM   1289  C   VAL A 173       6.975  34.451  25.322  1.00 16.50           C  
ATOM   1290  O   VAL A 173       7.006  33.232  25.413  1.00 17.50           O  
ATOM   1291  CB  VAL A 173       7.889  34.857  23.005  1.00 15.05           C  
ATOM   1292  CG1 VAL A 173       6.512  35.297  22.447  1.00 15.25           C  
ATOM   1293  CG2 VAL A 173       9.050  35.498  22.164  1.00 17.01           C  
ATOM   1294  N   THR A 174       5.992  35.162  25.846  1.00 16.67           N  
ATOM   1295  CA  THR A 174       4.918  34.485  26.546  1.00 16.93           C  
ATOM   1296  C   THR A 174       3.927  33.920  25.538  1.00 16.25           C  
ATOM   1297  O   THR A 174       3.761  34.464  24.463  1.00 16.87           O  
ATOM   1298  CB  THR A 174       4.164  35.486  27.493  1.00 16.32           C  
ATOM   1299  OG1 THR A 174       3.529  36.478  26.673  1.00 16.73           O  
ATOM   1300  CG2 THR A 174       5.118  36.331  28.401  1.00 17.35           C  
ATOM   1301  N   PRO A 175       3.219  32.855  25.904  1.00 16.92           N  
ATOM   1302  CA  PRO A 175       2.148  32.318  25.067  1.00 16.74           C  
ATOM   1303  C   PRO A 175       1.177  33.412  24.657  1.00 16.98           C  
ATOM   1304  O   PRO A 175       0.631  33.355  23.568  1.00 15.70           O  
ATOM   1305  CB  PRO A 175       1.458  31.357  26.013  1.00 17.17           C  
ATOM   1306  CG  PRO A 175       2.579  30.888  26.856  1.00 16.85           C  
ATOM   1307  CD  PRO A 175       3.376  32.085  27.165  1.00 17.32           C  
ATOM   1308  N   GLU A 176       0.907  34.381  25.542  1.00 17.24           N  
ATOM   1309  CA  GLU A 176      -0.127  35.341  25.185  1.00 18.57           C  
ATOM   1310  C   GLU A 176       0.390  36.323  24.152  1.00 16.51           C  
ATOM   1311  O   GLU A 176      -0.334  36.701  23.243  1.00 15.11           O  
ATOM   1312  CB  GLU A 176      -0.766  36.034  26.405  1.00 19.48           C  
ATOM   1313  CG  GLU A 176       0.044  35.933  27.678  1.00 26.14           C  
ATOM   1314  CD  GLU A 176      -0.057  34.575  28.359  1.00 33.20           C  
ATOM   1315  OE1 GLU A 176      -1.202  34.047  28.500  1.00 38.20           O  
ATOM   1316  OE2 GLU A 176       1.009  34.043  28.752  1.00 30.39           O  
ATOM   1317  N   GLU A 177       1.666  36.696  24.241  1.00 16.22           N  
ATOM   1318  CA  GLU A 177       2.281  37.468  23.154  1.00 15.69           C  
ATOM   1319  C   GLU A 177       2.250  36.685  21.855  1.00 15.51           C  
ATOM   1320  O   GLU A 177       1.966  37.226  20.752  1.00 15.72           O  
ATOM   1321  CB  GLU A 177       3.742  37.853  23.497  1.00 15.12           C  
ATOM   1322  CG  GLU A 177       3.862  38.943  24.587  1.00 16.58           C  
ATOM   1323  CD  GLU A 177       5.197  38.917  25.358  1.00 18.00           C  
ATOM   1324  OE1 GLU A 177       6.038  38.005  25.153  1.00 17.94           O  
ATOM   1325  OE2 GLU A 177       5.411  39.805  26.219  1.00 19.82           O  
ATOM   1326  N   TYR A 178       2.657  35.428  21.935  1.00 14.82           N  
ATOM   1327  CA  TYR A 178       2.729  34.618  20.689  1.00 13.29           C  
ATOM   1328  C   TYR A 178       1.343  34.540  20.011  1.00 14.65           C  
ATOM   1329  O   TYR A 178       1.215  34.790  18.809  1.00 13.16           O  
ATOM   1330  CB  TYR A 178       3.179  33.242  21.107  1.00 13.22           C  
ATOM   1331  CG  TYR A 178       3.283  32.166  20.039  1.00 12.40           C  
ATOM   1332  CD1 TYR A 178       4.371  32.142  19.119  1.00 11.10           C  
ATOM   1333  CD2 TYR A 178       2.312  31.146  19.966  1.00 10.48           C  
ATOM   1334  CE1 TYR A 178       4.462  31.114  18.148  1.00 11.46           C  
ATOM   1335  CE2 TYR A 178       2.441  30.103  19.009  1.00 10.95           C  
ATOM   1336  CZ  TYR A 178       3.511  30.104  18.126  1.00 11.89           C  
ATOM   1337  OH  TYR A 178       3.578  29.098  17.195  1.00 10.96           O  
ATOM   1338  N   TYR A 179       0.300  34.237  20.802  1.00 14.09           N  
ATOM   1339  CA  TYR A 179      -1.058  34.105  20.240  1.00 17.05           C  
ATOM   1340  C   TYR A 179      -1.810  35.422  19.972  1.00 18.38           C  
ATOM   1341  O   TYR A 179      -2.825  35.453  19.266  1.00 18.35           O  
ATOM   1342  CB  TYR A 179      -1.874  33.131  21.079  1.00 16.34           C  
ATOM   1343  CG  TYR A 179      -1.508  31.684  20.870  1.00 15.22           C  
ATOM   1344  CD1 TYR A 179      -1.558  31.108  19.597  1.00 18.25           C  
ATOM   1345  CD2 TYR A 179      -1.123  30.892  21.931  1.00 16.56           C  
ATOM   1346  CE1 TYR A 179      -1.226  29.772  19.420  1.00 15.90           C  
ATOM   1347  CE2 TYR A 179      -0.809  29.570  21.760  1.00 16.71           C  
ATOM   1348  CZ  TYR A 179      -0.856  29.023  20.510  1.00 16.42           C  
ATOM   1349  OH  TYR A 179      -0.527  27.701  20.356  1.00 15.46           O  
ATOM   1350  N   ASN A 180      -1.289  36.534  20.494  1.00 19.50           N  
ATOM   1351  CA  ASN A 180      -1.867  37.835  20.126  1.00 20.82           C  
ATOM   1352  C   ASN A 180      -1.297  38.429  18.820  1.00 20.65           C  
ATOM   1353  O   ASN A 180      -1.826  39.408  18.273  1.00 21.73           O  
ATOM   1354  CB  ASN A 180      -1.790  38.819  21.290  1.00 22.21           C  
ATOM   1355  CG  ASN A 180      -2.889  38.565  22.386  1.00 28.28           C  
ATOM   1356  OD1 ASN A 180      -2.751  37.670  23.215  1.00 31.33           O  
ATOM   1357  ND2 ASN A 180      -3.969  39.366  22.368  1.00 32.29           N  
ATOM   1358  N   VAL A 181      -0.265  37.803  18.259  1.00 19.97           N  
ATOM   1359  CA  VAL A 181       0.191  38.200  16.927  1.00 19.46           C  
ATOM   1360  C   VAL A 181      -0.914  38.072  15.876  1.00 20.70           C  
ATOM   1361  O   VAL A 181      -1.565  37.039  15.789  1.00 20.60           O  
ATOM   1362  CB  VAL A 181       1.398  37.354  16.425  1.00 19.83           C  
ATOM   1363  CG1 VAL A 181       1.706  37.718  14.963  1.00 17.26           C  
ATOM   1364  CG2 VAL A 181       2.606  37.571  17.324  1.00 18.47           C  
ATOM   1365  N   THR A 182      -1.127  39.122  15.091  1.00 22.33           N  
ATOM   1366  CA  THR A 182      -2.026  39.044  13.953  1.00 25.40           C  
ATOM   1367  C   THR A 182      -1.211  39.012  12.645  1.00 26.61           C  
ATOM   1368  O   THR A 182      -0.452  39.945  12.376  1.00 27.85           O  
ATOM   1369  CB  THR A 182      -3.046  40.227  13.975  1.00 26.22           C  
ATOM   1370  OG1 THR A 182      -2.370  41.462  14.240  1.00 27.99           O  
ATOM   1371  CG2 THR A 182      -3.982  40.104  15.191  1.00 27.42           C  
TER    1372      THR A 182                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
