
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 (  982),  selected  124 , name 3db0_B
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 3db0_B.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      A       2           -
LGA    -       -      D       3           -
LGA    -       -      P       4           -
LGA    -       -      K       5           -
LGA    E     4_B      E       6          2.668
LGA    L     5_B      L       7          3.122
LGA    E     6_B      Q       8          2.779
LGA    D     7_B      D       9          1.593
LGA    K     8_B      K      10          1.446
LGA    I     9_B      F      11          1.763
LGA    L    10_B      W      12          1.660
LGA    A    11_B      K      13          1.537
LGA    I    12_B      A      14          1.375
LGA    L    13_B      L      15          1.264
LGA    E    14_B      K      16          2.357
LGA    Q    15_B      S      17          2.346
LGA    H    16_B      D      18          0.826
LGA    Q    17_B      R      19          1.533
LGA    V    18_B      T      20          1.327
LGA    G    19_B      V      21          1.772
LGA    V    20_B      M      22          0.565
LGA    L    21_B      L      23          0.707
LGA    T    22_B      G      24          1.129
LGA    S    23_B      L      25          1.523
LGA    V    24_B      D      26          4.583
LGA    Q    25_B      -       -           -
LGA    G    26_B      G      27           #
LGA    D    27_B      V      28          2.820
LGA    F    28_B      E      29          1.553
LGA    P    29_B      D      30          3.856
LGA    H    30_B      G      31          2.259
LGA    -       -      H      32           -
LGA    A    31_B      A      33          1.058
LGA    R    32_B      R      34          0.615
LGA    Y    33_B      P      35          1.153
LGA    X    34_B      M      36          1.645
LGA    T    35_B      T      37          1.251
LGA    F    36_B      A      38          1.321
LGA    L    37_B      Q      39          1.085
LGA    H    38_B      I      40          1.699
LGA    D    39_B      E      41          2.582
LGA    -       -      G      42           -
LGA    -       -      D      43           -
LGA    G    40_B      S      44          2.777
LGA    L    41_B      G      45          2.565
LGA    T    42_B      G      46          1.700
LGA    -       -      P      47           -
LGA    L    43_B      I      48          0.834
LGA    Y    44_B      W      49          0.743
LGA    T    45_B      F      50          0.691
LGA    P    46_B      F      51          1.351
LGA    S    47_B      T      52          1.660
LGA    G    48_B      S      53          2.024
LGA    K    49_B      K      54          2.089
LGA    E    50_B      D      55          2.670
LGA    L    51_B      N      56          2.069
LGA    P    52_B      A      57          0.852
LGA    K    53_B      L      58          1.619
LGA    T    54_B      I      59          1.097
LGA    E    55_B      A      60          1.433
LGA    E    56_B      M      61          2.606
LGA    V    57_B      L      62          2.446
LGA    R    58_B      G      63          2.724
LGA    R    59_B      Q      64           #
LGA    N    60_B      G      65          5.399
LGA    P    61_B      R      66          1.330
LGA    H    62_B      R      67          0.659
LGA    V    63_B      V      68          0.910
LGA    C    64_B      I      69          0.847
LGA    V    65_B      G      70          0.877
LGA    L    66_B      A      71          1.516
LGA    I    67_B      F      72          1.470
LGA    G    68_B      S      73          2.047
LGA    Y    69_B      S      74          4.326
LGA    D    70_B      K      75          3.625
LGA    S    71_B      G      76          5.396
LGA    P    72_B      H      77          5.523
LGA    G    73_B      -       -           -
LGA    S    74_B      D      78          1.948
LGA    A    75_B      L      79          1.319
LGA    F    76_B      F      80          1.844
LGA    L    77_B      A      81          1.396
LGA    E    78_B      S      82          1.186
LGA    I    79_B      I      83          0.672
LGA    N    80_B      S      84          0.257
LGA    G    81_B      G      85          0.564
LGA    L    82_B      S      86          0.698
LGA    A    83_B      L      87          0.958
LGA    S    84_B      R      88          1.456
LGA    L    85_B      E      89          1.171
LGA    E    86_B      D      90          1.486
LGA    E    87_B      T      91          4.120
LGA    D    88_B      D      92          2.309
LGA    E    89_B      P      93          1.173
LGA    S    90_B      A      94          1.033
LGA    I    91_B      V      95          0.496
LGA    K    92_B      V      96          1.819
LGA    E    93_B      D      97          3.055
LGA    R    94_B      R      98          3.255
LGA    I    95_B      L      99          3.025
LGA    W    96_B      W     100          4.160
LGA    E    97_B      N     101          3.755
LGA    N    98_B      P     102          4.733
LGA    I    99_B      Y     103          3.908
LGA    S   100_B      V     104          3.158
LGA    K   101_B      A     105          3.791
LGA    D   102_B      A     106          4.725
LGA    W   103_B      -       -           -
LGA    F   104_B      W     107           #
LGA    Q   105_B      Y     108           -
LGA    G   106_B      E     109           -
LGA    E   107_B      G     110          4.193
LGA    D   108_B      G     111          3.080
LGA    -       -      K     112           -
LGA    -       -      D     113           -
LGA    S   109_B      D     114          0.482
LGA    P   110_B      P     115          1.448
LGA    S   111_B      K     116          2.021
LGA    F   112_B      L     117          0.510
LGA    V   113_B      A     118          0.906
LGA    V   114_B      L     119          0.406
LGA    I   115_B      L     120          0.443
LGA    K   116_B      R     121          0.535
LGA    I   117_B      L     122          0.615
LGA    V   118_B      D     123          0.931
LGA    P   119_B      A     124          0.672
LGA    E   120_B      D     125          0.538
LGA    Q   121_B      H     126          0.794
LGA    I   122_B      A     127          1.398
LGA    R   123_B      Q     128          1.758
LGA    I   124_B      I     129          1.161
LGA    L   125_B      W     130          1.211
LGA    N   126_B      L     131          2.957
LGA    S   127_B      N     132          4.660
LGA    -       -      G     133           -
LGA    -       -      S     134           -
LGA    -       -      S     135           -
LGA    -       -      L     136           -
LGA    -       -      L     137           -
LGA    -       -      A     138           -
LGA    -       -      G     139           -
LGA    -       -      I     140           -
LGA    -       -      K     141           -
LGA    -       -      V     142           -
LGA    -       -      L     143           -
LGA    -       -      L     144           -
LGA    -       -      G     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124  145    5.0    116    2.29    16.38     54.490     4.852

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.751075 * X  +  -0.660211 * Y  +   0.002900 * Z  +  21.314705
  Y_new =  -0.654569 * X  +  -0.745216 * Y  +  -0.127251 * Z  +  36.713875
  Z_new =   0.086174 * X  +   0.093677 * Y  +  -0.991866 * Z  +  32.491024 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.047427   -0.094166  [ DEG:   174.6047     -5.3953 ]
  Theta =  -0.086281   -3.055312  [ DEG:    -4.9435   -175.0565 ]
  Phi   =  -0.716850    2.424743  [ DEG:   -41.0725    138.9275 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3db0_B                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3db0_B.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124  145   5.0  116   2.29   16.38  54.490
REMARK  ---------------------------------------------------------- 
MOLECULE 3db0_B
HEADER    OXIDOREDUCTASE                          30-MAY-08   3DB0              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE PYRIDOXAMINE 5'-PHOSPHATE               
TITLE    2 OXIDASE (NP_472219.1) FROM LISTERIA INNOCUA AT 2.00 A                
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: LIN2891 PROTEIN;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: LISTERIA INNOCUA;                               
SOURCE   3 GENE: LIN2891;                                                       
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_472219.1, PUTATIVE PYRIDOXAMINE 5'-PHOSPHATE OXIDASE,              
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2, OXIDOREDUCTASE            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-JUL-08 3DB0    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE PYRIDOXAMINE                   
JRNL        TITL 2 5'-PHOSPHATE OXIDASE (NP_472219.1) FROM LISTERIA             
JRNL        TITL 3 INNOCUA AT 2.00 A RESOLUTION                                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  3DB0 A    1   127  UNP    Q926Z8   Q926Z8_LISIN     1    127             
DBREF  3DB0 B    1   127  UNP    Q926Z8   Q926Z8_LISIN     1    127             
SEQRES   1 A  128  GLY MSE GLU ASN GLU LEU GLU ASP LYS ILE LEU ALA ILE          
SEQRES   2 A  128  LEU GLU GLN HIS GLN VAL GLY VAL LEU THR SER VAL GLN          
SEQRES   3 A  128  GLY ASP PHE PRO HIS ALA ARG TYR MSE THR PHE LEU HIS          
SEQRES   4 A  128  ASP GLY LEU THR LEU TYR THR PRO SER GLY LYS GLU LEU          
SEQRES   5 A  128  PRO LYS THR GLU GLU VAL ARG ARG ASN PRO HIS VAL CYS          
SEQRES   6 A  128  VAL LEU ILE GLY TYR ASP SER PRO GLY SER ALA PHE LEU          
SEQRES   7 A  128  GLU ILE ASN GLY LEU ALA SER LEU GLU GLU ASP GLU SER          
SEQRES   8 A  128  ILE LYS GLU ARG ILE TRP GLU ASN ILE SER LYS ASP TRP          
SEQRES   9 A  128  PHE GLN GLY GLU ASP SER PRO SER PHE VAL VAL ILE LYS          
SEQRES  10 A  128  ILE VAL PRO GLU GLN ILE ARG ILE LEU ASN SER                  
SEQRES   1 B  128  GLY MSE GLU ASN GLU LEU GLU ASP LYS ILE LEU ALA ILE          
SEQRES   2 B  128  LEU GLU GLN HIS GLN VAL GLY VAL LEU THR SER VAL GLN          
SEQRES   3 B  128  GLY ASP PHE PRO HIS ALA ARG TYR MSE THR PHE LEU HIS          
SEQRES   4 B  128  ASP GLY LEU THR LEU TYR THR PRO SER GLY LYS GLU LEU          
SEQRES   5 B  128  PRO LYS THR GLU GLU VAL ARG ARG ASN PRO HIS VAL CYS          
SEQRES   6 B  128  VAL LEU ILE GLY TYR ASP SER PRO GLY SER ALA PHE LEU          
SEQRES   7 B  128  GLU ILE ASN GLY LEU ALA SER LEU GLU GLU ASP GLU SER          
SEQRES   8 B  128  ILE LYS GLU ARG ILE TRP GLU ASN ILE SER LYS ASP TRP          
SEQRES   9 B  128  PHE GLN GLY GLU ASP SER PRO SER PHE VAL VAL ILE LYS          
SEQRES  10 B  128  ILE VAL PRO GLU GLN ILE ARG ILE LEU ASN SER                  
HET    MSE  A   1       8                                                       
HET    MSE  A  34       8                                                       
HET    MSE  B  34       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *109(H2 O)                                                    
CRYST1   92.160   42.230   62.020  90.00  91.59  90.00 C 1 2 1       8          
ATOM    891  N   GLU B   4       5.294  42.814  18.023  1.00 42.38           N  
ATOM    892  CA  GLU B   4       6.014  42.399  16.776  1.00 41.19           C  
ATOM    893  C   GLU B   4       6.746  41.075  17.036  1.00 39.47           C  
ATOM    894  O   GLU B   4       7.211  40.399  16.096  1.00 37.31           O  
ATOM    895  CB  GLU B   4       7.002  43.489  16.312  1.00 41.11           C  
ATOM    896  CG  GLU B   4       8.087  43.824  17.318  1.00 39.34           C  
ATOM    897  N   LEU B   5       6.865  40.740  18.324  1.00 37.46           N  
ATOM    898  CA  LEU B   5       7.509  39.492  18.733  1.00 36.64           C  
ATOM    899  C   LEU B   5       6.688  38.323  18.206  1.00 34.39           C  
ATOM    900  O   LEU B   5       7.281  37.388  17.668  1.00 31.86           O  
ATOM    901  CB  LEU B   5       7.697  39.401  20.255  1.00 35.60           C  
ATOM    902  CG  LEU B   5       8.342  38.123  20.808  1.00 36.47           C  
ATOM    903  CD1 LEU B   5       9.594  37.776  20.066  1.00 37.02           C  
ATOM    904  CD2 LEU B   5       8.626  38.251  22.302  1.00 39.29           C  
ATOM    905  N   GLU B   6       5.347  38.384  18.342  1.00 34.67           N  
ATOM    906  CA  GLU B   6       4.483  37.287  17.841  1.00 35.57           C  
ATOM    907  C   GLU B   6       4.719  37.253  16.366  1.00 34.45           C  
ATOM    908  O   GLU B   6       4.763  36.190  15.778  1.00 36.01           O  
ATOM    909  CB  GLU B   6       2.950  37.505  17.904  1.00 37.20           C  
ATOM    910  CG  GLU B   6       2.267  37.896  19.172  1.00 44.92           C  
ATOM    911  CD  GLU B   6       2.657  37.040  20.294  1.00 51.63           C  
ATOM    912  OE1 GLU B   6       3.883  36.878  20.401  1.00 53.06           O  
ATOM    913  OE2 GLU B   6       1.769  36.584  21.064  1.00 55.13           O  
ATOM    914  N   ASP B   7       4.749  38.446  15.766  1.00 33.33           N  
ATOM    915  CA  ASP B   7       4.878  38.536  14.319  1.00 32.02           C  
ATOM    916  C   ASP B   7       6.125  37.833  13.882  1.00 28.94           C  
ATOM    917  O   ASP B   7       6.093  37.098  12.926  1.00 29.46           O  
ATOM    918  CB  ASP B   7       4.802  39.976  13.802  1.00 35.52           C  
ATOM    919  CG  ASP B   7       3.356  40.492  13.735  1.00 34.61           C  
ATOM    920  OD1 ASP B   7       2.433  39.671  13.914  1.00 47.65           O  
ATOM    921  OD2 ASP B   7       3.157  41.697  13.491  1.00 44.63           O  
ATOM    922  N   LYS B   8       7.201  37.959  14.648  1.00 28.43           N  
ATOM    923  CA  LYS B   8       8.452  37.271  14.279  1.00 28.59           C  
ATOM    924  C   LYS B   8       8.338  35.760  14.523  1.00 26.95           C  
ATOM    925  O   LYS B   8       8.839  34.947  13.766  1.00 27.30           O  
ATOM    926  CB  LYS B   8       9.677  37.889  15.003  1.00 29.46           C  
ATOM    927  N   ILE B   9       7.643  35.392  15.585  1.00 29.92           N  
ATOM    928  CA  ILE B   9       7.441  33.977  15.905  1.00 24.61           C  
ATOM    929  C   ILE B   9       6.649  33.369  14.769  1.00 25.27           C  
ATOM    930  O   ILE B   9       7.020  32.332  14.229  1.00 26.29           O  
ATOM    931  CB  ILE B   9       6.745  33.800  17.271  1.00 25.78           C  
ATOM    932  CG1 ILE B   9       7.662  34.229  18.387  1.00 23.30           C  
ATOM    933  CG2 ILE B   9       6.329  32.320  17.554  1.00 23.82           C  
ATOM    934  CD1 ILE B   9       6.979  34.479  19.704  1.00 25.41           C  
ATOM    935  N   LEU B  10       5.570  34.042  14.355  1.00 25.00           N  
ATOM    936  CA  LEU B  10       4.696  33.501  13.305  1.00 24.56           C  
ATOM    937  C   LEU B  10       5.391  33.355  11.984  1.00 23.92           C  
ATOM    938  O   LEU B  10       5.162  32.388  11.235  1.00 26.43           O  
ATOM    939  CB  LEU B  10       3.434  34.357  13.149  1.00 28.23           C  
ATOM    940  CG  LEU B  10       2.459  34.191  14.291  1.00 33.38           C  
ATOM    941  CD1 LEU B  10       1.395  35.286  14.310  1.00 34.45           C  
ATOM    942  CD2 LEU B  10       1.833  32.808  14.127  1.00 30.00           C  
ATOM    943  N   ALA B  11       6.268  34.312  11.695  1.00 27.09           N  
ATOM    944  CA  ALA B  11       7.011  34.315  10.432  1.00 27.06           C  
ATOM    945  C   ALA B  11       7.872  33.050  10.375  1.00 29.21           C  
ATOM    946  O   ALA B  11       7.918  32.344   9.360  1.00 31.11           O  
ATOM    947  CB  ALA B  11       7.881  35.613  10.297  1.00 29.17           C  
ATOM    948  N   ILE B  12       8.493  32.713  11.504  1.00 25.92           N  
ATOM    949  CA  ILE B  12       9.368  31.554  11.536  1.00 25.02           C  
ATOM    950  C   ILE B  12       8.499  30.262  11.365  1.00 27.97           C  
ATOM    951  O   ILE B  12       8.861  29.338  10.615  1.00 30.55           O  
ATOM    952  CB  ILE B  12      10.186  31.502  12.820  1.00 24.32           C  
ATOM    953  CG1 ILE B  12      11.203  32.657  12.920  1.00 28.56           C  
ATOM    954  CG2 ILE B  12      10.922  30.173  12.886  1.00 24.77           C  
ATOM    955  CD1 ILE B  12      11.931  32.740  14.258  1.00 27.21           C  
ATOM    956  N   LEU B  13       7.337  30.245  12.023  1.00 24.76           N  
ATOM    957  CA  LEU B  13       6.406  29.105  11.907  1.00 26.43           C  
ATOM    958  C   LEU B  13       5.832  29.013  10.492  1.00 27.50           C  
ATOM    959  O   LEU B  13       5.570  27.932  10.009  1.00 29.87           O  
ATOM    960  CB  LEU B  13       5.227  29.202  12.909  1.00 23.89           C  
ATOM    961  CG  LEU B  13       5.585  29.071  14.396  1.00 19.63           C  
ATOM    962  CD1 LEU B  13       4.387  29.263  15.315  1.00 22.84           C  
ATOM    963  CD2 LEU B  13       6.305  27.690  14.638  1.00 19.00           C  
ATOM    964  N   GLU B  14       5.636  30.146   9.827  1.00 25.13           N  
ATOM    965  CA  GLU B  14       5.028  30.097   8.509  1.00 30.44           C  
ATOM    966  C   GLU B  14       5.979  29.539   7.482  1.00 31.51           C  
ATOM    967  O   GLU B  14       5.560  28.889   6.519  1.00 35.14           O  
ATOM    968  CB  GLU B  14       4.516  31.487   8.089  1.00 31.33           C  
ATOM    969  CG  GLU B  14       3.479  32.036   9.053  1.00 34.80           C  
ATOM    970  CD  GLU B  14       3.111  33.461   8.791  1.00 40.92           C  
ATOM    971  OE1 GLU B  14       3.893  34.151   8.103  1.00 47.22           O  
ATOM    972  OE2 GLU B  14       2.060  33.905   9.313  1.00 47.24           O  
ATOM    973  N   GLN B  15       7.265  29.726   7.743  1.00 30.42           N  
ATOM    974  CA  GLN B  15       8.302  29.329   6.821  1.00 30.22           C  
ATOM    975  C   GLN B  15       8.925  28.003   7.106  1.00 31.37           C  
ATOM    976  O   GLN B  15       9.756  27.557   6.349  1.00 29.45           O  
ATOM    977  CB  GLN B  15       9.348  30.423   6.797  1.00 32.12           C  
ATOM    978  CG  GLN B  15       8.721  31.736   6.355  1.00 40.22           C  
ATOM    979  CD  GLN B  15       9.419  32.943   6.931  1.00 49.99           C  
ATOM    980  OE1 GLN B  15      10.547  32.840   7.414  1.00 59.08           O  
ATOM    981  NE2 GLN B  15       8.737  34.093   6.917  1.00 53.52           N  
ATOM    982  N   HIS B  16       8.517  27.345   8.193  1.00 30.45           N  
ATOM    983  CA  HIS B  16       9.093  26.034   8.536  1.00 31.78           C  
ATOM    984  C   HIS B  16       8.034  25.041   9.004  1.00 32.34           C  
ATOM    985  O   HIS B  16       7.226  25.330   9.863  1.00 35.60           O  
ATOM    986  CB  HIS B  16      10.157  26.155   9.639  1.00 30.41           C  
ATOM    987  CG  HIS B  16      11.263  27.083   9.293  1.00 28.32           C  
ATOM    988  ND1 HIS B  16      11.170  28.448   9.459  1.00 29.60           N  
ATOM    989  CD2 HIS B  16      12.469  26.852   8.737  1.00 25.56           C  
ATOM    990  CE1 HIS B  16      12.283  29.013   9.034  1.00 22.95           C  
ATOM    991  NE2 HIS B  16      13.085  28.068   8.586  1.00 25.21           N  
ATOM    992  N   GLN B  17       8.092  23.855   8.436  1.00 29.66           N  
ATOM    993  CA  GLN B  17       7.177  22.809   8.781  1.00 31.81           C  
ATOM    994  C   GLN B  17       7.919  21.605   9.379  1.00 33.52           C  
ATOM    995  O   GLN B  17       7.287  20.626   9.736  1.00 38.12           O  
ATOM    996  CB  GLN B  17       6.396  22.350   7.573  1.00 31.34           C  
ATOM    997  CG  GLN B  17       5.201  23.233   7.240  1.00 45.87           C  
ATOM    998  CD  GLN B  17       4.308  22.606   6.161  1.00 52.08           C  
ATOM    999  OE1 GLN B  17       4.696  21.642   5.496  1.00 54.96           O  
ATOM   1000  NE2 GLN B  17       3.113  23.163   5.983  1.00 47.07           N  
ATOM   1001  N   VAL B  18       9.248  21.642   9.402  1.00 31.15           N  
ATOM   1002  CA  VAL B  18       9.999  20.563  10.052  1.00 29.14           C  
ATOM   1003  C   VAL B  18      10.677  21.125  11.299  1.00 28.20           C  
ATOM   1004  O   VAL B  18      11.276  22.199  11.278  1.00 28.91           O  
ATOM   1005  CB  VAL B  18      11.048  19.902   9.125  1.00 30.69           C  
ATOM   1006  CG1 VAL B  18      11.853  18.841   9.867  1.00 24.44           C  
ATOM   1007  CG2 VAL B  18      10.415  19.301   7.893  1.00 31.96           C  
ATOM   1008  N   GLY B  19      10.577  20.394  12.389  1.00 24.76           N  
ATOM   1009  CA  GLY B  19      11.218  20.792  13.615  1.00 24.21           C  
ATOM   1010  C   GLY B  19      11.632  19.564  14.360  1.00 24.11           C  
ATOM   1011  O   GLY B  19      11.413  18.430  13.898  1.00 21.18           O  
ATOM   1012  N   VAL B  20      12.226  19.796  15.518  1.00 22.91           N  
ATOM   1013  CA  VAL B  20      12.664  18.723  16.411  1.00 25.08           C  
ATOM   1014  C   VAL B  20      11.718  18.679  17.624  1.00 25.01           C  
ATOM   1015  O   VAL B  20      11.536  19.677  18.307  1.00 23.67           O  
ATOM   1016  CB  VAL B  20      14.161  18.969  16.893  1.00 28.01           C  
ATOM   1017  CG1 VAL B  20      14.628  17.900  17.859  1.00 22.46           C  
ATOM   1018  CG2 VAL B  20      15.142  19.062  15.704  1.00 22.38           C  
ATOM   1019  N   LEU B  21      11.070  17.545  17.859  1.00 21.88           N  
ATOM   1020  CA  LEU B  21      10.284  17.384  19.055  1.00 22.34           C  
ATOM   1021  C   LEU B  21      11.121  16.631  20.073  1.00 23.69           C  
ATOM   1022  O   LEU B  21      11.661  15.582  19.750  1.00 22.74           O  
ATOM   1023  CB  LEU B  21       9.053  16.499  18.820  1.00 24.83           C  
ATOM   1024  CG  LEU B  21       8.253  16.339  20.127  1.00 26.96           C  
ATOM   1025  CD1 LEU B  21       7.437  17.624  20.478  1.00 20.26           C  
ATOM   1026  CD2 LEU B  21       7.377  15.172  19.998  1.00 27.07           C  
ATOM   1027  N   THR B  22      11.231  17.153  21.290  1.00 22.98           N  
ATOM   1028  CA  THR B  22      11.902  16.422  22.352  1.00 21.66           C  
ATOM   1029  C   THR B  22      10.852  16.114  23.387  1.00 20.32           C  
ATOM   1030  O   THR B  22      10.163  17.000  23.870  1.00 20.75           O  
ATOM   1031  CB  THR B  22      13.074  17.219  22.962  1.00 24.87           C  
ATOM   1032  OG1 THR B  22      14.011  17.547  21.919  1.00 24.69           O  
ATOM   1033  CG2 THR B  22      13.767  16.405  24.096  1.00 24.48           C  
ATOM   1034  N   SER B  23      10.672  14.818  23.625  1.00 21.81           N  
ATOM   1035  CA  SER B  23       9.736  14.263  24.607  1.00 22.75           C  
ATOM   1036  C   SER B  23      10.564  13.441  25.612  1.00 23.27           C  
ATOM   1037  O   SER B  23      11.799  13.283  25.463  1.00 21.19           O  
ATOM   1038  CB  SER B  23       8.630  13.471  23.946  1.00 24.06           C  
ATOM   1039  OG  SER B  23       9.155  12.561  22.978  1.00 31.42           O  
ATOM   1040  N   VAL B  24       9.883  12.959  26.644  1.00 21.84           N  
ATOM   1041  CA  VAL B  24      10.526  12.304  27.744  1.00 22.28           C  
ATOM   1042  C   VAL B  24       9.885  10.960  27.982  1.00 24.89           C  
ATOM   1043  O   VAL B  24       8.656  10.822  27.949  1.00 28.74           O  
ATOM   1044  CB  VAL B  24      10.350  13.154  29.050  1.00 24.26           C  
ATOM   1045  CG1 VAL B  24      10.872  12.417  30.306  1.00 21.44           C  
ATOM   1046  CG2 VAL B  24      10.943  14.538  28.888  1.00 27.38           C  
ATOM   1047  N   GLN B  25      10.737   9.976  28.170  1.00 24.78           N  
ATOM   1048  CA  GLN B  25      10.329   8.609  28.532  1.00 26.17           C  
ATOM   1049  C   GLN B  25      11.019   8.247  29.840  1.00 23.98           C  
ATOM   1050  O   GLN B  25      12.119   7.685  29.860  1.00 24.12           O  
ATOM   1051  CB  GLN B  25      10.762   7.630  27.441  1.00 28.26           C  
ATOM   1052  CG  GLN B  25      10.456   6.205  27.766  1.00 32.78           C  
ATOM   1053  CD  GLN B  25      11.697   5.299  27.632  1.00 46.32           C  
ATOM   1054  OE1 GLN B  25      12.682   5.616  26.930  1.00 31.55           O  
ATOM   1055  NE2 GLN B  25      11.651   4.168  28.323  1.00 37.86           N  
ATOM   1056  N   GLY B  26      10.368   8.559  30.950  1.00 25.59           N  
ATOM   1057  CA  GLY B  26      10.946   8.292  32.255  1.00 23.90           C  
ATOM   1058  C   GLY B  26      12.058   9.288  32.422  1.00 23.83           C  
ATOM   1059  O   GLY B  26      11.812  10.469  32.435  1.00 29.46           O  
ATOM   1060  N   ASP B  27      13.294   8.818  32.505  1.00 22.49           N  
ATOM   1061  CA  ASP B  27      14.455   9.706  32.636  1.00 22.69           C  
ATOM   1062  C   ASP B  27      15.168   9.942  31.302  1.00 21.00           C  
ATOM   1063  O   ASP B  27      16.220  10.577  31.275  1.00 24.02           O  
ATOM   1064  CB  ASP B  27      15.489   9.122  33.600  1.00 24.13           C  
ATOM   1065  CG  ASP B  27      14.930   8.938  35.000  1.00 30.59           C  
ATOM   1066  OD1 ASP B  27      14.315   9.898  35.479  1.00 31.77           O  
ATOM   1067  OD2 ASP B  27      15.066   7.826  35.567  1.00 33.51           O  
ATOM   1068  N   PHE B  28      14.603   9.464  30.214  1.00 21.28           N  
ATOM   1069  CA  PHE B  28      15.279   9.600  28.912  1.00 22.11           C  
ATOM   1070  C   PHE B  28      14.666  10.610  27.954  1.00 22.96           C  
ATOM   1071  O   PHE B  28      13.452  10.583  27.709  1.00 23.25           O  
ATOM   1072  CB  PHE B  28      15.327   8.268  28.213  1.00 23.03           C  
ATOM   1073  CG  PHE B  28      16.110   7.226  28.937  1.00 25.86           C  
ATOM   1074  CD1 PHE B  28      15.523   6.483  29.950  1.00 34.83           C  
ATOM   1075  CD2 PHE B  28      17.436   6.988  28.602  1.00 30.51           C  
ATOM   1076  CE1 PHE B  28      16.263   5.504  30.641  1.00 39.60           C  
ATOM   1077  CE2 PHE B  28      18.178   6.013  29.277  1.00 34.80           C  
ATOM   1078  CZ  PHE B  28      17.588   5.278  30.300  1.00 29.20           C  
ATOM   1079  N   PRO B  29      15.519  11.481  27.362  1.00 20.87           N  
ATOM   1080  CA  PRO B  29      14.980  12.359  26.343  1.00 20.13           C  
ATOM   1081  C   PRO B  29      14.886  11.584  25.007  1.00 21.65           C  
ATOM   1082  O   PRO B  29      15.663  10.652  24.751  1.00 22.71           O  
ATOM   1083  CB  PRO B  29      16.032  13.483  26.276  1.00 16.93           C  
ATOM   1084  CG  PRO B  29      17.278  12.848  26.656  1.00 20.39           C  
ATOM   1085  CD  PRO B  29      16.908  11.844  27.717  1.00 21.93           C  
ATOM   1086  N   HIS B  30      13.906  11.906  24.213  1.00 19.86           N  
ATOM   1087  CA  HIS B  30      13.830  11.364  22.867  1.00 22.55           C  
ATOM   1088  C   HIS B  30      13.688  12.554  21.938  1.00 23.86           C  
ATOM   1089  O   HIS B  30      12.779  13.348  22.095  1.00 24.48           O  
ATOM   1090  CB  HIS B  30      12.630  10.437  22.687  1.00 24.99           C  
ATOM   1091  CG  HIS B  30      12.748   9.147  23.436  1.00 27.13           C  
ATOM   1092  ND1 HIS B  30      13.402   8.056  22.921  1.00 42.31           N  
ATOM   1093  CD2 HIS B  30      12.320   8.783  24.665  1.00 31.98           C  
ATOM   1094  CE1 HIS B  30      13.365   7.068  23.798  1.00 43.97           C  
ATOM   1095  NE2 HIS B  30      12.719   7.484  24.867  1.00 28.39           N  
ATOM   1096  N   ALA B  31      14.606  12.709  20.993  1.00 21.62           N  
ATOM   1097  CA  ALA B  31      14.476  13.806  20.046  1.00 21.19           C  
ATOM   1098  C   ALA B  31      14.184  13.210  18.683  1.00 21.06           C  
ATOM   1099  O   ALA B  31      14.821  12.249  18.273  1.00 22.76           O  
ATOM   1100  CB  ALA B  31      15.756  14.659  19.990  1.00 17.98           C  
ATOM   1101  N   ARG B  32      13.238  13.813  17.981  1.00 20.86           N  
ATOM   1102  CA  ARG B  32      12.883  13.372  16.653  1.00 21.12           C  
ATOM   1103  C   ARG B  32      12.511  14.530  15.750  1.00 22.95           C  
ATOM   1104  O   ARG B  32      11.938  15.502  16.187  1.00 23.49           O  
ATOM   1105  CB  ARG B  32      11.683  12.420  16.689  1.00 23.47           C  
ATOM   1106  CG  ARG B  32      11.819  11.253  17.639  1.00 21.69           C  
ATOM   1107  CD  ARG B  32      10.531  10.475  17.698  1.00 19.58           C  
ATOM   1108  NE  ARG B  32      10.604   9.263  18.537  1.00 23.67           N  
ATOM   1109  CZ  ARG B  32      10.272   9.203  19.824  1.00 28.15           C  
ATOM   1110  NH1 ARG B  32       9.906  10.289  20.449  1.00 29.28           N  
ATOM   1111  NH2 ARG B  32      10.355   8.063  20.490  1.00 25.35           N  
ATOM   1112  N   TYR B  33      12.850  14.382  14.480  1.00 22.45           N  
ATOM   1113  CA  TYR B  33      12.479  15.350  13.467  1.00 23.41           C  
ATOM   1114  C   TYR B  33      11.087  15.010  12.999  1.00 24.86           C  
ATOM   1115  O   TYR B  33      10.725  13.843  12.846  1.00 26.66           O  
ATOM   1116  CB  TYR B  33      13.389  15.341  12.259  1.00 24.67           C  
ATOM   1117  CG  TYR B  33      14.661  16.091  12.455  1.00 18.01           C  
ATOM   1118  CD1 TYR B  33      14.688  17.456  12.401  1.00 24.93           C  
ATOM   1119  CD2 TYR B  33      15.841  15.428  12.754  1.00 29.92           C  
ATOM   1120  CE1 TYR B  33      15.854  18.143  12.588  1.00 23.33           C  
ATOM   1121  CE2 TYR B  33      17.021  16.134  12.973  1.00 26.70           C  
ATOM   1122  CZ  TYR B  33      17.019  17.456  12.879  1.00 21.77           C  
ATOM   1123  OH  TYR B  33      18.170  18.180  13.107  1.00 21.78           O  
HETATM 1124  N   MSE B  34      10.264  16.023  12.835  1.00 21.95           N  
HETATM 1125  CA  MSE B  34       8.951  15.778  12.287  1.00 24.11           C  
HETATM 1126  C   MSE B  34       8.271  17.051  11.764  1.00 23.90           C  
HETATM 1127  O   MSE B  34       8.778  18.169  11.897  1.00 25.87           O  
HETATM 1128  CB  MSE B  34       8.048  15.065  13.295  1.00 23.16           C  
HETATM 1129  CG  MSE B  34       7.784  15.938  14.544  1.00 18.26           C  
HETATM 1130 SE   MSE B  34       6.943  15.029  16.010  0.75 21.15          SE  
HETATM 1131  CE  MSE B  34       8.513  13.898  16.446  1.00 25.84           C  
ATOM   1132  N   THR B  35       7.128  16.822  11.134  1.00 25.59           N  
ATOM   1133  CA  THR B  35       6.328  17.878  10.511  1.00 26.45           C  
ATOM   1134  C   THR B  35       5.396  18.458  11.544  1.00 26.17           C  
ATOM   1135  O   THR B  35       4.759  17.718  12.340  1.00 25.36           O  
ATOM   1136  CB  THR B  35       5.549  17.342   9.293  1.00 30.86           C  
ATOM   1137  OG1 THR B  35       6.502  16.809   8.396  1.00 34.72           O  
ATOM   1138  CG2 THR B  35       4.722  18.443   8.541  1.00 27.33           C  
ATOM   1139  N   PHE B  36       5.417  19.790  11.549  1.00 24.61           N  
ATOM   1140  CA  PHE B  36       4.568  20.627  12.357  1.00 25.96           C  
ATOM   1141  C   PHE B  36       3.701  21.544  11.511  1.00 27.48           C  
ATOM   1142  O   PHE B  36       4.220  22.302  10.696  1.00 28.94           O  
ATOM   1143  CB  PHE B  36       5.399  21.502  13.287  1.00 23.70           C  
ATOM   1144  CG  PHE B  36       6.141  20.717  14.349  1.00 23.74           C  
ATOM   1145  CD1 PHE B  36       5.523  20.387  15.565  1.00 34.82           C  
ATOM   1146  CD2 PHE B  36       7.394  20.228  14.108  1.00 22.32           C  
ATOM   1147  CE1 PHE B  36       6.191  19.656  16.529  1.00 21.88           C  
ATOM   1148  CE2 PHE B  36       8.054  19.461  15.068  1.00 29.50           C  
ATOM   1149  CZ  PHE B  36       7.447  19.177  16.271  1.00 23.07           C  
ATOM   1150  N   LEU B  37       2.390  21.486  11.748  1.00 26.29           N  
ATOM   1151  CA  LEU B  37       1.446  22.486  11.235  1.00 22.58           C  
ATOM   1152  C   LEU B  37       1.194  23.443  12.409  1.00 23.58           C  
ATOM   1153  O   LEU B  37       1.468  23.119  13.585  1.00 24.31           O  
ATOM   1154  CB  LEU B  37       0.114  21.821  10.796  1.00 24.30           C  
ATOM   1155  CG  LEU B  37       0.351  20.732   9.731  1.00 28.99           C  
ATOM   1156  CD1 LEU B  37      -0.896  20.173   9.082  1.00 27.85           C  
ATOM   1157  CD2 LEU B  37       1.170  21.330   8.642  1.00 36.86           C  
ATOM   1158  N   HIS B  38       0.691  24.638  12.144  1.00 24.95           N  
ATOM   1159  CA  HIS B  38       0.321  25.520  13.239  1.00 23.71           C  
ATOM   1160  C   HIS B  38      -0.941  26.284  12.885  1.00 24.00           C  
ATOM   1161  O   HIS B  38      -1.330  26.432  11.745  1.00 24.63           O  
ATOM   1162  CB  HIS B  38       1.439  26.520  13.531  1.00 25.67           C  
ATOM   1163  CG  HIS B  38       1.599  27.518  12.445  1.00 25.92           C  
ATOM   1164  ND1 HIS B  38       1.123  28.808  12.549  1.00 25.93           N  
ATOM   1165  CD2 HIS B  38       2.024  27.368  11.168  1.00 24.95           C  
ATOM   1166  CE1 HIS B  38       1.322  29.430  11.403  1.00 19.50           C  
ATOM   1167  NE2 HIS B  38       1.864  28.577  10.551  1.00 25.82           N  
ATOM   1168  N   ASP B  39      -1.582  26.704  13.933  1.00 25.95           N  
ATOM   1169  CA  ASP B  39      -2.755  27.506  13.921  1.00 25.74           C  
ATOM   1170  C   ASP B  39      -2.427  28.559  14.944  1.00 26.80           C  
ATOM   1171  O   ASP B  39      -2.544  28.359  16.173  1.00 26.30           O  
ATOM   1172  CB  ASP B  39      -3.981  26.730  14.379  1.00 28.09           C  
ATOM   1173  CG  ASP B  39      -5.212  27.646  14.508  1.00 35.59           C  
ATOM   1174  OD1 ASP B  39      -5.284  28.590  13.723  1.00 33.68           O  
ATOM   1175  OD2 ASP B  39      -6.064  27.450  15.388  1.00 41.29           O  
ATOM   1176  N   GLY B  40      -1.986  29.700  14.470  1.00 27.82           N  
ATOM   1177  CA  GLY B  40      -1.550  30.700  15.425  1.00 26.02           C  
ATOM   1178  C   GLY B  40      -0.306  30.109  16.048  1.00 24.93           C  
ATOM   1179  O   GLY B  40       0.504  29.472  15.357  1.00 26.42           O  
ATOM   1180  N   LEU B  41      -0.169  30.278  17.355  1.00 26.12           N  
ATOM   1181  CA  LEU B  41       1.001  29.751  18.065  1.00 27.21           C  
ATOM   1182  C   LEU B  41       0.785  28.308  18.555  1.00 27.41           C  
ATOM   1183  O   LEU B  41       1.683  27.705  19.180  1.00 27.79           O  
ATOM   1184  CB  LEU B  41       1.427  30.661  19.212  1.00 27.92           C  
ATOM   1185  CG  LEU B  41       1.761  32.124  18.888  1.00 32.57           C  
ATOM   1186  CD1 LEU B  41       2.335  32.732  20.139  1.00 32.75           C  
ATOM   1187  CD2 LEU B  41       2.708  32.278  17.716  1.00 27.90           C  
ATOM   1188  N   THR B  42      -0.372  27.739  18.233  1.00 25.69           N  
ATOM   1189  CA  THR B  42      -0.616  26.301  18.536  1.00 26.21           C  
ATOM   1190  C   THR B  42      -0.008  25.387  17.449  1.00 26.36           C  
ATOM   1191  O   THR B  42      -0.205  25.585  16.256  1.00 23.32           O  
ATOM   1192  CB  THR B  42      -2.101  25.991  18.773  1.00 27.45           C  
ATOM   1193  OG1 THR B  42      -2.533  26.667  19.963  1.00 30.71           O  
ATOM   1194  CG2 THR B  42      -2.348  24.488  18.981  1.00 23.38           C  
ATOM   1195  N   LEU B  43       0.751  24.391  17.884  1.00 25.60           N  
ATOM   1196  CA  LEU B  43       1.368  23.449  16.967  1.00 23.92           C  
ATOM   1197  C   LEU B  43       0.639  22.099  16.973  1.00 24.50           C  
ATOM   1198  O   LEU B  43      -0.013  21.700  17.965  1.00 23.65           O  
ATOM   1199  CB  LEU B  43       2.825  23.224  17.312  1.00 25.35           C  
ATOM   1200  CG  LEU B  43       3.833  24.377  17.256  1.00 27.97           C  
ATOM   1201  CD1 LEU B  43       5.220  23.817  17.467  1.00 30.50           C  
ATOM   1202  CD2 LEU B  43       3.839  25.148  15.993  1.00 33.23           C  
ATOM   1203  N   TYR B  44       0.689  21.447  15.822  1.00 22.63           N  
ATOM   1204  CA  TYR B  44       0.053  20.140  15.620  1.00 22.01           C  
ATOM   1205  C   TYR B  44       1.056  19.288  14.870  1.00 23.89           C  
ATOM   1206  O   TYR B  44       1.771  19.748  13.979  1.00 24.22           O  
ATOM   1207  CB  TYR B  44      -1.255  20.234  14.814  1.00 24.73           C  
ATOM   1208  CG  TYR B  44      -2.372  21.023  15.474  1.00 25.85           C  
ATOM   1209  CD1 TYR B  44      -3.166  20.457  16.469  1.00 25.94           C  
ATOM   1210  CD2 TYR B  44      -2.680  22.286  15.052  1.00 24.88           C  
ATOM   1211  CE1 TYR B  44      -4.202  21.172  17.069  1.00 25.39           C  
ATOM   1212  CE2 TYR B  44      -3.715  23.008  15.630  1.00 27.64           C  
ATOM   1213  CZ  TYR B  44      -4.465  22.449  16.642  1.00 31.16           C  
ATOM   1214  OH  TYR B  44      -5.446  23.170  17.239  1.00 33.25           O  
ATOM   1215  N   THR B  45       1.222  18.061  15.322  1.00 25.20           N  
ATOM   1216  CA  THR B  45       2.074  17.161  14.600  1.00 22.70           C  
ATOM   1217  C   THR B  45       1.362  15.767  14.535  1.00 25.43           C  
ATOM   1218  O   THR B  45       0.802  15.278  15.558  1.00 24.36           O  
ATOM   1219  CB  THR B  45       3.506  17.117  15.234  1.00 25.94           C  
ATOM   1220  OG1 THR B  45       4.372  16.380  14.387  1.00 26.71           O  
ATOM   1221  CG2 THR B  45       3.485  16.480  16.608  1.00 21.15           C  
ATOM   1222  N   PRO B  46       1.414  15.119  13.351  1.00 24.87           N  
ATOM   1223  CA  PRO B  46       0.801  13.809  13.128  1.00 26.94           C  
ATOM   1224  C   PRO B  46       1.484  12.687  13.837  1.00 27.27           C  
ATOM   1225  O   PRO B  46       2.685  12.721  14.098  1.00 24.64           O  
ATOM   1226  CB  PRO B  46       0.854  13.621  11.595  1.00 27.69           C  
ATOM   1227  CG  PRO B  46       1.848  14.591  11.118  1.00 29.16           C  
ATOM   1228  CD  PRO B  46       2.107  15.627  12.157  1.00 26.04           C  
ATOM   1229  N   SER B  47       0.698  11.682  14.195  1.00 26.18           N  
ATOM   1230  CA  SER B  47       1.286  10.505  14.834  1.00 26.44           C  
ATOM   1231  C   SER B  47       0.363   9.300  14.666  1.00 26.07           C  
ATOM   1232  O   SER B  47      -0.687   9.410  14.043  1.00 24.99           O  
ATOM   1233  CB  SER B  47       1.586  10.816  16.289  1.00 28.27           C  
ATOM   1234  OG  SER B  47       2.329   9.778  16.888  1.00 28.45           O  
ATOM   1235  N   GLY B  48       0.778   8.143  15.165  1.00 26.43           N  
ATOM   1236  CA  GLY B  48      -0.035   6.936  15.142  1.00 25.49           C  
ATOM   1237  C   GLY B  48      -0.354   6.578  16.580  1.00 26.23           C  
ATOM   1238  O   GLY B  48       0.428   6.870  17.482  1.00 24.88           O  
ATOM   1239  N   LYS B  49      -1.500   5.943  16.794  1.00 25.40           N  
ATOM   1240  CA  LYS B  49      -1.953   5.578  18.147  1.00 25.22           C  
ATOM   1241  C   LYS B  49      -0.964   4.748  18.923  1.00 26.54           C  
ATOM   1242  O   LYS B  49      -0.896   4.816  20.167  1.00 24.69           O  
ATOM   1243  CB  LYS B  49      -3.231   4.731  18.125  1.00 26.01           C  
ATOM   1244  CG  LYS B  49      -4.502   5.462  17.867  1.00 35.93           C  
ATOM   1245  CD  LYS B  49      -5.668   4.498  17.817  1.00 31.61           C  
ATOM   1246  CE  LYS B  49      -6.836   5.187  17.155  1.00 34.42           C  
ATOM   1247  NZ  LYS B  49      -7.978   4.267  17.003  1.00 29.95           N  
ATOM   1248  N   GLU B  50      -0.264   3.894  18.194  1.00 25.56           N  
ATOM   1249  CA  GLU B  50       0.703   2.975  18.790  1.00 27.69           C  
ATOM   1250  C   GLU B  50       2.151   3.404  18.730  1.00 27.68           C  
ATOM   1251  O   GLU B  50       3.007   2.651  19.149  1.00 30.11           O  
ATOM   1252  CB  GLU B  50       0.595   1.572  18.169  1.00 31.57           C  
ATOM   1253  CG  GLU B  50      -0.531   0.706  18.746  1.00 34.74           C  
ATOM   1254  CD  GLU B  50      -1.950   1.311  18.614  1.00 40.91           C  
ATOM   1255  OE1 GLU B  50      -2.417   1.521  17.475  1.00 34.03           O  
ATOM   1256  OE2 GLU B  50      -2.601   1.518  19.663  1.00 38.96           O  
ATOM   1257  N   LEU B  51       2.441   4.585  18.203  1.00 24.38           N  
ATOM   1258  CA  LEU B  51       3.835   5.016  18.116  1.00 24.29           C  
ATOM   1259  C   LEU B  51       4.362   5.416  19.472  1.00 22.99           C  
ATOM   1260  O   LEU B  51       3.611   5.878  20.279  1.00 23.76           O  
ATOM   1261  CB  LEU B  51       3.979   6.168  17.161  1.00 23.68           C  
ATOM   1262  CG  LEU B  51       3.720   5.754  15.695  1.00 29.25           C  
ATOM   1263  CD1 LEU B  51       4.151   6.839  14.728  1.00 28.43           C  
ATOM   1264  CD2 LEU B  51       4.453   4.474  15.411  1.00 30.25           C  
ATOM   1265  N   PRO B  52       5.649   5.195  19.726  1.00 26.51           N  
ATOM   1266  CA  PRO B  52       6.281   5.592  20.970  1.00 28.12           C  
ATOM   1267  C   PRO B  52       6.071   7.086  21.309  1.00 26.60           C  
ATOM   1268  O   PRO B  52       5.802   7.381  22.452  1.00 26.82           O  
ATOM   1269  CB  PRO B  52       7.762   5.285  20.732  1.00 29.45           C  
ATOM   1270  CG  PRO B  52       7.750   4.134  19.768  1.00 31.64           C  
ATOM   1271  CD  PRO B  52       6.503   4.279  18.935  1.00 29.04           C  
ATOM   1272  N   LYS B  53       6.161   7.998  20.351  1.00 26.62           N  
ATOM   1273  CA  LYS B  53       6.024   9.417  20.693  1.00 25.94           C  
ATOM   1274  C   LYS B  53       4.633   9.733  21.209  1.00 24.77           C  
ATOM   1275  O   LYS B  53       4.465  10.566  22.077  1.00 22.68           O  
ATOM   1276  CB  LYS B  53       6.403  10.354  19.556  1.00 30.60           C  
ATOM   1277  CG  LYS B  53       5.509  10.289  18.339  1.00 31.49           C  
ATOM   1278  CD  LYS B  53       5.980  11.272  17.280  1.00 34.33           C  
ATOM   1279  CE  LYS B  53       5.100  11.181  16.057  1.00 38.11           C  
ATOM   1280  NZ  LYS B  53       5.760  11.648  14.805  1.00 36.28           N  
ATOM   1281  N   THR B  54       3.629   9.005  20.727  1.00 23.00           N  
ATOM   1282  CA  THR B  54       2.285   9.169  21.216  1.00 22.98           C  
ATOM   1283  C   THR B  54       2.147   8.715  22.660  1.00 22.46           C  
ATOM   1284  O   THR B  54       1.501   9.385  23.460  1.00 23.60           O  
ATOM   1285  CB  THR B  54       1.283   8.344  20.388  1.00 22.98           C  
ATOM   1286  OG1 THR B  54       1.346   8.795  19.032  1.00 26.67           O  
ATOM   1287  CG2 THR B  54      -0.136   8.474  20.972  1.00 23.40           C  
ATOM   1288  N   GLU B  55       2.716   7.557  22.990  1.00 22.50           N  
ATOM   1289  CA  GLU B  55       2.684   7.063  24.365  1.00 24.13           C  
ATOM   1290  C   GLU B  55       3.513   7.932  25.302  1.00 22.32           C  
ATOM   1291  O   GLU B  55       3.182   8.097  26.489  1.00 22.91           O  
ATOM   1292  CB  GLU B  55       3.110   5.585  24.457  1.00 21.81           C  
ATOM   1293  CG  GLU B  55       2.970   4.988  25.871  1.00 33.77           C  
ATOM   1294  CD  GLU B  55       1.533   4.967  26.381  1.00 34.42           C  
ATOM   1295  OE1 GLU B  55       0.604   5.053  25.558  1.00 35.03           O  
ATOM   1296  OE2 GLU B  55       1.347   4.858  27.609  1.00 40.57           O  
ATOM   1297  N   GLU B  56       4.612   8.478  24.793  1.00 20.37           N  
ATOM   1298  CA  GLU B  56       5.428   9.350  25.609  1.00 20.68           C  
ATOM   1299  C   GLU B  56       4.612  10.556  26.089  1.00 25.11           C  
ATOM   1300  O   GLU B  56       4.602  10.898  27.283  1.00 24.63           O  
ATOM   1301  CB  GLU B  56       6.674   9.791  24.847  1.00 21.89           C  
ATOM   1302  CG  GLU B  56       7.691   8.687  24.756  1.00 19.68           C  
ATOM   1303  CD  GLU B  56       8.667   8.884  23.616  1.00 22.26           C  
ATOM   1304  OE1 GLU B  56       8.778  10.009  23.164  1.00 22.14           O  
ATOM   1305  OE2 GLU B  56       9.294   7.909  23.141  1.00 20.23           O  
ATOM   1306  N   VAL B  57       3.937  11.196  25.131  1.00 23.86           N  
ATOM   1307  CA  VAL B  57       3.064  12.369  25.376  1.00 24.91           C  
ATOM   1308  C   VAL B  57       1.894  12.076  26.344  1.00 26.11           C  
ATOM   1309  O   VAL B  57       1.556  12.915  27.179  1.00 25.99           O  
ATOM   1310  CB  VAL B  57       2.562  12.933  24.010  1.00 24.87           C  
ATOM   1311  CG1 VAL B  57       1.364  13.790  24.172  1.00 25.59           C  
ATOM   1312  CG2 VAL B  57       3.737  13.703  23.342  1.00 31.46           C  
ATOM   1313  N   ARG B  58       1.283  10.886  26.223  1.00 24.58           N  
ATOM   1314  CA  ARG B  58       0.211  10.492  27.078  1.00 24.69           C  
ATOM   1315  C   ARG B  58       0.678  10.458  28.496  1.00 24.06           C  
ATOM   1316  O   ARG B  58      -0.056  10.823  29.365  1.00 26.23           O  
ATOM   1317  CB  ARG B  58      -0.323   9.081  26.768  1.00 25.86           C  
ATOM   1318  CG  ARG B  58      -1.051   8.971  25.427  1.00 34.18           C  
ATOM   1319  CD  ARG B  58      -1.927   7.699  25.330  1.00 33.97           C  
ATOM   1320  NE  ARG B  58      -2.437   7.526  23.962  1.00 33.53           N  
ATOM   1321  CZ  ARG B  58      -1.895   6.706  23.055  1.00 46.70           C  
ATOM   1322  NH1 ARG B  58      -0.850   5.938  23.372  1.00 46.58           N  
ATOM   1323  NH2 ARG B  58      -2.416   6.615  21.836  1.00 47.99           N  
ATOM   1324  N   ARG B  59       1.913  10.013  28.716  1.00 20.98           N  
ATOM   1325  CA  ARG B  59       2.447   9.816  30.054  1.00 21.14           C  
ATOM   1326  C   ARG B  59       3.209  11.025  30.609  1.00 22.65           C  
ATOM   1327  O   ARG B  59       3.383  11.153  31.825  1.00 25.19           O  
ATOM   1328  CB  ARG B  59       3.355   8.581  30.080  1.00 24.78           C  
ATOM   1329  CG  ARG B  59       2.599   7.308  29.785  1.00 32.59           C  
ATOM   1330  CD  ARG B  59       3.449   6.191  29.230  1.00 49.16           C  
ATOM   1331  NE  ARG B  59       3.899   5.237  30.230  1.00 64.75           N  
ATOM   1332  CZ  ARG B  59       4.087   3.947  29.969  1.00 69.91           C  
ATOM   1333  NH1 ARG B  59       3.810   3.466  28.761  1.00 73.25           N  
ATOM   1334  NH2 ARG B  59       4.502   3.129  30.922  1.00 76.88           N  
ATOM   1335  N   ASN B  60       3.713  11.865  29.721  1.00 21.58           N  
ATOM   1336  CA  ASN B  60       4.405  13.109  30.149  1.00 23.00           C  
ATOM   1337  C   ASN B  60       4.145  14.173  29.074  1.00 22.00           C  
ATOM   1338  O   ASN B  60       4.677  14.061  27.978  1.00 23.03           O  
ATOM   1339  CB  ASN B  60       5.903  12.861  30.361  1.00 25.44           C  
ATOM   1340  CG  ASN B  60       6.662  14.096  30.855  1.00 23.96           C  
ATOM   1341  OD1 ASN B  60       6.209  15.212  30.690  1.00 24.04           O  
ATOM   1342  ND2 ASN B  60       7.816  13.882  31.465  1.00 20.04           N  
ATOM   1343  N   PRO B  61       3.290  15.181  29.376  1.00 19.63           N  
ATOM   1344  CA  PRO B  61       2.907  16.196  28.397  1.00 22.26           C  
ATOM   1345  C   PRO B  61       3.973  17.268  28.082  1.00 23.66           C  
ATOM   1346  O   PRO B  61       3.824  18.054  27.152  1.00 21.03           O  
ATOM   1347  CB  PRO B  61       1.683  16.846  29.045  1.00 22.62           C  
ATOM   1348  CG  PRO B  61       2.017  16.794  30.527  1.00 22.15           C  
ATOM   1349  CD  PRO B  61       2.624  15.397  30.681  1.00 23.16           C  
ATOM   1350  N   HIS B  62       5.063  17.253  28.828  1.00 19.44           N  
ATOM   1351  CA  HIS B  62       6.085  18.280  28.687  1.00 18.08           C  
ATOM   1352  C   HIS B  62       6.986  17.971  27.488  1.00 21.54           C  
ATOM   1353  O   HIS B  62       7.706  16.948  27.453  1.00 21.88           O  
ATOM   1354  CB  HIS B  62       6.926  18.387  29.915  1.00 19.49           C  
ATOM   1355  CG  HIS B  62       6.135  18.502  31.173  1.00 21.80           C  
ATOM   1356  ND1 HIS B  62       5.939  17.436  32.027  1.00 26.45           N  
ATOM   1357  CD2 HIS B  62       5.425  19.528  31.687  1.00 25.89           C  
ATOM   1358  CE1 HIS B  62       5.186  17.816  33.042  1.00 26.72           C  
ATOM   1359  NE2 HIS B  62       4.853  19.076  32.857  1.00 27.18           N  
ATOM   1360  N   VAL B  63       6.930  18.884  26.535  1.00 22.49           N  
ATOM   1361  CA  VAL B  63       7.714  18.778  25.303  1.00 24.28           C  
ATOM   1362  C   VAL B  63       8.454  20.060  25.034  1.00 23.23           C  
ATOM   1363  O   VAL B  63       8.076  21.125  25.516  1.00 25.47           O  
ATOM   1364  CB  VAL B  63       6.862  18.368  24.097  1.00 24.21           C  
ATOM   1365  CG1 VAL B  63       6.216  16.966  24.339  1.00 19.99           C  
ATOM   1366  CG2 VAL B  63       5.764  19.410  23.788  1.00 25.94           C  
ATOM   1367  N   CYS B  64       9.559  19.920  24.321  1.00 21.97           N  
ATOM   1368  CA  CYS B  64      10.314  21.042  23.871  1.00 22.35           C  
ATOM   1369  C   CYS B  64      10.432  20.943  22.336  1.00 23.22           C  
ATOM   1370  O   CYS B  64      10.878  19.910  21.826  1.00 22.53           O  
ATOM   1371  CB  CYS B  64      11.711  21.017  24.506  1.00 23.04           C  
ATOM   1372  SG  CYS B  64      12.741  22.458  23.952  1.00 29.36           S  
ATOM   1373  N   VAL B  65      10.061  22.002  21.603  1.00 20.75           N  
ATOM   1374  CA  VAL B  65      10.231  22.029  20.120  1.00 20.19           C  
ATOM   1375  C   VAL B  65      11.258  23.082  19.673  1.00 20.91           C  
ATOM   1376  O   VAL B  65      11.264  24.198  20.167  1.00 23.06           O  
ATOM   1377  CB  VAL B  65       8.896  22.311  19.397  1.00 21.89           C  
ATOM   1378  CG1 VAL B  65       9.070  22.290  17.848  1.00 21.39           C  
ATOM   1379  CG2 VAL B  65       7.864  21.285  19.826  1.00 17.51           C  
ATOM   1380  N   LEU B  66      12.144  22.664  18.791  1.00 21.00           N  
ATOM   1381  CA  LEU B  66      13.086  23.539  18.141  1.00 22.83           C  
ATOM   1382  C   LEU B  66      12.660  23.546  16.683  1.00 24.37           C  
ATOM   1383  O   LEU B  66      12.472  22.489  16.056  1.00 22.34           O  
ATOM   1384  CB  LEU B  66      14.533  23.059  18.229  1.00 23.54           C  
ATOM   1385  CG  LEU B  66      15.199  23.032  19.617  1.00 22.50           C  
ATOM   1386  CD1 LEU B  66      16.651  22.591  19.463  1.00 21.40           C  
ATOM   1387  CD2 LEU B  66      15.149  24.399  20.135  1.00 24.83           C  
ATOM   1388  N   ILE B  67      12.493  24.756  16.177  1.00 24.16           N  
ATOM   1389  CA  ILE B  67      12.042  24.958  14.818  1.00 23.41           C  
ATOM   1390  C   ILE B  67      12.567  26.233  14.251  1.00 22.23           C  
ATOM   1391  O   ILE B  67      12.617  27.262  14.908  1.00 22.20           O  
ATOM   1392  CB  ILE B  67      10.457  24.845  14.681  1.00 27.64           C  
ATOM   1393  CG1 ILE B  67       9.976  25.021  13.205  1.00 27.72           C  
ATOM   1394  CG2 ILE B  67       9.725  25.869  15.555  1.00 23.71           C  
ATOM   1395  CD1 ILE B  67       8.680  24.302  12.934  1.00 30.36           C  
ATOM   1396  N   GLY B  68      13.051  26.139  13.007  1.00 23.63           N  
ATOM   1397  CA  GLY B  68      13.471  27.316  12.263  1.00 19.56           C  
ATOM   1398  C   GLY B  68      14.953  27.455  11.964  1.00 20.94           C  
ATOM   1399  O   GLY B  68      15.344  28.345  11.241  1.00 24.34           O  
ATOM   1400  N   TYR B  69      15.751  26.508  12.436  1.00 23.18           N  
ATOM   1401  CA  TYR B  69      17.188  26.541  12.246  1.00 25.41           C  
ATOM   1402  C   TYR B  69      17.576  26.028  10.831  1.00 27.83           C  
ATOM   1403  O   TYR B  69      17.596  24.836  10.564  1.00 31.88           O  
ATOM   1404  CB  TYR B  69      17.882  25.791  13.389  1.00 21.24           C  
ATOM   1405  CG  TYR B  69      19.376  25.817  13.323  1.00 24.82           C  
ATOM   1406  CD1 TYR B  69      20.106  26.699  14.091  1.00 33.89           C  
ATOM   1407  CD2 TYR B  69      20.060  25.004  12.408  1.00 37.24           C  
ATOM   1408  CE1 TYR B  69      21.476  26.773  13.991  1.00 33.53           C  
ATOM   1409  CE2 TYR B  69      21.441  25.064  12.295  1.00 40.44           C  
ATOM   1410  CZ  TYR B  69      22.139  25.956  13.102  1.00 37.40           C  
ATOM   1411  OH  TYR B  69      23.499  26.007  13.018  1.00 39.63           O  
ATOM   1412  N   ASP B  70      17.874  26.965   9.938  1.00 27.00           N  
ATOM   1413  CA  ASP B  70      18.227  26.684   8.535  1.00 29.39           C  
ATOM   1414  C   ASP B  70      19.744  26.623   8.327  1.00 32.01           C  
ATOM   1415  O   ASP B  70      20.262  25.781   7.593  1.00 30.28           O  
ATOM   1416  CB  ASP B  70      17.683  27.793   7.635  1.00 31.09           C  
ATOM   1417  CG  ASP B  70      16.190  27.847   7.634  1.00 29.31           C  
ATOM   1418  OD1 ASP B  70      15.608  26.777   7.713  1.00 34.31           O  
ATOM   1419  OD2 ASP B  70      15.611  28.946   7.573  1.00 41.91           O  
ATOM   1420  N   SER B  71      20.420  27.537   9.014  1.00 32.18           N  
ATOM   1421  CA  SER B  71      21.862  27.696   8.993  1.00 34.11           C  
ATOM   1422  C   SER B  71      22.358  28.316  10.305  1.00 33.71           C  
ATOM   1423  O   SER B  71      21.565  28.728  11.164  1.00 28.55           O  
ATOM   1424  CB  SER B  71      22.275  28.611   7.849  1.00 35.35           C  
ATOM   1425  OG  SER B  71      21.644  29.868   8.010  1.00 40.59           O  
ATOM   1426  N   PRO B  72      23.683  28.373  10.471  1.00 33.67           N  
ATOM   1427  CA  PRO B  72      24.181  28.920  11.737  1.00 35.80           C  
ATOM   1428  C   PRO B  72      23.694  30.344  12.073  1.00 33.94           C  
ATOM   1429  O   PRO B  72      23.700  30.699  13.231  1.00 32.67           O  
ATOM   1430  CB  PRO B  72      25.710  28.860  11.575  1.00 35.26           C  
ATOM   1431  CG  PRO B  72      25.937  27.809  10.561  1.00 36.46           C  
ATOM   1432  CD  PRO B  72      24.777  27.897   9.609  1.00 34.30           C  
ATOM   1433  N   GLY B  73      23.261  31.120  11.076  1.00 33.86           N  
ATOM   1434  CA  GLY B  73      22.781  32.492  11.298  1.00 34.31           C  
ATOM   1435  C   GLY B  73      21.265  32.682  11.414  1.00 34.45           C  
ATOM   1436  O   GLY B  73      20.798  33.780  11.636  1.00 32.11           O  
ATOM   1437  N   SER B  74      20.508  31.604  11.233  1.00 32.57           N  
ATOM   1438  CA  SER B  74      19.046  31.622  11.336  1.00 31.98           C  
ATOM   1439  C   SER B  74      18.565  31.978  12.740  1.00 29.05           C  
ATOM   1440  O   SER B  74      19.104  31.462  13.701  1.00 26.36           O  
ATOM   1441  CB  SER B  74      18.488  30.211  11.095  1.00 32.27           C  
ATOM   1442  OG  SER B  74      18.696  29.710   9.801  1.00 33.26           O  
ATOM   1443  N   ALA B  75      17.580  32.880  12.840  1.00 27.09           N  
ATOM   1444  CA  ALA B  75      16.883  33.100  14.113  1.00 24.35           C  
ATOM   1445  C   ALA B  75      15.907  31.915  14.127  1.00 26.03           C  
ATOM   1446  O   ALA B  75      15.324  31.544  13.093  1.00 25.85           O  
ATOM   1447  CB  ALA B  75      16.113  34.380  14.123  1.00 20.83           C  
ATOM   1448  N   PHE B  76      15.747  31.297  15.281  1.00 23.70           N  
ATOM   1449  CA  PHE B  76      14.875  30.143  15.394  1.00 21.58           C  
ATOM   1450  C   PHE B  76      14.155  30.169  16.714  1.00 22.33           C  
ATOM   1451  O   PHE B  76      14.369  31.060  17.528  1.00 22.48           O  
ATOM   1452  CB  PHE B  76      15.623  28.827  15.172  1.00 22.85           C  
ATOM   1453  CG  PHE B  76      16.687  28.564  16.160  1.00 24.24           C  
ATOM   1454  CD1 PHE B  76      17.943  29.131  15.999  1.00 22.01           C  
ATOM   1455  CD2 PHE B  76      16.435  27.767  17.280  1.00 25.18           C  
ATOM   1456  CE1 PHE B  76      18.932  28.913  16.942  1.00 31.42           C  
ATOM   1457  CE2 PHE B  76      17.414  27.561  18.216  1.00 27.57           C  
ATOM   1458  CZ  PHE B  76      18.671  28.122  18.040  1.00 27.59           C  
ATOM   1459  N   LEU B  77      13.283  29.191  16.900  1.00 24.31           N  
ATOM   1460  CA  LEU B  77      12.461  29.129  18.068  1.00 25.21           C  
ATOM   1461  C   LEU B  77      12.734  27.940  18.944  1.00 25.16           C  
ATOM   1462  O   LEU B  77      12.953  26.818  18.470  1.00 25.35           O  
ATOM   1463  CB  LEU B  77      10.963  29.053  17.658  1.00 23.45           C  
ATOM   1464  CG  LEU B  77      10.376  30.200  16.830  1.00 24.02           C  
ATOM   1465  CD1 LEU B  77       8.914  29.806  16.332  1.00 17.16           C  
ATOM   1466  CD2 LEU B  77      10.452  31.474  17.648  1.00 21.47           C  
ATOM   1467  N   GLU B  78      12.706  28.233  20.243  1.00 26.24           N  
ATOM   1468  CA  GLU B  78      12.680  27.204  21.265  1.00 25.21           C  
ATOM   1469  C   GLU B  78      11.314  27.337  21.953  1.00 23.10           C  
ATOM   1470  O   GLU B  78      10.982  28.367  22.536  1.00 24.75           O  
ATOM   1471  CB  GLU B  78      13.836  27.349  22.254  1.00 25.77           C  
ATOM   1472  CG  GLU B  78      13.620  26.436  23.388  1.00 26.30           C  
ATOM   1473  CD  GLU B  78      14.634  26.551  24.522  1.00 37.12           C  
ATOM   1474  OE1 GLU B  78      15.675  27.217  24.405  1.00 29.49           O  
ATOM   1475  OE2 GLU B  78      14.358  25.940  25.562  1.00 44.31           O  
ATOM   1476  N   ILE B  79      10.498  26.302  21.837  1.00 24.16           N  
ATOM   1477  CA  ILE B  79       9.144  26.276  22.368  1.00 22.67           C  
ATOM   1478  C   ILE B  79       8.969  25.171  23.442  1.00 25.34           C  
ATOM   1479  O   ILE B  79       9.144  23.993  23.165  1.00 25.31           O  
ATOM   1480  CB  ILE B  79       8.157  25.960  21.230  1.00 26.46           C  
ATOM   1481  CG1 ILE B  79       8.243  27.015  20.131  1.00 25.76           C  
ATOM   1482  CG2 ILE B  79       6.721  25.829  21.759  1.00 23.69           C  
ATOM   1483  CD1 ILE B  79       7.445  26.737  18.887  1.00 26.35           C  
ATOM   1484  N   ASN B  80       8.612  25.553  24.667  1.00 22.02           N  
ATOM   1485  CA  ASN B  80       8.361  24.574  25.744  1.00 21.97           C  
ATOM   1486  C   ASN B  80       6.893  24.632  25.930  1.00 23.64           C  
ATOM   1487  O   ASN B  80       6.313  25.718  26.058  1.00 22.91           O  
ATOM   1488  CB  ASN B  80       9.114  24.933  27.014  1.00 25.78           C  
ATOM   1489  CG  ASN B  80      10.643  24.895  26.809  1.00 24.67           C  
ATOM   1490  OD1 ASN B  80      11.282  25.934  26.689  1.00 42.52           O  
ATOM   1491  ND2 ASN B  80      11.196  23.714  26.684  1.00 28.75           N  
ATOM   1492  N   GLY B  81       6.276  23.457  25.840  1.00 23.95           N  
ATOM   1493  CA  GLY B  81       4.833  23.373  25.859  1.00 23.64           C  
ATOM   1494  C   GLY B  81       4.272  22.089  26.404  1.00 20.09           C  
ATOM   1495  O   GLY B  81       4.986  21.226  26.850  1.00 21.52           O  
ATOM   1496  N   LEU B  82       2.964  22.040  26.385  1.00 23.69           N  
ATOM   1497  CA  LEU B  82       2.219  20.938  26.868  1.00 24.40           C  
ATOM   1498  C   LEU B  82       1.519  20.275  25.706  1.00 23.40           C  
ATOM   1499  O   LEU B  82       0.720  20.912  24.982  1.00 24.27           O  
ATOM   1500  CB  LEU B  82       1.222  21.433  27.933  1.00 24.89           C  
ATOM   1501  CG  LEU B  82       1.817  21.837  29.280  1.00 23.88           C  
ATOM   1502  CD1 LEU B  82       0.711  22.420  30.234  1.00 27.80           C  
ATOM   1503  CD2 LEU B  82       2.490  20.600  29.916  1.00 23.17           C  
ATOM   1504  N   ALA B  83       1.825  18.984  25.553  1.00 23.61           N  
ATOM   1505  CA  ALA B  83       1.323  18.175  24.460  1.00 24.02           C  
ATOM   1506  C   ALA B  83       0.220  17.260  24.944  1.00 22.11           C  
ATOM   1507  O   ALA B  83       0.241  16.763  26.081  1.00 22.50           O  
ATOM   1508  CB  ALA B  83       2.504  17.388  23.727  1.00 20.76           C  
ATOM   1509  N   SER B  84      -0.747  17.099  24.043  1.00 24.74           N  
ATOM   1510  CA  SER B  84      -1.949  16.284  24.227  1.00 24.69           C  
ATOM   1511  C   SER B  84      -2.436  15.770  22.904  1.00 26.64           C  
ATOM   1512  O   SER B  84      -2.024  16.223  21.835  1.00 23.99           O  
ATOM   1513  CB  SER B  84      -3.042  17.075  24.970  1.00 24.39           C  
ATOM   1514  OG  SER B  84      -3.545  18.120  24.177  1.00 26.80           O  
ATOM   1515  N   LEU B  85      -3.278  14.755  22.965  1.00 25.96           N  
ATOM   1516  CA  LEU B  85      -3.840  14.190  21.756  1.00 26.62           C  
ATOM   1517  C   LEU B  85      -5.116  14.969  21.459  1.00 27.62           C  
ATOM   1518  O   LEU B  85      -5.997  15.120  22.331  1.00 27.66           O  
ATOM   1519  CB  LEU B  85      -4.083  12.681  21.917  1.00 30.04           C  
ATOM   1520  CG  LEU B  85      -2.792  11.865  22.233  1.00 33.75           C  
ATOM   1521  CD1 LEU B  85      -3.043  10.354  22.285  1.00 38.74           C  
ATOM   1522  CD2 LEU B  85      -1.725  12.214  21.195  1.00 40.61           C  
ATOM   1523  N   GLU B  86      -5.177  15.494  20.238  1.00 24.82           N  
ATOM   1524  CA  GLU B  86      -6.312  16.280  19.752  1.00 24.15           C  
ATOM   1525  C   GLU B  86      -7.523  15.404  19.700  1.00 21.95           C  
ATOM   1526  O   GLU B  86      -7.487  14.341  19.111  1.00 25.74           O  
ATOM   1527  CB  GLU B  86      -6.039  16.842  18.349  1.00 25.21           C  
ATOM   1528  CG  GLU B  86      -7.190  17.668  17.791  1.00 27.45           C  
ATOM   1529  CD  GLU B  86      -7.564  18.801  18.695  1.00 28.50           C  
ATOM   1530  OE1 GLU B  86      -6.674  19.609  19.002  1.00 29.45           O  
ATOM   1531  OE2 GLU B  86      -8.747  18.901  19.107  1.00 28.58           O  
ATOM   1532  N   GLU B  87      -8.602  15.887  20.289  1.00 26.80           N  
ATOM   1533  CA  GLU B  87      -9.858  15.117  20.392  1.00 28.88           C  
ATOM   1534  C   GLU B  87     -10.939  15.614  19.475  1.00 28.11           C  
ATOM   1535  O   GLU B  87     -11.944  14.949  19.283  1.00 25.77           O  
ATOM   1536  CB  GLU B  87     -10.360  15.115  21.858  1.00 32.23           C  
ATOM   1537  CG  GLU B  87      -9.446  14.317  22.839  1.00 38.23           C  
ATOM   1538  CD  GLU B  87      -9.901  14.391  24.301  1.00 44.95           C  
ATOM   1539  OE1 GLU B  87     -11.000  14.899  24.596  1.00 45.22           O  
ATOM   1540  OE2 GLU B  87      -9.138  13.944  25.173  1.00 54.19           O  
ATOM   1541  N   ASP B  88     -10.735  16.787  18.897  1.00 27.79           N  
ATOM   1542  CA  ASP B  88     -11.734  17.367  17.973  1.00 27.66           C  
ATOM   1543  C   ASP B  88     -11.532  16.712  16.614  1.00 24.62           C  
ATOM   1544  O   ASP B  88     -10.493  16.842  15.982  1.00 22.62           O  
ATOM   1545  CB  ASP B  88     -11.592  18.900  17.891  1.00 24.91           C  
ATOM   1546  CG  ASP B  88     -12.627  19.569  16.990  1.00 24.99           C  
ATOM   1547  OD1 ASP B  88     -12.820  19.213  15.794  1.00 25.75           O  
ATOM   1548  OD2 ASP B  88     -13.187  20.562  17.449  1.00 26.56           O  
ATOM   1549  N   GLU B  89     -12.551  15.972  16.230  1.00 24.47           N  
ATOM   1550  CA  GLU B  89     -12.534  15.189  15.030  1.00 25.52           C  
ATOM   1551  C   GLU B  89     -12.428  16.033  13.786  1.00 24.61           C  
ATOM   1552  O   GLU B  89     -11.883  15.580  12.792  1.00 25.80           O  
ATOM   1553  CB  GLU B  89     -13.765  14.305  14.959  1.00 26.20           C  
ATOM   1554  CG  GLU B  89     -13.731  13.111  15.889  1.00 32.76           C  
ATOM   1555  CD  GLU B  89     -12.740  12.052  15.457  1.00 45.69           C  
ATOM   1556  OE1 GLU B  89     -12.343  12.025  14.253  1.00 48.75           O  
ATOM   1557  OE2 GLU B  89     -12.397  11.217  16.325  1.00 50.86           O  
ATOM   1558  N   SER B  90     -13.006  17.226  13.808  1.00 22.42           N  
ATOM   1559  CA  SER B  90     -12.893  18.098  12.639  1.00 22.95           C  
ATOM   1560  C   SER B  90     -11.433  18.583  12.489  1.00 24.76           C  
ATOM   1561  O   SER B  90     -10.941  18.754  11.387  1.00 23.81           O  
ATOM   1562  CB  SER B  90     -13.843  19.296  12.727  1.00 23.56           C  
ATOM   1563  OG  SER B  90     -13.428  20.238  13.678  1.00 22.93           O  
ATOM   1564  N   ILE B  91     -10.741  18.788  13.603  1.00 24.44           N  
ATOM   1565  CA  ILE B  91      -9.336  19.247  13.549  1.00 25.61           C  
ATOM   1566  C   ILE B  91      -8.463  18.081  13.082  1.00 26.70           C  
ATOM   1567  O   ILE B  91      -7.570  18.239  12.249  1.00 25.04           O  
ATOM   1568  CB  ILE B  91      -8.822  19.791  14.911  1.00 26.67           C  
ATOM   1569  CG1 ILE B  91      -9.511  21.104  15.272  1.00 27.27           C  
ATOM   1570  CG2 ILE B  91      -7.319  20.012  14.834  1.00 20.52           C  
ATOM   1571  CD1 ILE B  91      -9.145  21.670  16.707  1.00 24.64           C  
ATOM   1572  N   LYS B  92      -8.770  16.887  13.568  1.00 25.93           N  
ATOM   1573  CA  LYS B  92      -8.006  15.719  13.151  1.00 28.64           C  
ATOM   1574  C   LYS B  92      -8.119  15.473  11.651  1.00 27.15           C  
ATOM   1575  O   LYS B  92      -7.133  15.122  11.023  1.00 24.46           O  
ATOM   1576  CB  LYS B  92      -8.470  14.457  13.881  1.00 29.23           C  
ATOM   1577  CG  LYS B  92      -8.140  14.469  15.388  1.00 35.47           C  
ATOM   1578  CD  LYS B  92      -8.794  13.301  16.096  1.00 38.72           C  
ATOM   1579  CE  LYS B  92      -8.333  11.991  15.525  1.00 42.97           C  
ATOM   1580  NZ  LYS B  92      -9.202  10.898  16.018  1.00 46.31           N  
ATOM   1581  N   GLU B  93      -9.333  15.608  11.126  1.00 24.10           N  
ATOM   1582  CA  GLU B  93      -9.642  15.348   9.694  1.00 26.65           C  
ATOM   1583  C   GLU B  93      -9.025  16.401   8.816  1.00 27.21           C  
ATOM   1584  O   GLU B  93      -8.508  16.116   7.731  1.00 25.60           O  
ATOM   1585  CB  GLU B  93     -11.151  15.324   9.445  1.00 25.01           C  
ATOM   1586  CG  GLU B  93     -11.555  15.168   7.947  1.00 34.20           C  
ATOM   1587  CD  GLU B  93     -11.115  13.849   7.355  1.00 35.65           C  
ATOM   1588  OE1 GLU B  93     -10.996  12.900   8.137  1.00 46.70           O  
ATOM   1589  OE2 GLU B  93     -10.879  13.753   6.121  1.00 35.98           O  
ATOM   1590  N   ARG B  94      -9.053  17.631   9.300  1.00 27.12           N  
ATOM   1591  CA  ARG B  94      -8.426  18.709   8.577  1.00 28.00           C  
ATOM   1592  C   ARG B  94      -6.901  18.503   8.443  1.00 27.43           C  
ATOM   1593  O   ARG B  94      -6.356  18.674   7.392  1.00 26.23           O  
ATOM   1594  CB  ARG B  94      -8.736  20.036   9.255  1.00 29.52           C  
ATOM   1595  CG  ARG B  94      -8.115  21.215   8.549  1.00 33.03           C  
ATOM   1596  CD  ARG B  94      -8.486  21.225   7.088  1.00 36.10           C  
ATOM   1597  NE  ARG B  94      -9.924  21.421   6.852  1.00 44.98           N  
ATOM   1598  CZ  ARG B  94     -10.500  22.623   6.783  1.00 45.17           C  
ATOM   1599  NH1 ARG B  94      -9.768  23.727   6.933  1.00 47.64           N  
ATOM   1600  NH2 ARG B  94     -11.796  22.725   6.575  1.00 43.33           N  
ATOM   1601  N   ILE B  95      -6.228  18.211   9.544  1.00 24.35           N  
ATOM   1602  CA  ILE B  95      -4.827  17.935   9.558  1.00 24.04           C  
ATOM   1603  C   ILE B  95      -4.546  16.716   8.638  1.00 24.16           C  
ATOM   1604  O   ILE B  95      -3.588  16.720   7.867  1.00 24.92           O  
ATOM   1605  CB  ILE B  95      -4.329  17.658  10.968  1.00 26.27           C  
ATOM   1606  CG1 ILE B  95      -4.445  18.913  11.909  1.00 28.97           C  
ATOM   1607  CG2 ILE B  95      -2.915  17.072  10.949  1.00 24.84           C  
ATOM   1608  CD1 ILE B  95      -3.722  20.093  11.422  1.00 34.68           C  
ATOM   1609  N   TRP B  96      -5.381  15.674   8.728  1.00 23.39           N  
ATOM   1610  CA  TRP B  96      -5.221  14.479   7.899  1.00 21.32           C  
ATOM   1611  C   TRP B  96      -5.215  14.858   6.418  1.00 24.82           C  
ATOM   1612  O   TRP B  96      -4.361  14.432   5.634  1.00 22.90           O  
ATOM   1613  CB  TRP B  96      -6.302  13.412   8.236  1.00 24.68           C  
ATOM   1614  CG  TRP B  96      -6.370  12.258   7.269  1.00 26.84           C  
ATOM   1615  CD1 TRP B  96      -7.401  11.976   6.399  1.00 30.90           C  
ATOM   1616  CD2 TRP B  96      -5.353  11.254   7.007  1.00 28.62           C  
ATOM   1617  NE1 TRP B  96      -7.100  10.857   5.657  1.00 35.51           N  
ATOM   1618  CE2 TRP B  96      -5.849  10.406   5.996  1.00 25.02           C  
ATOM   1619  CE3 TRP B  96      -4.098  10.980   7.540  1.00 27.30           C  
ATOM   1620  CZ2 TRP B  96      -5.128   9.314   5.523  1.00 33.32           C  
ATOM   1621  CZ3 TRP B  96      -3.380   9.896   7.033  1.00 31.13           C  
ATOM   1622  CH2 TRP B  96      -3.889   9.097   6.049  1.00 30.56           C  
ATOM   1623  N   GLU B  97      -6.169  15.691   6.037  1.00 26.97           N  
ATOM   1624  CA  GLU B  97      -6.332  16.120   4.661  1.00 26.44           C  
ATOM   1625  C   GLU B  97      -5.170  16.987   4.205  1.00 28.96           C  
ATOM   1626  O   GLU B  97      -4.760  16.937   3.048  1.00 29.19           O  
ATOM   1627  CB  GLU B  97      -7.686  16.855   4.493  1.00 29.88           C  
ATOM   1628  CG  GLU B  97      -8.848  15.909   4.539  1.00 26.25           C  
ATOM   1629  CD  GLU B  97     -10.199  16.580   4.571  1.00 33.38           C  
ATOM   1630  OE1 GLU B  97     -10.276  17.802   4.329  1.00 45.27           O  
ATOM   1631  OE2 GLU B  97     -11.170  15.879   4.887  1.00 31.96           O  
ATOM   1632  N   ASN B  98      -4.622  17.780   5.112  0.50 29.09           N  
ATOM   1634  CA  ASN B  98      -3.476  18.613   4.751  0.50 30.24           C  
ATOM   1636  C   ASN B  98      -2.221  17.748   4.570  0.50 28.65           C  
ATOM   1638  O   ASN B  98      -1.495  17.866   3.590  0.50 26.77           O  
ATOM   1640  CB  ASN B  98      -3.239  19.697   5.784  0.50 29.92           C  
ATOM   1642  CG  ASN B  98      -2.058  20.562   5.442  0.50 30.69           C  
ATOM   1644  OD1 ASN B  98      -0.958  20.065   5.158  0.50 29.64           O  
ATOM   1646  ND2 ASN B  98      -2.266  21.864   5.475  0.50 29.51           N  
ATOM   1648  N   ILE B  99      -2.019  16.828   5.495  1.00 30.14           N  
ATOM   1649  CA  ILE B  99      -0.870  15.921   5.421  1.00 30.55           C  
ATOM   1650  C   ILE B  99      -0.879  14.998   4.181  1.00 31.12           C  
ATOM   1651  O   ILE B  99       0.166  14.765   3.576  1.00 33.81           O  
ATOM   1652  CB  ILE B  99      -0.826  15.020   6.688  1.00 33.41           C  
ATOM   1653  CG1 ILE B  99      -0.457  15.847   7.905  1.00 44.69           C  
ATOM   1654  CG2 ILE B  99       0.187  13.922   6.565  1.00 46.54           C  
ATOM   1655  CD1 ILE B  99       0.831  16.568   7.773  1.00 42.35           C  
ATOM   1656  N   SER B 100      -2.050  14.458   3.829  1.00 27.06           N  
ATOM   1657  CA  SER B 100      -2.199  13.440   2.769  1.00 25.77           C  
ATOM   1658  C   SER B 100      -2.678  14.005   1.450  1.00 25.58           C  
ATOM   1659  O   SER B 100      -3.128  13.262   0.551  1.00 23.46           O  
ATOM   1660  CB  SER B 100      -3.221  12.375   3.225  1.00 20.90           C  
ATOM   1661  OG  SER B 100      -4.532  12.928   3.337  1.00 23.13           O  
ATOM   1662  N   LYS B 101      -2.579  15.323   1.313  1.00 27.27           N  
ATOM   1663  CA  LYS B 101      -3.209  15.983   0.170  1.00 28.29           C  
ATOM   1664  C   LYS B 101      -2.701  15.447  -1.176  1.00 24.38           C  
ATOM   1665  O   LYS B 101      -3.471  15.339  -2.104  1.00 27.83           O  
ATOM   1666  CB  LYS B 101      -3.101  17.503   0.232  1.00 30.29           C  
ATOM   1667  CG  LYS B 101      -1.684  18.051   0.062  1.00 41.68           C  
ATOM   1668  CD  LYS B 101      -1.713  19.573  -0.172  1.00 46.81           C  
ATOM   1669  CE  LYS B 101      -2.003  20.376   1.085  1.00 52.12           C  
ATOM   1670  NZ  LYS B 101      -0.870  20.353   2.039  1.00 49.92           N  
ATOM   1671  N   ASP B 102      -1.415  15.126  -1.274  1.00 26.17           N  
ATOM   1672  CA  ASP B 102      -0.855  14.622  -2.533  1.00 24.93           C  
ATOM   1673  C   ASP B 102      -1.512  13.304  -3.007  1.00 24.36           C  
ATOM   1674  O   ASP B 102      -1.489  13.003  -4.210  1.00 29.92           O  
ATOM   1675  CB  ASP B 102       0.657  14.420  -2.449  1.00 26.36           C  
ATOM   1676  CG  ASP B 102       1.444  15.721  -2.553  1.00 32.59           C  
ATOM   1677  OD1 ASP B 102       0.839  16.812  -2.749  1.00 33.69           O  
ATOM   1678  OD2 ASP B 102       2.691  15.615  -2.481  1.00 36.93           O  
ATOM   1679  N   TRP B 103      -2.122  12.549  -2.084  1.00 24.60           N  
ATOM   1680  CA  TRP B 103      -2.750  11.241  -2.406  1.00 25.17           C  
ATOM   1681  C   TRP B 103      -4.136  11.007  -1.810  1.00 30.11           C  
ATOM   1682  O   TRP B 103      -4.825  10.027  -2.144  1.00 32.70           O  
ATOM   1683  CB  TRP B 103      -1.828  10.081  -1.969  1.00 28.09           C  
ATOM   1684  CG  TRP B 103      -1.722   9.872  -0.453  1.00 34.30           C  
ATOM   1685  CD1 TRP B 103      -2.532   9.064   0.355  1.00 31.98           C  
ATOM   1686  CD2 TRP B 103      -0.784  10.475   0.419  1.00 29.27           C  
ATOM   1687  NE1 TRP B 103      -2.130   9.163   1.657  1.00 35.26           N  
ATOM   1688  CE2 TRP B 103      -1.049  10.005   1.716  1.00 30.28           C  
ATOM   1689  CE3 TRP B 103       0.260  11.365   0.230  1.00 18.77           C  
ATOM   1690  CZ2 TRP B 103      -0.339  10.410   2.780  1.00 37.18           C  
ATOM   1691  CZ3 TRP B 103       0.966  11.754   1.294  1.00 34.12           C  
ATOM   1692  CH2 TRP B 103       0.676  11.283   2.554  1.00 37.95           C  
ATOM   1693  N   PHE B 104      -4.591  11.928  -0.978  1.00 34.00           N  
ATOM   1694  CA  PHE B 104      -5.880  11.786  -0.299  1.00 35.95           C  
ATOM   1695  C   PHE B 104      -7.046  11.696  -1.254  1.00 35.24           C  
ATOM   1696  O   PHE B 104      -7.211  12.556  -2.118  1.00 34.16           O  
ATOM   1697  CB  PHE B 104      -6.095  12.935   0.715  1.00 39.24           C  
ATOM   1698  CG  PHE B 104      -7.483  12.971   1.331  1.00 38.94           C  
ATOM   1699  CD1 PHE B 104      -7.774  12.232   2.461  1.00 36.50           C  
ATOM   1700  CD2 PHE B 104      -8.477  13.773   0.794  1.00 40.95           C  
ATOM   1701  CE1 PHE B 104      -9.048  12.266   3.031  1.00 40.74           C  
ATOM   1702  CE2 PHE B 104      -9.752  13.813   1.359  1.00 41.12           C  
ATOM   1703  CZ  PHE B 104     -10.027  13.057   2.481  1.00 42.71           C  
ATOM   1704  N   GLN B 105      -7.833  10.633  -1.121  1.00 34.79           N  
ATOM   1705  CA  GLN B 105      -9.049  10.493  -1.917  1.00 36.45           C  
ATOM   1706  C   GLN B 105     -10.250  10.044  -1.074  1.00 40.48           C  
ATOM   1707  O   GLN B 105     -11.160   9.348  -1.545  1.00 36.61           O  
ATOM   1708  CB  GLN B 105      -8.852   9.632  -3.198  1.00 36.06           C  
ATOM   1709  CG  GLN B 105      -8.374   8.203  -2.986  1.00 38.74           C  
ATOM   1710  CD  GLN B 105      -8.363   7.383  -4.270  1.00 27.15           C  
ATOM   1711  OE1 GLN B 105      -7.563   7.633  -5.191  1.00 23.55           O  
ATOM   1712  NE2 GLN B 105      -9.235   6.362  -4.326  1.00 33.92           N  
ATOM   1713  N   GLY B 106     -10.261  10.484   0.183  1.00 43.39           N  
ATOM   1714  CA  GLY B 106     -11.383  10.190   1.078  1.00 44.55           C  
ATOM   1715  C   GLY B 106     -11.216   9.052   2.070  1.00 46.11           C  
ATOM   1716  O   GLY B 106     -12.078   8.833   2.907  1.00 48.44           O  
ATOM   1717  N   GLU B 107     -10.136   8.311   1.994  1.00 46.72           N  
ATOM   1718  CA  GLU B 107      -9.885   7.288   2.961  1.00 48.03           C  
ATOM   1719  C   GLU B 107      -9.553   7.892   4.316  1.00 49.31           C  
ATOM   1720  O   GLU B 107      -9.085   8.984   4.420  1.00 50.37           O  
ATOM   1721  CB  GLU B 107      -8.774   6.378   2.480  1.00 47.53           C  
ATOM   1722  N   ASP B 108      -9.827   7.182   5.368  1.00 49.32           N  
ATOM   1723  CA  ASP B 108      -9.296   7.607   6.631  1.00 50.51           C  
ATOM   1724  C   ASP B 108      -8.554   6.495   7.274  1.00 47.60           C  
ATOM   1725  O   ASP B 108      -8.639   5.388   6.869  1.00 48.55           O  
ATOM   1726  CB  ASP B 108     -10.375   8.127   7.568  1.00 51.81           C  
ATOM   1727  CG  ASP B 108     -10.037   9.471   8.156  1.00 59.75           C  
ATOM   1728  OD1 ASP B 108      -9.294   9.546   9.170  1.00 69.25           O  
ATOM   1729  OD2 ASP B 108     -10.514  10.459   7.594  1.00 60.83           O  
ATOM   1730  N   SER B 109      -7.828   6.825   8.301  1.00 42.70           N  
ATOM   1731  CA  SER B 109      -6.843   5.956   8.803  1.00 39.53           C  
ATOM   1732  C   SER B 109      -7.160   5.865  10.264  1.00 37.93           C  
ATOM   1733  O   SER B 109      -7.124   6.848  10.935  1.00 36.08           O  
ATOM   1734  CB  SER B 109      -5.497   6.591   8.567  1.00 35.74           C  
ATOM   1735  OG  SER B 109      -4.534   5.926   9.292  1.00 50.86           O  
ATOM   1736  N   PRO B 110      -7.522   4.695  10.745  1.00 36.20           N  
ATOM   1737  CA  PRO B 110      -7.994   4.582  12.129  1.00 34.17           C  
ATOM   1738  C   PRO B 110      -6.885   4.781  13.167  1.00 28.51           C  
ATOM   1739  O   PRO B 110      -7.137   5.150  14.300  1.00 30.62           O  
ATOM   1740  CB  PRO B 110      -8.539   3.154  12.183  1.00 34.50           C  
ATOM   1741  CG  PRO B 110      -7.683   2.391  11.241  1.00 38.99           C  
ATOM   1742  CD  PRO B 110      -7.335   3.376  10.111  1.00 39.07           C  
ATOM   1743  N   SER B 111      -5.656   4.591  12.752  1.00 26.60           N  
ATOM   1744  CA  SER B 111      -4.568   4.673  13.688  1.00 27.88           C  
ATOM   1745  C   SER B 111      -4.009   6.097  13.727  1.00 25.75           C  
ATOM   1746  O   SER B 111      -3.184   6.388  14.530  1.00 24.21           O  
ATOM   1747  CB  SER B 111      -3.479   3.679  13.329  1.00 31.27           C  
ATOM   1748  OG  SER B 111      -2.764   4.122  12.198  1.00 36.14           O  
ATOM   1749  N   PHE B 112      -4.538   6.981  12.886  1.00 28.87           N  
ATOM   1750  CA  PHE B 112      -4.082   8.368  12.797  1.00 29.00           C  
ATOM   1751  C   PHE B 112      -4.493   9.195  14.034  1.00 27.15           C  
ATOM   1752  O   PHE B 112      -5.615   9.157  14.525  1.00 25.88           O  
ATOM   1753  CB  PHE B 112      -4.559   9.043  11.520  1.00 30.08           C  
ATOM   1754  CG  PHE B 112      -3.980  10.433  11.310  1.00 28.08           C  
ATOM   1755  CD1 PHE B 112      -2.689  10.587  10.909  1.00 27.96           C  
ATOM   1756  CD2 PHE B 112      -4.750  11.556  11.482  1.00 28.83           C  
ATOM   1757  CE1 PHE B 112      -2.155  11.853  10.695  1.00 32.87           C  
ATOM   1758  CE2 PHE B 112      -4.258  12.801  11.254  1.00 26.31           C  
ATOM   1759  CZ  PHE B 112      -2.955  12.966  10.851  1.00 28.17           C  
ATOM   1760  N   VAL B 113      -3.531   9.942  14.538  0.50 24.30           N  
ATOM   1762  CA  VAL B 113      -3.773  10.797  15.679  0.50 23.77           C  
ATOM   1764  C   VAL B 113      -2.992  12.063  15.459  0.50 24.04           C  
ATOM   1766  O   VAL B 113      -2.106  12.133  14.597  0.50 21.68           O  
ATOM   1768  CB  VAL B 113      -3.362  10.142  17.004  0.50 22.73           C  
ATOM   1770  CG1 VAL B 113      -4.150   8.865  17.217  0.50 24.82           C  
ATOM   1772  CG2 VAL B 113      -1.848   9.904  17.041  0.50 22.09           C  
ATOM   1774  N   VAL B 114      -3.371  13.074  16.225  1.00 23.44           N  
ATOM   1775  CA  VAL B 114      -2.741  14.365  16.144  1.00 22.58           C  
ATOM   1776  C   VAL B 114      -2.304  14.796  17.547  1.00 22.66           C  
ATOM   1777  O   VAL B 114      -3.089  14.710  18.503  1.00 20.35           O  
ATOM   1778  CB  VAL B 114      -3.675  15.417  15.489  1.00 23.21           C  
ATOM   1779  CG1 VAL B 114      -3.080  16.898  15.593  1.00 21.96           C  
ATOM   1780  CG2 VAL B 114      -4.027  15.016  14.006  1.00 21.87           C  
ATOM   1781  N   ILE B 115      -1.025  15.145  17.639  1.00 23.01           N  
ATOM   1782  CA  ILE B 115      -0.433  15.736  18.818  1.00 26.40           C  
ATOM   1783  C   ILE B 115      -0.540  17.242  18.725  1.00 25.68           C  
ATOM   1784  O   ILE B 115      -0.002  17.907  17.816  1.00 21.88           O  
ATOM   1785  CB  ILE B 115       1.017  15.298  19.053  1.00 27.41           C  
ATOM   1786  CG1 ILE B 115       1.047  13.769  19.156  1.00 25.65           C  
ATOM   1787  CG2 ILE B 115       1.565  15.983  20.350  1.00 21.73           C  
ATOM   1788  CD1 ILE B 115       2.430  13.094  19.052  1.00 23.90           C  
ATOM   1789  N   LYS B 116      -1.277  17.776  19.694  1.00 24.59           N  
ATOM   1790  CA  LYS B 116      -1.498  19.213  19.819  1.00 24.48           C  
ATOM   1791  C   LYS B 116      -0.499  19.715  20.803  1.00 24.99           C  
ATOM   1792  O   LYS B 116      -0.304  19.107  21.857  1.00 22.82           O  
ATOM   1793  CB  LYS B 116      -2.904  19.504  20.347  1.00 24.07           C  
ATOM   1794  CG  LYS B 116      -3.205  21.002  20.582  1.00 29.98           C  
ATOM   1795  CD  LYS B 116      -4.516  21.212  21.400  1.00 26.90           C  
ATOM   1796  CE  LYS B 116      -4.920  22.636  21.330  1.00 39.03           C  
ATOM   1797  NZ  LYS B 116      -6.180  22.944  22.086  1.00 36.98           N  
ATOM   1798  N   ILE B 117       0.172  20.803  20.463  1.00 23.12           N  
ATOM   1799  CA  ILE B 117       1.126  21.390  21.403  1.00 24.67           C  
ATOM   1800  C   ILE B 117       0.761  22.823  21.703  1.00 22.63           C  
ATOM   1801  O   ILE B 117       0.801  23.702  20.817  1.00 23.51           O  
ATOM   1802  CB  ILE B 117       2.588  21.295  20.907  1.00 24.32           C  
ATOM   1803  CG1 ILE B 117       2.970  19.823  20.689  1.00 23.43           C  
ATOM   1804  CG2 ILE B 117       3.540  22.020  21.870  1.00 22.46           C  
ATOM   1805  CD1 ILE B 117       4.076  19.618  19.733  1.00 29.93           C  
ATOM   1806  N   VAL B 118       0.461  23.055  22.982  1.00 22.92           N  
ATOM   1807  CA  VAL B 118       0.134  24.380  23.508  1.00 24.35           C  
ATOM   1808  C   VAL B 118       1.389  25.007  24.116  1.00 22.53           C  
ATOM   1809  O   VAL B 118       1.928  24.544  25.107  1.00 25.36           O  
ATOM   1810  CB  VAL B 118      -1.084  24.343  24.527  1.00 25.46           C  
ATOM   1811  CG1 VAL B 118      -1.343  25.728  25.176  1.00 22.00           C  
ATOM   1812  CG2 VAL B 118      -2.323  23.869  23.820  1.00 23.69           C  
ATOM   1813  N   PRO B 119       1.893  26.079  23.519  1.00 26.30           N  
ATOM   1814  CA  PRO B 119       3.129  26.660  24.051  1.00 23.16           C  
ATOM   1815  C   PRO B 119       2.986  27.349  25.381  1.00 23.39           C  
ATOM   1816  O   PRO B 119       2.004  28.029  25.600  1.00 21.45           O  
ATOM   1817  CB  PRO B 119       3.461  27.736  23.013  1.00 26.11           C  
ATOM   1818  CG  PRO B 119       2.714  27.317  21.777  1.00 35.28           C  
ATOM   1819  CD  PRO B 119       1.447  26.793  22.313  1.00 27.67           C  
ATOM   1820  N   GLU B 120       3.982  27.202  26.249  1.00 22.68           N  
ATOM   1821  CA  GLU B 120       3.942  27.849  27.565  1.00 21.99           C  
ATOM   1822  C   GLU B 120       4.992  28.949  27.574  1.00 22.64           C  
ATOM   1823  O   GLU B 120       4.841  30.011  28.197  1.00 24.80           O  
ATOM   1824  CB  GLU B 120       4.165  26.827  28.700  1.00 22.70           C  
ATOM   1825  CG  GLU B 120       3.045  25.805  28.795  1.00 20.40           C  
ATOM   1826  CD  GLU B 120       1.694  26.453  29.179  1.00 34.03           C  
ATOM   1827  OE1 GLU B 120       1.695  27.544  29.796  1.00 30.66           O  
ATOM   1828  OE2 GLU B 120       0.652  25.841  28.900  1.00 30.18           O  
ATOM   1829  N   GLN B 121       6.044  28.695  26.827  1.00 24.66           N  
ATOM   1830  CA  GLN B 121       7.159  29.628  26.666  1.00 23.73           C  
ATOM   1831  C   GLN B 121       7.721  29.509  25.276  1.00 24.77           C  
ATOM   1832  O   GLN B 121       7.940  28.400  24.794  1.00 23.86           O  
ATOM   1833  CB  GLN B 121       8.216  29.259  27.681  1.00 25.65           C  
ATOM   1834  CG  GLN B 121       7.677  29.481  29.090  1.00 40.52           C  
ATOM   1835  CD  GLN B 121       7.889  28.321  30.084  1.00 54.09           C  
ATOM   1836  OE1 GLN B 121       8.370  27.221  29.725  1.00 52.65           O  
ATOM   1837  NE2 GLN B 121       7.459  28.552  31.339  1.00 48.47           N  
ATOM   1838  N   ILE B 122       7.970  30.651  24.636  1.00 21.91           N  
ATOM   1839  CA  ILE B 122       8.616  30.684  23.326  1.00 24.16           C  
ATOM   1840  C   ILE B 122       9.721  31.664  23.328  1.00 25.57           C  
ATOM   1841  O   ILE B 122       9.482  32.823  23.630  1.00 24.21           O  
ATOM   1842  CB  ILE B 122       7.678  31.080  22.177  1.00 20.31           C  
ATOM   1843  CG1 ILE B 122       6.374  30.260  22.208  1.00 23.42           C  
ATOM   1844  CG2 ILE B 122       8.413  30.892  20.892  1.00 22.36           C  
ATOM   1845  CD1 ILE B 122       5.436  30.550  21.095  1.00 30.33           C  
ATOM   1846  N   ARG B 123      10.938  31.177  23.032  1.00 23.37           N  
ATOM   1847  CA  ARG B 123      12.107  32.009  22.961  1.00 26.13           C  
ATOM   1848  C   ARG B 123      12.613  32.033  21.537  1.00 26.76           C  
ATOM   1849  O   ARG B 123      12.651  30.978  20.860  1.00 24.02           O  
ATOM   1850  CB  ARG B 123      13.219  31.455  23.814  1.00 28.72           C  
ATOM   1851  CG  ARG B 123      12.992  31.553  25.277  1.00 40.48           C  
ATOM   1852  CD  ARG B 123      14.347  31.593  25.949  1.00 48.20           C  
ATOM   1853  NE  ARG B 123      14.978  30.293  25.910  1.00 50.46           N  
ATOM   1854  CZ  ARG B 123      16.278  30.093  26.093  1.00 49.84           C  
ATOM   1855  NH1 ARG B 123      17.093  31.134  26.298  1.00 45.51           N  
ATOM   1856  NH2 ARG B 123      16.759  28.850  26.045  1.00 39.62           N  
ATOM   1857  N   ILE B 124      12.922  33.234  21.056  1.00 22.50           N  
ATOM   1858  CA  ILE B 124      13.562  33.373  19.752  1.00 24.45           C  
ATOM   1859  C   ILE B 124      15.017  33.439  20.071  1.00 24.58           C  
ATOM   1860  O   ILE B 124      15.487  34.336  20.789  1.00 20.24           O  
ATOM   1861  CB  ILE B 124      13.197  34.629  18.934  1.00 24.08           C  
ATOM   1862  CG1 ILE B 124      11.721  34.724  18.608  1.00 30.86           C  
ATOM   1863  CG2 ILE B 124      13.859  34.593  17.537  1.00 30.84           C  
ATOM   1864  CD1 ILE B 124      11.407  36.053  17.828  1.00 33.77           C  
ATOM   1865  N   LEU B 125      15.728  32.489  19.503  1.00 24.22           N  
ATOM   1866  CA  LEU B 125      17.143  32.377  19.670  1.00 26.90           C  
ATOM   1867  C   LEU B 125      17.871  32.765  18.399  1.00 28.39           C  
ATOM   1868  O   LEU B 125      17.308  32.679  17.293  1.00 24.33           O  
ATOM   1869  CB  LEU B 125      17.464  30.932  20.075  1.00 27.04           C  
ATOM   1870  CG  LEU B 125      16.851  30.430  21.381  1.00 29.37           C  
ATOM   1871  CD1 LEU B 125      17.226  28.956  21.615  1.00 36.63           C  
ATOM   1872  CD2 LEU B 125      17.260  31.300  22.571  1.00 32.33           C  
ATOM   1873  N   ASN B 126      19.121  33.214  18.586  1.00 29.72           N  
ATOM   1874  CA  ASN B 126      20.017  33.617  17.503  1.00 30.16           C  
ATOM   1875  C   ASN B 126      19.399  34.745  16.670  1.00 30.72           C  
ATOM   1876  O   ASN B 126      19.544  34.805  15.437  1.00 28.12           O  
ATOM   1877  CB  ASN B 126      20.404  32.405  16.628  1.00 31.62           C  
ATOM   1878  CG  ASN B 126      21.682  32.632  15.819  1.00 29.72           C  
ATOM   1879  OD1 ASN B 126      22.604  33.301  16.274  1.00 30.95           O  
ATOM   1880  ND2 ASN B 126      21.751  32.049  14.631  1.00 31.08           N  
ATOM   1881  N   SER B 127      18.676  35.635  17.343  1.00 27.81           N  
ATOM   1882  CA  SER B 127      18.056  36.749  16.624  1.00 30.83           C  
ATOM   1883  C   SER B 127      19.053  37.846  16.335  1.00 27.77           C  
ATOM   1884  O   SER B 127      18.798  38.638  15.452  1.00 29.89           O  
ATOM   1885  CB  SER B 127      16.828  37.325  17.357  1.00 30.64           C  
ATOM   1886  OG  SER B 127      17.194  37.788  18.628  1.00 34.66           O  
ATOM   1887  OXT SER B 127      20.119  37.956  16.943  1.00 27.95           O  
TER    1888      SER B 127                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
