
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  193 ( 1493),  selected  193 , name 2fur_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2fur_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R    16_A      M       1           #
LGA    A    17_A      A       2          5.425
LGA    S    18_A      D       3          5.820
LGA    Y    19_A      P       4          3.362
LGA    S    20_A      K       5          2.885
LGA    -       -      E       6           -
LGA    -       -      L       7           -
LGA    D    21_A      Q       8          2.956
LGA    E    22_A      D       9          1.907
LGA    D    23_A      K      10          2.364
LGA    L    24_A      F      11          2.256
LGA    V    25_A      W      12          1.605
LGA    A    26_A      K      13          1.054
LGA    X    27_A      A      14          1.667
LGA    L    28_A      L      15          1.573
LGA    D    29_A      K      16          1.441
LGA    R    30_A      S      17          1.419
LGA    N    31_A      D      18          1.197
LGA    F    32_A      R      19          2.385
LGA    T    33_A      T      20          1.366
LGA    C    34_A      V      21          1.400
LGA    T    35_A      M      22          0.740
LGA    V    36_A      L      23          0.671
LGA    S    37_A      G      24          1.906
LGA    F    38_A      L      25          1.579
LGA    I    39_A      D      26          3.920
LGA    D    40_A      G      27           #
LGA    G    41_A      V      28          4.621
LGA    G    42_A      E      29          3.083
LGA    I    43_A      D      30          3.629
LGA    P    44_A      G      31          3.565
LGA    Y    45_A      H      32          3.906
LGA    A    46_A      A      33          1.890
LGA    I    47_A      R      34          0.989
LGA    P    48_A      P      35          0.847
LGA    X    49_A      M      36          0.890
LGA    X    50_A      T      37          1.434
LGA    L    51_A      A      38          1.545
LGA    A    52_A      Q      39          1.439
LGA    S    53_A      I      40          1.858
LGA    E    54_A      E      41          2.627
LGA    -       -      G      42           -
LGA    -       -      D      43           -
LGA    G    55_A      S      44          2.365
LGA    K    56_A      G      45          2.151
LGA    T    57_A      G      46          1.668
LGA    -       -      P      47           -
LGA    I    58_A      I      48          0.755
LGA    Y    59_A      W      49          0.249
LGA    L    60_A      F      50          1.379
LGA    H    61_A      F      51          1.987
LGA    G    62_A      T      52          0.923
LGA    S    63_A      S      53          0.964
LGA    X    64_A      K      54          0.900
LGA    K    65_A      D      55          1.315
LGA    S    66_A      N      56          1.880
LGA    R    67_A      A      57          0.802
LGA    I    68_A      L      58          1.729
LGA    Y    69_A      I      59          1.229
LGA    G    70_A      A      60          1.505
LGA    I    71_A      M      61          2.906
LGA    L    72_A      L      62          3.343
LGA    K    73_A      G      63          3.336
LGA    T    74_A      Q      64          5.188
LGA    G    75_A      G      65          1.082
LGA    Q    76_A      R      66          1.109
LGA    L    77_A      R      67          0.782
LGA    I    78_A      V      68          0.582
LGA    A    79_A      I      69          0.858
LGA    I    80_A      G      70          1.152
LGA    S    81_A      A      71          1.725
LGA    L    82_A      F      72          1.091
LGA    L    83_A      S      73          1.144
LGA    E    84_A      S      74          2.801
LGA    -       -      K      75           -
LGA    I    85_A      G      76          3.572
LGA    N    86_A      H      77          4.655
LGA    G    87_A      -       -           -
LGA    I    88_A      -       -           -
LGA    V    89_A      -       -           -
LGA    L    90_A      -       -           -
LGA    A    91_A      -       -           -
LGA    K    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    I    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    N    96_A      -       -           -
LGA    N    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    I    99_A      -       -           -
LGA    N   100_A      -       -           -
LGA    Y   101_A      D      78          2.735
LGA    V   102_A      L      79          1.166
LGA    S   103_A      F      80          0.562
LGA    A   104_A      A      81          0.890
LGA    L   105_A      S      82          1.115
LGA    I   106_A      I      83          0.953
LGA    F   107_A      S      84          0.751
LGA    G   108_A      G      85          0.863
LGA    R   109_A      S      86          0.562
LGA    P   110_A      L      87          2.012
LGA    Y   111_A      R      88          3.329
LGA    E   112_A      E      89          2.598
LGA    I   113_A      D      90          1.888
LGA    D   114_A      T      91          3.736
LGA    D   115_A      D      92          2.694
LGA    T   116_A      P      93          1.324
LGA    E   117_A      A      94          2.121
LGA    K   118_A      V      95          1.524
LGA    K   119_A      V      96          1.296
LGA    I   120_A      D      97          1.843
LGA    E   121_A      R      98          1.333
LGA    V   122_A      L      99          1.959
LGA    F   123_A      W     100          2.283
LGA    R   124_A      N     101          3.231
LGA    L   125_A      P     102           -
LGA    L   126_A      Y     103           #
LGA    T   127_A      -       -           -
LGA    E   128_A      -       -           -
LGA    K   129_A      -       -           -
LGA    L   130_A      V     104           #
LGA    V   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    G   133_A      -       -           -
LGA    R   134_A      -       -           -
LGA    W   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    N   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    I   139_A      -       -           -
LGA    K   140_A      A     105           #
LGA    -       -      A     106           -
LGA    -       -      W     107           -
LGA    -       -      Y     108           -
LGA    -       -      E     109           -
LGA    -       -      G     110           -
LGA    P   141_A      G     111          2.276
LGA    S   142_A      K     112          4.013
LGA    Y   143_A      D     113          2.516
LGA    E   144_A      -       -           -
LGA    D   145_A      D     114          1.361
LGA    L   146_A      -       -           -
LGA    N   147_A      P     115          3.709
LGA    G   148_A      K     116          2.447
LGA    V   149_A      L     117          0.928
LGA    F   150_A      A     118          0.937
LGA    V   151_A      L     119          0.736
LGA    F   152_A      L     120          1.861
LGA    A   153_A      R     121          1.763
LGA    V   154_A      L     122          1.363
LGA    K   155_A      D     123          2.351
LGA    P   156_A      A     124          1.483
LGA    E   157_A      D     125          0.677
LGA    T   158_A      H     126          1.006
LGA    F   159_A      A     127          0.967
LGA    S   160_A      Q     128          1.885
LGA    X   161_A      I     129          0.978
LGA    K   162_A      W     130          0.916
LGA    A   163_A      L     131          1.040
LGA    R   164_A      N     132          2.074
LGA    T   165_A      G     133          3.207
LGA    G   166_A      S     134          4.772
LGA    P   167_A      -       -           -
LGA    P   168_A      S     135          3.925
LGA    H   169_A      L     136          1.038
LGA    D   170_A      L     137          1.987
LGA    T   171_A      A     138          2.465
LGA    S   172_A      G     139          3.329
LGA    T   173_A      I     140          3.050
LGA    D   174_A      K     141          3.624
LGA    D   175_A      V     142          3.215
LGA    I   176_A      L     143           -
LGA    W   177_A      L     144           -
LGA    S   178_A      G     145           -
LGA    G   179_A      -       -           -
LGA    V   180_A      -       -           -
LGA    L   181_A      -       -           -
LGA    P   182_A      -       -           -
LGA    I   183_A      -       -           -
LGA    Q   184_A      -       -           -
LGA    H   185_A      -       -           -
LGA    T   186_A      -       -           -
LGA    I   187_A      -       -           -
LGA    S   188_A      -       -           -
LGA    E   189_A      -       -           -
LGA    A   190_A      -       -           -
LGA    G   191_A      -       -           -
LGA    E   192_A      -       -           -
LGA    N   193_A      -       -           -
LGA    A   194_A      -       -           -
LGA    P   195_A      -       -           -
LGA    E   196_A      -       -           -
LGA    Y   197_A      -       -           -
LGA    V   198_A      -       -           -
LGA    K   199_A      -       -           -
LGA    S   200_A      -       -           -
LGA    L   201_A      -       -           -
LGA    Y   202_A      -       -           -
LGA    G   203_A      -       -           -
LGA    K   204_A      -       -           -
LGA    R   205_A      -       -           -
LGA    I   206_A      -       -           -
LGA    F   207_A      -       -           -
LGA    I   208_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  193  145    5.0    125    2.32    12.80     59.580     5.167

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.240766 * X  +   0.765885 * Y  +   0.596197 * Z  + -14.880939
  Y_new =  -0.009756 * X  +   0.612326 * Y  +  -0.790545 * Z  +   6.629434
  Z_new =  -0.970534 * X  +  -0.196153 * Y  +  -0.139956 * Z  +  35.337841 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.190527    0.951065  [ DEG:  -125.5080     54.4920 ]
  Theta =   1.327438    1.814155  [ DEG:    76.0566    103.9434 ]
  Phi   =  -3.101095    0.040498  [ DEG:  -177.6797      2.3203 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fur_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fur_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  193  145   5.0  125   2.32   12.80  59.580
REMARK  ---------------------------------------------------------- 
MOLECULE 2fur_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-JAN-06   2FUR              
TITLE     CRYSTAL STRUCTURE OF AN FMN-BINDING SPLIT BARREL FOLD                 
TITLE    2 PROTEIN WITH UNKNOWN FUNCTION (10649715) FROM THERMOPLASMA           
TITLE    3 ACIDOPHILUM AT 1.80 A RESOLUTION.                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOPLASMA ACIDOPHILUM;                       
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: 10640715;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    10640715, STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE                 
KEYWDS   2 INITIATIVE, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   28-FEB-06 2FUR    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN 10640715           
JRNL        TITL 2 FROM THERMOPLASMA ACIDOPHILUM AT 1.80 A RESOLUTION           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2FUR A    1   208  GB     10640715 CAC12493         1    208             
DBREF  2FUR B    1   208  GB     10640715 CAC12493         1    208             
SEQRES   1 A  209  GLY MSE ALA VAL GLU CYS ILE LYS ASP LYS VAL THR ARG          
SEQRES   2 A  209  TYR PRO GLU ARG ALA SER TYR SER ASP GLU ASP LEU VAL          
SEQRES   3 A  209  ALA MSE LEU ASP ARG ASN PHE THR CYS THR VAL SER PHE          
SEQRES   4 A  209  ILE ASP GLY GLY ILE PRO TYR ALA ILE PRO MSE MSE LEU          
SEQRES   5 A  209  ALA SER GLU GLY LYS THR ILE TYR LEU HIS GLY SER MSE          
SEQRES   6 A  209  LYS SER ARG ILE TYR GLY ILE LEU LYS THR GLY GLN LEU          
SEQRES   7 A  209  ILE ALA ILE SER LEU LEU GLU ILE ASN GLY ILE VAL LEU          
SEQRES   8 A  209  ALA LYS GLU ILE LYS ASN ASN SER ILE ASN TYR VAL SER          
SEQRES   9 A  209  ALA LEU ILE PHE GLY ARG PRO TYR GLU ILE ASP ASP THR          
SEQRES  10 A  209  GLU LYS LYS ILE GLU VAL PHE ARG LEU LEU THR GLU LYS          
SEQRES  11 A  209  LEU VAL LYS GLY ARG TRP ASP ASN SER ILE LYS PRO SER          
SEQRES  12 A  209  TYR GLU ASP LEU ASN GLY VAL PHE VAL PHE ALA VAL LYS          
SEQRES  13 A  209  PRO GLU THR PHE SER MSE LYS ALA ARG THR GLY PRO PRO          
SEQRES  14 A  209  HIS ASP THR SER THR ASP ASP ILE TRP SER GLY VAL LEU          
SEQRES  15 A  209  PRO ILE GLN HIS THR ILE SER GLU ALA GLY GLU ASN ALA          
SEQRES  16 A  209  PRO GLU TYR VAL LYS SER LEU TYR GLY LYS ARG ILE PHE          
SEQRES  17 A  209  ILE                                                          
SEQRES   1 B  209  GLY MSE ALA VAL GLU CYS ILE LYS ASP LYS VAL THR ARG          
SEQRES   2 B  209  TYR PRO GLU ARG ALA SER TYR SER ASP GLU ASP LEU VAL          
SEQRES   3 B  209  ALA MSE LEU ASP ARG ASN PHE THR CYS THR VAL SER PHE          
SEQRES   4 B  209  ILE ASP GLY GLY ILE PRO TYR ALA ILE PRO MSE MSE LEU          
SEQRES   5 B  209  ALA SER GLU GLY LYS THR ILE TYR LEU HIS GLY SER MSE          
SEQRES   6 B  209  LYS SER ARG ILE TYR GLY ILE LEU LYS THR GLY GLN LEU          
SEQRES   7 B  209  ILE ALA ILE SER LEU LEU GLU ILE ASN GLY ILE VAL LEU          
SEQRES   8 B  209  ALA LYS GLU ILE LYS ASN ASN SER ILE ASN TYR VAL SER          
SEQRES   9 B  209  ALA LEU ILE PHE GLY ARG PRO TYR GLU ILE ASP ASP THR          
SEQRES  10 B  209  GLU LYS LYS ILE GLU VAL PHE ARG LEU LEU THR GLU LYS          
SEQRES  11 B  209  LEU VAL LYS GLY ARG TRP ASP ASN SER ILE LYS PRO SER          
SEQRES  12 B  209  TYR GLU ASP LEU ASN GLY VAL PHE VAL PHE ALA VAL LYS          
SEQRES  13 B  209  PRO GLU THR PHE SER MSE LYS ALA ARG THR GLY PRO PRO          
SEQRES  14 B  209  HIS ASP THR SER THR ASP ASP ILE TRP SER GLY VAL LEU          
SEQRES  15 B  209  PRO ILE GLN HIS THR ILE SER GLU ALA GLY GLU ASN ALA          
SEQRES  16 B  209  PRO GLU TYR VAL LYS SER LEU TYR GLY LYS ARG ILE PHE          
SEQRES  17 B  209  ILE                                                          
HET    MSE  A  27       8                                                       
HET    MSE  A  49      12                                                       
HET    MSE  A  50      12                                                       
HET    MSE  A  64       8                                                       
HET    MSE  A 161       8                                                       
HET    MSE  B  27       8                                                       
HET    MSE  B  49      12                                                       
HET    MSE  B  50      12                                                       
HET    MSE  B  64       8                                                       
HET    MSE  B 161       8                                                       
HET    EDO      1       4                                                       
HET    EDO      2       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3  EDO    5(C2 H6 O2)                                                  
FORMUL   8  HOH   *272(H2 O)                                                    
CRYST1   61.040   66.690   99.940  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   ARG A  16      19.934  39.370  17.961  1.00 44.88           N  
ATOM      2  CA  ARG A  16      19.849  38.838  19.365  1.00 43.77           C  
ATOM      3  C   ARG A  16      18.503  38.096  19.535  1.00 42.25           C  
ATOM      4  O   ARG A  16      18.092  37.387  18.621  1.00 38.02           O  
ATOM      5  CB  ARG A  16      20.060  39.972  20.407  1.00 43.92           C  
ATOM      6  CG  ARG A  16      20.497  39.485  21.811  1.00 45.83           C  
ATOM      7  CD  ARG A  16      19.939  40.357  22.940  1.00 42.57           C  
ATOM      8  N   ALA A  17      17.820  38.288  20.675  1.00 42.63           N  
ATOM      9  CA  ALA A  17      16.653  37.481  21.063  1.00 42.06           C  
ATOM     10  C   ALA A  17      15.311  38.147  20.728  1.00 41.11           C  
ATOM     11  O   ALA A  17      15.224  39.378  20.583  1.00 44.33           O  
ATOM     12  CB  ALA A  17      16.722  37.181  22.554  1.00 41.27           C  
ATOM     13  N   SER A  18      14.266  37.332  20.610  1.00 37.11           N  
ATOM     14  CA  SER A  18      12.892  37.828  20.498  1.00 34.45           C  
ATOM     15  C   SER A  18      11.934  36.990  21.353  1.00 33.35           C  
ATOM     16  O   SER A  18      12.205  35.839  21.672  1.00 35.34           O  
ATOM     17  CB  SER A  18      12.440  37.842  19.046  1.00 34.08           C  
ATOM     18  OG  SER A  18      11.048  38.069  18.937  1.00 33.85           O  
ATOM     19  N   TYR A  19      10.843  37.621  21.763  1.00 36.07           N  
ATOM     20  CA  TYR A  19       9.763  36.982  22.518  1.00 33.38           C  
ATOM     21  C   TYR A  19       8.397  37.463  21.990  1.00 34.09           C  
ATOM     22  O   TYR A  19       7.389  37.314  22.668  1.00 35.62           O  
ATOM     23  CB  TYR A  19       9.922  37.304  24.015  1.00 34.92           C  
ATOM     24  CG  TYR A  19      11.335  37.093  24.545  1.00 35.45           C  
ATOM     25  CD1 TYR A  19      11.777  35.820  24.914  1.00 37.85           C  
ATOM     26  CD2 TYR A  19      12.224  38.158  24.669  1.00 37.32           C  
ATOM     27  CE1 TYR A  19      13.047  35.605  25.378  1.00 36.87           C  
ATOM     28  CE2 TYR A  19      13.527  37.955  25.155  1.00 39.67           C  
ATOM     29  CZ  TYR A  19      13.932  36.666  25.503  1.00 39.41           C  
ATOM     30  OH  TYR A  19      15.220  36.433  25.976  1.00 35.15           O  
ATOM     31  N   SER A  20       8.390  38.038  20.783  1.00 34.32           N  
ATOM     32  CA  SER A  20       7.185  38.484  20.063  1.00 32.06           C  
ATOM     33  C   SER A  20       6.331  37.326  19.507  1.00 30.50           C  
ATOM     34  O   SER A  20       6.842  36.453  18.807  1.00 26.28           O  
ATOM     35  CB  SER A  20       7.626  39.376  18.899  1.00 33.51           C  
ATOM     36  OG  SER A  20       6.550  39.719  18.031  1.00 40.20           O  
ATOM     37  N   ASP A  21       5.041  37.322  19.844  1.00 29.51           N  
ATOM     38  CA  ASP A  21       4.076  36.401  19.247  1.00 29.74           C  
ATOM     39  C   ASP A  21       4.069  36.530  17.734  1.00 27.68           C  
ATOM     40  O   ASP A  21       3.993  35.547  17.022  1.00 26.56           O  
ATOM     41  CB  ASP A  21       2.656  36.709  19.714  1.00 29.45           C  
ATOM     42  CG  ASP A  21       2.366  36.298  21.165  1.00 38.18           C  
ATOM     43  OD1 ASP A  21       3.147  35.564  21.805  1.00 46.46           O  
ATOM     44  OD2 ASP A  21       1.288  36.704  21.654  1.00 46.35           O  
ATOM     45  N   GLU A  22       4.096  37.756  17.228  1.00 28.30           N  
ATOM     46  CA  GLU A  22       4.013  37.939  15.774  1.00 30.18           C  
ATOM     47  C   GLU A  22       5.229  37.252  15.110  1.00 28.66           C  
ATOM     48  O   GLU A  22       5.106  36.586  14.072  1.00 27.63           O  
ATOM     49  CB  GLU A  22       3.928  39.414  15.404  1.00 30.29           C  
ATOM     50  CG  GLU A  22       3.192  40.320  16.434  1.00 39.39           C  
ATOM     51  N   ASP A  23       6.393  37.391  15.743  1.00 27.74           N  
ATOM     52  CA  ASP A  23       7.619  36.722  15.292  1.00 27.27           C  
ATOM     53  C   ASP A  23       7.491  35.201  15.282  1.00 29.37           C  
ATOM     54  O   ASP A  23       7.853  34.553  14.279  1.00 27.95           O  
ATOM     55  CB  ASP A  23       8.825  37.150  16.128  1.00 24.76           C  
ATOM     56  CG  ASP A  23       9.363  38.511  15.734  1.00 31.83           C  
ATOM     57  OD1 ASP A  23       8.925  39.081  14.714  1.00 31.39           O  
ATOM     58  OD2 ASP A  23      10.232  39.033  16.442  1.00 35.00           O  
ATOM     59  N   LEU A  24       7.004  34.626  16.392  1.00 27.62           N  
ATOM     60  CA  LEU A  24       6.799  33.162  16.468  1.00 26.25           C  
ATOM     61  C   LEU A  24       5.809  32.646  15.379  1.00 24.12           C  
ATOM     62  O   LEU A  24       6.092  31.657  14.711  1.00 25.79           O  
ATOM     63  CB  LEU A  24       6.336  32.757  17.868  1.00 24.21           C  
ATOM     64  CG  LEU A  24       6.156  31.249  18.152  1.00 25.73           C  
ATOM     65  CD1 LEU A  24       7.515  30.575  18.241  1.00 33.66           C  
ATOM     66  CD2 LEU A  24       5.350  31.042  19.398  1.00 24.57           C  
ATOM     67  N   VAL A  25       4.672  33.311  15.195  1.00 25.51           N  
ATOM     68  CA  VAL A  25       3.679  32.892  14.200  1.00 22.65           C  
ATOM     69  C   VAL A  25       4.301  32.925  12.805  1.00 23.70           C  
ATOM     70  O   VAL A  25       4.115  31.981  12.008  1.00 29.40           O  
ATOM     71  CB  VAL A  25       2.372  33.739  14.247  1.00 22.22           C  
ATOM     72  CG1 VAL A  25       1.494  33.341  13.103  1.00 22.19           C  
ATOM     73  CG2 VAL A  25       1.633  33.546  15.584  1.00 20.08           C  
ATOM     74  N   ALA A  26       5.093  33.962  12.525  1.00 24.52           N  
ATOM     75  CA  ALA A  26       5.749  34.095  11.219  1.00 26.37           C  
ATOM     76  C   ALA A  26       6.668  32.906  10.968  1.00 24.79           C  
ATOM     77  O   ALA A  26       6.722  32.351   9.883  1.00 30.88           O  
ATOM     78  CB  ALA A  26       6.530  35.387  11.153  1.00 23.46           C  
HETATM   79  N   MSE A  27       7.410  32.517  11.989  1.00 27.75           N  
HETATM   80  CA  MSE A  27       8.342  31.395  11.889  1.00 28.57           C  
HETATM   81  C   MSE A  27       7.587  30.068  11.789  1.00 25.48           C  
HETATM   82  O   MSE A  27       7.957  29.167  10.994  1.00 24.74           O  
HETATM   83  CB  MSE A  27       9.236  31.358  13.132  1.00 26.94           C  
HETATM   84  CG  MSE A  27      10.641  31.249  12.778  1.00 43.46           C  
HETATM   85 SE   MSE A  27      11.740  31.053  14.380  0.75 47.99          SE  
HETATM   86  CE  MSE A  27      12.885  29.688  13.543  1.00 25.75           C  
ATOM     87  N   LEU A  28       6.536  29.913  12.594  1.00 22.67           N  
ATOM     88  CA  LEU A  28       5.705  28.695  12.506  1.00 24.93           C  
ATOM     89  C   LEU A  28       5.108  28.557  11.096  1.00 24.06           C  
ATOM     90  O   LEU A  28       5.212  27.509  10.470  1.00 25.04           O  
ATOM     91  CB  LEU A  28       4.621  28.682  13.588  1.00 25.55           C  
ATOM     92  CG  LEU A  28       5.063  28.508  15.042  1.00 26.72           C  
ATOM     93  CD1 LEU A  28       3.833  28.564  15.980  1.00 28.97           C  
ATOM     94  CD2 LEU A  28       5.850  27.182  15.219  1.00 23.69           C  
ATOM     95  N   ASP A  29       4.534  29.634  10.577  1.00 22.82           N  
ATOM     96  CA  ASP A  29       3.941  29.626   9.234  1.00 27.11           C  
ATOM     97  C   ASP A  29       4.884  29.169   8.106  1.00 30.38           C  
ATOM     98  O   ASP A  29       4.412  28.638   7.108  1.00 30.67           O  
ATOM     99  CB  ASP A  29       3.448  31.017   8.848  1.00 28.09           C  
ATOM    100  CG  ASP A  29       2.213  31.454   9.613  1.00 32.03           C  
ATOM    101  OD1 ASP A  29       1.558  30.614  10.274  1.00 32.32           O  
ATOM    102  OD2 ASP A  29       1.897  32.669   9.551  1.00 28.82           O  
ATOM    103  N   ARG A  30       6.183  29.428   8.229  1.00 26.85           N  
ATOM    104  CA  ARG A  30       7.123  29.177   7.139  1.00 25.00           C  
ATOM    105  C   ARG A  30       7.965  27.916   7.327  1.00 27.39           C  
ATOM    106  O   ARG A  30       8.827  27.576   6.480  1.00 28.64           O  
ATOM    107  CB  ARG A  30       7.981  30.422   6.934  1.00 27.12           C  
ATOM    108  CG  ARG A  30       8.940  30.746   8.036  1.00 26.25           C  
ATOM    109  CD  ARG A  30       9.746  32.011   7.694  1.00 28.95           C  
ATOM    110  NE  ARG A  30      10.767  32.249   8.722  1.00 30.10           N  
ATOM    111  CZ  ARG A  30      10.854  33.331   9.481  1.00 26.78           C  
ATOM    112  NH1 ARG A  30      10.041  34.364   9.321  1.00 35.10           N  
ATOM    113  NH2 ARG A  30      11.838  33.419  10.368  1.00 36.70           N  
ATOM    114  N   ASN A  31       7.716  27.202   8.417  1.00 26.96           N  
ATOM    115  CA  ASN A  31       8.355  25.890   8.637  1.00 28.21           C  
ATOM    116  C   ASN A  31       7.309  24.752   8.653  1.00 28.49           C  
ATOM    117  O   ASN A  31       6.217  24.922   9.205  1.00 32.21           O  
ATOM    118  CB  ASN A  31       9.118  25.889   9.955  1.00 29.85           C  
ATOM    119  CG  ASN A  31      10.451  26.588   9.851  1.00 32.78           C  
ATOM    120  OD1 ASN A  31      11.436  26.008   9.391  1.00 38.39           O  
ATOM    121  ND2 ASN A  31      10.468  27.863  10.219  1.00 28.69           N  
ATOM    122  N   PHE A  32       7.650  23.628   8.048  1.00 28.99           N  
ATOM    123  CA  PHE A  32       6.805  22.425   8.053  1.00 26.70           C  
ATOM    124  C   PHE A  32       7.421  21.228   8.751  1.00 22.37           C  
ATOM    125  O   PHE A  32       6.821  20.132   8.763  1.00 21.47           O  
ATOM    126  CB  PHE A  32       6.328  22.021   6.628  1.00 26.38           C  
ATOM    127  CG  PHE A  32       7.416  21.887   5.604  1.00 27.34           C  
ATOM    128  CD1 PHE A  32       8.159  20.738   5.495  1.00 23.53           C  
ATOM    129  CD2 PHE A  32       7.640  22.910   4.692  1.00 32.27           C  
ATOM    130  CE1 PHE A  32       9.149  20.626   4.533  1.00 30.39           C  
ATOM    131  CE2 PHE A  32       8.615  22.797   3.742  1.00 30.22           C  
ATOM    132  CZ  PHE A  32       9.368  21.651   3.664  1.00 22.98           C  
ATOM    133  N   THR A  33       8.600  21.443   9.324  1.00 26.07           N  
ATOM    134  CA  THR A  33       9.243  20.468  10.173  1.00 25.12           C  
ATOM    135  C   THR A  33       9.765  21.176  11.429  1.00 26.53           C  
ATOM    136  O   THR A  33       9.891  22.429  11.473  1.00 28.77           O  
ATOM    137  CB  THR A  33      10.467  19.671   9.508  1.00 27.22           C  
ATOM    138  OG1 THR A  33      11.580  20.560   9.313  1.00 28.48           O  
ATOM    139  CG2 THR A  33      10.112  19.013   8.148  1.00 30.23           C  
ATOM    140  N   CYS A  34      10.039  20.354  12.452  1.00 25.95           N  
ATOM    141  CA  CYS A  34      10.579  20.806  13.728  1.00 23.34           C  
ATOM    142  C   CYS A  34      11.320  19.659  14.393  1.00 25.77           C  
ATOM    143  O   CYS A  34      11.273  18.538  13.913  1.00 24.94           O  
ATOM    144  CB  CYS A  34       9.497  21.298  14.657  1.00 27.92           C  
ATOM    145  SG  CYS A  34       8.325  20.014  15.200  1.00 26.41           S  
ATOM    146  N   THR A  35      11.983  19.950  15.497  1.00 25.79           N  
ATOM    147  CA  THR A  35      12.553  18.906  16.346  1.00 25.62           C  
ATOM    148  C   THR A  35      11.774  18.909  17.637  1.00 28.44           C  
ATOM    149  O   THR A  35      11.474  19.975  18.163  1.00 26.47           O  
ATOM    150  CB  THR A  35      14.055  19.128  16.607  1.00 27.59           C  
ATOM    151  OG1 THR A  35      14.757  19.023  15.360  1.00 32.74           O  
ATOM    152  CG2 THR A  35      14.616  18.020  17.604  1.00 24.24           C  
ATOM    153  N   VAL A  36      11.417  17.721  18.125  1.00 24.34           N  
ATOM    154  CA  VAL A  36      10.676  17.634  19.366  1.00 24.78           C  
ATOM    155  C   VAL A  36      11.538  16.924  20.368  1.00 26.67           C  
ATOM    156  O   VAL A  36      12.000  15.829  20.125  1.00 26.75           O  
ATOM    157  CB  VAL A  36       9.312  16.911  19.196  1.00 25.29           C  
ATOM    158  CG1 VAL A  36       8.642  16.653  20.602  1.00 26.99           C  
ATOM    159  CG2 VAL A  36       8.362  17.707  18.289  1.00 22.87           C  
ATOM    160  N   SER A  37      11.790  17.576  21.500  1.00 25.27           N  
ATOM    161  CA  SER A  37      12.663  17.001  22.486  1.00 23.67           C  
ATOM    162  C   SER A  37      11.860  16.640  23.741  1.00 24.55           C  
ATOM    163  O   SER A  37      10.995  17.417  24.184  1.00 23.24           O  
ATOM    164  CB  SER A  37      13.812  17.949  22.851  1.00 24.80           C  
ATOM    165  OG  SER A  37      14.677  18.148  21.776  1.00 25.51           O  
ATOM    166  N   PHE A  38      12.170  15.479  24.312  1.00 24.47           N  
ATOM    167  CA  PHE A  38      11.357  14.958  25.423  1.00 25.86           C  
ATOM    168  C   PHE A  38      12.164  14.043  26.309  1.00 25.97           C  
ATOM    169  O   PHE A  38      13.243  13.624  25.947  1.00 28.45           O  
ATOM    170  CB  PHE A  38      10.082  14.238  24.906  1.00 24.97           C  
ATOM    171  CG  PHE A  38      10.361  13.088  23.960  1.00 22.10           C  
ATOM    172  CD1 PHE A  38      10.574  11.788  24.437  1.00 23.71           C  
ATOM    173  CD2 PHE A  38      10.468  13.309  22.609  1.00 27.02           C  
ATOM    174  CE1 PHE A  38      10.855  10.739  23.554  1.00 24.40           C  
ATOM    175  CE2 PHE A  38      10.747  12.285  21.728  1.00 25.84           C  
ATOM    176  CZ  PHE A  38      10.945  10.980  22.197  1.00 18.87           C  
ATOM    177  N   ILE A  39      11.623  13.743  27.484  1.00 28.52           N  
ATOM    178  CA  ILE A  39      12.269  12.849  28.428  1.00 27.87           C  
ATOM    179  C   ILE A  39      11.548  11.507  28.476  1.00 28.55           C  
ATOM    180  O   ILE A  39      10.340  11.456  28.584  1.00 28.77           O  
ATOM    181  CB  ILE A  39      12.308  13.436  29.834  1.00 29.23           C  
ATOM    182  CG1 ILE A  39      13.030  14.771  29.844  1.00 24.46           C  
ATOM    183  CG2 ILE A  39      13.002  12.464  30.782  1.00 22.68           C  
ATOM    184  CD1 ILE A  39      13.052  15.451  31.190  1.00 27.08           C  
ATOM    185  N   ASP A  40      12.315  10.423  28.393  1.00 31.70           N  
ATOM    186  CA  ASP A  40      11.768   9.077  28.366  1.00 30.79           C  
ATOM    187  C   ASP A  40      12.668   8.186  29.207  1.00 32.01           C  
ATOM    188  O   ASP A  40      13.795   7.911  28.838  1.00 32.25           O  
ATOM    189  CB  ASP A  40      11.684   8.599  26.928  1.00 32.10           C  
ATOM    190  CG  ASP A  40      11.065   7.226  26.781  1.00 29.08           C  
ATOM    191  OD1 ASP A  40      10.465   6.705  27.737  1.00 33.25           O  
ATOM    192  OD2 ASP A  40      11.181   6.666  25.666  1.00 42.89           O  
ATOM    193  N   GLY A  41      12.159   7.750  30.356  1.00 35.38           N  
ATOM    194  CA  GLY A  41      12.991   7.103  31.362  1.00 35.82           C  
ATOM    195  C   GLY A  41      14.222   7.918  31.712  1.00 35.84           C  
ATOM    196  O   GLY A  41      15.339   7.416  31.661  1.00 34.35           O  
ATOM    197  N   GLY A  42      14.008   9.194  32.037  1.00 35.06           N  
ATOM    198  CA  GLY A  42      15.090  10.103  32.434  1.00 33.64           C  
ATOM    199  C   GLY A  42      16.198  10.344  31.424  1.00 36.94           C  
ATOM    200  O   GLY A  42      17.263  10.843  31.798  1.00 38.91           O  
ATOM    201  N   ILE A  43      15.933  10.007  30.148  1.00 35.33           N  
ATOM    202  CA  ILE A  43      16.881  10.155  29.047  1.00 35.72           C  
ATOM    203  C   ILE A  43      16.220  11.151  28.075  1.00 34.35           C  
ATOM    204  O   ILE A  43      15.039  10.992  27.724  1.00 26.82           O  
ATOM    205  CB  ILE A  43      17.190   8.769  28.361  1.00 35.71           C  
ATOM    206  CG1 ILE A  43      17.822   7.800  29.381  1.00 42.19           C  
ATOM    207  CG2 ILE A  43      18.083   8.933  27.146  1.00 33.93           C  
ATOM    208  CD1 ILE A  43      17.466   6.262  29.213  1.00 33.84           C  
ATOM    209  N   PRO A  44      16.949  12.206  27.684  1.00 33.48           N  
ATOM    210  CA  PRO A  44      16.408  13.133  26.699  1.00 32.94           C  
ATOM    211  C   PRO A  44      16.419  12.519  25.302  1.00 33.13           C  
ATOM    212  O   PRO A  44      17.362  11.857  24.918  1.00 36.92           O  
ATOM    213  CB  PRO A  44      17.361  14.307  26.779  1.00 35.11           C  
ATOM    214  CG  PRO A  44      18.658  13.698  27.162  1.00 30.73           C  
ATOM    215  CD  PRO A  44      18.321  12.572  28.088  1.00 36.09           C  
ATOM    216  N   TYR A  45      15.358  12.708  24.561  1.00 28.00           N  
ATOM    217  CA  TYR A  45      15.308  12.291  23.170  1.00 26.13           C  
ATOM    218  C   TYR A  45      14.979  13.498  22.338  1.00 21.11           C  
ATOM    219  O   TYR A  45      14.414  14.464  22.828  1.00 24.04           O  
ATOM    220  CB  TYR A  45      14.219  11.209  22.961  1.00 24.12           C  
ATOM    221  CG  TYR A  45      14.652   9.875  23.460  1.00 22.78           C  
ATOM    222  CD1 TYR A  45      14.571   9.570  24.814  1.00 21.70           C  
ATOM    223  CD2 TYR A  45      15.158   8.929  22.604  1.00 19.66           C  
ATOM    224  CE1 TYR A  45      15.022   8.331  25.314  1.00 22.56           C  
ATOM    225  CE2 TYR A  45      15.612   7.709  23.097  1.00 21.39           C  
ATOM    226  CZ  TYR A  45      15.519   7.412  24.446  1.00 25.11           C  
ATOM    227  OH  TYR A  45      15.961   6.200  24.941  1.00 26.59           O  
ATOM    228  N   ALA A  46      15.333  13.438  21.062  1.00 24.05           N  
ATOM    229  CA  ALA A  46      14.986  14.485  20.121  1.00 24.81           C  
ATOM    230  C   ALA A  46      14.699  13.787  18.805  1.00 25.24           C  
ATOM    231  O   ALA A  46      15.540  13.002  18.327  1.00 31.02           O  
ATOM    232  CB  ALA A  46      16.169  15.442  19.967  1.00 26.59           C  
ATOM    233  N   ILE A  47      13.506  14.010  18.273  1.00 27.36           N  
ATOM    234  CA  ILE A  47      13.102  13.409  17.002  1.00 26.53           C  
ATOM    235  C   ILE A  47      12.498  14.460  16.074  1.00 25.48           C  
ATOM    236  O   ILE A  47      11.875  15.405  16.521  1.00 23.29           O  
ATOM    237  CB  ILE A  47      12.161  12.184  17.204  1.00 25.87           C  
ATOM    238  CG1 ILE A  47      10.757  12.647  17.593  1.00 35.01           C  
ATOM    239  CG2 ILE A  47      12.835  11.133  18.197  1.00 25.17           C  
ATOM    240  CD1 ILE A  47       9.768  11.551  17.818  1.00 31.64           C  
ATOM    241  N   PRO A  48      12.693  14.312  14.767  1.00 25.39           N  
ATOM    242  CA  PRO A  48      12.065  15.238  13.862  1.00 23.09           C  
ATOM    243  C   PRO A  48      10.583  14.937  13.666  1.00 26.76           C  
ATOM    244  O   PRO A  48      10.174  13.795  13.697  1.00 26.40           O  
ATOM    245  CB  PRO A  48      12.816  15.002  12.530  1.00 27.01           C  
ATOM    246  CG  PRO A  48      13.240  13.637  12.603  1.00 26.10           C  
ATOM    247  CD  PRO A  48      13.495  13.320  14.050  1.00 25.19           C  
HETATM  248  N   MSE A  49       9.783  15.973  13.508  1.00 26.00           N  
HETATM  249  CA  MSE A  49       8.351  15.829  13.240  1.00 29.78           C  
HETATM  250  C   MSE A  49       7.826  16.893  12.277  1.00 27.45           C  
HETATM  251  O   MSE A  49       8.377  18.000  12.183  1.00 25.65           O  
HETATM  252  CB  MSE A  49       7.557  15.850  14.533  0.50 30.32           C  
HETATM  254  CG  MSE A  49       7.796  14.616  15.371  0.50 31.82           C  
HETATM  256 SE   MSE A  49       6.577  14.523  16.859  0.37 35.09          SE  
HETATM  258  CE  MSE A  49       4.921  14.000  15.967  0.50 24.46           C  
HETATM  260  N   MSE A  50       6.737  16.550  11.595  1.00 26.06           N  
HETATM  261  CA  MSE A  50       6.063  17.480  10.707  1.00 28.46           C  
HETATM  262  C   MSE A  50       5.371  18.485  11.562  1.00 25.39           C  
HETATM  263  O   MSE A  50       4.898  18.149  12.634  1.00 29.16           O  
HETATM  264  CB  MSE A  50       5.093  16.782   9.743  0.50 27.37           C  
HETATM  266  CG  MSE A  50       5.768  16.056   8.566  0.50 30.74           C  
HETATM  268 SE   MSE A  50       4.521  15.308   7.288  0.37 35.82          SE  
HETATM  270  CE  MSE A  50       3.701  16.924   6.647  0.50 24.33           C  
ATOM    272  N   LEU A  51       5.343  19.729  11.113  1.00 28.36           N  
ATOM    273  CA  LEU A  51       4.854  20.859  11.905  1.00 28.63           C  
ATOM    274  C   LEU A  51       3.606  21.472  11.297  1.00 26.01           C  
ATOM    275  O   LEU A  51       3.661  22.311  10.380  1.00 28.18           O  
ATOM    276  CB  LEU A  51       5.936  21.929  12.039  1.00 28.57           C  
ATOM    277  CG  LEU A  51       5.671  23.149  12.931  1.00 30.85           C  
ATOM    278  CD1 LEU A  51       5.864  22.836  14.381  1.00 28.81           C  
ATOM    279  CD2 LEU A  51       6.650  24.214  12.525  1.00 34.95           C  
ATOM    280  N   ALA A  52       2.455  21.043  11.795  1.00 24.95           N  
ATOM    281  CA  ALA A  52       1.234  21.735  11.438  1.00 22.31           C  
ATOM    282  C   ALA A  52       1.044  22.822  12.461  1.00 24.64           C  
ATOM    283  O   ALA A  52       1.433  22.698  13.606  1.00 25.60           O  
ATOM    284  CB  ALA A  52       0.031  20.778  11.326  1.00 24.01           C  
ATOM    285  N   SER A  53       0.430  23.926  12.056  1.00 23.22           N  
ATOM    286  CA  SER A  53       0.271  25.013  12.998  1.00 26.74           C  
ATOM    287  C   SER A  53      -0.814  25.895  12.510  1.00 27.30           C  
ATOM    288  O   SER A  53      -1.102  25.916  11.299  1.00 25.62           O  
ATOM    289  CB  SER A  53       1.566  25.805  13.192  1.00 28.74           C  
ATOM    290  OG  SER A  53       2.049  26.424  12.020  1.00 26.86           O  
ATOM    291  N   GLU A  54      -1.409  26.616  13.462  1.00 31.44           N  
ATOM    292  CA  GLU A  54      -2.332  27.664  13.197  1.00 33.63           C  
ATOM    293  C   GLU A  54      -2.169  28.721  14.292  1.00 30.77           C  
ATOM    294  O   GLU A  54      -2.446  28.471  15.476  1.00 26.86           O  
ATOM    295  CB  GLU A  54      -3.762  27.127  13.186  1.00 35.08           C  
ATOM    296  CG  GLU A  54      -4.790  28.161  12.797  1.00 40.94           C  
ATOM    297  CD  GLU A  54      -6.170  27.548  12.623  1.00 42.49           C  
ATOM    298  OE1 GLU A  54      -6.435  26.490  13.262  1.00 60.22           O  
ATOM    299  OE2 GLU A  54      -6.961  28.115  11.841  1.00 54.33           O  
ATOM    300  N   GLY A  55      -1.710  29.899  13.880  1.00 31.91           N  
ATOM    301  CA  GLY A  55      -1.370  30.957  14.816  1.00 31.09           C  
ATOM    302  C   GLY A  55      -0.234  30.438  15.658  1.00 29.09           C  
ATOM    303  O   GLY A  55       0.704  29.841  15.131  1.00 25.72           O  
ATOM    304  N   LYS A  56      -0.326  30.616  16.974  1.00 29.20           N  
ATOM    305  CA  LYS A  56       0.678  30.017  17.888  1.00 31.47           C  
ATOM    306  C   LYS A  56       0.502  28.541  18.214  1.00 30.29           C  
ATOM    307  O   LYS A  56       1.387  27.945  18.808  1.00 27.41           O  
ATOM    308  CB  LYS A  56       0.764  30.804  19.197  1.00 31.08           C  
ATOM    309  CG  LYS A  56       1.401  32.159  19.033  1.00 39.00           C  
ATOM    310  CD  LYS A  56       2.025  32.659  20.331  1.00 39.95           C  
ATOM    311  CE  LYS A  56       1.000  32.937  21.390  1.00 41.81           C  
ATOM    312  NZ  LYS A  56       1.651  33.021  22.737  1.00 47.83           N  
ATOM    313  N   THR A  57      -0.620  27.937  17.838  1.00 30.67           N  
ATOM    314  CA  THR A  57      -0.862  26.527  18.126  1.00 30.07           C  
ATOM    315  C   THR A  57      -0.235  25.598  17.126  1.00 28.15           C  
ATOM    316  O   THR A  57      -0.370  25.791  15.921  1.00 27.77           O  
ATOM    317  CB  THR A  57      -2.362  26.241  18.168  1.00 32.68           C  
ATOM    318  OG1 THR A  57      -2.982  27.142  19.091  1.00 36.34           O  
ATOM    319  CG2 THR A  57      -2.634  24.795  18.582  1.00 37.10           C  
ATOM    320  N   ILE A  58       0.493  24.617  17.657  1.00 26.45           N  
ATOM    321  CA  ILE A  58       1.222  23.610  16.929  1.00 25.44           C  
ATOM    322  C   ILE A  58       0.392  22.342  17.035  1.00 24.49           C  
ATOM    323  O   ILE A  58      -0.216  22.110  18.066  1.00 26.08           O  
ATOM    324  CB  ILE A  58       2.612  23.417  17.571  1.00 23.12           C  
ATOM    325  CG1 ILE A  58       3.498  24.610  17.165  1.00 29.91           C  
ATOM    326  CG2 ILE A  58       3.284  22.069  17.192  1.00 24.70           C  
ATOM    327  CD1 ILE A  58       4.651  24.864  18.104  1.00 27.51           C  
ATOM    328  N   TYR A  59       0.287  21.591  15.934  1.00 26.74           N  
ATOM    329  CA  TYR A  59      -0.353  20.282  15.929  1.00 26.83           C  
ATOM    330  C   TYR A  59       0.630  19.242  15.453  1.00 25.14           C  
ATOM    331  O   TYR A  59       1.317  19.409  14.400  1.00 23.81           O  
ATOM    332  CB  TYR A  59      -1.590  20.251  15.033  1.00 25.09           C  
ATOM    333  CG  TYR A  59      -2.611  21.288  15.368  1.00 23.89           C  
ATOM    334  CD1 TYR A  59      -3.527  21.075  16.393  1.00 22.32           C  
ATOM    335  CD2 TYR A  59      -2.694  22.461  14.647  1.00 33.52           C  
ATOM    336  CE1 TYR A  59      -4.513  22.001  16.694  1.00 28.15           C  
ATOM    337  CE2 TYR A  59      -3.673  23.415  14.958  1.00 31.91           C  
ATOM    338  CZ  TYR A  59      -4.573  23.171  15.979  1.00 31.26           C  
ATOM    339  OH  TYR A  59      -5.550  24.109  16.243  1.00 34.27           O  
ATOM    340  N   LEU A  60       0.806  18.232  16.292  1.00 23.64           N  
ATOM    341  CA  LEU A  60       1.649  17.073  15.987  1.00 22.06           C  
ATOM    342  C   LEU A  60       0.774  15.879  15.606  1.00 23.22           C  
ATOM    343  O   LEU A  60      -0.300  15.677  16.153  1.00 21.94           O  
ATOM    344  CB  LEU A  60       2.523  16.706  17.202  1.00 21.66           C  
ATOM    345  CG  LEU A  60       3.499  17.805  17.644  1.00 22.63           C  
ATOM    346  CD1 LEU A  60       4.266  17.285  18.851  1.00 22.97           C  
ATOM    347  CD2 LEU A  60       4.453  18.269  16.542  1.00 22.73           C  
ATOM    348  N   HIS A  61       1.235  15.066  14.670  1.00 23.10           N  
ATOM    349  CA  HIS A  61       0.454  13.895  14.242  1.00 26.51           C  
ATOM    350  C   HIS A  61       1.376  12.749  13.893  1.00 25.78           C  
ATOM    351  O   HIS A  61       2.579  12.961  13.668  1.00 26.72           O  
ATOM    352  CB  HIS A  61      -0.421  14.195  13.034  1.00 26.73           C  
ATOM    353  CG  HIS A  61       0.320  14.194  11.727  1.00 27.03           C  
ATOM    354  ND1 HIS A  61       1.063  15.277  11.287  1.00 28.84           N  
ATOM    355  CD2 HIS A  61       0.436  13.242  10.767  1.00 25.73           C  
ATOM    356  CE1 HIS A  61       1.577  14.996  10.102  1.00 27.63           C  
ATOM    357  NE2 HIS A  61       1.220  13.770   9.769  1.00 26.59           N  
ATOM    358  N   GLY A  62       0.792  11.555  13.844  1.00 27.58           N  
ATOM    359  CA  GLY A  62       1.546  10.360  13.566  1.00 30.14           C  
ATOM    360  C   GLY A  62       0.823   9.055  13.819  1.00 31.76           C  
ATOM    361  O   GLY A  62      -0.371   9.028  14.007  1.00 29.16           O  
ATOM    362  N   SER A  63       1.591   7.973  13.846  1.00 37.19           N  
ATOM    363  CA  SER A  63       1.034   6.657  14.018  1.00 40.16           C  
ATOM    364  C   SER A  63       0.893   6.363  15.485  1.00 39.47           C  
ATOM    365  O   SER A  63       1.770   6.653  16.270  1.00 37.30           O  
ATOM    366  CB  SER A  63       1.908   5.578  13.371  1.00 42.46           C  
ATOM    367  OG  SER A  63       1.602   4.296  13.914  1.00 44.89           O  
HETATM  368  N   MSE A  64      -0.215   5.725  15.837  1.00 41.46           N  
HETATM  369  CA  MSE A  64      -0.437   5.340  17.203  1.00 42.35           C  
HETATM  370  C   MSE A  64       0.483   4.192  17.614  1.00 42.12           C  
HETATM  371  O   MSE A  64       0.673   3.955  18.790  1.00 41.47           O  
HETATM  372  CB  MSE A  64      -1.885   4.961  17.387  1.00 43.08           C  
HETATM  373  CG  MSE A  64      -2.862   6.032  16.919  1.00 36.71           C  
HETATM  374 SE   MSE A  64      -4.611   5.807  17.810  0.75 49.34          SE  
HETATM  375  CE  MSE A  64      -4.933   7.688  18.363  1.00 46.37           C  
ATOM    376  N   LYS A  65       1.077   3.505  16.645  1.00 43.44           N  
ATOM    377  CA  LYS A  65       2.027   2.436  16.957  1.00 45.01           C  
ATOM    378  C   LYS A  65       3.419   2.988  17.392  1.00 45.50           C  
ATOM    379  O   LYS A  65       4.267   2.249  17.895  1.00 44.90           O  
ATOM    380  CB  LYS A  65       2.152   1.477  15.758  1.00 47.20           C  
ATOM    381  CG  LYS A  65       0.822   0.979  15.161  1.00 44.04           C  
ATOM    382  N   SER A  66       3.642   4.291  17.242  1.00 46.74           N  
ATOM    383  CA  SER A  66       4.927   4.918  17.600  1.00 46.01           C  
ATOM    384  C   SER A  66       5.102   5.169  19.084  1.00 44.25           C  
ATOM    385  O   SER A  66       4.140   5.454  19.794  1.00 47.57           O  
ATOM    386  CB  SER A  66       5.059   6.266  16.871  1.00 46.70           C  
ATOM    387  OG  SER A  66       4.211   7.224  17.479  1.00 54.24           O  
ATOM    388  N   ARG A  67       6.347   5.132  19.544  1.00 42.58           N  
ATOM    389  CA  ARG A  67       6.670   5.412  20.952  1.00 41.07           C  
ATOM    390  C   ARG A  67       6.333   6.858  21.352  1.00 39.05           C  
ATOM    391  O   ARG A  67       6.017   7.141  22.516  1.00 36.30           O  
ATOM    392  CB  ARG A  67       8.164   5.126  21.218  1.00 42.27           C  
ATOM    393  N   ILE A  68       6.409   7.773  20.380  1.00 37.58           N  
ATOM    394  CA  ILE A  68       6.072   9.165  20.614  1.00 34.71           C  
ATOM    395  C   ILE A  68       4.616   9.325  21.048  1.00 31.41           C  
ATOM    396  O   ILE A  68       4.315  10.209  21.821  1.00 28.84           O  
ATOM    397  CB  ILE A  68       6.422  10.077  19.371  1.00 34.11           C  
ATOM    398  CG1 ILE A  68       6.459  11.551  19.746  1.00 36.30           C  
ATOM    399  CG2 ILE A  68       5.475   9.852  18.202  1.00 34.13           C  
ATOM    400  CD1 ILE A  68       7.341  11.892  20.893  1.00 36.07           C  
ATOM    401  N   TYR A  69       3.723   8.468  20.580  1.00 32.26           N  
ATOM    402  CA  TYR A  69       2.303   8.559  21.009  1.00 31.56           C  
ATOM    403  C   TYR A  69       2.138   8.481  22.528  1.00 31.38           C  
ATOM    404  O   TYR A  69       1.530   9.355  23.164  1.00 27.52           O  
ATOM    405  CB  TYR A  69       1.456   7.510  20.281  1.00 31.05           C  
ATOM    406  CG  TYR A  69      -0.034   7.606  20.553  1.00 33.86           C  
ATOM    407  CD1 TYR A  69      -0.675   8.834  20.608  1.00 24.17           C  
ATOM    408  CD2 TYR A  69      -0.802   6.461  20.757  1.00 40.95           C  
ATOM    409  CE1 TYR A  69      -2.024   8.919  20.859  1.00 31.35           C  
ATOM    410  CE2 TYR A  69      -2.160   6.545  21.003  1.00 39.18           C  
ATOM    411  CZ  TYR A  69      -2.762   7.783  21.053  1.00 34.48           C  
ATOM    412  OH  TYR A  69      -4.106   7.899  21.280  1.00 36.85           O  
ATOM    413  N   GLY A  70       2.714   7.443  23.119  1.00 32.44           N  
ATOM    414  CA  GLY A  70       2.669   7.240  24.557  1.00 32.80           C  
ATOM    415  C   GLY A  70       3.258   8.392  25.341  1.00 33.50           C  
ATOM    416  O   GLY A  70       2.732   8.765  26.390  1.00 32.28           O  
ATOM    417  N   ILE A  71       4.331   8.981  24.811  1.00 32.74           N  
ATOM    418  CA  ILE A  71       4.958  10.125  25.432  1.00 29.79           C  
ATOM    419  C   ILE A  71       4.012  11.296  25.411  1.00 29.35           C  
ATOM    420  O   ILE A  71       3.853  11.955  26.405  1.00 32.19           O  
ATOM    421  CB  ILE A  71       6.269  10.554  24.695  1.00 33.81           C  
ATOM    422  CG1 ILE A  71       7.391   9.524  24.914  1.00 30.69           C  
ATOM    423  CG2 ILE A  71       6.732  11.863  25.251  1.00 32.19           C  
ATOM    424  CD1 ILE A  71       7.871   9.508  26.337  1.00 27.70           C  
ATOM    425  N   LEU A  72       3.420  11.585  24.252  1.00 26.32           N  
ATOM    426  CA  LEU A  72       2.493  12.733  24.151  1.00 27.28           C  
ATOM    427  C   LEU A  72       1.251  12.569  25.002  1.00 28.85           C  
ATOM    428  O   LEU A  72       0.730  13.555  25.550  1.00 25.96           O  
ATOM    429  CB  LEU A  72       2.157  13.040  22.691  1.00 29.86           C  
ATOM    430  CG  LEU A  72       3.363  13.457  21.819  1.00 26.97           C  
ATOM    431  CD1 LEU A  72       2.946  13.572  20.389  1.00 26.28           C  
ATOM    432  CD2 LEU A  72       3.955  14.777  22.319  1.00 26.71           C  
ATOM    433  N   LYS A  73       0.776  11.329  25.120  1.00 28.84           N  
ATOM    434  CA  LYS A  73      -0.380  11.018  25.986  1.00 32.94           C  
ATOM    435  C   LYS A  73      -0.146  11.414  27.472  1.00 32.51           C  
ATOM    436  O   LYS A  73      -1.100  11.759  28.186  1.00 34.17           O  
ATOM    437  CB  LYS A  73      -0.750   9.539  25.903  1.00 32.08           C  
ATOM    438  CG  LYS A  73      -1.634   9.164  24.785  1.00 36.87           C  
ATOM    439  CD  LYS A  73      -1.982   7.669  24.822  1.00 37.69           C  
ATOM    440  CE  LYS A  73      -3.463   7.405  24.987  1.00 54.16           C  
ATOM    441  NZ  LYS A  73      -4.335   8.190  24.052  1.00 53.06           N  
ATOM    442  N   THR A  74       1.103  11.398  27.921  1.00 30.29           N  
ATOM    443  CA  THR A  74       1.408  11.781  29.302  1.00 30.16           C  
ATOM    444  C   THR A  74       1.076  13.234  29.605  1.00 32.28           C  
ATOM    445  O   THR A  74       0.795  13.599  30.763  1.00 31.43           O  
ATOM    446  CB  THR A  74       2.897  11.535  29.677  1.00 32.52           C  
ATOM    447  OG1 THR A  74       3.774  12.378  28.905  1.00 32.11           O  
ATOM    448  CG2 THR A  74       3.274  10.057  29.509  1.00 33.84           C  
ATOM    449  N   GLY A  75       1.165  14.069  28.574  1.00 32.32           N  
ATOM    450  CA  GLY A  75       0.979  15.520  28.703  1.00 33.69           C  
ATOM    451  C   GLY A  75       2.205  16.212  29.304  1.00 33.85           C  
ATOM    452  O   GLY A  75       2.119  17.376  29.713  1.00 33.70           O  
ATOM    453  N   GLN A  76       3.349  15.511  29.340  1.00 34.36           N  
ATOM    454  CA  GLN A  76       4.598  16.072  29.900  1.00 35.48           C  
ATOM    455  C   GLN A  76       5.019  17.298  29.092  1.00 32.43           C  
ATOM    456  O   GLN A  76       4.646  17.438  27.917  1.00 31.16           O  
ATOM    457  CB  GLN A  76       5.737  15.023  29.950  1.00 34.90           C  
ATOM    458  CG  GLN A  76       6.202  14.500  28.604  1.00 41.75           C  
ATOM    459  CD  GLN A  76       7.225  13.349  28.706  1.00 43.18           C  
ATOM    460  OE1 GLN A  76       8.428  13.566  28.572  1.00 58.13           O  
ATOM    461  NE2 GLN A  76       6.734  12.129  28.914  1.00 50.50           N  
ATOM    462  N   LEU A  77       5.757  18.197  29.722  1.00 30.60           N  
ATOM    463  CA  LEU A  77       6.321  19.324  29.003  1.00 31.79           C  
ATOM    464  C   LEU A  77       7.285  18.806  27.925  1.00 31.28           C  
ATOM    465  O   LEU A  77       8.160  17.976  28.200  1.00 31.54           O  
ATOM    466  CB  LEU A  77       7.047  20.265  29.954  1.00 31.35           C  
ATOM    467  CG  LEU A  77       7.400  21.677  29.469  1.00 32.47           C  
ATOM    468  CD1 LEU A  77       6.208  22.539  29.254  1.00 21.07           C  
ATOM    469  CD2 LEU A  77       8.314  22.358  30.494  1.00 37.54           C  
ATOM    470  N   ILE A  78       7.083  19.274  26.697  1.00 28.04           N  
ATOM    471  CA  ILE A  78       7.983  18.972  25.579  1.00 24.47           C  
ATOM    472  C   ILE A  78       8.591  20.292  25.058  1.00 23.10           C  
ATOM    473  O   ILE A  78       8.020  21.402  25.285  1.00 25.17           O  
ATOM    474  CB  ILE A  78       7.269  18.170  24.473  1.00 20.78           C  
ATOM    475  CG1 ILE A  78       6.118  18.976  23.870  1.00 23.01           C  
ATOM    476  CG2 ILE A  78       6.865  16.831  25.021  1.00 23.63           C  
ATOM    477  CD1 ILE A  78       5.628  18.477  22.494  1.00 24.41           C  
ATOM    478  N   ALA A  79       9.757  20.178  24.414  1.00 24.46           N  
ATOM    479  CA  ALA A  79      10.468  21.301  23.838  1.00 25.78           C  
ATOM    480  C   ALA A  79      10.444  21.146  22.327  1.00 26.17           C  
ATOM    481  O   ALA A  79      10.954  20.187  21.778  1.00 30.99           O  
ATOM    482  CB  ALA A  79      11.934  21.334  24.348  1.00 22.89           C  
ATOM    483  N   ILE A  80       9.829  22.100  21.651  1.00 22.24           N  
ATOM    484  CA  ILE A  80       9.813  22.107  20.208  1.00 24.00           C  
ATOM    485  C   ILE A  80      10.772  23.202  19.716  1.00 24.62           C  
ATOM    486  O   ILE A  80      10.655  24.366  20.095  1.00 24.45           O  
ATOM    487  CB  ILE A  80       8.376  22.323  19.692  1.00 24.70           C  
ATOM    488  CG1 ILE A  80       7.449  21.173  20.181  1.00 27.89           C  
ATOM    489  CG2 ILE A  80       8.381  22.518  18.152  1.00 20.54           C  
ATOM    490  CD1 ILE A  80       5.980  21.410  19.854  1.00 25.85           C  
ATOM    491  N   SER A  81      11.710  22.792  18.882  1.00 21.53           N  
ATOM    492  CA  SER A  81      12.748  23.666  18.339  1.00 22.62           C  
ATOM    493  C   SER A  81      12.663  23.798  16.805  1.00 23.96           C  
ATOM    494  O   SER A  81      12.373  22.831  16.049  1.00 24.06           O  
ATOM    495  CB  SER A  81      14.159  23.169  18.764  1.00 20.57           C  
ATOM    496  OG  SER A  81      14.484  21.889  18.285  1.00 29.37           O  
ATOM    497  N   LEU A  82      12.928  25.010  16.345  1.00 21.80           N  
ATOM    498  CA  LEU A  82      13.003  25.329  14.949  1.00 22.67           C  
ATOM    499  C   LEU A  82      14.370  25.963  14.656  1.00 24.84           C  
ATOM    500  O   LEU A  82      14.931  26.670  15.488  1.00 22.98           O  
ATOM    501  CB  LEU A  82      11.944  26.372  14.659  1.00 23.75           C  
ATOM    502  CG  LEU A  82      10.479  26.092  14.952  1.00 29.60           C  
ATOM    503  CD1 LEU A  82       9.701  27.224  14.246  1.00 33.65           C  
ATOM    504  CD2 LEU A  82      10.062  24.769  14.425  1.00 32.77           C  
ATOM    505  N   LEU A  83      14.905  25.733  13.459  1.00 28.11           N  
ATOM    506  CA  LEU A  83      16.209  26.296  13.089  1.00 27.37           C  
ATOM    507  C   LEU A  83      16.228  26.607  11.587  1.00 28.10           C  
ATOM    508  O   LEU A  83      15.863  25.754  10.821  1.00 27.04           O  
ATOM    509  CB  LEU A  83      17.341  25.326  13.444  1.00 26.44           C  
ATOM    510  CG  LEU A  83      18.735  25.816  13.113  1.00 28.62           C  
ATOM    511  CD1 LEU A  83      19.158  27.056  13.888  1.00 22.04           C  
ATOM    512  CD2 LEU A  83      19.648  24.642  13.420  1.00 27.65           C  
ATOM    513  N   GLU A  84      16.568  27.836  11.225  1.00 24.84           N  
ATOM    514  CA  GLU A  84      16.704  28.273   9.818  1.00 23.45           C  
ATOM    515  C   GLU A  84      18.135  28.768   9.632  1.00 24.37           C  
ATOM    516  O   GLU A  84      18.581  29.579  10.374  1.00 22.24           O  
ATOM    517  CB  GLU A  84      15.714  29.423   9.573  1.00 24.06           C  
ATOM    518  CG  GLU A  84      14.309  28.998   9.697  1.00 21.62           C  
ATOM    519  CD  GLU A  84      13.332  30.144   9.678  1.00 28.87           C  
ATOM    520  OE1 GLU A  84      13.798  31.250   9.901  1.00 28.47           O  
ATOM    521  OE2 GLU A  84      12.140  29.904   9.442  1.00 32.28           O  
ATOM    522  N   ILE A  85      18.876  28.181   8.707  1.00 22.78           N  
ATOM    523  CA  ILE A  85      20.257  28.529   8.431  1.00 26.73           C  
ATOM    524  C   ILE A  85      20.370  29.319   7.138  1.00 22.29           C  
ATOM    525  O   ILE A  85      19.954  28.857   6.062  1.00 26.47           O  
ATOM    526  CB  ILE A  85      21.139  27.310   8.220  1.00 24.12           C  
ATOM    527  CG1 ILE A  85      21.041  26.323   9.414  1.00 29.92           C  
ATOM    528  CG2 ILE A  85      22.571  27.784   7.916  1.00 28.43           C  
ATOM    529  CD1 ILE A  85      21.431  26.854  10.739  1.00 33.23           C  
ATOM    530  N   ASN A  86      20.947  30.499   7.235  1.00 27.18           N  
ATOM    531  CA  ASN A  86      20.869  31.479   6.116  1.00 27.42           C  
ATOM    532  C   ASN A  86      22.206  31.914   5.513  1.00 27.39           C  
ATOM    533  O   ASN A  86      22.233  32.455   4.396  1.00 27.63           O  
ATOM    534  CB  ASN A  86      20.102  32.697   6.571  1.00 27.39           C  
ATOM    535  CG  ASN A  86      18.608  32.403   6.777  1.00 31.35           C  
ATOM    536  OD1 ASN A  86      17.921  31.842   5.901  1.00 27.67           O  
ATOM    537  ND2 ASN A  86      18.111  32.782   7.930  1.00 22.24           N  
ATOM    538  N   GLY A  87      23.303  31.729   6.245  1.00 25.62           N  
ATOM    539  CA  GLY A  87      24.610  32.024   5.656  1.00 26.77           C  
ATOM    540  C   GLY A  87      25.764  31.698   6.537  1.00 28.38           C  
ATOM    541  O   GLY A  87      25.577  31.495   7.701  1.00 28.87           O  
ATOM    542  N   ILE A  88      26.953  31.586   5.943  1.00 26.45           N  
ATOM    543  CA  ILE A  88      28.197  31.421   6.654  1.00 24.66           C  
ATOM    544  C   ILE A  88      28.897  32.799   6.757  1.00 26.75           C  
ATOM    545  O   ILE A  88      29.088  33.503   5.733  1.00 23.56           O  
ATOM    546  CB  ILE A  88      29.080  30.357   5.904  1.00 23.28           C  
ATOM    547  CG1 ILE A  88      28.342  29.010   5.830  1.00 27.84           C  
ATOM    548  CG2 ILE A  88      30.514  30.267   6.536  1.00 24.62           C  
ATOM    549  CD1 ILE A  88      29.082  27.926   4.983  1.00 26.47           C  
ATOM    550  N   VAL A  89      29.182  33.242   7.981  1.00 23.94           N  
ATOM    551  CA  VAL A  89      29.791  34.549   8.187  1.00 24.67           C  
ATOM    552  C   VAL A  89      31.291  34.387   8.320  1.00 22.03           C  
ATOM    553  O   VAL A  89      31.756  33.794   9.262  1.00 22.50           O  
ATOM    554  CB  VAL A  89      29.162  35.330   9.393  1.00 23.69           C  
ATOM    555  CG1 VAL A  89      29.826  36.693   9.566  1.00 21.62           C  
ATOM    556  CG2 VAL A  89      27.669  35.491   9.157  1.00 21.73           C  
ATOM    557  N   LEU A  90      32.035  34.913   7.340  1.00 22.11           N  
ATOM    558  CA  LEU A  90      33.506  34.829   7.317  1.00 24.80           C  
ATOM    559  C   LEU A  90      34.105  36.179   7.668  1.00 22.43           C  
ATOM    560  O   LEU A  90      34.094  37.101   6.841  1.00 23.94           O  
ATOM    561  CB  LEU A  90      34.038  34.406   5.947  1.00 24.17           C  
ATOM    562  CG  LEU A  90      33.657  33.018   5.470  1.00 31.02           C  
ATOM    563  CD1 LEU A  90      34.191  32.787   4.080  1.00 36.52           C  
ATOM    564  CD2 LEU A  90      34.145  31.915   6.464  1.00 21.96           C  
ATOM    565  N   ALA A  91      34.612  36.279   8.890  1.00 21.37           N  
ATOM    566  CA  ALA A  91      35.292  37.456   9.374  1.00 20.96           C  
ATOM    567  C   ALA A  91      36.799  37.334   9.128  1.00 22.32           C  
ATOM    568  O   ALA A  91      37.330  36.233   8.859  1.00 23.47           O  
ATOM    569  CB  ALA A  91      34.982  37.652  10.832  1.00 20.47           C  
ATOM    570  N   LYS A  92      37.496  38.470   9.188  1.00 21.26           N  
ATOM    571  CA  LYS A  92      38.947  38.497   9.012  1.00 21.69           C  
ATOM    572  C   LYS A  92      39.618  37.629  10.083  1.00 23.41           C  
ATOM    573  O   LYS A  92      40.615  36.962   9.805  1.00 29.57           O  
ATOM    574  CB  LYS A  92      39.527  39.912   9.096  1.00 23.60           C  
ATOM    575  CG  LYS A  92      39.061  40.882   8.041  1.00 18.27           C  
ATOM    576  CD  LYS A  92      39.898  42.113   8.057  1.00 23.38           C  
ATOM    577  CE  LYS A  92      39.368  43.152   7.088  1.00 25.01           C  
ATOM    578  NZ  LYS A  92      40.253  44.306   7.020  1.00 21.57           N  
ATOM    579  N   GLU A  93      39.063  37.662  11.293  1.00 22.11           N  
ATOM    580  CA  GLU A  93      39.510  36.817  12.398  1.00 24.62           C  
ATOM    581  C   GLU A  93      38.616  35.602  12.527  1.00 23.09           C  
ATOM    582  O   GLU A  93      37.407  35.735  12.644  1.00 20.85           O  
ATOM    583  CB  GLU A  93      39.493  37.591  13.733  1.00 23.25           C  
ATOM    584  CG  GLU A  93      40.508  38.678  13.817  1.00 30.13           C  
ATOM    585  CD  GLU A  93      40.502  39.409  15.153  1.00 31.39           C  
ATOM    586  OE1 GLU A  93      40.491  38.742  16.218  1.00 38.80           O  
ATOM    587  OE2 GLU A  93      40.525  40.662  15.135  1.00 38.36           O  
ATOM    588  N   ILE A  94      39.228  34.411  12.519  1.00 23.97           N  
ATOM    589  CA  ILE A  94      38.535  33.149  12.719  1.00 25.31           C  
ATOM    590  C   ILE A  94      37.586  33.214  13.925  1.00 29.13           C  
ATOM    591  O   ILE A  94      36.512  32.686  13.879  1.00 31.75           O  
ATOM    592  CB  ILE A  94      39.546  31.990  12.976  1.00 24.78           C  
ATOM    593  CG1 ILE A  94      40.395  31.724  11.744  1.00 26.76           C  
ATOM    594  CG2 ILE A  94      38.779  30.714  13.551  1.00 28.52           C  
ATOM    595  CD1 ILE A  94      39.699  30.961  10.668  1.00 26.38           C  
ATOM    596  N   LYS A  95      37.998  33.867  15.011  1.00 30.84           N  
ATOM    597  CA  LYS A  95      37.183  33.922  16.221  1.00 30.93           C  
ATOM    598  C   LYS A  95      35.897  34.729  16.031  1.00 28.30           C  
ATOM    599  O   LYS A  95      35.002  34.660  16.870  1.00 28.22           O  
ATOM    600  CB  LYS A  95      37.992  34.511  17.378  1.00 31.63           C  
ATOM    601  CG  LYS A  95      38.263  36.032  17.293  1.00 35.14           C  
ATOM    602  CD  LYS A  95      38.450  36.619  18.716  1.00 38.95           C  
ATOM    603  CE  LYS A  95      38.709  38.134  18.731  1.00 43.18           C  
ATOM    604  NZ  LYS A  95      37.714  38.938  17.959  1.00 49.13           N  
ATOM    605  N   ASN A  96      35.804  35.491  14.943  1.00 27.29           N  
ATOM    606  CA  ASN A  96      34.603  36.280  14.610  1.00 27.60           C  
ATOM    607  C   ASN A  96      33.736  35.599  13.549  1.00 27.26           C  
ATOM    608  O   ASN A  96      32.729  36.191  13.135  1.00 30.13           O  
ATOM    609  CB  ASN A  96      34.964  37.706  14.112  1.00 25.19           C  
ATOM    610  CG  ASN A  96      35.602  38.587  15.193  1.00 34.28           C  
ATOM    611  OD1 ASN A  96      35.361  38.387  16.370  1.00 32.61           O  
ATOM    612  ND2 ASN A  96      36.443  39.547  14.781  1.00 26.55           N  
ATOM    613  N   ASN A  97      34.133  34.395  13.099  1.00 27.11           N  
ATOM    614  CA  ASN A  97      33.343  33.630  12.112  1.00 25.52           C  
ATOM    615  C   ASN A  97      32.048  33.218  12.813  1.00 26.27           C  
ATOM    616  O   ASN A  97      32.061  32.966  14.001  1.00 28.25           O  
ATOM    617  CB  ASN A  97      34.099  32.384  11.593  1.00 24.18           C  
ATOM    618  CG  ASN A  97      35.216  32.712  10.600  1.00 19.06           C  
ATOM    619  OD1 ASN A  97      35.338  33.835  10.158  1.00 22.22           O  
ATOM    620  ND2 ASN A  97      36.049  31.709  10.265  1.00 20.03           N  
ATOM    621  N   SER A  98      30.916  33.217  12.114  1.00 26.32           N  
ATOM    622  CA  SER A  98      29.693  32.655  12.684  1.00 26.79           C  
ATOM    623  C   SER A  98      28.746  32.192  11.581  1.00 26.03           C  
ATOM    624  O   SER A  98      29.153  31.960  10.453  1.00 24.99           O  
ATOM    625  CB  SER A  98      29.012  33.638  13.641  1.00 29.04           C  
ATOM    626  OG  SER A  98      28.573  34.774  12.939  1.00 41.96           O  
ATOM    627  N   ILE A  99      27.486  31.997  11.940  1.00 24.43           N  
ATOM    628  CA  ILE A  99      26.453  31.550  11.013  1.00 24.96           C  
ATOM    629  C   ILE A  99      25.325  32.553  11.179  1.00 21.56           C  
ATOM    630  O   ILE A  99      25.020  32.981  12.286  1.00 24.34           O  
ATOM    631  CB  ILE A  99      25.943  30.148  11.364  1.00 27.92           C  
ATOM    632  CG1 ILE A  99      27.065  29.135  11.160  1.00 29.55           C  
ATOM    633  CG2 ILE A  99      24.740  29.763  10.494  1.00 30.05           C  
ATOM    634  CD1 ILE A  99      27.748  29.212   9.807  1.00 30.34           C  
ATOM    635  N   ASN A 100      24.693  32.908  10.087  1.00 24.62           N  
ATOM    636  CA  ASN A 100      23.483  33.697  10.182  1.00 22.43           C  
ATOM    637  C   ASN A 100      22.317  32.703  10.196  1.00 23.10           C  
ATOM    638  O   ASN A 100      22.232  31.815   9.345  1.00 24.94           O  
ATOM    639  CB  ASN A 100      23.333  34.652   9.028  1.00 23.30           C  
ATOM    640  CG  ASN A 100      24.133  35.917   9.189  1.00 30.23           C  
ATOM    641  OD1 ASN A 100      24.453  36.326  10.301  1.00 23.06           O  
ATOM    642  ND2 ASN A 100      24.461  36.548   8.065  1.00 27.34           N  
ATOM    643  N   TYR A 101      21.431  32.877  11.156  1.00 23.36           N  
ATOM    644  CA  TYR A 101      20.394  31.880  11.419  1.00 23.50           C  
ATOM    645  C   TYR A 101      19.212  32.516  12.157  1.00 26.49           C  
ATOM    646  O   TYR A 101      19.272  33.705  12.634  1.00 26.10           O  
ATOM    647  CB  TYR A 101      21.011  30.692  12.232  1.00 20.83           C  
ATOM    648  CG  TYR A 101      21.221  31.143  13.682  1.00 27.13           C  
ATOM    649  CD1 TYR A 101      22.291  31.958  14.031  1.00 30.37           C  
ATOM    650  CD2 TYR A 101      20.283  30.844  14.666  1.00 25.35           C  
ATOM    651  CE1 TYR A 101      22.431  32.451  15.316  1.00 32.10           C  
ATOM    652  CE2 TYR A 101      20.434  31.298  15.963  1.00 27.72           C  
ATOM    653  CZ  TYR A 101      21.498  32.103  16.291  1.00 35.97           C  
ATOM    654  OH  TYR A 101      21.615  32.565  17.613  1.00 35.95           O  
ATOM    655  N   VAL A 102      18.111  31.747  12.235  1.00 26.36           N  
ATOM    656  CA  VAL A 102      17.031  32.092  13.133  1.00 24.53           C  
ATOM    657  C   VAL A 102      16.644  30.803  13.851  1.00 23.68           C  
ATOM    658  O   VAL A 102      16.573  29.736  13.241  1.00 23.11           O  
ATOM    659  CB  VAL A 102      15.822  32.623  12.402  1.00 27.34           C  
ATOM    660  CG1 VAL A 102      14.772  33.201  13.395  1.00 23.76           C  
ATOM    661  CG2 VAL A 102      16.244  33.660  11.340  1.00 28.35           C  
ATOM    662  N   SER A 103      16.337  30.901  15.142  1.00 23.37           N  
ATOM    663  CA  SER A 103      16.013  29.708  15.927  1.00 22.85           C  
ATOM    664  C   SER A 103      14.891  30.021  16.873  1.00 21.18           C  
ATOM    665  O   SER A 103      14.668  31.185  17.206  1.00 23.74           O  
ATOM    666  CB  SER A 103      17.221  29.183  16.703  1.00 24.58           C  
ATOM    667  OG  SER A 103      17.611  30.048  17.742  1.00 26.87           O  
ATOM    668  N   ALA A 104      14.122  28.992  17.217  1.00 19.02           N  
ATOM    669  CA  ALA A 104      13.049  29.118  18.232  1.00 23.51           C  
ATOM    670  C   ALA A 104      13.059  27.913  19.120  1.00 25.23           C  
ATOM    671  O   ALA A 104      13.378  26.837  18.673  1.00 23.53           O  
ATOM    672  CB  ALA A 104      11.677  29.255  17.596  1.00 24.67           C  
ATOM    673  N   LEU A 105      12.724  28.125  20.394  1.00 26.23           N  
ATOM    674  CA  LEU A 105      12.539  27.042  21.359  1.00 25.95           C  
ATOM    675  C   LEU A 105      11.196  27.290  22.069  1.00 24.45           C  
ATOM    676  O   LEU A 105      11.015  28.313  22.704  1.00 22.42           O  
ATOM    677  CB  LEU A 105      13.672  27.008  22.398  1.00 27.77           C  
ATOM    678  CG  LEU A 105      13.554  25.942  23.499  1.00 28.16           C  
ATOM    679  CD1 LEU A 105      13.554  24.580  22.843  1.00 26.48           C  
ATOM    680  CD2 LEU A 105      14.714  26.047  24.457  1.00 25.50           C  
ATOM    681  N   ILE A 106      10.278  26.338  21.891  1.00 25.63           N  
ATOM    682  CA  ILE A 106       8.891  26.426  22.335  1.00 26.50           C  
ATOM    683  C   ILE A 106       8.600  25.318  23.364  1.00 26.61           C  
ATOM    684  O   ILE A 106       8.874  24.139  23.113  1.00 24.31           O  
ATOM    685  CB  ILE A 106       7.934  26.277  21.155  1.00 26.11           C  
ATOM    686  CG1 ILE A 106       8.253  27.321  20.091  1.00 28.80           C  
ATOM    687  CG2 ILE A 106       6.505  26.360  21.662  1.00 25.56           C  
ATOM    688  CD1 ILE A 106       8.019  26.879  18.652  1.00 26.65           C  
ATOM    689  N   PHE A 107       8.104  25.716  24.534  1.00 21.39           N  
ATOM    690  CA  PHE A 107       7.729  24.772  25.575  1.00 23.69           C  
ATOM    691  C   PHE A 107       6.213  24.661  25.700  1.00 25.78           C  
ATOM    692  O   PHE A 107       5.500  25.656  25.797  1.00 22.78           O  
ATOM    693  CB  PHE A 107       8.296  25.183  26.920  1.00 25.91           C  
ATOM    694  CG  PHE A 107       9.791  25.077  27.023  1.00 28.13           C  
ATOM    695  CD1 PHE A 107      10.381  23.902  27.433  1.00 21.49           C  
ATOM    696  CD2 PHE A 107      10.592  26.163  26.781  1.00 28.98           C  
ATOM    697  CE1 PHE A 107      11.725  23.807  27.574  1.00 27.13           C  
ATOM    698  CE2 PHE A 107      11.975  26.053  26.913  1.00 27.81           C  
ATOM    699  CZ  PHE A 107      12.514  24.872  27.332  1.00 29.09           C  
ATOM    700  N   GLY A 108       5.710  23.434  25.698  1.00 26.29           N  
ATOM    701  CA  GLY A 108       4.267  23.222  25.816  1.00 25.98           C  
ATOM    702  C   GLY A 108       3.872  21.828  26.294  1.00 26.50           C  
ATOM    703  O   GLY A 108       4.641  20.884  26.186  1.00 23.03           O  
ATOM    704  N   ARG A 109       2.643  21.724  26.798  1.00 25.98           N  
ATOM    705  CA  ARG A 109       2.062  20.461  27.286  1.00 25.09           C  
ATOM    706  C   ARG A 109       0.958  20.010  26.331  1.00 24.84           C  
ATOM    707  O   ARG A 109      -0.071  20.699  26.181  1.00 20.83           O  
ATOM    708  CB  ARG A 109       1.518  20.619  28.713  0.50 24.82           C  
ATOM    710  CG  ARG A 109       2.582  21.073  29.704  0.50 21.46           C  
ATOM    712  CD  ARG A 109       2.010  21.610  30.997  0.50 21.06           C  
ATOM    714  NE  ARG A 109       2.994  22.419  31.707  0.50 12.79           N  
ATOM    716  CZ  ARG A 109       4.049  21.949  32.382  0.50 21.71           C  
ATOM    718  NH1 ARG A 109       4.278  20.649  32.497  0.50 26.44           N  
ATOM    720  NH2 ARG A 109       4.884  22.805  32.973  0.50 20.79           N  
ATOM    722  N   PRO A 110       1.188  18.886  25.631  1.00 22.65           N  
ATOM    723  CA  PRO A 110       0.238  18.413  24.634  1.00 21.89           C  
ATOM    724  C   PRO A 110      -1.107  17.937  25.188  1.00 24.68           C  
ATOM    725  O   PRO A 110      -1.186  17.426  26.345  1.00 21.08           O  
ATOM    726  CB  PRO A 110       0.930  17.221  23.988  1.00 23.97           C  
ATOM    727  CG  PRO A 110       2.246  17.130  24.560  1.00 25.96           C  
ATOM    728  CD  PRO A 110       2.358  18.000  25.748  1.00 24.48           C  
ATOM    729  N   TYR A 111      -2.144  18.144  24.386  1.00 23.43           N  
ATOM    730  CA  TYR A 111      -3.426  17.457  24.597  1.00 26.77           C  
ATOM    731  C   TYR A 111      -3.972  16.814  23.307  1.00 26.08           C  
ATOM    732  O   TYR A 111      -3.797  17.342  22.224  1.00 24.23           O  
ATOM    733  CB  TYR A 111      -4.511  18.335  25.295  1.00 26.01           C  
ATOM    734  CG  TYR A 111      -5.087  19.424  24.452  1.00 21.89           C  
ATOM    735  CD1 TYR A 111      -6.136  19.180  23.597  1.00 26.02           C  
ATOM    736  CD2 TYR A 111      -4.600  20.727  24.533  1.00 31.59           C  
ATOM    737  CE1 TYR A 111      -6.678  20.189  22.806  1.00 28.73           C  
ATOM    738  CE2 TYR A 111      -5.164  21.750  23.759  1.00 28.04           C  
ATOM    739  CZ  TYR A 111      -6.191  21.461  22.895  1.00 28.31           C  
ATOM    740  OH  TYR A 111      -6.750  22.452  22.108  1.00 29.72           O  
ATOM    741  N   GLU A 112      -4.617  15.661  23.473  1.00 24.38           N  
ATOM    742  CA  GLU A 112      -5.072  14.878  22.339  1.00 25.71           C  
ATOM    743  C   GLU A 112      -6.376  15.413  21.793  1.00 23.53           C  
ATOM    744  O   GLU A 112      -7.287  15.682  22.533  1.00 25.48           O  
ATOM    745  CB  GLU A 112      -5.201  13.373  22.659  1.00 24.88           C  
ATOM    746  CG  GLU A 112      -5.388  12.524  21.355  1.00 30.62           C  
ATOM    747  CD  GLU A 112      -5.108  11.022  21.485  1.00 31.78           C  
ATOM    748  OE1 GLU A 112      -4.920  10.499  22.602  1.00 34.35           O  
ATOM    749  OE2 GLU A 112      -5.107  10.360  20.421  1.00 39.35           O  
ATOM    750  N   ILE A 113      -6.417  15.582  20.478  1.00 23.44           N  
ATOM    751  CA  ILE A 113      -7.642  15.914  19.751  1.00 25.81           C  
ATOM    752  C   ILE A 113      -8.412  14.639  19.433  1.00 28.81           C  
ATOM    753  O   ILE A 113      -7.890  13.734  18.746  1.00 27.93           O  
ATOM    754  CB  ILE A 113      -7.339  16.665  18.429  1.00 28.43           C  
ATOM    755  CG1 ILE A 113      -6.631  18.014  18.690  1.00 24.04           C  
ATOM    756  CG2 ILE A 113      -8.631  16.776  17.559  1.00 24.70           C  
ATOM    757  CD1 ILE A 113      -7.427  19.027  19.456  1.00 30.15           C  
ATOM    758  N   ASP A 114      -9.655  14.572  19.919  1.00 28.45           N  
ATOM    759  CA  ASP A 114     -10.450  13.339  19.784  1.00 33.11           C  
ATOM    760  C   ASP A 114     -11.484  13.359  18.626  1.00 32.81           C  
ATOM    761  O   ASP A 114     -11.807  12.308  18.082  1.00 34.95           O  
ATOM    762  CB  ASP A 114     -11.084  12.961  21.138  1.00 32.03           C  
ATOM    763  CG  ASP A 114     -10.094  12.273  22.103  1.00 36.82           C  
ATOM    764  OD1 ASP A 114      -8.903  12.054  21.781  1.00 41.76           O  
ATOM    765  OD2 ASP A 114     -10.521  11.917  23.214  1.00 40.84           O  
ATOM    766  N   ASP A 115     -11.967  14.527  18.204  1.00 35.28           N  
ATOM    767  CA  ASP A 115     -13.000  14.542  17.151  1.00 35.99           C  
ATOM    768  C   ASP A 115     -12.421  14.520  15.723  1.00 35.01           C  
ATOM    769  O   ASP A 115     -11.391  15.135  15.437  1.00 31.42           O  
ATOM    770  CB  ASP A 115     -14.043  15.654  17.354  1.00 39.54           C  
ATOM    771  CG  ASP A 115     -13.519  17.016  17.081  1.00 42.97           C  
ATOM    772  OD1 ASP A 115     -12.581  17.412  17.799  1.00 44.98           O  
ATOM    773  OD2 ASP A 115     -14.074  17.688  16.168  1.00 40.59           O  
ATOM    774  N   THR A 116     -13.088  13.777  14.850  1.00 34.58           N  
ATOM    775  CA  THR A 116     -12.535  13.524  13.526  1.00 34.66           C  
ATOM    776  C   THR A 116     -12.581  14.807  12.677  1.00 31.61           C  
ATOM    777  O   THR A 116     -11.699  15.031  11.855  1.00 29.66           O  
ATOM    778  CB  THR A 116     -13.198  12.304  12.813  1.00 38.97           C  
ATOM    779  OG1 THR A 116     -13.899  12.732  11.641  1.00 43.25           O  
ATOM    780  CG2 THR A 116     -14.112  11.535  13.748  1.00 32.24           C  
ATOM    781  N   GLU A 117     -13.565  15.668  12.909  1.00 28.74           N  
ATOM    782  CA  GLU A 117     -13.639  16.908  12.141  1.00 31.42           C  
ATOM    783  C   GLU A 117     -12.463  17.822  12.430  1.00 29.08           C  
ATOM    784  O   GLU A 117     -11.969  18.475  11.540  1.00 27.58           O  
ATOM    785  CB  GLU A 117     -14.936  17.680  12.396  1.00 31.19           C  
ATOM    786  CG  GLU A 117     -15.066  19.014  11.583  1.00 35.94           C  
ATOM    787  CD  GLU A 117     -14.704  18.864  10.069  1.00 50.33           C  
ATOM    788  OE1 GLU A 117     -15.317  17.977   9.421  1.00 44.68           O  
ATOM    789  OE2 GLU A 117     -13.798  19.611   9.546  1.00 51.12           O  
ATOM    790  N   LYS A 118     -12.044  17.926  13.688  1.00 31.96           N  
ATOM    791  CA  LYS A 118     -10.875  18.758  14.010  1.00 30.38           C  
ATOM    792  C   LYS A 118      -9.610  18.142  13.438  1.00 28.60           C  
ATOM    793  O   LYS A 118      -8.775  18.876  12.933  1.00 30.24           O  
ATOM    794  CB  LYS A 118     -10.719  19.006  15.507  1.00 29.13           C  
ATOM    795  CG  LYS A 118      -9.614  19.991  15.878  1.00 33.76           C  
ATOM    796  CD  LYS A 118      -9.657  21.364  15.176  1.00 34.93           C  
ATOM    797  CE  LYS A 118      -8.662  22.358  15.828  1.00 39.16           C  
ATOM    798  NZ  LYS A 118      -8.287  23.539  14.962  1.00 43.21           N  
ATOM    799  N   LYS A 119      -9.502  16.815  13.472  1.00 26.40           N  
ATOM    800  CA  LYS A 119      -8.405  16.121  12.824  1.00 25.24           C  
ATOM    801  C   LYS A 119      -8.337  16.408  11.307  1.00 28.05           C  
ATOM    802  O   LYS A 119      -7.274  16.633  10.766  1.00 24.74           O  
ATOM    803  CB  LYS A 119      -8.498  14.632  13.054  1.00 23.91           C  
ATOM    804  CG  LYS A 119      -8.214  14.265  14.481  1.00 27.60           C  
ATOM    805  CD  LYS A 119      -8.548  12.861  14.806  1.00 33.35           C  
ATOM    806  CE  LYS A 119      -7.341  11.985  14.767  1.00 31.36           C  
ATOM    807  NZ  LYS A 119      -7.651  10.703  15.447  1.00 25.43           N  
ATOM    808  N   ILE A 120      -9.487  16.389  10.639  1.00 24.31           N  
ATOM    809  CA  ILE A 120      -9.576  16.761   9.229  1.00 26.45           C  
ATOM    810  C   ILE A 120      -9.053  18.179   9.017  1.00 25.09           C  
ATOM    811  O   ILE A 120      -8.231  18.395   8.110  1.00 25.15           O  
ATOM    812  CB  ILE A 120     -11.024  16.611   8.733  1.00 26.29           C  
ATOM    813  CG1 ILE A 120     -11.397  15.121   8.702  1.00 28.74           C  
ATOM    814  CG2 ILE A 120     -11.271  17.244   7.323  1.00 22.68           C  
ATOM    815  CD1 ILE A 120     -12.889  14.875   8.617  1.00 31.22           C  
ATOM    816  N   GLU A 121      -9.521  19.131   9.826  1.00 28.46           N  
ATOM    817  CA  GLU A 121      -9.056  20.517   9.720  1.00 29.72           C  
ATOM    818  C   GLU A 121      -7.523  20.615   9.836  1.00 27.74           C  
ATOM    819  O   GLU A 121      -6.884  21.427   9.122  1.00 24.06           O  
ATOM    820  CB  GLU A 121      -9.731  21.449  10.753  1.00 30.35           C  
ATOM    821  CG  GLU A 121      -9.517  22.963  10.405  1.00 40.06           C  
ATOM    822  CD  GLU A 121      -9.085  23.881  11.557  1.00 60.26           C  
ATOM    823  OE1 GLU A 121      -9.352  23.571  12.750  1.00 67.51           O  
ATOM    824  OE2 GLU A 121      -8.502  24.954  11.242  1.00 62.18           O  
ATOM    825  N   VAL A 122      -6.939  19.807  10.733  1.00 27.15           N  
ATOM    826  CA  VAL A 122      -5.497  19.842  10.966  1.00 26.50           C  
ATOM    827  C   VAL A 122      -4.745  19.341   9.724  1.00 26.84           C  
ATOM    828  O   VAL A 122      -3.761  19.955   9.284  1.00 23.82           O  
ATOM    829  CB  VAL A 122      -5.109  19.060  12.237  1.00 25.43           C  
ATOM    830  CG1 VAL A 122      -3.615  18.906  12.358  1.00 25.32           C  
ATOM    831  CG2 VAL A 122      -5.673  19.799  13.457  1.00 24.44           C  
ATOM    832  N   PHE A 123      -5.243  18.269   9.122  1.00 25.80           N  
ATOM    833  CA  PHE A 123      -4.639  17.777   7.884  1.00 24.73           C  
ATOM    834  C   PHE A 123      -4.736  18.765   6.714  1.00 22.19           C  
ATOM    835  O   PHE A 123      -3.804  18.897   5.928  1.00 24.01           O  
ATOM    836  CB  PHE A 123      -5.176  16.414   7.524  1.00 28.82           C  
ATOM    837  CG  PHE A 123      -4.541  15.335   8.299  1.00 33.68           C  
ATOM    838  CD1 PHE A 123      -3.319  14.822   7.899  1.00 41.08           C  
ATOM    839  CD2 PHE A 123      -5.132  14.857   9.462  1.00 42.58           C  
ATOM    840  CE1 PHE A 123      -2.707  13.825   8.628  1.00 45.93           C  
ATOM    841  CE2 PHE A 123      -4.519  13.861  10.210  1.00 43.81           C  
ATOM    842  CZ  PHE A 123      -3.302  13.343   9.798  1.00 42.70           C  
ATOM    843  N   ARG A 124      -5.825  19.521   6.671  1.00 25.43           N  
ATOM    844  CA  ARG A 124      -6.008  20.526   5.642  1.00 26.47           C  
ATOM    845  C   ARG A 124      -5.031  21.656   5.868  1.00 24.06           C  
ATOM    846  O   ARG A 124      -4.447  22.136   4.927  1.00 25.28           O  
ATOM    847  CB  ARG A 124      -7.433  21.061   5.702  1.00 27.36           C  
ATOM    848  CG  ARG A 124      -7.822  22.049   4.601  1.00 35.28           C  
ATOM    849  CD  ARG A 124      -9.293  22.449   4.776  1.00 36.96           C  
ATOM    850  NE  ARG A 124      -9.741  23.413   3.769  1.00 51.96           N  
ATOM    851  CZ  ARG A 124     -11.010  23.819   3.604  1.00 52.99           C  
ATOM    852  NH1 ARG A 124     -11.999  23.351   4.365  1.00 57.35           N  
ATOM    853  NH2 ARG A 124     -11.301  24.704   2.661  1.00 53.92           N  
ATOM    854  N   LEU A 125      -4.877  22.091   7.125  1.00 26.68           N  
ATOM    855  CA  LEU A 125      -3.919  23.161   7.494  1.00 27.17           C  
ATOM    856  C   LEU A 125      -2.491  22.755   7.119  1.00 23.88           C  
ATOM    857  O   LEU A 125      -1.768  23.547   6.511  1.00 23.07           O  
ATOM    858  CB  LEU A 125      -3.969  23.504   9.003  1.00 30.26           C  
ATOM    859  CG  LEU A 125      -5.159  24.287   9.561  1.00 38.27           C  
ATOM    860  CD1 LEU A 125      -5.203  24.184  11.164  1.00 35.21           C  
ATOM    861  CD2 LEU A 125      -5.117  25.722   9.028  1.00 33.23           C  
ATOM    862  N   LEU A 126      -2.103  21.528   7.459  1.00 24.95           N  
ATOM    863  CA  LEU A 126      -0.763  21.003   7.122  1.00 25.70           C  
ATOM    864  C   LEU A 126      -0.528  20.951   5.623  1.00 25.21           C  
ATOM    865  O   LEU A 126       0.518  21.375   5.131  1.00 24.60           O  
ATOM    866  CB  LEU A 126      -0.573  19.585   7.676  1.00 24.70           C  
ATOM    867  CG  LEU A 126       0.794  18.907   7.456  1.00 28.50           C  
ATOM    868  CD1 LEU A 126       1.955  19.804   7.910  1.00 34.59           C  
ATOM    869  CD2 LEU A 126       0.815  17.604   8.234  1.00 28.10           C  
ATOM    870  N   THR A 127      -1.527  20.455   4.898  1.00 25.09           N  
ATOM    871  CA  THR A 127      -1.442  20.324   3.444  1.00 23.21           C  
ATOM    872  C   THR A 127      -1.303  21.675   2.782  1.00 22.27           C  
ATOM    873  O   THR A 127      -0.461  21.847   1.895  1.00 23.06           O  
ATOM    874  CB  THR A 127      -2.674  19.538   2.855  1.00 22.35           C  
ATOM    875  OG1 THR A 127      -2.838  18.278   3.537  1.00 20.49           O  
ATOM    876  CG2 THR A 127      -2.544  19.329   1.316  1.00 21.81           C  
ATOM    877  N   GLU A 128      -2.089  22.659   3.210  1.00 23.81           N  
ATOM    878  CA  GLU A 128      -1.997  23.960   2.620  1.00 26.87           C  
ATOM    879  C   GLU A 128      -0.668  24.663   2.966  1.00 29.66           C  
ATOM    880  O   GLU A 128      -0.217  25.499   2.187  1.00 27.39           O  
ATOM    881  CB  GLU A 128      -3.198  24.839   3.021  1.00 28.34           C  
ATOM    882  CG  GLU A 128      -4.531  24.387   2.361  1.00 32.42           C  
ATOM    883  CD  GLU A 128      -4.471  24.430   0.801  1.00 36.99           C  
ATOM    884  OE1 GLU A 128      -4.756  25.504   0.257  1.00 34.80           O  
ATOM    885  OE2 GLU A 128      -4.115  23.395   0.164  1.00 38.80           O  
ATOM    886  N   LYS A 129      -0.034  24.309   4.102  1.00 28.39           N  
ATOM    887  CA  LYS A 129       1.261  24.873   4.434  1.00 29.29           C  
ATOM    888  C   LYS A 129       2.337  24.257   3.526  1.00 27.67           C  
ATOM    889  O   LYS A 129       3.224  24.971   3.049  1.00 31.84           O  
ATOM    890  CB  LYS A 129       1.576  24.727   5.953  1.00 29.66           C  
ATOM    891  CG  LYS A 129       2.937  25.285   6.359  1.00 34.36           C  
ATOM    892  CD  LYS A 129       3.415  24.755   7.755  1.00 31.81           C  
ATOM    893  CE  LYS A 129       2.904  25.604   8.830  1.00 27.81           C  
ATOM    894  NZ  LYS A 129       3.518  25.212  10.139  1.00 22.56           N  
ATOM    895  N   LEU A 130       2.281  22.951   3.283  1.00 28.04           N  
ATOM    896  CA  LEU A 130       3.216  22.335   2.348  1.00 27.78           C  
ATOM    897  C   LEU A 130       3.044  22.846   0.904  1.00 27.46           C  
ATOM    898  O   LEU A 130       3.994  23.328   0.324  1.00 28.40           O  
ATOM    899  CB  LEU A 130       3.108  20.815   2.351  1.00 30.53           C  
ATOM    900  CG  LEU A 130       3.480  20.074   3.620  1.00 32.02           C  
ATOM    901  CD1 LEU A 130       2.936  18.644   3.536  1.00 31.31           C  
ATOM    902  CD2 LEU A 130       4.955  20.101   3.766  1.00 29.70           C  
ATOM    903  N   VAL A 131       1.851  22.659   0.313  1.00 29.15           N  
ATOM    904  CA  VAL A 131       1.568  23.105  -1.071  1.00 25.32           C  
ATOM    905  C   VAL A 131       0.185  23.702  -1.111  1.00 20.14           C  
ATOM    906  O   VAL A 131      -0.829  22.963  -1.054  1.00 20.69           O  
ATOM    907  CB  VAL A 131       1.694  21.945  -2.104  1.00 24.63           C  
ATOM    908  CG1 VAL A 131       1.423  22.447  -3.539  1.00 19.86           C  
ATOM    909  CG2 VAL A 131       3.080  21.228  -1.992  1.00 25.82           C  
ATOM    910  N   LYS A 132       0.100  25.032  -1.190  1.00 19.86           N  
ATOM    911  CA  LYS A 132      -1.197  25.680  -1.311  1.00 22.33           C  
ATOM    912  C   LYS A 132      -1.943  25.251  -2.607  1.00 21.87           C  
ATOM    913  O   LYS A 132      -1.371  25.285  -3.697  1.00 24.22           O  
ATOM    914  CB  LYS A 132      -1.031  27.199  -1.248  1.00 21.29           C  
ATOM    915  CG  LYS A 132      -2.353  27.960  -1.149  1.00 27.43           C  
ATOM    916  CD  LYS A 132      -2.143  29.459  -1.122  1.00 27.37           C  
ATOM    917  CE  LYS A 132      -3.491  30.167  -1.205  1.00 35.91           C  
ATOM    918  NZ  LYS A 132      -3.389  31.667  -1.295  1.00 41.90           N  
ATOM    919  N   GLY A 133      -3.206  24.842  -2.476  1.00 23.09           N  
ATOM    920  CA  GLY A 133      -3.976  24.299  -3.604  1.00 22.99           C  
ATOM    921  C   GLY A 133      -4.084  22.778  -3.689  1.00 22.04           C  
ATOM    922  O   GLY A 133      -4.884  22.218  -4.449  1.00 20.40           O  
ATOM    923  N   ARG A 134      -3.256  22.098  -2.932  1.00 22.26           N  
ATOM    924  CA  ARG A 134      -3.173  20.648  -3.026  1.00 23.85           C  
ATOM    925  C   ARG A 134      -4.345  19.889  -2.374  1.00 24.52           C  
ATOM    926  O   ARG A 134      -4.814  18.891  -2.935  1.00 23.88           O  
ATOM    927  CB  ARG A 134      -1.845  20.163  -2.412  1.00 24.87           C  
ATOM    928  CG  ARG A 134      -1.675  18.653  -2.373  1.00 23.36           C  
ATOM    929  CD  ARG A 134      -1.779  18.091  -3.775  1.00 25.83           C  
ATOM    930  NE  ARG A 134      -1.421  16.689  -3.860  1.00 23.49           N  
ATOM    931  CZ  ARG A 134      -1.208  16.022  -4.995  1.00 24.21           C  
ATOM    932  NH1 ARG A 134      -1.265  16.601  -6.181  1.00 23.47           N  
ATOM    933  NH2 ARG A 134      -0.886  14.751  -4.938  1.00 24.36           N  
ATOM    934  N   TRP A 135      -4.819  20.351  -1.208  1.00 21.38           N  
ATOM    935  CA  TRP A 135      -5.927  19.688  -0.507  1.00 22.55           C  
ATOM    936  C   TRP A 135      -7.103  19.422  -1.442  1.00 22.79           C  
ATOM    937  O   TRP A 135      -7.657  18.332  -1.493  1.00 20.64           O  
ATOM    938  CB  TRP A 135      -6.408  20.589   0.619  1.00 23.23           C  
ATOM    939  CG  TRP A 135      -7.610  20.115   1.348  1.00 24.75           C  
ATOM    940  CD1 TRP A 135      -8.908  20.558   1.190  1.00 23.11           C  
ATOM    941  CD2 TRP A 135      -7.653  19.114   2.350  1.00 22.02           C  
ATOM    942  NE1 TRP A 135      -9.738  19.912   2.063  1.00 23.90           N  
ATOM    943  CE2 TRP A 135      -9.003  19.010   2.786  1.00 27.86           C  
ATOM    944  CE3 TRP A 135      -6.684  18.292   2.944  1.00 26.03           C  
ATOM    945  CZ2 TRP A 135      -9.398  18.117   3.788  1.00 24.77           C  
ATOM    946  CZ3 TRP A 135      -7.089  17.423   3.946  1.00 22.62           C  
ATOM    947  CH2 TRP A 135      -8.412  17.354   4.361  1.00 21.04           C  
ATOM    948  N   ASP A 136      -7.513  20.463  -2.139  1.00 21.68           N  
ATOM    949  CA  ASP A 136      -8.662  20.362  -3.033  1.00 21.33           C  
ATOM    950  C   ASP A 136      -8.514  19.243  -4.075  1.00 19.92           C  
ATOM    951  O   ASP A 136      -9.487  18.539  -4.348  1.00 22.54           O  
ATOM    952  CB  ASP A 136      -8.893  21.744  -3.662  0.50 22.19           C  
ATOM    954  CG  ASP A 136     -10.057  21.786  -4.617  0.50 15.21           C  
ATOM    956  OD1 ASP A 136     -11.062  21.083  -4.398  0.50 19.14           O  
ATOM    958  OD2 ASP A 136      -9.942  22.553  -5.600  0.50 22.77           O  
ATOM    960  N   ASN A 137      -7.312  19.059  -4.611  1.00 18.65           N  
ATOM    961  CA  ASN A 137      -7.028  18.165  -5.750  1.00 19.35           C  
ATOM    962  C   ASN A 137      -6.385  16.836  -5.258  1.00 22.62           C  
ATOM    963  O   ASN A 137      -5.575  16.242  -5.951  1.00 30.09           O  
ATOM    964  CB  ASN A 137      -6.051  18.905  -6.656  1.00 18.71           C  
ATOM    965  CG  ASN A 137      -5.688  18.147  -7.918  1.00 28.43           C  
ATOM    966  OD1 ASN A 137      -6.535  17.558  -8.599  1.00 27.08           O  
ATOM    967  ND2 ASN A 137      -4.405  18.183  -8.253  1.00 17.27           N  
ATOM    968  N   SER A 138      -6.729  16.397  -4.059  1.00 20.12           N  
ATOM    969  CA  SER A 138      -6.120  15.212  -3.473  1.00 20.44           C  
ATOM    970  C   SER A 138      -7.188  14.371  -2.719  1.00 22.51           C  
ATOM    971  O   SER A 138      -8.170  14.916  -2.182  1.00 20.28           O  
ATOM    972  CB  SER A 138      -5.004  15.639  -2.513  1.00 21.48           C  
ATOM    973  OG  SER A 138      -4.366  14.462  -2.002  1.00 25.66           O  
ATOM    974  N   ILE A 139      -6.987  13.056  -2.680  1.00 22.28           N  
ATOM    975  CA  ILE A 139      -7.891  12.146  -1.932  1.00 23.68           C  
ATOM    976  C   ILE A 139      -7.796  12.375  -0.431  1.00 24.74           C  
ATOM    977  O   ILE A 139      -6.717  12.212   0.183  1.00 25.12           O  
ATOM    978  CB  ILE A 139      -7.640  10.654  -2.263  1.00 20.92           C  
ATOM    979  CG1 ILE A 139      -7.990  10.390  -3.729  1.00 26.84           C  
ATOM    980  CG2 ILE A 139      -8.467   9.730  -1.326  1.00 23.62           C  
ATOM    981  CD1 ILE A 139      -7.313   9.178  -4.366  1.00 26.20           C  
ATOM    982  N   LYS A 140      -8.936  12.742   0.164  1.00 23.00           N  
ATOM    983  CA  LYS A 140      -9.030  13.104   1.593  1.00 24.00           C  
ATOM    984  C   LYS A 140      -9.061  11.875   2.486  1.00 23.00           C  
ATOM    985  O   LYS A 140      -9.553  10.831   2.088  1.00 23.10           O  
ATOM    986  CB  LYS A 140     -10.305  13.896   1.886  1.00 28.85           C  
ATOM    987  CG  LYS A 140     -10.683  14.999   0.907  1.00 30.97           C  
ATOM    988  CD  LYS A 140      -9.638  16.034   0.773  1.00 33.68           C  
ATOM    989  CE  LYS A 140     -10.142  17.222  -0.130  1.00 29.14           C  
ATOM    990  NZ  LYS A 140     -10.018  16.985  -1.620  1.00 20.08           N  
ATOM    991  N   PRO A 141      -8.583  11.997   3.714  1.00 23.88           N  
ATOM    992  CA  PRO A 141      -8.611  10.809   4.614  1.00 25.54           C  
ATOM    993  C   PRO A 141     -10.009  10.317   4.973  1.00 25.28           C  
ATOM    994  O   PRO A 141     -10.895  11.127   5.258  1.00 23.83           O  
ATOM    995  CB  PRO A 141      -7.936  11.306   5.889  1.00 26.36           C  
ATOM    996  CG  PRO A 141      -7.315  12.611   5.546  1.00 29.20           C  
ATOM    997  CD  PRO A 141      -7.978  13.174   4.358  1.00 25.69           C  
ATOM    998  N   SER A 142     -10.180   9.003   4.980  1.00 24.45           N  
ATOM    999  CA  SER A 142     -11.433   8.403   5.383  1.00 25.05           C  
ATOM   1000  C   SER A 142     -11.536   8.435   6.911  1.00 27.20           C  
ATOM   1001  O   SER A 142     -10.593   8.780   7.590  1.00 26.77           O  
ATOM   1002  CB  SER A 142     -11.535   6.965   4.897  1.00 25.23           C  
ATOM   1003  OG  SER A 142     -10.572   6.107   5.505  1.00 27.16           O  
ATOM   1004  N   TYR A 143     -12.698   8.076   7.424  1.00 26.24           N  
ATOM   1005  CA  TYR A 143     -12.887   7.957   8.861  1.00 29.39           C  
ATOM   1006  C   TYR A 143     -11.967   6.831   9.430  1.00 28.91           C  
ATOM   1007  O   TYR A 143     -11.313   6.988  10.473  1.00 27.85           O  
ATOM   1008  CB  TYR A 143     -14.378   7.751   9.140  1.00 32.65           C  
ATOM   1009  CG  TYR A 143     -14.718   7.434  10.566  1.00 37.41           C  
ATOM   1010  CD1 TYR A 143     -14.681   8.425  11.552  1.00 38.73           C  
ATOM   1011  CD2 TYR A 143     -15.084   6.138  10.934  1.00 43.43           C  
ATOM   1012  CE1 TYR A 143     -14.996   8.138  12.866  1.00 42.31           C  
ATOM   1013  CE2 TYR A 143     -15.414   5.832  12.240  1.00 46.46           C  
ATOM   1014  CZ  TYR A 143     -15.364   6.836  13.207  1.00 46.25           C  
ATOM   1015  OH  TYR A 143     -15.678   6.512  14.510  1.00 46.20           O  
ATOM   1016  N   GLU A 144     -11.866   5.726   8.707  1.00 31.42           N  
ATOM   1017  CA  GLU A 144     -10.965   4.630   9.093  1.00 31.90           C  
ATOM   1018  C   GLU A 144      -9.516   5.132   9.173  1.00 31.61           C  
ATOM   1019  O   GLU A 144      -8.811   4.868  10.160  1.00 32.80           O  
ATOM   1020  CB  GLU A 144     -11.080   3.473   8.091  1.00 33.91           C  
ATOM   1021  CG  GLU A 144     -10.661   2.097   8.586  1.00 34.78           C  
ATOM   1022  N   ASP A 145      -9.080   5.878   8.154  1.00 28.73           N  
ATOM   1023  CA  ASP A 145      -7.719   6.417   8.107  1.00 29.85           C  
ATOM   1024  C   ASP A 145      -7.450   7.308   9.320  1.00 29.05           C  
ATOM   1025  O   ASP A 145      -6.412   7.244   9.940  1.00 28.76           O  
ATOM   1026  CB  ASP A 145      -7.500   7.310   6.869  1.00 32.45           C  
ATOM   1027  CG  ASP A 145      -7.484   6.553   5.515  1.00 34.05           C  
ATOM   1028  OD1 ASP A 145      -7.146   5.359   5.438  1.00 34.48           O  
ATOM   1029  OD2 ASP A 145      -7.771   7.225   4.494  1.00 29.75           O  
ATOM   1030  N   LEU A 146      -8.391   8.187   9.619  1.00 28.35           N  
ATOM   1031  CA  LEU A 146      -8.224   9.124  10.722  1.00 26.29           C  
ATOM   1032  C   LEU A 146      -8.166   8.425  12.095  1.00 26.46           C  
ATOM   1033  O   LEU A 146      -7.568   8.933  13.016  1.00 27.43           O  
ATOM   1034  CB  LEU A 146      -9.348  10.165  10.717  1.00 26.43           C  
ATOM   1035  CG  LEU A 146      -9.308  11.174   9.556  1.00 31.40           C  
ATOM   1036  CD1 LEU A 146     -10.692  11.858   9.344  1.00 36.55           C  
ATOM   1037  CD2 LEU A 146      -8.187  12.155   9.753  1.00 32.48           C  
ATOM   1038  N   ASN A 147      -8.844   7.301  12.231  1.00 27.21           N  
ATOM   1039  CA  ASN A 147      -8.862   6.529  13.470  1.00 27.90           C  
ATOM   1040  C   ASN A 147      -7.468   5.939  13.747  1.00 28.34           C  
ATOM   1041  O   ASN A 147      -7.180   5.546  14.881  1.00 28.53           O  
ATOM   1042  CB  ASN A 147      -9.923   5.395  13.374  1.00 29.97           C  
ATOM   1043  CG  ASN A 147     -11.346   5.852  13.716  1.00 33.72           C  
ATOM   1044  OD1 ASN A 147     -11.605   7.020  14.004  1.00 38.36           O  
ATOM   1045  ND2 ASN A 147     -12.276   4.908  13.695  1.00 36.55           N  
ATOM   1046  N   GLY A 148      -6.620   5.858  12.710  1.00 26.77           N  
ATOM   1047  CA  GLY A 148      -5.271   5.338  12.863  1.00 28.87           C  
ATOM   1048  C   GLY A 148      -4.171   6.396  13.101  1.00 29.75           C  
ATOM   1049  O   GLY A 148      -3.001   6.055  13.237  1.00 29.69           O  
ATOM   1050  N   VAL A 149      -4.522   7.674  13.123  1.00 26.64           N  
ATOM   1051  CA  VAL A 149      -3.536   8.722  13.259  1.00 28.32           C  
ATOM   1052  C   VAL A 149      -3.869   9.539  14.494  1.00 26.22           C  
ATOM   1053  O   VAL A 149      -5.013   9.969  14.661  1.00 26.53           O  
ATOM   1054  CB  VAL A 149      -3.442   9.650  11.995  1.00 32.16           C  
ATOM   1055  CG1 VAL A 149      -3.340   8.811  10.738  1.00 35.36           C  
ATOM   1056  CG2 VAL A 149      -4.651  10.550  11.893  1.00 35.57           C  
ATOM   1057  N   PHE A 150      -2.888   9.701  15.381  1.00 25.38           N  
ATOM   1058  CA  PHE A 150      -3.023  10.641  16.483  1.00 25.02           C  
ATOM   1059  C   PHE A 150      -2.822  12.073  16.016  1.00 24.54           C  
ATOM   1060  O   PHE A 150      -2.087  12.326  15.057  1.00 24.05           O  
ATOM   1061  CB  PHE A 150      -2.088  10.282  17.642  1.00 24.25           C  
ATOM   1062  CG  PHE A 150      -0.609  10.572  17.397  1.00 21.43           C  
ATOM   1063  CD1 PHE A 150      -0.107  11.890  17.373  1.00 22.73           C  
ATOM   1064  CD2 PHE A 150       0.309   9.525  17.280  1.00 26.91           C  
ATOM   1065  CE1 PHE A 150       1.246  12.134  17.207  1.00 28.21           C  
ATOM   1066  CE2 PHE A 150       1.678   9.800  17.118  1.00 29.52           C  
ATOM   1067  CZ  PHE A 150       2.125  11.106  17.084  1.00 30.61           C  
ATOM   1068  N   VAL A 151      -3.521  13.002  16.674  1.00 22.22           N  
ATOM   1069  CA  VAL A 151      -3.294  14.438  16.555  1.00 21.73           C  
ATOM   1070  C   VAL A 151      -3.254  15.022  17.990  1.00 21.62           C  
ATOM   1071  O   VAL A 151      -4.155  14.735  18.797  1.00 23.51           O  
ATOM   1072  CB  VAL A 151      -4.403  15.166  15.696  1.00 20.83           C  
ATOM   1073  CG1 VAL A 151      -4.183  16.657  15.713  1.00 21.82           C  
ATOM   1074  CG2 VAL A 151      -4.465  14.656  14.240  1.00 20.31           C  
ATOM   1075  N   PHE A 152      -2.205  15.789  18.315  1.00 21.29           N  
ATOM   1076  CA  PHE A 152      -2.128  16.573  19.563  1.00 21.60           C  
ATOM   1077  C   PHE A 152      -2.034  18.068  19.259  1.00 22.43           C  
ATOM   1078  O   PHE A 152      -1.340  18.444  18.327  1.00 23.24           O  
ATOM   1079  CB  PHE A 152      -0.904  16.153  20.407  1.00 21.83           C  
ATOM   1080  CG  PHE A 152      -1.042  14.810  21.016  1.00 23.66           C  
ATOM   1081  CD1 PHE A 152      -0.806  13.685  20.269  1.00 24.91           C  
ATOM   1082  CD2 PHE A 152      -1.453  14.654  22.340  1.00 26.63           C  
ATOM   1083  CE1 PHE A 152      -0.965  12.422  20.807  1.00 26.65           C  
ATOM   1084  CE2 PHE A 152      -1.627  13.395  22.880  1.00 25.24           C  
ATOM   1085  CZ  PHE A 152      -1.387  12.269  22.097  1.00 25.31           C  
ATOM   1086  N   ALA A 153      -2.702  18.906  20.061  1.00 20.35           N  
ATOM   1087  CA  ALA A 153      -2.448  20.352  20.074  1.00 21.55           C  
ATOM   1088  C   ALA A 153      -1.406  20.665  21.156  1.00 24.90           C  
ATOM   1089  O   ALA A 153      -1.481  20.169  22.252  1.00 24.03           O  
ATOM   1090  CB  ALA A 153      -3.713  21.125  20.305  1.00 21.38           C  
ATOM   1091  N   VAL A 154      -0.418  21.483  20.803  1.00 25.13           N  
ATOM   1092  CA  VAL A 154       0.543  22.042  21.755  1.00 26.28           C  
ATOM   1093  C   VAL A 154       0.464  23.584  21.664  1.00 27.96           C  
ATOM   1094  O   VAL A 154       0.881  24.179  20.643  1.00 29.36           O  
ATOM   1095  CB  VAL A 154       1.959  21.574  21.407  1.00 23.91           C  
ATOM   1096  CG1 VAL A 154       2.925  21.949  22.528  1.00 28.55           C  
ATOM   1097  CG2 VAL A 154       2.005  20.088  21.144  1.00 25.33           C  
ATOM   1098  N   LYS A 155      -0.069  24.216  22.712  1.00 28.51           N  
ATOM   1099  CA  LYS A 155      -0.050  25.681  22.860  1.00 31.96           C  
ATOM   1100  C   LYS A 155       1.193  26.100  23.669  1.00 30.52           C  
ATOM   1101  O   LYS A 155       1.519  25.471  24.668  1.00 26.02           O  
ATOM   1102  CB  LYS A 155      -1.313  26.188  23.577  1.00 34.89           C  
ATOM   1103  CG  LYS A 155      -2.647  25.845  22.893  1.00 39.85           C  
ATOM   1104  CD  LYS A 155      -3.818  25.754  23.930  1.00 41.20           C  
ATOM   1105  CE  LYS A 155      -4.614  27.043  24.028  1.00 44.32           C  
ATOM   1106  NZ  LYS A 155      -4.954  27.508  22.635  1.00 46.41           N  
ATOM   1107  N   PRO A 156       1.918  27.140  23.220  1.00 29.84           N  
ATOM   1108  CA  PRO A 156       3.128  27.524  23.968  1.00 29.16           C  
ATOM   1109  C   PRO A 156       2.896  27.986  25.417  1.00 25.56           C  
ATOM   1110  O   PRO A 156       2.129  28.926  25.654  1.00 25.21           O  
ATOM   1111  CB  PRO A 156       3.732  28.659  23.116  1.00 27.98           C  
ATOM   1112  CG  PRO A 156       3.158  28.424  21.699  1.00 32.41           C  
ATOM   1113  CD  PRO A 156       1.743  27.942  21.989  1.00 31.62           C  
ATOM   1114  N   GLU A 157       3.553  27.343  26.369  1.00 23.99           N  
ATOM   1115  CA  GLU A 157       3.558  27.821  27.749  1.00 25.50           C  
ATOM   1116  C   GLU A 157       4.583  28.944  27.911  1.00 24.40           C  
ATOM   1117  O   GLU A 157       4.334  29.923  28.613  1.00 23.79           O  
ATOM   1118  CB  GLU A 157       3.877  26.681  28.703  1.00 28.27           C  
ATOM   1119  CG  GLU A 157       3.781  27.058  30.196  1.00 28.74           C  
ATOM   1120  CD  GLU A 157       3.808  25.814  31.110  1.00 34.45           C  
ATOM   1121  OE1 GLU A 157       2.949  24.922  30.879  1.00 34.73           O  
ATOM   1122  OE2 GLU A 157       4.660  25.742  32.041  1.00 33.63           O  
ATOM   1123  N   THR A 158       5.745  28.754  27.284  1.00 25.10           N  
ATOM   1124  CA  THR A 158       6.735  29.813  27.067  1.00 22.65           C  
ATOM   1125  C   THR A 158       7.434  29.546  25.729  1.00 25.25           C  
ATOM   1126  O   THR A 158       7.377  28.424  25.167  1.00 20.70           O  
ATOM   1127  CB  THR A 158       7.806  29.915  28.202  1.00 21.81           C  
ATOM   1128  OG1 THR A 158       8.584  28.715  28.229  1.00 29.44           O  
ATOM   1129  CG2 THR A 158       7.200  30.084  29.525  1.00 26.79           C  
ATOM   1130  N   PHE A 159       8.084  30.584  25.209  1.00 26.40           N  
ATOM   1131  CA  PHE A 159       8.932  30.444  24.060  1.00 25.94           C  
ATOM   1132  C   PHE A 159      10.000  31.569  23.979  1.00 26.65           C  
ATOM   1133  O   PHE A 159       9.847  32.659  24.537  1.00 23.73           O  
ATOM   1134  CB  PHE A 159       8.101  30.387  22.773  1.00 25.67           C  
ATOM   1135  CG  PHE A 159       7.488  31.714  22.394  1.00 21.89           C  
ATOM   1136  CD1 PHE A 159       6.255  32.094  22.887  1.00 31.36           C  
ATOM   1137  CD2 PHE A 159       8.187  32.597  21.554  1.00 30.13           C  
ATOM   1138  CE1 PHE A 159       5.732  33.321  22.551  1.00 25.37           C  
ATOM   1139  CE2 PHE A 159       7.659  33.822  21.220  1.00 27.90           C  
ATOM   1140  CZ  PHE A 159       6.425  34.168  21.720  1.00 20.46           C  
ATOM   1141  N   SER A 160      11.067  31.277  23.234  1.00 26.08           N  
ATOM   1142  CA  SER A 160      12.107  32.250  22.962  1.00 25.73           C  
ATOM   1143  C   SER A 160      12.670  32.010  21.565  1.00 27.43           C  
ATOM   1144  O   SER A 160      12.581  30.901  21.011  1.00 23.11           O  
ATOM   1145  CB  SER A 160      13.218  32.167  24.004  1.00 25.92           C  
ATOM   1146  OG  SER A 160      13.844  30.889  23.983  1.00 26.40           O  
HETATM 1147  N   MSE A 161      13.234  33.077  21.013  1.00 24.97           N  
HETATM 1148  CA  MSE A 161      13.827  33.076  19.697  1.00 25.51           C  
HETATM 1149  C   MSE A 161      15.151  33.818  19.690  1.00 25.36           C  
HETATM 1150  O   MSE A 161      15.372  34.712  20.485  1.00 23.35           O  
HETATM 1151  CB  MSE A 161      12.870  33.720  18.752  1.00 24.64           C  
HETATM 1152  CG  MSE A 161      11.666  32.806  18.401  1.00 34.28           C  
HETATM 1153 SE   MSE A 161      10.361  33.850  17.343  0.75 31.00          SE  
HETATM 1154  CE  MSE A 161      10.373  35.427  18.487  1.00 29.10           C  
ATOM   1155  N   LYS A 162      16.048  33.407  18.794  1.00 27.11           N  
ATOM   1156  CA  LYS A 162      17.363  34.013  18.668  1.00 26.05           C  
ATOM   1157  C   LYS A 162      17.677  34.041  17.175  1.00 25.82           C  
ATOM   1158  O   LYS A 162      17.168  33.187  16.428  1.00 22.34           O  
ATOM   1159  CB  LYS A 162      18.417  33.182  19.423  1.00 27.26           C  
ATOM   1160  CG  LYS A 162      19.701  33.908  19.717  1.00 37.28           C  
ATOM   1161  N   ALA A 163      18.470  35.020  16.746  1.00 23.96           N  
ATOM   1162  CA  ALA A 163      18.857  35.151  15.333  1.00 22.90           C  
ATOM   1163  C   ALA A 163      20.158  35.939  15.252  1.00 24.63           C  
ATOM   1164  O   ALA A 163      20.465  36.757  16.130  1.00 24.87           O  
ATOM   1165  CB  ALA A 163      17.757  35.871  14.516  1.00 26.27           C  
ATOM   1166  N   ARG A 164      20.918  35.650  14.218  1.00 24.10           N  
ATOM   1167  CA  ARG A 164      21.990  36.535  13.734  1.00 24.41           C  
ATOM   1168  C   ARG A 164      21.773  36.809  12.250  1.00 25.10           C  
ATOM   1169  O   ARG A 164      21.475  35.892  11.465  1.00 27.23           O  
ATOM   1170  CB  ARG A 164      23.343  35.883  13.895  1.00 25.00           C  
ATOM   1171  CG  ARG A 164      24.532  36.849  13.724  1.00 18.35           C  
ATOM   1172  CD  ARG A 164      25.795  36.183  13.284  1.00 26.61           C  
ATOM   1173  NE  ARG A 164      26.864  37.180  13.327  1.00 22.54           N  
ATOM   1174  CZ  ARG A 164      27.137  38.072  12.369  1.00 24.83           C  
ATOM   1175  NH1 ARG A 164      26.439  38.109  11.225  1.00 21.44           N  
ATOM   1176  NH2 ARG A 164      28.120  38.952  12.557  1.00 25.53           N  
ATOM   1177  N   THR A 165      21.914  38.079  11.901  1.00 27.18           N  
ATOM   1178  CA  THR A 165      21.843  38.574  10.544  1.00 27.23           C  
ATOM   1179  C   THR A 165      23.009  39.541  10.336  1.00 24.89           C  
ATOM   1180  O   THR A 165      23.597  40.048  11.312  1.00 25.00           O  
ATOM   1181  CB  THR A 165      20.506  39.326  10.269  1.00 28.08           C  
ATOM   1182  OG1 THR A 165      20.415  40.490  11.109  1.00 34.46           O  
ATOM   1183  CG2 THR A 165      19.326  38.457  10.554  1.00 29.21           C  
ATOM   1184  N   GLY A 166      23.284  39.787   9.060  1.00 26.07           N  
ATOM   1185  CA  GLY A 166      24.216  40.783   8.611  1.00 27.08           C  
ATOM   1186  C   GLY A 166      25.661  40.336   8.483  1.00 24.30           C  
ATOM   1187  O   GLY A 166      25.976  39.131   8.598  1.00 26.54           O  
ATOM   1188  N   PRO A 167      26.544  41.309   8.217  1.00 26.88           N  
ATOM   1189  CA  PRO A 167      27.948  41.113   7.953  1.00 28.39           C  
ATOM   1190  C   PRO A 167      28.747  40.711   9.187  1.00 25.98           C  
ATOM   1191  O   PRO A 167      28.266  40.792  10.316  1.00 26.04           O  
ATOM   1192  CB  PRO A 167      28.400  42.479   7.420  1.00 29.40           C  
ATOM   1193  CG  PRO A 167      27.490  43.433   8.007  1.00 29.07           C  
ATOM   1194  CD  PRO A 167      26.177  42.735   8.112  1.00 27.64           C  
ATOM   1195  N   PRO A 168      29.972  40.259   8.963  1.00 26.61           N  
ATOM   1196  CA  PRO A 168      30.893  40.030  10.064  1.00 26.18           C  
ATOM   1197  C   PRO A 168      31.302  41.317  10.769  1.00 27.94           C  
ATOM   1198  O   PRO A 168      31.152  42.406  10.220  1.00 30.84           O  
ATOM   1199  CB  PRO A 168      32.108  39.387   9.388  1.00 25.84           C  
ATOM   1200  CG  PRO A 168      32.021  39.710   8.005  1.00 26.24           C  
ATOM   1201  CD  PRO A 168      30.555  39.893   7.658  1.00 24.12           C  
ATOM   1202  N   HIS A 169      31.806  41.150  11.983  1.00 31.32           N  
ATOM   1203  CA  HIS A 169      32.339  42.227  12.809  1.00 34.33           C  
ATOM   1204  C   HIS A 169      33.826  42.063  12.846  1.00 33.50           C  
ATOM   1205  O   HIS A 169      34.313  40.949  13.060  1.00 32.67           O  
ATOM   1206  CB  HIS A 169      31.836  42.107  14.236  1.00 38.94           C  
ATOM   1207  CG  HIS A 169      30.364  42.327  14.374  1.00 47.53           C  
ATOM   1208  ND1 HIS A 169      29.668  43.185  13.547  1.00 51.01           N  
ATOM   1209  CD2 HIS A 169      29.459  41.799  15.229  1.00 58.69           C  
ATOM   1210  CE1 HIS A 169      28.392  43.168  13.888  1.00 66.55           C  
ATOM   1211  NE2 HIS A 169      28.238  42.339  14.907  1.00 67.15           N  
ATOM   1212  N   ASP A 170      34.549  43.153  12.620  1.00 29.79           N  
ATOM   1213  CA  ASP A 170      36.024  43.120  12.649  1.00 30.10           C  
ATOM   1214  C   ASP A 170      36.595  44.441  13.134  1.00 26.74           C  
ATOM   1215  O   ASP A 170      35.973  45.482  13.019  1.00 31.13           O  
ATOM   1216  CB  ASP A 170      36.621  42.774  11.263  1.00 30.47           C  
ATOM   1217  CG  ASP A 170      36.626  41.256  10.965  1.00 28.28           C  
ATOM   1218  OD1 ASP A 170      37.197  40.434  11.744  1.00 30.25           O  
ATOM   1219  OD2 ASP A 170      36.016  40.892   9.949  1.00 25.77           O  
ATOM   1220  N   THR A 171      37.800  44.394  13.666  1.00 27.12           N  
ATOM   1221  CA  THR A 171      38.570  45.609  13.908  1.00 25.92           C  
ATOM   1222  C   THR A 171      39.862  45.679  13.046  1.00 26.03           C  
ATOM   1223  O   THR A 171      40.380  46.738  12.843  1.00 25.64           O  
ATOM   1224  CB  THR A 171      38.912  45.759  15.407  1.00 28.16           C  
ATOM   1225  OG1 THR A 171      39.839  44.748  15.794  1.00 28.71           O  
ATOM   1226  CG2 THR A 171      37.678  45.641  16.208  1.00 19.90           C  
ATOM   1227  N   SER A 172      40.333  44.556  12.505  1.00 24.73           N  
ATOM   1228  CA  SER A 172      41.588  44.525  11.780  1.00 23.31           C  
ATOM   1229  C   SER A 172      41.539  45.276  10.473  1.00 25.17           C  
ATOM   1230  O   SER A 172      40.536  45.215   9.763  1.00 24.70           O  
ATOM   1231  CB  SER A 172      41.989  43.079  11.453  1.00 24.50           C  
ATOM   1232  OG  SER A 172      43.191  43.033  10.704  1.00 27.82           O  
ATOM   1233  N   THR A 173      42.673  45.913  10.142  1.00 25.28           N  
ATOM   1234  CA  THR A 173      42.884  46.545   8.856  1.00 29.32           C  
ATOM   1235  C   THR A 173      43.460  45.601   7.784  1.00 28.35           C  
ATOM   1236  O   THR A 173      43.586  46.018   6.643  1.00 28.01           O  
ATOM   1237  CB  THR A 173      43.872  47.746   9.007  1.00 30.56           C  
ATOM   1238  OG1 THR A 173      45.113  47.252   9.547  1.00 31.54           O  
ATOM   1239  CG2 THR A 173      43.268  48.790   9.936  1.00 31.17           C  
ATOM   1240  N   ASP A 174      43.805  44.358   8.138  1.00 27.40           N  
ATOM   1241  CA  ASP A 174      44.475  43.433   7.210  1.00 30.37           C  
ATOM   1242  C   ASP A 174      43.693  43.211   5.929  1.00 29.42           C  
ATOM   1243  O   ASP A 174      42.469  43.189   5.947  1.00 27.34           O  
ATOM   1244  CB  ASP A 174      44.696  42.066   7.833  1.00 30.50           C  
ATOM   1245  CG  ASP A 174      45.719  42.077   8.971  1.00 40.55           C  
ATOM   1246  OD1 ASP A 174      46.370  43.122   9.206  1.00 41.64           O  
ATOM   1247  OD2 ASP A 174      45.863  41.012   9.625  1.00 45.36           O  
ATOM   1248  N   ASP A 175      44.428  42.995   4.835  1.00 27.09           N  
ATOM   1249  CA  ASP A 175      43.847  42.765   3.504  1.00 27.04           C  
ATOM   1250  C   ASP A 175      43.353  41.312   3.421  1.00 26.15           C  
ATOM   1251  O   ASP A 175      44.003  40.450   2.853  1.00 28.84           O  
ATOM   1252  CB  ASP A 175      44.898  43.055   2.429  1.00 27.04           C  
ATOM   1253  CG  ASP A 175      44.338  43.009   1.037  1.00 28.90           C  
ATOM   1254  OD1 ASP A 175      43.107  43.100   0.870  1.00 31.42           O  
ATOM   1255  OD2 ASP A 175      45.142  42.886   0.108  1.00 26.70           O  
ATOM   1256  N   ILE A 176      42.230  41.048   4.077  1.00 23.00           N  
ATOM   1257  CA  ILE A 176      41.608  39.730   4.114  1.00 25.39           C  
ATOM   1258  C   ILE A 176      40.156  39.928   3.727  1.00 24.45           C  
ATOM   1259  O   ILE A 176      39.476  40.809   4.272  1.00 23.09           O  
ATOM   1260  CB  ILE A 176      41.688  39.045   5.517  1.00 24.78           C  
ATOM   1261  CG1 ILE A 176      43.132  38.878   5.943  1.00 23.20           C  
ATOM   1262  CG2 ILE A 176      40.950  37.700   5.450  1.00 21.84           C  
ATOM   1263  CD1 ILE A 176      43.386  38.741   7.437  1.00 26.37           C  
ATOM   1264  N   TRP A 177      39.696  39.184   2.717  1.00 26.26           N  
ATOM   1265  CA  TRP A 177      38.309  39.325   2.267  1.00 23.55           C  
ATOM   1266  C   TRP A 177      37.376  38.902   3.390  1.00 22.40           C  
ATOM   1267  O   TRP A 177      37.657  37.991   4.116  1.00 19.63           O  
ATOM   1268  CB  TRP A 177      38.067  38.517   0.975  1.00 24.57           C  
ATOM   1269  CG  TRP A 177      36.659  38.600   0.452  1.00 22.60           C  
ATOM   1270  CD1 TRP A 177      36.180  39.461  -0.491  1.00 27.05           C  
ATOM   1271  CD2 TRP A 177      35.557  37.795   0.849  1.00 25.93           C  
ATOM   1272  NE1 TRP A 177      34.853  39.236  -0.707  1.00 24.31           N  
ATOM   1273  CE2 TRP A 177      34.442  38.217   0.107  1.00 27.82           C  
ATOM   1274  CE3 TRP A 177      35.403  36.742   1.745  1.00 24.81           C  
ATOM   1275  CZ2 TRP A 177      33.191  37.636   0.258  1.00 30.33           C  
ATOM   1276  CZ3 TRP A 177      34.167  36.180   1.886  1.00 26.76           C  
ATOM   1277  CH2 TRP A 177      33.084  36.622   1.154  1.00 24.70           C  
ATOM   1278  N   SER A 178      36.283  39.612   3.586  1.00 21.97           N  
ATOM   1279  CA  SER A 178      35.324  39.233   4.613  1.00 21.42           C  
ATOM   1280  C   SER A 178      33.942  39.430   4.047  1.00 23.84           C  
ATOM   1281  O   SER A 178      33.766  40.232   3.134  1.00 23.45           O  
ATOM   1282  CB  SER A 178      35.546  40.007   5.903  1.00 21.88           C  
ATOM   1283  OG  SER A 178      35.186  41.361   5.793  1.00 26.15           O  
ATOM   1284  N   GLY A 179      32.973  38.659   4.519  1.00 23.51           N  
ATOM   1285  CA  GLY A 179      31.653  38.732   3.935  1.00 25.54           C  
ATOM   1286  C   GLY A 179      30.773  37.586   4.378  1.00 25.51           C  
ATOM   1287  O   GLY A 179      31.167  36.811   5.215  1.00 23.60           O  
ATOM   1288  N   VAL A 180      29.581  37.484   3.780  1.00 25.07           N  
ATOM   1289  CA  VAL A 180      28.606  36.402   4.101  1.00 25.61           C  
ATOM   1290  C   VAL A 180      28.394  35.541   2.866  1.00 25.35           C  
ATOM   1291  O   VAL A 180      28.201  36.064   1.772  1.00 26.19           O  
ATOM   1292  CB  VAL A 180      27.265  36.959   4.581  1.00 23.94           C  
ATOM   1293  CG1 VAL A 180      26.309  35.825   4.942  1.00 26.31           C  
ATOM   1294  CG2 VAL A 180      27.460  37.915   5.765  1.00 25.94           C  
ATOM   1295  N   LEU A 181      28.558  34.238   3.016  1.00 24.38           N  
ATOM   1296  CA  LEU A 181      28.197  33.291   1.961  1.00 26.37           C  
ATOM   1297  C   LEU A 181      26.745  32.886   2.211  1.00 24.55           C  
ATOM   1298  O   LEU A 181      26.488  32.167   3.145  1.00 27.06           O  
ATOM   1299  CB  LEU A 181      29.105  32.053   1.991  1.00 25.04           C  
ATOM   1300  CG  LEU A 181      30.525  32.064   1.460  1.00 37.33           C  
ATOM   1301  CD1 LEU A 181      31.370  33.056   2.237  1.00 40.95           C  
ATOM   1302  CD2 LEU A 181      31.072  30.629   1.560  1.00 27.94           C  
ATOM   1303  N   PRO A 182      25.793  33.396   1.410  1.00 26.43           N  
ATOM   1304  CA  PRO A 182      24.374  33.110   1.612  1.00 27.18           C  
ATOM   1305  C   PRO A 182      24.115  31.645   1.353  1.00 26.46           C  
ATOM   1306  O   PRO A 182      24.695  31.101   0.429  1.00 23.69           O  
ATOM   1307  CB  PRO A 182      23.688  33.893   0.505  1.00 26.64           C  
ATOM   1308  CG  PRO A 182      24.692  34.815  -0.037  1.00 30.40           C  
ATOM   1309  CD  PRO A 182      26.022  34.195   0.207  1.00 28.18           C  
ATOM   1310  N   ILE A 183      23.225  31.032   2.119  1.00 27.43           N  
ATOM   1311  CA  ILE A 183      22.720  29.682   1.828  1.00 28.62           C  
ATOM   1312  C   ILE A 183      21.231  29.817   1.492  1.00 27.72           C  
ATOM   1313  O   ILE A 183      20.479  30.368   2.269  1.00 29.89           O  
ATOM   1314  CB  ILE A 183      22.936  28.739   3.012  1.00 27.28           C  
ATOM   1315  CG1 ILE A 183      24.420  28.448   3.232  1.00 31.54           C  
ATOM   1316  CG2 ILE A 183      22.244  27.414   2.805  1.00 28.34           C  
ATOM   1317  CD1 ILE A 183      24.711  28.041   4.640  1.00 23.87           C  
ATOM   1318  N   GLN A 184      20.858  29.348   0.302  1.00 28.90           N  
ATOM   1319  CA  GLN A 184      19.492  29.423  -0.241  1.00 29.94           C  
ATOM   1320  C   GLN A 184      18.844  28.028  -0.221  1.00 27.57           C  
ATOM   1321  O   GLN A 184      19.510  26.997  -0.478  1.00 28.54           O  
ATOM   1322  CB  GLN A 184      19.489  30.013  -1.655  0.50 29.61           C  
ATOM   1324  CG  GLN A 184      19.828  31.502  -1.719  0.50 32.70           C  
ATOM   1326  CD  GLN A 184      19.801  32.061  -3.134  0.50 35.22           C  
ATOM   1328  OE1 GLN A 184      20.027  31.337  -4.107  0.50 40.92           O  
ATOM   1330  NE2 GLN A 184      19.533  33.362  -3.257  0.50 36.51           N  
ATOM   1332  N   HIS A 185      17.566  27.996   0.147  1.00 26.99           N  
ATOM   1333  CA  HIS A 185      16.781  26.779   0.173  1.00 22.99           C  
ATOM   1334  C   HIS A 185      15.670  27.001  -0.852  1.00 26.99           C  
ATOM   1335  O   HIS A 185      14.902  27.941  -0.737  1.00 27.52           O  
ATOM   1336  CB  HIS A 185      16.220  26.482   1.555  1.00 24.66           C  
ATOM   1337  CG  HIS A 185      17.177  26.748   2.668  1.00 25.12           C  
ATOM   1338  ND1 HIS A 185      18.177  25.861   3.015  1.00 24.27           N  
ATOM   1339  CD2 HIS A 185      17.299  27.801   3.506  1.00 26.26           C  
ATOM   1340  CE1 HIS A 185      18.848  26.351   4.046  1.00 18.89           C  
ATOM   1341  NE2 HIS A 185      18.361  27.544   4.332  1.00 27.77           N  
ATOM   1342  N   THR A 186      15.677  26.186  -1.907  1.00 26.44           N  
ATOM   1343  CA  THR A 186      14.847  26.421  -3.081  1.00 27.63           C  
ATOM   1344  C   THR A 186      14.077  25.153  -3.461  1.00 30.34           C  
ATOM   1345  O   THR A 186      14.637  24.080  -3.432  1.00 31.17           O  
ATOM   1346  CB  THR A 186      15.641  26.961  -4.273  0.50 26.53           C  
ATOM   1348  OG1 THR A 186      14.726  27.362  -5.302  0.50 35.41           O  
ATOM   1350  CG2 THR A 186      16.601  25.945  -4.812  0.50 20.20           C  
ATOM   1352  N   ILE A 187      12.816  25.301  -3.871  1.00 30.90           N  
ATOM   1353  CA  ILE A 187      12.098  24.169  -4.478  1.00 30.57           C  
ATOM   1354  C   ILE A 187      12.489  24.130  -5.947  1.00 30.91           C  
ATOM   1355  O   ILE A 187      12.406  25.132  -6.625  1.00 28.91           O  
ATOM   1356  CB  ILE A 187      10.557  24.262  -4.298  1.00 29.05           C  
ATOM   1357  CG1 ILE A 187      10.198  24.135  -2.815  1.00 26.28           C  
ATOM   1358  CG2 ILE A 187       9.853  23.139  -5.139  1.00 31.24           C  
ATOM   1359  CD1 ILE A 187       8.732  24.335  -2.451  1.00 31.45           C  
ATOM   1360  N   SER A 188      12.967  22.985  -6.426  1.00 29.15           N  
ATOM   1361  CA  SER A 188      13.269  22.826  -7.833  1.00 30.02           C  
ATOM   1362  C   SER A 188      12.136  22.085  -8.650  1.00 29.98           C  
ATOM   1363  O   SER A 188      11.164  21.579  -8.085  1.00 29.76           O  
ATOM   1364  CB  SER A 188      14.644  22.176  -7.994  1.00 29.56           C  
ATOM   1365  OG  SER A 188      14.671  20.818  -7.670  1.00 34.01           O  
ATOM   1366  N   GLU A 189      12.300  22.025  -9.966  1.00 27.92           N  
ATOM   1367  CA  GLU A 189      11.278  21.545 -10.879  1.00 28.19           C  
ATOM   1368  C   GLU A 189      10.987  20.046 -10.691  1.00 29.64           C  
ATOM   1369  O   GLU A 189      11.909  19.226 -10.498  1.00 28.53           O  
ATOM   1370  CB  GLU A 189      11.686  21.865 -12.330  1.00 30.46           C  
ATOM   1371  CG  GLU A 189      12.620  20.848 -13.013  1.00 34.25           C  
ATOM   1372  N   ALA A 190       9.696  19.701 -10.717  1.00 30.04           N  
ATOM   1373  CA  ALA A 190       9.232  18.344 -10.569  1.00 29.28           C  
ATOM   1374  C   ALA A 190       8.585  17.828 -11.852  1.00 31.96           C  
ATOM   1375  O   ALA A 190       7.942  16.796 -11.827  1.00 31.40           O  
ATOM   1376  CB  ALA A 190       8.236  18.262  -9.411  1.00 30.49           C  
ATOM   1377  N   GLY A 191       8.735  18.562 -12.961  1.00 32.78           N  
ATOM   1378  CA  GLY A 191       8.164  18.192 -14.261  1.00 32.00           C  
ATOM   1379  C   GLY A 191       7.129  19.163 -14.795  1.00 31.78           C  
ATOM   1380  O   GLY A 191       6.378  19.803 -14.044  1.00 32.64           O  
ATOM   1381  N   GLU A 192       7.062  19.231 -16.113  1.00 34.74           N  
ATOM   1382  CA  GLU A 192       6.133  20.115 -16.822  1.00 34.10           C  
ATOM   1383  C   GLU A 192       4.689  19.621 -16.800  1.00 34.43           C  
ATOM   1384  O   GLU A 192       3.793  20.397 -17.084  1.00 34.39           O  
ATOM   1385  CB  GLU A 192       6.590  20.333 -18.274  1.00 35.47           C  
ATOM   1386  N   ASN A 193       4.422  18.362 -16.459  1.00 33.52           N  
ATOM   1387  CA  ASN A 193       3.022  17.936 -16.426  1.00 35.57           C  
ATOM   1388  C   ASN A 193       2.329  18.138 -15.078  1.00 32.44           C  
ATOM   1389  O   ASN A 193       1.172  17.819 -14.967  1.00 33.10           O  
ATOM   1390  CB  ASN A 193       2.821  16.509 -16.959  1.00 39.26           C  
ATOM   1391  CG  ASN A 193       3.148  16.388 -18.453  1.00 47.42           C  
ATOM   1392  OD1 ASN A 193       2.677  17.184 -19.285  1.00 59.50           O  
ATOM   1393  ND2 ASN A 193       3.977  15.404 -18.795  1.00 56.44           N  
ATOM   1394  N   ALA A 194       3.035  18.696 -14.086  1.00 31.92           N  
ATOM   1395  CA  ALA A 194       2.464  19.042 -12.778  1.00 29.80           C  
ATOM   1396  C   ALA A 194       1.367  20.115 -12.903  1.00 29.30           C  
ATOM   1397  O   ALA A 194       1.383  20.928 -13.824  1.00 28.27           O  
ATOM   1398  CB  ALA A 194       3.600  19.515 -11.816  1.00 28.17           C  
ATOM   1399  N   PRO A 195       0.348  20.088 -12.025  1.00 28.97           N  
ATOM   1400  CA  PRO A 195      -0.652  21.172 -12.094  1.00 25.49           C  
ATOM   1401  C   PRO A 195      -0.039  22.540 -11.756  1.00 24.13           C  
ATOM   1402  O   PRO A 195       0.999  22.604 -11.141  1.00 21.60           O  
ATOM   1403  CB  PRO A 195      -1.680  20.787 -11.039  1.00 25.67           C  
ATOM   1404  CG  PRO A 195      -1.003  19.788 -10.179  1.00 29.30           C  
ATOM   1405  CD  PRO A 195       0.008  19.091 -11.003  1.00 27.69           C  
ATOM   1406  N   GLU A 196      -0.716  23.607 -12.142  1.00 24.75           N  
ATOM   1407  CA  GLU A 196      -0.159  24.947 -11.985  1.00 26.05           C  
ATOM   1408  C   GLU A 196       0.145  25.304 -10.532  1.00 25.45           C  
ATOM   1409  O   GLU A 196       1.115  25.996 -10.265  1.00 18.63           O  
ATOM   1410  CB  GLU A 196      -1.079  26.017 -12.628  1.00 27.95           C  
ATOM   1411  CG  GLU A 196      -0.348  27.064 -13.563  1.00 44.40           C  
ATOM   1412  CD  GLU A 196       1.045  27.573 -13.073  1.00 51.08           C  
ATOM   1413  OE1 GLU A 196       1.184  28.295 -12.041  1.00 43.86           O  
ATOM   1414  OE2 GLU A 196       2.029  27.283 -13.787  1.00 66.89           O  
ATOM   1415  N   TYR A 197      -0.676  24.865  -9.576  1.00 24.18           N  
ATOM   1416  CA  TYR A 197      -0.368  25.139  -8.155  1.00 23.59           C  
ATOM   1417  C   TYR A 197       0.957  24.521  -7.696  1.00 23.47           C  
ATOM   1418  O   TYR A 197       1.616  25.043  -6.780  1.00 22.50           O  
ATOM   1419  CB  TYR A 197      -1.510  24.707  -7.209  1.00 25.24           C  
ATOM   1420  CG  TYR A 197      -1.774  23.207  -7.103  1.00 22.07           C  
ATOM   1421  CD1 TYR A 197      -1.059  22.413  -6.228  1.00 24.61           C  
ATOM   1422  CD2 TYR A 197      -2.776  22.609  -7.850  1.00 26.53           C  
ATOM   1423  CE1 TYR A 197      -1.328  21.066  -6.100  1.00 24.46           C  
ATOM   1424  CE2 TYR A 197      -3.061  21.250  -7.751  1.00 24.63           C  
ATOM   1425  CZ  TYR A 197      -2.325  20.464  -6.881  1.00 20.44           C  
ATOM   1426  OH  TYR A 197      -2.575  19.100  -6.745  1.00 28.56           O  
ATOM   1427  N   VAL A 198       1.362  23.415  -8.308  1.00 24.60           N  
ATOM   1428  CA  VAL A 198       2.666  22.843  -8.038  1.00 21.33           C  
ATOM   1429  C   VAL A 198       3.743  23.622  -8.782  1.00 23.10           C  
ATOM   1430  O   VAL A 198       4.740  24.027  -8.187  1.00 25.35           O  
ATOM   1431  CB  VAL A 198       2.732  21.311  -8.392  1.00 25.93           C  
ATOM   1432  CG1 VAL A 198       4.150  20.873  -8.460  1.00 21.70           C  
ATOM   1433  CG2 VAL A 198       1.958  20.479  -7.353  1.00 29.30           C  
ATOM   1434  N   LYS A 199       3.527  23.903 -10.070  1.00 22.44           N  
ATOM   1435  CA  LYS A 199       4.544  24.596 -10.852  1.00 24.92           C  
ATOM   1436  C   LYS A 199       4.827  26.010 -10.349  1.00 24.13           C  
ATOM   1437  O   LYS A 199       5.921  26.507 -10.518  1.00 24.78           O  
ATOM   1438  CB  LYS A 199       4.161  24.656 -12.304  1.00 25.32           C  
ATOM   1439  CG  LYS A 199       4.012  23.324 -13.009  1.00 24.73           C  
ATOM   1440  CD  LYS A 199       3.447  23.567 -14.355  1.00 33.19           C  
ATOM   1441  CE  LYS A 199       3.866  22.512 -15.286  1.00 42.50           C  
ATOM   1442  NZ  LYS A 199       3.376  22.850 -16.663  1.00 45.37           N  
ATOM   1443  N   SER A 200       3.869  26.622  -9.658  1.00 26.56           N  
ATOM   1444  CA  SER A 200       4.087  27.944  -9.077  1.00 26.98           C  
ATOM   1445  C   SER A 200       5.170  27.941  -7.980  1.00 28.50           C  
ATOM   1446  O   SER A 200       5.598  29.004  -7.552  1.00 28.87           O  
ATOM   1447  CB  SER A 200       2.771  28.506  -8.514  1.00 29.79           C  
ATOM   1448  OG  SER A 200       2.425  27.869  -7.285  1.00 36.28           O  
ATOM   1449  N   LEU A 201       5.605  26.760  -7.525  1.00 27.85           N  
ATOM   1450  CA  LEU A 201       6.634  26.632  -6.511  1.00 26.97           C  
ATOM   1451  C   LEU A 201       8.058  26.377  -7.065  1.00 30.05           C  
ATOM   1452  O   LEU A 201       9.045  26.514  -6.340  1.00 27.04           O  
ATOM   1453  CB  LEU A 201       6.267  25.496  -5.538  1.00 26.69           C  
ATOM   1454  CG  LEU A 201       5.031  25.665  -4.635  1.00 26.83           C  
ATOM   1455  CD1 LEU A 201       4.785  24.424  -3.845  1.00 30.85           C  
ATOM   1456  CD2 LEU A 201       5.176  26.894  -3.700  1.00 29.96           C  
ATOM   1457  N   TYR A 202       8.146  25.983  -8.325  1.00 28.55           N  
ATOM   1458  CA  TYR A 202       9.421  25.808  -9.006  1.00 28.58           C  
ATOM   1459  C   TYR A 202      10.282  27.080  -8.938  1.00 30.51           C  
ATOM   1460  O   TYR A 202       9.868  28.161  -9.361  1.00 30.48           O  
ATOM   1461  CB  TYR A 202       9.160  25.458 -10.454  1.00 28.90           C  
ATOM   1462  CG  TYR A 202       8.469  24.128 -10.711  1.00 31.13           C  
ATOM   1463  CD1 TYR A 202       8.018  23.311  -9.678  1.00 25.58           C  
ATOM   1464  CD2 TYR A 202       8.235  23.706 -12.007  1.00 23.57           C  
ATOM   1465  CE1 TYR A 202       7.399  22.110  -9.942  1.00 22.99           C  
ATOM   1466  CE2 TYR A 202       7.623  22.510 -12.265  1.00 29.23           C  
ATOM   1467  CZ  TYR A 202       7.205  21.725 -11.230  1.00 23.93           C  
ATOM   1468  OH  TYR A 202       6.609  20.522 -11.460  1.00 28.10           O  
ATOM   1469  N   GLY A 203      11.461  26.954  -8.356  1.00 30.75           N  
ATOM   1470  CA  GLY A 203      12.345  28.086  -8.127  1.00 30.64           C  
ATOM   1471  C   GLY A 203      12.121  28.906  -6.863  1.00 34.11           C  
ATOM   1472  O   GLY A 203      12.901  29.816  -6.578  1.00 34.51           O  
ATOM   1473  N   LYS A 204      11.080  28.608  -6.089  1.00 31.82           N  
ATOM   1474  CA  LYS A 204      10.768  29.424  -4.937  1.00 33.44           C  
ATOM   1475  C   LYS A 204      11.762  29.171  -3.824  1.00 31.16           C  
ATOM   1476  O   LYS A 204      12.055  28.015  -3.520  1.00 30.33           O  
ATOM   1477  CB  LYS A 204       9.386  29.103  -4.401  1.00 31.90           C  
ATOM   1478  CG  LYS A 204       8.883  30.086  -3.369  1.00 38.95           C  
ATOM   1479  CD  LYS A 204       7.666  29.518  -2.644  1.00 40.62           C  
ATOM   1480  CE  LYS A 204       7.336  30.341  -1.406  1.00 52.73           C  
ATOM   1481  NZ  LYS A 204       6.211  29.762  -0.621  1.00 48.69           N  
ATOM   1482  N   ARG A 205      12.274  30.250  -3.223  1.00 30.92           N  
ATOM   1483  CA  ARG A 205      13.105  30.102  -2.039  1.00 34.48           C  
ATOM   1484  C   ARG A 205      12.234  30.121  -0.781  1.00 31.76           C  
ATOM   1485  O   ARG A 205      11.290  30.910  -0.660  1.00 31.52           O  
ATOM   1486  CB  ARG A 205      14.318  31.053  -2.014  1.00 36.54           C  
ATOM   1487  CG  ARG A 205      14.077  32.504  -1.918  1.00 52.35           C  
ATOM   1488  CD  ARG A 205      15.438  33.301  -1.781  1.00 45.50           C  
ATOM   1489  NE  ARG A 205      16.244  32.928  -0.584  1.00 55.28           N  
ATOM   1490  CZ  ARG A 205      17.010  33.775   0.133  1.00 58.14           C  
ATOM   1491  NH1 ARG A 205      17.100  35.063  -0.190  1.00 62.39           N  
ATOM   1492  NH2 ARG A 205      17.701  33.340   1.193  1.00 53.89           N  
ATOM   1493  N   ILE A 206      12.514  29.157   0.092  1.00 29.29           N  
ATOM   1494  CA  ILE A 206      11.699  28.865   1.229  1.00 30.02           C  
ATOM   1495  C   ILE A 206      12.527  29.003   2.530  1.00 29.59           C  
ATOM   1496  O   ILE A 206      13.739  29.289   2.514  1.00 25.66           O  
ATOM   1497  CB  ILE A 206      10.985  27.477   1.048  1.00 27.65           C  
ATOM   1498  CG1 ILE A 206      12.000  26.309   1.007  1.00 26.51           C  
ATOM   1499  CG2 ILE A 206      10.055  27.526  -0.186  1.00 26.03           C  
ATOM   1500  CD1 ILE A 206      11.411  24.879   0.881  1.00 30.29           C  
ATOM   1501  N   PHE A 207      11.837  28.817   3.643  1.00 30.12           N  
ATOM   1502  CA  PHE A 207      12.402  28.914   5.000  1.00 30.24           C  
ATOM   1503  C   PHE A 207      12.934  30.316   5.275  1.00 31.72           C  
ATOM   1504  O   PHE A 207      13.874  30.489   6.077  1.00 32.75           O  
ATOM   1505  CB  PHE A 207      13.510  27.861   5.260  1.00 31.51           C  
ATOM   1506  CG  PHE A 207      13.109  26.435   4.950  1.00 30.99           C  
ATOM   1507  CD1 PHE A 207      11.837  25.958   5.260  1.00 37.40           C  
ATOM   1508  CD2 PHE A 207      14.046  25.547   4.395  1.00 35.49           C  
ATOM   1509  CE1 PHE A 207      11.487  24.614   4.969  1.00 31.24           C  
ATOM   1510  CE2 PHE A 207      13.729  24.203   4.123  1.00 31.12           C  
ATOM   1511  CZ  PHE A 207      12.444  23.740   4.422  1.00 30.51           C  
ATOM   1512  N   ILE A 208      12.304  31.307   4.635  1.00 32.71           N  
ATOM   1513  CA  ILE A 208      12.651  32.716   4.831  1.00 34.11           C  
ATOM   1514  C   ILE A 208      11.404  33.594   4.922  1.00 34.19           C  
ATOM   1515  O   ILE A 208      10.324  33.187   4.500  1.00 38.43           O  
ATOM   1516  CB  ILE A 208      13.582  33.281   3.710  1.00 33.02           C  
ATOM   1517  CG1 ILE A 208      12.995  32.989   2.325  1.00 39.34           C  
ATOM   1518  CG2 ILE A 208      14.994  32.726   3.827  1.00 32.65           C  
ATOM   1519  CD1 ILE A 208      13.646  33.830   1.264  1.00 37.29           C  
ATOM   1520  OXT ILE A 208      11.477  34.706   5.442  1.00 32.65           O  
TER    1521      ILE A 208                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
