
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  129 ( 1031),  selected  129 , name 2okf_A
# Molecule2: number of CA atoms  139 ( 1110),  selected  139 , name T0495_5_143.pdb
# PARAMETERS: 2okf_A.T0495_5_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L       5           -
LGA    -       -      D       6           -
LGA    -       -      L       7           -
LGA    -       -      Q       8           -
LGA    -       -      P       9           -
LGA    R     4_A      G      10          2.757
LGA    D     5_A      Q      11          2.192
LGA    V     6_A      R      12          2.250
LGA    F     7_A      L      13          2.242
LGA    H     8_A      A      14          1.888
LGA    E     9_A      R      15          1.501
LGA    V    10_A      G      16          1.936
LGA    V    11_A      V      17          1.566
LGA    K    12_A      A      18          1.087
LGA    T    13_A      R      19          1.422
LGA    A    14_A      H      20          2.056
LGA    L    15_A      L      21          1.670
LGA    K    16_A      R      22          1.391
LGA    K    17_A      A      23          1.994
LGA    D    18_A      H      24          2.424
LGA    G    19_A      G      25          2.292
LGA    W    20_A      F      26          1.403
LGA    Q    21_A      V      27          1.596
LGA    I    22_A      S      28          1.769
LGA    T    23_A      -       -           -
LGA    D    24_A      V      29          3.535
LGA    D    25_A      E      30          2.657
LGA    P    26_A      E      31          2.551
LGA    L    27_A      F      32          1.777
LGA    T    28_A      V      33          0.500
LGA    I    29_A      P      34          2.268
LGA    S    30_A      A      35          1.850
LGA    V    31_A      -       -           -
LGA    G    32_A      -       -           -
LGA    G    33_A      R      36           #
LGA    V    34_A      G      37          3.863
LGA    N    35_A      L      38          4.869
LGA    L    36_A      R      39          4.551
LGA    K    44_A      V      40          4.525
LGA    L    45_A      D      41          2.477
LGA    I    46_A      V      42          1.612
LGA    A    47_A      M      43          1.564
LGA    A    48_A      G      44          1.340
LGA    E    49_A      L      45          2.116
LGA    R    50_A      G      46          2.151
LGA    Q    51_A      P      47          3.382
LGA    G    52_A      K      48          1.805
LGA    -       -      G      49           -
LGA    Q    53_A      E      50          2.275
LGA    K    54_A      I      51          1.850
LGA    I    55_A      W      52          0.856
LGA    A    56_A      V      53          1.315
LGA    V    57_A      I      54          1.152
LGA    E    58_A      E      55          1.102
LGA    V    59_A      C      56          1.259
LGA    K    60_A      K      57          1.424
LGA    S    61_A      S      58          1.798
LGA    F    62_A      S      59          1.988
LGA    L    63_A      -       -           -
LGA    K    64_A      -       -           -
LGA    Q    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    A    68_A      -       -           -
LGA    I    69_A      R      60          4.379
LGA    S    70_A      A      61          3.130
LGA    E    71_A      D      62          3.092
LGA    F    72_A      F      63          2.736
LGA    H    73_A      Q      64          1.693
LGA    T    74_A      A      65          1.451
LGA    A    75_A      D      66          3.028
LGA    L    76_A      A      67          3.867
LGA    G    77_A      -       -           -
LGA    Q    78_A      K      68          4.170
LGA    F    79_A      W      69          1.691
LGA    I    80_A      Q      70          1.814
LGA    N    81_A      G      71          2.617
LGA    Y    82_A      Y      72          2.078
LGA    R    83_A      L      73          2.259
LGA    G    84_A      -       -           -
LGA    A    85_A      -       -           -
LGA    L    86_A      -       -           -
LGA    R    87_A      E      74          1.678
LGA    K    88_A      W      75           #
LGA    V    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    P    91_A      -       -           -
LGA    D    92_A      C      76          5.055
LGA    R    93_A      D      77          3.066
LGA    V    94_A      R      78          2.268
LGA    L    95_A      Y      79          1.940
LGA    Y    96_A      F      80          1.423
LGA    L    97_A      W      81          1.502
LGA    A    98_A      A      82          1.372
LGA    V    99_A      V      83          1.958
LGA    P   100_A      D      84          1.980
LGA    L   101_A      M      85          3.378
LGA    T   102_A      E      86          3.566
LGA    T   103_A      F      87          1.933
LGA    Y   104_A      -       -           -
LGA    K   105_A      -       -           -
LGA    T   106_A      -       -           -
LGA    F   107_A      P      88          1.405
LGA    F   108_A      A      89          2.434
LGA    Q   109_A      E      90          3.496
LGA    L   110_A      -       -           -
LGA    D   111_A      -       -           -
LGA    F   112_A      -       -           -
LGA    P   113_A      L      91          1.938
LGA    K   114_A      L      92           #
LGA    E   115_A      -       -           -
LGA    I   116_A      -       -           -
LGA    I   117_A      P      93          1.283
LGA    I   118_A      A      94          2.374
LGA    E   119_A      -       -           -
LGA    N   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    V   122_A      E      95          4.100
LGA    K   123_A      S      96          1.253
LGA    X   124_A      G      97          2.460
LGA    L   125_A      L      98          2.694
LGA    V   126_A      L      99          1.600
LGA    Y   127_A      I     100          2.202
LGA    D   128_A      A     101          3.583
LGA    V   129_A      D     102          1.842
LGA    E   130_A      A     103           #
LGA    Q   131_A      Y     104          4.836
LGA    E   132_A      D     105          0.833
LGA    V   133_A      A     106          2.560
LGA    I   134_A      E     107          1.437
LGA    F   135_A      I     108          3.949
LGA    Q   136_A      V     109          1.692
LGA    W   137_A      R     110          3.002
LGA    I   138_A      M     111          3.403
LGA    N   139_A      A     112          2.564
LGA    -       -      P     113           -
LGA    -       -      E     114           -
LGA    -       -      Q     115           -
LGA    -       -      K     116           -
LGA    -       -      L     117           -
LGA    -       -      A     118           -
LGA    -       -      P     119           -
LGA    -       -      A     120           -
LGA    -       -      R     121           -
LGA    -       -      R     122           -
LGA    -       -      K     123           -
LGA    -       -      V     124           -
LGA    -       -      L     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      K     128           -
LGA    -       -      F     129           -
LGA    -       -      A     130           -
LGA    -       -      T     131           -
LGA    -       -      H     132           -
LGA    -       -      A     133           -
LGA    -       -      A     134           -
LGA    -       -      R     135           -
LGA    -       -      R     136           -
LGA    -       -      L     137           -
LGA    -       -      Q     138           -
LGA    -       -      A     139           -
LGA    -       -      L     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      P     143           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  129  139    5.0     98    2.51    11.22     44.374     3.757

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.221371 * X  +   0.434807 * Y  +  -0.872890 * Z  +  49.503132
  Y_new =  -0.783811 * X  +  -0.611884 * Y  +  -0.106014 * Z  +  57.289570
  Z_new =  -0.580203 * X  +   0.660713 * Y  +   0.476260 * Z  + -10.862364 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.946229   -2.195364  [ DEG:    54.2149   -125.7851 ]
  Theta =   0.618978    2.522615  [ DEG:    35.4648    144.5352 ]
  Phi   =  -1.846056    1.295537  [ DEG:  -105.7712     74.2288 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2okf_A                                        
REMARK     2: T0495_5_143.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2okf_A.T0495_5_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  129  139   5.0   98   2.51   11.22  44.374
REMARK  ---------------------------------------------------------- 
MOLECULE 2okf_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   16-JAN-07   2OKF              
TITLE     CRYSTAL STRUCTURE OF FDXN ELEMENT EXCISION CONTROLLING                
TITLE    2 FACTOR PROTEIN (YP_323815.1) FROM ANABAENA VARIABILIS ATCC           
TITLE    3 29413 AT 1.60 A RESOLUTION                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FDXN ELEMENT EXCISION CONTROLLING FACTOR PROTEIN;          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ANABAENA VARIABILIS;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PCC 7937;                                                    
SOURCE   5 ATCC: 29413;                                                         
SOURCE   6 GENE: YP_323815.1, AVA_3312;                                         
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_323815.1, XISH PROTEIN, FDXN ELEMENT EXCISION                      
KEYWDS   2 CONTROLLING FACTOR PROTEIN, STRUCTURAL GENOMICS, JOINT               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE              
KEYWDS   4 INITIATIVE, PSI-2                                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   30-JAN-07 2OKF    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF FDXN ELEMENT EXCISION                   
JRNL        TITL 2 CONTROLLING FACTOR PROTEIN (YP_323815.1) FROM                
JRNL        TITL 3 ANABAENA VARIABILIS ATCC 29413 AT 1.60 A RESOLUTION          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2OKF A    1   139  UNP    Q3M7W6   Q3M7W6_ANAVT     1    139             
DBREF  2OKF B    1   139  UNP    Q3M7W6   Q3M7W6_ANAVT     1    139             
SEQRES   1 A  140  GLY MSE SER ALA ARG ASP VAL PHE HIS GLU VAL VAL LYS          
SEQRES   2 A  140  THR ALA LEU LYS LYS ASP GLY TRP GLN ILE THR ASP ASP          
SEQRES   3 A  140  PRO LEU THR ILE SER VAL GLY GLY VAL ASN LEU SER ILE          
SEQRES   4 A  140  ASP LEU ALA ALA GLN LYS LEU ILE ALA ALA GLU ARG GLN          
SEQRES   5 A  140  GLY GLN LYS ILE ALA VAL GLU VAL LYS SER PHE LEU LYS          
SEQRES   6 A  140  GLN SER SER ALA ILE SER GLU PHE HIS THR ALA LEU GLY          
SEQRES   7 A  140  GLN PHE ILE ASN TYR ARG GLY ALA LEU ARG LYS VAL GLU          
SEQRES   8 A  140  PRO ASP ARG VAL LEU TYR LEU ALA VAL PRO LEU THR THR          
SEQRES   9 A  140  TYR LYS THR PHE PHE GLN LEU ASP PHE PRO LYS GLU ILE          
SEQRES  10 A  140  ILE ILE GLU ASN GLN VAL LYS MSE LEU VAL TYR ASP VAL          
SEQRES  11 A  140  GLU GLN GLU VAL ILE PHE GLN TRP ILE ASN                      
SEQRES   1 B  140  GLY MSE SER ALA ARG ASP VAL PHE HIS GLU VAL VAL LYS          
SEQRES   2 B  140  THR ALA LEU LYS LYS ASP GLY TRP GLN ILE THR ASP ASP          
SEQRES   3 B  140  PRO LEU THR ILE SER VAL GLY GLY VAL ASN LEU SER ILE          
SEQRES   4 B  140  ASP LEU ALA ALA GLN LYS LEU ILE ALA ALA GLU ARG GLN          
SEQRES   5 B  140  GLY GLN LYS ILE ALA VAL GLU VAL LYS SER PHE LEU LYS          
SEQRES   6 B  140  GLN SER SER ALA ILE SER GLU PHE HIS THR ALA LEU GLY          
SEQRES   7 B  140  GLN PHE ILE ASN TYR ARG GLY ALA LEU ARG LYS VAL GLU          
SEQRES   8 B  140  PRO ASP ARG VAL LEU TYR LEU ALA VAL PRO LEU THR THR          
SEQRES   9 B  140  TYR LYS THR PHE PHE GLN LEU ASP PHE PRO LYS GLU ILE          
SEQRES  10 B  140  ILE ILE GLU ASN GLN VAL LYS MSE LEU VAL TYR ASP VAL          
SEQRES  11 B  140  GLU GLN GLU VAL ILE PHE GLN TRP ILE ASN                      
HET    MSE  A 124      13                                                       
HET    MSE  B 124      13                                                       
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HET    ACT     12       4                                                       
HET    ACT     13       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       4                                                       
HET    EDO      7       4                                                       
HET    EDO      8       4                                                       
HET    EDO      9       4                                                       
HET    EDO     10       4                                                       
HET    EDO     11       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     ACT ACETATE ION                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   3   CL    2(CL 1-)                                                     
FORMUL   5  ACT    2(C2 H3 O2 1-)                                               
FORMUL   7  EDO    9(C2 H6 O2)                                                  
FORMUL  16  HOH   *285(H2 O)                                                    
CRYST1   59.810   59.810   73.190  90.00  90.00 120.00 P 31          6          
ATOM      1  N   ARG A   4      44.236  31.988  10.682  1.00 57.71           N  
ATOM      2  CA  ARG A   4      44.570  33.448  10.568  1.00 56.40           C  
ATOM      3  C   ARG A   4      45.507  33.697   9.395  1.00 53.01           C  
ATOM      4  O   ARG A   4      45.270  34.600   8.608  1.00 49.90           O  
ATOM      5  CB  ARG A   4      45.199  33.978  11.866  1.00 58.14           C  
ATOM      6  N   ASP A   5      46.567  32.890   9.297  1.00 50.78           N  
ATOM      7  CA  ASP A   5      47.508  32.979   8.184  1.00 47.37           C  
ATOM      8  C   ASP A   5      46.781  32.723   6.852  1.00 43.11           C  
ATOM      9  O   ASP A   5      47.055  33.399   5.869  1.00 39.96           O  
ATOM     10  CB  ASP A   5      48.697  32.017   8.357  1.00 48.59           C  
ATOM     11  CG  ASP A   5      48.281  30.556   8.431  1.00 50.97           C  
ATOM     12  N   VAL A   6      45.844  31.773   6.829  1.00 38.28           N  
ATOM     13  CA  VAL A   6      45.097  31.481   5.606  1.00 37.55           C  
ATOM     14  C   VAL A   6      44.316  32.694   5.084  1.00 34.32           C  
ATOM     15  O   VAL A   6      44.390  33.030   3.904  1.00 31.53           O  
ATOM     16  CB  VAL A   6      44.117  30.318   5.805  1.00 38.82           C  
ATOM     17  CG1 VAL A   6      43.151  30.190   4.619  1.00 39.03           C  
ATOM     18  CG2 VAL A   6      44.893  29.018   6.025  1.00 42.90           C  
ATOM     19  N   PHE A   7      43.544  33.327   5.956  1.00 31.54           N  
ATOM     20  CA  PHE A   7      42.756  34.486   5.536  1.00 30.53           C  
ATOM     21  C   PHE A   7      43.650  35.649   5.178  1.00 29.78           C  
ATOM     22  O   PHE A   7      43.348  36.431   4.279  1.00 27.92           O  
ATOM     23  CB  PHE A   7      41.733  34.870   6.605  1.00 34.69           C  
ATOM     24  CG  PHE A   7      40.613  33.905   6.682  1.00 35.14           C  
ATOM     25  CD1 PHE A   7      40.747  32.725   7.415  1.00 43.08           C  
ATOM     26  CD2 PHE A   7      39.442  34.133   5.970  1.00 34.21           C  
ATOM     27  CE1 PHE A   7      39.725  31.804   7.444  1.00 39.19           C  
ATOM     28  CE2 PHE A   7      38.412  33.217   5.995  1.00 35.91           C  
ATOM     29  CZ  PHE A   7      38.553  32.039   6.722  1.00 39.03           C  
ATOM     30  N   HIS A   8      44.771  35.754   5.874  1.00 29.40           N  
ATOM     31  CA  HIS A   8      45.744  36.774   5.563  1.00 31.15           C  
ATOM     32  C   HIS A   8      46.258  36.586   4.122  1.00 28.59           C  
ATOM     33  O   HIS A   8      46.367  37.544   3.336  1.00 27.38           O  
ATOM     34  CB  HIS A   8      46.872  36.651   6.566  1.00 33.59           C  
ATOM     35  CG  HIS A   8      47.887  37.721   6.447  1.00 36.00           C  
ATOM     36  ND1 HIS A   8      47.861  38.856   7.231  1.00 34.36           N  
ATOM     37  CD2 HIS A   8      48.978  37.823   5.659  1.00 37.73           C  
ATOM     38  CE1 HIS A   8      48.889  39.623   6.907  1.00 34.69           C  
ATOM     39  NE2 HIS A   8      49.579  39.020   5.956  1.00 42.94           N  
ATOM     40  N   GLU A   9      46.588  35.346   3.762  1.00 25.16           N  
ATOM     41  CA  GLU A   9      47.061  35.038   2.432  1.00 25.74           C  
ATOM     42  C   GLU A   9      45.962  35.257   1.394  1.00 23.78           C  
ATOM     43  O   GLU A   9      46.240  35.751   0.305  1.00 23.81           O  
ATOM     44  CB  GLU A   9      47.633  33.622   2.352  1.00 26.64           C  
ATOM     45  CG  GLU A   9      48.981  33.494   3.072  1.00 35.76           C  
ATOM     46  CD  GLU A   9      49.993  34.543   2.582  1.00 39.10           C  
ATOM     47  OE1 GLU A   9      50.231  34.624   1.348  1.00 45.32           O  
ATOM     48  OE2 GLU A   9      50.526  35.305   3.433  1.00 45.49           O  
ATOM     49  N   VAL A  10      44.723  34.908   1.731  1.00 22.16           N  
ATOM     50  CA  VAL A  10      43.597  35.146   0.820  1.00 20.84           C  
ATOM     51  C   VAL A  10      43.492  36.629   0.475  1.00 21.73           C  
ATOM     52  O   VAL A  10      43.318  36.988  -0.673  1.00 21.60           O  
ATOM     53  CB  VAL A  10      42.258  34.693   1.435  1.00 22.21           C  
ATOM     54  CG1 VAL A  10      41.073  35.231   0.661  1.00 25.34           C  
ATOM     55  CG2 VAL A  10      42.208  33.170   1.496  1.00 23.84           C  
ATOM     56  N   VAL A  11      43.560  37.493   1.488  1.00 22.60           N  
ATOM     57  CA  VAL A  11      43.444  38.929   1.229  1.00 22.29           C  
ATOM     58  C   VAL A  11      44.618  39.436   0.401  1.00 22.38           C  
ATOM     59  O   VAL A  11      44.454  40.266  -0.494  1.00 22.22           O  
ATOM     60  CB  VAL A  11      43.258  39.730   2.557  1.00 22.62           C  
ATOM     61  CG1 VAL A  11      43.255  41.217   2.259  1.00 25.07           C  
ATOM     62  CG2 VAL A  11      41.981  39.299   3.232  1.00 25.18           C  
ATOM     63  N   LYS A  12      45.818  38.950   0.681  1.00 22.92           N  
ATOM     64  CA  LYS A  12      46.975  39.333  -0.112  1.00 23.22           C  
ATOM     65  C   LYS A  12      46.774  38.941  -1.558  1.00 23.00           C  
ATOM     66  O   LYS A  12      47.083  39.697  -2.466  1.00 23.30           O  
ATOM     67  CB  LYS A  12      48.260  38.721   0.460  1.00 23.86           C  
ATOM     68  CG  LYS A  12      48.695  39.356   1.729  1.00 28.88           C  
ATOM     69  CD  LYS A  12      49.827  38.622   2.449  1.00 34.46           C  
ATOM     70  CE  LYS A  12      51.127  38.652   1.705  1.00 43.33           C  
ATOM     71  NZ  LYS A  12      52.238  38.148   2.628  1.00 42.82           N  
ATOM     72  N   THR A  13      46.275  37.721  -1.775  1.00 22.53           N  
ATOM     73  CA  THR A  13      46.000  37.218  -3.112  1.00 24.07           C  
ATOM     74  C   THR A  13      44.974  38.095  -3.815  1.00 21.70           C  
ATOM     75  O   THR A  13      45.198  38.504  -4.969  1.00 23.00           O  
ATOM     76  CB  THR A  13      45.561  35.762  -3.053  1.00 25.45           C  
ATOM     77  OG1 THR A  13      46.710  34.993  -2.645  1.00 24.69           O  
ATOM     78  CG2 THR A  13      45.055  35.244  -4.405  1.00 24.29           C  
ATOM     79  N   ALA A  14      43.899  38.425  -3.108  1.00 22.02           N  
ATOM     80  CA  ALA A  14      42.835  39.262  -3.656  1.00 21.56           C  
ATOM     81  C   ALA A  14      43.380  40.638  -4.031  1.00 21.05           C  
ATOM     82  O   ALA A  14      43.087  41.169  -5.094  1.00 22.41           O  
ATOM     83  CB  ALA A  14      41.735  39.365  -2.672  1.00 22.63           C  
ATOM     84  N   LEU A  15      44.194  41.213  -3.143  1.00 18.95           N  
ATOM     85  CA  LEU A  15      44.828  42.502  -3.426  1.00 19.74           C  
ATOM     86  C   LEU A  15      45.694  42.428  -4.699  1.00 21.19           C  
ATOM     87  O   LEU A  15      45.582  43.289  -5.595  1.00 21.01           O  
ATOM     88  CB  LEU A  15      45.693  42.963  -2.239  1.00 19.81           C  
ATOM     89  CG  LEU A  15      44.908  43.536  -1.062  1.00 21.89           C  
ATOM     90  CD1 LEU A  15      45.763  43.587   0.195  1.00 24.51           C  
ATOM     91  CD2 LEU A  15      44.398  44.901  -1.427  1.00 23.30           C  
ATOM     92  N   LYS A  16      46.561  41.424  -4.775  1.00 20.55           N  
ATOM     93  CA  LYS A  16      47.453  41.333  -5.930  1.00 22.25           C  
ATOM     94  C   LYS A  16      46.686  41.129  -7.243  1.00 22.53           C  
ATOM     95  O   LYS A  16      47.087  41.677  -8.274  1.00 22.78           O  
ATOM     96  CB  LYS A  16      48.475  40.227  -5.684  1.00 23.16           C  
ATOM     97  CG  LYS A  16      49.474  40.676  -4.680  1.00 24.27           C  
ATOM     98  CD  LYS A  16      50.532  39.634  -4.426  1.00 26.78           C  
ATOM     99  CE  LYS A  16      50.010  38.483  -3.650  1.00 28.76           C  
ATOM    100  NZ  LYS A  16      51.074  37.418  -3.590  1.00 35.79           N  
ATOM    101  N   LYS A  17      45.581  40.405  -7.220  1.00 21.13           N  
ATOM    102  CA  LYS A  17      44.777  40.232  -8.420  1.00 21.25           C  
ATOM    103  C   LYS A  17      44.242  41.561  -8.961  1.00 21.03           C  
ATOM    104  O   LYS A  17      43.989  41.701 -10.166  1.00 22.33           O  
ATOM    105  CB  LYS A  17      43.591  39.322  -8.153  1.00 23.34           C  
ATOM    106  CG  LYS A  17      43.918  37.864  -8.068  1.00 23.74           C  
ATOM    107  CD  LYS A  17      42.601  37.080  -7.914  1.00 24.21           C  
ATOM    108  CE  LYS A  17      42.860  35.637  -7.689  1.00 25.11           C  
ATOM    109  NZ  LYS A  17      41.638  34.879  -7.319  1.00 20.66           N  
ATOM    110  N   ASP A  18      44.034  42.523  -8.066  1.00 20.28           N  
ATOM    111  CA  ASP A  18      43.544  43.843  -8.466  1.00 19.95           C  
ATOM    112  C   ASP A  18      44.703  44.822  -8.734  1.00 20.26           C  
ATOM    113  O   ASP A  18      44.477  45.999  -8.887  1.00 21.06           O  
ATOM    114  CB  ASP A  18      42.587  44.387  -7.443  1.00 20.29           C  
ATOM    115  CG  ASP A  18      41.151  43.915  -7.590  1.00 19.75           C  
ATOM    116  OD1 ASP A  18      40.889  42.914  -8.298  1.00 21.12           O  
ATOM    117  OD2 ASP A  18      40.296  44.562  -6.960  1.00 21.29           O  
ATOM    118  N   GLY A  19      45.918  44.310  -8.784  1.00 20.86           N  
ATOM    119  CA  GLY A  19      47.047  45.191  -9.083  1.00 21.86           C  
ATOM    120  C   GLY A  19      47.694  45.932  -7.970  1.00 21.97           C  
ATOM    121  O   GLY A  19      48.496  46.817  -8.232  1.00 24.79           O  
ATOM    122  N   TRP A  20      47.345  45.599  -6.721  1.00 20.63           N  
ATOM    123  CA  TRP A  20      47.963  46.207  -5.537  1.00 21.20           C  
ATOM    124  C   TRP A  20      49.311  45.541  -5.282  1.00 22.10           C  
ATOM    125  O   TRP A  20      49.503  44.342  -5.500  1.00 24.29           O  
ATOM    126  CB  TRP A  20      47.054  46.025  -4.313  1.00 20.04           C  
ATOM    127  CG  TRP A  20      45.793  46.815  -4.419  1.00 20.31           C  
ATOM    128  CD1 TRP A  20      44.637  46.427  -5.069  1.00 21.46           C  
ATOM    129  CD2 TRP A  20      45.569  48.143  -3.960  1.00 19.90           C  
ATOM    130  NE1 TRP A  20      43.749  47.427  -5.038  1.00 20.89           N  
ATOM    131  CE2 TRP A  20      44.270  48.498  -4.355  1.00 20.71           C  
ATOM    132  CE3 TRP A  20      46.339  49.067  -3.229  1.00 20.30           C  
ATOM    133  CZ2 TRP A  20      43.722  49.747  -4.057  1.00 22.65           C  
ATOM    134  CZ3 TRP A  20      45.817  50.299  -2.969  1.00 21.74           C  
ATOM    135  CH2 TRP A  20      44.521  50.637  -3.392  1.00 21.85           C  
ATOM    136  N   GLN A  21      50.273  46.353  -4.898  1.00 23.62           N  
ATOM    137  CA  GLN A  21      51.608  45.921  -4.541  1.00 25.56           C  
ATOM    138  C   GLN A  21      51.672  45.873  -3.031  1.00 23.41           C  
ATOM    139  O   GLN A  21      51.404  46.881  -2.370  1.00 24.30           O  
ATOM    140  CB  GLN A  21      52.625  46.945  -5.046  1.00 26.25           C  
ATOM    141  CG  GLN A  21      54.070  46.670  -4.602  1.00 35.50           C  
ATOM    142  CD  GLN A  21      55.063  47.812  -4.926  1.00 39.19           C  
ATOM    143  OE1 GLN A  21      54.714  48.835  -5.553  1.00 53.23           O  
ATOM    144  NE2 GLN A  21      56.302  47.644  -4.464  1.00 44.76           N  
ATOM    145  N   ILE A  22      51.994  44.708  -2.489  1.00 24.00           N  
ATOM    146  CA  ILE A  22      52.161  44.559  -1.075  1.00 24.32           C  
ATOM    147  C   ILE A  22      53.544  45.115  -0.657  1.00 24.64           C  
ATOM    148  O   ILE A  22      54.570  44.672  -1.212  1.00 27.53           O  
ATOM    149  CB  ILE A  22      52.025  43.112  -0.657  1.00 28.19           C  
ATOM    150  CG1 ILE A  22      50.737  42.437  -1.207  1.00 32.45           C  
ATOM    151  CG2 ILE A  22      52.138  42.985   0.852  1.00 28.55           C  
ATOM    152  CD1 ILE A  22      49.477  43.049  -0.831  1.00 32.60           C  
ATOM    153  N   THR A  23      53.604  46.077   0.268  1.00 25.52           N  
ATOM    154  CA  THR A  23      54.891  46.674   0.637  1.00 27.16           C  
ATOM    155  C   THR A  23      55.404  46.267   2.011  1.00 30.77           C  
ATOM    156  O   THR A  23      56.627  46.313   2.258  1.00 32.34           O  
ATOM    157  CB  THR A  23      54.842  48.193   0.518  1.00 28.49           C  
ATOM    158  OG1 THR A  23      53.825  48.718   1.402  1.00 27.69           O  
ATOM    159  CG2 THR A  23      54.588  48.576  -0.936  1.00 27.53           C  
ATOM    160  N   ASP A  24      54.512  45.884   2.898  1.00 29.34           N  
ATOM    161  CA  ASP A  24      54.893  45.468   4.227  1.00 34.60           C  
ATOM    162  C   ASP A  24      53.856  44.520   4.766  1.00 35.23           C  
ATOM    163  O   ASP A  24      52.626  44.685   4.603  1.00 34.32           O  
ATOM    164  CB  ASP A  24      55.083  46.656   5.198  1.00 35.98           C  
ATOM    165  CG  ASP A  24      56.467  47.266   5.121  1.00 42.41           C  
ATOM    166  OD1 ASP A  24      57.482  46.523   5.006  1.00 53.05           O  
ATOM    167  OD2 ASP A  24      56.550  48.501   5.189  1.00 55.71           O  
ATOM    168  N   ASP A  25      54.364  43.495   5.418  1.00 34.59           N  
ATOM    169  CA  ASP A  25      53.525  42.520   6.013  1.00 34.77           C  
ATOM    170  C   ASP A  25      54.400  41.779   7.003  1.00 36.46           C  
ATOM    171  O   ASP A  25      55.186  40.920   6.614  1.00 38.40           O  
ATOM    172  CB  ASP A  25      52.966  41.588   4.946  1.00 36.75           C  
ATOM    173  CG  ASP A  25      52.012  40.577   5.517  1.00 40.72           C  
ATOM    174  OD1 ASP A  25      51.684  40.681   6.707  1.00 44.06           O  
ATOM    175  OD2 ASP A  25      51.607  39.662   4.774  1.00 47.80           O  
ATOM    176  N   PRO A  26      54.279  42.112   8.286  1.00 35.89           N  
ATOM    177  CA  PRO A  26      53.364  43.103   8.830  1.00 36.17           C  
ATOM    178  C   PRO A  26      53.838  44.541   8.729  1.00 33.37           C  
ATOM    179  O   PRO A  26      55.048  44.830   8.678  1.00 32.32           O  
ATOM    180  CB  PRO A  26      53.273  42.706  10.306  1.00 38.28           C  
ATOM    181  CG  PRO A  26      54.635  42.130  10.602  1.00 38.99           C  
ATOM    182  CD  PRO A  26      55.100  41.478   9.337  1.00 37.88           C  
ATOM    183  N   LEU A  27      52.857  45.435   8.642  1.00 32.12           N  
ATOM    184  CA  LEU A  27      53.116  46.846   8.760  1.00 31.66           C  
ATOM    185  C   LEU A  27      53.187  47.062  10.273  1.00 32.42           C  
ATOM    186  O   LEU A  27      52.186  46.865  10.967  1.00 34.89           O  
ATOM    187  CB  LEU A  27      51.956  47.667   8.198  1.00 32.53           C  
ATOM    188  CG  LEU A  27      52.049  49.168   8.462  1.00 33.91           C  
ATOM    189  CD1 LEU A  27      53.254  49.788   7.818  1.00 36.59           C  
ATOM    190  CD2 LEU A  27      50.746  49.767   7.938  1.00 32.02           C  
ATOM    191  N   THR A  28      54.332  47.484  10.776  1.00 33.78           N  
ATOM    192  CA  THR A  28      54.462  47.724  12.224  1.00 37.91           C  
ATOM    193  C   THR A  28      54.296  49.199  12.499  1.00 40.43           C  
ATOM    194  O   THR A  28      54.749  50.035  11.717  1.00 42.66           O  
ATOM    195  CB  THR A  28      55.780  47.216  12.786  1.00 37.49           C  
ATOM    196  OG1 THR A  28      56.871  47.776  12.037  1.00 40.46           O  
ATOM    197  CG2 THR A  28      55.806  45.671  12.704  1.00 39.61           C  
ATOM    198  N   ILE A  29      53.626  49.505  13.607  1.00 41.74           N  
ATOM    199  CA  ILE A  29      53.357  50.887  13.978  1.00 44.68           C  
ATOM    200  C   ILE A  29      53.805  51.111  15.430  1.00 42.86           C  
ATOM    201  O   ILE A  29      53.352  50.411  16.338  1.00 43.12           O  
ATOM    202  CB  ILE A  29      51.844  51.206  13.846  1.00 45.04           C  
ATOM    203  CG1 ILE A  29      51.300  50.743  12.488  1.00 44.86           C  
ATOM    204  CG2 ILE A  29      51.569  52.719  14.043  1.00 46.42           C  
ATOM    205  CD1 ILE A  29      49.793  50.813  12.376  1.00 47.72           C  
ATOM    206  N   SER A  30      54.704  52.063  15.633  1.00 43.35           N  
ATOM    207  CA  SER A  30      55.128  52.431  16.981  1.00 43.36           C  
ATOM    208  C   SER A  30      54.876  53.921  17.164  1.00 40.72           C  
ATOM    209  O   SER A  30      55.353  54.732  16.390  1.00 39.33           O  
ATOM    210  CB  SER A  30      56.602  52.098  17.204  1.00 45.80           C  
ATOM    211  OG  SER A  30      56.782  50.688  17.290  1.00 54.53           O  
ATOM    212  N   VAL A  31      54.093  54.306  18.166  1.00 35.04           N  
ATOM    213  CA  VAL A  31      53.870  55.713  18.351  1.00 33.18           C  
ATOM    214  C   VAL A  31      53.384  55.997  19.754  1.00 33.45           C  
ATOM    215  O   VAL A  31      52.682  55.179  20.364  1.00 31.65           O  
ATOM    216  CB  VAL A  31      52.855  56.302  17.320  1.00 36.56           C  
ATOM    217  CG1 VAL A  31      51.510  55.738  17.538  1.00 34.98           C  
ATOM    218  CG2 VAL A  31      52.811  57.840  17.394  1.00 40.96           C  
ATOM    219  N   GLY A  32      53.809  57.140  20.273  1.00 32.85           N  
ATOM    220  CA  GLY A  32      53.332  57.608  21.550  1.00 32.69           C  
ATOM    221  C   GLY A  32      53.495  56.652  22.694  1.00 32.41           C  
ATOM    222  O   GLY A  32      52.630  56.582  23.559  1.00 28.66           O  
ATOM    223  N   GLY A  33      54.627  55.939  22.709  1.00 33.45           N  
ATOM    224  CA  GLY A  33      54.956  55.024  23.798  1.00 31.29           C  
ATOM    225  C   GLY A  33      54.391  53.625  23.663  1.00 32.83           C  
ATOM    226  O   GLY A  33      54.550  52.795  24.564  1.00 34.91           O  
ATOM    227  N   VAL A  34      53.735  53.344  22.544  1.00 32.71           N  
ATOM    228  CA  VAL A  34      53.141  52.047  22.340  1.00 35.23           C  
ATOM    229  C   VAL A  34      53.542  51.430  20.998  1.00 37.99           C  
ATOM    230  O   VAL A  34      53.656  52.120  19.993  1.00 35.71           O  
ATOM    231  CB  VAL A  34      51.586  52.156  22.438  1.00 35.83           C  
ATOM    232  CG1 VAL A  34      50.933  50.835  22.183  1.00 35.83           C  
ATOM    233  CG2 VAL A  34      51.203  52.687  23.804  1.00 34.65           C  
ATOM    234  N   ASN A  35      53.789  50.126  21.020  1.00 43.88           N  
ATOM    235  CA  ASN A  35      54.090  49.373  19.813  0.50 46.26           C  
ATOM    237  C   ASN A  35      52.855  48.549  19.539  1.00 48.12           C  
ATOM    238  O   ASN A  35      52.523  47.643  20.303  1.00 49.61           O  
ATOM    239  CB  ASN A  35      55.314  48.466  19.993  0.50 47.24           C  
ATOM    241  CG  ASN A  35      55.562  47.548  18.789  0.50 46.44           C  
ATOM    243  OD1 ASN A  35      56.234  46.529  18.916  0.50 55.02           O  
ATOM    245  ND2 ASN A  35      55.008  47.900  17.631  0.50 41.07           N  
ATOM    247  N   LEU A  36      52.169  48.881  18.461  1.00 49.80           N  
ATOM    248  CA  LEU A  36      50.951  48.183  18.101  1.00 53.16           C  
ATOM    249  C   LEU A  36      51.258  46.966  17.223  1.00 54.56           C  
ATOM    250  O   LEU A  36      52.416  46.531  17.129  1.00 57.89           O  
ATOM    251  CB  LEU A  36      49.984  49.138  17.400  1.00 52.49           C  
ATOM    252  CG  LEU A  36      49.399  50.271  18.252  1.00 48.82           C  
ATOM    253  CD1 LEU A  36      50.381  51.432  18.372  1.00 53.78           C  
ATOM    254  CD2 LEU A  36      48.120  50.781  17.636  1.00 54.57           C  
ATOM    255  N   LYS A  44      48.678  41.034  12.083  1.00 40.43           N  
ATOM    256  CA  LYS A  44      49.623  41.551  11.073  1.00 38.89           C  
ATOM    257  C   LYS A  44      48.898  42.390   9.991  1.00 36.04           C  
ATOM    258  O   LYS A  44      48.309  41.841   9.047  1.00 37.01           O  
ATOM    259  CB  LYS A  44      50.354  40.403  10.360  1.00 40.94           C  
ATOM    260  N   LEU A  45      48.935  43.713  10.141  1.00 34.27           N  
ATOM    261  CA  LEU A  45      48.355  44.587   9.155  1.00 31.49           C  
ATOM    262  C   LEU A  45      49.128  44.422   7.861  1.00 28.32           C  
ATOM    263  O   LEU A  45      50.361  44.252   7.860  1.00 30.67           O  
ATOM    264  CB  LEU A  45      48.486  46.059   9.572  1.00 31.40           C  
ATOM    265  CG  LEU A  45      47.634  46.645  10.660  1.00 35.81           C  
ATOM    266  CD1 LEU A  45      48.086  48.059  10.929  1.00 35.49           C  
ATOM    267  CD2 LEU A  45      46.180  46.600  10.241  1.00 34.06           C  
ATOM    268  N   ILE A  46      48.413  44.500   6.754  1.00 25.67           N  
ATOM    269  CA  ILE A  46      49.023  44.484   5.434  1.00 25.00           C  
ATOM    270  C   ILE A  46      49.121  45.915   4.919  1.00 27.07           C  
ATOM    271  O   ILE A  46      48.138  46.634   4.941  1.00 28.27           O  
ATOM    272  CB  ILE A  46      48.173  43.704   4.405  1.00 25.70           C  
ATOM    273  CG1 ILE A  46      47.998  42.258   4.837  1.00 29.75           C  
ATOM    274  CG2 ILE A  46      48.799  43.795   3.030  1.00 29.98           C  
ATOM    275  CD1 ILE A  46      46.922  41.464   4.037  1.00 27.88           C  
ATOM    276  N   ALA A  47      50.297  46.324   4.456  1.00 24.05           N  
ATOM    277  CA  ALA A  47      50.468  47.628   3.817  1.00 22.38           C  
ATOM    278  C   ALA A  47      50.541  47.348   2.312  1.00 23.79           C  
ATOM    279  O   ALA A  47      51.258  46.438   1.873  1.00 23.71           O  
ATOM    280  CB  ALA A  47      51.735  48.296   4.238  1.00 23.83           C  
ATOM    281  N   ALA A  48      49.831  48.137   1.513  1.00 22.11           N  
ATOM    282  CA  ALA A  48      49.863  47.960   0.082  1.00 21.33           C  
ATOM    283  C   ALA A  48      49.689  49.285  -0.581  1.00 20.85           C  
ATOM    284  O   ALA A  48      49.287  50.282   0.044  1.00 20.74           O  
ATOM    285  CB  ALA A  48      48.758  46.997  -0.376  1.00 22.16           C  
ATOM    286  N   GLU A  49      50.030  49.308  -1.866  1.00 21.46           N  
ATOM    287  CA  GLU A  49      49.832  50.526  -2.623  1.00 23.05           C  
ATOM    288  C   GLU A  49      49.564  50.262  -4.072  1.00 21.05           C  
ATOM    289  O   GLU A  49      49.869  49.192  -4.569  1.00 22.42           O  
ATOM    290  CB  GLU A  49      51.015  51.487  -2.468  1.00 26.20           C  
ATOM    291  CG  GLU A  49      52.273  51.029  -3.027  1.00 28.86           C  
ATOM    292  CD  GLU A  49      53.323  52.118  -2.823  1.00 30.87           C  
ATOM    293  OE1 GLU A  49      53.782  52.288  -1.675  1.00 29.76           O  
ATOM    294  OE2 GLU A  49      53.675  52.817  -3.808  1.00 38.33           O  
ATOM    295  N   ARG A  50      48.928  51.231  -4.733  1.00 21.71           N  
ATOM    296  CA  ARG A  50      48.641  51.106  -6.159  1.00 21.13           C  
ATOM    297  C   ARG A  50      48.560  52.496  -6.748  1.00 24.90           C  
ATOM    298  O   ARG A  50      47.748  53.308  -6.289  1.00 25.52           O  
ATOM    299  CB  ARG A  50      47.310  50.356  -6.348  1.00 22.06           C  
ATOM    300  CG  ARG A  50      47.046  49.904  -7.793  1.00 23.99           C  
ATOM    301  CD  ARG A  50      45.756  49.076  -7.867  1.00 22.89           C  
ATOM    302  NE  ARG A  50      44.608  49.939  -7.608  1.00 23.18           N  
ATOM    303  CZ  ARG A  50      43.361  49.628  -7.916  1.00 22.08           C  
ATOM    304  NH1 ARG A  50      43.077  48.438  -8.501  1.00 20.69           N  
ATOM    305  NH2 ARG A  50      42.427  50.506  -7.657  1.00 26.82           N  
ATOM    306  N   GLN A  51      49.368  52.745  -7.779  1.00 26.29           N  
ATOM    307  CA  GLN A  51      49.392  54.044  -8.423  0.50 28.18           C  
ATOM    309  C   GLN A  51      49.523  55.151  -7.377  1.00 28.89           C  
ATOM    310  O   GLN A  51      48.794  56.147  -7.398  1.00 31.40           O  
ATOM    311  CB  GLN A  51      48.122  54.201  -9.258  0.50 29.85           C  
ATOM    313  CG  GLN A  51      48.269  55.133 -10.449  0.50 31.26           C  
ATOM    315  CD  GLN A  51      47.043  55.108 -11.339  0.50 28.43           C  
ATOM    317  OE1 GLN A  51      45.939  54.838 -10.867  0.50 33.35           O  
ATOM    319  NE2 GLN A  51      47.228  55.415 -12.619  0.50 20.52           N  
ATOM    321  N   GLY A  52      50.433  54.946  -6.439  1.00 27.86           N  
ATOM    322  CA  GLY A  52      50.654  55.922  -5.383  1.00 28.99           C  
ATOM    323  C   GLY A  52      49.658  56.030  -4.249  1.00 29.44           C  
ATOM    324  O   GLY A  52      49.942  56.746  -3.287  1.00 33.35           O  
ATOM    325  N   GLN A  53      48.503  55.351  -4.365  1.00 26.65           N  
ATOM    326  CA  GLN A  53      47.497  55.354  -3.299  0.50 26.24           C  
ATOM    328  C   GLN A  53      47.909  54.273  -2.309  1.00 25.17           C  
ATOM    329  O   GLN A  53      48.100  53.142  -2.673  1.00 24.24           O  
ATOM    330  CB  GLN A  53      46.091  55.118  -3.840  0.50 28.44           C  
ATOM    332  CG  GLN A  53      45.765  56.018  -5.040  0.50 34.96           C  
ATOM    334  CD  GLN A  53      46.199  57.461  -4.840  0.50 36.28           C  
ATOM    336  OE1 GLN A  53      46.932  58.025  -5.663  0.50 45.27           O  
ATOM    338  NE2 GLN A  53      45.778  58.058  -3.743  0.50 39.28           N  
ATOM    340  N   LYS A  54      48.079  54.677  -1.048  1.00 22.37           N  
ATOM    341  CA  LYS A  54      48.556  53.791   0.032  1.00 23.03           C  
ATOM    342  C   LYS A  54      47.439  53.377   0.954  1.00 22.19           C  
ATOM    343  O   LYS A  54      46.593  54.180   1.333  1.00 22.18           O  
ATOM    344  CB  LYS A  54      49.624  54.535   0.875  1.00 23.09           C  
ATOM    345  CG  LYS A  54      50.916  54.831   0.127  1.00 26.08           C  
ATOM    346  CD  LYS A  54      51.883  55.636   1.008  1.00 29.36           C  
ATOM    347  CE  LYS A  54      53.150  55.970   0.258  1.00 41.36           C  
ATOM    348  NZ  LYS A  54      54.008  56.900   1.032  1.00 44.37           N  
ATOM    349  N   ILE A  55      47.436  52.103   1.314  1.00 21.72           N  
ATOM    350  CA  ILE A  55      46.446  51.530   2.218  1.00 21.27           C  
ATOM    351  C   ILE A  55      47.076  50.621   3.265  1.00 21.87           C  
ATOM    352  O   ILE A  55      48.197  50.167   3.121  1.00 21.07           O  
ATOM    353  CB  ILE A  55      45.337  50.739   1.475  1.00 22.06           C  
ATOM    354  CG1 ILE A  55      45.905  49.475   0.843  1.00 21.76           C  
ATOM    355  CG2 ILE A  55      44.684  51.617   0.435  1.00 23.05           C  
ATOM    356  CD1 ILE A  55      44.857  48.585   0.251  1.00 23.60           C  
ATOM    357  N   ALA A  56      46.318  50.411   4.342  1.00 20.76           N  
ATOM    358  CA  ALA A  56      46.634  49.427   5.362  1.00 20.65           C  
ATOM    359  C   ALA A  56      45.373  48.598   5.514  1.00 20.78           C  
ATOM    360  O   ALA A  56      44.281  49.122   5.454  1.00 22.53           O  
ATOM    361  CB  ALA A  56      47.006  50.080   6.698  1.00 22.41           C  
ATOM    362  N   VAL A  57      45.522  47.288   5.663  1.00 22.04           N  
ATOM    363  CA  VAL A  57      44.385  46.415   5.758  1.00 20.46           C  
ATOM    364  C   VAL A  57      44.479  45.555   6.992  1.00 21.67           C  
ATOM    365  O   VAL A  57      45.453  44.829   7.199  1.00 21.37           O  
ATOM    366  CB  VAL A  57      44.279  45.482   4.523  1.00 22.13           C  
ATOM    367  CG1 VAL A  57      43.034  44.611   4.634  1.00 22.97           C  
ATOM    368  CG2 VAL A  57      44.240  46.308   3.261  1.00 23.69           C  
ATOM    369  N   GLU A  58      43.423  45.679   7.806  1.00 21.46           N  
ATOM    370  CA  GLU A  58      43.164  44.897   9.026  1.00 21.11           C  
ATOM    371  C   GLU A  58      42.329  43.676   8.630  1.00 21.14           C  
ATOM    372  O   GLU A  58      41.165  43.804   8.295  1.00 23.41           O  
ATOM    373  CB  GLU A  58      42.473  45.736  10.069  1.00 20.20           C  
ATOM    374  CG  GLU A  58      42.025  44.963  11.291  1.00 21.18           C  
ATOM    375  CD  GLU A  58      41.210  45.787  12.221  1.00 23.84           C  
ATOM    376  OE1 GLU A  58      41.284  47.022  12.161  1.00 24.16           O  
ATOM    377  OE2 GLU A  58      40.459  45.200  13.056  1.00 22.96           O  
ATOM    378  N   VAL A  59      42.971  42.511   8.601  1.00 24.15           N  
ATOM    379  CA  VAL A  59      42.283  41.302   8.163  1.00 24.44           C  
ATOM    380  C   VAL A  59      41.541  40.590   9.255  1.00 27.29           C  
ATOM    381  O   VAL A  59      42.137  40.245  10.240  1.00 27.49           O  
ATOM    382  CB  VAL A  59      43.245  40.303   7.484  1.00 26.17           C  
ATOM    383  CG1 VAL A  59      42.478  39.066   7.004  1.00 28.67           C  
ATOM    384  CG2 VAL A  59      43.925  40.971   6.330  1.00 26.54           C  
ATOM    385  N   LYS A  60      40.252  40.323   9.004  1.00 27.01           N  
ATOM    386  CA  LYS A  60      39.382  39.542   9.896  1.00 30.33           C  
ATOM    387  C   LYS A  60      38.669  38.439   9.115  1.00 29.61           C  
ATOM    388  O   LYS A  60      38.338  38.585   7.902  1.00 29.93           O  
ATOM    389  CB  LYS A  60      38.371  40.434  10.617  1.00 31.07           C  
ATOM    390  CG  LYS A  60      39.043  41.455  11.518  1.00 27.28           C  
ATOM    391  CD  LYS A  60      39.729  40.766  12.660  1.00 29.34           C  
ATOM    392  CE  LYS A  60      40.574  41.705  13.472  1.00 27.97           C  
ATOM    393  NZ  LYS A  60      41.027  41.066  14.709  1.00 30.88           N  
ATOM    394  N   SER A  61      38.486  37.313   9.775  1.00 30.89           N  
ATOM    395  CA  SER A  61      37.827  36.153   9.152  1.00 32.30           C  
ATOM    396  C   SER A  61      36.441  35.887   9.741  1.00 32.66           C  
ATOM    397  O   SER A  61      35.635  35.217   9.108  1.00 33.11           O  
ATOM    398  CB  SER A  61      38.692  34.936   9.362  1.00 31.56           C  
ATOM    399  OG  SER A  61      38.940  34.783  10.746  1.00 31.17           O  
ATOM    400  N   PHE A  62      36.174  36.428  10.935  1.00 33.46           N  
ATOM    401  CA  PHE A  62      34.881  36.266  11.581  1.00 34.75           C  
ATOM    402  C   PHE A  62      34.441  34.812  11.591  1.00 36.89           C  
ATOM    403  O   PHE A  62      33.384  34.448  11.072  1.00 37.34           O  
ATOM    404  CB  PHE A  62      33.825  37.200  10.958  1.00 35.54           C  
ATOM    405  CG  PHE A  62      33.954  38.625  11.421  1.00 34.20           C  
ATOM    406  CD1 PHE A  62      33.310  39.044  12.572  1.00 35.44           C  
ATOM    407  CD2 PHE A  62      34.736  39.524  10.733  1.00 35.09           C  
ATOM    408  CE1 PHE A  62      33.446  40.338  13.016  1.00 38.32           C  
ATOM    409  CE2 PHE A  62      34.879  40.828  11.191  1.00 34.12           C  
ATOM    410  CZ  PHE A  62      34.226  41.223  12.332  1.00 34.84           C  
ATOM    411  N   LEU A  63      35.289  33.989  12.193  1.00 37.59           N  
ATOM    412  CA  LEU A  63      35.012  32.569  12.293  1.00 41.59           C  
ATOM    413  C   LEU A  63      33.926  32.299  13.320  1.00 41.44           C  
ATOM    414  O   LEU A  63      33.828  32.952  14.370  1.00 37.28           O  
ATOM    415  CB  LEU A  63      36.273  31.781  12.648  1.00 43.04           C  
ATOM    416  CG  LEU A  63      37.394  31.792  11.600  1.00 46.48           C  
ATOM    417  CD1 LEU A  63      38.556  30.964  12.126  1.00 52.20           C  
ATOM    418  CD2 LEU A  63      36.940  31.271  10.253  1.00 43.31           C  
ATOM    419  N   LYS A  64      33.116  31.306  12.996  1.00 45.88           N  
ATOM    420  CA  LYS A  64      32.010  30.866  13.852  1.00 49.36           C  
ATOM    421  C   LYS A  64      32.430  30.393  15.244  1.00 52.10           C  
ATOM    422  O   LYS A  64      31.573  30.166  16.102  1.00 53.10           O  
ATOM    423  CB  LYS A  64      31.247  29.740  13.157  1.00 49.33           C  
ATOM    424  CG  LYS A  64      30.568  30.169  11.858  1.00 50.70           C  
ATOM    425  N   GLN A  65      33.732  30.244  15.477  1.00 53.08           N  
ATOM    426  CA  GLN A  65      34.231  29.766  16.769  1.00 52.02           C  
ATOM    427  C   GLN A  65      33.834  30.689  17.942  1.00 50.39           C  
ATOM    428  O   GLN A  65      33.624  30.224  19.064  1.00 50.89           O  
ATOM    429  CB  GLN A  65      35.752  29.590  16.710  1.00 54.52           C  
ATOM    430  N   SER A  66      33.729  31.990  17.679  1.00 45.44           N  
ATOM    431  CA  SER A  66      33.317  32.955  18.704  1.00 43.13           C  
ATOM    432  C   SER A  66      32.175  33.762  18.151  1.00 36.14           C  
ATOM    433  O   SER A  66      31.921  33.737  16.960  1.00 38.82           O  
ATOM    434  CB  SER A  66      34.451  33.901  19.093  1.00 43.73           C  
ATOM    435  OG  SER A  66      35.468  33.225  19.801  1.00 49.44           O  
ATOM    436  N   SER A  67      31.479  34.479  19.017  1.00 34.48           N  
ATOM    437  CA  SER A  67      30.382  35.285  18.553  1.00 33.09           C  
ATOM    438  C   SER A  67      30.925  36.319  17.600  1.00 32.65           C  
ATOM    439  O   SER A  67      32.059  36.831  17.791  1.00 32.37           O  
ATOM    440  CB  SER A  67      29.664  35.964  19.707  1.00 31.98           C  
ATOM    441  OG  SER A  67      30.532  36.823  20.423  1.00 32.20           O  
ATOM    442  N   ALA A  68      30.136  36.631  16.567  1.00 30.12           N  
ATOM    443  CA  ALA A  68      30.513  37.686  15.657  1.00 30.25           C  
ATOM    444  C   ALA A  68      30.640  38.994  16.444  1.00 26.49           C  
ATOM    445  O   ALA A  68      31.559  39.767  16.191  1.00 25.81           O  
ATOM    446  CB  ALA A  68      29.487  37.817  14.524  1.00 32.34           C  
ATOM    447  N   ILE A  69      29.753  39.215  17.423  1.00 26.16           N  
ATOM    448  CA  ILE A  69      29.810  40.460  18.201  1.00 26.00           C  
ATOM    449  C   ILE A  69      31.136  40.554  18.999  1.00 25.51           C  
ATOM    450  O   ILE A  69      31.757  41.605  19.045  1.00 23.63           O  
ATOM    451  CB  ILE A  69      28.548  40.726  19.064  1.00 28.26           C  
ATOM    452  CG1 ILE A  69      28.609  42.103  19.730  1.00 29.98           C  
ATOM    453  CG2 ILE A  69      28.377  39.682  20.124  1.00 30.24           C  
ATOM    454  CD1 ILE A  69      28.646  43.295  18.761  1.00 30.81           C  
ATOM    455  N   SER A  70      31.584  39.469  19.617  1.00 24.36           N  
ATOM    456  CA  SER A  70      32.850  39.526  20.349  1.00 25.48           C  
ATOM    457  C   SER A  70      34.014  39.822  19.398  1.00 25.39           C  
ATOM    458  O   SER A  70      34.920  40.621  19.718  1.00 25.05           O  
ATOM    459  CB  SER A  70      33.131  38.221  21.093  1.00 29.00           C  
ATOM    460  OG  SER A  70      33.286  37.171  20.215  1.00 33.27           O  
ATOM    461  N   GLU A  71      33.991  39.189  18.226  1.00 23.97           N  
ATOM    462  CA  GLU A  71      35.023  39.402  17.213  1.00 23.86           C  
ATOM    463  C   GLU A  71      34.973  40.838  16.760  1.00 25.03           C  
ATOM    464  O   GLU A  71      36.016  41.471  16.528  1.00 23.76           O  
ATOM    465  CB  GLU A  71      34.784  38.459  16.033  1.00 25.34           C  
ATOM    466  CG  GLU A  71      34.961  37.039  16.412  1.00 29.73           C  
ATOM    467  CD  GLU A  71      34.348  36.008  15.450  1.00 31.01           C  
ATOM    468  OE1 GLU A  71      33.531  36.343  14.566  1.00 34.40           O  
ATOM    469  OE2 GLU A  71      34.712  34.828  15.607  1.00 37.07           O  
ATOM    470  N   PHE A  72      33.765  41.371  16.626  1.00 21.95           N  
ATOM    471  CA  PHE A  72      33.564  42.740  16.203  1.00 23.20           C  
ATOM    472  C   PHE A  72      34.090  43.733  17.219  1.00 20.90           C  
ATOM    473  O   PHE A  72      34.716  44.705  16.820  1.00 22.46           O  
ATOM    474  CB  PHE A  72      32.096  43.006  15.815  1.00 23.65           C  
ATOM    475  CG  PHE A  72      31.837  44.390  15.272  1.00 25.52           C  
ATOM    476  CD1 PHE A  72      32.590  44.894  14.228  1.00 26.22           C  
ATOM    477  CD2 PHE A  72      30.819  45.194  15.803  1.00 25.86           C  
ATOM    478  CE1 PHE A  72      32.355  46.213  13.755  1.00 29.97           C  
ATOM    479  CE2 PHE A  72      30.541  46.433  15.263  1.00 27.26           C  
ATOM    480  CZ  PHE A  72      31.309  46.938  14.262  1.00 27.86           C  
ATOM    481  N   HIS A  73      33.839  43.518  18.508  1.00 19.41           N  
ATOM    482  CA  HIS A  73      34.395  44.436  19.507  1.00 19.12           C  
ATOM    483  C   HIS A  73      35.918  44.614  19.302  1.00 20.30           C  
ATOM    484  O   HIS A  73      36.453  45.711  19.269  1.00 22.25           O  
ATOM    485  CB  HIS A  73      34.210  43.946  20.944  1.00 20.60           C  
ATOM    486  CG  HIS A  73      32.802  43.887  21.408  1.00 19.65           C  
ATOM    487  ND1 HIS A  73      31.903  44.915  21.193  1.00 22.04           N  
ATOM    488  CD2 HIS A  73      32.162  42.957  22.161  1.00 21.86           C  
ATOM    489  CE1 HIS A  73      30.759  44.593  21.791  1.00 23.52           C  
ATOM    490  NE2 HIS A  73      30.896  43.427  22.403  1.00 23.86           N  
ATOM    491  N   THR A  74      36.625  43.495  19.240  1.00 20.92           N  
ATOM    492  CA  THR A  74      38.078  43.559  19.100  1.00 22.38           C  
ATOM    493  C   THR A  74      38.481  44.172  17.760  1.00 20.84           C  
ATOM    494  O   THR A  74      39.361  45.041  17.682  1.00 22.15           O  
ATOM    495  CB  THR A  74      38.687  42.192  19.291  1.00 23.92           C  
ATOM    496  OG1 THR A  74      38.386  41.733  20.613  1.00 25.68           O  
ATOM    497  CG2 THR A  74      40.199  42.245  19.107  1.00 24.91           C  
ATOM    498  N   ALA A  75      37.820  43.752  16.674  1.00 21.69           N  
ATOM    499  CA  ALA A  75      38.128  44.310  15.355  1.00 21.38           C  
ATOM    500  C   ALA A  75      37.932  45.831  15.302  1.00 20.93           C  
ATOM    501  O   ALA A  75      38.707  46.542  14.663  1.00 20.83           O  
ATOM    502  CB  ALA A  75      37.295  43.660  14.261  1.00 23.40           C  
ATOM    503  N   LEU A  76      36.855  46.295  15.929  1.00 20.51           N  
ATOM    504  CA  LEU A  76      36.519  47.713  15.942  1.00 21.60           C  
ATOM    505  C   LEU A  76      37.561  48.507  16.757  1.00 20.23           C  
ATOM    506  O   LEU A  76      38.007  49.575  16.345  1.00 21.28           O  
ATOM    507  CB  LEU A  76      35.115  47.923  16.514  1.00 20.04           C  
ATOM    508  CG  LEU A  76      34.642  49.362  16.579  1.00 20.87           C  
ATOM    509  CD1 LEU A  76      34.595  50.075  15.195  1.00 21.68           C  
ATOM    510  CD2 LEU A  76      33.291  49.365  17.277  1.00 23.44           C  
ATOM    511  N   GLY A  77      37.895  48.011  17.941  1.00 20.85           N  
ATOM    512  CA  GLY A  77      38.892  48.670  18.774  1.00 21.08           C  
ATOM    513  C   GLY A  77      40.236  48.756  18.083  1.00 20.35           C  
ATOM    514  O   GLY A  77      40.891  49.801  18.089  1.00 21.34           O  
ATOM    515  N   GLN A  78      40.637  47.636  17.480  1.00 20.47           N  
ATOM    516  CA  GLN A  78      41.862  47.622  16.684  0.50 20.75           C  
ATOM    518  C   GLN A  78      41.783  48.657  15.554  1.00 20.89           C  
ATOM    519  O   GLN A  78      42.732  49.424  15.317  1.00 21.58           O  
ATOM    520  CB  GLN A  78      42.146  46.206  16.150  0.50 20.68           C  
ATOM    522  CG  GLN A  78      42.568  45.217  17.245  0.50 22.14           C  
ATOM    524  CD  GLN A  78      42.558  43.755  16.819  0.50 22.26           C  
ATOM    526  OE1 GLN A  78      41.890  43.377  15.862  0.50 19.43           O  
ATOM    528  NE2 GLN A  78      43.255  42.913  17.593  0.50 27.58           N  
ATOM    530  N   PHE A  79      40.665  48.716  14.862  1.00 20.17           N  
ATOM    531  CA  PHE A  79      40.513  49.624  13.759  1.00 20.31           C  
ATOM    532  C   PHE A  79      40.696  51.062  14.240  1.00 20.32           C  
ATOM    533  O   PHE A  79      41.421  51.837  13.631  1.00 21.70           O  
ATOM    534  CB  PHE A  79      39.164  49.432  13.073  1.00 19.88           C  
ATOM    535  CG  PHE A  79      38.978  50.340  11.875  1.00 20.12           C  
ATOM    536  CD1 PHE A  79      38.512  51.621  11.999  1.00 22.32           C  
ATOM    537  CD2 PHE A  79      39.351  49.902  10.604  1.00 21.67           C  
ATOM    538  CE1 PHE A  79      38.406  52.441  10.913  1.00 21.99           C  
ATOM    539  CE2 PHE A  79      39.218  50.729   9.521  1.00 23.03           C  
ATOM    540  CZ  PHE A  79      38.765  52.006   9.663  1.00 23.11           C  
ATOM    541  N   ILE A  80      39.986  51.435  15.306  1.00 20.64           N  
ATOM    542  CA  ILE A  80      40.086  52.787  15.813  1.00 20.48           C  
ATOM    543  C   ILE A  80      41.513  53.121  16.276  1.00 21.64           C  
ATOM    544  O   ILE A  80      42.014  54.194  15.975  1.00 21.01           O  
ATOM    545  CB  ILE A  80      39.037  53.007  16.941  1.00 21.76           C  
ATOM    546  CG1 ILE A  80      37.648  52.952  16.295  0.50 22.48           C  
ATOM    548  CG2 ILE A  80      39.273  54.367  17.611  1.00 21.23           C  
ATOM    549  CD1 ILE A  80      36.548  52.972  17.277  0.50 25.16           C  
ATOM    551  N   ASN A  81      42.157  52.200  16.992  1.00 21.16           N  
ATOM    552  CA  ASN A  81      43.523  52.430  17.433  1.00 21.20           C  
ATOM    553  C   ASN A  81      44.490  52.526  16.280  1.00 22.30           C  
ATOM    554  O   ASN A  81      45.328  53.440  16.217  1.00 21.99           O  
ATOM    555  CB  ASN A  81      43.946  51.339  18.407  1.00 20.52           C  
ATOM    556  CG  ASN A  81      43.448  51.574  19.820  1.00 22.28           C  
ATOM    557  OD1 ASN A  81      43.159  50.627  20.564  1.00 25.53           O  
ATOM    558  ND2 ASN A  81      43.355  52.767  20.222  1.00 20.53           N  
ATOM    559  N   TYR A  82      44.410  51.598  15.348  1.00 21.19           N  
ATOM    560  CA  TYR A  82      45.300  51.652  14.185  1.00 21.67           C  
ATOM    561  C   TYR A  82      45.059  52.885  13.351  1.00 21.83           C  
ATOM    562  O   TYR A  82      46.022  53.515  12.900  1.00 21.71           O  
ATOM    563  CB  TYR A  82      45.220  50.384  13.317  1.00 21.46           C  
ATOM    564  CG  TYR A  82      45.582  49.087  14.003  1.00 24.98           C  
ATOM    565  CD1 TYR A  82      46.507  49.028  15.016  1.00 29.95           C  
ATOM    566  CD2 TYR A  82      44.957  47.927  13.595  1.00 27.56           C  
ATOM    567  CE1 TYR A  82      46.804  47.817  15.638  1.00 33.10           C  
ATOM    568  CE2 TYR A  82      45.256  46.721  14.170  1.00 30.22           C  
ATOM    569  CZ  TYR A  82      46.175  46.665  15.185  1.00 34.68           C  
ATOM    570  OH  TYR A  82      46.452  45.462  15.799  1.00 36.91           O  
ATOM    571  N   ARG A  83      43.803  53.259  13.150  1.00 20.48           N  
ATOM    572  CA  ARG A  83      43.506  54.443  12.371  1.00 21.41           C  
ATOM    573  C   ARG A  83      44.108  55.674  13.048  1.00 19.40           C  
ATOM    574  O   ARG A  83      44.726  56.536  12.381  1.00 20.07           O  
ATOM    575  CB  ARG A  83      42.003  54.604  12.215  1.00 22.21           C  
ATOM    576  CG  ARG A  83      41.650  55.877  11.438  1.00 20.95           C  
ATOM    577  CD  ARG A  83      40.173  56.022  11.152  1.00 21.03           C  
ATOM    578  NE  ARG A  83      39.393  56.128  12.377  1.00 20.16           N  
ATOM    579  CZ  ARG A  83      38.064  56.081  12.399  1.00 22.34           C  
ATOM    580  NH1 ARG A  83      37.359  55.868  11.287  1.00 22.73           N  
ATOM    581  NH2 ARG A  83      37.453  56.188  13.579  1.00 25.77           N  
ATOM    582  N   GLY A  84      43.916  55.777  14.367  1.00 20.99           N  
ATOM    583  CA  GLY A  84      44.390  56.920  15.114  1.00 21.21           C  
ATOM    584  C   GLY A  84      45.915  56.987  15.096  1.00 20.80           C  
ATOM    585  O   GLY A  84      46.510  58.064  15.000  1.00 21.39           O  
ATOM    586  N   ALA A  85      46.567  55.828  15.201  1.00 20.54           N  
ATOM    587  CA  ALA A  85      48.026  55.781  15.150  1.00 21.47           C  
ATOM    588  C   ALA A  85      48.529  56.175  13.748  1.00 21.92           C  
ATOM    589  O   ALA A  85      49.474  56.947  13.612  1.00 21.06           O  
ATOM    590  CB  ALA A  85      48.509  54.392  15.529  1.00 23.49           C  
ATOM    591  N   LEU A  86      47.922  55.643  12.706  1.00 21.80           N  
ATOM    592  CA  LEU A  86      48.360  55.940  11.342  1.00 20.62           C  
ATOM    593  C   LEU A  86      48.249  57.437  11.009  1.00 19.88           C  
ATOM    594  O   LEU A  86      49.068  57.950  10.276  1.00 20.63           O  
ATOM    595  CB  LEU A  86      47.579  55.106  10.317  1.00 24.91           C  
ATOM    596  CG  LEU A  86      48.024  53.662  10.318  1.00 23.94           C  
ATOM    597  CD1 LEU A  86      47.012  52.787   9.518  1.00 28.77           C  
ATOM    598  CD2 LEU A  86      49.424  53.528   9.658  1.00 27.59           C  
ATOM    599  N   ARG A  87      47.232  58.120  11.524  1.00 20.78           N  
ATOM    600  CA  ARG A  87      47.118  59.546  11.298  1.00 20.82           C  
ATOM    601  C   ARG A  87      48.386  60.269  11.699  1.00 20.07           C  
ATOM    602  O   ARG A  87      48.793  61.210  11.054  1.00 22.37           O  
ATOM    603  CB  ARG A  87      45.993  60.188  12.117  1.00 25.27           C  
ATOM    604  CG  ARG A  87      44.682  59.992  11.626  1.00 29.43           C  
ATOM    605  CD  ARG A  87      43.689  60.821  12.455  1.00 25.19           C  
ATOM    606  NE  ARG A  87      42.427  60.222  12.160  1.00 25.56           N  
ATOM    607  CZ  ARG A  87      41.386  60.216  12.965  1.00 27.89           C  
ATOM    608  NH1 ARG A  87      41.374  60.811  14.157  1.00 25.57           N  
ATOM    609  NH2 ARG A  87      40.292  59.591  12.516  1.00 29.11           N  
ATOM    610  N   LYS A  88      48.971  59.835  12.817  1.00 20.81           N  
ATOM    611  CA  LYS A  88      50.128  60.469  13.414  1.00 20.37           C  
ATOM    612  C   LYS A  88      51.477  59.880  12.989  1.00 20.25           C  
ATOM    613  O   LYS A  88      52.539  60.378  13.423  1.00 22.62           O  
ATOM    614  CB  LYS A  88      49.962  60.413  14.929  1.00 20.24           C  
ATOM    615  CG  LYS A  88      48.640  61.041  15.433  1.00 25.65           C  
ATOM    616  CD  LYS A  88      48.603  62.534  15.302  1.00 24.75           C  
ATOM    617  CE  LYS A  88      47.323  63.118  15.923  1.00 23.98           C  
ATOM    618  NZ  LYS A  88      46.074  62.913  15.066  1.00 21.41           N  
ATOM    619  N   VAL A  89      51.457  58.908  12.082  1.00 20.69           N  
ATOM    620  CA  VAL A  89      52.669  58.264  11.604  1.00 21.62           C  
ATOM    621  C   VAL A  89      52.766  58.227  10.061  1.00 21.79           C  
ATOM    622  O   VAL A  89      53.781  58.584   9.474  1.00 23.06           O  
ATOM    623  CB  VAL A  89      52.781  56.841  12.181  1.00 24.37           C  
ATOM    624  CG1 VAL A  89      54.046  56.183  11.661  1.00 29.77           C  
ATOM    625  CG2 VAL A  89      52.848  56.910  13.683  1.00 26.93           C  
ATOM    626  N   GLU A  90      51.700  57.785   9.408  1.00 20.34           N  
ATOM    627  CA  GLU A  90      51.662  57.712   7.966  0.50 19.93           C  
ATOM    629  C   GLU A  90      50.254  58.168   7.504  1.00 20.32           C  
ATOM    630  O   GLU A  90      49.370  57.378   7.149  1.00 19.85           O  
ATOM    631  CB  GLU A  90      52.013  56.293   7.521  0.50 22.82           C  
ATOM    633  CG  GLU A  90      52.425  56.235   6.093  0.50 22.17           C  
ATOM    635  CD  GLU A  90      52.919  54.876   5.689  0.50 20.00           C  
ATOM    637  OE1 GLU A  90      52.707  53.891   6.476  0.50 25.83           O  
ATOM    639  OE2 GLU A  90      53.514  54.842   4.591  0.50 24.38           O  
ATOM    641  N   PRO A  91      50.049  59.480   7.516  1.00 21.06           N  
ATOM    642  CA  PRO A  91      48.736  60.031   7.274  1.00 21.21           C  
ATOM    643  C   PRO A  91      48.184  59.873   5.877  1.00 22.28           C  
ATOM    644  O   PRO A  91      46.997  60.101   5.698  1.00 25.02           O  
ATOM    645  CB  PRO A  91      48.947  61.525   7.589  1.00 23.74           C  
ATOM    646  CG  PRO A  91      50.357  61.773   7.331  1.00 24.64           C  
ATOM    647  CD  PRO A  91      51.043  60.534   7.795  1.00 24.22           C  
ATOM    648  N   ASP A  92      49.019  59.447   4.927  1.00 21.83           N  
ATOM    649  CA  ASP A  92      48.497  59.174   3.601  1.00 22.04           C  
ATOM    650  C   ASP A  92      48.078  57.734   3.400  1.00 23.48           C  
ATOM    651  O   ASP A  92      47.590  57.391   2.322  1.00 23.70           O  
ATOM    652  CB  ASP A  92      49.522  59.571   2.548  1.00 21.76           C  
ATOM    653  CG  ASP A  92      49.716  61.069   2.502  1.00 31.21           C  
ATOM    654  OD1 ASP A  92      48.698  61.780   2.361  1.00 30.51           O  
ATOM    655  OD2 ASP A  92      50.864  61.538   2.595  1.00 40.45           O  
ATOM    656  N   ARG A  93      48.235  56.895   4.411  1.00 19.70           N  
ATOM    657  CA  ARG A  93      47.899  55.486   4.291  1.00 21.02           C  
ATOM    658  C   ARG A  93      46.574  55.254   4.930  1.00 20.88           C  
ATOM    659  O   ARG A  93      46.397  55.387   6.166  1.00 22.60           O  
ATOM    660  CB  ARG A  93      48.986  54.610   4.897  1.00 20.26           C  
ATOM    661  CG  ARG A  93      48.706  53.160   4.703  1.00 22.01           C  
ATOM    662  CD  ARG A  93      49.830  52.247   5.221  1.00 22.69           C  
ATOM    663  NE  ARG A  93      51.122  52.550   4.637  1.00 24.46           N  
ATOM    664  CZ  ARG A  93      51.486  52.211   3.410  1.00 24.66           C  
ATOM    665  NH1 ARG A  93      50.702  51.502   2.589  1.00 23.19           N  
ATOM    666  NH2 ARG A  93      52.705  52.527   2.986  1.00 25.87           N  
ATOM    667  N   VAL A  94      45.602  54.875   4.106  1.00 20.00           N  
ATOM    668  CA  VAL A  94      44.220  54.723   4.551  1.00 20.00           C  
ATOM    669  C   VAL A  94      43.931  53.311   5.016  1.00 20.34           C  
ATOM    670  O   VAL A  94      44.176  52.359   4.306  1.00 21.49           O  
ATOM    671  CB  VAL A  94      43.259  55.116   3.414  1.00 21.89           C  
ATOM    672  CG1 VAL A  94      41.823  54.976   3.814  1.00 23.41           C  
ATOM    673  CG2 VAL A  94      43.544  56.556   2.987  1.00 24.59           C  
ATOM    674  N   LEU A  95      43.351  53.196   6.210  1.00 20.82           N  
ATOM    675  CA  LEU A  95      43.024  51.898   6.808  1.00 19.90           C  
ATOM    676  C   LEU A  95      41.657  51.358   6.423  1.00 21.51           C  
ATOM    677  O   LEU A  95      40.646  52.085   6.470  1.00 21.45           O  
ATOM    678  CB  LEU A  95      43.057  52.032   8.326  1.00 20.89           C  
ATOM    679  CG  LEU A  95      42.833  50.768   9.128  1.00 22.40           C  
ATOM    680  CD1 LEU A  95      43.942  49.782   8.926  1.00 23.87           C  
ATOM    681  CD2 LEU A  95      42.664  51.100  10.593  1.00 22.34           C  
ATOM    682  N   TYR A  96      41.657  50.066   6.081  1.00 21.33           N  
ATOM    683  CA  TYR A  96      40.435  49.328   5.761  1.00 20.89           C  
ATOM    684  C   TYR A  96      40.324  48.081   6.644  1.00 21.66           C  
ATOM    685  O   TYR A  96      41.339  47.429   6.894  1.00 21.13           O  
ATOM    686  CB  TYR A  96      40.436  48.870   4.271  1.00 20.61           C  
ATOM    687  CG  TYR A  96      40.311  50.003   3.331  1.00 19.62           C  
ATOM    688  CD1 TYR A  96      41.451  50.739   2.983  1.00 21.65           C  
ATOM    689  CD2 TYR A  96      39.077  50.406   2.816  1.00 21.25           C  
ATOM    690  CE1 TYR A  96      41.363  51.838   2.176  1.00 21.24           C  
ATOM    691  CE2 TYR A  96      38.987  51.528   2.001  1.00 21.59           C  
ATOM    692  CZ  TYR A  96      40.129  52.241   1.692  1.00 23.14           C  
ATOM    693  OH  TYR A  96      40.063  53.361   0.861  1.00 24.39           O  
ATOM    694  N   LEU A  97      39.103  47.767   7.054  1.00 21.04           N  
ATOM    695  CA  LEU A  97      38.784  46.488   7.727  1.00 21.55           C  
ATOM    696  C   LEU A  97      38.409  45.530   6.621  1.00 21.06           C  
ATOM    697  O   LEU A  97      37.411  45.741   5.917  1.00 21.70           O  
ATOM    698  CB  LEU A  97      37.652  46.645   8.715  1.00 21.45           C  
ATOM    699  CG  LEU A  97      37.182  45.379   9.395  1.00 21.03           C  
ATOM    700  CD1 LEU A  97      38.258  44.848  10.310  1.00 25.13           C  
ATOM    701  CD2 LEU A  97      35.922  45.679  10.159  1.00 23.65           C  
ATOM    702  N   ALA A  98      39.148  44.435   6.499  1.00 21.38           N  
ATOM    703  CA  ALA A  98      38.827  43.405   5.479  1.00 21.81           C  
ATOM    704  C   ALA A  98      37.861  42.386   6.095  1.00 22.96           C  
ATOM    705  O   ALA A  98      38.147  41.820   7.126  1.00 23.61           O  
ATOM    706  CB  ALA A  98      40.084  42.708   5.000  1.00 22.55           C  
ATOM    707  N   VAL A  99      36.715  42.206   5.457  1.00 21.42           N  
ATOM    708  CA  VAL A  99      35.611  41.382   5.923  0.50 22.64           C  
ATOM    710  C   VAL A  99      35.260  40.339   4.823  1.00 22.42           C  
ATOM    711  O   VAL A  99      35.097  40.745   3.685  1.00 22.42           O  
ATOM    712  CB  VAL A  99      34.362  42.350   6.083  0.50 22.40           C  
ATOM    714  CG1 VAL A  99      33.134  41.648   6.630  0.50 22.37           C  
ATOM    716  CG2 VAL A  99      34.682  43.569   6.964  0.50 22.93           C  
ATOM    718  N   PRO A 100      35.059  39.086   5.159  1.00 22.13           N  
ATOM    719  CA  PRO A 100      34.531  38.164   4.137  1.00 22.66           C  
ATOM    720  C   PRO A 100      33.144  38.557   3.649  1.00 22.80           C  
ATOM    721  O   PRO A 100      32.342  39.141   4.380  1.00 22.84           O  
ATOM    722  CB  PRO A 100      34.478  36.830   4.885  1.00 23.29           C  
ATOM    723  CG  PRO A 100      35.493  36.943   5.933  1.00 25.77           C  
ATOM    724  CD  PRO A 100      35.402  38.349   6.401  1.00 24.25           C  
ATOM    725  N   LEU A 101      32.844  38.250   2.406  1.00 22.15           N  
ATOM    726  CA  LEU A 101      31.567  38.562   1.825  1.00 21.53           C  
ATOM    727  C   LEU A 101      30.436  37.926   2.595  1.00 21.64           C  
ATOM    728  O   LEU A 101      29.384  38.528   2.728  1.00 22.82           O  
ATOM    729  CB  LEU A 101      31.517  38.053   0.390  1.00 24.10           C  
ATOM    730  CG  LEU A 101      30.269  38.410  -0.403  1.00 21.88           C  
ATOM    731  CD1 LEU A 101      29.874  39.884  -0.352  1.00 27.29           C  
ATOM    732  CD2 LEU A 101      30.489  37.920  -1.870  1.00 26.81           C  
ATOM    733  N   THR A 102      30.628  36.693   3.045  1.00 23.92           N  
ATOM    734  CA  THR A 102      29.578  36.008   3.827  1.00 24.69           C  
ATOM    735  C   THR A 102      29.246  36.800   5.091  1.00 23.05           C  
ATOM    736  O   THR A 102      28.071  36.983   5.412  1.00 24.64           O  
ATOM    737  CB  THR A 102      29.931  34.566   4.176  1.00 23.88           C  
ATOM    738  OG1 THR A 102      31.143  34.492   4.921  1.00 27.85           O  
ATOM    739  CG2 THR A 102      30.027  33.723   2.895  1.00 27.80           C  
ATOM    740  N   THR A 103      30.278  37.276   5.776  1.00 22.54           N  
ATOM    741  CA  THR A 103      30.099  38.089   6.974  1.00 22.81           C  
ATOM    742  C   THR A 103      29.429  39.414   6.647  1.00 23.32           C  
ATOM    743  O   THR A 103      28.514  39.887   7.369  1.00 24.21           O  
ATOM    744  CB  THR A 103      31.466  38.376   7.579  1.00 25.08           C  
ATOM    745  OG1 THR A 103      32.195  37.140   7.696  1.00 24.96           O  
ATOM    746  CG2 THR A 103      31.335  39.047   8.952  1.00 26.63           C  
ATOM    747  N   TYR A 104      29.895  40.032   5.562  1.00 23.86           N  
ATOM    748  CA  TYR A 104      29.344  41.280   5.086  1.00 22.07           C  
ATOM    749  C   TYR A 104      27.827  41.178   4.825  1.00 24.12           C  
ATOM    750  O   TYR A 104      27.073  42.069   5.162  1.00 24.49           O  
ATOM    751  CB  TYR A 104      30.078  41.749   3.804  1.00 24.06           C  
ATOM    752  CG  TYR A 104      29.537  43.063   3.286  1.00 23.73           C  
ATOM    753  CD1 TYR A 104      29.720  44.247   4.001  1.00 27.67           C  
ATOM    754  CD2 TYR A 104      28.856  43.113   2.095  1.00 27.03           C  
ATOM    755  CE1 TYR A 104      29.196  45.446   3.537  1.00 28.67           C  
ATOM    756  CE2 TYR A 104      28.335  44.298   1.610  1.00 31.33           C  
ATOM    757  CZ  TYR A 104      28.526  45.468   2.329  1.00 31.47           C  
ATOM    758  OH  TYR A 104      27.995  46.635   1.820  1.00 39.69           O  
ATOM    759  N   LYS A 105      27.413  40.094   4.192  1.00 24.21           N  
ATOM    760  CA  LYS A 105      26.010  39.883   3.807  1.00 25.80           C  
ATOM    761  C   LYS A 105      25.112  39.479   4.956  1.00 27.17           C  
ATOM    762  O   LYS A 105      23.898  39.545   4.809  1.00 27.97           O  
ATOM    763  CB  LYS A 105      25.909  38.844   2.689  1.00 24.49           C  
ATOM    764  CG  LYS A 105      26.524  39.307   1.381  1.00 29.15           C  
ATOM    765  CD  LYS A 105      26.521  38.220   0.310  1.00 35.75           C  
ATOM    766  CE  LYS A 105      25.178  37.993  -0.291  1.00 46.58           C  
ATOM    767  NZ  LYS A 105      25.393  37.093  -1.444  1.00 50.01           N  
ATOM    768  N   THR A 106      25.703  39.046   6.068  1.00 23.13           N  
ATOM    769  CA  THR A 106      24.943  38.589   7.215  1.00 23.36           C  
ATOM    770  C   THR A 106      25.100  39.551   8.393  1.00 22.87           C  
ATOM    771  O   THR A 106      24.276  40.473   8.555  1.00 24.94           O  
ATOM    772  CB  THR A 106      25.297  37.139   7.555  1.00 23.50           C  
ATOM    773  OG1 THR A 106      26.696  36.980   7.835  1.00 26.26           O  
ATOM    774  CG2 THR A 106      24.946  36.256   6.394  1.00 25.02           C  
ATOM    775  N   PHE A 107      26.159  39.380   9.180  1.00 22.65           N  
ATOM    776  CA  PHE A 107      26.381  40.201  10.354  1.00 22.93           C  
ATOM    777  C   PHE A 107      26.333  41.679  10.031  1.00 22.09           C  
ATOM    778  O   PHE A 107      25.707  42.464  10.741  1.00 23.36           O  
ATOM    779  CB  PHE A 107      27.721  39.839  10.984  1.00 23.51           C  
ATOM    780  CG  PHE A 107      28.036  40.617  12.241  1.00 23.99           C  
ATOM    781  CD1 PHE A 107      27.361  40.342  13.392  1.00 23.96           C  
ATOM    782  CD2 PHE A 107      28.982  41.629  12.254  1.00 23.26           C  
ATOM    783  CE1 PHE A 107      27.637  41.075  14.561  1.00 24.03           C  
ATOM    784  CE2 PHE A 107      29.244  42.347  13.403  1.00 25.42           C  
ATOM    785  CZ  PHE A 107      28.579  42.037  14.562  1.00 25.99           C  
ATOM    786  N   PHE A 108      27.046  42.090   8.989  1.00 21.83           N  
ATOM    787  CA  PHE A 108      27.088  43.518   8.687  1.00 23.21           C  
ATOM    788  C   PHE A 108      25.822  44.077   8.022  1.00 23.36           C  
ATOM    789  O   PHE A 108      25.774  45.294   7.814  1.00 25.70           O  
ATOM    790  CB  PHE A 108      28.367  43.921   7.966  1.00 25.00           C  
ATOM    791  CG  PHE A 108      29.575  43.857   8.845  1.00 24.76           C  
ATOM    792  CD1 PHE A 108      29.734  44.782   9.857  1.00 27.43           C  
ATOM    793  CD2 PHE A 108      30.472  42.816   8.749  1.00 27.16           C  
ATOM    794  CE1 PHE A 108      30.800  44.703  10.728  1.00 28.75           C  
ATOM    795  CE2 PHE A 108      31.560  42.728   9.605  1.00 25.56           C  
ATOM    796  CZ  PHE A 108      31.736  43.682  10.577  1.00 25.59           C  
ATOM    797  N   GLN A 109      24.822  43.244   7.768  1.00 24.96           N  
ATOM    798  CA  GLN A 109      23.515  43.719   7.302  1.00 26.62           C  
ATOM    799  C   GLN A 109      22.529  43.833   8.446  1.00 25.96           C  
ATOM    800  O   GLN A 109      21.442  44.368   8.269  1.00 28.80           O  
ATOM    801  CB  GLN A 109      22.972  42.862   6.162  1.00 27.22           C  
ATOM    802  CG  GLN A 109      23.921  42.895   4.955  1.00 28.01           C  
ATOM    803  CD  GLN A 109      24.336  44.318   4.547  1.00 31.98           C  
ATOM    804  OE1 GLN A 109      23.476  45.187   4.353  1.00 38.63           O  
ATOM    805  NE2 GLN A 109      25.637  44.565   4.435  1.00 31.44           N  
ATOM    806  N   LEU A 110      22.898  43.344   9.631  1.00 24.90           N  
ATOM    807  CA  LEU A 110      22.097  43.560  10.813  1.00 23.56           C  
ATOM    808  C   LEU A 110      22.155  45.065  11.143  1.00 22.64           C  
ATOM    809  O   LEU A 110      23.171  45.730  10.919  1.00 23.82           O  
ATOM    810  CB  LEU A 110      22.592  42.729  11.987  1.00 22.32           C  
ATOM    811  CG  LEU A 110      22.495  41.210  11.823  1.00 24.58           C  
ATOM    812  CD1 LEU A 110      23.232  40.534  12.969  1.00 25.56           C  
ATOM    813  CD2 LEU A 110      21.050  40.759  11.741  1.00 31.31           C  
ATOM    814  N   ASP A 111      21.044  45.595  11.645  1.00 24.86           N  
ATOM    815  CA  ASP A 111      20.915  47.030  11.870  1.00 24.43           C  
ATOM    816  C   ASP A 111      22.017  47.614  12.761  1.00 22.12           C  
ATOM    817  O   ASP A 111      22.601  48.633  12.430  1.00 23.04           O  
ATOM    818  CB  ASP A 111      19.560  47.374  12.470  1.00 24.07           C  
ATOM    819  CG  ASP A 111      18.401  47.235  11.487  1.00 27.45           C  
ATOM    820  OD1 ASP A 111      18.624  47.093  10.276  1.00 30.76           O  
ATOM    821  OD2 ASP A 111      17.260  47.309  11.974  1.00 33.79           O  
ATOM    822  N   PHE A 112      22.327  46.941  13.848  1.00 21.61           N  
ATOM    823  CA  PHE A 112      23.309  47.502  14.791  1.00 21.06           C  
ATOM    824  C   PHE A 112      24.730  47.590  14.208  1.00 22.08           C  
ATOM    825  O   PHE A 112      25.333  48.668  14.203  1.00 21.71           O  
ATOM    826  CB  PHE A 112      23.255  46.780  16.125  1.00 22.06           C  
ATOM    827  CG  PHE A 112      24.328  47.217  17.066  1.00 20.66           C  
ATOM    828  CD1 PHE A 112      24.201  48.392  17.740  1.00 24.67           C  
ATOM    829  CD2 PHE A 112      25.508  46.506  17.161  1.00 24.29           C  
ATOM    830  CE1 PHE A 112      25.205  48.808  18.586  1.00 26.90           C  
ATOM    831  CE2 PHE A 112      26.530  46.945  18.003  1.00 28.94           C  
ATOM    832  CZ  PHE A 112      26.369  48.084  18.684  1.00 25.42           C  
ATOM    833  N   PRO A 113      25.304  46.464  13.735  1.00 22.08           N  
ATOM    834  CA  PRO A 113      26.664  46.574  13.184  1.00 22.08           C  
ATOM    835  C   PRO A 113      26.736  47.516  12.013  1.00 22.79           C  
ATOM    836  O   PRO A 113      27.709  48.265  11.874  1.00 22.93           O  
ATOM    837  CB  PRO A 113      26.969  45.152  12.696  1.00 25.00           C  
ATOM    838  CG  PRO A 113      26.055  44.287  13.439  1.00 24.44           C  
ATOM    839  CD  PRO A 113      24.822  45.073  13.767  1.00 24.61           C  
ATOM    840  N   LYS A 114      25.720  47.470  11.156  1.00 23.45           N  
ATOM    841  CA  LYS A 114      25.694  48.377  10.031  1.00 24.00           C  
ATOM    842  C   LYS A 114      25.795  49.836  10.521  1.00 24.78           C  
ATOM    843  O   LYS A 114      26.573  50.626  10.025  1.00 24.37           O  
ATOM    844  CB  LYS A 114      24.432  48.169   9.186  1.00 24.22           C  
ATOM    845  CG  LYS A 114      24.312  49.137   8.034  1.00 27.09           C  
ATOM    846  CD  LYS A 114      22.999  48.935   7.248  1.00 31.38           C  
ATOM    847  CE  LYS A 114      23.016  47.670   6.393  1.00 43.29           C  
ATOM    848  NZ  LYS A 114      23.959  47.761   5.235  1.00 52.34           N  
ATOM    849  N   GLU A 115      25.000  50.183  11.516  1.00 21.47           N  
ATOM    850  CA  GLU A 115      25.001  51.568  12.051  1.00 21.19           C  
ATOM    851  C   GLU A 115      26.343  51.923  12.716  1.00 22.63           C  
ATOM    852  O   GLU A 115      26.877  53.022  12.530  1.00 22.64           O  
ATOM    853  CB  GLU A 115      23.810  51.768  12.974  1.00 21.07           C  
ATOM    854  CG  GLU A 115      23.741  53.105  13.667  1.00 22.79           C  
ATOM    855  CD  GLU A 115      23.445  54.266  12.732  1.00 21.83           C  
ATOM    856  OE1 GLU A 115      22.966  54.042  11.606  1.00 25.62           O  
ATOM    857  OE2 GLU A 115      23.646  55.420  13.215  1.00 22.78           O  
ATOM    858  N   ILE A 116      26.898  51.008  13.520  1.00 21.37           N  
ATOM    859  CA  ILE A 116      28.165  51.319  14.168  1.00 22.65           C  
ATOM    860  C   ILE A 116      29.298  51.574  13.179  1.00 21.63           C  
ATOM    861  O   ILE A 116      30.092  52.503  13.312  1.00 21.37           O  
ATOM    862  CB  ILE A 116      28.582  50.194  15.130  1.00 23.25           C  
ATOM    863  CG1 ILE A 116      27.654  50.169  16.312  1.00 25.51           C  
ATOM    864  CG2 ILE A 116      30.057  50.398  15.555  1.00 27.84           C  
ATOM    865  CD1 ILE A 116      27.647  51.448  17.223  1.00 25.41           C  
ATOM    866  N   ILE A 117      29.348  50.766  12.119  1.00 20.76           N  
ATOM    867  CA  ILE A 117      30.327  50.937  11.061  1.00 21.90           C  
ATOM    868  C   ILE A 117      30.222  52.315  10.450  1.00 21.95           C  
ATOM    869  O   ILE A 117      31.225  53.019  10.266  1.00 22.00           O  
ATOM    870  CB  ILE A 117      30.119  49.863   9.964  1.00 22.88           C  
ATOM    871  CG1 ILE A 117      30.592  48.481  10.452  1.00 23.69           C  
ATOM    872  CG2 ILE A 117      30.792  50.237   8.669  1.00 23.86           C  
ATOM    873  CD1 ILE A 117      32.083  48.331  10.602  1.00 23.54           C  
ATOM    874  N   ILE A 118      29.007  52.729  10.111  1.00 21.41           N  
ATOM    875  CA  ILE A 118      28.796  54.015   9.483  0.80 22.22           C  
ATOM    877  C   ILE A 118      29.077  55.138  10.473  1.00 22.59           C  
ATOM    878  O   ILE A 118      29.703  56.148  10.142  1.00 23.72           O  
ATOM    879  CB  ILE A 118      27.361  54.131   8.949  0.80 23.99           C  
ATOM    881  CG1 ILE A 118      27.115  53.069   7.884  0.80 28.98           C  
ATOM    883  CG2 ILE A 118      27.154  55.511   8.399  0.80 29.43           C  
ATOM    885  CD1 ILE A 118      25.668  52.863   7.580  0.80 29.86           C  
ATOM    887  N   GLU A 119      28.632  54.967  11.732  1.00 20.39           N  
ATOM    888  CA  GLU A 119      28.875  56.040  12.691  1.00 21.16           C  
ATOM    889  C   GLU A 119      30.343  56.313  12.949  1.00 21.78           C  
ATOM    890  O   GLU A 119      30.735  57.401  13.366  1.00 23.80           O  
ATOM    891  CB  GLU A 119      28.190  55.756  14.037  1.00 21.69           C  
ATOM    892  CG  GLU A 119      26.680  55.768  14.058  1.00 19.80           C  
ATOM    893  CD  GLU A 119      26.029  55.512  15.438  1.00 21.63           C  
ATOM    894  OE1 GLU A 119      26.741  55.376  16.452  1.00 22.23           O  
ATOM    895  OE2 GLU A 119      24.765  55.486  15.468  1.00 21.85           O  
ATOM    896  N   ASN A 120      31.168  55.270  12.766  1.00 22.01           N  
ATOM    897  CA  ASN A 120      32.585  55.344  13.045  1.00 21.14           C  
ATOM    898  C   ASN A 120      33.481  55.386  11.807  1.00 22.67           C  
ATOM    899  O   ASN A 120      34.698  55.259  11.907  1.00 23.28           O  
ATOM    900  CB  ASN A 120      32.969  54.189  13.980  1.00 21.94           C  
ATOM    901  CG  ASN A 120      32.402  54.414  15.349  1.00 22.01           C  
ATOM    902  OD1 ASN A 120      32.986  55.180  16.147  1.00 23.70           O  
ATOM    903  ND2 ASN A 120      31.213  53.893  15.602  1.00 20.88           N  
ATOM    904  N   GLN A 121      32.870  55.601  10.654  1.00 21.54           N  
ATOM    905  CA  GLN A 121      33.644  55.676   9.383  1.00 23.50           C  
ATOM    906  C   GLN A 121      34.584  54.491   9.173  1.00 23.01           C  
ATOM    907  O   GLN A 121      35.743  54.643   8.721  1.00 23.35           O  
ATOM    908  CB  GLN A 121      34.423  56.987   9.257  1.00 25.90           C  
ATOM    909  CG  GLN A 121      33.582  58.194   9.387  1.00 27.90           C  
ATOM    910  CD  GLN A 121      33.258  58.537  10.836  1.00 28.02           C  
ATOM    911  OE1 GLN A 121      34.097  58.398  11.776  1.00 30.23           O  
ATOM    912  NE2 GLN A 121      32.007  58.997  11.046  1.00 32.97           N  
ATOM    913  N   VAL A 122      34.096  53.318   9.491  1.00 21.43           N  
ATOM    914  CA  VAL A 122      34.882  52.114   9.340  1.00 21.44           C  
ATOM    915  C   VAL A 122      34.873  51.681   7.868  1.00 22.92           C  
ATOM    916  O   VAL A 122      33.963  50.959   7.406  1.00 24.71           O  
ATOM    917  CB  VAL A 122      34.424  50.991  10.252  1.00 21.99           C  
ATOM    918  CG1 VAL A 122      35.359  49.779  10.079  1.00 24.75           C  
ATOM    919  CG2 VAL A 122      34.409  51.467  11.725  1.00 22.88           C  
ATOM    920  N   LYS A 123      35.924  52.062   7.155  1.00 21.23           N  
ATOM    921  CA  LYS A 123      36.085  51.686   5.766  1.00 21.43           C  
ATOM    922  C   LYS A 123      36.331  50.191   5.677  1.00 21.24           C  
ATOM    923  O   LYS A 123      37.042  49.625   6.515  1.00 22.19           O  
ATOM    924  CB  LYS A 123      37.248  52.456   5.169  1.00 21.81           C  
ATOM    925  CG  LYS A 123      37.040  53.948   5.143  1.00 21.27           C  
ATOM    926  CD  LYS A 123      38.270  54.648   4.546  1.00 23.64           C  
ATOM    927  CE  LYS A 123      38.163  56.181   4.500  1.00 26.54           C  
ATOM    928  NZ  LYS A 123      37.288  56.604   3.381  1.00 30.98           N  
HETATM  929  N   MSE A 124      35.792  49.565   4.624  1.00 22.33           N  
HETATM  930  CA  MSE A 124      35.853  48.123   4.509  0.50 19.27           C  
HETATM  932  C   MSE A 124      36.352  47.649   3.148  1.00 21.61           C  
HETATM  933  O   MSE A 124      36.085  48.284   2.115  1.00 22.32           O  
HETATM  934  CB  MSE A 124      34.449  47.519   4.796  0.50 22.80           C  
HETATM  936  CG  MSE A 124      33.930  47.811   6.219  0.50 18.31           C  
HETATM  938 SE   MSE A 124      32.216  46.856   6.430  0.37 22.53          SE  
HETATM  940  CE  MSE A 124      31.205  48.003   5.531  0.50 27.54           C  
ATOM    942  N   LEU A 125      37.027  46.514   3.182  1.00 21.43           N  
ATOM    943  CA  LEU A 125      37.449  45.777   1.986  1.00 21.15           C  
ATOM    944  C   LEU A 125      36.683  44.462   2.113  1.00 22.73           C  
ATOM    945  O   LEU A 125      36.987  43.639   2.969  1.00 23.20           O  
ATOM    946  CB  LEU A 125      38.953  45.541   1.955  1.00 22.37           C  
ATOM    947  CG  LEU A 125      39.604  44.839   0.777  1.00 22.27           C  
ATOM    948  CD1 LEU A 125      41.126  44.718   1.024  1.00 22.88           C  
ATOM    949  CD2 LEU A 125      39.054  43.493   0.503  1.00 26.02           C  
ATOM    950  N   VAL A 126      35.669  44.267   1.258  1.00 21.74           N  
ATOM    951  CA  VAL A 126      34.870  43.042   1.303  1.00 21.68           C  
ATOM    952  C   VAL A 126      35.461  42.098   0.270  1.00 20.74           C  
ATOM    953  O   VAL A 126      35.577  42.436  -0.922  1.00 22.22           O  
ATOM    954  CB  VAL A 126      33.406  43.313   0.963  1.00 21.48           C  
ATOM    955  CG1 VAL A 126      32.594  42.087   1.105  1.00 25.81           C  
ATOM    956  CG2 VAL A 126      32.827  44.396   1.913  1.00 23.17           C  
ATOM    957  N   TYR A 127      35.873  40.947   0.759  1.00 20.39           N  
ATOM    958  CA  TYR A 127      36.551  39.941  -0.087  1.00 21.57           C  
ATOM    959  C   TYR A 127      35.825  38.622  -0.071  1.00 23.28           C  
ATOM    960  O   TYR A 127      35.226  38.253   0.897  1.00 22.27           O  
ATOM    961  CB  TYR A 127      38.011  39.751   0.317  1.00 21.59           C  
ATOM    962  CG  TYR A 127      38.273  39.168   1.674  1.00 22.91           C  
ATOM    963  CD1 TYR A 127      38.207  39.937   2.840  1.00 21.48           C  
ATOM    964  CD2 TYR A 127      38.624  37.830   1.824  1.00 24.12           C  
ATOM    965  CE1 TYR A 127      38.452  39.395   4.036  1.00 21.99           C  
ATOM    966  CE2 TYR A 127      38.849  37.270   3.029  1.00 24.47           C  
ATOM    967  CZ  TYR A 127      38.786  38.053   4.164  1.00 23.83           C  
ATOM    968  OH  TYR A 127      39.047  37.496   5.405  1.00 24.95           O  
ATOM    969  N   ASP A 128      35.838  37.956  -1.214  1.00 21.62           N  
ATOM    970  CA  ASP A 128      35.258  36.645  -1.384  1.00 21.09           C  
ATOM    971  C   ASP A 128      36.344  35.636  -1.055  1.00 21.93           C  
ATOM    972  O   ASP A 128      37.396  35.578  -1.691  1.00 22.05           O  
ATOM    973  CB  ASP A 128      34.770  36.479  -2.808  1.00 20.31           C  
ATOM    974  CG  ASP A 128      34.057  35.187  -3.009  1.00 23.14           C  
ATOM    975  OD1 ASP A 128      34.706  34.118  -2.957  1.00 24.50           O  
ATOM    976  OD2 ASP A 128      32.827  35.243  -3.204  1.00 26.70           O  
ATOM    977  N   VAL A 129      36.097  34.827  -0.044  1.00 22.23           N  
ATOM    978  CA  VAL A 129      37.125  33.907   0.439  1.00 22.78           C  
ATOM    979  C   VAL A 129      37.461  32.766  -0.524  1.00 21.94           C  
ATOM    980  O   VAL A 129      38.646  32.485  -0.810  1.00 23.25           O  
ATOM    981  CB  VAL A 129      36.705  33.328   1.822  1.00 24.66           C  
ATOM    982  CG1 VAL A 129      37.637  32.209   2.247  1.00 25.48           C  
ATOM    983  CG2 VAL A 129      36.634  34.442   2.874  1.00 25.12           C  
ATOM    984  N   GLU A 130      36.436  32.095  -1.045  1.00 20.89           N  
ATOM    985  CA  GLU A 130      36.648  30.933  -1.905  1.00 24.54           C  
ATOM    986  C   GLU A 130      37.352  31.320  -3.205  1.00 21.32           C  
ATOM    987  O   GLU A 130      38.239  30.614  -3.674  1.00 22.79           O  
ATOM    988  CB  GLU A 130      35.316  30.242  -2.197  1.00 25.33           C  
ATOM    989  CG  GLU A 130      35.450  28.998  -3.051  1.00 30.22           C  
ATOM    990  CD  GLU A 130      34.131  28.229  -3.236  1.00 35.40           C  
ATOM    991  OE1 GLU A 130      33.048  28.778  -2.920  1.00 47.47           O  
ATOM    992  OE2 GLU A 130      34.189  27.068  -3.719  1.00 47.93           O  
ATOM    993  N   GLN A 131      36.949  32.433  -3.797  1.00 21.10           N  
ATOM    994  CA  GLN A 131      37.547  32.846  -5.061  1.00 21.43           C  
ATOM    995  C   GLN A 131      38.763  33.735  -4.912  1.00 20.74           C  
ATOM    996  O   GLN A 131      39.490  33.962  -5.873  1.00 21.52           O  
ATOM    997  CB  GLN A 131      36.500  33.543  -5.918  1.00 22.55           C  
ATOM    998  CG  GLN A 131      35.367  32.648  -6.321  1.00 26.17           C  
ATOM    999  CD  GLN A 131      35.838  31.369  -6.925  1.00 27.31           C  
ATOM   1000  OE1 GLN A 131      36.787  31.353  -7.743  1.00 31.91           O  
ATOM   1001  NE2 GLN A 131      35.178  30.273  -6.562  1.00 27.81           N  
ATOM   1002  N   GLU A 132      38.974  34.238  -3.698  0.50 20.10           N  
ATOM   1004  CA  GLU A 132      40.109  35.091  -3.353  0.50 19.74           C  
ATOM   1006  C   GLU A 132      40.163  36.338  -4.213  0.50 18.98           C  
ATOM   1008  O   GLU A 132      41.162  36.611  -4.866  0.50 19.75           O  
ATOM   1010  CB  GLU A 132      41.422  34.319  -3.443  0.50 19.64           C  
ATOM   1012  CG  GLU A 132      41.361  32.939  -2.769  0.50 19.31           C  
ATOM   1014  CD  GLU A 132      42.719  32.331  -2.528  0.50 23.07           C  
ATOM   1016  OE1 GLU A 132      43.641  33.051  -2.118  0.50 19.85           O  
ATOM   1018  OE2 GLU A 132      42.854  31.101  -2.705  0.50 29.27           O  
ATOM   1020  N   VAL A 133      39.066  37.090  -4.184  1.00 20.14           N  
ATOM   1021  CA  VAL A 133      38.954  38.334  -4.953  1.00 19.46           C  
ATOM   1022  C   VAL A 133      38.367  39.436  -4.068  1.00 21.21           C  
ATOM   1023  O   VAL A 133      37.635  39.154  -3.098  1.00 21.15           O  
ATOM   1024  CB  VAL A 133      38.050  38.151  -6.200  1.00 19.61           C  
ATOM   1025  CG1 VAL A 133      38.670  37.164  -7.177  1.00 21.88           C  
ATOM   1026  CG2 VAL A 133      36.621  37.745  -5.824  1.00 21.99           C  
ATOM   1027  N   ILE A 134      38.642  40.665  -4.465  1.00 19.98           N  
ATOM   1028  CA  ILE A 134      38.027  41.836  -3.830  1.00 20.88           C  
ATOM   1029  C   ILE A 134      36.679  42.077  -4.519  1.00 20.18           C  
ATOM   1030  O   ILE A 134      36.581  42.252  -5.747  1.00 21.28           O  
ATOM   1031  CB  ILE A 134      38.901  43.092  -3.990  1.00 20.91           C  
ATOM   1032  CG1 ILE A 134      40.274  42.869  -3.305  1.00 22.26           C  
ATOM   1033  CG2 ILE A 134      38.176  44.291  -3.437  1.00 21.81           C  
ATOM   1034  CD1 ILE A 134      41.161  44.050  -3.273  1.00 24.68           C  
ATOM   1035  N   PHE A 135      35.638  42.002  -3.724  1.00 21.73           N  
ATOM   1036  CA  PHE A 135      34.280  42.283  -4.173  1.00 21.74           C  
ATOM   1037  C   PHE A 135      33.931  43.762  -4.145  1.00 21.65           C  
ATOM   1038  O   PHE A 135      33.372  44.287  -5.102  1.00 22.98           O  
ATOM   1039  CB  PHE A 135      33.262  41.505  -3.331  1.00 22.58           C  
ATOM   1040  CG  PHE A 135      31.839  41.927  -3.567  1.00 21.11           C  
ATOM   1041  CD1 PHE A 135      31.262  41.826  -4.807  1.00 22.28           C  
ATOM   1042  CD2 PHE A 135      31.110  42.512  -2.541  1.00 22.99           C  
ATOM   1043  CE1 PHE A 135      29.945  42.210  -5.016  1.00 22.57           C  
ATOM   1044  CE2 PHE A 135      29.826  42.923  -2.753  1.00 22.62           C  
ATOM   1045  CZ  PHE A 135      29.242  42.784  -3.974  1.00 23.78           C  
ATOM   1046  N   GLN A 136      34.249  44.443  -3.050  1.00 21.61           N  
ATOM   1047  CA  GLN A 136      33.831  45.828  -2.907  0.50 21.54           C  
ATOM   1049  C   GLN A 136      34.701  46.579  -1.937  1.00 23.06           C  
ATOM   1050  O   GLN A 136      35.051  46.027  -0.895  1.00 24.56           O  
ATOM   1051  CB  GLN A 136      32.381  45.840  -2.375  0.50 23.37           C  
ATOM   1053  CG  GLN A 136      31.719  47.203  -2.264  0.50 26.45           C  
ATOM   1055  CD  GLN A 136      30.258  47.110  -1.819  0.50 25.75           C  
ATOM   1057  OE1 GLN A 136      29.709  46.030  -1.677  0.50 33.23           O  
ATOM   1059  NE2 GLN A 136      29.636  48.257  -1.599  0.50 34.96           N  
ATOM   1061  N   TRP A 137      35.024  47.807  -2.291  1.00 22.63           N  
ATOM   1062  CA  TRP A 137      35.633  48.751  -1.362  1.00 22.17           C  
ATOM   1063  C   TRP A 137      34.514  49.676  -0.853  1.00 23.06           C  
ATOM   1064  O   TRP A 137      33.748  50.215  -1.654  1.00 23.48           O  
ATOM   1065  CB  TRP A 137      36.649  49.580  -2.045  1.00 23.13           C  
ATOM   1066  CG  TRP A 137      37.863  48.883  -2.519  1.00 22.00           C  
ATOM   1067  CD1 TRP A 137      38.116  48.453  -3.775  1.00 23.71           C  
ATOM   1068  CD2 TRP A 137      39.008  48.557  -1.736  1.00 21.87           C  
ATOM   1069  NE1 TRP A 137      39.372  47.917  -3.841  1.00 23.32           N  
ATOM   1070  CE2 TRP A 137      39.947  47.958  -2.601  1.00 20.16           C  
ATOM   1071  CE3 TRP A 137      39.363  48.750  -0.422  1.00 23.31           C  
ATOM   1072  CZ2 TRP A 137      41.216  47.555  -2.173  1.00 20.33           C  
ATOM   1073  CZ3 TRP A 137      40.634  48.350   0.004  1.00 23.47           C  
ATOM   1074  CH2 TRP A 137      41.541  47.763  -0.864  1.00 23.16           C  
ATOM   1075  N   ILE A 138      34.449  49.880   0.472  1.00 21.58           N  
ATOM   1076  CA  ILE A 138      33.431  50.734   1.084  1.00 22.69           C  
ATOM   1077  C   ILE A 138      34.176  51.848   1.781  1.00 24.27           C  
ATOM   1078  O   ILE A 138      34.834  51.610   2.776  1.00 24.49           O  
ATOM   1079  CB  ILE A 138      32.499  49.931   1.988  1.00 26.08           C  
ATOM   1080  CG1 ILE A 138      31.868  48.793   1.161  1.00 29.26           C  
ATOM   1081  CG2 ILE A 138      31.439  50.910   2.579  1.00 31.56           C  
ATOM   1082  CD1 ILE A 138      31.154  47.778   1.909  1.00 36.18           C  
ATOM   1083  N   ASN A 139      34.134  53.044   1.173  1.00 25.16           N  
ATOM   1084  CA  ASN A 139      34.877  54.203   1.662  1.00 27.06           C  
ATOM   1085  C   ASN A 139      34.030  55.121   2.466  1.00 29.68           C  
ATOM   1086  O   ASN A 139      34.621  55.948   3.172  1.00 29.82           O  
ATOM   1087  CB  ASN A 139      35.496  54.973   0.494  1.00 26.74           C  
ATOM   1088  CG  ASN A 139      36.812  54.379   0.068  1.00 29.96           C  
ATOM   1089  OD1 ASN A 139      37.777  54.452   0.836  1.00 32.46           O  
ATOM   1090  ND2 ASN A 139      36.868  53.791  -1.111  1.00 33.03           N  
ATOM   1091  OXT ASN A 139      32.777  55.046   2.404  1.00 30.09           O  
TER    1092      ASN A 139                                                      
END
MOLECULE T0495_5_143.pdb
ATOM      1  N   LEU     5      45.969  23.478   3.252  1.00 38.14           N  
ATOM      2  CA  LEU     5      46.490  24.710   3.921  1.00 38.30           C  
ATOM      3  C   LEU     5      46.362  24.598   5.434  1.00 38.70           C  
ATOM      4  O   LEU     5      45.265  24.375   5.947  1.00 38.88           O  
ATOM      5  CB  LEU     5      45.724  25.958   3.463  1.00 37.92           C  
ATOM      6  CG  LEU     5      45.678  26.334   1.977  1.00 37.39           C  
ATOM      7  CD1 LEU     5      45.154  27.777   1.825  1.00 35.18           C  
ATOM      8  CD2 LEU     5      47.048  26.165   1.302  1.00 36.39           C  
ATOM      9  N   ASP     6      47.483  24.733   6.143  1.00 39.19           N  
ATOM     10  CA  ASP     6      47.446  25.021   7.581  1.00 39.51           C  
ATOM     11  C   ASP     6      47.751  26.510   7.753  1.00 39.87           C  
ATOM     12  O   ASP     6      48.840  26.914   8.171  1.00 39.97           O  
ATOM     13  CB  ASP     6      48.340  24.100   8.452  1.00 39.40           C  
ATOM     14  CG  ASP     6      49.600  23.620   7.748  1.00 39.37           C  
ATOM     15  OD1 ASP     6      50.647  23.504   8.421  1.00 38.77           O  
ATOM     16  OD2 ASP     6      49.544  23.326   6.537  1.00 39.57           O  
ATOM     17  N   LEU     7      46.768  27.313   7.358  1.00 40.08           N  
ATOM     18  CA  LEU     7      46.722  28.728   7.677  1.00 40.61           C  
ATOM     19  C   LEU     7      45.600  28.932   8.688  1.00 41.15           C  
ATOM     20  O   LEU     7      44.546  28.297   8.592  1.00 40.41           O  
ATOM     21  CB  LEU     7      46.399  29.569   6.436  1.00 40.38           C  
ATOM     22  CG  LEU     7      47.368  29.613   5.253  1.00 40.99           C  
ATOM     23  CD1 LEU     7      46.776  30.487   4.151  1.00 40.42           C  
ATOM     24  CD2 LEU     7      48.755  30.110   5.651  1.00 40.43           C  
ATOM     25  N   GLN     8      45.822  29.829   9.645  1.00 42.24           N  
ATOM     26  CA  GLN     8      44.777  30.227  10.594  0.50 42.53           C  
ATOM     28  C   GLN     8      43.743  31.071   9.854  1.00 42.85           C  
ATOM     29  O   GLN     8      44.022  31.579   8.770  1.00 42.28           O  
ATOM     30  CB  GLN     8      45.380  31.029  11.755  0.50 42.65           C  
ATOM     32  CG  GLN     8      46.000  30.178  12.865  0.50 42.48           C  
ATOM     34  CD  GLN     8      46.979  30.965  13.716  0.50 41.89           C  
ATOM     36  OE1 GLN     8      47.364  32.081  13.364  0.50 41.95           O  
ATOM     38  NE2 GLN     8      47.383  30.391  14.844  0.50 42.22           N  
ATOM     40  N   PRO     9      42.535  31.223  10.429  1.00 43.65           N  
ATOM     41  CA  PRO     9      41.490  32.001   9.715  1.00 44.43           C  
ATOM     42  C   PRO     9      41.901  33.416   9.236  1.00 44.22           C  
ATOM     43  O   PRO     9      41.615  33.806   8.091  1.00 43.49           O  
ATOM     44  CB  PRO     9      40.349  32.054  10.740  1.00 44.78           C  
ATOM     45  CG  PRO     9      40.523  30.818  11.560  1.00 44.24           C  
ATOM     46  CD  PRO     9      42.019  30.661  11.700  1.00 43.75           C  
ATOM     47  N   GLY    10      42.574  34.186  10.086  1.00 44.09           N  
ATOM     48  CA  GLY    10      43.013  35.529   9.648  1.00 43.34           C  
ATOM     49  C   GLY    10      44.032  35.469   8.522  1.00 42.61           C  
ATOM     50  O   GLY    10      44.066  36.326   7.604  1.00 41.75           O  
ATOM     51  N   GLN    11      44.888  34.449   8.568  1.00 41.40           N  
ATOM     52  CA  GLN    11      45.884  34.302   7.538  1.00 40.04           C  
ATOM     53  C   GLN    11      45.242  33.961   6.211  1.00 38.83           C  
ATOM     54  O   GLN    11      45.787  34.295   5.169  1.00 39.89           O  
ATOM     55  CB  GLN    11      46.923  33.237   7.912  1.00 40.06           C  
ATOM     56  CG  GLN    11      47.873  33.655   9.035  1.00 40.33           C  
ATOM     57  CD  GLN    11      48.812  32.554   9.432  1.00 39.18           C  
ATOM     58  OE1 GLN    11      48.393  31.427   9.692  1.00 35.18           O  
ATOM     59  NE2 GLN    11      50.104  32.878   9.507  1.00 42.19           N  
ATOM     60  N   ARG    12      44.143  33.225   6.264  1.00 38.76           N  
ATOM     61  CA  ARG    12      43.395  32.852   5.071  1.00 37.01           C  
ATOM     62  C   ARG    12      42.862  34.084   4.372  1.00 34.65           C  
ATOM     63  O   ARG    12      43.071  34.264   3.181  1.00 34.81           O  
ATOM     64  CB  ARG    12      42.259  31.896   5.463  1.00 37.53           C  
ATOM     65  CG  ARG    12      42.702  30.436   5.681  1.00 38.59           C  
ATOM     66  CD  ARG    12      41.510  29.554   5.999  1.00 40.97           C  
ATOM     67  NE  ARG    12      41.799  28.128   5.848  1.00 43.25           N  
ATOM     68  CZ  ARG    12      41.525  27.376   4.772  1.00 44.47           C  
ATOM     69  NH1 ARG    12      41.831  26.083   4.792  1.00 45.36           N  
ATOM     70  NH2 ARG    12      40.948  27.879   3.678  1.00 44.66           N  
ATOM     71  N   LEU    13      42.158  34.928   5.123  1.00 32.91           N  
ATOM     72  CA  LEU    13      41.636  36.175   4.576  1.00 32.29           C  
ATOM     73  C   LEU    13      42.781  37.003   3.992  1.00 31.74           C  
ATOM     74  O   LEU    13      42.652  37.507   2.888  1.00 32.08           O  
ATOM     75  CB  LEU    13      40.873  36.994   5.637  1.00 32.92           C  
ATOM     76  CG  LEU    13      39.624  36.366   6.268  1.00 32.94           C  
ATOM     77  CD1 LEU    13      39.141  37.186   7.487  1.00 32.58           C  
ATOM     78  CD2 LEU    13      38.540  36.270   5.227  1.00 33.66           C  
ATOM     79  N   ALA    14      43.911  37.089   4.709  1.00 30.28           N  
ATOM     80  CA  ALA    14      45.002  37.910   4.250  1.00 30.35           C  
ATOM     81  C   ALA    14      45.583  37.382   2.911  1.00 29.01           C  
ATOM     82  O   ALA    14      46.110  38.152   2.106  1.00 29.67           O  
ATOM     83  CB  ALA    14      46.100  38.001   5.295  1.00 28.79           C  
ATOM     84  N   ARG    15      45.564  36.067   2.742  1.00 29.40           N  
ATOM     85  CA  ARG    15      46.005  35.465   1.454  1.00 29.83           C  
ATOM     86  C   ARG    15      45.180  35.916   0.310  1.00 29.24           C  
ATOM     87  O   ARG    15      45.718  36.353  -0.705  1.00 29.13           O  
ATOM     88  CB  ARG    15      46.007  33.936   1.546  1.00 30.37           C  
ATOM     89  CG  ARG    15      46.706  33.192   0.384  1.00 33.54           C  
ATOM     90  CD  ARG    15      46.524  31.724   0.763  1.00 39.34           C  
ATOM     91  NE  ARG    15      47.240  30.768  -0.023  1.00 41.73           N  
ATOM     92  CZ  ARG    15      46.689  29.951  -0.914  1.00 45.31           C  
ATOM     93  NH1 ARG    15      47.475  29.075  -1.533  1.00 45.52           N  
ATOM     94  NH2 ARG    15      45.386  30.002  -1.208  1.00 44.25           N  
ATOM     95  N   GLY    16      43.861  35.891   0.491  1.00 30.12           N  
ATOM     96  CA  GLY    16      42.936  36.343  -0.551  1.00 29.24           C  
ATOM     97  C   GLY    16      43.027  37.801  -0.808  1.00 29.52           C  
ATOM     98  O   GLY    16      43.063  38.242  -1.969  1.00 28.36           O  
ATOM     99  N   VAL    17      43.194  38.586   0.266  1.00 28.25           N  
ATOM    100  CA  VAL    17      43.387  40.014   0.101  1.00 27.59           C  
ATOM    101  C   VAL    17      44.646  40.337  -0.728  1.00 28.51           C  
ATOM    102  O   VAL    17      44.596  41.192  -1.661  1.00 28.26           O  
ATOM    103  CB  VAL    17      43.427  40.759   1.499  1.00 26.92           C  
ATOM    104  CG1 VAL    17      43.811  42.212   1.297  1.00 28.67           C  
ATOM    105  CG2 VAL    17      42.063  40.649   2.219  1.00 28.70           C  
ATOM    106  N   ALA    18      45.763  39.686  -0.367  1.00 28.55           N  
ATOM    107  CA  ALA    18      47.044  39.873  -1.053  1.00 27.98           C  
ATOM    108  C   ALA    18      46.959  39.510  -2.562  1.00 28.27           C  
ATOM    109  O   ALA    18      47.528  40.229  -3.403  1.00 27.57           O  
ATOM    110  CB  ALA    18      48.130  39.095  -0.372  1.00 27.73           C  
ATOM    111  N   ARG    19      46.283  38.412  -2.870  1.00 30.15           N  
ATOM    112  CA  ARG    19      46.061  38.000  -4.298  1.00 30.28           C  
ATOM    113  C   ARG    19      45.359  39.097  -5.014  1.00 30.51           C  
ATOM    114  O   ARG    19      45.758  39.480  -6.116  1.00 31.11           O  
ATOM    115  CB  ARG    19      45.260  36.717  -4.396  1.00 30.44           C  
ATOM    116  CG  ARG    19      45.997  35.514  -3.985  1.00 32.15           C  
ATOM    117  CD  ARG    19      45.114  34.276  -3.945  1.00 30.90           C  
ATOM    118  NE  ARG    19      45.927  33.072  -3.860  1.00 30.71           N  
ATOM    119  CZ  ARG    19      45.606  31.900  -4.405  1.00 34.06           C  
ATOM    120  NH1 ARG    19      44.443  31.701  -5.024  1.00 34.11           N  
ATOM    121  NH2 ARG    19      46.432  30.889  -4.286  1.00 36.45           N  
ATOM    122  N   HIS    20      44.283  39.638  -4.396  1.00 31.84           N  
ATOM    123  CA  HIS    20      43.448  40.623  -5.069  1.00 30.13           C  
ATOM    124  C   HIS    20      44.146  41.962  -5.243  1.00 29.99           C  
ATOM    125  O   HIS    20      44.067  42.583  -6.320  1.00 29.25           O  
ATOM    126  CB  HIS    20      42.099  40.805  -4.311  1.00 32.18           C  
ATOM    127  CG  HIS    20      41.118  41.669  -5.043  1.00 32.57           C  
ATOM    128  ND1 HIS    20      40.643  41.347  -6.295  1.00 33.23           N  
ATOM    129  CD2 HIS    20      40.597  42.888  -4.744  1.00 33.95           C  
ATOM    130  CE1 HIS    20      39.823  42.289  -6.703  1.00 33.99           C  
ATOM    131  NE2 HIS    20      39.783  43.238  -5.787  1.00 34.24           N  
ATOM    132  N   LEU    21      44.868  42.414  -4.211  1.00 28.80           N  
ATOM    133  CA  LEU    21      45.686  43.625  -4.315  1.00 30.87           C  
ATOM    134  C   LEU    21      46.682  43.491  -5.482  1.00 29.17           C  
ATOM    135  O   LEU    21      46.804  44.376  -6.308  1.00 29.80           O  
ATOM    136  CB  LEU    21      46.482  43.894  -3.033  1.00 30.12           C  
ATOM    137  CG  LEU    21      45.643  44.421  -1.869  1.00 34.58           C  
ATOM    138  CD1 LEU    21      46.525  44.462  -0.604  1.00 34.39           C  
ATOM    139  CD2 LEU    21      45.094  45.789  -2.178  1.00 36.07           C  
ATOM    140  N   ARG    22      47.320  42.351  -5.570  1.00 30.71           N  
ATOM    141  CA  ARG    22      48.371  42.149  -6.583  1.00 30.39           C  
ATOM    142  C   ARG    22      47.770  42.163  -8.013  1.00 30.86           C  
ATOM    143  O   ARG    22      48.362  42.730  -8.958  1.00 30.07           O  
ATOM    144  CB  ARG    22      49.180  40.892  -6.278  1.00 30.93           C  
ATOM    145  CG  ARG    22      50.300  40.579  -7.284  1.00 33.89           C  
ATOM    146  CD  ARG    22      50.938  39.237  -7.047  1.00 35.51           C  
ATOM    147  NE  ARG    22      51.936  39.087  -8.082  1.00 34.57           N  
ATOM    148  CZ  ARG    22      53.195  38.696  -7.913  1.00 35.50           C  
ATOM    149  NH1 ARG    22      53.656  38.311  -6.722  1.00 33.15           N  
ATOM    150  NH2 ARG    22      53.992  38.675  -8.980  1.00 34.96           N  
ATOM    151  N   ALA    23      46.619  41.553  -8.157  1.00 31.76           N  
ATOM    152  CA  ALA    23      45.849  41.569  -9.439  1.00 32.88           C  
ATOM    153  C   ALA    23      45.550  42.992  -9.922  1.00 34.72           C  
ATOM    154  O   ALA    23      45.422  43.265 -11.137  1.00 34.07           O  
ATOM    155  CB  ALA    23      44.571  40.794  -9.272  1.00 32.37           C  
ATOM    156  N   HIS    24      45.474  43.934  -8.975  1.00 36.04           N  
ATOM    157  CA  HIS    24      45.250  45.334  -9.327  1.00 36.14           C  
ATOM    158  C   HIS    24      46.427  46.284  -9.110  1.00 36.10           C  
ATOM    159  O   HIS    24      46.213  47.500  -8.923  1.00 36.57           O  
ATOM    160  CB  HIS    24      44.025  45.790  -8.591  1.00 36.62           C  
ATOM    161  CG  HIS    24      42.773  45.148  -9.090  1.00 39.20           C  
ATOM    162  ND1 HIS    24      42.127  45.574 -10.237  1.00 41.39           N  
ATOM    163  CD2 HIS    24      42.067  44.098  -8.626  1.00 39.99           C  
ATOM    164  CE1 HIS    24      41.058  44.825 -10.430  1.00 39.92           C  
ATOM    165  NE2 HIS    24      40.992  43.935  -9.463  1.00 41.57           N  
ATOM    166  N   GLY    25      47.648  45.767  -9.216  1.00 34.51           N  
ATOM    167  CA  GLY    25      48.872  46.573  -9.196  1.00 34.38           C  
ATOM    168  C   GLY    25      49.382  47.076  -7.851  1.00 33.84           C  
ATOM    169  O   GLY    25      50.367  47.828  -7.794  1.00 34.39           O  
ATOM    170  N   PHE    26      48.728  46.641  -6.770  1.00 33.03           N  
ATOM    171  CA  PHE    26      49.200  46.859  -5.425  1.00 32.41           C  
ATOM    172  C   PHE    26      50.146  45.720  -5.008  1.00 32.82           C  
ATOM    173  O   PHE    26      50.234  44.666  -5.664  1.00 32.25           O  
ATOM    174  CB  PHE    26      48.025  46.976  -4.449  1.00 32.87           C  
ATOM    175  CG  PHE    26      47.435  48.362  -4.362  1.00 32.59           C  
ATOM    176  CD1 PHE    26      46.831  48.948  -5.485  1.00 34.19           C  
ATOM    177  CD2 PHE    26      47.400  49.042  -3.149  1.00 32.00           C  
ATOM    178  CE1 PHE    26      46.270  50.199  -5.411  1.00 37.10           C  
ATOM    179  CE2 PHE    26      46.877  50.306  -3.076  1.00 33.19           C  
ATOM    180  CZ  PHE    26      46.282  50.893  -4.197  1.00 35.86           C  
ATOM    181  N   VAL    27      50.932  45.975  -3.970  1.00 30.86           N  
ATOM    182  CA  VAL    27      51.683  44.924  -3.297  1.00 29.69           C  
ATOM    183  C   VAL    27      51.322  44.998  -1.817  1.00 29.17           C  
ATOM    184  O   VAL    27      50.713  45.972  -1.374  1.00 30.58           O  
ATOM    185  CB  VAL    27      53.209  45.090  -3.475  1.00 29.88           C  
ATOM    186  CG1 VAL    27      53.601  44.831  -4.983  1.00 29.49           C  
ATOM    187  CG2 VAL    27      53.673  46.482  -3.043  1.00 28.47           C  
ATOM    188  N   SER    28      51.737  44.016  -1.055  1.00 28.60           N  
ATOM    189  CA  SER    28      51.295  43.942   0.339  1.00 27.97           C  
ATOM    190  C   SER    28      52.312  43.216   1.192  1.00 26.85           C  
ATOM    191  O   SER    28      53.161  42.470   0.690  1.00 26.63           O  
ATOM    192  CB  SER    28      49.943  43.289   0.447  1.00 27.40           C  
ATOM    193  OG  SER    28      49.995  41.929   0.001  1.00 28.09           O  
ATOM    194  N   VAL    29      52.217  43.471   2.498  1.00 26.32           N  
ATOM    195  CA  VAL    29      52.868  42.663   3.499  1.00 26.09           C  
ATOM    196  C   VAL    29      51.869  42.358   4.612  1.00 26.69           C  
ATOM    197  O   VAL    29      50.835  43.029   4.767  1.00 25.06           O  
ATOM    198  CB  VAL    29      54.155  43.294   4.125  1.00 25.96           C  
ATOM    199  CG1 VAL    29      55.258  43.478   3.036  1.00 26.47           C  
ATOM    200  CG2 VAL    29      53.900  44.569   4.878  1.00 24.70           C  
ATOM    201  N   GLU    30      52.207  41.357   5.394  1.00 26.99           N  
ATOM    202  CA  GLU    30      51.408  41.000   6.527  1.00 28.70           C  
ATOM    203  C   GLU    30      52.057  41.354   7.867  1.00 27.60           C  
ATOM    204  O   GLU    30      53.291  41.412   8.015  1.00 27.17           O  
ATOM    205  CB  GLU    30      51.109  39.498   6.493  1.00 29.53           C  
ATOM    206  CG  GLU    30      50.082  39.067   5.504  1.00 35.04           C  
ATOM    207  CD  GLU    30      49.665  37.586   5.712  1.00 43.13           C  
ATOM    208  OE1 GLU    30      49.320  37.173   6.875  1.00 48.65           O  
ATOM    209  OE2 GLU    30      49.648  36.838   4.713  1.00 39.81           O  
ATOM    210  N   GLU    31      51.198  41.593   8.857  1.00 27.51           N  
ATOM    211  CA  GLU    31      51.636  41.860  10.236  0.50 27.73           C  
ATOM    213  C   GLU    31      52.614  43.012  10.285  1.00 26.70           C  
ATOM    214  O   GLU    31      53.692  42.906  10.816  1.00 26.95           O  
ATOM    215  CB  GLU    31      52.244  40.596  10.829  0.50 28.41           C  
ATOM    217  CG  GLU    31      51.309  39.425  10.700  0.50 31.21           C  
ATOM    219  CD  GLU    31      51.797  38.212  11.432  0.50 35.16           C  
ATOM    221  OE1 GLU    31      52.986  37.874  11.284  0.50 39.43           O  
ATOM    223  OE2 GLU    31      50.974  37.584  12.139  0.50 39.69           O  
ATOM    225  N   PHE    32      52.203  44.124   9.708  1.00 26.33           N  
ATOM    226  CA  PHE    32      53.002  45.304   9.636  1.00 25.68           C  
ATOM    227  C   PHE    32      52.885  46.230  10.859  1.00 24.65           C  
ATOM    228  O   PHE    32      51.773  46.526  11.312  1.00 24.12           O  
ATOM    229  CB  PHE    32      52.590  46.095   8.426  1.00 25.46           C  
ATOM    230  CG  PHE    32      53.404  47.298   8.222  1.00 24.52           C  
ATOM    231  CD1 PHE    32      52.884  48.541   8.491  1.00 25.16           C  
ATOM    232  CD2 PHE    32      54.720  47.194   7.800  1.00 25.34           C  
ATOM    233  CE1 PHE    32      53.623  49.672   8.297  1.00 26.20           C  
ATOM    234  CE2 PHE    32      55.472  48.331   7.635  1.00 25.96           C  
ATOM    235  CZ  PHE    32      54.918  49.579   7.866  1.00 25.05           C  
ATOM    236  N   VAL    33      54.016  46.731  11.327  1.00 24.23           N  
ATOM    237  CA  VAL    33      54.088  47.595  12.530  1.00 23.50           C  
ATOM    238  C   VAL    33      54.357  49.052  12.142  1.00 24.37           C  
ATOM    239  O   VAL    33      55.509  49.435  11.869  1.00 24.23           O  
ATOM    240  CB  VAL    33      55.151  47.131  13.517  1.00 24.23           C  
ATOM    241  CG1 VAL    33      55.280  48.117  14.691  1.00 22.24           C  
ATOM    242  CG2 VAL    33      54.843  45.743  14.017  1.00 24.19           C  
ATOM    243  N   PRO    34      53.306  49.884  12.111  1.00 24.54           N  
ATOM    244  CA  PRO    34      53.506  51.294  11.752  1.00 25.71           C  
ATOM    245  C   PRO    34      54.085  52.172  12.867  1.00 26.84           C  
ATOM    246  O   PRO    34      54.626  53.251  12.588  1.00 27.21           O  
ATOM    247  CB  PRO    34      52.098  51.740  11.346  1.00 25.67           C  
ATOM    248  CG  PRO    34      51.161  50.843  12.130  1.00 25.17           C  
ATOM    249  CD  PRO    34      51.885  49.550  12.356  1.00 25.17           C  
ATOM    250  N   ALA    35      53.966  51.715  14.109  1.00 27.43           N  
ATOM    251  CA  ALA    35      54.412  52.460  15.275  1.00 29.07           C  
ATOM    252  C   ALA    35      54.355  51.486  16.435  1.00 29.37           C  
ATOM    253  O   ALA    35      53.620  50.492  16.383  1.00 27.54           O  
ATOM    254  CB  ALA    35      53.500  53.676  15.555  1.00 29.70           C  
ATOM    255  N   ARG    36      55.150  51.776  17.457  1.00 29.82           N  
ATOM    256  CA  ARG    36      55.188  50.979  18.677  1.00 30.96           C  
ATOM    257  C   ARG    36      53.791  50.685  19.158  1.00 31.11           C  
ATOM    258  O   ARG    36      52.973  51.593  19.233  1.00 31.88           O  
ATOM    259  CB  ARG    36      55.896  51.743  19.794  1.00 31.37           C  
ATOM    260  CG  ARG    36      57.369  51.514  19.876  1.00 33.43           C  
ATOM    261  CD  ARG    36      57.850  51.860  21.265  1.00 34.81           C  
ATOM    262  NE  ARG    36      59.263  51.560  21.469  1.00 36.64           N  
ATOM    263  CZ  ARG    36      59.757  50.402  21.907  1.00 37.17           C  
ATOM    264  NH1 ARG    36      58.960  49.382  22.198  1.00 37.94           N  
ATOM    265  NH2 ARG    36      61.069  50.274  22.059  1.00 38.12           N  
ATOM    266  N   GLY    37      53.529  49.430  19.510  1.00 31.00           N  
ATOM    267  CA  GLY    37      52.245  49.046  20.079  1.00 30.64           C  
ATOM    268  C   GLY    37      51.116  48.804  19.096  1.00 30.47           C  
ATOM    269  O   GLY    37      50.028  48.446  19.510  1.00 30.27           O  
ATOM    270  N   LEU    38      51.349  48.994  17.798  1.00 30.30           N  
ATOM    271  CA  LEU    38      50.332  48.695  16.792  1.00 30.44           C  
ATOM    272  C   LEU    38      50.824  47.654  15.805  1.00 29.85           C  
ATOM    273  O   LEU    38      52.008  47.579  15.498  1.00 27.66           O  
ATOM    274  CB  LEU    38      49.958  49.950  15.999  1.00 30.96           C  
ATOM    275  CG  LEU    38      49.282  51.087  16.761  1.00 34.65           C  
ATOM    276  CD1 LEU    38      49.226  52.317  15.860  1.00 37.20           C  
ATOM    277  CD2 LEU    38      47.864  50.657  17.221  1.00 37.06           C  
ATOM    278  N   ARG    39      49.894  46.878  15.287  1.00 30.06           N  
ATOM    279  CA  ARG    39      50.195  45.952  14.207  1.00 30.98           C  
ATOM    280  C   ARG    39      48.987  45.811  13.308  1.00 30.64           C  
ATOM    281  O   ARG    39      47.862  45.679  13.803  1.00 30.53           O  
ATOM    282  CB  ARG    39      50.602  44.602  14.753  1.00 31.70           C  
ATOM    283  CG  ARG    39      51.344  43.770  13.727  1.00 36.13           C  
ATOM    284  CD  ARG    39      51.801  42.461  14.311  1.00 41.67           C  
ATOM    285  NE  ARG    39      50.644  41.636  14.613  1.00 46.35           N  
ATOM    286  CZ  ARG    39      50.683  40.374  15.039  1.00 52.33           C  
ATOM    287  NH1 ARG    39      51.852  39.736  15.191  1.00 53.52           N  
ATOM    288  NH2 ARG    39      49.527  39.738  15.289  1.00 53.35           N  
ATOM    289  N   VAL    40      49.193  45.911  11.997  1.00 29.25           N  
ATOM    290  CA  VAL    40      48.084  45.806  11.073  1.00 29.29           C  
ATOM    291  C   VAL    40      48.180  44.491  10.303  1.00 29.28           C  
ATOM    292  O   VAL    40      49.260  44.038   9.971  1.00 28.16           O  
ATOM    293  CB  VAL    40      47.979  47.025  10.097  1.00 30.38           C  
ATOM    294  CG1 VAL    40      48.048  48.386  10.835  1.00 30.15           C  
ATOM    295  CG2 VAL    40      48.965  46.949   9.024  1.00 31.10           C  
ATOM    296  N   ASP    41      47.031  43.890  10.016  1.00 28.82           N  
ATOM    297  CA  ASP    41      46.989  42.539   9.423  1.00 28.90           C  
ATOM    298  C   ASP    41      47.559  42.493   7.997  1.00 29.20           C  
ATOM    299  O   ASP    41      48.356  41.616   7.681  1.00 28.96           O  
ATOM    300  CB  ASP    41      45.553  42.025   9.428  1.00 29.05           C  
ATOM    301  CG  ASP    41      45.003  41.835  10.844  1.00 29.68           C  
ATOM    302  OD1 ASP    41      45.807  41.624  11.776  1.00 28.41           O  
ATOM    303  OD2 ASP    41      43.761  41.888  10.974  1.00 29.44           O  
ATOM    304  N   VAL    42      47.146  43.451   7.170  1.00 29.53           N  
ATOM    305  CA  VAL    42      47.725  43.629   5.860  1.00 29.37           C  
ATOM    306  C   VAL    42      47.958  45.118   5.626  1.00 29.29           C  
ATOM    307  O   VAL    42      47.066  45.944   5.858  1.00 28.58           O  
ATOM    308  CB  VAL    42      46.839  43.039   4.739  1.00 30.24           C  
ATOM    309  CG1 VAL    42      47.444  43.342   3.341  1.00 29.49           C  
ATOM    310  CG2 VAL    42      46.690  41.534   4.922  1.00 29.51           C  
ATOM    311  N   MET    43      49.169  45.445   5.159  1.00 28.21           N  
ATOM    312  CA  MET    43      49.415  46.759   4.580  1.00 28.70           C  
ATOM    313  C   MET    43      49.538  46.629   3.083  1.00 29.05           C  
ATOM    314  O   MET    43      50.300  45.777   2.615  1.00 28.30           O  
ATOM    315  CB  MET    43      50.658  47.424   5.172  1.00 27.94           C  
ATOM    316  CG  MET    43      50.883  48.859   4.561  1.00 31.25           C  
ATOM    317  SD  MET    43      52.353  49.878   5.187  0.65 32.79          SE  
ATOM    318  CE  MET    43      52.924  50.775   3.501  1.00 36.03           C  
ATOM    319  N   GLY    44      48.790  47.465   2.347  1.00 29.66           N  
ATOM    320  CA  GLY    44      48.888  47.517   0.887  1.00 29.92           C  
ATOM    321  C   GLY    44      49.589  48.774   0.442  1.00 30.19           C  
ATOM    322  O   GLY    44      49.381  49.850   1.036  1.00 29.23           O  
ATOM    323  N   LEU    45      50.448  48.642  -0.590  1.00 30.88           N  
ATOM    324  CA  LEU    45      51.158  49.743  -1.171  1.00 31.78           C  
ATOM    325  C   LEU    45      50.853  49.835  -2.667  1.00 32.94           C  
ATOM    326  O   LEU    45      51.083  48.871  -3.439  1.00 32.14           O  
ATOM    327  CB  LEU    45      52.661  49.601  -0.943  1.00 31.03           C  
ATOM    328  CG  LEU    45      53.568  50.630  -1.591  1.00 32.51           C  
ATOM    329  CD1 LEU    45      53.290  52.041  -1.032  1.00 29.99           C  
ATOM    330  CD2 LEU    45      55.079  50.228  -1.445  1.00 29.43           C  
ATOM    331  N   GLY    46      50.318  50.986  -3.040  1.00 34.05           N  
ATOM    332  CA  GLY    46      49.879  51.284  -4.410  1.00 35.87           C  
ATOM    333  C   GLY    46      51.019  51.765  -5.274  1.00 37.83           C  
ATOM    334  O   GLY    46      52.109  52.125  -4.761  1.00 38.53           O  
ATOM    335  N   PRO    47      50.825  51.719  -6.603  1.00 39.46           N  
ATOM    336  CA  PRO    47      51.963  52.055  -7.492  1.00 40.90           C  
ATOM    337  C   PRO    47      52.426  53.525  -7.400  1.00 42.26           C  
ATOM    338  O   PRO    47      53.544  53.846  -7.840  1.00 43.50           O  
ATOM    339  CB  PRO    47      51.435  51.731  -8.910  1.00 40.67           C  
ATOM    340  CG  PRO    47      49.957  51.675  -8.775  1.00 40.80           C  
ATOM    341  CD  PRO    47      49.632  51.293  -7.341  1.00 38.82           C  
ATOM    342  N   LYS    48      51.595  54.390  -6.829  1.00 42.99           N  
ATOM    343  CA  LYS    48      51.946  55.797  -6.637  1.00 43.80           C  
ATOM    344  C   LYS    48      52.193  56.090  -5.162  1.00 42.11           C  
ATOM    345  O   LYS    48      52.254  57.247  -4.766  1.00 41.20           O  
ATOM    346  CB  LYS    48      50.823  56.696  -7.171  1.00 45.43           C  
ATOM    347  CG  LYS    48      50.573  56.567  -8.695  1.00 49.60           C  
ATOM    348  CD  LYS    48      49.446  57.511  -9.190  1.00 54.59           C  
ATOM    349  CE  LYS    48      48.163  56.754  -9.578  1.00 57.03           C  
ATOM    350  NZ  LYS    48      48.451  55.682 -10.606  1.00 58.42           N  
ATOM    351  N   GLY    49      52.349  55.039  -4.357  1.00 39.55           N  
ATOM    352  CA  GLY    49      52.672  55.189  -2.959  1.00 37.96           C  
ATOM    353  C   GLY    49      51.472  55.318  -2.034  1.00 36.76           C  
ATOM    354  O   GLY    49      51.631  55.663  -0.895  1.00 35.86           O  
ATOM    355  N   GLU    50      50.286  54.994  -2.516  1.00 35.39           N  
ATOM    356  CA  GLU    50      49.063  54.967  -1.695  1.00 36.06           C  
ATOM    357  C   GLU    50      49.233  53.877  -0.595  1.00 34.85           C  
ATOM    358  O   GLU    50      49.797  52.810  -0.849  1.00 34.55           O  
ATOM    359  CB  GLU    50      47.843  54.679  -2.589  1.00 36.91           C  
ATOM    360  CG  GLU    50      47.721  55.553  -3.900  1.00 42.02           C  
ATOM    361  CD  GLU    50      48.240  54.853  -5.207  1.00 46.63           C  
ATOM    362  OE1 GLU    50      47.541  54.840  -6.245  1.00 54.54           O  
ATOM    363  OE2 GLU    50      49.329  54.311  -5.222  1.00 41.20           O  
ATOM    364  N   ILE    51      48.834  54.170   0.638  1.00 32.72           N  
ATOM    365  CA  ILE    51      48.962  53.206   1.739  1.00 31.02           C  
ATOM    366  C   ILE    51      47.550  52.829   2.220  1.00 30.71           C  
ATOM    367  O   ILE    51      46.739  53.693   2.571  1.00 29.10           O  
ATOM    368  CB  ILE    51      49.842  53.760   2.910  1.00 31.37           C  
ATOM    369  CG1 ILE    51      51.291  53.948   2.439  1.00 33.61           C  
ATOM    370  CG2 ILE    51      49.866  52.793   4.125  1.00 29.15           C  
ATOM    371  CD1 ILE    51      52.022  55.011   3.209  1.00 36.59           C  
ATOM    372  N   TRP    52      47.278  51.515   2.200  1.00 30.35           N  
ATOM    373  CA  TRP    52      46.037  50.925   2.665  1.00 30.78           C  
ATOM    374  C   TRP    52      46.306  50.010   3.836  1.00 29.52           C  
ATOM    375  O   TRP    52      47.279  49.268   3.846  1.00 29.52           O  
ATOM    376  CB  TRP    52      45.424  50.083   1.556  1.00 31.80           C  
ATOM    377  CG  TRP    52      44.858  50.853   0.411  1.00 32.99           C  
ATOM    378  CD1 TRP    52      45.021  52.174   0.125  1.00 34.79           C  
ATOM    379  CD2 TRP    52      44.058  50.312  -0.642  1.00 33.33           C  
ATOM    380  NE1 TRP    52      44.387  52.489  -1.058  1.00 35.95           N  
ATOM    381  CE2 TRP    52      43.779  51.360  -1.540  1.00 36.05           C  
ATOM    382  CE3 TRP    52      43.586  49.048  -0.923  1.00 33.32           C  
ATOM    383  CZ2 TRP    52      43.012  51.183  -2.686  1.00 34.77           C  
ATOM    384  CZ3 TRP    52      42.800  48.874  -2.076  1.00 34.80           C  
ATOM    385  CH2 TRP    52      42.536  49.944  -2.927  1.00 35.32           C  
ATOM    386  N   VAL    53      45.469  50.098   4.847  1.00 29.67           N  
ATOM    387  CA  VAL    53      45.486  49.168   5.949  1.00 28.16           C  
ATOM    388  C   VAL    53      44.216  48.335   5.810  1.00 28.83           C  
ATOM    389  O   VAL    53      43.091  48.875   5.642  1.00 26.41           O  
ATOM    390  CB  VAL    53      45.524  49.899   7.297  1.00 29.11           C  
ATOM    391  CG1 VAL    53      45.002  48.988   8.448  1.00 27.78           C  
ATOM    392  CG2 VAL    53      46.940  50.456   7.540  1.00 28.12           C  
ATOM    393  N   ILE    54      44.398  47.020   5.880  1.00 28.50           N  
ATOM    394  CA  ILE    54      43.285  46.084   5.847  1.00 29.08           C  
ATOM    395  C   ILE    54      43.358  45.195   7.076  1.00 28.55           C  
ATOM    396  O   ILE    54      44.330  44.453   7.275  1.00 28.15           O  
ATOM    397  CB  ILE    54      43.272  45.213   4.565  1.00 29.43           C  
ATOM    398  CG1 ILE    54      43.212  46.102   3.335  1.00 31.46           C  
ATOM    399  CG2 ILE    54      42.083  44.228   4.538  1.00 30.38           C  
ATOM    400  CD1 ILE    54      44.488  46.089   2.575  1.00 34.04           C  
ATOM    401  N   GLU    55      42.313  45.285   7.902  1.00 26.85           N  
ATOM    402  CA  GLU    55      42.162  44.439   9.044  1.00 26.66           C  
ATOM    403  C   GLU    55      41.252  43.269   8.697  1.00 28.23           C  
ATOM    404  O   GLU    55      40.051  43.473   8.371  1.00 28.33           O  
ATOM    405  CB  GLU    55      41.580  45.241  10.223  1.00 26.95           C  
ATOM    406  CG  GLU    55      42.539  46.184  10.860  1.00 26.27           C  
ATOM    407  CD  GLU    55      43.671  45.464  11.554  1.00 28.92           C  
ATOM    408  OE1 GLU    55      43.450  44.953  12.672  1.00 30.37           O  
ATOM    409  OE2 GLU    55      44.779  45.412  10.987  1.00 26.72           O  
ATOM    410  N   CYS    56      41.792  42.077   8.878  1.00 29.07           N  
ATOM    411  CA  CYS    56      41.168  40.830   8.506  1.00 30.82           C  
ATOM    412  C   CYS    56      40.524  40.220   9.729  1.00 30.88           C  
ATOM    413  O   CYS    56      41.192  39.664  10.573  1.00 31.72           O  
ATOM    414  CB  CYS    56      42.194  39.878   7.881  1.00 30.80           C  
ATOM    415  SG  CYS    56      42.965  40.559   6.395  1.00 33.27           S  
ATOM    416  N   LYS    57      39.200  40.314   9.830  1.00 31.20           N  
ATOM    417  CA  LYS    57      38.504  39.778  10.992  1.00 32.78           C  
ATOM    418  C   LYS    57      37.786  38.473  10.639  1.00 33.46           C  
ATOM    419  O   LYS    57      36.905  38.436   9.806  1.00 32.62           O  
ATOM    420  CB  LYS    57      37.546  40.818  11.544  1.00 32.90           C  
ATOM    421  CG  LYS    57      38.238  42.112  11.931  1.00 35.60           C  
ATOM    422  CD  LYS    57      39.230  41.804  13.049  1.00 38.77           C  
ATOM    423  CE  LYS    57      39.999  42.990  13.468  1.00 42.21           C  
ATOM    424  NZ  LYS    57      40.988  42.670  14.570  1.00 43.45           N  
ATOM    425  N   SER    58      38.177  37.406  11.314  1.00 34.39           N  
ATOM    426  CA  SER    58      37.759  36.075  10.947  1.00 35.27           C  
ATOM    427  C   SER    58      36.486  35.655  11.695  1.00 35.26           C  
ATOM    428  O   SER    58      35.881  34.626  11.349  1.00 35.69           O  
ATOM    429  CB  SER    58      38.909  35.128  11.231  1.00 35.37           C  
ATOM    430  OG  SER    58      39.287  35.218  12.615  1.00 40.50           O  
ATOM    431  N   SER    59      36.088  36.486  12.679  1.00 34.46           N  
ATOM    432  CA  SER    59      34.943  36.235  13.568  0.50 34.53           C  
ATOM    434  C   SER    59      34.438  37.565  14.128  1.00 34.32           C  
ATOM    435  O   SER    59      35.182  38.525  14.196  1.00 33.74           O  
ATOM    436  CB  SER    59      35.378  35.365  14.771  0.50 34.93           C  
ATOM    438  OG  SER    59      34.823  34.065  14.735  0.50 34.74           O  
ATOM    440  N   ARG    60      33.193  37.599  14.584  1.00 35.75           N  
ATOM    441  CA  ARG    60      32.698  38.720  15.407  1.00 36.62           C  
ATOM    442  C   ARG    60      33.565  39.036  16.632  1.00 36.50           C  
ATOM    443  O   ARG    60      33.778  40.208  16.965  1.00 36.82           O  
ATOM    444  CB  ARG    60      31.297  38.420  15.900  1.00 37.23           C  
ATOM    445  CG  ARG    60      30.263  38.651  14.860  1.00 38.79           C  
ATOM    446  CD  ARG    60      28.912  38.625  15.475  1.00 40.20           C  
ATOM    447  NE  ARG    60      28.666  39.815  16.293  1.00 41.47           N  
ATOM    448  CZ  ARG    60      27.469  40.177  16.734  1.00 42.08           C  
ATOM    449  NH1 ARG    60      26.401  39.449  16.442  1.00 43.37           N  
ATOM    450  NH2 ARG    60      27.334  41.270  17.477  1.00 44.05           N  
ATOM    451  N   ALA    61      34.067  38.001  17.303  1.00 36.87           N  
ATOM    452  CA  ALA    61      34.974  38.201  18.469  1.00 36.31           C  
ATOM    453  C   ALA    61      36.273  38.886  18.035  1.00 36.59           C  
ATOM    454  O   ALA    61      36.788  39.761  18.745  1.00 36.73           O  
ATOM    455  CB  ALA    61      35.277  36.897  19.149  1.00 36.61           C  
ATOM    456  N   ASP    62      36.789  38.512  16.862  1.00 35.46           N  
ATOM    457  CA  ASP    62      37.976  39.126  16.337  1.00 35.64           C  
ATOM    458  C   ASP    62      37.748  40.632  16.174  1.00 34.83           C  
ATOM    459  O   ASP    62      38.657  41.446  16.416  1.00 35.10           O  
ATOM    460  CB  ASP    62      38.337  38.498  14.985  1.00 36.39           C  
ATOM    461  CG  ASP    62      39.794  38.623  14.654  1.00 39.25           C  
ATOM    462  OD1 ASP    62      40.637  38.680  15.583  1.00 40.62           O  
ATOM    463  OD2 ASP    62      40.114  38.638  13.450  1.00 38.77           O  
ATOM    464  N   PHE    63      36.537  40.996  15.744  1.00 32.94           N  
ATOM    465  CA  PHE    63      36.179  42.398  15.477  1.00 32.11           C  
ATOM    466  C   PHE    63      36.010  43.121  16.817  1.00 32.58           C  
ATOM    467  O   PHE    63      36.473  44.247  16.995  1.00 33.27           O  
ATOM    468  CB  PHE    63      34.899  42.469  14.593  1.00 31.56           C  
ATOM    469  CG  PHE    63      34.233  43.797  14.589  1.00 28.81           C  
ATOM    470  CD1 PHE    63      34.871  44.893  14.078  1.00 28.17           C  
ATOM    471  CD2 PHE    63      32.950  43.943  15.088  1.00 30.00           C  
ATOM    472  CE1 PHE    63      34.249  46.153  14.108  1.00 28.32           C  
ATOM    473  CE2 PHE    63      32.322  45.178  15.078  1.00 30.25           C  
ATOM    474  CZ  PHE    63      32.984  46.282  14.580  1.00 27.83           C  
ATOM    475  N   GLN    64      35.367  42.451  17.756  1.00 32.42           N  
ATOM    476  CA  GLN    64      35.174  42.992  19.090  1.00 33.60           C  
ATOM    477  C   GLN    64      36.503  43.384  19.776  1.00 34.10           C  
ATOM    478  O   GLN    64      36.585  44.416  20.447  1.00 34.13           O  
ATOM    479  CB  GLN    64      34.339  42.001  19.920  1.00 33.32           C  
ATOM    480  CG  GLN    64      32.896  41.839  19.354  1.00 34.10           C  
ATOM    481  CD  GLN    64      32.197  40.512  19.741  1.00 36.83           C  
ATOM    482  OE1 GLN    64      32.667  39.775  20.614  1.00 36.11           O  
ATOM    483  NE2 GLN    64      31.044  40.241  19.116  1.00 35.53           N  
ATOM    484  N   ALA    65      37.536  42.579  19.568  1.00 34.84           N  
ATOM    485  CA  ALA    65      38.888  42.850  20.073  1.00 35.88           C  
ATOM    486  C   ALA    65      39.640  44.026  19.386  1.00 36.86           C  
ATOM    487  O   ALA    65      40.586  44.555  19.953  1.00 37.09           O  
ATOM    488  CB  ALA    65      39.730  41.571  19.976  1.00 36.04           C  
ATOM    489  N   ASP    66      39.240  44.431  18.182  1.00 37.60           N  
ATOM    490  CA  ASP    66      39.887  45.567  17.476  1.00 38.20           C  
ATOM    491  C   ASP    66      39.131  46.910  17.766  1.00 38.27           C  
ATOM    492  O   ASP    66      38.944  47.742  16.855  1.00 38.55           O  
ATOM    493  CB  ASP    66      39.892  45.279  15.965  1.00 38.37           C  
ATOM    494  CG  ASP    66      41.248  45.575  15.260  1.00 40.27           C  
ATOM    495  OD1 ASP    66      42.284  45.891  15.898  1.00 38.46           O  
ATOM    496  OD2 ASP    66      41.267  45.439  14.011  1.00 42.28           O  
ATOM    497  N   ALA    67      38.724  47.103  19.020  1.00 37.94           N  
ATOM    498  CA  ALA    67      37.974  48.306  19.476  1.00 38.18           C  
ATOM    499  C   ALA    67      38.679  49.661  19.239  1.00 37.68           C  
ATOM    500  O   ALA    67      38.021  50.673  18.984  1.00 37.88           O  
ATOM    501  CB  ALA    67      37.598  48.168  20.949  1.00 37.97           C  
ATOM    502  N   LYS    68      40.010  49.669  19.296  1.00 36.84           N  
ATOM    503  CA  LYS    68      40.799  50.888  19.048  1.00 35.73           C  
ATOM    504  C   LYS    68      41.176  51.071  17.554  1.00 34.00           C  
ATOM    505  O   LYS    68      42.146  51.766  17.261  1.00 33.51           O  
ATOM    506  CB  LYS    68      42.086  50.896  19.910  1.00 36.00           C  
ATOM    507  CG  LYS    68      41.893  50.587  21.402  1.00 36.85           C  
ATOM    508  CD  LYS    68      41.016  51.628  22.134  1.00 38.26           C  
ATOM    509  CE  LYS    68      40.923  51.324  23.629  1.00 39.01           C  
ATOM    510  NZ  LYS    68      40.768  52.534  24.508  1.00 39.85           N  
ATOM    511  N   TRP    69      40.385  50.487  16.640  1.00 31.74           N  
ATOM    512  CA  TRP    69      40.667  50.500  15.197  1.00 30.62           C  
ATOM    513  C   TRP    69      40.785  51.913  14.634  1.00 29.24           C  
ATOM    514  O   TRP    69      41.469  52.122  13.638  1.00 28.58           O  
ATOM    515  CB  TRP    69      39.585  49.721  14.388  1.00 30.33           C  
ATOM    516  CG  TRP    69      38.240  50.371  14.427  1.00 29.23           C  
ATOM    517  CD1 TRP    69      37.264  50.197  15.372  1.00 29.94           C  
ATOM    518  CD2 TRP    69      37.727  51.339  13.498  1.00 28.17           C  
ATOM    519  NE1 TRP    69      36.185  51.017  15.101  1.00 27.93           N  
ATOM    520  CE2 TRP    69      36.441  51.727  13.958  1.00 29.02           C  
ATOM    521  CE3 TRP    69      38.243  51.944  12.353  1.00 30.65           C  
ATOM    522  CZ2 TRP    69      35.660  52.686  13.298  1.00 28.93           C  
ATOM    523  CZ3 TRP    69      37.462  52.892  11.686  1.00 31.23           C  
ATOM    524  CH2 TRP    69      36.181  53.244  12.154  1.00 29.10           C  
ATOM    525  N   GLN    70      40.075  52.870  15.219  1.00 28.41           N  
ATOM    526  CA  GLN    70      40.212  54.247  14.743  1.00 28.68           C  
ATOM    527  C   GLN    70      41.675  54.745  14.825  1.00 27.89           C  
ATOM    528  O   GLN    70      42.046  55.631  14.071  1.00 27.19           O  
ATOM    529  CB  GLN    70      39.254  55.186  15.435  1.00 29.10           C  
ATOM    530  CG  GLN    70      37.903  55.186  14.729  1.00 32.33           C  
ATOM    531  CD  GLN    70      36.780  55.565  15.629  1.00 36.45           C  
ATOM    532  OE1 GLN    70      36.146  56.603  15.447  1.00 39.10           O  
ATOM    533  NE2 GLN    70      36.514  54.724  16.628  1.00 40.07           N  
ATOM    534  N   GLY    71      42.485  54.128  15.692  1.00 27.12           N  
ATOM    535  CA  GLY    71      43.918  54.424  15.785  1.00 27.41           C  
ATOM    536  C   GLY    71      44.742  54.035  14.580  1.00 27.35           C  
ATOM    537  O   GLY    71      45.866  54.548  14.401  1.00 27.03           O  
ATOM    538  N   TYR    72      44.216  53.130  13.754  1.00 26.61           N  
ATOM    539  CA  TYR    72      44.875  52.798  12.505  1.00 26.99           C  
ATOM    540  C   TYR    72      44.747  53.886  11.439  1.00 27.21           C  
ATOM    541  O   TYR    72      45.543  53.935  10.512  1.00 26.79           O  
ATOM    542  CB  TYR    72      44.345  51.508  11.900  1.00 27.27           C  
ATOM    543  CG  TYR    72      44.484  50.262  12.727  1.00 27.75           C  
ATOM    544  CD1 TYR    72      43.357  49.517  13.068  1.00 28.90           C  
ATOM    545  CD2 TYR    72      45.732  49.788  13.133  1.00 30.26           C  
ATOM    546  CE1 TYR    72      43.455  48.343  13.795  1.00 29.21           C  
ATOM    547  CE2 TYR    72      45.842  48.595  13.883  1.00 29.26           C  
ATOM    548  CZ  TYR    72      44.699  47.889  14.212  1.00 31.18           C  
ATOM    549  OH  TYR    72      44.749  46.721  14.939  1.00 29.57           O  
ATOM    550  N   LEU    73      43.746  54.745  11.560  1.00 27.33           N  
ATOM    551  CA  LEU    73      43.444  55.725  10.512  1.00 27.22           C  
ATOM    552  C   LEU    73      44.593  56.676  10.138  1.00 26.79           C  
ATOM    553  O   LEU    73      44.805  56.986   8.953  1.00 26.50           O  
ATOM    554  CB  LEU    73      42.182  56.510  10.914  1.00 27.40           C  
ATOM    555  CG  LEU    73      40.896  55.651  10.984  1.00 26.60           C  
ATOM    556  CD1 LEU    73      39.633  56.515  11.140  1.00 25.98           C  
ATOM    557  CD2 LEU    73      40.786  54.743   9.750  1.00 25.85           C  
ATOM    558  N   GLU    74      45.315  57.149  11.151  1.00 26.70           N  
ATOM    559  CA  GLU    74      46.412  58.063  10.955  1.00 27.00           C  
ATOM    560  C   GLU    74      47.628  57.423  10.287  1.00 27.17           C  
ATOM    561  O   GLU    74      48.600  58.110   9.988  1.00 26.94           O  
ATOM    562  CB  GLU    74      46.822  58.705  12.295  1.00 27.76           C  
ATOM    563  CG  GLU    74      47.378  57.758  13.380  1.00 27.43           C  
ATOM    564  CD  GLU    74      48.101  58.532  14.471  1.00 30.96           C  
ATOM    565  OE1 GLU    74      48.632  59.626  14.155  1.00 29.86           O  
ATOM    566  OE2 GLU    74      48.148  58.061  15.633  1.00 31.00           O  
ATOM    567  N   TRP    75      47.585  56.116  10.063  1.00 27.84           N  
ATOM    568  CA  TRP    75      48.713  55.401   9.472  1.00 28.52           C  
ATOM    569  C   TRP    75      48.442  54.918   8.057  1.00 29.51           C  
ATOM    570  O   TRP    75      49.194  54.082   7.563  1.00 29.23           O  
ATOM    571  CB  TRP    75      49.091  54.215  10.359  1.00 28.34           C  
ATOM    572  CG  TRP    75      49.499  54.652  11.707  1.00 27.70           C  
ATOM    573  CD1 TRP    75      48.796  54.501  12.861  1.00 28.32           C  
ATOM    574  CD2 TRP    75      50.698  55.368  12.052  1.00 28.02           C  
ATOM    575  NE1 TRP    75      49.489  55.068  13.914  1.00 26.63           N  
ATOM    576  CE2 TRP    75      50.656  55.606  13.443  1.00 26.73           C  
ATOM    577  CE3 TRP    75      51.801  55.832  11.317  1.00 26.37           C  
ATOM    578  CZ2 TRP    75      51.671  56.264  14.113  1.00 28.27           C  
ATOM    579  CZ3 TRP    75      52.808  56.476  11.976  1.00 27.45           C  
ATOM    580  CH2 TRP    75      52.738  56.701  13.368  1.00 28.83           C  
ATOM    581  N   CYS    76      47.378  55.432   7.421  1.00 30.37           N  
ATOM    582  CA  CYS    76      47.009  55.020   6.068  1.00 30.52           C  
ATOM    583  C   CYS    76      46.244  56.096   5.308  1.00 30.62           C  
ATOM    584  O   CYS    76      45.786  57.063   5.885  1.00 30.35           O  
ATOM    585  CB  CYS    76      46.196  53.716   6.100  1.00 29.95           C  
ATOM    586  SG  CYS    76      44.615  53.781   6.963  1.00 33.52           S  
ATOM    587  N   ASP    77      46.205  55.957   3.990  1.00 30.59           N  
ATOM    588  CA  ASP    77      45.364  56.773   3.143  1.00 30.05           C  
ATOM    589  C   ASP    77      43.938  56.224   3.149  1.00 30.40           C  
ATOM    590  O   ASP    77      43.001  57.002   3.152  1.00 30.16           O  
ATOM    591  CB  ASP    77      45.881  56.791   1.713  1.00 30.00           C  
ATOM    592  CG  ASP    77      47.242  57.385   1.598  1.00 29.91           C  
ATOM    593  OD1 ASP    77      47.476  58.506   2.117  1.00 29.20           O  
ATOM    594  OD2 ASP    77      48.076  56.757   0.963  1.00 28.27           O  
ATOM    595  N   ARG    78      43.790  54.896   3.164  1.00 29.42           N  
ATOM    596  CA  ARG    78      42.491  54.227   3.170  1.00 30.31           C  
ATOM    597  C   ARG    78      42.547  53.037   4.126  1.00 30.99           C  
ATOM    598  O   ARG    78      43.531  52.321   4.164  1.00 30.71           O  
ATOM    599  CB  ARG    78      42.104  53.747   1.780  1.00 28.64           C  
ATOM    600  CG  ARG    78      41.965  54.859   0.751  1.00 30.72           C  
ATOM    601  CD  ARG    78      41.314  54.348  -0.506  1.00 30.48           C  
ATOM    602  NE  ARG    78      41.571  55.200  -1.659  1.00 32.15           N  
ATOM    603  CZ  ARG    78      40.678  55.961  -2.286  1.00 32.66           C  
ATOM    604  NH1 ARG    78      41.056  56.684  -3.326  1.00 32.79           N  
ATOM    605  NH2 ARG    78      39.419  55.982  -1.928  1.00 32.58           N  
ATOM    606  N   TYR    79      41.504  52.900   4.921  1.00 31.70           N  
ATOM    607  CA  TYR    79      41.309  51.824   5.903  1.00 31.79           C  
ATOM    608  C   TYR    79      40.117  50.941   5.538  1.00 32.08           C  
ATOM    609  O   TYR    79      38.991  51.439   5.249  1.00 31.39           O  
ATOM    610  CB  TYR    79      41.068  52.422   7.300  1.00 32.61           C  
ATOM    611  CG  TYR    79      40.800  51.366   8.318  1.00 31.46           C  
ATOM    612  CD1 TYR    79      41.838  50.715   8.945  1.00 35.19           C  
ATOM    613  CD2 TYR    79      39.485  51.014   8.662  1.00 34.21           C  
ATOM    614  CE1 TYR    79      41.600  49.708   9.871  1.00 34.13           C  
ATOM    615  CE2 TYR    79      39.236  50.004   9.565  1.00 34.41           C  
ATOM    616  CZ  TYR    79      40.307  49.385  10.195  1.00 35.70           C  
ATOM    617  OH  TYR    79      40.092  48.395  11.112  1.00 36.52           O  
ATOM    618  N   PHE    80      40.364  49.625   5.526  1.00 32.04           N  
ATOM    619  CA  PHE    80      39.387  48.598   5.133  1.00 31.79           C  
ATOM    620  C   PHE    80      39.313  47.502   6.169  1.00 32.70           C  
ATOM    621  O   PHE    80      40.330  47.155   6.826  1.00 30.72           O  
ATOM    622  CB  PHE    80      39.748  47.846   3.853  1.00 31.81           C  
ATOM    623  CG  PHE    80      39.922  48.711   2.634  1.00 30.72           C  
ATOM    624  CD1 PHE    80      38.977  48.736   1.631  1.00 31.33           C  
ATOM    625  CD2 PHE    80      41.078  49.473   2.485  1.00 31.26           C  
ATOM    626  CE1 PHE    80      39.166  49.520   0.490  1.00 31.56           C  
ATOM    627  CE2 PHE    80      41.276  50.243   1.358  1.00 28.69           C  
ATOM    628  CZ  PHE    80      40.313  50.285   0.368  1.00 31.86           C  
ATOM    629  N   TRP    81      38.103  46.939   6.278  1.00 31.67           N  
ATOM    630  CA  TRP    81      37.898  45.626   6.873  1.00 32.90           C  
ATOM    631  C   TRP    81      37.907  44.570   5.785  1.00 32.20           C  
ATOM    632  O   TRP    81      37.542  44.863   4.660  1.00 32.23           O  
ATOM    633  CB  TRP    81      36.585  45.564   7.622  1.00 34.68           C  
ATOM    634  CG  TRP    81      36.425  46.615   8.659  1.00 34.01           C  
ATOM    635  CD1 TRP    81      35.813  47.807   8.501  1.00 36.49           C  
ATOM    636  CD2 TRP    81      36.884  46.564  10.020  1.00 34.58           C  
ATOM    637  NE1 TRP    81      35.847  48.515   9.689  1.00 37.61           N  
ATOM    638  CE2 TRP    81      36.529  47.772  10.620  1.00 35.18           C  
ATOM    639  CE3 TRP    81      37.571  45.606  10.778  1.00 36.93           C  
ATOM    640  CZ2 TRP    81      36.810  48.046  11.954  1.00 37.41           C  
ATOM    641  CZ3 TRP    81      37.868  45.885  12.090  1.00 37.27           C  
ATOM    642  CH2 TRP    81      37.502  47.087  12.661  1.00 36.57           C  
ATOM    643  N   ALA    82      38.366  43.369   6.115  1.00 31.59           N  
ATOM    644  CA  ALA    82      38.247  42.185   5.236  1.00 31.92           C  
ATOM    645  C   ALA    82      37.638  41.056   6.088  1.00 30.84           C  
ATOM    646  O   ALA    82      38.151  40.731   7.143  1.00 30.63           O  
ATOM    647  CB  ALA    82      39.603  41.768   4.638  1.00 31.84           C  
ATOM    648  N   VAL    83      36.521  40.514   5.618  1.00 31.32           N  
ATOM    649  CA  VAL    83      35.763  39.465   6.294  1.00 30.64           C  
ATOM    650  C   VAL    83      35.287  38.454   5.271  1.00 31.95           C  
ATOM    651  O   VAL    83      35.279  38.730   4.050  1.00 31.88           O  
ATOM    652  CB  VAL    83      34.547  40.051   7.056  1.00 31.36           C  
ATOM    653  CG1 VAL    83      35.014  41.082   8.109  1.00 30.90           C  
ATOM    654  CG2 VAL    83      33.498  40.665   6.110  1.00 26.79           C  
ATOM    655  N   ASP    84      34.864  37.288   5.742  1.00 31.62           N  
ATOM    656  CA  ASP    84      34.318  36.324   4.835  1.00 31.95           C  
ATOM    657  C   ASP    84      32.794  36.515   4.712  1.00 31.17           C  
ATOM    658  O   ASP    84      32.190  37.331   5.409  1.00 29.18           O  
ATOM    659  CB  ASP    84      34.732  34.908   5.241  1.00 32.92           C  
ATOM    660  CG  ASP    84      34.059  34.396   6.503  1.00 34.47           C  
ATOM    661  OD1 ASP    84      32.989  34.896   6.988  1.00 34.31           O  
ATOM    662  OD2 ASP    84      34.622  33.393   7.008  1.00 41.19           O  
ATOM    663  N   MET    85      32.191  35.692   3.879  1.00 32.20           N  
ATOM    664  CA  MET    85      30.760  35.790   3.578  0.60 33.07           C  
ATOM    666  C   MET    85      29.846  35.354   4.727  1.00 33.77           C  
ATOM    667  O   MET    85      28.611  35.550   4.649  1.00 33.86           O  
ATOM    668  CB  MET    85      30.430  35.009   2.289  0.60 33.52           C  
ATOM    670  CG  MET    85      30.604  33.478   2.356  0.60 34.27           C  
ATOM    672  SD  MET    85      30.588  32.530   0.595  0.39 34.96          SE  
ATOM    674  CE  MET    85      30.777  30.720   1.349  0.60 39.15           C  
ATOM    676  N   GLU    86      30.414  34.741   5.778  1.00 34.54           N  
ATOM    677  CA  GLU    86      29.642  34.341   6.979  0.50 34.80           C  
ATOM    679  C   GLU    86      29.586  35.463   8.020  1.00 34.52           C  
ATOM    680  O   GLU    86      28.776  35.419   8.932  1.00 33.91           O  
ATOM    681  CB  GLU    86      30.258  33.118   7.664  0.50 35.25           C  
ATOM    683  CG  GLU    86      29.928  31.766   7.060  0.50 37.34           C  
ATOM    685  CD  GLU    86      30.082  30.639   8.082  0.50 39.05           C  
ATOM    687  OE1 GLU    86      31.231  30.281   8.424  0.50 40.29           O  
ATOM    689  OE2 GLU    86      29.047  30.136   8.562  0.50 41.01           O  
ATOM    691  N   PHE    87      30.459  36.460   7.881  1.00 33.43           N  
ATOM    692  CA  PHE    87      30.514  37.608   8.799  1.00 32.14           C  
ATOM    693  C   PHE    87      29.291  38.555   8.647  1.00 33.28           C  
ATOM    694  O   PHE    87      28.853  38.836   7.525  1.00 32.13           O  
ATOM    695  CB  PHE    87      31.831  38.369   8.601  1.00 32.08           C  
ATOM    696  CG  PHE    87      32.117  39.391   9.671  1.00 31.34           C  
ATOM    697  CD1 PHE    87      32.996  39.101  10.712  1.00 33.19           C  
ATOM    698  CD2 PHE    87      31.495  40.627   9.658  1.00 29.19           C  
ATOM    699  CE1 PHE    87      33.261  40.043  11.719  1.00 32.29           C  
ATOM    700  CE2 PHE    87      31.737  41.582  10.675  1.00 30.70           C  
ATOM    701  CZ  PHE    87      32.628  41.276  11.707  1.00 33.57           C  
ATOM    702  N   PRO    88      28.731  39.060   9.777  1.00 32.74           N  
ATOM    703  CA  PRO    88      27.627  40.050   9.723  1.00 32.84           C  
ATOM    704  C   PRO    88      28.187  41.443   9.366  1.00 32.72           C  
ATOM    705  O   PRO    88      28.366  42.318  10.232  1.00 32.91           O  
ATOM    706  CB  PRO    88      27.043  39.997  11.167  1.00 33.17           C  
ATOM    707  CG  PRO    88      28.226  39.725  11.959  1.00 33.49           C  
ATOM    708  CD  PRO    88      29.088  38.758  11.175  1.00 33.24           C  
ATOM    709  N   ALA    89      28.484  41.624   8.075  1.00 31.13           N  
ATOM    710  CA  ALA    89      29.129  42.815   7.561  1.00 30.72           C  
ATOM    711  C   ALA    89      28.449  44.156   7.895  1.00 30.38           C  
ATOM    712  O   ALA    89      29.130  45.181   7.983  1.00 31.56           O  
ATOM    713  CB  ALA    89      29.312  42.676   5.982  1.00 30.19           C  
ATOM    714  N   GLU    90      27.137  44.157   8.098  1.00 30.99           N  
ATOM    715  CA  GLU    90      26.377  45.371   8.444  1.00 31.12           C  
ATOM    716  C   GLU    90      26.762  45.985   9.776  1.00 32.02           C  
ATOM    717  O   GLU    90      26.505  47.156  10.024  1.00 33.10           O  
ATOM    718  CB  GLU    90      24.871  45.089   8.446  1.00 31.81           C  
ATOM    719  CG  GLU    90      24.254  45.011   7.027  1.00 29.73           C  
ATOM    720  CD  GLU    90      22.794  44.731   6.953  1.00 33.74           C  
ATOM    721  OE1 GLU    90      22.035  44.680   7.990  1.00 34.20           O  
ATOM    722  OE2 GLU    90      22.331  44.553   5.798  1.00 31.05           O  
ATOM    723  N   LEU    91      27.346  45.173  10.634  1.00 32.63           N  
ATOM    724  CA  LEU    91      27.817  45.612  11.959  1.00 34.26           C  
ATOM    725  C   LEU    91      29.124  46.366  11.898  1.00 34.34           C  
ATOM    726  O   LEU    91      29.487  47.004  12.865  1.00 34.35           O  
ATOM    727  CB  LEU    91      27.953  44.408  12.899  1.00 34.39           C  
ATOM    728  CG  LEU    91      26.625  43.659  13.155  1.00 36.53           C  
ATOM    729  CD1 LEU    91      26.799  42.696  14.337  1.00 38.24           C  
ATOM    730  CD2 LEU    91      25.377  44.560  13.379  1.00 39.11           C  
ATOM    731  N   LEU    92      29.845  46.295  10.770  1.00 34.27           N  
ATOM    732  CA  LEU    92      31.108  47.030  10.663  1.00 34.20           C  
ATOM    733  C   LEU    92      30.811  48.550  10.494  1.00 35.17           C  
ATOM    734  O   LEU    92      29.763  48.939   9.946  1.00 33.79           O  
ATOM    735  CB  LEU    92      31.972  46.516   9.532  1.00 32.57           C  
ATOM    736  CG  LEU    92      32.376  45.057   9.589  1.00 33.16           C  
ATOM    737  CD1 LEU    92      32.911  44.474   8.185  1.00 32.52           C  
ATOM    738  CD2 LEU    92      33.408  44.895  10.689  1.00 32.37           C  
ATOM    739  N   PRO    93      31.734  49.401  10.978  1.00 35.81           N  
ATOM    740  CA  PRO    93      31.588  50.865  10.836  1.00 37.22           C  
ATOM    741  C   PRO    93      31.281  51.285   9.374  1.00 38.57           C  
ATOM    742  O   PRO    93      31.985  50.864   8.435  1.00 37.83           O  
ATOM    743  CB  PRO    93      32.946  51.397  11.245  1.00 37.53           C  
ATOM    744  CG  PRO    93      33.556  50.341  12.105  1.00 37.95           C  
ATOM    745  CD  PRO    93      32.951  49.019  11.699  1.00 37.38           C  
ATOM    746  N   ALA    94      30.265  52.121   9.212  1.00 39.21           N  
ATOM    747  CA  ALA    94      29.795  52.547   7.908  1.00 40.64           C  
ATOM    748  C   ALA    94      30.846  53.293   7.097  1.00 41.69           C  
ATOM    749  O   ALA    94      30.839  53.220   5.871  1.00 43.45           O  
ATOM    750  CB  ALA    94      28.594  53.435   8.093  1.00 40.53           C  
ATOM    751  N   GLU    95      31.727  54.001   7.795  1.00 42.61           N  
ATOM    752  CA  GLU    95      32.748  54.890   7.206  0.50 43.01           C  
ATOM    754  C   GLU    95      33.948  54.142   6.627  1.00 42.97           C  
ATOM    755  O   GLU    95      34.721  54.703   5.853  1.00 45.71           O  
ATOM    756  CB  GLU    95      33.224  55.927   8.244  0.50 42.81           C  
ATOM    758  CG  GLU    95      33.351  55.423   9.716  0.50 43.53           C  
ATOM    760  CD  GLU    95      31.991  55.154  10.401  0.50 42.38           C  
ATOM    762  OE1 GLU    95      30.966  55.697   9.959  0.50 44.03           O  
ATOM    764  OE2 GLU    95      31.944  54.374  11.363  0.50 42.48           O  
ATOM    766  N   SER    96      34.114  52.886   7.026  1.00 41.41           N  
ATOM    767  CA  SER    96      35.207  52.049   6.582  1.00 40.17           C  
ATOM    768  C   SER    96      35.003  51.437   5.201  1.00 37.08           C  
ATOM    769  O   SER    96      33.889  51.255   4.728  1.00 35.17           O  
ATOM    770  CB  SER    96      35.375  50.924   7.590  1.00 40.72           C  
ATOM    771  OG  SER    96      35.655  51.500   8.866  1.00 45.53           O  
ATOM    772  N   GLY    97      36.105  51.139   4.543  1.00 34.07           N  
ATOM    773  CA  GLY    97      36.084  50.291   3.371  1.00 32.64           C  
ATOM    774  C   GLY    97      35.839  48.835   3.746  1.00 31.97           C  
ATOM    775  O   GLY    97      35.950  48.465   4.912  1.00 29.99           O  
ATOM    776  N   LEU    98      35.454  48.020   2.750  1.00 31.37           N  
ATOM    777  CA  LEU    98      35.116  46.642   3.021  1.00 31.04           C  
ATOM    778  C   LEU    98      35.460  45.738   1.870  1.00 30.64           C  
ATOM    779  O   LEU    98      35.038  45.971   0.717  1.00 30.06           O  
ATOM    780  CB  LEU    98      33.600  46.511   3.358  1.00 30.97           C  
ATOM    781  CG  LEU    98      33.051  45.099   3.698  1.00 32.31           C  
ATOM    782  CD1 LEU    98      33.697  44.497   4.956  1.00 31.26           C  
ATOM    783  CD2 LEU    98      31.482  45.121   3.898  1.00 30.70           C  
ATOM    784  N   LEU    99      36.162  44.651   2.197  1.00 30.07           N  
ATOM    785  CA  LEU    99      36.381  43.569   1.266  1.00 30.81           C  
ATOM    786  C   LEU    99      35.723  42.331   1.801  1.00 30.99           C  
ATOM    787  O   LEU    99      35.727  42.091   3.010  1.00 30.71           O  
ATOM    788  CB  LEU    99      37.885  43.238   1.058  1.00 32.25           C  
ATOM    789  CG  LEU    99      38.770  44.242   0.321  1.00 32.98           C  
ATOM    790  CD1 LEU    99      39.193  45.320   1.271  1.00 36.62           C  
ATOM    791  CD2 LEU    99      39.975  43.565  -0.229  1.00 33.97           C  
ATOM    792  N   ILE   100      35.168  41.546   0.897  1.00 30.41           N  
ATOM    793  CA  ILE   100      34.792  40.177   1.217  1.00 31.12           C  
ATOM    794  C   ILE   100      35.857  39.246   0.639  1.00 30.61           C  
ATOM    795  O   ILE   100      36.181  39.339  -0.545  1.00 30.06           O  
ATOM    796  CB  ILE   100      33.400  39.807   0.645  1.00 31.37           C  
ATOM    797  CG1 ILE   100      32.316  40.838   1.017  1.00 32.21           C  
ATOM    798  CG2 ILE   100      33.034  38.396   1.054  1.00 30.76           C  
ATOM    799  CD1 ILE   100      32.001  40.891   2.463  1.00 32.10           C  
ATOM    800  N   ALA   101      36.414  38.375   1.482  1.00 31.06           N  
ATOM    801  CA  ALA   101      37.602  37.608   1.150  1.00 31.30           C  
ATOM    802  C   ALA   101      37.462  36.157   1.616  1.00 32.07           C  
ATOM    803  O   ALA   101      36.580  35.821   2.438  1.00 29.94           O  
ATOM    804  CB  ALA   101      38.853  38.257   1.800  1.00 30.94           C  
ATOM    805  N   ASP   102      38.309  35.310   1.033  1.00 31.99           N  
ATOM    806  CA  ASP   102      38.595  33.959   1.547  1.00 32.72           C  
ATOM    807  C   ASP   102      40.051  33.647   1.231  1.00 31.93           C  
ATOM    808  O   ASP   102      40.771  34.553   0.879  1.00 31.12           O  
ATOM    809  CB  ASP   102      37.619  32.888   1.009  1.00 33.33           C  
ATOM    810  CG  ASP   102      37.670  32.697  -0.519  1.00 34.59           C  
ATOM    811  OD1 ASP   102      38.603  33.128  -1.228  1.00 33.45           O  
ATOM    812  OD2 ASP   102      36.735  32.065  -1.039  1.00 37.52           O  
ATOM    813  N   ALA   103      40.484  32.386   1.337  1.00 31.51           N  
ATOM    814  CA  ALA   103      41.897  32.076   1.133  1.00 31.02           C  
ATOM    815  C   ALA   103      42.311  32.249  -0.308  1.00 30.32           C  
ATOM    816  O   ALA   103      43.492  32.289  -0.557  1.00 30.88           O  
ATOM    817  CB  ALA   103      42.253  30.645   1.612  1.00 32.43           C  
ATOM    818  N   TYR   104      41.363  32.384  -1.245  1.00 28.87           N  
ATOM    819  CA  TYR   104      41.695  32.281  -2.640  1.00 28.34           C  
ATOM    820  C   TYR   104      41.545  33.554  -3.446  1.00 28.54           C  
ATOM    821  O   TYR   104      42.086  33.648  -4.556  1.00 27.28           O  
ATOM    822  CB  TYR   104      40.829  31.212  -3.278  1.00 29.91           C  
ATOM    823  CG  TYR   104      40.922  29.917  -2.508  1.00 31.41           C  
ATOM    824  CD1 TYR   104      42.062  29.153  -2.586  1.00 34.46           C  
ATOM    825  CD2 TYR   104      39.903  29.514  -1.639  1.00 31.16           C  
ATOM    826  CE1 TYR   104      42.179  27.950  -1.899  1.00 36.23           C  
ATOM    827  CE2 TYR   104      40.014  28.327  -0.920  1.00 33.40           C  
ATOM    828  CZ  TYR   104      41.157  27.549  -1.064  1.00 35.57           C  
ATOM    829  OH  TYR   104      41.324  26.371  -0.378  1.00 36.02           O  
ATOM    830  N   ASP   105      40.810  34.511  -2.908  1.00 28.70           N  
ATOM    831  CA  ASP   105      40.516  35.766  -3.623  1.00 30.60           C  
ATOM    832  C   ASP   105      39.815  36.739  -2.694  1.00 29.56           C  
ATOM    833  O   ASP   105      39.558  36.423  -1.538  1.00 29.98           O  
ATOM    834  CB  ASP   105      39.662  35.489  -4.837  1.00 31.52           C  
ATOM    835  CG  ASP   105      39.812  36.551  -5.961  1.00 35.65           C  
ATOM    836  OD1 ASP   105      40.466  37.614  -5.812  1.00 38.92           O  
ATOM    837  OD2 ASP   105      39.239  36.279  -7.007  1.00 38.82           O  
ATOM    838  N   ALA   106      39.534  37.941  -3.196  1.00 29.26           N  
ATOM    839  CA  ALA   106      38.810  38.950  -2.472  1.00 28.38           C  
ATOM    840  C   ALA   106      38.166  39.942  -3.425  1.00 29.35           C  
ATOM    841  O   ALA   106      38.511  40.010  -4.609  1.00 28.75           O  
ATOM    842  CB  ALA   106      39.710  39.672  -1.485  1.00 28.01           C  
ATOM    843  N   GLU   107      37.169  40.682  -2.940  1.00 29.53           N  
ATOM    844  CA  GLU   107      36.594  41.794  -3.723  1.00 29.12           C  
ATOM    845  C   GLU   107      36.297  42.980  -2.834  1.00 28.84           C  
ATOM    846  O   GLU   107      35.868  42.822  -1.713  1.00 30.23           O  
ATOM    847  CB  GLU   107      35.334  41.359  -4.476  1.00 31.03           C  
ATOM    848  CG  GLU   107      34.201  40.871  -3.577  1.00 31.48           C  
ATOM    849  CD  GLU   107      32.986  40.326  -4.320  1.00 36.07           C  
ATOM    850  OE1 GLU   107      32.978  40.275  -5.558  1.00 29.32           O  
ATOM    851  OE2 GLU   107      32.007  39.912  -3.637  1.00 32.19           O  
ATOM    852  N   ILE   108      36.489  44.178  -3.326  1.00 28.49           N  
ATOM    853  CA  ILE   108      36.142  45.373  -2.566  1.00 29.19           C  
ATOM    854  C   ILE   108      34.641  45.582  -2.845  1.00 29.79           C  
ATOM    855  O   ILE   108      34.221  45.650  -4.002  1.00 31.57           O  
ATOM    856  CB  ILE   108      36.910  46.589  -3.041  1.00 30.58           C  
ATOM    857  CG1 ILE   108      38.430  46.385  -2.854  1.00 31.34           C  
ATOM    858  CG2 ILE   108      36.395  47.861  -2.347  1.00 29.43           C  
ATOM    859  CD1 ILE   108      39.242  47.503  -3.377  1.00 30.62           C  
ATOM    860  N   VAL   109      33.844  45.597  -1.808  1.00 29.31           N  
ATOM    861  CA  VAL   109      32.410  45.850  -1.989  1.00 29.33           C  
ATOM    862  C   VAL   109      32.060  47.292  -1.589  1.00 30.06           C  
ATOM    863  O   VAL   109      30.997  47.791  -1.952  1.00 29.09           O  
ATOM    864  CB  VAL   109      31.540  44.803  -1.274  1.00 28.67           C  
ATOM    865  CG1 VAL   109      31.664  43.424  -2.020  1.00 28.48           C  
ATOM    866  CG2 VAL   109      31.878  44.678   0.186  1.00 27.23           C  
ATOM    867  N   ARG   110      32.957  47.921  -0.833  1.00 30.48           N  
ATOM    868  CA  ARG   110      32.838  49.302  -0.415  1.00 31.76           C  
ATOM    869  C   ARG   110      34.221  49.948  -0.323  1.00 31.92           C  
ATOM    870  O   ARG   110      35.073  49.527   0.469  1.00 30.40           O  
ATOM    871  CB  ARG   110      32.121  49.351   0.949  1.00 33.34           C  
ATOM    872  CG  ARG   110      31.775  50.723   1.408  1.00 32.47           C  
ATOM    873  CD  ARG   110      30.784  50.639   2.558  1.00 34.55           C  
ATOM    874  NE  ARG   110      31.397  50.331   3.818  1.00 33.13           N  
ATOM    875  CZ  ARG   110      30.895  49.500   4.742  1.00 38.01           C  
ATOM    876  NH1 ARG   110      31.545  49.328   5.885  1.00 38.34           N  
ATOM    877  NH2 ARG   110      29.748  48.860   4.549  1.00 38.93           N  
ATOM    878  N   MET   111      34.440  50.976  -1.143  1.00 32.39           N  
ATOM    879  CA  MET   111      35.747  51.614  -1.248  1.00 32.61           C  
ATOM    880  C   MET   111      35.901  52.493  -0.031  1.00 32.80           C  
ATOM    881  O   MET   111      34.948  53.179   0.350  1.00 34.31           O  
ATOM    882  CB  MET   111      35.831  52.404  -2.563  1.00 32.09           C  
ATOM    883  CG  MET   111      37.074  53.170  -2.762  1.00 32.99           C  
ATOM    884  SD  MET   111      38.685  52.092  -2.676  0.65 32.64          SE  
ATOM    885  CE  MET   111      38.431  50.909  -4.191  1.00 29.40           C  
ATOM    886  N   ALA   112      37.062  52.452   0.621  1.00 31.88           N  
ATOM    887  CA  ALA   112      37.270  53.287   1.767  1.00 32.18           C  
ATOM    888  C   ALA   112      37.368  54.764   1.359  1.00 31.82           C  
ATOM    889  O   ALA   112      37.847  55.099   0.267  1.00 31.28           O  
ATOM    890  CB  ALA   112      38.475  52.826   2.516  1.00 32.74           C  
ATOM    891  N   PRO   113      36.904  55.676   2.233  1.00 32.37           N  
ATOM    892  CA  PRO   113      37.153  57.097   1.969  1.00 32.98           C  
ATOM    893  C   PRO   113      38.671  57.422   2.065  1.00 34.37           C  
ATOM    894  O   PRO   113      39.385  56.746   2.804  1.00 33.27           O  
ATOM    895  CB  PRO   113      36.361  57.804   3.071  1.00 33.32           C  
ATOM    896  CG  PRO   113      36.246  56.845   4.164  1.00 33.19           C  
ATOM    897  CD  PRO   113      36.175  55.470   3.501  1.00 32.47           C  
ATOM    898  N   GLU   114      39.137  58.416   1.302  1.00 36.51           N  
ATOM    899  CA  GLU   114      40.559  58.817   1.305  1.00 38.56           C  
ATOM    900  C   GLU   114      40.847  59.871   2.385  1.00 39.40           C  
ATOM    901  O   GLU   114      40.219  60.919   2.412  1.00 39.23           O  
ATOM    902  CB  GLU   114      41.010  59.331  -0.076  1.00 38.96           C  
ATOM    903  CG  GLU   114      42.488  59.786  -0.083  1.00 42.79           C  
ATOM    904  CD  GLU   114      43.315  59.213  -1.225  1.00 47.89           C  
ATOM    905  OE1 GLU   114      42.714  58.779  -2.224  1.00 53.14           O  
ATOM    906  OE2 GLU   114      44.570  59.197  -1.131  1.00 48.25           O  
ATOM    907  N   GLN   115      41.783  59.548   3.275  1.00 40.80           N  
ATOM    908  CA  GLN   115      42.268  60.446   4.317  0.50 41.99           C  
ATOM    910  C   GLN   115      43.793  60.544   4.173  1.00 42.34           C  
ATOM    911  O   GLN   115      44.534  60.025   5.015  1.00 42.61           O  
ATOM    912  CB  GLN   115      41.880  59.905   5.712  0.50 42.46           C  
ATOM    914  CG  GLN   115      40.818  58.772   5.706  0.50 44.17           C  
ATOM    916  CD  GLN   115      39.800  58.895   6.827  0.50 45.73           C  
ATOM    918  OE1 GLN   115      38.600  58.789   6.585  0.50 47.54           O  
ATOM    920  NE2 GLN   115      40.271  59.125   8.052  0.50 47.44           N  
ATOM    922  N   LYS   116      44.249  61.179   3.097  1.00 42.86           N  
ATOM    923  CA  LYS   116      45.673  61.190   2.744  1.00 43.55           C  
ATOM    924  C   LYS   116      46.675  61.487   3.886  1.00 43.30           C  
ATOM    925  O   LYS   116      46.454  62.315   4.770  1.00 42.24           O  
ATOM    926  CB  LYS   116      45.944  62.167   1.595  1.00 44.43           C  
ATOM    927  CG  LYS   116      45.694  61.624   0.183  1.00 46.12           C  
ATOM    928  CD  LYS   116      46.476  62.501  -0.855  1.00 48.81           C  
ATOM    929  CE  LYS   116      45.588  63.021  -2.009  1.00 50.12           C  
ATOM    930  NZ  LYS   116      45.068  61.926  -2.889  1.00 51.16           N  
ATOM    931  N   LEU   117      47.795  60.786   3.801  1.00 43.26           N  
ATOM    932  CA  LEU   117      48.880  60.847   4.762  1.00 43.52           C  
ATOM    933  C   LEU   117      49.768  62.060   4.391  1.00 43.97           C  
ATOM    934  O   LEU   117      49.868  62.431   3.218  1.00 43.20           O  
ATOM    935  CB  LEU   117      49.662  59.524   4.650  1.00 43.32           C  
ATOM    936  CG  LEU   117      49.971  58.514   5.768  1.00 42.50           C  
ATOM    937  CD1 LEU   117      49.035  58.460   6.894  1.00 38.84           C  
ATOM    938  CD2 LEU   117      50.079  57.121   5.121  1.00 41.84           C  
ATOM    939  N   ALA   118      50.407  62.680   5.379  1.00 45.49           N  
ATOM    940  CA  ALA   118      51.416  63.721   5.118  1.00 46.60           C  
ATOM    941  C   ALA   118      52.688  63.104   4.473  1.00 47.17           C  
ATOM    942  O   ALA   118      52.980  61.941   4.739  1.00 46.34           O  
ATOM    943  CB  ALA   118      51.750  64.457   6.420  1.00 47.88           C  
ATOM    944  N   PRO   119      53.399  63.850   3.574  1.00 47.51           N  
ATOM    945  CA  PRO   119      54.599  63.389   2.842  1.00 47.59           C  
ATOM    946  C   PRO   119      55.693  62.724   3.689  1.00 47.35           C  
ATOM    947  O   PRO   119      56.294  61.727   3.249  1.00 46.86           O  
ATOM    948  CB  PRO   119      55.169  64.678   2.206  1.00 47.81           C  
ATOM    949  CG  PRO   119      53.996  65.589   2.057  1.00 48.09           C  
ATOM    950  CD  PRO   119      52.975  65.194   3.127  1.00 48.21           C  
ATOM    951  N   ALA   120      55.949  63.290   4.875  1.00 46.56           N  
ATOM    952  CA  ALA   120      57.009  62.781   5.740  1.00 46.24           C  
ATOM    953  C   ALA   120      56.628  61.425   6.315  1.00 44.99           C  
ATOM    954  O   ALA   120      57.461  60.542   6.467  1.00 43.76           O  
ATOM    955  CB  ALA   120      57.310  63.767   6.869  1.00 46.49           C  
ATOM    956  N   ARG   121      55.364  61.273   6.649  1.00 44.79           N  
ATOM    957  CA  ARG   121      54.872  60.019   7.199  1.00 44.89           C  
ATOM    958  C   ARG   121      54.772  58.924   6.150  1.00 43.80           C  
ATOM    959  O   ARG   121      55.066  57.770   6.436  1.00 43.62           O  
ATOM    960  CB  ARG   121      53.491  60.228   7.743  1.00 45.15           C  
ATOM    961  CG  ARG   121      52.984  59.105   8.616  1.00 47.67           C  
ATOM    962  CD  ARG   121      53.018  59.592  10.052  1.00 48.71           C  
ATOM    963  NE  ARG   121      51.957  59.036  10.799  1.00 47.08           N  
ATOM    964  CZ  ARG   121      51.534  59.475  11.983  1.00 45.97           C  
ATOM    965  NH1 ARG   121      50.526  58.854  12.536  1.00 42.19           N  
ATOM    966  NH2 ARG   121      52.105  60.484  12.633  1.00 42.92           N  
ATOM    967  N   ARG   122      54.295  59.281   4.962  1.00 42.61           N  
ATOM    968  CA  ARG   122      54.302  58.366   3.838  1.00 42.30           C  
ATOM    969  C   ARG   122      55.717  57.791   3.628  1.00 42.47           C  
ATOM    970  O   ARG   122      55.894  56.603   3.371  1.00 41.94           O  
ATOM    971  CB  ARG   122      53.861  59.088   2.582  1.00 41.69           C  
ATOM    972  CG  ARG   122      53.694  58.186   1.376  1.00 41.56           C  
ATOM    973  CD  ARG   122      53.218  58.964   0.170  1.00 41.36           C  
ATOM    974  NE  ARG   122      52.043  59.741   0.536  1.00 40.48           N  
ATOM    975  CZ  ARG   122      50.842  59.221   0.739  1.00 43.83           C  
ATOM    976  NH1 ARG   122      50.639  57.914   0.587  1.00 45.33           N  
ATOM    977  NH2 ARG   122      49.835  60.018   1.125  1.00 40.81           N  
ATOM    978  N   LYS   123      56.719  58.642   3.707  1.00 42.91           N  
ATOM    979  CA  LYS   123      58.126  58.207   3.531  1.00 43.36           C  
ATOM    980  C   LYS   123      58.548  57.179   4.554  1.00 42.40           C  
ATOM    981  O   LYS   123      59.149  56.157   4.210  1.00 42.17           O  
ATOM    982  CB  LYS   123      59.087  59.375   3.697  1.00 45.04           C  
ATOM    983  CG  LYS   123      59.344  60.143   2.450  1.00 49.40           C  
ATOM    984  CD  LYS   123      60.707  60.818   2.482  1.00 54.56           C  
ATOM    985  CE  LYS   123      60.650  62.240   1.878  1.00 57.35           C  
ATOM    986  NZ  LYS   123      59.260  62.655   1.400  1.00 57.21           N  
ATOM    987  N   VAL   124      58.269  57.467   5.819  1.00 41.11           N  
ATOM    988  CA  VAL   124      58.646  56.570   6.908  1.00 40.38           C  
ATOM    989  C   VAL   124      58.011  55.204   6.725  1.00 39.67           C  
ATOM    990  O   VAL   124      58.674  54.169   6.875  1.00 38.37           O  
ATOM    991  CB  VAL   124      58.257  57.153   8.287  1.00 40.77           C  
ATOM    992  CG1 VAL   124      58.451  56.116   9.393  1.00 42.42           C  
ATOM    993  CG2 VAL   124      59.092  58.337   8.592  1.00 40.80           C  
ATOM    994  N   LEU   125      56.715  55.188   6.383  1.00 38.13           N  
ATOM    995  CA  LEU   125      56.004  53.955   6.266  1.00 37.40           C  
ATOM    996  C   LEU   125      56.437  53.132   5.049  1.00 36.22           C  
ATOM    997  O   LEU   125      56.467  51.932   5.119  1.00 36.07           O  
ATOM    998  CB  LEU   125      54.501  54.230   6.178  1.00 37.35           C  
ATOM    999  CG  LEU   125      53.866  54.793   7.444  1.00 38.53           C  
ATOM   1000  CD1 LEU   125      52.439  55.234   7.103  1.00 36.55           C  
ATOM   1001  CD2 LEU   125      53.867  53.719   8.560  1.00 36.32           C  
ATOM   1002  N   ILE   126      56.713  53.779   3.931  1.00 36.14           N  
ATOM   1003  CA  ILE   126      57.241  53.080   2.749  1.00 35.99           C  
ATOM   1004  C   ILE   126      58.612  52.438   3.014  1.00 35.57           C  
ATOM   1005  O   ILE   126      58.883  51.300   2.576  1.00 35.09           O  
ATOM   1006  CB  ILE   126      57.222  53.984   1.480  1.00 35.88           C  
ATOM   1007  CG1 ILE   126      55.759  54.345   1.163  1.00 36.66           C  
ATOM   1008  CG2 ILE   126      57.978  53.277   0.261  1.00 35.04           C  
ATOM   1009  CD1 ILE   126      55.552  55.126  -0.092  1.00 37.14           C  
ATOM   1010  N   GLN   127      59.435  53.122   3.788  1.00 35.49           N  
ATOM   1011  CA  GLN   127      60.748  52.618   4.177  1.00 35.94           C  
ATOM   1012  C   GLN   127      60.589  51.363   5.038  1.00 36.10           C  
ATOM   1013  O   GLN   127      61.335  50.365   4.870  1.00 34.83           O  
ATOM   1014  CB  GLN   127      61.554  53.697   4.921  1.00 37.03           C  
ATOM   1015  CG  GLN   127      62.818  53.214   5.609  1.00 37.55           C  
ATOM   1016  CD  GLN   127      63.933  53.025   4.659  1.00 40.37           C  
ATOM   1017  OE1 GLN   127      64.111  53.833   3.752  1.00 42.14           O  
ATOM   1018  NE2 GLN   127      64.746  51.989   4.882  1.00 41.30           N  
ATOM   1019  N   LYS   128      59.604  51.410   5.936  1.00 35.63           N  
ATOM   1020  CA  LYS   128      59.332  50.301   6.848  1.00 34.77           C  
ATOM   1021  C   LYS   128      58.790  49.110   6.089  1.00 34.02           C  
ATOM   1022  O   LYS   128      59.157  47.982   6.371  1.00 33.41           O  
ATOM   1023  CB  LYS   128      58.342  50.717   7.931  1.00 34.60           C  
ATOM   1024  CG  LYS   128      58.969  51.487   9.048  1.00 39.61           C  
ATOM   1025  CD  LYS   128      57.941  52.005  10.052  1.00 41.93           C  
ATOM   1026  CE  LYS   128      58.606  53.085  10.914  1.00 46.04           C  
ATOM   1027  NZ  LYS   128      58.280  52.892  12.368  1.00 46.57           N  
ATOM   1028  N   PHE   129      57.890  49.380   5.153  1.00 32.95           N  
ATOM   1029  CA  PHE   129      57.306  48.360   4.312  1.00 33.01           C  
ATOM   1030  C   PHE   129      58.395  47.649   3.492  1.00 33.38           C  
ATOM   1031  O   PHE   129      58.469  46.406   3.489  1.00 33.16           O  
ATOM   1032  CB  PHE   129      56.273  49.021   3.422  1.00 32.46           C  
ATOM   1033  CG  PHE   129      55.574  48.100   2.489  1.00 31.79           C  
ATOM   1034  CD1 PHE   129      54.278  47.682   2.758  1.00 32.57           C  
ATOM   1035  CD2 PHE   129      56.158  47.685   1.311  1.00 31.11           C  
ATOM   1036  CE1 PHE   129      53.610  46.856   1.869  1.00 30.91           C  
ATOM   1037  CE2 PHE   129      55.499  46.864   0.425  1.00 32.46           C  
ATOM   1038  CZ  PHE   129      54.230  46.422   0.702  1.00 31.79           C  
ATOM   1039  N   ALA   130      59.221  48.448   2.818  1.00 33.33           N  
ATOM   1040  CA  ALA   130      60.407  47.950   2.052  1.00 33.63           C  
ATOM   1041  C   ALA   130      61.277  47.025   2.897  1.00 32.83           C  
ATOM   1042  O   ALA   130      61.613  45.899   2.523  1.00 31.42           O  
ATOM   1043  CB  ALA   130      61.250  49.124   1.558  1.00 32.72           C  
ATOM   1044  N   THR   131      61.591  47.500   4.073  1.00 32.85           N  
ATOM   1045  CA  THR   131      62.413  46.753   4.979  1.00 33.64           C  
ATOM   1046  C   THR   131      61.783  45.448   5.399  1.00 32.48           C  
ATOM   1047  O   THR   131      62.454  44.430   5.442  1.00 31.61           O  
ATOM   1048  CB  THR   131      62.747  47.599   6.186  1.00 34.24           C  
ATOM   1049  OG1 THR   131      63.439  48.756   5.711  1.00 34.28           O  
ATOM   1050  CG2 THR   131      63.637  46.820   7.134  1.00 36.35           C  
ATOM   1051  N   HIS   132      60.485  45.489   5.691  1.00 33.22           N  
ATOM   1052  CA  HIS   132      59.739  44.311   6.126  1.00 32.97           C  
ATOM   1053  C   HIS   132      59.736  43.274   5.015  1.00 32.06           C  
ATOM   1054  O   HIS   132      60.071  42.089   5.202  1.00 30.93           O  
ATOM   1055  CB  HIS   132      58.309  44.767   6.490  1.00 33.23           C  
ATOM   1056  CG  HIS   132      57.380  43.673   6.899  1.00 33.85           C  
ATOM   1057  ND1 HIS   132      56.700  43.700   8.101  1.00 33.95           N  
ATOM   1058  CD2 HIS   132      56.937  42.569   6.243  1.00 33.16           C  
ATOM   1059  CE1 HIS   132      55.908  42.643   8.179  1.00 32.64           C  
ATOM   1060  NE2 HIS   132      56.031  41.942   7.065  1.00 30.46           N  
ATOM   1061  N   ALA   133      59.328  43.727   3.837  1.00 31.75           N  
ATOM   1062  CA  ALA   133      59.244  42.852   2.693  1.00 30.24           C  
ATOM   1063  C   ALA   133      60.567  42.187   2.369  1.00 29.49           C  
ATOM   1064  O   ALA   133      60.622  40.971   2.107  1.00 30.73           O  
ATOM   1065  CB  ALA   133      58.757  43.650   1.511  1.00 29.31           C  
ATOM   1066  N   ALA   134      61.631  42.982   2.316  1.00 28.49           N  
ATOM   1067  CA  ALA   134      62.926  42.475   1.881  1.00 27.28           C  
ATOM   1068  C   ALA   134      63.539  41.515   2.914  1.00 28.08           C  
ATOM   1069  O   ALA   134      64.128  40.517   2.524  1.00 26.06           O  
ATOM   1070  CB  ALA   134      63.887  43.601   1.497  1.00 28.12           C  
ATOM   1071  N   ARG   135      63.335  41.771   4.208  1.00 29.15           N  
ATOM   1072  CA  ARG   135      63.798  40.846   5.246  1.00 29.60           C  
ATOM   1073  C   ARG   135      63.136  39.496   5.099  1.00 30.00           C  
ATOM   1074  O   ARG   135      63.804  38.471   5.096  1.00 30.62           O  
ATOM   1075  CB  ARG   135      63.525  41.364   6.672  1.00 29.23           C  
ATOM   1076  CG  ARG   135      64.605  42.218   7.201  1.00 34.62           C  
ATOM   1077  CD  ARG   135      64.358  42.618   8.697  1.00 38.89           C  
ATOM   1078  NE  ARG   135      65.422  43.550   9.090  1.00 47.15           N  
ATOM   1079  CZ  ARG   135      65.246  44.733   9.701  1.00 50.14           C  
ATOM   1080  NH1 ARG   135      64.028  45.160  10.070  1.00 50.63           N  
ATOM   1081  NH2 ARG   135      66.312  45.488   9.974  1.00 49.80           N  
ATOM   1082  N   ARG   136      61.790  39.495   5.037  1.00 30.67           N  
ATOM   1083  CA  ARG   136      61.048  38.243   4.931  1.00 30.83           C  
ATOM   1084  C   ARG   136      61.417  37.475   3.691  1.00 29.56           C  
ATOM   1085  O   ARG   136      61.473  36.261   3.712  1.00 29.65           O  
ATOM   1086  CB  ARG   136      59.524  38.505   4.909  1.00 31.76           C  
ATOM   1087  CG  ARG   136      59.014  39.294   6.065  1.00 36.83           C  
ATOM   1088  CD  ARG   136      59.004  38.556   7.316  1.00 42.45           C  
ATOM   1089  NE  ARG   136      58.221  39.289   8.324  1.00 48.18           N  
ATOM   1090  CZ  ARG   136      58.682  40.286   9.099  1.00 51.11           C  
ATOM   1091  NH1 ARG   136      59.940  40.731   8.999  1.00 52.60           N  
ATOM   1092  NH2 ARG   136      57.870  40.847   9.986  1.00 52.86           N  
ATOM   1093  N   LEU   137      61.579  38.178   2.582  1.00 29.38           N  
ATOM   1094  CA  LEU   137      61.999  37.561   1.329  1.00 28.94           C  
ATOM   1095  C   LEU   137      63.352  36.874   1.462  1.00 29.34           C  
ATOM   1096  O   LEU   137      63.513  35.689   1.113  1.00 30.12           O  
ATOM   1097  CB  LEU   137      62.057  38.612   0.245  1.00 28.19           C  
ATOM   1098  CG  LEU   137      62.578  38.237  -1.144  1.00 28.63           C  
ATOM   1099  CD1 LEU   137      61.872  37.025  -1.693  1.00 28.56           C  
ATOM   1100  CD2 LEU   137      62.419  39.454  -2.036  1.00 27.13           C  
ATOM   1101  N   GLN   138      64.330  37.599   2.009  1.00 28.89           N  
ATOM   1102  CA  GLN   138      65.664  37.027   2.177  1.00 27.63           C  
ATOM   1103  C   GLN   138      65.642  35.771   3.076  1.00 28.06           C  
ATOM   1104  O   GLN   138      66.330  34.810   2.799  1.00 28.10           O  
ATOM   1105  CB  GLN   138      66.680  38.080   2.654  1.00 27.43           C  
ATOM   1106  CG  GLN   138      68.167  37.618   2.581  1.00 25.72           C  
ATOM   1107  CD  GLN   138      68.624  36.982   3.883  1.00 28.91           C  
ATOM   1108  OE1 GLN   138      67.839  36.922   4.854  1.00 30.24           O  
ATOM   1109  NE2 GLN   138      69.870  36.485   3.921  1.00 24.05           N  
ATOM   1110  N   ALA   139      64.847  35.800   4.132  1.00 29.36           N  
ATOM   1111  CA  ALA   139      64.735  34.690   5.035  1.00 30.23           C  
ATOM   1112  C   ALA   139      64.095  33.433   4.382  1.00 32.15           C  
ATOM   1113  O   ALA   139      64.429  32.303   4.759  1.00 33.40           O  
ATOM   1114  CB  ALA   139      63.982  35.118   6.266  1.00 29.95           C  
ATOM   1115  N   LEU   140      63.170  33.615   3.445  1.00 32.96           N  
ATOM   1116  CA  LEU   140      62.568  32.490   2.722  1.00 34.03           C  
ATOM   1117  C   LEU   140      63.532  31.926   1.724  1.00 35.42           C  
ATOM   1118  O   LEU   140      63.681  30.714   1.620  1.00 35.86           O  
ATOM   1119  CB  LEU   140      61.274  32.916   2.012  1.00 33.87           C  
ATOM   1120  CG  LEU   140      60.018  32.982   2.847  1.00 35.13           C  
ATOM   1121  CD1 LEU   140      58.791  33.326   1.930  1.00 32.30           C  
ATOM   1122  CD2 LEU   140      59.794  31.673   3.641  1.00 35.34           C  
ATOM   1123  N   ARG   141      64.276  32.801   1.047  1.00 36.64           N  
ATOM   1124  CA  ARG   141      65.287  32.352   0.075  1.00 37.91           C  
ATOM   1125  C   ARG   141      66.548  31.761   0.649  1.00 37.87           C  
ATOM   1126  O   ARG   141      67.213  30.962  -0.007  1.00 37.13           O  
ATOM   1127  CB  ARG   141      65.639  33.496  -0.864  1.00 38.46           C  
ATOM   1128  CG  ARG   141      64.421  34.078  -1.487  1.00 41.46           C  
ATOM   1129  CD  ARG   141      64.562  34.460  -2.929  1.00 47.70           C  
ATOM   1130  NE  ARG   141      65.693  35.313  -3.174  1.00 52.73           N  
ATOM   1131  CZ  ARG   141      66.759  34.994  -3.922  1.00 57.69           C  
ATOM   1132  NH1 ARG   141      67.731  35.873  -4.045  1.00 57.08           N  
ATOM   1133  NH2 ARG   141      66.877  33.820  -4.558  1.00 60.85           N  
ATOM   1134  N   ASP   142      66.873  32.133   1.894  1.00 36.79           N  
ATOM   1135  CA  ASP   142      68.116  31.738   2.528  1.00 35.37           C  
ATOM   1136  C   ASP   142      67.823  31.607   4.025  1.00 35.29           C  
ATOM   1137  O   ASP   142      68.215  32.455   4.788  1.00 33.42           O  
ATOM   1138  CB  ASP   142      69.171  32.819   2.244  1.00 35.26           C  
ATOM   1139  CG  ASP   142      70.549  32.503   2.793  1.00 34.73           C  
ATOM   1140  OD1 ASP   142      70.806  31.384   3.324  1.00 36.25           O  
ATOM   1141  OD2 ASP   142      71.403  33.419   2.715  1.00 29.26           O  
ATOM   1142  N   PRO   143      67.130  30.523   4.427  1.00 36.28           N  
ATOM   1143  CA  PRO   143      66.664  30.323   5.800  1.00 35.81           C  
ATOM   1144  C   PRO   143      67.740  30.476   6.879  1.00 35.40           C  
ATOM   1145  O   PRO   143      67.446  31.016   7.961  1.00 34.44           O  
ATOM   1146  CB  PRO   143      66.105  28.904   5.789  1.00 36.12           C  
ATOM   1147  CG  PRO   143      65.852  28.569   4.361  1.00 37.43           C  
ATOM   1148  CD  PRO   143      66.667  29.454   3.512  1.00 37.57           C  
END
