
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   75 ( 1197),  selected   75 , name 2h3j_A
# Molecule2: number of CA atoms   70 ( 1132),  selected   70 , name T0492.pdb
# PARAMETERS: 2h3j_A.T0492.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      F       2           -
LGA    S     2_A      S       3           -
LGA    A     3_A      L       4           -
LGA    L     4_A      R       5           -
LGA    Q     5_A      D       6           -
LGA    -       -      A       7           -
LGA    -       -      K       8           -
LGA    P     6_A      C       9          6.773
LGA    S     7_A      G      10          2.327
LGA    R     8_A      Q      11          1.130
LGA    S     9_A      T      12          0.671
LGA    Y    10_A      V      13          1.048
LGA    R    11_A      K      14          0.882
LGA    I    12_A      V      15          0.726
LGA    T    13_A      V      16          1.031
LGA    G    14_A      K      17          1.367
LGA    Y    15_A      L      18          0.871
LGA    S    16_A      H      19          2.319
LGA    P    17_A      -       -           -
LGA    A    18_A      -       -           -
LGA    I    19_A      G      20          0.705
LGA    S    20_A      T      21          0.858
LGA    N    21_A      G      22          4.856
LGA    G    22_A      A      23          2.408
LGA    Y    23_A      L      24          1.976
LGA    R    24_A      K      25          1.982
LGA    Q    25_A      R      26          1.883
LGA    R    26_A      R      27          1.879
LGA    L    27_A      I      28          1.938
LGA    F    28_A      M      29          2.219
LGA    S    29_A      D      30          1.813
LGA    M    30_A      M      31          1.806
LGA    G    31_A      G      32          1.898
LGA    L    32_A      I      33          2.061
LGA    L    33_A      T      34          1.575
LGA    P    34_A      R      35          0.617
LGA    G    35_A      G      36          0.120
LGA    A    36_A      C      37          0.784
LGA    A    37_A      E      38          1.460
LGA    L    38_A      I      39          1.161
LGA    R    39_A      Y      40          0.728
LGA    V    40_A      I      41          1.641
LGA    V    41_A      R      42          1.297
LGA    R    42_A      K      43          1.185
LGA    I    43_A      V      44          0.767
LGA    A    44_A      A      45          0.892
LGA    P    45_A      -       -           -
LGA    L    46_A      -       -           -
LGA    G    47_A      G      48          2.541
LGA    D    48_A      D      49          1.300
LGA    P    49_A      P      50          0.815
LGA    I    50_A      I      51          0.790
LGA    Q    51_A      Q      52          0.855
LGA    V    52_A      I      53          1.553
LGA    E    53_A      N      54          1.707
LGA    T    54_A      V      55          2.468
LGA    R    55_A      R      56          4.869
LGA    Q    56_A      G      57          3.157
LGA    T    57_A      Y      58          2.688
LGA    S    58_A      E      59          0.816
LGA    L    59_A      L      60          1.996
LGA    A    60_A      S      61          1.180
LGA    L    61_A      L      62          0.702
LGA    R    62_A      R      63          1.067
LGA    R    63_A      K      64          1.150
LGA    K    64_A      S      65          0.676
LGA    D    65_A      A      66          1.216
LGA    L    66_A      A      67          1.414
LGA    A    67_A      E      68          2.751
LGA    L    68_A      M      69          3.059
LGA    L    69_A      I      70          1.252
LGA    T    70_A      E      71          0.394
LGA    L    71_A      V      72          1.155
LGA    V    72_A      E      73          0.650
LGA    P    73_A      -       -           -
LGA    L    74_A      -       -           -
LGA    D    75_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   75   70    5.0     63    1.97    22.22     81.071     3.049

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.552356 * X  +   0.833553 * Y  +  -0.009571 * Z  +   2.668506
  Y_new =  -0.541286 * X  +  -0.349906 * Y  +   0.764575 * Z  +   1.079370
  Z_new =   0.633965 * X  +   0.427499 * Y  +   0.644464 * Z  +   0.134244 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.585696   -2.555897  [ DEG:    33.5579   -146.4421 ]
  Theta =  -0.686669   -2.454923  [ DEG:   -39.3433   -140.6567 ]
  Phi   =  -2.366316    0.775276  [ DEG:  -135.5799     44.4201 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2h3j_A                                        
REMARK     2: T0492.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2h3j_A.T0492.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   75   70   5.0   63   1.97   22.22  81.071
REMARK  ---------------------------------------------------------- 
MOLECULE 2h3j_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   22-MAY-06   2H3J              
TITLE     SOLUTION NMR STRUCTURE OF PROTEIN PA4359 FROM PSEUDOMONAS             
TITLE    2 AERUGINOSA: NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
TITLE    3 TARGET PAT89                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA4359;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 GENE: PA4359;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    NESG, GFT NMR, STRUCTURAL GENOMICS, PAT89, STRUCTURAL                 
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST             
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM                                       
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    Q.ZHANG,G.LIU,A.YEE,C.ARROWSMITH,T.SZYPERSKI,NORTHEAST                
AUTHOR   2 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   20-JUN-06 2H3J    0                                                
JRNL        AUTH   Q.ZHANG,G.LIU,A.YEE,C.ARROWSMITH,T.SZYPERSKI                 
JRNL        TITL   SOLUTION STRUCTURE OF HYPOTHETICAL PROTEIN PA4359:           
JRNL        TITL 2 NORTHEST STRUCTURAL GENOMICS TARGET PAT89                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2H3J A    1    75  UNP    Q9HW42   Q9HW42_PSEAE     1     75             
SEQRES   1 A   75  MET SER ALA LEU GLN PRO SER ARG SER TYR ARG ILE THR          
SEQRES   2 A   75  GLY TYR SER PRO ALA ILE SER ASN GLY TYR ARG GLN ARG          
SEQRES   3 A   75  LEU PHE SER MET GLY LEU LEU PRO GLY ALA ALA LEU ARG          
SEQRES   4 A   75  VAL VAL ARG ILE ALA PRO LEU GLY ASP PRO ILE GLN VAL          
SEQRES   5 A   75  GLU THR ARG GLN THR SER LEU ALA LEU ARG ARG LYS ASP          
SEQRES   6 A   75  LEU ALA LEU LEU THR LEU VAL PRO LEU ASP                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -4.505 -13.978 -14.048  1.00  0.00           N  
ATOM      2  CA  MET A   1      -5.328 -13.670 -12.860  1.00  0.00           C  
ATOM      3  C   MET A   1      -5.714 -12.198 -12.846  1.00  0.00           C  
ATOM      4  O   MET A   1      -4.911 -11.339 -13.203  1.00  0.00           O  
ATOM      5  CB  MET A   1      -4.572 -14.018 -11.572  1.00  0.00           C  
ATOM      6  CG  MET A   1      -3.287 -13.225 -11.370  1.00  0.00           C  
ATOM      7  SD  MET A   1      -2.498 -13.557  -9.776  1.00  0.00           S  
ATOM      8  CE  MET A   1      -3.776 -13.029  -8.642  1.00  0.00           C  
ATOM      9  HA  MET A   1      -6.229 -14.265 -12.910  1.00  0.00           H  
ATOM     10  HB2 MET A   1      -5.221 -13.826 -10.730  1.00  0.00           H  
ATOM     11  HB3 MET A   1      -4.322 -15.068 -11.588  1.00  0.00           H  
ATOM     12  HG2 MET A   1      -2.595 -13.480 -12.162  1.00  0.00           H  
ATOM     13  HG3 MET A   1      -3.520 -12.172 -11.430  1.00  0.00           H  
ATOM     14  HE1 MET A   1      -3.450 -13.209  -7.628  1.00  0.00           H  
ATOM     15  HE2 MET A   1      -4.682 -13.583  -8.834  1.00  0.00           H  
ATOM     16  HE3 MET A   1      -3.965 -11.974  -8.776  1.00  0.00           H  
ATOM     17  N   SER A   2      -6.935 -11.910 -12.437  1.00  0.00           N  
ATOM     18  CA  SER A   2      -7.384 -10.541 -12.282  1.00  0.00           C  
ATOM     19  C   SER A   2      -7.701 -10.294 -10.812  1.00  0.00           C  
ATOM     20  O   SER A   2      -8.856 -10.390 -10.393  1.00  0.00           O  
ATOM     21  CB  SER A   2      -8.611 -10.288 -13.157  1.00  0.00           C  
ATOM     22  OG  SER A   2      -8.412 -10.806 -14.465  1.00  0.00           O  
ATOM     23  H   SER A   2      -7.561 -12.646 -12.223  1.00  0.00           H  
ATOM     24  HA  SER A   2      -6.582  -9.885 -12.587  1.00  0.00           H  
ATOM     25  HB2 SER A   2      -9.473 -10.769 -12.718  1.00  0.00           H  
ATOM     26  HB3 SER A   2      -8.789  -9.225 -13.228  1.00  0.00           H  
ATOM     27  HG  SER A   2      -8.283 -10.077 -15.086  1.00  0.00           H  
ATOM     28  N   ALA A   3      -6.650 -10.026 -10.033  1.00  0.00           N  
ATOM     29  CA  ALA A   3      -6.743  -9.953  -8.572  1.00  0.00           C  
ATOM     30  C   ALA A   3      -7.100 -11.324  -7.995  1.00  0.00           C  
ATOM     31  O   ALA A   3      -7.304 -12.287  -8.737  1.00  0.00           O  
ATOM     32  CB  ALA A   3      -7.751  -8.895  -8.127  1.00  0.00           C  
ATOM     33  H   ALA A   3      -5.780  -9.874 -10.456  1.00  0.00           H  
ATOM     34  HA  ALA A   3      -5.770  -9.668  -8.196  1.00  0.00           H  
ATOM     35  HB1 ALA A   3      -8.744  -9.196  -8.428  1.00  0.00           H  
ATOM     36  HB2 ALA A   3      -7.507  -7.948  -8.588  1.00  0.00           H  
ATOM     37  HB3 ALA A   3      -7.715  -8.791  -7.053  1.00  0.00           H  
ATOM     38  N   LEU A   4      -7.156 -11.425  -6.678  1.00  0.00           N  
ATOM     39  CA  LEU A   4      -7.490 -12.685  -6.036  1.00  0.00           C  
ATOM     40  C   LEU A   4      -8.276 -12.441  -4.758  1.00  0.00           C  
ATOM     41  O   LEU A   4      -7.699 -12.118  -3.721  1.00  0.00           O  
ATOM     42  CB  LEU A   4      -6.223 -13.484  -5.733  1.00  0.00           C  
ATOM     43  CG  LEU A   4      -6.451 -14.848  -5.079  1.00  0.00           C  
ATOM     44  CD1 LEU A   4      -7.234 -15.764  -6.007  1.00  0.00           C  
ATOM     45  CD2 LEU A   4      -5.124 -15.485  -4.696  1.00  0.00           C  
ATOM     46  H   LEU A   4      -6.972 -10.640  -6.124  1.00  0.00           H  
ATOM     47  HA  LEU A   4      -8.107 -13.250  -6.718  1.00  0.00           H  
ATOM     48  HB2 LEU A   4      -5.692 -13.638  -6.662  1.00  0.00           H  
ATOM     49  HB3 LEU A   4      -5.603 -12.896  -5.075  1.00  0.00           H  
ATOM     50  HG  LEU A   4      -7.030 -14.714  -4.177  1.00  0.00           H  
ATOM     51 HD11 LEU A   4      -7.402 -16.712  -5.522  1.00  0.00           H  
ATOM     52 HD12 LEU A   4      -6.671 -15.918  -6.916  1.00  0.00           H  
ATOM     53 HD13 LEU A   4      -8.184 -15.307  -6.246  1.00  0.00           H  
ATOM     54 HD21 LEU A   4      -4.525 -15.626  -5.584  1.00  0.00           H  
ATOM     55 HD22 LEU A   4      -5.303 -16.441  -4.227  1.00  0.00           H  
ATOM     56 HD23 LEU A   4      -4.598 -14.839  -4.008  1.00  0.00           H  
ATOM     57  N   GLN A   5      -9.596 -12.580  -4.864  1.00  0.00           N  
ATOM     58  CA  GLN A   5     -10.500 -12.416  -3.728  1.00  0.00           C  
ATOM     59  C   GLN A   5     -10.275 -11.073  -3.028  1.00  0.00           C  
ATOM     60  O   GLN A   5      -9.735 -11.021  -1.921  1.00  0.00           O  
ATOM     61  CB  GLN A   5     -10.334 -13.574  -2.736  1.00  0.00           C  
ATOM     62  CG  GLN A   5     -10.701 -14.932  -3.317  1.00  0.00           C  
ATOM     63  CD  GLN A   5     -10.351 -16.080  -2.390  1.00  0.00           C  
ATOM     64  OE1 GLN A   5     -10.345 -15.935  -1.167  1.00  0.00           O  
ATOM     65  NE2 GLN A   5     -10.074 -17.239  -2.966  1.00  0.00           N  
ATOM     66  H   GLN A   5      -9.976 -12.793  -5.744  1.00  0.00           H  
ATOM     67  HA  GLN A   5     -11.511 -12.436  -4.113  1.00  0.00           H  
ATOM     68  HB2 GLN A   5      -9.306 -13.611  -2.412  1.00  0.00           H  
ATOM     69  HB3 GLN A   5     -10.967 -13.394  -1.878  1.00  0.00           H  
ATOM     70  HG2 GLN A   5     -11.764 -14.957  -3.506  1.00  0.00           H  
ATOM     71  HG3 GLN A   5     -10.168 -15.066  -4.248  1.00  0.00           H  
ATOM     72 HE21 GLN A   5     -10.114 -17.294  -3.951  1.00  0.00           H  
ATOM     73 HE22 GLN A   5      -9.838 -17.998  -2.388  1.00  0.00           H  
ATOM     74  N   PRO A   6     -10.688  -9.966  -3.660  1.00  0.00           N  
ATOM     75  CA  PRO A   6     -10.486  -8.631  -3.109  1.00  0.00           C  
ATOM     76  C   PRO A   6     -11.450  -8.330  -1.966  1.00  0.00           C  
ATOM     77  O   PRO A   6     -12.666  -8.301  -2.152  1.00  0.00           O  
ATOM     78  CB  PRO A   6     -10.761  -7.689  -4.291  1.00  0.00           C  
ATOM     79  CG  PRO A   6     -11.008  -8.566  -5.478  1.00  0.00           C  
ATOM     80  CD  PRO A   6     -11.389  -9.918  -4.946  1.00  0.00           C  
ATOM     81  HA  PRO A   6      -9.470  -8.497  -2.765  1.00  0.00           H  
ATOM     82  HB2 PRO A   6     -11.624  -7.084  -4.064  1.00  0.00           H  
ATOM     83  HB3 PRO A   6      -9.904  -7.051  -4.447  1.00  0.00           H  
ATOM     84  HG2 PRO A   6     -11.815  -8.160  -6.070  1.00  0.00           H  
ATOM     85  HG3 PRO A   6     -10.109  -8.638  -6.072  1.00  0.00           H  
ATOM     86  HD2 PRO A   6     -12.458  -9.986  -4.807  1.00  0.00           H  
ATOM     87  HD3 PRO A   6     -11.039 -10.699  -5.604  1.00  0.00           H  
ATOM     88  N   SER A   7     -10.899  -8.113  -0.787  1.00  0.00           N  
ATOM     89  CA  SER A   7     -11.700  -7.797   0.385  1.00  0.00           C  
ATOM     90  C   SER A   7     -11.796  -6.284   0.554  1.00  0.00           C  
ATOM     91  O   SER A   7     -12.878  -5.732   0.734  1.00  0.00           O  
ATOM     92  CB  SER A   7     -11.083  -8.447   1.630  1.00  0.00           C  
ATOM     93  OG  SER A   7     -11.870  -8.214   2.785  1.00  0.00           O  
ATOM     94  H   SER A   7      -9.926  -8.170  -0.701  1.00  0.00           H  
ATOM     95  HA  SER A   7     -12.693  -8.198   0.233  1.00  0.00           H  
ATOM     96  HB2 SER A   7     -11.007  -9.512   1.472  1.00  0.00           H  
ATOM     97  HB3 SER A   7     -10.098  -8.036   1.795  1.00  0.00           H  
ATOM     98  HG  SER A   7     -12.697  -7.775   2.533  1.00  0.00           H  
ATOM     99  N   ARG A   8     -10.654  -5.622   0.485  1.00  0.00           N  
ATOM    100  CA  ARG A   8     -10.582  -4.178   0.630  1.00  0.00           C  
ATOM    101  C   ARG A   8      -9.487  -3.610  -0.255  1.00  0.00           C  
ATOM    102  O   ARG A   8      -8.574  -4.326  -0.671  1.00  0.00           O  
ATOM    103  CB  ARG A   8     -10.293  -3.800   2.084  1.00  0.00           C  
ATOM    104  CG  ARG A   8     -11.519  -3.748   2.979  1.00  0.00           C  
ATOM    105  CD  ARG A   8     -11.122  -3.570   4.435  1.00  0.00           C  
ATOM    106  NE  ARG A   8     -12.257  -3.232   5.289  1.00  0.00           N  
ATOM    107  CZ  ARG A   8     -12.433  -3.721   6.514  1.00  0.00           C  
ATOM    108  NH1 ARG A   8     -11.636  -4.680   6.971  1.00  0.00           N  
ATOM    109  NH2 ARG A   8     -13.417  -3.270   7.278  1.00  0.00           N  
ATOM    110  H   ARG A   8      -9.825  -6.118   0.329  1.00  0.00           H  
ATOM    111  HA  ARG A   8     -11.530  -3.761   0.335  1.00  0.00           H  
ATOM    112  HB2 ARG A   8      -9.609  -4.525   2.498  1.00  0.00           H  
ATOM    113  HB3 ARG A   8      -9.822  -2.828   2.101  1.00  0.00           H  
ATOM    114  HG2 ARG A   8     -12.140  -2.918   2.678  1.00  0.00           H  
ATOM    115  HG3 ARG A   8     -12.071  -4.670   2.873  1.00  0.00           H  
ATOM    116  HD2 ARG A   8     -10.685  -4.492   4.787  1.00  0.00           H  
ATOM    117  HD3 ARG A   8     -10.389  -2.779   4.496  1.00  0.00           H  
ATOM    118  HE  ARG A   8     -12.904  -2.568   4.941  1.00  0.00           H  
ATOM    119 HH11 ARG A   8     -10.901  -5.042   6.397  1.00  0.00           H  
ATOM    120 HH12 ARG A   8     -11.772  -5.047   7.897  1.00  0.00           H  
ATOM    121 HH21 ARG A   8     -14.038  -2.555   6.936  1.00  0.00           H  
ATOM    122 HH22 ARG A   8     -13.537  -3.633   8.207  1.00  0.00           H  
ATOM    123  N   SER A   9      -9.583  -2.328  -0.537  1.00  0.00           N  
ATOM    124  CA  SER A   9      -8.541  -1.629  -1.263  1.00  0.00           C  
ATOM    125  C   SER A   9      -8.004  -0.483  -0.414  1.00  0.00           C  
ATOM    126  O   SER A   9      -8.770   0.269   0.196  1.00  0.00           O  
ATOM    127  CB  SER A   9      -9.066  -1.119  -2.605  1.00  0.00           C  
ATOM    128  OG  SER A   9      -9.475  -2.196  -3.431  1.00  0.00           O  
ATOM    129  H   SER A   9     -10.379  -1.835  -0.252  1.00  0.00           H  
ATOM    130  HA  SER A   9      -7.738  -2.329  -1.442  1.00  0.00           H  
ATOM    131  HB2 SER A   9      -9.913  -0.468  -2.434  1.00  0.00           H  
ATOM    132  HB3 SER A   9      -8.283  -0.571  -3.112  1.00  0.00           H  
ATOM    133  HG  SER A   9     -10.428  -2.136  -3.595  1.00  0.00           H  
ATOM    134  N   TYR A  10      -6.690  -0.372  -0.357  1.00  0.00           N  
ATOM    135  CA  TYR A  10      -6.040   0.641   0.455  1.00  0.00           C  
ATOM    136  C   TYR A  10      -5.308   1.628  -0.444  1.00  0.00           C  
ATOM    137  O   TYR A  10      -4.543   1.222  -1.318  1.00  0.00           O  
ATOM    138  CB  TYR A  10      -5.036  -0.005   1.420  1.00  0.00           C  
ATOM    139  CG  TYR A  10      -5.632  -1.032   2.365  1.00  0.00           C  
ATOM    140  CD1 TYR A  10      -5.907  -2.330   1.942  1.00  0.00           C  
ATOM    141  CD2 TYR A  10      -5.913  -0.704   3.685  1.00  0.00           C  
ATOM    142  CE1 TYR A  10      -6.439  -3.266   2.808  1.00  0.00           C  
ATOM    143  CE2 TYR A  10      -6.448  -1.635   4.556  1.00  0.00           C  
ATOM    144  CZ  TYR A  10      -6.709  -2.915   4.113  1.00  0.00           C  
ATOM    145  OH  TYR A  10      -7.233  -3.848   4.979  1.00  0.00           O  
ATOM    146  H   TYR A  10      -6.135  -0.985  -0.896  1.00  0.00           H  
ATOM    147  HA  TYR A  10      -6.804   1.163   1.019  1.00  0.00           H  
ATOM    148  HB2 TYR A  10      -4.269  -0.499   0.847  1.00  0.00           H  
ATOM    149  HB3 TYR A  10      -4.581   0.769   2.022  1.00  0.00           H  
ATOM    150  HD1 TYR A  10      -5.694  -2.603   0.920  1.00  0.00           H  
ATOM    151  HD2 TYR A  10      -5.710   0.300   4.031  1.00  0.00           H  
ATOM    152  HE1 TYR A  10      -6.645  -4.268   2.461  1.00  0.00           H  
ATOM    153  HE2 TYR A  10      -6.659  -1.357   5.579  1.00  0.00           H  
ATOM    154  HH  TYR A  10      -7.863  -3.418   5.579  1.00  0.00           H  
ATOM    155  N   ARG A  11      -5.544   2.912  -0.243  1.00  0.00           N  
ATOM    156  CA  ARG A  11      -4.874   3.934  -1.034  1.00  0.00           C  
ATOM    157  C   ARG A  11      -3.601   4.398  -0.345  1.00  0.00           C  
ATOM    158  O   ARG A  11      -3.453   4.264   0.867  1.00  0.00           O  
ATOM    159  CB  ARG A  11      -5.773   5.149  -1.247  1.00  0.00           C  
ATOM    160  CG  ARG A  11      -7.052   4.860  -2.006  1.00  0.00           C  
ATOM    161  CD  ARG A  11      -7.818   6.144  -2.262  1.00  0.00           C  
ATOM    162  NE  ARG A  11      -9.115   5.903  -2.884  1.00  0.00           N  
ATOM    163  CZ  ARG A  11     -10.176   6.676  -2.682  1.00  0.00           C  
ATOM    164  NH1 ARG A  11     -10.084   7.747  -1.901  1.00  0.00           N  
ATOM    165  NH2 ARG A  11     -11.329   6.387  -3.266  1.00  0.00           N  
ATOM    166  H   ARG A  11      -6.171   3.185   0.466  1.00  0.00           H  
ATOM    167  HA  ARG A  11      -4.622   3.506  -1.992  1.00  0.00           H  
ATOM    168  HB2 ARG A  11      -6.039   5.555  -0.284  1.00  0.00           H  
ATOM    169  HB3 ARG A  11      -5.215   5.896  -1.796  1.00  0.00           H  
ATOM    170  HG2 ARG A  11      -6.808   4.400  -2.953  1.00  0.00           H  
ATOM    171  HG3 ARG A  11      -7.668   4.192  -1.423  1.00  0.00           H  
ATOM    172  HD2 ARG A  11      -7.971   6.652  -1.321  1.00  0.00           H  
ATOM    173  HD3 ARG A  11      -7.230   6.771  -2.915  1.00  0.00           H  
ATOM    174  HE  ARG A  11      -9.197   5.121  -3.482  1.00  0.00           H  
ATOM    175 HH11 ARG A  11      -9.213   7.979  -1.461  1.00  0.00           H  
ATOM    176 HH12 ARG A  11     -10.894   8.329  -1.743  1.00  0.00           H  
ATOM    177 HH21 ARG A  11     -11.406   5.580  -3.863  1.00  0.00           H  
ATOM    178 HH22 ARG A  11     -12.133   6.971  -3.119  1.00  0.00           H  
ATOM    179  N   ILE A  12      -2.693   4.955  -1.121  1.00  0.00           N  
ATOM    180  CA  ILE A  12      -1.494   5.556  -0.574  1.00  0.00           C  
ATOM    181  C   ILE A  12      -1.724   7.051  -0.414  1.00  0.00           C  
ATOM    182  O   ILE A  12      -1.730   7.790  -1.397  1.00  0.00           O  
ATOM    183  CB  ILE A  12      -0.272   5.316  -1.486  1.00  0.00           C  
ATOM    184  CG1 ILE A  12      -0.125   3.823  -1.802  1.00  0.00           C  
ATOM    185  CG2 ILE A  12       0.992   5.847  -0.825  1.00  0.00           C  
ATOM    186  CD1 ILE A  12       1.007   3.506  -2.759  1.00  0.00           C  
ATOM    187  H   ILE A  12      -2.841   4.972  -2.096  1.00  0.00           H  
ATOM    188  HA  ILE A  12      -1.304   5.118   0.399  1.00  0.00           H  
ATOM    189  HB  ILE A  12      -0.425   5.859  -2.406  1.00  0.00           H  
ATOM    190 HG12 ILE A  12       0.061   3.287  -0.884  1.00  0.00           H  
ATOM    191 HG13 ILE A  12      -1.042   3.466  -2.243  1.00  0.00           H  
ATOM    192 HG21 ILE A  12       1.833   5.693  -1.485  1.00  0.00           H  
ATOM    193 HG22 ILE A  12       1.159   5.319   0.101  1.00  0.00           H  
ATOM    194 HG23 ILE A  12       0.878   6.902  -0.624  1.00  0.00           H  
ATOM    195 HD11 ILE A  12       1.038   2.443  -2.941  1.00  0.00           H  
ATOM    196 HD12 ILE A  12       1.944   3.825  -2.325  1.00  0.00           H  
ATOM    197 HD13 ILE A  12       0.847   4.027  -3.691  1.00  0.00           H  
ATOM    198  N   THR A  13      -1.930   7.492   0.816  1.00  0.00           N  
ATOM    199  CA  THR A  13      -2.252   8.886   1.067  1.00  0.00           C  
ATOM    200  C   THR A  13      -0.982   9.731   1.087  1.00  0.00           C  
ATOM    201  O   THR A  13      -1.034  10.958   1.009  1.00  0.00           O  
ATOM    202  CB  THR A  13      -3.035   9.062   2.392  1.00  0.00           C  
ATOM    203  OG1 THR A  13      -3.747  10.308   2.383  1.00  0.00           O  
ATOM    204  CG2 THR A  13      -2.107   9.011   3.602  1.00  0.00           C  
ATOM    205  H   THR A  13      -1.858   6.869   1.573  1.00  0.00           H  
ATOM    206  HA  THR A  13      -2.883   9.226   0.258  1.00  0.00           H  
ATOM    207  HB  THR A  13      -3.749   8.254   2.476  1.00  0.00           H  
ATOM    208  HG1 THR A  13      -3.566  10.793   3.207  1.00  0.00           H  
ATOM    209 HG21 THR A  13      -1.355   9.780   3.512  1.00  0.00           H  
ATOM    210 HG22 THR A  13      -1.628   8.042   3.651  1.00  0.00           H  
ATOM    211 HG23 THR A  13      -2.681   9.173   4.504  1.00  0.00           H  
ATOM    212  N   GLY A  14       0.159   9.063   1.183  1.00  0.00           N  
ATOM    213  CA  GLY A  14       1.423   9.756   1.196  1.00  0.00           C  
ATOM    214  C   GLY A  14       2.513   8.930   1.826  1.00  0.00           C  
ATOM    215  O   GLY A  14       2.365   7.719   1.993  1.00  0.00           O  
ATOM    216  H   GLY A  14       0.140   8.084   1.258  1.00  0.00           H  
ATOM    217  HA2 GLY A  14       1.705   9.994   0.180  1.00  0.00           H  
ATOM    218  HA3 GLY A  14       1.315  10.674   1.754  1.00  0.00           H  
ATOM    219  N   TYR A  15       3.600   9.580   2.185  1.00  0.00           N  
ATOM    220  CA  TYR A  15       4.725   8.902   2.801  1.00  0.00           C  
ATOM    221  C   TYR A  15       4.661   9.058   4.313  1.00  0.00           C  
ATOM    222  O   TYR A  15       4.082  10.022   4.819  1.00  0.00           O  
ATOM    223  CB  TYR A  15       6.044   9.463   2.265  1.00  0.00           C  
ATOM    224  CG  TYR A  15       6.144   9.426   0.754  1.00  0.00           C  
ATOM    225  CD1 TYR A  15       6.622   8.301   0.098  1.00  0.00           C  
ATOM    226  CD2 TYR A  15       5.750  10.515  -0.017  1.00  0.00           C  
ATOM    227  CE1 TYR A  15       6.706   8.260  -1.281  1.00  0.00           C  
ATOM    228  CE2 TYR A  15       5.829  10.477  -1.396  1.00  0.00           C  
ATOM    229  CZ  TYR A  15       6.307   9.347  -2.022  1.00  0.00           C  
ATOM    230  OH  TYR A  15       6.387   9.306  -3.394  1.00  0.00           O  
ATOM    231  H   TYR A  15       3.648  10.550   2.035  1.00  0.00           H  
ATOM    232  HA  TYR A  15       4.658   7.853   2.553  1.00  0.00           H  
ATOM    233  HB2 TYR A  15       6.145  10.489   2.585  1.00  0.00           H  
ATOM    234  HB3 TYR A  15       6.860   8.883   2.669  1.00  0.00           H  
ATOM    235  HD1 TYR A  15       6.935   7.447   0.681  1.00  0.00           H  
ATOM    236  HD2 TYR A  15       5.374  11.402   0.477  1.00  0.00           H  
ATOM    237  HE1 TYR A  15       7.081   7.373  -1.771  1.00  0.00           H  
ATOM    238  HE2 TYR A  15       5.517  11.335  -1.977  1.00  0.00           H  
ATOM    239  HH  TYR A  15       6.205   8.404  -3.699  1.00  0.00           H  
ATOM    240  N   SER A  16       5.237   8.109   5.027  1.00  0.00           N  
ATOM    241  CA  SER A  16       5.241   8.132   6.475  1.00  0.00           C  
ATOM    242  C   SER A  16       6.225   9.176   6.999  1.00  0.00           C  
ATOM    243  O   SER A  16       7.098   9.637   6.265  1.00  0.00           O  
ATOM    244  CB  SER A  16       5.622   6.749   6.988  1.00  0.00           C  
ATOM    245  OG  SER A  16       6.926   6.397   6.565  1.00  0.00           O  
ATOM    246  H   SER A  16       5.679   7.361   4.568  1.00  0.00           H  
ATOM    247  HA  SER A  16       4.246   8.376   6.814  1.00  0.00           H  
ATOM    248  HB2 SER A  16       5.594   6.750   8.059  1.00  0.00           H  
ATOM    249  HB3 SER A  16       4.923   6.018   6.609  1.00  0.00           H  
ATOM    250  HG  SER A  16       7.088   5.463   6.763  1.00  0.00           H  
ATOM    251  N   PRO A  17       6.092   9.580   8.270  1.00  0.00           N  
ATOM    252  CA  PRO A  17       7.044  10.488   8.914  1.00  0.00           C  
ATOM    253  C   PRO A  17       8.385   9.811   9.194  1.00  0.00           C  
ATOM    254  O   PRO A  17       9.377  10.471   9.506  1.00  0.00           O  
ATOM    255  CB  PRO A  17       6.357  10.875  10.233  1.00  0.00           C  
ATOM    256  CG  PRO A  17       4.948  10.394  10.111  1.00  0.00           C  
ATOM    257  CD  PRO A  17       4.988   9.225   9.173  1.00  0.00           C  
ATOM    258  HA  PRO A  17       7.207  11.374   8.317  1.00  0.00           H  
ATOM    259  HB2 PRO A  17       6.867  10.398  11.059  1.00  0.00           H  
ATOM    260  HB3 PRO A  17       6.395  11.948  10.358  1.00  0.00           H  
ATOM    261  HG2 PRO A  17       4.578  10.086  11.080  1.00  0.00           H  
ATOM    262  HG3 PRO A  17       4.327  11.179   9.704  1.00  0.00           H  
ATOM    263  HD2 PRO A  17       5.201   8.312   9.710  1.00  0.00           H  
ATOM    264  HD3 PRO A  17       4.058   9.140   8.631  1.00  0.00           H  
ATOM    265  N   ALA A  18       8.410   8.489   9.072  1.00  0.00           N  
ATOM    266  CA  ALA A  18       9.614   7.715   9.350  1.00  0.00           C  
ATOM    267  C   ALA A  18      10.489   7.567   8.110  1.00  0.00           C  
ATOM    268  O   ALA A  18      11.559   6.958   8.165  1.00  0.00           O  
ATOM    269  CB  ALA A  18       9.246   6.346   9.896  1.00  0.00           C  
ATOM    270  H   ALA A  18       7.594   8.021   8.791  1.00  0.00           H  
ATOM    271  HA  ALA A  18      10.175   8.238  10.110  1.00  0.00           H  
ATOM    272  HB1 ALA A  18       8.740   5.779   9.131  1.00  0.00           H  
ATOM    273  HB2 ALA A  18       8.595   6.464  10.749  1.00  0.00           H  
ATOM    274  HB3 ALA A  18      10.145   5.828  10.195  1.00  0.00           H  
ATOM    275  N   ILE A  19      10.035   8.124   6.993  1.00  0.00           N  
ATOM    276  CA  ILE A  19      10.791   8.053   5.751  1.00  0.00           C  
ATOM    277  C   ILE A  19      12.100   8.833   5.889  1.00  0.00           C  
ATOM    278  O   ILE A  19      12.102  10.009   6.261  1.00  0.00           O  
ATOM    279  CB  ILE A  19       9.961   8.568   4.550  1.00  0.00           C  
ATOM    280  CG1 ILE A  19      10.690   8.296   3.237  1.00  0.00           C  
ATOM    281  CG2 ILE A  19       9.646  10.054   4.688  1.00  0.00           C  
ATOM    282  CD1 ILE A  19       9.865   8.634   2.016  1.00  0.00           C  
ATOM    283  H   ILE A  19       9.179   8.599   7.006  1.00  0.00           H  
ATOM    284  HA  ILE A  19      11.030   7.012   5.574  1.00  0.00           H  
ATOM    285  HB  ILE A  19       9.020   8.034   4.543  1.00  0.00           H  
ATOM    286 HG12 ILE A  19      11.592   8.888   3.202  1.00  0.00           H  
ATOM    287 HG13 ILE A  19      10.947   7.247   3.188  1.00  0.00           H  
ATOM    288 HG21 ILE A  19       9.032  10.212   5.562  1.00  0.00           H  
ATOM    289 HG22 ILE A  19       9.118  10.394   3.810  1.00  0.00           H  
ATOM    290 HG23 ILE A  19      10.567  10.608   4.792  1.00  0.00           H  
ATOM    291 HD11 ILE A  19       8.964   8.040   2.014  1.00  0.00           H  
ATOM    292 HD12 ILE A  19      10.437   8.422   1.127  1.00  0.00           H  
ATOM    293 HD13 ILE A  19       9.607   9.683   2.036  1.00  0.00           H  
ATOM    294  N   SER A  20      13.215   8.170   5.622  1.00  0.00           N  
ATOM    295  CA  SER A  20      14.519   8.770   5.873  1.00  0.00           C  
ATOM    296  C   SER A  20      15.508   8.476   4.747  1.00  0.00           C  
ATOM    297  O   SER A  20      15.303   7.556   3.955  1.00  0.00           O  
ATOM    298  CB  SER A  20      15.079   8.240   7.199  1.00  0.00           C  
ATOM    299  OG  SER A  20      14.113   8.341   8.234  1.00  0.00           O  
ATOM    300  H   SER A  20      13.164   7.267   5.246  1.00  0.00           H  
ATOM    301  HA  SER A  20      14.387   9.836   5.953  1.00  0.00           H  
ATOM    302  HB2 SER A  20      15.359   7.203   7.085  1.00  0.00           H  
ATOM    303  HB3 SER A  20      15.948   8.819   7.476  1.00  0.00           H  
ATOM    304  HG  SER A  20      13.337   7.813   8.005  1.00  0.00           H  
ATOM    305  N   ASN A  21      16.550   9.304   4.665  1.00  0.00           N  
ATOM    306  CA  ASN A  21      17.723   9.048   3.818  1.00  0.00           C  
ATOM    307  C   ASN A  21      17.366   8.938   2.333  1.00  0.00           C  
ATOM    308  O   ASN A  21      17.896   8.086   1.616  1.00  0.00           O  
ATOM    309  CB  ASN A  21      18.447   7.775   4.295  1.00  0.00           C  
ATOM    310  CG  ASN A  21      19.857   7.662   3.739  1.00  0.00           C  
ATOM    311  OD1 ASN A  21      20.519   8.669   3.485  1.00  0.00           O  
ATOM    312  ND2 ASN A  21      20.329   6.441   3.554  1.00  0.00           N  
ATOM    313  H   ASN A  21      16.526  10.132   5.188  1.00  0.00           H  
ATOM    314  HA  ASN A  21      18.393   9.884   3.941  1.00  0.00           H  
ATOM    315  HB2 ASN A  21      18.508   7.786   5.371  1.00  0.00           H  
ATOM    316  HB3 ASN A  21      17.882   6.909   3.978  1.00  0.00           H  
ATOM    317 HD21 ASN A  21      19.746   5.674   3.784  1.00  0.00           H  
ATOM    318 HD22 ASN A  21      21.236   6.342   3.195  1.00  0.00           H  
ATOM    319  N   GLY A  22      16.474   9.807   1.864  1.00  0.00           N  
ATOM    320  CA  GLY A  22      16.158   9.850   0.448  1.00  0.00           C  
ATOM    321  C   GLY A  22      15.381   8.639  -0.022  1.00  0.00           C  
ATOM    322  O   GLY A  22      15.372   8.328  -1.214  1.00  0.00           O  
ATOM    323  H   GLY A  22      16.026  10.430   2.486  1.00  0.00           H  
ATOM    324  HA2 GLY A  22      15.575  10.734   0.240  1.00  0.00           H  
ATOM    325  HA3 GLY A  22      17.083   9.907  -0.108  1.00  0.00           H  
ATOM    326  N   TYR A  23      14.714   7.960   0.905  1.00  0.00           N  
ATOM    327  CA  TYR A  23      13.931   6.781   0.567  1.00  0.00           C  
ATOM    328  C   TYR A  23      12.744   7.141  -0.320  1.00  0.00           C  
ATOM    329  O   TYR A  23      12.244   6.295  -1.056  1.00  0.00           O  
ATOM    330  CB  TYR A  23      13.455   6.060   1.824  1.00  0.00           C  
ATOM    331  CG  TYR A  23      14.250   4.811   2.136  1.00  0.00           C  
ATOM    332  CD1 TYR A  23      14.327   3.772   1.216  1.00  0.00           C  
ATOM    333  CD2 TYR A  23      14.918   4.664   3.346  1.00  0.00           C  
ATOM    334  CE1 TYR A  23      15.043   2.623   1.494  1.00  0.00           C  
ATOM    335  CE2 TYR A  23      15.638   3.520   3.629  1.00  0.00           C  
ATOM    336  CZ  TYR A  23      15.697   2.503   2.701  1.00  0.00           C  
ATOM    337  OH  TYR A  23      16.408   1.358   2.986  1.00  0.00           O  
ATOM    338  H   TYR A  23      14.767   8.243   1.843  1.00  0.00           H  
ATOM    339  HA  TYR A  23      14.577   6.114   0.011  1.00  0.00           H  
ATOM    340  HB2 TYR A  23      13.544   6.728   2.667  1.00  0.00           H  
ATOM    341  HB3 TYR A  23      12.422   5.779   1.700  1.00  0.00           H  
ATOM    342  HD1 TYR A  23      13.813   3.868   0.272  1.00  0.00           H  
ATOM    343  HD2 TYR A  23      14.868   5.462   4.074  1.00  0.00           H  
ATOM    344  HE1 TYR A  23      15.092   1.829   0.765  1.00  0.00           H  
ATOM    345  HE2 TYR A  23      16.151   3.425   4.574  1.00  0.00           H  
ATOM    346  HH  TYR A  23      16.895   1.083   2.197  1.00  0.00           H  
ATOM    347  N   ARG A  24      12.309   8.398  -0.266  1.00  0.00           N  
ATOM    348  CA  ARG A  24      11.225   8.859  -1.124  1.00  0.00           C  
ATOM    349  C   ARG A  24      11.619   8.680  -2.580  1.00  0.00           C  
ATOM    350  O   ARG A  24      10.798   8.337  -3.428  1.00  0.00           O  
ATOM    351  CB  ARG A  24      10.906  10.333  -0.870  1.00  0.00           C  
ATOM    352  CG  ARG A  24       9.561  10.748  -1.442  1.00  0.00           C  
ATOM    353  CD  ARG A  24       9.563  12.179  -1.957  1.00  0.00           C  
ATOM    354  NE  ARG A  24      10.013  13.144  -0.955  1.00  0.00           N  
ATOM    355  CZ  ARG A  24       9.237  14.091  -0.430  1.00  0.00           C  
ATOM    356  NH1 ARG A  24       7.952  14.156  -0.759  1.00  0.00           N  
ATOM    357  NH2 ARG A  24       9.744  14.974   0.420  1.00  0.00           N  
ATOM    358  H   ARG A  24      12.722   9.023   0.364  1.00  0.00           H  
ATOM    359  HA  ARG A  24      10.351   8.259  -0.919  1.00  0.00           H  
ATOM    360  HB2 ARG A  24      10.897  10.511   0.194  1.00  0.00           H  
ATOM    361  HB3 ARG A  24      11.673  10.943  -1.326  1.00  0.00           H  
ATOM    362  HG2 ARG A  24       9.315  10.087  -2.257  1.00  0.00           H  
ATOM    363  HG3 ARG A  24       8.814  10.656  -0.667  1.00  0.00           H  
ATOM    364  HD2 ARG A  24      10.216  12.239  -2.814  1.00  0.00           H  
ATOM    365  HD3 ARG A  24       8.556  12.435  -2.258  1.00  0.00           H  
ATOM    366  HE  ARG A  24      10.965  13.105  -0.688  1.00  0.00           H  
ATOM    367 HH11 ARG A  24       7.563  13.497  -1.402  1.00  0.00           H  
ATOM    368 HH12 ARG A  24       7.360  14.871  -0.360  1.00  0.00           H  
ATOM    369 HH21 ARG A  24      10.720  14.936   0.673  1.00  0.00           H  
ATOM    370 HH22 ARG A  24       9.159  15.699   0.813  1.00  0.00           H  
ATOM    371  N   GLN A  25      12.897   8.900  -2.850  1.00  0.00           N  
ATOM    372  CA  GLN A  25      13.445   8.768  -4.180  1.00  0.00           C  
ATOM    373  C   GLN A  25      13.466   7.309  -4.612  1.00  0.00           C  
ATOM    374  O   GLN A  25      13.218   6.995  -5.774  1.00  0.00           O  
ATOM    375  CB  GLN A  25      14.846   9.365  -4.199  1.00  0.00           C  
ATOM    376  CG  GLN A  25      14.856  10.880  -4.054  1.00  0.00           C  
ATOM    377  CD  GLN A  25      16.245  11.440  -3.808  1.00  0.00           C  
ATOM    378  OE1 GLN A  25      16.560  12.558  -4.223  1.00  0.00           O  
ATOM    379  NE2 GLN A  25      17.080  10.678  -3.120  1.00  0.00           N  
ATOM    380  H   GLN A  25      13.500   9.157  -2.121  1.00  0.00           H  
ATOM    381  HA  GLN A  25      12.816   9.319  -4.855  1.00  0.00           H  
ATOM    382  HB2 GLN A  25      15.412   8.943  -3.383  1.00  0.00           H  
ATOM    383  HB3 GLN A  25      15.323   9.110  -5.121  1.00  0.00           H  
ATOM    384  HG2 GLN A  25      14.466  11.317  -4.961  1.00  0.00           H  
ATOM    385  HG3 GLN A  25      14.219  11.156  -3.223  1.00  0.00           H  
ATOM    386 HE21 GLN A  25      16.763   9.804  -2.809  1.00  0.00           H  
ATOM    387 HE22 GLN A  25      17.986  11.024  -2.941  1.00  0.00           H  
ATOM    388  N   ARG A  26      13.738   6.420  -3.665  1.00  0.00           N  
ATOM    389  CA  ARG A  26      13.708   4.990  -3.933  1.00  0.00           C  
ATOM    390  C   ARG A  26      12.278   4.555  -4.225  1.00  0.00           C  
ATOM    391  O   ARG A  26      12.024   3.786  -5.151  1.00  0.00           O  
ATOM    392  CB  ARG A  26      14.255   4.208  -2.735  1.00  0.00           C  
ATOM    393  CG  ARG A  26      14.368   2.708  -2.978  1.00  0.00           C  
ATOM    394  CD  ARG A  26      15.466   2.383  -3.982  1.00  0.00           C  
ATOM    395  NE  ARG A  26      16.793   2.715  -3.462  1.00  0.00           N  
ATOM    396  CZ  ARG A  26      17.931   2.577  -4.144  1.00  0.00           C  
ATOM    397  NH1 ARG A  26      17.921   2.137  -5.395  1.00  0.00           N  
ATOM    398  NH2 ARG A  26      19.083   2.884  -3.564  1.00  0.00           N  
ATOM    399  H   ARG A  26      13.957   6.735  -2.761  1.00  0.00           H  
ATOM    400  HA  ARG A  26      14.321   4.797  -4.800  1.00  0.00           H  
ATOM    401  HB2 ARG A  26      15.233   4.586  -2.491  1.00  0.00           H  
ATOM    402  HB3 ARG A  26      13.600   4.365  -1.889  1.00  0.00           H  
ATOM    403  HG2 ARG A  26      14.592   2.218  -2.043  1.00  0.00           H  
ATOM    404  HG3 ARG A  26      13.426   2.344  -3.359  1.00  0.00           H  
ATOM    405  HD2 ARG A  26      15.433   1.326  -4.205  1.00  0.00           H  
ATOM    406  HD3 ARG A  26      15.290   2.948  -4.886  1.00  0.00           H  
ATOM    407  HE  ARG A  26      16.839   3.050  -2.536  1.00  0.00           H  
ATOM    408 HH11 ARG A  26      17.054   1.902  -5.847  1.00  0.00           H  
ATOM    409 HH12 ARG A  26      18.791   2.038  -5.904  1.00  0.00           H  
ATOM    410 HH21 ARG A  26      19.094   3.218  -2.613  1.00  0.00           H  
ATOM    411 HH22 ARG A  26      19.953   2.778  -4.064  1.00  0.00           H  
ATOM    412  N   LEU A  27      11.352   5.084  -3.438  1.00  0.00           N  
ATOM    413  CA  LEU A  27       9.936   4.768  -3.586  1.00  0.00           C  
ATOM    414  C   LEU A  27       9.413   5.301  -4.912  1.00  0.00           C  
ATOM    415  O   LEU A  27       8.688   4.611  -5.624  1.00  0.00           O  
ATOM    416  CB  LEU A  27       9.132   5.368  -2.427  1.00  0.00           C  
ATOM    417  CG  LEU A  27       9.537   4.887  -1.032  1.00  0.00           C  
ATOM    418  CD1 LEU A  27       8.769   5.646   0.034  1.00  0.00           C  
ATOM    419  CD2 LEU A  27       9.301   3.393  -0.888  1.00  0.00           C  
ATOM    420  H   LEU A  27      11.631   5.710  -2.732  1.00  0.00           H  
ATOM    421  HA  LEU A  27       9.828   3.692  -3.576  1.00  0.00           H  
ATOM    422  HB2 LEU A  27       9.242   6.441  -2.459  1.00  0.00           H  
ATOM    423  HB3 LEU A  27       8.090   5.125  -2.578  1.00  0.00           H  
ATOM    424  HG  LEU A  27      10.588   5.076  -0.883  1.00  0.00           H  
ATOM    425 HD11 LEU A  27       7.710   5.497  -0.108  1.00  0.00           H  
ATOM    426 HD12 LEU A  27       8.995   6.700  -0.044  1.00  0.00           H  
ATOM    427 HD13 LEU A  27       9.057   5.289   1.012  1.00  0.00           H  
ATOM    428 HD21 LEU A  27       9.894   2.864  -1.620  1.00  0.00           H  
ATOM    429 HD22 LEU A  27       8.255   3.176  -1.045  1.00  0.00           H  
ATOM    430 HD23 LEU A  27       9.590   3.078   0.103  1.00  0.00           H  
ATOM    431  N   PHE A  28       9.806   6.522  -5.247  1.00  0.00           N  
ATOM    432  CA  PHE A  28       9.407   7.149  -6.503  1.00  0.00           C  
ATOM    433  C   PHE A  28       9.923   6.339  -7.682  1.00  0.00           C  
ATOM    434  O   PHE A  28       9.222   6.142  -8.675  1.00  0.00           O  
ATOM    435  CB  PHE A  28       9.956   8.570  -6.571  1.00  0.00           C  
ATOM    436  CG  PHE A  28       9.341   9.403  -7.660  1.00  0.00           C  
ATOM    437  CD1 PHE A  28       8.039   9.870  -7.543  1.00  0.00           C  
ATOM    438  CD2 PHE A  28      10.062   9.719  -8.799  1.00  0.00           C  
ATOM    439  CE1 PHE A  28       7.471  10.636  -8.543  1.00  0.00           C  
ATOM    440  CE2 PHE A  28       9.499  10.485  -9.801  1.00  0.00           C  
ATOM    441  CZ  PHE A  28       8.201  10.943  -9.674  1.00  0.00           C  
ATOM    442  H   PHE A  28      10.376   7.027  -4.622  1.00  0.00           H  
ATOM    443  HA  PHE A  28       8.327   7.183  -6.540  1.00  0.00           H  
ATOM    444  HB2 PHE A  28       9.773   9.057  -5.632  1.00  0.00           H  
ATOM    445  HB3 PHE A  28      11.020   8.528  -6.748  1.00  0.00           H  
ATOM    446  HD1 PHE A  28       7.466   9.629  -6.660  1.00  0.00           H  
ATOM    447  HD2 PHE A  28      11.078   9.365  -8.901  1.00  0.00           H  
ATOM    448  HE1 PHE A  28       6.458  10.993  -8.440  1.00  0.00           H  
ATOM    449  HE2 PHE A  28      10.071  10.723 -10.687  1.00  0.00           H  
ATOM    450  HZ  PHE A  28       7.759  11.541 -10.457  1.00  0.00           H  
ATOM    451  N   SER A  29      11.156   5.874  -7.553  1.00  0.00           N  
ATOM    452  CA  SER A  29      11.764   5.010  -8.552  1.00  0.00           C  
ATOM    453  C   SER A  29      10.963   3.719  -8.711  1.00  0.00           C  
ATOM    454  O   SER A  29      10.829   3.195  -9.816  1.00  0.00           O  
ATOM    455  CB  SER A  29      13.203   4.680  -8.158  1.00  0.00           C  
ATOM    456  OG  SER A  29      13.997   5.854  -8.079  1.00  0.00           O  
ATOM    457  H   SER A  29      11.678   6.133  -6.764  1.00  0.00           H  
ATOM    458  HA  SER A  29      11.765   5.537  -9.491  1.00  0.00           H  
ATOM    459  HB2 SER A  29      13.205   4.194  -7.192  1.00  0.00           H  
ATOM    460  HB3 SER A  29      13.631   4.016  -8.892  1.00  0.00           H  
ATOM    461  HG  SER A  29      13.687   6.404  -7.345  1.00  0.00           H  
ATOM    462  N   MET A  30      10.416   3.229  -7.604  1.00  0.00           N  
ATOM    463  CA  MET A  30       9.663   1.980  -7.609  1.00  0.00           C  
ATOM    464  C   MET A  30       8.208   2.203  -8.018  1.00  0.00           C  
ATOM    465  O   MET A  30       7.474   1.247  -8.279  1.00  0.00           O  
ATOM    466  CB  MET A  30       9.730   1.314  -6.233  1.00  0.00           C  
ATOM    467  CG  MET A  30      11.094   0.723  -5.914  1.00  0.00           C  
ATOM    468  SD  MET A  30      11.100  -0.258  -4.400  1.00  0.00           S  
ATOM    469  CE  MET A  30      10.620   0.971  -3.189  1.00  0.00           C  
ATOM    470  H   MET A  30      10.526   3.721  -6.759  1.00  0.00           H  
ATOM    471  HA  MET A  30      10.127   1.326  -8.331  1.00  0.00           H  
ATOM    472  HB2 MET A  30       9.500   2.055  -5.479  1.00  0.00           H  
ATOM    473  HB3 MET A  30       8.996   0.530  -6.188  1.00  0.00           H  
ATOM    474  HG2 MET A  30      11.394   0.088  -6.736  1.00  0.00           H  
ATOM    475  HG3 MET A  30      11.804   1.530  -5.808  1.00  0.00           H  
ATOM    476  HE1 MET A  30      11.315   1.795  -3.221  1.00  0.00           H  
ATOM    477  HE2 MET A  30      10.631   0.528  -2.203  1.00  0.00           H  
ATOM    478  HE3 MET A  30       9.625   1.329  -3.413  1.00  0.00           H  
ATOM    479  N   GLY A  31       7.795   3.461  -8.069  1.00  0.00           N  
ATOM    480  CA  GLY A  31       6.444   3.786  -8.490  1.00  0.00           C  
ATOM    481  C   GLY A  31       5.483   3.912  -7.324  1.00  0.00           C  
ATOM    482  O   GLY A  31       4.285   3.674  -7.471  1.00  0.00           O  
ATOM    483  H   GLY A  31       8.413   4.179  -7.819  1.00  0.00           H  
ATOM    484  HA2 GLY A  31       6.464   4.722  -9.031  1.00  0.00           H  
ATOM    485  HA3 GLY A  31       6.088   3.010  -9.151  1.00  0.00           H  
ATOM    486  N   LEU A  32       6.007   4.280  -6.165  1.00  0.00           N  
ATOM    487  CA  LEU A  32       5.183   4.460  -4.977  1.00  0.00           C  
ATOM    488  C   LEU A  32       5.003   5.943  -4.669  1.00  0.00           C  
ATOM    489  O   LEU A  32       5.913   6.602  -4.162  1.00  0.00           O  
ATOM    490  CB  LEU A  32       5.811   3.740  -3.781  1.00  0.00           C  
ATOM    491  CG  LEU A  32       5.964   2.224  -3.940  1.00  0.00           C  
ATOM    492  CD1 LEU A  32       6.667   1.631  -2.730  1.00  0.00           C  
ATOM    493  CD2 LEU A  32       4.605   1.570  -4.138  1.00  0.00           C  
ATOM    494  H   LEU A  32       6.974   4.438  -6.101  1.00  0.00           H  
ATOM    495  HA  LEU A  32       4.212   4.029  -5.178  1.00  0.00           H  
ATOM    496  HB2 LEU A  32       6.790   4.166  -3.606  1.00  0.00           H  
ATOM    497  HB3 LEU A  32       5.198   3.927  -2.911  1.00  0.00           H  
ATOM    498  HG  LEU A  32       6.569   2.018  -4.813  1.00  0.00           H  
ATOM    499 HD11 LEU A  32       6.088   1.837  -1.841  1.00  0.00           H  
ATOM    500 HD12 LEU A  32       7.648   2.069  -2.630  1.00  0.00           H  
ATOM    501 HD13 LEU A  32       6.761   0.563  -2.855  1.00  0.00           H  
ATOM    502 HD21 LEU A  32       4.733   0.505  -4.261  1.00  0.00           H  
ATOM    503 HD22 LEU A  32       4.134   1.981  -5.020  1.00  0.00           H  
ATOM    504 HD23 LEU A  32       3.985   1.763  -3.275  1.00  0.00           H  
ATOM    505  N   LEU A  33       3.835   6.468  -5.006  1.00  0.00           N  
ATOM    506  CA  LEU A  33       3.531   7.866  -4.786  1.00  0.00           C  
ATOM    507  C   LEU A  33       2.106   8.020  -4.258  1.00  0.00           C  
ATOM    508  O   LEU A  33       1.271   7.130  -4.445  1.00  0.00           O  
ATOM    509  CB  LEU A  33       3.703   8.664  -6.086  1.00  0.00           C  
ATOM    510  CG  LEU A  33       2.788   8.265  -7.251  1.00  0.00           C  
ATOM    511  CD1 LEU A  33       2.705   9.398  -8.258  1.00  0.00           C  
ATOM    512  CD2 LEU A  33       3.293   7.006  -7.939  1.00  0.00           C  
ATOM    513  H   LEU A  33       3.157   5.903  -5.428  1.00  0.00           H  
ATOM    514  HA  LEU A  33       4.222   8.243  -4.046  1.00  0.00           H  
ATOM    515  HB2 LEU A  33       3.524   9.700  -5.862  1.00  0.00           H  
ATOM    516  HB3 LEU A  33       4.726   8.557  -6.412  1.00  0.00           H  
ATOM    517  HG  LEU A  33       1.794   8.072  -6.874  1.00  0.00           H  
ATOM    518 HD11 LEU A  33       3.693   9.615  -8.634  1.00  0.00           H  
ATOM    519 HD12 LEU A  33       2.301  10.277  -7.779  1.00  0.00           H  
ATOM    520 HD13 LEU A  33       2.062   9.107  -9.077  1.00  0.00           H  
ATOM    521 HD21 LEU A  33       2.600   6.717  -8.718  1.00  0.00           H  
ATOM    522 HD22 LEU A  33       3.375   6.210  -7.216  1.00  0.00           H  
ATOM    523 HD23 LEU A  33       4.262   7.198  -8.375  1.00  0.00           H  
ATOM    524  N   PRO A  34       1.817   9.136  -3.571  1.00  0.00           N  
ATOM    525  CA  PRO A  34       0.476   9.418  -3.052  1.00  0.00           C  
ATOM    526  C   PRO A  34      -0.554   9.537  -4.169  1.00  0.00           C  
ATOM    527  O   PRO A  34      -0.293  10.155  -5.204  1.00  0.00           O  
ATOM    528  CB  PRO A  34       0.633  10.763  -2.334  1.00  0.00           C  
ATOM    529  CG  PRO A  34       2.097  10.913  -2.104  1.00  0.00           C  
ATOM    530  CD  PRO A  34       2.766  10.211  -3.248  1.00  0.00           C  
ATOM    531  HA  PRO A  34       0.156   8.664  -2.347  1.00  0.00           H  
ATOM    532  HB2 PRO A  34       0.247  11.553  -2.961  1.00  0.00           H  
ATOM    533  HB3 PRO A  34       0.088  10.740  -1.401  1.00  0.00           H  
ATOM    534  HG2 PRO A  34       2.362  11.960  -2.099  1.00  0.00           H  
ATOM    535  HG3 PRO A  34       2.374  10.450  -1.168  1.00  0.00           H  
ATOM    536  HD2 PRO A  34       2.891  10.885  -4.085  1.00  0.00           H  
ATOM    537  HD3 PRO A  34       3.718   9.806  -2.940  1.00  0.00           H  
ATOM    538  N   GLY A  35      -1.714   8.937  -3.961  1.00  0.00           N  
ATOM    539  CA  GLY A  35      -2.761   8.993  -4.958  1.00  0.00           C  
ATOM    540  C   GLY A  35      -3.070   7.633  -5.544  1.00  0.00           C  
ATOM    541  O   GLY A  35      -4.128   7.438  -6.143  1.00  0.00           O  
ATOM    542  H   GLY A  35      -1.864   8.453  -3.115  1.00  0.00           H  
ATOM    543  HA2 GLY A  35      -3.657   9.390  -4.503  1.00  0.00           H  
ATOM    544  HA3 GLY A  35      -2.452   9.655  -5.754  1.00  0.00           H  
ATOM    545  N   ALA A  36      -2.153   6.688  -5.368  1.00  0.00           N  
ATOM    546  CA  ALA A  36      -2.335   5.352  -5.881  1.00  0.00           C  
ATOM    547  C   ALA A  36      -3.114   4.511  -4.888  1.00  0.00           C  
ATOM    548  O   ALA A  36      -3.427   4.959  -3.781  1.00  0.00           O  
ATOM    549  CB  ALA A  36      -0.989   4.710  -6.191  1.00  0.00           C  
ATOM    550  H   ALA A  36      -1.342   6.890  -4.874  1.00  0.00           H  
ATOM    551  HA  ALA A  36      -2.897   5.418  -6.801  1.00  0.00           H  
ATOM    552  HB1 ALA A  36      -1.147   3.735  -6.628  1.00  0.00           H  
ATOM    553  HB2 ALA A  36      -0.419   4.605  -5.280  1.00  0.00           H  
ATOM    554  HB3 ALA A  36      -0.444   5.332  -6.886  1.00  0.00           H  
ATOM    555  N   ALA A  37      -3.411   3.298  -5.284  1.00  0.00           N  
ATOM    556  CA  ALA A  37      -4.207   2.391  -4.469  1.00  0.00           C  
ATOM    557  C   ALA A  37      -3.795   0.943  -4.702  1.00  0.00           C  
ATOM    558  O   ALA A  37      -3.371   0.575  -5.798  1.00  0.00           O  
ATOM    559  CB  ALA A  37      -5.689   2.574  -4.769  1.00  0.00           C  
ATOM    560  H   ALA A  37      -3.074   2.999  -6.151  1.00  0.00           H  
ATOM    561  HA  ALA A  37      -4.039   2.640  -3.432  1.00  0.00           H  
ATOM    562  HB1 ALA A  37      -6.272   1.934  -4.121  1.00  0.00           H  
ATOM    563  HB2 ALA A  37      -5.885   2.319  -5.799  1.00  0.00           H  
ATOM    564  HB3 ALA A  37      -5.966   3.604  -4.596  1.00  0.00           H  
ATOM    565  N   LEU A  38      -3.914   0.130  -3.664  1.00  0.00           N  
ATOM    566  CA  LEU A  38      -3.583  -1.281  -3.751  1.00  0.00           C  
ATOM    567  C   LEU A  38      -4.789  -2.126  -3.361  1.00  0.00           C  
ATOM    568  O   LEU A  38      -5.416  -1.896  -2.325  1.00  0.00           O  
ATOM    569  CB  LEU A  38      -2.409  -1.617  -2.832  1.00  0.00           C  
ATOM    570  CG  LEU A  38      -1.162  -0.745  -3.004  1.00  0.00           C  
ATOM    571  CD1 LEU A  38      -0.126  -1.094  -1.946  1.00  0.00           C  
ATOM    572  CD2 LEU A  38      -0.576  -0.920  -4.397  1.00  0.00           C  
ATOM    573  H   LEU A  38      -4.228   0.493  -2.804  1.00  0.00           H  
ATOM    574  HA  LEU A  38      -3.312  -1.503  -4.773  1.00  0.00           H  
ATOM    575  HB2 LEU A  38      -2.749  -1.533  -1.816  1.00  0.00           H  
ATOM    576  HB3 LEU A  38      -2.127  -2.644  -3.011  1.00  0.00           H  
ATOM    577  HG  LEU A  38      -1.431   0.294  -2.880  1.00  0.00           H  
ATOM    578 HD11 LEU A  38       0.732  -0.445  -2.052  1.00  0.00           H  
ATOM    579 HD12 LEU A  38       0.185  -2.121  -2.071  1.00  0.00           H  
ATOM    580 HD13 LEU A  38      -0.556  -0.966  -0.963  1.00  0.00           H  
ATOM    581 HD21 LEU A  38      -1.307  -0.622  -5.134  1.00  0.00           H  
ATOM    582 HD22 LEU A  38      -0.316  -1.957  -4.549  1.00  0.00           H  
ATOM    583 HD23 LEU A  38       0.306  -0.309  -4.497  1.00  0.00           H  
ATOM    584  N   ARG A  39      -5.108  -3.091  -4.196  1.00  0.00           N  
ATOM    585  CA  ARG A  39      -6.216  -4.002  -3.943  1.00  0.00           C  
ATOM    586  C   ARG A  39      -5.681  -5.297  -3.347  1.00  0.00           C  
ATOM    587  O   ARG A  39      -4.875  -5.980  -3.973  1.00  0.00           O  
ATOM    588  CB  ARG A  39      -6.963  -4.273  -5.252  1.00  0.00           C  
ATOM    589  CG  ARG A  39      -8.172  -5.177  -5.103  1.00  0.00           C  
ATOM    590  CD  ARG A  39      -8.963  -5.253  -6.400  1.00  0.00           C  
ATOM    591  NE  ARG A  39      -9.466  -3.941  -6.805  1.00  0.00           N  
ATOM    592  CZ  ARG A  39     -10.704  -3.717  -7.241  1.00  0.00           C  
ATOM    593  NH1 ARG A  39     -11.544  -4.729  -7.427  1.00  0.00           N  
ATOM    594  NH2 ARG A  39     -11.085  -2.479  -7.527  1.00  0.00           N  
ATOM    595  H   ARG A  39      -4.576  -3.200  -5.015  1.00  0.00           H  
ATOM    596  HA  ARG A  39      -6.886  -3.533  -3.236  1.00  0.00           H  
ATOM    597  HB2 ARG A  39      -7.295  -3.332  -5.664  1.00  0.00           H  
ATOM    598  HB3 ARG A  39      -6.278  -4.737  -5.949  1.00  0.00           H  
ATOM    599  HG2 ARG A  39      -7.841  -6.168  -4.836  1.00  0.00           H  
ATOM    600  HG3 ARG A  39      -8.809  -4.782  -4.326  1.00  0.00           H  
ATOM    601  HD2 ARG A  39      -8.321  -5.638  -7.178  1.00  0.00           H  
ATOM    602  HD3 ARG A  39      -9.799  -5.922  -6.259  1.00  0.00           H  
ATOM    603  HE  ARG A  39      -8.840  -3.175  -6.731  1.00  0.00           H  
ATOM    604 HH11 ARG A  39     -11.248  -5.670  -7.245  1.00  0.00           H  
ATOM    605 HH12 ARG A  39     -12.484  -4.556  -7.752  1.00  0.00           H  
ATOM    606 HH21 ARG A  39     -10.443  -1.717  -7.418  1.00  0.00           H  
ATOM    607 HH22 ARG A  39     -12.024  -2.295  -7.846  1.00  0.00           H  
ATOM    608  N   VAL A  40      -6.120  -5.625  -2.142  1.00  0.00           N  
ATOM    609  CA  VAL A  40      -5.552  -6.744  -1.395  1.00  0.00           C  
ATOM    610  C   VAL A  40      -5.725  -8.086  -2.114  1.00  0.00           C  
ATOM    611  O   VAL A  40      -6.824  -8.444  -2.549  1.00  0.00           O  
ATOM    612  CB  VAL A  40      -6.153  -6.845   0.030  1.00  0.00           C  
ATOM    613  CG1 VAL A  40      -7.638  -7.172  -0.013  1.00  0.00           C  
ATOM    614  CG2 VAL A  40      -5.402  -7.873   0.860  1.00  0.00           C  
ATOM    615  H   VAL A  40      -6.853  -5.107  -1.742  1.00  0.00           H  
ATOM    616  HA  VAL A  40      -4.493  -6.557  -1.292  1.00  0.00           H  
ATOM    617  HB  VAL A  40      -6.044  -5.885   0.510  1.00  0.00           H  
ATOM    618 HG11 VAL A  40      -7.787  -8.103  -0.540  1.00  0.00           H  
ATOM    619 HG12 VAL A  40      -8.165  -6.380  -0.526  1.00  0.00           H  
ATOM    620 HG13 VAL A  40      -8.017  -7.265   0.993  1.00  0.00           H  
ATOM    621 HG21 VAL A  40      -5.477  -8.841   0.386  1.00  0.00           H  
ATOM    622 HG22 VAL A  40      -5.831  -7.921   1.849  1.00  0.00           H  
ATOM    623 HG23 VAL A  40      -4.363  -7.588   0.932  1.00  0.00           H  
ATOM    624  N   VAL A  41      -4.612  -8.794  -2.277  1.00  0.00           N  
ATOM    625  CA  VAL A  41      -4.643 -10.193  -2.656  1.00  0.00           C  
ATOM    626  C   VAL A  41      -4.487 -11.044  -1.402  1.00  0.00           C  
ATOM    627  O   VAL A  41      -5.329 -11.892  -1.116  1.00  0.00           O  
ATOM    628  CB  VAL A  41      -3.535 -10.541  -3.678  1.00  0.00           C  
ATOM    629  CG1 VAL A  41      -3.497 -12.035  -3.950  1.00  0.00           C  
ATOM    630  CG2 VAL A  41      -3.744  -9.770  -4.974  1.00  0.00           C  
ATOM    631  H   VAL A  41      -3.737  -8.354  -2.155  1.00  0.00           H  
ATOM    632  HA  VAL A  41      -5.605 -10.398  -3.104  1.00  0.00           H  
ATOM    633  HB  VAL A  41      -2.582 -10.252  -3.260  1.00  0.00           H  
ATOM    634 HG11 VAL A  41      -2.712 -12.248  -4.659  1.00  0.00           H  
ATOM    635 HG12 VAL A  41      -4.445 -12.353  -4.355  1.00  0.00           H  
ATOM    636 HG13 VAL A  41      -3.301 -12.566  -3.029  1.00  0.00           H  
ATOM    637 HG21 VAL A  41      -4.716 -10.007  -5.379  1.00  0.00           H  
ATOM    638 HG22 VAL A  41      -2.980 -10.050  -5.685  1.00  0.00           H  
ATOM    639 HG23 VAL A  41      -3.683  -8.711  -4.777  1.00  0.00           H  
ATOM    640  N   ARG A  42      -3.410 -10.784  -0.645  1.00  0.00           N  
ATOM    641  CA  ARG A  42      -3.183 -11.440   0.651  1.00  0.00           C  
ATOM    642  C   ARG A  42      -1.812 -11.096   1.232  1.00  0.00           C  
ATOM    643  O   ARG A  42      -0.882 -10.732   0.511  1.00  0.00           O  
ATOM    644  CB  ARG A  42      -3.303 -12.968   0.554  1.00  0.00           C  
ATOM    645  CG  ARG A  42      -2.275 -13.628  -0.353  1.00  0.00           C  
ATOM    646  CD  ARG A  42      -2.337 -15.142  -0.239  1.00  0.00           C  
ATOM    647  NE  ARG A  42      -1.371 -15.809  -1.106  1.00  0.00           N  
ATOM    648  CZ  ARG A  42      -0.475 -16.700  -0.679  1.00  0.00           C  
ATOM    649  NH1 ARG A  42      -0.385 -16.990   0.616  1.00  0.00           N  
ATOM    650  NH2 ARG A  42       0.335 -17.290  -1.549  1.00  0.00           N  
ATOM    651  H   ARG A  42      -2.757 -10.121  -0.965  1.00  0.00           H  
ATOM    652  HA  ARG A  42      -3.940 -11.079   1.330  1.00  0.00           H  
ATOM    653  HB2 ARG A  42      -3.192 -13.387   1.542  1.00  0.00           H  
ATOM    654  HB3 ARG A  42      -4.288 -13.214   0.181  1.00  0.00           H  
ATOM    655  HG2 ARG A  42      -2.477 -13.344  -1.377  1.00  0.00           H  
ATOM    656  HG3 ARG A  42      -1.290 -13.292  -0.070  1.00  0.00           H  
ATOM    657  HD2 ARG A  42      -2.132 -15.419   0.783  1.00  0.00           H  
ATOM    658  HD3 ARG A  42      -3.331 -15.470  -0.506  1.00  0.00           H  
ATOM    659  HE  ARG A  42      -1.405 -15.597  -2.066  1.00  0.00           H  
ATOM    660 HH11 ARG A  42      -0.992 -16.540   1.283  1.00  0.00           H  
ATOM    661 HH12 ARG A  42       0.295 -17.664   0.938  1.00  0.00           H  
ATOM    662 HH21 ARG A  42       0.278 -17.064  -2.528  1.00  0.00           H  
ATOM    663 HH22 ARG A  42       1.008 -17.972  -1.236  1.00  0.00           H  
ATOM    664  N   ILE A  43      -1.709 -11.212   2.553  1.00  0.00           N  
ATOM    665  CA  ILE A  43      -0.432 -11.131   3.255  1.00  0.00           C  
ATOM    666  C   ILE A  43      -0.189 -12.467   3.959  1.00  0.00           C  
ATOM    667  O   ILE A  43      -1.134 -13.090   4.447  1.00  0.00           O  
ATOM    668  CB  ILE A  43      -0.414  -9.992   4.307  1.00  0.00           C  
ATOM    669  CG1 ILE A  43      -0.609  -8.638   3.615  1.00  0.00           C  
ATOM    670  CG2 ILE A  43       0.891 -10.005   5.115  1.00  0.00           C  
ATOM    671  CD1 ILE A  43      -0.709  -7.470   4.571  1.00  0.00           C  
ATOM    672  H   ILE A  43      -2.521 -11.365   3.080  1.00  0.00           H  
ATOM    673  HA  ILE A  43       0.350 -10.945   2.523  1.00  0.00           H  
ATOM    674  HB  ILE A  43      -1.232 -10.155   4.991  1.00  0.00           H  
ATOM    675 HG12 ILE A  43       0.226  -8.454   2.957  1.00  0.00           H  
ATOM    676 HG13 ILE A  43      -1.520  -8.671   3.032  1.00  0.00           H  
ATOM    677 HG21 ILE A  43       0.992 -10.952   5.631  1.00  0.00           H  
ATOM    678 HG22 ILE A  43       0.879  -9.205   5.840  1.00  0.00           H  
ATOM    679 HG23 ILE A  43       1.732  -9.872   4.450  1.00  0.00           H  
ATOM    680 HD11 ILE A  43      -0.838  -6.555   4.009  1.00  0.00           H  
ATOM    681 HD12 ILE A  43       0.195  -7.407   5.158  1.00  0.00           H  
ATOM    682 HD13 ILE A  43      -1.556  -7.612   5.226  1.00  0.00           H  
ATOM    683  N   ALA A  44       1.052 -12.925   3.984  1.00  0.00           N  
ATOM    684  CA  ALA A  44       1.390 -14.156   4.693  1.00  0.00           C  
ATOM    685  C   ALA A  44       1.401 -13.921   6.203  1.00  0.00           C  
ATOM    686  O   ALA A  44       1.979 -12.942   6.679  1.00  0.00           O  
ATOM    687  CB  ALA A  44       2.737 -14.692   4.229  1.00  0.00           C  
ATOM    688  H   ALA A  44       1.754 -12.432   3.517  1.00  0.00           H  
ATOM    689  HA  ALA A  44       0.633 -14.892   4.459  1.00  0.00           H  
ATOM    690  HB1 ALA A  44       2.709 -14.869   3.164  1.00  0.00           H  
ATOM    691  HB2 ALA A  44       2.955 -15.616   4.744  1.00  0.00           H  
ATOM    692  HB3 ALA A  44       3.504 -13.966   4.453  1.00  0.00           H  
ATOM    693  N   PRO A  45       0.774 -14.831   6.970  1.00  0.00           N  
ATOM    694  CA  PRO A  45       0.607 -14.681   8.427  1.00  0.00           C  
ATOM    695  C   PRO A  45       1.928 -14.747   9.189  1.00  0.00           C  
ATOM    696  O   PRO A  45       2.014 -14.295  10.334  1.00  0.00           O  
ATOM    697  CB  PRO A  45      -0.283 -15.867   8.805  1.00  0.00           C  
ATOM    698  CG  PRO A  45      -0.038 -16.873   7.738  1.00  0.00           C  
ATOM    699  CD  PRO A  45       0.172 -16.084   6.479  1.00  0.00           C  
ATOM    700  HA  PRO A  45       0.102 -13.759   8.669  1.00  0.00           H  
ATOM    701  HB2 PRO A  45       0.005 -16.240   9.777  1.00  0.00           H  
ATOM    702  HB3 PRO A  45      -1.317 -15.553   8.823  1.00  0.00           H  
ATOM    703  HG2 PRO A  45       0.844 -17.453   7.972  1.00  0.00           H  
ATOM    704  HG3 PRO A  45      -0.897 -17.520   7.634  1.00  0.00           H  
ATOM    705  HD2 PRO A  45       0.845 -16.605   5.814  1.00  0.00           H  
ATOM    706  HD3 PRO A  45      -0.772 -15.891   5.992  1.00  0.00           H  
ATOM    707  N   LEU A  46       2.943 -15.321   8.544  1.00  0.00           N  
ATOM    708  CA  LEU A  46       4.294 -15.397   9.106  1.00  0.00           C  
ATOM    709  C   LEU A  46       4.755 -14.031   9.562  1.00  0.00           C  
ATOM    710  O   LEU A  46       5.301 -13.866  10.652  1.00  0.00           O  
ATOM    711  CB  LEU A  46       5.281 -15.919   8.058  1.00  0.00           C  
ATOM    712  CG  LEU A  46       5.482 -17.439   8.039  1.00  0.00           C  
ATOM    713  CD1 LEU A  46       5.999 -17.926   9.390  1.00  0.00           C  
ATOM    714  CD2 LEU A  46       4.186 -18.148   7.670  1.00  0.00           C  
ATOM    715  H   LEU A  46       2.777 -15.706   7.662  1.00  0.00           H  
ATOM    716  HA  LEU A  46       4.275 -16.069   9.948  1.00  0.00           H  
ATOM    717  HB2 LEU A  46       4.927 -15.611   7.082  1.00  0.00           H  
ATOM    718  HB3 LEU A  46       6.238 -15.447   8.229  1.00  0.00           H  
ATOM    719  HG  LEU A  46       6.223 -17.686   7.293  1.00  0.00           H  
ATOM    720 HD11 LEU A  46       6.164 -18.993   9.349  1.00  0.00           H  
ATOM    721 HD12 LEU A  46       5.271 -17.705  10.158  1.00  0.00           H  
ATOM    722 HD13 LEU A  46       6.930 -17.428   9.622  1.00  0.00           H  
ATOM    723 HD21 LEU A  46       3.419 -17.896   8.387  1.00  0.00           H  
ATOM    724 HD22 LEU A  46       4.344 -19.217   7.672  1.00  0.00           H  
ATOM    725 HD23 LEU A  46       3.873 -17.834   6.684  1.00  0.00           H  
ATOM    726  N   GLY A  47       4.511 -13.061   8.713  1.00  0.00           N  
ATOM    727  CA  GLY A  47       4.922 -11.714   8.972  1.00  0.00           C  
ATOM    728  C   GLY A  47       4.412 -10.803   7.906  1.00  0.00           C  
ATOM    729  O   GLY A  47       3.443 -10.070   8.123  1.00  0.00           O  
ATOM    730  H   GLY A  47       4.024 -13.263   7.889  1.00  0.00           H  
ATOM    731  HA2 GLY A  47       4.540 -11.397   9.932  1.00  0.00           H  
ATOM    732  HA3 GLY A  47       5.992 -11.665   8.980  1.00  0.00           H  
ATOM    733  N   ASP A  48       5.031 -10.878   6.733  1.00  0.00           N  
ATOM    734  CA  ASP A  48       4.630 -10.027   5.640  1.00  0.00           C  
ATOM    735  C   ASP A  48       5.394 -10.260   4.355  1.00  0.00           C  
ATOM    736  O   ASP A  48       6.614 -10.349   4.327  1.00  0.00           O  
ATOM    737  CB  ASP A  48       4.877  -8.576   6.030  1.00  0.00           C  
ATOM    738  CG  ASP A  48       6.355  -8.296   6.264  1.00  0.00           C  
ATOM    739  OD1 ASP A  48       6.856  -8.622   7.360  1.00  0.00           O  
ATOM    740  OD2 ASP A  48       7.027  -7.760   5.349  1.00  0.00           O  
ATOM    741  H   ASP A  48       5.769 -11.500   6.610  1.00  0.00           H  
ATOM    742  HA  ASP A  48       3.579 -10.162   5.457  1.00  0.00           H  
ATOM    743  HB2 ASP A  48       4.538  -7.949   5.235  1.00  0.00           H  
ATOM    744  HB3 ASP A  48       4.331  -8.345   6.934  1.00  0.00           H  
ATOM    745  N   PRO A  49       4.641 -10.474   3.297  1.00  0.00           N  
ATOM    746  CA  PRO A  49       4.776  -9.780   2.054  1.00  0.00           C  
ATOM    747  C   PRO A  49       3.507  -8.965   1.873  1.00  0.00           C  
ATOM    748  O   PRO A  49       2.714  -8.849   2.811  1.00  0.00           O  
ATOM    749  CB  PRO A  49       4.828 -10.933   1.057  1.00  0.00           C  
ATOM    750  CG  PRO A  49       4.025 -12.033   1.708  1.00  0.00           C  
ATOM    751  CD  PRO A  49       3.711 -11.579   3.123  1.00  0.00           C  
ATOM    752  HA  PRO A  49       5.656  -9.149   2.006  1.00  0.00           H  
ATOM    753  HB2 PRO A  49       4.390 -10.620   0.121  1.00  0.00           H  
ATOM    754  HB3 PRO A  49       5.852 -11.230   0.903  1.00  0.00           H  
ATOM    755  HG2 PRO A  49       3.110 -12.192   1.158  1.00  0.00           H  
ATOM    756  HG3 PRO A  49       4.608 -12.942   1.730  1.00  0.00           H  
ATOM    757  HD2 PRO A  49       2.688 -11.243   3.196  1.00  0.00           H  
ATOM    758  HD3 PRO A  49       3.909 -12.369   3.831  1.00  0.00           H  
ATOM    759  N   ILE A  50       3.281  -8.424   0.707  1.00  0.00           N  
ATOM    760  CA  ILE A  50       1.998  -7.811   0.431  1.00  0.00           C  
ATOM    761  C   ILE A  50       1.634  -8.038  -1.017  1.00  0.00           C  
ATOM    762  O   ILE A  50       2.149  -7.363  -1.900  1.00  0.00           O  
ATOM    763  CB  ILE A  50       1.970  -6.288   0.733  1.00  0.00           C  
ATOM    764  CG1 ILE A  50       2.227  -6.020   2.219  1.00  0.00           C  
ATOM    765  CG2 ILE A  50       0.633  -5.689   0.313  1.00  0.00           C  
ATOM    766  CD1 ILE A  50       2.179  -4.556   2.592  1.00  0.00           C  
ATOM    767  H   ILE A  50       3.977  -8.441   0.018  1.00  0.00           H  
ATOM    768  HA  ILE A  50       1.257  -8.304   1.062  1.00  0.00           H  
ATOM    769  HB  ILE A  50       2.745  -5.815   0.150  1.00  0.00           H  
ATOM    770 HG12 ILE A  50       1.476  -6.529   2.803  1.00  0.00           H  
ATOM    771 HG13 ILE A  50       3.204  -6.402   2.482  1.00  0.00           H  
ATOM    772 HG21 ILE A  50      -0.159  -6.151   0.881  1.00  0.00           H  
ATOM    773 HG22 ILE A  50       0.473  -5.872  -0.740  1.00  0.00           H  
ATOM    774 HG23 ILE A  50       0.637  -4.625   0.499  1.00  0.00           H  
ATOM    775 HD11 ILE A  50       2.409  -4.443   3.640  1.00  0.00           H  
ATOM    776 HD12 ILE A  50       1.189  -4.166   2.397  1.00  0.00           H  
ATOM    777 HD13 ILE A  50       2.900  -4.011   2.003  1.00  0.00           H  
ATOM    778  N   GLN A  51       0.783  -9.017  -1.257  1.00  0.00           N  
ATOM    779  CA  GLN A  51       0.271  -9.250  -2.586  1.00  0.00           C  
ATOM    780  C   GLN A  51      -0.946  -8.383  -2.816  1.00  0.00           C  
ATOM    781  O   GLN A  51      -1.921  -8.457  -2.066  1.00  0.00           O  
ATOM    782  CB  GLN A  51      -0.080 -10.722  -2.782  1.00  0.00           C  
ATOM    783  CG  GLN A  51       1.126 -11.627  -2.961  1.00  0.00           C  
ATOM    784  CD  GLN A  51       1.871 -11.391  -4.265  1.00  0.00           C  
ATOM    785  OE1 GLN A  51       1.894 -10.284  -4.804  1.00  0.00           O  
ATOM    786  NE2 GLN A  51       2.481 -12.445  -4.789  1.00  0.00           N  
ATOM    787  H   GLN A  51       0.486  -9.597  -0.522  1.00  0.00           H  
ATOM    788  HA  GLN A  51       1.038  -8.972  -3.293  1.00  0.00           H  
ATOM    789  HB2 GLN A  51      -0.635 -11.067  -1.921  1.00  0.00           H  
ATOM    790  HB3 GLN A  51      -0.703 -10.812  -3.654  1.00  0.00           H  
ATOM    791  HG2 GLN A  51       1.807 -11.459  -2.143  1.00  0.00           H  
ATOM    792  HG3 GLN A  51       0.786 -12.646  -2.942  1.00  0.00           H  
ATOM    793 HE21 GLN A  51       2.414 -13.303  -4.316  1.00  0.00           H  
ATOM    794 HE22 GLN A  51       2.976 -12.323  -5.625  1.00  0.00           H  
ATOM    795  N   VAL A  52      -0.877  -7.546  -3.830  1.00  0.00           N  
ATOM    796  CA  VAL A  52      -1.967  -6.640  -4.152  1.00  0.00           C  
ATOM    797  C   VAL A  52      -2.130  -6.500  -5.655  1.00  0.00           C  
ATOM    798  O   VAL A  52      -1.324  -7.011  -6.425  1.00  0.00           O  
ATOM    799  CB  VAL A  52      -1.759  -5.232  -3.544  1.00  0.00           C  
ATOM    800  CG1 VAL A  52      -1.975  -5.244  -2.041  1.00  0.00           C  
ATOM    801  CG2 VAL A  52      -0.378  -4.695  -3.887  1.00  0.00           C  
ATOM    802  H   VAL A  52      -0.061  -7.543  -4.387  1.00  0.00           H  
ATOM    803  HA  VAL A  52      -2.877  -7.052  -3.742  1.00  0.00           H  
ATOM    804  HB  VAL A  52      -2.492  -4.571  -3.981  1.00  0.00           H  
ATOM    805 HG11 VAL A  52      -1.271  -5.923  -1.577  1.00  0.00           H  
ATOM    806 HG12 VAL A  52      -2.980  -5.568  -1.827  1.00  0.00           H  
ATOM    807 HG13 VAL A  52      -1.827  -4.250  -1.649  1.00  0.00           H  
ATOM    808 HG21 VAL A  52      -0.261  -3.710  -3.460  1.00  0.00           H  
ATOM    809 HG22 VAL A  52      -0.271  -4.639  -4.959  1.00  0.00           H  
ATOM    810 HG23 VAL A  52       0.379  -5.355  -3.484  1.00  0.00           H  
ATOM    811  N   GLU A  53      -3.183  -5.818  -6.056  1.00  0.00           N  
ATOM    812  CA  GLU A  53      -3.448  -5.542  -7.454  1.00  0.00           C  
ATOM    813  C   GLU A  53      -3.535  -4.028  -7.627  1.00  0.00           C  
ATOM    814  O   GLU A  53      -3.900  -3.320  -6.688  1.00  0.00           O  
ATOM    815  CB  GLU A  53      -4.754  -6.237  -7.873  1.00  0.00           C  
ATOM    816  CG  GLU A  53      -4.757  -6.758  -9.304  1.00  0.00           C  
ATOM    817  CD  GLU A  53      -4.884  -5.661 -10.336  1.00  0.00           C  
ATOM    818  OE1 GLU A  53      -6.026  -5.297 -10.674  1.00  0.00           O  
ATOM    819  OE2 GLU A  53      -3.841  -5.155 -10.804  1.00  0.00           O  
ATOM    820  H   GLU A  53      -3.815  -5.483  -5.382  1.00  0.00           H  
ATOM    821  HA  GLU A  53      -2.625  -5.927  -8.039  1.00  0.00           H  
ATOM    822  HB2 GLU A  53      -4.928  -7.073  -7.211  1.00  0.00           H  
ATOM    823  HB3 GLU A  53      -5.567  -5.533  -7.768  1.00  0.00           H  
ATOM    824  HG2 GLU A  53      -3.834  -7.288  -9.483  1.00  0.00           H  
ATOM    825  HG3 GLU A  53      -5.587  -7.441  -9.423  1.00  0.00           H  
ATOM    826  N   THR A  54      -3.185  -3.533  -8.800  1.00  0.00           N  
ATOM    827  CA  THR A  54      -3.104  -2.097  -9.023  1.00  0.00           C  
ATOM    828  C   THR A  54      -4.052  -1.637 -10.131  1.00  0.00           C  
ATOM    829  O   THR A  54      -4.565  -0.513 -10.096  1.00  0.00           O  
ATOM    830  CB  THR A  54      -1.662  -1.684  -9.385  1.00  0.00           C  
ATOM    831  OG1 THR A  54      -1.169  -2.507 -10.453  1.00  0.00           O  
ATOM    832  CG2 THR A  54      -0.742  -1.801  -8.175  1.00  0.00           C  
ATOM    833  H   THR A  54      -2.999  -4.150  -9.547  1.00  0.00           H  
ATOM    834  HA  THR A  54      -3.375  -1.602  -8.103  1.00  0.00           H  
ATOM    835  HB  THR A  54      -1.672  -0.654  -9.710  1.00  0.00           H  
ATOM    836  HG1 THR A  54      -1.079  -3.420 -10.144  1.00  0.00           H  
ATOM    837 HG21 THR A  54       0.255  -1.482  -8.446  1.00  0.00           H  
ATOM    838 HG22 THR A  54      -0.713  -2.828  -7.844  1.00  0.00           H  
ATOM    839 HG23 THR A  54      -1.115  -1.176  -7.378  1.00  0.00           H  
ATOM    840  N   ARG A  55      -4.296  -2.522 -11.092  1.00  0.00           N  
ATOM    841  CA  ARG A  55      -5.106  -2.212 -12.265  1.00  0.00           C  
ATOM    842  C   ARG A  55      -5.164  -3.423 -13.189  1.00  0.00           C  
ATOM    843  O   ARG A  55      -6.244  -3.891 -13.556  1.00  0.00           O  
ATOM    844  CB  ARG A  55      -4.533  -1.004 -13.024  1.00  0.00           C  
ATOM    845  CG  ARG A  55      -5.247  -0.704 -14.336  1.00  0.00           C  
ATOM    846  CD  ARG A  55      -6.706  -0.319 -14.122  1.00  0.00           C  
ATOM    847  NE  ARG A  55      -7.429  -0.214 -15.386  1.00  0.00           N  
ATOM    848  CZ  ARG A  55      -8.718   0.108 -15.488  1.00  0.00           C  
ATOM    849  NH1 ARG A  55      -9.407   0.466 -14.412  1.00  0.00           N  
ATOM    850  NH2 ARG A  55      -9.306   0.105 -16.674  1.00  0.00           N  
ATOM    851  H   ARG A  55      -3.938  -3.439 -10.997  1.00  0.00           H  
ATOM    852  HA  ARG A  55      -6.107  -1.979 -11.930  1.00  0.00           H  
ATOM    853  HB2 ARG A  55      -4.607  -0.130 -12.396  1.00  0.00           H  
ATOM    854  HB3 ARG A  55      -3.491  -1.194 -13.243  1.00  0.00           H  
ATOM    855  HG2 ARG A  55      -4.742   0.111 -14.832  1.00  0.00           H  
ATOM    856  HG3 ARG A  55      -5.206  -1.585 -14.961  1.00  0.00           H  
ATOM    857  HD2 ARG A  55      -7.178  -1.072 -13.510  1.00  0.00           H  
ATOM    858  HD3 ARG A  55      -6.744   0.633 -13.615  1.00  0.00           H  
ATOM    859  HE  ARG A  55      -6.924  -0.417 -16.209  1.00  0.00           H  
ATOM    860 HH11 ARG A  55      -8.960   0.504 -13.518  1.00  0.00           H  
ATOM    861 HH12 ARG A  55     -10.386   0.700 -14.489  1.00  0.00           H  
ATOM    862 HH21 ARG A  55      -8.776  -0.138 -17.500  1.00  0.00           H  
ATOM    863 HH22 ARG A  55     -10.276   0.338 -16.762  1.00  0.00           H  
ATOM    864  N   GLN A  56      -3.993  -3.919 -13.565  1.00  0.00           N  
ATOM    865  CA  GLN A  56      -3.887  -5.067 -14.463  1.00  0.00           C  
ATOM    866  C   GLN A  56      -2.711  -5.965 -14.090  1.00  0.00           C  
ATOM    867  O   GLN A  56      -2.412  -6.935 -14.784  1.00  0.00           O  
ATOM    868  CB  GLN A  56      -3.709  -4.592 -15.902  1.00  0.00           C  
ATOM    869  CG  GLN A  56      -4.986  -4.099 -16.565  1.00  0.00           C  
ATOM    870  CD  GLN A  56      -5.993  -5.210 -16.801  1.00  0.00           C  
ATOM    871  OE1 GLN A  56      -5.989  -5.855 -17.849  1.00  0.00           O  
ATOM    872  NE2 GLN A  56      -6.861  -5.446 -15.828  1.00  0.00           N  
ATOM    873  H   GLN A  56      -3.171  -3.502 -13.231  1.00  0.00           H  
ATOM    874  HA  GLN A  56      -4.804  -5.632 -14.389  1.00  0.00           H  
ATOM    875  HB2 GLN A  56      -2.993  -3.784 -15.913  1.00  0.00           H  
ATOM    876  HB3 GLN A  56      -3.317  -5.411 -16.479  1.00  0.00           H  
ATOM    877  HG2 GLN A  56      -5.440  -3.353 -15.928  1.00  0.00           H  
ATOM    878  HG3 GLN A  56      -4.733  -3.653 -17.516  1.00  0.00           H  
ATOM    879 HE21 GLN A  56      -6.803  -4.899 -15.011  1.00  0.00           H  
ATOM    880 HE22 GLN A  56      -7.526  -6.155 -15.962  1.00  0.00           H  
ATOM    881  N   THR A  57      -2.050  -5.643 -12.996  1.00  0.00           N  
ATOM    882  CA  THR A  57      -0.858  -6.369 -12.587  1.00  0.00           C  
ATOM    883  C   THR A  57      -0.707  -6.363 -11.065  1.00  0.00           C  
ATOM    884  O   THR A  57      -0.948  -5.349 -10.400  1.00  0.00           O  
ATOM    885  CB  THR A  57       0.413  -5.789 -13.257  1.00  0.00           C  
ATOM    886  OG1 THR A  57       1.566  -6.563 -12.899  1.00  0.00           O  
ATOM    887  CG2 THR A  57       0.634  -4.333 -12.867  1.00  0.00           C  
ATOM    888  H   THR A  57      -2.385  -4.915 -12.437  1.00  0.00           H  
ATOM    889  HA  THR A  57      -0.973  -7.393 -12.917  1.00  0.00           H  
ATOM    890  HB  THR A  57       0.282  -5.838 -14.328  1.00  0.00           H  
ATOM    891  HG1 THR A  57       2.308  -5.973 -12.734  1.00  0.00           H  
ATOM    892 HG21 THR A  57      -0.226  -3.747 -13.159  1.00  0.00           H  
ATOM    893 HG22 THR A  57       1.513  -3.954 -13.369  1.00  0.00           H  
ATOM    894 HG23 THR A  57       0.772  -4.263 -11.799  1.00  0.00           H  
ATOM    895  N   SER A  58      -0.316  -7.510 -10.523  1.00  0.00           N  
ATOM    896  CA  SER A  58      -0.158  -7.671  -9.087  1.00  0.00           C  
ATOM    897  C   SER A  58       1.172  -7.095  -8.604  1.00  0.00           C  
ATOM    898  O   SER A  58       2.168  -7.111  -9.329  1.00  0.00           O  
ATOM    899  CB  SER A  58      -0.261  -9.152  -8.728  1.00  0.00           C  
ATOM    900  OG  SER A  58       0.567  -9.936  -9.575  1.00  0.00           O  
ATOM    901  H   SER A  58      -0.119  -8.270 -11.108  1.00  0.00           H  
ATOM    902  HA  SER A  58      -0.962  -7.139  -8.604  1.00  0.00           H  
ATOM    903  HB2 SER A  58       0.051  -9.298  -7.705  1.00  0.00           H  
ATOM    904  HB3 SER A  58      -1.283  -9.476  -8.843  1.00  0.00           H  
ATOM    905  HG  SER A  58       1.357  -9.433  -9.803  1.00  0.00           H  
ATOM    906  N   LEU A  59       1.183  -6.600  -7.376  1.00  0.00           N  
ATOM    907  CA  LEU A  59       2.367  -5.990  -6.803  1.00  0.00           C  
ATOM    908  C   LEU A  59       2.649  -6.592  -5.431  1.00  0.00           C  
ATOM    909  O   LEU A  59       1.727  -7.005  -4.733  1.00  0.00           O  
ATOM    910  CB  LEU A  59       2.157  -4.470  -6.721  1.00  0.00           C  
ATOM    911  CG  LEU A  59       3.405  -3.593  -6.518  1.00  0.00           C  
ATOM    912  CD1 LEU A  59       3.831  -3.549  -5.062  1.00  0.00           C  
ATOM    913  CD2 LEU A  59       4.550  -4.071  -7.401  1.00  0.00           C  
ATOM    914  H   LEU A  59       0.366  -6.650  -6.833  1.00  0.00           H  
ATOM    915  HA  LEU A  59       3.194  -6.201  -7.455  1.00  0.00           H  
ATOM    916  HB2 LEU A  59       1.686  -4.157  -7.635  1.00  0.00           H  
ATOM    917  HB3 LEU A  59       1.475  -4.270  -5.907  1.00  0.00           H  
ATOM    918  HG  LEU A  59       3.164  -2.586  -6.814  1.00  0.00           H  
ATOM    919 HD11 LEU A  59       4.049  -4.548  -4.716  1.00  0.00           H  
ATOM    920 HD12 LEU A  59       3.035  -3.126  -4.465  1.00  0.00           H  
ATOM    921 HD13 LEU A  59       4.716  -2.935  -4.965  1.00  0.00           H  
ATOM    922 HD21 LEU A  59       4.779  -5.100  -7.172  1.00  0.00           H  
ATOM    923 HD22 LEU A  59       5.422  -3.460  -7.221  1.00  0.00           H  
ATOM    924 HD23 LEU A  59       4.263  -3.988  -8.440  1.00  0.00           H  
ATOM    925  N   ALA A  60       3.924  -6.659  -5.069  1.00  0.00           N  
ATOM    926  CA  ALA A  60       4.344  -7.216  -3.784  1.00  0.00           C  
ATOM    927  C   ALA A  60       5.474  -6.392  -3.175  1.00  0.00           C  
ATOM    928  O   ALA A  60       6.298  -5.834  -3.902  1.00  0.00           O  
ATOM    929  CB  ALA A  60       4.781  -8.663  -3.953  1.00  0.00           C  
ATOM    930  H   ALA A  60       4.604  -6.313  -5.682  1.00  0.00           H  
ATOM    931  HA  ALA A  60       3.494  -7.197  -3.115  1.00  0.00           H  
ATOM    932  HB1 ALA A  60       3.984  -9.229  -4.409  1.00  0.00           H  
ATOM    933  HB2 ALA A  60       5.016  -9.084  -2.986  1.00  0.00           H  
ATOM    934  HB3 ALA A  60       5.656  -8.702  -4.584  1.00  0.00           H  
ATOM    935  N   LEU A  61       5.519  -6.329  -1.843  1.00  0.00           N  
ATOM    936  CA  LEU A  61       6.536  -5.559  -1.133  1.00  0.00           C  
ATOM    937  C   LEU A  61       6.593  -6.008   0.323  1.00  0.00           C  
ATOM    938  O   LEU A  61       5.861  -6.921   0.712  1.00  0.00           O  
ATOM    939  CB  LEU A  61       6.264  -4.044  -1.250  1.00  0.00           C  
ATOM    940  CG  LEU A  61       4.865  -3.573  -0.847  1.00  0.00           C  
ATOM    941  CD1 LEU A  61       4.783  -3.302   0.645  1.00  0.00           C  
ATOM    942  CD2 LEU A  61       4.473  -2.332  -1.635  1.00  0.00           C  
ATOM    943  H   LEU A  61       4.858  -6.833  -1.315  1.00  0.00           H  
ATOM    944  HA  LEU A  61       7.489  -5.778  -1.593  1.00  0.00           H  
ATOM    945  HB2 LEU A  61       6.975  -3.530  -0.627  1.00  0.00           H  
ATOM    946  HB3 LEU A  61       6.435  -3.751  -2.275  1.00  0.00           H  
ATOM    947  HG  LEU A  61       4.160  -4.351  -1.080  1.00  0.00           H  
ATOM    948 HD11 LEU A  61       5.029  -4.204   1.188  1.00  0.00           H  
ATOM    949 HD12 LEU A  61       3.780  -2.993   0.901  1.00  0.00           H  
ATOM    950 HD13 LEU A  61       5.481  -2.522   0.910  1.00  0.00           H  
ATOM    951 HD21 LEU A  61       5.169  -1.534  -1.420  1.00  0.00           H  
ATOM    952 HD22 LEU A  61       3.475  -2.024  -1.356  1.00  0.00           H  
ATOM    953 HD23 LEU A  61       4.498  -2.555  -2.691  1.00  0.00           H  
ATOM    954  N   ARG A  62       7.460  -5.395   1.123  1.00  0.00           N  
ATOM    955  CA  ARG A  62       7.611  -5.811   2.514  1.00  0.00           C  
ATOM    956  C   ARG A  62       7.089  -4.775   3.481  1.00  0.00           C  
ATOM    957  O   ARG A  62       6.803  -3.635   3.123  1.00  0.00           O  
ATOM    958  CB  ARG A  62       9.066  -6.086   2.866  1.00  0.00           C  
ATOM    959  CG  ARG A  62       9.705  -7.132   1.997  1.00  0.00           C  
ATOM    960  CD  ARG A  62       8.962  -8.457   2.034  1.00  0.00           C  
ATOM    961  NE  ARG A  62       8.897  -9.033   3.375  1.00  0.00           N  
ATOM    962  CZ  ARG A  62       9.584 -10.111   3.753  1.00  0.00           C  
ATOM    963  NH1 ARG A  62      10.500 -10.641   2.945  1.00  0.00           N  
ATOM    964  NH2 ARG A  62       9.361 -10.651   4.943  1.00  0.00           N  
ATOM    965  H   ARG A  62       7.999  -4.652   0.779  1.00  0.00           H  
ATOM    966  HA  ARG A  62       7.048  -6.720   2.646  1.00  0.00           H  
ATOM    967  HB2 ARG A  62       9.631  -5.172   2.767  1.00  0.00           H  
ATOM    968  HB3 ARG A  62       9.117  -6.421   3.894  1.00  0.00           H  
ATOM    969  HG2 ARG A  62       9.701  -6.766   0.993  1.00  0.00           H  
ATOM    970  HG3 ARG A  62      10.718  -7.285   2.328  1.00  0.00           H  
ATOM    971  HD2 ARG A  62       7.956  -8.302   1.675  1.00  0.00           H  
ATOM    972  HD3 ARG A  62       9.468  -9.154   1.382  1.00  0.00           H  
ATOM    973  HE  ARG A  62       8.259  -8.626   4.015  1.00  0.00           H  
ATOM    974 HH11 ARG A  62      10.683 -10.230   2.051  1.00  0.00           H  
ATOM    975 HH12 ARG A  62      11.015 -11.456   3.229  1.00  0.00           H  
ATOM    976 HH21 ARG A  62       8.678 -10.247   5.557  1.00  0.00           H  
ATOM    977 HH22 ARG A  62       9.856 -11.483   5.223  1.00  0.00           H  
ATOM    978  N   ARG A  63       7.019  -5.199   4.724  1.00  0.00           N  
ATOM    979  CA  ARG A  63       6.539  -4.347   5.819  1.00  0.00           C  
ATOM    980  C   ARG A  63       7.445  -3.136   6.022  1.00  0.00           C  
ATOM    981  O   ARG A  63       6.980  -2.058   6.375  1.00  0.00           O  
ATOM    982  CB  ARG A  63       6.442  -5.127   7.135  1.00  0.00           C  
ATOM    983  CG  ARG A  63       7.785  -5.516   7.740  1.00  0.00           C  
ATOM    984  CD  ARG A  63       7.608  -6.294   9.031  1.00  0.00           C  
ATOM    985  NE  ARG A  63       8.890  -6.651   9.646  1.00  0.00           N  
ATOM    986  CZ  ARG A  63       9.340  -7.906   9.763  1.00  0.00           C  
ATOM    987  NH1 ARG A  63       8.684  -8.912   9.194  1.00  0.00           N  
ATOM    988  NH2 ARG A  63      10.468  -8.149  10.424  1.00  0.00           N  
ATOM    989  H   ARG A  63       7.277  -6.145   4.906  1.00  0.00           H  
ATOM    990  HA  ARG A  63       5.555  -3.994   5.551  1.00  0.00           H  
ATOM    991  HB2 ARG A  63       5.913  -4.524   7.854  1.00  0.00           H  
ATOM    992  HB3 ARG A  63       5.881  -6.030   6.956  1.00  0.00           H  
ATOM    993  HG2 ARG A  63       8.323  -6.129   7.033  1.00  0.00           H  
ATOM    994  HG3 ARG A  63       8.351  -4.617   7.945  1.00  0.00           H  
ATOM    995  HD2 ARG A  63       7.042  -5.690   9.724  1.00  0.00           H  
ATOM    996  HD3 ARG A  63       7.060  -7.200   8.816  1.00  0.00           H  
ATOM    997  HE  ARG A  63       9.428  -5.910  10.024  1.00  0.00           H  
ATOM    998 HH11 ARG A  63       7.839  -8.733   8.656  1.00  0.00           H  
ATOM    999 HH12 ARG A  63       9.007  -9.862   9.309  1.00  0.00           H  
ATOM   1000 HH21 ARG A  63      10.982  -7.393  10.846  1.00  0.00           H  
ATOM   1001 HH22 ARG A  63      10.822  -9.092  10.496  1.00  0.00           H  
ATOM   1002  N   LYS A  64       8.740  -3.329   5.818  1.00  0.00           N  
ATOM   1003  CA  LYS A  64       9.708  -2.258   6.009  1.00  0.00           C  
ATOM   1004  C   LYS A  64       9.589  -1.212   4.909  1.00  0.00           C  
ATOM   1005  O   LYS A  64       9.787  -0.024   5.147  1.00  0.00           O  
ATOM   1006  CB  LYS A  64      11.120  -2.833   6.044  1.00  0.00           C  
ATOM   1007  CG  LYS A  64      11.329  -3.833   7.167  1.00  0.00           C  
ATOM   1008  CD  LYS A  64      12.776  -4.285   7.258  1.00  0.00           C  
ATOM   1009  CE  LYS A  64      12.982  -5.239   8.421  1.00  0.00           C  
ATOM   1010  NZ  LYS A  64      14.415  -5.576   8.625  1.00  0.00           N  
ATOM   1011  H   LYS A  64       9.051  -4.215   5.550  1.00  0.00           H  
ATOM   1012  HA  LYS A  64       9.499  -1.791   6.957  1.00  0.00           H  
ATOM   1013  HB2 LYS A  64      11.319  -3.326   5.105  1.00  0.00           H  
ATOM   1014  HB3 LYS A  64      11.822  -2.026   6.174  1.00  0.00           H  
ATOM   1015  HG2 LYS A  64      11.049  -3.373   8.101  1.00  0.00           H  
ATOM   1016  HG3 LYS A  64      10.704  -4.696   6.986  1.00  0.00           H  
ATOM   1017  HD2 LYS A  64      13.046  -4.787   6.341  1.00  0.00           H  
ATOM   1018  HD3 LYS A  64      13.405  -3.418   7.397  1.00  0.00           H  
ATOM   1019  HE2 LYS A  64      12.603  -4.775   9.319  1.00  0.00           H  
ATOM   1020  HE3 LYS A  64      12.431  -6.147   8.227  1.00  0.00           H  
ATOM   1021  HZ1 LYS A  64      14.954  -4.718   8.866  1.00  0.00           H  
ATOM   1022  HZ2 LYS A  64      14.819  -5.993   7.758  1.00  0.00           H  
ATOM   1023  HZ3 LYS A  64      14.512  -6.263   9.406  1.00  0.00           H  
ATOM   1024  N   ASP A  65       9.254  -1.665   3.714  1.00  0.00           N  
ATOM   1025  CA  ASP A  65       9.036  -0.768   2.587  1.00  0.00           C  
ATOM   1026  C   ASP A  65       7.693  -0.070   2.744  1.00  0.00           C  
ATOM   1027  O   ASP A  65       7.544   1.108   2.435  1.00  0.00           O  
ATOM   1028  CB  ASP A  65       9.095  -1.564   1.281  1.00  0.00           C  
ATOM   1029  CG  ASP A  65       9.030  -0.693   0.040  1.00  0.00           C  
ATOM   1030  OD1 ASP A  65       9.891   0.196  -0.111  1.00  0.00           O  
ATOM   1031  OD2 ASP A  65       8.135  -0.925  -0.800  1.00  0.00           O  
ATOM   1032  H   ASP A  65       9.150  -2.626   3.581  1.00  0.00           H  
ATOM   1033  HA  ASP A  65       9.817  -0.023   2.592  1.00  0.00           H  
ATOM   1034  HB2 ASP A  65      10.019  -2.123   1.252  1.00  0.00           H  
ATOM   1035  HB3 ASP A  65       8.265  -2.255   1.256  1.00  0.00           H  
ATOM   1036  N   LEU A  66       6.724  -0.810   3.266  1.00  0.00           N  
ATOM   1037  CA  LEU A  66       5.414  -0.252   3.577  1.00  0.00           C  
ATOM   1038  C   LEU A  66       5.522   0.803   4.669  1.00  0.00           C  
ATOM   1039  O   LEU A  66       4.746   1.754   4.713  1.00  0.00           O  
ATOM   1040  CB  LEU A  66       4.466  -1.356   4.040  1.00  0.00           C  
ATOM   1041  CG  LEU A  66       3.028  -0.906   4.297  1.00  0.00           C  
ATOM   1042  CD1 LEU A  66       2.353  -0.539   2.985  1.00  0.00           C  
ATOM   1043  CD2 LEU A  66       2.252  -1.990   5.028  1.00  0.00           C  
ATOM   1044  H   LEU A  66       6.886  -1.765   3.426  1.00  0.00           H  
ATOM   1045  HA  LEU A  66       5.020   0.203   2.683  1.00  0.00           H  
ATOM   1046  HB2 LEU A  66       4.454  -2.126   3.286  1.00  0.00           H  
ATOM   1047  HB3 LEU A  66       4.856  -1.775   4.953  1.00  0.00           H  
ATOM   1048  HG  LEU A  66       3.042  -0.024   4.920  1.00  0.00           H  
ATOM   1049 HD11 LEU A  66       2.898   0.267   2.514  1.00  0.00           H  
ATOM   1050 HD12 LEU A  66       1.338  -0.222   3.178  1.00  0.00           H  
ATOM   1051 HD13 LEU A  66       2.344  -1.398   2.332  1.00  0.00           H  
ATOM   1052 HD21 LEU A  66       2.707  -2.168   5.991  1.00  0.00           H  
ATOM   1053 HD22 LEU A  66       2.269  -2.900   4.447  1.00  0.00           H  
ATOM   1054 HD23 LEU A  66       1.229  -1.670   5.167  1.00  0.00           H  
ATOM   1055  N   ALA A  67       6.499   0.626   5.547  1.00  0.00           N  
ATOM   1056  CA  ALA A  67       6.708   1.536   6.666  1.00  0.00           C  
ATOM   1057  C   ALA A  67       7.176   2.907   6.195  1.00  0.00           C  
ATOM   1058  O   ALA A  67       7.244   3.846   6.984  1.00  0.00           O  
ATOM   1059  CB  ALA A  67       7.707   0.945   7.649  1.00  0.00           C  
ATOM   1060  H   ALA A  67       7.091  -0.149   5.445  1.00  0.00           H  
ATOM   1061  HA  ALA A  67       5.764   1.648   7.179  1.00  0.00           H  
ATOM   1062  HB1 ALA A  67       7.369  -0.032   7.957  1.00  0.00           H  
ATOM   1063  HB2 ALA A  67       7.786   1.588   8.513  1.00  0.00           H  
ATOM   1064  HB3 ALA A  67       8.671   0.860   7.172  1.00  0.00           H  
ATOM   1065  N   LEU A  68       7.514   3.017   4.915  1.00  0.00           N  
ATOM   1066  CA  LEU A  68       7.890   4.297   4.331  1.00  0.00           C  
ATOM   1067  C   LEU A  68       6.668   4.996   3.737  1.00  0.00           C  
ATOM   1068  O   LEU A  68       6.743   6.146   3.302  1.00  0.00           O  
ATOM   1069  CB  LEU A  68       8.953   4.085   3.255  1.00  0.00           C  
ATOM   1070  CG  LEU A  68      10.225   3.375   3.727  1.00  0.00           C  
ATOM   1071  CD1 LEU A  68      11.113   3.039   2.541  1.00  0.00           C  
ATOM   1072  CD2 LEU A  68      10.980   4.239   4.726  1.00  0.00           C  
ATOM   1073  H   LEU A  68       7.524   2.208   4.347  1.00  0.00           H  
ATOM   1074  HA  LEU A  68       8.297   4.919   5.114  1.00  0.00           H  
ATOM   1075  HB2 LEU A  68       8.516   3.503   2.457  1.00  0.00           H  
ATOM   1076  HB3 LEU A  68       9.234   5.049   2.860  1.00  0.00           H  
ATOM   1077  HG  LEU A  68       9.955   2.450   4.216  1.00  0.00           H  
ATOM   1078 HD11 LEU A  68      11.375   3.949   2.021  1.00  0.00           H  
ATOM   1079 HD12 LEU A  68      10.583   2.380   1.869  1.00  0.00           H  
ATOM   1080 HD13 LEU A  68      12.012   2.553   2.891  1.00  0.00           H  
ATOM   1081 HD21 LEU A  68      11.254   5.173   4.256  1.00  0.00           H  
ATOM   1082 HD22 LEU A  68      11.872   3.722   5.046  1.00  0.00           H  
ATOM   1083 HD23 LEU A  68      10.350   4.437   5.580  1.00  0.00           H  
ATOM   1084  N   LEU A  69       5.539   4.302   3.748  1.00  0.00           N  
ATOM   1085  CA  LEU A  69       4.308   4.832   3.188  1.00  0.00           C  
ATOM   1086  C   LEU A  69       3.221   4.921   4.251  1.00  0.00           C  
ATOM   1087  O   LEU A  69       3.238   4.191   5.241  1.00  0.00           O  
ATOM   1088  CB  LEU A  69       3.816   3.941   2.040  1.00  0.00           C  
ATOM   1089  CG  LEU A  69       4.750   3.842   0.831  1.00  0.00           C  
ATOM   1090  CD1 LEU A  69       4.215   2.828  -0.167  1.00  0.00           C  
ATOM   1091  CD2 LEU A  69       4.919   5.204   0.168  1.00  0.00           C  
ATOM   1092  H   LEU A  69       5.531   3.407   4.155  1.00  0.00           H  
ATOM   1093  HA  LEU A  69       4.510   5.821   2.806  1.00  0.00           H  
ATOM   1094  HB2 LEU A  69       3.664   2.944   2.430  1.00  0.00           H  
ATOM   1095  HB3 LEU A  69       2.865   4.323   1.701  1.00  0.00           H  
ATOM   1096  HG  LEU A  69       5.722   3.505   1.161  1.00  0.00           H  
ATOM   1097 HD11 LEU A  69       4.883   2.768  -1.012  1.00  0.00           H  
ATOM   1098 HD12 LEU A  69       3.235   3.135  -0.504  1.00  0.00           H  
ATOM   1099 HD13 LEU A  69       4.145   1.858   0.306  1.00  0.00           H  
ATOM   1100 HD21 LEU A  69       3.960   5.552  -0.193  1.00  0.00           H  
ATOM   1101 HD22 LEU A  69       5.604   5.119  -0.661  1.00  0.00           H  
ATOM   1102 HD23 LEU A  69       5.309   5.908   0.887  1.00  0.00           H  
ATOM   1103  N   THR A  70       2.290   5.833   4.051  1.00  0.00           N  
ATOM   1104  CA  THR A  70       1.096   5.897   4.874  1.00  0.00           C  
ATOM   1105  C   THR A  70      -0.128   5.551   4.028  1.00  0.00           C  
ATOM   1106  O   THR A  70      -0.400   6.208   3.016  1.00  0.00           O  
ATOM   1107  CB  THR A  70       0.915   7.289   5.499  1.00  0.00           C  
ATOM   1108  OG1 THR A  70       2.145   7.723   6.097  1.00  0.00           O  
ATOM   1109  CG2 THR A  70      -0.186   7.278   6.553  1.00  0.00           C  
ATOM   1110  H   THR A  70       2.414   6.492   3.330  1.00  0.00           H  
ATOM   1111  HA  THR A  70       1.194   5.174   5.669  1.00  0.00           H  
ATOM   1112  HB  THR A  70       0.635   7.976   4.719  1.00  0.00           H  
ATOM   1113  HG1 THR A  70       2.422   8.555   5.695  1.00  0.00           H  
ATOM   1114 HG21 THR A  70       0.067   6.570   7.330  1.00  0.00           H  
ATOM   1115 HG22 THR A  70      -1.120   6.990   6.095  1.00  0.00           H  
ATOM   1116 HG23 THR A  70      -0.285   8.264   6.984  1.00  0.00           H  
ATOM   1117  N   LEU A  71      -0.848   4.517   4.432  1.00  0.00           N  
ATOM   1118  CA  LEU A  71      -1.988   4.034   3.662  1.00  0.00           C  
ATOM   1119  C   LEU A  71      -3.306   4.463   4.285  1.00  0.00           C  
ATOM   1120  O   LEU A  71      -3.433   4.562   5.506  1.00  0.00           O  
ATOM   1121  CB  LEU A  71      -1.966   2.506   3.546  1.00  0.00           C  
ATOM   1122  CG  LEU A  71      -0.755   1.905   2.836  1.00  0.00           C  
ATOM   1123  CD1 LEU A  71      -0.924   0.403   2.689  1.00  0.00           C  
ATOM   1124  CD2 LEU A  71      -0.536   2.556   1.480  1.00  0.00           C  
ATOM   1125  H   LEU A  71      -0.619   4.074   5.281  1.00  0.00           H  
ATOM   1126  HA  LEU A  71      -1.919   4.458   2.670  1.00  0.00           H  
ATOM   1127  HB2 LEU A  71      -2.004   2.094   4.543  1.00  0.00           H  
ATOM   1128  HB3 LEU A  71      -2.855   2.194   3.014  1.00  0.00           H  
ATOM   1129  HG  LEU A  71       0.125   2.082   3.437  1.00  0.00           H  
ATOM   1130 HD11 LEU A  71      -1.810   0.193   2.106  1.00  0.00           H  
ATOM   1131 HD12 LEU A  71      -1.022  -0.042   3.668  1.00  0.00           H  
ATOM   1132 HD13 LEU A  71      -0.059  -0.008   2.191  1.00  0.00           H  
ATOM   1133 HD21 LEU A  71       0.316   2.104   0.999  1.00  0.00           H  
ATOM   1134 HD22 LEU A  71      -0.358   3.612   1.614  1.00  0.00           H  
ATOM   1135 HD23 LEU A  71      -1.414   2.415   0.866  1.00  0.00           H  
ATOM   1136  N   VAL A  72      -4.281   4.710   3.429  1.00  0.00           N  
ATOM   1137  CA  VAL A  72      -5.640   4.995   3.860  1.00  0.00           C  
ATOM   1138  C   VAL A  72      -6.617   4.103   3.100  1.00  0.00           C  
ATOM   1139  O   VAL A  72      -6.699   4.157   1.873  1.00  0.00           O  
ATOM   1140  CB  VAL A  72      -6.025   6.479   3.657  1.00  0.00           C  
ATOM   1141  CG1 VAL A  72      -5.301   7.369   4.657  1.00  0.00           C  
ATOM   1142  CG2 VAL A  72      -5.726   6.932   2.234  1.00  0.00           C  
ATOM   1143  H   VAL A  72      -4.081   4.690   2.466  1.00  0.00           H  
ATOM   1144  HA  VAL A  72      -5.708   4.766   4.914  1.00  0.00           H  
ATOM   1145  HB  VAL A  72      -7.087   6.580   3.825  1.00  0.00           H  
ATOM   1146 HG11 VAL A  72      -4.234   7.266   4.521  1.00  0.00           H  
ATOM   1147 HG12 VAL A  72      -5.565   7.072   5.662  1.00  0.00           H  
ATOM   1148 HG13 VAL A  72      -5.587   8.399   4.499  1.00  0.00           H  
ATOM   1149 HG21 VAL A  72      -4.673   6.802   2.029  1.00  0.00           H  
ATOM   1150 HG22 VAL A  72      -5.988   7.974   2.124  1.00  0.00           H  
ATOM   1151 HG23 VAL A  72      -6.304   6.341   1.538  1.00  0.00           H  
ATOM   1152  N   PRO A  73      -7.351   3.243   3.809  1.00  0.00           N  
ATOM   1153  CA  PRO A  73      -8.290   2.322   3.177  1.00  0.00           C  
ATOM   1154  C   PRO A  73      -9.508   3.050   2.624  1.00  0.00           C  
ATOM   1155  O   PRO A  73      -9.773   4.201   2.987  1.00  0.00           O  
ATOM   1156  CB  PRO A  73      -8.713   1.383   4.318  1.00  0.00           C  
ATOM   1157  CG  PRO A  73      -7.812   1.696   5.472  1.00  0.00           C  
ATOM   1158  CD  PRO A  73      -7.337   3.103   5.270  1.00  0.00           C  
ATOM   1159  HA  PRO A  73      -7.821   1.752   2.390  1.00  0.00           H  
ATOM   1160  HB2 PRO A  73      -9.748   1.568   4.571  1.00  0.00           H  
ATOM   1161  HB3 PRO A  73      -8.600   0.357   4.000  1.00  0.00           H  
ATOM   1162  HG2 PRO A  73      -8.363   1.617   6.397  1.00  0.00           H  
ATOM   1163  HG3 PRO A  73      -6.975   1.015   5.475  1.00  0.00           H  
ATOM   1164  HD2 PRO A  73      -8.018   3.804   5.734  1.00  0.00           H  
ATOM   1165  HD3 PRO A  73      -6.338   3.227   5.662  1.00  0.00           H  
ATOM   1166  N   LEU A  74     -10.240   2.384   1.740  1.00  0.00           N  
ATOM   1167  CA  LEU A  74     -11.507   2.907   1.254  1.00  0.00           C  
ATOM   1168  C   LEU A  74     -12.452   3.134   2.430  1.00  0.00           C  
ATOM   1169  O   LEU A  74     -13.061   4.199   2.557  1.00  0.00           O  
ATOM   1170  CB  LEU A  74     -12.138   1.938   0.256  1.00  0.00           C  
ATOM   1171  CG  LEU A  74     -11.348   1.724  -1.035  1.00  0.00           C  
ATOM   1172  CD1 LEU A  74     -12.073   0.743  -1.940  1.00  0.00           C  
ATOM   1173  CD2 LEU A  74     -11.122   3.046  -1.752  1.00  0.00           C  
ATOM   1174  H   LEU A  74      -9.908   1.530   1.385  1.00  0.00           H  
ATOM   1175  HA  LEU A  74     -11.317   3.850   0.766  1.00  0.00           H  
ATOM   1176  HB2 LEU A  74     -12.255   0.980   0.742  1.00  0.00           H  
ATOM   1177  HB3 LEU A  74     -13.110   2.311  -0.002  1.00  0.00           H  
ATOM   1178  HG  LEU A  74     -10.382   1.304  -0.792  1.00  0.00           H  
ATOM   1179 HD11 LEU A  74     -11.517   0.618  -2.856  1.00  0.00           H  
ATOM   1180 HD12 LEU A  74     -13.060   1.122  -2.166  1.00  0.00           H  
ATOM   1181 HD13 LEU A  74     -12.160  -0.210  -1.439  1.00  0.00           H  
ATOM   1182 HD21 LEU A  74     -10.590   2.868  -2.676  1.00  0.00           H  
ATOM   1183 HD22 LEU A  74     -10.540   3.702  -1.123  1.00  0.00           H  
ATOM   1184 HD23 LEU A  74     -12.074   3.506  -1.969  1.00  0.00           H  
ATOM   1185  N   ASP A  75     -12.546   2.124   3.284  1.00  0.00           N  
ATOM   1186  CA  ASP A  75     -13.311   2.212   4.518  1.00  0.00           C  
ATOM   1187  C   ASP A  75     -12.549   1.531   5.644  1.00  0.00           C  
ATOM   1188  O   ASP A  75     -11.713   2.205   6.285  1.00  0.00           O  
ATOM   1189  CB  ASP A  75     -14.697   1.576   4.356  1.00  0.00           C  
ATOM   1190  CG  ASP A  75     -15.693   2.512   3.711  1.00  0.00           C  
ATOM   1191  OD1 ASP A  75     -15.779   2.540   2.465  1.00  0.00           O  
ATOM   1192  OD2 ASP A  75     -16.392   3.237   4.448  1.00  0.00           O  
ATOM   1193  OXT ASP A  75     -12.765   0.320   5.867  1.00  0.00           O  
ATOM   1194  H   ASP A  75     -12.082   1.287   3.079  1.00  0.00           H  
ATOM   1195  HA  ASP A  75     -13.430   3.257   4.760  1.00  0.00           H  
ATOM   1196  HB2 ASP A  75     -14.611   0.694   3.740  1.00  0.00           H  
ATOM   1197  HB3 ASP A  75     -15.072   1.296   5.329  1.00  0.00           H  
TER    1198      ASP A  75                                                      
END
MOLECULE T0492.pdb
ATOM     18  N   PHE     2      -1.543   4.722  10.626  1.00 74.01
ATOM     19  HN  PHE     2      -1.545   5.677  10.295  1.00  0.00
ATOM     20  CA  PHE     2      -2.153   3.701   9.795  1.00  3.52
ATOM     21  HA  PHE     2      -2.214   2.774  10.364  1.00  0.00
ATOM     22  CB  PHE     2      -3.570   4.116   9.379  1.00 43.40
ATOM     23 2HB  PHE     2      -4.130   4.382  10.276  1.00  0.00
ATOM     24 3HB  PHE     2      -3.499   4.995   8.737  1.00  0.00
ATOM     25  CG  PHE     2      -4.330   3.046   8.642  1.00 20.11
ATOM     26  CD1 PHE     2      -4.372   3.032   7.256  1.00 62.52
ATOM     27 1HD  PHE     2      -3.855   3.800   6.699  1.00  0.00
ATOM     28  CE1 PHE     2      -5.067   2.049   6.579  1.00 34.45
ATOM     29 1HE  PHE     2      -5.093   2.052   5.499  1.00  0.00
ATOM     30  CZ  PHE     2      -5.728   1.064   7.284  1.00 62.44
ATOM     31  HZ  PHE     2      -6.269   0.293   6.756  1.00  0.00
ATOM     32  CE2 PHE     2      -5.698   1.066   8.665  1.00 65.21
ATOM     33 2HE  PHE     2      -6.220   0.300   9.218  1.00  0.00
ATOM     34  CD2 PHE     2      -4.999   2.051   9.338  1.00  5.40
ATOM     35 2HD  PHE     2      -4.974   2.046  10.418  1.00  0.00
ATOM     36  C   PHE     2      -1.276   3.477   8.572  1.00 11.34
ATOM     37  O   PHE     2      -1.121   4.368   7.734  1.00 25.11
ATOM     38  N   SER     3      -0.684   2.301   8.493  1.00 64.43
ATOM     39  HN  SER     3      -0.879   1.592   9.184  1.00  0.00
ATOM     40  CA  SER     3       0.249   1.991   7.431  1.00 24.31
ATOM     41  HA  SER     3       0.539   2.917   6.933  1.00  0.00
ATOM     42  CB  SER     3       1.493   1.334   8.027  1.00 64.20
ATOM     43 2HB  SER     3       1.287   0.280   8.213  1.00  0.00
ATOM     44 3HB  SER     3       2.318   1.424   7.320  1.00  0.00
ATOM     45  OG  SER     3       1.856   1.959   9.247  1.00 35.21
ATOM     46  HG  SER     3       2.639   1.527   9.597  1.00  0.00
ATOM     47  C   SER     3      -0.397   1.063   6.412  1.00 60.05
ATOM     48  O   SER     3      -1.528   0.612   6.597  1.00  3.21
ATOM     49  N   LEU     4       0.328   0.765   5.345  1.00 12.31
ATOM     50  HN  LEU     4       1.247   1.169   5.233  1.00  0.00
ATOM     51  CA  LEU     4      -0.162  -0.138   4.314  1.00 14.12
ATOM     52  HA  LEU     4      -1.150   0.198   4.000  1.00  0.00
ATOM     53  CB  LEU     4       0.773  -0.115   3.101  1.00 12.03
ATOM     54 2HB  LEU     4       0.891   0.923   2.787  1.00  0.00
ATOM     55 3HB  LEU     4       1.739  -0.512   3.413  1.00  0.00
ATOM     56  CG  LEU     4       0.298  -0.924   1.891  1.00 23.03
ATOM     57  HG  LEU     4       0.144  -1.956   2.206  1.00  0.00
ATOM     58  CD1 LEU     4      -1.022  -0.380   1.370  1.00 51.12
ATOM     59 1HD1 LEU     4      -1.358  -0.976   0.522  1.00  0.00
ATOM     60 2HD1 LEU     4      -1.770  -0.424   2.162  1.00  0.00
ATOM     61 3HD1 LEU     4      -0.888   0.655   1.054  1.00  0.00
ATOM     62  CD2 LEU     4       1.353  -0.909   0.796  1.00 63.44
ATOM     63 1HD2 LEU     4       1.014  -1.505  -0.051  1.00  0.00
ATOM     64 2HD2 LEU     4       1.524   0.118   0.470  1.00  0.00
ATOM     65 3HD2 LEU     4       2.283  -1.326   1.182  1.00  0.00
ATOM     66  C   LEU     4      -0.277  -1.556   4.867  1.00 33.11
ATOM     67  O   LEU     4      -1.097  -2.351   4.413  1.00 44.21
ATOM     68  N   ARG     5       0.537  -1.858   5.872  1.00 30.21
ATOM     69  HN  ARG     5       1.184  -1.165   6.222  1.00  0.00
ATOM     70  CA  ARG     5       0.527  -3.177   6.493  1.00 63.40
ATOM     71  HA  ARG     5       0.383  -3.914   5.703  1.00  0.00
ATOM     72  CB  ARG     5       1.875  -3.467   7.172  1.00 74.52
ATOM     73 2HB  ARG     5       1.804  -4.437   7.663  1.00  0.00
ATOM     74 3HB  ARG     5       2.642  -3.506   6.398  1.00  0.00
ATOM     75  CG  ARG     5       2.309  -2.440   8.214  1.00  4.51
ATOM     76 2HG  ARG     5       3.389  -2.511   8.347  1.00  0.00
ATOM     77 3HG  ARG     5       2.052  -1.444   7.852  1.00  0.00
ATOM     78  CD  ARG     5       1.636  -2.660   9.559  1.00 60.41
ATOM     79 2HD  ARG     5       0.561  -2.522   9.442  1.00  0.00
ATOM     80 3HD  ARG     5       1.833  -3.680   9.889  1.00  0.00
ATOM     81  NE  ARG     5       2.123  -1.732  10.576  1.00 53.25
ATOM     82  HE  ARG     5       2.750  -1.000  10.273  1.00  0.00
ATOM     83  CZ  ARG     5       1.788  -1.799  11.863  1.00 31.32
ATOM     84  NH1 ARG     5       0.974  -2.752  12.297  1.00 42.13
ATOM     85 1HH1 ARG     5       0.725  -2.799  13.274  1.00  0.00
ATOM     86 2HH1 ARG     5       0.603  -3.431  11.649  1.00  0.00
ATOM     87  NH2 ARG     5       2.275  -0.912  12.719  1.00  5.31
ATOM     88 1HH2 ARG     5       2.024  -0.962  13.696  1.00  0.00
ATOM     89 2HH2 ARG     5       2.898  -0.185  12.394  1.00  0.00
ATOM     90  C   ARG     5      -0.629  -3.317   7.482  1.00 10.22
ATOM     91  O   ARG     5      -0.864  -4.396   8.028  1.00 64.31
ATOM     92  N   ASP     6      -1.337  -2.219   7.719  1.00 63.24
ATOM     93  HN  ASP     6      -1.079  -1.348   7.276  1.00  0.00
ATOM     94  CA  ASP     6      -2.490  -2.231   8.612  1.00 35.34
ATOM     95  HA  ASP     6      -2.323  -2.992   9.374  1.00  0.00
ATOM     96  CB  ASP     6      -2.667  -0.876   9.304  1.00 22.10
ATOM     97 2HB  ASP     6      -2.603  -0.090   8.551  1.00  0.00
ATOM     98 3HB  ASP     6      -3.653  -0.848   9.767  1.00  0.00
ATOM     99  CG  ASP     6      -1.625  -0.608  10.371  1.00 45.42
ATOM    100  OD1 ASP     6      -1.739  -1.182  11.475  1.00 64.32
ATOM    101  OD2 ASP     6      -0.704   0.198  10.124  1.00 21.34
ATOM    102 2HD  ASP     6      -0.086   0.324  10.848  1.00  0.00
ATOM    103  C   ASP     6      -3.756  -2.578   7.839  1.00 55.21
ATOM    104  O   ASP     6      -4.831  -2.744   8.422  1.00 30.54
ATOM    105  N   ALA     7      -3.625  -2.680   6.524  1.00 72.34
ATOM    106  HN  ALA     7      -2.728  -2.503   6.093  1.00  0.00
ATOM    107  CA  ALA     7      -4.743  -3.041   5.669  1.00 22.13
ATOM    108  HA  ALA     7      -5.659  -2.672   6.130  1.00  0.00
ATOM    109  CB  ALA     7      -4.595  -2.392   4.302  1.00 22.42
ATOM    110 1HB  ALA     7      -5.451  -2.648   3.677  1.00  0.00
ATOM    111 2HB  ALA     7      -4.544  -1.309   4.418  1.00  0.00
ATOM    112 3HB  ALA     7      -3.681  -2.749   3.828  1.00  0.00
ATOM    113  C   ALA     7      -4.843  -4.555   5.534  1.00 53.13
ATOM    114  O   ALA     7      -3.841  -5.264   5.629  1.00 30.50
ATOM    115  N   LYS     8      -6.054  -5.046   5.322  1.00 32.51
ATOM    116  HN  LYS     8      -6.843  -4.420   5.247  1.00  0.00
ATOM    117  CA  LYS     8      -6.289  -6.477   5.191  1.00 22.44
ATOM    118  HA  LYS     8      -5.454  -7.012   5.645  1.00  0.00
ATOM    119  CB  LYS     8      -7.584  -6.872   5.910  1.00 13.25
ATOM    120 2HB  LYS     8      -8.423  -6.441   5.364  1.00  0.00
ATOM    121 3HB  LYS     8      -7.663  -7.959   5.899  1.00  0.00
ATOM    122  CG  LYS     8      -7.664  -6.403   7.354  1.00 65.44
ATOM    123 2HG  LYS     8      -7.546  -5.319   7.379  1.00  0.00
ATOM    124 3HG  LYS     8      -8.640  -6.671   7.758  1.00  0.00
ATOM    125  CD  LYS     8      -6.584  -7.035   8.217  1.00 11.52
ATOM    126 2HD  LYS     8      -6.700  -8.118   8.196  1.00  0.00
ATOM    127 3HD  LYS     8      -5.606  -6.767   7.816  1.00  0.00
ATOM    128  CE  LYS     8      -6.680  -6.553   9.654  1.00 44.24
ATOM    129 2HE  LYS     8      -6.530  -5.473   9.674  1.00  0.00
ATOM    130 3HE  LYS     8      -7.674  -6.784  10.037  1.00  0.00
ATOM    131  NZ  LYS     8      -5.665  -7.196  10.531  1.00  4.24
ATOM    132 1HZ  LYS     8      -5.760  -6.850  11.475  1.00  0.00
ATOM    133 2HZ  LYS     8      -5.801  -8.196  10.525  1.00  0.00
ATOM    134 3HZ  LYS     8      -4.740  -6.980  10.188  1.00  0.00
ATOM    135  C   LYS     8      -6.383  -6.857   3.718  1.00 42.14
ATOM    136  O   LYS     8      -6.815  -6.049   2.891  1.00 20.55
ATOM    137  N   CYS     9      -5.980  -8.076   3.388  1.00 41.51
ATOM    138  HN  CYS     9      -5.610  -8.695   4.094  1.00  0.00
ATOM    139  CA  CYS     9      -6.058  -8.552   2.015  1.00  2.35
ATOM    140  HA  CYS     9      -5.629  -7.787   1.367  1.00  0.00
ATOM    141  CB  CYS     9      -5.243  -9.834   1.843  1.00 21.02
ATOM    142 2HB  CYS     9      -5.616 -10.355   0.961  1.00  0.00
ATOM    143 3HB  CYS     9      -4.201  -9.552   1.687  1.00  0.00
ATOM    144  SG  CYS     9      -5.327 -10.961   3.252  1.00 72.52
ATOM    145  HG  CYS     9      -4.531 -11.912   2.755  1.00  0.00
ATOM    146  C   CYS     9      -7.512  -8.761   1.608  1.00 15.30
ATOM    147  O   CYS     9      -8.192  -9.663   2.102  1.00 13.32
ATOM    148  N   GLY    10      -7.978  -7.908   0.711  1.00 51.22
ATOM    149  HN  GLY    10      -7.355  -7.248   0.267  1.00  0.00
ATOM    150  CA  GLY    10      -9.376  -7.897   0.346  1.00  3.45
ATOM    151 1HA  GLY    10      -9.478  -8.244  -0.682  1.00  0.00
ATOM    152 2HA  GLY    10      -9.922  -8.567   1.009  1.00  0.00
ATOM    153  C   GLY    10      -9.962  -6.506   0.458  1.00 12.24
ATOM    154  O   GLY    10     -11.091  -6.256   0.029  1.00 13.34
ATOM    155  N   GLN    11      -9.191  -5.600   1.045  1.00 41.41
ATOM    156  HN  GLN    11      -8.285  -5.870   1.401  1.00  0.00
ATOM    157  CA  GLN    11      -9.605  -4.213   1.198  1.00 43.31
ATOM    158  HA  GLN    11     -10.686  -4.162   1.069  1.00  0.00
ATOM    159  CB  GLN    11      -9.253  -3.704   2.597  1.00 35.22
ATOM    160 2HB  GLN    11      -8.178  -3.812   2.741  1.00  0.00
ATOM    161 3HB  GLN    11      -9.523  -2.649   2.657  1.00  0.00
ATOM    162  CG  GLN    11      -9.963  -4.445   3.718  1.00 24.45
ATOM    163 2HG  GLN    11     -11.038  -4.302   3.607  1.00  0.00
ATOM    164 3HG  GLN    11      -9.731  -5.507   3.638  1.00  0.00
ATOM    165  CD  GLN    11      -9.544  -3.956   5.092  1.00 53.41
ATOM    166  OE1 GLN    11      -8.414  -3.504   5.288  1.00 54.04
ATOM    167  NE2 GLN    11     -10.448  -4.036   6.053  1.00 44.33
ATOM    168 1HE2 GLN    11     -11.363  -4.411   5.850  1.00  0.00
ATOM    169 2HE2 GLN    11     -10.222  -3.722   6.986  1.00  0.00
ATOM    170  C   GLN    11      -8.945  -3.330   0.142  1.00  4.23
ATOM    171  O   GLN    11      -7.996  -3.743  -0.527  1.00 30.34
ATOM    172  N   THR    12      -9.461  -2.119  -0.008  1.00  5.22
ATOM    173  HN  THR    12     -10.253  -1.839   0.553  1.00  0.00
ATOM    174  CA  THR    12      -8.921  -1.166  -0.962  1.00 72.31
ATOM    175  HA  THR    12      -8.091  -1.639  -1.488  1.00  0.00
ATOM    176  CB  THR    12      -9.989  -0.754  -1.992  1.00 24.54
ATOM    177  HB  THR    12     -10.761  -0.176  -1.484  1.00  0.00
ATOM    178  OG1 THR    12     -10.582  -1.926  -2.562  1.00 13.33
ATOM    179 1HG  THR    12     -11.256  -1.655  -3.189  1.00  0.00
ATOM    180  CG2 THR    12      -9.387   0.100  -3.099  1.00  4.01
ATOM    181 1HG2 THR    12     -10.161   0.386  -3.812  1.00  0.00
ATOM    182 2HG2 THR    12      -8.948   0.999  -2.665  1.00  0.00
ATOM    183 3HG2 THR    12      -8.613  -0.469  -3.615  1.00  0.00
ATOM    184  C   THR    12      -8.405   0.076  -0.241  1.00 11.14
ATOM    185  O   THR    12      -9.153   0.749   0.471  1.00 21.50
ATOM    186  N   VAL    13      -7.125   0.365  -0.412  1.00 64.12
ATOM    187  HN  VAL    13      -6.544  -0.236  -0.979  1.00  0.00
ATOM    188  CA  VAL    13      -6.521   1.536   0.199  1.00 41.30
ATOM    189  HA  VAL    13      -7.285   2.035   0.796  1.00  0.00
ATOM    190  CB  VAL    13      -5.340   1.166   1.121  1.00 62.24
ATOM    191  HB  VAL    13      -4.903   2.090   1.500  1.00  0.00
ATOM    192  CG1 VAL    13      -5.810   0.344   2.308  1.00 31.14
ATOM    193 1HG1 VAL    13      -4.965   0.114   2.957  1.00  0.00
ATOM    194 2HG1 VAL    13      -6.553   0.911   2.869  1.00  0.00
ATOM    195 3HG1 VAL    13      -6.255  -0.585   1.951  1.00  0.00
ATOM    196  CG2 VAL    13      -4.269   0.420   0.344  1.00  1.13
ATOM    197 1HG2 VAL    13      -3.430   0.189   1.000  1.00  0.00
ATOM    198 2HG2 VAL    13      -4.686  -0.506  -0.050  1.00  0.00
ATOM    199 3HG2 VAL    13      -3.921   1.042  -0.482  1.00  0.00
ATOM    200  C   VAL    13      -6.022   2.500  -0.866  1.00 61.23
ATOM    201  O   VAL    13      -5.900   2.144  -2.036  1.00 43.41
ATOM    202  N   LYS    14      -5.745   3.721  -0.452  1.00 54.14
ATOM    203  HN  LYS    14      -5.945   3.983   0.502  1.00  0.00
ATOM    204  CA  LYS    14      -5.155   4.717  -1.328  1.00 51.51
ATOM    205  HA  LYS    14      -4.765   4.211  -2.211  1.00  0.00
ATOM    206  CB  LYS    14      -6.208   5.727  -1.778  1.00 14.21
ATOM    207 2HB  LYS    14      -6.942   5.841  -0.981  1.00  0.00
ATOM    208 3HB  LYS    14      -5.716   6.684  -1.959  1.00  0.00
ATOM    209  CG  LYS    14      -6.932   5.308  -3.046  1.00 34.22
ATOM    210 2HG  LYS    14      -6.291   5.518  -3.903  1.00  0.00
ATOM    211 3HG  LYS    14      -7.136   4.239  -2.998  1.00  0.00
ATOM    212  CD  LYS    14      -8.243   6.050  -3.222  1.00 32.42
ATOM    213 2HD  LYS    14      -8.659   5.803  -4.199  1.00  0.00
ATOM    214 3HD  LYS    14      -8.934   5.733  -2.442  1.00  0.00
ATOM    215  CE  LYS    14      -8.062   7.556  -3.134  1.00 65.41
ATOM    216 2HE  LYS    14      -7.710   7.813  -2.135  1.00  0.00
ATOM    217 3HE  LYS    14      -7.317   7.867  -3.867  1.00  0.00
ATOM    218  NZ  LYS    14      -9.330   8.278  -3.400  1.00 21.43
ATOM    219 1HZ  LYS    14      -9.175   9.274  -3.334  1.00  0.00
ATOM    220 2HZ  LYS    14      -9.657   8.051  -4.328  1.00  0.00
ATOM    221 3HZ  LYS    14     -10.023   8.001  -2.721  1.00  0.00
ATOM    222  C   LYS    14      -4.006   5.413  -0.624  1.00 53.31
ATOM    223  O   LYS    14      -4.100   5.736   0.560  1.00 40.05
ATOM    224  N   VAL    15      -2.921   5.620  -1.351  1.00 31.31
ATOM    225  HN  VAL    15      -2.912   5.364  -2.328  1.00  0.00
ATOM    226  CA  VAL    15      -1.723   6.214  -0.779  1.00 74.25
ATOM    227  HA  VAL    15      -1.564   5.774   0.205  1.00  0.00
ATOM    228  CB  VAL    15      -0.481   5.931  -1.651  1.00 55.30
ATOM    229  HB  VAL    15      -0.611   6.440  -2.606  1.00  0.00
ATOM    230  CG1 VAL    15       0.778   6.475  -0.991  1.00 60.13
ATOM    231 1HG1 VAL    15       1.641   6.287  -1.630  1.00  0.00
ATOM    232 2HG1 VAL    15       0.671   7.549  -0.836  1.00  0.00
ATOM    233 3HG1 VAL    15       0.926   5.982  -0.030  1.00  0.00
ATOM    234  CG2 VAL    15      -0.345   4.442  -1.921  1.00  4.15
ATOM    235 1HG2 VAL    15       0.522   4.260  -2.557  1.00  0.00
ATOM    236 2HG2 VAL    15      -0.218   3.913  -0.977  1.00  0.00
ATOM    237 3HG2 VAL    15      -1.243   4.082  -2.422  1.00  0.00
ATOM    238  C   VAL    15      -1.890   7.716  -0.621  1.00  1.34
ATOM    239  O   VAL    15      -2.316   8.401  -1.552  1.00 64.13
ATOM    240  N   VAL    16      -1.568   8.222   0.556  1.00 40.44
ATOM    241  HN  VAL    16      -1.280   7.613   1.309  1.00  0.00
ATOM    242  CA  VAL    16      -1.618   9.653   0.797  1.00 52.11
ATOM    243  HA  VAL    16      -1.981  10.122  -0.118  1.00  0.00
ATOM    244  CB  VAL    16      -2.600  10.025   1.935  1.00 74.41
ATOM    245  HB  VAL    16      -2.405  11.057   2.229  1.00  0.00
ATOM    246  CG1 VAL    16      -4.034   9.925   1.446  1.00 32.42
ATOM    247 1HG1 VAL    16      -4.717  10.214   2.244  1.00  0.00
ATOM    248 2HG1 VAL    16      -4.173  10.590   0.593  1.00  0.00
ATOM    249 3HG1 VAL    16      -4.243   8.899   1.144  1.00  0.00
ATOM    250  CG2 VAL    16      -2.406   9.136   3.156  1.00 60.05
ATOM    251 1HG2 VAL    16      -3.096   9.432   3.946  1.00  0.00
ATOM    252 2HG2 VAL    16      -2.595   8.099   2.881  1.00  0.00
ATOM    253 3HG2 VAL    16      -1.382   9.235   3.516  1.00  0.00
ATOM    254  C   VAL    16      -0.230  10.206   1.086  1.00  3.43
ATOM    255  O   VAL    16       0.258  11.073   0.364  1.00 72.51
ATOM    256  N   LYS    17       0.420   9.684   2.111  1.00 33.10
ATOM    257  HN  LYS    17      -0.011   8.959   2.665  1.00  0.00
ATOM    258  CA  LYS    17       1.756  10.131   2.468  1.00 73.35
ATOM    259  HA  LYS    17       2.045  10.925   1.779  1.00  0.00
ATOM    260  CB  LYS    17       1.793  10.682   3.894  1.00 53.01
ATOM    261 2HB  LYS    17       1.381   9.926   4.562  1.00  0.00
ATOM    262 3HB  LYS    17       2.833  10.873   4.159  1.00  0.00
ATOM    263  CG  LYS    17       1.009  11.969   4.091  1.00 34.34
ATOM    264 2HG  LYS    17       1.380  12.723   3.395  1.00  0.00
ATOM    265 3HG  LYS    17      -0.045  11.779   3.892  1.00  0.00
ATOM    266  CD  LYS    17       1.162  12.485   5.510  1.00 73.01
ATOM    267 2HD  LYS    17       0.785  11.732   6.202  1.00  0.00
ATOM    268 3HD  LYS    17       2.219  12.664   5.708  1.00  0.00
ATOM    269  CE  LYS    17       0.397  13.778   5.726  1.00 72.44
ATOM    270 2HE  LYS    17       0.783  14.537   5.044  1.00  0.00
ATOM    271 3HE  LYS    17      -0.657  13.606   5.511  1.00  0.00
ATOM    272  NZ  LYS    17       0.532  14.270   7.122  1.00 74.42
ATOM    273 1HZ  LYS    17       0.013  15.130   7.232  1.00  0.00
ATOM    274 2HZ  LYS    17       0.170  13.576   7.759  1.00  0.00
ATOM    275 3HZ  LYS    17       1.507  14.439   7.326  1.00  0.00
ATOM    276  C   LYS    17       2.750   8.992   2.350  1.00 74.25
ATOM    277  O   LYS    17       2.376   7.820   2.348  1.00 52.02
ATOM    278  N   LEU    18       4.017   9.343   2.254  1.00 42.21
ATOM    279  HN  LEU    18       4.264  10.322   2.204  1.00  0.00
ATOM    280  CA  LEU    18       5.081   8.363   2.217  1.00 13.22
ATOM    281  HA  LEU    18       4.671   7.391   2.491  1.00  0.00
ATOM    282  CB  LEU    18       5.677   8.265   0.810  1.00 61.32
ATOM    283 2HB  LEU    18       5.975   9.267   0.499  1.00  0.00
ATOM    284 3HB  LEU    18       6.557   7.624   0.860  1.00  0.00
ATOM    285  CG  LEU    18       4.738   7.698  -0.258  1.00 65.15
ATOM    286  HG  LEU    18       3.824   8.292  -0.268  1.00  0.00
ATOM    287  CD1 LEU    18       5.386   7.783  -1.627  1.00 22.25
ATOM    288 1HD1 LEU    18       4.704   7.393  -2.382  1.00  0.00
ATOM    289 2HD1 LEU    18       5.619   8.824  -1.854  1.00  0.00
ATOM    290 3HD1 LEU    18       6.305   7.197  -1.631  1.00  0.00
ATOM    291  CD2 LEU    18       4.378   6.256   0.065  1.00 71.20
ATOM    292 1HD2 LEU    18       3.697   5.869  -0.693  1.00  0.00
ATOM    293 2HD2 LEU    18       5.285   5.651   0.080  1.00  0.00
ATOM    294 3HD2 LEU    18       3.896   6.213   1.041  1.00  0.00
ATOM    295  C   LEU    18       6.152   8.749   3.221  1.00 42.33
ATOM    296  O   LEU    18       6.836   9.754   3.048  1.00 73.24
ATOM    297  N   HIS    19       6.265   7.978   4.287  1.00 41.13
ATOM    298  HN  HIS    19       5.664   7.175   4.397  1.00  0.00
ATOM    299  CA  HIS    19       7.248   8.262   5.321  1.00 64.44
ATOM    300  HA  HIS    19       7.383   9.343   5.380  1.00  0.00
ATOM    301  CB  HIS    19       6.772   7.752   6.689  1.00 21.33
ATOM    302 2HB  HIS    19       6.602   6.678   6.615  1.00  0.00
ATOM    303 3HB  HIS    19       7.562   7.936   7.418  1.00  0.00
ATOM    304  CG  HIS    19       5.512   8.397   7.186  1.00 62.22
ATOM    305  ND1 HIS    19       5.494   9.362   8.169  1.00 53.41
ATOM    306  CD2 HIS    19       4.217   8.192   6.844  1.00 31.35
ATOM    307 1HD  HIS    19       6.309   9.737   8.634  1.00  0.00
ATOM    308  CE1 HIS    19       4.247   9.721   8.409  1.00 52.24
ATOM    309  NE2 HIS    19       3.450   9.027   7.619  1.00 64.53
ATOM    310 2HD  HIS    19       3.855   7.500   6.099  1.00  0.00
ATOM    311 1HE  HIS    19       3.932  10.460   9.131  1.00  0.00
ATOM    312 2HE  HIS    19       2.443   9.098   7.589  1.00  0.00
ATOM    313  C   HIS    19       8.580   7.618   4.964  1.00 43.41
ATOM    314  O   HIS    19       8.642   6.745   4.098  1.00 51.35
ATOM    315  N   GLY    20       9.643   8.056   5.620  1.00  2.20
ATOM    316  HN  GLY    20       9.559   8.812   6.285  1.00  0.00
ATOM    317  CA  GLY    20      10.943   7.462   5.397  1.00 72.45
ATOM    318 1HA  GLY    20      11.172   6.798   6.231  1.00  0.00
ATOM    319 2HA  GLY    20      10.909   6.884   4.474  1.00  0.00
ATOM    320  C   GLY    20      12.042   8.495   5.283  1.00 54.34
ATOM    321  O   GLY    20      11.782   9.697   5.320  1.00 10.33
ATOM    322  N   THR    21      13.267   8.020   5.119  1.00 54.33
ATOM    323  HN  THR    21      13.405   7.022   5.054  1.00  0.00
ATOM    324  CA  THR    21      14.442   8.881   5.026  1.00  4.12
ATOM    325  HA  THR    21      14.319   9.703   5.731  1.00  0.00
ATOM    326  CB  THR    21      15.700   8.083   5.402  1.00 61.42
ATOM    327  HB  THR    21      16.579   8.634   5.067  1.00  0.00
ATOM    328  OG1 THR    21      15.667   6.809   4.743  1.00 21.03
ATOM    329 1HG  THR    21      16.465   6.326   4.972  1.00  0.00
ATOM    330  CG2 THR    21      15.792   7.884   6.909  1.00 20.30
ATOM    331 1HG2 THR    21      16.693   7.322   7.154  1.00  0.00
ATOM    332 2HG2 THR    21      15.829   8.856   7.401  1.00  0.00
ATOM    333 3HG2 THR    21      14.918   7.334   7.255  1.00  0.00
ATOM    334  C   THR    21      14.623   9.464   3.621  1.00 30.23
ATOM    335  O   THR    21      15.746   9.711   3.182  1.00 75.23
ATOM    336  N   GLY    22      13.518   9.692   2.923  1.00 32.25
ATOM    337  HN  GLY    22      12.614   9.471   3.314  1.00  0.00
ATOM    338  CA  GLY    22      13.583  10.262   1.589  1.00 22.11
ATOM    339 1HA  GLY    22      12.614  10.698   1.348  1.00  0.00
ATOM    340 2HA  GLY    22      14.343  11.044   1.580  1.00  0.00
ATOM    341  C   GLY    22      13.931   9.233   0.531  1.00 74.52
ATOM    342  O   GLY    22      13.140   8.977  -0.377  1.00 73.21
ATOM    343  N   ALA    23      15.110   8.634   0.661  1.00 20.51
ATOM    344  HN  ALA    23      15.708   8.875   1.439  1.00  0.00
ATOM    345  CA  ALA    23      15.584   7.630  -0.287  1.00 74.44
ATOM    346  HA  ALA    23      15.664   8.101  -1.267  1.00  0.00
ATOM    347  CB  ALA    23      16.961   7.132   0.122  1.00 64.42
ATOM    348 1HB  ALA    23      17.322   6.407  -0.607  1.00  0.00
ATOM    349 2HB  ALA    23      17.653   7.974   0.167  1.00  0.00
ATOM    350 3HB  ALA    23      16.900   6.660   1.102  1.00  0.00
ATOM    351  C   ALA    23      14.605   6.465  -0.391  1.00 45.31
ATOM    352  O   ALA    23      14.386   5.915  -1.473  1.00 25.24
ATOM    353  N   LEU    24      14.015   6.101   0.741  1.00 14.13
ATOM    354  HN  LEU    24      14.259   6.564   1.605  1.00  0.00
ATOM    355  CA  LEU    24      13.015   5.043   0.780  1.00 61.23
ATOM    356  HA  LEU    24      13.452   4.138   0.358  1.00  0.00
ATOM    357  CB  LEU    24      12.599   4.760   2.230  1.00 63.32
ATOM    358 2HB  LEU    24      13.497   4.510   2.794  1.00  0.00
ATOM    359 3HB  LEU    24      12.156   5.670   2.636  1.00  0.00
ATOM    360  CG  LEU    24      11.592   3.621   2.414  1.00 32.01
ATOM    361  HG  LEU    24      10.713   3.839   1.807  1.00  0.00
ATOM    362  CD1 LEU    24      12.184   2.300   1.942  1.00 12.44
ATOM    363 1HD1 LEU    24      11.450   1.503   2.059  1.00  0.00
ATOM    364 2HD1 LEU    24      12.462   2.383   0.891  1.00  0.00
ATOM    365 3HD1 LEU    24      13.069   2.067   2.534  1.00  0.00
ATOM    366  CD2 LEU    24      11.159   3.523   3.866  1.00 51.42
ATOM    367 1HD2 LEU    24      10.427   2.724   3.980  1.00  0.00
ATOM    368 2HD2 LEU    24      12.027   3.309   4.489  1.00  0.00
ATOM    369 3HD2 LEU    24      10.714   4.469   4.176  1.00  0.00
ATOM    370  C   LEU    24      11.799   5.439  -0.057  1.00  1.54
ATOM    371  O   LEU    24      11.283   4.637  -0.835  1.00  3.43
ATOM    372  N   LYS    25      11.374   6.692   0.088  1.00 73.40
ATOM    373  HN  LYS    25      11.853   7.311   0.726  1.00  0.00
ATOM    374  CA  LYS    25      10.227   7.213  -0.650  1.00 74.22
ATOM    375  HA  LYS    25       9.353   6.610  -0.405  1.00  0.00
ATOM    376  CB  LYS    25       9.951   8.670  -0.266  1.00 62.33
ATOM    377 2HB  LYS    25      10.752   9.288  -0.673  1.00  0.00
ATOM    378 3HB  LYS    25       9.002   8.967  -0.711  1.00  0.00
ATOM    379  CG  LYS    25       9.873   8.915   1.232  1.00 12.02
ATOM    380 2HG  LYS    25       9.042   8.343   1.643  1.00  0.00
ATOM    381 3HG  LYS    25      10.804   8.589   1.695  1.00  0.00
ATOM    382  CD  LYS    25       9.658  10.389   1.535  1.00 54.14
ATOM    383 2HD  LYS    25      10.428  10.971   1.028  1.00  0.00
ATOM    384 3HD  LYS    25       8.677  10.687   1.166  1.00  0.00
ATOM    385  CE  LYS    25       9.730  10.668   3.025  1.00 61.02
ATOM    386 2HE  LYS    25       8.994  10.049   3.536  1.00  0.00
ATOM    387 3HE  LYS    25      10.727  10.411   3.385  1.00  0.00
ATOM    388  NZ  LYS    25       9.459  12.095   3.337  1.00 24.04
ATOM    389 1HZ  LYS    25       9.515  12.244   4.334  1.00  0.00
ATOM    390 2HZ  LYS    25      10.143  12.676   2.873  1.00  0.00
ATOM    391 3HZ  LYS    25       8.534  12.340   3.013  1.00  0.00
ATOM    392  C   LYS    25      10.485   7.132  -2.149  1.00 70.34
ATOM    393  O   LYS    25       9.607   6.757  -2.924  1.00 31.33
ATOM    394  N   ARG    26      11.706   7.480  -2.540  1.00 33.41
ATOM    395  HN  ARG    26      12.385   7.772  -1.852  1.00  0.00
ATOM    396  CA  ARG    26      12.112   7.459  -3.940  1.00 75.34
ATOM    397  HA  ARG    26      11.446   8.111  -4.505  1.00  0.00
ATOM    398  CB  ARG    26      13.544   7.987  -4.064  1.00 32.11
ATOM    399 2HB  ARG    26      13.577   8.987  -3.630  1.00  0.00
ATOM    400 3HB  ARG    26      14.201   7.324  -3.501  1.00  0.00
ATOM    401  CG  ARG    26      14.066   8.072  -5.490  1.00 13.24
ATOM    402 2HG  ARG    26      15.118   8.359  -5.464  1.00  0.00
ATOM    403 3HG  ARG    26      13.968   7.094  -5.961  1.00  0.00
ATOM    404  CD  ARG    26      13.299   9.092  -6.313  1.00 22.45
ATOM    405 2HD  ARG    26      12.303   8.702  -6.523  1.00  0.00
ATOM    406 3HD  ARG    26      13.209  10.015  -5.740  1.00  0.00
ATOM    407  NE  ARG    26      13.972   9.382  -7.579  1.00 22.31
ATOM    408  HE  ARG    26      14.692   8.740  -7.879  1.00  0.00
ATOM    409  CZ  ARG    26      13.691  10.432  -8.347  1.00 31.33
ATOM    410  NH1 ARG    26      12.691  11.244  -8.027  1.00 22.21
ATOM    411 1HH1 ARG    26      12.477  12.037  -8.615  1.00  0.00
ATOM    412 2HH1 ARG    26      12.145  11.069  -7.196  1.00  0.00
ATOM    413  NH2 ARG    26      14.399  10.655  -9.444  1.00 51.44
ATOM    414 1HH2 ARG    26      14.184  11.449 -10.031  1.00  0.00
ATOM    415 2HH2 ARG    26      15.154  10.032  -9.694  1.00  0.00
ATOM    416  C   ARG    26      12.016   6.050  -4.512  1.00 35.02
ATOM    417  O   ARG    26      11.545   5.859  -5.629  1.00 22.34
ATOM    418  N   ARG    27      12.457   5.069  -3.735  1.00 44.44
ATOM    419  HN  ARG    27      12.856   5.284  -2.832  1.00  0.00
ATOM    420  CA  ARG    27      12.385   3.673  -4.149  1.00 12.51
ATOM    421  HA  ARG    27      12.882   3.573  -5.114  1.00  0.00
ATOM    422  CB  ARG    27      13.107   2.783  -3.131  1.00 31.11
ATOM    423 2HB  ARG    27      14.164   3.050  -3.131  1.00  0.00
ATOM    424 3HB  ARG    27      12.683   2.976  -2.146  1.00  0.00
ATOM    425  CG  ARG    27      12.989   1.294  -3.420  1.00 32.35
ATOM    426 2HG  ARG    27      11.940   1.005  -3.366  1.00  0.00
ATOM    427 3HG  ARG    27      13.369   1.097  -4.423  1.00  0.00
ATOM    428  CD  ARG    27      13.781   0.468  -2.420  1.00 60.11
ATOM    429 2HD  ARG    27      14.843   0.677  -2.551  1.00  0.00
ATOM    430 3HD  ARG    27      13.482   0.753  -1.411  1.00  0.00
ATOM    431  NE  ARG    27      13.556  -0.964  -2.594  1.00  3.31
ATOM    432  HE  ARG    27      12.608  -1.263  -2.773  1.00  0.00
ATOM    433  CZ  ARG    27      14.515  -1.886  -2.532  1.00 50.51
ATOM    434  NH1 ARG    27      15.778  -1.533  -2.323  1.00 44.43
ATOM    435 1HH1 ARG    27      16.501  -2.237  -2.277  1.00  0.00
ATOM    436 2HH1 ARG    27      16.017  -0.558  -2.210  1.00  0.00
ATOM    437  NH2 ARG    27      14.207  -3.166  -2.680  1.00 61.44
ATOM    438 1HH2 ARG    27      14.932  -3.868  -2.634  1.00  0.00
ATOM    439 2HH2 ARG    27      13.248  -3.439  -2.840  1.00  0.00
ATOM    440  C   ARG    27      10.929   3.241  -4.302  1.00 45.42
ATOM    441  O   ARG    27      10.558   2.608  -5.291  1.00  0.02
ATOM    442  N   ILE    28      10.112   3.600  -3.319  1.00 44.23
ATOM    443  HN  ILE    28      10.482   4.097  -2.521  1.00  0.00
ATOM    444  CA  ILE    28       8.687   3.305  -3.346  1.00  2.21
ATOM    445  HA  ILE    28       8.567   2.223  -3.392  1.00  0.00
ATOM    446  CB  ILE    28       8.003   3.822  -2.059  1.00  5.03
ATOM    447  HB  ILE    28       8.209   4.889  -1.966  1.00  0.00
ATOM    448  CG2 ILE    28       6.496   3.631  -2.123  1.00 64.14
ATOM    449 1HG2 ILE    28       6.035   4.020  -1.215  1.00  0.00
ATOM    450 2HG2 ILE    28       6.100   4.166  -2.986  1.00  0.00
ATOM    451 3HG2 ILE    28       6.269   2.570  -2.218  1.00  0.00
ATOM    452  CG1 ILE    28       8.581   3.106  -0.835  1.00 34.04
ATOM    453 2HG1 ILE    28       8.331   2.048  -0.907  1.00  0.00
ATOM    454 3HG1 ILE    28       9.665   3.226  -0.848  1.00  0.00
ATOM    455  CD1 ILE    28       8.059   3.631   0.487  1.00 51.31
ATOM    456 1HD1 ILE    28       8.504   3.085   1.318  1.00  0.00
ATOM    457 2HD1 ILE    28       8.311   4.688   0.579  1.00  0.00
ATOM    458 3HD1 ILE    28       6.976   3.512   0.519  1.00  0.00
ATOM    459  C   ILE    28       8.017   3.920  -4.578  1.00 52.21
ATOM    460  O   ILE    28       7.316   3.230  -5.323  1.00 25.22
ATOM    461  N   MET    29       8.265   5.207  -4.799  1.00 11.03
ATOM    462  HN  MET    29       8.898   5.706  -4.190  1.00  0.00
ATOM    463  CA  MET    29       7.646   5.938  -5.905  1.00 64.11
ATOM    464  HA  MET    29       6.571   5.767  -5.858  1.00  0.00
ATOM    465  CB  MET    29       7.902   7.441  -5.774  1.00 73.02
ATOM    466 2HB  MET    29       8.976   7.600  -5.671  1.00  0.00
ATOM    467 3HB  MET    29       7.549   7.931  -6.682  1.00  0.00
ATOM    468  CG  MET    29       7.205   8.079  -4.583  1.00 55.12
ATOM    469 2HG  MET    29       6.136   7.880  -4.654  1.00  0.00
ATOM    470 3HG  MET    29       7.585   7.625  -3.668  1.00  0.00
ATOM    471  SD  MET    29       7.457   9.864  -4.491  1.00 72.11
ATOM    472  CE  MET    29       9.242   9.944  -4.348  1.00 32.31
ATOM    473 1HE  MET    29       9.563  10.984  -4.281  1.00  0.00
ATOM    474 2HE  MET    29       9.558   9.411  -3.452  1.00  0.00
ATOM    475 3HE  MET    29       9.697   9.483  -5.225  1.00  0.00
ATOM    476  C   MET    29       8.151   5.448  -7.255  1.00 70.22
ATOM    477  O   MET    29       7.423   5.487  -8.248  1.00 54.45
ATOM    478  N   ASP    30       9.393   4.986  -7.286  1.00 72.31
ATOM    479  HN  ASP    30       9.934   4.946  -6.434  1.00  0.00
ATOM    480  CA  ASP    30      10.016   4.528  -8.525  1.00 42.24
ATOM    481  HA  ASP    30       9.899   5.308  -9.278  1.00  0.00
ATOM    482  CB  ASP    30      11.510   4.276  -8.303  1.00 64.10
ATOM    483 2HB  ASP    30      11.918   5.094  -7.709  1.00  0.00
ATOM    484 3HB  ASP    30      11.630   3.341  -7.757  1.00  0.00
ATOM    485  CG  ASP    30      12.288   4.183  -9.599  1.00  0.52
ATOM    486  OD1 ASP    30      12.325   3.097 -10.207  1.00 34.42
ATOM    487  OD2 ASP    30      12.880   5.204 -10.012  1.00 31.43
ATOM    488 2HD  ASP    30      13.356   5.076 -10.836  1.00  0.00
ATOM    489  C   ASP    30       9.346   3.253  -9.030  1.00  2.22
ATOM    490  O   ASP    30       9.196   3.049 -10.237  1.00 50.42
ATOM    491  N   MET    31       8.927   2.407  -8.095  1.00 23.14
ATOM    492  HN  MET    31       9.043   2.641  -7.120  1.00  0.00
ATOM    493  CA  MET    31       8.298   1.134  -8.434  1.00 53.13
ATOM    494  HA  MET    31       8.886   0.665  -9.224  1.00  0.00
ATOM    495  CB  MET    31       8.279   0.205  -7.219  1.00 21.22
ATOM    496 2HB  MET    31       7.761   0.714  -6.406  1.00  0.00
ATOM    497 3HB  MET    31       7.734  -0.699  -7.488  1.00  0.00
ATOM    498  CG  MET    31       9.658  -0.197  -6.730  1.00 14.11
ATOM    499 2HG  MET    31      10.172  -0.737  -7.525  1.00  0.00
ATOM    500 3HG  MET    31      10.227   0.703  -6.495  1.00  0.00
ATOM    501  SD  MET    31       9.589  -1.245  -5.261  1.00 33.41
ATOM    502  CE  MET    31       8.790  -0.144  -4.094  1.00 40.45
ATOM    503 1HE  MET    31       8.673  -0.642  -3.132  1.00  0.00
ATOM    504 2HE  MET    31       9.400   0.751  -3.964  1.00  0.00
ATOM    505 3HE  MET    31       7.809   0.138  -4.476  1.00  0.00
ATOM    506  C   MET    31       6.874   1.336  -8.942  1.00 30.23
ATOM    507  O   MET    31       6.298   0.443  -9.563  1.00  3.40
ATOM    508  N   GLY    32       6.306   2.503  -8.668  1.00 21.22
ATOM    509  HN  GLY    32       6.813   3.211  -8.155  1.00  0.00
ATOM    510  CA  GLY    32       4.950   2.785  -9.099  1.00  3.34
ATOM    511 1HA  GLY    32       4.975   3.601  -9.822  1.00  0.00
ATOM    512 2HA  GLY    32       4.541   1.894  -9.575  1.00  0.00
ATOM    513  C   GLY    32       4.051   3.180  -7.947  1.00 64.11
ATOM    514  O   GLY    32       3.007   3.807  -8.151  1.00 43.22
ATOM    515  N   ILE    33       4.459   2.820  -6.733  1.00 63.23
ATOM    516  HN  ILE    33       5.320   2.304  -6.623  1.00  0.00
ATOM    517  CA  ILE    33       3.691   3.155  -5.540  1.00 55.11
ATOM    518  HA  ILE    33       2.652   2.875  -5.711  1.00  0.00
ATOM    519  CB  ILE    33       4.204   2.405  -4.292  1.00  3.13
ATOM    520  HB  ILE    33       5.160   2.840  -3.998  1.00  0.00
ATOM    521  CG2 ILE    33       3.223   2.571  -3.138  1.00 72.10
ATOM    522 1HG2 ILE    33       3.605   2.060  -2.255  1.00  0.00
ATOM    523 2HG2 ILE    33       3.100   3.632  -2.917  1.00  0.00
ATOM    524 3HG2 ILE    33       2.260   2.144  -3.417  1.00  0.00
ATOM    525  CG1 ILE    33       4.425   0.918  -4.599  1.00 61.44
ATOM    526 2HG1 ILE    33       5.148   0.840  -5.411  1.00  0.00
ATOM    527 3HG1 ILE    33       4.829   0.441  -3.706  1.00  0.00
ATOM    528  CD1 ILE    33       3.170   0.175  -5.008  1.00 31.52
ATOM    529 1HD1 ILE    33       3.393  -0.872  -5.213  1.00  0.00
ATOM    530 2HD1 ILE    33       2.439   0.233  -4.202  1.00  0.00
ATOM    531 3HD1 ILE    33       2.757   0.634  -5.907  1.00  0.00
ATOM    532  C   ILE    33       3.770   4.657  -5.294  1.00 33.21
ATOM    533  O   ILE    33       4.781   5.170  -4.817  1.00 62.34
ATOM    534  N   THR    34       2.709   5.360  -5.635  1.00 25.14
ATOM    535  HN  THR    34       1.854   4.892  -5.898  1.00  0.00
ATOM    536  CA  THR    34       2.738   6.808  -5.642  1.00 12.13
ATOM    537  HA  THR    34       3.684   7.128  -5.204  1.00  0.00
ATOM    538  CB  THR    34       2.672   7.320  -7.091  1.00  4.45
ATOM    539  HB  THR    34       2.235   8.319  -7.092  1.00  0.00
ATOM    540  OG1 THR    34       1.844   6.445  -7.875  1.00  0.23
ATOM    541 1HG  THR    34       1.801   6.785  -8.772  1.00  0.00
ATOM    542  CG2 THR    34       4.063   7.392  -7.704  1.00 51.22
ATOM    543 1HG2 THR    34       3.999   7.763  -8.727  1.00  0.00
ATOM    544 2HG2 THR    34       4.684   8.067  -7.114  1.00  0.00
ATOM    545 3HG2 THR    34       4.509   6.398  -7.708  1.00  0.00
ATOM    546  C   THR    34       1.605   7.409  -4.819  1.00 63.04
ATOM    547  O   THR    34       0.579   6.769  -4.591  1.00 72.21
ATOM    548  N   ARG    35       1.806   8.637  -4.362  1.00 70.22
ATOM    549  HN  ARG    35       2.674   9.112  -4.564  1.00  0.00
ATOM    550  CA  ARG    35       0.805   9.333  -3.567  1.00 21.30
ATOM    551  HA  ARG    35       0.503   8.682  -2.747  1.00  0.00
ATOM    552  CB  ARG    35       1.396  10.617  -2.978  1.00 35.44
ATOM    553 2HB  ARG    35       1.725  11.254  -3.800  1.00  0.00
ATOM    554 3HB  ARG    35       0.617  11.128  -2.412  1.00  0.00
ATOM    555  CG  ARG    35       2.581  10.373  -2.053  1.00 21.51
ATOM    556 2HG  ARG    35       2.245   9.789  -1.197  1.00  0.00
ATOM    557 3HG  ARG    35       3.344   9.816  -2.597  1.00  0.00
ATOM    558  CD  ARG    35       3.185  11.676  -1.553  1.00 62.41
ATOM    559 2HD  ARG    35       4.070  11.449  -0.958  1.00  0.00
ATOM    560 3HD  ARG    35       3.477  12.282  -2.411  1.00  0.00
ATOM    561  NE  ARG    35       2.248  12.441  -0.732  1.00 44.11
ATOM    562  HE  ARG    35       1.453  11.945  -0.356  1.00  0.00
ATOM    563  CZ  ARG    35       2.381  13.737  -0.455  1.00 13.24
ATOM    564  NH1 ARG    35       3.423  14.417  -0.922  1.00 23.11
ATOM    565 1HH1 ARG    35       3.524  15.399  -0.708  1.00  0.00
ATOM    566 2HH1 ARG    35       4.115  13.952  -1.492  1.00  0.00
ATOM    567  NH2 ARG    35       1.479  14.352   0.301  1.00 72.23
ATOM    568 1HH2 ARG    35       1.583  15.334   0.514  1.00  0.00
ATOM    569 2HH2 ARG    35       0.690  13.838   0.664  1.00  0.00
ATOM    570  C   ARG    35      -0.422   9.648  -4.415  1.00 73.33
ATOM    571  O   ARG    35      -0.386  10.523  -5.282  1.00 41.54
ATOM    572  N   GLY    36      -1.497   8.912  -4.177  1.00 30.55
ATOM    573  HN  GLY    36      -1.479   8.204  -3.457  1.00  0.00
ATOM    574  CA  GLY    36      -2.714   9.102  -4.936  1.00 74.03
ATOM    575 1HA  GLY    36      -3.494   9.458  -4.263  1.00  0.00
ATOM    576 2HA  GLY    36      -2.532   9.853  -5.706  1.00  0.00
ATOM    577  C   GLY    36      -3.188   7.826  -5.601  1.00 15.42
ATOM    578  O   GLY    36      -4.382   7.663  -5.855  1.00 54.02
ATOM    579  N   CYS    37      -2.265   6.913  -5.880  1.00  1.00
ATOM    580  HN  CYS    37      -1.298   7.074  -5.638  1.00  0.00
ATOM    581  CA  CYS    37      -2.627   5.665  -6.538  1.00  3.31
ATOM    582  HA  CYS    37      -3.274   5.903  -7.383  1.00  0.00
ATOM    583  CB  CYS    37      -1.384   4.936  -7.069  1.00 30.24
ATOM    584 2HB  CYS    37      -1.722   4.109  -7.693  1.00  0.00
ATOM    585 3HB  CYS    37      -0.815   5.642  -7.675  1.00  0.00
ATOM    586  SG  CYS    37      -0.291   4.275  -5.788  1.00  4.05
ATOM    587  HG  CYS    37       0.626   3.744  -6.603  1.00  0.00
ATOM    588  C   CYS    37      -3.393   4.765  -5.578  1.00 25.11
ATOM    589  O   CYS    37      -3.124   4.750  -4.371  1.00 71.03
ATOM    590  N   GLU    38      -4.357   4.035  -6.116  1.00 43.32
ATOM    591  HN  GLU    38      -4.556   4.116  -7.103  1.00  0.00
ATOM    592  CA  GLU    38      -5.146   3.110  -5.325  1.00  1.43
ATOM    593  HA  GLU    38      -5.216   3.496  -4.308  1.00  0.00
ATOM    594  CB  GLU    38      -6.561   2.992  -5.899  1.00 52.23
ATOM    595 2HB  GLU    38      -7.131   2.308  -5.271  1.00  0.00
ATOM    596 3HB  GLU    38      -7.025   3.978  -5.877  1.00  0.00
ATOM    597  CG  GLU    38      -6.598   2.477  -7.326  1.00 14.30
ATOM    598 2HG  GLU    38      -5.896   3.056  -7.927  1.00  0.00
ATOM    599 3HG  GLU    38      -6.294   1.431  -7.330  1.00  0.00
ATOM    600  CD  GLU    38      -7.974   2.587  -7.944  1.00 25.15
ATOM    601  OE1 GLU    38      -8.745   1.608  -7.881  1.00 65.40
ATOM    602  OE2 GLU    38      -8.290   3.663  -8.502  1.00 43.44
ATOM    603 2HE  GLU    38      -9.175   3.666  -8.874  1.00  0.00
ATOM    604  C   GLU    38      -4.465   1.751  -5.285  1.00  3.11
ATOM    605  O   GLU    38      -3.884   1.305  -6.279  1.00 71.51
ATOM    606  N   ILE    39      -4.520   1.108  -4.134  1.00 33.21
ATOM    607  HN  ILE    39      -5.015   1.516  -3.354  1.00  0.00
ATOM    608  CA  ILE    39      -3.887  -0.179  -3.950  1.00  2.24
ATOM    609  HA  ILE    39      -3.491  -0.503  -4.913  1.00  0.00
ATOM    610  CB  ILE    39      -2.723  -0.103  -2.938  1.00 41.43
ATOM    611  HB  ILE    39      -3.119   0.242  -1.983  1.00  0.00
ATOM    612  CG2 ILE    39      -2.109  -1.481  -2.735  1.00 50.33
ATOM    613 1HG2 ILE    39      -1.304  -1.420  -2.003  1.00  0.00
ATOM    614 2HG2 ILE    39      -2.874  -2.169  -2.376  1.00  0.00
ATOM    615 3HG2 ILE    39      -1.710  -1.843  -3.682  1.00  0.00
ATOM    616  CG1 ILE    39      -1.661   0.896  -3.409  1.00 52.30
ATOM    617 2HG1 ILE    39      -1.313   0.590  -4.396  1.00  0.00
ATOM    618 3HG1 ILE    39      -2.121   1.882  -3.476  1.00  0.00
ATOM    619  CD1 ILE    39      -0.463   0.989  -2.487  1.00 54.01
ATOM    620 1HD1 ILE    39       0.259   1.711  -2.870  1.00  0.00
ATOM    621 2HD1 ILE    39      -0.793   1.306  -1.498  1.00  0.00
ATOM    622 3HD1 ILE    39       0.014   0.012  -2.416  1.00  0.00
ATOM    623  C   ILE    39      -4.903  -1.201  -3.465  1.00 44.01
ATOM    624  O   ILE    39      -5.476  -1.061  -2.381  1.00  1.54
ATOM    625  N   TYR    40      -5.141  -2.214  -4.279  1.00  3.30
ATOM    626  HN  TYR    40      -4.721  -2.235  -5.197  1.00  0.00
ATOM    627  CA  TYR    40      -6.003  -3.309  -3.883  1.00 63.32
ATOM    628  HA  TYR    40      -6.730  -2.941  -3.159  1.00  0.00
ATOM    629  CB  TYR    40      -6.755  -3.872  -5.092  1.00 45.44
ATOM    630 2HB  TYR    40      -7.108  -3.039  -5.700  1.00  0.00
ATOM    631 3HB  TYR    40      -6.062  -4.469  -5.685  1.00  0.00
ATOM    632  CG  TYR    40      -7.942  -4.736  -4.723  1.00 73.12
ATOM    633  CD1 TYR    40      -9.180  -4.163  -4.471  1.00 62.21
ATOM    634 1HD  TYR    40      -9.292  -3.091  -4.539  1.00  0.00
ATOM    635  CE1 TYR    40     -10.271  -4.938  -4.135  1.00  3.24
ATOM    636 1HE  TYR    40     -11.227  -4.474  -3.944  1.00  0.00
ATOM    637  CZ  TYR    40     -10.135  -6.306  -4.044  1.00 43.21
ATOM    638  CE2 TYR    40      -8.916  -6.902  -4.291  1.00 70.42
ATOM    639 2HE  TYR    40      -8.812  -7.974  -4.223  1.00  0.00
ATOM    640  CD2 TYR    40      -7.827  -6.119  -4.627  1.00 10.11
ATOM    641 2HD  TYR    40      -6.873  -6.588  -4.818  1.00  0.00
ATOM    642  OH  TYR    40     -11.226  -7.077  -3.711  1.00 44.11
ATOM    643  HH  TYR    40     -11.024  -8.015  -3.677  1.00  0.00
ATOM    644  C   TYR    40      -5.154  -4.390  -3.234  1.00 13.02
ATOM    645  O   TYR    40      -4.362  -5.053  -3.909  1.00 51.30
ATOM    646  N   ILE    41      -5.290  -4.538  -1.924  1.00 21.31
ATOM    647  HN  ILE    41      -5.957  -3.972  -1.419  1.00  0.00
ATOM    648  CA  ILE    41      -4.495  -5.508  -1.181  1.00 62.32
ATOM    649  HA  ILE    41      -3.448  -5.366  -1.450  1.00  0.00
ATOM    650  CB  ILE    41      -4.637  -5.328   0.349  1.00 20.44
ATOM    651  HB  ILE    41      -5.601  -5.731   0.657  1.00  0.00
ATOM    652  CG2 ILE    41      -3.533  -6.093   1.074  1.00  2.14
ATOM    653 1HG2 ILE    41      -3.652  -5.978   2.151  1.00  0.00
ATOM    654 2HG2 ILE    41      -3.593  -7.149   0.814  1.00  0.00
ATOM    655 3HG2 ILE    41      -2.562  -5.699   0.773  1.00  0.00
ATOM    656  CG1 ILE    41      -4.584  -3.843   0.731  1.00 64.40
ATOM    657 2HG1 ILE    41      -5.380  -3.323   0.198  1.00  0.00
ATOM    658 3HG1 ILE    41      -4.750  -3.759   1.805  1.00  0.00
ATOM    659  CD1 ILE    41      -3.270  -3.168   0.399  1.00 63.01
ATOM    660 1HD1 ILE    41      -3.293  -2.118   0.691  1.00  0.00
ATOM    661 2HD1 ILE    41      -2.463  -3.669   0.933  1.00  0.00
ATOM    662 3HD1 ILE    41      -3.092  -3.235  -0.674  1.00  0.00
ATOM    663  C   ILE    41      -4.919  -6.920  -1.568  1.00 13.20
ATOM    664  O   ILE    41      -6.043  -7.337  -1.286  1.00 12.23
ATOM    665  N   ARG    42      -4.018  -7.644  -2.216  1.00 23.12
ATOM    666  HN  ARG    42      -3.074  -7.298  -2.317  1.00  0.00
ATOM    667  CA  ARG    42      -4.347  -8.938  -2.797  1.00 33.32
ATOM    668  HA  ARG    42      -5.398  -8.926  -3.084  1.00  0.00
ATOM    669  CB  ARG    42      -3.499  -9.179  -4.053  1.00 51.44
ATOM    670 2HB  ARG    42      -2.452  -9.240  -3.756  1.00  0.00
ATOM    671 3HB  ARG    42      -3.806 -10.124  -4.501  1.00  0.00
ATOM    672  CG  ARG    42      -3.640  -8.082  -5.100  1.00 53.22
ATOM    673 2HG  ARG    42      -3.470  -7.116  -4.624  1.00  0.00
ATOM    674 3HG  ARG    42      -2.893  -8.239  -5.879  1.00  0.00
ATOM    675  CD  ARG    42      -5.020  -8.080  -5.736  1.00  0.31
ATOM    676 2HD  ARG    42      -5.770  -8.205  -4.955  1.00  0.00
ATOM    677 3HD  ARG    42      -5.178  -7.123  -6.235  1.00  0.00
ATOM    678  NE  ARG    42      -5.171  -9.154  -6.713  1.00 34.30
ATOM    679  HE  ARG    42      -4.334  -9.472  -7.180  1.00  0.00
ATOM    680  CZ  ARG    42      -6.331  -9.732  -7.021  1.00 35.42
ATOM    681  NH1 ARG    42      -7.449  -9.360  -6.411  1.00 62.03
ATOM    682 1HH1 ARG    42      -8.326  -9.801  -6.647  1.00  0.00
ATOM    683 2HH1 ARG    42      -7.423  -8.633  -5.710  1.00  0.00
ATOM    684  NH2 ARG    42      -6.371 -10.690  -7.939  1.00 63.43
ATOM    685 1HH2 ARG    42      -7.249 -11.130  -8.173  1.00  0.00
ATOM    686 2HH2 ARG    42      -5.522 -10.979  -8.404  1.00  0.00
ATOM    687  C   ARG    42      -4.132 -10.064  -1.789  1.00 23.04
ATOM    688  O   ARG    42      -5.055 -10.819  -1.484  1.00 30.54
ATOM    689  N   LYS    43      -2.924 -10.163  -1.259  1.00 21.21
ATOM    690  HN  LYS    43      -2.216  -9.477  -1.480  1.00  0.00
ATOM    691  CA  LYS    43      -2.583 -11.250  -0.353  1.00 23.34
ATOM    692  HA  LYS    43      -3.489 -11.562   0.166  1.00  0.00
ATOM    693  CB  LYS    43      -2.038 -12.441  -1.153  1.00 24.53
ATOM    694 2HB  LYS    43      -2.839 -12.821  -1.786  1.00  0.00
ATOM    695 3HB  LYS    43      -1.218 -12.085  -1.778  1.00  0.00
ATOM    696  CG  LYS    43      -1.521 -13.589  -0.299  1.00  2.03
ATOM    697 2HG  LYS    43      -1.134 -14.369  -0.955  1.00  0.00
ATOM    698 3HG  LYS    43      -0.718 -13.219   0.339  1.00  0.00
ATOM    699  CD  LYS    43      -2.612 -14.181   0.577  1.00 65.05
ATOM    700 2HD  LYS    43      -2.981 -13.411   1.255  1.00  0.00
ATOM    701 3HD  LYS    43      -3.427 -14.528  -0.057  1.00  0.00
ATOM    702  CE  LYS    43      -2.085 -15.348   1.392  1.00 31.24
ATOM    703 2HE  LYS    43      -1.771 -16.140   0.712  1.00  0.00
ATOM    704 3HE  LYS    43      -1.226 -15.013   1.973  1.00  0.00
ATOM    705  NZ  LYS    43      -3.111 -15.889   2.319  1.00 73.11
ATOM    706 1HZ  LYS    43      -2.725 -16.661   2.842  1.00  0.00
ATOM    707 2HZ  LYS    43      -3.402 -15.163   2.958  1.00  0.00
ATOM    708 3HZ  LYS    43      -3.908 -16.209   1.787  1.00  0.00
ATOM    709  C   LYS    43      -1.562 -10.798   0.684  1.00 65.14
ATOM    710  O   LYS    43      -0.491 -10.307   0.339  1.00 52.44
ATOM    711  N   VAL    44      -1.904 -10.951   1.953  1.00 34.22
ATOM    712  HN  VAL    44      -2.826 -11.288   2.190  1.00  0.00
ATOM    713  CA  VAL    44      -0.980 -10.644   3.030  1.00 11.25
ATOM    714  HA  VAL    44      -0.116 -10.132   2.606  1.00  0.00
ATOM    715  CB  VAL    44      -1.624  -9.729   4.095  1.00 33.34
ATOM    716  HB  VAL    44      -2.470 -10.260   4.531  1.00  0.00
ATOM    717  CG1 VAL    44      -0.638  -9.411   5.210  1.00 31.30
ATOM    718 1HG1 VAL    44      -1.117  -8.785   5.962  1.00  0.00
ATOM    719 2HG1 VAL    44      -0.303 -10.339   5.673  1.00  0.00
ATOM    720 3HG1 VAL    44       0.220  -8.882   4.795  1.00  0.00
ATOM    721  CG2 VAL    44      -2.143  -8.448   3.463  1.00 31.24
ATOM    722 1HG2 VAL    44      -2.616  -7.825   4.222  1.00  0.00
ATOM    723 2HG2 VAL    44      -1.312  -7.902   3.016  1.00  0.00
ATOM    724 3HG2 VAL    44      -2.872  -8.694   2.691  1.00  0.00
ATOM    725  C   VAL    44      -0.521 -11.935   3.689  1.00  1.33
ATOM    726  O   VAL    44      -1.344 -12.719   4.171  1.00 75.45
ATOM    727  N   ALA    45       0.784 -12.167   3.682  1.00 33.23
ATOM    728  HN  ALA    45       1.411 -11.505   3.246  1.00  0.00
ATOM    729  CA  ALA    45       1.350 -13.362   4.289  1.00  4.52
ATOM    730  HA  ALA    45       0.819 -14.228   3.896  1.00  0.00
ATOM    731  CB  ALA    45       2.821 -13.490   3.924  1.00 33.24
ATOM    732 1HB  ALA    45       3.231 -14.401   4.359  1.00  0.00
ATOM    733 2HB  ALA    45       2.924 -13.529   2.839  1.00  0.00
ATOM    734 3HB  ALA    45       3.367 -12.628   4.309  1.00  0.00
ATOM    735  C   ALA    45       1.174 -13.333   5.806  1.00 31.22
ATOM    736  O   ALA    45       1.238 -12.270   6.420  1.00 73.05
ATOM    770  N   GLY    48       3.404 -11.491   7.989  1.00 30.10
ATOM    771  HN  GLY    48       2.708 -12.044   7.511  1.00  0.00
ATOM    772  CA  GLY    48       3.350 -10.052   7.866  1.00 74.31
ATOM    773 1HA  GLY    48       2.307  -9.737   7.830  1.00  0.00
ATOM    774 2HA  GLY    48       3.833  -9.603   8.734  1.00  0.00
ATOM    775  C   GLY    48       4.051  -9.579   6.613  1.00 24.03
ATOM    776  O   GLY    48       3.814  -8.472   6.133  1.00 15.43
ATOM    777  N   ASP    49       4.903 -10.440   6.079  1.00 11.02
ATOM    778  HN  ASP    49       5.015 -11.352   6.498  1.00  0.00
ATOM    779  CA  ASP    49       5.695 -10.127   4.902  1.00 52.24
ATOM    780  HA  ASP    49       5.179  -9.360   4.324  1.00  0.00
ATOM    781  CB  ASP    49       7.062  -9.593   5.329  1.00 50.22
ATOM    782 2HB  ASP    49       6.916  -8.690   5.922  1.00  0.00
ATOM    783 3HB  ASP    49       7.558 -10.347   5.940  1.00  0.00
ATOM    784  CG  ASP    49       7.950  -9.263   4.152  1.00 14.31
ATOM    785  OD1 ASP    49       7.699  -8.239   3.491  1.00  4.41
ATOM    786  OD2 ASP    49       8.911 -10.016   3.892  1.00 61.05
ATOM    787 2HD  ASP    49       9.432  -9.741   3.134  1.00  0.00
ATOM    788  C   ASP    49       5.863 -11.371   4.037  1.00 11.41
ATOM    789  O   ASP    49       6.006 -12.478   4.563  1.00 62.34
ATOM    790  N   PRO    50       5.823 -11.222   2.702  1.00 53.04
ATOM    791  CD  PRO    50       6.050 -12.295   1.724  1.00  2.02
ATOM    792  CA  PRO    50       5.574  -9.945   2.041  1.00 31.54
ATOM    793  HA  PRO    50       5.968  -9.118   2.633  1.00  0.00
ATOM    794  CB  PRO    50       6.353 -10.099   0.737  1.00 11.21
ATOM    795 2HB  PRO    50       5.927  -9.493  -0.063  1.00  0.00
ATOM    796 3HB  PRO    50       7.393  -9.825   0.916  1.00  0.00
ATOM    797  CG  PRO    50       6.292 -11.561   0.421  1.00 50.44
ATOM    798 2HG  PRO    50       5.435 -11.730  -0.230  1.00  0.00
ATOM    799 3HG  PRO    50       7.212 -11.899  -0.056  1.00  0.00
ATOM    800 2HD  PRO    50       5.190 -12.960   1.646  1.00  0.00
ATOM    801 3HD  PRO    50       6.940 -12.857   2.006  1.00  0.00
ATOM    802  C   PRO    50       4.092  -9.703   1.765  1.00 62.31
ATOM    803  O   PRO    50       3.257 -10.595   1.941  1.00 32.31
ATOM    804  N   ILE    51       3.769  -8.496   1.332  1.00 72.31
ATOM    805  HN  ILE    51       4.486  -7.795   1.205  1.00  0.00
ATOM    806  CA  ILE    51       2.393  -8.145   1.028  1.00 32.51
ATOM    807  HA  ILE    51       1.750  -8.940   1.405  1.00  0.00
ATOM    808  CB  ILE    51       1.989  -6.822   1.716  1.00 15.23
ATOM    809  HB  ILE    51       2.664  -6.036   1.376  1.00  0.00
ATOM    810  CG2 ILE    51       0.565  -6.425   1.342  1.00 14.23
ATOM    811 1HG2 ILE    51       0.306  -5.481   1.822  1.00  0.00
ATOM    812 2HG2 ILE    51       0.493  -6.311   0.260  1.00  0.00
ATOM    813 3HG2 ILE    51      -0.126  -7.200   1.672  1.00  0.00
ATOM    814  CG1 ILE    51       2.127  -6.960   3.234  1.00 60.52
ATOM    815 2HG1 ILE    51       1.470  -7.763   3.567  1.00  0.00
ATOM    816 3HG1 ILE    51       3.161  -7.217   3.463  1.00  0.00
ATOM    817  CD1 ILE    51       1.768  -5.703   3.996  1.00 22.22
ATOM    818 1HD1 ILE    51       1.884  -5.859   5.068  1.00  0.00
ATOM    819 2HD1 ILE    51       2.424  -4.891   3.681  1.00  0.00
ATOM    820 3HD1 ILE    51       0.733  -5.436   3.783  1.00  0.00
ATOM    821  C   ILE    51       2.190  -8.028  -0.481  1.00 72.54
ATOM    822  O   ILE    51       2.812  -7.192  -1.138  1.00 22.10
ATOM    823  N   GLN    52       1.333  -8.884  -1.025  1.00 34.43
ATOM    824  HN  GLN    52       0.876  -9.571  -0.443  1.00  0.00
ATOM    825  CA  GLN    52       1.024  -8.869  -2.448  1.00 15.41
ATOM    826  HA  GLN    52       1.927  -8.589  -2.991  1.00  0.00
ATOM    827  CB  GLN    52       0.566 -10.252  -2.938  1.00 71.34
ATOM    828 2HB  GLN    52      -0.198 -10.618  -2.252  1.00  0.00
ATOM    829 3HB  GLN    52       0.135 -10.133  -3.932  1.00  0.00
ATOM    830  CG  GLN    52       1.670 -11.305  -3.023  1.00  4.11
ATOM    831 2HG  GLN    52       1.285 -12.166  -3.569  1.00  0.00
ATOM    832 3HG  GLN    52       2.511 -10.880  -3.571  1.00  0.00
ATOM    833  CD  GLN    52       2.168 -11.777  -1.668  1.00 53.41
ATOM    834  OE1 GLN    52       1.624 -12.713  -1.088  1.00  5.20
ATOM    835  NE2 GLN    52       3.228 -11.162  -1.176  1.00 34.13
ATOM    836 1HE2 GLN    52       3.653 -10.405  -1.692  1.00  0.00
ATOM    837 2HE2 GLN    52       3.611 -11.449  -0.287  1.00  0.00
ATOM    838  C   GLN    52      -0.063  -7.842  -2.733  1.00 61.21
ATOM    839  O   GLN    52      -1.165  -7.916  -2.182  1.00  0.50
ATOM    840  N   ILE    53       0.252  -6.888  -3.590  1.00 42.44
ATOM    841  HN  ILE    53       1.160  -6.894  -4.034  1.00  0.00
ATOM    842  CA  ILE    53      -0.670  -5.816  -3.924  1.00 13.15
ATOM    843  HA  ILE    53      -1.668  -6.117  -3.607  1.00  0.00
ATOM    844  CB  ILE    53      -0.298  -4.502  -3.199  1.00 55.32
ATOM    845  HB  ILE    53      -0.931  -3.705  -3.590  1.00  0.00
ATOM    846  CG2 ILE    53      -0.555  -4.625  -1.703  1.00 54.10
ATOM    847 1HG2 ILE    53      -0.312  -3.684  -1.209  1.00  0.00
ATOM    848 2HG2 ILE    53      -1.605  -4.861  -1.534  1.00  0.00
ATOM    849 3HG2 ILE    53       0.067  -5.420  -1.293  1.00  0.00
ATOM    850  CG1 ILE    53       1.165  -4.130  -3.471  1.00 73.23
ATOM    851 2HG1 ILE    53       1.800  -4.927  -3.085  1.00  0.00
ATOM    852 3HG1 ILE    53       1.304  -4.044  -4.549  1.00  0.00
ATOM    853  CD1 ILE    53       1.594  -2.826  -2.830  1.00 42.51
ATOM    854 1HD1 ILE    53       2.640  -2.614  -3.056  1.00  0.00
ATOM    855 2HD1 ILE    53       0.975  -2.015  -3.214  1.00  0.00
ATOM    856 3HD1 ILE    53       1.470  -2.897  -1.750  1.00  0.00
ATOM    857  C   ILE    53      -0.685  -5.570  -5.426  1.00  4.23
ATOM    858  O   ILE    53       0.305  -5.821  -6.114  1.00 23.24
ATOM    859  N   ASN    54      -1.813  -5.098  -5.931  1.00  5.12
ATOM    860  HN  ASN    54      -2.615  -4.958  -5.334  1.00  0.00
ATOM    861  CA  ASN    54      -1.930  -4.769  -7.343  1.00 30.22
ATOM    862  HA  ASN    54      -1.030  -5.111  -7.855  1.00  0.00
ATOM    863  CB  ASN    54      -3.142  -5.471  -7.968  1.00 62.43
ATOM    864 2HB  ASN    54      -3.110  -6.526  -7.697  1.00  0.00
ATOM    865 3HB  ASN    54      -4.050  -5.023  -7.564  1.00  0.00
ATOM    866  CG  ASN    54      -3.182  -5.360  -9.486  1.00 23.35
ATOM    867  OD1 ASN    54      -2.770  -4.358 -10.072  1.00 35.11
ATOM    868  ND2 ASN    54      -3.672  -6.405 -10.138  1.00 41.54
ATOM    869 1HD2 ASN    54      -3.996  -7.211  -9.624  1.00  0.00
ATOM    870 2HD2 ASN    54      -3.719  -6.393 -11.147  1.00  0.00
ATOM    871  C   ASN    54      -2.039  -3.262  -7.502  1.00 22.34
ATOM    872  O   ASN    54      -3.026  -2.650  -7.083  1.00 73.05
ATOM    873  N   VAL    55      -1.006  -2.671  -8.082  1.00 75.43
ATOM    874  HN  VAL    55      -0.240  -3.232  -8.426  1.00  0.00
ATOM    875  CA  VAL    55      -0.928  -1.229  -8.246  1.00 71.34
ATOM    876  HA  VAL    55      -1.902  -0.804  -8.003  1.00  0.00
ATOM    877  CB  VAL    55       0.133  -0.606  -7.310  1.00 33.34
ATOM    878  HB  VAL    55       1.113  -0.967  -7.622  1.00  0.00
ATOM    879  CG1 VAL    55       0.132   0.912  -7.419  1.00 22.32
ATOM    880 1HG1 VAL    55       0.903   1.331  -6.772  1.00  0.00
ATOM    881 2HG1 VAL    55       0.331   1.202  -8.451  1.00  0.00
ATOM    882 3HG1 VAL    55      -0.842   1.297  -7.116  1.00  0.00
ATOM    883  CG2 VAL    55      -0.094  -1.039  -5.872  1.00 73.44
ATOM    884 1HG2 VAL    55       0.678  -0.612  -5.231  1.00  0.00
ATOM    885 2HG2 VAL    55      -1.072  -0.692  -5.540  1.00  0.00
ATOM    886 3HG2 VAL    55      -0.054  -2.126  -5.811  1.00  0.00
ATOM    887  C   VAL    55      -0.581  -0.881  -9.688  1.00 52.14
ATOM    888  O   VAL    55       0.349  -1.448 -10.263  1.00 20.40
ATOM    889  N   ARG    56      -1.348   0.041 -10.269  1.00 30.54
ATOM    890  HN  ARG    56      -2.121   0.437  -9.754  1.00  0.00
ATOM    891  CA  ARG    56      -1.120   0.514 -11.639  1.00 51.31
ATOM    892  HA  ARG    56      -1.862   1.282 -11.857  1.00  0.00
ATOM    893  CB  ARG    56       0.277   1.135 -11.773  1.00 23.31
ATOM    894 2HB  ARG    56       1.016   0.360 -11.570  1.00  0.00
ATOM    895 3HB  ARG    56       0.395   1.490 -12.797  1.00  0.00
ATOM    896  CG  ARG    56       0.541   2.303 -10.832  1.00 62.31
ATOM    897 2HG  ARG    56       0.416   1.963  -9.804  1.00  0.00
ATOM    898 3HG  ARG    56       1.564   2.650 -10.978  1.00  0.00
ATOM    899  CD  ARG    56      -0.411   3.460 -11.087  1.00 42.41
ATOM    900 2HD  ARG    56      -0.399   3.701 -12.150  1.00  0.00
ATOM    901 3HD  ARG    56      -1.418   3.160 -10.800  1.00  0.00
ATOM    902  NE  ARG    56      -0.036   4.653 -10.326  1.00  4.24
ATOM    903  HE  ARG    56       0.587   4.524  -9.541  1.00  0.00
ATOM    904  CZ  ARG    56      -0.465   5.885 -10.609  1.00 43.14
ATOM    905  NH1 ARG    56      -1.314   6.077 -11.610  1.00 63.41
ATOM    906 1HH1 ARG    56      -1.640   7.009 -11.825  1.00  0.00
ATOM    907 2HH1 ARG    56      -1.634   5.292 -12.158  1.00  0.00
ATOM    908  NH2 ARG    56      -0.049   6.924  -9.892  1.00 51.54
ATOM    909 1HH2 ARG    56      -0.377   7.855 -10.110  1.00  0.00
ATOM    910 2HH2 ARG    56       0.597   6.784  -9.128  1.00  0.00
ATOM    911  C   ARG    56      -1.282  -0.618 -12.658  1.00  4.53
ATOM    912  O   ARG    56      -0.865  -0.492 -13.809  1.00 23.23
ATOM    913  N   GLY    57      -1.895  -1.715 -12.233  1.00 73.14
ATOM    914  HN  GLY    57      -2.234  -1.773 -11.284  1.00  0.00
ATOM    915  CA  GLY    57      -2.091  -2.848 -13.115  1.00 35.31
ATOM    916 1HA  GLY    57      -3.079  -3.269 -12.931  1.00  0.00
ATOM    917 2HA  GLY    57      -2.032  -2.503 -14.148  1.00  0.00
ATOM    918  C   GLY    57      -1.051  -3.927 -12.900  1.00 64.14
ATOM    919  O   GLY    57      -1.142  -5.016 -13.474  1.00 42.35
ATOM    920  N   TYR    58      -0.058  -3.632 -12.072  1.00  2.31
ATOM    921  HN  TYR    58      -0.016  -2.720 -11.639  1.00  0.00
ATOM    922  CA  TYR    58       0.987  -4.594 -11.767  1.00 75.35
ATOM    923  HA  TYR    58       0.988  -5.367 -12.535  1.00  0.00
ATOM    924  CB  TYR    58       2.360  -3.910 -11.743  1.00 75.12
ATOM    925 2HB  TYR    58       2.411  -3.270 -10.862  1.00  0.00
ATOM    926 3HB  TYR    58       3.128  -4.679 -11.662  1.00  0.00
ATOM    927  CG  TYR    58       2.658  -3.066 -12.963  1.00 71.43
ATOM    928  CD1 TYR    58       2.429  -1.695 -12.953  1.00 24.05
ATOM    929 1HD  TYR    58       2.032  -1.230 -12.063  1.00  0.00
ATOM    930  CE1 TYR    58       2.701  -0.916 -14.061  1.00 21.41
ATOM    931 1HE  TYR    58       2.519   0.149 -14.035  1.00  0.00
ATOM    932  CZ  TYR    58       3.206  -1.504 -15.198  1.00 52.22
ATOM    933  CE2 TYR    58       3.443  -2.864 -15.233  1.00 71.21
ATOM    934 2HE  TYR    58       3.842  -3.322 -16.126  1.00  0.00
ATOM    935  CD2 TYR    58       3.168  -3.636 -14.120  1.00 63.43
ATOM    936 2HD  TYR    58       3.354  -4.699 -14.152  1.00  0.00
ATOM    937  OH  TYR    58       3.481  -0.729 -16.301  1.00  1.03
ATOM    938  HH  TYR    58       3.830  -1.236 -17.038  1.00  0.00
ATOM    939  C   TYR    58       0.718  -5.230 -10.411  1.00 14.14
ATOM    940  O   TYR    58       0.517  -4.528  -9.421  1.00 11.24
ATOM    941  N   GLU    59       0.726  -6.549 -10.364  1.00 53.21
ATOM    942  HN  GLU    59       0.863  -7.086 -11.208  1.00  0.00
ATOM    943  CA  GLU    59       0.542  -7.253  -9.111  1.00 72.32
ATOM    944  HA  GLU    59       0.152  -6.552  -8.373  1.00  0.00
ATOM    945  CB  GLU    59      -0.464  -8.384  -9.277  1.00 21.34
ATOM    946 2HB  GLU    59      -1.363  -7.975  -9.737  1.00  0.00
ATOM    947 3HB  GLU    59      -0.028  -9.135  -9.936  1.00  0.00
ATOM    948  CG  GLU    59      -0.860  -9.063  -7.978  1.00 50.34
ATOM    949 2HG  GLU    59       0.004  -9.596  -7.582  1.00  0.00
ATOM    950 3HG  GLU    59      -1.169  -8.301  -7.263  1.00  0.00
ATOM    951  CD  GLU    59      -1.997 -10.046  -8.169  1.00 11.43
ATOM    952  OE1 GLU    59      -1.748 -11.270  -8.169  1.00 32.42
ATOM    953  OE2 GLU    59      -3.148  -9.597  -8.329  1.00 24.44
ATOM    954 2HE  GLU    59      -3.819 -10.272  -8.447  1.00  0.00
ATOM    955  C   GLU    59       1.883  -7.773  -8.626  1.00 14.44
ATOM    956  O   GLU    59       2.507  -8.630  -9.254  1.00 31.01
ATOM    957  N   LEU    60       2.317  -7.241  -7.510  1.00 74.52
ATOM    958  HN  LEU    60       1.712  -6.636  -6.972  1.00  0.00
ATOM    959  CA  LEU    60       3.660  -7.496  -7.014  1.00 72.24
ATOM    960  HA  LEU    60       4.021  -8.417  -7.471  1.00  0.00
ATOM    961  CB  LEU    60       4.599  -6.347  -7.428  1.00 22.23
ATOM    962 2HB  LEU    60       5.542  -6.478  -6.896  1.00  0.00
ATOM    963 3HB  LEU    60       4.773  -6.429  -8.501  1.00  0.00
ATOM    964  CG  LEU    60       4.092  -4.922  -7.141  1.00 32.14
ATOM    965  HG  LEU    60       3.029  -4.886  -7.378  1.00  0.00
ATOM    966  CD1 LEU    60       4.262  -4.554  -5.672  1.00 70.41
ATOM    967 1HD1 LEU    60       3.877  -3.550  -5.492  1.00  0.00
ATOM    968 2HD1 LEU    60       3.714  -5.266  -5.055  1.00  0.00
ATOM    969 3HD1 LEU    60       5.320  -4.585  -5.411  1.00  0.00
ATOM    970  CD2 LEU    60       4.813  -3.917  -8.025  1.00 62.34
ATOM    971 1HD2 LEU    60       4.428  -2.915  -7.836  1.00  0.00
ATOM    972 2HD2 LEU    60       5.881  -3.940  -7.805  1.00  0.00
ATOM    973 3HD2 LEU    60       4.652  -4.174  -9.072  1.00  0.00
ATOM    974  C   LEU    60       3.667  -7.679  -5.505  1.00  2.23
ATOM    975  O   LEU    60       2.642  -7.519  -4.844  1.00 52.31
ATOM    976  N   SER    61       4.828  -8.020  -4.972  1.00 74.25
ATOM    977  HN  SER    61       5.627  -8.181  -5.569  1.00  0.00
ATOM    978  CA  SER    61       4.995  -8.170  -3.542  1.00 63.23
ATOM    979  HA  SER    61       4.012  -8.161  -3.072  1.00  0.00
ATOM    980  CB  SER    61       5.683  -9.497  -3.229  1.00 42.21
ATOM    981 2HB  SER    61       6.687  -9.486  -3.654  1.00  0.00
ATOM    982 3HB  SER    61       5.748  -9.618  -2.148  1.00  0.00
ATOM    983  OG  SER    61       4.962 -10.591  -3.774  1.00 23.41
ATOM    984  HG  SER    61       5.421 -11.406  -3.559  1.00  0.00
ATOM    985  C   SER    61       5.819  -7.015  -2.991  1.00 23.22
ATOM    986  O   SER    61       6.931  -6.758  -3.455  1.00 22.24
ATOM    987  N   LEU    62       5.266  -6.313  -2.021  1.00 12.43
ATOM    988  HN  LEU    62       4.330  -6.531  -1.711  1.00  0.00
ATOM    989  CA  LEU    62       5.971  -5.222  -1.377  1.00 51.32
ATOM    990  HA  LEU    62       6.855  -4.980  -1.968  1.00  0.00
ATOM    991  CB  LEU    62       5.083  -3.979  -1.295  1.00 61.11
ATOM    992 2HB  LEU    62       4.769  -3.723  -2.307  1.00  0.00
ATOM    993 3HB  LEU    62       4.209  -4.229  -0.695  1.00  0.00
ATOM    994  CG  LEU    62       5.742  -2.741  -0.677  1.00 32.54
ATOM    995  HG  LEU    62       6.151  -3.019   0.294  1.00  0.00
ATOM    996  CD1 LEU    62       6.885  -2.240  -1.549  1.00 41.21
ATOM    997 1HD1 LEU    62       7.354  -1.372  -1.084  1.00  0.00
ATOM    998 2HD1 LEU    62       7.626  -3.031  -1.665  1.00  0.00
ATOM    999 3HD1 LEU    62       6.498  -1.959  -2.529  1.00  0.00
ATOM   1000  CD2 LEU    62       4.713  -1.644  -0.467  1.00 23.13
ATOM   1001 1HD2 LEU    62       5.186  -0.777  -0.005  1.00  0.00
ATOM   1002 2HD2 LEU    62       4.291  -1.354  -1.429  1.00  0.00
ATOM   1003 3HD2 LEU    62       3.919  -2.011   0.183  1.00  0.00
ATOM   1004  C   LEU    62       6.408  -5.654   0.011  1.00 31.25
ATOM   1005  O   LEU    62       5.637  -6.276   0.748  1.00 74.34
ATOM   1006  N   ARG    63       7.653  -5.354   0.346  1.00 72.31
ATOM   1007  HN  ARG    63       8.242  -4.855  -0.306  1.00  0.00
ATOM   1008  CA  ARG    63       8.209  -5.723   1.634  1.00  1.32
ATOM   1009  HA  ARG    63       8.070  -6.794   1.778  1.00  0.00
ATOM   1010  CB  ARG    63       9.705  -5.411   1.673  1.00 14.24
ATOM   1011 2HB  ARG    63      10.103  -5.508   0.663  1.00  0.00
ATOM   1012 3HB  ARG    63       9.833  -4.384   2.017  1.00  0.00
ATOM   1013  CG  ARG    63      10.497  -6.325   2.590  1.00 34.41
ATOM   1014 2HG  ARG    63      11.554  -6.068   2.522  1.00  0.00
ATOM   1015 3HG  ARG    63      10.155  -6.184   3.615  1.00  0.00
ATOM   1016  CD  ARG    63      10.315  -7.783   2.201  1.00 15.20
ATOM   1017 2HD  ARG    63      10.006  -8.343   3.083  1.00  0.00
ATOM   1018 3HD  ARG    63       9.534  -7.846   1.444  1.00  0.00
ATOM   1019  NE  ARG    63      11.532  -8.390   1.667  1.00 23.14
ATOM   1020  HE  ARG    63      12.225  -7.771   1.268  1.00  0.00
ATOM   1021  CZ  ARG    63      11.769  -9.703   1.681  1.00 34.00
ATOM   1022  NH1 ARG    63      10.905 -10.538   2.250  1.00 30.12
ATOM   1023 1HH1 ARG    63      11.093 -11.530   2.262  1.00  0.00
ATOM   1024 2HH1 ARG    63      10.060 -10.179   2.670  1.00  0.00
ATOM   1025  NH2 ARG    63      12.885 -10.177   1.142  1.00 65.32
ATOM   1026 1HH2 ARG    63      13.070 -11.169   1.156  1.00  0.00
ATOM   1027 2HH2 ARG    63      13.550  -9.545   0.718  1.00  0.00
ATOM   1028  C   ARG    63       7.490  -4.979   2.751  1.00 54.04
ATOM   1029  O   ARG    63       7.207  -3.782   2.631  1.00 41.32
ATOM   1030  N   LYS    64       7.194  -5.697   3.826  1.00 42.41
ATOM   1031  HN  LYS    64       7.451  -6.673   3.857  1.00  0.00
ATOM   1032  CA  LYS    64       6.506  -5.131   4.978  1.00 13.22
ATOM   1033  HA  LYS    64       5.521  -4.794   4.656  1.00  0.00
ATOM   1034  CB  LYS    64       6.322  -6.207   6.060  1.00 51.34
ATOM   1035 2HB  LYS    64       5.863  -7.080   5.597  1.00  0.00
ATOM   1036 3HB  LYS    64       7.306  -6.474   6.446  1.00  0.00
ATOM   1037  CG  LYS    64       5.451  -5.776   7.233  1.00 41.41
ATOM   1038 2HG  LYS    64       4.672  -5.108   6.865  1.00  0.00
ATOM   1039 3HG  LYS    64       4.993  -6.660   7.674  1.00  0.00
ATOM   1040  CD  LYS    64       6.251  -5.053   8.304  1.00 32.31
ATOM   1041 2HD  LYS    64       7.058  -4.497   7.826  1.00  0.00
ATOM   1042 3HD  LYS    64       5.593  -4.359   8.827  1.00  0.00
ATOM   1043  CE  LYS    64       6.850  -6.018   9.314  1.00 34.43
ATOM   1044 2HE  LYS    64       6.045  -6.569   9.799  1.00  0.00
ATOM   1045 3HE  LYS    64       7.501  -6.719   8.792  1.00  0.00
ATOM   1046  NZ  LYS    64       7.640  -5.305  10.350  1.00 21.10
ATOM   1047 1HZ  LYS    64       8.024  -5.972  11.004  1.00  0.00
ATOM   1048 2HZ  LYS    64       8.393  -4.797   9.908  1.00  0.00
ATOM   1049 3HZ  LYS    64       7.042  -4.658  10.843  1.00  0.00
ATOM   1050  C   LYS    64       7.270  -3.928   5.525  1.00 20.34
ATOM   1051  O   LYS    64       6.670  -3.002   6.063  1.00 13.53
ATOM   1052  N   SER    65       8.588  -3.943   5.363  1.00 44.33
ATOM   1053  HN  SER    65       9.030  -4.744   4.935  1.00  0.00
ATOM   1054  CA  SER    65       9.431  -2.832   5.783  1.00 15.40
ATOM   1055  HA  SER    65       9.404  -2.762   6.870  1.00  0.00
ATOM   1056  CB  SER    65      10.867  -3.094   5.338  1.00  2.23
ATOM   1057 2HB  SER    65      10.933  -2.985   4.255  1.00  0.00
ATOM   1058 3HB  SER    65      11.529  -2.372   5.817  1.00  0.00
ATOM   1059  OG  SER    65      11.268  -4.405   5.700  1.00 32.21
ATOM   1060  HG  SER    65      12.173  -4.543   5.409  1.00  0.00
ATOM   1061  C   SER    65       8.924  -1.516   5.191  1.00 13.15
ATOM   1062  O   SER    65       8.802  -0.514   5.895  1.00 62.15
ATOM   1063  N   ALA    66       8.615  -1.536   3.898  1.00 34.10
ATOM   1064  HN  ALA    66       8.753  -2.380   3.362  1.00  0.00
ATOM   1065  CA  ALA    66       8.079  -0.366   3.220  1.00 54.22
ATOM   1066  HA  ALA    66       8.640   0.508   3.552  1.00  0.00
ATOM   1067  CB  ALA    66       8.249  -0.505   1.715  1.00 24.42
ATOM   1068 1HB  ALA    66       7.870   0.388   1.217  1.00  0.00
ATOM   1069 2HB  ALA    66       9.306  -0.628   1.479  1.00  0.00
ATOM   1070 3HB  ALA    66       7.695  -1.376   1.366  1.00  0.00
ATOM   1071  C   ALA    66       6.610  -0.163   3.576  1.00 45.41
ATOM   1072  O   ALA    66       6.182   0.951   3.870  1.00 32.23
ATOM   1073  N   ALA    67       5.848  -1.255   3.566  1.00 75.31
ATOM   1074  HN  ALA    67       6.265  -2.150   3.353  1.00  0.00
ATOM   1075  CA  ALA    67       4.412  -1.212   3.853  1.00  4.20
ATOM   1076  HA  ALA    67       3.935  -0.590   3.095  1.00  0.00
ATOM   1077  CB  ALA    67       3.818  -2.609   3.784  1.00 33.13
ATOM   1078 1HB  ALA    67       2.745  -2.564   3.967  1.00  0.00
ATOM   1079 2HB  ALA    67       3.998  -3.030   2.795  1.00  0.00
ATOM   1080 3HB  ALA    67       4.288  -3.240   4.538  1.00  0.00
ATOM   1081  C   ALA    67       4.131  -0.608   5.223  1.00 73.35
ATOM   1082  O   ALA    67       3.103   0.033   5.438  1.00 14.33
ATOM   1083  N   GLU    68       5.055  -0.821   6.144  1.00 44.23
ATOM   1084  HN  GLU    68       5.899  -1.318   5.897  1.00  0.00
ATOM   1085  CA  GLU    68       4.904  -0.361   7.514  1.00 44.40
ATOM   1086  HA  GLU    68       3.871  -0.520   7.823  1.00  0.00
ATOM   1087  CB  GLU    68       5.824  -1.174   8.424  1.00 14.11
ATOM   1088 2HB  GLU    68       5.845  -2.202   8.063  1.00  0.00
ATOM   1089 3HB  GLU    68       6.827  -0.749   8.368  1.00  0.00
ATOM   1090  CG  GLU    68       5.390  -1.185   9.873  1.00 61.13
ATOM   1091 2HG  GLU    68       5.224  -0.157  10.197  1.00  0.00
ATOM   1092 3HG  GLU    68       4.458  -1.743   9.956  1.00  0.00
ATOM   1093  CD  GLU    68       6.421  -1.821  10.779  1.00 20.11
ATOM   1094  OE1 GLU    68       6.416  -3.060  10.913  1.00 34.45
ATOM   1095  OE2 GLU    68       7.250  -1.081  11.348  1.00 62.33
ATOM   1096 2HE  GLU    68       7.877  -1.550  11.904  1.00  0.00
ATOM   1097  C   GLU    68       5.227   1.129   7.630  1.00 75.25
ATOM   1098  O   GLU    68       4.959   1.757   8.653  1.00 10.11
ATOM   1099  N   MET    69       5.792   1.690   6.570  1.00 20.45
ATOM   1100  HN  MET    69       5.949   1.146   5.734  1.00  0.00
ATOM   1101  CA  MET    69       6.201   3.088   6.577  1.00 54.12
ATOM   1102  HA  MET    69       6.113   3.468   7.595  1.00  0.00
ATOM   1103  CB  MET    69       7.663   3.203   6.133  1.00 20.41
ATOM   1104 2HB  MET    69       8.232   2.415   6.625  1.00  0.00
ATOM   1105 3HB  MET    69       7.704   3.061   5.053  1.00  0.00
ATOM   1106  CG  MET    69       8.317   4.539   6.462  1.00 42.02
ATOM   1107 2HG  MET    69       9.191   4.667   5.822  1.00  0.00
ATOM   1108 3HG  MET    69       7.607   5.338   6.246  1.00  0.00
ATOM   1109  SD  MET    69       8.840   4.681   8.189  1.00  4.42
ATOM   1110  CE  MET    69       7.274   4.758   9.061  1.00 63.43
ATOM   1111 1HE  MET    69       7.440   4.847  10.134  1.00  0.00
ATOM   1112 2HE  MET    69       6.710   5.624   8.714  1.00  0.00
ATOM   1113 3HE  MET    69       6.705   3.851   8.861  1.00  0.00
ATOM   1114  C   MET    69       5.301   3.925   5.664  1.00 71.11
ATOM   1115  O   MET    69       5.238   5.151   5.783  1.00 34.42
ATOM   1116  N   ILE    70       4.608   3.255   4.751  1.00 71.51
ATOM   1117  HN  ILE    70       4.694   2.250   4.696  1.00  0.00
ATOM   1118  CA  ILE    70       3.716   3.924   3.814  1.00 12.23
ATOM   1119  HA  ILE    70       4.222   4.819   3.449  1.00  0.00
ATOM   1120  CB  ILE    70       3.390   3.017   2.604  1.00 13.04
ATOM   1121  HB  ILE    70       2.984   2.078   2.979  1.00  0.00
ATOM   1122  CG2 ILE    70       2.346   3.661   1.701  1.00 31.32
ATOM   1123 1HG2 ILE    70       2.117   2.997   0.867  1.00  0.00
ATOM   1124 2HG2 ILE    70       1.438   3.848   2.274  1.00  0.00
ATOM   1125 3HG2 ILE    70       2.733   4.605   1.315  1.00  0.00
ATOM   1126  CG1 ILE    70       4.666   2.712   1.818  1.00 34.52
ATOM   1127 2HG1 ILE    70       5.076   3.653   1.449  1.00  0.00
ATOM   1128 3HG1 ILE    70       5.382   2.244   2.493  1.00  0.00
ATOM   1129  CD1 ILE    70       4.452   1.790   0.637  1.00 53.12
ATOM   1130 1HD1 ILE    70       5.393   1.611   0.116  1.00  0.00
ATOM   1131 2HD1 ILE    70       4.053   0.840   0.990  1.00  0.00
ATOM   1132 3HD1 ILE    70       3.744   2.248  -0.054  1.00  0.00
ATOM   1133  C   ILE    70       2.420   4.343   4.499  1.00 22.13
ATOM   1134  O   ILE    70       1.825   3.569   5.249  1.00  5.50
ATOM   1135  N   GLU    71       1.996   5.573   4.234  1.00 74.54
ATOM   1136  HN  GLU    71       2.534   6.165   3.617  1.00  0.00
ATOM   1137  CA  GLU    71       0.770   6.106   4.805  1.00 62.40
ATOM   1138  HA  GLU    71       0.511   5.522   5.688  1.00  0.00
ATOM   1139  CB  GLU    71       0.975   7.565   5.218  1.00  4.32
ATOM   1140 2HB  GLU    71       1.811   7.610   5.916  1.00  0.00
ATOM   1141 3HB  GLU    71       1.217   8.144   4.326  1.00  0.00
ATOM   1142  CG  GLU    71      -0.237   8.195   5.882  1.00  4.43
ATOM   1143 2HG  GLU    71      -0.751   8.822   5.153  1.00  0.00
ATOM   1144 3HG  GLU    71      -0.909   7.403   6.211  1.00  0.00
ATOM   1145  CD  GLU    71       0.136   9.044   7.076  1.00 71.52
ATOM   1146  OE1 GLU    71       0.853   8.545   7.968  1.00 64.22
ATOM   1147  OE2 GLU    71      -0.289  10.214   7.135  1.00 11.53
ATOM   1148 2HE  GLU    71      -0.014  10.694   7.920  1.00  0.00
ATOM   1149  C   GLU    71      -0.366   6.006   3.792  1.00 30.13
ATOM   1150  O   GLU    71      -0.350   6.672   2.752  1.00 22.31
ATOM   1151  N   VAL    72      -1.343   5.166   4.091  1.00 24.24
ATOM   1152  HN  VAL    72      -1.307   4.640   4.952  1.00  0.00
ATOM   1153  CA  VAL    72      -2.481   4.974   3.208  1.00 73.40
ATOM   1154  HA  VAL    72      -2.415   5.715   2.411  1.00  0.00
ATOM   1155  CB  VAL    72      -2.490   3.566   2.570  1.00 61.32
ATOM   1156  HB  VAL    72      -3.380   3.484   1.946  1.00  0.00
ATOM   1157  CG1 VAL    72      -1.272   3.362   1.683  1.00 52.44
ATOM   1158 1HG1 VAL    72      -1.309   2.375   1.222  1.00  0.00
ATOM   1159 2HG1 VAL    72      -1.260   4.124   0.903  1.00  0.00
ATOM   1160 3HG1 VAL    72      -0.367   3.445   2.285  1.00  0.00
ATOM   1161  CG2 VAL    72      -2.562   2.485   3.642  1.00  5.02
ATOM   1162 1HG2 VAL    72      -2.594   1.501   3.174  1.00  0.00
ATOM   1163 2HG2 VAL    72      -1.682   2.552   4.283  1.00  0.00
ATOM   1164 3HG2 VAL    72      -3.460   2.630   4.242  1.00  0.00
ATOM   1165  C   VAL    72      -3.783   5.181   3.964  1.00 64.04
ATOM   1166  O   VAL    72      -3.787   5.310   5.188  1.00 22.25
ATOM   1167  N   GLU    73      -4.880   5.220   3.230  1.00 45.33
ATOM   1168  HN  GLU    73      -4.815   5.170   2.223  1.00  0.00
ATOM   1169  CA  GLU    73      -6.195   5.333   3.835  1.00 65.41
ATOM   1170  HA  GLU    73      -6.083   5.265   4.917  1.00  0.00
ATOM   1171  CB  GLU    73      -6.847   6.673   3.492  1.00 65.44
ATOM   1172 2HB  GLU    73      -6.995   6.717   2.413  1.00  0.00
ATOM   1173 3HB  GLU    73      -7.813   6.724   3.994  1.00  0.00
ATOM   1174  CG  GLU    73      -6.029   7.877   3.910  1.00  3.41
ATOM   1175 2HG  GLU    73      -5.702   7.739   4.940  1.00  0.00
ATOM   1176 3HG  GLU    73      -5.154   7.950   3.263  1.00  0.00
ATOM   1177  CD  GLU    73      -6.812   9.168   3.816  1.00 44.43
ATOM   1178  OE1 GLU    73      -7.138   9.745   4.877  1.00 73.24
ATOM   1179  OE2 GLU    73      -7.111   9.610   2.689  1.00 41.01
ATOM   1180 2HE  GLU    73      -7.608  10.431   2.707  1.00  0.00
ATOM   1181  C   GLU    73      -7.089   4.205   3.357  1.00 53.54
ATOM   1182  O   GLU    73      -7.093   3.870   2.170  1.00 75.24
END
