
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 (  773),  selected  100 , name 1woc_C
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1woc_C.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_C      M       1          1.019
LGA    N     3_C      N       2          1.198
LGA    R     4_C      T       3          1.087
LGA    L     5_C      L       4          0.815
LGA    V     6_C      E       5          0.747
LGA    L     7_C      L       6          0.426
LGA    S     8_C      S       7          0.534
LGA    G     9_C      A       8          0.931
LGA    T    10_C      R       9          0.717
LGA    V    11_C      V      10          0.775
LGA    C    12_C      L      11          0.854
LGA    R    13_C      E      12          1.250
LGA    A    14_C      C      13          2.519
LGA    P    15_C      G      14          2.428
LGA    L    16_C      A      15          3.080
LGA    R    17_C      M      16          1.959
LGA    K    18_C      R      17          1.274
LGA    V    19_C      H      18          1.240
LGA    S    20_C      T      19          2.065
LGA    P    21_C      P      20          2.729
LGA    S    22_C      A      21          3.170
LGA    G    23_C      G      22          2.035
LGA    I    24_C      L      23          2.131
LGA    P    25_C      P      24          1.817
LGA    H    26_C      A      25          0.582
LGA    C    27_C      L      26          0.675
LGA    Q    28_C      E      27          0.485
LGA    F    29_C      L      28          0.577
LGA    V    30_C      L      29          0.620
LGA    L    31_C      L      30          0.501
LGA    E    32_C      V      31          0.258
LGA    H    33_C      H      32          0.404
LGA    R    34_C      E      33          0.866
LGA    S    35_C      S      34          0.766
LGA    V    36_C      E      35          0.497
LGA    Q    37_C      V      36          0.151
LGA    E    38_C      V      37          0.547
LGA    E    39_C      E      38          0.719
LGA    A    40_C      A      39          0.958
LGA    G    41_C      G      40          1.471
LGA    F    42_C      H      41          0.811
LGA    H    43_C      P      42          0.488
LGA    R    44_C      R      43          0.846
LGA    Q    45_C      R      44          1.208
LGA    A    46_C      V      45          1.348
LGA    W    47_C      E      46          1.777
LGA    C    48_C      L      47          1.195
LGA    Q    49_C      T      48          0.762
LGA    X    50_C      I      49          1.033
LGA    P    51_C      S      50          0.532
LGA    V    52_C      A      51          0.567
LGA    I    53_C      V      52          0.501
LGA    V    54_C      A      53          0.502
LGA    S    55_C      L      54          0.484
LGA    G    56_C      G      55          2.064
LGA    H    57_C      -       -           -
LGA    E    58_C      D      56          2.724
LGA    N    59_C      L      57          2.768
LGA    Q    60_C      A      58          2.751
LGA    A    61_C      L      59          3.041
LGA    I    62_C      L      60          2.051
LGA    T    63_C      L      61          0.965
LGA    H    64_C      A      62          3.530
LGA    S    65_C      D      63          5.006
LGA    I    66_C      T      64          1.463
LGA    T    67_C      P      65          2.627
LGA    V    68_C      L      66          1.486
LGA    G    69_C      G      67          0.898
LGA    S    70_C      T      68          1.080
LGA    R    71_C      E      69          0.843
LGA    I    72_C      M      70          0.519
LGA    T    73_C      Q      71          1.071
LGA    V    74_C      V      72          0.939
LGA    Q    75_C      Q      73          1.023
LGA    G    76_C      G      74          1.036
LGA    F    77_C      F      75          1.123
LGA    I    78_C      L      76          1.060
LGA    S    79_C      A      77          0.948
LGA    C    80_C      P      78          0.964
LGA    H    81_C      A      79          2.151
LGA    K    82_C      R      80          1.365
LGA    A    83_C      K      81           -
LGA    K    84_C      D      82           -
LGA    N    85_C      -       -           -
LGA    G    86_C      -       -           -
LGA    L    87_C      S      83          5.051
LGA    S    88_C      V      84          4.128
LGA    K    89_C      K      85          2.042
LGA    X    90_C      V      86          0.845
LGA    V    91_C      K      87          0.985
LGA    L    92_C      L      88          0.939
LGA    H    93_C      H      89          1.018
LGA    A    94_C      L      90          0.952
LGA    E    95_C      Q      91          1.344
LGA    Q    96_C      Q      92          1.272
LGA    I    97_C      A      93          1.063
LGA    E    98_C      R      94          1.671
LGA    L    99_C      R      95          1.191
LGA    I   100_C      I      96          1.173
LGA    D   101_C      A      97          1.156
LGA    -       -      G      98           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100   98    5.0     95    1.66    27.37     90.109     5.387

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.331782 * X  +  -0.626244 * Y  +   0.705506 * Z  + -32.573689
  Y_new =   0.837449 * X  +  -0.539813 * Y  +  -0.085334 * Z  +  49.676903
  Z_new =   0.434281 * X  +   0.562513 * Y  +   0.703547 * Z  +  48.513226 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.674459   -2.467134  [ DEG:    38.6437   -141.3563 ]
  Theta =  -0.449240   -2.692353  [ DEG:   -25.7396   -154.2604 ]
  Phi   =   1.948007   -1.193585  [ DEG:   111.6126    -68.3874 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1woc_C                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1woc_C.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100   98   5.0   95   1.66   27.37  90.109
REMARK  ---------------------------------------------------------- 
MOLECULE 1woc_C
HEADER    DNA BINDING PROTEIN                     13-AUG-04   1WOC              
TITLE     CRYSTAL STRUCTURE OF PRIB                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRIMOSOMAL REPLICATION PROTEIN N;                          
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PRIMOSOMAL PROTEIN B, PRIB;                                 
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET22B(+)                                 
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.SHIOI,T.OSE,K.MAENAKA,Y.ABE,D.KOHDA,T.KATAYAMA,T.UEDA               
REVDAT   1   25-JAN-05 1WOC    0                                                
JRNL        AUTH   S.SHIOI,T.OSE,K.MAENAKA,M.SHIROISHI,Y.ABE,D.KOHDA,           
JRNL        AUTH 2 T.KATAYAMA,T.UEDA                                            
JRNL        TITL   CRYSTAL STRUCTURE OF A BIOLOGICALLY FUNCTIONAL               
JRNL        TITL 2 FORM OF PRIB FROM ESCHERICHIA COLI REVEALS A                 
JRNL        TITL 3 POTENTIAL SINGLE-STRANDED DNA-BINDING SITE                   
JRNL        REF    BIOCHEM.BIOPHYS.RES.COMMUN.   V. 326   766 2005              
JRNL        REFN   ASTM BBRCA9  US ISSN 0006-291X                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1WOC A    2   104  UNP    P07013   PRIB_ECOLI       1    103             
DBREF  1WOC B    2   104  UNP    P07013   PRIB_ECOLI       1    103             
DBREF  1WOC C    2   104  UNP    P07013   PRIB_ECOLI       1    103             
DBREF  1WOC D    2   104  UNP    P07013   PRIB_ECOLI       1    103             
SEQRES   1 A  103  THR ASN ARG LEU VAL LEU SER GLY THR VAL CYS ARG ALA          
SEQRES   2 A  103  PRO LEU ARG LYS VAL SER PRO SER GLY ILE PRO HIS CYS          
SEQRES   3 A  103  GLN PHE VAL LEU GLU HIS ARG SER VAL GLN GLU GLU ALA          
SEQRES   4 A  103  GLY PHE HIS ARG GLN ALA TRP CYS GLN MSE PRO VAL ILE          
SEQRES   5 A  103  VAL SER GLY HIS GLU ASN GLN ALA ILE THR HIS SER ILE          
SEQRES   6 A  103  THR VAL GLY SER ARG ILE THR VAL GLN GLY PHE ILE SER          
SEQRES   7 A  103  CYS HIS LYS ALA LYS ASN GLY LEU SER LYS MSE VAL LEU          
SEQRES   8 A  103  HIS ALA GLU GLN ILE GLU LEU ILE ASP SER GLY ASP              
SEQRES   1 B  103  THR ASN ARG LEU VAL LEU SER GLY THR VAL CYS ARG ALA          
SEQRES   2 B  103  PRO LEU ARG LYS VAL SER PRO SER GLY ILE PRO HIS CYS          
SEQRES   3 B  103  GLN PHE VAL LEU GLU HIS ARG SER VAL GLN GLU GLU ALA          
SEQRES   4 B  103  GLY PHE HIS ARG GLN ALA TRP CYS GLN MSE PRO VAL ILE          
SEQRES   5 B  103  VAL SER GLY HIS GLU ASN GLN ALA ILE THR HIS SER ILE          
SEQRES   6 B  103  THR VAL GLY SER ARG ILE THR VAL GLN GLY PHE ILE SER          
SEQRES   7 B  103  CYS HIS LYS ALA LYS ASN GLY LEU SER LYS MSE VAL LEU          
SEQRES   8 B  103  HIS ALA GLU GLN ILE GLU LEU ILE ASP SER GLY ASP              
SEQRES   1 C  103  THR ASN ARG LEU VAL LEU SER GLY THR VAL CYS ARG ALA          
SEQRES   2 C  103  PRO LEU ARG LYS VAL SER PRO SER GLY ILE PRO HIS CYS          
SEQRES   3 C  103  GLN PHE VAL LEU GLU HIS ARG SER VAL GLN GLU GLU ALA          
SEQRES   4 C  103  GLY PHE HIS ARG GLN ALA TRP CYS GLN MSE PRO VAL ILE          
SEQRES   5 C  103  VAL SER GLY HIS GLU ASN GLN ALA ILE THR HIS SER ILE          
SEQRES   6 C  103  THR VAL GLY SER ARG ILE THR VAL GLN GLY PHE ILE SER          
SEQRES   7 C  103  CYS HIS LYS ALA LYS ASN GLY LEU SER LYS MSE VAL LEU          
SEQRES   8 C  103  HIS ALA GLU GLN ILE GLU LEU ILE ASP SER GLY ASP              
SEQRES   1 D  103  THR ASN ARG LEU VAL LEU SER GLY THR VAL CYS ARG ALA          
SEQRES   2 D  103  PRO LEU ARG LYS VAL SER PRO SER GLY ILE PRO HIS CYS          
SEQRES   3 D  103  GLN PHE VAL LEU GLU HIS ARG SER VAL GLN GLU GLU ALA          
SEQRES   4 D  103  GLY PHE HIS ARG GLN ALA TRP CYS GLN MSE PRO VAL ILE          
SEQRES   5 D  103  VAL SER GLY HIS GLU ASN GLN ALA ILE THR HIS SER ILE          
SEQRES   6 D  103  THR VAL GLY SER ARG ILE THR VAL GLN GLY PHE ILE SER          
SEQRES   7 D  103  CYS HIS LYS ALA LYS ASN GLY LEU SER LYS MSE VAL LEU          
SEQRES   8 D  103  HIS ALA GLU GLN ILE GLU LEU ILE ASP SER GLY ASP              
HET    MSE  A  50       8                                                       
HET    MSE  A  90       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  90       8                                                       
HET    MSE  C  50       8                                                       
HET    MSE  C  90       8                                                       
HET    MSE  D  50       8                                                       
HET    MSE  D  90       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   5  HOH   *202(H2 O)                                                    
CRYST1  103.521   70.317   74.805  90.00 131.59  90.00 C 1 2 1      16          
ATOM   1533  N   THR C   2      26.205  26.344  24.591  1.00 15.71           N  
ATOM   1534  CA  THR C   2      25.665  27.054  25.788  1.00 18.90           C  
ATOM   1535  C   THR C   2      25.384  26.047  26.903  1.00 17.87           C  
ATOM   1536  O   THR C   2      24.659  25.074  26.699  1.00 19.10           O  
ATOM   1537  CB  THR C   2      24.344  27.798  25.450  1.00 20.27           C  
ATOM   1538  OG1 THR C   2      24.571  28.709  24.373  1.00 22.63           O  
ATOM   1539  CG2 THR C   2      23.835  28.573  26.664  1.00 23.55           C  
ATOM   1540  N   ASN C   3      25.957  26.285  28.080  1.00 17.07           N  
ATOM   1541  CA  ASN C   3      25.766  25.387  29.217  1.00 15.89           C  
ATOM   1542  C   ASN C   3      26.055  26.128  30.508  1.00 16.13           C  
ATOM   1543  O   ASN C   3      27.185  26.132  30.986  1.00 17.02           O  
ATOM   1544  CB  ASN C   3      26.695  24.172  29.094  1.00 16.18           C  
ATOM   1545  CG  ASN C   3      26.413  23.086  30.141  1.00 15.02           C  
ATOM   1546  OD1 ASN C   3      26.821  21.938  29.972  1.00 16.67           O  
ATOM   1547  ND2 ASN C   3      25.734  23.447  31.219  1.00 11.74           N  
ATOM   1548  N   ARG C   4      25.033  26.764  31.065  1.00 15.04           N  
ATOM   1549  CA  ARG C   4      25.202  27.491  32.309  1.00 16.90           C  
ATOM   1550  C   ARG C   4      23.988  27.381  33.214  1.00 16.88           C  
ATOM   1551  O   ARG C   4      22.863  27.704  32.814  1.00 17.57           O  
ATOM   1552  CB  ARG C   4      25.498  28.973  32.049  1.00 18.28           C  
ATOM   1553  CG  ARG C   4      25.833  29.716  33.333  1.00 24.26           C  
ATOM   1554  CD  ARG C   4      26.695  30.944  33.078  1.00 31.88           C  
ATOM   1555  NE  ARG C   4      25.921  32.143  32.770  1.00 32.95           N  
ATOM   1556  CZ  ARG C   4      26.470  33.327  32.506  1.00 38.45           C  
ATOM   1557  NH1 ARG C   4      27.793  33.460  32.512  1.00 38.15           N  
ATOM   1558  NH2 ARG C   4      25.702  34.380  32.246  1.00 39.47           N  
ATOM   1559  N   LEU C   5      24.227  26.914  34.435  1.00 13.15           N  
ATOM   1560  CA  LEU C   5      23.169  26.789  35.427  1.00 13.29           C  
ATOM   1561  C   LEU C   5      23.503  27.667  36.626  1.00 14.14           C  
ATOM   1562  O   LEU C   5      24.630  27.654  37.132  1.00 14.10           O  
ATOM   1563  CB  LEU C   5      23.014  25.338  35.897  1.00  9.06           C  
ATOM   1564  CG  LEU C   5      22.059  25.082  37.076  1.00 12.72           C  
ATOM   1565  CD1 LEU C   5      20.629  25.479  36.708  1.00 12.15           C  
ATOM   1566  CD2 LEU C   5      22.104  23.613  37.464  1.00  9.74           C  
ATOM   1567  N   VAL C   6      22.527  28.462  37.042  1.00 12.89           N  
ATOM   1568  CA  VAL C   6      22.669  29.308  38.211  1.00 13.81           C  
ATOM   1569  C   VAL C   6      21.578  28.754  39.126  1.00 14.26           C  
ATOM   1570  O   VAL C   6      20.396  28.800  38.780  1.00 14.24           O  
ATOM   1571  CB  VAL C   6      22.409  30.788  37.869  1.00 13.16           C  
ATOM   1572  CG1 VAL C   6      22.558  31.644  39.122  1.00 15.49           C  
ATOM   1573  CG2 VAL C   6      23.399  31.250  36.783  1.00 13.74           C  
ATOM   1574  N   LEU C   7      21.975  28.207  40.272  1.00 12.93           N  
ATOM   1575  CA  LEU C   7      21.014  27.601  41.183  1.00 13.45           C  
ATOM   1576  C   LEU C   7      21.258  27.899  42.662  1.00 14.42           C  
ATOM   1577  O   LEU C   7      22.317  27.580  43.197  1.00 14.56           O  
ATOM   1578  CB  LEU C   7      21.024  26.086  40.979  1.00 11.28           C  
ATOM   1579  CG  LEU C   7      19.962  25.296  41.742  1.00 13.39           C  
ATOM   1580  CD1 LEU C   7      18.576  25.559  41.140  1.00 11.67           C  
ATOM   1581  CD2 LEU C   7      20.307  23.833  41.676  1.00 12.19           C  
ATOM   1582  N   SER C   8      20.267  28.495  43.318  1.00 14.64           N  
ATOM   1583  CA  SER C   8      20.372  28.819  44.736  1.00 17.90           C  
ATOM   1584  C   SER C   8      19.837  27.652  45.559  1.00 19.53           C  
ATOM   1585  O   SER C   8      19.011  26.869  45.084  1.00 19.80           O  
ATOM   1586  CB  SER C   8      19.569  30.084  45.050  1.00 18.17           C  
ATOM   1587  OG  SER C   8      18.215  29.922  44.656  1.00 22.33           O  
ATOM   1588  N   GLY C   9      20.301  27.523  46.795  1.00 19.31           N  
ATOM   1589  CA  GLY C   9      19.811  26.431  47.614  1.00 21.13           C  
ATOM   1590  C   GLY C   9      20.477  26.313  48.966  1.00 21.88           C  
ATOM   1591  O   GLY C   9      21.173  27.227  49.409  1.00 20.91           O  
ATOM   1592  N   THR C  10      20.253  25.176  49.616  1.00 21.49           N  
ATOM   1593  CA  THR C  10      20.826  24.896  50.924  1.00 21.80           C  
ATOM   1594  C   THR C  10      21.567  23.583  50.831  1.00 22.04           C  
ATOM   1595  O   THR C  10      21.021  22.587  50.354  1.00 23.33           O  
ATOM   1596  CB  THR C  10      19.727  24.779  52.006  1.00 21.03           C  
ATOM   1597  OG1 THR C  10      18.999  26.008  52.069  1.00 18.54           O  
ATOM   1598  CG2 THR C  10      20.340  24.494  53.373  1.00 20.25           C  
ATOM   1599  N   VAL C  11      22.818  23.580  51.278  1.00 21.42           N  
ATOM   1600  CA  VAL C  11      23.624  22.375  51.236  1.00 22.29           C  
ATOM   1601  C   VAL C  11      23.004  21.336  52.160  1.00 25.85           C  
ATOM   1602  O   VAL C  11      22.989  21.509  53.379  1.00 26.96           O  
ATOM   1603  CB  VAL C  11      25.076  22.680  51.652  1.00 20.81           C  
ATOM   1604  CG1 VAL C  11      25.899  21.411  51.653  1.00 19.94           C  
ATOM   1605  CG2 VAL C  11      25.677  23.699  50.688  1.00 21.28           C  
ATOM   1606  N   CYS C  12      22.494  20.256  51.566  1.00 28.55           N  
ATOM   1607  CA  CYS C  12      21.829  19.202  52.318  1.00 29.52           C  
ATOM   1608  C   CYS C  12      22.672  17.959  52.553  1.00 32.00           C  
ATOM   1609  O   CYS C  12      22.208  16.995  53.169  1.00 32.90           O  
ATOM   1610  CB  CYS C  12      20.508  18.826  51.633  1.00 28.14           C  
ATOM   1611  SG  CYS C  12      20.643  18.197  49.946  1.00 26.38           S  
ATOM   1612  N   ARG C  13      23.909  17.985  52.064  1.00 33.88           N  
ATOM   1613  CA  ARG C  13      24.853  16.883  52.244  1.00 35.39           C  
ATOM   1614  C   ARG C  13      26.221  17.465  52.571  1.00 36.42           C  
ATOM   1615  O   ARG C  13      26.778  18.229  51.776  1.00 37.81           O  
ATOM   1616  CB  ARG C  13      24.967  16.038  50.973  1.00 36.11           C  
ATOM   1617  CG  ARG C  13      24.243  14.703  51.026  1.00 37.49           C  
ATOM   1618  CD  ARG C  13      22.765  14.889  51.293  1.00 39.51           C  
ATOM   1619  NE  ARG C  13      22.007  13.653  51.126  1.00 42.01           N  
ATOM   1620  CZ  ARG C  13      20.704  13.546  51.359  1.00 42.78           C  
ATOM   1621  NH1 ARG C  13      20.089  12.386  51.179  1.00 43.94           N  
ATOM   1622  NH2 ARG C  13      20.015  14.599  51.781  1.00 41.93           N  
ATOM   1623  N   ALA C  14      26.758  17.107  53.737  1.00 34.70           N  
ATOM   1624  CA  ALA C  14      28.065  17.592  54.159  1.00 33.60           C  
ATOM   1625  C   ALA C  14      29.080  17.334  53.046  1.00 31.23           C  
ATOM   1626  O   ALA C  14      29.052  16.291  52.395  1.00 31.91           O  
ATOM   1627  CB  ALA C  14      28.495  16.891  55.439  1.00 34.27           C  
ATOM   1628  N   PRO C  15      29.995  18.283  52.822  1.00 29.69           N  
ATOM   1629  CA  PRO C  15      31.014  18.155  51.776  1.00 26.53           C  
ATOM   1630  C   PRO C  15      31.945  16.970  51.951  1.00 24.57           C  
ATOM   1631  O   PRO C  15      32.411  16.684  53.055  1.00 25.30           O  
ATOM   1632  CB  PRO C  15      31.773  19.479  51.860  1.00 26.29           C  
ATOM   1633  CG  PRO C  15      30.791  20.414  52.499  1.00 28.49           C  
ATOM   1634  CD  PRO C  15      30.158  19.553  53.548  1.00 29.04           C  
ATOM   1635  N   LEU C  16      32.203  16.281  50.847  1.00 21.29           N  
ATOM   1636  CA  LEU C  16      33.108  15.148  50.832  1.00 22.01           C  
ATOM   1637  C   LEU C  16      34.339  15.628  50.068  1.00 21.16           C  
ATOM   1638  O   LEU C  16      34.234  16.031  48.903  1.00 19.71           O  
ATOM   1639  CB  LEU C  16      32.468  13.964  50.111  1.00 22.40           C  
ATOM   1640  CG  LEU C  16      33.369  12.762  49.836  1.00 26.68           C  
ATOM   1641  CD1 LEU C  16      33.941  12.209  51.144  1.00 28.47           C  
ATOM   1642  CD2 LEU C  16      32.561  11.701  49.105  1.00 28.46           C  
ATOM   1643  N   ARG C  17      35.496  15.608  50.723  1.00 17.12           N  
ATOM   1644  CA  ARG C  17      36.722  16.063  50.075  1.00 17.59           C  
ATOM   1645  C   ARG C  17      37.598  14.892  49.676  1.00 17.34           C  
ATOM   1646  O   ARG C  17      37.859  13.991  50.476  1.00 18.71           O  
ATOM   1647  CB  ARG C  17      37.501  17.026  50.992  1.00 14.43           C  
ATOM   1648  CG  ARG C  17      36.759  18.320  51.280  1.00 13.18           C  
ATOM   1649  CD  ARG C  17      37.559  19.266  52.166  1.00 14.33           C  
ATOM   1650  NE  ARG C  17      36.768  20.437  52.550  1.00 15.32           N  
ATOM   1651  CZ  ARG C  17      36.368  21.387  51.707  1.00 15.59           C  
ATOM   1652  NH1 ARG C  17      35.644  22.406  52.148  1.00 14.59           N  
ATOM   1653  NH2 ARG C  17      36.699  21.327  50.423  1.00 17.11           N  
ATOM   1654  N   LYS C  18      38.048  14.915  48.427  1.00 16.62           N  
ATOM   1655  CA  LYS C  18      38.886  13.852  47.897  1.00 16.15           C  
ATOM   1656  C   LYS C  18      40.097  14.400  47.153  1.00 14.18           C  
ATOM   1657  O   LYS C  18      40.117  15.548  46.725  1.00 13.60           O  
ATOM   1658  CB  LYS C  18      38.081  12.983  46.922  1.00 21.75           C  
ATOM   1659  CG  LYS C  18      36.802  12.382  47.480  1.00 23.99           C  
ATOM   1660  CD  LYS C  18      36.012  11.757  46.342  1.00 30.33           C  
ATOM   1661  CE  LYS C  18      34.787  10.995  46.819  1.00 31.55           C  
ATOM   1662  NZ  LYS C  18      33.993  10.503  45.652  1.00 33.59           N  
ATOM   1663  N   VAL C  19      41.099  13.548  47.005  1.00 14.44           N  
ATOM   1664  CA  VAL C  19      42.320  13.869  46.279  1.00 16.04           C  
ATOM   1665  C   VAL C  19      42.500  12.684  45.326  1.00 17.07           C  
ATOM   1666  O   VAL C  19      42.675  11.548  45.774  1.00 17.17           O  
ATOM   1667  CB  VAL C  19      43.550  13.949  47.222  1.00 13.58           C  
ATOM   1668  CG1 VAL C  19      44.813  14.195  46.416  1.00 16.46           C  
ATOM   1669  CG2 VAL C  19      43.356  15.059  48.243  1.00 13.16           C  
ATOM   1670  N   SER C  20      42.434  12.935  44.021  1.00 17.24           N  
ATOM   1671  CA  SER C  20      42.586  11.849  43.056  1.00 18.19           C  
ATOM   1672  C   SER C  20      44.019  11.329  43.092  1.00 19.41           C  
ATOM   1673  O   SER C  20      44.918  12.015  43.579  1.00 20.00           O  
ATOM   1674  CB  SER C  20      42.244  12.336  41.643  1.00 18.60           C  
ATOM   1675  OG  SER C  20      43.162  13.323  41.204  1.00 19.80           O  
ATOM   1676  N   PRO C  21      44.249  10.107  42.576  1.00 19.09           N  
ATOM   1677  CA  PRO C  21      45.585   9.505  42.558  1.00 19.68           C  
ATOM   1678  C   PRO C  21      46.602  10.426  41.876  1.00 19.59           C  
ATOM   1679  O   PRO C  21      47.788  10.407  42.197  1.00 17.60           O  
ATOM   1680  CB  PRO C  21      45.371   8.207  41.777  1.00 21.67           C  
ATOM   1681  CG  PRO C  21      43.915   7.876  42.042  1.00 20.15           C  
ATOM   1682  CD  PRO C  21      43.263   9.221  41.925  1.00 21.12           C  
ATOM   1683  N   SER C  22      46.110  11.227  40.939  1.00 18.58           N  
ATOM   1684  CA  SER C  22      46.929  12.169  40.188  1.00 20.48           C  
ATOM   1685  C   SER C  22      47.269  13.425  40.996  1.00 20.22           C  
ATOM   1686  O   SER C  22      48.133  14.206  40.602  1.00 16.68           O  
ATOM   1687  CB  SER C  22      46.195  12.569  38.910  1.00 22.13           C  
ATOM   1688  OG  SER C  22      46.844  13.636  38.252  1.00 30.57           O  
ATOM   1689  N   GLY C  23      46.568  13.631  42.108  1.00 19.39           N  
ATOM   1690  CA  GLY C  23      46.849  14.783  42.947  1.00 18.42           C  
ATOM   1691  C   GLY C  23      45.867  15.926  42.802  1.00 20.12           C  
ATOM   1692  O   GLY C  23      46.076  16.997  43.373  1.00 19.48           O  
ATOM   1693  N   ILE C  24      44.800  15.713  42.035  1.00 19.66           N  
ATOM   1694  CA  ILE C  24      43.805  16.758  41.833  1.00 20.54           C  
ATOM   1695  C   ILE C  24      42.695  16.646  42.883  1.00 18.23           C  
ATOM   1696  O   ILE C  24      42.066  15.601  43.033  1.00 17.20           O  
ATOM   1697  CB  ILE C  24      43.180  16.671  40.421  1.00 22.70           C  
ATOM   1698  CG1 ILE C  24      44.286  16.640  39.361  1.00 25.01           C  
ATOM   1699  CG2 ILE C  24      42.274  17.864  40.180  1.00 21.92           C  
ATOM   1700  CD1 ILE C  24      45.181  17.874  39.370  1.00 25.63           C  
ATOM   1701  N   PRO C  25      42.445  17.731  43.622  1.00 17.60           N  
ATOM   1702  CA  PRO C  25      41.405  17.718  44.650  1.00 19.32           C  
ATOM   1703  C   PRO C  25      40.011  18.080  44.148  1.00 19.73           C  
ATOM   1704  O   PRO C  25      39.848  18.820  43.177  1.00 20.25           O  
ATOM   1705  CB  PRO C  25      41.909  18.753  45.639  1.00 19.04           C  
ATOM   1706  CG  PRO C  25      42.443  19.812  44.709  1.00 17.50           C  
ATOM   1707  CD  PRO C  25      43.215  18.987  43.677  1.00 17.79           C  
ATOM   1708  N   HIS C  26      39.004  17.539  44.811  1.00 19.40           N  
ATOM   1709  CA  HIS C  26      37.637  17.886  44.483  1.00 22.28           C  
ATOM   1710  C   HIS C  26      36.746  17.768  45.710  1.00 20.13           C  
ATOM   1711  O   HIS C  26      36.947  16.911  46.576  1.00 20.09           O  
ATOM   1712  CB  HIS C  26      37.089  17.077  43.294  1.00 25.86           C  
ATOM   1713  CG  HIS C  26      37.025  15.601  43.515  1.00 28.88           C  
ATOM   1714  ND1 HIS C  26      38.115  14.773  43.344  1.00 31.47           N  
ATOM   1715  CD2 HIS C  26      35.978  14.793  43.812  1.00 29.47           C  
ATOM   1716  CE1 HIS C  26      37.740  13.518  43.521  1.00 32.85           C  
ATOM   1717  NE2 HIS C  26      36.448  13.503  43.804  1.00 31.10           N  
ATOM   1718  N   CYS C  27      35.802  18.692  45.791  1.00 19.02           N  
ATOM   1719  CA  CYS C  27      34.853  18.779  46.885  1.00 19.59           C  
ATOM   1720  C   CYS C  27      33.450  18.512  46.333  1.00 18.81           C  
ATOM   1721  O   CYS C  27      32.982  19.226  45.444  1.00 18.13           O  
ATOM   1722  CB  CYS C  27      34.926  20.182  47.504  1.00 17.18           C  
ATOM   1723  SG  CYS C  27      33.739  20.503  48.822  1.00 21.14           S  
ATOM   1724  N   GLN C  28      32.791  17.488  46.873  1.00 19.51           N  
ATOM   1725  CA  GLN C  28      31.453  17.101  46.445  1.00 20.48           C  
ATOM   1726  C   GLN C  28      30.423  17.268  47.564  1.00 20.92           C  
ATOM   1727  O   GLN C  28      30.683  16.931  48.722  1.00 19.53           O  
ATOM   1728  CB  GLN C  28      31.438  15.629  46.011  1.00 23.30           C  
ATOM   1729  CG  GLN C  28      32.626  15.181  45.186  1.00 28.27           C  
ATOM   1730  CD  GLN C  28      32.567  13.699  44.831  1.00 32.43           C  
ATOM   1731  OE1 GLN C  28      32.586  12.831  45.708  1.00 33.48           O  
ATOM   1732  NE2 GLN C  28      32.494  13.407  43.538  1.00 31.89           N  
ATOM   1733  N   PHE C  29      29.254  17.783  47.202  1.00 19.27           N  
ATOM   1734  CA  PHE C  29      28.151  17.957  48.141  1.00 18.94           C  
ATOM   1735  C   PHE C  29      26.851  18.023  47.343  1.00 18.89           C  
ATOM   1736  O   PHE C  29      26.872  17.980  46.106  1.00 18.02           O  
ATOM   1737  CB  PHE C  29      28.324  19.222  49.004  1.00 15.71           C  
ATOM   1738  CG  PHE C  29      28.425  20.509  48.223  1.00 16.05           C  
ATOM   1739  CD1 PHE C  29      29.661  20.976  47.778  1.00 16.00           C  
ATOM   1740  CD2 PHE C  29      27.292  21.279  47.972  1.00 15.20           C  
ATOM   1741  CE1 PHE C  29      29.769  22.192  47.103  1.00 13.93           C  
ATOM   1742  CE2 PHE C  29      27.384  22.493  47.297  1.00 13.56           C  
ATOM   1743  CZ  PHE C  29      28.627  22.955  46.862  1.00 16.38           C  
ATOM   1744  N   VAL C  30      25.724  18.102  48.045  1.00 18.28           N  
ATOM   1745  CA  VAL C  30      24.416  18.167  47.395  1.00 17.02           C  
ATOM   1746  C   VAL C  30      23.672  19.439  47.780  1.00 17.44           C  
ATOM   1747  O   VAL C  30      23.500  19.753  48.966  1.00 17.32           O  
ATOM   1748  CB  VAL C  30      23.554  16.945  47.757  1.00 18.05           C  
ATOM   1749  CG1 VAL C  30      22.204  17.019  47.043  1.00 16.94           C  
ATOM   1750  CG2 VAL C  30      24.286  15.679  47.377  1.00 17.68           C  
ATOM   1751  N   LEU C  31      23.236  20.171  46.760  1.00 16.83           N  
ATOM   1752  CA  LEU C  31      22.521  21.422  46.944  1.00 16.08           C  
ATOM   1753  C   LEU C  31      21.027  21.226  46.749  1.00 18.74           C  
ATOM   1754  O   LEU C  31      20.573  20.830  45.669  1.00 17.24           O  
ATOM   1755  CB  LEU C  31      23.041  22.469  45.952  1.00 15.05           C  
ATOM   1756  CG  LEU C  31      22.371  23.846  45.950  1.00 16.73           C  
ATOM   1757  CD1 LEU C  31      22.608  24.521  47.290  1.00 19.13           C  
ATOM   1758  CD2 LEU C  31      22.943  24.710  44.824  1.00 17.59           C  
ATOM   1759  N   GLU C  32      20.253  21.507  47.794  1.00 20.68           N  
ATOM   1760  CA  GLU C  32      18.808  21.360  47.694  1.00 22.18           C  
ATOM   1761  C   GLU C  32      18.140  22.685  47.383  1.00 21.56           C  
ATOM   1762  O   GLU C  32      18.241  23.646  48.149  1.00 21.94           O  
ATOM   1763  CB  GLU C  32      18.219  20.781  48.979  1.00 23.02           C  
ATOM   1764  CG  GLU C  32      16.707  20.623  48.911  1.00 26.24           C  
ATOM   1765  CD  GLU C  32      16.181  19.612  49.907  1.00 29.46           C  
ATOM   1766  OE1 GLU C  32      14.970  19.320  49.868  1.00 32.49           O  
ATOM   1767  OE2 GLU C  32      16.978  19.104  50.725  1.00 31.28           O  
ATOM   1768  N   HIS C  33      17.462  22.722  46.244  1.00 19.95           N  
ATOM   1769  CA  HIS C  33      16.762  23.913  45.801  1.00 19.88           C  
ATOM   1770  C   HIS C  33      15.255  23.717  45.941  1.00 22.39           C  
ATOM   1771  O   HIS C  33      14.735  22.624  45.721  1.00 22.49           O  
ATOM   1772  CB  HIS C  33      17.084  24.204  44.336  1.00 16.86           C  
ATOM   1773  CG  HIS C  33      16.239  25.286  43.746  1.00 14.80           C  
ATOM   1774  ND1 HIS C  33      16.514  26.623  43.918  1.00 16.08           N  
ATOM   1775  CD2 HIS C  33      15.081  25.226  43.048  1.00 15.95           C  
ATOM   1776  CE1 HIS C  33      15.560  27.343  43.354  1.00 19.97           C  
ATOM   1777  NE2 HIS C  33      14.678  26.518  42.818  1.00 19.45           N  
ATOM   1778  N   ARG C  34      14.571  24.796  46.300  1.00 24.56           N  
ATOM   1779  CA  ARG C  34      13.128  24.797  46.458  1.00 27.00           C  
ATOM   1780  C   ARG C  34      12.648  26.193  46.134  1.00 26.55           C  
ATOM   1781  O   ARG C  34      13.132  27.167  46.707  1.00 26.64           O  
ATOM   1782  CB  ARG C  34      12.747  24.446  47.892  1.00 30.65           C  
ATOM   1783  CG  ARG C  34      12.902  22.979  48.232  1.00 35.37           C  
ATOM   1784  CD  ARG C  34      12.589  22.735  49.702  1.00 39.26           C  
ATOM   1785  NE  ARG C  34      12.207  21.350  49.956  1.00 40.52           N  
ATOM   1786  CZ  ARG C  34      11.067  20.808  49.544  1.00 41.27           C  
ATOM   1787  NH1 ARG C  34      10.802  19.539  49.822  1.00 42.53           N  
ATOM   1788  NH2 ARG C  34      10.188  21.538  48.862  1.00 41.88           N  
ATOM   1789  N   SER C  35      11.699  26.293  45.210  1.00 25.45           N  
ATOM   1790  CA  SER C  35      11.171  27.592  44.817  1.00 25.28           C  
ATOM   1791  C   SER C  35       9.833  27.467  44.115  1.00 25.62           C  
ATOM   1792  O   SER C  35       9.380  26.369  43.803  1.00 25.59           O  
ATOM   1793  CB  SER C  35      12.154  28.301  43.877  1.00 24.47           C  
ATOM   1794  OG  SER C  35      12.366  27.542  42.695  1.00 21.47           O  
ATOM   1795  N   VAL C  36       9.209  28.611  43.874  1.00 27.51           N  
ATOM   1796  CA  VAL C  36       7.941  28.659  43.173  1.00 30.63           C  
ATOM   1797  C   VAL C  36       8.232  29.349  41.848  1.00 31.83           C  
ATOM   1798  O   VAL C  36       8.862  30.406  41.817  1.00 32.72           O  
ATOM   1799  CB  VAL C  36       6.893  29.471  43.952  1.00 31.53           C  
ATOM   1800  CG1 VAL C  36       5.562  29.455  43.203  1.00 30.28           C  
ATOM   1801  CG2 VAL C  36       6.729  28.890  45.353  1.00 32.07           C  
ATOM   1802  N   GLN C  37       7.782  28.740  40.757  1.00 32.60           N  
ATOM   1803  CA  GLN C  37       8.011  29.285  39.426  1.00 35.20           C  
ATOM   1804  C   GLN C  37       6.686  29.391  38.670  1.00 37.48           C  
ATOM   1805  O   GLN C  37       5.848  28.490  38.744  1.00 37.47           O  
ATOM   1806  CB  GLN C  37       8.973  28.365  38.657  1.00 33.92           C  
ATOM   1807  CG  GLN C  37      10.241  29.028  38.119  1.00 33.69           C  
ATOM   1808  CD  GLN C  37      11.252  29.382  39.195  1.00 33.35           C  
ATOM   1809  OE1 GLN C  37      11.588  28.563  40.046  1.00 35.45           O  
ATOM   1810  NE2 GLN C  37      11.757  30.607  39.147  1.00 36.31           N  
ATOM   1811  N   GLU C  38       6.488  30.495  37.956  1.00 40.64           N  
ATOM   1812  CA  GLU C  38       5.268  30.666  37.175  1.00 43.48           C  
ATOM   1813  C   GLU C  38       5.429  29.827  35.914  1.00 44.56           C  
ATOM   1814  O   GLU C  38       6.506  29.791  35.316  1.00 44.89           O  
ATOM   1815  CB  GLU C  38       5.060  32.136  36.799  1.00 46.15           C  
ATOM   1816  CG  GLU C  38       3.836  32.389  35.917  1.00 49.92           C  
ATOM   1817  CD  GLU C  38       4.062  32.006  34.458  1.00 52.85           C  
ATOM   1818  OE1 GLU C  38       3.064  31.870  33.715  1.00 53.92           O  
ATOM   1819  OE2 GLU C  38       5.236  31.852  34.053  1.00 52.91           O  
ATOM   1820  N   GLU C  39       4.364  29.144  35.511  1.00 45.12           N  
ATOM   1821  CA  GLU C  39       4.431  28.313  34.319  1.00 44.39           C  
ATOM   1822  C   GLU C  39       3.045  28.003  33.768  1.00 44.25           C  
ATOM   1823  O   GLU C  39       2.223  27.376  34.441  1.00 43.03           O  
ATOM   1824  CB  GLU C  39       5.166  27.008  34.636  1.00 44.09           C  
ATOM   1825  CG  GLU C  39       5.461  26.148  33.419  1.00 43.71           C  
ATOM   1826  CD  GLU C  39       5.889  24.747  33.793  1.00 43.94           C  
ATOM   1827  OE1 GLU C  39       6.308  23.990  32.894  1.00 42.84           O  
ATOM   1828  OE2 GLU C  39       5.800  24.404  34.991  1.00 45.88           O  
ATOM   1829  N   ALA C  40       2.795  28.447  32.541  1.00 44.91           N  
ATOM   1830  CA  ALA C  40       1.515  28.216  31.880  1.00 45.41           C  
ATOM   1831  C   ALA C  40       0.346  28.787  32.676  1.00 45.06           C  
ATOM   1832  O   ALA C  40      -0.744  28.219  32.682  1.00 45.67           O  
ATOM   1833  CB  ALA C  40       1.310  26.714  31.653  1.00 45.08           C  
ATOM   1834  N   GLY C  41       0.578  29.912  33.345  1.00 45.29           N  
ATOM   1835  CA  GLY C  41      -0.476  30.534  34.128  1.00 45.30           C  
ATOM   1836  C   GLY C  41      -0.655  29.940  35.514  1.00 45.84           C  
ATOM   1837  O   GLY C  41      -1.644  30.220  36.195  1.00 45.47           O  
ATOM   1838  N   PHE C  42       0.294  29.112  35.937  1.00 45.46           N  
ATOM   1839  CA  PHE C  42       0.225  28.494  37.255  1.00 45.69           C  
ATOM   1840  C   PHE C  42       1.553  28.561  38.000  1.00 45.06           C  
ATOM   1841  O   PHE C  42       2.627  28.564  37.391  1.00 44.57           O  
ATOM   1842  CB  PHE C  42      -0.213  27.030  37.149  1.00 46.70           C  
ATOM   1843  CG  PHE C  42      -1.693  26.848  36.981  1.00 47.42           C  
ATOM   1844  CD1 PHE C  42      -2.313  27.128  35.770  1.00 48.25           C  
ATOM   1845  CD2 PHE C  42      -2.473  26.411  38.046  1.00 48.52           C  
ATOM   1846  CE1 PHE C  42      -3.691  26.975  35.619  1.00 48.89           C  
ATOM   1847  CE2 PHE C  42      -3.852  26.254  37.909  1.00 49.23           C  
ATOM   1848  CZ  PHE C  42      -4.463  26.537  36.692  1.00 49.30           C  
ATOM   1849  N   HIS C  43       1.471  28.628  39.324  1.00 44.71           N  
ATOM   1850  CA  HIS C  43       2.663  28.662  40.157  1.00 42.99           C  
ATOM   1851  C   HIS C  43       3.011  27.226  40.482  1.00 41.03           C  
ATOM   1852  O   HIS C  43       2.230  26.514  41.110  1.00 41.19           O  
ATOM   1853  CB  HIS C  43       2.410  29.447  41.447  1.00 45.34           C  
ATOM   1854  CG  HIS C  43       2.552  30.930  41.289  1.00 47.15           C  
ATOM   1855  ND1 HIS C  43       2.146  31.823  42.256  1.00 47.68           N  
ATOM   1856  CD2 HIS C  43       3.058  31.675  40.277  1.00 48.02           C  
ATOM   1857  CE1 HIS C  43       2.394  33.056  41.847  1.00 48.54           C  
ATOM   1858  NE2 HIS C  43       2.947  32.993  40.649  1.00 48.56           N  
ATOM   1859  N   ARG C  44       4.182  26.794  40.032  1.00 38.80           N  
ATOM   1860  CA  ARG C  44       4.617  25.432  40.280  1.00 36.92           C  
ATOM   1861  C   ARG C  44       5.799  25.417  41.232  1.00 35.10           C  
ATOM   1862  O   ARG C  44       6.594  26.352  41.277  1.00 34.57           O  
ATOM   1863  CB  ARG C  44       5.003  24.743  38.967  1.00 36.17           C  
ATOM   1864  CG  ARG C  44       3.900  24.728  37.921  1.00 34.76           C  
ATOM   1865  CD  ARG C  44       2.669  23.990  38.410  1.00 34.40           C  
ATOM   1866  NE  ARG C  44       1.607  24.004  37.409  1.00 35.26           N  
ATOM   1867  CZ  ARG C  44       0.398  23.481  37.590  1.00 34.42           C  
ATOM   1868  NH1 ARG C  44      -0.505  23.544  36.620  1.00 32.98           N  
ATOM   1869  NH2 ARG C  44       0.092  22.898  38.740  1.00 32.00           N  
ATOM   1870  N   GLN C  45       5.892  24.342  41.998  1.00 34.25           N  
ATOM   1871  CA  GLN C  45       6.966  24.153  42.955  1.00 32.90           C  
ATOM   1872  C   GLN C  45       8.119  23.467  42.229  1.00 30.49           C  
ATOM   1873  O   GLN C  45       7.956  22.371  41.692  1.00 29.94           O  
ATOM   1874  CB  GLN C  45       6.475  23.266  44.101  1.00 35.01           C  
ATOM   1875  CG  GLN C  45       7.563  22.761  45.037  1.00 40.99           C  
ATOM   1876  CD  GLN C  45       7.644  23.554  46.328  1.00 43.70           C  
ATOM   1877  OE1 GLN C  45       8.399  23.203  47.235  1.00 48.09           O  
ATOM   1878  NE2 GLN C  45       6.865  24.629  46.418  1.00 45.13           N  
ATOM   1879  N   ALA C  46       9.272  24.127  42.192  1.00 27.24           N  
ATOM   1880  CA  ALA C  46      10.454  23.556  41.557  1.00 23.56           C  
ATOM   1881  C   ALA C  46      11.303  22.986  42.689  1.00 22.19           C  
ATOM   1882  O   ALA C  46      11.502  23.645  43.710  1.00 21.24           O  
ATOM   1883  CB  ALA C  46      11.219  24.631  40.801  1.00 21.75           C  
ATOM   1884  N   TRP C  47      11.788  21.763  42.522  1.00 20.86           N  
ATOM   1885  CA  TRP C  47      12.588  21.140  43.565  1.00 21.36           C  
ATOM   1886  C   TRP C  47      13.608  20.156  43.046  1.00 19.74           C  
ATOM   1887  O   TRP C  47      13.357  19.422  42.087  1.00 20.46           O  
ATOM   1888  CB  TRP C  47      11.676  20.405  44.561  1.00 22.37           C  
ATOM   1889  CG  TRP C  47      12.435  19.554  45.544  1.00 22.45           C  
ATOM   1890  CD1 TRP C  47      12.933  19.940  46.766  1.00 22.47           C  
ATOM   1891  CD2 TRP C  47      12.853  18.199  45.355  1.00 22.84           C  
ATOM   1892  NE1 TRP C  47      13.636  18.909  47.339  1.00 19.21           N  
ATOM   1893  CE2 TRP C  47      13.604  17.827  46.497  1.00 23.61           C  
ATOM   1894  CE3 TRP C  47      12.671  17.260  44.331  1.00 24.13           C  
ATOM   1895  CZ2 TRP C  47      14.171  16.556  46.640  1.00 22.83           C  
ATOM   1896  CZ3 TRP C  47      13.235  15.995  44.475  1.00 23.44           C  
ATOM   1897  CH2 TRP C  47      13.976  15.657  45.622  1.00 24.88           C  
ATOM   1898  N   CYS C  48      14.765  20.130  43.696  1.00 18.87           N  
ATOM   1899  CA  CYS C  48      15.799  19.187  43.321  1.00 17.86           C  
ATOM   1900  C   CYS C  48      16.970  19.187  44.273  1.00 18.36           C  
ATOM   1901  O   CYS C  48      17.259  20.182  44.950  1.00 18.42           O  
ATOM   1902  CB  CYS C  48      16.318  19.463  41.904  1.00 19.62           C  
ATOM   1903  SG  CYS C  48      17.269  20.980  41.729  1.00 22.99           S  
ATOM   1904  N   GLN C  49      17.632  18.044  44.328  1.00 16.92           N  
ATOM   1905  CA  GLN C  49      18.816  17.892  45.145  1.00 19.81           C  
ATOM   1906  C   GLN C  49      19.902  17.667  44.111  1.00 18.15           C  
ATOM   1907  O   GLN C  49      20.105  16.559  43.622  1.00 18.18           O  
ATOM   1908  CB  GLN C  49      18.677  16.700  46.081  1.00 20.98           C  
ATOM   1909  CG  GLN C  49      17.503  16.862  47.044  1.00 25.29           C  
ATOM   1910  CD  GLN C  49      17.570  15.904  48.208  1.00 26.36           C  
ATOM   1911  OE1 GLN C  49      17.872  14.729  48.035  1.00 30.38           O  
ATOM   1912  NE2 GLN C  49      17.278  16.403  49.405  1.00 30.67           N  
HETATM 1913  N   MSE C  50      20.568  18.758  43.766  1.00 17.69           N  
HETATM 1914  CA  MSE C  50      21.623  18.762  42.764  1.00 14.69           C  
HETATM 1915  C   MSE C  50      23.003  18.401  43.301  1.00 14.00           C  
HETATM 1916  O   MSE C  50      23.519  19.062  44.217  1.00 15.53           O  
HETATM 1917  CB  MSE C  50      21.683  20.154  42.136  1.00 16.91           C  
HETATM 1918  CG  MSE C  50      22.783  20.319  41.102  1.00 19.63           C  
HETATM 1919 SE   MSE C  50      22.421  19.178  39.577  1.00 26.58          SE  
HETATM 1920  CE  MSE C  50      21.188  20.344  38.711  1.00 19.56           C  
ATOM   1921  N   PRO C  51      23.615  17.333  42.770  1.00 13.48           N  
ATOM   1922  CA  PRO C  51      24.949  17.026  43.290  1.00 13.90           C  
ATOM   1923  C   PRO C  51      25.858  18.116  42.712  1.00 16.75           C  
ATOM   1924  O   PRO C  51      25.695  18.506  41.552  1.00 16.07           O  
ATOM   1925  CB  PRO C  51      25.256  15.658  42.687  1.00 13.29           C  
ATOM   1926  CG  PRO C  51      23.883  15.057  42.465  1.00 12.61           C  
ATOM   1927  CD  PRO C  51      23.115  16.234  41.926  1.00 11.17           C  
ATOM   1928  N   VAL C  52      26.785  18.626  43.515  1.00 15.98           N  
ATOM   1929  CA  VAL C  52      27.698  19.669  43.049  1.00 15.82           C  
ATOM   1930  C   VAL C  52      29.133  19.203  43.255  1.00 16.52           C  
ATOM   1931  O   VAL C  52      29.449  18.564  44.266  1.00 14.79           O  
ATOM   1932  CB  VAL C  52      27.484  21.009  43.818  1.00 16.27           C  
ATOM   1933  CG1 VAL C  52      28.532  22.037  43.405  1.00 13.51           C  
ATOM   1934  CG2 VAL C  52      26.087  21.551  43.543  1.00 15.06           C  
ATOM   1935  N   ILE C  53      29.988  19.486  42.275  1.00 14.38           N  
ATOM   1936  CA  ILE C  53      31.397  19.125  42.366  1.00 16.20           C  
ATOM   1937  C   ILE C  53      32.243  20.371  42.121  1.00 14.61           C  
ATOM   1938  O   ILE C  53      31.987  21.133  41.187  1.00 12.98           O  
ATOM   1939  CB  ILE C  53      31.791  18.065  41.328  1.00 18.63           C  
ATOM   1940  CG1 ILE C  53      30.781  16.913  41.351  1.00 24.77           C  
ATOM   1941  CG2 ILE C  53      33.185  17.513  41.648  1.00 18.21           C  
ATOM   1942  CD1 ILE C  53      30.702  16.179  42.667  1.00 28.67           C  
ATOM   1943  N   VAL C  54      33.230  20.588  42.986  1.00 14.54           N  
ATOM   1944  CA  VAL C  54      34.131  21.729  42.866  1.00 14.49           C  
ATOM   1945  C   VAL C  54      35.498  21.092  42.666  1.00 15.17           C  
ATOM   1946  O   VAL C  54      36.028  20.457  43.583  1.00 15.29           O  
ATOM   1947  CB  VAL C  54      34.111  22.591  44.151  1.00 14.69           C  
ATOM   1948  CG1 VAL C  54      34.995  23.833  43.980  1.00 12.57           C  
ATOM   1949  CG2 VAL C  54      32.682  23.002  44.469  1.00 12.20           C  
ATOM   1950  N   SER C  55      36.066  21.261  41.473  1.00 14.45           N  
ATOM   1951  CA  SER C  55      37.349  20.635  41.145  1.00 16.95           C  
ATOM   1952  C   SER C  55      38.549  21.539  40.862  1.00 16.81           C  
ATOM   1953  O   SER C  55      38.399  22.654  40.357  1.00 15.00           O  
ATOM   1954  CB  SER C  55      37.148  19.697  39.952  1.00 16.78           C  
ATOM   1955  OG  SER C  55      36.059  18.825  40.193  1.00 19.90           O  
ATOM   1956  N   GLY C  56      39.737  21.020  41.183  1.00 17.49           N  
ATOM   1957  CA  GLY C  56      40.991  21.734  40.972  1.00 14.74           C  
ATOM   1958  C   GLY C  56      41.495  22.492  42.188  1.00 15.56           C  
ATOM   1959  O   GLY C  56      40.696  22.993  42.978  1.00 11.23           O  
ATOM   1960  N   HIS C  57      42.818  22.599  42.328  1.00 16.44           N  
ATOM   1961  CA  HIS C  57      43.414  23.306  43.467  1.00 20.11           C  
ATOM   1962  C   HIS C  57      42.854  24.716  43.658  1.00 21.30           C  
ATOM   1963  O   HIS C  57      42.512  25.114  44.773  1.00 22.83           O  
ATOM   1964  CB  HIS C  57      44.945  23.430  43.320  1.00 21.01           C  
ATOM   1965  CG  HIS C  57      45.669  22.121  43.228  1.00 23.14           C  
ATOM   1966  ND1 HIS C  57      46.072  21.575  42.027  1.00 25.00           N  
ATOM   1967  CD2 HIS C  57      46.090  21.265  44.189  1.00 22.44           C  
ATOM   1968  CE1 HIS C  57      46.712  20.441  42.253  1.00 23.22           C  
ATOM   1969  NE2 HIS C  57      46.738  20.230  43.556  1.00 24.95           N  
ATOM   1970  N   GLU C  58      42.759  25.476  42.573  1.00 23.29           N  
ATOM   1971  CA  GLU C  58      42.286  26.857  42.659  1.00 24.45           C  
ATOM   1972  C   GLU C  58      40.808  27.072  43.005  1.00 21.70           C  
ATOM   1973  O   GLU C  58      40.409  28.168  43.396  1.00 22.55           O  
ATOM   1974  CB  GLU C  58      42.612  27.587  41.356  1.00 27.64           C  
ATOM   1975  CG  GLU C  58      42.072  26.906  40.108  1.00 33.38           C  
ATOM   1976  CD  GLU C  58      43.157  26.215  39.295  1.00 36.56           C  
ATOM   1977  OE1 GLU C  58      43.719  25.198  39.766  1.00 34.66           O  
ATOM   1978  OE2 GLU C  58      43.447  26.704  38.179  1.00 38.64           O  
ATOM   1979  N   ASN C  59      39.998  26.035  42.873  1.00 20.13           N  
ATOM   1980  CA  ASN C  59      38.571  26.153  43.166  1.00 19.97           C  
ATOM   1981  C   ASN C  59      38.202  25.703  44.583  1.00 17.73           C  
ATOM   1982  O   ASN C  59      37.068  25.882  45.020  1.00 17.26           O  
ATOM   1983  CB  ASN C  59      37.768  25.321  42.156  1.00 19.56           C  
ATOM   1984  CG  ASN C  59      37.684  25.971  40.780  1.00 22.84           C  
ATOM   1985  OD1 ASN C  59      37.389  25.302  39.783  1.00 24.65           O  
ATOM   1986  ND2 ASN C  59      37.919  27.278  40.722  1.00 17.70           N  
ATOM   1987  N   GLN C  60      39.153  25.127  45.307  1.00 17.66           N  
ATOM   1988  CA  GLN C  60      38.844  24.631  46.638  1.00 16.29           C  
ATOM   1989  C   GLN C  60      38.616  25.705  47.688  1.00 16.78           C  
ATOM   1990  O   GLN C  60      37.865  25.487  48.642  1.00 15.75           O  
ATOM   1991  CB  GLN C  60      39.929  23.654  47.112  1.00 15.64           C  
ATOM   1992  CG  GLN C  60      40.132  22.432  46.206  1.00 14.38           C  
ATOM   1993  CD  GLN C  60      38.823  21.791  45.751  1.00 19.17           C  
ATOM   1994  OE1 GLN C  60      38.495  21.808  44.561  1.00 18.51           O  
ATOM   1995  NE2 GLN C  60      38.071  21.220  46.695  1.00 14.58           N  
ATOM   1996  N   ALA C  61      39.230  26.871  47.508  1.00 16.98           N  
ATOM   1997  CA  ALA C  61      39.093  27.950  48.491  1.00 17.08           C  
ATOM   1998  C   ALA C  61      37.654  28.417  48.695  1.00 17.01           C  
ATOM   1999  O   ALA C  61      37.240  28.689  49.822  1.00 15.96           O  
ATOM   2000  CB  ALA C  61      39.989  29.145  48.105  1.00 14.52           C  
ATOM   2001  N   ILE C  62      36.890  28.514  47.614  1.00 17.01           N  
ATOM   2002  CA  ILE C  62      35.502  28.958  47.729  1.00 17.90           C  
ATOM   2003  C   ILE C  62      34.594  27.927  48.397  1.00 18.25           C  
ATOM   2004  O   ILE C  62      33.382  28.112  48.453  1.00 20.78           O  
ATOM   2005  CB  ILE C  62      34.880  29.316  46.343  1.00 17.08           C  
ATOM   2006  CG1 ILE C  62      34.872  28.088  45.427  1.00 17.96           C  
ATOM   2007  CG2 ILE C  62      35.650  30.461  45.697  1.00 17.25           C  
ATOM   2008  CD1 ILE C  62      34.229  28.352  44.055  1.00 18.41           C  
ATOM   2009  N   THR C  63      35.163  26.838  48.898  1.00 19.09           N  
ATOM   2010  CA  THR C  63      34.345  25.819  49.549  1.00 18.07           C  
ATOM   2011  C   THR C  63      34.685  25.646  51.025  1.00 19.10           C  
ATOM   2012  O   THR C  63      34.079  24.825  51.709  1.00 18.96           O  
ATOM   2013  CB  THR C  63      34.526  24.443  48.894  1.00 16.60           C  
ATOM   2014  OG1 THR C  63      35.769  23.872  49.326  1.00 16.27           O  
ATOM   2015  CG2 THR C  63      34.518  24.569  47.375  1.00 13.56           C  
ATOM   2016  N   HIS C  64      35.654  26.414  51.512  1.00 18.68           N  
ATOM   2017  CA  HIS C  64      36.093  26.297  52.894  1.00 20.31           C  
ATOM   2018  C   HIS C  64      34.976  26.418  53.930  1.00 21.18           C  
ATOM   2019  O   HIS C  64      35.027  25.775  54.975  1.00 19.17           O  
ATOM   2020  CB  HIS C  64      37.147  27.357  53.205  1.00 19.79           C  
ATOM   2021  CG  HIS C  64      36.569  28.722  53.403  1.00 20.90           C  
ATOM   2022  ND1 HIS C  64      36.158  29.515  52.351  1.00 20.94           N  
ATOM   2023  CD2 HIS C  64      36.266  29.403  54.532  1.00 20.02           C  
ATOM   2024  CE1 HIS C  64      35.623  30.626  52.823  1.00 18.89           C  
ATOM   2025  NE2 HIS C  64      35.675  30.584  54.144  1.00 22.33           N  
ATOM   2026  N   SER C  65      33.974  27.244  53.647  1.00 23.00           N  
ATOM   2027  CA  SER C  65      32.892  27.457  54.604  1.00 25.58           C  
ATOM   2028  C   SER C  65      31.629  26.637  54.397  1.00 26.32           C  
ATOM   2029  O   SER C  65      30.754  26.643  55.266  1.00 26.30           O  
ATOM   2030  CB  SER C  65      32.490  28.929  54.613  1.00 26.09           C  
ATOM   2031  OG  SER C  65      31.732  29.246  53.452  1.00 28.24           O  
ATOM   2032  N   ILE C  66      31.515  25.926  53.279  1.00 26.29           N  
ATOM   2033  CA  ILE C  66      30.282  25.190  53.052  1.00 27.80           C  
ATOM   2034  C   ILE C  66      30.088  23.948  53.914  1.00 27.14           C  
ATOM   2035  O   ILE C  66      30.934  23.062  53.980  1.00 26.54           O  
ATOM   2036  CB  ILE C  66      30.075  24.846  51.535  1.00 30.29           C  
ATOM   2037  CG1 ILE C  66      30.493  23.407  51.220  1.00 32.03           C  
ATOM   2038  CG2 ILE C  66      30.825  25.848  50.680  1.00 30.61           C  
ATOM   2039  CD1 ILE C  66      31.973  23.137  51.321  1.00 35.23           C  
ATOM   2040  N   THR C  67      28.950  23.921  54.597  1.00 27.04           N  
ATOM   2041  CA  THR C  67      28.586  22.809  55.459  1.00 27.85           C  
ATOM   2042  C   THR C  67      27.084  22.620  55.295  1.00 27.44           C  
ATOM   2043  O   THR C  67      26.417  23.443  54.662  1.00 26.34           O  
ATOM   2044  CB  THR C  67      28.881  23.129  56.935  1.00 28.22           C  
ATOM   2045  OG1 THR C  67      29.968  24.060  57.014  1.00 31.03           O  
ATOM   2046  CG2 THR C  67      29.267  21.866  57.680  1.00 27.51           C  
ATOM   2047  N   VAL C  68      26.552  21.534  55.847  1.00 27.34           N  
ATOM   2048  CA  VAL C  68      25.121  21.297  55.765  1.00 26.18           C  
ATOM   2049  C   VAL C  68      24.463  22.546  56.343  1.00 24.75           C  
ATOM   2050  O   VAL C  68      24.831  23.001  57.423  1.00 24.83           O  
ATOM   2051  CB  VAL C  68      24.708  20.057  56.596  1.00 27.22           C  
ATOM   2052  CG1 VAL C  68      23.194  19.912  56.612  1.00 27.67           C  
ATOM   2053  CG2 VAL C  68      25.334  18.812  56.003  1.00 27.38           C  
ATOM   2054  N   GLY C  69      23.516  23.120  55.607  1.00 23.72           N  
ATOM   2055  CA  GLY C  69      22.844  24.312  56.088  1.00 20.68           C  
ATOM   2056  C   GLY C  69      23.345  25.587  55.440  1.00 20.22           C  
ATOM   2057  O   GLY C  69      22.705  26.632  55.552  1.00 18.38           O  
ATOM   2058  N   SER C  70      24.499  25.524  54.784  1.00 20.42           N  
ATOM   2059  CA  SER C  70      25.023  26.707  54.121  1.00 20.09           C  
ATOM   2060  C   SER C  70      24.051  27.057  53.004  1.00 20.36           C  
ATOM   2061  O   SER C  70      23.619  26.181  52.258  1.00 21.69           O  
ATOM   2062  CB  SER C  70      26.402  26.437  53.518  1.00 18.49           C  
ATOM   2063  OG  SER C  70      27.371  26.183  54.516  1.00 20.47           O  
ATOM   2064  N   ARG C  71      23.686  28.327  52.905  1.00 20.00           N  
ATOM   2065  CA  ARG C  71      22.781  28.758  51.853  1.00 21.57           C  
ATOM   2066  C   ARG C  71      23.655  29.454  50.816  1.00 20.78           C  
ATOM   2067  O   ARG C  71      24.279  30.481  51.104  1.00 18.38           O  
ATOM   2068  CB  ARG C  71      21.731  29.724  52.408  1.00 24.17           C  
ATOM   2069  CG  ARG C  71      21.056  29.233  53.688  1.00 27.57           C  
ATOM   2070  CD  ARG C  71      19.867  30.109  54.074  1.00 31.23           C  
ATOM   2071  NE  ARG C  71      20.181  31.532  54.013  1.00 34.76           N  
ATOM   2072  CZ  ARG C  71      21.082  32.141  54.782  1.00 39.68           C  
ATOM   2073  NH1 ARG C  71      21.295  33.445  54.645  1.00 38.02           N  
ATOM   2074  NH2 ARG C  71      21.765  31.453  55.691  1.00 40.76           N  
ATOM   2075  N   ILE C  72      23.718  28.885  49.617  1.00 18.00           N  
ATOM   2076  CA  ILE C  72      24.544  29.467  48.567  1.00 19.36           C  
ATOM   2077  C   ILE C  72      23.888  29.378  47.191  1.00 18.47           C  
ATOM   2078  O   ILE C  72      22.854  28.730  47.015  1.00 17.99           O  
ATOM   2079  CB  ILE C  72      25.935  28.771  48.484  1.00 19.33           C  
ATOM   2080  CG1 ILE C  72      25.816  27.424  47.775  1.00 23.10           C  
ATOM   2081  CG2 ILE C  72      26.518  28.552  49.896  1.00 17.90           C  
ATOM   2082  CD1 ILE C  72      24.995  26.409  48.507  1.00 27.78           C  
ATOM   2083  N   THR C  73      24.493  30.055  46.223  1.00 18.59           N  
ATOM   2084  CA  THR C  73      24.013  30.024  44.847  1.00 17.69           C  
ATOM   2085  C   THR C  73      25.214  29.582  44.036  1.00 17.25           C  
ATOM   2086  O   THR C  73      26.282  30.200  44.087  1.00 16.21           O  
ATOM   2087  CB  THR C  73      23.525  31.402  44.384  1.00 18.54           C  
ATOM   2088  OG1 THR C  73      22.540  31.875  45.310  1.00 20.94           O  
ATOM   2089  CG2 THR C  73      22.889  31.319  42.979  1.00 18.44           C  
ATOM   2090  N   VAL C  74      25.052  28.473  43.329  1.00 16.50           N  
ATOM   2091  CA  VAL C  74      26.125  27.935  42.519  1.00 16.27           C  
ATOM   2092  C   VAL C  74      25.933  28.220  41.037  1.00 17.75           C  
ATOM   2093  O   VAL C  74      24.822  28.093  40.502  1.00 18.95           O  
ATOM   2094  CB  VAL C  74      26.252  26.407  42.700  1.00 15.39           C  
ATOM   2095  CG1 VAL C  74      27.463  25.909  41.931  1.00 15.74           C  
ATOM   2096  CG2 VAL C  74      26.380  26.049  44.184  1.00 15.52           C  
ATOM   2097  N   GLN C  75      27.016  28.627  40.383  1.00 17.45           N  
ATOM   2098  CA  GLN C  75      26.996  28.885  38.950  1.00 17.16           C  
ATOM   2099  C   GLN C  75      28.070  27.983  38.363  1.00 15.92           C  
ATOM   2100  O   GLN C  75      29.181  27.912  38.893  1.00 16.07           O  
ATOM   2101  CB  GLN C  75      27.309  30.350  38.637  1.00 21.10           C  
ATOM   2102  CG  GLN C  75      27.292  30.666  37.149  1.00 25.03           C  
ATOM   2103  CD  GLN C  75      27.613  32.118  36.853  1.00 27.96           C  
ATOM   2104  OE1 GLN C  75      26.919  33.027  37.307  1.00 29.68           O  
ATOM   2105  NE2 GLN C  75      28.671  32.342  36.086  1.00 30.91           N  
ATOM   2106  N   GLY C  76      27.720  27.267  37.298  1.00 11.72           N  
ATOM   2107  CA  GLY C  76      28.654  26.364  36.648  1.00 10.08           C  
ATOM   2108  C   GLY C  76      27.979  25.691  35.465  1.00 11.37           C  
ATOM   2109  O   GLY C  76      26.943  26.156  34.990  1.00 11.86           O  
ATOM   2110  N   PHE C  77      28.556  24.599  34.982  1.00 11.53           N  
ATOM   2111  CA  PHE C  77      27.971  23.875  33.858  1.00 13.44           C  
ATOM   2112  C   PHE C  77      27.517  22.486  34.305  1.00 12.85           C  
ATOM   2113  O   PHE C  77      28.016  21.945  35.294  1.00 10.29           O  
ATOM   2114  CB  PHE C  77      28.980  23.772  32.704  1.00 12.70           C  
ATOM   2115  CG  PHE C  77      30.188  22.941  33.020  1.00 14.17           C  
ATOM   2116  CD1 PHE C  77      30.163  21.557  32.844  1.00 12.76           C  
ATOM   2117  CD2 PHE C  77      31.357  23.539  33.488  1.00 13.47           C  
ATOM   2118  CE1 PHE C  77      31.280  20.782  33.129  1.00 12.90           C  
ATOM   2119  CE2 PHE C  77      32.485  22.768  33.777  1.00 14.40           C  
ATOM   2120  CZ  PHE C  77      32.446  21.390  33.595  1.00 14.03           C  
ATOM   2121  N   ILE C  78      26.562  21.910  33.583  1.00 11.98           N  
ATOM   2122  CA  ILE C  78      26.066  20.588  33.943  1.00 11.25           C  
ATOM   2123  C   ILE C  78      26.580  19.500  33.031  1.00 12.92           C  
ATOM   2124  O   ILE C  78      26.868  19.734  31.847  1.00 10.55           O  
ATOM   2125  CB  ILE C  78      24.508  20.530  33.916  1.00 12.81           C  
ATOM   2126  CG1 ILE C  78      23.987  20.898  32.520  1.00 12.83           C  
ATOM   2127  CG2 ILE C  78      23.937  21.471  34.948  1.00 12.83           C  
ATOM   2128  CD1 ILE C  78      22.483  20.880  32.390  1.00 13.09           C  
ATOM   2129  N   SER C  79      26.681  18.297  33.587  1.00 12.90           N  
ATOM   2130  CA  SER C  79      27.121  17.144  32.829  1.00 15.52           C  
ATOM   2131  C   SER C  79      26.576  15.890  33.503  1.00 18.73           C  
ATOM   2132  O   SER C  79      26.273  15.892  34.701  1.00 18.11           O  
ATOM   2133  CB  SER C  79      28.649  17.104  32.743  1.00 15.62           C  
ATOM   2134  OG  SER C  79      29.075  16.217  31.720  1.00 14.06           O  
ATOM   2135  N   CYS C  80      26.432  14.823  32.730  1.00 20.16           N  
ATOM   2136  CA  CYS C  80      25.899  13.579  33.262  1.00 24.88           C  
ATOM   2137  C   CYS C  80      27.007  12.566  33.495  1.00 25.45           C  
ATOM   2138  O   CYS C  80      27.852  12.344  32.623  1.00 24.32           O  
ATOM   2139  CB  CYS C  80      24.853  13.011  32.292  1.00 26.26           C  
ATOM   2140  SG  CYS C  80      24.029  11.492  32.833  1.00 35.97           S  
ATOM   2141  N   HIS C  81      27.005  11.970  34.685  1.00 27.46           N  
ATOM   2142  CA  HIS C  81      28.000  10.966  35.062  1.00 31.63           C  
ATOM   2143  C   HIS C  81      27.278   9.684  35.451  1.00 33.55           C  
ATOM   2144  O   HIS C  81      26.120   9.723  35.860  1.00 32.93           O  
ATOM   2145  CB  HIS C  81      28.822  11.420  36.276  1.00 31.44           C  
ATOM   2146  CG  HIS C  81      29.406  12.790  36.148  1.00 33.72           C  
ATOM   2147  ND1 HIS C  81      28.627  13.921  36.044  1.00 33.03           N  
ATOM   2148  CD2 HIS C  81      30.691  13.215  36.145  1.00 34.54           C  
ATOM   2149  CE1 HIS C  81      29.405  14.984  35.987  1.00 34.33           C  
ATOM   2150  NE2 HIS C  81      30.663  14.585  36.047  1.00 34.88           N  
ATOM   2151  N   LYS C  82      27.969   8.555  35.346  1.00 37.49           N  
ATOM   2152  CA  LYS C  82      27.377   7.277  35.720  1.00 40.97           C  
ATOM   2153  C   LYS C  82      27.741   6.974  37.170  1.00 42.38           C  
ATOM   2154  O   LYS C  82      28.918   6.877  37.514  1.00 42.59           O  
ATOM   2155  CB  LYS C  82      27.889   6.157  34.818  1.00 43.01           C  
ATOM   2156  CG  LYS C  82      27.210   4.815  35.074  1.00 47.34           C  
ATOM   2157  CD  LYS C  82      27.886   3.686  34.311  1.00 48.70           C  
ATOM   2158  CE  LYS C  82      27.191   2.357  34.564  1.00 50.74           C  
ATOM   2159  NZ  LYS C  82      25.775   2.372  34.086  1.00 51.32           N  
ATOM   2160  N   ALA C  83      26.726   6.834  38.016  1.00 44.52           N  
ATOM   2161  CA  ALA C  83      26.933   6.551  39.430  1.00 46.52           C  
ATOM   2162  C   ALA C  83      27.233   5.074  39.672  1.00 48.07           C  
ATOM   2163  O   ALA C  83      26.938   4.221  38.832  1.00 49.05           O  
ATOM   2164  CB  ALA C  83      25.704   6.971  40.227  1.00 46.43           C  
ATOM   2165  N   LYS C  84      27.826   4.780  40.823  1.00 49.82           N  
ATOM   2166  CA  LYS C  84      28.166   3.408  41.178  1.00 51.23           C  
ATOM   2167  C   LYS C  84      26.926   2.518  41.276  1.00 51.88           C  
ATOM   2168  O   LYS C  84      27.027   1.294  41.197  1.00 51.99           O  
ATOM   2169  CB  LYS C  84      28.940   3.388  42.499  1.00 51.24           C  
ATOM   2170  CG  LYS C  84      28.326   4.243  43.599  1.00 51.92           C  
ATOM   2171  CD  LYS C  84      29.310   4.432  44.745  1.00 53.02           C  
ATOM   2172  CE  LYS C  84      28.766   5.378  45.805  1.00 52.98           C  
ATOM   2173  NZ  LYS C  84      29.739   5.583  46.913  1.00 51.31           N  
ATOM   2174  N   ASN C  85      25.758   3.133  41.440  1.00 52.20           N  
ATOM   2175  CA  ASN C  85      24.516   2.372  41.533  1.00 52.89           C  
ATOM   2176  C   ASN C  85      24.098   1.922  40.138  1.00 52.35           C  
ATOM   2177  O   ASN C  85      23.212   1.082  39.985  1.00 52.47           O  
ATOM   2178  CB  ASN C  85      23.407   3.224  42.156  1.00 54.01           C  
ATOM   2179  CG  ASN C  85      22.745   4.148  41.151  1.00 54.50           C  
ATOM   2180  OD1 ASN C  85      23.415   4.809  40.361  1.00 55.10           O  
ATOM   2181  ND2 ASN C  85      21.419   4.205  41.186  1.00 55.39           N  
ATOM   2182  N   GLY C  86      24.742   2.489  39.121  1.00 52.13           N  
ATOM   2183  CA  GLY C  86      24.431   2.126  37.751  1.00 51.63           C  
ATOM   2184  C   GLY C  86      23.761   3.222  36.944  1.00 51.20           C  
ATOM   2185  O   GLY C  86      23.988   3.340  35.737  1.00 51.92           O  
ATOM   2186  N   LEU C  87      22.930   4.021  37.602  1.00 49.59           N  
ATOM   2187  CA  LEU C  87      22.227   5.103  36.925  1.00 48.89           C  
ATOM   2188  C   LEU C  87      23.117   6.325  36.728  1.00 47.48           C  
ATOM   2189  O   LEU C  87      24.000   6.599  37.539  1.00 46.93           O  
ATOM   2190  CB  LEU C  87      20.974   5.497  37.713  1.00 50.14           C  
ATOM   2191  CG  LEU C  87      19.842   4.463  37.789  1.00 50.96           C  
ATOM   2192  CD1 LEU C  87      19.429   4.067  36.377  1.00 51.99           C  
ATOM   2193  CD2 LEU C  87      20.290   3.241  38.574  1.00 51.18           C  
ATOM   2194  N   SER C  88      22.877   7.054  35.644  1.00 45.24           N  
ATOM   2195  CA  SER C  88      23.651   8.249  35.336  1.00 44.31           C  
ATOM   2196  C   SER C  88      22.960   9.486  35.900  1.00 42.05           C  
ATOM   2197  O   SER C  88      21.827   9.794  35.531  1.00 43.42           O  
ATOM   2198  CB  SER C  88      23.806   8.392  33.822  1.00 46.16           C  
ATOM   2199  OG  SER C  88      22.540   8.521  33.200  1.00 47.76           O  
ATOM   2200  N   LYS C  89      23.648  10.200  36.789  1.00 37.91           N  
ATOM   2201  CA  LYS C  89      23.082  11.394  37.406  1.00 33.56           C  
ATOM   2202  C   LYS C  89      23.660  12.707  36.880  1.00 29.83           C  
ATOM   2203  O   LYS C  89      24.797  12.763  36.414  1.00 26.80           O  
ATOM   2204  CB  LYS C  89      23.281  11.349  38.922  1.00 35.51           C  
ATOM   2205  CG  LYS C  89      22.572  10.194  39.620  1.00 39.82           C  
ATOM   2206  CD  LYS C  89      22.675  10.330  41.132  1.00 41.33           C  
ATOM   2207  CE  LYS C  89      21.931   9.214  41.845  1.00 41.59           C  
ATOM   2208  NZ  LYS C  89      21.989   9.395  43.320  1.00 43.48           N  
HETATM 2209  N   MSE C  90      22.856  13.758  36.967  1.00 26.85           N  
HETATM 2210  CA  MSE C  90      23.267  15.085  36.545  1.00 25.49           C  
HETATM 2211  C   MSE C  90      24.139  15.661  37.654  1.00 23.57           C  
HETATM 2212  O   MSE C  90      23.903  15.409  38.838  1.00 20.90           O  
HETATM 2213  CB  MSE C  90      22.052  15.989  36.355  1.00 29.08           C  
HETATM 2214  CG  MSE C  90      21.139  15.602  35.206  1.00 37.70           C  
HETATM 2215 SE   MSE C  90      22.040  15.721  33.491  1.00 47.89          SE  
HETATM 2216  CE  MSE C  90      22.992  17.370  33.758  1.00 39.25           C  
ATOM   2217  N   VAL C  91      25.153  16.420  37.264  1.00 18.63           N  
ATOM   2218  CA  VAL C  91      26.043  17.054  38.218  1.00 17.75           C  
ATOM   2219  C   VAL C  91      26.338  18.466  37.744  1.00 15.95           C  
ATOM   2220  O   VAL C  91      26.429  18.723  36.540  1.00 14.79           O  
ATOM   2221  CB  VAL C  91      27.381  16.287  38.359  1.00 18.89           C  
ATOM   2222  CG1 VAL C  91      28.333  17.070  39.255  1.00 20.88           C  
ATOM   2223  CG2 VAL C  91      27.139  14.910  38.947  1.00 16.27           C  
ATOM   2224  N   LEU C  92      26.452  19.380  38.698  1.00 13.03           N  
ATOM   2225  CA  LEU C  92      26.764  20.772  38.417  1.00 10.84           C  
ATOM   2226  C   LEU C  92      28.217  21.014  38.807  1.00 13.28           C  
ATOM   2227  O   LEU C  92      28.589  20.896  39.984  1.00 13.31           O  
ATOM   2228  CB  LEU C  92      25.854  21.696  39.219  1.00  9.82           C  
ATOM   2229  CG  LEU C  92      26.218  23.182  39.270  1.00 10.61           C  
ATOM   2230  CD1 LEU C  92      26.225  23.790  37.874  1.00 11.20           C  
ATOM   2231  CD2 LEU C  92      25.219  23.904  40.161  1.00  8.38           C  
ATOM   2232  N   HIS C  93      29.031  21.322  37.804  1.00 10.32           N  
ATOM   2233  CA  HIS C  93      30.446  21.599  38.000  1.00 12.99           C  
ATOM   2234  C   HIS C  93      30.530  23.091  38.274  1.00 12.29           C  
ATOM   2235  O   HIS C  93      30.365  23.917  37.376  1.00 13.51           O  
ATOM   2236  CB  HIS C  93      31.230  21.196  36.747  1.00  9.66           C  
ATOM   2237  CG  HIS C  93      31.306  19.714  36.549  1.00 10.57           C  
ATOM   2238  ND1 HIS C  93      30.220  18.955  36.166  1.00 12.43           N  
ATOM   2239  CD2 HIS C  93      32.330  18.843  36.714  1.00 13.01           C  
ATOM   2240  CE1 HIS C  93      30.570  17.685  36.104  1.00 10.77           C  
ATOM   2241  NE2 HIS C  93      31.845  17.587  36.433  1.00 15.15           N  
ATOM   2242  N   ALA C  94      30.762  23.418  39.537  1.00 11.10           N  
ATOM   2243  CA  ALA C  94      30.789  24.797  39.988  1.00 14.05           C  
ATOM   2244  C   ALA C  94      31.982  25.600  39.519  1.00 15.42           C  
ATOM   2245  O   ALA C  94      33.111  25.107  39.476  1.00 18.19           O  
ATOM   2246  CB  ALA C  94      30.693  24.844  41.518  1.00 12.92           C  
ATOM   2247  N   GLU C  95      31.702  26.850  39.168  1.00 17.86           N  
ATOM   2248  CA  GLU C  95      32.711  27.792  38.699  1.00 20.87           C  
ATOM   2249  C   GLU C  95      32.693  28.951  39.697  1.00 20.75           C  
ATOM   2250  O   GLU C  95      33.737  29.497  40.051  1.00 20.15           O  
ATOM   2251  CB  GLU C  95      32.340  28.285  37.299  1.00 23.72           C  
ATOM   2252  CG  GLU C  95      33.462  28.970  36.548  1.00 31.80           C  
ATOM   2253  CD  GLU C  95      32.992  29.604  35.244  1.00 34.96           C  
ATOM   2254  OE1 GLU C  95      33.814  30.264  34.573  1.00 37.64           O  
ATOM   2255  OE2 GLU C  95      31.802  29.444  34.888  1.00 35.89           O  
ATOM   2256  N   GLN C  96      31.496  29.315  40.148  1.00 19.16           N  
ATOM   2257  CA  GLN C  96      31.332  30.385  41.133  1.00 20.19           C  
ATOM   2258  C   GLN C  96      30.357  29.963  42.219  1.00 20.07           C  
ATOM   2259  O   GLN C  96      29.413  29.200  41.978  1.00 19.87           O  
ATOM   2260  CB  GLN C  96      30.797  31.670  40.503  1.00 21.92           C  
ATOM   2261  CG  GLN C  96      31.716  32.342  39.525  1.00 25.25           C  
ATOM   2262  CD  GLN C  96      31.755  31.635  38.198  1.00 29.88           C  
ATOM   2263  OE1 GLN C  96      30.716  31.263  37.644  1.00 32.17           O  
ATOM   2264  NE2 GLN C  96      32.959  31.455  37.665  1.00 34.39           N  
ATOM   2265  N   ILE C  97      30.582  30.477  43.420  1.00 18.65           N  
ATOM   2266  CA  ILE C  97      29.721  30.170  44.549  1.00 15.96           C  
ATOM   2267  C   ILE C  97      29.511  31.424  45.370  1.00 18.34           C  
ATOM   2268  O   ILE C  97      30.466  31.998  45.909  1.00 15.23           O  
ATOM   2269  CB  ILE C  97      30.342  29.079  45.457  1.00 18.43           C  
ATOM   2270  CG1 ILE C  97      30.527  27.782  44.656  1.00 14.74           C  
ATOM   2271  CG2 ILE C  97      29.460  28.865  46.691  1.00 16.24           C  
ATOM   2272  CD1 ILE C  97      31.016  26.602  45.473  1.00 16.07           C  
ATOM   2273  N   GLU C  98      28.258  31.864  45.444  1.00 17.84           N  
ATOM   2274  CA  GLU C  98      27.917  33.037  46.226  1.00 18.77           C  
ATOM   2275  C   GLU C  98      27.511  32.567  47.610  1.00 19.71           C  
ATOM   2276  O   GLU C  98      26.717  31.640  47.740  1.00 18.29           O  
ATOM   2277  CB  GLU C  98      26.749  33.799  45.595  1.00 20.70           C  
ATOM   2278  CG  GLU C  98      26.427  35.105  46.319  1.00 22.43           C  
ATOM   2279  CD  GLU C  98      25.265  35.855  45.704  1.00 23.44           C  
ATOM   2280  OE1 GLU C  98      25.120  37.070  45.976  1.00 21.96           O  
ATOM   2281  OE2 GLU C  98      24.488  35.224  44.959  1.00 26.37           O  
ATOM   2282  N   LEU C  99      28.079  33.193  48.636  1.00 19.96           N  
ATOM   2283  CA  LEU C  99      27.759  32.860  50.023  1.00 21.44           C  
ATOM   2284  C   LEU C  99      26.722  33.903  50.431  1.00 22.03           C  
ATOM   2285  O   LEU C  99      27.066  34.997  50.874  1.00 18.97           O  
ATOM   2286  CB  LEU C  99      29.009  32.977  50.906  1.00 21.43           C  
ATOM   2287  CG  LEU C  99      30.303  32.295  50.433  1.00 21.95           C  
ATOM   2288  CD1 LEU C  99      31.370  32.421  51.519  1.00 21.98           C  
ATOM   2289  CD2 LEU C  99      30.044  30.823  50.129  1.00 23.48           C  
ATOM   2290  N   ILE C 100      25.448  33.575  50.268  1.00 25.83           N  
ATOM   2291  CA  ILE C 100      24.411  34.540  50.588  1.00 29.25           C  
ATOM   2292  C   ILE C 100      24.425  34.917  52.061  1.00 29.58           C  
ATOM   2293  O   ILE C 100      23.786  35.882  52.460  1.00 30.32           O  
ATOM   2294  CB  ILE C 100      23.007  34.023  50.191  1.00 31.36           C  
ATOM   2295  CG1 ILE C 100      22.521  32.974  51.184  1.00 33.17           C  
ATOM   2296  CG2 ILE C 100      23.056  33.420  48.786  1.00 31.68           C  
ATOM   2297  CD1 ILE C 100      21.059  32.636  51.010  1.00 37.24           C  
ATOM   2298  N   ASP C 101      25.193  34.171  52.850  1.00 31.96           N  
ATOM   2299  CA  ASP C 101      25.314  34.391  54.288  1.00 35.45           C  
ATOM   2300  C   ASP C 101      23.988  34.053  54.948  1.00 36.88           C  
ATOM   2301  O   ASP C 101      23.863  32.917  55.449  1.00 39.95           O  
ATOM   2302  CB  ASP C 101      25.682  35.850  54.614  1.00 34.85           C  
ATOM   2303  CG  ASP C 101      27.102  36.214  54.198  1.00 36.18           C  
ATOM   2304  OD1 ASP C 101      27.890  35.300  53.880  1.00 35.00           O  
ATOM   2305  OD2 ASP C 101      27.433  37.426  54.203  1.00 36.37           O  
TER    2306      ASP C 101                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
