
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 (  765),  selected  104 , name 1eyg_B
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1eyg_B.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A  2001_B      -       -           -
LGA    S  2002_B      -       -           -
LGA    R  2003_B      -       -           -
LGA    G  2004_B      -       -           -
LGA    V  2005_B      M       1          1.547
LGA    N  2006_B      N       2          0.983
LGA    K  2007_B      T       3          0.452
LGA    V  2008_B      L       4          0.436
LGA    I  2009_B      E       5          0.342
LGA    L  2010_B      L       6          0.761
LGA    V  2011_B      S       7          0.676
LGA    G  2012_B      A       8          0.782
LGA    N  2013_B      R       9          0.187
LGA    L  2014_B      V      10          0.756
LGA    G  2015_B      L      11          0.776
LGA    Q  2016_B      E      12          1.617
LGA    D  2017_B      C      13          2.815
LGA    P  2018_B      G      14          3.633
LGA    E  2019_B      A      15          3.764
LGA    V  2020_B      M      16          2.663
LGA    R  2021_B      R      17          1.770
LGA    Y  2022_B      H      18          1.457
LGA    M  2023_B      T      19          2.027
LGA    P  2024_B      P      20          1.518
LGA    N  2025_B      A      21          1.391
LGA    G  2026_B      G      22          1.691
LGA    G  2027_B      L      23          3.543
LGA    A  2028_B      P      24          0.955
LGA    V  2029_B      A      25          0.988
LGA    A  2030_B      L      26          0.854
LGA    N  2031_B      E      27          1.021
LGA    I  2032_B      L      28          0.977
LGA    T  2033_B      L      29          1.030
LGA    L  2034_B      L      30          0.892
LGA    A  2035_B      V      31          0.741
LGA    T  2036_B      H      32          0.798
LGA    S  2037_B      E      33          1.502
LGA    E  2038_B      S      34          3.211
LGA    -       -      E      35           -
LGA    -       -      V      36           -
LGA    -       -      V      37           -
LGA    -       -      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    S  2039_B      P      42           #
LGA    W  2040_B      R      43          4.597
LGA    E  2050_B      R      44          4.717
LGA    Q  2051_B      V      45          4.283
LGA    T  2052_B      E      46          1.301
LGA    E  2053_B      L      47          0.880
LGA    W  2054_B      T      48          0.487
LGA    H  2055_B      I      49          1.224
LGA    R  2056_B      S      50          1.342
LGA    V  2057_B      A      51          1.151
LGA    V  2058_B      V      52          0.642
LGA    L  2059_B      A      53          0.718
LGA    F  2060_B      L      54          0.930
LGA    G  2061_B      G      55          0.579
LGA    K  2062_B      D      56          1.235
LGA    L  2063_B      L      57          0.813
LGA    A  2064_B      A      58          0.321
LGA    E  2065_B      L      59          1.184
LGA    V  2066_B      L      60          1.356
LGA    A  2067_B      L      61          0.694
LGA    S  2068_B      A      62          0.672
LGA    E  2069_B      D      63          4.391
LGA    Y  2070_B      -       -           -
LGA    L  2071_B      T      64          1.215
LGA    R  2072_B      P      65          1.665
LGA    K  2073_B      L      66          0.909
LGA    G  2074_B      G      67          0.608
LGA    S  2075_B      T      68          0.803
LGA    Q  2076_B      E      69          0.677
LGA    V  2077_B      M      70          0.689
LGA    Y  2078_B      Q      71          0.680
LGA    I  2079_B      V      72          0.467
LGA    E  2080_B      Q      73          1.239
LGA    G  2081_B      G      74          0.547
LGA    Q  2082_B      F      75          0.885
LGA    L  2083_B      L      76          1.380
LGA    R  2084_B      A      77          1.183
LGA    T  2085_B      P      78          1.396
LGA    R  2086_B      A      79          4.385
LGA    K  2087_B      R      80          3.126
LGA    W  2088_B      K      81          4.014
LGA    T  2089_B      -       -           -
LGA    D  2090_B      -       -           -
LGA    Q  2091_B      -       -           -
LGA    S  2092_B      -       -           -
LGA    G  2093_B      -       -           -
LGA    Q  2094_B      -       -           -
LGA    D  2095_B      D      82           #
LGA    R  2096_B      S      83          3.894
LGA    Y  2097_B      V      84          4.147
LGA    T  2098_B      K      85          3.189
LGA    T  2099_B      V      86          1.424
LGA    E  2100_B      K      87          1.106
LGA    V  2101_B      L      88          1.127
LGA    V  2102_B      H      89          0.662
LGA    V  2103_B      L      90          1.790
LGA    N  2104_B      Q      91          3.730
LGA    V  2105_B      -       -           -
LGA    G  2106_B      -       -           -
LGA    G  2107_B      -       -           -
LGA    T  2108_B      Q      92          0.915
LGA    M  2109_B      A      93          0.672
LGA    Q  2110_B      R      94          0.574
LGA    M  2111_B      R      95          0.531
LGA    L  2112_B      I      96          0.517
LGA    G  2113_B      A      97          1.700
LGA    -       -      G      98           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104   98    5.0     88    1.93    14.77     77.706     4.332

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.026316 * X  +  -0.574598 * Y  +  -0.818013 * Z  +  40.850159
  Y_new =   0.903128 * X  +   0.364479 * Y  +  -0.226967 * Z  +  14.372817
  Z_new =   0.428563 * X  +  -0.732798 * Y  +   0.528527 * Z  +  18.317286 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.945953    2.195639  [ DEG:   -54.1991    125.8009 ]
  Theta =  -0.442902   -2.698691  [ DEG:   -25.3764   -154.6236 ]
  Phi   =   1.541666   -1.599927  [ DEG:    88.3309    -91.6691 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1eyg_B                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1eyg_B.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104   98   5.0   88   1.93   14.77  77.706
REMARK  ---------------------------------------------------------- 
MOLECULE 1eyg_B
HEADER    REPLICATION/DNA                         06-MAY-00   1EYG              
TITLE     CRYSTAL STRUCTURE OF CHYMOTRYPTIC FRAGMENT OF E. COLI SSB             
TITLE    2 BOUND TO TWO 35-MER SINGLE STRAND DNAS                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND DNA-BINDING PROTEIN;                         
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: CHYMOTRYPTIC FRAGMENT;                                     
COMPND   5 SYNONYM: SSB-C;                                                      
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: SINGLE STRANDED 28-MER OF D(C);                            
COMPND   9 CHAIN: Q, R;                                                         
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 SYNTHETIC: YES                                                       
KEYWDS    PROTEIN-DNA COMPLEX; OB FOLD; SE-MET; MAD PHASING; SSB;               
KEYWDS   2 BINDING MODE                                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.RAGHUNATHAN,G.WAKSMAN                                               
REVDAT   3   23-MAY-06 1EYG    1       SHEET  KEYWDS REMARK                     
REVDAT   2   21-AUG-00 1EYG    1       JRNL                                     
REVDAT   1   01-AUG-00 1EYG    0                                                
JRNL        AUTH   S.RAGHUNATHAN,A.G.KOZLOV,T.M.LOHMAN,G.WAKSMAN                
JRNL        TITL   STRUCTURE OF THE DNA BINDING DOMAIN OF E. COLI SSB           
JRNL        TITL 2 BOUND TO SSDNA.                                              
JRNL        REF    NAT.STRUCT.BIOL.              V.   7   648 2000              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  1EYG A 1000  1115  UNP    P0AGE0   SSB_ECOLI        1    116             
DBREF  1EYG B 2000  2115  UNP    P0AGE0   SSB_ECOLI        1    116             
DBREF  1EYG C 3000  3115  UNP    P0AGE0   SSB_ECOLI        1    116             
DBREF  1EYG D 4000  4115  UNP    P0AGE0   SSB_ECOLI        1    116             
SEQRES   1 A  116  MET ALA SER ARG GLY VAL ASN LYS VAL ILE LEU VAL GLY          
SEQRES   2 A  116  ASN LEU GLY GLN ASP PRO GLU VAL ARG TYR MET PRO ASN          
SEQRES   3 A  116  GLY GLY ALA VAL ALA ASN ILE THR LEU ALA THR SER GLU          
SEQRES   4 A  116  SER TRP ARG ASP LYS ALA THR GLY GLU MET LYS GLU GLN          
SEQRES   5 A  116  THR GLU TRP HIS ARG VAL VAL LEU PHE GLY LYS LEU ALA          
SEQRES   6 A  116  GLU VAL ALA SER GLU TYR LEU ARG LYS GLY SER GLN VAL          
SEQRES   7 A  116  TYR ILE GLU GLY GLN LEU ARG THR ARG LYS TRP THR ASP          
SEQRES   8 A  116  GLN SER GLY GLN ASP ARG TYR THR THR GLU VAL VAL VAL          
SEQRES   9 A  116  ASN VAL GLY GLY THR MET GLN MET LEU GLY GLY ARG              
SEQRES   1 B  116  MET ALA SER ARG GLY VAL ASN LYS VAL ILE LEU VAL GLY          
SEQRES   2 B  116  ASN LEU GLY GLN ASP PRO GLU VAL ARG TYR MET PRO ASN          
SEQRES   3 B  116  GLY GLY ALA VAL ALA ASN ILE THR LEU ALA THR SER GLU          
SEQRES   4 B  116  SER TRP ARG ASP LYS ALA THR GLY GLU MET LYS GLU GLN          
SEQRES   5 B  116  THR GLU TRP HIS ARG VAL VAL LEU PHE GLY LYS LEU ALA          
SEQRES   6 B  116  GLU VAL ALA SER GLU TYR LEU ARG LYS GLY SER GLN VAL          
SEQRES   7 B  116  TYR ILE GLU GLY GLN LEU ARG THR ARG LYS TRP THR ASP          
SEQRES   8 B  116  GLN SER GLY GLN ASP ARG TYR THR THR GLU VAL VAL VAL          
SEQRES   9 B  116  ASN VAL GLY GLY THR MET GLN MET LEU GLY GLY ARG              
SEQRES   1 C  116  MET ALA SER ARG GLY VAL ASN LYS VAL ILE LEU VAL GLY          
SEQRES   2 C  116  ASN LEU GLY GLN ASP PRO GLU VAL ARG TYR MET PRO ASN          
SEQRES   3 C  116  GLY GLY ALA VAL ALA ASN ILE THR LEU ALA THR SER GLU          
SEQRES   4 C  116  SER TRP ARG ASP LYS ALA THR GLY GLU MET LYS GLU GLN          
SEQRES   5 C  116  THR GLU TRP HIS ARG VAL VAL LEU PHE GLY LYS LEU ALA          
SEQRES   6 C  116  GLU VAL ALA SER GLU TYR LEU ARG LYS GLY SER GLN VAL          
SEQRES   7 C  116  TYR ILE GLU GLY GLN LEU ARG THR ARG LYS TRP THR ASP          
SEQRES   8 C  116  GLN SER GLY GLN ASP ARG TYR THR THR GLU VAL VAL VAL          
SEQRES   9 C  116  ASN VAL GLY GLY THR MET GLN MET LEU GLY GLY ARG              
SEQRES   1 D  116  MET ALA SER ARG GLY VAL ASN LYS VAL ILE LEU VAL GLY          
SEQRES   2 D  116  ASN LEU GLY GLN ASP PRO GLU VAL ARG TYR MET PRO ASN          
SEQRES   3 D  116  GLY GLY ALA VAL ALA ASN ILE THR LEU ALA THR SER GLU          
SEQRES   4 D  116  SER TRP ARG ASP LYS ALA THR GLY GLU MET LYS GLU GLN          
SEQRES   5 D  116  THR GLU TRP HIS ARG VAL VAL LEU PHE GLY LYS LEU ALA          
SEQRES   6 D  116  GLU VAL ALA SER GLU TYR LEU ARG LYS GLY SER GLN VAL          
SEQRES   7 D  116  TYR ILE GLU GLY GLN LEU ARG THR ARG LYS TRP THR ASP          
SEQRES   8 D  116  GLN SER GLY GLN ASP ARG TYR THR THR GLU VAL VAL VAL          
SEQRES   9 D  116  ASN VAL GLY GLY THR MET GLN MET LEU GLY GLY ARG              
SEQRES   1 Q   35   DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC          
SEQRES   2 Q   35   DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC          
SEQRES   3 Q   35   DC  DC  DC  DC  DC  DC  DC  DC  DC                          
SEQRES   1 R   35   DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC          
SEQRES   2 R   35   DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC  DC          
SEQRES   3 R   35   DC  DC  DC  DC  DC  DC  DC  DC  DC                          
FORMUL   7  HOH   *39(H2 O)                                                     
CRYST1   98.688   71.081   79.160  90.00  91.93  90.00 C 1 2 1      16          
ATOM    835  N   ALA B2001      34.094  26.166  23.694  1.00 65.65           N  
ATOM    836  CA  ALA B2001      32.681  25.890  23.571  1.00 68.69           C  
ATOM    837  C   ALA B2001      32.174  26.282  22.211  1.00 68.67           C  
ATOM    838  O   ALA B2001      31.535  27.319  22.057  1.00 66.31           O  
ATOM    839  CB  ALA B2001      31.910  26.620  24.615  1.00 66.13           C  
ATOM    840  N   SER B2002      32.502  25.474  21.208  1.00 70.31           N  
ATOM    841  CA  SER B2002      31.940  25.705  19.894  1.00 68.80           C  
ATOM    842  C   SER B2002      30.483  25.401  20.238  1.00 65.19           C  
ATOM    843  O   SER B2002      30.129  25.061  21.381  1.00 61.90           O  
ATOM    844  CB  SER B2002      32.420  24.663  18.871  1.00 70.06           C  
ATOM    845  OG  SER B2002      33.784  24.831  18.526  1.00 71.29           O  
ATOM    846  N   ARG B2003      29.620  25.484  19.256  1.00 66.28           N  
ATOM    847  CA  ARG B2003      28.245  25.204  19.563  1.00 65.09           C  
ATOM    848  C   ARG B2003      27.853  26.053  20.748  1.00 60.18           C  
ATOM    849  O   ARG B2003      28.612  26.836  21.305  1.00 61.32           O  
ATOM    850  CB  ARG B2003      28.060  23.727  19.898  1.00 66.75           C  
ATOM    851  N   GLY B2004      26.608  25.875  21.113  1.00 52.67           N  
ATOM    852  CA  GLY B2004      26.006  26.781  22.057  1.00 42.43           C  
ATOM    853  C   GLY B2004      26.621  27.084  23.394  1.00 36.01           C  
ATOM    854  O   GLY B2004      27.838  27.213  23.615  1.00 32.89           O  
ATOM    855  N   VAL B2005      25.647  27.249  24.289  1.00 30.03           N  
ATOM    856  CA  VAL B2005      25.808  27.600  25.681  1.00 25.60           C  
ATOM    857  C   VAL B2005      25.268  26.468  26.511  1.00 23.82           C  
ATOM    858  O   VAL B2005      24.246  25.863  26.158  1.00 24.72           O  
ATOM    859  CB  VAL B2005      24.975  28.819  25.962  1.00 24.80           C  
ATOM    860  CG1 VAL B2005      25.138  29.262  27.368  1.00 19.07           C  
ATOM    861  CG2 VAL B2005      25.359  29.880  25.013  1.00 20.92           C  
ATOM    862  N   ASN B2006      25.973  26.195  27.601  1.00 20.33           N  
ATOM    863  CA  ASN B2006      25.615  25.162  28.553  1.00 19.68           C  
ATOM    864  C   ASN B2006      25.905  25.831  29.875  1.00 18.75           C  
ATOM    865  O   ASN B2006      27.048  26.038  30.231  1.00 19.84           O  
ATOM    866  CB  ASN B2006      26.486  23.930  28.343  1.00 16.42           C  
ATOM    867  CG  ASN B2006      26.647  23.106  29.598  1.00 19.90           C  
ATOM    868  OD1 ASN B2006      25.688  22.820  30.316  1.00 19.15           O  
ATOM    869  ND2 ASN B2006      27.874  22.708  29.862  1.00 28.07           N  
ATOM    870  N   LYS B2007      24.864  26.208  30.592  1.00 16.90           N  
ATOM    871  CA  LYS B2007      25.082  26.894  31.845  1.00 19.87           C  
ATOM    872  C   LYS B2007      23.925  26.719  32.755  1.00 19.71           C  
ATOM    873  O   LYS B2007      22.786  26.729  32.306  1.00 21.89           O  
ATOM    874  CB  LYS B2007      25.258  28.395  31.625  1.00 22.83           C  
ATOM    875  CG  LYS B2007      25.215  29.200  32.921  1.00 19.90           C  
ATOM    876  CD  LYS B2007      25.140  30.690  32.624  1.00 20.45           C  
ATOM    877  CE  LYS B2007      26.416  31.191  31.939  1.00 24.67           C  
ATOM    878  NZ  LYS B2007      27.588  31.404  32.874  1.00 26.00           N  
ATOM    879  N   VAL B2008      24.217  26.598  34.039  1.00 16.03           N  
ATOM    880  CA  VAL B2008      23.185  26.429  35.040  1.00 17.64           C  
ATOM    881  C   VAL B2008      23.599  27.372  36.137  1.00 19.53           C  
ATOM    882  O   VAL B2008      24.791  27.591  36.354  1.00 19.51           O  
ATOM    883  CB  VAL B2008      23.086  24.941  35.531  1.00 15.89           C  
ATOM    884  CG1 VAL B2008      24.430  24.352  35.690  1.00 18.11           C  
ATOM    885  CG2 VAL B2008      22.382  24.858  36.842  1.00 10.63           C  
ATOM    886  N   ILE B2009      22.590  27.979  36.761  1.00 19.81           N  
ATOM    887  CA  ILE B2009      22.742  28.955  37.832  1.00 20.08           C  
ATOM    888  C   ILE B2009      21.850  28.479  38.934  1.00 21.15           C  
ATOM    889  O   ILE B2009      20.649  28.301  38.732  1.00 19.82           O  
ATOM    890  CB  ILE B2009      22.232  30.336  37.403  1.00 20.57           C  
ATOM    891  CG1 ILE B2009      23.033  30.817  36.202  1.00 17.68           C  
ATOM    892  CG2 ILE B2009      22.351  31.319  38.564  1.00 13.48           C  
ATOM    893  CD1 ILE B2009      22.458  31.961  35.482  1.00 19.62           C  
ATOM    894  N   LEU B2010      22.434  28.270  40.098  1.00 19.91           N  
ATOM    895  CA  LEU B2010      21.666  27.791  41.227  1.00 20.93           C  
ATOM    896  C   LEU B2010      21.936  28.651  42.442  1.00 21.86           C  
ATOM    897  O   LEU B2010      23.010  29.182  42.602  1.00 23.32           O  
ATOM    898  CB  LEU B2010      22.065  26.355  41.569  1.00 20.49           C  
ATOM    899  CG  LEU B2010      22.111  25.267  40.504  1.00 21.08           C  
ATOM    900  CD1 LEU B2010      22.852  24.053  41.063  1.00 23.91           C  
ATOM    901  CD2 LEU B2010      20.693  24.931  40.052  1.00 17.54           C  
ATOM    902  N   VAL B2011      20.937  28.758  43.290  1.00 18.97           N  
ATOM    903  CA  VAL B2011      21.006  29.488  44.523  1.00 21.30           C  
ATOM    904  C   VAL B2011      20.159  28.572  45.381  1.00 25.60           C  
ATOM    905  O   VAL B2011      18.980  28.347  45.053  1.00 24.53           O  
ATOM    906  CB  VAL B2011      20.372  30.866  44.364  1.00 19.95           C  
ATOM    907  CG1 VAL B2011      20.120  31.490  45.692  1.00 18.23           C  
ATOM    908  CG2 VAL B2011      21.310  31.757  43.587  1.00 22.76           C  
ATOM    909  N   GLY B2012      20.762  28.001  46.426  1.00 26.00           N  
ATOM    910  CA  GLY B2012      20.042  27.088  47.289  1.00 28.37           C  
ATOM    911  C   GLY B2012      20.931  26.766  48.463  1.00 27.61           C  
ATOM    912  O   GLY B2012      22.015  27.327  48.556  1.00 27.80           O  
ATOM    913  N   ASN B2013      20.503  25.882  49.359  1.00 27.99           N  
ATOM    914  CA  ASN B2013      21.315  25.543  50.531  1.00 31.35           C  
ATOM    915  C   ASN B2013      21.782  24.087  50.516  1.00 30.90           C  
ATOM    916  O   ASN B2013      21.043  23.200  50.081  1.00 29.79           O  
ATOM    917  CB  ASN B2013      20.540  25.777  51.832  1.00 33.18           C  
ATOM    918  CG  ASN B2013      19.332  26.647  51.653  1.00 37.32           C  
ATOM    919  OD1 ASN B2013      18.215  26.169  51.404  1.00 40.45           O  
ATOM    920  ND2 ASN B2013      19.541  27.938  51.778  1.00 37.50           N  
ATOM    921  N   LEU B2014      22.999  23.853  51.016  1.00 30.35           N  
ATOM    922  CA  LEU B2014      23.584  22.512  51.070  1.00 30.35           C  
ATOM    923  C   LEU B2014      22.768  21.620  51.970  1.00 29.51           C  
ATOM    924  O   LEU B2014      22.384  22.017  53.064  1.00 25.62           O  
ATOM    925  CB  LEU B2014      25.007  22.560  51.614  1.00 28.29           C  
ATOM    926  CG  LEU B2014      26.099  23.175  50.753  1.00 31.15           C  
ATOM    927  CD1 LEU B2014      25.680  24.526  50.218  1.00 31.31           C  
ATOM    928  CD2 LEU B2014      27.348  23.286  51.584  1.00 31.62           C  
ATOM    929  N   GLY B2015      22.504  20.406  51.522  1.00 33.41           N  
ATOM    930  CA  GLY B2015      21.724  19.521  52.349  1.00 36.69           C  
ATOM    931  C   GLY B2015      22.609  18.764  53.304  1.00 39.63           C  
ATOM    932  O   GLY B2015      22.157  18.018  54.167  1.00 38.50           O  
ATOM    933  N   GLN B2016      23.896  19.009  53.187  1.00 43.44           N  
ATOM    934  CA  GLN B2016      24.821  18.253  53.978  1.00 47.25           C  
ATOM    935  C   GLN B2016      26.229  18.823  53.791  1.00 46.29           C  
ATOM    936  O   GLN B2016      26.577  19.289  52.705  1.00 48.48           O  
ATOM    937  CB  GLN B2016      24.687  16.823  53.457  1.00 50.41           C  
ATOM    938  CG  GLN B2016      25.785  15.865  53.725  1.00 60.63           C  
ATOM    939  CD  GLN B2016      25.810  14.797  52.654  1.00 66.73           C  
ATOM    940  OE1 GLN B2016      26.569  13.824  52.737  1.00 70.53           O  
ATOM    941  NE2 GLN B2016      24.976  14.981  51.623  1.00 67.96           N  
ATOM    942  N   ASP B2017      27.018  18.812  54.862  1.00 45.98           N  
ATOM    943  CA  ASP B2017      28.403  19.277  54.828  1.00 43.92           C  
ATOM    944  C   ASP B2017      29.096  18.803  53.550  1.00 42.14           C  
ATOM    945  O   ASP B2017      28.894  17.669  53.081  1.00 44.62           O  
ATOM    946  CB  ASP B2017      29.212  18.689  55.996  1.00 47.25           C  
ATOM    947  CG  ASP B2017      28.788  19.208  57.358  1.00 51.01           C  
ATOM    948  OD1 ASP B2017      27.781  19.949  57.443  1.00 51.76           O  
ATOM    949  OD2 ASP B2017      29.479  18.859  58.353  1.00 55.52           O  
ATOM    950  N   PRO B2018      29.963  19.649  52.989  1.00 40.66           N  
ATOM    951  CA  PRO B2018      30.700  19.322  51.763  1.00 39.17           C  
ATOM    952  C   PRO B2018      31.527  18.019  51.856  1.00 39.33           C  
ATOM    953  O   PRO B2018      32.354  17.864  52.748  1.00 39.01           O  
ATOM    954  CB  PRO B2018      31.593  20.548  51.578  1.00 35.52           C  
ATOM    955  CG  PRO B2018      30.797  21.628  52.179  1.00 36.62           C  
ATOM    956  CD  PRO B2018      30.258  21.021  53.432  1.00 37.79           C  
ATOM    957  N   GLU B2019      31.310  17.078  50.949  1.00 40.95           N  
ATOM    958  CA  GLU B2019      32.108  15.866  50.972  1.00 41.88           C  
ATOM    959  C   GLU B2019      33.334  16.118  50.071  1.00 43.25           C  
ATOM    960  O   GLU B2019      33.279  15.900  48.858  1.00 41.24           O  
ATOM    961  CB  GLU B2019      31.284  14.678  50.462  1.00 37.43           C  
ATOM    962  N   VAL B2020      34.431  16.576  50.681  1.00 43.74           N  
ATOM    963  CA  VAL B2020      35.689  16.875  49.977  1.00 47.00           C  
ATOM    964  C   VAL B2020      36.592  15.651  49.800  1.00 51.26           C  
ATOM    965  O   VAL B2020      36.834  14.916  50.751  1.00 55.32           O  
ATOM    966  CB  VAL B2020      36.526  17.924  50.768  1.00 44.22           C  
ATOM    967  CG1 VAL B2020      37.621  18.511  49.884  1.00 44.35           C  
ATOM    968  CG2 VAL B2020      35.631  18.995  51.329  1.00 42.33           C  
ATOM    969  N   ARG B2021      37.117  15.462  48.600  1.00 53.85           N  
ATOM    970  CA  ARG B2021      38.003  14.341  48.312  1.00 56.13           C  
ATOM    971  C   ARG B2021      39.196  14.874  47.514  1.00 56.57           C  
ATOM    972  O   ARG B2021      39.152  15.983  47.004  1.00 59.57           O  
ATOM    973  CB  ARG B2021      37.237  13.278  47.517  1.00 57.36           C  
ATOM    974  CG  ARG B2021      38.009  12.005  47.130  1.00 62.57           C  
ATOM    975  CD  ARG B2021      37.040  10.959  46.524  1.00 66.92           C  
ATOM    976  NE  ARG B2021      37.671   9.728  46.015  1.00 72.84           N  
ATOM    977  CZ  ARG B2021      37.019   8.582  45.750  1.00 74.46           C  
ATOM    978  NH1 ARG B2021      35.712   8.481  45.943  1.00 75.54           N  
ATOM    979  NH2 ARG B2021      37.672   7.525  45.275  1.00 75.12           N  
ATOM    980  N   TYR B2022      40.259  14.087  47.420  1.00 54.86           N  
ATOM    981  CA  TYR B2022      41.464  14.479  46.708  1.00 54.87           C  
ATOM    982  C   TYR B2022      41.767  13.471  45.607  1.00 57.42           C  
ATOM    983  O   TYR B2022      42.452  12.478  45.841  1.00 57.77           O  
ATOM    984  CB  TYR B2022      42.628  14.556  47.705  1.00 50.74           C  
ATOM    985  CG  TYR B2022      42.387  15.599  48.767  1.00 51.26           C  
ATOM    986  CD1 TYR B2022      41.433  15.405  49.761  1.00 49.64           C  
ATOM    987  CD2 TYR B2022      43.001  16.854  48.689  1.00 50.60           C  
ATOM    988  CE1 TYR B2022      41.084  16.439  50.638  1.00 51.59           C  
ATOM    989  CE2 TYR B2022      42.658  17.898  49.559  1.00 49.59           C  
ATOM    990  CZ  TYR B2022      41.700  17.683  50.525  1.00 50.12           C  
ATOM    991  OH  TYR B2022      41.347  18.706  51.374  1.00 48.30           O  
ATOM    992  N   MET B2023      41.261  13.713  44.402  1.00 60.60           N  
ATOM    993  CA  MET B2023      41.498  12.779  43.301  1.00 63.51           C  
ATOM    994  C   MET B2023      43.019  12.513  43.130  1.00 65.45           C  
ATOM    995  O   MET B2023      43.821  12.909  43.985  1.00 62.98           O  
ATOM    996  CB  MET B2023      40.806  13.301  42.023  1.00 65.80           C  
ATOM    997  CG  MET B2023      41.715  13.787  40.936  1.00 67.47           C  
ATOM    998  SD  MET B2023      40.935  14.968  39.881  1.00 72.31           S  
ATOM    999  CE  MET B2023      42.377  15.539  38.936  1.00 70.88           C  
ATOM   1000  N   PRO B2024      43.431  11.795  42.070  1.00 67.43           N  
ATOM   1001  CA  PRO B2024      44.878  11.570  41.956  1.00 71.15           C  
ATOM   1002  C   PRO B2024      45.776  12.842  41.955  1.00 73.40           C  
ATOM   1003  O   PRO B2024      45.607  13.756  42.781  1.00 74.58           O  
ATOM   1004  CB  PRO B2024      44.975  10.757  40.675  1.00 70.33           C  
ATOM   1005  CG  PRO B2024      43.728   9.911  40.730  1.00 68.44           C  
ATOM   1006  CD  PRO B2024      42.677  10.890  41.175  1.00 68.12           C  
ATOM   1007  N   ASN B2025      46.750  12.889  41.053  1.00 74.32           N  
ATOM   1008  CA  ASN B2025      47.614  14.047  40.985  1.00 72.93           C  
ATOM   1009  C   ASN B2025      46.724  15.278  41.074  1.00 73.30           C  
ATOM   1010  O   ASN B2025      45.986  15.592  40.141  1.00 72.63           O  
ATOM   1011  CB  ASN B2025      48.369  14.040  39.686  1.00 73.85           C  
ATOM   1012  N   GLY B2026      46.764  15.959  42.209  1.00 72.35           N  
ATOM   1013  CA  GLY B2026      45.955  17.154  42.345  1.00 72.66           C  
ATOM   1014  C   GLY B2026      44.661  16.908  43.075  1.00 71.10           C  
ATOM   1015  O   GLY B2026      43.582  16.947  42.479  1.00 70.03           O  
ATOM   1016  N   GLY B2027      44.775  16.663  44.375  1.00 70.17           N  
ATOM   1017  CA  GLY B2027      43.591  16.412  45.168  1.00 68.88           C  
ATOM   1018  C   GLY B2027      42.738  17.644  45.420  1.00 65.17           C  
ATOM   1019  O   GLY B2027      43.118  18.525  46.174  1.00 70.63           O  
ATOM   1020  N   ALA B2028      41.577  17.719  44.794  1.00 57.75           N  
ATOM   1021  CA  ALA B2028      40.718  18.854  45.025  1.00 53.76           C  
ATOM   1022  C   ALA B2028      39.426  18.624  44.285  1.00 51.51           C  
ATOM   1023  O   ALA B2028      39.293  18.991  43.118  1.00 51.14           O  
ATOM   1024  CB  ALA B2028      41.389  20.130  44.550  1.00 56.21           C  
ATOM   1025  N   VAL B2029      38.484  17.974  44.958  1.00 45.79           N  
ATOM   1026  CA  VAL B2029      37.183  17.720  44.379  1.00 41.02           C  
ATOM   1027  C   VAL B2029      36.166  17.705  45.492  1.00 39.27           C  
ATOM   1028  O   VAL B2029      36.136  16.807  46.310  1.00 40.87           O  
ATOM   1029  CB  VAL B2029      37.132  16.388  43.590  1.00 37.44           C  
ATOM   1030  CG1 VAL B2029      35.748  16.191  43.018  1.00 35.15           C  
ATOM   1031  CG2 VAL B2029      38.115  16.412  42.448  1.00 35.14           C  
ATOM   1032  N   ALA B2030      35.353  18.736  45.546  1.00 38.41           N  
ATOM   1033  CA  ALA B2030      34.333  18.776  46.559  1.00 38.67           C  
ATOM   1034  C   ALA B2030      32.989  18.440  45.906  1.00 37.35           C  
ATOM   1035  O   ALA B2030      32.755  18.752  44.736  1.00 39.88           O  
ATOM   1036  CB  ALA B2030      34.289  20.150  47.200  1.00 38.02           C  
ATOM   1037  N   ASN B2031      32.124  17.760  46.644  1.00 37.04           N  
ATOM   1038  CA  ASN B2031      30.816  17.434  46.130  1.00 36.78           C  
ATOM   1039  C   ASN B2031      29.851  17.960  47.132  1.00 37.89           C  
ATOM   1040  O   ASN B2031      30.013  17.782  48.327  1.00 39.32           O  
ATOM   1041  CB  ASN B2031      30.599  15.940  45.982  1.00 37.23           C  
ATOM   1042  CG  ASN B2031      30.970  15.444  44.617  1.00 41.33           C  
ATOM   1043  OD1 ASN B2031      32.131  15.200  44.345  1.00 37.80           O  
ATOM   1044  ND2 ASN B2031      29.984  15.311  43.738  1.00 44.66           N  
ATOM   1045  N   ILE B2032      28.836  18.628  46.631  1.00 36.82           N  
ATOM   1046  CA  ILE B2032      27.827  19.205  47.480  1.00 33.72           C  
ATOM   1047  C   ILE B2032      26.494  18.807  46.878  1.00 33.91           C  
ATOM   1048  O   ILE B2032      26.423  18.358  45.715  1.00 33.54           O  
ATOM   1049  CB  ILE B2032      28.017  20.753  47.540  1.00 36.62           C  
ATOM   1050  CG1 ILE B2032      27.812  21.384  46.144  1.00 40.09           C  
ATOM   1051  CG2 ILE B2032      29.448  21.071  48.039  1.00 29.25           C  
ATOM   1052  CD1 ILE B2032      28.207  22.875  46.003  1.00 40.60           C  
ATOM   1053  N   THR B2033      25.454  18.929  47.690  1.00 32.95           N  
ATOM   1054  CA  THR B2033      24.107  18.589  47.285  1.00 31.09           C  
ATOM   1055  C   THR B2033      23.272  19.757  47.691  1.00 31.99           C  
ATOM   1056  O   THR B2033      23.003  19.962  48.882  1.00 28.90           O  
ATOM   1057  CB  THR B2033      23.618  17.389  48.024  1.00 31.52           C  
ATOM   1058  OG1 THR B2033      24.669  16.416  48.075  1.00 31.58           O  
ATOM   1059  CG2 THR B2033      22.415  16.802  47.305  1.00 36.63           C  
ATOM   1060  N   LEU B2034      22.863  20.515  46.682  1.00 33.50           N  
ATOM   1061  CA  LEU B2034      22.099  21.747  46.849  1.00 32.86           C  
ATOM   1062  C   LEU B2034      20.592  21.563  46.669  1.00 32.24           C  
ATOM   1063  O   LEU B2034      20.131  20.859  45.763  1.00 32.41           O  
ATOM   1064  CB  LEU B2034      22.647  22.757  45.834  1.00 32.87           C  
ATOM   1065  CG  LEU B2034      22.724  24.263  46.042  1.00 34.18           C  
ATOM   1066  CD1 LEU B2034      23.465  24.533  47.329  1.00 37.11           C  
ATOM   1067  CD2 LEU B2034      23.427  24.926  44.836  1.00 34.74           C  
ATOM   1068  N   ALA B2035      19.846  22.231  47.542  1.00 31.03           N  
ATOM   1069  CA  ALA B2035      18.402  22.177  47.551  1.00 30.55           C  
ATOM   1070  C   ALA B2035      17.802  23.496  47.095  1.00 31.19           C  
ATOM   1071  O   ALA B2035      18.201  24.566  47.523  1.00 29.99           O  
ATOM   1072  CB  ALA B2035      17.934  21.863  48.948  1.00 29.28           C  
ATOM   1073  N   THR B2036      16.840  23.403  46.199  1.00 31.71           N  
ATOM   1074  CA  THR B2036      16.142  24.563  45.711  1.00 33.18           C  
ATOM   1075  C   THR B2036      14.686  24.119  45.749  1.00 36.00           C  
ATOM   1076  O   THR B2036      14.372  22.993  45.402  1.00 32.74           O  
ATOM   1077  CB  THR B2036      16.587  24.910  44.276  1.00 31.58           C  
ATOM   1078  OG1 THR B2036      16.293  23.829  43.380  1.00 27.70           O  
ATOM   1079  CG2 THR B2036      18.067  25.198  44.260  1.00 30.67           C  
ATOM   1080  N   SER B2037      13.780  24.970  46.202  1.00 42.27           N  
ATOM   1081  CA  SER B2037      12.392  24.533  46.236  1.00 48.51           C  
ATOM   1082  C   SER B2037      11.407  25.557  45.704  1.00 54.23           C  
ATOM   1083  O   SER B2037      11.770  26.698  45.401  1.00 55.71           O  
ATOM   1084  CB  SER B2037      11.985  24.123  47.654  1.00 45.88           C  
ATOM   1085  OG  SER B2037      12.082  25.216  48.552  1.00 40.46           O  
ATOM   1086  N   GLU B2038      10.156  25.129  45.569  1.00 61.54           N  
ATOM   1087  CA  GLU B2038       9.134  26.036  45.103  1.00 67.97           C  
ATOM   1088  C   GLU B2038       7.721  25.756  45.596  1.00 71.54           C  
ATOM   1089  O   GLU B2038       7.237  24.623  45.606  1.00 70.78           O  
ATOM   1090  CB  GLU B2038       9.176  26.153  43.593  1.00 67.96           C  
ATOM   1091  CG  GLU B2038       8.229  25.282  42.857  1.00 69.70           C  
ATOM   1092  CD  GLU B2038       8.177  25.696  41.407  1.00 70.69           C  
ATOM   1093  OE1 GLU B2038       7.401  25.062  40.641  1.00 74.36           O  
ATOM   1094  OE2 GLU B2038       8.914  26.662  41.053  1.00 69.41           O  
ATOM   1095  N   SER B2039       7.088  26.841  46.029  1.00 77.10           N  
ATOM   1096  CA  SER B2039       5.738  26.857  46.568  1.00 81.58           C  
ATOM   1097  C   SER B2039       4.792  27.223  45.437  1.00 84.85           C  
ATOM   1098  O   SER B2039       5.209  27.316  44.286  1.00 84.97           O  
ATOM   1099  CB  SER B2039       5.643  27.914  47.667  1.00 81.07           C  
ATOM   1100  OG  SER B2039       6.783  27.875  48.514  1.00 80.36           O  
ATOM   1101  N   TRP B2040       3.527  27.459  45.760  1.00 88.70           N  
ATOM   1102  CA  TRP B2040       2.551  27.784  44.726  1.00 92.64           C  
ATOM   1103  C   TRP B2040       1.139  27.829  45.306  1.00 93.92           C  
ATOM   1104  O   TRP B2040       0.316  27.003  44.852  1.00 94.45           O  
ATOM   1105  CB  TRP B2040       2.612  26.719  43.587  1.00 92.63           C  
ATOM   1106  CG  TRP B2040       2.783  25.245  44.045  1.00 94.30           C  
ATOM   1107  CD1 TRP B2040       2.398  24.700  45.248  1.00 95.37           C  
ATOM   1108  CD2 TRP B2040       3.348  24.159  43.288  1.00 95.30           C  
ATOM   1109  NE1 TRP B2040       2.690  23.355  45.285  1.00 95.56           N  
ATOM   1110  CE2 TRP B2040       3.270  22.995  44.098  1.00 95.53           C  
ATOM   1111  CE3 TRP B2040       3.908  24.055  42.005  1.00 95.38           C  
ATOM   1112  CZ2 TRP B2040       3.733  21.746  43.667  1.00 95.84           C  
ATOM   1113  CZ3 TRP B2040       4.373  22.803  41.575  1.00 95.44           C  
ATOM   1114  CH2 TRP B2040       4.279  21.669  42.407  1.00 95.33           C  
ATOM   1115  N   GLU B2050       5.070  22.745  48.627  1.00 67.50           N  
ATOM   1116  CA  GLU B2050       6.479  23.101  48.299  1.00 68.11           C  
ATOM   1117  C   GLU B2050       7.289  21.910  47.752  1.00 66.69           C  
ATOM   1118  O   GLU B2050       7.681  20.996  48.479  1.00 66.96           O  
ATOM   1119  CB  GLU B2050       7.166  23.694  49.536  1.00 69.40           C  
ATOM   1120  CG  GLU B2050       8.528  24.337  49.254  1.00 70.27           C  
ATOM   1121  CD  GLU B2050       9.105  25.099  50.443  1.00 69.97           C  
ATOM   1122  OE1 GLU B2050       8.516  26.116  50.868  1.00 68.49           O  
ATOM   1123  OE2 GLU B2050      10.160  24.670  50.944  1.00 70.18           O  
ATOM   1124  N   GLN B2051       7.551  21.971  46.452  1.00 66.09           N  
ATOM   1125  CA  GLN B2051       8.271  20.945  45.699  1.00 63.60           C  
ATOM   1126  C   GLN B2051       9.747  21.259  45.552  1.00 59.22           C  
ATOM   1127  O   GLN B2051      10.125  22.186  44.831  1.00 58.16           O  
ATOM   1128  CB  GLN B2051       7.657  20.834  44.307  1.00 66.14           C  
ATOM   1129  CG  GLN B2051       8.646  20.446  43.232  1.00 72.61           C  
ATOM   1130  CD  GLN B2051       8.990  18.989  43.282  1.00 77.74           C  
ATOM   1131  OE1 GLN B2051       9.809  18.503  42.505  1.00 81.17           O  
ATOM   1132  NE2 GLN B2051       8.357  18.272  44.195  1.00 79.80           N  
ATOM   1133  N   THR B2052      10.587  20.460  46.199  1.00 53.69           N  
ATOM   1134  CA  THR B2052      12.024  20.710  46.148  1.00 46.93           C  
ATOM   1135  C   THR B2052      12.762  19.788  45.184  1.00 40.61           C  
ATOM   1136  O   THR B2052      12.231  18.768  44.782  1.00 41.39           O  
ATOM   1137  CB  THR B2052      12.644  20.710  47.608  1.00 42.58           C  
ATOM   1138  OG1 THR B2052      13.997  20.255  47.576  1.00 43.72           O  
ATOM   1139  CG2 THR B2052      11.797  19.879  48.569  1.00 42.66           C  
ATOM   1140  N   GLU B2053      13.956  20.213  44.764  1.00 36.18           N  
ATOM   1141  CA  GLU B2053      14.822  19.472  43.832  1.00 33.55           C  
ATOM   1142  C   GLU B2053      16.227  19.455  44.373  1.00 31.12           C  
ATOM   1143  O   GLU B2053      16.732  20.471  44.847  1.00 29.54           O  
ATOM   1144  CB  GLU B2053      14.918  20.134  42.472  1.00 29.94           C  
ATOM   1145  CG  GLU B2053      13.832  19.781  41.486  1.00 40.29           C  
ATOM   1146  CD  GLU B2053      14.052  18.454  40.774  1.00 43.68           C  
ATOM   1147  OE1 GLU B2053      15.213  17.992  40.647  1.00 43.59           O  
ATOM   1148  OE2 GLU B2053      13.045  17.871  40.318  1.00 48.76           O  
ATOM   1149  N   TRP B2054      16.875  18.305  44.288  1.00 26.85           N  
ATOM   1150  CA  TRP B2054      18.227  18.208  44.790  1.00 23.41           C  
ATOM   1151  C   TRP B2054      19.164  18.221  43.619  1.00 22.72           C  
ATOM   1152  O   TRP B2054      18.830  17.652  42.564  1.00 25.82           O  
ATOM   1153  CB  TRP B2054      18.409  16.943  45.620  1.00 24.74           C  
ATOM   1154  CG  TRP B2054      17.636  16.999  46.894  1.00 23.92           C  
ATOM   1155  CD1 TRP B2054      16.334  16.615  47.098  1.00 18.83           C  
ATOM   1156  CD2 TRP B2054      18.059  17.618  48.100  1.00 21.68           C  
ATOM   1157  NE1 TRP B2054      15.923  16.978  48.354  1.00 16.00           N  
ATOM   1158  CE2 TRP B2054      16.964  17.592  48.992  1.00 22.38           C  
ATOM   1159  CE3 TRP B2054      19.262  18.193  48.516  1.00 21.42           C  
ATOM   1160  CZ2 TRP B2054      17.034  18.127  50.251  1.00 21.78           C  
ATOM   1161  CZ3 TRP B2054      19.330  18.726  49.772  1.00 24.91           C  
ATOM   1162  CH2 TRP B2054      18.228  18.690  50.620  1.00 24.22           C  
ATOM   1163  N   HIS B2055      20.310  18.895  43.808  1.00 22.42           N  
ATOM   1164  CA  HIS B2055      21.336  19.046  42.781  1.00 24.20           C  
ATOM   1165  C   HIS B2055      22.710  18.565  43.234  1.00 26.78           C  
ATOM   1166  O   HIS B2055      23.091  18.756  44.389  1.00 27.31           O  
ATOM   1167  CB  HIS B2055      21.449  20.511  42.353  1.00 22.96           C  
ATOM   1168  CG  HIS B2055      20.175  21.097  41.829  1.00 21.84           C  
ATOM   1169  ND1 HIS B2055      19.265  21.752  42.638  1.00 16.99           N  
ATOM   1170  CD2 HIS B2055      19.671  21.153  40.573  1.00 22.29           C  
ATOM   1171  CE1 HIS B2055      18.260  22.190  41.898  1.00 20.41           C  
ATOM   1172  NE2 HIS B2055      18.481  21.842  40.643  1.00 19.86           N  
ATOM   1173  N   ARG B2056      23.440  17.942  42.310  1.00 25.89           N  
ATOM   1174  CA  ARG B2056      24.782  17.460  42.569  1.00 27.33           C  
ATOM   1175  C   ARG B2056      25.698  18.454  41.939  1.00 28.10           C  
ATOM   1176  O   ARG B2056      25.730  18.577  40.720  1.00 28.78           O  
ATOM   1177  CB  ARG B2056      24.996  16.172  41.917  1.00 26.09           C  
ATOM   1178  N   VAL B2057      26.448  19.163  42.762  1.00 24.75           N  
ATOM   1179  CA  VAL B2057      27.378  20.161  42.265  1.00 22.74           C  
ATOM   1180  C   VAL B2057      28.777  19.685  42.659  1.00 25.21           C  
ATOM   1181  O   VAL B2057      29.006  19.324  43.809  1.00 32.52           O  
ATOM   1182  CB  VAL B2057      27.086  21.556  42.914  1.00 23.03           C  
ATOM   1183  CG1 VAL B2057      28.080  22.574  42.413  1.00 17.25           C  
ATOM   1184  CG2 VAL B2057      25.638  21.989  42.631  1.00 18.91           C  
ATOM   1185  N   VAL B2058      29.715  19.646  41.720  1.00 24.96           N  
ATOM   1186  CA  VAL B2058      31.068  19.226  42.071  1.00 27.64           C  
ATOM   1187  C   VAL B2058      32.013  20.394  41.818  1.00 27.68           C  
ATOM   1188  O   VAL B2058      32.063  20.933  40.717  1.00 30.23           O  
ATOM   1189  CB  VAL B2058      31.471  17.956  41.291  1.00 28.41           C  
ATOM   1190  CG1 VAL B2058      30.273  17.064  41.174  1.00 30.05           C  
ATOM   1191  CG2 VAL B2058      31.990  18.279  39.938  1.00 26.46           C  
ATOM   1192  N   LEU B2059      32.717  20.819  42.865  1.00 29.41           N  
ATOM   1193  CA  LEU B2059      33.654  21.937  42.791  1.00 30.58           C  
ATOM   1194  C   LEU B2059      35.059  21.418  42.663  1.00 33.83           C  
ATOM   1195  O   LEU B2059      35.373  20.373  43.221  1.00 36.31           O  
ATOM   1196  CB  LEU B2059      33.570  22.747  44.059  1.00 25.46           C  
ATOM   1197  CG  LEU B2059      32.174  23.311  44.236  1.00 26.11           C  
ATOM   1198  CD1 LEU B2059      32.037  23.966  45.589  1.00 25.38           C  
ATOM   1199  CD2 LEU B2059      31.914  24.309  43.143  1.00 24.31           C  
ATOM   1200  N   PHE B2060      35.917  22.122  41.937  1.00 35.13           N  
ATOM   1201  CA  PHE B2060      37.301  21.645  41.832  1.00 37.12           C  
ATOM   1202  C   PHE B2060      38.308  22.670  42.329  1.00 37.99           C  
ATOM   1203  O   PHE B2060      37.947  23.806  42.655  1.00 42.45           O  
ATOM   1204  CB  PHE B2060      37.685  21.267  40.407  1.00 36.16           C  
ATOM   1205  CG  PHE B2060      36.750  20.302  39.752  1.00 40.37           C  
ATOM   1206  CD1 PHE B2060      35.657  20.761  39.007  1.00 43.00           C  
ATOM   1207  CD2 PHE B2060      36.971  18.935  39.835  1.00 40.30           C  
ATOM   1208  CE1 PHE B2060      34.796  19.863  38.342  1.00 46.42           C  
ATOM   1209  CE2 PHE B2060      36.114  18.035  39.176  1.00 42.44           C  
ATOM   1210  CZ  PHE B2060      35.030  18.502  38.430  1.00 45.44           C  
ATOM   1211  N   GLY B2061      39.572  22.259  42.377  1.00 37.16           N  
ATOM   1212  CA  GLY B2061      40.641  23.136  42.829  1.00 35.75           C  
ATOM   1213  C   GLY B2061      40.371  24.084  43.990  1.00 36.47           C  
ATOM   1214  O   GLY B2061      39.883  23.672  45.041  1.00 35.40           O  
ATOM   1215  N   LYS B2062      40.705  25.359  43.795  1.00 37.10           N  
ATOM   1216  CA  LYS B2062      40.497  26.392  44.810  1.00 36.94           C  
ATOM   1217  C   LYS B2062      39.065  26.417  45.378  1.00 38.49           C  
ATOM   1218  O   LYS B2062      38.868  26.426  46.602  1.00 38.52           O  
ATOM   1219  CB  LYS B2062      40.845  27.758  44.233  1.00 41.16           C  
ATOM   1220  N   LEU B2063      38.082  26.459  44.482  1.00 38.01           N  
ATOM   1221  CA  LEU B2063      36.673  26.461  44.857  1.00 40.48           C  
ATOM   1222  C   LEU B2063      36.417  25.279  45.769  1.00 40.02           C  
ATOM   1223  O   LEU B2063      35.594  25.332  46.697  1.00 37.40           O  
ATOM   1224  CB  LEU B2063      35.807  26.245  43.629  1.00 42.52           C  
ATOM   1225  CG  LEU B2063      35.715  27.194  42.447  1.00 43.85           C  
ATOM   1226  CD1 LEU B2063      35.066  28.448  42.938  1.00 39.63           C  
ATOM   1227  CD2 LEU B2063      37.083  27.417  41.805  1.00 46.63           C  
ATOM   1228  N   ALA B2064      37.098  24.184  45.438  1.00 39.08           N  
ATOM   1229  CA  ALA B2064      36.969  22.946  46.195  1.00 41.01           C  
ATOM   1230  C   ALA B2064      37.399  23.182  47.657  1.00 40.56           C  
ATOM   1231  O   ALA B2064      36.618  22.965  48.591  1.00 37.09           O  
ATOM   1232  CB  ALA B2064      37.815  21.810  45.527  1.00 42.03           C  
ATOM   1233  N   GLU B2065      38.630  23.655  47.845  1.00 42.73           N  
ATOM   1234  CA  GLU B2065      39.126  23.889  49.180  1.00 45.60           C  
ATOM   1235  C   GLU B2065      38.250  24.878  49.945  1.00 47.34           C  
ATOM   1236  O   GLU B2065      37.908  24.616  51.103  1.00 46.57           O  
ATOM   1237  CB  GLU B2065      40.600  24.312  49.128  1.00 48.47           C  
ATOM   1238  CG  GLU B2065      41.586  23.158  48.792  1.00 53.40           C  
ATOM   1239  CD  GLU B2065      41.583  22.008  49.834  1.00 58.57           C  
ATOM   1240  OE1 GLU B2065      42.664  21.461  50.175  1.00 60.46           O  
ATOM   1241  OE2 GLU B2065      40.491  21.633  50.317  1.00 62.09           O  
ATOM   1242  N   VAL B2066      37.852  25.989  49.321  1.00 49.07           N  
ATOM   1243  CA  VAL B2066      36.988  26.950  50.023  1.00 47.21           C  
ATOM   1244  C   VAL B2066      35.687  26.321  50.502  1.00 44.61           C  
ATOM   1245  O   VAL B2066      35.213  26.617  51.592  1.00 43.91           O  
ATOM   1246  CB  VAL B2066      36.580  28.137  49.153  1.00 48.09           C  
ATOM   1247  CG1 VAL B2066      35.811  27.667  47.916  1.00 51.98           C  
ATOM   1248  CG2 VAL B2066      35.690  29.046  49.968  1.00 47.73           C  
ATOM   1249  N   ALA B2067      35.097  25.480  49.657  1.00 46.74           N  
ATOM   1250  CA  ALA B2067      33.855  24.794  49.993  1.00 49.70           C  
ATOM   1251  C   ALA B2067      34.122  23.998  51.250  1.00 49.67           C  
ATOM   1252  O   ALA B2067      33.395  24.085  52.230  1.00 51.17           O  
ATOM   1253  CB  ALA B2067      33.445  23.869  48.863  1.00 50.17           C  
ATOM   1254  N   SER B2068      35.195  23.227  51.206  1.00 50.07           N  
ATOM   1255  CA  SER B2068      35.605  22.413  52.325  1.00 51.32           C  
ATOM   1256  C   SER B2068      35.830  23.281  53.534  1.00 52.02           C  
ATOM   1257  O   SER B2068      35.342  22.979  54.614  1.00 51.76           O  
ATOM   1258  CB  SER B2068      36.894  21.713  51.990  1.00 51.76           C  
ATOM   1259  OG  SER B2068      37.365  21.097  53.157  1.00 55.17           O  
ATOM   1260  N   GLU B2069      36.572  24.368  53.331  1.00 52.62           N  
ATOM   1261  CA  GLU B2069      36.910  25.316  54.392  1.00 50.17           C  
ATOM   1262  C   GLU B2069      35.724  26.074  55.028  1.00 49.79           C  
ATOM   1263  O   GLU B2069      35.496  25.971  56.246  1.00 50.24           O  
ATOM   1264  CB  GLU B2069      37.962  26.320  53.875  1.00 47.64           C  
ATOM   1265  N   TYR B2070      34.961  26.806  54.215  1.00 49.09           N  
ATOM   1266  CA  TYR B2070      33.857  27.599  54.742  1.00 47.86           C  
ATOM   1267  C   TYR B2070      32.412  27.073  54.599  1.00 47.21           C  
ATOM   1268  O   TYR B2070      31.532  27.499  55.339  1.00 48.58           O  
ATOM   1269  CB  TYR B2070      33.967  29.035  54.179  1.00 46.00           C  
ATOM   1270  N   LEU B2071      32.132  26.158  53.684  1.00 45.86           N  
ATOM   1271  CA  LEU B2071      30.754  25.700  53.557  1.00 44.67           C  
ATOM   1272  C   LEU B2071      30.389  24.567  54.509  1.00 47.14           C  
ATOM   1273  O   LEU B2071      31.152  23.622  54.692  1.00 48.45           O  
ATOM   1274  CB  LEU B2071      30.484  25.278  52.120  1.00 43.17           C  
ATOM   1275  CG  LEU B2071      29.769  26.209  51.134  1.00 40.41           C  
ATOM   1276  CD1 LEU B2071      30.054  27.649  51.426  1.00 36.42           C  
ATOM   1277  CD2 LEU B2071      30.217  25.851  49.735  1.00 39.02           C  
ATOM   1278  N   ARG B2072      29.211  24.668  55.122  1.00 48.63           N  
ATOM   1279  CA  ARG B2072      28.737  23.653  56.059  1.00 46.36           C  
ATOM   1280  C   ARG B2072      27.256  23.370  55.812  1.00 47.74           C  
ATOM   1281  O   ARG B2072      26.561  24.164  55.205  1.00 46.29           O  
ATOM   1282  CB  ARG B2072      28.959  24.120  57.484  1.00 40.13           C  
ATOM   1283  N   LYS B2073      26.788  22.234  56.298  1.00 50.67           N  
ATOM   1284  CA  LYS B2073      25.411  21.809  56.112  1.00 52.85           C  
ATOM   1285  C   LYS B2073      24.459  22.847  55.519  1.00 51.63           C  
ATOM   1286  O   LYS B2073      24.537  23.124  54.331  1.00 52.09           O  
ATOM   1287  CB  LYS B2073      24.822  21.276  57.426  1.00 59.27           C  
ATOM   1288  CG  LYS B2073      23.477  20.535  57.236  1.00 67.05           C  
ATOM   1289  CD  LYS B2073      22.784  20.236  58.579  1.00 74.36           C  
ATOM   1290  CE  LYS B2073      21.496  19.397  58.426  1.00 77.32           C  
ATOM   1291  NZ  LYS B2073      20.427  20.088  57.658  1.00 79.22           N  
ATOM   1292  N   GLY B2074      23.581  23.424  56.345  1.00 48.96           N  
ATOM   1293  CA  GLY B2074      22.577  24.370  55.870  1.00 45.79           C  
ATOM   1294  C   GLY B2074      22.962  25.627  55.107  1.00 45.27           C  
ATOM   1295  O   GLY B2074      22.118  26.472  54.820  1.00 45.47           O  
ATOM   1296  N   SER B2075      24.232  25.746  54.764  1.00 44.55           N  
ATOM   1297  CA  SER B2075      24.769  26.898  54.045  1.00 43.28           C  
ATOM   1298  C   SER B2075      24.060  27.212  52.702  1.00 41.98           C  
ATOM   1299  O   SER B2075      23.663  26.303  51.979  1.00 39.37           O  
ATOM   1300  CB  SER B2075      26.265  26.638  53.829  1.00 43.54           C  
ATOM   1301  OG  SER B2075      26.918  27.747  53.278  1.00 48.06           O  
ATOM   1302  N   GLN B2076      23.910  28.508  52.392  1.00 41.16           N  
ATOM   1303  CA  GLN B2076      23.269  29.014  51.162  1.00 38.38           C  
ATOM   1304  C   GLN B2076      24.330  29.483  50.199  1.00 37.78           C  
ATOM   1305  O   GLN B2076      25.127  30.355  50.531  1.00 38.16           O  
ATOM   1306  CB  GLN B2076      22.382  30.228  51.470  1.00 37.18           C  
ATOM   1307  CG  GLN B2076      21.585  30.736  50.263  1.00 41.32           C  
ATOM   1308  CD  GLN B2076      20.736  31.964  50.554  1.00 40.58           C  
ATOM   1309  OE1 GLN B2076      21.251  33.078  50.611  1.00 40.11           O  
ATOM   1310  NE2 GLN B2076      19.425  31.764  50.739  1.00 40.52           N  
ATOM   1311  N   VAL B2077      24.339  28.944  48.993  1.00 35.66           N  
ATOM   1312  CA  VAL B2077      25.350  29.378  48.041  1.00 31.66           C  
ATOM   1313  C   VAL B2077      24.769  29.748  46.685  1.00 30.80           C  
ATOM   1314  O   VAL B2077      23.595  29.502  46.412  1.00 30.76           O  
ATOM   1315  CB  VAL B2077      26.420  28.298  47.886  1.00 28.22           C  
ATOM   1316  CG1 VAL B2077      26.757  27.738  49.226  1.00 26.00           C  
ATOM   1317  CG2 VAL B2077      25.932  27.211  47.021  1.00 23.91           C  
ATOM   1318  N   TYR B2078      25.592  30.387  45.866  1.00 27.87           N  
ATOM   1319  CA  TYR B2078      25.208  30.784  44.516  1.00 26.98           C  
ATOM   1320  C   TYR B2078      26.201  30.009  43.676  1.00 27.76           C  
ATOM   1321  O   TYR B2078      27.388  30.049  43.962  1.00 29.34           O  
ATOM   1322  CB  TYR B2078      25.371  32.315  44.281  1.00 24.45           C  
ATOM   1323  CG  TYR B2078      25.439  32.760  42.798  1.00 20.07           C  
ATOM   1324  CD1 TYR B2078      24.283  32.919  41.997  1.00 20.52           C  
ATOM   1325  CD2 TYR B2078      26.671  32.929  42.178  1.00 17.16           C  
ATOM   1326  CE1 TYR B2078      24.382  33.220  40.607  1.00 17.39           C  
ATOM   1327  CE2 TYR B2078      26.777  33.230  40.801  1.00 18.97           C  
ATOM   1328  CZ  TYR B2078      25.645  33.367  40.023  1.00 19.69           C  
ATOM   1329  OH  TYR B2078      25.840  33.592  38.665  1.00 24.34           O  
ATOM   1330  N   ILE B2079      25.721  29.323  42.642  1.00 23.70           N  
ATOM   1331  CA  ILE B2079      26.577  28.508  41.801  1.00 22.94           C  
ATOM   1332  C   ILE B2079      26.371  28.761  40.315  1.00 25.49           C  
ATOM   1333  O   ILE B2079      25.243  28.778  39.839  1.00 25.29           O  
ATOM   1334  CB  ILE B2079      26.335  26.969  42.180  1.00 20.06           C  
ATOM   1335  CG1 ILE B2079      27.138  26.647  43.429  1.00 20.31           C  
ATOM   1336  CG2 ILE B2079      26.671  26.023  41.051  1.00  9.66           C  
ATOM   1337  CD1 ILE B2079      26.938  25.315  43.928  1.00 27.01           C  
ATOM   1338  N   GLU B2080      27.462  28.978  39.590  1.00 26.56           N  
ATOM   1339  CA  GLU B2080      27.391  29.147  38.135  1.00 27.66           C  
ATOM   1340  C   GLU B2080      28.269  28.037  37.485  1.00 24.72           C  
ATOM   1341  O   GLU B2080      29.491  28.074  37.612  1.00 24.97           O  
ATOM   1342  CB  GLU B2080      27.904  30.542  37.733  1.00 33.82           C  
ATOM   1343  CG  GLU B2080      27.567  31.025  36.315  1.00 43.46           C  
ATOM   1344  CD  GLU B2080      28.368  32.254  35.962  1.00 48.07           C  
ATOM   1345  OE1 GLU B2080      28.405  33.163  36.815  1.00 52.38           O  
ATOM   1346  OE2 GLU B2080      28.961  32.319  34.860  1.00 48.08           O  
ATOM   1347  N   GLY B2081      27.652  27.058  36.807  1.00 21.27           N  
ATOM   1348  CA  GLY B2081      28.427  25.992  36.200  1.00 19.41           C  
ATOM   1349  C   GLY B2081      27.894  25.452  34.891  1.00 19.60           C  
ATOM   1350  O   GLY B2081      27.108  26.114  34.211  1.00 20.46           O  
ATOM   1351  N   GLN B2082      28.340  24.252  34.531  1.00 20.99           N  
ATOM   1352  CA  GLN B2082      27.898  23.614  33.306  1.00 24.73           C  
ATOM   1353  C   GLN B2082      27.193  22.327  33.624  1.00 23.71           C  
ATOM   1354  O   GLN B2082      27.327  21.788  34.715  1.00 24.17           O  
ATOM   1355  CB  GLN B2082      29.078  23.285  32.435  1.00 28.08           C  
ATOM   1356  CG  GLN B2082      29.935  24.448  32.105  1.00 40.95           C  
ATOM   1357  CD  GLN B2082      31.087  24.038  31.205  1.00 48.21           C  
ATOM   1358  OE1 GLN B2082      31.950  23.212  31.586  1.00 51.50           O  
ATOM   1359  NE2 GLN B2082      31.111  24.605  29.994  1.00 50.92           N  
ATOM   1360  N   LEU B2083      26.457  21.818  32.657  1.00 23.28           N  
ATOM   1361  CA  LEU B2083      25.753  20.582  32.852  1.00 25.00           C  
ATOM   1362  C   LEU B2083      26.527  19.409  32.278  1.00 24.52           C  
ATOM   1363  O   LEU B2083      26.809  19.404  31.096  1.00 24.49           O  
ATOM   1364  CB  LEU B2083      24.427  20.695  32.160  1.00 21.05           C  
ATOM   1365  CG  LEU B2083      23.243  20.448  33.047  1.00 17.57           C  
ATOM   1366  CD1 LEU B2083      23.419  21.198  34.340  1.00 18.12           C  
ATOM   1367  CD2 LEU B2083      22.000  20.855  32.299  1.00 18.22           C  
ATOM   1368  N   ARG B2084      26.893  18.424  33.102  1.00 27.48           N  
ATOM   1369  CA  ARG B2084      27.614  17.224  32.609  1.00 27.72           C  
ATOM   1370  C   ARG B2084      26.994  15.907  33.064  1.00 26.26           C  
ATOM   1371  O   ARG B2084      26.698  15.716  34.237  1.00 27.40           O  
ATOM   1372  CB  ARG B2084      29.087  17.188  33.052  1.00 26.02           C  
ATOM   1373  CG  ARG B2084      29.744  15.852  32.625  1.00 30.42           C  
ATOM   1374  CD  ARG B2084      31.255  15.555  32.997  1.00 26.13           C  
ATOM   1375  NE  ARG B2084      31.504  15.218  34.406  1.00 22.80           N  
ATOM   1376  CZ  ARG B2084      32.633  15.468  35.080  1.00 23.46           C  
ATOM   1377  NH1 ARG B2084      33.665  16.055  34.472  1.00 21.85           N  
ATOM   1378  NH2 ARG B2084      32.682  15.254  36.399  1.00 19.65           N  
ATOM   1379  N   THR B2085      26.820  14.989  32.135  1.00 24.06           N  
ATOM   1380  CA  THR B2085      26.268  13.703  32.484  1.00 25.42           C  
ATOM   1381  C   THR B2085      27.247  12.637  32.132  1.00 24.58           C  
ATOM   1382  O   THR B2085      27.590  12.456  30.959  1.00 24.23           O  
ATOM   1383  CB  THR B2085      25.028  13.449  31.739  1.00 23.77           C  
ATOM   1384  OG1 THR B2085      24.030  14.299  32.292  1.00 31.97           O  
ATOM   1385  CG2 THR B2085      24.623  11.983  31.828  1.00 22.90           C  
ATOM   1386  N   ARG B2086      27.689  11.904  33.135  1.00 22.21           N  
ATOM   1387  CA  ARG B2086      28.676  10.870  32.874  1.00 21.22           C  
ATOM   1388  C   ARG B2086      28.165   9.479  33.052  1.00 16.20           C  
ATOM   1389  O   ARG B2086      27.377   9.207  33.958  1.00 13.72           O  
ATOM   1390  CB  ARG B2086      29.854  11.089  33.776  1.00 24.72           C  
ATOM   1391  CG  ARG B2086      29.412  11.712  35.029  1.00 29.96           C  
ATOM   1392  CD  ARG B2086      30.540  12.466  35.523  1.00 31.53           C  
ATOM   1393  NE  ARG B2086      31.491  11.530  36.035  1.00 36.77           N  
ATOM   1394  CZ  ARG B2086      31.224  10.724  37.040  1.00 42.57           C  
ATOM   1395  NH1 ARG B2086      30.038  10.785  37.631  1.00 36.72           N  
ATOM   1396  NH2 ARG B2086      32.130   9.830  37.404  1.00 47.46           N  
ATOM   1397  N   LYS B2087      28.633   8.589  32.186  1.00 18.09           N  
ATOM   1398  CA  LYS B2087      28.194   7.223  32.279  1.00 20.87           C  
ATOM   1399  C   LYS B2087      29.200   6.368  33.017  1.00 18.73           C  
ATOM   1400  O   LYS B2087      30.407   6.626  32.975  1.00 22.03           O  
ATOM   1401  CB  LYS B2087      27.929   6.647  30.899  1.00 21.98           C  
ATOM   1402  CG  LYS B2087      29.139   6.074  30.231  1.00 26.43           C  
ATOM   1403  CD  LYS B2087      28.803   5.534  28.850  1.00 31.41           C  
ATOM   1404  CE  LYS B2087      27.699   4.514  28.937  1.00 23.06           C  
ATOM   1405  NZ  LYS B2087      27.513   3.886  27.620  1.00 26.40           N  
ATOM   1406  N   TRP B2088      28.685   5.369  33.728  1.00 23.17           N  
ATOM   1407  CA  TRP B2088      29.519   4.422  34.444  1.00 24.57           C  
ATOM   1408  C   TRP B2088      28.727   3.141  34.648  1.00 24.54           C  
ATOM   1409  O   TRP B2088      27.561   3.196  34.978  1.00 24.17           O  
ATOM   1410  CB  TRP B2088      29.970   5.011  35.784  1.00 28.68           C  
ATOM   1411  CG  TRP B2088      29.108   4.661  36.930  1.00 38.85           C  
ATOM   1412  CD1 TRP B2088      29.279   3.623  37.816  1.00 45.99           C  
ATOM   1413  CD2 TRP B2088      27.858   5.236  37.227  1.00 40.28           C  
ATOM   1414  NE1 TRP B2088      28.186   3.513  38.637  1.00 47.10           N  
ATOM   1415  CE2 TRP B2088      27.295   4.491  38.294  1.00 45.58           C  
ATOM   1416  CE3 TRP B2088      27.149   6.295  36.690  1.00 36.02           C  
ATOM   1417  CZ2 TRP B2088      26.063   4.771  38.815  1.00 44.83           C  
ATOM   1418  CZ3 TRP B2088      25.938   6.568  37.195  1.00 41.19           C  
ATOM   1419  CH2 TRP B2088      25.390   5.807  38.254  1.00 45.93           C  
ATOM   1420  N   THR B2089      29.344   1.990  34.402  1.00 28.48           N  
ATOM   1421  CA  THR B2089      28.670   0.693  34.626  1.00 28.21           C  
ATOM   1422  C   THR B2089      28.804   0.332  36.116  1.00 29.61           C  
ATOM   1423  O   THR B2089      29.882   0.488  36.715  1.00 27.29           O  
ATOM   1424  CB  THR B2089      29.285  -0.457  33.775  1.00 27.72           C  
ATOM   1425  OG1 THR B2089      30.644  -0.161  33.477  1.00 33.66           O  
ATOM   1426  CG2 THR B2089      28.590  -0.608  32.481  1.00 29.45           C  
ATOM   1427  N   ASP B2090      27.723  -0.136  36.732  1.00 34.01           N  
ATOM   1428  CA  ASP B2090      27.787  -0.465  38.151  1.00 39.79           C  
ATOM   1429  C   ASP B2090      28.066  -1.930  38.408  1.00 39.73           C  
ATOM   1430  O   ASP B2090      28.029  -2.736  37.488  1.00 37.78           O  
ATOM   1431  CB  ASP B2090      26.489  -0.074  38.835  1.00 48.27           C  
ATOM   1432  CG  ASP B2090      26.678   0.244  40.317  1.00 58.73           C  
ATOM   1433  OD1 ASP B2090      25.636   0.458  40.989  1.00 64.38           O  
ATOM   1434  OD2 ASP B2090      27.850   0.289  40.801  1.00 61.29           O  
ATOM   1435  N   GLN B2091      28.333  -2.281  39.661  1.00 39.69           N  
ATOM   1436  CA  GLN B2091      28.622  -3.669  39.994  1.00 39.57           C  
ATOM   1437  C   GLN B2091      27.424  -4.544  39.701  1.00 39.74           C  
ATOM   1438  O   GLN B2091      26.858  -5.151  40.584  1.00 45.57           O  
ATOM   1439  CB  GLN B2091      28.999  -3.790  41.453  1.00 35.98           C  
ATOM   1440  CG  GLN B2091      30.164  -2.936  41.850  1.00 34.76           C  
ATOM   1441  CD  GLN B2091      30.408  -2.985  43.352  1.00 37.14           C  
ATOM   1442  OE1 GLN B2091      29.460  -2.852  44.136  1.00 36.21           O  
ATOM   1443  NE2 GLN B2091      31.674  -3.164  43.768  1.00 37.75           N  
ATOM   1444  N   SER B2092      27.041  -4.635  38.448  1.00 39.38           N  
ATOM   1445  CA  SER B2092      25.875  -5.411  38.133  1.00 37.17           C  
ATOM   1446  C   SER B2092      25.935  -5.526  36.643  1.00 37.14           C  
ATOM   1447  O   SER B2092      25.171  -6.277  36.043  1.00 35.88           O  
ATOM   1448  CB  SER B2092      24.625  -4.623  38.539  1.00 37.87           C  
ATOM   1449  OG  SER B2092      23.750  -5.352  39.377  1.00 40.57           O  
ATOM   1450  N   GLY B2093      26.834  -4.751  36.047  1.00 38.69           N  
ATOM   1451  CA  GLY B2093      26.980  -4.777  34.609  1.00 39.40           C  
ATOM   1452  C   GLY B2093      25.966  -3.887  33.930  1.00 38.31           C  
ATOM   1453  O   GLY B2093      25.843  -3.896  32.707  1.00 41.30           O  
ATOM   1454  N   GLN B2094      25.230  -3.124  34.724  1.00 38.44           N  
ATOM   1455  CA  GLN B2094      24.239  -2.201  34.184  1.00 41.49           C  
ATOM   1456  C   GLN B2094      24.775  -0.755  34.015  1.00 39.75           C  
ATOM   1457  O   GLN B2094      25.311  -0.142  34.959  1.00 38.64           O  
ATOM   1458  CB  GLN B2094      22.970  -2.204  35.056  1.00 45.70           C  
ATOM   1459  CG  GLN B2094      23.178  -2.391  36.571  1.00 48.70           C  
ATOM   1460  CD  GLN B2094      24.324  -1.550  37.173  1.00 50.64           C  
ATOM   1461  OE1 GLN B2094      25.508  -1.863  36.998  1.00 50.34           O  
ATOM   1462  NE2 GLN B2094      23.967  -0.487  37.890  1.00 45.92           N  
ATOM   1463  N   ASP B2095      24.635  -0.226  32.796  1.00 37.39           N  
ATOM   1464  CA  ASP B2095      25.065   1.138  32.485  1.00 41.06           C  
ATOM   1465  C   ASP B2095      24.225   2.157  33.239  1.00 39.37           C  
ATOM   1466  O   ASP B2095      23.000   2.080  33.250  1.00 37.62           O  
ATOM   1467  CB  ASP B2095      24.929   1.450  30.995  1.00 41.53           C  
ATOM   1468  CG  ASP B2095      25.955   0.743  30.150  1.00 43.54           C  
ATOM   1469  OD1 ASP B2095      27.028   0.407  30.674  1.00 44.73           O  
ATOM   1470  OD2 ASP B2095      25.701   0.536  28.946  1.00 47.88           O  
ATOM   1471  N   ARG B2096      24.888   3.119  33.852  1.00 38.20           N  
ATOM   1472  CA  ARG B2096      24.194   4.149  34.592  1.00 38.61           C  
ATOM   1473  C   ARG B2096      24.701   5.486  34.114  1.00 34.61           C  
ATOM   1474  O   ARG B2096      25.818   5.576  33.626  1.00 35.58           O  
ATOM   1475  CB  ARG B2096      24.529   4.096  36.079  1.00 38.82           C  
ATOM   1476  CG  ARG B2096      24.362   2.809  36.818  1.00 39.54           C  
ATOM   1477  CD  ARG B2096      23.020   2.706  37.459  1.00 37.90           C  
ATOM   1478  NE  ARG B2096      22.101   2.055  36.536  1.00 44.47           N  
ATOM   1479  CZ  ARG B2096      20.948   1.504  36.901  1.00 49.92           C  
ATOM   1480  NH1 ARG B2096      20.589   1.538  38.180  1.00 49.99           N  
ATOM   1481  NH2 ARG B2096      20.163   0.909  36.001  1.00 53.30           N  
ATOM   1482  N   TYR B2097      23.885   6.520  34.274  1.00 28.94           N  
ATOM   1483  CA  TYR B2097      24.279   7.871  33.933  1.00 22.29           C  
ATOM   1484  C   TYR B2097      24.060   8.810  35.080  1.00 18.85           C  
ATOM   1485  O   TYR B2097      23.237   8.599  35.967  1.00 24.85           O  
ATOM   1486  CB  TYR B2097      23.492   8.399  32.786  1.00 19.37           C  
ATOM   1487  CG  TYR B2097      23.819   7.719  31.524  1.00 20.54           C  
ATOM   1488  CD1 TYR B2097      23.303   6.471  31.258  1.00 21.11           C  
ATOM   1489  CD2 TYR B2097      24.595   8.345  30.561  1.00 18.01           C  
ATOM   1490  CE1 TYR B2097      23.530   5.845  30.043  1.00 22.78           C  
ATOM   1491  CE2 TYR B2097      24.846   7.740  29.335  1.00 21.35           C  
ATOM   1492  CZ  TYR B2097      24.305   6.478  29.079  1.00 26.58           C  
ATOM   1493  OH  TYR B2097      24.556   5.829  27.879  1.00 36.38           O  
ATOM   1494  N   THR B2098      24.830   9.866  35.092  1.00 20.75           N  
ATOM   1495  CA  THR B2098      24.629  10.823  36.134  1.00 24.93           C  
ATOM   1496  C   THR B2098      25.044  12.199  35.723  1.00 25.70           C  
ATOM   1497  O   THR B2098      26.179  12.455  35.260  1.00 23.68           O  
ATOM   1498  CB  THR B2098      25.291  10.431  37.366  1.00 25.96           C  
ATOM   1499  OG1 THR B2098      25.856   9.137  37.202  1.00 26.72           O  
ATOM   1500  CG2 THR B2098      24.259  10.346  38.438  1.00 33.56           C  
ATOM   1501  N   THR B2099      24.061  13.078  35.874  1.00 23.93           N  
ATOM   1502  CA  THR B2099      24.207  14.445  35.489  1.00 21.18           C  
ATOM   1503  C   THR B2099      24.433  15.264  36.746  1.00 21.03           C  
ATOM   1504  O   THR B2099      23.835  14.986  37.802  1.00 20.26           O  
ATOM   1505  CB  THR B2099      22.961  14.875  34.758  1.00 22.00           C  
ATOM   1506  OG1 THR B2099      22.097  15.541  35.662  1.00 27.97           O  
ATOM   1507  CG2 THR B2099      22.207  13.662  34.293  1.00 18.43           C  
ATOM   1508  N   GLU B2100      25.358  16.219  36.633  1.00 21.51           N  
ATOM   1509  CA  GLU B2100      25.659  17.129  37.712  1.00 21.99           C  
ATOM   1510  C   GLU B2100      26.078  18.471  37.165  1.00 18.84           C  
ATOM   1511  O   GLU B2100      26.386  18.614  35.987  1.00 16.82           O  
ATOM   1512  CB  GLU B2100      26.790  16.644  38.546  1.00 27.23           C  
ATOM   1513  CG  GLU B2100      26.739  15.276  39.014  1.00 42.32           C  
ATOM   1514  CD  GLU B2100      28.044  14.993  39.681  1.00 48.83           C  
ATOM   1515  OE1 GLU B2100      29.059  15.343  39.054  1.00 52.55           O  
ATOM   1516  OE2 GLU B2100      28.105  14.426  40.795  1.00 51.09           O  
ATOM   1517  N   VAL B2101      26.113  19.445  38.060  1.00 15.28           N  
ATOM   1518  CA  VAL B2101      26.502  20.793  37.736  1.00 14.81           C  
ATOM   1519  C   VAL B2101      27.942  20.900  38.166  1.00 13.49           C  
ATOM   1520  O   VAL B2101      28.254  20.748  39.338  1.00 12.52           O  
ATOM   1521  CB  VAL B2101      25.636  21.787  38.531  1.00 13.64           C  
ATOM   1522  CG1 VAL B2101      26.110  23.235  38.288  1.00  2.81           C  
ATOM   1523  CG2 VAL B2101      24.153  21.567  38.150  1.00  5.54           C  
ATOM   1524  N   VAL B2102      28.821  21.181  37.225  1.00 14.99           N  
ATOM   1525  CA  VAL B2102      30.222  21.285  37.550  1.00 19.91           C  
ATOM   1526  C   VAL B2102      30.764  22.677  37.409  1.00 22.02           C  
ATOM   1527  O   VAL B2102      30.592  23.339  36.395  1.00 25.45           O  
ATOM   1528  CB  VAL B2102      30.972  20.351  36.679  1.00 20.66           C  
ATOM   1529  CG1 VAL B2102      30.153  19.127  36.615  1.00 16.22           C  
ATOM   1530  CG2 VAL B2102      31.147  20.928  35.298  1.00 22.22           C  
ATOM   1531  N   VAL B2103      31.447  23.122  38.436  1.00 24.37           N  
ATOM   1532  CA  VAL B2103      31.983  24.450  38.408  1.00 24.19           C  
ATOM   1533  C   VAL B2103      33.415  24.456  37.933  1.00 25.26           C  
ATOM   1534  O   VAL B2103      34.335  24.285  38.726  1.00 23.04           O  
ATOM   1535  CB  VAL B2103      31.852  25.056  39.793  1.00 24.12           C  
ATOM   1536  CG1 VAL B2103      32.171  26.524  39.754  1.00 21.06           C  
ATOM   1537  CG2 VAL B2103      30.432  24.819  40.301  1.00 29.89           C  
ATOM   1538  N   ASN B2104      33.602  24.656  36.628  1.00 27.28           N  
ATOM   1539  CA  ASN B2104      34.958  24.667  36.039  1.00 31.90           C  
ATOM   1540  C   ASN B2104      35.403  26.022  35.476  1.00 36.04           C  
ATOM   1541  O   ASN B2104      35.670  26.976  36.227  1.00 36.68           O  
ATOM   1542  CB  ASN B2104      35.091  23.563  34.925  1.00 30.12           C  
ATOM   1543  N   VAL B2105      35.499  26.053  34.145  1.00 39.59           N  
ATOM   1544  CA  VAL B2105      35.905  27.216  33.377  1.00 45.75           C  
ATOM   1545  C   VAL B2105      35.281  28.516  33.871  1.00 48.77           C  
ATOM   1546  O   VAL B2105      35.649  29.042  34.937  1.00 49.36           O  
ATOM   1547  CB  VAL B2105      35.573  27.010  31.879  1.00 44.93           C  
ATOM   1548  N   GLY B2106      34.341  29.037  33.094  1.00 47.72           N  
ATOM   1549  CA  GLY B2106      33.727  30.300  33.456  1.00 49.10           C  
ATOM   1550  C   GLY B2106      32.649  30.123  34.483  1.00 48.36           C  
ATOM   1551  O   GLY B2106      31.566  30.687  34.349  1.00 51.16           O  
ATOM   1552  N   GLY B2107      32.949  29.328  35.505  1.00 45.06           N  
ATOM   1553  CA  GLY B2107      31.993  29.063  36.560  1.00 39.86           C  
ATOM   1554  C   GLY B2107      32.458  29.701  37.843  1.00 37.85           C  
ATOM   1555  O   GLY B2107      33.596  30.148  37.922  1.00 39.20           O  
ATOM   1556  N   THR B2108      31.585  29.732  38.844  1.00 32.06           N  
ATOM   1557  CA  THR B2108      31.899  30.362  40.113  1.00 30.88           C  
ATOM   1558  C   THR B2108      31.006  29.782  41.215  1.00 30.41           C  
ATOM   1559  O   THR B2108      29.954  29.192  40.943  1.00 29.69           O  
ATOM   1560  CB  THR B2108      31.650  31.920  40.015  1.00 32.67           C  
ATOM   1561  OG1 THR B2108      30.494  32.291  40.770  1.00 30.48           O  
ATOM   1562  CG2 THR B2108      31.327  32.320  38.591  1.00 32.07           C  
ATOM   1563  N   MET B2109      31.446  29.977  42.454  1.00 29.09           N  
ATOM   1564  CA  MET B2109      30.736  29.547  43.640  1.00 31.78           C  
ATOM   1565  C   MET B2109      30.878  30.793  44.532  1.00 36.36           C  
ATOM   1566  O   MET B2109      31.831  31.575  44.389  1.00 39.46           O  
ATOM   1567  CB  MET B2109      31.434  28.311  44.241  1.00 28.16           C  
ATOM   1568  CG  MET B2109      30.725  27.590  45.381  1.00 22.44           C  
ATOM   1569  SD  MET B2109      30.853  28.446  46.957  1.00 29.99           S  
ATOM   1570  CE  MET B2109      32.623  28.209  47.394  1.00 29.83           C  
ATOM   1571  N   GLN B2110      29.909  31.006  45.417  1.00 39.56           N  
ATOM   1572  CA  GLN B2110      29.955  32.141  46.299  1.00 38.91           C  
ATOM   1573  C   GLN B2110      29.035  31.938  47.478  1.00 39.80           C  
ATOM   1574  O   GLN B2110      27.905  31.509  47.308  1.00 39.54           O  
ATOM   1575  CB  GLN B2110      29.568  33.375  45.521  1.00 39.28           C  
ATOM   1576  CG  GLN B2110      30.140  34.622  46.128  1.00 39.35           C  
ATOM   1577  CD  GLN B2110      29.978  35.816  45.226  1.00 36.71           C  
ATOM   1578  OE1 GLN B2110      30.451  35.806  44.082  1.00 36.63           O  
ATOM   1579  NE2 GLN B2110      29.307  36.863  45.734  1.00 33.69           N  
ATOM   1580  N   MET B2111      29.543  32.232  48.669  1.00 43.00           N  
ATOM   1581  CA  MET B2111      28.792  32.109  49.921  1.00 46.69           C  
ATOM   1582  C   MET B2111      27.809  33.255  50.035  1.00 45.47           C  
ATOM   1583  O   MET B2111      28.195  34.400  49.887  1.00 45.43           O  
ATOM   1584  CB  MET B2111      29.759  32.186  51.111  1.00 52.57           C  
ATOM   1585  CG  MET B2111      30.786  31.051  51.177  1.00 61.49           C  
ATOM   1586  SD  MET B2111      32.441  31.577  51.674  1.00 73.03           S  
ATOM   1587  CE  MET B2111      32.213  32.086  53.368  1.00 68.09           C  
ATOM   1588  N   LEU B2112      26.547  32.971  50.313  1.00 45.48           N  
ATOM   1589  CA  LEU B2112      25.590  34.059  50.420  1.00 45.93           C  
ATOM   1590  C   LEU B2112      25.264  34.364  51.865  1.00 49.81           C  
ATOM   1591  O   LEU B2112      25.140  33.449  52.688  1.00 50.37           O  
ATOM   1592  CB  LEU B2112      24.298  33.748  49.664  1.00 40.11           C  
ATOM   1593  CG  LEU B2112      24.353  33.378  48.174  1.00 37.76           C  
ATOM   1594  CD1 LEU B2112      22.942  33.184  47.657  1.00 40.04           C  
ATOM   1595  CD2 LEU B2112      25.068  34.442  47.369  1.00 36.53           C  
ATOM   1596  N   GLY B2113      25.137  35.667  52.145  1.00 54.38           N  
ATOM   1597  CA  GLY B2113      24.822  36.163  53.476  1.00 57.56           C  
ATOM   1598  C   GLY B2113      25.947  36.005  54.477  1.00 58.75           C  
ATOM   1599  O   GLY B2113      26.916  35.280  54.153  1.00 60.77           O  
TER    1600      GLY B2113                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
