
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  359 ( 2624),  selected  359 , name 3c4n_A
# Molecule2: number of CA atoms  366 ( 2688),  selected  366 , name T0490.pdb
# PARAMETERS: 3c4n_A.T0490.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    34_A      -       -           -
LGA    E    35_A      T       3          3.889
LGA    A    36_A      D       4          2.017
LGA    F    37_A      I       5          1.255
LGA    D    38_A      D       6          1.833
LGA    I    39_A      C       7          1.215
LGA    V    40_A      I       8          0.733
LGA    V    41_A      V       9          0.231
LGA    I    42_A      I      10          0.405
LGA    G    43_A      G      11          0.357
LGA    A    44_A      A      12          0.452
LGA    G    45_A      G      13          0.461
LGA    R    46_A      V      14          0.756
LGA    X    47_A      V      15          0.754
LGA    G    48_A      G      16          0.224
LGA    A    49_A      L      17          0.412
LGA    A    50_A      A      18          0.500
LGA    C    51_A      I      19          0.725
LGA    A    52_A      A      20          0.692
LGA    F    53_A      R      21          0.650
LGA    Y    54_A      A      22          1.026
LGA    L    55_A      L      23          1.212
LGA    R    56_A      A      24          1.362
LGA    Q    57_A      A      25          1.738
LGA    L    58_A      G      26          2.707
LGA    A    59_A      -       -           -
LGA    P    60_A      G      27          0.529
LGA    G    61_A      H      28          3.896
LGA    R    62_A      -       -           -
LGA    S    63_A      E      29          1.885
LGA    L    64_A      V      30          1.577
LGA    L    65_A      L      31          0.910
LGA    L    66_A      V      32          0.509
LGA    V    67_A      A      33          0.705
LGA    E    68_A      E      34          0.891
LGA    E    69_A      A      35          1.619
LGA    G    70_A      A      36          1.819
LGA    -       -      E      37           -
LGA    G    71_A      G      38          0.494
LGA    L    72_A      I      39          2.776
LGA    P    73_A      G      40          4.261
LGA    N    74_A      T      41          2.580
LGA    E    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    G    77_A      G      42          1.137
LGA    A    78_A      T      43          1.223
LGA    T    79_A      S      44          0.721
LGA    I    80_A      S      45          1.603
LGA    L    81_A      R      46          2.361
LGA    A    82_A      N      47          1.722
LGA    P    83_A      S      48          1.572
LGA    G    84_A      E      49          2.129
LGA    V    85_A      V      50          1.524
LGA    W    86_A      I      51          2.414
LGA    T    87_A      H      52          2.857
LGA    A    88_A      A      53          2.941
LGA    Q    89_A      G      54          5.001
LGA    D    90_A      I      55          4.398
LGA    I    91_A      Y      56          4.425
LGA    P    92_A      Y      57          1.240
LGA    A    93_A      P      58          2.348
LGA    G    94_A      A      59          2.487
LGA    Q    95_A      D      60          3.912
LGA    -       -      S      61           -
LGA    -       -      L      62           -
LGA    -       -      K      63           -
LGA    E    96_A      A      64          4.523
LGA    A    97_A      R      65          3.595
LGA    Q    98_A      L      66          2.171
LGA    A    99_A      C      67          2.546
LGA    E   100_A      V      68          2.583
LGA    W   101_A      R      69          1.627
LGA    T   102_A      G      70          0.607
LGA    R   103_A      K      71          1.350
LGA    E   104_A      H      72          1.623
LGA    Q   105_A      L      73          1.188
LGA    L   106_A      L      74          1.016
LGA    L   107_A      Y      75          1.538
LGA    G   108_A      E      76          1.515
LGA    A   109_A      Y      77          0.953
LGA    L   110_A      C      78           #
LGA    G   111_A      A      79           -
LGA    S   112_A      -       -           -
LGA    G   113_A      A      80          4.295
LGA    K   114_A      R      81          1.806
LGA    T   115_A      G      82          1.514
LGA    L   116_A      V      83          1.892
LGA    E   117_A      P      84          2.183
LGA    V   118_A      H      85          2.514
LGA    E   119_A      Q      86          1.599
LGA    D   120_A      R      87          1.419
LGA    R   121_A      L      88          1.519
LGA    P   122_A      G      89          1.494
LGA    L   123_A      K      90          0.936
LGA    L   124_A      L      91          0.967
LGA    H   125_A      I      92          1.394
LGA    L   126_A      V      93          1.338
LGA    L   127_A      A      94          1.056
LGA    P   128_A      T      95          2.122
LGA    A   129_A      S      96          2.368
LGA    -       -      D      97           -
LGA    -       -      A      98           -
LGA    -       -      E      99           -
LGA    G   130_A      A     100          3.025
LGA    E   131_A      S     101          3.113
LGA    G   132_A      Q     102          4.782
LGA    S   133_A      L     103          4.142
LGA    G   134_A      D     104          4.546
LGA    -       -      S     105           -
LGA    -       -      I     106           -
LGA    -       -      A     107           -
LGA    -       -      R     108           -
LGA    -       -      R     109           -
LGA    -       -      A     110           -
LGA    -       -      G     111           -
LGA    -       -      A     112           -
LGA    -       -      N     113           -
LGA    -       -      G     114           -
LGA    -       -      V     115           -
LGA    -       -      D     116           -
LGA    -       -      D     117           -
LGA    -       -      L     118           -
LGA    -       -      Q     119           -
LGA    L   135_A      H     120          3.368
LGA    T   136_A      I     121          1.780
LGA    P   137_A      D     122          2.261
LGA    T   138_A      G     123          3.447
LGA    L   139_A      A     124          3.201
LGA    D   140_A      A     125          1.762
LGA    A   141_A      A     126          2.288
LGA    L   142_A      R     127          3.919
LGA    A   143_A      R     128          1.918
LGA    D   144_A      L     129          4.207
LGA    F   145_A      E     130          3.414
LGA    P   146_A      P     131          3.277
LGA    E   147_A      -       -           -
LGA    A   148_A      -       -           -
LGA    L   149_A      A     132          1.210
LGA    A   150_A      -       -           -
LGA    L   151_A      -       -           -
LGA    L   152_A      -       -           -
LGA    D   153_A      L     133           #
LGA    P   154_A      H     134          1.758
LGA    A   155_A      -       -           -
LGA    R   156_A      -       -           -
LGA    L   157_A      C     135          2.614
LGA    P   158_A      T     136          2.113
LGA    V   159_A      A     137          1.554
LGA    A   160_A      A     138          1.619
LGA    R   161_A      L     139          1.968
LGA    V   162_A      V     140          1.655
LGA    D   163_A      S     141          1.020
LGA    P   164_A      P     142          1.693
LGA    R   165_A      S     143          1.633
LGA    A   166_A      T     144          1.083
LGA    L   167_A      G     145          1.651
LGA    T   168_A      I     146          1.338
LGA    Y   169_A      V     147          0.981
LGA    R   170_A      D     148          1.804
LGA    P   171_A      S     149          2.026
LGA    G   172_A      H     150          1.959
LGA    S   173_A      A     151          1.823
LGA    L   174_A      L     152          1.729
LGA    A   175_A      M     153          1.807
LGA    L   176_A      L     154          1.683
LGA    L   177_A      A     155          1.018
LGA    A   178_A      Y     156          0.889
LGA    A   179_A      Q     157          1.457
LGA    Q   180_A      G     158          1.427
LGA    Q   181_A      D     159          0.569
LGA    A   182_A      A     160          0.509
LGA    I   183_A      E     161          1.052
LGA    G   184_A      S     162          1.152
LGA    Q   185_A      D     163          0.634
LGA    G   186_A      G     164          0.547
LGA    A   187_A      A     165          0.863
LGA    G   188_A      Q     166          2.223
LGA    L   189_A      L     167          1.683
LGA    L   190_A      V     168          0.790
LGA    L   191_A      F     169          1.110
LGA    N   192_A      H     170          1.702
LGA    T   193_A      T     171          1.214
LGA    R   194_A      P     172          1.029
LGA    A   195_A      L     173          1.373
LGA    E   196_A      I     174          1.696
LGA    L   197_A      A     175          2.965
LGA    V   198_A      G     176          1.205
LGA    P   199_A      R     177          1.048
LGA    G   200_A      V     178          3.429
LGA    -       -      R     179           -
LGA    -       -      P     180           -
LGA    -       -      E     181           -
LGA    -       -      G     182           -
LGA    -       -      G     183           -
LGA    -       -      F     184           -
LGA    G   201_A      E     185          2.118
LGA    V   202_A      L     186          1.671
LGA    R   203_A      D     187          1.467
LGA    L   204_A      F     188          1.791
LGA    H   205_A      G     189          2.149
LGA    R   206_A      G     190          3.434
LGA    L   207_A      A     191          2.450
LGA    T   208_A      -       -           -
LGA    V   216_A      -       -           -
LGA    V   217_A      -       -           -
LGA    H   218_A      -       -           -
LGA    E   219_A      E     192          1.964
LGA    T   220_A      P     193          1.269
LGA    R   221_A      M     194          0.415
LGA    Q   222_A      T     195          0.631
LGA    I   223_A      L     196          0.715
LGA    R   224_A      S     197          0.905
LGA    A   225_A      C     198          1.549
LGA    G   226_A      R     199          1.866
LGA    V   227_A      V     200          1.813
LGA    I   228_A      L     201          1.252
LGA    I   229_A      I     202          0.914
LGA    V   230_A      N     203          0.971
LGA    A   231_A      A     204          0.804
LGA    A   232_A      A     205          1.117
LGA    G   233_A      G     206          0.864
LGA    A   234_A      L     207          0.833
LGA    A   235_A      H     208          1.507
LGA    G   236_A      A     209          1.226
LGA    P   237_A      P     210          1.527
LGA    A   238_A      G     211          1.677
LGA    L   239_A      L     212          1.700
LGA    V   240_A      A     213          1.968
LGA    E   241_A      R     214          2.457
LGA    Q   242_A      -       -           -
LGA    G   243_A      R     215          1.244
LGA    L   244_A      I     216          3.098
LGA    G   245_A      E     217           #
LGA    -       -      G     218           -
LGA    -       -      I     219           -
LGA    L   246_A      P     220           #
LGA    H   247_A      R     221          4.465
LGA    -       -      D     222           -
LGA    -       -      S     223           -
LGA    T   248_A      I     224          2.954
LGA    R   249_A      P     225          2.824
LGA    H   250_A      P     226          4.153
LGA    -       -      E     227           -
LGA    G   251_A      Y     228          2.270
LGA    R   252_A      L     229          2.025
LGA    A   253_A      C     230          1.272
LGA    Y   254_A      K     231          1.526
LGA    R   255_A      G     232          1.462
LGA    Q   256_A      S     233          1.781
LGA    F   257_A      Y     234          2.111
LGA    P   258_A      F     235          2.039
LGA    R   259_A      T     236          1.391
LGA    L   260_A      L     237          2.015
LGA    D   261_A      A     238          2.081
LGA    L   262_A      G     239          4.332
LGA    L   263_A      R     240          2.348
LGA    S   264_A      A     241          2.473
LGA    G   265_A      P     242           -
LGA    A   266_A      -       -           -
LGA    Q   267_A      -       -           -
LGA    T   268_A      F     243          4.651
LGA    -       -      S     244           -
LGA    P   269_A      R     245          0.510
LGA    V   270_A      L     246          0.459
LGA    L   271_A      I     247          0.459
LGA    R   272_A      Y     248          1.173
LGA    A   273_A      P     249          2.278
LGA    -       -      V     250           -
LGA    -       -      P     251           -
LGA    -       -      Q     252           -
LGA    S   274_A      H     253          3.986
LGA    -       -      A     254           -
LGA    -       -      G     255           -
LGA    -       -      L     256           -
LGA    G   275_A      G     257          2.715
LGA    L   276_A      V     258          1.965
LGA    T   277_A      H     259          1.070
LGA    L   278_A      L     260          0.961
LGA    R   279_A      T     261          0.891
LGA    P   280_A      L     262          1.226
LGA    Q   281_A      D     263          1.597
LGA    -       -      L     264           -
LGA    N   282_A      G     265          2.536
LGA    G   283_A      G     266          2.726
LGA    G   284_A      Q     267          1.508
LGA    Y   285_A      A     268          1.121
LGA    T   286_A      K     269          1.964
LGA    L   287_A      F     270          1.791
LGA    V   288_A      G     271          2.355
LGA    P   289_A      P     272          1.945
LGA    A   290_A      D     273          3.889
LGA    I   291_A      T     274          3.215
LGA    H   292_A      E     275           #
LGA    H   293_A      -       -           -
LGA    R   294_A      W     276          3.955
LGA    D   295_A      I     277          2.914
LGA    P   296_A      -       -           -
LGA    H   297_A      -       -           -
LGA    G   298_A      A     278          3.156
LGA    Y   299_A      T     279          4.095
LGA    -       -      E     280           -
LGA    H   300_A      D     281          5.083
LGA    P   301_A      Y     282           #
LGA    A   302_A      T     283           #
LGA    G   303_A      L     284           #
LGA    G   304_A      -       -           -
LGA    S   305_A      -       -           -
LGA    L   306_A      -       -           -
LGA    T   307_A      -       -           -
LGA    G   308_A      -       -           -
LGA    V   309_A      -       -           -
LGA    P   310_A      -       -           -
LGA    T   311_A      D     285           #
LGA    G   312_A      P     286          2.309
LGA    L   313_A      R     287          4.198
LGA    R   314_A      -       -           -
LGA    R   315_A      -       -           -
LGA    E   316_A      R     288           #
LGA    L   317_A      A     289           #
LGA    L   318_A      D     290          3.910
LGA    E   319_A      V     291          3.438
LGA    D   320_A      -       -           -
LGA    L   321_A      F     292          1.558
LGA    V   322_A      Y     293          4.777
LGA    G   323_A      A     294          4.212
LGA    L   324_A      A     295          0.935
LGA    X   325_A      V     296          4.735
LGA    D   326_A      R     297          3.859
LGA    A   327_A      S     298          0.998
LGA    -       -      Y     299           -
LGA    V   328_A      W     300          3.476
LGA    P   329_A      P     301          3.246
LGA    A   330_A      A     302          5.119
LGA    L   331_A      L     303          4.977
LGA    A   332_A      P     304          4.994
LGA    G   333_A      D     305          2.304
LGA    E   334_A      G     306          3.576
LGA    G   335_A      A     307          2.339
LGA    L   336_A      L     308          0.810
LGA    E   337_A      A     309          0.538
LGA    L   338_A      P     310          3.716
LGA    G   339_A      -       -           -
LGA    R   340_A      -       -           -
LGA    S   341_A      -       -           -
LGA    S   342_A      -       -           -
LGA    A   343_A      -       -           -
LGA    D   344_A      -       -           -
LGA    V   345_A      G     311          4.548
LGA    P   346_A      Y     312          1.460
LGA    G   347_A      T     313          1.535
LGA    A   348_A      G     314          2.319
LGA    W   349_A      I     315          1.990
LGA    L   350_A      R     316          1.860
LGA    A   351_A      P     317          0.647
LGA    L   352_A      K     318          1.778
LGA    P   353_A      I     319          3.565
LGA    G   354_A      S     320          3.314
LGA    -       -      G     321           -
LGA    -       -      P     322           -
LGA    -       -      H     323           -
LGA    G   355_A      E     324           #
LGA    R   356_A      P     325           #
LGA    P   357_A      -       -           -
LGA    D   358_A      A     326          3.994
LGA    A   359_A      A     327          3.615
LGA    P   360_A      D     328          3.960
LGA    P   361_A      F     329          3.022
LGA    Q   362_A      A     330          2.867
LGA    A   363_A      I     331          0.855
LGA    E   364_A      A     332          0.662
LGA    E   365_A      G     333          3.191
LGA    -       -      P     334           -
LGA    -       -      A     335           -
LGA    -       -      S     336           -
LGA    L   366_A      H     337          4.103
LGA    A   367_A      G     338          5.101
LGA    P   368_A      V     339          0.945
LGA    G   369_A      A     340          3.813
LGA    -       -      G     341           -
LGA    L   370_A      L     342          2.849
LGA    H   371_A      V     343          2.032
LGA    L   372_A      N     344          1.549
LGA    L   373_A      L     345          1.463
LGA    L   374_A      Y     346          3.376
LGA    -       -      G     347           -
LGA    G   375_A      I     348          1.754
LGA    G   376_A      E     349          0.428
LGA    P   377_A      S     350          2.149
LGA    L   378_A      P     351          2.009
LGA    A   379_A      G     352          1.433
LGA    D   380_A      L     353          3.522
LGA    T   381_A      T     354          3.589
LGA    L   382_A      A     355          2.685
LGA    G   383_A      S     356          3.148
LGA    L   384_A      L     357          2.628
LGA    A   385_A      A     358          1.564
LGA    A   386_A      I     359          1.878
LGA    A   387_A      A     360          2.323
LGA    H   388_A      E     361          1.701
LGA    E   389_A      E     362          0.475
LGA    L   390_A      T     363          0.375
LGA    A   391_A      L     364          1.863
LGA    Q   392_A      A     365          2.779
LGA    R   393_A      R     366          2.901
LGA    V   394_A      L     367          2.338
LGA    S   395_A      A     368          5.213
LGA    A   396_A      -       -           -
LGA    S   397_A      -       -           -
LGA    L   398_A      -       -           -
LGA    E   399_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  359  366    5.0    300    2.39    18.67     53.726    12.027

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.169679 * X  +  -0.338759 * Y  +   0.925447 * Z  + -74.051048
  Y_new =  -0.792469 * X  +  -0.605132 * Y  +  -0.076211 * Z  + 119.814522
  Z_new =   0.585835 * X  +  -0.720456 * Y  +  -0.371134 * Z  +  35.970818 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.046481    1.095112  [ DEG:  -117.2547     62.7453 ]
  Theta =  -0.625910   -2.515683  [ DEG:   -35.8620   -144.1380 ]
  Phi   =  -1.359867    1.781725  [ DEG:   -77.9147    102.0853 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3c4n_A                                        
REMARK     2: T0490.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3c4n_A.T0490.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  359  366   5.0  300   2.39   18.67  53.726
REMARK  ---------------------------------------------------------- 
MOLECULE 3c4n_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-JAN-08   3C4N              
TITLE     CRYSTAL STRUCTURE OF DR_0571 PROTEIN FROM DEINOCOCCUS                 
TITLE    2 RADIODURANS IN COMPLEX WITH ADP. NORTHEAST STRUCTURAL                
TITLE    3 GENOMICS CONSORTIUM TARGET DRR125                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN DR_0571;                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DEINOCOCCUS RADIODURANS R1;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: R1 / DSM 20539 / IFO 15346 / LMG 4051 / NCIB 9279;           
SOURCE   5 ATCC: 13939;                                                         
SOURCE   6 GENE: DR_0571;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    ALPHA-BETA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG, STRUCTURAL GENOMICS, UNKNOWN FUNCTION              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,Y.CHEN,J.SEETHARAMAN,L.MAO,R.XIAO,K.CUNNINGHAM,            
AUTHOR   2 L.A.OWEN,M.MAGLAQUI,M.C.BARAN,T.B.ACTON,G.T.MONTELIONE,              
AUTHOR   3 J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL GENOMICS CONSORTIUM             
AUTHOR   4 (NESG)                                                               
REVDAT   1   26-FEB-08 3C4N    0                                                
JRNL        AUTH   F.FOROUHAR,Y.CHEN,J.SEETHARAMAN,L.MAO,R.XIAO,                
JRNL        AUTH 2 K.CUNNINGHAM,L.A.OWEN,M.MAGLAQUI,M.C.BARAN,                  
JRNL        AUTH 3 T.B.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG                     
JRNL        TITL   CRYSTAL STRUCTURE OF DR_0571 PROTEIN FROM                    
JRNL        TITL 2 DEINOCOCCUS RADIODURANS IN COMPLEX WITH ADP.                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3C4N A    1   397  UNP    Q9RWU4   Q9RWU4_DEIRA     1    397             
DBREF  3C4N B    1   397  UNP    Q9RWU4   Q9RWU4_DEIRA     1    397             
SEQRES   1 A  405  MSE THR GLY PRO GLU PRO VAL PRO ALA GLY PRO PRO PRO          
SEQRES   2 A  405  ASP PRO THR PRO PRO ARG ARG ALA GLY SER VAL TRP ALA          
SEQRES   3 A  405  HIS VAL GLY GLN HIS PHE THR GLU GLU ALA PHE ASP ILE          
SEQRES   4 A  405  VAL VAL ILE GLY ALA GLY ARG MSE GLY ALA ALA CYS ALA          
SEQRES   5 A  405  PHE TYR LEU ARG GLN LEU ALA PRO GLY ARG SER LEU LEU          
SEQRES   6 A  405  LEU VAL GLU GLU GLY GLY LEU PRO ASN GLU GLU GLY ALA          
SEQRES   7 A  405  THR ILE LEU ALA PRO GLY VAL TRP THR ALA GLN ASP ILE          
SEQRES   8 A  405  PRO ALA GLY GLN GLU ALA GLN ALA GLU TRP THR ARG GLU          
SEQRES   9 A  405  GLN LEU LEU GLY ALA LEU GLY SER GLY LYS THR LEU GLU          
SEQRES  10 A  405  VAL GLU ASP ARG PRO LEU LEU HIS LEU LEU PRO ALA GLY          
SEQRES  11 A  405  GLU GLY SER GLY LEU THR PRO THR LEU ASP ALA LEU ALA          
SEQRES  12 A  405  ASP PHE PRO GLU ALA LEU ALA LEU LEU ASP PRO ALA ARG          
SEQRES  13 A  405  LEU PRO VAL ALA ARG VAL ASP PRO ARG ALA LEU THR TYR          
SEQRES  14 A  405  ARG PRO GLY SER LEU ALA LEU LEU ALA ALA GLN GLN ALA          
SEQRES  15 A  405  ILE GLY GLN GLY ALA GLY LEU LEU LEU ASN THR ARG ALA          
SEQRES  16 A  405  GLU LEU VAL PRO GLY GLY VAL ARG LEU HIS ARG LEU THR          
SEQRES  17 A  405  VAL THR ASN THR HIS GLN ILE VAL VAL HIS GLU THR ARG          
SEQRES  18 A  405  GLN ILE ARG ALA GLY VAL ILE ILE VAL ALA ALA GLY ALA          
SEQRES  19 A  405  ALA GLY PRO ALA LEU VAL GLU GLN GLY LEU GLY LEU HIS          
SEQRES  20 A  405  THR ARG HIS GLY ARG ALA TYR ARG GLN PHE PRO ARG LEU          
SEQRES  21 A  405  ASP LEU LEU SER GLY ALA GLN THR PRO VAL LEU ARG ALA          
SEQRES  22 A  405  SER GLY LEU THR LEU ARG PRO GLN ASN GLY GLY TYR THR          
SEQRES  23 A  405  LEU VAL PRO ALA ILE HIS HIS ARG ASP PRO HIS GLY TYR          
SEQRES  24 A  405  HIS PRO ALA GLY GLY SER LEU THR GLY VAL PRO THR GLY          
SEQRES  25 A  405  LEU ARG ARG GLU LEU LEU GLU ASP LEU VAL GLY LEU MSE          
SEQRES  26 A  405  ASP ALA VAL PRO ALA LEU ALA GLY GLU GLY LEU GLU LEU          
SEQRES  27 A  405  GLY ARG SER SER ALA ASP VAL PRO GLY ALA TRP LEU ALA          
SEQRES  28 A  405  LEU PRO GLY GLY ARG PRO ASP ALA PRO PRO GLN ALA GLU          
SEQRES  29 A  405  GLU LEU ALA PRO GLY LEU HIS LEU LEU LEU GLY GLY PRO          
SEQRES  30 A  405  LEU ALA ASP THR LEU GLY LEU ALA ALA ALA HIS GLU LEU          
SEQRES  31 A  405  ALA GLN ARG VAL SER ALA SER LEU GLU HIS HIS HIS HIS          
SEQRES  32 A  405  HIS HIS                                                      
SEQRES   1 B  405  MSE THR GLY PRO GLU PRO VAL PRO ALA GLY PRO PRO PRO          
SEQRES   2 B  405  ASP PRO THR PRO PRO ARG ARG ALA GLY SER VAL TRP ALA          
SEQRES   3 B  405  HIS VAL GLY GLN HIS PHE THR GLU GLU ALA PHE ASP ILE          
SEQRES   4 B  405  VAL VAL ILE GLY ALA GLY ARG MSE GLY ALA ALA CYS ALA          
SEQRES   5 B  405  PHE TYR LEU ARG GLN LEU ALA PRO GLY ARG SER LEU LEU          
SEQRES   6 B  405  LEU VAL GLU GLU GLY GLY LEU PRO ASN GLU GLU GLY ALA          
SEQRES   7 B  405  THR ILE LEU ALA PRO GLY VAL TRP THR ALA GLN ASP ILE          
SEQRES   8 B  405  PRO ALA GLY GLN GLU ALA GLN ALA GLU TRP THR ARG GLU          
SEQRES   9 B  405  GLN LEU LEU GLY ALA LEU GLY SER GLY LYS THR LEU GLU          
SEQRES  10 B  405  VAL GLU ASP ARG PRO LEU LEU HIS LEU LEU PRO ALA GLY          
SEQRES  11 B  405  GLU GLY SER GLY LEU THR PRO THR LEU ASP ALA LEU ALA          
SEQRES  12 B  405  ASP PHE PRO GLU ALA LEU ALA LEU LEU ASP PRO ALA ARG          
SEQRES  13 B  405  LEU PRO VAL ALA ARG VAL ASP PRO ARG ALA LEU THR TYR          
SEQRES  14 B  405  ARG PRO GLY SER LEU ALA LEU LEU ALA ALA GLN GLN ALA          
SEQRES  15 B  405  ILE GLY GLN GLY ALA GLY LEU LEU LEU ASN THR ARG ALA          
SEQRES  16 B  405  GLU LEU VAL PRO GLY GLY VAL ARG LEU HIS ARG LEU THR          
SEQRES  17 B  405  VAL THR ASN THR HIS GLN ILE VAL VAL HIS GLU THR ARG          
SEQRES  18 B  405  GLN ILE ARG ALA GLY VAL ILE ILE VAL ALA ALA GLY ALA          
SEQRES  19 B  405  ALA GLY PRO ALA LEU VAL GLU GLN GLY LEU GLY LEU HIS          
SEQRES  20 B  405  THR ARG HIS GLY ARG ALA TYR ARG GLN PHE PRO ARG LEU          
SEQRES  21 B  405  ASP LEU LEU SER GLY ALA GLN THR PRO VAL LEU ARG ALA          
SEQRES  22 B  405  SER GLY LEU THR LEU ARG PRO GLN ASN GLY GLY TYR THR          
SEQRES  23 B  405  LEU VAL PRO ALA ILE HIS HIS ARG ASP PRO HIS GLY TYR          
SEQRES  24 B  405  HIS PRO ALA GLY GLY SER LEU THR GLY VAL PRO THR GLY          
SEQRES  25 B  405  LEU ARG ARG GLU LEU LEU GLU ASP LEU VAL GLY LEU MSE          
SEQRES  26 B  405  ASP ALA VAL PRO ALA LEU ALA GLY GLU GLY LEU GLU LEU          
SEQRES  27 B  405  GLY ARG SER SER ALA ASP VAL PRO GLY ALA TRP LEU ALA          
SEQRES  28 B  405  LEU PRO GLY GLY ARG PRO ASP ALA PRO PRO GLN ALA GLU          
SEQRES  29 B  405  GLU LEU ALA PRO GLY LEU HIS LEU LEU LEU GLY GLY PRO          
SEQRES  30 B  405  LEU ALA ASP THR LEU GLY LEU ALA ALA ALA HIS GLU LEU          
SEQRES  31 B  405  ALA GLN ARG VAL SER ALA SER LEU GLU HIS HIS HIS HIS          
SEQRES  32 B  405  HIS HIS                                                      
HET    MSE  A  47       8                                                       
HET    MSE  A 325       8                                                       
HET    MSE  B  47       8                                                       
HET    MSE  B 325       8                                                       
HET    ADP  A 411      27                                                       
HET    ADP  B 411      27                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ADP ADENOSINE-5'-DIPHOSPHATE                                         
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3  ADP    2(C10 H15 N5 O10 P2)                                         
FORMUL   5  HOH   *372(H2 O)                                                    
CRYST1   83.627   67.829   83.645  90.00  91.14  90.00 P 1 21 1      4          
ATOM      1  N   GLU A  34      30.622  59.230   7.910  1.00 61.64           N  
ATOM      2  CA  GLU A  34      30.173  58.991   6.506  1.00 58.89           C  
ATOM      3  C   GLU A  34      28.735  59.482   6.318  1.00 56.06           C  
ATOM      4  O   GLU A  34      28.409  60.604   6.716  1.00 52.73           O  
ATOM      5  CB  GLU A  34      30.276  57.493   6.186  1.00 60.64           C  
ATOM      6  CG  GLU A  34      31.058  57.156   4.907  1.00 60.77           C  
ATOM      7  CD  GLU A  34      32.437  57.821   4.847  1.00 63.75           C  
ATOM      8  OE1 GLU A  34      32.500  59.035   4.546  1.00 59.52           O  
ATOM      9  OE2 GLU A  34      33.454  57.131   5.106  1.00 52.39           O  
ATOM     10  N   GLU A  35      27.888  58.645   5.710  1.00 54.39           N  
ATOM     11  CA  GLU A  35      26.479  58.986   5.469  1.00 49.96           C  
ATOM     12  C   GLU A  35      25.796  59.220   6.816  1.00 43.54           C  
ATOM     13  O   GLU A  35      26.170  58.617   7.820  1.00 45.15           O  
ATOM     14  CB  GLU A  35      25.782  57.855   4.695  1.00 52.56           C  
ATOM     15  CG  GLU A  35      24.338  58.153   4.273  1.00 58.17           C  
ATOM     16  CD  GLU A  35      23.770  57.118   3.289  1.00 60.25           C  
ATOM     17  OE1 GLU A  35      24.197  57.097   2.106  1.00 54.51           O  
ATOM     18  OE2 GLU A  35      22.899  56.318   3.700  1.00 61.95           O  
ATOM     19  N   ALA A  36      24.799  60.098   6.843  1.00 33.31           N  
ATOM     20  CA  ALA A  36      24.121  60.408   8.094  1.00 29.45           C  
ATOM     21  C   ALA A  36      22.610  60.560   7.958  1.00 30.72           C  
ATOM     22  O   ALA A  36      22.107  60.884   6.885  1.00 35.87           O  
ATOM     23  CB  ALA A  36      24.715  61.677   8.692  1.00 22.67           C  
ATOM     24  N   PHE A  37      21.896  60.325   9.060  1.00 25.91           N  
ATOM     25  CA  PHE A  37      20.437  60.441   9.103  1.00 17.66           C  
ATOM     26  C   PHE A  37      20.024  61.265  10.320  1.00 22.79           C  
ATOM     27  O   PHE A  37      20.739  61.320  11.319  1.00 25.06           O  
ATOM     28  CB  PHE A  37      19.789  59.056   9.190  1.00 17.68           C  
ATOM     29  CG  PHE A  37      20.117  58.171   8.035  1.00 18.29           C  
ATOM     30  CD1 PHE A  37      21.349  57.540   7.958  1.00 17.70           C  
ATOM     31  CD2 PHE A  37      19.219  58.015   6.992  1.00 13.53           C  
ATOM     32  CE1 PHE A  37      21.685  56.766   6.853  1.00 22.49           C  
ATOM     33  CE2 PHE A  37      19.545  57.244   5.883  1.00 21.57           C  
ATOM     34  CZ  PHE A  37      20.781  56.619   5.813  1.00 18.35           C  
ATOM     35  N   ASP A  38      18.877  61.917  10.247  1.00 18.56           N  
ATOM     36  CA  ASP A  38      18.450  62.700  11.387  1.00 21.39           C  
ATOM     37  C   ASP A  38      17.993  61.773  12.504  1.00 20.41           C  
ATOM     38  O   ASP A  38      18.248  62.024  13.683  1.00 25.36           O  
ATOM     39  CB  ASP A  38      17.307  63.644  11.009  1.00 27.09           C  
ATOM     40  CG  ASP A  38      17.741  64.711  10.025  1.00 30.45           C  
ATOM     41  OD1 ASP A  38      18.912  65.158  10.113  1.00 37.05           O  
ATOM     42  OD2 ASP A  38      16.918  65.111   9.174  1.00 33.46           O  
ATOM     43  N   ILE A  39      17.340  60.685  12.119  1.00 16.51           N  
ATOM     44  CA  ILE A  39      16.810  59.743  13.079  1.00 12.66           C  
ATOM     45  C   ILE A  39      17.083  58.303  12.705  1.00 15.18           C  
ATOM     46  O   ILE A  39      16.852  57.903  11.574  1.00 18.68           O  
ATOM     47  CB  ILE A  39      15.295  59.894  13.184  1.00 17.51           C  
ATOM     48  CG1 ILE A  39      14.926  61.319  13.582  1.00 19.19           C  
ATOM     49  CG2 ILE A  39      14.750  58.914  14.194  1.00 14.67           C  
ATOM     50  CD1 ILE A  39      13.447  61.598  13.414  1.00 16.94           C  
ATOM     51  N   VAL A  40      17.577  57.514  13.652  1.00 17.75           N  
ATOM     52  CA  VAL A  40      17.812  56.104  13.369  1.00 18.63           C  
ATOM     53  C   VAL A  40      17.019  55.262  14.376  1.00 14.61           C  
ATOM     54  O   VAL A  40      17.158  55.416  15.588  1.00 17.07           O  
ATOM     55  CB  VAL A  40      19.335  55.758  13.413  1.00 19.22           C  
ATOM     56  CG1 VAL A  40      19.546  54.255  13.323  1.00 17.66           C  
ATOM     57  CG2 VAL A  40      20.044  56.425  12.253  1.00 15.05           C  
ATOM     58  N   VAL A  41      16.156  54.395  13.868  1.00  7.99           N  
ATOM     59  CA  VAL A  41      15.367  53.533  14.732  1.00  6.15           C  
ATOM     60  C   VAL A  41      15.893  52.100  14.615  1.00 12.09           C  
ATOM     61  O   VAL A  41      15.917  51.518  13.522  1.00  7.34           O  
ATOM     62  CB  VAL A  41      13.855  53.558  14.351  1.00  8.58           C  
ATOM     63  CG1 VAL A  41      13.059  52.603  15.240  1.00  1.53           C  
ATOM     64  CG2 VAL A  41      13.299  54.965  14.483  1.00  9.09           C  
ATOM     65  N   ILE A  42      16.323  51.546  15.751  1.00 15.01           N  
ATOM     66  CA  ILE A  42      16.855  50.182  15.819  1.00 17.45           C  
ATOM     67  C   ILE A  42      15.753  49.263  16.321  1.00 13.71           C  
ATOM     68  O   ILE A  42      15.278  49.410  17.445  1.00 13.49           O  
ATOM     69  CB  ILE A  42      18.059  50.093  16.791  1.00 20.67           C  
ATOM     70  CG1 ILE A  42      19.123  51.123  16.375  1.00 20.87           C  
ATOM     71  CG2 ILE A  42      18.624  48.653  16.803  1.00 16.43           C  
ATOM     72  CD1 ILE A  42      20.267  51.270  17.354  1.00 18.11           C  
ATOM     73  N   GLY A  43      15.343  48.321  15.479  1.00 12.91           N  
ATOM     74  CA  GLY A  43      14.291  47.390  15.856  1.00 14.40           C  
ATOM     75  C   GLY A  43      12.998  47.617  15.092  1.00 18.77           C  
ATOM     76  O   GLY A  43      12.370  48.678  15.208  1.00 18.42           O  
ATOM     77  N   ALA A  44      12.583  46.630  14.306  1.00 12.22           N  
ATOM     78  CA  ALA A  44      11.358  46.790  13.548  1.00 11.87           C  
ATOM     79  C   ALA A  44      10.191  45.958  14.071  1.00 10.78           C  
ATOM     80  O   ALA A  44       9.330  45.544  13.302  1.00 16.01           O  
ATOM     81  CB  ALA A  44      11.608  46.491  12.058  1.00  3.43           C  
ATOM     82  N   GLY A  45      10.158  45.716  15.378  1.00 14.52           N  
ATOM     83  CA  GLY A  45       9.054  44.965  15.966  1.00 15.26           C  
ATOM     84  C   GLY A  45       7.892  45.923  16.184  1.00 13.50           C  
ATOM     85  O   GLY A  45       7.929  47.020  15.640  1.00 16.35           O  
ATOM     86  N   ARG A  46       6.882  45.542  16.965  1.00  5.29           N  
ATOM     87  CA  ARG A  46       5.733  46.422  17.199  1.00 12.50           C  
ATOM     88  C   ARG A  46       6.116  47.834  17.662  1.00  9.71           C  
ATOM     89  O   ARG A  46       5.581  48.819  17.173  1.00 15.89           O  
ATOM     90  CB  ARG A  46       4.772  45.800  18.229  1.00 12.58           C  
ATOM     91  CG  ARG A  46       5.281  45.855  19.664  1.00 14.77           C  
ATOM     92  CD  ARG A  46       4.452  45.012  20.626  1.00 26.87           C  
ATOM     93  NE  ARG A  46       3.017  45.277  20.529  1.00 23.00           N  
ATOM     94  CZ  ARG A  46       2.090  44.479  21.045  1.00 21.83           C  
ATOM     95  NH1 ARG A  46       0.804  44.766  20.913  1.00 16.68           N  
ATOM     96  NH2 ARG A  46       2.455  43.385  21.693  1.00 27.93           N  
HETATM   97  N   MSE A  47       7.041  47.925  18.606  1.00 10.02           N  
HETATM   98  CA  MSE A  47       7.486  49.202  19.138  1.00  5.93           C  
HETATM   99  C   MSE A  47       8.246  50.080  18.149  1.00 14.11           C  
HETATM  100  O   MSE A  47       7.826  51.200  17.866  1.00 17.86           O  
HETATM  101  CB  MSE A  47       8.336  48.957  20.385  1.00 12.14           C  
HETATM  102  CG  MSE A  47       7.527  48.300  21.562  1.00 10.42           C  
HETATM  103 SE   MSE A  47       5.807  49.176  22.075  1.00 23.49          SE  
HETATM  104  CE  MSE A  47       6.464  50.952  22.529  1.00 13.44           C  
ATOM    105  N   GLY A  48       9.370  49.582  17.638  1.00 14.21           N  
ATOM    106  CA  GLY A  48      10.158  50.349  16.682  1.00 12.14           C  
ATOM    107  C   GLY A  48       9.398  50.686  15.403  1.00 12.58           C  
ATOM    108  O   GLY A  48       9.460  51.792  14.865  1.00 17.21           O  
ATOM    109  N   ALA A  49       8.663  49.714  14.904  1.00 12.21           N  
ATOM    110  CA  ALA A  49       7.889  49.925  13.699  1.00 12.83           C  
ATOM    111  C   ALA A  49       6.839  51.009  13.926  1.00  9.17           C  
ATOM    112  O   ALA A  49       6.620  51.844  13.057  1.00  7.10           O  
ATOM    113  CB  ALA A  49       7.215  48.623  13.271  1.00 10.88           C  
ATOM    114  N   ALA A  50       6.180  50.999  15.080  1.00  6.74           N  
ATOM    115  CA  ALA A  50       5.154  52.011  15.348  1.00  8.35           C  
ATOM    116  C   ALA A  50       5.773  53.392  15.504  1.00 12.99           C  
ATOM    117  O   ALA A  50       5.253  54.381  14.984  1.00 11.91           O  
ATOM    118  CB  ALA A  50       4.373  51.659  16.602  1.00  7.11           C  
ATOM    119  N   CYS A  51       6.892  53.443  16.222  1.00 14.53           N  
ATOM    120  CA  CYS A  51       7.597  54.693  16.458  1.00 11.86           C  
ATOM    121  C   CYS A  51       8.079  55.283  15.135  1.00  9.88           C  
ATOM    122  O   CYS A  51       7.953  56.487  14.915  1.00 11.16           O  
ATOM    123  CB  CYS A  51       8.774  54.457  17.407  1.00 18.64           C  
ATOM    124  SG  CYS A  51       9.434  55.960  18.149  1.00 17.25           S  
ATOM    125  N   ALA A  52       8.616  54.440  14.250  1.00 11.13           N  
ATOM    126  CA  ALA A  52       9.101  54.918  12.948  1.00 12.40           C  
ATOM    127  C   ALA A  52       7.935  55.460  12.131  1.00 13.32           C  
ATOM    128  O   ALA A  52       8.079  56.443  11.404  1.00 16.12           O  
ATOM    129  CB  ALA A  52       9.804  53.800  12.185  1.00  8.60           C  
ATOM    130  N   PHE A  53       6.777  54.822  12.263  1.00 17.11           N  
ATOM    131  CA  PHE A  53       5.595  55.276  11.550  1.00 16.94           C  
ATOM    132  C   PHE A  53       5.168  56.666  12.053  1.00 19.44           C  
ATOM    133  O   PHE A  53       5.008  57.594  11.258  1.00 19.19           O  
ATOM    134  CB  PHE A  53       4.456  54.277  11.730  1.00  9.09           C  
ATOM    135  CG  PHE A  53       3.142  54.775  11.233  1.00  9.68           C  
ATOM    136  CD1 PHE A  53       2.946  55.029   9.885  1.00 20.62           C  
ATOM    137  CD2 PHE A  53       2.098  55.001  12.118  1.00 15.92           C  
ATOM    138  CE1 PHE A  53       1.715  55.507   9.416  1.00 17.67           C  
ATOM    139  CE2 PHE A  53       0.866  55.478  11.669  1.00 17.55           C  
ATOM    140  CZ  PHE A  53       0.673  55.730  10.314  1.00 16.31           C  
ATOM    141  N   TYR A  54       5.017  56.816  13.368  1.00 12.15           N  
ATOM    142  CA  TYR A  54       4.595  58.092  13.929  1.00 15.05           C  
ATOM    143  C   TYR A  54       5.601  59.206  13.645  1.00 19.33           C  
ATOM    144  O   TYR A  54       5.215  60.358  13.459  1.00 19.52           O  
ATOM    145  CB  TYR A  54       4.360  57.982  15.438  1.00 11.67           C  
ATOM    146  CG  TYR A  54       3.212  57.080  15.814  1.00 13.46           C  
ATOM    147  CD1 TYR A  54       1.939  57.275  15.273  1.00 15.50           C  
ATOM    148  CD2 TYR A  54       3.397  56.032  16.708  1.00  9.77           C  
ATOM    149  CE1 TYR A  54       0.875  56.438  15.617  1.00 22.75           C  
ATOM    150  CE2 TYR A  54       2.350  55.192  17.060  1.00 14.75           C  
ATOM    151  CZ  TYR A  54       1.091  55.391  16.519  1.00 23.04           C  
ATOM    152  OH  TYR A  54       0.060  54.540  16.876  1.00 19.89           O  
ATOM    153  N   LEU A  55       6.887  58.870  13.607  1.00 10.41           N  
ATOM    154  CA  LEU A  55       7.889  59.877  13.312  1.00 12.68           C  
ATOM    155  C   LEU A  55       7.801  60.323  11.855  1.00 11.94           C  
ATOM    156  O   LEU A  55       8.063  61.488  11.548  1.00 16.27           O  
ATOM    157  CB  LEU A  55       9.294  59.360  13.620  1.00 11.29           C  
ATOM    158  CG  LEU A  55       9.642  59.392  15.108  1.00 13.65           C  
ATOM    159  CD1 LEU A  55      10.927  58.599  15.347  1.00  7.72           C  
ATOM    160  CD2 LEU A  55       9.800  60.850  15.564  1.00  6.94           C  
ATOM    161  N   ARG A  56       7.423  59.415  10.960  1.00  9.38           N  
ATOM    162  CA  ARG A  56       7.307  59.774   9.545  1.00 14.87           C  
ATOM    163  C   ARG A  56       6.157  60.743   9.331  1.00 19.89           C  
ATOM    164  O   ARG A  56       6.180  61.544   8.397  1.00 25.47           O  
ATOM    165  CB  ARG A  56       7.089  58.540   8.656  1.00 12.25           C  
ATOM    166  CG  ARG A  56       8.274  57.575   8.582  1.00 20.87           C  
ATOM    167  CD  ARG A  56       9.557  58.285   8.208  1.00 15.29           C  
ATOM    168  NE  ARG A  56       9.459  58.979   6.929  1.00 14.05           N  
ATOM    169  CZ  ARG A  56      10.349  59.870   6.505  1.00 16.05           C  
ATOM    170  NH1 ARG A  56      11.395  60.177   7.256  1.00 22.16           N  
ATOM    171  NH2 ARG A  56      10.202  60.459   5.331  1.00 17.34           N  
ATOM    172  N   GLN A  57       5.143  60.669  10.186  1.00 21.23           N  
ATOM    173  CA  GLN A  57       4.014  61.573  10.048  1.00 24.36           C  
ATOM    174  C   GLN A  57       4.191  62.853  10.855  1.00 21.48           C  
ATOM    175  O   GLN A  57       3.683  63.908  10.470  1.00 22.47           O  
ATOM    176  CB  GLN A  57       2.718  60.868  10.436  1.00 24.75           C  
ATOM    177  CG  GLN A  57       2.379  59.743   9.492  1.00 38.82           C  
ATOM    178  CD  GLN A  57       0.975  59.235   9.679  1.00 46.00           C  
ATOM    179  OE1 GLN A  57       0.540  58.995  10.807  1.00 43.84           O  
ATOM    180  NE2 GLN A  57       0.253  59.058   8.573  1.00 40.79           N  
ATOM    181  N   LEU A  58       4.921  62.760  11.965  1.00 15.90           N  
ATOM    182  CA  LEU A  58       5.168  63.922  12.813  1.00 16.34           C  
ATOM    183  C   LEU A  58       6.319  64.790  12.279  1.00 19.74           C  
ATOM    184  O   LEU A  58       6.257  66.019  12.348  1.00 24.84           O  
ATOM    185  CB  LEU A  58       5.448  63.474  14.256  1.00 13.85           C  
ATOM    186  CG  LEU A  58       4.205  62.969  15.006  1.00 20.87           C  
ATOM    187  CD1 LEU A  58       4.584  62.133  16.219  1.00  6.54           C  
ATOM    188  CD2 LEU A  58       3.365  64.177  15.418  1.00 20.49           C  
ATOM    189  N   ALA A  59       7.354  64.153  11.734  1.00 21.20           N  
ATOM    190  CA  ALA A  59       8.505  64.870  11.192  1.00 19.41           C  
ATOM    191  C   ALA A  59       8.914  64.325   9.827  1.00 23.33           C  
ATOM    192  O   ALA A  59      10.029  63.833   9.651  1.00 26.64           O  
ATOM    193  CB  ALA A  59       9.673  64.770  12.159  1.00 15.95           C  
ATOM    194  N   PRO A  60       8.028  64.446   8.827  1.00 24.69           N  
ATOM    195  CA  PRO A  60       8.321  63.947   7.482  1.00 20.23           C  
ATOM    196  C   PRO A  60       9.575  64.552   6.858  1.00 16.33           C  
ATOM    197  O   PRO A  60      10.183  63.947   5.974  1.00 24.08           O  
ATOM    198  CB  PRO A  60       7.047  64.287   6.709  1.00 22.76           C  
ATOM    199  CG  PRO A  60       6.629  65.576   7.316  1.00 26.35           C  
ATOM    200  CD  PRO A  60       6.864  65.353   8.808  1.00 30.77           C  
ATOM    201  N   GLY A  61       9.970  65.731   7.331  1.00 18.03           N  
ATOM    202  CA  GLY A  61      11.148  66.390   6.789  1.00 16.30           C  
ATOM    203  C   GLY A  61      12.450  65.930   7.411  1.00 29.28           C  
ATOM    204  O   GLY A  61      13.529  66.391   7.036  1.00 31.07           O  
ATOM    205  N   ARG A  62      12.347  65.017   8.370  1.00 28.74           N  
ATOM    206  CA  ARG A  62      13.523  64.490   9.053  1.00 25.50           C  
ATOM    207  C   ARG A  62      13.799  63.059   8.607  1.00 23.10           C  
ATOM    208  O   ARG A  62      13.037  62.147   8.919  1.00 25.53           O  
ATOM    209  CB  ARG A  62      13.307  64.558  10.569  1.00 30.25           C  
ATOM    210  CG  ARG A  62      13.239  65.985  11.086  1.00 27.86           C  
ATOM    211  CD  ARG A  62      14.587  66.660  10.888  1.00 37.38           C  
ATOM    212  NE  ARG A  62      14.482  68.070  10.516  1.00 46.82           N  
ATOM    213  CZ  ARG A  62      13.893  69.004  11.254  1.00 48.85           C  
ATOM    214  NH1 ARG A  62      13.855  70.261  10.828  1.00 52.36           N  
ATOM    215  NH2 ARG A  62      13.335  68.686  12.414  1.00 54.27           N  
ATOM    216  N   SER A  63      14.878  62.873   7.854  1.00 18.33           N  
ATOM    217  CA  SER A  63      15.244  61.553   7.362  1.00 16.86           C  
ATOM    218  C   SER A  63      15.317  60.567   8.527  1.00 21.93           C  
ATOM    219  O   SER A  63      15.784  60.918   9.622  1.00 21.92           O  
ATOM    220  CB  SER A  63      16.592  61.614   6.624  1.00 12.58           C  
ATOM    221  OG  SER A  63      17.628  62.126   7.445  1.00 17.75           O  
ATOM    222  N   LEU A  64      14.842  59.346   8.288  1.00 15.59           N  
ATOM    223  CA  LEU A  64      14.833  58.290   9.300  1.00 18.05           C  
ATOM    224  C   LEU A  64      15.243  56.961   8.690  1.00 13.91           C  
ATOM    225  O   LEU A  64      14.785  56.621   7.609  1.00 23.49           O  
ATOM    226  CB  LEU A  64      13.435  58.160   9.918  1.00 13.68           C  
ATOM    227  CG  LEU A  64      13.190  56.977  10.864  1.00 17.75           C  
ATOM    228  CD1 LEU A  64      12.120  57.368  11.887  1.00 15.63           C  
ATOM    229  CD2 LEU A  64      12.761  55.736  10.073  1.00  7.10           C  
ATOM    230  N   LEU A  65      16.109  56.221   9.376  1.00 14.25           N  
ATOM    231  CA  LEU A  65      16.575  54.916   8.889  1.00 16.82           C  
ATOM    232  C   LEU A  65      16.105  53.824   9.861  1.00 13.56           C  
ATOM    233  O   LEU A  65      16.374  53.899  11.054  1.00 18.24           O  
ATOM    234  CB  LEU A  65      18.111  54.898   8.818  1.00 21.59           C  
ATOM    235  CG  LEU A  65      18.872  53.949   7.873  1.00 23.65           C  
ATOM    236  CD1 LEU A  65      20.165  53.515   8.559  1.00 25.14           C  
ATOM    237  CD2 LEU A  65      18.055  52.734   7.528  1.00 18.44           C  
ATOM    238  N   LEU A  66      15.407  52.817   9.353  1.00 15.05           N  
ATOM    239  CA  LEU A  66      14.923  51.724  10.190  1.00 18.36           C  
ATOM    240  C   LEU A  66      15.870  50.528  10.021  1.00 19.16           C  
ATOM    241  O   LEU A  66      16.085  50.050   8.897  1.00 16.44           O  
ATOM    242  CB  LEU A  66      13.498  51.321   9.769  1.00 19.21           C  
ATOM    243  CG  LEU A  66      12.461  50.958  10.831  1.00 18.52           C  
ATOM    244  CD1 LEU A  66      11.525  49.895  10.284  1.00  8.14           C  
ATOM    245  CD2 LEU A  66      13.146  50.451  12.096  1.00 24.54           C  
ATOM    246  N   VAL A  67      16.438  50.051  11.129  1.00 18.45           N  
ATOM    247  CA  VAL A  67      17.360  48.913  11.076  1.00 22.67           C  
ATOM    248  C   VAL A  67      16.838  47.716  11.851  1.00 20.03           C  
ATOM    249  O   VAL A  67      16.472  47.813  13.023  1.00 18.94           O  
ATOM    250  CB  VAL A  67      18.763  49.270  11.633  1.00 19.14           C  
ATOM    251  CG1 VAL A  67      19.763  48.135  11.327  1.00 11.87           C  
ATOM    252  CG2 VAL A  67      19.233  50.559  11.024  1.00 15.98           C  
ATOM    253  N   GLU A  68      16.822  46.581  11.175  1.00  7.92           N  
ATOM    254  CA  GLU A  68      16.336  45.358  11.755  1.00  4.04           C  
ATOM    255  C   GLU A  68      17.300  44.233  11.400  1.00  8.74           C  
ATOM    256  O   GLU A  68      17.729  44.125  10.253  1.00 14.22           O  
ATOM    257  CB  GLU A  68      14.948  45.105  11.191  1.00  8.35           C  
ATOM    258  CG  GLU A  68      14.500  43.702  11.286  1.00 18.48           C  
ATOM    259  CD  GLU A  68      14.349  43.251  12.703  1.00 20.75           C  
ATOM    260  OE1 GLU A  68      14.604  42.052  12.945  1.00 21.04           O  
ATOM    261  OE2 GLU A  68      13.964  44.079  13.565  1.00 22.25           O  
ATOM    262  N   GLU A  69      17.651  43.398  12.372  1.00 16.51           N  
ATOM    263  CA  GLU A  69      18.584  42.316  12.088  1.00 24.44           C  
ATOM    264  C   GLU A  69      17.902  41.104  11.491  1.00 20.61           C  
ATOM    265  O   GLU A  69      18.550  40.255  10.878  1.00 23.78           O  
ATOM    266  CB  GLU A  69      19.354  41.912  13.344  1.00 32.26           C  
ATOM    267  CG  GLU A  69      18.509  41.407  14.495  1.00 34.32           C  
ATOM    268  CD  GLU A  69      19.355  41.082  15.718  1.00 42.72           C  
ATOM    269  OE1 GLU A  69      18.770  40.637  16.741  1.00 35.39           O  
ATOM    270  OE2 GLU A  69      20.600  41.276  15.644  1.00 28.98           O  
ATOM    271  N   GLY A  70      16.594  41.020  11.676  1.00 21.12           N  
ATOM    272  CA  GLY A  70      15.853  39.912  11.112  1.00 13.56           C  
ATOM    273  C   GLY A  70      15.183  40.403   9.844  1.00 20.88           C  
ATOM    274  O   GLY A  70      15.656  41.343   9.197  1.00 20.90           O  
ATOM    275  N   GLY A  71      14.076  39.769   9.482  1.00 21.89           N  
ATOM    276  CA  GLY A  71      13.361  40.177   8.295  1.00 23.44           C  
ATOM    277  C   GLY A  71      12.096  40.924   8.659  1.00 28.64           C  
ATOM    278  O   GLY A  71      11.825  41.183   9.833  1.00 33.14           O  
ATOM    279  N   LEU A  72      11.307  41.262   7.647  1.00 31.14           N  
ATOM    280  CA  LEU A  72      10.068  41.987   7.860  1.00 31.29           C  
ATOM    281  C   LEU A  72       8.880  41.243   7.253  1.00 30.17           C  
ATOM    282  O   LEU A  72       8.716  41.210   6.040  1.00 32.95           O  
ATOM    283  CB  LEU A  72      10.172  43.366   7.228  1.00 30.03           C  
ATOM    284  CG  LEU A  72       8.998  44.289   7.516  1.00 24.05           C  
ATOM    285  CD1 LEU A  72       9.066  44.753   8.969  1.00 25.63           C  
ATOM    286  CD2 LEU A  72       9.053  45.468   6.577  1.00 20.05           C  
ATOM    287  N   PRO A  73       8.028  40.644   8.095  1.00 32.11           N  
ATOM    288  CA  PRO A  73       8.100  40.617   9.563  1.00 28.79           C  
ATOM    289  C   PRO A  73       9.256  39.759  10.062  1.00 26.29           C  
ATOM    290  O   PRO A  73      10.013  39.191   9.275  1.00 23.77           O  
ATOM    291  CB  PRO A  73       6.757  40.010   9.968  1.00 28.70           C  
ATOM    292  CG  PRO A  73       5.856  40.342   8.812  1.00 34.88           C  
ATOM    293  CD  PRO A  73       6.747  40.087   7.628  1.00 31.00           C  
ATOM    294  N   ASN A  74       9.386  39.663  11.378  1.00 27.76           N  
ATOM    295  CA  ASN A  74      10.424  38.835  11.979  1.00 29.26           C  
ATOM    296  C   ASN A  74       9.741  37.829  12.900  1.00 30.95           C  
ATOM    297  O   ASN A  74       9.322  38.185  13.999  1.00 27.79           O  
ATOM    298  CB  ASN A  74      11.408  39.703  12.767  1.00 33.16           C  
ATOM    299  CG  ASN A  74      12.470  38.881  13.469  1.00 39.26           C  
ATOM    300  OD1 ASN A  74      12.840  37.798  13.005  1.00 35.72           O  
ATOM    301  ND2 ASN A  74      12.975  39.394  14.586  1.00 30.61           N  
ATOM    302  N   GLU A  75       9.613  36.576  12.458  1.00 37.39           N  
ATOM    303  CA  GLU A  75       8.944  35.574  13.294  1.00 39.43           C  
ATOM    304  C   GLU A  75       9.842  35.040  14.398  1.00 30.07           C  
ATOM    305  O   GLU A  75       9.506  34.065  15.058  1.00 28.05           O  
ATOM    306  CB  GLU A  75       8.400  34.412  12.452  1.00 49.53           C  
ATOM    307  CG  GLU A  75       9.367  33.273  12.266  1.00 61.65           C  
ATOM    308  CD  GLU A  75      10.485  33.627  11.329  1.00 65.19           C  
ATOM    309  OE1 GLU A  75      10.346  33.339  10.122  1.00 75.74           O  
ATOM    310  OE2 GLU A  75      11.496  34.201  11.794  1.00 70.21           O  
ATOM    311  N   GLU A  76      10.981  35.693  14.590  1.00 33.05           N  
ATOM    312  CA  GLU A  76      11.921  35.321  15.628  1.00 33.86           C  
ATOM    313  C   GLU A  76      11.836  36.362  16.744  1.00 35.81           C  
ATOM    314  O   GLU A  76      12.653  36.372  17.667  1.00 37.24           O  
ATOM    315  CB  GLU A  76      13.336  35.259  15.048  1.00 39.93           C  
ATOM    316  CG  GLU A  76      13.576  34.058  14.122  1.00 48.77           C  
ATOM    317  CD  GLU A  76      14.703  34.282  13.109  1.00 58.63           C  
ATOM    318  OE1 GLU A  76      15.782  34.791  13.500  1.00 62.60           O  
ATOM    319  OE2 GLU A  76      14.508  33.938  11.918  1.00 54.30           O  
ATOM    320  N   GLY A  77      10.829  37.228  16.663  1.00 32.87           N  
ATOM    321  CA  GLY A  77      10.663  38.265  17.673  1.00 32.82           C  
ATOM    322  C   GLY A  77       9.501  38.042  18.628  1.00 28.74           C  
ATOM    323  O   GLY A  77       8.738  37.087  18.472  1.00 25.07           O  
ATOM    324  N   ALA A  78       9.367  38.930  19.613  1.00 19.26           N  
ATOM    325  CA  ALA A  78       8.290  38.840  20.601  1.00 18.91           C  
ATOM    326  C   ALA A  78       6.949  39.285  20.021  1.00 18.68           C  
ATOM    327  O   ALA A  78       5.909  38.688  20.291  1.00 21.73           O  
ATOM    328  CB  ALA A  78       8.621  39.683  21.818  1.00 15.78           C  
ATOM    329  N   THR A  79       6.986  40.339  19.219  1.00 17.30           N  
ATOM    330  CA  THR A  79       5.786  40.881  18.605  1.00 16.78           C  
ATOM    331  C   THR A  79       4.919  39.841  17.894  1.00 20.35           C  
ATOM    332  O   THR A  79       3.694  39.880  17.982  1.00 22.31           O  
ATOM    333  CB  THR A  79       6.149  41.980  17.600  1.00 13.67           C  
ATOM    334  OG1 THR A  79       6.684  43.105  18.301  1.00 18.01           O  
ATOM    335  CG2 THR A  79       4.932  42.404  16.815  1.00 17.86           C  
ATOM    336  N   ILE A  80       5.559  38.915  17.197  1.00 14.42           N  
ATOM    337  CA  ILE A  80       4.856  37.890  16.453  1.00 16.08           C  
ATOM    338  C   ILE A  80       4.068  36.915  17.335  1.00 17.70           C  
ATOM    339  O   ILE A  80       2.975  36.494  16.958  1.00 24.69           O  
ATOM    340  CB  ILE A  80       5.861  37.113  15.561  1.00 26.02           C  
ATOM    341  CG1 ILE A  80       5.126  36.114  14.669  1.00 32.26           C  
ATOM    342  CG2 ILE A  80       6.891  36.403  16.436  1.00 33.81           C  
ATOM    343  CD1 ILE A  80       4.204  36.761  13.655  1.00 42.28           C  
ATOM    344  N   LEU A  81       4.601  36.566  18.506  1.00 15.58           N  
ATOM    345  CA  LEU A  81       3.926  35.629  19.423  1.00 12.46           C  
ATOM    346  C   LEU A  81       2.996  36.302  20.436  1.00 17.41           C  
ATOM    347  O   LEU A  81       2.210  35.632  21.107  1.00 17.13           O  
ATOM    348  CB  LEU A  81       4.960  34.799  20.202  1.00 14.51           C  
ATOM    349  CG  LEU A  81       5.973  33.934  19.416  1.00 19.08           C  
ATOM    350  CD1 LEU A  81       6.917  33.190  20.380  1.00 17.97           C  
ATOM    351  CD2 LEU A  81       5.224  32.953  18.547  1.00 15.52           C  
ATOM    352  N   ALA A  82       3.094  37.619  20.566  1.00 15.68           N  
ATOM    353  CA  ALA A  82       2.247  38.333  21.512  1.00 19.67           C  
ATOM    354  C   ALA A  82       0.780  38.002  21.216  1.00 16.95           C  
ATOM    355  O   ALA A  82       0.372  37.972  20.061  1.00 24.10           O  
ATOM    356  CB  ALA A  82       2.492  39.848  21.397  1.00 18.14           C  
ATOM    357  N   PRO A  83      -0.026  37.741  22.254  1.00 15.79           N  
ATOM    358  CA  PRO A  83      -1.432  37.418  22.021  1.00 12.07           C  
ATOM    359  C   PRO A  83      -2.289  38.555  21.488  1.00 15.07           C  
ATOM    360  O   PRO A  83      -3.388  38.320  20.993  1.00 18.03           O  
ATOM    361  CB  PRO A  83      -1.900  36.902  23.380  1.00  7.43           C  
ATOM    362  CG  PRO A  83      -1.014  37.598  24.339  1.00  6.30           C  
ATOM    363  CD  PRO A  83       0.330  37.517  23.665  1.00 15.93           C  
ATOM    364  N   GLY A  84      -1.797  39.785  21.574  1.00 19.83           N  
ATOM    365  CA  GLY A  84      -2.580  40.919  21.090  1.00 17.65           C  
ATOM    366  C   GLY A  84      -3.931  41.091  21.783  1.00 19.41           C  
ATOM    367  O   GLY A  84      -4.979  41.154  21.136  1.00 20.05           O  
ATOM    368  N   VAL A  85      -3.913  41.170  23.109  1.00 16.30           N  
ATOM    369  CA  VAL A  85      -5.144  41.348  23.865  1.00 15.15           C  
ATOM    370  C   VAL A  85      -5.230  42.735  24.491  1.00 11.13           C  
ATOM    371  O   VAL A  85      -4.415  43.086  25.337  1.00 12.51           O  
ATOM    372  CB  VAL A  85      -5.262  40.344  25.024  1.00  9.63           C  
ATOM    373  CG1 VAL A  85      -6.556  40.585  25.778  1.00  9.79           C  
ATOM    374  CG2 VAL A  85      -5.215  38.926  24.495  1.00 17.32           C  
ATOM    375  N   TRP A  86      -6.204  43.531  24.070  1.00 15.61           N  
ATOM    376  CA  TRP A  86      -6.370  44.845  24.661  1.00 10.39           C  
ATOM    377  C   TRP A  86      -7.465  44.681  25.698  1.00 16.71           C  
ATOM    378  O   TRP A  86      -8.604  44.329  25.367  1.00 12.54           O  
ATOM    379  CB  TRP A  86      -6.820  45.878  23.639  1.00  7.14           C  
ATOM    380  CG  TRP A  86      -6.772  47.283  24.179  1.00  7.31           C  
ATOM    381  CD1 TRP A  86      -5.788  48.202  23.975  1.00 13.97           C  
ATOM    382  CD2 TRP A  86      -7.737  47.919  25.037  1.00  4.48           C  
ATOM    383  NE1 TRP A  86      -6.076  49.368  24.648  1.00 12.26           N  
ATOM    384  CE2 TRP A  86      -7.267  49.218  25.308  1.00  6.53           C  
ATOM    385  CE3 TRP A  86      -8.949  47.514  25.603  1.00 12.32           C  
ATOM    386  CZ2 TRP A  86      -7.972  50.120  26.120  1.00 14.48           C  
ATOM    387  CZ3 TRP A  86      -9.652  48.413  26.415  1.00 16.96           C  
ATOM    388  CH2 TRP A  86      -9.158  49.698  26.664  1.00 11.94           C  
ATOM    389  N   THR A  87      -7.126  44.927  26.957  1.00 12.53           N  
ATOM    390  CA  THR A  87      -8.114  44.799  28.022  1.00 17.65           C  
ATOM    391  C   THR A  87      -7.957  45.862  29.088  1.00 16.61           C  
ATOM    392  O   THR A  87      -6.842  46.156  29.512  1.00 19.94           O  
ATOM    393  CB  THR A  87      -8.034  43.423  28.709  1.00 12.66           C  
ATOM    394  OG1 THR A  87      -8.981  43.386  29.776  1.00 12.12           O  
ATOM    395  CG2 THR A  87      -6.639  43.170  29.265  1.00  3.69           C  
ATOM    396  N   ALA A  88      -9.076  46.414  29.535  1.00 17.64           N  
ATOM    397  CA  ALA A  88      -9.061  47.444  30.569  1.00 19.68           C  
ATOM    398  C   ALA A  88      -8.457  46.908  31.860  1.00 16.64           C  
ATOM    399  O   ALA A  88      -8.178  47.674  32.782  1.00 19.96           O  
ATOM    400  CB  ALA A  88     -10.480  47.953  30.825  1.00 10.59           C  
ATOM    401  N   GLN A  89      -8.242  45.598  31.931  1.00 23.31           N  
ATOM    402  CA  GLN A  89      -7.667  45.011  33.146  1.00 25.29           C  
ATOM    403  C   GLN A  89      -6.148  45.058  33.118  1.00 20.52           C  
ATOM    404  O   GLN A  89      -5.487  44.706  34.093  1.00 22.10           O  
ATOM    405  CB  GLN A  89      -8.153  43.565  33.331  1.00 30.58           C  
ATOM    406  CG  GLN A  89      -9.651  43.466  33.615  1.00 25.46           C  
ATOM    407  CD  GLN A  89     -10.157  42.040  33.678  1.00 33.95           C  
ATOM    408  OE1 GLN A  89     -11.363  41.802  33.808  1.00 32.29           O  
ATOM    409  NE2 GLN A  89      -9.241  41.079  33.588  1.00 35.15           N  
ATOM    410  N   ASP A  90      -5.588  45.490  31.996  1.00 17.63           N  
ATOM    411  CA  ASP A  90      -4.147  45.582  31.904  1.00 20.31           C  
ATOM    412  C   ASP A  90      -3.701  47.029  31.965  1.00 20.00           C  
ATOM    413  O   ASP A  90      -2.586  47.358  31.568  1.00 21.64           O  
ATOM    414  CB  ASP A  90      -3.644  44.941  30.616  1.00 23.03           C  
ATOM    415  CG  ASP A  90      -3.621  43.430  30.688  1.00 27.97           C  
ATOM    416  OD1 ASP A  90      -3.904  42.870  31.777  1.00 18.20           O  
ATOM    417  OD2 ASP A  90      -3.305  42.803  29.650  1.00 29.20           O  
ATOM    418  N   ILE A  91      -4.576  47.891  32.471  1.00 17.43           N  
ATOM    419  CA  ILE A  91      -4.262  49.305  32.594  1.00 16.44           C  
ATOM    420  C   ILE A  91      -3.840  49.628  34.025  1.00 19.67           C  
ATOM    421  O   ILE A  91      -4.646  49.554  34.947  1.00 17.11           O  
ATOM    422  CB  ILE A  91      -5.482  50.188  32.264  1.00 18.84           C  
ATOM    423  CG1 ILE A  91      -6.018  49.864  30.864  1.00 19.62           C  
ATOM    424  CG2 ILE A  91      -5.089  51.667  32.370  1.00 13.91           C  
ATOM    425  CD1 ILE A  91      -7.338  50.553  30.531  1.00  6.85           C  
ATOM    426  N   PRO A  92      -2.561  49.966  34.233  1.00 19.79           N  
ATOM    427  CA  PRO A  92      -2.112  50.299  35.586  1.00 22.84           C  
ATOM    428  C   PRO A  92      -2.777  51.633  35.922  1.00 24.96           C  
ATOM    429  O   PRO A  92      -3.270  52.314  35.021  1.00 26.84           O  
ATOM    430  CB  PRO A  92      -0.600  50.450  35.429  1.00 21.85           C  
ATOM    431  CG  PRO A  92      -0.276  49.505  34.318  1.00 16.09           C  
ATOM    432  CD  PRO A  92      -1.409  49.767  33.336  1.00 26.29           C  
ATOM    433  N   ALA A  93      -2.784  52.011  37.199  1.00 20.67           N  
ATOM    434  CA  ALA A  93      -3.398  53.266  37.623  1.00 16.77           C  
ATOM    435  C   ALA A  93      -2.657  54.468  37.058  1.00 15.18           C  
ATOM    436  O   ALA A  93      -1.446  54.593  37.231  1.00 19.36           O  
ATOM    437  CB  ALA A  93      -3.430  53.343  39.139  1.00 14.57           C  
ATOM    438  N   GLY A  94      -3.382  55.350  36.374  1.00 15.76           N  
ATOM    439  CA  GLY A  94      -2.764  56.539  35.811  1.00  5.34           C  
ATOM    440  C   GLY A  94      -2.454  56.413  34.336  1.00 13.61           C  
ATOM    441  O   GLY A  94      -2.080  57.389  33.691  1.00 17.00           O  
ATOM    442  N   GLN A  95      -2.601  55.211  33.793  1.00 13.39           N  
ATOM    443  CA  GLN A  95      -2.316  55.004  32.383  1.00 14.75           C  
ATOM    444  C   GLN A  95      -3.570  54.914  31.489  1.00 13.36           C  
ATOM    445  O   GLN A  95      -3.485  54.443  30.356  1.00 17.34           O  
ATOM    446  CB  GLN A  95      -1.455  53.748  32.230  1.00 20.14           C  
ATOM    447  CG  GLN A  95      -0.139  53.797  33.012  1.00 10.57           C  
ATOM    448  CD  GLN A  95       0.941  54.573  32.285  1.00 21.82           C  
ATOM    449  OE1 GLN A  95       1.313  54.240  31.155  1.00 18.39           O  
ATOM    450  NE2 GLN A  95       1.452  55.615  32.924  1.00 20.57           N  
ATOM    451  N   GLU A  96      -4.714  55.385  31.986  1.00 12.20           N  
ATOM    452  CA  GLU A  96      -5.964  55.358  31.226  1.00 10.44           C  
ATOM    453  C   GLU A  96      -5.875  56.114  29.891  1.00 15.40           C  
ATOM    454  O   GLU A  96      -6.482  55.712  28.903  1.00 15.16           O  
ATOM    455  CB  GLU A  96      -7.123  55.979  32.031  1.00 21.71           C  
ATOM    456  CG  GLU A  96      -7.636  55.237  33.278  1.00 13.52           C  
ATOM    457  CD  GLU A  96      -6.693  55.297  34.477  1.00 26.85           C  
ATOM    458  OE1 GLU A  96      -5.864  56.227  34.566  1.00 22.24           O  
ATOM    459  OE2 GLU A  96      -6.787  54.407  35.354  1.00 40.88           O  
ATOM    460  N   ALA A  97      -5.144  57.222  29.855  1.00 15.90           N  
ATOM    461  CA  ALA A  97      -5.042  57.985  28.611  1.00 19.91           C  
ATOM    462  C   ALA A  97      -4.297  57.181  27.534  1.00 20.94           C  
ATOM    463  O   ALA A  97      -4.730  57.104  26.382  1.00 13.02           O  
ATOM    464  CB  ALA A  97      -4.331  59.321  28.863  1.00 17.56           C  
ATOM    465  N   GLN A  98      -3.172  56.593  27.921  1.00 13.13           N  
ATOM    466  CA  GLN A  98      -2.368  55.790  27.009  1.00 16.91           C  
ATOM    467  C   GLN A  98      -3.144  54.574  26.496  1.00 19.35           C  
ATOM    468  O   GLN A  98      -3.088  54.242  25.309  1.00 17.30           O  
ATOM    469  CB  GLN A  98      -1.082  55.324  27.706  1.00 20.12           C  
ATOM    470  CG  GLN A  98      -0.101  56.454  28.043  1.00 14.12           C  
ATOM    471  CD  GLN A  98      -0.462  57.239  29.298  1.00 22.11           C  
ATOM    472  OE1 GLN A  98      -1.577  57.147  29.819  1.00 14.43           O  
ATOM    473  NE2 GLN A  98       0.489  58.031  29.783  1.00 22.36           N  
ATOM    474  N   ALA A  99      -3.878  53.926  27.396  1.00 12.21           N  
ATOM    475  CA  ALA A  99      -4.653  52.749  27.046  1.00  9.79           C  
ATOM    476  C   ALA A  99      -5.760  53.036  26.043  1.00 13.41           C  
ATOM    477  O   ALA A  99      -5.945  52.287  25.078  1.00 16.37           O  
ATOM    478  CB  ALA A  99      -5.253  52.124  28.301  1.00 11.24           C  
ATOM    479  N   GLU A 100      -6.500  54.114  26.261  1.00 12.71           N  
ATOM    480  CA  GLU A 100      -7.609  54.442  25.364  1.00 14.47           C  
ATOM    481  C   GLU A 100      -7.121  54.929  24.006  1.00  9.40           C  
ATOM    482  O   GLU A 100      -7.707  54.600  22.980  1.00 13.46           O  
ATOM    483  CB  GLU A 100      -8.532  55.495  25.999  1.00 19.52           C  
ATOM    484  CG  GLU A 100      -9.315  55.019  27.246  1.00 21.69           C  
ATOM    485  CD  GLU A 100     -10.018  53.660  27.066  1.00 24.10           C  
ATOM    486  OE1 GLU A 100     -10.438  53.325  25.933  1.00 17.44           O  
ATOM    487  OE2 GLU A 100     -10.162  52.936  28.079  1.00 11.21           O  
ATOM    488  N   TRP A 101      -6.049  55.710  24.010  1.00  9.41           N  
ATOM    489  CA  TRP A 101      -5.483  56.226  22.776  1.00 18.99           C  
ATOM    490  C   TRP A 101      -5.019  55.037  21.934  1.00 20.54           C  
ATOM    491  O   TRP A 101      -5.265  54.973  20.720  1.00 23.86           O  
ATOM    492  CB  TRP A 101      -4.305  57.152  23.089  1.00 21.12           C  
ATOM    493  CG  TRP A 101      -3.766  57.854  21.884  1.00 17.09           C  
ATOM    494  CD1 TRP A 101      -4.195  59.041  21.364  1.00 21.68           C  
ATOM    495  CD2 TRP A 101      -2.755  57.370  20.999  1.00 15.06           C  
ATOM    496  NE1 TRP A 101      -3.515  59.326  20.203  1.00 19.97           N  
ATOM    497  CE2 TRP A 101      -2.624  58.315  19.956  1.00 26.36           C  
ATOM    498  CE3 TRP A 101      -1.948  56.226  20.983  1.00  8.55           C  
ATOM    499  CZ2 TRP A 101      -1.714  58.147  18.903  1.00 26.04           C  
ATOM    500  CZ3 TRP A 101      -1.048  56.059  19.940  1.00 15.79           C  
ATOM    501  CH2 TRP A 101      -0.939  57.017  18.913  1.00 16.68           C  
ATOM    502  N   THR A 102      -4.350  54.087  22.581  1.00 23.18           N  
ATOM    503  CA  THR A 102      -3.878  52.893  21.882  1.00 19.68           C  
ATOM    504  C   THR A 102      -5.080  52.134  21.318  1.00 17.29           C  
ATOM    505  O   THR A 102      -5.039  51.672  20.178  1.00 12.93           O  
ATOM    506  CB  THR A 102      -3.080  51.955  22.828  1.00 21.54           C  
ATOM    507  OG1 THR A 102      -1.884  52.619  23.247  1.00 19.58           O  
ATOM    508  CG2 THR A 102      -2.708  50.648  22.109  1.00 22.51           C  
ATOM    509  N   ARG A 103      -6.155  52.028  22.102  1.00 11.10           N  
ATOM    510  CA  ARG A 103      -7.335  51.306  21.639  1.00 14.10           C  
ATOM    511  C   ARG A 103      -7.910  51.953  20.386  1.00 15.77           C  
ATOM    512  O   ARG A 103      -8.244  51.257  19.424  1.00 11.09           O  
ATOM    513  CB  ARG A 103      -8.428  51.226  22.723  1.00 19.79           C  
ATOM    514  CG  ARG A 103      -9.346  50.013  22.519  1.00 14.65           C  
ATOM    515  CD  ARG A 103     -10.560  49.920  23.448  1.00 15.74           C  
ATOM    516  NE  ARG A 103     -11.740  50.317  22.692  1.00 20.09           N  
ATOM    517  CZ  ARG A 103     -12.878  49.632  22.595  1.00 15.33           C  
ATOM    518  NH1 ARG A 103     -13.057  48.478  23.213  1.00 14.19           N  
ATOM    519  NH2 ARG A 103     -13.843  50.101  21.830  1.00 18.88           N  
ATOM    520  N   GLU A 104      -8.014  53.280  20.404  1.00  9.60           N  
ATOM    521  CA  GLU A 104      -8.542  54.040  19.279  1.00 16.31           C  
ATOM    522  C   GLU A 104      -7.709  53.820  18.019  1.00 17.26           C  
ATOM    523  O   GLU A 104      -8.258  53.655  16.924  1.00 16.59           O  
ATOM    524  CB  GLU A 104      -8.580  55.533  19.618  1.00 18.85           C  
ATOM    525  CG  GLU A 104      -9.448  56.319  18.656  1.00 33.61           C  
ATOM    526  CD  GLU A 104      -9.697  57.767  19.081  1.00 38.79           C  
ATOM    527  OE1 GLU A 104     -10.746  58.322  18.675  1.00 39.04           O  
ATOM    528  OE2 GLU A 104      -8.857  58.354  19.797  1.00 41.05           O  
ATOM    529  N   GLN A 105      -6.385  53.819  18.186  1.00 15.86           N  
ATOM    530  CA  GLN A 105      -5.461  53.599  17.077  1.00 15.71           C  
ATOM    531  C   GLN A 105      -5.747  52.236  16.437  1.00 23.93           C  
ATOM    532  O   GLN A 105      -5.871  52.118  15.213  1.00 29.32           O  
ATOM    533  CB  GLN A 105      -4.007  53.639  17.568  1.00 14.00           C  
ATOM    534  CG  GLN A 105      -3.465  55.009  17.878  1.00 12.51           C  
ATOM    535  CD  GLN A 105      -3.303  55.868  16.645  1.00 21.96           C  
ATOM    536  OE1 GLN A 105      -4.052  56.822  16.452  1.00 24.71           O  
ATOM    537  NE2 GLN A 105      -2.326  55.535  15.795  1.00 14.30           N  
ATOM    538  N   LEU A 106      -5.860  51.214  17.283  1.00 20.77           N  
ATOM    539  CA  LEU A 106      -6.141  49.848  16.851  1.00 17.81           C  
ATOM    540  C   LEU A 106      -7.374  49.771  15.953  1.00 18.23           C  
ATOM    541  O   LEU A 106      -7.287  49.320  14.813  1.00 17.56           O  
ATOM    542  CB  LEU A 106      -6.331  48.950  18.079  1.00  6.75           C  
ATOM    543  CG  LEU A 106      -5.183  48.067  18.602  1.00 15.86           C  
ATOM    544  CD1 LEU A 106      -3.842  48.553  18.162  1.00 11.25           C  
ATOM    545  CD2 LEU A 106      -5.272  47.991  20.106  1.00  7.97           C  
ATOM    546  N   LEU A 107      -8.521  50.213  16.462  1.00 14.67           N  
ATOM    547  CA  LEU A 107      -9.758  50.179  15.681  1.00 16.92           C  
ATOM    548  C   LEU A 107      -9.699  51.069  14.434  1.00 20.04           C  
ATOM    549  O   LEU A 107     -10.407  50.825  13.464  1.00 11.87           O  
ATOM    550  CB  LEU A 107     -10.947  50.595  16.553  1.00  8.30           C  
ATOM    551  CG  LEU A 107     -11.249  49.751  17.796  1.00 12.07           C  
ATOM    552  CD1 LEU A 107     -12.386  50.396  18.562  1.00  7.76           C  
ATOM    553  CD2 LEU A 107     -11.602  48.331  17.406  1.00  9.89           C  
ATOM    554  N   GLY A 108      -8.854  52.099  14.461  1.00 28.92           N  
ATOM    555  CA  GLY A 108      -8.745  52.981  13.313  1.00 24.16           C  
ATOM    556  C   GLY A 108      -7.558  52.629  12.433  1.00 26.91           C  
ATOM    557  O   GLY A 108      -7.215  53.369  11.509  1.00 21.58           O  
ATOM    558  N   ALA A 109      -6.928  51.492  12.726  1.00 25.97           N  
ATOM    559  CA  ALA A 109      -5.765  51.024  11.975  1.00 27.40           C  
ATOM    560  C   ALA A 109      -4.677  52.105  11.842  1.00 20.64           C  
ATOM    561  O   ALA A 109      -4.061  52.241  10.788  1.00 20.09           O  
ATOM    562  CB  ALA A 109      -6.211  50.542  10.589  1.00 23.96           C  
ATOM    563  N   LEU A 110      -4.462  52.872  12.914  1.00 26.47           N  
ATOM    564  CA  LEU A 110      -3.456  53.945  12.949  1.00 28.59           C  
ATOM    565  C   LEU A 110      -3.857  55.113  12.062  1.00 30.50           C  
ATOM    566  O   LEU A 110      -3.053  56.006  11.806  1.00 28.50           O  
ATOM    567  CB  LEU A 110      -2.087  53.418  12.490  1.00 28.02           C  
ATOM    568  CG  LEU A 110      -1.564  52.164  13.202  1.00 25.85           C  
ATOM    569  CD1 LEU A 110      -0.289  51.649  12.543  1.00 14.17           C  
ATOM    570  CD2 LEU A 110      -1.333  52.499  14.654  1.00 21.07           C  
ATOM    571  N   GLY A 111      -5.096  55.090  11.585  1.00 34.64           N  
ATOM    572  CA  GLY A 111      -5.580  56.147  10.716  1.00 41.57           C  
ATOM    573  C   GLY A 111      -4.891  56.154   9.363  1.00 44.15           C  
ATOM    574  O   GLY A 111      -4.659  57.215   8.788  1.00 45.15           O  
ATOM    575  N   SER A 112      -4.578  54.969   8.842  1.00 41.27           N  
ATOM    576  CA  SER A 112      -3.888  54.854   7.559  1.00 35.63           C  
ATOM    577  C   SER A 112      -4.798  54.369   6.441  1.00 35.31           C  
ATOM    578  O   SER A 112      -4.320  53.994   5.372  1.00 39.23           O  
ATOM    579  CB  SER A 112      -2.735  53.868   7.684  1.00 38.90           C  
ATOM    580  OG  SER A 112      -3.256  52.567   7.898  1.00 34.96           O  
ATOM    581  N   GLY A 113      -6.100  54.363   6.691  1.00 28.38           N  
ATOM    582  CA  GLY A 113      -7.028  53.893   5.686  1.00 25.45           C  
ATOM    583  C   GLY A 113      -6.760  52.441   5.332  1.00 26.02           C  
ATOM    584  O   GLY A 113      -7.322  51.918   4.374  1.00 22.88           O  
ATOM    585  N   LYS A 114      -5.900  51.782   6.101  1.00 30.71           N  
ATOM    586  CA  LYS A 114      -5.573  50.385   5.846  1.00 27.71           C  
ATOM    587  C   LYS A 114      -6.446  49.432   6.664  1.00 30.02           C  
ATOM    588  O   LYS A 114      -7.232  49.854   7.520  1.00 28.65           O  
ATOM    589  CB  LYS A 114      -4.091  50.124   6.151  1.00 34.91           C  
ATOM    590  CG  LYS A 114      -3.110  50.748   5.160  1.00 24.90           C  
ATOM    591  CD  LYS A 114      -3.290  50.166   3.766  1.00 35.26           C  
ATOM    592  CE  LYS A 114      -2.205  50.622   2.784  1.00 33.42           C  
ATOM    593  NZ  LYS A 114      -2.380  51.997   2.278  1.00 34.21           N  
ATOM    594  N   THR A 115      -6.290  48.142   6.388  1.00 33.06           N  
ATOM    595  CA  THR A 115      -7.046  47.105   7.067  1.00 33.62           C  
ATOM    596  C   THR A 115      -6.263  46.471   8.216  1.00 36.77           C  
ATOM    597  O   THR A 115      -5.118  46.025   8.046  1.00 33.99           O  
ATOM    598  CB  THR A 115      -7.466  45.994   6.076  1.00 36.45           C  
ATOM    599  OG1 THR A 115      -8.094  44.913   6.783  1.00 37.17           O  
ATOM    600  CG2 THR A 115      -6.252  45.467   5.329  1.00 42.09           C  
ATOM    601  N   LEU A 116      -6.892  46.447   9.389  1.00 34.55           N  
ATOM    602  CA  LEU A 116      -6.296  45.855  10.579  1.00 24.06           C  
ATOM    603  C   LEU A 116      -7.381  45.055  11.291  1.00 18.58           C  
ATOM    604  O   LEU A 116      -8.245  45.629  11.937  1.00 22.06           O  
ATOM    605  CB  LEU A 116      -5.757  46.946  11.507  1.00 27.76           C  
ATOM    606  CG  LEU A 116      -4.508  46.571  12.309  1.00 23.93           C  
ATOM    607  CD1 LEU A 116      -4.595  47.214  13.689  1.00 32.44           C  
ATOM    608  CD2 LEU A 116      -4.396  45.077  12.450  1.00 28.84           C  
ATOM    609  N   GLU A 117      -7.328  43.735  11.143  1.00 23.76           N  
ATOM    610  CA  GLU A 117      -8.296  42.820  11.748  1.00 28.38           C  
ATOM    611  C   GLU A 117      -8.347  42.971  13.261  1.00 29.97           C  
ATOM    612  O   GLU A 117      -7.379  42.648  13.950  1.00 26.40           O  
ATOM    613  CB  GLU A 117      -7.933  41.362  11.433  1.00 34.25           C  
ATOM    614  CG  GLU A 117      -7.928  40.974   9.963  1.00 39.70           C  
ATOM    615  CD  GLU A 117      -9.322  40.840   9.391  1.00 53.14           C  
ATOM    616  OE1 GLU A 117      -9.433  40.587   8.170  1.00 57.04           O  
ATOM    617  OE2 GLU A 117     -10.305  40.987  10.156  1.00 55.71           O  
ATOM    618  N   VAL A 118      -9.477  43.446  13.778  1.00 24.09           N  
ATOM    619  CA  VAL A 118      -9.643  43.618  15.220  1.00 29.11           C  
ATOM    620  C   VAL A 118     -11.072  43.250  15.605  1.00 35.01           C  
ATOM    621  O   VAL A 118     -12.028  43.912  15.180  1.00 43.51           O  
ATOM    622  CB  VAL A 118      -9.391  45.085  15.661  1.00 23.07           C  
ATOM    623  CG1 VAL A 118      -9.538  45.201  17.167  1.00 16.80           C  
ATOM    624  CG2 VAL A 118      -8.025  45.548  15.220  1.00  9.59           C  
ATOM    625  N   GLU A 119     -11.226  42.200  16.405  1.00 29.64           N  
ATOM    626  CA  GLU A 119     -12.558  41.787  16.817  1.00 29.15           C  
ATOM    627  C   GLU A 119     -12.849  42.125  18.273  1.00 25.54           C  
ATOM    628  O   GLU A 119     -11.933  42.288  19.083  1.00 25.42           O  
ATOM    629  CB  GLU A 119     -12.773  40.281  16.557  1.00 34.23           C  
ATOM    630  CG  GLU A 119     -11.723  39.340  17.138  1.00 31.02           C  
ATOM    631  CD  GLU A 119     -10.636  38.918  16.132  1.00 33.72           C  
ATOM    632  OE1 GLU A 119      -9.736  38.145  16.526  1.00 28.88           O  
ATOM    633  OE2 GLU A 119     -10.675  39.343  14.956  1.00 28.59           O  
ATOM    634  N   ASP A 120     -14.133  42.279  18.580  1.00 24.98           N  
ATOM    635  CA  ASP A 120     -14.583  42.582  19.931  1.00 23.73           C  
ATOM    636  C   ASP A 120     -14.684  41.251  20.632  1.00 24.61           C  
ATOM    637  O   ASP A 120     -15.410  40.360  20.196  1.00 29.19           O  
ATOM    638  CB  ASP A 120     -15.946  43.260  19.902  1.00 21.52           C  
ATOM    639  CG  ASP A 120     -15.925  44.550  19.118  1.00 36.04           C  
ATOM    640  OD1 ASP A 120     -15.025  45.379  19.364  1.00 31.86           O  
ATOM    641  OD2 ASP A 120     -16.804  44.739  18.255  1.00 47.89           O  
ATOM    642  N   ARG A 121     -13.954  41.102  21.722  1.00 24.94           N  
ATOM    643  CA  ARG A 121     -13.972  39.836  22.417  1.00 30.68           C  
ATOM    644  C   ARG A 121     -13.860  40.096  23.906  1.00 30.74           C  
ATOM    645  O   ARG A 121     -12.822  40.530  24.386  1.00 41.12           O  
ATOM    646  CB  ARG A 121     -12.789  38.998  21.921  1.00 32.29           C  
ATOM    647  CG  ARG A 121     -12.885  37.518  22.164  1.00 30.63           C  
ATOM    648  CD  ARG A 121     -11.539  36.870  21.900  1.00 32.99           C  
ATOM    649  NE  ARG A 121     -11.157  36.853  20.493  1.00 29.12           N  
ATOM    650  CZ  ARG A 121     -11.738  36.098  19.568  1.00 38.68           C  
ATOM    651  NH1 ARG A 121     -11.313  36.137  18.308  1.00 36.27           N  
ATOM    652  NH2 ARG A 121     -12.749  35.307  19.900  1.00 45.27           N  
ATOM    653  N   PRO A 122     -14.935  39.848  24.659  1.00 30.23           N  
ATOM    654  CA  PRO A 122     -14.906  40.070  26.106  1.00 31.11           C  
ATOM    655  C   PRO A 122     -13.853  39.192  26.777  1.00 31.09           C  
ATOM    656  O   PRO A 122     -13.548  38.094  26.296  1.00 25.74           O  
ATOM    657  CB  PRO A 122     -16.323  39.704  26.537  1.00 29.85           C  
ATOM    658  CG  PRO A 122     -16.690  38.636  25.565  1.00 24.62           C  
ATOM    659  CD  PRO A 122     -16.209  39.237  24.258  1.00 34.74           C  
ATOM    660  N   LEU A 123     -13.309  39.686  27.889  1.00 24.74           N  
ATOM    661  CA  LEU A 123     -12.282  38.973  28.642  1.00 17.75           C  
ATOM    662  C   LEU A 123     -12.778  38.684  30.052  1.00 23.74           C  
ATOM    663  O   LEU A 123     -13.284  39.576  30.723  1.00 31.10           O  
ATOM    664  CB  LEU A 123     -10.999  39.809  28.684  1.00 12.76           C  
ATOM    665  CG  LEU A 123      -9.761  39.205  29.343  1.00 16.50           C  
ATOM    666  CD1 LEU A 123      -8.508  39.878  28.816  1.00 11.38           C  
ATOM    667  CD2 LEU A 123      -9.862  39.366  30.848  1.00 25.95           C  
ATOM    668  N   LEU A 124     -12.646  37.435  30.498  1.00 19.20           N  
ATOM    669  CA  LEU A 124     -13.100  37.068  31.838  1.00 21.23           C  
ATOM    670  C   LEU A 124     -11.946  36.669  32.744  1.00 22.15           C  
ATOM    671  O   LEU A 124     -11.146  35.818  32.376  1.00 27.48           O  
ATOM    672  CB  LEU A 124     -14.093  35.902  31.783  1.00 18.04           C  
ATOM    673  CG  LEU A 124     -15.291  35.957  30.834  1.00 20.01           C  
ATOM    674  CD1 LEU A 124     -16.186  34.769  31.130  1.00 23.64           C  
ATOM    675  CD2 LEU A 124     -16.064  37.228  31.010  1.00 23.35           C  
ATOM    676  N   HIS A 125     -11.862  37.289  33.921  1.00 26.46           N  
ATOM    677  CA  HIS A 125     -10.823  36.977  34.914  1.00 26.64           C  
ATOM    678  C   HIS A 125     -11.460  36.065  35.979  1.00 33.39           C  
ATOM    679  O   HIS A 125     -11.876  36.531  37.044  1.00 28.99           O  
ATOM    680  CB  HIS A 125     -10.312  38.263  35.577  1.00 31.82           C  
ATOM    681  CG  HIS A 125      -9.231  38.044  36.595  1.00 40.88           C  
ATOM    682  ND1 HIS A 125      -8.970  36.812  37.157  1.00 36.97           N  
ATOM    683  CD2 HIS A 125      -8.364  38.911  37.172  1.00 36.55           C  
ATOM    684  CE1 HIS A 125      -7.990  36.930  38.037  1.00 33.68           C  
ATOM    685  NE2 HIS A 125      -7.605  38.193  38.066  1.00 31.15           N  
ATOM    686  N   LEU A 126     -11.540  34.771  35.675  1.00 34.26           N  
ATOM    687  CA  LEU A 126     -12.125  33.773  36.575  1.00 36.18           C  
ATOM    688  C   LEU A 126     -11.550  33.826  37.991  1.00 35.94           C  
ATOM    689  O   LEU A 126     -10.335  33.910  38.182  1.00 32.01           O  
ATOM    690  CB  LEU A 126     -11.927  32.369  35.999  1.00 37.87           C  
ATOM    691  CG  LEU A 126     -12.440  32.193  34.568  1.00 35.96           C  
ATOM    692  CD1 LEU A 126     -11.835  30.930  33.960  1.00 37.42           C  
ATOM    693  CD2 LEU A 126     -13.963  32.137  34.570  1.00 33.69           C  
ATOM    694  N   LEU A 127     -12.435  33.755  38.979  1.00 38.63           N  
ATOM    695  CA  LEU A 127     -12.039  33.813  40.382  1.00 38.37           C  
ATOM    696  C   LEU A 127     -12.706  32.722  41.213  1.00 41.65           C  
ATOM    697  O   LEU A 127     -13.765  32.220  40.847  1.00 45.18           O  
ATOM    698  CB  LEU A 127     -12.412  35.177  40.955  1.00 37.15           C  
ATOM    699  CG  LEU A 127     -11.734  36.363  40.278  1.00 38.41           C  
ATOM    700  CD1 LEU A 127     -12.538  37.627  40.526  1.00 41.70           C  
ATOM    701  CD2 LEU A 127     -10.309  36.486  40.795  1.00 36.04           C  
ATOM    702  N   PRO A 128     -12.088  32.346  42.347  1.00 43.08           N  
ATOM    703  CA  PRO A 128     -12.619  31.314  43.241  1.00 49.48           C  
ATOM    704  C   PRO A 128     -13.776  31.830  44.096  1.00 57.15           C  
ATOM    705  O   PRO A 128     -14.887  32.019  43.601  1.00 58.35           O  
ATOM    706  CB  PRO A 128     -11.400  30.936  44.077  1.00 50.68           C  
ATOM    707  CG  PRO A 128     -10.679  32.239  44.201  1.00 43.50           C  
ATOM    708  CD  PRO A 128     -10.749  32.778  42.791  1.00 48.36           C  
ATOM    709  N   ALA A 129     -13.510  32.051  45.381  1.00 63.14           N  
ATOM    710  CA  ALA A 129     -14.519  32.557  46.308  1.00 62.75           C  
ATOM    711  C   ALA A 129     -15.114  33.847  45.745  1.00 63.83           C  
ATOM    712  O   ALA A 129     -14.451  34.884  45.726  1.00 67.13           O  
ATOM    713  CB  ALA A 129     -13.886  32.819  47.674  1.00 49.26           C  
ATOM    714  N   GLY A 130     -16.361  33.780  45.290  1.00 62.76           N  
ATOM    715  CA  GLY A 130     -17.003  34.956  44.728  1.00 67.35           C  
ATOM    716  C   GLY A 130     -17.488  35.957  45.759  1.00 69.61           C  
ATOM    717  O   GLY A 130     -18.499  35.724  46.420  1.00 70.15           O  
ATOM    718  N   GLU A 131     -16.774  37.075  45.887  1.00 72.64           N  
ATOM    719  CA  GLU A 131     -17.132  38.122  46.847  1.00 75.25           C  
ATOM    720  C   GLU A 131     -16.218  39.340  46.714  1.00 74.27           C  
ATOM    721  O   GLU A 131     -15.026  39.265  47.010  1.00 74.30           O  
ATOM    722  CB  GLU A 131     -17.050  37.569  48.275  1.00 76.94           C  
ATOM    723  CG  GLU A 131     -17.497  38.534  49.364  1.00 76.57           C  
ATOM    724  CD  GLU A 131     -17.758  37.833  50.684  1.00 77.79           C  
ATOM    725  OE1 GLU A 131     -18.594  36.904  50.705  1.00 76.96           O  
ATOM    726  OE2 GLU A 131     -17.135  38.211  51.698  1.00 82.43           O  
ATOM    727  N   GLY A 132     -16.786  40.458  46.271  1.00 74.38           N  
ATOM    728  CA  GLY A 132     -16.004  41.672  46.111  1.00 76.51           C  
ATOM    729  C   GLY A 132     -16.683  42.709  45.231  1.00 78.91           C  
ATOM    730  O   GLY A 132     -17.875  42.977  45.384  1.00 82.92           O  
ATOM    731  N   SER A 133     -15.923  43.288  44.303  1.00 76.97           N  
ATOM    732  CA  SER A 133     -16.446  44.301  43.390  1.00 74.29           C  
ATOM    733  C   SER A 133     -17.494  43.697  42.452  1.00 74.12           C  
ATOM    734  O   SER A 133     -17.880  42.538  42.609  1.00 77.49           O  
ATOM    735  CB  SER A 133     -15.299  44.909  42.573  1.00 73.16           C  
ATOM    736  OG  SER A 133     -15.745  45.997  41.782  1.00 73.91           O  
ATOM    737  N   GLY A 134     -17.944  44.483  41.477  1.00 70.54           N  
ATOM    738  CA  GLY A 134     -18.949  44.004  40.540  1.00 64.20           C  
ATOM    739  C   GLY A 134     -18.484  42.839  39.682  1.00 60.49           C  
ATOM    740  O   GLY A 134     -17.964  43.036  38.584  1.00 56.71           O  
ATOM    741  N   LEU A 135     -18.679  41.623  40.182  1.00 56.80           N  
ATOM    742  CA  LEU A 135     -18.284  40.413  39.470  1.00 55.40           C  
ATOM    743  C   LEU A 135     -19.458  39.848  38.681  1.00 57.19           C  
ATOM    744  O   LEU A 135     -20.528  40.450  38.622  1.00 62.96           O  
ATOM    745  CB  LEU A 135     -17.792  39.361  40.461  1.00 55.44           C  
ATOM    746  CG  LEU A 135     -16.660  39.817  41.381  1.00 62.78           C  
ATOM    747  CD1 LEU A 135     -16.457  38.804  42.503  1.00 66.65           C  
ATOM    748  CD2 LEU A 135     -15.393  39.994  40.560  1.00 64.48           C  
ATOM    749  N   THR A 136     -19.257  38.677  38.089  1.00 51.43           N  
ATOM    750  CA  THR A 136     -20.299  38.046  37.305  1.00 49.35           C  
ATOM    751  C   THR A 136     -20.154  36.531  37.387  1.00 51.84           C  
ATOM    752  O   THR A 136     -19.058  35.989  37.234  1.00 47.18           O  
ATOM    753  CB  THR A 136     -20.221  38.495  35.821  1.00 53.41           C  
ATOM    754  OG1 THR A 136     -20.274  39.926  35.750  1.00 48.08           O  
ATOM    755  CG2 THR A 136     -21.379  37.912  35.017  1.00 44.04           C  
ATOM    756  N   PRO A 137     -21.267  35.827  37.652  1.00 54.08           N  
ATOM    757  CA  PRO A 137     -21.240  34.366  37.751  1.00 52.13           C  
ATOM    758  C   PRO A 137     -20.839  33.753  36.418  1.00 50.62           C  
ATOM    759  O   PRO A 137     -21.498  33.968  35.399  1.00 51.76           O  
ATOM    760  CB  PRO A 137     -22.674  34.022  38.146  1.00 49.18           C  
ATOM    761  CG  PRO A 137     -23.466  35.102  37.473  1.00 56.94           C  
ATOM    762  CD  PRO A 137     -22.643  36.333  37.798  1.00 55.29           C  
ATOM    763  N   THR A 138     -19.747  32.997  36.440  1.00 48.42           N  
ATOM    764  CA  THR A 138     -19.217  32.337  35.253  1.00 40.59           C  
ATOM    765  C   THR A 138     -20.317  31.642  34.464  1.00 41.41           C  
ATOM    766  O   THR A 138     -20.298  31.628  33.235  1.00 40.67           O  
ATOM    767  CB  THR A 138     -18.168  31.288  35.641  1.00 38.48           C  
ATOM    768  OG1 THR A 138     -17.327  31.815  36.676  1.00 41.73           O  
ATOM    769  CG2 THR A 138     -17.313  30.930  34.445  1.00 43.08           C  
ATOM    770  N   LEU A 139     -21.273  31.061  35.181  1.00 43.71           N  
ATOM    771  CA  LEU A 139     -22.382  30.357  34.549  1.00 45.78           C  
ATOM    772  C   LEU A 139     -23.135  31.241  33.559  1.00 45.53           C  
ATOM    773  O   LEU A 139     -23.539  30.791  32.485  1.00 45.13           O  
ATOM    774  CB  LEU A 139     -23.345  29.831  35.619  1.00 46.79           C  
ATOM    775  CG  LEU A 139     -23.134  28.402  36.122  1.00 47.26           C  
ATOM    776  CD1 LEU A 139     -21.666  28.149  36.425  1.00 54.26           C  
ATOM    777  CD2 LEU A 139     -23.988  28.184  37.358  1.00 48.07           C  
ATOM    778  N   ASP A 140     -23.317  32.504  33.926  1.00 45.67           N  
ATOM    779  CA  ASP A 140     -24.027  33.462  33.087  1.00 45.02           C  
ATOM    780  C   ASP A 140     -23.105  34.088  32.050  1.00 44.41           C  
ATOM    781  O   ASP A 140     -23.523  34.361  30.925  1.00 43.03           O  
ATOM    782  CB  ASP A 140     -24.643  34.552  33.968  1.00 49.35           C  
ATOM    783  CG  ASP A 140     -25.726  34.015  34.887  1.00 56.00           C  
ATOM    784  OD1 ASP A 140     -25.965  34.624  35.954  1.00 60.08           O  
ATOM    785  OD2 ASP A 140     -26.346  32.987  34.539  1.00 60.98           O  
ATOM    786  N   ALA A 141     -21.852  34.312  32.440  1.00 46.46           N  
ATOM    787  CA  ALA A 141     -20.842  34.904  31.558  1.00 44.31           C  
ATOM    788  C   ALA A 141     -20.599  34.031  30.328  1.00 40.39           C  
ATOM    789  O   ALA A 141     -20.447  34.531  29.214  1.00 36.57           O  
ATOM    790  CB  ALA A 141     -19.539  35.100  32.325  1.00 41.18           C  
ATOM    791  N   LEU A 142     -20.556  32.722  30.547  1.00 43.37           N  
ATOM    792  CA  LEU A 142     -20.341  31.764  29.471  1.00 46.45           C  
ATOM    793  C   LEU A 142     -21.675  31.224  28.955  1.00 47.12           C  
ATOM    794  O   LEU A 142     -21.749  30.117  28.423  1.00 48.64           O  
ATOM    795  CB  LEU A 142     -19.449  30.622  29.969  1.00 35.30           C  
ATOM    796  CG  LEU A 142     -17.936  30.785  29.807  1.00 38.83           C  
ATOM    797  CD1 LEU A 142     -17.566  32.250  29.711  1.00 40.20           C  
ATOM    798  CD2 LEU A 142     -17.219  30.115  30.972  1.00 31.19           C  
ATOM    799  N   ALA A 143     -22.726  32.020  29.116  1.00 48.81           N  
ATOM    800  CA  ALA A 143     -24.052  31.638  28.665  1.00 47.06           C  
ATOM    801  C   ALA A 143     -24.016  31.178  27.221  1.00 46.48           C  
ATOM    802  O   ALA A 143     -24.271  30.013  26.931  1.00 51.05           O  
ATOM    803  CB  ALA A 143     -25.014  32.806  28.806  1.00 54.16           C  
ATOM    804  N   ASP A 144     -23.692  32.084  26.308  1.00 47.14           N  
ATOM    805  CA  ASP A 144     -23.664  31.704  24.902  1.00 54.28           C  
ATOM    806  C   ASP A 144     -22.288  31.257  24.426  1.00 51.46           C  
ATOM    807  O   ASP A 144     -21.999  31.270  23.230  1.00 53.15           O  
ATOM    808  CB  ASP A 144     -24.158  32.854  24.027  1.00 57.23           C  
ATOM    809  CG  ASP A 144     -24.851  32.363  22.768  1.00 59.63           C  
ATOM    810  OD1 ASP A 144     -24.833  33.084  21.750  1.00 59.75           O  
ATOM    811  OD2 ASP A 144     -25.424  31.251  22.802  1.00 61.19           O  
ATOM    812  N   PHE A 145     -21.443  30.849  25.363  1.00 48.79           N  
ATOM    813  CA  PHE A 145     -20.103  30.408  25.014  1.00 42.68           C  
ATOM    814  C   PHE A 145     -19.785  29.074  25.697  1.00 43.00           C  
ATOM    815  O   PHE A 145     -18.969  29.007  26.613  1.00 43.05           O  
ATOM    816  CB  PHE A 145     -19.105  31.486  25.430  1.00 41.84           C  
ATOM    817  CG  PHE A 145     -19.422  32.855  24.877  1.00 40.71           C  
ATOM    818  CD1 PHE A 145     -19.491  33.067  23.502  1.00 39.18           C  
ATOM    819  CD2 PHE A 145     -19.619  33.938  25.730  1.00 36.82           C  
ATOM    820  CE1 PHE A 145     -19.753  34.335  22.987  1.00 34.24           C  
ATOM    821  CE2 PHE A 145     -19.883  35.209  25.220  1.00 35.20           C  
ATOM    822  CZ  PHE A 145     -19.947  35.407  23.846  1.00 32.26           C  
ATOM    823  N   PRO A 146     -20.431  27.989  25.250  1.00 41.48           N  
ATOM    824  CA  PRO A 146     -20.220  26.659  25.818  1.00 38.58           C  
ATOM    825  C   PRO A 146     -18.838  26.066  25.570  1.00 35.67           C  
ATOM    826  O   PRO A 146     -18.335  25.301  26.388  1.00 33.50           O  
ATOM    827  CB  PRO A 146     -21.322  25.834  25.157  1.00 43.23           C  
ATOM    828  CG  PRO A 146     -21.413  26.447  23.799  1.00 43.79           C  
ATOM    829  CD  PRO A 146     -21.396  27.929  24.136  1.00 47.11           C  
ATOM    830  N   GLU A 147     -18.226  26.409  24.443  1.00 33.09           N  
ATOM    831  CA  GLU A 147     -16.913  25.864  24.122  1.00 33.21           C  
ATOM    832  C   GLU A 147     -15.839  26.338  25.098  1.00 34.20           C  
ATOM    833  O   GLU A 147     -14.759  25.754  25.174  1.00 34.19           O  
ATOM    834  CB  GLU A 147     -16.520  26.217  22.677  1.00 31.38           C  
ATOM    835  CG  GLU A 147     -16.174  27.681  22.410  1.00 35.59           C  
ATOM    836  CD  GLU A 147     -17.357  28.625  22.542  1.00 33.84           C  
ATOM    837  OE1 GLU A 147     -18.511  28.147  22.611  1.00 35.72           O  
ATOM    838  OE2 GLU A 147     -17.123  29.852  22.560  1.00 33.26           O  
ATOM    839  N   ALA A 148     -16.150  27.395  25.848  1.00 36.24           N  
ATOM    840  CA  ALA A 148     -15.228  27.956  26.830  1.00 33.96           C  
ATOM    841  C   ALA A 148     -15.536  27.397  28.211  1.00 33.08           C  
ATOM    842  O   ALA A 148     -14.688  27.408  29.102  1.00 33.87           O  
ATOM    843  CB  ALA A 148     -15.344  29.472  26.849  1.00 32.56           C  
ATOM    844  N   LEU A 149     -16.751  26.890  28.375  1.00 33.83           N  
ATOM    845  CA  LEU A 149     -17.180  26.337  29.649  1.00 34.56           C  
ATOM    846  C   LEU A 149     -16.531  24.982  29.917  1.00 33.26           C  
ATOM    847  O   LEU A 149     -16.063  24.715  31.023  1.00 38.11           O  
ATOM    848  CB  LEU A 149     -18.705  26.192  29.661  1.00 34.58           C  
ATOM    849  CG  LEU A 149     -19.422  26.342  31.008  1.00 42.84           C  
ATOM    850  CD1 LEU A 149     -20.916  26.135  30.804  1.00 46.53           C  
ATOM    851  CD2 LEU A 149     -18.886  25.340  32.024  1.00 51.45           C  
ATOM    852  N   ALA A 150     -16.496  24.136  28.895  1.00 30.51           N  
ATOM    853  CA  ALA A 150     -15.928  22.796  29.012  1.00 29.66           C  
ATOM    854  C   ALA A 150     -14.450  22.795  29.387  1.00 31.27           C  
ATOM    855  O   ALA A 150     -13.876  21.748  29.702  1.00 34.52           O  
ATOM    856  CB  ALA A 150     -16.132  22.036  27.696  1.00 37.40           C  
ATOM    857  N   LEU A 151     -13.827  23.963  29.339  1.00 27.25           N  
ATOM    858  CA  LEU A 151     -12.412  24.060  29.668  1.00 25.18           C  
ATOM    859  C   LEU A 151     -12.196  24.107  31.171  1.00 28.94           C  
ATOM    860  O   LEU A 151     -11.157  23.680  31.672  1.00 35.10           O  
ATOM    861  CB  LEU A 151     -11.809  25.316  29.045  1.00 13.82           C  
ATOM    862  CG  LEU A 151     -11.946  25.477  27.538  1.00 28.44           C  
ATOM    863  CD1 LEU A 151     -11.391  26.841  27.150  1.00 27.01           C  
ATOM    864  CD2 LEU A 151     -11.204  24.362  26.810  1.00 20.17           C  
ATOM    865  N   LEU A 152     -13.187  24.618  31.889  1.00 28.89           N  
ATOM    866  CA  LEU A 152     -13.061  24.769  33.328  1.00 33.97           C  
ATOM    867  C   LEU A 152     -14.094  24.049  34.162  1.00 34.72           C  
ATOM    868  O   LEU A 152     -14.969  23.350  33.652  1.00 33.93           O  
ATOM    869  CB  LEU A 152     -13.095  26.256  33.703  1.00 37.02           C  
ATOM    870  CG  LEU A 152     -13.468  27.259  32.612  1.00 28.96           C  
ATOM    871  CD1 LEU A 152     -14.088  28.510  33.209  1.00 36.26           C  
ATOM    872  CD2 LEU A 152     -12.223  27.600  31.830  1.00 31.71           C  
ATOM    873  N   ASP A 153     -13.971  24.240  35.468  1.00 40.06           N  
ATOM    874  CA  ASP A 153     -14.890  23.654  36.420  1.00 41.95           C  
ATOM    875  C   ASP A 153     -15.621  24.820  37.090  1.00 38.24           C  
ATOM    876  O   ASP A 153     -15.061  25.520  37.928  1.00 34.22           O  
ATOM    877  CB  ASP A 153     -14.119  22.839  37.457  1.00 46.20           C  
ATOM    878  CG  ASP A 153     -15.026  22.217  38.492  1.00 45.59           C  
ATOM    879  OD1 ASP A 153     -15.695  22.976  39.226  1.00 45.97           O  
ATOM    880  OD2 ASP A 153     -15.072  20.973  38.563  1.00 44.95           O  
ATOM    881  N   PRO A 154     -16.884  25.050  36.708  1.00 41.02           N  
ATOM    882  CA  PRO A 154     -17.723  26.124  37.247  1.00 44.94           C  
ATOM    883  C   PRO A 154     -17.691  26.262  38.767  1.00 47.74           C  
ATOM    884  O   PRO A 154     -17.805  27.370  39.290  1.00 55.47           O  
ATOM    885  CB  PRO A 154     -19.112  25.757  36.740  1.00 49.62           C  
ATOM    886  CG  PRO A 154     -18.811  25.133  35.401  1.00 50.66           C  
ATOM    887  CD  PRO A 154     -17.618  24.257  35.705  1.00 40.99           C  
ATOM    888  N   ALA A 155     -17.533  25.147  39.477  1.00 44.50           N  
ATOM    889  CA  ALA A 155     -17.506  25.179  40.943  1.00 42.81           C  
ATOM    890  C   ALA A 155     -16.237  25.805  41.525  1.00 37.37           C  
ATOM    891  O   ALA A 155     -16.304  26.582  42.475  1.00 29.11           O  
ATOM    892  CB  ALA A 155     -17.690  23.764  41.494  1.00 48.59           C  
ATOM    893  N   ARG A 156     -15.085  25.466  40.955  1.00 37.52           N  
ATOM    894  CA  ARG A 156     -13.812  26.005  41.433  1.00 36.35           C  
ATOM    895  C   ARG A 156     -13.544  27.419  40.883  1.00 35.32           C  
ATOM    896  O   ARG A 156     -12.629  28.106  41.333  1.00 30.46           O  
ATOM    897  CB  ARG A 156     -12.671  25.057  41.051  1.00 38.21           C  
ATOM    898  CG  ARG A 156     -12.996  23.577  41.285  1.00 41.10           C  
ATOM    899  CD  ARG A 156     -11.838  22.676  40.883  1.00 49.29           C  
ATOM    900  NE  ARG A 156     -10.932  22.420  41.996  1.00 52.03           N  
ATOM    901  CZ  ARG A 156     -11.013  21.359  42.790  1.00 51.25           C  
ATOM    902  NH1 ARG A 156     -11.955  20.446  42.588  1.00 47.19           N  
ATOM    903  NH2 ARG A 156     -10.166  21.222  43.799  1.00 43.74           N  
ATOM    904  N   LEU A 157     -14.352  27.842  39.912  1.00 30.77           N  
ATOM    905  CA  LEU A 157     -14.233  29.167  39.305  1.00 35.15           C  
ATOM    906  C   LEU A 157     -15.646  29.668  39.018  1.00 38.84           C  
ATOM    907  O   LEU A 157     -16.013  29.903  37.866  1.00 47.28           O  
ATOM    908  CB  LEU A 157     -13.442  29.098  37.992  1.00 37.22           C  
ATOM    909  CG  LEU A 157     -11.931  28.843  38.052  1.00 45.09           C  
ATOM    910  CD1 LEU A 157     -11.390  28.615  36.647  1.00 36.77           C  
ATOM    911  CD2 LEU A 157     -11.234  30.028  38.711  1.00 38.43           C  
ATOM    912  N   PRO A 158     -16.455  29.842  40.071  1.00 33.30           N  
ATOM    913  CA  PRO A 158     -17.840  30.305  39.980  1.00 29.56           C  
ATOM    914  C   PRO A 158     -18.048  31.720  39.444  1.00 35.70           C  
ATOM    915  O   PRO A 158     -18.952  31.960  38.642  1.00 35.56           O  
ATOM    916  CB  PRO A 158     -18.336  30.156  41.415  1.00 32.06           C  
ATOM    917  CG  PRO A 158     -17.127  30.489  42.209  1.00 32.70           C  
ATOM    918  CD  PRO A 158     -16.036  29.727  41.479  1.00 31.80           C  
ATOM    919  N   VAL A 159     -17.209  32.654  39.885  1.00 34.55           N  
ATOM    920  CA  VAL A 159     -17.333  34.047  39.471  1.00 36.01           C  
ATOM    921  C   VAL A 159     -16.169  34.571  38.620  1.00 39.64           C  
ATOM    922  O   VAL A 159     -15.106  33.953  38.541  1.00 34.53           O  
ATOM    923  CB  VAL A 159     -17.484  34.961  40.705  1.00 38.69           C  
ATOM    924  CG1 VAL A 159     -18.695  34.522  41.541  1.00 27.16           C  
ATOM    925  CG2 VAL A 159     -16.203  34.917  41.542  1.00 29.78           C  
ATOM    926  N   ALA A 160     -16.380  35.727  37.995  1.00 38.48           N  
ATOM    927  CA  ALA A 160     -15.356  36.340  37.160  1.00 44.22           C  
ATOM    928  C   ALA A 160     -15.534  37.854  37.041  1.00 45.63           C  
ATOM    929  O   ALA A 160     -16.584  38.406  37.375  1.00 46.92           O  
ATOM    930  CB  ALA A 160     -15.378  35.710  35.768  1.00 34.63           C  
ATOM    931  N   ARG A 161     -14.486  38.516  36.562  1.00 43.37           N  
ATOM    932  CA  ARG A 161     -14.501  39.957  36.349  1.00 36.93           C  
ATOM    933  C   ARG A 161     -14.515  40.111  34.825  1.00 32.81           C  
ATOM    934  O   ARG A 161     -13.497  39.905  34.164  1.00 33.17           O  
ATOM    935  CB  ARG A 161     -13.239  40.586  36.952  1.00 41.33           C  
ATOM    936  CG  ARG A 161     -13.006  42.064  36.617  1.00 41.49           C  
ATOM    937  CD  ARG A 161     -13.367  42.990  37.773  1.00 41.67           C  
ATOM    938  NE  ARG A 161     -12.838  42.502  39.045  1.00 48.47           N  
ATOM    939  CZ  ARG A 161     -11.556  42.232  39.279  1.00 49.04           C  
ATOM    940  NH1 ARG A 161     -10.649  42.407  38.326  1.00 45.71           N  
ATOM    941  NH2 ARG A 161     -11.185  41.754  40.461  1.00 46.12           N  
ATOM    942  N   VAL A 162     -15.676  40.444  34.274  1.00 23.75           N  
ATOM    943  CA  VAL A 162     -15.822  40.603  32.830  1.00 28.23           C  
ATOM    944  C   VAL A 162     -15.405  41.974  32.302  1.00 26.87           C  
ATOM    945  O   VAL A 162     -15.647  42.992  32.947  1.00 29.47           O  
ATOM    946  CB  VAL A 162     -17.287  40.399  32.388  1.00 32.67           C  
ATOM    947  CG1 VAL A 162     -17.380  40.461  30.870  1.00 34.82           C  
ATOM    948  CG2 VAL A 162     -17.823  39.077  32.914  1.00 31.47           C  
ATOM    949  N   ASP A 163     -14.783  41.994  31.128  1.00 21.42           N  
ATOM    950  CA  ASP A 163     -14.389  43.252  30.494  1.00 26.48           C  
ATOM    951  C   ASP A 163     -14.999  43.232  29.102  1.00 25.52           C  
ATOM    952  O   ASP A 163     -14.455  42.624  28.182  1.00 32.84           O  
ATOM    953  CB  ASP A 163     -12.863  43.389  30.401  1.00 23.56           C  
ATOM    954  CG  ASP A 163     -12.431  44.505  29.455  1.00 29.45           C  
ATOM    955  OD1 ASP A 163     -13.303  45.251  28.956  1.00 17.43           O  
ATOM    956  OD2 ASP A 163     -11.213  44.633  29.201  1.00 26.79           O  
ATOM    957  N   PRO A 164     -16.153  43.894  28.933  1.00 30.87           N  
ATOM    958  CA  PRO A 164     -16.846  43.943  27.642  1.00 30.53           C  
ATOM    959  C   PRO A 164     -16.113  44.712  26.547  1.00 30.92           C  
ATOM    960  O   PRO A 164     -16.447  44.580  25.371  1.00 33.35           O  
ATOM    961  CB  PRO A 164     -18.191  44.589  27.994  1.00 33.89           C  
ATOM    962  CG  PRO A 164     -18.380  44.234  29.442  1.00 37.34           C  
ATOM    963  CD  PRO A 164     -16.992  44.480  29.991  1.00 32.70           C  
ATOM    964  N   ARG A 165     -15.108  45.500  26.919  1.00 26.51           N  
ATOM    965  CA  ARG A 165     -14.377  46.272  25.920  1.00 28.56           C  
ATOM    966  C   ARG A 165     -13.057  45.637  25.463  1.00 24.57           C  
ATOM    967  O   ARG A 165     -12.274  46.272  24.762  1.00 20.46           O  
ATOM    968  CB  ARG A 165     -14.102  47.688  26.444  1.00 28.96           C  
ATOM    969  CG  ARG A 165     -15.334  48.432  26.953  1.00 23.70           C  
ATOM    970  CD  ARG A 165     -14.963  49.824  27.410  1.00 13.28           C  
ATOM    971  NE  ARG A 165     -14.439  50.616  26.294  1.00 20.53           N  
ATOM    972  CZ  ARG A 165     -13.428  51.472  26.395  1.00 14.41           C  
ATOM    973  NH1 ARG A 165     -12.825  51.645  27.562  1.00 23.67           N  
ATOM    974  NH2 ARG A 165     -13.017  52.162  25.341  1.00 11.80           N  
ATOM    975  N   ALA A 166     -12.802  44.392  25.853  1.00 24.94           N  
ATOM    976  CA  ALA A 166     -11.555  43.735  25.461  1.00 19.69           C  
ATOM    977  C   ALA A 166     -11.530  43.506  23.951  1.00 17.99           C  
ATOM    978  O   ALA A 166     -12.570  43.315  23.327  1.00 22.33           O  
ATOM    979  CB  ALA A 166     -11.392  42.405  26.220  1.00  8.14           C  
ATOM    980  N   LEU A 167     -10.336  43.529  23.370  1.00 16.42           N  
ATOM    981  CA  LEU A 167     -10.171  43.336  21.938  1.00 11.50           C  
ATOM    982  C   LEU A 167      -9.032  42.366  21.612  1.00 12.74           C  
ATOM    983  O   LEU A 167      -8.060  42.270  22.362  1.00 13.25           O  
ATOM    984  CB  LEU A 167      -9.832  44.671  21.269  1.00 17.66           C  
ATOM    985  CG  LEU A 167     -10.691  45.924  21.405  1.00 18.89           C  
ATOM    986  CD1 LEU A 167      -9.965  47.057  20.712  1.00 10.75           C  
ATOM    987  CD2 LEU A 167     -12.069  45.704  20.795  1.00 12.25           C  
ATOM    988  N   THR A 168      -9.144  41.648  20.496  1.00 14.05           N  
ATOM    989  CA  THR A 168      -8.049  40.775  20.079  1.00 17.05           C  
ATOM    990  C   THR A 168      -7.597  41.161  18.680  1.00 17.21           C  
ATOM    991  O   THR A 168      -8.410  41.510  17.825  1.00 13.58           O  
ATOM    992  CB  THR A 168      -8.407  39.263  20.068  1.00 18.31           C  
ATOM    993  OG1 THR A 168      -9.654  39.054  19.400  1.00 19.45           O  
ATOM    994  CG2 THR A 168      -8.475  38.721  21.489  1.00 21.48           C  
ATOM    995  N   TYR A 169      -6.289  41.111  18.464  1.00 17.72           N  
ATOM    996  CA  TYR A 169      -5.703  41.429  17.168  1.00 14.95           C  
ATOM    997  C   TYR A 169      -4.348  40.756  17.081  1.00 15.34           C  
ATOM    998  O   TYR A 169      -3.838  40.238  18.078  1.00 15.70           O  
ATOM    999  CB  TYR A 169      -5.525  42.939  17.025  1.00 17.63           C  
ATOM   1000  CG  TYR A 169      -4.562  43.555  18.028  1.00 23.58           C  
ATOM   1001  CD1 TYR A 169      -3.204  43.762  17.712  1.00 25.69           C  
ATOM   1002  CD2 TYR A 169      -5.013  43.960  19.281  1.00 13.89           C  
ATOM   1003  CE1 TYR A 169      -2.326  44.371  18.627  1.00 15.61           C  
ATOM   1004  CE2 TYR A 169      -4.154  44.562  20.194  1.00 15.03           C  
ATOM   1005  CZ  TYR A 169      -2.821  44.770  19.867  1.00 23.14           C  
ATOM   1006  OH  TYR A 169      -2.005  45.410  20.775  1.00 17.39           O  
ATOM   1007  N   ARG A 170      -3.753  40.767  15.896  1.00 12.39           N  
ATOM   1008  CA  ARG A 170      -2.435  40.163  15.734  1.00  9.82           C  
ATOM   1009  C   ARG A 170      -1.374  41.257  15.767  1.00  9.79           C  
ATOM   1010  O   ARG A 170      -1.320  42.111  14.882  1.00 15.80           O  
ATOM   1011  CB  ARG A 170      -2.353  39.397  14.406  1.00  5.49           C  
ATOM   1012  CG  ARG A 170      -3.366  38.278  14.263  1.00 14.44           C  
ATOM   1013  CD  ARG A 170      -3.177  37.231  15.350  1.00 28.45           C  
ATOM   1014  NE  ARG A 170      -1.838  36.642  15.302  1.00 34.20           N  
ATOM   1015  CZ  ARG A 170      -1.474  35.652  14.493  1.00 41.82           C  
ATOM   1016  NH1 ARG A 170      -2.356  35.119  13.656  1.00 39.71           N  
ATOM   1017  NH2 ARG A 170      -0.222  35.210  14.513  1.00 42.57           N  
ATOM   1018  N   PRO A 171      -0.511  41.246  16.789  1.00 16.18           N  
ATOM   1019  CA  PRO A 171       0.541  42.261  16.898  1.00 11.99           C  
ATOM   1020  C   PRO A 171       1.437  42.257  15.669  1.00 18.41           C  
ATOM   1021  O   PRO A 171       1.952  43.299  15.258  1.00 13.46           O  
ATOM   1022  CB  PRO A 171       1.302  41.845  18.159  1.00 17.96           C  
ATOM   1023  CG  PRO A 171       0.253  41.146  18.976  1.00 14.15           C  
ATOM   1024  CD  PRO A 171      -0.462  40.316  17.929  1.00 17.10           C  
ATOM   1025  N   GLY A 172       1.615  41.065  15.094  1.00 21.81           N  
ATOM   1026  CA  GLY A 172       2.432  40.905  13.906  1.00 12.40           C  
ATOM   1027  C   GLY A 172       1.874  41.748  12.779  1.00 16.52           C  
ATOM   1028  O   GLY A 172       2.613  42.455  12.097  1.00 18.62           O  
ATOM   1029  N   SER A 173       0.563  41.678  12.580  1.00 13.12           N  
ATOM   1030  CA  SER A 173      -0.077  42.474  11.541  1.00 15.36           C  
ATOM   1031  C   SER A 173       0.042  43.966  11.843  1.00 13.87           C  
ATOM   1032  O   SER A 173       0.214  44.775  10.937  1.00 17.90           O  
ATOM   1033  CB  SER A 173      -1.556  42.111  11.420  1.00 20.75           C  
ATOM   1034  OG  SER A 173      -1.708  40.821  10.868  1.00 36.98           O  
ATOM   1035  N   LEU A 174      -0.065  44.327  13.119  1.00 13.26           N  
ATOM   1036  CA  LEU A 174       0.032  45.726  13.536  1.00  9.02           C  
ATOM   1037  C   LEU A 174       1.402  46.257  13.164  1.00  9.36           C  
ATOM   1038  O   LEU A 174       1.520  47.291  12.512  1.00 20.25           O  
ATOM   1039  CB  LEU A 174      -0.175  45.855  15.050  1.00  3.64           C  
ATOM   1040  CG  LEU A 174       0.029  47.247  15.644  1.00  9.16           C  
ATOM   1041  CD1 LEU A 174      -0.781  48.250  14.836  1.00  5.24           C  
ATOM   1042  CD2 LEU A 174      -0.406  47.299  17.134  1.00  1.12           C  
ATOM   1043  N   ALA A 175       2.431  45.527  13.572  1.00 12.53           N  
ATOM   1044  CA  ALA A 175       3.813  45.902  13.307  1.00 15.72           C  
ATOM   1045  C   ALA A 175       4.103  46.023  11.806  1.00 12.99           C  
ATOM   1046  O   ALA A 175       4.632  47.036  11.362  1.00 11.99           O  
ATOM   1047  CB  ALA A 175       4.749  44.882  13.952  1.00 22.02           C  
ATOM   1048  N   LEU A 176       3.760  44.988  11.038  1.00 10.86           N  
ATOM   1049  CA  LEU A 176       3.975  44.996   9.588  1.00 14.39           C  
ATOM   1050  C   LEU A 176       3.319  46.227   8.964  1.00 18.31           C  
ATOM   1051  O   LEU A 176       3.930  46.938   8.166  1.00 19.15           O  
ATOM   1052  CB  LEU A 176       3.385  43.738   8.942  1.00  6.22           C  
ATOM   1053  CG  LEU A 176       3.644  43.638   7.433  1.00 16.62           C  
ATOM   1054  CD1 LEU A 176       5.141  43.591   7.200  1.00  6.43           C  
ATOM   1055  CD2 LEU A 176       2.962  42.401   6.825  1.00  1.09           C  
ATOM   1056  N   LEU A 177       2.061  46.456   9.328  1.00 14.78           N  
ATOM   1057  CA  LEU A 177       1.308  47.594   8.829  1.00 16.42           C  
ATOM   1058  C   LEU A 177       2.058  48.883   9.112  1.00 18.68           C  
ATOM   1059  O   LEU A 177       2.187  49.746   8.248  1.00 22.30           O  
ATOM   1060  CB  LEU A 177      -0.062  47.670   9.500  1.00  9.63           C  
ATOM   1061  CG  LEU A 177      -0.823  48.983   9.323  1.00  4.14           C  
ATOM   1062  CD1 LEU A 177      -1.077  49.268   7.850  1.00  9.16           C  
ATOM   1063  CD2 LEU A 177      -2.126  48.889  10.070  1.00 20.48           C  
ATOM   1064  N   ALA A 178       2.554  49.010  10.333  1.00 14.23           N  
ATOM   1065  CA  ALA A 178       3.267  50.204  10.724  1.00  9.35           C  
ATOM   1066  C   ALA A 178       4.543  50.332   9.919  1.00  8.84           C  
ATOM   1067  O   ALA A 178       4.854  51.407   9.413  1.00 12.56           O  
ATOM   1068  CB  ALA A 178       3.577  50.162  12.212  1.00  9.54           C  
ATOM   1069  N   ALA A 179       5.287  49.243   9.784  1.00 13.87           N  
ATOM   1070  CA  ALA A 179       6.524  49.313   9.015  1.00  9.75           C  
ATOM   1071  C   ALA A 179       6.186  49.678   7.565  1.00 10.75           C  
ATOM   1072  O   ALA A 179       6.763  50.603   7.004  1.00 15.54           O  
ATOM   1073  CB  ALA A 179       7.270  47.981   9.077  1.00  4.90           C  
ATOM   1074  N   GLN A 180       5.241  48.964   6.967  1.00  7.61           N  
ATOM   1075  CA  GLN A 180       4.862  49.240   5.594  1.00 14.79           C  
ATOM   1076  C   GLN A 180       4.574  50.714   5.347  1.00 19.89           C  
ATOM   1077  O   GLN A 180       5.178  51.339   4.468  1.00 23.86           O  
ATOM   1078  CB  GLN A 180       3.655  48.392   5.203  1.00  7.89           C  
ATOM   1079  CG  GLN A 180       4.028  46.941   5.076  1.00  9.35           C  
ATOM   1080  CD  GLN A 180       2.889  46.086   4.619  1.00 19.61           C  
ATOM   1081  OE1 GLN A 180       1.734  46.325   4.990  1.00 19.73           O  
ATOM   1082  NE2 GLN A 180       3.199  45.065   3.814  1.00 15.52           N  
ATOM   1083  N   GLN A 181       3.659  51.261   6.141  1.00 17.12           N  
ATOM   1084  CA  GLN A 181       3.268  52.658   6.061  1.00 13.12           C  
ATOM   1085  C   GLN A 181       4.466  53.588   6.263  1.00 15.43           C  
ATOM   1086  O   GLN A 181       4.555  54.628   5.615  1.00 18.95           O  
ATOM   1087  CB  GLN A 181       2.193  52.963   7.115  1.00 16.43           C  
ATOM   1088  CG  GLN A 181       0.796  52.440   6.797  1.00 19.29           C  
ATOM   1089  CD  GLN A 181       0.335  52.824   5.400  1.00 23.72           C  
ATOM   1090  OE1 GLN A 181       0.571  52.086   4.444  1.00 35.94           O  
ATOM   1091  NE2 GLN A 181      -0.309  53.983   5.273  1.00 18.61           N  
ATOM   1092  N   ALA A 182       5.379  53.222   7.162  1.00 18.66           N  
ATOM   1093  CA  ALA A 182       6.565  54.045   7.421  1.00 19.63           C  
ATOM   1094  C   ALA A 182       7.454  54.080   6.178  1.00 19.98           C  
ATOM   1095  O   ALA A 182       8.014  55.125   5.815  1.00 17.32           O  
ATOM   1096  CB  ALA A 182       7.343  53.486   8.607  1.00  7.19           C  
ATOM   1097  N   ILE A 183       7.575  52.918   5.540  1.00 18.17           N  
ATOM   1098  CA  ILE A 183       8.373  52.762   4.324  1.00 14.21           C  
ATOM   1099  C   ILE A 183       7.730  53.513   3.169  1.00 17.27           C  
ATOM   1100  O   ILE A 183       8.420  54.124   2.350  1.00 15.10           O  
ATOM   1101  CB  ILE A 183       8.499  51.285   3.914  1.00  6.00           C  
ATOM   1102  CG1 ILE A 183       9.335  50.517   4.951  1.00  8.16           C  
ATOM   1103  CG2 ILE A 183       9.105  51.201   2.544  1.00  7.40           C  
ATOM   1104  CD1 ILE A 183       9.146  49.000   4.907  1.00 15.07           C  
ATOM   1105  N   GLY A 184       6.403  53.456   3.104  1.00 16.82           N  
ATOM   1106  CA  GLY A 184       5.688  54.153   2.050  1.00 13.74           C  
ATOM   1107  C   GLY A 184       5.756  55.643   2.291  1.00 13.35           C  
ATOM   1108  O   GLY A 184       5.310  56.429   1.463  1.00 11.63           O  
ATOM   1109  N   GLN A 185       6.301  56.027   3.441  1.00 16.91           N  
ATOM   1110  CA  GLN A 185       6.419  57.434   3.758  1.00 16.71           C  
ATOM   1111  C   GLN A 185       7.852  57.905   3.676  1.00 16.24           C  
ATOM   1112  O   GLN A 185       8.197  58.962   4.202  1.00 23.21           O  
ATOM   1113  CB  GLN A 185       5.849  57.735   5.138  1.00 23.45           C  
ATOM   1114  CG  GLN A 185       4.384  57.409   5.259  1.00 28.87           C  
ATOM   1115  CD  GLN A 185       3.552  58.145   4.250  1.00 34.40           C  
ATOM   1116  OE1 GLN A 185       3.490  59.376   4.273  1.00 50.55           O  
ATOM   1117  NE2 GLN A 185       2.905  57.403   3.348  1.00 38.58           N  
ATOM   1118  N   GLY A 186       8.690  57.119   3.015  1.00 17.51           N  
ATOM   1119  CA  GLY A 186      10.079  57.513   2.845  1.00 21.80           C  
ATOM   1120  C   GLY A 186      11.038  57.139   3.954  1.00 23.01           C  
ATOM   1121  O   GLY A 186      12.096  57.754   4.121  1.00 25.40           O  
ATOM   1122  N   ALA A 187      10.673  56.134   4.731  1.00 15.99           N  
ATOM   1123  CA  ALA A 187      11.552  55.697   5.803  1.00 21.90           C  
ATOM   1124  C   ALA A 187      12.615  54.794   5.189  1.00 18.78           C  
ATOM   1125  O   ALA A 187      12.289  53.892   4.412  1.00 22.97           O  
ATOM   1126  CB  ALA A 187      10.763  54.931   6.861  1.00  7.55           C  
ATOM   1127  N   GLY A 188      13.876  55.053   5.511  1.00 12.38           N  
ATOM   1128  CA  GLY A 188      14.932  54.215   4.991  1.00 13.58           C  
ATOM   1129  C   GLY A 188      14.733  52.854   5.625  1.00 15.73           C  
ATOM   1130  O   GLY A 188      14.250  52.774   6.754  1.00 21.99           O  
ATOM   1131  N   LEU A 189      15.081  51.784   4.926  1.00 13.72           N  
ATOM   1132  CA  LEU A 189      14.904  50.456   5.487  1.00 19.32           C  
ATOM   1133  C   LEU A 189      16.145  49.605   5.329  1.00 19.88           C  
ATOM   1134  O   LEU A 189      16.717  49.504   4.248  1.00 22.24           O  
ATOM   1135  CB  LEU A 189      13.714  49.760   4.827  1.00 23.29           C  
ATOM   1136  CG  LEU A 189      13.235  48.382   5.328  1.00 26.70           C  
ATOM   1137  CD1 LEU A 189      14.146  47.281   4.828  1.00 35.65           C  
ATOM   1138  CD2 LEU A 189      13.142  48.382   6.838  1.00 21.16           C  
ATOM   1139  N   LEU A 190      16.559  48.995   6.426  1.00 22.26           N  
ATOM   1140  CA  LEU A 190      17.730  48.143   6.415  1.00 18.90           C  
ATOM   1141  C   LEU A 190      17.361  46.879   7.187  1.00 16.81           C  
ATOM   1142  O   LEU A 190      17.078  46.937   8.381  1.00 29.94           O  
ATOM   1143  CB  LEU A 190      18.887  48.877   7.087  1.00 17.50           C  
ATOM   1144  CG  LEU A 190      20.245  48.851   6.400  1.00 26.04           C  
ATOM   1145  CD1 LEU A 190      20.128  49.293   4.947  1.00 18.40           C  
ATOM   1146  CD2 LEU A 190      21.190  49.772   7.163  1.00 16.65           C  
ATOM   1147  N   LEU A 191      17.334  45.745   6.504  1.00 15.91           N  
ATOM   1148  CA  LEU A 191      16.994  44.487   7.150  1.00 10.47           C  
ATOM   1149  C   LEU A 191      18.233  43.615   7.283  1.00 16.27           C  
ATOM   1150  O   LEU A 191      19.304  43.971   6.791  1.00 20.44           O  
ATOM   1151  CB  LEU A 191      15.932  43.746   6.339  1.00  5.25           C  
ATOM   1152  CG  LEU A 191      14.636  44.514   6.095  1.00 12.38           C  
ATOM   1153  CD1 LEU A 191      13.752  43.743   5.128  1.00 19.88           C  
ATOM   1154  CD2 LEU A 191      13.911  44.745   7.410  1.00 13.76           C  
ATOM   1155  N   ASN A 192      18.072  42.475   7.947  1.00 18.82           N  
ATOM   1156  CA  ASN A 192      19.160  41.529   8.155  1.00 18.59           C  
ATOM   1157  C   ASN A 192      20.465  42.240   8.505  1.00 21.77           C  
ATOM   1158  O   ASN A 192      21.538  41.881   8.020  1.00 27.73           O  
ATOM   1159  CB  ASN A 192      19.334  40.672   6.900  1.00 13.83           C  
ATOM   1160  CG  ASN A 192      18.006  40.101   6.395  1.00 19.66           C  
ATOM   1161  OD1 ASN A 192      17.420  40.597   5.424  1.00 12.69           O  
ATOM   1162  ND2 ASN A 192      17.522  39.064   7.066  1.00 16.34           N  
ATOM   1163  N   THR A 193      20.351  43.250   9.361  1.00 22.11           N  
ATOM   1164  CA  THR A 193      21.487  44.053   9.795  1.00 21.06           C  
ATOM   1165  C   THR A 193      21.471  44.265  11.313  1.00 28.40           C  
ATOM   1166  O   THR A 193      20.483  44.742  11.894  1.00 22.77           O  
ATOM   1167  CB  THR A 193      21.448  45.425   9.122  1.00 19.67           C  
ATOM   1168  OG1 THR A 193      21.048  45.269   7.759  1.00 22.61           O  
ATOM   1169  CG2 THR A 193      22.801  46.083   9.168  1.00 21.87           C  
ATOM   1170  N   ARG A 194      22.574  43.916  11.955  1.00 25.28           N  
ATOM   1171  CA  ARG A 194      22.689  44.080  13.389  1.00 13.00           C  
ATOM   1172  C   ARG A 194      23.316  45.437  13.647  1.00 16.95           C  
ATOM   1173  O   ARG A 194      24.373  45.758  13.113  1.00 22.58           O  
ATOM   1174  CB  ARG A 194      23.549  42.961  13.977  1.00 16.08           C  
ATOM   1175  CG  ARG A 194      23.728  43.019  15.486  1.00 16.58           C  
ATOM   1176  CD  ARG A 194      24.449  41.776  15.994  1.00 22.80           C  
ATOM   1177  NE  ARG A 194      25.801  41.631  15.445  1.00 29.80           N  
ATOM   1178  CZ  ARG A 194      26.832  42.416  15.753  1.00 32.68           C  
ATOM   1179  NH1 ARG A 194      26.674  43.416  16.609  1.00 34.54           N  
ATOM   1180  NH2 ARG A 194      28.030  42.200  15.214  1.00 34.54           N  
ATOM   1181  N   ALA A 195      22.637  46.243  14.448  1.00 20.66           N  
ATOM   1182  CA  ALA A 195      23.131  47.558  14.776  1.00 17.48           C  
ATOM   1183  C   ALA A 195      23.908  47.480  16.094  1.00 24.31           C  
ATOM   1184  O   ALA A 195      23.542  46.734  17.006  1.00 25.78           O  
ATOM   1185  CB  ALA A 195      21.963  48.535  14.889  1.00 10.63           C  
ATOM   1186  N   GLU A 196      24.989  48.252  16.164  1.00 28.50           N  
ATOM   1187  CA  GLU A 196      25.855  48.336  17.331  1.00 22.10           C  
ATOM   1188  C   GLU A 196      26.005  49.826  17.615  1.00 23.28           C  
ATOM   1189  O   GLU A 196      26.361  50.592  16.718  1.00 19.75           O  
ATOM   1190  CB  GLU A 196      27.219  47.751  17.006  1.00 28.34           C  
ATOM   1191  CG  GLU A 196      28.232  47.894  18.116  1.00 35.85           C  
ATOM   1192  CD  GLU A 196      29.650  47.698  17.627  1.00 36.24           C  
ATOM   1193  OE1 GLU A 196      29.868  46.803  16.783  1.00 41.74           O  
ATOM   1194  OE2 GLU A 196      30.549  48.431  18.094  1.00 44.98           O  
ATOM   1195  N   LEU A 197      25.740  50.237  18.852  1.00 21.08           N  
ATOM   1196  CA  LEU A 197      25.838  51.647  19.205  1.00 25.95           C  
ATOM   1197  C   LEU A 197      27.267  52.126  19.436  1.00 26.88           C  
ATOM   1198  O   LEU A 197      28.022  51.535  20.202  1.00 29.35           O  
ATOM   1199  CB  LEU A 197      24.994  51.949  20.452  1.00 23.96           C  
ATOM   1200  CG  LEU A 197      23.476  51.760  20.376  1.00 15.80           C  
ATOM   1201  CD1 LEU A 197      22.886  52.047  21.742  1.00 29.19           C  
ATOM   1202  CD2 LEU A 197      22.862  52.685  19.345  1.00 17.03           C  
ATOM   1203  N   VAL A 198      27.638  53.200  18.755  1.00 23.95           N  
ATOM   1204  CA  VAL A 198      28.964  53.762  18.920  1.00 22.92           C  
ATOM   1205  C   VAL A 198      28.803  55.243  19.244  1.00 31.14           C  
ATOM   1206  O   VAL A 198      27.777  55.856  18.939  1.00 33.25           O  
ATOM   1207  CB  VAL A 198      29.835  53.612  17.634  1.00 23.06           C  
ATOM   1208  CG1 VAL A 198      30.094  52.150  17.352  1.00 14.18           C  
ATOM   1209  CG2 VAL A 198      29.147  54.281  16.442  1.00 18.28           C  
ATOM   1210  N   PRO A 199      29.815  55.839  19.875  1.00 28.97           N  
ATOM   1211  CA  PRO A 199      29.714  57.258  20.209  1.00 28.65           C  
ATOM   1212  C   PRO A 199      29.424  58.082  18.968  1.00 28.80           C  
ATOM   1213  O   PRO A 199      30.236  58.135  18.042  1.00 30.79           O  
ATOM   1214  CB  PRO A 199      31.077  57.562  20.821  1.00 31.06           C  
ATOM   1215  CG  PRO A 199      31.986  56.578  20.123  1.00 32.69           C  
ATOM   1216  CD  PRO A 199      31.157  55.322  20.180  1.00 31.53           C  
ATOM   1217  N   GLY A 200      28.240  58.690  18.937  1.00 34.06           N  
ATOM   1218  CA  GLY A 200      27.857  59.531  17.809  1.00 33.14           C  
ATOM   1219  C   GLY A 200      26.925  58.933  16.764  1.00 37.52           C  
ATOM   1220  O   GLY A 200      26.071  59.630  16.202  1.00 33.97           O  
ATOM   1221  N   GLY A 201      27.081  57.641  16.494  1.00 36.45           N  
ATOM   1222  CA  GLY A 201      26.240  57.006  15.498  1.00 31.46           C  
ATOM   1223  C   GLY A 201      26.006  55.519  15.694  1.00 27.04           C  
ATOM   1224  O   GLY A 201      25.916  55.019  16.821  1.00 28.38           O  
ATOM   1225  N   VAL A 202      25.911  54.804  14.583  1.00 19.04           N  
ATOM   1226  CA  VAL A 202      25.669  53.377  14.629  1.00 17.52           C  
ATOM   1227  C   VAL A 202      26.625  52.638  13.707  1.00 18.62           C  
ATOM   1228  O   VAL A 202      27.116  53.198  12.728  1.00 22.39           O  
ATOM   1229  CB  VAL A 202      24.215  53.075  14.213  1.00 16.05           C  
ATOM   1230  CG1 VAL A 202      23.890  51.617  14.444  1.00  9.89           C  
ATOM   1231  CG2 VAL A 202      23.264  53.975  14.993  1.00 18.85           C  
ATOM   1232  N   ARG A 203      26.915  51.389  14.052  1.00 20.99           N  
ATOM   1233  CA  ARG A 203      27.784  50.548  13.245  1.00 16.71           C  
ATOM   1234  C   ARG A 203      26.880  49.424  12.763  1.00 21.35           C  
ATOM   1235  O   ARG A 203      26.248  48.739  13.562  1.00 25.10           O  
ATOM   1236  CB  ARG A 203      28.933  49.989  14.082  1.00 23.75           C  
ATOM   1237  CG  ARG A 203      29.866  49.061  13.312  1.00 35.03           C  
ATOM   1238  CD  ARG A 203      30.922  48.435  14.227  1.00 45.81           C  
ATOM   1239  NE  ARG A 203      31.690  49.437  14.966  1.00 47.30           N  
ATOM   1240  CZ  ARG A 203      32.457  50.366  14.404  1.00 50.91           C  
ATOM   1241  NH1 ARG A 203      32.566  50.430  13.080  1.00 48.31           N  
ATOM   1242  NH2 ARG A 203      33.112  51.233  15.168  1.00 43.56           N  
ATOM   1243  N   LEU A 204      26.815  49.252  11.449  1.00 22.89           N  
ATOM   1244  CA  LEU A 204      25.965  48.242  10.838  1.00 19.58           C  
ATOM   1245  C   LEU A 204      26.732  47.023  10.354  1.00 24.01           C  
ATOM   1246  O   LEU A 204      27.652  47.142   9.547  1.00 29.10           O  
ATOM   1247  CB  LEU A 204      25.231  48.869   9.661  1.00 16.04           C  
ATOM   1248  CG  LEU A 204      24.543  50.183  10.008  1.00 15.79           C  
ATOM   1249  CD1 LEU A 204      24.092  50.871   8.739  1.00 16.74           C  
ATOM   1250  CD2 LEU A 204      23.373  49.917  10.951  1.00  7.75           C  
ATOM   1251  N   HIS A 205      26.336  45.849  10.835  1.00 25.94           N  
ATOM   1252  CA  HIS A 205      26.977  44.604  10.424  1.00 25.94           C  
ATOM   1253  C   HIS A 205      26.041  43.827   9.504  1.00 28.58           C  
ATOM   1254  O   HIS A 205      24.841  43.767   9.759  1.00 23.87           O  
ATOM   1255  CB  HIS A 205      27.319  43.745  11.645  1.00 17.83           C  
ATOM   1256  CG  HIS A 205      28.169  44.450  12.652  1.00 28.52           C  
ATOM   1257  ND1 HIS A 205      27.667  45.409  13.505  1.00 24.79           N  
ATOM   1258  CD2 HIS A 205      29.499  44.387  12.899  1.00 31.41           C  
ATOM   1259  CE1 HIS A 205      28.650  45.909  14.230  1.00 31.74           C  
ATOM   1260  NE2 HIS A 205      29.773  45.308  13.880  1.00 30.82           N  
ATOM   1261  N   ARG A 206      26.596  43.246   8.436  1.00 36.51           N  
ATOM   1262  CA  ARG A 206      25.833  42.442   7.471  1.00 41.86           C  
ATOM   1263  C   ARG A 206      26.614  41.190   7.082  1.00 44.99           C  
ATOM   1264  O   ARG A 206      27.580  40.811   7.752  1.00 44.49           O  
ATOM   1265  CB  ARG A 206      25.520  43.247   6.198  1.00 42.80           C  
ATOM   1266  CG  ARG A 206      24.824  44.576   6.479  1.00 58.98           C  
ATOM   1267  CD  ARG A 206      24.182  45.271   5.273  1.00 61.65           C  
ATOM   1268  NE  ARG A 206      25.094  46.081   4.524  1.00 62.47           N  
ATOM   1269  CZ  ARG A 206      25.157  47.385   4.271  1.00 52.70           C  
ATOM   1270  NH1 ARG A 206      24.315  48.322   4.697  1.00 49.21           N  
ATOM   1271  NH2 ARG A 206      26.166  47.717   3.496  1.00 44.62           N  
ATOM   1272  N   LEU A 207      26.178  40.559   5.992  1.00 48.91           N  
ATOM   1273  CA  LEU A 207      26.799  39.345   5.447  1.00 49.21           C  
ATOM   1274  C   LEU A 207      26.504  39.254   3.948  1.00 49.54           C  
ATOM   1275  O   LEU A 207      25.343  39.248   3.545  1.00 51.69           O  
ATOM   1276  CB  LEU A 207      26.256  38.088   6.151  1.00 48.47           C  
ATOM   1277  CG  LEU A 207      26.604  37.910   7.637  1.00 56.29           C  
ATOM   1278  CD1 LEU A 207      25.924  36.665   8.202  1.00 52.93           C  
ATOM   1279  CD2 LEU A 207      28.110  37.806   7.788  1.00 52.34           C  
ATOM   1280  N   THR A 208      27.558  39.185   3.132  1.00 52.51           N  
ATOM   1281  CA  THR A 208      27.421  39.098   1.676  1.00 58.98           C  
ATOM   1282  C   THR A 208      27.400  37.650   1.187  1.00 61.30           C  
ATOM   1283  O   THR A 208      28.128  36.799   1.698  1.00 66.28           O  
ATOM   1284  CB  THR A 208      28.579  39.838   0.951  1.00 60.61           C  
ATOM   1285  OG1 THR A 208      28.411  39.733  -0.471  1.00 63.81           O  
ATOM   1286  CG2 THR A 208      29.923  39.238   1.337  1.00 55.34           C  
ATOM   1287  N   VAL A 216      31.412  34.937   1.264  1.00 58.69           N  
ATOM   1288  CA  VAL A 216      30.819  35.205   2.570  1.00 63.39           C  
ATOM   1289  C   VAL A 216      31.782  35.968   3.463  1.00 66.20           C  
ATOM   1290  O   VAL A 216      32.867  35.480   3.776  1.00 66.93           O  
ATOM   1291  CB  VAL A 216      30.442  33.902   3.301  1.00 62.06           C  
ATOM   1292  CG1 VAL A 216      29.749  34.226   4.611  1.00 55.48           C  
ATOM   1293  CG2 VAL A 216      29.555  33.046   2.420  1.00 69.11           C  
ATOM   1294  N   VAL A 217      31.375  37.163   3.879  1.00 69.93           N  
ATOM   1295  CA  VAL A 217      32.205  37.992   4.742  1.00 69.29           C  
ATOM   1296  C   VAL A 217      31.386  39.111   5.384  1.00 67.55           C  
ATOM   1297  O   VAL A 217      30.412  39.591   4.802  1.00 62.57           O  
ATOM   1298  CB  VAL A 217      33.364  38.620   3.943  1.00 70.09           C  
ATOM   1299  CG1 VAL A 217      32.811  39.564   2.883  1.00 69.06           C  
ATOM   1300  CG2 VAL A 217      34.307  39.355   4.886  1.00 72.08           C  
ATOM   1301  N   HIS A 218      31.790  39.520   6.586  1.00 67.48           N  
ATOM   1302  CA  HIS A 218      31.109  40.590   7.312  1.00 68.80           C  
ATOM   1303  C   HIS A 218      31.270  41.934   6.604  1.00 68.87           C  
ATOM   1304  O   HIS A 218      32.177  42.113   5.790  1.00 74.95           O  
ATOM   1305  CB  HIS A 218      31.655  40.699   8.746  1.00 70.29           C  
ATOM   1306  CG  HIS A 218      33.133  40.948   8.823  1.00 73.55           C  
ATOM   1307  ND1 HIS A 218      33.757  41.346   9.985  1.00 76.63           N  
ATOM   1308  CD2 HIS A 218      34.112  40.834   7.892  1.00 75.31           C  
ATOM   1309  CE1 HIS A 218      35.056  41.468   9.769  1.00 74.49           C  
ATOM   1310  NE2 HIS A 218      35.297  41.162   8.507  1.00 76.39           N  
ATOM   1311  N   GLU A 219      30.385  42.876   6.908  1.00 65.12           N  
ATOM   1312  CA  GLU A 219      30.455  44.201   6.310  1.00 60.81           C  
ATOM   1313  C   GLU A 219      30.055  45.271   7.315  1.00 59.87           C  
ATOM   1314  O   GLU A 219      28.878  45.603   7.462  1.00 61.06           O  
ATOM   1315  CB  GLU A 219      29.555  44.294   5.077  1.00 61.27           C  
ATOM   1316  CG  GLU A 219      30.142  43.674   3.819  1.00 65.59           C  
ATOM   1317  CD  GLU A 219      29.272  43.919   2.588  1.00 65.16           C  
ATOM   1318  OE1 GLU A 219      28.877  45.087   2.370  1.00 68.16           O  
ATOM   1319  OE2 GLU A 219      28.991  42.951   1.842  1.00 55.15           O  
ATOM   1320  N   THR A 220      31.052  45.797   8.013  1.00 57.08           N  
ATOM   1321  CA  THR A 220      30.842  46.837   9.003  1.00 51.30           C  
ATOM   1322  C   THR A 220      30.704  48.172   8.286  1.00 49.80           C  
ATOM   1323  O   THR A 220      31.433  48.452   7.339  1.00 53.47           O  
ATOM   1324  CB  THR A 220      32.022  46.893   9.971  1.00 51.19           C  
ATOM   1325  OG1 THR A 220      32.013  45.717  10.790  1.00 48.79           O  
ATOM   1326  CG2 THR A 220      31.948  48.137  10.839  1.00 58.11           C  
ATOM   1327  N   ARG A 221      29.770  48.996   8.741  1.00 47.20           N  
ATOM   1328  CA  ARG A 221      29.537  50.290   8.115  1.00 45.51           C  
ATOM   1329  C   ARG A 221      28.948  51.261   9.128  1.00 45.68           C  
ATOM   1330  O   ARG A 221      27.837  51.058   9.611  1.00 56.22           O  
ATOM   1331  CB  ARG A 221      28.572  50.116   6.936  1.00 41.62           C  
ATOM   1332  CG  ARG A 221      27.973  51.411   6.404  1.00 49.21           C  
ATOM   1333  CD  ARG A 221      26.775  51.146   5.485  1.00 45.95           C  
ATOM   1334  NE  ARG A 221      26.032  52.378   5.214  1.00 51.07           N  
ATOM   1335  CZ  ARG A 221      24.814  52.424   4.683  1.00 51.80           C  
ATOM   1336  NH1 ARG A 221      24.226  53.595   4.477  1.00 49.46           N  
ATOM   1337  NH2 ARG A 221      24.183  51.302   4.361  1.00 51.32           N  
ATOM   1338  N   GLN A 222      29.687  52.313   9.455  1.00 43.45           N  
ATOM   1339  CA  GLN A 222      29.188  53.294  10.407  1.00 42.45           C  
ATOM   1340  C   GLN A 222      28.362  54.375   9.721  1.00 42.05           C  
ATOM   1341  O   GLN A 222      28.485  54.598   8.512  1.00 43.83           O  
ATOM   1342  CB  GLN A 222      30.342  53.948  11.164  1.00 41.23           C  
ATOM   1343  CG  GLN A 222      31.108  53.008  12.062  1.00 43.15           C  
ATOM   1344  CD  GLN A 222      31.805  53.746  13.178  1.00 51.08           C  
ATOM   1345  OE1 GLN A 222      32.617  54.642  12.937  1.00 56.32           O  
ATOM   1346  NE2 GLN A 222      31.490  53.378  14.412  1.00 56.32           N  
ATOM   1347  N   ILE A 223      27.516  55.039  10.508  1.00 39.77           N  
ATOM   1348  CA  ILE A 223      26.656  56.117  10.023  1.00 34.17           C  
ATOM   1349  C   ILE A 223      26.340  57.088  11.168  1.00 33.43           C  
ATOM   1350  O   ILE A 223      26.048  56.661  12.282  1.00 34.32           O  
ATOM   1351  CB  ILE A 223      25.307  55.569   9.463  1.00 32.24           C  
ATOM   1352  CG1 ILE A 223      24.606  54.698  10.510  1.00 39.97           C  
ATOM   1353  CG2 ILE A 223      25.548  54.775   8.193  1.00 39.49           C  
ATOM   1354  CD1 ILE A 223      23.296  54.067  10.031  1.00 36.13           C  
ATOM   1355  N   ARG A 224      26.422  58.392  10.903  1.00 32.45           N  
ATOM   1356  CA  ARG A 224      26.103  59.379  11.927  1.00 29.08           C  
ATOM   1357  C   ARG A 224      24.586  59.484  12.044  1.00 30.01           C  
ATOM   1358  O   ARG A 224      23.854  59.225  11.079  1.00 23.00           O  
ATOM   1359  CB  ARG A 224      26.653  60.767  11.585  1.00 30.10           C  
ATOM   1360  CG  ARG A 224      28.148  60.954  11.803  1.00 38.87           C  
ATOM   1361  CD  ARG A 224      28.534  62.428  11.611  1.00 45.16           C  
ATOM   1362  NE  ARG A 224      28.201  62.897  10.268  1.00 52.00           N  
ATOM   1363  CZ  ARG A 224      28.831  62.507   9.163  1.00 59.37           C  
ATOM   1364  NH1 ARG A 224      29.839  61.646   9.249  1.00 60.67           N  
ATOM   1365  NH2 ARG A 224      28.442  62.964   7.973  1.00 48.30           N  
ATOM   1366  N   ALA A 225      24.137  59.886  13.230  1.00 23.15           N  
ATOM   1367  CA  ALA A 225      22.728  60.037  13.534  1.00 27.30           C  
ATOM   1368  C   ALA A 225      22.538  61.078  14.630  1.00 23.30           C  
ATOM   1369  O   ALA A 225      23.252  61.065  15.629  1.00 24.12           O  
ATOM   1370  CB  ALA A 225      22.161  58.706  13.989  1.00 28.16           C  
ATOM   1371  N   GLY A 226      21.584  61.985  14.442  1.00 25.83           N  
ATOM   1372  CA  GLY A 226      21.329  62.999  15.455  1.00 25.24           C  
ATOM   1373  C   GLY A 226      20.500  62.428  16.591  1.00 30.85           C  
ATOM   1374  O   GLY A 226      20.617  62.851  17.743  1.00 31.70           O  
ATOM   1375  N   VAL A 227      19.651  61.461  16.258  1.00 20.93           N  
ATOM   1376  CA  VAL A 227      18.805  60.824  17.251  1.00 23.77           C  
ATOM   1377  C   VAL A 227      18.749  59.329  16.992  1.00 24.64           C  
ATOM   1378  O   VAL A 227      18.554  58.899  15.856  1.00 28.65           O  
ATOM   1379  CB  VAL A 227      17.354  61.381  17.226  1.00 31.22           C  
ATOM   1380  CG1 VAL A 227      16.559  60.784  18.380  1.00 30.45           C  
ATOM   1381  CG2 VAL A 227      17.362  62.904  17.332  1.00 19.73           C  
ATOM   1382  N   ILE A 228      18.927  58.547  18.056  1.00 26.41           N  
ATOM   1383  CA  ILE A 228      18.907  57.087  17.984  1.00 19.10           C  
ATOM   1384  C   ILE A 228      17.883  56.490  18.949  1.00 17.65           C  
ATOM   1385  O   ILE A 228      18.003  56.631  20.170  1.00 11.70           O  
ATOM   1386  CB  ILE A 228      20.286  56.493  18.342  1.00 21.07           C  
ATOM   1387  CG1 ILE A 228      21.331  56.947  17.320  1.00 19.03           C  
ATOM   1388  CG2 ILE A 228      20.189  54.976  18.432  1.00 12.58           C  
ATOM   1389  CD1 ILE A 228      22.750  56.529  17.650  1.00 20.44           C  
ATOM   1390  N   ILE A 229      16.882  55.819  18.387  1.00 16.54           N  
ATOM   1391  CA  ILE A 229      15.841  55.172  19.174  1.00 13.35           C  
ATOM   1392  C   ILE A 229      16.127  53.674  19.245  1.00 13.14           C  
ATOM   1393  O   ILE A 229      16.138  52.983  18.226  1.00 14.06           O  
ATOM   1394  CB  ILE A 229      14.453  55.404  18.546  1.00 10.45           C  
ATOM   1395  CG1 ILE A 229      14.158  56.903  18.527  1.00  9.22           C  
ATOM   1396  CG2 ILE A 229      13.387  54.647  19.314  1.00  6.69           C  
ATOM   1397  CD1 ILE A 229      12.845  57.247  17.899  1.00 16.43           C  
ATOM   1398  N   VAL A 230      16.374  53.194  20.462  1.00 17.98           N  
ATOM   1399  CA  VAL A 230      16.670  51.791  20.728  1.00  4.15           C  
ATOM   1400  C   VAL A 230      15.396  51.011  21.023  1.00  9.14           C  
ATOM   1401  O   VAL A 230      14.936  50.946  22.164  1.00  7.83           O  
ATOM   1402  CB  VAL A 230      17.629  51.652  21.934  1.00  9.67           C  
ATOM   1403  CG1 VAL A 230      17.826  50.203  22.293  1.00  5.62           C  
ATOM   1404  CG2 VAL A 230      18.955  52.296  21.619  1.00  7.28           C  
ATOM   1405  N   ALA A 231      14.840  50.414  19.970  1.00 15.25           N  
ATOM   1406  CA  ALA A 231      13.617  49.614  20.050  1.00 16.52           C  
ATOM   1407  C   ALA A 231      13.952  48.151  19.783  1.00 11.96           C  
ATOM   1408  O   ALA A 231      13.243  47.486  19.036  1.00 11.82           O  
ATOM   1409  CB  ALA A 231      12.616  50.100  19.021  1.00  7.73           C  
ATOM   1410  N   ALA A 232      15.018  47.653  20.407  1.00 12.60           N  
ATOM   1411  CA  ALA A 232      15.440  46.285  20.195  1.00  3.79           C  
ATOM   1412  C   ALA A 232      14.704  45.319  21.099  1.00  8.63           C  
ATOM   1413  O   ALA A 232      15.069  44.152  21.199  1.00 14.52           O  
ATOM   1414  CB  ALA A 232      16.944  46.169  20.409  1.00  3.59           C  
ATOM   1415  N   GLY A 233      13.646  45.800  21.741  1.00 11.97           N  
ATOM   1416  CA  GLY A 233      12.894  44.951  22.643  1.00 10.16           C  
ATOM   1417  C   GLY A 233      13.764  44.548  23.823  1.00 16.92           C  
ATOM   1418  O   GLY A 233      14.561  45.343  24.321  1.00 11.38           O  
ATOM   1419  N   ALA A 234      13.616  43.300  24.253  1.00 15.81           N  
ATOM   1420  CA  ALA A 234      14.363  42.751  25.377  1.00  8.96           C  
ATOM   1421  C   ALA A 234      15.870  42.911  25.214  1.00 13.91           C  
ATOM   1422  O   ALA A 234      16.603  42.955  26.200  1.00 18.56           O  
ATOM   1423  CB  ALA A 234      14.014  41.290  25.557  1.00  7.18           C  
ATOM   1424  N   ALA A 235      16.340  43.010  23.976  1.00  8.60           N  
ATOM   1425  CA  ALA A 235      17.767  43.164  23.739  1.00  4.46           C  
ATOM   1426  C   ALA A 235      18.198  44.631  23.824  1.00  7.83           C  
ATOM   1427  O   ALA A 235      19.377  44.957  23.660  1.00 12.88           O  
ATOM   1428  CB  ALA A 235      18.138  42.575  22.362  1.00  6.44           C  
ATOM   1429  N   GLY A 236      17.246  45.517  24.095  1.00 13.70           N  
ATOM   1430  CA  GLY A 236      17.556  46.939  24.186  1.00 12.94           C  
ATOM   1431  C   GLY A 236      18.500  47.304  25.316  1.00 20.45           C  
ATOM   1432  O   GLY A 236      19.455  48.041  25.098  1.00 26.42           O  
ATOM   1433  N   PRO A 237      18.250  46.827  26.547  1.00 22.34           N  
ATOM   1434  CA  PRO A 237      19.126  47.137  27.683  1.00 19.86           C  
ATOM   1435  C   PRO A 237      20.596  46.757  27.459  1.00 16.43           C  
ATOM   1436  O   PRO A 237      21.492  47.558  27.703  1.00 17.27           O  
ATOM   1437  CB  PRO A 237      18.484  46.356  28.822  1.00 19.00           C  
ATOM   1438  CG  PRO A 237      17.016  46.498  28.498  1.00 18.53           C  
ATOM   1439  CD  PRO A 237      16.999  46.200  27.009  1.00 22.44           C  
ATOM   1440  N   ALA A 238      20.847  45.541  26.995  1.00 15.15           N  
ATOM   1441  CA  ALA A 238      22.219  45.113  26.753  1.00 14.88           C  
ATOM   1442  C   ALA A 238      22.859  45.923  25.636  1.00 17.74           C  
ATOM   1443  O   ALA A 238      24.025  46.308  25.730  1.00 18.91           O  
ATOM   1444  CB  ALA A 238      22.259  43.622  26.409  1.00 10.65           C  
ATOM   1445  N   LEU A 239      22.102  46.167  24.571  1.00 19.90           N  
ATOM   1446  CA  LEU A 239      22.607  46.935  23.442  1.00 17.40           C  
ATOM   1447  C   LEU A 239      23.349  48.182  23.910  1.00 24.55           C  
ATOM   1448  O   LEU A 239      24.517  48.383  23.569  1.00 22.69           O  
ATOM   1449  CB  LEU A 239      21.464  47.362  22.532  1.00 16.29           C  
ATOM   1450  CG  LEU A 239      21.935  48.063  21.259  1.00 15.87           C  
ATOM   1451  CD1 LEU A 239      22.654  47.048  20.365  1.00 16.76           C  
ATOM   1452  CD2 LEU A 239      20.742  48.651  20.520  1.00 17.91           C  
ATOM   1453  N   VAL A 240      22.659  49.010  24.696  1.00 22.11           N  
ATOM   1454  CA  VAL A 240      23.223  50.251  25.212  1.00 23.75           C  
ATOM   1455  C   VAL A 240      24.323  50.035  26.244  1.00 22.97           C  
ATOM   1456  O   VAL A 240      25.198  50.882  26.420  1.00 21.49           O  
ATOM   1457  CB  VAL A 240      22.135  51.126  25.847  1.00 24.00           C  
ATOM   1458  CG1 VAL A 240      21.054  51.424  24.832  1.00 15.81           C  
ATOM   1459  CG2 VAL A 240      21.566  50.428  27.058  1.00 24.01           C  
ATOM   1460  N   GLU A 241      24.271  48.900  26.926  1.00 25.12           N  
ATOM   1461  CA  GLU A 241      25.264  48.571  27.936  1.00 25.17           C  
ATOM   1462  C   GLU A 241      26.589  48.216  27.279  1.00 20.01           C  
ATOM   1463  O   GLU A 241      27.607  48.821  27.570  1.00 22.16           O  
ATOM   1464  CB  GLU A 241      24.765  47.394  28.777  1.00 27.08           C  
ATOM   1465  CG  GLU A 241      25.824  46.729  29.645  1.00 37.76           C  
ATOM   1466  CD  GLU A 241      26.332  47.630  30.754  1.00 46.72           C  
ATOM   1467  OE1 GLU A 241      25.486  48.216  31.465  1.00 48.43           O  
ATOM   1468  OE2 GLU A 241      27.573  47.742  30.923  1.00 44.41           O  
ATOM   1469  N   GLN A 242      26.570  47.246  26.374  1.00 25.67           N  
ATOM   1470  CA  GLN A 242      27.796  46.825  25.727  1.00 32.06           C  
ATOM   1471  C   GLN A 242      28.300  47.833  24.698  1.00 37.92           C  
ATOM   1472  O   GLN A 242      29.469  47.801  24.310  1.00 43.47           O  
ATOM   1473  CB  GLN A 242      27.590  45.448  25.088  1.00 35.84           C  
ATOM   1474  CG  GLN A 242      26.949  44.424  26.047  1.00 42.61           C  
ATOM   1475  CD  GLN A 242      26.607  43.091  25.376  1.00 40.98           C  
ATOM   1476  OE1 GLN A 242      25.787  42.315  25.882  1.00 31.71           O  
ATOM   1477  NE2 GLN A 242      27.238  42.820  24.238  1.00 35.97           N  
ATOM   1478  N   GLY A 243      27.427  48.743  24.275  1.00 35.14           N  
ATOM   1479  CA  GLY A 243      27.818  49.731  23.284  1.00 27.55           C  
ATOM   1480  C   GLY A 243      28.244  51.079  23.833  1.00 32.22           C  
ATOM   1481  O   GLY A 243      29.170  51.699  23.307  1.00 32.69           O  
ATOM   1482  N   LEU A 244      27.581  51.533  24.893  1.00 29.91           N  
ATOM   1483  CA  LEU A 244      27.879  52.834  25.489  1.00 32.77           C  
ATOM   1484  C   LEU A 244      28.097  52.815  27.008  1.00 32.27           C  
ATOM   1485  O   LEU A 244      28.194  53.872  27.629  1.00 35.81           O  
ATOM   1486  CB  LEU A 244      26.746  53.818  25.150  1.00 28.42           C  
ATOM   1487  CG  LEU A 244      26.570  54.199  23.673  1.00 24.32           C  
ATOM   1488  CD1 LEU A 244      25.171  54.743  23.407  1.00 25.36           C  
ATOM   1489  CD2 LEU A 244      27.621  55.218  23.298  1.00 19.34           C  
ATOM   1490  N   GLY A 245      28.167  51.631  27.609  1.00 31.21           N  
ATOM   1491  CA  GLY A 245      28.373  51.556  29.046  1.00 23.98           C  
ATOM   1492  C   GLY A 245      27.252  52.177  29.868  1.00 26.04           C  
ATOM   1493  O   GLY A 245      27.451  52.560  31.021  1.00 28.35           O  
ATOM   1494  N   LEU A 246      26.068  52.271  29.276  1.00 22.52           N  
ATOM   1495  CA  LEU A 246      24.909  52.839  29.948  1.00 23.06           C  
ATOM   1496  C   LEU A 246      24.136  51.772  30.721  1.00 28.19           C  
ATOM   1497  O   LEU A 246      23.473  50.907  30.130  1.00 18.57           O  
ATOM   1498  CB  LEU A 246      23.989  53.507  28.924  1.00 30.25           C  
ATOM   1499  CG  LEU A 246      24.648  54.588  28.053  1.00 32.55           C  
ATOM   1500  CD1 LEU A 246      23.641  55.148  27.070  1.00 24.90           C  
ATOM   1501  CD2 LEU A 246      25.196  55.690  28.943  1.00 33.64           C  
ATOM   1502  N   HIS A 247      24.223  51.849  32.048  1.00 24.92           N  
ATOM   1503  CA  HIS A 247      23.557  50.899  32.935  1.00 25.04           C  
ATOM   1504  C   HIS A 247      22.074  51.204  33.152  1.00 25.83           C  
ATOM   1505  O   HIS A 247      21.678  52.363  33.234  1.00 21.23           O  
ATOM   1506  CB  HIS A 247      24.263  50.886  34.293  1.00 26.04           C  
ATOM   1507  CG  HIS A 247      25.741  50.691  34.199  1.00 29.44           C  
ATOM   1508  ND1 HIS A 247      26.307  49.565  33.644  1.00 28.37           N  
ATOM   1509  CD2 HIS A 247      26.770  51.482  34.583  1.00 33.56           C  
ATOM   1510  CE1 HIS A 247      27.623  49.670  33.691  1.00 37.26           C  
ATOM   1511  NE2 HIS A 247      27.929  50.823  34.256  1.00 40.41           N  
ATOM   1512  N   THR A 248      21.259  50.157  33.228  1.00 23.77           N  
ATOM   1513  CA  THR A 248      19.830  50.309  33.486  1.00 27.23           C  
ATOM   1514  C   THR A 248      19.418  49.169  34.420  1.00 32.22           C  
ATOM   1515  O   THR A 248      20.184  48.225  34.640  1.00 30.02           O  
ATOM   1516  CB  THR A 248      18.961  50.237  32.187  1.00 29.86           C  
ATOM   1517  OG1 THR A 248      19.143  48.964  31.549  1.00 19.66           O  
ATOM   1518  CG2 THR A 248      19.329  51.362  31.225  1.00 28.20           C  
ATOM   1519  N   ARG A 249      18.203  49.252  34.952  1.00 32.34           N  
ATOM   1520  CA  ARG A 249      17.701  48.235  35.865  1.00 29.36           C  
ATOM   1521  C   ARG A 249      16.729  47.289  35.162  1.00 22.95           C  
ATOM   1522  O   ARG A 249      16.197  46.362  35.773  1.00 28.82           O  
ATOM   1523  CB  ARG A 249      17.006  48.911  37.056  1.00 32.77           C  
ATOM   1524  CG  ARG A 249      17.653  50.219  37.503  1.00 40.48           C  
ATOM   1525  CD  ARG A 249      17.465  50.485  39.001  1.00 32.92           C  
ATOM   1526  NE  ARG A 249      18.334  49.591  39.747  1.00 37.46           N  
ATOM   1527  CZ  ARG A 249      19.379  49.976  40.474  1.00 26.40           C  
ATOM   1528  NH1 ARG A 249      19.702  51.256  40.589  1.00 15.87           N  
ATOM   1529  NH2 ARG A 249      20.140  49.059  41.044  1.00 30.39           N  
ATOM   1530  N   HIS A 250      16.510  47.508  33.869  1.00 24.06           N  
ATOM   1531  CA  HIS A 250      15.575  46.672  33.110  1.00 22.69           C  
ATOM   1532  C   HIS A 250      15.954  45.192  33.044  1.00 19.58           C  
ATOM   1533  O   HIS A 250      17.129  44.828  33.037  1.00 23.55           O  
ATOM   1534  CB  HIS A 250      15.421  47.234  31.703  1.00 22.62           C  
ATOM   1535  CG  HIS A 250      15.104  48.692  31.683  1.00 20.94           C  
ATOM   1536  ND1 HIS A 250      15.861  49.604  30.980  1.00 24.30           N  
ATOM   1537  CD2 HIS A 250      14.129  49.403  32.296  1.00 17.75           C  
ATOM   1538  CE1 HIS A 250      15.367  50.815  31.161  1.00 19.73           C  
ATOM   1539  NE2 HIS A 250      14.315  50.722  31.955  1.00 24.05           N  
ATOM   1540  N   GLY A 251      14.940  44.341  32.989  1.00 16.56           N  
ATOM   1541  CA  GLY A 251      15.193  42.921  32.940  1.00  9.98           C  
ATOM   1542  C   GLY A 251      14.513  42.266  31.766  1.00 21.56           C  
ATOM   1543  O   GLY A 251      13.863  42.923  30.954  1.00 19.22           O  
ATOM   1544  N   ARG A 252      14.655  40.951  31.684  1.00 20.60           N  
ATOM   1545  CA  ARG A 252      14.065  40.201  30.597  1.00 24.00           C  
ATOM   1546  C   ARG A 252      13.513  38.870  31.076  1.00 22.31           C  
ATOM   1547  O   ARG A 252      14.043  38.268  32.006  1.00 33.33           O  
ATOM   1548  CB  ARG A 252      15.119  39.985  29.503  1.00 28.59           C  
ATOM   1549  CG  ARG A 252      16.459  39.461  30.011  1.00 31.23           C  
ATOM   1550  CD  ARG A 252      17.593  39.746  29.019  1.00 33.18           C  
ATOM   1551  NE  ARG A 252      17.627  38.840  27.869  1.00 35.18           N  
ATOM   1552  CZ  ARG A 252      18.109  37.601  27.903  1.00 26.53           C  
ATOM   1553  NH1 ARG A 252      18.597  37.104  29.031  1.00 30.73           N  
ATOM   1554  NH2 ARG A 252      18.125  36.865  26.802  1.00 38.27           N  
ATOM   1555  N   ALA A 253      12.431  38.422  30.455  1.00 20.00           N  
ATOM   1556  CA  ALA A 253      11.843  37.148  30.823  1.00 17.50           C  
ATOM   1557  C   ALA A 253      11.513  36.349  29.565  1.00 21.04           C  
ATOM   1558  O   ALA A 253      11.074  36.904  28.554  1.00 25.72           O  
ATOM   1559  CB  ALA A 253      10.590  37.363  31.654  1.00 16.88           C  
ATOM   1560  N   TYR A 254      11.753  35.045  29.622  1.00 17.20           N  
ATOM   1561  CA  TYR A 254      11.442  34.188  28.496  1.00 16.94           C  
ATOM   1562  C   TYR A 254      10.098  33.561  28.760  1.00 20.35           C  
ATOM   1563  O   TYR A 254       9.892  32.878  29.767  1.00 11.25           O  
ATOM   1564  CB  TYR A 254      12.463  33.081  28.324  1.00 21.60           C  
ATOM   1565  CG  TYR A 254      12.200  32.221  27.112  1.00 24.38           C  
ATOM   1566  CD1 TYR A 254      12.312  32.741  25.825  1.00 27.85           C  
ATOM   1567  CD2 TYR A 254      11.895  30.873  27.247  1.00 25.57           C  
ATOM   1568  CE1 TYR A 254      12.140  31.934  24.705  1.00 27.39           C  
ATOM   1569  CE2 TYR A 254      11.722  30.061  26.133  1.00 22.42           C  
ATOM   1570  CZ  TYR A 254      11.852  30.591  24.871  1.00 25.92           C  
ATOM   1571  OH  TYR A 254      11.761  29.764  23.781  1.00 24.36           O  
ATOM   1572  N   ARG A 255       9.183  33.791  27.830  1.00 26.38           N  
ATOM   1573  CA  ARG A 255       7.835  33.280  27.950  1.00 22.00           C  
ATOM   1574  C   ARG A 255       7.501  32.425  26.748  1.00 23.59           C  
ATOM   1575  O   ARG A 255       7.770  32.795  25.607  1.00 20.08           O  
ATOM   1576  CB  ARG A 255       6.867  34.445  28.053  1.00 21.06           C  
ATOM   1577  CG  ARG A 255       5.417  34.054  28.110  1.00 25.90           C  
ATOM   1578  CD  ARG A 255       4.570  35.293  27.892  1.00 26.24           C  
ATOM   1579  NE  ARG A 255       3.835  35.676  29.085  1.00 20.00           N  
ATOM   1580  CZ  ARG A 255       3.235  36.849  29.239  1.00 20.06           C  
ATOM   1581  NH1 ARG A 255       3.293  37.756  28.273  1.00 14.65           N  
ATOM   1582  NH2 ARG A 255       2.562  37.102  30.353  1.00 13.10           N  
ATOM   1583  N   GLN A 256       6.905  31.275  27.023  1.00 19.91           N  
ATOM   1584  CA  GLN A 256       6.523  30.340  25.985  1.00 26.89           C  
ATOM   1585  C   GLN A 256       5.030  30.491  25.711  1.00 26.54           C  
ATOM   1586  O   GLN A 256       4.285  30.949  26.573  1.00 21.24           O  
ATOM   1587  CB  GLN A 256       6.840  28.918  26.450  1.00 31.59           C  
ATOM   1588  CG  GLN A 256       8.277  28.741  26.909  1.00 30.70           C  
ATOM   1589  CD  GLN A 256       8.561  27.341  27.410  1.00 34.90           C  
ATOM   1590  OE1 GLN A 256       8.043  26.916  28.453  1.00 33.46           O  
ATOM   1591  NE2 GLN A 256       9.387  26.608  26.667  1.00 27.07           N  
ATOM   1592  N   PHE A 257       4.593  30.112  24.513  1.00 24.39           N  
ATOM   1593  CA  PHE A 257       3.183  30.226  24.167  1.00 24.01           C  
ATOM   1594  C   PHE A 257       2.614  28.921  23.617  1.00 28.59           C  
ATOM   1595  O   PHE A 257       2.110  28.874  22.485  1.00 29.30           O  
ATOM   1596  CB  PHE A 257       2.973  31.350  23.146  1.00 22.22           C  
ATOM   1597  CG  PHE A 257       3.572  32.667  23.558  1.00 17.36           C  
ATOM   1598  CD1 PHE A 257       4.937  32.903  23.409  1.00 20.36           C  
ATOM   1599  CD2 PHE A 257       2.771  33.682  24.073  1.00 12.91           C  
ATOM   1600  CE1 PHE A 257       5.495  34.134  23.760  1.00 15.67           C  
ATOM   1601  CE2 PHE A 257       3.317  34.916  24.428  1.00 12.84           C  
ATOM   1602  CZ  PHE A 257       4.683  35.144  24.269  1.00 14.98           C  
ATOM   1603  N   PRO A 258       2.673  27.840  24.411  1.00 26.27           N  
ATOM   1604  CA  PRO A 258       2.138  26.562  23.931  1.00 20.25           C  
ATOM   1605  C   PRO A 258       0.675  26.667  23.503  1.00 24.99           C  
ATOM   1606  O   PRO A 258      -0.097  27.441  24.074  1.00 26.04           O  
ATOM   1607  CB  PRO A 258       2.351  25.626  25.123  1.00 18.87           C  
ATOM   1608  CG  PRO A 258       2.344  26.546  26.301  1.00 20.02           C  
ATOM   1609  CD  PRO A 258       3.111  27.744  25.814  1.00 18.07           C  
ATOM   1610  N   ARG A 259       0.304  25.883  22.494  1.00 32.16           N  
ATOM   1611  CA  ARG A 259      -1.057  25.891  21.969  1.00 28.68           C  
ATOM   1612  C   ARG A 259      -1.977  24.823  22.558  1.00 27.64           C  
ATOM   1613  O   ARG A 259      -1.558  23.695  22.811  1.00 30.22           O  
ATOM   1614  CB  ARG A 259      -1.043  25.747  20.448  1.00 23.68           C  
ATOM   1615  CG  ARG A 259      -2.443  25.659  19.889  1.00 29.66           C  
ATOM   1616  CD  ARG A 259      -2.524  26.061  18.443  1.00 31.89           C  
ATOM   1617  NE  ARG A 259      -3.721  25.509  17.887  1.00 46.21           N  
ATOM   1618  CZ  ARG A 259      -4.798  26.037  17.316  1.00 40.46           C  
ATOM   1619  NH1 ARG A 259      -5.037  27.326  17.101  1.00 45.21           N  
ATOM   1620  NH2 ARG A 259      -5.692  25.141  16.960  1.00 38.41           N  
ATOM   1621  N   LEU A 260      -3.238  25.198  22.762  1.00 18.28           N  
ATOM   1622  CA  LEU A 260      -4.242  24.298  23.306  1.00 20.87           C  
ATOM   1623  C   LEU A 260      -5.280  24.002  22.229  1.00 26.91           C  
ATOM   1624  O   LEU A 260      -6.141  24.833  21.935  1.00 22.19           O  
ATOM   1625  CB  LEU A 260      -4.933  24.934  24.507  1.00 19.19           C  
ATOM   1626  CG  LEU A 260      -5.947  24.035  25.221  1.00 16.36           C  
ATOM   1627  CD1 LEU A 260      -5.220  22.983  26.057  1.00  9.70           C  
ATOM   1628  CD2 LEU A 260      -6.831  24.891  26.106  1.00 16.42           C  
ATOM   1629  N   ASP A 261      -5.204  22.809  21.649  1.00 26.02           N  
ATOM   1630  CA  ASP A 261      -6.121  22.433  20.590  1.00 25.61           C  
ATOM   1631  C   ASP A 261      -7.493  21.990  21.067  1.00 26.24           C  
ATOM   1632  O   ASP A 261      -7.801  20.803  21.077  1.00 30.16           O  
ATOM   1633  CB  ASP A 261      -5.493  21.339  19.730  1.00 30.47           C  
ATOM   1634  CG  ASP A 261      -4.273  21.826  18.976  1.00 29.22           C  
ATOM   1635  OD1 ASP A 261      -4.417  22.712  18.112  1.00 30.01           O  
ATOM   1636  OD2 ASP A 261      -3.166  21.330  19.248  1.00 38.18           O  
ATOM   1637  N   LEU A 262      -8.308  22.952  21.476  1.00 23.78           N  
ATOM   1638  CA  LEU A 262      -9.664  22.665  21.917  1.00 27.09           C  
ATOM   1639  C   LEU A 262     -10.594  23.676  21.255  1.00 30.68           C  
ATOM   1640  O   LEU A 262     -10.238  24.846  21.100  1.00 28.33           O  
ATOM   1641  CB  LEU A 262      -9.765  22.739  23.438  1.00 19.52           C  
ATOM   1642  CG  LEU A 262      -9.141  21.541  24.158  1.00 28.43           C  
ATOM   1643  CD1 LEU A 262      -9.134  21.775  25.645  1.00 31.34           C  
ATOM   1644  CD2 LEU A 262      -9.929  20.286  23.826  1.00 28.55           C  
ATOM   1645  N   LEU A 263     -11.774  23.207  20.855  1.00 26.73           N  
ATOM   1646  CA  LEU A 263     -12.769  24.028  20.174  1.00 34.12           C  
ATOM   1647  C   LEU A 263     -12.764  25.495  20.564  1.00 35.57           C  
ATOM   1648  O   LEU A 263     -12.875  25.835  21.737  1.00 42.41           O  
ATOM   1649  CB  LEU A 263     -14.173  23.467  20.402  1.00 35.48           C  
ATOM   1650  CG  LEU A 263     -15.285  24.143  19.593  1.00 42.40           C  
ATOM   1651  CD1 LEU A 263     -14.979  23.993  18.108  1.00 40.53           C  
ATOM   1652  CD2 LEU A 263     -16.646  23.494  19.911  1.00 48.73           C  
ATOM   1653  N   SER A 264     -12.640  26.365  19.571  1.00 33.68           N  
ATOM   1654  CA  SER A 264     -12.649  27.791  19.825  1.00 32.96           C  
ATOM   1655  C   SER A 264     -13.413  28.510  18.730  1.00 32.86           C  
ATOM   1656  O   SER A 264     -13.493  28.032  17.598  1.00 29.58           O  
ATOM   1657  CB  SER A 264     -11.227  28.329  19.893  1.00 39.16           C  
ATOM   1658  OG  SER A 264     -11.240  29.742  19.921  1.00 38.71           O  
ATOM   1659  N   GLY A 265     -13.972  29.668  19.071  1.00 34.41           N  
ATOM   1660  CA  GLY A 265     -14.728  30.435  18.098  1.00 33.11           C  
ATOM   1661  C   GLY A 265     -14.205  31.840  17.889  1.00 32.35           C  
ATOM   1662  O   GLY A 265     -13.345  32.313  18.627  1.00 30.12           O  
ATOM   1663  N   ALA A 266     -14.728  32.518  16.874  1.00 37.42           N  
ATOM   1664  CA  ALA A 266     -14.292  33.878  16.570  1.00 41.72           C  
ATOM   1665  C   ALA A 266     -14.787  34.864  17.617  1.00 42.91           C  
ATOM   1666  O   ALA A 266     -14.262  35.969  17.743  1.00 39.95           O  
ATOM   1667  CB  ALA A 266     -14.797  34.292  15.194  1.00 41.57           C  
ATOM   1668  N   GLN A 267     -15.799  34.458  18.370  1.00 38.90           N  
ATOM   1669  CA  GLN A 267     -16.357  35.330  19.377  1.00 41.33           C  
ATOM   1670  C   GLN A 267     -16.266  34.766  20.789  1.00 43.31           C  
ATOM   1671  O   GLN A 267     -16.854  35.317  21.723  1.00 43.50           O  
ATOM   1672  CB  GLN A 267     -17.799  35.648  19.009  1.00 46.56           C  
ATOM   1673  CG  GLN A 267     -18.582  34.446  18.550  1.00 51.67           C  
ATOM   1674  CD  GLN A 267     -19.825  34.840  17.774  1.00 61.62           C  
ATOM   1675  OE1 GLN A 267     -20.697  34.005  17.511  1.00 67.67           O  
ATOM   1676  NE2 GLN A 267     -19.913  36.120  17.397  1.00 51.02           N  
ATOM   1677  N   THR A 268     -15.528  33.668  20.944  1.00 41.51           N  
ATOM   1678  CA  THR A 268     -15.348  33.069  22.261  1.00 36.84           C  
ATOM   1679  C   THR A 268     -14.415  33.994  23.032  1.00 29.84           C  
ATOM   1680  O   THR A 268     -13.311  34.310  22.584  1.00 28.65           O  
ATOM   1681  CB  THR A 268     -14.751  31.632  22.184  1.00 34.32           C  
ATOM   1682  OG1 THR A 268     -14.337  31.217  23.490  1.00 40.18           O  
ATOM   1683  CG2 THR A 268     -13.572  31.579  21.255  1.00 42.47           C  
ATOM   1684  N   PRO A 269     -14.862  34.452  24.204  1.00 31.25           N  
ATOM   1685  CA  PRO A 269     -14.092  35.359  25.064  1.00 30.89           C  
ATOM   1686  C   PRO A 269     -12.710  34.887  25.517  1.00 26.15           C  
ATOM   1687  O   PRO A 269     -12.418  33.692  25.539  1.00 25.21           O  
ATOM   1688  CB  PRO A 269     -15.046  35.617  26.235  1.00 30.87           C  
ATOM   1689  CG  PRO A 269     -15.895  34.381  26.279  1.00 31.02           C  
ATOM   1690  CD  PRO A 269     -16.140  34.070  24.832  1.00 25.40           C  
ATOM   1691  N   VAL A 270     -11.855  35.855  25.839  1.00 18.19           N  
ATOM   1692  CA  VAL A 270     -10.514  35.568  26.329  1.00 17.98           C  
ATOM   1693  C   VAL A 270     -10.729  35.200  27.795  1.00 16.50           C  
ATOM   1694  O   VAL A 270     -11.559  35.807  28.471  1.00 22.81           O  
ATOM   1695  CB  VAL A 270      -9.591  36.821  26.249  1.00 14.87           C  
ATOM   1696  CG1 VAL A 270      -8.235  36.518  26.855  1.00  8.15           C  
ATOM   1697  CG2 VAL A 270      -9.426  37.259  24.801  1.00 16.00           C  
ATOM   1698  N   LEU A 271     -10.003  34.202  28.281  1.00 18.72           N  
ATOM   1699  CA  LEU A 271     -10.143  33.767  29.665  1.00 14.31           C  
ATOM   1700  C   LEU A 271      -8.808  33.855  30.373  1.00 15.80           C  
ATOM   1701  O   LEU A 271      -7.757  33.649  29.765  1.00 20.94           O  
ATOM   1702  CB  LEU A 271     -10.640  32.322  29.712  1.00 23.06           C  
ATOM   1703  CG  LEU A 271     -11.981  32.050  29.019  1.00 25.58           C  
ATOM   1704  CD1 LEU A 271     -12.076  30.565  28.662  1.00 31.85           C  
ATOM   1705  CD2 LEU A 271     -13.125  32.476  29.926  1.00 16.56           C  
ATOM   1706  N   ARG A 272      -8.864  34.157  31.668  1.00 21.15           N  
ATOM   1707  CA  ARG A 272      -7.683  34.286  32.514  1.00 10.78           C  
ATOM   1708  C   ARG A 272      -7.926  33.617  33.855  1.00 18.88           C  
ATOM   1709  O   ARG A 272      -9.035  33.650  34.377  1.00 20.58           O  
ATOM   1710  CB  ARG A 272      -7.376  35.757  32.749  1.00  7.92           C  
ATOM   1711  CG  ARG A 272      -6.847  36.468  31.535  1.00 18.46           C  
ATOM   1712  CD  ARG A 272      -6.312  37.850  31.881  1.00 16.78           C  
ATOM   1713  NE  ARG A 272      -5.498  38.370  30.786  1.00 20.31           N  
ATOM   1714  CZ  ARG A 272      -4.956  39.581  30.765  1.00 16.63           C  
ATOM   1715  NH1 ARG A 272      -5.144  40.406  31.787  1.00 23.65           N  
ATOM   1716  NH2 ARG A 272      -4.223  39.963  29.726  1.00  8.02           N  
ATOM   1717  N   ALA A 273      -6.887  33.015  34.419  1.00 19.38           N  
ATOM   1718  CA  ALA A 273      -7.001  32.353  35.721  1.00 24.89           C  
ATOM   1719  C   ALA A 273      -5.628  32.356  36.385  1.00 22.84           C  
ATOM   1720  O   ALA A 273      -4.628  32.076  35.734  1.00 28.42           O  
ATOM   1721  CB  ALA A 273      -7.506  30.904  35.542  1.00 18.61           C  
ATOM   1722  N   SER A 274      -5.578  32.669  37.675  1.00 16.74           N  
ATOM   1723  CA  SER A 274      -4.309  32.701  38.402  1.00 25.02           C  
ATOM   1724  C   SER A 274      -3.145  33.281  37.587  1.00 28.01           C  
ATOM   1725  O   SER A 274      -2.002  32.848  37.729  1.00 30.25           O  
ATOM   1726  CB  SER A 274      -3.928  31.293  38.873  1.00 28.95           C  
ATOM   1727  OG  SER A 274      -4.841  30.804  39.843  1.00 30.05           O  
ATOM   1728  N   GLY A 275      -3.438  34.257  36.731  1.00 31.20           N  
ATOM   1729  CA  GLY A 275      -2.395  34.880  35.936  1.00 26.60           C  
ATOM   1730  C   GLY A 275      -2.170  34.267  34.565  1.00 28.00           C  
ATOM   1731  O   GLY A 275      -1.427  34.818  33.759  1.00 32.48           O  
ATOM   1732  N   LEU A 276      -2.791  33.129  34.287  1.00 17.81           N  
ATOM   1733  CA  LEU A 276      -2.619  32.510  32.990  1.00 17.00           C  
ATOM   1734  C   LEU A 276      -3.727  32.977  32.043  1.00 18.92           C  
ATOM   1735  O   LEU A 276      -4.825  33.306  32.486  1.00 18.85           O  
ATOM   1736  CB  LEU A 276      -2.625  30.988  33.136  1.00 22.42           C  
ATOM   1737  CG  LEU A 276      -2.640  30.126  31.869  1.00 24.44           C  
ATOM   1738  CD1 LEU A 276      -2.009  28.786  32.177  1.00 20.84           C  
ATOM   1739  CD2 LEU A 276      -4.061  29.963  31.375  1.00 13.97           C  
ATOM   1740  N   THR A 277      -3.440  33.030  30.742  1.00 16.96           N  
ATOM   1741  CA  THR A 277      -4.451  33.473  29.781  1.00 18.98           C  
ATOM   1742  C   THR A 277      -4.728  32.455  28.663  1.00 18.02           C  
ATOM   1743  O   THR A 277      -3.821  31.796  28.174  1.00 18.97           O  
ATOM   1744  CB  THR A 277      -4.040  34.822  29.121  1.00  8.86           C  
ATOM   1745  OG1 THR A 277      -3.811  35.804  30.134  1.00 17.22           O  
ATOM   1746  CG2 THR A 277      -5.123  35.328  28.196  1.00  2.56           C  
ATOM   1747  N   LEU A 278      -5.992  32.327  28.275  1.00 15.58           N  
ATOM   1748  CA  LEU A 278      -6.357  31.441  27.188  1.00 11.12           C  
ATOM   1749  C   LEU A 278      -6.879  32.339  26.069  1.00 15.03           C  
ATOM   1750  O   LEU A 278      -8.003  32.852  26.122  1.00 15.63           O  
ATOM   1751  CB  LEU A 278      -7.408  30.425  27.642  1.00 21.73           C  
ATOM   1752  CG  LEU A 278      -6.872  29.389  28.653  1.00 27.11           C  
ATOM   1753  CD1 LEU A 278      -7.978  28.422  29.100  1.00 16.64           C  
ATOM   1754  CD2 LEU A 278      -5.724  28.606  28.006  1.00 19.39           C  
ATOM   1755  N   ARG A 279      -6.021  32.549  25.069  1.00 19.32           N  
ATOM   1756  CA  ARG A 279      -6.318  33.401  23.926  1.00 16.43           C  
ATOM   1757  C   ARG A 279      -6.840  32.600  22.753  1.00 22.10           C  
ATOM   1758  O   ARG A 279      -6.076  31.921  22.058  1.00 19.33           O  
ATOM   1759  CB  ARG A 279      -5.054  34.168  23.505  1.00 16.68           C  
ATOM   1760  CG  ARG A 279      -5.030  34.704  22.050  1.00 22.88           C  
ATOM   1761  CD  ARG A 279      -5.999  35.858  21.803  1.00 25.46           C  
ATOM   1762  NE  ARG A 279      -5.516  36.785  20.762  1.00 32.31           N  
ATOM   1763  CZ  ARG A 279      -5.923  36.808  19.492  1.00 21.43           C  
ATOM   1764  NH1 ARG A 279      -6.840  35.954  19.058  1.00 31.26           N  
ATOM   1765  NH2 ARG A 279      -5.408  37.689  18.650  1.00 21.50           N  
ATOM   1766  N   PRO A 280      -8.161  32.658  22.518  1.00 28.43           N  
ATOM   1767  CA  PRO A 280      -8.748  31.918  21.394  1.00 20.91           C  
ATOM   1768  C   PRO A 280      -8.134  32.390  20.074  1.00 23.16           C  
ATOM   1769  O   PRO A 280      -8.063  33.589  19.806  1.00 20.71           O  
ATOM   1770  CB  PRO A 280     -10.237  32.245  21.504  1.00 22.36           C  
ATOM   1771  CG  PRO A 280     -10.245  33.593  22.189  1.00 24.91           C  
ATOM   1772  CD  PRO A 280      -9.187  33.431  23.242  1.00 23.30           C  
ATOM   1773  N   GLN A 281      -7.691  31.448  19.253  1.00 23.85           N  
ATOM   1774  CA  GLN A 281      -7.065  31.803  17.989  1.00 33.12           C  
ATOM   1775  C   GLN A 281      -6.916  30.590  17.072  1.00 35.12           C  
ATOM   1776  O   GLN A 281      -6.594  29.493  17.531  1.00 39.78           O  
ATOM   1777  CB  GLN A 281      -5.690  32.415  18.255  1.00 30.88           C  
ATOM   1778  CG  GLN A 281      -5.016  32.967  17.027  1.00 46.49           C  
ATOM   1779  CD  GLN A 281      -3.588  33.414  17.299  1.00 58.57           C  
ATOM   1780  OE1 GLN A 281      -3.338  34.373  18.058  1.00 50.08           O  
ATOM   1781  NE2 GLN A 281      -2.635  32.713  16.682  1.00 56.89           N  
ATOM   1782  N   ASN A 282      -7.157  30.783  15.777  1.00 33.97           N  
ATOM   1783  CA  ASN A 282      -7.040  29.686  14.820  1.00 37.92           C  
ATOM   1784  C   ASN A 282      -7.859  28.461  15.226  1.00 38.78           C  
ATOM   1785  O   ASN A 282      -7.395  27.329  15.097  1.00 40.84           O  
ATOM   1786  CB  ASN A 282      -5.575  29.279  14.669  1.00 42.33           C  
ATOM   1787  CG  ASN A 282      -4.988  29.718  13.348  1.00 54.28           C  
ATOM   1788  OD1 ASN A 282      -5.065  30.897  12.981  1.00 60.47           O  
ATOM   1789  ND2 ASN A 282      -4.392  28.775  12.622  1.00 54.20           N  
ATOM   1790  N   GLY A 283      -9.070  28.693  15.728  1.00 36.77           N  
ATOM   1791  CA  GLY A 283      -9.931  27.594  16.127  1.00 33.42           C  
ATOM   1792  C   GLY A 283      -9.525  26.922  17.421  1.00 31.73           C  
ATOM   1793  O   GLY A 283     -10.166  25.969  17.855  1.00 33.84           O  
ATOM   1794  N   GLY A 284      -8.463  27.416  18.040  1.00 26.62           N  
ATOM   1795  CA  GLY A 284      -8.012  26.839  19.289  1.00 25.75           C  
ATOM   1796  C   GLY A 284      -7.731  27.926  20.306  1.00 26.52           C  
ATOM   1797  O   GLY A 284      -8.367  28.978  20.297  1.00 25.15           O  
ATOM   1798  N   TYR A 285      -6.774  27.676  21.188  1.00 23.77           N  
ATOM   1799  CA  TYR A 285      -6.411  28.645  22.212  1.00 25.04           C  
ATOM   1800  C   TYR A 285      -4.901  28.675  22.313  1.00 25.19           C  
ATOM   1801  O   TYR A 285      -4.235  27.656  22.142  1.00 30.18           O  
ATOM   1802  CB  TYR A 285      -6.991  28.252  23.580  1.00 24.10           C  
ATOM   1803  CG  TYR A 285      -8.503  28.169  23.629  1.00 31.10           C  
ATOM   1804  CD1 TYR A 285      -9.274  29.264  24.014  1.00 31.62           C  
ATOM   1805  CD2 TYR A 285      -9.166  27.000  23.262  1.00 33.58           C  
ATOM   1806  CE1 TYR A 285     -10.670  29.195  24.031  1.00 32.47           C  
ATOM   1807  CE2 TYR A 285     -10.561  26.920  23.271  1.00 27.26           C  
ATOM   1808  CZ  TYR A 285     -11.307  28.022  23.656  1.00 28.63           C  
ATOM   1809  OH  TYR A 285     -12.682  27.955  23.647  1.00 20.80           O  
ATOM   1810  N   THR A 286      -4.366  29.859  22.568  1.00 23.47           N  
ATOM   1811  CA  THR A 286      -2.937  30.024  22.734  1.00 16.85           C  
ATOM   1812  C   THR A 286      -2.778  30.286  24.218  1.00 19.94           C  
ATOM   1813  O   THR A 286      -3.445  31.158  24.767  1.00 20.64           O  
ATOM   1814  CB  THR A 286      -2.418  31.219  21.938  1.00 15.57           C  
ATOM   1815  OG1 THR A 286      -2.525  30.934  20.539  1.00 23.03           O  
ATOM   1816  CG2 THR A 286      -0.962  31.492  22.275  1.00 25.60           C  
ATOM   1817  N   LEU A 287      -1.912  29.523  24.872  1.00 19.82           N  
ATOM   1818  CA  LEU A 287      -1.708  29.673  26.307  1.00 20.93           C  
ATOM   1819  C   LEU A 287      -0.642  30.741  26.579  1.00 19.98           C  
ATOM   1820  O   LEU A 287       0.481  30.632  26.096  1.00 30.81           O  
ATOM   1821  CB  LEU A 287      -1.320  28.302  26.896  1.00 18.34           C  
ATOM   1822  CG  LEU A 287      -1.313  28.085  28.404  1.00 18.44           C  
ATOM   1823  CD1 LEU A 287      -1.448  26.609  28.748  1.00 17.37           C  
ATOM   1824  CD2 LEU A 287      -0.025  28.656  28.956  1.00 24.84           C  
ATOM   1825  N   VAL A 288      -1.009  31.783  27.329  1.00 16.08           N  
ATOM   1826  CA  VAL A 288      -0.090  32.882  27.665  1.00 14.94           C  
ATOM   1827  C   VAL A 288       0.252  32.836  29.162  1.00 21.42           C  
ATOM   1828  O   VAL A 288      -0.451  33.410  30.000  1.00 18.30           O  
ATOM   1829  CB  VAL A 288      -0.717  34.268  27.313  1.00 13.84           C  
ATOM   1830  CG1 VAL A 288       0.302  35.390  27.525  1.00  7.81           C  
ATOM   1831  CG2 VAL A 288      -1.195  34.270  25.877  1.00  4.34           C  
ATOM   1832  N   PRO A 289       1.353  32.153  29.513  1.00 25.24           N  
ATOM   1833  CA  PRO A 289       1.776  32.024  30.910  1.00 27.59           C  
ATOM   1834  C   PRO A 289       1.990  33.354  31.617  1.00 29.60           C  
ATOM   1835  O   PRO A 289       2.187  34.396  30.988  1.00 30.89           O  
ATOM   1836  CB  PRO A 289       3.076  31.216  30.818  1.00 20.12           C  
ATOM   1837  CG  PRO A 289       2.934  30.469  29.531  1.00 27.99           C  
ATOM   1838  CD  PRO A 289       2.334  31.519  28.620  1.00 26.53           C  
ATOM   1839  N   ALA A 290       1.939  33.308  32.940  1.00 28.22           N  
ATOM   1840  CA  ALA A 290       2.154  34.498  33.728  1.00 22.57           C  
ATOM   1841  C   ALA A 290       3.663  34.597  33.932  1.00 22.30           C  
ATOM   1842  O   ALA A 290       4.378  33.595  33.854  1.00 17.75           O  
ATOM   1843  CB  ALA A 290       1.444  34.371  35.063  1.00 20.08           C  
ATOM   1844  N   ILE A 291       4.145  35.814  34.154  1.00 24.81           N  
ATOM   1845  CA  ILE A 291       5.560  36.036  34.405  1.00 28.13           C  
ATOM   1846  C   ILE A 291       5.641  36.332  35.895  1.00 29.28           C  
ATOM   1847  O   ILE A 291       5.195  37.386  36.355  1.00 31.44           O  
ATOM   1848  CB  ILE A 291       6.110  37.249  33.619  1.00 28.71           C  
ATOM   1849  CG1 ILE A 291       5.725  37.141  32.141  1.00 32.81           C  
ATOM   1850  CG2 ILE A 291       7.639  37.313  33.756  1.00 26.71           C  
ATOM   1851  CD1 ILE A 291       6.253  35.907  31.438  1.00 34.01           C  
ATOM   1852  N   HIS A 292       6.188  35.385  36.647  1.00 29.64           N  
ATOM   1853  CA  HIS A 292       6.310  35.530  38.088  1.00 28.84           C  
ATOM   1854  C   HIS A 292       7.519  36.355  38.455  1.00 29.18           C  
ATOM   1855  O   HIS A 292       7.507  37.068  39.456  1.00 26.67           O  
ATOM   1856  CB  HIS A 292       6.417  34.156  38.735  1.00 30.86           C  
ATOM   1857  CG  HIS A 292       5.262  33.264  38.425  1.00 34.83           C  
ATOM   1858  ND1 HIS A 292       3.965  33.585  38.764  1.00 31.56           N  
ATOM   1859  CD2 HIS A 292       5.203  32.072  37.787  1.00 36.85           C  
ATOM   1860  CE1 HIS A 292       3.156  32.629  38.346  1.00 43.80           C  
ATOM   1861  NE2 HIS A 292       3.881  31.698  37.750  1.00 46.46           N  
ATOM   1862  N   HIS A 293       8.552  36.266  37.626  1.00 33.03           N  
ATOM   1863  CA  HIS A 293       9.782  36.998  37.880  1.00 38.13           C  
ATOM   1864  C   HIS A 293      10.658  37.070  36.638  1.00 33.72           C  
ATOM   1865  O   HIS A 293      10.391  36.401  35.646  1.00 31.10           O  
ATOM   1866  CB  HIS A 293      10.551  36.304  39.004  1.00 46.49           C  
ATOM   1867  CG  HIS A 293      10.873  34.874  38.706  1.00 41.70           C  
ATOM   1868  ND1 HIS A 293      11.792  34.505  37.748  1.00 47.33           N  
ATOM   1869  CD2 HIS A 293      10.366  33.722  39.203  1.00 44.57           C  
ATOM   1870  CE1 HIS A 293      11.839  33.188  37.666  1.00 43.68           C  
ATOM   1871  NE2 HIS A 293      10.983  32.687  38.540  1.00 47.47           N  
ATOM   1872  N   ARG A 294      11.709  37.880  36.710  1.00 30.67           N  
ATOM   1873  CA  ARG A 294      12.629  38.030  35.595  1.00 29.62           C  
ATOM   1874  C   ARG A 294      13.620  36.868  35.555  1.00 24.19           C  
ATOM   1875  O   ARG A 294      13.916  36.259  36.581  1.00 23.83           O  
ATOM   1876  CB  ARG A 294      13.405  39.343  35.711  1.00 31.62           C  
ATOM   1877  CG  ARG A 294      14.333  39.402  36.906  1.00 33.13           C  
ATOM   1878  CD  ARG A 294      15.368  40.505  36.753  1.00 43.43           C  
ATOM   1879  NE  ARG A 294      16.219  40.611  37.937  1.00 46.20           N  
ATOM   1880  CZ  ARG A 294      15.772  40.927  39.149  1.00 44.92           C  
ATOM   1881  NH1 ARG A 294      14.483  41.170  39.341  1.00 43.49           N  
ATOM   1882  NH2 ARG A 294      16.613  40.998  40.167  1.00 34.79           N  
ATOM   1883  N   ASP A 295      14.124  36.562  34.362  1.00 23.79           N  
ATOM   1884  CA  ASP A 295      15.093  35.491  34.188  1.00 21.20           C  
ATOM   1885  C   ASP A 295      16.496  36.078  34.243  1.00 20.42           C  
ATOM   1886  O   ASP A 295      16.749  37.130  33.667  1.00 24.52           O  
ATOM   1887  CB  ASP A 295      14.886  34.792  32.847  1.00 26.02           C  
ATOM   1888  CG  ASP A 295      13.619  33.958  32.810  1.00 29.74           C  
ATOM   1889  OD1 ASP A 295      13.422  33.130  33.718  1.00 26.24           O  
ATOM   1890  OD2 ASP A 295      12.812  34.128  31.869  1.00 38.15           O  
ATOM   1891  N   PRO A 296      17.426  35.401  34.934  1.00 27.69           N  
ATOM   1892  CA  PRO A 296      18.814  35.851  35.072  1.00 31.00           C  
ATOM   1893  C   PRO A 296      19.548  35.995  33.749  1.00 37.54           C  
ATOM   1894  O   PRO A 296      19.168  35.394  32.743  1.00 40.36           O  
ATOM   1895  CB  PRO A 296      19.436  34.781  35.960  1.00 36.40           C  
ATOM   1896  CG  PRO A 296      18.667  33.553  35.580  1.00 38.38           C  
ATOM   1897  CD  PRO A 296      17.251  34.076  35.552  1.00 32.99           C  
ATOM   1898  N   HIS A 297      20.608  36.797  33.765  1.00 43.60           N  
ATOM   1899  CA  HIS A 297      21.421  37.045  32.581  1.00 47.47           C  
ATOM   1900  C   HIS A 297      21.883  35.742  31.931  1.00 48.41           C  
ATOM   1901  O   HIS A 297      21.698  35.540  30.730  1.00 52.63           O  
ATOM   1902  CB  HIS A 297      22.628  37.912  32.959  1.00 50.59           C  
ATOM   1903  CG  HIS A 297      23.527  38.242  31.806  1.00 58.71           C  
ATOM   1904  ND1 HIS A 297      24.321  37.300  31.186  1.00 59.09           N  
ATOM   1905  CD2 HIS A 297      23.769  39.413  31.170  1.00 59.34           C  
ATOM   1906  CE1 HIS A 297      25.013  37.877  30.219  1.00 59.21           C  
ATOM   1907  NE2 HIS A 297      24.697  39.158  30.189  1.00 61.97           N  
ATOM   1908  N   GLY A 298      22.483  34.859  32.722  1.00 44.30           N  
ATOM   1909  CA  GLY A 298      22.945  33.594  32.179  1.00 47.89           C  
ATOM   1910  C   GLY A 298      21.903  32.507  32.358  1.00 49.78           C  
ATOM   1911  O   GLY A 298      22.015  31.668  33.254  1.00 55.42           O  
ATOM   1912  N   TYR A 299      20.881  32.521  31.510  1.00 43.32           N  
ATOM   1913  CA  TYR A 299      19.817  31.532  31.598  1.00 41.97           C  
ATOM   1914  C   TYR A 299      19.412  31.000  30.231  1.00 42.28           C  
ATOM   1915  O   TYR A 299      19.157  31.765  29.302  1.00 39.85           O  
ATOM   1916  CB  TYR A 299      18.594  32.133  32.311  1.00 45.90           C  
ATOM   1917  CG  TYR A 299      17.360  31.254  32.291  1.00 41.65           C  
ATOM   1918  CD1 TYR A 299      17.348  30.012  32.927  1.00 48.08           C  
ATOM   1919  CD2 TYR A 299      16.224  31.638  31.574  1.00 44.69           C  
ATOM   1920  CE1 TYR A 299      16.236  29.168  32.838  1.00 46.55           C  
ATOM   1921  CE2 TYR A 299      15.111  30.806  31.476  1.00 40.57           C  
ATOM   1922  CZ  TYR A 299      15.125  29.572  32.105  1.00 50.62           C  
ATOM   1923  OH  TYR A 299      14.048  28.727  31.963  1.00 51.23           O  
ATOM   1924  N   HIS A 300      19.379  29.678  30.120  1.00 44.11           N  
ATOM   1925  CA  HIS A 300      18.985  29.014  28.890  1.00 45.02           C  
ATOM   1926  C   HIS A 300      17.701  28.250  29.150  1.00 46.12           C  
ATOM   1927  O   HIS A 300      17.678  27.299  29.929  1.00 48.73           O  
ATOM   1928  CB  HIS A 300      20.059  28.032  28.421  1.00 52.04           C  
ATOM   1929  CG  HIS A 300      21.236  28.685  27.769  1.00 54.66           C  
ATOM   1930  ND1 HIS A 300      22.106  27.999  26.949  1.00 54.57           N  
ATOM   1931  CD2 HIS A 300      21.693  29.958  27.821  1.00 58.75           C  
ATOM   1932  CE1 HIS A 300      23.048  28.820  26.525  1.00 55.45           C  
ATOM   1933  NE2 HIS A 300      22.822  30.016  27.040  1.00 61.97           N  
ATOM   1934  N   PRO A 301      16.605  28.669  28.509  1.00 44.57           N  
ATOM   1935  CA  PRO A 301      15.326  27.993  28.694  1.00 47.09           C  
ATOM   1936  C   PRO A 301      15.413  26.523  28.297  1.00 48.51           C  
ATOM   1937  O   PRO A 301      15.861  26.182  27.198  1.00 41.53           O  
ATOM   1938  CB  PRO A 301      14.385  28.790  27.797  1.00 47.74           C  
ATOM   1939  CG  PRO A 301      15.290  29.309  26.725  1.00 49.85           C  
ATOM   1940  CD  PRO A 301      16.484  29.752  27.521  1.00 44.51           C  
ATOM   1941  N   ALA A 302      14.974  25.657  29.202  1.00 48.37           N  
ATOM   1942  CA  ALA A 302      15.005  24.226  28.962  1.00 51.71           C  
ATOM   1943  C   ALA A 302      13.642  23.593  29.212  1.00 55.08           C  
ATOM   1944  O   ALA A 302      13.024  23.057  28.295  1.00 62.96           O  
ATOM   1945  CB  ALA A 302      16.059  23.580  29.849  1.00 53.18           C  
ATOM   1946  N   GLY A 303      13.176  23.653  30.454  1.00 51.33           N  
ATOM   1947  CA  GLY A 303      11.886  23.073  30.790  1.00 59.54           C  
ATOM   1948  C   GLY A 303      11.712  21.601  30.450  1.00 57.85           C  
ATOM   1949  O   GLY A 303      12.383  21.072  29.562  1.00 60.32           O  
ATOM   1950  N   GLY A 304      10.806  20.935  31.162  1.00 59.82           N  
ATOM   1951  CA  GLY A 304      10.547  19.527  30.906  1.00 60.63           C  
ATOM   1952  C   GLY A 304      10.719  18.634  32.119  1.00 56.73           C  
ATOM   1953  O   GLY A 304      11.810  18.126  32.375  1.00 60.59           O  
ATOM   1954  N   SER A 305       9.636  18.439  32.860  1.00 50.12           N  
ATOM   1955  CA  SER A 305       9.654  17.602  34.053  1.00 49.03           C  
ATOM   1956  C   SER A 305       8.222  17.341  34.505  1.00 46.30           C  
ATOM   1957  O   SER A 305       7.855  17.667  35.635  1.00 46.68           O  
ATOM   1958  CB  SER A 305      10.424  18.293  35.190  1.00 54.54           C  
ATOM   1959  OG  SER A 305      11.810  18.427  34.905  1.00 54.62           O  
ATOM   1960  N   LEU A 306       7.406  16.764  33.631  1.00 42.82           N  
ATOM   1961  CA  LEU A 306       6.024  16.489  34.002  1.00 47.00           C  
ATOM   1962  C   LEU A 306       5.752  15.004  34.217  1.00 46.36           C  
ATOM   1963  O   LEU A 306       5.797  14.202  33.280  1.00 39.54           O  
ATOM   1964  CB  LEU A 306       5.045  17.052  32.960  1.00 44.82           C  
ATOM   1965  CG  LEU A 306       3.556  16.858  33.295  1.00 39.86           C  
ATOM   1966  CD1 LEU A 306       3.213  17.583  34.588  1.00 39.24           C  
ATOM   1967  CD2 LEU A 306       2.703  17.371  32.161  1.00 32.21           C  
ATOM   1968  N   THR A 307       5.467  14.669  35.473  1.00 45.17           N  
ATOM   1969  CA  THR A 307       5.178  13.316  35.906  1.00 48.45           C  
ATOM   1970  C   THR A 307       6.110  12.271  35.286  1.00 47.28           C  
ATOM   1971  O   THR A 307       5.663  11.304  34.671  1.00 42.40           O  
ATOM   1972  CB  THR A 307       3.691  12.955  35.627  1.00 52.37           C  
ATOM   1973  OG1 THR A 307       3.430  11.621  36.078  1.00 62.51           O  
ATOM   1974  CG2 THR A 307       3.367  13.053  34.142  1.00 59.61           C  
ATOM   1975  N   GLY A 308       7.414  12.484  35.447  1.00 45.21           N  
ATOM   1976  CA  GLY A 308       8.399  11.548  34.933  1.00 48.71           C  
ATOM   1977  C   GLY A 308       8.686  11.556  33.444  1.00 51.71           C  
ATOM   1978  O   GLY A 308       9.407  10.692  32.949  1.00 54.53           O  
ATOM   1979  N   VAL A 309       8.135  12.522  32.721  1.00 51.60           N  
ATOM   1980  CA  VAL A 309       8.371  12.609  31.286  1.00 47.85           C  
ATOM   1981  C   VAL A 309       8.886  13.997  30.928  1.00 48.91           C  
ATOM   1982  O   VAL A 309       8.353  15.003  31.394  1.00 55.97           O  
ATOM   1983  CB  VAL A 309       7.082  12.340  30.496  1.00 49.67           C  
ATOM   1984  CG1 VAL A 309       7.389  12.278  29.009  1.00 44.14           C  
ATOM   1985  CG2 VAL A 309       6.441  11.054  30.975  1.00 44.53           C  
ATOM   1986  N   PRO A 310       9.939  14.069  30.098  1.00 46.77           N  
ATOM   1987  CA  PRO A 310      10.540  15.337  29.669  1.00 44.74           C  
ATOM   1988  C   PRO A 310       9.703  16.072  28.624  1.00 41.80           C  
ATOM   1989  O   PRO A 310       9.386  15.517  27.574  1.00 43.70           O  
ATOM   1990  CB  PRO A 310      11.894  14.898  29.117  1.00 45.44           C  
ATOM   1991  CG  PRO A 310      11.580  13.573  28.510  1.00 42.35           C  
ATOM   1992  CD  PRO A 310      10.701  12.924  29.568  1.00 44.57           C  
ATOM   1993  N   THR A 311       9.356  17.323  28.908  1.00 39.10           N  
ATOM   1994  CA  THR A 311       8.550  18.112  27.981  1.00 36.30           C  
ATOM   1995  C   THR A 311       9.279  19.378  27.547  1.00 35.20           C  
ATOM   1996  O   THR A 311      10.446  19.579  27.887  1.00 39.00           O  
ATOM   1997  CB  THR A 311       7.204  18.499  28.613  1.00 37.15           C  
ATOM   1998  OG1 THR A 311       7.349  19.726  29.332  1.00 36.46           O  
ATOM   1999  CG2 THR A 311       6.748  17.415  29.593  1.00 34.23           C  
ATOM   2000  N   GLY A 312       8.591  20.234  26.796  1.00 36.80           N  
ATOM   2001  CA  GLY A 312       9.214  21.463  26.323  1.00 32.36           C  
ATOM   2002  C   GLY A 312       8.910  22.707  27.139  1.00 28.59           C  
ATOM   2003  O   GLY A 312       9.440  23.772  26.848  1.00 23.97           O  
ATOM   2004  N   LEU A 313       8.067  22.563  28.161  1.00 31.47           N  
ATOM   2005  CA  LEU A 313       7.663  23.665  29.028  1.00 23.96           C  
ATOM   2006  C   LEU A 313       8.572  23.822  30.248  1.00 32.12           C  
ATOM   2007  O   LEU A 313       8.987  22.828  30.853  1.00 39.23           O  
ATOM   2008  CB  LEU A 313       6.218  23.445  29.491  1.00 18.25           C  
ATOM   2009  CG  LEU A 313       5.105  23.527  28.439  1.00 28.12           C  
ATOM   2010  CD1 LEU A 313       5.330  22.501  27.357  1.00 35.83           C  
ATOM   2011  CD2 LEU A 313       3.750  23.306  29.098  1.00 20.76           C  
ATOM   2012  N   ARG A 314       8.871  25.067  30.616  1.00 31.57           N  
ATOM   2013  CA  ARG A 314       9.723  25.338  31.771  1.00 32.99           C  
ATOM   2014  C   ARG A 314       9.080  24.815  33.037  1.00 35.83           C  
ATOM   2015  O   ARG A 314       7.855  24.734  33.136  1.00 37.31           O  
ATOM   2016  CB  ARG A 314       9.979  26.837  31.936  1.00 34.22           C  
ATOM   2017  CG  ARG A 314      10.528  27.493  30.700  1.00 44.95           C  
ATOM   2018  CD  ARG A 314      11.317  28.744  31.008  1.00 47.61           C  
ATOM   2019  NE  ARG A 314      10.640  29.729  31.780  1.00 42.61           N  
ATOM   2020  CZ  ARG A 314      11.060  30.493  32.782  1.00 52.05           C  
ATOM   2021  NH1 ARG A 314      12.281  30.473  33.312  1.00 43.72           N  
ATOM   2022  NH2 ARG A 314      10.170  31.361  33.214  1.00 62.12           N  
ATOM   2023  N   ARG A 315       9.920  24.472  34.006  1.00 33.13           N  
ATOM   2024  CA  ARG A 315       9.458  23.943  35.283  1.00 34.34           C  
ATOM   2025  C   ARG A 315       8.358  24.834  35.878  1.00 34.83           C  
ATOM   2026  O   ARG A 315       7.317  24.345  36.323  1.00 38.35           O  
ATOM   2027  CB  ARG A 315      10.651  23.820  36.246  1.00 35.81           C  
ATOM   2028  CG  ARG A 315      10.313  23.417  37.684  1.00 44.35           C  
ATOM   2029  CD  ARG A 315      11.571  23.463  38.578  1.00 47.40           C  
ATOM   2030  NE  ARG A 315      12.286  24.737  38.461  1.00 46.36           N  
ATOM   2031  CZ  ARG A 315      11.850  25.902  38.939  1.00 48.73           C  
ATOM   2032  NH1 ARG A 315      10.691  25.974  39.587  1.00 45.89           N  
ATOM   2033  NH2 ARG A 315      12.569  27.005  38.752  1.00 43.04           N  
ATOM   2034  N   GLU A 316       8.573  26.142  35.855  1.00 33.58           N  
ATOM   2035  CA  GLU A 316       7.593  27.055  36.412  1.00 32.76           C  
ATOM   2036  C   GLU A 316       6.227  26.997  35.753  1.00 33.42           C  
ATOM   2037  O   GLU A 316       5.206  27.081  36.434  1.00 29.88           O  
ATOM   2038  CB  GLU A 316       8.126  28.476  36.373  1.00 33.78           C  
ATOM   2039  CG  GLU A 316       9.228  28.698  37.376  1.00 45.74           C  
ATOM   2040  CD  GLU A 316       9.471  30.160  37.634  1.00 52.82           C  
ATOM   2041  OE1 GLU A 316       9.933  30.845  36.697  1.00 64.63           O  
ATOM   2042  OE2 GLU A 316       9.188  30.620  38.765  1.00 50.53           O  
ATOM   2043  N   LEU A 317       6.203  26.852  34.433  1.00 33.22           N  
ATOM   2044  CA  LEU A 317       4.935  26.774  33.718  1.00 32.83           C  
ATOM   2045  C   LEU A 317       4.257  25.455  34.095  1.00 32.08           C  
ATOM   2046  O   LEU A 317       3.046  25.404  34.315  1.00 32.61           O  
ATOM   2047  CB  LEU A 317       5.162  26.828  32.205  1.00 26.60           C  
ATOM   2048  CG  LEU A 317       4.033  27.449  31.371  1.00 32.37           C  
ATOM   2049  CD1 LEU A 317       4.254  27.112  29.899  1.00 32.18           C  
ATOM   2050  CD2 LEU A 317       2.685  26.938  31.817  1.00 26.68           C  
ATOM   2051  N   LEU A 318       5.055  24.395  34.169  1.00 28.92           N  
ATOM   2052  CA  LEU A 318       4.563  23.073  34.532  1.00 26.45           C  
ATOM   2053  C   LEU A 318       3.856  23.127  35.881  1.00 27.54           C  
ATOM   2054  O   LEU A 318       2.746  22.619  36.032  1.00 32.14           O  
ATOM   2055  CB  LEU A 318       5.729  22.083  34.603  1.00 25.76           C  
ATOM   2056  CG  LEU A 318       5.990  21.094  33.460  1.00 32.93           C  
ATOM   2057  CD1 LEU A 318       5.217  21.485  32.199  1.00 24.37           C  
ATOM   2058  CD2 LEU A 318       7.485  21.042  33.197  1.00 24.70           C  
ATOM   2059  N   GLU A 319       4.500  23.752  36.859  1.00 24.22           N  
ATOM   2060  CA  GLU A 319       3.922  23.855  38.191  1.00 21.34           C  
ATOM   2061  C   GLU A 319       2.613  24.632  38.134  1.00 25.20           C  
ATOM   2062  O   GLU A 319       1.615  24.217  38.724  1.00 30.30           O  
ATOM   2063  CB  GLU A 319       4.892  24.559  39.149  1.00 27.87           C  
ATOM   2064  CG  GLU A 319       6.324  24.038  39.103  1.00 29.78           C  
ATOM   2065  CD  GLU A 319       7.208  24.669  40.156  1.00 31.66           C  
ATOM   2066  OE1 GLU A 319       7.123  25.895  40.359  1.00 44.56           O  
ATOM   2067  OE2 GLU A 319       7.998  23.942  40.786  1.00 41.01           O  
ATOM   2068  N   ASP A 320       2.617  25.760  37.425  1.00 29.33           N  
ATOM   2069  CA  ASP A 320       1.416  26.587  37.303  1.00 29.15           C  
ATOM   2070  C   ASP A 320       0.261  25.742  36.768  1.00 28.19           C  
ATOM   2071  O   ASP A 320      -0.839  25.749  37.328  1.00 33.54           O  
ATOM   2072  CB  ASP A 320       1.660  27.787  36.365  1.00 27.95           C  
ATOM   2073  CG  ASP A 320       2.464  28.906  37.024  1.00 27.49           C  
ATOM   2074  OD1 ASP A 320       2.195  29.227  38.203  1.00 31.05           O  
ATOM   2075  OD2 ASP A 320       3.350  29.483  36.358  1.00 26.30           O  
ATOM   2076  N   LEU A 321       0.519  25.013  35.685  1.00 18.58           N  
ATOM   2077  CA  LEU A 321      -0.488  24.148  35.077  1.00 19.82           C  
ATOM   2078  C   LEU A 321      -1.051  23.162  36.105  1.00 22.45           C  
ATOM   2079  O   LEU A 321      -2.262  23.008  36.230  1.00 22.17           O  
ATOM   2080  CB  LEU A 321       0.121  23.371  33.904  1.00 13.21           C  
ATOM   2081  CG  LEU A 321       0.616  24.171  32.701  1.00 17.81           C  
ATOM   2082  CD1 LEU A 321       1.279  23.222  31.725  1.00 20.61           C  
ATOM   2083  CD2 LEU A 321      -0.533  24.905  32.038  1.00 13.23           C  
ATOM   2084  N   VAL A 322      -0.166  22.495  36.837  1.00 23.68           N  
ATOM   2085  CA  VAL A 322      -0.598  21.536  37.841  1.00 22.77           C  
ATOM   2086  C   VAL A 322      -1.536  22.214  38.830  1.00 21.94           C  
ATOM   2087  O   VAL A 322      -2.534  21.635  39.242  1.00 24.58           O  
ATOM   2088  CB  VAL A 322       0.615  20.951  38.592  1.00 28.79           C  
ATOM   2089  CG1 VAL A 322       0.155  20.060  39.735  1.00 31.18           C  
ATOM   2090  CG2 VAL A 322       1.492  20.168  37.620  1.00 20.34           C  
ATOM   2091  N   GLY A 323      -1.219  23.454  39.192  1.00 29.73           N  
ATOM   2092  CA  GLY A 323      -2.041  24.190  40.138  1.00 22.89           C  
ATOM   2093  C   GLY A 323      -3.357  24.681  39.568  1.00 21.45           C  
ATOM   2094  O   GLY A 323      -4.250  25.083  40.311  1.00 15.57           O  
ATOM   2095  N   LEU A 324      -3.487  24.640  38.247  1.00 21.68           N  
ATOM   2096  CA  LEU A 324      -4.711  25.096  37.598  1.00 27.70           C  
ATOM   2097  C   LEU A 324      -5.544  23.993  36.963  1.00 29.97           C  
ATOM   2098  O   LEU A 324      -6.680  24.227  36.554  1.00 32.00           O  
ATOM   2099  CB  LEU A 324      -4.379  26.140  36.538  1.00 28.05           C  
ATOM   2100  CG  LEU A 324      -4.502  27.593  36.984  1.00 26.40           C  
ATOM   2101  CD1 LEU A 324      -3.914  28.493  35.921  1.00 25.89           C  
ATOM   2102  CD2 LEU A 324      -5.956  27.929  37.248  1.00 17.53           C  
HETATM 2103  N   MSE A 325      -4.976  22.795  36.882  1.00 35.61           N  
HETATM 2104  CA  MSE A 325      -5.662  21.658  36.283  1.00 34.34           C  
HETATM 2105  C   MSE A 325      -7.019  21.347  36.870  1.00 26.57           C  
HETATM 2106  O   MSE A 325      -7.937  20.959  36.147  1.00 27.43           O  
HETATM 2107  CB  MSE A 325      -4.798  20.410  36.379  1.00 38.66           C  
HETATM 2108  CG  MSE A 325      -3.824  20.277  35.233  1.00 45.25           C  
HETATM 2109 SE   MSE A 325      -2.757  18.720  35.422  1.00 45.67          SE  
HETATM 2110  CE  MSE A 325      -1.079  19.501  34.899  1.00 42.24           C  
ATOM   2111  N   ASP A 326      -7.155  21.480  38.177  1.00 19.50           N  
ATOM   2112  CA  ASP A 326      -8.443  21.189  38.767  1.00 28.33           C  
ATOM   2113  C   ASP A 326      -9.443  22.228  38.278  1.00 31.57           C  
ATOM   2114  O   ASP A 326     -10.472  21.886  37.690  1.00 28.39           O  
ATOM   2115  CB  ASP A 326      -8.344  21.176  40.294  1.00 34.00           C  
ATOM   2116  CG  ASP A 326      -7.446  20.058  40.806  1.00 32.32           C  
ATOM   2117  OD1 ASP A 326      -7.600  18.913  40.347  1.00 37.39           O  
ATOM   2118  OD2 ASP A 326      -6.585  20.315  41.665  1.00 41.45           O  
ATOM   2119  N   ALA A 327      -9.122  23.501  38.483  1.00 30.84           N  
ATOM   2120  CA  ALA A 327     -10.007  24.586  38.064  1.00 30.79           C  
ATOM   2121  C   ALA A 327     -10.250  24.616  36.560  1.00 30.75           C  
ATOM   2122  O   ALA A 327     -11.355  24.920  36.108  1.00 29.68           O  
ATOM   2123  CB  ALA A 327      -9.433  25.928  38.517  1.00 33.55           C  
ATOM   2124  N   VAL A 328      -9.213  24.301  35.790  1.00 31.15           N  
ATOM   2125  CA  VAL A 328      -9.293  24.318  34.334  1.00 27.48           C  
ATOM   2126  C   VAL A 328      -8.897  22.944  33.784  1.00 30.46           C  
ATOM   2127  O   VAL A 328      -7.797  22.748  33.274  1.00 30.53           O  
ATOM   2128  CB  VAL A 328      -8.371  25.430  33.797  1.00 18.80           C  
ATOM   2129  CG1 VAL A 328      -8.525  25.591  32.295  1.00 12.69           C  
ATOM   2130  CG2 VAL A 328      -8.699  26.724  34.518  1.00 13.19           C  
ATOM   2131  N   PRO A 329      -9.817  21.973  33.871  1.00 31.43           N  
ATOM   2132  CA  PRO A 329      -9.602  20.599  33.405  1.00 36.94           C  
ATOM   2133  C   PRO A 329      -8.943  20.490  32.039  1.00 35.81           C  
ATOM   2134  O   PRO A 329      -8.181  19.556  31.786  1.00 41.78           O  
ATOM   2135  CB  PRO A 329     -11.009  20.006  33.413  1.00 38.86           C  
ATOM   2136  CG  PRO A 329     -11.676  20.749  34.531  1.00 40.10           C  
ATOM   2137  CD  PRO A 329     -11.222  22.170  34.272  1.00 35.90           C  
ATOM   2138  N   ALA A 330      -9.242  21.444  31.166  1.00 29.22           N  
ATOM   2139  CA  ALA A 330      -8.686  21.449  29.822  1.00 26.07           C  
ATOM   2140  C   ALA A 330      -7.160  21.397  29.843  1.00 25.82           C  
ATOM   2141  O   ALA A 330      -6.536  20.973  28.877  1.00 27.99           O  
ATOM   2142  CB  ALA A 330      -9.163  22.691  29.064  1.00 31.08           C  
ATOM   2143  N   LEU A 331      -6.557  21.830  30.941  1.00 17.45           N  
ATOM   2144  CA  LEU A 331      -5.111  21.808  31.039  1.00 24.33           C  
ATOM   2145  C   LEU A 331      -4.592  20.413  31.368  1.00 28.55           C  
ATOM   2146  O   LEU A 331      -3.388  20.177  31.343  1.00 26.63           O  
ATOM   2147  CB  LEU A 331      -4.639  22.804  32.102  1.00 19.39           C  
ATOM   2148  CG  LEU A 331      -4.339  24.226  31.633  1.00 28.95           C  
ATOM   2149  CD1 LEU A 331      -5.407  24.726  30.665  1.00 26.60           C  
ATOM   2150  CD2 LEU A 331      -4.231  25.109  32.848  1.00 11.20           C  
ATOM   2151  N   ALA A 332      -5.502  19.488  31.657  1.00 26.19           N  
ATOM   2152  CA  ALA A 332      -5.119  18.130  32.011  1.00 30.50           C  
ATOM   2153  C   ALA A 332      -5.515  17.069  30.993  1.00 36.46           C  
ATOM   2154  O   ALA A 332      -5.212  15.890  31.180  1.00 42.45           O  
ATOM   2155  CB  ALA A 332      -5.695  17.770  33.370  1.00 17.96           C  
ATOM   2156  N   GLY A 333      -6.178  17.479  29.912  1.00 38.84           N  
ATOM   2157  CA  GLY A 333      -6.601  16.530  28.889  1.00 32.93           C  
ATOM   2158  C   GLY A 333      -5.621  16.349  27.741  1.00 31.13           C  
ATOM   2159  O   GLY A 333      -4.407  16.431  27.930  1.00 33.18           O  
ATOM   2160  N   GLU A 334      -6.148  16.109  26.545  1.00 31.81           N  
ATOM   2161  CA  GLU A 334      -5.323  15.903  25.348  1.00 32.72           C  
ATOM   2162  C   GLU A 334      -5.036  17.186  24.569  1.00 27.11           C  
ATOM   2163  O   GLU A 334      -4.208  17.182  23.661  1.00 24.67           O  
ATOM   2164  CB  GLU A 334      -6.025  14.925  24.407  1.00 31.66           C  
ATOM   2165  CG  GLU A 334      -7.412  15.396  23.976  1.00 37.21           C  
ATOM   2166  CD  GLU A 334      -8.160  14.380  23.124  1.00 44.55           C  
ATOM   2167  OE1 GLU A 334      -7.761  14.163  21.960  1.00 35.37           O  
ATOM   2168  OE2 GLU A 334      -9.151  13.797  23.627  1.00 48.68           O  
ATOM   2169  N   GLY A 335      -5.710  18.273  24.934  1.00 23.83           N  
ATOM   2170  CA  GLY A 335      -5.550  19.534  24.224  1.00 26.92           C  
ATOM   2171  C   GLY A 335      -4.185  20.193  24.140  1.00 27.42           C  
ATOM   2172  O   GLY A 335      -3.728  20.521  23.046  1.00 25.49           O  
ATOM   2173  N   LEU A 336      -3.545  20.391  25.294  1.00 31.74           N  
ATOM   2174  CA  LEU A 336      -2.235  21.041  25.387  1.00 30.65           C  
ATOM   2175  C   LEU A 336      -1.091  20.346  24.689  1.00 26.56           C  
ATOM   2176  O   LEU A 336      -0.859  19.150  24.886  1.00 24.83           O  
ATOM   2177  CB  LEU A 336      -1.825  21.242  26.847  1.00 25.26           C  
ATOM   2178  CG  LEU A 336      -1.793  22.663  27.410  1.00 38.20           C  
ATOM   2179  CD1 LEU A 336      -1.263  22.610  28.849  1.00 45.90           C  
ATOM   2180  CD2 LEU A 336      -0.921  23.565  26.562  1.00 29.53           C  
ATOM   2181  N   GLU A 337      -0.380  21.124  23.879  1.00 23.64           N  
ATOM   2182  CA  GLU A 337       0.785  20.644  23.154  1.00 23.61           C  
ATOM   2183  C   GLU A 337       1.995  20.944  24.039  1.00 25.80           C  
ATOM   2184  O   GLU A 337       2.429  22.093  24.131  1.00 30.73           O  
ATOM   2185  CB  GLU A 337       0.952  21.383  21.822  1.00 20.67           C  
ATOM   2186  CG  GLU A 337      -0.306  21.508  20.962  1.00 30.25           C  
ATOM   2187  CD  GLU A 337       0.017  21.666  19.472  1.00 30.55           C  
ATOM   2188  OE1 GLU A 337       0.954  22.421  19.131  1.00 35.55           O  
ATOM   2189  OE2 GLU A 337      -0.667  21.034  18.640  1.00 23.51           O  
ATOM   2190  N   LEU A 338       2.530  19.915  24.687  1.00 27.47           N  
ATOM   2191  CA  LEU A 338       3.684  20.056  25.576  1.00 26.31           C  
ATOM   2192  C   LEU A 338       5.037  19.944  24.876  1.00 28.01           C  
ATOM   2193  O   LEU A 338       6.040  20.467  25.369  1.00 30.57           O  
ATOM   2194  CB  LEU A 338       3.627  18.992  26.674  1.00 27.20           C  
ATOM   2195  CG  LEU A 338       2.751  19.236  27.900  1.00 28.08           C  
ATOM   2196  CD1 LEU A 338       1.449  19.881  27.491  1.00 34.94           C  
ATOM   2197  CD2 LEU A 338       2.526  17.924  28.621  1.00 24.45           C  
ATOM   2198  N   GLY A 339       5.072  19.243  23.747  1.00 24.74           N  
ATOM   2199  CA  GLY A 339       6.322  19.060  23.025  1.00 33.19           C  
ATOM   2200  C   GLY A 339       7.315  18.192  23.789  1.00 33.29           C  
ATOM   2201  O   GLY A 339       7.095  17.868  24.956  1.00 29.88           O  
ATOM   2202  N   ARG A 340       8.408  17.815  23.128  1.00 39.94           N  
ATOM   2203  CA  ARG A 340       9.447  16.986  23.742  1.00 40.30           C  
ATOM   2204  C   ARG A 340      10.507  17.854  24.415  1.00 32.86           C  
ATOM   2205  O   ARG A 340      10.908  17.582  25.539  1.00 29.20           O  
ATOM   2206  CB  ARG A 340      10.123  16.112  22.688  1.00 47.88           C  
ATOM   2207  CG  ARG A 340       9.222  15.085  22.044  1.00 51.92           C  
ATOM   2208  CD  ARG A 340       9.908  14.427  20.856  1.00 61.10           C  
ATOM   2209  NE  ARG A 340      10.146  15.368  19.756  1.00 71.23           N  
ATOM   2210  CZ  ARG A 340      11.208  16.165  19.639  1.00 73.83           C  
ATOM   2211  NH1 ARG A 340      12.164  16.154  20.561  1.00 73.40           N  
ATOM   2212  NH2 ARG A 340      11.315  16.968  18.586  1.00 70.05           N  
ATOM   2213  N   SER A 341      10.974  18.880  23.710  1.00 28.40           N  
ATOM   2214  CA  SER A 341      11.967  19.790  24.262  1.00 33.47           C  
ATOM   2215  C   SER A 341      11.546  21.230  23.977  1.00 36.34           C  
ATOM   2216  O   SER A 341      10.627  21.469  23.192  1.00 33.14           O  
ATOM   2217  CB  SER A 341      13.345  19.536  23.653  1.00 27.32           C  
ATOM   2218  OG  SER A 341      13.348  19.870  22.278  1.00 42.65           O  
ATOM   2219  N   SER A 342      12.229  22.179  24.612  1.00 37.86           N  
ATOM   2220  CA  SER A 342      11.930  23.597  24.449  1.00 38.37           C  
ATOM   2221  C   SER A 342      11.962  24.058  22.999  1.00 38.52           C  
ATOM   2222  O   SER A 342      11.357  25.072  22.653  1.00 38.97           O  
ATOM   2223  CB  SER A 342      12.916  24.431  25.260  1.00 35.28           C  
ATOM   2224  OG  SER A 342      12.657  25.809  25.080  1.00 45.35           O  
ATOM   2225  N   ALA A 343      12.672  23.314  22.158  1.00 38.80           N  
ATOM   2226  CA  ALA A 343      12.784  23.647  20.745  1.00 37.69           C  
ATOM   2227  C   ALA A 343      11.459  23.474  20.007  1.00 33.69           C  
ATOM   2228  O   ALA A 343      11.228  24.113  18.984  1.00 36.61           O  
ATOM   2229  CB  ALA A 343      13.860  22.785  20.092  1.00 44.42           C  
ATOM   2230  N   ASP A 344      10.588  22.614  20.518  1.00 34.44           N  
ATOM   2231  CA  ASP A 344       9.300  22.396  19.869  1.00 33.72           C  
ATOM   2232  C   ASP A 344       8.230  23.372  20.364  1.00 32.19           C  
ATOM   2233  O   ASP A 344       7.118  23.374  19.851  1.00 35.62           O  
ATOM   2234  CB  ASP A 344       8.810  20.961  20.112  1.00 41.89           C  
ATOM   2235  CG  ASP A 344       9.791  19.903  19.608  1.00 42.97           C  
ATOM   2236  OD1 ASP A 344      10.115  19.901  18.395  1.00 39.40           O  
ATOM   2237  OD2 ASP A 344      10.228  19.072  20.436  1.00 38.34           O  
ATOM   2238  N   VAL A 345       8.576  24.210  21.337  1.00 26.25           N  
ATOM   2239  CA  VAL A 345       7.624  25.148  21.923  1.00 23.16           C  
ATOM   2240  C   VAL A 345       7.855  26.637  21.597  1.00 25.23           C  
ATOM   2241  O   VAL A 345       8.896  27.208  21.941  1.00 25.66           O  
ATOM   2242  CB  VAL A 345       7.614  24.946  23.461  1.00 16.71           C  
ATOM   2243  CG1 VAL A 345       6.594  25.852  24.121  1.00  7.29           C  
ATOM   2244  CG2 VAL A 345       7.318  23.488  23.772  1.00 16.85           C  
ATOM   2245  N   PRO A 346       6.879  27.283  20.930  1.00 20.33           N  
ATOM   2246  CA  PRO A 346       6.959  28.702  20.560  1.00 23.41           C  
ATOM   2247  C   PRO A 346       7.335  29.555  21.780  1.00 22.76           C  
ATOM   2248  O   PRO A 346       6.648  29.516  22.800  1.00 20.63           O  
ATOM   2249  CB  PRO A 346       5.545  29.008  20.063  1.00 18.83           C  
ATOM   2250  CG  PRO A 346       5.098  27.708  19.501  1.00 16.65           C  
ATOM   2251  CD  PRO A 346       5.571  26.724  20.545  1.00 22.88           C  
ATOM   2252  N   GLY A 347       8.418  30.322  21.668  1.00 26.62           N  
ATOM   2253  CA  GLY A 347       8.860  31.144  22.783  1.00 18.73           C  
ATOM   2254  C   GLY A 347       9.580  32.400  22.333  1.00 20.30           C  
ATOM   2255  O   GLY A 347      10.049  32.472  21.201  1.00 25.45           O  
ATOM   2256  N   ALA A 348       9.669  33.391  23.219  1.00 21.80           N  
ATOM   2257  CA  ALA A 348      10.326  34.656  22.898  1.00 20.37           C  
ATOM   2258  C   ALA A 348      10.754  35.393  24.153  1.00 18.57           C  
ATOM   2259  O   ALA A 348      10.236  35.140  25.241  1.00 23.55           O  
ATOM   2260  CB  ALA A 348       9.388  35.540  22.087  1.00 13.74           C  
ATOM   2261  N   TRP A 349      11.700  36.309  24.003  1.00 17.31           N  
ATOM   2262  CA  TRP A 349      12.152  37.090  25.148  1.00 24.79           C  
ATOM   2263  C   TRP A 349      11.433  38.436  25.185  1.00 21.74           C  
ATOM   2264  O   TRP A 349      11.409  39.166  24.192  1.00 21.45           O  
ATOM   2265  CB  TRP A 349      13.667  37.326  25.090  1.00 22.83           C  
ATOM   2266  CG  TRP A 349      14.490  36.118  25.396  1.00 24.51           C  
ATOM   2267  CD1 TRP A 349      14.976  35.199  24.505  1.00 21.21           C  
ATOM   2268  CD2 TRP A 349      14.943  35.704  26.688  1.00 22.64           C  
ATOM   2269  NE1 TRP A 349      15.710  34.245  25.166  1.00 22.82           N  
ATOM   2270  CE2 TRP A 349      15.706  34.530  26.507  1.00 29.04           C  
ATOM   2271  CE3 TRP A 349      14.781  36.213  27.982  1.00 26.38           C  
ATOM   2272  CZ2 TRP A 349      16.308  33.854  27.577  1.00 32.78           C  
ATOM   2273  CZ3 TRP A 349      15.381  35.540  29.050  1.00 31.71           C  
ATOM   2274  CH2 TRP A 349      16.134  34.375  28.839  1.00 25.75           C  
ATOM   2275  N   LEU A 350      10.836  38.754  26.327  1.00 20.61           N  
ATOM   2276  CA  LEU A 350      10.143  40.024  26.484  1.00 18.73           C  
ATOM   2277  C   LEU A 350      10.870  40.876  27.498  1.00 20.04           C  
ATOM   2278  O   LEU A 350      11.364  40.372  28.510  1.00 19.69           O  
ATOM   2279  CB  LEU A 350       8.696  39.834  26.948  1.00 19.73           C  
ATOM   2280  CG  LEU A 350       7.662  39.385  25.898  1.00 24.49           C  
ATOM   2281  CD1 LEU A 350       7.837  37.898  25.606  1.00 25.40           C  
ATOM   2282  CD2 LEU A 350       6.257  39.646  26.439  1.00 26.73           C  
ATOM   2283  N   ALA A 351      10.962  42.169  27.210  1.00 21.20           N  
ATOM   2284  CA  ALA A 351      11.615  43.078  28.126  1.00 17.69           C  
ATOM   2285  C   ALA A 351      10.695  43.291  29.308  1.00 18.57           C  
ATOM   2286  O   ALA A 351       9.471  43.229  29.186  1.00 20.87           O  
ATOM   2287  CB  ALA A 351      11.909  44.416  27.450  1.00 16.00           C  
ATOM   2288  N   LEU A 352      11.318  43.518  30.454  1.00 15.03           N  
ATOM   2289  CA  LEU A 352      10.636  43.782  31.698  1.00 11.83           C  
ATOM   2290  C   LEU A 352      11.189  45.127  32.154  1.00 16.98           C  
ATOM   2291  O   LEU A 352      12.332  45.224  32.608  1.00 18.74           O  
ATOM   2292  CB  LEU A 352      10.955  42.689  32.713  1.00  8.86           C  
ATOM   2293  CG  LEU A 352       9.782  41.751  32.982  1.00 13.04           C  
ATOM   2294  CD1 LEU A 352       9.235  41.211  31.672  1.00 11.71           C  
ATOM   2295  CD2 LEU A 352      10.222  40.624  33.892  1.00 16.28           C  
ATOM   2296  N   PRO A 353      10.396  46.195  31.993  1.00 15.44           N  
ATOM   2297  CA  PRO A 353      10.885  47.506  32.414  1.00 11.38           C  
ATOM   2298  C   PRO A 353      11.138  47.497  33.925  1.00 18.54           C  
ATOM   2299  O   PRO A 353      10.301  47.033  34.704  1.00 10.60           O  
ATOM   2300  CB  PRO A 353       9.748  48.446  32.006  1.00 16.86           C  
ATOM   2301  CG  PRO A 353       9.042  47.701  30.881  1.00 10.92           C  
ATOM   2302  CD  PRO A 353       9.051  46.292  31.396  1.00 10.89           C  
ATOM   2303  N   GLY A 354      12.299  48.001  34.328  1.00 23.96           N  
ATOM   2304  CA  GLY A 354      12.644  48.032  35.738  1.00 23.01           C  
ATOM   2305  C   GLY A 354      12.705  46.642  36.348  1.00 28.13           C  
ATOM   2306  O   GLY A 354      12.831  46.509  37.558  1.00 35.74           O  
ATOM   2307  N   GLY A 355      12.613  45.608  35.518  1.00 23.37           N  
ATOM   2308  CA  GLY A 355      12.660  44.251  36.022  1.00 16.80           C  
ATOM   2309  C   GLY A 355      11.347  43.791  36.620  1.00 18.68           C  
ATOM   2310  O   GLY A 355      11.265  42.693  37.165  1.00 17.64           O  
ATOM   2311  N   ARG A 356      10.322  44.635  36.519  1.00 19.93           N  
ATOM   2312  CA  ARG A 356       8.990  44.341  37.052  1.00 21.44           C  
ATOM   2313  C   ARG A 356       8.066  43.722  36.007  1.00 25.89           C  
ATOM   2314  O   ARG A 356       7.706  44.369  35.019  1.00 33.39           O  
ATOM   2315  CB  ARG A 356       8.356  45.621  37.595  1.00 29.09           C  
ATOM   2316  CG  ARG A 356       8.791  45.986  39.000  1.00 28.86           C  
ATOM   2317  CD  ARG A 356       8.385  47.405  39.364  1.00 40.37           C  
ATOM   2318  NE  ARG A 356       6.992  47.718  39.044  1.00 44.66           N  
ATOM   2319  CZ  ARG A 356       5.936  47.084  39.544  1.00 54.87           C  
ATOM   2320  NH1 ARG A 356       6.099  46.080  40.398  1.00 49.26           N  
ATOM   2321  NH2 ARG A 356       4.717  47.471  39.195  1.00 58.89           N  
ATOM   2322  N   PRO A 357       7.649  42.463  36.229  1.00 22.62           N  
ATOM   2323  CA  PRO A 357       6.770  41.705  35.335  1.00 21.95           C  
ATOM   2324  C   PRO A 357       5.473  42.411  34.951  1.00 25.06           C  
ATOM   2325  O   PRO A 357       4.878  42.116  33.911  1.00 26.76           O  
ATOM   2326  CB  PRO A 357       6.497  40.426  36.124  1.00 19.64           C  
ATOM   2327  CG  PRO A 357       7.729  40.264  36.939  1.00 23.62           C  
ATOM   2328  CD  PRO A 357       7.960  41.670  37.431  1.00 18.93           C  
ATOM   2329  N   ASP A 358       5.042  43.337  35.800  1.00 27.47           N  
ATOM   2330  CA  ASP A 358       3.804  44.079  35.583  1.00 28.98           C  
ATOM   2331  C   ASP A 358       4.020  45.560  35.246  1.00 29.74           C  
ATOM   2332  O   ASP A 358       3.109  46.379  35.389  1.00 26.68           O  
ATOM   2333  CB  ASP A 358       2.929  43.955  36.833  1.00 28.87           C  
ATOM   2334  CG  ASP A 358       3.583  44.568  38.066  1.00 38.21           C  
ATOM   2335  OD1 ASP A 358       4.830  44.515  38.169  1.00 32.26           O  
ATOM   2336  OD2 ASP A 358       2.852  45.093  38.937  1.00 44.40           O  
ATOM   2337  N   ALA A 359       5.224  45.909  34.808  1.00 23.22           N  
ATOM   2338  CA  ALA A 359       5.510  47.297  34.460  1.00 21.92           C  
ATOM   2339  C   ALA A 359       5.060  47.545  33.024  1.00 19.25           C  
ATOM   2340  O   ALA A 359       5.217  46.689  32.163  1.00 22.38           O  
ATOM   2341  CB  ALA A 359       7.012  47.587  34.610  1.00 23.41           C  
ATOM   2342  N   PRO A 360       4.516  48.735  32.744  1.00 16.13           N  
ATOM   2343  CA  PRO A 360       4.034  49.106  31.412  1.00 13.83           C  
ATOM   2344  C   PRO A 360       5.116  49.553  30.426  1.00 15.75           C  
ATOM   2345  O   PRO A 360       6.294  49.644  30.777  1.00 17.12           O  
ATOM   2346  CB  PRO A 360       3.080  50.246  31.730  1.00 13.31           C  
ATOM   2347  CG  PRO A 360       3.860  50.985  32.780  1.00  6.30           C  
ATOM   2348  CD  PRO A 360       4.318  49.854  33.690  1.00 12.60           C  
ATOM   2349  N   PRO A 361       4.713  49.826  29.170  1.00 10.02           N  
ATOM   2350  CA  PRO A 361       5.616  50.282  28.113  1.00  6.97           C  
ATOM   2351  C   PRO A 361       6.145  51.645  28.548  1.00 18.45           C  
ATOM   2352  O   PRO A 361       5.460  52.383  29.263  1.00 21.07           O  
ATOM   2353  CB  PRO A 361       4.699  50.386  26.901  1.00 13.31           C  
ATOM   2354  CG  PRO A 361       3.705  49.281  27.144  1.00 13.99           C  
ATOM   2355  CD  PRO A 361       3.399  49.458  28.609  1.00 12.54           C  
ATOM   2356  N   GLN A 362       7.350  51.994  28.119  1.00 16.39           N  
ATOM   2357  CA  GLN A 362       7.938  53.272  28.509  1.00 15.83           C  
ATOM   2358  C   GLN A 362       9.095  53.662  27.596  1.00 16.10           C  
ATOM   2359  O   GLN A 362       9.591  52.860  26.807  1.00 16.72           O  
ATOM   2360  CB  GLN A 362       8.469  53.190  29.949  1.00  8.20           C  
ATOM   2361  CG  GLN A 362       9.583  52.143  30.136  1.00 12.70           C  
ATOM   2362  CD  GLN A 362      10.377  52.298  31.428  1.00 20.40           C  
ATOM   2363  OE1 GLN A 362       9.863  52.074  32.535  1.00 16.55           O  
ATOM   2364  NE2 GLN A 362      11.645  52.685  31.292  1.00 16.81           N  
ATOM   2365  N   ALA A 363       9.527  54.905  27.721  1.00  9.48           N  
ATOM   2366  CA  ALA A 363      10.650  55.392  26.949  1.00 15.40           C  
ATOM   2367  C   ALA A 363      11.495  56.289  27.864  1.00 16.68           C  
ATOM   2368  O   ALA A 363      11.014  56.785  28.886  1.00 17.71           O  
ATOM   2369  CB  ALA A 363      10.154  56.176  25.747  1.00 21.04           C  
ATOM   2370  N   GLU A 364      12.754  56.491  27.513  1.00 18.13           N  
ATOM   2371  CA  GLU A 364      13.591  57.339  28.319  1.00 16.98           C  
ATOM   2372  C   GLU A 364      14.801  57.762  27.502  1.00 22.03           C  
ATOM   2373  O   GLU A 364      15.231  57.044  26.603  1.00 26.20           O  
ATOM   2374  CB  GLU A 364      14.015  56.585  29.581  1.00 27.14           C  
ATOM   2375  CG  GLU A 364      14.987  55.452  29.338  1.00 28.38           C  
ATOM   2376  CD  GLU A 364      15.136  54.537  30.550  1.00 34.81           C  
ATOM   2377  OE1 GLU A 364      15.385  55.041  31.679  1.00 36.60           O  
ATOM   2378  OE2 GLU A 364      15.011  53.306  30.363  1.00 18.31           O  
ATOM   2379  N   GLU A 365      15.337  58.940  27.789  1.00 18.96           N  
ATOM   2380  CA  GLU A 365      16.507  59.404  27.065  1.00 19.96           C  
ATOM   2381  C   GLU A 365      17.697  59.169  27.998  1.00 24.46           C  
ATOM   2382  O   GLU A 365      17.913  59.921  28.945  1.00 22.92           O  
ATOM   2383  CB  GLU A 365      16.353  60.889  26.705  1.00 17.49           C  
ATOM   2384  CG  GLU A 365      17.366  61.385  25.668  1.00 27.81           C  
ATOM   2385  CD  GLU A 365      17.278  62.889  25.375  1.00 34.48           C  
ATOM   2386  OE1 GLU A 365      16.785  63.651  26.239  1.00 28.57           O  
ATOM   2387  OE2 GLU A 365      17.724  63.307  24.279  1.00 35.78           O  
ATOM   2388  N   LEU A 366      18.441  58.096  27.728  1.00 23.99           N  
ATOM   2389  CA  LEU A 366      19.600  57.702  28.523  1.00 22.36           C  
ATOM   2390  C   LEU A 366      20.827  58.571  28.284  1.00 25.42           C  
ATOM   2391  O   LEU A 366      21.833  58.455  28.982  1.00 28.38           O  
ATOM   2392  CB  LEU A 366      19.962  56.243  28.233  1.00 24.10           C  
ATOM   2393  CG  LEU A 366      18.877  55.210  28.548  1.00 18.59           C  
ATOM   2394  CD1 LEU A 366      19.355  53.790  28.159  1.00 13.58           C  
ATOM   2395  CD2 LEU A 366      18.553  55.291  30.020  1.00  5.17           C  
ATOM   2396  N   ALA A 367      20.734  59.443  27.293  1.00 22.97           N  
ATOM   2397  CA  ALA A 367      21.819  60.341  26.952  1.00 15.89           C  
ATOM   2398  C   ALA A 367      21.309  61.234  25.841  1.00 26.89           C  
ATOM   2399  O   ALA A 367      20.329  60.911  25.165  1.00 34.35           O  
ATOM   2400  CB  ALA A 367      23.025  59.554  26.484  1.00 14.93           C  
ATOM   2401  N   PRO A 368      21.968  62.372  25.629  1.00 29.49           N  
ATOM   2402  CA  PRO A 368      21.533  63.284  24.574  1.00 28.92           C  
ATOM   2403  C   PRO A 368      21.262  62.572  23.248  1.00 25.31           C  
ATOM   2404  O   PRO A 368      22.148  61.932  22.685  1.00 20.49           O  
ATOM   2405  CB  PRO A 368      22.690  64.272  24.499  1.00 32.37           C  
ATOM   2406  CG  PRO A 368      23.095  64.391  25.951  1.00 28.54           C  
ATOM   2407  CD  PRO A 368      23.111  62.931  26.376  1.00 29.72           C  
ATOM   2408  N   GLY A 369      20.022  62.681  22.775  1.00 20.46           N  
ATOM   2409  CA  GLY A 369      19.635  62.068  21.518  1.00 22.16           C  
ATOM   2410  C   GLY A 369      19.485  60.555  21.521  1.00 24.81           C  
ATOM   2411  O   GLY A 369      19.181  59.964  20.484  1.00 21.68           O  
ATOM   2412  N   LEU A 370      19.696  59.932  22.679  1.00 20.10           N  
ATOM   2413  CA  LEU A 370      19.589  58.481  22.811  1.00 24.38           C  
ATOM   2414  C   LEU A 370      18.371  58.049  23.636  1.00 24.53           C  
ATOM   2415  O   LEU A 370      18.287  58.350  24.830  1.00 25.15           O  
ATOM   2416  CB  LEU A 370      20.856  57.912  23.453  1.00 12.70           C  
ATOM   2417  CG  LEU A 370      20.923  56.389  23.490  1.00 15.79           C  
ATOM   2418  CD1 LEU A 370      21.035  55.871  22.053  1.00 19.00           C  
ATOM   2419  CD2 LEU A 370      22.120  55.934  24.297  1.00 20.35           C  
ATOM   2420  N   HIS A 371      17.439  57.343  22.997  1.00 21.92           N  
ATOM   2421  CA  HIS A 371      16.226  56.874  23.670  1.00 17.04           C  
ATOM   2422  C   HIS A 371      16.092  55.367  23.703  1.00 13.54           C  
ATOM   2423  O   HIS A 371      16.394  54.686  22.724  1.00 18.06           O  
ATOM   2424  CB  HIS A 371      14.976  57.439  23.000  1.00  9.44           C  
ATOM   2425  CG  HIS A 371      14.927  58.930  22.991  1.00 14.31           C  
ATOM   2426  ND1 HIS A 371      15.485  59.683  21.982  1.00 18.25           N  
ATOM   2427  CD2 HIS A 371      14.446  59.810  23.898  1.00 18.59           C  
ATOM   2428  CE1 HIS A 371      15.349  60.966  22.267  1.00 13.80           C  
ATOM   2429  NE2 HIS A 371      14.723  61.072  23.425  1.00 19.92           N  
ATOM   2430  N   LEU A 372      15.629  54.851  24.836  1.00 10.84           N  
ATOM   2431  CA  LEU A 372      15.410  53.420  24.987  1.00 15.32           C  
ATOM   2432  C   LEU A 372      13.901  53.171  25.084  1.00 13.89           C  
ATOM   2433  O   LEU A 372      13.261  53.558  26.060  1.00 20.10           O  
ATOM   2434  CB  LEU A 372      16.128  52.900  26.239  1.00 11.24           C  
ATOM   2435  CG  LEU A 372      15.815  51.457  26.665  1.00 19.69           C  
ATOM   2436  CD1 LEU A 372      16.231  50.473  25.581  1.00 16.63           C  
ATOM   2437  CD2 LEU A 372      16.553  51.157  27.955  1.00 21.20           C  
ATOM   2438  N   LEU A 373      13.350  52.528  24.057  1.00 16.49           N  
ATOM   2439  CA  LEU A 373      11.925  52.217  23.960  1.00 12.24           C  
ATOM   2440  C   LEU A 373      11.662  50.804  24.436  1.00 14.37           C  
ATOM   2441  O   LEU A 373      12.237  49.850  23.918  1.00 20.69           O  
ATOM   2442  CB  LEU A 373      11.465  52.344  22.500  1.00 15.52           C  
ATOM   2443  CG  LEU A 373       9.997  52.103  22.111  1.00 10.07           C  
ATOM   2444  CD1 LEU A 373       9.088  52.923  23.013  1.00 14.48           C  
ATOM   2445  CD2 LEU A 373       9.780  52.487  20.645  1.00  1.06           C  
ATOM   2446  N   LEU A 374      10.789  50.673  25.421  1.00 14.11           N  
ATOM   2447  CA  LEU A 374      10.449  49.366  25.951  1.00 13.54           C  
ATOM   2448  C   LEU A 374       8.953  49.128  25.814  1.00 11.59           C  
ATOM   2449  O   LEU A 374       8.141  50.029  26.060  1.00 14.21           O  
ATOM   2450  CB  LEU A 374      10.865  49.276  27.424  1.00  9.22           C  
ATOM   2451  CG  LEU A 374      12.189  48.588  27.788  1.00 15.24           C  
ATOM   2452  CD1 LEU A 374      13.220  48.818  26.725  1.00  1.59           C  
ATOM   2453  CD2 LEU A 374      12.674  49.080  29.148  1.00  1.27           C  
ATOM   2454  N   GLY A 375       8.613  47.910  25.402  1.00 12.39           N  
ATOM   2455  CA  GLY A 375       7.231  47.488  25.250  1.00  7.35           C  
ATOM   2456  C   GLY A 375       6.874  46.708  26.502  1.00  9.65           C  
ATOM   2457  O   GLY A 375       6.448  47.306  27.484  1.00 14.81           O  
ATOM   2458  N   GLY A 376       7.053  45.386  26.489  1.00  8.80           N  
ATOM   2459  CA  GLY A 376       6.754  44.597  27.678  1.00  9.98           C  
ATOM   2460  C   GLY A 376       5.415  43.871  27.723  1.00 15.63           C  
ATOM   2461  O   GLY A 376       4.591  44.026  26.819  1.00 17.23           O  
ATOM   2462  N   PRO A 377       5.159  43.090  28.791  1.00 13.68           N  
ATOM   2463  CA  PRO A 377       3.925  42.313  28.994  1.00 14.21           C  
ATOM   2464  C   PRO A 377       2.602  43.063  28.840  1.00 14.64           C  
ATOM   2465  O   PRO A 377       1.544  42.441  28.728  1.00 15.05           O  
ATOM   2466  CB  PRO A 377       4.101  41.732  30.404  1.00  9.03           C  
ATOM   2467  CG  PRO A 377       5.578  41.581  30.517  1.00 13.82           C  
ATOM   2468  CD  PRO A 377       6.091  42.883  29.916  1.00 10.41           C  
ATOM   2469  N   LEU A 378       2.641  44.390  28.833  1.00 13.88           N  
ATOM   2470  CA  LEU A 378       1.387  45.131  28.676  1.00 21.34           C  
ATOM   2471  C   LEU A 378       1.318  45.853  27.329  1.00 18.91           C  
ATOM   2472  O   LEU A 378       0.375  46.604  27.062  1.00 16.46           O  
ATOM   2473  CB  LEU A 378       1.193  46.141  29.819  1.00 16.75           C  
ATOM   2474  CG  LEU A 378       1.016  45.571  31.239  1.00 17.53           C  
ATOM   2475  CD1 LEU A 378       0.973  46.711  32.225  1.00 14.72           C  
ATOM   2476  CD2 LEU A 378      -0.242  44.738  31.348  1.00 19.78           C  
ATOM   2477  N   ALA A 379       2.291  45.582  26.465  1.00  8.49           N  
ATOM   2478  CA  ALA A 379       2.338  46.229  25.161  1.00 14.60           C  
ATOM   2479  C   ALA A 379       1.046  46.140  24.341  1.00 15.76           C  
ATOM   2480  O   ALA A 379       0.766  47.025  23.534  1.00 11.38           O  
ATOM   2481  CB  ALA A 379       3.509  45.695  24.350  1.00 16.14           C  
ATOM   2482  N   ASP A 380       0.256  45.092  24.529  1.00  7.36           N  
ATOM   2483  CA  ASP A 380      -0.977  44.993  23.764  1.00 16.09           C  
ATOM   2484  C   ASP A 380      -1.981  46.089  24.157  1.00 15.40           C  
ATOM   2485  O   ASP A 380      -2.781  46.528  23.328  1.00  9.31           O  
ATOM   2486  CB  ASP A 380      -1.600  43.588  23.911  1.00 16.09           C  
ATOM   2487  CG  ASP A 380      -0.690  42.471  23.343  1.00 26.86           C  
ATOM   2488  OD1 ASP A 380      -0.138  42.644  22.222  1.00 12.86           O  
ATOM   2489  OD2 ASP A 380      -0.541  41.420  24.018  1.00 21.79           O  
ATOM   2490  N   THR A 381      -1.930  46.554  25.402  1.00 17.96           N  
ATOM   2491  CA  THR A 381      -2.862  47.597  25.835  1.00 19.81           C  
ATOM   2492  C   THR A 381      -2.279  49.009  25.812  1.00 15.58           C  
ATOM   2493  O   THR A 381      -3.015  49.982  25.664  1.00 15.15           O  
ATOM   2494  CB  THR A 381      -3.377  47.326  27.267  1.00 13.61           C  
ATOM   2495  OG1 THR A 381      -4.018  46.045  27.314  1.00 18.63           O  
ATOM   2496  CG2 THR A 381      -4.379  48.403  27.696  1.00  6.06           C  
ATOM   2497  N   LEU A 382      -0.959  49.108  25.936  1.00 17.16           N  
ATOM   2498  CA  LEU A 382      -0.285  50.401  26.006  1.00 17.20           C  
ATOM   2499  C   LEU A 382       0.882  50.640  25.032  1.00 15.27           C  
ATOM   2500  O   LEU A 382       1.498  51.704  25.074  1.00 18.63           O  
ATOM   2501  CB  LEU A 382       0.239  50.577  27.434  1.00 16.42           C  
ATOM   2502  CG  LEU A 382      -0.740  50.299  28.584  1.00 15.85           C  
ATOM   2503  CD1 LEU A 382       0.016  50.144  29.897  1.00 10.40           C  
ATOM   2504  CD2 LEU A 382      -1.749  51.411  28.673  1.00 14.24           C  
ATOM   2505  N   GLY A 383       1.187  49.671  24.169  1.00 13.06           N  
ATOM   2506  CA  GLY A 383       2.315  49.801  23.247  1.00  7.73           C  
ATOM   2507  C   GLY A 383       2.379  50.993  22.299  1.00  7.17           C  
ATOM   2508  O   GLY A 383       3.360  51.729  22.305  1.00  5.80           O  
ATOM   2509  N   LEU A 384       1.357  51.179  21.469  1.00  9.65           N  
ATOM   2510  CA  LEU A 384       1.343  52.293  20.527  1.00 14.39           C  
ATOM   2511  C   LEU A 384       1.550  53.633  21.226  1.00 15.49           C  
ATOM   2512  O   LEU A 384       2.391  54.426  20.815  1.00 15.82           O  
ATOM   2513  CB  LEU A 384       0.023  52.320  19.742  1.00 14.26           C  
ATOM   2514  CG  LEU A 384      -0.199  51.176  18.744  1.00 19.10           C  
ATOM   2515  CD1 LEU A 384      -1.632  51.202  18.158  1.00 18.19           C  
ATOM   2516  CD2 LEU A 384       0.826  51.322  17.633  1.00 14.50           C  
ATOM   2517  N   ALA A 385       0.799  53.863  22.301  1.00 15.04           N  
ATOM   2518  CA  ALA A 385       0.875  55.110  23.054  1.00 10.91           C  
ATOM   2519  C   ALA A 385       2.296  55.496  23.413  1.00  9.45           C  
ATOM   2520  O   ALA A 385       2.689  56.658  23.252  1.00 12.29           O  
ATOM   2521  CB  ALA A 385       0.028  55.008  24.321  1.00 14.50           C  
ATOM   2522  N   ALA A 386       3.074  54.534  23.899  1.00  8.20           N  
ATOM   2523  CA  ALA A 386       4.455  54.828  24.284  1.00 13.45           C  
ATOM   2524  C   ALA A 386       5.333  55.146  23.072  1.00 13.96           C  
ATOM   2525  O   ALA A 386       6.275  55.932  23.182  1.00 15.59           O  
ATOM   2526  CB  ALA A 386       5.039  53.665  25.093  1.00  1.03           C  
ATOM   2527  N   ALA A 387       5.022  54.553  21.918  1.00 15.54           N  
ATOM   2528  CA  ALA A 387       5.806  54.826  20.709  1.00 14.05           C  
ATOM   2529  C   ALA A 387       5.434  56.192  20.140  1.00 11.68           C  
ATOM   2530  O   ALA A 387       6.279  56.890  19.591  1.00 15.10           O  
ATOM   2531  CB  ALA A 387       5.573  53.736  19.656  1.00 11.49           C  
ATOM   2532  N   HIS A 388       4.168  56.566  20.273  1.00 10.63           N  
ATOM   2533  CA  HIS A 388       3.707  57.855  19.777  1.00 13.58           C  
ATOM   2534  C   HIS A 388       4.198  59.011  20.649  1.00 20.66           C  
ATOM   2535  O   HIS A 388       4.529  60.080  20.142  1.00 23.40           O  
ATOM   2536  CB  HIS A 388       2.187  57.883  19.724  1.00 15.78           C  
ATOM   2537  CG  HIS A 388       1.627  59.198  19.284  1.00 21.14           C  
ATOM   2538  ND1 HIS A 388       0.986  60.062  20.147  1.00 22.09           N  
ATOM   2539  CD2 HIS A 388       1.614  59.798  18.070  1.00 20.36           C  
ATOM   2540  CE1 HIS A 388       0.598  61.135  19.481  1.00 16.60           C  
ATOM   2541  NE2 HIS A 388       0.967  61.001  18.220  1.00 17.68           N  
ATOM   2542  N   GLU A 389       4.221  58.782  21.961  1.00 20.57           N  
ATOM   2543  CA  GLU A 389       4.674  59.758  22.946  1.00 17.82           C  
ATOM   2544  C   GLU A 389       6.145  60.055  22.645  1.00 16.32           C  
ATOM   2545  O   GLU A 389       6.557  61.212  22.603  1.00 17.14           O  
ATOM   2546  CB  GLU A 389       4.512  59.156  24.354  1.00 24.16           C  
ATOM   2547  CG  GLU A 389       4.504  60.115  25.548  1.00 38.56           C  
ATOM   2548  CD  GLU A 389       5.900  60.547  26.014  1.00 44.83           C  
ATOM   2549  OE1 GLU A 389       6.824  59.705  26.019  1.00 37.00           O  
ATOM   2550  OE2 GLU A 389       6.064  61.731  26.396  1.00 44.96           O  
ATOM   2551  N   LEU A 390       6.930  59.010  22.400  1.00 15.73           N  
ATOM   2552  CA  LEU A 390       8.346  59.192  22.106  1.00 12.57           C  
ATOM   2553  C   LEU A 390       8.528  59.924  20.793  1.00 16.58           C  
ATOM   2554  O   LEU A 390       9.431  60.756  20.661  1.00 17.59           O  
ATOM   2555  CB  LEU A 390       9.079  57.848  22.038  1.00 11.94           C  
ATOM   2556  CG  LEU A 390      10.547  57.960  21.605  1.00 11.14           C  
ATOM   2557  CD1 LEU A 390      11.302  58.849  22.587  1.00  1.03           C  
ATOM   2558  CD2 LEU A 390      11.179  56.580  21.504  1.00  3.08           C  
ATOM   2559  N   ALA A 391       7.678  59.615  19.819  1.00 11.29           N  
ATOM   2560  CA  ALA A 391       7.765  60.270  18.516  1.00 18.55           C  
ATOM   2561  C   ALA A 391       7.528  61.773  18.647  1.00 18.84           C  
ATOM   2562  O   ALA A 391       8.265  62.574  18.068  1.00 23.13           O  
ATOM   2563  CB  ALA A 391       6.762  59.657  17.540  1.00 12.23           C  
ATOM   2564  N   GLN A 392       6.505  62.149  19.417  1.00 26.53           N  
ATOM   2565  CA  GLN A 392       6.180  63.555  19.636  1.00 22.34           C  
ATOM   2566  C   GLN A 392       7.382  64.291  20.220  1.00 24.69           C  
ATOM   2567  O   GLN A 392       7.814  65.308  19.681  1.00 32.68           O  
ATOM   2568  CB  GLN A 392       4.974  63.689  20.579  1.00 15.56           C  
ATOM   2569  CG  GLN A 392       3.624  63.393  19.917  1.00 21.71           C  
ATOM   2570  CD  GLN A 392       2.435  63.399  20.899  1.00 32.50           C  
ATOM   2571  OE1 GLN A 392       2.382  62.589  21.832  1.00 30.44           O  
ATOM   2572  NE2 GLN A 392       1.472  64.305  20.676  1.00 18.97           N  
ATOM   2573  N   ARG A 393       7.934  63.765  21.308  1.00 24.57           N  
ATOM   2574  CA  ARG A 393       9.080  64.397  21.950  1.00 24.04           C  
ATOM   2575  C   ARG A 393      10.299  64.509  21.037  1.00 27.20           C  
ATOM   2576  O   ARG A 393      10.949  65.551  20.999  1.00 33.41           O  
ATOM   2577  CB  ARG A 393       9.438  63.657  23.250  1.00 29.67           C  
ATOM   2578  CG  ARG A 393       8.363  63.828  24.333  1.00 30.68           C  
ATOM   2579  CD  ARG A 393       8.764  63.301  25.717  1.00 32.16           C  
ATOM   2580  NE  ARG A 393       8.780  61.843  25.793  1.00 29.56           N  
ATOM   2581  CZ  ARG A 393       9.879  61.107  25.695  1.00 32.20           C  
ATOM   2582  NH1 ARG A 393      11.050  61.709  25.517  1.00 25.60           N  
ATOM   2583  NH2 ARG A 393       9.804  59.780  25.779  1.00 12.69           N  
ATOM   2584  N   VAL A 394      10.600  63.455  20.287  1.00 22.63           N  
ATOM   2585  CA  VAL A 394      11.749  63.478  19.389  1.00 14.95           C  
ATOM   2586  C   VAL A 394      11.536  64.518  18.295  1.00 24.56           C  
ATOM   2587  O   VAL A 394      12.448  65.265  17.920  1.00 16.78           O  
ATOM   2588  CB  VAL A 394      11.966  62.091  18.737  1.00 12.67           C  
ATOM   2589  CG1 VAL A 394      13.048  62.172  17.661  1.00  8.83           C  
ATOM   2590  CG2 VAL A 394      12.366  61.087  19.796  1.00 11.37           C  
ATOM   2591  N   SER A 395      10.311  64.560  17.790  1.00 23.42           N  
ATOM   2592  CA  SER A 395       9.946  65.494  16.740  1.00 25.40           C  
ATOM   2593  C   SER A 395      10.068  66.952  17.224  1.00 28.41           C  
ATOM   2594  O   SER A 395      10.556  67.815  16.496  1.00 28.73           O  
ATOM   2595  CB  SER A 395       8.522  65.179  16.275  1.00 19.46           C  
ATOM   2596  OG  SER A 395       8.080  66.092  15.292  1.00 32.57           O  
ATOM   2597  N   ALA A 396       9.637  67.220  18.455  1.00 29.14           N  
ATOM   2598  CA  ALA A 396       9.715  68.562  19.023  1.00 27.93           C  
ATOM   2599  C   ALA A 396      11.161  69.034  19.199  1.00 31.23           C  
ATOM   2600  O   ALA A 396      11.514  70.132  18.766  1.00 32.91           O  
ATOM   2601  CB  ALA A 396       8.986  68.607  20.365  1.00 16.68           C  
ATOM   2602  N   SER A 397      12.001  68.215  19.831  1.00 33.67           N  
ATOM   2603  CA  SER A 397      13.395  68.604  20.045  1.00 33.86           C  
ATOM   2604  C   SER A 397      14.144  68.825  18.728  1.00 36.63           C  
ATOM   2605  O   SER A 397      15.206  69.448  18.707  1.00 36.54           O  
ATOM   2606  CB  SER A 397      14.131  67.585  20.938  1.00 29.24           C  
ATOM   2607  OG  SER A 397      13.823  66.245  20.613  1.00 40.95           O  
ATOM   2608  N   LEU A 398      13.573  68.333  17.629  1.00 40.43           N  
ATOM   2609  CA  LEU A 398      14.164  68.519  16.306  1.00 38.22           C  
ATOM   2610  C   LEU A 398      13.645  69.811  15.676  1.00 41.85           C  
ATOM   2611  O   LEU A 398      14.341  70.436  14.883  1.00 43.73           O  
ATOM   2612  CB  LEU A 398      13.835  67.335  15.389  1.00 29.20           C  
ATOM   2613  CG  LEU A 398      14.859  66.195  15.374  1.00 26.67           C  
ATOM   2614  CD1 LEU A 398      15.180  65.804  16.799  1.00 37.06           C  
ATOM   2615  CD2 LEU A 398      14.325  65.006  14.596  1.00 22.89           C  
ATOM   2616  N   GLU A 399      12.423  70.209  16.032  1.00 43.40           N  
ATOM   2617  CA  GLU A 399      11.833  71.429  15.490  1.00 45.14           C  
ATOM   2618  C   GLU A 399      12.434  72.638  16.214  1.00 47.88           C  
ATOM   2619  O   GLU A 399      13.511  73.126  15.851  1.00 51.36           O  
ATOM   2620  CB  GLU A 399      10.296  71.407  15.654  1.00 44.61           C  
ATOM   2621  CG  GLU A 399       9.591  70.209  14.957  1.00 60.43           C  
ATOM   2622  CD  GLU A 399       8.056  70.138  15.163  1.00 61.16           C  
ATOM   2623  OE1 GLU A 399       7.583  70.137  16.324  1.00 58.92           O  
ATOM   2624  OE2 GLU A 399       7.323  70.062  14.149  1.00 58.65           O  
TER    2625      GLU A 399                                                      
END
MOLECULE T0490.pdb
ATOM      1  N   THR     3      26.547  61.762   4.288  1.00 30.83           N  
ATOM      2  CA  THR     3      25.686  62.760   4.970  1.00 30.86           C  
ATOM      3  CB  THR     3      24.743  63.446   3.956  1.00 31.28           C  
ATOM      4  OG1 THR     3      23.857  62.472   3.394  1.00 33.76           O  
ATOM      5  CG2 THR     3      25.545  64.077   2.829  1.00 32.39           C  
ATOM      6  C   THR     3      24.875  62.112   6.108  1.00 29.87           C  
ATOM      7  O   THR     3      24.664  60.894   6.139  1.00 30.04      A    O  
ATOM      8  N   ASP     4      24.420  62.918   7.058  1.00 28.40      A    N  
ATOM      9  CA  ASP     4      23.613  62.360   8.116  1.00 26.82      A    C  
ATOM     10  CB  ASP     4      23.315  63.426   9.167  1.00 27.09      A    C  
ATOM     11  CG  ASP     4      24.568  63.956   9.804  1.00 27.99      A    C  
ATOM     12  OD1 ASP     4      25.591  63.256   9.689  1.00 27.47      A    O  
ATOM     13  OD2 ASP     4      24.539  65.052  10.415  1.00 27.69      A    O  
ATOM     14  C   ASP     4      22.302  61.824   7.536  1.00 25.43      A    C  
ATOM     15  O   ASP     4      21.692  62.460   6.668  1.00 25.65      A    O  
ATOM     16  N   ILE     5      21.883  60.651   7.993  1.00 22.86      A    N  
ATOM     17  CA  ILE     5      20.492  60.264   7.862  1.00 20.85      A    C  
ATOM     18  CB  ILE     5      20.306  58.784   8.160  1.00 21.43      A    C  
ATOM     19  CG1 ILE     5      21.076  57.962   7.130  1.00 21.60      A    C  
ATOM     20  CD1 ILE     5      21.089  56.510   7.429  1.00 24.74      A    C  
ATOM     21  CG2 ILE     5      18.821  58.422   8.197  1.00 20.64      A    C  
ATOM     22  C   ILE     5      19.787  61.060   8.943  1.00 19.56      A    C  
ATOM     23  O   ILE     5      20.360  61.305   9.993  1.00 19.01      A    O  
ATOM     24  N   ASP     6      18.561  61.493   8.697  1.00 17.68      A    N  
ATOM     25  CA  ASP     6      17.886  62.313   9.686  1.00 16.70      A    C  
ATOM     26  CB  ASP     6      16.604  62.919   9.115  1.00 17.32      A    C  
ATOM     27  CG  ASP     6      15.998  63.962  10.033  1.00 19.64      A    C  
ATOM     28  OD1 ASP     6      16.705  64.927  10.417  1.00 24.36      A    O  
ATOM     29  OD2 ASP     6      14.808  63.830  10.357  1.00 23.29      A    O  
ATOM     30  C   ASP     6      17.603  61.482  10.948  1.00 15.36      A    C  
ATOM     31  O   ASP     6      18.145  61.771  12.016  1.00 15.11      A    O  
ATOM     32  N   CYS     7      16.783  60.442  10.808  1.00 13.88      A    N  
ATOM     33  CA  CYS     7      16.381  59.596  11.951  1.00 13.17      A    C  
ATOM     34  CB  CYS     7      14.860  59.633  12.129  1.00 13.41      A    C  
ATOM     35  SG  CYS     7      14.137  61.228  12.616  1.00 16.56      A    S  
ATOM     36  C   CYS     7      16.756  58.134  11.726  1.00 12.09      A    C  
ATOM     37  O   CYS     7      16.460  57.589  10.666  1.00 12.24      A    O  
ATOM     38  N   ILE     8      17.398  57.503  12.711  1.00 10.67      A    N  
ATOM     39  CA  ILE     8      17.606  56.048  12.667  1.00  8.90      A    C  
ATOM     40  CB  ILE     8      19.105  55.697  12.732  1.00  9.01      A    C  
ATOM     41  CG1 ILE     8      19.794  56.208  11.453  1.00  9.20      A    C  
ATOM     42  CD1 ILE     8      21.275  55.875  11.355  1.00  9.32      A    C  
ATOM     43  CG2 ILE     8      19.326  54.187  12.879  1.00  8.23      A    C  
ATOM     44  C   ILE     8      16.821  55.421  13.821  1.00  8.24      A    C  
ATOM     45  O   ILE     8      16.911  55.882  14.954  1.00  9.14      A    O  
ATOM     46  N   VAL     9      16.027  54.403  13.517  1.00  8.44      A    N  
ATOM     47  CA  VAL     9      15.312  53.637  14.533  1.00  8.39      A    C  
ATOM     48  CB  VAL     9      13.837  53.445  14.168  1.00  9.16      A    C  
ATOM     49  CG1 VAL     9      13.112  52.551  15.201  1.00  8.57      A    C  
ATOM     50  CG2 VAL     9      13.157  54.814  14.075  1.00 10.05      A    C  
ATOM     51  C   VAL     9      15.979  52.270  14.583  1.00  8.12      A    C  
ATOM     52  O   VAL     9      16.114  51.620  13.546  1.00  8.73      A    O  
ATOM     53  N   ILE    10      16.414  51.866  15.771  1.00  7.97      A    N  
ATOM     54  CA  ILE    10      16.989  50.533  15.970  1.00  7.82      A    C  
ATOM     55  CB  ILE    10      18.113  50.529  17.022  1.00  7.94      A    C  
ATOM     56  CG1 ILE    10      19.161  51.610  16.720  1.00  7.84      A    C  
ATOM     57  CD1 ILE    10      19.863  51.460  15.338  1.00  7.30      A    C  
ATOM     58  CG2 ILE    10      18.748  49.133  17.093  1.00  8.58      A    C  
ATOM     59  C   ILE    10      15.903  49.556  16.437  1.00  7.58      A    C  
ATOM     60  O   ILE    10      15.336  49.713  17.523  1.00  7.74      A    O  
ATOM     61  N   GLY    11      15.625  48.558  15.613  1.00  7.35      A    N  
ATOM     62  CA  GLY    11      14.606  47.553  15.893  1.00  8.11      A    C  
ATOM     63  C   GLY    11      13.362  47.716  15.036  1.00  9.10      A    C  
ATOM     64  O   GLY    11      12.773  48.817  14.973  1.00  9.00      A    O  
ATOM     65  N   ALA    12      12.956  46.614  14.403  1.00  8.90      A    N  
ATOM     66  CA  ALA    12      11.758  46.579  13.569  1.00  8.90      A    C  
ATOM     67  CB  ALA    12      12.082  46.117  12.142  1.00  9.90      A    C  
ATOM     68  C   ALA    12      10.692  45.694  14.182  1.00  8.86      A    C  
ATOM     69  O   ALA    12       9.985  44.978  13.475  1.00  9.63      A    O  
ATOM     70  N   GLY    13      10.574  45.748  15.504  1.00  8.06      A    N  
ATOM     71  CA  GLY    13       9.417  45.172  16.161  1.00  7.81      A    C  
ATOM     72  C   GLY    13       8.215  46.092  16.025  1.00  8.37      A    C  
ATOM     73  O   GLY    13       8.281  47.120  15.348  1.00  8.18      A    O  
ATOM     74  N   VAL    14       7.115  45.726  16.671  1.00  8.40      A    N  
ATOM     75  CA  VAL    14       5.877  46.483  16.459  1.00  9.52      A    C  
ATOM     76  CB  VAL    14       4.647  45.799  17.117  1.00  9.86      A    C  
ATOM     77  CG1 VAL    14       4.414  44.410  16.512  1.00 12.57      A    C  
ATOM     78  CG2 VAL    14       4.782  45.739  18.645  1.00 10.08      A    C  
ATOM     79  C   VAL    14       6.022  47.925  16.935  1.00 10.04      A    C  
ATOM     80  O   VAL    14       5.447  48.863  16.341  1.00 10.04      A    O  
ATOM     81  N   VAL    15       6.785  48.101  18.012  1.00  9.60      A    N  
ATOM     82  CA  VAL    15       7.004  49.416  18.599  1.00  9.62      A    C  
ATOM     83  CB  VAL    15       7.469  49.304  20.083  1.00  9.21      A    C  
ATOM     84  CG1 VAL    15       7.758  50.667  20.637  1.00 11.32      A    C  
ATOM     85  CG2 VAL    15       6.403  48.606  20.926  1.00 10.95      A    C  
ATOM     86  C   VAL    15       7.987  50.241  17.773  1.00  9.54      A    C  
ATOM     87  O   VAL    15       7.739  51.404  17.481  1.00  9.33      A    O  
ATOM     88  N   GLY    16       9.116  49.647  17.386  1.00  9.32      A    N  
ATOM     89  CA  GLY    16      10.039  50.332  16.493  1.00  9.59      A    C  
ATOM     90  C   GLY    16       9.346  50.773  15.215  1.00  9.25      A    C  
ATOM     91  O   GLY    16       9.593  51.880  14.705  1.00  9.62      A    O  
ATOM     92  N   LEU    17       8.508  49.896  14.661  1.00  9.19      A    N  
ATOM     93  CA  LEU    17       7.808  50.214  13.417  1.00  9.11      A    C  
ATOM     94  CB  LEU    17       7.173  48.974  12.782  1.00  9.20      A    C  
ATOM     95  CG  LEU    17       8.167  47.975  12.167  1.00 10.80      A    C  
ATOM     96  CD1 LEU    17       7.497  46.667  11.777  1.00 12.92      A    C  
ATOM     97  CD2 LEU    17       8.900  48.605  10.984  1.00 13.27      A    C  
ATOM     98  C   LEU    17       6.765  51.313  13.615  1.00  9.25      A    C  
ATOM     99  O   LEU    17       6.627  52.185  12.752  1.00  9.50      A    O  
ATOM    100  N   ALA    18       6.044  51.281  14.733  1.00  8.68      A    N  
ATOM    101  CA  ALA    18       5.076  52.366  15.005  1.00  8.79      A    C  
ATOM    102  CB  ALA    18       4.306  52.119  16.285  1.00  8.59      A    C  
ATOM    103  C   ALA    18       5.797  53.708  15.076  1.00  9.13      A    C  
ATOM    104  O   ALA    18       5.309  54.716  14.585  1.00  9.58      A    O  
ATOM    105  N   ILE    19       6.962  53.724  15.714  1.00  8.73      A    N  
ATOM    106  CA  ILE    19       7.751  54.945  15.795  1.00  9.02      A    C  
ATOM    107  CB  ILE    19       8.926  54.770  16.785  1.00  8.31      A    C  
ATOM    108  CG1 ILE    19       8.387  54.535  18.208  1.00  8.79      A    C  
ATOM    109  CD1 ILE    19       9.436  53.989  19.182  1.00  8.74      A    C  
ATOM    110  CG2 ILE    19       9.870  55.980  16.722  1.00  8.49      A    C  
ATOM    111  C   ILE    19       8.283  55.405  14.433  1.00  8.99      A    C  
ATOM    112  O   ILE    19       8.202  56.591  14.106  1.00  9.86      A    O  
ATOM    113  N   ALA    20       8.825  54.478  13.641  1.00  9.69      A    N  
ATOM    114  CA  ALA    20       9.303  54.808  12.295  1.00 10.16      A    C  
ATOM    115  CB  ALA    20       9.826  53.564  11.598  1.00 10.60      A    C  
ATOM    116  C   ALA    20       8.146  55.403  11.487  1.00 10.95      A    C  
ATOM    117  O   ALA    20       8.307  56.412  10.795  1.00 12.16      A    O  
ATOM    118  N   ARG    21       6.989  54.763  11.580  1.00 10.83      A    N  
ATOM    119  CA  ARG    21       5.778  55.252  10.926  1.00 11.56      A    C  
ATOM    120  CB  ARG    21       4.606  54.300  11.199  1.00 10.87      A    C  
ATOM    121  CG  ARG    21       3.228  54.819  10.767  1.00 13.06      A    C  
ATOM    122  CD  ARG    21       2.157  53.773  11.067  1.00 13.28      A    C  
ATOM    123  NE  ARG    21       0.846  54.186  10.573  1.00 14.54      A    N  
ATOM    124  CZ  ARG    21       0.054  55.051  11.190  1.00 16.67      A    C  
ATOM    125  NH1 ARG    21       0.435  55.614  12.331  1.00 17.57      A    N  
ATOM    126  NH2 ARG    21      -1.126  55.365  10.653  1.00 16.89      A    N  
ATOM    127  C   ARG    21       5.448  56.697  11.329  1.00 11.67      A    C  
ATOM    128  O   ARG    21       5.183  57.543  10.456  1.00 12.36      A    O  
ATOM    129  N   ALA    22       5.460  56.983  12.631  1.00 12.00      A    N  
ATOM    130  CA  ALA    22       5.177  58.338  13.121  1.00 12.31      A    C  
ATOM    131  CB  ALA    22       5.071  58.339  14.617  1.00 12.63      A    C  
ATOM    132  C   ALA    22       6.227  59.361  12.649  1.00 13.41      A    C  
ATOM    133  O   ALA    22       5.882  60.457  12.175  1.00 13.54      A    O  
ATOM    134  N   LEU    23       7.504  59.011  12.786  1.00 13.21      A    N  
ATOM    135  CA  LEU    23       8.567  59.890  12.307  1.00 13.66      A    C  
ATOM    136  CB  LEU    23       9.949  59.314  12.635  1.00 13.40      A    C  
ATOM    137  CG  LEU    23      10.337  59.315  14.116  1.00 12.88      A    C  
ATOM    138  CD1 LEU    23      11.577  58.449  14.320  1.00 12.59      A    C  
ATOM    139  CD2 LEU    23      10.563  60.741  14.646  1.00 12.46      A    C  
ATOM    140  C   LEU    23       8.444  60.169  10.803  1.00 14.15      A    C  
ATOM    141  O   LEU    23       8.563  61.325  10.364  1.00 15.00      A    O  
ATOM    142  N   ALA    24       8.181  59.140  10.012  1.00 14.11      A    N  
ATOM    143  CA  ALA    24       8.135  59.318   8.565  1.00 14.56      A    C  
ATOM    144  CB  ALA    24       8.095  57.977   7.855  1.00 14.78      A    C  
ATOM    145  C   ALA    24       6.921  60.177   8.190  1.00 15.33      A    C  
ATOM    146  O   ALA    24       7.010  61.038   7.309  1.00 15.33      A    O  
ATOM    147  N   ALA    25       5.807  59.961   8.884  1.00 15.07      A    N  
ATOM    148  CA  ALA    25       4.586  60.736   8.636  1.00 15.64      A    C  
ATOM    149  CB  ALA    25       3.403  60.147   9.414  1.00 15.31      A    C  
ATOM    150  C   ALA    25       4.798  62.204   8.994  1.00 16.35      A    C  
ATOM    151  O   ALA    25       4.101  63.093   8.478  1.00 17.36      A    O  
ATOM    152  N   GLY    26       5.761  62.466   9.870  1.00 16.03      A    N  
ATOM    153  CA  GLY    26       6.092  63.834  10.270  1.00 17.08      A    C  
ATOM    154  C   GLY    26       7.062  64.494   9.305  1.00 17.67      A    C  
ATOM    155  O   GLY    26       7.528  65.605   9.554  1.00 18.13      A    O  
ATOM    156  N   GLY    27       7.380  63.800   8.214  1.00 17.65      A    N  
ATOM    157  CA  GLY    27       8.239  64.358   7.159  1.00 18.53      A    C  
ATOM    158  C   GLY    27       9.727  64.060   7.277  1.00 18.76      A    C  
ATOM    159  O   GLY    27      10.549  64.617   6.533  1.00 19.47      A    O  
ATOM    160  N   HIS    28      10.090  63.180   8.203  1.00 17.87      A    N  
ATOM    161  CA  HIS    28      11.503  62.880   8.442  1.00 17.67      A    C  
ATOM    162  CB  HIS    28      11.738  62.632   9.932  1.00 17.58      A    C  
ATOM    163  CG  HIS    28      11.363  63.797  10.788  1.00 19.97      A    C  
ATOM    164  ND1 HIS    28      12.159  64.917  10.907  1.00 21.82      A    N  
ATOM    165  CE1 HIS    28      11.565  65.792  11.698  1.00 22.25      A    C  
ATOM    166  NE2 HIS    28      10.411  65.282  12.092  1.00 23.06      A    N  
ATOM    167  CD2 HIS    28      10.257  64.038  11.533  1.00 19.91      A    C  
ATOM    168  C   HIS    28      11.987  61.688   7.643  1.00 16.83      A    C  
ATOM    169  O   HIS    28      11.272  60.712   7.498  1.00 17.40      A    O  
ATOM    170  N   GLU    29      13.212  61.773   7.130  1.00 15.93      A    N  
ATOM    171  CA  GLU    29      13.850  60.630   6.492  1.00 15.15      A    C  
ATOM    172  CB  GLU    29      15.151  61.067   5.819  1.00 14.89      A    C  
ATOM    173  CG  GLU    29      16.082  59.945   5.429  1.00 16.89      A    C  
ATOM    174  CD  GLU    29      17.484  60.441   5.095  1.00 19.01      A    C  
ATOM    175  OE1 GLU    29      17.990  61.372   5.763  1.00 19.10      A    O  
ATOM    176  OE2 GLU    29      18.076  59.895   4.146  1.00 22.56      A    O  
ATOM    177  C   GLU    29      14.141  59.630   7.600  1.00 13.93      A    C  
ATOM    178  O   GLU    29      14.684  60.003   8.626  1.00 13.78      A    O  
ATOM    179  N   VAL    30      13.751  58.379   7.396  1.00 14.02      A    N  
ATOM    180  CA  VAL    30      13.918  57.353   8.423  1.00 13.80      A    C  
ATOM    181  CB  VAL    30      12.555  56.933   9.059  1.00 13.96      A    C  
ATOM    182  CG1 VAL    30      12.774  55.824  10.061  1.00 15.38      A    C  
ATOM    183  CG2 VAL    30      11.896  58.121   9.750  1.00 13.74      A    C  
ATOM    184  C   VAL    30      14.603  56.112   7.866  1.00 13.21      A    C  
ATOM    185  O   VAL    30      14.210  55.588   6.819  1.00 13.14      A    O  
ATOM    186  N   LEU    31      15.638  55.652   8.564  1.00 12.24      A    N  
ATOM    187  CA  LEU    31      16.211  54.336   8.290  1.00 11.94      A    C  
ATOM    188  CB  LEU    31      17.712  54.442   8.031  1.00 12.23      A    C  
ATOM    189  CG  LEU    31      18.406  53.094   7.757  1.00 13.44      A    C  
ATOM    190  CD1 LEU    31      17.915  52.455   6.462  1.00 14.49      A    C  
ATOM    191  CD2 LEU    31      19.935  53.264   7.747  1.00 15.66      A    C  
ATOM    192  C   LEU    31      15.982  53.457   9.513  1.00 11.02      A    C  
ATOM    193  O   LEU    31      16.349  53.834  10.607  1.00 11.03      A    O  
ATOM    194  N   VAL    32      15.350  52.309   9.321  1.00 10.82      A    N  
ATOM    195  CA  VAL    32      15.185  51.346  10.408  1.00 10.63      A    C  
ATOM    196  CB  VAL    32      13.792  50.708  10.395  1.00 11.15      A    C  
ATOM    197  CG1 VAL    32      13.662  49.752  11.568  1.00 11.21      A    C  
ATOM    198  CG2 VAL    32      12.716  51.788  10.455  1.00 11.23      A    C  
ATOM    199  C   VAL    32      16.201  50.221  10.253  1.00 10.43      A    C  
ATOM    200  O   VAL    32      16.208  49.525   9.238  1.00 10.08      A    O  
ATOM    201  N   ALA    33      17.040  50.034  11.267  1.00  9.72      A    N  
ATOM    202  CA  ALA    33      18.043  48.965  11.245  1.00  9.59      A    C  
ATOM    203  CB  ALA    33      19.388  49.493  11.716  1.00  9.71      A    C  
ATOM    204  C   ALA    33      17.588  47.814  12.139  1.00  9.51      A    C  
ATOM    205  O   ALA    33      17.351  48.005  13.321  1.00  9.72      A    O  
ATOM    206  N   GLU    34      17.486  46.627  11.555  1.00  9.06      A    N  
ATOM    207  CA  GLU    34      17.053  45.430  12.279  1.00  9.62      A    C  
ATOM    208  CB  GLU    34      15.703  44.965  11.711  1.00  9.26      A    C  
ATOM    209  CG  GLU    34      15.284  43.565  12.117  1.00 10.47      A    C  
ATOM    210  CD  GLU    34      15.182  43.388  13.624  1.00 10.26      A    C  
ATOM    211  OE1 GLU    34      14.447  44.153  14.296  1.00 10.24      A    O  
ATOM    212  OE2 GLU    34      15.829  42.465  14.149  1.00 11.78      A    O  
ATOM    213  C   GLU    34      18.117  44.334  12.166  1.00  9.66      A    C  
ATOM    214  O   GLU    34      18.593  44.042  11.074  1.00  9.88      A    O  
ATOM    215  N   ALA    35      18.485  43.738  13.296  1.00 10.29      A    N  
ATOM    216  CA  ALA    35      19.537  42.707  13.337  1.00 11.68      A    C  
ATOM    217  CB  ALA    35      19.993  42.478  14.780  1.00 10.93      A    C  
ATOM    218  C   ALA    35      19.102  41.395  12.694  1.00 12.64      A    C  
ATOM    219  O   ALA    35      19.916  40.686  12.076  1.00 12.39      A    O  
ATOM    220  N   ALA    36      17.819  41.066  12.838  1.00 13.65      A    N  
ATOM    221  CA  ALA    36      17.259  39.828  12.264  1.00 15.76      A    C  
ATOM    222  CB  ALA    36      15.907  39.496  12.917  1.00 15.54      A    C  
ATOM    223  C   ALA    36      17.099  39.912  10.748  1.00 17.64      A    C  
ATOM    224  O   ALA    36      17.257  40.973  10.168  1.00 16.16      A    O  
ATOM    225  N   GLU    37      16.740  38.789  10.120  1.00 21.32      A    N  
ATOM    226  CA  GLU    37      16.543  38.737   8.662  1.00 25.10      A    C  
ATOM    227  CB  GLU    37      16.706  37.291   8.155  1.00 25.58      A    C  
ATOM    228  CG  GLU    37      18.139  36.772   8.251  1.00 28.03      A    C  
ATOM    229  CD  GLU    37      19.061  37.370   7.182  1.00 31.75      A    C  
ATOM    230  OE1 GLU    37      18.559  38.078   6.282  1.00 34.60      A    O  
ATOM    231  OE2 GLU    37      20.285  37.133   7.239  1.00 33.38      A    O  
ATOM    232  C   GLU    37      15.234  39.372   8.138  1.00 27.36      A    C  
ATOM    233  O   GLU    37      15.129  39.691   6.946  1.00 27.94      A    O  
ATOM    234  N   GLY    38      14.247  39.567   9.012  1.00 29.61      A    N  
ATOM    235  CA  GLY    38      13.013  40.275   8.631  1.00 32.31      A    C  
ATOM    236  C   GLY    38      12.423  41.152   9.732  1.00 34.12      A    C  
ATOM    237  O   GLY    38      13.052  41.363  10.775  1.00 34.47      A    O  
ATOM    238  N   ILE    39      11.209  41.664   9.516  1.00 35.49      A    N  
ATOM    239  CA  ILE    39      10.524  42.431  10.563  1.00 36.78      A    C  
ATOM    240  CB  ILE    39       9.467  43.442  10.014  1.00 36.73      A    C  
ATOM    241  CG1 ILE    39       8.369  42.722   9.231  1.00 37.04      A    C  
ATOM    242  CD1 ILE    39       7.213  43.626   8.867  1.00 37.54      A    C  
ATOM    243  CG2 ILE    39      10.108  44.550   9.176  1.00 37.15      A    C  
ATOM    244  C   ILE    39       9.801  41.492  11.518  1.00 37.50      A    C  
ATOM    245  O   ILE    39       9.383  40.394  11.129  1.00 37.79      A    O  
ATOM    246  N   GLY    40       9.663  41.931  12.769  1.00 38.27      A    N  
ATOM    247  CA  GLY    40       8.746  41.302  13.719  1.00 38.99      A    C  
ATOM    248  C   GLY    40       9.009  39.844  14.042  1.00 39.46      A    C  
ATOM    249  O   GLY    40       8.075  39.071  14.270  1.00 39.75      A    O  
ATOM    250  N   THR    41      10.280  39.465  14.078  1.00 39.76      A    N  
ATOM    251  CA  THR    41      10.646  38.101  14.442  1.00 40.02      A    C  
ATOM    252  CB  THR    41      11.921  37.625  13.691  1.00 40.19      A    C  
ATOM    253  OG1 THR    41      13.008  38.527  13.944  1.00 40.65      A    O  
ATOM    254  CG2 THR    41      11.668  37.549  12.190  1.00 40.45      A    C  
ATOM    255  C   THR    41      10.842  37.957  15.957  1.00 39.91      A    C  
ATOM    256  O   THR    41      10.828  36.844  16.491  1.00 40.18      A    O  
ATOM    257  N   GLY    42      11.005  39.086  16.642  1.00 39.45      A    N  
ATOM    258  CA  GLY    42      11.349  39.084  18.060  1.00 39.18      A    C  
ATOM    259  C   GLY    42      10.189  38.908  19.023  1.00 38.90      A    C  
ATOM    260  O   GLY    42       9.378  37.998  18.874  1.00 38.88      A    O  
ATOM    261  N   THR    43      10.113  39.784  20.020  1.00 38.61      A    N  
ATOM    262  CA  THR    43       9.056  39.694  21.025  1.00 38.22      A    C  
ATOM    263  CB  THR    43       9.366  40.552  22.261  1.00 38.49      A    C  
ATOM    264  OG1 THR    43      10.627  40.151  22.808  1.00 38.92      A    O  
ATOM    265  CG2 THR    43       8.276  40.392  23.324  1.00 38.36      A    C  
ATOM    266  C   THR    43       7.712  40.111  20.454  1.00 37.63      A    C  
ATOM    267  O   THR    43       6.685  40.041  21.140  1.00 37.79      A    O  
ATOM    268  N   SER    44       7.730  40.550  19.199  1.00 36.71      A    N  
ATOM    269  CA  SER    44       6.498  40.889  18.488  1.00 35.10      A    C  
ATOM    270  CB  SER    44       6.731  42.056  17.524  1.00 35.16      A    C  
ATOM    271  OG  SER    44       7.150  43.214  18.225  1.00 27.29      A    O  
ATOM    272  C   SER    44       5.930  39.685  17.746  1.00 35.80      A    C  
ATOM    273  O   SER    44       4.904  39.792  17.070  1.00 36.07      A    O  
ATOM    274  N   SER    45       6.594  38.537  17.879  1.00 35.56      A    N  
ATOM    275  CA  SER    45       6.102  37.300  17.270  1.00 35.56      A    C  
ATOM    276  CB  SER    45       7.049  36.835  16.158  1.00 35.80      A    C  
ATOM    277  OG  SER    45       8.348  36.576  16.666  1.00 37.39      A    O  
ATOM    278  C   SER    45       5.905  36.197  18.314  1.00 35.04      A    C  
ATOM    279  O   SER    45       5.666  35.030  17.980  1.00 35.06      A    O  
ATOM    280  N   ARG    46       6.002  36.576  19.585  1.00 34.21      A    N  
ATOM    281  CA  ARG    46       5.930  35.604  20.671  1.00 33.05      A    C  
ATOM    282  CB  ARG    46       7.337  35.261  21.164  1.00 33.02      A    C  
ATOM    283  CG  ARG    46       8.279  34.710  20.077  1.00 33.79      A    C  
ATOM    284  CD  ARG    46       9.714  34.607  20.592  1.00 33.38      A    C  
ATOM    285  NE  ARG    46      10.592  33.854  19.694  1.00 33.18      A    N  
ATOM    286  CZ  ARG    46      10.528  32.538  19.512  1.00 32.21      A    C  
ATOM    287  NH1 ARG    46       9.608  31.816  20.140  1.00 29.99      A    N  
ATOM    288  NH2 ARG    46      11.376  31.945  18.678  1.00 32.48      A    N  
ATOM    289  C   ARG    46       5.062  36.126  21.822  1.00 32.25      A    C  
ATOM    290  O   ARG    46       5.469  36.100  22.979  1.00 31.54      A    O  
ATOM    291  N   ASN    47       3.861  36.601  21.490  1.00 31.32      A    N  
ATOM    292  CA  ASN    47       2.918  37.090  22.497  1.00 29.78      A    C  
ATOM    293  CB  ASN    47       2.924  38.641  22.557  1.00 30.79      A    C  
ATOM    294  CG  ASN    47       2.389  39.297  21.283  1.00 32.17      A    C  
ATOM    295  OD1 ASN    47       3.152  39.631  20.366  1.00 36.00      A    O  
ATOM    296  ND2 ASN    47       1.077  39.465  21.213  1.00 33.08      A    N  
ATOM    297  C   ASN    47       1.509  36.517  22.264  1.00 28.90      A    C  
ATOM    298  O   ASN    47       1.308  35.725  21.326  1.00 28.04      A    O  
ATOM    299  N   SER    48       0.549  36.905  23.115  1.00 27.12      A    N  
ATOM    300  CA  SER    48      -0.833  36.384  23.042  1.00 25.17      A    C  
ATOM    301  CB  SER    48      -1.567  36.576  24.377  1.00 25.29      A    C  
ATOM    302  OG  SER    48      -0.702  36.976  25.409  1.00 24.10      A    O  
ATOM    303  C   SER    48      -1.642  37.094  21.956  1.00 23.84      A    C  
ATOM    304  O   SER    48      -2.697  36.612  21.513  1.00 24.97      A    O  
ATOM    305  N   GLU    49      -1.155  38.258  21.547  1.00 20.63      A    N  
ATOM    306  CA  GLU    49      -1.794  39.025  20.517  1.00 16.82      A    C  
ATOM    307  CB  GLU    49      -2.003  38.175  19.271  1.00 16.62      A    C  
ATOM    308  CG  GLU    49      -0.705  37.888  18.511  1.00 22.04      A    C  
ATOM    309  CD  GLU    49      -0.908  36.953  17.316  1.00 26.81      A    C  
ATOM    310  OE1 GLU    49      -1.726  36.017  17.441  1.00 28.52      A    O  
ATOM    311  OE2 GLU    49      -0.254  37.164  16.263  1.00 27.42      A    O  
ATOM    312  C   GLU    49      -3.114  39.565  21.036  1.00 13.38      A    C  
ATOM    313  O   GLU    49      -4.050  39.731  20.274  1.00 12.75      A    O  
ATOM    314  N   VAL    50      -3.167  39.840  22.335  1.00 10.42      A    N  
ATOM    315  CA  VAL    50      -4.378  40.409  22.941  1.00  8.31      A    C  
ATOM    316  CB  VAL    50      -4.558  39.926  24.400  1.00  8.28      A    C  
ATOM    317  CG1 VAL    50      -5.753  40.589  25.055  1.00  8.43      A    C  
ATOM    318  CG2 VAL    50      -4.737  38.411  24.448  1.00  7.04      A    C  
ATOM    319  C   VAL    50      -4.383  41.937  22.890  1.00  8.10      A    C  
ATOM    320  O   VAL    50      -3.400  42.596  23.240  1.00  7.33      A    O  
ATOM    321  N   ILE    51      -5.504  42.502  22.439  1.00  7.64      A    N  
ATOM    322  CA  ILE    51      -5.712  43.948  22.519  1.00  6.60      A    C  
ATOM    323  CB  ILE    51      -6.682  44.451  21.428  1.00  7.25      A    C  
ATOM    324  CG1 ILE    51      -6.131  44.141  20.020  1.00  6.76      A    C  
ATOM    325  CD1 ILE    51      -7.089  44.499  18.857  1.00 10.48      A    C  
ATOM    326  CG2 ILE    51      -6.880  45.976  21.583  1.00  6.93      A    C  
ATOM    327  C   ILE    51      -6.311  44.196  23.907  1.00  7.08      A    C  
ATOM    328  O   ILE    51      -7.489  43.905  24.157  1.00  7.14      A    O  
ATOM    329  N   HIS    52      -5.487  44.704  24.817  1.00  6.56      A    N  
ATOM    330  CA  HIS    52      -5.903  44.856  26.214  1.00  7.08      A    C  
ATOM    331  CB  HIS    52      -4.669  44.922  27.115  1.00  7.43      A    C  
ATOM    332  CG  HIS    52      -4.032  43.589  27.330  1.00  7.92      A    C  
ATOM    333  ND1 HIS    52      -4.608  42.624  28.125  1.00  9.54      A    N  
ATOM    334  CE1 HIS    52      -3.831  41.553  28.146  1.00  9.18      A    C  
ATOM    335  NE2 HIS    52      -2.778  41.786  27.379  1.00  7.63      A    N  
ATOM    336  CD2 HIS    52      -2.876  43.056  26.863  1.00 10.24      A    C  
ATOM    337  C   HIS    52      -6.789  46.076  26.439  1.00  7.45      A    C  
ATOM    338  O   HIS    52      -6.610  47.118  25.810  1.00  8.19      A    O  
ATOM    339  N   ALA    53      -7.735  45.928  27.364  1.00  7.73      A    N  
ATOM    340  CA  ALA    53      -8.663  47.015  27.686  1.00  7.27      A    C  
ATOM    341  CB  ALA    53      -9.899  46.476  28.408  1.00  7.32      A    C  
ATOM    342  C   ALA    53      -8.033  48.173  28.476  1.00  7.41      A    C  
ATOM    343  O   ALA    53      -8.426  49.313  28.268  1.00  7.13      A    O  
ATOM    344  N   GLY    54      -7.075  47.876  29.361  1.00  7.59      A    N  
ATOM    345  CA  GLY    54      -6.435  48.884  30.232  1.00  7.25      A    C  
ATOM    346  C   GLY    54      -6.926  48.780  31.676  1.00  7.60      A    C  
ATOM    347  O   GLY    54      -7.012  49.777  32.400  1.00  7.73      A    O  
ATOM    348  N   ILE    55      -7.203  47.555  32.105  1.00  7.33      A    N  
ATOM    349  CA  ILE    55      -7.931  47.305  33.337  1.00  8.04      A    C  
ATOM    350  CB  ILE    55      -8.519  45.865  33.313  1.00  7.29      A    C  
ATOM    351  CG1 ILE    55      -9.633  45.786  32.256  1.00  7.56      A    C  
ATOM    352  CD1 ILE    55     -10.121  44.377  31.956  1.00  7.54      A    C  
ATOM    353  CG2 ILE    55      -9.027  45.417  34.712  1.00  7.10      A    C  
ATOM    354  C   ILE    55      -7.106  47.531  34.608  1.00  8.84      A    C  
ATOM    355  O   ILE    55      -7.498  48.309  35.478  1.00 10.00      A    O  
ATOM    356  N   TYR    56      -5.962  46.861  34.741  1.00  8.60      A    N  
ATOM    357  CA  TYR    56      -5.373  46.812  36.077  1.00  9.77      A    C  
ATOM    358  CB  TYR    56      -5.237  45.357  36.541  1.00 10.58      A    C  
ATOM    359  CG  TYR    56      -5.254  45.189  38.057  1.00 11.81      A    C  
ATOM    360  CD1 TYR    56      -6.344  45.630  38.814  1.00 14.23      A    C  
ATOM    361  CE1 TYR    56      -6.365  45.504  40.192  1.00 14.92      A    C  
ATOM    362  CZ  TYR    56      -5.289  44.904  40.837  1.00 16.04      A    C  
ATOM    363  OH  TYR    56      -5.311  44.764  42.206  1.00 17.65      A    O  
ATOM    364  CE2 TYR    56      -4.201  44.442  40.110  1.00 15.78      A    C  
ATOM    365  CD2 TYR    56      -4.188  44.589  38.721  1.00 15.35      A    C  
ATOM    366  C   TYR    56      -4.061  47.572  36.277  1.00  8.88      A    C  
ATOM    367  O   TYR    56      -3.445  47.492  37.345  1.00  9.87      A    O  
ATOM    368  N   TYR    57      -3.624  48.308  35.266  1.00  8.78      A    N  
ATOM    369  CA  TYR    57      -2.401  49.107  35.405  1.00  8.91      A    C  
ATOM    370  CB  TYR    57      -1.951  49.615  34.030  1.00  8.86      A    C  
ATOM    371  CG  TYR    57      -2.024  48.506  32.997  1.00  8.56      A    C  
ATOM    372  CD1 TYR    57      -1.156  47.419  33.063  1.00  9.52      A    C  
ATOM    373  CE1 TYR    57      -1.227  46.398  32.155  1.00 10.07      A    C  
ATOM    374  CZ  TYR    57      -2.189  46.421  31.165  1.00 11.26      A    C  
ATOM    375  OH  TYR    57      -2.252  45.384  30.268  1.00 11.50      A    O  
ATOM    376  CE2 TYR    57      -3.067  47.473  31.072  1.00  9.78      A    C  
ATOM    377  CD2 TYR    57      -2.993  48.509  32.010  1.00  8.62      A    C  
ATOM    378  C   TYR    57      -2.623  50.258  36.385  1.00  9.94      A    C  
ATOM    379  O   TYR    57      -3.727  50.794  36.484  1.00 10.15      A    O  
ATOM    380  N   PRO    58      -1.570  50.640  37.121  1.00 10.87      A    N  
ATOM    381  CA  PRO    58      -1.763  51.662  38.139  1.00 11.03      A    C  
ATOM    382  CB  PRO    58      -0.398  51.719  38.847  1.00 11.42      A    C  
ATOM    383  CG  PRO    58       0.265  50.391  38.549  1.00 12.06      A    C  
ATOM    384  CD  PRO    58      -0.230  50.027  37.174  1.00 10.77      A    C  
ATOM    385  C   PRO    58      -2.124  53.026  37.526  1.00 11.15      A    C  
ATOM    386  O   PRO    58      -1.664  53.374  36.433  1.00 11.25      A    O  
ATOM    387  N   ALA    59      -2.940  53.791  38.235  1.00 11.77      A    N  
ATOM    388  CA  ALA    59      -3.418  55.068  37.707  1.00 11.98      A    C  
ATOM    389  CB  ALA    59      -4.204  55.826  38.771  1.00 11.82      A    C  
ATOM    390  C   ALA    59      -2.287  55.950  37.162  1.00 12.46      A    C  
ATOM    391  O   ALA    59      -1.243  56.110  37.801  1.00 12.86      A    O  
ATOM    392  N   ASP    60      -2.518  56.508  35.975  1.00 12.85      A    N  
ATOM    393  CA  ASP    60      -1.603  57.462  35.342  1.00 13.80      A    C  
ATOM    394  CB  ASP    60      -1.455  58.719  36.198  1.00 14.86      A    C  
ATOM    395  CG  ASP    60      -2.760  59.484  36.335  1.00 18.07      A    C  
ATOM    396  OD1 ASP    60      -3.581  59.464  35.387  1.00 20.90      A    O  
ATOM    397  OD2 ASP    60      -2.964  60.121  37.398  1.00 23.61      A    O  
ATOM    398  C   ASP    60      -0.225  56.918  34.959  1.00 13.27      A    C  
ATOM    399  O   ASP    60       0.628  57.689  34.488  1.00 13.16      A    O  
ATOM    400  N   SER    61      -0.012  55.611  35.146  1.00 12.05      A    N  
ATOM    401  CA  SER    61       1.183  54.962  34.605  1.00 10.82      A    C  
ATOM    402  CB  SER    61       1.258  53.491  35.044  1.00 11.12      A    C  
ATOM    403  OG  SER    61       0.143  52.726  34.564  1.00  8.94      A    O  
ATOM    404  C   SER    61       1.191  55.059  33.087  1.00 10.60      A    C  
ATOM    405  O   SER    61       0.143  55.250  32.457  1.00  9.42      A    O  
ATOM    406  N   LEU    62       2.368  54.912  32.480  1.00  9.61      A    N  
ATOM    407  CA  LEU    62       2.418  54.839  31.024  1.00  9.93      A    C  
ATOM    408  CB  LEU    62       3.853  54.802  30.503  1.00 10.55      A    C  
ATOM    409  CG  LEU    62       4.588  56.137  30.557  1.00 11.66      A    C  
ATOM    410  CD1 LEU    62       5.974  55.960  29.987  1.00 11.95      A    C  
ATOM    411  CD2 LEU    62       3.797  57.185  29.753  1.00 12.15      A    C  
ATOM    412  C   LEU    62       1.660  53.623  30.529  1.00  9.43      A    C  
ATOM    413  O   LEU    62       0.955  53.709  29.526  1.00  8.87      A    O  
ATOM    414  N   LYS    63       1.788  52.494  31.226  1.00  8.82      A    N  
ATOM    415  CA  LYS    63       1.018  51.327  30.853  1.00  8.38      A    C  
ATOM    416  CB  LYS    63       1.293  50.141  31.792  1.00  8.35      A    C  
ATOM    417  CG  LYS    63       2.664  49.466  31.545  1.00  8.97      A    C  
ATOM    418  CD  LYS    63       2.842  48.265  32.505  1.00 11.67      A    C  
ATOM    419  CE  LYS    63       4.199  47.588  32.325  1.00 15.61      A    C  
ATOM    420  NZ  LYS    63       4.418  47.274  30.925  1.00 22.22      A    N  
ATOM    421  C   LYS    63      -0.475  51.667  30.827  1.00  7.93      A    C  
ATOM    422  O   LYS    63      -1.169  51.331  29.887  1.00  7.25      A    O  
ATOM    423  N   ALA    64      -0.977  52.337  31.856  1.00  8.01      A    N  
ATOM    424  CA  ALA    64      -2.415  52.628  31.866  1.00  7.83      A    C  
ATOM    425  CB  ALA    64      -2.823  53.189  33.204  1.00  7.78      A    C  
ATOM    426  C   ALA    64      -2.786  53.594  30.729  1.00  8.03      A    C  
ATOM    427  O   ALA    64      -3.722  53.360  29.968  1.00  7.77      A    O  
ATOM    428  N   ARG    65      -2.067  54.701  30.642  1.00  7.68      A    N  
ATOM    429  CA  ARG    65      -2.438  55.763  29.712  1.00  8.18      A    C  
ATOM    430  CB  ARG    65      -1.611  57.009  29.993  1.00  8.94      A    C  
ATOM    431  CG  ARG    65      -1.873  58.120  29.013  1.00 11.92      A    C  
ATOM    432  CD  ARG    65      -1.428  59.454  29.582  1.00 17.28      A    C  
ATOM    433  NE  ARG    65       0.007  59.690  29.473  1.00 21.96      A    N  
ATOM    434  CZ  ARG    65       0.886  59.562  30.457  1.00 25.98      A    C  
ATOM    435  NH1 ARG    65       0.505  59.150  31.664  1.00 28.44      A    N  
ATOM    436  NH2 ARG    65       2.167  59.836  30.219  1.00 28.46      A    N  
ATOM    437  C   ARG    65      -2.286  55.331  28.260  1.00  7.67      A    C  
ATOM    438  O   ARG    65      -3.163  55.560  27.420  1.00  7.78      A    O  
ATOM    439  N   LEU    66      -1.157  54.696  27.969  1.00  7.04      A    N  
ATOM    440  CA  LEU    66      -0.856  54.285  26.610  1.00  6.40      A    C  
ATOM    441  CB  LEU    66       0.653  54.100  26.422  1.00  6.40      A    C  
ATOM    442  CG  LEU    66       1.497  55.346  26.757  1.00  6.64      A    C  
ATOM    443  CD1 LEU    66       2.959  55.113  26.363  1.00  8.12      A    C  
ATOM    444  CD2 LEU    66       0.965  56.618  26.099  1.00  8.63      A    C  
ATOM    445  C   LEU    66      -1.626  53.032  26.210  1.00  6.58      A    C  
ATOM    446  O   LEU    66      -1.909  52.843  25.034  1.00  6.70      A    O  
ATOM    447  N   CYS    67      -1.986  52.178  27.169  1.00  6.22      A    N  
ATOM    448  CA  CYS    67      -2.799  51.021  26.801  1.00  6.53      A    C  
ATOM    449  CB  CYS    67      -2.938  50.019  27.953  1.00  6.79      A    C  
ATOM    450  SG  CYS    67      -3.829  48.505  27.463  1.00  7.60      A    S  
ATOM    451  C   CYS    67      -4.172  51.491  26.335  1.00  7.50      A    C  
ATOM    452  O   CYS    67      -4.685  51.016  25.323  1.00  6.74      A    O  
ATOM    453  N   VAL    68      -4.757  52.444  27.056  1.00  8.07      A    N  
ATOM    454  CA  VAL    68      -6.140  52.835  26.752  1.00  9.14      A    C  
ATOM    455  CB  VAL    68      -6.800  53.558  27.944  1.00  9.33      A    C  
ATOM    456  CG1 VAL    68      -8.160  54.155  27.542  1.00 11.40      A    C  
ATOM    457  CG2 VAL    68      -6.967  52.597  29.137  1.00  9.68      A    C  
ATOM    458  C   VAL    68      -6.174  53.673  25.474  1.00  9.38      A    C  
ATOM    459  O   VAL    68      -6.969  53.417  24.555  1.00  9.98      A    O  
ATOM    460  N   ARG    69      -5.298  54.655  25.390  1.00  9.31      A    N  
ATOM    461  CA  ARG    69      -5.156  55.434  24.158  1.00  9.28      A    C  
ATOM    462  CB  ARG    69      -4.072  56.484  24.362  1.00  9.91      A    C  
ATOM    463  CG  ARG    69      -3.657  57.204  23.105  1.00 13.50      A    C  
ATOM    464  CD  ARG    69      -4.612  58.275  22.754  1.00 16.88      A    C  
ATOM    465  NE  ARG    69      -4.147  59.054  21.603  1.00 17.05      A    N  
ATOM    466  CZ  ARG    69      -4.958  59.788  20.852  1.00 19.86      A    C  
ATOM    467  NH1 ARG    69      -6.254  59.846  21.154  1.00 20.22      A    N  
ATOM    468  NH2 ARG    69      -4.482  60.465  19.804  1.00 17.58      A    N  
ATOM    469  C   ARG    69      -4.792  54.536  22.970  1.00  8.86      A    C  
ATOM    470  O   ARG    69      -5.351  54.656  21.882  1.00  8.88      A    O  
ATOM    471  N   GLY    70      -3.825  53.644  23.185  1.00  6.96      A    N  
ATOM    472  CA  GLY    70      -3.346  52.752  22.137  1.00  6.63      A    C  
ATOM    473  C   GLY    70      -4.444  51.845  21.631  1.00  6.86      A    C  
ATOM    474  O   GLY    70      -4.516  51.578  20.426  1.00  6.60      A    O  
ATOM    475  N   LYS    71      -5.287  51.355  22.550  1.00  6.80      A    N  
ATOM    476  CA  LYS    71      -6.410  50.489  22.187  1.00  7.04      A    C  
ATOM    477  CB  LYS    71      -7.204  50.086  23.441  1.00  7.45      A    C  
ATOM    478  CG  LYS    71      -8.485  49.291  23.146  1.00  8.10      A    C  
ATOM    479  CD  LYS    71      -9.225  48.959  24.463  1.00  9.88      A    C  
ATOM    480  CE  LYS    71      -9.950  50.190  25.052  1.00 10.93      A    C  
ATOM    481  NZ  LYS    71     -10.581  49.920  26.392  1.00 10.98      A    N  
ATOM    482  C   LYS    71      -7.337  51.212  21.221  1.00  7.19      A    C  
ATOM    483  O   LYS    71      -7.713  50.679  20.193  1.00  7.76      A    O  
ATOM    484  N   HIS    72      -7.697  52.436  21.561  1.00  7.71      A    N  
ATOM    485  CA  HIS    72      -8.559  53.212  20.675  1.00  8.31      A    C  
ATOM    486  CB  HIS    72      -8.929  54.525  21.356  1.00  9.02      A    C  
ATOM    487  CG  HIS    72      -9.755  54.321  22.590  1.00 11.38      A    C  
ATOM    488  ND1 HIS    72     -10.778  53.395  22.649  1.00 15.33      A    N  
ATOM    489  CE1 HIS    72     -11.328  53.430  23.849  1.00 15.31      A    C  
ATOM    490  NE2 HIS    72     -10.690  54.336  24.573  1.00 16.23      A    N  
ATOM    491  CD2 HIS    72      -9.711  54.914  23.805  1.00 14.76      A    C  
ATOM    492  C   HIS    72      -7.909  53.442  19.307  1.00  7.82      A    C  
ATOM    493  O   HIS    72      -8.525  53.210  18.269  1.00  8.41      A    O  
ATOM    494  N   LEU    73      -6.662  53.880  19.303  1.00  8.35      A    N  
ATOM    495  CA  LEU    73      -5.962  54.085  18.038  1.00  8.19      A    C  
ATOM    496  CB  LEU    73      -4.558  54.631  18.286  1.00  8.54      A    C  
ATOM    497  CG  LEU    73      -4.514  56.027  18.872  1.00  9.09      A    C  
ATOM    498  CD1 LEU    73      -3.078  56.401  19.189  1.00  9.03      A    C  
ATOM    499  CD2 LEU    73      -5.127  57.016  17.846  1.00 12.63      A    C  
ATOM    500  C   LEU    73      -5.873  52.797  17.231  1.00  8.07      A    C  
ATOM    501  O   LEU    73      -6.002  52.823  16.005  1.00  8.49      A    O  
ATOM    502  N   LEU    74      -5.630  51.673  17.912  1.00  7.61      A    N  
ATOM    503  CA  LEU    74      -5.379  50.408  17.221  1.00  7.20      A    C  
ATOM    504  CB  LEU    74      -4.742  49.391  18.193  1.00  7.34      A    C  
ATOM    505  CG  LEU    74      -4.428  48.008  17.635  1.00  7.42      A    C  
ATOM    506  CD1 LEU    74      -3.462  48.134  16.483  1.00  8.05      A    C  
ATOM    507  CD2 LEU    74      -3.859  47.098  18.756  1.00  7.72      A    C  
ATOM    508  C   LEU    74      -6.677  49.840  16.622  1.00  7.35      A    C  
ATOM    509  O   LEU    74      -6.686  49.339  15.503  1.00  7.49      A    O  
ATOM    510  N   TYR    75      -7.785  49.914  17.360  1.00  7.06      A    N  
ATOM    511  CA  TYR    75      -9.043  49.410  16.805  1.00  7.41      A    C  
ATOM    512  CB  TYR    75     -10.165  49.489  17.844  1.00  7.37      A    C  
ATOM    513  CG  TYR    75     -10.304  48.244  18.673  1.00  7.53      A    C  
ATOM    514  CD1 TYR    75     -10.485  47.002  18.068  1.00  8.31      A    C  
ATOM    515  CE1 TYR    75     -10.617  45.851  18.832  1.00  8.00      A    C  
ATOM    516  CZ  TYR    75     -10.585  45.945  20.213  1.00  7.54      A    C  
ATOM    517  OH  TYR    75     -10.723  44.817  20.970  1.00  9.44      A    O  
ATOM    518  CE2 TYR    75     -10.406  47.172  20.830  1.00  6.93      A    C  
ATOM    519  CD2 TYR    75     -10.262  48.302  20.059  1.00  6.95      A    C  
ATOM    520  C   TYR    75      -9.418  50.220  15.567  1.00  7.93      A    C  
ATOM    521  O   TYR    75      -9.854  49.670  14.558  1.00  8.51      A    O  
ATOM    522  N   GLU    76      -9.219  51.529  15.648  1.00  8.56      A    N  
ATOM    523  CA  GLU    76      -9.482  52.387  14.496  1.00  9.57      A    C  
ATOM    524  CB  GLU    76      -9.352  53.849  14.892  1.00 10.16      A    C  
ATOM    525  CG  GLU    76      -9.505  54.835  13.749  1.00 11.30      A    C  
ATOM    526  CD  GLU    76      -9.489  56.253  14.271  1.00 14.87      A    C  
ATOM    527  OE1 GLU    76      -8.435  56.654  14.801  1.00 17.31      A    O  
ATOM    528  OE2 GLU    76     -10.522  56.955  14.177  1.00 14.89      A    O  
ATOM    529  C   GLU    76      -8.549  52.039  13.324  1.00  9.62      A    C  
ATOM    530  O   GLU    76      -8.989  51.897  12.185  1.00  9.61      A    O  
ATOM    531  N   TYR    77      -7.254  51.884  13.622  1.00  9.34      A    N  
ATOM    532  CA  TYR    77      -6.245  51.540  12.617  1.00  9.97      A    C  
ATOM    533  CB  TYR    77      -4.843  51.445  13.269  1.00  9.16      A    C  
ATOM    534  CG  TYR    77      -3.741  51.179  12.267  1.00  9.29      A    C  
ATOM    535  CD1 TYR    77      -3.079  52.228  11.645  1.00 12.12      A    C  
ATOM    536  CE1 TYR    77      -2.077  51.991  10.716  1.00 12.93      A    C  
ATOM    537  CZ  TYR    77      -1.740  50.692  10.413  1.00 12.43      A    C  
ATOM    538  OH  TYR    77      -0.748  50.415   9.491  1.00 13.90      A    O  
ATOM    539  CE2 TYR    77      -2.390  49.645  11.012  1.00 12.32      A    C  
ATOM    540  CD2 TYR    77      -3.382  49.893  11.940  1.00 11.30      A    C  
ATOM    541  C   TYR    77      -6.588  50.227  11.932  1.00 10.77      A    C  
ATOM    542  O   TYR    77      -6.526  50.118  10.713  1.00 11.12      A    O  
ATOM    543  N   CYS    78      -6.971  49.224  12.714  1.00 11.11      A    N  
ATOM    544  CA  CYS    78      -7.256  47.917  12.148  1.00 12.12      A    C  
ATOM    545  CB  CYS    78      -7.457  46.883  13.238  1.00 12.01      A    C  
ATOM    546  SG  CYS    78      -5.887  46.440  14.033  1.00 12.83      A    S  
ATOM    547  C   CYS    78      -8.461  47.969  11.218  1.00 12.71      A    C  
ATOM    548  O   CYS    78      -8.450  47.364  10.154  1.00 13.65      A    O  
ATOM    549  N   ALA    79      -9.493  48.696  11.619  1.00 13.19      A    N  
ATOM    550  CA  ALA    79     -10.673  48.839  10.770  1.00 14.27      A    C  
ATOM    551  CB  ALA    79     -11.831  49.481  11.538  1.00 14.37      A    C  
ATOM    552  C   ALA    79     -10.336  49.651   9.517  1.00 14.88      A    C  
ATOM    553  O   ALA    79     -10.793  49.332   8.413  1.00 16.04      A    O  
ATOM    554  N   ALA    80      -9.535  50.694   9.683  1.00 15.58      A    N  
ATOM    555  CA  ALA    80      -9.218  51.596   8.580  1.00 16.51      A    C  
ATOM    556  CB  ALA    80      -8.522  52.842   9.096  1.00 16.50      A    C  
ATOM    557  C   ALA    80      -8.359  50.908   7.528  1.00 17.40      A    C  
ATOM    558  O   ALA    80      -8.511  51.158   6.324  1.00 17.37      A    O  
ATOM    559  N   ARG    81      -7.473  50.019   7.978  1.00 17.86      A    N  
ATOM    560  CA  ARG    81      -6.459  49.440   7.105  1.00 18.60      A    C  
ATOM    561  CB  ARG    81      -5.071  49.521   7.750  1.00 18.91      A    C  
ATOM    562  CG  ARG    81      -4.677  50.897   8.239  1.00 21.65      A    C  
ATOM    563  CD  ARG    81      -4.958  51.991   7.242  1.00 28.32      A    C  
ATOM    564  NE  ARG    81      -4.214  53.181   7.637  1.00 31.43      A    N  
ATOM    565  CZ  ARG    81      -2.958  53.413   7.270  1.00 32.72      A    C  
ATOM    566  NH1 ARG    81      -2.340  52.543   6.478  1.00 34.15      A    N  
ATOM    567  NH2 ARG    81      -2.329  54.509   7.685  1.00 32.17      A    N  
ATOM    568  C   ARG    81      -6.736  47.997   6.758  1.00 18.28      A    C  
ATOM    569  O   ARG    81      -6.026  47.422   5.933  1.00 19.97      A    O  
ATOM    570  N   GLY    82      -7.733  47.391   7.401  1.00 16.96      A    N  
ATOM    571  CA  GLY    82      -8.090  46.009   7.102  1.00 15.99      A    C  
ATOM    572  C   GLY    82      -7.157  44.976   7.705  1.00 15.51      A    C  
ATOM    573  O   GLY    82      -6.957  43.901   7.128  1.00 15.97      A    O  
ATOM    574  N   VAL    83      -6.578  45.293   8.863  1.00 14.33      A    N  
ATOM    575  CA  VAL    83      -5.756  44.326   9.604  1.00 13.75      A    C  
ATOM    576  CB  VAL    83      -4.874  45.009  10.675  1.00 13.17      A    C  
ATOM    577  CG1 VAL    83      -4.049  43.961  11.402  1.00 12.94      A    C  
ATOM    578  CG2 VAL    83      -3.988  46.093  10.074  1.00 13.13      A    C  
ATOM    579  C   VAL    83      -6.678  43.371  10.340  1.00 13.66      A    C  
ATOM    580  O   VAL    83      -7.575  43.813  11.072  1.00 13.98      A    O  
ATOM    581  N   PRO    84      -6.477  42.061  10.158  1.00 13.63      A    N  
ATOM    582  CA  PRO    84      -7.341  41.084  10.834  1.00 13.76      A    C  
ATOM    583  CB  PRO    84      -6.753  39.730  10.398  1.00 14.02      A    C  
ATOM    584  CG  PRO    84      -6.072  40.025   9.089  1.00 14.50      A    C  
ATOM    585  CD  PRO    84      -5.524  41.421   9.228  1.00 14.23      A    C  
ATOM    586  C   PRO    84      -7.322  41.236  12.372  1.00 13.22      A    C  
ATOM    587  O   PRO    84      -6.259  41.271  13.008  1.00 12.96      A    O  
ATOM    588  N   HIS    85      -8.508  41.339  12.953  1.00 12.91      A    N  
ATOM    589  CA  HIS    85      -8.643  41.461  14.404  1.00 12.37      A    C  
ATOM    590  CB  HIS    85      -8.352  42.893  14.842  1.00 12.88      A    C  
ATOM    591  CG  HIS    85      -9.386  43.869  14.385  1.00 13.86      A    C  
ATOM    592  ND1 HIS    85      -9.571  44.175  13.056  1.00 13.97      A    N  
ATOM    593  CE1 HIS    85     -10.551  45.056  12.943  1.00 15.14      A    C  
ATOM    594  NE2 HIS    85     -11.020  45.317  14.151  1.00 14.84      A    N  
ATOM    595  CD2 HIS    85     -10.309  44.585  15.073  1.00 14.88      A    C  
ATOM    596  C   HIS    85     -10.068  41.123  14.780  1.00 12.31      A    C  
ATOM    597  O   HIS    85     -10.965  41.143  13.926  1.00 13.00      A    O  
ATOM    598  N   GLN    86     -10.291  40.837  16.058  1.00 11.53      A    N  
ATOM    599  CA  GLN    86     -11.628  40.510  16.564  1.00 11.67      A    C  
ATOM    600  CB  GLN    86     -11.820  38.994  16.655  1.00 11.93      A    C  
ATOM    601  CG  GLN    86     -11.932  38.285  15.303  1.00 13.88      A    C  
ATOM    602  CD  GLN    86     -11.704  36.774  15.374  1.00 17.56      A    C  
ATOM    603  OE1 GLN    86     -11.899  36.136  16.414  1.00 17.76      A    O  
ATOM    604  NE2 GLN    86     -11.292  36.193  14.239  1.00 19.92      A    N  
ATOM    605  C   GLN    86     -11.823  41.102  17.946  1.00 11.71      A    C  
ATOM    606  O   GLN    86     -11.004  40.885  18.844  1.00 11.32      A    O  
ATOM    607  N   ARG    87     -12.933  41.809  18.136  1.00 11.69      A    N  
ATOM    608  CA  ARG    87     -13.265  42.348  19.462  1.00 11.99      A    C  
ATOM    609  CB  ARG    87     -14.031  43.668  19.309  1.00 12.89      A    C  
ATOM    610  CG  ARG    87     -14.273  44.445  20.605  1.00 14.41      A    C  
ATOM    611  CD  ARG    87     -15.091  45.710  20.314  1.00 20.91      A    C  
ATOM    612  NE  ARG    87     -14.431  46.515  19.294  1.00 25.76      A    N  
ATOM    613  CZ  ARG    87     -14.793  46.590  18.015  1.00 26.20      A    C  
ATOM    614  NH1 ARG    87     -15.862  45.927  17.562  1.00 27.13      A    N  
ATOM    615  NH2 ARG    87     -14.078  47.337  17.184  1.00 25.93      A    N  
ATOM    616  C   ARG    87     -14.096  41.313  20.202  1.00 12.26      A    C  
ATOM    617  O   ARG    87     -15.322  41.471  20.361  1.00 12.43      A    O  
ATOM    618  N   LEU    88     -13.453  40.236  20.648  1.00 10.62      A    N  
ATOM    619  CA  LEU    88     -14.241  39.100  21.116  1.00 11.30      A    C  
ATOM    620  CB  LEU    88     -13.617  37.759  20.741  1.00 12.92      A    C  
ATOM    621  CG  LEU    88     -12.107  37.634  20.707  1.00 16.29      A    C  
ATOM    622  CD1 LEU    88     -11.483  38.125  21.990  1.00 18.49      A    C  
ATOM    623  CD2 LEU    88     -11.729  36.191  20.433  1.00 18.42      A    C  
ATOM    624  C   LEU    88     -14.594  39.127  22.586  1.00  9.68      A    C  
ATOM    625  O   LEU    88     -15.452  38.364  23.027  1.00  9.63      A    O  
ATOM    626  N   GLY    89     -13.950  40.009  23.345  1.00  8.23      A    N  
ATOM    627  CA  GLY    89     -14.279  40.148  24.753  1.00  8.07      A    C  
ATOM    628  C   GLY    89     -13.477  39.183  25.614  1.00  7.92      A    C  
ATOM    629  O   GLY    89     -12.870  38.230  25.114  1.00  7.11      A    O  
ATOM    630  N   LYS    90     -13.508  39.426  26.918  1.00  7.81      A    N  
ATOM    631  CA  LYS    90     -12.735  38.656  27.887  1.00  7.49      A    C  
ATOM    632  CB  LYS    90     -11.427  39.394  28.131  1.00  7.84      A    C  
ATOM    633  CG  LYS    90     -10.691  39.060  29.412  1.00  9.00      A    C  
ATOM    634  CD  LYS    90      -9.432  39.914  29.414  1.00 13.02      A    C  
ATOM    635  CE  LYS    90      -8.967  40.280  30.789  1.00 16.81      A    C  
ATOM    636  NZ  LYS    90      -7.546  40.741  30.725  1.00 15.31      A    N  
ATOM    637  C   LYS    90     -13.507  38.559  29.184  1.00  7.93      A    C  
ATOM    638  O   LYS    90     -14.272  39.470  29.515  1.00  7.95      A    O  
ATOM    639  N   LEU    91     -13.337  37.448  29.903  1.00  7.09      A    N  
ATOM    640  CA  LEU    91     -13.840  37.326  31.272  1.00  7.34      A    C  
ATOM    641  CB  LEU    91     -14.664  36.055  31.441  1.00  8.01      A    C  
ATOM    642  CG  LEU    91     -15.830  35.856  30.473  1.00 12.27      A    C  
ATOM    643  CD1 LEU    91     -16.554  34.549  30.737  1.00 15.66      A    C  
ATOM    644  CD2 LEU    91     -16.777  37.000  30.617  1.00 14.57      A    C  
ATOM    645  C   LEU    91     -12.650  37.235  32.212  1.00  7.37      A    C  
ATOM    646  O   LEU    91     -11.741  36.422  31.976  1.00  6.40      A    O  
ATOM    647  N   ILE    92     -12.639  38.075  33.247  1.00  6.71      A    N  
ATOM    648  CA  ILE    92     -11.746  37.875  34.380  1.00  7.10      A    C  
ATOM    649  CB  ILE    92     -11.371  39.195  35.053  1.00  6.40      A    C  
ATOM    650  CG1 ILE    92     -10.573  40.055  34.080  1.00  8.68      A    C  
ATOM    651  CD1 ILE    92     -10.285  41.480  34.618  1.00  8.17      A    C  
ATOM    652  CG2 ILE    92     -10.529  38.921  36.285  1.00  8.16      A    C  
ATOM    653  C   ILE    92     -12.543  37.035  35.353  1.00  7.55      A    C  
ATOM    654  O   ILE    92     -13.602  37.474  35.808  1.00  7.25      A    O  
ATOM    655  N   VAL    93     -12.060  35.828  35.642  1.00  6.72      A    N  
ATOM    656  CA  VAL    93     -12.872  34.870  36.404  1.00  7.87      A    C  
ATOM    657  CB  VAL    93     -13.009  33.514  35.645  1.00  7.58      A    C  
ATOM    658  CG1 VAL    93     -13.709  33.730  34.311  1.00  8.64      A    C  
ATOM    659  CG2 VAL    93     -11.628  32.870  35.444  1.00  7.96      A    C  
ATOM    660  C   VAL    93     -12.333  34.642  37.802  1.00  8.68      A    C  
ATOM    661  O   VAL    93     -11.124  34.456  37.980  1.00  8.93      A    O  
ATOM    662  N   ALA    94     -13.237  34.689  38.788  1.00  8.80      A    N  
ATOM    663  CA  ALA    94     -12.923  34.353  40.179  1.00  9.50      A    C  
ATOM    664  CB  ALA    94     -13.704  35.269  41.152  1.00  9.26      A    C  
ATOM    665  C   ALA    94     -13.302  32.890  40.411  1.00 10.61      A    C  
ATOM    666  O   ALA    94     -14.404  32.470  40.052  1.00 11.06      A    O  
ATOM    667  N   THR    95     -12.400  32.114  41.003  1.00 11.54      A    N  
ATOM    668  CA  THR    95     -12.683  30.697  41.212  1.00 12.50      A    C  
ATOM    669  CB  THR    95     -11.698  29.798  40.436  1.00 12.97      A    C  
ATOM    670  OG1 THR    95     -10.366  30.087  40.852  1.00 13.56      A    O  
ATOM    671  CG2 THR    95     -11.841  30.043  38.944  1.00 14.34      A    C  
ATOM    672  C   THR    95     -12.754  30.313  42.701  1.00 12.82      A    C  
ATOM    673  O   THR    95     -12.652  29.134  43.063  1.00 13.39      A    O  
ATOM    674  N   SER    96     -12.962  31.318  43.548  1.00 12.55      A    N  
ATOM    675  CA  SER    96     -13.217  31.103  44.967  1.00 12.29      A    C  
ATOM    676  CB  SER    96     -11.906  30.932  45.746  1.00 12.43      A    C  
ATOM    677  OG  SER    96     -11.225  32.172  45.884  1.00 10.79      A    O  
ATOM    678  C   SER    96     -13.987  32.317  45.482  1.00 13.35      A    C  
ATOM    679  O   SER    96     -14.070  33.341  44.799  1.00 13.14      A    O  
ATOM    680  N   ASP    97     -14.578  32.201  46.668  1.00 13.76      A    N  
ATOM    681  CA  ASP    97     -15.234  33.357  47.273  1.00 14.33      A    C  
ATOM    682  CB  ASP    97     -15.897  32.977  48.602  1.00 15.48      A    C  
ATOM    683  CG  ASP    97     -17.086  32.073  48.430  1.00 18.72      A    C  
ATOM    684  OD1 ASP    97     -17.653  31.983  47.316  1.00 20.38      A    O  
ATOM    685  OD2 ASP    97     -17.480  31.454  49.447  1.00 22.82      A    O  
ATOM    686  C   ASP    97     -14.245  34.495  47.533  1.00 13.36      A    C  
ATOM    687  O   ASP    97     -14.590  35.664  47.345  1.00 13.75      A    O  
ATOM    688  N   ALA    98     -13.033  34.171  47.982  1.00 12.77      A    N  
ATOM    689  CA  ALA    98     -12.038  35.218  48.256  1.00 12.41      A    C  
ATOM    690  CB  ALA    98     -10.769  34.619  48.857  1.00 13.38      A    C  
ATOM    691  C   ALA    98     -11.716  35.984  46.972  1.00 11.71      A    C  
ATOM    692  O   ALA    98     -11.676  37.212  46.954  1.00 10.94      A    O  
ATOM    693  N   GLU    99     -11.518  35.254  45.877  1.00 11.04      A    N  
ATOM    694  CA  GLU    99     -11.274  35.910  44.589  1.00 10.61      A    C  
ATOM    695  CB  GLU    99     -10.896  34.877  43.532  1.00 10.42      A    C  
ATOM    696  CG  GLU    99      -9.552  34.251  43.837  1.00 10.44      A    C  
ATOM    697  CD  GLU    99      -9.021  33.408  42.695  1.00 11.98      A    C  
ATOM    698  OE1 GLU    99      -9.779  33.116  41.748  1.00 11.82      A    O  
ATOM    699  OE2 GLU    99      -7.832  33.046  42.759  1.00 14.81      A    O  
ATOM    700  C   GLU    99     -12.462  36.727  44.108  1.00 10.14      A    C  
ATOM    701  O   GLU    99     -12.287  37.799  43.506  1.00  9.42      A    O  
ATOM    702  N   ALA   100     -13.669  36.220  44.353  1.00  9.81      A    N  
ATOM    703  CA  ALA   100     -14.864  36.939  43.928  1.00  9.80      A    C  
ATOM    704  CB  ALA   100     -16.112  36.138  44.236  1.00 10.31      A    C  
ATOM    705  C   ALA   100     -14.913  38.301  44.619  1.00  9.95      A    C  
ATOM    706  O   ALA   100     -15.399  39.279  44.038  1.00  9.60      A    O  
ATOM    707  N   SER   101     -14.411  38.347  45.851  1.00  9.51      A    N  
ATOM    708  CA  SER   101     -14.391  39.583  46.635  1.00 10.70      A    C  
ATOM    709  CB  SER   101     -14.057  39.273  48.093  1.00 11.53      A    C  
ATOM    710  OG  SER   101     -15.161  38.608  48.693  1.00 17.43      A    O  
ATOM    711  C   SER   101     -13.428  40.629  46.090  1.00 10.14      A    C  
ATOM    712  O   SER   101     -13.536  41.822  46.439  1.00 10.35      A    O  
ATOM    713  N   GLN   102     -12.500  40.189  45.241  1.00  8.68      A    N  
ATOM    714  CA  GLN   102     -11.491  41.073  44.649  1.00  7.88      A    C  
ATOM    715  CB  GLN   102     -10.244  40.253  44.285  1.00  7.99      A    C  
ATOM    716  CG  GLN   102      -9.545  39.752  45.539  1.00  9.55      A    C  
ATOM    717  CD  GLN   102      -8.329  38.929  45.250  1.00 12.22      A    C  
ATOM    718  OE1 GLN   102      -8.312  38.164  44.297  1.00 11.23      A    O  
ATOM    719  NE2 GLN   102      -7.296  39.067  46.084  1.00 14.05      A    N  
ATOM    720  C   GLN   102     -12.004  41.836  43.439  1.00  7.47      A    C  
ATOM    721  O   GLN   102     -11.404  42.827  43.019  1.00  7.61      A    O  
ATOM    722  N   LEU   103     -13.133  41.379  42.883  1.00  7.16      A    N  
ATOM    723  CA  LEU   103     -13.582  41.909  41.593  1.00  7.26      A    C  
ATOM    724  CB  LEU   103     -14.694  41.030  41.005  1.00  6.51      A    C  
ATOM    725  CG  LEU   103     -14.328  39.589  40.608  1.00  7.86      A    C  
ATOM    726  CD1 LEU   103     -15.549  38.902  39.995  1.00  7.61      A    C  
ATOM    727  CD2 LEU   103     -13.159  39.544  39.646  1.00  8.32      A    C  
ATOM    728  C   LEU   103     -14.023  43.379  41.668  1.00  7.37      A    C  
ATOM    729  O   LEU   103     -13.803  44.160  40.728  1.00  7.45      A    O  
ATOM    730  N   ASP   104     -14.645  43.770  42.775  1.00  8.24      A    N  
ATOM    731  CA  ASP   104     -15.186  45.132  42.828  1.00  8.79      A    C  
ATOM    732  CB  ASP   104     -15.919  45.389  44.137  1.00  9.63      A    C  
ATOM    733  CG  ASP   104     -17.371  44.900  44.122  1.00 13.58      A    C  
ATOM    734  OD1 ASP   104     -17.931  44.588  43.046  1.00 16.04      A    O  
ATOM    735  OD2 ASP   104     -17.967  44.853  45.217  1.00 16.17      A    O  
ATOM    736  C   ASP   104     -14.042  46.140  42.666  1.00  8.10      A    C  
ATOM    737  O   ASP   104     -14.156  47.117  41.920  1.00  8.37      A    O  
ATOM    738  N   SER   105     -12.935  45.909  43.370  1.00  7.66      A    N  
ATOM    739  CA  SER   105     -11.822  46.866  43.350  1.00  7.70      A    C  
ATOM    740  CB  SER   105     -10.786  46.490  44.418  1.00  8.34      A    C  
ATOM    741  OG  SER   105      -9.675  47.379  44.362  1.00 13.63      A    O  
ATOM    742  C   SER   105     -11.162  46.878  41.977  1.00  7.19      A    C  
ATOM    743  O   SER   105     -10.722  47.915  41.467  1.00  7.04      A    O  
ATOM    744  N   ILE   106     -11.082  45.702  41.368  1.00  6.71      A    N  
ATOM    745  CA  ILE   106     -10.522  45.617  40.020  1.00  6.69      A    C  
ATOM    746  CB  ILE   106     -10.476  44.143  39.556  1.00  6.42      A    C  
ATOM    747  CG1 ILE   106      -9.456  43.362  40.384  1.00  6.41      A    C  
ATOM    748  CD1 ILE   106      -9.572  41.854  40.154  1.00  7.76      A    C  
ATOM    749  CG2 ILE   106     -10.096  44.037  38.076  1.00  7.38      A    C  
ATOM    750  C   ILE   106     -11.352  46.464  39.041  1.00  6.80      A    C  
ATOM    751  O   ILE   106     -10.811  47.213  38.229  1.00  7.18      A    O  
ATOM    752  N   ALA   107     -12.677  46.348  39.115  1.00  7.29      A    N  
ATOM    753  CA  ALA   107     -13.541  47.146  38.238  1.00  7.35      A    C  
ATOM    754  CB  ALA   107     -15.003  46.727  38.393  1.00  8.25      A    C  
ATOM    755  C   ALA   107     -13.392  48.646  38.508  1.00  8.04      A    C  
ATOM    756  O   ALA   107     -13.462  49.456  37.579  1.00  7.76      A    O  
ATOM    757  N   ARG   108     -13.203  49.020  39.767  1.00  7.42      A    N  
ATOM    758  CA  ARG   108     -12.992  50.438  40.090  1.00  7.90      A    C  
ATOM    759  CB  ARG   108     -13.087  50.666  41.605  1.00  8.29      A    C  
ATOM    760  CG  ARG   108     -14.499  50.462  42.121  1.00  9.36      A    C  
ATOM    761  CD  ARG   108     -14.615  50.678  43.605  1.00 15.68      A    C  
ATOM    762  NE  ARG   108     -15.910  50.199  44.077  1.00 20.10      A    N  
ATOM    763  CZ  ARG   108     -16.080  49.241  44.985  1.00 22.84      A    C  
ATOM    764  NH1 ARG   108     -15.032  48.639  45.554  1.00 22.97      A    N  
ATOM    765  NH2 ARG   108     -17.309  48.878  45.326  1.00 23.77      A    N  
ATOM    766  C   ARG   108     -11.668  50.945  39.519  1.00  7.91      A    C  
ATOM    767  O   ARG   108     -11.569  52.084  39.044  1.00  9.07      A    O  
ATOM    768  N   ARG   109     -10.638  50.104  39.542  1.00  7.76      A    N  
ATOM    769  CA  ARG   109      -9.363  50.538  38.958  1.00  8.02      A    C  
ATOM    770  CB  ARG   109      -8.236  49.535  39.225  1.00  7.91      A    C  
ATOM    771  CG  ARG   109      -6.935  50.049  38.675  1.00  7.80      A    C  
ATOM    772  CD  ARG   109      -5.766  49.156  39.053  1.00  7.81      A    C  
ATOM    773  NE  ARG   109      -5.528  49.147  40.493  1.00  9.55      A    N  
ATOM    774  CZ  ARG   109      -4.473  48.561  41.060  1.00 11.61      A    C  
ATOM    775  NH1 ARG   109      -3.556  47.968  40.289  1.00 11.06      A    N  
ATOM    776  NH2 ARG   109      -4.335  48.572  42.383  1.00 10.41      A    N  
ATOM    777  C   ARG   109      -9.514  50.766  37.464  1.00  8.06      A    C  
ATOM    778  O   ARG   109      -9.035  51.774  36.924  1.00  7.99      A    O  
ATOM    779  N   ALA   110     -10.196  49.840  36.796  1.00  8.57      A    N  
ATOM    780  CA  ALA   110     -10.429  49.939  35.355  1.00  8.03      A    C  
ATOM    781  CB  ALA   110     -11.232  48.750  34.872  1.00  8.74      A    C  
ATOM    782  C   ALA   110     -11.189  51.233  35.070  1.00  8.42      A    C  
ATOM    783  O   ALA   110     -10.843  51.970  34.155  1.00  8.72      A    O  
ATOM    784  N   GLY   111     -12.226  51.499  35.849  1.00  8.72      A    N  
ATOM    785  CA  GLY   111     -13.012  52.725  35.640  1.00  9.25      A    C  
ATOM    786  C   GLY   111     -12.139  53.965  35.705  1.00 10.46      A    C  
ATOM    787  O   GLY   111     -12.298  54.901  34.900  1.00 11.07      A    O  
ATOM    788  N   ALA   112     -11.207  53.982  36.647  1.00  9.87      A    N  
ATOM    789  CA  ALA   112     -10.353  55.142  36.839  1.00 10.21      A    C  
ATOM    790  CB  ALA   112      -9.618  55.060  38.163  1.00 10.82      A    C  
ATOM    791  C   ALA   112      -9.377  55.306  35.689  1.00 10.06      A    C  
ATOM    792  O   ALA   112      -8.877  56.405  35.445  1.00 11.14      A    O  
ATOM    793  N   ASN   113      -9.088  54.201  34.993  1.00  9.16      A    N  
ATOM    794  CA  ASN   113      -8.221  54.236  33.813  1.00  8.58      A    C  
ATOM    795  CB  ASN   113      -7.544  52.867  33.610  1.00  8.54      A    C  
ATOM    796  CG  ASN   113      -6.440  52.615  34.610  1.00  8.49      A    C  
ATOM    797  OD1 ASN   113      -5.916  53.557  35.226  1.00 10.25      A    O  
ATOM    798  ND2 ASN   113      -6.090  51.336  34.802  1.00  8.99      A    N  
ATOM    799  C   ASN   113      -8.962  54.614  32.529  1.00  9.31      A    C  
ATOM    800  O   ASN   113      -8.355  54.705  31.436  1.00  8.68      A    O  
ATOM    801  N   GLY   114     -10.267  54.817  32.654  1.00  9.70      A    N  
ATOM    802  CA  GLY   114     -11.121  55.088  31.496  1.00 11.28      A    C  
ATOM    803  C   GLY   114     -11.697  53.858  30.805  1.00 11.74      A    C  
ATOM    804  O   GLY   114     -12.109  53.922  29.638  1.00 13.21      A    O  
ATOM    805  N   VAL   115     -11.737  52.734  31.515  1.00 11.48      A    N  
ATOM    806  CA  VAL   115     -12.386  51.534  31.014  1.00 11.45      A    C  
ATOM    807  CB  VAL   115     -11.535  50.271  31.295  1.00 10.60      A    C  
ATOM    808  CG1 VAL   115     -12.212  49.040  30.711  1.00 12.53      A    C  
ATOM    809  CG2 VAL   115     -10.120  50.450  30.738  1.00 13.32      A    C  
ATOM    810  C   VAL   115     -13.709  51.420  31.746  1.00 12.02      A    C  
ATOM    811  O   VAL   115     -13.766  51.014  32.895  1.00 11.16      A    O  
ATOM    812  N   ASP   116     -14.784  51.832  31.103  1.00 13.59      A    N  
ATOM    813  CA  ASP   116     -15.992  51.963  31.880  1.00 15.54      A    C  
ATOM    814  CB  ASP   116     -16.457  53.432  31.940  1.00 16.87      A    C  
ATOM    815  CG  ASP   116     -15.604  54.279  32.907  1.00 19.81      A    C  
ATOM    816  OD1 ASP   116     -16.016  54.458  34.075  1.00 26.33      A    O  
ATOM    817  OD2 ASP   116     -14.505  54.740  32.527  1.00 21.36      A    O  
ATOM    818  C   ASP   116     -17.075  50.984  31.423  1.00 15.16      A    C  
ATOM    819  O   ASP   116     -18.230  51.092  31.840  1.00 17.09      A    O  
ATOM    820  N   ASP   117     -16.672  49.982  30.643  1.00 12.69      A    N  
ATOM    821  CA  ASP   117     -17.614  48.992  30.133  1.00 11.33      A    C  
ATOM    822  CB  ASP   117     -17.478  48.839  28.616  1.00 11.97      A    C  
ATOM    823  CG  ASP   117     -16.115  48.341  28.197  1.00 13.56      A    C  
ATOM    824  OD1 ASP   117     -15.264  48.117  29.083  1.00 11.65      A    O  
ATOM    825  OD2 ASP   117     -15.912  48.155  26.981  1.00 15.47      A    O  
ATOM    826  C   ASP   117     -17.543  47.618  30.804  1.00 10.19      A    C  
ATOM    827  O   ASP   117     -18.091  46.648  30.269  1.00  9.96      A    O  
ATOM    828  N   LEU   118     -16.887  47.511  31.957  1.00  9.45      A    N  
ATOM    829  CA  LEU   118     -16.838  46.185  32.609  1.00  9.46      A    C  
ATOM    830  CB  LEU   118     -15.809  46.120  33.738  1.00  9.00      A    C  
ATOM    831  CG  LEU   118     -14.355  46.415  33.367  1.00 11.18      A    C  
ATOM    832  CD1 LEU   118     -13.426  45.906  34.467  1.00 11.89      A    C  
ATOM    833  CD2 LEU   118     -13.983  45.779  32.025  1.00 12.04      A    C  
ATOM    834  C   LEU   118     -18.208  45.804  33.146  1.00 10.13      A    C  
ATOM    835  O   LEU   118     -19.002  46.675  33.507  1.00 10.94      A    O  
ATOM    836  N   GLN   119     -18.492  44.506  33.183  1.00  8.74      A    N  
ATOM    837  CA  GLN   119     -19.769  44.023  33.699  1.00  8.51      A    C  
ATOM    838  CB  GLN   119     -20.575  43.355  32.575  1.00  8.34      A    C  
ATOM    839  CG  GLN   119     -20.815  44.275  31.368  1.00 11.21      A    C  
ATOM    840  CD  GLN   119     -21.022  43.542  30.044  1.00 16.69      A    C  
ATOM    841  OE1 GLN   119     -20.068  43.037  29.427  1.00 21.22      A    O  
ATOM    842  NE2 GLN   119     -22.261  43.521  29.578  1.00 19.52      A    N  
ATOM    843  C   GLN   119     -19.476  42.994  34.781  1.00  8.64      A    C  
ATOM    844  O   GLN   119     -18.814  41.996  34.511  1.00  9.81      A    O  
ATOM    845  N   HIS   120     -19.995  43.216  35.983  1.00  8.48      A    N  
ATOM    846  CA  HIS   120     -19.736  42.320  37.103  1.00  8.47      A    C  
ATOM    847  CB  HIS   120     -19.609  43.152  38.379  1.00  8.76      A    C  
ATOM    848  CG  HIS   120     -19.097  42.399  39.565  1.00 10.10      A    C  
ATOM    849  ND1 HIS   120     -18.554  43.039  40.655  1.00 10.85      A    N  
ATOM    850  CE1 HIS   120     -18.200  42.140  41.560  1.00 11.17      A    C  
ATOM    851  NE2 HIS   120     -18.493  40.940  41.091  1.00 12.17      A    N  
ATOM    852  CD2 HIS   120     -19.053  41.074  39.841  1.00 11.02      A    C  
ATOM    853  C   HIS   120     -20.913  41.373  37.203  1.00  8.24      A    C  
ATOM    854  O   HIS   120     -22.040  41.826  37.399  1.00  9.20      A    O  
ATOM    855  N   ILE   121     -20.655  40.073  37.061  1.00  8.14      A    N  
ATOM    856  CA  ILE   121     -21.726  39.069  37.013  1.00  8.68      A    C  
ATOM    857  CB  ILE   121     -22.019  38.603  35.555  1.00  8.35      A    C  
ATOM    858  CG1 ILE   121     -20.833  37.820  34.976  1.00  9.73      A    C  
ATOM    859  CD1 ILE   121     -21.018  37.429  33.522  1.00  9.21      A    C  
ATOM    860  CG2 ILE   121     -22.390  39.799  34.670  1.00 10.25      A    C  
ATOM    861  C   ILE   121     -21.387  37.870  37.897  1.00  9.26      A    C  
ATOM    862  O   ILE   121     -20.231  37.678  38.255  1.00  9.54      A    O  
ATOM    863  N   ASP   122     -22.405  37.092  38.269  1.00  9.73      A    N  
ATOM    864  CA  ASP   122     -22.188  35.908  39.106  1.00 10.86      A    C  
ATOM    865  CB  ASP   122     -23.354  35.676  40.093  1.00 11.61      A    C  
ATOM    866  CG  ASP   122     -24.672  35.249  39.421  1.00 13.45      A    C  
ATOM    867  OD1 ASP   122     -24.695  34.799  38.247  1.00 14.14      A    O  
ATOM    868  OD2 ASP   122     -25.716  35.331  40.126  1.00 15.48      A    O  
ATOM    869  C   ASP   122     -21.845  34.691  38.265  1.00 10.57      A    C  
ATOM    870  O   ASP   122     -21.785  34.777  37.039  1.00 10.96      A    O  
ATOM    871  N   GLY   123     -21.563  33.559  38.908  1.00 11.14      A    N  
ATOM    872  CA  GLY   123     -21.061  32.405  38.165  1.00 11.24      A    C  
ATOM    873  C   GLY   123     -22.102  31.799  37.236  1.00 10.96      A    C  
ATOM    874  O   GLY   123     -21.777  31.279  36.165  1.00 10.79      A    O  
ATOM    875  N   ALA   124     -23.365  31.871  37.641  1.00 11.37      A    N  
ATOM    876  CA  ALA   124     -24.425  31.317  36.818  1.00 11.90      A    C  
ATOM    877  CB  ALA   124     -25.736  31.283  37.574  1.00 12.51      A    C  
ATOM    878  C   ALA   124     -24.551  32.145  35.559  1.00 11.88      A    C  
ATOM    879  O   ALA   124     -24.719  31.600  34.460  1.00 12.27      A    O  
ATOM    880  N   ALA   125     -24.464  33.468  35.710  1.00 11.08      A    N  
ATOM    881  CA  ALA   125     -24.471  34.355  34.540  1.00 11.35      A    C  
ATOM    882  CB  ALA   125     -24.527  35.840  34.954  1.00 10.70      A    C  
ATOM    883  C   ALA   125     -23.276  34.090  33.625  1.00 11.48      A    C  
ATOM    884  O   ALA   125     -23.409  34.069  32.397  1.00 12.27      A    O  
ATOM    885  N   ALA   126     -22.113  33.851  34.226  1.00 11.56      A    N  
ATOM    886  CA  ALA   126     -20.917  33.609  33.443  1.00 11.94      A    C  
ATOM    887  CB  ALA   126     -19.703  33.540  34.342  1.00 11.91      A    C  
ATOM    888  C   ALA   126     -21.073  32.313  32.670  1.00 12.63      A    C  
ATOM    889  O   ALA   126     -20.632  32.228  31.526  1.00 12.77      A    O  
ATOM    890  N   ARG   127     -21.703  31.312  33.290  1.00 13.27      A    N  
ATOM    891  CA  ARG   127     -21.963  30.046  32.598  1.00 15.12      A    C  
ATOM    892  CB  ARG   127     -22.409  28.938  33.557  1.00 15.73      A    C  
ATOM    893  CG  ARG   127     -22.422  27.574  32.871  1.00 19.72      A    C  
ATOM    894  CD  ARG   127     -23.038  26.512  33.742  1.00 28.32      A    C  
ATOM    895  NE  ARG   127     -22.144  26.082  34.814  1.00 32.45      A    N  
ATOM    896  CZ  ARG   127     -20.915  25.609  34.628  1.00 34.53      A    C  
ATOM    897  NH1 ARG   127     -20.399  25.526  33.410  1.00 36.22      A    N  
ATOM    898  NH2 ARG   127     -20.192  25.241  35.674  1.00 35.62      A    N  
ATOM    899  C   ARG   127     -22.977  30.194  31.455  1.00 15.15      A    C  
ATOM    900  O   ARG   127     -22.910  29.453  30.475  1.00 15.26      A    O  
ATOM    901  N   ARG   128     -23.908  31.142  31.563  1.00 15.50      A    N  
ATOM    902  CA  ARG   128     -24.790  31.443  30.424  1.00 16.16      A    C  
ATOM    903  CB  ARG   128     -25.851  32.486  30.767  1.00 16.85      A    C  
ATOM    904  CG  ARG   128     -26.902  32.009  31.742  1.00 20.03      A    C  
ATOM    905  CD  ARG   128     -28.158  32.920  31.714  1.00 23.38      A    C  
ATOM    906  NE  ARG   128     -27.918  34.274  32.227  1.00 25.47      A    N  
ATOM    907  CZ  ARG   128     -27.910  34.592  33.519  1.00 27.33      A    C  
ATOM    908  NH1 ARG   128     -28.118  33.653  34.446  1.00 27.69      A    N  
ATOM    909  NH2 ARG   128     -27.688  35.847  33.891  1.00 26.88      A    N  
ATOM    910  C   ARG   128     -23.991  31.946  29.232  1.00 15.98      A    C  
ATOM    911  O   ARG   128     -24.267  31.573  28.086  1.00 15.86      A    O  
ATOM    912  N   LEU   129     -23.008  32.801  29.506  1.00 14.53      A    N  
ATOM    913  CA  LEU   129     -22.157  33.354  28.466  1.00 14.54      A    C  
ATOM    914  CB  LEU   129     -21.324  34.523  29.013  1.00 14.23      A    C  
ATOM    915  CG  LEU   129     -22.077  35.802  29.379  1.00 15.66      A    C  
ATOM    916  CD1 LEU   129     -21.063  36.888  29.787  1.00 13.86      A    C  
ATOM    917  CD2 LEU   129     -22.936  36.264  28.210  1.00 17.99      A    C  
ATOM    918  C   LEU   129     -21.224  32.286  27.899  1.00 14.19      A    C  
ATOM    919  O   LEU   129     -20.954  32.262  26.691  1.00 14.72      A    O  
ATOM    920  N   GLU   130     -20.714  31.429  28.780  1.00 13.72      A    N  
ATOM    921  CA  GLU   130     -19.693  30.447  28.403  1.00 13.56      A    C  
ATOM    922  CB  GLU   130     -18.301  30.918  28.843  1.00 13.55      A    C  
ATOM    923  CG  GLU   130     -17.812  32.200  28.176  1.00 12.68      A    C  
ATOM    924  CD  GLU   130     -17.538  32.055  26.680  1.00 15.70      A    C  
ATOM    925  OE1 GLU   130     -17.409  30.913  26.192  1.00 15.22      A    O  
ATOM    926  OE2 GLU   130     -17.450  33.099  25.993  1.00 16.47      A    O  
ATOM    927  C   GLU   130     -19.994  29.120  29.069  1.00 13.88      A    C  
ATOM    928  O   GLU   130     -19.589  28.887  30.202  1.00 13.11      A    O  
ATOM    929  N   PRO   131     -20.737  28.253  28.372  1.00 14.53      A    N  
ATOM    930  CA  PRO   131     -21.213  26.989  28.923  1.00 15.31      A    C  
ATOM    931  CB  PRO   131     -21.841  26.302  27.703  1.00 15.14      A    C  
ATOM    932  CG  PRO   131     -22.378  27.450  26.909  1.00 15.68      A    C  
ATOM    933  CD  PRO   131     -21.346  28.545  27.061  1.00 15.28      A    C  
ATOM    934  C   PRO   131     -20.140  26.105  29.568  1.00 15.38      A    C  
ATOM    935  O   PRO   131     -20.448  25.354  30.491  1.00 16.32      A    O  
ATOM    936  N   ALA   132     -18.896  26.197  29.118  1.00 15.33      A    N  
ATOM    937  CA  ALA   132     -17.847  25.328  29.668  1.00 15.52      A    C  
ATOM    938  CB  ALA   132     -16.771  25.078  28.617  1.00 16.38      A    C  
ATOM    939  C   ALA   132     -17.208  25.875  30.945  1.00 15.75      A    C  
ATOM    940  O   ALA   132     -16.409  25.189  31.603  1.00 15.42      A    O  
ATOM    941  N   LEU   133     -17.577  27.104  31.303  1.00 14.25      A    N  
ATOM    942  CA  LEU   133     -16.881  27.834  32.363  1.00 14.20      A    C  
ATOM    943  CB  LEU   133     -17.013  29.332  32.104  1.00 13.32      A    C  
ATOM    944  CG  LEU   133     -16.291  30.281  33.061  1.00 13.73      A    C  
ATOM    945  CD1 LEU   133     -14.819  30.063  32.911  1.00 13.50      A    C  
ATOM    946  CD2 LEU   133     -16.631  31.749  32.722  1.00 13.79      A    C  
ATOM    947  C   LEU   133     -17.400  27.519  33.770  1.00 14.47      A    C  
ATOM    948  O   LEU   133     -18.607  27.572  34.019  1.00 15.12      A    O  
ATOM    949  N   HIS   134     -16.478  27.225  34.686  1.00 14.03      A    N  
ATOM    950  CA  HIS   134     -16.791  27.085  36.108  1.00 14.76      A    C  
ATOM    951  CB  HIS   134     -16.326  25.724  36.611  1.00 15.90      A    C  
ATOM    952  CG  HIS   134     -17.110  24.582  36.049  1.00 20.20      A    C  
ATOM    953  ND1 HIS   134     -17.115  24.268  34.704  1.00 24.70      A    N  
ATOM    954  CE1 HIS   134     -17.893  23.216  34.503  1.00 24.55      A    C  
ATOM    955  NE2 HIS   134     -18.387  22.834  35.668  1.00 26.33      A    N  
ATOM    956  CD2 HIS   134     -17.918  23.674  36.651  1.00 24.33      A    C  
ATOM    957  C   HIS   134     -16.131  28.199  36.914  1.00 13.53      A    C  
ATOM    958  O   HIS   134     -14.913  28.234  37.069  1.00 13.85      A    O  
ATOM    959  N   CYS   135     -16.927  29.153  37.383  1.00 12.51      A    N  
ATOM    960  CA  CYS   135     -16.371  30.209  38.219  1.00 11.65      A    C  
ATOM    961  CB  CYS   135     -15.875  31.389  37.375  1.00 11.43      A    C  
ATOM    962  SG  CYS   135     -17.216  32.398  36.638  1.00 12.32      A    S  
ATOM    963  C   CYS   135     -17.401  30.688  39.230  1.00 11.62      A    C  
ATOM    964  O   CYS   135     -18.592  30.391  39.108  1.00 12.40      A    O  
ATOM    965  N   THR   136     -16.925  31.458  40.205  1.00 10.92      A    N  
ATOM    966  CA  THR   136     -17.759  31.963  41.287  1.00 10.56      A    C  
ATOM    967  CB  THR   136     -16.915  32.176  42.555  1.00 11.24      A    C  
ATOM    968  OG1 THR   136     -16.345  30.909  42.944  1.00 13.55      A    O  
ATOM    969  CG2 THR   136     -17.777  32.718  43.690  1.00 11.81      A    C  
ATOM    970  C   THR   136     -18.403  33.284  40.877  1.00 10.16      A    C  
ATOM    971  O   THR   136     -19.545  33.552  41.213  1.00 10.24      A    O  
ATOM    972  N   ALA   137     -17.646  34.092  40.140  1.00  9.44      A    N  
ATOM    973  CA  ALA   137     -18.134  35.370  39.620  1.00  7.84      A    C  
ATOM    974  CB  ALA   137     -18.210  36.398  40.727  1.00  8.66      A    C  
ATOM    975  C   ALA   137     -17.164  35.822  38.552  1.00  7.88      A    C  
ATOM    976  O   ALA   137     -16.083  35.261  38.427  1.00  7.58      A    O  
ATOM    977  N   ALA   138     -17.527  36.831  37.767  1.00  6.45      A    N  
ATOM    978  CA  ALA   138     -16.600  37.287  36.739  1.00  6.77      A    C  
ATOM    979  CB  ALA   138     -16.755  36.458  35.465  1.00  5.81      A    C  
ATOM    980  C   ALA   138     -16.801  38.758  36.441  1.00  6.16      A    C  
ATOM    981  O   ALA   138     -17.863  39.324  36.754  1.00  7.09      A    O  
ATOM    982  N   LEU   139     -15.778  39.366  35.855  1.00  6.31      A    N  
ATOM    983  CA  LEU   139     -15.931  40.662  35.194  1.00  6.22      A    C  
ATOM    984  CB  LEU   139     -14.799  41.612  35.585  1.00  5.90      A    C  
ATOM    985  CG  LEU   139     -14.821  42.073  37.031  1.00  6.27      A    C  
ATOM    986  CD1 LEU   139     -13.501  42.801  37.369  1.00  8.20      A    C  
ATOM    987  CD2 LEU   139     -16.055  42.965  37.215  1.00  8.08      A    C  
ATOM    988  C   LEU   139     -15.845  40.430  33.699  1.00  6.93      A    C  
ATOM    989  O   LEU   139     -14.862  39.866  33.209  1.00  6.95      A    O  
ATOM    990  N   VAL   140     -16.857  40.882  32.971  1.00  6.51      A    N  
ATOM    991  CA  VAL   140     -16.795  40.888  31.522  1.00  7.14      A    C  
ATOM    992  CB  VAL   140     -18.203  40.794  30.884  1.00  7.16      A    C  
ATOM    993  CG1 VAL   140     -18.077  40.514  29.383  1.00  8.41      A    C  
ATOM    994  CG2 VAL   140     -19.015  39.715  31.557  1.00  8.16      A    C  
ATOM    995  C   VAL   140     -16.126  42.163  31.029  1.00  6.55      A    C  
ATOM    996  O   VAL   140     -16.484  43.262  31.452  1.00  7.58      A    O  
ATOM    997  N   SER   141     -15.179  42.009  30.103  1.00  6.10      A    N  
ATOM    998  CA  SER   141     -14.471  43.144  29.483  1.00  6.48      A    C  
ATOM    999  CB  SER   141     -12.967  43.087  29.802  1.00  5.90      A    C  
ATOM   1000  OG  SER   141     -12.256  44.072  29.083  1.00  6.81      A    O  
ATOM   1001  C   SER   141     -14.717  43.098  27.978  1.00  7.17      A    C  
ATOM   1002  O   SER   141     -13.993  42.443  27.229  1.00  7.47      A    O  
ATOM   1003  N   PRO   142     -15.766  43.796  27.523  1.00  7.70      A    N  
ATOM   1004  CA  PRO   142     -16.172  43.629  26.122  1.00  8.72      A    C  
ATOM   1005  CB  PRO   142     -17.576  44.249  26.053  1.00  9.16      A    C  
ATOM   1006  CG  PRO   142     -17.902  44.720  27.403  1.00  9.02      A    C  
ATOM   1007  CD  PRO   142     -16.733  44.549  28.335  1.00  8.19      A    C  
ATOM   1008  C   PRO   142     -15.234  44.264  25.106  1.00  9.17      A    C  
ATOM   1009  O   PRO   142     -15.268  43.884  23.930  1.00 10.78      A    O  
ATOM   1010  N   SER   143     -14.380  45.190  25.538  1.00  9.07      A    N  
ATOM   1011  CA  SER   143     -13.504  45.889  24.594  1.00  9.08      A    C  
ATOM   1012  CB  SER   143     -13.225  47.319  25.066  1.00  9.83      A    C  
ATOM   1013  OG  SER   143     -12.209  47.392  26.069  1.00 10.75      A    O  
ATOM   1014  C   SER   143     -12.193  45.128  24.333  1.00  8.98      A    C  
ATOM   1015  O   SER   143     -11.432  45.488  23.444  1.00  9.13      A    O  
ATOM   1016  N   THR   144     -11.939  44.088  25.121  1.00  7.62      A    N  
ATOM   1017  CA  THR   144     -10.721  43.289  24.934  1.00  7.76      A    C  
ATOM   1018  CB  THR   144     -10.529  42.313  26.113  1.00  7.89      A    C  
ATOM   1019  OG1 THR   144     -10.479  43.049  27.344  1.00  7.88      A    O  
ATOM   1020  CG2 THR   144      -9.238  41.507  25.945  1.00  7.59      A    C  
ATOM   1021  C   THR   144     -10.845  42.512  23.636  1.00  7.77      A    C  
ATOM   1022  O   THR   144     -11.920  41.986  23.336  1.00  8.55      A    O  
ATOM   1023  N   GLY   145      -9.767  42.459  22.853  1.00  7.14      A    N  
ATOM   1024  CA  GLY   145      -9.798  41.770  21.569  1.00  7.26      A    C  
ATOM   1025  C   GLY   145      -8.525  41.004  21.284  1.00  7.74      A    C  
ATOM   1026  O   GLY   145      -7.682  40.821  22.182  1.00  7.64      A    O  
ATOM   1027  N   ILE   146      -8.416  40.529  20.041  1.00  7.82      A    N  
ATOM   1028  CA  ILE   146      -7.192  39.904  19.534  1.00  8.08      A    C  
ATOM   1029  CB  ILE   146      -7.332  38.378  19.409  1.00  8.11      A    C  
ATOM   1030  CG1 ILE   146      -8.470  38.015  18.452  1.00  8.73      A    C  
ATOM   1031  CD1 ILE   146      -8.649  36.472  18.277  1.00  9.10      A    C  
ATOM   1032  CG2 ILE   146      -7.492  37.716  20.799  1.00  7.93      A    C  
ATOM   1033  C   ILE   146      -6.826  40.473  18.172  1.00  8.45      A    C  
ATOM   1034  O   ILE   146      -7.678  40.956  17.430  1.00  8.53      A    O  
ATOM   1035  N   VAL   147      -5.542  40.442  17.863  1.00  9.05      A    N  
ATOM   1036  CA  VAL   147      -5.032  40.986  16.605  1.00 10.93      A    C  
ATOM   1037  CB  VAL   147      -4.579  42.453  16.777  1.00 10.90      A    C  
ATOM   1038  CG1 VAL   147      -3.412  42.552  17.811  1.00 11.75      A    C  
ATOM   1039  CG2 VAL   147      -4.243  43.114  15.426  1.00 11.05      A    C  
ATOM   1040  C   VAL   147      -3.884  40.130  16.090  1.00 12.52      A    C  
ATOM   1041  O   VAL   147      -3.128  39.532  16.863  1.00 12.11      A    O  
ATOM   1042  N   ASP   148      -3.770  40.097  14.769  1.00 14.47      A    N  
ATOM   1043  CA  ASP   148      -2.664  39.450  14.093  1.00 16.95      A    C  
ATOM   1044  CB  ASP   148      -3.085  39.112  12.665  1.00 17.58      A    C  
ATOM   1045  CG  ASP   148      -1.964  38.477  11.847  1.00 21.13      A    C  
ATOM   1046  OD1 ASP   148      -0.775  38.668  12.182  1.00 23.02      A    O  
ATOM   1047  OD2 ASP   148      -2.295  37.779  10.861  1.00 24.53      A    O  
ATOM   1048  C   ASP   148      -1.506  40.422  14.093  1.00 16.87      A    C  
ATOM   1049  O   ASP   148      -1.511  41.396  13.345  1.00 17.36      A    O  
ATOM   1050  N   SER   149      -0.532  40.165  14.958  1.00 17.72      A    N  
ATOM   1051  CA  SER   149       0.528  41.121  15.224  1.00 18.68      A    C  
ATOM   1052  CB  SER   149       1.254  40.764  16.510  1.00 19.12      A    C  
ATOM   1053  OG  SER   149       1.909  39.516  16.379  1.00 22.53      A    O  
ATOM   1054  C   SER   149       1.504  41.170  14.066  1.00 18.52      A    C  
ATOM   1055  O   SER   149       2.071  42.227  13.770  1.00 18.58      A    O  
ATOM   1056  N   HIS   150       1.681  40.029  13.399  1.00 18.36      A    N  
ATOM   1057  CA  HIS   150       2.470  40.003  12.167  1.00 18.02      A    C  
ATOM   1058  CB  HIS   150       2.681  38.572  11.657  1.00 18.68      A    C  
ATOM   1059  CG  HIS   150       3.558  38.503  10.447  1.00 21.09      A    C  
ATOM   1060  ND1 HIS   150       4.884  38.882  10.472  1.00 25.40      A    N  
ATOM   1061  CE1 HIS   150       5.406  38.726   9.268  1.00 25.84      A    C  
ATOM   1062  NE2 HIS   150       4.462  38.273   8.461  1.00 25.44      A    N  
ATOM   1063  CD2 HIS   150       3.296  38.129   9.173  1.00 24.21      A    C  
ATOM   1064  C   HIS   150       1.853  40.888  11.079  1.00 16.84      A    C  
ATOM   1065  O   HIS   150       2.546  41.695  10.446  1.00 16.16      A    O  
ATOM   1066  N   ALA   151       0.545  40.763  10.873  1.00 16.24      A    N  
ATOM   1067  CA  ALA   151      -0.139  41.625   9.928  1.00 15.86      A    C  
ATOM   1068  CB  ALA   151      -1.597  41.246   9.813  1.00 16.38      A    C  
ATOM   1069  C   ALA   151      -0.014  43.080  10.356  1.00 15.47      A    C  
ATOM   1070  O   ALA   151       0.171  43.956   9.528  1.00 15.17      A    O  
ATOM   1071  N   LEU   152      -0.137  43.335  11.653  1.00 14.77      A    N  
ATOM   1072  CA  LEU   152      -0.056  44.710  12.140  1.00 14.27      A    C  
ATOM   1073  CB  LEU   152      -0.319  44.751  13.639  1.00 13.97      A    C  
ATOM   1074  CG  LEU   152      -0.373  46.128  14.281  1.00 13.87      A    C  
ATOM   1075  CD1 LEU   152      -1.591  46.910  13.748  1.00 11.37      A    C  
ATOM   1076  CD2 LEU   152      -0.468  45.935  15.789  1.00 11.28      A    C  
ATOM   1077  C   LEU   152       1.311  45.289  11.822  1.00 14.19      A    C  
ATOM   1078  O   LEU   152       1.419  46.393  11.319  1.00 13.70      A    O  
ATOM   1079  N   MET   153       2.357  44.515  12.099  1.00 14.92      A    N  
ATOM   1080  CA  MET   153       3.723  44.933  11.785  1.00 15.94      A    C  
ATOM   1081  CB  MET   153       4.716  43.865  12.236  1.00 16.58      A    C  
ATOM   1082  CG  MET   153       4.994  43.954  13.716  1.00 18.71      A    C  
ATOM   1083  SD  MET   153       6.135  42.731  14.333  1.00 25.55      A    S  
ATOM   1084  CE  MET   153       5.900  41.338  13.214  1.00 19.88      A    C  
ATOM   1085  C   MET   153       3.916  45.278  10.304  1.00 15.59      A    C  
ATOM   1086  O   MET   153       4.469  46.313   9.967  1.00 14.87      A    O  
ATOM   1087  N   LEU   154       3.444  44.406   9.426  1.00 15.91      A    N  
ATOM   1088  CA  LEU   154       3.581  44.625   7.994  1.00 16.35      A    C  
ATOM   1089  CB  LEU   154       3.024  43.412   7.241  1.00 17.02      A    C  
ATOM   1090  CG  LEU   154       3.863  42.144   7.359  1.00 19.65      A    C  
ATOM   1091  CD1 LEU   154       3.184  40.943   6.698  1.00 22.42      A    C  
ATOM   1092  CD2 LEU   154       5.226  42.393   6.731  1.00 22.25      A    C  
ATOM   1093  C   LEU   154       2.850  45.893   7.581  1.00 15.80      A    C  
ATOM   1094  O   LEU   154       3.295  46.623   6.696  1.00 15.54      A    O  
ATOM   1095  N   ALA   155       1.715  46.155   8.232  1.00 15.23      A    N  
ATOM   1096  CA  ALA   155       0.925  47.329   7.924  1.00 14.47      A    C  
ATOM   1097  CB  ALA   155      -0.490  47.232   8.577  1.00 14.80      A    C  
ATOM   1098  C   ALA   155       1.656  48.596   8.352  1.00 14.00      A    C  
ATOM   1099  O   ALA   155       1.692  49.576   7.606  1.00 14.23      A    O  
ATOM   1100  N   TYR   156       2.246  48.586   9.552  1.00 13.09      A    N  
ATOM   1101  CA  TYR   156       3.050  49.728  10.006  1.00 12.38      A    C  
ATOM   1102  CB  TYR   156       3.629  49.514  11.406  1.00 12.10      A    C  
ATOM   1103  CG  TYR   156       2.652  49.504  12.567  1.00 10.97      A    C  
ATOM   1104  CD1 TYR   156       1.308  49.845  12.400  1.00  9.82      A    C  
ATOM   1105  CE1 TYR   156       0.416  49.822  13.489  1.00 10.69      A    C  
ATOM   1106  CZ  TYR   156       0.891  49.518  14.757  1.00  9.74      A    C  
ATOM   1107  OH  TYR   156       0.036  49.505  15.850  1.00 10.56      A    O  
ATOM   1108  CE2 TYR   156       2.219  49.206  14.943  1.00 10.96      A    C  
ATOM   1109  CD2 TYR   156       3.096  49.209  13.850  1.00 11.32      A    C  
ATOM   1110  C   TYR   156       4.220  49.940   9.049  1.00 12.81      A    C  
ATOM   1111  O   TYR   156       4.559  51.070   8.709  1.00 12.43      A    O  
ATOM   1112  N   GLN   157       4.851  48.841   8.658  1.00 13.85      A    N  
ATOM   1113  CA  GLN   157       5.981  48.904   7.726  1.00 14.67      A    C  
ATOM   1114  CB  GLN   157       6.560  47.517   7.449  1.00 15.34      A    C  
ATOM   1115  CG  GLN   157       7.733  47.581   6.475  1.00 17.21      A    C  
ATOM   1116  CD  GLN   157       8.411  46.240   6.247  1.00 20.78      A    C  
ATOM   1117  OE1 GLN   157       8.147  45.261   6.941  1.00 23.92      A    O  
ATOM   1118  NE2 GLN   157       9.297  46.194   5.262  1.00 22.71      A    N  
ATOM   1119  C   GLN   157       5.576  49.552   6.417  1.00 14.89      A    C  
ATOM   1120  O   GLN   157       6.260  50.448   5.940  1.00 14.44      A    O  
ATOM   1121  N   GLY   158       4.482  49.068   5.828  1.00 15.07      A    N  
ATOM   1122  CA  GLY   158       3.913  49.666   4.616  1.00 15.81      A    C  
ATOM   1123  C   GLY   158       3.687  51.163   4.711  1.00 16.14      A    C  
ATOM   1124  O   GLY   158       4.078  51.917   3.818  1.00 16.18      A    O  
ATOM   1125  N   ASP   159       3.055  51.611   5.797  1.00 15.83      A    N  
ATOM   1126  CA  ASP   159       2.843  53.032   6.002  1.00 16.31      A    C  
ATOM   1127  CB  ASP   159       2.101  53.288   7.321  1.00 16.20      A    C  
ATOM   1128  CG  ASP   159       0.697  52.694   7.341  1.00 18.03      A    C  
ATOM   1129  OD1 ASP   159       0.209  52.235   6.279  1.00 18.03      A    O  
ATOM   1130  OD2 ASP   159       0.075  52.701   8.435  1.00 15.54      A    O  
ATOM   1131  C   ASP   159       4.153  53.809   6.029  1.00 16.11      A    C  
ATOM   1132  O   ASP   159       4.287  54.834   5.371  1.00 16.51      A    O  
ATOM   1133  N   ALA   160       5.122  53.338   6.809  1.00 16.03      A    N  
ATOM   1134  CA  ALA   160       6.379  54.061   6.948  1.00 15.64      A    C  
ATOM   1135  CB  ALA   160       7.279  53.375   7.976  1.00 15.92      A    C  
ATOM   1136  C   ALA   160       7.084  54.161   5.598  1.00 16.30      A    C  
ATOM   1137  O   ALA   160       7.596  55.223   5.225  1.00 15.95      A    O  
ATOM   1138  N   GLU   161       7.102  53.052   4.871  1.00 16.77      A    N  
ATOM   1139  CA  GLU   161       7.720  53.023   3.542  1.00 17.91      A    C  
ATOM   1140  CB  GLU   161       7.720  51.607   2.973  1.00 17.88      A    C  
ATOM   1141  CG  GLU   161       8.741  50.677   3.637  1.00 20.21      A    C  
ATOM   1142  CD  GLU   161       8.599  49.224   3.201  1.00 23.52      A    C  
ATOM   1143  OE1 GLU   161       7.532  48.844   2.680  1.00 26.93      A    O  
ATOM   1144  OE2 GLU   161       9.559  48.452   3.386  1.00 25.88      A    O  
ATOM   1145  C   GLU   161       7.024  53.986   2.584  1.00 18.29      A    C  
ATOM   1146  O   GLU   161       7.673  54.645   1.777  1.00 18.44      A    O  
ATOM   1147  N   SER   162       5.704  54.080   2.684  1.00 18.99      A    N  
ATOM   1148  CA  SER   162       4.956  55.017   1.843  1.00 19.41      A    C  
ATOM   1149  CB  SER   162       3.447  54.841   2.046  1.00 19.38      A    C  
ATOM   1150  OG  SER   162       2.985  55.633   3.131  1.00 23.20      A    O  
ATOM   1151  C   SER   162       5.377  56.468   2.090  1.00 19.47      A    C  
ATOM   1152  O   SER   162       5.243  57.324   1.206  1.00 19.90      A    O  
ATOM   1153  N   ASP   163       5.894  56.741   3.287  1.00 18.85      A    N  
ATOM   1154  CA  ASP   163       6.424  58.053   3.621  1.00 18.86      A    C  
ATOM   1155  CB  ASP   163       5.941  58.495   5.008  1.00 18.79      A    C  
ATOM   1156  CG  ASP   163       4.470  58.866   5.021  1.00 20.54      A    C  
ATOM   1157  OD1 ASP   163       3.996  59.411   3.996  1.00 20.38      A    O  
ATOM   1158  OD2 ASP   163       3.791  58.631   6.055  1.00 20.98      A    O  
ATOM   1159  C   ASP   163       7.952  58.064   3.563  1.00 18.06      A    C  
ATOM   1160  O   ASP   163       8.595  58.866   4.225  1.00 18.31      A    O  
ATOM   1161  N   GLY   164       8.512  57.166   2.760  1.00 18.01      A    N  
ATOM   1162  CA  GLY   164       9.936  57.192   2.425  1.00 17.80      A    C  
ATOM   1163  C   GLY   164      10.883  56.463   3.359  1.00 17.55      A    C  
ATOM   1164  O   GLY   164      12.110  56.488   3.159  1.00 17.16      A    O  
ATOM   1165  N   ALA   165      10.347  55.821   4.392  1.00 16.59      A    N  
ATOM   1166  CA  ALA   165      11.226  55.078   5.299  1.00 15.88      A    C  
ATOM   1167  CB  ALA   165      10.464  54.611   6.531  1.00 15.49      A    C  
ATOM   1168  C   ALA   165      11.848  53.895   4.581  1.00 15.99      A    C  
ATOM   1169  O   ALA   165      11.227  53.301   3.702  1.00 16.08      A    O  
ATOM   1170  N   GLN   166      13.089  53.572   4.946  1.00 15.87      A    N  
ATOM   1171  CA  GLN   166      13.783  52.403   4.409  1.00 16.04      A    C  
ATOM   1172  CB  GLN   166      15.063  52.818   3.694  1.00 16.57      A    C  
ATOM   1173  CG  GLN   166      14.817  53.598   2.408  1.00 17.98      A    C  
ATOM   1174  CD  GLN   166      16.094  53.867   1.628  1.00 21.08      A    C  
ATOM   1175  OE1 GLN   166      16.923  52.979   1.448  1.00 23.16      A    O  
ATOM   1176  NE2 GLN   166      16.249  55.097   1.157  1.00 20.86      A    N  
ATOM   1177  C   GLN   166      14.134  51.479   5.564  1.00 15.97      A    C  
ATOM   1178  O   GLN   166      14.580  51.938   6.615  1.00 16.12      A    O  
ATOM   1179  N   LEU   167      13.920  50.188   5.373  1.00 15.41      A    N  
ATOM   1180  CA  LEU   167      14.239  49.197   6.385  1.00 16.04      A    C  
ATOM   1181  CB  LEU   167      13.047  48.288   6.632  1.00 16.45      A    C  
ATOM   1182  CG  LEU   167      11.863  48.925   7.362  1.00 18.85      A    C  
ATOM   1183  CD1 LEU   167      10.928  49.624   6.390  1.00 21.28      A    C  
ATOM   1184  CD2 LEU   167      11.135  47.861   8.152  1.00 20.90      A    C  
ATOM   1185  C   LEU   167      15.400  48.358   5.908  1.00 15.59      A    C  
ATOM   1186  O   LEU   167      15.386  47.864   4.770  1.00 15.57      A    O  
ATOM   1187  N   VAL   168      16.401  48.187   6.769  1.00 14.78      A    N  
ATOM   1188  CA  VAL   168      17.559  47.372   6.415  1.00 14.56      A    C  
ATOM   1189  CB  VAL   168      18.876  48.187   6.329  1.00 14.89      A    C  
ATOM   1190  CG1 VAL   168      18.823  49.156   5.161  1.00 16.13      A    C  
ATOM   1191  CG2 VAL   168      19.174  48.941   7.626  1.00 15.18      A    C  
ATOM   1192  C   VAL   168      17.697  46.230   7.410  1.00 14.04      A    C  
ATOM   1193  O   VAL   168      17.853  46.465   8.608  1.00 13.41      A    O  
ATOM   1194  N   PHE   169      17.589  45.004   6.905  1.00 13.28      A    N  
ATOM   1195  CA  PHE   169      17.640  43.818   7.757  1.00 13.58      A    C  
ATOM   1196  CB  PHE   169      16.650  42.755   7.264  1.00 13.70      A    C  
ATOM   1197  CG  PHE   169      15.212  43.168   7.435  1.00 15.53      A    C  
ATOM   1198  CD1 PHE   169      14.573  43.012   8.668  1.00 16.84      A    C  
ATOM   1199  CE1 PHE   169      13.258  43.403   8.842  1.00 18.53      A    C  
ATOM   1200  CZ  PHE   169      12.567  43.973   7.779  1.00 18.35      A    C  
ATOM   1201  CE2 PHE   169      13.193  44.145   6.547  1.00 17.55      A    C  
ATOM   1202  CD2 PHE   169      14.508  43.728   6.375  1.00 16.64      A    C  
ATOM   1203  C   PHE   169      19.067  43.272   7.865  1.00 13.19      A    C  
ATOM   1204  O   PHE   169      19.973  43.773   7.201  1.00 13.60      A    O  
ATOM   1205  N   HIS   170      19.252  42.277   8.726  1.00 12.99      A    N  
ATOM   1206  CA  HIS   170      20.580  41.741   9.069  1.00 13.34      A    C  
ATOM   1207  CB  HIS   170      21.019  40.628   8.092  1.00 14.56      A    C  
ATOM   1208  CG  HIS   170      20.910  40.999   6.648  1.00 18.57      A    C  
ATOM   1209  ND1 HIS   170      21.886  41.712   5.986  1.00 21.37      A    N  
ATOM   1210  CE1 HIS   170      21.520  41.890   4.728  1.00 22.64      A    C  
ATOM   1211  NE2 HIS   170      20.346  41.311   4.549  1.00 23.50      A    N  
ATOM   1212  CD2 HIS   170      19.945  40.738   5.732  1.00 20.09      A    C  
ATOM   1213  C   HIS   170      21.641  42.840   9.242  1.00 12.40      A    C  
ATOM   1214  O   HIS   170      22.780  42.732   8.777  1.00 11.98      A    O  
ATOM   1215  N   THR   171      21.243  43.884   9.960  1.00 10.20      A    N  
ATOM   1216  CA  THR   171      22.069  45.048  10.175  1.00 10.29      A    C  
ATOM   1217  CB  THR   171      21.558  46.211   9.305  1.00  9.65      A    C  
ATOM   1218  OG1 THR   171      21.615  45.801   7.930  1.00 11.88      A    O  
ATOM   1219  CG2 THR   171      22.400  47.460   9.509  1.00 10.17      A    C  
ATOM   1220  C   THR   171      22.068  45.398  11.669  1.00  9.25      A    C  
ATOM   1221  O   THR   171      21.277  46.224  12.139  1.00 10.00      A    O  
ATOM   1222  N   PRO   172      22.937  44.735  12.440  1.00  8.33      A    N  
ATOM   1223  CA  PRO   172      22.975  44.938  13.879  1.00  8.52      A    C  
ATOM   1224  CB  PRO   172      23.712  43.681  14.377  1.00  8.27      A    C  
ATOM   1225  CG  PRO   172      24.641  43.370  13.295  1.00  8.48      A    C  
ATOM   1226  CD  PRO   172      23.925  43.729  12.001  1.00  8.85      A    C  
ATOM   1227  C   PRO   172      23.779  46.177  14.265  1.00  8.15      A    C  
ATOM   1228  O   PRO   172      24.909  46.344  13.810  1.00  8.40      A    O  
ATOM   1229  N   LEU   173      23.199  47.047  15.087  1.00  7.89      A    N  
ATOM   1230  CA  LEU   173      23.974  48.130  15.697  1.00  7.87      A    C  
ATOM   1231  CB  LEU   173      23.061  49.217  16.291  1.00  7.05      A    C  
ATOM   1232  CG  LEU   173      23.786  50.364  16.999  1.00  7.37      A    C  
ATOM   1233  CD1 LEU   173      24.775  51.011  16.041  1.00  9.34      A    C  
ATOM   1234  CD2 LEU   173      22.811  51.424  17.509  1.00  7.46      A    C  
ATOM   1235  C   LEU   173      24.885  47.573  16.790  1.00  8.11      A    C  
ATOM   1236  O   LEU   173      24.426  46.892  17.713  1.00  8.12      A    O  
ATOM   1237  N   ILE   174      26.179  47.863  16.681  1.00  8.09      A    N  
ATOM   1238  CA  ILE   174      27.158  47.291  17.621  1.00  8.42      A    C  
ATOM   1239  CB  ILE   174      28.356  46.670  16.853  1.00  8.26      A    C  
ATOM   1240  CG1 ILE   174      27.865  45.676  15.789  1.00  7.67      A    C  
ATOM   1241  CD1 ILE   174      27.054  44.487  16.336  1.00  7.85      A    C  
ATOM   1242  CG2 ILE   174      29.361  46.028  17.830  1.00  8.43      A    C  
ATOM   1243  C   ILE   174      27.652  48.314  18.624  1.00  9.03      A    C  
ATOM   1244  O   ILE   174      27.699  48.070  19.829  1.00  9.28      A    O  
ATOM   1245  N   ALA   175      28.047  49.480  18.136  1.00  9.51      A    N  
ATOM   1246  CA  ALA   175      28.565  50.498  19.019  1.00 10.45      A    C  
ATOM   1247  CB  ALA   175      30.071  50.393  19.129  1.00 10.90      A    C  
ATOM   1248  C   ALA   175      28.188  51.837  18.435  1.00 11.08      A    C  
ATOM   1249  O   ALA   175      27.962  51.946  17.233  1.00 11.71      A    O  
ATOM   1250  N   GLY   176      28.139  52.854  19.278  1.00 12.21      A    N  
ATOM   1251  CA  GLY   176      27.846  54.194  18.798  1.00 13.05      A    C  
ATOM   1252  C   GLY   176      28.436  55.230  19.731  1.00 13.92      A    C  
ATOM   1253  O   GLY   176      28.990  54.894  20.775  1.00 13.64      A    O  
ATOM   1254  N   ARG   177      28.294  56.498  19.359  1.00 15.36      A    N  
ATOM   1255  CA  ARG   177      28.721  57.593  20.213  1.00 16.27      A    C  
ATOM   1256  CB  ARG   177      30.206  57.909  20.017  1.00 17.42      A    C  
ATOM   1257  CG  ARG   177      30.658  57.827  18.593  1.00 20.25      A    C  
ATOM   1258  CD  ARG   177      31.969  57.019  18.473  1.00 23.95      A    C  
ATOM   1259  NE  ARG   177      32.031  56.407  17.152  1.00 27.37      A    N  
ATOM   1260  CZ  ARG   177      31.792  55.125  16.912  1.00 27.14      A    C  
ATOM   1261  NH1 ARG   177      31.522  54.286  17.913  1.00 26.52      A    N  
ATOM   1262  NH2 ARG   177      31.845  54.676  15.669  1.00 29.80      A    N  
ATOM   1263  C   ARG   177      27.896  58.829  19.927  1.00 16.34      A    C  
ATOM   1264  O   ARG   177      27.538  59.091  18.788  1.00 15.95      A    O  
ATOM   1265  N   VAL   178      27.570  59.556  20.980  1.00 17.04      A    N  
ATOM   1266  CA  VAL   178      26.987  60.887  20.836  1.00 18.33      A    C  
ATOM   1267  CB  VAL   178      26.464  61.400  22.181  1.00 17.81      A    C  
ATOM   1268  CG1 VAL   178      25.794  62.775  22.007  1.00 19.49      A    C  
ATOM   1269  CG2 VAL   178      25.498  60.391  22.792  1.00 18.84      A    C  
ATOM   1270  C   VAL   178      28.092  61.799  20.348  1.00 19.19      A    C  
ATOM   1271  O   VAL   178      29.158  61.865  20.962  1.00 19.66      A    O  
ATOM   1272  N   ARG   179      27.849  62.492  19.244  1.00 20.46      A    N  
ATOM   1273  CA  ARG   179      28.847  63.385  18.655  1.00 22.18      A    C  
ATOM   1274  CB  ARG   179      28.556  63.618  17.170  1.00 21.81      A    C  
ATOM   1275  CG  ARG   179      28.576  62.372  16.315  1.00 21.76      A    C  
ATOM   1276  CD  ARG   179      28.501  62.735  14.854  1.00 21.65      A    C  
ATOM   1277  NE  ARG   179      27.341  63.577  14.565  1.00 21.68      A    N  
ATOM   1278  CZ  ARG   179      26.933  63.870  13.336  1.00 21.54      A    C  
ATOM   1279  NH1 ARG   179      27.594  63.391  12.291  1.00 21.08      A    N  
ATOM   1280  NH2 ARG   179      25.867  64.630  13.152  1.00 22.04      A    N  
ATOM   1281  C   ARG   179      28.893  64.723  19.376  1.00 23.47      A    C  
ATOM   1282  O   ARG   179      27.849  65.298  19.694  1.00 23.29      A    O  
ATOM   1283  N   PRO   180      30.113  65.232  19.616  1.00 25.00      A    N  
ATOM   1284  CA  PRO   180      30.317  66.517  20.281  1.00 25.94      A    C  
ATOM   1285  CB  PRO   180      31.798  66.812  20.025  1.00 26.04      A    C  
ATOM   1286  CG  PRO   180      32.425  65.461  19.860  1.00 26.63      A    C  
ATOM   1287  CD  PRO   180      31.381  64.610  19.192  1.00 25.14      A    C  
ATOM   1288  C   PRO   180      29.443  67.608  19.658  1.00 26.39      A    C  
ATOM   1289  O   PRO   180      28.883  68.438  20.378  1.00 27.48      A    O  
ATOM   1290  N   GLU   181      29.326  67.591  18.334  1.00 26.33      A    N  
ATOM   1291  CA  GLU   181      28.523  68.571  17.599  1.00 26.44      A    C  
ATOM   1292  CB  GLU   181      29.034  68.689  16.167  1.00 26.54      A    C  
ATOM   1293  CG  GLU   181      28.729  67.484  15.304  1.00 28.19      A    C  
ATOM   1294  CD  GLU   181      29.889  66.499  15.219  1.00 30.24      A    C  
ATOM   1295  OE1 GLU   181      30.617  66.327  16.229  1.00 30.67      A    O  
ATOM   1296  OE2 GLU   181      30.074  65.903  14.133  1.00 31.19      A    O  
ATOM   1297  C   GLU   181      27.020  68.258  17.548  1.00 25.87      A    C  
ATOM   1298  O   GLU   181      26.256  68.990  16.909  1.00 26.59      A    O  
ATOM   1299  N   GLY   182      26.596  67.182  18.206  1.00 24.64      A    N  
ATOM   1300  CA  GLY   182      25.198  66.750  18.146  1.00 22.42      A    C  
ATOM   1301  C   GLY   182      25.047  65.597  17.171  1.00 21.04      A    C  
ATOM   1302  O   GLY   182      25.896  65.402  16.308  1.00 20.92      A    O  
ATOM   1303  N   GLY   183      23.974  64.819  17.302  1.00 18.80      A    N  
ATOM   1304  CA  GLY   183      23.797  63.658  16.435  1.00 16.53      A    C  
ATOM   1305  C   GLY   183      24.635  62.485  16.927  1.00 14.99      A    C  
ATOM   1306  O   GLY   183      25.215  62.537  18.016  1.00 14.84      A    O  
ATOM   1307  N   PHE   184      24.726  61.456  16.094  1.00 13.93      A    N  
ATOM   1308  CA  PHE   184      25.298  60.172  16.507  1.00 13.13      A    C  
ATOM   1309  CB  PHE   184      24.152  59.206  16.850  1.00 12.83      A    C  
ATOM   1310  CG  PHE   184      23.183  59.768  17.842  1.00 13.91      A    C  
ATOM   1311  CD1 PHE   184      23.331  59.531  19.195  1.00 12.71      A    C  
ATOM   1312  CE1 PHE   184      22.449  60.071  20.115  1.00 12.74      A    C  
ATOM   1313  CZ  PHE   184      21.412  60.880  19.677  1.00 13.24      A    C  
ATOM   1314  CE2 PHE   184      21.257  61.124  18.330  1.00 11.65      A    C  
ATOM   1315  CD2 PHE   184      22.135  60.567  17.414  1.00 12.37      A    C  
ATOM   1316  C   PHE   184      26.144  59.580  15.403  1.00 12.91      A    C  
ATOM   1317  O   PHE   184      25.842  59.757  14.227  1.00 12.12      A    O  
ATOM   1318  N   GLU   185      27.199  58.855  15.786  1.00 12.91      A    N  
ATOM   1319  CA  GLU   185      27.953  58.058  14.831  1.00 13.21      A    C  
ATOM   1320  CB  GLU   185      29.432  58.434  14.829  1.00 13.69      A    C  
ATOM   1321  CG  GLU   185      30.186  57.732  13.726  1.00 17.84      A    C  
ATOM   1322  CD  GLU   185      31.647  58.112  13.682  1.00 23.25      A    C  
ATOM   1323  OE1 GLU   185      32.325  57.987  14.729  1.00 26.33      A    O  
ATOM   1324  OE2 GLU   185      32.115  58.509  12.593  1.00 25.75      A    O  
ATOM   1325  C   GLU   185      27.767  56.613  15.255  1.00 12.22      A    C  
ATOM   1326  O   GLU   185      27.908  56.294  16.442  1.00 12.86      A    O  
ATOM   1327  N   LEU   186      27.440  55.760  14.295  1.00 11.73      A    N  
ATOM   1328  CA  LEU   186      26.991  54.399  14.607  1.00 11.35      A    C  
ATOM   1329  CB  LEU   186      25.497  54.254  14.280  1.00 11.21      A    C  
ATOM   1330  CG  LEU   186      24.556  55.239  14.990  1.00 12.19      A    C  
ATOM   1331  CD1 LEU   186      23.129  54.999  14.522  1.00 12.80      A    C  
ATOM   1332  CD2 LEU   186      24.645  55.154  16.513  1.00 11.56      A    C  
ATOM   1333  C   LEU   186      27.740  53.346  13.809  1.00 10.81      A    C  
ATOM   1334  O   LEU   186      27.823  53.435  12.582  1.00 11.13      A    O  
ATOM   1335  N   ASP   187      28.236  52.317  14.502  1.00 10.47      A    N  
ATOM   1336  CA  ASP   187      28.934  51.222  13.856  1.00 10.57      A    C  
ATOM   1337  CB  ASP   187      30.211  50.862  14.629  1.00 10.52      A    C  
ATOM   1338  CG  ASP   187      31.160  52.039  14.749  1.00 13.54      A    C  
ATOM   1339  OD1 ASP   187      31.164  52.898  13.832  1.00 16.27      A    O  
ATOM   1340  OD2 ASP   187      31.895  52.108  15.756  1.00 17.11      A    O  
ATOM   1341  C   ASP   187      28.041  50.007  13.800  1.00  9.88      A    C  
ATOM   1342  O   ASP   187      27.648  49.475  14.844  1.00  9.11      A    O  
ATOM   1343  N   PHE   188      27.708  49.589  12.580  1.00  9.80      A    N  
ATOM   1344  CA  PHE   188      26.895  48.413  12.359  1.00 10.64      A    C  
ATOM   1345  CB  PHE   188      25.886  48.681  11.251  1.00 10.49      A    C  
ATOM   1346  CG  PHE   188      24.868  49.720  11.615  1.00  9.97      A    C  
ATOM   1347  CD1 PHE   188      23.687  49.348  12.231  1.00 11.29      A    C  
ATOM   1348  CE1 PHE   188      22.736  50.296  12.573  1.00 11.93      A    C  
ATOM   1349  CZ  PHE   188      22.965  51.633  12.295  1.00 12.62      A    C  
ATOM   1350  CE2 PHE   188      24.144  52.018  11.667  1.00 11.53      A    C  
ATOM   1351  CD2 PHE   188      25.090  51.058  11.336  1.00 12.05      A    C  
ATOM   1352  C   PHE   188      27.766  47.210  12.026  1.00 10.85      A    C  
ATOM   1353  O   PHE   188      28.836  47.340  11.404  1.00 11.32      A    O  
ATOM   1354  N   GLY   189      27.317  46.036  12.454  1.00 11.23      A    N  
ATOM   1355  CA  GLY   189      28.084  44.809  12.255  1.00 11.21      A    C  
ATOM   1356  C   GLY   189      27.490  43.887  11.205  1.00 11.49      A    C  
ATOM   1357  O   GLY   189      27.011  44.338  10.148  1.00 11.13      A    O  
ATOM   1358  N   GLY   190      27.496  42.591  11.501  1.00 10.38      A    N  
ATOM   1359  CA  GLY   190      27.004  41.572  10.579  1.00 11.23      A    C  
ATOM   1360  C   GLY   190      27.962  41.298   9.425  1.00 12.17      A    C  
ATOM   1361  O   GLY   190      29.160  41.543   9.529  1.00 11.35      A    O  
ATOM   1362  N   ALA   191      27.407  40.794   8.326  1.00 13.23      A    N  
ATOM   1363  CA  ALA   191      28.196  40.384   7.170  1.00 14.28      A    C  
ATOM   1364  CB  ALA   191      27.352  39.556   6.231  1.00 14.72      A    C  
ATOM   1365  C   ALA   191      28.794  41.571   6.423  1.00 14.38      A    C  
ATOM   1366  O   ALA   191      29.802  41.424   5.738  1.00 15.35      A    O  
ATOM   1367  N   GLU   192      28.172  42.735   6.558  1.00 13.71      A    N  
ATOM   1368  CA  GLU   192      28.578  43.918   5.805  1.00 14.16      A    C  
ATOM   1369  CB  GLU   192      27.563  44.223   4.703  1.00 14.36      A    C  
ATOM   1370  CG  GLU   192      27.275  43.073   3.758  1.00 17.88      A    C  
ATOM   1371  CD  GLU   192      26.044  43.352   2.920  1.00 22.75      A    C  
ATOM   1372  OE1 GLU   192      26.112  44.221   2.011  1.00 23.54      A    O  
ATOM   1373  OE2 GLU   192      24.996  42.720   3.189  1.00 25.37      A    O  
ATOM   1374  C   GLU   192      28.691  45.132   6.723  1.00 13.02      A    C  
ATOM   1375  O   GLU   192      27.886  46.059   6.632  1.00 12.59      A    O  
ATOM   1376  N   PRO   193      29.699  45.130   7.599  1.00 12.63      A    N  
ATOM   1377  CA  PRO   193      29.825  46.204   8.582  1.00 12.57      A    C  
ATOM   1378  CB  PRO   193      31.100  45.837   9.369  1.00 12.27      A    C  
ATOM   1379  CG  PRO   193      31.795  44.797   8.571  1.00 12.67      A    C  
ATOM   1380  CD  PRO   193      30.728  44.088   7.782  1.00 12.37      A    C  
ATOM   1381  C   PRO   193      29.993  47.543   7.913  1.00 12.99      A    C  
ATOM   1382  O   PRO   193      30.588  47.639   6.827  1.00 12.51      A    O  
ATOM   1383  N   MET   194      29.452  48.570   8.546  1.00 12.97      A    N  
ATOM   1384  CA  MET   194      29.477  49.906   7.968  1.00 13.24      A    C  
ATOM   1385  CB  MET   194      28.362  50.039   6.926  1.00 13.37      A    C  
ATOM   1386  CG  MET   194      26.958  50.127   7.541  1.00 14.71      A    C  
ATOM   1387  SD  MET   194      25.659  50.420   6.309  1.00 15.17      A    S  
ATOM   1388  CE  MET   194      25.838  48.946   5.359  1.00 18.02      A    C  
ATOM   1389  C   MET   194      29.243  50.911   9.075  1.00 13.51      A    C  
ATOM   1390  O   MET   194      28.750  50.551  10.138  1.00 13.59      A    O  
ATOM   1391  N   THR   195      29.579  52.177   8.826  1.00 13.34      A    N  
ATOM   1392  CA  THR   195      29.300  53.238   9.789  1.00 13.81      A    C  
ATOM   1393  CB  THR   195      30.589  53.926  10.251  1.00 13.18      A    C  
ATOM   1394  OG1 THR   195      31.392  52.988  10.983  1.00 16.01      A    O  
ATOM   1395  CG2 THR   195      30.281  55.119  11.140  1.00 14.43      A    C  
ATOM   1396  C   THR   195      28.364  54.261   9.154  1.00 13.99      A    C  
ATOM   1397  O   THR   195      28.519  54.598   7.981  1.00 13.93      A    O  
ATOM   1398  N   LEU   196      27.372  54.709   9.912  1.00 14.13      A    N  
ATOM   1399  CA  LEU   196      26.428  55.747   9.455  1.00 14.52      A    C  
ATOM   1400  CB  LEU   196      25.045  55.160   9.131  1.00 14.58      A    C  
ATOM   1401  CG  LEU   196      24.874  54.032   8.104  1.00 15.95      A    C  
ATOM   1402  CD1 LEU   196      23.415  53.563   8.044  1.00 17.10      A    C  
ATOM   1403  CD2 LEU   196      25.362  54.456   6.716  1.00 19.76      A    C  
ATOM   1404  C   LEU   196      26.275  56.754  10.570  1.00 14.91      A    C  
ATOM   1405  O   LEU   196      26.500  56.436  11.735  1.00 15.15      A    O  
ATOM   1406  N   SER   197      25.879  57.976  10.227  1.00 14.77      A    N  
ATOM   1407  CA  SER   197      25.653  58.990  11.245  1.00 14.47      A    C  
ATOM   1408  CB  SER   197      26.655  60.123  11.101  1.00 15.04      A    C  
ATOM   1409  OG  SER   197      26.461  60.772   9.858  1.00 18.23      A    O  
ATOM   1410  C   SER   197      24.242  59.537  11.079  1.00 13.78      A    C  
ATOM   1411  O   SER   197      23.646  59.401  10.007  1.00 13.97      A    O  
ATOM   1412  N   CYS   198      23.705  60.116  12.144  1.00 13.16      A    N  
ATOM   1413  CA  CYS   198      22.302  60.558  12.139  1.00 13.65      A    C  
ATOM   1414  CB  CYS   198      21.353  59.382  12.389  1.00 13.61      A    C  
ATOM   1415  SG  CYS   198      21.509  58.584  14.007  1.00 14.33      A    S  
ATOM   1416  C   CYS   198      22.010  61.678  13.128  1.00 13.53      A    C  
ATOM   1417  O   CYS   198      22.767  61.933  14.060  1.00 13.00      A    O  
ATOM   1418  N   ARG   199      20.892  62.364  12.925  1.00 13.13      A    N  
ATOM   1419  CA  ARG   199      20.540  63.455  13.826  1.00 13.43      A    C  
ATOM   1420  CB  ARG   199      19.746  64.518  13.055  1.00 14.01      A    C  
ATOM   1421  CG  ARG   199      19.304  65.698  13.885  1.00 15.90      A    C  
ATOM   1422  CD  ARG   199      18.369  66.620  13.076  1.00 17.46      A    C  
ATOM   1423  NE  ARG   199      17.089  65.989  12.728  1.00 19.34      A    N  
ATOM   1424  CZ  ARG   199      15.982  66.055  13.471  1.00 19.42      A    C  
ATOM   1425  NH1 ARG   199      15.968  66.733  14.612  1.00 21.71      A    N  
ATOM   1426  NH2 ARG   199      14.877  65.449  13.059  1.00 19.05      A    N  
ATOM   1427  C   ARG   199      19.737  62.938  15.022  1.00 12.85      A    C  
ATOM   1428  O   ARG   199      19.931  63.371  16.153  1.00 13.63      A    O  
ATOM   1429  N   VAL   200      18.833  62.006  14.757  1.00 12.54      A    N  
ATOM   1430  CA  VAL   200      17.954  61.466  15.784  1.00 12.29      A    C  
ATOM   1431  CB  VAL   200      16.479  61.745  15.431  1.00 12.66      A    C  
ATOM   1432  CG1 VAL   200      15.559  60.936  16.316  1.00 13.14      A    C  
ATOM   1433  CG2 VAL   200      16.178  63.230  15.586  1.00 12.74      A    C  
ATOM   1434  C   VAL   200      18.160  59.963  15.875  1.00 10.71      A    C  
ATOM   1435  O   VAL   200      18.263  59.305  14.858  1.00 10.98      A    O  
ATOM   1436  N   LEU   201      18.227  59.441  17.095  1.00 10.20      A    N  
ATOM   1437  CA  LEU   201      18.374  57.997  17.309  1.00  9.78      A    C  
ATOM   1438  CB  LEU   201      19.724  57.686  17.957  1.00  9.15      A    C  
ATOM   1439  CG  LEU   201      20.035  56.192  18.146  1.00  9.59      A    C  
ATOM   1440  CD1 LEU   201      19.935  55.405  16.828  1.00 13.48      A    C  
ATOM   1441  CD2 LEU   201      21.396  56.032  18.799  1.00 10.99      A    C  
ATOM   1442  C   LEU   201      17.288  57.474  18.229  1.00  9.04      A    C  
ATOM   1443  O   LEU   201      17.150  57.940  19.348  1.00 10.07      A    O  
ATOM   1444  N   ILE   202      16.556  56.463  17.769  1.00  9.03      A    N  
ATOM   1445  CA  ILE   202      15.549  55.818  18.598  1.00  8.77      A    C  
ATOM   1446  CB  ILE   202      14.187  55.717  17.900  1.00  9.02      A    C  
ATOM   1447  CG1 ILE   202      13.730  57.073  17.344  1.00 10.37      A    C  
ATOM   1448  CD1 ILE   202      13.604  58.141  18.384  1.00  9.20      A    C  
ATOM   1449  CG2 ILE   202      13.136  55.128  18.844  1.00 10.32      A    C  
ATOM   1450  C   ILE   202      16.027  54.389  18.860  1.00  7.84      A    C  
ATOM   1451  O   ILE   202      16.199  53.596  17.934  1.00  7.98      A    O  
ATOM   1452  N   ASN   203      16.245  54.083  20.122  1.00  8.20      A    N  
ATOM   1453  CA  ASN   203      16.652  52.743  20.538  1.00  8.37      A    C  
ATOM   1454  CB  ASN   203      17.694  52.858  21.657  1.00  8.39      A    C  
ATOM   1455  CG  ASN   203      17.922  51.553  22.401  1.00  8.59      A    C  
ATOM   1456  OD1 ASN   203      17.550  50.486  21.940  1.00  8.93      A    O  
ATOM   1457  ND2 ASN   203      18.553  51.647  23.571  1.00  9.50      A    N  
ATOM   1458  C   ASN   203      15.397  51.984  20.984  1.00  7.68      A    C  
ATOM   1459  O   ASN   203      14.888  52.183  22.098  1.00  7.64      A    O  
ATOM   1460  N   ALA   204      14.887  51.160  20.074  1.00  8.08      A    N  
ATOM   1461  CA  ALA   204      13.676  50.382  20.278  1.00  7.97      A    C  
ATOM   1462  CB  ALA   204      12.617  50.733  19.203  1.00  7.84      A    C  
ATOM   1463  C   ALA   204      14.055  48.906  20.221  1.00  8.03      A    C  
ATOM   1464  O   ALA   204      13.329  48.084  19.673  1.00  8.35      A    O  
ATOM   1465  N   ALA   205      15.205  48.581  20.810  1.00  8.09      A    N  
ATOM   1466  CA  ALA   205      15.783  47.246  20.649  1.00  8.95      A    C  
ATOM   1467  CB  ALA   205      17.323  47.335  20.785  1.00  8.85      A    C  
ATOM   1468  C   ALA   205      15.215  46.155  21.572  1.00  9.22      A    C  
ATOM   1469  O   ALA   205      15.742  45.027  21.623  1.00  8.90      A    O  
ATOM   1470  N   GLY   206      14.148  46.473  22.303  1.00  8.62      A    N  
ATOM   1471  CA  GLY   206      13.441  45.455  23.082  1.00  9.18      A    C  
ATOM   1472  C   GLY   206      14.242  44.835  24.216  1.00  9.37      A    C  
ATOM   1473  O   GLY   206      14.713  45.534  25.108  1.00  9.50      A    O  
ATOM   1474  N   LEU   207      14.366  43.508  24.188  1.00 10.01      A    N  
ATOM   1475  CA  LEU   207      15.168  42.779  25.166  1.00 11.08      A    C  
ATOM   1476  CB  LEU   207      15.341  41.325  24.703  1.00 10.79      A    C  
ATOM   1477  CG  LEU   207      14.086  40.490  24.532  1.00 14.13      A    C  
ATOM   1478  CD1 LEU   207      14.495  39.061  24.245  1.00 15.21      A    C  
ATOM   1479  CD2 LEU   207      13.256  40.564  25.800  1.00 15.53      A    C  
ATOM   1480  C   LEU   207      16.565  43.363  25.332  1.00 10.50      A    C  
ATOM   1481  O   LEU   207      17.194  43.224  26.401  1.00 11.39      A    O  
ATOM   1482  N   HIS   208      17.064  43.974  24.261  1.00  9.20      A    N  
ATOM   1483  CA  HIS   208      18.441  44.424  24.218  1.00  8.94      A    C  
ATOM   1484  CB  HIS   208      19.105  43.942  22.930  1.00  9.54      A    C  
ATOM   1485  CG  HIS   208      19.232  42.457  22.868  1.00 11.80      A    C  
ATOM   1486  ND1 HIS   208      20.119  41.767  23.659  1.00 17.06      A    N  
ATOM   1487  CE1 HIS   208      20.003  40.473  23.421  1.00 16.40      A    C  
ATOM   1488  NE2 HIS   208      19.063  40.303  22.513  1.00 15.08      A    N  
ATOM   1489  CD2 HIS   208      18.547  41.528  22.166  1.00 14.31      A    C  
ATOM   1490  C   HIS   208      18.590  45.914  24.354  1.00  8.24      A    C  
ATOM   1491  O   HIS   208      19.693  46.431  24.272  1.00  7.88      A    O  
ATOM   1492  N   ALA   209      17.491  46.621  24.599  1.00  7.48      A    N  
ATOM   1493  CA  ALA   209      17.611  48.071  24.654  1.00  7.41      A    C  
ATOM   1494  CB  ALA   209      16.193  48.767  24.727  1.00  8.13      A    C  
ATOM   1495  C   ALA   209      18.562  48.604  25.741  1.00  7.41      A    C  
ATOM   1496  O   ALA   209      19.333  49.533  25.484  1.00  7.52      A    O  
ATOM   1497  N   PRO   210      18.484  48.065  26.966  1.00  6.70      A    N  
ATOM   1498  CA  PRO   210      19.398  48.607  27.994  1.00  6.94      A    C  
ATOM   1499  CB  PRO   210      18.953  47.884  29.264  1.00  6.78      A    C  
ATOM   1500  CG  PRO   210      17.477  47.528  28.989  1.00  6.88      A    C  
ATOM   1501  CD  PRO   210      17.471  47.149  27.541  1.00  6.88      A    C  
ATOM   1502  C   PRO   210      20.876  48.325  27.692  1.00  7.62      A    C  
ATOM   1503  O   PRO   210      21.725  49.223  27.831  1.00  8.12      A    O  
ATOM   1504  N   GLY   211      21.164  47.109  27.247  1.00  7.83      A    N  
ATOM   1505  CA  GLY   211      22.535  46.752  26.915  1.00  7.75      A    C  
ATOM   1506  C   GLY   211      23.031  47.566  25.745  1.00  7.91      A    C  
ATOM   1507  O   GLY   211      24.186  47.983  25.703  1.00  8.44      A    O  
ATOM   1508  N   LEU   212      22.143  47.820  24.794  1.00  7.61      A    N  
ATOM   1509  CA  LEU   212      22.512  48.622  23.633  1.00  7.74      A    C  
ATOM   1510  CB  LEU   212      21.436  48.570  22.557  1.00  7.89      A    C  
ATOM   1511  CG  LEU   212      21.705  49.413  21.301  1.00  7.60      A    C  
ATOM   1512  CD1 LEU   212      23.016  49.006  20.629  1.00  9.65      A    C  
ATOM   1513  CD2 LEU   212      20.533  49.272  20.355  1.00  8.22      A    C  
ATOM   1514  C   LEU   212      22.791  50.056  24.048  1.00  7.66      A    C  
ATOM   1515  O   LEU   212      23.723  50.670  23.558  1.00  7.84      A    O  
ATOM   1516  N   ALA   213      21.984  50.606  24.951  1.00  7.71      A    N  
ATOM   1517  CA  ALA   213      22.288  51.968  25.437  1.00  8.99      A    C  
ATOM   1518  CB  ALA   213      21.227  52.432  26.418  1.00  9.47      A    C  
ATOM   1519  C   ALA   213      23.686  52.047  26.062  1.00  8.46      A    C  
ATOM   1520  O   ALA   213      24.410  53.014  25.880  1.00  9.13      A    O  
ATOM   1521  N   ARG   214      24.073  51.000  26.781  1.00  9.00      A    N  
ATOM   1522  CA  ARG   214      25.387  50.963  27.392  1.00  9.47      A    C  
ATOM   1523  CB  ARG   214      25.490  49.759  28.333  1.00  9.19      A    C  
ATOM   1524  CG  ARG   214      26.846  49.622  29.014  1.00 12.69      A    C  
ATOM   1525  CD  ARG   214      27.115  50.790  29.974  1.00 16.75      A    C  
ATOM   1526  NE  ARG   214      28.464  50.719  30.532  1.00 19.03      A    N  
ATOM   1527  CZ  ARG   214      29.546  51.176  29.911  1.00 18.83      A    C  
ATOM   1528  NH1 ARG   214      29.426  51.726  28.720  1.00 18.92      A    N  
ATOM   1529  NH2 ARG   214      30.753  51.075  30.474  1.00 17.01      A    N  
ATOM   1530  C   ARG   214      26.487  50.910  26.311  1.00  9.83      A    C  
ATOM   1531  O   ARG   214      27.655  51.227  26.581  1.00 10.62      A    O  
ATOM   1532  N   ARG   215      26.115  50.507  25.104  1.00  9.86      A    N  
ATOM   1533  CA  ARG   215      27.077  50.438  23.990  1.00 10.74      A    C  
ATOM   1534  CB  ARG   215      26.759  49.243  23.082  1.00 10.72      A    C  
ATOM   1535  CG  ARG   215      26.999  47.900  23.784  1.00 11.69      A    C  
ATOM   1536  CD  ARG   215      26.810  46.732  22.814  1.00 11.45      A    C  
ATOM   1537  NE  ARG   215      25.406  46.368  22.525  1.00 12.73      A    N  
ATOM   1538  CZ  ARG   215      24.625  45.579  23.276  1.00 15.53      A    C  
ATOM   1539  NH1 ARG   215      25.019  45.086  24.459  1.00 17.00      A    N  
ATOM   1540  NH2 ARG   215      23.397  45.310  22.863  1.00 17.23      A    N  
ATOM   1541  C   ARG   215      27.151  51.731  23.177  1.00 11.21      A    C  
ATOM   1542  O   ARG   215      27.825  51.787  22.141  1.00 10.82      A    O  
ATOM   1543  N   ILE   216      26.442  52.764  23.634  1.00 11.14      A    N  
ATOM   1544  CA  ILE   216      26.522  54.064  22.991  1.00 11.93      A    C  
ATOM   1545  CB  ILE   216      25.128  54.655  22.678  1.00 12.14      A    C  
ATOM   1546  CG1 ILE   216      24.269  53.654  21.887  1.00 13.07      A    C  
ATOM   1547  CD1 ILE   216      24.841  53.271  20.606  1.00 15.02      A    C  
ATOM   1548  CG2 ILE   216      25.289  55.973  21.908  1.00 11.88      A    C  
ATOM   1549  C   ILE   216      27.221  55.029  23.931  1.00 12.85      A    C  
ATOM   1550  O   ILE   216      26.660  55.409  24.958  1.00 12.73      A    O  
ATOM   1551  N   GLU   217      28.447  55.414  23.590  1.00 14.04      A    N  
ATOM   1552  CA  GLU   217      29.184  56.384  24.393  1.00 15.53      A    C  
ATOM   1553  CB  GLU   217      30.568  56.656  23.802  1.00 15.92      A    C  
ATOM   1554  CG  GLU   217      31.439  55.460  23.526  1.00 20.85      A    C  
ATOM   1555  CD  GLU   217      32.748  55.894  22.888  1.00 25.38      A    C  
ATOM   1556  OE1 GLU   217      33.386  56.827  23.434  1.00 27.71      A    O  
ATOM   1557  OE2 GLU   217      33.120  55.340  21.830  1.00 28.41      A    O  
ATOM   1558  C   GLU   217      28.430  57.701  24.432  1.00 15.44      A    C  
ATOM   1559  O   GLU   217      27.964  58.193  23.396  1.00 15.76      A    O  
ATOM   1560  N   GLY   218      28.322  58.278  25.623  1.00 15.55      A    N  
ATOM   1561  CA  GLY   218      27.629  59.549  25.763  1.00 15.38      A    C  
ATOM   1562  C   GLY   218      26.256  59.414  26.402  1.00 14.83      A    C  
ATOM   1563  O   GLY   218      25.655  60.407  26.805  1.00 15.66      A    O  
ATOM   1564  N   ILE   219      25.738  58.196  26.491  1.00 14.36      A    N  
ATOM   1565  CA  ILE   219      24.507  57.981  27.258  1.00 13.63      A    C  
ATOM   1566  CB  ILE   219      23.720  56.762  26.737  1.00 13.20      A    C  
ATOM   1567  CG1 ILE   219      23.383  56.947  25.259  1.00 12.65      A    C  
ATOM   1568  CD1 ILE   219      22.522  55.819  24.641  1.00 11.72      A    C  
ATOM   1569  CG2 ILE   219      22.481  56.531  27.603  1.00 13.03      A    C  
ATOM   1570  C   ILE   219      24.870  57.738  28.723  1.00 14.02      A    C  
ATOM   1571  O   ILE   219      25.614  56.810  29.028  1.00 13.55      A    O  
ATOM   1572  N   PRO   220      24.356  58.565  29.649  1.00 13.92      A    N  
ATOM   1573  CA  PRO   220      24.803  58.390  31.036  1.00 14.13      A    C  
ATOM   1574  CB  PRO   220      23.957  59.410  31.804  1.00 14.37      A    C  
ATOM   1575  CG  PRO   220      23.595  60.440  30.772  1.00 14.39      A    C  
ATOM   1576  CD  PRO   220      23.421  59.697  29.497  1.00 14.34      A    C  
ATOM   1577  C   PRO   220      24.544  56.977  31.571  1.00 14.69      A    C  
ATOM   1578  O   PRO   220      23.426  56.480  31.479  1.00 14.21      A    O  
ATOM   1579  N   ARG   221      25.565  56.337  32.133  1.00 15.12      A    N  
ATOM   1580  CA  ARG   221      25.393  54.954  32.591  1.00 15.77      A    C  
ATOM   1581  CB  ARG   221      26.740  54.327  32.944  1.00 16.21      A    C  
ATOM   1582  CG  ARG   221      27.657  54.279  31.760  1.00 19.37      A    C  
ATOM   1583  CD  ARG   221      29.022  53.739  32.141  1.00 23.16      A    C  
ATOM   1584  NE  ARG   221      29.941  53.847  31.016  1.00 27.81      A    N  
ATOM   1585  CZ  ARG   221      30.828  54.824  30.866  1.00 30.65      A    C  
ATOM   1586  NH1 ARG   221      30.918  55.786  31.779  1.00 32.89      A    N  
ATOM   1587  NH2 ARG   221      31.627  54.834  29.807  1.00 31.61      A    N  
ATOM   1588  C   ARG   221      24.430  54.824  33.763  1.00 16.47      A    C  
ATOM   1589  O   ARG   221      23.794  53.783  33.936  1.00 15.20      A    O  
ATOM   1590  N   ASP   222      24.306  55.874  34.572  1.00 17.16      A    N  
ATOM   1591  CA  ASP   222      23.375  55.801  35.692  1.00 19.11      A    C  
ATOM   1592  CB  ASP   222      23.709  56.840  36.789  1.00 19.64      A    C  
ATOM   1593  CG  ASP   222      23.653  58.271  36.293  1.00 23.52      A    C  
ATOM   1594  OD1 ASP   222      23.065  58.536  35.223  1.00 26.62      A    O  
ATOM   1595  OD2 ASP   222      24.207  59.158  36.992  1.00 29.09      A    O  
ATOM   1596  C   ASP   222      21.902  55.879  35.257  1.00 18.79      A    C  
ATOM   1597  O   ASP   222      21.004  55.567  36.042  1.00 20.87      A    O  
ATOM   1598  N   SER   223      21.656  56.272  34.015  1.00 18.16      A    N  
ATOM   1599  CA  SER   223      20.290  56.390  33.488  1.00 17.11      A    C  
ATOM   1600  CB  SER   223      20.219  57.467  32.377  1.00 17.33      A    C  
ATOM   1601  OG  SER   223      20.706  57.016  31.092  1.00 17.09      A    O  
ATOM   1602  C   SER   223      19.755  55.061  32.957  1.00 16.25      A    C  
ATOM   1603  O   SER   223      18.566  54.931  32.666  1.00 16.02      A    O  
ATOM   1604  N   ILE   224      20.641  54.087  32.783  1.00 14.35      A    N  
ATOM   1605  CA  ILE   224      20.266  52.866  32.073  1.00 14.06      A    C  
ATOM   1606  CB  ILE   224      21.425  52.377  31.184  1.00 13.42      A    C  
ATOM   1607  CG1 ILE   224      21.955  53.519  30.317  1.00 13.48      A    C  
ATOM   1608  CD1 ILE   224      23.278  53.178  29.555  1.00 14.75      A    C  
ATOM   1609  CG2 ILE   224      20.973  51.196  30.311  1.00 14.05      A    C  
ATOM   1610  C   ILE   224      19.903  51.759  33.048  1.00 14.44      A    C  
ATOM   1611  O   ILE   224      20.720  51.386  33.879  1.00 14.31      A    O  
ATOM   1612  N   PRO   225      18.678  51.210  32.942  1.00 14.92      A    N  
ATOM   1613  CA  PRO   225      18.260  50.130  33.847  1.00 15.89      A    C  
ATOM   1614  CB  PRO   225      16.753  50.016  33.570  1.00 15.86      A    C  
ATOM   1615  CG  PRO   225      16.613  50.457  32.143  1.00 15.53      A    C  
ATOM   1616  CD  PRO   225      17.620  51.568  31.977  1.00 14.98      A    C  
ATOM   1617  C   PRO   225      18.969  48.803  33.560  1.00 16.42      A    C  
ATOM   1618  O   PRO   225      19.573  48.631  32.494  1.00 16.92      A    O  
ATOM   1619  N   PRO   226      18.947  47.877  34.528  1.00 17.30      A    N  
ATOM   1620  CA  PRO   226      19.551  46.559  34.305  1.00 18.02      A    C  
ATOM   1621  CB  PRO   226      19.604  45.934  35.710  1.00 17.82      A    C  
ATOM   1622  CG  PRO   226      18.649  46.759  36.560  1.00 18.52      A    C  
ATOM   1623  CD  PRO   226      18.459  48.084  35.900  1.00 17.38      A    C  
ATOM   1624  C   PRO   226      18.660  45.766  33.343  1.00 18.20      A    C  
ATOM   1625  O   PRO   226      17.467  46.069  33.226  1.00 19.50      A    O  
ATOM   1626  N   GLU   227      19.240  44.824  32.602  1.00 17.79      A    N  
ATOM   1627  CA  GLU   227      18.504  44.119  31.564  1.00 17.57      A    C  
ATOM   1628  CB  GLU   227      19.393  44.052  30.323  1.00 18.16      A    C  
ATOM   1629  CG  GLU   227      18.828  43.351  29.100  1.00 19.27      A    C  
ATOM   1630  CD  GLU   227      19.810  43.380  27.923  1.00 21.02      A    C  
ATOM   1631  OE1 GLU   227      20.648  44.303  27.863  1.00 15.20      A    O  
ATOM   1632  OE2 GLU   227      19.731  42.479  27.061  1.00 24.76      A    O  
ATOM   1633  C   GLU   227      18.165  42.706  32.067  1.00 17.55      A    C  
ATOM   1634  O   GLU   227      19.070  41.859  32.133  1.00 17.14      A    O  
ATOM   1635  N   TYR   228      16.903  42.446  32.448  1.00 16.08      A    N  
ATOM   1636  CA  TYR   228      16.514  41.076  32.876  1.00 15.05      A    C  
ATOM   1637  CB  TYR   228      15.735  41.023  34.203  1.00 14.76      A    C  
ATOM   1638  CG  TYR   228      16.276  41.816  35.388  1.00 15.14      A    C  
ATOM   1639  CD1 TYR   228      17.088  41.220  36.346  1.00 13.64      A    C  
ATOM   1640  CE1 TYR   228      17.550  41.942  37.441  1.00 13.97      A    C  
ATOM   1641  CZ  TYR   228      17.189  43.272  37.592  1.00 16.03      A    C  
ATOM   1642  OH  TYR   228      17.642  44.003  38.674  1.00 17.70      A    O  
ATOM   1643  CE2 TYR   228      16.367  43.880  36.667  1.00 15.34      A    C  
ATOM   1644  CD2 TYR   228      15.913  43.151  35.573  1.00 15.34      A    C  
ATOM   1645  C   TYR   228      15.647  40.405  31.810  1.00 14.44      A    C  
ATOM   1646  O   TYR   228      15.128  41.067  30.911  1.00 14.49      A    O  
ATOM   1647  N   LEU   229      15.489  39.093  31.927  1.00 13.32      A    N  
ATOM   1648  CA  LEU   229      14.704  38.316  30.970  1.00 12.69      A    C  
ATOM   1649  CB  LEU   229      15.624  37.410  30.137  1.00 12.91      A    C  
ATOM   1650  CG  LEU   229      16.713  38.104  29.320  1.00 13.86      A    C  
ATOM   1651  CD1 LEU   229      17.614  37.056  28.648  1.00 15.17      A    C  
ATOM   1652  CD2 LEU   229      16.093  39.053  28.283  1.00 14.82      A    C  
ATOM   1653  C   LEU   229      13.694  37.447  31.702  1.00 12.18      A    C  
ATOM   1654  O   LEU   229      14.059  36.702  32.600  1.00 11.13      A    O  
ATOM   1655  N   CYS   230      12.418  37.551  31.320  1.00 10.88      A    N  
ATOM   1656  CA  CYS   230      11.374  36.735  31.931  1.00 11.08      A    C  
ATOM   1657  CB  CYS   230      10.411  37.568  32.793  1.00 11.08      A    C  
ATOM   1658  SG  CYS   230       9.250  36.533  33.681  1.00 14.08      A    S  
ATOM   1659  C   CYS   230      10.608  36.025  30.832  1.00 10.66      A    C  
ATOM   1660  O   CYS   230       9.745  36.610  30.179  1.00 11.14      A    O  
ATOM   1661  N   LYS   231      10.937  34.756  30.624  1.00 10.29      A    N  
ATOM   1662  CA  LYS   231      10.368  33.967  29.558  1.00  9.63      A    C  
ATOM   1663  CB  LYS   231      11.241  32.718  29.365  1.00  9.58      A    C  
ATOM   1664  CG  LYS   231      10.856  31.787  28.219  1.00 10.04      A    C  
ATOM   1665  CD  LYS   231      11.997  30.778  28.038  1.00 10.56      A    C  
ATOM   1666  CE  LYS   231      11.748  29.766  26.939  1.00 11.08      A    C  
ATOM   1667  NZ  LYS   231      12.935  28.823  26.874  1.00 11.14      A    N  
ATOM   1668  C   LYS   231       8.926  33.562  29.848  1.00  9.99      A    C  
ATOM   1669  O   LYS   231       8.500  33.465  31.008  1.00  9.09      A    O  
ATOM   1670  N   GLY   232       8.178  33.324  28.778  1.00 10.35      A    N  
ATOM   1671  CA  GLY   232       6.808  32.826  28.886  1.00 10.08      A    C  
ATOM   1672  C   GLY   232       6.544  31.773  27.822  1.00  9.90      A    C  
ATOM   1673  O   GLY   232       6.889  31.947  26.656  1.00 10.29      A    O  
ATOM   1674  N   SER   233       5.935  30.681  28.237  1.00  9.00      A    N  
ATOM   1675  CA  SER   233       5.628  29.575  27.322  1.00  9.36      A    C  
ATOM   1676  CB  SER   233       6.169  28.264  27.884  1.00  9.85      A    C  
ATOM   1677  OG  SER   233       7.594  28.307  27.972  1.00 10.35      A    O  
ATOM   1678  C   SER   233       4.126  29.446  27.139  1.00  9.52      A    C  
ATOM   1679  O   SER   233       3.358  29.584  28.101  1.00  8.77      A    O  
ATOM   1680  N   TYR   234       3.729  29.161  25.904  1.00  9.82      A    N  
ATOM   1681  CA  TYR   234       2.329  28.898  25.569  1.00  9.97      A    C  
ATOM   1682  CB  TYR   234       1.892  29.765  24.397  1.00 10.24      A    C  
ATOM   1683  CG  TYR   234       1.810  31.257  24.618  1.00 10.05      A    C  
ATOM   1684  CD1 TYR   234       0.588  31.870  24.924  1.00 11.14      A    C  
ATOM   1685  CE1 TYR   234       0.492  33.248  25.099  1.00 12.66      A    C  
ATOM   1686  CZ  TYR   234       1.615  34.033  24.938  1.00 13.31      A    C  
ATOM   1687  OH  TYR   234       1.518  35.410  25.101  1.00 14.00      A    O  
ATOM   1688  CE2 TYR   234       2.834  33.457  24.629  1.00 12.53      A    C  
ATOM   1689  CD2 TYR   234       2.934  32.064  24.471  1.00 12.37      A    C  
ATOM   1690  C   TYR   234       2.158  27.456  25.098  1.00 10.53      A    C  
ATOM   1691  O   TYR   234       3.051  26.898  24.445  1.00 10.21      A    O  
ATOM   1692  N   PHE   235       0.994  26.888  25.385  1.00 10.27      A    N  
ATOM   1693  CA  PHE   235       0.609  25.583  24.859  1.00 11.24      A    C  
ATOM   1694  CB  PHE   235       0.581  24.562  25.987  1.00 11.15      A    C  
ATOM   1695  CG  PHE   235       1.929  24.390  26.604  1.00 12.28      A    C  
ATOM   1696  CD1 PHE   235       2.827  23.487  26.062  1.00 11.31      A    C  
ATOM   1697  CE1 PHE   235       4.105  23.345  26.609  1.00 12.46      A    C  
ATOM   1698  CZ  PHE   235       4.499  24.155  27.670  1.00 12.52      A    C  
ATOM   1699  CE2 PHE   235       3.608  25.073  28.199  1.00 13.39      A    C  
ATOM   1700  CD2 PHE   235       2.339  25.199  27.650  1.00 11.84      A    C  
ATOM   1701  C   PHE   235      -0.701  25.693  24.145  1.00 11.95      A    C  
ATOM   1702  O   PHE   235      -1.514  26.550  24.463  1.00 12.43      A    O  
ATOM   1703  N   THR   236      -0.892  24.839  23.150  1.00 12.35      A    N  
ATOM   1704  CA  THR   236      -2.040  24.959  22.281  1.00 12.91      A    C  
ATOM   1705  CB  THR   236      -1.617  25.096  20.816  1.00 12.85      A    C  
ATOM   1706  OG1 THR   236      -0.869  23.935  20.432  1.00 14.79      A    O  
ATOM   1707  CG2 THR   236      -0.759  26.369  20.609  1.00 13.66      A    C  
ATOM   1708  C   THR   236      -2.992  23.785  22.460  1.00 13.85      A    C  
ATOM   1709  O   THR   236      -2.622  22.726  22.976  1.00 13.49      A    O  
ATOM   1710  N   LEU   237      -4.235  23.997  22.050  1.00 14.70      A    N  
ATOM   1711  CA  LEU   237      -5.272  22.996  22.164  1.00 16.57      A    C  
ATOM   1712  CB  LEU   237      -6.407  23.511  23.054  1.00 16.03      A    C  
ATOM   1713  CG  LEU   237      -7.596  22.577  23.295  1.00 16.60      A    C  
ATOM   1714  CD1 LEU   237      -7.296  21.552  24.388  1.00 14.34      A    C  
ATOM   1715  CD2 LEU   237      -8.818  23.386  23.687  1.00 16.05      A    C  
ATOM   1716  C   LEU   237      -5.783  22.717  20.758  1.00 18.19      A    C  
ATOM   1717  O   LEU   237      -6.296  23.612  20.087  1.00 18.01      A    O  
ATOM   1718  N   ALA   238      -5.606  21.483  20.304  1.00 20.35      A    N  
ATOM   1719  CA  ALA   238      -6.154  21.067  19.021  1.00 22.96      A    C  
ATOM   1720  CB  ALA   238      -5.573  19.715  18.604  1.00 22.72      A    C  
ATOM   1721  C   ALA   238      -7.670  20.985  19.103  1.00 24.35      A    C  
ATOM   1722  O   ALA   238      -8.237  20.646  20.142  1.00 25.10      A    O  
ATOM   1723  N   GLY   239      -8.338  21.295  18.002  1.00 26.36      A    N  
ATOM   1724  CA  GLY   239      -9.763  21.013  17.913  1.00 27.67      A    C  
ATOM   1725  C   GLY   239     -10.698  22.091  18.429  1.00 28.61      A    C  
ATOM   1726  O   GLY   239     -11.655  21.801  19.148  1.00 29.28      A    O  
ATOM   1727  N   ARG   240     -10.440  23.340  18.061  1.00 29.10           N  
ATOM   1728  CA  ARG   240     -11.454  24.383  18.262  1.00 29.55           C  
ATOM   1729  CB  ARG   240     -12.710  24.092  17.430  1.00 30.53           C  
ATOM   1730  CG  ARG   240     -12.474  24.085  15.925  1.00 33.58           C  
ATOM   1731  CD  ARG   240     -13.762  23.880  15.149  1.00 38.33           C  
ATOM   1732  NE  ARG   240     -13.495  23.869  13.714  1.00 41.74           N  
ATOM   1733  CZ  ARG   240     -14.407  24.096  12.772  1.00 43.52           C  
ATOM   1734  NH1 ARG   240     -15.671  24.360  13.105  1.00 44.69           N  
ATOM   1735  NH2 ARG   240     -14.051  24.066  11.490  1.00 43.91           N  
ATOM   1736  C   ARG   240     -11.832  24.549  19.739  1.00 28.00           C  
ATOM   1737  O   ARG   240     -12.019  23.574  20.478  1.00 28.31      A    O  
ATOM   1738  N   ALA   241     -11.964  25.806  20.141  1.00 26.48      A    N  
ATOM   1739  CA  ALA   241     -11.861  26.187  21.535  1.00 23.91      A    C  
ATOM   1740  CB  ALA   241     -11.409  27.635  21.645  1.00 23.72      A    C  
ATOM   1741  C   ALA   241     -13.132  25.949  22.341  1.00 22.42      A    C  
ATOM   1742  O   ALA   241     -14.230  25.928  21.794  1.00 22.61      A    O  
ATOM   1743  N   PRO   242     -12.979  25.758  23.655  1.00 20.76      A    N  
ATOM   1744  CA  PRO   242     -14.138  25.532  24.494  1.00 19.21      A    C  
ATOM   1745  CB  PRO   242     -13.541  24.895  25.752  1.00 19.39      A    C  
ATOM   1746  CG  PRO   242     -12.134  25.379  25.811  1.00 20.04      A    C  
ATOM   1747  CD  PRO   242     -11.704  25.592  24.385  1.00 20.59      A    C  
ATOM   1748  C   PRO   242     -14.856  26.844  24.850  1.00 17.67      A    C  
ATOM   1749  O   PRO   242     -15.957  26.801  25.390  1.00 16.99      A    O  
ATOM   1750  N   PHE   243     -14.235  27.983  24.528  1.00 15.95      A    N  
ATOM   1751  CA  PHE   243     -14.766  29.293  24.913  1.00 14.67      A    C  
ATOM   1752  CB  PHE   243     -13.920  29.905  26.044  1.00 15.00      A    C  
ATOM   1753  CG  PHE   243     -13.950  29.112  27.324  1.00 15.67      A    C  
ATOM   1754  CD1 PHE   243     -15.092  29.062  28.094  1.00 18.34      A    C  
ATOM   1755  CE1 PHE   243     -15.122  28.326  29.287  1.00 20.63      A    C  
ATOM   1756  CZ  PHE   243     -14.010  27.635  29.693  1.00 19.05      A    C  
ATOM   1757  CE2 PHE   243     -12.865  27.676  28.938  1.00 19.00      A    C  
ATOM   1758  CD2 PHE   243     -12.835  28.420  27.751  1.00 18.95      A    C  
ATOM   1759  C   PHE   243     -14.781  30.240  23.722  1.00 13.78      A    C  
ATOM   1760  O   PHE   243     -13.987  30.084  22.784  1.00 13.18      A    O  
ATOM   1761  N   SER   244     -15.669  31.232  23.775  1.00 12.52      A    N  
ATOM   1762  CA  SER   244     -15.759  32.234  22.717  1.00 11.90      A    C  
ATOM   1763  CB  SER   244     -17.221  32.484  22.335  1.00 12.90      A    C  
ATOM   1764  OG  SER   244     -17.848  33.361  23.254  1.00 15.35      A    O  
ATOM   1765  C   SER   244     -15.059  33.551  23.088  1.00 10.91      A    C  
ATOM   1766  O   SER   244     -14.860  34.409  22.236  1.00 10.95      A    O  
ATOM   1767  N   ARG   245     -14.731  33.699  24.369  1.00  9.65      A    N  
ATOM   1768  CA  ARG   245     -14.036  34.882  24.894  1.00  8.30      A    C  
ATOM   1769  CB  ARG   245     -14.911  35.562  25.960  1.00  8.39      A    C  
ATOM   1770  CG  ARG   245     -16.202  36.209  25.429  1.00 10.64      A    C  
ATOM   1771  CD  ARG   245     -17.111  36.590  26.583  1.00 15.14      A    C  
ATOM   1772  NE  ARG   245     -18.334  37.245  26.104  1.00 15.71      A    N  
ATOM   1773  CZ  ARG   245     -19.429  36.586  25.752  1.00 17.46      A    C  
ATOM   1774  NH1 ARG   245     -19.447  35.253  25.794  1.00 18.23      A    N  
ATOM   1775  NH2 ARG   245     -20.500  37.252  25.340  1.00 18.18      A    N  
ATOM   1776  C   ARG   245     -12.728  34.434  25.539  1.00  7.69      A    C  
ATOM   1777  O   ARG   245     -12.555  33.255  25.883  1.00  7.79      A    O  
ATOM   1778  N   LEU   246     -11.809  35.383  25.711  1.00  6.72      A    N  
ATOM   1779  CA  LEU   246     -10.589  35.142  26.482  1.00  6.91      A    C  
ATOM   1780  CB  LEU   246      -9.657  36.349  26.374  1.00  6.90      A    C  
ATOM   1781  CG  LEU   246      -9.406  36.891  24.966  1.00  7.52      A    C  
ATOM   1782  CD1 LEU   246      -8.399  38.008  25.075  1.00  7.96      A    C  
ATOM   1783  CD2 LEU   246      -8.882  35.808  24.008  1.00  7.60      A    C  
ATOM   1784  C   LEU   246     -10.946  34.918  27.944  1.00  6.90      A    C  
ATOM   1785  O   LEU   246     -11.898  35.516  28.459  1.00  6.64      A    O  
ATOM   1786  N   ILE   247     -10.188  34.049  28.622  1.00  6.47      A    N  
ATOM   1787  CA  ILE   247     -10.391  33.828  30.046  1.00  7.04      A    C  
ATOM   1788  CB  ILE   247     -10.809  32.383  30.359  1.00  7.69      A    C  
ATOM   1789  CG1 ILE   247     -12.036  31.980  29.524  1.00  7.94      A    C  
ATOM   1790  CD1 ILE   247     -13.328  32.787  29.804  1.00  9.23      A    C  
ATOM   1791  CG2 ILE   247     -11.017  32.201  31.879  1.00  7.54      A    C  
ATOM   1792  C   ILE   247      -9.096  34.128  30.808  1.00  7.59      A    C  
ATOM   1793  O   ILE   247      -8.041  33.566  30.490  1.00  7.66      A    O  
ATOM   1794  N   TYR   248      -9.183  35.037  31.774  1.00  6.63      A    N  
ATOM   1795  CA  TYR   248      -8.061  35.387  32.656  1.00  7.52      A    C  
ATOM   1796  CB  TYR   248      -7.717  36.877  32.522  1.00  6.90      A    C  
ATOM   1797  CG  TYR   248      -6.871  37.252  31.325  1.00  6.89      A    C  
ATOM   1798  CD1 TYR   248      -7.283  36.959  30.031  1.00  8.25      A    C  
ATOM   1799  CE1 TYR   248      -6.493  37.307  28.918  1.00  7.50      A    C  
ATOM   1800  CZ  TYR   248      -5.300  37.970  29.107  1.00  8.26      A    C  
ATOM   1801  OH  TYR   248      -4.527  38.327  28.006  1.00  8.26      A    O  
ATOM   1802  CE2 TYR   248      -4.879  38.296  30.388  1.00  8.23      A    C  
ATOM   1803  CD2 TYR   248      -5.665  37.933  31.488  1.00  6.66      A    C  
ATOM   1804  C   TYR   248      -8.436  35.148  34.119  1.00  7.85      A    C  
ATOM   1805  O   TYR   248      -9.444  35.664  34.588  1.00  7.69      A    O  
ATOM   1806  N   PRO   249      -7.607  34.411  34.878  1.00  8.01      A    N  
ATOM   1807  CA  PRO   249      -7.784  34.403  36.333  1.00  8.05      A    C  
ATOM   1808  CB  PRO   249      -6.676  33.436  36.809  1.00  8.48      A    C  
ATOM   1809  CG  PRO   249      -6.459  32.531  35.608  1.00  8.53      A    C  
ATOM   1810  CD  PRO   249      -6.546  33.480  34.439  1.00  8.42      A    C  
ATOM   1811  C   PRO   249      -7.554  35.811  36.915  1.00  8.25      A    C  
ATOM   1812  O   PRO   249      -7.012  36.677  36.224  1.00  8.85      A    O  
ATOM   1813  N   VAL   250      -7.979  36.049  38.151  1.00  8.72      A    N  
ATOM   1814  CA  VAL   250      -7.806  37.380  38.754  1.00  9.24      A    C  
ATOM   1815  CB  VAL   250      -8.527  37.510  40.115  1.00  8.62      A    C  
ATOM   1816  CG1 VAL   250     -10.028  37.359  39.916  1.00  9.05      A    C  
ATOM   1817  CG2 VAL   250      -7.981  36.471  41.143  1.00  9.59      A    C  
ATOM   1818  C   VAL   250      -6.325  37.732  38.890  1.00 10.19      A    C  
ATOM   1819  O   VAL   250      -5.478  36.850  38.996  1.00 11.06      A    O  
ATOM   1820  N   PRO   251      -6.013  39.032  38.878  1.00 11.49      A    N  
ATOM   1821  CA  PRO   251      -4.615  39.468  38.860  1.00 12.67      A    C  
ATOM   1822  CB  PRO   251      -4.699  40.998  38.995  1.00 13.04      A    C  
ATOM   1823  CG  PRO   251      -6.090  41.374  38.662  1.00 13.39      A    C  
ATOM   1824  CD  PRO   251      -6.975  40.144  38.748  1.00 11.42      A    C  
ATOM   1825  C   PRO   251      -3.823  38.892  40.025  1.00 13.50      A    C  
ATOM   1826  O   PRO   251      -2.634  38.547  39.869  1.00 14.04      A    O  
ATOM   1827  N   GLN   252      -4.471  38.784  41.184  1.00 13.91      A    N  
ATOM   1828  CA  GLN   252      -3.800  38.367  42.401  1.00 15.27      A    C  
ATOM   1829  CB  GLN   252      -4.293  39.199  43.597  1.00 15.31      A    C  
ATOM   1830  CG  GLN   252      -3.215  39.549  44.587  1.00 17.01      A    C  
ATOM   1831  CD  GLN   252      -3.704  40.492  45.674  1.00 18.72      A    C  
ATOM   1832  OE1 GLN   252      -4.049  41.651  45.402  1.00 17.92      A    O  
ATOM   1833  NE2 GLN   252      -3.720  40.005  46.915  1.00 17.66      A    N  
ATOM   1834  C   GLN   252      -3.961  36.884  42.701  1.00 15.14      A    C  
ATOM   1835  O   GLN   252      -3.677  36.432  43.816  1.00 16.38      A    O  
ATOM   1836  N   HIS   253      -4.431  36.124  41.717  1.00 15.20      A    N  
ATOM   1837  CA  HIS   253      -4.524  34.676  41.858  1.00 14.68      A    C  
ATOM   1838  CB  HIS   253      -4.903  34.044  40.513  1.00 14.79      A    C  
ATOM   1839  CG  HIS   253      -5.038  32.553  40.563  1.00 14.76      A    C  
ATOM   1840  ND1 HIS   253      -6.113  31.921  41.152  1.00 15.27      A    N  
ATOM   1841  CE1 HIS   253      -5.958  30.611  41.054  1.00 15.48      A    C  
ATOM   1842  NE2 HIS   253      -4.822  30.372  40.421  1.00 16.56      A    N  
ATOM   1843  CD2 HIS   253      -4.224  31.569  40.107  1.00 15.28      A    C  
ATOM   1844  C   HIS   253      -3.184  34.118  42.317  1.00 14.76      A    C  
ATOM   1845  O   HIS   253      -2.138  34.479  41.782  1.00 14.89      A    O  
ATOM   1846  N   ALA   254      -3.223  33.213  43.285  1.00 15.30      A    N  
ATOM   1847  CA  ALA   254      -1.996  32.664  43.859  1.00 16.18      A    C  
ATOM   1848  CB  ALA   254      -2.328  31.861  45.092  1.00 16.78      A    C  
ATOM   1849  C   ALA   254      -1.238  31.789  42.859  1.00 16.59      A    C  
ATOM   1850  O   ALA   254      -1.829  30.920  42.214  1.00 17.65      A    O  
ATOM   1851  N   GLY   255       0.063  32.029  42.727  1.00 16.56      A    N  
ATOM   1852  CA  GLY   255       0.907  31.172  41.884  1.00 16.33      A    C  
ATOM   1853  C   GLY   255       0.601  31.357  40.410  1.00 15.39      A    C  
ATOM   1854  O   GLY   255       0.450  32.485  39.937  1.00 16.73      A    O  
ATOM   1855  N   LEU   256       0.508  30.252  39.678  1.00 13.88      A    N  
ATOM   1856  CA  LEU   256       0.411  30.324  38.224  1.00 13.15      A    C  
ATOM   1857  CB  LEU   256       0.780  28.971  37.623  1.00 12.51      A    C  
ATOM   1858  CG  LEU   256       0.705  28.845  36.106  1.00 12.90      A    C  
ATOM   1859  CD1 LEU   256       1.749  29.690  35.464  1.00 11.55      A    C  
ATOM   1860  CD2 LEU   256       0.904  27.395  35.692  1.00 13.45      A    C  
ATOM   1861  C   LEU   256      -0.984  30.708  37.755  1.00 12.43      A    C  
ATOM   1862  O   LEU   256      -1.940  29.997  38.006  1.00 12.30      A    O  
ATOM   1863  N   GLY   257      -1.093  31.831  37.057  1.00 12.39      A    N  
ATOM   1864  CA  GLY   257      -2.366  32.215  36.455  1.00 11.94      A    C  
ATOM   1865  C   GLY   257      -2.323  31.976  34.962  1.00 11.42      A    C  
ATOM   1866  O   GLY   257      -1.634  32.696  34.248  1.00 12.25      A    O  
ATOM   1867  N   VAL   258      -3.048  30.961  34.498  1.00 10.57      A    N  
ATOM   1868  CA  VAL   258      -2.984  30.582  33.097  1.00  9.65      A    C  
ATOM   1869  CB  VAL   258      -3.137  29.058  32.912  1.00  9.42      A    C  
ATOM   1870  CG1 VAL   258      -3.011  28.718  31.435  1.00  9.96      A    C  
ATOM   1871  CG2 VAL   258      -2.075  28.321  33.719  1.00 10.25      A    C  
ATOM   1872  C   VAL   258      -4.097  31.250  32.313  1.00  8.69      A    C  
ATOM   1873  O   VAL   258      -5.276  31.018  32.589  1.00  8.82      A    O  
ATOM   1874  N   HIS   259      -3.720  32.091  31.355  1.00  8.69      A    N  
ATOM   1875  CA  HIS   259      -4.708  32.697  30.470  1.00  8.52      A    C  
ATOM   1876  CB  HIS   259      -4.157  33.940  29.775  1.00  8.94      A    C  
ATOM   1877  CG  HIS   259      -3.517  34.931  30.699  1.00  8.70      A    C  
ATOM   1878  ND1 HIS   259      -2.588  35.855  30.264  1.00 11.17      A    N  
ATOM   1879  CE1 HIS   259      -2.184  36.584  31.289  1.00  9.89      A    C  
ATOM   1880  NE2 HIS   259      -2.829  36.173  32.373  1.00  9.26      A    N  
ATOM   1881  CD2 HIS   259      -3.662  35.135  32.027  1.00  9.65      A    C  
ATOM   1882  C   HIS   259      -5.134  31.723  29.387  1.00  8.75      A    C  
ATOM   1883  O   HIS   259      -4.316  30.982  28.842  1.00  8.21      A    O  
ATOM   1884  N   LEU   260      -6.416  31.751  29.058  1.00  8.61      A    N  
ATOM   1885  CA  LEU   260      -6.900  31.053  27.879  1.00  9.66      A    C  
ATOM   1886  CB  LEU   260      -8.147  30.251  28.227  1.00 10.52      A    C  
ATOM   1887  CG  LEU   260      -8.652  29.286  27.155  1.00 13.49      A    C  
ATOM   1888  CD1 LEU   260      -9.657  28.342  27.788  1.00 17.17      A    C  
ATOM   1889  CD2 LEU   260      -9.279  30.057  26.026  1.00 16.43      A    C  
ATOM   1890  C   LEU   260      -7.185  32.131  26.839  1.00 10.52      A    C  
ATOM   1891  O   LEU   260      -8.030  33.010  27.054  1.00 11.23      A    O  
ATOM   1892  N   THR   261      -6.423  32.130  25.758  1.00 10.04      A    N  
ATOM   1893  CA  THR   261      -6.660  33.112  24.697  1.00 10.77      A    C  
ATOM   1894  CB  THR   261      -5.520  34.133  24.573  1.00 11.63      A    C  
ATOM   1895  OG1 THR   261      -4.338  33.465  24.116  1.00 11.35      A    O  
ATOM   1896  CG2 THR   261      -5.246  34.799  25.932  1.00 10.48      A    C  
ATOM   1897  C   THR   261      -6.942  32.398  23.365  1.00 10.91      A    C  
ATOM   1898  O   THR   261      -6.902  31.169  23.287  1.00 10.94      A    O  
ATOM   1899  N   LEU   262      -7.303  33.167  22.346  1.00 11.44      A    N  
ATOM   1900  CA  LEU   262      -7.759  32.573  21.086  1.00 12.06      A    C  
ATOM   1901  CB  LEU   262      -9.257  32.816  20.886  1.00 11.86      A    C  
ATOM   1902  CG  LEU   262     -10.225  32.119  21.861  1.00 13.23      A    C  
ATOM   1903  CD1 LEU   262     -11.575  32.859  21.908  1.00 16.99      A    C  
ATOM   1904  CD2 LEU   262     -10.415  30.624  21.528  1.00 17.13      A    C  
ATOM   1905  C   LEU   262      -6.988  33.223  19.957  1.00 12.69      A    C  
ATOM   1906  O   LEU   262      -6.642  34.406  20.032  1.00 12.48      A    O  
ATOM   1907  N   ASP   263      -6.687  32.449  18.921  1.00 13.40      A    N  
ATOM   1908  CA  ASP   263      -6.116  33.060  17.729  1.00 15.29      A    C  
ATOM   1909  CB  ASP   263      -5.002  32.205  17.105  1.00 16.06      A    C  
ATOM   1910  CG  ASP   263      -5.496  30.896  16.566  1.00 18.95      A    C  
ATOM   1911  OD1 ASP   263      -6.674  30.822  16.152  1.00 22.94      A    O  
ATOM   1912  OD2 ASP   263      -4.685  29.936  16.531  1.00 24.02      A    O  
ATOM   1913  C   ASP   263      -7.252  33.389  16.761  1.00 15.40      A    C  
ATOM   1914  O   ASP   263      -8.402  33.042  17.010  1.00 15.48      A    O  
ATOM   1915  N   LEU   264      -6.938  34.090  15.680  1.00 16.38      A    N  
ATOM   1916  CA  LEU   264      -7.959  34.531  14.748  1.00 17.60      A    C  
ATOM   1917  CB  LEU   264      -7.346  35.483  13.731  1.00 18.04      A    C  
ATOM   1918  CG  LEU   264      -7.108  36.889  14.284  1.00 18.95      A    C  
ATOM   1919  CD1 LEU   264      -6.402  37.738  13.241  1.00 20.48      A    C  
ATOM   1920  CD2 LEU   264      -8.429  37.520  14.675  1.00 20.84      A    C  
ATOM   1921  C   LEU   264      -8.685  33.378  14.051  1.00 18.29      A    C  
ATOM   1922  O   LEU   264      -9.833  33.525  13.620  1.00 18.22      A    O  
ATOM   1923  N   GLY   265      -8.016  32.234  13.960  1.00 18.52      A    N  
ATOM   1924  CA  GLY   265      -8.620  31.038  13.369  1.00 19.30      A    C  
ATOM   1925  C   GLY   265      -9.548  30.300  14.320  1.00 19.32      A    C  
ATOM   1926  O   GLY   265     -10.167  29.304  13.942  1.00 20.36      A    O  
ATOM   1927  N   GLY   266      -9.637  30.771  15.565  1.00 18.85      A    N  
ATOM   1928  CA  GLY   266     -10.577  30.211  16.536  1.00 17.59      A    C  
ATOM   1929  C   GLY   266      -9.999  29.184  17.493  1.00 17.14      A    C  
ATOM   1930  O   GLY   266     -10.731  28.623  18.318  1.00 17.58      A    O  
ATOM   1931  N   GLN   267      -8.692  28.935  17.395  1.00 16.26      A    N  
ATOM   1932  CA  GLN   267      -8.055  27.892  18.210  1.00 15.98      A    C  
ATOM   1933  CB  GLN   267      -6.863  27.292  17.476  1.00 16.35      A    C  
ATOM   1934  CG  GLN   267      -7.210  26.755  16.080  1.00 21.10      A    C  
ATOM   1935  CD  GLN   267      -7.859  25.373  16.091  1.00 26.43      A    C  
ATOM   1936  OE1 GLN   267      -8.851  25.129  16.782  1.00 30.29      A    O  
ATOM   1937  NE2 GLN   267      -7.306  24.463  15.290  1.00 30.58      A    N  
ATOM   1938  C   GLN   267      -7.609  28.471  19.541  1.00 14.60      A    C  
ATOM   1939  O   GLN   267      -7.183  29.624  19.593  1.00 14.37      A    O  
ATOM   1940  N   ALA   268      -7.710  27.676  20.606  1.00 13.38      A    N  
ATOM   1941  CA  ALA   268      -7.384  28.160  21.941  1.00 12.52      A    C  
ATOM   1942  CB  ALA   268      -8.259  27.471  22.988  1.00 13.02      A    C  
ATOM   1943  C   ALA   268      -5.915  27.917  22.246  1.00 11.90      A    C  
ATOM   1944  O   ALA   268      -5.331  26.927  21.801  1.00 12.23      A    O  
ATOM   1945  N   LYS   269      -5.314  28.826  22.995  1.00 10.24      A    N  
ATOM   1946  CA  LYS   269      -3.986  28.578  23.550  1.00 10.60      A    C  
ATOM   1947  CB  LYS   269      -2.871  29.230  22.738  1.00 11.48      A    C  
ATOM   1948  CG  LYS   269      -2.947  30.716  22.716  1.00 13.20      A    C  
ATOM   1949  CD  LYS   269      -1.853  31.356  21.843  1.00 17.38      A    C  
ATOM   1950  CE  LYS   269      -2.293  32.753  21.451  1.00 20.16      A    C  
ATOM   1951  NZ  LYS   269      -1.334  33.490  20.577  1.00 20.54      A    N  
ATOM   1952  C   LYS   269      -3.938  28.996  25.012  1.00 10.06      A    C  
ATOM   1953  O   LYS   269      -4.770  29.771  25.472  1.00  9.28      A    O  
ATOM   1954  N   PHE   270      -2.968  28.441  25.735  1.00  8.64      A    N  
ATOM   1955  CA  PHE   270      -2.882  28.636  27.175  1.00  9.31      A    C  
ATOM   1956  CB  PHE   270      -3.107  27.301  27.876  1.00 10.08      A    C  
ATOM   1957  CG  PHE   270      -4.514  26.808  27.745  1.00 11.56      A    C  
ATOM   1958  CD1 PHE   270      -5.493  27.252  28.622  1.00 15.06      A    C  
ATOM   1959  CE1 PHE   270      -6.813  26.837  28.497  1.00 15.20      A    C  
ATOM   1960  CZ  PHE   270      -7.158  25.955  27.482  1.00 15.93      A    C  
ATOM   1961  CE2 PHE   270      -6.192  25.526  26.583  1.00 14.70      A    C  
ATOM   1962  CD2 PHE   270      -4.866  25.956  26.722  1.00 16.44      A    C  
ATOM   1963  C   PHE   270      -1.530  29.190  27.518  1.00  8.87      A    C  
ATOM   1964  O   PHE   270      -0.529  28.749  26.955  1.00  8.57      A    O  
ATOM   1965  N   GLY   271      -1.503  30.146  28.445  1.00  8.10      A    N  
ATOM   1966  CA  GLY   271      -0.254  30.823  28.796  1.00  8.35      A    C  
ATOM   1967  C   GLY   271      -0.336  32.310  28.536  1.00  8.42      A    C  
ATOM   1968  O   GLY   271      -1.385  32.808  28.124  1.00  8.25      A    O  
ATOM   1969  N   PRO   272       0.782  33.024  28.732  1.00  8.68      A    N  
ATOM   1970  CA  PRO   272       2.107  32.459  29.043  1.00  8.92      A    C  
ATOM   1971  CB  PRO   272       3.045  33.569  28.563  1.00  9.05      A    C  
ATOM   1972  CG  PRO   272       2.256  34.840  28.942  1.00  9.03      A    C  
ATOM   1973  CD  PRO   272       0.841  34.490  28.557  1.00  8.18      A    C  
ATOM   1974  C   PRO   272       2.352  32.239  30.533  1.00  9.61      A    C  
ATOM   1975  O   PRO   272       1.695  32.863  31.384  1.00  9.74      A    O  
ATOM   1976  N   ASP   273       3.305  31.366  30.862  1.00  9.99      A    N  
ATOM   1977  CA  ASP   273       3.746  31.278  32.240  1.00  9.85      A    C  
ATOM   1978  CB  ASP   273       4.195  29.841  32.616  1.00  9.69      A    C  
ATOM   1979  CG  ASP   273       5.453  29.387  31.881  1.00 10.66      A    C  
ATOM   1980  OD1 ASP   273       5.979  30.139  31.040  1.00 10.49      A    O  
ATOM   1981  OD2 ASP   273       5.917  28.246  32.154  1.00 12.27      A    O  
ATOM   1982  C   ASP   273       4.850  32.299  32.470  1.00  9.78      A    C  
ATOM   1983  O   ASP   273       5.055  33.214  31.638  1.00  9.27      A    O  
ATOM   1984  N   THR   274       5.547  32.158  33.595  1.00 10.55      A    N  
ATOM   1985  CA  THR   274       6.660  33.056  33.909  1.00 11.27      A    C  
ATOM   1986  CB  THR   274       6.322  34.072  35.011  1.00 12.04      A    C  
ATOM   1987  OG1 THR   274       5.862  33.379  36.167  1.00 14.76      A    O  
ATOM   1988  CG2 THR   274       5.248  35.032  34.541  1.00 11.04      A    C  
ATOM   1989  C   THR   274       7.901  32.272  34.325  1.00 11.15      A    C  
ATOM   1990  O   THR   274       7.835  31.367  35.162  1.00 12.09      A    O  
ATOM   1991  N   GLU   275       9.025  32.653  33.741  1.00 10.62      A    N  
ATOM   1992  CA  GLU   275      10.268  31.926  33.968  1.00 10.76      A    C  
ATOM   1993  CB  GLU   275      10.368  30.782  32.959  1.00 10.82      A    C  
ATOM   1994  CG  GLU   275      11.597  29.872  33.165  1.00 12.29      A    C  
ATOM   1995  CD  GLU   275      11.835  28.931  32.002  1.00 15.29      A    C  
ATOM   1996  OE1 GLU   275      12.893  28.229  32.001  1.00 14.65      A    O  
ATOM   1997  OE2 GLU   275      10.980  28.881  31.084  1.00 11.82      A    O  
ATOM   1998  C   GLU   275      11.452  32.866  33.805  1.00 10.62      A    C  
ATOM   1999  O   GLU   275      11.833  33.208  32.686  1.00  9.94      A    O  
ATOM   2000  N   TRP   276      12.040  33.279  34.925  1.00 11.47      A    N  
ATOM   2001  CA  TRP   276      13.182  34.184  34.858  1.00 11.40      A    C  
ATOM   2002  CB  TRP   276      13.425  34.853  36.213  1.00 11.92      A    C  
ATOM   2003  CG  TRP   276      12.284  35.761  36.620  1.00 12.48      A    C  
ATOM   2004  CD1 TRP   276      11.097  35.382  37.190  1.00 14.61      A    C  
ATOM   2005  NE1 TRP   276      10.303  36.489  37.406  1.00 16.05      A    N  
ATOM   2006  CE2 TRP   276      10.974  37.606  36.980  1.00 15.55      A    C  
ATOM   2007  CD2 TRP   276      12.226  37.186  36.478  1.00 13.93      A    C  
ATOM   2008  CE3 TRP   276      13.108  38.147  35.968  1.00 13.89      A    C  
ATOM   2009  CZ3 TRP   276      12.724  39.483  35.988  1.00 12.81      A    C  
ATOM   2010  CH2 TRP   276      11.482  39.870  36.505  1.00 13.78      A    C  
ATOM   2011  CZ2 TRP   276      10.590  38.953  36.999  1.00 13.37      A    C  
ATOM   2012  C   TRP   276      14.406  33.401  34.418  1.00 11.85      A    C  
ATOM   2013  O   TRP   276      14.698  32.349  34.993  1.00 12.20      A    O  
ATOM   2014  N   ILE   277      15.088  33.904  33.392  1.00 11.57      A    N  
ATOM   2015  CA  ILE   277      16.202  33.196  32.775  1.00 11.71      A    C  
ATOM   2016  CB  ILE   277      15.816  32.558  31.422  1.00 11.61      A    C  
ATOM   2017  CG1 ILE   277      15.292  33.628  30.441  1.00 12.57      A    C  
ATOM   2018  CD1 ILE   277      15.054  33.139  29.003  1.00 13.97      A    C  
ATOM   2019  CG2 ILE   277      14.806  31.459  31.656  1.00 10.36      A    C  
ATOM   2020  C   ILE   277      17.420  34.094  32.591  1.00 12.72      A    C  
ATOM   2021  O   ILE   277      17.313  35.316  32.642  1.00 13.24      A    O  
ATOM   2022  N   ALA   278      18.573  33.473  32.357  1.00 13.28      A    N  
ATOM   2023  CA  ALA   278      19.847  34.188  32.279  1.00 14.04      A    C  
ATOM   2024  CB  ALA   278      20.958  33.315  32.878  1.00 14.41      A    C  
ATOM   2025  C   ALA   278      20.253  34.618  30.868  1.00 14.68      A    C  
ATOM   2026  O   ALA   278      21.076  35.527  30.702  1.00 15.66      A    O  
ATOM   2027  N   THR   279      19.738  33.921  29.859  1.00 14.41      A    N  
ATOM   2028  CA  THR   279      20.135  34.169  28.482  1.00 15.06      A    C  
ATOM   2029  CB  THR   279      21.205  33.163  27.999  1.00 14.74      A    C  
ATOM   2030  OG1 THR   279      20.605  31.872  27.844  1.00 16.89      A    O  
ATOM   2031  CG2 THR   279      22.352  33.056  29.002  1.00 17.10      A    C  
ATOM   2032  C   THR   279      18.933  34.054  27.565  1.00 14.88      A    C  
ATOM   2033  O   THR   279      17.903  33.500  27.955  1.00 14.75      A    O  
ATOM   2034  N   GLU   280      19.082  34.572  26.346  1.00 15.09      A    N  
ATOM   2035  CA  GLU   280      17.990  34.642  25.385  1.00 15.97      A    C  
ATOM   2036  CB  GLU   280      18.277  35.734  24.351  1.00 16.40      A    C  
ATOM   2037  CG  GLU   280      17.062  36.105  23.512  1.00 16.26      A    C  
ATOM   2038  CD  GLU   280      17.353  37.197  22.503  1.00 17.86      A    C  
ATOM   2039  OE1 GLU   280      18.480  37.743  22.516  1.00 17.75      A    O  
ATOM   2040  OE2 GLU   280      16.447  37.510  21.699  1.00 15.48      A    O  
ATOM   2041  C   GLU   280      17.781  33.319  24.672  1.00 16.35      A    C  
ATOM   2042  O   GLU   280      18.318  33.093  23.575  1.00 17.34      A    O  
ATOM   2043  N   ASP   281      16.976  32.459  25.280  1.00 16.27      A    N  
ATOM   2044  CA  ASP   281      16.787  31.103  24.811  1.00 15.94      A    C  
ATOM   2045  CB  ASP   281      17.349  30.156  25.848  1.00 16.71      A    C  
ATOM   2046  CG  ASP   281      17.211  28.714  25.451  1.00 19.98      A    C  
ATOM   2047  OD1 ASP   281      16.590  28.437  24.404  1.00 22.88      A    O  
ATOM   2048  OD2 ASP   281      17.740  27.860  26.198  1.00 24.64      A    O  
ATOM   2049  C   ASP   281      15.296  30.830  24.614  1.00 15.49      A    C  
ATOM   2050  O   ASP   281      14.542  30.828  25.582  1.00 15.13      A    O  
ATOM   2051  N   TYR   282      14.884  30.622  23.368  1.00 15.22      A    N  
ATOM   2052  CA  TYR   282      13.450  30.475  23.022  1.00 15.44      A    C  
ATOM   2053  CB  TYR   282      13.120  31.173  21.694  1.00 15.29      A    C  
ATOM   2054  CG  TYR   282      13.325  32.658  21.760  1.00 16.45      A    C  
ATOM   2055  CD1 TYR   282      12.366  33.484  22.340  1.00 16.25      A    C  
ATOM   2056  CE1 TYR   282      12.565  34.837  22.436  1.00 16.29      A    C  
ATOM   2057  CZ  TYR   282      13.737  35.389  21.938  1.00 16.47      A    C  
ATOM   2058  OH  TYR   282      13.940  36.741  22.031  1.00 18.48      A    O  
ATOM   2059  CE2 TYR   282      14.695  34.591  21.355  1.00 16.16      A    C  
ATOM   2060  CD2 TYR   282      14.487  33.236  21.274  1.00 15.31      A    C  
ATOM   2061  C   TYR   282      12.974  29.036  22.964  1.00 15.74      A    C  
ATOM   2062  O   TYR   282      11.809  28.772  22.639  1.00 15.76      A    O  
ATOM   2063  N   THR   283      13.872  28.106  23.270  1.00 16.29      A    N  
ATOM   2064  CA  THR   283      13.540  26.694  23.216  1.00 16.87      A    C  
ATOM   2065  CB  THR   283      14.729  25.826  23.644  1.00 17.42      A    C  
ATOM   2066  OG1 THR   283      15.899  26.263  22.946  1.00 19.92      A    O  
ATOM   2067  CG2 THR   283      14.468  24.360  23.320  1.00 18.08      A    C  
ATOM   2068  C   THR   283      12.339  26.359  24.096  1.00 16.86      A    C  
ATOM   2069  O   THR   283      12.297  26.708  25.266  1.00 15.97      A    O  
ATOM   2070  N   LEU   284      11.362  25.665  23.519  1.00 17.40      A    N  
ATOM   2071  CA  LEU   284      10.183  25.252  24.271  1.00 17.56      A    C  
ATOM   2072  CB  LEU   284       8.997  25.061  23.323  1.00 17.84      A    C  
ATOM   2073  CG  LEU   284       7.692  24.549  23.951  1.00 18.55      A    C  
ATOM   2074  CD1 LEU   284       7.000  25.612  24.813  1.00 20.18      A    C  
ATOM   2075  CD2 LEU   284       6.745  24.055  22.881  1.00 20.17      A    C  
ATOM   2076  C   LEU   284      10.419  23.968  25.070  1.00 17.57      A    C  
ATOM   2077  O   LEU   284      10.850  22.939  24.518  1.00 18.00      A    O  
ATOM   2078  N   ASP   285      10.145  24.030  26.370  1.00 16.60      A    N  
ATOM   2079  CA  ASP   285      10.186  22.856  27.220  1.00 17.28      A    C  
ATOM   2080  CB  ASP   285      10.779  23.206  28.585  1.00 17.02      A    C  
ATOM   2081  CG  ASP   285      10.878  22.006  29.514  1.00 18.78      A    C  
ATOM   2082  OD1 ASP   285      10.399  20.910  29.164  1.00 18.34      A    O  
ATOM   2083  OD2 ASP   285      11.442  22.164  30.619  1.00 21.24      A    O  
ATOM   2084  C   ASP   285       8.764  22.347  27.380  1.00 17.24      A    C  
ATOM   2085  O   ASP   285       7.975  22.935  28.125  1.00 16.97      A    O  
ATOM   2086  N   PRO   286       8.418  21.263  26.667  1.00 17.26      A    N  
ATOM   2087  CA  PRO   286       7.056  20.743  26.719  1.00 17.54      A    C  
ATOM   2088  CB  PRO   286       7.129  19.466  25.872  1.00 17.50      A    C  
ATOM   2089  CG  PRO   286       8.298  19.666  24.974  1.00 18.33      A    C  
ATOM   2090  CD  PRO   286       9.285  20.459  25.791  1.00 17.69      A    C  
ATOM   2091  C   PRO   286       6.624  20.394  28.135  1.00 17.34      A    C  
ATOM   2092  O   PRO   286       5.423  20.382  28.431  1.00 17.57      A    O  
ATOM   2093  N   ARG   287       7.586  20.103  29.006  1.00 17.57      A    N  
ATOM   2094  CA  ARG   287       7.267  19.708  30.374  1.00 17.64      A    C  
ATOM   2095  CB  ARG   287       8.468  19.049  31.063  1.00 18.31      A    C  
ATOM   2096  CG  ARG   287       8.897  17.733  30.394  1.00 22.54      A    C  
ATOM   2097  CD  ARG   287       7.687  16.877  30.034  1.00 27.59      A    C  
ATOM   2098  NE  ARG   287       7.130  16.192  31.197  1.00 32.67      A    N  
ATOM   2099  CZ  ARG   287       5.889  15.711  31.256  1.00 35.40      A    C  
ATOM   2100  NH1 ARG   287       5.064  15.869  30.231  1.00 36.13      A    N  
ATOM   2101  NH2 ARG   287       5.461  15.091  32.355  1.00 37.15      A    N  
ATOM   2102  C   ARG   287       6.716  20.853  31.216  1.00 16.94      A    C  
ATOM   2103  O   ARG   287       6.134  20.629  32.268  1.00 17.31      A    O  
ATOM   2104  N   ARG   288       6.875  22.083  30.734  1.00 15.87      A    N  
ATOM   2105  CA  ARG   288       6.365  23.230  31.472  1.00 14.59      A    C  
ATOM   2106  CB  ARG   288       6.936  24.536  30.909  1.00 14.24      A    C  
ATOM   2107  CG  ARG   288       8.441  24.735  31.179  1.00 13.41      A    C  
ATOM   2108  CD  ARG   288       8.886  26.175  30.981  1.00 14.26      A    C  
ATOM   2109  NE  ARG   288       8.313  27.029  32.022  1.00 13.59      A    N  
ATOM   2110  CZ  ARG   288       8.821  27.191  33.239  1.00 14.84      A    C  
ATOM   2111  NH1 ARG   288       9.934  26.549  33.599  1.00 13.13      A    N  
ATOM   2112  NH2 ARG   288       8.203  27.985  34.105  1.00 13.55      A    N  
ATOM   2113  C   ARG   288       4.829  23.257  31.479  1.00 13.80      A    C  
ATOM   2114  O   ARG   288       4.213  23.954  32.300  1.00 12.53      A    O  
ATOM   2115  N   ALA   289       4.217  22.487  30.581  1.00 13.00      A    N  
ATOM   2116  CA  ALA   289       2.752  22.351  30.572  1.00 12.95      A    C  
ATOM   2117  CB  ALA   289       2.268  21.718  29.257  1.00 13.05      A    C  
ATOM   2118  C   ALA   289       2.201  21.553  31.762  1.00 12.66      A    C  
ATOM   2119  O   ALA   289       1.017  21.620  32.074  1.00 12.60      A    O  
ATOM   2120  N   ASP   290       3.044  20.760  32.417  1.00 13.55      A    N  
ATOM   2121  CA  ASP   290       2.541  19.898  33.475  1.00 13.88      A    C  
ATOM   2122  CB  ASP   290       3.702  19.117  34.111  1.00 14.93      A    C  
ATOM   2123  CG  ASP   290       4.303  18.102  33.169  1.00 18.97      A    C  
ATOM   2124  OD1 ASP   290       3.702  17.847  32.102  1.00 22.29      A    O  
ATOM   2125  OD2 ASP   290       5.366  17.529  33.510  1.00 22.42      A    O  
ATOM   2126  C   ASP   290       1.740  20.647  34.558  1.00 13.43      A    C  
ATOM   2127  O   ASP   290       0.681  20.189  34.999  1.00 12.95      A    O  
ATOM   2128  N   VAL   291       2.241  21.805  34.979  1.00 12.94      A    N  
ATOM   2129  CA  VAL   291       1.579  22.575  36.025  1.00 12.20      A    C  
ATOM   2130  CB  VAL   291       2.554  23.571  36.672  1.00 12.87      A    C  
ATOM   2131  CG1 VAL   291       3.669  22.836  37.399  1.00 13.57      A    C  
ATOM   2132  CG2 VAL   291       3.136  24.471  35.635  1.00 12.19      A    C  
ATOM   2133  C   VAL   291       0.364  23.350  35.495  1.00 12.43      A    C  
ATOM   2134  O   VAL   291      -0.433  23.885  36.280  1.00 12.01      A    O  
ATOM   2135  N   PHE   292       0.240  23.442  34.168  1.00 11.95      A    N  
ATOM   2136  CA  PHE   292      -0.914  24.152  33.578  1.00 10.92      A    C  
ATOM   2137  CB  PHE   292      -0.783  24.271  32.058  1.00 11.04      A    C  
ATOM   2138  CG  PHE   292       0.084  25.418  31.582  1.00 10.23      A    C  
ATOM   2139  CD1 PHE   292       1.360  25.624  32.097  1.00 10.82      A    C  
ATOM   2140  CE1 PHE   292       2.176  26.666  31.613  1.00 11.82      A    C  
ATOM   2141  CZ  PHE   292       1.696  27.517  30.616  1.00 10.93      A    C  
ATOM   2142  CE2 PHE   292       0.426  27.298  30.083  1.00 10.64      A    C  
ATOM   2143  CD2 PHE   292      -0.366  26.258  30.563  1.00 10.22      A    C  
ATOM   2144  C   PHE   292      -2.238  23.453  33.884  1.00 11.02      A    C  
ATOM   2145  O   PHE   292      -3.282  24.107  34.008  1.00 10.60      A    O  
ATOM   2146  N   TYR   293      -2.209  22.127  33.970  1.00  9.73      A    N  
ATOM   2147  CA  TYR   293      -3.455  21.374  34.016  1.00  9.69      A    C  
ATOM   2148  CB  TYR   293      -3.162  19.869  33.976  1.00  9.58      A    C  
ATOM   2149  CG  TYR   293      -2.775  19.407  32.593  1.00  9.06      A    C  
ATOM   2150  CD1 TYR   293      -3.750  18.990  31.689  1.00 11.13      A    C  
ATOM   2151  CE1 TYR   293      -3.423  18.569  30.413  1.00 10.53      A    C  
ATOM   2152  CZ  TYR   293      -2.108  18.560  30.016  1.00 10.33      A    C  
ATOM   2153  OH  TYR   293      -1.790  18.143  28.740  1.00 13.17      A    O  
ATOM   2154  CE2 TYR   293      -1.109  18.985  30.880  1.00 10.09      A    C  
ATOM   2155  CD2 TYR   293      -1.456  19.412  32.178  1.00  9.39      A    C  
ATOM   2156  C   TYR   293      -4.368  21.737  35.191  1.00  9.92      A    C  
ATOM   2157  O   TYR   293      -5.554  22.004  34.993  1.00  9.94      A    O  
ATOM   2158  N   ALA   294      -3.819  21.748  36.400  1.00 10.38      A    N  
ATOM   2159  CA  ALA   294      -4.618  22.040  37.593  1.00 10.88      A    C  
ATOM   2160  CB  ALA   294      -3.809  21.778  38.852  1.00 11.48      A    C  
ATOM   2161  C   ALA   294      -5.071  23.488  37.567  1.00 11.10      A    C  
ATOM   2162  O   ALA   294      -6.197  23.799  37.969  1.00 12.44      A    O  
ATOM   2163  N   ALA   295      -4.189  24.367  37.093  1.00 10.94      A    N  
ATOM   2164  CA  ALA   295      -4.506  25.802  37.020  1.00 10.51      A    C  
ATOM   2165  CB  ALA   295      -3.292  26.570  36.554  1.00 10.31      A    C  
ATOM   2166  C   ALA   295      -5.687  26.045  36.078  1.00 10.79      A    C  
ATOM   2167  O   ALA   295      -6.684  26.696  36.446  1.00 10.82      A    O  
ATOM   2168  N   VAL   296      -5.594  25.507  34.864  1.00 10.01      A    N  
ATOM   2169  CA  VAL   296      -6.707  25.622  33.914  1.00  9.87      A    C  
ATOM   2170  CB  VAL   296      -6.340  25.059  32.527  1.00  9.10      A    C  
ATOM   2171  CG1 VAL   296      -7.574  25.046  31.617  1.00  9.19      A    C  
ATOM   2172  CG2 VAL   296      -5.215  25.853  31.908  1.00  9.41      A    C  
ATOM   2173  C   VAL   296      -7.986  24.962  34.400  1.00  9.86      A    C  
ATOM   2174  O   VAL   296      -9.065  25.507  34.250  1.00  9.68      A    O  
ATOM   2175  N   ARG   297      -7.878  23.776  35.000  1.00 10.21      A    N  
ATOM   2176  CA  ARG   297      -9.074  23.057  35.450  1.00 11.00      A    C  
ATOM   2177  CB  ARG   297      -8.706  21.631  35.865  1.00 10.72      A    C  
ATOM   2178  CG  ARG   297      -8.517  20.756  34.627  1.00  9.80      A    C  
ATOM   2179  CD  ARG   297      -7.831  19.429  34.941  1.00  9.74      A    C  
ATOM   2180  NE  ARG   297      -7.725  18.609  33.735  1.00 11.40      A    N  
ATOM   2181  CZ  ARG   297      -6.859  17.608  33.583  1.00 11.89      A    C  
ATOM   2182  NH1 ARG   297      -6.002  17.315  34.561  1.00 11.87      A    N  
ATOM   2183  NH2 ARG   297      -6.852  16.905  32.448  1.00 12.00      A    N  
ATOM   2184  C   ARG   297      -9.886  23.767  36.537  1.00 11.44      A    C  
ATOM   2185  O   ARG   297     -11.049  23.446  36.770  1.00 12.42      A    O  
ATOM   2186  N   SER   298      -9.278  24.756  37.179  1.00 12.40      A    N  
ATOM   2187  CA  SER   298     -10.018  25.583  38.114  1.00 13.04      A    C  
ATOM   2188  CB  SER   298      -9.102  26.591  38.787  1.00 13.52      A    C  
ATOM   2189  OG  SER   298      -8.259  25.925  39.715  1.00 16.65      A    O  
ATOM   2190  C   SER   298     -11.214  26.290  37.472  1.00 12.51      A    C  
ATOM   2191  O   SER   298     -12.263  26.428  38.120  1.00 13.57      A    O  
ATOM   2192  N   TYR   299     -11.059  26.734  36.222  1.00 10.89      A    N  
ATOM   2193  CA  TYR   299     -12.162  27.386  35.502  1.00 10.28      A    C  
ATOM   2194  CB  TYR   299     -11.774  28.812  35.075  1.00  9.50      A    C  
ATOM   2195  CG  TYR   299     -10.564  28.908  34.167  1.00  9.27      A    C  
ATOM   2196  CD1 TYR   299     -10.662  28.631  32.804  1.00  8.31      A    C  
ATOM   2197  CE1 TYR   299      -9.543  28.723  31.962  1.00  7.83      A    C  
ATOM   2198  CZ  TYR   299      -8.324  29.135  32.495  1.00  9.02      A    C  
ATOM   2199  OH  TYR   299      -7.223  29.242  31.688  1.00 10.26      A    O  
ATOM   2200  CE2 TYR   299      -8.210  29.418  33.844  1.00  8.89      A    C  
ATOM   2201  CD2 TYR   299      -9.322  29.302  34.670  1.00  8.08      A    C  
ATOM   2202  C   TYR   299     -12.696  26.591  34.297  1.00 10.61      A    C  
ATOM   2203  O   TYR   299     -13.793  26.865  33.793  1.00 11.06      A    O  
ATOM   2204  N   TRP   300     -11.914  25.624  33.828  1.00 10.62      A    N  
ATOM   2205  CA  TRP   300     -12.352  24.744  32.739  1.00 11.34      A    C  
ATOM   2206  CB  TRP   300     -11.674  25.096  31.415  1.00 11.18      A    C  
ATOM   2207  CG  TRP   300     -12.158  24.197  30.274  1.00 11.38      A    C  
ATOM   2208  CD1 TRP   300     -13.417  23.712  30.106  1.00 11.92      A    C  
ATOM   2209  NE1 TRP   300     -13.485  22.936  28.964  1.00 13.28      A    N  
ATOM   2210  CE2 TRP   300     -12.242  22.897  28.387  1.00 12.66      A    C  
ATOM   2211  CD2 TRP   300     -11.376  23.671  29.189  1.00 11.25      A    C  
ATOM   2212  CE3 TRP   300     -10.036  23.800  28.807  1.00 11.05      A    C  
ATOM   2213  CZ3 TRP   300      -9.602  23.139  27.663  1.00 12.96      A    C  
ATOM   2214  CH2 TRP   300     -10.484  22.368  26.900  1.00 11.99      A    C  
ATOM   2215  CZ2 TRP   300     -11.803  22.232  27.243  1.00 13.03      A    C  
ATOM   2216  C   TRP   300     -12.051  23.295  33.111  1.00 11.84      A    C  
ATOM   2217  O   TRP   300     -11.083  22.702  32.627  1.00 11.54      A    O  
ATOM   2218  N   PRO   301     -12.873  22.733  33.992  1.00 12.67      A    N  
ATOM   2219  CA  PRO   301     -12.551  21.392  34.504  1.00 13.02      A    C  
ATOM   2220  CB  PRO   301     -13.652  21.113  35.531  1.00 13.41      A    C  
ATOM   2221  CG  PRO   301     -14.550  22.298  35.535  1.00 14.04      A    C  
ATOM   2222  CD  PRO   301     -13.949  23.403  34.745  1.00 12.33      A    C  
ATOM   2223  C   PRO   301     -12.527  20.306  33.418  1.00 13.72      A    C  
ATOM   2224  O   PRO   301     -11.853  19.276  33.604  1.00 14.48      A    O  
ATOM   2225  N   ALA   302     -13.201  20.548  32.290  1.00 13.88      A    N  
ATOM   2226  CA  ALA   302     -13.247  19.568  31.188  1.00 13.62      A    C  
ATOM   2227  CB  ALA   302     -14.469  19.799  30.299  1.00 14.40      A    C  
ATOM   2228  C   ALA   302     -11.973  19.471  30.327  1.00 13.21      A    C  
ATOM   2229  O   ALA   302     -11.924  18.685  29.372  1.00 12.71      A    O  
ATOM   2230  N   LEU   303     -10.953  20.269  30.636  1.00 12.15      A    N  
ATOM   2231  CA  LEU   303      -9.669  20.124  29.963  1.00 11.78      A    C  
ATOM   2232  CB  LEU   303      -8.616  21.028  30.628  1.00 12.03      A    C  
ATOM   2233  CG  LEU   303      -7.164  20.732  30.254  1.00 10.30      A    C  
ATOM   2234  CD1 LEU   303      -6.941  21.017  28.784  1.00 10.85      A    C  
ATOM   2235  CD2 LEU   303      -6.222  21.572  31.101  1.00 12.46      A    C  
ATOM   2236  C   LEU   303      -9.219  18.658  29.996  1.00 12.31      A    C  
ATOM   2237  O   LEU   303      -9.025  18.088  31.064  1.00 11.62      A    O  
ATOM   2238  N   PRO   304      -9.072  18.028  28.824  1.00 12.54      A    N  
ATOM   2239  CA  PRO   304      -8.681  16.600  28.863  1.00 12.74      A    C  
ATOM   2240  CB  PRO   304      -8.928  16.141  27.426  1.00 12.86      A    C  
ATOM   2241  CG  PRO   304      -9.958  17.104  26.883  1.00 12.88      A    C  
ATOM   2242  CD  PRO   304      -9.506  18.431  27.479  1.00 13.01      A    C  
ATOM   2243  C   PRO   304      -7.220  16.355  29.202  1.00 12.69      A    C  
ATOM   2244  O   PRO   304      -6.372  17.183  28.892  1.00 12.47      A    O  
ATOM   2245  N   ASP   305      -6.912  15.192  29.782  1.00 12.85      A    N  
ATOM   2246  CA  ASP   305      -5.510  14.814  29.972  1.00 13.93      A    C  
ATOM   2247  CB  ASP   305      -5.380  13.382  30.520  1.00 14.21      A    C  
ATOM   2248  CG  ASP   305      -5.872  13.231  31.946  1.00 17.28      A    C  
ATOM   2249  OD1 ASP   305      -6.049  14.241  32.660  1.00 18.05      A    O  
ATOM   2250  OD2 ASP   305      -6.076  12.062  32.361  1.00 18.72      A    O  
ATOM   2251  C   ASP   305      -4.754  14.865  28.637  1.00 13.61      A    C  
ATOM   2252  O   ASP   305      -5.281  14.452  27.591  1.00 13.18      A    O  
ATOM   2253  N   GLY   306      -3.521  15.358  28.694  1.00 14.09      A    N  
ATOM   2254  CA  GLY   306      -2.581  15.336  27.573  1.00 15.47      A    C  
ATOM   2255  C   GLY   306      -2.878  16.305  26.452  1.00 15.97      A    C  
ATOM   2256  O   GLY   306      -2.157  16.342  25.442  1.00 16.58      A    O  
ATOM   2257  N   ALA   307      -3.924  17.114  26.627  1.00 15.64      A    N  
ATOM   2258  CA  ALA   307      -4.410  17.981  25.550  1.00 15.84      A    C  
ATOM   2259  CB  ALA   307      -5.864  18.338  25.764  1.00 15.75      A    C  
ATOM   2260  C   ALA   307      -3.595  19.248  25.320  1.00 15.38      A    C  
ATOM   2261  O   ALA   307      -3.788  19.926  24.314  1.00 16.04      A    O  
ATOM   2262  N   LEU   308      -2.702  19.580  26.238  1.00 15.35      A    N  
ATOM   2263  CA  LEU   308      -1.890  20.798  26.078  1.00 15.06      A    C  
ATOM   2264  CB  LEU   308      -1.536  21.397  27.435  1.00 15.18      A    C  
ATOM   2265  CG  LEU   308      -2.718  21.870  28.281  1.00 14.77      A    C  
ATOM   2266  CD1 LEU   308      -2.198  22.497  29.562  1.00 14.10      A    C  
ATOM   2267  CD2 LEU   308      -3.618  22.855  27.503  1.00 14.87      A    C  
ATOM   2268  C   LEU   308      -0.638  20.554  25.233  1.00 15.79      A    C  
ATOM   2269  O   LEU   308       0.415  20.143  25.748  1.00 16.90      A    O  
ATOM   2270  N   ALA   309      -0.765  20.814  23.933  1.00 15.13      A    N  
ATOM   2271  CA  ALA   309       0.294  20.542  22.959  1.00 15.57      A    C  
ATOM   2272  CB  ALA   309      -0.291  20.418  21.570  1.00 15.95      A    C  
ATOM   2273  C   ALA   309       1.339  21.638  22.982  1.00 15.67      A    C  
ATOM   2274  O   ALA   309       1.038  22.791  23.307  1.00 15.40      A    O  
ATOM   2275  N   PRO   310       2.583  21.291  22.620  1.00 15.20      A    N  
ATOM   2276  CA  PRO   310       3.639  22.296  22.612  1.00 15.54      A    C  
ATOM   2277  CB  PRO   310       4.845  21.522  22.066  1.00 16.09      A    C  
ATOM   2278  CG  PRO   310       4.594  20.132  22.520  1.00 15.08      A    C  
ATOM   2279  CD  PRO   310       3.105  19.946  22.318  1.00 15.93      A    C  
ATOM   2280  C   PRO   310       3.283  23.481  21.715  1.00 15.55      A    C  
ATOM   2281  O   PRO   310       2.832  23.304  20.573  1.00 16.49      A    O  
ATOM   2282  N   GLY   311       3.466  24.683  22.245  1.00 14.91      A    N  
ATOM   2283  CA  GLY   311       3.155  25.880  21.499  1.00 13.85      A    C  
ATOM   2284  C   GLY   311       4.416  26.604  21.094  1.00 13.91      A    C  
ATOM   2285  O   GLY   311       5.090  26.215  20.126  1.00 13.87      A    O  
ATOM   2286  N   TYR   312       4.751  27.644  21.848  1.00 12.49      A    N  
ATOM   2287  CA  TYR   312       5.884  28.490  21.525  1.00 12.61      A    C  
ATOM   2288  CB  TYR   312       5.543  29.393  20.332  1.00 12.89      A    C  
ATOM   2289  CG  TYR   312       4.403  30.366  20.585  1.00 12.92      A    C  
ATOM   2290  CD1 TYR   312       4.656  31.712  20.897  1.00 14.66      A    C  
ATOM   2291  CE1 TYR   312       3.604  32.609  21.121  1.00 12.57      A    C  
ATOM   2292  CZ  TYR   312       2.301  32.162  21.036  1.00 15.48      A    C  
ATOM   2293  OH  TYR   312       1.251  33.029  21.263  1.00 14.99      A    O  
ATOM   2294  CE2 TYR   312       2.029  30.838  20.730  1.00 14.43      A    C  
ATOM   2295  CD2 TYR   312       3.085  29.949  20.505  1.00 14.65      A    C  
ATOM   2296  C   TYR   312       6.198  29.334  22.752  1.00 12.62      A    C  
ATOM   2297  O   TYR   312       5.443  29.319  23.726  1.00 12.46      A    O  
ATOM   2298  N   THR   313       7.307  30.060  22.692  1.00 12.54      A    N  
ATOM   2299  CA  THR   313       7.735  30.902  23.798  1.00 11.75      A    C  
ATOM   2300  CB  THR   313       9.086  30.437  24.360  1.00 12.16      A    C  
ATOM   2301  OG1 THR   313      10.093  30.686  23.378  1.00 13.42      A    O  
ATOM   2302  CG2 THR   313       9.062  28.946  24.713  1.00 12.33      A    C  
ATOM   2303  C   THR   313       7.926  32.344  23.362  1.00 11.63      A    C  
ATOM   2304  O   THR   313       8.047  32.664  22.165  1.00 12.08      A    O  
ATOM   2305  N   GLY   314       7.943  33.223  24.350  1.00 11.01      A    N  
ATOM   2306  CA  GLY   314       8.393  34.583  24.177  1.00 10.25      A    C  
ATOM   2307  C   GLY   314       9.214  34.979  25.387  1.00  9.80      A    C  
ATOM   2308  O   GLY   314       9.208  34.285  26.403  1.00  9.57      A    O  
ATOM   2309  N   ILE   315       9.910  36.110  25.289  1.00  9.50      A    N  
ATOM   2310  CA  ILE   315      10.694  36.606  26.413  1.00  8.89      A    C  
ATOM   2311  CB  ILE   315      12.210  36.391  26.192  1.00  9.19      A    C  
ATOM   2312  CG1 ILE   315      12.471  34.898  26.003  1.00  9.37      A    C  
ATOM   2313  CD1 ILE   315      13.918  34.578  25.628  1.00  8.98      A    C  
ATOM   2314  CG2 ILE   315      13.009  36.900  27.376  1.00  8.33      A    C  
ATOM   2315  C   ILE   315      10.362  38.082  26.642  1.00  9.46      A    C  
ATOM   2316  O   ILE   315      10.390  38.883  25.711  1.00 10.01      A    O  
ATOM   2317  N   ARG   316       9.992  38.406  27.875  1.00  8.59      A    N  
ATOM   2318  CA  ARG   316       9.627  39.775  28.254  1.00  8.99      A    C  
ATOM   2319  CB  ARG   316       8.751  39.735  29.500  1.00  8.88      A    C  
ATOM   2320  CG  ARG   316       7.509  38.861  29.385  1.00  8.68      A    C  
ATOM   2321  CD  ARG   316       6.861  38.746  30.754  1.00  9.10      A    C  
ATOM   2322  NE  ARG   316       5.680  37.885  30.804  1.00  8.89      A    N  
ATOM   2323  CZ  ARG   316       5.706  36.555  30.910  1.00  9.60      A    C  
ATOM   2324  NH1 ARG   316       6.872  35.903  30.925  1.00  8.63      A    N  
ATOM   2325  NH2 ARG   316       4.561  35.876  31.000  1.00  9.36      A    N  
ATOM   2326  C   ARG   316      10.877  40.593  28.594  1.00  9.46      A    C  
ATOM   2327  O   ARG   316      11.767  40.105  29.306  1.00  9.72      A    O  
ATOM   2328  N   PRO   317      10.934  41.846  28.120  1.00  9.31      A    N  
ATOM   2329  CA  PRO   317      12.016  42.739  28.504  1.00  9.89      A    C  
ATOM   2330  CB  PRO   317      11.975  43.827  27.427  1.00  9.59      A    C  
ATOM   2331  CG  PRO   317      10.495  43.886  26.999  1.00  8.43      A    C  
ATOM   2332  CD  PRO   317       9.954  42.483  27.213  1.00  9.11      A    C  
ATOM   2333  C   PRO   317      11.744  43.320  29.878  1.00 11.45      A    C  
ATOM   2334  O   PRO   317      10.881  44.201  30.043  1.00 13.08      A    O  
ATOM   2335  N   LYS   318      12.463  42.824  30.871  1.00 11.27      A    N  
ATOM   2336  CA  LYS   318      12.249  43.260  32.233  1.00 12.41      A    C  
ATOM   2337  CB  LYS   318      12.263  42.066  33.191  1.00 12.01      A    C  
ATOM   2338  CG  LYS   318      11.083  41.103  33.038  1.00 13.09      A    C  
ATOM   2339  CD  LYS   318       9.795  41.777  33.503  1.00 13.40      A    C  
ATOM   2340  CE  LYS   318       8.691  40.776  33.707  1.00 17.34      A    C  
ATOM   2341  NZ  LYS   318       7.410  41.441  34.119  1.00 16.28      A    N  
ATOM   2342  C   LYS   318      13.319  44.268  32.614  1.00 12.36      A    C  
ATOM   2343  O   LYS   318      14.477  44.162  32.192  1.00 13.03      A    O  
ATOM   2344  N   ILE   319      12.920  45.273  33.384  1.00 12.75      A    N  
ATOM   2345  CA  ILE   319      13.884  46.257  33.881  1.00 13.42      A    C  
ATOM   2346  CB  ILE   319      13.723  47.645  33.185  1.00 12.92      A    C  
ATOM   2347  CG1 ILE   319      12.313  48.210  33.413  1.00 12.47      A    C  
ATOM   2348  CD1 ILE   319      12.049  49.541  32.682  1.00 14.80      A    C  
ATOM   2349  CG2 ILE   319      14.100  47.515  31.707  1.00 11.76      A    C  
ATOM   2350  C   ILE   319      13.804  46.382  35.397  1.00 14.59      A    C  
ATOM   2351  O   ILE   319      14.383  47.310  35.989  1.00 15.37      A    O  
ATOM   2352  N   SER   320      13.069  45.449  36.003  1.00 15.21      A    N  
ATOM   2353  CA  SER   320      13.081  45.230  37.452  1.00 16.19      A    C  
ATOM   2354  CB  SER   320      11.847  45.846  38.087  1.00 16.25      A    C  
ATOM   2355  OG  SER   320      10.670  45.381  37.458  1.00 18.25      A    O  
ATOM   2356  C   SER   320      13.129  43.712  37.712  1.00 16.19      A    C  
ATOM   2357  O   SER   320      12.763  42.920  36.849  1.00 15.55      A    O  
ATOM   2358  N   GLY   321      13.602  43.316  38.890  1.00 16.52      A    N  
ATOM   2359  CA  GLY   321      13.882  41.896  39.162  1.00 16.25      A    C  
ATOM   2360  C   GLY   321      12.718  41.085  39.696  1.00 17.17      A    C  
ATOM   2361  O   GLY   321      11.627  41.608  39.944  1.00 16.94      A    O  
ATOM   2362  N   PRO   322      12.945  39.789  39.908  1.00 17.42      A    N  
ATOM   2363  CA  PRO   322      11.844  38.905  40.261  1.00 18.52      A    C  
ATOM   2364  CB  PRO   322      12.500  37.519  40.303  1.00 18.42      A    C  
ATOM   2365  CG  PRO   322      13.974  37.795  40.469  1.00 17.83      A    C  
ATOM   2366  CD  PRO   322      14.204  39.052  39.695  1.00 17.21      A    C  
ATOM   2367  C   PRO   322      11.161  39.229  41.593  1.00 19.93      A    C  
ATOM   2368  O   PRO   322      10.013  38.843  41.782  1.00 20.35      A    O  
ATOM   2369  N   HIS   323      11.829  39.942  42.494  1.00 20.90      A    N  
ATOM   2370  CA  HIS   323      11.185  40.255  43.772  1.00 22.55      A    C  
ATOM   2371  CB  HIS   323      12.080  39.837  44.937  1.00 22.90      A    C  
ATOM   2372  CG  HIS   323      12.218  38.359  45.062  1.00 24.46      A    C  
ATOM   2373  ND1 HIS   323      11.126  37.521  45.140  1.00 26.17      A    N  
ATOM   2374  CE1 HIS   323      11.543  36.271  45.231  1.00 27.59      A    C  
ATOM   2375  NE2 HIS   323      12.865  36.271  45.223  1.00 26.79      A    N  
ATOM   2376  CD2 HIS   323      13.311  37.563  45.110  1.00 24.98      A    C  
ATOM   2377  C   HIS   323      10.749  41.697  43.916  1.00 23.21      A    C  
ATOM   2378  O   HIS   323      10.418  42.147  45.020  1.00 23.62      A    O  
ATOM   2379  N   GLU   324      10.749  42.424  42.806  1.00 23.33      A    N  
ATOM   2380  CA  GLU   324      10.331  43.819  42.824  1.00 24.07      A    C  
ATOM   2381  CB  GLU   324      11.335  44.697  42.077  1.00 24.29      A    C  
ATOM   2382  CG  GLU   324      12.749  44.691  42.607  1.00 25.23      A    C  
ATOM   2383  CD  GLU   324      13.650  45.578  41.777  1.00 27.39      A    C  
ATOM   2384  OE1 GLU   324      14.561  45.049  41.103  1.00 27.69      A    O  
ATOM   2385  OE2 GLU   324      13.426  46.808  41.776  1.00 29.72      A    O  
ATOM   2386  C   GLU   324       8.980  43.948  42.152  1.00 24.06      A    C  
ATOM   2387  O   GLU   324       8.636  43.158  41.274  1.00 24.04      A    O  
ATOM   2388  N   PRO   325       8.210  44.973  42.541  1.00 24.33      A    N  
ATOM   2389  CA  PRO   325       6.961  45.220  41.834  1.00 24.05      A    C  
ATOM   2390  CB  PRO   325       6.363  46.420  42.576  1.00 23.88      A    C  
ATOM   2391  CG  PRO   325       7.544  47.123  43.205  1.00 24.83      A    C  
ATOM   2392  CD  PRO   325       8.617  46.083  43.422  1.00 24.45      A    C  
ATOM   2393  C   PRO   325       7.278  45.555  40.375  1.00 23.37      A    C  
ATOM   2394  O   PRO   325       8.368  46.047  40.082  1.00 23.94      A    O  
ATOM   2395  N   ALA   326       6.351  45.273  39.470  1.00 22.84      A    N  
ATOM   2396  CA  ALA   326       6.627  45.446  38.055  1.00 21.74      A    C  
ATOM   2397  CB  ALA   326       5.493  44.889  37.217  1.00 22.03      A    C  
ATOM   2398  C   ALA   326       6.882  46.916  37.723  1.00 21.03      A    C  
ATOM   2399  O   ALA   326       6.162  47.801  38.194  1.00 21.31      A    O  
ATOM   2400  N   ALA   327       7.918  47.163  36.928  1.00 19.59      A    N  
ATOM   2401  CA  ALA   327       8.256  48.506  36.477  1.00 17.91      A    C  
ATOM   2402  CB  ALA   327       9.683  48.549  35.945  1.00 18.12      A    C  
ATOM   2403  C   ALA   327       7.284  48.951  35.395  1.00 16.70      A    C  
ATOM   2404  O   ALA   327       6.733  48.127  34.673  1.00 16.86      A    O  
ATOM   2405  N   ASP   328       7.086  50.261  35.279  1.00 14.08      A    N  
ATOM   2406  CA  ASP   328       6.267  50.816  34.199  1.00 12.69      A    C  
ATOM   2407  CB  ASP   328       5.993  52.285  34.514  1.00 12.36      A    C  
ATOM   2408  CG  ASP   328       4.814  52.868  33.745  1.00 11.56      A    C  
ATOM   2409  OD1 ASP   328       4.097  52.156  33.009  1.00  9.11      A    O  
ATOM   2410  OD2 ASP   328       4.601  54.092  33.904  1.00 12.11      A    O  
ATOM   2411  C   ASP   328       7.076  50.712  32.908  1.00 11.31      A    C  
ATOM   2412  O   ASP   328       8.271  50.381  32.944  1.00 11.06      A    O  
ATOM   2413  N   PHE   329       6.435  50.966  31.769  1.00  9.85      A    N  
ATOM   2414  CA  PHE   329       7.165  51.233  30.527  1.00  9.04      A    C  
ATOM   2415  CB  PHE   329       6.235  51.797  29.445  1.00  8.38      A    C  
ATOM   2416  CG  PHE   329       5.243  50.814  28.869  1.00  7.77      A    C  
ATOM   2417  CD1 PHE   329       5.485  49.457  28.838  1.00  6.76      A    C  
ATOM   2418  CE1 PHE   329       4.554  48.588  28.282  1.00  8.22      A    C  
ATOM   2419  CZ  PHE   329       3.376  49.084  27.736  1.00  8.19      A    C  
ATOM   2420  CE2 PHE   329       3.129  50.427  27.770  1.00  8.16      A    C  
ATOM   2421  CD2 PHE   329       4.060  51.289  28.330  1.00  6.55      A    C  
ATOM   2422  C   PHE   329       8.139  52.371  30.813  1.00  9.21      A    C  
ATOM   2423  O   PHE   329       7.837  53.265  31.617  1.00  9.11      A    O  
ATOM   2424  N   ALA   330       9.288  52.361  30.140  1.00  9.36      A    N  
ATOM   2425  CA  ALA   330      10.223  53.476  30.229  1.00  9.70      A    C  
ATOM   2426  CB  ALA   330      11.544  53.016  30.846  1.00 10.09      A    C  
ATOM   2427  C   ALA   330      10.446  54.064  28.848  1.00  9.72      A    C  
ATOM   2428  O   ALA   330      10.839  53.360  27.921  1.00 10.20      A    O  
ATOM   2429  N   ILE   331      10.128  55.345  28.688  1.00  9.12      A    N  
ATOM   2430  CA  ILE   331      10.407  56.050  27.438  1.00 10.05      A    C  
ATOM   2431  CB  ILE   331       9.101  56.490  26.710  1.00  9.64      A    C  
ATOM   2432  CG1 ILE   331       8.202  55.268  26.558  1.00  9.54      A    C  
ATOM   2433  CD1 ILE   331       6.788  55.563  26.050  1.00 11.62      A    C  
ATOM   2434  CG2 ILE   331       9.426  57.131  25.363  1.00 10.71      A    C  
ATOM   2435  C   ILE   331      11.314  57.227  27.765  1.00 10.54      A    C  
ATOM   2436  O   ILE   331      10.850  58.291  28.174  1.00 11.51      A    O  
ATOM   2437  N   ALA   332      12.623  57.009  27.657  1.00 10.84      A    N  
ATOM   2438  CA  ALA   332      13.598  57.980  28.152  1.00 11.17      A    C  
ATOM   2439  CB  ALA   332      14.781  57.246  28.838  1.00 10.60      A    C  
ATOM   2440  C   ALA   332      14.107  58.910  27.061  1.00 11.87      A    C  
ATOM   2441  O   ALA   332      14.918  58.521  26.203  1.00 11.49      A    O  
ATOM   2442  N   GLY   333      13.631  60.155  27.101  1.00 13.02      A    N  
ATOM   2443  CA  GLY   333      14.023  61.183  26.144  1.00 14.29      A    C  
ATOM   2444  C   GLY   333      15.041  62.142  26.761  1.00 15.51      A    C  
ATOM   2445  O   GLY   333      15.561  61.891  27.845  1.00 15.60      A    O  
ATOM   2446  N   PRO   334      15.343  63.241  26.061  1.00 16.59      A    N  
ATOM   2447  CA  PRO   334      16.346  64.208  26.526  1.00 17.80      A    C  
ATOM   2448  CB  PRO   334      16.278  65.305  25.463  1.00 17.73      A    C  
ATOM   2449  CG  PRO   334      15.925  64.575  24.229  1.00 17.84      A    C  
ATOM   2450  CD  PRO   334      14.950  63.494  24.668  1.00 16.65      A    C  
ATOM   2451  C   PRO   334      16.105  64.778  27.933  1.00 18.66      A    C  
ATOM   2452  O   PRO   334      17.066  65.110  28.642  1.00 18.90      A    O  
ATOM   2453  N   ALA   335      14.846  64.858  28.356  1.00 19.40      A    N  
ATOM   2454  CA  ALA   335      14.533  65.424  29.665  1.00 20.51      A    C  
ATOM   2455  CB  ALA   335      13.043  65.693  29.788  1.00 20.69      A    C  
ATOM   2456  C   ALA   335      15.004  64.562  30.824  1.00 20.87      A    C  
ATOM   2457  O   ALA   335      15.080  65.028  31.956  1.00 21.60      A    O  
ATOM   2458  N   SER   336      15.310  63.295  30.562  1.00 21.26      A    N  
ATOM   2459  CA  SER   336      15.780  62.454  31.650  1.00 21.23      A    C  
ATOM   2460  CB  SER   336      14.891  61.229  31.844  1.00 22.07      A    C  
ATOM   2461  OG  SER   336      15.031  60.332  30.775  1.00 22.98      A    O  
ATOM   2462  C   SER   336      17.250  62.070  31.532  1.00 20.80      A    C  
ATOM   2463  O   SER   336      17.946  62.003  32.538  1.00 21.80      A    O  
ATOM   2464  N   HIS   337      17.733  61.838  30.318  1.00 19.40      A    N  
ATOM   2465  CA  HIS   337      19.129  61.435  30.158  1.00 18.27      A    C  
ATOM   2466  CB  HIS   337      19.247  60.170  29.305  1.00 17.22      A    C  
ATOM   2467  CG  HIS   337      18.637  60.284  27.943  1.00 16.05      A    C  
ATOM   2468  ND1 HIS   337      18.946  61.299  27.062  1.00 12.91      A    N  
ATOM   2469  CE1 HIS   337      18.270  61.122  25.939  1.00 14.15      A    C  
ATOM   2470  NE2 HIS   337      17.539  60.027  26.059  1.00 11.99      A    N  
ATOM   2471  CD2 HIS   337      17.742  59.489  27.304  1.00 13.08      A    C  
ATOM   2472  C   HIS   337      20.038  62.544  29.623  1.00 17.98      A    C  
ATOM   2473  O   HIS   337      21.265  62.390  29.586  1.00 18.39      A    O  
ATOM   2474  N   GLY   338      19.438  63.655  29.205  1.00 17.54      A    N  
ATOM   2475  CA  GLY   338      20.212  64.820  28.790  1.00 17.18      A    C  
ATOM   2476  C   GLY   338      20.767  64.798  27.381  1.00 17.65      A    C  
ATOM   2477  O   GLY   338      21.467  65.726  26.968  1.00 17.52      A    O  
ATOM   2478  N   VAL   339      20.475  63.743  26.624  1.00 16.83      A    N  
ATOM   2479  CA  VAL   339      21.014  63.639  25.279  1.00 16.57      A    C  
ATOM   2480  CB  VAL   339      21.485  62.209  24.959  1.00 15.97      A    C  
ATOM   2481  CG1 VAL   339      22.114  62.166  23.571  1.00 16.43      A    C  
ATOM   2482  CG2 VAL   339      22.463  61.726  26.015  1.00 16.35      A    C  
ATOM   2483  C   VAL   339      20.024  64.098  24.207  1.00 16.67      A    C  
ATOM   2484  O   VAL   339      19.030  63.424  23.915  1.00 16.40      A    O  
ATOM   2485  N   ALA   340      20.305  65.248  23.600  1.00 16.95      A    N  
ATOM   2486  CA  ALA   340      19.451  65.739  22.533  1.00 16.86      A    C  
ATOM   2487  CB  ALA   340      19.970  67.078  22.003  1.00 17.42      A    C  
ATOM   2488  C   ALA   340      19.325  64.715  21.393  1.00 15.91      A    C  
ATOM   2489  O   ALA   340      20.316  64.135  20.941  1.00 16.33      A    O  
ATOM   2490  N   GLY   341      18.104  64.496  20.927  1.00 14.96      A    N  
ATOM   2491  CA  GLY   341      17.891  63.665  19.740  1.00 13.79      A    C  
ATOM   2492  C   GLY   341      17.781  62.163  19.993  1.00 12.87      A    C  
ATOM   2493  O   GLY   341      17.668  61.381  19.052  1.00 12.89      A    O  
ATOM   2494  N   LEU   342      17.785  61.773  21.258  1.00 12.27      A    N  
ATOM   2495  CA  LEU   342      17.794  60.352  21.629  1.00 11.43      A    C  
ATOM   2496  CB  LEU   342      19.079  60.047  22.405  1.00 11.60      A    C  
ATOM   2497  CG  LEU   342      19.194  58.643  23.006  1.00 10.88      A    C  
ATOM   2498  CD1 LEU   342      19.352  57.606  21.904  1.00 10.65      A    C  
ATOM   2499  CD2 LEU   342      20.336  58.587  24.016  1.00 12.16      A    C  
ATOM   2500  C   LEU   342      16.579  59.938  22.470  1.00 10.74      A    C  
ATOM   2501  O   LEU   342      16.264  60.570  23.478  1.00 10.56      A    O  
ATOM   2502  N   VAL   343      15.904  58.858  22.071  1.00  9.89      A    N  
ATOM   2503  CA  VAL   343      14.918  58.247  22.940  1.00  9.41      A    C  
ATOM   2504  CB  VAL   343      13.479  58.361  22.398  1.00  9.37      A    C  
ATOM   2505  CG1 VAL   343      12.513  57.679  23.376  1.00  9.75      A    C  
ATOM   2506  CG2 VAL   343      13.097  59.851  22.249  1.00 10.33      A    C  
ATOM   2507  C   VAL   343      15.283  56.773  23.089  1.00  9.14      A    C  
ATOM   2508  O   VAL   343      15.464  56.072  22.095  1.00  8.81      A    O  
ATOM   2509  N   ASN   344      15.429  56.336  24.326  1.00  9.10      A    N  
ATOM   2510  CA  ASN   344      15.610  54.911  24.618  1.00  9.14      A    C  
ATOM   2511  CB  ASN   344      16.651  54.718  25.727  1.00  9.42      A    C  
ATOM   2512  CG  ASN   344      18.044  55.142  25.315  1.00  9.13      A    C  
ATOM   2513  OD1 ASN   344      18.576  54.657  24.325  1.00  9.81      A    O  
ATOM   2514  ND2 ASN   344      18.647  56.061  26.079  1.00 10.83      A    N  
ATOM   2515  C   ASN   344      14.281  54.391  25.125  1.00  9.30      A    C  
ATOM   2516  O   ASN   344      13.667  55.005  26.011  1.00  9.51      A    O  
ATOM   2517  N   LEU   345      13.826  53.261  24.601  1.00  9.17      A    N  
ATOM   2518  CA  LEU   345      12.637  52.643  25.164  1.00  8.30      A    C  
ATOM   2519  CB  LEU   345      11.612  52.314  24.088  1.00  8.45      A    C  
ATOM   2520  CG  LEU   345      10.956  53.550  23.454  1.00  7.71      A    C  
ATOM   2521  CD1 LEU   345      11.731  54.027  22.238  1.00  7.74      A    C  
ATOM   2522  CD2 LEU   345       9.519  53.222  23.079  1.00 10.22      A    C  
ATOM   2523  C   LEU   345      13.041  51.379  25.906  1.00  8.26      A    C  
ATOM   2524  O   LEU   345      13.699  50.507  25.325  1.00  8.86      A    O  
ATOM   2525  N   TYR   346      12.675  51.290  27.178  1.00  7.95      A    N  
ATOM   2526  CA  TYR   346      13.024  50.130  27.996  1.00  7.85      A    C  
ATOM   2527  CB  TYR   346      13.941  50.515  29.159  1.00  8.77      A    C  
ATOM   2528  CG  TYR   346      15.152  51.358  28.854  1.00  8.37      A    C  
ATOM   2529  CD1 TYR   346      16.120  50.933  27.964  1.00  7.75      A    C  
ATOM   2530  CE1 TYR   346      17.258  51.695  27.710  1.00  8.11      A    C  
ATOM   2531  CZ  TYR   346      17.440  52.888  28.373  1.00  9.48      A    C  
ATOM   2532  OH  TYR   346      18.565  53.655  28.134  1.00 11.19      A    O  
ATOM   2533  CE2 TYR   346      16.490  53.340  29.271  1.00  9.35      A    C  
ATOM   2534  CD2 TYR   346      15.352  52.564  29.512  1.00  8.85      A    C  
ATOM   2535  C   TYR   346      11.794  49.490  28.617  1.00  7.97      A    C  
ATOM   2536  O   TYR   346      10.821  50.171  28.959  1.00  8.23      A    O  
ATOM   2537  N   GLY   347      11.829  48.171  28.779  1.00  7.68      A    N  
ATOM   2538  CA  GLY   347      10.769  47.465  29.501  1.00  7.05      A    C  
ATOM   2539  C   GLY   347       9.404  47.523  28.830  1.00  6.74      A    C  
ATOM   2540  O   GLY   347       8.374  47.561  29.511  1.00  7.05      A    O  
ATOM   2541  N   ILE   348       9.395  47.483  27.504  1.00  6.52      A    N  
ATOM   2542  CA  ILE   348       8.136  47.526  26.752  1.00  6.03      A    C  
ATOM   2543  CB  ILE   348       8.285  48.276  25.391  1.00  6.46      A    C  
ATOM   2544  CG1 ILE   348       8.997  49.627  25.558  1.00  7.27      A    C  
ATOM   2545  CD1 ILE   348       8.354  50.642  26.522  1.00  9.00      A    C  
ATOM   2546  CG2 ILE   348       6.892  48.424  24.700  1.00  5.84      A    C  
ATOM   2547  C   ILE   348       7.610  46.099  26.584  1.00  5.80      A    C  
ATOM   2548  O   ILE   348       7.639  45.509  25.484  1.00  6.23      A    O  
ATOM   2549  N   GLU   349       7.145  45.554  27.706  1.00  5.60      A    N  
ATOM   2550  CA  GLU   349       6.560  44.224  27.760  1.00  6.88      A    C  
ATOM   2551  CB  GLU   349       6.842  43.567  29.129  1.00  7.34      A    C  
ATOM   2552  CG  GLU   349       6.362  44.402  30.347  1.00  7.51      A    C  
ATOM   2553  CD  GLU   349       6.334  43.614  31.656  1.00 13.20      A    C  
ATOM   2554  OE1 GLU   349       6.539  42.377  31.618  1.00 13.64      A    O  
ATOM   2555  OE2 GLU   349       6.083  44.247  32.718  1.00 11.20      A    O  
ATOM   2556  C   GLU   349       5.065  44.414  27.514  1.00  6.72      A    C  
ATOM   2557  O   GLU   349       4.665  45.454  26.982  1.00  6.59      A    O  
ATOM   2558  N   SER   350       4.238  43.448  27.888  1.00  6.51      A    N  
ATOM   2559  CA  SER   350       2.787  43.679  27.786  1.00  6.93      A    C  
ATOM   2560  CB  SER   350       2.037  42.462  28.298  1.00  7.61      A    C  
ATOM   2561  OG  SER   350       0.649  42.645  28.093  1.00  6.79      A    O  
ATOM   2562  C   SER   350       2.385  44.915  28.609  1.00  6.47      A    C  
ATOM   2563  O   SER   350       2.844  45.095  29.734  1.00  6.32      A    O  
ATOM   2564  N   PRO   351       1.469  45.748  28.091  1.00  6.20      A    N  
ATOM   2565  CA  PRO   351       0.677  45.615  26.860  1.00  6.13      A    C  
ATOM   2566  CB  PRO   351      -0.680  46.177  27.290  1.00  5.56      A    C  
ATOM   2567  CG  PRO   351      -0.291  47.324  28.201  1.00  5.26      A    C  
ATOM   2568  CD  PRO   351       0.923  46.802  28.979  1.00  6.27      A    C  
ATOM   2569  C   PRO   351       1.247  46.469  25.724  1.00  6.66      A    C  
ATOM   2570  O   PRO   351       0.535  47.297  25.141  1.00  6.93      A    O  
ATOM   2571  N   GLY   352       2.528  46.279  25.424  1.00  6.23      A    N  
ATOM   2572  CA  GLY   352       3.221  47.057  24.393  1.00  6.36      A    C  
ATOM   2573  C   GLY   352       2.611  46.989  23.010  1.00  6.31      A    C  
ATOM   2574  O   GLY   352       2.661  47.968  22.254  1.00  7.52      A    O  
ATOM   2575  N   LEU   353       2.054  45.835  22.642  1.00  6.27      A    N  
ATOM   2576  CA  LEU   353       1.455  45.707  21.318  1.00  7.16      A    C  
ATOM   2577  CB  LEU   353       1.095  44.255  21.030  1.00  7.99      A    C  
ATOM   2578  CG  LEU   353       0.158  43.990  19.855  1.00 10.82      A    C  
ATOM   2579  CD1 LEU   353       0.843  44.264  18.547  1.00 16.56      A    C  
ATOM   2580  CD2 LEU   353      -0.289  42.509  19.923  1.00 16.29      A    C  
ATOM   2581  C   LEU   353       0.205  46.589  21.288  1.00  6.93      A    C  
ATOM   2582  O   LEU   353       0.004  47.385  20.364  1.00  6.88      A    O  
ATOM   2583  N   THR   354      -0.602  46.474  22.336  1.00  6.61      A    N  
ATOM   2584  CA  THR   354      -1.850  47.248  22.409  1.00  6.44      A    C  
ATOM   2585  CB  THR   354      -2.632  46.903  23.689  1.00  6.43      A    C  
ATOM   2586  OG1 THR   354      -2.966  45.514  23.667  1.00  6.69      A    O  
ATOM   2587  CG2 THR   354      -3.918  47.731  23.786  1.00  6.28      A    C  
ATOM   2588  C   THR   354      -1.521  48.732  22.408  1.00  6.59      A    C  
ATOM   2589  O   THR   354      -2.214  49.544  21.765  1.00  6.88      A    O  
ATOM   2590  N   ALA   355      -0.462  49.090  23.129  1.00  6.00      A    N  
ATOM   2591  CA  ALA   355      -0.102  50.497  23.329  1.00  6.80      A    C  
ATOM   2592  CB  ALA   355       0.702  50.665  24.630  1.00  7.17      A    C  
ATOM   2593  C   ALA   355       0.702  51.076  22.167  1.00  6.95      A    C  
ATOM   2594  O   ALA   355       1.009  52.271  22.176  1.00  7.73      A    O  
ATOM   2595  N   SER   356       1.078  50.238  21.199  1.00  6.68      A    N  
ATOM   2596  CA  SER   356       2.108  50.626  20.216  1.00  7.20      A    C  
ATOM   2597  CB  SER   356       2.309  49.550  19.137  1.00  7.64      A    C  
ATOM   2598  OG  SER   356       1.102  49.228  18.463  1.00  8.71      A    O  
ATOM   2599  C   SER   356       1.936  52.014  19.569  1.00  7.23      A    C  
ATOM   2600  O   SER   356       2.903  52.768  19.483  1.00  7.57      A    O  
ATOM   2601  N   LEU   357       0.734  52.340  19.085  1.00  7.09      A    N  
ATOM   2602  CA  LEU   357       0.583  53.618  18.388  1.00  7.54      A    C  
ATOM   2603  CB  LEU   357      -0.721  53.673  17.576  1.00  8.40      A    C  
ATOM   2604  CG  LEU   357      -0.855  52.660  16.434  1.00  6.87      A    C  
ATOM   2605  CD1 LEU   357       0.102  52.998  15.300  1.00  8.88      A    C  
ATOM   2606  CD2 LEU   357      -2.316  52.682  15.929  1.00  9.76      A    C  
ATOM   2607  C   LEU   357       0.663  54.774  19.379  1.00  8.05      A    C  
ATOM   2608  O   LEU   357       1.137  55.866  19.034  1.00  8.30      A    O  
ATOM   2609  N   ALA   358       0.199  54.545  20.604  1.00  7.75      A    N  
ATOM   2610  CA  ALA   358       0.332  55.540  21.651  1.00  7.72      A    C  
ATOM   2611  CB  ALA   358      -0.617  55.235  22.814  1.00  8.67      A    C  
ATOM   2612  C   ALA   358       1.774  55.692  22.127  1.00  8.33      A    C  
ATOM   2613  O   ALA   358       2.228  56.795  22.417  1.00  8.54      A    O  
ATOM   2614  N   ILE   359       2.510  54.587  22.163  1.00  6.73      A    N  
ATOM   2615  CA  ILE   359       3.923  54.675  22.489  1.00  6.96      A    C  
ATOM   2616  CB  ILE   359       4.563  53.285  22.609  1.00  6.82      A    C  
ATOM   2617  CG1 ILE   359       4.046  52.571  23.861  1.00  6.31      A    C  
ATOM   2618  CD1 ILE   359       4.282  51.015  23.857  1.00  6.58      A    C  
ATOM   2619  CG2 ILE   359       6.101  53.411  22.632  1.00  6.91      A    C  
ATOM   2620  C   ILE   359       4.661  55.508  21.424  1.00  6.55      A    C  
ATOM   2621  O   ILE   359       5.545  56.303  21.766  1.00  6.92      A    O  
ATOM   2622  N   ALA   360       4.304  55.328  20.155  1.00  7.28      A    N  
ATOM   2623  CA  ALA   360       4.848  56.173  19.077  1.00  8.37      A    C  
ATOM   2624  CB  ALA   360       4.310  55.746  17.727  1.00  9.00      A    C  
ATOM   2625  C   ALA   360       4.545  57.654  19.335  1.00  9.08      A    C  
ATOM   2626  O   ALA   360       5.440  58.502  19.249  1.00  9.65      A    O  
ATOM   2627  N   GLU   361       3.298  57.979  19.666  1.00  9.42      A    N  
ATOM   2628  CA  GLU   361       2.973  59.374  19.992  1.00 10.25      A    C  
ATOM   2629  CB  GLU   361       1.509  59.498  20.414  1.00 10.25      A    C  
ATOM   2630  CG  GLU   361       0.531  59.274  19.276  1.00 11.45      A    C  
ATOM   2631  CD  GLU   361      -0.930  59.463  19.712  1.00 14.44      A    C  
ATOM   2632  OE1 GLU   361      -1.268  59.103  20.852  1.00 15.38      A    O  
ATOM   2633  OE2 GLU   361      -1.737  59.988  18.903  1.00 14.41      A    O  
ATOM   2634  C   GLU   361       3.852  59.908  21.114  1.00 10.18      A    C  
ATOM   2635  O   GLU   361       4.403  61.010  21.021  1.00 10.62      A    O  
ATOM   2636  N   GLU   362       3.984  59.117  22.175  1.00  9.87      A    N  
ATOM   2637  CA  GLU   362       4.710  59.542  23.368  1.00 10.55      A    C  
ATOM   2638  CB  GLU   362       4.427  58.588  24.539  1.00 10.82      A    C  
ATOM   2639  CG  GLU   362       4.983  59.077  25.887  1.00 12.80      A    C  
ATOM   2640  CD  GLU   362       4.281  60.333  26.433  1.00 15.84      A    C  
ATOM   2641  OE1 GLU   362       4.832  60.978  27.346  1.00 18.23      A    O  
ATOM   2642  OE2 GLU   362       3.172  60.661  25.981  1.00 15.97      A    O  
ATOM   2643  C   GLU   362       6.216  59.691  23.116  1.00 10.27      A    C  
ATOM   2644  O   GLU   362       6.875  60.577  23.677  1.00  9.43      A    O  
ATOM   2645  N   THR   363       6.759  58.832  22.261  1.00 10.60      A    N  
ATOM   2646  CA  THR   363       8.173  58.925  21.908  1.00 11.59      A    C  
ATOM   2647  CB  THR   363       8.630  57.753  21.039  1.00 12.17      A    C  
ATOM   2648  OG1 THR   363       7.900  57.757  19.815  1.00 19.07      A    O  
ATOM   2649  CG2 THR   363       8.370  56.466  21.742  1.00  7.00      A    C  
ATOM   2650  C   THR   363       8.461  60.226  21.185  1.00 12.00      A    C  
ATOM   2651  O   THR   363       9.432  60.916  21.505  1.00 12.55      A    O  
ATOM   2652  N   LEU   364       7.611  60.579  20.231  1.00 12.00      A    N  
ATOM   2653  CA  LEU   364       7.800  61.838  19.521  1.00 13.53      A    C  
ATOM   2654  CB  LEU   364       6.855  61.939  18.322  1.00 13.46      A    C  
ATOM   2655  CG  LEU   364       7.391  61.374  17.002  1.00 13.50      A    C  
ATOM   2656  CD1 LEU   364       6.438  61.706  15.872  1.00 14.21      A    C  
ATOM   2657  CD2 LEU   364       7.620  59.850  17.065  1.00 13.39      A    C  
ATOM   2658  C   LEU   364       7.650  63.028  20.473  1.00 14.28      A    C  
ATOM   2659  O   LEU   364       8.400  63.993  20.387  1.00 14.05      A    O  
ATOM   2660  N   ALA   365       6.701  62.940  21.399  1.00 14.54      A    N  
ATOM   2661  CA  ALA   365       6.456  64.017  22.362  1.00 15.78      A    C  
ATOM   2662  CB  ALA   365       5.235  63.692  23.210  1.00 15.20      A    C  
ATOM   2663  C   ALA   365       7.659  64.240  23.260  1.00 16.57      A    C  
ATOM   2664  O   ALA   365       7.978  65.380  23.628  1.00 17.17      A    O  
ATOM   2665  N   ARG   366       8.301  63.148  23.646  1.00 16.44      A    N  
ATOM   2666  CA  ARG   366       9.441  63.150  24.544  1.00 17.63      A    C  
ATOM   2667  CB  ARG   366       9.579  61.799  25.280  1.00 17.68      A    C  
ATOM   2668  CG  ARG   366       8.565  61.657  26.343  1.00 18.23      A    C  
ATOM   2669  CD  ARG   366       8.601  60.446  27.266  1.00 21.06      A    C  
ATOM   2670  NE  ARG   366       7.442  60.466  28.144  1.00 25.26      A    N  
ATOM   2671  CZ  ARG   366       7.358  59.790  29.262  1.00 22.92      A    C  
ATOM   2672  NH1 ARG   366       8.347  59.006  29.599  1.00 28.39      A    N  
ATOM   2673  NH2 ARG   366       6.331  59.852  30.060  1.00 22.15      A    N  
ATOM   2674  C   ARG   366      10.719  63.557  23.788  1.00 18.21      A    C  
ATOM   2675  O   ARG   366      11.569  64.197  24.315  1.00 18.20      A    O  
ATOM   2676  N   LEU   367      10.815  63.138  22.551  1.00 18.40      A    N  
ATOM   2677  CA  LEU   367      11.953  63.482  21.718  1.00 19.46      A    C  
ATOM   2678  CB  LEU   367      11.813  62.827  20.343  1.00 19.34      A    C  
ATOM   2679  CG  LEU   367      12.834  63.151  19.259  1.00 18.92      A    C  
ATOM   2680  CD1 LEU   367      12.482  62.407  17.961  1.00 17.71      A    C  
ATOM   2681  CD2 LEU   367      14.232  62.824  19.732  1.00 19.16      A    C  
ATOM   2682  C   LEU   367      12.005  65.005  21.610  1.00 20.53      A    C  
ATOM   2683  O   LEU   367      13.077  65.601  21.550  1.00 20.59      A    O  
ATOM   2684  N   ALA   368      10.835  65.630  21.629  1.00 21.55      A    N  
ATOM   2685  CA  ALA   368      10.751  67.091  21.637  1.00 22.12      A    C  
ATOM   2686  CB  ALA   368       9.365  67.529  21.211  1.00 22.49      A    C  
ATOM   2687  C   ALA   368      11.095  67.663  23.015  1.00 22.64      A    C  
ATOM   2688  O   ALA   368      11.340  68.879  23.162  1.00 23.74      A    O  
END
