
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  364 ( 2846),  selected  364 , name 1ng3_A
# Molecule2: number of CA atoms  366 ( 2688),  selected  366 , name T0490.pdb
# PARAMETERS: 1ng3_A.T0490.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    R     3_A      T       3           #
LGA    H     4_A      D       4          3.151
LGA    Y     5_A      I       5          1.761
LGA    E     6_A      D       6          1.168
LGA    A     7_A      C       7          0.740
LGA    V     8_A      I       8          0.562
LGA    V     9_A      V       9          0.568
LGA    I    10_A      I      10          0.567
LGA    G    11_A      G      11          1.083
LGA    G    12_A      A      12          1.542
LGA    G    13_A      G      13          1.344
LGA    I    14_A      V      14          1.233
LGA    I    15_A      V      15          1.086
LGA    G    16_A      G      16          0.606
LGA    S    17_A      L      17          1.293
LGA    A    18_A      A      18          1.072
LGA    I    19_A      I      19          0.849
LGA    A    20_A      A      20          1.020
LGA    Y    21_A      R      21          1.208
LGA    Y    22_A      A      22          1.275
LGA    L    23_A      L      23          1.282
LGA    A    24_A      A      24          1.649
LGA    K    25_A      A      25          1.543
LGA    E    26_A      G      26          1.445
LGA    N    27_A      G      27          2.104
LGA    K    28_A      H      28          1.122
LGA    N    29_A      E      29          0.316
LGA    T    30_A      V      30          0.383
LGA    A    31_A      L      31          0.890
LGA    L    32_A      V      32          0.738
LGA    F    33_A      A      33          0.765
LGA    E    34_A      E      34          0.805
LGA    S    35_A      A      35          0.793
LGA    G    36_A      A      36          0.407
LGA    T    37_A      E      37          3.831
LGA    -       -      G      38           -
LGA    M    38_A      I      39          1.305
LGA    G    39_A      G      40          1.170
LGA    G    40_A      T      41          0.840
LGA    R    41_A      G      42          1.495
LGA    T    42_A      T      43          1.468
LGA    T    43_A      S      44          1.424
LGA    S    44_A      S      45          0.819
LGA    A    45_A      R      46          0.928
LGA    A    46_A      N      47          0.401
LGA    A    47_A      S      48          0.225
LGA    G    48_A      E      49          1.627
LGA    M    49_A      V      50          1.652
LGA    L    50_A      I      51          2.550
LGA    G    51_A      H      52          2.600
LGA    A    52_A      A      53          3.794
LGA    H    53_A      G      54          3.603
LGA    A    54_A      I      55          4.427
LGA    E    55_A      Y      56          2.778
LGA    C    56_A      Y      57          3.783
LGA    E    57_A      -       -           -
LGA    E    58_A      P      58          3.620
LGA    R    59_A      A      59          2.549
LGA    D    60_A      D      60          2.959
LGA    A    61_A      S      61          3.186
LGA    F    62_A      L      62          3.587
LGA    -       -      K      63           -
LGA    F    63_A      A      64          2.063
LGA    D    64_A      R      65          2.796
LGA    F    65_A      L      66          2.969
LGA    A    66_A      C      67          2.186
LGA    M    67_A      V      68          1.573
LGA    H    68_A      R      69          1.682
LGA    S    69_A      G      70          1.777
LGA    Q    70_A      K      71          1.747
LGA    R    71_A      H      72          1.888
LGA    L    72_A      L      73          1.627
LGA    Y    73_A      L      74          1.595
LGA    K    74_A      Y      75          2.531
LGA    G    75_A      E      76          1.077
LGA    L    76_A      Y      77          1.107
LGA    G    77_A      C      78          0.912
LGA    E    78_A      A      79          3.254
LGA    E    79_A      A      80          3.643
LGA    L    80_A      R      81          3.962
LGA    Y    81_A      G      82          3.952
LGA    A    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    S    84_A      -       -           -
LGA    G    85_A      -       -           -
LGA    V    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    I    88_A      V      83          3.630
LGA    R    89_A      P      84          2.569
LGA    Q    90_A      H      85          1.249
LGA    H    91_A      Q      86          1.528
LGA    N    92_A      R      87          0.705
LGA    G    93_A      L      88          1.143
LGA    G    94_A      G      89          0.787
LGA    M    95_A      K      90          0.683
LGA    F    96_A      L      91          0.138
LGA    K    97_A      I      92          0.505
LGA    L    98_A      V      93          0.659
LGA    A    99_A      A      94          0.434
LGA    F   100_A      T      95          1.145
LGA    S   101_A      S      96          1.810
LGA    E   102_A      D      97          2.435
LGA    E   103_A      A      98          2.644
LGA    D   104_A      E      99          1.549
LGA    V   105_A      A     100          1.739
LGA    L   106_A      S     101          2.089
LGA    Q   107_A      Q     102          1.785
LGA    L   108_A      L     103          1.788
LGA    R   109_A      D     104          1.569
LGA    Q   110_A      S     105          1.247
LGA    M   111_A      I     106          3.512
LGA    D   112_A      A     107          3.443
LGA    D   113_A      R     108          4.354
LGA    -       -      R     109           -
LGA    L   114_A      A     110          4.873
LGA    -       -      G     111           -
LGA    -       -      A     112           -
LGA    -       -      N     113           -
LGA    -       -      G     114           -
LGA    -       -      V     115           -
LGA    D   115_A      D     116          0.850
LGA    S   116_A      D     117          0.399
LGA    V   117_A      L     118          0.715
LGA    S   118_A      Q     119          1.475
LGA    W   119_A      H     120          0.576
LGA    Y   120_A      I     121          1.212
LGA    S   121_A      D     122          0.643
LGA    K   122_A      G     123          0.253
LGA    E   123_A      A     124          0.388
LGA    E   124_A      A     125          0.424
LGA    V   125_A      A     126          0.443
LGA    L   126_A      R     127          0.422
LGA    E   127_A      R     128          0.251
LGA    K   128_A      L     129          0.751
LGA    E   129_A      E     130          0.370
LGA    P   130_A      P     131          0.364
LGA    Y   131_A      A     132          0.398
LGA    A   132_A      L     133          1.283
LGA    S   133_A      H     134          2.609
LGA    G   134_A      -       -           -
LGA    D   135_A      -       -           -
LGA    I   136_A      C     135          1.452
LGA    F   137_A      T     136          0.867
LGA    G   138_A      A     137          1.337
LGA    A   139_A      A     138          0.744
LGA    S   140_A      L     139          0.602
LGA    F   141_A      V     140          0.650
LGA    I   142_A      S     141          0.994
LGA    Q   143_A      P     142          1.320
LGA    D   144_A      S     143          1.526
LGA    D   145_A      T     144          2.035
LGA    V   146_A      G     145          1.660
LGA    H   147_A      I     146          1.892
LGA    V   148_A      V     147          1.364
LGA    E   149_A      D     148          2.510
LGA    P   150_A      S     149          2.327
LGA    Y   151_A      H     150          2.561
LGA    F   152_A      A     151          2.385
LGA    V   153_A      L     152          1.549
LGA    C   154_A      M     153          1.902
LGA    K   155_A      L     154          2.404
LGA    A   156_A      A     155          2.013
LGA    Y   157_A      Y     156          1.341
LGA    V   158_A      Q     157          1.704
LGA    K   159_A      G     158          2.627
LGA    A   160_A      D     159          2.474
LGA    A   161_A      A     160          1.754
LGA    K   162_A      E     161          1.974
LGA    M   163_A      S     162          2.646
LGA    L   164_A      D     163          2.484
LGA    G   165_A      G     164          1.566
LGA    A   166_A      A     165          1.030
LGA    E   167_A      Q     166          0.573
LGA    I   168_A      L     167          0.678
LGA    F   169_A      V     168          1.048
LGA    E   170_A      F     169          1.249
LGA    H   171_A      H     170          1.107
LGA    T   172_A      T     171          0.874
LGA    P   173_A      P     172          0.616
LGA    V   174_A      L     173          0.715
LGA    L   175_A      I     174          0.735
LGA    H   176_A      A     175          1.298
LGA    V   177_A      G     176          2.036
LGA    E   178_A      R     177          1.585
LGA    R   179_A      V     178          1.266
LGA    D   180_A      R     179          1.548
LGA    -       -      P     180           -
LGA    G   181_A      E     181          3.783
LGA    E   182_A      G     182          2.691
LGA    A   183_A      G     183          1.727
LGA    L   184_A      F     184          0.905
LGA    F   185_A      E     185          1.359
LGA    I   186_A      L     186          1.714
LGA    K   187_A      D     187          1.445
LGA    T   188_A      F     188          0.832
LGA    P   189_A      G     189          2.197
LGA    -       -      G     190           -
LGA    -       -      A     191           -
LGA    -       -      E     192           -
LGA    S   190_A      P     193          3.411
LGA    G   191_A      M     194          1.315
LGA    D   192_A      T     195          1.532
LGA    V   193_A      L     196          1.320
LGA    W   194_A      S     197          1.308
LGA    A   195_A      C     198          1.038
LGA    N   196_A      R     199          0.882
LGA    H   197_A      V     200          0.541
LGA    V   198_A      L     201          0.353
LGA    V   199_A      I     202          0.451
LGA    V   200_A      N     203          0.501
LGA    A   201_A      A     204          0.661
LGA    S   202_A      A     205          0.755
LGA    G   203_A      G     206          0.677
LGA    V   204_A      L     207          1.205
LGA    W   205_A      H     208          0.914
LGA    S   206_A      A     209          1.127
LGA    G   207_A      P     210          1.951
LGA    M   208_A      G     211          1.917
LGA    F   209_A      L     212          2.263
LGA    F   210_A      A     213          2.265
LGA    K   211_A      R     214          1.616
LGA    Q   212_A      R     215          2.804
LGA    L   213_A      I     216          4.032
LGA    -       -      E     217           -
LGA    -       -      G     218           -
LGA    -       -      I     219           -
LGA    G   214_A      P     220          2.742
LGA    L   215_A      R     221          2.658
LGA    -       -      D     222           -
LGA    -       -      S     223           -
LGA    N   216_A      I     224          3.155
LGA    N   217_A      P     225          1.449
LGA    A   218_A      P     226          1.255
LGA    F   219_A      E     227          1.749
LGA    L   220_A      Y     228          0.536
LGA    P   221_A      L     229          0.635
LGA    V   222_A      C     230          0.471
LGA    K   223_A      K     231          0.502
LGA    G   224_A      G     232          0.470
LGA    E   225_A      S     233          0.644
LGA    C   226_A      Y     234          0.644
LGA    L   227_A      F     235          1.652
LGA    S   228_A      T     236          1.809
LGA    V   229_A      L     237          2.037
LGA    W   230_A      A     238          2.900
LGA    N   231_A      G     239          3.599
LGA    D   232_A      R     240          2.942
LGA    D   233_A      A     241           #
LGA    I   234_A      -       -           -
LGA    P   235_A      P     242          5.051
LGA    L   236_A      F     243          2.142
LGA    T   237_A      S     244          1.667
LGA    K   238_A      R     245          0.900
LGA    T   239_A      L     246          0.356
LGA    L   240_A      I     247          0.475
LGA    Y   241_A      Y     248          0.520
LGA    H   242_A      P     249          1.174
LGA    -       -      V     250           -
LGA    -       -      P     251           -
LGA    -       -      Q     252           -
LGA    D   243_A      H     253          4.348
LGA    -       -      A     254           -
LGA    -       -      G     255           -
LGA    -       -      L     256           -
LGA    H   244_A      G     257          4.565
LGA    C   245_A      V     258          2.568
LGA    Y   246_A      H     259          0.862
LGA    I   247_A      L     260          0.936
LGA    V   248_A      T     261          1.245
LGA    P   249_A      L     262          2.077
LGA    R   250_A      D     263          2.204
LGA    K   251_A      L     264          2.635
LGA    S   252_A      G     265          0.605
LGA    G   253_A      G     266          2.372
LGA    R   254_A      Q     267          1.196
LGA    L   255_A      A     268          0.925
LGA    V   256_A      K     269          2.196
LGA    V   257_A      F     270          1.408
LGA    G   258_A      G     271          0.504
LGA    A   259_A      P     272          1.235
LGA    T   260_A      D     273          1.269
LGA    M   261_A      T     274          0.726
LGA    K   262_A      E     275          0.943
LGA    P   263_A      W     276          1.559
LGA    G   264_A      I     277          2.780
LGA    D   265_A      A     278          4.154
LGA    W   266_A      T     279          2.869
LGA    -       -      E     280           -
LGA    S   267_A      D     281          1.739
LGA    E   268_A      Y     282          1.027
LGA    T   269_A      T     283          1.652
LGA    P   270_A      L     284          2.027
LGA    D   271_A      D     285          1.608
LGA    L   272_A      P     286          3.536
LGA    G   273_A      R     287          3.481
LGA    G   274_A      R     288          1.802
LGA    L   275_A      A     289          2.405
LGA    E   276_A      D     290          1.994
LGA    S   277_A      V     291          2.465
LGA    V   278_A      F     292          3.071
LGA    M   279_A      Y     293          4.298
LGA    K   280_A      A     294          4.137
LGA    K   281_A      A     295          2.634
LGA    A   282_A      V     296          2.760
LGA    K   283_A      R     297          3.390
LGA    T   284_A      S     298          2.999
LGA    M   285_A      Y     299          2.849
LGA    L   286_A      W     300          2.329
LGA    P   287_A      P     301          3.144
LGA    P   288_A      A     302          3.578
LGA    I   289_A      L     303          3.848
LGA    Q   290_A      P     304          2.401
LGA    N   291_A      D     305          6.672
LGA    M   292_A      G     306           -
LGA    K   293_A      A     307          5.800
LGA    V   294_A      L     308          5.541
LGA    D   295_A      A     309          5.709
LGA    R   296_A      P     310          4.609
LGA    F   297_A      G     311          1.437
LGA    W   298_A      Y     312          1.066
LGA    A   299_A      T     313          0.776
LGA    G   300_A      G     314          1.042
LGA    L   301_A      I     315          0.852
LGA    R   302_A      R     316          0.337
LGA    P   303_A      P     317          0.420
LGA    G   304_A      K     318          0.596
LGA    T   305_A      I     319          1.050
LGA    K   306_A      S     320          1.933
LGA    -       -      G     321           -
LGA    -       -      P     322           -
LGA    -       -      H     323           -
LGA    -       -      E     324           -
LGA    D   307_A      P     325           #
LGA    G   308_A      A     326          3.129
LGA    K   309_A      A     327          3.007
LGA    -       -      D     328           -
LGA    P   310_A      F     329          1.794
LGA    Y   311_A      A     330          1.451
LGA    I   312_A      I     331          0.556
LGA    G   313_A      A     332          2.761
LGA    R   314_A      G     333          0.865
LGA    H   315_A      P     334          4.237
LGA    -       -      A     335           -
LGA    -       -      S     336           -
LGA    P   316_A      H     337          1.332
LGA    E   317_A      G     338          1.590
LGA    D   318_A      V     339          0.790
LGA    S   319_A      A     340          2.370
LGA    R   320_A      G     341          0.861
LGA    I   321_A      L     342          0.880
LGA    L   322_A      V     343          0.432
LGA    F   323_A      N     344          1.170
LGA    A   324_A      L     345          1.630
LGA    A   325_A      Y     346          2.389
LGA    G   326_A      G     347          0.691
LGA    H   327_A      I     348          1.858
LGA    F   328_A      E     349          2.828
LGA    R   329_A      S     350          2.506
LGA    N   330_A      P     351          1.624
LGA    G   331_A      G     352          1.688
LGA    I   332_A      L     353          1.147
LGA    L   333_A      T     354          1.670
LGA    L   334_A      A     355          1.676
LGA    A   335_A      S     356          1.055
LGA    P   336_A      L     357          1.399
LGA    A   337_A      A     358          1.049
LGA    T   338_A      I     359          0.719
LGA    G   339_A      A     360          1.171
LGA    A   340_A      E     361          1.490
LGA    L   341_A      E     362          1.257
LGA    I   342_A      T     363          1.225
LGA    S   343_A      L     364          2.745
LGA    D   344_A      A     365          3.583
LGA    L   345_A      R     366          3.580
LGA    I   346_A      L     367          3.787
LGA    M   347_A      A     368           #
LGA    N   348_A      -       -           -
LGA    K   349_A      -       -           -
LGA    E   350_A      -       -           -
LGA    V   351_A      -       -           -
LGA    N   352_A      -       -           -
LGA    Q   353_A      -       -           -
LGA    D   354_A      -       -           -
LGA    W   355_A      -       -           -
LGA    L   356_A      -       -           -
LGA    H   357_A      -       -           -
LGA    A   358_A      -       -           -
LGA    F   359_A      -       -           -
LGA    R   360_A      -       -           -
LGA    I   361_A      -       -           -
LGA    D   362_A      -       -           -
LGA    R   363_A      -       -           -
LGA    K   364_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  364  366    5.0    330    2.11    16.06     71.382    14.937

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.693740 * X  +  -0.654792 * Y  +   0.299952 * Z  +  45.915878
  Y_new =  -0.275044 * X  +  -0.144045 * Y  +  -0.950580 * Z  + 123.334785
  Z_new =   0.665639 * X  +  -0.741955 * Y  +  -0.080167 * Z  +  37.473328 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.678426    1.463166  [ DEG:   -96.1667     83.8333 ]
  Theta =  -0.728350   -2.413243  [ DEG:   -41.7314   -138.2686 ]
  Phi   =  -2.764137    0.377455  [ DEG:  -158.3734     21.6266 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ng3_A                                        
REMARK     2: T0490.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ng3_A.T0490.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  364  366   5.0  330   2.11   16.06  71.382
REMARK  ---------------------------------------------------------- 
MOLECULE 1ng3_A
HEADER    OXIDOREDUCTASE                          16-DEC-02   1NG3              
TITLE     COMPLEX OF THIO (GLYCINE OXIDASE) WITH ACETYL-GLYCINE                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLYCINE OXIDASE;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.5.3.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GOXB;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET16-B                                   
KEYWDS    FLAVOPROTEIN, OXIDASE                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.C.SETTEMBRE,P.C.DORRESTEIN,J.PARK,A.AUGUSTINE,T.P.BEGLEY,           
AUTHOR   2 S.E.EALICK                                                           
REVDAT   2   03-FEB-04 1NG3    1       REMARK                                   
REVDAT   1   08-APR-03 1NG3    0                                                
JRNL        AUTH   E.C.SETTEMBRE,P.C.DORRESTEIN,J.PARK,A.AUGUSTINE,             
JRNL        AUTH 2 T.P.BEGLEY,S.E.EALICK                                        
JRNL        TITL   STRUCTURAL AND MECHANISTIC STUDIES ON THIO, A                
JRNL        TITL 2 GLYCINE OXIDASE ESSENTIAL FOR THIAMIN BIOSYNTHESIS           
JRNL        TITL 3 IN BACILLUS SUBTILIS                                         
JRNL        REF    BIOCHEMISTRY                  V.  42  2971 2003              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  1NG3 A    1   369  UNP    O31616   GLOX_BACSU       1    369             
DBREF  1NG3 B    1   369  UNP    O31616   GLOX_BACSU       1    369             
SEQRES   1 A  390  MET GLY HIS HIS HIS HIS HIS HIS HIS HIS HIS HIS SER          
SEQRES   2 A  390  SER GLY HIS ILE GLU GLY ARG HIS MET LYS ARG HIS TYR          
SEQRES   3 A  390  GLU ALA VAL VAL ILE GLY GLY GLY ILE ILE GLY SER ALA          
SEQRES   4 A  390  ILE ALA TYR TYR LEU ALA LYS GLU ASN LYS ASN THR ALA          
SEQRES   5 A  390  LEU PHE GLU SER GLY THR MET GLY GLY ARG THR THR SER          
SEQRES   6 A  390  ALA ALA ALA GLY MET LEU GLY ALA HIS ALA GLU CYS GLU          
SEQRES   7 A  390  GLU ARG ASP ALA PHE PHE ASP PHE ALA MET HIS SER GLN          
SEQRES   8 A  390  ARG LEU TYR LYS GLY LEU GLY GLU GLU LEU TYR ALA LEU          
SEQRES   9 A  390  SER GLY VAL ASP ILE ARG GLN HIS ASN GLY GLY MET PHE          
SEQRES  10 A  390  LYS LEU ALA PHE SER GLU GLU ASP VAL LEU GLN LEU ARG          
SEQRES  11 A  390  GLN MET ASP ASP LEU ASP SER VAL SER TRP TYR SER LYS          
SEQRES  12 A  390  GLU GLU VAL LEU GLU LYS GLU PRO TYR ALA SER GLY ASP          
SEQRES  13 A  390  ILE PHE GLY ALA SER PHE ILE GLN ASP ASP VAL HIS VAL          
SEQRES  14 A  390  GLU PRO TYR PHE VAL CYS LYS ALA TYR VAL LYS ALA ALA          
SEQRES  15 A  390  LYS MET LEU GLY ALA GLU ILE PHE GLU HIS THR PRO VAL          
SEQRES  16 A  390  LEU HIS VAL GLU ARG ASP GLY GLU ALA LEU PHE ILE LYS          
SEQRES  17 A  390  THR PRO SER GLY ASP VAL TRP ALA ASN HIS VAL VAL VAL          
SEQRES  18 A  390  ALA SER GLY VAL TRP SER GLY MET PHE PHE LYS GLN LEU          
SEQRES  19 A  390  GLY LEU ASN ASN ALA PHE LEU PRO VAL LYS GLY GLU CYS          
SEQRES  20 A  390  LEU SER VAL TRP ASN ASP ASP ILE PRO LEU THR LYS THR          
SEQRES  21 A  390  LEU TYR HIS ASP HIS CYS TYR ILE VAL PRO ARG LYS SER          
SEQRES  22 A  390  GLY ARG LEU VAL VAL GLY ALA THR MET LYS PRO GLY ASP          
SEQRES  23 A  390  TRP SER GLU THR PRO ASP LEU GLY GLY LEU GLU SER VAL          
SEQRES  24 A  390  MET LYS LYS ALA LYS THR MET LEU PRO PRO ILE GLN ASN          
SEQRES  25 A  390  MET LYS VAL ASP ARG PHE TRP ALA GLY LEU ARG PRO GLY          
SEQRES  26 A  390  THR LYS ASP GLY LYS PRO TYR ILE GLY ARG HIS PRO GLU          
SEQRES  27 A  390  ASP SER ARG ILE LEU PHE ALA ALA GLY HIS PHE ARG ASN          
SEQRES  28 A  390  GLY ILE LEU LEU ALA PRO ALA THR GLY ALA LEU ILE SER          
SEQRES  29 A  390  ASP LEU ILE MET ASN LYS GLU VAL ASN GLN ASP TRP LEU          
SEQRES  30 A  390  HIS ALA PHE ARG ILE ASP ARG LYS GLU ALA VAL GLN ILE          
SEQRES   1 B  390  MET GLY HIS HIS HIS HIS HIS HIS HIS HIS HIS HIS SER          
SEQRES   2 B  390  SER GLY HIS ILE GLU GLY ARG HIS MET LYS ARG HIS TYR          
SEQRES   3 B  390  GLU ALA VAL VAL ILE GLY GLY GLY ILE ILE GLY SER ALA          
SEQRES   4 B  390  ILE ALA TYR TYR LEU ALA LYS GLU ASN LYS ASN THR ALA          
SEQRES   5 B  390  LEU PHE GLU SER GLY THR MET GLY GLY ARG THR THR SER          
SEQRES   6 B  390  ALA ALA ALA GLY MET LEU GLY ALA HIS ALA GLU CYS GLU          
SEQRES   7 B  390  GLU ARG ASP ALA PHE PHE ASP PHE ALA MET HIS SER GLN          
SEQRES   8 B  390  ARG LEU TYR LYS GLY LEU GLY GLU GLU LEU TYR ALA LEU          
SEQRES   9 B  390  SER GLY VAL ASP ILE ARG GLN HIS ASN GLY GLY MET PHE          
SEQRES  10 B  390  LYS LEU ALA PHE SER GLU GLU ASP VAL LEU GLN LEU ARG          
SEQRES  11 B  390  GLN MET ASP ASP LEU ASP SER VAL SER TRP TYR SER LYS          
SEQRES  12 B  390  GLU GLU VAL LEU GLU LYS GLU PRO TYR ALA SER GLY ASP          
SEQRES  13 B  390  ILE PHE GLY ALA SER PHE ILE GLN ASP ASP VAL HIS VAL          
SEQRES  14 B  390  GLU PRO TYR PHE VAL CYS LYS ALA TYR VAL LYS ALA ALA          
SEQRES  15 B  390  LYS MET LEU GLY ALA GLU ILE PHE GLU HIS THR PRO VAL          
SEQRES  16 B  390  LEU HIS VAL GLU ARG ASP GLY GLU ALA LEU PHE ILE LYS          
SEQRES  17 B  390  THR PRO SER GLY ASP VAL TRP ALA ASN HIS VAL VAL VAL          
SEQRES  18 B  390  ALA SER GLY VAL TRP SER GLY MET PHE PHE LYS GLN LEU          
SEQRES  19 B  390  GLY LEU ASN ASN ALA PHE LEU PRO VAL LYS GLY GLU CYS          
SEQRES  20 B  390  LEU SER VAL TRP ASN ASP ASP ILE PRO LEU THR LYS THR          
SEQRES  21 B  390  LEU TYR HIS ASP HIS CYS TYR ILE VAL PRO ARG LYS SER          
SEQRES  22 B  390  GLY ARG LEU VAL VAL GLY ALA THR MET LYS PRO GLY ASP          
SEQRES  23 B  390  TRP SER GLU THR PRO ASP LEU GLY GLY LEU GLU SER VAL          
SEQRES  24 B  390  MET LYS LYS ALA LYS THR MET LEU PRO PRO ILE GLN ASN          
SEQRES  25 B  390  MET LYS VAL ASP ARG PHE TRP ALA GLY LEU ARG PRO GLY          
SEQRES  26 B  390  THR LYS ASP GLY LYS PRO TYR ILE GLY ARG HIS PRO GLU          
SEQRES  27 B  390  ASP SER ARG ILE LEU PHE ALA ALA GLY HIS PHE ARG ASN          
SEQRES  28 B  390  GLY ILE LEU LEU ALA PRO ALA THR GLY ALA LEU ILE SER          
SEQRES  29 B  390  ASP LEU ILE MET ASN LYS GLU VAL ASN GLN ASP TRP LEU          
SEQRES  30 B  390  HIS ALA PHE ARG ILE ASP ARG LYS GLU ALA VAL GLN ILE          
HET    PO4    402       5                                                       
HET    FAD    400      53                                                       
HET    AAC    401       8                                                       
HET    FAD    500      53                                                       
HET    AAC    501       8                                                       
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     AAC ACETYLAMINO-ACETIC ACID                                          
FORMUL   3  PO4    O4 P 3-                                                      
FORMUL   4  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL   5  AAC    2(C4 H7 N O3)                                                
FORMUL   8  HOH   *107(H2 O)                                                    
CRYST1  139.378  139.378  208.155  90.00  90.00 120.00 P 61 2 2     24          
ATOM      1  N   MET A   1      21.479  51.002   1.597  1.00 61.54           N  
ATOM      2  CA  MET A   1      21.634  51.663   2.933  1.00 63.13           C  
ATOM      3  C   MET A   1      22.318  53.021   2.773  1.00 62.92           C  
ATOM      4  O   MET A   1      23.515  53.079   2.492  1.00 62.99           O  
ATOM      5  CB  MET A   1      22.473  50.782   3.870  1.00 63.38           C  
ATOM      6  CG  MET A   1      22.463  51.218   5.344  1.00 63.43           C  
ATOM      7  SD  MET A   1      23.756  50.425   6.356  1.00 65.24           S  
ATOM      8  CE  MET A   1      23.122  48.761   6.554  1.00 63.97           C  
ATOM      9  N   LYS A   2      21.567  54.105   2.959  1.00 62.68           N  
ATOM     10  CA  LYS A   2      22.120  55.454   2.818  1.00 61.85           C  
ATOM     11  C   LYS A   2      23.174  55.779   3.872  1.00 62.18           C  
ATOM     12  O   LYS A   2      23.575  54.922   4.661  1.00 61.41           O  
ATOM     13  CB  LYS A   2      21.008  56.504   2.878  1.00 61.13           C  
ATOM     14  CG  LYS A   2      20.007  56.420   1.740  1.00 61.39           C  
ATOM     15  CD  LYS A   2      18.840  57.370   1.970  1.00 61.83           C  
ATOM     16  CE  LYS A   2      17.787  57.241   0.873  1.00 62.47           C  
ATOM     17  NZ  LYS A   2      16.581  58.080   1.164  1.00 62.38           N  
ATOM     18  N   ARG A   3      23.616  57.030   3.879  1.00 62.53           N  
ATOM     19  CA  ARG A   3      24.634  57.461   4.822  1.00 62.66           C  
ATOM     20  C   ARG A   3      24.080  58.361   5.913  1.00 60.80           C  
ATOM     21  O   ARG A   3      24.681  58.492   6.976  1.00 60.58           O  
ATOM     22  CB  ARG A   3      25.756  58.193   4.086  1.00 65.19           C  
ATOM     23  CG  ARG A   3      26.932  58.547   4.979  1.00 69.12           C  
ATOM     24  CD  ARG A   3      27.585  57.290   5.540  1.00 72.61           C  
ATOM     25  NE  ARG A   3      28.096  56.428   4.477  1.00 76.50           N  
ATOM     26  CZ  ARG A   3      29.041  56.787   3.611  1.00 78.56           C  
ATOM     27  NH1 ARG A   3      29.588  57.996   3.679  1.00 79.13           N  
ATOM     28  NH2 ARG A   3      29.436  55.939   2.670  1.00 79.35           N  
ATOM     29  N   HIS A   4      22.941  58.987   5.657  1.00 59.07           N  
ATOM     30  CA  HIS A   4      22.358  59.869   6.652  1.00 58.15           C  
ATOM     31  C   HIS A   4      20.837  59.823   6.644  1.00 55.96           C  
ATOM     32  O   HIS A   4      20.207  59.791   5.589  1.00 56.46           O  
ATOM     33  CB  HIS A   4      22.855  61.305   6.428  1.00 60.90           C  
ATOM     34  CG  HIS A   4      22.395  62.278   7.472  1.00 63.81           C  
ATOM     35  ND1 HIS A   4      21.109  62.777   7.513  1.00 64.88           N  
ATOM     36  CD2 HIS A   4      23.043  62.827   8.528  1.00 64.33           C  
ATOM     37  CE1 HIS A   4      20.986  63.590   8.547  1.00 65.52           C  
ATOM     38  NE2 HIS A   4      22.145  63.638   9.180  1.00 65.25           N  
ATOM     39  N   TYR A   5      20.257  59.807   7.840  1.00 53.61           N  
ATOM     40  CA  TYR A   5      18.810  59.766   8.015  1.00 51.18           C  
ATOM     41  C   TYR A   5      18.440  60.741   9.116  1.00 51.11           C  
ATOM     42  O   TYR A   5      19.242  61.007  10.009  1.00 51.48           O  
ATOM     43  CB  TYR A   5      18.363  58.364   8.433  1.00 48.76           C  
ATOM     44  CG  TYR A   5      18.568  57.304   7.381  1.00 45.74           C  
ATOM     45  CD1 TYR A   5      17.613  57.084   6.390  1.00 42.71           C  
ATOM     46  CD2 TYR A   5      19.730  56.533   7.362  1.00 44.55           C  
ATOM     47  CE1 TYR A   5      17.806  56.122   5.406  1.00 42.26           C  
ATOM     48  CE2 TYR A   5      19.936  55.572   6.382  1.00 43.86           C  
ATOM     49  CZ  TYR A   5      18.970  55.371   5.408  1.00 43.33           C  
ATOM     50  OH  TYR A   5      19.169  54.413   4.441  1.00 46.39           O  
ATOM     51  N   GLU A   6      17.231  61.279   9.059  1.00 51.45           N  
ATOM     52  CA  GLU A   6      16.798  62.196  10.095  1.00 52.11           C  
ATOM     53  C   GLU A   6      16.650  61.390  11.377  1.00 50.78           C  
ATOM     54  O   GLU A   6      17.066  61.829  12.448  1.00 51.47           O  
ATOM     55  CB  GLU A   6      15.463  62.849   9.723  1.00 54.94           C  
ATOM     56  CG  GLU A   6      15.531  63.728   8.476  1.00 60.85           C  
ATOM     57  CD  GLU A   6      14.283  64.579   8.285  1.00 64.95           C  
ATOM     58  OE1 GLU A   6      13.987  65.411   9.174  1.00 67.27           O  
ATOM     59  OE2 GLU A   6      13.600  64.419   7.248  1.00 66.05           O  
ATOM     60  N   ALA A   7      16.072  60.196  11.252  1.00 48.92           N  
ATOM     61  CA  ALA A   7      15.861  59.314  12.396  1.00 46.39           C  
ATOM     62  C   ALA A   7      16.224  57.858  12.103  1.00 44.49           C  
ATOM     63  O   ALA A   7      15.964  57.346  11.014  1.00 42.86           O  
ATOM     64  CB  ALA A   7      14.412  59.403  12.855  1.00 44.94           C  
ATOM     65  N   VAL A   8      16.829  57.209  13.098  1.00 41.64           N  
ATOM     66  CA  VAL A   8      17.234  55.813  13.017  1.00 40.12           C  
ATOM     67  C   VAL A   8      16.606  55.035  14.174  1.00 39.62           C  
ATOM     68  O   VAL A   8      16.860  55.335  15.341  1.00 41.07           O  
ATOM     69  CB  VAL A   8      18.772  55.673  13.109  1.00 40.46           C  
ATOM     70  CG1 VAL A   8      19.152  54.274  13.557  1.00 40.08           C  
ATOM     71  CG2 VAL A   8      19.400  55.959  11.762  1.00 40.78           C  
ATOM     72  N   VAL A   9      15.781  54.043  13.857  1.00 38.11           N  
ATOM     73  CA  VAL A   9      15.153  53.229  14.894  1.00 35.09           C  
ATOM     74  C   VAL A   9      15.924  51.914  15.026  1.00 35.34           C  
ATOM     75  O   VAL A   9      16.107  51.193  14.042  1.00 35.83           O  
ATOM     76  CB  VAL A   9      13.690  52.926  14.551  1.00 34.06           C  
ATOM     77  CG1 VAL A   9      13.063  52.069  15.641  1.00 32.44           C  
ATOM     78  CG2 VAL A   9      12.921  54.230  14.388  1.00 32.09           C  
ATOM     79  N   ILE A  10      16.383  51.615  16.240  1.00 32.87           N  
ATOM     80  CA  ILE A  10      17.145  50.395  16.497  1.00 30.65           C  
ATOM     81  C   ILE A  10      16.297  49.300  17.151  1.00 30.63           C  
ATOM     82  O   ILE A  10      16.084  49.299  18.364  1.00 30.47           O  
ATOM     83  CB  ILE A  10      18.355  50.677  17.415  1.00 29.92           C  
ATOM     84  CG1 ILE A  10      19.110  51.918  16.929  1.00 28.41           C  
ATOM     85  CG2 ILE A  10      19.278  49.461  17.441  1.00 28.43           C  
ATOM     86  CD1 ILE A  10      20.291  52.297  17.794  1.00 26.57           C  
ATOM     87  N   GLY A  11      15.826  48.361  16.340  1.00 30.05           N  
ATOM     88  CA  GLY A  11      15.011  47.282  16.861  1.00 29.16           C  
ATOM     89  C   GLY A  11      13.753  47.172  16.035  1.00 28.43           C  
ATOM     90  O   GLY A  11      13.083  48.172  15.784  1.00 27.18           O  
ATOM     91  N   GLY A  12      13.417  45.956  15.627  1.00 28.43           N  
ATOM     92  CA  GLY A  12      12.243  45.781  14.796  1.00 29.32           C  
ATOM     93  C   GLY A  12      11.142  44.889  15.327  1.00 29.72           C  
ATOM     94  O   GLY A  12      10.638  44.015  14.615  1.00 31.28           O  
ATOM     95  N   GLY A  13      10.781  45.096  16.585  1.00 28.82           N  
ATOM     96  CA  GLY A  13       9.701  44.339  17.177  1.00 27.39           C  
ATOM     97  C   GLY A  13       8.523  45.268  16.994  1.00 26.59           C  
ATOM     98  O   GLY A  13       8.661  46.282  16.321  1.00 27.29           O  
ATOM     99  N   ILE A  14       7.381  44.961  17.593  1.00 25.35           N  
ATOM    100  CA  ILE A  14       6.224  45.825  17.442  1.00 25.31           C  
ATOM    101  C   ILE A  14       6.486  47.285  17.863  1.00 26.04           C  
ATOM    102  O   ILE A  14       5.959  48.211  17.258  1.00 26.99           O  
ATOM    103  CB  ILE A  14       5.005  45.264  18.220  1.00 24.06           C  
ATOM    104  CG1 ILE A  14       3.727  45.915  17.689  1.00 20.91           C  
ATOM    105  CG2 ILE A  14       5.165  45.506  19.726  1.00 18.45           C  
ATOM    106  CD1 ILE A  14       2.459  45.263  18.181  1.00 23.80           C  
ATOM    107  N   ILE A  15       7.306  47.501  18.883  1.00 27.20           N  
ATOM    108  CA  ILE A  15       7.591  48.863  19.327  1.00 28.31           C  
ATOM    109  C   ILE A  15       8.332  49.683  18.263  1.00 30.56           C  
ATOM    110  O   ILE A  15       7.827  50.704  17.786  1.00 30.98           O  
ATOM    111  CB  ILE A  15       8.411  48.858  20.641  1.00 27.21           C  
ATOM    112  CG1 ILE A  15       7.587  48.213  21.769  1.00 26.68           C  
ATOM    113  CG2 ILE A  15       8.822  50.272  21.009  1.00 25.66           C  
ATOM    114  CD1 ILE A  15       6.227  48.862  22.012  1.00 20.81           C  
ATOM    115  N   GLY A  16       9.525  49.234  17.889  1.00 32.42           N  
ATOM    116  CA  GLY A  16      10.292  49.941  16.881  1.00 32.98           C  
ATOM    117  C   GLY A  16       9.518  50.080  15.581  1.00 34.71           C  
ATOM    118  O   GLY A  16       9.624  51.095  14.895  1.00 36.46           O  
ATOM    119  N   SER A  17       8.735  49.059  15.242  1.00 34.19           N  
ATOM    120  CA  SER A  17       7.943  49.079  14.022  1.00 34.26           C  
ATOM    121  C   SER A  17       6.932  50.200  14.062  1.00 35.64           C  
ATOM    122  O   SER A  17       6.785  50.943  13.096  1.00 36.08           O  
ATOM    123  CB  SER A  17       7.213  47.753  13.833  1.00 33.75           C  
ATOM    124  OG  SER A  17       8.123  46.742  13.440  1.00 36.50           O  
ATOM    125  N   ALA A  18       6.228  50.314  15.182  1.00 35.65           N  
ATOM    126  CA  ALA A  18       5.235  51.358  15.333  1.00 36.95           C  
ATOM    127  C   ALA A  18       5.927  52.720  15.231  1.00 38.11           C  
ATOM    128  O   ALA A  18       5.470  53.610  14.514  1.00 38.21           O  
ATOM    129  CB  ALA A  18       4.536  51.219  16.678  1.00 37.54           C  
ATOM    130  N   ILE A  19       7.037  52.867  15.945  1.00 38.31           N  
ATOM    131  CA  ILE A  19       7.792  54.110  15.942  1.00 38.36           C  
ATOM    132  C   ILE A  19       8.156  54.509  14.517  1.00 40.14           C  
ATOM    133  O   ILE A  19       7.941  55.653  14.109  1.00 39.69           O  
ATOM    134  CB  ILE A  19       9.087  53.975  16.789  1.00 37.95           C  
ATOM    135  CG1 ILE A  19       8.725  53.708  18.256  1.00 36.89           C  
ATOM    136  CG2 ILE A  19       9.924  55.244  16.683  1.00 35.30           C  
ATOM    137  CD1 ILE A  19       9.917  53.499  19.167  1.00 34.65           C  
ATOM    138  N   ALA A  20       8.693  53.557  13.758  1.00 41.46           N  
ATOM    139  CA  ALA A  20       9.099  53.812  12.379  1.00 41.23           C  
ATOM    140  C   ALA A  20       7.924  54.277  11.535  1.00 42.29           C  
ATOM    141  O   ALA A  20       8.071  55.134  10.664  1.00 43.72           O  
ATOM    142  CB  ALA A  20       9.714  52.561  11.772  1.00 38.39           C  
ATOM    143  N   TYR A  21       6.755  53.713  11.802  1.00 42.67           N  
ATOM    144  CA  TYR A  21       5.559  54.071  11.059  1.00 42.73           C  
ATOM    145  C   TYR A  21       5.134  55.512  11.293  1.00 43.33           C  
ATOM    146  O   TYR A  21       4.914  56.261  10.344  1.00 43.78           O  
ATOM    147  CB  TYR A  21       4.403  53.163  11.449  1.00 41.24           C  
ATOM    148  CG  TYR A  21       3.088  53.596  10.848  1.00 42.19           C  
ATOM    149  CD1 TYR A  21       2.832  53.432   9.482  1.00 41.72           C  
ATOM    150  CD2 TYR A  21       2.090  54.161  11.645  1.00 41.19           C  
ATOM    151  CE1 TYR A  21       1.613  53.815   8.927  1.00 40.77           C  
ATOM    152  CE2 TYR A  21       0.870  54.548  11.100  1.00 40.98           C  
ATOM    153  CZ  TYR A  21       0.638  54.370   9.741  1.00 41.66           C  
ATOM    154  OH  TYR A  21      -0.576  54.736   9.204  1.00 41.96           O  
ATOM    155  N   TYR A  22       5.001  55.888  12.559  1.00 43.57           N  
ATOM    156  CA  TYR A  22       4.580  57.233  12.903  1.00 44.08           C  
ATOM    157  C   TYR A  22       5.556  58.298  12.431  1.00 45.75           C  
ATOM    158  O   TYR A  22       5.147  59.410  12.102  1.00 46.15           O  
ATOM    159  CB  TYR A  22       4.343  57.329  14.406  1.00 43.27           C  
ATOM    160  CG  TYR A  22       3.172  56.478  14.843  1.00 42.79           C  
ATOM    161  CD1 TYR A  22       1.897  56.712  14.340  1.00 41.87           C  
ATOM    162  CD2 TYR A  22       3.344  55.409  15.723  1.00 42.69           C  
ATOM    163  CE1 TYR A  22       0.823  55.904  14.693  1.00 42.92           C  
ATOM    164  CE2 TYR A  22       2.274  54.594  16.084  1.00 42.26           C  
ATOM    165  CZ  TYR A  22       1.019  54.846  15.562  1.00 43.06           C  
ATOM    166  OH  TYR A  22      -0.040  54.030  15.884  1.00 44.07           O  
ATOM    167  N   LEU A  23       6.840  57.959  12.387  1.00 46.59           N  
ATOM    168  CA  LEU A  23       7.843  58.905  11.920  1.00 48.38           C  
ATOM    169  C   LEU A  23       7.687  59.057  10.413  1.00 50.78           C  
ATOM    170  O   LEU A  23       7.775  60.156   9.870  1.00 51.88           O  
ATOM    171  CB  LEU A  23       9.249  58.404  12.249  1.00 47.57           C  
ATOM    172  CG  LEU A  23       9.695  58.516  13.709  1.00 47.95           C  
ATOM    173  CD1 LEU A  23      11.073  57.889  13.875  1.00 45.71           C  
ATOM    174  CD2 LEU A  23       9.710  59.984  14.126  1.00 46.64           C  
ATOM    175  N   ALA A  24       7.455  57.938   9.739  1.00 53.07           N  
ATOM    176  CA  ALA A  24       7.265  57.943   8.298  1.00 54.38           C  
ATOM    177  C   ALA A  24       6.041  58.798   7.986  1.00 55.49           C  
ATOM    178  O   ALA A  24       6.028  59.548   7.017  1.00 55.53           O  
ATOM    179  CB  ALA A  24       7.056  56.517   7.794  1.00 53.73           C  
ATOM    180  N   LYS A  25       5.022  58.677   8.831  1.00 57.24           N  
ATOM    181  CA  LYS A  25       3.777  59.424   8.681  1.00 58.49           C  
ATOM    182  C   LYS A  25       4.044  60.921   8.864  1.00 59.09           C  
ATOM    183  O   LYS A  25       3.444  61.755   8.187  1.00 58.39           O  
ATOM    184  CB  LYS A  25       2.766  58.944   9.724  1.00 58.96           C  
ATOM    185  CG  LYS A  25       1.358  58.740   9.207  1.00 58.91           C  
ATOM    186  CD  LYS A  25       0.439  58.367  10.359  1.00 60.57           C  
ATOM    187  CE  LYS A  25      -1.007  58.204   9.920  1.00 61.52           C  
ATOM    188  NZ  LYS A  25      -1.886  57.951  11.103  1.00 63.04           N  
ATOM    189  N   GLU A  26       4.940  61.251   9.789  1.00 59.88           N  
ATOM    190  CA  GLU A  26       5.312  62.638  10.050  1.00 61.06           C  
ATOM    191  C   GLU A  26       6.284  63.079   8.963  1.00 61.34           C  
ATOM    192  O   GLU A  26       6.857  64.167   9.020  1.00 60.62           O  
ATOM    193  CB  GLU A  26       6.001  62.763  11.410  1.00 62.54           C  
ATOM    194  CG  GLU A  26       5.087  62.599  12.604  1.00 65.99           C  
ATOM    195  CD  GLU A  26       4.149  63.770  12.778  1.00 67.18           C  
ATOM    196  OE1 GLU A  26       3.372  63.764  13.754  1.00 68.81           O  
ATOM    197  OE2 GLU A  26       4.191  64.695  11.942  1.00 68.26           O  
ATOM    198  N   ASN A  27       6.469  62.207   7.978  1.00 61.85           N  
ATOM    199  CA  ASN A  27       7.368  62.466   6.865  1.00 62.74           C  
ATOM    200  C   ASN A  27       8.758  62.827   7.367  1.00 62.10           C  
ATOM    201  O   ASN A  27       9.202  63.965   7.253  1.00 62.83           O  
ATOM    202  CB  ASN A  27       6.825  63.594   5.993  1.00 64.85           C  
ATOM    203  CG  ASN A  27       7.512  63.662   4.647  1.00 67.04           C  
ATOM    204  OD1 ASN A  27       8.741  63.733   4.564  1.00 68.27           O  
ATOM    205  ND2 ASN A  27       6.721  63.639   3.580  1.00 68.56           N  
ATOM    206  N   LYS A  28       9.441  61.838   7.925  1.00 61.62           N  
ATOM    207  CA  LYS A  28      10.779  62.024   8.454  1.00 60.29           C  
ATOM    208  C   LYS A  28      11.646  60.950   7.801  1.00 59.05           C  
ATOM    209  O   LYS A  28      11.343  59.764   7.910  1.00 60.07           O  
ATOM    210  CB  LYS A  28      10.748  61.835   9.975  1.00 61.25           C  
ATOM    211  CG  LYS A  28      11.824  62.577  10.759  1.00 63.25           C  
ATOM    212  CD  LYS A  28      11.537  64.074  10.831  1.00 65.24           C  
ATOM    213  CE  LYS A  28      12.355  64.756  11.928  1.00 65.17           C  
ATOM    214  NZ  LYS A  28      13.830  64.605  11.750  1.00 66.24           N  
ATOM    215  N   ASN A  29      12.695  61.367   7.097  1.00 58.10           N  
ATOM    216  CA  ASN A  29      13.610  60.430   6.441  1.00 56.76           C  
ATOM    217  C   ASN A  29      14.082  59.486   7.546  1.00 55.13           C  
ATOM    218  O   ASN A  29      15.042  59.779   8.263  1.00 55.63           O  
ATOM    219  CB  ASN A  29      14.795  61.204   5.836  1.00 57.65           C  
ATOM    220  CG  ASN A  29      15.789  60.306   5.103  1.00 59.23           C  
ATOM    221  OD1 ASN A  29      15.427  59.576   4.178  1.00 59.94           O  
ATOM    222  ND2 ASN A  29      17.056  60.371   5.510  1.00 59.25           N  
ATOM    223  N   THR A  30      13.397  58.355   7.691  1.00 52.39           N  
ATOM    224  CA  THR A  30      13.731  57.411   8.752  1.00 49.72           C  
ATOM    225  C   THR A  30      14.168  56.026   8.305  1.00 46.74           C  
ATOM    226  O   THR A  30      13.733  55.514   7.276  1.00 46.53           O  
ATOM    227  CB  THR A  30      12.543  57.252   9.732  1.00 49.52           C  
ATOM    228  OG1 THR A  30      11.365  56.915   8.996  1.00 52.71           O  
ATOM    229  CG2 THR A  30      12.287  58.544  10.482  1.00 48.86           C  
ATOM    230  N   ALA A  31      15.042  55.426   9.103  1.00 44.06           N  
ATOM    231  CA  ALA A  31      15.550  54.095   8.834  1.00 42.29           C  
ATOM    232  C   ALA A  31      15.409  53.267  10.107  1.00 41.77           C  
ATOM    233  O   ALA A  31      15.475  53.805  11.218  1.00 40.94           O  
ATOM    234  CB  ALA A  31      17.014  54.170   8.417  1.00 41.64           C  
ATOM    235  N   LEU A  32      15.206  51.963   9.943  1.00 40.46           N  
ATOM    236  CA  LEU A  32      15.083  51.053  11.078  1.00 38.52           C  
ATOM    237  C   LEU A  32      16.032  49.881  10.875  1.00 37.73           C  
ATOM    238  O   LEU A  32      16.025  49.243   9.830  1.00 38.80           O  
ATOM    239  CB  LEU A  32      13.643  50.544  11.212  1.00 37.05           C  
ATOM    240  CG  LEU A  32      13.343  49.531  12.331  1.00 35.49           C  
ATOM    241  CD1 LEU A  32      11.845  49.512  12.622  1.00 34.26           C  
ATOM    242  CD2 LEU A  32      13.827  48.143  11.932  1.00 32.46           C  
ATOM    243  N   PHE A  33      16.842  49.592  11.881  1.00 37.71           N  
ATOM    244  CA  PHE A  33      17.797  48.496  11.797  1.00 37.76           C  
ATOM    245  C   PHE A  33      17.386  47.329  12.686  1.00 37.68           C  
ATOM    246  O   PHE A  33      17.378  47.454  13.906  1.00 39.68           O  
ATOM    247  CB  PHE A  33      19.184  49.008  12.195  1.00 38.02           C  
ATOM    248  CG  PHE A  33      19.733  50.036  11.246  1.00 41.48           C  
ATOM    249  CD1 PHE A  33      20.395  49.650  10.086  1.00 42.95           C  
ATOM    250  CD2 PHE A  33      19.535  51.388  11.478  1.00 41.77           C  
ATOM    251  CE1 PHE A  33      20.847  50.596   9.176  1.00 42.85           C  
ATOM    252  CE2 PHE A  33      19.983  52.338  10.572  1.00 43.03           C  
ATOM    253  CZ  PHE A  33      20.640  51.941   9.418  1.00 42.21           C  
ATOM    254  N   GLU A  34      17.034  46.201  12.073  1.00 36.43           N  
ATOM    255  CA  GLU A  34      16.629  45.013  12.821  1.00 34.40           C  
ATOM    256  C   GLU A  34      17.678  43.917  12.722  1.00 33.99           C  
ATOM    257  O   GLU A  34      18.065  43.498  11.633  1.00 34.63           O  
ATOM    258  CB  GLU A  34      15.291  44.478  12.305  1.00 34.54           C  
ATOM    259  CG  GLU A  34      15.014  43.032  12.689  1.00 34.05           C  
ATOM    260  CD  GLU A  34      14.855  42.843  14.186  1.00 36.31           C  
ATOM    261  OE1 GLU A  34      15.410  41.868  14.743  1.00 35.57           O  
ATOM    262  OE2 GLU A  34      14.159  43.665  14.807  1.00 35.72           O  
ATOM    263  N   SER A  35      18.126  43.449  13.875  1.00 32.78           N  
ATOM    264  CA  SER A  35      19.134  42.407  13.951  1.00 32.34           C  
ATOM    265  C   SER A  35      18.808  41.136  13.149  1.00 31.67           C  
ATOM    266  O   SER A  35      19.691  40.555  12.509  1.00 31.97           O  
ATOM    267  CB  SER A  35      19.364  42.047  15.417  1.00 31.78           C  
ATOM    268  OG  SER A  35      20.489  41.204  15.544  1.00 35.95           O  
ATOM    269  N   GLY A  36      17.552  40.693  13.203  1.00 29.08           N  
ATOM    270  CA  GLY A  36      17.149  39.498  12.475  1.00 26.49           C  
ATOM    271  C   GLY A  36      15.987  39.806  11.554  1.00 24.84           C  
ATOM    272  O   GLY A  36      16.157  40.521  10.579  1.00 25.84           O  
ATOM    273  N   THR A  37      14.804  39.284  11.851  1.00 24.05           N  
ATOM    274  CA  THR A  37      13.640  39.573  11.017  1.00 26.49           C  
ATOM    275  C   THR A  37      12.624  40.369  11.813  1.00 26.63           C  
ATOM    276  O   THR A  37      12.538  40.227  13.031  1.00 28.26           O  
ATOM    277  CB  THR A  37      12.958  38.287  10.503  1.00 27.15           C  
ATOM    278  OG1 THR A  37      12.681  37.424  11.610  1.00 28.80           O  
ATOM    279  CG2 THR A  37      13.854  37.562   9.507  1.00 26.79           C  
ATOM    280  N   MET A  38      11.853  41.199  11.120  1.00 26.82           N  
ATOM    281  CA  MET A  38      10.846  42.030  11.763  1.00 26.69           C  
ATOM    282  C   MET A  38       9.885  41.208  12.605  1.00 27.69           C  
ATOM    283  O   MET A  38       9.282  40.256  12.110  1.00 28.67           O  
ATOM    284  CB  MET A  38      10.063  42.823  10.713  1.00 27.60           C  
ATOM    285  CG  MET A  38      10.916  43.775   9.891  1.00 27.84           C  
ATOM    286  SD  MET A  38      11.911  44.906  10.904  1.00 33.24           S  
ATOM    287  CE  MET A  38      10.697  46.156  11.329  1.00 32.16           C  
ATOM    288  N   GLY A  39       9.754  41.588  13.880  1.00 27.82           N  
ATOM    289  CA  GLY A  39       8.873  40.900  14.810  1.00 24.05           C  
ATOM    290  C   GLY A  39       9.255  39.453  15.084  1.00 25.13           C  
ATOM    291  O   GLY A  39       8.405  38.642  15.452  1.00 23.86           O  
ATOM    292  N   GLY A  40      10.534  39.124  14.922  1.00 24.70           N  
ATOM    293  CA  GLY A  40      10.977  37.760  15.135  1.00 22.76           C  
ATOM    294  C   GLY A  40      11.266  37.334  16.561  1.00 25.28           C  
ATOM    295  O   GLY A  40      11.589  36.166  16.792  1.00 24.48           O  
ATOM    296  N   ARG A  41      11.154  38.241  17.528  1.00 24.63           N  
ATOM    297  CA  ARG A  41      11.433  37.851  18.900  1.00 25.11           C  
ATOM    298  C   ARG A  41      10.209  37.830  19.817  1.00 25.36           C  
ATOM    299  O   ARG A  41       9.198  37.202  19.498  1.00 25.63           O  
ATOM    300  CB  ARG A  41      12.542  38.736  19.484  1.00 26.10           C  
ATOM    301  CG  ARG A  41      13.844  38.723  18.664  1.00 28.32           C  
ATOM    302  CD  ARG A  41      14.312  37.303  18.304  1.00 28.84           C  
ATOM    303  NE  ARG A  41      15.100  36.645  19.349  1.00 29.81           N  
ATOM    304  CZ  ARG A  41      16.412  36.796  19.513  1.00 31.28           C  
ATOM    305  NH1 ARG A  41      17.101  37.582  18.697  1.00 34.57           N  
ATOM    306  NH2 ARG A  41      17.041  36.172  20.503  1.00 29.31           N  
ATOM    307  N   THR A  42      10.301  38.519  20.949  1.00 25.52           N  
ATOM    308  CA  THR A  42       9.220  38.550  21.931  1.00 25.22           C  
ATOM    309  C   THR A  42       7.855  38.846  21.314  1.00 24.43           C  
ATOM    310  O   THR A  42       6.850  38.225  21.664  1.00 23.01           O  
ATOM    311  CB  THR A  42       9.517  39.585  23.046  1.00 27.06           C  
ATOM    312  OG1 THR A  42      10.846  39.381  23.553  1.00 22.64           O  
ATOM    313  CG2 THR A  42       8.524  39.424  24.195  1.00 27.56           C  
ATOM    314  N   THR A  43       7.827  39.793  20.386  1.00 24.47           N  
ATOM    315  CA  THR A  43       6.592  40.173  19.715  1.00 24.34           C  
ATOM    316  C   THR A  43       5.847  38.963  19.138  1.00 24.80           C  
ATOM    317  O   THR A  43       4.627  38.861  19.256  1.00 24.11           O  
ATOM    318  CB  THR A  43       6.895  41.195  18.598  1.00 24.33           C  
ATOM    319  OG1 THR A  43       7.350  42.414  19.201  1.00 24.03           O  
ATOM    320  CG2 THR A  43       5.653  41.476  17.747  1.00 21.58           C  
ATOM    321  N   SER A  44       6.580  38.042  18.526  1.00 24.04           N  
ATOM    322  CA  SER A  44       5.959  36.856  17.943  1.00 24.03           C  
ATOM    323  C   SER A  44       5.449  35.844  18.963  1.00 22.59           C  
ATOM    324  O   SER A  44       4.726  34.910  18.609  1.00 20.02           O  
ATOM    325  CB  SER A  44       6.948  36.154  17.018  1.00 23.18           C  
ATOM    326  OG  SER A  44       6.978  36.802  15.768  1.00 30.32           O  
ATOM    327  N   ALA A  45       5.827  36.024  20.225  1.00 21.64           N  
ATOM    328  CA  ALA A  45       5.427  35.090  21.257  1.00 18.67           C  
ATOM    329  C   ALA A  45       4.213  35.548  22.019  1.00 17.44           C  
ATOM    330  O   ALA A  45       3.542  34.740  22.632  1.00 18.58           O  
ATOM    331  CB  ALA A  45       6.575  34.864  22.213  1.00 18.35           C  
ATOM    332  N   ALA A  46       3.922  36.842  21.963  1.00 17.89           N  
ATOM    333  CA  ALA A  46       2.796  37.409  22.707  1.00 19.22           C  
ATOM    334  C   ALA A  46       1.418  36.951  22.272  1.00 21.13           C  
ATOM    335  O   ALA A  46       1.201  36.582  21.118  1.00 22.77           O  
ATOM    336  CB  ALA A  46       2.865  38.937  22.675  1.00 16.69           C  
ATOM    337  N   ALA A  47       0.485  36.982  23.218  1.00 23.39           N  
ATOM    338  CA  ALA A  47      -0.893  36.585  22.962  1.00 25.17           C  
ATOM    339  C   ALA A  47      -1.598  37.689  22.182  1.00 25.85           C  
ATOM    340  O   ALA A  47      -2.438  37.418  21.329  1.00 27.24           O  
ATOM    341  CB  ALA A  47      -1.623  36.323  24.279  1.00 24.15           C  
ATOM    342  N   GLY A  48      -1.253  38.937  22.479  1.00 25.60           N  
ATOM    343  CA  GLY A  48      -1.869  40.046  21.781  1.00 26.63           C  
ATOM    344  C   GLY A  48      -3.099  40.632  22.451  1.00 27.59           C  
ATOM    345  O   GLY A  48      -3.939  41.234  21.787  1.00 26.96           O  
ATOM    346  N   MET A  49      -3.222  40.457  23.762  1.00 28.89           N  
ATOM    347  CA  MET A  49      -4.364  41.014  24.479  1.00 29.89           C  
ATOM    348  C   MET A  49      -4.115  42.486  24.738  1.00 31.03           C  
ATOM    349  O   MET A  49      -2.991  42.881  25.075  1.00 32.02           O  
ATOM    350  CB  MET A  49      -4.557  40.318  25.824  1.00 28.19           C  
ATOM    351  CG  MET A  49      -4.952  38.873  25.725  1.00 30.28           C  
ATOM    352  SD  MET A  49      -4.965  38.091  27.325  1.00 32.56           S  
ATOM    353  CE  MET A  49      -3.222  37.659  27.522  1.00 27.76           C  
ATOM    354  N   LEU A  50      -5.148  43.304  24.565  1.00 30.83           N  
ATOM    355  CA  LEU A  50      -5.018  44.726  24.847  1.00 33.57           C  
ATOM    356  C   LEU A  50      -5.473  44.876  26.310  1.00 34.92           C  
ATOM    357  O   LEU A  50      -6.388  45.635  26.627  1.00 36.76           O  
ATOM    358  CB  LEU A  50      -5.908  45.538  23.897  1.00 32.09           C  
ATOM    359  CG  LEU A  50      -5.810  45.159  22.411  1.00 33.80           C  
ATOM    360  CD1 LEU A  50      -6.577  46.179  21.581  1.00 31.28           C  
ATOM    361  CD2 LEU A  50      -4.346  45.094  21.958  1.00 31.19           C  
ATOM    362  N   GLY A  51      -4.820  44.125  27.193  1.00 35.18           N  
ATOM    363  CA  GLY A  51      -5.169  44.133  28.601  1.00 36.69           C  
ATOM    364  C   GLY A  51      -4.903  45.425  29.345  1.00 38.11           C  
ATOM    365  O   GLY A  51      -3.993  45.492  30.174  1.00 36.76           O  
ATOM    366  N   ALA A  52      -5.706  46.446  29.065  1.00 39.42           N  
ATOM    367  CA  ALA A  52      -5.541  47.737  29.719  1.00 41.70           C  
ATOM    368  C   ALA A  52      -6.086  47.693  31.137  1.00 42.98           C  
ATOM    369  O   ALA A  52      -5.772  48.551  31.954  1.00 43.09           O  
ATOM    370  CB  ALA A  52      -6.250  48.821  28.926  1.00 41.02           C  
ATOM    371  N   HIS A  53      -6.896  46.680  31.426  1.00 45.37           N  
ATOM    372  CA  HIS A  53      -7.490  46.532  32.749  1.00 47.45           C  
ATOM    373  C   HIS A  53      -6.763  45.501  33.607  1.00 49.97           C  
ATOM    374  O   HIS A  53      -7.353  44.835  34.446  1.00 48.69           O  
ATOM    375  CB  HIS A  53      -8.965  46.175  32.601  1.00 45.35           C  
ATOM    376  CG  HIS A  53      -9.760  47.228  31.899  1.00 45.92           C  
ATOM    377  ND1 HIS A  53     -10.430  48.228  32.571  1.00 46.02           N  
ATOM    378  CD2 HIS A  53      -9.950  47.470  30.580  1.00 45.48           C  
ATOM    379  CE1 HIS A  53     -10.999  49.039  31.696  1.00 45.64           C  
ATOM    380  NE2 HIS A  53     -10.724  48.601  30.481  1.00 45.64           N  
ATOM    381  N   ALA A  54      -5.468  45.369  33.372  1.00 55.23           N  
ATOM    382  CA  ALA A  54      -4.639  44.457  34.143  1.00 60.28           C  
ATOM    383  C   ALA A  54      -3.692  45.392  34.886  1.00 63.74           C  
ATOM    384  O   ALA A  54      -2.937  44.984  35.766  1.00 63.89           O  
ATOM    385  CB  ALA A  54      -3.861  43.533  33.210  1.00 59.79           C  
ATOM    386  N   GLU A  55      -3.772  46.667  34.508  1.00 67.90           N  
ATOM    387  CA  GLU A  55      -2.952  47.733  35.072  1.00 71.31           C  
ATOM    388  C   GLU A  55      -3.840  48.806  35.694  1.00 71.91           C  
ATOM    389  O   GLU A  55      -3.549  49.999  35.586  1.00 71.59           O  
ATOM    390  CB  GLU A  55      -2.108  48.369  33.965  1.00 73.56           C  
ATOM    391  CG  GLU A  55      -1.238  47.389  33.193  1.00 76.83           C  
ATOM    392  CD  GLU A  55      -0.815  47.932  31.838  1.00 78.48           C  
ATOM    393  OE1 GLU A  55      -0.273  49.061  31.784  1.00 79.69           O  
ATOM    394  OE2 GLU A  55      -1.024  47.227  30.825  1.00 79.50           O  
ATOM    395  N   CYS A  56      -4.927  48.384  36.333  1.00 73.17           N  
ATOM    396  CA  CYS A  56      -5.842  49.330  36.961  1.00 74.34           C  
ATOM    397  C   CYS A  56      -6.015  49.069  38.454  1.00 74.77           C  
ATOM    398  O   CYS A  56      -6.960  49.563  39.068  1.00 75.14           O  
ATOM    399  CB  CYS A  56      -7.209  49.298  36.268  1.00 74.03           C  
ATOM    400  SG  CYS A  56      -8.130  47.752  36.453  1.00 74.95           S  
ATOM    401  N   GLU A  57      -5.105  48.295  39.040  1.00 75.66           N  
ATOM    402  CA  GLU A  57      -5.184  48.019  40.467  1.00 76.06           C  
ATOM    403  C   GLU A  57      -4.911  49.344  41.173  1.00 75.27           C  
ATOM    404  O   GLU A  57      -5.078  49.476  42.387  1.00 76.30           O  
ATOM    405  CB  GLU A  57      -4.159  46.954  40.875  1.00 77.52           C  
ATOM    406  CG  GLU A  57      -4.394  46.402  42.279  1.00 80.38           C  
ATOM    407  CD  GLU A  57      -3.992  44.941  42.423  1.00 81.90           C  
ATOM    408  OE1 GLU A  57      -4.476  44.111  41.619  1.00 81.92           O  
ATOM    409  OE2 GLU A  57      -3.207  44.622  43.346  1.00 81.82           O  
ATOM    410  N   GLU A  58      -4.494  50.322  40.375  1.00 73.87           N  
ATOM    411  CA  GLU A  58      -4.201  51.683  40.815  1.00 71.70           C  
ATOM    412  C   GLU A  58      -4.403  52.552  39.583  1.00 69.21           C  
ATOM    413  O   GLU A  58      -3.634  52.460  38.632  1.00 70.01           O  
ATOM    414  CB  GLU A  58      -2.754  51.804  41.288  1.00 73.00           C  
ATOM    415  CG  GLU A  58      -2.448  51.062  42.573  1.00 76.04           C  
ATOM    416  CD  GLU A  58      -1.014  51.259  43.024  1.00 77.75           C  
ATOM    417  OE1 GLU A  58      -0.658  50.769  44.118  1.00 79.14           O  
ATOM    418  OE2 GLU A  58      -0.241  51.903  42.281  1.00 79.16           O  
ATOM    419  N   ARG A  59      -5.438  53.384  39.586  1.00 66.17           N  
ATOM    420  CA  ARG A  59      -5.714  54.233  38.434  1.00 63.30           C  
ATOM    421  C   ARG A  59      -4.773  55.428  38.310  1.00 61.63           C  
ATOM    422  O   ARG A  59      -5.194  56.571  38.460  1.00 62.07           O  
ATOM    423  CB  ARG A  59      -7.163  54.735  38.473  1.00 63.03           C  
ATOM    424  CG  ARG A  59      -8.220  53.642  38.384  1.00 63.26           C  
ATOM    425  CD  ARG A  59      -8.420  52.944  39.718  1.00 63.05           C  
ATOM    426  NE  ARG A  59      -9.417  51.875  39.656  1.00 63.83           N  
ATOM    427  CZ  ARG A  59     -10.665  52.023  39.217  1.00 63.06           C  
ATOM    428  NH1 ARG A  59     -11.093  53.201  38.788  1.00 62.63           N  
ATOM    429  NH2 ARG A  59     -11.494  50.990  39.222  1.00 62.71           N  
ATOM    430  N   ASP A  60      -3.502  55.167  38.021  1.00 59.61           N  
ATOM    431  CA  ASP A  60      -2.533  56.244  37.873  1.00 58.13           C  
ATOM    432  C   ASP A  60      -2.203  56.541  36.410  1.00 56.44           C  
ATOM    433  O   ASP A  60      -2.955  56.181  35.504  1.00 56.82           O  
ATOM    434  CB  ASP A  60      -1.248  55.915  38.634  1.00 58.96           C  
ATOM    435  CG  ASP A  60      -0.659  54.586  38.229  1.00 60.80           C  
ATOM    436  OD1 ASP A  60      -0.835  54.193  37.056  1.00 62.61           O  
ATOM    437  OD2 ASP A  60      -0.007  53.940  39.077  1.00 61.91           O  
ATOM    438  N   ALA A  61      -1.073  57.205  36.188  1.00 53.92           N  
ATOM    439  CA  ALA A  61      -0.634  57.567  34.848  1.00 52.01           C  
ATOM    440  C   ALA A  61      -0.510  56.349  33.941  1.00 51.30           C  
ATOM    441  O   ALA A  61      -0.889  56.394  32.764  1.00 49.99           O  
ATOM    442  CB  ALA A  61       0.697  58.295  34.921  1.00 51.76           C  
ATOM    443  N   PHE A  62       0.031  55.264  34.489  1.00 49.63           N  
ATOM    444  CA  PHE A  62       0.203  54.038  33.728  1.00 48.33           C  
ATOM    445  C   PHE A  62      -1.120  53.541  33.172  1.00 48.78           C  
ATOM    446  O   PHE A  62      -1.199  53.150  32.007  1.00 49.74           O  
ATOM    447  CB  PHE A  62       0.847  52.972  34.604  1.00 47.15           C  
ATOM    448  CG  PHE A  62       2.236  53.326  35.050  1.00 48.42           C  
ATOM    449  CD1 PHE A  62       3.240  53.560  34.111  1.00 47.91           C  
ATOM    450  CD2 PHE A  62       2.541  53.446  36.402  1.00 48.54           C  
ATOM    451  CE1 PHE A  62       4.534  53.912  34.512  1.00 48.89           C  
ATOM    452  CE2 PHE A  62       3.835  53.799  36.817  1.00 49.12           C  
ATOM    453  CZ  PHE A  62       4.832  54.031  35.869  1.00 48.39           C  
ATOM    454  N   PHE A  63      -2.163  53.567  33.996  1.00 49.04           N  
ATOM    455  CA  PHE A  63      -3.483  53.122  33.560  1.00 49.04           C  
ATOM    456  C   PHE A  63      -4.069  54.052  32.494  1.00 48.70           C  
ATOM    457  O   PHE A  63      -4.725  53.600  31.553  1.00 47.80           O  
ATOM    458  CB  PHE A  63      -4.442  53.038  34.754  1.00 49.15           C  
ATOM    459  CG  PHE A  63      -5.860  52.722  34.365  1.00 49.87           C  
ATOM    460  CD1 PHE A  63      -6.177  51.506  33.755  1.00 49.69           C  
ATOM    461  CD2 PHE A  63      -6.875  53.662  34.555  1.00 48.58           C  
ATOM    462  CE1 PHE A  63      -7.484  51.231  33.333  1.00 47.18           C  
ATOM    463  CE2 PHE A  63      -8.178  53.397  34.138  1.00 47.10           C  
ATOM    464  CZ  PHE A  63      -8.482  52.178  33.524  1.00 47.76           C  
ATOM    465  N   ASP A  64      -3.835  55.351  32.641  1.00 49.10           N  
ATOM    466  CA  ASP A  64      -4.350  56.316  31.675  1.00 50.18           C  
ATOM    467  C   ASP A  64      -3.656  56.114  30.338  1.00 49.23           C  
ATOM    468  O   ASP A  64      -4.266  56.249  29.275  1.00 48.96           O  
ATOM    469  CB  ASP A  64      -4.118  57.743  32.173  1.00 53.00           C  
ATOM    470  CG  ASP A  64      -4.691  57.973  33.559  1.00 56.77           C  
ATOM    471  OD1 ASP A  64      -5.902  57.720  33.749  1.00 57.81           O  
ATOM    472  OD2 ASP A  64      -3.933  58.402  34.458  1.00 59.28           O  
ATOM    473  N   PHE A  65      -2.371  55.785  30.399  1.00 48.27           N  
ATOM    474  CA  PHE A  65      -1.595  55.548  29.193  1.00 47.57           C  
ATOM    475  C   PHE A  65      -2.127  54.280  28.524  1.00 46.85           C  
ATOM    476  O   PHE A  65      -2.442  54.279  27.331  1.00 45.99           O  
ATOM    477  CB  PHE A  65      -0.120  55.384  29.550  1.00 48.23           C  
ATOM    478  CG  PHE A  65       0.805  55.469  28.370  1.00 49.66           C  
ATOM    479  CD1 PHE A  65       0.887  56.636  27.616  1.00 49.50           C  
ATOM    480  CD2 PHE A  65       1.614  54.385  28.025  1.00 49.30           C  
ATOM    481  CE1 PHE A  65       1.762  56.727  26.535  1.00 50.37           C  
ATOM    482  CE2 PHE A  65       2.490  54.463  26.948  1.00 49.24           C  
ATOM    483  CZ  PHE A  65       2.565  55.638  26.200  1.00 51.13           C  
ATOM    484  N   ALA A  66      -2.238  53.206  29.302  1.00 45.95           N  
ATOM    485  CA  ALA A  66      -2.741  51.937  28.785  1.00 44.95           C  
ATOM    486  C   ALA A  66      -4.096  52.159  28.120  1.00 45.14           C  
ATOM    487  O   ALA A  66      -4.335  51.704  27.000  1.00 45.01           O  
ATOM    488  CB  ALA A  66      -2.860  50.920  29.915  1.00 42.12           C  
ATOM    489  N   MET A  67      -4.981  52.870  28.811  1.00 46.49           N  
ATOM    490  CA  MET A  67      -6.308  53.157  28.282  1.00 46.68           C  
ATOM    491  C   MET A  67      -6.247  53.962  26.989  1.00 46.95           C  
ATOM    492  O   MET A  67      -6.970  53.676  26.028  1.00 47.10           O  
ATOM    493  CB  MET A  67      -7.129  53.900  29.326  1.00 46.65           C  
ATOM    494  CG  MET A  67      -7.754  52.985  30.340  1.00 48.15           C  
ATOM    495  SD  MET A  67      -8.813  51.779  29.510  1.00 53.63           S  
ATOM    496  CE  MET A  67     -10.086  52.843  28.809  1.00 51.37           C  
ATOM    497  N   HIS A  68      -5.380  54.969  26.970  1.00 46.66           N  
ATOM    498  CA  HIS A  68      -5.207  55.812  25.796  1.00 46.69           C  
ATOM    499  C   HIS A  68      -4.680  54.998  24.616  1.00 47.03           C  
ATOM    500  O   HIS A  68      -5.126  55.177  23.482  1.00 48.17           O  
ATOM    501  CB  HIS A  68      -4.242  56.954  26.125  1.00 47.05           C  
ATOM    502  CG  HIS A  68      -3.599  57.571  24.922  1.00 47.48           C  
ATOM    503  ND1 HIS A  68      -4.324  58.042  23.848  1.00 48.02           N  
ATOM    504  CD2 HIS A  68      -2.296  57.791  24.624  1.00 47.18           C  
ATOM    505  CE1 HIS A  68      -3.494  58.524  22.940  1.00 47.92           C  
ATOM    506  NE2 HIS A  68      -2.258  58.385  23.386  1.00 46.70           N  
ATOM    507  N   SER A  69      -3.732  54.103  24.882  1.00 47.00           N  
ATOM    508  CA  SER A  69      -3.162  53.271  23.827  1.00 46.68           C  
ATOM    509  C   SER A  69      -4.228  52.319  23.309  1.00 46.46           C  
ATOM    510  O   SER A  69      -4.324  52.078  22.106  1.00 45.04           O  
ATOM    511  CB  SER A  69      -1.966  52.473  24.357  1.00 47.49           C  
ATOM    512  OG  SER A  69      -1.279  51.822  23.300  1.00 47.66           O  
ATOM    513  N   GLN A  70      -5.029  51.783  24.227  1.00 46.93           N  
ATOM    514  CA  GLN A  70      -6.103  50.861  23.866  1.00 47.94           C  
ATOM    515  C   GLN A  70      -7.089  51.583  22.965  1.00 48.74           C  
ATOM    516  O   GLN A  70      -7.683  50.998  22.057  1.00 48.84           O  
ATOM    517  CB  GLN A  70      -6.830  50.363  25.116  1.00 47.11           C  
ATOM    518  CG  GLN A  70      -8.050  49.512  24.803  1.00 46.12           C  
ATOM    519  CD  GLN A  70      -8.774  49.038  26.049  1.00 47.54           C  
ATOM    520  OE1 GLN A  70      -8.283  48.182  26.783  1.00 47.04           O  
ATOM    521  NE2 GLN A  70      -9.953  49.601  26.295  1.00 48.38           N  
ATOM    522  N   ARG A  71      -7.254  52.871  23.230  1.00 50.04           N  
ATOM    523  CA  ARG A  71      -8.162  53.698  22.456  1.00 50.47           C  
ATOM    524  C   ARG A  71      -7.617  53.830  21.039  1.00 49.24           C  
ATOM    525  O   ARG A  71      -8.352  53.667  20.066  1.00 50.57           O  
ATOM    526  CB  ARG A  71      -8.283  55.069  23.119  1.00 50.57           C  
ATOM    527  CG  ARG A  71      -9.692  55.624  23.182  1.00 50.91           C  
ATOM    528  CD  ARG A  71      -9.751  56.729  24.222  1.00 50.12           C  
ATOM    529  NE  ARG A  71      -9.731  56.182  25.577  1.00 49.54           N  
ATOM    530  CZ  ARG A  71      -9.086  56.729  26.603  1.00 50.34           C  
ATOM    531  NH1 ARG A  71      -8.385  57.847  26.438  1.00 48.48           N  
ATOM    532  NH2 ARG A  71      -9.155  56.160  27.805  1.00 50.89           N  
ATOM    533  N   LEU A  72      -6.319  54.101  20.930  1.00 46.84           N  
ATOM    534  CA  LEU A  72      -5.670  54.256  19.629  1.00 45.39           C  
ATOM    535  C   LEU A  72      -5.831  53.049  18.705  1.00 45.22           C  
ATOM    536  O   LEU A  72      -5.613  53.153  17.501  1.00 45.89           O  
ATOM    537  CB  LEU A  72      -4.179  54.541  19.815  1.00 43.58           C  
ATOM    538  CG  LEU A  72      -3.790  55.842  20.513  1.00 42.72           C  
ATOM    539  CD1 LEU A  72      -2.278  55.916  20.638  1.00 42.84           C  
ATOM    540  CD2 LEU A  72      -4.318  57.023  19.720  1.00 42.08           C  
ATOM    541  N   TYR A  73      -6.200  51.901  19.257  1.00 45.71           N  
ATOM    542  CA  TYR A  73      -6.368  50.709  18.435  1.00 45.47           C  
ATOM    543  C   TYR A  73      -7.656  50.752  17.625  1.00 46.50           C  
ATOM    544  O   TYR A  73      -7.816  50.002  16.665  1.00 46.79           O  
ATOM    545  CB  TYR A  73      -6.330  49.447  19.305  1.00 41.67           C  
ATOM    546  CG  TYR A  73      -4.983  48.758  19.320  1.00 39.27           C  
ATOM    547  CD1 TYR A  73      -4.521  48.057  18.201  1.00 38.58           C  
ATOM    548  CD2 TYR A  73      -4.170  48.805  20.450  1.00 37.99           C  
ATOM    549  CE1 TYR A  73      -3.276  47.416  18.213  1.00 36.18           C  
ATOM    550  CE2 TYR A  73      -2.930  48.174  20.477  1.00 35.99           C  
ATOM    551  CZ  TYR A  73      -2.487  47.478  19.360  1.00 36.31           C  
ATOM    552  OH  TYR A  73      -1.266  46.839  19.405  1.00 33.64           O  
ATOM    553  N   LYS A  74      -8.573  51.630  18.016  1.00 49.14           N  
ATOM    554  CA  LYS A  74      -9.841  51.759  17.307  1.00 50.86           C  
ATOM    555  C   LYS A  74      -9.542  52.301  15.914  1.00 50.89           C  
ATOM    556  O   LYS A  74      -9.096  53.444  15.760  1.00 51.63           O  
ATOM    557  CB  LYS A  74     -10.775  52.712  18.055  1.00 52.43           C  
ATOM    558  CG  LYS A  74     -12.175  52.792  17.462  1.00 58.69           C  
ATOM    559  CD  LYS A  74     -13.082  53.783  18.209  1.00 62.79           C  
ATOM    560  CE  LYS A  74     -13.446  53.307  19.625  1.00 65.03           C  
ATOM    561  NZ  LYS A  74     -12.275  53.218  20.557  1.00 66.24           N  
ATOM    562  N   GLY A  75      -9.759  51.469  14.902  1.00 49.66           N  
ATOM    563  CA  GLY A  75      -9.498  51.895  13.538  1.00 49.42           C  
ATOM    564  C   GLY A  75      -8.088  51.647  13.024  1.00 48.73           C  
ATOM    565  O   GLY A  75      -7.839  51.736  11.818  1.00 48.08           O  
ATOM    566  N   LEU A  76      -7.159  51.336  13.923  1.00 48.21           N  
ATOM    567  CA  LEU A  76      -5.785  51.088  13.516  1.00 48.35           C  
ATOM    568  C   LEU A  76      -5.683  49.964  12.487  1.00 49.45           C  
ATOM    569  O   LEU A  76      -4.911  50.058  11.535  1.00 49.89           O  
ATOM    570  CB  LEU A  76      -4.926  50.756  14.734  1.00 48.12           C  
ATOM    571  CG  LEU A  76      -3.437  50.520  14.468  1.00 49.07           C  
ATOM    572  CD1 LEU A  76      -2.838  51.676  13.677  1.00 48.98           C  
ATOM    573  CD2 LEU A  76      -2.722  50.354  15.798  1.00 50.25           C  
ATOM    574  N   GLY A  77      -6.470  48.906  12.677  1.00 50.25           N  
ATOM    575  CA  GLY A  77      -6.444  47.786  11.753  1.00 49.40           C  
ATOM    576  C   GLY A  77      -6.689  48.187  10.310  1.00 50.30           C  
ATOM    577  O   GLY A  77      -5.900  47.858   9.423  1.00 50.40           O  
ATOM    578  N   GLU A  78      -7.786  48.902  10.081  1.00 51.42           N  
ATOM    579  CA  GLU A  78      -8.177  49.367   8.749  1.00 51.82           C  
ATOM    580  C   GLU A  78      -7.124  50.298   8.160  1.00 51.34           C  
ATOM    581  O   GLU A  78      -6.766  50.191   6.985  1.00 51.25           O  
ATOM    582  CB  GLU A  78      -9.519  50.105   8.827  1.00 53.28           C  
ATOM    583  CG  GLU A  78     -10.653  49.284   9.438  1.00 58.36           C  
ATOM    584  CD  GLU A  78     -10.288  48.682  10.796  1.00 60.85           C  
ATOM    585  OE1 GLU A  78     -10.019  49.448  11.750  1.00 60.30           O  
ATOM    586  OE2 GLU A  78     -10.259  47.434  10.902  1.00 62.85           O  
ATOM    587  N   GLU A  79      -6.635  51.214   8.989  1.00 50.47           N  
ATOM    588  CA  GLU A  79      -5.621  52.174   8.581  1.00 49.49           C  
ATOM    589  C   GLU A  79      -4.359  51.494   8.053  1.00 49.55           C  
ATOM    590  O   GLU A  79      -3.807  51.895   7.025  1.00 51.22           O  
ATOM    591  CB  GLU A  79      -5.276  53.078   9.766  1.00 49.13           C  
ATOM    592  CG  GLU A  79      -4.032  53.912   9.576  1.00 51.73           C  
ATOM    593  CD  GLU A  79      -3.814  54.887  10.716  1.00 54.41           C  
ATOM    594  OE1 GLU A  79      -2.683  55.413  10.848  1.00 54.00           O  
ATOM    595  OE2 GLU A  79      -4.778  55.133  11.477  1.00 56.36           O  
ATOM    596  N   LEU A  80      -3.905  50.462   8.752  1.00 48.14           N  
ATOM    597  CA  LEU A  80      -2.708  49.746   8.343  1.00 46.37           C  
ATOM    598  C   LEU A  80      -2.987  48.796   7.185  1.00 45.43           C  
ATOM    599  O   LEU A  80      -2.103  48.526   6.369  1.00 44.12           O  
ATOM    600  CB  LEU A  80      -2.127  48.975   9.533  1.00 47.36           C  
ATOM    601  CG  LEU A  80      -1.611  49.839  10.687  1.00 46.66           C  
ATOM    602  CD1 LEU A  80      -1.266  48.959  11.876  1.00 44.80           C  
ATOM    603  CD2 LEU A  80      -0.396  50.634  10.224  1.00 47.10           C  
ATOM    604  N   TYR A  81      -4.210  48.280   7.109  1.00 44.41           N  
ATOM    605  CA  TYR A  81      -4.543  47.375   6.020  1.00 45.41           C  
ATOM    606  C   TYR A  81      -4.420  48.129   4.705  1.00 45.54           C  
ATOM    607  O   TYR A  81      -3.743  47.688   3.783  1.00 44.96           O  
ATOM    608  CB  TYR A  81      -5.964  46.840   6.155  1.00 44.36           C  
ATOM    609  CG  TYR A  81      -6.268  45.760   5.140  1.00 46.17           C  
ATOM    610  CD1 TYR A  81      -5.524  44.579   5.116  1.00 46.93           C  
ATOM    611  CD2 TYR A  81      -7.287  45.918   4.194  1.00 46.35           C  
ATOM    612  CE1 TYR A  81      -5.783  43.574   4.177  1.00 48.71           C  
ATOM    613  CE2 TYR A  81      -7.560  44.918   3.245  1.00 47.64           C  
ATOM    614  CZ  TYR A  81      -6.799  43.747   3.244  1.00 49.61           C  
ATOM    615  OH  TYR A  81      -7.036  42.749   2.323  1.00 48.00           O  
ATOM    616  N   ALA A  82      -5.082  49.277   4.645  1.00 46.65           N  
ATOM    617  CA  ALA A  82      -5.080  50.135   3.467  1.00 48.47           C  
ATOM    618  C   ALA A  82      -3.684  50.307   2.867  1.00 49.59           C  
ATOM    619  O   ALA A  82      -3.521  50.322   1.643  1.00 50.07           O  
ATOM    620  CB  ALA A  82      -5.661  51.504   3.830  1.00 46.24           C  
ATOM    621  N   LEU A  83      -2.685  50.432   3.736  1.00 49.84           N  
ATOM    622  CA  LEU A  83      -1.303  50.633   3.312  1.00 50.18           C  
ATOM    623  C   LEU A  83      -0.449  49.368   3.258  1.00 50.77           C  
ATOM    624  O   LEU A  83       0.533  49.313   2.513  1.00 50.91           O  
ATOM    625  CB  LEU A  83      -0.623  51.637   4.248  1.00 50.65           C  
ATOM    626  CG  LEU A  83      -1.002  53.116   4.135  1.00 51.28           C  
ATOM    627  CD1 LEU A  83      -0.665  53.858   5.426  1.00 49.61           C  
ATOM    628  CD2 LEU A  83      -0.267  53.721   2.946  1.00 50.57           C  
ATOM    629  N   SER A  84      -0.819  48.356   4.040  1.00 50.21           N  
ATOM    630  CA  SER A  84      -0.042  47.123   4.105  1.00 48.62           C  
ATOM    631  C   SER A  84      -0.576  45.933   3.342  1.00 46.50           C  
ATOM    632  O   SER A  84       0.188  45.181   2.735  1.00 46.65           O  
ATOM    633  CB  SER A  84       0.139  46.703   5.565  1.00 49.48           C  
ATOM    634  OG  SER A  84       0.973  47.618   6.243  1.00 54.02           O  
ATOM    635  N   GLY A  85      -1.885  45.750   3.382  1.00 44.02           N  
ATOM    636  CA  GLY A  85      -2.458  44.599   2.725  1.00 41.88           C  
ATOM    637  C   GLY A  85      -2.393  43.458   3.721  1.00 39.81           C  
ATOM    638  O   GLY A  85      -2.655  42.307   3.377  1.00 40.00           O  
ATOM    639  N   VAL A  86      -2.042  43.789   4.964  1.00 38.85           N  
ATOM    640  CA  VAL A  86      -1.943  42.799   6.040  1.00 36.44           C  
ATOM    641  C   VAL A  86      -3.040  42.985   7.086  1.00 35.48           C  
ATOM    642  O   VAL A  86      -3.202  44.068   7.652  1.00 35.11           O  
ATOM    643  CB  VAL A  86      -0.587  42.886   6.777  1.00 36.15           C  
ATOM    644  CG1 VAL A  86      -0.465  41.739   7.762  1.00 34.85           C  
ATOM    645  CG2 VAL A  86       0.564  42.862   5.783  1.00 35.60           C  
ATOM    646  N   ASP A  87      -3.791  41.923   7.338  1.00 34.28           N  
ATOM    647  CA  ASP A  87      -4.859  41.956   8.331  1.00 35.71           C  
ATOM    648  C   ASP A  87      -4.242  41.692   9.714  1.00 35.31           C  
ATOM    649  O   ASP A  87      -3.486  40.731   9.874  1.00 36.50           O  
ATOM    650  CB  ASP A  87      -5.886  40.874   7.999  1.00 38.52           C  
ATOM    651  CG  ASP A  87      -6.985  40.777   9.029  1.00 41.53           C  
ATOM    652  OD1 ASP A  87      -7.725  39.768   9.024  1.00 42.39           O  
ATOM    653  OD2 ASP A  87      -7.113  41.716   9.839  1.00 46.19           O  
ATOM    654  N   ILE A  88      -4.547  42.526  10.708  1.00 34.32           N  
ATOM    655  CA  ILE A  88      -3.975  42.308  12.040  1.00 34.55           C  
ATOM    656  C   ILE A  88      -4.738  41.263  12.843  1.00 35.05           C  
ATOM    657  O   ILE A  88      -4.327  40.903  13.943  1.00 36.74           O  
ATOM    658  CB  ILE A  88      -3.899  43.606  12.884  1.00 34.10           C  
ATOM    659  CG1 ILE A  88      -5.283  44.240  13.021  1.00 33.34           C  
ATOM    660  CG2 ILE A  88      -2.905  44.575  12.264  1.00 33.92           C  
ATOM    661  CD1 ILE A  88      -5.338  45.331  14.081  1.00 28.87           C  
ATOM    662  N   ARG A  89      -5.844  40.778  12.284  1.00 34.38           N  
ATOM    663  CA  ARG A  89      -6.661  39.757  12.926  1.00 34.16           C  
ATOM    664  C   ARG A  89      -7.184  40.154  14.311  1.00 35.23           C  
ATOM    665  O   ARG A  89      -6.916  39.491  15.313  1.00 36.10           O  
ATOM    666  CB  ARG A  89      -5.869  38.450  13.018  1.00 34.43           C  
ATOM    667  CG  ARG A  89      -5.351  37.932  11.679  1.00 34.18           C  
ATOM    668  CD  ARG A  89      -4.519  36.667  11.857  1.00 33.64           C  
ATOM    669  NE  ARG A  89      -4.031  36.144  10.585  1.00 35.25           N  
ATOM    670  CZ  ARG A  89      -3.346  35.012  10.440  1.00 35.41           C  
ATOM    671  NH1 ARG A  89      -3.055  34.261  11.492  1.00 35.67           N  
ATOM    672  NH2 ARG A  89      -2.953  34.628   9.233  1.00 36.32           N  
ATOM    673  N   GLN A  90      -7.938  41.241  14.365  1.00 35.67           N  
ATOM    674  CA  GLN A  90      -8.501  41.699  15.621  1.00 37.12           C  
ATOM    675  C   GLN A  90      -9.764  40.904  15.974  1.00 37.42           C  
ATOM    676  O   GLN A  90     -10.607  40.644  15.119  1.00 36.58           O  
ATOM    677  CB  GLN A  90      -8.824  43.193  15.532  1.00 38.74           C  
ATOM    678  CG  GLN A  90      -9.415  43.781  16.799  1.00 41.86           C  
ATOM    679  CD  GLN A  90      -9.470  45.295  16.763  1.00 44.41           C  
ATOM    680  OE1 GLN A  90     -10.047  45.934  17.650  1.00 46.70           O  
ATOM    681  NE2 GLN A  90      -8.863  45.882  15.737  1.00 45.66           N  
ATOM    682  N   HIS A  91      -9.875  40.518  17.243  1.00 37.86           N  
ATOM    683  CA  HIS A  91     -11.015  39.759  17.745  1.00 36.48           C  
ATOM    684  C   HIS A  91     -11.625  40.552  18.898  1.00 37.62           C  
ATOM    685  O   HIS A  91     -10.971  40.774  19.914  1.00 37.90           O  
ATOM    686  CB  HIS A  91     -10.544  38.395  18.233  1.00 33.23           C  
ATOM    687  CG  HIS A  91     -11.647  37.506  18.712  1.00 32.28           C  
ATOM    688  ND1 HIS A  91     -12.605  37.925  19.608  1.00 33.28           N  
ATOM    689  CD2 HIS A  91     -11.929  36.210  18.438  1.00 32.55           C  
ATOM    690  CE1 HIS A  91     -13.431  36.925  19.867  1.00 32.50           C  
ATOM    691  NE2 HIS A  91     -13.042  35.873  19.170  1.00 31.28           N  
ATOM    692  N   ASN A  92     -12.881  40.967  18.740  1.00 39.57           N  
ATOM    693  CA  ASN A  92     -13.564  41.778  19.751  1.00 41.04           C  
ATOM    694  C   ASN A  92     -14.456  41.060  20.765  1.00 40.95           C  
ATOM    695  O   ASN A  92     -15.332  41.678  21.368  1.00 41.68           O  
ATOM    696  CB  ASN A  92     -14.378  42.871  19.055  1.00 41.38           C  
ATOM    697  CG  ASN A  92     -13.513  43.786  18.198  1.00 43.86           C  
ATOM    698  OD1 ASN A  92     -12.557  44.399  18.685  1.00 42.81           O  
ATOM    699  ND2 ASN A  92     -13.848  43.883  16.911  1.00 43.00           N  
ATOM    700  N   GLY A  93     -14.223  39.774  20.982  1.00 41.02           N  
ATOM    701  CA  GLY A  93     -15.042  39.040  21.929  1.00 40.19           C  
ATOM    702  C   GLY A  93     -15.094  39.608  23.339  1.00 39.53           C  
ATOM    703  O   GLY A  93     -16.103  39.477  24.029  1.00 40.67           O  
ATOM    704  N   GLY A  94     -14.017  40.247  23.777  1.00 38.44           N  
ATOM    705  CA  GLY A  94     -14.000  40.783  25.124  1.00 36.98           C  
ATOM    706  C   GLY A  94     -13.308  39.793  26.039  1.00 35.49           C  
ATOM    707  O   GLY A  94     -12.851  38.747  25.582  1.00 35.04           O  
ATOM    708  N   MET A  95     -13.257  40.089  27.331  1.00 34.58           N  
ATOM    709  CA  MET A  95     -12.567  39.203  28.260  1.00 35.35           C  
ATOM    710  C   MET A  95     -13.301  38.881  29.563  1.00 36.13           C  
ATOM    711  O   MET A  95     -13.949  39.740  30.151  1.00 38.42           O  
ATOM    712  CB  MET A  95     -11.206  39.823  28.586  1.00 33.92           C  
ATOM    713  CG  MET A  95     -10.339  39.031  29.547  1.00 33.18           C  
ATOM    714  SD  MET A  95      -8.900  40.001  30.084  1.00 37.21           S  
ATOM    715  CE  MET A  95      -7.800  39.819  28.647  1.00 29.86           C  
ATOM    716  N   PHE A  96     -13.181  37.635  30.013  1.00 36.50           N  
ATOM    717  CA  PHE A  96     -13.781  37.201  31.272  1.00 36.45           C  
ATOM    718  C   PHE A  96     -12.661  36.941  32.278  1.00 36.69           C  
ATOM    719  O   PHE A  96     -12.060  35.871  32.263  1.00 36.36           O  
ATOM    720  CB  PHE A  96     -14.560  35.884  31.120  1.00 39.26           C  
ATOM    721  CG  PHE A  96     -16.034  36.049  30.841  1.00 41.73           C  
ATOM    722  CD1 PHE A  96     -16.749  37.133  31.348  1.00 44.31           C  
ATOM    723  CD2 PHE A  96     -16.720  35.078  30.113  1.00 41.86           C  
ATOM    724  CE1 PHE A  96     -18.128  37.245  31.132  1.00 44.61           C  
ATOM    725  CE2 PHE A  96     -18.086  35.178  29.892  1.00 42.72           C  
ATOM    726  CZ  PHE A  96     -18.795  36.262  30.402  1.00 44.09           C  
ATOM    727  N   LYS A  97     -12.359  37.909  33.135  1.00 36.16           N  
ATOM    728  CA  LYS A  97     -11.336  37.693  34.148  1.00 36.49           C  
ATOM    729  C   LYS A  97     -11.997  36.822  35.218  1.00 37.07           C  
ATOM    730  O   LYS A  97     -12.729  37.330  36.063  1.00 39.25           O  
ATOM    731  CB  LYS A  97     -10.888  39.020  34.767  1.00 36.84           C  
ATOM    732  CG  LYS A  97     -10.037  39.890  33.865  1.00 38.74           C  
ATOM    733  CD  LYS A  97      -9.515  41.119  34.609  1.00 40.72           C  
ATOM    734  CE  LYS A  97      -8.594  41.977  33.738  1.00 43.34           C  
ATOM    735  NZ  LYS A  97      -7.267  41.336  33.440  1.00 44.32           N  
ATOM    736  N   LEU A  98     -11.740  35.517  35.184  1.00 35.70           N  
ATOM    737  CA  LEU A  98     -12.342  34.586  36.136  1.00 34.54           C  
ATOM    738  C   LEU A  98     -11.918  34.749  37.595  1.00 35.98           C  
ATOM    739  O   LEU A  98     -10.827  35.232  37.903  1.00 35.74           O  
ATOM    740  CB  LEU A  98     -12.063  33.142  35.708  1.00 31.77           C  
ATOM    741  CG  LEU A  98     -12.288  32.752  34.247  1.00 29.99           C  
ATOM    742  CD1 LEU A  98     -12.019  31.259  34.094  1.00 29.71           C  
ATOM    743  CD2 LEU A  98     -13.702  33.092  33.816  1.00 27.79           C  
ATOM    744  N   ALA A  99     -12.799  34.308  38.488  1.00 37.82           N  
ATOM    745  CA  ALA A  99     -12.568  34.359  39.928  1.00 38.11           C  
ATOM    746  C   ALA A  99     -12.744  32.951  40.473  1.00 38.58           C  
ATOM    747  O   ALA A  99     -13.713  32.269  40.128  1.00 38.06           O  
ATOM    748  CB  ALA A  99     -13.574  35.304  40.588  1.00 38.20           C  
ATOM    749  N   PHE A 100     -11.809  32.511  41.312  1.00 38.93           N  
ATOM    750  CA  PHE A 100     -11.894  31.175  41.890  1.00 40.48           C  
ATOM    751  C   PHE A 100     -11.943  31.217  43.413  1.00 42.06           C  
ATOM    752  O   PHE A 100     -11.773  30.200  44.082  1.00 40.94           O  
ATOM    753  CB  PHE A 100     -10.712  30.307  41.434  1.00 39.67           C  
ATOM    754  CG  PHE A 100     -10.826  29.813  40.016  1.00 39.74           C  
ATOM    755  CD1 PHE A 100     -10.418  30.608  38.947  1.00 39.63           C  
ATOM    756  CD2 PHE A 100     -11.362  28.556  39.747  1.00 38.84           C  
ATOM    757  CE1 PHE A 100     -10.547  30.153  37.631  1.00 37.93           C  
ATOM    758  CE2 PHE A 100     -11.493  28.097  38.436  1.00 38.61           C  
ATOM    759  CZ  PHE A 100     -11.084  28.898  37.377  1.00 37.32           C  
ATOM    760  N   SER A 101     -12.186  32.402  43.957  1.00 45.91           N  
ATOM    761  CA  SER A 101     -12.259  32.576  45.404  1.00 49.53           C  
ATOM    762  C   SER A 101     -12.920  33.906  45.748  1.00 52.29           C  
ATOM    763  O   SER A 101     -13.163  34.740  44.871  1.00 52.80           O  
ATOM    764  CB  SER A 101     -10.861  32.546  46.012  1.00 48.72           C  
ATOM    765  OG  SER A 101     -10.140  33.705  45.631  1.00 50.32           O  
ATOM    766  N   GLU A 102     -13.210  34.102  47.031  1.00 54.77           N  
ATOM    767  CA  GLU A 102     -13.834  35.339  47.474  1.00 56.23           C  
ATOM    768  C   GLU A 102     -12.863  36.494  47.310  1.00 55.63           C  
ATOM    769  O   GLU A 102     -13.249  37.572  46.866  1.00 55.82           O  
ATOM    770  CB  GLU A 102     -14.281  35.219  48.932  1.00 59.02           C  
ATOM    771  CG  GLU A 102     -15.456  34.262  49.130  1.00 62.33           C  
ATOM    772  CD  GLU A 102     -16.705  34.689  48.359  1.00 63.76           C  
ATOM    773  OE1 GLU A 102     -17.691  33.916  48.343  1.00 63.23           O  
ATOM    774  OE2 GLU A 102     -16.701  35.799  47.775  1.00 64.36           O  
ATOM    775  N   GLU A 103     -11.600  36.265  47.662  1.00 55.03           N  
ATOM    776  CA  GLU A 103     -10.579  37.297  47.521  1.00 55.33           C  
ATOM    777  C   GLU A 103     -10.522  37.720  46.058  1.00 54.61           C  
ATOM    778  O   GLU A 103     -10.374  38.903  45.748  1.00 54.62           O  
ATOM    779  CB  GLU A 103      -9.207  36.776  47.954  1.00 57.33           C  
ATOM    780  CG  GLU A 103      -9.127  36.344  49.416  1.00 62.07           C  
ATOM    781  CD  GLU A 103      -9.565  34.904  49.641  1.00 64.71           C  
ATOM    782  OE1 GLU A 103     -10.635  34.508  49.120  1.00 66.04           O  
ATOM    783  OE2 GLU A 103      -8.838  34.171  50.348  1.00 65.94           O  
ATOM    784  N   ASP A 104     -10.644  36.744  45.161  1.00 52.86           N  
ATOM    785  CA  ASP A 104     -10.626  37.029  43.736  1.00 51.66           C  
ATOM    786  C   ASP A 104     -11.769  37.984  43.435  1.00 51.24           C  
ATOM    787  O   ASP A 104     -11.589  38.983  42.739  1.00 51.81           O  
ATOM    788  CB  ASP A 104     -10.798  35.740  42.916  1.00 51.96           C  
ATOM    789  CG  ASP A 104      -9.477  35.013  42.653  1.00 50.01           C  
ATOM    790  OD1 ASP A 104      -9.523  33.862  42.172  1.00 48.48           O  
ATOM    791  OD2 ASP A 104      -8.400  35.586  42.914  1.00 48.95           O  
ATOM    792  N   VAL A 105     -12.946  37.675  43.972  1.00 50.73           N  
ATOM    793  CA  VAL A 105     -14.128  38.505  43.758  1.00 50.55           C  
ATOM    794  C   VAL A 105     -13.914  39.902  44.328  1.00 50.39           C  
ATOM    795  O   VAL A 105     -14.174  40.906  43.665  1.00 48.69           O  
ATOM    796  CB  VAL A 105     -15.374  37.889  44.428  1.00 51.10           C  
ATOM    797  CG1 VAL A 105     -16.599  38.722  44.090  1.00 50.17           C  
ATOM    798  CG2 VAL A 105     -15.561  36.447  43.968  1.00 50.87           C  
ATOM    799  N   LEU A 106     -13.444  39.959  45.569  1.00 50.89           N  
ATOM    800  CA  LEU A 106     -13.183  41.235  46.215  1.00 52.44           C  
ATOM    801  C   LEU A 106     -12.281  42.060  45.311  1.00 51.83           C  
ATOM    802  O   LEU A 106     -12.615  43.188  44.949  1.00 52.78           O  
ATOM    803  CB  LEU A 106     -12.508  41.013  47.573  1.00 54.33           C  
ATOM    804  CG  LEU A 106     -13.399  40.793  48.806  1.00 55.30           C  
ATOM    805  CD1 LEU A 106     -14.546  39.838  48.489  1.00 55.61           C  
ATOM    806  CD2 LEU A 106     -12.540  40.260  49.954  1.00 54.55           C  
ATOM    807  N   GLN A 107     -11.148  41.481  44.934  1.00 50.80           N  
ATOM    808  CA  GLN A 107     -10.199  42.161  44.069  1.00 50.49           C  
ATOM    809  C   GLN A 107     -10.804  42.561  42.719  1.00 49.15           C  
ATOM    810  O   GLN A 107     -10.710  43.719  42.317  1.00 48.86           O  
ATOM    811  CB  GLN A 107      -8.973  41.274  43.860  1.00 53.03           C  
ATOM    812  CG  GLN A 107      -7.854  41.920  43.053  1.00 58.42           C  
ATOM    813  CD  GLN A 107      -6.583  41.076  43.043  1.00 61.76           C  
ATOM    814  OE1 GLN A 107      -5.898  40.954  44.065  1.00 63.66           O  
ATOM    815  NE2 GLN A 107      -6.270  40.479  41.893  1.00 61.08           N  
ATOM    816  N   LEU A 108     -11.435  41.621  42.022  1.00 47.73           N  
ATOM    817  CA  LEU A 108     -12.021  41.931  40.720  1.00 48.29           C  
ATOM    818  C   LEU A 108     -13.188  42.915  40.755  1.00 51.66           C  
ATOM    819  O   LEU A 108     -13.398  43.660  39.789  1.00 52.77           O  
ATOM    820  CB  LEU A 108     -12.473  40.650  40.016  1.00 45.44           C  
ATOM    821  CG  LEU A 108     -11.383  39.693  39.527  1.00 43.70           C  
ATOM    822  CD1 LEU A 108     -12.023  38.431  39.003  1.00 41.97           C  
ATOM    823  CD2 LEU A 108     -10.554  40.354  38.452  1.00 39.67           C  
ATOM    824  N   ARG A 109     -13.954  42.922  41.849  1.00 53.75           N  
ATOM    825  CA  ARG A 109     -15.094  43.833  41.953  1.00 53.93           C  
ATOM    826  C   ARG A 109     -14.616  45.279  42.022  1.00 53.95           C  
ATOM    827  O   ARG A 109     -15.301  46.189  41.557  1.00 53.38           O  
ATOM    828  CB  ARG A 109     -15.943  43.536  43.197  1.00 55.76           C  
ATOM    829  CG  ARG A 109     -16.631  42.164  43.250  1.00 56.62           C  
ATOM    830  CD  ARG A 109     -17.563  41.910  42.075  1.00 56.20           C  
ATOM    831  NE  ARG A 109     -18.785  42.716  42.076  1.00 54.61           N  
ATOM    832  CZ  ARG A 109     -19.926  42.379  42.676  1.00 52.08           C  
ATOM    833  NH1 ARG A 109     -20.031  41.241  43.351  1.00 49.32           N  
ATOM    834  NH2 ARG A 109     -20.983  43.174  42.566  1.00 49.51           N  
ATOM    835  N   GLN A 110     -13.436  45.490  42.593  1.00 53.82           N  
ATOM    836  CA  GLN A 110     -12.902  46.836  42.727  1.00 55.49           C  
ATOM    837  C   GLN A 110     -12.891  47.666  41.450  1.00 56.48           C  
ATOM    838  O   GLN A 110     -12.706  48.878  41.507  1.00 57.06           O  
ATOM    839  CB  GLN A 110     -11.495  46.799  43.312  1.00 56.21           C  
ATOM    840  CG  GLN A 110     -11.421  46.186  44.694  1.00 59.07           C  
ATOM    841  CD  GLN A 110     -10.121  46.518  45.407  1.00 61.50           C  
ATOM    842  OE1 GLN A 110      -9.029  46.293  44.878  1.00 61.78           O  
ATOM    843  NE2 GLN A 110     -10.234  47.059  46.617  1.00 62.12           N  
ATOM    844  N   MET A 111     -13.082  47.038  40.296  1.00 58.49           N  
ATOM    845  CA  MET A 111     -13.088  47.814  39.061  1.00 60.27           C  
ATOM    846  C   MET A 111     -14.474  47.914  38.430  1.00 60.78           C  
ATOM    847  O   MET A 111     -14.609  48.250  37.252  1.00 60.99           O  
ATOM    848  CB  MET A 111     -12.063  47.254  38.058  1.00 61.70           C  
ATOM    849  CG  MET A 111     -12.136  45.759  37.769  1.00 64.99           C  
ATOM    850  SD  MET A 111     -10.710  45.185  36.756  1.00 66.05           S  
ATOM    851  CE  MET A 111     -11.347  45.450  35.100  1.00 66.75           C  
ATOM    852  N   ASP A 112     -15.501  47.641  39.235  1.00 61.58           N  
ATOM    853  CA  ASP A 112     -16.894  47.705  38.786  1.00 61.52           C  
ATOM    854  C   ASP A 112     -17.285  49.113  38.357  1.00 61.40           C  
ATOM    855  O   ASP A 112     -18.099  49.292  37.449  1.00 61.30           O  
ATOM    856  CB  ASP A 112     -17.839  47.250  39.901  1.00 61.02           C  
ATOM    857  CG  ASP A 112     -18.084  45.752  39.889  1.00 62.13           C  
ATOM    858  OD1 ASP A 112     -18.672  45.257  38.899  1.00 61.62           O  
ATOM    859  OD2 ASP A 112     -17.695  45.074  40.867  1.00 61.50           O  
ATOM    860  N   ASP A 113     -16.698  50.106  39.017  1.00 61.53           N  
ATOM    861  CA  ASP A 113     -16.983  51.501  38.712  1.00 62.42           C  
ATOM    862  C   ASP A 113     -16.401  51.950  37.379  1.00 62.92           C  
ATOM    863  O   ASP A 113     -16.613  53.089  36.960  1.00 63.75           O  
ATOM    864  CB  ASP A 113     -16.468  52.413  39.831  1.00 63.16           C  
ATOM    865  CG  ASP A 113     -14.989  52.224  40.114  1.00 65.02           C  
ATOM    866  OD1 ASP A 113     -14.603  51.129  40.577  1.00 66.50           O  
ATOM    867  OD2 ASP A 113     -14.212  53.176  39.880  1.00 65.17           O  
ATOM    868  N   LEU A 114     -15.667  51.062  36.715  1.00 62.51           N  
ATOM    869  CA  LEU A 114     -15.079  51.396  35.425  1.00 61.76           C  
ATOM    870  C   LEU A 114     -16.095  51.190  34.305  1.00 62.01           C  
ATOM    871  O   LEU A 114     -16.991  50.352  34.407  1.00 61.35           O  
ATOM    872  CB  LEU A 114     -13.823  50.553  35.174  1.00 60.08           C  
ATOM    873  CG  LEU A 114     -12.610  50.901  36.047  1.00 59.78           C  
ATOM    874  CD1 LEU A 114     -11.510  49.880  35.834  1.00 58.59           C  
ATOM    875  CD2 LEU A 114     -12.113  52.299  35.713  1.00 57.21           C  
ATOM    876  N   ASP A 115     -15.940  51.975  33.244  1.00 62.50           N  
ATOM    877  CA  ASP A 115     -16.819  51.943  32.076  1.00 63.54           C  
ATOM    878  C   ASP A 115     -16.523  50.747  31.163  1.00 62.94           C  
ATOM    879  O   ASP A 115     -15.362  50.401  30.926  1.00 62.15           O  
ATOM    880  CB  ASP A 115     -16.640  53.250  31.306  1.00 67.18           C  
ATOM    881  CG  ASP A 115     -16.467  54.449  32.235  1.00 71.81           C  
ATOM    882  OD1 ASP A 115     -17.488  54.966  32.748  1.00 73.13           O  
ATOM    883  OD2 ASP A 115     -15.304  54.859  32.469  1.00 72.61           O  
ATOM    884  N   SER A 116     -17.583  50.131  30.643  1.00 61.55           N  
ATOM    885  CA  SER A 116     -17.456  48.966  29.767  1.00 60.86           C  
ATOM    886  C   SER A 116     -16.931  47.757  30.526  1.00 59.63           C  
ATOM    887  O   SER A 116     -16.551  46.750  29.927  1.00 59.87           O  
ATOM    888  CB  SER A 116     -16.536  49.264  28.576  1.00 61.71           C  
ATOM    889  OG  SER A 116     -17.258  49.834  27.498  1.00 62.22           O  
ATOM    890  N   VAL A 117     -16.902  47.867  31.848  1.00 57.55           N  
ATOM    891  CA  VAL A 117     -16.447  46.777  32.697  1.00 56.16           C  
ATOM    892  C   VAL A 117     -17.561  46.489  33.682  1.00 54.86           C  
ATOM    893  O   VAL A 117     -18.042  47.395  34.360  1.00 56.68           O  
ATOM    894  CB  VAL A 117     -15.181  47.159  33.490  1.00 56.93           C  
ATOM    895  CG1 VAL A 117     -14.766  46.004  34.394  1.00 56.78           C  
ATOM    896  CG2 VAL A 117     -14.056  47.518  32.534  1.00 56.95           C  
ATOM    897  N   SER A 118     -17.976  45.232  33.764  1.00 53.24           N  
ATOM    898  CA  SER A 118     -19.047  44.854  34.681  1.00 51.93           C  
ATOM    899  C   SER A 118     -18.879  43.444  35.229  1.00 50.41           C  
ATOM    900  O   SER A 118     -18.255  42.595  34.602  1.00 51.83           O  
ATOM    901  CB  SER A 118     -20.402  44.985  33.980  1.00 52.06           C  
ATOM    902  OG  SER A 118     -20.403  44.312  32.736  1.00 52.22           O  
ATOM    903  N   TRP A 119     -19.442  43.202  36.406  1.00 48.99           N  
ATOM    904  CA  TRP A 119     -19.348  41.897  37.049  1.00 47.17           C  
ATOM    905  C   TRP A 119     -20.451  40.927  36.625  1.00 46.75           C  
ATOM    906  O   TRP A 119     -21.584  41.330  36.380  1.00 47.69           O  
ATOM    907  CB  TRP A 119     -19.364  42.073  38.568  1.00 45.28           C  
ATOM    908  CG  TRP A 119     -19.346  40.791  39.329  1.00 44.50           C  
ATOM    909  CD1 TRP A 119     -20.406  40.185  39.927  1.00 45.57           C  
ATOM    910  CD2 TRP A 119     -18.211  39.954  39.579  1.00 44.04           C  
ATOM    911  NE1 TRP A 119     -20.006  39.024  40.542  1.00 44.89           N  
ATOM    912  CE2 TRP A 119     -18.662  38.858  40.342  1.00 44.42           C  
ATOM    913  CE3 TRP A 119     -16.855  40.024  39.233  1.00 43.73           C  
ATOM    914  CZ2 TRP A 119     -17.806  37.836  40.768  1.00 43.66           C  
ATOM    915  CZ3 TRP A 119     -16.003  39.008  39.658  1.00 43.10           C  
ATOM    916  CH2 TRP A 119     -16.484  37.929  40.416  1.00 43.29           C  
ATOM    917  N   TYR A 120     -20.093  39.649  36.529  1.00 45.88           N  
ATOM    918  CA  TYR A 120     -21.021  38.588  36.153  1.00 43.90           C  
ATOM    919  C   TYR A 120     -20.974  37.523  37.233  1.00 44.36           C  
ATOM    920  O   TYR A 120     -19.932  37.293  37.842  1.00 43.65           O  
ATOM    921  CB  TYR A 120     -20.620  37.948  34.821  1.00 42.73           C  
ATOM    922  CG  TYR A 120     -21.071  38.686  33.579  1.00 40.38           C  
ATOM    923  CD1 TYR A 120     -20.823  40.048  33.423  1.00 39.85           C  
ATOM    924  CD2 TYR A 120     -21.709  38.007  32.535  1.00 39.28           C  
ATOM    925  CE1 TYR A 120     -21.196  40.722  32.255  1.00 38.53           C  
ATOM    926  CE2 TYR A 120     -22.085  38.674  31.363  1.00 39.08           C  
ATOM    927  CZ  TYR A 120     -21.822  40.031  31.232  1.00 38.51           C  
ATOM    928  OH  TYR A 120     -22.163  40.700  30.077  1.00 39.68           O  
ATOM    929  N   SER A 121     -22.104  36.869  37.460  1.00 45.67           N  
ATOM    930  CA  SER A 121     -22.187  35.826  38.469  1.00 46.59           C  
ATOM    931  C   SER A 121     -21.824  34.474  37.866  1.00 47.05           C  
ATOM    932  O   SER A 121     -21.923  34.273  36.657  1.00 46.51           O  
ATOM    933  CB  SER A 121     -23.603  35.766  39.055  1.00 46.80           C  
ATOM    934  OG  SER A 121     -24.562  35.441  38.057  1.00 48.70           O  
ATOM    935  N   LYS A 122     -21.408  33.553  38.728  1.00 48.33           N  
ATOM    936  CA  LYS A 122     -21.021  32.211  38.322  1.00 50.18           C  
ATOM    937  C   LYS A 122     -21.990  31.598  37.316  1.00 52.10           C  
ATOM    938  O   LYS A 122     -21.593  30.795  36.475  1.00 53.72           O  
ATOM    939  CB  LYS A 122     -20.917  31.331  39.567  1.00 50.20           C  
ATOM    940  CG  LYS A 122     -20.437  29.916  39.337  1.00 49.37           C  
ATOM    941  CD  LYS A 122     -21.576  28.985  39.029  1.00 48.98           C  
ATOM    942  CE  LYS A 122     -21.121  27.533  39.129  1.00 50.12           C  
ATOM    943  NZ  LYS A 122     -20.573  27.215  40.479  1.00 49.33           N  
ATOM    944  N   GLU A 123     -23.258  31.989  37.393  1.00 54.15           N  
ATOM    945  CA  GLU A 123     -24.283  31.466  36.490  1.00 54.82           C  
ATOM    946  C   GLU A 123     -24.474  32.328  35.242  1.00 54.21           C  
ATOM    947  O   GLU A 123     -24.924  31.839  34.205  1.00 54.09           O  
ATOM    948  CB  GLU A 123     -25.618  31.317  37.237  1.00 55.58           C  
ATOM    949  CG  GLU A 123     -25.863  32.392  38.292  1.00 58.05           C  
ATOM    950  CD  GLU A 123     -25.090  32.144  39.581  1.00 58.49           C  
ATOM    951  OE1 GLU A 123     -24.801  33.125  40.301  1.00 57.16           O  
ATOM    952  OE2 GLU A 123     -24.783  30.963  39.875  1.00 58.47           O  
ATOM    953  N   GLU A 124     -24.134  33.608  35.346  1.00 54.05           N  
ATOM    954  CA  GLU A 124     -24.255  34.525  34.217  1.00 53.91           C  
ATOM    955  C   GLU A 124     -23.073  34.333  33.270  1.00 53.50           C  
ATOM    956  O   GLU A 124     -23.154  34.647  32.080  1.00 53.98           O  
ATOM    957  CB  GLU A 124     -24.302  35.972  34.717  1.00 55.81           C  
ATOM    958  CG  GLU A 124     -25.625  36.356  35.364  1.00 58.45           C  
ATOM    959  CD  GLU A 124     -25.594  37.727  36.023  1.00 60.30           C  
ATOM    960  OE1 GLU A 124     -25.123  38.694  35.387  1.00 60.59           O  
ATOM    961  OE2 GLU A 124     -26.056  37.836  37.178  1.00 62.32           O  
ATOM    962  N   VAL A 125     -21.972  33.819  33.812  1.00 52.07           N  
ATOM    963  CA  VAL A 125     -20.773  33.556  33.028  1.00 49.14           C  
ATOM    964  C   VAL A 125     -21.033  32.298  32.212  1.00 48.80           C  
ATOM    965  O   VAL A 125     -20.864  32.287  30.995  1.00 48.70           O  
ATOM    966  CB  VAL A 125     -19.549  33.316  33.935  1.00 48.05           C  
ATOM    967  CG1 VAL A 125     -18.365  32.858  33.110  1.00 46.78           C  
ATOM    968  CG2 VAL A 125     -19.201  34.589  34.680  1.00 47.74           C  
ATOM    969  N   LEU A 126     -21.463  31.244  32.894  1.00 48.28           N  
ATOM    970  CA  LEU A 126     -21.747  29.979  32.242  1.00 47.67           C  
ATOM    971  C   LEU A 126     -22.851  30.093  31.202  1.00 49.33           C  
ATOM    972  O   LEU A 126     -23.026  29.190  30.384  1.00 50.09           O  
ATOM    973  CB  LEU A 126     -22.115  28.928  33.283  1.00 46.40           C  
ATOM    974  CG  LEU A 126     -21.054  28.789  34.375  1.00 47.63           C  
ATOM    975  CD1 LEU A 126     -21.409  27.645  35.304  1.00 45.72           C  
ATOM    976  CD2 LEU A 126     -19.692  28.550  33.732  1.00 48.20           C  
ATOM    977  N   GLU A 127     -23.601  31.192  31.221  1.00 50.53           N  
ATOM    978  CA  GLU A 127     -24.657  31.358  30.229  1.00 51.64           C  
ATOM    979  C   GLU A 127     -24.009  31.746  28.905  1.00 51.18           C  
ATOM    980  O   GLU A 127     -24.454  31.330  27.832  1.00 50.61           O  
ATOM    981  CB  GLU A 127     -25.644  32.446  30.637  1.00 54.06           C  
ATOM    982  CG  GLU A 127     -26.943  32.388  29.839  1.00 57.56           C  
ATOM    983  CD  GLU A 127     -27.686  33.712  29.805  1.00 61.25           C  
ATOM    984  OE1 GLU A 127     -27.866  34.335  30.881  1.00 61.70           O  
ATOM    985  OE2 GLU A 127     -28.095  34.126  28.694  1.00 62.88           O  
ATOM    986  N   LYS A 128     -22.952  32.548  28.992  1.00 49.98           N  
ATOM    987  CA  LYS A 128     -22.222  32.991  27.812  1.00 48.36           C  
ATOM    988  C   LYS A 128     -21.172  31.955  27.420  1.00 45.23           C  
ATOM    989  O   LYS A 128     -21.038  31.604  26.249  1.00 45.34           O  
ATOM    990  CB  LYS A 128     -21.539  34.332  28.087  1.00 50.09           C  
ATOM    991  CG  LYS A 128     -22.498  35.483  28.337  1.00 52.62           C  
ATOM    992  CD  LYS A 128     -23.325  35.789  27.099  1.00 54.84           C  
ATOM    993  CE  LYS A 128     -24.232  36.991  27.332  1.00 57.69           C  
ATOM    994  NZ  LYS A 128     -25.142  36.794  28.506  1.00 59.14           N  
ATOM    995  N   GLU A 129     -20.433  31.475  28.413  1.00 41.58           N  
ATOM    996  CA  GLU A 129     -19.389  30.483  28.195  1.00 39.00           C  
ATOM    997  C   GLU A 129     -19.681  29.260  29.059  1.00 37.09           C  
ATOM    998  O   GLU A 129     -19.137  29.107  30.154  1.00 35.60           O  
ATOM    999  CB  GLU A 129     -18.017  31.068  28.549  1.00 39.38           C  
ATOM   1000  CG  GLU A 129     -17.597  32.286  27.708  1.00 40.34           C  
ATOM   1001  CD  GLU A 129     -17.564  32.014  26.202  1.00 41.49           C  
ATOM   1002  OE1 GLU A 129     -17.551  30.829  25.790  1.00 41.37           O  
ATOM   1003  OE2 GLU A 129     -17.536  32.997  25.429  1.00 40.26           O  
ATOM   1004  N   PRO A 130     -20.552  28.369  28.559  1.00 35.54           N  
ATOM   1005  CA  PRO A 130     -21.005  27.125  29.190  1.00 34.98           C  
ATOM   1006  C   PRO A 130     -19.913  26.195  29.675  1.00 35.53           C  
ATOM   1007  O   PRO A 130     -20.080  25.498  30.675  1.00 34.88           O  
ATOM   1008  CB  PRO A 130     -21.834  26.461  28.094  1.00 33.76           C  
ATOM   1009  CG  PRO A 130     -22.347  27.608  27.309  1.00 35.21           C  
ATOM   1010  CD  PRO A 130     -21.162  28.528  27.227  1.00 35.49           C  
ATOM   1011  N   TYR A 131     -18.792  26.178  28.961  1.00 36.96           N  
ATOM   1012  CA  TYR A 131     -17.703  25.273  29.301  1.00 34.45           C  
ATOM   1013  C   TYR A 131     -16.629  25.832  30.204  1.00 32.58           C  
ATOM   1014  O   TYR A 131     -15.641  25.158  30.467  1.00 33.84           O  
ATOM   1015  CB  TYR A 131     -17.089  24.728  28.016  1.00 34.23           C  
ATOM   1016  CG  TYR A 131     -18.099  23.982  27.175  1.00 33.36           C  
ATOM   1017  CD1 TYR A 131     -18.395  22.644  27.431  1.00 33.52           C  
ATOM   1018  CD2 TYR A 131     -18.795  24.630  26.155  1.00 33.93           C  
ATOM   1019  CE1 TYR A 131     -19.363  21.964  26.691  1.00 33.66           C  
ATOM   1020  CE2 TYR A 131     -19.764  23.968  25.412  1.00 35.16           C  
ATOM   1021  CZ  TYR A 131     -20.046  22.632  25.684  1.00 36.39           C  
ATOM   1022  OH  TYR A 131     -21.018  21.973  24.955  1.00 38.01           O  
ATOM   1023  N   ALA A 132     -16.823  27.057  30.680  1.00 30.85           N  
ATOM   1024  CA  ALA A 132     -15.869  27.669  31.592  1.00 31.85           C  
ATOM   1025  C   ALA A 132     -15.940  26.842  32.871  1.00 33.49           C  
ATOM   1026  O   ALA A 132     -16.993  26.288  33.192  1.00 35.26           O  
ATOM   1027  CB  ALA A 132     -16.252  29.121  31.872  1.00 29.19           C  
ATOM   1028  N   SER A 133     -14.835  26.753  33.601  1.00 34.77           N  
ATOM   1029  CA  SER A 133     -14.818  25.960  34.825  1.00 36.96           C  
ATOM   1030  C   SER A 133     -16.030  26.209  35.717  1.00 37.65           C  
ATOM   1031  O   SER A 133     -16.466  27.350  35.900  1.00 36.25           O  
ATOM   1032  CB  SER A 133     -13.543  26.224  35.630  1.00 38.04           C  
ATOM   1033  OG  SER A 133     -13.496  25.397  36.784  1.00 37.61           O  
ATOM   1034  N   GLY A 134     -16.563  25.122  36.268  1.00 38.98           N  
ATOM   1035  CA  GLY A 134     -17.708  25.220  37.153  1.00 39.95           C  
ATOM   1036  C   GLY A 134     -17.301  25.542  38.581  1.00 40.21           C  
ATOM   1037  O   GLY A 134     -18.135  25.526  39.479  1.00 41.16           O  
ATOM   1038  N   ASP A 135     -16.023  25.848  38.784  1.00 40.69           N  
ATOM   1039  CA  ASP A 135     -15.499  26.162  40.109  1.00 41.26           C  
ATOM   1040  C   ASP A 135     -15.295  27.650  40.297  1.00 41.66           C  
ATOM   1041  O   ASP A 135     -14.676  28.075  41.274  1.00 42.33           O  
ATOM   1042  CB  ASP A 135     -14.161  25.455  40.328  1.00 42.98           C  
ATOM   1043  CG  ASP A 135     -14.296  23.949  40.351  1.00 47.31           C  
ATOM   1044  OD1 ASP A 135     -13.255  23.258  40.280  1.00 49.25           O  
ATOM   1045  OD2 ASP A 135     -15.443  23.451  40.448  1.00 50.55           O  
ATOM   1046  N   ILE A 136     -15.805  28.445  39.363  1.00 42.58           N  
ATOM   1047  CA  ILE A 136     -15.649  29.892  39.439  1.00 43.53           C  
ATOM   1048  C   ILE A 136     -16.695  30.553  40.328  1.00 45.06           C  
ATOM   1049  O   ILE A 136     -17.786  30.024  40.529  1.00 45.39           O  
ATOM   1050  CB  ILE A 136     -15.733  30.538  38.041  1.00 42.76           C  
ATOM   1051  CG1 ILE A 136     -17.124  30.316  37.446  1.00 41.41           C  
ATOM   1052  CG2 ILE A 136     -14.674  29.940  37.132  1.00 42.01           C  
ATOM   1053  CD1 ILE A 136     -17.361  31.079  36.168  1.00 40.91           C  
ATOM   1054  N   PHE A 137     -16.341  31.716  40.859  1.00 46.58           N  
ATOM   1055  CA  PHE A 137     -17.226  32.495  41.716  1.00 47.79           C  
ATOM   1056  C   PHE A 137     -17.771  33.613  40.849  1.00 48.51           C  
ATOM   1057  O   PHE A 137     -18.286  34.604  41.354  1.00 51.60           O  
ATOM   1058  CB  PHE A 137     -16.441  33.113  42.881  1.00 47.86           C  
ATOM   1059  CG  PHE A 137     -16.084  32.141  43.970  1.00 49.92           C  
ATOM   1060  CD1 PHE A 137     -15.587  30.878  43.669  1.00 50.06           C  
ATOM   1061  CD2 PHE A 137     -16.228  32.500  45.310  1.00 50.56           C  
ATOM   1062  CE1 PHE A 137     -15.239  29.986  44.685  1.00 50.61           C  
ATOM   1063  CE2 PHE A 137     -15.884  31.618  46.331  1.00 49.71           C  
ATOM   1064  CZ  PHE A 137     -15.387  30.358  46.018  1.00 49.97           C  
ATOM   1065  N   GLY A 138     -17.643  33.454  39.537  1.00 48.09           N  
ATOM   1066  CA  GLY A 138     -18.100  34.484  38.620  1.00 47.31           C  
ATOM   1067  C   GLY A 138     -16.889  35.170  38.009  1.00 46.43           C  
ATOM   1068  O   GLY A 138     -15.755  34.764  38.257  1.00 46.82           O  
ATOM   1069  N   ALA A 139     -17.104  36.219  37.226  1.00 45.49           N  
ATOM   1070  CA  ALA A 139     -15.981  36.898  36.605  1.00 43.40           C  
ATOM   1071  C   ALA A 139     -16.307  38.313  36.165  1.00 43.32           C  
ATOM   1072  O   ALA A 139     -17.469  38.678  36.006  1.00 42.97           O  
ATOM   1073  CB  ALA A 139     -15.509  36.087  35.408  1.00 44.88           C  
ATOM   1074  N   SER A 140     -15.268  39.110  35.961  1.00 43.76           N  
ATOM   1075  CA  SER A 140     -15.451  40.482  35.510  1.00 44.64           C  
ATOM   1076  C   SER A 140     -15.374  40.510  33.984  1.00 45.36           C  
ATOM   1077  O   SER A 140     -14.442  39.970  33.387  1.00 46.46           O  
ATOM   1078  CB  SER A 140     -14.373  41.385  36.103  1.00 43.63           C  
ATOM   1079  OG  SER A 140     -14.625  42.734  35.762  1.00 46.51           O  
ATOM   1080  N   PHE A 141     -16.358  41.127  33.347  1.00 45.68           N  
ATOM   1081  CA  PHE A 141     -16.360  41.191  31.898  1.00 45.09           C  
ATOM   1082  C   PHE A 141     -15.772  42.507  31.416  1.00 45.62           C  
ATOM   1083  O   PHE A 141     -16.323  43.578  31.669  1.00 46.83           O  
ATOM   1084  CB  PHE A 141     -17.776  41.025  31.363  1.00 44.58           C  
ATOM   1085  CG  PHE A 141     -17.871  41.174  29.888  1.00 45.36           C  
ATOM   1086  CD1 PHE A 141     -17.167  40.321  29.049  1.00 46.91           C  
ATOM   1087  CD2 PHE A 141     -18.635  42.187  29.327  1.00 46.04           C  
ATOM   1088  CE1 PHE A 141     -17.219  40.476  27.659  1.00 47.07           C  
ATOM   1089  CE2 PHE A 141     -18.695  42.354  27.942  1.00 47.20           C  
ATOM   1090  CZ  PHE A 141     -17.984  41.494  27.107  1.00 46.51           C  
ATOM   1091  N   ILE A 142     -14.638  42.422  30.729  1.00 44.69           N  
ATOM   1092  CA  ILE A 142     -13.980  43.609  30.212  1.00 44.75           C  
ATOM   1093  C   ILE A 142     -14.191  43.620  28.708  1.00 45.26           C  
ATOM   1094  O   ILE A 142     -13.502  42.934  27.962  1.00 46.45           O  
ATOM   1095  CB  ILE A 142     -12.464  43.601  30.530  1.00 44.76           C  
ATOM   1096  CG1 ILE A 142     -12.236  43.465  32.036  1.00 44.61           C  
ATOM   1097  CG2 ILE A 142     -11.828  44.892  30.057  1.00 44.68           C  
ATOM   1098  CD1 ILE A 142     -12.473  42.074  32.578  1.00 45.36           C  
ATOM   1099  N   GLN A 143     -15.163  44.402  28.270  1.00 46.27           N  
ATOM   1100  CA  GLN A 143     -15.500  44.494  26.859  1.00 47.12           C  
ATOM   1101  C   GLN A 143     -14.384  44.990  25.945  1.00 46.69           C  
ATOM   1102  O   GLN A 143     -14.249  44.526  24.817  1.00 46.79           O  
ATOM   1103  CB  GLN A 143     -16.718  45.399  26.691  1.00 48.73           C  
ATOM   1104  CG  GLN A 143     -17.093  45.676  25.252  1.00 53.20           C  
ATOM   1105  CD  GLN A 143     -18.078  46.818  25.123  1.00 56.07           C  
ATOM   1106  OE1 GLN A 143     -17.822  47.930  25.598  1.00 58.18           O  
ATOM   1107  NE2 GLN A 143     -19.211  46.556  24.476  1.00 57.75           N  
ATOM   1108  N   ASP A 144     -13.577  45.926  26.427  1.00 47.50           N  
ATOM   1109  CA  ASP A 144     -12.526  46.494  25.598  1.00 46.74           C  
ATOM   1110  C   ASP A 144     -11.171  45.798  25.603  1.00 45.32           C  
ATOM   1111  O   ASP A 144     -10.299  46.136  24.805  1.00 46.43           O  
ATOM   1112  CB  ASP A 144     -12.371  47.976  25.932  1.00 49.47           C  
ATOM   1113  CG  ASP A 144     -13.626  48.787  25.586  1.00 52.10           C  
ATOM   1114  OD1 ASP A 144     -13.656  49.996  25.898  1.00 54.94           O  
ATOM   1115  OD2 ASP A 144     -14.581  48.222  24.999  1.00 49.98           O  
ATOM   1116  N   ASP A 145     -10.981  44.832  26.492  1.00 42.40           N  
ATOM   1117  CA  ASP A 145      -9.723  44.097  26.513  1.00 40.18           C  
ATOM   1118  C   ASP A 145      -9.781  42.997  25.449  1.00 38.49           C  
ATOM   1119  O   ASP A 145      -9.750  41.807  25.763  1.00 38.14           O  
ATOM   1120  CB  ASP A 145      -9.476  43.483  27.890  1.00 38.75           C  
ATOM   1121  CG  ASP A 145      -8.741  44.420  28.818  1.00 40.55           C  
ATOM   1122  OD1 ASP A 145      -8.728  45.644  28.547  1.00 41.43           O  
ATOM   1123  OD2 ASP A 145      -8.181  43.933  29.825  1.00 40.74           O  
ATOM   1124  N   VAL A 146      -9.878  43.411  24.190  1.00 35.65           N  
ATOM   1125  CA  VAL A 146      -9.940  42.483  23.062  1.00 35.65           C  
ATOM   1126  C   VAL A 146      -8.533  41.981  22.696  1.00 34.87           C  
ATOM   1127  O   VAL A 146      -7.582  42.198  23.442  1.00 36.35           O  
ATOM   1128  CB  VAL A 146     -10.577  43.188  21.837  1.00 35.66           C  
ATOM   1129  CG1 VAL A 146     -11.992  43.659  22.186  1.00 32.68           C  
ATOM   1130  CG2 VAL A 146      -9.720  44.381  21.420  1.00 33.14           C  
ATOM   1131  N   HIS A 147      -8.389  41.299  21.565  1.00 33.23           N  
ATOM   1132  CA  HIS A 147      -7.062  40.832  21.178  1.00 32.20           C  
ATOM   1133  C   HIS A 147      -6.773  40.856  19.677  1.00 33.14           C  
ATOM   1134  O   HIS A 147      -7.684  40.875  18.845  1.00 33.01           O  
ATOM   1135  CB  HIS A 147      -6.789  39.434  21.750  1.00 30.72           C  
ATOM   1136  CG  HIS A 147      -7.723  38.365  21.265  1.00 31.05           C  
ATOM   1137  ND1 HIS A 147      -7.673  37.852  19.987  1.00 32.70           N  
ATOM   1138  CD2 HIS A 147      -8.675  37.654  21.915  1.00 30.72           C  
ATOM   1139  CE1 HIS A 147      -8.548  36.868  19.875  1.00 32.91           C  
ATOM   1140  NE2 HIS A 147      -9.169  36.728  21.031  1.00 30.61           N  
ATOM   1141  N   VAL A 148      -5.485  40.877  19.350  1.00 32.47           N  
ATOM   1142  CA  VAL A 148      -5.009  40.900  17.966  1.00 32.47           C  
ATOM   1143  C   VAL A 148      -3.848  39.911  17.854  1.00 33.03           C  
ATOM   1144  O   VAL A 148      -3.418  39.343  18.865  1.00 32.19           O  
ATOM   1145  CB  VAL A 148      -4.468  42.303  17.588  1.00 30.78           C  
ATOM   1146  CG1 VAL A 148      -5.563  43.338  17.707  1.00 29.45           C  
ATOM   1147  CG2 VAL A 148      -3.302  42.672  18.504  1.00 27.25           C  
ATOM   1148  N   GLU A 149      -3.346  39.693  16.638  1.00 32.20           N  
ATOM   1149  CA  GLU A 149      -2.196  38.806  16.474  1.00 32.54           C  
ATOM   1150  C   GLU A 149      -1.007  39.739  16.311  1.00 31.44           C  
ATOM   1151  O   GLU A 149      -0.845  40.393  15.288  1.00 30.89           O  
ATOM   1152  CB  GLU A 149      -2.364  37.889  15.263  1.00 34.11           C  
ATOM   1153  CG  GLU A 149      -3.584  36.977  15.386  1.00 38.63           C  
ATOM   1154  CD  GLU A 149      -3.442  35.684  14.603  1.00 42.37           C  
ATOM   1155  OE1 GLU A 149      -4.458  34.966  14.459  1.00 43.63           O  
ATOM   1156  OE2 GLU A 149      -2.319  35.383  14.138  1.00 44.27           O  
ATOM   1157  N   PRO A 150      -0.171  39.829  17.352  1.00 30.41           N  
ATOM   1158  CA  PRO A 150       1.031  40.663  17.449  1.00 29.93           C  
ATOM   1159  C   PRO A 150       1.966  40.690  16.240  1.00 30.74           C  
ATOM   1160  O   PRO A 150       2.402  41.762  15.814  1.00 30.77           O  
ATOM   1161  CB  PRO A 150       1.718  40.121  18.694  1.00 29.19           C  
ATOM   1162  CG  PRO A 150       0.585  39.671  19.522  1.00 29.66           C  
ATOM   1163  CD  PRO A 150      -0.291  38.964  18.536  1.00 28.75           C  
ATOM   1164  N   TYR A 151       2.281  39.518  15.700  1.00 30.22           N  
ATOM   1165  CA  TYR A 151       3.181  39.423  14.558  1.00 30.53           C  
ATOM   1166  C   TYR A 151       2.666  40.221  13.381  1.00 31.30           C  
ATOM   1167  O   TYR A 151       3.398  41.004  12.781  1.00 30.81           O  
ATOM   1168  CB  TYR A 151       3.346  37.969  14.125  1.00 31.80           C  
ATOM   1169  CG  TYR A 151       4.292  37.775  12.962  1.00 30.41           C  
ATOM   1170  CD1 TYR A 151       5.668  37.907  13.128  1.00 30.43           C  
ATOM   1171  CD2 TYR A 151       3.809  37.460  11.691  1.00 31.06           C  
ATOM   1172  CE1 TYR A 151       6.544  37.728  12.059  1.00 31.42           C  
ATOM   1173  CE2 TYR A 151       4.676  37.279  10.611  1.00 29.93           C  
ATOM   1174  CZ  TYR A 151       6.040  37.415  10.804  1.00 31.00           C  
ATOM   1175  OH  TYR A 151       6.903  37.242   9.748  1.00 32.44           O  
ATOM   1176  N   PHE A 152       1.397  40.024  13.051  1.00 32.36           N  
ATOM   1177  CA  PHE A 152       0.820  40.722  11.917  1.00 33.35           C  
ATOM   1178  C   PHE A 152       0.616  42.213  12.120  1.00 33.94           C  
ATOM   1179  O   PHE A 152       0.782  42.982  11.180  1.00 36.13           O  
ATOM   1180  CB  PHE A 152      -0.464  40.018  11.484  1.00 32.16           C  
ATOM   1181  CG  PHE A 152      -0.215  38.639  10.929  1.00 32.72           C  
ATOM   1182  CD1 PHE A 152       0.509  38.474   9.751  1.00 31.53           C  
ATOM   1183  CD2 PHE A 152      -0.651  37.503  11.611  1.00 32.89           C  
ATOM   1184  CE1 PHE A 152       0.798  37.204   9.260  1.00 32.67           C  
ATOM   1185  CE2 PHE A 152      -0.368  36.224  11.128  1.00 33.21           C  
ATOM   1186  CZ  PHE A 152       0.359  36.072   9.951  1.00 33.68           C  
ATOM   1187  N   VAL A 153       0.277  42.646  13.329  1.00 34.83           N  
ATOM   1188  CA  VAL A 153       0.127  44.079  13.543  1.00 35.87           C  
ATOM   1189  C   VAL A 153       1.520  44.693  13.380  1.00 36.68           C  
ATOM   1190  O   VAL A 153       1.660  45.821  12.910  1.00 37.44           O  
ATOM   1191  CB  VAL A 153      -0.481  44.402  14.943  1.00 35.99           C  
ATOM   1192  CG1 VAL A 153      -0.221  43.260  15.896  1.00 36.01           C  
ATOM   1193  CG2 VAL A 153       0.084  45.724  15.480  1.00 32.81           C  
ATOM   1194  N   CYS A 154       2.549  43.936  13.751  1.00 36.31           N  
ATOM   1195  CA  CYS A 154       3.923  44.403  13.600  1.00 35.16           C  
ATOM   1196  C   CYS A 154       4.265  44.483  12.105  1.00 36.35           C  
ATOM   1197  O   CYS A 154       4.751  45.517  11.637  1.00 37.85           O  
ATOM   1198  CB  CYS A 154       4.896  43.453  14.306  1.00 32.19           C  
ATOM   1199  SG  CYS A 154       6.672  43.777  14.007  1.00 31.70           S  
ATOM   1200  N   LYS A 155       4.009  43.404  11.360  1.00 35.40           N  
ATOM   1201  CA  LYS A 155       4.297  43.382   9.922  1.00 36.49           C  
ATOM   1202  C   LYS A 155       3.487  44.433   9.174  1.00 36.37           C  
ATOM   1203  O   LYS A 155       3.920  44.933   8.143  1.00 36.06           O  
ATOM   1204  CB  LYS A 155       4.006  42.004   9.317  1.00 36.72           C  
ATOM   1205  CG  LYS A 155       4.955  40.913   9.775  1.00 41.03           C  
ATOM   1206  CD  LYS A 155       6.389  41.133   9.270  1.00 42.91           C  
ATOM   1207  CE  LYS A 155       6.518  40.837   7.778  1.00 43.21           C  
ATOM   1208  NZ  LYS A 155       6.152  39.425   7.441  1.00 42.71           N  
ATOM   1209  N   ALA A 156       2.308  44.759   9.692  1.00 36.23           N  
ATOM   1210  CA  ALA A 156       1.464  45.761   9.066  1.00 36.70           C  
ATOM   1211  C   ALA A 156       2.096  47.129   9.277  1.00 36.95           C  
ATOM   1212  O   ALA A 156       2.126  47.957   8.369  1.00 37.51           O  
ATOM   1213  CB  ALA A 156       0.071  45.726   9.666  1.00 37.21           C  
ATOM   1214  N   TYR A 157       2.599  47.373  10.482  1.00 37.00           N  
ATOM   1215  CA  TYR A 157       3.246  48.643  10.769  1.00 37.81           C  
ATOM   1216  C   TYR A 157       4.441  48.815   9.837  1.00 38.57           C  
ATOM   1217  O   TYR A 157       4.576  49.834   9.168  1.00 37.47           O  
ATOM   1218  CB  TYR A 157       3.735  48.694  12.220  1.00 37.29           C  
ATOM   1219  CG  TYR A 157       2.792  49.380  13.189  1.00 38.60           C  
ATOM   1220  CD1 TYR A 157       2.249  50.632  12.900  1.00 36.36           C  
ATOM   1221  CD2 TYR A 157       2.506  48.810  14.435  1.00 39.51           C  
ATOM   1222  CE1 TYR A 157       1.456  51.305  13.823  1.00 36.29           C  
ATOM   1223  CE2 TYR A 157       1.709  49.479  15.369  1.00 38.48           C  
ATOM   1224  CZ  TYR A 157       1.192  50.726  15.055  1.00 38.20           C  
ATOM   1225  OH  TYR A 157       0.425  51.400  15.973  1.00 38.62           O  
ATOM   1226  N   VAL A 158       5.298  47.799   9.786  1.00 39.89           N  
ATOM   1227  CA  VAL A 158       6.497  47.845   8.957  1.00 41.97           C  
ATOM   1228  C   VAL A 158       6.195  48.070   7.486  1.00 43.04           C  
ATOM   1229  O   VAL A 158       6.812  48.920   6.849  1.00 44.12           O  
ATOM   1230  CB  VAL A 158       7.320  46.547   9.072  1.00 42.80           C  
ATOM   1231  CG1 VAL A 158       8.724  46.780   8.542  1.00 42.95           C  
ATOM   1232  CG2 VAL A 158       7.372  46.089  10.507  1.00 45.03           C  
ATOM   1233  N   LYS A 159       5.263  47.292   6.944  1.00 43.46           N  
ATOM   1234  CA  LYS A 159       4.893  47.412   5.541  1.00 44.55           C  
ATOM   1235  C   LYS A 159       4.301  48.792   5.275  1.00 45.12           C  
ATOM   1236  O   LYS A 159       4.660  49.438   4.298  1.00 46.20           O  
ATOM   1237  CB  LYS A 159       3.882  46.327   5.159  1.00 44.91           C  
ATOM   1238  CG  LYS A 159       4.302  45.431   3.993  1.00 45.34           C  
ATOM   1239  CD  LYS A 159       4.442  46.211   2.696  1.00 47.04           C  
ATOM   1240  CE  LYS A 159       4.603  45.293   1.494  1.00 45.72           C  
ATOM   1241  NZ  LYS A 159       3.359  44.520   1.194  1.00 46.69           N  
ATOM   1242  N   ALA A 160       3.399  49.245   6.140  1.00 44.40           N  
ATOM   1243  CA  ALA A 160       2.798  50.559   5.961  1.00 44.76           C  
ATOM   1244  C   ALA A 160       3.902  51.608   5.973  1.00 45.80           C  
ATOM   1245  O   ALA A 160       3.861  52.569   5.212  1.00 48.63           O  
ATOM   1246  CB  ALA A 160       1.793  50.846   7.069  1.00 43.74           C  
ATOM   1247  N   ALA A 161       4.895  51.412   6.834  1.00 45.30           N  
ATOM   1248  CA  ALA A 161       6.008  52.347   6.939  1.00 45.28           C  
ATOM   1249  C   ALA A 161       6.841  52.361   5.658  1.00 46.02           C  
ATOM   1250  O   ALA A 161       7.294  53.419   5.223  1.00 46.15           O  
ATOM   1251  CB  ALA A 161       6.889  51.983   8.135  1.00 43.76           C  
ATOM   1252  N   LYS A 162       7.050  51.187   5.067  1.00 46.60           N  
ATOM   1253  CA  LYS A 162       7.827  51.074   3.837  1.00 47.44           C  
ATOM   1254  C   LYS A 162       7.154  51.858   2.718  1.00 48.30           C  
ATOM   1255  O   LYS A 162       7.810  52.588   1.969  1.00 47.05           O  
ATOM   1256  CB  LYS A 162       7.956  49.612   3.405  1.00 47.41           C  
ATOM   1257  CG  LYS A 162       8.895  48.785   4.243  1.00 48.29           C  
ATOM   1258  CD  LYS A 162       9.079  47.401   3.640  1.00 48.83           C  
ATOM   1259  CE  LYS A 162      10.087  46.594   4.440  1.00 51.14           C  
ATOM   1260  NZ  LYS A 162      10.444  45.305   3.794  1.00 51.55           N  
ATOM   1261  N   MET A 163       5.840  51.696   2.612  1.00 49.18           N  
ATOM   1262  CA  MET A 163       5.065  52.385   1.596  1.00 50.43           C  
ATOM   1263  C   MET A 163       5.173  53.900   1.776  1.00 50.44           C  
ATOM   1264  O   MET A 163       5.099  54.650   0.803  1.00 51.14           O  
ATOM   1265  CB  MET A 163       3.601  51.936   1.661  1.00 51.32           C  
ATOM   1266  CG  MET A 163       3.409  50.420   1.530  1.00 53.91           C  
ATOM   1267  SD  MET A 163       3.971  49.705  -0.042  1.00 57.50           S  
ATOM   1268  CE  MET A 163       5.694  49.339   0.331  1.00 57.12           C  
ATOM   1269  N   LEU A 164       5.361  54.351   3.013  1.00 49.03           N  
ATOM   1270  CA  LEU A 164       5.490  55.778   3.269  1.00 48.29           C  
ATOM   1271  C   LEU A 164       6.941  56.262   3.220  1.00 48.27           C  
ATOM   1272  O   LEU A 164       7.239  57.394   3.621  1.00 48.62           O  
ATOM   1273  CB  LEU A 164       4.870  56.148   4.615  1.00 48.59           C  
ATOM   1274  CG  LEU A 164       3.390  55.802   4.763  1.00 49.84           C  
ATOM   1275  CD1 LEU A 164       2.836  56.477   6.007  1.00 49.70           C  
ATOM   1276  CD2 LEU A 164       2.633  56.252   3.524  1.00 49.18           C  
ATOM   1277  N   GLY A 165       7.844  55.405   2.748  1.00 45.99           N  
ATOM   1278  CA  GLY A 165       9.234  55.806   2.621  1.00 45.46           C  
ATOM   1279  C   GLY A 165      10.265  55.371   3.649  1.00 45.54           C  
ATOM   1280  O   GLY A 165      11.444  55.695   3.501  1.00 46.06           O  
ATOM   1281  N   ALA A 166       9.855  54.652   4.686  1.00 44.68           N  
ATOM   1282  CA  ALA A 166      10.816  54.218   5.690  1.00 43.01           C  
ATOM   1283  C   ALA A 166      11.663  53.102   5.105  1.00 42.49           C  
ATOM   1284  O   ALA A 166      11.151  52.241   4.402  1.00 42.64           O  
ATOM   1285  CB  ALA A 166      10.094  53.735   6.934  1.00 43.22           C  
ATOM   1286  N   GLU A 167      12.961  53.127   5.389  1.00 42.98           N  
ATOM   1287  CA  GLU A 167      13.877  52.107   4.890  1.00 44.20           C  
ATOM   1288  C   GLU A 167      14.193  51.105   5.996  1.00 42.93           C  
ATOM   1289  O   GLU A 167      14.867  51.432   6.968  1.00 43.70           O  
ATOM   1290  CB  GLU A 167      15.160  52.765   4.375  1.00 46.47           C  
ATOM   1291  CG  GLU A 167      14.958  53.524   3.065  1.00 50.25           C  
ATOM   1292  CD  GLU A 167      16.113  54.456   2.726  1.00 52.58           C  
ATOM   1293  OE1 GLU A 167      17.269  53.991   2.643  1.00 52.02           O  
ATOM   1294  OE2 GLU A 167      15.853  55.664   2.539  1.00 55.98           O  
ATOM   1295  N   ILE A 168      13.696  49.883   5.834  1.00 41.89           N  
ATOM   1296  CA  ILE A 168      13.878  48.823   6.821  1.00 40.14           C  
ATOM   1297  C   ILE A 168      15.005  47.862   6.460  1.00 39.63           C  
ATOM   1298  O   ILE A 168      15.020  47.285   5.380  1.00 40.26           O  
ATOM   1299  CB  ILE A 168      12.554  48.030   7.016  1.00 38.93           C  
ATOM   1300  CG1 ILE A 168      11.530  48.890   7.773  1.00 37.15           C  
ATOM   1301  CG2 ILE A 168      12.812  46.755   7.818  1.00 37.47           C  
ATOM   1302  CD1 ILE A 168      11.170  50.183   7.120  1.00 29.74           C  
ATOM   1303  N   PHE A 169      15.935  47.677   7.389  1.00 39.01           N  
ATOM   1304  CA  PHE A 169      17.080  46.812   7.160  1.00 38.53           C  
ATOM   1305  C   PHE A 169      17.146  45.612   8.102  1.00 37.86           C  
ATOM   1306  O   PHE A 169      17.592  45.726   9.242  1.00 39.90           O  
ATOM   1307  CB  PHE A 169      18.358  47.638   7.293  1.00 40.26           C  
ATOM   1308  CG  PHE A 169      18.438  48.785   6.322  1.00 41.81           C  
ATOM   1309  CD1 PHE A 169      18.972  48.601   5.047  1.00 41.85           C  
ATOM   1310  CD2 PHE A 169      17.958  50.044   6.672  1.00 40.89           C  
ATOM   1311  CE1 PHE A 169      19.024  49.655   4.138  1.00 42.28           C  
ATOM   1312  CE2 PHE A 169      18.004  51.107   5.770  1.00 42.00           C  
ATOM   1313  CZ  PHE A 169      18.538  50.913   4.501  1.00 42.54           C  
ATOM   1314  N   GLU A 170      16.709  44.458   7.620  1.00 35.13           N  
ATOM   1315  CA  GLU A 170      16.747  43.260   8.430  1.00 34.82           C  
ATOM   1316  C   GLU A 170      18.150  42.694   8.429  1.00 34.83           C  
ATOM   1317  O   GLU A 170      18.980  43.094   7.623  1.00 35.24           O  
ATOM   1318  CB  GLU A 170      15.763  42.221   7.892  1.00 35.06           C  
ATOM   1319  CG  GLU A 170      14.309  42.568   8.172  1.00 36.99           C  
ATOM   1320  CD  GLU A 170      13.353  41.484   7.729  1.00 37.29           C  
ATOM   1321  OE1 GLU A 170      12.226  41.430   8.264  1.00 38.79           O  
ATOM   1322  OE2 GLU A 170      13.723  40.690   6.845  1.00 38.98           O  
ATOM   1323  N   HIS A 171      18.417  41.776   9.350  1.00 34.92           N  
ATOM   1324  CA  HIS A 171      19.725  41.147   9.444  1.00 36.06           C  
ATOM   1325  C   HIS A 171      20.841  42.167   9.578  1.00 36.13           C  
ATOM   1326  O   HIS A 171      21.985  41.883   9.238  1.00 36.69           O  
ATOM   1327  CB  HIS A 171      19.959  40.288   8.209  1.00 37.97           C  
ATOM   1328  CG  HIS A 171      18.824  39.363   7.911  1.00 39.43           C  
ATOM   1329  ND1 HIS A 171      18.561  38.242   8.670  1.00 38.77           N  
ATOM   1330  CD2 HIS A 171      17.839  39.434   6.984  1.00 39.13           C  
ATOM   1331  CE1 HIS A 171      17.460  37.664   8.224  1.00 40.58           C  
ATOM   1332  NE2 HIS A 171      17.001  38.367   7.203  1.00 40.81           N  
ATOM   1333  N   THR A 172      20.500  43.347  10.090  1.00 37.04           N  
ATOM   1334  CA  THR A 172      21.461  44.428  10.274  1.00 37.48           C  
ATOM   1335  C   THR A 172      21.607  44.866  11.739  1.00 36.97           C  
ATOM   1336  O   THR A 172      21.027  45.862  12.168  1.00 35.60           O  
ATOM   1337  CB  THR A 172      21.054  45.655   9.449  1.00 39.32           C  
ATOM   1338  OG1 THR A 172      20.744  45.247   8.113  1.00 41.91           O  
ATOM   1339  CG2 THR A 172      22.188  46.670   9.411  1.00 40.39           C  
ATOM   1340  N   PRO A 173      22.385  44.120  12.528  1.00 36.36           N  
ATOM   1341  CA  PRO A 173      22.592  44.460  13.937  1.00 37.84           C  
ATOM   1342  C   PRO A 173      23.244  45.829  14.104  1.00 39.18           C  
ATOM   1343  O   PRO A 173      24.166  46.170  13.359  1.00 40.27           O  
ATOM   1344  CB  PRO A 173      23.543  43.367  14.420  1.00 36.15           C  
ATOM   1345  CG  PRO A 173      23.233  42.221  13.537  1.00 37.18           C  
ATOM   1346  CD  PRO A 173      23.059  42.857  12.190  1.00 36.43           C  
ATOM   1347  N   VAL A 174      22.765  46.626  15.055  1.00 38.20           N  
ATOM   1348  CA  VAL A 174      23.417  47.897  15.314  1.00 36.70           C  
ATOM   1349  C   VAL A 174      24.447  47.513  16.366  1.00 37.11           C  
ATOM   1350  O   VAL A 174      24.103  46.975  17.408  1.00 36.96           O  
ATOM   1351  CB  VAL A 174      22.459  48.938  15.874  1.00 36.65           C  
ATOM   1352  CG1 VAL A 174      23.240  50.155  16.359  1.00 35.62           C  
ATOM   1353  CG2 VAL A 174      21.485  49.354  14.796  1.00 36.38           C  
ATOM   1354  N   LEU A 175      25.717  47.755  16.076  1.00 39.37           N  
ATOM   1355  CA  LEU A 175      26.786  47.388  16.994  1.00 41.49           C  
ATOM   1356  C   LEU A 175      27.106  48.436  18.055  1.00 42.55           C  
ATOM   1357  O   LEU A 175      27.411  48.100  19.204  1.00 41.31           O  
ATOM   1358  CB  LEU A 175      28.061  47.087  16.204  1.00 41.10           C  
ATOM   1359  CG  LEU A 175      28.017  45.933  15.200  1.00 43.09           C  
ATOM   1360  CD1 LEU A 175      29.295  45.955  14.364  1.00 43.39           C  
ATOM   1361  CD2 LEU A 175      27.865  44.601  15.929  1.00 40.10           C  
ATOM   1362  N   HIS A 176      27.028  49.705  17.673  1.00 43.68           N  
ATOM   1363  CA  HIS A 176      27.369  50.769  18.595  1.00 45.87           C  
ATOM   1364  C   HIS A 176      26.788  52.110  18.171  1.00 46.15           C  
ATOM   1365  O   HIS A 176      26.713  52.413  16.980  1.00 44.92           O  
ATOM   1366  CB  HIS A 176      28.896  50.851  18.674  1.00 48.12           C  
ATOM   1367  CG  HIS A 176      29.408  51.706  19.786  1.00 52.24           C  
ATOM   1368  ND1 HIS A 176      29.366  53.084  19.749  1.00 54.35           N  
ATOM   1369  CD2 HIS A 176      29.988  51.379  20.965  1.00 53.57           C  
ATOM   1370  CE1 HIS A 176      29.900  53.568  20.856  1.00 55.12           C  
ATOM   1371  NE2 HIS A 176      30.285  52.554  21.611  1.00 55.49           N  
ATOM   1372  N   VAL A 177      26.358  52.898  19.152  1.00 47.97           N  
ATOM   1373  CA  VAL A 177      25.813  54.227  18.891  1.00 50.17           C  
ATOM   1374  C   VAL A 177      26.828  55.243  19.388  1.00 53.52           C  
ATOM   1375  O   VAL A 177      27.187  55.261  20.566  1.00 52.44           O  
ATOM   1376  CB  VAL A 177      24.481  54.478  19.620  1.00 47.88           C  
ATOM   1377  CG1 VAL A 177      24.052  55.918  19.428  1.00 44.53           C  
ATOM   1378  CG2 VAL A 177      23.415  53.548  19.084  1.00 48.55           C  
ATOM   1379  N   GLU A 178      27.291  56.081  18.468  1.00 59.08           N  
ATOM   1380  CA  GLU A 178      28.278  57.104  18.772  1.00 63.77           C  
ATOM   1381  C   GLU A 178      27.700  58.500  18.716  1.00 65.75           C  
ATOM   1382  O   GLU A 178      26.933  58.844  17.817  1.00 65.15           O  
ATOM   1383  CB  GLU A 178      29.459  57.026  17.795  1.00 65.65           C  
ATOM   1384  CG  GLU A 178      30.719  56.415  18.375  1.00 68.41           C  
ATOM   1385  CD  GLU A 178      31.233  57.183  19.581  1.00 71.09           C  
ATOM   1386  OE1 GLU A 178      32.264  56.766  20.156  1.00 72.54           O  
ATOM   1387  OE2 GLU A 178      30.609  58.202  19.954  1.00 72.68           O  
ATOM   1388  N   ARG A 179      28.085  59.300  19.697  1.00 69.48           N  
ATOM   1389  CA  ARG A 179      27.653  60.679  19.779  1.00 73.51           C  
ATOM   1390  C   ARG A 179      28.924  61.500  19.929  1.00 76.46           C  
ATOM   1391  O   ARG A 179      29.703  61.293  20.861  1.00 77.02           O  
ATOM   1392  CB  ARG A 179      26.740  60.877  20.989  1.00 72.97           C  
ATOM   1393  CG  ARG A 179      27.324  60.363  22.300  1.00 73.11           C  
ATOM   1394  CD  ARG A 179      26.379  60.642  23.456  1.00 72.78           C  
ATOM   1395  NE  ARG A 179      26.945  60.242  24.740  1.00 72.41           N  
ATOM   1396  CZ  ARG A 179      26.318  60.387  25.902  1.00 73.14           C  
ATOM   1397  NH1 ARG A 179      25.104  60.922  25.940  1.00 72.80           N  
ATOM   1398  NH2 ARG A 179      26.907  60.001  27.029  1.00 72.99           N  
ATOM   1399  N   ASP A 180      29.152  62.409  18.991  1.00 79.87           N  
ATOM   1400  CA  ASP A 180      30.338  63.250  19.046  1.00 83.57           C  
ATOM   1401  C   ASP A 180      30.145  64.461  18.138  1.00 84.06           C  
ATOM   1402  O   ASP A 180      30.366  65.604  18.549  1.00 84.04           O  
ATOM   1403  CB  ASP A 180      31.573  62.453  18.614  1.00 85.94           C  
ATOM   1404  CG  ASP A 180      32.872  63.106  19.058  1.00 88.15           C  
ATOM   1405  OD1 ASP A 180      33.109  63.182  20.287  1.00 88.95           O  
ATOM   1406  OD2 ASP A 180      33.649  63.545  18.181  1.00 88.61           O  
ATOM   1407  N   GLY A 181      29.735  64.204  16.900  1.00 83.91           N  
ATOM   1408  CA  GLY A 181      29.501  65.295  15.981  1.00 83.27           C  
ATOM   1409  C   GLY A 181      28.272  66.047  16.448  1.00 83.27           C  
ATOM   1410  O   GLY A 181      27.885  65.964  17.614  1.00 82.29           O  
ATOM   1411  N   GLU A 182      27.652  66.790  15.543  1.00 83.43           N  
ATOM   1412  CA  GLU A 182      26.456  67.529  15.899  1.00 83.58           C  
ATOM   1413  C   GLU A 182      25.303  66.545  15.756  1.00 82.19           C  
ATOM   1414  O   GLU A 182      24.152  66.851  16.079  1.00 82.47           O  
ATOM   1415  CB  GLU A 182      26.266  68.719  14.954  1.00 85.91           C  
ATOM   1416  CG  GLU A 182      25.631  69.933  15.616  1.00 89.70           C  
ATOM   1417  CD  GLU A 182      26.479  70.483  16.757  1.00 92.55           C  
ATOM   1418  OE1 GLU A 182      27.647  70.865  16.508  1.00 93.58           O  
ATOM   1419  OE2 GLU A 182      25.977  70.535  17.904  1.00 93.78           O  
ATOM   1420  N   ALA A 183      25.633  65.349  15.273  1.00 79.77           N  
ATOM   1421  CA  ALA A 183      24.650  64.292  15.074  1.00 77.01           C  
ATOM   1422  C   ALA A 183      25.159  62.956  15.624  1.00 74.60           C  
ATOM   1423  O   ALA A 183      26.311  62.848  16.072  1.00 74.10           O  
ATOM   1424  CB  ALA A 183      24.326  64.157  13.584  1.00 77.27           C  
ATOM   1425  N   LEU A 184      24.291  61.948  15.593  1.00 70.67           N  
ATOM   1426  CA  LEU A 184      24.639  60.617  16.076  1.00 66.71           C  
ATOM   1427  C   LEU A 184      25.270  59.781  14.973  1.00 64.31           C  
ATOM   1428  O   LEU A 184      25.107  60.054  13.785  1.00 62.78           O  
ATOM   1429  CB  LEU A 184      23.404  59.886  16.613  1.00 66.94           C  
ATOM   1430  CG  LEU A 184      22.675  60.425  17.845  1.00 65.83           C  
ATOM   1431  CD1 LEU A 184      23.686  60.664  18.955  1.00 65.84           C  
ATOM   1432  CD2 LEU A 184      21.928  61.702  17.502  1.00 65.36           C  
ATOM   1433  N   PHE A 185      25.973  58.739  15.388  1.00 62.49           N  
ATOM   1434  CA  PHE A 185      26.660  57.852  14.468  1.00 61.07           C  
ATOM   1435  C   PHE A 185      26.387  56.403  14.866  1.00 58.62           C  
ATOM   1436  O   PHE A 185      26.867  55.941  15.894  1.00 58.68           O  
ATOM   1437  CB  PHE A 185      28.161  58.150  14.540  1.00 62.52           C  
ATOM   1438  CG  PHE A 185      28.988  57.385  13.558  1.00 63.01           C  
ATOM   1439  CD1 PHE A 185      28.851  57.607  12.191  1.00 64.63           C  
ATOM   1440  CD2 PHE A 185      29.941  56.473  14.001  1.00 64.72           C  
ATOM   1441  CE1 PHE A 185      29.658  56.930  11.269  1.00 65.37           C  
ATOM   1442  CE2 PHE A 185      30.753  55.791  13.096  1.00 65.88           C  
ATOM   1443  CZ  PHE A 185      30.612  56.022  11.724  1.00 66.05           C  
ATOM   1444  N   ILE A 186      25.614  55.689  14.056  1.00 55.96           N  
ATOM   1445  CA  ILE A 186      25.301  54.295  14.340  1.00 54.35           C  
ATOM   1446  C   ILE A 186      26.220  53.387  13.537  1.00 53.53           C  
ATOM   1447  O   ILE A 186      26.509  53.668  12.379  1.00 54.19           O  
ATOM   1448  CB  ILE A 186      23.849  53.955  13.963  1.00 54.38           C  
ATOM   1449  CG1 ILE A 186      22.875  54.801  14.781  1.00 55.19           C  
ATOM   1450  CG2 ILE A 186      23.583  52.488  14.209  1.00 54.88           C  
ATOM   1451  CD1 ILE A 186      22.790  56.247  14.337  1.00 57.10           C  
ATOM   1452  N   LYS A 187      26.672  52.293  14.142  1.00 52.97           N  
ATOM   1453  CA  LYS A 187      27.556  51.363  13.444  1.00 53.09           C  
ATOM   1454  C   LYS A 187      27.008  49.936  13.304  1.00 52.32           C  
ATOM   1455  O   LYS A 187      26.705  49.280  14.297  1.00 53.06           O  
ATOM   1456  CB  LYS A 187      28.925  51.331  14.131  1.00 53.50           C  
ATOM   1457  CG  LYS A 187      29.709  52.624  13.951  1.00 56.61           C  
ATOM   1458  CD  LYS A 187      31.125  52.540  14.508  1.00 59.31           C  
ATOM   1459  CE  LYS A 187      31.132  52.504  16.032  1.00 62.53           C  
ATOM   1460  NZ  LYS A 187      32.513  52.630  16.597  1.00 63.51           N  
ATOM   1461  N   THR A 188      26.892  49.469  12.062  1.00 50.67           N  
ATOM   1462  CA  THR A 188      26.391  48.126  11.763  1.00 49.75           C  
ATOM   1463  C   THR A 188      27.435  47.373  10.947  1.00 49.48           C  
ATOM   1464  O   THR A 188      28.308  47.987  10.342  1.00 50.92           O  
ATOM   1465  CB  THR A 188      25.116  48.169  10.913  1.00 49.60           C  
ATOM   1466  OG1 THR A 188      25.474  48.143   9.524  1.00 49.67           O  
ATOM   1467  CG2 THR A 188      24.326  49.446  11.197  1.00 49.89           C  
ATOM   1468  N   PRO A 189      27.356  46.033  10.908  1.00 49.13           N  
ATOM   1469  CA  PRO A 189      28.347  45.286  10.126  1.00 49.84           C  
ATOM   1470  C   PRO A 189      28.255  45.629   8.642  1.00 50.96           C  
ATOM   1471  O   PRO A 189      29.187  45.394   7.881  1.00 50.17           O  
ATOM   1472  CB  PRO A 189      27.985  43.830  10.408  1.00 48.91           C  
ATOM   1473  CG  PRO A 189      27.388  43.889  11.787  1.00 47.70           C  
ATOM   1474  CD  PRO A 189      26.511  45.115  11.689  1.00 48.45           C  
ATOM   1475  N   SER A 190      27.126  46.197   8.239  1.00 53.28           N  
ATOM   1476  CA  SER A 190      26.911  46.566   6.847  1.00 54.92           C  
ATOM   1477  C   SER A 190      27.170  48.047   6.618  1.00 56.18           C  
ATOM   1478  O   SER A 190      26.519  48.670   5.774  1.00 56.87           O  
ATOM   1479  CB  SER A 190      25.475  46.241   6.427  1.00 55.24           C  
ATOM   1480  OG  SER A 190      25.230  44.849   6.456  1.00 56.30           O  
ATOM   1481  N   GLY A 191      28.104  48.615   7.375  1.00 56.63           N  
ATOM   1482  CA  GLY A 191      28.411  50.027   7.207  1.00 57.02           C  
ATOM   1483  C   GLY A 191      27.944  50.911   8.345  1.00 56.44           C  
ATOM   1484  O   GLY A 191      27.326  50.434   9.296  1.00 56.93           O  
ATOM   1485  N   ASP A 192      28.231  52.206   8.242  1.00 55.14           N  
ATOM   1486  CA  ASP A 192      27.857  53.159   9.279  1.00 53.09           C  
ATOM   1487  C   ASP A 192      26.885  54.221   8.772  1.00 51.33           C  
ATOM   1488  O   ASP A 192      26.837  54.501   7.580  1.00 51.12           O  
ATOM   1489  CB  ASP A 192      29.122  53.798   9.837  1.00 54.89           C  
ATOM   1490  CG  ASP A 192      30.074  52.768  10.435  1.00 57.44           C  
ATOM   1491  OD1 ASP A 192      31.196  53.146  10.842  1.00 59.46           O  
ATOM   1492  OD2 ASP A 192      29.701  51.575  10.503  1.00 57.27           O  
ATOM   1493  N   VAL A 193      26.115  54.806   9.686  1.00 49.59           N  
ATOM   1494  CA  VAL A 193      25.116  55.814   9.330  1.00 49.87           C  
ATOM   1495  C   VAL A 193      25.037  56.972  10.327  1.00 50.07           C  
ATOM   1496  O   VAL A 193      25.299  56.793  11.514  1.00 50.12           O  
ATOM   1497  CB  VAL A 193      23.710  55.164   9.229  1.00 49.68           C  
ATOM   1498  CG1 VAL A 193      22.634  56.225   9.109  1.00 49.50           C  
ATOM   1499  CG2 VAL A 193      23.658  54.244   8.033  1.00 51.32           C  
ATOM   1500  N   TRP A 194      24.673  58.156   9.832  1.00 49.64           N  
ATOM   1501  CA  TRP A 194      24.534  59.345  10.668  1.00 49.52           C  
ATOM   1502  C   TRP A 194      23.058  59.685  10.796  1.00 48.05           C  
ATOM   1503  O   TRP A 194      22.291  59.472   9.861  1.00 47.39           O  
ATOM   1504  CB  TRP A 194      25.252  60.546  10.047  1.00 51.94           C  
ATOM   1505  CG  TRP A 194      26.697  60.331   9.796  1.00 55.23           C  
ATOM   1506  CD1 TRP A 194      27.265  59.758   8.691  1.00 56.82           C  
ATOM   1507  CD2 TRP A 194      27.772  60.650  10.681  1.00 56.55           C  
ATOM   1508  NE1 TRP A 194      28.629  59.699   8.836  1.00 58.03           N  
ATOM   1509  CE2 TRP A 194      28.967  60.240  10.050  1.00 57.96           C  
ATOM   1510  CE3 TRP A 194      27.841  61.242  11.948  1.00 58.29           C  
ATOM   1511  CZ2 TRP A 194      30.223  60.403  10.647  1.00 58.99           C  
ATOM   1512  CZ3 TRP A 194      29.091  61.404  12.544  1.00 59.40           C  
ATOM   1513  CH2 TRP A 194      30.264  60.985  11.892  1.00 59.91           C  
ATOM   1514  N   ALA A 195      22.662  60.226  11.943  1.00 47.09           N  
ATOM   1515  CA  ALA A 195      21.265  60.591  12.152  1.00 46.82           C  
ATOM   1516  C   ALA A 195      21.126  61.793  13.073  1.00 46.09           C  
ATOM   1517  O   ALA A 195      22.077  62.176  13.747  1.00 46.21           O  
ATOM   1518  CB  ALA A 195      20.499  59.407  12.726  1.00 46.90           C  
ATOM   1519  N   ASN A 196      19.939  62.389  13.089  1.00 45.99           N  
ATOM   1520  CA  ASN A 196      19.670  63.534  13.949  1.00 47.31           C  
ATOM   1521  C   ASN A 196      18.886  63.036  15.157  1.00 48.26           C  
ATOM   1522  O   ASN A 196      18.702  63.750  16.142  1.00 49.63           O  
ATOM   1523  CB  ASN A 196      18.838  64.588  13.218  1.00 47.80           C  
ATOM   1524  CG  ASN A 196      19.479  65.049  11.925  1.00 49.50           C  
ATOM   1525  OD1 ASN A 196      20.682  65.316  11.871  1.00 49.10           O  
ATOM   1526  ND2 ASN A 196      18.669  65.160  10.873  1.00 49.81           N  
ATOM   1527  N   HIS A 197      18.413  61.801  15.063  1.00 48.21           N  
ATOM   1528  CA  HIS A 197      17.651  61.186  16.134  1.00 46.69           C  
ATOM   1529  C   HIS A 197      17.822  59.684  16.098  1.00 44.67           C  
ATOM   1530  O   HIS A 197      17.667  59.068  15.048  1.00 45.58           O  
ATOM   1531  CB  HIS A 197      16.166  61.494  15.979  1.00 50.09           C  
ATOM   1532  CG  HIS A 197      15.823  62.934  16.169  1.00 54.31           C  
ATOM   1533  ND1 HIS A 197      15.897  63.560  17.395  1.00 55.52           N  
ATOM   1534  CD2 HIS A 197      15.378  63.867  15.294  1.00 55.29           C  
ATOM   1535  CE1 HIS A 197      15.509  64.816  17.268  1.00 56.44           C  
ATOM   1536  NE2 HIS A 197      15.189  65.028  16.003  1.00 56.63           N  
ATOM   1537  N   VAL A 198      18.156  59.100  17.243  1.00 41.86           N  
ATOM   1538  CA  VAL A 198      18.288  57.657  17.349  1.00 38.66           C  
ATOM   1539  C   VAL A 198      17.269  57.220  18.384  1.00 38.10           C  
ATOM   1540  O   VAL A 198      17.118  57.854  19.429  1.00 38.63           O  
ATOM   1541  CB  VAL A 198      19.666  57.224  17.840  1.00 37.86           C  
ATOM   1542  CG1 VAL A 198      19.701  55.728  17.976  1.00 37.03           C  
ATOM   1543  CG2 VAL A 198      20.728  57.672  16.875  1.00 39.45           C  
ATOM   1544  N   VAL A 199      16.551  56.150  18.081  1.00 36.78           N  
ATOM   1545  CA  VAL A 199      15.557  55.622  19.004  1.00 33.79           C  
ATOM   1546  C   VAL A 199      15.939  54.181  19.310  1.00 32.93           C  
ATOM   1547  O   VAL A 199      16.021  53.348  18.406  1.00 33.30           O  
ATOM   1548  CB  VAL A 199      14.150  55.630  18.379  1.00 33.50           C  
ATOM   1549  CG1 VAL A 199      13.127  55.163  19.395  1.00 32.30           C  
ATOM   1550  CG2 VAL A 199      13.812  57.018  17.863  1.00 32.69           C  
ATOM   1551  N   VAL A 200      16.202  53.894  20.578  1.00 30.82           N  
ATOM   1552  CA  VAL A 200      16.549  52.540  20.984  1.00 28.97           C  
ATOM   1553  C   VAL A 200      15.264  51.770  21.310  1.00 28.50           C  
ATOM   1554  O   VAL A 200      14.549  52.121  22.247  1.00 28.41           O  
ATOM   1555  CB  VAL A 200      17.466  52.555  22.230  1.00 28.53           C  
ATOM   1556  CG1 VAL A 200      17.758  51.135  22.687  1.00 27.56           C  
ATOM   1557  CG2 VAL A 200      18.764  53.274  21.911  1.00 26.39           C  
ATOM   1558  N   ALA A 201      14.959  50.742  20.517  1.00 27.66           N  
ATOM   1559  CA  ALA A 201      13.767  49.911  20.733  1.00 27.63           C  
ATOM   1560  C   ALA A 201      14.138  48.444  20.524  1.00 27.16           C  
ATOM   1561  O   ALA A 201      13.483  47.724  19.769  1.00 26.34           O  
ATOM   1562  CB  ALA A 201      12.637  50.315  19.766  1.00 23.81           C  
ATOM   1563  N   SER A 202      15.194  48.016  21.212  1.00 27.30           N  
ATOM   1564  CA  SER A 202      15.707  46.654  21.111  1.00 27.30           C  
ATOM   1565  C   SER A 202      15.140  45.693  22.147  1.00 27.61           C  
ATOM   1566  O   SER A 202      15.763  44.677  22.459  1.00 28.49           O  
ATOM   1567  CB  SER A 202      17.231  46.661  21.240  1.00 26.64           C  
ATOM   1568  OG  SER A 202      17.850  47.235  20.102  1.00 31.39           O  
ATOM   1569  N   GLY A 203      13.968  46.009  22.682  1.00 26.56           N  
ATOM   1570  CA  GLY A 203      13.367  45.142  23.678  1.00 27.18           C  
ATOM   1571  C   GLY A 203      14.304  44.818  24.829  1.00 26.79           C  
ATOM   1572  O   GLY A 203      15.008  45.693  25.332  1.00 26.27           O  
ATOM   1573  N   VAL A 204      14.330  43.547  25.222  1.00 25.13           N  
ATOM   1574  CA  VAL A 204      15.156  43.088  26.331  1.00 24.98           C  
ATOM   1575  C   VAL A 204      16.661  43.206  26.084  1.00 26.15           C  
ATOM   1576  O   VAL A 204      17.455  43.095  27.017  1.00 26.12           O  
ATOM   1577  CB  VAL A 204      14.795  41.613  26.705  1.00 24.06           C  
ATOM   1578  CG1 VAL A 204      15.270  40.660  25.624  1.00 23.75           C  
ATOM   1579  CG2 VAL A 204      15.395  41.248  28.039  1.00 22.51           C  
ATOM   1580  N   TRP A 205      17.065  43.443  24.841  1.00 26.30           N  
ATOM   1581  CA  TRP A 205      18.492  43.567  24.532  1.00 26.57           C  
ATOM   1582  C   TRP A 205      18.953  45.022  24.554  1.00 27.03           C  
ATOM   1583  O   TRP A 205      20.094  45.327  24.214  1.00 27.26           O  
ATOM   1584  CB  TRP A 205      18.792  42.945  23.159  1.00 26.20           C  
ATOM   1585  CG  TRP A 205      18.489  41.474  23.094  1.00 23.08           C  
ATOM   1586  CD1 TRP A 205      19.313  40.447  23.456  1.00 22.59           C  
ATOM   1587  CD2 TRP A 205      17.233  40.879  22.744  1.00 21.59           C  
ATOM   1588  NE1 TRP A 205      18.644  39.244  23.362  1.00 22.79           N  
ATOM   1589  CE2 TRP A 205      17.366  39.482  22.925  1.00 21.71           C  
ATOM   1590  CE3 TRP A 205      16.004  41.392  22.303  1.00 19.65           C  
ATOM   1591  CZ2 TRP A 205      16.311  38.589  22.680  1.00 19.96           C  
ATOM   1592  CZ3 TRP A 205      14.954  40.505  22.060  1.00 18.07           C  
ATOM   1593  CH2 TRP A 205      15.117  39.119  22.251  1.00 18.64           C  
ATOM   1594  N   SER A 206      18.071  45.914  24.980  1.00 27.63           N  
ATOM   1595  CA  SER A 206      18.384  47.337  25.021  1.00 27.82           C  
ATOM   1596  C   SER A 206      19.517  47.752  25.957  1.00 29.43           C  
ATOM   1597  O   SER A 206      20.152  48.794  25.750  1.00 30.36           O  
ATOM   1598  CB  SER A 206      17.128  48.114  25.378  1.00 23.60           C  
ATOM   1599  OG  SER A 206      16.130  47.857  24.418  1.00 21.84           O  
ATOM   1600  N   GLY A 207      19.772  46.935  26.971  1.00 29.81           N  
ATOM   1601  CA  GLY A 207      20.801  47.252  27.939  1.00 31.26           C  
ATOM   1602  C   GLY A 207      22.117  47.765  27.393  1.00 35.04           C  
ATOM   1603  O   GLY A 207      22.621  48.789  27.852  1.00 35.36           O  
ATOM   1604  N   MET A 208      22.679  47.069  26.409  1.00 36.94           N  
ATOM   1605  CA  MET A 208      23.964  47.471  25.859  1.00 37.83           C  
ATOM   1606  C   MET A 208      23.989  48.904  25.338  1.00 37.89           C  
ATOM   1607  O   MET A 208      25.028  49.564  25.393  1.00 38.20           O  
ATOM   1608  CB  MET A 208      24.412  46.503  24.751  1.00 41.37           C  
ATOM   1609  CG  MET A 208      23.808  46.756  23.375  1.00 46.02           C  
ATOM   1610  SD  MET A 208      24.676  45.849  22.055  1.00 51.37           S  
ATOM   1611  CE  MET A 208      26.274  46.588  22.130  1.00 48.92           C  
ATOM   1612  N   PHE A 209      22.863  49.393  24.830  1.00 37.06           N  
ATOM   1613  CA  PHE A 209      22.832  50.756  24.316  1.00 37.60           C  
ATOM   1614  C   PHE A 209      22.788  51.753  25.456  1.00 37.87           C  
ATOM   1615  O   PHE A 209      23.504  52.753  25.434  1.00 38.90           O  
ATOM   1616  CB  PHE A 209      21.649  50.946  23.374  1.00 37.59           C  
ATOM   1617  CG  PHE A 209      21.773  50.166  22.094  1.00 37.31           C  
ATOM   1618  CD1 PHE A 209      22.860  50.368  21.249  1.00 36.12           C  
ATOM   1619  CD2 PHE A 209      20.810  49.229  21.733  1.00 35.38           C  
ATOM   1620  CE1 PHE A 209      22.987  49.647  20.061  1.00 35.75           C  
ATOM   1621  CE2 PHE A 209      20.926  48.505  20.548  1.00 35.95           C  
ATOM   1622  CZ  PHE A 209      22.016  48.713  19.710  1.00 35.81           C  
ATOM   1623  N   PHE A 210      21.954  51.481  26.455  1.00 37.42           N  
ATOM   1624  CA  PHE A 210      21.873  52.345  27.632  1.00 36.70           C  
ATOM   1625  C   PHE A 210      23.291  52.478  28.196  1.00 37.79           C  
ATOM   1626  O   PHE A 210      23.793  53.586  28.407  1.00 37.18           O  
ATOM   1627  CB  PHE A 210      20.975  51.714  28.693  1.00 33.47           C  
ATOM   1628  CG  PHE A 210      19.523  52.052  28.548  1.00 31.52           C  
ATOM   1629  CD1 PHE A 210      19.016  53.227  29.084  1.00 31.54           C  
ATOM   1630  CD2 PHE A 210      18.656  51.182  27.908  1.00 31.06           C  
ATOM   1631  CE1 PHE A 210      17.665  53.534  28.996  1.00 30.73           C  
ATOM   1632  CE2 PHE A 210      17.301  51.475  27.808  1.00 32.24           C  
ATOM   1633  CZ  PHE A 210      16.802  52.656  28.357  1.00 33.36           C  
ATOM   1634  N   LYS A 211      23.933  51.337  28.425  1.00 37.89           N  
ATOM   1635  CA  LYS A 211      25.284  51.319  28.965  1.00 39.87           C  
ATOM   1636  C   LYS A 211      26.274  52.049  28.051  1.00 40.37           C  
ATOM   1637  O   LYS A 211      27.189  52.721  28.520  1.00 41.86           O  
ATOM   1638  CB  LYS A 211      25.742  49.877  29.189  1.00 40.51           C  
ATOM   1639  CG  LYS A 211      27.076  49.771  29.916  1.00 46.17           C  
ATOM   1640  CD  LYS A 211      26.993  50.422  31.292  1.00 50.40           C  
ATOM   1641  CE  LYS A 211      28.374  50.793  31.834  1.00 52.25           C  
ATOM   1642  NZ  LYS A 211      28.266  51.712  33.015  1.00 53.11           N  
ATOM   1643  N   GLN A 212      26.090  51.923  26.745  1.00 40.28           N  
ATOM   1644  CA  GLN A 212      26.978  52.583  25.793  1.00 39.70           C  
ATOM   1645  C   GLN A 212      26.840  54.096  25.903  1.00 39.71           C  
ATOM   1646  O   GLN A 212      27.800  54.833  25.693  1.00 38.85           O  
ATOM   1647  CB  GLN A 212      26.627  52.161  24.368  1.00 37.91           C  
ATOM   1648  CG  GLN A 212      27.603  51.228  23.714  1.00 35.28           C  
ATOM   1649  CD  GLN A 212      27.057  50.678  22.408  1.00 37.74           C  
ATOM   1650  OE1 GLN A 212      26.355  51.378  21.670  1.00 36.64           O  
ATOM   1651  NE2 GLN A 212      27.386  49.425  22.108  1.00 36.79           N  
ATOM   1652  N   LEU A 213      25.635  54.547  26.239  1.00 39.36           N  
ATOM   1653  CA  LEU A 213      25.348  55.968  26.345  1.00 38.41           C  
ATOM   1654  C   LEU A 213      25.432  56.532  27.763  1.00 37.73           C  
ATOM   1655  O   LEU A 213      24.887  57.598  28.040  1.00 36.35           O  
ATOM   1656  CB  LEU A 213      23.963  56.245  25.761  1.00 39.72           C  
ATOM   1657  CG  LEU A 213      23.778  55.768  24.318  1.00 40.32           C  
ATOM   1658  CD1 LEU A 213      22.360  56.065  23.852  1.00 40.17           C  
ATOM   1659  CD2 LEU A 213      24.796  56.468  23.424  1.00 40.55           C  
ATOM   1660  N   GLY A 214      26.102  55.812  28.659  1.00 37.51           N  
ATOM   1661  CA  GLY A 214      26.252  56.295  30.021  1.00 37.89           C  
ATOM   1662  C   GLY A 214      25.164  55.999  31.044  1.00 38.90           C  
ATOM   1663  O   GLY A 214      25.363  56.264  32.226  1.00 40.09           O  
ATOM   1664  N   LEU A 215      24.020  55.475  30.617  1.00 37.92           N  
ATOM   1665  CA  LEU A 215      22.952  55.148  31.556  1.00 38.04           C  
ATOM   1666  C   LEU A 215      23.181  53.733  32.076  1.00 38.78           C  
ATOM   1667  O   LEU A 215      23.876  52.947  31.435  1.00 40.76           O  
ATOM   1668  CB  LEU A 215      21.597  55.236  30.857  1.00 37.54           C  
ATOM   1669  CG  LEU A 215      21.386  56.587  30.174  1.00 38.36           C  
ATOM   1670  CD1 LEU A 215      20.047  56.628  29.453  1.00 36.99           C  
ATOM   1671  CD2 LEU A 215      21.462  57.678  31.225  1.00 37.53           C  
ATOM   1672  N   ASN A 216      22.616  53.406  33.236  1.00 38.63           N  
ATOM   1673  CA  ASN A 216      22.783  52.065  33.798  1.00 36.90           C  
ATOM   1674  C   ASN A 216      21.480  51.280  33.913  1.00 34.39           C  
ATOM   1675  O   ASN A 216      21.420  50.253  34.586  1.00 32.07           O  
ATOM   1676  CB  ASN A 216      23.469  52.134  35.161  1.00 38.77           C  
ATOM   1677  CG  ASN A 216      24.956  52.393  35.044  1.00 43.20           C  
ATOM   1678  OD1 ASN A 216      25.687  52.345  36.033  1.00 47.58           O  
ATOM   1679  ND2 ASN A 216      25.414  52.667  33.829  1.00 44.20           N  
ATOM   1680  N   ASN A 217      20.441  51.771  33.251  1.00 31.87           N  
ATOM   1681  CA  ASN A 217      19.155  51.100  33.249  1.00 31.72           C  
ATOM   1682  C   ASN A 217      19.371  49.631  32.881  1.00 31.71           C  
ATOM   1683  O   ASN A 217      19.988  49.327  31.865  1.00 33.15           O  
ATOM   1684  CB  ASN A 217      18.239  51.753  32.222  1.00 31.33           C  
ATOM   1685  CG  ASN A 217      18.014  53.229  32.492  1.00 31.93           C  
ATOM   1686  OD1 ASN A 217      18.970  53.994  32.674  1.00 32.92           O  
ATOM   1687  ND2 ASN A 217      16.744  53.642  32.511  1.00 27.93           N  
ATOM   1688  N   ALA A 218      18.865  48.721  33.703  1.00 31.33           N  
ATOM   1689  CA  ALA A 218      19.030  47.301  33.437  1.00 29.55           C  
ATOM   1690  C   ALA A 218      17.764  46.626  32.921  1.00 28.82           C  
ATOM   1691  O   ALA A 218      16.647  47.104  33.120  1.00 26.81           O  
ATOM   1692  CB  ALA A 218      19.509  46.596  34.687  1.00 28.43           C  
ATOM   1693  N   PHE A 219      17.966  45.509  32.234  1.00 28.29           N  
ATOM   1694  CA  PHE A 219      16.869  44.726  31.688  1.00 27.14           C  
ATOM   1695  C   PHE A 219      17.092  43.296  32.124  1.00 24.72           C  
ATOM   1696  O   PHE A 219      18.220  42.808  32.164  1.00 25.98           O  
ATOM   1697  CB  PHE A 219      16.829  44.846  30.162  1.00 26.91           C  
ATOM   1698  CG  PHE A 219      16.363  46.188  29.687  1.00 27.25           C  
ATOM   1699  CD1 PHE A 219      15.006  46.440  29.496  1.00 26.89           C  
ATOM   1700  CD2 PHE A 219      17.273  47.229  29.497  1.00 27.80           C  
ATOM   1701  CE1 PHE A 219      14.556  47.710  29.129  1.00 25.94           C  
ATOM   1702  CE2 PHE A 219      16.836  48.507  29.128  1.00 24.81           C  
ATOM   1703  CZ  PHE A 219      15.476  48.747  28.944  1.00 25.34           C  
ATOM   1704  N   LEU A 220      16.002  42.643  32.479  1.00 24.46           N  
ATOM   1705  CA  LEU A 220      16.021  41.270  32.959  1.00 24.92           C  
ATOM   1706  C   LEU A 220      14.956  40.543  32.160  1.00 25.78           C  
ATOM   1707  O   LEU A 220      13.792  40.962  32.115  1.00 27.42           O  
ATOM   1708  CB  LEU A 220      15.685  41.267  34.456  1.00 27.23           C  
ATOM   1709  CG  LEU A 220      15.719  40.023  35.339  1.00 29.61           C  
ATOM   1710  CD1 LEU A 220      14.448  39.227  35.153  1.00 31.71           C  
ATOM   1711  CD2 LEU A 220      16.966  39.205  35.021  1.00 31.74           C  
ATOM   1712  N   PRO A 221      15.336  39.456  31.489  1.00 25.45           N  
ATOM   1713  CA  PRO A 221      14.319  38.753  30.717  1.00 23.13           C  
ATOM   1714  C   PRO A 221      13.432  37.939  31.622  1.00 23.32           C  
ATOM   1715  O   PRO A 221      13.901  37.328  32.587  1.00 25.68           O  
ATOM   1716  CB  PRO A 221      15.142  37.864  29.803  1.00 24.06           C  
ATOM   1717  CG  PRO A 221      16.301  37.483  30.696  1.00 24.25           C  
ATOM   1718  CD  PRO A 221      16.658  38.820  31.330  1.00 25.53           C  
ATOM   1719  N   VAL A 222      12.141  37.957  31.340  1.00 21.04           N  
ATOM   1720  CA  VAL A 222      11.224  37.146  32.107  1.00 20.31           C  
ATOM   1721  C   VAL A 222      10.573  36.262  31.051  1.00 21.07           C  
ATOM   1722  O   VAL A 222       9.649  36.672  30.335  1.00 19.86           O  
ATOM   1723  CB  VAL A 222      10.175  37.986  32.859  1.00 20.09           C  
ATOM   1724  CG1 VAL A 222       9.319  37.079  33.736  1.00 19.10           C  
ATOM   1725  CG2 VAL A 222      10.862  39.016  33.715  1.00 18.34           C  
ATOM   1726  N   LYS A 223      11.105  35.050  30.940  1.00 19.79           N  
ATOM   1727  CA  LYS A 223      10.628  34.092  29.969  1.00 20.29           C  
ATOM   1728  C   LYS A 223       9.173  33.708  30.174  1.00 22.06           C  
ATOM   1729  O   LYS A 223       8.712  33.552  31.302  1.00 22.42           O  
ATOM   1730  CB  LYS A 223      11.500  32.844  30.016  1.00 18.25           C  
ATOM   1731  CG  LYS A 223      11.166  31.816  28.957  1.00 15.50           C  
ATOM   1732  CD  LYS A 223      12.086  30.614  29.122  1.00 16.97           C  
ATOM   1733  CE  LYS A 223      11.849  29.571  28.053  1.00 17.35           C  
ATOM   1734  NZ  LYS A 223      12.798  28.451  28.199  1.00 17.77           N  
ATOM   1735  N   GLY A 224       8.463  33.561  29.061  1.00 22.36           N  
ATOM   1736  CA  GLY A 224       7.067  33.167  29.081  1.00 21.07           C  
ATOM   1737  C   GLY A 224       6.888  32.040  28.080  1.00 21.71           C  
ATOM   1738  O   GLY A 224       7.244  32.182  26.913  1.00 22.34           O  
ATOM   1739  N   GLU A 225       6.343  30.918  28.539  1.00 23.39           N  
ATOM   1740  CA  GLU A 225       6.125  29.743  27.696  1.00 22.71           C  
ATOM   1741  C   GLU A 225       4.643  29.558  27.406  1.00 23.38           C  
ATOM   1742  O   GLU A 225       3.811  29.708  28.301  1.00 23.84           O  
ATOM   1743  CB  GLU A 225       6.710  28.513  28.393  1.00 21.49           C  
ATOM   1744  CG  GLU A 225       8.206  28.659  28.609  1.00 23.48           C  
ATOM   1745  CD  GLU A 225       8.775  27.716  29.639  1.00 25.48           C  
ATOM   1746  OE1 GLU A 225       8.301  27.746  30.790  1.00 28.52           O  
ATOM   1747  OE2 GLU A 225       9.706  26.953  29.306  1.00 28.45           O  
ATOM   1748  N   CYS A 226       4.324  29.242  26.150  1.00 24.46           N  
ATOM   1749  CA  CYS A 226       2.938  29.052  25.709  1.00 23.84           C  
ATOM   1750  C   CYS A 226       2.745  27.857  24.796  1.00 22.26           C  
ATOM   1751  O   CYS A 226       3.699  27.220  24.356  1.00 23.03           O  
ATOM   1752  CB  CYS A 226       2.457  30.254  24.912  1.00 26.62           C  
ATOM   1753  SG  CYS A 226       2.744  31.829  25.634  1.00 34.94           S  
ATOM   1754  N   LEU A 227       1.483  27.598  24.483  1.00 20.04           N  
ATOM   1755  CA  LEU A 227       1.114  26.516  23.593  1.00 20.38           C  
ATOM   1756  C   LEU A 227      -0.204  26.885  22.936  1.00 20.50           C  
ATOM   1757  O   LEU A 227      -0.858  27.841  23.340  1.00 22.17           O  
ATOM   1758  CB  LEU A 227       0.978  25.206  24.370  1.00 19.95           C  
ATOM   1759  CG  LEU A 227      -0.106  25.054  25.430  1.00 18.91           C  
ATOM   1760  CD1 LEU A 227      -1.430  24.712  24.780  1.00 19.38           C  
ATOM   1761  CD2 LEU A 227       0.297  23.950  26.365  1.00 19.14           C  
ATOM   1762  N   SER A 228      -0.577  26.154  21.899  1.00 20.95           N  
ATOM   1763  CA  SER A 228      -1.839  26.413  21.222  1.00 20.42           C  
ATOM   1764  C   SER A 228      -2.504  25.082  20.929  1.00 19.93           C  
ATOM   1765  O   SER A 228      -1.845  24.042  20.860  1.00 18.85           O  
ATOM   1766  CB  SER A 228      -1.620  27.199  19.920  1.00 21.78           C  
ATOM   1767  OG  SER A 228      -0.834  26.491  18.977  1.00 22.00           O  
ATOM   1768  N   VAL A 229      -3.819  25.119  20.774  1.00 20.63           N  
ATOM   1769  CA  VAL A 229      -4.594  23.922  20.481  1.00 20.04           C  
ATOM   1770  C   VAL A 229      -5.655  24.283  19.461  1.00 22.07           C  
ATOM   1771  O   VAL A 229      -5.885  25.456  19.162  1.00 22.06           O  
ATOM   1772  CB  VAL A 229      -5.330  23.374  21.750  1.00 19.93           C  
ATOM   1773  CG1 VAL A 229      -4.323  22.915  22.803  1.00 17.57           C  
ATOM   1774  CG2 VAL A 229      -6.252  24.451  22.325  1.00 15.24           C  
ATOM   1775  N   TRP A 230      -6.301  23.262  18.920  1.00 24.50           N  
ATOM   1776  CA  TRP A 230      -7.379  23.480  17.979  1.00 25.44           C  
ATOM   1777  C   TRP A 230      -8.668  23.246  18.752  1.00 26.73           C  
ATOM   1778  O   TRP A 230      -8.843  22.208  19.388  1.00 25.32           O  
ATOM   1779  CB  TRP A 230      -7.293  22.498  16.814  1.00 26.16           C  
ATOM   1780  CG  TRP A 230      -6.109  22.729  15.939  1.00 26.89           C  
ATOM   1781  CD1 TRP A 230      -4.925  22.064  15.973  1.00 25.92           C  
ATOM   1782  CD2 TRP A 230      -5.987  23.724  14.918  1.00 25.65           C  
ATOM   1783  NE1 TRP A 230      -4.067  22.579  15.037  1.00 26.63           N  
ATOM   1784  CE2 TRP A 230      -4.692  23.602  14.374  1.00 27.07           C  
ATOM   1785  CE3 TRP A 230      -6.846  24.709  14.412  1.00 26.98           C  
ATOM   1786  CZ2 TRP A 230      -4.226  24.431  13.340  1.00 27.89           C  
ATOM   1787  CZ3 TRP A 230      -6.386  25.539  13.382  1.00 28.87           C  
ATOM   1788  CH2 TRP A 230      -5.084  25.389  12.860  1.00 28.10           C  
ATOM   1789  N   ASN A 231      -9.550  24.232  18.725  1.00 28.16           N  
ATOM   1790  CA  ASN A 231     -10.826  24.116  19.395  1.00 29.63           C  
ATOM   1791  C   ASN A 231     -11.873  23.889  18.321  1.00 32.00           C  
ATOM   1792  O   ASN A 231     -12.495  24.832  17.851  1.00 32.79           O  
ATOM   1793  CB  ASN A 231     -11.146  25.393  20.167  1.00 28.49           C  
ATOM   1794  CG  ASN A 231     -12.563  25.402  20.685  1.00 25.75           C  
ATOM   1795  OD1 ASN A 231     -13.177  24.354  20.832  1.00 25.42           O  
ATOM   1796  ND2 ASN A 231     -13.085  26.581  20.970  1.00 25.86           N  
ATOM   1797  N   ASP A 232     -12.056  22.634  17.929  1.00 35.80           N  
ATOM   1798  CA  ASP A 232     -13.024  22.307  16.891  1.00 39.99           C  
ATOM   1799  C   ASP A 232     -14.390  21.920  17.446  1.00 42.19           C  
ATOM   1800  O   ASP A 232     -15.349  21.792  16.687  1.00 43.65           O  
ATOM   1801  CB  ASP A 232     -12.526  21.141  16.026  1.00 40.55           C  
ATOM   1802  CG  ASP A 232     -11.120  21.356  15.479  1.00 42.52           C  
ATOM   1803  OD1 ASP A 232     -10.806  22.462  14.977  1.00 41.33           O  
ATOM   1804  OD2 ASP A 232     -10.327  20.391  15.541  1.00 44.47           O  
ATOM   1805  N   ASP A 233     -14.494  21.761  18.759  1.00 43.77           N  
ATOM   1806  CA  ASP A 233     -15.752  21.322  19.335  1.00 45.12           C  
ATOM   1807  C   ASP A 233     -16.603  22.248  20.187  1.00 44.39           C  
ATOM   1808  O   ASP A 233     -17.814  22.297  20.006  1.00 44.76           O  
ATOM   1809  CB  ASP A 233     -15.507  20.027  20.098  1.00 48.91           C  
ATOM   1810  CG  ASP A 233     -15.026  18.913  19.191  1.00 53.71           C  
ATOM   1811  OD1 ASP A 233     -15.714  18.637  18.180  1.00 57.38           O  
ATOM   1812  OD2 ASP A 233     -13.965  18.318  19.481  1.00 55.64           O  
ATOM   1813  N   ILE A 234     -16.006  22.979  21.115  1.00 43.28           N  
ATOM   1814  CA  ILE A 234     -16.815  23.842  21.955  1.00 41.36           C  
ATOM   1815  C   ILE A 234     -16.740  25.305  21.605  1.00 41.14           C  
ATOM   1816  O   ILE A 234     -15.757  25.778  21.045  1.00 42.52           O  
ATOM   1817  CB  ILE A 234     -16.444  23.702  23.433  1.00 40.40           C  
ATOM   1818  CG1 ILE A 234     -15.042  24.248  23.669  1.00 38.16           C  
ATOM   1819  CG2 ILE A 234     -16.546  22.254  23.849  1.00 40.22           C  
ATOM   1820  CD1 ILE A 234     -14.933  25.092  24.922  1.00 38.47           C  
ATOM   1821  N   PRO A 235     -17.799  26.051  21.935  1.00 41.20           N  
ATOM   1822  CA  PRO A 235     -17.822  27.484  21.644  1.00 39.37           C  
ATOM   1823  C   PRO A 235     -16.980  28.244  22.675  1.00 37.45           C  
ATOM   1824  O   PRO A 235     -16.915  27.856  23.844  1.00 36.14           O  
ATOM   1825  CB  PRO A 235     -19.313  27.841  21.762  1.00 39.35           C  
ATOM   1826  CG  PRO A 235     -20.030  26.511  21.665  1.00 39.64           C  
ATOM   1827  CD  PRO A 235     -19.116  25.594  22.406  1.00 39.33           C  
ATOM   1828  N   LEU A 236     -16.327  29.309  22.230  1.00 34.57           N  
ATOM   1829  CA  LEU A 236     -15.536  30.158  23.111  1.00 33.34           C  
ATOM   1830  C   LEU A 236     -15.339  31.471  22.367  1.00 33.09           C  
ATOM   1831  O   LEU A 236     -14.657  31.528  21.350  1.00 34.06           O  
ATOM   1832  CB  LEU A 236     -14.182  29.519  23.451  1.00 32.28           C  
ATOM   1833  CG  LEU A 236     -13.360  30.344  24.458  1.00 32.93           C  
ATOM   1834  CD1 LEU A 236     -14.137  30.482  25.760  1.00 31.15           C  
ATOM   1835  CD2 LEU A 236     -12.008  29.697  24.716  1.00 30.95           C  
ATOM   1836  N   THR A 237     -15.960  32.528  22.864  1.00 32.27           N  
ATOM   1837  CA  THR A 237     -15.853  33.821  22.216  1.00 32.91           C  
ATOM   1838  C   THR A 237     -15.072  34.783  23.093  1.00 33.79           C  
ATOM   1839  O   THR A 237     -14.352  35.650  22.597  1.00 34.93           O  
ATOM   1840  CB  THR A 237     -17.254  34.422  21.939  1.00 34.22           C  
ATOM   1841  OG1 THR A 237     -17.994  33.546  21.079  1.00 33.36           O  
ATOM   1842  CG2 THR A 237     -17.129  35.795  21.280  1.00 32.97           C  
ATOM   1843  N   LYS A 238     -15.221  34.631  24.403  1.00 33.38           N  
ATOM   1844  CA  LYS A 238     -14.525  35.495  25.334  1.00 33.32           C  
ATOM   1845  C   LYS A 238     -13.179  34.880  25.681  1.00 32.85           C  
ATOM   1846  O   LYS A 238     -13.008  33.661  25.647  1.00 30.46           O  
ATOM   1847  CB  LYS A 238     -15.318  35.652  26.639  1.00 35.11           C  
ATOM   1848  CG  LYS A 238     -16.801  35.944  26.502  1.00 40.32           C  
ATOM   1849  CD  LYS A 238     -17.100  37.381  26.131  1.00 41.09           C  
ATOM   1850  CE  LYS A 238     -18.612  37.656  26.192  1.00 41.84           C  
ATOM   1851  NZ  LYS A 238     -19.403  36.789  25.268  1.00 40.08           N  
ATOM   1852  N   THR A 239     -12.226  35.740  26.012  1.00 31.73           N  
ATOM   1853  CA  THR A 239     -10.909  35.292  26.441  1.00 31.55           C  
ATOM   1854  C   THR A 239     -11.051  34.977  27.938  1.00 31.30           C  
ATOM   1855  O   THR A 239     -11.659  35.753  28.671  1.00 32.58           O  
ATOM   1856  CB  THR A 239      -9.867  36.416  26.271  1.00 30.06           C  
ATOM   1857  OG1 THR A 239      -9.669  36.679  24.878  1.00 29.58           O  
ATOM   1858  CG2 THR A 239      -8.564  36.037  26.914  1.00 28.27           C  
ATOM   1859  N   LEU A 240     -10.521  33.841  28.384  1.00 30.77           N  
ATOM   1860  CA  LEU A 240     -10.588  33.474  29.798  1.00 30.55           C  
ATOM   1861  C   LEU A 240      -9.263  33.891  30.431  1.00 32.05           C  
ATOM   1862  O   LEU A 240      -8.193  33.508  29.952  1.00 31.20           O  
ATOM   1863  CB  LEU A 240     -10.826  31.965  29.950  1.00 28.58           C  
ATOM   1864  CG  LEU A 240     -12.269  31.468  29.761  1.00 28.45           C  
ATOM   1865  CD1 LEU A 240     -12.907  32.144  28.570  1.00 29.75           C  
ATOM   1866  CD2 LEU A 240     -12.281  29.958  29.588  1.00 26.80           C  
ATOM   1867  N   TYR A 241      -9.343  34.685  31.498  1.00 33.46           N  
ATOM   1868  CA  TYR A 241      -8.157  35.207  32.178  1.00 35.13           C  
ATOM   1869  C   TYR A 241      -8.146  34.942  33.685  1.00 36.20           C  
ATOM   1870  O   TYR A 241      -9.163  35.079  34.358  1.00 36.41           O  
ATOM   1871  CB  TYR A 241      -8.077  36.715  31.943  1.00 36.42           C  
ATOM   1872  CG  TYR A 241      -6.777  37.373  32.359  1.00 41.49           C  
ATOM   1873  CD1 TYR A 241      -5.841  37.780  31.400  1.00 43.67           C  
ATOM   1874  CD2 TYR A 241      -6.484  37.613  33.705  1.00 42.15           C  
ATOM   1875  CE1 TYR A 241      -4.651  38.412  31.769  1.00 44.73           C  
ATOM   1876  CE2 TYR A 241      -5.296  38.243  34.084  1.00 43.05           C  
ATOM   1877  CZ  TYR A 241      -4.388  38.641  33.111  1.00 45.59           C  
ATOM   1878  OH  TYR A 241      -3.223  39.279  33.474  1.00 49.03           O  
ATOM   1879  N   HIS A 242      -6.983  34.570  34.213  1.00 37.37           N  
ATOM   1880  CA  HIS A 242      -6.836  34.329  35.645  1.00 37.07           C  
ATOM   1881  C   HIS A 242      -5.384  34.206  36.070  1.00 37.59           C  
ATOM   1882  O   HIS A 242      -4.627  33.399  35.528  1.00 36.61           O  
ATOM   1883  CB  HIS A 242      -7.568  33.067  36.087  1.00 37.66           C  
ATOM   1884  CG  HIS A 242      -7.500  32.833  37.563  1.00 38.43           C  
ATOM   1885  ND1 HIS A 242      -8.187  33.611  38.474  1.00 38.69           N  
ATOM   1886  CD2 HIS A 242      -6.802  31.930  38.292  1.00 38.81           C  
ATOM   1887  CE1 HIS A 242      -7.914  33.196  39.698  1.00 36.50           C  
ATOM   1888  NE2 HIS A 242      -7.077  32.178  39.616  1.00 38.05           N  
ATOM   1889  N   ASP A 243      -5.019  35.010  37.063  1.00 37.24           N  
ATOM   1890  CA  ASP A 243      -3.676  35.028  37.608  1.00 36.45           C  
ATOM   1891  C   ASP A 243      -2.610  35.096  36.518  1.00 35.48           C  
ATOM   1892  O   ASP A 243      -1.675  34.288  36.491  1.00 34.18           O  
ATOM   1893  CB  ASP A 243      -3.463  33.801  38.498  1.00 37.72           C  
ATOM   1894  CG  ASP A 243      -2.215  33.917  39.355  1.00 41.10           C  
ATOM   1895  OD1 ASP A 243      -1.817  35.058  39.683  1.00 40.78           O  
ATOM   1896  OD2 ASP A 243      -1.638  32.870  39.716  1.00 43.79           O  
ATOM   1897  N   HIS A 244      -2.769  36.075  35.625  1.00 34.40           N  
ATOM   1898  CA  HIS A 244      -1.848  36.316  34.516  1.00 33.36           C  
ATOM   1899  C   HIS A 244      -1.810  35.208  33.468  1.00 32.99           C  
ATOM   1900  O   HIS A 244      -1.015  35.266  32.530  1.00 35.71           O  
ATOM   1901  CB  HIS A 244      -0.440  36.562  35.052  1.00 34.06           C  
ATOM   1902  CG  HIS A 244      -0.336  37.760  35.944  1.00 37.55           C  
ATOM   1903  ND1 HIS A 244      -0.527  39.048  35.487  1.00 37.30           N  
ATOM   1904  CD2 HIS A 244      -0.055  37.865  37.267  1.00 35.38           C  
ATOM   1905  CE1 HIS A 244      -0.363  39.895  36.489  1.00 38.74           C  
ATOM   1906  NE2 HIS A 244      -0.077  39.203  37.579  1.00 35.85           N  
ATOM   1907  N   CYS A 245      -2.659  34.199  33.632  1.00 31.14           N  
ATOM   1908  CA  CYS A 245      -2.740  33.104  32.681  1.00 28.11           C  
ATOM   1909  C   CYS A 245      -3.977  33.304  31.826  1.00 28.33           C  
ATOM   1910  O   CYS A 245      -4.912  33.995  32.228  1.00 28.35           O  
ATOM   1911  CB  CYS A 245      -2.752  31.778  33.408  1.00 26.83           C  
ATOM   1912  SG  CYS A 245      -1.146  31.543  34.189  1.00 33.34           S  
ATOM   1913  N   TYR A 246      -4.000  32.692  30.650  1.00 27.89           N  
ATOM   1914  CA  TYR A 246      -5.104  32.948  29.747  1.00 25.50           C  
ATOM   1915  C   TYR A 246      -5.398  31.893  28.685  1.00 24.79           C  
ATOM   1916  O   TYR A 246      -4.620  30.961  28.452  1.00 23.38           O  
ATOM   1917  CB  TYR A 246      -4.802  34.272  29.055  1.00 26.43           C  
ATOM   1918  CG  TYR A 246      -3.385  34.292  28.514  1.00 28.10           C  
ATOM   1919  CD1 TYR A 246      -3.044  33.564  27.368  1.00 27.65           C  
ATOM   1920  CD2 TYR A 246      -2.366  34.960  29.195  1.00 29.83           C  
ATOM   1921  CE1 TYR A 246      -1.729  33.496  26.918  1.00 27.31           C  
ATOM   1922  CE2 TYR A 246      -1.042  34.897  28.751  1.00 30.32           C  
ATOM   1923  CZ  TYR A 246      -0.737  34.165  27.613  1.00 29.51           C  
ATOM   1924  OH  TYR A 246       0.559  34.118  27.169  1.00 32.42           O  
ATOM   1925  N   ILE A 247      -6.543  32.075  28.039  1.00 23.52           N  
ATOM   1926  CA  ILE A 247      -6.990  31.212  26.961  1.00 21.20           C  
ATOM   1927  C   ILE A 247      -7.668  32.157  25.981  1.00 23.36           C  
ATOM   1928  O   ILE A 247      -8.777  32.627  26.221  1.00 22.65           O  
ATOM   1929  CB  ILE A 247      -8.005  30.170  27.448  1.00 19.08           C  
ATOM   1930  CG1 ILE A 247      -7.377  29.311  28.542  1.00 15.84           C  
ATOM   1931  CG2 ILE A 247      -8.461  29.303  26.274  1.00 17.37           C  
ATOM   1932  CD1 ILE A 247      -8.250  28.160  28.992  1.00 18.75           C  
ATOM   1933  N   VAL A 248      -6.995  32.469  24.883  1.00 24.49           N  
ATOM   1934  CA  VAL A 248      -7.599  33.379  23.925  1.00 25.55           C  
ATOM   1935  C   VAL A 248      -7.986  32.646  22.656  1.00 25.74           C  
ATOM   1936  O   VAL A 248      -7.162  31.976  22.034  1.00 26.28           O  
ATOM   1937  CB  VAL A 248      -6.652  34.571  23.608  1.00 24.96           C  
ATOM   1938  CG1 VAL A 248      -5.588  34.671  24.691  1.00 23.03           C  
ATOM   1939  CG2 VAL A 248      -6.037  34.429  22.225  1.00 24.57           C  
ATOM   1940  N   PRO A 249      -9.266  32.731  22.278  1.00 26.65           N  
ATOM   1941  CA  PRO A 249      -9.776  32.076  21.072  1.00 26.84           C  
ATOM   1942  C   PRO A 249      -9.440  32.916  19.850  1.00 28.09           C  
ATOM   1943  O   PRO A 249      -9.840  34.073  19.765  1.00 29.70           O  
ATOM   1944  CB  PRO A 249     -11.274  32.001  21.341  1.00 27.33           C  
ATOM   1945  CG  PRO A 249     -11.525  33.271  22.109  1.00 26.05           C  
ATOM   1946  CD  PRO A 249     -10.365  33.313  23.070  1.00 25.98           C  
ATOM   1947  N   ARG A 250      -8.686  32.351  18.914  1.00 30.13           N  
ATOM   1948  CA  ARG A 250      -8.320  33.094  17.709  1.00 31.52           C  
ATOM   1949  C   ARG A 250      -9.344  32.811  16.622  1.00 32.63           C  
ATOM   1950  O   ARG A 250     -10.057  31.807  16.677  1.00 32.43           O  
ATOM   1951  CB  ARG A 250      -6.925  32.696  17.219  1.00 31.21           C  
ATOM   1952  CG  ARG A 250      -5.844  32.772  18.277  1.00 31.72           C  
ATOM   1953  CD  ARG A 250      -4.710  33.719  17.896  1.00 31.94           C  
ATOM   1954  NE  ARG A 250      -4.860  35.016  18.537  1.00 31.48           N  
ATOM   1955  CZ  ARG A 250      -3.856  35.744  19.024  1.00 32.08           C  
ATOM   1956  NH1 ARG A 250      -2.600  35.311  18.947  1.00 27.57           N  
ATOM   1957  NH2 ARG A 250      -4.122  36.909  19.611  1.00 30.07           N  
ATOM   1958  N   LYS A 251      -9.414  33.691  15.629  1.00 33.57           N  
ATOM   1959  CA  LYS A 251     -10.381  33.512  14.549  1.00 34.28           C  
ATOM   1960  C   LYS A 251     -10.091  32.293  13.673  1.00 33.33           C  
ATOM   1961  O   LYS A 251     -10.914  31.917  12.837  1.00 34.62           O  
ATOM   1962  CB  LYS A 251     -10.437  34.774  13.691  1.00 36.30           C  
ATOM   1963  CG  LYS A 251     -10.962  36.002  14.424  1.00 40.08           C  
ATOM   1964  CD  LYS A 251     -10.709  37.245  13.598  1.00 41.97           C  
ATOM   1965  CE  LYS A 251     -11.876  38.223  13.669  1.00 43.93           C  
ATOM   1966  NZ  LYS A 251     -11.699  39.285  12.628  1.00 44.13           N  
ATOM   1967  N   SER A 252      -8.932  31.675  13.875  1.00 30.42           N  
ATOM   1968  CA  SER A 252      -8.534  30.500  13.106  1.00 29.05           C  
ATOM   1969  C   SER A 252      -9.100  29.209  13.683  1.00 28.97           C  
ATOM   1970  O   SER A 252      -9.084  28.164  13.029  1.00 29.09           O  
ATOM   1971  CB  SER A 252      -7.020  30.384  13.098  1.00 30.37           C  
ATOM   1972  OG  SER A 252      -6.540  30.196  14.418  1.00 32.67           O  
ATOM   1973  N   GLY A 253      -9.592  29.281  14.913  1.00 27.18           N  
ATOM   1974  CA  GLY A 253     -10.122  28.098  15.559  1.00 25.45           C  
ATOM   1975  C   GLY A 253      -9.121  27.598  16.579  1.00 25.77           C  
ATOM   1976  O   GLY A 253      -9.334  26.576  17.220  1.00 27.13           O  
ATOM   1977  N   ARG A 254      -8.013  28.316  16.720  1.00 25.90           N  
ATOM   1978  CA  ARG A 254      -6.982  27.958  17.686  1.00 26.74           C  
ATOM   1979  C   ARG A 254      -7.234  28.633  19.036  1.00 26.86           C  
ATOM   1980  O   ARG A 254      -7.890  29.673  19.118  1.00 28.11           O  
ATOM   1981  CB  ARG A 254      -5.596  28.431  17.226  1.00 26.63           C  
ATOM   1982  CG  ARG A 254      -4.980  27.762  16.026  1.00 26.03           C  
ATOM   1983  CD  ARG A 254      -3.561  28.288  15.865  1.00 23.78           C  
ATOM   1984  NE  ARG A 254      -2.859  27.684  14.742  1.00 28.04           N  
ATOM   1985  CZ  ARG A 254      -3.017  28.047  13.471  1.00 31.96           C  
ATOM   1986  NH1 ARG A 254      -3.857  29.028  13.148  1.00 30.28           N  
ATOM   1987  NH2 ARG A 254      -2.325  27.430  12.517  1.00 31.57           N  
ATOM   1988  N   LEU A 255      -6.702  28.035  20.094  1.00 24.73           N  
ATOM   1989  CA  LEU A 255      -6.786  28.629  21.414  1.00 23.46           C  
ATOM   1990  C   LEU A 255      -5.320  28.884  21.750  1.00 23.29           C  
ATOM   1991  O   LEU A 255      -4.488  27.981  21.639  1.00 23.04           O  
ATOM   1992  CB  LEU A 255      -7.392  27.664  22.441  1.00 23.57           C  
ATOM   1993  CG  LEU A 255      -8.853  27.224  22.312  1.00 24.71           C  
ATOM   1994  CD1 LEU A 255      -9.257  26.446  23.557  1.00 20.84           C  
ATOM   1995  CD2 LEU A 255      -9.744  28.450  22.135  1.00 24.23           C  
ATOM   1996  N   VAL A 256      -4.988  30.122  22.101  1.00 22.92           N  
ATOM   1997  CA  VAL A 256      -3.619  30.454  22.469  1.00 22.44           C  
ATOM   1998  C   VAL A 256      -3.647  30.389  23.980  1.00 23.19           C  
ATOM   1999  O   VAL A 256      -4.450  31.070  24.609  1.00 24.52           O  
ATOM   2000  CB  VAL A 256      -3.230  31.870  22.032  1.00 21.77           C  
ATOM   2001  CG1 VAL A 256      -1.937  32.288  22.723  1.00 25.71           C  
ATOM   2002  CG2 VAL A 256      -3.037  31.903  20.542  1.00 19.97           C  
ATOM   2003  N   VAL A 257      -2.783  29.571  24.563  1.00 23.00           N  
ATOM   2004  CA  VAL A 257      -2.803  29.414  26.004  1.00 24.17           C  
ATOM   2005  C   VAL A 257      -1.566  29.816  26.733  1.00 25.55           C  
ATOM   2006  O   VAL A 257      -0.478  29.839  26.169  1.00 28.87           O  
ATOM   2007  CB  VAL A 257      -3.040  27.948  26.410  1.00 23.98           C  
ATOM   2008  CG1 VAL A 257      -3.136  27.820  27.937  1.00 21.79           C  
ATOM   2009  CG2 VAL A 257      -4.296  27.433  25.756  1.00 18.88           C  
ATOM   2010  N   GLY A 258      -1.721  30.147  28.005  1.00 28.90           N  
ATOM   2011  CA  GLY A 258      -0.506  30.400  28.691  1.00 28.49           C  
ATOM   2012  C   GLY A 258       0.003  31.276  29.765  1.00 30.26           C  
ATOM   2013  O   GLY A 258      -0.645  31.739  30.703  1.00 28.66           O  
ATOM   2014  N   ALA A 259       1.294  31.316  29.529  1.00 31.39           N  
ATOM   2015  CA  ALA A 259       2.395  31.980  30.144  1.00 32.00           C  
ATOM   2016  C   ALA A 259       2.864  31.621  31.518  1.00 32.25           C  
ATOM   2017  O   ALA A 259       2.166  31.700  32.525  1.00 33.89           O  
ATOM   2018  CB  ALA A 259       2.223  33.473  30.009  1.00 35.47           C  
ATOM   2019  N   THR A 260       4.109  31.184  31.504  1.00 31.46           N  
ATOM   2020  CA  THR A 260       4.859  30.851  32.676  1.00 28.91           C  
ATOM   2021  C   THR A 260       5.601  32.165  32.899  1.00 28.32           C  
ATOM   2022  O   THR A 260       5.612  33.039  32.033  1.00 26.70           O  
ATOM   2023  CB  THR A 260       5.869  29.732  32.386  1.00 28.65           C  
ATOM   2024  OG1 THR A 260       6.680  30.083  31.268  1.00 27.82           O  
ATOM   2025  CG2 THR A 260       5.155  28.415  32.098  1.00 29.52           C  
ATOM   2026  N   MET A 261       6.184  32.327  34.074  1.00 27.57           N  
ATOM   2027  CA  MET A 261       6.897  33.548  34.388  1.00 27.63           C  
ATOM   2028  C   MET A 261       8.244  33.094  34.931  1.00 27.45           C  
ATOM   2029  O   MET A 261       8.365  32.708  36.096  1.00 28.29           O  
ATOM   2030  CB  MET A 261       6.086  34.347  35.417  1.00 30.24           C  
ATOM   2031  CG  MET A 261       6.483  35.798  35.559  1.00 34.43           C  
ATOM   2032  SD  MET A 261       7.685  36.085  36.888  1.00 41.58           S  
ATOM   2033  CE  MET A 261       7.579  37.892  37.049  1.00 35.51           C  
ATOM   2034  N   LYS A 262       9.257  33.116  34.068  1.00 27.24           N  
ATOM   2035  CA  LYS A 262      10.589  32.667  34.455  1.00 27.66           C  
ATOM   2036  C   LYS A 262      11.640  33.749  34.348  1.00 26.75           C  
ATOM   2037  O   LYS A 262      12.269  33.926  33.308  1.00 28.87           O  
ATOM   2038  CB  LYS A 262      10.990  31.450  33.618  1.00 26.92           C  
ATOM   2039  CG  LYS A 262      10.118  30.245  33.897  1.00 28.68           C  
ATOM   2040  CD  LYS A 262      10.495  29.062  33.035  1.00 33.34           C  
ATOM   2041  CE  LYS A 262       9.713  27.821  33.464  1.00 34.58           C  
ATOM   2042  NZ  LYS A 262      10.023  26.620  32.629  1.00 34.95           N  
ATOM   2043  N   PRO A 263      11.862  34.479  35.447  1.00 27.42           N  
ATOM   2044  CA  PRO A 263      12.847  35.568  35.492  1.00 25.15           C  
ATOM   2045  C   PRO A 263      14.286  35.096  35.293  1.00 24.70           C  
ATOM   2046  O   PRO A 263      14.709  34.074  35.850  1.00 22.23           O  
ATOM   2047  CB  PRO A 263      12.646  36.169  36.888  1.00 23.73           C  
ATOM   2048  CG  PRO A 263      11.250  35.727  37.279  1.00 25.58           C  
ATOM   2049  CD  PRO A 263      11.192  34.322  36.749  1.00 23.98           C  
ATOM   2050  N   GLY A 264      15.026  35.851  34.485  1.00 24.36           N  
ATOM   2051  CA  GLY A 264      16.423  35.547  34.241  1.00 22.02           C  
ATOM   2052  C   GLY A 264      16.753  34.412  33.300  1.00 21.85           C  
ATOM   2053  O   GLY A 264      17.917  34.051  33.165  1.00 22.48           O  
ATOM   2054  N   ASP A 265      15.751  33.845  32.642  1.00 23.53           N  
ATOM   2055  CA  ASP A 265      15.993  32.743  31.710  1.00 23.05           C  
ATOM   2056  C   ASP A 265      16.034  33.324  30.291  1.00 22.98           C  
ATOM   2057  O   ASP A 265      15.034  33.841  29.803  1.00 23.25           O  
ATOM   2058  CB  ASP A 265      14.874  31.711  31.826  1.00 21.82           C  
ATOM   2059  CG  ASP A 265      15.164  30.454  31.051  1.00 24.93           C  
ATOM   2060  OD1 ASP A 265      15.908  30.525  30.052  1.00 25.49           O  
ATOM   2061  OD2 ASP A 265      14.634  29.388  31.432  1.00 30.09           O  
ATOM   2062  N   TRP A 266      17.184  33.244  29.629  1.00 22.36           N  
ATOM   2063  CA  TRP A 266      17.298  33.791  28.286  1.00 23.11           C  
ATOM   2064  C   TRP A 266      17.004  32.808  27.145  1.00 23.14           C  
ATOM   2065  O   TRP A 266      17.102  33.181  25.976  1.00 24.24           O  
ATOM   2066  CB  TRP A 266      18.684  34.405  28.065  1.00 22.15           C  
ATOM   2067  CG  TRP A 266      18.969  35.676  28.823  1.00 22.78           C  
ATOM   2068  CD1 TRP A 266      19.499  35.781  30.075  1.00 22.84           C  
ATOM   2069  CD2 TRP A 266      18.858  37.019  28.325  1.00 22.62           C  
ATOM   2070  NE1 TRP A 266      19.743  37.100  30.385  1.00 22.26           N  
ATOM   2071  CE2 TRP A 266      19.359  37.882  29.329  1.00 22.83           C  
ATOM   2072  CE3 TRP A 266      18.391  37.577  27.128  1.00 22.15           C  
ATOM   2073  CZ2 TRP A 266      19.409  39.271  29.172  1.00 21.46           C  
ATOM   2074  CZ3 TRP A 266      18.439  38.965  26.971  1.00 22.33           C  
ATOM   2075  CH2 TRP A 266      18.947  39.793  27.989  1.00 21.70           C  
ATOM   2076  N   SER A 267      16.655  31.566  27.465  1.00 20.92           N  
ATOM   2077  CA  SER A 267      16.338  30.600  26.414  1.00 21.70           C  
ATOM   2078  C   SER A 267      14.961  30.912  25.814  1.00 22.41           C  
ATOM   2079  O   SER A 267      14.032  31.287  26.528  1.00 24.67           O  
ATOM   2080  CB  SER A 267      16.359  29.182  26.977  1.00 20.18           C  
ATOM   2081  OG  SER A 267      15.477  29.063  28.069  1.00 23.72           O  
ATOM   2082  N   GLU A 268      14.819  30.755  24.502  1.00 23.05           N  
ATOM   2083  CA  GLU A 268      13.548  31.062  23.858  1.00 21.60           C  
ATOM   2084  C   GLU A 268      12.711  29.900  23.375  1.00 20.71           C  
ATOM   2085  O   GLU A 268      11.834  30.082  22.547  1.00 23.15           O  
ATOM   2086  CB  GLU A 268      13.772  32.057  22.720  1.00 23.23           C  
ATOM   2087  CG  GLU A 268      14.395  33.351  23.223  1.00 28.02           C  
ATOM   2088  CD  GLU A 268      14.821  34.295  22.120  1.00 31.54           C  
ATOM   2089  OE1 GLU A 268      13.943  34.925  21.484  1.00 33.40           O  
ATOM   2090  OE2 GLU A 268      16.042  34.409  21.895  1.00 30.59           O  
ATOM   2091  N   THR A 269      12.972  28.706  23.889  1.00 21.05           N  
ATOM   2092  CA  THR A 269      12.163  27.549  23.530  1.00 23.99           C  
ATOM   2093  C   THR A 269      11.683  26.984  24.858  1.00 24.69           C  
ATOM   2094  O   THR A 269      12.431  26.949  25.833  1.00 24.32           O  
ATOM   2095  CB  THR A 269      12.961  26.475  22.772  1.00 26.42           C  
ATOM   2096  OG1 THR A 269      14.145  26.148  23.510  1.00 31.35           O  
ATOM   2097  CG2 THR A 269      13.327  26.969  21.378  1.00 24.25           C  
ATOM   2098  N   PRO A 270      10.422  26.543  24.916  1.00 25.73           N  
ATOM   2099  CA  PRO A 270       9.804  25.980  26.124  1.00 25.12           C  
ATOM   2100  C   PRO A 270      10.454  24.718  26.644  1.00 25.46           C  
ATOM   2101  O   PRO A 270      10.964  23.911  25.859  1.00 24.69           O  
ATOM   2102  CB  PRO A 270       8.367  25.702  25.689  1.00 24.95           C  
ATOM   2103  CG  PRO A 270       8.154  26.639  24.539  1.00 27.56           C  
ATOM   2104  CD  PRO A 270       9.460  26.588  23.806  1.00 25.65           C  
ATOM   2105  N   ASP A 271      10.448  24.546  27.967  1.00 23.84           N  
ATOM   2106  CA  ASP A 271      10.994  23.323  28.529  1.00 25.73           C  
ATOM   2107  C   ASP A 271       9.816  22.473  29.019  1.00 24.55           C  
ATOM   2108  O   ASP A 271       8.693  22.968  29.164  1.00 23.01           O  
ATOM   2109  CB  ASP A 271      12.024  23.614  29.634  1.00 30.87           C  
ATOM   2110  CG  ASP A 271      11.418  24.224  30.883  1.00 36.93           C  
ATOM   2111  OD1 ASP A 271      10.202  24.522  30.897  1.00 42.19           O  
ATOM   2112  OD2 ASP A 271      12.178  24.410  31.864  1.00 39.50           O  
ATOM   2113  N   LEU A 272      10.058  21.191  29.249  1.00 22.78           N  
ATOM   2114  CA  LEU A 272       8.983  20.297  29.650  1.00 23.67           C  
ATOM   2115  C   LEU A 272       8.210  20.720  30.898  1.00 24.58           C  
ATOM   2116  O   LEU A 272       6.978  20.671  30.912  1.00 26.21           O  
ATOM   2117  CB  LEU A 272       9.535  18.873  29.795  1.00 24.35           C  
ATOM   2118  CG  LEU A 272       8.566  17.714  30.064  1.00 25.71           C  
ATOM   2119  CD1 LEU A 272       9.185  16.425  29.545  1.00 21.64           C  
ATOM   2120  CD2 LEU A 272       8.241  17.613  31.571  1.00 24.56           C  
ATOM   2121  N   GLY A 273       8.918  21.142  31.941  1.00 25.14           N  
ATOM   2122  CA  GLY A 273       8.247  21.550  33.160  1.00 22.37           C  
ATOM   2123  C   GLY A 273       7.310  22.728  32.966  1.00 23.07           C  
ATOM   2124  O   GLY A 273       6.209  22.753  33.511  1.00 23.20           O  
ATOM   2125  N   GLY A 274       7.751  23.713  32.190  1.00 22.51           N  
ATOM   2126  CA  GLY A 274       6.926  24.879  31.936  1.00 22.37           C  
ATOM   2127  C   GLY A 274       5.655  24.577  31.160  1.00 23.82           C  
ATOM   2128  O   GLY A 274       4.600  25.132  31.468  1.00 24.98           O  
ATOM   2129  N   LEU A 275       5.743  23.710  30.151  1.00 23.80           N  
ATOM   2130  CA  LEU A 275       4.569  23.363  29.365  1.00 23.43           C  
ATOM   2131  C   LEU A 275       3.570  22.549  30.184  1.00 24.57           C  
ATOM   2132  O   LEU A 275       2.360  22.739  30.070  1.00 24.70           O  
ATOM   2133  CB  LEU A 275       4.974  22.587  28.112  1.00 22.93           C  
ATOM   2134  CG  LEU A 275       5.698  23.360  27.008  1.00 22.33           C  
ATOM   2135  CD1 LEU A 275       6.107  22.406  25.915  1.00 16.62           C  
ATOM   2136  CD2 LEU A 275       4.803  24.454  26.459  1.00 20.09           C  
ATOM   2137  N   GLU A 276       4.071  21.636  31.005  1.00 25.72           N  
ATOM   2138  CA  GLU A 276       3.183  20.830  31.834  1.00 28.07           C  
ATOM   2139  C   GLU A 276       2.420  21.788  32.736  1.00 27.75           C  
ATOM   2140  O   GLU A 276       1.220  21.645  32.961  1.00 29.41           O  
ATOM   2141  CB  GLU A 276       3.980  19.857  32.703  1.00 29.00           C  
ATOM   2142  CG  GLU A 276       3.098  19.017  33.598  1.00 32.89           C  
ATOM   2143  CD  GLU A 276       3.860  18.330  34.716  1.00 36.34           C  
ATOM   2144  OE1 GLU A 276       3.236  17.525  35.446  1.00 36.62           O  
ATOM   2145  OE2 GLU A 276       5.073  18.597  34.869  1.00 36.74           O  
ATOM   2146  N   SER A 277       3.144  22.772  33.243  1.00 27.14           N  
ATOM   2147  CA  SER A 277       2.585  23.779  34.123  1.00 27.76           C  
ATOM   2148  C   SER A 277       1.450  24.559  33.456  1.00 28.02           C  
ATOM   2149  O   SER A 277       0.388  24.760  34.052  1.00 28.55           O  
ATOM   2150  CB  SER A 277       3.703  24.724  34.561  1.00 27.89           C  
ATOM   2151  OG  SER A 277       3.182  25.879  35.173  1.00 33.14           O  
ATOM   2152  N   VAL A 278       1.678  25.001  32.220  1.00 27.51           N  
ATOM   2153  CA  VAL A 278       0.663  25.749  31.481  1.00 26.33           C  
ATOM   2154  C   VAL A 278      -0.562  24.878  31.195  1.00 26.31           C  
ATOM   2155  O   VAL A 278      -1.695  25.315  31.365  1.00 26.34           O  
ATOM   2156  CB  VAL A 278       1.226  26.295  30.143  1.00 24.75           C  
ATOM   2157  CG1 VAL A 278       0.102  26.842  29.276  1.00 21.21           C  
ATOM   2158  CG2 VAL A 278       2.233  27.396  30.425  1.00 23.09           C  
ATOM   2159  N   MET A 279      -0.337  23.647  30.754  1.00 26.66           N  
ATOM   2160  CA  MET A 279      -1.445  22.744  30.473  1.00 28.25           C  
ATOM   2161  C   MET A 279      -2.313  22.592  31.727  1.00 29.84           C  
ATOM   2162  O   MET A 279      -3.541  22.716  31.668  1.00 27.53           O  
ATOM   2163  CB  MET A 279      -0.910  21.376  30.044  1.00 26.84           C  
ATOM   2164  CG  MET A 279       0.033  21.433  28.866  1.00 26.35           C  
ATOM   2165  SD  MET A 279       0.581  19.800  28.393  1.00 28.38           S  
ATOM   2166  CE  MET A 279       0.967  20.038  26.711  1.00 28.83           C  
ATOM   2167  N   LYS A 280      -1.663  22.326  32.860  1.00 30.83           N  
ATOM   2168  CA  LYS A 280      -2.364  22.168  34.126  1.00 32.28           C  
ATOM   2169  C   LYS A 280      -3.234  23.388  34.470  1.00 30.86           C  
ATOM   2170  O   LYS A 280      -4.390  23.252  34.865  1.00 30.40           O  
ATOM   2171  CB  LYS A 280      -1.354  21.912  35.247  1.00 34.84           C  
ATOM   2172  CG  LYS A 280      -1.981  21.393  36.527  1.00 37.20           C  
ATOM   2173  CD  LYS A 280      -0.941  20.741  37.419  1.00 42.39           C  
ATOM   2174  CE  LYS A 280      -0.520  21.652  38.558  1.00 45.29           C  
ATOM   2175  NZ  LYS A 280      -1.606  21.806  39.567  1.00 47.23           N  
ATOM   2176  N   LYS A 281      -2.683  24.582  34.313  1.00 30.18           N  
ATOM   2177  CA  LYS A 281      -3.441  25.790  34.611  1.00 30.42           C  
ATOM   2178  C   LYS A 281      -4.673  25.907  33.717  1.00 30.02           C  
ATOM   2179  O   LYS A 281      -5.792  26.035  34.203  1.00 31.32           O  
ATOM   2180  CB  LYS A 281      -2.552  27.016  34.433  1.00 30.90           C  
ATOM   2181  CG  LYS A 281      -3.237  28.331  34.738  1.00 33.66           C  
ATOM   2182  CD  LYS A 281      -3.708  28.399  36.173  1.00 31.85           C  
ATOM   2183  CE  LYS A 281      -4.309  29.758  36.480  1.00 32.83           C  
ATOM   2184  NZ  LYS A 281      -4.905  29.776  37.847  1.00 35.06           N  
ATOM   2185  N   ALA A 282      -4.457  25.858  32.408  1.00 28.82           N  
ATOM   2186  CA  ALA A 282      -5.540  25.958  31.436  1.00 27.81           C  
ATOM   2187  C   ALA A 282      -6.712  25.021  31.753  1.00 28.06           C  
ATOM   2188  O   ALA A 282      -7.875  25.409  31.616  1.00 27.49           O  
ATOM   2189  CB  ALA A 282      -5.002  25.666  30.041  1.00 27.53           C  
ATOM   2190  N   LYS A 283      -6.400  23.790  32.160  1.00 27.80           N  
ATOM   2191  CA  LYS A 283      -7.420  22.803  32.502  1.00 28.03           C  
ATOM   2192  C   LYS A 283      -8.329  23.255  33.642  1.00 29.28           C  
ATOM   2193  O   LYS A 283      -9.515  22.929  33.647  1.00 29.84           O  
ATOM   2194  CB  LYS A 283      -6.777  21.463  32.865  1.00 26.17           C  
ATOM   2195  CG  LYS A 283      -6.475  20.594  31.668  1.00 28.77           C  
ATOM   2196  CD  LYS A 283      -5.569  19.424  32.018  1.00 32.15           C  
ATOM   2197  CE  LYS A 283      -6.170  18.542  33.100  1.00 32.51           C  
ATOM   2198  NZ  LYS A 283      -5.331  17.331  33.338  1.00 32.98           N  
ATOM   2199  N   THR A 284      -7.784  24.004  34.602  1.00 28.94           N  
ATOM   2200  CA  THR A 284      -8.592  24.485  35.715  1.00 28.22           C  
ATOM   2201  C   THR A 284      -9.545  25.566  35.230  1.00 29.78           C  
ATOM   2202  O   THR A 284     -10.617  25.747  35.795  1.00 31.92           O  
ATOM   2203  CB  THR A 284      -7.743  25.098  36.853  1.00 29.02           C  
ATOM   2204  OG1 THR A 284      -7.251  26.384  36.447  1.00 32.77           O  
ATOM   2205  CG2 THR A 284      -6.590  24.190  37.217  1.00 23.30           C  
ATOM   2206  N   MET A 285      -9.154  26.294  34.190  1.00 30.14           N  
ATOM   2207  CA  MET A 285      -9.999  27.357  33.648  1.00 29.66           C  
ATOM   2208  C   MET A 285     -10.997  26.877  32.582  1.00 29.34           C  
ATOM   2209  O   MET A 285     -12.111  27.386  32.494  1.00 28.76           O  
ATOM   2210  CB  MET A 285      -9.133  28.463  33.042  1.00 28.75           C  
ATOM   2211  CG  MET A 285      -8.169  29.120  33.995  1.00 28.46           C  
ATOM   2212  SD  MET A 285      -6.959  30.121  33.086  1.00 30.73           S  
ATOM   2213  CE  MET A 285      -7.825  31.679  32.908  1.00 29.77           C  
ATOM   2214  N   LEU A 286     -10.593  25.906  31.769  1.00 29.99           N  
ATOM   2215  CA  LEU A 286     -11.447  25.393  30.693  1.00 30.20           C  
ATOM   2216  C   LEU A 286     -11.243  23.886  30.567  1.00 31.34           C  
ATOM   2217  O   LEU A 286     -10.531  23.418  29.676  1.00 33.35           O  
ATOM   2218  CB  LEU A 286     -11.065  26.073  29.377  1.00 28.54           C  
ATOM   2219  CG  LEU A 286     -11.894  25.797  28.128  1.00 28.01           C  
ATOM   2220  CD1 LEU A 286     -13.333  26.234  28.373  1.00 27.83           C  
ATOM   2221  CD2 LEU A 286     -11.305  26.559  26.954  1.00 26.78           C  
ATOM   2222  N   PRO A 287     -11.890  23.107  31.445  1.00 30.38           N  
ATOM   2223  CA  PRO A 287     -11.787  21.644  31.465  1.00 30.12           C  
ATOM   2224  C   PRO A 287     -11.698  20.921  30.119  1.00 29.94           C  
ATOM   2225  O   PRO A 287     -10.843  20.060  29.936  1.00 31.20           O  
ATOM   2226  CB  PRO A 287     -13.012  21.228  32.273  1.00 28.44           C  
ATOM   2227  CG  PRO A 287     -13.141  22.345  33.244  1.00 26.56           C  
ATOM   2228  CD  PRO A 287     -12.941  23.563  32.371  1.00 28.89           C  
ATOM   2229  N   PRO A 288     -12.569  21.264  29.161  1.00 29.25           N  
ATOM   2230  CA  PRO A 288     -12.565  20.621  27.837  1.00 28.14           C  
ATOM   2231  C   PRO A 288     -11.267  20.747  27.031  1.00 28.66           C  
ATOM   2232  O   PRO A 288     -11.018  19.950  26.130  1.00 29.31           O  
ATOM   2233  CB  PRO A 288     -13.729  21.301  27.116  1.00 28.74           C  
ATOM   2234  CG  PRO A 288     -14.607  21.790  28.235  1.00 28.33           C  
ATOM   2235  CD  PRO A 288     -13.616  22.295  29.238  1.00 26.82           C  
ATOM   2236  N   ILE A 289     -10.450  21.748  27.340  1.00 28.16           N  
ATOM   2237  CA  ILE A 289      -9.201  21.958  26.612  1.00 28.12           C  
ATOM   2238  C   ILE A 289      -8.324  20.714  26.702  1.00 29.59           C  
ATOM   2239  O   ILE A 289      -7.397  20.520  25.920  1.00 30.04           O  
ATOM   2240  CB  ILE A 289      -8.415  23.165  27.180  1.00 26.22           C  
ATOM   2241  CG1 ILE A 289      -7.410  23.667  26.135  1.00 26.12           C  
ATOM   2242  CG2 ILE A 289      -7.703  22.763  28.466  1.00 22.89           C  
ATOM   2243  CD1 ILE A 289      -6.655  24.929  26.531  1.00 24.03           C  
ATOM   2244  N   GLN A 290      -8.633  19.873  27.673  1.00 30.59           N  
ATOM   2245  CA  GLN A 290      -7.892  18.648  27.889  1.00 32.17           C  
ATOM   2246  C   GLN A 290      -7.990  17.666  26.717  1.00 32.03           C  
ATOM   2247  O   GLN A 290      -7.086  16.851  26.497  1.00 30.08           O  
ATOM   2248  CB  GLN A 290      -8.399  17.976  29.157  1.00 33.11           C  
ATOM   2249  CG  GLN A 290      -7.864  16.595  29.336  1.00 40.94           C  
ATOM   2250  CD  GLN A 290      -8.320  15.965  30.624  1.00 45.55           C  
ATOM   2251  OE1 GLN A 290      -9.519  15.918  30.915  1.00 45.23           O  
ATOM   2252  NE2 GLN A 290      -7.361  15.467  31.412  1.00 47.33           N  
ATOM   2253  N   ASN A 291      -9.084  17.740  25.969  1.00 30.61           N  
ATOM   2254  CA  ASN A 291      -9.279  16.835  24.850  1.00 30.62           C  
ATOM   2255  C   ASN A 291      -8.955  17.465  23.511  1.00 30.77           C  
ATOM   2256  O   ASN A 291      -9.176  16.863  22.464  1.00 32.42           O  
ATOM   2257  CB  ASN A 291     -10.720  16.328  24.837  1.00 30.56           C  
ATOM   2258  CG  ASN A 291     -11.102  15.646  26.130  1.00 32.45           C  
ATOM   2259  OD1 ASN A 291     -10.379  14.779  26.616  1.00 32.30           O  
ATOM   2260  ND2 ASN A 291     -12.243  16.031  26.695  1.00 33.83           N  
ATOM   2261  N   MET A 292      -8.431  18.681  23.536  1.00 30.27           N  
ATOM   2262  CA  MET A 292      -8.100  19.359  22.297  1.00 29.04           C  
ATOM   2263  C   MET A 292      -6.713  18.963  21.793  1.00 28.30           C  
ATOM   2264  O   MET A 292      -5.810  18.664  22.578  1.00 26.96           O  
ATOM   2265  CB  MET A 292      -8.211  20.872  22.503  1.00 28.83           C  
ATOM   2266  CG  MET A 292      -9.630  21.306  22.831  1.00 25.94           C  
ATOM   2267  SD  MET A 292      -9.815  23.069  23.049  1.00 30.04           S  
ATOM   2268  CE  MET A 292     -11.415  23.162  23.788  1.00 29.54           C  
ATOM   2269  N   LYS A 293      -6.562  18.936  20.474  1.00 27.75           N  
ATOM   2270  CA  LYS A 293      -5.295  18.567  19.848  1.00 28.16           C  
ATOM   2271  C   LYS A 293      -4.273  19.689  19.967  1.00 25.61           C  
ATOM   2272  O   LYS A 293      -4.569  20.839  19.671  1.00 24.82           O  
ATOM   2273  CB  LYS A 293      -5.521  18.232  18.370  1.00 28.79           C  
ATOM   2274  CG  LYS A 293      -6.522  17.113  18.148  1.00 31.14           C  
ATOM   2275  CD  LYS A 293      -5.948  15.759  18.562  1.00 36.34           C  
ATOM   2276  CE  LYS A 293      -6.956  14.920  19.344  1.00 37.98           C  
ATOM   2277  NZ  LYS A 293      -8.275  14.811  18.654  1.00 39.53           N  
ATOM   2278  N   VAL A 294      -3.076  19.345  20.421  1.00 25.22           N  
ATOM   2279  CA  VAL A 294      -2.008  20.324  20.559  1.00 23.96           C  
ATOM   2280  C   VAL A 294      -1.515  20.753  19.189  1.00 23.75           C  
ATOM   2281  O   VAL A 294      -1.319  19.918  18.306  1.00 25.24           O  
ATOM   2282  CB  VAL A 294      -0.826  19.736  21.335  1.00 23.76           C  
ATOM   2283  CG1 VAL A 294       0.328  20.733  21.395  1.00 18.23           C  
ATOM   2284  CG2 VAL A 294      -1.289  19.366  22.732  1.00 25.63           C  
ATOM   2285  N   ASP A 295      -1.322  22.057  19.019  1.00 22.80           N  
ATOM   2286  CA  ASP A 295      -0.838  22.622  17.764  1.00 23.30           C  
ATOM   2287  C   ASP A 295       0.664  22.911  17.865  1.00 23.29           C  
ATOM   2288  O   ASP A 295       1.486  22.159  17.352  1.00 22.63           O  
ATOM   2289  CB  ASP A 295      -1.584  23.926  17.442  1.00 24.30           C  
ATOM   2290  CG  ASP A 295      -1.119  24.566  16.131  1.00 26.74           C  
ATOM   2291  OD1 ASP A 295      -1.326  25.787  15.968  1.00 26.61           O  
ATOM   2292  OD2 ASP A 295      -0.559  23.854  15.262  1.00 24.68           O  
ATOM   2293  N   ARG A 296       1.008  24.002  18.542  1.00 23.54           N  
ATOM   2294  CA  ARG A 296       2.395  24.399  18.704  1.00 25.12           C  
ATOM   2295  C   ARG A 296       2.729  24.851  20.120  1.00 24.90           C  
ATOM   2296  O   ARG A 296       1.844  25.061  20.951  1.00 22.64           O  
ATOM   2297  CB  ARG A 296       2.732  25.542  17.751  1.00 29.90           C  
ATOM   2298  CG  ARG A 296       2.653  25.191  16.280  1.00 39.57           C  
ATOM   2299  CD  ARG A 296       3.505  26.167  15.499  1.00 47.08           C  
ATOM   2300  NE  ARG A 296       4.823  26.282  16.123  1.00 56.46           N  
ATOM   2301  CZ  ARG A 296       5.711  27.236  15.849  1.00 59.14           C  
ATOM   2302  NH1 ARG A 296       5.426  28.169  14.946  1.00 60.26           N  
ATOM   2303  NH2 ARG A 296       6.876  27.265  16.495  1.00 58.93           N  
ATOM   2304  N   PHE A 297       4.023  25.013  20.372  1.00 24.16           N  
ATOM   2305  CA  PHE A 297       4.520  25.461  21.661  1.00 24.75           C  
ATOM   2306  C   PHE A 297       5.630  26.451  21.347  1.00 22.86           C  
ATOM   2307  O   PHE A 297       6.293  26.327  20.322  1.00 24.05           O  
ATOM   2308  CB  PHE A 297       5.037  24.262  22.488  1.00 28.56           C  
ATOM   2309  CG  PHE A 297       6.020  23.398  21.760  1.00 34.37           C  
ATOM   2310  CD1 PHE A 297       7.361  23.773  21.648  1.00 39.19           C  
ATOM   2311  CD2 PHE A 297       5.598  22.244  21.110  1.00 37.84           C  
ATOM   2312  CE1 PHE A 297       8.269  23.013  20.888  1.00 38.40           C  
ATOM   2313  CE2 PHE A 297       6.502  21.477  20.346  1.00 39.15           C  
ATOM   2314  CZ  PHE A 297       7.836  21.867  20.237  1.00 36.44           C  
ATOM   2315  N   TRP A 298       5.818  27.451  22.195  1.00 20.39           N  
ATOM   2316  CA  TRP A 298       6.862  28.439  21.947  1.00 19.16           C  
ATOM   2317  C   TRP A 298       7.100  29.250  23.209  1.00 19.08           C  
ATOM   2318  O   TRP A 298       6.480  29.004  24.231  1.00 22.16           O  
ATOM   2319  CB  TRP A 298       6.462  29.358  20.782  1.00 17.20           C  
ATOM   2320  CG  TRP A 298       5.294  30.243  21.084  1.00 19.35           C  
ATOM   2321  CD1 TRP A 298       5.326  31.483  21.676  1.00 20.01           C  
ATOM   2322  CD2 TRP A 298       3.904  29.924  20.904  1.00 20.56           C  
ATOM   2323  NE1 TRP A 298       4.045  31.950  21.879  1.00 20.33           N  
ATOM   2324  CE2 TRP A 298       3.152  31.016  21.419  1.00 20.31           C  
ATOM   2325  CE3 TRP A 298       3.222  28.823  20.367  1.00 15.69           C  
ATOM   2326  CZ2 TRP A 298       1.750  31.034  21.410  1.00 17.43           C  
ATOM   2327  CZ3 TRP A 298       1.827  28.843  20.362  1.00 18.22           C  
ATOM   2328  CH2 TRP A 298       1.107  29.944  20.882  1.00 17.14           C  
ATOM   2329  N   ALA A 299       8.011  30.204  23.147  1.00 21.02           N  
ATOM   2330  CA  ALA A 299       8.308  31.029  24.304  1.00 21.10           C  
ATOM   2331  C   ALA A 299       8.819  32.383  23.839  1.00 20.87           C  
ATOM   2332  O   ALA A 299       9.102  32.566  22.661  1.00 18.19           O  
ATOM   2333  CB  ALA A 299       9.352  30.338  25.190  1.00 21.34           C  
ATOM   2334  N   GLY A 300       8.916  33.322  24.775  1.00 20.46           N  
ATOM   2335  CA  GLY A 300       9.392  34.655  24.464  1.00 20.37           C  
ATOM   2336  C   GLY A 300       9.969  35.285  25.715  1.00 21.89           C  
ATOM   2337  O   GLY A 300       9.673  34.848  26.825  1.00 22.18           O  
ATOM   2338  N   LEU A 301      10.789  36.314  25.547  1.00 22.81           N  
ATOM   2339  CA  LEU A 301      11.407  36.984  26.685  1.00 22.54           C  
ATOM   2340  C   LEU A 301      10.768  38.340  26.964  1.00 22.22           C  
ATOM   2341  O   LEU A 301      11.040  39.302  26.255  1.00 25.12           O  
ATOM   2342  CB  LEU A 301      12.903  37.178  26.419  1.00 21.99           C  
ATOM   2343  CG  LEU A 301      13.665  35.923  25.981  1.00 23.44           C  
ATOM   2344  CD1 LEU A 301      15.136  36.254  25.830  1.00 22.84           C  
ATOM   2345  CD2 LEU A 301      13.473  34.804  27.009  1.00 22.64           C  
ATOM   2346  N   ARG A 302       9.907  38.425  27.973  1.00 22.16           N  
ATOM   2347  CA  ARG A 302       9.300  39.709  28.300  1.00 21.82           C  
ATOM   2348  C   ARG A 302      10.467  40.580  28.775  1.00 21.63           C  
ATOM   2349  O   ARG A 302      11.304  40.125  29.557  1.00 22.12           O  
ATOM   2350  CB  ARG A 302       8.282  39.562  29.432  1.00 20.11           C  
ATOM   2351  CG  ARG A 302       7.247  38.491  29.208  1.00 20.38           C  
ATOM   2352  CD  ARG A 302       6.185  38.566  30.282  1.00 20.74           C  
ATOM   2353  NE  ARG A 302       5.245  37.445  30.280  1.00 20.02           N  
ATOM   2354  CZ  ARG A 302       5.526  36.218  30.714  1.00 18.34           C  
ATOM   2355  NH1 ARG A 302       6.728  35.933  31.185  1.00 15.93           N  
ATOM   2356  NH2 ARG A 302       4.585  35.277  30.703  1.00 19.20           N  
ATOM   2357  N   PRO A 303      10.559  41.826  28.291  1.00 20.61           N  
ATOM   2358  CA  PRO A 303      11.671  42.675  28.735  1.00 23.93           C  
ATOM   2359  C   PRO A 303      11.394  43.338  30.093  1.00 26.19           C  
ATOM   2360  O   PRO A 303      10.695  44.349  30.165  1.00 27.15           O  
ATOM   2361  CB  PRO A 303      11.804  43.680  27.597  1.00 21.87           C  
ATOM   2362  CG  PRO A 303      10.389  43.848  27.148  1.00 22.89           C  
ATOM   2363  CD  PRO A 303       9.844  42.436  27.158  1.00 20.99           C  
ATOM   2364  N   GLY A 304      11.949  42.769  31.161  1.00 26.69           N  
ATOM   2365  CA  GLY A 304      11.713  43.313  32.488  1.00 29.34           C  
ATOM   2366  C   GLY A 304      12.660  44.379  33.024  1.00 29.35           C  
ATOM   2367  O   GLY A 304      13.876  44.293  32.877  1.00 27.73           O  
ATOM   2368  N   THR A 305      12.095  45.406  33.649  1.00 30.45           N  
ATOM   2369  CA  THR A 305      12.915  46.460  34.230  1.00 32.67           C  
ATOM   2370  C   THR A 305      12.757  46.363  35.739  1.00 33.65           C  
ATOM   2371  O   THR A 305      11.874  45.660  36.226  1.00 35.25           O  
ATOM   2372  CB  THR A 305      12.484  47.856  33.753  1.00 32.46           C  
ATOM   2373  OG1 THR A 305      11.108  48.069  34.079  1.00 35.15           O  
ATOM   2374  CG2 THR A 305      12.679  47.988  32.253  1.00 31.30           C  
ATOM   2375  N   LYS A 306      13.620  47.054  36.475  1.00 35.20           N  
ATOM   2376  CA  LYS A 306      13.583  47.034  37.935  1.00 36.26           C  
ATOM   2377  C   LYS A 306      12.200  47.248  38.535  1.00 36.39           C  
ATOM   2378  O   LYS A 306      11.873  46.653  39.558  1.00 37.92           O  
ATOM   2379  CB  LYS A 306      14.541  48.079  38.500  1.00 38.28           C  
ATOM   2380  CG  LYS A 306      14.174  49.521  38.180  1.00 39.90           C  
ATOM   2381  CD  LYS A 306      15.281  50.454  38.655  1.00 40.74           C  
ATOM   2382  CE  LYS A 306      14.950  51.912  38.408  1.00 42.74           C  
ATOM   2383  NZ  LYS A 306      16.023  52.791  38.971  1.00 47.11           N  
ATOM   2384  N   ASP A 307      11.384  48.087  37.909  1.00 36.35           N  
ATOM   2385  CA  ASP A 307      10.046  48.344  38.428  1.00 36.81           C  
ATOM   2386  C   ASP A 307       8.929  47.812  37.529  1.00 36.32           C  
ATOM   2387  O   ASP A 307       7.754  48.122  37.735  1.00 36.19           O  
ATOM   2388  CB  ASP A 307       9.864  49.848  38.666  1.00 39.19           C  
ATOM   2389  CG  ASP A 307      10.087  50.670  37.411  1.00 42.73           C  
ATOM   2390  OD1 ASP A 307      10.388  51.879  37.531  1.00 43.27           O  
ATOM   2391  OD2 ASP A 307       9.954  50.110  36.303  1.00 42.75           O  
ATOM   2392  N   GLY A 308       9.303  47.011  36.534  1.00 35.94           N  
ATOM   2393  CA  GLY A 308       8.322  46.443  35.621  1.00 35.04           C  
ATOM   2394  C   GLY A 308       7.615  47.468  34.756  1.00 35.22           C  
ATOM   2395  O   GLY A 308       6.514  47.233  34.258  1.00 34.77           O  
ATOM   2396  N   LYS A 309       8.252  48.614  34.569  1.00 36.12           N  
ATOM   2397  CA  LYS A 309       7.676  49.680  33.771  1.00 37.47           C  
ATOM   2398  C   LYS A 309       8.634  50.047  32.647  1.00 37.41           C  
ATOM   2399  O   LYS A 309       9.850  49.991  32.800  1.00 36.61           O  
ATOM   2400  CB  LYS A 309       7.405  50.903  34.650  1.00 39.79           C  
ATOM   2401  CG  LYS A 309       6.386  50.673  35.754  1.00 41.50           C  
ATOM   2402  CD  LYS A 309       4.989  50.503  35.187  1.00 44.61           C  
ATOM   2403  CE  LYS A 309       3.952  50.342  36.295  1.00 47.20           C  
ATOM   2404  NZ  LYS A 309       4.229  49.164  37.172  1.00 48.39           N  
ATOM   2405  N   PRO A 310       8.087  50.436  31.496  1.00 38.39           N  
ATOM   2406  CA  PRO A 310       8.898  50.809  30.337  1.00 38.98           C  
ATOM   2407  C   PRO A 310       9.690  52.102  30.536  1.00 40.69           C  
ATOM   2408  O   PRO A 310       9.333  52.947  31.359  1.00 40.57           O  
ATOM   2409  CB  PRO A 310       7.862  50.976  29.220  1.00 39.20           C  
ATOM   2410  CG  PRO A 310       6.619  50.290  29.741  1.00 40.09           C  
ATOM   2411  CD  PRO A 310       6.652  50.569  31.203  1.00 38.70           C  
ATOM   2412  N   TYR A 311      10.768  52.234  29.769  1.00 40.99           N  
ATOM   2413  CA  TYR A 311      11.597  53.426  29.768  1.00 39.68           C  
ATOM   2414  C   TYR A 311      11.280  54.050  28.414  1.00 40.72           C  
ATOM   2415  O   TYR A 311      11.786  53.596  27.389  1.00 42.13           O  
ATOM   2416  CB  TYR A 311      13.079  53.063  29.825  1.00 39.02           C  
ATOM   2417  CG  TYR A 311      13.542  52.538  31.160  1.00 40.10           C  
ATOM   2418  CD1 TYR A 311      13.407  53.308  32.317  1.00 39.81           C  
ATOM   2419  CD2 TYR A 311      14.128  51.276  31.271  1.00 39.37           C  
ATOM   2420  CE1 TYR A 311      13.839  52.834  33.554  1.00 38.51           C  
ATOM   2421  CE2 TYR A 311      14.566  50.791  32.503  1.00 38.55           C  
ATOM   2422  CZ  TYR A 311      14.414  51.573  33.642  1.00 39.21           C  
ATOM   2423  OH  TYR A 311      14.791  51.081  34.869  1.00 37.33           O  
ATOM   2424  N   ILE A 312      10.429  55.072  28.405  1.00 41.24           N  
ATOM   2425  CA  ILE A 312      10.039  55.738  27.161  1.00 40.34           C  
ATOM   2426  C   ILE A 312      10.342  57.240  27.225  1.00 42.14           C  
ATOM   2427  O   ILE A 312       9.665  57.981  27.935  1.00 44.31           O  
ATOM   2428  CB  ILE A 312       8.525  55.557  26.892  1.00 38.24           C  
ATOM   2429  CG1 ILE A 312       8.148  54.075  26.965  1.00 36.55           C  
ATOM   2430  CG2 ILE A 312       8.166  56.120  25.532  1.00 36.55           C  
ATOM   2431  CD1 ILE A 312       6.650  53.815  26.823  1.00 33.73           C  
ATOM   2432  N   GLY A 313      11.353  57.687  26.483  1.00 42.21           N  
ATOM   2433  CA  GLY A 313      11.695  59.098  26.494  1.00 41.97           C  
ATOM   2434  C   GLY A 313      13.115  59.415  26.070  1.00 43.13           C  
ATOM   2435  O   GLY A 313      13.850  58.534  25.621  1.00 43.56           O  
ATOM   2436  N   ARG A 314      13.506  60.679  26.230  1.00 43.48           N  
ATOM   2437  CA  ARG A 314      14.833  61.152  25.843  1.00 43.42           C  
ATOM   2438  C   ARG A 314      15.964  60.773  26.795  1.00 44.02           C  
ATOM   2439  O   ARG A 314      15.755  60.474  27.972  1.00 42.18           O  
ATOM   2440  CB  ARG A 314      14.838  62.674  25.719  1.00 44.40           C  
ATOM   2441  CG  ARG A 314      13.704  63.286  24.919  1.00 46.71           C  
ATOM   2442  CD  ARG A 314      13.750  64.803  25.072  1.00 49.42           C  
ATOM   2443  NE  ARG A 314      12.585  65.482  24.519  1.00 51.56           N  
ATOM   2444  CZ  ARG A 314      12.313  65.556  23.223  1.00 53.56           C  
ATOM   2445  NH1 ARG A 314      13.127  64.986  22.343  1.00 55.87           N  
ATOM   2446  NH2 ARG A 314      11.233  66.206  22.807  1.00 53.41           N  
ATOM   2447  N   HIS A 315      17.178  60.798  26.263  1.00 45.27           N  
ATOM   2448  CA  HIS A 315      18.351  60.515  27.067  1.00 47.92           C  
ATOM   2449  C   HIS A 315      18.472  61.760  27.960  1.00 50.20           C  
ATOM   2450  O   HIS A 315      18.464  62.887  27.466  1.00 49.96           O  
ATOM   2451  CB  HIS A 315      19.579  60.371  26.163  1.00 44.86           C  
ATOM   2452  CG  HIS A 315      20.817  59.924  26.875  1.00 43.02           C  
ATOM   2453  ND1 HIS A 315      21.292  60.547  28.010  1.00 44.34           N  
ATOM   2454  CD2 HIS A 315      21.709  58.948  26.584  1.00 43.25           C  
ATOM   2455  CE1 HIS A 315      22.424  59.975  28.384  1.00 42.98           C  
ATOM   2456  NE2 HIS A 315      22.700  59.001  27.535  1.00 41.97           N  
ATOM   2457  N   PRO A 316      18.555  61.569  29.284  1.00 52.00           N  
ATOM   2458  CA  PRO A 316      18.669  62.683  30.227  1.00 53.05           C  
ATOM   2459  C   PRO A 316      19.656  63.776  29.816  1.00 53.67           C  
ATOM   2460  O   PRO A 316      19.447  64.948  30.114  1.00 53.88           O  
ATOM   2461  CB  PRO A 316      19.084  61.988  31.521  1.00 52.86           C  
ATOM   2462  CG  PRO A 316      18.342  60.709  31.440  1.00 53.02           C  
ATOM   2463  CD  PRO A 316      18.577  60.282  30.002  1.00 52.75           C  
ATOM   2464  N   GLU A 317      20.726  63.395  29.128  1.00 55.05           N  
ATOM   2465  CA  GLU A 317      21.733  64.363  28.716  1.00 55.56           C  
ATOM   2466  C   GLU A 317      21.910  64.469  27.205  1.00 55.00           C  
ATOM   2467  O   GLU A 317      23.020  64.719  26.734  1.00 56.37           O  
ATOM   2468  CB  GLU A 317      23.083  64.006  29.338  1.00 57.37           C  
ATOM   2469  CG  GLU A 317      23.104  63.962  30.853  1.00 61.31           C  
ATOM   2470  CD  GLU A 317      24.488  63.620  31.396  1.00 64.99           C  
ATOM   2471  OE1 GLU A 317      25.006  62.530  31.066  1.00 66.31           O  
ATOM   2472  OE2 GLU A 317      25.061  64.442  32.147  1.00 66.74           O  
ATOM   2473  N   ASP A 318      20.833  64.286  26.445  1.00 53.43           N  
ATOM   2474  CA  ASP A 318      20.908  64.363  24.983  1.00 50.87           C  
ATOM   2475  C   ASP A 318      19.542  64.034  24.392  1.00 49.50           C  
ATOM   2476  O   ASP A 318      19.183  62.869  24.268  1.00 48.83           O  
ATOM   2477  CB  ASP A 318      21.969  63.378  24.461  1.00 50.56           C  
ATOM   2478  CG  ASP A 318      22.285  63.570  22.982  1.00 50.77           C  
ATOM   2479  OD1 ASP A 318      23.380  63.146  22.553  1.00 49.08           O  
ATOM   2480  OD2 ASP A 318      21.444  64.129  22.247  1.00 49.60           O  
ATOM   2481  N   SER A 319      18.787  65.067  24.030  1.00 48.24           N  
ATOM   2482  CA  SER A 319      17.452  64.880  23.471  1.00 48.57           C  
ATOM   2483  C   SER A 319      17.401  64.328  22.039  1.00 48.58           C  
ATOM   2484  O   SER A 319      16.322  64.216  21.454  1.00 49.15           O  
ATOM   2485  CB  SER A 319      16.673  66.193  23.540  1.00 48.16           C  
ATOM   2486  OG  SER A 319      17.299  67.195  22.765  1.00 49.45           O  
ATOM   2487  N   ARG A 320      18.558  63.987  21.477  1.00 47.95           N  
ATOM   2488  CA  ARG A 320      18.623  63.428  20.127  1.00 48.12           C  
ATOM   2489  C   ARG A 320      18.423  61.914  20.234  1.00 47.67           C  
ATOM   2490  O   ARG A 320      18.054  61.249  19.266  1.00 46.49           O  
ATOM   2491  CB  ARG A 320      19.997  63.689  19.490  1.00 49.27           C  
ATOM   2492  CG  ARG A 320      20.388  65.153  19.291  1.00 50.04           C  
ATOM   2493  CD  ARG A 320      21.849  65.265  18.828  1.00 50.92           C  
ATOM   2494  NE  ARG A 320      22.793  64.730  19.816  1.00 52.56           N  
ATOM   2495  CZ  ARG A 320      24.110  64.634  19.634  1.00 52.59           C  
ATOM   2496  NH1 ARG A 320      24.657  65.037  18.496  1.00 54.31           N  
ATOM   2497  NH2 ARG A 320      24.884  64.127  20.584  1.00 51.95           N  
ATOM   2498  N   ILE A 321      18.687  61.384  21.428  1.00 46.11           N  
ATOM   2499  CA  ILE A 321      18.575  59.955  21.704  1.00 43.93           C  
ATOM   2500  C   ILE A 321      17.354  59.627  22.554  1.00 42.91           C  
ATOM   2501  O   ILE A 321      17.179  60.188  23.632  1.00 44.53           O  
ATOM   2502  CB  ILE A 321      19.822  59.456  22.451  1.00 42.43           C  
ATOM   2503  CG1 ILE A 321      21.075  59.773  21.633  1.00 42.37           C  
ATOM   2504  CG2 ILE A 321      19.709  57.969  22.720  1.00 42.44           C  
ATOM   2505  CD1 ILE A 321      22.375  59.441  22.345  1.00 41.91           C  
ATOM   2506  N   LEU A 322      16.507  58.724  22.072  1.00 40.60           N  
ATOM   2507  CA  LEU A 322      15.326  58.336  22.829  1.00 39.33           C  
ATOM   2508  C   LEU A 322      15.327  56.834  23.063  1.00 39.41           C  
ATOM   2509  O   LEU A 322      16.005  56.089  22.357  1.00 39.94           O  
ATOM   2510  CB  LEU A 322      14.041  58.737  22.100  1.00 39.09           C  
ATOM   2511  CG  LEU A 322      13.799  60.226  21.840  1.00 39.72           C  
ATOM   2512  CD1 LEU A 322      14.643  60.666  20.656  1.00 40.25           C  
ATOM   2513  CD2 LEU A 322      12.326  60.475  21.546  1.00 38.64           C  
ATOM   2514  N   PHE A 323      14.569  56.400  24.066  1.00 39.00           N  
ATOM   2515  CA  PHE A 323      14.460  54.984  24.411  1.00 37.58           C  
ATOM   2516  C   PHE A 323      12.990  54.587  24.447  1.00 36.90           C  
ATOM   2517  O   PHE A 323      12.128  55.422  24.710  1.00 37.11           O  
ATOM   2518  CB  PHE A 323      15.089  54.726  25.779  1.00 36.33           C  
ATOM   2519  CG  PHE A 323      16.561  55.008  25.828  1.00 35.86           C  
ATOM   2520  CD1 PHE A 323      17.484  54.012  25.525  1.00 33.61           C  
ATOM   2521  CD2 PHE A 323      17.026  56.278  26.154  1.00 34.79           C  
ATOM   2522  CE1 PHE A 323      18.847  54.280  25.548  1.00 33.32           C  
ATOM   2523  CE2 PHE A 323      18.391  56.554  26.177  1.00 32.90           C  
ATOM   2524  CZ  PHE A 323      19.300  55.557  25.874  1.00 32.93           C  
ATOM   2525  N   ALA A 324      12.712  53.315  24.174  1.00 36.01           N  
ATOM   2526  CA  ALA A 324      11.346  52.786  24.180  1.00 34.29           C  
ATOM   2527  C   ALA A 324      11.428  51.280  24.410  1.00 33.32           C  
ATOM   2528  O   ALA A 324      11.109  50.487  23.524  1.00 31.95           O  
ATOM   2529  CB  ALA A 324      10.666  53.079  22.846  1.00 32.59           C  
ATOM   2530  N   ALA A 325      11.855  50.894  25.607  1.00 32.05           N  
ATOM   2531  CA  ALA A 325      12.021  49.484  25.926  1.00 32.32           C  
ATOM   2532  C   ALA A 325      11.624  49.093  27.350  1.00 32.84           C  
ATOM   2533  O   ALA A 325      11.618  49.919  28.262  1.00 31.39           O  
ATOM   2534  CB  ALA A 325      13.473  49.084  25.674  1.00 29.36           C  
ATOM   2535  N   GLY A 326      11.305  47.814  27.531  1.00 32.90           N  
ATOM   2536  CA  GLY A 326      10.929  47.332  28.842  1.00 33.23           C  
ATOM   2537  C   GLY A 326       9.435  47.251  29.090  1.00 34.00           C  
ATOM   2538  O   GLY A 326       8.987  47.474  30.215  1.00 35.71           O  
ATOM   2539  N   HIS A 327       8.660  46.961  28.050  1.00 31.96           N  
ATOM   2540  CA  HIS A 327       7.220  46.825  28.208  1.00 31.43           C  
ATOM   2541  C   HIS A 327       7.029  45.376  28.645  1.00 32.81           C  
ATOM   2542  O   HIS A 327       6.847  44.499  27.811  1.00 35.52           O  
ATOM   2543  CB  HIS A 327       6.492  47.042  26.881  1.00 30.31           C  
ATOM   2544  CG  HIS A 327       6.706  48.393  26.274  1.00 29.61           C  
ATOM   2545  ND1 HIS A 327       7.932  48.815  25.804  1.00 28.89           N  
ATOM   2546  CD2 HIS A 327       5.832  49.391  25.997  1.00 28.75           C  
ATOM   2547  CE1 HIS A 327       7.802  50.011  25.258  1.00 29.18           C  
ATOM   2548  NE2 HIS A 327       6.538  50.383  25.360  1.00 28.69           N  
ATOM   2549  N   PHE A 328       7.070  45.136  29.951  1.00 33.48           N  
ATOM   2550  CA  PHE A 328       6.945  43.797  30.529  1.00 32.55           C  
ATOM   2551  C   PHE A 328       5.856  42.880  29.931  1.00 33.32           C  
ATOM   2552  O   PHE A 328       6.162  41.949  29.172  1.00 31.72           O  
ATOM   2553  CB  PHE A 328       6.764  43.944  32.046  1.00 32.41           C  
ATOM   2554  CG  PHE A 328       6.819  42.649  32.799  1.00 31.15           C  
ATOM   2555  CD1 PHE A 328       7.830  41.731  32.560  1.00 30.50           C  
ATOM   2556  CD2 PHE A 328       5.860  42.352  33.758  1.00 31.35           C  
ATOM   2557  CE1 PHE A 328       7.884  40.538  33.255  1.00 27.42           C  
ATOM   2558  CE2 PHE A 328       5.907  41.162  34.458  1.00 30.30           C  
ATOM   2559  CZ  PHE A 328       6.924  40.252  34.202  1.00 30.01           C  
ATOM   2560  N   ARG A 329       4.596  43.128  30.273  1.00 33.22           N  
ATOM   2561  CA  ARG A 329       3.502  42.308  29.759  1.00 33.68           C  
ATOM   2562  C   ARG A 329       2.551  43.086  28.856  1.00 33.54           C  
ATOM   2563  O   ARG A 329       1.503  42.561  28.480  1.00 34.29           O  
ATOM   2564  CB  ARG A 329       2.668  41.720  30.908  1.00 35.15           C  
ATOM   2565  CG  ARG A 329       3.365  40.736  31.851  1.00 38.31           C  
ATOM   2566  CD  ARG A 329       2.411  40.333  33.007  1.00 38.66           C  
ATOM   2567  NE  ARG A 329       2.943  39.274  33.866  1.00 40.81           N  
ATOM   2568  CZ  ARG A 329       2.853  37.972  33.600  1.00 42.48           C  
ATOM   2569  NH1 ARG A 329       2.243  37.560  32.501  1.00 43.17           N  
ATOM   2570  NH2 ARG A 329       3.383  37.074  34.425  1.00 42.77           N  
ATOM   2571  N   ASN A 330       2.893  44.322  28.504  1.00 32.97           N  
ATOM   2572  CA  ASN A 330       1.988  45.122  27.682  1.00 34.20           C  
ATOM   2573  C   ASN A 330       2.548  45.741  26.402  1.00 33.77           C  
ATOM   2574  O   ASN A 330       2.006  46.734  25.905  1.00 34.28           O  
ATOM   2575  CB  ASN A 330       1.361  46.237  28.530  1.00 36.38           C  
ATOM   2576  CG  ASN A 330       2.400  47.182  29.124  1.00 40.48           C  
ATOM   2577  OD1 ASN A 330       3.562  47.189  28.712  1.00 42.09           O  
ATOM   2578  ND2 ASN A 330       1.979  47.995  30.089  1.00 40.78           N  
ATOM   2579  N   GLY A 331       3.612  45.159  25.858  1.00 32.47           N  
ATOM   2580  CA  GLY A 331       4.196  45.703  24.647  1.00 30.34           C  
ATOM   2581  C   GLY A 331       3.229  45.864  23.485  1.00 29.08           C  
ATOM   2582  O   GLY A 331       3.288  46.856  22.770  1.00 29.46           O  
ATOM   2583  N   ILE A 332       2.345  44.892  23.280  1.00 27.67           N  
ATOM   2584  CA  ILE A 332       1.388  44.957  22.183  1.00 26.18           C  
ATOM   2585  C   ILE A 332       0.382  46.087  22.416  1.00 28.89           C  
ATOM   2586  O   ILE A 332       0.209  46.969  21.570  1.00 29.09           O  
ATOM   2587  CB  ILE A 332       0.640  43.613  22.030  1.00 23.49           C  
ATOM   2588  CG1 ILE A 332       1.647  42.458  22.037  1.00 21.59           C  
ATOM   2589  CG2 ILE A 332      -0.166  43.603  20.747  1.00 19.54           C  
ATOM   2590  CD1 ILE A 332       2.873  42.682  21.159  1.00 17.36           C  
ATOM   2591  N   LEU A 333      -0.276  46.051  23.571  1.00 29.88           N  
ATOM   2592  CA  LEU A 333      -1.250  47.065  23.956  1.00 29.02           C  
ATOM   2593  C   LEU A 333      -0.686  48.475  23.798  1.00 30.89           C  
ATOM   2594  O   LEU A 333      -1.287  49.326  23.146  1.00 32.76           O  
ATOM   2595  CB  LEU A 333      -1.649  46.852  25.416  1.00 28.12           C  
ATOM   2596  CG  LEU A 333      -2.441  47.938  26.143  1.00 26.79           C  
ATOM   2597  CD1 LEU A 333      -3.884  47.974  25.646  1.00 28.09           C  
ATOM   2598  CD2 LEU A 333      -2.406  47.643  27.631  1.00 26.25           C  
ATOM   2599  N   LEU A 334       0.480  48.709  24.390  1.00 30.42           N  
ATOM   2600  CA  LEU A 334       1.119  50.017  24.371  1.00 31.27           C  
ATOM   2601  C   LEU A 334       1.859  50.409  23.095  1.00 34.85           C  
ATOM   2602  O   LEU A 334       2.476  51.479  23.035  1.00 35.65           O  
ATOM   2603  CB  LEU A 334       2.065  50.116  25.564  1.00 28.00           C  
ATOM   2604  CG  LEU A 334       1.575  50.801  26.845  1.00 28.03           C  
ATOM   2605  CD1 LEU A 334       0.072  50.684  27.027  1.00 26.98           C  
ATOM   2606  CD2 LEU A 334       2.305  50.186  28.012  1.00 26.02           C  
ATOM   2607  N   ALA A 335       1.791  49.563  22.072  1.00 36.85           N  
ATOM   2608  CA  ALA A 335       2.478  49.840  20.815  1.00 36.98           C  
ATOM   2609  C   ALA A 335       2.099  51.197  20.208  1.00 37.61           C  
ATOM   2610  O   ALA A 335       2.973  52.005  19.900  1.00 37.07           O  
ATOM   2611  CB  ALA A 335       2.208  48.719  19.817  1.00 39.32           C  
ATOM   2612  N   PRO A 336       0.793  51.460  20.022  1.00 37.61           N  
ATOM   2613  CA  PRO A 336       0.343  52.736  19.447  1.00 38.04           C  
ATOM   2614  C   PRO A 336       0.730  53.970  20.270  1.00 38.65           C  
ATOM   2615  O   PRO A 336       1.256  54.937  19.727  1.00 39.64           O  
ATOM   2616  CB  PRO A 336      -1.170  52.559  19.362  1.00 37.70           C  
ATOM   2617  CG  PRO A 336      -1.327  51.081  19.173  1.00 37.20           C  
ATOM   2618  CD  PRO A 336      -0.339  50.528  20.164  1.00 36.73           C  
ATOM   2619  N   ALA A 337       0.472  53.933  21.575  1.00 39.11           N  
ATOM   2620  CA  ALA A 337       0.795  55.056  22.458  1.00 39.26           C  
ATOM   2621  C   ALA A 337       2.293  55.305  22.569  1.00 39.50           C  
ATOM   2622  O   ALA A 337       2.730  56.454  22.637  1.00 41.41           O  
ATOM   2623  CB  ALA A 337       0.210  54.823  23.851  1.00 38.07           C  
ATOM   2624  N   THR A 338       3.077  54.230  22.600  1.00 39.01           N  
ATOM   2625  CA  THR A 338       4.530  54.349  22.695  1.00 37.15           C  
ATOM   2626  C   THR A 338       5.088  54.946  21.401  1.00 37.12           C  
ATOM   2627  O   THR A 338       5.985  55.781  21.426  1.00 36.32           O  
ATOM   2628  CB  THR A 338       5.189  52.968  22.943  1.00 36.39           C  
ATOM   2629  OG1 THR A 338       4.602  52.359  24.099  1.00 35.90           O  
ATOM   2630  CG2 THR A 338       6.692  53.116  23.179  1.00 33.77           C  
ATOM   2631  N   GLY A 339       4.539  54.517  20.272  1.00 38.13           N  
ATOM   2632  CA  GLY A 339       4.999  55.015  18.988  1.00 41.21           C  
ATOM   2633  C   GLY A 339       4.650  56.472  18.771  1.00 43.44           C  
ATOM   2634  O   GLY A 339       5.446  57.241  18.235  1.00 43.92           O  
ATOM   2635  N   ALA A 340       3.447  56.852  19.182  1.00 44.97           N  
ATOM   2636  CA  ALA A 340       3.002  58.229  19.040  1.00 45.53           C  
ATOM   2637  C   ALA A 340       3.822  59.124  19.962  1.00 46.36           C  
ATOM   2638  O   ALA A 340       4.206  60.232  19.589  1.00 46.52           O  
ATOM   2639  CB  ALA A 340       1.529  58.338  19.382  1.00 44.54           C  
ATOM   2640  N   LEU A 341       4.097  58.633  21.166  1.00 46.56           N  
ATOM   2641  CA  LEU A 341       4.865  59.406  22.128  1.00 47.34           C  
ATOM   2642  C   LEU A 341       6.276  59.691  21.628  1.00 48.19           C  
ATOM   2643  O   LEU A 341       6.719  60.837  21.630  1.00 48.64           O  
ATOM   2644  CB  LEU A 341       4.923  58.676  23.470  1.00 47.64           C  
ATOM   2645  CG  LEU A 341       5.565  59.475  24.608  1.00 48.71           C  
ATOM   2646  CD1 LEU A 341       4.918  60.851  24.678  1.00 49.42           C  
ATOM   2647  CD2 LEU A 341       5.398  58.739  25.935  1.00 48.63           C  
ATOM   2648  N   ILE A 342       6.981  58.650  21.199  1.00 48.84           N  
ATOM   2649  CA  ILE A 342       8.338  58.825  20.698  1.00 49.56           C  
ATOM   2650  C   ILE A 342       8.347  59.701  19.445  1.00 51.34           C  
ATOM   2651  O   ILE A 342       9.202  60.573  19.299  1.00 51.36           O  
ATOM   2652  CB  ILE A 342       9.006  57.460  20.386  1.00 47.85           C  
ATOM   2653  CG1 ILE A 342       9.291  56.709  21.691  1.00 46.88           C  
ATOM   2654  CG2 ILE A 342      10.302  57.670  19.607  1.00 46.93           C  
ATOM   2655  CD1 ILE A 342      10.251  57.426  22.638  1.00 43.01           C  
ATOM   2656  N   SER A 343       7.392  59.477  18.546  1.00 52.83           N  
ATOM   2657  CA  SER A 343       7.314  60.268  17.323  1.00 53.59           C  
ATOM   2658  C   SER A 343       7.095  61.739  17.656  1.00 53.59           C  
ATOM   2659  O   SER A 343       7.809  62.597  17.153  1.00 54.20           O  
ATOM   2660  CB  SER A 343       6.177  59.767  16.427  1.00 55.27           C  
ATOM   2661  OG  SER A 343       6.115  60.503  15.213  1.00 57.15           O  
ATOM   2662  N   ASP A 344       6.118  62.029  18.512  1.00 53.85           N  
ATOM   2663  CA  ASP A 344       5.832  63.410  18.887  1.00 53.58           C  
ATOM   2664  C   ASP A 344       7.006  64.096  19.576  1.00 54.16           C  
ATOM   2665  O   ASP A 344       7.243  65.284  19.359  1.00 54.85           O  
ATOM   2666  CB  ASP A 344       4.589  63.482  19.776  1.00 52.26           C  
ATOM   2667  CG  ASP A 344       3.325  63.124  19.025  1.00 52.62           C  
ATOM   2668  OD1 ASP A 344       3.297  63.327  17.795  1.00 52.45           O  
ATOM   2669  OD2 ASP A 344       2.355  62.652  19.658  1.00 53.68           O  
ATOM   2670  N   LEU A 345       7.737  63.357  20.405  1.00 54.03           N  
ATOM   2671  CA  LEU A 345       8.894  63.922  21.092  1.00 53.79           C  
ATOM   2672  C   LEU A 345       9.942  64.319  20.064  1.00 54.13           C  
ATOM   2673  O   LEU A 345      10.554  65.382  20.163  1.00 55.09           O  
ATOM   2674  CB  LEU A 345       9.500  62.909  22.068  1.00 53.43           C  
ATOM   2675  CG  LEU A 345       8.818  62.716  23.423  1.00 51.97           C  
ATOM   2676  CD1 LEU A 345       9.516  61.614  24.201  1.00 51.02           C  
ATOM   2677  CD2 LEU A 345       8.867  64.016  24.201  1.00 50.62           C  
ATOM   2678  N   ILE A 346      10.148  63.458  19.078  1.00 54.45           N  
ATOM   2679  CA  ILE A 346      11.120  63.728  18.032  1.00 56.08           C  
ATOM   2680  C   ILE A 346      10.660  64.923  17.196  1.00 58.16           C  
ATOM   2681  O   ILE A 346      11.480  65.713  16.728  1.00 57.60           O  
ATOM   2682  CB  ILE A 346      11.320  62.487  17.136  1.00 55.57           C  
ATOM   2683  CG1 ILE A 346      12.028  61.392  17.940  1.00 54.71           C  
ATOM   2684  CG2 ILE A 346      12.136  62.850  15.902  1.00 56.98           C  
ATOM   2685  CD1 ILE A 346      12.171  60.073  17.207  1.00 54.81           C  
ATOM   2686  N   MET A 347       9.348  65.054  17.014  1.00 60.33           N  
ATOM   2687  CA  MET A 347       8.796  66.180  16.267  1.00 62.50           C  
ATOM   2688  C   MET A 347       8.750  67.371  17.216  1.00 64.51           C  
ATOM   2689  O   MET A 347       8.308  68.456  16.847  1.00 64.99           O  
ATOM   2690  CB  MET A 347       7.379  65.877  15.769  1.00 62.32           C  
ATOM   2691  CG  MET A 347       7.286  64.766  14.733  1.00 64.76           C  
ATOM   2692  SD  MET A 347       8.238  65.090  13.233  1.00 68.40           S  
ATOM   2693  CE  MET A 347       7.000  65.921  12.218  1.00 67.73           C  
ATOM   2694  N   ASN A 348       9.212  67.152  18.444  1.00 66.40           N  
ATOM   2695  CA  ASN A 348       9.235  68.187  19.472  1.00 68.21           C  
ATOM   2696  C   ASN A 348       7.882  68.861  19.657  1.00 69.08           C  
ATOM   2697  O   ASN A 348       7.794  70.087  19.717  1.00 69.69           O  
ATOM   2698  CB  ASN A 348      10.302  69.235  19.143  1.00 68.70           C  
ATOM   2699  CG  ASN A 348      11.708  68.738  19.416  1.00 70.43           C  
ATOM   2700  OD1 ASN A 348      12.158  67.748  18.833  1.00 71.37           O  
ATOM   2701  ND2 ASN A 348      12.412  69.418  20.316  1.00 70.79           N  
ATOM   2702  N   LYS A 349       6.832  68.050  19.756  1.00 69.56           N  
ATOM   2703  CA  LYS A 349       5.478  68.560  19.936  1.00 70.08           C  
ATOM   2704  C   LYS A 349       5.124  68.617  21.414  1.00 70.36           C  
ATOM   2705  O   LYS A 349       5.971  68.370  22.270  1.00 70.49           O  
ATOM   2706  CB  LYS A 349       4.474  67.662  19.210  1.00 69.99           C  
ATOM   2707  CG  LYS A 349       4.777  67.458  17.742  1.00 69.99           C  
ATOM   2708  CD  LYS A 349       3.643  66.739  17.028  1.00 70.77           C  
ATOM   2709  CE  LYS A 349       3.936  66.604  15.535  1.00 71.23           C  
ATOM   2710  NZ  LYS A 349       2.778  66.073  14.768  1.00 70.96           N  
ATOM   2711  N   GLU A 350       3.870  68.951  21.705  1.00 71.31           N  
ATOM   2712  CA  GLU A 350       3.387  69.025  23.084  1.00 72.89           C  
ATOM   2713  C   GLU A 350       3.070  67.608  23.547  1.00 71.91           C  
ATOM   2714  O   GLU A 350       2.473  66.830  22.801  1.00 72.42           O  
ATOM   2715  CB  GLU A 350       2.116  69.875  23.160  1.00 75.37           C  
ATOM   2716  CG  GLU A 350       0.973  69.351  22.288  1.00 79.66           C  
ATOM   2717  CD  GLU A 350      -0.355  70.059  22.545  1.00 82.17           C  
ATOM   2718  OE1 GLU A 350      -0.400  71.307  22.447  1.00 83.36           O  
ATOM   2719  OE2 GLU A 350      -1.354  69.363  22.837  1.00 82.62           O  
ATOM   2720  N   VAL A 351       3.461  67.265  24.770  1.00 70.12           N  
ATOM   2721  CA  VAL A 351       3.200  65.925  25.276  1.00 68.22           C  
ATOM   2722  C   VAL A 351       2.809  65.886  26.748  1.00 67.20           C  
ATOM   2723  O   VAL A 351       3.345  66.634  27.566  1.00 66.60           O  
ATOM   2724  CB  VAL A 351       4.428  64.996  25.075  1.00 68.27           C  
ATOM   2725  CG1 VAL A 351       4.840  64.984  23.613  1.00 67.75           C  
ATOM   2726  CG2 VAL A 351       5.579  65.445  25.960  1.00 66.81           C  
ATOM   2727  N   ASN A 352       1.867  65.003  27.068  1.00 66.33           N  
ATOM   2728  CA  ASN A 352       1.383  64.810  28.430  1.00 65.31           C  
ATOM   2729  C   ASN A 352       2.584  64.647  29.358  1.00 65.61           C  
ATOM   2730  O   ASN A 352       3.283  63.632  29.307  1.00 65.95           O  
ATOM   2731  CB  ASN A 352       0.509  63.555  28.487  1.00 64.75           C  
ATOM   2732  CG  ASN A 352      -0.078  63.309  29.860  1.00 64.88           C  
ATOM   2733  OD1 ASN A 352       0.646  63.226  30.855  1.00 64.87           O  
ATOM   2734  ND2 ASN A 352      -1.400  63.181  29.920  1.00 63.34           N  
ATOM   2735  N   GLN A 353       2.820  65.649  30.203  1.00 64.62           N  
ATOM   2736  CA  GLN A 353       3.953  65.625  31.123  1.00 63.70           C  
ATOM   2737  C   GLN A 353       3.881  64.529  32.174  1.00 62.17           C  
ATOM   2738  O   GLN A 353       4.908  64.110  32.717  1.00 61.00           O  
ATOM   2739  CB  GLN A 353       4.101  66.985  31.810  1.00 65.41           C  
ATOM   2740  CG  GLN A 353       4.621  68.071  30.888  1.00 67.69           C  
ATOM   2741  CD  GLN A 353       6.040  67.802  30.418  1.00 69.44           C  
ATOM   2742  OE1 GLN A 353       6.494  68.375  29.427  1.00 70.51           O  
ATOM   2743  NE2 GLN A 353       6.754  66.936  31.136  1.00 69.36           N  
ATOM   2744  N   ASP A 354       2.672  64.062  32.461  1.00 60.66           N  
ATOM   2745  CA  ASP A 354       2.503  63.017  33.458  1.00 60.41           C  
ATOM   2746  C   ASP A 354       3.059  61.697  32.946  1.00 58.24           C  
ATOM   2747  O   ASP A 354       3.768  60.990  33.666  1.00 57.57           O  
ATOM   2748  CB  ASP A 354       1.025  62.875  33.832  1.00 62.95           C  
ATOM   2749  CG  ASP A 354       0.460  64.141  34.463  1.00 64.82           C  
ATOM   2750  OD1 ASP A 354       1.050  64.637  35.452  1.00 64.60           O  
ATOM   2751  OD2 ASP A 354      -0.577  64.638  33.972  1.00 67.00           O  
ATOM   2752  N   TRP A 355       2.748  61.369  31.696  1.00 55.55           N  
ATOM   2753  CA  TRP A 355       3.248  60.137  31.109  1.00 53.30           C  
ATOM   2754  C   TRP A 355       4.748  60.250  30.918  1.00 52.92           C  
ATOM   2755  O   TRP A 355       5.500  59.332  31.258  1.00 53.38           O  
ATOM   2756  CB  TRP A 355       2.572  59.868  29.769  1.00 50.80           C  
ATOM   2757  CG  TRP A 355       1.101  59.706  29.897  1.00 50.01           C  
ATOM   2758  CD1 TRP A 355       0.415  59.366  31.025  1.00 48.72           C  
ATOM   2759  CD2 TRP A 355       0.125  59.832  28.856  1.00 49.53           C  
ATOM   2760  NE1 TRP A 355      -0.926  59.270  30.754  1.00 50.22           N  
ATOM   2761  CE2 TRP A 355      -1.133  59.550  29.429  1.00 49.04           C  
ATOM   2762  CE3 TRP A 355       0.192  60.153  27.494  1.00 49.78           C  
ATOM   2763  CZ2 TRP A 355      -2.320  59.578  28.689  1.00 48.88           C  
ATOM   2764  CZ3 TRP A 355      -0.993  60.182  26.755  1.00 50.41           C  
ATOM   2765  CH2 TRP A 355      -2.230  59.894  27.358  1.00 49.85           C  
ATOM   2766  N   LEU A 356       5.179  61.388  30.386  1.00 51.45           N  
ATOM   2767  CA  LEU A 356       6.592  61.630  30.143  1.00 50.04           C  
ATOM   2768  C   LEU A 356       7.401  61.451  31.420  1.00 49.72           C  
ATOM   2769  O   LEU A 356       8.561  61.042  31.378  1.00 49.99           O  
ATOM   2770  CB  LEU A 356       6.795  63.040  29.586  1.00 50.42           C  
ATOM   2771  CG  LEU A 356       8.206  63.404  29.112  1.00 49.58           C  
ATOM   2772  CD1 LEU A 356       8.704  62.361  28.120  1.00 49.90           C  
ATOM   2773  CD2 LEU A 356       8.180  64.781  28.471  1.00 47.92           C  
ATOM   2774  N   HIS A 357       6.783  61.747  32.559  1.00 49.26           N  
ATOM   2775  CA  HIS A 357       7.474  61.611  33.834  1.00 48.43           C  
ATOM   2776  C   HIS A 357       7.322  60.205  34.384  1.00 46.50           C  
ATOM   2777  O   HIS A 357       8.163  59.731  35.147  1.00 44.24           O  
ATOM   2778  CB  HIS A 357       6.939  62.626  34.853  1.00 50.24           C  
ATOM   2779  CG  HIS A 357       7.543  62.481  36.216  1.00 50.65           C  
ATOM   2780  ND1 HIS A 357       7.131  61.519  37.114  1.00 51.68           N  
ATOM   2781  CD2 HIS A 357       8.572  63.132  36.809  1.00 51.30           C  
ATOM   2782  CE1 HIS A 357       7.882  61.580  38.199  1.00 51.48           C  
ATOM   2783  NE2 HIS A 357       8.765  62.549  38.040  1.00 52.21           N  
ATOM   2784  N   ALA A 358       6.240  59.544  33.994  1.00 45.71           N  
ATOM   2785  CA  ALA A 358       5.987  58.186  34.454  1.00 46.67           C  
ATOM   2786  C   ALA A 358       6.986  57.214  33.825  1.00 45.75           C  
ATOM   2787  O   ALA A 358       7.369  56.222  34.441  1.00 45.66           O  
ATOM   2788  CB  ALA A 358       4.549  57.768  34.107  1.00 46.65           C  
ATOM   2789  N   PHE A 359       7.418  57.516  32.606  1.00 44.89           N  
ATOM   2790  CA  PHE A 359       8.356  56.650  31.905  1.00 45.21           C  
ATOM   2791  C   PHE A 359       9.779  57.200  31.827  1.00 46.26           C  
ATOM   2792  O   PHE A 359      10.595  56.691  31.064  1.00 46.21           O  
ATOM   2793  CB  PHE A 359       7.827  56.360  30.497  1.00 42.76           C  
ATOM   2794  CG  PHE A 359       6.439  55.758  30.481  1.00 41.67           C  
ATOM   2795  CD1 PHE A 359       6.186  54.538  31.105  1.00 40.18           C  
ATOM   2796  CD2 PHE A 359       5.389  56.409  29.842  1.00 39.01           C  
ATOM   2797  CE1 PHE A 359       4.906  53.979  31.088  1.00 38.97           C  
ATOM   2798  CE2 PHE A 359       4.108  55.855  29.823  1.00 38.41           C  
ATOM   2799  CZ  PHE A 359       3.867  54.642  30.445  1.00 37.58           C  
ATOM   2800  N   ARG A 360      10.073  58.228  32.617  1.00 47.84           N  
ATOM   2801  CA  ARG A 360      11.407  58.829  32.642  1.00 50.13           C  
ATOM   2802  C   ARG A 360      12.471  57.749  32.546  1.00 49.98           C  
ATOM   2803  O   ARG A 360      12.283  56.643  33.049  1.00 50.56           O  
ATOM   2804  CB  ARG A 360      11.645  59.586  33.954  1.00 53.02           C  
ATOM   2805  CG  ARG A 360      10.652  60.682  34.266  1.00 57.90           C  
ATOM   2806  CD  ARG A 360      11.013  61.444  35.549  1.00 60.02           C  
ATOM   2807  NE  ARG A 360      10.679  60.739  36.790  1.00 61.95           N  
ATOM   2808  CZ  ARG A 360      11.416  59.781  37.347  1.00 63.14           C  
ATOM   2809  NH1 ARG A 360      12.551  59.390  36.779  1.00 64.61           N  
ATOM   2810  NH2 ARG A 360      11.025  59.220  38.484  1.00 61.75           N  
ATOM   2811  N   ILE A 361      13.595  58.074  31.918  1.00 49.49           N  
ATOM   2812  CA  ILE A 361      14.686  57.121  31.796  1.00 50.27           C  
ATOM   2813  C   ILE A 361      15.420  56.958  33.133  1.00 53.76           C  
ATOM   2814  O   ILE A 361      15.857  55.864  33.480  1.00 54.86           O  
ATOM   2815  CB  ILE A 361      15.689  57.556  30.693  1.00 46.42           C  
ATOM   2816  CG1 ILE A 361      15.345  56.868  29.368  1.00 43.31           C  
ATOM   2817  CG2 ILE A 361      17.112  57.201  31.098  1.00 44.56           C  
ATOM   2818  CD1 ILE A 361      13.946  57.102  28.880  1.00 40.68           C  
ATOM   2819  N   ASP A 362      15.555  58.043  33.886  1.00 57.54           N  
ATOM   2820  CA  ASP A 362      16.245  57.978  35.171  1.00 61.30           C  
ATOM   2821  C   ASP A 362      15.284  58.052  36.357  1.00 62.62           C  
ATOM   2822  O   ASP A 362      15.112  59.107  36.966  1.00 62.28           O  
ATOM   2823  CB  ASP A 362      17.277  59.103  35.269  1.00 63.30           C  
ATOM   2824  CG  ASP A 362      16.666  60.473  35.059  1.00 66.73           C  
ATOM   2825  OD1 ASP A 362      15.432  60.553  34.860  1.00 68.15           O  
ATOM   2826  OD2 ASP A 362      17.420  61.472  35.093  1.00 68.88           O  
ATOM   2827  N   ARG A 363      14.662  56.920  36.679  1.00 64.03           N  
ATOM   2828  CA  ARG A 363      13.723  56.842  37.791  1.00 63.74           C  
ATOM   2829  C   ARG A 363      14.445  56.479  39.081  1.00 65.39           C  
ATOM   2830  O   ARG A 363      14.837  55.332  39.279  1.00 64.58           O  
ATOM   2831  CB  ARG A 363      12.641  55.809  37.488  1.00 61.85           C  
ATOM   2832  CG  ARG A 363      11.761  56.188  36.319  1.00 59.57           C  
ATOM   2833  CD  ARG A 363      10.519  55.330  36.284  1.00 58.43           C  
ATOM   2834  NE  ARG A 363      10.772  53.972  35.809  1.00 57.50           N  
ATOM   2835  CZ  ARG A 363      10.703  53.600  34.534  1.00 56.29           C  
ATOM   2836  NH1 ARG A 363      10.394  54.481  33.591  1.00 54.87           N  
ATOM   2837  NH2 ARG A 363      10.918  52.337  34.203  1.00 56.17           N  
ATOM   2838  N   LYS A 364      14.600  57.476  39.951  1.00 68.18           N  
ATOM   2839  CA  LYS A 364      15.285  57.338  41.235  1.00 70.36           C  
ATOM   2840  C   LYS A 364      16.234  56.140  41.297  1.00 71.02           C  
ATOM   2841  O   LYS A 364      17.423  56.261  40.997  1.00 70.30           O  
ATOM   2842  CB  LYS A 364      14.270  57.254  42.381  1.00 71.92           C  
ATOM   2843  CG  LYS A 364      13.539  55.931  42.505  1.00 73.78           C  
ATOM   2844  CD  LYS A 364      12.604  55.967  43.708  1.00 77.61           C  
ATOM   2845  CE  LYS A 364      11.892  54.636  43.919  1.00 79.78           C  
ATOM   2846  NZ  LYS A 364      12.842  53.529  44.244  1.00 80.75           N  
TER    2847      LYS A 364                                                      
END
MOLECULE T0490.pdb
ATOM      1  N   THR     3      26.547  61.762   4.288  1.00 30.83           N  
ATOM      2  CA  THR     3      25.686  62.760   4.970  1.00 30.86           C  
ATOM      3  CB  THR     3      24.743  63.446   3.956  1.00 31.28           C  
ATOM      4  OG1 THR     3      23.857  62.472   3.394  1.00 33.76           O  
ATOM      5  CG2 THR     3      25.545  64.077   2.829  1.00 32.39           C  
ATOM      6  C   THR     3      24.875  62.112   6.108  1.00 29.87           C  
ATOM      7  O   THR     3      24.664  60.894   6.139  1.00 30.04      A    O  
ATOM      8  N   ASP     4      24.420  62.918   7.058  1.00 28.40      A    N  
ATOM      9  CA  ASP     4      23.613  62.360   8.116  1.00 26.82      A    C  
ATOM     10  CB  ASP     4      23.315  63.426   9.167  1.00 27.09      A    C  
ATOM     11  CG  ASP     4      24.568  63.956   9.804  1.00 27.99      A    C  
ATOM     12  OD1 ASP     4      25.591  63.256   9.689  1.00 27.47      A    O  
ATOM     13  OD2 ASP     4      24.539  65.052  10.415  1.00 27.69      A    O  
ATOM     14  C   ASP     4      22.302  61.824   7.536  1.00 25.43      A    C  
ATOM     15  O   ASP     4      21.692  62.460   6.668  1.00 25.65      A    O  
ATOM     16  N   ILE     5      21.883  60.651   7.993  1.00 22.86      A    N  
ATOM     17  CA  ILE     5      20.492  60.264   7.862  1.00 20.85      A    C  
ATOM     18  CB  ILE     5      20.306  58.784   8.160  1.00 21.43      A    C  
ATOM     19  CG1 ILE     5      21.076  57.962   7.130  1.00 21.60      A    C  
ATOM     20  CD1 ILE     5      21.089  56.510   7.429  1.00 24.74      A    C  
ATOM     21  CG2 ILE     5      18.821  58.422   8.197  1.00 20.64      A    C  
ATOM     22  C   ILE     5      19.787  61.060   8.943  1.00 19.56      A    C  
ATOM     23  O   ILE     5      20.360  61.305   9.993  1.00 19.01      A    O  
ATOM     24  N   ASP     6      18.561  61.493   8.697  1.00 17.68      A    N  
ATOM     25  CA  ASP     6      17.886  62.313   9.686  1.00 16.70      A    C  
ATOM     26  CB  ASP     6      16.604  62.919   9.115  1.00 17.32      A    C  
ATOM     27  CG  ASP     6      15.998  63.962  10.033  1.00 19.64      A    C  
ATOM     28  OD1 ASP     6      16.705  64.927  10.417  1.00 24.36      A    O  
ATOM     29  OD2 ASP     6      14.808  63.830  10.357  1.00 23.29      A    O  
ATOM     30  C   ASP     6      17.603  61.482  10.948  1.00 15.36      A    C  
ATOM     31  O   ASP     6      18.145  61.771  12.016  1.00 15.11      A    O  
ATOM     32  N   CYS     7      16.783  60.442  10.808  1.00 13.88      A    N  
ATOM     33  CA  CYS     7      16.381  59.596  11.951  1.00 13.17      A    C  
ATOM     34  CB  CYS     7      14.860  59.633  12.129  1.00 13.41      A    C  
ATOM     35  SG  CYS     7      14.137  61.228  12.616  1.00 16.56      A    S  
ATOM     36  C   CYS     7      16.756  58.134  11.726  1.00 12.09      A    C  
ATOM     37  O   CYS     7      16.460  57.589  10.666  1.00 12.24      A    O  
ATOM     38  N   ILE     8      17.398  57.503  12.711  1.00 10.67      A    N  
ATOM     39  CA  ILE     8      17.606  56.048  12.667  1.00  8.90      A    C  
ATOM     40  CB  ILE     8      19.105  55.697  12.732  1.00  9.01      A    C  
ATOM     41  CG1 ILE     8      19.794  56.208  11.453  1.00  9.20      A    C  
ATOM     42  CD1 ILE     8      21.275  55.875  11.355  1.00  9.32      A    C  
ATOM     43  CG2 ILE     8      19.326  54.187  12.879  1.00  8.23      A    C  
ATOM     44  C   ILE     8      16.821  55.421  13.821  1.00  8.24      A    C  
ATOM     45  O   ILE     8      16.911  55.882  14.954  1.00  9.14      A    O  
ATOM     46  N   VAL     9      16.027  54.403  13.517  1.00  8.44      A    N  
ATOM     47  CA  VAL     9      15.312  53.637  14.533  1.00  8.39      A    C  
ATOM     48  CB  VAL     9      13.837  53.445  14.168  1.00  9.16      A    C  
ATOM     49  CG1 VAL     9      13.112  52.551  15.201  1.00  8.57      A    C  
ATOM     50  CG2 VAL     9      13.157  54.814  14.075  1.00 10.05      A    C  
ATOM     51  C   VAL     9      15.979  52.270  14.583  1.00  8.12      A    C  
ATOM     52  O   VAL     9      16.114  51.620  13.546  1.00  8.73      A    O  
ATOM     53  N   ILE    10      16.414  51.866  15.771  1.00  7.97      A    N  
ATOM     54  CA  ILE    10      16.989  50.533  15.970  1.00  7.82      A    C  
ATOM     55  CB  ILE    10      18.113  50.529  17.022  1.00  7.94      A    C  
ATOM     56  CG1 ILE    10      19.161  51.610  16.720  1.00  7.84      A    C  
ATOM     57  CD1 ILE    10      19.863  51.460  15.338  1.00  7.30      A    C  
ATOM     58  CG2 ILE    10      18.748  49.133  17.093  1.00  8.58      A    C  
ATOM     59  C   ILE    10      15.903  49.556  16.437  1.00  7.58      A    C  
ATOM     60  O   ILE    10      15.336  49.713  17.523  1.00  7.74      A    O  
ATOM     61  N   GLY    11      15.625  48.558  15.613  1.00  7.35      A    N  
ATOM     62  CA  GLY    11      14.606  47.553  15.893  1.00  8.11      A    C  
ATOM     63  C   GLY    11      13.362  47.716  15.036  1.00  9.10      A    C  
ATOM     64  O   GLY    11      12.773  48.817  14.973  1.00  9.00      A    O  
ATOM     65  N   ALA    12      12.956  46.614  14.403  1.00  8.90      A    N  
ATOM     66  CA  ALA    12      11.758  46.579  13.569  1.00  8.90      A    C  
ATOM     67  CB  ALA    12      12.082  46.117  12.142  1.00  9.90      A    C  
ATOM     68  C   ALA    12      10.692  45.694  14.182  1.00  8.86      A    C  
ATOM     69  O   ALA    12       9.985  44.978  13.475  1.00  9.63      A    O  
ATOM     70  N   GLY    13      10.574  45.748  15.504  1.00  8.06      A    N  
ATOM     71  CA  GLY    13       9.417  45.172  16.161  1.00  7.81      A    C  
ATOM     72  C   GLY    13       8.215  46.092  16.025  1.00  8.37      A    C  
ATOM     73  O   GLY    13       8.281  47.120  15.348  1.00  8.18      A    O  
ATOM     74  N   VAL    14       7.115  45.726  16.671  1.00  8.40      A    N  
ATOM     75  CA  VAL    14       5.877  46.483  16.459  1.00  9.52      A    C  
ATOM     76  CB  VAL    14       4.647  45.799  17.117  1.00  9.86      A    C  
ATOM     77  CG1 VAL    14       4.414  44.410  16.512  1.00 12.57      A    C  
ATOM     78  CG2 VAL    14       4.782  45.739  18.645  1.00 10.08      A    C  
ATOM     79  C   VAL    14       6.022  47.925  16.935  1.00 10.04      A    C  
ATOM     80  O   VAL    14       5.447  48.863  16.341  1.00 10.04      A    O  
ATOM     81  N   VAL    15       6.785  48.101  18.012  1.00  9.60      A    N  
ATOM     82  CA  VAL    15       7.004  49.416  18.599  1.00  9.62      A    C  
ATOM     83  CB  VAL    15       7.469  49.304  20.083  1.00  9.21      A    C  
ATOM     84  CG1 VAL    15       7.758  50.667  20.637  1.00 11.32      A    C  
ATOM     85  CG2 VAL    15       6.403  48.606  20.926  1.00 10.95      A    C  
ATOM     86  C   VAL    15       7.987  50.241  17.773  1.00  9.54      A    C  
ATOM     87  O   VAL    15       7.739  51.404  17.481  1.00  9.33      A    O  
ATOM     88  N   GLY    16       9.116  49.647  17.386  1.00  9.32      A    N  
ATOM     89  CA  GLY    16      10.039  50.332  16.493  1.00  9.59      A    C  
ATOM     90  C   GLY    16       9.346  50.773  15.215  1.00  9.25      A    C  
ATOM     91  O   GLY    16       9.593  51.880  14.705  1.00  9.62      A    O  
ATOM     92  N   LEU    17       8.508  49.896  14.661  1.00  9.19      A    N  
ATOM     93  CA  LEU    17       7.808  50.214  13.417  1.00  9.11      A    C  
ATOM     94  CB  LEU    17       7.173  48.974  12.782  1.00  9.20      A    C  
ATOM     95  CG  LEU    17       8.167  47.975  12.167  1.00 10.80      A    C  
ATOM     96  CD1 LEU    17       7.497  46.667  11.777  1.00 12.92      A    C  
ATOM     97  CD2 LEU    17       8.900  48.605  10.984  1.00 13.27      A    C  
ATOM     98  C   LEU    17       6.765  51.313  13.615  1.00  9.25      A    C  
ATOM     99  O   LEU    17       6.627  52.185  12.752  1.00  9.50      A    O  
ATOM    100  N   ALA    18       6.044  51.281  14.733  1.00  8.68      A    N  
ATOM    101  CA  ALA    18       5.076  52.366  15.005  1.00  8.79      A    C  
ATOM    102  CB  ALA    18       4.306  52.119  16.285  1.00  8.59      A    C  
ATOM    103  C   ALA    18       5.797  53.708  15.076  1.00  9.13      A    C  
ATOM    104  O   ALA    18       5.309  54.716  14.585  1.00  9.58      A    O  
ATOM    105  N   ILE    19       6.962  53.724  15.714  1.00  8.73      A    N  
ATOM    106  CA  ILE    19       7.751  54.945  15.795  1.00  9.02      A    C  
ATOM    107  CB  ILE    19       8.926  54.770  16.785  1.00  8.31      A    C  
ATOM    108  CG1 ILE    19       8.387  54.535  18.208  1.00  8.79      A    C  
ATOM    109  CD1 ILE    19       9.436  53.989  19.182  1.00  8.74      A    C  
ATOM    110  CG2 ILE    19       9.870  55.980  16.722  1.00  8.49      A    C  
ATOM    111  C   ILE    19       8.283  55.405  14.433  1.00  8.99      A    C  
ATOM    112  O   ILE    19       8.202  56.591  14.106  1.00  9.86      A    O  
ATOM    113  N   ALA    20       8.825  54.478  13.641  1.00  9.69      A    N  
ATOM    114  CA  ALA    20       9.303  54.808  12.295  1.00 10.16      A    C  
ATOM    115  CB  ALA    20       9.826  53.564  11.598  1.00 10.60      A    C  
ATOM    116  C   ALA    20       8.146  55.403  11.487  1.00 10.95      A    C  
ATOM    117  O   ALA    20       8.307  56.412  10.795  1.00 12.16      A    O  
ATOM    118  N   ARG    21       6.989  54.763  11.580  1.00 10.83      A    N  
ATOM    119  CA  ARG    21       5.778  55.252  10.926  1.00 11.56      A    C  
ATOM    120  CB  ARG    21       4.606  54.300  11.199  1.00 10.87      A    C  
ATOM    121  CG  ARG    21       3.228  54.819  10.767  1.00 13.06      A    C  
ATOM    122  CD  ARG    21       2.157  53.773  11.067  1.00 13.28      A    C  
ATOM    123  NE  ARG    21       0.846  54.186  10.573  1.00 14.54      A    N  
ATOM    124  CZ  ARG    21       0.054  55.051  11.190  1.00 16.67      A    C  
ATOM    125  NH1 ARG    21       0.435  55.614  12.331  1.00 17.57      A    N  
ATOM    126  NH2 ARG    21      -1.126  55.365  10.653  1.00 16.89      A    N  
ATOM    127  C   ARG    21       5.448  56.697  11.329  1.00 11.67      A    C  
ATOM    128  O   ARG    21       5.183  57.543  10.456  1.00 12.36      A    O  
ATOM    129  N   ALA    22       5.460  56.983  12.631  1.00 12.00      A    N  
ATOM    130  CA  ALA    22       5.177  58.338  13.121  1.00 12.31      A    C  
ATOM    131  CB  ALA    22       5.071  58.339  14.617  1.00 12.63      A    C  
ATOM    132  C   ALA    22       6.227  59.361  12.649  1.00 13.41      A    C  
ATOM    133  O   ALA    22       5.882  60.457  12.175  1.00 13.54      A    O  
ATOM    134  N   LEU    23       7.504  59.011  12.786  1.00 13.21      A    N  
ATOM    135  CA  LEU    23       8.567  59.890  12.307  1.00 13.66      A    C  
ATOM    136  CB  LEU    23       9.949  59.314  12.635  1.00 13.40      A    C  
ATOM    137  CG  LEU    23      10.337  59.315  14.116  1.00 12.88      A    C  
ATOM    138  CD1 LEU    23      11.577  58.449  14.320  1.00 12.59      A    C  
ATOM    139  CD2 LEU    23      10.563  60.741  14.646  1.00 12.46      A    C  
ATOM    140  C   LEU    23       8.444  60.169  10.803  1.00 14.15      A    C  
ATOM    141  O   LEU    23       8.563  61.325  10.364  1.00 15.00      A    O  
ATOM    142  N   ALA    24       8.181  59.140  10.012  1.00 14.11      A    N  
ATOM    143  CA  ALA    24       8.135  59.318   8.565  1.00 14.56      A    C  
ATOM    144  CB  ALA    24       8.095  57.977   7.855  1.00 14.78      A    C  
ATOM    145  C   ALA    24       6.921  60.177   8.190  1.00 15.33      A    C  
ATOM    146  O   ALA    24       7.010  61.038   7.309  1.00 15.33      A    O  
ATOM    147  N   ALA    25       5.807  59.961   8.884  1.00 15.07      A    N  
ATOM    148  CA  ALA    25       4.586  60.736   8.636  1.00 15.64      A    C  
ATOM    149  CB  ALA    25       3.403  60.147   9.414  1.00 15.31      A    C  
ATOM    150  C   ALA    25       4.798  62.204   8.994  1.00 16.35      A    C  
ATOM    151  O   ALA    25       4.101  63.093   8.478  1.00 17.36      A    O  
ATOM    152  N   GLY    26       5.761  62.466   9.870  1.00 16.03      A    N  
ATOM    153  CA  GLY    26       6.092  63.834  10.270  1.00 17.08      A    C  
ATOM    154  C   GLY    26       7.062  64.494   9.305  1.00 17.67      A    C  
ATOM    155  O   GLY    26       7.528  65.605   9.554  1.00 18.13      A    O  
ATOM    156  N   GLY    27       7.380  63.800   8.214  1.00 17.65      A    N  
ATOM    157  CA  GLY    27       8.239  64.358   7.159  1.00 18.53      A    C  
ATOM    158  C   GLY    27       9.727  64.060   7.277  1.00 18.76      A    C  
ATOM    159  O   GLY    27      10.549  64.617   6.533  1.00 19.47      A    O  
ATOM    160  N   HIS    28      10.090  63.180   8.203  1.00 17.87      A    N  
ATOM    161  CA  HIS    28      11.503  62.880   8.442  1.00 17.67      A    C  
ATOM    162  CB  HIS    28      11.738  62.632   9.932  1.00 17.58      A    C  
ATOM    163  CG  HIS    28      11.363  63.797  10.788  1.00 19.97      A    C  
ATOM    164  ND1 HIS    28      12.159  64.917  10.907  1.00 21.82      A    N  
ATOM    165  CE1 HIS    28      11.565  65.792  11.698  1.00 22.25      A    C  
ATOM    166  NE2 HIS    28      10.411  65.282  12.092  1.00 23.06      A    N  
ATOM    167  CD2 HIS    28      10.257  64.038  11.533  1.00 19.91      A    C  
ATOM    168  C   HIS    28      11.987  61.688   7.643  1.00 16.83      A    C  
ATOM    169  O   HIS    28      11.272  60.712   7.498  1.00 17.40      A    O  
ATOM    170  N   GLU    29      13.212  61.773   7.130  1.00 15.93      A    N  
ATOM    171  CA  GLU    29      13.850  60.630   6.492  1.00 15.15      A    C  
ATOM    172  CB  GLU    29      15.151  61.067   5.819  1.00 14.89      A    C  
ATOM    173  CG  GLU    29      16.082  59.945   5.429  1.00 16.89      A    C  
ATOM    174  CD  GLU    29      17.484  60.441   5.095  1.00 19.01      A    C  
ATOM    175  OE1 GLU    29      17.990  61.372   5.763  1.00 19.10      A    O  
ATOM    176  OE2 GLU    29      18.076  59.895   4.146  1.00 22.56      A    O  
ATOM    177  C   GLU    29      14.141  59.630   7.600  1.00 13.93      A    C  
ATOM    178  O   GLU    29      14.684  60.003   8.626  1.00 13.78      A    O  
ATOM    179  N   VAL    30      13.751  58.379   7.396  1.00 14.02      A    N  
ATOM    180  CA  VAL    30      13.918  57.353   8.423  1.00 13.80      A    C  
ATOM    181  CB  VAL    30      12.555  56.933   9.059  1.00 13.96      A    C  
ATOM    182  CG1 VAL    30      12.774  55.824  10.061  1.00 15.38      A    C  
ATOM    183  CG2 VAL    30      11.896  58.121   9.750  1.00 13.74      A    C  
ATOM    184  C   VAL    30      14.603  56.112   7.866  1.00 13.21      A    C  
ATOM    185  O   VAL    30      14.210  55.588   6.819  1.00 13.14      A    O  
ATOM    186  N   LEU    31      15.638  55.652   8.564  1.00 12.24      A    N  
ATOM    187  CA  LEU    31      16.211  54.336   8.290  1.00 11.94      A    C  
ATOM    188  CB  LEU    31      17.712  54.442   8.031  1.00 12.23      A    C  
ATOM    189  CG  LEU    31      18.406  53.094   7.757  1.00 13.44      A    C  
ATOM    190  CD1 LEU    31      17.915  52.455   6.462  1.00 14.49      A    C  
ATOM    191  CD2 LEU    31      19.935  53.264   7.747  1.00 15.66      A    C  
ATOM    192  C   LEU    31      15.982  53.457   9.513  1.00 11.02      A    C  
ATOM    193  O   LEU    31      16.349  53.834  10.607  1.00 11.03      A    O  
ATOM    194  N   VAL    32      15.350  52.309   9.321  1.00 10.82      A    N  
ATOM    195  CA  VAL    32      15.185  51.346  10.408  1.00 10.63      A    C  
ATOM    196  CB  VAL    32      13.792  50.708  10.395  1.00 11.15      A    C  
ATOM    197  CG1 VAL    32      13.662  49.752  11.568  1.00 11.21      A    C  
ATOM    198  CG2 VAL    32      12.716  51.788  10.455  1.00 11.23      A    C  
ATOM    199  C   VAL    32      16.201  50.221  10.253  1.00 10.43      A    C  
ATOM    200  O   VAL    32      16.208  49.525   9.238  1.00 10.08      A    O  
ATOM    201  N   ALA    33      17.040  50.034  11.267  1.00  9.72      A    N  
ATOM    202  CA  ALA    33      18.043  48.965  11.245  1.00  9.59      A    C  
ATOM    203  CB  ALA    33      19.388  49.493  11.716  1.00  9.71      A    C  
ATOM    204  C   ALA    33      17.588  47.814  12.139  1.00  9.51      A    C  
ATOM    205  O   ALA    33      17.351  48.005  13.321  1.00  9.72      A    O  
ATOM    206  N   GLU    34      17.486  46.627  11.555  1.00  9.06      A    N  
ATOM    207  CA  GLU    34      17.053  45.430  12.279  1.00  9.62      A    C  
ATOM    208  CB  GLU    34      15.703  44.965  11.711  1.00  9.26      A    C  
ATOM    209  CG  GLU    34      15.284  43.565  12.117  1.00 10.47      A    C  
ATOM    210  CD  GLU    34      15.182  43.388  13.624  1.00 10.26      A    C  
ATOM    211  OE1 GLU    34      14.447  44.153  14.296  1.00 10.24      A    O  
ATOM    212  OE2 GLU    34      15.829  42.465  14.149  1.00 11.78      A    O  
ATOM    213  C   GLU    34      18.117  44.334  12.166  1.00  9.66      A    C  
ATOM    214  O   GLU    34      18.593  44.042  11.074  1.00  9.88      A    O  
ATOM    215  N   ALA    35      18.485  43.738  13.296  1.00 10.29      A    N  
ATOM    216  CA  ALA    35      19.537  42.707  13.337  1.00 11.68      A    C  
ATOM    217  CB  ALA    35      19.993  42.478  14.780  1.00 10.93      A    C  
ATOM    218  C   ALA    35      19.102  41.395  12.694  1.00 12.64      A    C  
ATOM    219  O   ALA    35      19.916  40.686  12.076  1.00 12.39      A    O  
ATOM    220  N   ALA    36      17.819  41.066  12.838  1.00 13.65      A    N  
ATOM    221  CA  ALA    36      17.259  39.828  12.264  1.00 15.76      A    C  
ATOM    222  CB  ALA    36      15.907  39.496  12.917  1.00 15.54      A    C  
ATOM    223  C   ALA    36      17.099  39.912  10.748  1.00 17.64      A    C  
ATOM    224  O   ALA    36      17.257  40.973  10.168  1.00 16.16      A    O  
ATOM    225  N   GLU    37      16.740  38.789  10.120  1.00 21.32      A    N  
ATOM    226  CA  GLU    37      16.543  38.737   8.662  1.00 25.10      A    C  
ATOM    227  CB  GLU    37      16.706  37.291   8.155  1.00 25.58      A    C  
ATOM    228  CG  GLU    37      18.139  36.772   8.251  1.00 28.03      A    C  
ATOM    229  CD  GLU    37      19.061  37.370   7.182  1.00 31.75      A    C  
ATOM    230  OE1 GLU    37      18.559  38.078   6.282  1.00 34.60      A    O  
ATOM    231  OE2 GLU    37      20.285  37.133   7.239  1.00 33.38      A    O  
ATOM    232  C   GLU    37      15.234  39.372   8.138  1.00 27.36      A    C  
ATOM    233  O   GLU    37      15.129  39.691   6.946  1.00 27.94      A    O  
ATOM    234  N   GLY    38      14.247  39.567   9.012  1.00 29.61      A    N  
ATOM    235  CA  GLY    38      13.013  40.275   8.631  1.00 32.31      A    C  
ATOM    236  C   GLY    38      12.423  41.152   9.732  1.00 34.12      A    C  
ATOM    237  O   GLY    38      13.052  41.363  10.775  1.00 34.47      A    O  
ATOM    238  N   ILE    39      11.209  41.664   9.516  1.00 35.49      A    N  
ATOM    239  CA  ILE    39      10.524  42.431  10.563  1.00 36.78      A    C  
ATOM    240  CB  ILE    39       9.467  43.442  10.014  1.00 36.73      A    C  
ATOM    241  CG1 ILE    39       8.369  42.722   9.231  1.00 37.04      A    C  
ATOM    242  CD1 ILE    39       7.213  43.626   8.867  1.00 37.54      A    C  
ATOM    243  CG2 ILE    39      10.108  44.550   9.176  1.00 37.15      A    C  
ATOM    244  C   ILE    39       9.801  41.492  11.518  1.00 37.50      A    C  
ATOM    245  O   ILE    39       9.383  40.394  11.129  1.00 37.79      A    O  
ATOM    246  N   GLY    40       9.663  41.931  12.769  1.00 38.27      A    N  
ATOM    247  CA  GLY    40       8.746  41.302  13.719  1.00 38.99      A    C  
ATOM    248  C   GLY    40       9.009  39.844  14.042  1.00 39.46      A    C  
ATOM    249  O   GLY    40       8.075  39.071  14.270  1.00 39.75      A    O  
ATOM    250  N   THR    41      10.280  39.465  14.078  1.00 39.76      A    N  
ATOM    251  CA  THR    41      10.646  38.101  14.442  1.00 40.02      A    C  
ATOM    252  CB  THR    41      11.921  37.625  13.691  1.00 40.19      A    C  
ATOM    253  OG1 THR    41      13.008  38.527  13.944  1.00 40.65      A    O  
ATOM    254  CG2 THR    41      11.668  37.549  12.190  1.00 40.45      A    C  
ATOM    255  C   THR    41      10.842  37.957  15.957  1.00 39.91      A    C  
ATOM    256  O   THR    41      10.828  36.844  16.491  1.00 40.18      A    O  
ATOM    257  N   GLY    42      11.005  39.086  16.642  1.00 39.45      A    N  
ATOM    258  CA  GLY    42      11.349  39.084  18.060  1.00 39.18      A    C  
ATOM    259  C   GLY    42      10.189  38.908  19.023  1.00 38.90      A    C  
ATOM    260  O   GLY    42       9.378  37.998  18.874  1.00 38.88      A    O  
ATOM    261  N   THR    43      10.113  39.784  20.020  1.00 38.61      A    N  
ATOM    262  CA  THR    43       9.056  39.694  21.025  1.00 38.22      A    C  
ATOM    263  CB  THR    43       9.366  40.552  22.261  1.00 38.49      A    C  
ATOM    264  OG1 THR    43      10.627  40.151  22.808  1.00 38.92      A    O  
ATOM    265  CG2 THR    43       8.276  40.392  23.324  1.00 38.36      A    C  
ATOM    266  C   THR    43       7.712  40.111  20.454  1.00 37.63      A    C  
ATOM    267  O   THR    43       6.685  40.041  21.140  1.00 37.79      A    O  
ATOM    268  N   SER    44       7.730  40.550  19.199  1.00 36.71      A    N  
ATOM    269  CA  SER    44       6.498  40.889  18.488  1.00 35.10      A    C  
ATOM    270  CB  SER    44       6.731  42.056  17.524  1.00 35.16      A    C  
ATOM    271  OG  SER    44       7.150  43.214  18.225  1.00 27.29      A    O  
ATOM    272  C   SER    44       5.930  39.685  17.746  1.00 35.80      A    C  
ATOM    273  O   SER    44       4.904  39.792  17.070  1.00 36.07      A    O  
ATOM    274  N   SER    45       6.594  38.537  17.879  1.00 35.56      A    N  
ATOM    275  CA  SER    45       6.102  37.300  17.270  1.00 35.56      A    C  
ATOM    276  CB  SER    45       7.049  36.835  16.158  1.00 35.80      A    C  
ATOM    277  OG  SER    45       8.348  36.576  16.666  1.00 37.39      A    O  
ATOM    278  C   SER    45       5.905  36.197  18.314  1.00 35.04      A    C  
ATOM    279  O   SER    45       5.666  35.030  17.980  1.00 35.06      A    O  
ATOM    280  N   ARG    46       6.002  36.576  19.585  1.00 34.21      A    N  
ATOM    281  CA  ARG    46       5.930  35.604  20.671  1.00 33.05      A    C  
ATOM    282  CB  ARG    46       7.337  35.261  21.164  1.00 33.02      A    C  
ATOM    283  CG  ARG    46       8.279  34.710  20.077  1.00 33.79      A    C  
ATOM    284  CD  ARG    46       9.714  34.607  20.592  1.00 33.38      A    C  
ATOM    285  NE  ARG    46      10.592  33.854  19.694  1.00 33.18      A    N  
ATOM    286  CZ  ARG    46      10.528  32.538  19.512  1.00 32.21      A    C  
ATOM    287  NH1 ARG    46       9.608  31.816  20.140  1.00 29.99      A    N  
ATOM    288  NH2 ARG    46      11.376  31.945  18.678  1.00 32.48      A    N  
ATOM    289  C   ARG    46       5.062  36.126  21.822  1.00 32.25      A    C  
ATOM    290  O   ARG    46       5.469  36.100  22.979  1.00 31.54      A    O  
ATOM    291  N   ASN    47       3.861  36.601  21.490  1.00 31.32      A    N  
ATOM    292  CA  ASN    47       2.918  37.090  22.497  1.00 29.78      A    C  
ATOM    293  CB  ASN    47       2.924  38.641  22.557  1.00 30.79      A    C  
ATOM    294  CG  ASN    47       2.389  39.297  21.283  1.00 32.17      A    C  
ATOM    295  OD1 ASN    47       3.152  39.631  20.366  1.00 36.00      A    O  
ATOM    296  ND2 ASN    47       1.077  39.465  21.213  1.00 33.08      A    N  
ATOM    297  C   ASN    47       1.509  36.517  22.264  1.00 28.90      A    C  
ATOM    298  O   ASN    47       1.308  35.725  21.326  1.00 28.04      A    O  
ATOM    299  N   SER    48       0.549  36.905  23.115  1.00 27.12      A    N  
ATOM    300  CA  SER    48      -0.833  36.384  23.042  1.00 25.17      A    C  
ATOM    301  CB  SER    48      -1.567  36.576  24.377  1.00 25.29      A    C  
ATOM    302  OG  SER    48      -0.702  36.976  25.409  1.00 24.10      A    O  
ATOM    303  C   SER    48      -1.642  37.094  21.956  1.00 23.84      A    C  
ATOM    304  O   SER    48      -2.697  36.612  21.513  1.00 24.97      A    O  
ATOM    305  N   GLU    49      -1.155  38.258  21.547  1.00 20.63      A    N  
ATOM    306  CA  GLU    49      -1.794  39.025  20.517  1.00 16.82      A    C  
ATOM    307  CB  GLU    49      -2.003  38.175  19.271  1.00 16.62      A    C  
ATOM    308  CG  GLU    49      -0.705  37.888  18.511  1.00 22.04      A    C  
ATOM    309  CD  GLU    49      -0.908  36.953  17.316  1.00 26.81      A    C  
ATOM    310  OE1 GLU    49      -1.726  36.017  17.441  1.00 28.52      A    O  
ATOM    311  OE2 GLU    49      -0.254  37.164  16.263  1.00 27.42      A    O  
ATOM    312  C   GLU    49      -3.114  39.565  21.036  1.00 13.38      A    C  
ATOM    313  O   GLU    49      -4.050  39.731  20.274  1.00 12.75      A    O  
ATOM    314  N   VAL    50      -3.167  39.840  22.335  1.00 10.42      A    N  
ATOM    315  CA  VAL    50      -4.378  40.409  22.941  1.00  8.31      A    C  
ATOM    316  CB  VAL    50      -4.558  39.926  24.400  1.00  8.28      A    C  
ATOM    317  CG1 VAL    50      -5.753  40.589  25.055  1.00  8.43      A    C  
ATOM    318  CG2 VAL    50      -4.737  38.411  24.448  1.00  7.04      A    C  
ATOM    319  C   VAL    50      -4.383  41.937  22.890  1.00  8.10      A    C  
ATOM    320  O   VAL    50      -3.400  42.596  23.240  1.00  7.33      A    O  
ATOM    321  N   ILE    51      -5.504  42.502  22.439  1.00  7.64      A    N  
ATOM    322  CA  ILE    51      -5.712  43.948  22.519  1.00  6.60      A    C  
ATOM    323  CB  ILE    51      -6.682  44.451  21.428  1.00  7.25      A    C  
ATOM    324  CG1 ILE    51      -6.131  44.141  20.020  1.00  6.76      A    C  
ATOM    325  CD1 ILE    51      -7.089  44.499  18.857  1.00 10.48      A    C  
ATOM    326  CG2 ILE    51      -6.880  45.976  21.583  1.00  6.93      A    C  
ATOM    327  C   ILE    51      -6.311  44.196  23.907  1.00  7.08      A    C  
ATOM    328  O   ILE    51      -7.489  43.905  24.157  1.00  7.14      A    O  
ATOM    329  N   HIS    52      -5.487  44.704  24.817  1.00  6.56      A    N  
ATOM    330  CA  HIS    52      -5.903  44.856  26.214  1.00  7.08      A    C  
ATOM    331  CB  HIS    52      -4.669  44.922  27.115  1.00  7.43      A    C  
ATOM    332  CG  HIS    52      -4.032  43.589  27.330  1.00  7.92      A    C  
ATOM    333  ND1 HIS    52      -4.608  42.624  28.125  1.00  9.54      A    N  
ATOM    334  CE1 HIS    52      -3.831  41.553  28.146  1.00  9.18      A    C  
ATOM    335  NE2 HIS    52      -2.778  41.786  27.379  1.00  7.63      A    N  
ATOM    336  CD2 HIS    52      -2.876  43.056  26.863  1.00 10.24      A    C  
ATOM    337  C   HIS    52      -6.789  46.076  26.439  1.00  7.45      A    C  
ATOM    338  O   HIS    52      -6.610  47.118  25.810  1.00  8.19      A    O  
ATOM    339  N   ALA    53      -7.735  45.928  27.364  1.00  7.73      A    N  
ATOM    340  CA  ALA    53      -8.663  47.015  27.686  1.00  7.27      A    C  
ATOM    341  CB  ALA    53      -9.899  46.476  28.408  1.00  7.32      A    C  
ATOM    342  C   ALA    53      -8.033  48.173  28.476  1.00  7.41      A    C  
ATOM    343  O   ALA    53      -8.426  49.313  28.268  1.00  7.13      A    O  
ATOM    344  N   GLY    54      -7.075  47.876  29.361  1.00  7.59      A    N  
ATOM    345  CA  GLY    54      -6.435  48.884  30.232  1.00  7.25      A    C  
ATOM    346  C   GLY    54      -6.926  48.780  31.676  1.00  7.60      A    C  
ATOM    347  O   GLY    54      -7.012  49.777  32.400  1.00  7.73      A    O  
ATOM    348  N   ILE    55      -7.203  47.555  32.105  1.00  7.33      A    N  
ATOM    349  CA  ILE    55      -7.931  47.305  33.337  1.00  8.04      A    C  
ATOM    350  CB  ILE    55      -8.519  45.865  33.313  1.00  7.29      A    C  
ATOM    351  CG1 ILE    55      -9.633  45.786  32.256  1.00  7.56      A    C  
ATOM    352  CD1 ILE    55     -10.121  44.377  31.956  1.00  7.54      A    C  
ATOM    353  CG2 ILE    55      -9.027  45.417  34.712  1.00  7.10      A    C  
ATOM    354  C   ILE    55      -7.106  47.531  34.608  1.00  8.84      A    C  
ATOM    355  O   ILE    55      -7.498  48.309  35.478  1.00 10.00      A    O  
ATOM    356  N   TYR    56      -5.962  46.861  34.741  1.00  8.60      A    N  
ATOM    357  CA  TYR    56      -5.373  46.812  36.077  1.00  9.77      A    C  
ATOM    358  CB  TYR    56      -5.237  45.357  36.541  1.00 10.58      A    C  
ATOM    359  CG  TYR    56      -5.254  45.189  38.057  1.00 11.81      A    C  
ATOM    360  CD1 TYR    56      -6.344  45.630  38.814  1.00 14.23      A    C  
ATOM    361  CE1 TYR    56      -6.365  45.504  40.192  1.00 14.92      A    C  
ATOM    362  CZ  TYR    56      -5.289  44.904  40.837  1.00 16.04      A    C  
ATOM    363  OH  TYR    56      -5.311  44.764  42.206  1.00 17.65      A    O  
ATOM    364  CE2 TYR    56      -4.201  44.442  40.110  1.00 15.78      A    C  
ATOM    365  CD2 TYR    56      -4.188  44.589  38.721  1.00 15.35      A    C  
ATOM    366  C   TYR    56      -4.061  47.572  36.277  1.00  8.88      A    C  
ATOM    367  O   TYR    56      -3.445  47.492  37.345  1.00  9.87      A    O  
ATOM    368  N   TYR    57      -3.624  48.308  35.266  1.00  8.78      A    N  
ATOM    369  CA  TYR    57      -2.401  49.107  35.405  1.00  8.91      A    C  
ATOM    370  CB  TYR    57      -1.951  49.615  34.030  1.00  8.86      A    C  
ATOM    371  CG  TYR    57      -2.024  48.506  32.997  1.00  8.56      A    C  
ATOM    372  CD1 TYR    57      -1.156  47.419  33.063  1.00  9.52      A    C  
ATOM    373  CE1 TYR    57      -1.227  46.398  32.155  1.00 10.07      A    C  
ATOM    374  CZ  TYR    57      -2.189  46.421  31.165  1.00 11.26      A    C  
ATOM    375  OH  TYR    57      -2.252  45.384  30.268  1.00 11.50      A    O  
ATOM    376  CE2 TYR    57      -3.067  47.473  31.072  1.00  9.78      A    C  
ATOM    377  CD2 TYR    57      -2.993  48.509  32.010  1.00  8.62      A    C  
ATOM    378  C   TYR    57      -2.623  50.258  36.385  1.00  9.94      A    C  
ATOM    379  O   TYR    57      -3.727  50.794  36.484  1.00 10.15      A    O  
ATOM    380  N   PRO    58      -1.570  50.640  37.121  1.00 10.87      A    N  
ATOM    381  CA  PRO    58      -1.763  51.662  38.139  1.00 11.03      A    C  
ATOM    382  CB  PRO    58      -0.398  51.719  38.847  1.00 11.42      A    C  
ATOM    383  CG  PRO    58       0.265  50.391  38.549  1.00 12.06      A    C  
ATOM    384  CD  PRO    58      -0.230  50.027  37.174  1.00 10.77      A    C  
ATOM    385  C   PRO    58      -2.124  53.026  37.526  1.00 11.15      A    C  
ATOM    386  O   PRO    58      -1.664  53.374  36.433  1.00 11.25      A    O  
ATOM    387  N   ALA    59      -2.940  53.791  38.235  1.00 11.77      A    N  
ATOM    388  CA  ALA    59      -3.418  55.068  37.707  1.00 11.98      A    C  
ATOM    389  CB  ALA    59      -4.204  55.826  38.771  1.00 11.82      A    C  
ATOM    390  C   ALA    59      -2.287  55.950  37.162  1.00 12.46      A    C  
ATOM    391  O   ALA    59      -1.243  56.110  37.801  1.00 12.86      A    O  
ATOM    392  N   ASP    60      -2.518  56.508  35.975  1.00 12.85      A    N  
ATOM    393  CA  ASP    60      -1.603  57.462  35.342  1.00 13.80      A    C  
ATOM    394  CB  ASP    60      -1.455  58.719  36.198  1.00 14.86      A    C  
ATOM    395  CG  ASP    60      -2.760  59.484  36.335  1.00 18.07      A    C  
ATOM    396  OD1 ASP    60      -3.581  59.464  35.387  1.00 20.90      A    O  
ATOM    397  OD2 ASP    60      -2.964  60.121  37.398  1.00 23.61      A    O  
ATOM    398  C   ASP    60      -0.225  56.918  34.959  1.00 13.27      A    C  
ATOM    399  O   ASP    60       0.628  57.689  34.488  1.00 13.16      A    O  
ATOM    400  N   SER    61      -0.012  55.611  35.146  1.00 12.05      A    N  
ATOM    401  CA  SER    61       1.183  54.962  34.605  1.00 10.82      A    C  
ATOM    402  CB  SER    61       1.258  53.491  35.044  1.00 11.12      A    C  
ATOM    403  OG  SER    61       0.143  52.726  34.564  1.00  8.94      A    O  
ATOM    404  C   SER    61       1.191  55.059  33.087  1.00 10.60      A    C  
ATOM    405  O   SER    61       0.143  55.250  32.457  1.00  9.42      A    O  
ATOM    406  N   LEU    62       2.368  54.912  32.480  1.00  9.61      A    N  
ATOM    407  CA  LEU    62       2.418  54.839  31.024  1.00  9.93      A    C  
ATOM    408  CB  LEU    62       3.853  54.802  30.503  1.00 10.55      A    C  
ATOM    409  CG  LEU    62       4.588  56.137  30.557  1.00 11.66      A    C  
ATOM    410  CD1 LEU    62       5.974  55.960  29.987  1.00 11.95      A    C  
ATOM    411  CD2 LEU    62       3.797  57.185  29.753  1.00 12.15      A    C  
ATOM    412  C   LEU    62       1.660  53.623  30.529  1.00  9.43      A    C  
ATOM    413  O   LEU    62       0.955  53.709  29.526  1.00  8.87      A    O  
ATOM    414  N   LYS    63       1.788  52.494  31.226  1.00  8.82      A    N  
ATOM    415  CA  LYS    63       1.018  51.327  30.853  1.00  8.38      A    C  
ATOM    416  CB  LYS    63       1.293  50.141  31.792  1.00  8.35      A    C  
ATOM    417  CG  LYS    63       2.664  49.466  31.545  1.00  8.97      A    C  
ATOM    418  CD  LYS    63       2.842  48.265  32.505  1.00 11.67      A    C  
ATOM    419  CE  LYS    63       4.199  47.588  32.325  1.00 15.61      A    C  
ATOM    420  NZ  LYS    63       4.418  47.274  30.925  1.00 22.22      A    N  
ATOM    421  C   LYS    63      -0.475  51.667  30.827  1.00  7.93      A    C  
ATOM    422  O   LYS    63      -1.169  51.331  29.887  1.00  7.25      A    O  
ATOM    423  N   ALA    64      -0.977  52.337  31.856  1.00  8.01      A    N  
ATOM    424  CA  ALA    64      -2.415  52.628  31.866  1.00  7.83      A    C  
ATOM    425  CB  ALA    64      -2.823  53.189  33.204  1.00  7.78      A    C  
ATOM    426  C   ALA    64      -2.786  53.594  30.729  1.00  8.03      A    C  
ATOM    427  O   ALA    64      -3.722  53.360  29.968  1.00  7.77      A    O  
ATOM    428  N   ARG    65      -2.067  54.701  30.642  1.00  7.68      A    N  
ATOM    429  CA  ARG    65      -2.438  55.763  29.712  1.00  8.18      A    C  
ATOM    430  CB  ARG    65      -1.611  57.009  29.993  1.00  8.94      A    C  
ATOM    431  CG  ARG    65      -1.873  58.120  29.013  1.00 11.92      A    C  
ATOM    432  CD  ARG    65      -1.428  59.454  29.582  1.00 17.28      A    C  
ATOM    433  NE  ARG    65       0.007  59.690  29.473  1.00 21.96      A    N  
ATOM    434  CZ  ARG    65       0.886  59.562  30.457  1.00 25.98      A    C  
ATOM    435  NH1 ARG    65       0.505  59.150  31.664  1.00 28.44      A    N  
ATOM    436  NH2 ARG    65       2.167  59.836  30.219  1.00 28.46      A    N  
ATOM    437  C   ARG    65      -2.286  55.331  28.260  1.00  7.67      A    C  
ATOM    438  O   ARG    65      -3.163  55.560  27.420  1.00  7.78      A    O  
ATOM    439  N   LEU    66      -1.157  54.696  27.969  1.00  7.04      A    N  
ATOM    440  CA  LEU    66      -0.856  54.285  26.610  1.00  6.40      A    C  
ATOM    441  CB  LEU    66       0.653  54.100  26.422  1.00  6.40      A    C  
ATOM    442  CG  LEU    66       1.497  55.346  26.757  1.00  6.64      A    C  
ATOM    443  CD1 LEU    66       2.959  55.113  26.363  1.00  8.12      A    C  
ATOM    444  CD2 LEU    66       0.965  56.618  26.099  1.00  8.63      A    C  
ATOM    445  C   LEU    66      -1.626  53.032  26.210  1.00  6.58      A    C  
ATOM    446  O   LEU    66      -1.909  52.843  25.034  1.00  6.70      A    O  
ATOM    447  N   CYS    67      -1.986  52.178  27.169  1.00  6.22      A    N  
ATOM    448  CA  CYS    67      -2.799  51.021  26.801  1.00  6.53      A    C  
ATOM    449  CB  CYS    67      -2.938  50.019  27.953  1.00  6.79      A    C  
ATOM    450  SG  CYS    67      -3.829  48.505  27.463  1.00  7.60      A    S  
ATOM    451  C   CYS    67      -4.172  51.491  26.335  1.00  7.50      A    C  
ATOM    452  O   CYS    67      -4.685  51.016  25.323  1.00  6.74      A    O  
ATOM    453  N   VAL    68      -4.757  52.444  27.056  1.00  8.07      A    N  
ATOM    454  CA  VAL    68      -6.140  52.835  26.752  1.00  9.14      A    C  
ATOM    455  CB  VAL    68      -6.800  53.558  27.944  1.00  9.33      A    C  
ATOM    456  CG1 VAL    68      -8.160  54.155  27.542  1.00 11.40      A    C  
ATOM    457  CG2 VAL    68      -6.967  52.597  29.137  1.00  9.68      A    C  
ATOM    458  C   VAL    68      -6.174  53.673  25.474  1.00  9.38      A    C  
ATOM    459  O   VAL    68      -6.969  53.417  24.555  1.00  9.98      A    O  
ATOM    460  N   ARG    69      -5.298  54.655  25.390  1.00  9.31      A    N  
ATOM    461  CA  ARG    69      -5.156  55.434  24.158  1.00  9.28      A    C  
ATOM    462  CB  ARG    69      -4.072  56.484  24.362  1.00  9.91      A    C  
ATOM    463  CG  ARG    69      -3.657  57.204  23.105  1.00 13.50      A    C  
ATOM    464  CD  ARG    69      -4.612  58.275  22.754  1.00 16.88      A    C  
ATOM    465  NE  ARG    69      -4.147  59.054  21.603  1.00 17.05      A    N  
ATOM    466  CZ  ARG    69      -4.958  59.788  20.852  1.00 19.86      A    C  
ATOM    467  NH1 ARG    69      -6.254  59.846  21.154  1.00 20.22      A    N  
ATOM    468  NH2 ARG    69      -4.482  60.465  19.804  1.00 17.58      A    N  
ATOM    469  C   ARG    69      -4.792  54.536  22.970  1.00  8.86      A    C  
ATOM    470  O   ARG    69      -5.351  54.656  21.882  1.00  8.88      A    O  
ATOM    471  N   GLY    70      -3.825  53.644  23.185  1.00  6.96      A    N  
ATOM    472  CA  GLY    70      -3.346  52.752  22.137  1.00  6.63      A    C  
ATOM    473  C   GLY    70      -4.444  51.845  21.631  1.00  6.86      A    C  
ATOM    474  O   GLY    70      -4.516  51.578  20.426  1.00  6.60      A    O  
ATOM    475  N   LYS    71      -5.287  51.355  22.550  1.00  6.80      A    N  
ATOM    476  CA  LYS    71      -6.410  50.489  22.187  1.00  7.04      A    C  
ATOM    477  CB  LYS    71      -7.204  50.086  23.441  1.00  7.45      A    C  
ATOM    478  CG  LYS    71      -8.485  49.291  23.146  1.00  8.10      A    C  
ATOM    479  CD  LYS    71      -9.225  48.959  24.463  1.00  9.88      A    C  
ATOM    480  CE  LYS    71      -9.950  50.190  25.052  1.00 10.93      A    C  
ATOM    481  NZ  LYS    71     -10.581  49.920  26.392  1.00 10.98      A    N  
ATOM    482  C   LYS    71      -7.337  51.212  21.221  1.00  7.19      A    C  
ATOM    483  O   LYS    71      -7.713  50.679  20.193  1.00  7.76      A    O  
ATOM    484  N   HIS    72      -7.697  52.436  21.561  1.00  7.71      A    N  
ATOM    485  CA  HIS    72      -8.559  53.212  20.675  1.00  8.31      A    C  
ATOM    486  CB  HIS    72      -8.929  54.525  21.356  1.00  9.02      A    C  
ATOM    487  CG  HIS    72      -9.755  54.321  22.590  1.00 11.38      A    C  
ATOM    488  ND1 HIS    72     -10.778  53.395  22.649  1.00 15.33      A    N  
ATOM    489  CE1 HIS    72     -11.328  53.430  23.849  1.00 15.31      A    C  
ATOM    490  NE2 HIS    72     -10.690  54.336  24.573  1.00 16.23      A    N  
ATOM    491  CD2 HIS    72      -9.711  54.914  23.805  1.00 14.76      A    C  
ATOM    492  C   HIS    72      -7.909  53.442  19.307  1.00  7.82      A    C  
ATOM    493  O   HIS    72      -8.525  53.210  18.269  1.00  8.41      A    O  
ATOM    494  N   LEU    73      -6.662  53.880  19.303  1.00  8.35      A    N  
ATOM    495  CA  LEU    73      -5.962  54.085  18.038  1.00  8.19      A    C  
ATOM    496  CB  LEU    73      -4.558  54.631  18.286  1.00  8.54      A    C  
ATOM    497  CG  LEU    73      -4.514  56.027  18.872  1.00  9.09      A    C  
ATOM    498  CD1 LEU    73      -3.078  56.401  19.189  1.00  9.03      A    C  
ATOM    499  CD2 LEU    73      -5.127  57.016  17.846  1.00 12.63      A    C  
ATOM    500  C   LEU    73      -5.873  52.797  17.231  1.00  8.07      A    C  
ATOM    501  O   LEU    73      -6.002  52.823  16.005  1.00  8.49      A    O  
ATOM    502  N   LEU    74      -5.630  51.673  17.912  1.00  7.61      A    N  
ATOM    503  CA  LEU    74      -5.379  50.408  17.221  1.00  7.20      A    C  
ATOM    504  CB  LEU    74      -4.742  49.391  18.193  1.00  7.34      A    C  
ATOM    505  CG  LEU    74      -4.428  48.008  17.635  1.00  7.42      A    C  
ATOM    506  CD1 LEU    74      -3.462  48.134  16.483  1.00  8.05      A    C  
ATOM    507  CD2 LEU    74      -3.859  47.098  18.756  1.00  7.72      A    C  
ATOM    508  C   LEU    74      -6.677  49.840  16.622  1.00  7.35      A    C  
ATOM    509  O   LEU    74      -6.686  49.339  15.503  1.00  7.49      A    O  
ATOM    510  N   TYR    75      -7.785  49.914  17.360  1.00  7.06      A    N  
ATOM    511  CA  TYR    75      -9.043  49.410  16.805  1.00  7.41      A    C  
ATOM    512  CB  TYR    75     -10.165  49.489  17.844  1.00  7.37      A    C  
ATOM    513  CG  TYR    75     -10.304  48.244  18.673  1.00  7.53      A    C  
ATOM    514  CD1 TYR    75     -10.485  47.002  18.068  1.00  8.31      A    C  
ATOM    515  CE1 TYR    75     -10.617  45.851  18.832  1.00  8.00      A    C  
ATOM    516  CZ  TYR    75     -10.585  45.945  20.213  1.00  7.54      A    C  
ATOM    517  OH  TYR    75     -10.723  44.817  20.970  1.00  9.44      A    O  
ATOM    518  CE2 TYR    75     -10.406  47.172  20.830  1.00  6.93      A    C  
ATOM    519  CD2 TYR    75     -10.262  48.302  20.059  1.00  6.95      A    C  
ATOM    520  C   TYR    75      -9.418  50.220  15.567  1.00  7.93      A    C  
ATOM    521  O   TYR    75      -9.854  49.670  14.558  1.00  8.51      A    O  
ATOM    522  N   GLU    76      -9.219  51.529  15.648  1.00  8.56      A    N  
ATOM    523  CA  GLU    76      -9.482  52.387  14.496  1.00  9.57      A    C  
ATOM    524  CB  GLU    76      -9.352  53.849  14.892  1.00 10.16      A    C  
ATOM    525  CG  GLU    76      -9.505  54.835  13.749  1.00 11.30      A    C  
ATOM    526  CD  GLU    76      -9.489  56.253  14.271  1.00 14.87      A    C  
ATOM    527  OE1 GLU    76      -8.435  56.654  14.801  1.00 17.31      A    O  
ATOM    528  OE2 GLU    76     -10.522  56.955  14.177  1.00 14.89      A    O  
ATOM    529  C   GLU    76      -8.549  52.039  13.324  1.00  9.62      A    C  
ATOM    530  O   GLU    76      -8.989  51.897  12.185  1.00  9.61      A    O  
ATOM    531  N   TYR    77      -7.254  51.884  13.622  1.00  9.34      A    N  
ATOM    532  CA  TYR    77      -6.245  51.540  12.617  1.00  9.97      A    C  
ATOM    533  CB  TYR    77      -4.843  51.445  13.269  1.00  9.16      A    C  
ATOM    534  CG  TYR    77      -3.741  51.179  12.267  1.00  9.29      A    C  
ATOM    535  CD1 TYR    77      -3.079  52.228  11.645  1.00 12.12      A    C  
ATOM    536  CE1 TYR    77      -2.077  51.991  10.716  1.00 12.93      A    C  
ATOM    537  CZ  TYR    77      -1.740  50.692  10.413  1.00 12.43      A    C  
ATOM    538  OH  TYR    77      -0.748  50.415   9.491  1.00 13.90      A    O  
ATOM    539  CE2 TYR    77      -2.390  49.645  11.012  1.00 12.32      A    C  
ATOM    540  CD2 TYR    77      -3.382  49.893  11.940  1.00 11.30      A    C  
ATOM    541  C   TYR    77      -6.588  50.227  11.932  1.00 10.77      A    C  
ATOM    542  O   TYR    77      -6.526  50.118  10.713  1.00 11.12      A    O  
ATOM    543  N   CYS    78      -6.971  49.224  12.714  1.00 11.11      A    N  
ATOM    544  CA  CYS    78      -7.256  47.917  12.148  1.00 12.12      A    C  
ATOM    545  CB  CYS    78      -7.457  46.883  13.238  1.00 12.01      A    C  
ATOM    546  SG  CYS    78      -5.887  46.440  14.033  1.00 12.83      A    S  
ATOM    547  C   CYS    78      -8.461  47.969  11.218  1.00 12.71      A    C  
ATOM    548  O   CYS    78      -8.450  47.364  10.154  1.00 13.65      A    O  
ATOM    549  N   ALA    79      -9.493  48.696  11.619  1.00 13.19      A    N  
ATOM    550  CA  ALA    79     -10.673  48.839  10.770  1.00 14.27      A    C  
ATOM    551  CB  ALA    79     -11.831  49.481  11.538  1.00 14.37      A    C  
ATOM    552  C   ALA    79     -10.336  49.651   9.517  1.00 14.88      A    C  
ATOM    553  O   ALA    79     -10.793  49.332   8.413  1.00 16.04      A    O  
ATOM    554  N   ALA    80      -9.535  50.694   9.683  1.00 15.58      A    N  
ATOM    555  CA  ALA    80      -9.218  51.596   8.580  1.00 16.51      A    C  
ATOM    556  CB  ALA    80      -8.522  52.842   9.096  1.00 16.50      A    C  
ATOM    557  C   ALA    80      -8.359  50.908   7.528  1.00 17.40      A    C  
ATOM    558  O   ALA    80      -8.511  51.158   6.324  1.00 17.37      A    O  
ATOM    559  N   ARG    81      -7.473  50.019   7.978  1.00 17.86      A    N  
ATOM    560  CA  ARG    81      -6.459  49.440   7.105  1.00 18.60      A    C  
ATOM    561  CB  ARG    81      -5.071  49.521   7.750  1.00 18.91      A    C  
ATOM    562  CG  ARG    81      -4.677  50.897   8.239  1.00 21.65      A    C  
ATOM    563  CD  ARG    81      -4.958  51.991   7.242  1.00 28.32      A    C  
ATOM    564  NE  ARG    81      -4.214  53.181   7.637  1.00 31.43      A    N  
ATOM    565  CZ  ARG    81      -2.958  53.413   7.270  1.00 32.72      A    C  
ATOM    566  NH1 ARG    81      -2.340  52.543   6.478  1.00 34.15      A    N  
ATOM    567  NH2 ARG    81      -2.329  54.509   7.685  1.00 32.17      A    N  
ATOM    568  C   ARG    81      -6.736  47.997   6.758  1.00 18.28      A    C  
ATOM    569  O   ARG    81      -6.026  47.422   5.933  1.00 19.97      A    O  
ATOM    570  N   GLY    82      -7.733  47.391   7.401  1.00 16.96      A    N  
ATOM    571  CA  GLY    82      -8.090  46.009   7.102  1.00 15.99      A    C  
ATOM    572  C   GLY    82      -7.157  44.976   7.705  1.00 15.51      A    C  
ATOM    573  O   GLY    82      -6.957  43.901   7.128  1.00 15.97      A    O  
ATOM    574  N   VAL    83      -6.578  45.293   8.863  1.00 14.33      A    N  
ATOM    575  CA  VAL    83      -5.756  44.326   9.604  1.00 13.75      A    C  
ATOM    576  CB  VAL    83      -4.874  45.009  10.675  1.00 13.17      A    C  
ATOM    577  CG1 VAL    83      -4.049  43.961  11.402  1.00 12.94      A    C  
ATOM    578  CG2 VAL    83      -3.988  46.093  10.074  1.00 13.13      A    C  
ATOM    579  C   VAL    83      -6.678  43.371  10.340  1.00 13.66      A    C  
ATOM    580  O   VAL    83      -7.575  43.813  11.072  1.00 13.98      A    O  
ATOM    581  N   PRO    84      -6.477  42.061  10.158  1.00 13.63      A    N  
ATOM    582  CA  PRO    84      -7.341  41.084  10.834  1.00 13.76      A    C  
ATOM    583  CB  PRO    84      -6.753  39.730  10.398  1.00 14.02      A    C  
ATOM    584  CG  PRO    84      -6.072  40.025   9.089  1.00 14.50      A    C  
ATOM    585  CD  PRO    84      -5.524  41.421   9.228  1.00 14.23      A    C  
ATOM    586  C   PRO    84      -7.322  41.236  12.372  1.00 13.22      A    C  
ATOM    587  O   PRO    84      -6.259  41.271  13.008  1.00 12.96      A    O  
ATOM    588  N   HIS    85      -8.508  41.339  12.953  1.00 12.91      A    N  
ATOM    589  CA  HIS    85      -8.643  41.461  14.404  1.00 12.37      A    C  
ATOM    590  CB  HIS    85      -8.352  42.893  14.842  1.00 12.88      A    C  
ATOM    591  CG  HIS    85      -9.386  43.869  14.385  1.00 13.86      A    C  
ATOM    592  ND1 HIS    85      -9.571  44.175  13.056  1.00 13.97      A    N  
ATOM    593  CE1 HIS    85     -10.551  45.056  12.943  1.00 15.14      A    C  
ATOM    594  NE2 HIS    85     -11.020  45.317  14.151  1.00 14.84      A    N  
ATOM    595  CD2 HIS    85     -10.309  44.585  15.073  1.00 14.88      A    C  
ATOM    596  C   HIS    85     -10.068  41.123  14.780  1.00 12.31      A    C  
ATOM    597  O   HIS    85     -10.965  41.143  13.926  1.00 13.00      A    O  
ATOM    598  N   GLN    86     -10.291  40.837  16.058  1.00 11.53      A    N  
ATOM    599  CA  GLN    86     -11.628  40.510  16.564  1.00 11.67      A    C  
ATOM    600  CB  GLN    86     -11.820  38.994  16.655  1.00 11.93      A    C  
ATOM    601  CG  GLN    86     -11.932  38.285  15.303  1.00 13.88      A    C  
ATOM    602  CD  GLN    86     -11.704  36.774  15.374  1.00 17.56      A    C  
ATOM    603  OE1 GLN    86     -11.899  36.136  16.414  1.00 17.76      A    O  
ATOM    604  NE2 GLN    86     -11.292  36.193  14.239  1.00 19.92      A    N  
ATOM    605  C   GLN    86     -11.823  41.102  17.946  1.00 11.71      A    C  
ATOM    606  O   GLN    86     -11.004  40.885  18.844  1.00 11.32      A    O  
ATOM    607  N   ARG    87     -12.933  41.809  18.136  1.00 11.69      A    N  
ATOM    608  CA  ARG    87     -13.265  42.348  19.462  1.00 11.99      A    C  
ATOM    609  CB  ARG    87     -14.031  43.668  19.309  1.00 12.89      A    C  
ATOM    610  CG  ARG    87     -14.273  44.445  20.605  1.00 14.41      A    C  
ATOM    611  CD  ARG    87     -15.091  45.710  20.314  1.00 20.91      A    C  
ATOM    612  NE  ARG    87     -14.431  46.515  19.294  1.00 25.76      A    N  
ATOM    613  CZ  ARG    87     -14.793  46.590  18.015  1.00 26.20      A    C  
ATOM    614  NH1 ARG    87     -15.862  45.927  17.562  1.00 27.13      A    N  
ATOM    615  NH2 ARG    87     -14.078  47.337  17.184  1.00 25.93      A    N  
ATOM    616  C   ARG    87     -14.096  41.313  20.202  1.00 12.26      A    C  
ATOM    617  O   ARG    87     -15.322  41.471  20.361  1.00 12.43      A    O  
ATOM    618  N   LEU    88     -13.453  40.236  20.648  1.00 10.62      A    N  
ATOM    619  CA  LEU    88     -14.241  39.100  21.116  1.00 11.30      A    C  
ATOM    620  CB  LEU    88     -13.617  37.759  20.741  1.00 12.92      A    C  
ATOM    621  CG  LEU    88     -12.107  37.634  20.707  1.00 16.29      A    C  
ATOM    622  CD1 LEU    88     -11.483  38.125  21.990  1.00 18.49      A    C  
ATOM    623  CD2 LEU    88     -11.729  36.191  20.433  1.00 18.42      A    C  
ATOM    624  C   LEU    88     -14.594  39.127  22.586  1.00  9.68      A    C  
ATOM    625  O   LEU    88     -15.452  38.364  23.027  1.00  9.63      A    O  
ATOM    626  N   GLY    89     -13.950  40.009  23.345  1.00  8.23      A    N  
ATOM    627  CA  GLY    89     -14.279  40.148  24.753  1.00  8.07      A    C  
ATOM    628  C   GLY    89     -13.477  39.183  25.614  1.00  7.92      A    C  
ATOM    629  O   GLY    89     -12.870  38.230  25.114  1.00  7.11      A    O  
ATOM    630  N   LYS    90     -13.508  39.426  26.918  1.00  7.81      A    N  
ATOM    631  CA  LYS    90     -12.735  38.656  27.887  1.00  7.49      A    C  
ATOM    632  CB  LYS    90     -11.427  39.394  28.131  1.00  7.84      A    C  
ATOM    633  CG  LYS    90     -10.691  39.060  29.412  1.00  9.00      A    C  
ATOM    634  CD  LYS    90      -9.432  39.914  29.414  1.00 13.02      A    C  
ATOM    635  CE  LYS    90      -8.967  40.280  30.789  1.00 16.81      A    C  
ATOM    636  NZ  LYS    90      -7.546  40.741  30.725  1.00 15.31      A    N  
ATOM    637  C   LYS    90     -13.507  38.559  29.184  1.00  7.93      A    C  
ATOM    638  O   LYS    90     -14.272  39.470  29.515  1.00  7.95      A    O  
ATOM    639  N   LEU    91     -13.337  37.448  29.903  1.00  7.09      A    N  
ATOM    640  CA  LEU    91     -13.840  37.326  31.272  1.00  7.34      A    C  
ATOM    641  CB  LEU    91     -14.664  36.055  31.441  1.00  8.01      A    C  
ATOM    642  CG  LEU    91     -15.830  35.856  30.473  1.00 12.27      A    C  
ATOM    643  CD1 LEU    91     -16.554  34.549  30.737  1.00 15.66      A    C  
ATOM    644  CD2 LEU    91     -16.777  37.000  30.617  1.00 14.57      A    C  
ATOM    645  C   LEU    91     -12.650  37.235  32.212  1.00  7.37      A    C  
ATOM    646  O   LEU    91     -11.741  36.422  31.976  1.00  6.40      A    O  
ATOM    647  N   ILE    92     -12.639  38.075  33.247  1.00  6.71      A    N  
ATOM    648  CA  ILE    92     -11.746  37.875  34.380  1.00  7.10      A    C  
ATOM    649  CB  ILE    92     -11.371  39.195  35.053  1.00  6.40      A    C  
ATOM    650  CG1 ILE    92     -10.573  40.055  34.080  1.00  8.68      A    C  
ATOM    651  CD1 ILE    92     -10.285  41.480  34.618  1.00  8.17      A    C  
ATOM    652  CG2 ILE    92     -10.529  38.921  36.285  1.00  8.16      A    C  
ATOM    653  C   ILE    92     -12.543  37.035  35.353  1.00  7.55      A    C  
ATOM    654  O   ILE    92     -13.602  37.474  35.808  1.00  7.25      A    O  
ATOM    655  N   VAL    93     -12.060  35.828  35.642  1.00  6.72      A    N  
ATOM    656  CA  VAL    93     -12.872  34.870  36.404  1.00  7.87      A    C  
ATOM    657  CB  VAL    93     -13.009  33.514  35.645  1.00  7.58      A    C  
ATOM    658  CG1 VAL    93     -13.709  33.730  34.311  1.00  8.64      A    C  
ATOM    659  CG2 VAL    93     -11.628  32.870  35.444  1.00  7.96      A    C  
ATOM    660  C   VAL    93     -12.333  34.642  37.802  1.00  8.68      A    C  
ATOM    661  O   VAL    93     -11.124  34.456  37.980  1.00  8.93      A    O  
ATOM    662  N   ALA    94     -13.237  34.689  38.788  1.00  8.80      A    N  
ATOM    663  CA  ALA    94     -12.923  34.353  40.179  1.00  9.50      A    C  
ATOM    664  CB  ALA    94     -13.704  35.269  41.152  1.00  9.26      A    C  
ATOM    665  C   ALA    94     -13.302  32.890  40.411  1.00 10.61      A    C  
ATOM    666  O   ALA    94     -14.404  32.470  40.052  1.00 11.06      A    O  
ATOM    667  N   THR    95     -12.400  32.114  41.003  1.00 11.54      A    N  
ATOM    668  CA  THR    95     -12.683  30.697  41.212  1.00 12.50      A    C  
ATOM    669  CB  THR    95     -11.698  29.798  40.436  1.00 12.97      A    C  
ATOM    670  OG1 THR    95     -10.366  30.087  40.852  1.00 13.56      A    O  
ATOM    671  CG2 THR    95     -11.841  30.043  38.944  1.00 14.34      A    C  
ATOM    672  C   THR    95     -12.754  30.313  42.701  1.00 12.82      A    C  
ATOM    673  O   THR    95     -12.652  29.134  43.063  1.00 13.39      A    O  
ATOM    674  N   SER    96     -12.962  31.318  43.548  1.00 12.55      A    N  
ATOM    675  CA  SER    96     -13.217  31.103  44.967  1.00 12.29      A    C  
ATOM    676  CB  SER    96     -11.906  30.932  45.746  1.00 12.43      A    C  
ATOM    677  OG  SER    96     -11.225  32.172  45.884  1.00 10.79      A    O  
ATOM    678  C   SER    96     -13.987  32.317  45.482  1.00 13.35      A    C  
ATOM    679  O   SER    96     -14.070  33.341  44.799  1.00 13.14      A    O  
ATOM    680  N   ASP    97     -14.578  32.201  46.668  1.00 13.76      A    N  
ATOM    681  CA  ASP    97     -15.234  33.357  47.273  1.00 14.33      A    C  
ATOM    682  CB  ASP    97     -15.897  32.977  48.602  1.00 15.48      A    C  
ATOM    683  CG  ASP    97     -17.086  32.073  48.430  1.00 18.72      A    C  
ATOM    684  OD1 ASP    97     -17.653  31.983  47.316  1.00 20.38      A    O  
ATOM    685  OD2 ASP    97     -17.480  31.454  49.447  1.00 22.82      A    O  
ATOM    686  C   ASP    97     -14.245  34.495  47.533  1.00 13.36      A    C  
ATOM    687  O   ASP    97     -14.590  35.664  47.345  1.00 13.75      A    O  
ATOM    688  N   ALA    98     -13.033  34.171  47.982  1.00 12.77      A    N  
ATOM    689  CA  ALA    98     -12.038  35.218  48.256  1.00 12.41      A    C  
ATOM    690  CB  ALA    98     -10.769  34.619  48.857  1.00 13.38      A    C  
ATOM    691  C   ALA    98     -11.716  35.984  46.972  1.00 11.71      A    C  
ATOM    692  O   ALA    98     -11.676  37.212  46.954  1.00 10.94      A    O  
ATOM    693  N   GLU    99     -11.518  35.254  45.877  1.00 11.04      A    N  
ATOM    694  CA  GLU    99     -11.274  35.910  44.589  1.00 10.61      A    C  
ATOM    695  CB  GLU    99     -10.896  34.877  43.532  1.00 10.42      A    C  
ATOM    696  CG  GLU    99      -9.552  34.251  43.837  1.00 10.44      A    C  
ATOM    697  CD  GLU    99      -9.021  33.408  42.695  1.00 11.98      A    C  
ATOM    698  OE1 GLU    99      -9.779  33.116  41.748  1.00 11.82      A    O  
ATOM    699  OE2 GLU    99      -7.832  33.046  42.759  1.00 14.81      A    O  
ATOM    700  C   GLU    99     -12.462  36.727  44.108  1.00 10.14      A    C  
ATOM    701  O   GLU    99     -12.287  37.799  43.506  1.00  9.42      A    O  
ATOM    702  N   ALA   100     -13.669  36.220  44.353  1.00  9.81      A    N  
ATOM    703  CA  ALA   100     -14.864  36.939  43.928  1.00  9.80      A    C  
ATOM    704  CB  ALA   100     -16.112  36.138  44.236  1.00 10.31      A    C  
ATOM    705  C   ALA   100     -14.913  38.301  44.619  1.00  9.95      A    C  
ATOM    706  O   ALA   100     -15.399  39.279  44.038  1.00  9.60      A    O  
ATOM    707  N   SER   101     -14.411  38.347  45.851  1.00  9.51      A    N  
ATOM    708  CA  SER   101     -14.391  39.583  46.635  1.00 10.70      A    C  
ATOM    709  CB  SER   101     -14.057  39.273  48.093  1.00 11.53      A    C  
ATOM    710  OG  SER   101     -15.161  38.608  48.693  1.00 17.43      A    O  
ATOM    711  C   SER   101     -13.428  40.629  46.090  1.00 10.14      A    C  
ATOM    712  O   SER   101     -13.536  41.822  46.439  1.00 10.35      A    O  
ATOM    713  N   GLN   102     -12.500  40.189  45.241  1.00  8.68      A    N  
ATOM    714  CA  GLN   102     -11.491  41.073  44.649  1.00  7.88      A    C  
ATOM    715  CB  GLN   102     -10.244  40.253  44.285  1.00  7.99      A    C  
ATOM    716  CG  GLN   102      -9.545  39.752  45.539  1.00  9.55      A    C  
ATOM    717  CD  GLN   102      -8.329  38.929  45.250  1.00 12.22      A    C  
ATOM    718  OE1 GLN   102      -8.312  38.164  44.297  1.00 11.23      A    O  
ATOM    719  NE2 GLN   102      -7.296  39.067  46.084  1.00 14.05      A    N  
ATOM    720  C   GLN   102     -12.004  41.836  43.439  1.00  7.47      A    C  
ATOM    721  O   GLN   102     -11.404  42.827  43.019  1.00  7.61      A    O  
ATOM    722  N   LEU   103     -13.133  41.379  42.883  1.00  7.16      A    N  
ATOM    723  CA  LEU   103     -13.582  41.909  41.593  1.00  7.26      A    C  
ATOM    724  CB  LEU   103     -14.694  41.030  41.005  1.00  6.51      A    C  
ATOM    725  CG  LEU   103     -14.328  39.589  40.608  1.00  7.86      A    C  
ATOM    726  CD1 LEU   103     -15.549  38.902  39.995  1.00  7.61      A    C  
ATOM    727  CD2 LEU   103     -13.159  39.544  39.646  1.00  8.32      A    C  
ATOM    728  C   LEU   103     -14.023  43.379  41.668  1.00  7.37      A    C  
ATOM    729  O   LEU   103     -13.803  44.160  40.728  1.00  7.45      A    O  
ATOM    730  N   ASP   104     -14.645  43.770  42.775  1.00  8.24      A    N  
ATOM    731  CA  ASP   104     -15.186  45.132  42.828  1.00  8.79      A    C  
ATOM    732  CB  ASP   104     -15.919  45.389  44.137  1.00  9.63      A    C  
ATOM    733  CG  ASP   104     -17.371  44.900  44.122  1.00 13.58      A    C  
ATOM    734  OD1 ASP   104     -17.931  44.588  43.046  1.00 16.04      A    O  
ATOM    735  OD2 ASP   104     -17.967  44.853  45.217  1.00 16.17      A    O  
ATOM    736  C   ASP   104     -14.042  46.140  42.666  1.00  8.10      A    C  
ATOM    737  O   ASP   104     -14.156  47.117  41.920  1.00  8.37      A    O  
ATOM    738  N   SER   105     -12.935  45.909  43.370  1.00  7.66      A    N  
ATOM    739  CA  SER   105     -11.822  46.866  43.350  1.00  7.70      A    C  
ATOM    740  CB  SER   105     -10.786  46.490  44.418  1.00  8.34      A    C  
ATOM    741  OG  SER   105      -9.675  47.379  44.362  1.00 13.63      A    O  
ATOM    742  C   SER   105     -11.162  46.878  41.977  1.00  7.19      A    C  
ATOM    743  O   SER   105     -10.722  47.915  41.467  1.00  7.04      A    O  
ATOM    744  N   ILE   106     -11.082  45.702  41.368  1.00  6.71      A    N  
ATOM    745  CA  ILE   106     -10.522  45.617  40.020  1.00  6.69      A    C  
ATOM    746  CB  ILE   106     -10.476  44.143  39.556  1.00  6.42      A    C  
ATOM    747  CG1 ILE   106      -9.456  43.362  40.384  1.00  6.41      A    C  
ATOM    748  CD1 ILE   106      -9.572  41.854  40.154  1.00  7.76      A    C  
ATOM    749  CG2 ILE   106     -10.096  44.037  38.076  1.00  7.38      A    C  
ATOM    750  C   ILE   106     -11.352  46.464  39.041  1.00  6.80      A    C  
ATOM    751  O   ILE   106     -10.811  47.213  38.229  1.00  7.18      A    O  
ATOM    752  N   ALA   107     -12.677  46.348  39.115  1.00  7.29      A    N  
ATOM    753  CA  ALA   107     -13.541  47.146  38.238  1.00  7.35      A    C  
ATOM    754  CB  ALA   107     -15.003  46.727  38.393  1.00  8.25      A    C  
ATOM    755  C   ALA   107     -13.392  48.646  38.508  1.00  8.04      A    C  
ATOM    756  O   ALA   107     -13.462  49.456  37.579  1.00  7.76      A    O  
ATOM    757  N   ARG   108     -13.203  49.020  39.767  1.00  7.42      A    N  
ATOM    758  CA  ARG   108     -12.992  50.438  40.090  1.00  7.90      A    C  
ATOM    759  CB  ARG   108     -13.087  50.666  41.605  1.00  8.29      A    C  
ATOM    760  CG  ARG   108     -14.499  50.462  42.121  1.00  9.36      A    C  
ATOM    761  CD  ARG   108     -14.615  50.678  43.605  1.00 15.68      A    C  
ATOM    762  NE  ARG   108     -15.910  50.199  44.077  1.00 20.10      A    N  
ATOM    763  CZ  ARG   108     -16.080  49.241  44.985  1.00 22.84      A    C  
ATOM    764  NH1 ARG   108     -15.032  48.639  45.554  1.00 22.97      A    N  
ATOM    765  NH2 ARG   108     -17.309  48.878  45.326  1.00 23.77      A    N  
ATOM    766  C   ARG   108     -11.668  50.945  39.519  1.00  7.91      A    C  
ATOM    767  O   ARG   108     -11.569  52.084  39.044  1.00  9.07      A    O  
ATOM    768  N   ARG   109     -10.638  50.104  39.542  1.00  7.76      A    N  
ATOM    769  CA  ARG   109      -9.363  50.538  38.958  1.00  8.02      A    C  
ATOM    770  CB  ARG   109      -8.236  49.535  39.225  1.00  7.91      A    C  
ATOM    771  CG  ARG   109      -6.935  50.049  38.675  1.00  7.80      A    C  
ATOM    772  CD  ARG   109      -5.766  49.156  39.053  1.00  7.81      A    C  
ATOM    773  NE  ARG   109      -5.528  49.147  40.493  1.00  9.55      A    N  
ATOM    774  CZ  ARG   109      -4.473  48.561  41.060  1.00 11.61      A    C  
ATOM    775  NH1 ARG   109      -3.556  47.968  40.289  1.00 11.06      A    N  
ATOM    776  NH2 ARG   109      -4.335  48.572  42.383  1.00 10.41      A    N  
ATOM    777  C   ARG   109      -9.514  50.766  37.464  1.00  8.06      A    C  
ATOM    778  O   ARG   109      -9.035  51.774  36.924  1.00  7.99      A    O  
ATOM    779  N   ALA   110     -10.196  49.840  36.796  1.00  8.57      A    N  
ATOM    780  CA  ALA   110     -10.429  49.939  35.355  1.00  8.03      A    C  
ATOM    781  CB  ALA   110     -11.232  48.750  34.872  1.00  8.74      A    C  
ATOM    782  C   ALA   110     -11.189  51.233  35.070  1.00  8.42      A    C  
ATOM    783  O   ALA   110     -10.843  51.970  34.155  1.00  8.72      A    O  
ATOM    784  N   GLY   111     -12.226  51.499  35.849  1.00  8.72      A    N  
ATOM    785  CA  GLY   111     -13.012  52.725  35.640  1.00  9.25      A    C  
ATOM    786  C   GLY   111     -12.139  53.965  35.705  1.00 10.46      A    C  
ATOM    787  O   GLY   111     -12.298  54.901  34.900  1.00 11.07      A    O  
ATOM    788  N   ALA   112     -11.207  53.982  36.647  1.00  9.87      A    N  
ATOM    789  CA  ALA   112     -10.353  55.142  36.839  1.00 10.21      A    C  
ATOM    790  CB  ALA   112      -9.618  55.060  38.163  1.00 10.82      A    C  
ATOM    791  C   ALA   112      -9.377  55.306  35.689  1.00 10.06      A    C  
ATOM    792  O   ALA   112      -8.877  56.405  35.445  1.00 11.14      A    O  
ATOM    793  N   ASN   113      -9.088  54.201  34.993  1.00  9.16      A    N  
ATOM    794  CA  ASN   113      -8.221  54.236  33.813  1.00  8.58      A    C  
ATOM    795  CB  ASN   113      -7.544  52.867  33.610  1.00  8.54      A    C  
ATOM    796  CG  ASN   113      -6.440  52.615  34.610  1.00  8.49      A    C  
ATOM    797  OD1 ASN   113      -5.916  53.557  35.226  1.00 10.25      A    O  
ATOM    798  ND2 ASN   113      -6.090  51.336  34.802  1.00  8.99      A    N  
ATOM    799  C   ASN   113      -8.962  54.614  32.529  1.00  9.31      A    C  
ATOM    800  O   ASN   113      -8.355  54.705  31.436  1.00  8.68      A    O  
ATOM    801  N   GLY   114     -10.267  54.817  32.654  1.00  9.70      A    N  
ATOM    802  CA  GLY   114     -11.121  55.088  31.496  1.00 11.28      A    C  
ATOM    803  C   GLY   114     -11.697  53.858  30.805  1.00 11.74      A    C  
ATOM    804  O   GLY   114     -12.109  53.922  29.638  1.00 13.21      A    O  
ATOM    805  N   VAL   115     -11.737  52.734  31.515  1.00 11.48      A    N  
ATOM    806  CA  VAL   115     -12.386  51.534  31.014  1.00 11.45      A    C  
ATOM    807  CB  VAL   115     -11.535  50.271  31.295  1.00 10.60      A    C  
ATOM    808  CG1 VAL   115     -12.212  49.040  30.711  1.00 12.53      A    C  
ATOM    809  CG2 VAL   115     -10.120  50.450  30.738  1.00 13.32      A    C  
ATOM    810  C   VAL   115     -13.709  51.420  31.746  1.00 12.02      A    C  
ATOM    811  O   VAL   115     -13.766  51.014  32.895  1.00 11.16      A    O  
ATOM    812  N   ASP   116     -14.784  51.832  31.103  1.00 13.59      A    N  
ATOM    813  CA  ASP   116     -15.992  51.963  31.880  1.00 15.54      A    C  
ATOM    814  CB  ASP   116     -16.457  53.432  31.940  1.00 16.87      A    C  
ATOM    815  CG  ASP   116     -15.604  54.279  32.907  1.00 19.81      A    C  
ATOM    816  OD1 ASP   116     -16.016  54.458  34.075  1.00 26.33      A    O  
ATOM    817  OD2 ASP   116     -14.505  54.740  32.527  1.00 21.36      A    O  
ATOM    818  C   ASP   116     -17.075  50.984  31.423  1.00 15.16      A    C  
ATOM    819  O   ASP   116     -18.230  51.092  31.840  1.00 17.09      A    O  
ATOM    820  N   ASP   117     -16.672  49.982  30.643  1.00 12.69      A    N  
ATOM    821  CA  ASP   117     -17.614  48.992  30.133  1.00 11.33      A    C  
ATOM    822  CB  ASP   117     -17.478  48.839  28.616  1.00 11.97      A    C  
ATOM    823  CG  ASP   117     -16.115  48.341  28.197  1.00 13.56      A    C  
ATOM    824  OD1 ASP   117     -15.264  48.117  29.083  1.00 11.65      A    O  
ATOM    825  OD2 ASP   117     -15.912  48.155  26.981  1.00 15.47      A    O  
ATOM    826  C   ASP   117     -17.543  47.618  30.804  1.00 10.19      A    C  
ATOM    827  O   ASP   117     -18.091  46.648  30.269  1.00  9.96      A    O  
ATOM    828  N   LEU   118     -16.887  47.511  31.957  1.00  9.45      A    N  
ATOM    829  CA  LEU   118     -16.838  46.185  32.609  1.00  9.46      A    C  
ATOM    830  CB  LEU   118     -15.809  46.120  33.738  1.00  9.00      A    C  
ATOM    831  CG  LEU   118     -14.355  46.415  33.367  1.00 11.18      A    C  
ATOM    832  CD1 LEU   118     -13.426  45.906  34.467  1.00 11.89      A    C  
ATOM    833  CD2 LEU   118     -13.983  45.779  32.025  1.00 12.04      A    C  
ATOM    834  C   LEU   118     -18.208  45.804  33.146  1.00 10.13      A    C  
ATOM    835  O   LEU   118     -19.002  46.675  33.507  1.00 10.94      A    O  
ATOM    836  N   GLN   119     -18.492  44.506  33.183  1.00  8.74      A    N  
ATOM    837  CA  GLN   119     -19.769  44.023  33.699  1.00  8.51      A    C  
ATOM    838  CB  GLN   119     -20.575  43.355  32.575  1.00  8.34      A    C  
ATOM    839  CG  GLN   119     -20.815  44.275  31.368  1.00 11.21      A    C  
ATOM    840  CD  GLN   119     -21.022  43.542  30.044  1.00 16.69      A    C  
ATOM    841  OE1 GLN   119     -20.068  43.037  29.427  1.00 21.22      A    O  
ATOM    842  NE2 GLN   119     -22.261  43.521  29.578  1.00 19.52      A    N  
ATOM    843  C   GLN   119     -19.476  42.994  34.781  1.00  8.64      A    C  
ATOM    844  O   GLN   119     -18.814  41.996  34.511  1.00  9.81      A    O  
ATOM    845  N   HIS   120     -19.995  43.216  35.983  1.00  8.48      A    N  
ATOM    846  CA  HIS   120     -19.736  42.320  37.103  1.00  8.47      A    C  
ATOM    847  CB  HIS   120     -19.609  43.152  38.379  1.00  8.76      A    C  
ATOM    848  CG  HIS   120     -19.097  42.399  39.565  1.00 10.10      A    C  
ATOM    849  ND1 HIS   120     -18.554  43.039  40.655  1.00 10.85      A    N  
ATOM    850  CE1 HIS   120     -18.200  42.140  41.560  1.00 11.17      A    C  
ATOM    851  NE2 HIS   120     -18.493  40.940  41.091  1.00 12.17      A    N  
ATOM    852  CD2 HIS   120     -19.053  41.074  39.841  1.00 11.02      A    C  
ATOM    853  C   HIS   120     -20.913  41.373  37.203  1.00  8.24      A    C  
ATOM    854  O   HIS   120     -22.040  41.826  37.399  1.00  9.20      A    O  
ATOM    855  N   ILE   121     -20.655  40.073  37.061  1.00  8.14      A    N  
ATOM    856  CA  ILE   121     -21.726  39.069  37.013  1.00  8.68      A    C  
ATOM    857  CB  ILE   121     -22.019  38.603  35.555  1.00  8.35      A    C  
ATOM    858  CG1 ILE   121     -20.833  37.820  34.976  1.00  9.73      A    C  
ATOM    859  CD1 ILE   121     -21.018  37.429  33.522  1.00  9.21      A    C  
ATOM    860  CG2 ILE   121     -22.390  39.799  34.670  1.00 10.25      A    C  
ATOM    861  C   ILE   121     -21.387  37.870  37.897  1.00  9.26      A    C  
ATOM    862  O   ILE   121     -20.231  37.678  38.255  1.00  9.54      A    O  
ATOM    863  N   ASP   122     -22.405  37.092  38.269  1.00  9.73      A    N  
ATOM    864  CA  ASP   122     -22.188  35.908  39.106  1.00 10.86      A    C  
ATOM    865  CB  ASP   122     -23.354  35.676  40.093  1.00 11.61      A    C  
ATOM    866  CG  ASP   122     -24.672  35.249  39.421  1.00 13.45      A    C  
ATOM    867  OD1 ASP   122     -24.695  34.799  38.247  1.00 14.14      A    O  
ATOM    868  OD2 ASP   122     -25.716  35.331  40.126  1.00 15.48      A    O  
ATOM    869  C   ASP   122     -21.845  34.691  38.265  1.00 10.57      A    C  
ATOM    870  O   ASP   122     -21.785  34.777  37.039  1.00 10.96      A    O  
ATOM    871  N   GLY   123     -21.563  33.559  38.908  1.00 11.14      A    N  
ATOM    872  CA  GLY   123     -21.061  32.405  38.165  1.00 11.24      A    C  
ATOM    873  C   GLY   123     -22.102  31.799  37.236  1.00 10.96      A    C  
ATOM    874  O   GLY   123     -21.777  31.279  36.165  1.00 10.79      A    O  
ATOM    875  N   ALA   124     -23.365  31.871  37.641  1.00 11.37      A    N  
ATOM    876  CA  ALA   124     -24.425  31.317  36.818  1.00 11.90      A    C  
ATOM    877  CB  ALA   124     -25.736  31.283  37.574  1.00 12.51      A    C  
ATOM    878  C   ALA   124     -24.551  32.145  35.559  1.00 11.88      A    C  
ATOM    879  O   ALA   124     -24.719  31.600  34.460  1.00 12.27      A    O  
ATOM    880  N   ALA   125     -24.464  33.468  35.710  1.00 11.08      A    N  
ATOM    881  CA  ALA   125     -24.471  34.355  34.540  1.00 11.35      A    C  
ATOM    882  CB  ALA   125     -24.527  35.840  34.954  1.00 10.70      A    C  
ATOM    883  C   ALA   125     -23.276  34.090  33.625  1.00 11.48      A    C  
ATOM    884  O   ALA   125     -23.409  34.069  32.397  1.00 12.27      A    O  
ATOM    885  N   ALA   126     -22.113  33.851  34.226  1.00 11.56      A    N  
ATOM    886  CA  ALA   126     -20.917  33.609  33.443  1.00 11.94      A    C  
ATOM    887  CB  ALA   126     -19.703  33.540  34.342  1.00 11.91      A    C  
ATOM    888  C   ALA   126     -21.073  32.313  32.670  1.00 12.63      A    C  
ATOM    889  O   ALA   126     -20.632  32.228  31.526  1.00 12.77      A    O  
ATOM    890  N   ARG   127     -21.703  31.312  33.290  1.00 13.27      A    N  
ATOM    891  CA  ARG   127     -21.963  30.046  32.598  1.00 15.12      A    C  
ATOM    892  CB  ARG   127     -22.409  28.938  33.557  1.00 15.73      A    C  
ATOM    893  CG  ARG   127     -22.422  27.574  32.871  1.00 19.72      A    C  
ATOM    894  CD  ARG   127     -23.038  26.512  33.742  1.00 28.32      A    C  
ATOM    895  NE  ARG   127     -22.144  26.082  34.814  1.00 32.45      A    N  
ATOM    896  CZ  ARG   127     -20.915  25.609  34.628  1.00 34.53      A    C  
ATOM    897  NH1 ARG   127     -20.399  25.526  33.410  1.00 36.22      A    N  
ATOM    898  NH2 ARG   127     -20.192  25.241  35.674  1.00 35.62      A    N  
ATOM    899  C   ARG   127     -22.977  30.194  31.455  1.00 15.15      A    C  
ATOM    900  O   ARG   127     -22.910  29.453  30.475  1.00 15.26      A    O  
ATOM    901  N   ARG   128     -23.908  31.142  31.563  1.00 15.50      A    N  
ATOM    902  CA  ARG   128     -24.790  31.443  30.424  1.00 16.16      A    C  
ATOM    903  CB  ARG   128     -25.851  32.486  30.767  1.00 16.85      A    C  
ATOM    904  CG  ARG   128     -26.902  32.009  31.742  1.00 20.03      A    C  
ATOM    905  CD  ARG   128     -28.158  32.920  31.714  1.00 23.38      A    C  
ATOM    906  NE  ARG   128     -27.918  34.274  32.227  1.00 25.47      A    N  
ATOM    907  CZ  ARG   128     -27.910  34.592  33.519  1.00 27.33      A    C  
ATOM    908  NH1 ARG   128     -28.118  33.653  34.446  1.00 27.69      A    N  
ATOM    909  NH2 ARG   128     -27.688  35.847  33.891  1.00 26.88      A    N  
ATOM    910  C   ARG   128     -23.991  31.946  29.232  1.00 15.98      A    C  
ATOM    911  O   ARG   128     -24.267  31.573  28.086  1.00 15.86      A    O  
ATOM    912  N   LEU   129     -23.008  32.801  29.506  1.00 14.53      A    N  
ATOM    913  CA  LEU   129     -22.157  33.354  28.466  1.00 14.54      A    C  
ATOM    914  CB  LEU   129     -21.324  34.523  29.013  1.00 14.23      A    C  
ATOM    915  CG  LEU   129     -22.077  35.802  29.379  1.00 15.66      A    C  
ATOM    916  CD1 LEU   129     -21.063  36.888  29.787  1.00 13.86      A    C  
ATOM    917  CD2 LEU   129     -22.936  36.264  28.210  1.00 17.99      A    C  
ATOM    918  C   LEU   129     -21.224  32.286  27.899  1.00 14.19      A    C  
ATOM    919  O   LEU   129     -20.954  32.262  26.691  1.00 14.72      A    O  
ATOM    920  N   GLU   130     -20.714  31.429  28.780  1.00 13.72      A    N  
ATOM    921  CA  GLU   130     -19.693  30.447  28.403  1.00 13.56      A    C  
ATOM    922  CB  GLU   130     -18.301  30.918  28.843  1.00 13.55      A    C  
ATOM    923  CG  GLU   130     -17.812  32.200  28.176  1.00 12.68      A    C  
ATOM    924  CD  GLU   130     -17.538  32.055  26.680  1.00 15.70      A    C  
ATOM    925  OE1 GLU   130     -17.409  30.913  26.192  1.00 15.22      A    O  
ATOM    926  OE2 GLU   130     -17.450  33.099  25.993  1.00 16.47      A    O  
ATOM    927  C   GLU   130     -19.994  29.120  29.069  1.00 13.88      A    C  
ATOM    928  O   GLU   130     -19.589  28.887  30.202  1.00 13.11      A    O  
ATOM    929  N   PRO   131     -20.737  28.253  28.372  1.00 14.53      A    N  
ATOM    930  CA  PRO   131     -21.213  26.989  28.923  1.00 15.31      A    C  
ATOM    931  CB  PRO   131     -21.841  26.302  27.703  1.00 15.14      A    C  
ATOM    932  CG  PRO   131     -22.378  27.450  26.909  1.00 15.68      A    C  
ATOM    933  CD  PRO   131     -21.346  28.545  27.061  1.00 15.28      A    C  
ATOM    934  C   PRO   131     -20.140  26.105  29.568  1.00 15.38      A    C  
ATOM    935  O   PRO   131     -20.448  25.354  30.491  1.00 16.32      A    O  
ATOM    936  N   ALA   132     -18.896  26.197  29.118  1.00 15.33      A    N  
ATOM    937  CA  ALA   132     -17.847  25.328  29.668  1.00 15.52      A    C  
ATOM    938  CB  ALA   132     -16.771  25.078  28.617  1.00 16.38      A    C  
ATOM    939  C   ALA   132     -17.208  25.875  30.945  1.00 15.75      A    C  
ATOM    940  O   ALA   132     -16.409  25.189  31.603  1.00 15.42      A    O  
ATOM    941  N   LEU   133     -17.577  27.104  31.303  1.00 14.25      A    N  
ATOM    942  CA  LEU   133     -16.881  27.834  32.363  1.00 14.20      A    C  
ATOM    943  CB  LEU   133     -17.013  29.332  32.104  1.00 13.32      A    C  
ATOM    944  CG  LEU   133     -16.291  30.281  33.061  1.00 13.73      A    C  
ATOM    945  CD1 LEU   133     -14.819  30.063  32.911  1.00 13.50      A    C  
ATOM    946  CD2 LEU   133     -16.631  31.749  32.722  1.00 13.79      A    C  
ATOM    947  C   LEU   133     -17.400  27.519  33.770  1.00 14.47      A    C  
ATOM    948  O   LEU   133     -18.607  27.572  34.019  1.00 15.12      A    O  
ATOM    949  N   HIS   134     -16.478  27.225  34.686  1.00 14.03      A    N  
ATOM    950  CA  HIS   134     -16.791  27.085  36.108  1.00 14.76      A    C  
ATOM    951  CB  HIS   134     -16.326  25.724  36.611  1.00 15.90      A    C  
ATOM    952  CG  HIS   134     -17.110  24.582  36.049  1.00 20.20      A    C  
ATOM    953  ND1 HIS   134     -17.115  24.268  34.704  1.00 24.70      A    N  
ATOM    954  CE1 HIS   134     -17.893  23.216  34.503  1.00 24.55      A    C  
ATOM    955  NE2 HIS   134     -18.387  22.834  35.668  1.00 26.33      A    N  
ATOM    956  CD2 HIS   134     -17.918  23.674  36.651  1.00 24.33      A    C  
ATOM    957  C   HIS   134     -16.131  28.199  36.914  1.00 13.53      A    C  
ATOM    958  O   HIS   134     -14.913  28.234  37.069  1.00 13.85      A    O  
ATOM    959  N   CYS   135     -16.927  29.153  37.383  1.00 12.51      A    N  
ATOM    960  CA  CYS   135     -16.371  30.209  38.219  1.00 11.65      A    C  
ATOM    961  CB  CYS   135     -15.875  31.389  37.375  1.00 11.43      A    C  
ATOM    962  SG  CYS   135     -17.216  32.398  36.638  1.00 12.32      A    S  
ATOM    963  C   CYS   135     -17.401  30.688  39.230  1.00 11.62      A    C  
ATOM    964  O   CYS   135     -18.592  30.391  39.108  1.00 12.40      A    O  
ATOM    965  N   THR   136     -16.925  31.458  40.205  1.00 10.92      A    N  
ATOM    966  CA  THR   136     -17.759  31.963  41.287  1.00 10.56      A    C  
ATOM    967  CB  THR   136     -16.915  32.176  42.555  1.00 11.24      A    C  
ATOM    968  OG1 THR   136     -16.345  30.909  42.944  1.00 13.55      A    O  
ATOM    969  CG2 THR   136     -17.777  32.718  43.690  1.00 11.81      A    C  
ATOM    970  C   THR   136     -18.403  33.284  40.877  1.00 10.16      A    C  
ATOM    971  O   THR   136     -19.545  33.552  41.213  1.00 10.24      A    O  
ATOM    972  N   ALA   137     -17.646  34.092  40.140  1.00  9.44      A    N  
ATOM    973  CA  ALA   137     -18.134  35.370  39.620  1.00  7.84      A    C  
ATOM    974  CB  ALA   137     -18.210  36.398  40.727  1.00  8.66      A    C  
ATOM    975  C   ALA   137     -17.164  35.822  38.552  1.00  7.88      A    C  
ATOM    976  O   ALA   137     -16.083  35.261  38.427  1.00  7.58      A    O  
ATOM    977  N   ALA   138     -17.527  36.831  37.767  1.00  6.45      A    N  
ATOM    978  CA  ALA   138     -16.600  37.287  36.739  1.00  6.77      A    C  
ATOM    979  CB  ALA   138     -16.755  36.458  35.465  1.00  5.81      A    C  
ATOM    980  C   ALA   138     -16.801  38.758  36.441  1.00  6.16      A    C  
ATOM    981  O   ALA   138     -17.863  39.324  36.754  1.00  7.09      A    O  
ATOM    982  N   LEU   139     -15.778  39.366  35.855  1.00  6.31      A    N  
ATOM    983  CA  LEU   139     -15.931  40.662  35.194  1.00  6.22      A    C  
ATOM    984  CB  LEU   139     -14.799  41.612  35.585  1.00  5.90      A    C  
ATOM    985  CG  LEU   139     -14.821  42.073  37.031  1.00  6.27      A    C  
ATOM    986  CD1 LEU   139     -13.501  42.801  37.369  1.00  8.20      A    C  
ATOM    987  CD2 LEU   139     -16.055  42.965  37.215  1.00  8.08      A    C  
ATOM    988  C   LEU   139     -15.845  40.430  33.699  1.00  6.93      A    C  
ATOM    989  O   LEU   139     -14.862  39.866  33.209  1.00  6.95      A    O  
ATOM    990  N   VAL   140     -16.857  40.882  32.971  1.00  6.51      A    N  
ATOM    991  CA  VAL   140     -16.795  40.888  31.522  1.00  7.14      A    C  
ATOM    992  CB  VAL   140     -18.203  40.794  30.884  1.00  7.16      A    C  
ATOM    993  CG1 VAL   140     -18.077  40.514  29.383  1.00  8.41      A    C  
ATOM    994  CG2 VAL   140     -19.015  39.715  31.557  1.00  8.16      A    C  
ATOM    995  C   VAL   140     -16.126  42.163  31.029  1.00  6.55      A    C  
ATOM    996  O   VAL   140     -16.484  43.262  31.452  1.00  7.58      A    O  
ATOM    997  N   SER   141     -15.179  42.009  30.103  1.00  6.10      A    N  
ATOM    998  CA  SER   141     -14.471  43.144  29.483  1.00  6.48      A    C  
ATOM    999  CB  SER   141     -12.967  43.087  29.802  1.00  5.90      A    C  
ATOM   1000  OG  SER   141     -12.256  44.072  29.083  1.00  6.81      A    O  
ATOM   1001  C   SER   141     -14.717  43.098  27.978  1.00  7.17      A    C  
ATOM   1002  O   SER   141     -13.993  42.443  27.229  1.00  7.47      A    O  
ATOM   1003  N   PRO   142     -15.766  43.796  27.523  1.00  7.70      A    N  
ATOM   1004  CA  PRO   142     -16.172  43.629  26.122  1.00  8.72      A    C  
ATOM   1005  CB  PRO   142     -17.576  44.249  26.053  1.00  9.16      A    C  
ATOM   1006  CG  PRO   142     -17.902  44.720  27.403  1.00  9.02      A    C  
ATOM   1007  CD  PRO   142     -16.733  44.549  28.335  1.00  8.19      A    C  
ATOM   1008  C   PRO   142     -15.234  44.264  25.106  1.00  9.17      A    C  
ATOM   1009  O   PRO   142     -15.268  43.884  23.930  1.00 10.78      A    O  
ATOM   1010  N   SER   143     -14.380  45.190  25.538  1.00  9.07      A    N  
ATOM   1011  CA  SER   143     -13.504  45.889  24.594  1.00  9.08      A    C  
ATOM   1012  CB  SER   143     -13.225  47.319  25.066  1.00  9.83      A    C  
ATOM   1013  OG  SER   143     -12.209  47.392  26.069  1.00 10.75      A    O  
ATOM   1014  C   SER   143     -12.193  45.128  24.333  1.00  8.98      A    C  
ATOM   1015  O   SER   143     -11.432  45.488  23.444  1.00  9.13      A    O  
ATOM   1016  N   THR   144     -11.939  44.088  25.121  1.00  7.62      A    N  
ATOM   1017  CA  THR   144     -10.721  43.289  24.934  1.00  7.76      A    C  
ATOM   1018  CB  THR   144     -10.529  42.313  26.113  1.00  7.89      A    C  
ATOM   1019  OG1 THR   144     -10.479  43.049  27.344  1.00  7.88      A    O  
ATOM   1020  CG2 THR   144      -9.238  41.507  25.945  1.00  7.59      A    C  
ATOM   1021  C   THR   144     -10.845  42.512  23.636  1.00  7.77      A    C  
ATOM   1022  O   THR   144     -11.920  41.986  23.336  1.00  8.55      A    O  
ATOM   1023  N   GLY   145      -9.767  42.459  22.853  1.00  7.14      A    N  
ATOM   1024  CA  GLY   145      -9.798  41.770  21.569  1.00  7.26      A    C  
ATOM   1025  C   GLY   145      -8.525  41.004  21.284  1.00  7.74      A    C  
ATOM   1026  O   GLY   145      -7.682  40.821  22.182  1.00  7.64      A    O  
ATOM   1027  N   ILE   146      -8.416  40.529  20.041  1.00  7.82      A    N  
ATOM   1028  CA  ILE   146      -7.192  39.904  19.534  1.00  8.08      A    C  
ATOM   1029  CB  ILE   146      -7.332  38.378  19.409  1.00  8.11      A    C  
ATOM   1030  CG1 ILE   146      -8.470  38.015  18.452  1.00  8.73      A    C  
ATOM   1031  CD1 ILE   146      -8.649  36.472  18.277  1.00  9.10      A    C  
ATOM   1032  CG2 ILE   146      -7.492  37.716  20.799  1.00  7.93      A    C  
ATOM   1033  C   ILE   146      -6.826  40.473  18.172  1.00  8.45      A    C  
ATOM   1034  O   ILE   146      -7.678  40.956  17.430  1.00  8.53      A    O  
ATOM   1035  N   VAL   147      -5.542  40.442  17.863  1.00  9.05      A    N  
ATOM   1036  CA  VAL   147      -5.032  40.986  16.605  1.00 10.93      A    C  
ATOM   1037  CB  VAL   147      -4.579  42.453  16.777  1.00 10.90      A    C  
ATOM   1038  CG1 VAL   147      -3.412  42.552  17.811  1.00 11.75      A    C  
ATOM   1039  CG2 VAL   147      -4.243  43.114  15.426  1.00 11.05      A    C  
ATOM   1040  C   VAL   147      -3.884  40.130  16.090  1.00 12.52      A    C  
ATOM   1041  O   VAL   147      -3.128  39.532  16.863  1.00 12.11      A    O  
ATOM   1042  N   ASP   148      -3.770  40.097  14.769  1.00 14.47      A    N  
ATOM   1043  CA  ASP   148      -2.664  39.450  14.093  1.00 16.95      A    C  
ATOM   1044  CB  ASP   148      -3.085  39.112  12.665  1.00 17.58      A    C  
ATOM   1045  CG  ASP   148      -1.964  38.477  11.847  1.00 21.13      A    C  
ATOM   1046  OD1 ASP   148      -0.775  38.668  12.182  1.00 23.02      A    O  
ATOM   1047  OD2 ASP   148      -2.295  37.779  10.861  1.00 24.53      A    O  
ATOM   1048  C   ASP   148      -1.506  40.422  14.093  1.00 16.87      A    C  
ATOM   1049  O   ASP   148      -1.511  41.396  13.345  1.00 17.36      A    O  
ATOM   1050  N   SER   149      -0.532  40.165  14.958  1.00 17.72      A    N  
ATOM   1051  CA  SER   149       0.528  41.121  15.224  1.00 18.68      A    C  
ATOM   1052  CB  SER   149       1.254  40.764  16.510  1.00 19.12      A    C  
ATOM   1053  OG  SER   149       1.909  39.516  16.379  1.00 22.53      A    O  
ATOM   1054  C   SER   149       1.504  41.170  14.066  1.00 18.52      A    C  
ATOM   1055  O   SER   149       2.071  42.227  13.770  1.00 18.58      A    O  
ATOM   1056  N   HIS   150       1.681  40.029  13.399  1.00 18.36      A    N  
ATOM   1057  CA  HIS   150       2.470  40.003  12.167  1.00 18.02      A    C  
ATOM   1058  CB  HIS   150       2.681  38.572  11.657  1.00 18.68      A    C  
ATOM   1059  CG  HIS   150       3.558  38.503  10.447  1.00 21.09      A    C  
ATOM   1060  ND1 HIS   150       4.884  38.882  10.472  1.00 25.40      A    N  
ATOM   1061  CE1 HIS   150       5.406  38.726   9.268  1.00 25.84      A    C  
ATOM   1062  NE2 HIS   150       4.462  38.273   8.461  1.00 25.44      A    N  
ATOM   1063  CD2 HIS   150       3.296  38.129   9.173  1.00 24.21      A    C  
ATOM   1064  C   HIS   150       1.853  40.888  11.079  1.00 16.84      A    C  
ATOM   1065  O   HIS   150       2.546  41.695  10.446  1.00 16.16      A    O  
ATOM   1066  N   ALA   151       0.545  40.763  10.873  1.00 16.24      A    N  
ATOM   1067  CA  ALA   151      -0.139  41.625   9.928  1.00 15.86      A    C  
ATOM   1068  CB  ALA   151      -1.597  41.246   9.813  1.00 16.38      A    C  
ATOM   1069  C   ALA   151      -0.014  43.080  10.356  1.00 15.47      A    C  
ATOM   1070  O   ALA   151       0.171  43.956   9.528  1.00 15.17      A    O  
ATOM   1071  N   LEU   152      -0.137  43.335  11.653  1.00 14.77      A    N  
ATOM   1072  CA  LEU   152      -0.056  44.710  12.140  1.00 14.27      A    C  
ATOM   1073  CB  LEU   152      -0.319  44.751  13.639  1.00 13.97      A    C  
ATOM   1074  CG  LEU   152      -0.373  46.128  14.281  1.00 13.87      A    C  
ATOM   1075  CD1 LEU   152      -1.591  46.910  13.748  1.00 11.37      A    C  
ATOM   1076  CD2 LEU   152      -0.468  45.935  15.789  1.00 11.28      A    C  
ATOM   1077  C   LEU   152       1.311  45.289  11.822  1.00 14.19      A    C  
ATOM   1078  O   LEU   152       1.419  46.393  11.319  1.00 13.70      A    O  
ATOM   1079  N   MET   153       2.357  44.515  12.099  1.00 14.92      A    N  
ATOM   1080  CA  MET   153       3.723  44.933  11.785  1.00 15.94      A    C  
ATOM   1081  CB  MET   153       4.716  43.865  12.236  1.00 16.58      A    C  
ATOM   1082  CG  MET   153       4.994  43.954  13.716  1.00 18.71      A    C  
ATOM   1083  SD  MET   153       6.135  42.731  14.333  1.00 25.55      A    S  
ATOM   1084  CE  MET   153       5.900  41.338  13.214  1.00 19.88      A    C  
ATOM   1085  C   MET   153       3.916  45.278  10.304  1.00 15.59      A    C  
ATOM   1086  O   MET   153       4.469  46.313   9.967  1.00 14.87      A    O  
ATOM   1087  N   LEU   154       3.444  44.406   9.426  1.00 15.91      A    N  
ATOM   1088  CA  LEU   154       3.581  44.625   7.994  1.00 16.35      A    C  
ATOM   1089  CB  LEU   154       3.024  43.412   7.241  1.00 17.02      A    C  
ATOM   1090  CG  LEU   154       3.863  42.144   7.359  1.00 19.65      A    C  
ATOM   1091  CD1 LEU   154       3.184  40.943   6.698  1.00 22.42      A    C  
ATOM   1092  CD2 LEU   154       5.226  42.393   6.731  1.00 22.25      A    C  
ATOM   1093  C   LEU   154       2.850  45.893   7.581  1.00 15.80      A    C  
ATOM   1094  O   LEU   154       3.295  46.623   6.696  1.00 15.54      A    O  
ATOM   1095  N   ALA   155       1.715  46.155   8.232  1.00 15.23      A    N  
ATOM   1096  CA  ALA   155       0.925  47.329   7.924  1.00 14.47      A    C  
ATOM   1097  CB  ALA   155      -0.490  47.232   8.577  1.00 14.80      A    C  
ATOM   1098  C   ALA   155       1.656  48.596   8.352  1.00 14.00      A    C  
ATOM   1099  O   ALA   155       1.692  49.576   7.606  1.00 14.23      A    O  
ATOM   1100  N   TYR   156       2.246  48.586   9.552  1.00 13.09      A    N  
ATOM   1101  CA  TYR   156       3.050  49.728  10.006  1.00 12.38      A    C  
ATOM   1102  CB  TYR   156       3.629  49.514  11.406  1.00 12.10      A    C  
ATOM   1103  CG  TYR   156       2.652  49.504  12.567  1.00 10.97      A    C  
ATOM   1104  CD1 TYR   156       1.308  49.845  12.400  1.00  9.82      A    C  
ATOM   1105  CE1 TYR   156       0.416  49.822  13.489  1.00 10.69      A    C  
ATOM   1106  CZ  TYR   156       0.891  49.518  14.757  1.00  9.74      A    C  
ATOM   1107  OH  TYR   156       0.036  49.505  15.850  1.00 10.56      A    O  
ATOM   1108  CE2 TYR   156       2.219  49.206  14.943  1.00 10.96      A    C  
ATOM   1109  CD2 TYR   156       3.096  49.209  13.850  1.00 11.32      A    C  
ATOM   1110  C   TYR   156       4.220  49.940   9.049  1.00 12.81      A    C  
ATOM   1111  O   TYR   156       4.559  51.070   8.709  1.00 12.43      A    O  
ATOM   1112  N   GLN   157       4.851  48.841   8.658  1.00 13.85      A    N  
ATOM   1113  CA  GLN   157       5.981  48.904   7.726  1.00 14.67      A    C  
ATOM   1114  CB  GLN   157       6.560  47.517   7.449  1.00 15.34      A    C  
ATOM   1115  CG  GLN   157       7.733  47.581   6.475  1.00 17.21      A    C  
ATOM   1116  CD  GLN   157       8.411  46.240   6.247  1.00 20.78      A    C  
ATOM   1117  OE1 GLN   157       8.147  45.261   6.941  1.00 23.92      A    O  
ATOM   1118  NE2 GLN   157       9.297  46.194   5.262  1.00 22.71      A    N  
ATOM   1119  C   GLN   157       5.576  49.552   6.417  1.00 14.89      A    C  
ATOM   1120  O   GLN   157       6.260  50.448   5.940  1.00 14.44      A    O  
ATOM   1121  N   GLY   158       4.482  49.068   5.828  1.00 15.07      A    N  
ATOM   1122  CA  GLY   158       3.913  49.666   4.616  1.00 15.81      A    C  
ATOM   1123  C   GLY   158       3.687  51.163   4.711  1.00 16.14      A    C  
ATOM   1124  O   GLY   158       4.078  51.917   3.818  1.00 16.18      A    O  
ATOM   1125  N   ASP   159       3.055  51.611   5.797  1.00 15.83      A    N  
ATOM   1126  CA  ASP   159       2.843  53.032   6.002  1.00 16.31      A    C  
ATOM   1127  CB  ASP   159       2.101  53.288   7.321  1.00 16.20      A    C  
ATOM   1128  CG  ASP   159       0.697  52.694   7.341  1.00 18.03      A    C  
ATOM   1129  OD1 ASP   159       0.209  52.235   6.279  1.00 18.03      A    O  
ATOM   1130  OD2 ASP   159       0.075  52.701   8.435  1.00 15.54      A    O  
ATOM   1131  C   ASP   159       4.153  53.809   6.029  1.00 16.11      A    C  
ATOM   1132  O   ASP   159       4.287  54.834   5.371  1.00 16.51      A    O  
ATOM   1133  N   ALA   160       5.122  53.338   6.809  1.00 16.03      A    N  
ATOM   1134  CA  ALA   160       6.379  54.061   6.948  1.00 15.64      A    C  
ATOM   1135  CB  ALA   160       7.279  53.375   7.976  1.00 15.92      A    C  
ATOM   1136  C   ALA   160       7.084  54.161   5.598  1.00 16.30      A    C  
ATOM   1137  O   ALA   160       7.596  55.223   5.225  1.00 15.95      A    O  
ATOM   1138  N   GLU   161       7.102  53.052   4.871  1.00 16.77      A    N  
ATOM   1139  CA  GLU   161       7.720  53.023   3.542  1.00 17.91      A    C  
ATOM   1140  CB  GLU   161       7.720  51.607   2.973  1.00 17.88      A    C  
ATOM   1141  CG  GLU   161       8.741  50.677   3.637  1.00 20.21      A    C  
ATOM   1142  CD  GLU   161       8.599  49.224   3.201  1.00 23.52      A    C  
ATOM   1143  OE1 GLU   161       7.532  48.844   2.680  1.00 26.93      A    O  
ATOM   1144  OE2 GLU   161       9.559  48.452   3.386  1.00 25.88      A    O  
ATOM   1145  C   GLU   161       7.024  53.986   2.584  1.00 18.29      A    C  
ATOM   1146  O   GLU   161       7.673  54.645   1.777  1.00 18.44      A    O  
ATOM   1147  N   SER   162       5.704  54.080   2.684  1.00 18.99      A    N  
ATOM   1148  CA  SER   162       4.956  55.017   1.843  1.00 19.41      A    C  
ATOM   1149  CB  SER   162       3.447  54.841   2.046  1.00 19.38      A    C  
ATOM   1150  OG  SER   162       2.985  55.633   3.131  1.00 23.20      A    O  
ATOM   1151  C   SER   162       5.377  56.468   2.090  1.00 19.47      A    C  
ATOM   1152  O   SER   162       5.243  57.324   1.206  1.00 19.90      A    O  
ATOM   1153  N   ASP   163       5.894  56.741   3.287  1.00 18.85      A    N  
ATOM   1154  CA  ASP   163       6.424  58.053   3.621  1.00 18.86      A    C  
ATOM   1155  CB  ASP   163       5.941  58.495   5.008  1.00 18.79      A    C  
ATOM   1156  CG  ASP   163       4.470  58.866   5.021  1.00 20.54      A    C  
ATOM   1157  OD1 ASP   163       3.996  59.411   3.996  1.00 20.38      A    O  
ATOM   1158  OD2 ASP   163       3.791  58.631   6.055  1.00 20.98      A    O  
ATOM   1159  C   ASP   163       7.952  58.064   3.563  1.00 18.06      A    C  
ATOM   1160  O   ASP   163       8.595  58.866   4.225  1.00 18.31      A    O  
ATOM   1161  N   GLY   164       8.512  57.166   2.760  1.00 18.01      A    N  
ATOM   1162  CA  GLY   164       9.936  57.192   2.425  1.00 17.80      A    C  
ATOM   1163  C   GLY   164      10.883  56.463   3.359  1.00 17.55      A    C  
ATOM   1164  O   GLY   164      12.110  56.488   3.159  1.00 17.16      A    O  
ATOM   1165  N   ALA   165      10.347  55.821   4.392  1.00 16.59      A    N  
ATOM   1166  CA  ALA   165      11.226  55.078   5.299  1.00 15.88      A    C  
ATOM   1167  CB  ALA   165      10.464  54.611   6.531  1.00 15.49      A    C  
ATOM   1168  C   ALA   165      11.848  53.895   4.581  1.00 15.99      A    C  
ATOM   1169  O   ALA   165      11.227  53.301   3.702  1.00 16.08      A    O  
ATOM   1170  N   GLN   166      13.089  53.572   4.946  1.00 15.87      A    N  
ATOM   1171  CA  GLN   166      13.783  52.403   4.409  1.00 16.04      A    C  
ATOM   1172  CB  GLN   166      15.063  52.818   3.694  1.00 16.57      A    C  
ATOM   1173  CG  GLN   166      14.817  53.598   2.408  1.00 17.98      A    C  
ATOM   1174  CD  GLN   166      16.094  53.867   1.628  1.00 21.08      A    C  
ATOM   1175  OE1 GLN   166      16.923  52.979   1.448  1.00 23.16      A    O  
ATOM   1176  NE2 GLN   166      16.249  55.097   1.157  1.00 20.86      A    N  
ATOM   1177  C   GLN   166      14.134  51.479   5.564  1.00 15.97      A    C  
ATOM   1178  O   GLN   166      14.580  51.938   6.615  1.00 16.12      A    O  
ATOM   1179  N   LEU   167      13.920  50.188   5.373  1.00 15.41      A    N  
ATOM   1180  CA  LEU   167      14.239  49.197   6.385  1.00 16.04      A    C  
ATOM   1181  CB  LEU   167      13.047  48.288   6.632  1.00 16.45      A    C  
ATOM   1182  CG  LEU   167      11.863  48.925   7.362  1.00 18.85      A    C  
ATOM   1183  CD1 LEU   167      10.928  49.624   6.390  1.00 21.28      A    C  
ATOM   1184  CD2 LEU   167      11.135  47.861   8.152  1.00 20.90      A    C  
ATOM   1185  C   LEU   167      15.400  48.358   5.908  1.00 15.59      A    C  
ATOM   1186  O   LEU   167      15.386  47.864   4.770  1.00 15.57      A    O  
ATOM   1187  N   VAL   168      16.401  48.187   6.769  1.00 14.78      A    N  
ATOM   1188  CA  VAL   168      17.559  47.372   6.415  1.00 14.56      A    C  
ATOM   1189  CB  VAL   168      18.876  48.187   6.329  1.00 14.89      A    C  
ATOM   1190  CG1 VAL   168      18.823  49.156   5.161  1.00 16.13      A    C  
ATOM   1191  CG2 VAL   168      19.174  48.941   7.626  1.00 15.18      A    C  
ATOM   1192  C   VAL   168      17.697  46.230   7.410  1.00 14.04      A    C  
ATOM   1193  O   VAL   168      17.853  46.465   8.608  1.00 13.41      A    O  
ATOM   1194  N   PHE   169      17.589  45.004   6.905  1.00 13.28      A    N  
ATOM   1195  CA  PHE   169      17.640  43.818   7.757  1.00 13.58      A    C  
ATOM   1196  CB  PHE   169      16.650  42.755   7.264  1.00 13.70      A    C  
ATOM   1197  CG  PHE   169      15.212  43.168   7.435  1.00 15.53      A    C  
ATOM   1198  CD1 PHE   169      14.573  43.012   8.668  1.00 16.84      A    C  
ATOM   1199  CE1 PHE   169      13.258  43.403   8.842  1.00 18.53      A    C  
ATOM   1200  CZ  PHE   169      12.567  43.973   7.779  1.00 18.35      A    C  
ATOM   1201  CE2 PHE   169      13.193  44.145   6.547  1.00 17.55      A    C  
ATOM   1202  CD2 PHE   169      14.508  43.728   6.375  1.00 16.64      A    C  
ATOM   1203  C   PHE   169      19.067  43.272   7.865  1.00 13.19      A    C  
ATOM   1204  O   PHE   169      19.973  43.773   7.201  1.00 13.60      A    O  
ATOM   1205  N   HIS   170      19.252  42.277   8.726  1.00 12.99      A    N  
ATOM   1206  CA  HIS   170      20.580  41.741   9.069  1.00 13.34      A    C  
ATOM   1207  CB  HIS   170      21.019  40.628   8.092  1.00 14.56      A    C  
ATOM   1208  CG  HIS   170      20.910  40.999   6.648  1.00 18.57      A    C  
ATOM   1209  ND1 HIS   170      21.886  41.712   5.986  1.00 21.37      A    N  
ATOM   1210  CE1 HIS   170      21.520  41.890   4.728  1.00 22.64      A    C  
ATOM   1211  NE2 HIS   170      20.346  41.311   4.549  1.00 23.50      A    N  
ATOM   1212  CD2 HIS   170      19.945  40.738   5.732  1.00 20.09      A    C  
ATOM   1213  C   HIS   170      21.641  42.840   9.242  1.00 12.40      A    C  
ATOM   1214  O   HIS   170      22.780  42.732   8.777  1.00 11.98      A    O  
ATOM   1215  N   THR   171      21.243  43.884   9.960  1.00 10.20      A    N  
ATOM   1216  CA  THR   171      22.069  45.048  10.175  1.00 10.29      A    C  
ATOM   1217  CB  THR   171      21.558  46.211   9.305  1.00  9.65      A    C  
ATOM   1218  OG1 THR   171      21.615  45.801   7.930  1.00 11.88      A    O  
ATOM   1219  CG2 THR   171      22.400  47.460   9.509  1.00 10.17      A    C  
ATOM   1220  C   THR   171      22.068  45.398  11.669  1.00  9.25      A    C  
ATOM   1221  O   THR   171      21.277  46.224  12.139  1.00 10.00      A    O  
ATOM   1222  N   PRO   172      22.937  44.735  12.440  1.00  8.33      A    N  
ATOM   1223  CA  PRO   172      22.975  44.938  13.879  1.00  8.52      A    C  
ATOM   1224  CB  PRO   172      23.712  43.681  14.377  1.00  8.27      A    C  
ATOM   1225  CG  PRO   172      24.641  43.370  13.295  1.00  8.48      A    C  
ATOM   1226  CD  PRO   172      23.925  43.729  12.001  1.00  8.85      A    C  
ATOM   1227  C   PRO   172      23.779  46.177  14.265  1.00  8.15      A    C  
ATOM   1228  O   PRO   172      24.909  46.344  13.810  1.00  8.40      A    O  
ATOM   1229  N   LEU   173      23.199  47.047  15.087  1.00  7.89      A    N  
ATOM   1230  CA  LEU   173      23.974  48.130  15.697  1.00  7.87      A    C  
ATOM   1231  CB  LEU   173      23.061  49.217  16.291  1.00  7.05      A    C  
ATOM   1232  CG  LEU   173      23.786  50.364  16.999  1.00  7.37      A    C  
ATOM   1233  CD1 LEU   173      24.775  51.011  16.041  1.00  9.34      A    C  
ATOM   1234  CD2 LEU   173      22.811  51.424  17.509  1.00  7.46      A    C  
ATOM   1235  C   LEU   173      24.885  47.573  16.790  1.00  8.11      A    C  
ATOM   1236  O   LEU   173      24.426  46.892  17.713  1.00  8.12      A    O  
ATOM   1237  N   ILE   174      26.179  47.863  16.681  1.00  8.09      A    N  
ATOM   1238  CA  ILE   174      27.158  47.291  17.621  1.00  8.42      A    C  
ATOM   1239  CB  ILE   174      28.356  46.670  16.853  1.00  8.26      A    C  
ATOM   1240  CG1 ILE   174      27.865  45.676  15.789  1.00  7.67      A    C  
ATOM   1241  CD1 ILE   174      27.054  44.487  16.336  1.00  7.85      A    C  
ATOM   1242  CG2 ILE   174      29.361  46.028  17.830  1.00  8.43      A    C  
ATOM   1243  C   ILE   174      27.652  48.314  18.624  1.00  9.03      A    C  
ATOM   1244  O   ILE   174      27.699  48.070  19.829  1.00  9.28      A    O  
ATOM   1245  N   ALA   175      28.047  49.480  18.136  1.00  9.51      A    N  
ATOM   1246  CA  ALA   175      28.565  50.498  19.019  1.00 10.45      A    C  
ATOM   1247  CB  ALA   175      30.071  50.393  19.129  1.00 10.90      A    C  
ATOM   1248  C   ALA   175      28.188  51.837  18.435  1.00 11.08      A    C  
ATOM   1249  O   ALA   175      27.962  51.946  17.233  1.00 11.71      A    O  
ATOM   1250  N   GLY   176      28.139  52.854  19.278  1.00 12.21      A    N  
ATOM   1251  CA  GLY   176      27.846  54.194  18.798  1.00 13.05      A    C  
ATOM   1252  C   GLY   176      28.436  55.230  19.731  1.00 13.92      A    C  
ATOM   1253  O   GLY   176      28.990  54.894  20.775  1.00 13.64      A    O  
ATOM   1254  N   ARG   177      28.294  56.498  19.359  1.00 15.36      A    N  
ATOM   1255  CA  ARG   177      28.721  57.593  20.213  1.00 16.27      A    C  
ATOM   1256  CB  ARG   177      30.206  57.909  20.017  1.00 17.42      A    C  
ATOM   1257  CG  ARG   177      30.658  57.827  18.593  1.00 20.25      A    C  
ATOM   1258  CD  ARG   177      31.969  57.019  18.473  1.00 23.95      A    C  
ATOM   1259  NE  ARG   177      32.031  56.407  17.152  1.00 27.37      A    N  
ATOM   1260  CZ  ARG   177      31.792  55.125  16.912  1.00 27.14      A    C  
ATOM   1261  NH1 ARG   177      31.522  54.286  17.913  1.00 26.52      A    N  
ATOM   1262  NH2 ARG   177      31.845  54.676  15.669  1.00 29.80      A    N  
ATOM   1263  C   ARG   177      27.896  58.829  19.927  1.00 16.34      A    C  
ATOM   1264  O   ARG   177      27.538  59.091  18.788  1.00 15.95      A    O  
ATOM   1265  N   VAL   178      27.570  59.556  20.980  1.00 17.04      A    N  
ATOM   1266  CA  VAL   178      26.987  60.887  20.836  1.00 18.33      A    C  
ATOM   1267  CB  VAL   178      26.464  61.400  22.181  1.00 17.81      A    C  
ATOM   1268  CG1 VAL   178      25.794  62.775  22.007  1.00 19.49      A    C  
ATOM   1269  CG2 VAL   178      25.498  60.391  22.792  1.00 18.84      A    C  
ATOM   1270  C   VAL   178      28.092  61.799  20.348  1.00 19.19      A    C  
ATOM   1271  O   VAL   178      29.158  61.865  20.962  1.00 19.66      A    O  
ATOM   1272  N   ARG   179      27.849  62.492  19.244  1.00 20.46      A    N  
ATOM   1273  CA  ARG   179      28.847  63.385  18.655  1.00 22.18      A    C  
ATOM   1274  CB  ARG   179      28.556  63.618  17.170  1.00 21.81      A    C  
ATOM   1275  CG  ARG   179      28.576  62.372  16.315  1.00 21.76      A    C  
ATOM   1276  CD  ARG   179      28.501  62.735  14.854  1.00 21.65      A    C  
ATOM   1277  NE  ARG   179      27.341  63.577  14.565  1.00 21.68      A    N  
ATOM   1278  CZ  ARG   179      26.933  63.870  13.336  1.00 21.54      A    C  
ATOM   1279  NH1 ARG   179      27.594  63.391  12.291  1.00 21.08      A    N  
ATOM   1280  NH2 ARG   179      25.867  64.630  13.152  1.00 22.04      A    N  
ATOM   1281  C   ARG   179      28.893  64.723  19.376  1.00 23.47      A    C  
ATOM   1282  O   ARG   179      27.849  65.298  19.694  1.00 23.29      A    O  
ATOM   1283  N   PRO   180      30.113  65.232  19.616  1.00 25.00      A    N  
ATOM   1284  CA  PRO   180      30.317  66.517  20.281  1.00 25.94      A    C  
ATOM   1285  CB  PRO   180      31.798  66.812  20.025  1.00 26.04      A    C  
ATOM   1286  CG  PRO   180      32.425  65.461  19.860  1.00 26.63      A    C  
ATOM   1287  CD  PRO   180      31.381  64.610  19.192  1.00 25.14      A    C  
ATOM   1288  C   PRO   180      29.443  67.608  19.658  1.00 26.39      A    C  
ATOM   1289  O   PRO   180      28.883  68.438  20.378  1.00 27.48      A    O  
ATOM   1290  N   GLU   181      29.326  67.591  18.334  1.00 26.33      A    N  
ATOM   1291  CA  GLU   181      28.523  68.571  17.599  1.00 26.44      A    C  
ATOM   1292  CB  GLU   181      29.034  68.689  16.167  1.00 26.54      A    C  
ATOM   1293  CG  GLU   181      28.729  67.484  15.304  1.00 28.19      A    C  
ATOM   1294  CD  GLU   181      29.889  66.499  15.219  1.00 30.24      A    C  
ATOM   1295  OE1 GLU   181      30.617  66.327  16.229  1.00 30.67      A    O  
ATOM   1296  OE2 GLU   181      30.074  65.903  14.133  1.00 31.19      A    O  
ATOM   1297  C   GLU   181      27.020  68.258  17.548  1.00 25.87      A    C  
ATOM   1298  O   GLU   181      26.256  68.990  16.909  1.00 26.59      A    O  
ATOM   1299  N   GLY   182      26.596  67.182  18.206  1.00 24.64      A    N  
ATOM   1300  CA  GLY   182      25.198  66.750  18.146  1.00 22.42      A    C  
ATOM   1301  C   GLY   182      25.047  65.597  17.171  1.00 21.04      A    C  
ATOM   1302  O   GLY   182      25.896  65.402  16.308  1.00 20.92      A    O  
ATOM   1303  N   GLY   183      23.974  64.819  17.302  1.00 18.80      A    N  
ATOM   1304  CA  GLY   183      23.797  63.658  16.435  1.00 16.53      A    C  
ATOM   1305  C   GLY   183      24.635  62.485  16.927  1.00 14.99      A    C  
ATOM   1306  O   GLY   183      25.215  62.537  18.016  1.00 14.84      A    O  
ATOM   1307  N   PHE   184      24.726  61.456  16.094  1.00 13.93      A    N  
ATOM   1308  CA  PHE   184      25.298  60.172  16.507  1.00 13.13      A    C  
ATOM   1309  CB  PHE   184      24.152  59.206  16.850  1.00 12.83      A    C  
ATOM   1310  CG  PHE   184      23.183  59.768  17.842  1.00 13.91      A    C  
ATOM   1311  CD1 PHE   184      23.331  59.531  19.195  1.00 12.71      A    C  
ATOM   1312  CE1 PHE   184      22.449  60.071  20.115  1.00 12.74      A    C  
ATOM   1313  CZ  PHE   184      21.412  60.880  19.677  1.00 13.24      A    C  
ATOM   1314  CE2 PHE   184      21.257  61.124  18.330  1.00 11.65      A    C  
ATOM   1315  CD2 PHE   184      22.135  60.567  17.414  1.00 12.37      A    C  
ATOM   1316  C   PHE   184      26.144  59.580  15.403  1.00 12.91      A    C  
ATOM   1317  O   PHE   184      25.842  59.757  14.227  1.00 12.12      A    O  
ATOM   1318  N   GLU   185      27.199  58.855  15.786  1.00 12.91      A    N  
ATOM   1319  CA  GLU   185      27.953  58.058  14.831  1.00 13.21      A    C  
ATOM   1320  CB  GLU   185      29.432  58.434  14.829  1.00 13.69      A    C  
ATOM   1321  CG  GLU   185      30.186  57.732  13.726  1.00 17.84      A    C  
ATOM   1322  CD  GLU   185      31.647  58.112  13.682  1.00 23.25      A    C  
ATOM   1323  OE1 GLU   185      32.325  57.987  14.729  1.00 26.33      A    O  
ATOM   1324  OE2 GLU   185      32.115  58.509  12.593  1.00 25.75      A    O  
ATOM   1325  C   GLU   185      27.767  56.613  15.255  1.00 12.22      A    C  
ATOM   1326  O   GLU   185      27.908  56.294  16.442  1.00 12.86      A    O  
ATOM   1327  N   LEU   186      27.440  55.760  14.295  1.00 11.73      A    N  
ATOM   1328  CA  LEU   186      26.991  54.399  14.607  1.00 11.35      A    C  
ATOM   1329  CB  LEU   186      25.497  54.254  14.280  1.00 11.21      A    C  
ATOM   1330  CG  LEU   186      24.556  55.239  14.990  1.00 12.19      A    C  
ATOM   1331  CD1 LEU   186      23.129  54.999  14.522  1.00 12.80      A    C  
ATOM   1332  CD2 LEU   186      24.645  55.154  16.513  1.00 11.56      A    C  
ATOM   1333  C   LEU   186      27.740  53.346  13.809  1.00 10.81      A    C  
ATOM   1334  O   LEU   186      27.823  53.435  12.582  1.00 11.13      A    O  
ATOM   1335  N   ASP   187      28.236  52.317  14.502  1.00 10.47      A    N  
ATOM   1336  CA  ASP   187      28.934  51.222  13.856  1.00 10.57      A    C  
ATOM   1337  CB  ASP   187      30.211  50.862  14.629  1.00 10.52      A    C  
ATOM   1338  CG  ASP   187      31.160  52.039  14.749  1.00 13.54      A    C  
ATOM   1339  OD1 ASP   187      31.164  52.898  13.832  1.00 16.27      A    O  
ATOM   1340  OD2 ASP   187      31.895  52.108  15.756  1.00 17.11      A    O  
ATOM   1341  C   ASP   187      28.041  50.007  13.800  1.00  9.88      A    C  
ATOM   1342  O   ASP   187      27.648  49.475  14.844  1.00  9.11      A    O  
ATOM   1343  N   PHE   188      27.708  49.589  12.580  1.00  9.80      A    N  
ATOM   1344  CA  PHE   188      26.895  48.413  12.359  1.00 10.64      A    C  
ATOM   1345  CB  PHE   188      25.886  48.681  11.251  1.00 10.49      A    C  
ATOM   1346  CG  PHE   188      24.868  49.720  11.615  1.00  9.97      A    C  
ATOM   1347  CD1 PHE   188      23.687  49.348  12.231  1.00 11.29      A    C  
ATOM   1348  CE1 PHE   188      22.736  50.296  12.573  1.00 11.93      A    C  
ATOM   1349  CZ  PHE   188      22.965  51.633  12.295  1.00 12.62      A    C  
ATOM   1350  CE2 PHE   188      24.144  52.018  11.667  1.00 11.53      A    C  
ATOM   1351  CD2 PHE   188      25.090  51.058  11.336  1.00 12.05      A    C  
ATOM   1352  C   PHE   188      27.766  47.210  12.026  1.00 10.85      A    C  
ATOM   1353  O   PHE   188      28.836  47.340  11.404  1.00 11.32      A    O  
ATOM   1354  N   GLY   189      27.317  46.036  12.454  1.00 11.23      A    N  
ATOM   1355  CA  GLY   189      28.084  44.809  12.255  1.00 11.21      A    C  
ATOM   1356  C   GLY   189      27.490  43.887  11.205  1.00 11.49      A    C  
ATOM   1357  O   GLY   189      27.011  44.338  10.148  1.00 11.13      A    O  
ATOM   1358  N   GLY   190      27.496  42.591  11.501  1.00 10.38      A    N  
ATOM   1359  CA  GLY   190      27.004  41.572  10.579  1.00 11.23      A    C  
ATOM   1360  C   GLY   190      27.962  41.298   9.425  1.00 12.17      A    C  
ATOM   1361  O   GLY   190      29.160  41.543   9.529  1.00 11.35      A    O  
ATOM   1362  N   ALA   191      27.407  40.794   8.326  1.00 13.23      A    N  
ATOM   1363  CA  ALA   191      28.196  40.384   7.170  1.00 14.28      A    C  
ATOM   1364  CB  ALA   191      27.352  39.556   6.231  1.00 14.72      A    C  
ATOM   1365  C   ALA   191      28.794  41.571   6.423  1.00 14.38      A    C  
ATOM   1366  O   ALA   191      29.802  41.424   5.738  1.00 15.35      A    O  
ATOM   1367  N   GLU   192      28.172  42.735   6.558  1.00 13.71      A    N  
ATOM   1368  CA  GLU   192      28.578  43.918   5.805  1.00 14.16      A    C  
ATOM   1369  CB  GLU   192      27.563  44.223   4.703  1.00 14.36      A    C  
ATOM   1370  CG  GLU   192      27.275  43.073   3.758  1.00 17.88      A    C  
ATOM   1371  CD  GLU   192      26.044  43.352   2.920  1.00 22.75      A    C  
ATOM   1372  OE1 GLU   192      26.112  44.221   2.011  1.00 23.54      A    O  
ATOM   1373  OE2 GLU   192      24.996  42.720   3.189  1.00 25.37      A    O  
ATOM   1374  C   GLU   192      28.691  45.132   6.723  1.00 13.02      A    C  
ATOM   1375  O   GLU   192      27.886  46.059   6.632  1.00 12.59      A    O  
ATOM   1376  N   PRO   193      29.699  45.130   7.599  1.00 12.63      A    N  
ATOM   1377  CA  PRO   193      29.825  46.204   8.582  1.00 12.57      A    C  
ATOM   1378  CB  PRO   193      31.100  45.837   9.369  1.00 12.27      A    C  
ATOM   1379  CG  PRO   193      31.795  44.797   8.571  1.00 12.67      A    C  
ATOM   1380  CD  PRO   193      30.728  44.088   7.782  1.00 12.37      A    C  
ATOM   1381  C   PRO   193      29.993  47.543   7.913  1.00 12.99      A    C  
ATOM   1382  O   PRO   193      30.588  47.639   6.827  1.00 12.51      A    O  
ATOM   1383  N   MET   194      29.452  48.570   8.546  1.00 12.97      A    N  
ATOM   1384  CA  MET   194      29.477  49.906   7.968  1.00 13.24      A    C  
ATOM   1385  CB  MET   194      28.362  50.039   6.926  1.00 13.37      A    C  
ATOM   1386  CG  MET   194      26.958  50.127   7.541  1.00 14.71      A    C  
ATOM   1387  SD  MET   194      25.659  50.420   6.309  1.00 15.17      A    S  
ATOM   1388  CE  MET   194      25.838  48.946   5.359  1.00 18.02      A    C  
ATOM   1389  C   MET   194      29.243  50.911   9.075  1.00 13.51      A    C  
ATOM   1390  O   MET   194      28.750  50.551  10.138  1.00 13.59      A    O  
ATOM   1391  N   THR   195      29.579  52.177   8.826  1.00 13.34      A    N  
ATOM   1392  CA  THR   195      29.300  53.238   9.789  1.00 13.81      A    C  
ATOM   1393  CB  THR   195      30.589  53.926  10.251  1.00 13.18      A    C  
ATOM   1394  OG1 THR   195      31.392  52.988  10.983  1.00 16.01      A    O  
ATOM   1395  CG2 THR   195      30.281  55.119  11.140  1.00 14.43      A    C  
ATOM   1396  C   THR   195      28.364  54.261   9.154  1.00 13.99      A    C  
ATOM   1397  O   THR   195      28.519  54.598   7.981  1.00 13.93      A    O  
ATOM   1398  N   LEU   196      27.372  54.709   9.912  1.00 14.13      A    N  
ATOM   1399  CA  LEU   196      26.428  55.747   9.455  1.00 14.52      A    C  
ATOM   1400  CB  LEU   196      25.045  55.160   9.131  1.00 14.58      A    C  
ATOM   1401  CG  LEU   196      24.874  54.032   8.104  1.00 15.95      A    C  
ATOM   1402  CD1 LEU   196      23.415  53.563   8.044  1.00 17.10      A    C  
ATOM   1403  CD2 LEU   196      25.362  54.456   6.716  1.00 19.76      A    C  
ATOM   1404  C   LEU   196      26.275  56.754  10.570  1.00 14.91      A    C  
ATOM   1405  O   LEU   196      26.500  56.436  11.735  1.00 15.15      A    O  
ATOM   1406  N   SER   197      25.879  57.976  10.227  1.00 14.77      A    N  
ATOM   1407  CA  SER   197      25.653  58.990  11.245  1.00 14.47      A    C  
ATOM   1408  CB  SER   197      26.655  60.123  11.101  1.00 15.04      A    C  
ATOM   1409  OG  SER   197      26.461  60.772   9.858  1.00 18.23      A    O  
ATOM   1410  C   SER   197      24.242  59.537  11.079  1.00 13.78      A    C  
ATOM   1411  O   SER   197      23.646  59.401  10.007  1.00 13.97      A    O  
ATOM   1412  N   CYS   198      23.705  60.116  12.144  1.00 13.16      A    N  
ATOM   1413  CA  CYS   198      22.302  60.558  12.139  1.00 13.65      A    C  
ATOM   1414  CB  CYS   198      21.353  59.382  12.389  1.00 13.61      A    C  
ATOM   1415  SG  CYS   198      21.509  58.584  14.007  1.00 14.33      A    S  
ATOM   1416  C   CYS   198      22.010  61.678  13.128  1.00 13.53      A    C  
ATOM   1417  O   CYS   198      22.767  61.933  14.060  1.00 13.00      A    O  
ATOM   1418  N   ARG   199      20.892  62.364  12.925  1.00 13.13      A    N  
ATOM   1419  CA  ARG   199      20.540  63.455  13.826  1.00 13.43      A    C  
ATOM   1420  CB  ARG   199      19.746  64.518  13.055  1.00 14.01      A    C  
ATOM   1421  CG  ARG   199      19.304  65.698  13.885  1.00 15.90      A    C  
ATOM   1422  CD  ARG   199      18.369  66.620  13.076  1.00 17.46      A    C  
ATOM   1423  NE  ARG   199      17.089  65.989  12.728  1.00 19.34      A    N  
ATOM   1424  CZ  ARG   199      15.982  66.055  13.471  1.00 19.42      A    C  
ATOM   1425  NH1 ARG   199      15.968  66.733  14.612  1.00 21.71      A    N  
ATOM   1426  NH2 ARG   199      14.877  65.449  13.059  1.00 19.05      A    N  
ATOM   1427  C   ARG   199      19.737  62.938  15.022  1.00 12.85      A    C  
ATOM   1428  O   ARG   199      19.931  63.371  16.153  1.00 13.63      A    O  
ATOM   1429  N   VAL   200      18.833  62.006  14.757  1.00 12.54      A    N  
ATOM   1430  CA  VAL   200      17.954  61.466  15.784  1.00 12.29      A    C  
ATOM   1431  CB  VAL   200      16.479  61.745  15.431  1.00 12.66      A    C  
ATOM   1432  CG1 VAL   200      15.559  60.936  16.316  1.00 13.14      A    C  
ATOM   1433  CG2 VAL   200      16.178  63.230  15.586  1.00 12.74      A    C  
ATOM   1434  C   VAL   200      18.160  59.963  15.875  1.00 10.71      A    C  
ATOM   1435  O   VAL   200      18.263  59.305  14.858  1.00 10.98      A    O  
ATOM   1436  N   LEU   201      18.227  59.441  17.095  1.00 10.20      A    N  
ATOM   1437  CA  LEU   201      18.374  57.997  17.309  1.00  9.78      A    C  
ATOM   1438  CB  LEU   201      19.724  57.686  17.957  1.00  9.15      A    C  
ATOM   1439  CG  LEU   201      20.035  56.192  18.146  1.00  9.59      A    C  
ATOM   1440  CD1 LEU   201      19.935  55.405  16.828  1.00 13.48      A    C  
ATOM   1441  CD2 LEU   201      21.396  56.032  18.799  1.00 10.99      A    C  
ATOM   1442  C   LEU   201      17.288  57.474  18.229  1.00  9.04      A    C  
ATOM   1443  O   LEU   201      17.150  57.940  19.348  1.00 10.07      A    O  
ATOM   1444  N   ILE   202      16.556  56.463  17.769  1.00  9.03      A    N  
ATOM   1445  CA  ILE   202      15.549  55.818  18.598  1.00  8.77      A    C  
ATOM   1446  CB  ILE   202      14.187  55.717  17.900  1.00  9.02      A    C  
ATOM   1447  CG1 ILE   202      13.730  57.073  17.344  1.00 10.37      A    C  
ATOM   1448  CD1 ILE   202      13.604  58.141  18.384  1.00  9.20      A    C  
ATOM   1449  CG2 ILE   202      13.136  55.128  18.844  1.00 10.32      A    C  
ATOM   1450  C   ILE   202      16.027  54.389  18.860  1.00  7.84      A    C  
ATOM   1451  O   ILE   202      16.199  53.596  17.934  1.00  7.98      A    O  
ATOM   1452  N   ASN   203      16.245  54.083  20.122  1.00  8.20      A    N  
ATOM   1453  CA  ASN   203      16.652  52.743  20.538  1.00  8.37      A    C  
ATOM   1454  CB  ASN   203      17.694  52.858  21.657  1.00  8.39      A    C  
ATOM   1455  CG  ASN   203      17.922  51.553  22.401  1.00  8.59      A    C  
ATOM   1456  OD1 ASN   203      17.550  50.486  21.940  1.00  8.93      A    O  
ATOM   1457  ND2 ASN   203      18.553  51.647  23.571  1.00  9.50      A    N  
ATOM   1458  C   ASN   203      15.397  51.984  20.984  1.00  7.68      A    C  
ATOM   1459  O   ASN   203      14.888  52.183  22.098  1.00  7.64      A    O  
ATOM   1460  N   ALA   204      14.887  51.160  20.074  1.00  8.08      A    N  
ATOM   1461  CA  ALA   204      13.676  50.382  20.278  1.00  7.97      A    C  
ATOM   1462  CB  ALA   204      12.617  50.733  19.203  1.00  7.84      A    C  
ATOM   1463  C   ALA   204      14.055  48.906  20.221  1.00  8.03      A    C  
ATOM   1464  O   ALA   204      13.329  48.084  19.673  1.00  8.35      A    O  
ATOM   1465  N   ALA   205      15.205  48.581  20.810  1.00  8.09      A    N  
ATOM   1466  CA  ALA   205      15.783  47.246  20.649  1.00  8.95      A    C  
ATOM   1467  CB  ALA   205      17.323  47.335  20.785  1.00  8.85      A    C  
ATOM   1468  C   ALA   205      15.215  46.155  21.572  1.00  9.22      A    C  
ATOM   1469  O   ALA   205      15.742  45.027  21.623  1.00  8.90      A    O  
ATOM   1470  N   GLY   206      14.148  46.473  22.303  1.00  8.62      A    N  
ATOM   1471  CA  GLY   206      13.441  45.455  23.082  1.00  9.18      A    C  
ATOM   1472  C   GLY   206      14.242  44.835  24.216  1.00  9.37      A    C  
ATOM   1473  O   GLY   206      14.713  45.534  25.108  1.00  9.50      A    O  
ATOM   1474  N   LEU   207      14.366  43.508  24.188  1.00 10.01      A    N  
ATOM   1475  CA  LEU   207      15.168  42.779  25.166  1.00 11.08      A    C  
ATOM   1476  CB  LEU   207      15.341  41.325  24.703  1.00 10.79      A    C  
ATOM   1477  CG  LEU   207      14.086  40.490  24.532  1.00 14.13      A    C  
ATOM   1478  CD1 LEU   207      14.495  39.061  24.245  1.00 15.21      A    C  
ATOM   1479  CD2 LEU   207      13.256  40.564  25.800  1.00 15.53      A    C  
ATOM   1480  C   LEU   207      16.565  43.363  25.332  1.00 10.50      A    C  
ATOM   1481  O   LEU   207      17.194  43.224  26.401  1.00 11.39      A    O  
ATOM   1482  N   HIS   208      17.064  43.974  24.261  1.00  9.20      A    N  
ATOM   1483  CA  HIS   208      18.441  44.424  24.218  1.00  8.94      A    C  
ATOM   1484  CB  HIS   208      19.105  43.942  22.930  1.00  9.54      A    C  
ATOM   1485  CG  HIS   208      19.232  42.457  22.868  1.00 11.80      A    C  
ATOM   1486  ND1 HIS   208      20.119  41.767  23.659  1.00 17.06      A    N  
ATOM   1487  CE1 HIS   208      20.003  40.473  23.421  1.00 16.40      A    C  
ATOM   1488  NE2 HIS   208      19.063  40.303  22.513  1.00 15.08      A    N  
ATOM   1489  CD2 HIS   208      18.547  41.528  22.166  1.00 14.31      A    C  
ATOM   1490  C   HIS   208      18.590  45.914  24.354  1.00  8.24      A    C  
ATOM   1491  O   HIS   208      19.693  46.431  24.272  1.00  7.88      A    O  
ATOM   1492  N   ALA   209      17.491  46.621  24.599  1.00  7.48      A    N  
ATOM   1493  CA  ALA   209      17.611  48.071  24.654  1.00  7.41      A    C  
ATOM   1494  CB  ALA   209      16.193  48.767  24.727  1.00  8.13      A    C  
ATOM   1495  C   ALA   209      18.562  48.604  25.741  1.00  7.41      A    C  
ATOM   1496  O   ALA   209      19.333  49.533  25.484  1.00  7.52      A    O  
ATOM   1497  N   PRO   210      18.484  48.065  26.966  1.00  6.70      A    N  
ATOM   1498  CA  PRO   210      19.398  48.607  27.994  1.00  6.94      A    C  
ATOM   1499  CB  PRO   210      18.953  47.884  29.264  1.00  6.78      A    C  
ATOM   1500  CG  PRO   210      17.477  47.528  28.989  1.00  6.88      A    C  
ATOM   1501  CD  PRO   210      17.471  47.149  27.541  1.00  6.88      A    C  
ATOM   1502  C   PRO   210      20.876  48.325  27.692  1.00  7.62      A    C  
ATOM   1503  O   PRO   210      21.725  49.223  27.831  1.00  8.12      A    O  
ATOM   1504  N   GLY   211      21.164  47.109  27.247  1.00  7.83      A    N  
ATOM   1505  CA  GLY   211      22.535  46.752  26.915  1.00  7.75      A    C  
ATOM   1506  C   GLY   211      23.031  47.566  25.745  1.00  7.91      A    C  
ATOM   1507  O   GLY   211      24.186  47.983  25.703  1.00  8.44      A    O  
ATOM   1508  N   LEU   212      22.143  47.820  24.794  1.00  7.61      A    N  
ATOM   1509  CA  LEU   212      22.512  48.622  23.633  1.00  7.74      A    C  
ATOM   1510  CB  LEU   212      21.436  48.570  22.557  1.00  7.89      A    C  
ATOM   1511  CG  LEU   212      21.705  49.413  21.301  1.00  7.60      A    C  
ATOM   1512  CD1 LEU   212      23.016  49.006  20.629  1.00  9.65      A    C  
ATOM   1513  CD2 LEU   212      20.533  49.272  20.355  1.00  8.22      A    C  
ATOM   1514  C   LEU   212      22.791  50.056  24.048  1.00  7.66      A    C  
ATOM   1515  O   LEU   212      23.723  50.670  23.558  1.00  7.84      A    O  
ATOM   1516  N   ALA   213      21.984  50.606  24.951  1.00  7.71      A    N  
ATOM   1517  CA  ALA   213      22.288  51.968  25.437  1.00  8.99      A    C  
ATOM   1518  CB  ALA   213      21.227  52.432  26.418  1.00  9.47      A    C  
ATOM   1519  C   ALA   213      23.686  52.047  26.062  1.00  8.46      A    C  
ATOM   1520  O   ALA   213      24.410  53.014  25.880  1.00  9.13      A    O  
ATOM   1521  N   ARG   214      24.073  51.000  26.781  1.00  9.00      A    N  
ATOM   1522  CA  ARG   214      25.387  50.963  27.392  1.00  9.47      A    C  
ATOM   1523  CB  ARG   214      25.490  49.759  28.333  1.00  9.19      A    C  
ATOM   1524  CG  ARG   214      26.846  49.622  29.014  1.00 12.69      A    C  
ATOM   1525  CD  ARG   214      27.115  50.790  29.974  1.00 16.75      A    C  
ATOM   1526  NE  ARG   214      28.464  50.719  30.532  1.00 19.03      A    N  
ATOM   1527  CZ  ARG   214      29.546  51.176  29.911  1.00 18.83      A    C  
ATOM   1528  NH1 ARG   214      29.426  51.726  28.720  1.00 18.92      A    N  
ATOM   1529  NH2 ARG   214      30.753  51.075  30.474  1.00 17.01      A    N  
ATOM   1530  C   ARG   214      26.487  50.910  26.311  1.00  9.83      A    C  
ATOM   1531  O   ARG   214      27.655  51.227  26.581  1.00 10.62      A    O  
ATOM   1532  N   ARG   215      26.115  50.507  25.104  1.00  9.86      A    N  
ATOM   1533  CA  ARG   215      27.077  50.438  23.990  1.00 10.74      A    C  
ATOM   1534  CB  ARG   215      26.759  49.243  23.082  1.00 10.72      A    C  
ATOM   1535  CG  ARG   215      26.999  47.900  23.784  1.00 11.69      A    C  
ATOM   1536  CD  ARG   215      26.810  46.732  22.814  1.00 11.45      A    C  
ATOM   1537  NE  ARG   215      25.406  46.368  22.525  1.00 12.73      A    N  
ATOM   1538  CZ  ARG   215      24.625  45.579  23.276  1.00 15.53      A    C  
ATOM   1539  NH1 ARG   215      25.019  45.086  24.459  1.00 17.00      A    N  
ATOM   1540  NH2 ARG   215      23.397  45.310  22.863  1.00 17.23      A    N  
ATOM   1541  C   ARG   215      27.151  51.731  23.177  1.00 11.21      A    C  
ATOM   1542  O   ARG   215      27.825  51.787  22.141  1.00 10.82      A    O  
ATOM   1543  N   ILE   216      26.442  52.764  23.634  1.00 11.14      A    N  
ATOM   1544  CA  ILE   216      26.522  54.064  22.991  1.00 11.93      A    C  
ATOM   1545  CB  ILE   216      25.128  54.655  22.678  1.00 12.14      A    C  
ATOM   1546  CG1 ILE   216      24.269  53.654  21.887  1.00 13.07      A    C  
ATOM   1547  CD1 ILE   216      24.841  53.271  20.606  1.00 15.02      A    C  
ATOM   1548  CG2 ILE   216      25.289  55.973  21.908  1.00 11.88      A    C  
ATOM   1549  C   ILE   216      27.221  55.029  23.931  1.00 12.85      A    C  
ATOM   1550  O   ILE   216      26.660  55.409  24.958  1.00 12.73      A    O  
ATOM   1551  N   GLU   217      28.447  55.414  23.590  1.00 14.04      A    N  
ATOM   1552  CA  GLU   217      29.184  56.384  24.393  1.00 15.53      A    C  
ATOM   1553  CB  GLU   217      30.568  56.656  23.802  1.00 15.92      A    C  
ATOM   1554  CG  GLU   217      31.439  55.460  23.526  1.00 20.85      A    C  
ATOM   1555  CD  GLU   217      32.748  55.894  22.888  1.00 25.38      A    C  
ATOM   1556  OE1 GLU   217      33.386  56.827  23.434  1.00 27.71      A    O  
ATOM   1557  OE2 GLU   217      33.120  55.340  21.830  1.00 28.41      A    O  
ATOM   1558  C   GLU   217      28.430  57.701  24.432  1.00 15.44      A    C  
ATOM   1559  O   GLU   217      27.964  58.193  23.396  1.00 15.76      A    O  
ATOM   1560  N   GLY   218      28.322  58.278  25.623  1.00 15.55      A    N  
ATOM   1561  CA  GLY   218      27.629  59.549  25.763  1.00 15.38      A    C  
ATOM   1562  C   GLY   218      26.256  59.414  26.402  1.00 14.83      A    C  
ATOM   1563  O   GLY   218      25.655  60.407  26.805  1.00 15.66      A    O  
ATOM   1564  N   ILE   219      25.738  58.196  26.491  1.00 14.36      A    N  
ATOM   1565  CA  ILE   219      24.507  57.981  27.258  1.00 13.63      A    C  
ATOM   1566  CB  ILE   219      23.720  56.762  26.737  1.00 13.20      A    C  
ATOM   1567  CG1 ILE   219      23.383  56.947  25.259  1.00 12.65      A    C  
ATOM   1568  CD1 ILE   219      22.522  55.819  24.641  1.00 11.72      A    C  
ATOM   1569  CG2 ILE   219      22.481  56.531  27.603  1.00 13.03      A    C  
ATOM   1570  C   ILE   219      24.870  57.738  28.723  1.00 14.02      A    C  
ATOM   1571  O   ILE   219      25.614  56.810  29.028  1.00 13.55      A    O  
ATOM   1572  N   PRO   220      24.356  58.565  29.649  1.00 13.92      A    N  
ATOM   1573  CA  PRO   220      24.803  58.390  31.036  1.00 14.13      A    C  
ATOM   1574  CB  PRO   220      23.957  59.410  31.804  1.00 14.37      A    C  
ATOM   1575  CG  PRO   220      23.595  60.440  30.772  1.00 14.39      A    C  
ATOM   1576  CD  PRO   220      23.421  59.697  29.497  1.00 14.34      A    C  
ATOM   1577  C   PRO   220      24.544  56.977  31.571  1.00 14.69      A    C  
ATOM   1578  O   PRO   220      23.426  56.480  31.479  1.00 14.21      A    O  
ATOM   1579  N   ARG   221      25.565  56.337  32.133  1.00 15.12      A    N  
ATOM   1580  CA  ARG   221      25.393  54.954  32.591  1.00 15.77      A    C  
ATOM   1581  CB  ARG   221      26.740  54.327  32.944  1.00 16.21      A    C  
ATOM   1582  CG  ARG   221      27.657  54.279  31.760  1.00 19.37      A    C  
ATOM   1583  CD  ARG   221      29.022  53.739  32.141  1.00 23.16      A    C  
ATOM   1584  NE  ARG   221      29.941  53.847  31.016  1.00 27.81      A    N  
ATOM   1585  CZ  ARG   221      30.828  54.824  30.866  1.00 30.65      A    C  
ATOM   1586  NH1 ARG   221      30.918  55.786  31.779  1.00 32.89      A    N  
ATOM   1587  NH2 ARG   221      31.627  54.834  29.807  1.00 31.61      A    N  
ATOM   1588  C   ARG   221      24.430  54.824  33.763  1.00 16.47      A    C  
ATOM   1589  O   ARG   221      23.794  53.783  33.936  1.00 15.20      A    O  
ATOM   1590  N   ASP   222      24.306  55.874  34.572  1.00 17.16      A    N  
ATOM   1591  CA  ASP   222      23.375  55.801  35.692  1.00 19.11      A    C  
ATOM   1592  CB  ASP   222      23.709  56.840  36.789  1.00 19.64      A    C  
ATOM   1593  CG  ASP   222      23.653  58.271  36.293  1.00 23.52      A    C  
ATOM   1594  OD1 ASP   222      23.065  58.536  35.223  1.00 26.62      A    O  
ATOM   1595  OD2 ASP   222      24.207  59.158  36.992  1.00 29.09      A    O  
ATOM   1596  C   ASP   222      21.902  55.879  35.257  1.00 18.79      A    C  
ATOM   1597  O   ASP   222      21.004  55.567  36.042  1.00 20.87      A    O  
ATOM   1598  N   SER   223      21.656  56.272  34.015  1.00 18.16      A    N  
ATOM   1599  CA  SER   223      20.290  56.390  33.488  1.00 17.11      A    C  
ATOM   1600  CB  SER   223      20.219  57.467  32.377  1.00 17.33      A    C  
ATOM   1601  OG  SER   223      20.706  57.016  31.092  1.00 17.09      A    O  
ATOM   1602  C   SER   223      19.755  55.061  32.957  1.00 16.25      A    C  
ATOM   1603  O   SER   223      18.566  54.931  32.666  1.00 16.02      A    O  
ATOM   1604  N   ILE   224      20.641  54.087  32.783  1.00 14.35      A    N  
ATOM   1605  CA  ILE   224      20.266  52.866  32.073  1.00 14.06      A    C  
ATOM   1606  CB  ILE   224      21.425  52.377  31.184  1.00 13.42      A    C  
ATOM   1607  CG1 ILE   224      21.955  53.519  30.317  1.00 13.48      A    C  
ATOM   1608  CD1 ILE   224      23.278  53.178  29.555  1.00 14.75      A    C  
ATOM   1609  CG2 ILE   224      20.973  51.196  30.311  1.00 14.05      A    C  
ATOM   1610  C   ILE   224      19.903  51.759  33.048  1.00 14.44      A    C  
ATOM   1611  O   ILE   224      20.720  51.386  33.879  1.00 14.31      A    O  
ATOM   1612  N   PRO   225      18.678  51.210  32.942  1.00 14.92      A    N  
ATOM   1613  CA  PRO   225      18.260  50.130  33.847  1.00 15.89      A    C  
ATOM   1614  CB  PRO   225      16.753  50.016  33.570  1.00 15.86      A    C  
ATOM   1615  CG  PRO   225      16.613  50.457  32.143  1.00 15.53      A    C  
ATOM   1616  CD  PRO   225      17.620  51.568  31.977  1.00 14.98      A    C  
ATOM   1617  C   PRO   225      18.969  48.803  33.560  1.00 16.42      A    C  
ATOM   1618  O   PRO   225      19.573  48.631  32.494  1.00 16.92      A    O  
ATOM   1619  N   PRO   226      18.947  47.877  34.528  1.00 17.30      A    N  
ATOM   1620  CA  PRO   226      19.551  46.559  34.305  1.00 18.02      A    C  
ATOM   1621  CB  PRO   226      19.604  45.934  35.710  1.00 17.82      A    C  
ATOM   1622  CG  PRO   226      18.649  46.759  36.560  1.00 18.52      A    C  
ATOM   1623  CD  PRO   226      18.459  48.084  35.900  1.00 17.38      A    C  
ATOM   1624  C   PRO   226      18.660  45.766  33.343  1.00 18.20      A    C  
ATOM   1625  O   PRO   226      17.467  46.069  33.226  1.00 19.50      A    O  
ATOM   1626  N   GLU   227      19.240  44.824  32.602  1.00 17.79      A    N  
ATOM   1627  CA  GLU   227      18.504  44.119  31.564  1.00 17.57      A    C  
ATOM   1628  CB  GLU   227      19.393  44.052  30.323  1.00 18.16      A    C  
ATOM   1629  CG  GLU   227      18.828  43.351  29.100  1.00 19.27      A    C  
ATOM   1630  CD  GLU   227      19.810  43.380  27.923  1.00 21.02      A    C  
ATOM   1631  OE1 GLU   227      20.648  44.303  27.863  1.00 15.20      A    O  
ATOM   1632  OE2 GLU   227      19.731  42.479  27.061  1.00 24.76      A    O  
ATOM   1633  C   GLU   227      18.165  42.706  32.067  1.00 17.55      A    C  
ATOM   1634  O   GLU   227      19.070  41.859  32.133  1.00 17.14      A    O  
ATOM   1635  N   TYR   228      16.903  42.446  32.448  1.00 16.08      A    N  
ATOM   1636  CA  TYR   228      16.514  41.076  32.876  1.00 15.05      A    C  
ATOM   1637  CB  TYR   228      15.735  41.023  34.203  1.00 14.76      A    C  
ATOM   1638  CG  TYR   228      16.276  41.816  35.388  1.00 15.14      A    C  
ATOM   1639  CD1 TYR   228      17.088  41.220  36.346  1.00 13.64      A    C  
ATOM   1640  CE1 TYR   228      17.550  41.942  37.441  1.00 13.97      A    C  
ATOM   1641  CZ  TYR   228      17.189  43.272  37.592  1.00 16.03      A    C  
ATOM   1642  OH  TYR   228      17.642  44.003  38.674  1.00 17.70      A    O  
ATOM   1643  CE2 TYR   228      16.367  43.880  36.667  1.00 15.34      A    C  
ATOM   1644  CD2 TYR   228      15.913  43.151  35.573  1.00 15.34      A    C  
ATOM   1645  C   TYR   228      15.647  40.405  31.810  1.00 14.44      A    C  
ATOM   1646  O   TYR   228      15.128  41.067  30.911  1.00 14.49      A    O  
ATOM   1647  N   LEU   229      15.489  39.093  31.927  1.00 13.32      A    N  
ATOM   1648  CA  LEU   229      14.704  38.316  30.970  1.00 12.69      A    C  
ATOM   1649  CB  LEU   229      15.624  37.410  30.137  1.00 12.91      A    C  
ATOM   1650  CG  LEU   229      16.713  38.104  29.320  1.00 13.86      A    C  
ATOM   1651  CD1 LEU   229      17.614  37.056  28.648  1.00 15.17      A    C  
ATOM   1652  CD2 LEU   229      16.093  39.053  28.283  1.00 14.82      A    C  
ATOM   1653  C   LEU   229      13.694  37.447  31.702  1.00 12.18      A    C  
ATOM   1654  O   LEU   229      14.059  36.702  32.600  1.00 11.13      A    O  
ATOM   1655  N   CYS   230      12.418  37.551  31.320  1.00 10.88      A    N  
ATOM   1656  CA  CYS   230      11.374  36.735  31.931  1.00 11.08      A    C  
ATOM   1657  CB  CYS   230      10.411  37.568  32.793  1.00 11.08      A    C  
ATOM   1658  SG  CYS   230       9.250  36.533  33.681  1.00 14.08      A    S  
ATOM   1659  C   CYS   230      10.608  36.025  30.832  1.00 10.66      A    C  
ATOM   1660  O   CYS   230       9.745  36.610  30.179  1.00 11.14      A    O  
ATOM   1661  N   LYS   231      10.937  34.756  30.624  1.00 10.29      A    N  
ATOM   1662  CA  LYS   231      10.368  33.967  29.558  1.00  9.63      A    C  
ATOM   1663  CB  LYS   231      11.241  32.718  29.365  1.00  9.58      A    C  
ATOM   1664  CG  LYS   231      10.856  31.787  28.219  1.00 10.04      A    C  
ATOM   1665  CD  LYS   231      11.997  30.778  28.038  1.00 10.56      A    C  
ATOM   1666  CE  LYS   231      11.748  29.766  26.939  1.00 11.08      A    C  
ATOM   1667  NZ  LYS   231      12.935  28.823  26.874  1.00 11.14      A    N  
ATOM   1668  C   LYS   231       8.926  33.562  29.848  1.00  9.99      A    C  
ATOM   1669  O   LYS   231       8.500  33.465  31.008  1.00  9.09      A    O  
ATOM   1670  N   GLY   232       8.178  33.324  28.778  1.00 10.35      A    N  
ATOM   1671  CA  GLY   232       6.808  32.826  28.886  1.00 10.08      A    C  
ATOM   1672  C   GLY   232       6.544  31.773  27.822  1.00  9.90      A    C  
ATOM   1673  O   GLY   232       6.889  31.947  26.656  1.00 10.29      A    O  
ATOM   1674  N   SER   233       5.935  30.681  28.237  1.00  9.00      A    N  
ATOM   1675  CA  SER   233       5.628  29.575  27.322  1.00  9.36      A    C  
ATOM   1676  CB  SER   233       6.169  28.264  27.884  1.00  9.85      A    C  
ATOM   1677  OG  SER   233       7.594  28.307  27.972  1.00 10.35      A    O  
ATOM   1678  C   SER   233       4.126  29.446  27.139  1.00  9.52      A    C  
ATOM   1679  O   SER   233       3.358  29.584  28.101  1.00  8.77      A    O  
ATOM   1680  N   TYR   234       3.729  29.161  25.904  1.00  9.82      A    N  
ATOM   1681  CA  TYR   234       2.329  28.898  25.569  1.00  9.97      A    C  
ATOM   1682  CB  TYR   234       1.892  29.765  24.397  1.00 10.24      A    C  
ATOM   1683  CG  TYR   234       1.810  31.257  24.618  1.00 10.05      A    C  
ATOM   1684  CD1 TYR   234       0.588  31.870  24.924  1.00 11.14      A    C  
ATOM   1685  CE1 TYR   234       0.492  33.248  25.099  1.00 12.66      A    C  
ATOM   1686  CZ  TYR   234       1.615  34.033  24.938  1.00 13.31      A    C  
ATOM   1687  OH  TYR   234       1.518  35.410  25.101  1.00 14.00      A    O  
ATOM   1688  CE2 TYR   234       2.834  33.457  24.629  1.00 12.53      A    C  
ATOM   1689  CD2 TYR   234       2.934  32.064  24.471  1.00 12.37      A    C  
ATOM   1690  C   TYR   234       2.158  27.456  25.098  1.00 10.53      A    C  
ATOM   1691  O   TYR   234       3.051  26.898  24.445  1.00 10.21      A    O  
ATOM   1692  N   PHE   235       0.994  26.888  25.385  1.00 10.27      A    N  
ATOM   1693  CA  PHE   235       0.609  25.583  24.859  1.00 11.24      A    C  
ATOM   1694  CB  PHE   235       0.581  24.562  25.987  1.00 11.15      A    C  
ATOM   1695  CG  PHE   235       1.929  24.390  26.604  1.00 12.28      A    C  
ATOM   1696  CD1 PHE   235       2.827  23.487  26.062  1.00 11.31      A    C  
ATOM   1697  CE1 PHE   235       4.105  23.345  26.609  1.00 12.46      A    C  
ATOM   1698  CZ  PHE   235       4.499  24.155  27.670  1.00 12.52      A    C  
ATOM   1699  CE2 PHE   235       3.608  25.073  28.199  1.00 13.39      A    C  
ATOM   1700  CD2 PHE   235       2.339  25.199  27.650  1.00 11.84      A    C  
ATOM   1701  C   PHE   235      -0.701  25.693  24.145  1.00 11.95      A    C  
ATOM   1702  O   PHE   235      -1.514  26.550  24.463  1.00 12.43      A    O  
ATOM   1703  N   THR   236      -0.892  24.839  23.150  1.00 12.35      A    N  
ATOM   1704  CA  THR   236      -2.040  24.959  22.281  1.00 12.91      A    C  
ATOM   1705  CB  THR   236      -1.617  25.096  20.816  1.00 12.85      A    C  
ATOM   1706  OG1 THR   236      -0.869  23.935  20.432  1.00 14.79      A    O  
ATOM   1707  CG2 THR   236      -0.759  26.369  20.609  1.00 13.66      A    C  
ATOM   1708  C   THR   236      -2.992  23.785  22.460  1.00 13.85      A    C  
ATOM   1709  O   THR   236      -2.622  22.726  22.976  1.00 13.49      A    O  
ATOM   1710  N   LEU   237      -4.235  23.997  22.050  1.00 14.70      A    N  
ATOM   1711  CA  LEU   237      -5.272  22.996  22.164  1.00 16.57      A    C  
ATOM   1712  CB  LEU   237      -6.407  23.511  23.054  1.00 16.03      A    C  
ATOM   1713  CG  LEU   237      -7.596  22.577  23.295  1.00 16.60      A    C  
ATOM   1714  CD1 LEU   237      -7.296  21.552  24.388  1.00 14.34      A    C  
ATOM   1715  CD2 LEU   237      -8.818  23.386  23.687  1.00 16.05      A    C  
ATOM   1716  C   LEU   237      -5.783  22.717  20.758  1.00 18.19      A    C  
ATOM   1717  O   LEU   237      -6.296  23.612  20.087  1.00 18.01      A    O  
ATOM   1718  N   ALA   238      -5.606  21.483  20.304  1.00 20.35      A    N  
ATOM   1719  CA  ALA   238      -6.154  21.067  19.021  1.00 22.96      A    C  
ATOM   1720  CB  ALA   238      -5.573  19.715  18.604  1.00 22.72      A    C  
ATOM   1721  C   ALA   238      -7.670  20.985  19.103  1.00 24.35      A    C  
ATOM   1722  O   ALA   238      -8.237  20.646  20.142  1.00 25.10      A    O  
ATOM   1723  N   GLY   239      -8.338  21.295  18.002  1.00 26.36      A    N  
ATOM   1724  CA  GLY   239      -9.763  21.013  17.913  1.00 27.67      A    C  
ATOM   1725  C   GLY   239     -10.698  22.091  18.429  1.00 28.61      A    C  
ATOM   1726  O   GLY   239     -11.655  21.801  19.148  1.00 29.28      A    O  
ATOM   1727  N   ARG   240     -10.440  23.340  18.061  1.00 29.10           N  
ATOM   1728  CA  ARG   240     -11.454  24.383  18.262  1.00 29.55           C  
ATOM   1729  CB  ARG   240     -12.710  24.092  17.430  1.00 30.53           C  
ATOM   1730  CG  ARG   240     -12.474  24.085  15.925  1.00 33.58           C  
ATOM   1731  CD  ARG   240     -13.762  23.880  15.149  1.00 38.33           C  
ATOM   1732  NE  ARG   240     -13.495  23.869  13.714  1.00 41.74           N  
ATOM   1733  CZ  ARG   240     -14.407  24.096  12.772  1.00 43.52           C  
ATOM   1734  NH1 ARG   240     -15.671  24.360  13.105  1.00 44.69           N  
ATOM   1735  NH2 ARG   240     -14.051  24.066  11.490  1.00 43.91           N  
ATOM   1736  C   ARG   240     -11.832  24.549  19.739  1.00 28.00           C  
ATOM   1737  O   ARG   240     -12.019  23.574  20.478  1.00 28.31      A    O  
ATOM   1738  N   ALA   241     -11.964  25.806  20.141  1.00 26.48      A    N  
ATOM   1739  CA  ALA   241     -11.861  26.187  21.535  1.00 23.91      A    C  
ATOM   1740  CB  ALA   241     -11.409  27.635  21.645  1.00 23.72      A    C  
ATOM   1741  C   ALA   241     -13.132  25.949  22.341  1.00 22.42      A    C  
ATOM   1742  O   ALA   241     -14.230  25.928  21.794  1.00 22.61      A    O  
ATOM   1743  N   PRO   242     -12.979  25.758  23.655  1.00 20.76      A    N  
ATOM   1744  CA  PRO   242     -14.138  25.532  24.494  1.00 19.21      A    C  
ATOM   1745  CB  PRO   242     -13.541  24.895  25.752  1.00 19.39      A    C  
ATOM   1746  CG  PRO   242     -12.134  25.379  25.811  1.00 20.04      A    C  
ATOM   1747  CD  PRO   242     -11.704  25.592  24.385  1.00 20.59      A    C  
ATOM   1748  C   PRO   242     -14.856  26.844  24.850  1.00 17.67      A    C  
ATOM   1749  O   PRO   242     -15.957  26.801  25.390  1.00 16.99      A    O  
ATOM   1750  N   PHE   243     -14.235  27.983  24.528  1.00 15.95      A    N  
ATOM   1751  CA  PHE   243     -14.766  29.293  24.913  1.00 14.67      A    C  
ATOM   1752  CB  PHE   243     -13.920  29.905  26.044  1.00 15.00      A    C  
ATOM   1753  CG  PHE   243     -13.950  29.112  27.324  1.00 15.67      A    C  
ATOM   1754  CD1 PHE   243     -15.092  29.062  28.094  1.00 18.34      A    C  
ATOM   1755  CE1 PHE   243     -15.122  28.326  29.287  1.00 20.63      A    C  
ATOM   1756  CZ  PHE   243     -14.010  27.635  29.693  1.00 19.05      A    C  
ATOM   1757  CE2 PHE   243     -12.865  27.676  28.938  1.00 19.00      A    C  
ATOM   1758  CD2 PHE   243     -12.835  28.420  27.751  1.00 18.95      A    C  
ATOM   1759  C   PHE   243     -14.781  30.240  23.722  1.00 13.78      A    C  
ATOM   1760  O   PHE   243     -13.987  30.084  22.784  1.00 13.18      A    O  
ATOM   1761  N   SER   244     -15.669  31.232  23.775  1.00 12.52      A    N  
ATOM   1762  CA  SER   244     -15.759  32.234  22.717  1.00 11.90      A    C  
ATOM   1763  CB  SER   244     -17.221  32.484  22.335  1.00 12.90      A    C  
ATOM   1764  OG  SER   244     -17.848  33.361  23.254  1.00 15.35      A    O  
ATOM   1765  C   SER   244     -15.059  33.551  23.088  1.00 10.91      A    C  
ATOM   1766  O   SER   244     -14.860  34.409  22.236  1.00 10.95      A    O  
ATOM   1767  N   ARG   245     -14.731  33.699  24.369  1.00  9.65      A    N  
ATOM   1768  CA  ARG   245     -14.036  34.882  24.894  1.00  8.30      A    C  
ATOM   1769  CB  ARG   245     -14.911  35.562  25.960  1.00  8.39      A    C  
ATOM   1770  CG  ARG   245     -16.202  36.209  25.429  1.00 10.64      A    C  
ATOM   1771  CD  ARG   245     -17.111  36.590  26.583  1.00 15.14      A    C  
ATOM   1772  NE  ARG   245     -18.334  37.245  26.104  1.00 15.71      A    N  
ATOM   1773  CZ  ARG   245     -19.429  36.586  25.752  1.00 17.46      A    C  
ATOM   1774  NH1 ARG   245     -19.447  35.253  25.794  1.00 18.23      A    N  
ATOM   1775  NH2 ARG   245     -20.500  37.252  25.340  1.00 18.18      A    N  
ATOM   1776  C   ARG   245     -12.728  34.434  25.539  1.00  7.69      A    C  
ATOM   1777  O   ARG   245     -12.555  33.255  25.883  1.00  7.79      A    O  
ATOM   1778  N   LEU   246     -11.809  35.383  25.711  1.00  6.72      A    N  
ATOM   1779  CA  LEU   246     -10.589  35.142  26.482  1.00  6.91      A    C  
ATOM   1780  CB  LEU   246      -9.657  36.349  26.374  1.00  6.90      A    C  
ATOM   1781  CG  LEU   246      -9.406  36.891  24.966  1.00  7.52      A    C  
ATOM   1782  CD1 LEU   246      -8.399  38.008  25.075  1.00  7.96      A    C  
ATOM   1783  CD2 LEU   246      -8.882  35.808  24.008  1.00  7.60      A    C  
ATOM   1784  C   LEU   246     -10.946  34.918  27.944  1.00  6.90      A    C  
ATOM   1785  O   LEU   246     -11.898  35.516  28.459  1.00  6.64      A    O  
ATOM   1786  N   ILE   247     -10.188  34.049  28.622  1.00  6.47      A    N  
ATOM   1787  CA  ILE   247     -10.391  33.828  30.046  1.00  7.04      A    C  
ATOM   1788  CB  ILE   247     -10.809  32.383  30.359  1.00  7.69      A    C  
ATOM   1789  CG1 ILE   247     -12.036  31.980  29.524  1.00  7.94      A    C  
ATOM   1790  CD1 ILE   247     -13.328  32.787  29.804  1.00  9.23      A    C  
ATOM   1791  CG2 ILE   247     -11.017  32.201  31.879  1.00  7.54      A    C  
ATOM   1792  C   ILE   247      -9.096  34.128  30.808  1.00  7.59      A    C  
ATOM   1793  O   ILE   247      -8.041  33.566  30.490  1.00  7.66      A    O  
ATOM   1794  N   TYR   248      -9.183  35.037  31.774  1.00  6.63      A    N  
ATOM   1795  CA  TYR   248      -8.061  35.387  32.656  1.00  7.52      A    C  
ATOM   1796  CB  TYR   248      -7.717  36.877  32.522  1.00  6.90      A    C  
ATOM   1797  CG  TYR   248      -6.871  37.252  31.325  1.00  6.89      A    C  
ATOM   1798  CD1 TYR   248      -7.283  36.959  30.031  1.00  8.25      A    C  
ATOM   1799  CE1 TYR   248      -6.493  37.307  28.918  1.00  7.50      A    C  
ATOM   1800  CZ  TYR   248      -5.300  37.970  29.107  1.00  8.26      A    C  
ATOM   1801  OH  TYR   248      -4.527  38.327  28.006  1.00  8.26      A    O  
ATOM   1802  CE2 TYR   248      -4.879  38.296  30.388  1.00  8.23      A    C  
ATOM   1803  CD2 TYR   248      -5.665  37.933  31.488  1.00  6.66      A    C  
ATOM   1804  C   TYR   248      -8.436  35.148  34.119  1.00  7.85      A    C  
ATOM   1805  O   TYR   248      -9.444  35.664  34.588  1.00  7.69      A    O  
ATOM   1806  N   PRO   249      -7.607  34.411  34.878  1.00  8.01      A    N  
ATOM   1807  CA  PRO   249      -7.784  34.403  36.333  1.00  8.05      A    C  
ATOM   1808  CB  PRO   249      -6.676  33.436  36.809  1.00  8.48      A    C  
ATOM   1809  CG  PRO   249      -6.459  32.531  35.608  1.00  8.53      A    C  
ATOM   1810  CD  PRO   249      -6.546  33.480  34.439  1.00  8.42      A    C  
ATOM   1811  C   PRO   249      -7.554  35.811  36.915  1.00  8.25      A    C  
ATOM   1812  O   PRO   249      -7.012  36.677  36.224  1.00  8.85      A    O  
ATOM   1813  N   VAL   250      -7.979  36.049  38.151  1.00  8.72      A    N  
ATOM   1814  CA  VAL   250      -7.806  37.380  38.754  1.00  9.24      A    C  
ATOM   1815  CB  VAL   250      -8.527  37.510  40.115  1.00  8.62      A    C  
ATOM   1816  CG1 VAL   250     -10.028  37.359  39.916  1.00  9.05      A    C  
ATOM   1817  CG2 VAL   250      -7.981  36.471  41.143  1.00  9.59      A    C  
ATOM   1818  C   VAL   250      -6.325  37.732  38.890  1.00 10.19      A    C  
ATOM   1819  O   VAL   250      -5.478  36.850  38.996  1.00 11.06      A    O  
ATOM   1820  N   PRO   251      -6.013  39.032  38.878  1.00 11.49      A    N  
ATOM   1821  CA  PRO   251      -4.615  39.468  38.860  1.00 12.67      A    C  
ATOM   1822  CB  PRO   251      -4.699  40.998  38.995  1.00 13.04      A    C  
ATOM   1823  CG  PRO   251      -6.090  41.374  38.662  1.00 13.39      A    C  
ATOM   1824  CD  PRO   251      -6.975  40.144  38.748  1.00 11.42      A    C  
ATOM   1825  C   PRO   251      -3.823  38.892  40.025  1.00 13.50      A    C  
ATOM   1826  O   PRO   251      -2.634  38.547  39.869  1.00 14.04      A    O  
ATOM   1827  N   GLN   252      -4.471  38.784  41.184  1.00 13.91      A    N  
ATOM   1828  CA  GLN   252      -3.800  38.367  42.401  1.00 15.27      A    C  
ATOM   1829  CB  GLN   252      -4.293  39.199  43.597  1.00 15.31      A    C  
ATOM   1830  CG  GLN   252      -3.215  39.549  44.587  1.00 17.01      A    C  
ATOM   1831  CD  GLN   252      -3.704  40.492  45.674  1.00 18.72      A    C  
ATOM   1832  OE1 GLN   252      -4.049  41.651  45.402  1.00 17.92      A    O  
ATOM   1833  NE2 GLN   252      -3.720  40.005  46.915  1.00 17.66      A    N  
ATOM   1834  C   GLN   252      -3.961  36.884  42.701  1.00 15.14      A    C  
ATOM   1835  O   GLN   252      -3.677  36.432  43.816  1.00 16.38      A    O  
ATOM   1836  N   HIS   253      -4.431  36.124  41.717  1.00 15.20      A    N  
ATOM   1837  CA  HIS   253      -4.524  34.676  41.858  1.00 14.68      A    C  
ATOM   1838  CB  HIS   253      -4.903  34.044  40.513  1.00 14.79      A    C  
ATOM   1839  CG  HIS   253      -5.038  32.553  40.563  1.00 14.76      A    C  
ATOM   1840  ND1 HIS   253      -6.113  31.921  41.152  1.00 15.27      A    N  
ATOM   1841  CE1 HIS   253      -5.958  30.611  41.054  1.00 15.48      A    C  
ATOM   1842  NE2 HIS   253      -4.822  30.372  40.421  1.00 16.56      A    N  
ATOM   1843  CD2 HIS   253      -4.224  31.569  40.107  1.00 15.28      A    C  
ATOM   1844  C   HIS   253      -3.184  34.118  42.317  1.00 14.76      A    C  
ATOM   1845  O   HIS   253      -2.138  34.479  41.782  1.00 14.89      A    O  
ATOM   1846  N   ALA   254      -3.223  33.213  43.285  1.00 15.30      A    N  
ATOM   1847  CA  ALA   254      -1.996  32.664  43.859  1.00 16.18      A    C  
ATOM   1848  CB  ALA   254      -2.328  31.861  45.092  1.00 16.78      A    C  
ATOM   1849  C   ALA   254      -1.238  31.789  42.859  1.00 16.59      A    C  
ATOM   1850  O   ALA   254      -1.829  30.920  42.214  1.00 17.65      A    O  
ATOM   1851  N   GLY   255       0.063  32.029  42.727  1.00 16.56      A    N  
ATOM   1852  CA  GLY   255       0.907  31.172  41.884  1.00 16.33      A    C  
ATOM   1853  C   GLY   255       0.601  31.357  40.410  1.00 15.39      A    C  
ATOM   1854  O   GLY   255       0.450  32.485  39.937  1.00 16.73      A    O  
ATOM   1855  N   LEU   256       0.508  30.252  39.678  1.00 13.88      A    N  
ATOM   1856  CA  LEU   256       0.411  30.324  38.224  1.00 13.15      A    C  
ATOM   1857  CB  LEU   256       0.780  28.971  37.623  1.00 12.51      A    C  
ATOM   1858  CG  LEU   256       0.705  28.845  36.106  1.00 12.90      A    C  
ATOM   1859  CD1 LEU   256       1.749  29.690  35.464  1.00 11.55      A    C  
ATOM   1860  CD2 LEU   256       0.904  27.395  35.692  1.00 13.45      A    C  
ATOM   1861  C   LEU   256      -0.984  30.708  37.755  1.00 12.43      A    C  
ATOM   1862  O   LEU   256      -1.940  29.997  38.006  1.00 12.30      A    O  
ATOM   1863  N   GLY   257      -1.093  31.831  37.057  1.00 12.39      A    N  
ATOM   1864  CA  GLY   257      -2.366  32.215  36.455  1.00 11.94      A    C  
ATOM   1865  C   GLY   257      -2.323  31.976  34.962  1.00 11.42      A    C  
ATOM   1866  O   GLY   257      -1.634  32.696  34.248  1.00 12.25      A    O  
ATOM   1867  N   VAL   258      -3.048  30.961  34.498  1.00 10.57      A    N  
ATOM   1868  CA  VAL   258      -2.984  30.582  33.097  1.00  9.65      A    C  
ATOM   1869  CB  VAL   258      -3.137  29.058  32.912  1.00  9.42      A    C  
ATOM   1870  CG1 VAL   258      -3.011  28.718  31.435  1.00  9.96      A    C  
ATOM   1871  CG2 VAL   258      -2.075  28.321  33.719  1.00 10.25      A    C  
ATOM   1872  C   VAL   258      -4.097  31.250  32.313  1.00  8.69      A    C  
ATOM   1873  O   VAL   258      -5.276  31.018  32.589  1.00  8.82      A    O  
ATOM   1874  N   HIS   259      -3.720  32.091  31.355  1.00  8.69      A    N  
ATOM   1875  CA  HIS   259      -4.708  32.697  30.470  1.00  8.52      A    C  
ATOM   1876  CB  HIS   259      -4.157  33.940  29.775  1.00  8.94      A    C  
ATOM   1877  CG  HIS   259      -3.517  34.931  30.699  1.00  8.70      A    C  
ATOM   1878  ND1 HIS   259      -2.588  35.855  30.264  1.00 11.17      A    N  
ATOM   1879  CE1 HIS   259      -2.184  36.584  31.289  1.00  9.89      A    C  
ATOM   1880  NE2 HIS   259      -2.829  36.173  32.373  1.00  9.26      A    N  
ATOM   1881  CD2 HIS   259      -3.662  35.135  32.027  1.00  9.65      A    C  
ATOM   1882  C   HIS   259      -5.134  31.723  29.387  1.00  8.75      A    C  
ATOM   1883  O   HIS   259      -4.316  30.982  28.842  1.00  8.21      A    O  
ATOM   1884  N   LEU   260      -6.416  31.751  29.058  1.00  8.61      A    N  
ATOM   1885  CA  LEU   260      -6.900  31.053  27.879  1.00  9.66      A    C  
ATOM   1886  CB  LEU   260      -8.147  30.251  28.227  1.00 10.52      A    C  
ATOM   1887  CG  LEU   260      -8.652  29.286  27.155  1.00 13.49      A    C  
ATOM   1888  CD1 LEU   260      -9.657  28.342  27.788  1.00 17.17      A    C  
ATOM   1889  CD2 LEU   260      -9.279  30.057  26.026  1.00 16.43      A    C  
ATOM   1890  C   LEU   260      -7.185  32.131  26.839  1.00 10.52      A    C  
ATOM   1891  O   LEU   260      -8.030  33.010  27.054  1.00 11.23      A    O  
ATOM   1892  N   THR   261      -6.423  32.130  25.758  1.00 10.04      A    N  
ATOM   1893  CA  THR   261      -6.660  33.112  24.697  1.00 10.77      A    C  
ATOM   1894  CB  THR   261      -5.520  34.133  24.573  1.00 11.63      A    C  
ATOM   1895  OG1 THR   261      -4.338  33.465  24.116  1.00 11.35      A    O  
ATOM   1896  CG2 THR   261      -5.246  34.799  25.932  1.00 10.48      A    C  
ATOM   1897  C   THR   261      -6.942  32.398  23.365  1.00 10.91      A    C  
ATOM   1898  O   THR   261      -6.902  31.169  23.287  1.00 10.94      A    O  
ATOM   1899  N   LEU   262      -7.303  33.167  22.346  1.00 11.44      A    N  
ATOM   1900  CA  LEU   262      -7.759  32.573  21.086  1.00 12.06      A    C  
ATOM   1901  CB  LEU   262      -9.257  32.816  20.886  1.00 11.86      A    C  
ATOM   1902  CG  LEU   262     -10.225  32.119  21.861  1.00 13.23      A    C  
ATOM   1903  CD1 LEU   262     -11.575  32.859  21.908  1.00 16.99      A    C  
ATOM   1904  CD2 LEU   262     -10.415  30.624  21.528  1.00 17.13      A    C  
ATOM   1905  C   LEU   262      -6.988  33.223  19.957  1.00 12.69      A    C  
ATOM   1906  O   LEU   262      -6.642  34.406  20.032  1.00 12.48      A    O  
ATOM   1907  N   ASP   263      -6.687  32.449  18.921  1.00 13.40      A    N  
ATOM   1908  CA  ASP   263      -6.116  33.060  17.729  1.00 15.29      A    C  
ATOM   1909  CB  ASP   263      -5.002  32.205  17.105  1.00 16.06      A    C  
ATOM   1910  CG  ASP   263      -5.496  30.896  16.566  1.00 18.95      A    C  
ATOM   1911  OD1 ASP   263      -6.674  30.822  16.152  1.00 22.94      A    O  
ATOM   1912  OD2 ASP   263      -4.685  29.936  16.531  1.00 24.02      A    O  
ATOM   1913  C   ASP   263      -7.252  33.389  16.761  1.00 15.40      A    C  
ATOM   1914  O   ASP   263      -8.402  33.042  17.010  1.00 15.48      A    O  
ATOM   1915  N   LEU   264      -6.938  34.090  15.680  1.00 16.38      A    N  
ATOM   1916  CA  LEU   264      -7.959  34.531  14.748  1.00 17.60      A    C  
ATOM   1917  CB  LEU   264      -7.346  35.483  13.731  1.00 18.04      A    C  
ATOM   1918  CG  LEU   264      -7.108  36.889  14.284  1.00 18.95      A    C  
ATOM   1919  CD1 LEU   264      -6.402  37.738  13.241  1.00 20.48      A    C  
ATOM   1920  CD2 LEU   264      -8.429  37.520  14.675  1.00 20.84      A    C  
ATOM   1921  C   LEU   264      -8.685  33.378  14.051  1.00 18.29      A    C  
ATOM   1922  O   LEU   264      -9.833  33.525  13.620  1.00 18.22      A    O  
ATOM   1923  N   GLY   265      -8.016  32.234  13.960  1.00 18.52      A    N  
ATOM   1924  CA  GLY   265      -8.620  31.038  13.369  1.00 19.30      A    C  
ATOM   1925  C   GLY   265      -9.548  30.300  14.320  1.00 19.32      A    C  
ATOM   1926  O   GLY   265     -10.167  29.304  13.942  1.00 20.36      A    O  
ATOM   1927  N   GLY   266      -9.637  30.771  15.565  1.00 18.85      A    N  
ATOM   1928  CA  GLY   266     -10.577  30.211  16.536  1.00 17.59      A    C  
ATOM   1929  C   GLY   266      -9.999  29.184  17.493  1.00 17.14      A    C  
ATOM   1930  O   GLY   266     -10.731  28.623  18.318  1.00 17.58      A    O  
ATOM   1931  N   GLN   267      -8.692  28.935  17.395  1.00 16.26      A    N  
ATOM   1932  CA  GLN   267      -8.055  27.892  18.210  1.00 15.98      A    C  
ATOM   1933  CB  GLN   267      -6.863  27.292  17.476  1.00 16.35      A    C  
ATOM   1934  CG  GLN   267      -7.210  26.755  16.080  1.00 21.10      A    C  
ATOM   1935  CD  GLN   267      -7.859  25.373  16.091  1.00 26.43      A    C  
ATOM   1936  OE1 GLN   267      -8.851  25.129  16.782  1.00 30.29      A    O  
ATOM   1937  NE2 GLN   267      -7.306  24.463  15.290  1.00 30.58      A    N  
ATOM   1938  C   GLN   267      -7.609  28.471  19.541  1.00 14.60      A    C  
ATOM   1939  O   GLN   267      -7.183  29.624  19.593  1.00 14.37      A    O  
ATOM   1940  N   ALA   268      -7.710  27.676  20.606  1.00 13.38      A    N  
ATOM   1941  CA  ALA   268      -7.384  28.160  21.941  1.00 12.52      A    C  
ATOM   1942  CB  ALA   268      -8.259  27.471  22.988  1.00 13.02      A    C  
ATOM   1943  C   ALA   268      -5.915  27.917  22.246  1.00 11.90      A    C  
ATOM   1944  O   ALA   268      -5.331  26.927  21.801  1.00 12.23      A    O  
ATOM   1945  N   LYS   269      -5.314  28.826  22.995  1.00 10.24      A    N  
ATOM   1946  CA  LYS   269      -3.986  28.578  23.550  1.00 10.60      A    C  
ATOM   1947  CB  LYS   269      -2.871  29.230  22.738  1.00 11.48      A    C  
ATOM   1948  CG  LYS   269      -2.947  30.716  22.716  1.00 13.20      A    C  
ATOM   1949  CD  LYS   269      -1.853  31.356  21.843  1.00 17.38      A    C  
ATOM   1950  CE  LYS   269      -2.293  32.753  21.451  1.00 20.16      A    C  
ATOM   1951  NZ  LYS   269      -1.334  33.490  20.577  1.00 20.54      A    N  
ATOM   1952  C   LYS   269      -3.938  28.996  25.012  1.00 10.06      A    C  
ATOM   1953  O   LYS   269      -4.770  29.771  25.472  1.00  9.28      A    O  
ATOM   1954  N   PHE   270      -2.968  28.441  25.735  1.00  8.64      A    N  
ATOM   1955  CA  PHE   270      -2.882  28.636  27.175  1.00  9.31      A    C  
ATOM   1956  CB  PHE   270      -3.107  27.301  27.876  1.00 10.08      A    C  
ATOM   1957  CG  PHE   270      -4.514  26.808  27.745  1.00 11.56      A    C  
ATOM   1958  CD1 PHE   270      -5.493  27.252  28.622  1.00 15.06      A    C  
ATOM   1959  CE1 PHE   270      -6.813  26.837  28.497  1.00 15.20      A    C  
ATOM   1960  CZ  PHE   270      -7.158  25.955  27.482  1.00 15.93      A    C  
ATOM   1961  CE2 PHE   270      -6.192  25.526  26.583  1.00 14.70      A    C  
ATOM   1962  CD2 PHE   270      -4.866  25.956  26.722  1.00 16.44      A    C  
ATOM   1963  C   PHE   270      -1.530  29.190  27.518  1.00  8.87      A    C  
ATOM   1964  O   PHE   270      -0.529  28.749  26.955  1.00  8.57      A    O  
ATOM   1965  N   GLY   271      -1.503  30.146  28.445  1.00  8.10      A    N  
ATOM   1966  CA  GLY   271      -0.254  30.823  28.796  1.00  8.35      A    C  
ATOM   1967  C   GLY   271      -0.336  32.310  28.536  1.00  8.42      A    C  
ATOM   1968  O   GLY   271      -1.385  32.808  28.124  1.00  8.25      A    O  
ATOM   1969  N   PRO   272       0.782  33.024  28.732  1.00  8.68      A    N  
ATOM   1970  CA  PRO   272       2.107  32.459  29.043  1.00  8.92      A    C  
ATOM   1971  CB  PRO   272       3.045  33.569  28.563  1.00  9.05      A    C  
ATOM   1972  CG  PRO   272       2.256  34.840  28.942  1.00  9.03      A    C  
ATOM   1973  CD  PRO   272       0.841  34.490  28.557  1.00  8.18      A    C  
ATOM   1974  C   PRO   272       2.352  32.239  30.533  1.00  9.61      A    C  
ATOM   1975  O   PRO   272       1.695  32.863  31.384  1.00  9.74      A    O  
ATOM   1976  N   ASP   273       3.305  31.366  30.862  1.00  9.99      A    N  
ATOM   1977  CA  ASP   273       3.746  31.278  32.240  1.00  9.85      A    C  
ATOM   1978  CB  ASP   273       4.195  29.841  32.616  1.00  9.69      A    C  
ATOM   1979  CG  ASP   273       5.453  29.387  31.881  1.00 10.66      A    C  
ATOM   1980  OD1 ASP   273       5.979  30.139  31.040  1.00 10.49      A    O  
ATOM   1981  OD2 ASP   273       5.917  28.246  32.154  1.00 12.27      A    O  
ATOM   1982  C   ASP   273       4.850  32.299  32.470  1.00  9.78      A    C  
ATOM   1983  O   ASP   273       5.055  33.214  31.638  1.00  9.27      A    O  
ATOM   1984  N   THR   274       5.547  32.158  33.595  1.00 10.55      A    N  
ATOM   1985  CA  THR   274       6.660  33.056  33.909  1.00 11.27      A    C  
ATOM   1986  CB  THR   274       6.322  34.072  35.011  1.00 12.04      A    C  
ATOM   1987  OG1 THR   274       5.862  33.379  36.167  1.00 14.76      A    O  
ATOM   1988  CG2 THR   274       5.248  35.032  34.541  1.00 11.04      A    C  
ATOM   1989  C   THR   274       7.901  32.272  34.325  1.00 11.15      A    C  
ATOM   1990  O   THR   274       7.835  31.367  35.162  1.00 12.09      A    O  
ATOM   1991  N   GLU   275       9.025  32.653  33.741  1.00 10.62      A    N  
ATOM   1992  CA  GLU   275      10.268  31.926  33.968  1.00 10.76      A    C  
ATOM   1993  CB  GLU   275      10.368  30.782  32.959  1.00 10.82      A    C  
ATOM   1994  CG  GLU   275      11.597  29.872  33.165  1.00 12.29      A    C  
ATOM   1995  CD  GLU   275      11.835  28.931  32.002  1.00 15.29      A    C  
ATOM   1996  OE1 GLU   275      12.893  28.229  32.001  1.00 14.65      A    O  
ATOM   1997  OE2 GLU   275      10.980  28.881  31.084  1.00 11.82      A    O  
ATOM   1998  C   GLU   275      11.452  32.866  33.805  1.00 10.62      A    C  
ATOM   1999  O   GLU   275      11.833  33.208  32.686  1.00  9.94      A    O  
ATOM   2000  N   TRP   276      12.040  33.279  34.925  1.00 11.47      A    N  
ATOM   2001  CA  TRP   276      13.182  34.184  34.858  1.00 11.40      A    C  
ATOM   2002  CB  TRP   276      13.425  34.853  36.213  1.00 11.92      A    C  
ATOM   2003  CG  TRP   276      12.284  35.761  36.620  1.00 12.48      A    C  
ATOM   2004  CD1 TRP   276      11.097  35.382  37.190  1.00 14.61      A    C  
ATOM   2005  NE1 TRP   276      10.303  36.489  37.406  1.00 16.05      A    N  
ATOM   2006  CE2 TRP   276      10.974  37.606  36.980  1.00 15.55      A    C  
ATOM   2007  CD2 TRP   276      12.226  37.186  36.478  1.00 13.93      A    C  
ATOM   2008  CE3 TRP   276      13.108  38.147  35.968  1.00 13.89      A    C  
ATOM   2009  CZ3 TRP   276      12.724  39.483  35.988  1.00 12.81      A    C  
ATOM   2010  CH2 TRP   276      11.482  39.870  36.505  1.00 13.78      A    C  
ATOM   2011  CZ2 TRP   276      10.590  38.953  36.999  1.00 13.37      A    C  
ATOM   2012  C   TRP   276      14.406  33.401  34.418  1.00 11.85      A    C  
ATOM   2013  O   TRP   276      14.698  32.349  34.993  1.00 12.20      A    O  
ATOM   2014  N   ILE   277      15.088  33.904  33.392  1.00 11.57      A    N  
ATOM   2015  CA  ILE   277      16.202  33.196  32.775  1.00 11.71      A    C  
ATOM   2016  CB  ILE   277      15.816  32.558  31.422  1.00 11.61      A    C  
ATOM   2017  CG1 ILE   277      15.292  33.628  30.441  1.00 12.57      A    C  
ATOM   2018  CD1 ILE   277      15.054  33.139  29.003  1.00 13.97      A    C  
ATOM   2019  CG2 ILE   277      14.806  31.459  31.656  1.00 10.36      A    C  
ATOM   2020  C   ILE   277      17.420  34.094  32.591  1.00 12.72      A    C  
ATOM   2021  O   ILE   277      17.313  35.316  32.642  1.00 13.24      A    O  
ATOM   2022  N   ALA   278      18.573  33.473  32.357  1.00 13.28      A    N  
ATOM   2023  CA  ALA   278      19.847  34.188  32.279  1.00 14.04      A    C  
ATOM   2024  CB  ALA   278      20.958  33.315  32.878  1.00 14.41      A    C  
ATOM   2025  C   ALA   278      20.253  34.618  30.868  1.00 14.68      A    C  
ATOM   2026  O   ALA   278      21.076  35.527  30.702  1.00 15.66      A    O  
ATOM   2027  N   THR   279      19.738  33.921  29.859  1.00 14.41      A    N  
ATOM   2028  CA  THR   279      20.135  34.169  28.482  1.00 15.06      A    C  
ATOM   2029  CB  THR   279      21.205  33.163  27.999  1.00 14.74      A    C  
ATOM   2030  OG1 THR   279      20.605  31.872  27.844  1.00 16.89      A    O  
ATOM   2031  CG2 THR   279      22.352  33.056  29.002  1.00 17.10      A    C  
ATOM   2032  C   THR   279      18.933  34.054  27.565  1.00 14.88      A    C  
ATOM   2033  O   THR   279      17.903  33.500  27.955  1.00 14.75      A    O  
ATOM   2034  N   GLU   280      19.082  34.572  26.346  1.00 15.09      A    N  
ATOM   2035  CA  GLU   280      17.990  34.642  25.385  1.00 15.97      A    C  
ATOM   2036  CB  GLU   280      18.277  35.734  24.351  1.00 16.40      A    C  
ATOM   2037  CG  GLU   280      17.062  36.105  23.512  1.00 16.26      A    C  
ATOM   2038  CD  GLU   280      17.353  37.197  22.503  1.00 17.86      A    C  
ATOM   2039  OE1 GLU   280      18.480  37.743  22.516  1.00 17.75      A    O  
ATOM   2040  OE2 GLU   280      16.447  37.510  21.699  1.00 15.48      A    O  
ATOM   2041  C   GLU   280      17.781  33.319  24.672  1.00 16.35      A    C  
ATOM   2042  O   GLU   280      18.318  33.093  23.575  1.00 17.34      A    O  
ATOM   2043  N   ASP   281      16.976  32.459  25.280  1.00 16.27      A    N  
ATOM   2044  CA  ASP   281      16.787  31.103  24.811  1.00 15.94      A    C  
ATOM   2045  CB  ASP   281      17.349  30.156  25.848  1.00 16.71      A    C  
ATOM   2046  CG  ASP   281      17.211  28.714  25.451  1.00 19.98      A    C  
ATOM   2047  OD1 ASP   281      16.590  28.437  24.404  1.00 22.88      A    O  
ATOM   2048  OD2 ASP   281      17.740  27.860  26.198  1.00 24.64      A    O  
ATOM   2049  C   ASP   281      15.296  30.830  24.614  1.00 15.49      A    C  
ATOM   2050  O   ASP   281      14.542  30.828  25.582  1.00 15.13      A    O  
ATOM   2051  N   TYR   282      14.884  30.622  23.368  1.00 15.22      A    N  
ATOM   2052  CA  TYR   282      13.450  30.475  23.022  1.00 15.44      A    C  
ATOM   2053  CB  TYR   282      13.120  31.173  21.694  1.00 15.29      A    C  
ATOM   2054  CG  TYR   282      13.325  32.658  21.760  1.00 16.45      A    C  
ATOM   2055  CD1 TYR   282      12.366  33.484  22.340  1.00 16.25      A    C  
ATOM   2056  CE1 TYR   282      12.565  34.837  22.436  1.00 16.29      A    C  
ATOM   2057  CZ  TYR   282      13.737  35.389  21.938  1.00 16.47      A    C  
ATOM   2058  OH  TYR   282      13.940  36.741  22.031  1.00 18.48      A    O  
ATOM   2059  CE2 TYR   282      14.695  34.591  21.355  1.00 16.16      A    C  
ATOM   2060  CD2 TYR   282      14.487  33.236  21.274  1.00 15.31      A    C  
ATOM   2061  C   TYR   282      12.974  29.036  22.964  1.00 15.74      A    C  
ATOM   2062  O   TYR   282      11.809  28.772  22.639  1.00 15.76      A    O  
ATOM   2063  N   THR   283      13.872  28.106  23.270  1.00 16.29      A    N  
ATOM   2064  CA  THR   283      13.540  26.694  23.216  1.00 16.87      A    C  
ATOM   2065  CB  THR   283      14.729  25.826  23.644  1.00 17.42      A    C  
ATOM   2066  OG1 THR   283      15.899  26.263  22.946  1.00 19.92      A    O  
ATOM   2067  CG2 THR   283      14.468  24.360  23.320  1.00 18.08      A    C  
ATOM   2068  C   THR   283      12.339  26.359  24.096  1.00 16.86      A    C  
ATOM   2069  O   THR   283      12.297  26.708  25.266  1.00 15.97      A    O  
ATOM   2070  N   LEU   284      11.362  25.665  23.519  1.00 17.40      A    N  
ATOM   2071  CA  LEU   284      10.183  25.252  24.271  1.00 17.56      A    C  
ATOM   2072  CB  LEU   284       8.997  25.061  23.323  1.00 17.84      A    C  
ATOM   2073  CG  LEU   284       7.692  24.549  23.951  1.00 18.55      A    C  
ATOM   2074  CD1 LEU   284       7.000  25.612  24.813  1.00 20.18      A    C  
ATOM   2075  CD2 LEU   284       6.745  24.055  22.881  1.00 20.17      A    C  
ATOM   2076  C   LEU   284      10.419  23.968  25.070  1.00 17.57      A    C  
ATOM   2077  O   LEU   284      10.850  22.939  24.518  1.00 18.00      A    O  
ATOM   2078  N   ASP   285      10.145  24.030  26.370  1.00 16.60      A    N  
ATOM   2079  CA  ASP   285      10.186  22.856  27.220  1.00 17.28      A    C  
ATOM   2080  CB  ASP   285      10.779  23.206  28.585  1.00 17.02      A    C  
ATOM   2081  CG  ASP   285      10.878  22.006  29.514  1.00 18.78      A    C  
ATOM   2082  OD1 ASP   285      10.399  20.910  29.164  1.00 18.34      A    O  
ATOM   2083  OD2 ASP   285      11.442  22.164  30.619  1.00 21.24      A    O  
ATOM   2084  C   ASP   285       8.764  22.347  27.380  1.00 17.24      A    C  
ATOM   2085  O   ASP   285       7.975  22.935  28.125  1.00 16.97      A    O  
ATOM   2086  N   PRO   286       8.418  21.263  26.667  1.00 17.26      A    N  
ATOM   2087  CA  PRO   286       7.056  20.743  26.719  1.00 17.54      A    C  
ATOM   2088  CB  PRO   286       7.129  19.466  25.872  1.00 17.50      A    C  
ATOM   2089  CG  PRO   286       8.298  19.666  24.974  1.00 18.33      A    C  
ATOM   2090  CD  PRO   286       9.285  20.459  25.791  1.00 17.69      A    C  
ATOM   2091  C   PRO   286       6.624  20.394  28.135  1.00 17.34      A    C  
ATOM   2092  O   PRO   286       5.423  20.382  28.431  1.00 17.57      A    O  
ATOM   2093  N   ARG   287       7.586  20.103  29.006  1.00 17.57      A    N  
ATOM   2094  CA  ARG   287       7.267  19.708  30.374  1.00 17.64      A    C  
ATOM   2095  CB  ARG   287       8.468  19.049  31.063  1.00 18.31      A    C  
ATOM   2096  CG  ARG   287       8.897  17.733  30.394  1.00 22.54      A    C  
ATOM   2097  CD  ARG   287       7.687  16.877  30.034  1.00 27.59      A    C  
ATOM   2098  NE  ARG   287       7.130  16.192  31.197  1.00 32.67      A    N  
ATOM   2099  CZ  ARG   287       5.889  15.711  31.256  1.00 35.40      A    C  
ATOM   2100  NH1 ARG   287       5.064  15.869  30.231  1.00 36.13      A    N  
ATOM   2101  NH2 ARG   287       5.461  15.091  32.355  1.00 37.15      A    N  
ATOM   2102  C   ARG   287       6.716  20.853  31.216  1.00 16.94      A    C  
ATOM   2103  O   ARG   287       6.134  20.629  32.268  1.00 17.31      A    O  
ATOM   2104  N   ARG   288       6.875  22.083  30.734  1.00 15.87      A    N  
ATOM   2105  CA  ARG   288       6.365  23.230  31.472  1.00 14.59      A    C  
ATOM   2106  CB  ARG   288       6.936  24.536  30.909  1.00 14.24      A    C  
ATOM   2107  CG  ARG   288       8.441  24.735  31.179  1.00 13.41      A    C  
ATOM   2108  CD  ARG   288       8.886  26.175  30.981  1.00 14.26      A    C  
ATOM   2109  NE  ARG   288       8.313  27.029  32.022  1.00 13.59      A    N  
ATOM   2110  CZ  ARG   288       8.821  27.191  33.239  1.00 14.84      A    C  
ATOM   2111  NH1 ARG   288       9.934  26.549  33.599  1.00 13.13      A    N  
ATOM   2112  NH2 ARG   288       8.203  27.985  34.105  1.00 13.55      A    N  
ATOM   2113  C   ARG   288       4.829  23.257  31.479  1.00 13.80      A    C  
ATOM   2114  O   ARG   288       4.213  23.954  32.300  1.00 12.53      A    O  
ATOM   2115  N   ALA   289       4.217  22.487  30.581  1.00 13.00      A    N  
ATOM   2116  CA  ALA   289       2.752  22.351  30.572  1.00 12.95      A    C  
ATOM   2117  CB  ALA   289       2.268  21.718  29.257  1.00 13.05      A    C  
ATOM   2118  C   ALA   289       2.201  21.553  31.762  1.00 12.66      A    C  
ATOM   2119  O   ALA   289       1.017  21.620  32.074  1.00 12.60      A    O  
ATOM   2120  N   ASP   290       3.044  20.760  32.417  1.00 13.55      A    N  
ATOM   2121  CA  ASP   290       2.541  19.898  33.475  1.00 13.88      A    C  
ATOM   2122  CB  ASP   290       3.702  19.117  34.111  1.00 14.93      A    C  
ATOM   2123  CG  ASP   290       4.303  18.102  33.169  1.00 18.97      A    C  
ATOM   2124  OD1 ASP   290       3.702  17.847  32.102  1.00 22.29      A    O  
ATOM   2125  OD2 ASP   290       5.366  17.529  33.510  1.00 22.42      A    O  
ATOM   2126  C   ASP   290       1.740  20.647  34.558  1.00 13.43      A    C  
ATOM   2127  O   ASP   290       0.681  20.189  34.999  1.00 12.95      A    O  
ATOM   2128  N   VAL   291       2.241  21.805  34.979  1.00 12.94      A    N  
ATOM   2129  CA  VAL   291       1.579  22.575  36.025  1.00 12.20      A    C  
ATOM   2130  CB  VAL   291       2.554  23.571  36.672  1.00 12.87      A    C  
ATOM   2131  CG1 VAL   291       3.669  22.836  37.399  1.00 13.57      A    C  
ATOM   2132  CG2 VAL   291       3.136  24.471  35.635  1.00 12.19      A    C  
ATOM   2133  C   VAL   291       0.364  23.350  35.495  1.00 12.43      A    C  
ATOM   2134  O   VAL   291      -0.433  23.885  36.280  1.00 12.01      A    O  
ATOM   2135  N   PHE   292       0.240  23.442  34.168  1.00 11.95      A    N  
ATOM   2136  CA  PHE   292      -0.914  24.152  33.578  1.00 10.92      A    C  
ATOM   2137  CB  PHE   292      -0.783  24.271  32.058  1.00 11.04      A    C  
ATOM   2138  CG  PHE   292       0.084  25.418  31.582  1.00 10.23      A    C  
ATOM   2139  CD1 PHE   292       1.360  25.624  32.097  1.00 10.82      A    C  
ATOM   2140  CE1 PHE   292       2.176  26.666  31.613  1.00 11.82      A    C  
ATOM   2141  CZ  PHE   292       1.696  27.517  30.616  1.00 10.93      A    C  
ATOM   2142  CE2 PHE   292       0.426  27.298  30.083  1.00 10.64      A    C  
ATOM   2143  CD2 PHE   292      -0.366  26.258  30.563  1.00 10.22      A    C  
ATOM   2144  C   PHE   292      -2.238  23.453  33.884  1.00 11.02      A    C  
ATOM   2145  O   PHE   292      -3.282  24.107  34.008  1.00 10.60      A    O  
ATOM   2146  N   TYR   293      -2.209  22.127  33.970  1.00  9.73      A    N  
ATOM   2147  CA  TYR   293      -3.455  21.374  34.016  1.00  9.69      A    C  
ATOM   2148  CB  TYR   293      -3.162  19.869  33.976  1.00  9.58      A    C  
ATOM   2149  CG  TYR   293      -2.775  19.407  32.593  1.00  9.06      A    C  
ATOM   2150  CD1 TYR   293      -3.750  18.990  31.689  1.00 11.13      A    C  
ATOM   2151  CE1 TYR   293      -3.423  18.569  30.413  1.00 10.53      A    C  
ATOM   2152  CZ  TYR   293      -2.108  18.560  30.016  1.00 10.33      A    C  
ATOM   2153  OH  TYR   293      -1.790  18.143  28.740  1.00 13.17      A    O  
ATOM   2154  CE2 TYR   293      -1.109  18.985  30.880  1.00 10.09      A    C  
ATOM   2155  CD2 TYR   293      -1.456  19.412  32.178  1.00  9.39      A    C  
ATOM   2156  C   TYR   293      -4.368  21.737  35.191  1.00  9.92      A    C  
ATOM   2157  O   TYR   293      -5.554  22.004  34.993  1.00  9.94      A    O  
ATOM   2158  N   ALA   294      -3.819  21.748  36.400  1.00 10.38      A    N  
ATOM   2159  CA  ALA   294      -4.618  22.040  37.593  1.00 10.88      A    C  
ATOM   2160  CB  ALA   294      -3.809  21.778  38.852  1.00 11.48      A    C  
ATOM   2161  C   ALA   294      -5.071  23.488  37.567  1.00 11.10      A    C  
ATOM   2162  O   ALA   294      -6.197  23.799  37.969  1.00 12.44      A    O  
ATOM   2163  N   ALA   295      -4.189  24.367  37.093  1.00 10.94      A    N  
ATOM   2164  CA  ALA   295      -4.506  25.802  37.020  1.00 10.51      A    C  
ATOM   2165  CB  ALA   295      -3.292  26.570  36.554  1.00 10.31      A    C  
ATOM   2166  C   ALA   295      -5.687  26.045  36.078  1.00 10.79      A    C  
ATOM   2167  O   ALA   295      -6.684  26.696  36.446  1.00 10.82      A    O  
ATOM   2168  N   VAL   296      -5.594  25.507  34.864  1.00 10.01      A    N  
ATOM   2169  CA  VAL   296      -6.707  25.622  33.914  1.00  9.87      A    C  
ATOM   2170  CB  VAL   296      -6.340  25.059  32.527  1.00  9.10      A    C  
ATOM   2171  CG1 VAL   296      -7.574  25.046  31.617  1.00  9.19      A    C  
ATOM   2172  CG2 VAL   296      -5.215  25.853  31.908  1.00  9.41      A    C  
ATOM   2173  C   VAL   296      -7.986  24.962  34.400  1.00  9.86      A    C  
ATOM   2174  O   VAL   296      -9.065  25.507  34.250  1.00  9.68      A    O  
ATOM   2175  N   ARG   297      -7.878  23.776  35.000  1.00 10.21      A    N  
ATOM   2176  CA  ARG   297      -9.074  23.057  35.450  1.00 11.00      A    C  
ATOM   2177  CB  ARG   297      -8.706  21.631  35.865  1.00 10.72      A    C  
ATOM   2178  CG  ARG   297      -8.517  20.756  34.627  1.00  9.80      A    C  
ATOM   2179  CD  ARG   297      -7.831  19.429  34.941  1.00  9.74      A    C  
ATOM   2180  NE  ARG   297      -7.725  18.609  33.735  1.00 11.40      A    N  
ATOM   2181  CZ  ARG   297      -6.859  17.608  33.583  1.00 11.89      A    C  
ATOM   2182  NH1 ARG   297      -6.002  17.315  34.561  1.00 11.87      A    N  
ATOM   2183  NH2 ARG   297      -6.852  16.905  32.448  1.00 12.00      A    N  
ATOM   2184  C   ARG   297      -9.886  23.767  36.537  1.00 11.44      A    C  
ATOM   2185  O   ARG   297     -11.049  23.446  36.770  1.00 12.42      A    O  
ATOM   2186  N   SER   298      -9.278  24.756  37.179  1.00 12.40      A    N  
ATOM   2187  CA  SER   298     -10.018  25.583  38.114  1.00 13.04      A    C  
ATOM   2188  CB  SER   298      -9.102  26.591  38.787  1.00 13.52      A    C  
ATOM   2189  OG  SER   298      -8.259  25.925  39.715  1.00 16.65      A    O  
ATOM   2190  C   SER   298     -11.214  26.290  37.472  1.00 12.51      A    C  
ATOM   2191  O   SER   298     -12.263  26.428  38.120  1.00 13.57      A    O  
ATOM   2192  N   TYR   299     -11.059  26.734  36.222  1.00 10.89      A    N  
ATOM   2193  CA  TYR   299     -12.162  27.386  35.502  1.00 10.28      A    C  
ATOM   2194  CB  TYR   299     -11.774  28.812  35.075  1.00  9.50      A    C  
ATOM   2195  CG  TYR   299     -10.564  28.908  34.167  1.00  9.27      A    C  
ATOM   2196  CD1 TYR   299     -10.662  28.631  32.804  1.00  8.31      A    C  
ATOM   2197  CE1 TYR   299      -9.543  28.723  31.962  1.00  7.83      A    C  
ATOM   2198  CZ  TYR   299      -8.324  29.135  32.495  1.00  9.02      A    C  
ATOM   2199  OH  TYR   299      -7.223  29.242  31.688  1.00 10.26      A    O  
ATOM   2200  CE2 TYR   299      -8.210  29.418  33.844  1.00  8.89      A    C  
ATOM   2201  CD2 TYR   299      -9.322  29.302  34.670  1.00  8.08      A    C  
ATOM   2202  C   TYR   299     -12.696  26.591  34.297  1.00 10.61      A    C  
ATOM   2203  O   TYR   299     -13.793  26.865  33.793  1.00 11.06      A    O  
ATOM   2204  N   TRP   300     -11.914  25.624  33.828  1.00 10.62      A    N  
ATOM   2205  CA  TRP   300     -12.352  24.744  32.739  1.00 11.34      A    C  
ATOM   2206  CB  TRP   300     -11.674  25.096  31.415  1.00 11.18      A    C  
ATOM   2207  CG  TRP   300     -12.158  24.197  30.274  1.00 11.38      A    C  
ATOM   2208  CD1 TRP   300     -13.417  23.712  30.106  1.00 11.92      A    C  
ATOM   2209  NE1 TRP   300     -13.485  22.936  28.964  1.00 13.28      A    N  
ATOM   2210  CE2 TRP   300     -12.242  22.897  28.387  1.00 12.66      A    C  
ATOM   2211  CD2 TRP   300     -11.376  23.671  29.189  1.00 11.25      A    C  
ATOM   2212  CE3 TRP   300     -10.036  23.800  28.807  1.00 11.05      A    C  
ATOM   2213  CZ3 TRP   300      -9.602  23.139  27.663  1.00 12.96      A    C  
ATOM   2214  CH2 TRP   300     -10.484  22.368  26.900  1.00 11.99      A    C  
ATOM   2215  CZ2 TRP   300     -11.803  22.232  27.243  1.00 13.03      A    C  
ATOM   2216  C   TRP   300     -12.051  23.295  33.111  1.00 11.84      A    C  
ATOM   2217  O   TRP   300     -11.083  22.702  32.627  1.00 11.54      A    O  
ATOM   2218  N   PRO   301     -12.873  22.733  33.992  1.00 12.67      A    N  
ATOM   2219  CA  PRO   301     -12.551  21.392  34.504  1.00 13.02      A    C  
ATOM   2220  CB  PRO   301     -13.652  21.113  35.531  1.00 13.41      A    C  
ATOM   2221  CG  PRO   301     -14.550  22.298  35.535  1.00 14.04      A    C  
ATOM   2222  CD  PRO   301     -13.949  23.403  34.745  1.00 12.33      A    C  
ATOM   2223  C   PRO   301     -12.527  20.306  33.418  1.00 13.72      A    C  
ATOM   2224  O   PRO   301     -11.853  19.276  33.604  1.00 14.48      A    O  
ATOM   2225  N   ALA   302     -13.201  20.548  32.290  1.00 13.88      A    N  
ATOM   2226  CA  ALA   302     -13.247  19.568  31.188  1.00 13.62      A    C  
ATOM   2227  CB  ALA   302     -14.469  19.799  30.299  1.00 14.40      A    C  
ATOM   2228  C   ALA   302     -11.973  19.471  30.327  1.00 13.21      A    C  
ATOM   2229  O   ALA   302     -11.924  18.685  29.372  1.00 12.71      A    O  
ATOM   2230  N   LEU   303     -10.953  20.269  30.636  1.00 12.15      A    N  
ATOM   2231  CA  LEU   303      -9.669  20.124  29.963  1.00 11.78      A    C  
ATOM   2232  CB  LEU   303      -8.616  21.028  30.628  1.00 12.03      A    C  
ATOM   2233  CG  LEU   303      -7.164  20.732  30.254  1.00 10.30      A    C  
ATOM   2234  CD1 LEU   303      -6.941  21.017  28.784  1.00 10.85      A    C  
ATOM   2235  CD2 LEU   303      -6.222  21.572  31.101  1.00 12.46      A    C  
ATOM   2236  C   LEU   303      -9.219  18.658  29.996  1.00 12.31      A    C  
ATOM   2237  O   LEU   303      -9.025  18.088  31.064  1.00 11.62      A    O  
ATOM   2238  N   PRO   304      -9.072  18.028  28.824  1.00 12.54      A    N  
ATOM   2239  CA  PRO   304      -8.681  16.600  28.863  1.00 12.74      A    C  
ATOM   2240  CB  PRO   304      -8.928  16.141  27.426  1.00 12.86      A    C  
ATOM   2241  CG  PRO   304      -9.958  17.104  26.883  1.00 12.88      A    C  
ATOM   2242  CD  PRO   304      -9.506  18.431  27.479  1.00 13.01      A    C  
ATOM   2243  C   PRO   304      -7.220  16.355  29.202  1.00 12.69      A    C  
ATOM   2244  O   PRO   304      -6.372  17.183  28.892  1.00 12.47      A    O  
ATOM   2245  N   ASP   305      -6.912  15.192  29.782  1.00 12.85      A    N  
ATOM   2246  CA  ASP   305      -5.510  14.814  29.972  1.00 13.93      A    C  
ATOM   2247  CB  ASP   305      -5.380  13.382  30.520  1.00 14.21      A    C  
ATOM   2248  CG  ASP   305      -5.872  13.231  31.946  1.00 17.28      A    C  
ATOM   2249  OD1 ASP   305      -6.049  14.241  32.660  1.00 18.05      A    O  
ATOM   2250  OD2 ASP   305      -6.076  12.062  32.361  1.00 18.72      A    O  
ATOM   2251  C   ASP   305      -4.754  14.865  28.637  1.00 13.61      A    C  
ATOM   2252  O   ASP   305      -5.281  14.452  27.591  1.00 13.18      A    O  
ATOM   2253  N   GLY   306      -3.521  15.358  28.694  1.00 14.09      A    N  
ATOM   2254  CA  GLY   306      -2.581  15.336  27.573  1.00 15.47      A    C  
ATOM   2255  C   GLY   306      -2.878  16.305  26.452  1.00 15.97      A    C  
ATOM   2256  O   GLY   306      -2.157  16.342  25.442  1.00 16.58      A    O  
ATOM   2257  N   ALA   307      -3.924  17.114  26.627  1.00 15.64      A    N  
ATOM   2258  CA  ALA   307      -4.410  17.981  25.550  1.00 15.84      A    C  
ATOM   2259  CB  ALA   307      -5.864  18.338  25.764  1.00 15.75      A    C  
ATOM   2260  C   ALA   307      -3.595  19.248  25.320  1.00 15.38      A    C  
ATOM   2261  O   ALA   307      -3.788  19.926  24.314  1.00 16.04      A    O  
ATOM   2262  N   LEU   308      -2.702  19.580  26.238  1.00 15.35      A    N  
ATOM   2263  CA  LEU   308      -1.890  20.798  26.078  1.00 15.06      A    C  
ATOM   2264  CB  LEU   308      -1.536  21.397  27.435  1.00 15.18      A    C  
ATOM   2265  CG  LEU   308      -2.718  21.870  28.281  1.00 14.77      A    C  
ATOM   2266  CD1 LEU   308      -2.198  22.497  29.562  1.00 14.10      A    C  
ATOM   2267  CD2 LEU   308      -3.618  22.855  27.503  1.00 14.87      A    C  
ATOM   2268  C   LEU   308      -0.638  20.554  25.233  1.00 15.79      A    C  
ATOM   2269  O   LEU   308       0.415  20.143  25.748  1.00 16.90      A    O  
ATOM   2270  N   ALA   309      -0.765  20.814  23.933  1.00 15.13      A    N  
ATOM   2271  CA  ALA   309       0.294  20.542  22.959  1.00 15.57      A    C  
ATOM   2272  CB  ALA   309      -0.291  20.418  21.570  1.00 15.95      A    C  
ATOM   2273  C   ALA   309       1.339  21.638  22.982  1.00 15.67      A    C  
ATOM   2274  O   ALA   309       1.038  22.791  23.307  1.00 15.40      A    O  
ATOM   2275  N   PRO   310       2.583  21.291  22.620  1.00 15.20      A    N  
ATOM   2276  CA  PRO   310       3.639  22.296  22.612  1.00 15.54      A    C  
ATOM   2277  CB  PRO   310       4.845  21.522  22.066  1.00 16.09      A    C  
ATOM   2278  CG  PRO   310       4.594  20.132  22.520  1.00 15.08      A    C  
ATOM   2279  CD  PRO   310       3.105  19.946  22.318  1.00 15.93      A    C  
ATOM   2280  C   PRO   310       3.283  23.481  21.715  1.00 15.55      A    C  
ATOM   2281  O   PRO   310       2.832  23.304  20.573  1.00 16.49      A    O  
ATOM   2282  N   GLY   311       3.466  24.683  22.245  1.00 14.91      A    N  
ATOM   2283  CA  GLY   311       3.155  25.880  21.499  1.00 13.85      A    C  
ATOM   2284  C   GLY   311       4.416  26.604  21.094  1.00 13.91      A    C  
ATOM   2285  O   GLY   311       5.090  26.215  20.126  1.00 13.87      A    O  
ATOM   2286  N   TYR   312       4.751  27.644  21.848  1.00 12.49      A    N  
ATOM   2287  CA  TYR   312       5.884  28.490  21.525  1.00 12.61      A    C  
ATOM   2288  CB  TYR   312       5.543  29.393  20.332  1.00 12.89      A    C  
ATOM   2289  CG  TYR   312       4.403  30.366  20.585  1.00 12.92      A    C  
ATOM   2290  CD1 TYR   312       4.656  31.712  20.897  1.00 14.66      A    C  
ATOM   2291  CE1 TYR   312       3.604  32.609  21.121  1.00 12.57      A    C  
ATOM   2292  CZ  TYR   312       2.301  32.162  21.036  1.00 15.48      A    C  
ATOM   2293  OH  TYR   312       1.251  33.029  21.263  1.00 14.99      A    O  
ATOM   2294  CE2 TYR   312       2.029  30.838  20.730  1.00 14.43      A    C  
ATOM   2295  CD2 TYR   312       3.085  29.949  20.505  1.00 14.65      A    C  
ATOM   2296  C   TYR   312       6.198  29.334  22.752  1.00 12.62      A    C  
ATOM   2297  O   TYR   312       5.443  29.319  23.726  1.00 12.46      A    O  
ATOM   2298  N   THR   313       7.307  30.060  22.692  1.00 12.54      A    N  
ATOM   2299  CA  THR   313       7.735  30.902  23.798  1.00 11.75      A    C  
ATOM   2300  CB  THR   313       9.086  30.437  24.360  1.00 12.16      A    C  
ATOM   2301  OG1 THR   313      10.093  30.686  23.378  1.00 13.42      A    O  
ATOM   2302  CG2 THR   313       9.062  28.946  24.713  1.00 12.33      A    C  
ATOM   2303  C   THR   313       7.926  32.344  23.362  1.00 11.63      A    C  
ATOM   2304  O   THR   313       8.047  32.664  22.165  1.00 12.08      A    O  
ATOM   2305  N   GLY   314       7.943  33.223  24.350  1.00 11.01      A    N  
ATOM   2306  CA  GLY   314       8.393  34.583  24.177  1.00 10.25      A    C  
ATOM   2307  C   GLY   314       9.214  34.979  25.387  1.00  9.80      A    C  
ATOM   2308  O   GLY   314       9.208  34.285  26.403  1.00  9.57      A    O  
ATOM   2309  N   ILE   315       9.910  36.110  25.289  1.00  9.50      A    N  
ATOM   2310  CA  ILE   315      10.694  36.606  26.413  1.00  8.89      A    C  
ATOM   2311  CB  ILE   315      12.210  36.391  26.192  1.00  9.19      A    C  
ATOM   2312  CG1 ILE   315      12.471  34.898  26.003  1.00  9.37      A    C  
ATOM   2313  CD1 ILE   315      13.918  34.578  25.628  1.00  8.98      A    C  
ATOM   2314  CG2 ILE   315      13.009  36.900  27.376  1.00  8.33      A    C  
ATOM   2315  C   ILE   315      10.362  38.082  26.642  1.00  9.46      A    C  
ATOM   2316  O   ILE   315      10.390  38.883  25.711  1.00 10.01      A    O  
ATOM   2317  N   ARG   316       9.992  38.406  27.875  1.00  8.59      A    N  
ATOM   2318  CA  ARG   316       9.627  39.775  28.254  1.00  8.99      A    C  
ATOM   2319  CB  ARG   316       8.751  39.735  29.500  1.00  8.88      A    C  
ATOM   2320  CG  ARG   316       7.509  38.861  29.385  1.00  8.68      A    C  
ATOM   2321  CD  ARG   316       6.861  38.746  30.754  1.00  9.10      A    C  
ATOM   2322  NE  ARG   316       5.680  37.885  30.804  1.00  8.89      A    N  
ATOM   2323  CZ  ARG   316       5.706  36.555  30.910  1.00  9.60      A    C  
ATOM   2324  NH1 ARG   316       6.872  35.903  30.925  1.00  8.63      A    N  
ATOM   2325  NH2 ARG   316       4.561  35.876  31.000  1.00  9.36      A    N  
ATOM   2326  C   ARG   316      10.877  40.593  28.594  1.00  9.46      A    C  
ATOM   2327  O   ARG   316      11.767  40.105  29.306  1.00  9.72      A    O  
ATOM   2328  N   PRO   317      10.934  41.846  28.120  1.00  9.31      A    N  
ATOM   2329  CA  PRO   317      12.016  42.739  28.504  1.00  9.89      A    C  
ATOM   2330  CB  PRO   317      11.975  43.827  27.427  1.00  9.59      A    C  
ATOM   2331  CG  PRO   317      10.495  43.886  26.999  1.00  8.43      A    C  
ATOM   2332  CD  PRO   317       9.954  42.483  27.213  1.00  9.11      A    C  
ATOM   2333  C   PRO   317      11.744  43.320  29.878  1.00 11.45      A    C  
ATOM   2334  O   PRO   317      10.881  44.201  30.043  1.00 13.08      A    O  
ATOM   2335  N   LYS   318      12.463  42.824  30.871  1.00 11.27      A    N  
ATOM   2336  CA  LYS   318      12.249  43.260  32.233  1.00 12.41      A    C  
ATOM   2337  CB  LYS   318      12.263  42.066  33.191  1.00 12.01      A    C  
ATOM   2338  CG  LYS   318      11.083  41.103  33.038  1.00 13.09      A    C  
ATOM   2339  CD  LYS   318       9.795  41.777  33.503  1.00 13.40      A    C  
ATOM   2340  CE  LYS   318       8.691  40.776  33.707  1.00 17.34      A    C  
ATOM   2341  NZ  LYS   318       7.410  41.441  34.119  1.00 16.28      A    N  
ATOM   2342  C   LYS   318      13.319  44.268  32.614  1.00 12.36      A    C  
ATOM   2343  O   LYS   318      14.477  44.162  32.192  1.00 13.03      A    O  
ATOM   2344  N   ILE   319      12.920  45.273  33.384  1.00 12.75      A    N  
ATOM   2345  CA  ILE   319      13.884  46.257  33.881  1.00 13.42      A    C  
ATOM   2346  CB  ILE   319      13.723  47.645  33.185  1.00 12.92      A    C  
ATOM   2347  CG1 ILE   319      12.313  48.210  33.413  1.00 12.47      A    C  
ATOM   2348  CD1 ILE   319      12.049  49.541  32.682  1.00 14.80      A    C  
ATOM   2349  CG2 ILE   319      14.100  47.515  31.707  1.00 11.76      A    C  
ATOM   2350  C   ILE   319      13.804  46.382  35.397  1.00 14.59      A    C  
ATOM   2351  O   ILE   319      14.383  47.310  35.989  1.00 15.37      A    O  
ATOM   2352  N   SER   320      13.069  45.449  36.003  1.00 15.21      A    N  
ATOM   2353  CA  SER   320      13.081  45.230  37.452  1.00 16.19      A    C  
ATOM   2354  CB  SER   320      11.847  45.846  38.087  1.00 16.25      A    C  
ATOM   2355  OG  SER   320      10.670  45.381  37.458  1.00 18.25      A    O  
ATOM   2356  C   SER   320      13.129  43.712  37.712  1.00 16.19      A    C  
ATOM   2357  O   SER   320      12.763  42.920  36.849  1.00 15.55      A    O  
ATOM   2358  N   GLY   321      13.602  43.316  38.890  1.00 16.52      A    N  
ATOM   2359  CA  GLY   321      13.882  41.896  39.162  1.00 16.25      A    C  
ATOM   2360  C   GLY   321      12.718  41.085  39.696  1.00 17.17      A    C  
ATOM   2361  O   GLY   321      11.627  41.608  39.944  1.00 16.94      A    O  
ATOM   2362  N   PRO   322      12.945  39.789  39.908  1.00 17.42      A    N  
ATOM   2363  CA  PRO   322      11.844  38.905  40.261  1.00 18.52      A    C  
ATOM   2364  CB  PRO   322      12.500  37.519  40.303  1.00 18.42      A    C  
ATOM   2365  CG  PRO   322      13.974  37.795  40.469  1.00 17.83      A    C  
ATOM   2366  CD  PRO   322      14.204  39.052  39.695  1.00 17.21      A    C  
ATOM   2367  C   PRO   322      11.161  39.229  41.593  1.00 19.93      A    C  
ATOM   2368  O   PRO   322      10.013  38.843  41.782  1.00 20.35      A    O  
ATOM   2369  N   HIS   323      11.829  39.942  42.494  1.00 20.90      A    N  
ATOM   2370  CA  HIS   323      11.185  40.255  43.772  1.00 22.55      A    C  
ATOM   2371  CB  HIS   323      12.080  39.837  44.937  1.00 22.90      A    C  
ATOM   2372  CG  HIS   323      12.218  38.359  45.062  1.00 24.46      A    C  
ATOM   2373  ND1 HIS   323      11.126  37.521  45.140  1.00 26.17      A    N  
ATOM   2374  CE1 HIS   323      11.543  36.271  45.231  1.00 27.59      A    C  
ATOM   2375  NE2 HIS   323      12.865  36.271  45.223  1.00 26.79      A    N  
ATOM   2376  CD2 HIS   323      13.311  37.563  45.110  1.00 24.98      A    C  
ATOM   2377  C   HIS   323      10.749  41.697  43.916  1.00 23.21      A    C  
ATOM   2378  O   HIS   323      10.418  42.147  45.020  1.00 23.62      A    O  
ATOM   2379  N   GLU   324      10.749  42.424  42.806  1.00 23.33      A    N  
ATOM   2380  CA  GLU   324      10.331  43.819  42.824  1.00 24.07      A    C  
ATOM   2381  CB  GLU   324      11.335  44.697  42.077  1.00 24.29      A    C  
ATOM   2382  CG  GLU   324      12.749  44.691  42.607  1.00 25.23      A    C  
ATOM   2383  CD  GLU   324      13.650  45.578  41.777  1.00 27.39      A    C  
ATOM   2384  OE1 GLU   324      14.561  45.049  41.103  1.00 27.69      A    O  
ATOM   2385  OE2 GLU   324      13.426  46.808  41.776  1.00 29.72      A    O  
ATOM   2386  C   GLU   324       8.980  43.948  42.152  1.00 24.06      A    C  
ATOM   2387  O   GLU   324       8.636  43.158  41.274  1.00 24.04      A    O  
ATOM   2388  N   PRO   325       8.210  44.973  42.541  1.00 24.33      A    N  
ATOM   2389  CA  PRO   325       6.961  45.220  41.834  1.00 24.05      A    C  
ATOM   2390  CB  PRO   325       6.363  46.420  42.576  1.00 23.88      A    C  
ATOM   2391  CG  PRO   325       7.544  47.123  43.205  1.00 24.83      A    C  
ATOM   2392  CD  PRO   325       8.617  46.083  43.422  1.00 24.45      A    C  
ATOM   2393  C   PRO   325       7.278  45.555  40.375  1.00 23.37      A    C  
ATOM   2394  O   PRO   325       8.368  46.047  40.082  1.00 23.94      A    O  
ATOM   2395  N   ALA   326       6.351  45.273  39.470  1.00 22.84      A    N  
ATOM   2396  CA  ALA   326       6.627  45.446  38.055  1.00 21.74      A    C  
ATOM   2397  CB  ALA   326       5.493  44.889  37.217  1.00 22.03      A    C  
ATOM   2398  C   ALA   326       6.882  46.916  37.723  1.00 21.03      A    C  
ATOM   2399  O   ALA   326       6.162  47.801  38.194  1.00 21.31      A    O  
ATOM   2400  N   ALA   327       7.918  47.163  36.928  1.00 19.59      A    N  
ATOM   2401  CA  ALA   327       8.256  48.506  36.477  1.00 17.91      A    C  
ATOM   2402  CB  ALA   327       9.683  48.549  35.945  1.00 18.12      A    C  
ATOM   2403  C   ALA   327       7.284  48.951  35.395  1.00 16.70      A    C  
ATOM   2404  O   ALA   327       6.733  48.127  34.673  1.00 16.86      A    O  
ATOM   2405  N   ASP   328       7.086  50.261  35.279  1.00 14.08      A    N  
ATOM   2406  CA  ASP   328       6.267  50.816  34.199  1.00 12.69      A    C  
ATOM   2407  CB  ASP   328       5.993  52.285  34.514  1.00 12.36      A    C  
ATOM   2408  CG  ASP   328       4.814  52.868  33.745  1.00 11.56      A    C  
ATOM   2409  OD1 ASP   328       4.097  52.156  33.009  1.00  9.11      A    O  
ATOM   2410  OD2 ASP   328       4.601  54.092  33.904  1.00 12.11      A    O  
ATOM   2411  C   ASP   328       7.076  50.712  32.908  1.00 11.31      A    C  
ATOM   2412  O   ASP   328       8.271  50.381  32.944  1.00 11.06      A    O  
ATOM   2413  N   PHE   329       6.435  50.966  31.769  1.00  9.85      A    N  
ATOM   2414  CA  PHE   329       7.165  51.233  30.527  1.00  9.04      A    C  
ATOM   2415  CB  PHE   329       6.235  51.797  29.445  1.00  8.38      A    C  
ATOM   2416  CG  PHE   329       5.243  50.814  28.869  1.00  7.77      A    C  
ATOM   2417  CD1 PHE   329       5.485  49.457  28.838  1.00  6.76      A    C  
ATOM   2418  CE1 PHE   329       4.554  48.588  28.282  1.00  8.22      A    C  
ATOM   2419  CZ  PHE   329       3.376  49.084  27.736  1.00  8.19      A    C  
ATOM   2420  CE2 PHE   329       3.129  50.427  27.770  1.00  8.16      A    C  
ATOM   2421  CD2 PHE   329       4.060  51.289  28.330  1.00  6.55      A    C  
ATOM   2422  C   PHE   329       8.139  52.371  30.813  1.00  9.21      A    C  
ATOM   2423  O   PHE   329       7.837  53.265  31.617  1.00  9.11      A    O  
ATOM   2424  N   ALA   330       9.288  52.361  30.140  1.00  9.36      A    N  
ATOM   2425  CA  ALA   330      10.223  53.476  30.229  1.00  9.70      A    C  
ATOM   2426  CB  ALA   330      11.544  53.016  30.846  1.00 10.09      A    C  
ATOM   2427  C   ALA   330      10.446  54.064  28.848  1.00  9.72      A    C  
ATOM   2428  O   ALA   330      10.839  53.360  27.921  1.00 10.20      A    O  
ATOM   2429  N   ILE   331      10.128  55.345  28.688  1.00  9.12      A    N  
ATOM   2430  CA  ILE   331      10.407  56.050  27.438  1.00 10.05      A    C  
ATOM   2431  CB  ILE   331       9.101  56.490  26.710  1.00  9.64      A    C  
ATOM   2432  CG1 ILE   331       8.202  55.268  26.558  1.00  9.54      A    C  
ATOM   2433  CD1 ILE   331       6.788  55.563  26.050  1.00 11.62      A    C  
ATOM   2434  CG2 ILE   331       9.426  57.131  25.363  1.00 10.71      A    C  
ATOM   2435  C   ILE   331      11.314  57.227  27.765  1.00 10.54      A    C  
ATOM   2436  O   ILE   331      10.850  58.291  28.174  1.00 11.51      A    O  
ATOM   2437  N   ALA   332      12.623  57.009  27.657  1.00 10.84      A    N  
ATOM   2438  CA  ALA   332      13.598  57.980  28.152  1.00 11.17      A    C  
ATOM   2439  CB  ALA   332      14.781  57.246  28.838  1.00 10.60      A    C  
ATOM   2440  C   ALA   332      14.107  58.910  27.061  1.00 11.87      A    C  
ATOM   2441  O   ALA   332      14.918  58.521  26.203  1.00 11.49      A    O  
ATOM   2442  N   GLY   333      13.631  60.155  27.101  1.00 13.02      A    N  
ATOM   2443  CA  GLY   333      14.023  61.183  26.144  1.00 14.29      A    C  
ATOM   2444  C   GLY   333      15.041  62.142  26.761  1.00 15.51      A    C  
ATOM   2445  O   GLY   333      15.561  61.891  27.845  1.00 15.60      A    O  
ATOM   2446  N   PRO   334      15.343  63.241  26.061  1.00 16.59      A    N  
ATOM   2447  CA  PRO   334      16.346  64.208  26.526  1.00 17.80      A    C  
ATOM   2448  CB  PRO   334      16.278  65.305  25.463  1.00 17.73      A    C  
ATOM   2449  CG  PRO   334      15.925  64.575  24.229  1.00 17.84      A    C  
ATOM   2450  CD  PRO   334      14.950  63.494  24.668  1.00 16.65      A    C  
ATOM   2451  C   PRO   334      16.105  64.778  27.933  1.00 18.66      A    C  
ATOM   2452  O   PRO   334      17.066  65.110  28.642  1.00 18.90      A    O  
ATOM   2453  N   ALA   335      14.846  64.858  28.356  1.00 19.40      A    N  
ATOM   2454  CA  ALA   335      14.533  65.424  29.665  1.00 20.51      A    C  
ATOM   2455  CB  ALA   335      13.043  65.693  29.788  1.00 20.69      A    C  
ATOM   2456  C   ALA   335      15.004  64.562  30.824  1.00 20.87      A    C  
ATOM   2457  O   ALA   335      15.080  65.028  31.956  1.00 21.60      A    O  
ATOM   2458  N   SER   336      15.310  63.295  30.562  1.00 21.26      A    N  
ATOM   2459  CA  SER   336      15.780  62.454  31.650  1.00 21.23      A    C  
ATOM   2460  CB  SER   336      14.891  61.229  31.844  1.00 22.07      A    C  
ATOM   2461  OG  SER   336      15.031  60.332  30.775  1.00 22.98      A    O  
ATOM   2462  C   SER   336      17.250  62.070  31.532  1.00 20.80      A    C  
ATOM   2463  O   SER   336      17.946  62.003  32.538  1.00 21.80      A    O  
ATOM   2464  N   HIS   337      17.733  61.838  30.318  1.00 19.40      A    N  
ATOM   2465  CA  HIS   337      19.129  61.435  30.158  1.00 18.27      A    C  
ATOM   2466  CB  HIS   337      19.247  60.170  29.305  1.00 17.22      A    C  
ATOM   2467  CG  HIS   337      18.637  60.284  27.943  1.00 16.05      A    C  
ATOM   2468  ND1 HIS   337      18.946  61.299  27.062  1.00 12.91      A    N  
ATOM   2469  CE1 HIS   337      18.270  61.122  25.939  1.00 14.15      A    C  
ATOM   2470  NE2 HIS   337      17.539  60.027  26.059  1.00 11.99      A    N  
ATOM   2471  CD2 HIS   337      17.742  59.489  27.304  1.00 13.08      A    C  
ATOM   2472  C   HIS   337      20.038  62.544  29.623  1.00 17.98      A    C  
ATOM   2473  O   HIS   337      21.265  62.390  29.586  1.00 18.39      A    O  
ATOM   2474  N   GLY   338      19.438  63.655  29.205  1.00 17.54      A    N  
ATOM   2475  CA  GLY   338      20.212  64.820  28.790  1.00 17.18      A    C  
ATOM   2476  C   GLY   338      20.767  64.798  27.381  1.00 17.65      A    C  
ATOM   2477  O   GLY   338      21.467  65.726  26.968  1.00 17.52      A    O  
ATOM   2478  N   VAL   339      20.475  63.743  26.624  1.00 16.83      A    N  
ATOM   2479  CA  VAL   339      21.014  63.639  25.279  1.00 16.57      A    C  
ATOM   2480  CB  VAL   339      21.485  62.209  24.959  1.00 15.97      A    C  
ATOM   2481  CG1 VAL   339      22.114  62.166  23.571  1.00 16.43      A    C  
ATOM   2482  CG2 VAL   339      22.463  61.726  26.015  1.00 16.35      A    C  
ATOM   2483  C   VAL   339      20.024  64.098  24.207  1.00 16.67      A    C  
ATOM   2484  O   VAL   339      19.030  63.424  23.915  1.00 16.40      A    O  
ATOM   2485  N   ALA   340      20.305  65.248  23.600  1.00 16.95      A    N  
ATOM   2486  CA  ALA   340      19.451  65.739  22.533  1.00 16.86      A    C  
ATOM   2487  CB  ALA   340      19.970  67.078  22.003  1.00 17.42      A    C  
ATOM   2488  C   ALA   340      19.325  64.715  21.393  1.00 15.91      A    C  
ATOM   2489  O   ALA   340      20.316  64.135  20.941  1.00 16.33      A    O  
ATOM   2490  N   GLY   341      18.104  64.496  20.927  1.00 14.96      A    N  
ATOM   2491  CA  GLY   341      17.891  63.665  19.740  1.00 13.79      A    C  
ATOM   2492  C   GLY   341      17.781  62.163  19.993  1.00 12.87      A    C  
ATOM   2493  O   GLY   341      17.668  61.381  19.052  1.00 12.89      A    O  
ATOM   2494  N   LEU   342      17.785  61.773  21.258  1.00 12.27      A    N  
ATOM   2495  CA  LEU   342      17.794  60.352  21.629  1.00 11.43      A    C  
ATOM   2496  CB  LEU   342      19.079  60.047  22.405  1.00 11.60      A    C  
ATOM   2497  CG  LEU   342      19.194  58.643  23.006  1.00 10.88      A    C  
ATOM   2498  CD1 LEU   342      19.352  57.606  21.904  1.00 10.65      A    C  
ATOM   2499  CD2 LEU   342      20.336  58.587  24.016  1.00 12.16      A    C  
ATOM   2500  C   LEU   342      16.579  59.938  22.470  1.00 10.74      A    C  
ATOM   2501  O   LEU   342      16.264  60.570  23.478  1.00 10.56      A    O  
ATOM   2502  N   VAL   343      15.904  58.858  22.071  1.00  9.89      A    N  
ATOM   2503  CA  VAL   343      14.918  58.247  22.940  1.00  9.41      A    C  
ATOM   2504  CB  VAL   343      13.479  58.361  22.398  1.00  9.37      A    C  
ATOM   2505  CG1 VAL   343      12.513  57.679  23.376  1.00  9.75      A    C  
ATOM   2506  CG2 VAL   343      13.097  59.851  22.249  1.00 10.33      A    C  
ATOM   2507  C   VAL   343      15.283  56.773  23.089  1.00  9.14      A    C  
ATOM   2508  O   VAL   343      15.464  56.072  22.095  1.00  8.81      A    O  
ATOM   2509  N   ASN   344      15.429  56.336  24.326  1.00  9.10      A    N  
ATOM   2510  CA  ASN   344      15.610  54.911  24.618  1.00  9.14      A    C  
ATOM   2511  CB  ASN   344      16.651  54.718  25.727  1.00  9.42      A    C  
ATOM   2512  CG  ASN   344      18.044  55.142  25.315  1.00  9.13      A    C  
ATOM   2513  OD1 ASN   344      18.576  54.657  24.325  1.00  9.81      A    O  
ATOM   2514  ND2 ASN   344      18.647  56.061  26.079  1.00 10.83      A    N  
ATOM   2515  C   ASN   344      14.281  54.391  25.125  1.00  9.30      A    C  
ATOM   2516  O   ASN   344      13.667  55.005  26.011  1.00  9.51      A    O  
ATOM   2517  N   LEU   345      13.826  53.261  24.601  1.00  9.17      A    N  
ATOM   2518  CA  LEU   345      12.637  52.643  25.164  1.00  8.30      A    C  
ATOM   2519  CB  LEU   345      11.612  52.314  24.088  1.00  8.45      A    C  
ATOM   2520  CG  LEU   345      10.956  53.550  23.454  1.00  7.71      A    C  
ATOM   2521  CD1 LEU   345      11.731  54.027  22.238  1.00  7.74      A    C  
ATOM   2522  CD2 LEU   345       9.519  53.222  23.079  1.00 10.22      A    C  
ATOM   2523  C   LEU   345      13.041  51.379  25.906  1.00  8.26      A    C  
ATOM   2524  O   LEU   345      13.699  50.507  25.325  1.00  8.86      A    O  
ATOM   2525  N   TYR   346      12.675  51.290  27.178  1.00  7.95      A    N  
ATOM   2526  CA  TYR   346      13.024  50.130  27.996  1.00  7.85      A    C  
ATOM   2527  CB  TYR   346      13.941  50.515  29.159  1.00  8.77      A    C  
ATOM   2528  CG  TYR   346      15.152  51.358  28.854  1.00  8.37      A    C  
ATOM   2529  CD1 TYR   346      16.120  50.933  27.964  1.00  7.75      A    C  
ATOM   2530  CE1 TYR   346      17.258  51.695  27.710  1.00  8.11      A    C  
ATOM   2531  CZ  TYR   346      17.440  52.888  28.373  1.00  9.48      A    C  
ATOM   2532  OH  TYR   346      18.565  53.655  28.134  1.00 11.19      A    O  
ATOM   2533  CE2 TYR   346      16.490  53.340  29.271  1.00  9.35      A    C  
ATOM   2534  CD2 TYR   346      15.352  52.564  29.512  1.00  8.85      A    C  
ATOM   2535  C   TYR   346      11.794  49.490  28.617  1.00  7.97      A    C  
ATOM   2536  O   TYR   346      10.821  50.171  28.959  1.00  8.23      A    O  
ATOM   2537  N   GLY   347      11.829  48.171  28.779  1.00  7.68      A    N  
ATOM   2538  CA  GLY   347      10.769  47.465  29.501  1.00  7.05      A    C  
ATOM   2539  C   GLY   347       9.404  47.523  28.830  1.00  6.74      A    C  
ATOM   2540  O   GLY   347       8.374  47.561  29.511  1.00  7.05      A    O  
ATOM   2541  N   ILE   348       9.395  47.483  27.504  1.00  6.52      A    N  
ATOM   2542  CA  ILE   348       8.136  47.526  26.752  1.00  6.03      A    C  
ATOM   2543  CB  ILE   348       8.285  48.276  25.391  1.00  6.46      A    C  
ATOM   2544  CG1 ILE   348       8.997  49.627  25.558  1.00  7.27      A    C  
ATOM   2545  CD1 ILE   348       8.354  50.642  26.522  1.00  9.00      A    C  
ATOM   2546  CG2 ILE   348       6.892  48.424  24.700  1.00  5.84      A    C  
ATOM   2547  C   ILE   348       7.610  46.099  26.584  1.00  5.80      A    C  
ATOM   2548  O   ILE   348       7.639  45.509  25.484  1.00  6.23      A    O  
ATOM   2549  N   GLU   349       7.145  45.554  27.706  1.00  5.60      A    N  
ATOM   2550  CA  GLU   349       6.560  44.224  27.760  1.00  6.88      A    C  
ATOM   2551  CB  GLU   349       6.842  43.567  29.129  1.00  7.34      A    C  
ATOM   2552  CG  GLU   349       6.362  44.402  30.347  1.00  7.51      A    C  
ATOM   2553  CD  GLU   349       6.334  43.614  31.656  1.00 13.20      A    C  
ATOM   2554  OE1 GLU   349       6.539  42.377  31.618  1.00 13.64      A    O  
ATOM   2555  OE2 GLU   349       6.083  44.247  32.718  1.00 11.20      A    O  
ATOM   2556  C   GLU   349       5.065  44.414  27.514  1.00  6.72      A    C  
ATOM   2557  O   GLU   349       4.665  45.454  26.982  1.00  6.59      A    O  
ATOM   2558  N   SER   350       4.238  43.448  27.888  1.00  6.51      A    N  
ATOM   2559  CA  SER   350       2.787  43.679  27.786  1.00  6.93      A    C  
ATOM   2560  CB  SER   350       2.037  42.462  28.298  1.00  7.61      A    C  
ATOM   2561  OG  SER   350       0.649  42.645  28.093  1.00  6.79      A    O  
ATOM   2562  C   SER   350       2.385  44.915  28.609  1.00  6.47      A    C  
ATOM   2563  O   SER   350       2.844  45.095  29.734  1.00  6.32      A    O  
ATOM   2564  N   PRO   351       1.469  45.748  28.091  1.00  6.20      A    N  
ATOM   2565  CA  PRO   351       0.677  45.615  26.860  1.00  6.13      A    C  
ATOM   2566  CB  PRO   351      -0.680  46.177  27.290  1.00  5.56      A    C  
ATOM   2567  CG  PRO   351      -0.291  47.324  28.201  1.00  5.26      A    C  
ATOM   2568  CD  PRO   351       0.923  46.802  28.979  1.00  6.27      A    C  
ATOM   2569  C   PRO   351       1.247  46.469  25.724  1.00  6.66      A    C  
ATOM   2570  O   PRO   351       0.535  47.297  25.141  1.00  6.93      A    O  
ATOM   2571  N   GLY   352       2.528  46.279  25.424  1.00  6.23      A    N  
ATOM   2572  CA  GLY   352       3.221  47.057  24.393  1.00  6.36      A    C  
ATOM   2573  C   GLY   352       2.611  46.989  23.010  1.00  6.31      A    C  
ATOM   2574  O   GLY   352       2.661  47.968  22.254  1.00  7.52      A    O  
ATOM   2575  N   LEU   353       2.054  45.835  22.642  1.00  6.27      A    N  
ATOM   2576  CA  LEU   353       1.455  45.707  21.318  1.00  7.16      A    C  
ATOM   2577  CB  LEU   353       1.095  44.255  21.030  1.00  7.99      A    C  
ATOM   2578  CG  LEU   353       0.158  43.990  19.855  1.00 10.82      A    C  
ATOM   2579  CD1 LEU   353       0.843  44.264  18.547  1.00 16.56      A    C  
ATOM   2580  CD2 LEU   353      -0.289  42.509  19.923  1.00 16.29      A    C  
ATOM   2581  C   LEU   353       0.205  46.589  21.288  1.00  6.93      A    C  
ATOM   2582  O   LEU   353       0.004  47.385  20.364  1.00  6.88      A    O  
ATOM   2583  N   THR   354      -0.602  46.474  22.336  1.00  6.61      A    N  
ATOM   2584  CA  THR   354      -1.850  47.248  22.409  1.00  6.44      A    C  
ATOM   2585  CB  THR   354      -2.632  46.903  23.689  1.00  6.43      A    C  
ATOM   2586  OG1 THR   354      -2.966  45.514  23.667  1.00  6.69      A    O  
ATOM   2587  CG2 THR   354      -3.918  47.731  23.786  1.00  6.28      A    C  
ATOM   2588  C   THR   354      -1.521  48.732  22.408  1.00  6.59      A    C  
ATOM   2589  O   THR   354      -2.214  49.544  21.765  1.00  6.88      A    O  
ATOM   2590  N   ALA   355      -0.462  49.090  23.129  1.00  6.00      A    N  
ATOM   2591  CA  ALA   355      -0.102  50.497  23.329  1.00  6.80      A    C  
ATOM   2592  CB  ALA   355       0.702  50.665  24.630  1.00  7.17      A    C  
ATOM   2593  C   ALA   355       0.702  51.076  22.167  1.00  6.95      A    C  
ATOM   2594  O   ALA   355       1.009  52.271  22.176  1.00  7.73      A    O  
ATOM   2595  N   SER   356       1.078  50.238  21.199  1.00  6.68      A    N  
ATOM   2596  CA  SER   356       2.108  50.626  20.216  1.00  7.20      A    C  
ATOM   2597  CB  SER   356       2.309  49.550  19.137  1.00  7.64      A    C  
ATOM   2598  OG  SER   356       1.102  49.228  18.463  1.00  8.71      A    O  
ATOM   2599  C   SER   356       1.936  52.014  19.569  1.00  7.23      A    C  
ATOM   2600  O   SER   356       2.903  52.768  19.483  1.00  7.57      A    O  
ATOM   2601  N   LEU   357       0.734  52.340  19.085  1.00  7.09      A    N  
ATOM   2602  CA  LEU   357       0.583  53.618  18.388  1.00  7.54      A    C  
ATOM   2603  CB  LEU   357      -0.721  53.673  17.576  1.00  8.40      A    C  
ATOM   2604  CG  LEU   357      -0.855  52.660  16.434  1.00  6.87      A    C  
ATOM   2605  CD1 LEU   357       0.102  52.998  15.300  1.00  8.88      A    C  
ATOM   2606  CD2 LEU   357      -2.316  52.682  15.929  1.00  9.76      A    C  
ATOM   2607  C   LEU   357       0.663  54.774  19.379  1.00  8.05      A    C  
ATOM   2608  O   LEU   357       1.137  55.866  19.034  1.00  8.30      A    O  
ATOM   2609  N   ALA   358       0.199  54.545  20.604  1.00  7.75      A    N  
ATOM   2610  CA  ALA   358       0.332  55.540  21.651  1.00  7.72      A    C  
ATOM   2611  CB  ALA   358      -0.617  55.235  22.814  1.00  8.67      A    C  
ATOM   2612  C   ALA   358       1.774  55.692  22.127  1.00  8.33      A    C  
ATOM   2613  O   ALA   358       2.228  56.795  22.417  1.00  8.54      A    O  
ATOM   2614  N   ILE   359       2.510  54.587  22.163  1.00  6.73      A    N  
ATOM   2615  CA  ILE   359       3.923  54.675  22.489  1.00  6.96      A    C  
ATOM   2616  CB  ILE   359       4.563  53.285  22.609  1.00  6.82      A    C  
ATOM   2617  CG1 ILE   359       4.046  52.571  23.861  1.00  6.31      A    C  
ATOM   2618  CD1 ILE   359       4.282  51.015  23.857  1.00  6.58      A    C  
ATOM   2619  CG2 ILE   359       6.101  53.411  22.632  1.00  6.91      A    C  
ATOM   2620  C   ILE   359       4.661  55.508  21.424  1.00  6.55      A    C  
ATOM   2621  O   ILE   359       5.545  56.303  21.766  1.00  6.92      A    O  
ATOM   2622  N   ALA   360       4.304  55.328  20.155  1.00  7.28      A    N  
ATOM   2623  CA  ALA   360       4.848  56.173  19.077  1.00  8.37      A    C  
ATOM   2624  CB  ALA   360       4.310  55.746  17.727  1.00  9.00      A    C  
ATOM   2625  C   ALA   360       4.545  57.654  19.335  1.00  9.08      A    C  
ATOM   2626  O   ALA   360       5.440  58.502  19.249  1.00  9.65      A    O  
ATOM   2627  N   GLU   361       3.298  57.979  19.666  1.00  9.42      A    N  
ATOM   2628  CA  GLU   361       2.973  59.374  19.992  1.00 10.25      A    C  
ATOM   2629  CB  GLU   361       1.509  59.498  20.414  1.00 10.25      A    C  
ATOM   2630  CG  GLU   361       0.531  59.274  19.276  1.00 11.45      A    C  
ATOM   2631  CD  GLU   361      -0.930  59.463  19.712  1.00 14.44      A    C  
ATOM   2632  OE1 GLU   361      -1.268  59.103  20.852  1.00 15.38      A    O  
ATOM   2633  OE2 GLU   361      -1.737  59.988  18.903  1.00 14.41      A    O  
ATOM   2634  C   GLU   361       3.852  59.908  21.114  1.00 10.18      A    C  
ATOM   2635  O   GLU   361       4.403  61.010  21.021  1.00 10.62      A    O  
ATOM   2636  N   GLU   362       3.984  59.117  22.175  1.00  9.87      A    N  
ATOM   2637  CA  GLU   362       4.710  59.542  23.368  1.00 10.55      A    C  
ATOM   2638  CB  GLU   362       4.427  58.588  24.539  1.00 10.82      A    C  
ATOM   2639  CG  GLU   362       4.983  59.077  25.887  1.00 12.80      A    C  
ATOM   2640  CD  GLU   362       4.281  60.333  26.433  1.00 15.84      A    C  
ATOM   2641  OE1 GLU   362       4.832  60.978  27.346  1.00 18.23      A    O  
ATOM   2642  OE2 GLU   362       3.172  60.661  25.981  1.00 15.97      A    O  
ATOM   2643  C   GLU   362       6.216  59.691  23.116  1.00 10.27      A    C  
ATOM   2644  O   GLU   362       6.875  60.577  23.677  1.00  9.43      A    O  
ATOM   2645  N   THR   363       6.759  58.832  22.261  1.00 10.60      A    N  
ATOM   2646  CA  THR   363       8.173  58.925  21.908  1.00 11.59      A    C  
ATOM   2647  CB  THR   363       8.630  57.753  21.039  1.00 12.17      A    C  
ATOM   2648  OG1 THR   363       7.900  57.757  19.815  1.00 19.07      A    O  
ATOM   2649  CG2 THR   363       8.370  56.466  21.742  1.00  7.00      A    C  
ATOM   2650  C   THR   363       8.461  60.226  21.185  1.00 12.00      A    C  
ATOM   2651  O   THR   363       9.432  60.916  21.505  1.00 12.55      A    O  
ATOM   2652  N   LEU   364       7.611  60.579  20.231  1.00 12.00      A    N  
ATOM   2653  CA  LEU   364       7.800  61.838  19.521  1.00 13.53      A    C  
ATOM   2654  CB  LEU   364       6.855  61.939  18.322  1.00 13.46      A    C  
ATOM   2655  CG  LEU   364       7.391  61.374  17.002  1.00 13.50      A    C  
ATOM   2656  CD1 LEU   364       6.438  61.706  15.872  1.00 14.21      A    C  
ATOM   2657  CD2 LEU   364       7.620  59.850  17.065  1.00 13.39      A    C  
ATOM   2658  C   LEU   364       7.650  63.028  20.473  1.00 14.28      A    C  
ATOM   2659  O   LEU   364       8.400  63.993  20.387  1.00 14.05      A    O  
ATOM   2660  N   ALA   365       6.701  62.940  21.399  1.00 14.54      A    N  
ATOM   2661  CA  ALA   365       6.456  64.017  22.362  1.00 15.78      A    C  
ATOM   2662  CB  ALA   365       5.235  63.692  23.210  1.00 15.20      A    C  
ATOM   2663  C   ALA   365       7.659  64.240  23.260  1.00 16.57      A    C  
ATOM   2664  O   ALA   365       7.978  65.380  23.628  1.00 17.17      A    O  
ATOM   2665  N   ARG   366       8.301  63.148  23.646  1.00 16.44      A    N  
ATOM   2666  CA  ARG   366       9.441  63.150  24.544  1.00 17.63      A    C  
ATOM   2667  CB  ARG   366       9.579  61.799  25.280  1.00 17.68      A    C  
ATOM   2668  CG  ARG   366       8.565  61.657  26.343  1.00 18.23      A    C  
ATOM   2669  CD  ARG   366       8.601  60.446  27.266  1.00 21.06      A    C  
ATOM   2670  NE  ARG   366       7.442  60.466  28.144  1.00 25.26      A    N  
ATOM   2671  CZ  ARG   366       7.358  59.790  29.262  1.00 22.92      A    C  
ATOM   2672  NH1 ARG   366       8.347  59.006  29.599  1.00 28.39      A    N  
ATOM   2673  NH2 ARG   366       6.331  59.852  30.060  1.00 22.15      A    N  
ATOM   2674  C   ARG   366      10.719  63.557  23.788  1.00 18.21      A    C  
ATOM   2675  O   ARG   366      11.569  64.197  24.315  1.00 18.20      A    O  
ATOM   2676  N   LEU   367      10.815  63.138  22.551  1.00 18.40      A    N  
ATOM   2677  CA  LEU   367      11.953  63.482  21.718  1.00 19.46      A    C  
ATOM   2678  CB  LEU   367      11.813  62.827  20.343  1.00 19.34      A    C  
ATOM   2679  CG  LEU   367      12.834  63.151  19.259  1.00 18.92      A    C  
ATOM   2680  CD1 LEU   367      12.482  62.407  17.961  1.00 17.71      A    C  
ATOM   2681  CD2 LEU   367      14.232  62.824  19.732  1.00 19.16      A    C  
ATOM   2682  C   LEU   367      12.005  65.005  21.610  1.00 20.53      A    C  
ATOM   2683  O   LEU   367      13.077  65.601  21.550  1.00 20.59      A    O  
ATOM   2684  N   ALA   368      10.835  65.630  21.629  1.00 21.55      A    N  
ATOM   2685  CA  ALA   368      10.751  67.091  21.637  1.00 22.12      A    C  
ATOM   2686  CB  ALA   368       9.365  67.529  21.211  1.00 22.49      A    C  
ATOM   2687  C   ALA   368      11.095  67.663  23.015  1.00 22.64      A    C  
ATOM   2688  O   ALA   368      11.340  68.879  23.162  1.00 23.74      A    O  
END
