
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  120 ( 1757),  selected  120 , name 2eno_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2eno_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    N     9_A      -       -           -
LGA    G    10_A      -       -           -
LGA    R    11_A      -       -           -
LGA    V    12_A      -       -           -
LGA    D    13_A      -       -           -
LGA    Y    14_A      -       -           -
LGA    L    15_A      S       1          3.407
LGA    V    16_A      M       2          0.966
LGA    T    17_A      E       3          0.577
LGA    E    18_A      I       4          0.342
LGA    E    19_A      L       5          0.391
LGA    E    20_A      Q       6          0.191
LGA    I    21_A      V       7          0.567
LGA    N    22_A      A       8          0.485
LGA    L    23_A      L       9          0.561
LGA    T    24_A      H      10          0.840
LGA    R    25_A      K      11          1.448
LGA    G    26_A      R      12          4.020
LGA    P    27_A      D      13          3.476
LGA    -       -      S      14           -
LGA    S    28_A      G      15          2.001
LGA    G    29_A      E      16          2.993
LGA    L    30_A      Q      17          2.301
LGA    -       -      L      18           -
LGA    G    31_A      G      19          1.564
LGA    F    32_A      I      20          1.739
LGA    N    33_A      K      21          1.636
LGA    I    34_A      L      22          0.898
LGA    V    35_A      V      23          1.177
LGA    G    36_A      R      24          3.223
LGA    G    37_A      -       -           -
LGA    T    38_A      -       -           -
LGA    D    39_A      -       -           -
LGA    Q    40_A      -       -           -
LGA    Q    41_A      -       -           -
LGA    Y    42_A      R      25          1.714
LGA    V    43_A      T      26          2.381
LGA    S    44_A      D      27          2.196
LGA    N    45_A      E      28          2.050
LGA    D    46_A      P      29          2.200
LGA    S    47_A      -       -           -
LGA    G    48_A      G      30          1.060
LGA    I    49_A      V      31          0.989
LGA    Y    50_A      F      32          0.900
LGA    V    51_A      I      33          1.157
LGA    S    52_A      L      34          1.792
LGA    R    53_A      D      35          2.500
LGA    I    54_A      L      36          1.192
LGA    K    55_A      L      37          1.340
LGA    E    56_A      E      38          0.995
LGA    N    57_A      G      39          1.124
LGA    G    58_A      G      40          0.709
LGA    A    59_A      L      41          0.380
LGA    A    60_A      A      42          0.679
LGA    A    61_A      A      43          1.201
LGA    L    62_A      Q      44          0.952
LGA    D    63_A      D      45          0.796
LGA    G    64_A      G      46          0.824
LGA    R    65_A      R      47          1.263
LGA    L    66_A      L      48          1.463
LGA    Q    67_A      S      49          1.844
LGA    E    68_A      S      50          2.174
LGA    G    69_A      N      51          2.048
LGA    D    70_A      D      52          1.396
LGA    K    71_A      R      53          1.003
LGA    I    72_A      V      54          0.856
LGA    L    73_A      L      55          0.977
LGA    S    74_A      A      56          0.934
LGA    V    75_A      I      57          1.006
LGA    N    76_A      N      58          1.648
LGA    G    77_A      G      59          1.906
LGA    Q    78_A      H      60          1.779
LGA    D    79_A      D      61          1.390
LGA    L    80_A      L      62          0.520
LGA    K    81_A      K      63          3.789
LGA    N    82_A      Y      64          4.098
LGA    L    83_A      G      65          3.546
LGA    L    84_A      T      66          3.783
LGA    H    85_A      P      67          3.143
LGA    Q    86_A      E      68          1.883
LGA    D    87_A      L      69          1.605
LGA    A    88_A      A      70          1.871
LGA    V    89_A      A      71          0.878
LGA    D    90_A      Q      72          0.328
LGA    L    91_A      I      73          1.127
LGA    F    92_A      I      74          1.677
LGA    R    93_A      Q      75          2.046
LGA    N    94_A      A      76          2.617
LGA    A    95_A      S      77          2.616
LGA    G    96_A      G      78          1.633
LGA    Y    97_A      E      79          0.537
LGA    A    98_A      R      80          0.522
LGA    V    99_A      V      81          0.374
LGA    S   100_A      N      82          0.416
LGA    L   101_A      L      83          0.345
LGA    R   102_A      T      84          0.731
LGA    V   103_A      I      85          0.878
LGA    Q   104_A      A      86          1.432
LGA    H   105_A      R      87          1.763
LGA    R   106_A      P      88          1.964
LGA    L   107_A      G      89          3.273
LGA    Q   108_A      K      90          3.128
LGA    -       -      P      91           -
LGA    V   109_A      E      92          4.835
LGA    Q   110_A      I      93          2.495
LGA    N   111_A      E      94          5.713
LGA    G   112_A      L      95          6.580
LGA    P   113_A      -       -           -
LGA    I   114_A      -       -           -
LGA    S   115_A      -       -           -
LGA    G   116_A      -       -           -
LGA    P   117_A      -       -           -
LGA    S   118_A      -       -           -
LGA    S   119_A      -       -           -
LGA    G   120_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  120   95    5.0     92    2.10    25.00     86.793     4.184

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.455567 * X  +  -0.418989 * Y  +   0.785434 * Z  +  16.168234
  Y_new =   0.786148 * X  +   0.224588 * Y  +   0.575787 * Z  +  15.639554
  Z_new =  -0.417647 * X  +   0.879778 * Y  +   0.227072 * Z  +  16.733635 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.318207   -1.823386  [ DEG:    75.5277   -104.4723 ]
  Theta =   0.430854    2.710738  [ DEG:    24.6861    155.3139 ]
  Phi   =   2.096000   -1.045592  [ DEG:   120.0920    -59.9080 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eno_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eno_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  120   95   5.0   92   2.10   25.00  86.793
REMARK  ---------------------------------------------------------- 
MOLECULE 2eno_A
HEADER    ENDOCYTOSIS                             28-MAR-07   2ENO              
TITLE     SOLUTION STRUCTURE OF THE PDZ DOMAIN FROM HUMAN                       
TITLE    2 SYNAPTOJANIN 2 BINDING PROTEIN                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SYNAPTOJANIN-2-BINDING PROTEIN;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: MITOCHONDRIAL OUTER MEMBRANE PROTEIN 25;                    
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SYNJ2BP;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050509-14;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    MITOCHONDRIAL OUTER MEMBRANE PROTEIN 25, STRUCTURAL                   
KEYWDS   2 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   3 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, ENDOCYTOSIS                    
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.ENDO,M.YOSHIDA,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL                
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   02-OCT-07 2ENO    0                                                
JRNL        AUTH   H.ENDO,M.YOSHIDA,F.HAYASHI,S.YOKOYAMA                        
JRNL        TITL   SOLUTION STRUCTURE OF THE PDZ DOMAIN FROM HUMAN              
JRNL        TITL 2 SYNAPTOJANIN 2 BINDING PROTEIN                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2ENO A    8   114  UNP    P57105   SYJ2B_HUMAN      1    107             
SEQRES   1 A  120  GLY SER SER GLY SER SER GLY MET ASN GLY ARG VAL ASP          
SEQRES   2 A  120  TYR LEU VAL THR GLU GLU GLU ILE ASN LEU THR ARG GLY          
SEQRES   3 A  120  PRO SER GLY LEU GLY PHE ASN ILE VAL GLY GLY THR ASP          
SEQRES   4 A  120  GLN GLN TYR VAL SER ASN ASP SER GLY ILE TYR VAL SER          
SEQRES   5 A  120  ARG ILE LYS GLU ASN GLY ALA ALA ALA LEU ASP GLY ARG          
SEQRES   6 A  120  LEU GLN GLU GLY ASP LYS ILE LEU SER VAL ASN GLY GLN          
SEQRES   7 A  120  ASP LEU LYS ASN LEU LEU HIS GLN ASP ALA VAL ASP LEU          
SEQRES   8 A  120  PHE ARG ASN ALA GLY TYR ALA VAL SER LEU ARG VAL GLN          
SEQRES   9 A  120  HIS ARG LEU GLN VAL GLN ASN GLY PRO ILE SER GLY PRO          
SEQRES  10 A  120  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      25.229  31.244  43.698  1.00  0.00           N  
ATOM      2  CA  GLY A   1      24.099  31.059  42.806  1.00  0.00           C  
ATOM      3  C   GLY A   1      23.738  29.599  42.623  1.00  0.00           C  
ATOM      4  O   GLY A   1      24.502  28.832  42.036  1.00  0.00           O  
ATOM      5  H1  GLY A   1      25.720  30.464  44.031  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      23.246  31.583  43.210  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      24.344  31.481  41.842  1.00  0.00           H  
ATOM      8  N   SER A   2      22.571  29.212  43.128  1.00  0.00           N  
ATOM      9  CA  SER A   2      22.112  27.831  43.023  1.00  0.00           C  
ATOM     10  C   SER A   2      21.208  27.651  41.807  1.00  0.00           C  
ATOM     11  O   SER A   2      20.783  28.625  41.185  1.00  0.00           O  
ATOM     12  CB  SER A   2      21.366  27.421  44.294  1.00  0.00           C  
ATOM     13  OG  SER A   2      21.309  26.011  44.419  1.00  0.00           O  
ATOM     14  H   SER A   2      22.006  29.870  43.585  1.00  0.00           H  
ATOM     15  HA  SER A   2      22.981  27.201  42.906  1.00  0.00           H  
ATOM     16  HB2 SER A   2      21.875  27.827  45.154  1.00  0.00           H  
ATOM     17  HB3 SER A   2      20.357  27.808  44.256  1.00  0.00           H  
ATOM     18  HG  SER A   2      20.410  25.743  44.617  1.00  0.00           H  
ATOM     19  N   SER A   3      20.917  26.397  41.475  1.00  0.00           N  
ATOM     20  CA  SER A   3      20.067  26.087  40.332  1.00  0.00           C  
ATOM     21  C   SER A   3      19.504  24.674  40.440  1.00  0.00           C  
ATOM     22  O   SER A   3      20.171  23.763  40.931  1.00  0.00           O  
ATOM     23  CB  SER A   3      20.854  26.236  39.028  1.00  0.00           C  
ATOM     24  OG  SER A   3      22.001  25.405  39.028  1.00  0.00           O  
ATOM     25  H   SER A   3      21.286  25.664  42.009  1.00  0.00           H  
ATOM     26  HA  SER A   3      19.246  26.789  40.329  1.00  0.00           H  
ATOM     27  HB2 SER A   3      20.224  25.959  38.197  1.00  0.00           H  
ATOM     28  HB3 SER A   3      21.167  27.264  38.915  1.00  0.00           H  
ATOM     29  HG  SER A   3      21.822  24.610  39.534  1.00  0.00           H  
ATOM     30  N   GLY A   4      18.270  24.497  39.978  1.00  0.00           N  
ATOM     31  CA  GLY A   4      17.637  23.193  40.033  1.00  0.00           C  
ATOM     32  C   GLY A   4      16.783  22.911  38.813  1.00  0.00           C  
ATOM     33  O   GLY A   4      16.530  23.804  38.004  1.00  0.00           O  
ATOM     34  H   GLY A   4      17.785  25.259  39.597  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      18.403  22.435  40.106  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      17.013  23.145  40.913  1.00  0.00           H  
ATOM     37  N   SER A   5      16.338  21.666  38.679  1.00  0.00           N  
ATOM     38  CA  SER A   5      15.511  21.267  37.544  1.00  0.00           C  
ATOM     39  C   SER A   5      14.073  21.742  37.726  1.00  0.00           C  
ATOM     40  O   SER A   5      13.527  22.446  36.877  1.00  0.00           O  
ATOM     41  CB  SER A   5      15.542  19.748  37.373  1.00  0.00           C  
ATOM     42  OG  SER A   5      15.015  19.365  36.115  1.00  0.00           O  
ATOM     43  H   SER A   5      16.573  20.998  39.356  1.00  0.00           H  
ATOM     44  HA  SER A   5      15.921  21.729  36.658  1.00  0.00           H  
ATOM     45  HB2 SER A   5      16.562  19.400  37.443  1.00  0.00           H  
ATOM     46  HB3 SER A   5      14.951  19.289  38.152  1.00  0.00           H  
ATOM     47  HG  SER A   5      15.161  20.070  35.479  1.00  0.00           H  
ATOM     48  N   SER A   6      13.465  21.349  38.841  1.00  0.00           N  
ATOM     49  CA  SER A   6      12.088  21.730  39.135  1.00  0.00           C  
ATOM     50  C   SER A   6      11.135  21.180  38.079  1.00  0.00           C  
ATOM     51  O   SER A   6      10.224  21.873  37.628  1.00  0.00           O  
ATOM     52  CB  SER A   6      11.962  23.253  39.208  1.00  0.00           C  
ATOM     53  OG  SER A   6      12.338  23.736  40.487  1.00  0.00           O  
ATOM     54  H   SER A   6      13.953  20.789  39.481  1.00  0.00           H  
ATOM     55  HA  SER A   6      11.825  21.309  40.095  1.00  0.00           H  
ATOM     56  HB2 SER A   6      12.605  23.702  38.466  1.00  0.00           H  
ATOM     57  HB3 SER A   6      10.938  23.537  39.017  1.00  0.00           H  
ATOM     58  HG  SER A   6      12.314  24.695  40.488  1.00  0.00           H  
ATOM     59  N   GLY A   7      11.352  19.928  37.688  1.00  0.00           N  
ATOM     60  CA  GLY A   7      10.507  19.305  36.688  1.00  0.00           C  
ATOM     61  C   GLY A   7       9.869  18.023  37.185  1.00  0.00           C  
ATOM     62  O   GLY A   7       9.961  17.694  38.367  1.00  0.00           O  
ATOM     63  H   GLY A   7      12.095  19.423  38.083  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       9.726  19.999  36.410  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      11.103  19.082  35.816  1.00  0.00           H  
ATOM     66  N   MET A   8       9.219  17.298  36.280  1.00  0.00           N  
ATOM     67  CA  MET A   8       8.564  16.044  36.634  1.00  0.00           C  
ATOM     68  C   MET A   8       9.592  14.963  36.952  1.00  0.00           C  
ATOM     69  O   MET A   8      10.663  14.917  36.350  1.00  0.00           O  
ATOM     70  CB  MET A   8       7.655  15.580  35.495  1.00  0.00           C  
ATOM     71  CG  MET A   8       8.414  15.095  34.270  1.00  0.00           C  
ATOM     72  SD  MET A   8       8.879  16.441  33.164  1.00  0.00           S  
ATOM     73  CE  MET A   8       7.821  16.106  31.759  1.00  0.00           C  
ATOM     74  H   MET A   8       9.180  17.612  35.352  1.00  0.00           H  
ATOM     75  HA  MET A   8       7.962  16.222  37.513  1.00  0.00           H  
ATOM     76  HB2 MET A   8       7.035  14.770  35.851  1.00  0.00           H  
ATOM     77  HB3 MET A   8       7.022  16.403  35.197  1.00  0.00           H  
ATOM     78  HG2 MET A   8       9.311  14.590  34.596  1.00  0.00           H  
ATOM     79  HG3 MET A   8       7.789  14.401  33.728  1.00  0.00           H  
ATOM     80  HE1 MET A   8       7.185  16.961  31.574  1.00  0.00           H  
ATOM     81  HE2 MET A   8       8.429  15.915  30.887  1.00  0.00           H  
ATOM     82  HE3 MET A   8       7.209  15.241  31.967  1.00  0.00           H  
ATOM     83  N   ASN A   9       9.258  14.097  37.902  1.00  0.00           N  
ATOM     84  CA  ASN A   9      10.154  13.016  38.301  1.00  0.00           C  
ATOM     85  C   ASN A   9      10.074  11.852  37.318  1.00  0.00           C  
ATOM     86  O   ASN A   9       9.023  11.231  37.160  1.00  0.00           O  
ATOM     87  CB  ASN A   9       9.809  12.533  39.710  1.00  0.00           C  
ATOM     88  CG  ASN A   9      10.367  13.443  40.787  1.00  0.00           C  
ATOM     89  OD1 ASN A   9      11.584  13.573  40.936  1.00  0.00           O  
ATOM     90  ND2 ASN A   9       9.481  14.077  41.545  1.00  0.00           N  
ATOM     91  H   ASN A   9       8.390  14.185  38.348  1.00  0.00           H  
ATOM     92  HA  ASN A   9      11.162  13.405  38.300  1.00  0.00           H  
ATOM     93  HB2 ASN A   9       8.734  12.497  39.819  1.00  0.00           H  
ATOM     94  HB3 ASN A   9      10.215  11.543  39.855  1.00  0.00           H  
ATOM     95 HD21 ASN A   9       8.529  13.926  41.369  1.00  0.00           H  
ATOM     96 HD22 ASN A   9       9.815  14.673  42.248  1.00  0.00           H  
ATOM     97  N   GLY A  10      11.192  11.562  36.659  1.00  0.00           N  
ATOM     98  CA  GLY A  10      11.226  10.474  35.700  1.00  0.00           C  
ATOM     99  C   GLY A  10      12.500  10.465  34.878  1.00  0.00           C  
ATOM    100  O   GLY A  10      13.191  11.480  34.780  1.00  0.00           O  
ATOM    101  H   GLY A  10      11.999  12.093  36.825  1.00  0.00           H  
ATOM    102  HA2 GLY A  10      11.147   9.538  36.232  1.00  0.00           H  
ATOM    103  HA3 GLY A  10      10.383  10.570  35.032  1.00  0.00           H  
ATOM    104  N   ARG A  11      12.815   9.316  34.290  1.00  0.00           N  
ATOM    105  CA  ARG A  11      14.016   9.179  33.476  1.00  0.00           C  
ATOM    106  C   ARG A  11      13.746   9.593  32.032  1.00  0.00           C  
ATOM    107  O   ARG A  11      12.776   9.148  31.419  1.00  0.00           O  
ATOM    108  CB  ARG A  11      14.523   7.736  33.516  1.00  0.00           C  
ATOM    109  CG  ARG A  11      15.406   7.434  34.716  1.00  0.00           C  
ATOM    110  CD  ARG A  11      14.601   7.402  36.006  1.00  0.00           C  
ATOM    111  NE  ARG A  11      15.237   6.576  37.028  1.00  0.00           N  
ATOM    112  CZ  ARG A  11      15.256   5.248  36.993  1.00  0.00           C  
ATOM    113  NH1 ARG A  11      14.678   4.600  35.992  1.00  0.00           N  
ATOM    114  NH2 ARG A  11      15.856   4.566  37.961  1.00  0.00           N  
ATOM    115  H   ARG A  11      12.225   8.542  34.405  1.00  0.00           H  
ATOM    116  HA  ARG A  11      14.774   9.828  33.889  1.00  0.00           H  
ATOM    117  HB2 ARG A  11      13.675   7.069  33.545  1.00  0.00           H  
ATOM    118  HB3 ARG A  11      15.094   7.542  32.620  1.00  0.00           H  
ATOM    119  HG2 ARG A  11      15.875   6.471  34.574  1.00  0.00           H  
ATOM    120  HG3 ARG A  11      16.166   8.198  34.794  1.00  0.00           H  
ATOM    121  HD2 ARG A  11      14.505   8.410  36.380  1.00  0.00           H  
ATOM    122  HD3 ARG A  11      13.620   7.002  35.792  1.00  0.00           H  
ATOM    123  HE  ARG A  11      15.671   7.034  37.777  1.00  0.00           H  
ATOM    124 HH11 ARG A  11      14.226   5.111  35.260  1.00  0.00           H  
ATOM    125 HH12 ARG A  11      14.695   3.599  35.967  1.00  0.00           H  
ATOM    126 HH21 ARG A  11      16.294   5.052  38.717  1.00  0.00           H  
ATOM    127 HH22 ARG A  11      15.870   3.567  37.934  1.00  0.00           H  
ATOM    128  N   VAL A  12      14.609  10.450  31.497  1.00  0.00           N  
ATOM    129  CA  VAL A  12      14.464  10.925  30.125  1.00  0.00           C  
ATOM    130  C   VAL A  12      15.785  10.836  29.370  1.00  0.00           C  
ATOM    131  O   VAL A  12      16.279  11.833  28.843  1.00  0.00           O  
ATOM    132  CB  VAL A  12      13.960  12.380  30.087  1.00  0.00           C  
ATOM    133  CG1 VAL A  12      12.517  12.459  30.562  1.00  0.00           C  
ATOM    134  CG2 VAL A  12      14.857  13.278  30.926  1.00  0.00           C  
ATOM    135  H   VAL A  12      15.362  10.770  32.036  1.00  0.00           H  
ATOM    136  HA  VAL A  12      13.735  10.301  29.631  1.00  0.00           H  
ATOM    137  HB  VAL A  12      13.998  12.725  29.063  1.00  0.00           H  
ATOM    138 HG11 VAL A  12      12.372  11.772  31.383  1.00  0.00           H  
ATOM    139 HG12 VAL A  12      12.300  13.465  30.889  1.00  0.00           H  
ATOM    140 HG13 VAL A  12      11.857  12.194  29.750  1.00  0.00           H  
ATOM    141 HG21 VAL A  12      14.931  12.878  31.927  1.00  0.00           H  
ATOM    142 HG22 VAL A  12      15.839  13.320  30.481  1.00  0.00           H  
ATOM    143 HG23 VAL A  12      14.436  14.272  30.966  1.00  0.00           H  
ATOM    144  N   ASP A  13      16.353   9.636  29.322  1.00  0.00           N  
ATOM    145  CA  ASP A  13      17.616   9.416  28.629  1.00  0.00           C  
ATOM    146  C   ASP A  13      17.377   8.956  27.195  1.00  0.00           C  
ATOM    147  O   ASP A  13      16.828   7.880  26.960  1.00  0.00           O  
ATOM    148  CB  ASP A  13      18.458   8.379  29.377  1.00  0.00           C  
ATOM    149  CG  ASP A  13      19.028   8.922  30.672  1.00  0.00           C  
ATOM    150  OD1 ASP A  13      20.081   9.591  30.622  1.00  0.00           O  
ATOM    151  OD2 ASP A  13      18.422   8.676  31.737  1.00  0.00           O  
ATOM    152  H   ASP A  13      15.911   8.880  29.762  1.00  0.00           H  
ATOM    153  HA  ASP A  13      18.153  10.353  28.609  1.00  0.00           H  
ATOM    154  HB2 ASP A  13      17.842   7.523  29.607  1.00  0.00           H  
ATOM    155  HB3 ASP A  13      19.278   8.067  28.745  1.00  0.00           H  
ATOM    156  N   TYR A  14      17.792   9.778  26.238  1.00  0.00           N  
ATOM    157  CA  TYR A  14      17.620   9.459  24.826  1.00  0.00           C  
ATOM    158  C   TYR A  14      18.745  10.061  23.989  1.00  0.00           C  
ATOM    159  O   TYR A  14      19.096  11.231  24.149  1.00  0.00           O  
ATOM    160  CB  TYR A  14      16.267   9.971  24.327  1.00  0.00           C  
ATOM    161  CG  TYR A  14      16.028  11.435  24.621  1.00  0.00           C  
ATOM    162  CD1 TYR A  14      15.884  11.886  25.927  1.00  0.00           C  
ATOM    163  CD2 TYR A  14      15.946  12.365  23.594  1.00  0.00           C  
ATOM    164  CE1 TYR A  14      15.664  13.222  26.201  1.00  0.00           C  
ATOM    165  CE2 TYR A  14      15.729  13.704  23.858  1.00  0.00           C  
ATOM    166  CZ  TYR A  14      15.588  14.127  25.163  1.00  0.00           C  
ATOM    167  OH  TYR A  14      15.370  15.459  25.430  1.00  0.00           O  
ATOM    168  H   TYR A  14      18.224  10.623  26.487  1.00  0.00           H  
ATOM    169  HA  TYR A  14      17.647   8.384  24.724  1.00  0.00           H  
ATOM    170  HB2 TYR A  14      16.211   9.835  23.258  1.00  0.00           H  
ATOM    171  HB3 TYR A  14      15.479   9.404  24.800  1.00  0.00           H  
ATOM    172  HD1 TYR A  14      15.944  11.175  26.738  1.00  0.00           H  
ATOM    173  HD2 TYR A  14      16.057  12.030  22.572  1.00  0.00           H  
ATOM    174  HE1 TYR A  14      15.554  13.555  27.223  1.00  0.00           H  
ATOM    175  HE2 TYR A  14      15.669  14.412  23.045  1.00  0.00           H  
ATOM    176  HH  TYR A  14      15.057  15.898  24.635  1.00  0.00           H  
ATOM    177  N   LEU A  15      19.306   9.253  23.097  1.00  0.00           N  
ATOM    178  CA  LEU A  15      20.391   9.705  22.232  1.00  0.00           C  
ATOM    179  C   LEU A  15      19.847  10.458  21.023  1.00  0.00           C  
ATOM    180  O   LEU A  15      19.010   9.942  20.282  1.00  0.00           O  
ATOM    181  CB  LEU A  15      21.231   8.512  21.770  1.00  0.00           C  
ATOM    182  CG  LEU A  15      22.653   8.832  21.307  1.00  0.00           C  
ATOM    183  CD1 LEU A  15      22.639   9.949  20.275  1.00  0.00           C  
ATOM    184  CD2 LEU A  15      23.528   9.210  22.494  1.00  0.00           C  
ATOM    185  H   LEU A  15      18.983   8.332  23.016  1.00  0.00           H  
ATOM    186  HA  LEU A  15      21.016  10.373  22.807  1.00  0.00           H  
ATOM    187  HB2 LEU A  15      21.300   7.818  22.593  1.00  0.00           H  
ATOM    188  HB3 LEU A  15      20.712   8.042  20.947  1.00  0.00           H  
ATOM    189  HG  LEU A  15      23.080   7.954  20.843  1.00  0.00           H  
ATOM    190 HD11 LEU A  15      23.590   9.977  19.763  1.00  0.00           H  
ATOM    191 HD12 LEU A  15      22.469  10.893  20.769  1.00  0.00           H  
ATOM    192 HD13 LEU A  15      21.850   9.768  19.560  1.00  0.00           H  
ATOM    193 HD21 LEU A  15      23.898   8.314  22.968  1.00  0.00           H  
ATOM    194 HD22 LEU A  15      22.945   9.779  23.203  1.00  0.00           H  
ATOM    195 HD23 LEU A  15      24.360   9.807  22.151  1.00  0.00           H  
ATOM    196  N   VAL A  16      20.330  11.681  20.829  1.00  0.00           N  
ATOM    197  CA  VAL A  16      19.894  12.505  19.706  1.00  0.00           C  
ATOM    198  C   VAL A  16      21.001  12.646  18.667  1.00  0.00           C  
ATOM    199  O   VAL A  16      22.134  13.001  18.993  1.00  0.00           O  
ATOM    200  CB  VAL A  16      19.461  13.907  20.174  1.00  0.00           C  
ATOM    201  CG1 VAL A  16      18.574  13.808  21.406  1.00  0.00           C  
ATOM    202  CG2 VAL A  16      20.679  14.774  20.452  1.00  0.00           C  
ATOM    203  H   VAL A  16      20.994  12.038  21.453  1.00  0.00           H  
ATOM    204  HA  VAL A  16      19.043  12.022  19.248  1.00  0.00           H  
ATOM    205  HB  VAL A  16      18.889  14.367  19.382  1.00  0.00           H  
ATOM    206 HG11 VAL A  16      19.184  13.599  22.272  1.00  0.00           H  
ATOM    207 HG12 VAL A  16      18.051  14.743  21.549  1.00  0.00           H  
ATOM    208 HG13 VAL A  16      17.858  13.012  21.270  1.00  0.00           H  
ATOM    209 HG21 VAL A  16      21.445  14.180  20.926  1.00  0.00           H  
ATOM    210 HG22 VAL A  16      21.056  15.173  19.521  1.00  0.00           H  
ATOM    211 HG23 VAL A  16      20.400  15.589  21.104  1.00  0.00           H  
ATOM    212  N   THR A  17      20.664  12.368  17.411  1.00  0.00           N  
ATOM    213  CA  THR A  17      21.629  12.463  16.323  1.00  0.00           C  
ATOM    214  C   THR A  17      21.138  13.410  15.234  1.00  0.00           C  
ATOM    215  O   THR A  17      19.962  13.393  14.869  1.00  0.00           O  
ATOM    216  CB  THR A  17      21.911  11.084  15.698  1.00  0.00           C  
ATOM    217  OG1 THR A  17      20.681  10.466  15.301  1.00  0.00           O  
ATOM    218  CG2 THR A  17      22.642  10.183  16.682  1.00  0.00           C  
ATOM    219  H   THR A  17      19.746  12.090  17.214  1.00  0.00           H  
ATOM    220  HA  THR A  17      22.553  12.846  16.730  1.00  0.00           H  
ATOM    221  HB  THR A  17      22.534  11.221  14.826  1.00  0.00           H  
ATOM    222  HG1 THR A  17      20.170  10.240  16.083  1.00  0.00           H  
ATOM    223 HG21 THR A  17      23.699  10.403  16.653  1.00  0.00           H  
ATOM    224 HG22 THR A  17      22.481   9.150  16.414  1.00  0.00           H  
ATOM    225 HG23 THR A  17      22.265  10.359  17.679  1.00  0.00           H  
ATOM    226  N   GLU A  18      22.044  14.236  14.719  1.00  0.00           N  
ATOM    227  CA  GLU A  18      21.700  15.190  13.672  1.00  0.00           C  
ATOM    228  C   GLU A  18      21.993  14.611  12.291  1.00  0.00           C  
ATOM    229  O   GLU A  18      23.129  14.248  11.988  1.00  0.00           O  
ATOM    230  CB  GLU A  18      22.476  16.494  13.866  1.00  0.00           C  
ATOM    231  CG  GLU A  18      21.833  17.442  14.865  1.00  0.00           C  
ATOM    232  CD  GLU A  18      22.822  18.433  15.448  1.00  0.00           C  
ATOM    233  OE1 GLU A  18      23.883  17.994  15.939  1.00  0.00           O  
ATOM    234  OE2 GLU A  18      22.535  19.648  15.413  1.00  0.00           O  
ATOM    235  H   GLU A  18      22.965  14.202  15.053  1.00  0.00           H  
ATOM    236  HA  GLU A  18      20.643  15.396  13.745  1.00  0.00           H  
ATOM    237  HB2 GLU A  18      23.472  16.259  14.212  1.00  0.00           H  
ATOM    238  HB3 GLU A  18      22.547  17.002  12.914  1.00  0.00           H  
ATOM    239  HG2 GLU A  18      21.049  17.992  14.365  1.00  0.00           H  
ATOM    240  HG3 GLU A  18      21.409  16.862  15.670  1.00  0.00           H  
ATOM    241  N   GLU A  19      20.960  14.528  11.459  1.00  0.00           N  
ATOM    242  CA  GLU A  19      21.107  13.991  10.111  1.00  0.00           C  
ATOM    243  C   GLU A  19      20.399  14.880   9.092  1.00  0.00           C  
ATOM    244  O   GLU A  19      19.408  15.536   9.409  1.00  0.00           O  
ATOM    245  CB  GLU A  19      20.546  12.570  10.040  1.00  0.00           C  
ATOM    246  CG  GLU A  19      20.980  11.805   8.800  1.00  0.00           C  
ATOM    247  CD  GLU A  19      22.393  11.267   8.912  1.00  0.00           C  
ATOM    248  OE1 GLU A  19      22.615  10.346   9.727  1.00  0.00           O  
ATOM    249  OE2 GLU A  19      23.277  11.766   8.186  1.00  0.00           O  
ATOM    250  H   GLU A  19      20.079  14.833  11.759  1.00  0.00           H  
ATOM    251  HA  GLU A  19      22.160  13.965   9.877  1.00  0.00           H  
ATOM    252  HB2 GLU A  19      20.875  12.022  10.910  1.00  0.00           H  
ATOM    253  HB3 GLU A  19      19.467  12.621  10.045  1.00  0.00           H  
ATOM    254  HG2 GLU A  19      20.306  10.975   8.650  1.00  0.00           H  
ATOM    255  HG3 GLU A  19      20.929  12.467   7.949  1.00  0.00           H  
ATOM    256  N   GLU A  20      20.919  14.897   7.868  1.00  0.00           N  
ATOM    257  CA  GLU A  20      20.339  15.706   6.803  1.00  0.00           C  
ATOM    258  C   GLU A  20      19.631  14.827   5.776  1.00  0.00           C  
ATOM    259  O   GLU A  20      20.270  14.053   5.062  1.00  0.00           O  
ATOM    260  CB  GLU A  20      21.423  16.540   6.118  1.00  0.00           C  
ATOM    261  CG  GLU A  20      20.893  17.799   5.452  1.00  0.00           C  
ATOM    262  CD  GLU A  20      21.973  18.571   4.720  1.00  0.00           C  
ATOM    263  OE1 GLU A  20      22.256  18.233   3.552  1.00  0.00           O  
ATOM    264  OE2 GLU A  20      22.535  19.513   5.317  1.00  0.00           O  
ATOM    265  H   GLU A  20      21.711  14.352   7.677  1.00  0.00           H  
ATOM    266  HA  GLU A  20      19.615  16.371   7.249  1.00  0.00           H  
ATOM    267  HB2 GLU A  20      22.158  16.829   6.855  1.00  0.00           H  
ATOM    268  HB3 GLU A  20      21.903  15.934   5.363  1.00  0.00           H  
ATOM    269  HG2 GLU A  20      20.127  17.521   4.743  1.00  0.00           H  
ATOM    270  HG3 GLU A  20      20.464  18.438   6.210  1.00  0.00           H  
ATOM    271  N   ILE A  21      18.311  14.953   5.707  1.00  0.00           N  
ATOM    272  CA  ILE A  21      17.517  14.171   4.767  1.00  0.00           C  
ATOM    273  C   ILE A  21      17.242  14.960   3.491  1.00  0.00           C  
ATOM    274  O   ILE A  21      16.480  15.924   3.498  1.00  0.00           O  
ATOM    275  CB  ILE A  21      16.176  13.736   5.387  1.00  0.00           C  
ATOM    276  CG1 ILE A  21      16.405  13.116   6.767  1.00  0.00           C  
ATOM    277  CG2 ILE A  21      15.462  12.755   4.472  1.00  0.00           C  
ATOM    278  CD1 ILE A  21      16.945  11.704   6.714  1.00  0.00           C  
ATOM    279  H   ILE A  21      17.859  15.587   6.302  1.00  0.00           H  
ATOM    280  HA  ILE A  21      18.079  13.283   4.516  1.00  0.00           H  
ATOM    281  HB  ILE A  21      15.554  14.612   5.492  1.00  0.00           H  
ATOM    282 HG12 ILE A  21      17.112  13.720   7.314  1.00  0.00           H  
ATOM    283 HG13 ILE A  21      15.467  13.094   7.304  1.00  0.00           H  
ATOM    284 HG21 ILE A  21      14.990  13.293   3.664  1.00  0.00           H  
ATOM    285 HG22 ILE A  21      16.178  12.055   4.067  1.00  0.00           H  
ATOM    286 HG23 ILE A  21      14.712  12.218   5.032  1.00  0.00           H  
ATOM    287 HD11 ILE A  21      17.357  11.515   5.733  1.00  0.00           H  
ATOM    288 HD12 ILE A  21      17.718  11.586   7.457  1.00  0.00           H  
ATOM    289 HD13 ILE A  21      16.146  11.005   6.909  1.00  0.00           H  
ATOM    290  N   ASN A  22      17.869  14.540   2.396  1.00  0.00           N  
ATOM    291  CA  ASN A  22      17.690  15.206   1.112  1.00  0.00           C  
ATOM    292  C   ASN A  22      16.691  14.450   0.241  1.00  0.00           C  
ATOM    293  O   ASN A  22      16.991  13.371  -0.274  1.00  0.00           O  
ATOM    294  CB  ASN A  22      19.032  15.323   0.384  1.00  0.00           C  
ATOM    295  CG  ASN A  22      19.940  16.363   1.010  1.00  0.00           C  
ATOM    296  OD1 ASN A  22      20.383  17.298   0.344  1.00  0.00           O  
ATOM    297  ND2 ASN A  22      20.223  16.203   2.297  1.00  0.00           N  
ATOM    298  H   ASN A  22      18.464  13.764   2.454  1.00  0.00           H  
ATOM    299  HA  ASN A  22      17.307  16.197   1.302  1.00  0.00           H  
ATOM    300  HB2 ASN A  22      19.535  14.367   0.414  1.00  0.00           H  
ATOM    301  HB3 ASN A  22      18.854  15.598  -0.645  1.00  0.00           H  
ATOM    302 HD21 ASN A  22      19.834  15.433   2.766  1.00  0.00           H  
ATOM    303 HD22 ASN A  22      20.808  16.861   2.728  1.00  0.00           H  
ATOM    304  N   LEU A  23      15.504  15.022   0.080  1.00  0.00           N  
ATOM    305  CA  LEU A  23      14.459  14.404  -0.730  1.00  0.00           C  
ATOM    306  C   LEU A  23      14.215  15.203  -2.007  1.00  0.00           C  
ATOM    307  O   LEU A  23      14.605  16.366  -2.109  1.00  0.00           O  
ATOM    308  CB  LEU A  23      13.162  14.296   0.074  1.00  0.00           C  
ATOM    309  CG  LEU A  23      13.245  13.501   1.377  1.00  0.00           C  
ATOM    310  CD1 LEU A  23      12.009  13.746   2.231  1.00  0.00           C  
ATOM    311  CD2 LEU A  23      13.409  12.016   1.087  1.00  0.00           C  
ATOM    312  H   LEU A  23      15.324  15.882   0.514  1.00  0.00           H  
ATOM    313  HA  LEU A  23      14.791  13.413  -0.998  1.00  0.00           H  
ATOM    314  HB2 LEU A  23      12.839  15.296   0.316  1.00  0.00           H  
ATOM    315  HB3 LEU A  23      12.422  13.823  -0.558  1.00  0.00           H  
ATOM    316  HG  LEU A  23      14.108  13.830   1.938  1.00  0.00           H  
ATOM    317 HD11 LEU A  23      11.705  12.821   2.697  1.00  0.00           H  
ATOM    318 HD12 LEU A  23      11.209  14.115   1.608  1.00  0.00           H  
ATOM    319 HD13 LEU A  23      12.238  14.476   2.993  1.00  0.00           H  
ATOM    320 HD21 LEU A  23      13.642  11.877   0.042  1.00  0.00           H  
ATOM    321 HD22 LEU A  23      12.489  11.500   1.323  1.00  0.00           H  
ATOM    322 HD23 LEU A  23      14.210  11.618   1.692  1.00  0.00           H  
ATOM    323  N   THR A  24      13.564  14.570  -2.978  1.00  0.00           N  
ATOM    324  CA  THR A  24      13.266  15.221  -4.248  1.00  0.00           C  
ATOM    325  C   THR A  24      11.830  15.732  -4.280  1.00  0.00           C  
ATOM    326  O   THR A  24      10.920  15.089  -3.755  1.00  0.00           O  
ATOM    327  CB  THR A  24      13.486  14.264  -5.434  1.00  0.00           C  
ATOM    328  OG1 THR A  24      14.690  13.514  -5.242  1.00  0.00           O  
ATOM    329  CG2 THR A  24      13.565  15.035  -6.744  1.00  0.00           C  
ATOM    330  H   THR A  24      13.278  13.644  -2.836  1.00  0.00           H  
ATOM    331  HA  THR A  24      13.939  16.059  -4.359  1.00  0.00           H  
ATOM    332  HB  THR A  24      12.650  13.582  -5.486  1.00  0.00           H  
ATOM    333  HG1 THR A  24      15.443  14.112  -5.243  1.00  0.00           H  
ATOM    334 HG21 THR A  24      12.569  15.191  -7.130  1.00  0.00           H  
ATOM    335 HG22 THR A  24      14.143  14.471  -7.460  1.00  0.00           H  
ATOM    336 HG23 THR A  24      14.038  15.990  -6.570  1.00  0.00           H  
ATOM    337  N   ARG A  25      11.633  16.891  -4.900  1.00  0.00           N  
ATOM    338  CA  ARG A  25      10.307  17.487  -5.000  1.00  0.00           C  
ATOM    339  C   ARG A  25       9.433  16.711  -5.981  1.00  0.00           C  
ATOM    340  O   ARG A  25       9.768  16.581  -7.158  1.00  0.00           O  
ATOM    341  CB  ARG A  25      10.414  18.949  -5.444  1.00  0.00           C  
ATOM    342  CG  ARG A  25       9.072  19.657  -5.535  1.00  0.00           C  
ATOM    343  CD  ARG A  25       9.130  20.839  -6.490  1.00  0.00           C  
ATOM    344  NE  ARG A  25       7.824  21.141  -7.068  1.00  0.00           N  
ATOM    345  CZ  ARG A  25       7.531  22.292  -7.662  1.00  0.00           C  
ATOM    346  NH1 ARG A  25       8.449  23.244  -7.758  1.00  0.00           N  
ATOM    347  NH2 ARG A  25       6.319  22.492  -8.163  1.00  0.00           N  
ATOM    348  H   ARG A  25      12.398  17.356  -5.299  1.00  0.00           H  
ATOM    349  HA  ARG A  25       9.850  17.450  -4.022  1.00  0.00           H  
ATOM    350  HB2 ARG A  25      11.030  19.483  -4.736  1.00  0.00           H  
ATOM    351  HB3 ARG A  25      10.882  18.983  -6.415  1.00  0.00           H  
ATOM    352  HG2 ARG A  25       8.330  18.957  -5.891  1.00  0.00           H  
ATOM    353  HG3 ARG A  25       8.795  20.011  -4.554  1.00  0.00           H  
ATOM    354  HD2 ARG A  25       9.483  21.704  -5.950  1.00  0.00           H  
ATOM    355  HD3 ARG A  25       9.821  20.606  -7.287  1.00  0.00           H  
ATOM    356  HE  ARG A  25       7.131  20.451  -7.008  1.00  0.00           H  
ATOM    357 HH11 ARG A  25       9.363  23.096  -7.383  1.00  0.00           H  
ATOM    358 HH12 ARG A  25       8.226  24.109  -8.208  1.00  0.00           H  
ATOM    359 HH21 ARG A  25       5.625  21.777  -8.093  1.00  0.00           H  
ATOM    360 HH22 ARG A  25       6.099  23.358  -8.611  1.00  0.00           H  
ATOM    361  N   GLY A  26       8.312  16.195  -5.486  1.00  0.00           N  
ATOM    362  CA  GLY A  26       7.408  15.436  -6.332  1.00  0.00           C  
ATOM    363  C   GLY A  26       6.738  16.298  -7.384  1.00  0.00           C  
ATOM    364  O   GLY A  26       7.230  17.367  -7.747  1.00  0.00           O  
ATOM    365  H   GLY A  26       8.096  16.330  -4.540  1.00  0.00           H  
ATOM    366  HA2 GLY A  26       7.965  14.653  -6.824  1.00  0.00           H  
ATOM    367  HA3 GLY A  26       6.646  14.988  -5.712  1.00  0.00           H  
ATOM    368  N   PRO A  27       5.590  15.829  -7.894  1.00  0.00           N  
ATOM    369  CA  PRO A  27       4.827  16.549  -8.918  1.00  0.00           C  
ATOM    370  C   PRO A  27       4.182  17.819  -8.377  1.00  0.00           C  
ATOM    371  O   PRO A  27       3.746  18.680  -9.141  1.00  0.00           O  
ATOM    372  CB  PRO A  27       3.753  15.540  -9.335  1.00  0.00           C  
ATOM    373  CG  PRO A  27       3.589  14.651  -8.150  1.00  0.00           C  
ATOM    374  CD  PRO A  27       4.946  14.562  -7.508  1.00  0.00           C  
ATOM    375  HA  PRO A  27       5.443  16.793  -9.772  1.00  0.00           H  
ATOM    376  HB2 PRO A  27       2.837  16.063  -9.568  1.00  0.00           H  
ATOM    377  HB3 PRO A  27       4.089  14.987 -10.200  1.00  0.00           H  
ATOM    378  HG2 PRO A  27       2.877  15.082  -7.464  1.00  0.00           H  
ATOM    379  HG3 PRO A  27       3.261  13.673  -8.470  1.00  0.00           H  
ATOM    380  HD2 PRO A  27       4.852  14.489  -6.435  1.00  0.00           H  
ATOM    381  HD3 PRO A  27       5.494  13.718  -7.900  1.00  0.00           H  
ATOM    382  N   SER A  28       4.127  17.932  -7.054  1.00  0.00           N  
ATOM    383  CA  SER A  28       3.533  19.097  -6.409  1.00  0.00           C  
ATOM    384  C   SER A  28       4.471  19.671  -5.352  1.00  0.00           C  
ATOM    385  O   SER A  28       4.662  20.883  -5.267  1.00  0.00           O  
ATOM    386  CB  SER A  28       2.193  18.725  -5.770  1.00  0.00           C  
ATOM    387  OG  SER A  28       1.274  18.265  -6.745  1.00  0.00           O  
ATOM    388  H   SER A  28       4.493  17.212  -6.497  1.00  0.00           H  
ATOM    389  HA  SER A  28       3.364  19.846  -7.169  1.00  0.00           H  
ATOM    390  HB2 SER A  28       2.350  17.943  -5.043  1.00  0.00           H  
ATOM    391  HB3 SER A  28       1.777  19.595  -5.282  1.00  0.00           H  
ATOM    392  HG  SER A  28       1.752  17.846  -7.464  1.00  0.00           H  
ATOM    393  N   GLY A  29       5.057  18.789  -4.547  1.00  0.00           N  
ATOM    394  CA  GLY A  29       5.967  19.226  -3.505  1.00  0.00           C  
ATOM    395  C   GLY A  29       6.593  18.065  -2.758  1.00  0.00           C  
ATOM    396  O   GLY A  29       7.724  17.668  -3.046  1.00  0.00           O  
ATOM    397  H   GLY A  29       4.867  17.834  -4.660  1.00  0.00           H  
ATOM    398  HA2 GLY A  29       6.752  19.817  -3.953  1.00  0.00           H  
ATOM    399  HA3 GLY A  29       5.424  19.840  -2.802  1.00  0.00           H  
ATOM    400  N   LEU A  30       5.860  17.520  -1.794  1.00  0.00           N  
ATOM    401  CA  LEU A  30       6.350  16.398  -1.002  1.00  0.00           C  
ATOM    402  C   LEU A  30       5.217  15.434  -0.663  1.00  0.00           C  
ATOM    403  O   LEU A  30       4.083  15.614  -1.103  1.00  0.00           O  
ATOM    404  CB  LEU A  30       7.005  16.904   0.285  1.00  0.00           C  
ATOM    405  CG  LEU A  30       8.072  17.986   0.113  1.00  0.00           C  
ATOM    406  CD1 LEU A  30       8.120  18.887   1.337  1.00  0.00           C  
ATOM    407  CD2 LEU A  30       9.434  17.357  -0.141  1.00  0.00           C  
ATOM    408  H   LEU A  30       4.967  17.879  -1.611  1.00  0.00           H  
ATOM    409  HA  LEU A  30       7.089  15.874  -1.590  1.00  0.00           H  
ATOM    410  HB2 LEU A  30       6.228  17.304   0.916  1.00  0.00           H  
ATOM    411  HB3 LEU A  30       7.466  16.059   0.775  1.00  0.00           H  
ATOM    412  HG  LEU A  30       7.820  18.599  -0.742  1.00  0.00           H  
ATOM    413 HD11 LEU A  30       8.483  18.325   2.184  1.00  0.00           H  
ATOM    414 HD12 LEU A  30       7.129  19.258   1.550  1.00  0.00           H  
ATOM    415 HD13 LEU A  30       8.782  19.719   1.147  1.00  0.00           H  
ATOM    416 HD21 LEU A  30      10.162  17.793   0.526  1.00  0.00           H  
ATOM    417 HD22 LEU A  30       9.728  17.539  -1.165  1.00  0.00           H  
ATOM    418 HD23 LEU A  30       9.377  16.293   0.031  1.00  0.00           H  
ATOM    419  N   GLY A  31       5.534  14.410   0.124  1.00  0.00           N  
ATOM    420  CA  GLY A  31       4.531  13.434   0.510  1.00  0.00           C  
ATOM    421  C   GLY A  31       4.548  13.144   1.998  1.00  0.00           C  
ATOM    422  O   GLY A  31       4.800  12.012   2.414  1.00  0.00           O  
ATOM    423  H   GLY A  31       6.455  14.317   0.446  1.00  0.00           H  
ATOM    424  HA2 GLY A  31       3.556  13.809   0.237  1.00  0.00           H  
ATOM    425  HA3 GLY A  31       4.716  12.515  -0.027  1.00  0.00           H  
ATOM    426  N   PHE A  32       4.280  14.166   2.802  1.00  0.00           N  
ATOM    427  CA  PHE A  32       4.268  14.016   4.253  1.00  0.00           C  
ATOM    428  C   PHE A  32       3.764  15.288   4.927  1.00  0.00           C  
ATOM    429  O   PHE A  32       4.026  16.397   4.460  1.00  0.00           O  
ATOM    430  CB  PHE A  32       5.670  13.675   4.763  1.00  0.00           C  
ATOM    431  CG  PHE A  32       6.667  14.780   4.560  1.00  0.00           C  
ATOM    432  CD1 PHE A  32       6.678  15.882   5.399  1.00  0.00           C  
ATOM    433  CD2 PHE A  32       7.592  14.716   3.531  1.00  0.00           C  
ATOM    434  CE1 PHE A  32       7.594  16.901   5.214  1.00  0.00           C  
ATOM    435  CE2 PHE A  32       8.511  15.730   3.342  1.00  0.00           C  
ATOM    436  CZ  PHE A  32       8.513  16.825   4.185  1.00  0.00           C  
ATOM    437  H   PHE A  32       4.087  15.044   2.410  1.00  0.00           H  
ATOM    438  HA  PHE A  32       3.599  13.205   4.495  1.00  0.00           H  
ATOM    439  HB2 PHE A  32       5.619  13.465   5.821  1.00  0.00           H  
ATOM    440  HB3 PHE A  32       6.031  12.801   4.243  1.00  0.00           H  
ATOM    441  HD1 PHE A  32       5.962  15.944   6.205  1.00  0.00           H  
ATOM    442  HD2 PHE A  32       7.592  13.861   2.871  1.00  0.00           H  
ATOM    443  HE1 PHE A  32       7.593  17.755   5.875  1.00  0.00           H  
ATOM    444  HE2 PHE A  32       9.227  15.668   2.536  1.00  0.00           H  
ATOM    445  HZ  PHE A  32       9.229  17.620   4.039  1.00  0.00           H  
ATOM    446  N   ASN A  33       3.040  15.121   6.029  1.00  0.00           N  
ATOM    447  CA  ASN A  33       2.498  16.255   6.767  1.00  0.00           C  
ATOM    448  C   ASN A  33       3.460  16.698   7.865  1.00  0.00           C  
ATOM    449  O   ASN A  33       4.261  15.905   8.359  1.00  0.00           O  
ATOM    450  CB  ASN A  33       1.142  15.893   7.377  1.00  0.00           C  
ATOM    451  CG  ASN A  33       0.413  17.103   7.927  1.00  0.00           C  
ATOM    452  OD1 ASN A  33       0.142  17.188   9.124  1.00  0.00           O  
ATOM    453  ND2 ASN A  33       0.092  18.048   7.051  1.00  0.00           N  
ATOM    454  H   ASN A  33       2.865  14.212   6.352  1.00  0.00           H  
ATOM    455  HA  ASN A  33       2.363  17.069   6.072  1.00  0.00           H  
ATOM    456  HB2 ASN A  33       0.523  15.438   6.617  1.00  0.00           H  
ATOM    457  HB3 ASN A  33       1.293  15.189   8.182  1.00  0.00           H  
ATOM    458 HD21 ASN A  33       0.340  17.913   6.112  1.00  0.00           H  
ATOM    459 HD22 ASN A  33      -0.379  18.842   7.380  1.00  0.00           H  
ATOM    460  N   ILE A  34       3.374  17.969   8.242  1.00  0.00           N  
ATOM    461  CA  ILE A  34       4.234  18.518   9.282  1.00  0.00           C  
ATOM    462  C   ILE A  34       3.429  19.327  10.294  1.00  0.00           C  
ATOM    463  O   ILE A  34       2.323  19.781  10.001  1.00  0.00           O  
ATOM    464  CB  ILE A  34       5.337  19.413   8.686  1.00  0.00           C  
ATOM    465  CG1 ILE A  34       4.737  20.393   7.675  1.00  0.00           C  
ATOM    466  CG2 ILE A  34       6.415  18.563   8.032  1.00  0.00           C  
ATOM    467  CD1 ILE A  34       5.523  21.679   7.542  1.00  0.00           C  
ATOM    468  H   ILE A  34       2.714  18.553   7.811  1.00  0.00           H  
ATOM    469  HA  ILE A  34       4.707  17.692   9.793  1.00  0.00           H  
ATOM    470  HB  ILE A  34       5.791  19.971   9.491  1.00  0.00           H  
ATOM    471 HG12 ILE A  34       4.703  19.924   6.705  1.00  0.00           H  
ATOM    472 HG13 ILE A  34       3.734  20.647   7.984  1.00  0.00           H  
ATOM    473 HG21 ILE A  34       5.992  17.615   7.732  1.00  0.00           H  
ATOM    474 HG22 ILE A  34       6.800  19.075   7.163  1.00  0.00           H  
ATOM    475 HG23 ILE A  34       7.216  18.393   8.736  1.00  0.00           H  
ATOM    476 HD11 ILE A  34       5.175  22.224   6.676  1.00  0.00           H  
ATOM    477 HD12 ILE A  34       5.379  22.283   8.425  1.00  0.00           H  
ATOM    478 HD13 ILE A  34       6.571  21.451   7.426  1.00  0.00           H  
ATOM    479  N   VAL A  35       3.992  19.505  11.483  1.00  0.00           N  
ATOM    480  CA  VAL A  35       3.328  20.262  12.538  1.00  0.00           C  
ATOM    481  C   VAL A  35       4.274  21.283  13.161  1.00  0.00           C  
ATOM    482  O   VAL A  35       5.321  20.925  13.700  1.00  0.00           O  
ATOM    483  CB  VAL A  35       2.792  19.334  13.643  1.00  0.00           C  
ATOM    484  CG1 VAL A  35       1.664  18.464  13.109  1.00  0.00           C  
ATOM    485  CG2 VAL A  35       3.914  18.477  14.210  1.00  0.00           C  
ATOM    486  H   VAL A  35       4.877  19.119  11.657  1.00  0.00           H  
ATOM    487  HA  VAL A  35       2.491  20.784  12.097  1.00  0.00           H  
ATOM    488  HB  VAL A  35       2.397  19.946  14.441  1.00  0.00           H  
ATOM    489 HG11 VAL A  35       0.962  19.079  12.566  1.00  0.00           H  
ATOM    490 HG12 VAL A  35       2.070  17.712  12.449  1.00  0.00           H  
ATOM    491 HG13 VAL A  35       1.158  17.985  13.934  1.00  0.00           H  
ATOM    492 HG21 VAL A  35       4.754  18.488  13.531  1.00  0.00           H  
ATOM    493 HG22 VAL A  35       4.219  18.872  15.168  1.00  0.00           H  
ATOM    494 HG23 VAL A  35       3.565  17.461  14.333  1.00  0.00           H  
ATOM    495  N   GLY A  36       3.897  22.555  13.085  1.00  0.00           N  
ATOM    496  CA  GLY A  36       4.723  23.608  13.646  1.00  0.00           C  
ATOM    497  C   GLY A  36       4.023  24.954  13.653  1.00  0.00           C  
ATOM    498  O   GLY A  36       2.896  25.076  13.173  1.00  0.00           O  
ATOM    499  H   GLY A  36       3.051  22.781  12.644  1.00  0.00           H  
ATOM    500  HA2 GLY A  36       4.983  23.345  14.661  1.00  0.00           H  
ATOM    501  HA3 GLY A  36       5.628  23.689  13.063  1.00  0.00           H  
ATOM    502  N   GLY A  37       4.691  25.965  14.199  1.00  0.00           N  
ATOM    503  CA  GLY A  37       4.109  27.293  14.257  1.00  0.00           C  
ATOM    504  C   GLY A  37       3.897  27.770  15.680  1.00  0.00           C  
ATOM    505  O   GLY A  37       3.210  27.117  16.466  1.00  0.00           O  
ATOM    506  H   GLY A  37       5.587  25.807  14.566  1.00  0.00           H  
ATOM    507  HA2 GLY A  37       4.767  27.984  13.752  1.00  0.00           H  
ATOM    508  HA3 GLY A  37       3.157  27.278  13.748  1.00  0.00           H  
ATOM    509  N   THR A  38       4.486  28.914  16.014  1.00  0.00           N  
ATOM    510  CA  THR A  38       4.360  29.477  17.351  1.00  0.00           C  
ATOM    511  C   THR A  38       2.916  29.423  17.837  1.00  0.00           C  
ATOM    512  O   THR A  38       2.655  29.421  19.041  1.00  0.00           O  
ATOM    513  CB  THR A  38       4.849  30.937  17.396  1.00  0.00           C  
ATOM    514  OG1 THR A  38       4.117  31.727  16.452  1.00  0.00           O  
ATOM    515  CG2 THR A  38       6.336  31.019  17.087  1.00  0.00           C  
ATOM    516  H   THR A  38       5.021  29.388  15.343  1.00  0.00           H  
ATOM    517  HA  THR A  38       4.977  28.893  18.019  1.00  0.00           H  
ATOM    518  HB  THR A  38       4.681  31.327  18.389  1.00  0.00           H  
ATOM    519  HG1 THR A  38       3.782  31.162  15.752  1.00  0.00           H  
ATOM    520 HG21 THR A  38       6.731  31.951  17.463  1.00  0.00           H  
ATOM    521 HG22 THR A  38       6.485  30.971  16.018  1.00  0.00           H  
ATOM    522 HG23 THR A  38       6.848  30.194  17.559  1.00  0.00           H  
ATOM    523  N   ASP A  39       1.981  29.376  16.895  1.00  0.00           N  
ATOM    524  CA  ASP A  39       0.562  29.319  17.227  1.00  0.00           C  
ATOM    525  C   ASP A  39       0.075  27.875  17.284  1.00  0.00           C  
ATOM    526  O   ASP A  39      -0.833  27.546  18.047  1.00  0.00           O  
ATOM    527  CB  ASP A  39      -0.255  30.106  16.201  1.00  0.00           C  
ATOM    528  CG  ASP A  39      -0.492  29.321  14.925  1.00  0.00           C  
ATOM    529  OD1 ASP A  39       0.449  29.218  14.109  1.00  0.00           O  
ATOM    530  OD2 ASP A  39      -1.616  28.812  14.742  1.00  0.00           O  
ATOM    531  H   ASP A  39       2.252  29.380  15.952  1.00  0.00           H  
ATOM    532  HA  ASP A  39       0.431  29.769  18.199  1.00  0.00           H  
ATOM    533  HB2 ASP A  39      -1.215  30.356  16.630  1.00  0.00           H  
ATOM    534  HB3 ASP A  39       0.271  31.016  15.952  1.00  0.00           H  
ATOM    535  N   GLN A  40       0.685  27.018  16.472  1.00  0.00           N  
ATOM    536  CA  GLN A  40       0.311  25.609  16.430  1.00  0.00           C  
ATOM    537  C   GLN A  40       1.392  24.740  17.063  1.00  0.00           C  
ATOM    538  O   GLN A  40       1.466  23.539  16.807  1.00  0.00           O  
ATOM    539  CB  GLN A  40       0.066  25.167  14.986  1.00  0.00           C  
ATOM    540  CG  GLN A  40      -0.961  26.016  14.256  1.00  0.00           C  
ATOM    541  CD  GLN A  40      -1.664  25.257  13.148  1.00  0.00           C  
ATOM    542  OE1 GLN A  40      -1.076  24.386  12.506  1.00  0.00           O  
ATOM    543  NE2 GLN A  40      -2.931  25.583  12.919  1.00  0.00           N  
ATOM    544  H   GLN A  40       1.401  27.340  15.887  1.00  0.00           H  
ATOM    545  HA  GLN A  40      -0.602  25.491  16.992  1.00  0.00           H  
ATOM    546  HB2 GLN A  40       0.998  25.221  14.443  1.00  0.00           H  
ATOM    547  HB3 GLN A  40      -0.280  24.145  14.989  1.00  0.00           H  
ATOM    548  HG2 GLN A  40      -1.702  26.352  14.967  1.00  0.00           H  
ATOM    549  HG3 GLN A  40      -0.462  26.872  13.825  1.00  0.00           H  
ATOM    550 HE21 GLN A  40      -3.335  26.287  13.468  1.00  0.00           H  
ATOM    551 HE22 GLN A  40      -3.409  25.109  12.208  1.00  0.00           H  
ATOM    552  N   GLN A  41       2.230  25.355  17.892  1.00  0.00           N  
ATOM    553  CA  GLN A  41       3.308  24.637  18.561  1.00  0.00           C  
ATOM    554  C   GLN A  41       2.860  23.237  18.968  1.00  0.00           C  
ATOM    555  O   GLN A  41       2.170  23.063  19.973  1.00  0.00           O  
ATOM    556  CB  GLN A  41       3.778  25.413  19.793  1.00  0.00           C  
ATOM    557  CG  GLN A  41       4.469  26.725  19.459  1.00  0.00           C  
ATOM    558  CD  GLN A  41       5.118  27.367  20.670  1.00  0.00           C  
ATOM    559  OE1 GLN A  41       4.941  28.559  20.923  1.00  0.00           O  
ATOM    560  NE2 GLN A  41       5.874  26.580  21.424  1.00  0.00           N  
ATOM    561  H   GLN A  41       2.120  26.315  18.056  1.00  0.00           H  
ATOM    562  HA  GLN A  41       4.130  24.551  17.866  1.00  0.00           H  
ATOM    563  HB2 GLN A  41       2.923  25.630  20.416  1.00  0.00           H  
ATOM    564  HB3 GLN A  41       4.470  24.798  20.348  1.00  0.00           H  
ATOM    565  HG2 GLN A  41       5.232  26.537  18.719  1.00  0.00           H  
ATOM    566  HG3 GLN A  41       3.738  27.409  19.055  1.00  0.00           H  
ATOM    567 HE21 GLN A  41       5.971  25.640  21.160  1.00  0.00           H  
ATOM    568 HE22 GLN A  41       6.306  26.968  22.212  1.00  0.00           H  
ATOM    569  N   TYR A  42       3.254  22.244  18.180  1.00  0.00           N  
ATOM    570  CA  TYR A  42       2.891  20.859  18.456  1.00  0.00           C  
ATOM    571  C   TYR A  42       2.959  20.565  19.952  1.00  0.00           C  
ATOM    572  O   TYR A  42       2.282  19.668  20.453  1.00  0.00           O  
ATOM    573  CB  TYR A  42       3.813  19.906  17.695  1.00  0.00           C  
ATOM    574  CG  TYR A  42       3.426  18.450  17.831  1.00  0.00           C  
ATOM    575  CD1 TYR A  42       2.315  17.942  17.171  1.00  0.00           C  
ATOM    576  CD2 TYR A  42       4.173  17.583  18.620  1.00  0.00           C  
ATOM    577  CE1 TYR A  42       1.956  16.614  17.293  1.00  0.00           C  
ATOM    578  CE2 TYR A  42       3.823  16.253  18.746  1.00  0.00           C  
ATOM    579  CZ  TYR A  42       2.714  15.773  18.082  1.00  0.00           C  
ATOM    580  OH  TYR A  42       2.361  14.448  18.205  1.00  0.00           O  
ATOM    581  H   TYR A  42       3.802  22.446  17.393  1.00  0.00           H  
ATOM    582  HA  TYR A  42       1.876  20.708  18.117  1.00  0.00           H  
ATOM    583  HB2 TYR A  42       3.793  20.157  16.645  1.00  0.00           H  
ATOM    584  HB3 TYR A  42       4.821  20.017  18.067  1.00  0.00           H  
ATOM    585  HD1 TYR A  42       1.723  18.603  16.553  1.00  0.00           H  
ATOM    586  HD2 TYR A  42       5.041  17.963  19.139  1.00  0.00           H  
ATOM    587  HE1 TYR A  42       1.088  16.238  16.773  1.00  0.00           H  
ATOM    588  HE2 TYR A  42       4.415  15.594  19.364  1.00  0.00           H  
ATOM    589  HH  TYR A  42       3.126  13.896  18.027  1.00  0.00           H  
ATOM    590  N   VAL A  43       3.783  21.331  20.661  1.00  0.00           N  
ATOM    591  CA  VAL A  43       3.941  21.155  22.100  1.00  0.00           C  
ATOM    592  C   VAL A  43       4.101  22.498  22.803  1.00  0.00           C  
ATOM    593  O   VAL A  43       4.346  23.520  22.162  1.00  0.00           O  
ATOM    594  CB  VAL A  43       5.158  20.268  22.427  1.00  0.00           C  
ATOM    595  CG1 VAL A  43       4.928  19.505  23.723  1.00  0.00           C  
ATOM    596  CG2 VAL A  43       5.444  19.313  21.279  1.00  0.00           C  
ATOM    597  H   VAL A  43       4.298  22.029  20.205  1.00  0.00           H  
ATOM    598  HA  VAL A  43       3.054  20.667  22.476  1.00  0.00           H  
ATOM    599  HB  VAL A  43       6.018  20.907  22.560  1.00  0.00           H  
ATOM    600 HG11 VAL A  43       3.949  19.048  23.702  1.00  0.00           H  
ATOM    601 HG12 VAL A  43       5.682  18.739  23.828  1.00  0.00           H  
ATOM    602 HG13 VAL A  43       4.989  20.187  24.558  1.00  0.00           H  
ATOM    603 HG21 VAL A  43       6.359  18.775  21.478  1.00  0.00           H  
ATOM    604 HG22 VAL A  43       4.628  18.613  21.182  1.00  0.00           H  
ATOM    605 HG23 VAL A  43       5.548  19.873  20.361  1.00  0.00           H  
ATOM    606  N   SER A  44       3.961  22.489  24.124  1.00  0.00           N  
ATOM    607  CA  SER A  44       4.087  23.707  24.915  1.00  0.00           C  
ATOM    608  C   SER A  44       5.553  24.056  25.147  1.00  0.00           C  
ATOM    609  O   SER A  44       5.903  25.218  25.352  1.00  0.00           O  
ATOM    610  CB  SER A  44       3.370  23.546  26.258  1.00  0.00           C  
ATOM    611  OG  SER A  44       3.991  22.547  27.049  1.00  0.00           O  
ATOM    612  H   SER A  44       3.766  21.642  24.578  1.00  0.00           H  
ATOM    613  HA  SER A  44       3.622  24.510  24.363  1.00  0.00           H  
ATOM    614  HB2 SER A  44       3.400  24.482  26.793  1.00  0.00           H  
ATOM    615  HB3 SER A  44       2.343  23.263  26.082  1.00  0.00           H  
ATOM    616  HG  SER A  44       3.896  22.771  27.978  1.00  0.00           H  
ATOM    617  N   ASN A  45       6.409  23.038  25.115  1.00  0.00           N  
ATOM    618  CA  ASN A  45       7.839  23.236  25.322  1.00  0.00           C  
ATOM    619  C   ASN A  45       8.594  23.180  23.998  1.00  0.00           C  
ATOM    620  O   ASN A  45       9.823  23.249  23.967  1.00  0.00           O  
ATOM    621  CB  ASN A  45       8.387  22.175  26.279  1.00  0.00           C  
ATOM    622  CG  ASN A  45       9.886  22.297  26.480  1.00  0.00           C  
ATOM    623  OD1 ASN A  45      10.662  21.512  25.935  1.00  0.00           O  
ATOM    624  ND2 ASN A  45      10.299  23.284  27.266  1.00  0.00           N  
ATOM    625  H   ASN A  45       6.071  22.134  24.948  1.00  0.00           H  
ATOM    626  HA  ASN A  45       7.978  24.211  25.762  1.00  0.00           H  
ATOM    627  HB2 ASN A  45       7.906  22.282  27.240  1.00  0.00           H  
ATOM    628  HB3 ASN A  45       8.174  21.194  25.882  1.00  0.00           H  
ATOM    629 HD21 ASN A  45       9.624  23.871  27.667  1.00  0.00           H  
ATOM    630 HD22 ASN A  45      11.262  23.386  27.412  1.00  0.00           H  
ATOM    631  N   ASP A  46       7.850  23.055  22.904  1.00  0.00           N  
ATOM    632  CA  ASP A  46       8.447  22.991  21.576  1.00  0.00           C  
ATOM    633  C   ASP A  46       7.637  23.808  20.575  1.00  0.00           C  
ATOM    634  O   ASP A  46       6.406  23.786  20.593  1.00  0.00           O  
ATOM    635  CB  ASP A  46       8.545  21.538  21.106  1.00  0.00           C  
ATOM    636  CG  ASP A  46       9.776  20.837  21.647  1.00  0.00           C  
ATOM    637  OD1 ASP A  46      10.898  21.228  21.264  1.00  0.00           O  
ATOM    638  OD2 ASP A  46       9.615  19.897  22.452  1.00  0.00           O  
ATOM    639  H   ASP A  46       6.875  23.004  22.992  1.00  0.00           H  
ATOM    640  HA  ASP A  46       9.441  23.407  21.640  1.00  0.00           H  
ATOM    641  HB2 ASP A  46       7.670  21.000  21.439  1.00  0.00           H  
ATOM    642  HB3 ASP A  46       8.587  21.518  20.027  1.00  0.00           H  
ATOM    643  N   SER A  47       8.335  24.531  19.705  1.00  0.00           N  
ATOM    644  CA  SER A  47       7.679  25.360  18.700  1.00  0.00           C  
ATOM    645  C   SER A  47       8.258  25.093  17.314  1.00  0.00           C  
ATOM    646  O   SER A  47       7.888  25.744  16.338  1.00  0.00           O  
ATOM    647  CB  SER A  47       7.832  26.842  19.052  1.00  0.00           C  
ATOM    648  OG  SER A  47       9.135  27.307  18.743  1.00  0.00           O  
ATOM    649  H   SER A  47       9.314  24.508  19.742  1.00  0.00           H  
ATOM    650  HA  SER A  47       6.630  25.107  18.695  1.00  0.00           H  
ATOM    651  HB2 SER A  47       7.115  27.419  18.490  1.00  0.00           H  
ATOM    652  HB3 SER A  47       7.656  26.978  20.109  1.00  0.00           H  
ATOM    653  HG  SER A  47       9.128  28.265  18.687  1.00  0.00           H  
ATOM    654  N   GLY A  48       9.169  24.128  17.236  1.00  0.00           N  
ATOM    655  CA  GLY A  48       9.784  23.789  15.966  1.00  0.00           C  
ATOM    656  C   GLY A  48       8.830  23.073  15.031  1.00  0.00           C  
ATOM    657  O   GLY A  48       7.618  23.083  15.246  1.00  0.00           O  
ATOM    658  H   GLY A  48       9.425  23.640  18.047  1.00  0.00           H  
ATOM    659  HA2 GLY A  48      10.124  24.697  15.491  1.00  0.00           H  
ATOM    660  HA3 GLY A  48      10.636  23.151  16.150  1.00  0.00           H  
ATOM    661  N   ILE A  49       9.377  22.452  13.991  1.00  0.00           N  
ATOM    662  CA  ILE A  49       8.566  21.729  13.021  1.00  0.00           C  
ATOM    663  C   ILE A  49       8.819  20.227  13.103  1.00  0.00           C  
ATOM    664  O   ILE A  49       9.964  19.777  13.054  1.00  0.00           O  
ATOM    665  CB  ILE A  49       8.845  22.208  11.584  1.00  0.00           C  
ATOM    666  CG1 ILE A  49       8.999  23.731  11.552  1.00  0.00           C  
ATOM    667  CG2 ILE A  49       7.730  21.763  10.650  1.00  0.00           C  
ATOM    668  CD1 ILE A  49       7.744  24.472  11.958  1.00  0.00           C  
ATOM    669  H   ILE A  49      10.349  22.481  13.875  1.00  0.00           H  
ATOM    670  HA  ILE A  49       7.526  21.920  13.247  1.00  0.00           H  
ATOM    671  HB  ILE A  49       9.765  21.754  11.249  1.00  0.00           H  
ATOM    672 HG12 ILE A  49       9.788  24.021  12.226  1.00  0.00           H  
ATOM    673 HG13 ILE A  49       9.257  24.037  10.548  1.00  0.00           H  
ATOM    674 HG21 ILE A  49       7.874  20.726  10.386  1.00  0.00           H  
ATOM    675 HG22 ILE A  49       6.779  21.877  11.147  1.00  0.00           H  
ATOM    676 HG23 ILE A  49       7.745  22.368   9.756  1.00  0.00           H  
ATOM    677 HD11 ILE A  49       7.661  24.475  13.035  1.00  0.00           H  
ATOM    678 HD12 ILE A  49       7.797  25.490  11.600  1.00  0.00           H  
ATOM    679 HD13 ILE A  49       6.882  23.984  11.531  1.00  0.00           H  
ATOM    680  N   TYR A  50       7.744  19.457  13.223  1.00  0.00           N  
ATOM    681  CA  TYR A  50       7.850  18.006  13.312  1.00  0.00           C  
ATOM    682  C   TYR A  50       6.978  17.331  12.257  1.00  0.00           C  
ATOM    683  O   TYR A  50       6.285  17.998  11.488  1.00  0.00           O  
ATOM    684  CB  TYR A  50       7.442  17.528  14.708  1.00  0.00           C  
ATOM    685  CG  TYR A  50       8.241  18.163  15.823  1.00  0.00           C  
ATOM    686  CD1 TYR A  50       8.020  19.483  16.198  1.00  0.00           C  
ATOM    687  CD2 TYR A  50       9.217  17.445  16.501  1.00  0.00           C  
ATOM    688  CE1 TYR A  50       8.748  20.068  17.216  1.00  0.00           C  
ATOM    689  CE2 TYR A  50       9.949  18.020  17.521  1.00  0.00           C  
ATOM    690  CZ  TYR A  50       9.712  19.332  17.874  1.00  0.00           C  
ATOM    691  OH  TYR A  50      10.438  19.911  18.890  1.00  0.00           O  
ATOM    692  H   TYR A  50       6.858  19.874  13.257  1.00  0.00           H  
ATOM    693  HA  TYR A  50       8.880  17.737  13.138  1.00  0.00           H  
ATOM    694  HB2 TYR A  50       6.402  17.762  14.871  1.00  0.00           H  
ATOM    695  HB3 TYR A  50       7.580  16.458  14.768  1.00  0.00           H  
ATOM    696  HD1 TYR A  50       7.263  20.055  15.681  1.00  0.00           H  
ATOM    697  HD2 TYR A  50       9.402  16.417  16.221  1.00  0.00           H  
ATOM    698  HE1 TYR A  50       8.560  21.095  17.493  1.00  0.00           H  
ATOM    699  HE2 TYR A  50      10.704  17.446  18.036  1.00  0.00           H  
ATOM    700  HH  TYR A  50      11.170  20.407  18.516  1.00  0.00           H  
ATOM    701  N   VAL A  51       7.020  16.003  12.226  1.00  0.00           N  
ATOM    702  CA  VAL A  51       6.234  15.235  11.267  1.00  0.00           C  
ATOM    703  C   VAL A  51       5.106  14.480  11.961  1.00  0.00           C  
ATOM    704  O   VAL A  51       5.346  13.668  12.855  1.00  0.00           O  
ATOM    705  CB  VAL A  51       7.113  14.232  10.498  1.00  0.00           C  
ATOM    706  CG1 VAL A  51       6.288  13.487   9.459  1.00  0.00           C  
ATOM    707  CG2 VAL A  51       8.288  14.943   9.846  1.00  0.00           C  
ATOM    708  H   VAL A  51       7.591  15.527  12.865  1.00  0.00           H  
ATOM    709  HA  VAL A  51       5.807  15.926  10.556  1.00  0.00           H  
ATOM    710  HB  VAL A  51       7.500  13.509  11.201  1.00  0.00           H  
ATOM    711 HG11 VAL A  51       6.719  12.512   9.289  1.00  0.00           H  
ATOM    712 HG12 VAL A  51       5.274  13.377   9.814  1.00  0.00           H  
ATOM    713 HG13 VAL A  51       6.286  14.045   8.533  1.00  0.00           H  
ATOM    714 HG21 VAL A  51       9.204  14.424  10.089  1.00  0.00           H  
ATOM    715 HG22 VAL A  51       8.154  14.955   8.776  1.00  0.00           H  
ATOM    716 HG23 VAL A  51       8.343  15.958  10.214  1.00  0.00           H  
ATOM    717  N   SER A  52       3.874  14.750  11.542  1.00  0.00           N  
ATOM    718  CA  SER A  52       2.708  14.099  12.125  1.00  0.00           C  
ATOM    719  C   SER A  52       2.408  12.783  11.413  1.00  0.00           C  
ATOM    720  O   SER A  52       2.192  11.753  12.053  1.00  0.00           O  
ATOM    721  CB  SER A  52       1.489  15.022  12.049  1.00  0.00           C  
ATOM    722  OG  SER A  52       0.288  14.298  12.249  1.00  0.00           O  
ATOM    723  H   SER A  52       3.747  15.408  10.825  1.00  0.00           H  
ATOM    724  HA  SER A  52       2.927  13.891  13.162  1.00  0.00           H  
ATOM    725  HB2 SER A  52       1.569  15.782  12.811  1.00  0.00           H  
ATOM    726  HB3 SER A  52       1.457  15.490  11.076  1.00  0.00           H  
ATOM    727  HG  SER A  52       0.106  14.233  13.189  1.00  0.00           H  
ATOM    728  N   ARG A  53       2.398  12.825  10.085  1.00  0.00           N  
ATOM    729  CA  ARG A  53       2.124  11.638   9.285  1.00  0.00           C  
ATOM    730  C   ARG A  53       2.891  11.681   7.967  1.00  0.00           C  
ATOM    731  O   ARG A  53       3.284  12.751   7.501  1.00  0.00           O  
ATOM    732  CB  ARG A  53       0.624  11.517   9.010  1.00  0.00           C  
ATOM    733  CG  ARG A  53       0.189  10.116   8.611  1.00  0.00           C  
ATOM    734  CD  ARG A  53       0.357   9.133   9.759  1.00  0.00           C  
ATOM    735  NE  ARG A  53      -0.171   7.812   9.428  1.00  0.00           N  
ATOM    736  CZ  ARG A  53      -1.466   7.516   9.429  1.00  0.00           C  
ATOM    737  NH1 ARG A  53      -2.360   8.444   9.741  1.00  0.00           N  
ATOM    738  NH2 ARG A  53      -1.869   6.291   9.118  1.00  0.00           N  
ATOM    739  H   ARG A  53       2.578  13.675   9.632  1.00  0.00           H  
ATOM    740  HA  ARG A  53       2.448  10.776   9.848  1.00  0.00           H  
ATOM    741  HB2 ARG A  53       0.082  11.798   9.901  1.00  0.00           H  
ATOM    742  HB3 ARG A  53       0.361  12.194   8.210  1.00  0.00           H  
ATOM    743  HG2 ARG A  53      -0.852  10.141   8.322  1.00  0.00           H  
ATOM    744  HG3 ARG A  53       0.789   9.787   7.775  1.00  0.00           H  
ATOM    745  HD2 ARG A  53       1.408   9.043   9.987  1.00  0.00           H  
ATOM    746  HD3 ARG A  53      -0.168   9.515  10.622  1.00  0.00           H  
ATOM    747  HE  ARG A  53       0.473   7.111   9.196  1.00  0.00           H  
ATOM    748 HH11 ARG A  53      -2.060   9.368   9.975  1.00  0.00           H  
ATOM    749 HH12 ARG A  53      -3.335   8.220   9.740  1.00  0.00           H  
ATOM    750 HH21 ARG A  53      -1.197   5.589   8.883  1.00  0.00           H  
ATOM    751 HH22 ARG A  53      -2.844   6.070   9.120  1.00  0.00           H  
ATOM    752  N   ILE A  54       3.103  10.512   7.372  1.00  0.00           N  
ATOM    753  CA  ILE A  54       3.823  10.418   6.108  1.00  0.00           C  
ATOM    754  C   ILE A  54       3.053   9.572   5.099  1.00  0.00           C  
ATOM    755  O   ILE A  54       2.577   8.483   5.420  1.00  0.00           O  
ATOM    756  CB  ILE A  54       5.225   9.813   6.303  1.00  0.00           C  
ATOM    757  CG1 ILE A  54       6.105  10.764   7.117  1.00  0.00           C  
ATOM    758  CG2 ILE A  54       5.866   9.513   4.956  1.00  0.00           C  
ATOM    759  CD1 ILE A  54       7.447  10.175   7.491  1.00  0.00           C  
ATOM    760  H   ILE A  54       2.765   9.694   7.792  1.00  0.00           H  
ATOM    761  HA  ILE A  54       3.934  11.416   5.713  1.00  0.00           H  
ATOM    762  HB  ILE A  54       5.121   8.883   6.840  1.00  0.00           H  
ATOM    763 HG12 ILE A  54       6.285  11.658   6.542  1.00  0.00           H  
ATOM    764 HG13 ILE A  54       5.591  11.026   8.031  1.00  0.00           H  
ATOM    765 HG21 ILE A  54       5.224   8.851   4.393  1.00  0.00           H  
ATOM    766 HG22 ILE A  54       5.999  10.434   4.408  1.00  0.00           H  
ATOM    767 HG23 ILE A  54       6.824   9.042   5.110  1.00  0.00           H  
ATOM    768 HD11 ILE A  54       7.391   9.096   7.449  1.00  0.00           H  
ATOM    769 HD12 ILE A  54       8.199  10.520   6.797  1.00  0.00           H  
ATOM    770 HD13 ILE A  54       7.711  10.482   8.491  1.00  0.00           H  
ATOM    771  N   LYS A  55       2.936  10.079   3.877  1.00  0.00           N  
ATOM    772  CA  LYS A  55       2.228   9.370   2.818  1.00  0.00           C  
ATOM    773  C   LYS A  55       2.812   7.976   2.610  1.00  0.00           C  
ATOM    774  O   LYS A  55       3.976   7.729   2.922  1.00  0.00           O  
ATOM    775  CB  LYS A  55       2.297  10.163   1.510  1.00  0.00           C  
ATOM    776  CG  LYS A  55       1.149  11.142   1.332  1.00  0.00           C  
ATOM    777  CD  LYS A  55       1.460  12.488   1.967  1.00  0.00           C  
ATOM    778  CE  LYS A  55       0.195  13.189   2.435  1.00  0.00           C  
ATOM    779  NZ  LYS A  55       0.485  14.240   3.450  1.00  0.00           N  
ATOM    780  H   LYS A  55       3.338  10.952   3.682  1.00  0.00           H  
ATOM    781  HA  LYS A  55       1.194   9.275   3.116  1.00  0.00           H  
ATOM    782  HB2 LYS A  55       3.223  10.718   1.488  1.00  0.00           H  
ATOM    783  HB3 LYS A  55       2.283   9.471   0.682  1.00  0.00           H  
ATOM    784  HG2 LYS A  55       0.973  11.288   0.277  1.00  0.00           H  
ATOM    785  HG3 LYS A  55       0.263  10.733   1.794  1.00  0.00           H  
ATOM    786  HD2 LYS A  55       2.108  12.333   2.817  1.00  0.00           H  
ATOM    787  HD3 LYS A  55       1.960  13.112   1.240  1.00  0.00           H  
ATOM    788  HE2 LYS A  55      -0.284  13.647   1.583  1.00  0.00           H  
ATOM    789  HE3 LYS A  55      -0.469  12.455   2.869  1.00  0.00           H  
ATOM    790  HZ1 LYS A  55       1.444  14.112   3.831  1.00  0.00           H  
ATOM    791  HZ2 LYS A  55      -0.198  14.180   4.232  1.00  0.00           H  
ATOM    792  HZ3 LYS A  55       0.418  15.183   3.017  1.00  0.00           H  
ATOM    793  N   GLU A  56       1.995   7.071   2.081  1.00  0.00           N  
ATOM    794  CA  GLU A  56       2.434   5.702   1.832  1.00  0.00           C  
ATOM    795  C   GLU A  56       3.148   5.595   0.488  1.00  0.00           C  
ATOM    796  O   GLU A  56       4.071   4.799   0.326  1.00  0.00           O  
ATOM    797  CB  GLU A  56       1.238   4.747   1.864  1.00  0.00           C  
ATOM    798  CG  GLU A  56       0.112   5.150   0.928  1.00  0.00           C  
ATOM    799  CD  GLU A  56      -0.850   6.136   1.562  1.00  0.00           C  
ATOM    800  OE1 GLU A  56      -0.944   6.156   2.806  1.00  0.00           O  
ATOM    801  OE2 GLU A  56      -1.507   6.888   0.812  1.00  0.00           O  
ATOM    802  H   GLU A  56       1.078   7.328   1.854  1.00  0.00           H  
ATOM    803  HA  GLU A  56       3.123   5.427   2.616  1.00  0.00           H  
ATOM    804  HB2 GLU A  56       1.575   3.760   1.586  1.00  0.00           H  
ATOM    805  HB3 GLU A  56       0.847   4.714   2.870  1.00  0.00           H  
ATOM    806  HG2 GLU A  56       0.539   5.605   0.046  1.00  0.00           H  
ATOM    807  HG3 GLU A  56      -0.438   4.265   0.644  1.00  0.00           H  
ATOM    808  N   ASN A  57       2.713   6.405  -0.473  1.00  0.00           N  
ATOM    809  CA  ASN A  57       3.310   6.401  -1.804  1.00  0.00           C  
ATOM    810  C   ASN A  57       3.932   7.756  -2.124  1.00  0.00           C  
ATOM    811  O   ASN A  57       3.872   8.225  -3.261  1.00  0.00           O  
ATOM    812  CB  ASN A  57       2.257   6.048  -2.856  1.00  0.00           C  
ATOM    813  CG  ASN A  57       1.765   4.619  -2.726  1.00  0.00           C  
ATOM    814  OD1 ASN A  57       2.552   3.674  -2.763  1.00  0.00           O  
ATOM    815  ND2 ASN A  57       0.456   4.456  -2.572  1.00  0.00           N  
ATOM    816  H   ASN A  57       1.972   7.018  -0.283  1.00  0.00           H  
ATOM    817  HA  ASN A  57       4.085   5.649  -1.816  1.00  0.00           H  
ATOM    818  HB2 ASN A  57       1.411   6.711  -2.746  1.00  0.00           H  
ATOM    819  HB3 ASN A  57       2.683   6.175  -3.840  1.00  0.00           H  
ATOM    820 HD21 ASN A  57      -0.111   5.256  -2.551  1.00  0.00           H  
ATOM    821 HD22 ASN A  57       0.111   3.543  -2.484  1.00  0.00           H  
ATOM    822  N   GLY A  58       4.528   8.382  -1.114  1.00  0.00           N  
ATOM    823  CA  GLY A  58       5.154   9.677  -1.308  1.00  0.00           C  
ATOM    824  C   GLY A  58       6.666   9.606  -1.244  1.00  0.00           C  
ATOM    825  O   GLY A  58       7.231   8.583  -0.860  1.00  0.00           O  
ATOM    826  H   GLY A  58       4.545   7.960  -0.229  1.00  0.00           H  
ATOM    827  HA2 GLY A  58       4.862  10.063  -2.274  1.00  0.00           H  
ATOM    828  HA3 GLY A  58       4.803  10.351  -0.541  1.00  0.00           H  
ATOM    829  N   ALA A  59       7.325  10.698  -1.620  1.00  0.00           N  
ATOM    830  CA  ALA A  59       8.781  10.756  -1.603  1.00  0.00           C  
ATOM    831  C   ALA A  59       9.329  10.374  -0.232  1.00  0.00           C  
ATOM    832  O   ALA A  59      10.330   9.665  -0.128  1.00  0.00           O  
ATOM    833  CB  ALA A  59       9.259  12.145  -1.996  1.00  0.00           C  
ATOM    834  H   ALA A  59       6.819  11.482  -1.916  1.00  0.00           H  
ATOM    835  HA  ALA A  59       9.152  10.053  -2.336  1.00  0.00           H  
ATOM    836  HB1 ALA A  59       9.458  12.170  -3.058  1.00  0.00           H  
ATOM    837  HB2 ALA A  59       8.494  12.870  -1.757  1.00  0.00           H  
ATOM    838  HB3 ALA A  59      10.162  12.382  -1.454  1.00  0.00           H  
ATOM    839  N   ALA A  60       8.668  10.849   0.817  1.00  0.00           N  
ATOM    840  CA  ALA A  60       9.088  10.557   2.182  1.00  0.00           C  
ATOM    841  C   ALA A  60       8.962   9.068   2.489  1.00  0.00           C  
ATOM    842  O   ALA A  60       9.566   8.566   3.436  1.00  0.00           O  
ATOM    843  CB  ALA A  60       8.270  11.372   3.172  1.00  0.00           C  
ATOM    844  H   ALA A  60       7.877  11.409   0.671  1.00  0.00           H  
ATOM    845  HA  ALA A  60      10.124  10.848   2.282  1.00  0.00           H  
ATOM    846  HB1 ALA A  60       7.343  11.676   2.710  1.00  0.00           H  
ATOM    847  HB2 ALA A  60       8.057  10.770   4.044  1.00  0.00           H  
ATOM    848  HB3 ALA A  60       8.830  12.247   3.467  1.00  0.00           H  
ATOM    849  N   ALA A  61       8.173   8.367   1.680  1.00  0.00           N  
ATOM    850  CA  ALA A  61       7.969   6.936   1.864  1.00  0.00           C  
ATOM    851  C   ALA A  61       9.001   6.129   1.083  1.00  0.00           C  
ATOM    852  O   ALA A  61       9.671   5.257   1.636  1.00  0.00           O  
ATOM    853  CB  ALA A  61       6.560   6.545   1.442  1.00  0.00           C  
ATOM    854  H   ALA A  61       7.719   8.823   0.942  1.00  0.00           H  
ATOM    855  HA  ALA A  61       8.077   6.715   2.917  1.00  0.00           H  
ATOM    856  HB1 ALA A  61       6.514   5.477   1.290  1.00  0.00           H  
ATOM    857  HB2 ALA A  61       5.862   6.830   2.216  1.00  0.00           H  
ATOM    858  HB3 ALA A  61       6.307   7.051   0.523  1.00  0.00           H  
ATOM    859  N   LEU A  62       9.123   6.426  -0.206  1.00  0.00           N  
ATOM    860  CA  LEU A  62      10.074   5.727  -1.064  1.00  0.00           C  
ATOM    861  C   LEU A  62      11.493   5.849  -0.518  1.00  0.00           C  
ATOM    862  O   LEU A  62      12.184   4.847  -0.329  1.00  0.00           O  
ATOM    863  CB  LEU A  62      10.013   6.287  -2.487  1.00  0.00           C  
ATOM    864  CG  LEU A  62       8.652   6.214  -3.180  1.00  0.00           C  
ATOM    865  CD1 LEU A  62       8.561   7.252  -4.287  1.00  0.00           C  
ATOM    866  CD2 LEU A  62       8.409   4.817  -3.733  1.00  0.00           C  
ATOM    867  H   LEU A  62       8.563   7.131  -0.591  1.00  0.00           H  
ATOM    868  HA  LEU A  62       9.798   4.684  -1.085  1.00  0.00           H  
ATOM    869  HB2 LEU A  62      10.308   7.324  -2.447  1.00  0.00           H  
ATOM    870  HB3 LEU A  62      10.722   5.736  -3.089  1.00  0.00           H  
ATOM    871  HG  LEU A  62       7.876   6.428  -2.457  1.00  0.00           H  
ATOM    872 HD11 LEU A  62       7.637   7.119  -4.830  1.00  0.00           H  
ATOM    873 HD12 LEU A  62       9.395   7.132  -4.963  1.00  0.00           H  
ATOM    874 HD13 LEU A  62       8.587   8.242  -3.856  1.00  0.00           H  
ATOM    875 HD21 LEU A  62       9.017   4.107  -3.194  1.00  0.00           H  
ATOM    876 HD22 LEU A  62       8.672   4.796  -4.781  1.00  0.00           H  
ATOM    877 HD23 LEU A  62       7.366   4.561  -3.618  1.00  0.00           H  
ATOM    878  N   ASP A  63      11.921   7.081  -0.264  1.00  0.00           N  
ATOM    879  CA  ASP A  63      13.256   7.334   0.264  1.00  0.00           C  
ATOM    880  C   ASP A  63      13.501   6.521   1.531  1.00  0.00           C  
ATOM    881  O   ASP A  63      14.595   5.998   1.744  1.00  0.00           O  
ATOM    882  CB  ASP A  63      13.438   8.824   0.554  1.00  0.00           C  
ATOM    883  CG  ASP A  63      13.845   9.609  -0.678  1.00  0.00           C  
ATOM    884  OD1 ASP A  63      15.062   9.727  -0.930  1.00  0.00           O  
ATOM    885  OD2 ASP A  63      12.946  10.106  -1.388  1.00  0.00           O  
ATOM    886  H   ASP A  63      11.322   7.839  -0.436  1.00  0.00           H  
ATOM    887  HA  ASP A  63      13.971   7.032  -0.486  1.00  0.00           H  
ATOM    888  HB2 ASP A  63      12.508   9.229   0.925  1.00  0.00           H  
ATOM    889  HB3 ASP A  63      14.204   8.946   1.306  1.00  0.00           H  
ATOM    890  N   GLY A  64      12.476   6.421   2.372  1.00  0.00           N  
ATOM    891  CA  GLY A  64      12.601   5.672   3.609  1.00  0.00           C  
ATOM    892  C   GLY A  64      13.280   6.471   4.704  1.00  0.00           C  
ATOM    893  O   GLY A  64      12.844   6.454   5.855  1.00  0.00           O  
ATOM    894  H   GLY A  64      11.628   6.860   2.151  1.00  0.00           H  
ATOM    895  HA2 GLY A  64      11.616   5.386   3.945  1.00  0.00           H  
ATOM    896  HA3 GLY A  64      13.180   4.780   3.420  1.00  0.00           H  
ATOM    897  N   ARG A  65      14.351   7.171   4.346  1.00  0.00           N  
ATOM    898  CA  ARG A  65      15.094   7.978   5.308  1.00  0.00           C  
ATOM    899  C   ARG A  65      14.145   8.686   6.270  1.00  0.00           C  
ATOM    900  O   ARG A  65      14.035   8.311   7.438  1.00  0.00           O  
ATOM    901  CB  ARG A  65      15.962   9.006   4.580  1.00  0.00           C  
ATOM    902  CG  ARG A  65      17.271   8.437   4.056  1.00  0.00           C  
ATOM    903  CD  ARG A  65      18.110   9.507   3.376  1.00  0.00           C  
ATOM    904  NE  ARG A  65      17.558   9.894   2.081  1.00  0.00           N  
ATOM    905  CZ  ARG A  65      18.279  10.439   1.107  1.00  0.00           C  
ATOM    906  NH1 ARG A  65      19.575  10.659   1.282  1.00  0.00           N  
ATOM    907  NH2 ARG A  65      17.704  10.765  -0.044  1.00  0.00           N  
ATOM    908  H   ARG A  65      14.650   7.145   3.413  1.00  0.00           H  
ATOM    909  HA  ARG A  65      15.733   7.316   5.872  1.00  0.00           H  
ATOM    910  HB2 ARG A  65      15.406   9.402   3.743  1.00  0.00           H  
ATOM    911  HB3 ARG A  65      16.192   9.811   5.263  1.00  0.00           H  
ATOM    912  HG2 ARG A  65      17.831   8.028   4.883  1.00  0.00           H  
ATOM    913  HG3 ARG A  65      17.052   7.656   3.344  1.00  0.00           H  
ATOM    914  HD2 ARG A  65      18.148  10.376   4.014  1.00  0.00           H  
ATOM    915  HD3 ARG A  65      19.109   9.124   3.231  1.00  0.00           H  
ATOM    916  HE  ARG A  65      16.603   9.740   1.930  1.00  0.00           H  
ATOM    917 HH11 ARG A  65      20.010  10.415   2.147  1.00  0.00           H  
ATOM    918 HH12 ARG A  65      20.116  11.068   0.546  1.00  0.00           H  
ATOM    919 HH21 ARG A  65      16.728  10.599  -0.179  1.00  0.00           H  
ATOM    920 HH22 ARG A  65      18.248  11.175  -0.776  1.00  0.00           H  
ATOM    921  N   LEU A  66      13.464   9.712   5.773  1.00  0.00           N  
ATOM    922  CA  LEU A  66      12.524  10.474   6.588  1.00  0.00           C  
ATOM    923  C   LEU A  66      11.517   9.550   7.266  1.00  0.00           C  
ATOM    924  O   LEU A  66      10.967   8.648   6.635  1.00  0.00           O  
ATOM    925  CB  LEU A  66      11.790  11.504   5.728  1.00  0.00           C  
ATOM    926  CG  LEU A  66      11.018  12.584   6.486  1.00  0.00           C  
ATOM    927  CD1 LEU A  66      11.940  13.736   6.858  1.00  0.00           C  
ATOM    928  CD2 LEU A  66       9.846  13.085   5.655  1.00  0.00           C  
ATOM    929  H   LEU A  66      13.594   9.964   4.835  1.00  0.00           H  
ATOM    930  HA  LEU A  66      13.091  10.991   7.349  1.00  0.00           H  
ATOM    931  HB2 LEU A  66      12.520  11.996   5.105  1.00  0.00           H  
ATOM    932  HB3 LEU A  66      11.087  10.971   5.103  1.00  0.00           H  
ATOM    933  HG  LEU A  66      10.625  12.162   7.401  1.00  0.00           H  
ATOM    934 HD11 LEU A  66      11.355  14.549   7.259  1.00  0.00           H  
ATOM    935 HD12 LEU A  66      12.470  14.071   5.980  1.00  0.00           H  
ATOM    936 HD13 LEU A  66      12.650  13.403   7.602  1.00  0.00           H  
ATOM    937 HD21 LEU A  66      10.206  13.433   4.698  1.00  0.00           H  
ATOM    938 HD22 LEU A  66       9.358  13.896   6.174  1.00  0.00           H  
ATOM    939 HD23 LEU A  66       9.142  12.280   5.505  1.00  0.00           H  
ATOM    940  N   GLN A  67      11.281   9.783   8.553  1.00  0.00           N  
ATOM    941  CA  GLN A  67      10.340   8.973   9.316  1.00  0.00           C  
ATOM    942  C   GLN A  67       9.508   9.841  10.253  1.00  0.00           C  
ATOM    943  O   GLN A  67       9.975  10.873  10.735  1.00  0.00           O  
ATOM    944  CB  GLN A  67      11.085   7.905  10.118  1.00  0.00           C  
ATOM    945  CG  GLN A  67      12.038   8.478  11.154  1.00  0.00           C  
ATOM    946  CD  GLN A  67      12.647   7.409  12.041  1.00  0.00           C  
ATOM    947  OE1 GLN A  67      13.863   7.215  12.053  1.00  0.00           O  
ATOM    948  NE2 GLN A  67      11.803   6.711  12.790  1.00  0.00           N  
ATOM    949  H   GLN A  67      11.752  10.517   9.000  1.00  0.00           H  
ATOM    950  HA  GLN A  67       9.678   8.486   8.615  1.00  0.00           H  
ATOM    951  HB2 GLN A  67      10.364   7.284  10.627  1.00  0.00           H  
ATOM    952  HB3 GLN A  67      11.657   7.293   9.435  1.00  0.00           H  
ATOM    953  HG2 GLN A  67      12.835   8.997  10.644  1.00  0.00           H  
ATOM    954  HG3 GLN A  67      11.497   9.175  11.776  1.00  0.00           H  
ATOM    955 HE21 GLN A  67      10.847   6.920  12.728  1.00  0.00           H  
ATOM    956 HE22 GLN A  67      12.169   6.013  13.372  1.00  0.00           H  
ATOM    957  N   GLU A  68       8.274   9.416  10.508  1.00  0.00           N  
ATOM    958  CA  GLU A  68       7.378  10.158  11.388  1.00  0.00           C  
ATOM    959  C   GLU A  68       8.032  10.408  12.744  1.00  0.00           C  
ATOM    960  O   GLU A  68       8.882   9.638  13.187  1.00  0.00           O  
ATOM    961  CB  GLU A  68       6.065   9.395  11.575  1.00  0.00           C  
ATOM    962  CG  GLU A  68       5.158   9.437  10.357  1.00  0.00           C  
ATOM    963  CD  GLU A  68       4.143   8.312  10.347  1.00  0.00           C  
ATOM    964  OE1 GLU A  68       3.598   7.992  11.424  1.00  0.00           O  
ATOM    965  OE2 GLU A  68       3.892   7.749   9.260  1.00  0.00           O  
ATOM    966  H   GLU A  68       7.960   8.586  10.094  1.00  0.00           H  
ATOM    967  HA  GLU A  68       7.168  11.109  10.923  1.00  0.00           H  
ATOM    968  HB2 GLU A  68       6.291   8.362  11.795  1.00  0.00           H  
ATOM    969  HB3 GLU A  68       5.531   9.822  12.411  1.00  0.00           H  
ATOM    970  HG2 GLU A  68       4.629  10.379  10.351  1.00  0.00           H  
ATOM    971  HG3 GLU A  68       5.767   9.362   9.468  1.00  0.00           H  
ATOM    972  N   GLY A  69       7.628  11.493  13.398  1.00  0.00           N  
ATOM    973  CA  GLY A  69       8.183  11.826  14.696  1.00  0.00           C  
ATOM    974  C   GLY A  69       9.515  12.542  14.590  1.00  0.00           C  
ATOM    975  O   GLY A  69      10.223  12.702  15.584  1.00  0.00           O  
ATOM    976  H   GLY A  69       6.946  12.071  12.996  1.00  0.00           H  
ATOM    977  HA2 GLY A  69       7.486  12.462  15.222  1.00  0.00           H  
ATOM    978  HA3 GLY A  69       8.320  10.916  15.261  1.00  0.00           H  
ATOM    979  N   ASP A  70       9.859  12.971  13.380  1.00  0.00           N  
ATOM    980  CA  ASP A  70      11.117  13.673  13.148  1.00  0.00           C  
ATOM    981  C   ASP A  70      10.942  15.177  13.332  1.00  0.00           C  
ATOM    982  O   ASP A  70       9.910  15.742  12.970  1.00  0.00           O  
ATOM    983  CB  ASP A  70      11.637  13.376  11.740  1.00  0.00           C  
ATOM    984  CG  ASP A  70      12.395  12.065  11.669  1.00  0.00           C  
ATOM    985  OD1 ASP A  70      12.425  11.341  12.685  1.00  0.00           O  
ATOM    986  OD2 ASP A  70      12.959  11.763  10.596  1.00  0.00           O  
ATOM    987  H   ASP A  70       9.253  12.814  12.627  1.00  0.00           H  
ATOM    988  HA  ASP A  70      11.835  13.315  13.870  1.00  0.00           H  
ATOM    989  HB2 ASP A  70      10.802  13.325  11.058  1.00  0.00           H  
ATOM    990  HB3 ASP A  70      12.300  14.172  11.433  1.00  0.00           H  
ATOM    991  N   LYS A  71      11.957  15.821  13.899  1.00  0.00           N  
ATOM    992  CA  LYS A  71      11.918  17.259  14.132  1.00  0.00           C  
ATOM    993  C   LYS A  71      12.841  17.993  13.164  1.00  0.00           C  
ATOM    994  O   LYS A  71      14.043  18.101  13.402  1.00  0.00           O  
ATOM    995  CB  LYS A  71      12.319  17.573  15.574  1.00  0.00           C  
ATOM    996  CG  LYS A  71      12.203  19.046  15.931  1.00  0.00           C  
ATOM    997  CD  LYS A  71      13.382  19.843  15.397  1.00  0.00           C  
ATOM    998  CE  LYS A  71      13.490  21.199  16.077  1.00  0.00           C  
ATOM    999  NZ  LYS A  71      13.833  21.071  17.520  1.00  0.00           N  
ATOM   1000  H   LYS A  71      12.753  15.315  14.166  1.00  0.00           H  
ATOM   1001  HA  LYS A  71      10.904  17.594  13.968  1.00  0.00           H  
ATOM   1002  HB2 LYS A  71      11.684  17.012  16.243  1.00  0.00           H  
ATOM   1003  HB3 LYS A  71      13.345  17.268  15.725  1.00  0.00           H  
ATOM   1004  HG2 LYS A  71      11.293  19.441  15.503  1.00  0.00           H  
ATOM   1005  HG3 LYS A  71      12.170  19.145  17.006  1.00  0.00           H  
ATOM   1006  HD2 LYS A  71      14.292  19.289  15.578  1.00  0.00           H  
ATOM   1007  HD3 LYS A  71      13.253  19.992  14.334  1.00  0.00           H  
ATOM   1008  HE2 LYS A  71      14.258  21.774  15.583  1.00  0.00           H  
ATOM   1009  HE3 LYS A  71      12.543  21.710  15.984  1.00  0.00           H  
ATOM   1010  HZ1 LYS A  71      13.223  21.693  18.089  1.00  0.00           H  
ATOM   1011  HZ2 LYS A  71      14.826  21.338  17.677  1.00  0.00           H  
ATOM   1012  HZ3 LYS A  71      13.698  20.089  17.833  1.00  0.00           H  
ATOM   1013  N   ILE A  72      12.269  18.495  12.075  1.00  0.00           N  
ATOM   1014  CA  ILE A  72      13.041  19.221  11.073  1.00  0.00           C  
ATOM   1015  C   ILE A  72      13.653  20.486  11.663  1.00  0.00           C  
ATOM   1016  O   ILE A  72      13.003  21.530  11.732  1.00  0.00           O  
ATOM   1017  CB  ILE A  72      12.173  19.601   9.860  1.00  0.00           C  
ATOM   1018  CG1 ILE A  72      11.572  18.346   9.222  1.00  0.00           C  
ATOM   1019  CG2 ILE A  72      12.995  20.378   8.842  1.00  0.00           C  
ATOM   1020  CD1 ILE A  72      10.238  18.589   8.551  1.00  0.00           C  
ATOM   1021  H   ILE A  72      11.306  18.375  11.941  1.00  0.00           H  
ATOM   1022  HA  ILE A  72      13.836  18.573  10.732  1.00  0.00           H  
ATOM   1023  HB  ILE A  72      11.374  20.240  10.204  1.00  0.00           H  
ATOM   1024 HG12 ILE A  72      12.254  17.968   8.477  1.00  0.00           H  
ATOM   1025 HG13 ILE A  72      11.428  17.597   9.987  1.00  0.00           H  
ATOM   1026 HG21 ILE A  72      12.919  19.898   7.877  1.00  0.00           H  
ATOM   1027 HG22 ILE A  72      12.620  21.387   8.772  1.00  0.00           H  
ATOM   1028 HG23 ILE A  72      14.029  20.396   9.154  1.00  0.00           H  
ATOM   1029 HD11 ILE A  72      10.390  18.729   7.489  1.00  0.00           H  
ATOM   1030 HD12 ILE A  72       9.593  17.739   8.713  1.00  0.00           H  
ATOM   1031 HD13 ILE A  72       9.782  19.474   8.967  1.00  0.00           H  
ATOM   1032  N   LEU A  73      14.910  20.388  12.084  1.00  0.00           N  
ATOM   1033  CA  LEU A  73      15.612  21.526  12.667  1.00  0.00           C  
ATOM   1034  C   LEU A  73      15.661  22.695  11.688  1.00  0.00           C  
ATOM   1035  O   LEU A  73      15.109  23.763  11.953  1.00  0.00           O  
ATOM   1036  CB  LEU A  73      17.033  21.123  13.068  1.00  0.00           C  
ATOM   1037  CG  LEU A  73      17.149  19.937  14.026  1.00  0.00           C  
ATOM   1038  CD1 LEU A  73      18.488  19.239  13.852  1.00  0.00           C  
ATOM   1039  CD2 LEU A  73      16.967  20.396  15.466  1.00  0.00           C  
ATOM   1040  H   LEU A  73      15.376  19.530  12.003  1.00  0.00           H  
ATOM   1041  HA  LEU A  73      15.072  21.834  13.549  1.00  0.00           H  
ATOM   1042  HB2 LEU A  73      17.572  20.873  12.166  1.00  0.00           H  
ATOM   1043  HB3 LEU A  73      17.498  21.977  13.538  1.00  0.00           H  
ATOM   1044  HG  LEU A  73      16.369  19.222  13.800  1.00  0.00           H  
ATOM   1045 HD11 LEU A  73      18.850  19.399  12.848  1.00  0.00           H  
ATOM   1046 HD12 LEU A  73      18.367  18.180  14.026  1.00  0.00           H  
ATOM   1047 HD13 LEU A  73      19.198  19.641  14.560  1.00  0.00           H  
ATOM   1048 HD21 LEU A  73      15.914  20.491  15.683  1.00  0.00           H  
ATOM   1049 HD22 LEU A  73      17.452  21.351  15.603  1.00  0.00           H  
ATOM   1050 HD23 LEU A  73      17.408  19.669  16.133  1.00  0.00           H  
ATOM   1051  N   SER A  74      16.323  22.484  10.554  1.00  0.00           N  
ATOM   1052  CA  SER A  74      16.444  23.520   9.536  1.00  0.00           C  
ATOM   1053  C   SER A  74      16.224  22.941   8.142  1.00  0.00           C  
ATOM   1054  O   SER A  74      16.336  21.733   7.934  1.00  0.00           O  
ATOM   1055  CB  SER A  74      17.820  24.183   9.614  1.00  0.00           C  
ATOM   1056  OG  SER A  74      18.179  24.458  10.957  1.00  0.00           O  
ATOM   1057  H   SER A  74      16.740  21.611  10.401  1.00  0.00           H  
ATOM   1058  HA  SER A  74      15.684  24.264   9.728  1.00  0.00           H  
ATOM   1059  HB2 SER A  74      18.559  23.523   9.185  1.00  0.00           H  
ATOM   1060  HB3 SER A  74      17.803  25.111   9.061  1.00  0.00           H  
ATOM   1061  HG  SER A  74      17.432  24.275  11.531  1.00  0.00           H  
ATOM   1062  N   VAL A  75      15.909  23.813   7.189  1.00  0.00           N  
ATOM   1063  CA  VAL A  75      15.674  23.389   5.813  1.00  0.00           C  
ATOM   1064  C   VAL A  75      16.624  24.095   4.851  1.00  0.00           C  
ATOM   1065  O   VAL A  75      16.579  25.315   4.702  1.00  0.00           O  
ATOM   1066  CB  VAL A  75      14.222  23.667   5.381  1.00  0.00           C  
ATOM   1067  CG1 VAL A  75      13.982  23.168   3.964  1.00  0.00           C  
ATOM   1068  CG2 VAL A  75      13.245  23.025   6.354  1.00  0.00           C  
ATOM   1069  H   VAL A  75      15.834  24.763   7.416  1.00  0.00           H  
ATOM   1070  HA  VAL A  75      15.846  22.325   5.758  1.00  0.00           H  
ATOM   1071  HB  VAL A  75      14.062  24.735   5.394  1.00  0.00           H  
ATOM   1072 HG11 VAL A  75      13.986  22.088   3.958  1.00  0.00           H  
ATOM   1073 HG12 VAL A  75      13.025  23.528   3.613  1.00  0.00           H  
ATOM   1074 HG13 VAL A  75      14.764  23.534   3.317  1.00  0.00           H  
ATOM   1075 HG21 VAL A  75      12.457  23.726   6.588  1.00  0.00           H  
ATOM   1076 HG22 VAL A  75      12.819  22.141   5.904  1.00  0.00           H  
ATOM   1077 HG23 VAL A  75      13.766  22.753   7.262  1.00  0.00           H  
ATOM   1078  N   ASN A  76      17.482  23.318   4.200  1.00  0.00           N  
ATOM   1079  CA  ASN A  76      18.443  23.868   3.251  1.00  0.00           C  
ATOM   1080  C   ASN A  76      19.366  24.874   3.933  1.00  0.00           C  
ATOM   1081  O   ASN A  76      19.850  25.813   3.303  1.00  0.00           O  
ATOM   1082  CB  ASN A  76      17.714  24.537   2.084  1.00  0.00           C  
ATOM   1083  CG  ASN A  76      17.054  23.530   1.160  1.00  0.00           C  
ATOM   1084  OD1 ASN A  76      17.710  22.630   0.637  1.00  0.00           O  
ATOM   1085  ND2 ASN A  76      15.751  23.679   0.959  1.00  0.00           N  
ATOM   1086  H   ASN A  76      17.470  22.351   4.360  1.00  0.00           H  
ATOM   1087  HA  ASN A  76      19.038  23.051   2.871  1.00  0.00           H  
ATOM   1088  HB2 ASN A  76      16.949  25.193   2.474  1.00  0.00           H  
ATOM   1089  HB3 ASN A  76      18.421  25.116   1.510  1.00  0.00           H  
ATOM   1090 HD21 ASN A  76      15.292  24.420   1.409  1.00  0.00           H  
ATOM   1091 HD22 ASN A  76      15.299  23.042   0.366  1.00  0.00           H  
ATOM   1092  N   GLY A  77      19.603  24.670   5.224  1.00  0.00           N  
ATOM   1093  CA  GLY A  77      20.467  25.566   5.971  1.00  0.00           C  
ATOM   1094  C   GLY A  77      19.713  26.744   6.557  1.00  0.00           C  
ATOM   1095  O   GLY A  77      20.320  27.727   6.982  1.00  0.00           O  
ATOM   1096  H   GLY A  77      19.189  23.903   5.675  1.00  0.00           H  
ATOM   1097  HA2 GLY A  77      20.932  25.014   6.774  1.00  0.00           H  
ATOM   1098  HA3 GLY A  77      21.237  25.938   5.311  1.00  0.00           H  
ATOM   1099  N   GLN A  78      18.388  26.646   6.575  1.00  0.00           N  
ATOM   1100  CA  GLN A  78      17.551  27.713   7.110  1.00  0.00           C  
ATOM   1101  C   GLN A  78      16.871  27.275   8.403  1.00  0.00           C  
ATOM   1102  O   GLN A  78      15.900  26.518   8.380  1.00  0.00           O  
ATOM   1103  CB  GLN A  78      16.498  28.129   6.081  1.00  0.00           C  
ATOM   1104  CG  GLN A  78      17.085  28.527   4.737  1.00  0.00           C  
ATOM   1105  CD  GLN A  78      16.021  28.904   3.725  1.00  0.00           C  
ATOM   1106  OE1 GLN A  78      15.232  29.822   3.948  1.00  0.00           O  
ATOM   1107  NE2 GLN A  78      15.995  28.195   2.602  1.00  0.00           N  
ATOM   1108  H   GLN A  78      17.963  25.837   6.222  1.00  0.00           H  
ATOM   1109  HA  GLN A  78      18.187  28.558   7.322  1.00  0.00           H  
ATOM   1110  HB2 GLN A  78      15.821  27.303   5.924  1.00  0.00           H  
ATOM   1111  HB3 GLN A  78      15.943  28.970   6.472  1.00  0.00           H  
ATOM   1112  HG2 GLN A  78      17.738  29.375   4.882  1.00  0.00           H  
ATOM   1113  HG3 GLN A  78      17.655  27.697   4.347  1.00  0.00           H  
ATOM   1114 HE21 GLN A  78      16.654  27.477   2.494  1.00  0.00           H  
ATOM   1115 HE22 GLN A  78      15.317  28.416   1.931  1.00  0.00           H  
ATOM   1116  N   ASP A  79      17.386  27.755   9.529  1.00  0.00           N  
ATOM   1117  CA  ASP A  79      16.829  27.414  10.833  1.00  0.00           C  
ATOM   1118  C   ASP A  79      15.338  27.734  10.887  1.00  0.00           C  
ATOM   1119  O   ASP A  79      14.910  28.819  10.490  1.00  0.00           O  
ATOM   1120  CB  ASP A  79      17.565  28.169  11.940  1.00  0.00           C  
ATOM   1121  CG  ASP A  79      19.070  28.137  11.761  1.00  0.00           C  
ATOM   1122  OD1 ASP A  79      19.592  28.955  10.973  1.00  0.00           O  
ATOM   1123  OD2 ASP A  79      19.727  27.296  12.408  1.00  0.00           O  
ATOM   1124  H   ASP A  79      18.161  28.355   9.483  1.00  0.00           H  
ATOM   1125  HA  ASP A  79      16.962  26.354  10.984  1.00  0.00           H  
ATOM   1126  HB2 ASP A  79      17.243  29.201  11.939  1.00  0.00           H  
ATOM   1127  HB3 ASP A  79      17.324  27.722  12.894  1.00  0.00           H  
ATOM   1128  N   LEU A  80      14.552  26.783  11.377  1.00  0.00           N  
ATOM   1129  CA  LEU A  80      13.108  26.962  11.482  1.00  0.00           C  
ATOM   1130  C   LEU A  80      12.703  27.297  12.913  1.00  0.00           C  
ATOM   1131  O   LEU A  80      12.471  26.405  13.730  1.00  0.00           O  
ATOM   1132  CB  LEU A  80      12.382  25.698  11.017  1.00  0.00           C  
ATOM   1133  CG  LEU A  80      12.624  25.281   9.566  1.00  0.00           C  
ATOM   1134  CD1 LEU A  80      12.285  23.811   9.370  1.00  0.00           C  
ATOM   1135  CD2 LEU A  80      11.809  26.148   8.618  1.00  0.00           C  
ATOM   1136  H   LEU A  80      14.950  25.939  11.676  1.00  0.00           H  
ATOM   1137  HA  LEU A  80      12.829  27.785  10.840  1.00  0.00           H  
ATOM   1138  HB2 LEU A  80      12.696  24.884  11.652  1.00  0.00           H  
ATOM   1139  HB3 LEU A  80      11.321  25.862  11.143  1.00  0.00           H  
ATOM   1140  HG  LEU A  80      13.670  25.416   9.329  1.00  0.00           H  
ATOM   1141 HD11 LEU A  80      11.662  23.698   8.496  1.00  0.00           H  
ATOM   1142 HD12 LEU A  80      11.758  23.445  10.238  1.00  0.00           H  
ATOM   1143 HD13 LEU A  80      13.197  23.246   9.238  1.00  0.00           H  
ATOM   1144 HD21 LEU A  80      10.940  26.527   9.135  1.00  0.00           H  
ATOM   1145 HD22 LEU A  80      11.495  25.558   7.770  1.00  0.00           H  
ATOM   1146 HD23 LEU A  80      12.415  26.975   8.275  1.00  0.00           H  
ATOM   1147  N   LYS A  81      12.618  28.589  13.213  1.00  0.00           N  
ATOM   1148  CA  LYS A  81      12.237  29.044  14.544  1.00  0.00           C  
ATOM   1149  C   LYS A  81      11.526  30.391  14.477  1.00  0.00           C  
ATOM   1150  O   LYS A  81      11.629  31.109  13.483  1.00  0.00           O  
ATOM   1151  CB  LYS A  81      13.473  29.152  15.441  1.00  0.00           C  
ATOM   1152  CG  LYS A  81      14.302  27.880  15.489  1.00  0.00           C  
ATOM   1153  CD  LYS A  81      15.271  27.891  16.659  1.00  0.00           C  
ATOM   1154  CE  LYS A  81      16.428  28.847  16.417  1.00  0.00           C  
ATOM   1155  NZ  LYS A  81      17.523  28.657  17.410  1.00  0.00           N  
ATOM   1156  H   LYS A  81      12.815  29.254  12.518  1.00  0.00           H  
ATOM   1157  HA  LYS A  81      11.562  28.314  14.963  1.00  0.00           H  
ATOM   1158  HB2 LYS A  81      14.099  29.952  15.075  1.00  0.00           H  
ATOM   1159  HB3 LYS A  81      13.155  29.386  16.446  1.00  0.00           H  
ATOM   1160  HG2 LYS A  81      13.641  27.033  15.590  1.00  0.00           H  
ATOM   1161  HG3 LYS A  81      14.864  27.793  14.570  1.00  0.00           H  
ATOM   1162  HD2 LYS A  81      14.744  28.201  17.550  1.00  0.00           H  
ATOM   1163  HD3 LYS A  81      15.663  26.893  16.801  1.00  0.00           H  
ATOM   1164  HE2 LYS A  81      16.820  28.675  15.426  1.00  0.00           H  
ATOM   1165  HE3 LYS A  81      16.062  29.861  16.488  1.00  0.00           H  
ATOM   1166  HZ1 LYS A  81      17.201  28.042  18.183  1.00  0.00           H  
ATOM   1167  HZ2 LYS A  81      17.808  29.575  17.807  1.00  0.00           H  
ATOM   1168  HZ3 LYS A  81      18.348  28.219  16.953  1.00  0.00           H  
ATOM   1169  N   ASN A  82      10.805  30.728  15.542  1.00  0.00           N  
ATOM   1170  CA  ASN A  82      10.077  31.991  15.602  1.00  0.00           C  
ATOM   1171  C   ASN A  82       9.268  32.214  14.329  1.00  0.00           C  
ATOM   1172  O   ASN A  82       9.233  33.321  13.789  1.00  0.00           O  
ATOM   1173  CB  ASN A  82      11.049  33.154  15.815  1.00  0.00           C  
ATOM   1174  CG  ASN A  82      11.929  32.958  17.033  1.00  0.00           C  
ATOM   1175  OD1 ASN A  82      11.655  33.501  18.104  1.00  0.00           O  
ATOM   1176  ND2 ASN A  82      12.992  32.178  16.876  1.00  0.00           N  
ATOM   1177  H   ASN A  82      10.761  30.114  16.304  1.00  0.00           H  
ATOM   1178  HA  ASN A  82       9.400  31.942  16.441  1.00  0.00           H  
ATOM   1179  HB2 ASN A  82      11.685  33.246  14.946  1.00  0.00           H  
ATOM   1180  HB3 ASN A  82      10.486  34.067  15.941  1.00  0.00           H  
ATOM   1181 HD21 ASN A  82      13.147  31.779  15.994  1.00  0.00           H  
ATOM   1182 HD22 ASN A  82      13.578  32.034  17.649  1.00  0.00           H  
ATOM   1183  N   LEU A  83       8.618  31.158  13.854  1.00  0.00           N  
ATOM   1184  CA  LEU A  83       7.808  31.238  12.644  1.00  0.00           C  
ATOM   1185  C   LEU A  83       6.445  30.588  12.858  1.00  0.00           C  
ATOM   1186  O   LEU A  83       6.252  29.820  13.800  1.00  0.00           O  
ATOM   1187  CB  LEU A  83       8.530  30.563  11.477  1.00  0.00           C  
ATOM   1188  CG  LEU A  83       9.323  29.301  11.819  1.00  0.00           C  
ATOM   1189  CD1 LEU A  83       8.383  28.154  12.155  1.00  0.00           C  
ATOM   1190  CD2 LEU A  83      10.242  28.920  10.667  1.00  0.00           C  
ATOM   1191  H   LEU A  83       8.684  30.303  14.327  1.00  0.00           H  
ATOM   1192  HA  LEU A  83       7.663  32.283  12.411  1.00  0.00           H  
ATOM   1193  HB2 LEU A  83       7.790  30.297  10.739  1.00  0.00           H  
ATOM   1194  HB3 LEU A  83       9.217  31.282  11.053  1.00  0.00           H  
ATOM   1195  HG  LEU A  83       9.938  29.493  12.687  1.00  0.00           H  
ATOM   1196 HD11 LEU A  83       8.519  27.356  11.440  1.00  0.00           H  
ATOM   1197 HD12 LEU A  83       7.362  28.503  12.116  1.00  0.00           H  
ATOM   1198 HD13 LEU A  83       8.602  27.789  13.148  1.00  0.00           H  
ATOM   1199 HD21 LEU A  83      10.637  27.929  10.834  1.00  0.00           H  
ATOM   1200 HD22 LEU A  83      11.055  29.628  10.606  1.00  0.00           H  
ATOM   1201 HD23 LEU A  83       9.684  28.934   9.741  1.00  0.00           H  
ATOM   1202  N   LEU A  84       5.503  30.899  11.974  1.00  0.00           N  
ATOM   1203  CA  LEU A  84       4.156  30.343  12.063  1.00  0.00           C  
ATOM   1204  C   LEU A  84       4.018  29.107  11.180  1.00  0.00           C  
ATOM   1205  O   LEU A  84       4.874  28.833  10.339  1.00  0.00           O  
ATOM   1206  CB  LEU A  84       3.122  31.394  11.657  1.00  0.00           C  
ATOM   1207  CG  LEU A  84       3.359  32.809  12.185  1.00  0.00           C  
ATOM   1208  CD1 LEU A  84       2.718  33.836  11.265  1.00  0.00           C  
ATOM   1209  CD2 LEU A  84       2.817  32.947  13.601  1.00  0.00           C  
ATOM   1210  H   LEU A  84       5.716  31.516  11.243  1.00  0.00           H  
ATOM   1211  HA  LEU A  84       3.984  30.057  13.090  1.00  0.00           H  
ATOM   1212  HB2 LEU A  84       3.106  31.441  10.579  1.00  0.00           H  
ATOM   1213  HB3 LEU A  84       2.157  31.062  12.015  1.00  0.00           H  
ATOM   1214  HG  LEU A  84       4.422  33.002  12.212  1.00  0.00           H  
ATOM   1215 HD11 LEU A  84       2.656  33.434  10.265  1.00  0.00           H  
ATOM   1216 HD12 LEU A  84       3.318  34.734  11.256  1.00  0.00           H  
ATOM   1217 HD13 LEU A  84       1.726  34.070  11.623  1.00  0.00           H  
ATOM   1218 HD21 LEU A  84       2.683  33.992  13.834  1.00  0.00           H  
ATOM   1219 HD22 LEU A  84       3.516  32.508  14.297  1.00  0.00           H  
ATOM   1220 HD23 LEU A  84       1.868  32.436  13.674  1.00  0.00           H  
ATOM   1221  N   HIS A  85       2.932  28.365  11.375  1.00  0.00           N  
ATOM   1222  CA  HIS A  85       2.679  27.160  10.593  1.00  0.00           C  
ATOM   1223  C   HIS A  85       2.789  27.448   9.099  1.00  0.00           C  
ATOM   1224  O   HIS A  85       3.275  26.617   8.333  1.00  0.00           O  
ATOM   1225  CB  HIS A  85       1.294  26.598  10.917  1.00  0.00           C  
ATOM   1226  CG  HIS A  85       0.898  25.445  10.047  1.00  0.00           C  
ATOM   1227  ND1 HIS A  85       1.401  24.172  10.210  1.00  0.00           N  
ATOM   1228  CD2 HIS A  85       0.039  25.377   9.003  1.00  0.00           C  
ATOM   1229  CE1 HIS A  85       0.871  23.372   9.302  1.00  0.00           C  
ATOM   1230  NE2 HIS A  85       0.040  24.078   8.558  1.00  0.00           N  
ATOM   1231  H   HIS A  85       2.286  28.636  12.060  1.00  0.00           H  
ATOM   1232  HA  HIS A  85       3.426  26.427  10.862  1.00  0.00           H  
ATOM   1233  HB2 HIS A  85       1.280  26.260  11.942  1.00  0.00           H  
ATOM   1234  HB3 HIS A  85       0.558  27.379  10.790  1.00  0.00           H  
ATOM   1235  HD1 HIS A  85       2.053  23.896  10.888  1.00  0.00           H  
ATOM   1236  HD2 HIS A  85      -0.541  26.194   8.595  1.00  0.00           H  
ATOM   1237  HE1 HIS A  85       1.080  22.319   9.188  1.00  0.00           H  
ATOM   1238  N   GLN A  86       2.333  28.629   8.694  1.00  0.00           N  
ATOM   1239  CA  GLN A  86       2.379  29.025   7.292  1.00  0.00           C  
ATOM   1240  C   GLN A  86       3.808  29.345   6.863  1.00  0.00           C  
ATOM   1241  O   GLN A  86       4.179  29.141   5.708  1.00  0.00           O  
ATOM   1242  CB  GLN A  86       1.477  30.237   7.052  1.00  0.00           C  
ATOM   1243  CG  GLN A  86       1.547  30.775   5.633  1.00  0.00           C  
ATOM   1244  CD  GLN A  86       0.941  29.826   4.618  1.00  0.00           C  
ATOM   1245  OE1 GLN A  86      -0.258  29.877   4.342  1.00  0.00           O  
ATOM   1246  NE2 GLN A  86       1.768  28.952   4.056  1.00  0.00           N  
ATOM   1247  H   GLN A  86       1.957  29.248   9.354  1.00  0.00           H  
ATOM   1248  HA  GLN A  86       2.017  28.196   6.701  1.00  0.00           H  
ATOM   1249  HB2 GLN A  86       0.456  29.957   7.259  1.00  0.00           H  
ATOM   1250  HB3 GLN A  86       1.770  31.027   7.729  1.00  0.00           H  
ATOM   1251  HG2 GLN A  86       1.012  31.713   5.590  1.00  0.00           H  
ATOM   1252  HG3 GLN A  86       2.583  30.942   5.374  1.00  0.00           H  
ATOM   1253 HE21 GLN A  86       2.710  28.968   4.326  1.00  0.00           H  
ATOM   1254 HE22 GLN A  86       1.402  28.326   3.398  1.00  0.00           H  
ATOM   1255  N   ASP A  87       4.602  29.849   7.802  1.00  0.00           N  
ATOM   1256  CA  ASP A  87       5.990  30.197   7.521  1.00  0.00           C  
ATOM   1257  C   ASP A  87       6.804  28.953   7.177  1.00  0.00           C  
ATOM   1258  O   ASP A  87       7.655  28.982   6.289  1.00  0.00           O  
ATOM   1259  CB  ASP A  87       6.610  30.913   8.721  1.00  0.00           C  
ATOM   1260  CG  ASP A  87       6.432  32.417   8.655  1.00  0.00           C  
ATOM   1261  OD1 ASP A  87       5.280  32.870   8.488  1.00  0.00           O  
ATOM   1262  OD2 ASP A  87       7.442  33.140   8.771  1.00  0.00           O  
ATOM   1263  H   ASP A  87       4.247  29.988   8.704  1.00  0.00           H  
ATOM   1264  HA  ASP A  87       6.000  30.863   6.671  1.00  0.00           H  
ATOM   1265  HB2 ASP A  87       6.145  30.554   9.627  1.00  0.00           H  
ATOM   1266  HB3 ASP A  87       7.668  30.696   8.755  1.00  0.00           H  
ATOM   1267  N   ALA A  88       6.538  27.863   7.889  1.00  0.00           N  
ATOM   1268  CA  ALA A  88       7.244  26.610   7.660  1.00  0.00           C  
ATOM   1269  C   ALA A  88       6.829  25.979   6.335  1.00  0.00           C  
ATOM   1270  O   ALA A  88       7.671  25.524   5.561  1.00  0.00           O  
ATOM   1271  CB  ALA A  88       6.993  25.644   8.808  1.00  0.00           C  
ATOM   1272  H   ALA A  88       5.848  27.903   8.585  1.00  0.00           H  
ATOM   1273  HA  ALA A  88       8.303  26.824   7.628  1.00  0.00           H  
ATOM   1274  HB1 ALA A  88       7.629  24.778   8.696  1.00  0.00           H  
ATOM   1275  HB2 ALA A  88       7.213  26.134   9.745  1.00  0.00           H  
ATOM   1276  HB3 ALA A  88       5.958  25.334   8.797  1.00  0.00           H  
ATOM   1277  N   VAL A  89       5.523  25.956   6.080  1.00  0.00           N  
ATOM   1278  CA  VAL A  89       4.997  25.382   4.848  1.00  0.00           C  
ATOM   1279  C   VAL A  89       5.585  26.074   3.623  1.00  0.00           C  
ATOM   1280  O   VAL A  89       5.987  25.419   2.662  1.00  0.00           O  
ATOM   1281  CB  VAL A  89       3.460  25.484   4.794  1.00  0.00           C  
ATOM   1282  CG1 VAL A  89       2.936  24.944   3.472  1.00  0.00           C  
ATOM   1283  CG2 VAL A  89       2.836  24.744   5.967  1.00  0.00           C  
ATOM   1284  H   VAL A  89       4.902  26.335   6.735  1.00  0.00           H  
ATOM   1285  HA  VAL A  89       5.268  24.336   4.823  1.00  0.00           H  
ATOM   1286  HB  VAL A  89       3.187  26.526   4.866  1.00  0.00           H  
ATOM   1287 HG11 VAL A  89       2.922  23.865   3.505  1.00  0.00           H  
ATOM   1288 HG12 VAL A  89       1.934  25.313   3.305  1.00  0.00           H  
ATOM   1289 HG13 VAL A  89       3.579  25.272   2.669  1.00  0.00           H  
ATOM   1290 HG21 VAL A  89       3.616  24.352   6.603  1.00  0.00           H  
ATOM   1291 HG22 VAL A  89       2.218  25.426   6.533  1.00  0.00           H  
ATOM   1292 HG23 VAL A  89       2.229  23.931   5.598  1.00  0.00           H  
ATOM   1293  N   ASP A  90       5.630  27.400   3.665  1.00  0.00           N  
ATOM   1294  CA  ASP A  90       6.171  28.182   2.559  1.00  0.00           C  
ATOM   1295  C   ASP A  90       7.602  27.757   2.242  1.00  0.00           C  
ATOM   1296  O   ASP A  90       7.902  27.333   1.125  1.00  0.00           O  
ATOM   1297  CB  ASP A  90       6.131  29.674   2.893  1.00  0.00           C  
ATOM   1298  CG  ASP A  90       5.948  30.538   1.662  1.00  0.00           C  
ATOM   1299  OD1 ASP A  90       4.869  30.461   1.037  1.00  0.00           O  
ATOM   1300  OD2 ASP A  90       6.882  31.294   1.324  1.00  0.00           O  
ATOM   1301  H   ASP A  90       5.294  27.865   4.460  1.00  0.00           H  
ATOM   1302  HA  ASP A  90       5.555  28.000   1.692  1.00  0.00           H  
ATOM   1303  HB2 ASP A  90       5.309  29.863   3.569  1.00  0.00           H  
ATOM   1304  HB3 ASP A  90       7.058  29.953   3.373  1.00  0.00           H  
ATOM   1305  N   LEU A  91       8.482  27.876   3.230  1.00  0.00           N  
ATOM   1306  CA  LEU A  91       9.882  27.505   3.057  1.00  0.00           C  
ATOM   1307  C   LEU A  91      10.005  26.153   2.361  1.00  0.00           C  
ATOM   1308  O   LEU A  91      10.822  25.981   1.456  1.00  0.00           O  
ATOM   1309  CB  LEU A  91      10.590  27.461   4.412  1.00  0.00           C  
ATOM   1310  CG  LEU A  91      12.100  27.223   4.374  1.00  0.00           C  
ATOM   1311  CD1 LEU A  91      12.793  28.323   3.584  1.00  0.00           C  
ATOM   1312  CD2 LEU A  91      12.663  27.141   5.784  1.00  0.00           C  
ATOM   1313  H   LEU A  91       8.184  28.220   4.098  1.00  0.00           H  
ATOM   1314  HA  LEU A  91      10.349  28.257   2.440  1.00  0.00           H  
ATOM   1315  HB2 LEU A  91      10.416  28.404   4.907  1.00  0.00           H  
ATOM   1316  HB3 LEU A  91      10.144  26.665   4.992  1.00  0.00           H  
ATOM   1317  HG  LEU A  91      12.297  26.283   3.878  1.00  0.00           H  
ATOM   1318 HD11 LEU A  91      13.837  28.077   3.464  1.00  0.00           H  
ATOM   1319 HD12 LEU A  91      12.702  29.259   4.115  1.00  0.00           H  
ATOM   1320 HD13 LEU A  91      12.329  28.415   2.612  1.00  0.00           H  
ATOM   1321 HD21 LEU A  91      12.557  26.133   6.156  1.00  0.00           H  
ATOM   1322 HD22 LEU A  91      12.123  27.821   6.427  1.00  0.00           H  
ATOM   1323 HD23 LEU A  91      13.709  27.413   5.771  1.00  0.00           H  
ATOM   1324  N   PHE A  92       9.188  25.197   2.789  1.00  0.00           N  
ATOM   1325  CA  PHE A  92       9.204  23.860   2.207  1.00  0.00           C  
ATOM   1326  C   PHE A  92       8.976  23.920   0.699  1.00  0.00           C  
ATOM   1327  O   PHE A  92       9.484  23.086  -0.050  1.00  0.00           O  
ATOM   1328  CB  PHE A  92       8.134  22.983   2.860  1.00  0.00           C  
ATOM   1329  CG  PHE A  92       8.548  22.424   4.193  1.00  0.00           C  
ATOM   1330  CD1 PHE A  92       9.168  23.231   5.133  1.00  0.00           C  
ATOM   1331  CD2 PHE A  92       8.319  21.094   4.502  1.00  0.00           C  
ATOM   1332  CE1 PHE A  92       9.550  22.722   6.360  1.00  0.00           C  
ATOM   1333  CE2 PHE A  92       8.698  20.579   5.727  1.00  0.00           C  
ATOM   1334  CZ  PHE A  92       9.316  21.392   6.657  1.00  0.00           C  
ATOM   1335  H   PHE A  92       8.558  25.395   3.514  1.00  0.00           H  
ATOM   1336  HA  PHE A  92      10.175  23.430   2.395  1.00  0.00           H  
ATOM   1337  HB2 PHE A  92       7.240  23.568   3.010  1.00  0.00           H  
ATOM   1338  HB3 PHE A  92       7.911  22.153   2.206  1.00  0.00           H  
ATOM   1339  HD1 PHE A  92       9.353  24.271   4.902  1.00  0.00           H  
ATOM   1340  HD2 PHE A  92       7.837  20.455   3.777  1.00  0.00           H  
ATOM   1341  HE1 PHE A  92      10.033  23.360   7.084  1.00  0.00           H  
ATOM   1342  HE2 PHE A  92       8.514  19.540   5.957  1.00  0.00           H  
ATOM   1343  HZ  PHE A  92       9.612  20.992   7.614  1.00  0.00           H  
ATOM   1344  N   ARG A  93       8.210  24.914   0.262  1.00  0.00           N  
ATOM   1345  CA  ARG A  93       7.913  25.084  -1.155  1.00  0.00           C  
ATOM   1346  C   ARG A  93       9.086  25.734  -1.883  1.00  0.00           C  
ATOM   1347  O   ARG A  93       9.512  25.265  -2.938  1.00  0.00           O  
ATOM   1348  CB  ARG A  93       6.654  25.934  -1.336  1.00  0.00           C  
ATOM   1349  CG  ARG A  93       5.399  25.292  -0.766  1.00  0.00           C  
ATOM   1350  CD  ARG A  93       4.177  26.171  -0.980  1.00  0.00           C  
ATOM   1351  NE  ARG A  93       3.530  25.906  -2.263  1.00  0.00           N  
ATOM   1352  CZ  ARG A  93       2.435  26.531  -2.677  1.00  0.00           C  
ATOM   1353  NH1 ARG A  93       1.866  27.454  -1.914  1.00  0.00           N  
ATOM   1354  NH2 ARG A  93       1.905  26.235  -3.858  1.00  0.00           N  
ATOM   1355  H   ARG A  93       7.834  25.548   0.908  1.00  0.00           H  
ATOM   1356  HA  ARG A  93       7.740  24.105  -1.577  1.00  0.00           H  
ATOM   1357  HB2 ARG A  93       6.801  26.884  -0.845  1.00  0.00           H  
ATOM   1358  HB3 ARG A  93       6.497  26.103  -2.391  1.00  0.00           H  
ATOM   1359  HG2 ARG A  93       5.237  24.342  -1.256  1.00  0.00           H  
ATOM   1360  HG3 ARG A  93       5.537  25.133   0.294  1.00  0.00           H  
ATOM   1361  HD2 ARG A  93       3.470  25.982  -0.187  1.00  0.00           H  
ATOM   1362  HD3 ARG A  93       4.484  27.205  -0.950  1.00  0.00           H  
ATOM   1363  HE  ARG A  93       3.934  25.226  -2.843  1.00  0.00           H  
ATOM   1364 HH11 ARG A  93       2.264  27.682  -1.025  1.00  0.00           H  
ATOM   1365 HH12 ARG A  93       1.042  27.925  -2.229  1.00  0.00           H  
ATOM   1366 HH21 ARG A  93       2.331  25.539  -4.435  1.00  0.00           H  
ATOM   1367 HH22 ARG A  93       1.080  26.706  -4.168  1.00  0.00           H  
ATOM   1368  N   ASN A  94       9.604  26.816  -1.311  1.00  0.00           N  
ATOM   1369  CA  ASN A  94      10.728  27.530  -1.905  1.00  0.00           C  
ATOM   1370  C   ASN A  94      11.917  26.598  -2.115  1.00  0.00           C  
ATOM   1371  O   ASN A  94      12.730  26.805  -3.016  1.00  0.00           O  
ATOM   1372  CB  ASN A  94      11.139  28.707  -1.018  1.00  0.00           C  
ATOM   1373  CG  ASN A  94      12.167  29.602  -1.682  1.00  0.00           C  
ATOM   1374  OD1 ASN A  94      11.982  30.041  -2.817  1.00  0.00           O  
ATOM   1375  ND2 ASN A  94      13.258  29.876  -0.975  1.00  0.00           N  
ATOM   1376  H   ASN A  94       9.222  27.142  -0.469  1.00  0.00           H  
ATOM   1377  HA  ASN A  94      10.409  27.909  -2.865  1.00  0.00           H  
ATOM   1378  HB2 ASN A  94      10.265  29.301  -0.791  1.00  0.00           H  
ATOM   1379  HB3 ASN A  94      11.559  28.327  -0.098  1.00  0.00           H  
ATOM   1380 HD21 ASN A  94      13.336  29.491  -0.077  1.00  0.00           H  
ATOM   1381 HD22 ASN A  94      13.938  30.453  -1.381  1.00  0.00           H  
ATOM   1382  N   ALA A  95      12.011  25.570  -1.277  1.00  0.00           N  
ATOM   1383  CA  ALA A  95      13.098  24.604  -1.372  1.00  0.00           C  
ATOM   1384  C   ALA A  95      13.464  24.330  -2.827  1.00  0.00           C  
ATOM   1385  O   ALA A  95      14.499  24.783  -3.312  1.00  0.00           O  
ATOM   1386  CB  ALA A  95      12.716  23.310  -0.669  1.00  0.00           C  
ATOM   1387  H   ALA A  95      11.332  25.459  -0.580  1.00  0.00           H  
ATOM   1388  HA  ALA A  95      13.959  25.020  -0.867  1.00  0.00           H  
ATOM   1389  HB1 ALA A  95      13.027  23.358   0.364  1.00  0.00           H  
ATOM   1390  HB2 ALA A  95      11.645  23.177  -0.716  1.00  0.00           H  
ATOM   1391  HB3 ALA A  95      13.205  22.479  -1.155  1.00  0.00           H  
ATOM   1392  N   GLY A  96      12.606  23.584  -3.517  1.00  0.00           N  
ATOM   1393  CA  GLY A  96      12.858  23.261  -4.909  1.00  0.00           C  
ATOM   1394  C   GLY A  96      13.133  21.786  -5.122  1.00  0.00           C  
ATOM   1395  O   GLY A  96      13.016  20.985  -4.194  1.00  0.00           O  
ATOM   1396  H   GLY A  96      11.797  23.250  -3.077  1.00  0.00           H  
ATOM   1397  HA2 GLY A  96      11.996  23.545  -5.494  1.00  0.00           H  
ATOM   1398  HA3 GLY A  96      13.713  23.827  -5.249  1.00  0.00           H  
ATOM   1399  N   TYR A  97      13.497  21.425  -6.348  1.00  0.00           N  
ATOM   1400  CA  TYR A  97      13.785  20.035  -6.681  1.00  0.00           C  
ATOM   1401  C   TYR A  97      14.452  19.320  -5.509  1.00  0.00           C  
ATOM   1402  O   TYR A  97      13.984  18.276  -5.056  1.00  0.00           O  
ATOM   1403  CB  TYR A  97      14.682  19.959  -7.917  1.00  0.00           C  
ATOM   1404  CG  TYR A  97      14.750  18.581  -8.534  1.00  0.00           C  
ATOM   1405  CD1 TYR A  97      13.849  18.194  -9.518  1.00  0.00           C  
ATOM   1406  CD2 TYR A  97      15.713  17.664  -8.131  1.00  0.00           C  
ATOM   1407  CE1 TYR A  97      13.906  16.936 -10.084  1.00  0.00           C  
ATOM   1408  CE2 TYR A  97      15.779  16.404  -8.693  1.00  0.00           C  
ATOM   1409  CZ  TYR A  97      14.872  16.045  -9.670  1.00  0.00           C  
ATOM   1410  OH  TYR A  97      14.934  14.789 -10.230  1.00  0.00           O  
ATOM   1411  H   TYR A  97      13.572  22.108  -7.045  1.00  0.00           H  
ATOM   1412  HA  TYR A  97      12.847  19.544  -6.899  1.00  0.00           H  
ATOM   1413  HB2 TYR A  97      14.309  20.640  -8.666  1.00  0.00           H  
ATOM   1414  HB3 TYR A  97      15.687  20.250  -7.642  1.00  0.00           H  
ATOM   1415  HD1 TYR A  97      13.092  18.895  -9.842  1.00  0.00           H  
ATOM   1416  HD2 TYR A  97      16.421  17.949  -7.367  1.00  0.00           H  
ATOM   1417  HE1 TYR A  97      13.197  16.654 -10.849  1.00  0.00           H  
ATOM   1418  HE2 TYR A  97      16.536  15.706  -8.368  1.00  0.00           H  
ATOM   1419  HH  TYR A  97      15.454  14.825 -11.036  1.00  0.00           H  
ATOM   1420  N   ALA A  98      15.548  19.893  -5.023  1.00  0.00           N  
ATOM   1421  CA  ALA A  98      16.279  19.314  -3.903  1.00  0.00           C  
ATOM   1422  C   ALA A  98      15.870  19.963  -2.585  1.00  0.00           C  
ATOM   1423  O   ALA A  98      16.130  21.144  -2.355  1.00  0.00           O  
ATOM   1424  CB  ALA A  98      17.778  19.458  -4.120  1.00  0.00           C  
ATOM   1425  H   ALA A  98      15.872  20.725  -5.427  1.00  0.00           H  
ATOM   1426  HA  ALA A  98      16.047  18.259  -3.861  1.00  0.00           H  
ATOM   1427  HB1 ALA A  98      18.148  20.288  -3.537  1.00  0.00           H  
ATOM   1428  HB2 ALA A  98      18.275  18.550  -3.810  1.00  0.00           H  
ATOM   1429  HB3 ALA A  98      17.974  19.638  -5.166  1.00  0.00           H  
ATOM   1430  N   VAL A  99      15.224  19.183  -1.723  1.00  0.00           N  
ATOM   1431  CA  VAL A  99      14.778  19.682  -0.428  1.00  0.00           C  
ATOM   1432  C   VAL A  99      15.585  19.063   0.708  1.00  0.00           C  
ATOM   1433  O   VAL A  99      15.434  17.881   1.017  1.00  0.00           O  
ATOM   1434  CB  VAL A  99      13.283  19.392  -0.199  1.00  0.00           C  
ATOM   1435  CG1 VAL A  99      12.860  19.832   1.194  1.00  0.00           C  
ATOM   1436  CG2 VAL A  99      12.438  20.076  -1.263  1.00  0.00           C  
ATOM   1437  H   VAL A  99      15.045  18.251  -1.963  1.00  0.00           H  
ATOM   1438  HA  VAL A  99      14.921  20.754  -0.415  1.00  0.00           H  
ATOM   1439  HB  VAL A  99      13.129  18.325  -0.277  1.00  0.00           H  
ATOM   1440 HG11 VAL A  99      13.539  19.418   1.924  1.00  0.00           H  
ATOM   1441 HG12 VAL A  99      12.880  20.910   1.253  1.00  0.00           H  
ATOM   1442 HG13 VAL A  99      11.859  19.479   1.395  1.00  0.00           H  
ATOM   1443 HG21 VAL A  99      13.083  20.599  -1.953  1.00  0.00           H  
ATOM   1444 HG22 VAL A  99      11.865  19.333  -1.798  1.00  0.00           H  
ATOM   1445 HG23 VAL A  99      11.766  20.779  -0.793  1.00  0.00           H  
ATOM   1446  N   SER A 100      16.442  19.869   1.326  1.00  0.00           N  
ATOM   1447  CA  SER A 100      17.276  19.399   2.425  1.00  0.00           C  
ATOM   1448  C   SER A 100      16.610  19.677   3.770  1.00  0.00           C  
ATOM   1449  O   SER A 100      16.377  20.831   4.133  1.00  0.00           O  
ATOM   1450  CB  SER A 100      18.650  20.072   2.376  1.00  0.00           C  
ATOM   1451  OG  SER A 100      19.336  19.741   1.181  1.00  0.00           O  
ATOM   1452  H   SER A 100      16.517  20.802   1.033  1.00  0.00           H  
ATOM   1453  HA  SER A 100      17.403  18.332   2.314  1.00  0.00           H  
ATOM   1454  HB2 SER A 100      18.525  21.143   2.420  1.00  0.00           H  
ATOM   1455  HB3 SER A 100      19.239  19.743   3.219  1.00  0.00           H  
ATOM   1456  HG  SER A 100      19.061  20.335   0.479  1.00  0.00           H  
ATOM   1457  N   LEU A 101      16.306  18.612   4.504  1.00  0.00           N  
ATOM   1458  CA  LEU A 101      15.666  18.740   5.808  1.00  0.00           C  
ATOM   1459  C   LEU A 101      16.541  18.140   6.905  1.00  0.00           C  
ATOM   1460  O   LEU A 101      16.728  16.925   6.969  1.00  0.00           O  
ATOM   1461  CB  LEU A 101      14.300  18.052   5.798  1.00  0.00           C  
ATOM   1462  CG  LEU A 101      13.366  18.434   4.649  1.00  0.00           C  
ATOM   1463  CD1 LEU A 101      12.099  17.593   4.689  1.00  0.00           C  
ATOM   1464  CD2 LEU A 101      13.026  19.917   4.709  1.00  0.00           C  
ATOM   1465  H   LEU A 101      16.517  17.719   4.161  1.00  0.00           H  
ATOM   1466  HA  LEU A 101      15.529  19.792   6.009  1.00  0.00           H  
ATOM   1467  HB2 LEU A 101      14.466  16.987   5.748  1.00  0.00           H  
ATOM   1468  HB3 LEU A 101      13.801  18.294   6.726  1.00  0.00           H  
ATOM   1469  HG  LEU A 101      13.864  18.242   3.709  1.00  0.00           H  
ATOM   1470 HD11 LEU A 101      12.017  17.112   5.651  1.00  0.00           H  
ATOM   1471 HD12 LEU A 101      12.142  16.843   3.913  1.00  0.00           H  
ATOM   1472 HD13 LEU A 101      11.240  18.228   4.529  1.00  0.00           H  
ATOM   1473 HD21 LEU A 101      13.745  20.426   5.332  1.00  0.00           H  
ATOM   1474 HD22 LEU A 101      12.036  20.042   5.124  1.00  0.00           H  
ATOM   1475 HD23 LEU A 101      13.052  20.332   3.712  1.00  0.00           H  
ATOM   1476  N   ARG A 102      17.073  19.001   7.767  1.00  0.00           N  
ATOM   1477  CA  ARG A 102      17.927  18.556   8.861  1.00  0.00           C  
ATOM   1478  C   ARG A 102      17.096  18.201  10.090  1.00  0.00           C  
ATOM   1479  O   ARG A 102      16.682  19.079  10.848  1.00  0.00           O  
ATOM   1480  CB  ARG A 102      18.944  19.642   9.217  1.00  0.00           C  
ATOM   1481  CG  ARG A 102      20.100  19.140  10.066  1.00  0.00           C  
ATOM   1482  CD  ARG A 102      20.887  20.291  10.673  1.00  0.00           C  
ATOM   1483  NE  ARG A 102      22.182  19.858  11.189  1.00  0.00           N  
ATOM   1484  CZ  ARG A 102      22.991  20.639  11.897  1.00  0.00           C  
ATOM   1485  NH1 ARG A 102      22.638  21.887  12.172  1.00  0.00           N  
ATOM   1486  NH2 ARG A 102      24.154  20.171  12.332  1.00  0.00           N  
ATOM   1487  H   ARG A 102      16.888  19.958   7.664  1.00  0.00           H  
ATOM   1488  HA  ARG A 102      18.456  17.674   8.532  1.00  0.00           H  
ATOM   1489  HB2 ARG A 102      19.349  20.053   8.304  1.00  0.00           H  
ATOM   1490  HB3 ARG A 102      18.440  20.426   9.761  1.00  0.00           H  
ATOM   1491  HG2 ARG A 102      19.709  18.526  10.864  1.00  0.00           H  
ATOM   1492  HG3 ARG A 102      20.761  18.551   9.447  1.00  0.00           H  
ATOM   1493  HD2 ARG A 102      21.046  21.042   9.914  1.00  0.00           H  
ATOM   1494  HD3 ARG A 102      20.311  20.715  11.483  1.00  0.00           H  
ATOM   1495  HE  ARG A 102      22.462  18.938  10.997  1.00  0.00           H  
ATOM   1496 HH11 ARG A 102      21.762  22.241  11.846  1.00  0.00           H  
ATOM   1497 HH12 ARG A 102      23.249  22.472  12.706  1.00  0.00           H  
ATOM   1498 HH21 ARG A 102      24.423  19.231  12.126  1.00  0.00           H  
ATOM   1499 HH22 ARG A 102      24.762  20.760  12.863  1.00  0.00           H  
ATOM   1500  N   VAL A 103      16.854  16.908  10.282  1.00  0.00           N  
ATOM   1501  CA  VAL A 103      16.073  16.437  11.419  1.00  0.00           C  
ATOM   1502  C   VAL A 103      16.968  15.802  12.477  1.00  0.00           C  
ATOM   1503  O   VAL A 103      18.119  15.458  12.204  1.00  0.00           O  
ATOM   1504  CB  VAL A 103      15.008  15.412  10.982  1.00  0.00           C  
ATOM   1505  CG1 VAL A 103      14.096  16.009   9.921  1.00  0.00           C  
ATOM   1506  CG2 VAL A 103      15.670  14.141  10.473  1.00  0.00           C  
ATOM   1507  H   VAL A 103      17.210  16.256   9.643  1.00  0.00           H  
ATOM   1508  HA  VAL A 103      15.566  17.287  11.852  1.00  0.00           H  
ATOM   1509  HB  VAL A 103      14.406  15.159  11.842  1.00  0.00           H  
ATOM   1510 HG11 VAL A 103      14.644  16.741   9.345  1.00  0.00           H  
ATOM   1511 HG12 VAL A 103      13.742  15.226   9.268  1.00  0.00           H  
ATOM   1512 HG13 VAL A 103      13.253  16.487  10.399  1.00  0.00           H  
ATOM   1513 HG21 VAL A 103      16.730  14.179  10.677  1.00  0.00           H  
ATOM   1514 HG22 VAL A 103      15.237  13.286  10.970  1.00  0.00           H  
ATOM   1515 HG23 VAL A 103      15.512  14.054   9.407  1.00  0.00           H  
ATOM   1516  N   GLN A 104      16.433  15.649  13.684  1.00  0.00           N  
ATOM   1517  CA  GLN A 104      17.185  15.056  14.782  1.00  0.00           C  
ATOM   1518  C   GLN A 104      16.510  13.781  15.279  1.00  0.00           C  
ATOM   1519  O   GLN A 104      15.375  13.814  15.755  1.00  0.00           O  
ATOM   1520  CB  GLN A 104      17.322  16.056  15.932  1.00  0.00           C  
ATOM   1521  CG  GLN A 104      18.126  15.523  17.108  1.00  0.00           C  
ATOM   1522  CD  GLN A 104      18.082  16.446  18.310  1.00  0.00           C  
ATOM   1523  OE1 GLN A 104      17.480  16.124  19.334  1.00  0.00           O  
ATOM   1524  NE2 GLN A 104      18.724  17.603  18.191  1.00  0.00           N  
ATOM   1525  H   GLN A 104      15.512  15.943  13.838  1.00  0.00           H  
ATOM   1526  HA  GLN A 104      18.169  14.808  14.414  1.00  0.00           H  
ATOM   1527  HB2 GLN A 104      17.812  16.945  15.564  1.00  0.00           H  
ATOM   1528  HB3 GLN A 104      16.337  16.317  16.287  1.00  0.00           H  
ATOM   1529  HG2 GLN A 104      17.724  14.564  17.398  1.00  0.00           H  
ATOM   1530  HG3 GLN A 104      19.154  15.403  16.801  1.00  0.00           H  
ATOM   1531 HE21 GLN A 104      19.181  17.794  17.344  1.00  0.00           H  
ATOM   1532 HE22 GLN A 104      18.712  18.219  18.952  1.00  0.00           H  
ATOM   1533  N   HIS A 105      17.215  12.661  15.165  1.00  0.00           N  
ATOM   1534  CA  HIS A 105      16.684  11.375  15.603  1.00  0.00           C  
ATOM   1535  C   HIS A 105      16.876  11.191  17.105  1.00  0.00           C  
ATOM   1536  O   HIS A 105      17.999  11.018  17.580  1.00  0.00           O  
ATOM   1537  CB  HIS A 105      17.364  10.234  14.846  1.00  0.00           C  
ATOM   1538  CG  HIS A 105      17.337  10.403  13.357  1.00  0.00           C  
ATOM   1539  ND1 HIS A 105      16.169  10.522  12.634  1.00  0.00           N  
ATOM   1540  CD2 HIS A 105      18.344  10.473  12.457  1.00  0.00           C  
ATOM   1541  CE1 HIS A 105      16.458  10.657  11.352  1.00  0.00           C  
ATOM   1542  NE2 HIS A 105      17.772  10.630  11.218  1.00  0.00           N  
ATOM   1543  H   HIS A 105      18.115  12.700  14.777  1.00  0.00           H  
ATOM   1544  HA  HIS A 105      15.627  11.361  15.383  1.00  0.00           H  
ATOM   1545  HB2 HIS A 105      18.397  10.173  15.153  1.00  0.00           H  
ATOM   1546  HB3 HIS A 105      16.866   9.305  15.084  1.00  0.00           H  
ATOM   1547  HD1 HIS A 105      15.262  10.508  13.005  1.00  0.00           H  
ATOM   1548  HD2 HIS A 105      19.402  10.415  12.670  1.00  0.00           H  
ATOM   1549  HE1 HIS A 105      15.744  10.770  10.551  1.00  0.00           H  
ATOM   1550  N   ARG A 106      15.774  11.230  17.847  1.00  0.00           N  
ATOM   1551  CA  ARG A 106      15.822  11.069  19.295  1.00  0.00           C  
ATOM   1552  C   ARG A 106      14.970   9.884  19.739  1.00  0.00           C  
ATOM   1553  O   ARG A 106      13.739   9.942  19.704  1.00  0.00           O  
ATOM   1554  CB  ARG A 106      15.341  12.345  19.987  1.00  0.00           C  
ATOM   1555  CG  ARG A 106      14.314  13.124  19.182  1.00  0.00           C  
ATOM   1556  CD  ARG A 106      13.783  14.317  19.962  1.00  0.00           C  
ATOM   1557  NE  ARG A 106      12.444  14.705  19.526  1.00  0.00           N  
ATOM   1558  CZ  ARG A 106      11.632  15.476  20.240  1.00  0.00           C  
ATOM   1559  NH1 ARG A 106      12.022  15.939  21.421  1.00  0.00           N  
ATOM   1560  NH2 ARG A 106      10.428  15.784  19.776  1.00  0.00           N  
ATOM   1561  H   ARG A 106      14.908  11.371  17.410  1.00  0.00           H  
ATOM   1562  HA  ARG A 106      16.848  10.884  19.574  1.00  0.00           H  
ATOM   1563  HB2 ARG A 106      14.896  12.081  20.936  1.00  0.00           H  
ATOM   1564  HB3 ARG A 106      16.191  12.987  20.163  1.00  0.00           H  
ATOM   1565  HG2 ARG A 106      14.776  13.480  18.274  1.00  0.00           H  
ATOM   1566  HG3 ARG A 106      13.490  12.470  18.937  1.00  0.00           H  
ATOM   1567  HD2 ARG A 106      13.748  14.059  21.010  1.00  0.00           H  
ATOM   1568  HD3 ARG A 106      14.454  15.151  19.819  1.00  0.00           H  
ATOM   1569  HE  ARG A 106      12.136  14.373  18.657  1.00  0.00           H  
ATOM   1570 HH11 ARG A 106      12.928  15.709  21.772  1.00  0.00           H  
ATOM   1571 HH12 ARG A 106      11.409  16.520  21.957  1.00  0.00           H  
ATOM   1572 HH21 ARG A 106      10.132  15.437  18.887  1.00  0.00           H  
ATOM   1573 HH22 ARG A 106       9.818  16.364  20.315  1.00  0.00           H  
ATOM   1574  N   LEU A 107      15.630   8.810  20.155  1.00  0.00           N  
ATOM   1575  CA  LEU A 107      14.934   7.609  20.606  1.00  0.00           C  
ATOM   1576  C   LEU A 107      15.301   7.276  22.049  1.00  0.00           C  
ATOM   1577  O   LEU A 107      16.454   7.419  22.453  1.00  0.00           O  
ATOM   1578  CB  LEU A 107      15.270   6.427  19.695  1.00  0.00           C  
ATOM   1579  CG  LEU A 107      16.663   6.442  19.065  1.00  0.00           C  
ATOM   1580  CD1 LEU A 107      16.806   7.620  18.113  1.00  0.00           C  
ATOM   1581  CD2 LEU A 107      17.737   6.492  20.142  1.00  0.00           C  
ATOM   1582  H   LEU A 107      16.610   8.822  20.161  1.00  0.00           H  
ATOM   1583  HA  LEU A 107      13.872   7.803  20.554  1.00  0.00           H  
ATOM   1584  HB2 LEU A 107      15.181   5.525  20.279  1.00  0.00           H  
ATOM   1585  HB3 LEU A 107      14.544   6.411  18.896  1.00  0.00           H  
ATOM   1586  HG  LEU A 107      16.803   5.534  18.495  1.00  0.00           H  
ATOM   1587 HD11 LEU A 107      17.520   8.323  18.514  1.00  0.00           H  
ATOM   1588 HD12 LEU A 107      15.848   8.105  17.995  1.00  0.00           H  
ATOM   1589 HD13 LEU A 107      17.149   7.266  17.151  1.00  0.00           H  
ATOM   1590 HD21 LEU A 107      17.371   6.012  21.037  1.00  0.00           H  
ATOM   1591 HD22 LEU A 107      17.979   7.522  20.360  1.00  0.00           H  
ATOM   1592 HD23 LEU A 107      18.622   5.980  19.793  1.00  0.00           H  
ATOM   1593  N   GLN A 108      14.313   6.829  22.817  1.00  0.00           N  
ATOM   1594  CA  GLN A 108      14.534   6.473  24.214  1.00  0.00           C  
ATOM   1595  C   GLN A 108      15.451   5.260  24.328  1.00  0.00           C  
ATOM   1596  O   GLN A 108      15.177   4.205  23.757  1.00  0.00           O  
ATOM   1597  CB  GLN A 108      13.200   6.186  24.906  1.00  0.00           C  
ATOM   1598  CG  GLN A 108      13.351   5.691  26.335  1.00  0.00           C  
ATOM   1599  CD  GLN A 108      12.133   4.929  26.820  1.00  0.00           C  
ATOM   1600  OE1 GLN A 108      11.404   4.330  26.028  1.00  0.00           O  
ATOM   1601  NE2 GLN A 108      11.905   4.946  28.128  1.00  0.00           N  
ATOM   1602  H   GLN A 108      13.416   6.737  22.437  1.00  0.00           H  
ATOM   1603  HA  GLN A 108      15.007   7.314  24.700  1.00  0.00           H  
ATOM   1604  HB2 GLN A 108      12.614   7.092  24.921  1.00  0.00           H  
ATOM   1605  HB3 GLN A 108      12.670   5.433  24.342  1.00  0.00           H  
ATOM   1606  HG2 GLN A 108      14.209   5.036  26.388  1.00  0.00           H  
ATOM   1607  HG3 GLN A 108      13.507   6.541  26.982  1.00  0.00           H  
ATOM   1608 HE21 GLN A 108      12.528   5.445  28.699  1.00  0.00           H  
ATOM   1609 HE22 GLN A 108      11.125   4.464  28.469  1.00  0.00           H  
ATOM   1610  N   VAL A 109      16.543   5.418  25.070  1.00  0.00           N  
ATOM   1611  CA  VAL A 109      17.501   4.335  25.260  1.00  0.00           C  
ATOM   1612  C   VAL A 109      17.028   3.365  26.337  1.00  0.00           C  
ATOM   1613  O   VAL A 109      16.559   3.781  27.397  1.00  0.00           O  
ATOM   1614  CB  VAL A 109      18.890   4.877  25.647  1.00  0.00           C  
ATOM   1615  CG1 VAL A 109      19.845   3.732  25.948  1.00  0.00           C  
ATOM   1616  CG2 VAL A 109      19.442   5.766  24.543  1.00  0.00           C  
ATOM   1617  H   VAL A 109      16.708   6.283  25.501  1.00  0.00           H  
ATOM   1618  HA  VAL A 109      17.593   3.803  24.325  1.00  0.00           H  
ATOM   1619  HB  VAL A 109      18.785   5.473  26.542  1.00  0.00           H  
ATOM   1620 HG11 VAL A 109      20.784   3.905  25.444  1.00  0.00           H  
ATOM   1621 HG12 VAL A 109      20.012   3.672  27.014  1.00  0.00           H  
ATOM   1622 HG13 VAL A 109      19.416   2.804  25.598  1.00  0.00           H  
ATOM   1623 HG21 VAL A 109      20.124   5.196  23.928  1.00  0.00           H  
ATOM   1624 HG22 VAL A 109      18.627   6.130  23.935  1.00  0.00           H  
ATOM   1625 HG23 VAL A 109      19.966   6.602  24.981  1.00  0.00           H  
ATOM   1626  N   GLN A 110      17.154   2.073  26.058  1.00  0.00           N  
ATOM   1627  CA  GLN A 110      16.739   1.043  27.004  1.00  0.00           C  
ATOM   1628  C   GLN A 110      17.624   1.055  28.245  1.00  0.00           C  
ATOM   1629  O   GLN A 110      18.587   0.295  28.342  1.00  0.00           O  
ATOM   1630  CB  GLN A 110      16.786  -0.336  26.343  1.00  0.00           C  
ATOM   1631  CG  GLN A 110      15.904  -0.450  25.110  1.00  0.00           C  
ATOM   1632  CD  GLN A 110      16.601   0.015  23.848  1.00  0.00           C  
ATOM   1633  OE1 GLN A 110      16.218   1.018  23.246  1.00  0.00           O  
ATOM   1634  NE2 GLN A 110      17.634  -0.713  23.439  1.00  0.00           N  
ATOM   1635  H   GLN A 110      17.535   1.804  25.196  1.00  0.00           H  
ATOM   1636  HA  GLN A 110      15.723   1.255  27.299  1.00  0.00           H  
ATOM   1637  HB2 GLN A 110      17.805  -0.547  26.051  1.00  0.00           H  
ATOM   1638  HB3 GLN A 110      16.465  -1.076  27.060  1.00  0.00           H  
ATOM   1639  HG2 GLN A 110      15.617  -1.484  24.984  1.00  0.00           H  
ATOM   1640  HG3 GLN A 110      15.020   0.152  25.259  1.00  0.00           H  
ATOM   1641 HE21 GLN A 110      17.883  -1.501  23.967  1.00  0.00           H  
ATOM   1642 HE22 GLN A 110      18.102  -0.436  22.625  1.00  0.00           H  
ATOM   1643  N   ASN A 111      17.293   1.925  29.194  1.00  0.00           N  
ATOM   1644  CA  ASN A 111      18.059   2.037  30.430  1.00  0.00           C  
ATOM   1645  C   ASN A 111      17.676   0.932  31.410  1.00  0.00           C  
ATOM   1646  O   ASN A 111      16.749   1.085  32.204  1.00  0.00           O  
ATOM   1647  CB  ASN A 111      17.829   3.406  31.074  1.00  0.00           C  
ATOM   1648  CG  ASN A 111      16.391   3.606  31.511  1.00  0.00           C  
ATOM   1649  OD1 ASN A 111      15.466   3.508  30.706  1.00  0.00           O  
ATOM   1650  ND2 ASN A 111      16.197   3.888  32.795  1.00  0.00           N  
ATOM   1651  H   ASN A 111      16.514   2.505  29.060  1.00  0.00           H  
ATOM   1652  HA  ASN A 111      19.104   1.937  30.182  1.00  0.00           H  
ATOM   1653  HB2 ASN A 111      18.466   3.500  31.942  1.00  0.00           H  
ATOM   1654  HB3 ASN A 111      18.081   4.178  30.364  1.00  0.00           H  
ATOM   1655 HD21 ASN A 111      16.981   3.951  33.378  1.00  0.00           H  
ATOM   1656 HD22 ASN A 111      15.277   4.021  33.105  1.00  0.00           H  
ATOM   1657  N   GLY A 112      18.398  -0.183  31.346  1.00  0.00           N  
ATOM   1658  CA  GLY A 112      18.119  -1.299  32.233  1.00  0.00           C  
ATOM   1659  C   GLY A 112      18.712  -2.599  31.731  1.00  0.00           C  
ATOM   1660  O   GLY A 112      18.948  -2.779  30.536  1.00  0.00           O  
ATOM   1661  H   GLY A 112      19.125  -0.249  30.693  1.00  0.00           H  
ATOM   1662  HA2 GLY A 112      18.529  -1.080  33.207  1.00  0.00           H  
ATOM   1663  HA3 GLY A 112      17.049  -1.414  32.322  1.00  0.00           H  
ATOM   1664  N   PRO A 113      18.964  -3.536  32.658  1.00  0.00           N  
ATOM   1665  CA  PRO A 113      19.538  -4.844  32.326  1.00  0.00           C  
ATOM   1666  C   PRO A 113      18.561  -5.727  31.558  1.00  0.00           C  
ATOM   1667  O   PRO A 113      17.385  -5.391  31.417  1.00  0.00           O  
ATOM   1668  CB  PRO A 113      19.846  -5.454  33.696  1.00  0.00           C  
ATOM   1669  CG  PRO A 113      18.898  -4.784  34.631  1.00  0.00           C  
ATOM   1670  CD  PRO A 113      18.708  -3.390  34.100  1.00  0.00           C  
ATOM   1671  HA  PRO A 113      20.452  -4.743  31.761  1.00  0.00           H  
ATOM   1672  HB2 PRO A 113      19.682  -6.521  33.663  1.00  0.00           H  
ATOM   1673  HB3 PRO A 113      20.872  -5.249  33.963  1.00  0.00           H  
ATOM   1674  HG2 PRO A 113      17.956  -5.313  34.639  1.00  0.00           H  
ATOM   1675  HG3 PRO A 113      19.321  -4.753  35.623  1.00  0.00           H  
ATOM   1676  HD2 PRO A 113      17.698  -3.052  34.281  1.00  0.00           H  
ATOM   1677  HD3 PRO A 113      19.420  -2.715  34.551  1.00  0.00           H  
ATOM   1678  N   ILE A 114      19.055  -6.858  31.065  1.00  0.00           N  
ATOM   1679  CA  ILE A 114      18.224  -7.790  30.313  1.00  0.00           C  
ATOM   1680  C   ILE A 114      18.381  -9.213  30.837  1.00  0.00           C  
ATOM   1681  O   ILE A 114      19.491  -9.659  31.129  1.00  0.00           O  
ATOM   1682  CB  ILE A 114      18.570  -7.767  28.812  1.00  0.00           C  
ATOM   1683  CG1 ILE A 114      18.368  -6.361  28.241  1.00  0.00           C  
ATOM   1684  CG2 ILE A 114      17.721  -8.779  28.058  1.00  0.00           C  
ATOM   1685  CD1 ILE A 114      19.009  -6.161  26.886  1.00  0.00           C  
ATOM   1686  H   ILE A 114      20.000  -7.071  31.211  1.00  0.00           H  
ATOM   1687  HA  ILE A 114      17.194  -7.486  30.429  1.00  0.00           H  
ATOM   1688  HB  ILE A 114      19.606  -8.047  28.699  1.00  0.00           H  
ATOM   1689 HG12 ILE A 114      17.311  -6.170  28.139  1.00  0.00           H  
ATOM   1690 HG13 ILE A 114      18.796  -5.640  28.922  1.00  0.00           H  
ATOM   1691 HG21 ILE A 114      17.071  -8.260  27.368  1.00  0.00           H  
ATOM   1692 HG22 ILE A 114      18.364  -9.450  27.508  1.00  0.00           H  
ATOM   1693 HG23 ILE A 114      17.125  -9.343  28.758  1.00  0.00           H  
ATOM   1694 HD11 ILE A 114      19.348  -7.115  26.504  1.00  0.00           H  
ATOM   1695 HD12 ILE A 114      18.287  -5.737  26.204  1.00  0.00           H  
ATOM   1696 HD13 ILE A 114      19.852  -5.494  26.981  1.00  0.00           H  
ATOM   1697  N   SER A 115      17.263  -9.923  30.952  1.00  0.00           N  
ATOM   1698  CA  SER A 115      17.276 -11.295  31.444  1.00  0.00           C  
ATOM   1699  C   SER A 115      17.786 -12.252  30.370  1.00  0.00           C  
ATOM   1700  O   SER A 115      17.041 -12.658  29.479  1.00  0.00           O  
ATOM   1701  CB  SER A 115      15.873 -11.712  31.889  1.00  0.00           C  
ATOM   1702  OG  SER A 115      15.852 -13.068  32.301  1.00  0.00           O  
ATOM   1703  H   SER A 115      16.409  -9.511  30.703  1.00  0.00           H  
ATOM   1704  HA  SER A 115      17.942 -11.338  32.292  1.00  0.00           H  
ATOM   1705  HB2 SER A 115      15.562 -11.093  32.716  1.00  0.00           H  
ATOM   1706  HB3 SER A 115      15.184 -11.587  31.066  1.00  0.00           H  
ATOM   1707  HG  SER A 115      15.204 -13.551  31.781  1.00  0.00           H  
ATOM   1708  N   GLY A 116      19.064 -12.606  30.461  1.00  0.00           N  
ATOM   1709  CA  GLY A 116      19.653 -13.513  29.492  1.00  0.00           C  
ATOM   1710  C   GLY A 116      20.897 -14.199  30.021  1.00  0.00           C  
ATOM   1711  O   GLY A 116      21.189 -14.165  31.216  1.00  0.00           O  
ATOM   1712  H   GLY A 116      19.611 -12.252  31.193  1.00  0.00           H  
ATOM   1713  HA2 GLY A 116      18.925 -14.264  29.228  1.00  0.00           H  
ATOM   1714  HA3 GLY A 116      19.915 -12.952  28.606  1.00  0.00           H  
ATOM   1715  N   PRO A 117      21.653 -14.841  29.118  1.00  0.00           N  
ATOM   1716  CA  PRO A 117      22.884 -15.552  29.478  1.00  0.00           C  
ATOM   1717  C   PRO A 117      24.004 -14.601  29.886  1.00  0.00           C  
ATOM   1718  O   PRO A 117      23.907 -13.391  29.686  1.00  0.00           O  
ATOM   1719  CB  PRO A 117      23.253 -16.293  28.191  1.00  0.00           C  
ATOM   1720  CG  PRO A 117      22.630 -15.494  27.100  1.00  0.00           C  
ATOM   1721  CD  PRO A 117      21.365 -14.921  27.676  1.00  0.00           C  
ATOM   1722  HA  PRO A 117      22.713 -16.265  30.271  1.00  0.00           H  
ATOM   1723  HB2 PRO A 117      24.330 -16.331  28.091  1.00  0.00           H  
ATOM   1724  HB3 PRO A 117      22.854 -17.297  28.222  1.00  0.00           H  
ATOM   1725  HG2 PRO A 117      23.298 -14.701  26.799  1.00  0.00           H  
ATOM   1726  HG3 PRO A 117      22.404 -16.134  26.260  1.00  0.00           H  
ATOM   1727  HD2 PRO A 117      21.173 -13.942  27.265  1.00  0.00           H  
ATOM   1728  HD3 PRO A 117      20.532 -15.582  27.487  1.00  0.00           H  
ATOM   1729  N   SER A 118      25.068 -15.157  30.456  1.00  0.00           N  
ATOM   1730  CA  SER A 118      26.205 -14.358  30.894  1.00  0.00           C  
ATOM   1731  C   SER A 118      26.630 -13.375  29.808  1.00  0.00           C  
ATOM   1732  O   SER A 118      27.143 -13.771  28.762  1.00  0.00           O  
ATOM   1733  CB  SER A 118      27.381 -15.265  31.264  1.00  0.00           C  
ATOM   1734  OG  SER A 118      28.416 -14.529  31.893  1.00  0.00           O  
ATOM   1735  H   SER A 118      25.086 -16.128  30.587  1.00  0.00           H  
ATOM   1736  HA  SER A 118      25.903 -13.801  31.769  1.00  0.00           H  
ATOM   1737  HB2 SER A 118      27.040 -16.034  31.940  1.00  0.00           H  
ATOM   1738  HB3 SER A 118      27.775 -15.723  30.367  1.00  0.00           H  
ATOM   1739  HG  SER A 118      28.040 -13.967  32.575  1.00  0.00           H  
ATOM   1740  N   SER A 119      26.410 -12.089  30.064  1.00  0.00           N  
ATOM   1741  CA  SER A 119      26.766 -11.047  29.107  1.00  0.00           C  
ATOM   1742  C   SER A 119      28.281 -10.945  28.953  1.00  0.00           C  
ATOM   1743  O   SER A 119      28.996 -10.668  29.915  1.00  0.00           O  
ATOM   1744  CB  SER A 119      26.196  -9.699  29.553  1.00  0.00           C  
ATOM   1745  OG  SER A 119      26.544  -8.672  28.643  1.00  0.00           O  
ATOM   1746  H   SER A 119      25.998 -11.835  30.917  1.00  0.00           H  
ATOM   1747  HA  SER A 119      26.335 -11.313  28.154  1.00  0.00           H  
ATOM   1748  HB2 SER A 119      25.120  -9.767  29.606  1.00  0.00           H  
ATOM   1749  HB3 SER A 119      26.589  -9.450  30.528  1.00  0.00           H  
ATOM   1750  HG  SER A 119      27.401  -8.309  28.882  1.00  0.00           H  
ATOM   1751  N   GLY A 120      28.761 -11.170  27.733  1.00  0.00           N  
ATOM   1752  CA  GLY A 120      30.187 -11.099  27.474  1.00  0.00           C  
ATOM   1753  C   GLY A 120      30.723  -9.684  27.564  1.00  0.00           C  
ATOM   1754  O   GLY A 120      31.282  -9.289  28.587  1.00  0.00           O  
ATOM   1755  H   GLY A 120      28.142 -11.386  27.005  1.00  0.00           H  
ATOM   1756  HA2 GLY A 120      30.704 -11.716  28.195  1.00  0.00           H  
ATOM   1757  HA3 GLY A 120      30.380 -11.482  26.483  1.00  0.00           H  
TER    1758      GLY A 120                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
