
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  722),  selected   95 , name 1ihj_B
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 1ihj_B.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    12_B      S       1          4.088
LGA    E    13_B      M       2          1.782
LGA    L    14_B      E       3          0.457
LGA    I    15_B      I       4          0.750
LGA    H    16_B      L       5          0.652
LGA    M    17_B      Q       6          0.526
LGA    V    18_B      V       7          0.551
LGA    T    19_B      A       8          0.623
LGA    L    20_B      L       9          0.990
LGA    D    21_B      H      10          0.878
LGA    K    22_B      K      11          1.893
LGA    T    23_B      R      12          1.691
LGA    G    24_B      D      13          5.421
LGA    K    25_B      S      14           -
LGA    K    26_B      G      15          5.300
LGA    S    27_B      E      16          2.673
LGA    -       -      Q      17           -
LGA    F    28_B      L      18          1.041
LGA    G    29_B      G      19          0.877
LGA    I    30_B      I      20          1.004
LGA    C    31_B      K      21          1.636
LGA    I    32_B      L      22          0.618
LGA    V    33_B      V      23          0.904
LGA    R    34_B      R      24          1.103
LGA    G    35_B      R      25          1.476
LGA    E    36_B      T      26          5.312
LGA    V    37_B      D      27          5.421
LGA    K    38_B      E      28           #
LGA    D    39_B      -       -           -
LGA    S    40_B      -       -           -
LGA    P    41_B      -       -           -
LGA    N    42_B      -       -           -
LGA    T    43_B      -       -           -
LGA    K    44_B      -       -           -
LGA    T    45_B      -       -           -
LGA    T    46_B      P      29          0.759
LGA    G    47_B      G      30          0.493
LGA    I    48_B      V      31          0.207
LGA    F    49_B      F      32          0.249
LGA    I    50_B      I      33          0.748
LGA    K    51_B      L      34          1.591
LGA    G    52_B      D      35          2.428
LGA    I    53_B      L      36          1.066
LGA    V    54_B      L      37          1.213
LGA    P    55_B      E      38          0.937
LGA    D    56_B      G      39          0.885
LGA    S    57_B      G      40          0.938
LGA    P    58_B      L      41          0.872
LGA    A    59_B      A      42          0.484
LGA    H    60_B      A      43          0.426
LGA    L    61_B      Q      44          0.639
LGA    C    62_B      D      45          0.867
LGA    G    63_B      G      46          0.672
LGA    R    64_B      R      47          0.513
LGA    L    65_B      L      48          0.246
LGA    K    66_B      S      49          0.253
LGA    V    67_B      S      50          1.297
LGA    G    68_B      N      51          1.210
LGA    D    69_B      D      52          0.611
LGA    R    70_B      R      53          0.433
LGA    I    71_B      V      54          0.122
LGA    L    72_B      L      55          0.440
LGA    S    73_B      A      56          0.661
LGA    L    74_B      I      57          0.830
LGA    N    75_B      N      58          0.771
LGA    G    76_B      G      59          0.844
LGA    K    77_B      H      60          1.149
LGA    D    78_B      D      61          0.828
LGA    V    79_B      L      62          0.805
LGA    R    80_B      K      63          1.412
LGA    N    81_B      Y      64          1.541
LGA    S    82_B      G      65          1.647
LGA    T    83_B      T      66          2.345
LGA    E    84_B      P      67          1.611
LGA    Q    85_B      E      68          1.060
LGA    A    86_B      L      69          1.428
LGA    V    87_B      A      70          1.273
LGA    I    88_B      A      71          0.242
LGA    D    89_B      Q      72          0.555
LGA    L    90_B      I      73          0.750
LGA    I    91_B      I      74          0.665
LGA    K    92_B      Q      75          0.399
LGA    E    93_B      A      76          0.515
LGA    A    94_B      S      77          0.338
LGA    D    95_B      G      78          1.706
LGA    F    96_B      E      79          1.460
LGA    K    97_B      R      80          1.789
LGA    I    98_B      V      81          0.921
LGA    E    99_B      N      82          0.734
LGA    L   100_B      L      83          0.576
LGA    E   101_B      T      84          0.596
LGA    I   102_B      I      85          0.321
LGA    Q   103_B      A      86          0.605
LGA    T   104_B      R      87          0.895
LGA    F   105_B      P      88          3.736
LGA    -       -      G      89           -
LGA    -       -      K      90           -
LGA    D   106_B      P      91          4.100
LGA    -       -      E      92           -
LGA    -       -      I      93           -
LGA    -       -      E      94           -
LGA    -       -      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   95    5.0     86    1.72    29.07     86.214     4.728

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.922016 * X  +  -0.268271 * Y  +   0.279137 * Z  +  17.872765
  Y_new =   0.380228 * X  +   0.763221 * Y  +  -0.522418 * Z  +  14.228841
  Z_new =  -0.072893 * X  +   0.587813 * Y  +   0.805706 * Z  + -28.439514 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.630293   -2.511300  [ DEG:    36.1131   -143.8869 ]
  Theta =   0.072958    3.068635  [ DEG:     4.1802    175.8198 ]
  Phi   =   0.391139   -2.750453  [ DEG:    22.4106   -157.5894 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ihj_B                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ihj_B.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   95   5.0   86   1.72   29.07  86.214
REMARK  ---------------------------------------------------------- 
MOLECULE 1ihj_B
HEADER    SIGNALING PROTEIN                       19-APR-01   1IHJ              
TITLE     CRYSTAL STRUCTURE OF THE N-TERMINAL PDZ DOMAIN OF INAD IN             
TITLE    2 COMPLEX WITH A NORPA C-TERMINAL PEPTIDE                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: INAD;                                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: PDZ1 DOMAIN;                                               
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: PHOSPHOLIPASE C;                                           
COMPND   8 CHAIN: C, D;                                                         
COMPND   9 FRAGMENT: C-TERMINUS;                                                
COMPND  10 SYNONYM: NORPA;                                                      
COMPND  11 EC: 3.1.4.3;                                                         
COMPND  12 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DROSOPHILA MELANOGASTER;                        
SOURCE   3 ORGANISM_COMMON: FRUIT FLY;                                          
SOURCE   4 GENE: INAD;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 SYNTHETIC: YES;                                                      
SOURCE  10 OTHER_DETAILS: THIS PEPTIDE WAS CHEMICALLY SYNTHESIZED. IT           
SOURCE  11 CONSISTS OF THE FINAL SEVEN RESIDUES OF PHOSPHOLIPASE C              
SOURCE  12 (GKTEFCA).                                                           
KEYWDS    INTERMOLECULAR DISULFIDE BOND, PDZ DOMAIN                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.KIMPLE,D.P.SIDEROVSKI,J.SONDEK                                    
REVDAT   1   22-AUG-01 1IHJ    0                                                
JRNL        AUTH   M.E.KIMPLE,D.P.SIDEROVSKI,J.SONDEK                           
JRNL        TITL   FUNCTIONAL RELEVANCE OF THE DISULFIDE-LINKED                 
JRNL        TITL 2 COMPLEX OF THE N-TERMINAL PDZ DOMAIN OF INAD WITH            
JRNL        TITL 3 NORPA.                                                       
JRNL        REF    EMBO J.                       V.  20  4414 2001              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1IHJ A   11   107  UNP    Q24008   INAD_DROME      11    107             
DBREF  1IHJ B   11   107  UNP    Q24008   INAD_DROME      11    107             
DBREF  1IHJ C    1     7  GB     85099    A31225        1089   1095             
DBREF  1IHJ D    1     7  GB     85099    A31225        1089   1095             
SEQRES   1 A   98  MET ALA GLY GLU LEU ILE HIS MET VAL THR LEU ASP LYS          
SEQRES   2 A   98  THR GLY LYS LYS SER PHE GLY ILE CYS ILE VAL ARG GLY          
SEQRES   3 A   98  GLU VAL LYS ASP SER PRO ASN THR LYS THR THR GLY ILE          
SEQRES   4 A   98  PHE ILE LYS GLY ILE VAL PRO ASP SER PRO ALA HIS LEU          
SEQRES   5 A   98  CYS GLY ARG LEU LYS VAL GLY ASP ARG ILE LEU SER LEU          
SEQRES   6 A   98  ASN GLY LYS ASP VAL ARG ASN SER THR GLU GLN ALA VAL          
SEQRES   7 A   98  ILE ASP LEU ILE LYS GLU ALA ASP PHE LYS ILE GLU LEU          
SEQRES   8 A   98  GLU ILE GLN THR PHE ASP LYS                                  
SEQRES   1 B   98  MET ALA GLY GLU LEU ILE HIS MET VAL THR LEU ASP LYS          
SEQRES   2 B   98  THR GLY LYS LYS SER PHE GLY ILE CYS ILE VAL ARG GLY          
SEQRES   3 B   98  GLU VAL LYS ASP SER PRO ASN THR LYS THR THR GLY ILE          
SEQRES   4 B   98  PHE ILE LYS GLY ILE VAL PRO ASP SER PRO ALA HIS LEU          
SEQRES   5 B   98  CYS GLY ARG LEU LYS VAL GLY ASP ARG ILE LEU SER LEU          
SEQRES   6 B   98  ASN GLY LYS ASP VAL ARG ASN SER THR GLU GLN ALA VAL          
SEQRES   7 B   98  ILE ASP LEU ILE LYS GLU ALA ASP PHE LYS ILE GLU LEU          
SEQRES   8 B   98  GLU ILE GLN THR PHE ASP LYS                                  
SEQRES   1 C    7  GLY LYS THR GLU PHE CYS ALA                                  
SEQRES   1 D    7  GLY LYS THR GLU PHE CYS ALA                                  
FORMUL   5  HOH   *172(H2 O)                                                    
CRYST1   42.170   44.150   44.460 106.55 100.61 118.25 P 1           2          
ATOM    715  N   GLY B  12      21.202   8.418  22.101  1.00 41.18           N  
ATOM    716  CA  GLY B  12      19.882   9.091  22.237  1.00 38.01           C  
ATOM    717  C   GLY B  12      19.454   9.783  20.957  1.00 35.77           C  
ATOM    718  O   GLY B  12      19.030   9.136  19.999  1.00 37.68           O  
ATOM    719  N   GLU B  13      19.572  11.103  20.937  1.00 33.16           N  
ATOM    720  CA  GLU B  13      19.190  11.880  19.768  1.00 29.03           C  
ATOM    721  C   GLU B  13      20.356  12.127  18.824  1.00 25.26           C  
ATOM    722  O   GLU B  13      21.523  11.952  19.183  1.00 21.19           O  
ATOM    723  CB  GLU B  13      18.605  13.224  20.194  1.00 31.29           C  
ATOM    724  CG  GLU B  13      17.311  13.125  20.965  1.00 41.35           C  
ATOM    725  CD  GLU B  13      16.716  14.487  21.243  1.00 45.87           C  
ATOM    726  OE1 GLU B  13      17.365  15.283  21.956  1.00 48.62           O  
ATOM    727  OE2 GLU B  13      15.604  14.763  20.743  1.00 49.26           O  
ATOM    728  N   LEU B  14      20.023  12.552  17.612  1.00 21.48           N  
ATOM    729  CA  LEU B  14      21.033  12.834  16.609  1.00 19.08           C  
ATOM    730  C   LEU B  14      20.512  13.847  15.601  1.00 18.50           C  
ATOM    731  O   LEU B  14      19.341  13.808  15.224  1.00 17.43           O  
ATOM    732  CB  LEU B  14      21.413  11.556  15.869  1.00 21.39           C  
ATOM    733  CG  LEU B  14      22.597  11.703  14.912  1.00 23.76           C  
ATOM    734  CD1 LEU B  14      23.874  11.843  15.730  1.00 27.00           C  
ATOM    735  CD2 LEU B  14      22.681  10.497  13.993  1.00 27.03           C  
ATOM    736  N   ILE B  15      21.378  14.763  15.185  1.00 16.49           N  
ATOM    737  CA  ILE B  15      21.004  15.746  14.175  1.00 14.99           C  
ATOM    738  C   ILE B  15      21.681  15.251  12.907  1.00 17.09           C  
ATOM    739  O   ILE B  15      22.883  14.992  12.905  1.00 16.73           O  
ATOM    740  CB  ILE B  15      21.535  17.165  14.509  1.00 16.30           C  
ATOM    741  CG1 ILE B  15      20.882  17.673  15.795  1.00 20.80           C  
ATOM    742  CG2 ILE B  15      21.235  18.134  13.352  1.00 19.63           C  
ATOM    743  CD1 ILE B  15      21.450  19.004  16.289  1.00 20.78           C  
ATOM    744  N   HIS B  16      20.900  15.077  11.846  1.00 15.23           N  
ATOM    745  CA  HIS B  16      21.442  14.621  10.582  1.00 14.89           C  
ATOM    746  C   HIS B  16      20.753  15.344   9.441  1.00 16.56           C  
ATOM    747  O   HIS B  16      19.781  16.061   9.664  1.00 15.60           O  
ATOM    748  CB  HIS B  16      21.303  13.100  10.444  1.00 15.29           C  
ATOM    749  CG  HIS B  16      19.890  12.611  10.444  1.00 18.06           C  
ATOM    750  ND1 HIS B  16      19.336  11.954   9.368  1.00 22.45           N  
ATOM    751  CD2 HIS B  16      18.923  12.663  11.392  1.00 20.71           C  
ATOM    752  CE1 HIS B  16      18.089  11.622   9.652  1.00 22.22           C  
ATOM    753  NE2 HIS B  16      17.814  12.041  10.873  1.00 22.31           N  
ATOM    754  N   MET B  17      21.270  15.172   8.227  1.00 14.87           N  
ATOM    755  CA  MET B  17      20.705  15.847   7.063  1.00 16.62           C  
ATOM    756  C   MET B  17      19.957  14.886   6.157  1.00 18.65           C  
ATOM    757  O   MET B  17      20.417  13.773   5.892  1.00 18.22           O  
ATOM    758  CB  MET B  17      21.811  16.533   6.248  1.00 17.48           C  
ATOM    759  CG  MET B  17      22.547  17.643   6.969  1.00 21.72           C  
ATOM    760  SD  MET B  17      21.471  18.991   7.465  1.00 24.06           S  
ATOM    761  CE  MET B  17      20.999  19.661   5.876  1.00 27.91           C  
ATOM    762  N   VAL B  18      18.791  15.323   5.697  1.00 18.33           N  
ATOM    763  CA  VAL B  18      17.983  14.518   4.799  1.00 20.10           C  
ATOM    764  C   VAL B  18      17.543  15.382   3.631  1.00 19.21           C  
ATOM    765  O   VAL B  18      16.951  16.439   3.820  1.00 17.81           O  
ATOM    766  CB  VAL B  18      16.718  13.964   5.490  1.00 20.22           C  
ATOM    767  CG1 VAL B  18      15.824  13.288   4.458  1.00 23.94           C  
ATOM    768  CG2 VAL B  18      17.105  12.958   6.571  1.00 20.20           C  
ATOM    769  N   THR B  19      17.849  14.935   2.422  1.00 21.46           N  
ATOM    770  CA  THR B  19      17.440  15.671   1.239  1.00 22.86           C  
ATOM    771  C   THR B  19      16.292  14.911   0.595  1.00 21.71           C  
ATOM    772  O   THR B  19      16.396  13.710   0.350  1.00 22.92           O  
ATOM    773  CB  THR B  19      18.589  15.792   0.219  1.00 25.52           C  
ATOM    774  OG1 THR B  19      19.611  16.645   0.750  1.00 29.18           O  
ATOM    775  CG2 THR B  19      18.076  16.371  -1.097  1.00 24.32           C  
ATOM    776  N   LEU B  20      15.189  15.608   0.357  1.00 21.87           N  
ATOM    777  CA  LEU B  20      14.036  15.003  -0.289  1.00 20.98           C  
ATOM    778  C   LEU B  20      13.944  15.597  -1.688  1.00 22.11           C  
ATOM    779  O   LEU B  20      14.040  16.811  -1.868  1.00 20.92           O  
ATOM    780  CB  LEU B  20      12.749  15.286   0.491  1.00 19.25           C  
ATOM    781  CG  LEU B  20      12.613  14.607   1.859  1.00 21.16           C  
ATOM    782  CD1 LEU B  20      11.250  14.912   2.442  1.00 19.80           C  
ATOM    783  CD2 LEU B  20      12.800  13.098   1.710  1.00 20.88           C  
ATOM    784  N   ASP B  21      13.767  14.719  -2.664  1.00 20.47           N  
ATOM    785  CA  ASP B  21      13.679  15.091  -4.070  1.00 20.88           C  
ATOM    786  C   ASP B  21      12.315  14.613  -4.563  1.00 21.16           C  
ATOM    787  O   ASP B  21      12.037  13.415  -4.546  1.00 20.06           O  
ATOM    788  CB  ASP B  21      14.802  14.381  -4.828  1.00 23.74           C  
ATOM    789  CG  ASP B  21      14.907  14.822  -6.265  1.00 28.18           C  
ATOM    790  OD1 ASP B  21      13.857  14.958  -6.920  1.00 21.93           O  
ATOM    791  OD2 ASP B  21      16.047  15.022  -6.736  1.00 35.94           O  
ATOM    792  N   LYS B  22      11.455  15.534  -4.994  1.00 17.29           N  
ATOM    793  CA  LYS B  22      10.135  15.118  -5.449  1.00 18.02           C  
ATOM    794  C   LYS B  22      10.026  15.014  -6.963  1.00 21.13           C  
ATOM    795  O   LYS B  22       8.949  15.199  -7.527  1.00 19.47           O  
ATOM    796  CB  LYS B  22       9.049  16.052  -4.906  1.00 22.05           C  
ATOM    797  CG  LYS B  22       9.094  17.473  -5.438  1.00 24.03           C  
ATOM    798  CD  LYS B  22       7.926  18.278  -4.900  1.00 26.87           C  
ATOM    799  CE  LYS B  22       7.919  19.692  -5.454  1.00 28.24           C  
ATOM    800  NZ  LYS B  22       6.832  20.506  -4.835  1.00 33.85           N  
ATOM    801  N   THR B  23      11.142  14.711  -7.616  1.00 22.56           N  
ATOM    802  CA  THR B  23      11.138  14.558  -9.068  1.00 25.34           C  
ATOM    803  C   THR B  23      10.100  13.489  -9.405  1.00 26.07           C  
ATOM    804  O   THR B  23      10.138  12.389  -8.857  1.00 28.00           O  
ATOM    805  CB  THR B  23      12.525  14.107  -9.594  1.00 27.31           C  
ATOM    806  OG1 THR B  23      13.485  15.149  -9.378  1.00 24.33           O  
ATOM    807  CG2 THR B  23      12.458  13.790 -11.093  1.00 25.40           C  
ATOM    808  N   GLY B  24       9.163  13.823 -10.286  1.00 29.73           N  
ATOM    809  CA  GLY B  24       8.140  12.868 -10.675  1.00 30.82           C  
ATOM    810  C   GLY B  24       7.084  12.605  -9.617  1.00 33.78           C  
ATOM    811  O   GLY B  24       6.331  11.637  -9.716  1.00 34.98           O  
ATOM    812  N   LYS B  25       7.027  13.460  -8.601  1.00 33.59           N  
ATOM    813  CA  LYS B  25       6.049  13.322  -7.524  1.00 32.68           C  
ATOM    814  C   LYS B  25       5.252  14.614  -7.369  1.00 31.82           C  
ATOM    815  O   LYS B  25       5.699  15.678  -7.794  1.00 31.80           O  
ATOM    816  CB  LYS B  25       6.753  12.985  -6.209  1.00 32.07           C  
ATOM    817  CG  LYS B  25       7.318  11.572  -6.145  1.00 33.59           C  
ATOM    818  CD  LYS B  25       6.205  10.541  -6.052  1.00 36.55           C  
ATOM    819  CE  LYS B  25       6.758   9.150  -5.817  1.00 36.99           C  
ATOM    820  NZ  LYS B  25       5.663   8.157  -5.646  1.00 39.61           N  
ATOM    821  N   LYS B  26       4.079  14.517  -6.748  1.00 31.80           N  
ATOM    822  CA  LYS B  26       3.207  15.675  -6.554  1.00 33.54           C  
ATOM    823  C   LYS B  26       3.578  16.532  -5.344  1.00 32.10           C  
ATOM    824  O   LYS B  26       3.229  17.713  -5.277  1.00 32.50           O  
ATOM    825  CB  LYS B  26       1.748  15.215  -6.434  1.00 36.86           C  
ATOM    826  CG  LYS B  26       1.444  14.402  -5.184  1.00 42.90           C  
ATOM    827  CD  LYS B  26       0.095  13.687  -5.284  1.00 47.87           C  
ATOM    828  CE  LYS B  26      -1.060  14.659  -5.510  1.00 50.01           C  
ATOM    829  NZ  LYS B  26      -1.232  15.607  -4.375  1.00 53.27           N  
ATOM    830  N   SER B  27       4.283  15.941  -4.386  1.00 28.48           N  
ATOM    831  CA  SER B  27       4.688  16.672  -3.190  1.00 26.93           C  
ATOM    832  C   SER B  27       5.773  15.898  -2.459  1.00 23.49           C  
ATOM    833  O   SER B  27       6.109  14.777  -2.840  1.00 21.51           O  
ATOM    834  CB  SER B  27       3.496  16.865  -2.257  1.00 28.61           C  
ATOM    835  OG  SER B  27       3.105  15.627  -1.694  1.00 34.48           O  
ATOM    836  N   PHE B  28       6.321  16.492  -1.404  1.00 20.81           N  
ATOM    837  CA  PHE B  28       7.364  15.816  -0.651  1.00 18.61           C  
ATOM    838  C   PHE B  28       6.773  14.737   0.252  1.00 18.00           C  
ATOM    839  O   PHE B  28       7.408  13.711   0.496  1.00 20.46           O  
ATOM    840  CB  PHE B  28       8.179  16.831   0.152  1.00 18.32           C  
ATOM    841  CG  PHE B  28       8.988  17.757  -0.710  1.00 16.19           C  
ATOM    842  CD1 PHE B  28       8.549  19.051  -0.964  1.00 17.25           C  
ATOM    843  CD2 PHE B  28      10.162  17.312  -1.315  1.00 16.35           C  
ATOM    844  CE1 PHE B  28       9.266  19.894  -1.813  1.00 19.01           C  
ATOM    845  CE2 PHE B  28      10.890  18.154  -2.170  1.00 18.64           C  
ATOM    846  CZ  PHE B  28      10.439  19.441  -2.416  1.00 18.42           C  
ATOM    847  N   GLY B  29       5.560  14.970   0.740  1.00 18.85           N  
ATOM    848  CA  GLY B  29       4.901  13.977   1.572  1.00 20.66           C  
ATOM    849  C   GLY B  29       5.012  14.121   3.079  1.00 19.42           C  
ATOM    850  O   GLY B  29       4.946  13.127   3.802  1.00 17.12           O  
ATOM    851  N   ILE B  30       5.190  15.339   3.573  1.00 18.58           N  
ATOM    852  CA  ILE B  30       5.268  15.513   5.015  1.00 19.17           C  
ATOM    853  C   ILE B  30       4.207  16.466   5.533  1.00 19.80           C  
ATOM    854  O   ILE B  30       3.860  17.451   4.879  1.00 21.00           O  
ATOM    855  CB  ILE B  30       6.657  16.040   5.479  1.00 22.16           C  
ATOM    856  CG1 ILE B  30       6.951  17.404   4.858  1.00 21.20           C  
ATOM    857  CG2 ILE B  30       7.738  15.035   5.118  1.00 21.97           C  
ATOM    858  CD1 ILE B  30       8.148  18.107   5.483  1.00 25.90           C  
ATOM    859  N   CYS B  31       3.673  16.152   6.703  1.00 18.30           N  
ATOM    860  CA  CYS B  31       2.693  17.015   7.339  1.00 18.24           C  
ATOM    861  C   CYS B  31       3.365  17.399   8.650  1.00 18.48           C  
ATOM    862  O   CYS B  31       3.917  16.545   9.348  1.00 18.78           O  
ATOM    863  CB  CYS B  31       1.387  16.279   7.590  1.00 23.28           C  
ATOM    864  SG  CYS B  31       0.518  15.734   6.080  1.00 28.08           S  
ATOM    865  N   ILE B  32       3.321  18.682   8.975  1.00 16.58           N  
ATOM    866  CA  ILE B  32       3.995  19.169  10.169  1.00 18.37           C  
ATOM    867  C   ILE B  32       3.094  19.857  11.178  1.00 19.18           C  
ATOM    868  O   ILE B  32       1.968  20.246  10.872  1.00 19.56           O  
ATOM    869  CB  ILE B  32       5.106  20.154   9.776  1.00 15.35           C  
ATOM    870  CG1 ILE B  32       4.485  21.380   9.082  1.00 18.59           C  
ATOM    871  CG2 ILE B  32       6.096  19.478   8.837  1.00 17.99           C  
ATOM    872  CD1 ILE B  32       5.485  22.445   8.704  1.00 16.93           C  
ATOM    873  N   VAL B  33       3.604  19.992  12.396  1.00 18.93           N  
ATOM    874  CA  VAL B  33       2.878  20.660  13.466  1.00 19.22           C  
ATOM    875  C   VAL B  33       3.892  21.321  14.376  1.00 20.35           C  
ATOM    876  O   VAL B  33       5.049  20.911  14.429  1.00 15.75           O  
ATOM    877  CB  VAL B  33       2.050  19.679  14.335  1.00 21.37           C  
ATOM    878  CG1 VAL B  33       1.001  18.979  13.489  1.00 26.48           C  
ATOM    879  CG2 VAL B  33       2.977  18.673  15.016  1.00 21.37           C  
ATOM    880  N   ARG B  34       3.455  22.354  15.081  1.00 21.18           N  
ATOM    881  CA  ARG B  34       4.330  23.031  16.023  1.00 24.58           C  
ATOM    882  C   ARG B  34       4.103  22.268  17.324  1.00 24.64           C  
ATOM    883  O   ARG B  34       2.966  21.953  17.673  1.00 21.51           O  
ATOM    884  CB  ARG B  34       3.918  24.499  16.173  1.00 29.78           C  
ATOM    885  CG  ARG B  34       4.957  25.366  16.863  1.00 39.78           C  
ATOM    886  CD  ARG B  34       4.760  26.839  16.525  1.00 41.05           C  
ATOM    887  NE  ARG B  34       5.883  27.655  16.982  1.00 48.23           N  
ATOM    888  CZ  ARG B  34       6.114  27.970  18.252  1.00 51.91           C  
ATOM    889  NH1 ARG B  34       5.296  27.542  19.204  1.00 53.71           N  
ATOM    890  NH2 ARG B  34       7.169  28.707  18.573  1.00 55.04           N  
ATOM    891  N   GLY B  35       5.184  21.939  18.021  1.00 25.59           N  
ATOM    892  CA  GLY B  35       5.038  21.203  19.260  1.00 29.33           C  
ATOM    893  C   GLY B  35       6.147  21.522  20.232  1.00 30.77           C  
ATOM    894  O   GLY B  35       6.978  22.388  19.977  1.00 30.07           O  
ATOM    895  N   GLU B  36       6.158  20.823  21.360  1.00 36.31           N  
ATOM    896  CA  GLU B  36       7.186  21.048  22.360  1.00 37.34           C  
ATOM    897  C   GLU B  36       7.608  19.747  23.012  1.00 36.60           C  
ATOM    898  O   GLU B  36       6.919  18.729  22.919  1.00 35.32           O  
ATOM    899  CB  GLU B  36       6.690  22.021  23.431  1.00 40.28           C  
ATOM    900  CG  GLU B  36       5.372  21.628  24.074  1.00 44.80           C  
ATOM    901  CD  GLU B  36       5.086  22.415  25.340  1.00 47.87           C  
ATOM    902  OE1 GLU B  36       5.238  23.655  25.323  1.00 50.53           O  
ATOM    903  OE2 GLU B  36       4.703  21.790  26.351  1.00 49.08           O  
ATOM    904  N   VAL B  37       8.755  19.792  23.671  1.00 35.84           N  
ATOM    905  CA  VAL B  37       9.291  18.632  24.356  1.00 35.44           C  
ATOM    906  C   VAL B  37      10.286  19.134  25.386  1.00 36.12           C  
ATOM    907  O   VAL B  37      10.919  20.171  25.190  1.00 33.45           O  
ATOM    908  CB  VAL B  37       9.980  17.708  23.362  1.00 35.17           C  
ATOM    909  N   LYS B  38      10.409  18.413  26.492  1.00 37.72           N  
ATOM    910  CA  LYS B  38      11.355  18.809  27.519  1.00 39.96           C  
ATOM    911  C   LYS B  38      12.753  18.440  27.050  1.00 40.44           C  
ATOM    912  O   LYS B  38      13.055  17.268  26.830  1.00 42.04           O  
ATOM    913  CB  LYS B  38      11.043  18.110  28.843  1.00 41.55           C  
ATOM    914  CG  LYS B  38       9.763  18.587  29.506  1.00 45.36           C  
ATOM    915  CD  LYS B  38       9.703  18.136  30.958  1.00 49.10           C  
ATOM    916  CE  LYS B  38       8.509  18.743  31.677  1.00 51.56           C  
ATOM    917  NZ  LYS B  38       8.524  18.435  33.135  1.00 53.04           N  
ATOM    918  N   ASP B  39      13.594  19.451  26.875  1.00 41.57           N  
ATOM    919  CA  ASP B  39      14.966  19.242  26.440  1.00 43.82           C  
ATOM    920  C   ASP B  39      15.864  19.164  27.669  1.00 43.65           C  
ATOM    921  O   ASP B  39      17.089  19.083  27.561  1.00 45.19           O  
ATOM    922  CB  ASP B  39      15.402  20.387  25.523  1.00 45.70           C  
ATOM    923  CG  ASP B  39      15.197  21.748  26.154  1.00 48.78           C  
ATOM    924  OD1 ASP B  39      14.112  21.980  26.730  1.00 48.52           O  
ATOM    925  OD2 ASP B  39      16.115  22.589  26.064  1.00 50.44           O  
ATOM    926  N   SER B  40      15.232  19.194  28.838  1.00 41.43           N  
ATOM    927  CA  SER B  40      15.931  19.107  30.113  1.00 40.54           C  
ATOM    928  C   SER B  40      14.877  18.947  31.207  1.00 39.41           C  
ATOM    929  O   SER B  40      13.682  19.127  30.963  1.00 36.82           O  
ATOM    930  CB  SER B  40      16.770  20.364  30.362  1.00 41.76           C  
ATOM    931  OG  SER B  40      16.003  21.390  30.960  1.00 46.56           O  
ATOM    932  N   PRO B  41      15.302  18.614  32.433  1.00 38.70           N  
ATOM    933  CA  PRO B  41      14.326  18.444  33.511  1.00 35.80           C  
ATOM    934  C   PRO B  41      13.478  19.672  33.840  1.00 33.69           C  
ATOM    935  O   PRO B  41      12.314  19.537  34.218  1.00 33.18           O  
ATOM    936  CB  PRO B  41      15.194  18.004  34.688  1.00 39.49           C  
ATOM    937  CG  PRO B  41      16.498  18.702  34.418  1.00 40.69           C  
ATOM    938  CD  PRO B  41      16.677  18.457  32.939  1.00 40.09           C  
ATOM    939  N   ASN B  42      14.046  20.862  33.680  1.00 30.71           N  
ATOM    940  CA  ASN B  42      13.318  22.081  34.012  1.00 30.12           C  
ATOM    941  C   ASN B  42      13.082  23.042  32.858  1.00 27.53           C  
ATOM    942  O   ASN B  42      12.820  24.222  33.078  1.00 23.27           O  
ATOM    943  CB  ASN B  42      14.042  22.820  35.137  1.00 33.80           C  
ATOM    944  CG  ASN B  42      14.230  21.960  36.364  1.00 36.93           C  
ATOM    945  OD1 ASN B  42      13.265  21.435  36.920  1.00 38.54           O  
ATOM    946  ND2 ASN B  42      15.480  21.809  36.795  1.00 42.44           N  
ATOM    947  N   THR B  43      13.180  22.556  31.628  1.00 27.36           N  
ATOM    948  CA  THR B  43      12.951  23.430  30.485  1.00 28.86           C  
ATOM    949  C   THR B  43      12.264  22.690  29.351  1.00 28.42           C  
ATOM    950  O   THR B  43      12.260  21.460  29.302  1.00 28.03           O  
ATOM    951  CB  THR B  43      14.263  24.019  29.927  1.00 30.55           C  
ATOM    952  OG1 THR B  43      15.058  22.968  29.365  1.00 35.90           O  
ATOM    953  CG2 THR B  43      15.048  24.721  31.024  1.00 32.50           C  
ATOM    954  N   LYS B  44      11.673  23.457  28.445  1.00 29.22           N  
ATOM    955  CA  LYS B  44      10.999  22.896  27.285  1.00 31.74           C  
ATOM    956  C   LYS B  44      11.423  23.678  26.058  1.00 33.64           C  
ATOM    957  O   LYS B  44      11.895  24.809  26.161  1.00 31.42           O  
ATOM    958  CB  LYS B  44       9.480  22.988  27.434  1.00 33.26           C  
ATOM    959  CG  LYS B  44       8.869  21.952  28.354  1.00 37.59           C  
ATOM    960  CD  LYS B  44       7.354  21.969  28.242  1.00 38.04           C  
ATOM    961  CE  LYS B  44       6.732  20.802  28.983  1.00 41.94           C  
ATOM    962  NZ  LYS B  44       5.244  20.813  28.869  1.00 45.75           N  
ATOM    963  N   THR B  45      11.267  23.062  24.894  1.00 33.14           N  
ATOM    964  CA  THR B  45      11.608  23.709  23.640  1.00 36.03           C  
ATOM    965  C   THR B  45      10.454  23.428  22.685  1.00 35.75           C  
ATOM    966  O   THR B  45       9.972  22.298  22.604  1.00 34.33           O  
ATOM    967  CB  THR B  45      12.929  23.157  23.056  1.00 38.11           C  
ATOM    968  OG1 THR B  45      13.286  23.913  21.893  1.00 41.48           O  
ATOM    969  CG2 THR B  45      12.786  21.685  22.680  1.00 38.31           C  
ATOM    970  N   THR B  46       9.991  24.465  21.995  1.00 35.53           N  
ATOM    971  CA  THR B  46       8.888  24.326  21.053  1.00 34.31           C  
ATOM    972  C   THR B  46       9.422  24.454  19.631  1.00 33.33           C  
ATOM    973  O   THR B  46      10.054  25.450  19.294  1.00 36.24           O  
ATOM    974  CB  THR B  46       7.815  25.414  21.292  1.00 37.28           C  
ATOM    975  OG1 THR B  46       7.363  25.353  22.650  1.00 40.63           O  
ATOM    976  CG2 THR B  46       6.626  25.209  20.368  1.00 36.65           C  
ATOM    977  N   GLY B  47       9.167  23.447  18.801  1.00 28.76           N  
ATOM    978  CA  GLY B  47       9.651  23.488  17.433  1.00 21.69           C  
ATOM    979  C   GLY B  47       8.697  22.868  16.427  1.00 18.25           C  
ATOM    980  O   GLY B  47       7.540  22.602  16.737  1.00 19.67           O  
ATOM    981  N   ILE B  48       9.201  22.647  15.215  1.00 18.27           N  
ATOM    982  CA  ILE B  48       8.427  22.057  14.124  1.00 17.81           C  
ATOM    983  C   ILE B  48       8.685  20.554  14.072  1.00 16.83           C  
ATOM    984  O   ILE B  48       9.828  20.119  13.956  1.00 19.68           O  
ATOM    985  CB  ILE B  48       8.836  22.679  12.772  1.00 18.21           C  
ATOM    986  CG1 ILE B  48       8.539  24.183  12.781  1.00 16.82           C  
ATOM    987  CG2 ILE B  48       8.083  21.999  11.625  1.00 18.65           C  
ATOM    988  CD1 ILE B  48       7.073  24.518  12.874  1.00 21.03           C  
ATOM    989  N   PHE B  49       7.622  19.764  14.145  1.00 16.18           N  
ATOM    990  CA  PHE B  49       7.770  18.319  14.127  1.00 15.10           C  
ATOM    991  C   PHE B  49       7.025  17.682  12.975  1.00 16.71           C  
ATOM    992  O   PHE B  49       6.031  18.219  12.495  1.00 17.17           O  
ATOM    993  CB  PHE B  49       7.246  17.716  15.427  1.00 17.54           C  
ATOM    994  CG  PHE B  49       8.022  18.123  16.644  1.00 18.64           C  
ATOM    995  CD1 PHE B  49       7.853  19.385  17.206  1.00 20.81           C  
ATOM    996  CD2 PHE B  49       8.923  17.240  17.231  1.00 20.58           C  
ATOM    997  CE1 PHE B  49       8.570  19.763  18.335  1.00 23.63           C  
ATOM    998  CE2 PHE B  49       9.647  17.608  18.366  1.00 25.37           C  
ATOM    999  CZ  PHE B  49       9.468  18.873  18.917  1.00 21.55           C  
ATOM   1000  N   ILE B  50       7.512  16.528  12.539  1.00 15.50           N  
ATOM   1001  CA  ILE B  50       6.836  15.803  11.480  1.00 16.84           C  
ATOM   1002  C   ILE B  50       5.696  15.051  12.169  1.00 18.22           C  
ATOM   1003  O   ILE B  50       5.933  14.227  13.054  1.00 20.21           O  
ATOM   1004  CB  ILE B  50       7.785  14.804  10.791  1.00 16.56           C  
ATOM   1005  CG1 ILE B  50       8.885  15.572  10.052  1.00 19.70           C  
ATOM   1006  CG2 ILE B  50       6.994  13.903   9.837  1.00 17.94           C  
ATOM   1007  CD1 ILE B  50       9.887  14.684   9.323  1.00 21.65           C  
ATOM   1008  N   LYS B  51       4.461  15.351  11.778  1.00 16.57           N  
ATOM   1009  CA  LYS B  51       3.292  14.710  12.381  1.00 18.28           C  
ATOM   1010  C   LYS B  51       2.792  13.535  11.551  1.00 20.49           C  
ATOM   1011  O   LYS B  51       2.103  12.645  12.056  1.00 18.75           O  
ATOM   1012  CB  LYS B  51       2.160  15.726  12.547  1.00 22.98           C  
ATOM   1013  CG  LYS B  51       1.063  15.275  13.504  1.00 27.57           C  
ATOM   1014  CD  LYS B  51       1.626  15.048  14.903  1.00 34.68           C  
ATOM   1015  CE  LYS B  51       0.550  14.574  15.876  1.00 38.53           C  
ATOM   1016  NZ  LYS B  51       1.104  14.365  17.248  1.00 39.98           N  
ATOM   1017  N   GLY B  52       3.127  13.535  10.268  1.00 20.02           N  
ATOM   1018  CA  GLY B  52       2.685  12.448   9.419  1.00 19.97           C  
ATOM   1019  C   GLY B  52       3.470  12.406   8.132  1.00 20.13           C  
ATOM   1020  O   GLY B  52       4.017  13.422   7.700  1.00 18.09           O  
ATOM   1021  N   ILE B  53       3.528  11.225   7.529  1.00 19.27           N  
ATOM   1022  CA  ILE B  53       4.232  11.020   6.270  1.00 18.30           C  
ATOM   1023  C   ILE B  53       3.258  10.370   5.286  1.00 20.38           C  
ATOM   1024  O   ILE B  53       2.563   9.421   5.635  1.00 21.35           O  
ATOM   1025  CB  ILE B  53       5.456  10.104   6.477  1.00 20.43           C  
ATOM   1026  CG1 ILE B  53       6.522  10.857   7.283  1.00 20.36           C  
ATOM   1027  CG2 ILE B  53       6.013   9.639   5.134  1.00 21.65           C  
ATOM   1028  CD1 ILE B  53       7.727  10.020   7.644  1.00 27.59           C  
ATOM   1029  N   VAL B  54       3.203  10.889   4.063  1.00 18.61           N  
ATOM   1030  CA  VAL B  54       2.296  10.344   3.050  1.00 18.93           C  
ATOM   1031  C   VAL B  54       2.865   9.065   2.437  1.00 18.08           C  
ATOM   1032  O   VAL B  54       3.989   9.047   1.945  1.00 18.41           O  
ATOM   1033  CB  VAL B  54       2.055  11.363   1.912  1.00 21.36           C  
ATOM   1034  CG1 VAL B  54       1.102  10.772   0.873  1.00 22.71           C  
ATOM   1035  CG2 VAL B  54       1.498  12.659   2.484  1.00 18.66           C  
ATOM   1036  N   PRO B  55       2.086   7.974   2.452  1.00 21.89           N  
ATOM   1037  CA  PRO B  55       2.606   6.736   1.869  1.00 21.85           C  
ATOM   1038  C   PRO B  55       2.991   6.878   0.396  1.00 23.12           C  
ATOM   1039  O   PRO B  55       2.295   7.536  -0.383  1.00 22.89           O  
ATOM   1040  CB  PRO B  55       1.470   5.731   2.108  1.00 25.61           C  
ATOM   1041  CG  PRO B  55       0.245   6.594   2.219  1.00 29.51           C  
ATOM   1042  CD  PRO B  55       0.739   7.777   3.010  1.00 21.25           C  
ATOM   1043  N   ASP B  56       4.118   6.270   0.044  1.00 23.93           N  
ATOM   1044  CA  ASP B  56       4.656   6.273  -1.316  1.00 27.16           C  
ATOM   1045  C   ASP B  56       5.212   7.621  -1.771  1.00 26.33           C  
ATOM   1046  O   ASP B  56       5.503   7.808  -2.950  1.00 24.15           O  
ATOM   1047  CB  ASP B  56       3.597   5.805  -2.320  1.00 32.02           C  
ATOM   1048  CG  ASP B  56       4.200   5.430  -3.660  1.00 36.24           C  
ATOM   1049  OD1 ASP B  56       3.534   5.624  -4.698  1.00 43.25           O  
ATOM   1050  OD2 ASP B  56       5.346   4.931  -3.673  1.00 38.06           O  
ATOM   1051  N   SER B  57       5.364   8.555  -0.838  1.00 23.57           N  
ATOM   1052  CA  SER B  57       5.896   9.876  -1.164  1.00 22.19           C  
ATOM   1053  C   SER B  57       7.410   9.869  -0.986  1.00 21.26           C  
ATOM   1054  O   SER B  57       7.976   8.911  -0.465  1.00 20.83           O  
ATOM   1055  CB  SER B  57       5.302  10.928  -0.229  1.00 23.47           C  
ATOM   1056  OG  SER B  57       5.785  10.729   1.093  1.00 19.36           O  
ATOM   1057  N   PRO B  58       8.090  10.937  -1.434  1.00 20.43           N  
ATOM   1058  CA  PRO B  58       9.543  10.998  -1.281  1.00 21.11           C  
ATOM   1059  C   PRO B  58       9.941  10.831   0.191  1.00 19.81           C  
ATOM   1060  O   PRO B  58      10.907  10.140   0.510  1.00 20.58           O  
ATOM   1061  CB  PRO B  58       9.882  12.389  -1.811  1.00 22.60           C  
ATOM   1062  CG  PRO B  58       8.873  12.568  -2.916  1.00 20.70           C  
ATOM   1063  CD  PRO B  58       7.599  12.043  -2.277  1.00 21.41           C  
ATOM   1064  N   ALA B  59       9.187  11.464   1.087  1.00 18.66           N  
ATOM   1065  CA  ALA B  59       9.484  11.382   2.518  1.00 18.36           C  
ATOM   1066  C   ALA B  59       9.402   9.946   3.012  1.00 19.71           C  
ATOM   1067  O   ALA B  59      10.228   9.502   3.813  1.00 20.25           O  
ATOM   1068  CB  ALA B  59       8.518  12.257   3.309  1.00 18.61           C  
ATOM   1069  N   HIS B  60       8.399   9.223   2.530  1.00 19.26           N  
ATOM   1070  CA  HIS B  60       8.203   7.836   2.932  1.00 21.47           C  
ATOM   1071  C   HIS B  60       9.256   6.923   2.306  1.00 23.57           C  
ATOM   1072  O   HIS B  60       9.876   6.112   2.996  1.00 25.22           O  
ATOM   1073  CB  HIS B  60       6.793   7.385   2.529  1.00 22.14           C  
ATOM   1074  CG  HIS B  60       6.455   5.992   2.955  1.00 26.58           C  
ATOM   1075  ND1 HIS B  60       6.758   5.502   4.208  1.00 30.15           N  
ATOM   1076  CD2 HIS B  60       5.803   4.996   2.310  1.00 26.02           C  
ATOM   1077  CE1 HIS B  60       6.308   4.265   4.316  1.00 27.82           C  
ATOM   1078  NE2 HIS B  60       5.724   3.933   3.178  1.00 29.87           N  
ATOM   1079  N   LEU B  61       9.463   7.065   1.001  1.00 23.66           N  
ATOM   1080  CA  LEU B  61      10.434   6.239   0.289  1.00 25.54           C  
ATOM   1081  C   LEU B  61      11.856   6.481   0.788  1.00 26.58           C  
ATOM   1082  O   LEU B  61      12.687   5.568   0.792  1.00 22.89           O  
ATOM   1083  CB  LEU B  61      10.344   6.508  -1.219  1.00 26.67           C  
ATOM   1084  CG  LEU B  61       8.992   6.177  -1.858  1.00 29.82           C  
ATOM   1085  CD1 LEU B  61       9.006   6.573  -3.323  1.00 31.31           C  
ATOM   1086  CD2 LEU B  61       8.695   4.688  -1.706  1.00 33.02           C  
ATOM   1087  N   CYS B  62      12.127   7.713   1.207  1.00 25.40           N  
ATOM   1088  CA  CYS B  62      13.437   8.085   1.731  1.00 29.56           C  
ATOM   1089  C   CYS B  62      13.858   7.136   2.851  1.00 28.96           C  
ATOM   1090  O   CYS B  62      14.992   6.655   2.876  1.00 30.95           O  
ATOM   1091  CB  CYS B  62      13.392   9.526   2.249  1.00 28.61           C  
ATOM   1092  SG  CYS B  62      14.575   9.905   3.546  1.00 33.39           S  
ATOM   1093  N   GLY B  63      12.940   6.879   3.779  1.00 27.61           N  
ATOM   1094  CA  GLY B  63      13.225   5.980   4.885  1.00 29.92           C  
ATOM   1095  C   GLY B  63      14.076   6.560   6.002  1.00 30.81           C  
ATOM   1096  O   GLY B  63      14.294   5.906   7.023  1.00 34.63           O  
ATOM   1097  N   ARG B  64      14.552   7.786   5.827  1.00 29.20           N  
ATOM   1098  CA  ARG B  64      15.387   8.406   6.848  1.00 29.14           C  
ATOM   1099  C   ARG B  64      14.650   9.456   7.669  1.00 25.81           C  
ATOM   1100  O   ARG B  64      15.262  10.172   8.465  1.00 24.65           O  
ATOM   1101  CB  ARG B  64      16.628   9.031   6.206  1.00 31.02           C  
ATOM   1102  CG  ARG B  64      17.492   8.042   5.428  1.00 38.59           C  
ATOM   1103  CD  ARG B  64      17.600   6.705   6.155  1.00 41.71           C  
ATOM   1104  NE  ARG B  64      17.854   6.874   7.582  1.00 48.58           N  
ATOM   1105  CZ  ARG B  64      17.897   5.875   8.457  1.00 51.15           C  
ATOM   1106  NH1 ARG B  64      17.702   4.626   8.050  1.00 53.36           N  
ATOM   1107  NH2 ARG B  64      18.127   6.122   9.740  1.00 51.92           N  
ATOM   1108  N   LEU B  65      13.341   9.549   7.463  1.00 23.15           N  
ATOM   1109  CA  LEU B  65      12.514  10.503   8.186  1.00 22.91           C  
ATOM   1110  C   LEU B  65      11.480   9.738   8.994  1.00 25.57           C  
ATOM   1111  O   LEU B  65      10.829   8.827   8.485  1.00 26.12           O  
ATOM   1112  CB  LEU B  65      11.805  11.450   7.216  1.00 24.95           C  
ATOM   1113  CG  LEU B  65      12.678  12.438   6.444  1.00 26.47           C  
ATOM   1114  CD1 LEU B  65      11.817  13.218   5.460  1.00 27.28           C  
ATOM   1115  CD2 LEU B  65      13.369  13.387   7.424  1.00 25.96           C  
ATOM   1116  N   LYS B  66      11.339  10.109  10.259  1.00 21.71           N  
ATOM   1117  CA  LYS B  66      10.388   9.443  11.130  1.00 21.66           C  
ATOM   1118  C   LYS B  66       9.372  10.416  11.688  1.00 21.49           C  
ATOM   1119  O   LYS B  66       9.683  11.584  11.933  1.00 19.66           O  
ATOM   1120  CB  LYS B  66      11.116   8.767  12.298  1.00 25.77           C  
ATOM   1121  CG  LYS B  66      11.798   7.448  11.950  1.00 34.04           C  
ATOM   1122  CD  LYS B  66      12.913   7.622  10.935  1.00 40.20           C  
ATOM   1123  CE  LYS B  66      13.569   6.284  10.604  1.00 43.80           C  
ATOM   1124  NZ  LYS B  66      14.732   6.436   9.680  1.00 45.22           N  
ATOM   1125  N   VAL B  67       8.146   9.938  11.871  1.00 20.98           N  
ATOM   1126  CA  VAL B  67       7.120  10.770  12.466  1.00 19.38           C  
ATOM   1127  C   VAL B  67       7.702  11.059  13.841  1.00 20.90           C  
ATOM   1128  O   VAL B  67       8.257  10.159  14.478  1.00 20.35           O  
ATOM   1129  CB  VAL B  67       5.791  10.005  12.629  1.00 22.63           C  
ATOM   1130  CG1 VAL B  67       4.790  10.856  13.389  1.00 24.38           C  
ATOM   1131  CG2 VAL B  67       5.245   9.628  11.269  1.00 20.33           C  
ATOM   1132  N   GLY B  68       7.602  12.306  14.287  1.00 18.63           N  
ATOM   1133  CA  GLY B  68       8.150  12.667  15.584  1.00 20.83           C  
ATOM   1134  C   GLY B  68       9.466  13.425  15.492  1.00 18.18           C  
ATOM   1135  O   GLY B  68       9.895  14.048  16.467  1.00 20.13           O  
ATOM   1136  N   ASP B  69      10.114  13.367  14.328  1.00 17.28           N  
ATOM   1137  CA  ASP B  69      11.378  14.071  14.110  1.00 17.52           C  
ATOM   1138  C   ASP B  69      11.143  15.572  14.111  1.00 17.47           C  
ATOM   1139  O   ASP B  69      10.076  16.033  13.714  1.00 17.96           O  
ATOM   1140  CB  ASP B  69      11.992  13.712  12.752  1.00 17.68           C  
ATOM   1141  CG  ASP B  69      12.643  12.351  12.734  1.00 19.27           C  
ATOM   1142  OD1 ASP B  69      12.849  11.766  13.815  1.00 19.80           O  
ATOM   1143  OD2 ASP B  69      12.970  11.877  11.623  1.00 20.19           O  
ATOM   1144  N   ARG B  70      12.139  16.334  14.547  1.00 15.13           N  
ATOM   1145  CA  ARG B  70      12.028  17.785  14.543  1.00 16.62           C  
ATOM   1146  C   ARG B  70      12.799  18.345  13.350  1.00 18.06           C  
ATOM   1147  O   ARG B  70      13.855  17.831  12.989  1.00 19.92           O  
ATOM   1148  CB  ARG B  70      12.601  18.389  15.832  1.00 18.90           C  
ATOM   1149  CG  ARG B  70      12.546  19.909  15.826  1.00 26.36           C  
ATOM   1150  CD  ARG B  70      13.071  20.550  17.113  1.00 33.45           C  
ATOM   1151  NE  ARG B  70      13.029  22.007  16.992  1.00 36.92           N  
ATOM   1152  CZ  ARG B  70      13.378  22.865  17.942  1.00 35.90           C  
ATOM   1153  NH1 ARG B  70      13.807  22.430  19.118  1.00 42.41           N  
ATOM   1154  NH2 ARG B  70      13.288  24.169  17.716  1.00 41.50           N  
ATOM   1155  N   ILE B  71      12.264  19.388  12.724  1.00 15.56           N  
ATOM   1156  CA  ILE B  71      12.951  20.015  11.602  1.00 14.32           C  
ATOM   1157  C   ILE B  71      13.614  21.267  12.182  1.00 16.65           C  
ATOM   1158  O   ILE B  71      12.926  22.161  12.686  1.00 16.91           O  
ATOM   1159  CB  ILE B  71      11.951  20.411  10.481  1.00 17.28           C  
ATOM   1160  CG1 ILE B  71      11.237  19.160   9.958  1.00 18.00           C  
ATOM   1161  CG2 ILE B  71      12.689  21.097   9.340  1.00 16.14           C  
ATOM   1162  CD1 ILE B  71      10.163  19.436   8.915  1.00 19.89           C  
ATOM   1163  N   LEU B  72      14.944  21.314  12.142  1.00 14.97           N  
ATOM   1164  CA  LEU B  72      15.675  22.462  12.683  1.00 18.76           C  
ATOM   1165  C   LEU B  72      15.857  23.554  11.638  1.00 19.13           C  
ATOM   1166  O   LEU B  72      15.800  24.744  11.953  1.00 21.43           O  
ATOM   1167  CB  LEU B  72      17.043  22.024  13.225  1.00 19.34           C  
ATOM   1168  CG  LEU B  72      17.030  20.996  14.368  1.00 21.53           C  
ATOM   1169  CD1 LEU B  72      18.462  20.692  14.807  1.00 22.97           C  
ATOM   1170  CD2 LEU B  72      16.225  21.521  15.546  1.00 22.47           C  
ATOM   1171  N   SER B  73      16.087  23.150  10.396  1.00 17.13           N  
ATOM   1172  CA  SER B  73      16.247  24.114   9.315  1.00 20.23           C  
ATOM   1173  C   SER B  73      15.843  23.490   7.988  1.00 20.07           C  
ATOM   1174  O   SER B  73      15.823  22.261   7.839  1.00 15.74           O  
ATOM   1175  CB  SER B  73      17.692  24.626   9.236  1.00 20.86           C  
ATOM   1176  OG  SER B  73      18.587  23.638   8.767  1.00 21.43           O  
ATOM   1177  N   LEU B  74      15.506  24.353   7.037  1.00 19.20           N  
ATOM   1178  CA  LEU B  74      15.087  23.940   5.703  1.00 22.45           C  
ATOM   1179  C   LEU B  74      15.904  24.749   4.710  1.00 24.68           C  
ATOM   1180  O   LEU B  74      15.821  25.978   4.683  1.00 27.80           O  
ATOM   1181  CB  LEU B  74      13.589  24.220   5.517  1.00 25.18           C  
ATOM   1182  CG  LEU B  74      12.902  23.909   4.179  1.00 28.01           C  
ATOM   1183  CD1 LEU B  74      13.316  24.904   3.111  1.00 34.13           C  
ATOM   1184  CD2 LEU B  74      13.241  22.502   3.762  1.00 32.72           C  
ATOM   1185  N   ASN B  75      16.700  24.057   3.903  1.00 24.79           N  
ATOM   1186  CA  ASN B  75      17.554  24.711   2.924  1.00 30.33           C  
ATOM   1187  C   ASN B  75      18.397  25.799   3.574  1.00 32.19           C  
ATOM   1188  O   ASN B  75      18.581  26.881   3.014  1.00 34.42           O  
ATOM   1189  CB  ASN B  75      16.720  25.301   1.785  1.00 32.11           C  
ATOM   1190  CG  ASN B  75      16.094  24.234   0.920  1.00 33.87           C  
ATOM   1191  OD1 ASN B  75      16.674  23.167   0.720  1.00 29.58           O  
ATOM   1192  ND2 ASN B  75      14.911  24.516   0.387  1.00 36.42           N  
ATOM   1193  N   GLY B  76      18.892  25.505   4.770  1.00 32.23           N  
ATOM   1194  CA  GLY B  76      19.734  26.450   5.476  1.00 34.09           C  
ATOM   1195  C   GLY B  76      19.010  27.469   6.328  1.00 33.15           C  
ATOM   1196  O   GLY B  76      19.639  28.144   7.140  1.00 36.47           O  
ATOM   1197  N   LYS B  77      17.699  27.596   6.151  1.00 31.85           N  
ATOM   1198  CA  LYS B  77      16.939  28.555   6.940  1.00 29.73           C  
ATOM   1199  C   LYS B  77      16.443  27.948   8.240  1.00 28.44           C  
ATOM   1200  O   LYS B  77      15.779  26.911   8.244  1.00 23.91           O  
ATOM   1201  CB  LYS B  77      15.745  29.093   6.153  1.00 33.24           C  
ATOM   1202  CG  LYS B  77      14.945  30.134   6.926  1.00 39.06           C  
ATOM   1203  CD  LYS B  77      13.900  30.800   6.052  1.00 42.55           C  
ATOM   1204  CE  LYS B  77      13.232  31.958   6.779  1.00 44.99           C  
ATOM   1205  NZ  LYS B  77      12.433  32.791   5.835  1.00 47.67           N  
ATOM   1206  N   ASP B  78      16.772  28.607   9.344  1.00 25.87           N  
ATOM   1207  CA  ASP B  78      16.360  28.158  10.663  1.00 28.01           C  
ATOM   1208  C   ASP B  78      14.843  28.287  10.808  1.00 27.74           C  
ATOM   1209  O   ASP B  78      14.282  29.364  10.604  1.00 26.76           O  
ATOM   1210  CB  ASP B  78      17.088  28.992  11.726  1.00 30.69           C  
ATOM   1211  CG  ASP B  78      16.500  28.827  13.106  1.00 32.77           C  
ATOM   1212  OD1 ASP B  78      16.141  27.694  13.470  1.00 30.82           O  
ATOM   1213  OD2 ASP B  78      16.407  29.840  13.836  1.00 37.89           O  
ATOM   1214  N   VAL B  79      14.177  27.183  11.140  1.00 24.51           N  
ATOM   1215  CA  VAL B  79      12.725  27.199  11.304  1.00 21.36           C  
ATOM   1216  C   VAL B  79      12.303  26.803  12.715  1.00 23.50           C  
ATOM   1217  O   VAL B  79      11.131  26.530  12.969  1.00 22.14           O  
ATOM   1218  CB  VAL B  79      12.031  26.250  10.294  1.00 24.07           C  
ATOM   1219  CG1 VAL B  79      12.200  26.788   8.884  1.00 22.30           C  
ATOM   1220  CG2 VAL B  79      12.623  24.835  10.404  1.00 22.12           C  
ATOM   1221  N   ARG B  80      13.261  26.791  13.635  1.00 23.55           N  
ATOM   1222  CA  ARG B  80      12.977  26.419  15.014  1.00 26.70           C  
ATOM   1223  C   ARG B  80      11.790  27.176  15.604  1.00 25.83           C  
ATOM   1224  O   ARG B  80      10.999  26.605  16.349  1.00 28.77           O  
ATOM   1225  CB  ARG B  80      14.220  26.634  15.884  1.00 28.52           C  
ATOM   1226  CG  ARG B  80      15.394  25.717  15.537  1.00 33.22           C  
ATOM   1227  CD  ARG B  80      16.602  26.042  16.402  1.00 36.26           C  
ATOM   1228  NE  ARG B  80      17.746  25.172  16.143  1.00 39.03           N  
ATOM   1229  CZ  ARG B  80      18.421  25.127  14.997  1.00 39.63           C  
ATOM   1230  NH1 ARG B  80      18.073  25.906  13.980  1.00 39.40           N  
ATOM   1231  NH2 ARG B  80      19.457  24.307  14.870  1.00 40.94           N  
ATOM   1232  N   ASN B  81      11.656  28.458  15.272  1.00 25.88           N  
ATOM   1233  CA  ASN B  81      10.546  29.248  15.795  1.00 26.84           C  
ATOM   1234  C   ASN B  81       9.528  29.704  14.755  1.00 26.30           C  
ATOM   1235  O   ASN B  81       8.783  30.655  14.988  1.00 24.53           O  
ATOM   1236  CB  ASN B  81      11.074  30.464  16.558  1.00 32.54           C  
ATOM   1237  CG  ASN B  81      11.463  30.127  17.981  1.00 37.02           C  
ATOM   1238  OD1 ASN B  81      12.436  29.416  18.219  1.00 37.65           O  
ATOM   1239  ND2 ASN B  81      10.688  30.624  18.939  1.00 41.90           N  
ATOM   1240  N   SER B  82       9.478  29.012  13.621  1.00 23.95           N  
ATOM   1241  CA  SER B  82       8.547  29.374  12.558  1.00 21.52           C  
ATOM   1242  C   SER B  82       7.138  28.839  12.773  1.00 20.97           C  
ATOM   1243  O   SER B  82       6.925  27.850  13.477  1.00 18.51           O  
ATOM   1244  CB  SER B  82       9.061  28.863  11.205  1.00 24.21           C  
ATOM   1245  OG  SER B  82      10.305  29.451  10.864  1.00 26.69           O  
ATOM   1246  N   THR B  83       6.168  29.513  12.168  1.00 19.25           N  
ATOM   1247  CA  THR B  83       4.791  29.061  12.246  1.00 19.88           C  
ATOM   1248  C   THR B  83       4.751  27.903  11.248  1.00 18.77           C  
ATOM   1249  O   THR B  83       5.648  27.778  10.410  1.00 19.91           O  
ATOM   1250  CB  THR B  83       3.806  30.156  11.784  1.00 22.91           C  
ATOM   1251  OG1 THR B  83       4.114  30.528  10.433  1.00 23.18           O  
ATOM   1252  CG2 THR B  83       3.916  31.387  12.678  1.00 23.89           C  
ATOM   1253  N   GLU B  84       3.734  27.057  11.334  1.00 18.96           N  
ATOM   1254  CA  GLU B  84       3.634  25.938  10.410  1.00 20.79           C  
ATOM   1255  C   GLU B  84       3.486  26.440   8.984  1.00 20.89           C  
ATOM   1256  O   GLU B  84       4.184  25.982   8.079  1.00 18.19           O  
ATOM   1257  CB  GLU B  84       2.445  25.044  10.761  1.00 23.07           C  
ATOM   1258  CG  GLU B  84       2.549  24.390  12.123  1.00 27.14           C  
ATOM   1259  CD  GLU B  84       1.761  25.124  13.184  1.00 28.72           C  
ATOM   1260  OE1 GLU B  84       1.747  26.373  13.162  1.00 30.70           O  
ATOM   1261  OE2 GLU B  84       1.161  24.449  14.046  1.00 34.13           O  
ATOM   1262  N   GLN B  85       2.584  27.394   8.787  1.00 20.20           N  
ATOM   1263  CA  GLN B  85       2.353  27.932   7.450  1.00 20.93           C  
ATOM   1264  C   GLN B  85       3.619  28.506   6.834  1.00 20.21           C  
ATOM   1265  O   GLN B  85       3.844  28.365   5.632  1.00 23.17           O  
ATOM   1266  CB  GLN B  85       1.270  29.009   7.476  1.00 22.70           C  
ATOM   1267  CG  GLN B  85       0.836  29.432   6.077  1.00 25.03           C  
ATOM   1268  CD  GLN B  85       0.298  28.266   5.276  1.00 20.74           C  
ATOM   1269  OE1 GLN B  85      -0.645  27.598   5.695  1.00 24.85           O  
ATOM   1270  NE2 GLN B  85       0.897  28.012   4.121  1.00 23.78           N  
ATOM   1271  N   ALA B  86       4.440  29.163   7.647  1.00 21.23           N  
ATOM   1272  CA  ALA B  86       5.682  29.743   7.153  1.00 22.12           C  
ATOM   1273  C   ALA B  86       6.587  28.662   6.570  1.00 23.39           C  
ATOM   1274  O   ALA B  86       7.228  28.861   5.534  1.00 24.35           O  
ATOM   1275  CB  ALA B  86       6.408  30.479   8.278  1.00 23.94           C  
ATOM   1276  N   VAL B  87       6.646  27.519   7.244  1.00 20.62           N  
ATOM   1277  CA  VAL B  87       7.477  26.418   6.775  1.00 20.36           C  
ATOM   1278  C   VAL B  87       6.914  25.833   5.484  1.00 20.06           C  
ATOM   1279  O   VAL B  87       7.664  25.524   4.550  1.00 22.42           O  
ATOM   1280  CB  VAL B  87       7.577  25.305   7.832  1.00 17.94           C  
ATOM   1281  CG1 VAL B  87       8.467  24.179   7.309  1.00 20.37           C  
ATOM   1282  CG2 VAL B  87       8.146  25.876   9.139  1.00 18.89           C  
ATOM   1283  N   ILE B  88       5.595  25.680   5.434  1.00 19.18           N  
ATOM   1284  CA  ILE B  88       4.939  25.146   4.243  1.00 20.79           C  
ATOM   1285  C   ILE B  88       5.228  26.063   3.060  1.00 22.10           C  
ATOM   1286  O   ILE B  88       5.553  25.593   1.966  1.00 21.93           O  
ATOM   1287  CB  ILE B  88       3.414  25.036   4.442  1.00 20.67           C  
ATOM   1288  CG1 ILE B  88       3.102  24.023   5.550  1.00 20.72           C  
ATOM   1289  CG2 ILE B  88       2.739  24.608   3.137  1.00 20.45           C  
ATOM   1290  CD1 ILE B  88       3.604  22.608   5.272  1.00 21.00           C  
ATOM   1291  N   ASP B  89       5.118  27.372   3.276  1.00 23.00           N  
ATOM   1292  CA  ASP B  89       5.392  28.328   2.208  1.00 27.10           C  
ATOM   1293  C   ASP B  89       6.815  28.131   1.690  1.00 27.08           C  
ATOM   1294  O   ASP B  89       7.040  28.089   0.485  1.00 24.72           O  
ATOM   1295  CB  ASP B  89       5.221  29.777   2.691  1.00 28.04           C  
ATOM   1296  CG  ASP B  89       3.777  30.132   2.998  1.00 30.60           C  
ATOM   1297  OD1 ASP B  89       2.864  29.478   2.451  1.00 34.68           O  
ATOM   1298  OD2 ASP B  89       3.553  31.083   3.777  1.00 32.69           O  
ATOM   1299  N   LEU B  90       7.775  28.014   2.603  1.00 27.55           N  
ATOM   1300  CA  LEU B  90       9.164  27.808   2.212  1.00 28.67           C  
ATOM   1301  C   LEU B  90       9.307  26.540   1.375  1.00 27.78           C  
ATOM   1302  O   LEU B  90       9.985  26.535   0.350  1.00 29.40           O  
ATOM   1303  CB  LEU B  90      10.063  27.706   3.448  1.00 31.51           C  
ATOM   1304  CG  LEU B  90      10.352  29.006   4.202  1.00 35.55           C  
ATOM   1305  CD1 LEU B  90      11.164  28.706   5.455  1.00 39.29           C  
ATOM   1306  CD2 LEU B  90      11.110  29.961   3.294  1.00 37.91           C  
ATOM   1307  N   ILE B  91       8.666  25.466   1.816  1.00 26.23           N  
ATOM   1308  CA  ILE B  91       8.737  24.204   1.094  1.00 25.84           C  
ATOM   1309  C   ILE B  91       8.134  24.310  -0.308  1.00 27.61           C  
ATOM   1310  O   ILE B  91       8.699  23.796  -1.270  1.00 26.07           O  
ATOM   1311  CB  ILE B  91       8.016  23.083   1.862  1.00 26.78           C  
ATOM   1312  CG1 ILE B  91       8.739  22.813   3.185  1.00 23.79           C  
ATOM   1313  CG2 ILE B  91       7.982  21.813   1.013  1.00 23.99           C  
ATOM   1314  CD1 ILE B  91       8.007  21.851   4.102  1.00 24.05           C  
ATOM   1315  N   LYS B  92       6.994  24.982  -0.426  1.00 28.06           N  
ATOM   1316  CA  LYS B  92       6.355  25.128  -1.729  1.00 33.30           C  
ATOM   1317  C   LYS B  92       7.150  26.046  -2.657  1.00 35.42           C  
ATOM   1318  O   LYS B  92       6.989  25.996  -3.877  1.00 37.61           O  
ATOM   1319  CB  LYS B  92       4.919  25.631  -1.559  1.00 32.99           C  
ATOM   1320  CG  LYS B  92       4.012  24.618  -0.861  1.00 32.83           C  
ATOM   1321  CD  LYS B  92       2.560  25.076  -0.808  1.00 31.89           C  
ATOM   1322  CE  LYS B  92       1.662  23.969  -0.261  1.00 35.18           C  
ATOM   1323  NZ  LYS B  92       0.219  24.351  -0.219  1.00 31.54           N  
ATOM   1324  N   GLU B  93       8.017  26.872  -2.081  1.00 35.90           N  
ATOM   1325  CA  GLU B  93       8.844  27.773  -2.881  1.00 39.09           C  
ATOM   1326  C   GLU B  93       9.994  26.993  -3.511  1.00 39.35           C  
ATOM   1327  O   GLU B  93      10.646  27.470  -4.441  1.00 37.43           O  
ATOM   1328  CB  GLU B  93       9.408  28.901  -2.013  1.00 40.87           C  
ATOM   1329  CG  GLU B  93       8.393  29.966  -1.633  1.00 46.43           C  
ATOM   1330  CD  GLU B  93       8.946  30.963  -0.632  1.00 49.56           C  
ATOM   1331  OE1 GLU B  93      10.051  31.495  -0.868  1.00 51.45           O  
ATOM   1332  OE2 GLU B  93       8.273  31.218   0.390  1.00 53.68           O  
ATOM   1333  N   ALA B  94      10.237  25.792  -2.993  1.00 37.39           N  
ATOM   1334  CA  ALA B  94      11.305  24.940  -3.500  1.00 37.90           C  
ATOM   1335  C   ALA B  94      10.944  24.406  -4.881  1.00 37.01           C  
ATOM   1336  O   ALA B  94       9.779  24.143  -5.174  1.00 38.58           O  
ATOM   1337  CB  ALA B  94      11.552  23.786  -2.534  1.00 37.44           C  
ATOM   1338  N   ASP B  95      11.952  24.239  -5.727  1.00 37.34           N  
ATOM   1339  CA  ASP B  95      11.734  23.751  -7.079  1.00 36.65           C  
ATOM   1340  C   ASP B  95      11.415  22.258  -7.112  1.00 34.17           C  
ATOM   1341  O   ASP B  95      10.341  21.855  -7.560  1.00 36.10           O  
ATOM   1342  CB  ASP B  95      12.970  24.029  -7.935  1.00 41.06           C  
ATOM   1343  CG  ASP B  95      12.682  23.933  -9.415  1.00 46.21           C  
ATOM   1344  OD1 ASP B  95      12.146  22.890  -9.851  1.00 47.72           O  
ATOM   1345  OD2 ASP B  95      12.992  24.903 -10.140  1.00 47.55           O  
ATOM   1346  N   PHE B  96      12.343  21.437  -6.634  1.00 27.73           N  
ATOM   1347  CA  PHE B  96      12.133  19.997  -6.640  1.00 25.35           C  
ATOM   1348  C   PHE B  96      12.782  19.282  -5.463  1.00 22.98           C  
ATOM   1349  O   PHE B  96      12.549  18.094  -5.259  1.00 21.18           O  
ATOM   1350  CB  PHE B  96      12.663  19.402  -7.948  1.00 25.87           C  
ATOM   1351  CG  PHE B  96      14.160  19.379  -8.035  1.00 23.56           C  
ATOM   1352  CD1 PHE B  96      14.873  18.240  -7.677  1.00 23.18           C  
ATOM   1353  CD2 PHE B  96      14.862  20.510  -8.435  1.00 27.58           C  
ATOM   1354  CE1 PHE B  96      16.261  18.229  -7.712  1.00 25.27           C  
ATOM   1355  CE2 PHE B  96      16.252  20.508  -8.474  1.00 26.13           C  
ATOM   1356  CZ  PHE B  96      16.953  19.366  -8.110  1.00 26.87           C  
ATOM   1357  N   LYS B  97      13.602  19.987  -4.690  1.00 22.11           N  
ATOM   1358  CA  LYS B  97      14.244  19.344  -3.548  1.00 20.93           C  
ATOM   1359  C   LYS B  97      14.371  20.259  -2.339  1.00 20.31           C  
ATOM   1360  O   LYS B  97      14.439  21.478  -2.465  1.00 19.54           O  
ATOM   1361  CB  LYS B  97      15.634  18.824  -3.934  1.00 25.46           C  
ATOM   1362  CG  LYS B  97      16.678  19.901  -4.171  1.00 30.07           C  
ATOM   1363  CD  LYS B  97      18.008  19.289  -4.586  1.00 36.74           C  
ATOM   1364  CE  LYS B  97      19.068  20.352  -4.831  1.00 39.98           C  
ATOM   1365  NZ  LYS B  97      19.424  21.088  -3.585  1.00 45.01           N  
ATOM   1366  N   ILE B  98      14.387  19.654  -1.158  1.00 19.87           N  
ATOM   1367  CA  ILE B  98      14.541  20.414   0.072  1.00 18.95           C  
ATOM   1368  C   ILE B  98      15.542  19.668   0.941  1.00 22.13           C  
ATOM   1369  O   ILE B  98      15.525  18.435   1.007  1.00 19.55           O  
ATOM   1370  CB  ILE B  98      13.202  20.567   0.839  1.00 20.34           C  
ATOM   1371  CG1 ILE B  98      12.563  19.197   1.075  1.00 19.19           C  
ATOM   1372  CG2 ILE B  98      12.265  21.490   0.066  1.00 19.27           C  
ATOM   1373  CD1 ILE B  98      11.281  19.237   1.914  1.00 19.42           C  
ATOM   1374  N   GLU B  99      16.432  20.425   1.569  1.00 18.79           N  
ATOM   1375  CA  GLU B  99      17.452  19.863   2.444  1.00 23.65           C  
ATOM   1376  C   GLU B  99      16.962  20.115   3.859  1.00 20.46           C  
ATOM   1377  O   GLU B  99      16.786  21.262   4.266  1.00 21.74           O  
ATOM   1378  CB  GLU B  99      18.792  20.571   2.222  1.00 28.81           C  
ATOM   1379  CG  GLU B  99      19.357  20.423   0.817  1.00 39.76           C  
ATOM   1380  CD  GLU B  99      20.592  21.284   0.592  1.00 46.75           C  
ATOM   1381  OE1 GLU B  99      21.543  21.193   1.400  1.00 49.07           O  
ATOM   1382  OE2 GLU B  99      20.612  22.051  -0.396  1.00 51.53           O  
ATOM   1383  N   LEU B 100      16.736  19.043   4.606  1.00 17.62           N  
ATOM   1384  CA  LEU B 100      16.240  19.172   5.965  1.00 17.01           C  
ATOM   1385  C   LEU B 100      17.281  18.816   7.012  1.00 15.82           C  
ATOM   1386  O   LEU B 100      17.945  17.790   6.902  1.00 18.54           O  
ATOM   1387  CB  LEU B 100      15.029  18.255   6.165  1.00 16.35           C  
ATOM   1388  CG  LEU B 100      13.835  18.448   5.229  1.00 19.30           C  
ATOM   1389  CD1 LEU B 100      12.844  17.297   5.392  1.00 24.09           C  
ATOM   1390  CD2 LEU B 100      13.172  19.772   5.534  1.00 23.00           C  
ATOM   1391  N   GLU B 101      17.429  19.677   8.016  1.00 14.90           N  
ATOM   1392  CA  GLU B 101      18.332  19.390   9.130  1.00 13.89           C  
ATOM   1393  C   GLU B 101      17.336  18.800  10.123  1.00 13.00           C  
ATOM   1394  O   GLU B 101      16.440  19.496  10.605  1.00 15.93           O  
ATOM   1395  CB  GLU B 101      18.951  20.668   9.702  1.00 15.98           C  
ATOM   1396  CG  GLU B 101      19.912  20.395  10.859  1.00 16.10           C  
ATOM   1397  CD  GLU B 101      20.476  21.666  11.463  1.00 21.06           C  
ATOM   1398  OE1 GLU B 101      20.217  22.749  10.902  1.00 22.79           O  
ATOM   1399  OE2 GLU B 101      21.173  21.579  12.497  1.00 22.08           O  
ATOM   1400  N   ILE B 102      17.497  17.513  10.404  1.00 13.47           N  
ATOM   1401  CA  ILE B 102      16.593  16.764  11.265  1.00 16.45           C  
ATOM   1402  C   ILE B 102      17.202  16.329  12.592  1.00 16.00           C  
ATOM   1403  O   ILE B 102      18.353  15.913  12.639  1.00 15.39           O  
ATOM   1404  CB  ILE B 102      16.139  15.472  10.534  1.00 15.64           C  
ATOM   1405  CG1 ILE B 102      15.450  15.828   9.214  1.00 18.75           C  
ATOM   1406  CG2 ILE B 102      15.236  14.634  11.439  1.00 17.18           C  
ATOM   1407  CD1 ILE B 102      14.136  16.537   9.387  1.00 16.74           C  
ATOM   1408  N   GLN B 103      16.420  16.433  13.665  1.00 18.33           N  
ATOM   1409  CA  GLN B 103      16.870  15.956  14.970  1.00 19.08           C  
ATOM   1410  C   GLN B 103      15.939  14.785  15.271  1.00 19.66           C  
ATOM   1411  O   GLN B 103      14.725  14.966  15.392  1.00 20.06           O  
ATOM   1412  CB  GLN B 103      16.733  17.022  16.052  1.00 19.81           C  
ATOM   1413  CG  GLN B 103      17.300  16.550  17.387  1.00 23.12           C  
ATOM   1414  CD  GLN B 103      17.429  17.673  18.385  1.00 26.34           C  
ATOM   1415  OE1 GLN B 103      17.738  18.805  18.014  1.00 29.24           O  
ATOM   1416  NE2 GLN B 103      17.203  17.369  19.660  1.00 24.88           N  
ATOM   1417  N   THR B 104      16.513  13.591  15.371  1.00 22.23           N  
ATOM   1418  CA  THR B 104      15.742  12.370  15.600  1.00 25.78           C  
ATOM   1419  C   THR B 104      16.245  11.553  16.783  1.00 30.40           C  
ATOM   1420  O   THR B 104      17.284  11.856  17.368  1.00 28.96           O  
ATOM   1421  CB  THR B 104      15.806  11.458  14.356  1.00 25.32           C  
ATOM   1422  OG1 THR B 104      14.980  10.302  14.551  1.00 26.46           O  
ATOM   1423  CG2 THR B 104      17.240  10.995  14.119  1.00 25.32           C  
ATOM   1424  N   PHE B 105      15.491  10.510  17.121  1.00 34.95           N  
ATOM   1425  CA  PHE B 105      15.858   9.607  18.204  1.00 39.35           C  
ATOM   1426  C   PHE B 105      16.393   8.331  17.556  1.00 43.72           C  
ATOM   1427  O   PHE B 105      15.852   7.868  16.551  1.00 44.71           O  
ATOM   1428  CB  PHE B 105      14.641   9.291  19.063  1.00 38.87           C  
ATOM   1429  N   ASP B 106      17.458   7.770  18.118  1.00 47.66           N  
ATOM   1430  CA  ASP B 106      18.039   6.549  17.570  1.00 51.57           C  
ATOM   1431  C   ASP B 106      18.666   5.691  18.662  1.00 52.47           C  
ATOM   1432  O   ASP B 106      18.634   6.114  19.837  1.00 55.25           O  
ATOM   1433  CB  ASP B 106      19.097   6.892  16.520  1.00 52.59           C  
ATOM   1434  CG  ASP B 106      20.324   7.550  17.123  1.00 52.79           C  
ATOM   1435  OD1 ASP B 106      20.174   8.605  17.774  1.00 53.14           O  
ATOM   1436  OD2 ASP B 106      21.437   7.011  16.942  1.00 52.51           O  
TER    1437      ASP B 106                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
