
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  682 ( 5670),  selected  682 , name 1yvu_A
# Molecule2: number of CA atoms  637 ( 4891),  selected  637 , name T0487.pdb
# PARAMETERS: 1yvu_A.T0487.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      H       3           -
LGA    -       -      L       4           -
LGA    -       -      G       5           -
LGA    -       -      K       6           -
LGA    -       -      T       7           -
LGA    E     4_A      E       8          2.963
LGA    A     5_A      V       9          2.426
LGA    L     6_A      F      10          1.763
LGA    L     7_A      L      11          1.401
LGA    N     8_A      N      12          1.126
LGA    L     9_A      R      13          0.412
LGA    Y    10_A      F      14          0.322
LGA    R    11_A      A      15          0.405
LGA    I    12_A      L      16          1.642
LGA    E    13_A      R      17          1.988
LGA    -       -      P      18           -
LGA    Y    14_A      L      19           #
LGA    R    15_A      N      20           #
LGA    P    16_A      P      21           -
LGA    K    17_A      -       -           -
LGA    D    18_A      -       -           -
LGA    T    19_A      -       -           -
LGA    T    20_A      -       -           -
LGA    F    21_A      E      22           #
LGA    T    22_A      E      23           -
LGA    -       -      L      24           -
LGA    -       -      R      25           -
LGA    -       -      P      26           -
LGA    V    23_A      W      27           #
LGA    F    24_A      R      28           #
LGA    K    25_A      L      29          3.455
LGA    P    26_A      -       -           -
LGA    T    27_A      E      30           #
LGA    H    28_A      V      31          4.064
LGA    E    29_A      V      32          4.427
LGA    I    30_A      L      33           -
LGA    Q    31_A      D      34           -
LGA    -       -      P      35           -
LGA    -       -      P      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    -       -      R      39           -
LGA    -       -      E      40           -
LGA    -       -      E      41           -
LGA    K    32_A      V      42           #
LGA    E    33_A      Y      43          2.188
LGA    -       -      P      44           -
LGA    K    34_A      L      45          3.697
LGA    L    35_A      L      46          3.777
LGA    N    36_A      A      47          3.339
LGA    K    37_A      Q      48          2.837
LGA    V    38_A      V      49          2.848
LGA    R    39_A      A      50          2.977
LGA    W    40_A      R      51          2.497
LGA    R    41_A      R      52          2.821
LGA    V    42_A      A      53          3.061
LGA    F    43_A      G      54          2.766
LGA    L    44_A      G      55           #
LGA    Q    45_A      -       -           -
LGA    T    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    L    48_A      -       -           -
LGA    P    49_A      V      56           #
LGA    T    50_A      T      57           #
LGA    F    51_A      V      58           #
LGA    -       -      R      59           -
LGA    -       -      M      60           -
LGA    -       -      G      61           -
LGA    -       -      D      62           -
LGA    -       -      G      63           -
LGA    R    52_A      L      64           #
LGA    R    53_A      A      65          3.700
LGA    E    54_A      -       -           -
LGA    D    55_A      -       -           -
LGA    E    56_A      -       -           -
LGA    F    57_A      S      66          2.362
LGA    W    58_A      W      67          2.621
LGA    C    59_A      S      68          0.722
LGA    A    60_A      P      69           #
LGA    G    61_A      P      70           -
LGA    K    62_A      -       -           -
LGA    V    63_A      -       -           -
LGA    E    64_A      -       -           -
LGA    K    65_A      -       -           -
LGA    D    66_A      E      71           #
LGA    T    67_A      V      72           -
LGA    L    68_A      L      73           #
LGA    Y    69_A      V      74          2.754
LGA    L    70_A      L      75          3.974
LGA    -       -      E      76           -
LGA    T    71_A      G      77          3.380
LGA    L    72_A      T      78          2.850
LGA    S    73_A      L      79          2.815
LGA    N    74_A      A      80          2.893
LGA    G    75_A      R      81          4.278
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    -       -      Q      84           -
LGA    E    76_A      T      85          3.267
LGA    I    77_A      Y      86          2.912
LGA    -       -      A      87           -
LGA    V    78_A      Y      88          2.940
LGA    E    79_A      R      89          2.622
LGA    L    80_A      L      90          3.729
LGA    K    81_A      Y      91           #
LGA    R    82_A      P      92           #
LGA    -       -      K      93           -
LGA    V    83_A      G      94           #
LGA    G    84_A      -       -           -
LGA    E    85_A      -       -           -
LGA    E    86_A      R      95           #
LGA    E    87_A      R      96           -
LGA    F    88_A      P      97           -
LGA    R    89_A      -       -           -
LGA    G    90_A      -       -           -
LGA    F    91_A      L      98           #
LGA    Q    92_A      D      99           #
LGA    N    93_A      P     100           #
LGA    -       -      K     101           -
LGA    -       -      D     102           -
LGA    -       -      P     103           -
LGA    -       -      G     104           -
LGA    -       -      E     105           -
LGA    -       -      R     106           -
LGA    E    94_A      S     107           #
LGA    -       -      V     108           -
LGA    -       -      L     109           -
LGA    -       -      S     110           -
LGA    R    95_A      A     111          3.052
LGA    E    96_A      L     112          2.749
LGA    C    97_A      A     113          2.654
LGA    Q    98_A      R     114          2.650
LGA    E    99_A      R     115          2.357
LGA    L   100_A      L     116          2.003
LGA    F   101_A      L     117          2.912
LGA    R   102_A      Q     118          2.597
LGA    D   103_A      E     119          1.317
LGA    F   104_A      R     120          1.302
LGA    L   105_A      L     121          1.749
LGA    T   106_A      R     122          1.574
LGA    K   107_A      R     123          2.017
LGA    T   108_A      L     124          2.913
LGA    K   109_A      E     125          4.500
LGA    V   110_A      -       -           -
LGA    K   111_A      -       -           -
LGA    D   112_A      G     126           #
LGA    K   113_A      V     127          1.696
LGA    F   114_A      W     128           #
LGA    -       -      V     129           -
LGA    -       -      E     130           -
LGA    -       -      G     131           -
LGA    -       -      L     132           -
LGA    -       -      A     133           -
LGA    I   115_A      V     134           #
LGA    S   116_A      Y     135           #
LGA    D   117_A      R     136          3.960
LGA    F   118_A      R     137          1.859
LGA    Y   119_A      E     138          1.920
LGA    K   120_A      -       -           -
LGA    K   121_A      -       -           -
LGA    F   122_A      H     139          0.249
LGA    R   123_A      A     140          1.828
LGA    D   124_A      R     141          4.614
LGA    K   125_A      G     142           -
LGA    -       -      P     143           -
LGA    -       -      G     144           -
LGA    -       -      W     145           -
LGA    I   126_A      R     146           #
LGA    T   127_A      V     147           #
LGA    V   128_A      -       -           -
LGA    Q   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    K   131_A      -       -           -
LGA    N   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    K   134_A      -       -           -
LGA    I   135_A      -       -           -
LGA    A   136_A      -       -           -
LGA    L   137_A      -       -           -
LGA    I   138_A      L     148           #
LGA    P   139_A      G     149          5.187
LGA    E   140_A      G     150           #
LGA    V   141_A      A     151          3.315
LGA    N   142_A      V     152          2.642
LGA    E   143_A      L     153          2.223
LGA    K   144_A      D     154          2.210
LGA    V   145_A      L     155          2.663
LGA    L   146_A      W     156          4.062
LGA    K   147_A      V     157          4.598
LGA    S   148_A      S     158          4.947
LGA    E   149_A      D     159           #
LGA    E   150_A      S     160           #
LGA    G   151_A      G     161          5.095
LGA    Y   152_A      A     162          3.964
LGA    F   153_A      F     163          3.078
LGA    L   154_A      L     164          1.669
LGA    L   155_A      L     165          0.704
LGA    H   156_A      E     166          1.360
LGA    L   157_A      V     167          1.640
LGA    D   158_A      D     168          1.796
LGA    L   159_A      P     169          2.705
LGA    K   160_A      A     170          3.177
LGA    F   161_A      Y     171          4.253
LGA    R   162_A      R     172           #
LGA    I   163_A      I     173           #
LGA    Q   164_A      -       -           -
LGA    P   165_A      -       -           -
LGA    F   166_A      L     174           #
LGA    E   167_A      C     175           #
LGA    -       -      E     176           -
LGA    -       -      M     177           -
LGA    T   168_A      S     178           #
LGA    L   169_A      L     179           #
LGA    Q   170_A      E     180           #
LGA    T   171_A      A     181           #
LGA    -       -      W     182           -
LGA    -       -      L     183           -
LGA    -       -      A     184           -
LGA    -       -      Q     185           -
LGA    -       -      G     186           -
LGA    -       -      H     187           -
LGA    -       -      P     188           -
LGA    L   172_A      L     189          5.019
LGA    L   173_A      P     190           -
LGA    E   174_A      -       -           -
LGA    R   175_A      -       -           -
LGA    N   176_A      -       -           -
LGA    D   177_A      -       -           -
LGA    F   178_A      -       -           -
LGA    N   179_A      -       -           -
LGA    P   180_A      -       -           -
LGA    K   181_A      -       -           -
LGA    R   182_A      -       -           -
LGA    I   183_A      K     191           #
LGA    R   184_A      R     192           #
LGA    V   185_A      V     193          5.435
LGA    K   186_A      R     194          4.818
LGA    P   187_A      N     195          4.929
LGA    I   188_A      A     196           #
LGA    -       -      Y     197           -
LGA    G   189_A      D     198           #
LGA    I   190_A      R     199          3.759
LGA    D   191_A      -       -           -
LGA    F   192_A      -       -           -
LGA    V   193_A      R     200           #
LGA    G   194_A      T     201           #
LGA    R   195_A      W     202           #
LGA    V   196_A      E     203           #
LGA    Q   197_A      L     204           -
LGA    D   198_A      L     205           -
LGA    -       -      R     206           -
LGA    -       -      L     207           -
LGA    -       -      G     208           -
LGA    -       -      E     209           -
LGA    -       -      E     210           -
LGA    -       -      D     211           -
LGA    -       -      P     212           -
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    -       -      R     240           -
LGA    -       -      V     241           -
LGA    -       -      A     242           -
LGA    -       -      W     243           -
LGA    -       -      V     244           -
LGA    -       -      A     245           -
LGA    -       -      D     246           -
LGA    -       -      P     247           -
LGA    -       -      K     248           -
LGA    -       -      D     249           -
LGA    -       -      P     250           -
LGA    -       -      R     251           -
LGA    -       -      K     252           -
LGA    V   199_A      P     253          3.905
LGA    F   200_A      I     254          3.423
LGA    K   201_A      P     255          3.964
LGA    A   202_A      -       -           -
LGA    K   203_A      -       -           -
LGA    E   204_A      -       -           -
LGA    K   205_A      -       -           -
LGA    G   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    E   208_A      -       -           -
LGA    F   209_A      -       -           -
LGA    F   210_A      -       -           -
LGA    R   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    C   213_A      -       -           -
LGA    X   214_A      -       -           -
LGA    E   215_A      -       -           -
LGA    R   216_A      -       -           -
LGA    S   217_A      -       -           -
LGA    T   218_A      -       -           -
LGA    H   219_A      -       -           -
LGA    K   220_A      -       -           -
LGA    S   221_A      -       -           -
LGA    S   222_A      -       -           -
LGA    K   223_A      -       -           -
LGA    K   224_A      -       -           -
LGA    A   225_A      -       -           -
LGA    W   226_A      -       -           -
LGA    E   227_A      -       -           -
LGA    E   228_A      -       -           -
LGA    L   229_A      -       -           -
LGA    L   230_A      -       -           -
LGA    K   231_A      -       -           -
LGA    N   232_A      -       -           -
LGA    R   233_A      -       -           -
LGA    E   234_A      -       -           -
LGA    L   235_A      -       -           -
LGA    R   236_A      -       -           -
LGA    E   237_A      -       -           -
LGA    K   238_A      -       -           -
LGA    A   239_A      H     256          4.186
LGA    F   240_A      L     257          4.002
LGA    L   241_A      -       -           -
LGA    V   242_A      -       -           -
LGA    V   243_A      -       -           -
LGA    L   244_A      -       -           -
LGA    E   245_A      -       -           -
LGA    K   246_A      -       -           -
LGA    G   247_A      -       -           -
LGA    Y   248_A      -       -           -
LGA    T   249_A      -       -           -
LGA    Y   250_A      -       -           -
LGA    P   251_A      -       -           -
LGA    A   252_A      T     258           #
LGA    -       -      G     259           -
LGA    T   253_A      L     260          2.470
LGA    I   254_A      L     261          4.169
LGA    L   255_A      V     262          5.411
LGA    K   256_A      P     263          4.072
LGA    P   257_A      V     264          4.279
LGA    V   258_A      L     265           -
LGA    L   259_A      T     266           #
LGA    T   260_A      L     267           -
LGA    Y   261_A      -       -           -
LGA    E   268_A      -       -           -
LGA    R   269_A      E     268          4.446
LGA    N   270_A      D     269           -
LGA    E   271_A      L     270           -
LGA    -       -      H     271           -
LGA    -       -      E     272           -
LGA    V   272_A      S     276          3.485
LGA    A   273_A      L     277           -
LGA    D   274_A      A     278           #
LGA    I   275_A      L     279          4.232
LGA    V   276_A      S     280          2.973
LGA    R   277_A      -       -           -
LGA    X   278_A      L     281          1.746
LGA    E   279_A      P     282          0.832
LGA    P   280_A      W     283          1.210
LGA    G   281_A      E     284          1.698
LGA    K   282_A      E     285          2.179
LGA    R   283_A      R     286          2.154
LGA    L   284_A      R     287          1.744
LGA    N   285_A      R     288          1.971
LGA    L   286_A      R     289          1.978
LGA    I   287_A      T     290          1.853
LGA    R   288_A      R     291          1.966
LGA    Y   289_A      E     292          2.454
LGA    I   290_A      I     293          1.730
LGA    L   291_A      A     294          1.778
LGA    R   292_A      S     295          2.510
LGA    R   293_A      W     296          2.288
LGA    Y   294_A      I     297          1.660
LGA    V   295_A      G     298          2.712
LGA    K   296_A      R     299          3.061
LGA    A   297_A      R     300          2.279
LGA    L   298_A      L     301          3.134
LGA    R   299_A      G     302          3.437
LGA    D   300_A      -       -           -
LGA    Y   301_A      -       -           -
LGA    G   302_A      -       -           -
LGA    W   303_A      L     303          1.768
LGA    Y   304_A      G     304          1.595
LGA    I   305_A      T     305          3.493
LGA    S   306_A      P     306          1.577
LGA    P   307_A      E     307          4.588
LGA    E   308_A      A     308          2.764
LGA    E   309_A      -       -           -
LGA    E   310_A      V     309          1.553
LGA    R   311_A      R     310          1.832
LGA    A   312_A      A     311          2.601
LGA    K   313_A      Q     312          1.189
LGA    G   314_A      A     313          1.803
LGA    K   315_A      Y     314          1.364
LGA    L   316_A      R     315          4.132
LGA    N   317_A      L     316          1.875
LGA    F   318_A      S     317          3.691
LGA    K   319_A      I     318           #
LGA    D   320_A      P     319          0.941
LGA    T   321_A      K     320          1.053
LGA    V   322_A      L     321          1.326
LGA    L   323_A      M     322          1.708
LGA    D   324_A      G     323          1.569
LGA    A   325_A      R     324           #
LGA    K   326_A      -       -           -
LGA    G   327_A      -       -           -
LGA    K   328_A      R     325          2.709
LGA    N   329_A      A     326          3.226
LGA    T   330_A      V     327          4.618
LGA    K   331_A      -       -           -
LGA    V   332_A      -       -           -
LGA    I   333_A      -       -           -
LGA    T   334_A      -       -           -
LGA    N   335_A      S     328          2.722
LGA    L   336_A      K     329          5.277
LGA    R   337_A      P     330           -
LGA    K   338_A      A     331           -
LGA    F   339_A      D     332          5.076
LGA    L   340_A      A     333          3.841
LGA    E   341_A      L     334           #
LGA    L   342_A      R     335           #
LGA    C   343_A      V     336          2.808
LGA    R   344_A      G     337          2.332
LGA    P   345_A      F     338          0.831
LGA    -       -      Y     339           -
LGA    F   346_A      R     340          2.741
LGA    V   347_A      A     341          2.422
LGA    K   348_A      Q     342           #
LGA    K   349_A      E     343          4.144
LGA    D   350_A      T     344          3.103
LGA    V   351_A      A     345          4.524
LGA    L   352_A      L     346          3.805
LGA    S   353_A      A     347          3.949
LGA    V   354_A      L     348          4.195
LGA    -       -      L     349           -
LGA    -       -      R     350           -
LGA    -       -      L     351           -
LGA    -       -      D     352           -
LGA    -       -      G     353           -
LGA    -       -      A     354           -
LGA    E   355_A      Q     355           #
LGA    I   356_A      G     356          2.769
LGA    I   357_A      W     357           #
LGA    S   358_A      P     358           #
LGA    V   359_A      -       -           -
LGA    S   360_A      -       -           -
LGA    V   361_A      -       -           -
LGA    W   367_A      -       -           -
LGA    R   368_A      -       -           -
LGA    K   369_A      -       -           -
LGA    E   370_A      -       -           -
LGA    E   371_A      -       -           -
LGA    F   372_A      E     359           #
LGA    L   373_A      F     360          2.991
LGA    K   374_A      L     361           -
LGA    E   375_A      R     362           -
LGA    L   376_A      -       -           -
LGA    I   377_A      R     363          2.271
LGA    N   378_A      A     364           #
LGA    -       -      L     365           -
LGA    -       -      L     366           -
LGA    F   379_A      R     367          2.393
LGA    L   380_A      A     368          2.362
LGA    K   381_A      F     369          4.282
LGA    N   382_A      G     370          2.077
LGA    K   383_A      A     371          2.186
LGA    -       -      S     372           -
LGA    -       -      G     373           -
LGA    G   384_A      A     374          3.204
LGA    I   385_A      S     375          5.319
LGA    K   386_A      L     376          3.773
LGA    L   387_A      R     377          5.366
LGA    K   388_A      L     378          3.496
LGA    I   389_A      H     379           #
LGA    K   390_A      -       -           -
LGA    G   391_A      T     380           #
LGA    K   392_A      L     381           -
LGA    S   393_A      H     382           -
LGA    L   394_A      A     383           -
LGA    I   395_A      -       -           -
LGA    L   396_A      -       -           -
LGA    A   397_A      -       -           -
LGA    Q   398_A      -       -           -
LGA    T   399_A      -       -           -
LGA    R   400_A      -       -           -
LGA    E   401_A      -       -           -
LGA    E   402_A      -       -           -
LGA    A   403_A      -       -           -
LGA    K   404_A      -       -           -
LGA    E   405_A      -       -           -
LGA    K   406_A      -       -           -
LGA    L   407_A      -       -           -
LGA    I   408_A      -       -           -
LGA    P   409_A      -       -           -
LGA    V   410_A      -       -           -
LGA    I   411_A      H     384           #
LGA    N   412_A      P     385          3.394
LGA    K   413_A      S     386           -
LGA    -       -      Q     387           -
LGA    -       -      G     388           -
LGA    -       -      L     389           -
LGA    -       -      A     390           -
LGA    I   414_A      F     391           #
LGA    -       -      R     392           -
LGA    -       -      E     393           -
LGA    -       -      A     394           -
LGA    K   415_A      L     395           #
LGA    -       -      R     396           -
LGA    -       -      K     397           -
LGA    D   416_A      A     398          4.764
LGA    V   417_A      K     399           -
LGA    -       -      E     400           -
LGA    -       -      E     401           -
LGA    -       -      G     402           -
LGA    -       -      V     403           -
LGA    -       -      Q     404           -
LGA    -       -      A     405           -
LGA    D   418_A      V     406          3.418
LGA    L   419_A      L     407          3.197
LGA    V   420_A      V     408          5.600
LGA    I   421_A      L     409           #
LGA    V   422_A      -       -           -
LGA    F   423_A      -       -           -
LGA    L   424_A      -       -           -
LGA    E   425_A      -       -           -
LGA    F   436_A      -       -           -
LGA    L   437_A      -       -           -
LGA    L   438_A      -       -           -
LGA    Y   439_A      -       -           -
LGA    D   440_A      -       -           -
LGA    F   441_A      -       -           -
LGA    V   442_A      T     410          3.184
LGA    K   443_A      P     411          4.883
LGA    R   444_A      P     412          3.206
LGA    E   445_A      M     413          4.738
LGA    L   446_A      A     414           -
LGA    -       -      W     415           -
LGA    -       -      E     416           -
LGA    -       -      D     417           -
LGA    L   447_A      R     418          5.092
LGA    -       -      N     419           -
LGA    K   448_A      R     420           #
LGA    K   449_A      L     421          3.926
LGA    X   450_A      K     422          4.269
LGA    I   451_A      A     423           -
LGA    -       -      L     424           -
LGA    -       -      L     425           -
LGA    -       -      L     426           -
LGA    -       -      R     427           -
LGA    -       -      E     428           -
LGA    -       -      G     429           -
LGA    -       -      L     430           -
LGA    -       -      P     431           -
LGA    -       -      S     432           -
LGA    P   452_A      Q     433          3.164
LGA    -       -      I     434           -
LGA    S   453_A      L     435          3.397
LGA    Q   454_A      N     436           #
LGA    -       -      V     437           -
LGA    V   455_A      P     438           #
LGA    I   456_A      L     439          3.542
LGA    L   457_A      R     440          1.255
LGA    N   458_A      E     441          4.901
LGA    R   459_A      -       -           -
LGA    T   460_A      -       -           -
LGA    L   461_A      E     442          3.537
LGA    K   462_A      E     443           -
LGA    N   463_A      -       -           -
LGA    E   464_A      -       -           -
LGA    N   465_A      -       -           -
LGA    L   466_A      -       -           -
LGA    K   467_A      -       -           -
LGA    F   468_A      -       -           -
LGA    V   469_A      -       -           -
LGA    L   470_A      -       -           -
LGA    L   471_A      R     444           #
LGA    N   472_A      H     445          5.041
LGA    V   473_A      R     446           #
LGA    -       -      W     447           -
LGA    A   474_A      E     448          5.005
LGA    E   475_A      N     449           #
LGA    Q   476_A      A     450          4.548
LGA    V   477_A      L     451          1.957
LGA    L   478_A      L     452          3.849
LGA    A   479_A      G     453          3.542
LGA    K   480_A      L     454          1.692
LGA    T   481_A      L     455          2.316
LGA    G   482_A      A     456          2.739
LGA    -       -      K     457           -
LGA    -       -      A     458           -
LGA    -       -      G     459           -
LGA    N   483_A      L     460          3.621
LGA    I   484_A      Q     461          4.239
LGA    P   485_A      V     462          2.996
LGA    Y   486_A      V     463          1.158
LGA    K   487_A      A     464          1.804
LGA    L   488_A      L     465          0.726
LGA    K   489_A      S     466          1.530
LGA    E   490_A      G     467          1.453
LGA    I   491_A      A     468          4.755
LGA    E   492_A      Y     469          3.162
LGA    G   493_A      P     470          2.311
LGA    K   494_A      -       -           -
LGA    V   495_A      A     471          1.572
LGA    D   496_A      E     472          2.977
LGA    A   497_A      L     473          1.402
LGA    F   498_A      A     474          0.516
LGA    V   499_A      V     475          1.006
LGA    G   500_A      G     476          0.459
LGA    I   501_A      F     477          0.350
LGA    D   502_A      D     478          0.761
LGA    I   503_A      A     479          1.662
LGA    S   504_A      G     480          3.886
LGA    -       -      G     481           -
LGA    R   505_A      R     482          4.327
LGA    I   506_A      E     483           -
LGA    T   507_A      -       -           -
LGA    R   508_A      -       -           -
LGA    D   509_A      -       -           -
LGA    G   510_A      -       -           -
LGA    K   511_A      -       -           -
LGA    T   512_A      S     484           #
LGA    V   513_A      F     485           -
LGA    N   514_A      R     486           #
LGA    A   515_A      F     487          1.993
LGA    V   516_A      G     488          1.788
LGA    A   517_A      G     489          1.143
LGA    F   518_A      A     490          0.950
LGA    T   519_A      A     491          0.667
LGA    K   520_A      C     492          0.972
LGA    I   521_A      A     493          1.437
LGA    F   522_A      V     494          1.608
LGA    N   523_A      G     495          1.681
LGA    S   524_A      G     496          2.342
LGA    K   525_A      D     497          1.053
LGA    G   526_A      G     498          2.910
LGA    E   527_A      G     499          2.772
LGA    L   528_A      H     500          1.471
LGA    V   529_A      L     501          1.058
LGA    R   530_A      L     502          1.679
LGA    Y   531_A      W     503          1.362
LGA    Y   532_A      T     504          0.765
LGA    L   533_A      L     505          2.595
LGA    T   534_A      P     506          3.712
LGA    -       -      E     507           -
LGA    S   535_A      A     508           #
LGA    Y   536_A      Q     509           -
LGA    P   537_A      A     510           #
LGA    A   538_A      G     511           #
LGA    F   539_A      E     512          1.835
LGA    G   540_A      -       -           -
LGA    E   541_A      -       -           -
LGA    K   542_A      R     513          2.750
LGA    L   543_A      I     514          3.474
LGA    T   544_A      P     515          0.764
LGA    E   545_A      Q     516          2.512
LGA    K   546_A      E     517          2.695
LGA    A   547_A      V     518          1.233
LGA    I   548_A      V     519          1.484
LGA    G   549_A      W     520          2.241
LGA    D   550_A      D     521          1.032
LGA    V   551_A      L     522          2.056
LGA    F   552_A      L     523          3.550
LGA    S   553_A      E     524          2.520
LGA    L   554_A      E     525          1.389
LGA    L   555_A      T     526          3.968
LGA    E   556_A      L     527          4.320
LGA    K   557_A      W     528          2.357
LGA    L   558_A      A     529          3.611
LGA    -       -      F     530           -
LGA    G   559_A      R     531          2.736
LGA    -       -      R     532           -
LGA    -       -      K     533           -
LGA    -       -      A     534           -
LGA    -       -      G     535           -
LGA    -       -      R     536           -
LGA    F   560_A      L     537          1.463
LGA    K   561_A      P     538           #
LGA    K   562_A      -       -           -
LGA    G   563_A      -       -           -
LGA    S   564_A      S     539          2.443
LGA    K   565_A      R     540          1.499
LGA    I   566_A      V     541          1.528
LGA    V   567_A      L     542          1.059
LGA    V   568_A      L     543          0.446
LGA    H   569_A      L     544          0.390
LGA    R   570_A      R     545          0.646
LGA    D   571_A      D     546          2.655
LGA    G   572_A      G     547          3.466
LGA    R   573_A      R     548          2.898
LGA    L   574_A      V     549          3.469
LGA    Y   575_A      P     550          1.567
LGA    R   576_A      Q     551          4.205
LGA    D   577_A      D     552          3.570
LGA    E   578_A      E     553          0.946
LGA    V   579_A      F     554          3.196
LGA    A   580_A      A     555          2.370
LGA    A   581_A      L     556          2.758
LGA    F   582_A      A     557          2.432
LGA    K   583_A      L     558          2.884
LGA    K   584_A      E     559          3.109
LGA    Y   585_A      A     560          2.748
LGA    G   586_A      L     561          2.935
LGA    E   587_A      A     562          3.705
LGA    L   588_A      R     563          4.028
LGA    Y   589_A      E     564          3.209
LGA    G   590_A      G     565          3.639
LGA    Y   591_A      I     566          2.568
LGA    S   592_A      A     567          2.014
LGA    L   593_A      Y     568          2.634
LGA    E   594_A      D     569          1.426
LGA    L   595_A      L     570          1.104
LGA    L   596_A      V     571          1.130
LGA    E   597_A      S     572          0.890
LGA    I   598_A      V     573          0.383
LGA    I   599_A      R     574          0.192
LGA    K   600_A      K     575          0.637
LGA    R   601_A      S     576          1.665
LGA    N   602_A      G     577          2.776
LGA    N   603_A      G     578          1.866
LGA    P   604_A      G     579          0.677
LGA    R   605_A      R     580          1.042
LGA    F   606_A      V     581          1.329
LGA    F   607_A      Y     582          2.007
LGA    S   608_A      P     583          3.069
LGA    -       -      V     584           -
LGA    -       -      Q     585           -
LGA    N   609_A      G     586           #
LGA    E   610_A      R     587          2.081
LGA    K   611_A      L     588          3.964
LGA    F   612_A      A     589          1.426
LGA    I   613_A      D     590          3.448
LGA    K   614_A      G     591          1.593
LGA    G   615_A      L     592          1.514
LGA    Y   616_A      Y     593          3.515
LGA    F   617_A      V     594          0.911
LGA    Y   618_A      P     595          3.995
LGA    K   619_A      L     596          0.830
LGA    L   620_A      E     597          2.615
LGA    S   621_A      -       -           -
LGA    E   622_A      D     598           #
LGA    D   623_A      K     599          0.921
LGA    S   624_A      T     600          1.652
LGA    V   625_A      F     601          1.398
LGA    I   626_A      L     602          2.279
LGA    L   627_A      L     603          2.149
LGA    A   628_A      L     604          1.252
LGA    T   629_A      -       -           -
LGA    Y   630_A      T     605          1.531
LGA    N   631_A      V     606          2.269
LGA    Q   632_A      H     607          4.372
LGA    V   633_A      R     608          3.037
LGA    -       -      D     609           -
LGA    Y   634_A      F     610          2.505
LGA    E   635_A      R     611          1.977
LGA    G   636_A      G     612          1.415
LGA    T   637_A      T     613           #
LGA    H   638_A      P     614          1.427
LGA    Q   639_A      R     615          1.619
LGA    P   640_A      P     616          0.318
LGA    I   641_A      L     617          0.489
LGA    K   642_A      K     618          0.540
LGA    V   643_A      L     619          0.333
LGA    R   644_A      V     620          0.736
LGA    K   645_A      H     621          1.179
LGA    V   646_A      E     622          1.481
LGA    Y   647_A      A     623          1.371
LGA    G   648_A      G     624          1.419
LGA    E   649_A      D     625          1.436
LGA    L   650_A      T     626          1.290
LGA    P   651_A      P     627          2.290
LGA    V   652_A      L     628          2.138
LGA    E   653_A      E     629          2.173
LGA    V   654_A      A     630          1.718
LGA    L   655_A      L     631          1.146
LGA    C   656_A      A     632          1.240
LGA    S   657_A      H     633          1.243
LGA    Q   658_A      Q     634          0.823
LGA    I   659_A      I     635          0.743
LGA    L   660_A      F     636          0.529
LGA    S   661_A      H     637          0.709
LGA    L   662_A      L     638          0.446
LGA    T   663_A      T     639          1.224
LGA    L   664_A      R     640          2.193
LGA    X   665_A      L     641          1.965
LGA    N   666_A      Y     642          0.855
LGA    Y   667_A      -       -           -
LGA    S   668_A      -       -           -
LGA    S   669_A      -       -           -
LGA    F   670_A      -       -           -
LGA    Q   671_A      -       -           -
LGA    P   672_A      -       -           -
LGA    I   673_A      -       -           -
LGA    K   674_A      -       -           -
LGA    L   675_A      -       -           -
LGA    P   676_A      -       -           -
LGA    A   677_A      -       -           -
LGA    T   678_A      -       -           -
LGA    V   679_A      -       -           -
LGA    H   680_A      -       -           -
LGA    Y   681_A      -       -           -
LGA    S   682_A      -       -           -
LGA    D   683_A      -       -           -
LGA    K   684_A      -       -           -
LGA    I   685_A      -       -           -
LGA    T   686_A      -       -           -
LGA    K   687_A      -       -           -
LGA    L   688_A      -       -           -
LGA    X   689_A      -       -           -
LGA    L   690_A      -       -           -
LGA    R   691_A      -       -           -
LGA    G   692_A      -       -           -
LGA    I   693_A      -       -           -
LGA    E   694_A      -       -           -
LGA    P   695_A      -       -           -
LGA    I   696_A      -       -           -
LGA    K   697_A      -       -           -
LGA    K   698_A      -       -           -
LGA    E   699_A      -       -           -
LGA    G   700_A      -       -           -
LGA    D   701_A      -       -           -
LGA    I   702_A      -       -           -
LGA    X   703_A      -       -           -
LGA    Y   704_A      -       -           -
LGA    W   705_A      -       -           -
LGA    L   706_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  682  637    5.0    361    2.81    17.17     33.146    12.419

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.949304 * X  +   0.175050 * Y  +   0.261113 * Z  +  59.776005
  Y_new =  -0.134210 * X  +   0.525432 * Y  +  -0.840184 * Z  +  16.036001
  Z_new =  -0.284271 * X  +  -0.832634 * Y  +  -0.475301 * Z  + 127.300636 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.089499    1.052094  [ DEG:  -119.7195     60.2805 ]
  Theta =   0.288246    2.853346  [ DEG:    16.5153    163.4847 ]
  Phi   =  -3.001146    0.140447  [ DEG:  -171.9530      8.0470 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yvu_A                                        
REMARK     2: T0487.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yvu_A.T0487.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  682  637   5.0  361   2.81   17.17  33.146
REMARK  ---------------------------------------------------------- 
MOLECULE 1yvu_A
HEADER    RNA BINDING PROTEIN, GENE REGULATION    16-FEB-05   1YVU              
TITLE     CRYSTAL STRUCTURE OF A. AEOLICUS ARGONAUTE                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN AQ_1447;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS VF5;                           
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET28B                                    
KEYWDS    RNASE H FOLD                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.R.YUAN,Y.PEI,J.B.MA,V.KURYAVYI,M.ZHADINA,G.MEISTER,                 
AUTHOR   2 H.Y.CHEN,Z.DAUTER,T.TUSCHL,D.J.PATEL                                 
REVDAT   1   09-AUG-05 1YVU    0                                                
JRNL        AUTH   Y.R.YUAN,Y.PEI,J.B.MA,V.KURYAVYI,M.ZHADINA,                  
JRNL        AUTH 2 G.MEISTER,H.Y.CHEN,Z.DAUTER,T.TUSCHL,D.J.PATEL               
JRNL        TITL   CRYSTAL STRUCTURE OF A. AEOLICUS ARGONAUTE                   
JRNL        TITL 2 PROVIDES UNIQUE PERSPECTIVES INTO THE MECHANISM OF           
JRNL        TITL 3 GUIDE STRAND-MEDIATED MRNA CLEAVAGE                          
JRNL        REF    MOL. CELL                     V.  19   405 2005              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 2.90 ANGSTROMS.                                          
DBREF  1YVU A    1   706  UNP    O67434   O67434_AQUAE     1    706             
SEQRES   1 A  706  MET GLY LYS GLU ALA LEU LEU ASN LEU TYR ARG ILE GLU          
SEQRES   2 A  706  TYR ARG PRO LYS ASP THR THR PHE THR VAL PHE LYS PRO          
SEQRES   3 A  706  THR HIS GLU ILE GLN LYS GLU LYS LEU ASN LYS VAL ARG          
SEQRES   4 A  706  TRP ARG VAL PHE LEU GLN THR GLY LEU PRO THR PHE ARG          
SEQRES   5 A  706  ARG GLU ASP GLU PHE TRP CYS ALA GLY LYS VAL GLU LYS          
SEQRES   6 A  706  ASP THR LEU TYR LEU THR LEU SER ASN GLY GLU ILE VAL          
SEQRES   7 A  706  GLU LEU LYS ARG VAL GLY GLU GLU GLU PHE ARG GLY PHE          
SEQRES   8 A  706  GLN ASN GLU ARG GLU CYS GLN GLU LEU PHE ARG ASP PHE          
SEQRES   9 A  706  LEU THR LYS THR LYS VAL LYS ASP LYS PHE ILE SER ASP          
SEQRES  10 A  706  PHE TYR LYS LYS PHE ARG ASP LYS ILE THR VAL GLN GLY          
SEQRES  11 A  706  LYS ASN ARG LYS ILE ALA LEU ILE PRO GLU VAL ASN GLU          
SEQRES  12 A  706  LYS VAL LEU LYS SER GLU GLU GLY TYR PHE LEU LEU HIS          
SEQRES  13 A  706  LEU ASP LEU LYS PHE ARG ILE GLN PRO PHE GLU THR LEU          
SEQRES  14 A  706  GLN THR LEU LEU GLU ARG ASN ASP PHE ASN PRO LYS ARG          
SEQRES  15 A  706  ILE ARG VAL LYS PRO ILE GLY ILE ASP PHE VAL GLY ARG          
SEQRES  16 A  706  VAL GLN ASP VAL PHE LYS ALA LYS GLU LYS GLY GLU GLU          
SEQRES  17 A  706  PHE PHE ARG LEU CYS MSE GLU ARG SER THR HIS LYS SER          
SEQRES  18 A  706  SER LYS LYS ALA TRP GLU GLU LEU LEU LYS ASN ARG GLU          
SEQRES  19 A  706  LEU ARG GLU LYS ALA PHE LEU VAL VAL LEU GLU LYS GLY          
SEQRES  20 A  706  TYR THR TYR PRO ALA THR ILE LEU LYS PRO VAL LEU THR          
SEQRES  21 A  706  TYR GLU ASN LEU GLU ASP GLU GLU ARG ASN GLU VAL ALA          
SEQRES  22 A  706  ASP ILE VAL ARG MSE GLU PRO GLY LYS ARG LEU ASN LEU          
SEQRES  23 A  706  ILE ARG TYR ILE LEU ARG ARG TYR VAL LYS ALA LEU ARG          
SEQRES  24 A  706  ASP TYR GLY TRP TYR ILE SER PRO GLU GLU GLU ARG ALA          
SEQRES  25 A  706  LYS GLY LYS LEU ASN PHE LYS ASP THR VAL LEU ASP ALA          
SEQRES  26 A  706  LYS GLY LYS ASN THR LYS VAL ILE THR ASN LEU ARG LYS          
SEQRES  27 A  706  PHE LEU GLU LEU CYS ARG PRO PHE VAL LYS LYS ASP VAL          
SEQRES  28 A  706  LEU SER VAL GLU ILE ILE SER VAL SER VAL TYR LYS LYS          
SEQRES  29 A  706  LEU GLU TRP ARG LYS GLU GLU PHE LEU LYS GLU LEU ILE          
SEQRES  30 A  706  ASN PHE LEU LYS ASN LYS GLY ILE LYS LEU LYS ILE LYS          
SEQRES  31 A  706  GLY LYS SER LEU ILE LEU ALA GLN THR ARG GLU GLU ALA          
SEQRES  32 A  706  LYS GLU LYS LEU ILE PRO VAL ILE ASN LYS ILE LYS ASP          
SEQRES  33 A  706  VAL ASP LEU VAL ILE VAL PHE LEU GLU GLU TYR PRO LYS          
SEQRES  34 A  706  VAL ASP PRO TYR LYS SER PHE LEU LEU TYR ASP PHE VAL          
SEQRES  35 A  706  LYS ARG GLU LEU LEU LYS LYS MSE ILE PRO SER GLN VAL          
SEQRES  36 A  706  ILE LEU ASN ARG THR LEU LYS ASN GLU ASN LEU LYS PHE          
SEQRES  37 A  706  VAL LEU LEU ASN VAL ALA GLU GLN VAL LEU ALA LYS THR          
SEQRES  38 A  706  GLY ASN ILE PRO TYR LYS LEU LYS GLU ILE GLU GLY LYS          
SEQRES  39 A  706  VAL ASP ALA PHE VAL GLY ILE ASP ILE SER ARG ILE THR          
SEQRES  40 A  706  ARG ASP GLY LYS THR VAL ASN ALA VAL ALA PHE THR LYS          
SEQRES  41 A  706  ILE PHE ASN SER LYS GLY GLU LEU VAL ARG TYR TYR LEU          
SEQRES  42 A  706  THR SER TYR PRO ALA PHE GLY GLU LYS LEU THR GLU LYS          
SEQRES  43 A  706  ALA ILE GLY ASP VAL PHE SER LEU LEU GLU LYS LEU GLY          
SEQRES  44 A  706  PHE LYS LYS GLY SER LYS ILE VAL VAL HIS ARG ASP GLY          
SEQRES  45 A  706  ARG LEU TYR ARG ASP GLU VAL ALA ALA PHE LYS LYS TYR          
SEQRES  46 A  706  GLY GLU LEU TYR GLY TYR SER LEU GLU LEU LEU GLU ILE          
SEQRES  47 A  706  ILE LYS ARG ASN ASN PRO ARG PHE PHE SER ASN GLU LYS          
SEQRES  48 A  706  PHE ILE LYS GLY TYR PHE TYR LYS LEU SER GLU ASP SER          
SEQRES  49 A  706  VAL ILE LEU ALA THR TYR ASN GLN VAL TYR GLU GLY THR          
SEQRES  50 A  706  HIS GLN PRO ILE LYS VAL ARG LYS VAL TYR GLY GLU LEU          
SEQRES  51 A  706  PRO VAL GLU VAL LEU CYS SER GLN ILE LEU SER LEU THR          
SEQRES  52 A  706  LEU MSE ASN TYR SER SER PHE GLN PRO ILE LYS LEU PRO          
SEQRES  53 A  706  ALA THR VAL HIS TYR SER ASP LYS ILE THR LYS LEU MSE          
SEQRES  54 A  706  LEU ARG GLY ILE GLU PRO ILE LYS LYS GLU GLY ASP ILE          
SEQRES  55 A  706  MSE TYR TRP LEU                                              
HET    MSE  A 214       8                                                       
HET    MSE  A 278       8                                                       
HET    MSE  A 450       8                                                       
HET    MSE  A 665       8                                                       
HET    MSE  A 689       8                                                       
HET    MSE  A 703       8                                                       
HET     CA    901       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CA CALCIUM ION                                                      
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   2   CA    CA 2+                                                        
FORMUL   3  HOH   *69(H2 O)                                                     
CRYST1   64.150  100.679  115.217  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   GLU A   4      20.251  -1.156  38.178  1.00 66.66           N  
ATOM      2  CA  GLU A   4      19.532  -0.550  39.338  1.00 68.83           C  
ATOM      3  C   GLU A   4      20.410   0.583  39.874  1.00 65.50           C  
ATOM      4  O   GLU A   4      20.906   0.508  41.006  1.00 68.87           O  
ATOM      5  CB  GLU A   4      19.304  -1.620  40.428  1.00 82.39           C  
ATOM      6  CG  GLU A   4      18.684  -2.956  39.926  1.00 93.20           C  
ATOM      7  CD  GLU A   4      18.648  -4.068  40.993  1.00 97.56           C  
ATOM      8  OE1 GLU A   4      18.546  -3.741  42.205  1.00100.79           O  
ATOM      9  OE2 GLU A   4      18.714  -5.270  40.613  1.00 97.93           O  
ATOM     10  N   ALA A   5      20.641   1.591  39.022  1.00 59.13           N  
ATOM     11  CA  ALA A   5      21.462   2.801  39.296  1.00 48.34           C  
ATOM     12  C   ALA A   5      22.996   2.672  39.433  1.00 43.27           C  
ATOM     13  O   ALA A   5      23.510   2.231  40.475  1.00 46.11           O  
ATOM     14  CB  ALA A   5      20.886   3.603  40.453  1.00 46.14           C  
ATOM     15  N   LEU A   6      23.713   3.116  38.394  1.00 32.85           N  
ATOM     16  CA  LEU A   6      25.170   3.039  38.347  1.00 24.55           C  
ATOM     17  C   LEU A   6      25.872   4.277  38.877  1.00 20.74           C  
ATOM     18  O   LEU A   6      25.303   5.359  38.850  1.00 15.79           O  
ATOM     19  CB  LEU A   6      25.645   2.792  36.915  1.00 18.63           C  
ATOM     20  CG  LEU A   6      25.142   1.607  36.117  1.00 13.14           C  
ATOM     21  CD1 LEU A   6      25.978   1.505  34.856  1.00 18.48           C  
ATOM     22  CD2 LEU A   6      25.294   0.373  36.902  1.00  9.30           C  
ATOM     23  N   LEU A   7      27.107   4.089  39.366  1.00 20.80           N  
ATOM     24  CA  LEU A   7      27.950   5.160  39.899  1.00 11.91           C  
ATOM     25  C   LEU A   7      29.399   5.040  39.415  1.00 14.09           C  
ATOM     26  O   LEU A   7      29.897   3.919  39.197  1.00 16.65           O  
ATOM     27  CB  LEU A   7      28.015   5.135  41.426  1.00  9.85           C  
ATOM     28  CG  LEU A   7      26.864   5.433  42.385  1.00  5.25           C  
ATOM     29  CD1 LEU A   7      26.393   4.127  42.990  1.00 13.66           C  
ATOM     30  CD2 LEU A   7      27.280   6.346  43.498  1.00  4.55           C  
ATOM     31  N   ASN A   8      30.094   6.195  39.475  1.00 19.79           N  
ATOM     32  CA  ASN A   8      31.515   6.436  39.132  1.00 15.86           C  
ATOM     33  C   ASN A   8      32.459   5.634  39.996  1.00 16.64           C  
ATOM     34  O   ASN A   8      33.604   6.075  40.217  1.00 16.90           O  
ATOM     35  CB  ASN A   8      31.911   7.865  39.527  1.00 26.26           C  
ATOM     36  CG  ASN A   8      31.252   8.908  38.737  1.00 16.94           C  
ATOM     37  OD1 ASN A   8      31.767   9.337  37.711  1.00 17.79           O  
ATOM     38  ND2 ASN A   8      30.137   9.390  39.240  1.00 20.27           N  
ATOM     39  N   LEU A   9      31.971   4.557  40.607  1.00 16.13           N  
ATOM     40  CA  LEU A   9      32.789   3.749  41.517  1.00 13.86           C  
ATOM     41  C   LEU A   9      33.154   2.408  40.955  1.00 15.44           C  
ATOM     42  O   LEU A   9      32.294   1.701  40.481  1.00 21.22           O  
ATOM     43  CB  LEU A   9      32.074   3.584  42.854  1.00 13.70           C  
ATOM     44  CG  LEU A   9      31.646   4.885  43.543  1.00  8.93           C  
ATOM     45  CD1 LEU A   9      30.559   4.651  44.539  1.00  5.40           C  
ATOM     46  CD2 LEU A   9      32.826   5.535  44.163  1.00  3.09           C  
ATOM     47  N   TYR A  10      34.441   2.086  40.964  1.00 16.58           N  
ATOM     48  CA  TYR A  10      34.929   0.823  40.432  1.00 20.26           C  
ATOM     49  C   TYR A  10      35.917   0.201  41.405  1.00 21.30           C  
ATOM     50  O   TYR A  10      36.877   0.879  41.802  1.00 20.47           O  
ATOM     51  CB  TYR A  10      35.700   1.074  39.138  1.00 27.39           C  
ATOM     52  CG  TYR A  10      34.964   1.841  38.087  1.00 21.53           C  
ATOM     53  CD1 TYR A  10      35.013   3.258  38.052  1.00 22.97           C  
ATOM     54  CD2 TYR A  10      34.168   1.168  37.148  1.00 25.01           C  
ATOM     55  CE1 TYR A  10      34.245   3.988  37.093  1.00 31.46           C  
ATOM     56  CE2 TYR A  10      33.417   1.871  36.185  1.00 28.56           C  
ATOM     57  CZ  TYR A  10      33.445   3.280  36.169  1.00 33.03           C  
ATOM     58  OH  TYR A  10      32.629   3.955  35.289  1.00 32.99           O  
ATOM     59  N   ARG A  11      35.760  -1.107  41.686  1.00 19.92           N  
ATOM     60  CA  ARG A  11      36.653  -1.843  42.596  1.00 11.39           C  
ATOM     61  C   ARG A  11      38.044  -1.791  42.051  1.00  8.82           C  
ATOM     62  O   ARG A  11      38.260  -2.094  40.897  1.00 11.73           O  
ATOM     63  CB  ARG A  11      36.254  -3.307  42.785  1.00 13.70           C  
ATOM     64  CG  ARG A  11      35.027  -3.465  43.632  1.00 24.43           C  
ATOM     65  CD  ARG A  11      34.772  -4.882  44.145  1.00 44.12           C  
ATOM     66  NE  ARG A  11      33.654  -4.878  45.106  1.00 54.47           N  
ATOM     67  CZ  ARG A  11      32.893  -5.927  45.423  1.00 61.22           C  
ATOM     68  NH1 ARG A  11      33.111  -7.114  44.866  1.00 63.92           N  
ATOM     69  NH2 ARG A  11      31.892  -5.776  46.291  1.00 58.43           N  
ATOM     70  N   ILE A  12      38.929  -1.204  42.840  1.00 12.63           N  
ATOM     71  CA  ILE A  12      40.327  -1.079  42.491  1.00 17.26           C  
ATOM     72  C   ILE A  12      41.149  -2.031  43.377  1.00 14.12           C  
ATOM     73  O   ILE A  12      40.817  -2.282  44.540  1.00 21.09           O  
ATOM     74  CB  ILE A  12      40.806   0.425  42.523  1.00 13.04           C  
ATOM     75  CG1 ILE A  12      42.241   0.539  42.042  1.00 10.69           C  
ATOM     76  CG2 ILE A  12      40.648   1.061  43.902  1.00  8.70           C  
ATOM     77  CD1 ILE A  12      42.639   1.922  41.736  1.00 18.58           C  
ATOM     78  N   GLU A  13      42.186  -2.607  42.791  1.00 18.61           N  
ATOM     79  CA  GLU A  13      43.036  -3.552  43.486  1.00 17.55           C  
ATOM     80  C   GLU A  13      44.493  -3.398  43.081  1.00 21.57           C  
ATOM     81  O   GLU A  13      44.789  -2.990  41.954  1.00 24.64           O  
ATOM     82  CB  GLU A  13      42.558  -4.980  43.191  1.00 16.73           C  
ATOM     83  CG  GLU A  13      41.597  -5.534  44.232  1.00 25.09           C  
ATOM     84  CD  GLU A  13      40.519  -6.439  43.666  1.00 22.82           C  
ATOM     85  OE1 GLU A  13      40.759  -7.186  42.697  1.00 25.69           O  
ATOM     86  OE2 GLU A  13      39.409  -6.418  44.225  1.00 26.91           O  
ATOM     87  N   TYR A  14      45.384  -3.649  44.039  1.00 25.91           N  
ATOM     88  CA  TYR A  14      46.829  -3.587  43.825  1.00 22.88           C  
ATOM     89  C   TYR A  14      47.514  -4.873  44.357  1.00 24.48           C  
ATOM     90  O   TYR A  14      47.498  -5.166  45.563  1.00 28.01           O  
ATOM     91  CB  TYR A  14      47.426  -2.330  44.470  1.00 18.96           C  
ATOM     92  CG  TYR A  14      48.877  -2.072  44.114  1.00 18.86           C  
ATOM     93  CD1 TYR A  14      49.321  -2.129  42.779  1.00 13.51           C  
ATOM     94  CD2 TYR A  14      49.818  -1.771  45.109  1.00 15.53           C  
ATOM     95  CE1 TYR A  14      50.663  -1.899  42.437  1.00 23.30           C  
ATOM     96  CE2 TYR A  14      51.177  -1.535  44.782  1.00 22.02           C  
ATOM     97  CZ  TYR A  14      51.596  -1.607  43.440  1.00 26.23           C  
ATOM     98  OH  TYR A  14      52.941  -1.477  43.108  1.00 19.25           O  
ATOM     99  N   ARG A  15      48.084  -5.641  43.426  1.00 25.96           N  
ATOM    100  CA  ARG A  15      48.795  -6.896  43.710  1.00 29.68           C  
ATOM    101  C   ARG A  15      50.138  -6.840  42.915  1.00 33.81           C  
ATOM    102  O   ARG A  15      50.305  -7.592  41.943  1.00 31.75           O  
ATOM    103  CB  ARG A  15      47.964  -8.108  43.222  1.00 18.10           C  
ATOM    104  CG  ARG A  15      46.522  -8.192  43.704  1.00 23.14           C  
ATOM    105  CD  ARG A  15      45.826  -9.429  43.114  1.00 15.98           C  
ATOM    106  NE  ARG A  15      44.366  -9.338  42.922  1.00 15.81           N  
ATOM    107  CZ  ARG A  15      43.458  -9.194  43.886  1.00 17.59           C  
ATOM    108  NH1 ARG A  15      43.818  -9.078  45.156  1.00 22.06           N  
ATOM    109  NH2 ARG A  15      42.172  -9.292  43.592  1.00 21.01           N  
ATOM    110  N   PRO A  16      51.118  -6.001  43.348  1.00 35.07           N  
ATOM    111  CA  PRO A  16      52.413  -5.874  42.640  1.00 34.96           C  
ATOM    112  C   PRO A  16      53.314  -7.101  42.447  1.00 42.72           C  
ATOM    113  O   PRO A  16      53.313  -8.044  43.264  1.00 40.06           O  
ATOM    114  CB  PRO A  16      53.116  -4.747  43.396  1.00 36.25           C  
ATOM    115  CG  PRO A  16      52.637  -4.895  44.776  1.00 31.22           C  
ATOM    116  CD  PRO A  16      51.168  -5.260  44.629  1.00 28.74           C  
ATOM    117  N   LYS A  17      54.008  -7.094  41.300  1.00 51.70           N  
ATOM    118  CA  LYS A  17      54.950  -8.149  40.907  1.00 56.08           C  
ATOM    119  C   LYS A  17      56.201  -7.990  41.801  1.00 58.96           C  
ATOM    120  O   LYS A  17      56.403  -8.775  42.734  1.00 57.99           O  
ATOM    121  CB  LYS A  17      55.298  -8.024  39.405  1.00 63.44           C  
ATOM    122  CG  LYS A  17      54.090  -7.988  38.418  1.00 66.53           C  
ATOM    123  CD  LYS A  17      54.531  -7.816  36.932  1.00 63.23           C  
ATOM    124  CE  LYS A  17      53.353  -7.922  35.956  1.00 63.28           C  
ATOM    125  NZ  LYS A  17      53.714  -7.692  34.526  1.00 53.17           N  
ATOM    126  N   ASP A  18      56.968  -6.916  41.577  1.00 63.53           N  
ATOM    127  CA  ASP A  18      58.162  -6.591  42.377  1.00 66.03           C  
ATOM    128  C   ASP A  18      57.608  -5.865  43.610  1.00 64.47           C  
ATOM    129  O   ASP A  18      57.351  -4.655  43.587  1.00 64.35           O  
ATOM    130  CB  ASP A  18      59.132  -5.697  41.566  1.00 66.15           C  
ATOM    131  CG  ASP A  18      60.474  -5.457  42.282  1.00 70.66           C  
ATOM    132  OD1 ASP A  18      60.588  -4.446  43.002  1.00 68.98           O  
ATOM    133  OD2 ASP A  18      61.420  -6.269  42.122  1.00 75.23           O  
ATOM    134  N   THR A  19      57.378  -6.640  44.662  1.00 61.57           N  
ATOM    135  CA  THR A  19      56.812  -6.150  45.926  1.00 61.05           C  
ATOM    136  C   THR A  19      57.827  -5.438  46.853  1.00 56.70           C  
ATOM    137  O   THR A  19      57.516  -5.143  48.009  1.00 56.03           O  
ATOM    138  CB  THR A  19      56.099  -7.329  46.676  1.00 63.68           C  
ATOM    139  OG1 THR A  19      55.647  -8.300  45.722  1.00 72.63           O  
ATOM    140  CG2 THR A  19      54.873  -6.843  47.413  1.00 62.89           C  
ATOM    141  N   THR A  20      59.021  -5.144  46.328  1.00 55.71           N  
ATOM    142  CA  THR A  20      60.086  -4.471  47.088  1.00 56.75           C  
ATOM    143  C   THR A  20      59.926  -2.945  47.078  1.00 53.18           C  
ATOM    144  O   THR A  20      59.807  -2.317  46.011  1.00 48.35           O  
ATOM    145  CB  THR A  20      61.513  -4.850  46.588  1.00 61.69           C  
ATOM    146  OG1 THR A  20      61.553  -6.238  46.218  1.00 57.76           O  
ATOM    147  CG2 THR A  20      62.532  -4.617  47.706  1.00 54.84           C  
ATOM    148  N   PHE A  21      59.865  -2.395  48.300  1.00 51.57           N  
ATOM    149  CA  PHE A  21      59.685  -0.961  48.612  1.00 48.46           C  
ATOM    150  C   PHE A  21      60.759  -0.373  49.544  1.00 48.63           C  
ATOM    151  O   PHE A  21      61.069  -0.960  50.590  1.00 48.05           O  
ATOM    152  CB  PHE A  21      58.328  -0.730  49.322  1.00 45.37           C  
ATOM    153  CG  PHE A  21      57.152  -0.578  48.407  1.00 41.46           C  
ATOM    154  CD1 PHE A  21      56.928  -1.466  47.329  1.00 42.34           C  
ATOM    155  CD2 PHE A  21      56.219   0.426  48.654  1.00 49.87           C  
ATOM    156  CE1 PHE A  21      55.784  -1.368  46.510  1.00 44.56           C  
ATOM    157  CE2 PHE A  21      55.059   0.549  47.842  1.00 51.41           C  
ATOM    158  CZ  PHE A  21      54.840  -0.357  46.767  1.00 47.19           C  
ATOM    159  N   THR A  22      61.219   0.837  49.215  1.00 44.98           N  
ATOM    160  CA  THR A  22      62.206   1.558  50.014  1.00 44.68           C  
ATOM    161  C   THR A  22      61.530   2.532  51.013  1.00 38.19           C  
ATOM    162  O   THR A  22      60.772   3.430  50.629  1.00 32.57           O  
ATOM    163  CB  THR A  22      63.202   2.309  49.102  1.00 45.60           C  
ATOM    164  OG1 THR A  22      63.725   1.394  48.134  1.00 47.37           O  
ATOM    165  CG2 THR A  22      64.370   2.873  49.907  1.00 45.27           C  
ATOM    166  N   VAL A  23      61.807   2.321  52.298  1.00 38.16           N  
ATOM    167  CA  VAL A  23      61.249   3.142  53.375  1.00 41.50           C  
ATOM    168  C   VAL A  23      62.166   4.326  53.703  1.00 46.13           C  
ATOM    169  O   VAL A  23      63.398   4.233  53.616  1.00 45.07           O  
ATOM    170  CB  VAL A  23      61.001   2.303  54.677  1.00 38.60           C  
ATOM    171  CG1 VAL A  23      60.159   3.079  55.671  1.00 30.25           C  
ATOM    172  CG2 VAL A  23      60.324   0.985  54.349  1.00 35.07           C  
ATOM    173  N   PHE A  24      61.523   5.450  54.030  1.00 50.31           N  
ATOM    174  CA  PHE A  24      62.169   6.707  54.400  1.00 46.49           C  
ATOM    175  C   PHE A  24      61.458   7.317  55.616  1.00 54.38           C  
ATOM    176  O   PHE A  24      60.257   7.545  55.560  1.00 57.50           O  
ATOM    177  CB  PHE A  24      62.175   7.710  53.226  1.00 38.57           C  
ATOM    178  CG  PHE A  24      63.146   7.366  52.120  1.00 44.61           C  
ATOM    179  CD1 PHE A  24      62.690   6.839  50.907  1.00 40.39           C  
ATOM    180  CD2 PHE A  24      64.535   7.501  52.311  1.00 48.70           C  
ATOM    181  CE1 PHE A  24      63.611   6.439  49.888  1.00 39.45           C  
ATOM    182  CE2 PHE A  24      65.469   7.102  51.299  1.00 45.37           C  
ATOM    183  CZ  PHE A  24      65.001   6.568  50.095  1.00 37.39           C  
ATOM    184  N   LYS A  25      62.168   7.491  56.722  1.00 62.19           N  
ATOM    185  CA  LYS A  25      61.576   8.113  57.916  1.00 61.69           C  
ATOM    186  C   LYS A  25      62.417   9.367  58.234  1.00 67.28           C  
ATOM    187  O   LYS A  25      63.655   9.329  58.052  1.00 71.58           O  
ATOM    188  CB  LYS A  25      61.565   7.138  59.107  1.00 62.33           C  
ATOM    189  CG  LYS A  25      60.450   7.410  60.132  1.00 61.72           C  
ATOM    190  CD  LYS A  25      60.835   6.954  61.544  1.00 69.96           C  
ATOM    191  CE  LYS A  25      59.712   7.202  62.540  1.00 66.70           C  
ATOM    192  NZ  LYS A  25      60.128   6.894  63.930  1.00 63.41           N  
ATOM    193  N   PRO A  26      61.774  10.510  58.642  1.00 71.16           N  
ATOM    194  CA  PRO A  26      62.544  11.731  58.954  1.00 69.37           C  
ATOM    195  C   PRO A  26      63.389  11.593  60.207  1.00 73.65           C  
ATOM    196  O   PRO A  26      63.117  10.740  61.063  1.00 77.41           O  
ATOM    197  CB  PRO A  26      61.464  12.791  59.153  1.00 67.22           C  
ATOM    198  CG  PRO A  26      60.318  12.271  58.351  1.00 65.15           C  
ATOM    199  CD  PRO A  26      60.330  10.825  58.697  1.00 63.16           C  
ATOM    200  N   THR A  27      64.445  12.389  60.297  1.00 78.83           N  
ATOM    201  CA  THR A  27      65.282  12.341  61.490  1.00 83.66           C  
ATOM    202  C   THR A  27      64.746  13.365  62.501  1.00 90.74           C  
ATOM    203  O   THR A  27      65.143  13.379  63.668  1.00 87.13           O  
ATOM    204  CB  THR A  27      66.778  12.579  61.167  1.00 77.00           C  
ATOM    205  OG1 THR A  27      67.029  12.255  59.794  1.00 83.59           O  
ATOM    206  CG2 THR A  27      67.665  11.673  62.011  1.00 84.10           C  
ATOM    207  N   HIS A  28      63.784  14.165  62.038  1.00 90.97           N  
ATOM    208  CA  HIS A  28      63.131  15.201  62.839  1.00 97.04           C  
ATOM    209  C   HIS A  28      61.728  14.738  63.297  1.00 98.48           C  
ATOM    210  O   HIS A  28      61.559  13.577  63.671  1.00 94.92           O  
ATOM    211  CB  HIS A  28      62.997  16.545  62.095  1.00 98.17           C  
ATOM    212  CG  HIS A  28      63.853  16.692  60.873  1.00104.12           C  
ATOM    213  ND1 HIS A  28      64.783  17.697  60.738  1.00104.72           N  
ATOM    214  CD2 HIS A  28      63.830  16.035  59.678  1.00103.76           C  
ATOM    215  CE1 HIS A  28      65.295  17.667  59.520  1.00107.26           C  
ATOM    216  NE2 HIS A  28      64.732  16.667  58.865  1.00107.00           N  
ATOM    217  N   GLU A  29      60.738  15.642  63.208  1.00101.80           N  
ATOM    218  CA  GLU A  29      59.343  15.415  63.646  1.00107.05           C  
ATOM    219  C   GLU A  29      58.231  15.281  62.578  1.00109.73           C  
ATOM    220  O   GLU A  29      58.480  15.296  61.367  1.00106.77           O  
ATOM    221  CB  GLU A  29      58.924  16.533  64.625  1.00112.26           C  
ATOM    222  CG  GLU A  29      59.850  16.818  65.808  1.00117.45           C  
ATOM    223  CD  GLU A  29      59.513  18.131  66.523  1.00121.87           C  
ATOM    224  OE1 GLU A  29      58.919  19.046  65.902  1.00123.44           O  
ATOM    225  OE2 GLU A  29      59.852  18.244  67.723  1.00124.15           O  
ATOM    226  N   ILE A  30      56.995  15.184  63.080  1.00110.37           N  
ATOM    227  CA  ILE A  30      55.767  15.050  62.286  1.00112.23           C  
ATOM    228  C   ILE A  30      55.082  16.429  62.190  1.00111.69           C  
ATOM    229  O   ILE A  30      54.850  17.072  63.224  1.00112.84           O  
ATOM    230  CB  ILE A  30      54.726  14.057  62.975  1.00111.44           C  
ATOM    231  CG1 ILE A  30      55.424  13.079  63.945  1.00115.29           C  
ATOM    232  CG2 ILE A  30      53.953  13.280  61.905  1.00110.91           C  
ATOM    233  CD1 ILE A  30      54.480  12.336  64.921  1.00110.49           C  
ATOM    234  N   GLN A  31      54.772  16.882  60.969  1.00113.70           N  
ATOM    235  CA  GLN A  31      54.069  18.160  60.753  1.00112.37           C  
ATOM    236  C   GLN A  31      52.940  18.005  59.743  1.00105.60           C  
ATOM    237  O   GLN A  31      53.145  18.161  58.549  1.00102.22           O  
ATOM    238  CB  GLN A  31      55.047  19.282  60.375  1.00116.15           C  
ATOM    239  CG  GLN A  31      55.565  20.091  61.585  1.00124.52           C  
ATOM    240  CD  GLN A  31      56.835  20.891  61.317  1.00126.05           C  
ATOM    241  OE1 GLN A  31      57.437  20.815  60.243  1.00130.07           O  
ATOM    242  NE2 GLN A  31      57.238  21.667  62.316  1.00126.59           N  
ATOM    243  N   LYS A  32      51.756  17.690  60.276  1.00105.08           N  
ATOM    244  CA  LYS A  32      50.492  17.422  59.558  1.00100.50           C  
ATOM    245  C   LYS A  32      50.175  18.014  58.186  1.00101.78           C  
ATOM    246  O   LYS A  32      49.836  17.277  57.245  1.00 97.79           O  
ATOM    247  CB  LYS A  32      49.289  17.641  60.484  1.00 97.98           C  
ATOM    248  CG  LYS A  32      49.127  16.554  61.558  1.00100.99           C  
ATOM    249  CD  LYS A  32      47.824  16.679  62.348  1.00100.46           C  
ATOM    250  CE  LYS A  32      47.734  15.591  63.411  1.00 92.76           C  
ATOM    251  NZ  LYS A  32      46.573  15.773  64.306  1.00 90.79           N  
ATOM    252  N   GLU A  33      50.285  19.336  58.079  1.00 99.56           N  
ATOM    253  CA  GLU A  33      49.995  20.070  56.844  1.00 90.99           C  
ATOM    254  C   GLU A  33      51.107  19.844  55.819  1.00 87.88           C  
ATOM    255  O   GLU A  33      50.850  19.698  54.608  1.00 87.85           O  
ATOM    256  CB  GLU A  33      49.858  21.573  57.160  1.00 99.40           C  
ATOM    257  CG  GLU A  33      48.753  21.938  58.187  1.00102.27           C  
ATOM    258  CD  GLU A  33      49.185  22.953  59.272  1.00100.70           C  
ATOM    259  OE1 GLU A  33      50.181  23.695  59.078  1.00104.62           O  
ATOM    260  OE2 GLU A  33      48.515  23.010  60.331  1.00100.07           O  
ATOM    261  N   LYS A  34      52.321  19.718  56.357  1.00 83.51           N  
ATOM    262  CA  LYS A  34      53.542  19.530  55.590  1.00 78.78           C  
ATOM    263  C   LYS A  34      53.842  18.117  55.168  1.00 72.98           C  
ATOM    264  O   LYS A  34      54.646  17.918  54.265  1.00 74.13           O  
ATOM    265  CB  LYS A  34      54.718  20.105  56.366  1.00 82.56           C  
ATOM    266  CG  LYS A  34      54.488  21.559  56.713  1.00 92.28           C  
ATOM    267  CD  LYS A  34      55.525  22.083  57.671  1.00101.95           C  
ATOM    268  CE  LYS A  34      55.114  23.460  58.164  1.00101.35           C  
ATOM    269  NZ  LYS A  34      56.076  24.044  59.159  1.00106.88           N  
ATOM    270  N   LEU A  35      53.187  17.147  55.806  1.00 69.40           N  
ATOM    271  CA  LEU A  35      53.384  15.733  55.503  1.00 60.54           C  
ATOM    272  C   LEU A  35      52.999  15.403  54.081  1.00 59.83           C  
ATOM    273  O   LEU A  35      53.746  14.717  53.379  1.00 61.99           O  
ATOM    274  CB  LEU A  35      52.597  14.861  56.473  1.00 53.82           C  
ATOM    275  CG  LEU A  35      53.194  14.677  57.870  1.00 46.35           C  
ATOM    276  CD1 LEU A  35      52.232  13.893  58.719  1.00 40.99           C  
ATOM    277  CD2 LEU A  35      54.528  13.985  57.809  1.00 50.09           C  
ATOM    278  N   ASN A  36      51.903  16.016  53.627  1.00 61.97           N  
ATOM    279  CA  ASN A  36      51.375  15.822  52.271  1.00 58.20           C  
ATOM    280  C   ASN A  36      52.248  16.459  51.187  1.00 59.51           C  
ATOM    281  O   ASN A  36      52.253  16.005  50.026  1.00 48.64           O  
ATOM    282  CB  ASN A  36      49.954  16.375  52.177  1.00 63.04           C  
ATOM    283  CG  ASN A  36      48.925  15.294  51.957  1.00 63.19           C  
ATOM    284  OD1 ASN A  36      48.805  14.743  50.856  1.00 64.42           O  
ATOM    285  ND2 ASN A  36      48.175  14.979  53.005  1.00 60.67           N  
ATOM    286  N   LYS A  37      53.006  17.483  51.610  1.00 60.88           N  
ATOM    287  CA  LYS A  37      53.939  18.245  50.758  1.00 58.63           C  
ATOM    288  C   LYS A  37      55.272  17.513  50.601  1.00 54.42           C  
ATOM    289  O   LYS A  37      55.879  17.538  49.526  1.00 48.68           O  
ATOM    290  CB  LYS A  37      54.224  19.623  51.360  1.00 63.21           C  
ATOM    291  CG  LYS A  37      53.012  20.514  51.579  1.00 63.31           C  
ATOM    292  CD  LYS A  37      53.451  21.814  52.264  1.00 67.28           C  
ATOM    293  CE  LYS A  37      52.273  22.760  52.545  1.00 69.21           C  
ATOM    294  NZ  LYS A  37      52.695  24.081  53.133  1.00 61.20           N  
ATOM    295  N   VAL A  38      55.703  16.852  51.676  1.00 47.94           N  
ATOM    296  CA  VAL A  38      56.954  16.108  51.693  1.00 48.29           C  
ATOM    297  C   VAL A  38      56.831  14.890  50.833  1.00 44.59           C  
ATOM    298  O   VAL A  38      57.707  14.618  50.026  1.00 43.26           O  
ATOM    299  CB  VAL A  38      57.341  15.682  53.108  1.00 54.78           C  
ATOM    300  CG1 VAL A  38      58.659  14.860  53.101  1.00 56.65           C  
ATOM    301  CG2 VAL A  38      57.500  16.919  53.983  1.00 60.19           C  
ATOM    302  N   ARG A  39      55.719  14.181  51.023  1.00 44.00           N  
ATOM    303  CA  ARG A  39      55.361  12.966  50.288  1.00 43.66           C  
ATOM    304  C   ARG A  39      55.380  13.244  48.776  1.00 46.32           C  
ATOM    305  O   ARG A  39      55.795  12.387  47.980  1.00 47.91           O  
ATOM    306  CB  ARG A  39      53.993  12.461  50.792  1.00 46.74           C  
ATOM    307  CG  ARG A  39      53.241  11.444  49.921  1.00 44.50           C  
ATOM    308  CD  ARG A  39      51.943  12.087  49.450  1.00 49.96           C  
ATOM    309  NE  ARG A  39      51.302  11.463  48.296  1.00 47.73           N  
ATOM    310  CZ  ARG A  39      51.835  11.331  47.079  1.00 53.55           C  
ATOM    311  NH1 ARG A  39      53.059  11.748  46.795  1.00 47.61           N  
ATOM    312  NH2 ARG A  39      51.074  10.886  46.093  1.00 63.67           N  
ATOM    313  N   TRP A  40      55.019  14.479  48.410  1.00 40.79           N  
ATOM    314  CA  TRP A  40      55.004  14.910  47.024  1.00 43.88           C  
ATOM    315  C   TRP A  40      56.446  15.033  46.539  1.00 45.65           C  
ATOM    316  O   TRP A  40      56.799  14.536  45.459  1.00 43.80           O  
ATOM    317  CB  TRP A  40      54.229  16.240  46.892  1.00 38.77           C  
ATOM    318  CG  TRP A  40      54.304  16.901  45.528  1.00 49.17           C  
ATOM    319  CD1 TRP A  40      54.973  18.058  45.224  1.00 48.48           C  
ATOM    320  CD2 TRP A  40      53.789  16.397  44.281  1.00 50.84           C  
ATOM    321  NE1 TRP A  40      54.928  18.296  43.868  1.00 56.06           N  
ATOM    322  CE2 TRP A  40      54.210  17.296  43.263  1.00 53.76           C  
ATOM    323  CE3 TRP A  40      53.021  15.268  43.913  1.00 55.42           C  
ATOM    324  CZ2 TRP A  40      53.886  17.098  41.892  1.00 54.35           C  
ATOM    325  CZ3 TRP A  40      52.697  15.072  42.541  1.00 56.59           C  
ATOM    326  CH2 TRP A  40      53.135  15.989  41.554  1.00 51.82           C  
ATOM    327  N   ARG A  41      57.281  15.610  47.404  1.00 44.17           N  
ATOM    328  CA  ARG A  41      58.695  15.839  47.130  1.00 40.42           C  
ATOM    329  C   ARG A  41      59.540  14.583  47.154  1.00 40.78           C  
ATOM    330  O   ARG A  41      60.508  14.502  46.378  1.00 36.29           O  
ATOM    331  CB  ARG A  41      59.236  16.893  48.076  1.00 42.73           C  
ATOM    332  CG  ARG A  41      58.558  18.238  47.869  1.00 50.34           C  
ATOM    333  CD  ARG A  41      59.053  19.283  48.863  1.00 56.45           C  
ATOM    334  NE  ARG A  41      58.670  20.666  48.543  1.00 57.98           N  
ATOM    335  CZ  ARG A  41      59.057  21.343  47.459  1.00 56.46           C  
ATOM    336  NH1 ARG A  41      59.832  20.785  46.523  1.00 61.27           N  
ATOM    337  NH2 ARG A  41      58.789  22.640  47.378  1.00 63.09           N  
ATOM    338  N   VAL A  42      59.127  13.590  47.974  1.00 37.02           N  
ATOM    339  CA  VAL A  42      59.816  12.278  48.078  1.00 31.17           C  
ATOM    340  C   VAL A  42      59.617  11.606  46.741  1.00 26.98           C  
ATOM    341  O   VAL A  42      60.514  11.000  46.226  1.00 28.64           O  
ATOM    342  CB  VAL A  42      59.232  11.278  49.112  1.00 29.29           C  
ATOM    343  CG1 VAL A  42      60.178  10.063  49.273  1.00 29.32           C  
ATOM    344  CG2 VAL A  42      59.026  11.904  50.436  1.00 31.06           C  
ATOM    345  N   PHE A  43      58.430  11.755  46.181  1.00 24.37           N  
ATOM    346  CA  PHE A  43      58.104  11.206  44.878  1.00 26.96           C  
ATOM    347  C   PHE A  43      58.866  11.977  43.751  1.00 31.76           C  
ATOM    348  O   PHE A  43      59.317  11.367  42.786  1.00 29.59           O  
ATOM    349  CB  PHE A  43      56.557  11.213  44.742  1.00 28.36           C  
ATOM    350  CG  PHE A  43      56.032  11.118  43.327  1.00 25.17           C  
ATOM    351  CD1 PHE A  43      56.361  10.025  42.482  1.00 17.19           C  
ATOM    352  CD2 PHE A  43      55.219  12.157  42.821  1.00 21.63           C  
ATOM    353  CE1 PHE A  43      55.896   9.973  41.147  1.00 22.29           C  
ATOM    354  CE2 PHE A  43      54.739  12.122  41.484  1.00 19.12           C  
ATOM    355  CZ  PHE A  43      55.083  11.027  40.648  1.00 24.10           C  
ATOM    356  N   LEU A  44      59.084  13.282  43.918  1.00 36.41           N  
ATOM    357  CA  LEU A  44      59.795  14.073  42.904  1.00 42.99           C  
ATOM    358  C   LEU A  44      61.289  13.773  42.748  1.00 46.96           C  
ATOM    359  O   LEU A  44      61.764  13.573  41.622  1.00 39.70           O  
ATOM    360  CB  LEU A  44      59.605  15.572  43.153  1.00 44.34           C  
ATOM    361  CG  LEU A  44      58.245  16.239  42.928  1.00 45.37           C  
ATOM    362  CD1 LEU A  44      58.477  17.735  43.020  1.00 45.76           C  
ATOM    363  CD2 LEU A  44      57.641  15.890  41.571  1.00 36.11           C  
ATOM    364  N   GLN A  45      62.009  13.730  43.883  1.00 53.66           N  
ATOM    365  CA  GLN A  45      63.459  13.456  43.942  1.00 53.55           C  
ATOM    366  C   GLN A  45      63.834  12.013  43.621  1.00 56.15           C  
ATOM    367  O   GLN A  45      64.859  11.754  42.971  1.00 55.69           O  
ATOM    368  CB  GLN A  45      64.027  13.852  45.305  1.00 66.83           C  
ATOM    369  CG  GLN A  45      64.301  15.340  45.418  1.00 69.04           C  
ATOM    370  CD  GLN A  45      65.378  15.679  46.435  1.00 74.83           C  
ATOM    371  OE1 GLN A  45      66.402  14.995  46.537  1.00 73.16           O  
ATOM    372  NE2 GLN A  45      65.159  16.765  47.174  1.00 79.35           N  
ATOM    373  N   THR A  46      62.960  11.099  44.046  1.00 57.94           N  
ATOM    374  CA  THR A  46      63.085   9.654  43.830  1.00 57.25           C  
ATOM    375  C   THR A  46      62.692   9.328  42.395  1.00 58.29           C  
ATOM    376  O   THR A  46      63.523   8.914  41.587  1.00 59.15           O  
ATOM    377  CB  THR A  46      62.145   8.845  44.787  1.00 59.78           C  
ATOM    378  OG1 THR A  46      62.371   9.246  46.144  1.00 68.90           O  
ATOM    379  CG2 THR A  46      62.413   7.386  44.707  1.00 70.79           C  
ATOM    380  N   GLY A  47      61.419   9.545  42.099  1.00 52.91           N  
ATOM    381  CA  GLY A  47      60.897   9.261  40.779  1.00 54.45           C  
ATOM    382  C   GLY A  47      60.029   8.027  40.834  1.00 53.17           C  
ATOM    383  O   GLY A  47      59.496   7.604  39.811  1.00 54.08           O  
ATOM    384  N   LEU A  48      59.909   7.437  42.025  1.00 47.30           N  
ATOM    385  CA  LEU A  48      59.106   6.233  42.232  1.00 47.49           C  
ATOM    386  C   LEU A  48      57.904   6.567  43.098  1.00 47.46           C  
ATOM    387  O   LEU A  48      58.041   7.314  44.071  1.00 45.68           O  
ATOM    388  CB  LEU A  48      59.930   5.139  42.947  1.00 47.75           C  
ATOM    389  CG  LEU A  48      61.188   4.538  42.301  1.00 42.19           C  
ATOM    390  CD1 LEU A  48      62.043   3.908  43.349  1.00 36.06           C  
ATOM    391  CD2 LEU A  48      60.843   3.540  41.210  1.00 51.00           C  
ATOM    392  N   PRO A  49      56.690   6.084  42.714  1.00 43.81           N  
ATOM    393  CA  PRO A  49      55.428   6.283  43.433  1.00 38.77           C  
ATOM    394  C   PRO A  49      55.575   6.124  44.953  1.00 36.64           C  
ATOM    395  O   PRO A  49      56.233   5.195  45.426  1.00 34.88           O  
ATOM    396  CB  PRO A  49      54.552   5.208  42.819  1.00 38.55           C  
ATOM    397  CG  PRO A  49      54.885   5.351  41.395  1.00 37.51           C  
ATOM    398  CD  PRO A  49      56.401   5.473  41.396  1.00 46.08           C  
ATOM    399  N   THR A  50      54.951   7.018  45.703  1.00 25.23           N  
ATOM    400  CA  THR A  50      55.100   7.016  47.136  1.00 18.73           C  
ATOM    401  C   THR A  50      53.805   7.111  47.895  1.00 19.04           C  
ATOM    402  O   THR A  50      52.832   7.665  47.413  1.00 26.50           O  
ATOM    403  CB  THR A  50      56.015   8.240  47.545  1.00 19.81           C  
ATOM    404  OG1 THR A  50      57.269   8.150  46.863  1.00  8.03           O  
ATOM    405  CG2 THR A  50      56.280   8.333  49.053  1.00 10.88           C  
ATOM    406  N   PHE A  51      53.786   6.495  49.067  1.00 24.97           N  
ATOM    407  CA  PHE A  51      52.657   6.602  49.971  1.00 34.68           C  
ATOM    408  C   PHE A  51      53.172   6.856  51.390  1.00 33.73           C  
ATOM    409  O   PHE A  51      54.318   6.521  51.714  1.00 33.12           O  
ATOM    410  CB  PHE A  51      51.636   5.437  49.854  1.00 44.18           C  
ATOM    411  CG  PHE A  51      52.072   4.123  50.462  1.00 45.97           C  
ATOM    412  CD1 PHE A  51      51.889   3.865  51.837  1.00 47.90           C  
ATOM    413  CD2 PHE A  51      52.591   3.110  49.650  1.00 48.37           C  
ATOM    414  CE1 PHE A  51      52.208   2.620  52.401  1.00 48.28           C  
ATOM    415  CE2 PHE A  51      52.917   1.845  50.197  1.00 46.91           C  
ATOM    416  CZ  PHE A  51      52.724   1.600  51.581  1.00 52.70           C  
ATOM    417  N   ARG A  52      52.308   7.434  52.219  1.00 35.50           N  
ATOM    418  CA  ARG A  52      52.628   7.769  53.598  1.00 36.65           C  
ATOM    419  C   ARG A  52      51.952   6.820  54.602  1.00 37.26           C  
ATOM    420  O   ARG A  52      50.735   6.848  54.767  1.00 36.43           O  
ATOM    421  CB  ARG A  52      52.203   9.224  53.861  1.00 39.23           C  
ATOM    422  CG  ARG A  52      52.836   9.918  55.068  1.00 37.74           C  
ATOM    423  CD  ARG A  52      51.929  11.019  55.589  1.00 36.78           C  
ATOM    424  NE  ARG A  52      50.980  10.485  56.558  1.00 39.44           N  
ATOM    425  CZ  ARG A  52      49.677  10.751  56.590  1.00 42.44           C  
ATOM    426  NH1 ARG A  52      49.129  11.564  55.697  1.00 47.87           N  
ATOM    427  NH2 ARG A  52      48.909  10.160  57.501  1.00 44.73           N  
ATOM    428  N   ARG A  53      52.760   5.981  55.259  1.00 43.44           N  
ATOM    429  CA  ARG A  53      52.296   5.041  56.288  1.00 47.29           C  
ATOM    430  C   ARG A  53      52.737   5.685  57.598  1.00 49.66           C  
ATOM    431  O   ARG A  53      53.894   5.561  57.999  1.00 46.38           O  
ATOM    432  CB  ARG A  53      52.958   3.665  56.103  1.00 49.89           C  
ATOM    433  CG  ARG A  53      52.053   2.459  56.396  1.00 55.30           C  
ATOM    434  CD  ARG A  53      52.687   1.106  56.003  1.00 53.59           C  
ATOM    435  NE  ARG A  53      51.964   0.414  54.926  1.00 53.65           N  
ATOM    436  CZ  ARG A  53      52.122  -0.867  54.596  1.00 58.40           C  
ATOM    437  NH1 ARG A  53      52.984  -1.646  55.240  1.00 63.58           N  
ATOM    438  NH2 ARG A  53      51.398  -1.384  53.623  1.00 59.29           N  
ATOM    439  N   GLU A  54      51.820   6.443  58.205  1.00 56.83           N  
ATOM    440  CA  GLU A  54      52.038   7.197  59.453  1.00 61.87           C  
ATOM    441  C   GLU A  54      53.261   8.145  59.385  1.00 64.41           C  
ATOM    442  O   GLU A  54      53.126   9.275  58.912  1.00 69.17           O  
ATOM    443  CB  GLU A  54      52.076   6.285  60.708  1.00 62.69           C  
ATOM    444  CG  GLU A  54      50.800   5.425  61.003  1.00 68.84           C  
ATOM    445  CD  GLU A  54      49.603   6.176  61.620  1.00 67.88           C  
ATOM    446  OE1 GLU A  54      49.788   7.207  62.304  1.00 74.95           O  
ATOM    447  OE2 GLU A  54      48.457   5.699  61.438  1.00 66.25           O  
ATOM    448  N   ASP A  55      54.449   7.658  59.754  1.00 62.41           N  
ATOM    449  CA  ASP A  55      55.679   8.470  59.742  1.00 61.65           C  
ATOM    450  C   ASP A  55      56.653   8.073  58.658  1.00 56.68           C  
ATOM    451  O   ASP A  55      57.531   8.847  58.273  1.00 56.82           O  
ATOM    452  CB  ASP A  55      56.414   8.340  61.078  1.00 73.90           C  
ATOM    453  CG  ASP A  55      56.019   9.401  62.089  1.00 79.42           C  
ATOM    454  OD1 ASP A  55      55.444  10.444  61.695  1.00 80.33           O  
ATOM    455  OD2 ASP A  55      56.307   9.187  63.292  1.00 80.98           O  
ATOM    456  N   GLU A  56      56.527   6.824  58.233  1.00 54.04           N  
ATOM    457  CA  GLU A  56      57.384   6.221  57.231  1.00 53.58           C  
ATOM    458  C   GLU A  56      56.879   6.492  55.811  1.00 43.71           C  
ATOM    459  O   GLU A  56      55.709   6.302  55.531  1.00 47.29           O  
ATOM    460  CB  GLU A  56      57.448   4.701  57.504  1.00 62.97           C  
ATOM    461  CG  GLU A  56      57.965   4.293  58.930  1.00 70.09           C  
ATOM    462  CD  GLU A  56      57.848   2.783  59.266  1.00 74.42           C  
ATOM    463  OE1 GLU A  56      57.454   1.976  58.396  1.00 70.42           O  
ATOM    464  OE2 GLU A  56      58.165   2.404  60.422  1.00 74.49           O  
ATOM    465  N   PHE A  57      57.768   6.928  54.922  1.00 37.44           N  
ATOM    466  CA  PHE A  57      57.425   7.207  53.529  1.00 39.43           C  
ATOM    467  C   PHE A  57      57.861   6.060  52.625  1.00 39.52           C  
ATOM    468  O   PHE A  57      59.010   5.981  52.186  1.00 42.97           O  
ATOM    469  CB  PHE A  57      58.049   8.520  53.050  1.00 39.77           C  
ATOM    470  CG  PHE A  57      57.516   9.731  53.752  1.00 46.82           C  
ATOM    471  CD1 PHE A  57      57.917  10.026  55.071  1.00 43.78           C  
ATOM    472  CD2 PHE A  57      56.588  10.571  53.121  1.00 41.00           C  
ATOM    473  CE1 PHE A  57      57.396  11.142  55.762  1.00 48.92           C  
ATOM    474  CE2 PHE A  57      56.056  11.691  53.795  1.00 38.03           C  
ATOM    475  CZ  PHE A  57      56.459  11.977  55.121  1.00 46.80           C  
ATOM    476  N   TRP A  58      56.902   5.198  52.308  1.00 42.19           N  
ATOM    477  CA  TRP A  58      57.129   4.024  51.471  1.00 42.93           C  
ATOM    478  C   TRP A  58      57.168   4.345  49.975  1.00 40.12           C  
ATOM    479  O   TRP A  58      56.236   4.910  49.442  1.00 38.84           O  
ATOM    480  CB  TRP A  58      56.043   2.981  51.761  1.00 47.17           C  
ATOM    481  CG  TRP A  58      56.063   2.346  53.162  1.00 51.44           C  
ATOM    482  CD1 TRP A  58      56.045   2.992  54.361  1.00 47.56           C  
ATOM    483  CD2 TRP A  58      56.148   0.937  53.468  1.00 50.00           C  
ATOM    484  NE1 TRP A  58      56.126   2.089  55.397  1.00 44.08           N  
ATOM    485  CE2 TRP A  58      56.196   0.819  54.880  1.00 45.66           C  
ATOM    486  CE3 TRP A  58      56.197  -0.245  52.678  1.00 51.00           C  
ATOM    487  CZ2 TRP A  58      56.300  -0.439  55.533  1.00 47.91           C  
ATOM    488  CZ3 TRP A  58      56.301  -1.511  53.332  1.00 44.90           C  
ATOM    489  CH2 TRP A  58      56.353  -1.587  54.743  1.00 44.07           C  
ATOM    490  N   CYS A  59      58.239   3.944  49.300  1.00 37.94           N  
ATOM    491  CA  CYS A  59      58.393   4.201  47.869  1.00 39.06           C  
ATOM    492  C   CYS A  59      58.428   2.926  47.032  1.00 42.66           C  
ATOM    493  O   CYS A  59      59.154   2.007  47.347  1.00 41.29           O  
ATOM    494  CB  CYS A  59      59.650   5.026  47.633  1.00 39.46           C  
ATOM    495  SG  CYS A  59      59.656   6.518  48.601  1.00 36.62           S  
ATOM    496  N   ALA A  60      57.711   2.925  45.913  1.00 43.53           N  
ATOM    497  CA  ALA A  60      57.598   1.776  45.011  1.00 48.90           C  
ATOM    498  C   ALA A  60      58.768   1.361  44.118  1.00 50.70           C  
ATOM    499  O   ALA A  60      58.782   1.663  42.927  1.00 47.12           O  
ATOM    500  CB  ALA A  60      56.330   1.915  44.182  1.00 52.37           C  
ATOM    501  N   GLY A  61      59.687   0.585  44.677  1.00 56.16           N  
ATOM    502  CA  GLY A  61      60.832   0.117  43.916  1.00 69.64           C  
ATOM    503  C   GLY A  61      62.174   0.379  44.561  1.00 73.37           C  
ATOM    504  O   GLY A  61      62.259   0.892  45.682  1.00 75.54           O  
ATOM    505  N   LYS A  62      63.229   0.054  43.814  1.00 82.67           N  
ATOM    506  CA  LYS A  62      64.602   0.219  44.270  1.00 92.31           C  
ATOM    507  C   LYS A  62      65.305   1.431  43.673  1.00 95.62           C  
ATOM    508  O   LYS A  62      65.295   1.638  42.453  1.00 91.62           O  
ATOM    509  CB  LYS A  62      65.432  -1.043  43.974  1.00 97.05           C  
ATOM    510  CG  LYS A  62      64.914  -2.320  44.617  1.00 99.65           C  
ATOM    511  CD  LYS A  62      65.866  -3.487  44.401  1.00106.37           C  
ATOM    512  CE  LYS A  62      65.270  -4.769  44.974  1.00109.29           C  
ATOM    513  NZ  LYS A  62      66.207  -5.934  45.016  1.00110.87           N  
ATOM    514  N   VAL A  63      65.849   2.256  44.570  1.00103.86           N  
ATOM    515  CA  VAL A  63      66.627   3.451  44.218  1.00109.46           C  
ATOM    516  C   VAL A  63      68.058   3.018  44.557  1.00114.05           C  
ATOM    517  O   VAL A  63      68.346   2.674  45.717  1.00117.01           O  
ATOM    518  CB  VAL A  63      66.319   4.695  45.126  1.00102.82           C  
ATOM    519  CG1 VAL A  63      66.697   5.993  44.414  1.00104.49           C  
ATOM    520  CG2 VAL A  63      64.895   4.714  45.595  1.00105.14           C  
ATOM    521  N   GLU A  64      68.933   2.991  43.550  1.00117.24           N  
ATOM    522  CA  GLU A  64      70.334   2.605  43.746  1.00121.21           C  
ATOM    523  C   GLU A  64      71.110   3.737  44.416  1.00122.46           C  
ATOM    524  O   GLU A  64      70.812   4.914  44.181  1.00122.79           O  
ATOM    525  CB  GLU A  64      70.988   2.244  42.407  1.00122.26           C  
ATOM    526  CG  GLU A  64      70.361   1.033  41.713  1.00124.89           C  
ATOM    527  CD  GLU A  64      71.067   0.642  40.417  1.00132.06           C  
ATOM    528  OE1 GLU A  64      71.720   1.507  39.784  1.00132.53           O  
ATOM    529  OE2 GLU A  64      70.961  -0.543  40.025  1.00131.42           O  
ATOM    530  N   LYS A  65      72.053   3.362  45.290  1.00118.29           N  
ATOM    531  CA  LYS A  65      72.937   4.278  46.043  1.00118.93           C  
ATOM    532  C   LYS A  65      72.245   5.271  47.013  1.00114.76           C  
ATOM    533  O   LYS A  65      72.907   6.184  47.526  1.00115.23           O  
ATOM    534  CB  LYS A  65      73.879   5.051  45.079  1.00120.14           C  
ATOM    535  CG  LYS A  65      74.769   4.212  44.124  1.00119.17           C  
ATOM    536  CD  LYS A  65      75.184   5.060  42.906  1.00119.24           C  
ATOM    537  CE  LYS A  65      76.025   4.293  41.898  1.00117.21           C  
ATOM    538  NZ  LYS A  65      76.264   5.109  40.668  1.00115.12           N  
ATOM    539  N   ASP A  66      70.944   5.075  47.282  1.00118.68           N  
ATOM    540  CA  ASP A  66      70.155   5.956  48.175  1.00114.94           C  
ATOM    541  C   ASP A  66      70.610   5.992  49.644  1.00117.24           C  
ATOM    542  O   ASP A  66      70.679   4.957  50.321  1.00121.31           O  
ATOM    543  CB  ASP A  66      68.633   5.649  48.090  1.00114.44           C  
ATOM    544  CG  ASP A  66      68.218   4.365  48.844  1.00119.54           C  
ATOM    545  OD1 ASP A  66      68.571   3.253  48.391  1.00115.94           O  
ATOM    546  OD2 ASP A  66      67.555   4.476  49.906  1.00113.98           O  
ATOM    547  N   THR A  67      70.939   7.185  50.125  1.00114.81           N  
ATOM    548  CA  THR A  67      71.373   7.332  51.505  1.00112.10           C  
ATOM    549  C   THR A  67      70.369   8.257  52.181  1.00107.41           C  
ATOM    550  O   THR A  67      69.409   7.785  52.800  1.00103.64           O  
ATOM    551  CB  THR A  67      72.838   7.891  51.599  1.00110.94           C  
ATOM    552  OG1 THR A  67      73.624   7.359  50.524  1.00111.15           O  
ATOM    553  CG2 THR A  67      73.502   7.471  52.918  1.00114.03           C  
ATOM    554  N   LEU A  68      70.565   9.567  51.992  1.00102.79           N  
ATOM    555  CA  LEU A  68      69.724  10.616  52.574  1.00100.51           C  
ATOM    556  C   LEU A  68      68.981  11.447  51.545  1.00 89.54           C  
ATOM    557  O   LEU A  68      69.458  11.661  50.423  1.00 85.47           O  
ATOM    558  CB  LEU A  68      70.565  11.563  53.432  1.00 93.23           C  
ATOM    559  CG  LEU A  68      71.294  10.961  54.624  1.00 97.17           C  
ATOM    560  CD1 LEU A  68      72.786  11.119  54.441  1.00 98.33           C  
ATOM    561  CD2 LEU A  68      70.826  11.627  55.867  1.00 96.52           C  
ATOM    562  N   TYR A  69      67.800  11.907  51.949  1.00 85.65           N  
ATOM    563  CA  TYR A  69      66.940  12.733  51.118  1.00 82.10           C  
ATOM    564  C   TYR A  69      66.785  14.093  51.761  1.00 75.92           C  
ATOM    565  O   TYR A  69      66.259  14.207  52.868  1.00 67.52           O  
ATOM    566  CB  TYR A  69      65.592  12.051  50.937  1.00 84.26           C  
ATOM    567  CG  TYR A  69      65.525  11.212  49.699  1.00 96.43           C  
ATOM    568  CD1 TYR A  69      66.350  10.080  49.545  1.00103.88           C  
ATOM    569  CD2 TYR A  69      64.693  11.579  48.627  1.00106.95           C  
ATOM    570  CE1 TYR A  69      66.365   9.327  48.337  1.00110.02           C  
ATOM    571  CE2 TYR A  69      64.688  10.837  47.410  1.00103.92           C  
ATOM    572  CZ  TYR A  69      65.529   9.714  47.275  1.00111.63           C  
ATOM    573  OH  TYR A  69      65.556   8.979  46.113  1.00112.64           O  
ATOM    574  N   LEU A  70      67.266  15.112  51.052  1.00 73.28           N  
ATOM    575  CA  LEU A  70      67.245  16.484  51.538  1.00 65.05           C  
ATOM    576  C   LEU A  70      66.220  17.327  50.775  1.00 64.02           C  
ATOM    577  O   LEU A  70      66.567  18.215  49.995  1.00 64.05           O  
ATOM    578  CB  LEU A  70      68.670  17.093  51.462  1.00 69.14           C  
ATOM    579  CG  LEU A  70      69.914  16.346  52.011  1.00 71.10           C  
ATOM    580  CD1 LEU A  70      71.179  16.908  51.377  1.00 66.02           C  
ATOM    581  CD2 LEU A  70      70.015  16.366  53.545  1.00 63.34           C  
ATOM    582  N   THR A  71      64.945  17.025  50.986  1.00 59.65           N  
ATOM    583  CA  THR A  71      63.858  17.761  50.340  1.00 56.56           C  
ATOM    584  C   THR A  71      63.641  19.133  51.002  1.00 55.95           C  
ATOM    585  O   THR A  71      63.746  19.271  52.217  1.00 52.84           O  
ATOM    586  CB  THR A  71      62.520  16.920  50.293  1.00 60.85           C  
ATOM    587  OG1 THR A  71      62.159  16.451  51.598  1.00 49.76           O  
ATOM    588  CG2 THR A  71      62.665  15.725  49.377  1.00 53.51           C  
ATOM    589  N   LEU A  72      63.424  20.153  50.181  1.00 56.83           N  
ATOM    590  CA  LEU A  72      63.198  21.512  50.672  1.00 63.31           C  
ATOM    591  C   LEU A  72      61.749  21.926  50.418  1.00 62.80           C  
ATOM    592  O   LEU A  72      61.306  21.927  49.276  1.00 63.49           O  
ATOM    593  CB  LEU A  72      64.142  22.483  49.954  1.00 63.08           C  
ATOM    594  CG  LEU A  72      63.978  23.993  50.170  1.00 65.19           C  
ATOM    595  CD1 LEU A  72      64.700  24.404  51.425  1.00 60.59           C  
ATOM    596  CD2 LEU A  72      64.530  24.750  48.966  1.00 68.10           C  
ATOM    597  N   SER A  73      61.040  22.343  51.462  1.00 66.60           N  
ATOM    598  CA  SER A  73      59.639  22.751  51.326  1.00 72.10           C  
ATOM    599  C   SER A  73      59.408  24.229  50.910  1.00 73.32           C  
ATOM    600  O   SER A  73      60.367  24.974  50.662  1.00 71.66           O  
ATOM    601  CB  SER A  73      58.852  22.373  52.602  1.00 68.21           C  
ATOM    602  OG  SER A  73      59.342  23.027  53.760  1.00 71.56           O  
ATOM    603  N   ASN A  74      58.130  24.611  50.781  1.00 74.92           N  
ATOM    604  CA  ASN A  74      57.688  25.959  50.411  1.00 70.07           C  
ATOM    605  C   ASN A  74      58.119  26.971  51.445  1.00 71.74           C  
ATOM    606  O   ASN A  74      58.487  28.087  51.092  1.00 74.41           O  
ATOM    607  CB  ASN A  74      56.166  26.021  50.291  1.00 77.56           C  
ATOM    608  CG  ASN A  74      55.639  25.155  49.177  1.00 78.81           C  
ATOM    609  OD1 ASN A  74      56.081  25.264  48.033  1.00 90.63           O  
ATOM    610  ND2 ASN A  74      54.687  24.283  49.498  1.00 83.64           N  
ATOM    611  N   GLY A  75      58.061  26.554  52.719  1.00 74.15           N  
ATOM    612  CA  GLY A  75      58.448  27.381  53.854  1.00 73.36           C  
ATOM    613  C   GLY A  75      59.844  27.907  53.613  1.00 74.59           C  
ATOM    614  O   GLY A  75      59.989  29.083  53.322  1.00 79.92           O  
ATOM    615  N   GLU A  76      60.797  26.977  53.540  1.00 74.90           N  
ATOM    616  CA  GLU A  76      62.247  27.167  53.299  1.00 78.25           C  
ATOM    617  C   GLU A  76      62.926  26.129  54.182  1.00 76.28           C  
ATOM    618  O   GLU A  76      64.138  25.956  54.112  1.00 77.55           O  
ATOM    619  CB  GLU A  76      62.796  28.570  53.679  1.00 80.98           C  
ATOM    620  CG  GLU A  76      64.219  28.934  53.145  1.00 85.66           C  
ATOM    621  CD  GLU A  76      64.900  30.104  53.890  1.00 85.20           C  
ATOM    622  OE1 GLU A  76      64.399  31.247  53.817  1.00 87.81           O  
ATOM    623  OE2 GLU A  76      65.947  29.882  54.541  1.00 79.92           O  
ATOM    624  N   ILE A  77      62.128  25.427  54.989  1.00 74.86           N  
ATOM    625  CA  ILE A  77      62.628  24.393  55.904  1.00 76.88           C  
ATOM    626  C   ILE A  77      63.165  23.193  55.118  1.00 77.43           C  
ATOM    627  O   ILE A  77      62.509  22.709  54.187  1.00 71.70           O  
ATOM    628  CB  ILE A  77      61.516  23.878  56.871  1.00 78.06           C  
ATOM    629  CG1 ILE A  77      60.672  25.043  57.388  1.00 74.45           C  
ATOM    630  CG2 ILE A  77      62.153  23.150  58.073  1.00 70.74           C  
ATOM    631  CD1 ILE A  77      59.401  24.622  58.093  1.00 77.92           C  
ATOM    632  N   VAL A  78      64.375  22.754  55.466  1.00 71.80           N  
ATOM    633  CA  VAL A  78      64.959  21.593  54.808  1.00 73.68           C  
ATOM    634  C   VAL A  78      64.607  20.381  55.672  1.00 76.63           C  
ATOM    635  O   VAL A  78      64.479  20.493  56.906  1.00 72.90           O  
ATOM    636  CB  VAL A  78      66.491  21.690  54.635  1.00 70.21           C  
ATOM    637  CG1 VAL A  78      66.942  20.750  53.517  1.00 75.96           C  
ATOM    638  CG2 VAL A  78      66.914  23.107  54.316  1.00 71.80           C  
ATOM    639  N   GLU A  79      64.343  19.256  54.997  1.00 78.31           N  
ATOM    640  CA  GLU A  79      63.967  17.998  55.644  1.00 75.97           C  
ATOM    641  C   GLU A  79      64.827  16.820  55.218  1.00 69.36           C  
ATOM    642  O   GLU A  79      64.983  16.564  54.034  1.00 68.53           O  
ATOM    643  CB  GLU A  79      62.496  17.660  55.358  1.00 79.33           C  
ATOM    644  CG  GLU A  79      61.460  18.592  56.010  1.00 98.19           C  
ATOM    645  CD  GLU A  79      60.821  19.581  55.027  1.00110.36           C  
ATOM    646  OE1 GLU A  79      60.721  19.272  53.812  1.00114.17           O  
ATOM    647  OE2 GLU A  79      60.396  20.670  55.475  1.00114.04           O  
ATOM    648  N   LEU A  80      65.375  16.107  56.194  1.00 68.45           N  
ATOM    649  CA  LEU A  80      66.189  14.939  55.910  1.00 71.68           C  
ATOM    650  C   LEU A  80      65.498  13.659  56.361  1.00 71.30           C  
ATOM    651  O   LEU A  80      64.731  13.640  57.335  1.00 70.12           O  
ATOM    652  CB  LEU A  80      67.637  15.083  56.435  1.00 66.74           C  
ATOM    653  CG  LEU A  80      68.237  14.493  57.721  1.00 72.42           C  
ATOM    654  CD1 LEU A  80      69.718  14.407  57.586  1.00 72.92           C  
ATOM    655  CD2 LEU A  80      67.912  15.330  58.929  1.00 67.32           C  
ATOM    656  N   LYS A  81      65.658  12.633  55.529  1.00 66.11           N  
ATOM    657  CA  LYS A  81      65.075  11.324  55.768  1.00 68.32           C  
ATOM    658  C   LYS A  81      65.928  10.237  55.160  1.00 68.90           C  
ATOM    659  O   LYS A  81      66.476  10.421  54.066  1.00 70.92           O  
ATOM    660  CB  LYS A  81      63.641  11.252  55.232  1.00 67.74           C  
ATOM    661  CG  LYS A  81      63.361  12.165  54.106  1.00 70.39           C  
ATOM    662  CD  LYS A  81      61.943  12.190  53.775  1.00 73.60           C  
ATOM    663  CE  LYS A  81      61.887  12.522  52.334  1.00 74.78           C  
ATOM    664  NZ  LYS A  81      62.484  11.378  51.574  1.00 81.66           N  
ATOM    665  N   ARG A  82      66.062   9.128  55.897  1.00 66.23           N  
ATOM    666  CA  ARG A  82      66.879   7.977  55.486  1.00 69.90           C  
ATOM    667  C   ARG A  82      66.157   6.618  55.634  1.00 63.42           C  
ATOM    668  O   ARG A  82      64.955   6.588  55.482  1.00 60.16           O  
ATOM    669  CB  ARG A  82      68.263   8.020  56.194  1.00 71.63           C  
ATOM    670  CG  ARG A  82      68.298   8.631  57.617  1.00 77.36           C  
ATOM    671  CD  ARG A  82      69.739   8.846  58.147  1.00 82.70           C  
ATOM    672  NE  ARG A  82      69.954  10.203  58.686  1.00 87.58           N  
ATOM    673  CZ  ARG A  82      70.758  10.519  59.709  1.00 82.48           C  
ATOM    674  NH1 ARG A  82      71.459   9.588  60.342  1.00 87.72           N  
ATOM    675  NH2 ARG A  82      70.825  11.778  60.130  1.00 78.17           N  
ATOM    676  N   VAL A  83      66.892   5.531  55.951  1.00 62.40           N  
ATOM    677  CA  VAL A  83      66.449   4.109  56.144  1.00 59.38           C  
ATOM    678  C   VAL A  83      66.361   3.319  54.830  1.00 56.07           C  
ATOM    679  O   VAL A  83      66.501   3.891  53.736  1.00 54.99           O  
ATOM    680  CB  VAL A  83      65.098   3.899  57.011  1.00 63.74           C  
ATOM    681  CG1 VAL A  83      64.884   2.394  57.413  1.00 54.11           C  
ATOM    682  CG2 VAL A  83      65.126   4.736  58.291  1.00 58.34           C  
ATOM    683  N   GLY A  84      66.197   1.999  54.979  1.00 52.14           N  
ATOM    684  CA  GLY A  84      66.075   1.079  53.861  1.00 56.42           C  
ATOM    685  C   GLY A  84      64.857   0.159  53.938  1.00 55.05           C  
ATOM    686  O   GLY A  84      64.052   0.239  54.870  1.00 55.21           O  
ATOM    687  N   GLU A  85      64.813  -0.760  52.970  1.00 56.42           N  
ATOM    688  CA  GLU A  85      63.784  -1.786  52.693  1.00 61.93           C  
ATOM    689  C   GLU A  85      62.839  -2.501  53.667  1.00 61.76           C  
ATOM    690  O   GLU A  85      63.133  -2.703  54.849  1.00 65.94           O  
ATOM    691  CB  GLU A  85      64.397  -2.862  51.795  1.00 54.23           C  
ATOM    692  CG  GLU A  85      64.582  -2.415  50.365  1.00 57.45           C  
ATOM    693  CD  GLU A  85      65.830  -2.978  49.724  1.00 66.24           C  
ATOM    694  OE1 GLU A  85      66.037  -4.215  49.793  1.00 65.30           O  
ATOM    695  OE2 GLU A  85      66.601  -2.169  49.146  1.00 64.91           O  
ATOM    696  N   GLU A  86      61.716  -2.932  53.072  1.00 62.07           N  
ATOM    697  CA  GLU A  86      60.604  -3.691  53.670  1.00 62.66           C  
ATOM    698  C   GLU A  86      59.657  -4.089  52.513  1.00 53.93           C  
ATOM    699  O   GLU A  86      59.536  -3.365  51.528  1.00 44.36           O  
ATOM    700  CB  GLU A  86      59.843  -2.885  54.737  1.00 68.29           C  
ATOM    701  CG  GLU A  86      60.108  -3.340  56.181  1.00 76.26           C  
ATOM    702  CD  GLU A  86      59.026  -2.882  57.150  1.00 81.45           C  
ATOM    703  OE1 GLU A  86      58.041  -3.636  57.301  1.00 86.33           O  
ATOM    704  OE2 GLU A  86      59.148  -1.785  57.758  1.00 84.17           O  
ATOM    705  N   GLU A  87      59.035  -5.263  52.623  1.00 54.17           N  
ATOM    706  CA  GLU A  87      58.131  -5.795  51.600  1.00 52.00           C  
ATOM    707  C   GLU A  87      56.660  -5.563  51.919  1.00 51.86           C  
ATOM    708  O   GLU A  87      56.155  -5.950  52.981  1.00 53.84           O  
ATOM    709  CB  GLU A  87      58.403  -7.280  51.358  1.00 53.61           C  
ATOM    710  CG  GLU A  87      59.854  -7.602  50.969  1.00 56.12           C  
ATOM    711  CD  GLU A  87      59.972  -8.308  49.632  1.00 62.49           C  
ATOM    712  OE1 GLU A  87      59.544  -9.484  49.530  1.00 63.64           O  
ATOM    713  OE2 GLU A  87      60.513  -7.694  48.687  1.00 61.36           O  
ATOM    714  N   PHE A  88      55.984  -4.970  50.937  1.00 49.74           N  
ATOM    715  CA  PHE A  88      54.569  -4.558  50.949  1.00 52.64           C  
ATOM    716  C   PHE A  88      53.460  -5.635  50.977  1.00 49.33           C  
ATOM    717  O   PHE A  88      53.344  -6.455  50.066  1.00 48.99           O  
ATOM    718  CB  PHE A  88      54.389  -3.604  49.749  1.00 53.55           C  
ATOM    719  CG  PHE A  88      52.992  -3.081  49.548  1.00 53.55           C  
ATOM    720  CD1 PHE A  88      52.476  -2.067  50.370  1.00 49.82           C  
ATOM    721  CD2 PHE A  88      52.204  -3.563  48.486  1.00 54.31           C  
ATOM    722  CE1 PHE A  88      51.192  -1.541  50.133  1.00 50.06           C  
ATOM    723  CE2 PHE A  88      50.916  -3.045  48.245  1.00 53.61           C  
ATOM    724  CZ  PHE A  88      50.416  -2.033  49.065  1.00 48.49           C  
ATOM    725  N   ARG A  89      52.579  -5.543  51.972  1.00 51.69           N  
ATOM    726  CA  ARG A  89      51.475  -6.498  52.125  1.00 54.88           C  
ATOM    727  C   ARG A  89      50.088  -5.830  52.199  1.00 56.42           C  
ATOM    728  O   ARG A  89      49.397  -5.926  53.239  1.00 54.36           O  
ATOM    729  CB  ARG A  89      51.706  -7.365  53.371  1.00 55.80           C  
ATOM    730  CG  ARG A  89      53.080  -8.032  53.430  1.00 61.65           C  
ATOM    731  CD  ARG A  89      53.145  -9.186  54.404  1.00 63.33           C  
ATOM    732  NE  ARG A  89      52.205 -10.256  54.065  1.00 55.20           N  
ATOM    733  CZ  ARG A  89      52.276 -11.038  52.987  1.00 56.64           C  
ATOM    734  NH1 ARG A  89      53.250 -10.899  52.097  1.00 55.09           N  
ATOM    735  NH2 ARG A  89      51.341 -11.949  52.788  1.00 57.29           N  
ATOM    736  N   GLY A  90      49.679  -5.187  51.092  1.00 58.43           N  
ATOM    737  CA  GLY A  90      48.388  -4.489  51.021  1.00 51.86           C  
ATOM    738  C   GLY A  90      48.369  -3.129  51.711  1.00 47.59           C  
ATOM    739  O   GLY A  90      49.363  -2.753  52.331  1.00 43.35           O  
ATOM    740  N   PHE A  91      47.266  -2.384  51.595  1.00 42.94           N  
ATOM    741  CA  PHE A  91      47.176  -1.060  52.219  1.00 39.59           C  
ATOM    742  C   PHE A  91      46.401  -1.098  53.518  1.00 39.74           C  
ATOM    743  O   PHE A  91      45.607  -2.017  53.752  1.00 41.09           O  
ATOM    744  CB  PHE A  91      46.466  -0.051  51.316  1.00 39.42           C  
ATOM    745  CG  PHE A  91      47.019   0.040  49.928  1.00 34.96           C  
ATOM    746  CD1 PHE A  91      46.472  -0.742  48.887  1.00 38.11           C  
ATOM    747  CD2 PHE A  91      48.067   0.938  49.630  1.00 38.47           C  
ATOM    748  CE1 PHE A  91      46.964  -0.629  47.552  1.00 36.18           C  
ATOM    749  CE2 PHE A  91      48.573   1.065  48.297  1.00 35.01           C  
ATOM    750  CZ  PHE A  91      48.015   0.279  47.263  1.00 33.51           C  
ATOM    751  N   GLN A  92      46.565  -0.031  54.306  1.00 42.03           N  
ATOM    752  CA  GLN A  92      45.882   0.152  55.600  1.00 40.53           C  
ATOM    753  C   GLN A  92      44.802   1.248  55.491  1.00 37.86           C  
ATOM    754  O   GLN A  92      43.833   1.290  56.272  1.00 39.23           O  
ATOM    755  CB  GLN A  92      46.899   0.537  56.674  1.00 42.63           C  
ATOM    756  CG  GLN A  92      48.142  -0.370  56.701  1.00 39.34           C  
ATOM    757  CD  GLN A  92      49.111  -0.035  57.813  1.00 34.10           C  
ATOM    758  OE1 GLN A  92      48.962   0.985  58.500  1.00 29.76           O  
ATOM    759  NE2 GLN A  92      50.117  -0.898  57.998  1.00 27.16           N  
ATOM    760  N   ASN A  93      45.014   2.152  54.536  1.00 39.55           N  
ATOM    761  CA  ASN A  93      44.114   3.258  54.258  1.00 40.33           C  
ATOM    762  C   ASN A  93      43.827   3.378  52.765  1.00 38.85           C  
ATOM    763  O   ASN A  93      44.600   2.945  51.893  1.00 27.58           O  
ATOM    764  CB  ASN A  93      44.723   4.601  54.694  1.00 48.96           C  
ATOM    765  CG  ASN A  93      44.984   4.685  56.170  1.00 51.46           C  
ATOM    766  OD1 ASN A  93      44.247   4.124  56.988  1.00 58.77           O  
ATOM    767  ND2 ASN A  93      46.048   5.389  56.529  1.00 50.90           N  
ATOM    768  N   GLU A  94      42.734   4.085  52.507  1.00 41.37           N  
ATOM    769  CA  GLU A  94      42.244   4.412  51.174  1.00 37.89           C  
ATOM    770  C   GLU A  94      43.178   5.501  50.687  1.00 37.49           C  
ATOM    771  O   GLU A  94      43.453   5.613  49.478  1.00 39.28           O  
ATOM    772  CB  GLU A  94      40.835   5.001  51.282  1.00 39.22           C  
ATOM    773  CG  GLU A  94      39.911   4.189  52.144  1.00 35.61           C  
ATOM    774  CD  GLU A  94      39.523   4.831  53.471  1.00 38.79           C  
ATOM    775  OE1 GLU A  94      39.807   4.221  54.525  1.00 36.67           O  
ATOM    776  OE2 GLU A  94      38.877   5.900  53.458  1.00 33.29           O  
ATOM    777  N   ARG A  95      43.633   6.301  51.666  1.00 37.48           N  
ATOM    778  CA  ARG A  95      44.537   7.427  51.471  1.00 34.87           C  
ATOM    779  C   ARG A  95      45.819   6.956  50.817  1.00 32.85           C  
ATOM    780  O   ARG A  95      46.210   7.501  49.786  1.00 40.97           O  
ATOM    781  CB  ARG A  95      44.853   8.134  52.801  1.00 31.55           C  
ATOM    782  CG  ARG A  95      45.916   9.275  52.684  1.00 25.74           C  
ATOM    783  CD  ARG A  95      46.367   9.860  54.013  1.00 20.85           C  
ATOM    784  NE  ARG A  95      46.746   8.840  54.998  1.00 29.43           N  
ATOM    785  CZ  ARG A  95      47.913   8.196  55.042  1.00 24.99           C  
ATOM    786  NH1 ARG A  95      48.860   8.440  54.155  1.00 19.25           N  
ATOM    787  NH2 ARG A  95      48.156   7.335  56.014  1.00 33.08           N  
ATOM    788  N   GLU A  96      46.411   5.894  51.367  1.00 30.91           N  
ATOM    789  CA  GLU A  96      47.656   5.322  50.844  1.00 30.77           C  
ATOM    790  C   GLU A  96      47.477   4.826  49.426  1.00 30.21           C  
ATOM    791  O   GLU A  96      48.306   5.135  48.554  1.00 31.52           O  
ATOM    792  CB  GLU A  96      48.139   4.179  51.719  1.00 35.41           C  
ATOM    793  CG  GLU A  96      48.419   4.581  53.143  1.00 40.18           C  
ATOM    794  CD  GLU A  96      48.831   3.417  54.020  1.00 41.37           C  
ATOM    795  OE1 GLU A  96      49.097   2.318  53.479  1.00 40.84           O  
ATOM    796  OE2 GLU A  96      48.886   3.612  55.260  1.00 44.72           O  
ATOM    797  N   CYS A  97      46.327   4.185  49.177  1.00 25.62           N  
ATOM    798  CA  CYS A  97      45.979   3.651  47.858  1.00 18.46           C  
ATOM    799  C   CYS A  97      45.924   4.766  46.813  1.00 17.80           C  
ATOM    800  O   CYS A  97      46.521   4.659  45.731  1.00 16.61           O  
ATOM    801  CB  CYS A  97      44.664   2.875  47.946  1.00 13.95           C  
ATOM    802  SG  CYS A  97      44.123   2.211  46.386  1.00 10.00           S  
ATOM    803  N   GLN A  98      45.285   5.867  47.201  1.00 11.02           N  
ATOM    804  CA  GLN A  98      45.164   7.041  46.356  1.00  5.41           C  
ATOM    805  C   GLN A  98      46.523   7.685  46.072  1.00  4.98           C  
ATOM    806  O   GLN A  98      46.902   7.858  44.914  1.00  2.06           O  
ATOM    807  CB  GLN A  98      44.269   8.012  47.060  1.00  9.37           C  
ATOM    808  CG  GLN A  98      43.927   9.236  46.295  1.00  5.99           C  
ATOM    809  CD  GLN A  98      43.406  10.236  47.257  1.00 10.05           C  
ATOM    810  OE1 GLN A  98      44.196  11.054  47.802  1.00 11.19           O  
ATOM    811  NE2 GLN A  98      42.113  10.091  47.620  1.00  4.20           N  
ATOM    812  N   GLU A  99      47.273   7.933  47.143  1.00  2.23           N  
ATOM    813  CA  GLU A  99      48.589   8.547  47.078  1.00  8.28           C  
ATOM    814  C   GLU A  99      49.451   7.811  46.096  1.00 13.09           C  
ATOM    815  O   GLU A  99      49.901   8.415  45.112  1.00 13.60           O  
ATOM    816  CB  GLU A  99      49.262   8.565  48.428  1.00  2.00           C  
ATOM    817  CG  GLU A  99      48.535   9.423  49.402  1.00  6.51           C  
ATOM    818  CD  GLU A  99      49.282   9.608  50.691  1.00 20.03           C  
ATOM    819  OE1 GLU A  99      50.313   8.941  50.901  1.00 17.58           O  
ATOM    820  OE2 GLU A  99      48.866  10.466  51.497  1.00 20.34           O  
ATOM    821  N   LEU A 100      49.496   6.483  46.247  1.00 14.86           N  
ATOM    822  CA  LEU A 100      50.293   5.636  45.358  1.00 17.15           C  
ATOM    823  C   LEU A 100      49.690   5.586  43.930  1.00 16.67           C  
ATOM    824  O   LEU A 100      50.392   5.886  42.967  1.00 11.73           O  
ATOM    825  CB  LEU A 100      50.459   4.233  45.961  1.00 15.92           C  
ATOM    826  CG  LEU A 100      51.590   3.420  45.314  1.00 21.12           C  
ATOM    827  CD1 LEU A 100      52.863   3.739  46.032  1.00 20.29           C  
ATOM    828  CD2 LEU A 100      51.319   1.903  45.322  1.00  8.50           C  
ATOM    829  N   PHE A 101      48.380   5.343  43.812  1.00 14.44           N  
ATOM    830  CA  PHE A 101      47.712   5.288  42.504  1.00 18.46           C  
ATOM    831  C   PHE A 101      47.959   6.539  41.647  1.00 24.86           C  
ATOM    832  O   PHE A 101      48.331   6.423  40.478  1.00 22.17           O  
ATOM    833  CB  PHE A 101      46.197   5.062  42.673  1.00 20.16           C  
ATOM    834  CG  PHE A 101      45.422   4.923  41.355  1.00 25.48           C  
ATOM    835  CD1 PHE A 101      45.574   3.778  40.525  1.00 19.31           C  
ATOM    836  CD2 PHE A 101      44.533   5.932  40.939  1.00 26.12           C  
ATOM    837  CE1 PHE A 101      44.843   3.650  39.290  1.00 20.77           C  
ATOM    838  CE2 PHE A 101      43.800   5.814  39.705  1.00 25.13           C  
ATOM    839  CZ  PHE A 101      43.959   4.671  38.885  1.00 24.71           C  
ATOM    840  N   ARG A 102      47.776   7.717  42.253  1.00 26.42           N  
ATOM    841  CA  ARG A 102      47.939   9.014  41.586  1.00 28.91           C  
ATOM    842  C   ARG A 102      49.303   9.225  40.953  1.00 26.95           C  
ATOM    843  O   ARG A 102      49.423   9.649  39.806  1.00 29.38           O  
ATOM    844  CB  ARG A 102      47.678  10.145  42.570  1.00 30.32           C  
ATOM    845  CG  ARG A 102      46.218  10.408  42.835  1.00 30.82           C  
ATOM    846  CD  ARG A 102      46.061  11.666  43.664  1.00 39.26           C  
ATOM    847  NE  ARG A 102      44.651  12.041  43.781  1.00 44.56           N  
ATOM    848  CZ  ARG A 102      44.143  12.811  44.745  1.00 46.39           C  
ATOM    849  NH1 ARG A 102      44.927  13.310  45.700  1.00 46.35           N  
ATOM    850  NH2 ARG A 102      42.834  13.052  44.777  1.00 44.24           N  
ATOM    851  N   ASP A 103      50.328   8.848  41.699  1.00 27.11           N  
ATOM    852  CA  ASP A 103      51.713   8.958  41.273  1.00 23.31           C  
ATOM    853  C   ASP A 103      52.018   8.023  40.121  1.00 20.97           C  
ATOM    854  O   ASP A 103      53.003   8.192  39.412  1.00 12.78           O  
ATOM    855  CB  ASP A 103      52.643   8.690  42.460  1.00 35.58           C  
ATOM    856  CG  ASP A 103      52.562   9.787  43.560  1.00 45.80           C  
ATOM    857  OD1 ASP A 103      51.895  10.845  43.363  1.00 45.44           O  
ATOM    858  OD2 ASP A 103      53.182   9.586  44.635  1.00 42.57           O  
ATOM    859  N   PHE A 104      51.163   7.029  39.935  1.00 22.06           N  
ATOM    860  CA  PHE A 104      51.335   6.121  38.818  1.00 27.45           C  
ATOM    861  C   PHE A 104      50.787   6.780  37.576  1.00 28.46           C  
ATOM    862  O   PHE A 104      51.421   6.725  36.540  1.00 32.68           O  
ATOM    863  CB  PHE A 104      50.630   4.800  39.064  1.00 28.47           C  
ATOM    864  CG  PHE A 104      51.506   3.773  39.669  1.00 24.02           C  
ATOM    865  CD1 PHE A 104      51.471   3.538  41.035  1.00 24.66           C  
ATOM    866  CD2 PHE A 104      52.386   3.033  38.866  1.00 28.96           C  
ATOM    867  CE1 PHE A 104      52.302   2.578  41.617  1.00 23.68           C  
ATOM    868  CE2 PHE A 104      53.226   2.061  39.435  1.00 20.01           C  
ATOM    869  CZ  PHE A 104      53.186   1.832  40.817  1.00 28.74           C  
ATOM    870  N   LEU A 105      49.658   7.483  37.716  1.00 31.54           N  
ATOM    871  CA  LEU A 105      48.999   8.205  36.609  1.00 30.11           C  
ATOM    872  C   LEU A 105      49.886   9.325  36.074  1.00 30.54           C  
ATOM    873  O   LEU A 105      49.775   9.756  34.919  1.00 28.77           O  
ATOM    874  CB  LEU A 105      47.686   8.826  37.101  1.00 23.34           C  
ATOM    875  CG  LEU A 105      46.713   7.902  37.817  1.00 15.58           C  
ATOM    876  CD1 LEU A 105      45.483   8.677  38.140  1.00  6.60           C  
ATOM    877  CD2 LEU A 105      46.372   6.695  36.943  1.00 19.96           C  
ATOM    878  N   THR A 106      50.757   9.785  36.964  1.00 29.04           N  
ATOM    879  CA  THR A 106      51.688  10.851  36.701  1.00 32.38           C  
ATOM    880  C   THR A 106      52.926  10.304  36.033  1.00 34.62           C  
ATOM    881  O   THR A 106      53.207  10.675  34.912  1.00 41.19           O  
ATOM    882  CB  THR A 106      52.017  11.584  38.015  1.00 31.34           C  
ATOM    883  OG1 THR A 106      50.836  12.272  38.470  1.00 26.68           O  
ATOM    884  CG2 THR A 106      53.184  12.566  37.836  1.00 30.85           C  
ATOM    885  N   LYS A 107      53.632   9.391  36.703  1.00 46.78           N  
ATOM    886  CA  LYS A 107      54.855   8.772  36.169  1.00 45.42           C  
ATOM    887  C   LYS A 107      54.661   7.987  34.861  1.00 44.15           C  
ATOM    888  O   LYS A 107      55.608   7.886  34.078  1.00 47.64           O  
ATOM    889  CB  LYS A 107      55.552   7.926  37.253  1.00 42.17           C  
ATOM    890  CG  LYS A 107      57.010   7.485  36.940  1.00 49.41           C  
ATOM    891  CD  LYS A 107      57.945   8.641  36.478  1.00 47.69           C  
ATOM    892  CE  LYS A 107      59.361   8.125  36.228  1.00 49.72           C  
ATOM    893  NZ  LYS A 107      60.213   9.113  35.524  1.00 46.25           N  
ATOM    894  N   THR A 108      53.432   7.520  34.600  1.00 43.33           N  
ATOM    895  CA  THR A 108      53.102   6.782  33.371  1.00 44.44           C  
ATOM    896  C   THR A 108      52.486   7.745  32.364  1.00 44.00           C  
ATOM    897  O   THR A 108      52.091   7.342  31.268  1.00 43.97           O  
ATOM    898  CB  THR A 108      52.126   5.609  33.631  1.00 43.67           C  
ATOM    899  OG1 THR A 108      52.456   5.007  34.881  1.00 43.82           O  
ATOM    900  CG2 THR A 108      52.290   4.519  32.581  1.00 47.84           C  
ATOM    901  N   LYS A 109      52.349   9.007  32.788  1.00 52.24           N  
ATOM    902  CA  LYS A 109      51.801  10.131  31.997  1.00 54.37           C  
ATOM    903  C   LYS A 109      50.519   9.861  31.200  1.00 51.13           C  
ATOM    904  O   LYS A 109      50.235  10.544  30.214  1.00 51.15           O  
ATOM    905  CB  LYS A 109      52.903  10.708  31.092  1.00 52.91           C  
ATOM    906  CG  LYS A 109      54.090  11.268  31.869  1.00 60.89           C  
ATOM    907  CD  LYS A 109      55.293  11.496  30.989  1.00 67.97           C  
ATOM    908  CE  LYS A 109      56.534  11.644  31.837  1.00 66.47           C  
ATOM    909  NZ  LYS A 109      57.715  11.861  30.968  1.00 70.17           N  
ATOM    910  N   VAL A 110      49.724   8.907  31.692  1.00 49.13           N  
ATOM    911  CA  VAL A 110      48.476   8.465  31.065  1.00 47.25           C  
ATOM    912  C   VAL A 110      47.325   9.482  31.090  1.00 44.50           C  
ATOM    913  O   VAL A 110      46.471   9.495  30.201  1.00 40.72           O  
ATOM    914  CB  VAL A 110      48.072   7.088  31.625  1.00 43.32           C  
ATOM    915  CG1 VAL A 110      47.791   7.175  33.111  1.00 40.54           C  
ATOM    916  CG2 VAL A 110      46.931   6.454  30.803  1.00 41.34           C  
ATOM    917  N   LYS A 111      47.352  10.371  32.076  1.00 45.57           N  
ATOM    918  CA  LYS A 111      46.341  11.414  32.176  1.00 47.50           C  
ATOM    919  C   LYS A 111      46.763  12.530  31.196  1.00 43.62           C  
ATOM    920  O   LYS A 111      45.929  13.236  30.633  1.00 44.98           O  
ATOM    921  CB  LYS A 111      46.240  11.927  33.613  1.00 50.05           C  
ATOM    922  CG  LYS A 111      44.849  12.453  33.947  1.00 48.61           C  
ATOM    923  CD  LYS A 111      44.798  13.401  35.157  1.00 46.64           C  
ATOM    924  CE  LYS A 111      45.068  12.692  36.471  1.00 39.51           C  
ATOM    925  NZ  LYS A 111      44.260  13.340  37.513  1.00 35.27           N  
ATOM    926  N   ASP A 112      48.063  12.604  30.930  1.00 46.69           N  
ATOM    927  CA  ASP A 112      48.607  13.579  29.997  1.00 53.12           C  
ATOM    928  C   ASP A 112      48.382  13.113  28.559  1.00 52.61           C  
ATOM    929  O   ASP A 112      48.170  13.942  27.673  1.00 53.40           O  
ATOM    930  CB  ASP A 112      50.096  13.784  30.246  1.00 60.03           C  
ATOM    931  CG  ASP A 112      50.390  14.208  31.657  1.00 62.96           C  
ATOM    932  OD1 ASP A 112      49.614  15.021  32.214  1.00 65.20           O  
ATOM    933  OD2 ASP A 112      51.395  13.714  32.212  1.00 64.03           O  
ATOM    934  N   LYS A 113      48.422  11.792  28.331  1.00 53.83           N  
ATOM    935  CA  LYS A 113      48.173  11.238  26.995  1.00 51.26           C  
ATOM    936  C   LYS A 113      46.697  11.460  26.673  1.00 53.88           C  
ATOM    937  O   LYS A 113      46.362  11.838  25.554  1.00 52.20           O  
ATOM    938  CB  LYS A 113      48.490   9.734  26.888  1.00 50.87           C  
ATOM    939  CG  LYS A 113      48.788   9.268  25.419  1.00 56.12           C  
ATOM    940  CD  LYS A 113      48.500   7.775  25.175  1.00 62.67           C  
ATOM    941  CE  LYS A 113      48.696   7.365  23.702  1.00 54.47           C  
ATOM    942  NZ  LYS A 113      48.221   5.954  23.464  1.00 51.43           N  
ATOM    943  N   PHE A 114      45.843  11.321  27.692  1.00 50.29           N  
ATOM    944  CA  PHE A 114      44.408  11.514  27.538  1.00 49.64           C  
ATOM    945  C   PHE A 114      44.046  12.951  27.222  1.00 53.83           C  
ATOM    946  O   PHE A 114      43.318  13.203  26.267  1.00 55.28           O  
ATOM    947  CB  PHE A 114      43.635  11.071  28.777  1.00 55.12           C  
ATOM    948  CG  PHE A 114      42.137  11.111  28.589  1.00 52.28           C  
ATOM    949  CD1 PHE A 114      41.508  10.216  27.683  1.00 47.66           C  
ATOM    950  CD2 PHE A 114      41.353  12.089  29.238  1.00 50.09           C  
ATOM    951  CE1 PHE A 114      40.108  10.297  27.413  1.00 49.70           C  
ATOM    952  CE2 PHE A 114      39.945  12.190  28.981  1.00 47.50           C  
ATOM    953  CZ  PHE A 114      39.325  11.288  28.060  1.00 50.44           C  
ATOM    954  N   ILE A 115      44.495  13.884  28.059  1.00 56.57           N  
ATOM    955  CA  ILE A 115      44.226  15.309  27.851  1.00 60.81           C  
ATOM    956  C   ILE A 115      44.630  15.727  26.417  1.00 60.22           C  
ATOM    957  O   ILE A 115      43.789  16.231  25.680  1.00 64.08           O  
ATOM    958  CB  ILE A 115      44.870  16.150  29.011  1.00 65.87           C  
ATOM    959  CG1 ILE A 115      43.923  16.111  30.224  1.00 61.18           C  
ATOM    960  CG2 ILE A 115      45.209  17.594  28.589  1.00 55.67           C  
ATOM    961  CD1 ILE A 115      44.607  16.203  31.583  1.00 62.01           C  
ATOM    962  N   SER A 116      45.810  15.286  25.967  1.00 63.22           N  
ATOM    963  CA  SER A 116      46.293  15.603  24.623  1.00 55.99           C  
ATOM    964  C   SER A 116      45.526  14.902  23.488  1.00 57.86           C  
ATOM    965  O   SER A 116      45.442  15.443  22.391  1.00 59.84           O  
ATOM    966  CB  SER A 116      47.812  15.369  24.507  1.00 54.59           C  
ATOM    967  OG  SER A 116      48.136  14.055  24.075  1.00 56.81           O  
ATOM    968  N   ASP A 117      44.964  13.723  23.761  1.00 55.53           N  
ATOM    969  CA  ASP A 117      44.191  12.974  22.761  1.00 55.38           C  
ATOM    970  C   ASP A 117      42.729  13.473  22.689  1.00 57.86           C  
ATOM    971  O   ASP A 117      42.029  13.256  21.685  1.00 58.78           O  
ATOM    972  CB  ASP A 117      44.212  11.460  23.055  1.00 56.01           C  
ATOM    973  CG  ASP A 117      45.543  10.781  22.693  1.00 57.67           C  
ATOM    974  OD1 ASP A 117      46.627  11.310  23.014  1.00 54.24           O  
ATOM    975  OD2 ASP A 117      45.493   9.678  22.105  1.00 54.95           O  
ATOM    976  N   PHE A 118      42.288  14.158  23.746  1.00 54.34           N  
ATOM    977  CA  PHE A 118      40.937  14.709  23.821  1.00 52.20           C  
ATOM    978  C   PHE A 118      40.911  16.086  23.159  1.00 56.87           C  
ATOM    979  O   PHE A 118      39.854  16.593  22.832  1.00 56.59           O  
ATOM    980  CB  PHE A 118      40.478  14.802  25.285  1.00 48.93           C  
ATOM    981  CG  PHE A 118      39.006  15.097  25.454  1.00 37.78           C  
ATOM    982  CD1 PHE A 118      38.055  14.066  25.402  1.00 42.46           C  
ATOM    983  CD2 PHE A 118      38.565  16.404  25.665  1.00 27.45           C  
ATOM    984  CE1 PHE A 118      36.653  14.347  25.558  1.00 39.01           C  
ATOM    985  CE2 PHE A 118      37.188  16.698  25.820  1.00 32.89           C  
ATOM    986  CZ  PHE A 118      36.231  15.674  25.769  1.00 36.34           C  
ATOM    987  N   TYR A 119      42.076  16.712  23.034  1.00 61.99           N  
ATOM    988  CA  TYR A 119      42.187  18.014  22.382  1.00 63.47           C  
ATOM    989  C   TYR A 119      42.238  17.795  20.873  1.00 66.94           C  
ATOM    990  O   TYR A 119      41.558  18.488  20.135  1.00 68.38           O  
ATOM    991  CB  TYR A 119      43.446  18.745  22.842  1.00 66.46           C  
ATOM    992  CG  TYR A 119      43.365  19.400  24.201  1.00 72.38           C  
ATOM    993  CD1 TYR A 119      42.701  18.781  25.268  1.00 73.41           C  
ATOM    994  CD2 TYR A 119      44.027  20.621  24.451  1.00 78.68           C  
ATOM    995  CE1 TYR A 119      42.700  19.332  26.550  1.00 82.62           C  
ATOM    996  CE2 TYR A 119      44.036  21.205  25.754  1.00 82.35           C  
ATOM    997  CZ  TYR A 119      43.368  20.540  26.797  1.00 84.09           C  
ATOM    998  OH  TYR A 119      43.391  21.040  28.082  1.00 89.47           O  
ATOM    999  N   LYS A 120      42.971  16.761  20.436  1.00 68.81           N  
ATOM   1000  CA  LYS A 120      43.116  16.406  19.013  1.00 71.82           C  
ATOM   1001  C   LYS A 120      41.777  16.209  18.267  1.00 72.77           C  
ATOM   1002  O   LYS A 120      41.572  16.791  17.184  1.00 75.11           O  
ATOM   1003  CB  LYS A 120      44.039  15.185  18.847  1.00 66.38           C  
ATOM   1004  CG  LYS A 120      45.493  15.503  19.203  1.00 59.70           C  
ATOM   1005  CD  LYS A 120      46.496  14.535  18.600  1.00 62.07           C  
ATOM   1006  CE  LYS A 120      47.919  14.995  18.904  1.00 57.12           C  
ATOM   1007  NZ  LYS A 120      48.922  14.324  18.038  1.00 55.95           N  
ATOM   1008  N   LYS A 121      40.853  15.469  18.886  1.00 74.54           N  
ATOM   1009  CA  LYS A 121      39.542  15.229  18.287  1.00 76.61           C  
ATOM   1010  C   LYS A 121      38.525  16.303  18.687  1.00 73.46           C  
ATOM   1011  O   LYS A 121      37.683  16.682  17.877  1.00 78.29           O  
ATOM   1012  CB  LYS A 121      38.958  13.867  18.697  1.00 77.99           C  
ATOM   1013  CG  LYS A 121      39.890  12.666  18.785  1.00 83.36           C  
ATOM   1014  CD  LYS A 121      39.060  11.437  19.181  1.00 84.86           C  
ATOM   1015  CE  LYS A 121      39.916  10.210  19.470  1.00 88.61           C  
ATOM   1016  NZ  LYS A 121      39.089   9.053  19.942  1.00 87.82           N  
ATOM   1017  N   PHE A 122      38.606  16.794  19.927  1.00 72.22           N  
ATOM   1018  CA  PHE A 122      37.636  17.775  20.438  1.00 70.00           C  
ATOM   1019  C   PHE A 122      37.976  19.285  20.534  1.00 72.43           C  
ATOM   1020  O   PHE A 122      37.087  20.047  20.912  1.00 70.36           O  
ATOM   1021  CB  PHE A 122      37.054  17.306  21.797  1.00 64.47           C  
ATOM   1022  CG  PHE A 122      36.305  15.986  21.758  1.00 63.58           C  
ATOM   1023  CD1 PHE A 122      36.973  14.770  21.499  1.00 51.39           C  
ATOM   1024  CD2 PHE A 122      34.921  15.952  22.037  1.00 62.17           C  
ATOM   1025  CE1 PHE A 122      36.291  13.528  21.497  1.00 47.20           C  
ATOM   1026  CE2 PHE A 122      34.202  14.713  22.047  1.00 62.56           C  
ATOM   1027  CZ  PHE A 122      34.894  13.492  21.776  1.00 58.61           C  
ATOM   1028  N   ARG A 123      39.192  19.729  20.163  1.00 70.42           N  
ATOM   1029  CA  ARG A 123      39.625  21.171  20.209  1.00 76.92           C  
ATOM   1030  C   ARG A 123      38.656  22.186  19.602  1.00 75.20           C  
ATOM   1031  O   ARG A 123      38.594  23.356  19.985  1.00 75.35           O  
ATOM   1032  CB  ARG A 123      40.956  21.358  19.465  1.00 76.61           C  
ATOM   1033  CG  ARG A 123      42.146  21.728  20.343  1.00 86.44           C  
ATOM   1034  CD  ARG A 123      43.474  21.562  19.587  1.00 90.11           C  
ATOM   1035  NE  ARG A 123      44.468  20.809  20.361  1.00101.05           N  
ATOM   1036  CZ  ARG A 123      45.438  20.042  19.864  1.00101.92           C  
ATOM   1037  NH1 ARG A 123      45.587  19.899  18.559  1.00105.70           N  
ATOM   1038  NH2 ARG A 123      46.222  19.364  20.691  1.00100.40           N  
ATOM   1039  N   ASP A 124      37.949  21.693  18.605  1.00 72.51           N  
ATOM   1040  CA  ASP A 124      36.988  22.417  17.811  1.00 70.62           C  
ATOM   1041  C   ASP A 124      35.704  22.580  18.598  1.00 69.18           C  
ATOM   1042  O   ASP A 124      35.097  23.641  18.600  1.00 64.62           O  
ATOM   1043  CB  ASP A 124      36.743  21.601  16.534  1.00 73.93           C  
ATOM   1044  CG  ASP A 124      37.873  20.589  16.252  1.00 77.50           C  
ATOM   1045  OD1 ASP A 124      39.066  20.984  16.211  1.00 71.93           O  
ATOM   1046  OD2 ASP A 124      37.573  19.387  16.121  1.00 76.63           O  
ATOM   1047  N   LYS A 125      35.356  21.522  19.324  1.00 67.41           N  
ATOM   1048  CA  LYS A 125      34.151  21.446  20.153  1.00 66.00           C  
ATOM   1049  C   LYS A 125      34.369  22.112  21.507  1.00 65.66           C  
ATOM   1050  O   LYS A 125      33.467  22.772  22.025  1.00 61.37           O  
ATOM   1051  CB  LYS A 125      33.753  19.979  20.338  1.00 68.40           C  
ATOM   1052  CG  LYS A 125      33.848  19.167  19.041  1.00 76.85           C  
ATOM   1053  CD  LYS A 125      33.276  17.778  19.189  1.00 74.81           C  
ATOM   1054  CE  LYS A 125      33.263  17.052  17.851  1.00 75.66           C  
ATOM   1055  NZ  LYS A 125      32.489  15.779  17.932  1.00 78.46           N  
ATOM   1056  N   ILE A 126      35.587  21.964  22.036  1.00 62.50           N  
ATOM   1057  CA  ILE A 126      36.031  22.541  23.317  1.00 61.78           C  
ATOM   1058  C   ILE A 126      36.046  24.091  23.304  1.00 66.00           C  
ATOM   1059  O   ILE A 126      35.809  24.726  24.338  1.00 64.80           O  
ATOM   1060  CB  ILE A 126      37.469  21.975  23.704  1.00 62.74           C  
ATOM   1061  CG1 ILE A 126      37.343  20.575  24.298  1.00 56.66           C  
ATOM   1062  CG2 ILE A 126      38.250  22.888  24.669  1.00 58.34           C  
ATOM   1063  CD1 ILE A 126      38.687  19.876  24.449  1.00 52.22           C  
ATOM   1064  N   THR A 127      36.309  24.682  22.137  1.00 62.74           N  
ATOM   1065  CA  THR A 127      36.379  26.136  21.995  1.00 54.10           C  
ATOM   1066  C   THR A 127      35.052  26.836  21.690  1.00 57.43           C  
ATOM   1067  O   THR A 127      34.211  26.331  20.938  1.00 54.83           O  
ATOM   1068  CB  THR A 127      37.404  26.507  20.926  1.00 58.96           C  
ATOM   1069  OG1 THR A 127      38.608  25.771  21.148  1.00 63.26           O  
ATOM   1070  CG2 THR A 127      37.718  27.999  20.929  1.00 59.98           C  
ATOM   1071  N   VAL A 128      34.878  27.989  22.339  1.00 58.13           N  
ATOM   1072  CA  VAL A 128      33.712  28.870  22.195  1.00 64.34           C  
ATOM   1073  C   VAL A 128      34.276  30.270  21.855  1.00 69.98           C  
ATOM   1074  O   VAL A 128      35.339  30.649  22.363  1.00 69.23           O  
ATOM   1075  CB  VAL A 128      32.847  28.937  23.517  1.00 60.32           C  
ATOM   1076  CG1 VAL A 128      31.641  29.861  23.349  1.00 56.38           C  
ATOM   1077  CG2 VAL A 128      32.327  27.563  23.888  1.00 64.27           C  
ATOM   1078  N   GLN A 129      33.604  30.994  20.951  1.00 76.91           N  
ATOM   1079  CA  GLN A 129      34.021  32.341  20.532  1.00 82.02           C  
ATOM   1080  C   GLN A 129      32.930  33.364  20.718  1.00 82.99           C  
ATOM   1081  O   GLN A 129      31.753  33.057  20.531  1.00 87.39           O  
ATOM   1082  CB  GLN A 129      34.395  32.382  19.053  1.00 84.75           C  
ATOM   1083  CG  GLN A 129      35.667  31.670  18.699  1.00 89.83           C  
ATOM   1084  CD  GLN A 129      35.456  30.551  17.706  1.00 98.16           C  
ATOM   1085  OE1 GLN A 129      34.321  30.122  17.433  1.00100.65           O  
ATOM   1086  NE2 GLN A 129      36.556  30.064  17.153  1.00101.29           N  
ATOM   1087  N   GLY A 130      33.344  34.595  21.005  1.00 85.97           N  
ATOM   1088  CA  GLY A 130      32.421  35.703  21.175  1.00 83.86           C  
ATOM   1089  C   GLY A 130      32.993  36.900  20.438  1.00 91.82           C  
ATOM   1090  O   GLY A 130      33.958  36.777  19.661  1.00 95.61           O  
ATOM   1091  N   LYS A 131      32.365  38.056  20.627  1.00 95.05           N  
ATOM   1092  CA  LYS A 131      32.863  39.278  20.015  1.00 96.16           C  
ATOM   1093  C   LYS A 131      33.750  39.920  21.100  1.00 98.35           C  
ATOM   1094  O   LYS A 131      33.238  40.321  22.157  1.00102.03           O  
ATOM   1095  CB  LYS A 131      31.700  40.203  19.613  1.00 94.96           C  
ATOM   1096  CG  LYS A 131      32.127  41.375  18.731  1.00 99.29           C  
ATOM   1097  CD  LYS A 131      31.181  42.552  18.850  1.00 95.12           C  
ATOM   1098  CE  LYS A 131      31.959  43.858  18.901  1.00 96.28           C  
ATOM   1099  NZ  LYS A 131      31.187  44.991  18.322  1.00100.08           N  
ATOM   1100  N   ASN A 132      35.072  39.962  20.835  1.00 95.96           N  
ATOM   1101  CA  ASN A 132      36.166  40.521  21.692  1.00 96.08           C  
ATOM   1102  C   ASN A 132      36.808  39.584  22.769  1.00 95.88           C  
ATOM   1103  O   ASN A 132      37.637  40.053  23.574  1.00 91.26           O  
ATOM   1104  CB  ASN A 132      35.812  41.898  22.356  1.00101.49           C  
ATOM   1105  CG  ASN A 132      35.192  42.916  21.380  1.00100.53           C  
ATOM   1106  OD1 ASN A 132      35.851  43.405  20.461  1.00 98.99           O  
ATOM   1107  ND2 ASN A 132      33.908  43.225  21.588  1.00 96.81           N  
ATOM   1108  N   ARG A 133      36.481  38.279  22.736  1.00 91.21           N  
ATOM   1109  CA  ARG A 133      36.997  37.282  23.706  1.00 85.19           C  
ATOM   1110  C   ARG A 133      36.855  35.816  23.210  1.00 82.56           C  
ATOM   1111  O   ARG A 133      35.907  35.489  22.505  1.00 80.03           O  
ATOM   1112  CB  ARG A 133      36.265  37.482  25.046  1.00 89.54           C  
ATOM   1113  CG  ARG A 133      36.824  36.792  26.290  1.00 90.90           C  
ATOM   1114  CD  ARG A 133      36.164  37.410  27.530  1.00 94.37           C  
ATOM   1115  NE  ARG A 133      36.298  36.610  28.749  1.00 94.33           N  
ATOM   1116  CZ  ARG A 133      35.498  36.709  29.812  1.00 93.43           C  
ATOM   1117  NH1 ARG A 133      34.497  37.575  29.827  1.00 96.16           N  
ATOM   1118  NH2 ARG A 133      35.695  35.929  30.863  1.00 90.45           N  
ATOM   1119  N   LYS A 134      37.786  34.944  23.613  1.00 77.50           N  
ATOM   1120  CA  LYS A 134      37.824  33.509  23.222  1.00 73.31           C  
ATOM   1121  C   LYS A 134      38.082  32.593  24.467  1.00 67.42           C  
ATOM   1122  O   LYS A 134      39.073  32.757  25.188  1.00 64.68           O  
ATOM   1123  CB  LYS A 134      38.923  33.315  22.151  1.00 77.18           C  
ATOM   1124  CG  LYS A 134      38.767  32.140  21.180  1.00 73.43           C  
ATOM   1125  CD  LYS A 134      39.942  32.088  20.163  1.00 68.43           C  
ATOM   1126  CE  LYS A 134      39.918  30.824  19.258  1.00 75.77           C  
ATOM   1127  NZ  LYS A 134      41.125  30.661  18.364  1.00 69.17           N  
ATOM   1128  N   ILE A 135      37.166  31.650  24.713  1.00 67.59           N  
ATOM   1129  CA  ILE A 135      37.215  30.717  25.865  1.00 62.55           C  
ATOM   1130  C   ILE A 135      37.389  29.214  25.466  1.00 61.78           C  
ATOM   1131  O   ILE A 135      37.047  28.812  24.344  1.00 61.10           O  
ATOM   1132  CB  ILE A 135      35.897  30.849  26.742  1.00 59.68           C  
ATOM   1133  CG1 ILE A 135      35.598  32.306  27.093  1.00 61.21           C  
ATOM   1134  CG2 ILE A 135      36.033  30.105  28.059  1.00 61.94           C  
ATOM   1135  CD1 ILE A 135      34.242  32.520  27.737  1.00 62.46           C  
ATOM   1136  N   ALA A 136      37.919  28.406  26.398  1.00 59.98           N  
ATOM   1137  CA  ALA A 136      38.135  26.954  26.239  1.00 54.02           C  
ATOM   1138  C   ALA A 136      37.590  26.216  27.465  1.00 44.90           C  
ATOM   1139  O   ALA A 136      37.664  26.714  28.587  1.00 49.48           O  
ATOM   1140  CB  ALA A 136      39.615  26.642  26.066  1.00 53.17           C  
ATOM   1141  N   LEU A 137      37.022  25.037  27.232  1.00 49.26           N  
ATOM   1142  CA  LEU A 137      36.443  24.199  28.289  1.00 47.09           C  
ATOM   1143  C   LEU A 137      37.422  23.079  28.595  1.00 43.78           C  
ATOM   1144  O   LEU A 137      37.236  21.953  28.157  1.00 47.52           O  
ATOM   1145  CB  LEU A 137      35.117  23.587  27.815  1.00 50.58           C  
ATOM   1146  CG  LEU A 137      34.013  24.500  27.285  1.00 55.81           C  
ATOM   1147  CD1 LEU A 137      33.260  23.813  26.149  1.00 54.54           C  
ATOM   1148  CD2 LEU A 137      33.089  24.917  28.411  1.00 53.05           C  
ATOM   1149  N   ILE A 138      38.460  23.387  29.360  1.00 44.45           N  
ATOM   1150  CA  ILE A 138      39.490  22.407  29.698  1.00 42.97           C  
ATOM   1151  C   ILE A 138      38.989  21.228  30.542  1.00 47.88           C  
ATOM   1152  O   ILE A 138      38.190  21.416  31.439  1.00 49.62           O  
ATOM   1153  CB  ILE A 138      40.722  23.133  30.310  1.00 42.68           C  
ATOM   1154  CG1 ILE A 138      41.407  23.909  29.181  1.00 43.50           C  
ATOM   1155  CG2 ILE A 138      41.715  22.140  30.983  1.00 36.69           C  
ATOM   1156  CD1 ILE A 138      42.263  25.059  29.634  1.00 56.29           C  
ATOM   1157  N   PRO A 139      39.323  19.985  30.138  1.00 49.30           N  
ATOM   1158  CA  PRO A 139      38.896  18.790  30.885  1.00 53.01           C  
ATOM   1159  C   PRO A 139      39.781  18.504  32.082  1.00 54.61           C  
ATOM   1160  O   PRO A 139      41.012  18.583  32.006  1.00 54.65           O  
ATOM   1161  CB  PRO A 139      39.047  17.662  29.871  1.00 46.40           C  
ATOM   1162  CG  PRO A 139      39.115  18.349  28.576  1.00 47.92           C  
ATOM   1163  CD  PRO A 139      39.848  19.591  28.821  1.00 46.72           C  
ATOM   1164  N   GLU A 140      39.138  18.193  33.196  1.00 60.06           N  
ATOM   1165  CA  GLU A 140      39.849  17.836  34.412  1.00 63.90           C  
ATOM   1166  C   GLU A 140      39.348  16.459  34.800  1.00 58.36           C  
ATOM   1167  O   GLU A 140      38.148  16.142  34.701  1.00 54.35           O  
ATOM   1168  CB  GLU A 140      39.642  18.864  35.542  1.00 68.80           C  
ATOM   1169  CG  GLU A 140      38.208  18.968  36.077  1.00 77.15           C  
ATOM   1170  CD  GLU A 140      37.963  20.152  36.992  1.00 88.26           C  
ATOM   1171  OE1 GLU A 140      38.934  20.633  37.622  1.00 92.24           O  
ATOM   1172  OE2 GLU A 140      36.786  20.593  37.081  1.00 89.11           O  
ATOM   1173  N   VAL A 141      40.318  15.607  35.099  1.00 56.34           N  
ATOM   1174  CA  VAL A 141      40.049  14.245  35.494  1.00 52.83           C  
ATOM   1175  C   VAL A 141      40.527  14.097  36.935  1.00 48.58           C  
ATOM   1176  O   VAL A 141      41.732  14.101  37.216  1.00 41.11           O  
ATOM   1177  CB  VAL A 141      40.748  13.210  34.563  1.00 45.31           C  
ATOM   1178  CG1 VAL A 141      39.871  11.996  34.397  1.00 48.19           C  
ATOM   1179  CG2 VAL A 141      41.081  13.815  33.189  1.00 51.20           C  
ATOM   1180  N   ASN A 142      39.554  14.071  37.841  1.00 46.00           N  
ATOM   1181  CA  ASN A 142      39.810  13.921  39.261  1.00 49.76           C  
ATOM   1182  C   ASN A 142      39.485  12.496  39.735  1.00 48.09           C  
ATOM   1183  O   ASN A 142      38.406  11.960  39.444  1.00 48.27           O  
ATOM   1184  CB  ASN A 142      39.015  14.971  40.051  1.00 52.35           C  
ATOM   1185  CG  ASN A 142      39.614  16.395  39.940  1.00 62.65           C  
ATOM   1186  OD1 ASN A 142      40.440  16.707  39.064  1.00 64.25           O  
ATOM   1187  ND2 ASN A 142      39.190  17.261  40.851  1.00 61.03           N  
ATOM   1188  N   GLU A 143      40.482  11.859  40.358  1.00 50.07           N  
ATOM   1189  CA  GLU A 143      40.376  10.494  40.911  1.00 45.28           C  
ATOM   1190  C   GLU A 143      40.628  10.530  42.412  1.00 47.67           C  
ATOM   1191  O   GLU A 143      41.580  11.158  42.891  1.00 50.48           O  
ATOM   1192  CB  GLU A 143      41.432   9.518  40.349  1.00 44.07           C  
ATOM   1193  CG  GLU A 143      41.649   9.485  38.857  1.00 36.04           C  
ATOM   1194  CD  GLU A 143      42.491  10.638  38.365  1.00 34.03           C  
ATOM   1195  OE1 GLU A 143      43.221  11.260  39.170  1.00 32.63           O  
ATOM   1196  OE2 GLU A 143      42.422  10.923  37.154  1.00 38.03           O  
ATOM   1197  N   LYS A 144      39.780   9.835  43.145  1.00 47.35           N  
ATOM   1198  CA  LYS A 144      39.923   9.718  44.583  1.00 41.64           C  
ATOM   1199  C   LYS A 144      39.595   8.261  44.920  1.00 40.07           C  
ATOM   1200  O   LYS A 144      38.754   7.642  44.257  1.00 42.27           O  
ATOM   1201  CB  LYS A 144      38.995  10.699  45.300  1.00 37.05           C  
ATOM   1202  CG  LYS A 144      39.658  12.016  45.597  1.00 45.00           C  
ATOM   1203  CD  LYS A 144      38.657  13.109  45.821  1.00 44.00           C  
ATOM   1204  CE  LYS A 144      39.376  14.429  46.020  1.00 49.81           C  
ATOM   1205  NZ  LYS A 144      38.480  15.579  45.671  1.00 57.02           N  
ATOM   1206  N   VAL A 145      40.343   7.674  45.850  1.00 39.02           N  
ATOM   1207  CA  VAL A 145      40.094   6.297  46.258  1.00 33.56           C  
ATOM   1208  C   VAL A 145      39.281   6.279  47.541  1.00 29.87           C  
ATOM   1209  O   VAL A 145      39.700   6.826  48.552  1.00 34.16           O  
ATOM   1210  CB  VAL A 145      41.398   5.489  46.414  1.00 32.38           C  
ATOM   1211  CG1 VAL A 145      41.122   4.141  47.055  1.00 36.21           C  
ATOM   1212  CG2 VAL A 145      42.048   5.291  45.033  1.00 33.91           C  
ATOM   1213  N   LEU A 146      38.082   5.710  47.442  1.00 28.78           N  
ATOM   1214  CA  LEU A 146      37.136   5.565  48.555  1.00 21.58           C  
ATOM   1215  C   LEU A 146      37.087   4.109  48.998  1.00 16.84           C  
ATOM   1216  O   LEU A 146      37.744   3.266  48.400  1.00 14.65           O  
ATOM   1217  CB  LEU A 146      35.729   6.045  48.164  1.00 14.33           C  
ATOM   1218  CG  LEU A 146      35.496   7.410  47.498  1.00  2.00           C  
ATOM   1219  CD1 LEU A 146      34.062   7.776  47.700  1.00  2.00           C  
ATOM   1220  CD2 LEU A 146      36.408   8.519  48.058  1.00  3.19           C  
ATOM   1221  N   LYS A 147      36.305   3.822  50.031  1.00 21.17           N  
ATOM   1222  CA  LYS A 147      36.215   2.483  50.596  1.00 27.00           C  
ATOM   1223  C   LYS A 147      34.764   2.172  50.742  1.00 30.31           C  
ATOM   1224  O   LYS A 147      34.041   2.942  51.385  1.00 38.63           O  
ATOM   1225  CB  LYS A 147      36.819   2.486  51.996  1.00 22.29           C  
ATOM   1226  CG  LYS A 147      37.151   1.147  52.602  1.00 27.48           C  
ATOM   1227  CD  LYS A 147      37.758   1.339  53.981  1.00 23.04           C  
ATOM   1228  CE  LYS A 147      37.808   0.034  54.752  1.00 28.11           C  
ATOM   1229  NZ  LYS A 147      38.179   0.280  56.171  1.00 34.33           N  
ATOM   1230  N   SER A 148      34.360   1.004  50.248  1.00 40.38           N  
ATOM   1231  CA  SER A 148      32.964   0.575  50.330  1.00 41.67           C  
ATOM   1232  C   SER A 148      32.536   0.170  51.749  1.00 40.91           C  
ATOM   1233  O   SER A 148      33.338   0.179  52.704  1.00 39.95           O  
ATOM   1234  CB  SER A 148      32.696  -0.578  49.352  1.00 47.52           C  
ATOM   1235  OG  SER A 148      33.460  -1.740  49.667  1.00 57.66           O  
ATOM   1236  N   GLU A 149      31.257  -0.178  51.867  1.00 40.70           N  
ATOM   1237  CA  GLU A 149      30.650  -0.614  53.122  1.00 41.94           C  
ATOM   1238  C   GLU A 149      31.316  -1.928  53.541  1.00 40.02           C  
ATOM   1239  O   GLU A 149      31.830  -2.054  54.662  1.00 46.80           O  
ATOM   1240  CB  GLU A 149      29.142  -0.828  52.899  1.00 39.16           C  
ATOM   1241  CG  GLU A 149      28.321  -1.046  54.178  1.00 32.51           C  
ATOM   1242  CD  GLU A 149      26.888  -1.499  53.917  1.00 31.90           C  
ATOM   1243  OE1 GLU A 149      26.515  -1.781  52.756  1.00 23.09           O  
ATOM   1244  OE2 GLU A 149      26.128  -1.569  54.902  1.00 31.01           O  
ATOM   1245  N   GLU A 150      31.432  -2.816  52.551  1.00 39.48           N  
ATOM   1246  CA  GLU A 150      31.996  -4.150  52.695  1.00 39.62           C  
ATOM   1247  C   GLU A 150      33.499  -4.161  52.975  1.00 36.62           C  
ATOM   1248  O   GLU A 150      33.988  -5.062  53.673  1.00 42.86           O  
ATOM   1249  CB  GLU A 150      31.661  -4.971  51.455  1.00 38.10           C  
ATOM   1250  CG  GLU A 150      30.256  -4.722  50.915  1.00 42.32           C  
ATOM   1251  CD  GLU A 150      29.693  -5.919  50.177  1.00 45.07           C  
ATOM   1252  OE1 GLU A 150      30.288  -6.322  49.148  1.00 47.93           O  
ATOM   1253  OE2 GLU A 150      28.649  -6.455  50.621  1.00 34.89           O  
ATOM   1254  N   GLY A 151      34.213  -3.160  52.450  1.00 37.15           N  
ATOM   1255  CA  GLY A 151      35.643  -3.061  52.688  1.00 33.27           C  
ATOM   1256  C   GLY A 151      36.595  -2.950  51.507  1.00 33.89           C  
ATOM   1257  O   GLY A 151      37.823  -2.815  51.732  1.00 35.81           O  
ATOM   1258  N   TYR A 152      36.059  -3.000  50.275  1.00 33.73           N  
ATOM   1259  CA  TYR A 152      36.863  -2.904  49.045  1.00 34.47           C  
ATOM   1260  C   TYR A 152      37.105  -1.437  48.717  1.00 34.49           C  
ATOM   1261  O   TYR A 152      36.270  -0.575  49.032  1.00 29.02           O  
ATOM   1262  CB  TYR A 152      36.162  -3.575  47.849  1.00 38.49           C  
ATOM   1263  CG  TYR A 152      35.665  -4.980  48.130  1.00 59.81           C  
ATOM   1264  CD1 TYR A 152      36.450  -6.122  47.817  1.00 61.20           C  
ATOM   1265  CD2 TYR A 152      34.446  -5.186  48.815  1.00 61.53           C  
ATOM   1266  CE1 TYR A 152      36.024  -7.463  48.212  1.00 66.40           C  
ATOM   1267  CE2 TYR A 152      34.015  -6.506  49.209  1.00 62.99           C  
ATOM   1268  CZ  TYR A 152      34.802  -7.633  48.915  1.00 63.43           C  
ATOM   1269  OH  TYR A 152      34.376  -8.879  49.362  1.00 55.84           O  
ATOM   1270  N   PHE A 153      38.268  -1.153  48.128  1.00 34.77           N  
ATOM   1271  CA  PHE A 153      38.604   0.210  47.720  1.00 30.11           C  
ATOM   1272  C   PHE A 153      37.962   0.511  46.374  1.00 31.24           C  
ATOM   1273  O   PHE A 153      37.901  -0.354  45.494  1.00 33.64           O  
ATOM   1274  CB  PHE A 153      40.115   0.417  47.644  1.00 28.05           C  
ATOM   1275  CG  PHE A 153      40.809   0.372  48.989  1.00 27.72           C  
ATOM   1276  CD1 PHE A 153      42.171   0.015  49.078  1.00 31.46           C  
ATOM   1277  CD2 PHE A 153      40.120   0.698  50.177  1.00 19.61           C  
ATOM   1278  CE1 PHE A 153      42.833  -0.016  50.323  1.00 20.50           C  
ATOM   1279  CE2 PHE A 153      40.775   0.669  51.421  1.00 16.75           C  
ATOM   1280  CZ  PHE A 153      42.135   0.310  51.492  1.00 15.04           C  
ATOM   1281  N   LEU A 154      37.364   1.689  46.259  1.00 23.53           N  
ATOM   1282  CA  LEU A 154      36.708   2.073  45.015  1.00 26.98           C  
ATOM   1283  C   LEU A 154      37.413   3.240  44.353  1.00 24.36           C  
ATOM   1284  O   LEU A 154      37.817   4.197  45.026  1.00 30.79           O  
ATOM   1285  CB  LEU A 154      35.256   2.475  45.276  1.00 13.76           C  
ATOM   1286  CG  LEU A 154      34.425   1.474  46.068  1.00 17.74           C  
ATOM   1287  CD1 LEU A 154      33.078   2.019  46.440  1.00 11.66           C  
ATOM   1288  CD2 LEU A 154      34.331   0.175  45.267  1.00 15.82           C  
ATOM   1289  N   LEU A 155      37.634   3.151  43.046  1.00 24.60           N  
ATOM   1290  CA  LEU A 155      38.224   4.281  42.390  1.00 19.41           C  
ATOM   1291  C   LEU A 155      37.055   5.094  41.933  1.00 22.19           C  
ATOM   1292  O   LEU A 155      36.159   4.608  41.231  1.00 19.04           O  
ATOM   1293  CB  LEU A 155      39.120   3.928  41.216  1.00 15.36           C  
ATOM   1294  CG  LEU A 155      39.708   5.153  40.488  1.00 14.60           C  
ATOM   1295  CD1 LEU A 155      40.650   5.969  41.369  1.00 20.94           C  
ATOM   1296  CD2 LEU A 155      40.426   4.687  39.268  1.00 17.57           C  
ATOM   1297  N   HIS A 156      36.985   6.262  42.552  1.00 25.24           N  
ATOM   1298  CA  HIS A 156      35.994   7.252  42.234  1.00 27.72           C  
ATOM   1299  C   HIS A 156      36.684   8.047  41.126  1.00 33.78           C  
ATOM   1300  O   HIS A 156      37.742   8.664  41.356  1.00 31.69           O  
ATOM   1301  CB  HIS A 156      35.716   8.137  43.443  1.00 21.11           C  
ATOM   1302  CG  HIS A 156      34.970   9.390  43.120  1.00 27.98           C  
ATOM   1303  ND1 HIS A 156      34.306   9.573  41.926  1.00 25.40           N  
ATOM   1304  CD2 HIS A 156      34.845  10.551  43.805  1.00 29.82           C  
ATOM   1305  CE1 HIS A 156      33.815  10.800  41.877  1.00 30.03           C  
ATOM   1306  NE2 HIS A 156      34.125  11.411  43.006  1.00 38.35           N  
ATOM   1307  N   LEU A 157      36.087   7.984  39.932  1.00 34.65           N  
ATOM   1308  CA  LEU A 157      36.614   8.683  38.774  1.00 35.85           C  
ATOM   1309  C   LEU A 157      35.570   9.524  38.053  1.00 34.24           C  
ATOM   1310  O   LEU A 157      34.506   9.037  37.671  1.00 35.39           O  
ATOM   1311  CB  LEU A 157      37.271   7.681  37.831  1.00 34.06           C  
ATOM   1312  CG  LEU A 157      37.840   8.045  36.456  1.00 32.09           C  
ATOM   1313  CD1 LEU A 157      38.699   9.283  36.449  1.00 32.55           C  
ATOM   1314  CD2 LEU A 157      38.655   6.866  36.018  1.00 37.66           C  
ATOM   1315  N   ASP A 158      35.910  10.788  37.848  1.00 37.46           N  
ATOM   1316  CA  ASP A 158      35.021  11.711  37.172  1.00 39.80           C  
ATOM   1317  C   ASP A 158      35.782  12.533  36.140  1.00 42.03           C  
ATOM   1318  O   ASP A 158      37.022  12.533  36.103  1.00 41.27           O  
ATOM   1319  CB  ASP A 158      34.346  12.645  38.195  1.00 42.06           C  
ATOM   1320  CG  ASP A 158      32.904  13.012  37.820  1.00 40.63           C  
ATOM   1321  OD1 ASP A 158      32.562  13.082  36.611  1.00 27.63           O  
ATOM   1322  OD2 ASP A 158      32.115  13.232  38.764  1.00 44.26           O  
ATOM   1323  N   LEU A 159      34.994  13.230  35.315  1.00 38.94           N  
ATOM   1324  CA  LEU A 159      35.461  14.110  34.252  1.00 39.42           C  
ATOM   1325  C   LEU A 159      34.628  15.381  34.287  1.00 37.65           C  
ATOM   1326  O   LEU A 159      33.413  15.355  34.086  1.00 32.96           O  
ATOM   1327  CB  LEU A 159      35.311  13.435  32.888  1.00 36.59           C  
ATOM   1328  CG  LEU A 159      35.847  14.260  31.728  1.00 35.99           C  
ATOM   1329  CD1 LEU A 159      37.354  14.168  31.666  1.00 43.29           C  
ATOM   1330  CD2 LEU A 159      35.252  13.750  30.467  1.00 39.89           C  
ATOM   1331  N   LYS A 160      35.273  16.487  34.614  1.00 36.96           N  
ATOM   1332  CA  LYS A 160      34.576  17.760  34.655  1.00 49.02           C  
ATOM   1333  C   LYS A 160      35.242  18.723  33.671  1.00 44.35           C  
ATOM   1334  O   LYS A 160      36.284  18.392  33.115  1.00 44.89           O  
ATOM   1335  CB  LYS A 160      34.532  18.270  36.104  1.00 55.52           C  
ATOM   1336  CG  LYS A 160      33.630  17.381  36.998  1.00 70.15           C  
ATOM   1337  CD  LYS A 160      33.666  17.676  38.498  1.00 76.90           C  
ATOM   1338  CE  LYS A 160      32.776  16.664  39.243  1.00 78.87           C  
ATOM   1339  NZ  LYS A 160      32.676  16.893  40.707  1.00 69.28           N  
ATOM   1340  N   PHE A 161      34.585  19.842  33.355  1.00 43.01           N  
ATOM   1341  CA  PHE A 161      35.141  20.837  32.422  1.00 42.49           C  
ATOM   1342  C   PHE A 161      35.400  22.176  33.065  1.00 41.60           C  
ATOM   1343  O   PHE A 161      34.481  22.870  33.483  1.00 39.58           O  
ATOM   1344  CB  PHE A 161      34.259  21.030  31.184  1.00 43.89           C  
ATOM   1345  CG  PHE A 161      34.257  19.856  30.253  1.00 51.22           C  
ATOM   1346  CD1 PHE A 161      33.257  18.871  30.353  1.00 52.31           C  
ATOM   1347  CD2 PHE A 161      35.288  19.686  29.308  1.00 54.22           C  
ATOM   1348  CE1 PHE A 161      33.289  17.722  29.531  1.00 54.15           C  
ATOM   1349  CE2 PHE A 161      35.328  18.537  28.477  1.00 47.97           C  
ATOM   1350  CZ  PHE A 161      34.325  17.551  28.593  1.00 51.26           C  
ATOM   1351  N   ARG A 162      36.675  22.525  33.117  1.00 39.59           N  
ATOM   1352  CA  ARG A 162      37.153  23.766  33.704  1.00 41.98           C  
ATOM   1353  C   ARG A 162      37.056  24.839  32.636  1.00 42.28           C  
ATOM   1354  O   ARG A 162      37.645  24.701  31.564  1.00 37.50           O  
ATOM   1355  CB  ARG A 162      38.613  23.577  34.171  1.00 46.77           C  
ATOM   1356  CG  ARG A 162      39.156  24.672  35.054  1.00 54.01           C  
ATOM   1357  CD  ARG A 162      38.431  24.724  36.377  1.00 71.06           C  
ATOM   1358  NE  ARG A 162      39.022  23.877  37.414  1.00 75.99           N  
ATOM   1359  CZ  ARG A 162      38.475  23.654  38.612  1.00 76.95           C  
ATOM   1360  NH1 ARG A 162      37.303  24.202  38.946  1.00 73.68           N  
ATOM   1361  NH2 ARG A 162      39.132  22.917  39.506  1.00 78.42           N  
ATOM   1362  N   ILE A 163      36.261  25.873  32.912  1.00 41.13           N  
ATOM   1363  CA  ILE A 163      36.067  26.977  31.962  1.00 43.68           C  
ATOM   1364  C   ILE A 163      37.205  27.965  32.157  1.00 43.54           C  
ATOM   1365  O   ILE A 163      37.372  28.534  33.229  1.00 43.31           O  
ATOM   1366  CB  ILE A 163      34.679  27.684  32.143  1.00 47.61           C  
ATOM   1367  CG1 ILE A 163      33.548  26.647  32.305  1.00 47.35           C  
ATOM   1368  CG2 ILE A 163      34.368  28.542  30.918  1.00 39.86           C  
ATOM   1369  CD1 ILE A 163      32.203  27.222  32.769  1.00 42.14           C  
ATOM   1370  N   GLN A 164      38.016  28.131  31.119  1.00 44.38           N  
ATOM   1371  CA  GLN A 164      39.177  29.002  31.187  1.00 50.70           C  
ATOM   1372  C   GLN A 164      39.391  29.800  29.912  1.00 52.64           C  
ATOM   1373  O   GLN A 164      39.103  29.288  28.841  1.00 55.94           O  
ATOM   1374  CB  GLN A 164      40.432  28.149  31.445  1.00 51.96           C  
ATOM   1375  CG  GLN A 164      40.711  27.838  32.913  1.00 51.07           C  
ATOM   1376  CD  GLN A 164      41.916  26.966  33.117  1.00 58.23           C  
ATOM   1377  OE1 GLN A 164      42.806  26.886  32.278  1.00 55.62           O  
ATOM   1378  NE2 GLN A 164      41.958  26.308  34.251  1.00 60.09           N  
ATOM   1379  N   PRO A 165      39.850  31.076  30.012  1.00 58.42           N  
ATOM   1380  CA  PRO A 165      40.111  31.929  28.839  1.00 57.27           C  
ATOM   1381  C   PRO A 165      41.476  31.593  28.229  1.00 60.58           C  
ATOM   1382  O   PRO A 165      42.360  31.080  28.919  1.00 61.89           O  
ATOM   1383  CB  PRO A 165      40.144  33.345  29.429  1.00 61.70           C  
ATOM   1384  CG  PRO A 165      39.373  33.230  30.681  1.00 63.78           C  
ATOM   1385  CD  PRO A 165      39.850  31.923  31.222  1.00 63.95           C  
ATOM   1386  N   PHE A 166      41.639  31.907  26.946  1.00 59.32           N  
ATOM   1387  CA  PHE A 166      42.884  31.649  26.225  1.00 62.37           C  
ATOM   1388  C   PHE A 166      43.995  32.525  26.780  1.00 65.80           C  
ATOM   1389  O   PHE A 166      45.149  32.092  26.921  1.00 64.42           O  
ATOM   1390  CB  PHE A 166      42.683  31.940  24.729  1.00 70.04           C  
ATOM   1391  CG  PHE A 166      42.206  30.749  23.934  1.00 71.61           C  
ATOM   1392  CD1 PHE A 166      40.884  30.274  24.067  1.00 74.96           C  
ATOM   1393  CD2 PHE A 166      43.087  30.073  23.058  1.00 76.29           C  
ATOM   1394  CE1 PHE A 166      40.436  29.129  23.334  1.00 69.06           C  
ATOM   1395  CE2 PHE A 166      42.663  28.923  22.312  1.00 75.92           C  
ATOM   1396  CZ  PHE A 166      41.328  28.453  22.456  1.00 71.62           C  
ATOM   1397  N   GLU A 167      43.583  33.722  27.193  1.00 62.28           N  
ATOM   1398  CA  GLU A 167      44.467  34.735  27.740  1.00 61.19           C  
ATOM   1399  C   GLU A 167      44.886  34.381  29.138  1.00 53.26           C  
ATOM   1400  O   GLU A 167      44.114  33.837  29.924  1.00 53.78           O  
ATOM   1401  CB  GLU A 167      43.780  36.102  27.770  1.00 68.34           C  
ATOM   1402  CG  GLU A 167      43.032  36.517  26.491  1.00 67.90           C  
ATOM   1403  CD  GLU A 167      41.529  36.574  26.701  1.00 69.84           C  
ATOM   1404  OE1 GLU A 167      41.076  37.436  27.481  1.00 73.80           O  
ATOM   1405  OE2 GLU A 167      40.802  35.758  26.096  1.00 73.23           O  
ATOM   1406  N   THR A 168      46.126  34.724  29.427  1.00 52.19           N  
ATOM   1407  CA  THR A 168      46.765  34.512  30.711  1.00 43.87           C  
ATOM   1408  C   THR A 168      46.252  35.612  31.654  1.00 40.24           C  
ATOM   1409  O   THR A 168      45.520  36.505  31.218  1.00 36.11           O  
ATOM   1410  CB  THR A 168      48.288  34.635  30.476  1.00 45.53           C  
ATOM   1411  OG1 THR A 168      48.710  33.580  29.610  1.00 45.65           O  
ATOM   1412  CG2 THR A 168      49.065  34.564  31.715  1.00 43.11           C  
ATOM   1413  N   LEU A 169      46.581  35.515  32.940  1.00 35.51           N  
ATOM   1414  CA  LEU A 169      46.191  36.544  33.899  1.00 32.37           C  
ATOM   1415  C   LEU A 169      47.098  37.760  33.664  1.00 30.35           C  
ATOM   1416  O   LEU A 169      46.672  38.872  33.891  1.00 25.86           O  
ATOM   1417  CB  LEU A 169      46.276  36.044  35.350  1.00 33.67           C  
ATOM   1418  CG  LEU A 169      45.636  36.894  36.473  1.00 31.80           C  
ATOM   1419  CD1 LEU A 169      44.157  36.980  36.274  1.00 31.58           C  
ATOM   1420  CD2 LEU A 169      45.894  36.338  37.843  1.00 22.88           C  
ATOM   1421  N   GLN A 170      48.300  37.535  33.118  1.00 34.07           N  
ATOM   1422  CA  GLN A 170      49.253  38.607  32.771  1.00 31.28           C  
ATOM   1423  C   GLN A 170      48.765  39.371  31.521  1.00 33.45           C  
ATOM   1424  O   GLN A 170      48.676  40.599  31.548  1.00 32.51           O  
ATOM   1425  CB  GLN A 170      50.660  38.028  32.525  1.00 28.73           C  
ATOM   1426  CG  GLN A 170      51.808  39.036  32.382  1.00 27.95           C  
ATOM   1427  CD  GLN A 170      51.894  40.039  33.516  1.00 34.48           C  
ATOM   1428  OE1 GLN A 170      52.103  39.683  34.682  1.00 37.52           O  
ATOM   1429  NE2 GLN A 170      51.740  41.311  33.176  1.00 35.07           N  
ATOM   1430  N   THR A 171      48.388  38.638  30.468  1.00 28.71           N  
ATOM   1431  CA  THR A 171      47.869  39.208  29.223  1.00 30.87           C  
ATOM   1432  C   THR A 171      46.621  40.045  29.560  1.00 40.12           C  
ATOM   1433  O   THR A 171      46.401  41.106  28.985  1.00 38.75           O  
ATOM   1434  CB  THR A 171      47.476  38.084  28.224  1.00 31.96           C  
ATOM   1435  OG1 THR A 171      48.574  37.163  28.053  1.00 21.02           O  
ATOM   1436  CG2 THR A 171      47.061  38.673  26.876  1.00 27.65           C  
ATOM   1437  N   LEU A 172      45.872  39.577  30.561  1.00 43.88           N  
ATOM   1438  CA  LEU A 172      44.648  40.229  31.045  1.00 48.15           C  
ATOM   1439  C   LEU A 172      44.876  41.453  31.911  1.00 49.54           C  
ATOM   1440  O   LEU A 172      44.175  42.446  31.746  1.00 53.11           O  
ATOM   1441  CB  LEU A 172      43.767  39.242  31.823  1.00 46.81           C  
ATOM   1442  CG  LEU A 172      42.742  38.420  31.044  1.00 53.52           C  
ATOM   1443  CD1 LEU A 172      42.293  37.250  31.883  1.00 46.71           C  
ATOM   1444  CD2 LEU A 172      41.564  39.275  30.642  1.00 48.92           C  
ATOM   1445  N   LEU A 173      45.810  41.366  32.860  1.00 51.14           N  
ATOM   1446  CA  LEU A 173      46.129  42.487  33.757  1.00 50.21           C  
ATOM   1447  C   LEU A 173      46.791  43.643  32.992  1.00 55.83           C  
ATOM   1448  O   LEU A 173      46.670  44.817  33.386  1.00 56.45           O  
ATOM   1449  CB  LEU A 173      47.036  42.030  34.916  1.00 52.22           C  
ATOM   1450  CG  LEU A 173      46.518  41.105  36.037  1.00 54.00           C  
ATOM   1451  CD1 LEU A 173      47.640  40.676  36.987  1.00 49.25           C  
ATOM   1452  CD2 LEU A 173      45.391  41.751  36.798  1.00 47.83           C  
ATOM   1453  N   GLU A 174      47.424  43.286  31.865  1.00 63.68           N  
ATOM   1454  CA  GLU A 174      48.114  44.205  30.943  1.00 63.58           C  
ATOM   1455  C   GLU A 174      47.139  45.107  30.186  1.00 65.75           C  
ATOM   1456  O   GLU A 174      47.207  46.333  30.320  1.00 64.46           O  
ATOM   1457  CB  GLU A 174      48.902  43.422  29.889  1.00 60.36           C  
ATOM   1458  CG  GLU A 174      50.397  43.313  30.076  1.00 62.42           C  
ATOM   1459  CD  GLU A 174      51.034  42.525  28.937  1.00 69.04           C  
ATOM   1460  OE1 GLU A 174      50.937  42.968  27.764  1.00 71.85           O  
ATOM   1461  OE2 GLU A 174      51.598  41.442  29.207  1.00 64.79           O  
ATOM   1462  N   ARG A 175      46.210  44.493  29.438  1.00 68.39           N  
ATOM   1463  CA  ARG A 175      45.247  45.227  28.613  1.00 67.28           C  
ATOM   1464  C   ARG A 175      44.268  46.178  29.302  1.00 73.45           C  
ATOM   1465  O   ARG A 175      44.296  47.387  29.034  1.00 73.30           O  
ATOM   1466  CB  ARG A 175      44.577  44.314  27.549  1.00 70.95           C  
ATOM   1467  CG  ARG A 175      43.571  43.239  27.971  1.00 70.24           C  
ATOM   1468  CD  ARG A 175      43.352  42.269  26.789  1.00 71.43           C  
ATOM   1469  NE  ARG A 175      42.017  41.657  26.747  1.00 76.25           N  
ATOM   1470  CZ  ARG A 175      41.707  40.513  26.120  1.00 79.19           C  
ATOM   1471  NH1 ARG A 175      42.628  39.803  25.470  1.00 74.07           N  
ATOM   1472  NH2 ARG A 175      40.446  40.089  26.105  1.00 80.31           N  
ATOM   1473  N   ASN A 176      43.451  45.663  30.217  1.00 75.86           N  
ATOM   1474  CA  ASN A 176      42.493  46.506  30.925  1.00 81.99           C  
ATOM   1475  C   ASN A 176      42.411  46.171  32.409  1.00 81.41           C  
ATOM   1476  O   ASN A 176      42.528  45.012  32.806  1.00 80.87           O  
ATOM   1477  CB  ASN A 176      41.095  46.453  30.251  1.00 83.65           C  
ATOM   1478  CG  ASN A 176      40.959  47.431  29.047  1.00 85.65           C  
ATOM   1479  OD1 ASN A 176      41.555  48.517  29.033  1.00 80.21           O  
ATOM   1480  ND2 ASN A 176      40.164  47.039  28.051  1.00 80.14           N  
ATOM   1481  N   ASP A 177      42.223  47.215  33.212  1.00 87.08           N  
ATOM   1482  CA  ASP A 177      42.127  47.119  34.671  1.00 92.87           C  
ATOM   1483  C   ASP A 177      40.729  46.802  35.241  1.00 97.99           C  
ATOM   1484  O   ASP A 177      40.012  47.699  35.719  1.00 96.90           O  
ATOM   1485  CB  ASP A 177      42.669  48.407  35.320  1.00 88.34           C  
ATOM   1486  CG  ASP A 177      44.160  48.344  35.629  1.00 85.21           C  
ATOM   1487  OD1 ASP A 177      44.796  47.279  35.433  1.00 86.04           O  
ATOM   1488  OD2 ASP A 177      44.692  49.370  36.100  1.00 81.37           O  
ATOM   1489  N   PHE A 178      40.360  45.518  35.188  1.00102.09           N  
ATOM   1490  CA  PHE A 178      39.085  44.996  35.721  1.00100.86           C  
ATOM   1491  C   PHE A 178      39.367  44.422  37.133  1.00100.33           C  
ATOM   1492  O   PHE A 178      40.456  43.884  37.365  1.00105.36           O  
ATOM   1493  CB  PHE A 178      38.463  43.945  34.758  1.00103.27           C  
ATOM   1494  CG  PHE A 178      39.260  42.641  34.612  1.00104.78           C  
ATOM   1495  CD1 PHE A 178      38.600  41.403  34.752  1.00110.24           C  
ATOM   1496  CD2 PHE A 178      40.661  42.638  34.351  1.00110.05           C  
ATOM   1497  CE1 PHE A 178      39.314  40.177  34.642  1.00111.38           C  
ATOM   1498  CE2 PHE A 178      41.392  41.424  34.239  1.00110.27           C  
ATOM   1499  CZ  PHE A 178      40.717  40.192  34.387  1.00109.06           C  
ATOM   1500  N   ASN A 179      38.404  44.553  38.053  1.00102.02           N  
ATOM   1501  CA  ASN A 179      38.515  44.102  39.464  1.00 98.78           C  
ATOM   1502  C   ASN A 179      39.075  42.691  39.720  1.00 92.32           C  
ATOM   1503  O   ASN A 179      38.333  41.699  39.704  1.00 89.03           O  
ATOM   1504  CB  ASN A 179      37.177  44.295  40.162  1.00103.93           C  
ATOM   1505  CG  ASN A 179      36.621  45.674  39.923  1.00104.15           C  
ATOM   1506  OD1 ASN A 179      37.147  46.661  40.437  1.00106.57           O  
ATOM   1507  ND2 ASN A 179      35.600  45.762  39.071  1.00102.24           N  
ATOM   1508  N   PRO A 180      40.387  42.605  40.044  1.00 89.44           N  
ATOM   1509  CA  PRO A 180      41.118  41.360  40.310  1.00 86.70           C  
ATOM   1510  C   PRO A 180      40.743  40.469  41.498  1.00 82.79           C  
ATOM   1511  O   PRO A 180      40.827  39.250  41.397  1.00 79.61           O  
ATOM   1512  CB  PRO A 180      42.564  41.846  40.406  1.00 86.28           C  
ATOM   1513  CG  PRO A 180      42.428  43.177  41.073  1.00 86.48           C  
ATOM   1514  CD  PRO A 180      41.247  43.777  40.350  1.00 87.94           C  
ATOM   1515  N   LYS A 181      40.314  41.068  42.608  1.00 81.83           N  
ATOM   1516  CA  LYS A 181      39.976  40.314  43.814  1.00 87.68           C  
ATOM   1517  C   LYS A 181      38.739  39.453  43.711  1.00 87.45           C  
ATOM   1518  O   LYS A 181      37.754  39.835  43.063  1.00 86.83           O  
ATOM   1519  CB  LYS A 181      39.927  41.237  45.026  1.00 84.16           C  
ATOM   1520  CG  LYS A 181      41.308  41.774  45.309  1.00 89.53           C  
ATOM   1521  CD  LYS A 181      41.338  42.850  46.347  1.00 94.37           C  
ATOM   1522  CE  LYS A 181      42.764  43.359  46.497  1.00 95.35           C  
ATOM   1523  NZ  LYS A 181      43.034  43.900  47.855  1.00 99.97           N  
ATOM   1524  N   ARG A 182      38.858  38.266  44.320  1.00 82.40           N  
ATOM   1525  CA  ARG A 182      37.839  37.204  44.361  1.00 84.32           C  
ATOM   1526  C   ARG A 182      37.787  36.408  43.066  1.00 79.12           C  
ATOM   1527  O   ARG A 182      36.832  35.655  42.824  1.00 83.50           O  
ATOM   1528  CB  ARG A 182      36.421  37.729  44.683  1.00 91.41           C  
ATOM   1529  CG  ARG A 182      36.230  38.235  46.090  1.00100.09           C  
ATOM   1530  CD  ARG A 182      34.848  38.828  46.270  1.00101.46           C  
ATOM   1531  NE  ARG A 182      34.736  39.478  47.569  1.00103.57           N  
ATOM   1532  CZ  ARG A 182      34.541  38.849  48.730  1.00106.81           C  
ATOM   1533  NH1 ARG A 182      34.425  37.520  48.796  1.00100.15           N  
ATOM   1534  NH2 ARG A 182      34.463  39.569  49.841  1.00108.96           N  
ATOM   1535  N   ILE A 183      38.791  36.588  42.219  1.00 75.52           N  
ATOM   1536  CA  ILE A 183      38.819  35.871  40.961  1.00 72.28           C  
ATOM   1537  C   ILE A 183      39.556  34.564  41.152  1.00 71.52           C  
ATOM   1538  O   ILE A 183      40.706  34.543  41.577  1.00 72.23           O  
ATOM   1539  CB  ILE A 183      39.402  36.732  39.811  1.00 73.01           C  
ATOM   1540  CG1 ILE A 183      38.389  37.824  39.461  1.00 79.76           C  
ATOM   1541  CG2 ILE A 183      39.708  35.877  38.571  1.00 73.53           C  
ATOM   1542  CD1 ILE A 183      38.830  38.786  38.383  1.00 76.86           C  
ATOM   1543  N   ARG A 184      38.843  33.470  40.901  1.00 64.74           N  
ATOM   1544  CA  ARG A 184      39.404  32.133  41.037  1.00 58.17           C  
ATOM   1545  C   ARG A 184      40.308  31.881  39.844  1.00 52.09           C  
ATOM   1546  O   ARG A 184      39.909  32.083  38.692  1.00 57.40           O  
ATOM   1547  CB  ARG A 184      38.292  31.068  41.158  1.00 61.98           C  
ATOM   1548  CG  ARG A 184      37.308  31.311  42.316  1.00 70.36           C  
ATOM   1549  CD  ARG A 184      36.756  30.037  42.981  1.00 75.40           C  
ATOM   1550  NE  ARG A 184      36.215  30.334  44.320  1.00 80.31           N  
ATOM   1551  CZ  ARG A 184      35.566  29.474  45.112  1.00 81.21           C  
ATOM   1552  NH1 ARG A 184      35.342  28.223  44.733  1.00 74.14           N  
ATOM   1553  NH2 ARG A 184      35.156  29.865  46.314  1.00 78.21           N  
ATOM   1554  N   VAL A 185      41.572  31.616  40.148  1.00 46.97           N  
ATOM   1555  CA  VAL A 185      42.587  31.341  39.132  1.00 40.60           C  
ATOM   1556  C   VAL A 185      43.219  29.960  39.339  1.00 36.92           C  
ATOM   1557  O   VAL A 185      43.055  29.348  40.384  1.00 35.20           O  
ATOM   1558  CB  VAL A 185      43.713  32.432  39.096  1.00 29.18           C  
ATOM   1559  CG1 VAL A 185      43.309  33.572  38.238  1.00 28.61           C  
ATOM   1560  CG2 VAL A 185      44.036  32.938  40.478  1.00 31.97           C  
ATOM   1561  N   LYS A 186      43.909  29.458  38.320  1.00 37.03           N  
ATOM   1562  CA  LYS A 186      44.569  28.162  38.395  1.00 40.49           C  
ATOM   1563  C   LYS A 186      45.850  28.161  37.579  1.00 45.39           C  
ATOM   1564  O   LYS A 186      45.845  28.655  36.441  1.00 42.42           O  
ATOM   1565  CB  LYS A 186      43.669  27.036  37.834  1.00 40.86           C  
ATOM   1566  CG  LYS A 186      44.332  25.626  37.806  1.00 40.23           C  
ATOM   1567  CD  LYS A 186      44.069  24.890  36.527  1.00 43.61           C  
ATOM   1568  CE  LYS A 186      44.820  23.594  36.463  1.00 42.48           C  
ATOM   1569  NZ  LYS A 186      44.635  23.016  35.135  1.00 57.89           N  
ATOM   1570  N   PRO A 187      46.959  27.633  38.158  1.00 46.01           N  
ATOM   1571  CA  PRO A 187      48.271  27.533  37.483  1.00 49.67           C  
ATOM   1572  C   PRO A 187      48.191  26.372  36.466  1.00 50.56           C  
ATOM   1573  O   PRO A 187      47.498  25.380  36.723  1.00 50.43           O  
ATOM   1574  CB  PRO A 187      49.219  27.194  38.627  1.00 44.61           C  
ATOM   1575  CG  PRO A 187      48.561  27.795  39.815  1.00 45.82           C  
ATOM   1576  CD  PRO A 187      47.131  27.460  39.616  1.00 44.87           C  
ATOM   1577  N   ILE A 188      48.950  26.449  35.370  1.00 51.47           N  
ATOM   1578  CA  ILE A 188      48.873  25.448  34.297  1.00 56.71           C  
ATOM   1579  C   ILE A 188      49.026  23.948  34.607  1.00 58.75           C  
ATOM   1580  O   ILE A 188      48.040  23.191  34.478  1.00 59.33           O  
ATOM   1581  CB  ILE A 188      49.684  25.884  33.023  1.00 51.46           C  
ATOM   1582  CG1 ILE A 188      49.093  27.203  32.485  1.00 50.99           C  
ATOM   1583  CG2 ILE A 188      49.600  24.798  31.913  1.00 47.99           C  
ATOM   1584  CD1 ILE A 188      49.720  27.745  31.209  1.00 53.14           C  
ATOM   1585  N   GLY A 189      50.231  23.514  34.975  1.00 59.62           N  
ATOM   1586  CA  GLY A 189      50.428  22.105  35.287  1.00 59.61           C  
ATOM   1587  C   GLY A 189      50.087  21.737  36.734  1.00 54.74           C  
ATOM   1588  O   GLY A 189      50.526  20.695  37.222  1.00 58.46           O  
ATOM   1589  N   ILE A 190      49.316  22.598  37.417  1.00 55.50           N  
ATOM   1590  CA  ILE A 190      48.919  22.413  38.822  1.00 54.93           C  
ATOM   1591  C   ILE A 190      47.388  22.248  39.071  1.00 53.75           C  
ATOM   1592  O   ILE A 190      46.585  23.074  38.644  1.00 56.72           O  
ATOM   1593  CB  ILE A 190      49.510  23.581  39.713  1.00 50.03           C  
ATOM   1594  CG1 ILE A 190      51.034  23.700  39.492  1.00 46.99           C  
ATOM   1595  CG2 ILE A 190      49.207  23.372  41.201  1.00 47.65           C  
ATOM   1596  CD1 ILE A 190      51.793  24.744  40.340  1.00 41.67           C  
ATOM   1597  N   ASP A 191      47.043  21.192  39.826  1.00 50.87           N  
ATOM   1598  CA  ASP A 191      45.672  20.788  40.229  1.00 47.55           C  
ATOM   1599  C   ASP A 191      45.078  21.726  41.321  1.00 43.85           C  
ATOM   1600  O   ASP A 191      44.335  21.288  42.213  1.00 43.14           O  
ATOM   1601  CB  ASP A 191      45.774  19.351  40.815  1.00 49.88           C  
ATOM   1602  CG  ASP A 191      45.008  18.303  40.008  1.00 52.30           C  
ATOM   1603  OD1 ASP A 191      43.870  18.565  39.563  1.00 52.62           O  
ATOM   1604  OD2 ASP A 191      45.562  17.179  39.889  1.00 46.63           O  
ATOM   1605  N   PHE A 192      45.324  23.017  41.198  1.00 42.60           N  
ATOM   1606  CA  PHE A 192      44.887  23.949  42.230  1.00 42.48           C  
ATOM   1607  C   PHE A 192      44.114  25.189  41.766  1.00 40.02           C  
ATOM   1608  O   PHE A 192      44.470  25.813  40.787  1.00 39.59           O  
ATOM   1609  CB  PHE A 192      46.135  24.311  43.090  1.00 45.43           C  
ATOM   1610  CG  PHE A 192      45.914  25.392  44.108  1.00 49.73           C  
ATOM   1611  CD1 PHE A 192      45.113  25.161  45.231  1.00 56.80           C  
ATOM   1612  CD2 PHE A 192      46.494  26.663  43.918  1.00 55.22           C  
ATOM   1613  CE1 PHE A 192      44.871  26.188  46.172  1.00 61.46           C  
ATOM   1614  CE2 PHE A 192      46.274  27.708  44.839  1.00 58.06           C  
ATOM   1615  CZ  PHE A 192      45.459  27.476  45.972  1.00 64.17           C  
ATOM   1616  N   VAL A 193      43.081  25.559  42.525  1.00 32.48           N  
ATOM   1617  CA  VAL A 193      42.266  26.741  42.240  1.00 31.73           C  
ATOM   1618  C   VAL A 193      42.172  27.549  43.546  1.00 35.49           C  
ATOM   1619  O   VAL A 193      41.853  26.995  44.612  1.00 32.91           O  
ATOM   1620  CB  VAL A 193      40.828  26.369  41.703  1.00 27.49           C  
ATOM   1621  CG1 VAL A 193      39.889  27.589  41.678  1.00 20.66           C  
ATOM   1622  CG2 VAL A 193      40.930  25.784  40.311  1.00 16.18           C  
ATOM   1623  N   GLY A 194      42.494  28.840  43.435  1.00 32.79           N  
ATOM   1624  CA  GLY A 194      42.455  29.759  44.561  1.00 37.04           C  
ATOM   1625  C   GLY A 194      41.961  31.130  44.138  1.00 38.73           C  
ATOM   1626  O   GLY A 194      41.960  31.438  42.944  1.00 36.48           O  
ATOM   1627  N   ARG A 195      41.510  31.934  45.102  1.00 45.33           N  
ATOM   1628  CA  ARG A 195      41.005  33.287  44.822  1.00 50.57           C  
ATOM   1629  C   ARG A 195      42.090  34.310  45.037  1.00 48.03           C  
ATOM   1630  O   ARG A 195      42.801  34.247  46.032  1.00 48.05           O  
ATOM   1631  CB  ARG A 195      39.804  33.663  45.700  1.00 55.30           C  
ATOM   1632  CG  ARG A 195      38.520  32.904  45.458  1.00 69.69           C  
ATOM   1633  CD  ARG A 195      37.333  33.689  45.988  1.00 71.15           C  
ATOM   1634  NE  ARG A 195      36.103  32.899  46.029  1.00 79.56           N  
ATOM   1635  CZ  ARG A 195      35.045  33.183  46.793  1.00 82.76           C  
ATOM   1636  NH1 ARG A 195      35.043  34.254  47.588  1.00 90.77           N  
ATOM   1637  NH2 ARG A 195      34.002  32.363  46.805  1.00 90.14           N  
ATOM   1638  N   VAL A 196      42.154  35.298  44.147  1.00 54.04           N  
ATOM   1639  CA  VAL A 196      43.164  36.361  44.212  1.00 55.92           C  
ATOM   1640  C   VAL A 196      42.994  37.262  45.434  1.00 62.48           C  
ATOM   1641  O   VAL A 196      41.898  37.772  45.700  1.00 69.68           O  
ATOM   1642  CB  VAL A 196      43.169  37.231  42.918  1.00 55.20           C  
ATOM   1643  CG1 VAL A 196      44.247  38.285  42.978  1.00 52.34           C  
ATOM   1644  CG2 VAL A 196      43.405  36.376  41.700  1.00 50.34           C  
ATOM   1645  N   GLN A 197      44.096  37.433  46.166  1.00 65.87           N  
ATOM   1646  CA  GLN A 197      44.126  38.270  47.360  1.00 72.36           C  
ATOM   1647  C   GLN A 197      44.861  39.598  47.123  1.00 72.65           C  
ATOM   1648  O   GLN A 197      44.294  40.672  47.382  1.00 70.57           O  
ATOM   1649  CB  GLN A 197      44.757  37.507  48.539  1.00 79.35           C  
ATOM   1650  CG  GLN A 197      44.665  38.272  49.868  1.00 89.88           C  
ATOM   1651  CD  GLN A 197      45.203  37.529  51.079  1.00 94.91           C  
ATOM   1652  OE1 GLN A 197      45.639  36.361  51.014  1.00 94.64           O  
ATOM   1653  NE2 GLN A 197      45.168  38.218  52.210  1.00 94.91           N  
ATOM   1654  N   ASP A 198      46.116  39.502  46.660  1.00 74.21           N  
ATOM   1655  CA  ASP A 198      46.992  40.659  46.388  1.00 74.01           C  
ATOM   1656  C   ASP A 198      47.759  40.556  45.066  1.00 69.81           C  
ATOM   1657  O   ASP A 198      48.237  39.478  44.699  1.00 67.29           O  
ATOM   1658  CB  ASP A 198      48.029  40.823  47.514  1.00 78.67           C  
ATOM   1659  CG  ASP A 198      47.709  41.973  48.474  1.00 82.61           C  
ATOM   1660  OD1 ASP A 198      46.551  42.454  48.534  1.00 78.03           O  
ATOM   1661  OD2 ASP A 198      48.646  42.387  49.193  1.00 84.60           O  
ATOM   1662  N   VAL A 199      47.864  41.692  44.370  1.00 66.04           N  
ATOM   1663  CA  VAL A 199      48.598  41.805  43.107  1.00 56.71           C  
ATOM   1664  C   VAL A 199      49.604  42.940  43.250  1.00 57.71           C  
ATOM   1665  O   VAL A 199      49.284  44.023  43.777  1.00 58.32           O  
ATOM   1666  CB  VAL A 199      47.665  42.078  41.864  1.00 55.17           C  
ATOM   1667  CG1 VAL A 199      48.486  42.341  40.606  1.00 49.99           C  
ATOM   1668  CG2 VAL A 199      46.787  40.886  41.574  1.00 53.49           C  
ATOM   1669  N   PHE A 200      50.831  42.650  42.821  1.00 57.34           N  
ATOM   1670  CA  PHE A 200      51.916  43.617  42.827  1.00 55.74           C  
ATOM   1671  C   PHE A 200      52.895  43.334  41.684  1.00 55.47           C  
ATOM   1672  O   PHE A 200      52.902  42.234  41.133  1.00 54.31           O  
ATOM   1673  CB  PHE A 200      52.610  43.693  44.206  1.00 62.75           C  
ATOM   1674  CG  PHE A 200      53.405  42.475  44.582  1.00 60.00           C  
ATOM   1675  CD1 PHE A 200      54.808  42.451  44.384  1.00 61.35           C  
ATOM   1676  CD2 PHE A 200      52.777  41.367  45.182  1.00 61.87           C  
ATOM   1677  CE1 PHE A 200      55.585  41.334  44.779  1.00 66.13           C  
ATOM   1678  CE2 PHE A 200      53.539  40.232  45.591  1.00 64.32           C  
ATOM   1679  CZ  PHE A 200      54.948  40.217  45.391  1.00 62.14           C  
ATOM   1680  N   LYS A 201      53.701  44.338  41.339  1.00 53.86           N  
ATOM   1681  CA  LYS A 201      54.690  44.249  40.264  1.00 51.74           C  
ATOM   1682  C   LYS A 201      55.931  43.439  40.642  1.00 51.29           C  
ATOM   1683  O   LYS A 201      56.325  43.392  41.817  1.00 49.43           O  
ATOM   1684  CB  LYS A 201      55.108  45.656  39.816  1.00 53.65           C  
ATOM   1685  CG  LYS A 201      53.989  46.499  39.233  1.00 58.80           C  
ATOM   1686  CD  LYS A 201      54.386  47.966  39.082  1.00 59.26           C  
ATOM   1687  CE  LYS A 201      53.143  48.860  38.940  1.00 61.11           C  
ATOM   1688  NZ  LYS A 201      53.384  50.308  39.256  1.00 61.00           N  
ATOM   1689  N   ALA A 202      56.542  42.815  39.633  1.00 49.76           N  
ATOM   1690  CA  ALA A 202      57.737  41.998  39.811  1.00 48.84           C  
ATOM   1691  C   ALA A 202      59.001  42.840  39.867  1.00 48.76           C  
ATOM   1692  O   ALA A 202      60.053  42.353  40.299  1.00 44.04           O  
ATOM   1693  CB  ALA A 202      57.828  40.971  38.733  1.00 43.36           C  
ATOM   1694  N   LYS A 203      58.883  44.107  39.449  1.00 51.27           N  
ATOM   1695  CA  LYS A 203      59.989  45.073  39.502  1.00 59.19           C  
ATOM   1696  C   LYS A 203      60.339  45.261  40.984  1.00 64.39           C  
ATOM   1697  O   LYS A 203      61.521  45.372  41.341  1.00 67.88           O  
ATOM   1698  CB  LYS A 203      59.576  46.475  39.022  1.00 60.15           C  
ATOM   1699  CG  LYS A 203      58.851  46.609  37.720  1.00 66.38           C  
ATOM   1700  CD  LYS A 203      59.199  47.961  37.061  1.00 71.74           C  
ATOM   1701  CE  LYS A 203      58.338  48.278  35.819  1.00 68.91           C  
ATOM   1702  NZ  LYS A 203      59.151  48.606  34.607  1.00 58.08           N  
ATOM   1703  N   GLU A 204      59.286  45.248  41.823  1.00 65.22           N  
ATOM   1704  CA  GLU A 204      59.348  45.439  43.282  1.00 60.64           C  
ATOM   1705  C   GLU A 204      60.277  44.495  44.021  1.00 62.69           C  
ATOM   1706  O   GLU A 204      60.686  44.761  45.154  1.00 65.54           O  
ATOM   1707  CB  GLU A 204      57.946  45.367  43.893  1.00 70.58           C  
ATOM   1708  CG  GLU A 204      57.553  46.613  44.689  1.00 71.08           C  
ATOM   1709  CD  GLU A 204      56.175  46.507  45.341  1.00 68.25           C  
ATOM   1710  OE1 GLU A 204      56.111  46.140  46.537  1.00 73.90           O  
ATOM   1711  OE2 GLU A 204      55.163  46.797  44.661  1.00 71.16           O  
ATOM   1712  N   LYS A 205      60.586  43.373  43.381  1.00 56.18           N  
ATOM   1713  CA  LYS A 205      61.483  42.388  43.947  1.00 53.07           C  
ATOM   1714  C   LYS A 205      62.718  42.239  43.053  1.00 49.42           C  
ATOM   1715  O   LYS A 205      62.617  42.345  41.825  1.00 53.48           O  
ATOM   1716  CB  LYS A 205      60.744  41.067  44.135  1.00 53.38           C  
ATOM   1717  CG  LYS A 205      59.543  41.141  45.098  1.00 49.08           C  
ATOM   1718  CD  LYS A 205      59.912  41.470  46.557  1.00 51.83           C  
ATOM   1719  CE  LYS A 205      58.664  41.584  47.420  1.00 53.28           C  
ATOM   1720  NZ  LYS A 205      58.985  41.496  48.861  1.00 56.07           N  
ATOM   1721  N   GLY A 206      63.879  42.057  43.683  1.00 48.83           N  
ATOM   1722  CA  GLY A 206      65.140  41.906  42.967  1.00 48.77           C  
ATOM   1723  C   GLY A 206      65.493  40.475  42.592  1.00 48.66           C  
ATOM   1724  O   GLY A 206      64.771  39.552  42.966  1.00 46.40           O  
ATOM   1725  N   GLU A 207      66.644  40.299  41.931  1.00 47.06           N  
ATOM   1726  CA  GLU A 207      67.141  38.998  41.443  1.00 49.77           C  
ATOM   1727  C   GLU A 207      67.038  37.714  42.284  1.00 47.49           C  
ATOM   1728  O   GLU A 207      66.482  36.717  41.803  1.00 48.23           O  
ATOM   1729  CB  GLU A 207      68.562  39.135  40.881  1.00 49.79           C  
ATOM   1730  CG  GLU A 207      68.618  39.926  39.592  1.00 56.78           C  
ATOM   1731  CD  GLU A 207      69.675  39.414  38.640  1.00 58.98           C  
ATOM   1732  OE1 GLU A 207      70.813  39.934  38.669  1.00 69.77           O  
ATOM   1733  OE2 GLU A 207      69.369  38.490  37.861  1.00 64.68           O  
ATOM   1734  N   GLU A 208      67.515  37.739  43.534  1.00 50.83           N  
ATOM   1735  CA  GLU A 208      67.471  36.545  44.411  1.00 48.61           C  
ATOM   1736  C   GLU A 208      66.074  36.045  44.823  1.00 48.74           C  
ATOM   1737  O   GLU A 208      65.925  34.873  45.118  1.00 45.33           O  
ATOM   1738  CB  GLU A 208      68.348  36.714  45.658  1.00 51.72           C  
ATOM   1739  CG  GLU A 208      69.799  36.208  45.580  1.00 68.33           C  
ATOM   1740  CD  GLU A 208      70.589  36.467  46.899  1.00 81.26           C  
ATOM   1741  OE1 GLU A 208      70.361  35.745  47.900  1.00 83.24           O  
ATOM   1742  OE2 GLU A 208      71.433  37.398  46.949  1.00 83.30           O  
ATOM   1743  N   PHE A 209      65.051  36.902  44.779  1.00 45.20           N  
ATOM   1744  CA  PHE A 209      63.676  36.524  45.130  1.00 35.74           C  
ATOM   1745  C   PHE A 209      63.183  35.430  44.208  1.00 39.45           C  
ATOM   1746  O   PHE A 209      62.647  34.419  44.662  1.00 42.56           O  
ATOM   1747  CB  PHE A 209      62.753  37.737  44.983  1.00 36.48           C  
ATOM   1748  CG  PHE A 209      61.361  37.533  45.522  1.00 40.23           C  
ATOM   1749  CD1 PHE A 209      61.087  37.783  46.879  1.00 39.49           C  
ATOM   1750  CD2 PHE A 209      60.296  37.143  44.671  1.00 37.25           C  
ATOM   1751  CE1 PHE A 209      59.771  37.659  47.400  1.00 44.31           C  
ATOM   1752  CE2 PHE A 209      58.973  37.011  45.177  1.00 36.96           C  
ATOM   1753  CZ  PHE A 209      58.715  37.274  46.548  1.00 34.72           C  
ATOM   1754  N   PHE A 210      63.378  35.676  42.911  1.00 37.71           N  
ATOM   1755  CA  PHE A 210      62.969  34.806  41.810  1.00 35.04           C  
ATOM   1756  C   PHE A 210      63.686  33.510  41.794  1.00 29.77           C  
ATOM   1757  O   PHE A 210      63.118  32.504  41.379  1.00 27.67           O  
ATOM   1758  CB  PHE A 210      63.213  35.478  40.474  1.00 31.69           C  
ATOM   1759  CG  PHE A 210      62.588  36.805  40.355  1.00 29.41           C  
ATOM   1760  CD1 PHE A 210      63.386  37.947  40.299  1.00 20.51           C  
ATOM   1761  CD2 PHE A 210      61.198  36.942  40.398  1.00 22.62           C  
ATOM   1762  CE1 PHE A 210      62.812  39.226  40.300  1.00 19.14           C  
ATOM   1763  CE2 PHE A 210      60.606  38.219  40.398  1.00 24.16           C  
ATOM   1764  CZ  PHE A 210      61.421  39.366  40.354  1.00 20.24           C  
ATOM   1765  N   ARG A 211      64.952  33.572  42.199  1.00 34.36           N  
ATOM   1766  CA  ARG A 211      65.829  32.412  42.288  1.00 35.99           C  
ATOM   1767  C   ARG A 211      65.405  31.588  43.508  1.00 36.36           C  
ATOM   1768  O   ARG A 211      65.377  30.352  43.441  1.00 34.62           O  
ATOM   1769  CB  ARG A 211      67.293  32.865  42.410  1.00 37.97           C  
ATOM   1770  CG  ARG A 211      68.325  31.778  42.184  1.00 43.24           C  
ATOM   1771  CD  ARG A 211      69.686  32.393  42.020  1.00 49.26           C  
ATOM   1772  NE  ARG A 211      70.344  31.839  40.840  1.00 67.11           N  
ATOM   1773  CZ  ARG A 211      71.605  31.411  40.795  1.00 77.13           C  
ATOM   1774  NH1 ARG A 211      72.391  31.471  41.868  1.00 91.10           N  
ATOM   1775  NH2 ARG A 211      72.062  30.840  39.690  1.00 82.38           N  
ATOM   1776  N   LEU A 212      64.986  32.291  44.570  1.00 30.86           N  
ATOM   1777  CA  LEU A 212      64.551  31.655  45.803  1.00 35.51           C  
ATOM   1778  C   LEU A 212      63.217  30.977  45.657  1.00 34.79           C  
ATOM   1779  O   LEU A 212      63.073  29.806  46.021  1.00 36.64           O  
ATOM   1780  CB  LEU A 212      64.478  32.644  46.958  1.00 47.74           C  
ATOM   1781  CG  LEU A 212      65.777  32.978  47.712  1.00 52.38           C  
ATOM   1782  CD1 LEU A 212      65.471  34.070  48.771  1.00 55.30           C  
ATOM   1783  CD2 LEU A 212      66.433  31.732  48.347  1.00 48.20           C  
ATOM   1784  N   CYS A 213      62.272  31.699  45.059  1.00 31.19           N  
ATOM   1785  CA  CYS A 213      60.919  31.211  44.835  1.00 37.32           C  
ATOM   1786  C   CYS A 213      60.883  30.086  43.792  1.00 37.66           C  
ATOM   1787  O   CYS A 213      59.930  29.298  43.737  1.00 30.88           O  
ATOM   1788  CB  CYS A 213      60.020  32.376  44.444  1.00 40.14           C  
ATOM   1789  SG  CYS A 213      58.648  32.678  45.596  1.00 47.36           S  
HETATM 1790  N   MSE A 214      61.984  29.981  43.043  1.00 38.40           N  
HETATM 1791  CA  MSE A 214      62.204  28.969  42.011  1.00 47.50           C  
HETATM 1792  C   MSE A 214      62.713  27.736  42.712  1.00 52.03           C  
HETATM 1793  O   MSE A 214      62.266  26.621  42.432  1.00 50.95           O  
HETATM 1794  CB  MSE A 214      63.272  29.442  41.051  1.00 51.54           C  
HETATM 1795  CG  MSE A 214      63.392  28.663  39.775  1.00 64.73           C  
HETATM 1796 SE   MSE A 214      65.259  28.520  39.319  1.00 75.80          SE  
HETATM 1797  CE  MSE A 214      65.585  30.294  38.836  1.00 71.42           C  
ATOM   1798  N   GLU A 215      63.664  27.943  43.621  1.00 53.62           N  
ATOM   1799  CA  GLU A 215      64.220  26.848  44.405  1.00 63.02           C  
ATOM   1800  C   GLU A 215      63.151  26.278  45.353  1.00 65.59           C  
ATOM   1801  O   GLU A 215      63.218  25.105  45.760  1.00 67.28           O  
ATOM   1802  CB  GLU A 215      65.445  27.318  45.185  1.00 71.49           C  
ATOM   1803  CG  GLU A 215      66.720  27.350  44.339  1.00 76.53           C  
ATOM   1804  CD  GLU A 215      67.914  27.958  45.072  1.00 86.35           C  
ATOM   1805  OE1 GLU A 215      67.821  28.259  46.289  1.00 87.79           O  
ATOM   1806  OE2 GLU A 215      68.964  28.140  44.417  1.00 91.79           O  
ATOM   1807  N   ARG A 216      62.143  27.103  45.646  1.00 65.91           N  
ATOM   1808  CA  ARG A 216      61.036  26.720  46.523  1.00 64.90           C  
ATOM   1809  C   ARG A 216      59.794  26.284  45.775  1.00 62.32           C  
ATOM   1810  O   ARG A 216      58.743  26.065  46.393  1.00 56.97           O  
ATOM   1811  CB  ARG A 216      60.657  27.865  47.461  1.00 68.96           C  
ATOM   1812  CG  ARG A 216      61.672  28.164  48.533  1.00 67.22           C  
ATOM   1813  CD  ARG A 216      61.236  29.389  49.285  1.00 72.11           C  
ATOM   1814  NE  ARG A 216      62.348  30.044  49.968  1.00 64.18           N  
ATOM   1815  CZ  ARG A 216      62.256  31.232  50.550  1.00 61.18           C  
ATOM   1816  NH1 ARG A 216      61.094  31.881  50.521  1.00 69.17           N  
ATOM   1817  NH2 ARG A 216      63.316  31.760  51.161  1.00 60.67           N  
ATOM   1818  N   SER A 217      59.904  26.160  44.454  1.00 62.68           N  
ATOM   1819  CA  SER A 217      58.747  25.750  43.667  1.00 60.36           C  
ATOM   1820  C   SER A 217      58.525  24.236  43.599  1.00 57.63           C  
ATOM   1821  O   SER A 217      59.424  23.448  43.260  1.00 59.26           O  
ATOM   1822  CB  SER A 217      58.723  26.430  42.294  1.00 61.61           C  
ATOM   1823  OG  SER A 217      59.938  26.271  41.606  1.00 61.94           O  
ATOM   1824  N   THR A 218      57.325  23.856  44.029  1.00 54.13           N  
ATOM   1825  CA  THR A 218      56.862  22.472  44.096  1.00 55.49           C  
ATOM   1826  C   THR A 218      56.708  21.697  42.780  1.00 56.49           C  
ATOM   1827  O   THR A 218      56.968  20.484  42.750  1.00 59.21           O  
ATOM   1828  CB  THR A 218      55.524  22.426  44.798  1.00 48.64           C  
ATOM   1829  OG1 THR A 218      54.820  23.639  44.522  1.00 46.95           O  
ATOM   1830  CG2 THR A 218      55.700  22.269  46.275  1.00 50.79           C  
ATOM   1831  N   HIS A 219      56.227  22.383  41.732  1.00 57.97           N  
ATOM   1832  CA  HIS A 219      56.005  21.789  40.406  1.00 52.53           C  
ATOM   1833  C   HIS A 219      56.947  22.363  39.361  1.00 51.31           C  
ATOM   1834  O   HIS A 219      57.584  23.383  39.596  1.00 50.18           O  
ATOM   1835  CB  HIS A 219      54.571  22.030  39.945  1.00 52.02           C  
ATOM   1836  CG  HIS A 219      53.531  21.240  40.686  1.00 48.76           C  
ATOM   1837  ND1 HIS A 219      52.777  20.250  40.076  1.00 48.70           N  
ATOM   1838  CD2 HIS A 219      53.052  21.345  41.945  1.00 51.86           C  
ATOM   1839  CE1 HIS A 219      51.881  19.795  40.928  1.00 46.07           C  
ATOM   1840  NE2 HIS A 219      52.027  20.439  42.073  1.00 51.12           N  
ATOM   1841  N   LYS A 220      56.970  21.726  38.190  1.00 52.55           N  
ATOM   1842  CA  LYS A 220      57.824  22.086  37.045  1.00 52.40           C  
ATOM   1843  C   LYS A 220      57.450  23.373  36.291  1.00 50.54           C  
ATOM   1844  O   LYS A 220      58.337  24.179  35.984  1.00 53.61           O  
ATOM   1845  CB  LYS A 220      57.876  20.909  36.068  1.00 57.72           C  
ATOM   1846  CG  LYS A 220      58.893  21.014  34.944  1.00 56.45           C  
ATOM   1847  CD  LYS A 220      58.575  19.965  33.896  1.00 65.79           C  
ATOM   1848  CE  LYS A 220      59.640  19.886  32.819  1.00 61.45           C  
ATOM   1849  NZ  LYS A 220      59.349  18.772  31.874  1.00 65.95           N  
ATOM   1850  N   SER A 221      56.160  23.562  35.967  1.00 44.57           N  
ATOM   1851  CA  SER A 221      55.710  24.772  35.257  1.00 43.72           C  
ATOM   1852  C   SER A 221      55.996  26.061  36.049  1.00 42.34           C  
ATOM   1853  O   SER A 221      56.315  27.087  35.456  1.00 38.78           O  
ATOM   1854  CB  SER A 221      54.238  24.673  34.762  1.00 44.04           C  
ATOM   1855  OG  SER A 221      53.314  24.186  35.719  1.00 35.63           O  
ATOM   1856  N   SER A 222      56.021  25.943  37.380  1.00 36.90           N  
ATOM   1857  CA  SER A 222      56.318  27.046  38.290  1.00 40.02           C  
ATOM   1858  C   SER A 222      57.834  27.306  38.403  1.00 44.03           C  
ATOM   1859  O   SER A 222      58.236  28.453  38.620  1.00 40.53           O  
ATOM   1860  CB  SER A 222      55.685  26.815  39.669  1.00 42.36           C  
ATOM   1861  OG  SER A 222      55.979  25.528  40.207  1.00 40.80           O  
ATOM   1862  N   LYS A 223      58.664  26.257  38.235  1.00 42.18           N  
ATOM   1863  CA  LYS A 223      60.142  26.373  38.243  1.00 42.34           C  
ATOM   1864  C   LYS A 223      60.453  27.218  37.028  1.00 41.37           C  
ATOM   1865  O   LYS A 223      61.023  28.305  37.155  1.00 39.75           O  
ATOM   1866  CB  LYS A 223      60.861  25.008  38.068  1.00 44.11           C  
ATOM   1867  CG  LYS A 223      60.976  24.142  39.329  1.00 58.93           C  
ATOM   1868  CD  LYS A 223      61.938  22.926  39.206  1.00 58.99           C  
ATOM   1869  CE  LYS A 223      61.923  22.073  40.524  1.00 60.89           C  
ATOM   1870  NZ  LYS A 223      62.639  20.744  40.513  1.00 61.79           N  
ATOM   1871  N   LYS A 224      59.867  26.789  35.905  1.00 41.05           N  
ATOM   1872  CA  LYS A 224      60.000  27.426  34.595  1.00 45.17           C  
ATOM   1873  C   LYS A 224      59.391  28.822  34.466  1.00 47.39           C  
ATOM   1874  O   LYS A 224      59.737  29.566  33.548  1.00 44.32           O  
ATOM   1875  CB  LYS A 224      59.450  26.516  33.484  1.00 53.22           C  
ATOM   1876  CG  LYS A 224      60.449  25.468  32.946  1.00 60.67           C  
ATOM   1877  CD  LYS A 224      59.917  24.827  31.660  1.00 65.21           C  
ATOM   1878  CE  LYS A 224      60.450  23.397  31.465  1.00 71.25           C  
ATOM   1879  NZ  LYS A 224      59.651  22.577  30.473  1.00 71.48           N  
ATOM   1880  N   ALA A 225      58.481  29.167  35.377  1.00 44.15           N  
ATOM   1881  CA  ALA A 225      57.841  30.481  35.382  1.00 39.47           C  
ATOM   1882  C   ALA A 225      58.704  31.469  36.185  1.00 40.47           C  
ATOM   1883  O   ALA A 225      58.793  32.660  35.851  1.00 40.53           O  
ATOM   1884  CB  ALA A 225      56.449  30.391  35.972  1.00 39.66           C  
ATOM   1885  N   TRP A 226      59.349  30.964  37.239  1.00 38.50           N  
ATOM   1886  CA  TRP A 226      60.217  31.795  38.056  1.00 36.39           C  
ATOM   1887  C   TRP A 226      61.558  31.942  37.349  1.00 40.21           C  
ATOM   1888  O   TRP A 226      62.170  33.019  37.415  1.00 44.32           O  
ATOM   1889  CB  TRP A 226      60.389  31.231  39.471  1.00 34.50           C  
ATOM   1890  CG  TRP A 226      59.154  31.315  40.386  1.00 26.89           C  
ATOM   1891  CD1 TRP A 226      58.363  30.275  40.794  1.00 26.75           C  
ATOM   1892  CD2 TRP A 226      58.591  32.496  40.987  1.00 20.09           C  
ATOM   1893  NE1 TRP A 226      57.340  30.731  41.592  1.00 20.46           N  
ATOM   1894  CE2 TRP A 226      57.451  32.089  41.725  1.00 17.68           C  
ATOM   1895  CE3 TRP A 226      58.926  33.869  40.958  1.00 22.07           C  
ATOM   1896  CZ2 TRP A 226      56.655  32.996  42.444  1.00 19.00           C  
ATOM   1897  CZ3 TRP A 226      58.134  34.771  41.671  1.00 16.39           C  
ATOM   1898  CH2 TRP A 226      57.001  34.330  42.399  1.00 18.82           C  
ATOM   1899  N   GLU A 227      61.944  30.906  36.586  1.00 40.11           N  
ATOM   1900  CA  GLU A 227      63.194  30.895  35.798  1.00 41.24           C  
ATOM   1901  C   GLU A 227      63.158  32.048  34.804  1.00 42.39           C  
ATOM   1902  O   GLU A 227      64.081  32.841  34.748  1.00 42.15           O  
ATOM   1903  CB  GLU A 227      63.385  29.561  35.037  1.00 44.99           C  
ATOM   1904  CG  GLU A 227      64.838  29.254  34.576  1.00 50.99           C  
ATOM   1905  CD  GLU A 227      64.995  27.917  33.819  1.00 61.28           C  
ATOM   1906  OE1 GLU A 227      64.124  27.033  33.955  1.00 68.67           O  
ATOM   1907  OE2 GLU A 227      66.003  27.737  33.082  1.00 69.42           O  
ATOM   1908  N   GLU A 228      62.018  32.225  34.148  1.00 37.50           N  
ATOM   1909  CA  GLU A 228      61.842  33.280  33.174  1.00 37.48           C  
ATOM   1910  C   GLU A 228      61.880  34.695  33.734  1.00 36.75           C  
ATOM   1911  O   GLU A 228      62.557  35.543  33.187  1.00 37.39           O  
ATOM   1912  CB  GLU A 228      60.556  33.070  32.365  1.00 40.31           C  
ATOM   1913  CG  GLU A 228      60.507  31.779  31.509  1.00 46.86           C  
ATOM   1914  CD  GLU A 228      61.727  31.582  30.598  1.00 52.13           C  
ATOM   1915  OE1 GLU A 228      61.927  32.425  29.682  1.00 53.70           O  
ATOM   1916  OE2 GLU A 228      62.474  30.586  30.810  1.00 47.44           O  
ATOM   1917  N   LEU A 229      61.256  34.936  34.879  1.00 39.63           N  
ATOM   1918  CA  LEU A 229      61.234  36.298  35.428  1.00 36.39           C  
ATOM   1919  C   LEU A 229      62.611  36.745  35.882  1.00 32.54           C  
ATOM   1920  O   LEU A 229      62.957  37.919  35.787  1.00 34.27           O  
ATOM   1921  CB  LEU A 229      60.235  36.415  36.579  1.00 44.43           C  
ATOM   1922  CG  LEU A 229      58.773  35.951  36.477  1.00 38.54           C  
ATOM   1923  CD1 LEU A 229      58.189  36.073  37.852  1.00 43.86           C  
ATOM   1924  CD2 LEU A 229      57.946  36.745  35.494  1.00 33.64           C  
ATOM   1925  N   LEU A 230      63.400  35.770  36.312  1.00 32.89           N  
ATOM   1926  CA  LEU A 230      64.765  35.967  36.764  1.00 27.95           C  
ATOM   1927  C   LEU A 230      65.683  36.245  35.563  1.00 32.23           C  
ATOM   1928  O   LEU A 230      66.427  37.232  35.544  1.00 32.74           O  
ATOM   1929  CB  LEU A 230      65.242  34.688  37.465  1.00 27.05           C  
ATOM   1930  CG  LEU A 230      66.703  34.659  37.938  1.00 32.06           C  
ATOM   1931  CD1 LEU A 230      66.935  35.637  39.038  1.00 30.88           C  
ATOM   1932  CD2 LEU A 230      67.092  33.288  38.380  1.00 27.53           C  
ATOM   1933  N   LYS A 231      65.583  35.371  34.561  1.00 30.55           N  
ATOM   1934  CA  LYS A 231      66.409  35.431  33.371  1.00 24.57           C  
ATOM   1935  C   LYS A 231      65.951  36.327  32.232  1.00 30.22           C  
ATOM   1936  O   LYS A 231      66.769  36.692  31.400  1.00 29.79           O  
ATOM   1937  CB  LYS A 231      66.727  34.018  32.880  1.00 23.06           C  
ATOM   1938  CG  LYS A 231      67.495  33.150  33.888  1.00 27.01           C  
ATOM   1939  CD  LYS A 231      68.053  31.843  33.302  1.00 38.65           C  
ATOM   1940  CE  LYS A 231      68.625  30.921  34.410  1.00 49.37           C  
ATOM   1941  NZ  LYS A 231      69.289  29.657  33.928  1.00 54.91           N  
ATOM   1942  N   ASN A 232      64.680  36.732  32.220  1.00 34.73           N  
ATOM   1943  CA  ASN A 232      64.128  37.612  31.165  1.00 30.68           C  
ATOM   1944  C   ASN A 232      63.643  38.923  31.794  1.00 33.96           C  
ATOM   1945  O   ASN A 232      62.597  38.953  32.468  1.00 30.40           O  
ATOM   1946  CB  ASN A 232      62.978  36.895  30.453  1.00 18.18           C  
ATOM   1947  CG  ASN A 232      62.458  37.643  29.269  1.00 27.59           C  
ATOM   1948  OD1 ASN A 232      62.851  38.779  28.984  1.00 24.79           O  
ATOM   1949  ND2 ASN A 232      61.556  37.001  28.553  1.00 32.00           N  
ATOM   1950  N   ARG A 233      64.379  40.006  31.528  1.00 36.59           N  
ATOM   1951  CA  ARG A 233      64.035  41.311  32.098  1.00 40.41           C  
ATOM   1952  C   ARG A 233      62.943  42.113  31.430  1.00 40.43           C  
ATOM   1953  O   ARG A 233      62.407  43.047  32.033  1.00 43.04           O  
ATOM   1954  CB  ARG A 233      65.275  42.160  32.346  1.00 46.99           C  
ATOM   1955  CG  ARG A 233      65.984  41.722  33.598  1.00 49.82           C  
ATOM   1956  CD  ARG A 233      67.258  42.460  33.834  1.00 54.55           C  
ATOM   1957  NE  ARG A 233      67.054  43.793  34.395  1.00 54.48           N  
ATOM   1958  CZ  ARG A 233      67.778  44.297  35.391  1.00 62.61           C  
ATOM   1959  NH1 ARG A 233      68.754  43.587  35.960  1.00 69.13           N  
ATOM   1960  NH2 ARG A 233      67.575  45.542  35.778  1.00 66.80           N  
ATOM   1961  N   GLU A 234      62.593  41.725  30.208  1.00 36.73           N  
ATOM   1962  CA  GLU A 234      61.508  42.361  29.474  1.00 37.48           C  
ATOM   1963  C   GLU A 234      60.247  42.007  30.275  1.00 35.74           C  
ATOM   1964  O   GLU A 234      59.497  42.881  30.709  1.00 28.98           O  
ATOM   1965  CB  GLU A 234      61.405  41.758  28.059  1.00 50.69           C  
ATOM   1966  CG  GLU A 234      61.672  42.726  26.885  1.00 54.59           C  
ATOM   1967  CD  GLU A 234      61.326  42.134  25.511  1.00 59.74           C  
ATOM   1968  OE1 GLU A 234      60.447  42.694  24.817  1.00 57.16           O  
ATOM   1969  OE2 GLU A 234      61.939  41.113  25.120  1.00 61.94           O  
ATOM   1970  N   LEU A 235      60.152  40.718  30.597  1.00 33.84           N  
ATOM   1971  CA  LEU A 235      59.058  40.128  31.357  1.00 30.46           C  
ATOM   1972  C   LEU A 235      58.991  40.672  32.768  1.00 32.41           C  
ATOM   1973  O   LEU A 235      57.991  41.260  33.150  1.00 28.88           O  
ATOM   1974  CB  LEU A 235      59.247  38.616  31.450  1.00 29.02           C  
ATOM   1975  CG  LEU A 235      58.069  37.685  31.205  1.00 26.19           C  
ATOM   1976  CD1 LEU A 235      58.454  36.332  31.713  1.00 24.59           C  
ATOM   1977  CD2 LEU A 235      56.800  38.153  31.885  1.00 30.02           C  
ATOM   1978  N   ARG A 236      60.076  40.488  33.519  1.00 32.28           N  
ATOM   1979  CA  ARG A 236      60.167  40.920  34.908  1.00 31.60           C  
ATOM   1980  C   ARG A 236      59.683  42.320  35.174  1.00 35.50           C  
ATOM   1981  O   ARG A 236      59.097  42.580  36.226  1.00 35.94           O  
ATOM   1982  CB  ARG A 236      61.579  40.798  35.426  1.00 31.19           C  
ATOM   1983  CG  ARG A 236      61.639  40.817  36.935  1.00 28.92           C  
ATOM   1984  CD  ARG A 236      62.940  41.365  37.407  1.00 32.47           C  
ATOM   1985  NE  ARG A 236      64.035  40.485  37.023  1.00 40.09           N  
ATOM   1986  CZ  ARG A 236      65.160  40.358  37.714  1.00 41.68           C  
ATOM   1987  NH1 ARG A 236      65.329  41.059  38.839  1.00 47.36           N  
ATOM   1988  NH2 ARG A 236      66.112  39.540  37.277  1.00 49.75           N  
ATOM   1989  N   GLU A 237      59.940  43.227  34.242  1.00 36.30           N  
ATOM   1990  CA  GLU A 237      59.481  44.591  34.441  1.00 45.56           C  
ATOM   1991  C   GLU A 237      57.963  44.744  34.365  1.00 46.65           C  
ATOM   1992  O   GLU A 237      57.336  45.122  35.369  1.00 48.87           O  
ATOM   1993  CB  GLU A 237      60.245  45.574  33.573  1.00 50.56           C  
ATOM   1994  CG  GLU A 237      61.511  45.996  34.301  1.00 57.36           C  
ATOM   1995  CD  GLU A 237      62.394  46.875  33.483  1.00 62.81           C  
ATOM   1996  OE1 GLU A 237      61.872  47.852  32.908  1.00 74.93           O  
ATOM   1997  OE2 GLU A 237      63.609  46.586  33.413  1.00 61.34           O  
ATOM   1998  N   LYS A 238      57.377  44.252  33.265  1.00 48.30           N  
ATOM   1999  CA  LYS A 238      55.922  44.289  33.027  1.00 44.73           C  
ATOM   2000  C   LYS A 238      55.126  43.204  33.784  1.00 34.50           C  
ATOM   2001  O   LYS A 238      53.892  43.219  33.774  1.00 30.22           O  
ATOM   2002  CB  LYS A 238      55.629  44.182  31.524  1.00 44.09           C  
ATOM   2003  CG  LYS A 238      56.119  42.889  30.870  1.00 52.07           C  
ATOM   2004  CD  LYS A 238      55.144  42.415  29.809  1.00 58.06           C  
ATOM   2005  CE  LYS A 238      55.139  40.895  29.699  1.00 59.48           C  
ATOM   2006  NZ  LYS A 238      54.015  40.378  28.852  1.00 58.41           N  
ATOM   2007  N   ALA A 239      55.835  42.287  34.442  1.00 31.71           N  
ATOM   2008  CA  ALA A 239      55.200  41.188  35.155  1.00 29.26           C  
ATOM   2009  C   ALA A 239      54.664  41.467  36.524  1.00 29.30           C  
ATOM   2010  O   ALA A 239      55.145  42.349  37.242  1.00 36.21           O  
ATOM   2011  CB  ALA A 239      56.104  40.002  35.219  1.00 29.98           C  
ATOM   2012  N   PHE A 240      53.651  40.683  36.862  1.00 29.07           N  
ATOM   2013  CA  PHE A 240      52.995  40.761  38.144  1.00 29.54           C  
ATOM   2014  C   PHE A 240      53.096  39.438  38.875  1.00 29.55           C  
ATOM   2015  O   PHE A 240      53.250  38.357  38.280  1.00 26.89           O  
ATOM   2016  CB  PHE A 240      51.517  41.088  37.993  1.00 27.61           C  
ATOM   2017  CG  PHE A 240      51.236  42.401  37.351  1.00 29.22           C  
ATOM   2018  CD1 PHE A 240      50.678  42.454  36.058  1.00 27.53           C  
ATOM   2019  CD2 PHE A 240      51.425  43.595  38.062  1.00 27.76           C  
ATOM   2020  CE1 PHE A 240      50.290  43.690  35.469  1.00 32.24           C  
ATOM   2021  CE2 PHE A 240      51.047  44.845  37.502  1.00 33.47           C  
ATOM   2022  CZ  PHE A 240      50.473  44.895  36.197  1.00 36.29           C  
ATOM   2023  N   LEU A 241      53.089  39.548  40.192  1.00 27.24           N  
ATOM   2024  CA  LEU A 241      53.123  38.390  41.050  1.00 28.63           C  
ATOM   2025  C   LEU A 241      51.841  38.519  41.805  1.00 30.14           C  
ATOM   2026  O   LEU A 241      51.421  39.621  42.168  1.00 25.90           O  
ATOM   2027  CB  LEU A 241      54.324  38.391  41.993  1.00 21.53           C  
ATOM   2028  CG  LEU A 241      55.706  38.504  41.351  1.00 26.19           C  
ATOM   2029  CD1 LEU A 241      56.781  38.438  42.376  1.00 25.07           C  
ATOM   2030  CD2 LEU A 241      55.900  37.433  40.334  1.00 27.89           C  
ATOM   2031  N   VAL A 242      51.170  37.379  41.901  1.00 31.68           N  
ATOM   2032  CA  VAL A 242      49.868  37.249  42.536  1.00 36.26           C  
ATOM   2033  C   VAL A 242      49.932  36.362  43.772  1.00 35.89           C  
ATOM   2034  O   VAL A 242      50.442  35.236  43.721  1.00 38.25           O  
ATOM   2035  CB  VAL A 242      48.853  36.635  41.528  1.00 34.45           C  
ATOM   2036  CG1 VAL A 242      47.446  36.612  42.110  1.00 25.99           C  
ATOM   2037  CG2 VAL A 242      48.891  37.402  40.171  1.00 30.50           C  
ATOM   2038  N   VAL A 243      49.394  36.884  44.874  1.00 39.47           N  
ATOM   2039  CA  VAL A 243      49.343  36.153  46.143  1.00 41.80           C  
ATOM   2040  C   VAL A 243      47.923  35.594  46.302  1.00 42.07           C  
ATOM   2041  O   VAL A 243      46.932  36.328  46.199  1.00 40.37           O  
ATOM   2042  CB  VAL A 243      49.722  37.047  47.370  1.00 33.32           C  
ATOM   2043  CG1 VAL A 243      49.893  36.178  48.630  1.00 27.38           C  
ATOM   2044  CG2 VAL A 243      51.003  37.813  47.097  1.00 29.81           C  
ATOM   2045  N   LEU A 244      47.839  34.283  46.495  1.00 49.06           N  
ATOM   2046  CA  LEU A 244      46.558  33.615  46.653  1.00 56.47           C  
ATOM   2047  C   LEU A 244      46.157  33.379  48.115  1.00 61.01           C  
ATOM   2048  O   LEU A 244      46.981  33.539  49.020  1.00 62.68           O  
ATOM   2049  CB  LEU A 244      46.523  32.329  45.818  1.00 59.70           C  
ATOM   2050  CG  LEU A 244      46.824  32.456  44.309  1.00 57.85           C  
ATOM   2051  CD1 LEU A 244      46.584  31.128  43.616  1.00 57.85           C  
ATOM   2052  CD2 LEU A 244      45.966  33.509  43.645  1.00 54.03           C  
ATOM   2053  N   GLU A 245      44.885  33.018  48.317  1.00 67.67           N  
ATOM   2054  CA  GLU A 245      44.248  32.809  49.626  1.00 74.55           C  
ATOM   2055  C   GLU A 245      45.020  32.208  50.786  1.00 76.56           C  
ATOM   2056  O   GLU A 245      45.261  32.881  51.805  1.00 75.36           O  
ATOM   2057  CB  GLU A 245      42.924  32.060  49.477  1.00 77.38           C  
ATOM   2058  CG  GLU A 245      42.807  31.100  48.300  1.00 82.80           C  
ATOM   2059  CD  GLU A 245      41.366  30.654  48.050  1.00 92.02           C  
ATOM   2060  OE1 GLU A 245      40.394  31.403  48.359  1.00 86.76           O  
ATOM   2061  OE2 GLU A 245      41.213  29.540  47.508  1.00 93.53           O  
ATOM   2062  N   LYS A 246      45.447  30.963  50.598  1.00 79.19           N  
ATOM   2063  CA  LYS A 246      46.188  30.219  51.608  1.00 78.41           C  
ATOM   2064  C   LYS A 246      47.590  30.831  51.843  1.00 79.95           C  
ATOM   2065  O   LYS A 246      48.108  30.808  52.971  1.00 80.87           O  
ATOM   2066  CB  LYS A 246      46.224  28.733  51.203  1.00 81.94           C  
ATOM   2067  CG  LYS A 246      44.817  28.110  50.863  1.00 84.91           C  
ATOM   2068  CD  LYS A 246      44.888  26.672  50.255  1.00 79.49           C  
ATOM   2069  CE  LYS A 246      43.497  26.114  49.924  1.00 80.13           C  
ATOM   2070  NZ  LYS A 246      43.562  24.799  49.216  1.00 67.89           N  
ATOM   2071  N   GLY A 247      48.114  31.490  50.803  1.00 76.78           N  
ATOM   2072  CA  GLY A 247      49.417  32.138  50.871  1.00 74.25           C  
ATOM   2073  C   GLY A 247      50.254  32.037  49.606  1.00 72.94           C  
ATOM   2074  O   GLY A 247      50.974  32.998  49.274  1.00 68.27           O  
ATOM   2075  N   TYR A 248      50.159  30.877  48.932  1.00 70.26           N  
ATOM   2076  CA  TYR A 248      50.865  30.490  47.687  1.00 65.69           C  
ATOM   2077  C   TYR A 248      51.071  31.633  46.675  1.00 63.17           C  
ATOM   2078  O   TYR A 248      50.096  32.232  46.209  1.00 62.32           O  
ATOM   2079  CB  TYR A 248      50.086  29.364  46.964  1.00 68.68           C  
ATOM   2080  CG  TYR A 248      49.810  28.065  47.730  1.00 71.34           C  
ATOM   2081  CD1 TYR A 248      49.150  28.075  48.976  1.00 73.91           C  
ATOM   2082  CD2 TYR A 248      50.181  26.808  47.196  1.00 70.94           C  
ATOM   2083  CE1 TYR A 248      48.864  26.860  49.688  1.00 68.52           C  
ATOM   2084  CE2 TYR A 248      49.888  25.567  47.905  1.00 70.55           C  
ATOM   2085  CZ  TYR A 248      49.236  25.618  49.147  1.00 65.58           C  
ATOM   2086  OH  TYR A 248      48.944  24.483  49.857  1.00 61.77           O  
ATOM   2087  N   THR A 249      52.327  31.971  46.379  1.00 55.49           N  
ATOM   2088  CA  THR A 249      52.617  33.038  45.422  1.00 45.95           C  
ATOM   2089  C   THR A 249      52.961  32.435  44.083  1.00 48.47           C  
ATOM   2090  O   THR A 249      53.757  31.489  44.008  1.00 47.36           O  
ATOM   2091  CB  THR A 249      53.764  33.943  45.882  1.00 50.45           C  
ATOM   2092  OG1 THR A 249      53.455  34.463  47.181  1.00 52.54           O  
ATOM   2093  CG2 THR A 249      53.962  35.125  44.906  1.00 48.77           C  
ATOM   2094  N   TYR A 250      52.302  32.950  43.042  1.00 44.94           N  
ATOM   2095  CA  TYR A 250      52.498  32.499  41.660  1.00 35.24           C  
ATOM   2096  C   TYR A 250      52.548  33.716  40.733  1.00 28.15           C  
ATOM   2097  O   TYR A 250      51.918  34.731  41.050  1.00 28.54           O  
ATOM   2098  CB  TYR A 250      51.335  31.571  41.215  1.00 38.62           C  
ATOM   2099  CG  TYR A 250      51.324  30.190  41.847  1.00 39.77           C  
ATOM   2100  CD1 TYR A 250      50.262  29.782  42.674  1.00 45.50           C  
ATOM   2101  CD2 TYR A 250      52.377  29.277  41.626  1.00 49.88           C  
ATOM   2102  CE1 TYR A 250      50.232  28.481  43.284  1.00 51.48           C  
ATOM   2103  CE2 TYR A 250      52.369  27.967  42.226  1.00 61.19           C  
ATOM   2104  CZ  TYR A 250      51.286  27.578  43.057  1.00 58.93           C  
ATOM   2105  OH  TYR A 250      51.253  26.315  43.638  1.00 56.44           O  
ATOM   2106  N   PRO A 251      53.378  33.675  39.647  1.00 22.27           N  
ATOM   2107  CA  PRO A 251      53.499  34.774  38.665  1.00 18.87           C  
ATOM   2108  C   PRO A 251      52.270  34.764  37.785  1.00 14.60           C  
ATOM   2109  O   PRO A 251      51.824  33.688  37.342  1.00 15.89           O  
ATOM   2110  CB  PRO A 251      54.694  34.364  37.821  1.00 13.76           C  
ATOM   2111  CG  PRO A 251      55.486  33.572  38.760  1.00 20.66           C  
ATOM   2112  CD  PRO A 251      54.471  32.717  39.424  1.00 16.50           C  
ATOM   2113  N   ALA A 252      51.753  35.961  37.503  1.00 18.31           N  
ATOM   2114  CA  ALA A 252      50.570  36.151  36.669  1.00 15.58           C  
ATOM   2115  C   ALA A 252      50.677  35.466  35.312  1.00 22.29           C  
ATOM   2116  O   ALA A 252      49.671  35.178  34.663  1.00 20.97           O  
ATOM   2117  CB  ALA A 252      50.318  37.617  36.481  1.00 18.99           C  
ATOM   2118  N   THR A 253      51.914  35.156  34.940  1.00 25.86           N  
ATOM   2119  CA  THR A 253      52.254  34.499  33.684  1.00 31.99           C  
ATOM   2120  C   THR A 253      51.751  33.065  33.554  1.00 34.25           C  
ATOM   2121  O   THR A 253      51.454  32.613  32.444  1.00 38.14           O  
ATOM   2122  CB  THR A 253      53.774  34.521  33.425  1.00 34.06           C  
ATOM   2123  OG1 THR A 253      54.458  33.827  34.487  1.00 37.39           O  
ATOM   2124  CG2 THR A 253      54.275  35.973  33.299  1.00 24.12           C  
ATOM   2125  N   ILE A 254      51.640  32.349  34.668  1.00 36.01           N  
ATOM   2126  CA  ILE A 254      51.155  30.977  34.603  1.00 40.91           C  
ATOM   2127  C   ILE A 254      49.747  30.831  35.154  1.00 44.27           C  
ATOM   2128  O   ILE A 254      49.270  29.707  35.333  1.00 51.78           O  
ATOM   2129  CB  ILE A 254      52.075  29.973  35.331  1.00 38.76           C  
ATOM   2130  CG1 ILE A 254      52.333  30.433  36.769  1.00 35.86           C  
ATOM   2131  CG2 ILE A 254      53.307  29.685  34.487  1.00 35.98           C  
ATOM   2132  CD1 ILE A 254      52.360  29.309  37.738  1.00 37.40           C  
ATOM   2133  N   LEU A 255      49.085  31.949  35.444  1.00 47.43           N  
ATOM   2134  CA  LEU A 255      47.726  31.893  35.974  1.00 44.80           C  
ATOM   2135  C   LEU A 255      46.674  32.134  34.922  1.00 41.57           C  
ATOM   2136  O   LEU A 255      46.747  33.086  34.150  1.00 43.96           O  
ATOM   2137  CB  LEU A 255      47.534  32.880  37.121  1.00 35.72           C  
ATOM   2138  CG  LEU A 255      48.301  32.568  38.392  1.00 31.87           C  
ATOM   2139  CD1 LEU A 255      48.336  33.767  39.300  1.00 32.41           C  
ATOM   2140  CD2 LEU A 255      47.666  31.398  39.073  1.00 38.56           C  
ATOM   2141  N   LYS A 256      45.722  31.213  34.876  1.00 43.46           N  
ATOM   2142  CA  LYS A 256      44.601  31.292  33.969  1.00 39.64           C  
ATOM   2143  C   LYS A 256      43.357  31.368  34.856  1.00 32.69           C  
ATOM   2144  O   LYS A 256      43.300  30.685  35.872  1.00 34.64           O  
ATOM   2145  CB  LYS A 256      44.561  30.055  33.063  1.00 45.81           C  
ATOM   2146  CG  LYS A 256      45.152  30.255  31.644  1.00 52.14           C  
ATOM   2147  CD  LYS A 256      44.886  28.998  30.774  1.00 63.89           C  
ATOM   2148  CE  LYS A 256      45.106  29.193  29.262  1.00 58.36           C  
ATOM   2149  NZ  LYS A 256      44.350  28.166  28.440  1.00 60.28           N  
ATOM   2150  N   PRO A 257      42.430  32.308  34.572  1.00 36.27           N  
ATOM   2151  CA  PRO A 257      41.186  32.467  35.343  1.00 31.70           C  
ATOM   2152  C   PRO A 257      40.235  31.323  35.161  1.00 33.08           C  
ATOM   2153  O   PRO A 257      40.250  30.657  34.137  1.00 28.86           O  
ATOM   2154  CB  PRO A 257      40.582  33.737  34.770  1.00 28.24           C  
ATOM   2155  CG  PRO A 257      41.794  34.531  34.453  1.00 40.77           C  
ATOM   2156  CD  PRO A 257      42.678  33.525  33.777  1.00 36.70           C  
ATOM   2157  N   VAL A 258      39.431  31.086  36.187  1.00 37.22           N  
ATOM   2158  CA  VAL A 258      38.429  30.021  36.182  1.00 37.98           C  
ATOM   2159  C   VAL A 258      37.039  30.713  36.207  1.00 39.77           C  
ATOM   2160  O   VAL A 258      36.755  31.513  37.114  1.00 42.73           O  
ATOM   2161  CB  VAL A 258      38.681  29.059  37.386  1.00 32.21           C  
ATOM   2162  CG1 VAL A 258      37.551  28.075  37.540  1.00 44.10           C  
ATOM   2163  CG2 VAL A 258      39.983  28.284  37.181  1.00 34.07           C  
ATOM   2164  N   LEU A 259      36.210  30.427  35.192  1.00 39.38           N  
ATOM   2165  CA  LEU A 259      34.886  31.050  35.029  1.00 42.14           C  
ATOM   2166  C   LEU A 259      33.674  30.174  35.318  1.00 44.67           C  
ATOM   2167  O   LEU A 259      33.725  28.964  35.088  1.00 44.44           O  
ATOM   2168  CB  LEU A 259      34.739  31.576  33.600  1.00 25.52           C  
ATOM   2169  CG  LEU A 259      35.912  32.288  32.916  1.00 26.00           C  
ATOM   2170  CD1 LEU A 259      35.581  32.517  31.446  1.00 26.89           C  
ATOM   2171  CD2 LEU A 259      36.242  33.605  33.635  1.00 21.18           C  
ATOM   2172  N   THR A 260      32.593  30.819  35.793  1.00 51.05           N  
ATOM   2173  CA  THR A 260      31.267  30.205  36.111  1.00 61.09           C  
ATOM   2174  C   THR A 260      30.182  31.141  35.520  1.00 60.79           C  
ATOM   2175  O   THR A 260      30.535  32.178  34.948  1.00 63.04           O  
ATOM   2176  CB  THR A 260      31.019  30.004  37.674  1.00 63.83           C  
ATOM   2177  OG1 THR A 260      32.120  29.295  38.251  1.00 65.39           O  
ATOM   2178  CG2 THR A 260      29.731  29.172  37.960  1.00 62.27           C  
ATOM   2179  N   TYR A 261      28.897  30.786  35.722  1.00 64.67           N  
ATOM   2180  CA  TYR A 261      27.646  31.453  35.257  1.00 63.86           C  
ATOM   2181  C   TYR A 261      27.053  30.680  34.083  1.00 61.70           C  
ATOM   2182  O   TYR A 261      26.444  29.632  34.256  1.00 63.02           O  
ATOM   2183  CB  TYR A 261      27.793  32.929  34.813  1.00 60.25           C  
ATOM   2184  CG  TYR A 261      27.817  33.988  35.903  1.00 67.81           C  
ATOM   2185  CD1 TYR A 261      28.627  35.132  35.757  1.00 68.98           C  
ATOM   2186  CD2 TYR A 261      26.991  33.895  37.054  1.00 66.87           C  
ATOM   2187  CE1 TYR A 261      28.609  36.183  36.736  1.00 72.23           C  
ATOM   2188  CE2 TYR A 261      26.960  34.933  38.044  1.00 65.77           C  
ATOM   2189  CZ  TYR A 261      27.773  36.076  37.876  1.00 72.34           C  
ATOM   2190  OH  TYR A 261      27.731  37.120  38.791  1.00 72.16           O  
ATOM   2191  N   GLU A 268      24.945  33.818  22.502  1.00113.29           N  
ATOM   2192  CA  GLU A 268      25.004  33.668  23.959  1.00114.77           C  
ATOM   2193  C   GLU A 268      26.002  32.571  24.324  1.00110.01           C  
ATOM   2194  O   GLU A 268      25.967  31.482  23.746  1.00111.75           O  
ATOM   2195  CB  GLU A 268      23.617  33.317  24.527  1.00114.42           C  
ATOM   2196  CG  GLU A 268      22.516  34.374  24.275  1.00116.92           C  
ATOM   2197  CD  GLU A 268      21.097  33.897  24.644  1.00115.39           C  
ATOM   2198  OE1 GLU A 268      20.941  33.109  25.605  1.00120.00           O  
ATOM   2199  OE2 GLU A 268      20.128  34.311  23.968  1.00114.91           O  
ATOM   2200  N   ARG A 269      26.882  32.867  25.284  1.00110.77           N  
ATOM   2201  CA  ARG A 269      27.923  31.934  25.754  1.00108.48           C  
ATOM   2202  C   ARG A 269      27.378  30.831  26.629  1.00107.24           C  
ATOM   2203  O   ARG A 269      27.805  29.687  26.513  1.00103.78           O  
ATOM   2204  CB  ARG A 269      29.017  32.666  26.533  1.00112.45           C  
ATOM   2205  CG  ARG A 269      29.868  33.568  25.688  1.00109.83           C  
ATOM   2206  CD  ARG A 269      30.931  34.288  26.479  1.00110.83           C  
ATOM   2207  NE  ARG A 269      31.605  35.232  25.594  1.00111.53           N  
ATOM   2208  CZ  ARG A 269      32.798  35.780  25.802  1.00118.14           C  
ATOM   2209  NH1 ARG A 269      33.504  35.498  26.891  1.00113.53           N  
ATOM   2210  NH2 ARG A 269      33.287  36.617  24.894  1.00116.84           N  
ATOM   2211  N   ASN A 270      26.434  31.201  27.498  1.00107.22           N  
ATOM   2212  CA  ASN A 270      25.770  30.279  28.415  1.00 99.12           C  
ATOM   2213  C   ASN A 270      25.172  29.099  27.671  1.00 98.74           C  
ATOM   2214  O   ASN A 270      25.363  27.958  28.076  1.00100.00           O  
ATOM   2215  CB  ASN A 270      24.700  31.022  29.213  1.00102.19           C  
ATOM   2216  CG  ASN A 270      25.299  32.029  30.181  1.00102.47           C  
ATOM   2217  OD1 ASN A 270      25.761  31.670  31.262  1.00105.64           O  
ATOM   2218  ND2 ASN A 270      25.326  33.289  29.775  1.00102.82           N  
ATOM   2219  N   GLU A 271      24.598  29.384  26.504  1.00 93.08           N  
ATOM   2220  CA  GLU A 271      23.985  28.387  25.639  1.00 96.72           C  
ATOM   2221  C   GLU A 271      24.978  27.376  25.080  1.00 92.70           C  
ATOM   2222  O   GLU A 271      24.800  26.173  25.275  1.00 96.14           O  
ATOM   2223  CB  GLU A 271      23.271  29.061  24.476  1.00 97.73           C  
ATOM   2224  CG  GLU A 271      21.815  29.387  24.706  1.00104.52           C  
ATOM   2225  CD  GLU A 271      21.176  30.029  23.484  1.00105.56           C  
ATOM   2226  OE1 GLU A 271      21.440  29.578  22.346  1.00108.43           O  
ATOM   2227  OE2 GLU A 271      20.400  30.992  23.659  1.00110.42           O  
ATOM   2228  N   VAL A 272      26.050  27.869  24.449  1.00 88.29           N  
ATOM   2229  CA  VAL A 272      27.070  27.001  23.829  1.00 91.02           C  
ATOM   2230  C   VAL A 272      27.939  26.268  24.867  1.00 90.39           C  
ATOM   2231  O   VAL A 272      28.617  25.285  24.543  1.00 89.72           O  
ATOM   2232  CB  VAL A 272      28.011  27.761  22.800  1.00 94.14           C  
ATOM   2233  CG1 VAL A 272      28.465  26.802  21.683  1.00 95.89           C  
ATOM   2234  CG2 VAL A 272      27.321  28.987  22.179  1.00 93.24           C  
ATOM   2235  N   ALA A 273      27.886  26.741  26.111  1.00 91.65           N  
ATOM   2236  CA  ALA A 273      28.644  26.148  27.211  1.00 89.89           C  
ATOM   2237  C   ALA A 273      27.755  25.310  28.133  1.00 90.96           C  
ATOM   2238  O   ALA A 273      28.166  24.911  29.224  1.00 93.39           O  
ATOM   2239  CB  ALA A 273      29.393  27.232  27.995  1.00 90.84           C  
ATOM   2240  N   ASP A 274      26.523  25.071  27.691  1.00 89.97           N  
ATOM   2241  CA  ASP A 274      25.569  24.234  28.418  1.00 92.58           C  
ATOM   2242  C   ASP A 274      25.523  22.834  27.771  1.00 95.74           C  
ATOM   2243  O   ASP A 274      24.712  21.984  28.150  1.00 95.78           O  
ATOM   2244  CB  ASP A 274      24.169  24.885  28.468  1.00 98.49           C  
ATOM   2245  CG  ASP A 274      23.947  25.745  29.732  1.00 98.59           C  
ATOM   2246  OD1 ASP A 274      24.891  25.890  30.547  1.00 96.60           O  
ATOM   2247  OD2 ASP A 274      22.824  26.287  29.901  1.00 99.78           O  
ATOM   2248  N   ILE A 275      26.411  22.606  26.796  1.00 93.60           N  
ATOM   2249  CA  ILE A 275      26.536  21.308  26.106  1.00 93.20           C  
ATOM   2250  C   ILE A 275      27.559  20.513  26.935  1.00 88.67           C  
ATOM   2251  O   ILE A 275      27.825  19.338  26.686  1.00 89.33           O  
ATOM   2252  CB  ILE A 275      27.083  21.436  24.628  1.00 94.29           C  
ATOM   2253  CG1 ILE A 275      26.524  22.686  23.920  1.00 98.60           C  
ATOM   2254  CG2 ILE A 275      26.687  20.181  23.808  1.00 95.96           C  
ATOM   2255  CD1 ILE A 275      27.175  23.008  22.534  1.00 93.13           C  
ATOM   2256  N   VAL A 276      28.094  21.183  27.948  1.00 90.19           N  
ATOM   2257  CA  VAL A 276      29.076  20.635  28.858  1.00 85.38           C  
ATOM   2258  C   VAL A 276      28.429  19.820  29.973  1.00 79.99           C  
ATOM   2259  O   VAL A 276      29.112  19.065  30.674  1.00 83.56           O  
ATOM   2260  CB  VAL A 276      29.974  21.791  29.355  1.00 83.37           C  
ATOM   2261  CG1 VAL A 276      29.980  21.973  30.899  1.00 75.37           C  
ATOM   2262  CG2 VAL A 276      31.343  21.604  28.768  1.00 85.16           C  
ATOM   2263  N   ARG A 277      27.109  19.971  30.101  1.00 82.59           N  
ATOM   2264  CA  ARG A 277      26.295  19.258  31.086  1.00 82.02           C  
ATOM   2265  C   ARG A 277      26.316  17.777  30.755  1.00 83.56           C  
ATOM   2266  O   ARG A 277      26.342  16.936  31.655  1.00 84.40           O  
ATOM   2267  CB  ARG A 277      24.848  19.756  31.062  1.00 84.80           C  
ATOM   2268  CG  ARG A 277      24.679  21.179  31.575  1.00 86.81           C  
ATOM   2269  CD  ARG A 277      23.204  21.613  31.632  1.00 91.61           C  
ATOM   2270  NE  ARG A 277      23.056  23.007  32.070  1.00 90.04           N  
ATOM   2271  CZ  ARG A 277      21.918  23.579  32.462  1.00 91.06           C  
ATOM   2272  NH1 ARG A 277      20.778  22.894  32.490  1.00 90.37           N  
ATOM   2273  NH2 ARG A 277      21.927  24.855  32.825  1.00 95.88           N  
HETATM 2274  N   MSE A 278      26.363  17.487  29.450  1.00 83.67           N  
HETATM 2275  CA  MSE A 278      26.398  16.135  28.867  1.00 84.09           C  
HETATM 2276  C   MSE A 278      25.235  15.240  29.251  1.00 84.80           C  
HETATM 2277  O   MSE A 278      24.554  15.478  30.242  1.00 83.96           O  
HETATM 2278  CB  MSE A 278      27.719  15.402  29.186  1.00 82.93           C  
HETATM 2279  CG  MSE A 278      28.958  15.934  28.463  1.00 89.61           C  
HETATM 2280 SE   MSE A 278      30.450  14.666  28.394  1.00 92.13          SE  
HETATM 2281  CE  MSE A 278      31.234  15.047  30.086  1.00 94.26           C  
ATOM   2282  N   GLU A 279      24.984  14.222  28.427  1.00 85.98           N  
ATOM   2283  CA  GLU A 279      23.930  13.250  28.720  1.00 89.77           C  
ATOM   2284  C   GLU A 279      24.589  12.263  29.706  1.00 88.38           C  
ATOM   2285  O   GLU A 279      25.828  12.181  29.737  1.00 87.60           O  
ATOM   2286  CB  GLU A 279      23.528  12.483  27.446  1.00 94.54           C  
ATOM   2287  CG  GLU A 279      22.852  13.288  26.334  1.00103.51           C  
ATOM   2288  CD  GLU A 279      22.700  12.491  25.021  1.00107.43           C  
ATOM   2289  OE1 GLU A 279      23.370  11.443  24.840  1.00114.99           O  
ATOM   2290  OE2 GLU A 279      21.923  12.928  24.143  1.00111.83           O  
ATOM   2291  N   PRO A 280      23.804  11.572  30.581  1.00 81.30           N  
ATOM   2292  CA  PRO A 280      24.432  10.619  31.510  1.00 80.17           C  
ATOM   2293  C   PRO A 280      25.195   9.482  30.796  1.00 74.69           C  
ATOM   2294  O   PRO A 280      26.140   8.941  31.347  1.00 71.39           O  
ATOM   2295  CB  PRO A 280      23.237  10.106  32.313  1.00 81.66           C  
ATOM   2296  CG  PRO A 280      22.412  11.330  32.444  1.00 86.23           C  
ATOM   2297  CD  PRO A 280      22.413  11.834  31.007  1.00 81.79           C  
ATOM   2298  N   GLY A 281      24.813   9.195  29.547  1.00 68.13           N  
ATOM   2299  CA  GLY A 281      25.475   8.182  28.740  1.00 63.35           C  
ATOM   2300  C   GLY A 281      26.861   8.632  28.306  1.00 60.50           C  
ATOM   2301  O   GLY A 281      27.796   7.839  28.336  1.00 58.90           O  
ATOM   2302  N   LYS A 282      26.988   9.934  28.015  1.00 59.13           N  
ATOM   2303  CA  LYS A 282      28.236  10.596  27.582  1.00 65.50           C  
ATOM   2304  C   LYS A 282      29.391  10.683  28.595  1.00 63.76           C  
ATOM   2305  O   LYS A 282      30.548  10.558  28.198  1.00 63.77           O  
ATOM   2306  CB  LYS A 282      27.939  12.007  27.065  1.00 65.52           C  
ATOM   2307  CG  LYS A 282      27.203  12.062  25.734  1.00 78.81           C  
ATOM   2308  CD  LYS A 282      26.788  13.490  25.354  1.00 83.78           C  
ATOM   2309  CE  LYS A 282      26.130  13.519  23.967  1.00 76.86           C  
ATOM   2310  NZ  LYS A 282      25.406  14.793  23.688  1.00 79.00           N  
ATOM   2311  N   ARG A 283      29.095  10.965  29.873  1.00 57.55           N  
ATOM   2312  CA  ARG A 283      30.130  11.024  30.927  1.00 50.24           C  
ATOM   2313  C   ARG A 283      30.502   9.599  31.227  1.00 42.53           C  
ATOM   2314  O   ARG A 283      31.669   9.263  31.208  1.00 41.24           O  
ATOM   2315  CB  ARG A 283      29.637  11.627  32.257  1.00 53.97           C  
ATOM   2316  CG  ARG A 283      29.183  13.053  32.204  1.00 58.85           C  
ATOM   2317  CD  ARG A 283      29.193  13.711  33.546  1.00 60.52           C  
ATOM   2318  NE  ARG A 283      29.488  15.146  33.435  1.00 67.24           N  
ATOM   2319  CZ  ARG A 283      28.691  16.143  33.826  1.00 68.32           C  
ATOM   2320  NH1 ARG A 283      27.511  15.900  34.382  1.00 71.75           N  
ATOM   2321  NH2 ARG A 283      29.076  17.398  33.635  1.00 69.36           N  
ATOM   2322  N   LEU A 284      29.475   8.771  31.428  1.00 30.20           N  
ATOM   2323  CA  LEU A 284      29.612   7.359  31.757  1.00 32.46           C  
ATOM   2324  C   LEU A 284      30.470   6.593  30.764  1.00 36.64           C  
ATOM   2325  O   LEU A 284      31.339   5.840  31.186  1.00 38.62           O  
ATOM   2326  CB  LEU A 284      28.234   6.692  31.912  1.00 34.19           C  
ATOM   2327  CG  LEU A 284      28.035   5.251  32.411  1.00 26.96           C  
ATOM   2328  CD1 LEU A 284      28.413   5.132  33.844  1.00 19.63           C  
ATOM   2329  CD2 LEU A 284      26.604   4.822  32.242  1.00 29.37           C  
ATOM   2330  N   ASN A 285      30.290   6.848  29.465  1.00 36.08           N  
ATOM   2331  CA  ASN A 285      31.078   6.159  28.431  1.00 36.42           C  
ATOM   2332  C   ASN A 285      32.474   6.726  28.262  1.00 30.60           C  
ATOM   2333  O   ASN A 285      33.402   6.005  27.866  1.00 33.14           O  
ATOM   2334  CB  ASN A 285      30.343   6.126  27.093  1.00 40.37           C  
ATOM   2335  CG  ASN A 285      29.065   5.292  27.139  1.00 45.56           C  
ATOM   2336  OD1 ASN A 285      28.357   5.214  26.142  1.00 53.92           O  
ATOM   2337  ND2 ASN A 285      28.743   4.710  28.296  1.00 51.47           N  
ATOM   2338  N   LEU A 286      32.613   7.991  28.655  1.00 31.46           N  
ATOM   2339  CA  LEU A 286      33.868   8.730  28.605  1.00 31.58           C  
ATOM   2340  C   LEU A 286      34.718   8.269  29.771  1.00 29.31           C  
ATOM   2341  O   LEU A 286      35.868   7.915  29.582  1.00 29.48           O  
ATOM   2342  CB  LEU A 286      33.611  10.227  28.729  1.00 31.70           C  
ATOM   2343  CG  LEU A 286      34.400  11.228  27.890  1.00 28.08           C  
ATOM   2344  CD1 LEU A 286      35.492  10.572  27.055  1.00 22.12           C  
ATOM   2345  CD2 LEU A 286      33.405  12.035  27.061  1.00 18.08           C  
ATOM   2346  N   ILE A 287      34.127   8.254  30.967  1.00 26.21           N  
ATOM   2347  CA  ILE A 287      34.784   7.761  32.175  1.00 26.03           C  
ATOM   2348  C   ILE A 287      35.232   6.342  31.835  1.00 32.54           C  
ATOM   2349  O   ILE A 287      36.398   6.013  32.055  1.00 39.20           O  
ATOM   2350  CB  ILE A 287      33.802   7.759  33.365  1.00 15.88           C  
ATOM   2351  CG1 ILE A 287      33.614   9.185  33.854  1.00  8.46           C  
ATOM   2352  CG2 ILE A 287      34.219   6.787  34.492  1.00  2.00           C  
ATOM   2353  CD1 ILE A 287      32.351   9.338  34.659  1.00  3.26           C  
ATOM   2354  N   ARG A 288      34.345   5.577  31.167  1.00 41.91           N  
ATOM   2355  CA  ARG A 288      34.628   4.196  30.733  1.00 40.45           C  
ATOM   2356  C   ARG A 288      35.760   4.185  29.729  1.00 37.57           C  
ATOM   2357  O   ARG A 288      36.485   3.216  29.667  1.00 44.43           O  
ATOM   2358  CB  ARG A 288      33.411   3.491  30.114  1.00 33.36           C  
ATOM   2359  CG  ARG A 288      32.333   3.034  31.091  1.00 32.54           C  
ATOM   2360  CD  ARG A 288      31.103   2.519  30.346  1.00 37.23           C  
ATOM   2361  NE  ARG A 288      29.940   2.385  31.221  1.00 36.56           N  
ATOM   2362  CZ  ARG A 288      29.099   1.352  31.221  1.00 36.20           C  
ATOM   2363  NH1 ARG A 288      29.263   0.335  30.384  1.00 40.99           N  
ATOM   2364  NH2 ARG A 288      28.119   1.308  32.109  1.00 35.23           N  
ATOM   2365  N   TYR A 289      35.950   5.266  28.982  1.00 33.10           N  
ATOM   2366  CA  TYR A 289      37.052   5.296  28.022  1.00 44.31           C  
ATOM   2367  C   TYR A 289      38.378   5.621  28.730  1.00 39.25           C  
ATOM   2368  O   TYR A 289      39.420   5.097  28.359  1.00 34.88           O  
ATOM   2369  CB  TYR A 289      36.761   6.291  26.877  1.00 56.99           C  
ATOM   2370  CG  TYR A 289      37.758   6.277  25.713  1.00 68.72           C  
ATOM   2371  CD1 TYR A 289      37.796   5.202  24.782  1.00 75.11           C  
ATOM   2372  CD2 TYR A 289      38.652   7.359  25.516  1.00 69.72           C  
ATOM   2373  CE1 TYR A 289      38.717   5.218  23.665  1.00 77.19           C  
ATOM   2374  CE2 TYR A 289      39.567   7.388  24.414  1.00 76.52           C  
ATOM   2375  CZ  TYR A 289      39.594   6.323  23.495  1.00 78.59           C  
ATOM   2376  OH  TYR A 289      40.471   6.387  22.424  1.00 74.31           O  
ATOM   2377  N   ILE A 290      38.311   6.432  29.785  1.00 38.98           N  
ATOM   2378  CA  ILE A 290      39.486   6.844  30.565  1.00 36.80           C  
ATOM   2379  C   ILE A 290      40.067   5.653  31.330  1.00 37.05           C  
ATOM   2380  O   ILE A 290      41.290   5.473  31.389  1.00 40.45           O  
ATOM   2381  CB  ILE A 290      39.119   7.965  31.571  1.00 31.35           C  
ATOM   2382  CG1 ILE A 290      38.369   9.078  30.853  1.00 29.77           C  
ATOM   2383  CG2 ILE A 290      40.374   8.562  32.207  1.00 36.70           C  
ATOM   2384  CD1 ILE A 290      37.757  10.129  31.742  1.00 40.69           C  
ATOM   2385  N   LEU A 291      39.173   4.842  31.896  1.00 46.52           N  
ATOM   2386  CA  LEU A 291      39.522   3.641  32.660  1.00 47.86           C  
ATOM   2387  C   LEU A 291      40.370   2.665  31.868  1.00 48.81           C  
ATOM   2388  O   LEU A 291      41.395   2.197  32.356  1.00 49.50           O  
ATOM   2389  CB  LEU A 291      38.268   2.888  33.071  1.00 47.44           C  
ATOM   2390  CG  LEU A 291      37.471   3.185  34.317  1.00 45.47           C  
ATOM   2391  CD1 LEU A 291      36.637   1.945  34.542  1.00 44.82           C  
ATOM   2392  CD2 LEU A 291      38.386   3.393  35.490  1.00 40.41           C  
ATOM   2393  N   ARG A 292      39.934   2.387  30.637  1.00 52.28           N  
ATOM   2394  CA  ARG A 292      40.613   1.463  29.741  1.00 52.82           C  
ATOM   2395  C   ARG A 292      42.100   1.803  29.577  1.00 52.49           C  
ATOM   2396  O   ARG A 292      42.944   0.925  29.751  1.00 53.83           O  
ATOM   2397  CB  ARG A 292      39.898   1.413  28.384  1.00 54.70           C  
ATOM   2398  CG  ARG A 292      38.441   0.927  28.415  1.00 64.94           C  
ATOM   2399  CD  ARG A 292      37.910   0.691  27.003  1.00 67.35           C  
ATOM   2400  NE  ARG A 292      36.448   0.725  26.879  1.00 79.03           N  
ATOM   2401  CZ  ARG A 292      35.762   0.201  25.861  1.00 83.22           C  
ATOM   2402  NH1 ARG A 292      36.387  -0.419  24.860  1.00 79.53           N  
ATOM   2403  NH2 ARG A 292      34.439   0.322  25.835  1.00 87.05           N  
ATOM   2404  N   ARG A 293      42.406   3.099  29.422  1.00 53.89           N  
ATOM   2405  CA  ARG A 293      43.787   3.589  29.240  1.00 55.63           C  
ATOM   2406  C   ARG A 293      44.668   3.462  30.473  1.00 52.33           C  
ATOM   2407  O   ARG A 293      45.885   3.243  30.359  1.00 50.86           O  
ATOM   2408  CB  ARG A 293      43.807   5.033  28.739  1.00 59.45           C  
ATOM   2409  CG  ARG A 293      43.333   5.198  27.307  1.00 67.29           C  
ATOM   2410  CD  ARG A 293      43.325   6.662  26.953  1.00 71.76           C  
ATOM   2411  NE  ARG A 293      42.740   6.940  25.643  1.00 75.05           N  
ATOM   2412  CZ  ARG A 293      43.304   7.714  24.720  1.00 82.97           C  
ATOM   2413  NH1 ARG A 293      44.486   8.288  24.950  1.00 84.05           N  
ATOM   2414  NH2 ARG A 293      42.664   7.956  23.578  1.00 90.45           N  
ATOM   2415  N   TYR A 294      44.038   3.604  31.643  1.00 48.73           N  
ATOM   2416  CA  TYR A 294      44.715   3.467  32.933  1.00 45.42           C  
ATOM   2417  C   TYR A 294      45.113   2.006  33.105  1.00 43.90           C  
ATOM   2418  O   TYR A 294      46.228   1.719  33.531  1.00 44.27           O  
ATOM   2419  CB  TYR A 294      43.798   3.858  34.115  1.00 41.37           C  
ATOM   2420  CG  TYR A 294      43.580   5.336  34.385  1.00 33.22           C  
ATOM   2421  CD1 TYR A 294      42.693   5.760  35.391  1.00 19.87           C  
ATOM   2422  CD2 TYR A 294      44.233   6.325  33.620  1.00 37.96           C  
ATOM   2423  CE1 TYR A 294      42.465   7.145  35.616  1.00 27.75           C  
ATOM   2424  CE2 TYR A 294      44.018   7.712  33.837  1.00 30.58           C  
ATOM   2425  CZ  TYR A 294      43.141   8.111  34.824  1.00 29.29           C  
ATOM   2426  OH  TYR A 294      42.950   9.450  34.987  1.00 23.52           O  
ATOM   2427  N   VAL A 295      44.227   1.102  32.676  1.00 43.77           N  
ATOM   2428  CA  VAL A 295      44.466  -0.327  32.809  1.00 44.14           C  
ATOM   2429  C   VAL A 295      45.578  -0.833  31.898  1.00 44.92           C  
ATOM   2430  O   VAL A 295      46.230  -1.815  32.251  1.00 48.42           O  
ATOM   2431  CB  VAL A 295      43.185  -1.194  32.626  1.00 45.60           C  
ATOM   2432  CG1 VAL A 295      43.363  -2.544  33.351  1.00 53.06           C  
ATOM   2433  CG2 VAL A 295      41.965  -0.509  33.207  1.00 46.57           C  
ATOM   2434  N   LYS A 296      45.830  -0.159  30.767  1.00 48.98           N  
ATOM   2435  CA  LYS A 296      46.921  -0.556  29.841  1.00 43.27           C  
ATOM   2436  C   LYS A 296      48.231  -0.158  30.514  1.00 43.26           C  
ATOM   2437  O   LYS A 296      49.175  -0.956  30.701  1.00 42.39           O  
ATOM   2438  CB  LYS A 296      46.885   0.248  28.529  1.00 54.50           C  
ATOM   2439  CG  LYS A 296      46.075  -0.285  27.370  1.00 56.56           C  
ATOM   2440  CD  LYS A 296      46.584   0.365  26.062  1.00 56.93           C  
ATOM   2441  CE  LYS A 296      45.836  -0.175  24.844  1.00 59.79           C  
ATOM   2442  NZ  LYS A 296      46.636  -0.082  23.587  1.00 64.26           N  
ATOM   2443  N   ALA A 297      48.183   1.093  30.959  1.00 39.37           N  
ATOM   2444  CA  ALA A 297      49.266   1.791  31.594  1.00 35.57           C  
ATOM   2445  C   ALA A 297      49.688   1.256  32.933  1.00 37.24           C  
ATOM   2446  O   ALA A 297      50.843   1.463  33.324  1.00 37.12           O  
ATOM   2447  CB  ALA A 297      48.877   3.234  31.731  1.00 37.86           C  
ATOM   2448  N   LEU A 298      48.756   0.603  33.644  1.00 31.41           N  
ATOM   2449  CA  LEU A 298      49.025   0.113  34.998  1.00 28.49           C  
ATOM   2450  C   LEU A 298      48.912  -1.385  35.375  1.00 24.92           C  
ATOM   2451  O   LEU A 298      49.323  -1.775  36.482  1.00 22.29           O  
ATOM   2452  CB  LEU A 298      48.252   0.976  36.007  1.00 24.01           C  
ATOM   2453  CG  LEU A 298      48.198   2.520  35.994  1.00 23.68           C  
ATOM   2454  CD1 LEU A 298      47.612   2.992  37.287  1.00 25.34           C  
ATOM   2455  CD2 LEU A 298      49.545   3.178  35.834  1.00 24.14           C  
ATOM   2456  N   ARG A 299      48.412  -2.216  34.454  1.00 29.00           N  
ATOM   2457  CA  ARG A 299      48.250  -3.682  34.637  1.00 36.42           C  
ATOM   2458  C   ARG A 299      49.587  -4.360  34.927  1.00 36.92           C  
ATOM   2459  O   ARG A 299      49.686  -5.294  35.720  1.00 36.87           O  
ATOM   2460  CB  ARG A 299      47.718  -4.301  33.340  1.00 39.17           C  
ATOM   2461  CG  ARG A 299      46.479  -5.187  33.441  1.00 43.42           C  
ATOM   2462  CD  ARG A 299      46.194  -5.832  32.066  1.00 52.71           C  
ATOM   2463  NE  ARG A 299      45.832  -4.873  30.994  1.00 54.64           N  
ATOM   2464  CZ  ARG A 299      46.263  -4.892  29.719  1.00 57.57           C  
ATOM   2465  NH1 ARG A 299      47.128  -5.810  29.277  1.00 63.86           N  
ATOM   2466  NH2 ARG A 299      45.717  -4.067  28.831  1.00 53.90           N  
ATOM   2467  N   ASP A 300      50.604  -3.857  34.235  1.00 43.00           N  
ATOM   2468  CA  ASP A 300      51.978  -4.330  34.315  1.00 37.81           C  
ATOM   2469  C   ASP A 300      52.629  -3.911  35.627  1.00 32.95           C  
ATOM   2470  O   ASP A 300      53.581  -4.537  36.099  1.00 33.45           O  
ATOM   2471  CB  ASP A 300      52.754  -3.781  33.108  1.00 45.28           C  
ATOM   2472  CG  ASP A 300      52.239  -4.343  31.761  1.00 50.37           C  
ATOM   2473  OD1 ASP A 300      51.341  -5.222  31.746  1.00 50.27           O  
ATOM   2474  OD2 ASP A 300      52.766  -3.931  30.703  1.00 56.76           O  
ATOM   2475  N   TYR A 301      52.022  -2.915  36.265  1.00 31.40           N  
ATOM   2476  CA  TYR A 301      52.526  -2.366  37.522  1.00 30.62           C  
ATOM   2477  C   TYR A 301      51.825  -2.978  38.719  1.00 27.35           C  
ATOM   2478  O   TYR A 301      52.188  -2.724  39.872  1.00 20.96           O  
ATOM   2479  CB  TYR A 301      52.433  -0.841  37.478  1.00 24.14           C  
ATOM   2480  CG  TYR A 301      53.322  -0.275  36.383  1.00 32.05           C  
ATOM   2481  CD1 TYR A 301      52.857  -0.156  35.060  1.00 31.36           C  
ATOM   2482  CD2 TYR A 301      54.683   0.036  36.636  1.00 32.89           C  
ATOM   2483  CE1 TYR A 301      53.725   0.243  34.001  1.00 32.21           C  
ATOM   2484  CE2 TYR A 301      55.566   0.443  35.577  1.00 33.36           C  
ATOM   2485  CZ  TYR A 301      55.076   0.532  34.268  1.00 34.48           C  
ATOM   2486  OH  TYR A 301      55.933   0.825  33.231  1.00 34.31           O  
ATOM   2487  N   GLY A 302      50.879  -3.862  38.401  1.00 28.01           N  
ATOM   2488  CA  GLY A 302      50.103  -4.593  39.393  1.00 29.84           C  
ATOM   2489  C   GLY A 302      48.724  -4.062  39.742  1.00 25.16           C  
ATOM   2490  O   GLY A 302      48.128  -4.522  40.718  1.00 23.35           O  
ATOM   2491  N   TRP A 303      48.197  -3.138  38.937  1.00 26.27           N  
ATOM   2492  CA  TRP A 303      46.887  -2.530  39.186  1.00 23.72           C  
ATOM   2493  C   TRP A 303      45.702  -3.084  38.407  1.00 26.56           C  
ATOM   2494  O   TRP A 303      45.763  -3.238  37.187  1.00 26.42           O  
ATOM   2495  CB  TRP A 303      46.936  -1.030  38.909  1.00 22.49           C  
ATOM   2496  CG  TRP A 303      47.715  -0.236  39.864  1.00 23.32           C  
ATOM   2497  CD1 TRP A 303      49.004   0.142  39.726  1.00 24.94           C  
ATOM   2498  CD2 TRP A 303      47.257   0.322  41.121  1.00 26.31           C  
ATOM   2499  NE1 TRP A 303      49.392   0.909  40.800  1.00 27.08           N  
ATOM   2500  CE2 TRP A 303      48.346   1.043  41.671  1.00 21.22           C  
ATOM   2501  CE3 TRP A 303      46.026   0.289  41.825  1.00 27.99           C  
ATOM   2502  CZ2 TRP A 303      48.262   1.722  42.911  1.00 18.18           C  
ATOM   2503  CZ3 TRP A 303      45.939   0.971  43.086  1.00 19.58           C  
ATOM   2504  CH2 TRP A 303      47.067   1.679  43.600  1.00 19.09           C  
ATOM   2505  N   TYR A 304      44.600  -3.297  39.123  1.00 25.26           N  
ATOM   2506  CA  TYR A 304      43.358  -3.769  38.534  1.00 21.98           C  
ATOM   2507  C   TYR A 304      42.294  -2.766  38.906  1.00 24.14           C  
ATOM   2508  O   TYR A 304      42.292  -2.235  40.018  1.00 28.76           O  
ATOM   2509  CB  TYR A 304      42.937  -5.115  39.098  1.00 26.39           C  
ATOM   2510  CG  TYR A 304      41.640  -5.635  38.522  1.00 15.29           C  
ATOM   2511  CD1 TYR A 304      41.610  -6.165  37.216  1.00 16.56           C  
ATOM   2512  CD2 TYR A 304      40.442  -5.646  39.288  1.00 11.96           C  
ATOM   2513  CE1 TYR A 304      40.432  -6.707  36.670  1.00 24.50           C  
ATOM   2514  CE2 TYR A 304      39.233  -6.188  38.747  1.00 27.71           C  
ATOM   2515  CZ  TYR A 304      39.249  -6.718  37.432  1.00 31.81           C  
ATOM   2516  OH  TYR A 304      38.114  -7.257  36.861  1.00 37.26           O  
ATOM   2517  N   ILE A 305      41.414  -2.505  37.943  1.00 22.04           N  
ATOM   2518  CA  ILE A 305      40.287  -1.609  38.097  1.00 24.94           C  
ATOM   2519  C   ILE A 305      39.134  -2.362  37.435  1.00 24.30           C  
ATOM   2520  O   ILE A 305      39.255  -2.831  36.290  1.00 21.93           O  
ATOM   2521  CB  ILE A 305      40.502  -0.213  37.391  1.00 26.30           C  
ATOM   2522  CG1 ILE A 305      41.790   0.490  37.891  1.00 22.30           C  
ATOM   2523  CG2 ILE A 305      39.297   0.716  37.694  1.00 23.14           C  
ATOM   2524  CD1 ILE A 305      42.148   1.784  37.190  1.00 17.20           C  
ATOM   2525  N   SER A 306      38.032  -2.503  38.173  1.00 27.34           N  
ATOM   2526  CA  SER A 306      36.841  -3.175  37.691  1.00 33.17           C  
ATOM   2527  C   SER A 306      36.187  -2.379  36.537  1.00 39.33           C  
ATOM   2528  O   SER A 306      36.106  -1.146  36.594  1.00 37.98           O  
ATOM   2529  CB  SER A 306      35.835  -3.329  38.849  1.00 37.25           C  
ATOM   2530  OG  SER A 306      34.819  -4.295  38.562  1.00 31.12           O  
ATOM   2531  N   PRO A 307      35.854  -3.064  35.408  1.00 44.14           N  
ATOM   2532  CA  PRO A 307      35.209  -2.428  34.239  1.00 39.41           C  
ATOM   2533  C   PRO A 307      33.747  -2.093  34.567  1.00 35.20           C  
ATOM   2534  O   PRO A 307      33.118  -1.261  33.913  1.00 32.72           O  
ATOM   2535  CB  PRO A 307      35.269  -3.536  33.186  1.00 40.40           C  
ATOM   2536  CG  PRO A 307      36.529  -4.270  33.548  1.00 43.57           C  
ATOM   2537  CD  PRO A 307      36.356  -4.404  35.036  1.00 43.18           C  
ATOM   2538  N   GLU A 308      33.252  -2.749  35.611  1.00 25.82           N  
ATOM   2539  CA  GLU A 308      31.896  -2.605  36.085  1.00 34.51           C  
ATOM   2540  C   GLU A 308      31.683  -1.615  37.254  1.00 35.39           C  
ATOM   2541  O   GLU A 308      32.299  -1.728  38.329  1.00 39.64           O  
ATOM   2542  CB  GLU A 308      31.333  -3.991  36.421  1.00 36.23           C  
ATOM   2543  CG  GLU A 308      31.099  -4.876  35.188  1.00 42.45           C  
ATOM   2544  CD  GLU A 308      29.706  -5.484  35.141  1.00 44.69           C  
ATOM   2545  OE1 GLU A 308      29.432  -6.408  35.945  1.00 42.68           O  
ATOM   2546  OE2 GLU A 308      28.885  -5.039  34.308  1.00 43.12           O  
ATOM   2547  N   GLU A 309      30.754  -0.676  37.030  1.00 30.27           N  
ATOM   2548  CA  GLU A 309      30.357   0.358  37.981  1.00 25.53           C  
ATOM   2549  C   GLU A 309      29.761  -0.283  39.196  1.00 25.25           C  
ATOM   2550  O   GLU A 309      29.322  -1.421  39.117  1.00 22.80           O  
ATOM   2551  CB  GLU A 309      29.281   1.253  37.370  1.00 27.89           C  
ATOM   2552  CG  GLU A 309      29.741   2.263  36.320  1.00 25.72           C  
ATOM   2553  CD  GLU A 309      30.121   1.674  34.960  1.00 35.20           C  
ATOM   2554  OE1 GLU A 309      29.688   0.543  34.604  1.00 32.98           O  
ATOM   2555  OE2 GLU A 309      30.861   2.382  34.237  1.00 33.34           O  
ATOM   2556  N   GLU A 310      29.770   0.420  40.324  1.00 24.34           N  
ATOM   2557  CA  GLU A 310      29.170  -0.126  41.522  1.00 23.45           C  
ATOM   2558  C   GLU A 310      27.739   0.373  41.515  1.00 30.30           C  
ATOM   2559  O   GLU A 310      27.473   1.545  41.219  1.00 28.49           O  
ATOM   2560  CB  GLU A 310      29.912   0.307  42.784  1.00 25.54           C  
ATOM   2561  CG  GLU A 310      31.337  -0.256  42.933  1.00 29.94           C  
ATOM   2562  CD  GLU A 310      31.420  -1.780  43.162  1.00 41.63           C  
ATOM   2563  OE1 GLU A 310      30.950  -2.259  44.231  1.00 41.39           O  
ATOM   2564  OE2 GLU A 310      31.992  -2.488  42.283  1.00 41.32           O  
ATOM   2565  N   ARG A 311      26.815  -0.566  41.692  1.00 30.44           N  
ATOM   2566  CA  ARG A 311      25.395  -0.261  41.702  1.00 28.47           C  
ATOM   2567  C   ARG A 311      24.965   0.200  43.069  1.00 21.18           C  
ATOM   2568  O   ARG A 311      25.538  -0.226  44.073  1.00 20.01           O  
ATOM   2569  CB  ARG A 311      24.593  -1.489  41.287  1.00 28.94           C  
ATOM   2570  CG  ARG A 311      24.563  -1.708  39.783  1.00 39.90           C  
ATOM   2571  CD  ARG A 311      25.301  -2.968  39.322  1.00 48.50           C  
ATOM   2572  NE  ARG A 311      26.086  -2.728  38.106  1.00 54.89           N  
ATOM   2573  CZ  ARG A 311      25.761  -3.130  36.877  1.00 58.01           C  
ATOM   2574  NH1 ARG A 311      24.639  -3.813  36.645  1.00 56.40           N  
ATOM   2575  NH2 ARG A 311      26.561  -2.810  35.861  1.00 59.74           N  
ATOM   2576  N   ALA A 312      23.966   1.079  43.094  1.00 19.55           N  
ATOM   2577  CA  ALA A 312      23.400   1.614  44.340  1.00 24.59           C  
ATOM   2578  C   ALA A 312      22.699   0.526  45.124  1.00 22.70           C  
ATOM   2579  O   ALA A 312      22.310  -0.488  44.548  1.00 30.47           O  
ATOM   2580  CB  ALA A 312      22.412   2.712  44.034  1.00 18.23           C  
ATOM   2581  N   LYS A 313      22.545   0.718  46.426  1.00 24.21           N  
ATOM   2582  CA  LYS A 313      21.861  -0.285  47.229  1.00 31.33           C  
ATOM   2583  C   LYS A 313      20.340  -0.274  47.041  1.00 32.42           C  
ATOM   2584  O   LYS A 313      19.758  -1.325  46.785  1.00 37.88           O  
ATOM   2585  CB  LYS A 313      22.240  -0.160  48.686  1.00 36.24           C  
ATOM   2586  CG  LYS A 313      23.686  -0.563  48.964  1.00 46.84           C  
ATOM   2587  CD  LYS A 313      24.082  -0.350  50.437  1.00 53.94           C  
ATOM   2588  CE  LYS A 313      23.280  -1.202  51.428  1.00 48.59           C  
ATOM   2589  NZ  LYS A 313      23.650  -0.864  52.832  1.00 51.92           N  
ATOM   2590  N   GLY A 314      19.716   0.902  47.111  1.00 29.48           N  
ATOM   2591  CA  GLY A 314      18.273   0.996  46.924  1.00 26.93           C  
ATOM   2592  C   GLY A 314      17.627   2.345  47.199  1.00 31.58           C  
ATOM   2593  O   GLY A 314      18.283   3.380  47.179  1.00 25.04           O  
ATOM   2594  N   LYS A 315      16.312   2.345  47.387  1.00 31.66           N  
ATOM   2595  CA  LYS A 315      15.618   3.575  47.703  1.00 34.17           C  
ATOM   2596  C   LYS A 315      15.347   3.545  49.203  1.00 34.44           C  
ATOM   2597  O   LYS A 315      14.985   2.513  49.769  1.00 31.75           O  
ATOM   2598  CB  LYS A 315      14.317   3.743  46.914  1.00 33.90           C  
ATOM   2599  CG  LYS A 315      13.817   5.171  47.011  1.00 40.20           C  
ATOM   2600  CD  LYS A 315      12.372   5.378  46.630  1.00 56.06           C  
ATOM   2601  CE  LYS A 315      11.888   6.702  47.250  1.00 62.76           C  
ATOM   2602  NZ  LYS A 315      10.597   7.244  46.716  1.00 70.34           N  
ATOM   2603  N   LEU A 316      15.626   4.667  49.845  1.00 34.56           N  
ATOM   2604  CA  LEU A 316      15.412   4.828  51.267  1.00 31.86           C  
ATOM   2605  C   LEU A 316      14.120   5.611  51.415  1.00 35.10           C  
ATOM   2606  O   LEU A 316      14.010   6.735  50.951  1.00 30.89           O  
ATOM   2607  CB  LEU A 316      16.585   5.608  51.867  1.00 25.97           C  
ATOM   2608  CG  LEU A 316      16.946   5.420  53.336  1.00 26.66           C  
ATOM   2609  CD1 LEU A 316      17.401   3.999  53.629  1.00 18.86           C  
ATOM   2610  CD2 LEU A 316      18.048   6.360  53.641  1.00 18.67           C  
ATOM   2611  N   ASN A 317      13.096   4.976  51.965  1.00 39.18           N  
ATOM   2612  CA  ASN A 317      11.838   5.676  52.167  1.00 40.61           C  
ATOM   2613  C   ASN A 317      12.030   6.606  53.338  1.00 41.40           C  
ATOM   2614  O   ASN A 317      12.886   6.402  54.216  1.00 39.92           O  
ATOM   2615  CB  ASN A 317      10.652   4.727  52.387  1.00 45.07           C  
ATOM   2616  CG  ASN A 317      10.214   4.032  51.097  1.00 60.08           C  
ATOM   2617  OD1 ASN A 317       9.662   4.664  50.190  1.00 56.92           O  
ATOM   2618  ND2 ASN A 317      10.475   2.727  51.008  1.00 58.30           N  
ATOM   2619  N   PHE A 318      11.328   7.713  53.248  1.00 36.43           N  
ATOM   2620  CA  PHE A 318      11.390   8.724  54.263  1.00 34.14           C  
ATOM   2621  C   PHE A 318       9.970   9.183  54.529  1.00 29.16           C  
ATOM   2622  O   PHE A 318       9.086   8.930  53.705  1.00 28.50           O  
ATOM   2623  CB  PHE A 318      12.295   9.865  53.791  1.00 28.39           C  
ATOM   2624  CG  PHE A 318      11.898  10.469  52.457  1.00 28.78           C  
ATOM   2625  CD1 PHE A 318      11.067  11.611  52.401  1.00 30.41           C  
ATOM   2626  CD2 PHE A 318      12.370   9.925  51.255  1.00 28.08           C  
ATOM   2627  CE1 PHE A 318      10.716  12.200  51.165  1.00 24.60           C  
ATOM   2628  CE2 PHE A 318      12.021  10.510  50.017  1.00 34.50           C  
ATOM   2629  CZ  PHE A 318      11.189  11.649  49.984  1.00 26.53           C  
ATOM   2630  N   LYS A 319       9.766   9.866  55.655  1.00 28.56           N  
ATOM   2631  CA  LYS A 319       8.459  10.380  56.026  1.00 27.26           C  
ATOM   2632  C   LYS A 319       8.159  11.691  55.270  1.00 32.41           C  
ATOM   2633  O   LYS A 319       8.608  12.771  55.648  1.00 37.47           O  
ATOM   2634  CB  LYS A 319       8.392  10.581  57.528  1.00 24.18           C  
ATOM   2635  CG  LYS A 319       8.671   9.354  58.382  1.00 27.31           C  
ATOM   2636  CD  LYS A 319       7.588   8.268  58.259  1.00 40.73           C  
ATOM   2637  CE  LYS A 319       7.857   7.092  59.227  1.00 48.62           C  
ATOM   2638  NZ  LYS A 319       6.818   5.996  59.227  1.00 49.49           N  
ATOM   2639  N   ASP A 320       7.448  11.569  54.156  1.00 34.65           N  
ATOM   2640  CA  ASP A 320       7.106  12.714  53.307  1.00 33.07           C  
ATOM   2641  C   ASP A 320       5.749  13.342  53.567  1.00 31.98           C  
ATOM   2642  O   ASP A 320       5.389  14.344  52.942  1.00 30.12           O  
ATOM   2643  CB  ASP A 320       7.214  12.348  51.820  1.00 43.28           C  
ATOM   2644  CG  ASP A 320       6.828  10.901  51.523  1.00 47.41           C  
ATOM   2645  OD1 ASP A 320       6.085  10.272  52.322  1.00 53.52           O  
ATOM   2646  OD2 ASP A 320       7.299  10.390  50.482  1.00 53.82           O  
ATOM   2647  N   THR A 321       5.015  12.766  54.510  1.00 31.68           N  
ATOM   2648  CA  THR A 321       3.690  13.256  54.836  1.00 26.01           C  
ATOM   2649  C   THR A 321       3.741  14.556  55.598  1.00 32.51           C  
ATOM   2650  O   THR A 321       4.410  14.674  56.634  1.00 30.92           O  
ATOM   2651  CB  THR A 321       2.849  12.210  55.596  1.00 25.58           C  
ATOM   2652  OG1 THR A 321       2.776  11.008  54.808  1.00 26.62           O  
ATOM   2653  CG2 THR A 321       1.428  12.739  55.840  1.00 14.14           C  
ATOM   2654  N   VAL A 322       3.068  15.533  55.001  1.00 32.08           N  
ATOM   2655  CA  VAL A 322       2.929  16.873  55.534  1.00 32.59           C  
ATOM   2656  C   VAL A 322       1.463  17.174  55.884  1.00 29.25           C  
ATOM   2657  O   VAL A 322       0.548  16.547  55.351  1.00 30.43           O  
ATOM   2658  CB  VAL A 322       3.444  17.914  54.513  1.00 29.00           C  
ATOM   2659  CG1 VAL A 322       4.882  17.590  54.084  1.00 26.57           C  
ATOM   2660  CG2 VAL A 322       2.487  18.042  53.294  1.00 27.15           C  
ATOM   2661  N   LEU A 323       1.248  18.145  56.761  1.00 31.77           N  
ATOM   2662  CA  LEU A 323      -0.099  18.537  57.159  1.00 38.43           C  
ATOM   2663  C   LEU A 323      -0.259  20.032  57.409  1.00 36.64           C  
ATOM   2664  O   LEU A 323       0.706  20.703  57.750  1.00 32.28           O  
ATOM   2665  CB  LEU A 323      -0.580  17.721  58.375  1.00 33.28           C  
ATOM   2666  CG  LEU A 323       0.233  17.369  59.633  1.00 31.95           C  
ATOM   2667  CD1 LEU A 323       0.784  18.582  60.388  1.00 29.56           C  
ATOM   2668  CD2 LEU A 323      -0.675  16.546  60.546  1.00 33.12           C  
ATOM   2669  N   ASP A 324      -1.479  20.539  57.242  1.00 39.85           N  
ATOM   2670  CA  ASP A 324      -1.779  21.956  57.470  1.00 44.83           C  
ATOM   2671  C   ASP A 324      -2.278  22.247  58.911  1.00 49.44           C  
ATOM   2672  O   ASP A 324      -2.132  21.394  59.799  1.00 53.30           O  
ATOM   2673  CB  ASP A 324      -2.734  22.493  56.386  1.00 40.16           C  
ATOM   2674  CG  ASP A 324      -4.176  22.025  56.548  1.00 39.72           C  
ATOM   2675  OD1 ASP A 324      -4.456  20.962  57.143  1.00 39.41           O  
ATOM   2676  OD2 ASP A 324      -5.046  22.748  56.054  1.00 38.88           O  
ATOM   2677  N   ALA A 325      -2.810  23.457  59.144  1.00 47.59           N  
ATOM   2678  CA  ALA A 325      -3.299  23.878  60.465  1.00 48.50           C  
ATOM   2679  C   ALA A 325      -4.550  23.166  60.904  1.00 49.35           C  
ATOM   2680  O   ALA A 325      -4.835  23.099  62.102  1.00 51.84           O  
ATOM   2681  CB  ALA A 325      -3.511  25.350  60.507  1.00 52.32           C  
ATOM   2682  N   LYS A 326      -5.310  22.673  59.929  1.00 58.43           N  
ATOM   2683  CA  LYS A 326      -6.523  21.925  60.223  1.00 62.84           C  
ATOM   2684  C   LYS A 326      -6.163  20.436  60.389  1.00 60.68           C  
ATOM   2685  O   LYS A 326      -6.848  19.672  61.101  1.00 62.01           O  
ATOM   2686  CB  LYS A 326      -7.598  22.150  59.154  1.00 63.91           C  
ATOM   2687  CG  LYS A 326      -8.925  22.558  59.796  1.00 68.00           C  
ATOM   2688  CD  LYS A 326     -10.132  22.483  58.883  1.00 66.31           C  
ATOM   2689  CE  LYS A 326     -11.419  22.573  59.698  1.00 65.74           C  
ATOM   2690  NZ  LYS A 326     -12.597  22.448  58.806  1.00 66.40           N  
ATOM   2691  N   GLY A 327      -5.035  20.066  59.788  1.00 56.82           N  
ATOM   2692  CA  GLY A 327      -4.549  18.710  59.882  1.00 51.45           C  
ATOM   2693  C   GLY A 327      -4.836  17.832  58.694  1.00 51.46           C  
ATOM   2694  O   GLY A 327      -5.010  16.633  58.891  1.00 50.83           O  
ATOM   2695  N   LYS A 328      -4.895  18.397  57.485  1.00 49.16           N  
ATOM   2696  CA  LYS A 328      -5.135  17.594  56.279  1.00 54.54           C  
ATOM   2697  C   LYS A 328      -3.833  16.907  55.861  1.00 52.81           C  
ATOM   2698  O   LYS A 328      -2.814  17.558  55.709  1.00 45.94           O  
ATOM   2699  CB  LYS A 328      -5.714  18.444  55.137  1.00 62.92           C  
ATOM   2700  CG  LYS A 328      -7.254  18.476  55.087  1.00 74.07           C  
ATOM   2701  CD  LYS A 328      -7.788  19.462  54.038  1.00 73.46           C  
ATOM   2702  CE  LYS A 328      -9.290  19.752  54.250  1.00 88.84           C  
ATOM   2703  NZ  LYS A 328      -9.795  20.967  53.510  1.00 87.19           N  
ATOM   2704  N   ASN A 329      -3.878  15.582  55.734  1.00 52.91           N  
ATOM   2705  CA  ASN A 329      -2.706  14.790  55.386  1.00 55.05           C  
ATOM   2706  C   ASN A 329      -2.680  14.432  53.929  1.00 56.93           C  
ATOM   2707  O   ASN A 329      -3.723  14.134  53.350  1.00 62.66           O  
ATOM   2708  CB  ASN A 329      -2.685  13.446  56.138  1.00 56.41           C  
ATOM   2709  CG  ASN A 329      -3.317  13.508  57.520  1.00 66.61           C  
ATOM   2710  OD1 ASN A 329      -3.198  14.509  58.227  1.00 72.60           O  
ATOM   2711  ND2 ASN A 329      -3.973  12.414  57.922  1.00 70.58           N  
ATOM   2712  N   THR A 330      -1.487  14.498  53.340  1.00 62.75           N  
ATOM   2713  CA  THR A 330      -1.223  14.086  51.956  1.00 69.40           C  
ATOM   2714  C   THR A 330       0.275  13.976  51.776  1.00 70.90           C  
ATOM   2715  O   THR A 330       1.022  14.900  52.131  1.00 66.07           O  
ATOM   2716  CB  THR A 330      -1.739  15.026  50.834  1.00 66.35           C  
ATOM   2717  OG1 THR A 330      -3.004  15.589  51.181  1.00 73.76           O  
ATOM   2718  CG2 THR A 330      -1.960  14.200  49.578  1.00 67.29           C  
ATOM   2719  N   LYS A 331       0.700  12.836  51.217  1.00 74.70           N  
ATOM   2720  CA  LYS A 331       2.112  12.541  50.929  1.00 76.96           C  
ATOM   2721  C   LYS A 331       2.624  13.569  49.914  1.00 81.44           C  
ATOM   2722  O   LYS A 331       1.850  14.104  49.104  1.00 87.38           O  
ATOM   2723  CB  LYS A 331       2.301  11.116  50.346  1.00 77.15           C  
ATOM   2724  CG  LYS A 331       2.275   9.914  51.328  1.00 75.40           C  
ATOM   2725  CD  LYS A 331       2.443   8.576  50.549  1.00 79.33           C  
ATOM   2726  CE  LYS A 331       2.392   7.306  51.441  1.00 79.69           C  
ATOM   2727  NZ  LYS A 331       2.446   5.971  50.710  1.00 71.72           N  
ATOM   2728  N   VAL A 332       3.908  13.891  50.019  1.00 86.40           N  
ATOM   2729  CA  VAL A 332       4.554  14.850  49.126  1.00 89.32           C  
ATOM   2730  C   VAL A 332       5.455  14.152  48.091  1.00 94.18           C  
ATOM   2731  O   VAL A 332       6.454  13.500  48.428  1.00 94.66           O  
ATOM   2732  CB  VAL A 332       5.300  15.923  49.955  1.00 85.25           C  
ATOM   2733  CG1 VAL A 332       6.363  16.654  49.150  1.00 84.26           C  
ATOM   2734  CG2 VAL A 332       4.306  16.885  50.490  1.00 79.00           C  
ATOM   2735  N   ILE A 333       5.009  14.204  46.835  1.00 95.45           N  
ATOM   2736  CA  ILE A 333       5.732  13.619  45.700  1.00103.78           C  
ATOM   2737  C   ILE A 333       5.972  14.755  44.662  1.00110.59           C  
ATOM   2738  O   ILE A 333       6.925  14.691  43.876  1.00111.70           O  
ATOM   2739  CB  ILE A 333       4.971  12.375  45.103  1.00102.96           C  
ATOM   2740  CG1 ILE A 333       4.777  11.300  46.190  1.00 99.40           C  
ATOM   2741  CG2 ILE A 333       5.789  11.722  43.973  1.00102.58           C  
ATOM   2742  CD1 ILE A 333       3.433  10.605  46.166  1.00 97.93           C  
ATOM   2743  N   THR A 334       5.103  15.782  44.699  1.00113.53           N  
ATOM   2744  CA  THR A 334       5.131  17.021  43.868  1.00110.29           C  
ATOM   2745  C   THR A 334       4.211  18.067  44.582  1.00108.78           C  
ATOM   2746  O   THR A 334       4.060  19.202  44.101  1.00109.47           O  
ATOM   2747  CB  THR A 334       4.630  16.771  42.346  1.00115.22           C  
ATOM   2748  OG1 THR A 334       5.369  15.699  41.735  1.00115.99           O  
ATOM   2749  CG2 THR A 334       4.870  18.010  41.444  1.00111.79           C  
ATOM   2750  N   ASN A 335       3.734  17.704  45.793  1.00108.06           N  
ATOM   2751  CA  ASN A 335       2.786  18.450  46.684  1.00101.41           C  
ATOM   2752  C   ASN A 335       1.604  18.908  45.866  1.00 96.40           C  
ATOM   2753  O   ASN A 335       1.699  19.894  45.120  1.00 95.14           O  
ATOM   2754  CB  ASN A 335       3.328  19.704  47.412  1.00108.96           C  
ATOM   2755  CG  ASN A 335       4.628  19.475  48.159  1.00109.91           C  
ATOM   2756  OD1 ASN A 335       5.636  19.075  47.583  1.00114.54           O  
ATOM   2757  ND2 ASN A 335       4.636  19.829  49.433  1.00108.69           N  
ATOM   2758  N   LEU A 336       0.481  18.230  46.053  1.00 90.48           N  
ATOM   2759  CA  LEU A 336      -0.714  18.533  45.300  1.00 84.85           C  
ATOM   2760  C   LEU A 336      -1.043  20.011  45.234  1.00 83.65           C  
ATOM   2761  O   LEU A 336      -0.765  20.777  46.174  1.00 83.57           O  
ATOM   2762  CB  LEU A 336      -1.916  17.792  45.878  1.00 77.88           C  
ATOM   2763  CG  LEU A 336      -1.890  16.321  46.270  1.00 81.44           C  
ATOM   2764  CD1 LEU A 336      -3.341  15.905  46.535  1.00 75.07           C  
ATOM   2765  CD2 LEU A 336      -1.259  15.439  45.195  1.00 76.06           C  
ATOM   2766  N   ARG A 337      -1.516  20.420  44.059  1.00 82.41           N  
ATOM   2767  CA  ARG A 337      -1.969  21.784  43.860  1.00 79.96           C  
ATOM   2768  C   ARG A 337      -3.229  21.821  44.711  1.00 76.18           C  
ATOM   2769  O   ARG A 337      -3.522  22.820  45.358  1.00 71.15           O  
ATOM   2770  CB  ARG A 337      -2.363  22.025  42.404  1.00 85.43           C  
ATOM   2771  CG  ARG A 337      -1.230  22.342  41.466  1.00 96.47           C  
ATOM   2772  CD  ARG A 337      -0.733  21.090  40.774  1.00101.24           C  
ATOM   2773  NE  ARG A 337       0.459  21.369  39.983  1.00107.93           N  
ATOM   2774  CZ  ARG A 337       0.529  21.371  38.652  1.00107.00           C  
ATOM   2775  NH1 ARG A 337      -0.550  21.095  37.929  1.00108.81           N  
ATOM   2776  NH2 ARG A 337       1.656  21.698  38.061  1.00110.11           N  
ATOM   2777  N   LYS A 338      -3.910  20.667  44.730  1.00 65.13           N  
ATOM   2778  CA  LYS A 338      -5.139  20.427  45.473  1.00 59.73           C  
ATOM   2779  C   LYS A 338      -4.920  20.697  46.940  1.00 54.97           C  
ATOM   2780  O   LYS A 338      -5.691  21.464  47.544  1.00 49.99           O  
ATOM   2781  CB  LYS A 338      -5.597  18.976  45.319  1.00 64.93           C  
ATOM   2782  CG  LYS A 338      -6.364  18.628  44.031  1.00 73.60           C  
ATOM   2783  CD  LYS A 338      -6.656  17.103  43.982  1.00 81.11           C  
ATOM   2784  CE  LYS A 338      -7.588  16.691  42.840  1.00 84.10           C  
ATOM   2785  NZ  LYS A 338      -7.662  15.201  42.698  1.00 85.56           N  
ATOM   2786  N   PHE A 339      -3.837  20.123  47.484  1.00 45.76           N  
ATOM   2787  CA  PHE A 339      -3.496  20.315  48.893  1.00 34.62           C  
ATOM   2788  C   PHE A 339      -3.239  21.799  49.160  1.00 33.80           C  
ATOM   2789  O   PHE A 339      -3.836  22.379  50.055  1.00 33.58           O  
ATOM   2790  CB  PHE A 339      -2.299  19.436  49.328  1.00 31.86           C  
ATOM   2791  CG  PHE A 339      -1.872  19.641  50.776  1.00 32.41           C  
ATOM   2792  CD1 PHE A 339      -2.760  19.384  51.835  1.00 31.95           C  
ATOM   2793  CD2 PHE A 339      -0.624  20.224  51.078  1.00 27.66           C  
ATOM   2794  CE1 PHE A 339      -2.410  19.726  53.181  1.00 32.60           C  
ATOM   2795  CE2 PHE A 339      -0.269  20.566  52.419  1.00 25.47           C  
ATOM   2796  CZ  PHE A 339      -1.161  20.323  53.465  1.00 23.44           C  
ATOM   2797  N   LEU A 340      -2.486  22.437  48.276  1.00 33.59           N  
ATOM   2798  CA  LEU A 340      -2.169  23.846  48.449  1.00 32.44           C  
ATOM   2799  C   LEU A 340      -3.323  24.797  48.174  1.00 36.01           C  
ATOM   2800  O   LEU A 340      -3.209  25.990  48.444  1.00 34.53           O  
ATOM   2801  CB  LEU A 340      -0.963  24.225  47.597  1.00 34.94           C  
ATOM   2802  CG  LEU A 340       0.413  23.763  48.083  1.00 36.09           C  
ATOM   2803  CD1 LEU A 340       1.399  23.903  46.922  1.00 43.03           C  
ATOM   2804  CD2 LEU A 340       0.874  24.534  49.342  1.00 32.17           C  
ATOM   2805  N   GLU A 341      -4.416  24.276  47.617  1.00 32.02           N  
ATOM   2806  CA  GLU A 341      -5.581  25.098  47.329  1.00 32.59           C  
ATOM   2807  C   GLU A 341      -6.405  25.134  48.579  1.00 34.73           C  
ATOM   2808  O   GLU A 341      -6.718  26.201  49.093  1.00 30.65           O  
ATOM   2809  CB  GLU A 341      -6.415  24.521  46.175  1.00 40.37           C  
ATOM   2810  CG  GLU A 341      -6.029  25.008  44.760  1.00 47.58           C  
ATOM   2811  CD  GLU A 341      -6.784  24.306  43.606  1.00 49.91           C  
ATOM   2812  OE1 GLU A 341      -8.039  24.383  43.553  1.00 52.04           O  
ATOM   2813  OE2 GLU A 341      -6.108  23.698  42.738  1.00 43.79           O  
ATOM   2814  N   LEU A 342      -6.585  23.943  49.138  1.00 38.25           N  
ATOM   2815  CA  LEU A 342      -7.390  23.708  50.330  1.00 44.75           C  
ATOM   2816  C   LEU A 342      -6.753  23.909  51.706  1.00 45.77           C  
ATOM   2817  O   LEU A 342      -7.474  24.047  52.700  1.00 40.75           O  
ATOM   2818  CB  LEU A 342      -7.981  22.297  50.241  1.00 51.72           C  
ATOM   2819  CG  LEU A 342      -9.125  22.075  49.241  1.00 55.39           C  
ATOM   2820  CD1 LEU A 342      -9.249  20.592  48.852  1.00 56.52           C  
ATOM   2821  CD2 LEU A 342     -10.427  22.578  49.861  1.00 58.41           C  
ATOM   2822  N   CYS A 343      -5.420  23.936  51.758  1.00 42.63           N  
ATOM   2823  CA  CYS A 343      -4.667  24.082  53.013  1.00 44.46           C  
ATOM   2824  C   CYS A 343      -4.782  25.401  53.801  1.00 49.63           C  
ATOM   2825  O   CYS A 343      -4.737  26.498  53.238  1.00 54.50           O  
ATOM   2826  CB  CYS A 343      -3.182  23.778  52.792  1.00 44.22           C  
ATOM   2827  SG  CYS A 343      -2.266  25.173  52.119  1.00 33.15           S  
ATOM   2828  N   ARG A 344      -4.886  25.261  55.122  1.00 50.96           N  
ATOM   2829  CA  ARG A 344      -4.963  26.381  56.057  1.00 53.10           C  
ATOM   2830  C   ARG A 344      -3.549  26.477  56.688  1.00 53.82           C  
ATOM   2831  O   ARG A 344      -3.108  25.537  57.347  1.00 58.94           O  
ATOM   2832  CB  ARG A 344      -6.038  26.078  57.114  1.00 52.32           C  
ATOM   2833  CG  ARG A 344      -6.246  27.063  58.264  1.00 54.29           C  
ATOM   2834  CD  ARG A 344      -7.171  26.349  59.231  1.00 70.42           C  
ATOM   2835  NE  ARG A 344      -7.457  27.029  60.494  1.00 77.97           N  
ATOM   2836  CZ  ARG A 344      -7.963  26.428  61.579  1.00 83.62           C  
ATOM   2837  NH1 ARG A 344      -8.235  25.128  61.578  1.00 82.31           N  
ATOM   2838  NH2 ARG A 344      -8.253  27.141  62.658  1.00 83.85           N  
ATOM   2839  N   PRO A 345      -2.815  27.586  56.457  1.00 49.07           N  
ATOM   2840  CA  PRO A 345      -1.454  27.774  57.007  1.00 50.13           C  
ATOM   2841  C   PRO A 345      -1.350  27.923  58.542  1.00 49.67           C  
ATOM   2842  O   PRO A 345      -2.347  27.971  59.243  1.00 54.16           O  
ATOM   2843  CB  PRO A 345      -0.993  29.059  56.314  1.00 52.99           C  
ATOM   2844  CG  PRO A 345      -1.820  29.094  55.075  1.00 47.44           C  
ATOM   2845  CD  PRO A 345      -3.152  28.699  55.553  1.00 39.69           C  
ATOM   2846  N   PHE A 346      -0.127  27.960  59.058  1.00 45.10           N  
ATOM   2847  CA  PHE A 346       0.090  28.162  60.480  1.00 44.67           C  
ATOM   2848  C   PHE A 346       0.454  29.622  60.561  1.00 46.48           C  
ATOM   2849  O   PHE A 346       1.597  29.998  60.345  1.00 48.22           O  
ATOM   2850  CB  PHE A 346       1.246  27.306  60.992  1.00 44.15           C  
ATOM   2851  CG  PHE A 346       0.957  25.845  60.989  1.00 41.00           C  
ATOM   2852  CD1 PHE A 346       1.208  25.079  59.847  1.00 45.29           C  
ATOM   2853  CD2 PHE A 346       0.436  25.221  62.137  1.00 45.71           C  
ATOM   2854  CE1 PHE A 346       0.947  23.703  59.849  1.00 45.26           C  
ATOM   2855  CE2 PHE A 346       0.168  23.850  62.161  1.00 43.61           C  
ATOM   2856  CZ  PHE A 346       0.420  23.084  61.018  1.00 48.53           C  
ATOM   2857  N   VAL A 347      -0.539  30.445  60.840  1.00 52.15           N  
ATOM   2858  CA  VAL A 347      -0.357  31.892  60.911  1.00 54.53           C  
ATOM   2859  C   VAL A 347       0.550  32.498  61.998  1.00 52.60           C  
ATOM   2860  O   VAL A 347       0.342  32.289  63.191  1.00 54.29           O  
ATOM   2861  CB  VAL A 347      -1.735  32.607  60.897  1.00 55.70           C  
ATOM   2862  CG1 VAL A 347      -2.411  32.368  59.555  1.00 57.98           C  
ATOM   2863  CG2 VAL A 347      -2.634  32.095  62.045  1.00 58.96           C  
ATOM   2864  N   LYS A 348       1.577  33.218  61.559  1.00 51.33           N  
ATOM   2865  CA  LYS A 348       2.501  33.886  62.465  1.00 52.70           C  
ATOM   2866  C   LYS A 348       2.201  35.383  62.457  1.00 53.32           C  
ATOM   2867  O   LYS A 348       2.421  36.070  63.459  1.00 59.82           O  
ATOM   2868  CB  LYS A 348       3.954  33.625  62.073  1.00 62.75           C  
ATOM   2869  CG  LYS A 348       4.981  34.125  63.105  1.00 60.34           C  
ATOM   2870  CD  LYS A 348       6.404  33.676  62.791  1.00 60.62           C  
ATOM   2871  CE  LYS A 348       6.598  32.189  63.036  1.00 68.18           C  
ATOM   2872  NZ  LYS A 348       7.997  31.777  62.789  1.00 66.86           N  
ATOM   2873  N   LYS A 349       1.717  35.883  61.319  1.00 53.19           N  
ATOM   2874  CA  LYS A 349       1.356  37.291  61.177  1.00 48.49           C  
ATOM   2875  C   LYS A 349       0.118  37.404  60.281  1.00 48.46           C  
ATOM   2876  O   LYS A 349       0.209  37.289  59.055  1.00 43.53           O  
ATOM   2877  CB  LYS A 349       2.537  38.118  60.644  1.00 46.01           C  
ATOM   2878  CG  LYS A 349       2.453  39.580  61.073  1.00 43.62           C  
ATOM   2879  CD  LYS A 349       3.616  40.415  60.610  1.00 38.01           C  
ATOM   2880  CE  LYS A 349       3.370  41.871  60.967  1.00 37.84           C  
ATOM   2881  NZ  LYS A 349       4.542  42.747  60.639  1.00 35.21           N  
ATOM   2882  N   ASP A 350      -1.041  37.599  60.924  1.00 49.38           N  
ATOM   2883  CA  ASP A 350      -2.339  37.713  60.245  1.00 50.54           C  
ATOM   2884  C   ASP A 350      -2.461  38.836  59.210  1.00 45.61           C  
ATOM   2885  O   ASP A 350      -3.122  38.658  58.193  1.00 43.57           O  
ATOM   2886  CB  ASP A 350      -3.544  37.698  61.240  1.00 57.99           C  
ATOM   2887  CG  ASP A 350      -3.273  38.425  62.584  1.00 64.45           C  
ATOM   2888  OD1 ASP A 350      -2.716  39.550  62.578  1.00 69.51           O  
ATOM   2889  OD2 ASP A 350      -3.660  37.878  63.654  1.00 67.02           O  
ATOM   2890  N   VAL A 351      -1.740  39.936  59.440  1.00 45.53           N  
ATOM   2891  CA  VAL A 351      -1.710  41.119  58.566  1.00 43.94           C  
ATOM   2892  C   VAL A 351      -0.270  41.412  58.138  1.00 44.71           C  
ATOM   2893  O   VAL A 351       0.620  41.473  58.989  1.00 49.41           O  
ATOM   2894  CB  VAL A 351      -2.274  42.345  59.339  1.00 50.62           C  
ATOM   2895  CG1 VAL A 351      -1.856  43.693  58.716  1.00 47.98           C  
ATOM   2896  CG2 VAL A 351      -3.777  42.249  59.394  1.00 57.89           C  
ATOM   2897  N   LEU A 352      -0.052  41.692  56.853  1.00 41.08           N  
ATOM   2898  CA  LEU A 352       1.307  41.977  56.332  1.00 47.78           C  
ATOM   2899  C   LEU A 352       1.541  43.307  55.572  1.00 42.53           C  
ATOM   2900  O   LEU A 352       0.649  43.799  54.877  1.00 40.94           O  
ATOM   2901  CB  LEU A 352       1.753  40.826  55.428  1.00 39.51           C  
ATOM   2902  CG  LEU A 352       2.638  39.670  55.869  1.00 34.98           C  
ATOM   2903  CD1 LEU A 352       2.280  39.087  57.186  1.00 30.05           C  
ATOM   2904  CD2 LEU A 352       2.479  38.645  54.819  1.00 37.79           C  
ATOM   2905  N   SER A 353       2.752  43.861  55.688  1.00 41.07           N  
ATOM   2906  CA  SER A 353       3.124  45.104  54.999  1.00 40.83           C  
ATOM   2907  C   SER A 353       4.066  44.746  53.851  1.00 39.47           C  
ATOM   2908  O   SER A 353       5.172  44.256  54.083  1.00 44.37           O  
ATOM   2909  CB  SER A 353       3.762  46.118  55.966  1.00 41.39           C  
ATOM   2910  OG  SER A 353       4.852  45.560  56.678  1.00 49.94           O  
ATOM   2911  N   VAL A 354       3.582  44.936  52.619  1.00 39.27           N  
ATOM   2912  CA  VAL A 354       4.306  44.595  51.385  1.00 32.95           C  
ATOM   2913  C   VAL A 354       4.647  45.791  50.497  1.00 27.39           C  
ATOM   2914  O   VAL A 354       3.846  46.712  50.388  1.00 28.15           O  
ATOM   2915  CB  VAL A 354       3.426  43.606  50.525  1.00 24.04           C  
ATOM   2916  CG1 VAL A 354       4.120  43.180  49.233  1.00 28.21           C  
ATOM   2917  CG2 VAL A 354       3.084  42.374  51.332  1.00 30.12           C  
ATOM   2918  N   GLU A 355       5.849  45.787  49.919  1.00 25.42           N  
ATOM   2919  CA  GLU A 355       6.272  46.796  48.929  1.00 27.67           C  
ATOM   2920  C   GLU A 355       6.284  46.053  47.567  1.00 24.15           C  
ATOM   2921  O   GLU A 355       6.543  44.840  47.518  1.00 29.93           O  
ATOM   2922  CB  GLU A 355       7.676  47.352  49.227  1.00 36.37           C  
ATOM   2923  CG  GLU A 355       7.711  48.716  49.970  1.00 43.43           C  
ATOM   2924  CD  GLU A 355       8.149  49.907  49.119  1.00 45.94           C  
ATOM   2925  OE1 GLU A 355       9.184  49.833  48.420  1.00 51.11           O  
ATOM   2926  OE2 GLU A 355       7.462  50.944  49.179  1.00 42.63           O  
ATOM   2927  N   ILE A 356       5.936  46.740  46.480  1.00 18.46           N  
ATOM   2928  CA  ILE A 356       5.916  46.121  45.148  1.00 19.43           C  
ATOM   2929  C   ILE A 356       6.806  46.857  44.181  1.00 15.90           C  
ATOM   2930  O   ILE A 356       7.036  48.067  44.351  1.00 20.05           O  
ATOM   2931  CB  ILE A 356       4.472  46.074  44.559  1.00 14.43           C  
ATOM   2932  CG1 ILE A 356       3.602  45.141  45.382  1.00 20.99           C  
ATOM   2933  CG2 ILE A 356       4.458  45.537  43.156  1.00 16.85           C  
ATOM   2934  CD1 ILE A 356       2.218  45.568  45.440  1.00 21.30           C  
ATOM   2935  N   ILE A 357       7.373  46.122  43.221  1.00  7.49           N  
ATOM   2936  CA  ILE A 357       8.224  46.725  42.197  1.00 16.78           C  
ATOM   2937  C   ILE A 357       7.944  46.105  40.855  1.00 18.49           C  
ATOM   2938  O   ILE A 357       7.852  44.893  40.742  1.00 21.55           O  
ATOM   2939  CB  ILE A 357       9.802  46.588  42.448  1.00 14.06           C  
ATOM   2940  CG1 ILE A 357      10.229  47.289  43.717  1.00  9.85           C  
ATOM   2941  CG2 ILE A 357      10.663  47.186  41.283  1.00 13.26           C  
ATOM   2942  CD1 ILE A 357      10.247  46.377  44.832  1.00 17.20           C  
ATOM   2943  N   SER A 358       7.861  46.946  39.832  1.00 22.83           N  
ATOM   2944  CA  SER A 358       7.663  46.462  38.500  1.00 28.37           C  
ATOM   2945  C   SER A 358       8.674  47.103  37.610  1.00 29.33           C  
ATOM   2946  O   SER A 358       8.978  48.277  37.709  1.00 31.97           O  
ATOM   2947  CB  SER A 358       6.276  46.759  37.996  1.00 24.62           C  
ATOM   2948  OG  SER A 358       6.090  48.144  38.087  1.00 44.86           O  
ATOM   2949  N   VAL A 359       9.224  46.240  36.790  1.00 33.33           N  
ATOM   2950  CA  VAL A 359      10.229  46.521  35.802  1.00 41.87           C  
ATOM   2951  C   VAL A 359       9.445  46.273  34.512  1.00 45.24           C  
ATOM   2952  O   VAL A 359       9.086  45.123  34.184  1.00 41.27           O  
ATOM   2953  CB  VAL A 359      11.340  45.528  36.043  1.00 41.33           C  
ATOM   2954  CG1 VAL A 359      12.064  45.137  34.778  1.00 40.61           C  
ATOM   2955  CG2 VAL A 359      12.244  46.064  37.120  1.00 40.06           C  
ATOM   2956  N   SER A 360       9.152  47.362  33.807  1.00 54.44           N  
ATOM   2957  CA  SER A 360       8.343  47.272  32.598  1.00 60.59           C  
ATOM   2958  C   SER A 360       8.982  47.885  31.362  1.00 67.73           C  
ATOM   2959  O   SER A 360      10.036  48.522  31.446  1.00 69.00           O  
ATOM   2960  CB  SER A 360       6.975  47.936  32.831  1.00 59.96           C  
ATOM   2961  OG  SER A 360       6.640  48.031  34.212  1.00 59.27           O  
ATOM   2962  N   VAL A 361       8.309  47.680  30.223  1.00 70.18           N  
ATOM   2963  CA  VAL A 361       8.718  48.192  28.904  1.00 76.50           C  
ATOM   2964  C   VAL A 361       7.609  49.107  28.301  1.00 81.49           C  
ATOM   2965  O   VAL A 361       7.736  50.347  28.230  1.00 76.98           O  
ATOM   2966  CB  VAL A 361       9.074  47.004  27.920  1.00 78.40           C  
ATOM   2967  CG1 VAL A 361       9.183  47.480  26.449  1.00 78.32           C  
ATOM   2968  CG2 VAL A 361      10.405  46.371  28.330  1.00 77.18           C  
ATOM   2969  N   TRP A 367      -1.460  45.162  32.647  1.00 91.27           N  
ATOM   2970  CA  TRP A 367      -2.591  45.084  33.563  1.00 95.23           C  
ATOM   2971  C   TRP A 367      -2.829  43.612  33.841  1.00 93.69           C  
ATOM   2972  O   TRP A 367      -3.908  43.179  34.267  1.00 95.69           O  
ATOM   2973  CB  TRP A 367      -3.770  45.832  32.947  1.00 94.95           C  
ATOM   2974  CG  TRP A 367      -3.300  47.233  32.642  1.00101.14           C  
ATOM   2975  CD1 TRP A 367      -2.617  47.637  31.517  1.00100.87           C  
ATOM   2976  CD2 TRP A 367      -3.237  48.339  33.565  1.00101.17           C  
ATOM   2977  NE1 TRP A 367      -2.104  48.904  31.704  1.00101.83           N  
ATOM   2978  CE2 TRP A 367      -2.467  49.363  32.943  1.00 98.31           C  
ATOM   2979  CE3 TRP A 367      -3.747  48.572  34.865  1.00 97.42           C  
ATOM   2980  CZ2 TRP A 367      -2.191  50.602  33.585  1.00101.21           C  
ATOM   2981  CZ3 TRP A 367      -3.470  49.819  35.505  1.00 92.90           C  
ATOM   2982  CH2 TRP A 367      -2.699  50.809  34.856  1.00 93.38           C  
ATOM   2983  N   ARG A 368      -1.729  42.878  33.646  1.00 89.52           N  
ATOM   2984  CA  ARG A 368      -1.596  41.439  33.842  1.00 88.92           C  
ATOM   2985  C   ARG A 368      -1.034  41.208  35.222  1.00 81.35           C  
ATOM   2986  O   ARG A 368      -1.486  40.319  35.941  1.00 85.02           O  
ATOM   2987  CB  ARG A 368      -0.575  40.857  32.871  1.00 94.06           C  
ATOM   2988  CG  ARG A 368      -1.070  40.600  31.486  1.00102.89           C  
ATOM   2989  CD  ARG A 368      -0.446  39.309  30.994  1.00103.91           C  
ATOM   2990  NE  ARG A 368      -0.529  39.174  29.544  1.00 98.74           N  
ATOM   2991  CZ  ARG A 368       0.517  38.970  28.757  1.00104.25           C  
ATOM   2992  NH1 ARG A 368       1.720  38.871  29.288  1.00101.42           N  
ATOM   2993  NH2 ARG A 368       0.358  38.905  27.443  1.00105.69           N  
ATOM   2994  N   LYS A 369      -0.006  41.995  35.551  1.00 73.97           N  
ATOM   2995  CA  LYS A 369       0.684  41.935  36.831  1.00 66.56           C  
ATOM   2996  C   LYS A 369      -0.301  42.310  37.920  1.00 59.65           C  
ATOM   2997  O   LYS A 369      -0.429  41.614  38.919  1.00 54.31           O  
ATOM   2998  CB  LYS A 369       1.879  42.906  36.851  1.00 68.61           C  
ATOM   2999  CG  LYS A 369       2.931  42.707  35.737  1.00 74.67           C  
ATOM   3000  CD  LYS A 369       4.022  43.785  35.827  1.00 79.69           C  
ATOM   3001  CE  LYS A 369       4.765  43.991  34.519  1.00 76.66           C  
ATOM   3002  NZ  LYS A 369       6.005  44.812  34.662  1.00 75.18           N  
ATOM   3003  N   GLU A 370      -1.083  43.336  37.622  1.00 54.34           N  
ATOM   3004  CA  GLU A 370      -2.099  43.878  38.507  1.00 56.38           C  
ATOM   3005  C   GLU A 370      -3.222  42.899  38.785  1.00 50.08           C  
ATOM   3006  O   GLU A 370      -3.641  42.723  39.927  1.00 47.60           O  
ATOM   3007  CB  GLU A 370      -2.699  45.125  37.877  1.00 66.33           C  
ATOM   3008  CG  GLU A 370      -1.693  46.194  37.529  1.00 75.04           C  
ATOM   3009  CD  GLU A 370      -2.045  47.554  38.108  1.00 78.42           C  
ATOM   3010  OE1 GLU A 370      -2.863  47.639  39.074  1.00 76.49           O  
ATOM   3011  OE2 GLU A 370      -1.487  48.540  37.575  1.00 78.73           O  
ATOM   3012  N   GLU A 371      -3.717  42.286  37.714  1.00 51.21           N  
ATOM   3013  CA  GLU A 371      -4.797  41.299  37.772  1.00 46.47           C  
ATOM   3014  C   GLU A 371      -4.360  40.112  38.646  1.00 46.37           C  
ATOM   3015  O   GLU A 371      -5.127  39.630  39.491  1.00 48.41           O  
ATOM   3016  CB  GLU A 371      -5.105  40.796  36.363  1.00 44.28           C  
ATOM   3017  CG  GLU A 371      -6.477  41.131  35.813  1.00 48.22           C  
ATOM   3018  CD  GLU A 371      -6.747  40.405  34.497  1.00 47.03           C  
ATOM   3019  OE1 GLU A 371      -6.314  39.238  34.356  1.00 58.54           O  
ATOM   3020  OE2 GLU A 371      -7.374  40.993  33.594  1.00 42.17           O  
ATOM   3021  N   PHE A 372      -3.086  39.735  38.486  1.00 38.41           N  
ATOM   3022  CA  PHE A 372      -2.431  38.635  39.193  1.00 28.08           C  
ATOM   3023  C   PHE A 372      -2.186  38.939  40.665  1.00 25.16           C  
ATOM   3024  O   PHE A 372      -2.442  38.105  41.532  1.00 25.12           O  
ATOM   3025  CB  PHE A 372      -1.113  38.327  38.498  1.00 26.78           C  
ATOM   3026  CG  PHE A 372      -0.410  37.135  39.038  1.00 29.76           C  
ATOM   3027  CD1 PHE A 372      -0.916  35.847  38.812  1.00 26.35           C  
ATOM   3028  CD2 PHE A 372       0.776  37.298  39.768  1.00 29.77           C  
ATOM   3029  CE1 PHE A 372      -0.257  34.723  39.304  1.00 29.42           C  
ATOM   3030  CE2 PHE A 372       1.455  36.197  40.269  1.00 27.92           C  
ATOM   3031  CZ  PHE A 372       0.940  34.893  40.040  1.00 36.71           C  
ATOM   3032  N   LEU A 373      -1.669  40.131  40.931  1.00 18.53           N  
ATOM   3033  CA  LEU A 373      -1.401  40.585  42.283  1.00 22.66           C  
ATOM   3034  C   LEU A 373      -2.685  40.586  43.079  1.00 20.71           C  
ATOM   3035  O   LEU A 373      -2.698  40.203  44.238  1.00 25.83           O  
ATOM   3036  CB  LEU A 373      -0.817  41.991  42.264  1.00 20.14           C  
ATOM   3037  CG  LEU A 373      -0.415  42.595  43.608  1.00 19.59           C  
ATOM   3038  CD1 LEU A 373       1.028  42.313  43.907  1.00 29.07           C  
ATOM   3039  CD2 LEU A 373      -0.637  44.076  43.546  1.00 31.94           C  
ATOM   3040  N   LYS A 374      -3.771  40.946  42.411  1.00 24.23           N  
ATOM   3041  CA  LYS A 374      -5.082  40.995  43.029  1.00 27.08           C  
ATOM   3042  C   LYS A 374      -5.592  39.599  43.344  1.00 24.48           C  
ATOM   3043  O   LYS A 374      -6.084  39.366  44.445  1.00 23.43           O  
ATOM   3044  CB  LYS A 374      -6.054  41.795  42.153  1.00 33.21           C  
ATOM   3045  CG  LYS A 374      -5.772  43.298  42.221  1.00 34.52           C  
ATOM   3046  CD  LYS A 374      -6.608  44.166  41.321  1.00 35.10           C  
ATOM   3047  CE  LYS A 374      -6.148  45.609  41.537  1.00 50.01           C  
ATOM   3048  NZ  LYS A 374      -6.802  46.686  40.709  1.00 55.46           N  
ATOM   3049  N   GLU A 375      -5.348  38.651  42.432  1.00 31.34           N  
ATOM   3050  CA  GLU A 375      -5.770  37.253  42.618  1.00 34.55           C  
ATOM   3051  C   GLU A 375      -4.992  36.570  43.734  1.00 37.71           C  
ATOM   3052  O   GLU A 375      -5.549  35.737  44.466  1.00 36.45           O  
ATOM   3053  CB  GLU A 375      -5.667  36.459  41.322  1.00 38.77           C  
ATOM   3054  CG  GLU A 375      -6.842  36.692  40.394  1.00 54.32           C  
ATOM   3055  CD  GLU A 375      -6.702  36.031  39.025  1.00 64.49           C  
ATOM   3056  OE1 GLU A 375      -5.761  35.225  38.790  1.00 61.96           O  
ATOM   3057  OE2 GLU A 375      -7.566  36.337  38.169  1.00 71.71           O  
ATOM   3058  N   LEU A 376      -3.722  36.971  43.862  1.00 37.05           N  
ATOM   3059  CA  LEU A 376      -2.796  36.508  44.906  1.00 37.52           C  
ATOM   3060  C   LEU A 376      -3.339  36.931  46.251  1.00 38.25           C  
ATOM   3061  O   LEU A 376      -3.677  36.078  47.076  1.00 34.32           O  
ATOM   3062  CB  LEU A 376      -1.443  37.180  44.746  1.00 40.80           C  
ATOM   3063  CG  LEU A 376      -0.368  36.442  44.007  1.00 48.85           C  
ATOM   3064  CD1 LEU A 376      -0.950  35.748  42.823  1.00 57.47           C  
ATOM   3065  CD2 LEU A 376       0.696  37.443  43.591  1.00 55.91           C  
ATOM   3066  N   ILE A 377      -3.466  38.259  46.401  1.00 32.09           N  
ATOM   3067  CA  ILE A 377      -3.992  38.918  47.584  1.00 30.00           C  
ATOM   3068  C   ILE A 377      -5.294  38.231  48.003  1.00 31.61           C  
ATOM   3069  O   ILE A 377      -5.471  37.926  49.190  1.00 36.51           O  
ATOM   3070  CB  ILE A 377      -4.219  40.455  47.323  1.00 25.89           C  
ATOM   3071  CG1 ILE A 377      -2.891  41.189  47.342  1.00 16.60           C  
ATOM   3072  CG2 ILE A 377      -5.150  41.094  48.362  1.00 17.94           C  
ATOM   3073  CD1 ILE A 377      -3.011  42.608  46.887  1.00 20.06           C  
ATOM   3074  N   ASN A 378      -6.127  37.868  47.023  1.00 36.40           N  
ATOM   3075  CA  ASN A 378      -7.373  37.217  47.366  1.00 39.72           C  
ATOM   3076  C   ASN A 378      -7.218  35.779  47.795  1.00 36.91           C  
ATOM   3077  O   ASN A 378      -7.828  35.377  48.789  1.00 34.38           O  
ATOM   3078  CB  ASN A 378      -8.449  37.373  46.299  1.00 40.39           C  
ATOM   3079  CG  ASN A 378      -9.830  37.488  46.917  1.00 45.73           C  
ATOM   3080  OD1 ASN A 378     -10.200  38.540  47.448  1.00 55.84           O  
ATOM   3081  ND2 ASN A 378     -10.564  36.383  46.934  1.00 48.55           N  
ATOM   3082  N   PHE A 379      -6.316  35.052  47.136  1.00 34.26           N  
ATOM   3083  CA  PHE A 379      -6.073  33.655  47.477  1.00 34.28           C  
ATOM   3084  C   PHE A 379      -5.614  33.515  48.936  1.00 35.85           C  
ATOM   3085  O   PHE A 379      -6.149  32.689  49.696  1.00 38.82           O  
ATOM   3086  CB  PHE A 379      -5.028  33.043  46.543  1.00 29.72           C  
ATOM   3087  CG  PHE A 379      -5.074  31.552  46.503  1.00 26.10           C  
ATOM   3088  CD1 PHE A 379      -6.193  30.890  45.950  1.00 30.31           C  
ATOM   3089  CD2 PHE A 379      -4.023  30.788  47.024  1.00 25.54           C  
ATOM   3090  CE1 PHE A 379      -6.271  29.466  45.911  1.00 32.61           C  
ATOM   3091  CE2 PHE A 379      -4.080  29.377  46.999  1.00 30.16           C  
ATOM   3092  CZ  PHE A 379      -5.215  28.713  46.436  1.00 30.82           C  
ATOM   3093  N   LEU A 380      -4.721  34.423  49.336  1.00 36.09           N  
ATOM   3094  CA  LEU A 380      -4.147  34.458  50.682  1.00 35.92           C  
ATOM   3095  C   LEU A 380      -5.083  35.026  51.759  1.00 41.98           C  
ATOM   3096  O   LEU A 380      -4.939  34.681  52.942  1.00 40.75           O  
ATOM   3097  CB  LEU A 380      -2.818  35.237  50.686  1.00 25.76           C  
ATOM   3098  CG  LEU A 380      -1.654  34.934  49.717  1.00 25.29           C  
ATOM   3099  CD1 LEU A 380      -0.492  35.836  50.028  1.00 22.28           C  
ATOM   3100  CD2 LEU A 380      -1.194  33.486  49.801  1.00 22.59           C  
ATOM   3101  N   LYS A 381      -6.012  35.908  51.363  1.00 44.75           N  
ATOM   3102  CA  LYS A 381      -6.978  36.534  52.281  1.00 46.61           C  
ATOM   3103  C   LYS A 381      -7.920  35.475  52.790  1.00 45.94           C  
ATOM   3104  O   LYS A 381      -8.169  35.349  53.997  1.00 40.86           O  
ATOM   3105  CB  LYS A 381      -7.765  37.622  51.560  1.00 48.81           C  
ATOM   3106  CG  LYS A 381      -7.347  39.031  51.934  1.00 62.94           C  
ATOM   3107  CD  LYS A 381      -8.035  40.114  51.079  1.00 73.80           C  
ATOM   3108  CE  LYS A 381      -7.519  41.508  51.460  1.00 74.48           C  
ATOM   3109  NZ  LYS A 381      -7.654  42.463  50.335  1.00 73.07           N  
ATOM   3110  N   ASN A 382      -8.285  34.619  51.837  1.00 46.78           N  
ATOM   3111  CA  ASN A 382      -9.171  33.483  52.031  1.00 53.77           C  
ATOM   3112  C   ASN A 382      -8.386  32.341  52.665  1.00 54.08           C  
ATOM   3113  O   ASN A 382      -8.853  31.195  52.716  1.00 57.80           O  
ATOM   3114  CB  ASN A 382      -9.806  33.068  50.692  1.00 55.54           C  
ATOM   3115  CG  ASN A 382     -10.728  34.147  50.112  1.00 61.02           C  
ATOM   3116  OD1 ASN A 382     -11.260  34.993  50.846  1.00 62.74           O  
ATOM   3117  ND2 ASN A 382     -10.923  34.116  48.785  1.00 64.40           N  
ATOM   3118  N   LYS A 383      -7.173  32.671  53.113  1.00 48.12           N  
ATOM   3119  CA  LYS A 383      -6.301  31.737  53.816  1.00 45.18           C  
ATOM   3120  C   LYS A 383      -5.859  32.363  55.121  1.00 44.27           C  
ATOM   3121  O   LYS A 383      -4.971  31.842  55.798  1.00 41.70           O  
ATOM   3122  CB  LYS A 383      -5.111  31.297  52.979  1.00 41.04           C  
ATOM   3123  CG  LYS A 383      -5.254  29.885  52.526  1.00 34.97           C  
ATOM   3124  CD  LYS A 383      -4.240  29.631  51.516  1.00 34.85           C  
ATOM   3125  CE  LYS A 383      -4.546  28.382  50.798  1.00 32.28           C  
ATOM   3126  NZ  LYS A 383      -3.372  28.113  49.921  1.00 49.01           N  
ATOM   3127  N   GLY A 384      -6.505  33.482  55.452  1.00 44.14           N  
ATOM   3128  CA  GLY A 384      -6.256  34.171  56.708  1.00 50.06           C  
ATOM   3129  C   GLY A 384      -5.248  35.287  56.760  1.00 50.42           C  
ATOM   3130  O   GLY A 384      -5.276  36.110  57.697  1.00 51.97           O  
ATOM   3131  N   ILE A 385      -4.326  35.296  55.799  1.00 50.50           N  
ATOM   3132  CA  ILE A 385      -3.305  36.336  55.743  1.00 48.06           C  
ATOM   3133  C   ILE A 385      -3.711  37.409  54.753  1.00 48.08           C  
ATOM   3134  O   ILE A 385      -4.017  37.143  53.596  1.00 43.64           O  
ATOM   3135  CB  ILE A 385      -1.893  35.795  55.408  1.00 45.28           C  
ATOM   3136  CG1 ILE A 385      -1.540  34.638  56.336  1.00 42.44           C  
ATOM   3137  CG2 ILE A 385      -0.838  36.925  55.554  1.00 43.04           C  
ATOM   3138  CD1 ILE A 385      -1.852  33.296  55.776  1.00 46.16           C  
ATOM   3139  N   LYS A 386      -3.696  38.634  55.251  1.00 49.55           N  
ATOM   3140  CA  LYS A 386      -4.062  39.799  54.477  1.00 51.46           C  
ATOM   3141  C   LYS A 386      -2.844  40.678  54.148  1.00 46.64           C  
ATOM   3142  O   LYS A 386      -2.093  41.093  55.059  1.00 45.00           O  
ATOM   3143  CB  LYS A 386      -5.125  40.596  55.265  1.00 52.80           C  
ATOM   3144  CG  LYS A 386      -6.340  39.762  55.687  1.00 51.84           C  
ATOM   3145  CD  LYS A 386      -6.860  40.184  57.036  1.00 61.78           C  
ATOM   3146  CE  LYS A 386      -7.756  39.109  57.640  1.00 64.62           C  
ATOM   3147  NZ  LYS A 386      -8.150  39.498  59.029  1.00 70.80           N  
ATOM   3148  N   LEU A 387      -2.591  40.876  52.848  1.00 50.84           N  
ATOM   3149  CA  LEU A 387      -1.509  41.773  52.430  1.00 44.67           C  
ATOM   3150  C   LEU A 387      -2.094  43.172  52.356  1.00 48.70           C  
ATOM   3151  O   LEU A 387      -3.221  43.375  51.883  1.00 47.01           O  
ATOM   3152  CB  LEU A 387      -0.953  41.451  51.050  1.00 44.29           C  
ATOM   3153  CG  LEU A 387      -0.443  40.082  50.649  1.00 36.67           C  
ATOM   3154  CD1 LEU A 387       0.480  40.311  49.465  1.00 29.00           C  
ATOM   3155  CD2 LEU A 387       0.285  39.425  51.764  1.00 31.55           C  
ATOM   3156  N   LYS A 388      -1.340  44.108  52.916  1.00 45.11           N  
ATOM   3157  CA  LYS A 388      -1.681  45.517  52.937  1.00 46.69           C  
ATOM   3158  C   LYS A 388      -0.508  46.205  52.250  1.00 51.56           C  
ATOM   3159  O   LYS A 388       0.605  46.248  52.798  1.00 50.77           O  
ATOM   3160  CB  LYS A 388      -1.836  46.014  54.377  1.00 48.38           C  
ATOM   3161  CG  LYS A 388      -3.065  45.483  55.072  1.00 51.77           C  
ATOM   3162  CD  LYS A 388      -3.309  46.159  56.404  1.00 56.28           C  
ATOM   3163  CE  LYS A 388      -4.710  45.837  56.908  1.00 61.27           C  
ATOM   3164  NZ  LYS A 388      -4.893  46.306  58.300  1.00 64.71           N  
ATOM   3165  N   ILE A 389      -0.744  46.671  51.018  1.00 49.18           N  
ATOM   3166  CA  ILE A 389       0.279  47.351  50.211  1.00 44.69           C  
ATOM   3167  C   ILE A 389       0.717  48.679  50.831  1.00 44.07           C  
ATOM   3168  O   ILE A 389      -0.095  49.571  51.105  1.00 35.54           O  
ATOM   3169  CB  ILE A 389      -0.183  47.555  48.731  1.00 46.62           C  
ATOM   3170  CG1 ILE A 389      -0.637  46.213  48.136  1.00 44.34           C  
ATOM   3171  CG2 ILE A 389       0.989  48.087  47.883  1.00 39.22           C  
ATOM   3172  CD1 ILE A 389      -1.577  46.332  46.953  1.00 47.76           C  
ATOM   3173  N   LYS A 390       2.009  48.734  51.133  1.00 47.70           N  
ATOM   3174  CA  LYS A 390       2.606  49.916  51.700  1.00 48.69           C  
ATOM   3175  C   LYS A 390       3.014  50.818  50.545  1.00 49.71           C  
ATOM   3176  O   LYS A 390       2.604  51.977  50.535  1.00 58.89           O  
ATOM   3177  CB  LYS A 390       3.809  49.582  52.592  1.00 47.31           C  
ATOM   3178  CG  LYS A 390       3.749  50.287  53.959  1.00 56.30           C  
ATOM   3179  CD  LYS A 390       5.029  50.173  54.805  1.00 57.73           C  
ATOM   3180  CE  LYS A 390       4.801  50.751  56.223  1.00 62.92           C  
ATOM   3181  NZ  LYS A 390       6.034  50.774  57.075  1.00 69.65           N  
ATOM   3182  N   GLY A 391       3.680  50.276  49.514  1.00 47.05           N  
ATOM   3183  CA  GLY A 391       4.105  51.141  48.420  1.00 44.70           C  
ATOM   3184  C   GLY A 391       4.545  50.598  47.079  1.00 43.35           C  
ATOM   3185  O   GLY A 391       5.597  49.976  46.955  1.00 48.68           O  
ATOM   3186  N   LYS A 392       3.796  50.966  46.044  1.00 41.57           N  
ATOM   3187  CA  LYS A 392       4.108  50.538  44.682  1.00 37.32           C  
ATOM   3188  C   LYS A 392       5.198  51.400  44.062  1.00 36.78           C  
ATOM   3189  O   LYS A 392       5.068  52.632  43.978  1.00 33.61           O  
ATOM   3190  CB  LYS A 392       2.850  50.544  43.788  1.00 41.62           C  
ATOM   3191  CG  LYS A 392       1.753  49.603  44.287  1.00 41.74           C  
ATOM   3192  CD  LYS A 392       0.534  49.531  43.378  1.00 41.08           C  
ATOM   3193  CE  LYS A 392      -0.550  48.597  43.924  1.00 37.53           C  
ATOM   3194  NZ  LYS A 392      -1.698  48.374  42.994  1.00 37.02           N  
ATOM   3195  N   SER A 393       6.298  50.746  43.704  1.00 28.40           N  
ATOM   3196  CA  SER A 393       7.407  51.424  43.057  1.00 30.19           C  
ATOM   3197  C   SER A 393       7.453  50.923  41.610  1.00 27.34           C  
ATOM   3198  O   SER A 393       7.828  49.789  41.367  1.00 29.87           O  
ATOM   3199  CB  SER A 393       8.742  51.121  43.770  1.00 30.65           C  
ATOM   3200  OG  SER A 393       8.636  51.132  45.193  1.00 26.07           O  
ATOM   3201  N   LEU A 394       6.997  51.733  40.659  1.00 26.59           N  
ATOM   3202  CA  LEU A 394       7.033  51.345  39.252  1.00 29.50           C  
ATOM   3203  C   LEU A 394       8.258  51.970  38.570  1.00 32.31           C  
ATOM   3204  O   LEU A 394       8.470  53.187  38.640  1.00 30.12           O  
ATOM   3205  CB  LEU A 394       5.707  51.689  38.552  1.00 25.39           C  
ATOM   3206  CG  LEU A 394       5.634  51.864  37.025  1.00 27.64           C  
ATOM   3207  CD1 LEU A 394       6.137  50.624  36.229  1.00 24.66           C  
ATOM   3208  CD2 LEU A 394       4.194  52.255  36.669  1.00 32.29           C  
ATOM   3209  N   ILE A 395       9.030  51.101  37.903  1.00 31.09           N  
ATOM   3210  CA  ILE A 395      10.277  51.438  37.212  1.00 35.27           C  
ATOM   3211  C   ILE A 395      10.141  51.138  35.742  1.00 34.27           C  
ATOM   3212  O   ILE A 395       9.701  50.056  35.364  1.00 37.73           O  
ATOM   3213  CB  ILE A 395      11.497  50.614  37.784  1.00 32.07           C  
ATOM   3214  CG1 ILE A 395      11.803  51.036  39.224  1.00 33.04           C  
ATOM   3215  CG2 ILE A 395      12.757  50.880  36.976  1.00 31.99           C  
ATOM   3216  CD1 ILE A 395      12.652  50.086  39.981  1.00 32.87           C  
ATOM   3217  N   LEU A 396      10.654  52.066  34.935  1.00 46.18           N  
ATOM   3218  CA  LEU A 396      10.615  51.981  33.479  1.00 55.84           C  
ATOM   3219  C   LEU A 396      11.928  51.707  32.764  1.00 64.58           C  
ATOM   3220  O   LEU A 396      12.808  52.575  32.639  1.00 61.59           O  
ATOM   3221  CB  LEU A 396       9.948  53.214  32.899  1.00 57.51           C  
ATOM   3222  CG  LEU A 396       8.505  52.880  32.577  1.00 62.88           C  
ATOM   3223  CD1 LEU A 396       7.583  53.976  33.130  1.00 68.08           C  
ATOM   3224  CD2 LEU A 396       8.376  52.655  31.058  1.00 63.23           C  
ATOM   3225  N   ALA A 397      12.002  50.486  32.243  1.00 67.90           N  
ATOM   3226  CA  ALA A 397      13.160  49.990  31.523  1.00 72.02           C  
ATOM   3227  C   ALA A 397      13.150  50.370  30.071  1.00 79.42           C  
ATOM   3228  O   ALA A 397      12.191  50.942  29.543  1.00 79.87           O  
ATOM   3229  CB  ALA A 397      13.226  48.481  31.610  1.00 73.33           C  
ATOM   3230  N   GLN A 398      14.292  50.080  29.467  1.00 81.90           N  
ATOM   3231  CA  GLN A 398      14.612  50.259  28.063  1.00 80.64           C  
ATOM   3232  C   GLN A 398      15.474  49.014  27.921  1.00 85.50           C  
ATOM   3233  O   GLN A 398      15.185  48.152  27.096  1.00 81.47           O  
ATOM   3234  CB  GLN A 398      15.422  51.540  27.850  1.00 82.37           C  
ATOM   3235  CG  GLN A 398      14.604  52.797  28.155  1.00 84.83           C  
ATOM   3236  CD  GLN A 398      15.315  54.093  27.911  1.00 86.03           C  
ATOM   3237  OE1 GLN A 398      16.304  54.163  27.171  1.00 82.74           O  
ATOM   3238  NE2 GLN A 398      14.789  55.151  28.512  1.00 82.74           N  
ATOM   3239  N   THR A 399      16.439  48.888  28.845  1.00 79.80           N  
ATOM   3240  CA  THR A 399      17.383  47.767  28.992  1.00 81.91           C  
ATOM   3241  C   THR A 399      18.128  47.991  30.341  1.00 83.93           C  
ATOM   3242  O   THR A 399      17.657  48.787  31.172  1.00 85.32           O  
ATOM   3243  CB  THR A 399      18.367  47.667  27.769  1.00 83.24           C  
ATOM   3244  OG1 THR A 399      17.602  47.607  26.563  1.00 77.31           O  
ATOM   3245  CG2 THR A 399      19.187  46.377  27.799  1.00 84.15           C  
ATOM   3246  N   ARG A 400      19.257  47.286  30.539  1.00 81.89           N  
ATOM   3247  CA  ARG A 400      20.177  47.313  31.705  1.00 80.13           C  
ATOM   3248  C   ARG A 400      20.290  48.551  32.569  1.00 84.46           C  
ATOM   3249  O   ARG A 400      20.693  48.423  33.726  1.00 80.82           O  
ATOM   3250  CB  ARG A 400      21.598  47.022  31.254  1.00 82.80           C  
ATOM   3251  CG  ARG A 400      21.825  45.696  30.640  1.00 82.97           C  
ATOM   3252  CD  ARG A 400      23.112  45.744  29.869  1.00 85.76           C  
ATOM   3253  NE  ARG A 400      23.541  44.405  29.477  1.00 89.63           N  
ATOM   3254  CZ  ARG A 400      24.785  44.090  29.128  1.00 87.83           C  
ATOM   3255  NH1 ARG A 400      25.724  45.027  29.120  1.00 86.46           N  
ATOM   3256  NH2 ARG A 400      25.094  42.840  28.800  1.00 86.08           N  
ATOM   3257  N   GLU A 401      19.977  49.736  32.001  1.00 86.69           N  
ATOM   3258  CA  GLU A 401      19.990  51.062  32.678  1.00 89.38           C  
ATOM   3259  C   GLU A 401      19.180  50.994  33.954  1.00 87.27           C  
ATOM   3260  O   GLU A 401      19.216  51.879  34.805  1.00 87.92           O  
ATOM   3261  CB  GLU A 401      19.312  52.124  31.814  1.00 92.99           C  
ATOM   3262  CG  GLU A 401      19.940  52.400  30.464  1.00106.97           C  
ATOM   3263  CD  GLU A 401      19.187  53.488  29.700  1.00103.98           C  
ATOM   3264  OE1 GLU A 401      17.956  53.628  29.922  1.00106.22           O  
ATOM   3265  OE2 GLU A 401      19.822  54.199  28.883  1.00106.95           O  
ATOM   3266  N   GLU A 402      18.420  49.913  34.022  1.00 86.13           N  
ATOM   3267  CA  GLU A 402      17.548  49.556  35.104  1.00 85.64           C  
ATOM   3268  C   GLU A 402      18.246  49.006  36.338  1.00 79.45           C  
ATOM   3269  O   GLU A 402      17.744  49.206  37.439  1.00 76.96           O  
ATOM   3270  CB  GLU A 402      16.582  48.545  34.585  1.00 90.08           C  
ATOM   3271  CG  GLU A 402      15.423  48.369  35.456  1.00104.76           C  
ATOM   3272  CD  GLU A 402      14.425  47.532  34.796  1.00108.98           C  
ATOM   3273  OE1 GLU A 402      14.779  46.381  34.444  1.00113.61           O  
ATOM   3274  OE2 GLU A 402      13.279  48.015  34.626  1.00114.19           O  
ATOM   3275  N   ALA A 403      19.376  48.302  36.174  1.00 71.90           N  
ATOM   3276  CA  ALA A 403      20.136  47.781  37.324  1.00 65.48           C  
ATOM   3277  C   ALA A 403      20.492  48.956  38.256  1.00 67.94           C  
ATOM   3278  O   ALA A 403      20.558  48.797  39.482  1.00 61.07           O  
ATOM   3279  CB  ALA A 403      21.376  47.060  36.865  1.00 59.37           C  
ATOM   3280  N   LYS A 404      20.525  50.154  37.646  1.00 66.44           N  
ATOM   3281  CA  LYS A 404      20.796  51.457  38.290  1.00 63.25           C  
ATOM   3282  C   LYS A 404      19.492  52.085  38.813  1.00 60.60           C  
ATOM   3283  O   LYS A 404      19.417  52.543  39.952  1.00 58.27           O  
ATOM   3284  CB  LYS A 404      21.442  52.431  37.290  1.00 74.22           C  
ATOM   3285  CG  LYS A 404      22.738  51.979  36.598  1.00 69.51           C  
ATOM   3286  CD  LYS A 404      23.015  52.933  35.438  1.00 69.46           C  
ATOM   3287  CE  LYS A 404      24.386  52.780  34.815  1.00 70.92           C  
ATOM   3288  NZ  LYS A 404      24.547  53.766  33.707  1.00 66.63           N  
ATOM   3289  N   GLU A 405      18.458  52.088  37.978  1.00 64.98           N  
ATOM   3290  CA  GLU A 405      17.160  52.632  38.365  1.00 66.63           C  
ATOM   3291  C   GLU A 405      16.464  51.731  39.389  1.00 67.37           C  
ATOM   3292  O   GLU A 405      15.419  52.104  39.914  1.00 66.11           O  
ATOM   3293  CB  GLU A 405      16.249  52.806  37.147  1.00 70.14           C  
ATOM   3294  CG  GLU A 405      16.633  53.923  36.171  1.00 80.42           C  
ATOM   3295  CD  GLU A 405      15.623  54.134  35.024  1.00 88.58           C  
ATOM   3296  OE1 GLU A 405      14.434  53.754  35.168  1.00 93.10           O  
ATOM   3297  OE2 GLU A 405      16.020  54.695  33.973  1.00 91.69           O  
ATOM   3298  N   LYS A 406      17.034  50.548  39.651  1.00 64.88           N  
ATOM   3299  CA  LYS A 406      16.504  49.596  40.637  1.00 58.77           C  
ATOM   3300  C   LYS A 406      17.344  49.692  41.888  1.00 55.77           C  
ATOM   3301  O   LYS A 406      16.821  49.509  42.988  1.00 57.36           O  
ATOM   3302  CB  LYS A 406      16.544  48.169  40.133  1.00 52.60           C  
ATOM   3303  CG  LYS A 406      15.381  47.332  40.562  1.00 48.63           C  
ATOM   3304  CD  LYS A 406      15.663  45.883  40.257  1.00 60.46           C  
ATOM   3305  CE  LYS A 406      16.075  45.638  38.802  1.00 71.73           C  
ATOM   3306  NZ  LYS A 406      16.341  44.206  38.421  1.00 69.15           N  
ATOM   3307  N   LEU A 407      18.614  50.072  41.717  1.00 56.85           N  
ATOM   3308  CA  LEU A 407      19.536  50.260  42.832  1.00 56.64           C  
ATOM   3309  C   LEU A 407      18.963  51.307  43.754  1.00 54.87           C  
ATOM   3310  O   LEU A 407      18.716  51.014  44.926  1.00 51.99           O  
ATOM   3311  CB  LEU A 407      20.916  50.701  42.344  1.00 54.91           C  
ATOM   3312  CG  LEU A 407      21.986  49.606  42.320  1.00 57.31           C  
ATOM   3313  CD1 LEU A 407      23.097  50.000  41.388  1.00 55.87           C  
ATOM   3314  CD2 LEU A 407      22.514  49.332  43.736  1.00 56.22           C  
ATOM   3315  N   ILE A 408      18.552  52.429  43.160  1.00 52.56           N  
ATOM   3316  CA  ILE A 408      17.959  53.531  43.906  1.00 53.66           C  
ATOM   3317  C   ILE A 408      16.751  53.100  44.811  1.00 53.74           C  
ATOM   3318  O   ILE A 408      16.841  53.333  46.025  1.00 44.23           O  
ATOM   3319  CB  ILE A 408      17.692  54.815  42.986  1.00 60.08           C  
ATOM   3320  CG1 ILE A 408      18.856  55.019  42.005  1.00 63.10           C  
ATOM   3321  CG2 ILE A 408      17.496  56.079  43.864  1.00 63.45           C  
ATOM   3322  CD1 ILE A 408      18.749  56.251  41.053  1.00 67.27           C  
ATOM   3323  N   PRO A 409      15.676  52.420  44.272  1.00 49.08           N  
ATOM   3324  CA  PRO A 409      14.565  52.018  45.155  1.00 50.51           C  
ATOM   3325  C   PRO A 409      14.840  50.873  46.123  1.00 52.22           C  
ATOM   3326  O   PRO A 409      14.149  50.787  47.142  1.00 54.67           O  
ATOM   3327  CB  PRO A 409      13.453  51.623  44.176  1.00 54.27           C  
ATOM   3328  CG  PRO A 409      13.705  52.497  43.030  1.00 47.99           C  
ATOM   3329  CD  PRO A 409      15.189  52.358  42.881  1.00 47.17           C  
ATOM   3330  N   VAL A 410      15.805  50.002  45.803  1.00 49.24           N  
ATOM   3331  CA  VAL A 410      16.149  48.868  46.676  1.00 43.27           C  
ATOM   3332  C   VAL A 410      16.825  49.330  47.952  1.00 41.36           C  
ATOM   3333  O   VAL A 410      16.456  48.866  49.016  1.00 41.32           O  
ATOM   3334  CB  VAL A 410      17.036  47.805  45.962  1.00 48.76           C  
ATOM   3335  CG1 VAL A 410      17.666  46.849  46.962  1.00 47.78           C  
ATOM   3336  CG2 VAL A 410      16.209  46.983  44.981  1.00 49.73           C  
ATOM   3337  N   ILE A 411      17.761  50.276  47.836  1.00 43.68           N  
ATOM   3338  CA  ILE A 411      18.516  50.831  48.976  1.00 51.54           C  
ATOM   3339  C   ILE A 411      17.601  51.424  50.064  1.00 54.82           C  
ATOM   3340  O   ILE A 411      17.899  51.323  51.258  1.00 56.28           O  
ATOM   3341  CB  ILE A 411      19.542  51.936  48.519  1.00 57.30           C  
ATOM   3342  CG1 ILE A 411      20.508  51.378  47.479  1.00 55.58           C  
ATOM   3343  CG2 ILE A 411      20.433  52.389  49.688  1.00 49.16           C  
ATOM   3344  CD1 ILE A 411      21.168  52.456  46.612  1.00 58.74           C  
ATOM   3345  N   ASN A 412      16.450  51.943  49.639  1.00 57.62           N  
ATOM   3346  CA  ASN A 412      15.478  52.588  50.524  1.00 61.09           C  
ATOM   3347  C   ASN A 412      14.382  51.663  51.025  1.00 64.75           C  
ATOM   3348  O   ASN A 412      13.559  52.063  51.864  1.00 69.43           O  
ATOM   3349  CB  ASN A 412      14.814  53.758  49.785  1.00 64.65           C  
ATOM   3350  CG  ASN A 412      15.826  54.722  49.145  1.00 76.42           C  
ATOM   3351  OD1 ASN A 412      16.583  55.405  49.838  1.00 80.90           O  
ATOM   3352  ND2 ASN A 412      15.818  54.794  47.812  1.00 74.40           N  
ATOM   3353  N   LYS A 413      14.401  50.421  50.553  1.00 67.52           N  
ATOM   3354  CA  LYS A 413      13.357  49.465  50.898  1.00 70.21           C  
ATOM   3355  C   LYS A 413      13.394  48.736  52.211  1.00 69.71           C  
ATOM   3356  O   LYS A 413      12.737  47.701  52.365  1.00 67.51           O  
ATOM   3357  CB  LYS A 413      13.179  48.475  49.768  1.00 72.79           C  
ATOM   3358  CG  LYS A 413      11.737  48.114  49.513  1.00 78.11           C  
ATOM   3359  CD  LYS A 413      11.653  47.345  48.269  1.00 88.25           C  
ATOM   3360  CE  LYS A 413      12.204  48.137  47.093  1.00 97.76           C  
ATOM   3361  NZ  LYS A 413      12.905  47.221  46.151  1.00102.58           N  
ATOM   3362  N   ILE A 414      14.138  49.258  53.177  1.00 67.93           N  
ATOM   3363  CA  ILE A 414      14.152  48.572  54.463  1.00 65.81           C  
ATOM   3364  C   ILE A 414      12.918  48.969  55.261  1.00 65.51           C  
ATOM   3365  O   ILE A 414      12.476  48.204  56.116  1.00 57.48           O  
ATOM   3366  CB  ILE A 414      15.478  48.716  55.267  1.00 73.16           C  
ATOM   3367  CG1 ILE A 414      16.682  48.740  54.306  1.00 75.52           C  
ATOM   3368  CG2 ILE A 414      15.622  47.484  56.215  1.00 71.33           C  
ATOM   3369  CD1 ILE A 414      18.087  48.503  54.953  1.00 73.09           C  
ATOM   3370  N   LYS A 415      12.298  50.073  54.826  1.00 67.86           N  
ATOM   3371  CA  LYS A 415      11.074  50.697  55.371  1.00 73.63           C  
ATOM   3372  C   LYS A 415      10.404  50.161  56.645  1.00 69.86           C  
ATOM   3373  O   LYS A 415      10.105  50.951  57.553  1.00 76.86           O  
ATOM   3374  CB  LYS A 415      10.046  50.907  54.242  1.00 72.39           C  
ATOM   3375  CG  LYS A 415      10.487  51.968  53.259  1.00 72.58           C  
ATOM   3376  CD  LYS A 415       9.546  52.128  52.106  1.00 79.47           C  
ATOM   3377  CE  LYS A 415      10.085  53.172  51.158  1.00 79.96           C  
ATOM   3378  NZ  LYS A 415       9.203  53.389  49.979  1.00 85.97           N  
ATOM   3379  N   ASP A 416      10.182  48.837  56.659  1.00 65.52           N  
ATOM   3380  CA  ASP A 416       9.601  48.007  57.732  1.00 59.64           C  
ATOM   3381  C   ASP A 416       8.856  46.847  57.082  1.00 57.56           C  
ATOM   3382  O   ASP A 416       8.112  46.115  57.747  1.00 56.22           O  
ATOM   3383  CB  ASP A 416       8.637  48.768  58.662  1.00 64.61           C  
ATOM   3384  CG  ASP A 416       8.701  48.282  60.108  1.00 63.35           C  
ATOM   3385  OD1 ASP A 416       9.241  47.181  60.377  1.00 60.83           O  
ATOM   3386  OD2 ASP A 416       8.209  49.022  60.980  1.00 70.22           O  
ATOM   3387  N   VAL A 417       9.088  46.655  55.788  1.00 50.61           N  
ATOM   3388  CA  VAL A 417       8.417  45.612  55.032  1.00 36.84           C  
ATOM   3389  C   VAL A 417       8.606  44.187  55.493  1.00 36.99           C  
ATOM   3390  O   VAL A 417       9.683  43.808  55.959  1.00 40.66           O  
ATOM   3391  CB  VAL A 417       8.709  45.687  53.530  1.00 40.63           C  
ATOM   3392  CG1 VAL A 417       7.653  46.465  52.877  1.00 35.54           C  
ATOM   3393  CG2 VAL A 417      10.078  46.305  53.251  1.00 42.14           C  
ATOM   3394  N   ASP A 418       7.505  43.443  55.418  1.00 34.43           N  
ATOM   3395  CA  ASP A 418       7.434  42.038  55.783  1.00 32.93           C  
ATOM   3396  C   ASP A 418       7.751  41.165  54.574  1.00 35.78           C  
ATOM   3397  O   ASP A 418       8.277  40.054  54.721  1.00 33.31           O  
ATOM   3398  CB  ASP A 418       6.040  41.704  56.304  1.00 36.88           C  
ATOM   3399  CG  ASP A 418       5.753  42.297  57.680  1.00 36.46           C  
ATOM   3400  OD1 ASP A 418       6.695  42.594  58.456  1.00 45.74           O  
ATOM   3401  OD2 ASP A 418       4.556  42.453  57.992  1.00 38.23           O  
ATOM   3402  N   LEU A 419       7.403  41.670  53.386  1.00 39.07           N  
ATOM   3403  CA  LEU A 419       7.646  41.017  52.081  1.00 31.70           C  
ATOM   3404  C   LEU A 419       7.844  42.093  51.007  1.00 27.34           C  
ATOM   3405  O   LEU A 419       7.565  43.281  51.227  1.00 29.22           O  
ATOM   3406  CB  LEU A 419       6.474  40.100  51.691  1.00 37.81           C  
ATOM   3407  CG  LEU A 419       6.512  39.329  50.357  1.00 36.19           C  
ATOM   3408  CD1 LEU A 419       7.666  38.340  50.275  1.00 40.81           C  
ATOM   3409  CD2 LEU A 419       5.225  38.604  50.204  1.00 40.66           C  
ATOM   3410  N   VAL A 420       8.400  41.691  49.874  1.00 21.19           N  
ATOM   3411  CA  VAL A 420       8.623  42.611  48.763  1.00 19.63           C  
ATOM   3412  C   VAL A 420       8.262  41.828  47.505  1.00 15.44           C  
ATOM   3413  O   VAL A 420       8.858  40.773  47.240  1.00 24.23           O  
ATOM   3414  CB  VAL A 420      10.132  43.069  48.696  1.00 25.62           C  
ATOM   3415  CG1 VAL A 420      10.420  43.860  47.433  1.00 21.32           C  
ATOM   3416  CG2 VAL A 420      10.508  43.921  49.886  1.00 32.06           C  
ATOM   3417  N   ILE A 421       7.296  42.303  46.731  1.00 14.72           N  
ATOM   3418  CA  ILE A 421       6.966  41.558  45.525  1.00 13.14           C  
ATOM   3419  C   ILE A 421       7.478  42.299  44.307  1.00 12.01           C  
ATOM   3420  O   ILE A 421       7.106  43.438  44.076  1.00 11.80           O  
ATOM   3421  CB  ILE A 421       5.457  41.254  45.407  1.00 11.54           C  
ATOM   3422  CG1 ILE A 421       4.947  40.575  46.700  1.00  9.62           C  
ATOM   3423  CG2 ILE A 421       5.201  40.350  44.192  1.00  7.74           C  
ATOM   3424  CD1 ILE A 421       3.480  40.086  46.686  1.00 13.53           C  
ATOM   3425  N   VAL A 422       8.334  41.642  43.529  1.00 15.31           N  
ATOM   3426  CA  VAL A 422       8.913  42.238  42.329  1.00 19.68           C  
ATOM   3427  C   VAL A 422       8.511  41.538  41.041  1.00 18.10           C  
ATOM   3428  O   VAL A 422       8.732  40.333  40.876  1.00 19.46           O  
ATOM   3429  CB  VAL A 422      10.491  42.257  42.380  1.00 28.02           C  
ATOM   3430  CG1 VAL A 422      11.089  43.042  41.164  1.00 18.81           C  
ATOM   3431  CG2 VAL A 422      10.994  42.853  43.702  1.00 30.56           C  
ATOM   3432  N   PHE A 423       7.988  42.330  40.104  1.00 21.31           N  
ATOM   3433  CA  PHE A 423       7.596  41.843  38.785  1.00 27.40           C  
ATOM   3434  C   PHE A 423       8.662  42.307  37.783  1.00 26.86           C  
ATOM   3435  O   PHE A 423       8.766  43.508  37.509  1.00 30.57           O  
ATOM   3436  CB  PHE A 423       6.242  42.407  38.353  1.00 19.81           C  
ATOM   3437  CG  PHE A 423       5.088  41.980  39.189  1.00 14.34           C  
ATOM   3438  CD1 PHE A 423       4.560  42.858  40.160  1.00 17.02           C  
ATOM   3439  CD2 PHE A 423       4.445  40.752  38.951  1.00 12.20           C  
ATOM   3440  CE1 PHE A 423       3.375  42.524  40.886  1.00 11.35           C  
ATOM   3441  CE2 PHE A 423       3.257  40.394  39.665  1.00 13.79           C  
ATOM   3442  CZ  PHE A 423       2.721  41.292  40.641  1.00  7.34           C  
ATOM   3443  N   LEU A 424       9.462  41.373  37.262  1.00 32.48           N  
ATOM   3444  CA  LEU A 424      10.510  41.720  36.288  1.00 39.77           C  
ATOM   3445  C   LEU A 424      10.099  41.441  34.853  1.00 40.56           C  
ATOM   3446  O   LEU A 424       9.389  40.467  34.612  1.00 44.56           O  
ATOM   3447  CB  LEU A 424      11.799  40.963  36.573  1.00 39.48           C  
ATOM   3448  CG  LEU A 424      12.559  41.136  37.877  1.00 40.04           C  
ATOM   3449  CD1 LEU A 424      13.718  40.186  37.791  1.00 42.25           C  
ATOM   3450  CD2 LEU A 424      13.066  42.558  38.076  1.00 34.74           C  
ATOM   3451  N   GLU A 425      10.569  42.261  33.906  1.00 42.96           N  
ATOM   3452  CA  GLU A 425      10.243  42.068  32.496  1.00 52.67           C  
ATOM   3453  C   GLU A 425      11.122  41.010  31.851  1.00 51.85           C  
ATOM   3454  O   GLU A 425      12.330  41.046  32.021  1.00 53.85           O  
ATOM   3455  CB  GLU A 425      10.361  43.381  31.714  1.00 56.66           C  
ATOM   3456  CG  GLU A 425       9.722  43.329  30.297  1.00 62.76           C  
ATOM   3457  CD  GLU A 425       8.191  43.193  30.277  1.00 66.73           C  
ATOM   3458  OE1 GLU A 425       7.494  43.726  31.167  1.00 69.63           O  
ATOM   3459  OE2 GLU A 425       7.680  42.560  29.336  1.00 66.80           O  
ATOM   3460  N   PHE A 436      18.798  36.766  33.395  1.00 78.61           N  
ATOM   3461  CA  PHE A 436      18.670  36.036  34.655  1.00 79.34           C  
ATOM   3462  C   PHE A 436      19.423  36.701  35.806  1.00 77.51           C  
ATOM   3463  O   PHE A 436      19.029  36.544  36.974  1.00 76.33           O  
ATOM   3464  CB  PHE A 436      19.159  34.592  34.509  1.00 75.50           C  
ATOM   3465  CG  PHE A 436      18.335  33.755  33.580  1.00 89.10           C  
ATOM   3466  CD1 PHE A 436      18.825  33.440  32.288  1.00 88.26           C  
ATOM   3467  CD2 PHE A 436      17.078  33.249  33.991  1.00 82.84           C  
ATOM   3468  CE1 PHE A 436      18.079  32.622  31.394  1.00 85.35           C  
ATOM   3469  CE2 PHE A 436      16.300  32.423  33.117  1.00 91.61           C  
ATOM   3470  CZ  PHE A 436      16.806  32.105  31.805  1.00 91.78           C  
ATOM   3471  N   LEU A 437      20.480  37.461  35.478  1.00 73.54           N  
ATOM   3472  CA  LEU A 437      21.308  38.179  36.468  1.00 71.23           C  
ATOM   3473  C   LEU A 437      20.429  39.184  37.185  1.00 69.07           C  
ATOM   3474  O   LEU A 437      20.783  39.688  38.246  1.00 64.00           O  
ATOM   3475  CB  LEU A 437      22.476  38.926  35.799  1.00 74.39           C  
ATOM   3476  CG  LEU A 437      23.525  38.209  34.936  1.00 75.61           C  
ATOM   3477  CD1 LEU A 437      24.542  39.232  34.448  1.00 75.19           C  
ATOM   3478  CD2 LEU A 437      24.229  37.102  35.713  1.00 76.61           C  
ATOM   3479  N   LEU A 438      19.266  39.426  36.574  1.00 64.61           N  
ATOM   3480  CA  LEU A 438      18.217  40.310  37.058  1.00 62.24           C  
ATOM   3481  C   LEU A 438      17.607  39.741  38.354  1.00 62.87           C  
ATOM   3482  O   LEU A 438      17.700  40.405  39.395  1.00 62.88           O  
ATOM   3483  CB  LEU A 438      17.146  40.486  35.963  1.00 62.95           C  
ATOM   3484  CG  LEU A 438      17.437  41.440  34.798  1.00 58.40           C  
ATOM   3485  CD1 LEU A 438      16.399  41.273  33.701  1.00 55.88           C  
ATOM   3486  CD2 LEU A 438      17.456  42.873  35.308  1.00 54.05           C  
ATOM   3487  N   TYR A 439      17.078  38.499  38.304  1.00 59.13           N  
ATOM   3488  CA  TYR A 439      16.487  37.788  39.468  1.00 54.78           C  
ATOM   3489  C   TYR A 439      17.544  37.803  40.561  1.00 49.12           C  
ATOM   3490  O   TYR A 439      17.326  38.380  41.626  1.00 48.48           O  
ATOM   3491  CB  TYR A 439      16.112  36.317  39.091  1.00 58.47           C  
ATOM   3492  CG  TYR A 439      15.627  35.347  40.219  1.00 61.72           C  
ATOM   3493  CD1 TYR A 439      14.256  35.030  40.385  1.00 59.27           C  
ATOM   3494  CD2 TYR A 439      16.543  34.741  41.123  1.00 62.74           C  
ATOM   3495  CE1 TYR A 439      13.807  34.128  41.441  1.00 60.02           C  
ATOM   3496  CE2 TYR A 439      16.111  33.853  42.176  1.00 59.57           C  
ATOM   3497  CZ  TYR A 439      14.751  33.556  42.326  1.00 61.54           C  
ATOM   3498  OH  TYR A 439      14.363  32.719  43.357  1.00 59.20           O  
ATOM   3499  N   ASP A 440      18.720  37.279  40.194  1.00 48.81           N  
ATOM   3500  CA  ASP A 440      19.909  37.143  41.046  1.00 52.35           C  
ATOM   3501  C   ASP A 440      20.350  38.412  41.793  1.00 46.88           C  
ATOM   3502  O   ASP A 440      20.567  38.381  43.002  1.00 42.18           O  
ATOM   3503  CB  ASP A 440      21.101  36.583  40.223  1.00 63.21           C  
ATOM   3504  CG  ASP A 440      20.889  35.126  39.723  1.00 58.13           C  
ATOM   3505  OD1 ASP A 440      19.944  34.435  40.161  1.00 62.69           O  
ATOM   3506  OD2 ASP A 440      21.703  34.659  38.889  1.00 63.11           O  
ATOM   3507  N   PHE A 441      20.475  39.523  41.078  1.00 42.72           N  
ATOM   3508  CA  PHE A 441      20.862  40.795  41.681  1.00 38.82           C  
ATOM   3509  C   PHE A 441      19.844  41.203  42.759  1.00 38.12           C  
ATOM   3510  O   PHE A 441      20.214  41.396  43.915  1.00 37.31           O  
ATOM   3511  CB  PHE A 441      21.001  41.894  40.585  1.00 42.98           C  
ATOM   3512  CG  PHE A 441      21.006  43.325  41.113  1.00 42.39           C  
ATOM   3513  CD1 PHE A 441      22.085  43.808  41.871  1.00 37.33           C  
ATOM   3514  CD2 PHE A 441      19.877  44.160  40.934  1.00 39.33           C  
ATOM   3515  CE1 PHE A 441      22.036  45.098  42.461  1.00 37.57           C  
ATOM   3516  CE2 PHE A 441      19.821  45.459  41.526  1.00 38.84           C  
ATOM   3517  CZ  PHE A 441      20.899  45.923  42.290  1.00 33.34           C  
ATOM   3518  N   VAL A 442      18.570  41.256  42.366  1.00 36.72           N  
ATOM   3519  CA  VAL A 442      17.473  41.678  43.234  1.00 35.89           C  
ATOM   3520  C   VAL A 442      17.316  40.899  44.526  1.00 35.29           C  
ATOM   3521  O   VAL A 442      17.104  41.502  45.584  1.00 31.95           O  
ATOM   3522  CB  VAL A 442      16.123  41.651  42.483  1.00 44.50           C  
ATOM   3523  CG1 VAL A 442      15.031  42.355  43.294  1.00 44.65           C  
ATOM   3524  CG2 VAL A 442      16.249  42.306  41.142  1.00 39.75           C  
ATOM   3525  N   LYS A 443      17.412  39.574  44.437  1.00 32.95           N  
ATOM   3526  CA  LYS A 443      17.278  38.715  45.603  1.00 36.30           C  
ATOM   3527  C   LYS A 443      18.407  38.907  46.607  1.00 36.74           C  
ATOM   3528  O   LYS A 443      18.132  39.007  47.806  1.00 38.79           O  
ATOM   3529  CB  LYS A 443      17.170  37.237  45.205  1.00 38.91           C  
ATOM   3530  CG  LYS A 443      15.755  36.744  44.833  1.00 42.35           C  
ATOM   3531  CD  LYS A 443      14.888  36.346  46.032  1.00 36.30           C  
ATOM   3532  CE  LYS A 443      14.595  34.858  46.048  1.00 30.90           C  
ATOM   3533  NZ  LYS A 443      13.536  34.532  47.032  1.00 35.73           N  
ATOM   3534  N   ARG A 444      19.644  39.059  46.102  1.00 34.95           N  
ATOM   3535  CA  ARG A 444      20.850  39.246  46.933  1.00 26.00           C  
ATOM   3536  C   ARG A 444      20.770  40.486  47.811  1.00 30.24           C  
ATOM   3537  O   ARG A 444      21.089  40.443  48.995  1.00 31.16           O  
ATOM   3538  CB  ARG A 444      22.117  39.358  46.089  1.00 30.66           C  
ATOM   3539  CG  ARG A 444      22.598  38.086  45.421  1.00 44.92           C  
ATOM   3540  CD  ARG A 444      23.980  38.280  44.777  1.00 49.29           C  
ATOM   3541  NE  ARG A 444      24.127  39.609  44.178  1.00 56.40           N  
ATOM   3542  CZ  ARG A 444      25.003  39.942  43.231  1.00 62.92           C  
ATOM   3543  NH1 ARG A 444      25.845  39.049  42.722  1.00 66.46           N  
ATOM   3544  NH2 ARG A 444      25.061  41.203  42.826  1.00 65.52           N  
ATOM   3545  N   GLU A 445      20.264  41.569  47.236  1.00 31.49           N  
ATOM   3546  CA  GLU A 445      20.131  42.838  47.937  1.00 28.35           C  
ATOM   3547  C   GLU A 445      19.083  42.824  49.034  1.00 24.02           C  
ATOM   3548  O   GLU A 445      19.278  43.432  50.105  1.00 14.14           O  
ATOM   3549  CB  GLU A 445      19.817  43.927  46.934  1.00 34.54           C  
ATOM   3550  CG  GLU A 445      20.880  44.075  45.869  1.00 51.81           C  
ATOM   3551  CD  GLU A 445      22.074  44.923  46.308  1.00 51.92           C  
ATOM   3552  OE1 GLU A 445      21.851  46.002  46.915  1.00 62.91           O  
ATOM   3553  OE2 GLU A 445      23.231  44.521  46.022  1.00 62.03           O  
ATOM   3554  N   LEU A 446      17.977  42.126  48.754  1.00 20.61           N  
ATOM   3555  CA  LEU A 446      16.888  41.994  49.704  1.00 20.93           C  
ATOM   3556  C   LEU A 446      17.171  40.926  50.724  1.00 25.79           C  
ATOM   3557  O   LEU A 446      16.495  40.842  51.758  1.00 25.64           O  
ATOM   3558  CB  LEU A 446      15.591  41.736  48.998  1.00 23.82           C  
ATOM   3559  CG  LEU A 446      15.115  43.006  48.306  1.00 23.96           C  
ATOM   3560  CD1 LEU A 446      13.921  42.645  47.430  1.00 25.63           C  
ATOM   3561  CD2 LEU A 446      14.728  44.083  49.311  1.00 22.40           C  
ATOM   3562  N   LEU A 447      18.224  40.155  50.438  1.00 27.82           N  
ATOM   3563  CA  LEU A 447      18.716  39.110  51.322  1.00 30.66           C  
ATOM   3564  C   LEU A 447      19.605  39.793  52.342  1.00 31.67           C  
ATOM   3565  O   LEU A 447      19.585  39.445  53.533  1.00 34.32           O  
ATOM   3566  CB  LEU A 447      19.564  38.108  50.562  1.00 33.45           C  
ATOM   3567  CG  LEU A 447      19.147  36.645  50.398  1.00 43.20           C  
ATOM   3568  CD1 LEU A 447      20.224  35.950  49.554  1.00 38.32           C  
ATOM   3569  CD2 LEU A 447      18.970  35.956  51.763  1.00 37.88           C  
ATOM   3570  N   LYS A 448      20.365  40.786  51.870  1.00 37.62           N  
ATOM   3571  CA  LYS A 448      21.272  41.562  52.732  1.00 39.51           C  
ATOM   3572  C   LYS A 448      20.507  42.345  53.790  1.00 36.67           C  
ATOM   3573  O   LYS A 448      20.925  42.407  54.946  1.00 33.84           O  
ATOM   3574  CB  LYS A 448      22.129  42.544  51.918  1.00 45.75           C  
ATOM   3575  CG  LYS A 448      23.115  41.890  50.958  1.00 50.23           C  
ATOM   3576  CD  LYS A 448      24.035  42.895  50.278  1.00 54.49           C  
ATOM   3577  CE  LYS A 448      24.687  42.307  49.022  1.00 58.84           C  
ATOM   3578  NZ  LYS A 448      25.687  43.243  48.386  1.00 62.78           N  
ATOM   3579  N   LYS A 449      19.375  42.913  53.370  1.00 40.06           N  
ATOM   3580  CA  LYS A 449      18.505  43.706  54.237  1.00 43.20           C  
ATOM   3581  C   LYS A 449      17.601  42.816  55.055  1.00 44.40           C  
ATOM   3582  O   LYS A 449      16.903  43.279  55.967  1.00 49.81           O  
ATOM   3583  CB  LYS A 449      17.674  44.652  53.406  1.00 53.44           C  
ATOM   3584  CG  LYS A 449      18.512  45.635  52.694  1.00 59.22           C  
ATOM   3585  CD  LYS A 449      17.784  46.186  51.519  1.00 66.03           C  
ATOM   3586  CE  LYS A 449      18.610  47.274  50.871  1.00 70.91           C  
ATOM   3587  NZ  LYS A 449      18.389  48.574  51.566  1.00 71.40           N  
HETATM 3588  N   MSE A 450      17.637  41.527  54.707  1.00 45.90           N  
HETATM 3589  CA  MSE A 450      16.891  40.458  55.367  1.00 38.77           C  
HETATM 3590  C   MSE A 450      15.400  40.491  55.219  1.00 35.65           C  
HETATM 3591  O   MSE A 450      14.674  39.853  55.976  1.00 39.83           O  
HETATM 3592  CB  MSE A 450      17.322  40.310  56.830  1.00 48.67           C  
HETATM 3593  CG  MSE A 450      18.815  39.978  56.939  1.00 60.15           C  
HETATM 3594 SE   MSE A 450      19.592  40.111  58.689  1.00 81.56          SE  
HETATM 3595  CE  MSE A 450      19.384  42.075  58.969  1.00 72.15           C  
ATOM   3596  N   ILE A 451      14.964  41.204  54.189  1.00 34.76           N  
ATOM   3597  CA  ILE A 451      13.554  41.346  53.854  1.00 23.50           C  
ATOM   3598  C   ILE A 451      13.202  40.265  52.832  1.00 13.52           C  
ATOM   3599  O   ILE A 451      13.775  40.217  51.740  1.00 13.12           O  
ATOM   3600  CB  ILE A 451      13.237  42.740  53.205  1.00 26.79           C  
ATOM   3601  CG1 ILE A 451      13.771  43.889  54.062  1.00 30.82           C  
ATOM   3602  CG2 ILE A 451      11.740  42.952  53.115  1.00 25.41           C  
ATOM   3603  CD1 ILE A 451      14.161  45.061  53.228  1.00 27.32           C  
ATOM   3604  N   PRO A 452      12.260  39.360  53.182  1.00  9.70           N  
ATOM   3605  CA  PRO A 452      11.800  38.282  52.309  1.00 12.53           C  
ATOM   3606  C   PRO A 452      11.436  38.878  50.946  1.00 14.50           C  
ATOM   3607  O   PRO A 452      10.906  40.003  50.882  1.00 15.87           O  
ATOM   3608  CB  PRO A 452      10.535  37.813  53.013  1.00  7.50           C  
ATOM   3609  CG  PRO A 452      10.816  38.013  54.378  1.00  7.70           C  
ATOM   3610  CD  PRO A 452      11.562  39.292  54.477  1.00  8.96           C  
ATOM   3611  N   SER A 453      11.723  38.149  49.875  1.00 15.13           N  
ATOM   3612  CA  SER A 453      11.436  38.661  48.541  1.00 15.27           C  
ATOM   3613  C   SER A 453      10.883  37.645  47.599  1.00 16.27           C  
ATOM   3614  O   SER A 453      11.417  36.545  47.518  1.00 22.94           O  
ATOM   3615  CB  SER A 453      12.697  39.259  47.924  1.00 17.56           C  
ATOM   3616  OG  SER A 453      13.836  38.449  48.197  1.00 19.52           O  
ATOM   3617  N   GLN A 454       9.843  38.034  46.862  1.00 17.31           N  
ATOM   3618  CA  GLN A 454       9.215  37.171  45.859  1.00 16.14           C  
ATOM   3619  C   GLN A 454       9.364  37.847  44.503  1.00  7.89           C  
ATOM   3620  O   GLN A 454       8.657  38.795  44.214  1.00 10.55           O  
ATOM   3621  CB  GLN A 454       7.732  36.918  46.177  1.00 17.66           C  
ATOM   3622  CG  GLN A 454       7.057  35.864  45.274  1.00 27.41           C  
ATOM   3623  CD  GLN A 454       7.488  34.434  45.583  1.00 32.53           C  
ATOM   3624  OE1 GLN A 454       7.168  33.910  46.646  1.00 38.70           O  
ATOM   3625  NE2 GLN A 454       8.213  33.801  44.656  1.00 25.40           N  
ATOM   3626  N   VAL A 455      10.280  37.324  43.686  1.00  6.58           N  
ATOM   3627  CA  VAL A 455      10.606  37.853  42.361  1.00 12.29           C  
ATOM   3628  C   VAL A 455       9.818  37.152  41.243  1.00 13.55           C  
ATOM   3629  O   VAL A 455      10.247  36.140  40.691  1.00 24.37           O  
ATOM   3630  CB  VAL A 455      12.162  37.744  42.114  1.00 11.07           C  
ATOM   3631  CG1 VAL A 455      12.523  38.179  40.706  1.00  9.54           C  
ATOM   3632  CG2 VAL A 455      12.975  38.575  43.191  1.00  7.09           C  
ATOM   3633  N   ILE A 456       8.663  37.698  40.893  1.00 18.25           N  
ATOM   3634  CA  ILE A 456       7.822  37.116  39.844  1.00 15.72           C  
ATOM   3635  C   ILE A 456       8.312  37.621  38.482  1.00 19.89           C  
ATOM   3636  O   ILE A 456       8.438  38.836  38.305  1.00 18.88           O  
ATOM   3637  CB  ILE A 456       6.349  37.517  40.058  1.00 11.18           C  
ATOM   3638  CG1 ILE A 456       5.941  37.222  41.504  1.00  2.85           C  
ATOM   3639  CG2 ILE A 456       5.444  36.819  39.029  1.00 12.03           C  
ATOM   3640  CD1 ILE A 456       4.521  37.588  41.872  1.00  7.22           C  
ATOM   3641  N   LEU A 457       8.673  36.696  37.574  1.00 21.86           N  
ATOM   3642  CA  LEU A 457       9.137  37.042  36.211  1.00 23.91           C  
ATOM   3643  C   LEU A 457       7.923  37.216  35.305  1.00 25.92           C  
ATOM   3644  O   LEU A 457       6.936  36.491  35.464  1.00 23.10           O  
ATOM   3645  CB  LEU A 457      10.048  35.951  35.637  1.00 23.52           C  
ATOM   3646  CG  LEU A 457      11.492  35.815  36.151  1.00 17.39           C  
ATOM   3647  CD1 LEU A 457      12.231  34.709  35.404  1.00 14.03           C  
ATOM   3648  CD2 LEU A 457      12.246  37.120  35.937  1.00 30.11           C  
ATOM   3649  N   ASN A 458       7.979  38.177  34.380  1.00 26.76           N  
ATOM   3650  CA  ASN A 458       6.864  38.426  33.457  1.00 36.13           C  
ATOM   3651  C   ASN A 458       6.724  37.303  32.454  1.00 34.15           C  
ATOM   3652  O   ASN A 458       5.639  37.033  31.935  1.00 29.49           O  
ATOM   3653  CB  ASN A 458       7.052  39.744  32.718  1.00 46.16           C  
ATOM   3654  CG  ASN A 458       6.386  40.902  33.426  1.00 54.92           C  
ATOM   3655  OD1 ASN A 458       5.188  41.132  33.254  1.00 60.93           O  
ATOM   3656  ND2 ASN A 458       7.141  41.633  34.227  1.00 53.71           N  
ATOM   3657  N   ARG A 459       7.852  36.635  32.233  1.00 38.44           N  
ATOM   3658  CA  ARG A 459       7.962  35.501  31.324  1.00 40.83           C  
ATOM   3659  C   ARG A 459       7.155  34.292  31.828  1.00 41.33           C  
ATOM   3660  O   ARG A 459       6.531  33.593  31.037  1.00 42.47           O  
ATOM   3661  CB  ARG A 459       9.427  35.132  31.198  1.00 45.98           C  
ATOM   3662  CG  ARG A 459       9.851  34.724  29.817  1.00 63.83           C  
ATOM   3663  CD  ARG A 459      11.322  34.388  29.857  1.00 77.38           C  
ATOM   3664  NE  ARG A 459      11.800  33.715  28.652  1.00 85.57           N  
ATOM   3665  CZ  ARG A 459      12.739  32.770  28.651  1.00 94.39           C  
ATOM   3666  NH1 ARG A 459      13.296  32.377  29.796  1.00100.49           N  
ATOM   3667  NH2 ARG A 459      13.164  32.247  27.503  1.00 97.74           N  
ATOM   3668  N   THR A 460       7.138  34.113  33.153  1.00 41.10           N  
ATOM   3669  CA  THR A 460       6.417  33.052  33.862  1.00 33.94           C  
ATOM   3670  C   THR A 460       4.892  33.140  33.661  1.00 33.24           C  
ATOM   3671  O   THR A 460       4.265  32.138  33.355  1.00 36.75           O  
ATOM   3672  CB  THR A 460       6.745  33.147  35.352  1.00 35.82           C  
ATOM   3673  OG1 THR A 460       8.166  33.118  35.508  1.00 35.23           O  
ATOM   3674  CG2 THR A 460       6.138  32.005  36.148  1.00 35.03           C  
ATOM   3675  N   LEU A 461       4.316  34.335  33.807  1.00 30.92           N  
ATOM   3676  CA  LEU A 461       2.863  34.564  33.619  1.00 38.47           C  
ATOM   3677  C   LEU A 461       2.402  34.379  32.170  1.00 35.31           C  
ATOM   3678  O   LEU A 461       1.237  34.054  31.883  1.00 33.55           O  
ATOM   3679  CB  LEU A 461       2.513  35.985  34.042  1.00 34.95           C  
ATOM   3680  CG  LEU A 461       2.874  36.320  35.472  1.00 23.70           C  
ATOM   3681  CD1 LEU A 461       3.014  37.828  35.588  1.00 32.85           C  
ATOM   3682  CD2 LEU A 461       1.813  35.776  36.396  1.00 23.77           C  
ATOM   3683  N   LYS A 462       3.339  34.691  31.279  1.00 42.48           N  
ATOM   3684  CA  LYS A 462       3.191  34.584  29.834  1.00 50.14           C  
ATOM   3685  C   LYS A 462       3.175  33.105  29.408  1.00 50.85           C  
ATOM   3686  O   LYS A 462       2.287  32.662  28.679  1.00 50.94           O  
ATOM   3687  CB  LYS A 462       4.385  35.285  29.161  1.00 51.04           C  
ATOM   3688  CG  LYS A 462       4.205  36.751  28.909  1.00 46.58           C  
ATOM   3689  CD  LYS A 462       3.527  36.957  27.574  1.00 50.20           C  
ATOM   3690  CE  LYS A 462       4.496  37.528  26.548  1.00 61.27           C  
ATOM   3691  NZ  LYS A 462       3.770  37.980  25.308  1.00 62.15           N  
ATOM   3692  N   ASN A 463       4.111  32.348  29.975  1.00 51.91           N  
ATOM   3693  CA  ASN A 463       4.317  30.946  29.663  1.00 52.50           C  
ATOM   3694  C   ASN A 463       3.596  29.850  30.457  1.00 56.78           C  
ATOM   3695  O   ASN A 463       3.230  28.819  29.873  1.00 58.34           O  
ATOM   3696  CB  ASN A 463       5.809  30.663  29.694  1.00 58.18           C  
ATOM   3697  CG  ASN A 463       6.578  31.458  28.664  1.00 59.01           C  
ATOM   3698  OD1 ASN A 463       6.117  31.670  27.539  1.00 55.75           O  
ATOM   3699  ND2 ASN A 463       7.785  31.867  29.034  1.00 61.57           N  
ATOM   3700  N   GLU A 464       3.490  29.993  31.784  1.00 54.35           N  
ATOM   3701  CA  GLU A 464       2.813  28.968  32.596  1.00 51.33           C  
ATOM   3702  C   GLU A 464       1.353  29.274  32.827  1.00 41.70           C  
ATOM   3703  O   GLU A 464       0.880  30.390  32.569  1.00 38.88           O  
ATOM   3704  CB  GLU A 464       3.522  28.734  33.936  1.00 53.70           C  
ATOM   3705  CG  GLU A 464       4.776  27.861  33.865  1.00 61.56           C  
ATOM   3706  CD  GLU A 464       5.569  27.766  35.190  1.00 63.42           C  
ATOM   3707  OE1 GLU A 464       5.124  28.308  36.243  1.00 55.87           O  
ATOM   3708  OE2 GLU A 464       6.660  27.139  35.160  1.00 64.18           O  
ATOM   3709  N   ASN A 465       0.636  28.246  33.263  1.00 45.17           N  
ATOM   3710  CA  ASN A 465      -0.778  28.361  33.559  1.00 46.75           C  
ATOM   3711  C   ASN A 465      -0.913  29.121  34.880  1.00 44.34           C  
ATOM   3712  O   ASN A 465      -0.381  28.705  35.915  1.00 48.46           O  
ATOM   3713  CB  ASN A 465      -1.407  26.976  33.637  1.00 44.44           C  
ATOM   3714  CG  ASN A 465      -2.900  27.032  33.710  1.00 46.74           C  
ATOM   3715  OD1 ASN A 465      -3.492  26.834  34.779  1.00 48.89           O  
ATOM   3716  ND2 ASN A 465      -3.527  27.356  32.581  1.00 50.46           N  
ATOM   3717  N   LEU A 466      -1.632  30.239  34.803  1.00 44.86           N  
ATOM   3718  CA  LEU A 466      -1.855  31.165  35.915  1.00 49.59           C  
ATOM   3719  C   LEU A 466      -2.232  30.602  37.290  1.00 48.34           C  
ATOM   3720  O   LEU A 466      -1.847  31.177  38.310  1.00 45.14           O  
ATOM   3721  CB  LEU A 466      -2.816  32.301  35.504  1.00 51.04           C  
ATOM   3722  CG  LEU A 466      -2.521  33.244  34.316  1.00 55.19           C  
ATOM   3723  CD1 LEU A 466      -3.622  34.326  34.301  1.00 51.50           C  
ATOM   3724  CD2 LEU A 466      -1.102  33.873  34.349  1.00 33.75           C  
ATOM   3725  N   LYS A 467      -2.912  29.457  37.326  1.00 48.89           N  
ATOM   3726  CA  LYS A 467      -3.272  28.848  38.605  1.00 49.28           C  
ATOM   3727  C   LYS A 467      -2.064  28.221  39.272  1.00 47.39           C  
ATOM   3728  O   LYS A 467      -1.921  28.319  40.489  1.00 47.31           O  
ATOM   3729  CB  LYS A 467      -4.370  27.795  38.446  1.00 51.55           C  
ATOM   3730  CG  LYS A 467      -5.761  28.387  38.383  1.00 65.51           C  
ATOM   3731  CD  LYS A 467      -6.828  27.338  38.128  1.00 66.19           C  
ATOM   3732  CE  LYS A 467      -8.074  28.000  37.567  1.00 68.45           C  
ATOM   3733  NZ  LYS A 467      -8.993  27.044  36.905  1.00 66.29           N  
ATOM   3734  N   PHE A 468      -1.165  27.659  38.461  1.00 40.92           N  
ATOM   3735  CA  PHE A 468       0.025  27.002  38.988  1.00 39.47           C  
ATOM   3736  C   PHE A 468       0.996  28.005  39.495  1.00 40.92           C  
ATOM   3737  O   PHE A 468       1.623  27.763  40.523  1.00 41.49           O  
ATOM   3738  CB  PHE A 468       0.715  26.114  37.959  1.00 46.23           C  
ATOM   3739  CG  PHE A 468      -0.183  25.092  37.333  1.00 51.43           C  
ATOM   3740  CD1 PHE A 468      -1.428  24.721  37.930  1.00 55.24           C  
ATOM   3741  CD2 PHE A 468       0.158  24.544  36.086  1.00 60.10           C  
ATOM   3742  CE1 PHE A 468      -2.324  23.835  37.285  1.00 58.88           C  
ATOM   3743  CE2 PHE A 468      -0.724  23.647  35.422  1.00 64.93           C  
ATOM   3744  CZ  PHE A 468      -1.974  23.299  36.019  1.00 61.26           C  
ATOM   3745  N   VAL A 469       1.084  29.143  38.804  1.00 35.31           N  
ATOM   3746  CA  VAL A 469       1.967  30.245  39.197  1.00 27.28           C  
ATOM   3747  C   VAL A 469       1.443  30.818  40.496  1.00 25.05           C  
ATOM   3748  O   VAL A 469       2.191  30.948  41.441  1.00 25.71           O  
ATOM   3749  CB  VAL A 469       2.011  31.362  38.150  1.00 26.47           C  
ATOM   3750  CG1 VAL A 469       3.128  32.374  38.495  1.00 19.77           C  
ATOM   3751  CG2 VAL A 469       2.218  30.764  36.759  1.00 27.12           C  
ATOM   3752  N   LEU A 470       0.127  31.021  40.553  1.00 27.27           N  
ATOM   3753  CA  LEU A 470      -0.575  31.530  41.734  1.00 21.07           C  
ATOM   3754  C   LEU A 470      -0.280  30.598  42.907  1.00 22.11           C  
ATOM   3755  O   LEU A 470       0.086  31.054  43.973  1.00 14.74           O  
ATOM   3756  CB  LEU A 470      -2.073  31.558  41.455  1.00 30.19           C  
ATOM   3757  CG  LEU A 470      -3.149  32.034  42.441  1.00 37.16           C  
ATOM   3758  CD1 LEU A 470      -3.431  33.489  42.208  1.00 36.17           C  
ATOM   3759  CD2 LEU A 470      -4.467  31.239  42.205  1.00 44.39           C  
ATOM   3760  N   LEU A 471      -0.317  29.289  42.658  1.00 22.07           N  
ATOM   3761  CA  LEU A 471      -0.039  28.303  43.702  1.00 22.73           C  
ATOM   3762  C   LEU A 471       1.421  28.263  44.092  1.00 25.27           C  
ATOM   3763  O   LEU A 471       1.745  28.323  45.293  1.00 28.09           O  
ATOM   3764  CB  LEU A 471      -0.541  26.908  43.321  1.00 21.57           C  
ATOM   3765  CG  LEU A 471      -2.069  26.823  43.477  1.00 24.84           C  
ATOM   3766  CD1 LEU A 471      -2.576  25.577  42.858  1.00 24.43           C  
ATOM   3767  CD2 LEU A 471      -2.508  26.877  44.917  1.00 16.70           C  
ATOM   3768  N   ASN A 472       2.289  28.249  43.073  1.00 20.57           N  
ATOM   3769  CA  ASN A 472       3.742  28.230  43.252  1.00 21.15           C  
ATOM   3770  C   ASN A 472       4.118  29.394  44.150  1.00 23.64           C  
ATOM   3771  O   ASN A 472       4.698  29.202  45.233  1.00 22.15           O  
ATOM   3772  CB  ASN A 472       4.454  28.326  41.893  1.00 20.99           C  
ATOM   3773  CG  ASN A 472       5.980  28.112  41.986  1.00 35.12           C  
ATOM   3774  OD1 ASN A 472       6.670  28.727  42.811  1.00 41.04           O  
ATOM   3775  ND2 ASN A 472       6.516  27.266  41.104  1.00 42.73           N  
ATOM   3776  N   VAL A 473       3.571  30.553  43.797  1.00 14.67           N  
ATOM   3777  CA  VAL A 473       3.824  31.790  44.521  1.00 22.83           C  
ATOM   3778  C   VAL A 473       3.250  31.759  45.950  1.00 21.74           C  
ATOM   3779  O   VAL A 473       3.964  32.076  46.900  1.00 16.14           O  
ATOM   3780  CB  VAL A 473       3.311  33.003  43.665  1.00 20.34           C  
ATOM   3781  CG1 VAL A 473       3.250  34.304  44.457  1.00 27.80           C  
ATOM   3782  CG2 VAL A 473       4.215  33.168  42.436  1.00 24.72           C  
ATOM   3783  N   ALA A 474       1.998  31.298  46.069  1.00 22.53           N  
ATOM   3784  CA  ALA A 474       1.253  31.188  47.333  1.00 16.77           C  
ATOM   3785  C   ALA A 474       2.050  30.487  48.414  1.00 13.80           C  
ATOM   3786  O   ALA A 474       2.365  31.097  49.435  1.00 13.15           O  
ATOM   3787  CB  ALA A 474      -0.071  30.428  47.103  1.00 19.66           C  
ATOM   3788  N   GLU A 475       2.443  29.241  48.105  1.00 14.60           N  
ATOM   3789  CA  GLU A 475       3.239  28.347  48.966  1.00 11.13           C  
ATOM   3790  C   GLU A 475       4.519  29.006  49.456  1.00  6.76           C  
ATOM   3791  O   GLU A 475       4.857  28.895  50.628  1.00  4.55           O  
ATOM   3792  CB  GLU A 475       3.587  27.069  48.167  1.00 18.62           C  
ATOM   3793  CG  GLU A 475       4.500  26.027  48.867  1.00 16.13           C  
ATOM   3794  CD  GLU A 475       5.010  24.924  47.937  1.00 17.33           C  
ATOM   3795  OE1 GLU A 475       5.387  25.203  46.763  1.00 16.15           O  
ATOM   3796  OE2 GLU A 475       5.064  23.762  48.396  1.00 16.67           O  
ATOM   3797  N   GLN A 476       5.179  29.732  48.551  1.00  6.79           N  
ATOM   3798  CA  GLN A 476       6.438  30.417  48.849  1.00  9.20           C  
ATOM   3799  C   GLN A 476       6.335  31.688  49.683  1.00 11.67           C  
ATOM   3800  O   GLN A 476       7.199  31.931  50.520  1.00 10.32           O  
ATOM   3801  CB  GLN A 476       7.184  30.726  47.583  1.00  4.41           C  
ATOM   3802  CG  GLN A 476       7.954  29.609  47.034  1.00  8.90           C  
ATOM   3803  CD  GLN A 476       8.800  30.103  45.901  1.00 22.94           C  
ATOM   3804  OE1 GLN A 476       8.334  30.210  44.759  1.00 25.50           O  
ATOM   3805  NE2 GLN A 476      10.045  30.470  46.212  1.00 18.88           N  
ATOM   3806  N   VAL A 477       5.318  32.514  49.427  1.00  9.98           N  
ATOM   3807  CA  VAL A 477       5.065  33.753  50.182  1.00 12.94           C  
ATOM   3808  C   VAL A 477       4.681  33.405  51.625  1.00 16.12           C  
ATOM   3809  O   VAL A 477       4.998  34.150  52.549  1.00 13.31           O  
ATOM   3810  CB  VAL A 477       3.944  34.584  49.497  1.00 10.61           C  
ATOM   3811  CG1 VAL A 477       3.247  35.539  50.474  1.00  9.96           C  
ATOM   3812  CG2 VAL A 477       4.542  35.362  48.342  1.00 12.87           C  
ATOM   3813  N   LEU A 478       3.994  32.273  51.792  1.00 11.70           N  
ATOM   3814  CA  LEU A 478       3.571  31.795  53.095  1.00 15.55           C  
ATOM   3815  C   LEU A 478       4.767  31.391  53.959  1.00 19.45           C  
ATOM   3816  O   LEU A 478       4.895  31.825  55.112  1.00 15.77           O  
ATOM   3817  CB  LEU A 478       2.624  30.623  52.927  1.00  8.96           C  
ATOM   3818  CG  LEU A 478       1.248  30.983  52.386  1.00 14.09           C  
ATOM   3819  CD1 LEU A 478       0.509  29.707  52.098  1.00 14.76           C  
ATOM   3820  CD2 LEU A 478       0.490  31.860  53.367  1.00  9.53           C  
ATOM   3821  N   ALA A 479       5.695  30.670  53.342  1.00 18.51           N  
ATOM   3822  CA  ALA A 479       6.900  30.204  54.000  1.00 19.66           C  
ATOM   3823  C   ALA A 479       7.783  31.365  54.446  1.00 21.99           C  
ATOM   3824  O   ALA A 479       8.224  31.404  55.606  1.00 27.97           O  
ATOM   3825  CB  ALA A 479       7.663  29.305  53.049  1.00 27.16           C  
ATOM   3826  N   LYS A 480       7.997  32.317  53.533  1.00 21.69           N  
ATOM   3827  CA  LYS A 480       8.828  33.524  53.774  1.00 27.78           C  
ATOM   3828  C   LYS A 480       8.325  34.448  54.890  1.00 31.93           C  
ATOM   3829  O   LYS A 480       9.069  35.293  55.355  1.00 34.54           O  
ATOM   3830  CB  LYS A 480       8.894  34.419  52.531  1.00 28.74           C  
ATOM   3831  CG  LYS A 480       9.712  33.965  51.387  1.00 23.94           C  
ATOM   3832  CD  LYS A 480       9.077  34.581  50.165  1.00 22.34           C  
ATOM   3833  CE  LYS A 480       9.922  34.385  48.939  1.00 25.82           C  
ATOM   3834  NZ  LYS A 480      10.038  33.030  48.400  1.00 26.79           N  
ATOM   3835  N   THR A 481       7.048  34.337  55.259  1.00 29.27           N  
ATOM   3836  CA  THR A 481       6.453  35.221  56.265  1.00 24.37           C  
ATOM   3837  C   THR A 481       6.085  34.522  57.557  1.00 27.05           C  
ATOM   3838  O   THR A 481       5.395  35.098  58.411  1.00 30.62           O  
ATOM   3839  CB  THR A 481       5.219  35.905  55.671  1.00 22.56           C  
ATOM   3840  OG1 THR A 481       4.279  34.906  55.239  1.00 16.55           O  
ATOM   3841  CG2 THR A 481       5.624  36.784  54.488  1.00 14.34           C  
ATOM   3842  N   GLY A 482       6.549  33.275  57.667  1.00 29.17           N  
ATOM   3843  CA  GLY A 482       6.300  32.434  58.830  1.00 26.10           C  
ATOM   3844  C   GLY A 482       4.938  31.759  58.843  1.00 24.58           C  
ATOM   3845  O   GLY A 482       4.673  30.907  59.690  1.00 27.89           O  
ATOM   3846  N   ASN A 483       4.088  32.126  57.886  1.00 27.29           N  
ATOM   3847  CA  ASN A 483       2.747  31.577  57.752  1.00 23.91           C  
ATOM   3848  C   ASN A 483       2.846  30.332  56.871  1.00 25.01           C  
ATOM   3849  O   ASN A 483       2.202  30.220  55.831  1.00 19.99           O  
ATOM   3850  CB  ASN A 483       1.820  32.643  57.160  1.00 26.34           C  
ATOM   3851  CG  ASN A 483       1.955  34.009  57.864  1.00 26.39           C  
ATOM   3852  OD1 ASN A 483       1.449  34.201  58.958  1.00 36.67           O  
ATOM   3853  ND2 ASN A 483       2.650  34.939  57.238  1.00 26.89           N  
ATOM   3854  N   ILE A 484       3.677  29.392  57.331  1.00 22.33           N  
ATOM   3855  CA  ILE A 484       3.968  28.133  56.653  1.00 23.09           C  
ATOM   3856  C   ILE A 484       2.723  27.321  56.240  1.00 25.20           C  
ATOM   3857  O   ILE A 484       1.818  27.086  57.049  1.00 26.52           O  
ATOM   3858  CB  ILE A 484       4.996  27.274  57.460  1.00 23.37           C  
ATOM   3859  CG1 ILE A 484       4.472  26.922  58.855  1.00 23.88           C  
ATOM   3860  CG2 ILE A 484       6.347  28.014  57.547  1.00 17.60           C  
ATOM   3861  CD1 ILE A 484       5.066  25.642  59.420  1.00 13.79           C  
ATOM   3862  N   PRO A 485       2.654  26.903  54.962  1.00 27.28           N  
ATOM   3863  CA  PRO A 485       1.512  26.130  54.453  1.00 30.20           C  
ATOM   3864  C   PRO A 485       1.240  24.784  55.102  1.00 26.26           C  
ATOM   3865  O   PRO A 485       0.083  24.367  55.275  1.00 24.62           O  
ATOM   3866  CB  PRO A 485       1.843  25.974  52.967  1.00 28.25           C  
ATOM   3867  CG  PRO A 485       3.340  26.071  52.932  1.00 33.29           C  
ATOM   3868  CD  PRO A 485       3.641  27.142  53.894  1.00 26.90           C  
ATOM   3869  N   TYR A 486       2.327  24.137  55.480  1.00 21.78           N  
ATOM   3870  CA  TYR A 486       2.276  22.827  56.075  1.00 22.40           C  
ATOM   3871  C   TYR A 486       3.554  22.560  56.843  1.00 26.94           C  
ATOM   3872  O   TYR A 486       4.522  23.334  56.742  1.00 23.40           O  
ATOM   3873  CB  TYR A 486       2.103  21.768  54.961  1.00 20.57           C  
ATOM   3874  CG  TYR A 486       3.099  21.871  53.809  1.00 15.14           C  
ATOM   3875  CD1 TYR A 486       4.390  21.331  53.913  1.00 18.45           C  
ATOM   3876  CD2 TYR A 486       2.782  22.552  52.642  1.00 15.37           C  
ATOM   3877  CE1 TYR A 486       5.339  21.471  52.890  1.00 22.25           C  
ATOM   3878  CE2 TYR A 486       3.734  22.710  51.595  1.00 14.34           C  
ATOM   3879  CZ  TYR A 486       5.007  22.173  51.734  1.00 16.71           C  
ATOM   3880  OH  TYR A 486       5.969  22.364  50.769  1.00 26.89           O  
ATOM   3881  N   LYS A 487       3.569  21.436  57.555  1.00 25.66           N  
ATOM   3882  CA  LYS A 487       4.736  20.963  58.303  1.00 24.14           C  
ATOM   3883  C   LYS A 487       4.613  19.467  58.285  1.00 24.37           C  
ATOM   3884  O   LYS A 487       3.515  18.946  58.103  1.00 28.04           O  
ATOM   3885  CB  LYS A 487       4.807  21.489  59.748  1.00 26.72           C  
ATOM   3886  CG  LYS A 487       3.737  20.991  60.716  1.00 32.00           C  
ATOM   3887  CD  LYS A 487       3.895  21.630  62.081  1.00 29.88           C  
ATOM   3888  CE  LYS A 487       2.891  21.055  63.056  1.00 35.27           C  
ATOM   3889  NZ  LYS A 487       3.205  21.495  64.436  1.00 43.15           N  
ATOM   3890  N   LEU A 488       5.740  18.785  58.463  1.00 27.22           N  
ATOM   3891  CA  LEU A 488       5.806  17.329  58.471  1.00 28.11           C  
ATOM   3892  C   LEU A 488       5.010  16.756  59.640  1.00 35.46           C  
ATOM   3893  O   LEU A 488       4.859  17.414  60.675  1.00 35.55           O  
ATOM   3894  CB  LEU A 488       7.268  16.868  58.535  1.00 22.81           C  
ATOM   3895  CG  LEU A 488       8.148  17.156  57.325  1.00 20.99           C  
ATOM   3896  CD1 LEU A 488       9.572  17.373  57.758  1.00 15.68           C  
ATOM   3897  CD2 LEU A 488       8.046  16.020  56.303  1.00 22.36           C  
ATOM   3898  N   LYS A 489       4.433  15.579  59.416  1.00 37.70           N  
ATOM   3899  CA  LYS A 489       3.627  14.884  60.406  1.00 33.23           C  
ATOM   3900  C   LYS A 489       4.514  14.068  61.324  1.00 36.74           C  
ATOM   3901  O   LYS A 489       4.286  14.019  62.518  1.00 37.40           O  
ATOM   3902  CB  LYS A 489       2.656  13.960  59.682  1.00 41.97           C  
ATOM   3903  CG  LYS A 489       1.861  13.004  60.558  1.00 43.48           C  
ATOM   3904  CD  LYS A 489       1.273  11.942  59.688  1.00 41.47           C  
ATOM   3905  CE  LYS A 489       0.521  10.943  60.481  1.00 44.57           C  
ATOM   3906  NZ  LYS A 489      -0.844  10.789  59.885  1.00 51.51           N  
ATOM   3907  N   GLU A 490       5.498  13.396  60.744  1.00 36.62           N  
ATOM   3908  CA  GLU A 490       6.396  12.559  61.509  1.00 38.62           C  
ATOM   3909  C   GLU A 490       7.745  12.599  60.811  1.00 40.42           C  
ATOM   3910  O   GLU A 490       7.773  12.748  59.589  1.00 48.03           O  
ATOM   3911  CB  GLU A 490       5.836  11.119  61.495  1.00 37.45           C  
ATOM   3912  CG  GLU A 490       6.501  10.108  62.451  1.00 50.78           C  
ATOM   3913  CD  GLU A 490       6.428  10.515  63.938  1.00 62.82           C  
ATOM   3914  OE1 GLU A 490       5.306  10.793  64.438  1.00 62.85           O  
ATOM   3915  OE2 GLU A 490       7.492  10.567  64.605  1.00 61.36           O  
ATOM   3916  N   ILE A 491       8.838  12.684  61.573  1.00 37.16           N  
ATOM   3917  CA  ILE A 491      10.186  12.598  60.997  1.00 30.44           C  
ATOM   3918  C   ILE A 491      10.677  11.353  61.692  1.00 34.91           C  
ATOM   3919  O   ILE A 491      10.540  11.245  62.919  1.00 34.65           O  
ATOM   3920  CB  ILE A 491      11.130  13.754  61.377  1.00 31.06           C  
ATOM   3921  CG1 ILE A 491      10.807  14.990  60.546  1.00 26.25           C  
ATOM   3922  CG2 ILE A 491      12.603  13.376  61.114  1.00 27.13           C  
ATOM   3923  CD1 ILE A 491      11.586  16.239  60.948  1.00 18.74           C  
ATOM   3924  N   GLU A 492      11.279  10.445  60.925  1.00 35.41           N  
ATOM   3925  CA  GLU A 492      11.790   9.187  61.463  1.00 42.43           C  
ATOM   3926  C   GLU A 492      12.911   9.385  62.477  1.00 43.16           C  
ATOM   3927  O   GLU A 492      13.905  10.038  62.144  1.00 46.84           O  
ATOM   3928  CB  GLU A 492      12.296   8.283  60.324  1.00 41.76           C  
ATOM   3929  CG  GLU A 492      12.657   6.831  60.747  1.00 38.28           C  
ATOM   3930  CD  GLU A 492      13.159   5.964  59.599  1.00 46.99           C  
ATOM   3931  OE1 GLU A 492      12.633   6.118  58.470  1.00 53.21           O  
ATOM   3932  OE2 GLU A 492      14.071   5.122  59.828  1.00 44.13           O  
ATOM   3933  N   GLY A 493      12.667   9.007  63.737  1.00 37.91           N  
ATOM   3934  CA  GLY A 493      13.748   9.063  64.694  1.00 32.37           C  
ATOM   3935  C   GLY A 493      13.870   9.680  66.059  1.00 35.13           C  
ATOM   3936  O   GLY A 493      14.999   9.664  66.566  1.00 37.45           O  
ATOM   3937  N   LYS A 494      12.808  10.197  66.673  1.00 36.58           N  
ATOM   3938  CA  LYS A 494      12.906  10.812  68.033  1.00 39.89           C  
ATOM   3939  C   LYS A 494      14.203  11.620  68.299  1.00 37.52           C  
ATOM   3940  O   LYS A 494      15.179  11.135  68.889  1.00 35.53           O  
ATOM   3941  CB  LYS A 494      12.712   9.767  69.139  1.00 41.54           C  
ATOM   3942  CG  LYS A 494      11.352   9.136  69.187  1.00 50.58           C  
ATOM   3943  CD  LYS A 494      11.411   7.918  70.079  1.00 60.92           C  
ATOM   3944  CE  LYS A 494      10.239   6.972  69.806  1.00 68.17           C  
ATOM   3945  NZ  LYS A 494      10.233   5.726  70.657  1.00 69.05           N  
ATOM   3946  N   VAL A 495      14.245  12.780  67.671  1.00 27.33           N  
ATOM   3947  CA  VAL A 495      15.346  13.704  67.770  1.00 22.44           C  
ATOM   3948  C   VAL A 495      14.656  14.944  68.273  1.00 22.76           C  
ATOM   3949  O   VAL A 495      13.608  15.294  67.752  1.00 23.03           O  
ATOM   3950  CB  VAL A 495      15.914  13.990  66.377  1.00 26.36           C  
ATOM   3951  CG1 VAL A 495      16.855  15.208  66.402  1.00 25.15           C  
ATOM   3952  CG2 VAL A 495      16.589  12.744  65.805  1.00 25.67           C  
ATOM   3953  N   ASP A 496      15.263  15.651  69.221  1.00 23.29           N  
ATOM   3954  CA  ASP A 496      14.634  16.839  69.773  1.00 22.76           C  
ATOM   3955  C   ASP A 496      14.863  18.171  69.019  1.00 27.45           C  
ATOM   3956  O   ASP A 496      14.058  19.099  69.181  1.00 27.60           O  
ATOM   3957  CB  ASP A 496      14.913  16.936  71.284  1.00 20.73           C  
ATOM   3958  CG  ASP A 496      14.424  15.690  72.072  1.00 25.37           C  
ATOM   3959  OD1 ASP A 496      13.839  14.750  71.492  1.00 33.24           O  
ATOM   3960  OD2 ASP A 496      14.638  15.622  73.299  1.00 30.68           O  
ATOM   3961  N   ALA A 497      15.928  18.267  68.202  1.00 24.26           N  
ATOM   3962  CA  ALA A 497      16.244  19.471  67.373  1.00 20.82           C  
ATOM   3963  C   ALA A 497      17.290  19.216  66.292  1.00 20.07           C  
ATOM   3964  O   ALA A 497      18.261  18.478  66.496  1.00 21.18           O  
ATOM   3965  CB  ALA A 497      16.661  20.677  68.207  1.00 15.12           C  
ATOM   3966  N   PHE A 498      17.063  19.833  65.132  1.00 20.40           N  
ATOM   3967  CA  PHE A 498      17.940  19.717  63.959  1.00 18.96           C  
ATOM   3968  C   PHE A 498      18.625  21.052  63.764  1.00 21.92           C  
ATOM   3969  O   PHE A 498      17.979  22.041  63.408  1.00 27.98           O  
ATOM   3970  CB  PHE A 498      17.124  19.361  62.709  1.00 16.99           C  
ATOM   3971  CG  PHE A 498      16.460  18.024  62.790  1.00 17.86           C  
ATOM   3972  CD1 PHE A 498      15.236  17.868  63.453  1.00 20.76           C  
ATOM   3973  CD2 PHE A 498      17.074  16.889  62.265  1.00 23.26           C  
ATOM   3974  CE1 PHE A 498      14.639  16.588  63.595  1.00 21.24           C  
ATOM   3975  CE2 PHE A 498      16.488  15.610  62.401  1.00 16.02           C  
ATOM   3976  CZ  PHE A 498      15.271  15.463  63.066  1.00 14.30           C  
ATOM   3977  N   VAL A 499      19.906  21.121  64.093  1.00 12.09           N  
ATOM   3978  CA  VAL A 499      20.600  22.377  63.936  1.00  9.27           C  
ATOM   3979  C   VAL A 499      21.525  22.340  62.730  1.00 11.21           C  
ATOM   3980  O   VAL A 499      22.305  21.414  62.572  1.00  9.23           O  
ATOM   3981  CB  VAL A 499      21.249  22.878  65.276  1.00  5.33           C  
ATOM   3982  CG1 VAL A 499      20.765  22.057  66.434  1.00  2.99           C  
ATOM   3983  CG2 VAL A 499      22.737  22.881  65.251  1.00  4.64           C  
ATOM   3984  N   GLY A 500      21.372  23.312  61.837  1.00 14.94           N  
ATOM   3985  CA  GLY A 500      22.228  23.357  60.664  1.00 12.69           C  
ATOM   3986  C   GLY A 500      23.154  24.550  60.702  1.00 10.93           C  
ATOM   3987  O   GLY A 500      22.681  25.662  60.946  1.00  6.26           O  
ATOM   3988  N   ILE A 501      24.455  24.310  60.518  1.00 13.31           N  
ATOM   3989  CA  ILE A 501      25.447  25.387  60.551  1.00 19.03           C  
ATOM   3990  C   ILE A 501      26.394  25.451  59.335  1.00 16.36           C  
ATOM   3991  O   ILE A 501      26.563  24.456  58.626  1.00 19.71           O  
ATOM   3992  CB  ILE A 501      26.406  25.279  61.839  1.00 27.51           C  
ATOM   3993  CG1 ILE A 501      25.636  24.850  63.100  1.00 30.90           C  
ATOM   3994  CG2 ILE A 501      27.125  26.639  62.129  1.00 26.73           C  
ATOM   3995  CD1 ILE A 501      26.378  24.993  64.434  1.00 26.86           C  
ATOM   3996  N   ASP A 502      26.838  26.676  59.024  1.00 15.51           N  
ATOM   3997  CA  ASP A 502      27.899  26.955  58.053  1.00 14.30           C  
ATOM   3998  C   ASP A 502      28.561  28.124  58.729  1.00 19.60           C  
ATOM   3999  O   ASP A 502      27.915  28.947  59.400  1.00 22.58           O  
ATOM   4000  CB  ASP A 502      27.521  27.394  56.627  1.00 17.21           C  
ATOM   4001  CG  ASP A 502      28.791  27.435  55.650  1.00 19.79           C  
ATOM   4002  OD1 ASP A 502      29.668  28.319  55.767  1.00 13.57           O  
ATOM   4003  OD2 ASP A 502      28.954  26.558  54.769  1.00 16.07           O  
ATOM   4004  N   ILE A 503      29.883  28.093  58.662  1.00 21.32           N  
ATOM   4005  CA  ILE A 503      30.736  29.120  59.199  1.00 18.47           C  
ATOM   4006  C   ILE A 503      31.659  29.382  58.021  1.00 21.58           C  
ATOM   4007  O   ILE A 503      32.214  28.438  57.434  1.00 19.07           O  
ATOM   4008  CB  ILE A 503      31.523  28.618  60.431  1.00 12.28           C  
ATOM   4009  CG1 ILE A 503      30.550  28.251  61.571  1.00 16.86           C  
ATOM   4010  CG2 ILE A 503      32.516  29.690  60.871  1.00 13.99           C  
ATOM   4011  CD1 ILE A 503      31.162  27.717  62.882  1.00 10.42           C  
ATOM   4012  N   SER A 504      31.676  30.639  57.584  1.00 27.97           N  
ATOM   4013  CA  SER A 504      32.522  31.075  56.474  1.00 38.93           C  
ATOM   4014  C   SER A 504      33.391  32.214  56.964  1.00 37.30           C  
ATOM   4015  O   SER A 504      32.908  33.189  57.533  1.00 45.06           O  
ATOM   4016  CB  SER A 504      31.700  31.475  55.243  1.00 43.59           C  
ATOM   4017  OG  SER A 504      31.181  30.314  54.600  1.00 45.94           O  
ATOM   4018  N   ARG A 505      34.685  32.078  56.722  1.00 47.58           N  
ATOM   4019  CA  ARG A 505      35.682  33.047  57.166  1.00 51.30           C  
ATOM   4020  C   ARG A 505      36.406  33.814  56.062  1.00 46.24           C  
ATOM   4021  O   ARG A 505      36.416  33.399  54.901  1.00 44.93           O  
ATOM   4022  CB  ARG A 505      36.745  32.311  58.009  1.00 61.54           C  
ATOM   4023  CG  ARG A 505      36.212  31.494  59.198  1.00 61.35           C  
ATOM   4024  CD  ARG A 505      36.921  30.157  59.318  1.00 63.12           C  
ATOM   4025  NE  ARG A 505      36.344  29.317  60.367  1.00 73.21           N  
ATOM   4026  CZ  ARG A 505      36.936  29.046  61.528  1.00 73.91           C  
ATOM   4027  NH1 ARG A 505      38.143  29.549  61.814  1.00 71.23           N  
ATOM   4028  NH2 ARG A 505      36.314  28.265  62.407  1.00 75.51           N  
ATOM   4029  N   ILE A 506      36.958  34.968  56.415  1.00 45.14           N  
ATOM   4030  CA  ILE A 506      37.748  35.686  55.437  1.00 50.18           C  
ATOM   4031  C   ILE A 506      39.214  35.510  55.829  1.00 58.65           C  
ATOM   4032  O   ILE A 506      39.623  35.740  56.977  1.00 47.74           O  
ATOM   4033  CB  ILE A 506      37.289  37.156  55.167  1.00 47.74           C  
ATOM   4034  CG1 ILE A 506      36.133  37.122  54.151  1.00 50.72           C  
ATOM   4035  CG2 ILE A 506      38.415  37.983  54.527  1.00 52.21           C  
ATOM   4036  CD1 ILE A 506      35.535  38.460  53.782  1.00 50.74           C  
ATOM   4037  N   THR A 507      39.936  34.939  54.864  1.00 62.15           N  
ATOM   4038  CA  THR A 507      41.352  34.639  54.970  1.00 69.18           C  
ATOM   4039  C   THR A 507      42.201  35.809  54.448  1.00 77.04           C  
ATOM   4040  O   THR A 507      42.008  36.327  53.326  1.00 77.64           O  
ATOM   4041  CB  THR A 507      41.697  33.358  54.155  1.00 66.87           C  
ATOM   4042  OG1 THR A 507      40.669  32.372  54.313  1.00 65.93           O  
ATOM   4043  CG2 THR A 507      43.029  32.768  54.624  1.00 70.32           C  
ATOM   4044  N   ARG A 508      43.080  36.275  55.337  1.00 81.32           N  
ATOM   4045  CA  ARG A 508      44.033  37.343  55.040  1.00 86.18           C  
ATOM   4046  C   ARG A 508      45.356  36.940  55.659  1.00 89.74           C  
ATOM   4047  O   ARG A 508      45.561  37.056  56.873  1.00 93.78           O  
ATOM   4048  CB  ARG A 508      43.581  38.697  55.565  1.00 85.64           C  
ATOM   4049  CG  ARG A 508      42.757  39.496  54.591  1.00 86.62           C  
ATOM   4050  CD  ARG A 508      42.706  40.928  55.045  1.00 91.97           C  
ATOM   4051  NE  ARG A 508      41.504  41.592  54.561  1.00 99.57           N  
ATOM   4052  CZ  ARG A 508      41.013  42.729  55.048  1.00 96.62           C  
ATOM   4053  NH1 ARG A 508      41.622  43.366  56.048  1.00 94.80           N  
ATOM   4054  NH2 ARG A 508      39.877  43.200  54.552  1.00 98.28           N  
ATOM   4055  N   ASP A 509      46.229  36.422  54.786  1.00 93.62           N  
ATOM   4056  CA  ASP A 509      47.582  35.914  55.093  1.00 95.93           C  
ATOM   4057  C   ASP A 509      47.573  34.543  55.780  1.00102.28           C  
ATOM   4058  O   ASP A 509      47.640  33.506  55.091  1.00 97.47           O  
ATOM   4059  CB  ASP A 509      48.444  36.919  55.884  1.00 98.96           C  
ATOM   4060  CG  ASP A 509      48.918  38.103  55.048  1.00 98.02           C  
ATOM   4061  OD1 ASP A 509      48.197  38.503  54.106  1.00101.26           O  
ATOM   4062  OD2 ASP A 509      50.008  38.640  55.338  1.00 99.62           O  
ATOM   4063  N   GLY A 510      47.426  34.549  57.106  1.00 99.45           N  
ATOM   4064  CA  GLY A 510      47.447  33.312  57.871  1.00100.32           C  
ATOM   4065  C   GLY A 510      46.344  33.073  58.879  1.00100.49           C  
ATOM   4066  O   GLY A 510      45.696  32.025  58.799  1.00 99.77           O  
ATOM   4067  N   LYS A 511      46.177  33.986  59.848  1.00 99.63           N  
ATOM   4068  CA  LYS A 511      45.135  33.864  60.882  1.00 95.75           C  
ATOM   4069  C   LYS A 511      43.850  34.674  60.598  1.00 95.70           C  
ATOM   4070  O   LYS A 511      43.905  35.804  60.089  1.00 94.15           O  
ATOM   4071  CB  LYS A 511      45.718  34.103  62.293  1.00102.61           C  
ATOM   4072  CG  LYS A 511      46.394  32.834  62.883  1.00103.87           C  
ATOM   4073  CD  LYS A 511      47.813  33.080  63.438  1.00105.79           C  
ATOM   4074  CE  LYS A 511      48.578  31.760  63.694  1.00105.34           C  
ATOM   4075  NZ  LYS A 511      49.976  31.994  64.184  1.00 99.16           N  
ATOM   4076  N   THR A 512      42.705  34.033  60.876  1.00 92.64           N  
ATOM   4077  CA  THR A 512      41.347  34.553  60.634  1.00 86.35           C  
ATOM   4078  C   THR A 512      40.979  35.951  61.134  1.00 81.33           C  
ATOM   4079  O   THR A 512      40.970  36.233  62.344  1.00 81.83           O  
ATOM   4080  CB  THR A 512      40.239  33.566  61.136  1.00 86.84           C  
ATOM   4081  OG1 THR A 512      40.575  32.212  60.806  1.00 85.72           O  
ATOM   4082  CG2 THR A 512      38.908  33.895  60.489  1.00 83.12           C  
ATOM   4083  N   VAL A 513      40.547  36.754  60.162  1.00 79.20           N  
ATOM   4084  CA  VAL A 513      40.119  38.134  60.343  1.00 71.59           C  
ATOM   4085  C   VAL A 513      38.607  38.196  60.652  1.00 71.35           C  
ATOM   4086  O   VAL A 513      38.209  38.294  61.818  1.00 64.93           O  
ATOM   4087  CB  VAL A 513      40.492  38.950  59.074  1.00 78.46           C  
ATOM   4088  CG1 VAL A 513      39.966  40.399  59.140  1.00 82.29           C  
ATOM   4089  CG2 VAL A 513      41.997  38.949  58.915  1.00 77.69           C  
ATOM   4090  N   ASN A 514      37.781  38.145  59.607  1.00 60.35           N  
ATOM   4091  CA  ASN A 514      36.335  38.185  59.767  1.00 53.70           C  
ATOM   4092  C   ASN A 514      35.745  36.780  59.561  1.00 47.30           C  
ATOM   4093  O   ASN A 514      36.327  35.942  58.851  1.00 41.44           O  
ATOM   4094  CB  ASN A 514      35.724  39.216  58.803  1.00 50.15           C  
ATOM   4095  CG  ASN A 514      34.254  39.551  59.127  1.00 50.91           C  
ATOM   4096  OD1 ASN A 514      33.737  39.247  60.217  1.00 38.31           O  
ATOM   4097  ND2 ASN A 514      33.582  40.195  58.171  1.00 52.99           N  
ATOM   4098  N   ALA A 515      34.621  36.547  60.248  1.00 44.72           N  
ATOM   4099  CA  ALA A 515      33.858  35.291  60.229  1.00 39.58           C  
ATOM   4100  C   ALA A 515      32.387  35.529  60.529  1.00 33.56           C  
ATOM   4101  O   ALA A 515      32.034  36.363  61.354  1.00 33.83           O  
ATOM   4102  CB  ALA A 515      34.415  34.293  61.252  1.00 41.20           C  
ATOM   4103  N   VAL A 516      31.538  34.780  59.840  1.00 31.51           N  
ATOM   4104  CA  VAL A 516      30.093  34.844  60.003  1.00 26.71           C  
ATOM   4105  C   VAL A 516      29.596  33.405  60.209  1.00 29.29           C  
ATOM   4106  O   VAL A 516      30.009  32.487  59.473  1.00 21.48           O  
ATOM   4107  CB  VAL A 516      29.395  35.447  58.725  1.00 30.42           C  
ATOM   4108  CG1 VAL A 516      27.882  35.432  58.883  1.00 20.41           C  
ATOM   4109  CG2 VAL A 516      29.861  36.885  58.459  1.00 25.08           C  
ATOM   4110  N   ALA A 517      28.700  33.229  61.190  1.00 17.72           N  
ATOM   4111  CA  ALA A 517      28.084  31.929  61.501  1.00 18.86           C  
ATOM   4112  C   ALA A 517      26.588  32.008  61.313  1.00 24.55           C  
ATOM   4113  O   ALA A 517      25.941  32.927  61.838  1.00 24.32           O  
ATOM   4114  CB  ALA A 517      28.368  31.509  62.946  1.00 13.76           C  
ATOM   4115  N   PHE A 518      26.036  31.051  60.569  1.00 17.93           N  
ATOM   4116  CA  PHE A 518      24.595  31.003  60.386  1.00 18.72           C  
ATOM   4117  C   PHE A 518      23.974  29.668  60.821  1.00 22.38           C  
ATOM   4118  O   PHE A 518      24.004  28.667  60.085  1.00 19.78           O  
ATOM   4119  CB  PHE A 518      24.186  31.378  58.957  1.00 20.65           C  
ATOM   4120  CG  PHE A 518      22.678  31.527  58.756  1.00 23.08           C  
ATOM   4121  CD1 PHE A 518      21.878  32.214  59.701  1.00 18.68           C  
ATOM   4122  CD2 PHE A 518      22.055  30.981  57.616  1.00 29.42           C  
ATOM   4123  CE1 PHE A 518      20.500  32.361  59.533  1.00 17.79           C  
ATOM   4124  CE2 PHE A 518      20.659  31.127  57.433  1.00 26.69           C  
ATOM   4125  CZ  PHE A 518      19.887  31.828  58.413  1.00 24.29           C  
ATOM   4126  N   THR A 519      23.303  29.730  61.970  1.00 17.72           N  
ATOM   4127  CA  THR A 519      22.631  28.585  62.595  1.00 17.82           C  
ATOM   4128  C   THR A 519      21.116  28.619  62.389  1.00 15.96           C  
ATOM   4129  O   THR A 519      20.489  29.697  62.361  1.00 15.06           O  
ATOM   4130  CB  THR A 519      23.010  28.494  64.101  1.00 15.01           C  
ATOM   4131  OG1 THR A 519      24.442  28.405  64.203  1.00 11.46           O  
ATOM   4132  CG2 THR A 519      22.388  27.271  64.786  1.00 13.10           C  
ATOM   4133  N   LYS A 520      20.568  27.423  62.160  1.00 16.67           N  
ATOM   4134  CA  LYS A 520      19.144  27.205  61.930  1.00  9.25           C  
ATOM   4135  C   LYS A 520      18.686  26.041  62.796  1.00  5.91           C  
ATOM   4136  O   LYS A 520      19.064  24.886  62.578  1.00  4.80           O  
ATOM   4137  CB  LYS A 520      18.909  26.866  60.462  1.00  5.59           C  
ATOM   4138  CG  LYS A 520      18.369  27.970  59.637  1.00  2.00           C  
ATOM   4139  CD  LYS A 520      18.182  27.525  58.212  1.00  3.92           C  
ATOM   4140  CE  LYS A 520      19.475  27.622  57.409  1.00 10.37           C  
ATOM   4141  NZ  LYS A 520      19.293  28.276  56.043  1.00 10.38           N  
ATOM   4142  N   ILE A 521      17.912  26.366  63.816  1.00  6.62           N  
ATOM   4143  CA  ILE A 521      17.379  25.357  64.729  1.00 12.97           C  
ATOM   4144  C   ILE A 521      15.954  24.971  64.310  1.00 13.30           C  
ATOM   4145  O   ILE A 521      15.088  25.851  64.160  1.00  6.43           O  
ATOM   4146  CB  ILE A 521      17.392  25.874  66.191  1.00 12.22           C  
ATOM   4147  CG1 ILE A 521      18.809  26.317  66.540  1.00  7.86           C  
ATOM   4148  CG2 ILE A 521      16.952  24.772  67.146  1.00  8.81           C  
ATOM   4149  CD1 ILE A 521      18.885  27.216  67.651  1.00  2.00           C  
ATOM   4150  N   PHE A 522      15.744  23.657  64.140  1.00 12.04           N  
ATOM   4151  CA  PHE A 522      14.452  23.082  63.740  1.00 20.22           C  
ATOM   4152  C   PHE A 522      13.785  22.151  64.777  1.00 23.98           C  
ATOM   4153  O   PHE A 522      14.413  21.735  65.761  1.00 23.84           O  
ATOM   4154  CB  PHE A 522      14.592  22.344  62.405  1.00 18.93           C  
ATOM   4155  CG  PHE A 522      14.711  23.252  61.208  1.00 18.59           C  
ATOM   4156  CD1 PHE A 522      15.971  23.754  60.790  1.00 16.87           C  
ATOM   4157  CD2 PHE A 522      13.561  23.578  60.455  1.00 20.69           C  
ATOM   4158  CE1 PHE A 522      16.082  24.571  59.623  1.00 18.89           C  
ATOM   4159  CE2 PHE A 522      13.637  24.396  59.279  1.00 25.01           C  
ATOM   4160  CZ  PHE A 522      14.919  24.896  58.858  1.00 17.36           C  
ATOM   4161  N   ASN A 523      12.498  21.868  64.518  1.00 32.57           N  
ATOM   4162  CA  ASN A 523      11.559  21.024  65.305  1.00 32.50           C  
ATOM   4163  C   ASN A 523      11.608  19.588  64.809  1.00 29.66           C  
ATOM   4164  O   ASN A 523      12.087  19.337  63.712  1.00 28.49           O  
ATOM   4165  CB  ASN A 523      10.120  21.510  65.029  1.00 33.52           C  
ATOM   4166  CG  ASN A 523       9.282  21.634  66.278  1.00 45.71           C  
ATOM   4167  OD1 ASN A 523       9.336  20.786  67.168  1.00 57.37           O  
ATOM   4168  ND2 ASN A 523       8.481  22.693  66.349  1.00 49.35           N  
ATOM   4169  N   SER A 524      10.999  18.666  65.562  1.00 35.32           N  
ATOM   4170  CA  SER A 524      10.912  17.238  65.182  1.00 33.36           C  
ATOM   4171  C   SER A 524       9.847  17.080  64.097  1.00 33.83           C  
ATOM   4172  O   SER A 524       9.659  15.997  63.535  1.00 35.96           O  
ATOM   4173  CB  SER A 524      10.522  16.385  66.384  1.00 28.55           C  
ATOM   4174  OG  SER A 524       9.266  16.799  66.891  1.00 25.30           O  
ATOM   4175  N   LYS A 525       9.098  18.164  63.883  1.00 37.11           N  
ATOM   4176  CA  LYS A 525       8.050  18.239  62.876  1.00 38.21           C  
ATOM   4177  C   LYS A 525       8.548  19.083  61.676  1.00 35.69           C  
ATOM   4178  O   LYS A 525       7.802  19.402  60.752  1.00 39.34           O  
ATOM   4179  CB  LYS A 525       6.763  18.805  63.496  1.00 36.18           C  
ATOM   4180  CG  LYS A 525       6.212  18.002  64.673  1.00 33.42           C  
ATOM   4181  CD  LYS A 525       5.974  16.551  64.266  1.00 45.10           C  
ATOM   4182  CE  LYS A 525       6.020  15.572  65.440  1.00 47.40           C  
ATOM   4183  NZ  LYS A 525       6.163  14.165  64.934  1.00 49.57           N  
ATOM   4184  N   GLY A 526       9.827  19.453  61.737  1.00 36.63           N  
ATOM   4185  CA  GLY A 526      10.467  20.211  60.681  1.00 28.54           C  
ATOM   4186  C   GLY A 526      10.329  21.721  60.669  1.00 32.70           C  
ATOM   4187  O   GLY A 526      10.957  22.349  59.814  1.00 28.53           O  
ATOM   4188  N   GLU A 527       9.519  22.317  61.555  1.00 27.80           N  
ATOM   4189  CA  GLU A 527       9.339  23.771  61.541  1.00 27.15           C  
ATOM   4190  C   GLU A 527      10.470  24.582  62.166  1.00 30.27           C  
ATOM   4191  O   GLU A 527      11.189  24.085  63.035  1.00 33.32           O  
ATOM   4192  CB  GLU A 527       7.959  24.178  62.059  1.00 28.68           C  
ATOM   4193  CG  GLU A 527       7.739  24.112  63.541  1.00 37.31           C  
ATOM   4194  CD  GLU A 527       6.279  23.968  63.894  1.00 42.21           C  
ATOM   4195  OE1 GLU A 527       5.468  24.818  63.459  1.00 45.65           O  
ATOM   4196  OE2 GLU A 527       5.937  22.990  64.594  1.00 36.63           O  
ATOM   4197  N   LEU A 528      10.658  25.813  61.677  1.00 29.49           N  
ATOM   4198  CA  LEU A 528      11.738  26.673  62.148  1.00 24.39           C  
ATOM   4199  C   LEU A 528      11.521  27.259  63.536  1.00 25.93           C  
ATOM   4200  O   LEU A 528      10.629  28.091  63.764  1.00 21.79           O  
ATOM   4201  CB  LEU A 528      12.044  27.794  61.132  1.00 20.89           C  
ATOM   4202  CG  LEU A 528      13.304  28.644  61.398  1.00 16.92           C  
ATOM   4203  CD1 LEU A 528      14.610  27.843  61.110  1.00 12.67           C  
ATOM   4204  CD2 LEU A 528      13.261  29.921  60.599  1.00  4.64           C  
ATOM   4205  N   VAL A 529      12.364  26.818  64.456  1.00 17.58           N  
ATOM   4206  CA  VAL A 529      12.296  27.316  65.796  1.00 18.55           C  
ATOM   4207  C   VAL A 529      12.977  28.695  65.802  1.00 19.26           C  
ATOM   4208  O   VAL A 529      12.299  29.675  66.077  1.00 24.97           O  
ATOM   4209  CB  VAL A 529      12.923  26.347  66.805  1.00 22.90           C  
ATOM   4210  CG1 VAL A 529      12.811  26.916  68.224  1.00 25.50           C  
ATOM   4211  CG2 VAL A 529      12.222  25.005  66.731  1.00 12.63           C  
ATOM   4212  N   ARG A 530      14.275  28.776  65.482  1.00 20.29           N  
ATOM   4213  CA  ARG A 530      14.990  30.059  65.434  1.00 17.45           C  
ATOM   4214  C   ARG A 530      16.216  29.940  64.592  1.00 19.64           C  
ATOM   4215  O   ARG A 530      16.757  28.850  64.475  1.00 26.07           O  
ATOM   4216  CB  ARG A 530      15.558  30.501  66.794  1.00 27.30           C  
ATOM   4217  CG  ARG A 530      14.645  31.040  67.866  1.00 36.06           C  
ATOM   4218  CD  ARG A 530      13.801  32.239  67.523  1.00 41.83           C  
ATOM   4219  NE  ARG A 530      12.593  32.173  68.345  1.00 42.16           N  
ATOM   4220  CZ  ARG A 530      12.158  33.140  69.146  1.00 51.47           C  
ATOM   4221  NH1 ARG A 530      12.815  34.300  69.239  1.00 56.77           N  
ATOM   4222  NH2 ARG A 530      11.104  32.914  69.927  1.00 55.78           N  
ATOM   4223  N   TYR A 531      16.673  31.064  64.037  1.00 21.92           N  
ATOM   4224  CA  TYR A 531      17.939  31.117  63.296  1.00 18.83           C  
ATOM   4225  C   TYR A 531      18.825  32.084  64.052  1.00 23.28           C  
ATOM   4226  O   TYR A 531      18.327  32.921  64.816  1.00 19.26           O  
ATOM   4227  CB  TYR A 531      17.822  31.549  61.810  1.00 19.68           C  
ATOM   4228  CG  TYR A 531      17.290  32.946  61.466  1.00 23.95           C  
ATOM   4229  CD1 TYR A 531      18.062  34.127  61.661  1.00 24.18           C  
ATOM   4230  CD2 TYR A 531      16.017  33.091  60.892  1.00 25.59           C  
ATOM   4231  CE1 TYR A 531      17.562  35.423  61.293  1.00 28.93           C  
ATOM   4232  CE2 TYR A 531      15.512  34.374  60.516  1.00 34.08           C  
ATOM   4233  CZ  TYR A 531      16.282  35.531  60.717  1.00 30.40           C  
ATOM   4234  OH  TYR A 531      15.761  36.743  60.318  1.00 26.09           O  
ATOM   4235  N   TYR A 532      20.122  32.013  63.798  1.00 22.23           N  
ATOM   4236  CA  TYR A 532      21.052  32.925  64.441  1.00 22.77           C  
ATOM   4237  C   TYR A 532      22.203  33.232  63.498  1.00 15.83           C  
ATOM   4238  O   TYR A 532      22.996  32.363  63.109  1.00 16.13           O  
ATOM   4239  CB  TYR A 532      21.531  32.396  65.797  1.00 20.44           C  
ATOM   4240  CG  TYR A 532      22.225  33.418  66.675  1.00 17.49           C  
ATOM   4241  CD1 TYR A 532      21.551  34.585  67.146  1.00 16.97           C  
ATOM   4242  CD2 TYR A 532      23.568  33.228  67.051  1.00 17.95           C  
ATOM   4243  CE1 TYR A 532      22.226  35.543  67.980  1.00 13.86           C  
ATOM   4244  CE2 TYR A 532      24.244  34.171  67.876  1.00 14.07           C  
ATOM   4245  CZ  TYR A 532      23.577  35.319  68.331  1.00 14.51           C  
ATOM   4246  OH  TYR A 532      24.300  36.225  69.090  1.00 14.57           O  
ATOM   4247  N   LEU A 533      22.253  34.497  63.124  1.00 16.66           N  
ATOM   4248  CA  LEU A 533      23.252  34.990  62.214  1.00 21.52           C  
ATOM   4249  C   LEU A 533      24.120  36.008  62.938  1.00 21.87           C  
ATOM   4250  O   LEU A 533      23.611  37.030  63.383  1.00 24.07           O  
ATOM   4251  CB  LEU A 533      22.521  35.602  61.029  1.00 18.47           C  
ATOM   4252  CG  LEU A 533      23.238  36.175  59.817  1.00 20.97           C  
ATOM   4253  CD1 LEU A 533      24.261  35.209  59.266  1.00 26.66           C  
ATOM   4254  CD2 LEU A 533      22.191  36.507  58.753  1.00 30.22           C  
ATOM   4255  N   THR A 534      25.410  35.701  63.104  1.00 22.67           N  
ATOM   4256  CA  THR A 534      26.328  36.600  63.789  1.00 23.51           C  
ATOM   4257  C   THR A 534      27.625  36.680  63.039  1.00 29.02           C  
ATOM   4258  O   THR A 534      28.108  35.674  62.509  1.00 27.85           O  
ATOM   4259  CB  THR A 534      26.754  36.073  65.173  1.00 21.20           C  
ATOM   4260  OG1 THR A 534      25.668  35.402  65.791  1.00 21.83           O  
ATOM   4261  CG2 THR A 534      27.211  37.200  66.105  1.00 26.26           C  
ATOM   4262  N   SER A 535      28.199  37.884  63.052  1.00 35.07           N  
ATOM   4263  CA  SER A 535      29.513  38.142  62.474  1.00 37.26           C  
ATOM   4264  C   SER A 535      30.396  38.103  63.719  1.00 36.97           C  
ATOM   4265  O   SER A 535      29.987  38.555  64.789  1.00 40.22           O  
ATOM   4266  CB  SER A 535      29.574  39.523  61.836  1.00 37.01           C  
ATOM   4267  OG  SER A 535      30.586  39.608  60.839  1.00 38.76           O  
ATOM   4268  N   TYR A 536      31.569  37.494  63.598  1.00 40.22           N  
ATOM   4269  CA  TYR A 536      32.482  37.360  64.718  1.00 42.57           C  
ATOM   4270  C   TYR A 536      33.831  38.038  64.464  1.00 51.37           C  
ATOM   4271  O   TYR A 536      34.301  38.030  63.311  1.00 50.25           O  
ATOM   4272  CB  TYR A 536      32.686  35.867  65.021  1.00 38.35           C  
ATOM   4273  CG  TYR A 536      31.539  35.180  65.724  1.00 30.13           C  
ATOM   4274  CD1 TYR A 536      30.677  34.314  65.024  1.00 25.06           C  
ATOM   4275  CD2 TYR A 536      31.304  35.399  67.101  1.00 25.99           C  
ATOM   4276  CE1 TYR A 536      29.609  33.688  65.678  1.00 29.48           C  
ATOM   4277  CE2 TYR A 536      30.240  34.783  67.773  1.00 22.45           C  
ATOM   4278  CZ  TYR A 536      29.402  33.932  67.063  1.00 38.65           C  
ATOM   4279  OH  TYR A 536      28.406  33.296  67.752  1.00 39.41           O  
ATOM   4280  N   PRO A 537      34.462  38.638  65.519  1.00 60.25           N  
ATOM   4281  CA  PRO A 537      35.781  39.344  65.440  1.00 66.27           C  
ATOM   4282  C   PRO A 537      36.998  38.425  65.178  1.00 68.71           C  
ATOM   4283  O   PRO A 537      36.852  37.240  64.881  1.00 70.59           O  
ATOM   4284  CB  PRO A 537      35.895  40.007  66.825  1.00 68.49           C  
ATOM   4285  CG  PRO A 537      34.503  40.175  67.264  1.00 65.35           C  
ATOM   4286  CD  PRO A 537      33.859  38.883  66.848  1.00 60.89           C  
ATOM   4287  N   ALA A 538      38.205  38.984  65.341  1.00 76.51           N  
ATOM   4288  CA  ALA A 538      39.441  38.226  65.116  1.00 76.15           C  
ATOM   4289  C   ALA A 538      40.174  37.662  66.332  1.00 79.69           C  
ATOM   4290  O   ALA A 538      40.887  38.393  67.031  1.00 80.78           O  
ATOM   4291  CB  ALA A 538      40.415  39.054  64.240  1.00 74.38           C  
ATOM   4292  N   PHE A 539      39.921  36.383  66.633  1.00 79.57           N  
ATOM   4293  CA  PHE A 539      40.597  35.651  67.715  1.00 83.30           C  
ATOM   4294  C   PHE A 539      40.781  34.196  67.306  1.00 84.37           C  
ATOM   4295  O   PHE A 539      39.917  33.639  66.640  1.00 89.42           O  
ATOM   4296  CB  PHE A 539      39.943  35.753  69.111  1.00 81.16           C  
ATOM   4297  CG  PHE A 539      38.465  36.076  69.131  1.00 81.43           C  
ATOM   4298  CD1 PHE A 539      37.510  35.375  68.365  1.00 82.53           C  
ATOM   4299  CD2 PHE A 539      38.002  37.055  70.025  1.00 82.81           C  
ATOM   4300  CE1 PHE A 539      36.115  35.616  68.480  1.00 80.80           C  
ATOM   4301  CE2 PHE A 539      36.599  37.336  70.175  1.00 89.35           C  
ATOM   4302  CZ  PHE A 539      35.655  36.598  69.384  1.00 80.14           C  
ATOM   4303  N   GLY A 540      41.892  33.597  67.722  1.00 87.59           N  
ATOM   4304  CA  GLY A 540      42.228  32.219  67.364  1.00 86.98           C  
ATOM   4305  C   GLY A 540      41.197  31.107  67.507  1.00 90.13           C  
ATOM   4306  O   GLY A 540      40.421  30.851  66.581  1.00 88.78           O  
ATOM   4307  N   GLU A 541      41.206  30.448  68.665  1.00 91.54           N  
ATOM   4308  CA  GLU A 541      40.286  29.348  68.970  1.00 91.91           C  
ATOM   4309  C   GLU A 541      38.961  29.841  69.502  1.00 90.25           C  
ATOM   4310  O   GLU A 541      37.985  29.092  69.467  1.00 87.25           O  
ATOM   4311  CB  GLU A 541      40.816  28.464  70.086  1.00 95.33           C  
ATOM   4312  CG  GLU A 541      42.112  27.770  69.874  1.00101.99           C  
ATOM   4313  CD  GLU A 541      42.473  26.911  71.075  1.00102.20           C  
ATOM   4314  OE1 GLU A 541      42.147  27.297  72.216  1.00101.66           O  
ATOM   4315  OE2 GLU A 541      43.073  25.835  70.884  1.00103.22           O  
ATOM   4316  N   LYS A 542      38.968  31.036  70.106  1.00 86.29           N  
ATOM   4317  CA  LYS A 542      37.782  31.660  70.711  1.00 84.70           C  
ATOM   4318  C   LYS A 542      36.665  31.892  69.713  1.00 84.86           C  
ATOM   4319  O   LYS A 542      35.524  32.089  70.116  1.00 82.81           O  
ATOM   4320  CB  LYS A 542      38.136  32.991  71.400  1.00 84.23           C  
ATOM   4321  CG  LYS A 542      39.243  32.934  72.488  1.00 88.36           C  
ATOM   4322  CD  LYS A 542      39.372  34.313  73.166  1.00 88.20           C  
ATOM   4323  CE  LYS A 542      40.794  34.782  73.216  1.00 90.49           C  
ATOM   4324  NZ  LYS A 542      40.892  36.215  72.907  1.00 90.76           N  
ATOM   4325  N   LEU A 543      37.016  31.830  68.423  1.00 79.56           N  
ATOM   4326  CA  LEU A 543      36.096  31.976  67.291  1.00 78.02           C  
ATOM   4327  C   LEU A 543      35.149  30.784  67.220  1.00 73.77           C  
ATOM   4328  O   LEU A 543      33.984  30.868  67.622  1.00 81.41           O  
ATOM   4329  CB  LEU A 543      36.904  32.020  66.005  1.00 82.13           C  
ATOM   4330  CG  LEU A 543      36.992  33.285  65.165  1.00 90.50           C  
ATOM   4331  CD1 LEU A 543      37.579  32.833  63.864  1.00 88.80           C  
ATOM   4332  CD2 LEU A 543      35.662  33.919  64.927  1.00 83.10           C  
ATOM   4333  N   THR A 544      35.718  29.658  66.789  1.00 68.26           N  
ATOM   4334  CA  THR A 544      35.062  28.370  66.645  1.00 61.62           C  
ATOM   4335  C   THR A 544      34.235  28.039  67.886  1.00 57.34           C  
ATOM   4336  O   THR A 544      33.033  27.808  67.781  1.00 58.34           O  
ATOM   4337  CB  THR A 544      36.140  27.312  66.431  1.00 59.84           C  
ATOM   4338  OG1 THR A 544      37.057  27.776  65.434  1.00 64.30           O  
ATOM   4339  CG2 THR A 544      35.541  26.027  65.972  1.00 62.94           C  
ATOM   4340  N   GLU A 545      34.878  28.175  69.047  1.00 55.25           N  
ATOM   4341  CA  GLU A 545      34.300  27.935  70.367  1.00 52.09           C  
ATOM   4342  C   GLU A 545      33.121  28.839  70.702  1.00 46.39           C  
ATOM   4343  O   GLU A 545      32.108  28.355  71.212  1.00 41.29           O  
ATOM   4344  CB  GLU A 545      35.374  28.125  71.444  1.00 63.64           C  
ATOM   4345  CG  GLU A 545      36.434  27.024  71.560  1.00 70.73           C  
ATOM   4346  CD  GLU A 545      36.071  25.910  72.553  1.00 77.73           C  
ATOM   4347  OE1 GLU A 545      35.323  26.170  73.527  1.00 80.51           O  
ATOM   4348  OE2 GLU A 545      36.566  24.769  72.371  1.00 82.00           O  
ATOM   4349  N   LYS A 546      33.253  30.142  70.423  1.00 41.41           N  
ATOM   4350  CA  LYS A 546      32.182  31.095  70.729  1.00 42.18           C  
ATOM   4351  C   LYS A 546      31.025  30.809  69.831  1.00 36.48           C  
ATOM   4352  O   LYS A 546      29.940  30.535  70.328  1.00 39.78           O  
ATOM   4353  CB  LYS A 546      32.616  32.553  70.572  1.00 47.91           C  
ATOM   4354  CG  LYS A 546      31.998  33.503  71.602  1.00 53.15           C  
ATOM   4355  CD  LYS A 546      32.895  34.711  71.907  1.00 67.36           C  
ATOM   4356  CE  LYS A 546      34.269  34.316  72.533  1.00 74.64           C  
ATOM   4357  NZ  LYS A 546      35.198  35.463  72.865  1.00 77.91           N  
ATOM   4358  N   ALA A 547      31.326  30.678  68.536  1.00 39.90           N  
ATOM   4359  CA  ALA A 547      30.345  30.381  67.485  1.00 36.07           C  
ATOM   4360  C   ALA A 547      29.476  29.187  67.831  1.00 33.20           C  
ATOM   4361  O   ALA A 547      28.239  29.284  67.769  1.00 34.02           O  
ATOM   4362  CB  ALA A 547      31.036  30.160  66.139  1.00 35.10           C  
ATOM   4363  N   ILE A 548      30.133  28.130  68.326  1.00 23.68           N  
ATOM   4364  CA  ILE A 548      29.453  26.911  68.715  1.00 19.96           C  
ATOM   4365  C   ILE A 548      28.891  26.939  70.128  1.00 24.83           C  
ATOM   4366  O   ILE A 548      27.886  26.283  70.394  1.00 28.68           O  
ATOM   4367  CB  ILE A 548      30.308  25.685  68.405  1.00 14.46           C  
ATOM   4368  CG1 ILE A 548      30.447  25.604  66.880  1.00 16.32           C  
ATOM   4369  CG2 ILE A 548      29.636  24.389  68.860  1.00  4.10           C  
ATOM   4370  CD1 ILE A 548      31.620  24.865  66.426  1.00 21.55           C  
ATOM   4371  N   GLY A 549      29.467  27.756  71.006  1.00 22.45           N  
ATOM   4372  CA  GLY A 549      28.949  27.852  72.367  1.00 23.88           C  
ATOM   4373  C   GLY A 549      27.690  28.693  72.350  1.00 27.00           C  
ATOM   4374  O   GLY A 549      26.742  28.455  73.130  1.00 13.62           O  
ATOM   4375  N   ASP A 550      27.709  29.675  71.436  1.00 19.29           N  
ATOM   4376  CA  ASP A 550      26.596  30.590  71.210  1.00 24.10           C  
ATOM   4377  C   ASP A 550      25.432  29.756  70.734  1.00 22.91           C  
ATOM   4378  O   ASP A 550      24.323  29.884  71.280  1.00 30.86           O  
ATOM   4379  CB  ASP A 550      26.926  31.653  70.173  1.00 28.40           C  
ATOM   4380  CG  ASP A 550      27.678  32.828  70.762  1.00 37.13           C  
ATOM   4381  OD1 ASP A 550      27.070  33.883  71.001  1.00 39.29           O  
ATOM   4382  OD2 ASP A 550      28.893  32.707  70.966  1.00 38.58           O  
ATOM   4383  N   VAL A 551      25.715  28.826  69.815  1.00 16.37           N  
ATOM   4384  CA  VAL A 551      24.717  27.887  69.293  1.00 14.50           C  
ATOM   4385  C   VAL A 551      24.093  27.073  70.453  1.00 15.24           C  
ATOM   4386  O   VAL A 551      22.866  26.914  70.559  1.00 16.97           O  
ATOM   4387  CB  VAL A 551      25.394  26.955  68.290  1.00 14.14           C  
ATOM   4388  CG1 VAL A 551      24.558  25.674  67.985  1.00 13.32           C  
ATOM   4389  CG2 VAL A 551      25.667  27.733  67.035  1.00 13.47           C  
ATOM   4390  N   PHE A 552      24.954  26.670  71.382  1.00 17.12           N  
ATOM   4391  CA  PHE A 552      24.537  25.914  72.543  1.00 16.07           C  
ATOM   4392  C   PHE A 552      23.763  26.718  73.557  1.00 15.75           C  
ATOM   4393  O   PHE A 552      22.737  26.246  74.025  1.00 10.32           O  
ATOM   4394  CB  PHE A 552      25.739  25.253  73.165  1.00 15.14           C  
ATOM   4395  CG  PHE A 552      26.066  23.940  72.541  1.00 18.94           C  
ATOM   4396  CD1 PHE A 552      26.878  23.867  71.396  1.00 18.47           C  
ATOM   4397  CD2 PHE A 552      25.531  22.765  73.079  1.00 16.87           C  
ATOM   4398  CE1 PHE A 552      27.158  22.637  70.795  1.00 20.59           C  
ATOM   4399  CE2 PHE A 552      25.795  21.516  72.497  1.00 20.59           C  
ATOM   4400  CZ  PHE A 552      26.613  21.442  71.350  1.00 22.07           C  
ATOM   4401  N   SER A 553      24.203  27.958  73.828  1.00 18.79           N  
ATOM   4402  CA  SER A 553      23.479  28.831  74.760  1.00 16.14           C  
ATOM   4403  C   SER A 553      22.124  29.220  74.183  1.00 14.69           C  
ATOM   4404  O   SER A 553      21.174  29.383  74.934  1.00 18.75           O  
ATOM   4405  CB  SER A 553      24.280  30.065  75.182  1.00 17.84           C  
ATOM   4406  OG  SER A 553      24.521  30.947  74.110  1.00 22.62           O  
ATOM   4407  N   LEU A 554      22.017  29.274  72.854  1.00 18.70           N  
ATOM   4408  CA  LEU A 554      20.737  29.568  72.207  1.00 15.66           C  
ATOM   4409  C   LEU A 554      19.788  28.378  72.400  1.00 22.82           C  
ATOM   4410  O   LEU A 554      18.612  28.592  72.677  1.00 28.43           O  
ATOM   4411  CB  LEU A 554      20.882  29.875  70.705  1.00 19.07           C  
ATOM   4412  CG  LEU A 554      19.572  30.246  69.958  1.00 21.54           C  
ATOM   4413  CD1 LEU A 554      18.860  31.432  70.602  1.00 19.14           C  
ATOM   4414  CD2 LEU A 554      19.825  30.534  68.496  1.00 15.63           C  
ATOM   4415  N   LEU A 555      20.304  27.144  72.320  1.00 17.75           N  
ATOM   4416  CA  LEU A 555      19.465  25.954  72.506  1.00 19.82           C  
ATOM   4417  C   LEU A 555      18.951  25.929  73.925  1.00 22.50           C  
ATOM   4418  O   LEU A 555      17.783  25.637  74.161  1.00 20.68           O  
ATOM   4419  CB  LEU A 555      20.222  24.664  72.195  1.00 16.44           C  
ATOM   4420  CG  LEU A 555      20.401  24.386  70.693  1.00 16.29           C  
ATOM   4421  CD1 LEU A 555      21.512  23.402  70.460  1.00 16.03           C  
ATOM   4422  CD2 LEU A 555      19.117  23.872  70.076  1.00 17.23           C  
ATOM   4423  N   GLU A 556      19.793  26.388  74.849  1.00 28.37           N  
ATOM   4424  CA  GLU A 556      19.442  26.455  76.266  1.00 28.81           C  
ATOM   4425  C   GLU A 556      18.358  27.515  76.457  1.00 27.68           C  
ATOM   4426  O   GLU A 556      17.363  27.261  77.145  1.00 31.76           O  
ATOM   4427  CB  GLU A 556      20.667  26.824  77.104  1.00 35.57           C  
ATOM   4428  CG  GLU A 556      20.498  26.656  78.614  1.00 43.21           C  
ATOM   4429  CD  GLU A 556      21.358  27.615  79.421  1.00 48.66           C  
ATOM   4430  OE1 GLU A 556      20.887  28.055  80.500  1.00 48.69           O  
ATOM   4431  OE2 GLU A 556      22.489  27.945  78.983  1.00 49.25           O  
ATOM   4432  N   LYS A 557      18.531  28.659  75.781  1.00 23.88           N  
ATOM   4433  CA  LYS A 557      17.584  29.772  75.844  1.00 27.66           C  
ATOM   4434  C   LYS A 557      16.206  29.364  75.313  1.00 28.67           C  
ATOM   4435  O   LYS A 557      15.183  29.927  75.735  1.00 33.94           O  
ATOM   4436  CB  LYS A 557      18.122  30.990  75.073  1.00 20.45           C  
ATOM   4437  CG  LYS A 557      19.201  31.745  75.815  1.00 27.42           C  
ATOM   4438  CD  LYS A 557      19.947  32.780  74.995  1.00 26.38           C  
ATOM   4439  CE  LYS A 557      21.303  33.069  75.650  1.00 26.33           C  
ATOM   4440  NZ  LYS A 557      22.119  34.111  74.953  1.00 28.25           N  
ATOM   4441  N   LEU A 558      16.204  28.336  74.458  1.00 25.92           N  
ATOM   4442  CA  LEU A 558      15.003  27.805  73.838  1.00 32.70           C  
ATOM   4443  C   LEU A 558      14.390  26.602  74.584  1.00 39.42           C  
ATOM   4444  O   LEU A 558      13.593  25.843  74.006  1.00 42.55           O  
ATOM   4445  CB  LEU A 558      15.275  27.461  72.365  1.00 28.82           C  
ATOM   4446  CG  LEU A 558      15.412  28.580  71.317  1.00 22.06           C  
ATOM   4447  CD1 LEU A 558      16.017  28.036  70.073  1.00 21.55           C  
ATOM   4448  CD2 LEU A 558      14.076  29.186  71.005  1.00 22.99           C  
ATOM   4449  N   GLY A 559      14.779  26.432  75.854  1.00 44.04           N  
ATOM   4450  CA  GLY A 559      14.243  25.365  76.712  1.00 51.90           C  
ATOM   4451  C   GLY A 559      14.507  23.893  76.421  1.00 47.22           C  
ATOM   4452  O   GLY A 559      13.617  23.038  76.567  1.00 50.13           O  
ATOM   4453  N   PHE A 560      15.712  23.600  75.959  1.00 44.48           N  
ATOM   4454  CA  PHE A 560      16.097  22.236  75.690  1.00 43.60           C  
ATOM   4455  C   PHE A 560      16.783  21.728  76.945  1.00 46.15           C  
ATOM   4456  O   PHE A 560      17.873  22.183  77.323  1.00 39.18           O  
ATOM   4457  CB  PHE A 560      17.003  22.153  74.474  1.00 35.48           C  
ATOM   4458  CG  PHE A 560      16.263  22.225  73.188  1.00 33.75           C  
ATOM   4459  CD1 PHE A 560      16.208  23.429  72.462  1.00 34.79           C  
ATOM   4460  CD2 PHE A 560      15.582  21.095  72.698  1.00 37.66           C  
ATOM   4461  CE1 PHE A 560      15.473  23.526  71.250  1.00 31.22           C  
ATOM   4462  CE2 PHE A 560      14.836  21.162  71.486  1.00 36.47           C  
ATOM   4463  CZ  PHE A 560      14.783  22.390  70.758  1.00 39.48           C  
ATOM   4464  N   LYS A 561      16.085  20.807  77.600  1.00 50.95           N  
ATOM   4465  CA  LYS A 561      16.509  20.178  78.842  1.00 51.00           C  
ATOM   4466  C   LYS A 561      17.660  19.202  78.592  1.00 45.44           C  
ATOM   4467  O   LYS A 561      17.911  18.778  77.460  1.00 39.51           O  
ATOM   4468  CB  LYS A 561      15.302  19.473  79.487  1.00 56.66           C  
ATOM   4469  CG  LYS A 561      14.027  20.323  79.479  1.00 57.01           C  
ATOM   4470  CD  LYS A 561      12.762  19.476  79.399  1.00 67.99           C  
ATOM   4471  CE  LYS A 561      11.555  20.326  78.978  1.00 73.17           C  
ATOM   4472  NZ  LYS A 561      10.249  19.610  79.154  1.00 75.43           N  
ATOM   4473  N   LYS A 562      18.379  18.908  79.672  1.00 50.59           N  
ATOM   4474  CA  LYS A 562      19.536  18.005  79.720  1.00 54.91           C  
ATOM   4475  C   LYS A 562      19.114  16.603  79.249  1.00 48.93           C  
ATOM   4476  O   LYS A 562      18.146  16.051  79.761  1.00 49.72           O  
ATOM   4477  CB  LYS A 562      20.050  17.991  81.182  1.00 56.32           C  
ATOM   4478  CG  LYS A 562      21.297  17.162  81.554  1.00 55.69           C  
ATOM   4479  CD  LYS A 562      21.602  17.362  83.061  1.00 64.16           C  
ATOM   4480  CE  LYS A 562      22.735  16.478  83.601  1.00 60.52           C  
ATOM   4481  NZ  LYS A 562      23.243  16.913  84.943  1.00 57.50           N  
ATOM   4482  N   GLY A 563      19.760  16.108  78.192  1.00 47.62           N  
ATOM   4483  CA  GLY A 563      19.458  14.782  77.669  1.00 37.74           C  
ATOM   4484  C   GLY A 563      18.562  14.733  76.449  1.00 34.42           C  
ATOM   4485  O   GLY A 563      17.916  13.707  76.158  1.00 31.32           O  
ATOM   4486  N   SER A 564      18.498  15.861  75.750  1.00 32.25           N  
ATOM   4487  CA  SER A 564      17.703  15.959  74.540  1.00 29.87           C  
ATOM   4488  C   SER A 564      18.636  15.655  73.349  1.00 24.92           C  
ATOM   4489  O   SER A 564      19.823  16.016  73.380  1.00 24.91           O  
ATOM   4490  CB  SER A 564      17.010  17.330  74.469  1.00 21.11           C  
ATOM   4491  OG  SER A 564      17.924  18.382  74.590  1.00 20.42           O  
ATOM   4492  N   LYS A 565      18.121  14.902  72.368  1.00 22.77           N  
ATOM   4493  CA  LYS A 565      18.895  14.488  71.184  1.00 18.65           C  
ATOM   4494  C   LYS A 565      19.015  15.592  70.167  1.00 21.93           C  
ATOM   4495  O   LYS A 565      18.013  16.175  69.749  1.00 19.93           O  
ATOM   4496  CB  LYS A 565      18.291  13.242  70.539  1.00 18.49           C  
ATOM   4497  CG  LYS A 565      19.020  12.723  69.324  1.00  9.49           C  
ATOM   4498  CD  LYS A 565      20.304  12.006  69.654  1.00 24.48           C  
ATOM   4499  CE  LYS A 565      20.083  10.587  70.114  1.00 29.42           C  
ATOM   4500  NZ  LYS A 565      19.175   9.844  69.184  1.00 42.55           N  
ATOM   4501  N   ILE A 566      20.258  15.913  69.814  1.00 24.36           N  
ATOM   4502  CA  ILE A 566      20.510  16.974  68.864  1.00 21.67           C  
ATOM   4503  C   ILE A 566      21.307  16.570  67.623  1.00 24.34           C  
ATOM   4504  O   ILE A 566      22.442  16.109  67.699  1.00 19.82           O  
ATOM   4505  CB  ILE A 566      21.085  18.213  69.594  1.00 27.10           C  
ATOM   4506  CG1 ILE A 566      19.952  18.880  70.397  1.00 34.62           C  
ATOM   4507  CG2 ILE A 566      21.617  19.228  68.617  1.00 26.00           C  
ATOM   4508  CD1 ILE A 566      20.340  19.959  71.367  1.00 43.86           C  
ATOM   4509  N   VAL A 567      20.666  16.742  66.474  1.00 24.59           N  
ATOM   4510  CA  VAL A 567      21.279  16.441  65.192  1.00 24.25           C  
ATOM   4511  C   VAL A 567      21.800  17.724  64.569  1.00 21.73           C  
ATOM   4512  O   VAL A 567      21.045  18.680  64.386  1.00 28.45           O  
ATOM   4513  CB  VAL A 567      20.295  15.766  64.237  1.00 21.21           C  
ATOM   4514  CG1 VAL A 567      20.960  15.482  62.909  1.00 23.47           C  
ATOM   4515  CG2 VAL A 567      19.802  14.469  64.843  1.00 20.94           C  
ATOM   4516  N   VAL A 568      23.095  17.730  64.256  1.00 21.64           N  
ATOM   4517  CA  VAL A 568      23.730  18.884  63.662  1.00 19.37           C  
ATOM   4518  C   VAL A 568      24.105  18.555  62.254  1.00 19.83           C  
ATOM   4519  O   VAL A 568      24.646  17.494  61.993  1.00 22.22           O  
ATOM   4520  CB  VAL A 568      25.011  19.328  64.428  1.00 23.07           C  
ATOM   4521  CG1 VAL A 568      25.682  20.554  63.753  1.00 13.26           C  
ATOM   4522  CG2 VAL A 568      24.674  19.643  65.881  1.00 21.85           C  
ATOM   4523  N   HIS A 569      23.775  19.458  61.337  1.00 18.39           N  
ATOM   4524  CA  HIS A 569      24.121  19.306  59.924  1.00 15.57           C  
ATOM   4525  C   HIS A 569      25.079  20.418  59.655  1.00 15.92           C  
ATOM   4526  O   HIS A 569      24.800  21.589  59.981  1.00 16.78           O  
ATOM   4527  CB  HIS A 569      22.918  19.489  59.011  1.00 16.36           C  
ATOM   4528  CG  HIS A 569      21.869  18.425  59.138  1.00 17.86           C  
ATOM   4529  ND1 HIS A 569      20.723  18.432  58.369  1.00 14.57           N  
ATOM   4530  CD2 HIS A 569      21.791  17.328  59.925  1.00 19.96           C  
ATOM   4531  CE1 HIS A 569      19.987  17.381  58.683  1.00 13.82           C  
ATOM   4532  NE2 HIS A 569      20.609  16.692  59.622  1.00 13.61           N  
ATOM   4533  N   ARG A 570      26.229  20.044  59.113  1.00 18.68           N  
ATOM   4534  CA  ARG A 570      27.265  21.001  58.787  1.00 20.79           C  
ATOM   4535  C   ARG A 570      27.282  21.117  57.292  1.00 25.20           C  
ATOM   4536  O   ARG A 570      27.414  20.106  56.588  1.00 32.07           O  
ATOM   4537  CB  ARG A 570      28.621  20.543  59.310  1.00  8.15           C  
ATOM   4538  CG  ARG A 570      29.750  21.507  59.010  1.00 13.22           C  
ATOM   4539  CD  ARG A 570      29.567  22.843  59.693  1.00 15.45           C  
ATOM   4540  NE  ARG A 570      30.718  23.718  59.509  1.00 12.88           N  
ATOM   4541  CZ  ARG A 570      30.986  24.391  58.399  1.00 15.32           C  
ATOM   4542  NH1 ARG A 570      30.174  24.292  57.335  1.00 18.72           N  
ATOM   4543  NH2 ARG A 570      32.033  25.219  58.378  1.00 10.22           N  
ATOM   4544  N   ASP A 571      27.192  22.356  56.819  1.00 27.45           N  
ATOM   4545  CA  ASP A 571      27.179  22.654  55.403  1.00 36.31           C  
ATOM   4546  C   ASP A 571      28.485  22.216  54.763  1.00 38.77           C  
ATOM   4547  O   ASP A 571      28.516  21.745  53.624  1.00 43.63           O  
ATOM   4548  CB  ASP A 571      26.933  24.145  55.228  1.00 34.28           C  
ATOM   4549  CG  ASP A 571      26.881  24.593  53.766  1.00 39.14           C  
ATOM   4550  OD1 ASP A 571      27.973  24.774  53.149  1.00 37.56           O  
ATOM   4551  OD2 ASP A 571      25.749  24.819  53.263  1.00 39.47           O  
ATOM   4552  N   GLY A 572      29.563  22.314  55.508  1.00 41.79           N  
ATOM   4553  CA  GLY A 572      30.806  21.910  54.901  1.00 46.42           C  
ATOM   4554  C   GLY A 572      31.326  20.705  55.597  1.00 51.25           C  
ATOM   4555  O   GLY A 572      30.565  19.856  56.065  1.00 50.06           O  
ATOM   4556  N   ARG A 573      32.649  20.625  55.583  1.00 51.51           N  
ATOM   4557  CA  ARG A 573      33.368  19.576  56.259  1.00 54.88           C  
ATOM   4558  C   ARG A 573      33.616  20.160  57.655  1.00 54.64           C  
ATOM   4559  O   ARG A 573      33.966  21.338  57.799  1.00 58.59           O  
ATOM   4560  CB  ARG A 573      34.696  19.221  55.532  1.00 57.90           C  
ATOM   4561  CG  ARG A 573      34.594  18.149  54.404  1.00 65.25           C  
ATOM   4562  CD  ARG A 573      35.902  17.297  54.235  1.00 64.76           C  
ATOM   4563  NE  ARG A 573      35.828  16.233  53.205  1.00 63.94           N  
ATOM   4564  CZ  ARG A 573      35.902  14.915  53.435  1.00 65.04           C  
ATOM   4565  NH1 ARG A 573      36.040  14.440  54.668  1.00 63.20           N  
ATOM   4566  NH2 ARG A 573      35.887  14.063  52.413  1.00 62.70           N  
ATOM   4567  N   LEU A 574      33.275  19.382  58.671  1.00 53.87           N  
ATOM   4568  CA  LEU A 574      33.478  19.763  60.058  1.00 50.19           C  
ATOM   4569  C   LEU A 574      34.976  19.739  60.354  1.00 56.75           C  
ATOM   4570  O   LEU A 574      35.602  18.672  60.304  1.00 60.15           O  
ATOM   4571  CB  LEU A 574      32.800  18.738  60.953  1.00 40.97           C  
ATOM   4572  CG  LEU A 574      31.431  18.994  61.527  1.00 33.92           C  
ATOM   4573  CD1 LEU A 574      30.856  17.702  62.011  1.00 33.48           C  
ATOM   4574  CD2 LEU A 574      31.532  19.995  62.638  1.00 34.91           C  
ATOM   4575  N   TYR A 575      35.552  20.902  60.646  1.00 60.45           N  
ATOM   4576  CA  TYR A 575      36.977  20.992  60.978  1.00 58.54           C  
ATOM   4577  C   TYR A 575      37.143  20.411  62.367  1.00 56.12           C  
ATOM   4578  O   TYR A 575      36.233  20.517  63.180  1.00 50.21           O  
ATOM   4579  CB  TYR A 575      37.449  22.444  60.945  1.00 62.95           C  
ATOM   4580  CG  TYR A 575      37.240  23.115  59.594  1.00 74.74           C  
ATOM   4581  CD1 TYR A 575      36.071  23.860  59.330  1.00 73.49           C  
ATOM   4582  CD2 TYR A 575      38.205  23.007  58.568  1.00 76.49           C  
ATOM   4583  CE1 TYR A 575      35.860  24.484  58.083  1.00 76.25           C  
ATOM   4584  CE2 TYR A 575      38.006  23.633  57.307  1.00 74.86           C  
ATOM   4585  CZ  TYR A 575      36.825  24.371  57.079  1.00 77.43           C  
ATOM   4586  OH  TYR A 575      36.598  25.007  55.873  1.00 87.04           O  
ATOM   4587  N   ARG A 576      38.272  19.740  62.600  1.00 57.40           N  
ATOM   4588  CA  ARG A 576      38.616  19.081  63.874  1.00 56.73           C  
ATOM   4589  C   ARG A 576      38.284  19.905  65.130  1.00 53.05           C  
ATOM   4590  O   ARG A 576      37.824  19.369  66.140  1.00 49.29           O  
ATOM   4591  CB  ARG A 576      40.101  18.725  63.838  1.00 66.07           C  
ATOM   4592  CG  ARG A 576      40.636  17.915  64.999  1.00 77.25           C  
ATOM   4593  CD  ARG A 576      41.889  18.606  65.528  1.00 82.52           C  
ATOM   4594  NE  ARG A 576      42.694  17.766  66.413  1.00 96.05           N  
ATOM   4595  CZ  ARG A 576      44.009  17.898  66.585  1.00 99.99           C  
ATOM   4596  NH1 ARG A 576      44.691  18.842  65.934  1.00 98.02           N  
ATOM   4597  NH2 ARG A 576      44.651  17.073  67.407  1.00101.65           N  
ATOM   4598  N   ASP A 577      38.427  21.222  64.985  1.00 48.74           N  
ATOM   4599  CA  ASP A 577      38.173  22.231  66.023  1.00 52.61           C  
ATOM   4600  C   ASP A 577      36.704  22.310  66.377  1.00 50.21           C  
ATOM   4601  O   ASP A 577      36.336  22.477  67.538  1.00 46.48           O  
ATOM   4602  CB  ASP A 577      38.581  23.621  65.523  1.00 58.68           C  
ATOM   4603  CG  ASP A 577      39.934  23.631  64.864  1.00 67.48           C  
ATOM   4604  OD1 ASP A 577      40.859  24.224  65.463  1.00 69.85           O  
ATOM   4605  OD2 ASP A 577      40.055  23.050  63.751  1.00 70.91           O  
ATOM   4606  N   GLU A 578      35.876  22.239  65.345  1.00 39.40           N  
ATOM   4607  CA  GLU A 578      34.444  22.296  65.497  1.00 32.25           C  
ATOM   4608  C   GLU A 578      33.935  21.025  66.123  1.00 31.57           C  
ATOM   4609  O   GLU A 578      33.242  21.104  67.124  1.00 31.32           O  
ATOM   4610  CB  GLU A 578      33.785  22.523  64.161  1.00 33.79           C  
ATOM   4611  CG  GLU A 578      34.409  23.652  63.411  1.00 35.45           C  
ATOM   4612  CD  GLU A 578      33.764  23.915  62.098  1.00 40.31           C  
ATOM   4613  OE1 GLU A 578      33.171  22.978  61.511  1.00 43.23           O  
ATOM   4614  OE2 GLU A 578      33.891  25.073  61.638  1.00 41.89           O  
ATOM   4615  N   VAL A 579      34.383  19.867  65.620  1.00 30.23           N  
ATOM   4616  CA  VAL A 579      33.986  18.541  66.133  1.00 25.81           C  
ATOM   4617  C   VAL A 579      34.202  18.503  67.648  1.00 25.13           C  
ATOM   4618  O   VAL A 579      33.311  18.113  68.417  1.00 19.02           O  
ATOM   4619  CB  VAL A 579      34.814  17.410  65.443  1.00 22.70           C  
ATOM   4620  CG1 VAL A 579      34.310  16.037  65.824  1.00 19.12           C  
ATOM   4621  CG2 VAL A 579      34.768  17.554  63.933  1.00 28.90           C  
ATOM   4622  N   ALA A 580      35.337  19.087  68.044  1.00 26.84           N  
ATOM   4623  CA  ALA A 580      35.783  19.207  69.438  1.00 28.76           C  
ATOM   4624  C   ALA A 580      34.827  20.045  70.290  1.00 31.14           C  
ATOM   4625  O   ALA A 580      34.248  19.538  71.274  1.00 36.15           O  
ATOM   4626  CB  ALA A 580      37.169  19.825  69.480  1.00 18.00           C  
ATOM   4627  N   ALA A 581      34.636  21.305  69.859  1.00 29.96           N  
ATOM   4628  CA  ALA A 581      33.788  22.302  70.519  1.00 24.72           C  
ATOM   4629  C   ALA A 581      32.437  21.733  70.836  1.00 22.56           C  
ATOM   4630  O   ALA A 581      31.963  21.856  71.942  1.00 23.99           O  
ATOM   4631  CB  ALA A 581      33.640  23.523  69.642  1.00 23.65           C  
ATOM   4632  N   PHE A 582      31.897  20.987  69.880  1.00 27.84           N  
ATOM   4633  CA  PHE A 582      30.598  20.337  69.988  1.00 24.73           C  
ATOM   4634  C   PHE A 582      30.586  19.308  71.102  1.00 28.89           C  
ATOM   4635  O   PHE A 582      29.822  19.453  72.059  1.00 29.18           O  
ATOM   4636  CB  PHE A 582      30.248  19.663  68.657  1.00 24.19           C  
ATOM   4637  CG  PHE A 582      29.655  20.592  67.644  1.00 24.89           C  
ATOM   4638  CD1 PHE A 582      30.413  21.028  66.559  1.00 22.44           C  
ATOM   4639  CD2 PHE A 582      28.322  21.043  67.760  1.00 27.29           C  
ATOM   4640  CE1 PHE A 582      29.860  21.914  65.589  1.00 24.45           C  
ATOM   4641  CE2 PHE A 582      27.749  21.934  66.794  1.00 23.76           C  
ATOM   4642  CZ  PHE A 582      28.524  22.367  65.713  1.00 16.58           C  
ATOM   4643  N   LYS A 583      31.492  18.331  70.999  1.00 30.72           N  
ATOM   4644  CA  LYS A 583      31.634  17.244  71.963  1.00 30.71           C  
ATOM   4645  C   LYS A 583      31.774  17.754  73.383  1.00 32.72           C  
ATOM   4646  O   LYS A 583      31.198  17.172  74.301  1.00 39.07           O  
ATOM   4647  CB  LYS A 583      32.861  16.402  71.641  1.00 33.04           C  
ATOM   4648  CG  LYS A 583      32.825  15.705  70.319  1.00 28.30           C  
ATOM   4649  CD  LYS A 583      34.118  14.949  70.103  1.00 28.36           C  
ATOM   4650  CE  LYS A 583      34.006  14.002  68.917  1.00 31.58           C  
ATOM   4651  NZ  LYS A 583      35.297  13.393  68.519  1.00 36.53           N  
ATOM   4652  N   LYS A 584      32.502  18.858  73.550  1.00 34.57           N  
ATOM   4653  CA  LYS A 584      32.709  19.435  74.870  1.00 40.38           C  
ATOM   4654  C   LYS A 584      31.526  20.221  75.368  1.00 41.51           C  
ATOM   4655  O   LYS A 584      31.227  20.175  76.554  1.00 42.73           O  
ATOM   4656  CB  LYS A 584      33.973  20.268  74.898  1.00 43.96           C  
ATOM   4657  CG  LYS A 584      35.199  19.374  74.776  1.00 60.07           C  
ATOM   4658  CD  LYS A 584      36.413  20.136  74.294  1.00 64.44           C  
ATOM   4659  CE  LYS A 584      37.604  19.223  74.136  1.00 56.32           C  
ATOM   4660  NZ  LYS A 584      38.805  20.041  73.800  1.00 59.17           N  
ATOM   4661  N   TYR A 585      30.821  20.877  74.443  1.00 36.89           N  
ATOM   4662  CA  TYR A 585      29.625  21.663  74.761  1.00 36.31           C  
ATOM   4663  C   TYR A 585      28.417  20.738  74.816  1.00 36.07           C  
ATOM   4664  O   TYR A 585      27.360  21.104  75.329  1.00 34.09           O  
ATOM   4665  CB  TYR A 585      29.421  22.782  73.748  1.00 36.18           C  
ATOM   4666  CG  TYR A 585      30.177  24.058  74.061  1.00 39.57           C  
ATOM   4667  CD1 TYR A 585      31.293  24.453  73.298  1.00 32.68           C  
ATOM   4668  CD2 TYR A 585      29.801  24.871  75.147  1.00 40.71           C  
ATOM   4669  CE1 TYR A 585      32.022  25.621  73.613  1.00 42.45           C  
ATOM   4670  CE2 TYR A 585      30.514  26.049  75.475  1.00 45.50           C  
ATOM   4671  CZ  TYR A 585      31.622  26.418  74.709  1.00 41.00           C  
ATOM   4672  OH  TYR A 585      32.283  27.580  75.041  1.00 46.74           O  
ATOM   4673  N   GLY A 586      28.587  19.536  74.266  1.00 33.96           N  
ATOM   4674  CA  GLY A 586      27.558  18.514  74.320  1.00 33.48           C  
ATOM   4675  C   GLY A 586      27.658  17.916  75.719  1.00 36.39           C  
ATOM   4676  O   GLY A 586      26.644  17.653  76.355  1.00 34.60           O  
ATOM   4677  N   GLU A 587      28.894  17.782  76.220  1.00 36.99           N  
ATOM   4678  CA  GLU A 587      29.176  17.233  77.553  1.00 46.53           C  
ATOM   4679  C   GLU A 587      28.715  18.195  78.618  1.00 41.28           C  
ATOM   4680  O   GLU A 587      28.023  17.791  79.559  1.00 43.26           O  
ATOM   4681  CB  GLU A 587      30.678  16.963  77.741  1.00 51.19           C  
ATOM   4682  CG  GLU A 587      31.128  15.534  77.399  1.00 63.08           C  
ATOM   4683  CD  GLU A 587      32.621  15.422  77.031  1.00 72.74           C  
ATOM   4684  OE1 GLU A 587      33.423  16.338  77.357  1.00 72.45           O  
ATOM   4685  OE2 GLU A 587      32.990  14.393  76.410  1.00 71.46           O  
ATOM   4686  N   LEU A 588      29.048  19.468  78.402  1.00 39.34           N  
ATOM   4687  CA  LEU A 588      28.722  20.587  79.284  1.00 38.16           C  
ATOM   4688  C   LEU A 588      27.240  20.864  79.519  1.00 36.14           C  
ATOM   4689  O   LEU A 588      26.853  21.124  80.648  1.00 39.34           O  
ATOM   4690  CB  LEU A 588      29.395  21.860  78.770  1.00 40.28           C  
ATOM   4691  CG  LEU A 588      30.586  22.442  79.543  1.00 50.39           C  
ATOM   4692  CD1 LEU A 588      31.686  22.930  78.585  1.00 44.06           C  
ATOM   4693  CD2 LEU A 588      30.064  23.577  80.438  1.00 53.11           C  
ATOM   4694  N   TYR A 589      26.419  20.802  78.466  1.00 31.01           N  
ATOM   4695  CA  TYR A 589      24.969  21.044  78.579  1.00 31.72           C  
ATOM   4696  C   TYR A 589      24.170  19.764  78.715  1.00 32.67           C  
ATOM   4697  O   TYR A 589      22.930  19.800  78.802  1.00 32.40           O  
ATOM   4698  CB  TYR A 589      24.438  21.796  77.367  1.00 35.01           C  
ATOM   4699  CG  TYR A 589      24.856  23.231  77.252  1.00 32.05           C  
ATOM   4700  CD1 TYR A 589      26.123  23.562  76.758  1.00 33.38           C  
ATOM   4701  CD2 TYR A 589      23.977  24.279  77.586  1.00 27.35           C  
ATOM   4702  CE1 TYR A 589      26.523  24.913  76.589  1.00 33.59           C  
ATOM   4703  CE2 TYR A 589      24.365  25.641  77.413  1.00 31.71           C  
ATOM   4704  CZ  TYR A 589      25.643  25.943  76.911  1.00 30.47           C  
ATOM   4705  OH  TYR A 589      26.062  27.239  76.702  1.00 35.29           O  
ATOM   4706  N   GLY A 590      24.890  18.646  78.649  1.00 30.95           N  
ATOM   4707  CA  GLY A 590      24.309  17.325  78.778  1.00 31.76           C  
ATOM   4708  C   GLY A 590      23.393  16.927  77.643  1.00 34.31           C  
ATOM   4709  O   GLY A 590      22.310  16.427  77.913  1.00 38.61           O  
ATOM   4710  N   TYR A 591      23.795  17.196  76.396  1.00 34.48           N  
ATOM   4711  CA  TYR A 591      22.999  16.832  75.199  1.00 33.50           C  
ATOM   4712  C   TYR A 591      23.533  15.568  74.476  1.00 26.92           C  
ATOM   4713  O   TYR A 591      24.738  15.276  74.541  1.00 24.06           O  
ATOM   4714  CB  TYR A 591      22.964  17.987  74.155  1.00 25.09           C  
ATOM   4715  CG  TYR A 591      22.293  19.288  74.560  1.00 18.08           C  
ATOM   4716  CD1 TYR A 591      21.143  19.300  75.389  1.00 22.81           C  
ATOM   4717  CD2 TYR A 591      22.825  20.531  74.127  1.00 21.30           C  
ATOM   4718  CE1 TYR A 591      20.540  20.527  75.796  1.00 27.31           C  
ATOM   4719  CE2 TYR A 591      22.234  21.785  74.522  1.00 24.52           C  
ATOM   4720  CZ  TYR A 591      21.091  21.768  75.363  1.00 25.89           C  
ATOM   4721  OH  TYR A 591      20.533  22.956  75.816  1.00 27.99           O  
ATOM   4722  N   SER A 592      22.631  14.826  73.816  1.00 30.06           N  
ATOM   4723  CA  SER A 592      23.017  13.651  73.016  1.00 29.46           C  
ATOM   4724  C   SER A 592      23.211  14.178  71.563  1.00 27.94           C  
ATOM   4725  O   SER A 592      22.256  14.518  70.851  1.00 20.61           O  
ATOM   4726  CB  SER A 592      21.974  12.515  73.106  1.00 25.43           C  
ATOM   4727  OG  SER A 592      22.415  11.337  72.438  1.00 15.35           O  
ATOM   4728  N   LEU A 593      24.483  14.328  71.196  1.00 26.15           N  
ATOM   4729  CA  LEU A 593      24.895  14.833  69.907  1.00 22.85           C  
ATOM   4730  C   LEU A 593      25.076  13.846  68.778  1.00 27.96           C  
ATOM   4731  O   LEU A 593      25.559  12.725  68.974  1.00 34.58           O  
ATOM   4732  CB  LEU A 593      26.195  15.588  70.055  1.00 24.56           C  
ATOM   4733  CG  LEU A 593      26.155  17.110  69.938  1.00 31.63           C  
ATOM   4734  CD1 LEU A 593      25.321  17.752  71.024  1.00 24.68           C  
ATOM   4735  CD2 LEU A 593      27.574  17.591  70.053  1.00 25.16           C  
ATOM   4736  N   GLU A 594      24.672  14.306  67.592  1.00 28.73           N  
ATOM   4737  CA  GLU A 594      24.781  13.602  66.317  1.00 24.18           C  
ATOM   4738  C   GLU A 594      25.334  14.669  65.375  1.00 22.72           C  
ATOM   4739  O   GLU A 594      24.711  15.725  65.185  1.00 18.47           O  
ATOM   4740  CB  GLU A 594      23.423  13.155  65.778  1.00 21.71           C  
ATOM   4741  CG  GLU A 594      22.541  12.329  66.691  1.00 27.07           C  
ATOM   4742  CD  GLU A 594      22.903  10.847  66.776  1.00 38.50           C  
ATOM   4743  OE1 GLU A 594      23.258  10.227  65.740  1.00 31.39           O  
ATOM   4744  OE2 GLU A 594      22.769  10.289  67.892  1.00 35.55           O  
ATOM   4745  N   LEU A 595      26.542  14.425  64.868  1.00 14.50           N  
ATOM   4746  CA  LEU A 595      27.210  15.342  63.950  1.00 19.82           C  
ATOM   4747  C   LEU A 595      27.288  14.828  62.535  1.00 18.78           C  
ATOM   4748  O   LEU A 595      27.812  13.730  62.275  1.00 16.70           O  
ATOM   4749  CB  LEU A 595      28.633  15.670  64.405  1.00 24.55           C  
ATOM   4750  CG  LEU A 595      28.834  16.338  65.762  1.00 29.34           C  
ATOM   4751  CD1 LEU A 595      30.325  16.571  65.984  1.00 30.40           C  
ATOM   4752  CD2 LEU A 595      28.038  17.630  65.863  1.00 26.03           C  
ATOM   4753  N   LEU A 596      26.737  15.614  61.618  1.00 12.55           N  
ATOM   4754  CA  LEU A 596      26.767  15.261  60.212  1.00 16.54           C  
ATOM   4755  C   LEU A 596      27.429  16.336  59.383  1.00 19.80           C  
ATOM   4756  O   LEU A 596      27.260  17.526  59.646  1.00 21.19           O  
ATOM   4757  CB  LEU A 596      25.364  15.025  59.653  1.00 16.40           C  
ATOM   4758  CG  LEU A 596      24.410  14.084  60.376  1.00 15.31           C  
ATOM   4759  CD1 LEU A 596      23.227  13.867  59.523  1.00 16.17           C  
ATOM   4760  CD2 LEU A 596      25.059  12.786  60.627  1.00 14.14           C  
ATOM   4761  N   GLU A 597      28.227  15.890  58.420  1.00 17.82           N  
ATOM   4762  CA  GLU A 597      28.907  16.743  57.448  1.00 20.40           C  
ATOM   4763  C   GLU A 597      28.008  16.576  56.211  1.00 22.68           C  
ATOM   4764  O   GLU A 597      27.481  15.475  55.989  1.00 20.16           O  
ATOM   4765  CB  GLU A 597      30.256  16.131  57.067  1.00 20.10           C  
ATOM   4766  CG  GLU A 597      31.507  16.535  57.824  1.00 28.61           C  
ATOM   4767  CD  GLU A 597      32.764  15.805  57.267  1.00 34.07           C  
ATOM   4768  OE1 GLU A 597      32.618  15.009  56.305  1.00 34.53           O  
ATOM   4769  OE2 GLU A 597      33.900  16.018  57.784  1.00 36.69           O  
ATOM   4770  N   ILE A 598      27.763  17.653  55.457  1.00 21.76           N  
ATOM   4771  CA  ILE A 598      26.947  17.542  54.230  1.00 18.16           C  
ATOM   4772  C   ILE A 598      27.751  18.083  53.060  1.00 16.84           C  
ATOM   4773  O   ILE A 598      27.847  19.284  52.862  1.00 29.29           O  
ATOM   4774  CB  ILE A 598      25.518  18.187  54.355  1.00 17.31           C  
ATOM   4775  CG1 ILE A 598      24.651  17.328  55.285  1.00  9.39           C  
ATOM   4776  CG2 ILE A 598      24.827  18.259  52.978  1.00  5.20           C  
ATOM   4777  CD1 ILE A 598      23.323  17.912  55.589  1.00 14.22           C  
ATOM   4778  N   ILE A 599      28.346  17.164  52.306  1.00 20.18           N  
ATOM   4779  CA  ILE A 599      29.198  17.492  51.172  1.00 18.92           C  
ATOM   4780  C   ILE A 599      28.418  17.477  49.864  1.00 24.87           C  
ATOM   4781  O   ILE A 599      28.016  16.403  49.393  1.00 28.54           O  
ATOM   4782  CB  ILE A 599      30.435  16.521  51.099  1.00 15.38           C  
ATOM   4783  CG1 ILE A 599      31.422  16.827  52.226  1.00  8.75           C  
ATOM   4784  CG2 ILE A 599      31.204  16.663  49.761  1.00 15.83           C  
ATOM   4785  CD1 ILE A 599      31.102  16.220  53.524  1.00 11.95           C  
ATOM   4786  N   LYS A 600      28.262  18.663  49.266  1.00 28.08           N  
ATOM   4787  CA  LYS A 600      27.531  18.821  48.009  1.00 25.21           C  
ATOM   4788  C   LYS A 600      28.380  18.791  46.752  1.00 27.51           C  
ATOM   4789  O   LYS A 600      27.906  18.367  45.692  1.00 27.68           O  
ATOM   4790  CB  LYS A 600      26.650  20.075  48.026  1.00 27.74           C  
ATOM   4791  CG  LYS A 600      27.240  21.331  48.611  1.00 25.19           C  
ATOM   4792  CD  LYS A 600      26.945  21.472  50.089  1.00 31.33           C  
ATOM   4793  CE  LYS A 600      27.760  22.631  50.655  1.00 31.10           C  
ATOM   4794  NZ  LYS A 600      27.374  23.973  50.088  1.00 31.93           N  
ATOM   4795  N   ARG A 601      29.648  19.177  46.904  1.00 29.41           N  
ATOM   4796  CA  ARG A 601      30.607  19.226  45.798  1.00 31.30           C  
ATOM   4797  C   ARG A 601      31.506  17.976  45.596  1.00 28.92           C  
ATOM   4798  O   ARG A 601      31.947  17.357  46.557  1.00 23.82           O  
ATOM   4799  CB  ARG A 601      31.479  20.484  45.950  1.00 33.58           C  
ATOM   4800  CG  ARG A 601      31.092  21.673  45.049  1.00 43.04           C  
ATOM   4801  CD  ARG A 601      31.744  22.993  45.507  1.00 47.69           C  
ATOM   4802  NE  ARG A 601      31.077  23.539  46.697  1.00 54.45           N  
ATOM   4803  CZ  ARG A 601      31.379  24.689  47.309  1.00 52.82           C  
ATOM   4804  NH1 ARG A 601      32.361  25.465  46.868  1.00 56.26           N  
ATOM   4805  NH2 ARG A 601      30.668  25.081  48.361  1.00 52.74           N  
ATOM   4806  N   ASN A 602      31.734  17.630  44.324  1.00 26.60           N  
ATOM   4807  CA  ASN A 602      32.593  16.537  43.828  1.00 24.61           C  
ATOM   4808  C   ASN A 602      32.339  15.080  44.267  1.00 24.46           C  
ATOM   4809  O   ASN A 602      33.260  14.245  44.408  1.00 26.40           O  
ATOM   4810  CB  ASN A 602      34.075  16.921  43.981  1.00 29.59           C  
ATOM   4811  CG  ASN A 602      34.371  18.333  43.485  1.00 27.09           C  
ATOM   4812  OD1 ASN A 602      33.837  18.778  42.471  1.00 28.17           O  
ATOM   4813  ND2 ASN A 602      35.195  19.054  44.227  1.00 29.33           N  
ATOM   4814  N   ASN A 603      31.057  14.760  44.351  1.00 26.08           N  
ATOM   4815  CA  ASN A 603      30.588  13.456  44.776  1.00 21.11           C  
ATOM   4816  C   ASN A 603      30.377  12.488  43.614  1.00 17.60           C  
ATOM   4817  O   ASN A 603      30.416  12.901  42.445  1.00 21.89           O  
ATOM   4818  CB  ASN A 603      29.272  13.660  45.534  1.00 16.23           C  
ATOM   4819  CG  ASN A 603      29.457  14.447  46.800  1.00 16.30           C  
ATOM   4820  OD1 ASN A 603      30.391  14.217  47.581  1.00  2.31           O  
ATOM   4821  ND2 ASN A 603      28.566  15.402  47.010  1.00 15.21           N  
ATOM   4822  N   PRO A 604      30.271  11.170  43.907  1.00 19.83           N  
ATOM   4823  CA  PRO A 604      30.045  10.196  42.835  1.00 23.35           C  
ATOM   4824  C   PRO A 604      28.609  10.353  42.358  1.00 23.57           C  
ATOM   4825  O   PRO A 604      27.685  10.414  43.175  1.00 26.86           O  
ATOM   4826  CB  PRO A 604      30.247   8.869  43.544  1.00 24.68           C  
ATOM   4827  CG  PRO A 604      31.254   9.182  44.568  1.00 19.84           C  
ATOM   4828  CD  PRO A 604      30.740  10.470  45.120  1.00 17.73           C  
ATOM   4829  N   ARG A 605      28.452  10.495  41.044  1.00 22.72           N  
ATOM   4830  CA  ARG A 605      27.148  10.686  40.428  1.00 23.83           C  
ATOM   4831  C   ARG A 605      26.356   9.391  40.267  1.00 18.59           C  
ATOM   4832  O   ARG A 605      26.869   8.324  40.596  1.00 16.93           O  
ATOM   4833  CB  ARG A 605      27.306  11.451  39.107  1.00 27.27           C  
ATOM   4834  CG  ARG A 605      27.741  12.936  39.278  1.00 32.31           C  
ATOM   4835  CD  ARG A 605      27.335  13.819  38.076  1.00 34.38           C  
ATOM   4836  NE  ARG A 605      28.355  14.802  37.710  1.00 38.86           N  
ATOM   4837  CZ  ARG A 605      29.450  14.527  36.996  1.00 38.53           C  
ATOM   4838  NH1 ARG A 605      29.661  13.291  36.555  1.00 40.19           N  
ATOM   4839  NH2 ARG A 605      30.360  15.467  36.763  1.00 32.99           N  
ATOM   4840  N   PHE A 606      25.061   9.529  39.960  1.00 20.75           N  
ATOM   4841  CA  PHE A 606      24.151   8.399  39.723  1.00 25.50           C  
ATOM   4842  C   PHE A 606      23.742   8.450  38.253  1.00 31.13           C  
ATOM   4843  O   PHE A 606      23.290   9.498  37.746  1.00 37.92           O  
ATOM   4844  CB  PHE A 606      22.875   8.490  40.546  1.00 23.83           C  
ATOM   4845  CG  PHE A 606      23.048   8.159  42.007  1.00 18.36           C  
ATOM   4846  CD1 PHE A 606      22.927   9.162  42.974  1.00 24.25           C  
ATOM   4847  CD2 PHE A 606      23.228   6.833  42.450  1.00 18.83           C  
ATOM   4848  CE1 PHE A 606      22.981   8.856  44.361  1.00 10.79           C  
ATOM   4849  CE2 PHE A 606      23.280   6.527  43.858  1.00 10.65           C  
ATOM   4850  CZ  PHE A 606      23.153   7.540  44.793  1.00  2.00           C  
ATOM   4851  N   PHE A 607      23.917   7.323  37.569  1.00 29.40           N  
ATOM   4852  CA  PHE A 607      23.579   7.209  36.160  1.00 27.81           C  
ATOM   4853  C   PHE A 607      22.523   6.123  36.054  1.00 34.75           C  
ATOM   4854  O   PHE A 607      22.740   4.997  36.501  1.00 29.19           O  
ATOM   4855  CB  PHE A 607      24.810   6.829  35.316  1.00 28.64           C  
ATOM   4856  CG  PHE A 607      26.033   7.690  35.568  1.00 27.01           C  
ATOM   4857  CD1 PHE A 607      27.106   7.204  36.343  1.00 26.88           C  
ATOM   4858  CD2 PHE A 607      26.115   8.994  35.041  1.00 22.65           C  
ATOM   4859  CE1 PHE A 607      28.264   8.018  36.590  1.00 22.16           C  
ATOM   4860  CE2 PHE A 607      27.262   9.826  35.278  1.00 19.63           C  
ATOM   4861  CZ  PHE A 607      28.333   9.345  36.046  1.00 16.88           C  
ATOM   4862  N   SER A 608      21.351   6.515  35.556  1.00 39.02           N  
ATOM   4863  CA  SER A 608      20.200   5.641  35.333  1.00 46.11           C  
ATOM   4864  C   SER A 608      19.109   6.455  34.671  1.00 48.30           C  
ATOM   4865  O   SER A 608      19.122   7.692  34.737  1.00 47.07           O  
ATOM   4866  CB  SER A 608      19.665   5.061  36.627  1.00 47.51           C  
ATOM   4867  OG  SER A 608      19.583   6.076  37.591  1.00 50.46           O  
ATOM   4868  N   ASN A 609      18.130   5.739  34.116  1.00 53.03           N  
ATOM   4869  CA  ASN A 609      17.005   6.315  33.387  1.00 56.31           C  
ATOM   4870  C   ASN A 609      15.711   6.416  34.185  1.00 59.28           C  
ATOM   4871  O   ASN A 609      14.676   6.879  33.683  1.00 61.64           O  
ATOM   4872  CB  ASN A 609      16.810   5.506  32.111  1.00 68.26           C  
ATOM   4873  CG  ASN A 609      18.086   5.435  31.279  1.00 65.58           C  
ATOM   4874  OD1 ASN A 609      18.461   6.406  30.618  1.00 69.42           O  
ATOM   4875  ND2 ASN A 609      18.796   4.310  31.368  1.00 70.98           N  
ATOM   4876  N   GLU A 610      15.835   6.092  35.465  1.00 60.81           N  
ATOM   4877  CA  GLU A 610      14.769   6.090  36.451  1.00 58.32           C  
ATOM   4878  C   GLU A 610      14.002   7.415  36.643  1.00 57.74           C  
ATOM   4879  O   GLU A 610      12.781   7.395  36.859  1.00 61.46           O  
ATOM   4880  CB  GLU A 610      15.389   5.629  37.774  1.00 65.61           C  
ATOM   4881  CG  GLU A 610      14.469   5.549  38.979  1.00 74.14           C  
ATOM   4882  CD  GLU A 610      13.447   4.445  38.870  1.00 78.28           C  
ATOM   4883  OE1 GLU A 610      13.854   3.269  38.685  1.00 74.12           O  
ATOM   4884  OE2 GLU A 610      12.242   4.775  38.961  1.00 72.56           O  
ATOM   4885  N   LYS A 611      14.719   8.539  36.592  1.00 55.06           N  
ATOM   4886  CA  LYS A 611      14.168   9.897  36.778  1.00 49.73           C  
ATOM   4887  C   LYS A 611      13.452  10.188  38.119  1.00 50.59           C  
ATOM   4888  O   LYS A 611      13.093  11.328  38.386  1.00 48.79           O  
ATOM   4889  CB  LYS A 611      13.347  10.369  35.553  1.00 48.47           C  
ATOM   4890  CG  LYS A 611      14.199  10.657  34.282  1.00 53.77           C  
ATOM   4891  CD  LYS A 611      13.336  10.892  33.024  1.00 50.86           C  
ATOM   4892  CE  LYS A 611      13.887  10.124  31.808  1.00 49.27           C  
ATOM   4893  NZ  LYS A 611      13.152  10.398  30.501  1.00 43.36           N  
ATOM   4894  N   PHE A 612      13.296   9.157  38.958  1.00 45.68           N  
ATOM   4895  CA  PHE A 612      12.689   9.242  40.300  1.00 46.81           C  
ATOM   4896  C   PHE A 612      13.648   8.675  41.359  1.00 44.65           C  
ATOM   4897  O   PHE A 612      13.286   7.920  42.283  1.00 43.60           O  
ATOM   4898  CB  PHE A 612      11.355   8.521  40.341  1.00 57.73           C  
ATOM   4899  CG  PHE A 612      10.204   9.414  40.045  1.00 65.99           C  
ATOM   4900  CD1 PHE A 612       9.691   9.501  38.725  1.00 65.88           C  
ATOM   4901  CD2 PHE A 612       9.657  10.231  41.064  1.00 62.72           C  
ATOM   4902  CE1 PHE A 612       8.645  10.398  38.411  1.00 65.69           C  
ATOM   4903  CE2 PHE A 612       8.600  11.147  40.780  1.00 69.04           C  
ATOM   4904  CZ  PHE A 612       8.091  11.234  39.447  1.00 69.47           C  
ATOM   4905  N   ILE A 613      14.866   9.179  41.239  1.00 39.00           N  
ATOM   4906  CA  ILE A 613      16.025   8.828  42.027  1.00 37.64           C  
ATOM   4907  C   ILE A 613      16.090   9.312  43.504  1.00 34.81           C  
ATOM   4908  O   ILE A 613      16.881   8.778  44.300  1.00 30.77           O  
ATOM   4909  CB  ILE A 613      17.275   9.148  41.110  1.00 40.89           C  
ATOM   4910  CG1 ILE A 613      17.362   8.059  40.045  1.00 33.73           C  
ATOM   4911  CG2 ILE A 613      18.591   9.181  41.822  1.00 34.90           C  
ATOM   4912  CD1 ILE A 613      18.045   8.467  38.798  1.00 41.09           C  
ATOM   4913  N   LYS A 614      15.199  10.230  43.904  1.00 29.82           N  
ATOM   4914  CA  LYS A 614      15.203  10.723  45.290  1.00 28.85           C  
ATOM   4915  C   LYS A 614      15.074   9.567  46.269  1.00 23.68           C  
ATOM   4916  O   LYS A 614      14.065   8.849  46.239  1.00 28.33           O  
ATOM   4917  CB  LYS A 614      14.085  11.739  45.553  1.00 23.64           C  
ATOM   4918  CG  LYS A 614      14.051  12.250  46.977  1.00 10.65           C  
ATOM   4919  CD  LYS A 614      13.133  13.408  47.165  1.00 11.84           C  
ATOM   4920  CE  LYS A 614      13.326  14.014  48.557  1.00 22.75           C  
ATOM   4921  NZ  LYS A 614      12.501  15.210  48.878  1.00 14.24           N  
ATOM   4922  N   GLY A 615      16.143   9.391  47.059  1.00 25.16           N  
ATOM   4923  CA  GLY A 615      16.244   8.347  48.078  1.00 25.42           C  
ATOM   4924  C   GLY A 615      17.307   7.301  47.755  1.00 22.80           C  
ATOM   4925  O   GLY A 615      17.666   6.458  48.592  1.00 18.09           O  
ATOM   4926  N   TYR A 616      17.834   7.374  46.536  1.00 21.92           N  
ATOM   4927  CA  TYR A 616      18.855   6.448  46.098  1.00 23.20           C  
ATOM   4928  C   TYR A 616      20.160   6.594  46.843  1.00 23.96           C  
ATOM   4929  O   TYR A 616      20.605   7.721  47.092  1.00 28.48           O  
ATOM   4930  CB  TYR A 616      19.075   6.595  44.612  1.00 22.45           C  
ATOM   4931  CG  TYR A 616      18.064   5.843  43.792  1.00 31.60           C  
ATOM   4932  CD1 TYR A 616      16.684   5.778  44.168  1.00 44.09           C  
ATOM   4933  CD2 TYR A 616      18.468   5.189  42.626  1.00 42.24           C  
ATOM   4934  CE1 TYR A 616      15.731   5.069  43.377  1.00 49.60           C  
ATOM   4935  CE2 TYR A 616      17.540   4.477  41.821  1.00 52.96           C  
ATOM   4936  CZ  TYR A 616      16.177   4.414  42.195  1.00 51.02           C  
ATOM   4937  OH  TYR A 616      15.333   3.673  41.383  1.00 51.78           O  
ATOM   4938  N   PHE A 617      20.784   5.450  47.156  1.00 20.19           N  
ATOM   4939  CA  PHE A 617      22.031   5.429  47.918  1.00 14.54           C  
ATOM   4940  C   PHE A 617      23.087   4.346  47.708  1.00 11.28           C  
ATOM   4941  O   PHE A 617      22.784   3.216  47.350  1.00 13.69           O  
ATOM   4942  CB  PHE A 617      21.706   5.510  49.419  1.00 14.67           C  
ATOM   4943  CG  PHE A 617      21.105   4.237  50.025  1.00 12.01           C  
ATOM   4944  CD1 PHE A 617      21.836   3.496  50.974  1.00  6.74           C  
ATOM   4945  CD2 PHE A 617      19.788   3.836  49.718  1.00 17.21           C  
ATOM   4946  CE1 PHE A 617      21.278   2.371  51.618  1.00  3.02           C  
ATOM   4947  CE2 PHE A 617      19.200   2.707  50.354  1.00 15.66           C  
ATOM   4948  CZ  PHE A 617      19.953   1.971  51.311  1.00 13.17           C  
ATOM   4949  N   TYR A 618      24.332   4.710  47.994  1.00  7.52           N  
ATOM   4950  CA  TYR A 618      25.465   3.785  47.947  1.00 12.82           C  
ATOM   4951  C   TYR A 618      26.066   4.057  49.312  1.00  9.40           C  
ATOM   4952  O   TYR A 618      26.211   5.218  49.688  1.00 13.01           O  
ATOM   4953  CB  TYR A 618      26.495   4.098  46.825  1.00 10.69           C  
ATOM   4954  CG  TYR A 618      27.577   3.018  46.715  1.00 13.85           C  
ATOM   4955  CD1 TYR A 618      27.378   1.888  45.898  1.00 23.68           C  
ATOM   4956  CD2 TYR A 618      28.709   3.022  47.562  1.00 15.92           C  
ATOM   4957  CE1 TYR A 618      28.257   0.772  45.936  1.00 26.02           C  
ATOM   4958  CE2 TYR A 618      29.598   1.905  47.620  1.00 24.21           C  
ATOM   4959  CZ  TYR A 618      29.362   0.783  46.804  1.00 26.75           C  
ATOM   4960  OH  TYR A 618      30.213  -0.304  46.862  1.00 24.81           O  
ATOM   4961  N   LYS A 619      26.408   3.005  50.048  1.00  7.84           N  
ATOM   4962  CA  LYS A 619      26.979   3.194  51.379  1.00 13.71           C  
ATOM   4963  C   LYS A 619      28.487   2.891  51.440  1.00 23.09           C  
ATOM   4964  O   LYS A 619      28.974   1.932  50.832  1.00 18.71           O  
ATOM   4965  CB  LYS A 619      26.177   2.387  52.412  1.00 18.21           C  
ATOM   4966  CG  LYS A 619      26.447   2.735  53.876  1.00 20.45           C  
ATOM   4967  CD  LYS A 619      25.514   1.959  54.815  1.00 19.13           C  
ATOM   4968  CE  LYS A 619      25.853   2.263  56.261  1.00 23.59           C  
ATOM   4969  NZ  LYS A 619      26.192   1.076  57.149  1.00 27.71           N  
ATOM   4970  N   LEU A 620      29.217   3.792  52.106  1.00 20.34           N  
ATOM   4971  CA  LEU A 620      30.663   3.690  52.298  1.00 25.32           C  
ATOM   4972  C   LEU A 620      31.047   3.214  53.715  1.00 31.82           C  
ATOM   4973  O   LEU A 620      30.174   2.830  54.510  1.00 31.86           O  
ATOM   4974  CB  LEU A 620      31.341   5.012  51.947  1.00 21.17           C  
ATOM   4975  CG  LEU A 620      31.095   5.427  50.500  1.00 16.85           C  
ATOM   4976  CD1 LEU A 620      31.455   6.877  50.273  1.00 12.08           C  
ATOM   4977  CD2 LEU A 620      31.872   4.495  49.576  1.00 15.55           C  
ATOM   4978  N   SER A 621      32.348   3.244  54.014  1.00 38.24           N  
ATOM   4979  CA  SER A 621      32.895   2.754  55.280  1.00 45.26           C  
ATOM   4980  C   SER A 621      32.502   3.410  56.592  1.00 49.28           C  
ATOM   4981  O   SER A 621      31.630   2.891  57.296  1.00 57.40           O  
ATOM   4982  CB  SER A 621      34.422   2.637  55.193  1.00 49.30           C  
ATOM   4983  OG  SER A 621      35.023   3.848  54.756  1.00 53.62           O  
ATOM   4984  N   GLU A 622      33.149   4.532  56.911  1.00 52.76           N  
ATOM   4985  CA  GLU A 622      32.937   5.283  58.157  1.00 56.03           C  
ATOM   4986  C   GLU A 622      31.589   6.036  58.189  1.00 51.20           C  
ATOM   4987  O   GLU A 622      31.531   7.259  58.413  1.00 53.13           O  
ATOM   4988  CB  GLU A 622      34.122   6.249  58.362  1.00 66.91           C  
ATOM   4989  CG  GLU A 622      35.530   5.614  58.297  1.00 62.56           C  
ATOM   4990  CD  GLU A 622      36.612   6.602  57.854  1.00 69.06           C  
ATOM   4991  OE1 GLU A 622      36.378   7.840  57.899  1.00 66.01           O  
ATOM   4992  OE2 GLU A 622      37.701   6.126  57.446  1.00 73.98           O  
ATOM   4993  N   ASP A 623      30.514   5.265  57.991  1.00 44.82           N  
ATOM   4994  CA  ASP A 623      29.124   5.726  57.941  1.00 36.82           C  
ATOM   4995  C   ASP A 623      28.885   6.960  57.077  1.00 35.96           C  
ATOM   4996  O   ASP A 623      28.374   7.987  57.526  1.00 30.21           O  
ATOM   4997  CB  ASP A 623      28.505   5.853  59.340  1.00 45.55           C  
ATOM   4998  CG  ASP A 623      27.588   4.668  59.687  1.00 47.24           C  
ATOM   4999  OD1 ASP A 623      27.461   3.739  58.850  1.00 58.23           O  
ATOM   5000  OD2 ASP A 623      26.974   4.660  60.776  1.00 42.03           O  
ATOM   5001  N   SER A 624      29.435   6.884  55.872  1.00 32.29           N  
ATOM   5002  CA  SER A 624      29.271   7.911  54.873  1.00 29.28           C  
ATOM   5003  C   SER A 624      28.393   7.260  53.799  1.00 31.26           C  
ATOM   5004  O   SER A 624      28.443   6.034  53.619  1.00 33.24           O  
ATOM   5005  CB  SER A 624      30.616   8.444  54.353  1.00 33.78           C  
ATOM   5006  OG  SER A 624      31.584   7.429  54.165  1.00 43.00           O  
ATOM   5007  N   VAL A 625      27.468   8.052  53.239  1.00 28.99           N  
ATOM   5008  CA  VAL A 625      26.491   7.607  52.231  1.00 21.19           C  
ATOM   5009  C   VAL A 625      26.395   8.626  51.109  1.00 26.57           C  
ATOM   5010  O   VAL A 625      26.232   9.828  51.366  1.00 21.82           O  
ATOM   5011  CB  VAL A 625      25.038   7.528  52.852  1.00 20.45           C  
ATOM   5012  CG1 VAL A 625      23.968   7.266  51.793  1.00 13.59           C  
ATOM   5013  CG2 VAL A 625      24.960   6.484  53.921  1.00 16.21           C  
ATOM   5014  N   ILE A 626      26.399   8.125  49.873  1.00 20.77           N  
ATOM   5015  CA  ILE A 626      26.237   8.974  48.689  1.00 23.05           C  
ATOM   5016  C   ILE A 626      24.731   8.872  48.504  1.00 24.55           C  
ATOM   5017  O   ILE A 626      24.187   7.787  48.336  1.00 24.72           O  
ATOM   5018  CB  ILE A 626      27.015   8.432  47.521  1.00 26.08           C  
ATOM   5019  CG1 ILE A 626      28.496   8.499  47.876  1.00 33.27           C  
ATOM   5020  CG2 ILE A 626      26.755   9.258  46.269  1.00 23.64           C  
ATOM   5021  CD1 ILE A 626      29.299   7.335  47.306  1.00 47.68           C  
ATOM   5022  N   LEU A 627      24.070  10.016  48.586  1.00 24.15           N  
ATOM   5023  CA  LEU A 627      22.628  10.067  48.565  1.00 20.50           C  
ATOM   5024  C   LEU A 627      21.990  10.964  47.521  1.00 26.14           C  
ATOM   5025  O   LEU A 627      22.395  12.121  47.349  1.00 27.97           O  
ATOM   5026  CB  LEU A 627      22.173  10.533  49.960  1.00 16.28           C  
ATOM   5027  CG  LEU A 627      20.697  10.543  50.312  1.00 14.42           C  
ATOM   5028  CD1 LEU A 627      20.211   9.104  50.258  1.00 15.54           C  
ATOM   5029  CD2 LEU A 627      20.433  11.196  51.690  1.00  6.67           C  
ATOM   5030  N   ALA A 628      20.902  10.474  46.932  1.00 18.05           N  
ATOM   5031  CA  ALA A 628      20.154  11.252  45.969  1.00 17.63           C  
ATOM   5032  C   ALA A 628      19.033  11.957  46.756  1.00 20.29           C  
ATOM   5033  O   ALA A 628      18.083  11.296  47.226  1.00 14.79           O  
ATOM   5034  CB  ALA A 628      19.592  10.357  44.950  1.00 13.54           C  
ATOM   5035  N   THR A 629      19.161  13.281  46.887  1.00 15.50           N  
ATOM   5036  CA  THR A 629      18.206  14.111  47.620  1.00 19.34           C  
ATOM   5037  C   THR A 629      17.026  14.679  46.869  1.00 26.61           C  
ATOM   5038  O   THR A 629      16.128  15.273  47.487  1.00 27.41           O  
ATOM   5039  CB  THR A 629      18.892  15.295  48.210  1.00 15.76           C  
ATOM   5040  OG1 THR A 629      19.850  15.817  47.265  1.00 17.31           O  
ATOM   5041  CG2 THR A 629      19.550  14.914  49.503  1.00 18.96           C  
ATOM   5042  N   TYR A 630      17.075  14.598  45.538  1.00 32.97           N  
ATOM   5043  CA  TYR A 630      16.027  15.130  44.660  1.00 32.57           C  
ATOM   5044  C   TYR A 630      15.978  14.331  43.354  1.00 33.56           C  
ATOM   5045  O   TYR A 630      16.993  13.777  42.937  1.00 32.85           O  
ATOM   5046  CB  TYR A 630      16.254  16.640  44.387  1.00 32.06           C  
ATOM   5047  CG  TYR A 630      17.451  17.025  43.510  1.00 33.33           C  
ATOM   5048  CD1 TYR A 630      17.252  17.639  42.258  1.00 39.01           C  
ATOM   5049  CD2 TYR A 630      18.779  16.836  43.948  1.00 34.01           C  
ATOM   5050  CE1 TYR A 630      18.345  18.070  41.454  1.00 42.33           C  
ATOM   5051  CE2 TYR A 630      19.886  17.258  43.155  1.00 40.24           C  
ATOM   5052  CZ  TYR A 630      19.658  17.882  41.910  1.00 46.82           C  
ATOM   5053  OH  TYR A 630      20.710  18.357  41.144  1.00 44.60           O  
ATOM   5054  N   ASN A 631      14.810  14.330  42.702  1.00 39.82           N  
ATOM   5055  CA  ASN A 631      14.568  13.623  41.435  1.00 40.64           C  
ATOM   5056  C   ASN A 631      15.218  14.351  40.245  1.00 47.03           C  
ATOM   5057  O   ASN A 631      15.355  15.579  40.274  1.00 45.06           O  
ATOM   5058  CB  ASN A 631      13.061  13.516  41.186  1.00 41.99           C  
ATOM   5059  CG  ASN A 631      12.280  13.056  42.413  1.00 34.94           C  
ATOM   5060  OD1 ASN A 631      12.458  11.947  42.886  1.00 39.56           O  
ATOM   5061  ND2 ASN A 631      11.394  13.909  42.911  1.00 31.69           N  
ATOM   5062  N   GLN A 632      15.607  13.602  39.206  1.00 49.64           N  
ATOM   5063  CA  GLN A 632      16.245  14.183  38.005  1.00 61.01           C  
ATOM   5064  C   GLN A 632      15.226  14.964  37.183  1.00 67.23           C  
ATOM   5065  O   GLN A 632      14.360  14.358  36.539  1.00 68.65           O  
ATOM   5066  CB  GLN A 632      16.839  13.103  37.088  1.00 58.97           C  
ATOM   5067  CG  GLN A 632      17.978  12.273  37.639  1.00 65.26           C  
ATOM   5068  CD  GLN A 632      18.582  11.338  36.582  1.00 72.46           C  
ATOM   5069  OE1 GLN A 632      17.943  10.376  36.143  1.00 65.28           O  
ATOM   5070  NE2 GLN A 632      19.819  11.622  36.177  1.00 68.13           N  
ATOM   5071  N   VAL A 633      15.311  16.295  37.221  1.00 72.62           N  
ATOM   5072  CA  VAL A 633      14.386  17.148  36.461  1.00 75.77           C  
ATOM   5073  C   VAL A 633      15.008  17.612  35.134  1.00 82.40           C  
ATOM   5074  O   VAL A 633      14.470  17.307  34.061  1.00 82.51           O  
ATOM   5075  CB  VAL A 633      13.857  18.331  37.323  1.00 71.85           C  
ATOM   5076  CG1 VAL A 633      12.894  19.200  36.531  1.00 72.42           C  
ATOM   5077  CG2 VAL A 633      13.114  17.785  38.531  1.00 75.23           C  
ATOM   5078  N   TYR A 634      16.104  18.374  35.208  1.00 92.12           N  
ATOM   5079  CA  TYR A 634      16.819  18.835  34.006  1.00101.07           C  
ATOM   5080  C   TYR A 634      17.968  17.860  33.741  1.00 99.73           C  
ATOM   5081  O   TYR A 634      18.540  17.296  34.684  1.00102.29           O  
ATOM   5082  CB  TYR A 634      17.356  20.271  34.161  1.00107.34           C  
ATOM   5083  CG  TYR A 634      16.287  21.357  34.227  1.00109.94           C  
ATOM   5084  CD1 TYR A 634      16.104  22.114  35.405  1.00111.05           C  
ATOM   5085  CD2 TYR A 634      15.430  21.618  33.130  1.00112.09           C  
ATOM   5086  CE1 TYR A 634      15.078  23.115  35.502  1.00110.02           C  
ATOM   5087  CE2 TYR A 634      14.396  22.620  33.215  1.00112.68           C  
ATOM   5088  CZ  TYR A 634      14.231  23.355  34.409  1.00110.50           C  
ATOM   5089  OH  TYR A 634      13.231  24.296  34.528  1.00108.66           O  
ATOM   5090  N   GLU A 635      18.291  17.676  32.458  1.00105.73           N  
ATOM   5091  CA  GLU A 635      19.338  16.753  31.984  1.00102.25           C  
ATOM   5092  C   GLU A 635      20.763  17.022  32.463  1.00 99.81           C  
ATOM   5093  O   GLU A 635      21.255  18.153  32.341  1.00100.84           O  
ATOM   5094  CB  GLU A 635      19.338  16.716  30.460  1.00 99.19           C  
ATOM   5095  CG  GLU A 635      17.978  16.499  29.843  1.00101.25           C  
ATOM   5096  CD  GLU A 635      18.056  16.423  28.347  1.00 99.51           C  
ATOM   5097  OE1 GLU A 635      18.517  17.409  27.726  1.00100.55           O  
ATOM   5098  OE2 GLU A 635      17.678  15.364  27.796  1.00103.45           O  
ATOM   5099  N   GLY A 636      21.408  15.978  33.003  1.00102.70           N  
ATOM   5100  CA  GLY A 636      22.774  16.076  33.515  1.00 98.91           C  
ATOM   5101  C   GLY A 636      22.945  16.901  34.787  1.00 96.25           C  
ATOM   5102  O   GLY A 636      24.066  17.033  35.306  1.00 95.22           O  
ATOM   5103  N   THR A 637      21.828  17.483  35.251  1.00 96.60           N  
ATOM   5104  CA  THR A 637      21.755  18.310  36.466  1.00 91.32           C  
ATOM   5105  C   THR A 637      21.426  17.443  37.696  1.00 84.41           C  
ATOM   5106  O   THR A 637      20.346  17.574  38.311  1.00 85.95           O  
ATOM   5107  CB  THR A 637      20.694  19.477  36.349  1.00 91.74           C  
ATOM   5108  OG1 THR A 637      20.799  20.116  35.071  1.00 91.21           O  
ATOM   5109  CG2 THR A 637      20.904  20.534  37.454  1.00 93.18           C  
ATOM   5110  N   HIS A 638      22.305  16.478  37.966  1.00 76.67           N  
ATOM   5111  CA  HIS A 638      22.145  15.668  39.152  1.00 66.37           C  
ATOM   5112  C   HIS A 638      23.390  15.516  39.981  1.00 59.71           C  
ATOM   5113  O   HIS A 638      24.306  14.759  39.657  1.00 65.18           O  
ATOM   5114  CB  HIS A 638      21.467  14.326  38.956  1.00 71.49           C  
ATOM   5115  CG  HIS A 638      20.886  13.816  40.235  1.00 63.88           C  
ATOM   5116  ND1 HIS A 638      21.562  12.937  41.056  1.00 64.51           N  
ATOM   5117  CD2 HIS A 638      19.793  14.213  40.931  1.00 59.98           C  
ATOM   5118  CE1 HIS A 638      20.916  12.828  42.203  1.00 63.00           C  
ATOM   5119  NE2 HIS A 638      19.841  13.594  42.155  1.00 57.50           N  
ATOM   5120  N   GLN A 639      23.340  16.219  41.106  1.00 57.68           N  
ATOM   5121  CA  GLN A 639      24.401  16.266  42.075  1.00 53.24           C  
ATOM   5122  C   GLN A 639      23.976  15.547  43.366  1.00 46.59           C  
ATOM   5123  O   GLN A 639      23.128  16.056  44.120  1.00 50.96           O  
ATOM   5124  CB  GLN A 639      24.729  17.725  42.402  1.00 56.28           C  
ATOM   5125  CG  GLN A 639      24.673  18.726  41.249  1.00 72.12           C  
ATOM   5126  CD  GLN A 639      25.980  19.471  41.082  1.00 76.11           C  
ATOM   5127  OE1 GLN A 639      27.024  18.854  40.837  1.00 81.50           O  
ATOM   5128  NE2 GLN A 639      25.939  20.799  41.229  1.00 76.49           N  
ATOM   5129  N   PRO A 640      24.519  14.333  43.618  1.00 39.10           N  
ATOM   5130  CA  PRO A 640      24.161  13.604  44.838  1.00 32.80           C  
ATOM   5131  C   PRO A 640      25.001  14.164  45.975  1.00 28.28           C  
ATOM   5132  O   PRO A 640      26.142  14.581  45.751  1.00 35.06           O  
ATOM   5133  CB  PRO A 640      24.619  12.176  44.526  1.00 28.12           C  
ATOM   5134  CG  PRO A 640      24.771  12.139  43.077  1.00 30.71           C  
ATOM   5135  CD  PRO A 640      25.328  13.463  42.745  1.00 32.68           C  
ATOM   5136  N   ILE A 641      24.455  14.203  47.184  1.00 25.21           N  
ATOM   5137  CA  ILE A 641      25.244  14.699  48.317  1.00 21.80           C  
ATOM   5138  C   ILE A 641      25.908  13.537  49.079  1.00 24.19           C  
ATOM   5139  O   ILE A 641      25.526  12.369  48.927  1.00 22.38           O  
ATOM   5140  CB  ILE A 641      24.415  15.608  49.282  1.00 15.31           C  
ATOM   5141  CG1 ILE A 641      23.478  14.771  50.157  1.00  6.73           C  
ATOM   5142  CG2 ILE A 641      23.657  16.683  48.477  1.00  7.13           C  
ATOM   5143  CD1 ILE A 641      22.941  15.497  51.349  1.00 11.14           C  
ATOM   5144  N   LYS A 642      26.958  13.849  49.830  1.00 18.85           N  
ATOM   5145  CA  LYS A 642      27.640  12.838  50.623  1.00 17.02           C  
ATOM   5146  C   LYS A 642      27.443  13.274  52.045  1.00 18.15           C  
ATOM   5147  O   LYS A 642      27.809  14.388  52.424  1.00 15.75           O  
ATOM   5148  CB  LYS A 642      29.123  12.720  50.264  1.00 14.27           C  
ATOM   5149  CG  LYS A 642      29.954  11.863  51.210  1.00 13.78           C  
ATOM   5150  CD  LYS A 642      31.389  11.716  50.736  1.00 23.51           C  
ATOM   5151  CE  LYS A 642      32.333  11.655  51.928  1.00 33.39           C  
ATOM   5152  NZ  LYS A 642      33.674  11.102  51.565  1.00 46.65           N  
ATOM   5153  N   VAL A 643      26.743  12.417  52.787  1.00 23.52           N  
ATOM   5154  CA  VAL A 643      26.416  12.617  54.210  1.00 20.76           C  
ATOM   5155  C   VAL A 643      27.398  11.764  54.994  1.00 21.27           C  
ATOM   5156  O   VAL A 643      27.566  10.598  54.677  1.00 18.88           O  
ATOM   5157  CB  VAL A 643      24.984  12.106  54.541  1.00 21.97           C  
ATOM   5158  CG1 VAL A 643      24.698  12.240  56.032  1.00 19.84           C  
ATOM   5159  CG2 VAL A 643      23.943  12.832  53.710  1.00 15.58           C  
ATOM   5160  N   ARG A 644      28.041  12.354  55.996  1.00 19.65           N  
ATOM   5161  CA  ARG A 644      28.990  11.631  56.816  1.00 21.69           C  
ATOM   5162  C   ARG A 644      28.608  11.731  58.286  1.00 22.93           C  
ATOM   5163  O   ARG A 644      28.277  12.812  58.765  1.00 23.36           O  
ATOM   5164  CB  ARG A 644      30.411  12.158  56.587  1.00 29.23           C  
ATOM   5165  CG  ARG A 644      31.504  11.339  57.303  1.00 43.97           C  
ATOM   5166  CD  ARG A 644      32.873  11.980  57.213  1.00 45.30           C  
ATOM   5167  NE  ARG A 644      33.739  11.519  58.297  1.00 62.63           N  
ATOM   5168  CZ  ARG A 644      34.912  12.058  58.628  1.00 60.36           C  
ATOM   5169  NH1 ARG A 644      35.406  13.105  57.956  1.00 65.56           N  
ATOM   5170  NH2 ARG A 644      35.584  11.559  59.656  1.00 59.99           N  
ATOM   5171  N   LYS A 645      28.567  10.592  58.975  1.00 22.95           N  
ATOM   5172  CA  LYS A 645      28.248  10.586  60.397  1.00 24.82           C  
ATOM   5173  C   LYS A 645      29.597  10.649  61.043  1.00 28.22           C  
ATOM   5174  O   LYS A 645      30.345   9.663  61.067  1.00 32.83           O  
ATOM   5175  CB  LYS A 645      27.522   9.317  60.830  1.00 31.29           C  
ATOM   5176  CG  LYS A 645      27.167   9.290  62.324  1.00 31.86           C  
ATOM   5177  CD  LYS A 645      26.406   8.027  62.699  1.00 25.75           C  
ATOM   5178  CE  LYS A 645      27.258   6.914  63.233  1.00 20.34           C  
ATOM   5179  NZ  LYS A 645      26.407   5.718  63.566  1.00 31.03           N  
ATOM   5180  N   VAL A 646      29.927  11.844  61.511  1.00 28.90           N  
ATOM   5181  CA  VAL A 646      31.208  12.084  62.134  1.00 28.07           C  
ATOM   5182  C   VAL A 646      31.135  11.533  63.530  1.00 27.06           C  
ATOM   5183  O   VAL A 646      31.916  10.664  63.887  1.00 27.18           O  
ATOM   5184  CB  VAL A 646      31.554  13.586  62.106  1.00 30.26           C  
ATOM   5185  CG1 VAL A 646      32.948  13.860  62.729  1.00 29.75           C  
ATOM   5186  CG2 VAL A 646      31.543  14.062  60.690  1.00 17.40           C  
ATOM   5187  N   TYR A 647      30.092  11.953  64.237  1.00 25.71           N  
ATOM   5188  CA  TYR A 647      29.813  11.550  65.607  1.00 32.53           C  
ATOM   5189  C   TYR A 647      28.322  11.250  65.611  1.00 35.45           C  
ATOM   5190  O   TYR A 647      27.550  11.963  64.961  1.00 38.41           O  
ATOM   5191  CB  TYR A 647      30.159  12.701  66.560  1.00 35.52           C  
ATOM   5192  CG  TYR A 647      30.159  12.393  68.045  1.00 32.54           C  
ATOM   5193  CD1 TYR A 647      31.251  11.719  68.652  1.00 33.99           C  
ATOM   5194  CD2 TYR A 647      29.087  12.813  68.865  1.00 38.58           C  
ATOM   5195  CE1 TYR A 647      31.272  11.473  70.065  1.00 41.87           C  
ATOM   5196  CE2 TYR A 647      29.090  12.569  70.270  1.00 44.48           C  
ATOM   5197  CZ  TYR A 647      30.182  11.900  70.864  1.00 40.04           C  
ATOM   5198  OH  TYR A 647      30.156  11.656  72.222  1.00 41.00           O  
ATOM   5199  N   GLY A 648      27.931  10.164  66.279  1.00 29.44           N  
ATOM   5200  CA  GLY A 648      26.527   9.785  66.320  1.00 30.39           C  
ATOM   5201  C   GLY A 648      26.191   8.408  66.853  1.00 28.83           C  
ATOM   5202  O   GLY A 648      26.906   7.435  66.640  1.00 31.48           O  
ATOM   5203  N   GLU A 649      25.027   8.339  67.487  1.00 33.95           N  
ATOM   5204  CA  GLU A 649      24.482   7.140  68.124  1.00 34.61           C  
ATOM   5205  C   GLU A 649      23.508   6.444  67.173  1.00 42.68           C  
ATOM   5206  O   GLU A 649      23.348   5.216  67.235  1.00 40.89           O  
ATOM   5207  CB  GLU A 649      23.781   7.624  69.396  1.00 36.57           C  
ATOM   5208  CG  GLU A 649      22.991   6.690  70.257  1.00 29.72           C  
ATOM   5209  CD  GLU A 649      22.130   7.501  71.216  1.00 36.04           C  
ATOM   5210  OE1 GLU A 649      20.894   7.430  71.093  1.00 39.97           O  
ATOM   5211  OE2 GLU A 649      22.683   8.241  72.065  1.00 40.39           O  
ATOM   5212  N   LEU A 650      22.880   7.244  66.295  1.00 42.06           N  
ATOM   5213  CA  LEU A 650      21.894   6.775  65.302  1.00 39.51           C  
ATOM   5214  C   LEU A 650      22.533   6.297  63.995  1.00 39.46           C  
ATOM   5215  O   LEU A 650      23.598   6.762  63.625  1.00 36.85           O  
ATOM   5216  CB  LEU A 650      20.879   7.891  64.978  1.00 45.47           C  
ATOM   5217  CG  LEU A 650      19.987   8.503  66.072  1.00 40.15           C  
ATOM   5218  CD1 LEU A 650      19.140   9.611  65.483  1.00 37.93           C  
ATOM   5219  CD2 LEU A 650      19.095   7.471  66.747  1.00 48.38           C  
ATOM   5220  N   PRO A 651      21.913   5.331  63.300  1.00 41.50           N  
ATOM   5221  CA  PRO A 651      22.484   4.843  62.032  1.00 45.48           C  
ATOM   5222  C   PRO A 651      22.343   5.871  60.902  1.00 42.14           C  
ATOM   5223  O   PRO A 651      21.390   6.650  60.927  1.00 37.81           O  
ATOM   5224  CB  PRO A 651      21.620   3.614  61.728  1.00 50.44           C  
ATOM   5225  CG  PRO A 651      21.229   3.132  63.096  1.00 49.07           C  
ATOM   5226  CD  PRO A 651      20.858   4.415  63.775  1.00 38.32           C  
ATOM   5227  N   VAL A 652      23.240   5.842  59.904  1.00 39.63           N  
ATOM   5228  CA  VAL A 652      23.170   6.788  58.766  1.00 30.84           C  
ATOM   5229  C   VAL A 652      21.890   6.733  57.987  1.00 28.94           C  
ATOM   5230  O   VAL A 652      21.393   7.758  57.573  1.00 37.76           O  
ATOM   5231  CB  VAL A 652      24.255   6.632  57.703  1.00 28.43           C  
ATOM   5232  CG1 VAL A 652      25.261   7.728  57.801  1.00 21.46           C  
ATOM   5233  CG2 VAL A 652      24.841   5.292  57.739  1.00 28.70           C  
ATOM   5234  N   GLU A 653      21.366   5.536  57.781  1.00 21.90           N  
ATOM   5235  CA  GLU A 653      20.119   5.370  57.058  1.00 30.55           C  
ATOM   5236  C   GLU A 653      18.955   6.183  57.687  1.00 26.26           C  
ATOM   5237  O   GLU A 653      18.175   6.830  56.973  1.00 24.56           O  
ATOM   5238  CB  GLU A 653      19.777   3.877  56.961  1.00 27.65           C  
ATOM   5239  CG  GLU A 653      20.723   3.108  56.045  1.00 28.53           C  
ATOM   5240  CD  GLU A 653      21.725   2.234  56.787  1.00 41.91           C  
ATOM   5241  OE1 GLU A 653      21.798   2.266  58.047  1.00 36.08           O  
ATOM   5242  OE2 GLU A 653      22.449   1.491  56.082  1.00 43.51           O  
ATOM   5243  N   VAL A 654      18.954   6.253  59.018  1.00 20.24           N  
ATOM   5244  CA  VAL A 654      17.937   6.976  59.777  1.00 24.79           C  
ATOM   5245  C   VAL A 654      18.156   8.494  59.617  1.00 23.29           C  
ATOM   5246  O   VAL A 654      17.216   9.248  59.360  1.00 27.32           O  
ATOM   5247  CB  VAL A 654      17.966   6.562  61.291  1.00 31.55           C  
ATOM   5248  CG1 VAL A 654      16.987   7.411  62.114  1.00 34.61           C  
ATOM   5249  CG2 VAL A 654      17.614   5.080  61.458  1.00 24.41           C  
ATOM   5250  N   LEU A 655      19.413   8.910  59.705  1.00 20.86           N  
ATOM   5251  CA  LEU A 655      19.798  10.300  59.568  1.00 15.05           C  
ATOM   5252  C   LEU A 655      19.592  10.802  58.166  1.00 19.73           C  
ATOM   5253  O   LEU A 655      19.336  11.994  57.962  1.00 22.55           O  
ATOM   5254  CB  LEU A 655      21.262  10.447  59.909  1.00 25.99           C  
ATOM   5255  CG  LEU A 655      21.644   9.961  61.301  1.00 32.39           C  
ATOM   5256  CD1 LEU A 655      23.170   9.810  61.408  1.00 22.14           C  
ATOM   5257  CD2 LEU A 655      21.056  10.910  62.363  1.00 41.29           C  
ATOM   5258  N   CYS A 656      19.734   9.883  57.207  1.00 16.64           N  
ATOM   5259  CA  CYS A 656      19.559  10.174  55.784  1.00 17.92           C  
ATOM   5260  C   CYS A 656      18.102  10.421  55.458  1.00 19.37           C  
ATOM   5261  O   CYS A 656      17.785  11.343  54.722  1.00 17.52           O  
ATOM   5262  CB  CYS A 656      20.090   9.038  54.923  1.00 14.74           C  
ATOM   5263  SG  CYS A 656      21.895   8.888  54.847  1.00 26.19           S  
ATOM   5264  N   SER A 657      17.222   9.629  56.072  1.00 22.85           N  
ATOM   5265  CA  SER A 657      15.774   9.753  55.901  1.00 26.10           C  
ATOM   5266  C   SER A 657      15.281  11.117  56.423  1.00 24.36           C  
ATOM   5267  O   SER A 657      14.423  11.753  55.807  1.00 20.14           O  
ATOM   5268  CB  SER A 657      15.062   8.595  56.622  1.00 27.42           C  
ATOM   5269  OG  SER A 657      13.716   8.898  56.972  1.00 27.03           O  
ATOM   5270  N   GLN A 658      15.874  11.576  57.521  1.00 16.48           N  
ATOM   5271  CA  GLN A 658      15.520  12.866  58.124  1.00 17.86           C  
ATOM   5272  C   GLN A 658      15.996  14.030  57.247  1.00 19.21           C  
ATOM   5273  O   GLN A 658      15.421  15.095  57.259  1.00 14.71           O  
ATOM   5274  CB  GLN A 658      16.187  12.996  59.483  1.00 16.52           C  
ATOM   5275  CG  GLN A 658      15.960  11.822  60.396  1.00 24.69           C  
ATOM   5276  CD  GLN A 658      16.729  11.900  61.695  1.00 25.44           C  
ATOM   5277  OE1 GLN A 658      17.866  12.390  61.757  1.00 18.63           O  
ATOM   5278  NE2 GLN A 658      16.098  11.414  62.756  1.00 27.10           N  
ATOM   5279  N   ILE A 659      17.080  13.809  56.506  1.00 19.71           N  
ATOM   5280  CA  ILE A 659      17.650  14.804  55.608  1.00 16.61           C  
ATOM   5281  C   ILE A 659      16.694  14.958  54.456  1.00 17.74           C  
ATOM   5282  O   ILE A 659      16.318  16.076  54.106  1.00 26.79           O  
ATOM   5283  CB  ILE A 659      19.027  14.322  55.146  1.00 10.33           C  
ATOM   5284  CG1 ILE A 659      20.062  14.943  56.046  1.00  6.23           C  
ATOM   5285  CG2 ILE A 659      19.301  14.556  53.614  1.00 15.14           C  
ATOM   5286  CD1 ILE A 659      21.330  14.258  55.970  1.00  8.02           C  
ATOM   5287  N   LEU A 660      16.276  13.802  53.929  1.00 15.73           N  
ATOM   5288  CA  LEU A 660      15.339  13.675  52.821  1.00  8.18           C  
ATOM   5289  C   LEU A 660      13.998  14.275  53.156  1.00 10.24           C  
ATOM   5290  O   LEU A 660      13.400  14.936  52.314  1.00 12.21           O  
ATOM   5291  CB  LEU A 660      15.136  12.223  52.486  1.00  2.00           C  
ATOM   5292  CG  LEU A 660      16.186  11.583  51.623  1.00  6.94           C  
ATOM   5293  CD1 LEU A 660      15.932  10.108  51.526  1.00  9.70           C  
ATOM   5294  CD2 LEU A 660      16.094  12.214  50.265  1.00  8.86           C  
ATOM   5295  N   SER A 661      13.556  14.104  54.405  1.00  9.01           N  
ATOM   5296  CA  SER A 661      12.278  14.669  54.829  1.00 12.08           C  
ATOM   5297  C   SER A 661      12.361  16.178  54.950  1.00  9.79           C  
ATOM   5298  O   SER A 661      11.456  16.864  54.520  1.00 13.92           O  
ATOM   5299  CB  SER A 661      11.812  14.045  56.137  1.00 15.09           C  
ATOM   5300  OG  SER A 661      11.487  12.673  55.940  1.00 19.05           O  
ATOM   5301  N   LEU A 662      13.508  16.679  55.403  1.00  9.05           N  
ATOM   5302  CA  LEU A 662      13.744  18.110  55.592  1.00  5.31           C  
ATOM   5303  C   LEU A 662      13.927  18.886  54.319  1.00  6.03           C  
ATOM   5304  O   LEU A 662      13.985  20.101  54.377  1.00  2.00           O  
ATOM   5305  CB  LEU A 662      14.964  18.357  56.493  1.00  5.76           C  
ATOM   5306  CG  LEU A 662      14.840  18.068  57.995  1.00  6.29           C  
ATOM   5307  CD1 LEU A 662      16.182  18.144  58.668  1.00 10.02           C  
ATOM   5308  CD2 LEU A 662      13.857  18.985  58.680  1.00 13.47           C  
ATOM   5309  N   THR A 663      14.032  18.207  53.172  1.00  8.44           N  
ATOM   5310  CA  THR A 663      14.185  18.920  51.891  1.00  9.09           C  
ATOM   5311  C   THR A 663      12.860  19.589  51.605  1.00 11.75           C  
ATOM   5312  O   THR A 663      12.791  20.636  50.999  1.00 10.00           O  
ATOM   5313  CB  THR A 663      14.421  17.977  50.744  1.00  9.78           C  
ATOM   5314  OG1 THR A 663      13.427  16.941  50.788  1.00 12.99           O  
ATOM   5315  CG2 THR A 663      15.804  17.393  50.802  1.00  3.32           C  
ATOM   5316  N   LEU A 664      11.814  18.947  52.110  1.00 16.18           N  
ATOM   5317  CA  LEU A 664      10.427  19.380  51.975  1.00 18.12           C  
ATOM   5318  C   LEU A 664      10.085  20.573  52.852  1.00 16.25           C  
ATOM   5319  O   LEU A 664       8.992  21.131  52.756  1.00 19.82           O  
ATOM   5320  CB  LEU A 664       9.476  18.221  52.296  1.00 17.88           C  
ATOM   5321  CG  LEU A 664       9.767  16.821  51.756  1.00 18.92           C  
ATOM   5322  CD1 LEU A 664       8.558  15.984  52.033  1.00 11.05           C  
ATOM   5323  CD2 LEU A 664      10.125  16.807  50.275  1.00 12.02           C  
HETATM 5324  N   MSE A 665      11.015  20.951  53.714  1.00 12.77           N  
HETATM 5325  CA  MSE A 665      10.812  22.106  54.559  1.00 16.55           C  
HETATM 5326  C   MSE A 665      11.314  23.347  53.882  1.00 17.28           C  
HETATM 5327  O   MSE A 665      11.421  24.400  54.496  1.00 24.35           O  
HETATM 5328  CB  MSE A 665      11.442  21.915  55.938  1.00 26.00           C  
HETATM 5329  CG  MSE A 665      10.678  20.939  56.793  1.00 34.73           C  
HETATM 5330 SE   MSE A 665       8.761  21.100  56.530  1.00 39.97          SE  
HETATM 5331  CE  MSE A 665       8.392  22.248  57.952  1.00 34.03           C  
ATOM   5332  N   ASN A 666      11.598  23.216  52.591  1.00 23.65           N  
ATOM   5333  CA  ASN A 666      12.068  24.321  51.763  1.00 17.91           C  
ATOM   5334  C   ASN A 666      10.934  24.908  50.937  1.00 19.67           C  
ATOM   5335  O   ASN A 666      11.137  25.835  50.163  1.00 19.52           O  
ATOM   5336  CB  ASN A 666      13.200  23.848  50.883  1.00 22.89           C  
ATOM   5337  CG  ASN A 666      14.453  23.662  51.650  1.00 17.58           C  
ATOM   5338  OD1 ASN A 666      14.889  24.585  52.340  1.00 25.42           O  
ATOM   5339  ND2 ASN A 666      15.049  22.468  51.566  1.00 26.40           N  
ATOM   5340  N   TYR A 667       9.766  24.283  51.088  1.00 21.34           N  
ATOM   5341  CA  TYR A 667       8.495  24.671  50.487  1.00 25.03           C  
ATOM   5342  C   TYR A 667       8.545  25.058  49.024  1.00 28.74           C  
ATOM   5343  O   TYR A 667       8.037  26.106  48.623  1.00 29.20           O  
ATOM   5344  CB  TYR A 667       7.857  25.800  51.309  1.00 19.14           C  
ATOM   5345  CG  TYR A 667       7.735  25.488  52.769  1.00 11.87           C  
ATOM   5346  CD1 TYR A 667       8.716  25.911  53.680  1.00 17.17           C  
ATOM   5347  CD2 TYR A 667       6.648  24.773  53.255  1.00 11.69           C  
ATOM   5348  CE1 TYR A 667       8.606  25.636  55.060  1.00 18.91           C  
ATOM   5349  CE2 TYR A 667       6.521  24.478  54.635  1.00 16.11           C  
ATOM   5350  CZ  TYR A 667       7.506  24.923  55.523  1.00 20.60           C  
ATOM   5351  OH  TYR A 667       7.359  24.746  56.872  1.00 24.04           O  
ATOM   5352  N   SER A 668       9.196  24.224  48.232  1.00 32.30           N  
ATOM   5353  CA  SER A 668       9.310  24.461  46.807  1.00 33.51           C  
ATOM   5354  C   SER A 668       8.835  23.173  46.161  1.00 35.09           C  
ATOM   5355  O   SER A 668       9.634  22.276  45.845  1.00 39.09           O  
ATOM   5356  CB  SER A 668      10.759  24.788  46.465  1.00 35.10           C  
ATOM   5357  OG  SER A 668      10.918  24.996  45.078  1.00 43.29           O  
ATOM   5358  N   SER A 669       7.517  23.070  46.028  1.00 36.21           N  
ATOM   5359  CA  SER A 669       6.895  21.880  45.462  1.00 37.25           C  
ATOM   5360  C   SER A 669       6.996  21.685  43.959  1.00 39.75           C  
ATOM   5361  O   SER A 669       6.967  20.567  43.451  1.00 34.85           O  
ATOM   5362  CB  SER A 669       5.437  21.849  45.852  1.00 36.55           C  
ATOM   5363  OG  SER A 669       4.740  23.061  45.625  1.00 36.31           O  
ATOM   5364  N   PHE A 670       7.104  22.802  43.263  1.00 39.38           N  
ATOM   5365  CA  PHE A 670       7.152  22.805  41.816  1.00 43.02           C  
ATOM   5366  C   PHE A 670       8.576  22.797  41.304  1.00 42.30           C  
ATOM   5367  O   PHE A 670       8.847  22.440  40.166  1.00 37.70           O  
ATOM   5368  CB  PHE A 670       6.323  23.998  41.311  1.00 51.20           C  
ATOM   5369  CG  PHE A 670       4.884  23.975  41.804  1.00 54.67           C  
ATOM   5370  CD1 PHE A 670       4.515  24.665  42.964  1.00 52.50           C  
ATOM   5371  CD2 PHE A 670       3.916  23.172  41.173  1.00 57.54           C  
ATOM   5372  CE1 PHE A 670       3.198  24.563  43.512  1.00 47.55           C  
ATOM   5373  CE2 PHE A 670       2.596  23.060  41.709  1.00 57.53           C  
ATOM   5374  CZ  PHE A 670       2.245  23.763  42.884  1.00 54.26           C  
ATOM   5375  N   GLN A 671       9.491  23.126  42.199  1.00 48.21           N  
ATOM   5376  CA  GLN A 671      10.911  23.166  41.887  1.00 51.80           C  
ATOM   5377  C   GLN A 671      11.673  22.260  42.861  1.00 53.25           C  
ATOM   5378  O   GLN A 671      11.150  21.913  43.923  1.00 49.44           O  
ATOM   5379  CB  GLN A 671      11.429  24.618  41.930  1.00 55.44           C  
ATOM   5380  CG  GLN A 671      11.108  25.406  40.655  1.00 62.93           C  
ATOM   5381  CD  GLN A 671      11.419  26.896  40.752  1.00 76.68           C  
ATOM   5382  OE1 GLN A 671      12.421  27.305  41.369  1.00 77.86           O  
ATOM   5383  NE2 GLN A 671      10.569  27.715  40.116  1.00 73.68           N  
ATOM   5384  N   PRO A 672      12.854  21.760  42.458  1.00 52.98           N  
ATOM   5385  CA  PRO A 672      13.571  20.899  43.388  1.00 45.58           C  
ATOM   5386  C   PRO A 672      14.675  21.620  44.133  1.00 42.16           C  
ATOM   5387  O   PRO A 672      15.275  22.584  43.643  1.00 41.02           O  
ATOM   5388  CB  PRO A 672      14.120  19.790  42.497  1.00 51.78           C  
ATOM   5389  CG  PRO A 672      13.979  20.303  41.055  1.00 50.82           C  
ATOM   5390  CD  PRO A 672      13.491  21.703  41.115  1.00 51.36           C  
ATOM   5391  N   ILE A 673      14.861  21.179  45.365  1.00 42.40           N  
ATOM   5392  CA  ILE A 673      15.879  21.701  46.257  1.00 38.22           C  
ATOM   5393  C   ILE A 673      16.673  20.508  46.757  1.00 28.32           C  
ATOM   5394  O   ILE A 673      16.142  19.578  47.351  1.00 31.61           O  
ATOM   5395  CB  ILE A 673      15.245  22.552  47.368  1.00 39.37           C  
ATOM   5396  CG1 ILE A 673      14.746  23.863  46.727  1.00 39.16           C  
ATOM   5397  CG2 ILE A 673      16.244  22.765  48.516  1.00 41.47           C  
ATOM   5398  CD1 ILE A 673      14.287  24.944  47.640  1.00 54.42           C  
ATOM   5399  N   LYS A 674      17.948  20.552  46.414  1.00 27.83           N  
ATOM   5400  CA  LYS A 674      18.952  19.544  46.695  1.00 20.34           C  
ATOM   5401  C   LYS A 674      19.279  19.397  48.158  1.00 24.58           C  
ATOM   5402  O   LYS A 674      19.511  18.286  48.630  1.00 20.86           O  
ATOM   5403  CB  LYS A 674      20.209  19.962  45.940  1.00 23.04           C  
ATOM   5404  CG  LYS A 674      21.464  19.135  46.096  1.00 17.89           C  
ATOM   5405  CD  LYS A 674      22.466  19.725  45.145  1.00 21.56           C  
ATOM   5406  CE  LYS A 674      23.866  19.389  45.527  1.00 25.42           C  
ATOM   5407  NZ  LYS A 674      24.867  20.285  44.822  1.00 30.34           N  
ATOM   5408  N   LEU A 675      19.272  20.515  48.873  1.00 20.40           N  
ATOM   5409  CA  LEU A 675      19.661  20.524  50.274  1.00 19.21           C  
ATOM   5410  C   LEU A 675      18.563  20.533  51.356  1.00 14.45           C  
ATOM   5411  O   LEU A 675      17.468  21.070  51.128  1.00 18.01           O  
ATOM   5412  CB  LEU A 675      20.648  21.684  50.499  1.00 23.86           C  
ATOM   5413  CG  LEU A 675      22.055  21.641  49.874  1.00 25.30           C  
ATOM   5414  CD1 LEU A 675      22.879  22.826  50.355  1.00 29.71           C  
ATOM   5415  CD2 LEU A 675      22.774  20.348  50.254  1.00 30.39           C  
ATOM   5416  N   PRO A 676      18.819  19.883  52.533  1.00 12.44           N  
ATOM   5417  CA  PRO A 676      17.854  19.844  53.642  1.00 10.59           C  
ATOM   5418  C   PRO A 676      17.694  21.273  54.097  1.00 10.85           C  
ATOM   5419  O   PRO A 676      18.658  22.039  54.025  1.00 11.14           O  
ATOM   5420  CB  PRO A 676      18.613  19.104  54.730  1.00  8.35           C  
ATOM   5421  CG  PRO A 676      19.527  18.292  54.003  1.00 12.44           C  
ATOM   5422  CD  PRO A 676      19.993  19.057  52.870  1.00  6.31           C  
ATOM   5423  N   ALA A 677      16.517  21.626  54.601  1.00 10.24           N  
ATOM   5424  CA  ALA A 677      16.269  22.991  55.067  1.00 13.94           C  
ATOM   5425  C   ALA A 677      17.284  23.523  56.071  1.00 14.01           C  
ATOM   5426  O   ALA A 677      17.577  24.727  56.081  1.00 16.63           O  
ATOM   5427  CB  ALA A 677      14.866  23.134  55.610  1.00 10.32           C  
ATOM   5428  N   THR A 678      17.893  22.598  56.811  1.00 13.48           N  
ATOM   5429  CA  THR A 678      18.919  22.921  57.818  1.00 21.94           C  
ATOM   5430  C   THR A 678      20.207  23.553  57.247  1.00 19.20           C  
ATOM   5431  O   THR A 678      20.913  24.311  57.947  1.00 16.49           O  
ATOM   5432  CB  THR A 678      19.262  21.685  58.681  1.00 17.75           C  
ATOM   5433  OG1 THR A 678      19.546  20.561  57.837  1.00 21.05           O  
ATOM   5434  CG2 THR A 678      18.107  21.337  59.554  1.00 20.16           C  
ATOM   5435  N   VAL A 679      20.512  23.221  55.983  1.00 18.86           N  
ATOM   5436  CA  VAL A 679      21.690  23.773  55.312  1.00 16.20           C  
ATOM   5437  C   VAL A 679      21.412  24.478  54.004  1.00 14.65           C  
ATOM   5438  O   VAL A 679      22.286  25.154  53.484  1.00 18.27           O  
ATOM   5439  CB  VAL A 679      22.847  22.758  55.124  1.00 12.37           C  
ATOM   5440  CG1 VAL A 679      23.473  22.448  56.464  1.00  6.96           C  
ATOM   5441  CG2 VAL A 679      22.370  21.519  54.406  1.00  7.51           C  
ATOM   5442  N   HIS A 680      20.189  24.383  53.496  1.00 16.00           N  
ATOM   5443  CA  HIS A 680      19.851  25.050  52.248  1.00 17.44           C  
ATOM   5444  C   HIS A 680      19.988  26.533  52.435  1.00 23.10           C  
ATOM   5445  O   HIS A 680      19.457  27.107  53.390  1.00 22.77           O  
ATOM   5446  CB  HIS A 680      18.448  24.731  51.803  1.00  8.02           C  
ATOM   5447  CG  HIS A 680      18.034  25.498  50.587  1.00 19.03           C  
ATOM   5448  ND1 HIS A 680      17.053  26.470  50.635  1.00 18.46           N  
ATOM   5449  CD2 HIS A 680      18.444  25.432  49.308  1.00 12.53           C  
ATOM   5450  CE1 HIS A 680      16.872  26.958  49.423  1.00  9.46           C  
ATOM   5451  NE2 HIS A 680      17.699  26.349  48.598  1.00 16.56           N  
ATOM   5452  N   TYR A 681      20.779  27.106  51.534  1.00 31.24           N  
ATOM   5453  CA  TYR A 681      21.125  28.529  51.494  1.00 31.97           C  
ATOM   5454  C   TYR A 681      22.107  28.997  52.578  1.00 37.68           C  
ATOM   5455  O   TYR A 681      22.522  30.162  52.567  1.00 32.93           O  
ATOM   5456  CB  TYR A 681      19.867  29.408  51.509  1.00 32.32           C  
ATOM   5457  CG  TYR A 681      19.661  30.169  50.239  1.00 33.29           C  
ATOM   5458  CD1 TYR A 681      19.659  29.508  48.983  1.00 35.14           C  
ATOM   5459  CD2 TYR A 681      19.510  31.560  50.269  1.00 33.04           C  
ATOM   5460  CE1 TYR A 681      19.520  30.225  47.786  1.00 40.05           C  
ATOM   5461  CE2 TYR A 681      19.364  32.296  49.086  1.00 45.89           C  
ATOM   5462  CZ  TYR A 681      19.373  31.630  47.837  1.00 51.07           C  
ATOM   5463  OH  TYR A 681      19.260  32.371  46.662  1.00 54.77           O  
ATOM   5464  N   SER A 682      22.494  28.102  53.497  1.00 35.00           N  
ATOM   5465  CA  SER A 682      23.414  28.468  54.576  1.00 37.40           C  
ATOM   5466  C   SER A 682      24.780  28.983  54.129  1.00 39.71           C  
ATOM   5467  O   SER A 682      25.262  29.982  54.688  1.00 39.75           O  
ATOM   5468  CB  SER A 682      23.562  27.356  55.611  1.00 32.32           C  
ATOM   5469  OG  SER A 682      22.405  27.307  56.415  1.00 30.87           O  
ATOM   5470  N   ASP A 683      25.338  28.393  53.062  1.00 39.51           N  
ATOM   5471  CA  ASP A 683      26.642  28.832  52.572  1.00 37.04           C  
ATOM   5472  C   ASP A 683      26.571  30.123  51.761  1.00 36.21           C  
ATOM   5473  O   ASP A 683      27.551  30.865  51.708  1.00 34.38           O  
ATOM   5474  CB  ASP A 683      27.337  27.736  51.771  1.00 37.95           C  
ATOM   5475  CG  ASP A 683      28.855  27.927  51.691  1.00 33.96           C  
ATOM   5476  OD1 ASP A 683      29.316  28.340  50.605  1.00 37.84           O  
ATOM   5477  OD2 ASP A 683      29.570  27.661  52.688  1.00 28.91           O  
ATOM   5478  N   LYS A 684      25.421  30.388  51.140  1.00 34.04           N  
ATOM   5479  CA  LYS A 684      25.255  31.619  50.358  1.00 33.79           C  
ATOM   5480  C   LYS A 684      25.003  32.853  51.214  1.00 27.40           C  
ATOM   5481  O   LYS A 684      25.516  33.917  50.895  1.00 25.65           O  
ATOM   5482  CB  LYS A 684      24.201  31.458  49.253  1.00 40.77           C  
ATOM   5483  CG  LYS A 684      24.688  30.486  48.154  1.00 55.00           C  
ATOM   5484  CD  LYS A 684      23.764  30.324  46.932  1.00 58.19           C  
ATOM   5485  CE  LYS A 684      24.311  29.211  45.997  1.00 60.11           C  
ATOM   5486  NZ  LYS A 684      23.675  29.213  44.639  1.00 63.70           N  
ATOM   5487  N   ILE A 685      24.320  32.670  52.350  1.00 27.19           N  
ATOM   5488  CA  ILE A 685      24.000  33.743  53.315  1.00 24.14           C  
ATOM   5489  C   ILE A 685      25.244  34.217  54.130  1.00 26.13           C  
ATOM   5490  O   ILE A 685      25.442  35.412  54.314  1.00 28.63           O  
ATOM   5491  CB  ILE A 685      22.809  33.307  54.264  1.00 17.51           C  
ATOM   5492  CG1 ILE A 685      21.540  33.079  53.455  1.00 11.11           C  
ATOM   5493  CG2 ILE A 685      22.486  34.368  55.306  1.00 14.15           C  
ATOM   5494  CD1 ILE A 685      20.455  32.406  54.233  1.00 26.45           C  
ATOM   5495  N   THR A 686      26.095  33.284  54.563  1.00 29.28           N  
ATOM   5496  CA  THR A 686      27.300  33.600  55.321  1.00 25.41           C  
ATOM   5497  C   THR A 686      28.323  34.353  54.464  1.00 27.50           C  
ATOM   5498  O   THR A 686      28.860  35.369  54.895  1.00 39.04           O  
ATOM   5499  CB  THR A 686      27.965  32.332  55.868  1.00 19.65           C  
ATOM   5500  OG1 THR A 686      28.341  31.482  54.784  1.00 16.50           O  
ATOM   5501  CG2 THR A 686      27.052  31.598  56.791  1.00 16.30           C  
ATOM   5502  N   LYS A 687      28.540  33.892  53.235  1.00 24.58           N  
ATOM   5503  CA  LYS A 687      29.491  34.524  52.323  1.00 27.95           C  
ATOM   5504  C   LYS A 687      29.048  35.910  51.885  1.00 29.03           C  
ATOM   5505  O   LYS A 687      29.842  36.705  51.412  1.00 25.98           O  
ATOM   5506  CB  LYS A 687      29.709  33.640  51.091  1.00 32.79           C  
ATOM   5507  CG  LYS A 687      30.634  32.466  51.341  1.00 38.04           C  
ATOM   5508  CD  LYS A 687      30.650  31.483  50.185  1.00 46.81           C  
ATOM   5509  CE  LYS A 687      31.708  30.394  50.422  1.00 61.46           C  
ATOM   5510  NZ  LYS A 687      31.774  29.330  49.351  1.00 64.07           N  
ATOM   5511  N   LEU A 688      27.772  36.188  52.094  1.00 27.56           N  
ATOM   5512  CA  LEU A 688      27.155  37.455  51.727  1.00 31.79           C  
ATOM   5513  C   LEU A 688      27.333  38.493  52.844  1.00 35.08           C  
ATOM   5514  O   LEU A 688      27.599  39.682  52.594  1.00 34.40           O  
ATOM   5515  CB  LEU A 688      25.663  37.211  51.465  1.00 27.65           C  
ATOM   5516  CG  LEU A 688      24.764  38.320  50.921  1.00 30.17           C  
ATOM   5517  CD1 LEU A 688      25.024  38.595  49.461  1.00 33.87           C  
ATOM   5518  CD2 LEU A 688      23.357  37.924  51.109  1.00 25.77           C  
HETATM 5519  N   MSE A 689      27.191  38.015  54.077  1.00 35.88           N  
HETATM 5520  CA  MSE A 689      27.313  38.850  55.254  1.00 37.13           C  
HETATM 5521  C   MSE A 689      28.764  39.233  55.501  1.00 39.15           C  
HETATM 5522  O   MSE A 689      29.029  40.295  56.051  1.00 47.35           O  
HETATM 5523  CB  MSE A 689      26.685  38.155  56.464  1.00 39.14           C  
HETATM 5524  CG  MSE A 689      25.182  37.851  56.348  1.00 34.86           C  
HETATM 5525 SE   MSE A 689      24.056  39.269  55.623  1.00 48.42          SE  
HETATM 5526  CE  MSE A 689      22.607  38.200  54.896  1.00 48.37           C  
ATOM   5527  N   LEU A 690      29.685  38.370  55.056  1.00 46.95           N  
ATOM   5528  CA  LEU A 690      31.152  38.578  55.128  1.00 53.97           C  
ATOM   5529  C   LEU A 690      31.589  39.803  54.282  1.00 49.95           C  
ATOM   5530  O   LEU A 690      32.467  40.577  54.686  1.00 51.91           O  
ATOM   5531  CB  LEU A 690      31.904  37.335  54.594  1.00 45.69           C  
ATOM   5532  CG  LEU A 690      32.243  36.103  55.437  1.00 48.70           C  
ATOM   5533  CD1 LEU A 690      32.966  35.079  54.564  1.00 42.99           C  
ATOM   5534  CD2 LEU A 690      33.092  36.494  56.637  1.00 36.55           C  
ATOM   5535  N   ARG A 691      30.946  39.958  53.119  1.00 54.47           N  
ATOM   5536  CA  ARG A 691      31.156  41.060  52.172  1.00 58.61           C  
ATOM   5537  C   ARG A 691      30.574  42.382  52.730  1.00 53.59           C  
ATOM   5538  O   ARG A 691      30.556  43.395  52.045  1.00 57.92           O  
ATOM   5539  CB  ARG A 691      30.468  40.740  50.822  1.00 66.91           C  
ATOM   5540  CG  ARG A 691      30.979  39.495  50.109  1.00 73.58           C  
ATOM   5541  CD  ARG A 691      30.324  39.232  48.745  1.00 86.65           C  
ATOM   5542  NE  ARG A 691      30.968  38.074  48.097  1.00 94.62           N  
ATOM   5543  CZ  ARG A 691      31.053  37.861  46.779  1.00101.31           C  
ATOM   5544  NH1 ARG A 691      30.525  38.723  45.906  1.00 94.47           N  
ATOM   5545  NH2 ARG A 691      31.730  36.802  46.327  1.00 95.93           N  
ATOM   5546  N   GLY A 692      30.073  42.345  53.963  1.00 53.70           N  
ATOM   5547  CA  GLY A 692      29.505  43.512  54.613  1.00 47.68           C  
ATOM   5548  C   GLY A 692      30.551  44.457  55.163  1.00 46.86           C  
ATOM   5549  O   GLY A 692      31.748  44.244  55.012  1.00 48.30           O  
ATOM   5550  N   ILE A 693      30.080  45.529  55.778  1.00 51.95           N  
ATOM   5551  CA  ILE A 693      30.928  46.560  56.360  1.00 55.37           C  
ATOM   5552  C   ILE A 693      30.597  46.586  57.831  1.00 57.06           C  
ATOM   5553  O   ILE A 693      31.416  46.952  58.657  1.00 61.51           O  
ATOM   5554  CB  ILE A 693      30.623  47.910  55.676  1.00 59.02           C  
ATOM   5555  CG1 ILE A 693      31.578  48.105  54.517  1.00 58.45           C  
ATOM   5556  CG2 ILE A 693      30.648  49.114  56.626  1.00 63.16           C  
ATOM   5557  CD1 ILE A 693      31.022  49.046  53.491  1.00 66.08           C  
ATOM   5558  N   GLU A 694      29.365  46.217  58.144  1.00 58.65           N  
ATOM   5559  CA  GLU A 694      28.907  46.198  59.518  1.00 57.47           C  
ATOM   5560  C   GLU A 694      28.713  44.777  59.985  1.00 53.60           C  
ATOM   5561  O   GLU A 694      28.469  43.878  59.181  1.00 55.97           O  
ATOM   5562  CB  GLU A 694      27.607  46.964  59.635  1.00 56.33           C  
ATOM   5563  CG  GLU A 694      27.703  48.326  59.044  1.00 58.35           C  
ATOM   5564  CD  GLU A 694      26.814  49.292  59.716  1.00 63.50           C  
ATOM   5565  OE1 GLU A 694      26.808  49.335  60.963  1.00 70.39           O  
ATOM   5566  OE2 GLU A 694      26.143  50.042  58.993  1.00 60.91           O  
ATOM   5567  N   PRO A 695      28.911  44.541  61.293  1.00 50.73           N  
ATOM   5568  CA  PRO A 695      28.727  43.194  61.824  1.00 52.71           C  
ATOM   5569  C   PRO A 695      27.276  42.980  62.187  1.00 52.32           C  
ATOM   5570  O   PRO A 695      26.551  43.935  62.459  1.00 56.12           O  
ATOM   5571  CB  PRO A 695      29.575  43.218  63.094  1.00 55.48           C  
ATOM   5572  CG  PRO A 695      30.525  44.301  62.868  1.00 54.59           C  
ATOM   5573  CD  PRO A 695      29.668  45.343  62.249  1.00 54.36           C  
ATOM   5574  N   ILE A 696      26.854  41.720  62.157  1.00 52.93           N  
ATOM   5575  CA  ILE A 696      25.490  41.356  62.515  1.00 48.39           C  
ATOM   5576  C   ILE A 696      25.507  40.514  63.762  1.00 45.53           C  
ATOM   5577  O   ILE A 696      26.530  39.951  64.164  1.00 41.91           O  
ATOM   5578  CB  ILE A 696      24.714  40.521  61.426  1.00 47.59           C  
ATOM   5579  CG1 ILE A 696      25.501  40.368  60.120  1.00 47.11           C  
ATOM   5580  CG2 ILE A 696      23.358  41.136  61.185  1.00 47.97           C  
ATOM   5581  CD1 ILE A 696      26.295  39.123  60.043  1.00 40.19           C  
ATOM   5582  N   LYS A 697      24.330  40.468  64.361  1.00 45.30           N  
ATOM   5583  CA  LYS A 697      24.000  39.702  65.543  1.00 37.16           C  
ATOM   5584  C   LYS A 697      22.481  39.777  65.407  1.00 32.84           C  
ATOM   5585  O   LYS A 697      21.887  40.807  65.739  1.00 30.32           O  
ATOM   5586  CB  LYS A 697      24.484  40.375  66.839  1.00 42.55           C  
ATOM   5587  CG  LYS A 697      24.265  39.510  68.090  1.00 44.74           C  
ATOM   5588  CD  LYS A 697      23.960  40.369  69.326  1.00 56.85           C  
ATOM   5589  CE  LYS A 697      23.343  39.571  70.480  1.00 58.50           C  
ATOM   5590  NZ  LYS A 697      21.915  39.172  70.266  1.00 60.20           N  
ATOM   5591  N   LYS A 698      21.906  38.774  64.735  1.00 28.92           N  
ATOM   5592  CA  LYS A 698      20.464  38.687  64.536  1.00 31.11           C  
ATOM   5593  C   LYS A 698      19.938  37.293  64.773  1.00 30.51           C  
ATOM   5594  O   LYS A 698      20.568  36.290  64.455  1.00 30.63           O  
ATOM   5595  CB  LYS A 698      20.020  39.144  63.142  1.00 36.33           C  
ATOM   5596  CG  LYS A 698      18.592  39.721  63.135  1.00 42.94           C  
ATOM   5597  CD  LYS A 698      17.933  39.667  61.758  1.00 53.51           C  
ATOM   5598  CE  LYS A 698      16.759  40.666  61.632  1.00 60.12           C  
ATOM   5599  NZ  LYS A 698      16.248  40.854  60.220  1.00 59.15           N  
ATOM   5600  N   GLU A 699      18.711  37.278  65.253  1.00 26.38           N  
ATOM   5601  CA  GLU A 699      17.977  36.085  65.568  1.00 27.21           C  
ATOM   5602  C   GLU A 699      16.582  36.286  64.961  1.00 23.67           C  
ATOM   5603  O   GLU A 699      16.066  37.402  64.916  1.00 23.35           O  
ATOM   5604  CB  GLU A 699      17.895  35.978  67.098  1.00 28.94           C  
ATOM   5605  CG  GLU A 699      17.394  34.652  67.626  1.00 31.29           C  
ATOM   5606  CD  GLU A 699      16.957  34.725  69.065  1.00 34.26           C  
ATOM   5607  OE1 GLU A 699      17.763  35.119  69.930  1.00 21.81           O  
ATOM   5608  OE2 GLU A 699      15.796  34.362  69.326  1.00 41.62           O  
ATOM   5609  N   GLY A 700      15.985  35.215  64.470  1.00 25.90           N  
ATOM   5610  CA  GLY A 700      14.660  35.326  63.891  1.00 25.19           C  
ATOM   5611  C   GLY A 700      13.994  33.984  63.892  1.00 20.99           C  
ATOM   5612  O   GLY A 700      14.535  33.029  64.412  1.00 21.63           O  
ATOM   5613  N   ASP A 701      12.859  33.911  63.218  1.00 21.18           N  
ATOM   5614  CA  ASP A 701      12.042  32.712  63.147  1.00 22.10           C  
ATOM   5615  C   ASP A 701      11.329  32.658  61.799  1.00 23.41           C  
ATOM   5616  O   ASP A 701      10.368  31.913  61.611  1.00 28.89           O  
ATOM   5617  CB  ASP A 701      11.014  32.767  64.285  1.00 26.83           C  
ATOM   5618  CG  ASP A 701      10.218  34.076  64.317  1.00 33.59           C  
ATOM   5619  OD1 ASP A 701      10.621  35.058  63.658  1.00 29.66           O  
ATOM   5620  OD2 ASP A 701       9.185  34.125  65.011  1.00 36.40           O  
ATOM   5621  N   ILE A 702      11.850  33.441  60.858  1.00 26.85           N  
ATOM   5622  CA  ILE A 702      11.325  33.595  59.497  1.00 22.22           C  
ATOM   5623  C   ILE A 702      12.301  32.977  58.509  1.00 21.08           C  
ATOM   5624  O   ILE A 702      13.519  33.117  58.667  1.00 21.14           O  
ATOM   5625  CB  ILE A 702      11.174  35.134  59.170  1.00 21.20           C  
ATOM   5626  CG1 ILE A 702      10.149  35.790  60.083  1.00 21.64           C  
ATOM   5627  CG2 ILE A 702      10.717  35.381  57.779  1.00  9.08           C  
ATOM   5628  CD1 ILE A 702      10.593  37.170  60.532  1.00 34.22           C  
HETATM 5629  N   MSE A 703      11.777  32.280  57.505  1.00 20.47           N  
HETATM 5630  CA  MSE A 703      12.658  31.723  56.487  1.00 20.74           C  
HETATM 5631  C   MSE A 703      12.711  32.757  55.342  1.00 20.48           C  
HETATM 5632  O   MSE A 703      12.188  32.515  54.239  1.00 28.14           O  
HETATM 5633  CB  MSE A 703      12.164  30.348  56.031  1.00 21.67           C  
HETATM 5634  CG  MSE A 703      12.192  29.275  57.118  1.00 35.25           C  
HETATM 5635 SE   MSE A 703      11.783  27.412  56.568  1.00 58.10          SE  
HETATM 5636  CE  MSE A 703      13.393  26.991  55.539  1.00 33.81           C  
ATOM   5637  N   TYR A 704      13.404  33.877  55.590  1.00 20.77           N  
ATOM   5638  CA  TYR A 704      13.469  34.990  54.622  1.00 20.42           C  
ATOM   5639  C   TYR A 704      14.236  34.799  53.294  1.00 28.29           C  
ATOM   5640  O   TYR A 704      14.100  35.618  52.351  1.00 31.02           O  
ATOM   5641  CB  TYR A 704      13.924  36.294  55.318  1.00 12.36           C  
ATOM   5642  CG  TYR A 704      15.372  36.312  55.718  1.00 16.81           C  
ATOM   5643  CD1 TYR A 704      16.362  36.752  54.817  1.00 12.01           C  
ATOM   5644  CD2 TYR A 704      15.777  35.832  56.979  1.00 14.68           C  
ATOM   5645  CE1 TYR A 704      17.708  36.714  55.143  1.00 15.47           C  
ATOM   5646  CE2 TYR A 704      17.148  35.791  57.326  1.00 18.46           C  
ATOM   5647  CZ  TYR A 704      18.100  36.234  56.391  1.00 18.42           C  
ATOM   5648  OH  TYR A 704      19.433  36.222  56.702  1.00 27.06           O  
ATOM   5649  N   TRP A 705      15.039  33.739  53.236  1.00 18.74           N  
ATOM   5650  CA  TRP A 705      15.866  33.448  52.070  1.00 17.57           C  
ATOM   5651  C   TRP A 705      15.169  32.755  50.888  1.00 16.05           C  
ATOM   5652  O   TRP A 705      15.566  32.909  49.726  1.00  9.21           O  
ATOM   5653  CB  TRP A 705      17.079  32.648  52.537  1.00 16.69           C  
ATOM   5654  CG  TRP A 705      16.766  31.495  53.487  1.00 12.07           C  
ATOM   5655  CD1 TRP A 705      16.478  30.205  53.134  1.00 18.44           C  
ATOM   5656  CD2 TRP A 705      16.665  31.543  54.916  1.00 17.18           C  
ATOM   5657  NE1 TRP A 705      16.201  29.453  54.244  1.00 17.56           N  
ATOM   5658  CE2 TRP A 705      16.306  30.242  55.359  1.00 15.47           C  
ATOM   5659  CE3 TRP A 705      16.837  32.562  55.877  1.00 21.70           C  
ATOM   5660  CZ2 TRP A 705      16.110  29.913  56.723  1.00 11.81           C  
ATOM   5661  CZ3 TRP A 705      16.638  32.239  57.272  1.00 22.49           C  
ATOM   5662  CH2 TRP A 705      16.268  30.916  57.666  1.00 15.74           C  
ATOM   5663  N   LEU A 706      14.070  32.079  51.194  1.00 16.74           N  
ATOM   5664  CA  LEU A 706      13.317  31.314  50.208  1.00 23.87           C  
ATOM   5665  C   LEU A 706      12.792  32.044  48.979  1.00 26.37           C  
ATOM   5666  O   LEU A 706      12.481  31.412  47.957  1.00 24.51           O  
ATOM   5667  CB  LEU A 706      12.190  30.533  50.894  1.00 13.31           C  
ATOM   5668  CG  LEU A 706      12.691  29.504  51.908  1.00 10.06           C  
ATOM   5669  CD1 LEU A 706      11.513  28.817  52.545  1.00 11.43           C  
ATOM   5670  CD2 LEU A 706      13.624  28.480  51.246  1.00  8.79           C  
TER    5671      LEU A 706                                                      
END
MOLECULE T0487.pdb
ATOM      1  N   HIS     3       6.444   3.101  48.834  1.00100.07           N  
ATOM      2  CA  HIS     3       7.887   3.258  48.495  1.00100.10           C  
ATOM      3  C   HIS     3       8.767   2.608  49.561  1.00100.38           C  
ATOM      4  O   HIS     3       9.001   3.170  50.631  1.00 99.89           O  
ATOM      5  CB  HIS     3       8.221   4.732  48.363  1.00100.17           C  
ATOM      6  N   LEU     4       9.248   1.411  49.254  1.00101.22           N  
ATOM      7  CA  LEU     4      10.099   0.642  50.163  1.00101.53           C  
ATOM      8  C   LEU     4      10.968  -0.280  49.298  1.00100.87           C  
ATOM      9  O   LEU     4      11.951  -0.859  49.776  1.00100.42           O  
ATOM     10  CB  LEU     4       9.234  -0.217  51.097  1.00102.35           C  
ATOM     11  CG  LEU     4       8.663  -1.477  50.415  1.00103.57           C  
ATOM     12  CD1 LEU     4       9.551  -2.686  50.735  1.00102.75           C  
ATOM     13  CD2 LEU     4       7.231  -1.727  50.870  1.00103.45           C  
ATOM     14  N   GLY     5      10.578  -0.410  48.028  1.00 99.44           N  
ATOM     15  CA  GLY     5      11.292  -1.261  47.092  1.00 98.33           C  
ATOM     16  C   GLY     5      12.740  -0.882  46.835  1.00 97.37           C  
ATOM     17  O   GLY     5      13.083   0.297  46.751  1.00 97.09           O  
ATOM     18  N   LYS     6      13.596  -1.892  46.707  1.00 96.15           N  
ATOM     19  CA  LYS     6      15.014  -1.665  46.456  1.00 95.16           C  
ATOM     20  C   LYS     6      15.289  -1.631  44.955  1.00 94.70           C  
ATOM     21  O   LYS     6      14.628  -2.312  44.167  1.00 94.81           O  
ATOM     22  CB  LYS     6      15.846  -2.747  47.123  1.00 94.76           C  
ATOM     23  N   THR     7      16.266  -0.824  44.562  1.00 93.91           N  
ATOM     24  CA  THR     7      16.623  -0.684  43.156  1.00 92.09           C  
ATOM     25  C   THR     7      18.126  -0.728  42.973  1.00 90.89           C  
ATOM     26  O   THR     7      18.849   0.108  43.509  1.00 92.51           O  
ATOM     27  CB  THR     7      16.097   0.644  42.578  1.00 92.12           C  
ATOM     28  OG1 THR     7      14.673   0.570  42.444  1.00 91.76           O  
ATOM     29  CG2 THR     7      16.723   0.929  41.223  1.00 91.89           C  
ATOM     30  N   GLU     8      18.587  -1.720  42.220  1.00 89.04           N  
ATOM     31  CA  GLU     8      20.005  -1.880  41.943  1.00 86.13           C  
ATOM     32  C   GLU     8      20.441  -0.604  41.234  1.00 83.12           C  
ATOM     33  O   GLU     8      19.669  -0.009  40.489  1.00 82.79           O  
ATOM     34  CB  GLU     8      20.238  -3.103  41.037  1.00 87.94           C  
ATOM     35  CG  GLU     8      19.639  -2.997  39.623  1.00 89.17           C  
ATOM     36  CD  GLU     8      18.185  -3.458  39.524  1.00 90.74           C  
ATOM     37  OE1 GLU     8      17.400  -3.210  40.469  1.00 91.91           O  
ATOM     38  OE2 GLU     8      17.822  -4.055  38.482  1.00 89.73           O  
ATOM     39  N   VAL     9      21.669  -0.171  41.467  1.00 80.15           N  
ATOM     40  CA  VAL     9      22.138   1.040  40.821  1.00 77.34           C  
ATOM     41  C   VAL     9      23.649   1.005  40.649  1.00 76.06           C  
ATOM     42  O   VAL     9      24.368   0.448  41.477  1.00 75.33           O  
ATOM     43  CB  VAL     9      21.714   2.285  41.645  1.00 77.24           C  
ATOM     44  CG1 VAL     9      22.823   2.702  42.630  1.00 74.28           C  
ATOM     45  CG2 VAL     9      21.328   3.405  40.707  1.00 75.83           C  
ATOM     46  N   PHE    10      24.131   1.579  39.556  1.00 75.53           N  
ATOM     47  CA  PHE    10      25.570   1.617  39.310  1.00 74.88           C  
ATOM     48  C   PHE    10      26.150   2.979  39.661  1.00 72.88           C  
ATOM     49  O   PHE    10      25.668   4.020  39.198  1.00 71.03           O  
ATOM     50  CB  PHE    10      25.901   1.317  37.840  1.00 77.26           C  
ATOM     51  CG  PHE    10      26.232  -0.125  37.563  1.00 79.72           C  
ATOM     52  CD1 PHE    10      27.288  -0.753  38.220  1.00 80.92           C  
ATOM     53  CD2 PHE    10      25.480  -0.860  36.648  1.00 80.62           C  
ATOM     54  CE1 PHE    10      27.588  -2.098  37.969  1.00 80.62           C  
ATOM     55  CE2 PHE    10      25.772  -2.197  36.393  1.00 80.67           C  
ATOM     56  CZ  PHE    10      26.827  -2.816  37.056  1.00 80.56           C  
ATOM     57  N   LEU    11      27.178   2.957  40.500  1.00 70.62           N  
ATOM     58  CA  LEU    11      27.883   4.167  40.885  1.00 69.43           C  
ATOM     59  C   LEU    11      29.014   4.315  39.873  1.00 68.78           C  
ATOM     60  O   LEU    11      29.307   3.379  39.126  1.00 70.60           O  
ATOM     61  CB  LEU    11      28.482   4.019  42.281  1.00 67.43           C  
ATOM     62  CG  LEU    11      27.514   3.779  43.442  1.00 66.66           C  
ATOM     63  CD1 LEU    11      28.327   3.702  44.721  1.00 65.31           C  
ATOM     64  CD2 LEU    11      26.482   4.889  43.537  1.00 64.31           C  
ATOM     65  N   ASN    12      29.646   5.479  39.824  1.00 67.02           N  
ATOM     66  CA  ASN    12      30.751   5.642  38.903  1.00 62.74           C  
ATOM     67  C   ASN    12      32.026   5.374  39.683  1.00 60.87           C  
ATOM     68  O   ASN    12      33.004   6.107  39.597  1.00 60.45           O  
ATOM     69  CB  ASN    12      30.726   7.031  38.246  1.00 63.10           C  
ATOM     70  CG  ASN    12      30.974   8.155  39.213  1.00 62.68           C  
ATOM     71  OD1 ASN    12      30.782   8.014  40.421  1.00 62.56           O  
ATOM     72  ND2 ASN    12      31.393   9.301  38.678  1.00 62.62           N  
ATOM     73  N   ARG    13      31.973   4.298  40.466  1.00 59.39           N  
ATOM     74  CA  ARG    13      33.105   3.822  41.263  1.00 59.66           C  
ATOM     75  C   ARG    13      33.481   2.448  40.739  1.00 58.30           C  
ATOM     76  O   ARG    13      32.677   1.781  40.081  1.00 57.95           O  
ATOM     77  CB  ARG    13      32.738   3.647  42.732  1.00 61.21           C  
ATOM     78  CG  ARG    13      32.238   4.874  43.367  1.00 64.16           C  
ATOM     79  CD  ARG    13      31.922   4.635  44.811  1.00 64.95           C  
ATOM     80  NE  ARG    13      31.799   5.931  45.453  1.00 67.21           N  
ATOM     81  CZ  ARG    13      31.859   6.124  46.754  1.00 67.14           C  
ATOM     82  NH1 ARG    13      32.031   5.086  47.557  1.00 67.21           N  
ATOM     83  NH2 ARG    13      31.788   7.358  47.235  1.00 67.78           N  
ATOM     84  N   PHE    14      34.693   2.018  41.061  1.00 56.41           N  
ATOM     85  CA  PHE    14      35.175   0.726  40.616  1.00 56.49           C  
ATOM     86  C   PHE    14      36.086   0.154  41.681  1.00 57.15           C  
ATOM     87  O   PHE    14      36.900   0.879  42.249  1.00 58.82           O  
ATOM     88  CB  PHE    14      35.932   0.875  39.278  1.00 53.89           C  
ATOM     89  CG  PHE    14      35.121   1.536  38.191  1.00 49.26           C  
ATOM     90  CD1 PHE    14      34.945   2.918  38.170  1.00 47.28           C  
ATOM     91  CD2 PHE    14      34.490   0.773  37.217  1.00 47.81           C  
ATOM     92  CE1 PHE    14      34.149   3.519  37.193  1.00 45.49           C  
ATOM     93  CE2 PHE    14      33.687   1.367  36.231  1.00 43.95           C  
ATOM     94  CZ  PHE    14      33.520   2.730  36.220  1.00 45.62           C  
ATOM     95  N   ALA    15      35.957  -1.144  41.949  1.00 58.08           N  
ATOM     96  CA  ALA    15      36.778  -1.786  42.977  1.00 58.87           C  
ATOM     97  C   ALA    15      38.078  -2.370  42.429  1.00 59.13           C  
ATOM     98  O   ALA    15      38.104  -2.971  41.355  1.00 58.72           O  
ATOM     99  CB  ALA    15      35.973  -2.871  43.685  1.00 57.67           C  
ATOM    100  N   LEU    16      39.158  -2.183  43.178  1.00 59.18           N  
ATOM    101  CA  LEU    16      40.451  -2.692  42.771  1.00 60.54           C  
ATOM    102  C   LEU    16      41.004  -3.676  43.799  1.00 62.32           C  
ATOM    103  O   LEU    16      40.410  -3.886  44.849  1.00 61.77           O  
ATOM    104  CB  LEU    16      41.408  -1.530  42.524  1.00 60.96           C  
ATOM    105  CG  LEU    16      40.958  -0.626  41.353  1.00 62.16           C  
ATOM    106  CD1 LEU    16      41.844   0.609  41.279  1.00 60.09           C  
ATOM    107  CD2 LEU    16      41.002  -1.395  40.025  1.00 60.38           C  
ATOM    108  N   ARG    17      42.132  -4.299  43.491  1.00 64.81           N  
ATOM    109  CA  ARG    17      42.691  -5.285  44.397  1.00 67.20           C  
ATOM    110  C   ARG    17      42.740  -4.768  45.820  1.00 70.61           C  
ATOM    111  O   ARG    17      42.742  -3.564  46.052  1.00 71.60           O  
ATOM    112  CB  ARG    17      44.097  -5.685  43.957  1.00 65.33           C  
ATOM    113  CG  ARG    17      45.128  -4.601  44.135  1.00 65.08           C  
ATOM    114  CD  ARG    17      46.521  -5.172  44.309  1.00 63.68           C  
ATOM    115  NE  ARG    17      47.310  -4.329  45.200  1.00 65.95           N  
ATOM    116  CZ  ARG    17      48.390  -3.652  44.826  1.00 68.32           C  
ATOM    117  NH1 ARG    17      48.821  -3.724  43.574  1.00 70.06           N  
ATOM    118  NH2 ARG    17      49.024  -2.876  45.692  1.00 68.14           N  
ATOM    119  N   PRO    18      42.737  -5.676  46.804  1.00 73.90           N  
ATOM    120  CA  PRO    18      42.797  -5.206  48.191  1.00 75.11           C  
ATOM    121  C   PRO    18      44.229  -4.734  48.409  1.00 76.77           C  
ATOM    122  O   PRO    18      45.119  -5.076  47.631  1.00 76.09           O  
ATOM    123  CB  PRO    18      42.485  -6.464  48.998  1.00 74.96           C  
ATOM    124  CG  PRO    18      41.629  -7.278  48.054  1.00 74.85           C  
ATOM    125  CD  PRO    18      42.363  -7.100  46.749  1.00 74.46           C  
ATOM    126  N   LEU    19      44.460  -3.939  49.445  1.00 79.33           N  
ATOM    127  CA  LEU    19      45.815  -3.482  49.711  1.00 81.93           C  
ATOM    128  C   LEU    19      46.609  -4.638  50.331  1.00 84.42           C  
ATOM    129  O   LEU    19      46.132  -5.323  51.247  1.00 84.14           O  
ATOM    130  CB  LEU    19      45.805  -2.274  50.657  1.00 81.55           C  
ATOM    131  CG  LEU    19      45.371  -0.907  50.111  1.00 82.04           C  
ATOM    132  CD1 LEU    19      43.983  -1.003  49.491  1.00 82.27           C  
ATOM    133  CD2 LEU    19      45.377   0.124  51.236  1.00 81.12           C  
ATOM    134  N   ASN    20      47.811  -4.867  49.810  1.00 86.67           N  
ATOM    135  CA  ASN    20      48.664  -5.925  50.321  1.00 89.22           C  
ATOM    136  C   ASN    20      49.231  -5.463  51.655  1.00 91.10           C  
ATOM    137  O   ASN    20      49.189  -4.273  51.968  1.00 91.62           O  
ATOM    138  CB  ASN    20      49.797  -6.223  49.332  1.00 90.95           C  
ATOM    139  CG  ASN    20      50.740  -5.042  49.129  1.00 92.05           C  
ATOM    140  OD1 ASN    20      51.271  -4.479  50.088  1.00 93.47           O  
ATOM    141  ND2 ASN    20      50.972  -4.680  47.872  1.00 91.60           N  
ATOM    142  N   PRO    21      49.758  -6.394  52.469  1.00 92.64           N  
ATOM    143  CA  PRO    21      50.329  -6.043  53.777  1.00 93.03           C  
ATOM    144  C   PRO    21      51.253  -4.819  53.795  1.00 93.26           C  
ATOM    145  O   PRO    21      51.094  -3.941  54.648  1.00 94.03           O  
ATOM    146  CB  PRO    21      51.036  -7.333  54.212  1.00 93.16           C  
ATOM    147  CG  PRO    21      51.168  -8.143  52.932  1.00 93.95           C  
ATOM    148  CD  PRO    21      49.887  -7.837  52.217  1.00 92.99           C  
ATOM    149  N   GLU    22      52.196  -4.748  52.855  1.00 92.42           N  
ATOM    150  CA  GLU    22      53.135  -3.621  52.783  1.00 92.25           C  
ATOM    151  C   GLU    22      52.464  -2.242  52.784  1.00 90.18           C  
ATOM    152  O   GLU    22      52.927  -1.316  53.438  1.00 88.53           O  
ATOM    153  CB  GLU    22      54.008  -3.731  51.525  1.00 94.48           C  
ATOM    154  CG  GLU    22      54.916  -4.942  51.487  1.00 98.22           C  
ATOM    155  CD  GLU    22      54.143  -6.239  51.645  1.00101.59           C  
ATOM    156  OE1 GLU    22      53.215  -6.484  50.842  1.00101.73           O  
ATOM    157  OE2 GLU    22      54.462  -7.014  52.577  1.00103.69           O  
ATOM    158  N   GLU    23      51.374  -2.113  52.040  1.00 89.02           N  
ATOM    159  CA  GLU    23      50.660  -0.849  51.932  1.00 87.43           C  
ATOM    160  C   GLU    23      49.761  -0.589  53.128  1.00 86.72           C  
ATOM    161  O   GLU    23      49.181   0.489  53.258  1.00 86.51           O  
ATOM    162  CB  GLU    23      49.844  -0.845  50.641  1.00 87.07           C  
ATOM    163  CG  GLU    23      50.691  -1.231  49.439  1.00 86.82           C  
ATOM    164  CD  GLU    23      49.876  -1.575  48.209  1.00 86.51           C  
ATOM    165  OE1 GLU    23      48.796  -2.186  48.354  1.00 86.21           O  
ATOM    166  OE2 GLU    23      50.334  -1.251  47.092  1.00 86.66           O  
ATOM    167  N   LEU    24      49.636  -1.585  53.998  1.00 85.54           N  
ATOM    168  CA  LEU    24      48.811  -1.436  55.182  1.00 84.08           C  
ATOM    169  C   LEU    24      49.744  -1.004  56.299  1.00 84.53           C  
ATOM    170  O   LEU    24      49.316  -0.552  57.365  1.00 84.00           O  
ATOM    171  CB  LEU    24      48.119  -2.760  55.510  1.00 82.17           C  
ATOM    172  CG  LEU    24      46.849  -3.050  54.707  1.00 80.47           C  
ATOM    173  CD1 LEU    24      46.452  -4.502  54.869  1.00 80.15           C  
ATOM    174  CD2 LEU    24      45.729  -2.132  55.171  1.00 79.01           C  
ATOM    175  N   ARG    25      51.035  -1.131  56.020  1.00 85.12           N  
ATOM    176  CA  ARG    25      52.076  -0.756  56.959  1.00 86.52           C  
ATOM    177  C   ARG    25      53.008   0.280  56.323  1.00 85.98           C  
ATOM    178  O   ARG    25      54.157  -0.004  56.002  1.00 85.01           O  
ATOM    179  CB  ARG    25      52.871  -1.998  57.377  1.00 89.00           C  
ATOM    180  CG  ARG    25      52.353  -2.724  58.619  1.00 90.63           C  
ATOM    181  CD  ARG    25      50.940  -3.226  58.432  1.00 91.79           C  
ATOM    182  NE  ARG    25      50.573  -4.153  59.492  1.00 93.59           N  
ATOM    183  CZ  ARG    25      49.434  -4.833  59.530  1.00 94.01           C  
ATOM    184  NH1 ARG    25      48.539  -4.690  58.562  1.00 92.90           N  
ATOM    185  NH2 ARG    25      49.196  -5.665  60.537  1.00 95.41           N  
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
ATOM    744  N   PRO    97      51.524   0.356  61.154  1.00 90.60           N  
ATOM    745  CA  PRO    97      50.191  -0.065  60.693  1.00 89.48           C  
ATOM    746  C   PRO    97      48.978   0.872  60.896  1.00 88.63           C  
ATOM    747  O   PRO    97      48.822   1.536  61.935  1.00 88.58           O  
ATOM    748  CB  PRO    97      49.981  -1.359  61.459  1.00 90.16           C  
ATOM    749  CG  PRO    97      50.550  -0.981  62.800  1.00 90.97           C  
ATOM    750  CD  PRO    97      51.837  -0.271  62.462  1.00 90.82           C  
ATOM    751  N   LEU    98      48.086   0.876  59.908  1.00 87.92           N  
ATOM    752  CA  LEU    98      46.852   1.679  59.909  1.00 87.54           C  
ATOM    753  C   LEU    98      45.641   0.780  59.628  1.00 86.35           C  
ATOM    754  O   LEU    98      45.745  -0.173  58.859  1.00 86.40           O  
ATOM    755  CB  LEU    98      46.911   2.768  58.822  1.00 89.09           C  
ATOM    756  CG  LEU    98      47.644   4.109  58.968  1.00 88.65           C  
ATOM    757  CD1 LEU    98      49.045   3.940  59.521  1.00 89.22           C  
ATOM    758  CD2 LEU    98      47.712   4.745  57.589  1.00 89.87           C  
ATOM    759  N   ASP    99      44.496   1.091  60.237  1.00 85.53           N  
ATOM    760  CA  ASP    99      43.278   0.289  60.041  1.00 84.74           C  
ATOM    761  C   ASP    99      42.159   0.999  59.284  1.00 81.33           C  
ATOM    762  O   ASP    99      41.670   2.054  59.692  1.00 80.11           O  
ATOM    763  CB  ASP    99      42.725  -0.242  61.384  1.00 88.35           C  
ATOM    764  CG  ASP    99      42.224   0.868  62.316  1.00 92.89           C  
ATOM    765  OD1 ASP    99      41.730   0.534  63.424  1.00 95.55           O  
ATOM    766  OD2 ASP    99      42.325   2.066  61.956  1.00 93.80           O  
ATOM    767  N   PRO   100      41.737   0.410  58.163  1.00 78.86           N  
ATOM    768  CA  PRO   100      40.674   0.945  57.306  1.00 78.44           C  
ATOM    769  C   PRO   100      39.360   1.178  58.059  1.00 77.45           C  
ATOM    770  O   PRO   100      38.489   1.927  57.613  1.00 75.53           O  
ATOM    771  CB  PRO   100      40.540  -0.128  56.220  1.00 78.10           C  
ATOM    772  CG  PRO   100      41.927  -0.685  56.129  1.00 77.63           C  
ATOM    773  CD  PRO   100      42.346  -0.792  57.566  1.00 77.31           C  
ATOM    774  N   LYS   101      39.234   0.528  59.207  1.00 78.45           N  
ATOM    775  CA  LYS   101      38.036   0.627  60.029  1.00 79.90           C  
ATOM    776  C   LYS   101      37.967   1.948  60.801  1.00 79.56           C  
ATOM    777  O   LYS   101      36.885   2.405  61.159  1.00 77.93           O  
ATOM    778  CB  LYS   101      37.991  -0.549  61.005  1.00 81.68           C  
ATOM    779  CG  LYS   101      38.480  -1.865  60.414  1.00 83.52           C  
ATOM    780  CD  LYS   101      40.002  -1.878  60.264  1.00 83.96           C  
ATOM    781  CE  LYS   101      40.473  -3.135  59.539  1.00 84.31           C  
ATOM    782  NZ  LYS   101      41.955  -3.210  59.437  1.00 84.04           N  
ATOM    783  N   ASP   102      39.129   2.551  61.041  1.00 80.64           N  
ATOM    784  CA  ASP   102      39.234   3.817  61.761  1.00 82.70           C  
ATOM    785  C   ASP   102      39.176   5.025  60.814  1.00 82.44           C  
ATOM    786  O   ASP   102      40.081   5.235  59.997  1.00 79.79           O  
ATOM    787  CB  ASP   102      40.541   3.850  62.555  1.00 85.74           C  
ATOM    788  CG  ASP   102      40.646   5.056  63.475  1.00 89.25           C  
ATOM    789  OD1 ASP   102      40.780   6.196  62.968  1.00 89.10           O  
ATOM    790  OD2 ASP   102      40.594   4.852  64.716  1.00 92.75           O  
ATOM    791  N   PRO   103      38.118   5.851  60.944  1.00 82.42           N  
ATOM    792  CA  PRO   103      37.898   7.046  60.124  1.00 82.10           C  
ATOM    793  C   PRO   103      39.133   7.908  59.860  1.00 80.70           C  
ATOM    794  O   PRO   103      39.308   8.421  58.753  1.00 80.86           O  
ATOM    795  CB  PRO   103      36.808   7.792  60.897  1.00 81.86           C  
ATOM    796  CG  PRO   103      35.983   6.671  61.431  1.00 81.48           C  
ATOM    797  CD  PRO   103      37.062   5.740  61.971  1.00 82.18           C  
ATOM    798  N   GLY   104      39.988   8.049  60.864  1.00 79.06           N  
ATOM    799  CA  GLY   104      41.177   8.864  60.700  1.00 78.37           C  
ATOM    800  C   GLY   104      42.316   8.198  59.953  1.00 78.10           C  
ATOM    801  O   GLY   104      42.884   8.779  59.025  1.00 77.03           O  
ATOM    802  N   GLU   105      42.659   6.981  60.360  1.00 78.40           N  
ATOM    803  CA  GLU   105      43.744   6.240  59.725  1.00 78.99           C  
ATOM    804  C   GLU   105      43.413   5.894  58.278  1.00 77.22           C  
ATOM    805  O   GLU   105      44.285   5.858  57.419  1.00 77.36           O  
ATOM    806  CB  GLU   105      44.048   4.974  60.528  1.00 81.54           C  
ATOM    807  CG  GLU   105      45.054   5.222  61.641  1.00 87.07           C  
ATOM    808  CD  GLU   105      44.955   4.232  62.795  1.00 90.76           C  
ATOM    809  OE1 GLU   105      45.013   3.005  62.546  1.00 92.73           O  
ATOM    810  OE2 GLU   105      44.829   4.689  63.957  1.00 92.21           O  
ATOM    811  N   ARG   106      42.142   5.654  58.013  1.00 75.03           N  
ATOM    812  CA  ARG   106      41.705   5.331  56.675  1.00 73.33           C  
ATOM    813  C   ARG   106      41.866   6.555  55.777  1.00 72.50           C  
ATOM    814  O   ARG   106      42.196   6.428  54.598  1.00 72.89           O  
ATOM    815  CB  ARG   106      40.243   4.905  56.703  1.00 73.84           C  
ATOM    816  CG  ARG   106      39.655   4.610  55.355  1.00 77.66           C  
ATOM    817  CD  ARG   106      38.140   4.759  55.372  1.00 81.26           C  
ATOM    818  NE  ARG   106      37.583   4.603  54.032  1.00 85.82           N  
ATOM    819  CZ  ARG   106      36.351   4.962  53.678  1.00 88.83           C  
ATOM    820  NH1 ARG   106      35.532   5.506  54.572  1.00 89.61           N  
ATOM    821  NH2 ARG   106      35.940   4.785  52.423  1.00 89.25           N  
ATOM    822  N   SER   107      41.633   7.742  56.333  1.00 70.78           N  
ATOM    823  CA  SER   107      41.744   8.972  55.549  1.00 67.82           C  
ATOM    824  C   SER   107      43.176   9.174  55.080  1.00 66.49           C  
ATOM    825  O   SER   107      43.404   9.793  54.035  1.00 66.15           O  
ATOM    826  CB  SER   107      41.315  10.190  56.368  1.00 66.66           C  
ATOM    827  OG  SER   107      42.429  10.756  57.037  1.00 68.47           O  
ATOM    828  N   VAL   108      44.127   8.651  55.858  1.00 64.47           N  
ATOM    829  CA  VAL   108      45.549   8.755  55.549  1.00 62.95           C  
ATOM    830  C   VAL   108      45.921   7.759  54.472  1.00 63.50           C  
ATOM    831  O   VAL   108      46.596   8.109  53.502  1.00 64.63           O  
ATOM    832  CB  VAL   108      46.429   8.496  56.800  1.00 62.97           C  
ATOM    833  CG1 VAL   108      47.877   8.232  56.397  1.00 60.07           C  
ATOM    834  CG2 VAL   108      46.361   9.699  57.725  1.00 63.07           C  
ATOM    835  N   LEU   109      45.482   6.515  54.632  1.00 63.15           N  
ATOM    836  CA  LEU   109      45.787   5.491  53.635  1.00 62.19           C  
ATOM    837  C   LEU   109      45.290   5.942  52.257  1.00 60.92           C  
ATOM    838  O   LEU   109      45.945   5.686  51.249  1.00 60.16           O  
ATOM    839  CB  LEU   109      45.147   4.145  54.026  1.00 60.53           C  
ATOM    840  CG  LEU   109      45.900   3.301  55.070  1.00 60.39           C  
ATOM    841  CD1 LEU   109      44.999   2.165  55.552  1.00 58.69           C  
ATOM    842  CD2 LEU   109      47.205   2.765  54.486  1.00 55.69           C  
ATOM    843  N   SER   110      44.140   6.616  52.240  1.00 58.67           N  
ATOM    844  CA  SER   110      43.528   7.117  51.015  1.00 58.92           C  
ATOM    845  C   SER   110      44.305   8.276  50.422  1.00 58.98           C  
ATOM    846  O   SER   110      44.239   8.524  49.218  1.00 58.97           O  
ATOM    847  CB  SER   110      42.092   7.587  51.269  1.00 58.40           C  
ATOM    848  OG  SER   110      41.194   6.498  51.302  1.00 59.26           O  
ATOM    849  N   ALA   111      45.009   9.006  51.277  1.00 57.94           N  
ATOM    850  CA  ALA   111      45.800  10.128  50.821  1.00 56.24           C  
ATOM    851  C   ALA   111      46.970   9.522  50.079  1.00 55.63           C  
ATOM    852  O   ALA   111      47.416  10.037  49.065  1.00 57.35           O  
ATOM    853  CB  ALA   111      46.282  10.926  51.989  1.00 55.30           C  
ATOM    854  N   LEU   112      47.472   8.416  50.595  1.00 54.79           N  
ATOM    855  CA  LEU   112      48.578   7.749  49.942  1.00 55.19           C  
ATOM    856  C   LEU   112      48.104   7.275  48.576  1.00 53.33           C  
ATOM    857  O   LEU   112      48.802   7.438  47.587  1.00 53.50           O  
ATOM    858  CB  LEU   112      49.076   6.573  50.794  1.00 55.11           C  
ATOM    859  CG  LEU   112      49.862   7.035  52.030  1.00 56.18           C  
ATOM    860  CD1 LEU   112      49.829   5.963  53.111  1.00 55.35           C  
ATOM    861  CD2 LEU   112      51.307   7.388  51.622  1.00 54.94           C  
ATOM    862  N   ALA   113      46.907   6.709  48.533  1.00 51.67           N  
ATOM    863  CA  ALA   113      46.326   6.221  47.292  1.00 51.20           C  
ATOM    864  C   ALA   113      46.153   7.357  46.274  1.00 50.60           C  
ATOM    865  O   ALA   113      46.504   7.200  45.117  1.00 50.46           O  
ATOM    866  CB  ALA   113      44.989   5.575  47.576  1.00 52.01           C  
ATOM    867  N   ARG   114      45.613   8.489  46.716  1.00 49.15           N  
ATOM    868  CA  ARG   114      45.409   9.632  45.856  1.00 49.51           C  
ATOM    869  C   ARG   114      46.769   9.996  45.270  1.00 51.04           C  
ATOM    870  O   ARG   114      46.915  10.198  44.061  1.00 51.84           O  
ATOM    871  CB  ARG   114      44.826  10.810  46.660  1.00 49.19           C  
ATOM    872  CG  ARG   114      44.355  12.000  45.807  1.00 52.27           C  
ATOM    873  CD  ARG   114      43.813  13.194  46.619  1.00 55.32           C  
ATOM    874  NE  ARG   114      44.149  14.496  46.007  1.00 61.37           N  
ATOM    875  CZ  ARG   114      44.054  15.691  46.618  1.00 65.98           C  
ATOM    876  NH1 ARG   114      43.627  15.784  47.883  1.00 65.95           N  
ATOM    877  NH2 ARG   114      44.396  16.812  45.970  1.00 64.49           N  
ATOM    878  N   ARG   115      47.781  10.034  46.127  1.00 52.10           N  
ATOM    879  CA  ARG   115      49.120  10.377  45.690  1.00 52.46           C  
ATOM    880  C   ARG   115      49.695   9.356  44.726  1.00 51.72           C  
ATOM    881  O   ARG   115      50.507   9.687  43.874  1.00 50.66           O  
ATOM    882  CB  ARG   115      50.034  10.504  46.893  1.00 54.19           C  
ATOM    883  CG  ARG   115      51.333  11.201  46.591  1.00 58.70           C  
ATOM    884  CD  ARG   115      51.122  12.658  46.193  1.00 64.25           C  
ATOM    885  NE  ARG   115      52.386  13.379  46.300  1.00 71.61           N  
ATOM    886  CZ  ARG   115      53.425  13.202  45.483  1.00 74.87           C  
ATOM    887  NH1 ARG   115      53.351  12.338  44.479  1.00 75.09           N  
ATOM    888  NH2 ARG   115      54.562  13.858  45.696  1.00 77.88           N  
ATOM    889  N   LEU   116      49.270   8.108  44.875  1.00 53.33           N  
ATOM    890  CA  LEU   116      49.737   7.024  44.025  1.00 53.58           C  
ATOM    891  C   LEU   116      49.196   7.267  42.632  1.00 54.07           C  
ATOM    892  O   LEU   116      49.904   7.129  41.641  1.00 53.57           O  
ATOM    893  CB  LEU   116      49.223   5.685  44.541  1.00 53.00           C  
ATOM    894  CG  LEU   116      49.707   4.495  43.700  1.00 55.61           C  
ATOM    895  CD1 LEU   116      51.238   4.431  43.760  1.00 55.15           C  
ATOM    896  CD2 LEU   116      49.088   3.196  44.202  1.00 52.60           C  
ATOM    897  N   LEU   117      47.927   7.644  42.575  1.00 55.37           N  
ATOM    898  CA  LEU   117      47.273   7.909  41.312  1.00 56.86           C  
ATOM    899  C   LEU   117      48.001   9.045  40.601  1.00 58.79           C  
ATOM    900  O   LEU   117      48.218   8.992  39.397  1.00 57.58           O  
ATOM    901  CB  LEU   117      45.817   8.285  41.549  1.00 54.08           C  
ATOM    902  CG  LEU   117      45.092   8.604  40.250  1.00 55.91           C  
ATOM    903  CD1 LEU   117      45.068   7.355  39.383  1.00 52.57           C  
ATOM    904  CD2 LEU   117      43.685   9.124  40.549  1.00 54.28           C  
ATOM    905  N   GLN   118      48.364  10.076  41.357  1.00 61.30           N  
ATOM    906  CA  GLN   118      49.087  11.212  40.813  1.00 64.01           C  
ATOM    907  C   GLN   118      50.420  10.789  40.208  1.00 65.87           C  
ATOM    908  O   GLN   118      50.724  11.114  39.060  1.00 66.18           O  
ATOM    909  CB  GLN   118      49.369  12.240  41.904  1.00 66.27           C  
ATOM    910  CG  GLN   118      48.333  13.338  42.033  1.00 70.48           C  
ATOM    911  CD  GLN   118      48.967  14.674  42.403  1.00 71.81           C  
ATOM    912  OE1 GLN   118      49.490  14.842  43.507  1.00 72.65           O  
ATOM    913  NE2 GLN   118      48.936  15.627  41.470  1.00 71.99           N  
ATOM    914  N   GLU   119      51.226  10.070  40.984  1.00 67.06           N  
ATOM    915  CA  GLU   119      52.523   9.645  40.494  1.00 67.50           C  
ATOM    916  C   GLU   119      52.431   8.820  39.221  1.00 67.60           C  
ATOM    917  O   GLU   119      53.225   9.003  38.302  1.00 68.48           O  
ATOM    918  CB  GLU   119      53.275   8.878  41.573  1.00 68.66           C  
ATOM    919  CG  GLU   119      53.928   9.767  42.620  1.00 71.97           C  
ATOM    920  CD  GLU   119      54.828  10.844  42.016  1.00 74.74           C  
ATOM    921  OE1 GLU   119      55.733  10.510  41.209  1.00 75.46           O  
ATOM    922  OE2 GLU   119      54.630  12.031  42.356  1.00 75.41           O  
ATOM    923  N   ARG   120      51.465   7.918  39.154  1.00 67.09           N  
ATOM    924  CA  ARG   120      51.316   7.101  37.962  1.00 67.86           C  
ATOM    925  C   ARG   120      50.855   7.967  36.786  1.00 67.81           C  
ATOM    926  O   ARG   120      51.320   7.796  35.664  1.00 67.79           O  
ATOM    927  CB  ARG   120      50.324   5.966  38.224  1.00 68.54           C  
ATOM    928  CG  ARG   120      50.763   5.028  39.331  1.00 70.24           C  
ATOM    929  CD  ARG   120      50.838   3.592  38.829  1.00 73.28           C  
ATOM    930  NE  ARG   120      51.951   2.858  39.433  1.00 74.70           N  
ATOM    931  CZ  ARG   120      51.835   1.959  40.406  1.00 75.34           C  
ATOM    932  NH1 ARG   120      50.644   1.651  40.908  1.00 76.24           N  
ATOM    933  NH2 ARG   120      52.925   1.377  40.890  1.00 75.76           N  
ATOM    934  N   LEU   121      49.947   8.899  37.050  1.00 68.08           N  
ATOM    935  CA  LEU   121      49.439   9.791  36.018  1.00 68.24           C  
ATOM    936  C   LEU   121      50.554  10.682  35.488  1.00 70.62           C  
ATOM    937  O   LEU   121      50.622  10.976  34.292  1.00 71.40           O  
ATOM    938  CB  LEU   121      48.317  10.687  36.563  1.00 64.60           C  
ATOM    939  CG  LEU   121      46.905  10.115  36.721  1.00 63.20           C  
ATOM    940  CD1 LEU   121      45.941  11.241  37.003  1.00 62.27           C  
ATOM    941  CD2 LEU   121      46.476   9.417  35.457  1.00 62.87           C  
ATOM    942  N   ARG   122      51.433  11.111  36.385  1.00 72.33           N  
ATOM    943  CA  ARG   122      52.519  11.988  35.998  1.00 73.62           C  
ATOM    944  C   ARG   122      53.534  11.322  35.066  1.00 74.20           C  
ATOM    945  O   ARG   122      54.229  12.009  34.319  1.00 74.67           O  
ATOM    946  CB  ARG   122      53.219  12.521  37.242  1.00 74.51           C  
ATOM    947  CG  ARG   122      54.192  13.639  36.940  1.00 78.84           C  
ATOM    948  CD  ARG   122      54.973  14.074  38.172  1.00 81.78           C  
ATOM    949  NE  ARG   122      55.975  13.088  38.585  1.00 85.00           N  
ATOM    950  CZ  ARG   122      57.036  12.739  37.856  1.00 86.41           C  
ATOM    951  NH1 ARG   122      57.243  13.290  36.664  1.00 87.13           N  
ATOM    952  NH2 ARG   122      57.900  11.843  38.322  1.00 85.88           N  
ATOM    953  N   ARG   123      53.609   9.995  35.087  1.00 74.20           N  
ATOM    954  CA  ARG   123      54.559   9.288  34.242  1.00 75.77           C  
ATOM    955  C   ARG   123      53.935   8.726  32.975  1.00 76.88           C  
ATOM    956  O   ARG   123      54.529   7.891  32.286  1.00 77.15           O  
ATOM    957  CB  ARG   123      55.226   8.171  35.042  1.00 77.07           C  
ATOM    958  CG  ARG   123      56.273   8.678  36.018  1.00 79.66           C  
ATOM    959  CD  ARG   123      56.275   7.859  37.307  1.00 84.37           C  
ATOM    960  NE  ARG   123      57.260   8.341  38.279  1.00 87.36           N  
ATOM    961  CZ  ARG   123      58.298   7.629  38.714  1.00 88.63           C  
ATOM    962  NH1 ARG   123      58.499   6.390  38.268  1.00 88.48           N  
ATOM    963  NH2 ARG   123      59.143   8.157  39.595  1.00 88.92           N  
ATOM    964  N   LEU   124      52.736   9.194  32.660  1.00 78.38           N  
ATOM    965  CA  LEU   124      52.048   8.723  31.472  1.00 79.17           C  
ATOM    966  C   LEU   124      52.505   9.401  30.195  1.00 81.39           C  
ATOM    967  O   LEU   124      52.708  10.620  30.141  1.00 80.31           O  
ATOM    968  CB  LEU   124      50.540   8.876  31.631  1.00 77.62           C  
ATOM    969  CG  LEU   124      49.923   7.711  32.394  1.00 76.01           C  
ATOM    970  CD1 LEU   124      48.422   7.901  32.513  1.00 75.32           C  
ATOM    971  CD2 LEU   124      50.252   6.424  31.660  1.00 75.36           C  
ATOM    972  N   GLU   125      52.652   8.574  29.164  1.00 84.49           N  
ATOM    973  CA  GLU   125      53.110   8.994  27.845  1.00 85.71           C  
ATOM    974  C   GLU   125      52.056   9.689  26.994  1.00 85.14           C  
ATOM    975  O   GLU   125      50.935   9.205  26.858  1.00 85.22           O  
ATOM    976  CB  GLU   125      53.637   7.770  27.105  1.00 87.34           C  
ATOM    977  CG  GLU   125      52.672   6.596  27.120  1.00 90.13           C  
ATOM    978  CD  GLU   125      53.277   5.342  26.503  1.00 93.48           C  
ATOM    979  OE1 GLU   125      52.526   4.364  26.264  1.00 93.88           O  
ATOM    980  OE2 GLU   125      54.508   5.332  26.262  1.00 94.50           O  
ATOM    981  N   GLY   126      52.432  10.827  26.421  1.00 84.38           N  
ATOM    982  CA  GLY   126      51.525  11.569  25.567  1.00 84.11           C  
ATOM    983  C   GLY   126      50.109  11.654  26.094  1.00 84.57           C  
ATOM    984  O   GLY   126      49.202  10.961  25.621  1.00 84.45           O  
ATOM    985  N   VAL   127      49.923  12.512  27.088  1.00 84.08           N  
ATOM    986  CA  VAL   127      48.620  12.718  27.692  1.00 82.67           C  
ATOM    987  C   VAL   127      48.748  13.875  28.618  1.00 81.90           C  
ATOM    988  O   VAL   127      49.804  14.183  29.172  1.00 82.37           O  
ATOM    989  CB  VAL   127      48.136  11.527  28.488  1.00 83.19           C  
ATOM    990  CG1 VAL   127      48.848  11.468  29.813  1.00 83.20           C  
ATOM    991  CG2 VAL   127      46.632  11.661  28.705  1.00 85.44           C  
ATOM    992  N   TRP   128      47.632  14.468  28.887  1.00 80.51           N  
ATOM    993  CA  TRP   128      47.734  15.623  29.638  1.00 80.52           C  
ATOM    994  C   TRP   128      47.141  15.645  31.061  1.00 79.00           C  
ATOM    995  O   TRP   128      45.951  15.445  31.262  1.00 77.99           O  
ATOM    996  CB  TRP   128      47.134  16.624  28.761  1.00 82.46           C  
ATOM    997  CG  TRP   128      46.958  17.666  29.437  1.00 85.61           C  
ATOM    998  CD1 TRP   128      46.005  17.899  30.373  1.00 86.56           C  
ATOM    999  CD2 TRP   128      47.763  18.784  29.346  1.00 86.36           C  
ATOM   1000  NE1 TRP   128      46.174  19.156  30.883  1.00 86.71           N  
ATOM   1001  CE2 TRP   128      47.266  19.720  30.273  1.00 86.60           C  
ATOM   1002  CE3 TRP   128      48.886  19.099  28.561  1.00 87.01           C  
ATOM   1003  CZ2 TRP   128      47.840  20.951  30.448  1.00 86.74           C  
ATOM   1004  CZ3 TRP   128      49.470  20.322  28.713  1.00 87.31           C  
ATOM   1005  CH2 TRP   128      48.950  21.250  29.666  1.00 87.56           C  
ATOM   1006  N   VAL   129      47.980  15.960  32.033  1.00 75.97           N  
ATOM   1007  CA  VAL   129      47.559  15.911  33.410  1.00 75.60           C  
ATOM   1008  C   VAL   129      47.448  17.230  34.159  1.00 76.75           C  
ATOM   1009  O   VAL   129      48.377  18.013  34.180  1.00 77.49           O  
ATOM   1010  CB  VAL   129      48.481  14.982  34.158  1.00 73.90           C  
ATOM   1011  CG1 VAL   129      47.937  14.678  35.508  1.00 72.70           C  
ATOM   1012  CG2 VAL   129      48.676  13.740  33.319  1.00 74.83           C  
ATOM   1013  N   GLU   130      46.312  17.452  34.812  1.00 77.77           N  
ATOM   1014  CA  GLU   130      46.095  18.674  35.558  1.00 78.92           C  
ATOM   1015  C   GLU   130      45.676  18.287  36.984  1.00 78.24           C  
ATOM   1016  O   GLU   130      44.547  18.553  37.417  1.00 78.14           O  
ATOM   1017  CB  GLU   130      45.014  19.508  34.858  1.00 81.69           C  
ATOM   1018  CG  GLU   130      45.052  21.006  35.164  1.00 87.16           C  
ATOM   1019  CD  GLU   130      44.100  21.814  34.283  1.00 90.28           C  
ATOM   1020  OE1 GLU   130      42.880  21.856  34.573  1.00 91.28           O  
ATOM   1021  OE2 GLU   130      44.580  22.401  33.286  1.00 92.44           O  
ATOM   1022  N   GLY   131      46.598  17.647  37.702  1.00 76.55           N  
ATOM   1023  CA  GLY   131      46.330  17.230  39.068  1.00 74.58           C  
ATOM   1024  C   GLY   131      45.865  15.791  39.106  1.00 73.64           C  
ATOM   1025  O   GLY   131      46.671  14.882  38.911  1.00 73.38           O  
ATOM   1026  N   LEU   132      44.571  15.590  39.366  1.00 72.73           N  
ATOM   1027  CA  LEU   132      43.975  14.258  39.397  1.00 71.14           C  
ATOM   1028  C   LEU   132      43.165  14.024  38.134  1.00 70.81           C  
ATOM   1029  O   LEU   132      42.451  13.033  38.009  1.00 70.97           O  
ATOM   1030  CB  LEU   132      43.082  14.082  40.626  1.00 69.55           C  
ATOM   1031  CG  LEU   132      43.854  13.777  41.914  1.00 69.71           C  
ATOM   1032  CD1 LEU   132      42.862  13.482  43.025  1.00 68.93           C  
ATOM   1033  CD2 LEU   132      44.797  12.593  41.702  1.00 67.63           C  
ATOM   1034  N   ALA   133      43.291  14.946  37.190  1.00 70.99           N  
ATOM   1035  CA  ALA   133      42.580  14.843  35.932  1.00 70.67           C  
ATOM   1036  C   ALA   133      43.492  14.341  34.812  1.00 70.47           C  
ATOM   1037  O   ALA   133      44.708  14.505  34.855  1.00 69.45           O  
ATOM   1038  CB  ALA   133      41.990  16.195  35.566  1.00 70.41           C  
ATOM   1039  N   VAL   134      42.892  13.691  33.827  1.00 70.67           N  
ATOM   1040  CA  VAL   134      43.635  13.193  32.689  1.00 71.29           C  
ATOM   1041  C   VAL   134      42.827  13.645  31.498  1.00 72.40           C  
ATOM   1042  O   VAL   134      41.604  13.543  31.505  1.00 71.80           O  
ATOM   1043  CB  VAL   134      43.695  11.657  32.623  1.00 70.65           C  
ATOM   1044  CG1 VAL   134      44.702  11.235  31.579  1.00 69.82           C  
ATOM   1045  CG2 VAL   134      44.058  11.080  33.954  1.00 72.45           C  
ATOM   1046  N   TYR   135      43.514  14.167  30.492  1.00 73.97           N  
ATOM   1047  CA  TYR   135      42.872  14.607  29.267  1.00 74.92           C  
ATOM   1048  C   TYR   135      43.616  13.860  28.175  1.00 76.66           C  
ATOM   1049  O   TYR   135      44.782  14.113  27.913  1.00 77.04           O  
ATOM   1050  CB  TYR   135      42.971  16.128  29.138  1.00 72.52           C  
ATOM   1051  CG  TYR   135      42.156  16.810  30.207  1.00 70.54           C  
ATOM   1052  CD1 TYR   135      42.708  17.125  31.442  1.00 70.96           C  
ATOM   1053  CD2 TYR   135      40.795  17.033  30.027  1.00 71.86           C  
ATOM   1054  CE1 TYR   135      41.918  17.651  32.484  1.00 70.63           C  
ATOM   1055  CE2 TYR   135      39.989  17.548  31.060  1.00 71.08           C  
ATOM   1056  CZ  TYR   135      40.559  17.855  32.283  1.00 70.70           C  
ATOM   1057  OH  TYR   135      39.771  18.361  33.292  1.00 68.68           O  
ATOM   1058  N   ARG   136      42.931  12.891  27.579  1.00 79.43           N  
ATOM   1059  CA  ARG   136      43.527  12.047  26.553  1.00 82.21           C  
ATOM   1060  C   ARG   136      43.487  12.561  25.112  1.00 82.50           C  
ATOM   1061  O   ARG   136      44.511  12.540  24.426  1.00 83.13           O  
ATOM   1062  CB  ARG   136      42.885  10.662  26.595  1.00 84.89           C  
ATOM   1063  CG  ARG   136      42.700  10.095  27.989  1.00 89.03           C  
ATOM   1064  CD  ARG   136      42.321   8.624  27.926  1.00 94.02           C  
ATOM   1065  NE  ARG   136      41.072   8.379  27.196  1.00 98.32           N  
ATOM   1066  CZ  ARG   136      40.660   7.178  26.773  1.00100.24           C  
ATOM   1067  NH1 ARG   136      41.394   6.092  26.997  1.00100.92           N  
ATOM   1068  NH2 ARG   136      39.507   7.054  26.123  1.00 99.02           N  
ATOM   1069  N   ARG   137      42.323  13.020  24.652  1.00 81.91           N  
ATOM   1070  CA  ARG   137      42.193  13.456  23.266  1.00 80.78           C  
ATOM   1071  C   ARG   137      41.467  14.750  22.926  1.00 81.03           C  
ATOM   1072  O   ARG   137      40.510  15.150  23.587  1.00 80.59           O  
ATOM   1073  CB  ARG   137      41.551  12.334  22.471  1.00 81.17           C  
ATOM   1074  CG  ARG   137      40.339  11.709  23.145  1.00 79.96           C  
ATOM   1075  CD  ARG   137      39.832  10.566  22.298  1.00 81.08           C  
ATOM   1076  NE  ARG   137      40.939   9.735  21.829  1.00 82.40           N  
ATOM   1077  CZ  ARG   137      41.252   8.539  22.320  1.00 83.14           C  
ATOM   1078  NH1 ARG   137      40.541   8.007  23.307  1.00 84.17           N  
ATOM   1079  NH2 ARG   137      42.283   7.872  21.823  1.00 82.61           N  
ATOM   1080  N   GLU   138      41.920  15.368  21.837  1.00 82.42           N  
ATOM   1081  CA  GLU   138      41.378  16.626  21.331  1.00 83.22           C  
ATOM   1082  C   GLU   138      39.941  16.567  20.846  1.00 83.78           C  
ATOM   1083  O   GLU   138      39.455  15.521  20.442  1.00 84.00           O  
ATOM   1084  CB  GLU   138      42.252  17.147  20.198  1.00 83.28           C  
ATOM   1085  CG  GLU   138      43.532  17.798  20.665  1.00 85.60           C  
ATOM   1086  CD  GLU   138      44.228  18.547  19.553  1.00 87.23           C  
ATOM   1087  OE1 GLU   138      43.518  19.061  18.659  1.00 87.20           O  
ATOM   1088  OE2 GLU   138      45.477  18.632  19.582  1.00 88.25           O  
ATOM   1089  N   HIS   139      39.271  17.713  20.880  1.00 85.40           N  
ATOM   1090  CA  HIS   139      37.882  17.815  20.449  1.00 87.35           C  
ATOM   1091  C   HIS   139      37.633  19.055  19.610  1.00 87.96           C  
ATOM   1092  O   HIS   139      36.544  19.230  19.068  1.00 89.27           O  
ATOM   1093  CB  HIS   139      36.934  17.840  21.652  1.00 88.46           C  
ATOM   1094  CG  HIS   139      36.643  16.485  22.219  1.00 91.04           C  
ATOM   1095  ND1 HIS   139      37.569  15.763  22.942  1.00 92.06           N  
ATOM   1096  CD2 HIS   139      35.540  15.704  22.138  1.00 91.59           C  
ATOM   1097  CE1 HIS   139      37.049  14.596  23.281  1.00 91.95           C  
ATOM   1098  NE2 HIS   139      35.818  14.536  22.806  1.00 91.16           N  
ATOM   1099  N   ALA   140      38.641  19.912  19.507  1.00 87.65           N  
ATOM   1100  CA  ALA   140      38.535  21.147  18.742  1.00 87.55           C  
ATOM   1101  C   ALA   140      39.808  21.893  19.044  1.00 88.15           C  
ATOM   1102  O   ALA   140      40.442  21.615  20.060  1.00 88.01           O  
ATOM   1103  CB  ALA   140      37.340  21.957  19.209  1.00 87.03           C  
ATOM   1104  N   ARG   141      40.194  22.829  18.180  1.00 88.44           N  
ATOM   1105  CA  ARG   141      41.412  23.568  18.440  1.00 89.04           C  
ATOM   1106  C   ARG   141      41.438  25.018  17.965  1.00 90.28           C  
ATOM   1107  O   ARG   141      41.049  25.905  18.701  1.00 90.53           O  
ATOM   1108  CB  ARG   141      42.622  22.784  17.912  1.00 87.72           C  
ATOM   1109  CG  ARG   141      42.749  22.703  16.423  1.00 88.27           C  
ATOM   1110  CD  ARG   141      43.439  21.425  15.983  1.00 90.32           C  
ATOM   1111  NE  ARG   141      44.515  20.972  16.866  1.00 92.61           N  
ATOM   1112  CZ  ARG   141      45.688  21.580  17.032  1.00 93.88           C  
ATOM   1113  NH1 ARG   141      45.969  22.699  16.373  1.00 95.14           N  
ATOM   1114  NH2 ARG   141      46.588  21.054  17.857  1.00 93.25           N  
ATOM   1115  N   GLY   142      41.885  25.290  16.753  1.00 91.38           N  
ATOM   1116  CA  GLY   142      41.936  26.682  16.346  1.00 91.80           C  
ATOM   1117  C   GLY   142      43.212  27.332  16.866  1.00 91.86           C  
ATOM   1118  O   GLY   142      43.961  26.711  17.629  1.00 91.91           O  
ATOM   1119  N   PRO   143      43.475  28.595  16.496  1.00 91.92           N  
ATOM   1120  CA  PRO   143      44.680  29.316  16.926  1.00 91.04           C  
ATOM   1121  C   PRO   143      44.930  29.490  18.429  1.00 90.18           C  
ATOM   1122  O   PRO   143      44.177  30.172  19.126  1.00 89.84           O  
ATOM   1123  CB  PRO   143      44.547  30.656  16.206  1.00 91.64           C  
ATOM   1124  CG  PRO   143      43.056  30.866  16.185  1.00 92.31           C  
ATOM   1125  CD  PRO   143      42.544  29.498  15.788  1.00 91.67           C  
ATOM   1126  N   GLY   144      45.996  28.861  18.917  1.00 89.03           N  
ATOM   1127  CA  GLY   144      46.369  28.993  20.315  1.00 87.46           C  
ATOM   1128  C   GLY   144      45.532  28.326  21.392  1.00 85.90           C  
ATOM   1129  O   GLY   144      45.972  28.235  22.530  1.00 85.97           O  
ATOM   1130  N   TRP   145      44.322  27.892  21.078  1.00 84.14           N  
ATOM   1131  CA  TRP   145      43.525  27.220  22.092  1.00 82.52           C  
ATOM   1132  C   TRP   145      43.294  25.798  21.635  1.00 80.56           C  
ATOM   1133  O   TRP   145      43.558  25.467  20.483  1.00 81.96           O  
ATOM   1134  CB  TRP   145      42.188  27.921  22.320  1.00 83.40           C  
ATOM   1135  CG  TRP   145      41.329  28.067  21.105  1.00 86.17           C  
ATOM   1136  CD1 TRP   145      41.407  29.047  20.155  1.00 86.41           C  
ATOM   1137  CD2 TRP   145      40.204  27.254  20.748  1.00 88.09           C  
ATOM   1138  NE1 TRP   145      40.395  28.901  19.238  1.00 87.17           N  
ATOM   1139  CE2 TRP   145      39.641  27.811  19.575  1.00 87.21           C  
ATOM   1140  CE3 TRP   145      39.615  26.105  21.305  1.00 88.76           C  
ATOM   1141  CZ2 TRP   145      38.517  27.262  18.950  1.00 87.59           C  
ATOM   1142  CZ3 TRP   145      38.490  25.557  20.676  1.00 88.82           C  
ATOM   1143  CH2 TRP   145      37.957  26.140  19.513  1.00 88.14           C  
ATOM   1144  N   ARG   146      42.825  24.949  22.537  1.00 77.09           N  
ATOM   1145  CA  ARG   146      42.575  23.562  22.194  1.00 74.62           C  
ATOM   1146  C   ARG   146      41.838  22.850  23.318  1.00 72.32           C  
ATOM   1147  O   ARG   146      42.250  22.868  24.464  1.00 72.39           O  
ATOM   1148  CB  ARG   146      43.904  22.878  21.828  1.00 75.07           C  
ATOM   1149  CG  ARG   146      44.366  21.686  22.648  1.00 75.81           C  
ATOM   1150  CD  ARG   146      45.612  21.142  21.964  1.00 77.61           C  
ATOM   1151  NE  ARG   146      46.308  20.063  22.664  1.00 80.87           N  
ATOM   1152  CZ  ARG   146      47.153  20.233  23.679  1.00 82.13           C  
ATOM   1153  NH1 ARG   146      47.413  21.449  24.142  1.00 82.86           N  
ATOM   1154  NH2 ARG   146      47.776  19.182  24.205  1.00 82.93           N  
ATOM   1155  N   VAL   147      40.711  22.250  22.975  1.00 70.54           N  
ATOM   1156  CA  VAL   147      39.896  21.549  23.948  1.00 68.67           C  
ATOM   1157  C   VAL   147      40.288  20.081  24.042  1.00 67.90           C  
ATOM   1158  O   VAL   147      40.510  19.431  23.023  1.00 67.92           O  
ATOM   1159  CB  VAL   147      38.405  21.628  23.568  1.00 68.06           C  
ATOM   1160  CG1 VAL   147      37.590  20.726  24.466  1.00 67.90           C  
ATOM   1161  CG2 VAL   147      37.924  23.049  23.674  1.00 66.33           C  
ATOM   1162  N   LEU   148      40.385  19.564  25.266  1.00 66.41           N  
ATOM   1163  CA  LEU   148      40.715  18.157  25.464  1.00 63.56           C  
ATOM   1164  C   LEU   148      39.663  17.514  26.337  1.00 62.01           C  
ATOM   1165  O   LEU   148      39.061  18.161  27.191  1.00 60.42           O  
ATOM   1166  CB  LEU   148      42.079  17.995  26.111  1.00 62.43           C  
ATOM   1167  CG  LEU   148      43.245  18.583  25.330  1.00 63.05           C  
ATOM   1168  CD1 LEU   148      44.543  18.188  25.999  1.00 64.18           C  
ATOM   1169  CD2 LEU   148      43.223  18.070  23.913  1.00 62.67           C  
ATOM   1170  N   GLY   149      39.428  16.234  26.100  1.00 61.64           N  
ATOM   1171  CA  GLY   149      38.447  15.521  26.884  1.00 60.17           C  
ATOM   1172  C   GLY   149      39.090  14.360  27.600  1.00 60.50           C  
ATOM   1173  O   GLY   149      39.861  13.596  27.007  1.00 60.87           O  
ATOM   1174  N   GLY   150      38.782  14.245  28.888  1.00 59.65           N  
ATOM   1175  CA  GLY   150      39.302  13.161  29.702  1.00 57.19           C  
ATOM   1176  C   GLY   150      38.365  12.972  30.881  1.00 56.01           C  
ATOM   1177  O   GLY   150      37.140  12.950  30.697  1.00 54.74           O  
ATOM   1178  N   ALA   151      38.928  12.848  32.086  1.00 53.87           N  
ATOM   1179  CA  ALA   151      38.128  12.676  33.295  1.00 52.26           C  
ATOM   1180  C   ALA   151      38.894  13.034  34.565  1.00 51.67           C  
ATOM   1181  O   ALA   151      40.091  12.764  34.670  1.00 49.71           O  
ATOM   1182  CB  ALA   151      37.633  11.231  33.393  1.00 50.92           C  
ATOM   1183  N   VAL   152      38.213  13.660  35.521  1.00 51.42           N  
ATOM   1184  CA  VAL   152      38.858  13.962  36.797  1.00 52.53           C  
ATOM   1185  C   VAL   152      38.692  12.631  37.517  1.00 52.46           C  
ATOM   1186  O   VAL   152      37.633  12.014  37.446  1.00 53.17           O  
ATOM   1187  CB  VAL   152      38.157  15.115  37.561  1.00 52.93           C  
ATOM   1188  CG1 VAL   152      38.479  16.431  36.899  1.00 53.90           C  
ATOM   1189  CG2 VAL   152      36.666  14.941  37.533  1.00 54.66           C  
ATOM   1190  N   LEU   153      39.746  12.170  38.173  1.00 51.56           N  
ATOM   1191  CA  LEU   153      39.712  10.876  38.824  1.00 50.97           C  
ATOM   1192  C   LEU   153      40.001  10.939  40.304  1.00 53.35           C  
ATOM   1193  O   LEU   153      40.428  11.971  40.836  1.00 54.32           O  
ATOM   1194  CB  LEU   153      40.769   9.964  38.211  1.00 49.44           C  
ATOM   1195  CG  LEU   153      40.998   9.830  36.703  1.00 48.15           C  
ATOM   1196  CD1 LEU   153      42.318   9.086  36.495  1.00 47.23           C  
ATOM   1197  CD2 LEU   153      39.854   9.103  36.040  1.00 43.93           C  
ATOM   1198  N   ASP   154      39.778   9.812  40.971  1.00 53.61           N  
ATOM   1199  CA  ASP   154      40.093   9.718  42.380  1.00 53.31           C  
ATOM   1200  C   ASP   154      40.356   8.268  42.720  1.00 52.51           C  
ATOM   1201  O   ASP   154      39.785   7.369  42.110  1.00 51.87           O  
ATOM   1202  CB  ASP   154      38.972  10.285  43.243  1.00 55.47           C  
ATOM   1203  CG  ASP   154      39.475  10.759  44.603  1.00 56.67           C  
ATOM   1204  OD1 ASP   154      40.692  10.605  44.873  1.00 57.83           O  
ATOM   1205  OD2 ASP   154      38.663  11.285  45.392  1.00 56.10           O  
ATOM   1206  N   LEU   155      41.244   8.056  43.685  1.00 52.57           N  
ATOM   1207  CA  LEU   155      41.630   6.720  44.124  1.00 53.42           C  
ATOM   1208  C   LEU   155      41.853   6.732  45.624  1.00 54.92           C  
ATOM   1209  O   LEU   155      42.752   7.407  46.127  1.00 54.74           O  
ATOM   1210  CB  LEU   155      42.924   6.262  43.422  1.00 50.84           C  
ATOM   1211  CG  LEU   155      43.420   4.864  43.802  1.00 49.30           C  
ATOM   1212  CD1 LEU   155      42.417   3.820  43.326  1.00 49.80           C  
ATOM   1213  CD2 LEU   155      44.763   4.594  43.167  1.00 50.73           C  
ATOM   1214  N   TRP   156      41.027   5.974  46.334  1.00 57.64           N  
ATOM   1215  CA  TRP   156      41.112   5.880  47.790  1.00 59.74           C  
ATOM   1216  C   TRP   156      40.881   4.461  48.283  1.00 60.15           C  
ATOM   1217  O   TRP   156      40.627   3.544  47.497  1.00 59.26           O  
ATOM   1218  CB  TRP   156      40.082   6.811  48.433  1.00 60.32           C  
ATOM   1219  CG  TRP   156      38.930   7.049  47.558  1.00 63.67           C  
ATOM   1220  CD1 TRP   156      38.922   7.740  46.375  1.00 66.54           C  
ATOM   1221  CD2 TRP   156      37.614   6.535  47.731  1.00 65.16           C  
ATOM   1222  NE1 TRP   156      37.676   7.679  45.794  1.00 67.32           N  
ATOM   1223  CE2 TRP   156      36.854   6.944  46.607  1.00 67.03           C  
ATOM   1224  CE3 TRP   156      37.004   5.767  48.719  1.00 64.21           C  
ATOM   1225  CZ2 TRP   156      35.516   6.607  46.452  1.00 67.24           C  
ATOM   1226  CZ3 TRP   156      35.688   5.436  48.568  1.00 66.86           C  
ATOM   1227  CH2 TRP   156      34.950   5.855  47.437  1.00 68.51           C  
ATOM   1228  N   VAL   157      40.981   4.293  49.597  1.00 61.19           N  
ATOM   1229  CA  VAL   157      40.770   3.000  50.236  1.00 62.27           C  
ATOM   1230  C   VAL   157      39.403   2.961  50.958  1.00 62.56           C  
ATOM   1231  O   VAL   157      38.846   3.998  51.318  1.00 62.00           O  
ATOM   1232  CB  VAL   157      41.919   2.723  51.219  1.00 62.30           C  
ATOM   1233  CG1 VAL   157      41.728   1.388  51.909  1.00 64.43           C  
ATOM   1234  CG2 VAL   157      43.237   2.727  50.465  1.00 62.97           C  
ATOM   1235  N   SER   158      38.845   1.767  51.135  1.00 64.49           N  
ATOM   1236  CA  SER   158      37.560   1.625  51.831  1.00 67.24           C  
ATOM   1237  C   SER   158      37.751   1.081  53.262  1.00 68.87           C  
ATOM   1238  O   SER   158      38.877   0.755  53.675  1.00 67.12           O  
ATOM   1239  CB  SER   158      36.631   0.699  51.042  1.00 66.15           C  
ATOM   1240  OG  SER   158      37.240  -0.564  50.826  1.00 66.46           O  
ATOM   1241  N   ASP   159      36.654   1.003  54.021  1.00 71.30           N  
ATOM   1242  CA  ASP   159      36.709   0.479  55.396  1.00 73.47           C  
ATOM   1243  C   ASP   159      36.947  -1.027  55.344  1.00 72.53           C  
ATOM   1244  O   ASP   159      37.199  -1.660  56.365  1.00 72.71           O  
ATOM   1245  CB  ASP   159      35.409   0.762  56.154  1.00 75.20           C  
ATOM   1246  CG  ASP   159      34.196   0.151  55.480  1.00 78.36           C  
ATOM   1247  OD1 ASP   159      34.355  -0.832  54.717  1.00 79.99           O  
ATOM   1248  OD2 ASP   159      33.077   0.646  55.723  1.00 79.78           O  
ATOM   1249  N   SER   160      36.855  -1.572  54.134  1.00 71.61           N  
ATOM   1250  CA  SER   160      37.073  -2.983  53.856  1.00 72.21           C  
ATOM   1251  C   SER   160      38.554  -3.179  53.541  1.00 72.10           C  
ATOM   1252  O   SER   160      39.067  -4.295  53.606  1.00 72.06           O  
ATOM   1253  CB  SER   160      36.235  -3.423  52.643  1.00 74.47           C  
ATOM   1254  OG  SER   160      34.848  -3.133  52.811  1.00 75.86           O  
ATOM   1255  N   GLY   161      39.231  -2.092  53.162  1.00 71.78           N  
ATOM   1256  CA  GLY   161      40.656  -2.168  52.869  1.00 69.97           C  
ATOM   1257  C   GLY   161      41.140  -2.440  51.454  1.00 68.35           C  
ATOM   1258  O   GLY   161      42.212  -3.023  51.264  1.00 67.64           O  
ATOM   1259  N   ALA   162      40.368  -2.026  50.456  1.00 67.82           N  
ATOM   1260  CA  ALA   162      40.768  -2.219  49.060  1.00 66.31           C  
ATOM   1261  C   ALA   162      40.673  -0.886  48.323  1.00 64.90           C  
ATOM   1262  O   ALA   162      39.918   0.005  48.734  1.00 64.15           O  
ATOM   1263  CB  ALA   162      39.865  -3.249  48.383  1.00 65.17           C  
ATOM   1264  N   PHE   163      41.429  -0.753  47.235  1.00 61.59           N  
ATOM   1265  CA  PHE   163      41.395   0.472  46.449  1.00 58.00           C  
ATOM   1266  C   PHE   163      40.062   0.678  45.768  1.00 57.52           C  
ATOM   1267  O   PHE   163      39.458  -0.259  45.278  1.00 59.00           O  
ATOM   1268  CB  PHE   163      42.460   0.447  45.377  1.00 54.06           C  
ATOM   1269  CG  PHE   163      43.837   0.594  45.902  1.00 50.52           C  
ATOM   1270  CD1 PHE   163      44.718  -0.477  45.875  1.00 49.21           C  
ATOM   1271  CD2 PHE   163      44.269   1.815  46.392  1.00 48.02           C  
ATOM   1272  CE1 PHE   163      46.015  -0.330  46.326  1.00 49.90           C  
ATOM   1273  CE2 PHE   163      45.562   1.973  46.844  1.00 48.71           C  
ATOM   1274  CZ  PHE   163      46.443   0.902  46.813  1.00 49.07           C  
ATOM   1275  N   LEU   164      39.614   1.920  45.728  1.00 57.55           N  
ATOM   1276  CA  LEU   164      38.365   2.263  45.075  1.00 57.26           C  
ATOM   1277  C   LEU   164      38.730   3.412  44.124  1.00 57.53           C  
ATOM   1278  O   LEU   164      39.370   4.387  44.533  1.00 56.25           O  
ATOM   1279  CB  LEU   164      37.349   2.697  46.131  1.00 57.98           C  
ATOM   1280  CG  LEU   164      35.912   2.189  45.989  1.00 59.74           C  
ATOM   1281  CD1 LEU   164      35.844   0.674  46.042  1.00 59.30           C  
ATOM   1282  CD2 LEU   164      35.095   2.751  47.116  1.00 62.37           C  
ATOM   1283  N   LEU   165      38.351   3.285  42.854  1.00 57.37           N  
ATOM   1284  CA  LEU   165      38.675   4.297  41.850  1.00 55.98           C  
ATOM   1285  C   LEU   165      37.434   5.036  41.363  1.00 55.73           C  
ATOM   1286  O   LEU   165      36.470   4.404  40.963  1.00 56.30           O  
ATOM   1287  CB  LEU   165      39.378   3.626  40.653  1.00 54.80           C  
ATOM   1288  CG  LEU   165      39.518   4.427  39.344  1.00 52.01           C  
ATOM   1289  CD1 LEU   165      40.715   5.304  39.447  1.00 50.99           C  
ATOM   1290  CD2 LEU   165      39.648   3.522  38.158  1.00 48.67           C  
ATOM   1291  N   GLU   166      37.469   6.369  41.388  1.00 56.74           N  
ATOM   1292  CA  GLU   166      36.346   7.198  40.921  1.00 58.45           C  
ATOM   1293  C   GLU   166      36.673   7.782  39.546  1.00 57.73           C  
ATOM   1294  O   GLU   166      37.808   8.165  39.281  1.00 57.50           O  
ATOM   1295  CB  GLU   166      36.070   8.357  41.899  1.00 61.94           C  
ATOM   1296  CG  GLU   166      34.696   9.057  41.715  1.00 66.38           C  
ATOM   1297  CD  GLU   166      34.790  10.579  41.505  1.00 70.05           C  
ATOM   1298  OE1 GLU   166      33.887  11.304  41.984  1.00 71.91           O  
ATOM   1299  OE2 GLU   166      35.747  11.063  40.848  1.00 72.07           O  
ATOM   1300  N   VAL   167      35.673   7.868  38.680  1.00 57.94           N  
ATOM   1301  CA  VAL   167      35.885   8.387  37.335  1.00 58.56           C  
ATOM   1302  C   VAL   167      34.695   9.207  36.828  1.00 60.05           C  
ATOM   1303  O   VAL   167      33.565   8.727  36.847  1.00 60.55           O  
ATOM   1304  CB  VAL   167      36.104   7.236  36.323  1.00 57.58           C  
ATOM   1305  CG1 VAL   167      36.498   7.800  34.973  1.00 57.01           C  
ATOM   1306  CG2 VAL   167      37.151   6.277  36.838  1.00 58.12           C  
ATOM   1307  N   ASP   168      34.953  10.435  36.377  1.00 59.99           N  
ATOM   1308  CA  ASP   168      33.906  11.282  35.832  1.00 60.21           C  
ATOM   1309  C   ASP   168      34.446  12.147  34.689  1.00 62.04           C  
ATOM   1310  O   ASP   168      35.305  13.009  34.887  1.00 62.04           O  
ATOM   1311  CB  ASP   168      33.289  12.169  36.918  1.00 60.99           C  
ATOM   1312  CG  ASP   168      31.954  12.776  36.487  1.00 61.77           C  
ATOM   1313  OD1 ASP   168      31.289  12.180  35.623  1.00 61.73           O  
ATOM   1314  OD2 ASP   168      31.555  13.836  37.012  1.00 64.32           O  
ATOM   1315  N   PRO   169      33.954  11.906  33.465  1.00 62.54           N  
ATOM   1316  CA  PRO   169      34.358  12.640  32.267  1.00 62.04           C  
ATOM   1317  C   PRO   169      34.256  14.144  32.449  1.00 62.31           C  
ATOM   1318  O   PRO   169      33.307  14.649  33.057  1.00 60.82           O  
ATOM   1319  CB  PRO   169      33.379  12.142  31.215  1.00 62.41           C  
ATOM   1320  CG  PRO   169      33.167  10.738  31.618  1.00 63.31           C  
ATOM   1321  CD  PRO   169      32.999  10.839  33.120  1.00 62.76           C  
ATOM   1322  N   ALA   170      35.250  14.837  31.903  1.00 62.45           N  
ATOM   1323  CA  ALA   170      35.341  16.285  31.947  1.00 63.07           C  
ATOM   1324  C   ALA   170      36.097  16.741  30.689  1.00 64.66           C  
ATOM   1325  O   ALA   170      36.689  15.924  29.973  1.00 64.85           O  
ATOM   1326  CB  ALA   170      36.084  16.710  33.195  1.00 60.17           C  
ATOM   1327  N   TYR   171      36.066  18.034  30.403  1.00 64.63           N  
ATOM   1328  CA  TYR   171      36.787  18.537  29.245  1.00 66.52           C  
ATOM   1329  C   TYR   171      37.591  19.713  29.740  1.00 67.32           C  
ATOM   1330  O   TYR   171      37.192  20.375  30.693  1.00 69.33           O  
ATOM   1331  CB  TYR   171      35.827  19.018  28.160  1.00 66.79           C  
ATOM   1332  CG  TYR   171      34.923  20.122  28.638  1.00 68.70           C  
ATOM   1333  CD1 TYR   171      33.812  19.838  29.431  1.00 70.55           C  
ATOM   1334  CD2 TYR   171      35.204  21.458  28.354  1.00 68.74           C  
ATOM   1335  CE1 TYR   171      33.002  20.857  29.935  1.00 70.62           C  
ATOM   1336  CE2 TYR   171      34.399  22.489  28.854  1.00 69.66           C  
ATOM   1337  CZ  TYR   171      33.303  22.179  29.645  1.00 69.77           C  
ATOM   1338  OH  TYR   171      32.513  23.173  30.169  1.00 67.58           O  
ATOM   1339  N   ARG   172      38.723  19.979  29.108  1.00 66.90           N  
ATOM   1340  CA  ARG   172      39.522  21.109  29.521  1.00 66.95           C  
ATOM   1341  C   ARG   172      39.938  21.934  28.310  1.00 66.95           C  
ATOM   1342  O   ARG   172      40.433  21.392  27.316  1.00 66.90           O  
ATOM   1343  CB  ARG   172      40.772  20.645  30.268  1.00 67.46           C  
ATOM   1344  CG  ARG   172      41.364  21.719  31.162  1.00 70.04           C  
ATOM   1345  CD  ARG   172      40.433  21.940  32.339  1.00 74.46           C  
ATOM   1346  NE  ARG   172      40.334  23.324  32.784  1.00 76.61           N  
ATOM   1347  CZ  ARG   172      39.466  23.734  33.706  1.00 79.04           C  
ATOM   1348  NH1 ARG   172      38.638  22.855  34.273  1.00 77.36           N  
ATOM   1349  NH2 ARG   172      39.403  25.023  34.046  1.00 79.54           N  
ATOM   1350  N   ILE   173      39.723  23.243  28.390  1.00 65.29           N  
ATOM   1351  CA  ILE   173      40.124  24.129  27.312  1.00 63.66           C  
ATOM   1352  C   ILE   173      41.474  24.704  27.680  1.00 62.98           C  
ATOM   1353  O   ILE   173      41.576  25.455  28.637  1.00 62.68           O  
ATOM   1354  CB  ILE   173      39.162  25.310  27.140  1.00 62.85           C  
ATOM   1355  CG1 ILE   173      37.725  24.814  27.040  1.00 61.85           C  
ATOM   1356  CG2 ILE   173      39.515  26.064  25.875  1.00 62.71           C  
ATOM   1357  CD1 ILE   173      36.719  25.914  26.921  1.00 62.07           C  
ATOM   1358  N   LEU   174      42.508  24.347  26.936  1.00 63.11           N  
ATOM   1359  CA  LEU   174      43.834  24.875  27.208  1.00 65.88           C  
ATOM   1360  C   LEU   174      44.241  26.025  26.270  1.00 67.64           C  
ATOM   1361  O   LEU   174      43.879  26.044  25.098  1.00 67.57           O  
ATOM   1362  CB  LEU   174      44.884  23.771  27.089  1.00 66.60           C  
ATOM   1363  CG  LEU   174      44.896  22.548  28.011  1.00 68.44           C  
ATOM   1364  CD1 LEU   174      46.192  21.798  27.738  1.00 67.09           C  
ATOM   1365  CD2 LEU   174      44.821  22.931  29.487  1.00 67.41           C  
ATOM   1366  N   CYS   175      45.002  26.984  26.786  1.00 69.71           N  
ATOM   1367  CA  CYS   175      45.479  28.083  25.957  1.00 71.26           C  
ATOM   1368  C   CYS   175      46.927  27.756  25.633  1.00 72.34           C  
ATOM   1369  O   CYS   175      47.711  27.487  26.534  1.00 72.52           O  
ATOM   1370  CB  CYS   175      45.416  29.397  26.713  1.00 71.46           C  
ATOM   1371  SG  CYS   175      45.466  30.815  25.626  1.00 75.01           S  
ATOM   1372  N   GLU   176      47.282  27.779  24.354  1.00 74.58           N  
ATOM   1373  CA  GLU   176      48.641  27.449  23.915  1.00 76.40           C  
ATOM   1374  C   GLU   176      49.640  28.604  23.900  1.00 75.71           C  
ATOM   1375  O   GLU   176      50.763  28.438  23.428  1.00 75.54           O  
ATOM   1376  CB  GLU   176      48.603  26.806  22.517  1.00 79.08           C  
ATOM   1377  CG  GLU   176      48.006  25.390  22.486  1.00 84.44           C  
ATOM   1378  CD  GLU   176      48.012  24.747  21.089  1.00 87.05           C  
ATOM   1379  OE1 GLU   176      47.703  23.537  21.000  1.00 87.91           O  
ATOM   1380  OE2 GLU   176      48.314  25.441  20.086  1.00 87.82           O  
ATOM   1381  N   MET   177      49.250  29.761  24.425  1.00 75.11           N  
ATOM   1382  CA  MET   177      50.144  30.912  24.433  1.00 75.61           C  
ATOM   1383  C   MET   177      50.024  31.799  25.686  1.00 74.77           C  
ATOM   1384  O   MET   177      49.167  31.573  26.546  1.00 74.38           O  
ATOM   1385  CB  MET   177      49.889  31.754  23.175  1.00 77.08           C  
ATOM   1386  CG  MET   177      48.444  32.201  23.032  1.00 79.47           C  
ATOM   1387  SD  MET   177      48.165  33.310  21.637  1.00 83.37           S  
ATOM   1388  CE  MET   177      47.304  32.242  20.499  1.00 81.96           C  
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
ATOM   2064  N   THR   266      37.458  29.804  28.952  1.00 78.13           N  
ATOM   2065  CA  THR   266      36.132  29.307  29.265  1.00 81.48           C  
ATOM   2066  C   THR   266      35.394  28.993  27.958  1.00 82.53           C  
ATOM   2067  O   THR   266      35.831  29.405  26.887  1.00 81.51           O  
ATOM   2068  CB  THR   266      35.382  30.392  30.090  1.00 82.69           C  
ATOM   2069  OG1 THR   266      34.736  29.785  31.214  1.00 84.93           O  
ATOM   2070  CG2 THR   266      34.357  31.120  29.241  1.00 83.39           C  
ATOM   2071  N   LEU   267      34.289  28.258  28.034  1.00 85.06           N  
ATOM   2072  CA  LEU   267      33.538  27.930  26.822  1.00 87.81           C  
ATOM   2073  C   LEU   267      33.097  29.220  26.135  1.00 90.40           C  
ATOM   2074  O   LEU   267      33.109  29.312  24.904  1.00 91.23           O  
ATOM   2075  CB  LEU   267      32.328  27.065  27.158  1.00 87.01           C  
ATOM   2076  N   GLU   268      32.720  30.217  26.928  1.00 93.17           N  
ATOM   2077  CA  GLU   268      32.305  31.494  26.368  1.00 96.22           C  
ATOM   2078  C   GLU   268      33.447  32.088  25.529  1.00 98.05           C  
ATOM   2079  O   GLU   268      33.271  32.346  24.335  1.00 98.94           O  
ATOM   2080  CB  GLU   268      31.903  32.467  27.494  1.00 96.56           C  
ATOM   2081  N   ASP   269      34.610  32.290  26.154  1.00 99.11           N  
ATOM   2082  CA  ASP   269      35.787  32.852  25.472  1.00100.45           C  
ATOM   2083  C   ASP   269      35.951  32.333  24.043  1.00101.21           C  
ATOM   2084  O   ASP   269      36.147  33.089  23.102  1.00101.19           O  
ATOM   2085  CB  ASP   269      37.060  32.559  26.279  1.00100.45           C  
ATOM   2086  CG  ASP   269      37.159  33.415  27.523  1.00100.14           C  
ATOM   2087  OD1 ASP   269      37.234  32.856  28.637  1.00 99.05           O  
ATOM   2088  OD2 ASP   269      37.164  34.656  27.381  1.00101.41           O  
ATOM   2089  N   LEU   270      35.856  31.033  23.874  1.00103.10           N  
ATOM   2090  CA  LEU   270      36.046  30.475  22.572  1.00105.14           C  
ATOM   2091  C   LEU   270      34.968  30.775  21.517  1.00107.79           C  
ATOM   2092  O   LEU   270      35.273  31.311  20.415  1.00108.10           O  
ATOM   2093  CB  LEU   270      36.139  28.948  22.655  1.00104.65           C  
ATOM   2094  CG  LEU   270      37.214  28.290  23.550  1.00105.31           C  
ATOM   2095  CD1 LEU   270      37.156  26.751  23.521  1.00105.07           C  
ATOM   2096  CD2 LEU   270      38.575  28.770  23.093  1.00105.27           C  
ATOM   2097  N   HIS   271      33.693  30.552  21.871  1.00110.62           N  
ATOM   2098  CA  HIS   271      32.525  30.463  20.921  1.00112.69           C  
ATOM   2099  C   HIS   271      32.858  29.985  19.531  1.00113.58           C  
ATOM   2100  O   HIS   271      33.267  28.858  19.405  1.00114.13           O  
ATOM   2101  CB  HIS   271      31.416  31.499  20.867  1.00114.37           C  
ATOM   2102  CG  HIS   271      31.840  32.922  20.708  1.00116.56           C  
ATOM   2103  ND1 HIS   271      32.651  33.401  19.696  1.00117.03           N  
ATOM   2104  CD2 HIS   271      31.531  33.990  21.479  1.00116.65           C  
ATOM   2105  CE1 HIS   271      32.840  34.701  19.877  1.00116.92           C  
ATOM   2106  NE2 HIS   271      32.176  35.080  20.954  1.00117.04           N  
ATOM   2107  N   GLU   272      32.549  30.701  18.453  1.00113.08           N  
ATOM   2108  CA  GLU   272      32.826  30.184  17.121  1.00112.43           C  
ATOM   2109  C   GLU   272      31.701  29.314  16.606  1.00112.07           C  
ATOM   2110  O   GLU   272      30.686  29.802  16.077  1.00111.29           O  
ATOM   2111  N   SER   276      27.567  26.867  21.326  1.00113.63           N  
ATOM   2112  CA  SER   276      27.122  25.678  20.605  1.00113.98           C  
ATOM   2113  C   SER   276      28.316  24.928  20.013  1.00113.89           C  
ATOM   2114  O   SER   276      28.318  24.593  18.828  1.00114.79           O  
ATOM   2115  CB  SER   276      26.147  26.076  19.492  1.00113.28           C  
ATOM   2116  N   LEU   277      29.326  24.661  20.839  1.00113.04           N  
ATOM   2117  CA  LEU   277      30.518  23.963  20.371  1.00112.13           C  
ATOM   2118  C   LEU   277      30.589  22.481  20.766  1.00111.68           C  
ATOM   2119  O   LEU   277      31.660  21.965  21.097  1.00111.55           O  
ATOM   2120  CB  LEU   277      31.782  24.705  20.835  1.00111.47           C  
ATOM   2121  CG  LEU   277      32.031  26.077  20.197  0.00111.35           C  
ATOM   2122  CD1 LEU   277      31.017  27.089  20.713  0.00111.16           C  
ATOM   2123  CD2 LEU   277      33.445  26.526  20.523  0.00111.16           C  
ATOM   2124  N   ALA   278      29.439  21.810  20.719  1.00110.83           N  
ATOM   2125  CA  ALA   278      29.321  20.378  21.022  1.00110.30           C  
ATOM   2126  C   ALA   278      29.948  19.886  22.320  1.00109.58           C  
ATOM   2127  O   ALA   278      30.546  18.809  22.346  1.00108.88           O  
ATOM   2128  CB  ALA   278      29.876  19.552  19.850  1.00110.46           C  
ATOM   2129  N   LEU   279      29.805  20.652  23.395  1.00109.00           N  
ATOM   2130  CA  LEU   279      30.370  20.237  24.671  1.00108.24           C  
ATOM   2131  C   LEU   279      29.331  20.179  25.793  1.00107.87           C  
ATOM   2132  O   LEU   279      29.055  21.182  26.460  1.00108.93           O  
ATOM   2133  CB  LEU   279      31.535  21.158  25.072  1.00108.28           C  
ATOM   2134  CG  LEU   279      31.312  22.649  25.343  0.00108.10           C  
ATOM   2135  CD1 LEU   279      32.594  23.251  25.900  0.00108.05           C  
ATOM   2136  CD2 LEU   279      30.896  23.366  24.069  0.00108.05           C  
ATOM   2137  N   SER   280      28.757  18.991  25.979  1.00105.80           N  
ATOM   2138  CA  SER   280      27.755  18.713  27.013  1.00103.96           C  
ATOM   2139  C   SER   280      27.431  17.231  26.867  1.00102.47           C  
ATOM   2140  O   SER   280      27.079  16.778  25.778  1.00102.27           O  
ATOM   2141  CB  SER   280      26.490  19.561  26.811  1.00104.00           C  
ATOM   2142  OG  SER   280      25.823  19.231  25.608  1.00105.38           O  
ATOM   2143  N   LEU   281      27.547  16.471  27.952  1.00100.32           N  
ATOM   2144  CA  LEU   281      27.312  15.037  27.863  1.00 98.40           C  
ATOM   2145  C   LEU   281      25.987  14.504  28.371  1.00 96.59           C  
ATOM   2146  O   LEU   281      25.641  14.662  29.547  1.00 96.47           O  
ATOM   2147  CB  LEU   281      28.435  14.265  28.565  1.00 99.09           C  
ATOM   2148  CG  LEU   281      29.870  14.426  28.069  1.00100.53           C  
ATOM   2149  CD1 LEU   281      30.394  15.823  28.408  1.00101.96           C  
ATOM   2150  CD2 LEU   281      30.733  13.368  28.735  1.00101.63           C  
ATOM   2151  N   PRO   282      25.226  13.848  27.481  1.00 94.24           N  
ATOM   2152  CA  PRO   282      23.941  13.287  27.889  1.00 92.61           C  
ATOM   2153  C   PRO   282      24.257  12.091  28.774  1.00 91.72           C  
ATOM   2154  O   PRO   282      25.284  11.446  28.600  1.00 91.28           O  
ATOM   2155  CB  PRO   282      23.291  12.903  26.558  1.00 92.49           C  
ATOM   2156  CG  PRO   282      24.456  12.596  25.675  1.00 91.76           C  
ATOM   2157  CD  PRO   282      25.454  13.669  26.035  1.00 93.15           C  
ATOM   2158  N   TRP   283      23.382  11.812  29.729  1.00 91.82           N  
ATOM   2159  CA  TRP   283      23.571  10.711  30.665  1.00 91.47           C  
ATOM   2160  C   TRP   283      24.045   9.390  30.051  1.00 88.73           C  
ATOM   2161  O   TRP   283      24.900   8.717  30.619  1.00 87.59           O  
ATOM   2162  CB  TRP   283      22.272  10.513  31.469  1.00 96.12           C  
ATOM   2163  CG  TRP   283      21.971   9.096  31.881  1.00100.96           C  
ATOM   2164  CD1 TRP   283      22.774   8.257  32.598  1.00102.27           C  
ATOM   2165  CD2 TRP   283      20.784   8.351  31.577  1.00102.94           C  
ATOM   2166  NE1 TRP   283      22.163   7.032  32.755  1.00103.93           N  
ATOM   2167  CE2 TRP   283      20.940   7.063  32.139  1.00103.62           C  
ATOM   2168  CE3 TRP   283      19.603   8.648  30.883  1.00104.12           C  
ATOM   2169  CZ2 TRP   283      19.960   6.071  32.028  1.00104.29           C  
ATOM   2170  CZ3 TRP   283      18.626   7.660  30.773  1.00105.43           C  
ATOM   2171  CH2 TRP   283      18.814   6.386  31.344  1.00105.15           C  
ATOM   2172  N   GLU   284      23.504   9.017  28.899  1.00 86.26           N  
ATOM   2173  CA  GLU   284      23.899   7.763  28.266  1.00 83.97           C  
ATOM   2174  C   GLU   284      25.357   7.827  27.799  1.00 80.36           C  
ATOM   2175  O   GLU   284      26.154   6.943  28.106  1.00 78.82           O  
ATOM   2176  CB  GLU   284      22.966   7.450  27.086  1.00 87.06           C  
ATOM   2177  CG  GLU   284      23.218   6.107  26.409  1.00 91.30           C  
ATOM   2178  CD  GLU   284      22.895   4.913  27.303  1.00 94.83           C  
ATOM   2179  OE1 GLU   284      23.423   4.841  28.441  1.00 96.21           O  
ATOM   2180  OE2 GLU   284      22.115   4.039  26.854  1.00 96.02           O  
ATOM   2181  N   GLU   285      25.700   8.880  27.066  1.00 76.86           N  
ATOM   2182  CA  GLU   285      27.062   9.063  26.573  1.00 74.61           C  
ATOM   2183  C   GLU   285      28.061   9.222  27.718  1.00 71.80           C  
ATOM   2184  O   GLU   285      29.205   8.810  27.624  1.00 70.09           O  
ATOM   2185  CB  GLU   285      27.130  10.281  25.663  1.00 75.14           C  
ATOM   2186  N   ARG   286      27.620   9.827  28.803  1.00 70.17           N  
ATOM   2187  CA  ARG   286      28.495  10.028  29.940  1.00 69.41           C  
ATOM   2188  C   ARG   286      28.888   8.721  30.571  1.00 68.08           C  
ATOM   2189  O   ARG   286      30.045   8.504  30.886  1.00 67.01           O  
ATOM   2190  CB  ARG   286      27.811  10.889  31.003  1.00 69.51           C  
ATOM   2191  CG  ARG   286      28.754  11.327  32.094  1.00 69.39           C  
ATOM   2192  CD  ARG   286      28.079  12.197  33.122  1.00 70.70           C  
ATOM   2193  NE  ARG   286      29.080  12.959  33.860  1.00 73.75           N  
ATOM   2194  CZ  ARG   286      29.819  13.932  33.328  1.00 74.85           C  
ATOM   2195  NH1 ARG   286      29.659  14.276  32.055  1.00 73.29           N  
ATOM   2196  NH2 ARG   286      30.757  14.529  34.058  1.00 75.58           N  
ATOM   2197  N   ARG   287      27.898   7.861  30.766  1.00 68.58           N  
ATOM   2198  CA  ARG   287      28.097   6.571  31.400  1.00 68.75           C  
ATOM   2199  C   ARG   287      29.068   5.671  30.648  1.00 67.31           C  
ATOM   2200  O   ARG   287      29.967   5.087  31.249  1.00 66.14           O  
ATOM   2201  CB  ARG   287      26.753   5.853  31.563  1.00 70.69           C  
ATOM   2202  CG  ARG   287      26.885   4.493  32.208  1.00 73.21           C  
ATOM   2203  CD  ARG   287      25.887   3.540  31.613  1.00 76.93           C  
ATOM   2204  NE  ARG   287      24.613   3.605  32.313  1.00 80.48           N  
ATOM   2205  CZ  ARG   287      23.507   2.997  31.903  1.00 80.95           C  
ATOM   2206  NH1 ARG   287      23.516   2.284  30.789  1.00 80.44           N  
ATOM   2207  NH2 ARG   287      22.400   3.084  32.625  1.00 83.02           N  
ATOM   2208  N   ARG   288      28.884   5.550  29.339  1.00 66.04           N  
ATOM   2209  CA  ARG   288      29.764   4.695  28.562  1.00 66.05           C  
ATOM   2210  C   ARG   288      31.187   5.248  28.582  1.00 64.44           C  
ATOM   2211  O   ARG   288      32.153   4.493  28.572  1.00 63.70           O  
ATOM   2212  CB  ARG   288      29.259   4.529  27.109  1.00 66.54           C  
ATOM   2213  CG  ARG   288      29.356   5.747  26.197  1.00 67.75           C  
ATOM   2214  CD  ARG   288      29.127   5.323  24.739  1.00 70.78           C  
ATOM   2215  NE  ARG   288      27.857   4.611  24.558  1.00 73.79           N  
ATOM   2216  CZ  ARG   288      26.690   5.196  24.279  1.00 73.76           C  
ATOM   2217  NH1 ARG   288      26.617   6.515  24.136  1.00 74.79           N  
ATOM   2218  NH2 ARG   288      25.590   4.465  24.159  1.00 71.85           N  
ATOM   2219  N   ARG   289      31.313   6.568  28.631  1.00 63.54           N  
ATOM   2220  CA  ARG   289      32.628   7.189  28.651  1.00 62.32           C  
ATOM   2221  C   ARG   289      33.343   6.981  29.956  1.00 61.76           C  
ATOM   2222  O   ARG   289      34.567   6.910  29.973  1.00 62.62           O  
ATOM   2223  CB  ARG   289      32.547   8.684  28.381  1.00 62.50           C  
ATOM   2224  CG  ARG   289      32.331   9.025  26.944  1.00 64.29           C  
ATOM   2225  CD  ARG   289      32.410  10.514  26.754  1.00 67.34           C  
ATOM   2226  NE  ARG   289      32.089  10.874  25.378  1.00 70.40           N  
ATOM   2227  CZ  ARG   289      32.444  12.019  24.808  1.00 70.25           C  
ATOM   2228  NH1 ARG   289      33.142  12.922  25.500  1.00 70.87           N  
ATOM   2229  NH2 ARG   289      32.095  12.259  23.551  1.00 68.30           N  
ATOM   2230  N   THR   290      32.606   6.891  31.057  1.00 59.53           N  
ATOM   2231  CA  THR   290      33.283   6.684  32.314  1.00 58.33           C  
ATOM   2232  C   THR   290      33.763   5.232  32.409  1.00 57.87           C  
ATOM   2233  O   THR   290      34.775   4.947  33.036  1.00 56.85           O  
ATOM   2234  CB  THR   290      32.403   7.173  33.536  1.00 57.40           C  
ATOM   2235  OG1 THR   290      32.421   6.213  34.595  1.00 56.08           O  
ATOM   2236  CG2 THR   290      30.998   7.462  33.109  1.00 56.36           C  
ATOM   2237  N   ARG   291      33.084   4.325  31.724  1.00 59.12           N  
ATOM   2238  CA  ARG   291      33.500   2.930  31.728  1.00 60.57           C  
ATOM   2239  C   ARG   291      34.683   2.723  30.864  1.00 59.82           C  
ATOM   2240  O   ARG   291      35.525   1.868  31.117  1.00 60.55           O  
ATOM   2241  CB  ARG   291      32.448   2.041  31.156  1.00 62.67           C  
ATOM   2242  CG  ARG   291      31.385   1.854  32.074  1.00 69.24           C  
ATOM   2243  CD  ARG   291      30.767   0.548  31.888  1.00 73.44           C  
ATOM   2244  NE  ARG   291      29.687   0.562  32.833  1.00 78.41           N  
ATOM   2245  CZ  ARG   291      29.336  -0.459  33.592  1.00 81.92           C  
ATOM   2246  NH1 ARG   291      29.988  -1.611  33.509  1.00 82.26           N  
ATOM   2247  NH2 ARG   291      28.342  -0.305  34.460  1.00 82.38           N  
ATOM   2248  N   GLU   292      34.684   3.470  29.785  1.00 57.40           N  
ATOM   2249  CA  GLU   292      35.740   3.390  28.837  1.00 56.82           C  
ATOM   2250  C   GLU   292      37.015   3.963  29.484  1.00 55.16           C  
ATOM   2251  O   GLU   292      38.040   3.275  29.519  1.00 54.83           O  
ATOM   2252  CB  GLU   292      35.321   4.150  27.584  1.00 60.91           C  
ATOM   2253  CG  GLU   292      36.085   3.755  26.350  1.00 66.48           C  
ATOM   2254  CD  GLU   292      35.946   4.784  25.250  1.00 70.14           C  
ATOM   2255  OE1 GLU   292      34.793   5.121  24.894  1.00 72.42           O  
ATOM   2256  OE2 GLU   292      36.986   5.251  24.741  1.00 71.34           O  
ATOM   2257  N   ILE   293      36.968   5.195  30.000  1.00 50.95           N  
ATOM   2258  CA  ILE   293      38.148   5.753  30.672  1.00 48.78           C  
ATOM   2259  C   ILE   293      38.625   4.821  31.795  1.00 49.38           C  
ATOM   2260  O   ILE   293      39.814   4.597  31.943  1.00 50.00           O  
ATOM   2261  CB  ILE   293      37.890   7.093  31.376  1.00 48.19           C  
ATOM   2262  CG1 ILE   293      37.427   8.164  30.389  1.00 47.57           C  
ATOM   2263  CG2 ILE   293      39.166   7.546  32.053  1.00 42.73           C  
ATOM   2264  CD1 ILE   293      38.441   8.492  29.366  1.00 46.54           C  
ATOM   2265  N   ALA   294      37.704   4.293  32.595  1.00 48.50           N  
ATOM   2266  CA  ALA   294      38.093   3.410  33.692  1.00 49.37           C  
ATOM   2267  C   ALA   294      38.888   2.204  33.207  1.00 49.06           C  
ATOM   2268  O   ALA   294      39.860   1.804  33.848  1.00 50.12           O  
ATOM   2269  CB  ALA   294      36.843   2.939  34.506  1.00 49.04           C  
ATOM   2270  N   SER   295      38.462   1.608  32.099  1.00 47.41           N  
ATOM   2271  CA  SER   295      39.177   0.473  31.546  1.00 46.91           C  
ATOM   2272  C   SER   295      40.586   0.914  31.214  1.00 47.78           C  
ATOM   2273  O   SER   295      41.557   0.215  31.499  1.00 45.29           O  
ATOM   2274  CB  SER   295      38.500  -0.017  30.286  1.00 47.12           C  
ATOM   2275  OG  SER   295      37.520  -0.984  30.617  1.00 53.48           O  
ATOM   2276  N   TRP   296      40.669   2.096  30.611  1.00 49.29           N  
ATOM   2277  CA  TRP   296      41.927   2.709  30.241  1.00 51.33           C  
ATOM   2278  C   TRP   296      42.837   2.943  31.446  1.00 51.69           C  
ATOM   2279  O   TRP   296      43.913   2.360  31.535  1.00 51.03           O  
ATOM   2280  CB  TRP   296      41.660   4.041  29.518  1.00 54.07           C  
ATOM   2281  CG  TRP   296      42.764   5.077  29.645  1.00 59.32           C  
ATOM   2282  CD1 TRP   296      42.922   6.013  30.646  1.00 62.64           C  
ATOM   2283  CD2 TRP   296      43.863   5.258  28.763  1.00 60.62           C  
ATOM   2284  NE1 TRP   296      44.055   6.761  30.433  1.00 62.23           N  
ATOM   2285  CE2 TRP   296      44.650   6.317  29.287  1.00 63.06           C  
ATOM   2286  CE3 TRP   296      44.261   4.632  27.587  1.00 62.21           C  
ATOM   2287  CZ2 TRP   296      45.816   6.754  28.663  1.00 65.71           C  
ATOM   2288  CZ3 TRP   296      45.423   5.071  26.962  1.00 66.53           C  
ATOM   2289  CH2 TRP   296      46.189   6.123  27.504  1.00 67.27           C  
ATOM   2290  N   ILE   297      42.411   3.782  32.387  1.00 51.44           N  
ATOM   2291  CA  ILE   297      43.280   4.072  33.505  1.00 52.59           C  
ATOM   2292  C   ILE   297      43.568   2.812  34.255  1.00 52.56           C  
ATOM   2293  O   ILE   297      44.579   2.710  34.916  1.00 54.75           O  
ATOM   2294  CB  ILE   297      42.704   5.160  34.460  1.00 53.37           C  
ATOM   2295  CG1 ILE   297      43.850   5.922  35.121  1.00 56.37           C  
ATOM   2296  CG2 ILE   297      41.983   4.537  35.630  1.00 54.37           C  
ATOM   2297  CD1 ILE   297      44.784   6.644  34.151  1.00 58.49           C  
ATOM   2298  N   GLY   298      42.687   1.836  34.137  1.00 53.37           N  
ATOM   2299  CA  GLY   298      42.905   0.584  34.831  1.00 54.13           C  
ATOM   2300  C   GLY   298      44.129  -0.161  34.322  1.00 55.78           C  
ATOM   2301  O   GLY   298      44.889  -0.713  35.113  1.00 56.14           O  
ATOM   2302  N   ARG   299      44.351  -0.184  33.011  1.00 56.49           N  
ATOM   2303  CA  ARG   299      45.499  -0.916  32.527  1.00 57.25           C  
ATOM   2304  C   ARG   299      46.753  -0.214  32.970  1.00 56.85           C  
ATOM   2305  O   ARG   299      47.729  -0.850  33.321  1.00 58.47           O  
ATOM   2306  CB  ARG   299      45.506  -1.066  31.002  1.00 58.73           C  
ATOM   2307  CG  ARG   299      46.268  -2.329  30.586  1.00 60.46           C  
ATOM   2308  CD  ARG   299      47.151  -2.150  29.378  1.00 63.73           C  
ATOM   2309  NE  ARG   299      46.482  -2.423  28.107  1.00 67.08           N  
ATOM   2310  CZ  ARG   299      45.789  -3.530  27.834  1.00 68.40           C  
ATOM   2311  NH1 ARG   299      45.653  -4.485  28.746  1.00 67.18           N  
ATOM   2312  NH2 ARG   299      45.253  -3.693  26.630  1.00 69.98           N  
ATOM   2313  N   ARG   300      46.717   1.105  32.979  1.00 56.74           N  
ATOM   2314  CA  ARG   300      47.865   1.891  33.389  1.00 56.46           C  
ATOM   2315  C   ARG   300      48.090   1.946  34.900  1.00 57.53           C  
ATOM   2316  O   ARG   300      49.160   2.339  35.356  1.00 59.87           O  
ATOM   2317  CB  ARG   300      47.730   3.293  32.809  1.00 55.09           C  
ATOM   2318  CG  ARG   300      47.955   3.281  31.310  1.00 58.90           C  
ATOM   2319  CD  ARG   300      47.009   4.184  30.518  1.00 61.61           C  
ATOM   2320  NE  ARG   300      47.162   3.913  29.091  1.00 63.08           N  
ATOM   2321  CZ  ARG   300      46.685   2.834  28.469  1.00 65.60           C  
ATOM   2322  NH1 ARG   300      46.001   1.912  29.131  1.00 67.13           N  
ATOM   2323  NH2 ARG   300      46.925   2.654  27.175  1.00 67.61           N  
ATOM   2324  N   LEU   301      47.105   1.528  35.681  1.00 57.46           N  
ATOM   2325  CA  LEU   301      47.239   1.565  37.124  1.00 59.08           C  
ATOM   2326  C   LEU   301      47.855   0.318  37.759  1.00 60.41           C  
ATOM   2327  O   LEU   301      48.461   0.406  38.825  1.00 60.51           O  
ATOM   2328  CB  LEU   301      45.879   1.813  37.765  1.00 61.05           C  
ATOM   2329  CG  LEU   301      45.667   3.121  38.528  1.00 61.22           C  
ATOM   2330  CD1 LEU   301      44.390   3.024  39.369  1.00 60.58           C  
ATOM   2331  CD2 LEU   301      46.852   3.381  39.418  1.00 60.26           C  
ATOM   2332  N   GLY   302      47.674  -0.839  37.131  1.00 61.31           N  
ATOM   2333  CA  GLY   302      48.230  -2.071  37.673  1.00 63.15           C  
ATOM   2334  C   GLY   302      47.728  -2.487  39.055  1.00 64.27           C  
ATOM   2335  O   GLY   302      48.470  -3.092  39.838  1.00 64.94           O  
ATOM   2336  N   LEU   303      46.471  -2.175  39.355  1.00 63.34           N  
ATOM   2337  CA  LEU   303      45.880  -2.518  40.639  1.00 62.86           C  
ATOM   2338  C   LEU   303      44.657  -3.411  40.411  1.00 63.13           C  
ATOM   2339  O   LEU   303      43.629  -3.279  41.084  1.00 63.03           O  
ATOM   2340  CB  LEU   303      45.480  -1.233  41.378  1.00 63.36           C  
ATOM   2341  CG  LEU   303      46.483  -0.496  42.284  1.00 63.68           C  
ATOM   2342  CD1 LEU   303      47.911  -0.759  41.860  1.00 64.24           C  
ATOM   2343  CD2 LEU   303      46.178   0.995  42.249  1.00 61.54           C  
ATOM   2344  N   GLY   304      44.774  -4.321  39.451  1.00 62.71           N  
ATOM   2345  CA  GLY   304      43.671  -5.208  39.147  1.00 61.55           C  
ATOM   2346  C   GLY   304      42.687  -4.553  38.204  1.00 62.77           C  
ATOM   2347  O   GLY   304      42.790  -3.370  37.888  1.00 64.41           O  
ATOM   2348  N   THR   305      41.712  -5.328  37.757  1.00 64.20           N  
ATOM   2349  CA  THR   305      40.703  -4.838  36.831  1.00 65.30           C  
ATOM   2350  C   THR   305      39.565  -4.091  37.526  1.00 66.49           C  
ATOM   2351  O   THR   305      39.062  -4.500  38.569  1.00 66.29           O  
ATOM   2352  CB  THR   305      40.105  -6.009  36.014  1.00 64.90           C  
ATOM   2353  OG1 THR   305      41.168  -6.769  35.439  1.00 65.27           O  
ATOM   2354  CG2 THR   305      39.212  -5.494  34.891  1.00 64.35           C  
ATOM   2355  N   PRO   306      39.153  -2.969  36.948  1.00 67.33           N  
ATOM   2356  CA  PRO   306      38.065  -2.192  37.538  1.00 68.13           C  
ATOM   2357  C   PRO   306      36.710  -2.883  37.440  1.00 67.91           C  
ATOM   2358  O   PRO   306      36.226  -3.131  36.344  1.00 68.25           O  
ATOM   2359  CB  PRO   306      38.107  -0.903  36.729  1.00 68.19           C  
ATOM   2360  CG  PRO   306      39.556  -0.756  36.446  1.00 67.64           C  
ATOM   2361  CD  PRO   306      39.934  -2.145  36.017  1.00 66.54           C  
ATOM   2362  N   GLU   307      36.106  -3.202  38.580  1.00 68.87           N  
ATOM   2363  CA  GLU   307      34.777  -3.822  38.589  1.00 69.87           C  
ATOM   2364  C   GLU   307      33.797  -2.751  39.058  1.00 69.54           C  
ATOM   2365  O   GLU   307      33.794  -2.367  40.226  1.00 69.63           O  
ATOM   2366  CB  GLU   307      34.707  -5.021  39.548  1.00 71.42           C  
ATOM   2367  CG  GLU   307      35.481  -6.278  39.132  1.00 74.98           C  
ATOM   2368  CD  GLU   307      35.079  -6.810  37.757  1.00 77.74           C  
ATOM   2369  OE1 GLU   307      33.986  -6.438  37.262  1.00 79.56           O  
ATOM   2370  OE2 GLU   307      35.855  -7.609  37.174  1.00 77.49           O  
ATOM   2371  N   ALA   308      32.978  -2.257  38.140  1.00 69.22           N  
ATOM   2372  CA  ALA   308      32.011  -1.221  38.475  1.00 70.10           C  
ATOM   2373  C   ALA   308      31.255  -1.558  39.748  1.00 69.75           C  
ATOM   2374  O   ALA   308      30.737  -2.656  39.898  1.00 70.62           O  
ATOM   2375  CB  ALA   308      31.027  -1.028  37.312  1.00 70.49           C  
ATOM   2376  N   VAL   309      31.195  -0.616  40.675  1.00 70.65           N  
ATOM   2377  CA  VAL   309      30.477  -0.869  41.912  1.00 71.44           C  
ATOM   2378  C   VAL   309      29.007  -0.610  41.756  1.00 72.10           C  
ATOM   2379  O   VAL   309      28.593   0.422  41.247  1.00 72.02           O  
ATOM   2380  CB  VAL   309      30.960  -0.003  43.055  1.00 70.93           C  
ATOM   2381  CG1 VAL   309      29.954  -0.070  44.206  1.00 70.23           C  
ATOM   2382  CG2 VAL   309      32.315  -0.492  43.508  1.00 69.44           C  
ATOM   2383  N   ARG   310      28.209  -1.556  42.212  1.00 73.62           N  
ATOM   2384  CA  ARG   310      26.782  -1.387  42.107  1.00 74.10           C  
ATOM   2385  C   ARG   310      26.201  -1.425  43.500  1.00 73.87           C  
ATOM   2386  O   ARG   310      26.722  -2.098  44.404  1.00 72.94           O  
ATOM   2387  CB  ARG   310      26.203  -2.489  41.290  1.00 74.85           C  
ATOM   2388  CG  ARG   310      26.276  -3.764  42.004  1.00 76.05           C  
ATOM   2389  CD  ARG   310      25.610  -4.750  41.159  1.00 78.99           C  
ATOM   2390  NE  ARG   310      26.530  -5.166  40.116  1.00 82.02           N  
ATOM   2391  CZ  ARG   310      26.175  -5.483  38.878  1.00 82.09           C  
ATOM   2392  NH1 ARG   310      24.900  -5.419  38.509  1.00 80.59           N  
ATOM   2393  NH2 ARG   310      27.101  -5.895  38.020  1.00 81.60           N  
ATOM   2394  N   ALA   311      25.105  -0.709  43.673  1.00 73.37           N  
ATOM   2395  CA  ALA   311      24.533  -0.634  44.995  1.00 73.62           C  
ATOM   2396  C   ALA   311      23.030  -0.634  45.066  1.00 72.34           C  
ATOM   2397  O   ALA   311      22.324  -0.431  44.079  1.00 69.53           O  
ATOM   2398  CB  ALA   311      25.084   0.594  45.712  1.00 74.22           C  
ATOM   2399  N   GLN   312      22.552  -0.874  46.274  1.00 73.69           N  
ATOM   2400  CA  GLN   312      21.130  -0.897  46.518  1.00 76.13           C  
ATOM   2401  C   GLN   312      20.688   0.518  46.872  1.00 75.73           C  
ATOM   2402  O   GLN   312      21.188   1.131  47.816  1.00 75.52           O  
ATOM   2403  CB  GLN   312      20.793  -1.900  47.636  1.00 77.68           C  
ATOM   2404  CG  GLN   312      22.000  -2.409  48.421  1.00 82.12           C  
ATOM   2405  CD  GLN   312      22.529  -1.396  49.428  1.00 85.92           C  
ATOM   2406  OE1 GLN   312      22.237  -1.485  50.630  1.00 87.52           O  
ATOM   2407  NE2 GLN   312      23.300  -0.418  48.943  1.00 85.97           N  
ATOM   2408  N   ALA   313      19.770   1.035  46.068  1.00 75.18           N  
ATOM   2409  CA  ALA   313      19.235   2.366  46.255  1.00 75.28           C  
ATOM   2410  C   ALA   313      17.768   2.284  46.666  1.00 75.23           C  
ATOM   2411  O   ALA   313      16.908   1.934  45.856  1.00 74.23           O  
ATOM   2412  CB  ALA   313      19.375   3.159  44.967  1.00 75.77           C  
ATOM   2413  N   TYR   314      17.499   2.613  47.929  1.00 75.56           N  
ATOM   2414  CA  TYR   314      16.149   2.595  48.488  1.00 75.55           C  
ATOM   2415  C   TYR   314      15.419   3.883  48.282  1.00 74.76           C  
ATOM   2416  O   TYR   314      15.954   4.968  48.495  1.00 74.85           O  
ATOM   2417  CB  TYR   314      16.179   2.375  49.978  1.00 76.97           C  
ATOM   2418  CG  TYR   314      16.938   1.168  50.371  1.00 79.66           C  
ATOM   2419  CD1 TYR   314      16.291  -0.037  50.613  1.00 80.27           C  
ATOM   2420  CD2 TYR   314      18.314   1.225  50.509  1.00 80.84           C  
ATOM   2421  CE1 TYR   314      17.006  -1.159  50.991  1.00 81.85           C  
ATOM   2422  CE2 TYR   314      19.038   0.116  50.880  1.00 82.23           C  
ATOM   2423  CZ  TYR   314      18.383  -1.070  51.123  1.00 82.34           C  
ATOM   2424  OH  TYR   314      19.117  -2.157  51.512  1.00 84.14           O  
ATOM   2425  N   ARG   315      14.161   3.747  47.920  1.00 74.63           N  
ATOM   2426  CA  ARG   315      13.322   4.896  47.704  1.00 75.28           C  
ATOM   2427  C   ARG   315      12.631   5.315  48.990  1.00 73.87           C  
ATOM   2428  O   ARG   315      11.697   4.660  49.418  1.00 73.32           O  
ATOM   2429  CB  ARG   315      12.279   4.554  46.692  1.00 77.06           C  
ATOM   2430  CG  ARG   315      11.474   5.726  46.399  1.00 79.66           C  
ATOM   2431  CD  ARG   315      11.018   5.577  45.041  1.00 83.22           C  
ATOM   2432  NE  ARG   315       9.782   4.829  45.037  1.00 87.80           N  
ATOM   2433  CZ  ARG   315       9.319   4.185  43.980  1.00 89.91           C  
ATOM   2434  NH1 ARG   315      10.009   4.190  42.846  1.00 91.11           N  
ATOM   2435  NH2 ARG   315       8.149   3.573  44.048  1.00 90.31           N  
ATOM   2436  N   LEU   316      13.062   6.415  49.590  1.00 73.39           N  
ATOM   2437  CA  LEU   316      12.480   6.855  50.857  1.00 73.13           C  
ATOM   2438  C   LEU   316      10.988   7.206  50.835  1.00 72.10           C  
ATOM   2439  O   LEU   316      10.474   7.747  49.853  1.00 71.20           O  
ATOM   2440  CB  LEU   316      13.281   8.040  51.399  1.00 72.76           C  
ATOM   2441  CG  LEU   316      14.747   7.758  51.739  1.00 72.22           C  
ATOM   2442  CD1 LEU   316      15.495   9.065  51.898  1.00 70.89           C  
ATOM   2443  CD2 LEU   316      14.845   6.924  52.997  1.00 70.91           C  
ATOM   2444  N   SER   317      10.299   6.901  51.930  1.00 72.05           N  
ATOM   2445  CA  SER   317       8.876   7.205  52.027  1.00 73.18           C  
ATOM   2446  C   SER   317       8.623   8.710  51.941  1.00 73.42           C  
ATOM   2447  O   SER   317       9.277   9.512  52.608  1.00 72.85           O  
ATOM   2448  CB  SER   317       8.270   6.636  53.328  1.00 72.42           C  
ATOM   2449  OG  SER   317       8.847   7.196  54.491  1.00 72.42           O  
ATOM   2450  N   ILE   318       7.674   9.068  51.083  1.00 75.17           N  
ATOM   2451  CA  ILE   318       7.266  10.447  50.853  1.00 76.64           C  
ATOM   2452  C   ILE   318       6.534  10.963  52.093  1.00 76.34           C  
ATOM   2453  O   ILE   318       5.683  10.281  52.656  1.00 76.86           O  
ATOM   2454  CB  ILE   318       6.352  10.509  49.611  1.00 78.09           C  
ATOM   2455  CG1 ILE   318       7.160  10.092  48.375  1.00 79.57           C  
ATOM   2456  CG2 ILE   318       5.768  11.897  49.445  1.00 76.73           C  
ATOM   2457  CD1 ILE   318       6.323   9.856  47.120  1.00 81.63           C  
ATOM   2458  N   PRO   319       6.865  12.183  52.536  1.00 76.40           N  
ATOM   2459  CA  PRO   319       6.267  12.823  53.720  1.00 76.49           C  
ATOM   2460  C   PRO   319       4.781  13.233  53.662  1.00 75.57           C  
ATOM   2461  O   PRO   319       4.320  13.839  52.690  1.00 74.41           O  
ATOM   2462  CB  PRO   319       7.186  14.023  53.949  1.00 75.91           C  
ATOM   2463  CG  PRO   319       7.553  14.418  52.548  1.00 75.48           C  
ATOM   2464  CD  PRO   319       7.837  13.082  51.885  1.00 76.26           C  
ATOM   2465  N   LYS   320       4.042  12.891  54.714  1.00 75.02           N  
ATOM   2466  CA  LYS   320       2.638  13.259  54.798  1.00 74.69           C  
ATOM   2467  C   LYS   320       2.621  14.736  55.159  1.00 74.67           C  
ATOM   2468  O   LYS   320       2.709  15.105  56.328  1.00 74.28           O  
ATOM   2469  CB  LYS   320       1.932  12.449  55.874  1.00 73.82           C  
ATOM   2470  N   LEU   321       2.544  15.569  54.132  1.00 75.17           N  
ATOM   2471  CA  LEU   321       2.518  17.013  54.281  1.00 76.56           C  
ATOM   2472  C   LEU   321       1.089  17.463  54.459  1.00 78.23           C  
ATOM   2473  O   LEU   321       0.190  16.965  53.781  1.00 79.23           O  
ATOM   2474  CB  LEU   321       3.052  17.688  53.022  1.00 75.87           C  
ATOM   2475  CG  LEU   321       4.509  18.104  52.880  1.00 76.18           C  
ATOM   2476  CD1 LEU   321       5.429  16.953  53.216  1.00 76.87           C  
ATOM   2477  CD2 LEU   321       4.735  18.580  51.453  1.00 75.72           C  
ATOM   2478  N   MET   322       0.866  18.408  55.358  1.00 79.65           N  
ATOM   2479  CA  MET   322      -0.482  18.908  55.537  1.00 81.28           C  
ATOM   2480  C   MET   322      -0.584  20.268  56.194  1.00 78.82           C  
ATOM   2481  O   MET   322      -0.027  20.503  57.261  1.00 76.72           O  
ATOM   2482  CB  MET   322      -1.334  17.905  56.308  1.00 85.67           C  
ATOM   2483  CG  MET   322      -0.895  17.647  57.725  1.00 90.88           C  
ATOM   2484  SD  MET   322      -2.240  16.800  58.586  1.00 98.69           S  
ATOM   2485  CE  MET   322      -2.381  15.260  57.570  1.00 96.37           C  
ATOM   2486  N   GLY   323      -1.295  21.159  55.514  1.00 77.51           N  
ATOM   2487  CA  GLY   323      -1.525  22.499  56.020  1.00 77.01           C  
ATOM   2488  C   GLY   323      -2.858  22.439  56.735  1.00 75.76           C  
ATOM   2489  O   GLY   323      -3.016  21.619  57.629  1.00 74.22           O  
ATOM   2490  N   ARG   324      -3.817  23.278  56.344  1.00 76.29           N  
ATOM   2491  CA  ARG   324      -5.133  23.244  56.970  1.00 76.56           C  
ATOM   2492  C   ARG   324      -5.740  21.866  56.714  1.00 77.94           C  
ATOM   2493  O   ARG   324      -6.434  21.318  57.561  1.00 77.88           O  
ATOM   2494  CB  ARG   324      -6.037  24.331  56.420  1.00 75.07           C  
ATOM   2495  CG  ARG   324      -7.306  24.476  57.209  1.00 72.49           C  
ATOM   2496  CD  ARG   324      -7.929  25.815  56.969  1.00 71.41           C  
ATOM   2497  NE  ARG   324      -9.012  26.048  57.905  1.00 69.72           N  
ATOM   2498  CZ  ARG   324      -9.626  27.212  58.060  1.00 69.49           C  
ATOM   2499  NH1 ARG   324      -9.266  28.264  57.336  1.00 68.09           N  
ATOM   2500  NH2 ARG   324     -10.592  27.323  58.956  1.00 69.88           N  
ATOM   2501  N   ARG   325      -5.486  21.307  55.536  1.00 80.31           N  
ATOM   2502  CA  ARG   325      -5.921  19.952  55.201  1.00 83.03           C  
ATOM   2503  C   ARG   325      -4.787  19.299  54.425  1.00 83.42           C  
ATOM   2504  O   ARG   325      -3.901  19.997  53.932  1.00 83.67           O  
ATOM   2505  CB  ARG   325      -7.200  19.946  54.350  1.00 84.59           C  
ATOM   2506  CG  ARG   325      -7.142  20.755  53.100  1.00 85.86           C  
ATOM   2507  CD  ARG   325      -8.465  20.554  52.422  1.00 87.95           C  
ATOM   2508  NE  ARG   325      -8.730  21.537  51.397  1.00 91.35           N  
ATOM   2509  CZ  ARG   325      -8.532  21.361  50.099  1.00 93.28           C  
ATOM   2510  NH1 ARG   325      -8.052  20.208  49.637  1.00 94.64           N  
ATOM   2511  NH2 ARG   325      -8.831  22.360  49.268  1.00 94.28           N  
ATOM   2512  N   ALA   326      -4.820  17.968  54.319  1.00 83.71           N  
ATOM   2513  CA  ALA   326      -3.778  17.239  53.581  1.00 83.29           C  
ATOM   2514  C   ALA   326      -3.311  17.993  52.313  1.00 82.66           C  
ATOM   2515  O   ALA   326      -4.100  18.666  51.647  1.00 81.68           O  
ATOM   2516  CB  ALA   326      -4.252  15.841  53.207  1.00 83.45           C  
ATOM   2517  N   VAL   327      -2.027  17.867  51.980  1.00 82.72           N  
ATOM   2518  CA  VAL   327      -1.460  18.556  50.822  1.00 83.20           C  
ATOM   2519  C   VAL   327      -0.366  17.737  50.128  1.00 83.72           C  
ATOM   2520  O   VAL   327       0.341  16.953  50.764  1.00 83.40           O  
ATOM   2521  CB  VAL   327      -0.872  19.922  51.258  1.00 83.36           C  
ATOM   2522  CG1 VAL   327      -0.036  20.521  50.156  1.00 83.27           C  
ATOM   2523  CG2 VAL   327      -1.994  20.873  51.620  1.00 84.19           C  
ATOM   2524  N   SER   328      -0.233  17.929  48.821  1.00 83.97           N  
ATOM   2525  CA  SER   328       0.771  17.228  48.045  1.00 84.91           C  
ATOM   2526  C   SER   328       2.097  17.981  48.107  1.00 85.65           C  
ATOM   2527  O   SER   328       3.171  17.402  47.935  1.00 85.53           O  
ATOM   2528  CB  SER   328       0.301  17.095  46.599  1.00 84.91           C  
ATOM   2529  OG  SER   328       1.401  17.009  45.710  1.00 86.91           O  
ATOM   2530  N   LYS   329       2.023  19.283  48.347  1.00 86.24           N  
ATOM   2531  CA  LYS   329       3.237  20.063  48.446  1.00 86.83           C  
ATOM   2532  C   LYS   329       3.124  21.362  49.205  1.00 86.35           C  
ATOM   2533  O   LYS   329       2.105  22.052  49.174  1.00 86.11           O  
ATOM   2534  CB  LYS   329       3.810  20.353  47.086  1.00 87.59           C  
ATOM   2535  CG  LYS   329       3.021  19.841  45.927  1.00 89.31           C  
ATOM   2536  CD  LYS   329       2.947  20.916  44.871  1.00 90.93           C  
ATOM   2537  CE  LYS   329       3.957  22.034  45.133  1.00 90.94           C  
ATOM   2538  NZ  LYS   329       5.330  21.519  45.427  1.00 92.30           N  
ATOM   2539  N   PRO   330       4.220  21.745  49.855  1.00 85.48           N  
ATOM   2540  CA  PRO   330       4.249  22.967  50.641  1.00 84.14           C  
ATOM   2541  C   PRO   330       3.553  24.168  50.022  1.00 82.55           C  
ATOM   2542  O   PRO   330       2.716  24.777  50.677  1.00 82.62           O  
ATOM   2543  CB  PRO   330       5.738  23.175  50.875  1.00 84.95           C  
ATOM   2544  CG  PRO   330       6.245  21.754  50.946  1.00 85.65           C  
ATOM   2545  CD  PRO   330       5.576  21.184  49.732  1.00 85.80           C  
ATOM   2546  N   ALA   331       3.852  24.505  48.772  1.00 80.28           N  
ATOM   2547  CA  ALA   331       3.209  25.674  48.183  1.00 78.76           C  
ATOM   2548  C   ALA   331       1.684  25.571  48.081  1.00 78.45           C  
ATOM   2549  O   ALA   331       0.999  26.580  47.873  1.00 78.42           O  
ATOM   2550  CB  ALA   331       3.800  25.963  46.829  1.00 78.23           C  
ATOM   2551  N   ASP   332       1.146  24.365  48.242  1.00 77.36           N  
ATOM   2552  CA  ASP   332      -0.298  24.186  48.148  1.00 75.44           C  
ATOM   2553  C   ASP   332      -1.019  24.803  49.328  1.00 74.34           C  
ATOM   2554  O   ASP   332      -2.213  25.116  49.243  1.00 74.41           O  
ATOM   2555  CB  ASP   332      -0.653  22.702  48.034  1.00 74.57           C  
ATOM   2556  CG  ASP   332      -0.469  22.162  46.622  1.00 75.05           C  
ATOM   2557  OD1 ASP   332      -0.159  22.970  45.707  1.00 73.23           O  
ATOM   2558  OD2 ASP   332      -0.645  20.933  46.431  1.00 73.69           O  
ATOM   2559  N   ALA   333      -0.289  24.983  50.424  1.00 72.21           N  
ATOM   2560  CA  ALA   333      -0.862  25.572  51.621  1.00 71.76           C  
ATOM   2561  C   ALA   333      -1.219  27.033  51.378  1.00 70.41           C  
ATOM   2562  O   ALA   333      -2.051  27.615  52.076  1.00 69.75           O  
ATOM   2563  CB  ALA   333       0.114  25.461  52.762  1.00 73.24           C  
ATOM   2564  N   LEU   334      -0.576  27.618  50.379  1.00 68.45           N  
ATOM   2565  CA  LEU   334      -0.824  28.996  50.024  1.00 67.50           C  
ATOM   2566  C   LEU   334      -2.237  29.187  49.540  1.00 67.37           C  
ATOM   2567  O   LEU   334      -2.750  30.298  49.530  1.00 69.17           O  
ATOM   2568  CB  LEU   334       0.107  29.427  48.896  1.00 66.53           C  
ATOM   2569  CG  LEU   334       1.557  29.702  49.266  1.00 65.00           C  
ATOM   2570  CD1 LEU   334       2.364  29.994  48.013  1.00 61.76           C  
ATOM   2571  CD2 LEU   334       1.586  30.876  50.223  1.00 64.01           C  
ATOM   2572  N   ARG   335      -2.875  28.107  49.124  1.00 66.58           N  
ATOM   2573  CA  ARG   335      -4.210  28.243  48.588  1.00 64.78           C  
ATOM   2574  C   ARG   335      -5.225  27.398  49.319  1.00 64.81           C  
ATOM   2575  O   ARG   335      -6.430  27.566  49.159  1.00 64.78           O  
ATOM   2576  CB  ARG   335      -4.192  27.905  47.128  1.00 62.96           C  
ATOM   2577  N   VAL   336      -4.737  26.477  50.124  1.00 64.46           N  
ATOM   2578  CA  VAL   336      -5.622  25.653  50.891  1.00 64.79           C  
ATOM   2579  C   VAL   336      -5.602  26.124  52.346  1.00 66.07           C  
ATOM   2580  O   VAL   336      -6.460  25.745  53.143  1.00 66.01           O  
ATOM   2581  CB  VAL   336      -5.197  24.194  50.775  1.00 65.47           C  
ATOM   2582  CG1 VAL   336      -5.638  23.411  52.002  1.00 66.52           C  
ATOM   2583  CG2 VAL   336      -5.799  23.604  49.519  1.00 64.80           C  
ATOM   2584  N   GLY   337      -4.621  26.961  52.686  1.00 66.62           N  
ATOM   2585  CA  GLY   337      -4.520  27.473  54.044  1.00 65.36           C  
ATOM   2586  C   GLY   337      -3.439  26.816  54.888  1.00 64.29           C  
ATOM   2587  O   GLY   337      -3.198  25.612  54.786  1.00 64.43           O  
ATOM   2588  N   PHE   338      -2.809  27.604  55.749  1.00 62.48           N  
ATOM   2589  CA  PHE   338      -1.731  27.112  56.587  1.00 61.70           C  
ATOM   2590  C   PHE   338      -2.143  26.124  57.659  1.00 62.63           C  
ATOM   2591  O   PHE   338      -3.282  26.112  58.110  1.00 62.38           O  
ATOM   2592  CB  PHE   338      -1.028  28.284  57.237  1.00 60.40           C  
ATOM   2593  CG  PHE   338      -0.640  29.349  56.267  1.00 60.55           C  
ATOM   2594  CD1 PHE   338      -0.650  30.684  56.638  1.00 59.19           C  
ATOM   2595  CD2 PHE   338      -0.289  29.022  54.968  1.00 59.51           C  
ATOM   2596  CE1 PHE   338      -0.324  31.667  55.727  1.00 58.74           C  
ATOM   2597  CE2 PHE   338       0.040  30.005  54.056  1.00 58.01           C  
ATOM   2598  CZ  PHE   338       0.020  31.324  54.433  1.00 57.93           C  
ATOM   2599  N   TYR   339      -1.181  25.300  58.064  1.00 62.84           N  
ATOM   2600  CA  TYR   339      -1.387  24.304  59.103  1.00 62.87           C  
ATOM   2601  C   TYR   339      -1.874  24.943  60.403  1.00 63.24           C  
ATOM   2602  O   TYR   339      -2.826  24.471  61.006  1.00 62.89           O  
ATOM   2603  CB  TYR   339      -0.087  23.560  59.377  1.00 61.85           C  
ATOM   2604  CG  TYR   339      -0.212  22.537  60.464  1.00 60.92           C  
ATOM   2605  CD1 TYR   339      -0.963  21.392  60.270  1.00 61.61           C  
ATOM   2606  CD2 TYR   339       0.411  22.719  61.698  1.00 62.51           C  
ATOM   2607  CE1 TYR   339      -1.102  20.444  61.275  1.00 63.04           C  
ATOM   2608  CE2 TYR   339       0.283  21.778  62.712  1.00 62.88           C  
ATOM   2609  CZ  TYR   339      -0.481  20.642  62.489  1.00 63.39           C  
ATOM   2610  OH  TYR   339      -0.652  19.706  63.480  1.00 66.50           O  
ATOM   2611  N   ARG   340      -1.197  25.997  60.845  1.00 64.30           N  
ATOM   2612  CA  ARG   340      -1.583  26.685  62.071  1.00 66.36           C  
ATOM   2613  C   ARG   340      -1.273  28.167  61.950  1.00 66.52           C  
ATOM   2614  O   ARG   340      -0.112  28.559  62.007  1.00 67.27           O  
ATOM   2615  CB  ARG   340      -0.845  26.126  63.287  1.00 66.95           C  
ATOM   2616  CG  ARG   340      -1.298  26.826  64.529  1.00 71.43           C  
ATOM   2617  CD  ARG   340      -0.500  26.520  65.760  1.00 76.04           C  
ATOM   2618  NE  ARG   340      -0.982  27.383  66.835  1.00 81.26           N  
ATOM   2619  CZ  ARG   340      -0.518  27.372  68.079  1.00 83.99           C  
ATOM   2620  NH1 ARG   340       0.455  26.537  68.425  1.00 85.05           N  
ATOM   2621  NH2 ARG   340      -1.035  28.194  68.981  1.00 85.76           N  
ATOM   2622  N   ALA   341      -2.315  28.989  61.819  1.00 66.67           N  
ATOM   2623  CA  ALA   341      -2.146  30.433  61.644  1.00 65.57           C  
ATOM   2624  C   ALA   341      -2.135  31.319  62.895  1.00 65.62           C  
ATOM   2625  O   ALA   341      -2.280  30.852  64.032  1.00 65.57           O  
ATOM   2626  CB  ALA   341      -3.178  30.947  60.657  1.00 65.25           C  
ATOM   2627  N   GLN   342      -1.968  32.616  62.659  1.00 65.20           N  
ATOM   2628  CA  GLN   342      -1.876  33.610  63.722  1.00 64.89           C  
ATOM   2629  C   GLN   342      -1.941  34.975  63.068  1.00 63.30           C  
ATOM   2630  O   GLN   342      -1.803  35.091  61.853  1.00 61.88           O  
ATOM   2631  CB  GLN   342      -0.521  33.481  64.428  1.00 67.97           C  
ATOM   2632  CG  GLN   342       0.647  33.354  63.433  1.00 70.81           C  
ATOM   2633  CD  GLN   342       1.999  33.825  63.968  1.00 74.50           C  
ATOM   2634  OE1 GLN   342       2.528  33.286  64.954  1.00 76.38           O  
ATOM   2635  NE2 GLN   342       2.574  34.834  63.302  1.00 74.60           N  
ATOM   2636  N   GLU   343      -2.148  36.012  63.872  1.00 62.50           N  
ATOM   2637  CA  GLU   343      -2.179  37.373  63.339  1.00 61.34           C  
ATOM   2638  C   GLU   343      -0.776  37.547  62.772  1.00 59.29           C  
ATOM   2639  O   GLU   343       0.200  37.224  63.437  1.00 58.93           O  
ATOM   2640  CB  GLU   343      -2.417  38.366  64.471  1.00 62.57           C  
ATOM   2641  CG  GLU   343      -2.841  39.735  64.019  1.00 64.18           C  
ATOM   2642  CD  GLU   343      -3.261  40.597  65.192  1.00 65.96           C  
ATOM   2643  OE1 GLU   343      -3.604  40.012  66.248  1.00 66.64           O  
ATOM   2644  OE2 GLU   343      -3.265  41.847  65.055  1.00 66.30           O  
ATOM   2645  N   THR   344      -0.664  38.051  61.554  1.00 56.61           N  
ATOM   2646  CA  THR   344       0.648  38.177  60.944  1.00 53.90           C  
ATOM   2647  C   THR   344       0.938  39.539  60.334  1.00 53.83           C  
ATOM   2648  O   THR   344       0.088  40.109  59.640  1.00 52.77           O  
ATOM   2649  CB  THR   344       0.820  37.085  59.857  1.00 52.39           C  
ATOM   2650  OG1 THR   344       0.655  35.792  60.449  1.00 51.47           O  
ATOM   2651  CG2 THR   344       2.183  37.162  59.218  1.00 52.21           C  
ATOM   2652  N   ALA   345       2.138  40.060  60.607  1.00 53.69           N  
ATOM   2653  CA  ALA   345       2.558  41.347  60.049  1.00 54.53           C  
ATOM   2654  C   ALA   345       3.881  41.194  59.246  1.00 55.31           C  
ATOM   2655  O   ALA   345       4.909  40.764  59.771  1.00 55.22           O  
ATOM   2656  CB  ALA   345       2.707  42.386  61.165  1.00 50.73           C  
ATOM   2657  N   LEU   346       3.833  41.534  57.966  1.00 54.57           N  
ATOM   2658  CA  LEU   346       4.991  41.428  57.106  1.00 54.74           C  
ATOM   2659  C   LEU   346       5.260  42.771  56.501  1.00 56.30           C  
ATOM   2660  O   LEU   346       4.344  43.482  56.115  1.00 55.24           O  
ATOM   2661  CB  LEU   346       4.733  40.452  55.962  1.00 54.66           C  
ATOM   2662  CG  LEU   346       3.997  39.151  56.277  1.00 54.58           C  
ATOM   2663  CD1 LEU   346       3.827  38.410  54.973  1.00 54.37           C  
ATOM   2664  CD2 LEU   346       4.756  38.307  57.298  1.00 52.86           C  
ATOM   2665  N   ALA   347       6.532  43.120  56.414  1.00 60.46           N  
ATOM   2666  CA  ALA   347       6.919  44.376  55.812  1.00 63.30           C  
ATOM   2667  C   ALA   347       7.773  44.004  54.626  1.00 65.99           C  
ATOM   2668  O   ALA   347       8.550  43.055  54.685  1.00 66.09           O  
ATOM   2669  CB  ALA   347       7.712  45.204  56.785  1.00 62.72           C  
ATOM   2670  N   LEU   348       7.605  44.733  53.537  1.00 69.75           N  
ATOM   2671  CA  LEU   348       8.388  44.493  52.345  1.00 73.27           C  
ATOM   2672  C   LEU   348       9.425  45.598  52.249  1.00 76.28           C  
ATOM   2673  O   LEU   348       9.079  46.774  52.340  1.00 77.09           O  
ATOM   2674  CB  LEU   348       7.488  44.501  51.105  1.00 72.63           C  
ATOM   2675  CG  LEU   348       8.164  44.752  49.756  1.00 72.07           C  
ATOM   2676  CD1 LEU   348       7.439  44.008  48.661  1.00 72.10           C  
ATOM   2677  CD2 LEU   348       8.178  46.255  49.469  1.00 73.08           C  
ATOM   2678  N   LEU   349      10.692  45.211  52.089  1.00 80.36           N  
ATOM   2679  CA  LEU   349      11.800  46.161  51.948  1.00 84.04           C  
ATOM   2680  C   LEU   349      12.382  45.977  50.559  1.00 86.93           C  
ATOM   2681  O   LEU   349      13.096  45.008  50.253  1.00 87.77           O  
ATOM   2682  CB  LEU   349      12.885  45.930  52.997  1.00 82.81           C  
ATOM   2683  CG  LEU   349      13.916  47.051  53.179  1.00 81.98           C  
ATOM   2684  CD1 LEU   349      14.826  46.645  54.316  1.00 82.06           C  
ATOM   2685  CD2 LEU   349      14.735  47.285  51.920  1.00 81.21           C  
ATOM   2686  N   ARG   350      12.050  46.955  49.744  1.00 90.06           N  
ATOM   2687  CA  ARG   350      12.362  47.071  48.349  1.00 93.96           C  
ATOM   2688  C   ARG   350      13.733  47.732  48.103  1.00 95.24           C  
ATOM   2689  O   ARG   350      13.850  48.951  48.188  1.00 95.36           O  
ATOM   2690  CB  ARG   350      11.304  48.000  47.798  1.00 96.66           C  
ATOM   2691  CG  ARG   350      11.495  49.406  48.486  1.00101.76           C  
ATOM   2692  CD  ARG   350      10.590  49.798  49.693  1.00103.10           C  
ATOM   2693  NE  ARG   350       9.486  50.645  49.232  1.00105.61           N  
ATOM   2694  CZ  ARG   350       9.581  51.934  48.897  1.00106.47           C  
ATOM   2695  NH1 ARG   350      10.744  52.556  48.989  1.00106.98           N  
ATOM   2696  NH2 ARG   350       8.518  52.596  48.422  1.00106.24           N  
ATOM   2697  N   LEU   351      14.772  46.986  47.781  1.00 96.20           N  
ATOM   2698  CA  LEU   351      16.052  47.640  47.574  1.00 97.27           C  
ATOM   2699  C   LEU   351      16.377  47.802  46.092  1.00 98.60           C  
ATOM   2700  O   LEU   351      17.488  48.177  45.718  1.00 99.70           O  
ATOM   2701  CB  LEU   351      17.128  46.840  48.280  1.00 96.71           C  
ATOM   2702  CG  LEU   351      17.973  47.559  49.313  1.00 96.99           C  
ATOM   2703  CD1 LEU   351      18.417  46.551  50.364  1.00 95.95           C  
ATOM   2704  CD2 LEU   351      19.154  48.220  48.605  1.00 97.39           C  
ATOM   2705  N   ASP   352      15.377  47.541  45.256  1.00 99.78           N  
ATOM   2706  CA  ASP   352      15.518  47.618  43.820  1.00100.88           C  
ATOM   2707  C   ASP   352      15.245  48.992  43.210  1.00101.16           C  
ATOM   2708  O   ASP   352      16.144  49.594  42.620  1.00101.17           O  
ATOM   2709  CB  ASP   352      14.631  46.551  43.149  1.00101.28           C  
ATOM   2710  N   GLY   353      14.038  49.521  43.346  1.00101.29           N  
ATOM   2711  CA  GLY   353      13.770  50.777  42.704  1.00101.77           C  
ATOM   2712  C   GLY   353      12.365  51.307  42.835  1.00103.52           C  
ATOM   2713  O   GLY   353      12.059  52.375  42.223  1.00104.04           O  
ATOM   2714  N   ALA   354      11.433  50.548  43.432  1.00104.23           N  
ATOM   2715  CA  ALA   354      10.122  51.237  43.436  1.00105.23           C  
ATOM   2716  C   ALA   354       9.317  51.465  44.684  1.00105.23           C  
ATOM   2717  O   ALA   354       9.797  51.996  45.764  1.00106.68           O  
ATOM   2718  CB  ALA   354       9.247  50.850  42.267  1.00104.97           C  
ATOM   2719  N   GLN   355       8.039  51.034  44.588  1.00105.18           N  
ATOM   2720  CA  GLN   355       7.230  51.266  45.690  1.00103.76           C  
ATOM   2721  C   GLN   355       6.644  50.033  46.286  1.00102.50           C  
ATOM   2722  O   GLN   355       7.300  49.476  47.191  1.00104.04           O  
ATOM   2723  CB  GLN   355       6.271  52.454  45.430  1.00102.82           C  
ATOM   2724  N   GLY   356       5.533  49.482  45.854  1.00 99.31           N  
ATOM   2725  CA  GLY   356       5.135  48.337  46.613  1.00 94.67           C  
ATOM   2726  C   GLY   356       5.205  46.878  46.347  1.00 91.77           C  
ATOM   2727  O   GLY   356       6.062  46.223  45.659  1.00 92.95           O  
ATOM   2728  N   TRP   357       4.295  46.331  47.110  1.00 88.45           N  
ATOM   2729  CA  TRP   357       4.070  44.946  47.004  1.00 84.96           C  
ATOM   2730  C   TRP   357       3.775  44.540  45.507  1.00 84.34           C  
ATOM   2731  O   TRP   357       2.870  45.085  44.898  1.00 83.43           O  
ATOM   2732  CB  TRP   357       2.898  44.641  47.927  1.00 80.64           C  
ATOM   2733  CG  TRP   357       3.415  44.501  49.266  1.00 75.95           C  
ATOM   2734  CD1 TRP   357       3.373  45.378  50.319  1.00 75.26           C  
ATOM   2735  CD2 TRP   357       3.918  43.303  49.749  1.00 73.93           C  
ATOM   2736  NE1 TRP   357       3.801  44.740  51.462  1.00 73.89           N  
ATOM   2737  CE2 TRP   357       4.146  43.456  51.128  1.00 72.85           C  
ATOM   2738  CE3 TRP   357       4.192  42.081  49.138  1.00 73.29           C  
ATOM   2739  CZ2 TRP   357       4.634  42.417  51.909  1.00 71.22           C  
ATOM   2740  CZ3 TRP   357       4.669  41.054  49.898  1.00 73.42           C  
ATOM   2741  CH2 TRP   357       4.888  41.220  51.278  1.00 71.91           C  
ATOM   2742  N   PRO   358       4.555  43.599  44.879  1.00 83.85           N  
ATOM   2743  CA  PRO   358       4.178  43.251  43.483  1.00 83.32           C  
ATOM   2744  C   PRO   358       2.817  42.550  43.464  1.00 82.44           C  
ATOM   2745  O   PRO   358       2.635  41.525  44.114  1.00 80.88           O  
ATOM   2746  CB  PRO   358       5.290  42.288  43.023  1.00 83.67           C  
ATOM   2747  CG  PRO   358       6.463  42.786  43.779  1.00 83.65           C  
ATOM   2748  CD  PRO   358       5.885  43.023  45.172  1.00 83.90           C  
ATOM   2749  N   GLU   359       1.876  43.137  42.730  1.00 81.62           N  
ATOM   2750  CA  GLU   359       0.517  42.624  42.624  1.00 81.43           C  
ATOM   2751  C   GLU   359       0.384  41.119  42.848  1.00 79.12           C  
ATOM   2752  O   GLU   359      -0.442  40.695  43.647  1.00 78.89           O  
ATOM   2753  CB  GLU   359      -0.084  42.987  41.258  1.00 83.94           C  
ATOM   2754  CG  GLU   359      -1.484  43.618  41.319  1.00 88.17           C  
ATOM   2755  CD  GLU   359      -1.458  45.142  41.524  1.00 91.26           C  
ATOM   2756  OE1 GLU   359      -0.634  45.638  42.329  1.00 92.64           O  
ATOM   2757  OE2 GLU   359      -2.275  45.846  40.886  1.00 91.99           O  
ATOM   2758  N   PHE   360       1.188  40.307  42.163  1.00 76.68           N  
ATOM   2759  CA  PHE   360       1.048  38.869  42.349  1.00 75.12           C  
ATOM   2760  C   PHE   360       1.481  38.335  43.714  1.00 73.72           C  
ATOM   2761  O   PHE   360       1.085  37.231  44.102  1.00 73.90           O  
ATOM   2762  CB  PHE   360       1.722  38.075  41.212  1.00 74.23           C  
ATOM   2763  CG  PHE   360       3.163  38.382  41.007  1.00 74.14           C  
ATOM   2764  CD1 PHE   360       3.551  39.472  40.242  1.00 76.28           C  
ATOM   2765  CD2 PHE   360       4.141  37.555  41.540  1.00 74.67           C  
ATOM   2766  CE1 PHE   360       4.912  39.735  40.004  1.00 76.47           C  
ATOM   2767  CE2 PHE   360       5.493  37.805  41.314  1.00 74.78           C  
ATOM   2768  CZ  PHE   360       5.880  38.897  40.543  1.00 74.49           C  
ATOM   2769  N   LEU   361       2.271  39.117  44.448  1.00 71.70           N  
ATOM   2770  CA  LEU   361       2.702  38.721  45.787  1.00 69.76           C  
ATOM   2771  C   LEU   361       1.597  39.093  46.799  1.00 68.49           C  
ATOM   2772  O   LEU   361       1.280  38.318  47.716  1.00 68.53           O  
ATOM   2773  CB  LEU   361       4.036  39.394  46.131  1.00 70.03           C  
ATOM   2774  CG  LEU   361       5.244  38.756  45.419  1.00 70.77           C  
ATOM   2775  CD1 LEU   361       6.454  39.634  45.580  1.00 70.87           C  
ATOM   2776  CD2 LEU   361       5.518  37.356  45.972  1.00 69.38           C  
ATOM   2777  N   ARG   362       0.996  40.266  46.605  1.00 65.18           N  
ATOM   2778  CA  ARG   362      -0.097  40.729  47.453  1.00 63.12           C  
ATOM   2779  C   ARG   362      -1.265  39.715  47.361  1.00 62.00           C  
ATOM   2780  O   ARG   362      -1.849  39.309  48.377  1.00 60.91           O  
ATOM   2781  CB  ARG   362      -0.535  42.120  46.982  1.00 61.86           C  
ATOM   2782  CG  ARG   362      -1.712  42.717  47.716  1.00 61.96           C  
ATOM   2783  CD  ARG   362      -2.222  43.940  46.978  1.00 63.92           C  
ATOM   2784  NE  ARG   362      -1.195  44.977  46.840  1.00 66.76           N  
ATOM   2785  CZ  ARG   362      -0.951  45.649  45.713  1.00 67.73           C  
ATOM   2786  NH1 ARG   362      -1.654  45.392  44.608  1.00 64.71           N  
ATOM   2787  NH2 ARG   362      -0.018  46.598  45.697  1.00 66.28           N  
ATOM   2788  N   ARG   363      -1.568  39.292  46.136  1.00 59.81           N  
ATOM   2789  CA  ARG   363      -2.631  38.329  45.863  1.00 59.48           C  
ATOM   2790  C   ARG   363      -2.433  37.003  46.619  1.00 59.25           C  
ATOM   2791  O   ARG   363      -3.341  36.530  47.330  1.00 58.56           O  
ATOM   2792  CB  ARG   363      -2.696  38.023  44.352  1.00 60.89           C  
ATOM   2793  CG  ARG   363      -4.066  38.203  43.685  1.00 64.51           C  
ATOM   2794  CD  ARG   363      -4.328  37.220  42.502  1.00 68.23           C  
ATOM   2795  NE  ARG   363      -3.397  37.355  41.371  1.00 72.07           N  
ATOM   2796  CZ  ARG   363      -2.158  36.848  41.319  1.00 73.24           C  
ATOM   2797  NH1 ARG   363      -1.651  36.139  42.336  1.00 72.33           N  
ATOM   2798  NH2 ARG   363      -1.404  37.079  40.249  1.00 71.98           N  
ATOM   2799  N   ALA   364      -1.254  36.397  46.467  1.00 56.54           N  
ATOM   2800  CA  ALA   364      -1.015  35.110  47.110  1.00 54.65           C  
ATOM   2801  C   ALA   364      -1.153  35.200  48.615  1.00 53.48           C  
ATOM   2802  O   ALA   364      -1.774  34.348  49.250  1.00 51.50           O  
ATOM   2803  CB  ALA   364       0.361  34.571  46.733  1.00 54.14           C  
ATOM   2804  N   LEU   365      -0.568  36.246  49.179  1.00 52.92           N  
ATOM   2805  CA  LEU   365      -0.625  36.452  50.605  1.00 52.01           C  
ATOM   2806  C   LEU   365      -2.068  36.660  51.080  1.00 51.54           C  
ATOM   2807  O   LEU   365      -2.523  35.955  51.986  1.00 48.93           O  
ATOM   2808  CB  LEU   365       0.270  37.641  50.977  1.00 52.84           C  
ATOM   2809  CG  LEU   365       1.779  37.436  50.757  1.00 51.97           C  
ATOM   2810  CD1 LEU   365       2.499  38.700  51.212  1.00 50.86           C  
ATOM   2811  CD2 LEU   365       2.299  36.205  51.532  1.00 48.79           C  
ATOM   2812  N   LEU   366      -2.786  37.601  50.453  1.00 52.27           N  
ATOM   2813  CA  LEU   366      -4.187  37.900  50.812  1.00 53.19           C  
ATOM   2814  C   LEU   366      -5.049  36.684  50.700  1.00 54.43           C  
ATOM   2815  O   LEU   366      -5.990  36.454  51.462  1.00 54.27           O  
ATOM   2816  CB  LEU   366      -4.782  38.972  49.903  1.00 49.80           C  
ATOM   2817  CG  LEU   366      -4.097  40.310  50.135  1.00 50.24           C  
ATOM   2818  CD1 LEU   366      -4.751  41.377  49.288  1.00 47.66           C  
ATOM   2819  CD2 LEU   366      -4.150  40.648  51.622  1.00 47.10           C  
ATOM   2820  N   ARG   367      -4.719  35.891  49.719  1.00 56.43           N  
ATOM   2821  CA  ARG   367      -5.479  34.720  49.535  1.00 58.74           C  
ATOM   2822  C   ARG   367      -5.095  33.624  50.499  1.00 58.78           C  
ATOM   2823  O   ARG   367      -5.946  32.898  51.004  1.00 58.29           O  
ATOM   2824  CB  ARG   367      -5.288  34.266  48.141  1.00 63.80           C  
ATOM   2825  CG  ARG   367      -6.427  33.468  47.735  1.00 70.46           C  
ATOM   2826  CD  ARG   367      -6.042  32.818  46.520  1.00 75.79           C  
ATOM   2827  NE  ARG   367      -5.764  33.833  45.523  1.00 81.56           N  
ATOM   2828  CZ  ARG   367      -5.668  33.552  44.238  1.00 83.54           C  
ATOM   2829  NH1 ARG   367      -5.827  32.289  43.859  1.00 83.52           N  
ATOM   2830  NH2 ARG   367      -5.449  34.516  43.350  1.00 83.58           N  
ATOM   2831  N   ALA   368      -3.800  33.496  50.757  1.00 58.48           N  
ATOM   2832  CA  ALA   368      -3.341  32.473  51.677  1.00 56.99           C  
ATOM   2833  C   ALA   368      -3.985  32.690  53.041  1.00 56.60           C  
ATOM   2834  O   ALA   368      -4.560  31.764  53.625  1.00 53.99           O  
ATOM   2835  CB  ALA   368      -1.828  32.503  51.790  1.00 55.43           C  
ATOM   2836  N   PHE   369      -3.913  33.915  53.549  1.00 56.73           N  
ATOM   2837  CA  PHE   369      -4.508  34.166  54.856  1.00 57.88           C  
ATOM   2838  C   PHE   369      -6.007  34.064  54.834  1.00 57.49           C  
ATOM   2839  O   PHE   369      -6.598  33.692  55.833  1.00 57.23           O  
ATOM   2840  CB  PHE   369      -4.081  35.518  55.414  1.00 58.82           C  
ATOM   2841  CG  PHE   369      -2.689  35.515  55.940  1.00 61.44           C  
ATOM   2842  CD1 PHE   369      -1.603  35.490  55.065  1.00 61.63           C  
ATOM   2843  CD2 PHE   369      -2.456  35.435  57.309  1.00 62.48           C  
ATOM   2844  CE1 PHE   369      -0.309  35.376  55.540  1.00 62.22           C  
ATOM   2845  CE2 PHE   369      -1.162  35.318  57.797  1.00 64.00           C  
ATOM   2846  CZ  PHE   369      -0.084  35.288  56.909  1.00 63.33           C  
ATOM   2847  N   GLY   370      -6.618  34.391  53.697  1.00 57.31           N  
ATOM   2848  CA  GLY   370      -8.060  34.285  53.592  1.00 56.52           C  
ATOM   2849  C   GLY   370      -8.456  32.831  53.780  1.00 57.41           C  
ATOM   2850  O   GLY   370      -9.400  32.514  54.513  1.00 58.60           O  
ATOM   2851  N   ALA   371      -7.711  31.931  53.149  1.00 56.71           N  
ATOM   2852  CA  ALA   371      -8.013  30.503  53.247  1.00 56.52           C  
ATOM   2853  C   ALA   371      -7.740  29.949  54.635  1.00 55.56           C  
ATOM   2854  O   ALA   371      -8.270  28.907  55.020  1.00 55.91           O  
ATOM   2855  CB  ALA   371      -7.206  29.720  52.197  1.00 55.62           C  
ATOM   2856  N   SER   372      -6.898  30.650  55.380  1.00 56.44           N  
ATOM   2857  CA  SER   372      -6.534  30.237  56.727  1.00 55.52           C  
ATOM   2858  C   SER   372      -7.477  30.867  57.739  1.00 54.67           C  
ATOM   2859  O   SER   372      -7.694  30.328  58.818  1.00 56.25           O  
ATOM   2860  CB  SER   372      -5.094  30.660  57.019  1.00 57.69           C  
ATOM   2861  OG  SER   372      -4.201  30.111  56.058  1.00 58.74           O  
ATOM   2862  N   GLY   373      -8.057  32.002  57.377  1.00 53.05           N  
ATOM   2863  CA  GLY   373      -8.966  32.673  58.281  1.00 51.55           C  
ATOM   2864  C   GLY   373      -8.183  33.413  59.345  1.00 49.80           C  
ATOM   2865  O   GLY   373      -8.461  33.284  60.540  1.00 51.12           O  
ATOM   2866  N   ALA   374      -7.212  34.203  58.905  1.00 45.58           N  
ATOM   2867  CA  ALA   374      -6.372  34.929  59.819  1.00 43.74           C  
ATOM   2868  C   ALA   374      -6.066  36.331  59.336  1.00 44.12           C  
ATOM   2869  O   ALA   374      -6.093  36.619  58.137  1.00 39.91           O  
ATOM   2870  CB  ALA   374      -5.092  34.163  60.047  1.00 43.55           C  
ATOM   2871  N   SER   375      -5.770  37.194  60.302  1.00 44.81           N  
ATOM   2872  CA  SER   375      -5.476  38.588  60.046  1.00 48.94           C  
ATOM   2873  C   SER   375      -4.039  38.777  59.579  1.00 49.80           C  
ATOM   2874  O   SER   375      -3.107  38.224  60.165  1.00 50.45           O  
ATOM   2875  CB  SER   375      -5.716  39.388  61.323  1.00 50.97           C  
ATOM   2876  OG  SER   375      -6.877  38.897  61.969  1.00 56.08           O  
ATOM   2877  N   LEU   376      -3.882  39.578  58.531  1.00 49.83           N  
ATOM   2878  CA  LEU   376      -2.594  39.868  57.952  1.00 51.97           C  
ATOM   2879  C   LEU   376      -2.426  41.345  57.679  1.00 52.80           C  
ATOM   2880  O   LEU   376      -3.380  42.015  57.293  1.00 53.63           O  
ATOM   2881  CB  LEU   376      -2.440  39.135  56.623  1.00 55.03           C  
ATOM   2882  CG  LEU   376      -1.167  39.516  55.853  1.00 56.99           C  
ATOM   2883  CD1 LEU   376       0.013  38.851  56.535  1.00 55.71           C  
ATOM   2884  CD2 LEU   376      -1.254  39.096  54.395  1.00 56.77           C  
ATOM   2885  N   ARG   377      -1.213  41.854  57.872  1.00 53.29           N  
ATOM   2886  CA  ARG   377      -0.934  43.248  57.557  1.00 54.93           C  
ATOM   2887  C   ARG   377       0.223  43.263  56.586  1.00 53.45           C  
ATOM   2888  O   ARG   377       1.235  42.658  56.849  1.00 53.65           O  
ATOM   2889  CB  ARG   377      -0.572  44.053  58.800  1.00 56.22           C  
ATOM   2890  CG  ARG   377      -1.758  44.486  59.625  1.00 60.28           C  
ATOM   2891  CD  ARG   377      -1.266  45.202  60.861  1.00 65.36           C  
ATOM   2892  NE  ARG   377      -2.328  45.801  61.662  1.00 69.05           N  
ATOM   2893  CZ  ARG   377      -2.106  46.706  62.612  1.00 72.24           C  
ATOM   2894  NH1 ARG   377      -0.864  47.101  62.862  1.00 73.53           N  
ATOM   2895  NH2 ARG   377      -3.116  47.216  63.310  1.00 73.11           N  
ATOM   2896  N   LEU   378       0.056  43.941  55.458  1.00 53.65           N  
ATOM   2897  CA  LEU   378       1.102  44.038  54.450  1.00 53.25           C  
ATOM   2898  C   LEU   378       1.775  45.402  54.512  1.00 52.89           C  
ATOM   2899  O   LEU   378       1.424  46.325  53.785  1.00 51.49           O  
ATOM   2900  CB  LEU   378       0.513  43.792  53.058  1.00 53.19           C  
ATOM   2901  CG  LEU   378       1.009  42.538  52.327  1.00 53.58           C  
ATOM   2902  CD1 LEU   378       1.225  41.401  53.299  1.00 53.98           C  
ATOM   2903  CD2 LEU   378       0.007  42.146  51.272  1.00 54.10           C  
ATOM   2904  N   HIS   379       2.750  45.510  55.404  1.00 54.02           N  
ATOM   2905  CA  HIS   379       3.499  46.749  55.597  1.00 55.10           C  
ATOM   2906  C   HIS   379       4.432  47.007  54.418  1.00 56.02           C  
ATOM   2907  O   HIS   379       4.548  46.189  53.524  1.00 56.33           O  
ATOM   2908  CB  HIS   379       4.318  46.658  56.890  1.00 51.91           C  
ATOM   2909  CG  HIS   379       3.486  46.596  58.133  1.00 51.99           C  
ATOM   2910  ND1 HIS   379       3.350  47.666  58.992  1.00 50.80           N  
ATOM   2911  CD2 HIS   379       2.751  45.591  58.667  1.00 51.96           C  
ATOM   2912  CE1 HIS   379       2.568  47.320  60.001  1.00 51.49           C  
ATOM   2913  NE2 HIS   379       2.190  46.067  59.827  1.00 50.88           N  
ATOM   2914  N   THR   380       5.086  48.157  54.434  1.00 58.20           N  
ATOM   2915  CA  THR   380       6.041  48.542  53.410  1.00 61.65           C  
ATOM   2916  C   THR   380       7.079  49.474  54.042  1.00 65.35           C  
ATOM   2917  O   THR   380       6.730  50.523  54.583  1.00 66.79           O  
ATOM   2918  CB  THR   380       5.372  49.296  52.264  1.00 61.35           C  
ATOM   2919  OG1 THR   380       4.535  48.407  51.522  1.00 61.64           O  
ATOM   2920  CG2 THR   380       6.426  49.874  51.330  1.00 64.54           C  
ATOM   2921  N   LEU   381       8.355  49.113  53.984  1.00 68.20           N  
ATOM   2922  CA  LEU   381       9.359  49.979  54.575  1.00 70.75           C  
ATOM   2923  C   LEU   381       9.731  51.112  53.640  1.00 74.35           C  
ATOM   2924  O   LEU   381      10.439  50.909  52.660  1.00 75.47           O  
ATOM   2925  CB  LEU   381      10.595  49.172  54.967  1.00 68.81           C  
ATOM   2926  CG  LEU   381      10.455  48.371  56.270  1.00 67.11           C  
ATOM   2927  CD1 LEU   381      11.417  47.215  56.273  1.00 64.80           C  
ATOM   2928  CD2 LEU   381      10.700  49.272  57.465  1.00 65.73           C  
ATOM   2929  N   HIS   382       9.221  52.305  53.938  1.00 79.18           N  
ATOM   2930  CA  HIS   382       9.520  53.490  53.137  1.00 83.84           C  
ATOM   2931  C   HIS   382      10.849  54.066  53.619  1.00 86.36           C  
ATOM   2932  O   HIS   382      11.100  55.273  53.550  1.00 86.56           O  
ATOM   2933  CB  HIS   382       8.416  54.543  53.279  1.00 84.63           C  
ATOM   2934  CG  HIS   382       7.060  54.053  52.882  1.00 87.02           C  
ATOM   2935  ND1 HIS   382       6.098  53.697  53.803  1.00 87.85           N  
ATOM   2936  CD2 HIS   382       6.506  53.851  51.663  1.00 88.30           C  
ATOM   2937  CE1 HIS   382       5.009  53.300  53.169  1.00 88.78           C  
ATOM   2938  NE2 HIS   382       5.230  53.383  51.869  1.00 89.57           N  
ATOM   2939  N   ALA   383      11.692  53.184  54.138  1.00 89.15           N  
ATOM   2940  CA  ALA   383      13.005  53.574  54.610  1.00 91.84           C  
ATOM   2941  C   ALA   383      13.917  53.228  53.460  1.00 93.75           C  
ATOM   2942  O   ALA   383      13.750  52.189  52.821  1.00 93.47           O  
ATOM   2943  CB  ALA   383      13.385  52.775  55.829  1.00 93.33           C  
ATOM   2944  N   HIS   384      14.877  54.098  53.190  1.00 96.22           N  
ATOM   2945  CA  HIS   384      15.800  53.872  52.089  1.00 98.18           C  
ATOM   2946  C   HIS   384      16.596  52.601  52.335  1.00 97.41           C  
ATOM   2947  O   HIS   384      16.378  51.919  53.342  1.00 96.85           O  
ATOM   2948  CB  HIS   384      16.721  55.086  51.946  1.00100.90           C  
ATOM   2949  CG  HIS   384      15.990  56.349  51.601  1.00103.91           C  
ATOM   2950  ND1 HIS   384      15.006  56.883  52.407  1.00104.49           N  
ATOM   2951  CD2 HIS   384      16.070  57.160  50.517  1.00104.73           C  
ATOM   2952  CE1 HIS   384      14.510  57.966  51.834  1.00104.83           C  
ATOM   2953  NE2 HIS   384      15.138  58.156  50.686  1.00104.91           N  
ATOM   2954  N   PRO   385      17.494  52.235  51.398  1.00 97.04           N  
ATOM   2955  CA  PRO   385      18.282  51.020  51.619  1.00 96.77           C  
ATOM   2956  C   PRO   385      18.951  51.220  52.973  1.00 96.28           C  
ATOM   2957  O   PRO   385      18.740  52.248  53.619  1.00 95.78           O  
ATOM   2958  CB  PRO   385      19.289  51.050  50.469  1.00 96.63           C  
ATOM   2959  CG  PRO   385      18.515  51.686  49.365  1.00 96.27           C  
ATOM   2960  CD  PRO   385      17.789  52.818  50.075  1.00 97.05           C  
ATOM   2961  N   SER   386      19.749  50.265  53.422  1.00 95.39           N  
ATOM   2962  CA  SER   386      20.406  50.466  54.702  1.00 95.77           C  
ATOM   2963  C   SER   386      21.328  51.688  54.626  1.00 94.13           C  
ATOM   2964  O   SER   386      22.545  51.549  54.585  1.00 94.15           O  
ATOM   2965  CB  SER   386      21.218  49.230  55.095  1.00 97.84           C  
ATOM   2966  OG  SER   386      21.940  49.466  56.299  1.00 99.03           O  
ATOM   2967  N   GLN   387      20.748  52.883  54.617  1.00 92.28           N  
ATOM   2968  CA  GLN   387      21.545  54.101  54.538  1.00 90.28           C  
ATOM   2969  C   GLN   387      21.216  55.164  55.592  1.00 88.47           C  
ATOM   2970  O   GLN   387      20.457  56.114  55.339  1.00 86.81           O  
ATOM   2971  CB  GLN   387      21.411  54.710  53.150  1.00 90.16           C  
ATOM   2972  CG  GLN   387      21.453  53.688  52.057  1.00 90.14           C  
ATOM   2973  CD  GLN   387      21.724  54.319  50.723  1.00 91.48           C  
ATOM   2974  OE1 GLN   387      21.320  53.798  49.682  1.00 92.20           O  
ATOM   2975  NE2 GLN   387      22.426  55.451  50.739  1.00 91.98           N  
ATOM   2976  N   GLY   388      21.809  54.999  56.769  1.00 86.08           N  
ATOM   2977  CA  GLY   388      21.599  55.948  57.836  1.00 84.79           C  
ATOM   2978  C   GLY   388      21.163  55.283  59.116  1.00 84.07           C  
ATOM   2979  O   GLY   388      20.703  54.144  59.109  1.00 84.15           O  
ATOM   2980  N   LEU   389      21.336  55.980  60.229  1.00 82.60           N  
ATOM   2981  CA  LEU   389      20.898  55.431  61.490  1.00 81.50           C  
ATOM   2982  C   LEU   389      19.380  55.504  61.403  1.00 80.28           C  
ATOM   2983  O   LEU   389      18.666  54.872  62.175  1.00 79.39           O  
ATOM   2984  CB  LEU   389      21.437  56.265  62.658  1.00 82.67           C  
ATOM   2985  CG  LEU   389      22.819  55.850  63.191  1.00 83.07           C  
ATOM   2986  CD1 LEU   389      22.688  54.543  63.955  1.00 83.88           C  
ATOM   2987  CD2 LEU   389      23.815  55.691  62.053  1.00 82.66           C  
ATOM   2988  N   ALA   390      18.902  56.274  60.429  1.00 78.98           N  
ATOM   2989  CA  ALA   390      17.474  56.433  60.193  1.00 77.68           C  
ATOM   2990  C   ALA   390      16.870  55.076  59.822  1.00 77.25           C  
ATOM   2991  O   ALA   390      15.749  54.757  60.237  1.00 77.78           O  
ATOM   2992  CB  ALA   390      17.238  57.436  59.079  1.00 76.68           C  
ATOM   2993  N   PHE   391      17.614  54.291  59.038  1.00 74.91           N  
ATOM   2994  CA  PHE   391      17.179  52.955  58.625  1.00 72.52           C  
ATOM   2995  C   PHE   391      17.006  52.123  59.894  1.00 73.50           C  
ATOM   2996  O   PHE   391      15.972  51.495  60.104  1.00 75.23           O  
ATOM   2997  CB  PHE   391      18.231  52.306  57.724  1.00 68.50           C  
ATOM   2998  CG  PHE   391      17.837  50.951  57.198  1.00 64.58           C  
ATOM   2999  CD1 PHE   391      16.902  50.829  56.175  1.00 64.14           C  
ATOM   3000  CD2 PHE   391      18.389  49.792  57.740  1.00 61.18           C  
ATOM   3001  CE1 PHE   391      16.529  49.574  55.709  1.00 62.48           C  
ATOM   3002  CE2 PHE   391      18.019  48.535  57.282  1.00 57.17           C  
ATOM   3003  CZ  PHE   391      17.098  48.419  56.275  1.00 60.15           C  
ATOM   3004  N   ARG   392      18.031  52.119  60.738  1.00 73.50           N  
ATOM   3005  CA  ARG   392      17.980  51.395  62.001  1.00 73.90           C  
ATOM   3006  C   ARG   392      16.692  51.821  62.726  1.00 74.41           C  
ATOM   3007  O   ARG   392      16.064  51.017  63.420  1.00 74.51           O  
ATOM   3008  CB  ARG   392      19.218  51.762  62.844  1.00 73.67           C  
ATOM   3009  CG  ARG   392      19.276  51.216  64.285  1.00 74.97           C  
ATOM   3010  CD  ARG   392      19.768  49.772  64.351  1.00 76.08           C  
ATOM   3011  NE  ARG   392      19.942  49.281  65.722  1.00 76.87           N  
ATOM   3012  CZ  ARG   392      21.102  49.251  66.378  1.00 77.54           C  
ATOM   3013  NH1 ARG   392      22.204  49.691  65.792  1.00 77.89           N  
ATOM   3014  NH2 ARG   392      21.167  48.753  67.611  1.00 77.04           N  
ATOM   3015  N   GLU   393      16.310  53.089  62.542  1.00 73.97           N  
ATOM   3016  CA  GLU   393      15.130  53.675  63.178  1.00 73.57           C  
ATOM   3017  C   GLU   393      13.833  53.191  62.546  1.00 73.21           C  
ATOM   3018  O   GLU   393      12.904  52.816  63.251  1.00 74.45           O  
ATOM   3019  CB  GLU   393      15.213  55.213  63.118  1.00 74.67           C  
ATOM   3020  CG  GLU   393      14.123  55.986  63.886  1.00 75.44           C  
ATOM   3021  CD  GLU   393      13.875  55.449  65.294  1.00 76.45           C  
ATOM   3022  OE1 GLU   393      14.830  54.941  65.923  1.00 76.72           O  
ATOM   3023  OE2 GLU   393      12.725  55.546  65.777  1.00 75.61           O  
ATOM   3024  N   ALA   394      13.769  53.198  61.220  1.00 71.93           N  
ATOM   3025  CA  ALA   394      12.577  52.736  60.518  1.00 71.04           C  
ATOM   3026  C   ALA   394      12.267  51.281  60.885  1.00 70.73           C  
ATOM   3027  O   ALA   394      11.098  50.876  60.933  1.00 71.78           O  
ATOM   3028  CB  ALA   394      12.776  52.860  59.019  1.00 69.08           C  
ATOM   3029  N   LEU   395      13.321  50.511  61.140  1.00 68.84           N  
ATOM   3030  CA  LEU   395      13.198  49.113  61.499  1.00 68.10           C  
ATOM   3031  C   LEU   395      12.650  48.965  62.897  1.00 67.98           C  
ATOM   3032  O   LEU   395      11.709  48.209  63.120  1.00 68.98           O  
ATOM   3033  CB  LEU   395      14.555  48.414  61.433  1.00 68.67           C  
ATOM   3034  CG  LEU   395      15.317  48.286  60.110  1.00 68.06           C  
ATOM   3035  CD1 LEU   395      16.546  47.435  60.372  1.00 67.35           C  
ATOM   3036  CD2 LEU   395      14.458  47.638  59.033  1.00 67.32           C  
ATOM   3037  N   ARG   396      13.249  49.679  63.843  1.00 68.20           N  
ATOM   3038  CA  ARG   396      12.820  49.621  65.238  1.00 68.08           C  
ATOM   3039  C   ARG   396      11.334  49.948  65.310  1.00 69.44           C  
ATOM   3040  O   ARG   396      10.568  49.292  66.015  1.00 69.34           O  
ATOM   3041  CB  ARG   396      13.602  50.626  66.066  1.00 65.37           C  
ATOM   3042  CG  ARG   396      13.337  50.537  67.552  1.00 63.99           C  
ATOM   3043  CD  ARG   396      13.753  51.830  68.256  1.00 63.64           C  
ATOM   3044  NE  ARG   396      13.033  52.992  67.735  1.00 63.64           N  
ATOM   3045  CZ  ARG   396      11.753  53.260  67.986  1.00 65.07           C  
ATOM   3046  NH1 ARG   396      11.026  52.455  68.766  1.00 63.14           N  
ATOM   3047  NH2 ARG   396      11.189  54.331  67.439  1.00 64.87           N  
ATOM   3048  N   LYS   397      10.941  50.971  64.560  1.00 70.84           N  
ATOM   3049  CA  LYS   397       9.556  51.416  64.493  1.00 72.07           C  
ATOM   3050  C   LYS   397       8.665  50.269  64.002  1.00 71.46           C  
ATOM   3051  O   LYS   397       7.656  49.947  64.620  1.00 71.57           O  
ATOM   3052  CB  LYS   397       9.462  52.622  63.549  1.00 73.71           C  
ATOM   3053  CG  LYS   397       8.128  53.363  63.579  1.00 77.32           C  
ATOM   3054  CD  LYS   397       8.177  54.596  62.677  1.00 79.13           C  
ATOM   3055  CE  LYS   397       6.802  54.934  62.101  1.00 80.43           C  
ATOM   3056  NZ  LYS   397       6.876  55.967  61.015  1.00 80.60           N  
ATOM   3057  N   ALA   398       9.064  49.649  62.895  1.00 71.06           N  
ATOM   3058  CA  ALA   398       8.335  48.532  62.294  1.00 69.23           C  
ATOM   3059  C   ALA   398       8.118  47.336  63.233  1.00 68.53           C  
ATOM   3060  O   ALA   398       7.054  46.719  63.237  1.00 67.92           O  
ATOM   3061  CB  ALA   398       9.066  48.071  61.058  1.00 67.15           C  
ATOM   3062  N   LYS   399       9.134  47.003  64.017  1.00 67.52           N  
ATOM   3063  CA  LYS   399       9.043  45.872  64.922  1.00 66.89           C  
ATOM   3064  C   LYS   399       8.131  46.231  66.074  1.00 67.65           C  
ATOM   3065  O   LYS   399       7.403  45.389  66.604  1.00 67.39           O  
ATOM   3066  CB  LYS   399      10.432  45.532  65.445  1.00 65.46           C  
ATOM   3067  CG  LYS   399      10.641  44.082  65.808  1.00 65.45           C  
ATOM   3068  CD  LYS   399      10.024  43.744  67.130  1.00 66.96           C  
ATOM   3069  CE  LYS   399      10.511  42.392  67.622  1.00 68.58           C  
ATOM   3070  NZ  LYS   399      10.209  41.303  66.663  1.00 70.49           N  
ATOM   3071  N   GLU   400       8.177  47.499  66.454  1.00 68.34           N  
ATOM   3072  CA  GLU   400       7.376  47.996  67.557  1.00 68.69           C  
ATOM   3073  C   GLU   400       5.926  47.962  67.115  1.00 66.99           C  
ATOM   3074  O   GLU   400       5.038  47.610  67.880  1.00 67.27           O  
ATOM   3075  CB  GLU   400       7.795  49.425  67.880  1.00 71.17           C  
ATOM   3076  CG  GLU   400       7.492  49.880  69.288  1.00 75.33           C  
ATOM   3077  CD  GLU   400       8.040  51.266  69.547  1.00 79.00           C  
ATOM   3078  OE1 GLU   400       7.455  52.253  69.032  1.00 78.91           O  
ATOM   3079  OE2 GLU   400       9.073  51.362  70.250  1.00 81.55           O  
ATOM   3080  N   GLU   401       5.703  48.326  65.860  1.00 65.26           N  
ATOM   3081  CA  GLU   401       4.374  48.336  65.284  1.00 63.47           C  
ATOM   3082  C   GLU   401       3.846  46.935  64.992  1.00 60.72           C  
ATOM   3083  O   GLU   401       2.770  46.783  64.439  1.00 60.47           O  
ATOM   3084  CB  GLU   401       4.374  49.164  64.005  1.00 66.24           C  
ATOM   3085  CG  GLU   401       4.370  50.656  64.235  1.00 72.45           C  
ATOM   3086  CD  GLU   401       4.380  51.433  62.931  1.00 78.43           C  
ATOM   3087  OE1 GLU   401       4.260  52.681  62.978  1.00 82.26           O  
ATOM   3088  OE2 GLU   401       4.513  50.799  61.858  1.00 81.15           O  
ATOM   3089  N   GLY   402       4.608  45.909  65.349  1.00 59.20           N  
ATOM   3090  CA  GLY   402       4.150  44.545  65.121  1.00 55.54           C  
ATOM   3091  C   GLY   402       4.650  43.728  63.934  1.00 51.64           C  
ATOM   3092  O   GLY   402       4.179  42.613  63.745  1.00 49.52           O  
ATOM   3093  N   VAL   403       5.576  44.246  63.134  1.00 49.33           N  
ATOM   3094  CA  VAL   403       6.083  43.462  62.017  1.00 47.55           C  
ATOM   3095  C   VAL   403       6.810  42.258  62.589  1.00 48.03           C  
ATOM   3096  O   VAL   403       7.432  42.346  63.642  1.00 50.13           O  
ATOM   3097  CB  VAL   403       7.025  44.269  61.144  1.00 46.21           C  
ATOM   3098  CG1 VAL   403       7.603  43.379  60.085  1.00 48.28           C  
ATOM   3099  CG2 VAL   403       6.269  45.413  60.482  1.00 43.87           C  
ATOM   3100  N   GLN   404       6.716  41.123  61.909  1.00 48.46           N  
ATOM   3101  CA  GLN   404       7.325  39.892  62.389  1.00 47.90           C  
ATOM   3102  C   GLN   404       8.401  39.325  61.467  1.00 49.46           C  
ATOM   3103  O   GLN   404       9.112  38.389  61.828  1.00 50.28           O  
ATOM   3104  CB  GLN   404       6.241  38.840  62.586  1.00 47.42           C  
ATOM   3105  CG  GLN   404       4.989  39.362  63.281  1.00 49.38           C  
ATOM   3106  CD  GLN   404       3.879  38.315  63.362  1.00 51.56           C  
ATOM   3107  OE1 GLN   404       3.423  37.765  62.340  1.00 52.27           O  
ATOM   3108  NE2 GLN   404       3.446  38.028  64.578  1.00 48.42           N  
ATOM   3109  N   ALA   405       8.519  39.875  60.270  1.00 50.59           N  
ATOM   3110  CA  ALA   405       9.515  39.387  59.334  1.00 53.14           C  
ATOM   3111  C   ALA   405       9.501  40.323  58.174  1.00 54.84           C  
ATOM   3112  O   ALA   405       8.491  40.952  57.900  1.00 55.84           O  
ATOM   3113  CB  ALA   405       9.182  37.989  58.873  1.00 53.11           C  
ATOM   3114  N   VAL   406      10.625  40.419  57.486  1.00 56.75           N  
ATOM   3115  CA  VAL   406      10.725  41.317  56.358  1.00 57.07           C  
ATOM   3116  C   VAL   406      11.093  40.546  55.101  1.00 59.00           C  
ATOM   3117  O   VAL   406      11.885  39.610  55.138  1.00 59.03           O  
ATOM   3118  CB  VAL   406      11.780  42.401  56.637  1.00 55.96           C  
ATOM   3119  CG1 VAL   406      11.832  43.397  55.500  1.00 54.50           C  
ATOM   3120  CG2 VAL   406      11.456  43.101  57.945  1.00 54.72           C  
ATOM   3121  N   LEU   407      10.473  40.940  53.997  1.00 61.07           N  
ATOM   3122  CA  LEU   407      10.708  40.341  52.705  1.00 63.09           C  
ATOM   3123  C   LEU   407      11.606  41.325  51.987  1.00 66.55           C  
ATOM   3124  O   LEU   407      11.230  42.478  51.779  1.00 66.76           O  
ATOM   3125  CB  LEU   407       9.402  40.198  51.923  1.00 62.13           C  
ATOM   3126  CG  LEU   407       9.506  39.345  50.652  1.00 60.93           C  
ATOM   3127  CD1 LEU   407       9.824  37.936  51.067  1.00 57.60           C  
ATOM   3128  CD2 LEU   407       8.219  39.377  49.851  1.00 59.77           C  
ATOM   3129  N   VAL   408      12.793  40.874  51.603  1.00 69.70           N  
ATOM   3130  CA  VAL   408      13.719  41.751  50.920  1.00 71.94           C  
ATOM   3131  C   VAL   408      13.802  41.433  49.441  1.00 74.01           C  
ATOM   3132  O   VAL   408      14.261  40.358  49.057  1.00 74.62           O  
ATOM   3133  CB  VAL   408      15.127  41.655  51.532  1.00 71.44           C  
ATOM   3134  CG1 VAL   408      16.000  42.775  50.970  1.00 70.84           C  
ATOM   3135  CG2 VAL   408      15.041  41.724  53.056  1.00 69.41           C  
ATOM   3136  N   LEU   409      13.322  42.373  48.627  1.00 76.67           N  
ATOM   3137  CA  LEU   409      13.341  42.271  47.168  1.00 78.86           C  
ATOM   3138  C   LEU   409      14.599  43.029  46.779  1.00 81.23           C  
ATOM   3139  O   LEU   409      14.623  44.262  46.789  1.00 81.47           O  
ATOM   3140  CB  LEU   409      12.118  42.958  46.562  1.00 77.86           C  
ATOM   3141  CG  LEU   409      10.877  42.124  46.250  1.00 78.49           C  
ATOM   3142  CD1 LEU   409       9.748  43.062  45.860  1.00 77.07           C  
ATOM   3143  CD2 LEU   409      11.156  41.144  45.118  1.00 78.28           C  
ATOM   3144  N   THR   410      15.643  42.292  46.425  1.00 83.76           N  
ATOM   3145  CA  THR   410      16.915  42.917  46.113  1.00 85.94           C  
ATOM   3146  C   THR   410      17.734  42.218  45.040  1.00 87.27           C  
ATOM   3147  O   THR   410      17.673  41.000  44.893  1.00 86.80           O  
ATOM   3148  CB  THR   410      17.772  42.986  47.400  1.00 86.84           C  
ATOM   3149  OG1 THR   410      19.074  43.510  47.104  1.00 88.27           O  
ATOM   3150  CG2 THR   410      17.914  41.585  48.011  1.00 85.89           C  
ATOM   3151  N   PRO   411      18.498  42.996  44.259  1.00 89.39           N  
ATOM   3152  CA  PRO   411      19.346  42.434  43.208  1.00 90.75           C  
ATOM   3153  C   PRO   411      20.306  41.502  43.927  1.00 91.92           C  
ATOM   3154  O   PRO   411      20.536  41.655  45.122  1.00 91.90           O  
ATOM   3155  CB  PRO   411      20.054  43.659  42.653  1.00 91.13           C  
ATOM   3156  CG  PRO   411      18.998  44.711  42.750  1.00 91.57           C  
ATOM   3157  CD  PRO   411      18.410  44.464  44.131  1.00 90.65           C  
ATOM   3158  N   PRO   412      20.875  40.523  43.222  1.00 93.41           N  
ATOM   3159  CA  PRO   412      21.803  39.609  43.894  1.00 94.43           C  
ATOM   3160  C   PRO   412      22.856  40.305  44.760  1.00 95.63           C  
ATOM   3161  O   PRO   412      23.463  41.297  44.362  1.00 94.80           O  
ATOM   3162  CB  PRO   412      22.400  38.822  42.736  1.00 93.95           C  
ATOM   3163  CG  PRO   412      21.223  38.717  41.798  1.00 94.37           C  
ATOM   3164  CD  PRO   412      20.668  40.133  41.817  1.00 93.59           C  
ATOM   3165  N   MET   413      23.050  39.772  45.960  1.00 97.99           N  
ATOM   3166  CA  MET   413      24.012  40.322  46.908  1.00100.79           C  
ATOM   3167  C   MET   413      25.176  39.367  47.126  1.00102.04           C  
ATOM   3168  O   MET   413      25.036  38.155  46.964  1.00102.08           O  
ATOM   3169  CB  MET   413      23.355  40.557  48.272  1.00101.82           C  
ATOM   3170  CG  MET   413      22.213  41.553  48.312  1.00103.45           C  
ATOM   3171  SD  MET   413      21.362  41.420  49.911  1.00103.53           S  
ATOM   3172  CE  MET   413      22.331  42.552  50.928  1.00103.98           C  
ATOM   3173  N   ALA   414      26.320  39.927  47.509  1.00103.97           N  
ATOM   3174  CA  ALA   414      27.504  39.127  47.796  1.00105.85           C  
ATOM   3175  C   ALA   414      27.099  38.386  49.040  1.00106.38           C  
ATOM   3176  O   ALA   414      26.309  38.885  49.842  1.00106.75           O  
ATOM   3177  CB  ALA   414      28.689  40.019  48.087  1.00106.57           C  
ATOM   3178  N   TRP   415      27.599  37.203  49.275  1.00106.66           N  
ATOM   3179  CA  TRP   415      27.041  36.636  50.450  1.00107.75           C  
ATOM   3180  C   TRP   415      27.507  37.346  51.743  1.00108.51           C  
ATOM   3181  O   TRP   415      27.047  37.028  52.857  1.00107.71           O  
ATOM   3182  CB  TRP   415      27.362  35.183  50.507  1.00107.61           C  
ATOM   3183  CG  TRP   415      28.169  35.004  51.626  1.00107.74           C  
ATOM   3184  CD1 TRP   415      29.261  35.775  52.019  1.00108.18           C  
ATOM   3185  CD2 TRP   415      27.979  34.030  52.600  1.00106.65           C  
ATOM   3186  NE1 TRP   415      29.739  35.310  53.201  1.00107.61           N  
ATOM   3187  CE2 TRP   415      28.984  34.225  53.578  1.00106.40           C  
ATOM   3188  CE3 TRP   415      27.072  32.967  52.731  1.00105.06           C  
ATOM   3189  CZ2 TRP   415      29.077  33.414  54.703  1.00104.51           C  
ATOM   3190  CZ3 TRP   415      27.164  32.167  53.831  1.00104.32           C  
ATOM   3191  CH2 TRP   415      28.176  32.387  54.809  1.00104.02           C  
ATOM   3192  N   GLU   416      28.441  38.280  51.617  1.00109.72           N  
ATOM   3193  CA  GLU   416      28.915  38.997  52.791  1.00109.87           C  
ATOM   3194  C   GLU   416      27.858  40.047  53.051  1.00108.38           C  
ATOM   3195  O   GLU   416      27.329  40.143  54.153  1.00108.88           O  
ATOM   3196  CB  GLU   416      30.297  39.624  52.537  1.00111.95           C  
ATOM   3197  CG  GLU   416      31.351  38.602  52.158  1.00112.92           C  
ATOM   3198  CD  GLU   416      32.528  39.217  51.425  1.00113.76           C  
ATOM   3199  OE1 GLU   416      32.291  40.073  50.543  1.00114.47           O  
ATOM   3200  OE2 GLU   416      33.683  38.832  51.716  1.00112.91           O  
ATOM   3201  N   ASP   417      27.515  40.807  52.018  1.00106.97           N  
ATOM   3202  CA  ASP   417      26.489  41.844  52.145  1.00105.86           C  
ATOM   3203  C   ASP   417      25.119  41.269  52.552  1.00105.07           C  
ATOM   3204  O   ASP   417      24.281  41.965  53.133  1.00105.88           O  
ATOM   3205  CB  ASP   417      26.358  42.631  50.827  1.00104.58           C  
ATOM   3206  N   ARG   418      24.900  39.994  52.254  1.00103.19           N  
ATOM   3207  CA  ARG   418      23.652  39.296  52.559  1.00101.00           C  
ATOM   3208  C   ARG   418      23.593  38.969  54.032  1.00 99.87           C  
ATOM   3209  O   ARG   418      22.557  39.111  54.694  1.00100.01           O  
ATOM   3210  CB  ARG   418      23.588  38.011  51.736  1.00101.30           C  
ATOM   3211  CG  ARG   418      22.351  37.139  51.911  1.00 99.48           C  
ATOM   3212  CD  ARG   418      22.535  35.869  51.084  1.00 98.59           C  
ATOM   3213  NE  ARG   418      21.295  35.149  50.805  1.00 98.83           N  
ATOM   3214  CZ  ARG   418      20.674  34.339  51.660  1.00 98.71           C  
ATOM   3215  NH1 ARG   418      21.177  34.137  52.873  1.00 99.15           N  
ATOM   3216  NH2 ARG   418      19.557  33.718  51.294  1.00 97.51           N  
ATOM   3217  N   ASN   419      24.713  38.516  54.554  1.00 98.07           N  
ATOM   3218  CA  ASN   419      24.773  38.194  55.948  1.00 95.93           C  
ATOM   3219  C   ASN   419      24.805  39.446  56.809  1.00 94.17           C  
ATOM   3220  O   ASN   419      24.329  39.454  57.946  1.00 92.71           O  
ATOM   3221  CB  ASN   419      26.012  37.338  56.185  1.00 96.39           C  
ATOM   3222  CG  ASN   419      25.676  35.954  56.656  1.00 96.33           C  
ATOM   3223  OD1 ASN   419      24.680  35.333  56.221  1.00 96.82           O  
ATOM   3224  ND2 ASN   419      26.504  35.446  57.553  1.00 95.71           N  
ATOM   3225  N   ARG   420      25.334  40.522  56.238  1.00 92.86           N  
ATOM   3226  CA  ARG   420      25.388  41.782  56.964  1.00 90.97           C  
ATOM   3227  C   ARG   420      23.952  42.269  57.188  1.00 88.97           C  
ATOM   3228  O   ARG   420      23.499  42.421  58.332  1.00 87.55           O  
ATOM   3229  CB  ARG   420      26.210  42.830  56.191  1.00 92.12           C  
ATOM   3230  CG  ARG   420      26.701  43.988  57.043  1.00 93.45           C  
ATOM   3231  CD  ARG   420      27.931  44.649  56.428  1.00 95.52           C  
ATOM   3232  NE  ARG   420      29.094  43.758  56.398  1.00 96.90           N  
ATOM   3233  CZ  ARG   420      30.325  44.139  56.061  1.00 97.50           C  
ATOM   3234  NH1 ARG   420      30.561  45.401  55.724  1.00 97.74           N  
ATOM   3235  NH2 ARG   420      31.319  43.260  56.056  1.00 98.04           N  
ATOM   3236  N   LEU   421      23.230  42.473  56.089  1.00 85.67           N  
ATOM   3237  CA  LEU   421      21.845  42.931  56.149  1.00 82.38           C  
ATOM   3238  C   LEU   421      20.997  42.089  57.102  1.00 80.89           C  
ATOM   3239  O   LEU   421      20.285  42.628  57.947  1.00 80.23           O  
ATOM   3240  CB  LEU   421      21.217  42.936  54.747  1.00 80.13           C  
ATOM   3241  CG  LEU   421      19.820  43.568  54.650  1.00 78.25           C  
ATOM   3242  CD1 LEU   421      19.712  44.748  55.617  1.00 76.32           C  
ATOM   3243  CD2 LEU   421      19.550  44.012  53.211  1.00 76.38           C  
ATOM   3244  N   LYS   422      21.080  40.772  56.974  1.00 79.37           N  
ATOM   3245  CA  LYS   422      20.317  39.898  57.851  1.00 79.24           C  
ATOM   3246  C   LYS   422      20.703  40.148  59.290  1.00 78.84           C  
ATOM   3247  O   LYS   422      19.888  39.974  60.195  1.00 78.89           O  
ATOM   3248  CB  LYS   422      20.563  38.420  57.517  1.00 80.27           C  
ATOM   3249  CG  LYS   422      19.726  37.900  56.357  1.00 80.84           C  
ATOM   3250  CD  LYS   422      19.998  36.440  56.090  1.00 81.25           C  
ATOM   3251  CE  LYS   422      18.871  35.825  55.279  1.00 81.95           C  
ATOM   3252  NZ  LYS   422      17.671  35.600  56.125  1.00 81.02           N  
ATOM   3253  N   ALA   423      21.951  40.559  59.498  1.00 78.91           N  
ATOM   3254  CA  ALA   423      22.456  40.832  60.840  1.00 78.05           C  
ATOM   3255  C   ALA   423      21.864  42.120  61.391  1.00 76.96           C  
ATOM   3256  O   ALA   423      21.506  42.196  62.566  1.00 75.31           O  
ATOM   3257  CB  ALA   423      23.971  40.925  60.819  1.00 79.78           C  
ATOM   3258  N   LEU   424      21.764  43.132  60.538  1.00 76.20           N  
ATOM   3259  CA  LEU   424      21.203  44.404  60.956  1.00 77.10           C  
ATOM   3260  C   LEU   424      19.767  44.193  61.455  1.00 77.44           C  
ATOM   3261  O   LEU   424      19.431  44.543  62.588  1.00 77.02           O  
ATOM   3262  CB  LEU   424      21.193  45.384  59.789  1.00 77.44           C  
ATOM   3263  CG  LEU   424      21.116  46.836  60.254  1.00 79.53           C  
ATOM   3264  CD1 LEU   424      22.511  47.331  60.559  1.00 81.77           C  
ATOM   3265  CD2 LEU   424      20.514  47.694  59.182  1.00 80.78           C  
ATOM   3266  N   LEU   425      18.938  43.596  60.598  1.00 76.81           N  
ATOM   3267  CA  LEU   425      17.534  43.326  60.893  1.00 75.30           C  
ATOM   3268  C   LEU   425      17.276  42.463  62.116  1.00 76.29           C  
ATOM   3269  O   LEU   425      16.482  42.836  62.978  1.00 76.39           O  
ATOM   3270  CB  LEU   425      16.867  42.639  59.708  1.00 73.34           C  
ATOM   3271  CG  LEU   425      17.056  43.225  58.320  1.00 72.81           C  
ATOM   3272  CD1 LEU   425      16.266  42.380  57.348  1.00 71.97           C  
ATOM   3273  CD2 LEU   425      16.606  44.669  58.278  1.00 71.87           C  
ATOM   3274  N   LEU   426      17.915  41.290  62.161  1.00 77.66           N  
ATOM   3275  CA  LEU   426      17.749  40.326  63.259  1.00 77.59           C  
ATOM   3276  C   LEU   426      18.077  40.987  64.564  1.00 77.63           C  
ATOM   3277  O   LEU   426      17.692  40.541  65.643  1.00 76.70           O  
ATOM   3278  CB  LEU   426      18.687  39.136  63.097  1.00 77.39           C  
ATOM   3279  CG  LEU   426      18.287  37.996  64.031  1.00 78.31           C  
ATOM   3280  CD1 LEU   426      17.374  37.077  63.257  1.00 79.63           C  
ATOM   3281  CD2 LEU   426      19.485  37.231  64.532  1.00 78.88           C  
ATOM   3282  N   ARG   427      18.825  42.059  64.435  1.00 78.65           N  
ATOM   3283  CA  ARG   427      19.238  42.814  65.566  1.00 80.33           C  
ATOM   3284  C   ARG   427      18.067  43.345  66.284  1.00 79.47           C  
ATOM   3285  O   ARG   427      17.932  43.269  67.503  1.00 80.34           O  
ATOM   3286  CB  ARG   427      19.980  44.044  65.150  1.00 83.88           C  
ATOM   3287  CG  ARG   427      20.371  44.679  66.370  1.00 87.75           C  
ATOM   3288  CD  ARG   427      21.159  43.586  67.016  1.00 90.99           C  
ATOM   3289  NE  ARG   427      22.507  44.065  67.059  1.00 94.46           N  
ATOM   3290  CZ  ARG   427      23.002  44.617  68.148  1.00 96.65           C  
ATOM   3291  NH1 ARG   427      22.238  44.693  69.237  1.00 96.88           N  
ATOM   3292  NH2 ARG   427      24.206  45.170  68.127  1.00 96.72           N  
ATOM   3293  N   GLU   428      17.296  44.023  65.462  1.00 78.10           N  
ATOM   3294  CA  GLU   428      16.094  44.687  65.853  1.00 77.18           C  
ATOM   3295  C   GLU   428      14.976  43.677  66.021  1.00 75.63           C  
ATOM   3296  O   GLU   428      13.828  44.038  66.238  1.00 74.74           O  
ATOM   3297  CB  GLU   428      15.775  45.726  64.786  1.00 77.14           C  
ATOM   3298  CG  GLU   428      16.764  46.891  64.804  1.00 79.44           C  
ATOM   3299  CD  GLU   428      16.807  47.583  66.162  1.00 79.89           C  
ATOM   3300  OE1 GLU   428      17.534  47.112  67.067  1.00 79.73           O  
ATOM   3301  OE2 GLU   428      16.091  48.592  66.329  1.00 80.91           O  
ATOM   3302  N   GLY   429      15.336  42.402  65.931  1.00 74.63           N  
ATOM   3303  CA  GLY   429      14.360  41.334  66.080  1.00 72.55           C  
ATOM   3304  C   GLY   429      13.550  40.984  64.840  1.00 69.54           C  
ATOM   3305  O   GLY   429      12.543  40.285  64.954  1.00 69.46           O  
ATOM   3306  N   LEU   430      13.989  41.435  63.666  1.00 65.59           N  
ATOM   3307  CA  LEU   430      13.263  41.170  62.429  1.00 63.62           C  
ATOM   3308  C   LEU   430      13.808  40.068  61.507  1.00 63.34           C  
ATOM   3309  O   LEU   430      14.744  40.307  60.733  1.00 63.73           O  
ATOM   3310  CB  LEU   430      13.150  42.468  61.627  1.00 62.33           C  
ATOM   3311  CG  LEU   430      12.451  43.641  62.324  1.00 62.79           C  
ATOM   3312  CD1 LEU   430      12.677  44.896  61.493  1.00 60.07           C  
ATOM   3313  CD2 LEU   430      10.941  43.359  62.534  1.00 59.66           C  
ATOM   3314  N   PRO   431      13.237  38.846  61.578  1.00 62.40           N  
ATOM   3315  CA  PRO   431      13.720  37.774  60.703  1.00 61.39           C  
ATOM   3316  C   PRO   431      13.654  38.230  59.249  1.00 62.47           C  
ATOM   3317  O   PRO   431      13.092  39.280  58.951  1.00 63.84           O  
ATOM   3318  CB  PRO   431      12.780  36.632  61.035  1.00 61.00           C  
ATOM   3319  CG  PRO   431      12.651  36.783  62.523  1.00 59.95           C  
ATOM   3320  CD  PRO   431      12.419  38.284  62.671  1.00 61.72           C  
ATOM   3321  N   SER   432      14.226  37.468  58.328  1.00 63.15           N  
ATOM   3322  CA  SER   432      14.231  37.925  56.943  1.00 62.84           C  
ATOM   3323  C   SER   432      14.320  36.826  55.883  1.00 64.22           C  
ATOM   3324  O   SER   432      14.755  35.700  56.150  1.00 63.59           O  
ATOM   3325  CB  SER   432      15.376  38.915  56.771  1.00 62.93           C  
ATOM   3326  OG  SER   432      16.518  38.491  57.521  1.00 62.22           O  
ATOM   3327  N   GLN   433      13.897  37.176  54.675  1.00 64.53           N  
ATOM   3328  CA  GLN   433      13.890  36.257  53.551  1.00 64.83           C  
ATOM   3329  C   GLN   433      14.243  37.037  52.303  1.00 66.12           C  
ATOM   3330  O   GLN   433      13.609  38.038  51.995  1.00 64.22           O  
ATOM   3331  CB  GLN   433      12.503  35.645  53.391  1.00 63.12           C  
ATOM   3332  CG  GLN   433      12.286  34.935  52.083  1.00 61.22           C  
ATOM   3333  CD  GLN   433      13.009  33.623  52.021  1.00 61.81           C  
ATOM   3334  OE1 GLN   433      13.014  32.867  53.001  1.00 61.91           O  
ATOM   3335  NE2 GLN   433      13.616  33.321  50.866  1.00 58.69           N  
ATOM   3336  N   ILE   434      15.263  36.571  51.593  1.00 69.20           N  
ATOM   3337  CA  ILE   434      15.715  37.229  50.377  1.00 72.35           C  
ATOM   3338  C   ILE   434      14.969  36.697  49.164  1.00 73.45           C  
ATOM   3339  O   ILE   434      14.593  35.527  49.114  1.00 72.73           O  
ATOM   3340  CB  ILE   434      17.248  37.024  50.163  1.00 73.51           C  
ATOM   3341  CG1 ILE   434      18.024  37.634  51.339  1.00 74.36           C  
ATOM   3342  CG2 ILE   434      17.692  37.647  48.846  1.00 71.51           C  
ATOM   3343  CD1 ILE   434      17.862  39.133  51.482  1.00 75.29           C  
ATOM   3344  N   LEU   435      14.758  37.574  48.192  1.00 75.09           N  
ATOM   3345  CA  LEU   435      14.073  37.214  46.963  1.00 78.54           C  
ATOM   3346  C   LEU   435      14.667  38.145  45.911  1.00 80.79           C  
ATOM   3347  O   LEU   435      14.323  39.328  45.854  1.00 79.86           O  
ATOM   3348  CB  LEU   435      12.559  37.434  47.120  1.00 78.73           C  
ATOM   3349  CG  LEU   435      11.603  36.787  46.111  1.00 78.79           C  
ATOM   3350  CD1 LEU   435      10.169  36.994  46.563  1.00 78.83           C  
ATOM   3351  CD2 LEU   435      11.822  37.381  44.726  1.00 78.56           C  
ATOM   3352  N   ASN   436      15.569  37.600  45.090  1.00 84.19           N  
ATOM   3353  CA  ASN   436      16.274  38.370  44.055  1.00 86.14           C  
ATOM   3354  C   ASN   436      15.351  39.053  43.064  1.00 87.85           C  
ATOM   3355  O   ASN   436      14.460  38.432  42.503  1.00 88.11           O  
ATOM   3356  CB  ASN   436      17.297  37.478  43.354  1.00 85.32           C  
ATOM   3357  CG  ASN   436      18.254  36.808  44.345  1.00 84.74           C  
ATOM   3358  OD1 ASN   436      18.461  37.299  45.455  1.00 82.94           O  
ATOM   3359  ND2 ASN   436      18.844  35.692  43.941  1.00 85.31           N  
ATOM   3360  N   VAL   437      15.606  40.345  42.862  1.00 91.02           N  
ATOM   3361  CA  VAL   437      14.801  41.244  42.034  1.00 94.25           C  
ATOM   3362  C   VAL   437      14.242  40.875  40.643  1.00 96.47           C  
ATOM   3363  O   VAL   437      13.060  41.133  40.385  1.00 97.05           O  
ATOM   3364  CB  VAL   437      15.489  42.650  41.966  1.00 95.19           C  
ATOM   3365  CG1 VAL   437      16.833  42.558  41.273  1.00 96.70           C  
ATOM   3366  CG2 VAL   437      14.571  43.654  41.278  1.00 95.32           C  
ATOM   3367  N   PRO   438      15.054  40.305  39.722  1.00 97.89           N  
ATOM   3368  CA  PRO   438      14.426  39.983  38.426  1.00 98.05           C  
ATOM   3369  C   PRO   438      13.326  38.957  38.696  1.00 98.73           C  
ATOM   3370  O   PRO   438      13.587  37.755  38.766  1.00 98.98           O  
ATOM   3371  CB  PRO   438      15.574  39.379  37.616  1.00 97.76           C  
ATOM   3372  CG  PRO   438      16.801  39.983  38.240  1.00 98.23           C  
ATOM   3373  CD  PRO   438      16.479  39.932  39.716  1.00 98.00           C  
ATOM   3374  N   LEU   439      12.100  39.431  38.872  1.00 99.19           N  
ATOM   3375  CA  LEU   439      11.000  38.530  39.171  1.00 99.12           C  
ATOM   3376  C   LEU   439       9.855  38.740  38.206  1.00 99.09           C  
ATOM   3377  O   LEU   439       9.476  39.878  37.905  1.00 97.78           O  
ATOM   3378  CB  LEU   439      10.523  38.746  40.612  1.00 99.18           C  
ATOM   3379  CG  LEU   439       9.556  37.710  41.188  1.00 99.34           C  
ATOM   3380  CD1 LEU   439      10.187  36.331  41.109  1.00 99.23           C  
ATOM   3381  CD2 LEU   439       9.221  38.060  42.631  1.00100.08           C  
ATOM   3382  N   ARG   440       9.307  37.629  37.727  1.00 99.55           N  
ATOM   3383  CA  ARG   440       8.206  37.663  36.780  1.00100.12           C  
ATOM   3384  C   ARG   440       7.058  36.770  37.217  1.00 99.18           C  
ATOM   3385  O   ARG   440       7.274  35.663  37.708  1.00 98.60           O  
ATOM   3386  CB  ARG   440       8.708  37.234  35.401  1.00102.04           C  
ATOM   3387  CG  ARG   440       9.632  38.252  34.753  1.00105.17           C  
ATOM   3388  CD  ARG   440      10.368  37.669  33.555  1.00107.50           C  
ATOM   3389  NE  ARG   440      11.251  36.575  33.954  1.00108.82           N  
ATOM   3390  CZ  ARG   440      12.046  35.911  33.120  1.00108.98           C  
ATOM   3391  NH1 ARG   440      12.073  36.231  31.830  1.00109.58           N  
ATOM   3392  NH2 ARG   440      12.812  34.927  33.577  1.00107.31           N  
ATOM   3393  N   GLU   441       5.839  37.270  37.034  1.00 98.47           N  
ATOM   3394  CA  GLU   441       4.624  36.543  37.389  1.00 98.07           C  
ATOM   3395  C   GLU   441       4.774  35.022  37.320  1.00 98.27           C  
ATOM   3396  O   GLU   441       4.696  34.328  38.333  1.00 96.98           O  
ATOM   3397  CB  GLU   441       3.472  36.976  36.467  1.00 97.87           C  
ATOM   3398  CG  GLU   441       2.655  38.176  36.959  1.00 96.22           C  
ATOM   3399  CD  GLU   441       1.281  37.774  37.499  1.00 94.70           C  
ATOM   3400  OE1 GLU   441       1.184  36.752  38.215  1.00 92.70           O  
ATOM   3401  OE2 GLU   441       0.298  38.490  37.216  1.00 93.59           O  
ATOM   3402  N   GLU   442       5.012  34.514  36.117  1.00 99.34           N  
ATOM   3403  CA  GLU   442       5.123  33.076  35.897  1.00100.22           C  
ATOM   3404  C   GLU   442       6.396  32.373  36.399  1.00 99.72           C  
ATOM   3405  O   GLU   442       6.890  31.459  35.739  1.00100.23           O  
ATOM   3406  CB  GLU   442       4.916  32.774  34.401  1.00 99.48           C  
ATOM   3407  N   GLU   443       6.917  32.772  37.556  1.00 98.53           N  
ATOM   3408  CA  GLU   443       8.109  32.122  38.110  1.00 97.47           C  
ATOM   3409  C   GLU   443       7.723  31.454  39.424  1.00 96.61           C  
ATOM   3410  O   GLU   443       8.488  31.423  40.392  1.00 95.83           O  
ATOM   3411  CB  GLU   443       9.230  33.139  38.339  1.00 97.80           C  
ATOM   3412  CG  GLU   443       9.740  33.767  37.060  1.00 98.79           C  
ATOM   3413  CD  GLU   443      11.049  34.493  37.250  1.00 99.76           C  
ATOM   3414  OE1 GLU   443      12.030  33.843  37.675  1.00 98.85           O  
ATOM   3415  OE2 GLU   443      11.097  35.711  36.970  1.00101.08           O  
ATOM   3416  N   ARG   444       6.514  30.908  39.412  1.00 95.98           N  
ATOM   3417  CA  ARG   444       5.894  30.238  40.549  1.00 95.19           C  
ATOM   3418  C   ARG   444       6.783  29.458  41.515  1.00 94.13           C  
ATOM   3419  O   ARG   444       6.556  29.491  42.722  1.00 94.37           O  
ATOM   3420  CB  ARG   444       4.769  29.330  40.051  1.00 94.15           C  
ATOM   3421  N   HIS   445       7.793  28.758  41.024  1.00 92.74           N  
ATOM   3422  CA  HIS   445       8.605  27.986  41.946  1.00 91.04           C  
ATOM   3423  C   HIS   445       9.434  28.795  42.955  1.00 88.56           C  
ATOM   3424  O   HIS   445       9.388  28.538  44.160  1.00 87.28           O  
ATOM   3425  CB  HIS   445       9.521  27.039  41.176  1.00 92.78           C  
ATOM   3426  CG  HIS   445      10.366  26.180  42.063  1.00 95.26           C  
ATOM   3427  ND1 HIS   445       9.827  25.294  42.974  1.00 95.37           N  
ATOM   3428  CD2 HIS   445      11.710  26.112  42.221  1.00 96.05           C  
ATOM   3429  CE1 HIS   445      10.803  24.719  43.656  1.00 96.00           C  
ATOM   3430  NE2 HIS   445      11.956  25.198  43.218  1.00 96.62           N  
ATOM   3431  N   ARG   446      10.183  29.777  42.474  1.00 85.80           N  
ATOM   3432  CA  ARG   446      11.026  30.550  43.373  1.00 83.17           C  
ATOM   3433  C   ARG   446      10.257  31.370  44.410  1.00 82.01           C  
ATOM   3434  O   ARG   446      10.481  31.224  45.614  1.00 81.48           O  
ATOM   3435  CB  ARG   446      11.954  31.472  42.573  1.00 81.52           C  
ATOM   3436  CG  ARG   446      13.395  31.513  43.082  1.00 79.01           C  
ATOM   3437  CD  ARG   446      14.050  32.836  42.712  1.00 79.07           C  
ATOM   3438  NE  ARG   446      13.729  33.228  41.342  1.00 77.93           N  
ATOM   3439  CZ  ARG   446      13.788  34.475  40.887  1.00 77.82           C  
ATOM   3440  NH1 ARG   446      14.154  35.459  41.692  1.00 77.88           N  
ATOM   3441  NH2 ARG   446      13.474  34.741  39.626  1.00 78.13           N  
ATOM   3442  N   TRP   447       9.345  32.223  43.960  1.00 80.42           N  
ATOM   3443  CA  TRP   447       8.626  33.051  44.910  1.00 79.75           C  
ATOM   3444  C   TRP   447       7.647  32.348  45.853  1.00 79.40           C  
ATOM   3445  O   TRP   447       7.453  32.810  46.972  1.00 79.31           O  
ATOM   3446  CB  TRP   447       7.945  34.231  44.207  1.00 79.05           C  
ATOM   3447  CG  TRP   447       6.848  33.912  43.253  1.00 79.39           C  
ATOM   3448  CD1 TRP   447       6.945  33.817  41.896  1.00 79.71           C  
ATOM   3449  CD2 TRP   447       5.457  33.777  43.564  1.00 79.97           C  
ATOM   3450  NE1 TRP   447       5.699  33.646  41.339  1.00 79.51           N  
ATOM   3451  CE2 TRP   447       4.767  33.619  42.342  1.00 80.10           C  
ATOM   3452  CE3 TRP   447       4.723  33.780  44.758  1.00 79.53           C  
ATOM   3453  CZ2 TRP   447       3.376  33.468  42.281  1.00 79.48           C  
ATOM   3454  CZ3 TRP   447       3.341  33.628  44.695  1.00 78.13           C  
ATOM   3455  CH2 TRP   447       2.684  33.475  43.466  1.00 78.28           C  
ATOM   3456  N   GLU   448       7.031  31.246  45.437  1.00 78.76           N  
ATOM   3457  CA  GLU   448       6.119  30.557  46.347  1.00 78.69           C  
ATOM   3458  C   GLU   448       6.924  30.041  47.537  1.00 78.31           C  
ATOM   3459  O   GLU   448       6.443  29.999  48.672  1.00 78.83           O  
ATOM   3460  CB  GLU   448       5.406  29.377  45.666  1.00 79.68           C  
ATOM   3461  CG  GLU   448       4.414  29.783  44.566  1.00 80.69           C  
ATOM   3462  CD  GLU   448       3.314  28.751  44.348  1.00 79.85           C  
ATOM   3463  OE1 GLU   448       3.616  27.538  44.371  1.00 79.77           O  
ATOM   3464  OE2 GLU   448       2.150  29.162  44.144  1.00 78.03           O  
ATOM   3465  N   ASN   449       8.158  29.641  47.280  1.00 77.42           N  
ATOM   3466  CA  ASN   449       8.990  29.155  48.363  1.00 76.32           C  
ATOM   3467  C   ASN   449       9.466  30.350  49.206  1.00 74.54           C  
ATOM   3468  O   ASN   449       9.367  30.324  50.436  1.00 74.07           O  
ATOM   3469  CB  ASN   449      10.167  28.341  47.798  1.00 77.23           C  
ATOM   3470  CG  ASN   449       9.737  26.961  47.295  1.00 76.85           C  
ATOM   3471  OD1 ASN   449       8.791  26.838  46.516  1.00 77.04           O  
ATOM   3472  ND2 ASN   449      10.438  25.923  47.736  1.00 76.34           N  
ATOM   3473  N   ALA   450       9.957  31.403  48.553  1.00 71.90           N  
ATOM   3474  CA  ALA   450      10.417  32.578  49.285  1.00 69.69           C  
ATOM   3475  C   ALA   450       9.325  32.988  50.270  1.00 69.06           C  
ATOM   3476  O   ALA   450       9.602  33.286  51.436  1.00 68.21           O  
ATOM   3477  CB  ALA   450      10.716  33.720  48.321  1.00 68.92           C  
ATOM   3478  N   LEU   451       8.081  32.979  49.791  1.00 67.35           N  
ATOM   3479  CA  LEU   451       6.932  33.343  50.603  1.00 65.40           C  
ATOM   3480  C   LEU   451       6.769  32.384  51.762  1.00 65.21           C  
ATOM   3481  O   LEU   451       6.316  32.776  52.838  1.00 65.37           O  
ATOM   3482  CB  LEU   451       5.665  33.351  49.754  1.00 65.42           C  
ATOM   3483  CG  LEU   451       5.039  34.714  49.435  1.00 66.59           C  
ATOM   3484  CD1 LEU   451       6.106  35.781  49.206  1.00 66.15           C  
ATOM   3485  CD2 LEU   451       4.147  34.563  48.204  1.00 65.91           C  
ATOM   3486  N   LEU   452       7.135  31.126  51.557  1.00 64.26           N  
ATOM   3487  CA  LEU   452       7.025  30.157  52.639  1.00 64.26           C  
ATOM   3488  C   LEU   452       8.072  30.401  53.735  1.00 64.39           C  
ATOM   3489  O   LEU   452       7.779  30.242  54.928  1.00 63.61           O  
ATOM   3490  CB  LEU   452       7.151  28.734  52.095  1.00 64.86           C  
ATOM   3491  CG  LEU   452       5.905  28.180  51.404  1.00 65.27           C  
ATOM   3492  CD1 LEU   452       6.292  27.008  50.531  1.00 65.89           C  
ATOM   3493  CD2 LEU   452       4.871  27.768  52.440  1.00 62.60           C  
ATOM   3494  N   GLY   453       9.284  30.790  53.335  1.00 63.39           N  
ATOM   3495  CA  GLY   453      10.325  31.048  54.318  1.00 64.16           C  
ATOM   3496  C   GLY   453       9.997  32.271  55.155  1.00 63.73           C  
ATOM   3497  O   GLY   453      10.199  32.297  56.376  1.00 62.75           O  
ATOM   3498  N   LEU   454       9.486  33.290  54.473  1.00 62.79           N  
ATOM   3499  CA  LEU   454       9.093  34.525  55.112  1.00 62.41           C  
ATOM   3500  C   LEU   454       8.059  34.193  56.198  1.00 61.23           C  
ATOM   3501  O   LEU   454       8.178  34.644  57.346  1.00 60.74           O  
ATOM   3502  CB  LEU   454       8.503  35.477  54.059  1.00 63.32           C  
ATOM   3503  CG  LEU   454       8.546  37.017  54.194  1.00 65.10           C  
ATOM   3504  CD1 LEU   454       7.134  37.555  54.338  1.00 65.05           C  
ATOM   3505  CD2 LEU   454       9.424  37.452  55.365  1.00 65.74           C  
ATOM   3506  N   LEU   455       7.079  33.362  55.850  1.00 59.72           N  
ATOM   3507  CA  LEU   455       6.020  33.008  56.794  1.00 60.24           C  
ATOM   3508  C   LEU   455       6.484  32.094  57.910  1.00 59.72           C  
ATOM   3509  O   LEU   455       6.103  32.276  59.069  1.00 58.97           O  
ATOM   3510  CB  LEU   455       4.820  32.373  56.062  1.00 60.75           C  
ATOM   3511  CG  LEU   455       3.989  33.269  55.131  1.00 59.94           C  
ATOM   3512  CD1 LEU   455       3.138  32.408  54.250  1.00 59.53           C  
ATOM   3513  CD2 LEU   455       3.133  34.227  55.925  1.00 59.15           C  
ATOM   3514  N   ALA   456       7.298  31.106  57.561  1.00 60.17           N  
ATOM   3515  CA  ALA   456       7.823  30.175  58.555  1.00 60.06           C  
ATOM   3516  C   ALA   456       8.624  30.955  59.594  1.00 60.28           C  
ATOM   3517  O   ALA   456       8.566  30.655  60.789  1.00 59.15           O  
ATOM   3518  CB  ALA   456       8.707  29.141  57.886  1.00 60.54           C  
ATOM   3519  N   LYS   457       9.361  31.958  59.122  1.00 60.97           N  
ATOM   3520  CA  LYS   457      10.174  32.802  59.988  1.00 63.58           C  
ATOM   3521  C   LYS   457       9.310  33.738  60.813  1.00 64.57           C  
ATOM   3522  O   LYS   457       9.644  34.070  61.948  1.00 65.77           O  
ATOM   3523  CB  LYS   457      11.171  33.621  59.160  1.00 63.49           C  
ATOM   3524  CG  LYS   457      12.306  32.780  58.600  1.00 65.51           C  
ATOM   3525  CD  LYS   457      13.165  33.544  57.604  1.00 65.97           C  
ATOM   3526  CE  LYS   457      14.015  32.576  56.780  1.00 66.12           C  
ATOM   3527  NZ  LYS   457      14.828  33.275  55.741  1.00 65.64           N  
ATOM   3528  N   ALA   458       8.194  34.166  60.240  1.00 64.66           N  
ATOM   3529  CA  ALA   458       7.298  35.062  60.940  1.00 63.69           C  
ATOM   3530  C   ALA   458       6.669  34.391  62.151  1.00 62.73           C  
ATOM   3531  O   ALA   458       5.910  35.015  62.877  1.00 62.93           O  
ATOM   3532  CB  ALA   458       6.220  35.547  59.993  1.00 64.34           C  
ATOM   3533  N   GLY   459       6.994  33.127  62.375  1.00 63.10           N  
ATOM   3534  CA  GLY   459       6.427  32.405  63.503  1.00 64.91           C  
ATOM   3535  C   GLY   459       5.185  31.656  63.054  1.00 66.83           C  
ATOM   3536  O   GLY   459       4.467  31.025  63.838  1.00 66.40           O  
ATOM   3537  N   LEU   460       4.942  31.719  61.756  1.00 67.91           N  
ATOM   3538  CA  LEU   460       3.795  31.074  61.182  1.00 69.78           C  
ATOM   3539  C   LEU   460       4.116  29.664  60.684  1.00 70.34           C  
ATOM   3540  O   LEU   460       5.007  29.473  59.870  1.00 71.78           O  
ATOM   3541  CB  LEU   460       3.287  31.938  60.053  1.00 72.34           C  
ATOM   3542  CG  LEU   460       1.951  31.526  59.467  1.00 76.66           C  
ATOM   3543  CD1 LEU   460       0.855  31.575  60.530  1.00 76.70           C  
ATOM   3544  CD2 LEU   460       1.644  32.475  58.326  1.00 79.44           C  
ATOM   3545  N   GLN   461       3.375  28.679  61.177  1.00 69.76           N  
ATOM   3546  CA  GLN   461       3.576  27.289  60.788  1.00 68.59           C  
ATOM   3547  C   GLN   461       2.760  26.843  59.566  1.00 66.95           C  
ATOM   3548  O   GLN   461       1.694  26.238  59.684  1.00 64.83           O  
ATOM   3549  CB  GLN   461       3.263  26.392  61.974  1.00 70.27           C  
ATOM   3550  CG  GLN   461       3.561  24.941  61.752  1.00 72.88           C  
ATOM   3551  CD  GLN   461       3.683  24.214  63.062  1.00 76.21           C  
ATOM   3552  OE1 GLN   461       3.032  24.584  64.047  1.00 77.16           O  
ATOM   3553  NE2 GLN   461       4.511  23.169  63.092  1.00 77.22           N  
ATOM   3554  N   VAL   462       3.302  27.157  58.396  1.00 66.06           N  
ATOM   3555  CA  VAL   462       2.729  26.830  57.100  1.00 65.72           C  
ATOM   3556  C   VAL   462       2.292  25.381  56.927  1.00 66.48           C  
ATOM   3557  O   VAL   462       1.133  25.105  56.610  1.00 66.90           O  
ATOM   3558  CB  VAL   462       3.742  27.133  56.002  1.00 64.49           C  
ATOM   3559  CG1 VAL   462       3.473  26.260  54.800  1.00 63.68           C  
ATOM   3560  CG2 VAL   462       3.683  28.598  55.643  1.00 64.45           C  
ATOM   3561  N   VAL   463       3.239  24.468  57.105  1.00 66.83           N  
ATOM   3562  CA  VAL   463       2.992  23.044  56.959  1.00 67.98           C  
ATOM   3563  C   VAL   463       3.602  22.259  58.094  1.00 68.60           C  
ATOM   3564  O   VAL   463       4.584  22.682  58.686  1.00 69.47           O  
ATOM   3565  CB  VAL   463       3.617  22.500  55.670  1.00 69.08           C  
ATOM   3566  CG1 VAL   463       3.567  20.979  55.678  1.00 69.81           C  
ATOM   3567  CG2 VAL   463       2.886  23.046  54.453  1.00 69.83           C  
ATOM   3568  N   ALA   464       3.022  21.103  58.380  1.00 69.70           N  
ATOM   3569  CA  ALA   464       3.529  20.229  59.425  1.00 72.30           C  
ATOM   3570  C   ALA   464       3.805  18.852  58.807  1.00 74.52           C  
ATOM   3571  O   ALA   464       3.051  18.384  57.954  1.00 74.47           O  
ATOM   3572  CB  ALA   464       2.521  20.112  60.552  1.00 71.04           C  
ATOM   3573  N   LEU   465       4.900  18.219  59.222  1.00 76.38           N  
ATOM   3574  CA  LEU   465       5.264  16.905  58.703  1.00 77.84           C  
ATOM   3575  C   LEU   465       4.616  15.832  59.569  1.00 78.78           C  
ATOM   3576  O   LEU   465       4.476  16.025  60.779  1.00 78.89           O  
ATOM   3577  CB  LEU   465       6.787  16.747  58.695  1.00 78.40           C  
ATOM   3578  CG  LEU   465       7.559  17.587  57.665  1.00 78.96           C  
ATOM   3579  CD1 LEU   465       9.050  17.574  57.985  1.00 79.72           C  
ATOM   3580  CD2 LEU   465       7.317  17.041  56.271  1.00 77.67           C  
ATOM   3581  N   SER   466       4.214  14.725  58.936  1.00 79.81           N  
ATOM   3582  CA  SER   466       3.549  13.588  59.596  1.00 80.82           C  
ATOM   3583  C   SER   466       3.950  13.415  61.045  1.00 80.84           C  
ATOM   3584  O   SER   466       3.274  13.917  61.938  1.00 81.56           O  
ATOM   3585  CB  SER   466       3.839  12.291  58.838  1.00 82.93           C  
ATOM   3586  OG  SER   466       5.235  12.037  58.766  1.00 84.15           O  
ATOM   3587  N   GLY   467       5.042  12.695  61.287  1.00 81.00           N  
ATOM   3588  CA  GLY   467       5.502  12.525  62.654  1.00 81.37           C  
ATOM   3589  C   GLY   467       6.572  11.474  62.865  1.00 81.75           C  
ATOM   3590  O   GLY   467       7.041  10.835  61.920  1.00 82.48           O  
ATOM   3591  N   ALA   468       6.974  11.322  64.124  1.00 81.68           N  
ATOM   3592  CA  ALA   468       7.961  10.327  64.533  1.00 80.99           C  
ATOM   3593  C   ALA   468       9.324  10.361  63.839  1.00 80.19           C  
ATOM   3594  O   ALA   468       9.623   9.523  62.979  1.00 79.92           O  
ATOM   3595  CB  ALA   468       7.351   8.924  64.402  1.00 82.22           C  
ATOM   3596  N   TYR   469      10.151  11.328  64.222  1.00 78.24           N  
ATOM   3597  CA  TYR   469      11.495  11.428  63.675  1.00 76.47           C  
ATOM   3598  C   TYR   469      12.491  11.352  64.831  1.00 75.83           C  
ATOM   3599  O   TYR   469      12.132  11.577  65.994  1.00 76.20           O  
ATOM   3600  CB  TYR   469      11.698  12.743  62.938  1.00 75.45           C  
ATOM   3601  CG  TYR   469      10.840  12.942  61.714  1.00 75.83           C  
ATOM   3602  CD1 TYR   469       9.533  13.408  61.824  1.00 77.11           C  
ATOM   3603  CD2 TYR   469      11.365  12.760  60.438  1.00 75.21           C  
ATOM   3604  CE1 TYR   469       8.771  13.704  60.692  1.00 76.69           C  
ATOM   3605  CE2 TYR   469      10.616  13.050  59.299  1.00 76.12           C  
ATOM   3606  CZ  TYR   469       9.319  13.528  59.432  1.00 77.17           C  
ATOM   3607  OH  TYR   469       8.586  13.861  58.306  1.00 78.60           O  
ATOM   3608  N   PRO   470      13.758  11.020  64.534  1.00 74.43           N  
ATOM   3609  CA  PRO   470      14.756  10.935  65.600  1.00 73.59           C  
ATOM   3610  C   PRO   470      14.874  12.222  66.436  1.00 72.92           C  
ATOM   3611  O   PRO   470      14.674  12.205  67.653  1.00 73.08           O  
ATOM   3612  CB  PRO   470      16.034  10.607  64.836  1.00 72.97           C  
ATOM   3613  CG  PRO   470      15.528   9.766  63.727  1.00 72.63           C  
ATOM   3614  CD  PRO   470      14.313  10.518  63.265  1.00 73.00           C  
ATOM   3615  N   ALA   471      15.193  13.334  65.781  1.00 71.13           N  
ATOM   3616  CA  ALA   471      15.343  14.602  66.480  1.00 69.59           C  
ATOM   3617  C   ALA   471      14.063  15.442  66.455  1.00 68.79           C  
ATOM   3618  O   ALA   471      13.316  15.422  65.484  1.00 69.37           O  
ATOM   3619  CB  ALA   471      16.487  15.385  65.865  1.00 68.16           C  
ATOM   3620  N   GLU   472      13.803  16.170  67.533  1.00 67.55           N  
ATOM   3621  CA  GLU   472      12.632  17.025  67.578  1.00 66.34           C  
ATOM   3622  C   GLU   472      13.095  18.461  67.347  1.00 64.82           C  
ATOM   3623  O   GLU   472      12.304  19.401  67.416  1.00 65.70           O  
ATOM   3624  CB  GLU   472      11.911  16.889  68.923  1.00 69.32           C  
ATOM   3625  CG  GLU   472      12.669  17.392  70.137  1.00 74.14           C  
ATOM   3626  CD  GLU   472      11.908  17.152  71.442  1.00 77.40           C  
ATOM   3627  OE1 GLU   472      10.710  17.519  71.521  1.00 79.69           O  
ATOM   3628  OE2 GLU   472      12.508  16.606  72.392  1.00 77.27           O  
ATOM   3629  N   LEU   473      14.392  18.605  67.073  1.00 61.73           N  
ATOM   3630  CA  LEU   473      15.036  19.880  66.790  1.00 58.59           C  
ATOM   3631  C   LEU   473      16.234  19.560  65.920  1.00 57.54           C  
ATOM   3632  O   LEU   473      17.077  18.783  66.342  1.00 59.96           O  
ATOM   3633  CB  LEU   473      15.538  20.550  68.070  1.00 58.06           C  
ATOM   3634  CG  LEU   473      16.521  21.715  67.809  1.00 59.46           C  
ATOM   3635  CD1 LEU   473      15.854  22.782  66.961  1.00 57.23           C  
ATOM   3636  CD2 LEU   473      17.009  22.320  69.126  1.00 59.28           C  
ATOM   3637  N   ALA   474      16.327  20.142  64.725  1.00 54.50           N  
ATOM   3638  CA  ALA   474      17.463  19.871  63.839  1.00 52.49           C  
ATOM   3639  C   ALA   474      18.077  21.167  63.396  1.00 53.04           C  
ATOM   3640  O   ALA   474      17.388  22.015  62.846  1.00 53.89           O  
ATOM   3641  CB  ALA   474      17.011  19.097  62.617  1.00 52.75           C  
ATOM   3642  N   VAL   475      19.373  21.342  63.603  1.00 52.65           N  
ATOM   3643  CA  VAL   475      19.961  22.595  63.190  1.00 52.65           C  
ATOM   3644  C   VAL   475      21.160  22.484  62.286  1.00 53.23           C  
ATOM   3645  O   VAL   475      22.094  21.755  62.569  1.00 52.96           O  
ATOM   3646  CB  VAL   475      20.290  23.498  64.413  1.00 52.11           C  
ATOM   3647  CG1 VAL   475      20.180  22.713  65.690  1.00 52.05           C  
ATOM   3648  CG2 VAL   475      21.664  24.129  64.251  1.00 51.25           C  
ATOM   3649  N   GLY   476      21.103  23.229  61.186  1.00 54.26           N  
ATOM   3650  CA  GLY   476      22.183  23.238  60.223  1.00 59.06           C  
ATOM   3651  C   GLY   476      23.190  24.330  60.532  1.00 62.56           C  
ATOM   3652  O   GLY   476      22.830  25.365  61.097  1.00 63.14           O  
ATOM   3653  N   PHE   477      24.454  24.091  60.189  1.00 64.87           N  
ATOM   3654  CA  PHE   477      25.509  25.066  60.426  1.00 67.11           C  
ATOM   3655  C   PHE   477      26.152  25.454  59.115  1.00 70.31           C  
ATOM   3656  O   PHE   477      26.238  24.652  58.189  1.00 70.80           O  
ATOM   3657  CB  PHE   477      26.564  24.519  61.373  1.00 65.03           C  
ATOM   3658  CG  PHE   477      26.047  24.253  62.738  1.00 65.27           C  
ATOM   3659  CD1 PHE   477      25.230  23.158  62.979  1.00 66.15           C  
ATOM   3660  CD2 PHE   477      26.319  25.127  63.775  1.00 64.65           C  
ATOM   3661  CE1 PHE   477      24.685  22.942  64.244  1.00 67.44           C  
ATOM   3662  CE2 PHE   477      25.782  24.926  65.040  1.00 66.38           C  
ATOM   3663  CZ  PHE   477      24.960  23.831  65.279  1.00 66.69           C  
ATOM   3664  N   ASP   478      26.605  26.697  59.040  1.00 74.12           N  
ATOM   3665  CA  ASP   478      27.212  27.187  57.821  1.00 77.69           C  
ATOM   3666  C   ASP   478      28.273  28.250  58.077  1.00 79.17           C  
ATOM   3667  O   ASP   478      28.054  29.205  58.829  1.00 78.70           O  
ATOM   3668  CB  ASP   478      26.118  27.737  56.905  1.00 79.42           C  
ATOM   3669  CG  ASP   478      26.672  28.385  55.665  1.00 81.71           C  
ATOM   3670  OD1 ASP   478      27.332  29.431  55.796  1.00 84.66           O  
ATOM   3671  OD2 ASP   478      26.455  27.853  54.560  1.00 83.29           O  
ATOM   3672  N   ALA   479      29.429  28.062  57.443  1.00 80.41           N  
ATOM   3673  CA  ALA   479      30.548  28.993  57.553  1.00 81.96           C  
ATOM   3674  C   ALA   479      30.863  29.489  56.134  1.00 82.56           C  
ATOM   3675  O   ALA   479      31.940  30.022  55.858  1.00 82.11           O  
ATOM   3676  CB  ALA   479      31.761  28.289  58.174  1.00 80.91           C  
ATOM   3677  N   GLY   480      29.891  29.291  55.248  1.00 83.91           N  
ATOM   3678  CA  GLY   480      29.998  29.702  53.857  1.00 85.47           C  
ATOM   3679  C   GLY   480      31.371  29.636  53.225  1.00 86.12           C  
ATOM   3680  O   GLY   480      32.058  30.646  53.139  1.00 86.47           O  
ATOM   3681  N   GLY   481      31.773  28.453  52.778  1.00 87.37           N  
ATOM   3682  CA  GLY   481      33.072  28.310  52.149  1.00 88.80           C  
ATOM   3683  C   GLY   481      34.242  28.308  53.115  1.00 90.41           C  
ATOM   3684  O   GLY   481      35.184  27.532  52.942  1.00 89.49           O  
ATOM   3685  N   ARG   482      34.187  29.165  54.135  1.00 92.39           N  
ATOM   3686  CA  ARG   482      35.268  29.256  55.123  1.00 94.48           C  
ATOM   3687  C   ARG   482      35.453  27.955  55.904  1.00 93.95           C  
ATOM   3688  O   ARG   482      34.539  27.503  56.590  1.00 95.02           O  
ATOM   3689  CB  ARG   482      35.010  30.408  56.105  1.00 96.04           C  
ATOM   3690  CG  ARG   482      34.852  31.768  55.439  1.00100.17           C  
ATOM   3691  CD  ARG   482      35.232  32.923  56.366  1.00102.80           C  
ATOM   3692  NE  ARG   482      36.649  32.880  56.721  1.00105.41           N  
ATOM   3693  CZ  ARG   482      37.146  32.178  57.734  1.00107.00           C  
ATOM   3694  NH1 ARG   482      36.339  31.462  58.509  1.00107.90           N  
ATOM   3695  NH2 ARG   482      38.450  32.186  57.969  1.00108.18           N  
ATOM   3696  N   GLU   483      36.643  27.369  55.808  1.00 92.62           N  
ATOM   3697  CA  GLU   483      36.943  26.116  56.480  1.00 91.36           C  
ATOM   3698  C   GLU   483      37.040  26.177  58.012  1.00 91.43           C  
ATOM   3699  O   GLU   483      37.798  25.412  58.605  1.00 91.71           O  
ATOM   3700  CB  GLU   483      38.225  25.523  55.904  1.00 90.34           C  
ATOM   3701  N   SER   484      36.280  27.063  58.655  1.00 91.34           N  
ATOM   3702  CA  SER   484      36.277  27.159  60.126  1.00 91.48           C  
ATOM   3703  C   SER   484      35.218  28.157  60.599  1.00 90.68           C  
ATOM   3704  O   SER   484      34.873  29.083  59.871  1.00 89.54           O  
ATOM   3705  CB  SER   484      37.642  27.588  60.657  1.00 91.50           C  
ATOM   3706  OG  SER   484      37.767  28.998  60.630  1.00 94.91           O  
ATOM   3707  N   PHE   485      34.722  27.985  61.822  1.00 90.60           N  
ATOM   3708  CA  PHE   485      33.676  28.865  62.341  1.00 91.42           C  
ATOM   3709  C   PHE   485      34.054  30.101  63.135  1.00 92.33           C  
ATOM   3710  O   PHE   485      33.250  30.608  63.917  1.00 90.61           O  
ATOM   3711  CB  PHE   485      32.675  28.074  63.170  1.00 91.82           C  
ATOM   3712  CG  PHE   485      31.661  27.351  62.349  1.00 92.06           C  
ATOM   3713  CD1 PHE   485      31.955  26.114  61.788  1.00 92.59           C  
ATOM   3714  CD2 PHE   485      30.429  27.933  62.086  1.00 91.29           C  
ATOM   3715  CE1 PHE   485      31.038  25.469  60.970  1.00 92.29           C  
ATOM   3716  CE2 PHE   485      29.505  27.299  61.271  1.00 91.80           C  
ATOM   3717  CZ  PHE   485      29.809  26.062  60.710  1.00 92.15           C  
ATOM   3718  N   ARG   486      35.266  30.591  62.947  1.00 94.68           N  
ATOM   3719  CA  ARG   486      35.687  31.792  63.645  1.00 96.24           C  
ATOM   3720  C   ARG   486      35.109  32.893  62.776  1.00 96.95           C  
ATOM   3721  O   ARG   486      34.168  33.614  63.130  1.00 97.63           O  
ATOM   3722  CB  ARG   486      37.211  31.874  63.629  1.00 96.08           C  
ATOM   3723  CG  ARG   486      37.823  32.746  64.693  1.00 96.93           C  
ATOM   3724  CD  ARG   486      38.939  33.582  64.100  1.00 99.26           C  
ATOM   3725  NE  ARG   486      40.310  33.184  64.428  1.00101.19           N  
ATOM   3726  CZ  ARG   486      41.373  33.916  64.095  1.00102.21           C  
ATOM   3727  NH1 ARG   486      41.203  35.047  63.442  1.00102.28           N  
ATOM   3728  NH2 ARG   486      42.603  33.543  64.414  1.00101.93           N  
ATOM   3729  N   PHE   487      35.666  32.959  61.585  1.00 96.79           N  
ATOM   3730  CA  PHE   487      35.287  33.962  60.636  1.00 96.17           C  
ATOM   3731  C   PHE   487      33.946  33.831  60.022  1.00 95.34           C  
ATOM   3732  O   PHE   487      33.775  33.531  58.835  1.00 96.58           O  
ATOM   3733  CB  PHE   487      36.393  34.052  59.634  1.00 96.46           C  
ATOM   3734  CG  PHE   487      37.624  34.505  60.273  1.00 96.31           C  
ATOM   3735  CD1 PHE   487      37.539  35.580  61.139  1.00 96.10           C  
ATOM   3736  CD2 PHE   487      38.842  33.895  60.060  1.00 96.33           C  
ATOM   3737  CE1 PHE   487      38.627  36.024  61.819  1.00 95.50           C  
ATOM   3738  CE2 PHE   487      39.954  34.342  60.746  1.00 95.96           C  
ATOM   3739  CZ  PHE   487      39.837  35.422  61.606  1.00 94.98           C  
ATOM   3740  N   GLY   488      32.983  34.111  60.879  1.00 93.35           N  
ATOM   3741  CA  GLY   488      31.602  34.022  60.495  1.00 90.98           C  
ATOM   3742  C   GLY   488      30.999  32.840  61.214  1.00 88.15           C  
ATOM   3743  O   GLY   488      31.613  32.224  62.085  1.00 88.43           O  
ATOM   3744  N   GLY   489      29.781  32.517  60.832  1.00 85.17           N  
ATOM   3745  CA  GLY   489      29.104  31.415  61.459  1.00 81.80           C  
ATOM   3746  C   GLY   489      27.641  31.759  61.468  1.00 79.88           C  
ATOM   3747  O   GLY   489      27.248  32.821  61.927  1.00 80.37           O  
ATOM   3748  N   ALA   490      26.832  30.865  60.930  1.00 77.48           N  
ATOM   3749  CA  ALA   490      25.405  31.074  60.876  1.00 73.63           C  
ATOM   3750  C   ALA   490      24.767  29.719  61.097  1.00 72.05           C  
ATOM   3751  O   ALA   490      25.328  28.691  60.737  1.00 70.51           O  
ATOM   3752  CB  ALA   490      25.013  31.632  59.532  1.00 72.13           C  
ATOM   3753  N   ALA   491      23.584  29.729  61.685  1.00 70.90           N  
ATOM   3754  CA  ALA   491      22.876  28.507  61.980  1.00 70.01           C  
ATOM   3755  C   ALA   491      21.375  28.687  61.790  1.00 70.81           C  
ATOM   3756  O   ALA   491      20.829  29.749  62.096  1.00 70.49           O  
ATOM   3757  CB  ALA   491      23.167  28.100  63.413  1.00 69.19           C  
ATOM   3758  N   CYS   492      20.716  27.656  61.267  1.00 70.70           N  
ATOM   3759  CA  CYS   492      19.268  27.689  61.096  1.00 71.54           C  
ATOM   3760  C   CYS   492      18.709  26.470  61.822  1.00 70.66           C  
ATOM   3761  O   CYS   492      19.222  25.366  61.692  1.00 69.51           O  
ATOM   3762  CB  CYS   492      18.872  27.642  59.623  1.00 72.08           C  
ATOM   3763  SG  CYS   492      19.323  26.117  58.795  1.00 79.76           S  
ATOM   3764  N   ALA   493      17.658  26.686  62.597  1.00 70.90           N  
ATOM   3765  CA  ALA   493      17.042  25.620  63.357  1.00 71.94           C  
ATOM   3766  C   ALA   493      15.631  25.349  62.873  1.00 72.42           C  
ATOM   3767  O   ALA   493      14.874  26.275  62.601  1.00 73.23           O  
ATOM   3768  CB  ALA   493      17.018  25.988  64.835  1.00 71.98           C  
ATOM   3769  N   VAL   494      15.284  24.075  62.761  1.00 72.69           N  
ATOM   3770  CA  VAL   494      13.954  23.693  62.339  1.00 73.22           C  
ATOM   3771  C   VAL   494      13.369  22.909  63.495  1.00 74.42           C  
ATOM   3772  O   VAL   494      13.993  21.992  64.021  1.00 72.90           O  
ATOM   3773  CB  VAL   494      13.998  22.855  61.058  1.00 73.08           C  
ATOM   3774  CG1 VAL   494      12.607  22.362  60.698  1.00 73.65           C  
ATOM   3775  CG2 VAL   494      14.546  23.704  59.929  1.00 73.27           C  
ATOM   3776  N   GLY   495      12.167  23.302  63.895  1.00 76.86           N  
ATOM   3777  CA  GLY   495      11.503  22.680  65.017  1.00 79.92           C  
ATOM   3778  C   GLY   495      11.186  21.209  64.940  1.00 82.73           C  
ATOM   3779  O   GLY   495      10.473  20.707  65.809  1.00 83.86           O  
ATOM   3780  N   GLY   496      11.711  20.504  63.941  1.00 85.18           N  
ATOM   3781  CA  GLY   496      11.417  19.083  63.830  1.00 87.81           C  
ATOM   3782  C   GLY   496       9.960  18.971  63.436  1.00 90.22           C  
ATOM   3783  O   GLY   496       9.078  19.504  64.123  1.00 91.12           O  
ATOM   3784  N   ASP   497       9.690  18.287  62.331  1.00 90.96           N  
ATOM   3785  CA  ASP   497       8.321  18.178  61.860  1.00 91.31           C  
ATOM   3786  C   ASP   497       7.727  19.594  61.684  1.00 92.12           C  
ATOM   3787  O   ASP   497       6.687  19.935  62.260  1.00 90.73           O  
ATOM   3788  CB  ASP   497       7.486  17.354  62.843  1.00 90.84           C  
ATOM   3789  N   GLY   498       8.444  20.417  60.916  1.00 93.38           N  
ATOM   3790  CA  GLY   498       8.013  21.772  60.581  1.00 95.00           C  
ATOM   3791  C   GLY   498       7.860  22.935  61.552  1.00 95.84           C  
ATOM   3792  O   GLY   498       7.714  24.068  61.096  1.00 95.78           O  
ATOM   3793  N   GLY   499       7.873  22.697  62.860  1.00 96.64           N  
ATOM   3794  CA  GLY   499       7.719  23.808  63.790  1.00 97.80           C  
ATOM   3795  C   GLY   499       8.861  24.815  63.729  1.00 98.62           C  
ATOM   3796  O   GLY   499       9.339  25.281  64.769  1.00 98.61           O  
ATOM   3797  N   HIS   500       9.287  25.157  62.512  1.00 98.19           N  
ATOM   3798  CA  HIS   500      10.393  26.089  62.270  1.00 99.04           C  
ATOM   3799  C   HIS   500      10.815  27.008  63.436  1.00100.49           C  
ATOM   3800  O   HIS   500      10.015  27.778  63.941  1.00101.06           O  
ATOM   3801  CB  HIS   500      10.078  26.979  61.077  1.00 96.88           C  
ATOM   3802  CG  HIS   500      11.241  27.810  60.651  1.00 96.37           C  
ATOM   3803  ND1 HIS   500      12.205  27.345  59.783  1.00 97.02           N  
ATOM   3804  CD2 HIS   500      11.648  29.040  61.040  1.00 96.19           C  
ATOM   3805  CE1 HIS   500      13.158  28.251  59.657  1.00 96.31           C  
ATOM   3806  NE2 HIS   500      12.845  29.290  60.411  1.00 96.67           N  
ATOM   3807  N   LEU   501      12.086  26.932  63.821  1.00101.76           N  
ATOM   3808  CA  LEU   501      12.651  27.742  64.895  1.00102.44           C  
ATOM   3809  C   LEU   501      13.311  28.987  64.269  1.00102.21           C  
ATOM   3810  O   LEU   501      12.643  29.684  63.524  1.00103.94           O  
ATOM   3811  CB  LEU   501      13.667  26.930  65.671  1.00102.72           C  
ATOM   3812  CG  LEU   501      14.103  27.558  66.982  1.00103.11           C  
ATOM   3813  CD1 LEU   501      12.873  27.701  67.863  1.00102.96           C  
ATOM   3814  CD2 LEU   501      15.165  26.699  67.644  1.00103.63           C  
ATOM   3815  N   LEU   502      14.593  29.295  64.542  1.00101.65           N  
ATOM   3816  CA  LEU   502      15.233  30.392  63.806  1.00100.88           C  
ATOM   3817  C   LEU   502      16.549  30.333  63.135  1.00 98.85           C  
ATOM   3818  O   LEU   502      17.147  29.302  62.825  1.00 97.87           O  
ATOM   3819  CB  LEU   502      15.087  31.793  64.352  1.00102.99           C  
ATOM   3820  N   TRP   503      16.965  31.545  62.892  1.00 96.87           N  
ATOM   3821  CA  TRP   503      18.125  31.843  62.159  1.00 95.68           C  
ATOM   3822  C   TRP   503      18.983  32.665  62.982  1.00 95.58           C  
ATOM   3823  O   TRP   503      18.500  33.601  63.562  1.00 95.38           O  
ATOM   3824  CB  TRP   503      17.801  32.754  61.088  1.00 93.80           C  
ATOM   3825  CG  TRP   503      18.775  32.622  60.239  1.00 92.23           C  
ATOM   3826  CD1 TRP   503      18.970  31.553  59.464  1.00 91.63           C  
ATOM   3827  CD2 TRP   503      19.814  33.545  59.973  1.00 92.13           C  
ATOM   3828  NE1 TRP   503      20.073  31.718  58.703  1.00 91.49           N  
ATOM   3829  CE2 TRP   503      20.616  32.944  58.982  1.00 92.12           C  
ATOM   3830  CE3 TRP   503      20.150  34.832  60.459  1.00 91.53           C  
ATOM   3831  CZ2 TRP   503      21.739  33.567  58.448  1.00 91.22           C  
ATOM   3832  CZ3 TRP   503      21.267  35.459  59.934  1.00 90.71           C  
ATOM   3833  CH2 TRP   503      22.054  34.817  58.925  1.00 91.00           C  
ATOM   3834  N   THR   504      20.269  32.422  62.984  1.00 96.21           N  
ATOM   3835  CA  THR   504      21.006  33.333  63.795  1.00 96.61           C  
ATOM   3836  C   THR   504      22.453  33.241  63.468  1.00 96.47           C  
ATOM   3837  O   THR   504      22.849  32.490  62.594  1.00 95.90           O  
ATOM   3838  CB  THR   504      20.796  32.999  65.235  1.00 97.21           C  
ATOM   3839  OG1 THR   504      21.339  34.045  66.053  1.00 97.80           O  
ATOM   3840  CG2 THR   504      21.545  31.694  65.521  1.00 96.14           C  
ATOM   3841  N   LEU   505      23.248  34.003  64.193  1.00 96.60           N  
ATOM   3842  CA  LEU   505      24.693  33.916  64.085  1.00 96.62           C  
ATOM   3843  C   LEU   505      25.296  34.488  65.329  1.00 97.06           C  
ATOM   3844  O   LEU   505      24.644  35.237  66.053  1.00 96.94           O  
ATOM   3845  CB  LEU   505      25.281  34.583  62.840  1.00 95.18           C  
ATOM   3846  CG  LEU   505      24.726  35.876  62.324  1.00 94.25           C  
ATOM   3847  CD1 LEU   505      23.855  35.480  61.207  1.00 93.84           C  
ATOM   3848  CD2 LEU   505      23.998  36.634  63.414  1.00 94.38           C  
ATOM   3849  N   PRO   506      26.564  34.152  65.577  1.00 97.45           N  
ATOM   3850  CA  PRO   506      27.325  34.585  66.742  1.00 97.82           C  
ATOM   3851  C   PRO   506      27.045  35.991  67.219  1.00 98.30           C  
ATOM   3852  O   PRO   506      27.296  36.965  66.511  1.00 98.51           O  
ATOM   3853  CB  PRO   506      28.774  34.398  66.297  1.00 97.52           C  
ATOM   3854  CG  PRO   506      28.677  33.301  65.281  1.00 97.67           C  
ATOM   3855  CD  PRO   506      27.486  33.727  64.509  1.00 97.61           C  
ATOM   3856  N   GLU   507      26.512  36.078  68.432  1.00 99.24           N  
ATOM   3857  CA  GLU   507      26.225  37.356  69.064  1.00100.50           C  
ATOM   3858  C   GLU   507      27.517  38.183  69.105  1.00100.40           C  
ATOM   3859  O   GLU   507      28.518  37.798  68.505  1.00101.08           O  
ATOM   3860  CB  GLU   507      25.710  37.111  70.480  1.00100.99           C  
ATOM   3861  CG  GLU   507      24.337  36.473  70.551  1.00102.84           C  
ATOM   3862  CD  GLU   507      23.236  37.492  70.776  1.00103.79           C  
ATOM   3863  OE1 GLU   507      22.296  37.183  71.539  1.00104.00           O  
ATOM   3864  OE2 GLU   507      23.304  38.596  70.191  1.00105.06           O  
ATOM   3865  N   ALA   508      27.512  39.298  69.830  1.00100.03           N  
ATOM   3866  CA  ALA   508      28.700  40.146  69.890  1.00 99.67           C  
ATOM   3867  C   ALA   508      29.566  40.049  71.148  1.00 99.04           C  
ATOM   3868  O   ALA   508      29.258  40.612  72.198  1.00 98.30           O  
ATOM   3869  CB  ALA   508      28.313  41.604  69.647  1.00 98.75           C  
ATOM   3870  N   GLN   509      30.668  39.333  71.033  1.00 98.74           N  
ATOM   3871  CA  GLN   509      31.581  39.225  72.145  1.00 98.53           C  
ATOM   3872  C   GLN   509      32.857  39.898  71.733  1.00 98.42           C  
ATOM   3873  O   GLN   509      32.955  40.438  70.640  1.00 98.71           O  
ATOM   3874  CB  GLN   509      31.897  37.808  72.412  1.00 98.40           C  
ATOM   3875  CG  GLN   509      31.501  37.351  73.705  1.00 98.23           C  
ATOM   3876  CD  GLN   509      31.629  35.903  73.669  1.00 98.32           C  
ATOM   3877  OE1 GLN   509      30.653  35.186  73.457  1.00 98.50           O  
ATOM   3878  NE2 GLN   509      32.860  35.434  73.784  1.00 97.43           N  
ATOM   3879  N   ALA   510      33.876  39.822  72.567  1.00 97.78           N  
ATOM   3880  CA  ALA   510      35.071  40.521  72.175  1.00 96.97           C  
ATOM   3881  C   ALA   510      36.388  39.821  72.388  1.00 95.63           C  
ATOM   3882  O   ALA   510      36.670  39.300  73.468  1.00 95.98           O  
ATOM   3883  CB  ALA   510      35.088  41.890  72.845  1.00 98.22           C  
ATOM   3884  N   GLY   511      37.200  39.845  71.336  1.00 93.45           N  
ATOM   3885  CA  GLY   511      38.506  39.230  71.388  1.00 91.43           C  
ATOM   3886  C   GLY   511      38.561  38.087  70.411  1.00 90.60           C  
ATOM   3887  O   GLY   511      37.519  37.671  69.912  1.00 90.46           O  
ATOM   3888  N   GLU   512      39.763  37.588  70.127  1.00 89.80           N  
ATOM   3889  CA  GLU   512      39.913  36.472  69.207  1.00 89.31           C  
ATOM   3890  C   GLU   512      38.947  35.368  69.637  1.00 88.94           C  
ATOM   3891  O   GLU   512      38.795  35.084  70.830  1.00 88.33           O  
ATOM   3892  CB  GLU   512      41.360  35.962  69.210  1.00 90.79           C  
ATOM   3893  CG  GLU   512      41.551  34.609  68.510  1.00 92.23           C  
ATOM   3894  CD  GLU   512      43.012  34.263  68.269  1.00 93.52           C  
ATOM   3895  OE1 GLU   512      43.893  34.922  68.871  1.00 93.79           O  
ATOM   3896  OE2 GLU   512      43.279  33.327  67.480  1.00 93.98           O  
ATOM   3897  N   ARG   513      38.299  34.746  68.659  1.00 88.19           N  
ATOM   3898  CA  ARG   513      37.316  33.712  68.940  1.00 87.95           C  
ATOM   3899  C   ARG   513      37.785  32.282  68.645  1.00 87.97           C  
ATOM   3900  O   ARG   513      38.332  31.993  67.579  1.00 87.55           O  
ATOM   3901  CB  ARG   513      36.039  34.018  68.147  1.00 87.51           C  
ATOM   3902  CG  ARG   513      34.753  33.596  68.824  1.00 88.14           C  
ATOM   3903  CD  ARG   513      34.147  34.711  69.659  1.00 89.44           C  
ATOM   3904  NE  ARG   513      32.872  34.287  70.228  1.00 91.22           N  
ATOM   3905  CZ  ARG   513      32.764  33.377  71.189  1.00 93.32           C  
ATOM   3906  NH1 ARG   513      33.858  32.810  71.690  1.00 94.09           N  
ATOM   3907  NH2 ARG   513      31.567  33.020  71.639  1.00 93.85           N  
ATOM   3908  N   ILE   514      37.562  31.395  69.609  1.00 88.83           N  
ATOM   3909  CA  ILE   514      37.917  29.987  69.481  1.00 89.59           C  
ATOM   3910  C   ILE   514      36.683  29.309  68.842  1.00 88.94           C  
ATOM   3911  O   ILE   514      35.598  29.291  69.433  1.00 88.81           O  
ATOM   3912  CB  ILE   514      38.254  29.406  70.893  1.00 91.15           C  
ATOM   3913  CG1 ILE   514      38.811  27.977  70.781  1.00 93.84           C  
ATOM   3914  CG2 ILE   514      37.034  29.503  71.806  1.00 91.95           C  
ATOM   3915  CD1 ILE   514      37.828  26.912  70.291  1.00 95.43           C  
ATOM   3916  N   PRO   515      36.832  28.759  67.617  1.00 88.22           N  
ATOM   3917  CA  PRO   515      35.729  28.097  66.901  1.00 87.35           C  
ATOM   3918  C   PRO   515      34.720  27.298  67.746  1.00 86.17           C  
ATOM   3919  O   PRO   515      33.506  27.497  67.621  1.00 85.92           O  
ATOM   3920  CB  PRO   515      36.453  27.240  65.846  1.00 86.45           C  
ATOM   3921  CG  PRO   515      37.851  27.105  66.379  1.00 88.11           C  
ATOM   3922  CD  PRO   515      38.114  28.470  66.953  1.00 88.10           C  
ATOM   3923  N   GLN   516      35.221  26.410  68.602  1.00 84.15           N  
ATOM   3924  CA  GLN   516      34.367  25.593  69.463  1.00 82.25           C  
ATOM   3925  C   GLN   516      33.397  26.432  70.289  1.00 80.38           C  
ATOM   3926  O   GLN   516      32.336  25.960  70.697  1.00 79.49           O  
ATOM   3927  CB  GLN   516      35.226  24.744  70.405  1.00 83.08           C  
ATOM   3928  CG  GLN   516      35.941  23.571  69.743  1.00 84.55           C  
ATOM   3929  CD  GLN   516      36.934  22.905  70.680  1.00 85.58           C  
ATOM   3930  OE1 GLN   516      37.185  21.706  70.585  1.00 85.77           O  
ATOM   3931  NE2 GLN   516      37.515  23.689  71.587  1.00 85.81           N  
ATOM   3932  N   GLU   517      33.770  27.679  70.544  1.00 78.86           N  
ATOM   3933  CA  GLU   517      32.927  28.573  71.318  1.00 76.82           C  
ATOM   3934  C   GLU   517      31.854  29.177  70.400  1.00 75.90           C  
ATOM   3935  O   GLU   517      30.717  29.418  70.832  1.00 74.44           O  
ATOM   3936  CB  GLU   517      33.780  29.662  71.959  1.00 76.50           C  
ATOM   3937  N   VAL   518      32.218  29.415  69.139  1.00 73.51           N  
ATOM   3938  CA  VAL   518      31.269  29.955  68.180  1.00 73.34           C  
ATOM   3939  C   VAL   518      30.178  28.915  68.048  1.00 72.98           C  
ATOM   3940  O   VAL   518      29.022  29.143  68.436  1.00 72.16           O  
ATOM   3941  CB  VAL   518      31.897  30.163  66.771  1.00 74.75           C  
ATOM   3942  CG1 VAL   518      30.785  30.226  65.694  1.00 73.79           C  
ATOM   3943  CG2 VAL   518      32.703  31.450  66.741  1.00 75.01           C  
ATOM   3944  N   VAL   519      30.579  27.773  67.490  1.00 72.38           N  
ATOM   3945  CA  VAL   519      29.697  26.647  67.276  1.00 71.36           C  
ATOM   3946  C   VAL   519      28.810  26.467  68.500  1.00 71.94           C  
ATOM   3947  O   VAL   519      27.582  26.441  68.375  1.00 73.35           O  
ATOM   3948  CB  VAL   519      30.512  25.366  66.997  1.00 71.25           C  
ATOM   3949  CG1 VAL   519      29.596  24.159  66.930  1.00 71.23           C  
ATOM   3950  CG2 VAL   519      31.254  25.507  65.678  1.00 70.30           C  
ATOM   3951  N   TRP   520      29.409  26.373  69.684  1.00 70.51           N  
ATOM   3952  CA  TRP   520      28.606  26.208  70.884  1.00 70.26           C  
ATOM   3953  C   TRP   520      27.534  27.287  71.023  1.00 71.83           C  
ATOM   3954  O   TRP   520      26.366  26.981  71.264  1.00 70.83           O  
ATOM   3955  CB  TRP   520      29.470  26.231  72.137  1.00 69.03           C  
ATOM   3956  CG  TRP   520      28.634  26.153  73.405  1.00 69.51           C  
ATOM   3957  CD1 TRP   520      28.813  26.876  74.554  1.00 69.58           C  
ATOM   3958  CD2 TRP   520      27.478  25.326  73.634  1.00 68.30           C  
ATOM   3959  NE1 TRP   520      27.843  26.555  75.475  1.00 68.00           N  
ATOM   3960  CE2 TRP   520      27.012  25.609  74.937  1.00 67.58           C  
ATOM   3961  CE3 TRP   520      26.791  24.379  72.863  1.00 66.74           C  
ATOM   3962  CZ2 TRP   520      25.892  24.979  75.486  1.00 67.64           C  
ATOM   3963  CZ3 TRP   520      25.682  23.756  73.409  1.00 66.32           C  
ATOM   3964  CH2 TRP   520      25.242  24.058  74.708  1.00 66.50           C  
ATOM   3965  N   ASP   521      27.927  28.552  70.882  1.00 74.28           N  
ATOM   3966  CA  ASP   521      26.964  29.645  71.018  1.00 75.89           C  
ATOM   3967  C   ASP   521      25.823  29.609  69.995  1.00 75.86           C  
ATOM   3968  O   ASP   521      24.672  29.874  70.344  1.00 75.73           O  
ATOM   3969  CB  ASP   521      27.676  31.008  71.001  1.00 76.97           C  
ATOM   3970  CG  ASP   521      28.237  31.387  72.371  1.00 79.73           C  
ATOM   3971  OD1 ASP   521      27.683  30.907  73.392  1.00 80.15           O  
ATOM   3972  OD2 ASP   521      29.215  32.169  72.440  1.00 80.34           O  
ATOM   3973  N   LEU   522      26.122  29.279  68.742  1.00 75.42           N  
ATOM   3974  CA  LEU   522      25.059  29.193  67.742  1.00 75.16           C  
ATOM   3975  C   LEU   522      23.983  28.198  68.215  1.00 76.83           C  
ATOM   3976  O   LEU   522      22.783  28.486  68.190  1.00 77.30           O  
ATOM   3977  CB  LEU   522      25.632  28.738  66.404  1.00 71.39           C  
ATOM   3978  CG  LEU   522      26.544  29.754  65.734  1.00 68.02           C  
ATOM   3979  CD1 LEU   522      27.111  29.196  64.449  1.00 65.86           C  
ATOM   3980  CD2 LEU   522      25.738  30.997  65.462  1.00 67.48           C  
ATOM   3981  N   LEU   523      24.430  27.028  68.653  1.00 77.61           N  
ATOM   3982  CA  LEU   523      23.535  25.998  69.138  1.00 78.18           C  
ATOM   3983  C   LEU   523      22.894  26.481  70.424  1.00 79.47           C  
ATOM   3984  O   LEU   523      21.709  26.248  70.664  1.00 80.21           O  
ATOM   3985  CB  LEU   523      24.330  24.719  69.397  1.00 78.76           C  
ATOM   3986  CG  LEU   523      23.613  23.488  69.944  1.00 77.73           C  
ATOM   3987  CD1 LEU   523      22.495  23.095  68.994  1.00 77.40           C  
ATOM   3988  CD2 LEU   523      24.618  22.360  70.113  1.00 76.61           C  
ATOM   3989  N   GLU   524      23.696  27.146  71.250  1.00 80.37           N  
ATOM   3990  CA  GLU   524      23.243  27.684  72.529  1.00 81.70           C  
ATOM   3991  C   GLU   524      22.000  28.526  72.311  1.00 82.34           C  
ATOM   3992  O   GLU   524      21.034  28.434  73.072  1.00 82.93           O  
ATOM   3993  CB  GLU   524      24.360  28.538  73.153  1.00 83.30           C  
ATOM   3994  CG  GLU   524      23.963  29.545  74.252  1.00 84.85           C  
ATOM   3995  CD  GLU   524      23.498  28.890  75.544  1.00 86.61           C  
ATOM   3996  OE1 GLU   524      23.533  29.546  76.612  1.00 85.70           O  
ATOM   3997  OE2 GLU   524      23.081  27.716  75.487  1.00 88.43           O  
ATOM   3998  N   GLU   525      22.013  29.334  71.256  1.00 81.97           N  
ATOM   3999  CA  GLU   525      20.875  30.194  70.975  1.00 81.91           C  
ATOM   4000  C   GLU   525      19.645  29.412  70.507  1.00 80.80           C  
ATOM   4001  O   GLU   525      18.531  29.616  71.009  1.00 79.38           O  
ATOM   4002  CB  GLU   525      21.260  31.247  69.936  1.00 83.38           C  
ATOM   4003  CG  GLU   525      20.441  32.510  70.076  1.00 86.89           C  
ATOM   4004  CD  GLU   525      20.401  33.011  71.519  1.00 87.75           C  
ATOM   4005  OE1 GLU   525      19.294  33.342  71.999  1.00 87.79           O  
ATOM   4006  OE2 GLU   525      21.469  33.074  72.169  1.00 88.20           O  
ATOM   4007  N   THR   526      19.858  28.510  69.552  1.00 79.63           N  
ATOM   4008  CA  THR   526      18.785  27.692  69.004  1.00 77.67           C  
ATOM   4009  C   THR   526      18.027  26.958  70.114  1.00 77.02           C  
ATOM   4010  O   THR   526      16.808  26.833  70.059  1.00 75.80           O  
ATOM   4011  CB  THR   526      19.344  26.666  68.020  1.00 77.01           C  
ATOM   4012  OG1 THR   526      20.236  25.797  68.724  1.00 78.88           O  
ATOM   4013  CG2 THR   526      20.117  27.357  66.896  1.00 76.06           C  
ATOM   4014  N   LEU   527      18.745  26.481  71.124  1.00 76.63           N  
ATOM   4015  CA  LEU   527      18.100  25.767  72.218  1.00 76.55           C  
ATOM   4016  C   LEU   527      17.154  26.684  72.984  1.00 76.95           C  
ATOM   4017  O   LEU   527      16.076  26.259  73.413  1.00 77.15           O  
ATOM   4018  CB  LEU   527      19.141  25.173  73.165  1.00 76.23           C  
ATOM   4019  CG  LEU   527      20.082  24.134  72.549  1.00 77.11           C  
ATOM   4020  CD1 LEU   527      21.139  23.722  73.575  1.00 76.73           C  
ATOM   4021  CD2 LEU   527      19.280  22.925  72.073  1.00 75.80           C  
ATOM   4022  N   TRP   528      17.547  27.940  73.169  1.00 76.82           N  
ATOM   4023  CA  TRP   528      16.673  28.879  73.862  1.00 76.26           C  
ATOM   4024  C   TRP   528      15.479  29.172  72.967  1.00 77.32           C  
ATOM   4025  O   TRP   528      14.335  29.194  73.427  1.00 76.87           O  
ATOM   4026  CB  TRP   528      17.420  30.163  74.200  1.00 75.00           C  
ATOM   4027  CG  TRP   528      18.397  29.945  75.295  1.00 75.62           C  
ATOM   4028  CD1 TRP   528      19.747  30.104  75.232  1.00 75.27           C  
ATOM   4029  CD2 TRP   528      18.106  29.457  76.610  1.00 76.17           C  
ATOM   4030  NE1 TRP   528      20.320  29.739  76.427  1.00 76.88           N  
ATOM   4031  CE2 TRP   528      19.335  29.339  77.291  1.00 76.98           C  
ATOM   4032  CE3 TRP   528      16.921  29.106  77.279  1.00 77.38           C  
ATOM   4033  CZ2 TRP   528      19.422  28.880  78.618  1.00 78.64           C  
ATOM   4034  CZ3 TRP   528      17.000  28.649  78.597  1.00 78.35           C  
ATOM   4035  CH2 TRP   528      18.246  28.540  79.252  1.00 79.66           C  
ATOM   4036  N   ALA   529      15.741  29.387  71.682  1.00 77.74           N  
ATOM   4037  CA  ALA   529      14.657  29.644  70.750  1.00 79.31           C  
ATOM   4038  C   ALA   529      13.641  28.519  70.939  1.00 80.36           C  
ATOM   4039  O   ALA   529      12.466  28.759  71.240  1.00 81.49           O  
ATOM   4040  CB  ALA   529      15.183  29.648  69.326  1.00 78.43           C  
ATOM   4041  N   PHE   530      14.124  27.293  70.776  1.00 80.60           N  
ATOM   4042  CA  PHE   530      13.321  26.091  70.926  1.00 81.33           C  
ATOM   4043  C   PHE   530      12.674  26.068  72.319  1.00 83.94           C  
ATOM   4044  O   PHE   530      11.543  25.604  72.484  1.00 83.94           O  
ATOM   4045  CB  PHE   530      14.220  24.859  70.741  1.00 79.61           C  
ATOM   4046  CG  PHE   530      13.476  23.557  70.719  1.00 77.24           C  
ATOM   4047  CD1 PHE   530      13.018  23.029  69.525  1.00 76.57           C  
ATOM   4048  CD2 PHE   530      13.193  22.885  71.902  1.00 76.88           C  
ATOM   4049  CE1 PHE   530      12.289  21.854  69.509  1.00 77.77           C  
ATOM   4050  CE2 PHE   530      12.463  21.707  71.899  1.00 76.90           C  
ATOM   4051  CZ  PHE   530      12.006  21.189  70.699  1.00 77.74           C  
ATOM   4052  N   ARG   531      13.392  26.568  73.320  1.00 86.31           N  
ATOM   4053  CA  ARG   531      12.872  26.591  74.687  1.00 89.16           C  
ATOM   4054  C   ARG   531      11.599  27.447  74.738  1.00 89.27           C  
ATOM   4055  O   ARG   531      10.489  26.942  74.932  1.00 88.23           O  
ATOM   4056  CB  ARG   531      13.947  27.148  75.643  1.00 91.22           C  
ATOM   4057  CG  ARG   531      13.719  26.897  77.149  1.00 94.99           C  
ATOM   4058  CD  ARG   531      12.780  27.929  77.790  1.00 99.95           C  
ATOM   4059  NE  ARG   531      13.309  29.301  77.743  1.00103.15           N  
ATOM   4060  CZ  ARG   531      12.595  30.398  78.011  1.00103.99           C  
ATOM   4061  NH1 ARG   531      13.163  31.597  77.943  1.00103.11           N  
ATOM   4062  NH2 ARG   531      11.309  30.299  78.342  1.00104.81           N  
ATOM   4063  N   ARG   532      11.777  28.745  74.539  1.00 90.06           N  
ATOM   4064  CA  ARG   532      10.679  29.697  74.566  1.00 90.78           C  
ATOM   4065  C   ARG   532       9.505  29.270  73.687  1.00 91.49           C  
ATOM   4066  O   ARG   532       8.347  29.346  74.100  1.00 90.93           O  
ATOM   4067  CB  ARG   532      11.196  31.066  74.114  1.00 90.56           C  
ATOM   4068  CG  ARG   532      12.433  31.520  74.882  1.00 91.51           C  
ATOM   4069  CD  ARG   532      12.911  32.899  74.459  1.00 91.80           C  
ATOM   4070  NE  ARG   532      13.413  32.923  73.090  1.00 92.06           N  
ATOM   4071  CZ  ARG   532      14.688  33.121  72.768  1.00 92.90           C  
ATOM   4072  NH1 ARG   532      15.592  33.314  73.722  1.00 92.91           N  
ATOM   4073  NH2 ARG   532      15.061  33.127  71.494  1.00 92.13           N  
ATOM   4074  N   LYS   533       9.819  28.801  72.483  1.00 91.81           N  
ATOM   4075  CA  LYS   533       8.807  28.400  71.512  1.00 90.99           C  
ATOM   4076  C   LYS   533       8.140  27.041  71.729  1.00 90.59           C  
ATOM   4077  O   LYS   533       7.175  26.714  71.036  1.00 90.66           O  
ATOM   4078  CB  LYS   533       9.410  28.457  70.108  1.00 89.79           C  
ATOM   4079  N   ALA   534       8.624  26.248  72.677  1.00 90.15           N  
ATOM   4080  CA  ALA   534       8.028  24.934  72.888  1.00 90.13           C  
ATOM   4081  C   ALA   534       7.892  24.537  74.348  1.00 90.85           C  
ATOM   4082  O   ALA   534       7.286  23.510  74.660  1.00 90.94           O  
ATOM   4083  CB  ALA   534       8.830  23.883  72.141  1.00 89.69           C  
ATOM   4084  N   GLY   535       8.469  25.337  75.243  1.00 91.59           N  
ATOM   4085  CA  GLY   535       8.364  25.048  76.665  1.00 91.25           C  
ATOM   4086  C   GLY   535       9.485  24.268  77.337  1.00 90.98           C  
ATOM   4087  O   GLY   535       9.657  24.376  78.555  1.00 91.43           O  
ATOM   4088  N   ARG   536      10.248  23.485  76.573  1.00 89.52           N  
ATOM   4089  CA  ARG   536      11.338  22.697  77.156  1.00 87.32           C  
ATOM   4090  C   ARG   536      12.491  22.431  76.190  1.00 84.87           C  
ATOM   4091  O   ARG   536      12.369  22.649  74.983  1.00 85.26           O  
ATOM   4092  CB  ARG   536      10.789  21.362  77.690  1.00 87.33           C  
ATOM   4093  N   LEU   537      13.612  21.963  76.735  1.00 81.90           N  
ATOM   4094  CA  LEU   537      14.782  21.638  75.924  1.00 79.59           C  
ATOM   4095  C   LEU   537      14.517  20.365  75.136  1.00 77.21           C  
ATOM   4096  O   LEU   537      13.911  19.429  75.656  1.00 77.15           O  
ATOM   4097  CB  LEU   537      16.009  21.401  76.795  1.00 79.37           C  
ATOM   4098  CG  LEU   537      16.710  22.590  77.426  1.00 79.79           C  
ATOM   4099  CD1 LEU   537      15.787  23.269  78.416  1.00 81.45           C  
ATOM   4100  CD2 LEU   537      17.963  22.099  78.125  1.00 81.28           C  
ATOM   4101  N   PRO   538      14.973  20.311  73.872  1.00 74.74           N  
ATOM   4102  CA  PRO   538      14.785  19.138  73.012  1.00 73.61           C  
ATOM   4103  C   PRO   538      15.467  17.904  73.597  1.00 73.15           C  
ATOM   4104  O   PRO   538      16.556  17.991  74.166  1.00 72.71           O  
ATOM   4105  CB  PRO   538      15.401  19.578  71.683  1.00 72.37           C  
ATOM   4106  CG  PRO   538      16.429  20.567  72.098  1.00 72.50           C  
ATOM   4107  CD  PRO   538      15.741  21.353  73.171  1.00 73.30           C  
ATOM   4108  N   SER   539      14.816  16.755  73.467  1.00 72.78           N  
ATOM   4109  CA  SER   539      15.365  15.512  73.991  1.00 72.75           C  
ATOM   4110  C   SER   539      16.538  15.026  73.139  1.00 71.68           C  
ATOM   4111  O   SER   539      17.512  14.479  73.669  1.00 72.12           O  
ATOM   4112  CB  SER   539      14.278  14.434  74.042  1.00 74.13           C  
ATOM   4113  OG  SER   539      13.808  14.123  72.740  1.00 77.38           O  
ATOM   4114  N   ARG   540      16.436  15.236  71.828  1.00 68.92           N  
ATOM   4115  CA  ARG   540      17.468  14.831  70.878  1.00 67.12           C  
ATOM   4116  C   ARG   540      17.623  15.899  69.796  1.00 64.84           C  
ATOM   4117  O   ARG   540      16.636  16.471  69.352  1.00 64.93           O  
ATOM   4118  CB  ARG   540      17.086  13.496  70.234  1.00 67.89           C  
ATOM   4119  CG  ARG   540      18.160  12.919  69.342  1.00 69.06           C  
ATOM   4120  CD  ARG   540      17.915  11.442  69.014  1.00 71.29           C  
ATOM   4121  NE  ARG   540      19.176  10.789  68.662  1.00 72.80           N  
ATOM   4122  CZ  ARG   540      19.806   9.890  69.414  1.00 72.93           C  
ATOM   4123  NH1 ARG   540      19.296   9.495  70.577  1.00 70.54           N  
ATOM   4124  NH2 ARG   540      20.985   9.422  69.018  1.00 74.92           N  
ATOM   4125  N   VAL   541      18.852  16.159  69.363  1.00 61.35           N  
ATOM   4126  CA  VAL   541      19.086  17.176  68.348  1.00 58.28           C  
ATOM   4127  C   VAL   541      19.887  16.614  67.187  1.00 58.28           C  
ATOM   4128  O   VAL   541      20.731  15.754  67.374  1.00 58.90           O  
ATOM   4129  CB  VAL   541      19.847  18.393  68.953  1.00 57.68           C  
ATOM   4130  CG1 VAL   541      20.188  19.428  67.879  1.00 54.80           C  
ATOM   4131  CG2 VAL   541      19.006  19.026  70.010  1.00 55.24           C  
ATOM   4132  N   LEU   542      19.610  17.099  65.984  1.00 57.06           N  
ATOM   4133  CA  LEU   542      20.321  16.658  64.796  1.00 56.94           C  
ATOM   4134  C   LEU   542      21.162  17.841  64.336  1.00 56.72           C  
ATOM   4135  O   LEU   542      20.625  18.893  64.024  1.00 58.77           O  
ATOM   4136  CB  LEU   542      19.317  16.256  63.713  1.00 56.22           C  
ATOM   4137  CG  LEU   542      19.809  15.860  62.318  1.00 57.58           C  
ATOM   4138  CD1 LEU   542      20.749  14.658  62.345  1.00 56.27           C  
ATOM   4139  CD2 LEU   542      18.598  15.533  61.490  1.00 58.90           C  
ATOM   4140  N   LEU   543      22.478  17.674  64.316  1.00 56.66           N  
ATOM   4141  CA  LEU   543      23.391  18.747  63.918  1.00 56.10           C  
ATOM   4142  C   LEU   543      23.975  18.447  62.548  1.00 56.09           C  
ATOM   4143  O   LEU   543      24.721  17.494  62.385  1.00 56.87           O  
ATOM   4144  CB  LEU   543      24.525  18.882  64.944  1.00 55.20           C  
ATOM   4145  CG  LEU   543      24.104  18.851  66.425  1.00 56.09           C  
ATOM   4146  CD1 LEU   543      25.231  18.341  67.256  1.00 55.56           C  
ATOM   4147  CD2 LEU   543      23.687  20.207  66.906  1.00 56.77           C  
ATOM   4148  N   LEU   544      23.621  19.249  61.557  1.00 56.75           N  
ATOM   4149  CA  LEU   544      24.140  19.048  60.216  1.00 58.15           C  
ATOM   4150  C   LEU   544      25.177  20.106  59.926  1.00 60.68           C  
ATOM   4151  O   LEU   544      24.902  21.298  60.038  1.00 61.33           O  
ATOM   4152  CB  LEU   544      23.027  19.175  59.201  1.00 57.70           C  
ATOM   4153  CG  LEU   544      21.809  18.287  59.388  1.00 56.10           C  
ATOM   4154  CD1 LEU   544      20.869  18.544  58.229  1.00 56.53           C  
ATOM   4155  CD2 LEU   544      22.220  16.837  59.419  1.00 55.62           C  
ATOM   4156  N   ARG   545      26.369  19.671  59.544  1.00 63.27           N  
ATOM   4157  CA  ARG   545      27.458  20.594  59.249  1.00 65.62           C  
ATOM   4158  C   ARG   545      28.051  20.363  57.862  1.00 67.80           C  
ATOM   4159  O   ARG   545      27.917  19.279  57.289  1.00 67.01           O  
ATOM   4160  CB  ARG   545      28.569  20.422  60.275  1.00 65.31           C  
ATOM   4161  CG  ARG   545      29.429  19.197  60.023  1.00 64.23           C  
ATOM   4162  CD  ARG   545      30.524  19.041  61.068  1.00 66.70           C  
ATOM   4163  NE  ARG   545      31.487  18.022  60.658  1.00 69.61           N  
ATOM   4164  CZ  ARG   545      32.363  18.170  59.663  1.00 70.75           C  
ATOM   4165  NH1 ARG   545      32.408  19.313  58.981  1.00 70.21           N  
ATOM   4166  NH2 ARG   545      33.168  17.163  59.320  1.00 68.64           N  
ATOM   4167  N   ASP   546      28.719  21.386  57.336  1.00 70.58           N  
ATOM   4168  CA  ASP   546      29.361  21.278  56.030  1.00 73.43           C  
ATOM   4169  C   ASP   546      30.657  20.486  56.173  1.00 74.77           C  
ATOM   4170  O   ASP   546      31.460  20.735  57.073  1.00 74.95           O  
ATOM   4171  CB  ASP   546      29.671  22.665  55.460  1.00 74.73           C  
ATOM   4172  CG  ASP   546      30.552  22.598  54.230  1.00 74.97           C  
ATOM   4173  OD1 ASP   546      30.236  21.814  53.319  1.00 74.59           O  
ATOM   4174  OD2 ASP   546      31.562  23.325  54.171  1.00 78.37           O  
ATOM   4175  N   GLY   547      30.854  19.535  55.272  1.00 76.20           N  
ATOM   4176  CA  GLY   547      32.040  18.698  55.313  1.00 78.31           C  
ATOM   4177  C   GLY   547      33.398  19.371  55.240  1.00 78.80           C  
ATOM   4178  O   GLY   547      34.322  18.952  55.929  1.00 79.07           O  
ATOM   4179  N   ARG   548      33.532  20.403  54.412  1.00 80.58           N  
ATOM   4180  CA  ARG   548      34.812  21.103  54.264  1.00 81.35           C  
ATOM   4181  C   ARG   548      35.481  21.366  55.617  1.00 81.16           C  
ATOM   4182  O   ARG   548      36.704  21.287  55.746  1.00 80.58           O  
ATOM   4183  CB  ARG   548      34.610  22.423  53.507  1.00 81.73           C  
ATOM   4184  N   VAL   549      34.671  21.666  56.624  1.00 81.15           N  
ATOM   4185  CA  VAL   549      35.182  21.940  57.963  1.00 80.87           C  
ATOM   4186  C   VAL   549      35.562  20.655  58.691  1.00 80.24           C  
ATOM   4187  O   VAL   549      34.995  19.596  58.427  1.00 80.21           O  
ATOM   4188  CB  VAL   549      34.130  22.680  58.792  1.00 81.36           C  
ATOM   4189  CG1 VAL   549      34.599  22.832  60.228  1.00 81.58           C  
ATOM   4190  CG2 VAL   549      33.847  24.035  58.161  1.00 81.60           C  
ATOM   4191  N   PRO   550      36.555  20.729  59.596  1.00 79.52           N  
ATOM   4192  CA  PRO   550      36.994  19.553  60.358  1.00 77.69           C  
ATOM   4193  C   PRO   550      36.137  19.411  61.613  1.00 75.49           C  
ATOM   4194  O   PRO   550      36.015  20.340  62.415  1.00 74.14           O  
ATOM   4195  CB  PRO   550      38.454  19.871  60.665  1.00 78.99           C  
ATOM   4196  CG  PRO   550      38.428  21.355  60.872  1.00 78.71           C  
ATOM   4197  CD  PRO   550      37.503  21.851  59.765  1.00 79.58           C  
ATOM   4198  N   GLN   551      35.560  18.233  61.784  1.00 73.56           N  
ATOM   4199  CA  GLN   551      34.674  17.988  62.899  1.00 73.36           C  
ATOM   4200  C   GLN   551      35.169  18.269  64.318  1.00 74.50           C  
ATOM   4201  O   GLN   551      34.379  18.219  65.256  1.00 74.41           O  
ATOM   4202  CB  GLN   551      34.138  16.566  62.818  1.00 72.76           C  
ATOM   4203  CG  GLN   551      34.977  15.521  63.497  1.00 71.87           C  
ATOM   4204  CD  GLN   551      34.207  14.230  63.689  1.00 70.02           C  
ATOM   4205  OE1 GLN   551      33.812  13.590  62.718  1.00 68.56           O  
ATOM   4206  NE2 GLN   551      33.983  13.847  64.947  1.00 68.29           N  
ATOM   4207  N   ASP   552      36.454  18.572  64.485  1.00 76.02           N  
ATOM   4208  CA  ASP   552      37.006  18.864  65.817  1.00 76.42           C  
ATOM   4209  C   ASP   552      36.272  20.038  66.469  1.00 75.72           C  
ATOM   4210  O   ASP   552      36.084  20.069  67.688  1.00 75.17           O  
ATOM   4211  CB  ASP   552      38.495  19.232  65.729  1.00 79.42           C  
ATOM   4212  CG  ASP   552      39.326  18.184  65.018  1.00 82.73           C  
ATOM   4213  OD1 ASP   552      38.939  17.775  63.895  1.00 85.08           O  
ATOM   4214  OD2 ASP   552      40.372  17.780  65.581  1.00 83.68           O  
ATOM   4215  N   GLU   553      35.859  20.997  65.639  1.00 74.79           N  
ATOM   4216  CA  GLU   553      35.175  22.214  66.091  1.00 72.91           C  
ATOM   4217  C   GLU   553      33.833  22.046  66.805  1.00 70.89           C  
ATOM   4218  O   GLU   553      33.320  23.007  67.383  1.00 69.92           O  
ATOM   4219  CB  GLU   553      35.008  23.178  64.906  1.00 70.93           C  
ATOM   4220  N   PHE   554      33.257  20.851  66.773  1.00 68.73           N  
ATOM   4221  CA  PHE   554      31.975  20.655  67.437  1.00 69.00           C  
ATOM   4222  C   PHE   554      32.106  19.947  68.784  1.00 68.75           C  
ATOM   4223  O   PHE   554      31.117  19.752  69.492  1.00 67.51           O  
ATOM   4224  CB  PHE   554      31.025  19.878  66.520  1.00 68.35           C  
ATOM   4225  CG  PHE   554      30.711  20.587  65.234  1.00 68.55           C  
ATOM   4226  CD1 PHE   554      31.723  20.908  64.327  1.00 68.74           C  
ATOM   4227  CD2 PHE   554      29.404  20.936  64.924  1.00 67.83           C  
ATOM   4228  CE1 PHE   554      31.425  21.567  63.125  1.00 67.77           C  
ATOM   4229  CE2 PHE   554      29.102  21.591  63.734  1.00 67.45           C  
ATOM   4230  CZ  PHE   554      30.111  21.907  62.834  1.00 66.30           C  
ATOM   4231  N   ALA   555      33.340  19.593  69.137  1.00 69.34           N  
ATOM   4232  CA  ALA   555      33.633  18.889  70.385  1.00 69.62           C  
ATOM   4233  C   ALA   555      33.032  19.542  71.622  1.00 69.66           C  
ATOM   4234  O   ALA   555      32.343  18.884  72.409  1.00 69.66           O  
ATOM   4235  CB  ALA   555      35.137  18.748  70.558  1.00 70.58           C  
ATOM   4236  N   LEU   556      33.302  20.831  71.806  1.00 69.35           N  
ATOM   4237  CA  LEU   556      32.761  21.540  72.963  1.00 68.54           C  
ATOM   4238  C   LEU   556      31.239  21.442  72.899  1.00 67.05           C  
ATOM   4239  O   LEU   556      30.585  21.096  73.882  1.00 65.66           O  
ATOM   4240  CB  LEU   556      33.211  23.017  72.951  1.00 69.05           C  
ATOM   4241  N   ALA   557      30.691  21.723  71.721  1.00 65.72           N  
ATOM   4242  CA  ALA   557      29.256  21.668  71.518  1.00 64.71           C  
ATOM   4243  C   ALA   557      28.672  20.314  71.932  1.00 64.77           C  
ATOM   4244  O   ALA   557      27.656  20.270  72.634  1.00 63.90           O  
ATOM   4245  CB  ALA   557      28.928  21.969  70.064  1.00 63.56           C  
ATOM   4246  N   LEU   558      29.305  19.218  71.509  1.00 64.48           N  
ATOM   4247  CA  LEU   558      28.823  17.881  71.858  1.00 65.96           C  
ATOM   4248  C   LEU   558      28.892  17.615  73.347  1.00 68.91           C  
ATOM   4249  O   LEU   558      27.976  17.037  73.929  1.00 69.45           O  
ATOM   4250  CB  LEU   558      29.612  16.793  71.132  1.00 63.25           C  
ATOM   4251  CG  LEU   558      29.345  16.722  69.631  1.00 61.20           C  
ATOM   4252  CD1 LEU   558      29.771  15.378  69.099  1.00 57.43           C  
ATOM   4253  CD2 LEU   558      27.866  16.956  69.382  1.00 59.20           C  
ATOM   4254  N   GLU   559      29.980  18.029  73.975  1.00 71.67           N  
ATOM   4255  CA  GLU   559      30.111  17.814  75.404  1.00 74.20           C  
ATOM   4256  C   GLU   559      29.097  18.597  76.208  1.00 74.06           C  
ATOM   4257  O   GLU   559      28.735  18.204  77.325  1.00 73.30           O  
ATOM   4258  CB  GLU   559      31.490  18.205  75.866  1.00 77.14           C  
ATOM   4259  CG  GLU   559      32.551  17.323  75.334  1.00 82.53           C  
ATOM   4260  CD  GLU   559      33.900  17.865  75.685  1.00 86.60           C  
ATOM   4261  OE1 GLU   559      34.906  17.241  75.297  1.00 88.60           O  
ATOM   4262  OE2 GLU   559      33.948  18.926  76.351  1.00 88.51           O  
ATOM   4263  N   ALA   560      28.656  19.719  75.653  1.00 72.69           N  
ATOM   4264  CA  ALA   560      27.677  20.538  76.339  1.00 71.58           C  
ATOM   4265  C   ALA   560      26.330  19.835  76.301  1.00 70.95           C  
ATOM   4266  O   ALA   560      25.626  19.763  77.306  1.00 71.46           O  
ATOM   4267  CB  ALA   560      27.579  21.891  75.689  1.00 71.08           C  
ATOM   4268  N   LEU   561      25.976  19.299  75.142  1.00 70.33           N  
ATOM   4269  CA  LEU   561      24.705  18.606  75.002  1.00 70.82           C  
ATOM   4270  C   LEU   561      24.662  17.404  75.942  1.00 71.66           C  
ATOM   4271  O   LEU   561      23.629  17.089  76.552  1.00 69.40           O  
ATOM   4272  CB  LEU   561      24.515  18.144  73.558  1.00 70.62           C  
ATOM   4273  CG  LEU   561      24.262  19.197  72.482  1.00 69.34           C  
ATOM   4274  CD1 LEU   561      24.259  18.523  71.128  1.00 68.95           C  
ATOM   4275  CD2 LEU   561      22.930  19.883  72.727  1.00 69.71           C  
ATOM   4276  N   ALA   562      25.803  16.734  76.045  1.00 73.00           N  
ATOM   4277  CA  ALA   562      25.930  15.569  76.903  1.00 72.97           C  
ATOM   4278  C   ALA   562      25.656  16.000  78.333  1.00 72.64           C  
ATOM   4279  O   ALA   562      24.880  15.360  79.041  1.00 71.75           O  
ATOM   4280  CB  ALA   562      27.329  14.982  76.779  1.00 73.22           C  
ATOM   4281  N   ARG   563      26.291  17.094  78.747  1.00 73.35           N  
ATOM   4282  CA  ARG   563      26.113  17.629  80.099  1.00 74.33           C  
ATOM   4283  C   ARG   563      24.642  17.975  80.343  1.00 73.12           C  
ATOM   4284  O   ARG   563      24.087  17.639  81.385  1.00 71.47           O  
ATOM   4285  CB  ARG   563      26.981  18.880  80.300  1.00 76.50           C  
ATOM   4286  CG  ARG   563      28.480  18.620  80.222  1.00 81.64           C  
ATOM   4287  CD  ARG   563      29.293  19.902  80.426  1.00 86.20           C  
ATOM   4288  NE  ARG   563      30.745  19.682  80.394  1.00 89.40           N  
ATOM   4289  CZ  ARG   563      31.571  20.179  79.469  1.00 89.91           C  
ATOM   4290  NH1 ARG   563      31.104  20.929  78.483  1.00 89.17           N  
ATOM   4291  NH2 ARG   563      32.874  19.936  79.536  1.00 90.96           N  
ATOM   4292  N   GLU   564      24.021  18.632  79.364  1.00 72.05           N  
ATOM   4293  CA  GLU   564      22.620  19.036  79.441  1.00 72.05           C  
ATOM   4294  C   GLU   564      21.615  17.886  79.463  1.00 71.31           C  
ATOM   4295  O   GLU   564      20.464  18.066  79.862  1.00 70.31           O  
ATOM   4296  CB  GLU   564      22.259  19.925  78.252  1.00 73.17           C  
ATOM   4297  CG  GLU   564      23.059  21.206  78.130  1.00 77.28           C  
ATOM   4298  CD  GLU   564      22.935  22.104  79.346  1.00 79.30           C  
ATOM   4299  OE1 GLU   564      21.806  22.233  79.887  1.00 80.51           O  
ATOM   4300  OE2 GLU   564      23.968  22.689  79.745  1.00 79.27           O  
ATOM   4301  N   GLY   565      22.035  16.710  79.009  1.00 70.78           N  
ATOM   4302  CA  GLY   565      21.119  15.583  78.965  1.00 68.36           C  
ATOM   4303  C   GLY   565      20.439  15.523  77.604  1.00 66.25           C  
ATOM   4304  O   GLY   565      19.378  14.916  77.446  1.00 66.53           O  
ATOM   4305  N   ILE   566      21.064  16.149  76.615  1.00 63.16           N  
ATOM   4306  CA  ILE   566      20.521  16.161  75.271  1.00 62.51           C  
ATOM   4307  C   ILE   566      21.248  15.220  74.301  1.00 61.42           C  
ATOM   4308  O   ILE   566      22.440  15.374  74.032  1.00 60.97           O  
ATOM   4309  CB  ILE   566      20.531  17.595  74.694  1.00 62.93           C  
ATOM   4310  CG1 ILE   566      19.636  18.482  75.552  1.00 63.12           C  
ATOM   4311  CG2 ILE   566      20.046  17.595  73.250  1.00 62.42           C  
ATOM   4312  CD1 ILE   566      19.625  19.909  75.126  1.00 63.14           C  
ATOM   4313  N   ALA   567      20.506  14.246  73.783  1.00 59.47           N  
ATOM   4314  CA  ALA   567      21.045  13.286  72.834  1.00 57.87           C  
ATOM   4315  C   ALA   567      21.298  14.020  71.521  1.00 58.02           C  
ATOM   4316  O   ALA   567      20.763  15.116  71.307  1.00 54.73           O  
ATOM   4317  CB  ALA   567      20.058  12.151  72.630  1.00 55.57           C  
ATOM   4318  N   TYR   568      22.106  13.408  70.647  1.00 59.50           N  
ATOM   4319  CA  TYR   568      22.456  14.006  69.355  1.00 59.67           C  
ATOM   4320  C   TYR   568      23.005  13.060  68.282  1.00 58.98           C  
ATOM   4321  O   TYR   568      23.343  11.913  68.546  1.00 61.20           O  
ATOM   4322  CB  TYR   568      23.484  15.128  69.554  1.00 59.98           C  
ATOM   4323  CG  TYR   568      24.755  14.669  70.223  1.00 61.08           C  
ATOM   4324  CD1 TYR   568      24.838  14.587  71.616  1.00 63.21           C  
ATOM   4325  CD2 TYR   568      25.865  14.277  69.466  1.00 60.42           C  
ATOM   4326  CE1 TYR   568      26.001  14.118  72.248  1.00 64.86           C  
ATOM   4327  CE2 TYR   568      27.031  13.806  70.076  1.00 61.12           C  
ATOM   4328  CZ  TYR   568      27.097  13.724  71.472  1.00 64.74           C  
ATOM   4329  OH  TYR   568      28.232  13.235  72.105  1.00 64.10           O  
ATOM   4330  N   ASP   569      23.090  13.585  67.067  1.00 57.85           N  
ATOM   4331  CA  ASP   569      23.615  12.890  65.908  1.00 56.33           C  
ATOM   4332  C   ASP   569      24.232  13.990  65.087  1.00 56.03           C  
ATOM   4333  O   ASP   569      23.559  14.938  64.737  1.00 56.12           O  
ATOM   4334  CB  ASP   569      22.510  12.251  65.079  1.00 56.77           C  
ATOM   4335  CG  ASP   569      21.946  11.018  65.717  1.00 57.76           C  
ATOM   4336  OD1 ASP   569      22.652   9.990  65.751  1.00 58.65           O  
ATOM   4337  OD2 ASP   569      20.792  11.081  66.185  1.00 58.90           O  
ATOM   4338  N   LEU   570      25.516  13.871  64.795  1.00 57.02           N  
ATOM   4339  CA  LEU   570      26.219  14.859  63.999  1.00 56.00           C  
ATOM   4340  C   LEU   570      26.467  14.252  62.639  1.00 56.31           C  
ATOM   4341  O   LEU   570      27.152  13.244  62.516  1.00 56.30           O  
ATOM   4342  CB  LEU   570      27.554  15.215  64.658  1.00 56.74           C  
ATOM   4343  CG  LEU   570      28.512  16.102  63.861  1.00 57.39           C  
ATOM   4344  CD1 LEU   570      27.901  17.490  63.652  1.00 56.03           C  
ATOM   4345  CD2 LEU   570      29.828  16.210  64.609  1.00 57.46           C  
ATOM   4346  N   VAL   571      25.876  14.855  61.617  1.00 57.93           N  
ATOM   4347  CA  VAL   571      26.042  14.394  60.245  1.00 58.55           C  
ATOM   4348  C   VAL   571      26.650  15.532  59.448  1.00 60.15           C  
ATOM   4349  O   VAL   571      26.253  16.687  59.621  1.00 60.53           O  
ATOM   4350  CB  VAL   571      24.708  14.032  59.609  1.00 57.13           C  
ATOM   4351  CG1 VAL   571      24.902  13.782  58.138  1.00 58.68           C  
ATOM   4352  CG2 VAL   571      24.136  12.794  60.270  1.00 57.22           C  
ATOM   4353  N   SER   572      27.614  15.207  58.591  1.00 60.73           N  
ATOM   4354  CA  SER   572      28.272  16.213  57.774  1.00 63.70           C  
ATOM   4355  C   SER   572      27.824  16.087  56.326  1.00 65.35           C  
ATOM   4356  O   SER   572      27.668  14.986  55.809  1.00 65.75           O  
ATOM   4357  CB  SER   572      29.799  16.081  57.877  1.00 64.28           C  
ATOM   4358  OG  SER   572      30.257  14.821  57.420  1.00 64.45           O  
ATOM   4359  N   VAL   573      27.622  17.224  55.673  1.00 67.61           N  
ATOM   4360  CA  VAL   573      27.164  17.233  54.294  1.00 69.83           C  
ATOM   4361  C   VAL   573      28.163  17.804  53.317  1.00 72.18           C  
ATOM   4362  O   VAL   573      28.861  18.765  53.619  1.00 72.98           O  
ATOM   4363  CB  VAL   573      25.869  18.034  54.155  1.00 68.88           C  
ATOM   4364  CG1 VAL   573      25.387  18.003  52.714  1.00 67.14           C  
ATOM   4365  CG2 VAL   573      24.824  17.462  55.087  1.00 68.95           C  
ATOM   4366  N   ARG   574      28.211  17.199  52.137  1.00 75.00           N  
ATOM   4367  CA  ARG   574      29.098  17.623  51.072  1.00 78.02           C  
ATOM   4368  C   ARG   574      28.379  17.353  49.754  1.00 81.00           C  
ATOM   4369  O   ARG   574      27.993  16.218  49.482  1.00 82.42           O  
ATOM   4370  CB  ARG   574      30.409  16.841  51.136  1.00 76.86           C  
ATOM   4371  N   LYS   575      28.177  18.402  48.957  1.00 84.03           N  
ATOM   4372  CA  LYS   575      27.520  18.293  47.653  1.00 85.84           C  
ATOM   4373  C   LYS   575      28.562  17.951  46.591  1.00 88.00           C  
ATOM   4374  O   LYS   575      28.231  17.704  45.430  1.00 88.17           O  
ATOM   4375  CB  LYS   575      26.836  19.606  47.304  1.00 85.96           C  
ATOM   4376  N   SER   576      29.824  17.948  47.013  1.00 90.55           N  
ATOM   4377  CA  SER   576      30.966  17.640  46.155  1.00 92.53           C  
ATOM   4378  C   SER   576      31.394  16.185  46.336  1.00 93.82           C  
ATOM   4379  O   SER   576      30.957  15.516  47.271  1.00 93.67           O  
ATOM   4380  CB  SER   576      32.142  18.548  46.519  1.00 92.82           C  
ATOM   4381  OG  SER   576      32.452  18.444  47.902  1.00 91.73           O  
ATOM   4382  N   GLY   577      32.254  15.708  45.440  1.00 94.85           N  
ATOM   4383  CA  GLY   577      32.746  14.342  45.521  1.00 96.13           C  
ATOM   4384  C   GLY   577      31.767  13.285  46.010  1.00 96.68           C  
ATOM   4385  O   GLY   577      32.093  12.471  46.883  1.00 96.76           O  
ATOM   4386  N   GLY   578      30.558  13.301  45.460  1.00 96.27           N  
ATOM   4387  CA  GLY   578      29.571  12.309  45.840  1.00 95.72           C  
ATOM   4388  C   GLY   578      29.510  11.290  44.719  1.00 95.23           C  
ATOM   4389  O   GLY   578      28.795  10.281  44.797  1.00 95.53           O  
ATOM   4390  N   GLY   579      30.283  11.570  43.669  1.00 93.89           N  
ATOM   4391  CA  GLY   579      30.337  10.708  42.503  1.00 89.91           C  
ATOM   4392  C   GLY   579      29.046  10.806  41.726  1.00 87.45           C  
ATOM   4393  O   GLY   579      28.294  11.763  41.877  1.00 88.09           O  
ATOM   4394  N   ARG   580      28.782   9.811  40.895  1.00 85.01           N  
ATOM   4395  CA  ARG   580      27.569   9.790  40.104  1.00 82.15           C  
ATOM   4396  C   ARG   580      26.792   8.532  40.426  1.00 81.17           C  
ATOM   4397  O   ARG   580      27.259   7.687  41.187  1.00 79.68           O  
ATOM   4398  CB  ARG   580      27.915   9.814  38.623  1.00 82.12           C  
ATOM   4399  CG  ARG   580      28.431  11.144  38.148  1.00 81.14           C  
ATOM   4400  CD  ARG   580      27.316  12.146  38.139  1.00 81.20           C  
ATOM   4401  NE  ARG   580      27.512  13.129  37.083  1.00 82.64           N  
ATOM   4402  CZ  ARG   580      28.253  14.221  37.199  1.00 83.10           C  
ATOM   4403  NH1 ARG   580      28.877  14.485  38.342  1.00 82.51           N  
ATOM   4404  NH2 ARG   580      28.375  15.039  36.163  1.00 82.89           N  
ATOM   4405  N   VAL   581      25.598   8.425  39.857  1.00 80.69           N  
ATOM   4406  CA  VAL   581      24.748   7.261  40.061  1.00 80.30           C  
ATOM   4407  C   VAL   581      23.931   7.044  38.812  1.00 79.97           C  
ATOM   4408  O   VAL   581      23.288   7.961  38.320  1.00 79.38           O  
ATOM   4409  CB  VAL   581      23.780   7.441  41.230  1.00 80.23           C  
ATOM   4410  CG1 VAL   581      22.936   6.193  41.375  1.00 80.02           C  
ATOM   4411  CG2 VAL   581      24.551   7.701  42.517  1.00 79.92           C  
ATOM   4412  N   TYR   582      23.958   5.819  38.309  1.00 81.01           N  
ATOM   4413  CA  TYR   582      23.234   5.465  37.093  1.00 81.67           C  
ATOM   4414  C   TYR   582      22.370   4.230  37.324  1.00 83.39           C  
ATOM   4415  O   TYR   582      22.650   3.415  38.214  1.00 83.10           O  
ATOM   4416  CB  TYR   582      24.232   5.152  35.973  1.00 79.16           C  
ATOM   4417  CG  TYR   582      25.244   6.238  35.710  1.00 75.47           C  
ATOM   4418  CD1 TYR   582      24.952   7.280  34.842  1.00 74.69           C  
ATOM   4419  CD2 TYR   582      26.480   6.243  36.357  1.00 74.02           C  
ATOM   4420  CE1 TYR   582      25.857   8.307  34.621  1.00 74.09           C  
ATOM   4421  CE2 TYR   582      27.398   7.266  36.148  1.00 72.95           C  
ATOM   4422  CZ  TYR   582      27.078   8.300  35.280  1.00 74.55           C  
ATOM   4423  OH  TYR   582      27.954   9.353  35.087  1.00 74.51           O  
ATOM   4424  N   PRO   583      21.298   4.079  36.535  1.00 85.17           N  
ATOM   4425  CA  PRO   583      20.438   2.904  36.700  1.00 87.05           C  
ATOM   4426  C   PRO   583      21.193   1.751  36.045  1.00 89.56           C  
ATOM   4427  O   PRO   583      22.038   1.988  35.167  1.00 89.90           O  
ATOM   4428  CB  PRO   583      19.187   3.255  35.893  1.00 85.33           C  
ATOM   4429  CG  PRO   583      19.231   4.738  35.766  1.00 85.86           C  
ATOM   4430  CD  PRO   583      20.694   5.038  35.600  1.00 85.84           C  
ATOM   4431  N   VAL   584      20.926   0.522  36.479  1.00 91.45           N  
ATOM   4432  CA  VAL   584      21.560  -0.637  35.862  1.00 93.41           C  
ATOM   4433  C   VAL   584      20.709  -0.863  34.621  1.00 94.92           C  
ATOM   4434  O   VAL   584      21.192  -1.296  33.576  1.00 94.27           O  
ATOM   4435  CB  VAL   584      21.489  -1.885  36.759  1.00 93.16           C  
ATOM   4436  CG1 VAL   584      21.967  -3.103  35.987  1.00 93.32           C  
ATOM   4437  CG2 VAL   584      22.347  -1.689  37.993  1.00 93.68           C  
ATOM   4438  N   GLN   585      19.430  -0.530  34.770  1.00 97.43           N  
ATOM   4439  CA  GLN   585      18.425  -0.644  33.720  1.00100.23           C  
ATOM   4440  C   GLN   585      17.187   0.164  34.134  1.00101.07           C  
ATOM   4441  O   GLN   585      16.930   0.340  35.331  1.00100.24           O  
ATOM   4442  CB  GLN   585      18.061  -2.118  33.503  1.00102.50           C  
ATOM   4443  CG  GLN   585      18.913  -2.824  32.447  1.00104.49           C  
ATOM   4444  CD  GLN   585      19.052  -4.315  32.702  1.00105.53           C  
ATOM   4445  OE1 GLN   585      19.126  -5.115  31.764  1.00106.64           O  
ATOM   4446  NE2 GLN   585      19.108  -4.696  33.975  1.00105.11           N  
ATOM   4447  N   GLY   586      16.435   0.648  33.145  1.00101.88           N  
ATOM   4448  CA  GLY   586      15.242   1.442  33.412  1.00103.73           C  
ATOM   4449  C   GLY   586      15.637   2.860  33.762  1.00105.16           C  
ATOM   4450  O   GLY   586      16.760   3.262  33.446  1.00105.31           O  
ATOM   4451  N   ARG   587      14.765   3.657  34.375  1.00106.46           N  
ATOM   4452  CA  ARG   587      15.239   4.977  34.756  1.00107.43           C  
ATOM   4453  C   ARG   587      15.252   5.112  36.263  1.00106.60           C  
ATOM   4454  O   ARG   587      14.850   4.211  37.005  1.00106.33           O  
ATOM   4455  CB  ARG   587      14.464   6.134  34.100  1.00109.57           C  
ATOM   4456  CG  ARG   587      15.450   7.254  33.709  1.00112.86           C  
ATOM   4457  CD  ARG   587      14.829   8.483  33.074  1.00114.93           C  
ATOM   4458  NE  ARG   587      15.392   9.672  33.716  1.00117.52           N  
ATOM   4459  CZ  ARG   587      15.407  10.904  33.215  1.00118.08           C  
ATOM   4460  NH1 ARG   587      15.968  11.876  33.926  1.00117.13           N  
ATOM   4461  NH2 ARG   587      14.891  11.164  32.018  1.00118.51           N  
ATOM   4462  N   LEU   588      15.712   6.276  36.684  1.00105.52           N  
ATOM   4463  CA  LEU   588      15.924   6.590  38.079  1.00103.82           C  
ATOM   4464  C   LEU   588      14.925   7.567  38.706  1.00102.35           C  
ATOM   4465  O   LEU   588      14.653   8.624  38.147  1.00102.83           O  
ATOM   4466  CB  LEU   588      17.341   7.116  38.167  1.00104.39           C  
ATOM   4467  CG  LEU   588      18.128   7.284  39.445  1.00104.70           C  
ATOM   4468  CD1 LEU   588      19.600   7.067  39.151  1.00104.13           C  
ATOM   4469  CD2 LEU   588      17.878   8.668  39.999  1.00106.26           C  
ATOM   4470  N   ALA   589      14.397   7.213  39.880  1.00100.07           N  
ATOM   4471  CA  ALA   589      13.420   8.049  40.579  1.00 97.60           C  
ATOM   4472  C   ALA   589      14.004   9.311  41.224  1.00 96.06           C  
ATOM   4473  O   ALA   589      15.141   9.698  40.947  1.00 96.48           O  
ATOM   4474  CB  ALA   589      12.695   7.228  41.623  1.00 97.97           C  
ATOM   4475  N   ASP   590      13.215   9.941  42.093  1.00 93.76           N  
ATOM   4476  CA  ASP   590      13.614  11.178  42.768  1.00 91.68           C  
ATOM   4477  C   ASP   590      14.342  11.028  44.109  1.00 88.22           C  
ATOM   4478  O   ASP   590      15.567  10.969  44.139  1.00 88.18           O  
ATOM   4479  CB  ASP   590      12.389  12.089  42.956  1.00 94.79           C  
ATOM   4480  CG  ASP   590      12.721  13.392  43.683  1.00 97.21           C  
ATOM   4481  OD1 ASP   590      11.790  14.193  43.924  1.00 98.56           O  
ATOM   4482  OD2 ASP   590      13.905  13.620  44.014  1.00 98.49           O  
ATOM   4483  N   GLY   591      13.595  10.983  45.212  1.00 83.81           N  
ATOM   4484  CA  GLY   591      14.213  10.884  46.528  1.00 78.73           C  
ATOM   4485  C   GLY   591      14.828   9.549  46.901  1.00 75.18           C  
ATOM   4486  O   GLY   591      14.240   8.782  47.663  1.00 75.18           O  
ATOM   4487  N   LEU   592      16.025   9.274  46.391  1.00 71.57           N  
ATOM   4488  CA  LEU   592      16.687   8.009  46.670  1.00 67.14           C  
ATOM   4489  C   LEU   592      17.739   8.053  47.745  1.00 64.47           C  
ATOM   4490  O   LEU   592      18.488   9.021  47.871  1.00 63.34           O  
ATOM   4491  CB  LEU   592      17.332   7.436  45.411  1.00 67.91           C  
ATOM   4492  CG  LEU   592      16.415   7.009  44.273  1.00 68.32           C  
ATOM   4493  CD1 LEU   592      17.212   6.185  43.276  1.00 67.64           C  
ATOM   4494  CD2 LEU   592      15.264   6.197  44.822  1.00 69.12           C  
ATOM   4495  N   TYR   593      17.778   6.965  48.505  1.00 61.49           N  
ATOM   4496  CA  TYR   593      18.712   6.760  49.596  1.00 59.33           C  
ATOM   4497  C   TYR   593      19.657   5.623  49.203  1.00 59.19           C  
ATOM   4498  O   TYR   593      19.235   4.480  49.050  1.00 59.52           O  
ATOM   4499  CB  TYR   593      17.939   6.385  50.860  1.00 57.12           C  
ATOM   4500  CG  TYR   593      18.775   5.767  51.958  1.00 54.35           C  
ATOM   4501  CD1 TYR   593      19.822   6.463  52.540  1.00 52.89           C  
ATOM   4502  CD2 TYR   593      18.479   4.501  52.448  1.00 54.03           C  
ATOM   4503  CE1 TYR   593      20.546   5.919  53.587  1.00 52.50           C  
ATOM   4504  CE2 TYR   593      19.195   3.951  53.488  1.00 52.80           C  
ATOM   4505  CZ  TYR   593      20.222   4.664  54.055  1.00 52.70           C  
ATOM   4506  OH  TYR   593      20.894   4.122  55.118  1.00 54.05           O  
ATOM   4507  N   VAL   594      20.935   5.933  49.028  1.00 57.64           N  
ATOM   4508  CA  VAL   594      21.898   4.908  48.653  1.00 55.45           C  
ATOM   4509  C   VAL   594      22.940   4.717  49.734  1.00 55.57           C  
ATOM   4510  O   VAL   594      23.868   5.500  49.858  1.00 57.23           O  
ATOM   4511  CB  VAL   594      22.608   5.263  47.335  1.00 53.89           C  
ATOM   4512  CG1 VAL   594      23.644   4.222  46.996  1.00 52.13           C  
ATOM   4513  CG2 VAL   594      21.598   5.343  46.221  1.00 54.77           C  
ATOM   4514  N   PRO   595      22.770   3.704  50.580  1.00 55.86           N  
ATOM   4515  CA  PRO   595      23.826   3.579  51.585  1.00 56.51           C  
ATOM   4516  C   PRO   595      25.071   2.972  50.913  1.00 58.78           C  
ATOM   4517  O   PRO   595      24.949   2.138  50.003  1.00 58.47           O  
ATOM   4518  CB  PRO   595      23.191   2.679  52.657  1.00 53.86           C  
ATOM   4519  CG  PRO   595      22.118   1.958  51.945  1.00 53.30           C  
ATOM   4520  CD  PRO   595      21.563   2.959  50.974  1.00 54.05           C  
ATOM   4521  N   LEU   596      26.251   3.413  51.349  1.00 59.89           N  
ATOM   4522  CA  LEU   596      27.518   2.958  50.793  1.00 61.44           C  
ATOM   4523  C   LEU   596      28.376   2.208  51.805  1.00 64.81           C  
ATOM   4524  O   LEU   596      28.847   1.107  51.532  1.00 68.23           O  
ATOM   4525  CB  LEU   596      28.300   4.151  50.233  1.00 59.77           C  
ATOM   4526  CG  LEU   596      28.053   4.557  48.768  1.00 60.61           C  
ATOM   4527  CD1 LEU   596      26.581   4.690  48.507  1.00 59.32           C  
ATOM   4528  CD2 LEU   596      28.762   5.879  48.451  1.00 60.21           C  
ATOM   4529  N   GLU   597      28.605   2.805  52.965  1.00 66.82           N  
ATOM   4530  CA  GLU   597      29.396   2.161  54.000  1.00 68.50           C  
ATOM   4531  C   GLU   597      28.570   2.218  55.282  1.00 69.94           C  
ATOM   4532  O   GLU   597      27.444   2.724  55.279  1.00 70.42           O  
ATOM   4533  CB  GLU   597      30.729   2.881  54.171  1.00 69.59           C  
ATOM   4534  CG  GLU   597      31.498   3.033  52.857  1.00 74.70           C  
ATOM   4535  CD  GLU   597      32.935   3.526  53.044  1.00 78.47           C  
ATOM   4536  OE1 GLU   597      33.126   4.665  53.534  1.00 79.24           O  
ATOM   4537  OE2 GLU   597      33.880   2.770  52.699  1.00 81.10           O  
ATOM   4538  N   ASP   598      29.109   1.700  56.377  1.00 70.61           N  
ATOM   4539  CA  ASP   598      28.364   1.685  57.632  1.00 70.40           C  
ATOM   4540  C   ASP   598      27.849   3.069  58.037  1.00 70.16           C  
ATOM   4541  O   ASP   598      26.738   3.193  58.577  1.00 70.08           O  
ATOM   4542  CB  ASP   598      29.233   1.095  58.753  1.00 70.00           C  
ATOM   4543  N   LYS   599      28.635   4.107  57.746  1.00 68.09           N  
ATOM   4544  CA  LYS   599      28.262   5.466  58.138  1.00 65.83           C  
ATOM   4545  C   LYS   599      28.104   6.512  57.026  1.00 63.72           C  
ATOM   4546  O   LYS   599      28.067   7.704  57.307  1.00 63.76           O  
ATOM   4547  CB  LYS   599      29.283   5.976  59.164  1.00 66.12           C  
ATOM   4548  CG  LYS   599      29.507   5.049  60.357  1.00 67.07           C  
ATOM   4549  CD  LYS   599      28.316   5.073  61.322  1.00 69.38           C  
ATOM   4550  CE  LYS   599      28.630   4.323  62.619  1.00 69.96           C  
ATOM   4551  NZ  LYS   599      27.603   4.535  63.678  1.00 70.19           N  
ATOM   4552  N   THR   600      27.999   6.092  55.772  1.00 62.28           N  
ATOM   4553  CA  THR   600      27.868   7.061  54.677  1.00 60.49           C  
ATOM   4554  C   THR   600      26.777   6.712  53.667  1.00 59.31           C  
ATOM   4555  O   THR   600      26.523   5.546  53.384  1.00 59.73           O  
ATOM   4556  CB  THR   600      29.200   7.211  53.892  1.00 59.11           C  
ATOM   4557  OG1 THR   600      29.642   5.914  53.479  1.00 61.64           O  
ATOM   4558  CG2 THR   600      30.279   7.848  54.750  1.00 57.54           C  
ATOM   4559  N   PHE   601      26.119   7.726  53.129  1.00 57.24           N  
ATOM   4560  CA  PHE   601      25.104   7.456  52.140  1.00 55.79           C  
ATOM   4561  C   PHE   601      24.916   8.621  51.210  1.00 56.02           C  
ATOM   4562  O   PHE   601      25.336   9.741  51.487  1.00 54.44           O  
ATOM   4563  CB  PHE   601      23.775   7.124  52.787  1.00 55.33           C  
ATOM   4564  CG  PHE   601      23.222   8.229  53.633  1.00 54.93           C  
ATOM   4565  CD1 PHE   601      23.719   8.460  54.911  1.00 53.15           C  
ATOM   4566  CD2 PHE   601      22.196   9.036  53.152  1.00 53.59           C  
ATOM   4567  CE1 PHE   601      23.204   9.470  55.697  1.00 53.33           C  
ATOM   4568  CE2 PHE   601      21.674  10.052  53.932  1.00 54.96           C  
ATOM   4569  CZ  PHE   601      22.176  10.272  55.209  1.00 54.27           C  
ATOM   4570  N   LEU   602      24.287   8.326  50.087  1.00 56.43           N  
ATOM   4571  CA  LEU   602      24.018   9.314  49.080  1.00 58.29           C  
ATOM   4572  C   LEU   602      22.537   9.606  49.142  1.00 60.23           C  
ATOM   4573  O   LEU   602      21.756   8.821  49.666  1.00 60.47           O  
ATOM   4574  CB  LEU   602      24.379   8.776  47.687  1.00 57.86           C  
ATOM   4575  CG  LEU   602      25.821   8.358  47.367  1.00 57.90           C  
ATOM   4576  CD1 LEU   602      25.891   7.927  45.906  1.00 55.45           C  
ATOM   4577  CD2 LEU   602      26.794   9.515  47.630  1.00 54.94           C  
ATOM   4578  N   LEU   603      22.161  10.747  48.595  1.00 62.75           N  
ATOM   4579  CA  LEU   603      20.780  11.165  48.558  1.00 63.76           C  
ATOM   4580  C   LEU   603      20.619  11.811  47.196  1.00 65.44           C  
ATOM   4581  O   LEU   603      21.305  12.772  46.886  1.00 65.49           O  
ATOM   4582  CB  LEU   603      20.528  12.182  49.667  1.00 62.83           C  
ATOM   4583  CG  LEU   603      19.254  12.036  50.488  1.00 61.28           C  
ATOM   4584  CD1 LEU   603      19.126  10.632  50.982  1.00 61.01           C  
ATOM   4585  CD2 LEU   603      19.299  12.984  51.657  1.00 61.14           C  
ATOM   4586  N   LEU   604      19.744  11.256  46.372  1.00 68.63           N  
ATOM   4587  CA  LEU   604      19.512  11.806  45.048  1.00 73.76           C  
ATOM   4588  C   LEU   604      18.130  12.402  44.950  1.00 77.67           C  
ATOM   4589  O   LEU   604      17.222  11.973  45.659  1.00 77.20           O  
ATOM   4590  CB  LEU   604      19.615  10.728  43.990  1.00 73.64           C  
ATOM   4591  CG  LEU   604      20.986  10.173  43.696  1.00 75.02           C  
ATOM   4592  CD1 LEU   604      21.069   8.751  44.231  1.00 75.61           C  
ATOM   4593  CD2 LEU   604      21.208  10.222  42.187  1.00 75.72           C  
ATOM   4594  N   THR   605      17.971  13.368  44.049  1.00 82.05           N  
ATOM   4595  CA  THR   605      16.682  14.024  43.829  1.00 87.99           C  
ATOM   4596  C   THR   605      16.614  14.656  42.427  1.00 92.06           C  
ATOM   4597  O   THR   605      17.018  15.804  42.282  1.00 91.89           O  
ATOM   4598  CB  THR   605      16.408  15.187  44.852  1.00 87.19           C  
ATOM   4599  OG1 THR   605      17.508  16.099  44.852  1.00 88.13           O  
ATOM   4600  CG2 THR   605      16.214  14.663  46.265  1.00 88.25           C  
ATOM   4601  N   VAL   606      16.122  13.967  41.380  1.00 96.37           N  
ATOM   4602  CA  VAL   606      16.043  14.652  40.051  1.00 99.98           C  
ATOM   4603  C   VAL   606      14.868  15.710  40.035  1.00102.78           C  
ATOM   4604  O   VAL   606      14.782  16.489  40.980  1.00103.31           O  
ATOM   4605  CB  VAL   606      15.964  13.628  38.912  1.00 99.96           C  
ATOM   4606  N   HIS   607      14.002  15.808  39.024  1.00105.50           N  
ATOM   4607  CA  HIS   607      12.937  16.829  39.087  1.00108.35           C  
ATOM   4608  C   HIS   607      12.801  17.743  37.864  1.00110.39           C  
ATOM   4609  O   HIS   607      13.573  18.687  37.710  1.00111.07           O  
ATOM   4610  N   ARG   608      11.798  17.485  37.022  1.00111.60           N  
ATOM   4611  CA  ARG   608      11.617  18.165  35.737  1.00112.49           C  
ATOM   4612  C   ARG   608      12.201  16.951  35.117  1.00113.49           C  
ATOM   4613  O   ARG   608      12.321  15.954  35.817  1.00114.46           O  
ATOM   4614  CB  ARG   608      12.600  19.350  35.586  1.00112.02           C  
ATOM   4615  N   ASP   609      12.595  16.951  33.862  1.00113.44           N  
ATOM   4616  CA  ASP   609      13.231  15.725  33.615  1.00113.39           C  
ATOM   4617  C   ASP   609      14.525  15.569  32.996  1.00112.81           C  
ATOM   4618  O   ASP   609      14.793  14.899  31.995  1.00112.71           O  
ATOM   4619  CB  ASP   609      12.259  14.637  33.353  1.00113.86           C  
ATOM   4620  CG  ASP   609      12.157  13.828  34.579  1.00114.74           C  
ATOM   4621  OD1 ASP   609      11.061  13.365  35.033  1.00115.24           O  
ATOM   4622  OD2 ASP   609      13.257  13.740  35.130  1.00115.56           O  
ATOM   4623  N   PHE   610      15.342  16.178  33.844  1.00111.79           N  
ATOM   4624  CA  PHE   610      16.726  16.349  33.707  1.00109.89           C  
ATOM   4625  C   PHE   610      17.336  15.471  32.658  1.00109.54           C  
ATOM   4626  O   PHE   610      17.175  14.243  32.650  1.00109.63           O  
ATOM   4627  CB  PHE   610      17.379  16.139  35.053  1.00108.86           C  
ATOM   4628  CG  PHE   610      18.446  17.118  35.325  1.00107.78           C  
ATOM   4629  CD1 PHE   610      18.135  18.455  35.589  1.00107.57           C  
ATOM   4630  CD2 PHE   610      19.767  16.720  35.326  1.00106.43           C  
ATOM   4631  CE1 PHE   610      19.150  19.374  35.857  1.00106.15           C  
ATOM   4632  CE2 PHE   610      20.779  17.620  35.589  1.00105.18           C  
ATOM   4633  CZ  PHE   610      20.477  18.947  35.860  1.00105.48           C  
ATOM   4634  N   ARG   611      18.003  16.138  31.728  1.00108.07           N  
ATOM   4635  CA  ARG   611      18.686  15.463  30.634  1.00106.59           C  
ATOM   4636  C   ARG   611      20.130  15.125  31.024  1.00105.26           C  
ATOM   4637  O   ARG   611      20.723  14.194  30.477  1.00105.05           O  
ATOM   4638  CB  ARG   611      18.713  16.330  29.367  1.00107.68           C  
ATOM   4639  CG  ARG   611      17.368  16.587  28.708  1.00109.30           C  
ATOM   4640  CD  ARG   611      17.569  17.092  27.281  1.00110.11           C  
ATOM   4641  NE  ARG   611      16.346  17.656  26.716  1.00112.12           N  
ATOM   4642  CZ  ARG   611      16.259  18.195  25.502  1.00112.47           C  
ATOM   4643  NH1 ARG   611      17.325  18.241  24.715  1.00112.71           N  
ATOM   4644  NH2 ARG   611      15.110  18.708  25.080  1.00112.47           N  
ATOM   4645  N   GLY   612      20.701  15.882  31.958  1.00103.30           N  
ATOM   4646  CA  GLY   612      22.066  15.617  32.380  1.00100.39           C  
ATOM   4647  C   GLY   612      22.114  14.554  33.457  1.00 98.56           C  
ATOM   4648  O   GLY   612      21.176  13.776  33.615  1.00 98.55           O  
ATOM   4649  N   THR   613      23.210  14.512  34.201  1.00 97.01           N  
ATOM   4650  CA  THR   613      23.356  13.537  35.277  1.00 95.66           C  
ATOM   4651  C   THR   613      23.316  14.265  36.631  1.00 93.38           C  
ATOM   4652  O   THR   613      23.884  15.350  36.790  1.00 92.42           O  
ATOM   4653  CB  THR   613      24.671  12.734  35.109  1.00 96.41           C  
ATOM   4654  OG1 THR   613      24.867  11.876  36.242  1.00 97.68           O  
ATOM   4655  CG2 THR   613      25.848  13.675  34.951  1.00 97.54           C  
ATOM   4656  N   PRO   614      22.633  13.675  37.625  1.00 91.41           N  
ATOM   4657  CA  PRO   614      22.537  14.311  38.942  1.00 89.38           C  
ATOM   4658  C   PRO   614      23.755  14.091  39.830  1.00 87.45           C  
ATOM   4659  O   PRO   614      24.312  13.000  39.862  1.00 87.58           O  
ATOM   4660  CB  PRO   614      21.281  13.678  39.552  1.00 89.43           C  
ATOM   4661  CG  PRO   614      20.746  12.689  38.469  1.00 90.29           C  
ATOM   4662  CD  PRO   614      21.934  12.380  37.622  1.00 90.38           C  
ATOM   4663  N   ARG   615      24.164  15.136  40.539  1.00 84.97           N  
ATOM   4664  CA  ARG   615      25.287  15.056  41.467  1.00 83.05           C  
ATOM   4665  C   ARG   615      24.654  14.870  42.845  1.00 80.76           C  
ATOM   4666  O   ARG   615      24.153  15.824  43.436  1.00 81.45           O  
ATOM   4667  CB  ARG   615      26.110  16.353  41.434  1.00 84.23           C  
ATOM   4668  CG  ARG   615      27.293  16.327  40.478  1.00 86.29           C  
ATOM   4669  CD  ARG   615      27.682  17.713  39.969  1.00 88.45           C  
ATOM   4670  NE  ARG   615      26.683  18.246  39.040  1.00 91.73           N  
ATOM   4671  CZ  ARG   615      26.888  19.260  38.197  1.00 92.76           C  
ATOM   4672  NH1 ARG   615      28.068  19.873  38.152  1.00 91.99           N  
ATOM   4673  NH2 ARG   615      25.907  19.656  37.389  1.00 92.59           N  
ATOM   4674  N   PRO   616      24.653  13.633  43.366  1.00 77.99           N  
ATOM   4675  CA  PRO   616      24.065  13.346  44.679  1.00 75.68           C  
ATOM   4676  C   PRO   616      24.794  14.010  45.848  1.00 74.01           C  
ATOM   4677  O   PRO   616      25.881  14.555  45.670  1.00 73.60           O  
ATOM   4678  CB  PRO   616      24.112  11.822  44.739  1.00 76.27           C  
ATOM   4679  CG  PRO   616      25.339  11.493  43.938  1.00 76.13           C  
ATOM   4680  CD  PRO   616      25.205  12.410  42.756  1.00 77.04           C  
ATOM   4681  N   LEU   617      24.180  13.979  47.033  1.00 71.30           N  
ATOM   4682  CA  LEU   617      24.781  14.562  48.236  1.00 68.30           C  
ATOM   4683  C   LEU   617      25.391  13.458  49.073  1.00 66.32           C  
ATOM   4684  O   LEU   617      24.703  12.500  49.418  1.00 65.75           O  
ATOM   4685  CB  LEU   617      23.732  15.259  49.105  1.00 69.03           C  
ATOM   4686  CG  LEU   617      23.004  16.529  48.659  1.00 69.07           C  
ATOM   4687  CD1 LEU   617      21.788  16.715  49.561  1.00 67.97           C  
ATOM   4688  CD2 LEU   617      23.936  17.745  48.717  1.00 66.95           C  
ATOM   4689  N   LYS   618      26.672  13.592  49.402  1.00 63.61           N  
ATOM   4690  CA  LYS   618      27.349  12.605  50.232  1.00 61.60           C  
ATOM   4691  C   LYS   618      27.148  13.045  51.683  1.00 58.76           C  
ATOM   4692  O   LYS   618      27.395  14.190  52.038  1.00 58.25           O  
ATOM   4693  CB  LYS   618      28.843  12.548  49.880  1.00 64.59           C  
ATOM   4694  CG  LYS   618      29.564  11.281  50.358  1.00 67.29           C  
ATOM   4695  CD  LYS   618      30.944  11.098  49.708  1.00 68.43           C  
ATOM   4696  CE  LYS   618      31.952  12.118  50.222  1.00 71.78           C  
ATOM   4697  NZ  LYS   618      33.316  11.959  49.624  1.00 73.75           N  
ATOM   4698  N   LEU   619      26.671  12.135  52.519  1.00 56.19           N  
ATOM   4699  CA  LEU   619      26.421  12.457  53.918  1.00 53.00           C  
ATOM   4700  C   LEU   619      27.130  11.458  54.791  1.00 50.95           C  
ATOM   4701  O   LEU   619      27.077  10.264  54.533  1.00 49.93           O  
ATOM   4702  CB  LEU   619      24.907  12.449  54.217  1.00 51.72           C  
ATOM   4703  CG  LEU   619      24.099  13.618  53.616  1.00 52.03           C  
ATOM   4704  CD1 LEU   619      23.492  13.242  52.249  1.00 48.17           C  
ATOM   4705  CD2 LEU   619      22.997  14.006  54.597  1.00 51.71           C  
ATOM   4706  N   VAL   620      27.793  11.950  55.829  1.00 50.06           N  
ATOM   4707  CA  VAL   620      28.520  11.072  56.722  1.00 50.88           C  
ATOM   4708  C   VAL   620      28.122  11.191  58.193  1.00 52.09           C  
ATOM   4709  O   VAL   620      28.237  12.243  58.819  1.00 52.98           O  
ATOM   4710  CB  VAL   620      30.047  11.288  56.582  1.00 50.70           C  
ATOM   4711  CG1 VAL   620      30.792  10.336  57.504  1.00 48.15           C  
ATOM   4712  CG2 VAL   620      30.467  11.064  55.122  1.00 49.58           C  
ATOM   4713  N   HIS   621      27.637  10.087  58.736  1.00 52.52           N  
ATOM   4714  CA  HIS   621      27.234  10.049  60.126  1.00 54.24           C  
ATOM   4715  C   HIS   621      28.535   9.986  60.943  1.00 55.51           C  
ATOM   4716  O   HIS   621      29.231   8.976  60.933  1.00 57.01           O  
ATOM   4717  CB  HIS   621      26.348   8.816  60.344  1.00 52.19           C  
ATOM   4718  CG  HIS   621      25.690   8.780  61.682  1.00 49.95           C  
ATOM   4719  ND1 HIS   621      25.554   9.901  62.470  1.00 49.79           N  
ATOM   4720  CD2 HIS   621      25.117   7.766  62.366  1.00 48.63           C  
ATOM   4721  CE1 HIS   621      24.926   9.577  63.585  1.00 49.12           C  
ATOM   4722  NE2 HIS   621      24.650   8.287  63.547  1.00 49.83           N  
ATOM   4723  N   GLU   622      28.863  11.071  61.636  1.00 56.25           N  
ATOM   4724  CA  GLU   622      30.098  11.141  62.403  1.00 57.05           C  
ATOM   4725  C   GLU   622      29.946  10.854  63.894  1.00 58.12           C  
ATOM   4726  O   GLU   622      30.845  10.281  64.511  1.00 59.02           O  
ATOM   4727  CB  GLU   622      30.747  12.507  62.184  1.00 58.06           C  
ATOM   4728  CG  GLU   622      30.819  12.889  60.709  1.00 62.39           C  
ATOM   4729  CD  GLU   622      31.334  14.314  60.467  1.00 66.12           C  
ATOM   4730  OE1 GLU   622      30.847  15.249  61.145  1.00 67.44           O  
ATOM   4731  OE2 GLU   622      32.212  14.503  59.587  1.00 67.38           O  
ATOM   4732  N   ALA   623      28.832  11.261  64.488  1.00 57.86           N  
ATOM   4733  CA  ALA   623      28.596  10.990  65.899  1.00 58.83           C  
ATOM   4734  C   ALA   623      27.132  10.643  65.987  1.00 60.26           C  
ATOM   4735  O   ALA   623      26.342  11.119  65.178  1.00 60.53           O  
ATOM   4736  CB  ALA   623      28.896  12.212  66.747  1.00 58.56           C  
ATOM   4737  N   GLY   624      26.755   9.818  66.953  1.00 60.83           N  
ATOM   4738  CA  GLY   624      25.357   9.455  67.051  1.00 62.40           C  
ATOM   4739  C   GLY   624      25.112   7.966  67.101  1.00 62.64           C  
ATOM   4740  O   GLY   624      25.976   7.169  66.793  1.00 63.72           O  
ATOM   4741  N   ASP   625      23.892   7.598  67.449  1.00 64.31           N  
ATOM   4742  CA  ASP   625      23.520   6.206  67.611  1.00 63.93           C  
ATOM   4743  C   ASP   625      22.377   5.831  66.665  1.00 63.33           C  
ATOM   4744  O   ASP   625      22.080   4.657  66.451  1.00 63.83           O  
ATOM   4745  CB  ASP   625      23.099   6.031  69.071  1.00 66.46           C  
ATOM   4746  CG  ASP   625      23.224   4.615  69.549  1.00 70.81           C  
ATOM   4747  OD1 ASP   625      24.043   3.864  68.973  1.00 73.03           O  
ATOM   4748  OD2 ASP   625      22.511   4.259  70.515  1.00 72.36           O  
ATOM   4749  N   THR   626      21.741   6.842  66.091  1.00 60.45           N  
ATOM   4750  CA  THR   626      20.617   6.622  65.200  1.00 57.55           C  
ATOM   4751  C   THR   626      20.964   5.897  63.913  1.00 55.50           C  
ATOM   4752  O   THR   626      21.995   6.142  63.312  1.00 54.83           O  
ATOM   4753  CB  THR   626      19.947   7.960  64.877  1.00 55.91           C  
ATOM   4754  OG1 THR   626      19.422   8.500  66.088  1.00 54.91           O  
ATOM   4755  CG2 THR   626      18.823   7.789  63.872  1.00 54.87           C  
ATOM   4756  N   PRO   627      20.097   4.975  63.483  1.00 54.84           N  
ATOM   4757  CA  PRO   627      20.298   4.197  62.252  1.00 54.85           C  
ATOM   4758  C   PRO   627      20.447   5.117  61.042  1.00 54.29           C  
ATOM   4759  O   PRO   627      19.838   6.167  61.002  1.00 53.53           O  
ATOM   4760  CB  PRO   627      19.029   3.360  62.177  1.00 53.12           C  
ATOM   4761  CG  PRO   627      18.713   3.141  63.608  1.00 53.59           C  
ATOM   4762  CD  PRO   627      18.916   4.493  64.218  1.00 53.08           C  
ATOM   4763  N   LEU   628      21.245   4.734  60.053  1.00 55.05           N  
ATOM   4764  CA  LEU   628      21.398   5.598  58.890  1.00 55.66           C  
ATOM   4765  C   LEU   628      20.067   5.861  58.195  1.00 55.81           C  
ATOM   4766  O   LEU   628      19.745   7.001  57.917  1.00 56.68           O  
ATOM   4767  CB  LEU   628      22.404   5.020  57.893  1.00 54.95           C  
ATOM   4768  CG  LEU   628      23.904   5.252  58.123  1.00 54.91           C  
ATOM   4769  CD1 LEU   628      24.670   4.834  56.866  1.00 55.51           C  
ATOM   4770  CD2 LEU   628      24.185   6.712  58.405  1.00 53.16           C  
ATOM   4771  N   GLU   629      19.296   4.813  57.931  1.00 56.89           N  
ATOM   4772  CA  GLU   629      18.000   4.940  57.274  1.00 58.00           C  
ATOM   4773  C   GLU   629      17.156   6.035  57.978  1.00 58.26           C  
ATOM   4774  O   GLU   629      16.634   6.937  57.321  1.00 59.42           O  
ATOM   4775  CB  GLU   629      17.262   3.577  57.298  1.00 59.16           C  
ATOM   4776  CG  GLU   629      16.349   3.285  56.081  1.00 63.27           C  
ATOM   4777  CD  GLU   629      15.484   1.990  56.223  1.00 67.20           C  
ATOM   4778  OE1 GLU   629      14.428   2.011  56.906  1.00 67.03           O  
ATOM   4779  OE2 GLU   629      15.860   0.941  55.646  1.00 68.18           O  
ATOM   4780  N   ALA   630      17.021   5.968  59.301  1.00 56.63           N  
ATOM   4781  CA  ALA   630      16.237   6.978  60.025  1.00 55.58           C  
ATOM   4782  C   ALA   630      16.773   8.395  59.768  1.00 54.83           C  
ATOM   4783  O   ALA   630      16.005   9.320  59.526  1.00 55.36           O  
ATOM   4784  CB  ALA   630      16.236   6.675  61.537  1.00 54.68           C  
ATOM   4785  N   LEU   631      18.092   8.552  59.827  1.00 53.44           N  
ATOM   4786  CA  LEU   631      18.755   9.827  59.581  1.00 53.08           C  
ATOM   4787  C   LEU   631      18.530  10.334  58.137  1.00 53.36           C  
ATOM   4788  O   LEU   631      18.319  11.534  57.904  1.00 52.55           O  
ATOM   4789  CB  LEU   631      20.251   9.663  59.842  1.00 52.55           C  
ATOM   4790  CG  LEU   631      21.003  10.435  60.932  1.00 51.06           C  
ATOM   4791  CD1 LEU   631      20.205  10.576  62.193  1.00 50.77           C  
ATOM   4792  CD2 LEU   631      22.285   9.672  61.215  1.00 50.40           C  
ATOM   4793  N   ALA   632      18.585   9.423  57.171  1.00 53.33           N  
ATOM   4794  CA  ALA   632      18.382   9.784  55.769  1.00 55.11           C  
ATOM   4795  C   ALA   632      16.951  10.290  55.536  1.00 56.54           C  
ATOM   4796  O   ALA   632      16.694  11.137  54.678  1.00 56.19           O  
ATOM   4797  CB  ALA   632      18.671   8.585  54.877  1.00 52.98           C  
ATOM   4798  N   HIS   633      16.018   9.772  56.310  1.00 58.41           N  
ATOM   4799  CA  HIS   633      14.639  10.180  56.175  1.00 61.72           C  
ATOM   4800  C   HIS   633      14.416  11.568  56.632  1.00 61.43           C  
ATOM   4801  O   HIS   633      13.736  12.361  55.993  1.00 62.04           O  
ATOM   4802  CB  HIS   633      13.759   9.332  57.043  1.00 66.12           C  
ATOM   4803  CG  HIS   633      13.138   8.199  56.324  1.00 70.02           C  
ATOM   4804  ND1 HIS   633      11.840   8.237  55.869  1.00 72.49           N  
ATOM   4805  CD2 HIS   633      13.638   6.994  55.967  1.00 71.51           C  
ATOM   4806  CE1 HIS   633      11.568   7.096  55.259  1.00 74.39           C  
ATOM   4807  NE2 HIS   633      12.641   6.325  55.305  1.00 72.34           N  
ATOM   4808  N   GLN   634      14.948  11.834  57.804  1.00 59.85           N  
ATOM   4809  CA  GLN   634      14.776  13.131  58.357  1.00 58.93           C  
ATOM   4810  C   GLN   634      15.453  14.177  57.500  1.00 57.39           C  
ATOM   4811  O   GLN   634      14.864  15.195  57.195  1.00 57.55           O  
ATOM   4812  CB  GLN   634      15.296  13.170  59.785  1.00 60.41           C  
ATOM   4813  CG  GLN   634      14.524  14.168  60.598  1.00 62.60           C  
ATOM   4814  CD  GLN   634      14.867  14.122  62.056  1.00 63.88           C  
ATOM   4815  OE1 GLN   634      15.418  13.134  62.552  1.00 65.00           O  
ATOM   4816  NE2 GLN   634      14.524  15.187  62.769  1.00 64.50           N  
ATOM   4817  N   ILE   635      16.680  13.929  57.081  1.00 56.39           N  
ATOM   4818  CA  ILE   635      17.350  14.926  56.277  1.00 55.93           C  
ATOM   4819  C   ILE   635      16.606  15.139  54.977  1.00 57.66           C  
ATOM   4820  O   ILE   635      16.287  16.282  54.614  1.00 57.88           O  
ATOM   4821  CB  ILE   635      18.800  14.525  56.005  1.00 53.28           C  
ATOM   4822  CG1 ILE   635      19.581  14.571  57.316  1.00 51.56           C  
ATOM   4823  CG2 ILE   635      19.419  15.466  55.005  1.00 49.92           C  
ATOM   4824  CD1 ILE   635      20.880  13.836  57.275  1.00 53.17           C  
ATOM   4825  N   PHE   636      16.303  14.036  54.295  1.00 59.01           N  
ATOM   4826  CA  PHE   636      15.593  14.093  53.021  1.00 59.73           C  
ATOM   4827  C   PHE   636      14.287  14.849  53.165  1.00 60.41           C  
ATOM   4828  O   PHE   636      13.950  15.665  52.303  1.00 58.94           O  
ATOM   4829  CB  PHE   636      15.318  12.686  52.489  1.00 59.50           C  
ATOM   4830  CG  PHE   636      14.426  12.660  51.282  1.00 59.22           C  
ATOM   4831  CD1 PHE   636      14.816  13.286  50.094  1.00 59.56           C  
ATOM   4832  CD2 PHE   636      13.180  12.033  51.336  1.00 58.45           C  
ATOM   4833  CE1 PHE   636      13.970  13.297  48.970  1.00 58.49           C  
ATOM   4834  CE2 PHE   636      12.325  12.033  50.219  1.00 58.88           C  
ATOM   4835  CZ  PHE   636      12.723  12.669  49.034  1.00 58.28           C  
ATOM   4836  N   HIS   637      13.557  14.587  54.251  1.00 61.30           N  
ATOM   4837  CA  HIS   637      12.292  15.281  54.473  1.00 64.05           C  
ATOM   4838  C   HIS   637      12.502  16.767  54.762  1.00 66.33           C  
ATOM   4839  O   HIS   637      11.690  17.592  54.366  1.00 67.78           O  
ATOM   4840  CB  HIS   637      11.483  14.626  55.600  1.00 62.63           C  
ATOM   4841  CG  HIS   637      10.771  13.369  55.183  1.00 62.33           C  
ATOM   4842  ND1 HIS   637       9.922  12.677  56.025  1.00 61.36           N  
ATOM   4843  CD2 HIS   637      10.772  12.691  54.011  1.00 59.59           C  
ATOM   4844  CE1 HIS   637       9.432  11.628  55.388  1.00 60.62           C  
ATOM   4845  NE2 HIS   637       9.933  11.613  54.165  1.00 60.24           N  
ATOM   4846  N   LEU   638      13.592  17.121  55.433  1.00 68.96           N  
ATOM   4847  CA  LEU   638      13.851  18.525  55.714  1.00 71.24           C  
ATOM   4848  C   LEU   638      14.179  19.234  54.413  1.00 72.96           C  
ATOM   4849  O   LEU   638      13.727  20.342  54.172  1.00 72.85           O  
ATOM   4850  CB  LEU   638      15.003  18.682  56.709  1.00 71.28           C  
ATOM   4851  CG  LEU   638      14.690  18.270  58.150  1.00 71.29           C  
ATOM   4852  CD1 LEU   638      15.908  18.516  59.032  1.00 70.20           C  
ATOM   4853  CD2 LEU   638      13.480  19.054  58.655  1.00 71.25           C  
ATOM   4854  N   THR   639      14.964  18.586  53.569  1.00 76.08           N  
ATOM   4855  CA  THR   639      15.320  19.160  52.282  1.00 79.92           C  
ATOM   4856  C   THR   639      14.111  19.624  51.473  1.00 83.99           C  
ATOM   4857  O   THR   639      14.052  20.783  51.066  1.00 84.97           O  
ATOM   4858  CB  THR   639      16.089  18.159  51.432  1.00 78.66           C  
ATOM   4859  OG1 THR   639      17.443  18.099  51.897  1.00 77.59           O  
ATOM   4860  CG2 THR   639      16.045  18.562  49.959  1.00 76.87           C  
ATOM   4861  N   ARG   640      13.162  18.724  51.219  1.00 87.69           N  
ATOM   4862  CA  ARG   640      11.972  19.086  50.447  1.00 90.86           C  
ATOM   4863  C   ARG   640      11.179  20.199  51.126  1.00 92.99           C  
ATOM   4864  O   ARG   640      10.896  21.232  50.509  1.00 93.79           O  
ATOM   4865  CB  ARG   640      11.049  17.876  50.247  1.00 92.32           C  
ATOM   4866  CG  ARG   640      11.269  17.077  48.961  1.00 94.07           C  
ATOM   4867  CD  ARG   640      12.554  16.264  49.014  1.00 96.16           C  
ATOM   4868  NE  ARG   640      13.709  16.964  48.456  1.00 97.05           N  
ATOM   4869  CZ  ARG   640      14.015  16.990  47.162  1.00 97.04           C  
ATOM   4870  NH1 ARG   640      13.250  16.353  46.283  1.00 96.78           N  
ATOM   4871  NH2 ARG   640      15.092  17.643  46.748  1.00 96.82           N  
ATOM   4872  N   LEU   641      10.825  19.984  52.393  1.00 94.26           N  
ATOM   4873  CA  LEU   641      10.053  20.958  53.157  1.00 94.92           C  
ATOM   4874  C   LEU   641      10.474  22.396  52.894  1.00 95.62           C  
ATOM   4875  O   LEU   641       9.624  23.276  52.789  1.00 95.48           O  
ATOM   4876  CB  LEU   641      10.150  20.661  54.653  1.00 95.89           C  
ATOM   4877  CG  LEU   641       9.438  21.651  55.582  1.00 97.68           C  
ATOM   4878  CD1 LEU   641       8.059  22.000  55.037  1.00 98.03           C  
ATOM   4879  CD2 LEU   641       9.329  21.040  56.973  1.00 98.61           C  
ATOM   4880  N   TYR   642      11.778  22.638  52.780  1.00 96.08           N  
ATOM   4881  CA  TYR   642      12.261  23.991  52.528  1.00 96.65           C  
ATOM   4882  C   TYR   642      13.021  24.118  51.208  1.00 96.48           C  
ATOM   4883  O   TYR   642      12.342  24.193  50.159  1.00 95.61           O  
ATOM   4884  CB  TYR   642      13.145  24.455  53.689  1.00 98.05           C  
ATOM   4885  CG  TYR   642      12.451  24.449  55.040  1.00 99.99           C  
ATOM   4886  CD1 TYR   642      12.547  23.347  55.897  1.00100.65           C  
ATOM   4887  CD2 TYR   642      11.692  25.546  55.462  1.00100.55           C  
ATOM   4888  CE1 TYR   642      11.906  23.338  57.144  1.00101.31           C  
ATOM   4889  CE2 TYR   642      11.044  25.546  56.706  1.00101.33           C  
ATOM   4890  CZ  TYR   642      11.155  24.439  57.542  1.00101.51           C  
ATOM   4891  OH  TYR   642      10.510  24.431  58.764  1.00101.44           O  
END
