
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  150 ( 1145),  selected  150 , name 2obx_A
# Molecule2: number of CA atoms  150 ( 1143),  selected  150 , name T0487_317_466.pdb
# PARAMETERS: 2obx_A.T0487_317_466.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     6_A      S     317           -
LGA    K     7_A      I     318           -
LGA    -       -      P     319           -
LGA    -       -      K     320           -
LGA    -       -      L     321           -
LGA    -       -      M     322           -
LGA    -       -      G     323           -
LGA    -       -      R     324           -
LGA    -       -      R     325           -
LGA    -       -      A     326           -
LGA    -       -      V     327           -
LGA    -       -      S     328           -
LGA    -       -      K     329           -
LGA    -       -      P     330           -
LGA    -       -      A     331           -
LGA    -       -      D     332           -
LGA    -       -      A     333           -
LGA    -       -      L     334           -
LGA    -       -      R     335           -
LGA    -       -      V     336           -
LGA    -       -      G     337           -
LGA    -       -      F     338           -
LGA    -       -      Y     339           -
LGA    -       -      R     340           -
LGA    -       -      A     341           -
LGA    D     8_A      Q     342           #
LGA    Y     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    T    11_A      E     343          3.381
LGA    V    12_A      T     344          2.576
LGA    R    13_A      A     345          1.708
LGA    I    14_A      L     346          0.923
LGA    A    15_A      A     347          0.782
LGA    V    16_A      L     348          0.444
LGA    V    17_A      L     349          0.769
LGA    R    18_A      R     350          0.768
LGA    A    19_A      L     351          2.223
LGA    R    20_A      D     352          3.556
LGA    W    21_A      G     353          3.668
LGA    H    22_A      -       -           -
LGA    A    23_A      A     354          4.761
LGA    D    24_A      Q     355           -
LGA    I    25_A      -       -           -
LGA    V    26_A      -       -           -
LGA    D    27_A      G     356           #
LGA    Q    28_A      -       -           -
LGA    C    29_A      W     357           #
LGA    V    30_A      P     358          2.988
LGA    S    31_A      E     359          2.737
LGA    A    32_A      F     360          2.733
LGA    F    33_A      L     361          2.384
LGA    E    34_A      R     362          1.778
LGA    A    35_A      R     363          1.636
LGA    E    36_A      A     364          1.631
LGA    M    37_A      L     365          1.318
LGA    A    38_A      L     366          1.121
LGA    D    39_A      R     367          1.497
LGA    I    40_A      A     368          1.313
LGA    G    41_A      F     369          1.968
LGA    G    42_A      G     370          3.212
LGA    -       -      A     371           -
LGA    -       -      S     372           -
LGA    -       -      G     373           -
LGA    D    43_A      A     374          4.400
LGA    R    44_A      S     375          1.919
LGA    F    45_A      L     376          1.345
LGA    A    46_A      R     377          0.835
LGA    V    47_A      L     378          0.394
LGA    D    48_A      H     379          1.449
LGA    V    49_A      T     380          2.109
LGA    F    50_A      L     381          3.078
LGA    D    51_A      H     382          4.638
LGA    V    52_A      A     383          5.889
LGA    P    53_A      H     384          5.713
LGA    G    54_A      -       -           -
LGA    A    55_A      -       -           -
LGA    Y    56_A      -       -           -
LGA    E    57_A      -       -           -
LGA    I    58_A      P     385          3.453
LGA    P    59_A      S     386          4.004
LGA    -       -      Q     387           -
LGA    -       -      G     388           -
LGA    -       -      L     389           -
LGA    L    60_A      A     390           #
LGA    H    61_A      F     391          3.520
LGA    A    62_A      -       -           -
LGA    R    63_A      R     392          4.155
LGA    T    64_A      E     393          3.144
LGA    L    65_A      A     394          3.682
LGA    A    66_A      L     395          3.392
LGA    E    67_A      R     396          1.551
LGA    T    68_A      K     397          2.034
LGA    -       -      A     398           -
LGA    -       -      K     399           -
LGA    G    69_A      E     400          1.614
LGA    R    70_A      E     401          1.679
LGA    -       -      G     402           -
LGA    Y    71_A      V     403          0.809
LGA    G    72_A      Q     404          1.107
LGA    A    73_A      A     405          1.159
LGA    V    74_A      V     406          1.297
LGA    L    75_A      L     407          1.322
LGA    G    76_A      V     408          1.339
LGA    T    77_A      L     409          0.957
LGA    A    78_A      T     410          1.524
LGA    F    79_A      P     411          2.104
LGA    V    80_A      P     412          3.924
LGA    V    81_A      -       -           -
LGA    N    82_A      -       -           -
LGA    G    83_A      -       -           -
LGA    G    84_A      -       -           -
LGA    I    85_A      -       -           -
LGA    Y    86_A      -       -           -
LGA    R    87_A      -       -           -
LGA    H    88_A      -       -           -
LGA    E    89_A      -       -           -
LGA    F    90_A      -       -           -
LGA    V    91_A      M     413           #
LGA    A    92_A      A     414          3.727
LGA    S    93_A      W     415          3.878
LGA    A    94_A      E     416          4.831
LGA    V    95_A      D     417          3.662
LGA    I    96_A      R     418          0.909
LGA    D    97_A      N     419          1.840
LGA    G    98_A      R     420          2.229
LGA    M    99_A      L     421          2.175
LGA    M   100_A      K     422          1.883
LGA    N   101_A      A     423          0.863
LGA    V   102_A      L     424          1.986
LGA    Q   103_A      L     425          3.572
LGA    L   104_A      L     426          3.320
LGA    S   105_A      R     427          1.823
LGA    T   106_A      E     428          1.953
LGA    G   107_A      G     429          2.416
LGA    V   108_A      L     430          2.001
LGA    P   109_A      P     431          0.865
LGA    V   110_A      S     432          1.755
LGA    L   111_A      Q     433          1.676
LGA    S   112_A      I     434          1.427
LGA    A   113_A      L     435          1.678
LGA    V   114_A      N     436          3.807
LGA    L   115_A      V     437          5.309
LGA    T   116_A      -       -           -
LGA    P   117_A      -       -           -
LGA    H   118_A      -       -           -
LGA    N   119_A      -       -           -
LGA    Y   120_A      -       -           -
LGA    H   121_A      -       -           -
LGA    D   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    A   124_A      -       -           -
LGA    E   125_A      -       -           -
LGA    H   126_A      -       -           -
LGA    H   127_A      -       -           -
LGA    R   128_A      -       -           -
LGA    F   129_A      -       -           -
LGA    F   130_A      P     438          4.137
LGA    -       -      L     439           -
LGA    F   131_A      R     440          3.254
LGA    E   132_A      E     441          4.290
LGA    H   133_A      E     442           #
LGA    F   134_A      E     443           #
LGA    T   135_A      R     444           #
LGA    V   136_A      H     445           #
LGA    K   137_A      R     446          3.677
LGA    G   138_A      W     447          3.529
LGA    K   139_A      E     448          3.025
LGA    E   140_A      N     449          2.609
LGA    A   141_A      A     450          2.619
LGA    A   142_A      L     451          2.143
LGA    R   143_A      L     452          2.067
LGA    A   144_A      G     453          1.888
LGA    C   145_A      L     454          1.900
LGA    V   146_A      L     455          1.933
LGA    E   147_A      A     456          2.149
LGA    I   148_A      K     457          2.315
LGA    L   149_A      A     458          2.554
LGA    A   150_A      G     459          3.516
LGA    -       -      L     460           -
LGA    A   151_A      Q     461          4.752
LGA    R   152_A      V     462           -
LGA    E   153_A      V     463           -
LGA    K   154_A      A     464           -
LGA    I   155_A      L     465           -
LGA    -       -      S     466           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  150  150    5.0     99    2.76    14.14     41.509     3.466

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.127298 * X  +  -0.871525 * Y  +   0.473539 * Z  +  19.117348
  Y_new =   0.536078 * X  +   0.341230 * Y  +   0.772128 * Z  +   7.087090
  Z_new =  -0.834515 * X  +   0.352144 * Y  +   0.423767 * Z  +  53.829945 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.693350   -2.448242  [ DEG:    39.7260   -140.2740 ]
  Theta =   0.987252    2.154340  [ DEG:    56.5654    123.4346 ]
  Phi   =   1.803940   -1.337653  [ DEG:   103.3582    -76.6418 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2obx_A                                        
REMARK     2: T0487_317_466.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2obx_A.T0487_317_466.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  150  150   5.0   99   2.76   14.14  41.509
REMARK  ---------------------------------------------------------- 
MOLECULE 2obx_A
HEADER    TRANSFERASE                             20-DEC-06   2OBX              
TITLE     LUMAZINE SYNTHASE RIBH2 FROM MESORHIZOBIUM LOTI (GENE                 
TITLE    2 MLL7281, SWISS-PROT ENTRY Q986N2) COMPLEXED WITH INHIBITOR           
TITLE    3 5-NITRO-6-(D-RIBITYLAMINO)-2,4(1H,3H) PYRIMIDINEDIONE                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 6,7-DIMETHYL-8-RIBITYLLUMAZINE SYNTHASE 1;                 
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J;                                 
COMPND   4 SYNONYM: DMRL SYNTHASE 1; LUMAZINE SYNTHASE 1; RIBOFLAVIN            
COMPND   5 SYNTHASE 1 BETA CHAIN;                                               
COMPND   6 EC: 2.5.1.9;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MESORHIZOBIUM LOTI;                             
SOURCE   3 GENE: RIBH1, RIBH;                                                   
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    LUMAZINE SYNTHASE, ALPHA-BETA, TRANSFERASE                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.KLINKE,V.ZYLBERMAN,H.R.BONOMI,I.HAASE,B.G.GUIMARAES,                
AUTHOR   2 B.C.BRADEN,A.BACHER,M.FISCHER,F.A.GOLDBAUM                           
REVDAT   2   16-OCT-07 2OBX    1       JRNL                                     
REVDAT   1   14-AUG-07 2OBX    0                                                
JRNL        AUTH   S.KLINKE,V.ZYLBERMAN,H.R.BONOMI,I.HAASE,                     
JRNL        AUTH 2 B.G.GUIMARAES,B.C.BRADEN,A.BACHER,M.FISCHER,                 
JRNL        AUTH 3 F.A.GOLDBAUM                                                 
JRNL        TITL   STRUCTURAL AND KINETIC PROPERTIES OF LUMAZINE                
JRNL        TITL 2 SYNTHASE ISOENZYMES IN THE ORDER RHIZOBIALES                 
JRNL        REF    J.MOL.BIOL.                   V. 373   664 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.53 ANGSTROMS.                                          
DBREF  2OBX A    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX B    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX C    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX D    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX E    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX F    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX G    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX H    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX I    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
DBREF  2OBX J    1   157  UNP    Q986N2   RISB1_RHILO      1    157             
SEQRES   1 A  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 A  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 A  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 A  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 A  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 A  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 A  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 A  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 A  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 A  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 A  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 A  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 A  157  ALA                                                          
SEQRES   1 B  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 B  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 B  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 B  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 B  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 B  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 B  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 B  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 B  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 B  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 B  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 B  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 B  157  ALA                                                          
SEQRES   1 C  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 C  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 C  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 C  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 C  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 C  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 C  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 C  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 C  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 C  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 C  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 C  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 C  157  ALA                                                          
SEQRES   1 D  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 D  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 D  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 D  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 D  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 D  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 D  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 D  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 D  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 D  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 D  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 D  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 D  157  ALA                                                          
SEQRES   1 E  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 E  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 E  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 E  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 E  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 E  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 E  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 E  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 E  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 E  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 E  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 E  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 E  157  ALA                                                          
SEQRES   1 F  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 F  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 F  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 F  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 F  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 F  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 F  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 F  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 F  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 F  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 F  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 F  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 F  157  ALA                                                          
SEQRES   1 G  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 G  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 G  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 G  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 G  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 G  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 G  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 G  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 G  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 G  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 G  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 G  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 G  157  ALA                                                          
SEQRES   1 H  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 H  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 H  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 H  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 H  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 H  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 H  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 H  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 H  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 H  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 H  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 H  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 H  157  ALA                                                          
SEQRES   1 I  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 I  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 I  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 I  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 I  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 I  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 I  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 I  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 I  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 I  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 I  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 I  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 I  157  ALA                                                          
SEQRES   1 J  157  MET ASN GLN HIS SER HIS LYS ASP TYR GLU THR VAL ARG          
SEQRES   2 J  157  ILE ALA VAL VAL ARG ALA ARG TRP HIS ALA ASP ILE VAL          
SEQRES   3 J  157  ASP GLN CYS VAL SER ALA PHE GLU ALA GLU MET ALA ASP          
SEQRES   4 J  157  ILE GLY GLY ASP ARG PHE ALA VAL ASP VAL PHE ASP VAL          
SEQRES   5 J  157  PRO GLY ALA TYR GLU ILE PRO LEU HIS ALA ARG THR LEU          
SEQRES   6 J  157  ALA GLU THR GLY ARG TYR GLY ALA VAL LEU GLY THR ALA          
SEQRES   7 J  157  PHE VAL VAL ASN GLY GLY ILE TYR ARG HIS GLU PHE VAL          
SEQRES   8 J  157  ALA SER ALA VAL ILE ASP GLY MET MET ASN VAL GLN LEU          
SEQRES   9 J  157  SER THR GLY VAL PRO VAL LEU SER ALA VAL LEU THR PRO          
SEQRES  10 J  157  HIS ASN TYR HIS ASP SER ALA GLU HIS HIS ARG PHE PHE          
SEQRES  11 J  157  PHE GLU HIS PHE THR VAL LYS GLY LYS GLU ALA ALA ARG          
SEQRES  12 J  157  ALA CYS VAL GLU ILE LEU ALA ALA ARG GLU LYS ILE ALA          
SEQRES  13 J  157  ALA                                                          
HET    PO4  A1001       5                                                       
HET    PO4  B1002       5                                                       
HET    PO4  C1003       5                                                       
HET    PO4  E1004       5                                                       
HET    PO4  F1005       5                                                       
HET    PO4  G1006       5                                                       
HET    PO4  I1007       5                                                       
HET    PO4  J1008       5                                                       
HET    PO4  J1009       5                                                       
HET    INI  A 201      21                                                       
HET    INI  B 202      21                                                       
HET    INI  C 203      21                                                       
HET    INI  D 204      21                                                       
HET    INI  E 205      21                                                       
HET    INI  F 206      21                                                       
HET    INI  G 207      21                                                       
HET    INI  H 208      21                                                       
HET    INI  I 209      21                                                       
HET    INI  J 210      21                                                       
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     INI 5-NITRO-6-RIBITYL-AMINO-2,4(1H,3H)-PYRIMIDINEDIONE               
FORMUL  11  PO4    9(O4 P 3-)                                                   
FORMUL  20  INI    10(C9 H14 N4 O8)                                             
FORMUL  30  HOH   *219(H2 O)                                                    
CRYST1  154.385  122.218   94.929  90.00 125.43  90.00 C 1 2 1      40          
ATOM      1  N   HIS A   6      -1.355  37.393  74.417  1.00 56.30           N  
ATOM      2  CA  HIS A   6      -2.783  36.979  74.513  1.00 56.21           C  
ATOM      3  C   HIS A   6      -3.045  35.928  73.455  1.00 55.26           C  
ATOM      4  O   HIS A   6      -2.135  35.560  72.718  1.00 55.45           O  
ATOM      5  CB  HIS A   6      -3.693  38.175  74.293  1.00 56.28           C  
ATOM      6  N   LYS A   7      -4.281  35.443  73.381  1.00 53.69           N  
ATOM      7  CA  LYS A   7      -4.618  34.435  72.388  1.00 52.25           C  
ATOM      8  C   LYS A   7      -4.586  35.126  71.037  1.00 51.54           C  
ATOM      9  O   LYS A   7      -4.601  36.356  70.964  1.00 50.31           O  
ATOM     10  CB  LYS A   7      -5.996  33.842  72.662  1.00 51.96           C  
ATOM     11  CG  LYS A   7      -6.180  32.431  72.138  1.00 51.76           C  
ATOM     12  CD  LYS A   7      -7.402  31.793  72.784  1.00 52.22           C  
ATOM     13  CE  LYS A   7      -7.616  30.364  72.326  1.00 52.54           C  
ATOM     14  NZ  LYS A   7      -8.801  29.744  72.995  1.00 53.58           N  
ATOM     15  N   ASP A   8      -4.558  34.348  69.962  1.00 50.82           N  
ATOM     16  CA  ASP A   8      -4.466  34.957  68.652  1.00 48.74           C  
ATOM     17  C   ASP A   8      -5.730  35.319  67.879  1.00 46.57           C  
ATOM     18  O   ASP A   8      -6.331  34.506  67.169  1.00 44.97           O  
ATOM     19  CB  ASP A   8      -3.548  34.138  67.761  1.00 50.37           C  
ATOM     20  CG  ASP A   8      -2.948  34.969  66.653  1.00 52.73           C  
ATOM     21  OD1 ASP A   8      -3.728  35.578  65.892  1.00 55.57           O  
ATOM     22  OD2 ASP A   8      -1.704  35.026  66.544  1.00 54.61           O  
ATOM     23  N   TYR A   9      -6.101  36.583  68.040  1.00 44.19           N  
ATOM     24  CA  TYR A   9      -7.230  37.212  67.372  1.00 40.79           C  
ATOM     25  C   TYR A   9      -6.525  38.447  66.827  1.00 38.72           C  
ATOM     26  O   TYR A   9      -7.154  39.420  66.403  1.00 38.59           O  
ATOM     27  CB  TYR A   9      -8.302  37.650  68.385  1.00 39.48           C  
ATOM     28  CG  TYR A   9      -9.129  36.527  68.968  1.00 38.62           C  
ATOM     29  CD1 TYR A   9      -8.609  35.676  69.946  1.00 37.68           C  
ATOM     30  CD2 TYR A   9     -10.431  36.291  68.510  1.00 38.77           C  
ATOM     31  CE1 TYR A   9      -9.363  34.613  70.451  1.00 37.20           C  
ATOM     32  CE2 TYR A   9     -11.194  35.236  69.006  1.00 37.43           C  
ATOM     33  CZ  TYR A   9     -10.653  34.399  69.971  1.00 38.11           C  
ATOM     34  OH  TYR A   9     -11.396  33.334  70.422  1.00 38.71           O  
ATOM     35  N   GLU A  10      -5.196  38.368  66.846  1.00 35.20           N  
ATOM     36  CA  GLU A  10      -4.312  39.451  66.444  1.00 33.43           C  
ATOM     37  C   GLU A  10      -3.839  39.411  65.008  1.00 32.13           C  
ATOM     38  O   GLU A  10      -3.864  38.377  64.355  1.00 33.09           O  
ATOM     39  CB  GLU A  10      -3.103  39.460  67.372  1.00 33.20           C  
ATOM     40  CG  GLU A  10      -3.264  38.485  68.530  1.00 35.60           C  
ATOM     41  CD  GLU A  10      -2.009  38.323  69.353  1.00 37.55           C  
ATOM     42  OE1 GLU A  10      -0.919  38.265  68.745  1.00 39.37           O  
ATOM     43  OE2 GLU A  10      -2.113  38.237  70.600  1.00 36.29           O  
ATOM     44  N   THR A  11      -3.411  40.561  64.517  1.00 31.90           N  
ATOM     45  CA  THR A  11      -2.906  40.670  63.160  1.00 31.33           C  
ATOM     46  C   THR A  11      -1.404  40.894  63.227  1.00 30.01           C  
ATOM     47  O   THR A  11      -0.913  41.661  64.062  1.00 30.39           O  
ATOM     48  CB  THR A  11      -3.552  41.838  62.419  1.00 30.72           C  
ATOM     49  OG1 THR A  11      -4.965  41.615  62.337  1.00 32.20           O  
ATOM     50  CG2 THR A  11      -2.968  41.965  61.017  1.00 30.11           C  
ATOM     51  N   VAL A  12      -0.673  40.202  62.367  1.00 28.30           N  
ATOM     52  CA  VAL A  12       0.775  40.338  62.340  1.00 26.92           C  
ATOM     53  C   VAL A  12       1.134  41.134  61.115  1.00 25.68           C  
ATOM     54  O   VAL A  12       0.707  40.821  60.006  1.00 24.57           O  
ATOM     55  CB  VAL A  12       1.486  38.960  62.284  1.00 26.69           C  
ATOM     56  CG1 VAL A  12       2.982  39.150  62.124  1.00 23.89           C  
ATOM     57  CG2 VAL A  12       1.197  38.176  63.560  1.00 24.98           C  
ATOM     58  N   ARG A  13       1.903  42.192  61.325  1.00 26.55           N  
ATOM     59  CA  ARG A  13       2.311  43.029  60.211  1.00 25.97           C  
ATOM     60  C   ARG A  13       3.624  42.570  59.620  1.00 23.76           C  
ATOM     61  O   ARG A  13       4.548  42.189  60.333  1.00 22.89           O  
ATOM     62  CB  ARG A  13       2.427  44.484  60.650  1.00 26.02           C  
ATOM     63  CG  ARG A  13       1.108  45.067  61.049  1.00 27.13           C  
ATOM     64  CD  ARG A  13       1.122  46.576  61.001  1.00 29.12           C  
ATOM     65  NE  ARG A  13      -0.206  47.056  60.644  1.00 33.20           N  
ATOM     66  CZ  ARG A  13      -0.689  47.036  59.409  1.00 34.18           C  
ATOM     67  NH1 ARG A  13       0.057  46.579  58.417  1.00 37.81           N  
ATOM     68  NH2 ARG A  13      -1.927  47.435  59.169  1.00 36.23           N  
ATOM     69  N   ILE A  14       3.675  42.594  58.298  1.00 23.58           N  
ATOM     70  CA  ILE A  14       4.862  42.222  57.558  1.00 23.61           C  
ATOM     71  C   ILE A  14       5.240  43.463  56.762  1.00 22.76           C  
ATOM     72  O   ILE A  14       4.414  44.019  56.041  1.00 22.87           O  
ATOM     73  CB  ILE A  14       4.585  41.033  56.575  1.00 25.05           C  
ATOM     74  CG1 ILE A  14       4.927  39.696  57.241  1.00 25.41           C  
ATOM     75  CG2 ILE A  14       5.435  41.177  55.307  1.00 24.54           C  
ATOM     76  CD1 ILE A  14       4.207  39.419  58.529  1.00 26.50           C  
ATOM     77  N   ALA A  15       6.479  43.911  56.916  1.00 22.00           N  
ATOM     78  CA  ALA A  15       6.950  45.067  56.175  1.00 20.23           C  
ATOM     79  C   ALA A  15       7.825  44.574  55.035  1.00 19.90           C  
ATOM     80  O   ALA A  15       8.663  43.691  55.209  1.00 20.68           O  
ATOM     81  CB  ALA A  15       7.747  45.996  57.088  1.00 20.33           C  
ATOM     82  N   VAL A  16       7.613  45.137  53.858  1.00 19.64           N  
ATOM     83  CA  VAL A  16       8.391  44.771  52.691  1.00 19.44           C  
ATOM     84  C   VAL A  16       9.255  45.968  52.301  1.00 21.60           C  
ATOM     85  O   VAL A  16       8.728  47.062  52.060  1.00 21.16           O  
ATOM     86  CB  VAL A  16       7.483  44.433  51.506  1.00 17.56           C  
ATOM     87  CG1 VAL A  16       8.318  44.191  50.267  1.00 17.34           C  
ATOM     88  CG2 VAL A  16       6.642  43.237  51.829  1.00 16.15           C  
ATOM     89  N   VAL A  17      10.572  45.772  52.251  1.00 20.37           N  
ATOM     90  CA  VAL A  17      11.470  46.849  51.857  1.00 20.80           C  
ATOM     91  C   VAL A  17      11.975  46.538  50.455  1.00 21.07           C  
ATOM     92  O   VAL A  17      12.940  45.809  50.290  1.00 21.26           O  
ATOM     93  CB  VAL A  17      12.673  46.976  52.815  1.00 21.01           C  
ATOM     94  CG1 VAL A  17      13.587  48.091  52.347  1.00 20.47           C  
ATOM     95  CG2 VAL A  17      12.191  47.256  54.238  1.00 20.26           C  
ATOM     96  N   ARG A  18      11.310  47.089  49.446  1.00 22.00           N  
ATOM     97  CA  ARG A  18      11.686  46.858  48.053  1.00 23.38           C  
ATOM     98  C   ARG A  18      12.604  47.937  47.482  1.00 23.87           C  
ATOM     99  O   ARG A  18      12.364  49.128  47.679  1.00 25.80           O  
ATOM    100  CB  ARG A  18      10.436  46.789  47.183  1.00 22.79           C  
ATOM    101  CG  ARG A  18       9.714  48.117  47.051  1.00 23.06           C  
ATOM    102  CD  ARG A  18       8.576  47.994  46.077  1.00 26.75           C  
ATOM    103  NE  ARG A  18       7.823  49.234  45.945  1.00 30.20           N  
ATOM    104  CZ  ARG A  18       6.647  49.320  45.332  1.00 32.36           C  
ATOM    105  NH1 ARG A  18       6.099  48.235  44.801  1.00 33.52           N  
ATOM    106  NH2 ARG A  18       6.016  50.484  45.255  1.00 33.15           N  
ATOM    107  N   ALA A  19      13.644  47.526  46.765  1.00 24.38           N  
ATOM    108  CA  ALA A  19      14.561  48.486  46.159  1.00 24.86           C  
ATOM    109  C   ALA A  19      13.903  49.033  44.893  1.00 24.99           C  
ATOM    110  O   ALA A  19      12.901  48.488  44.431  1.00 24.74           O  
ATOM    111  CB  ALA A  19      15.885  47.811  45.821  1.00 23.61           C  
ATOM    112  N   ARG A  20      14.452  50.107  44.331  1.00 25.64           N  
ATOM    113  CA  ARG A  20      13.866  50.689  43.125  1.00 26.17           C  
ATOM    114  C   ARG A  20      14.644  50.431  41.833  1.00 27.27           C  
ATOM    115  O   ARG A  20      14.130  50.685  40.746  1.00 28.02           O  
ATOM    116  CB  ARG A  20      13.639  52.191  43.318  1.00 24.80           C  
ATOM    117  CG  ARG A  20      12.634  52.536  44.428  1.00 25.68           C  
ATOM    118  CD  ARG A  20      11.200  52.154  44.058  1.00 22.49           C  
ATOM    119  NE  ARG A  20      11.040  50.713  43.954  1.00 23.39           N  
ATOM    120  CZ  ARG A  20      10.014  50.105  43.370  1.00 22.38           C  
ATOM    121  NH1 ARG A  20       9.035  50.810  42.832  1.00 21.45           N  
ATOM    122  NH2 ARG A  20       9.988  48.782  43.304  1.00 23.69           N  
ATOM    123  N   TRP A  21      15.881  49.951  41.933  1.00 28.43           N  
ATOM    124  CA  TRP A  21      16.632  49.622  40.721  1.00 30.70           C  
ATOM    125  C   TRP A  21      15.879  48.442  40.117  1.00 31.37           C  
ATOM    126  O   TRP A  21      15.587  47.474  40.826  1.00 31.58           O  
ATOM    127  CB  TRP A  21      18.056  49.158  41.040  1.00 30.43           C  
ATOM    128  CG  TRP A  21      19.071  50.246  41.166  1.00 32.67           C  
ATOM    129  CD1 TRP A  21      19.127  51.209  42.132  1.00 31.93           C  
ATOM    130  CD2 TRP A  21      20.209  50.459  40.319  1.00 33.60           C  
ATOM    131  NE1 TRP A  21      20.227  52.004  41.941  1.00 32.75           N  
ATOM    132  CE2 TRP A  21      20.910  51.568  40.835  1.00 34.29           C  
ATOM    133  CE3 TRP A  21      20.705  49.816  39.174  1.00 35.25           C  
ATOM    134  CZ2 TRP A  21      22.090  52.056  40.243  1.00 34.66           C  
ATOM    135  CZ3 TRP A  21      21.878  50.300  38.584  1.00 35.75           C  
ATOM    136  CH2 TRP A  21      22.556  51.412  39.125  1.00 34.73           C  
ATOM    137  N   HIS A  22      15.573  48.508  38.824  1.00 31.22           N  
ATOM    138  CA  HIS A  22      14.844  47.421  38.179  1.00 30.97           C  
ATOM    139  C   HIS A  22      13.489  47.283  38.874  1.00 31.59           C  
ATOM    140  O   HIS A  22      13.011  46.170  39.104  1.00 32.24           O  
ATOM    141  CB  HIS A  22      15.591  46.089  38.329  1.00 30.01           C  
ATOM    142  CG  HIS A  22      17.018  46.124  37.877  1.00 29.29           C  
ATOM    143  ND1 HIS A  22      17.379  46.282  36.556  1.00 28.72           N  
ATOM    144  CD2 HIS A  22      18.172  45.988  38.571  1.00 28.18           C  
ATOM    145  CE1 HIS A  22      18.695  46.240  36.457  1.00 27.77           C  
ATOM    146  NE2 HIS A  22      19.201  46.061  37.664  1.00 29.35           N  
ATOM    147  N   ALA A  23      12.883  48.413  39.224  1.00 31.05           N  
ATOM    148  CA  ALA A  23      11.589  48.407  39.900  1.00 29.96           C  
ATOM    149  C   ALA A  23      10.627  47.460  39.178  1.00 28.93           C  
ATOM    150  O   ALA A  23       9.878  46.710  39.799  1.00 28.44           O  
ATOM    151  CB  ALA A  23      11.016  49.824  39.939  1.00 27.58           C  
ATOM    152  N   ASP A  24      10.665  47.508  37.856  1.00 28.81           N  
ATOM    153  CA  ASP A  24       9.822  46.675  37.014  1.00 27.47           C  
ATOM    154  C   ASP A  24       9.812  45.216  37.492  1.00 25.48           C  
ATOM    155  O   ASP A  24       8.769  44.659  37.843  1.00 23.56           O  
ATOM    156  CB  ASP A  24      10.347  46.759  35.589  1.00 30.80           C  
ATOM    157  CG  ASP A  24       9.504  45.998  34.617  1.00 36.79           C  
ATOM    158  OD1 ASP A  24       9.432  44.763  34.740  1.00 40.74           O  
ATOM    159  OD2 ASP A  24       8.908  46.632  33.721  1.00 42.22           O  
ATOM    160  N   ILE A  25      10.993  44.608  37.510  1.00 23.35           N  
ATOM    161  CA  ILE A  25      11.136  43.222  37.922  1.00 21.76           C  
ATOM    162  C   ILE A  25      10.865  43.022  39.409  1.00 21.24           C  
ATOM    163  O   ILE A  25      10.141  42.102  39.794  1.00 22.44           O  
ATOM    164  CB  ILE A  25      12.553  42.689  37.574  1.00 19.87           C  
ATOM    165  CG1 ILE A  25      12.654  42.448  36.072  1.00 19.79           C  
ATOM    166  CG2 ILE A  25      12.851  41.411  38.326  1.00 17.91           C  
ATOM    167  CD1 ILE A  25      14.003  41.940  35.633  1.00 19.20           C  
ATOM    168  N   VAL A  26      11.438  43.880  40.242  1.00 18.85           N  
ATOM    169  CA  VAL A  26      11.246  43.755  41.674  1.00 20.03           C  
ATOM    170  C   VAL A  26       9.772  43.756  42.055  1.00 21.36           C  
ATOM    171  O   VAL A  26       9.341  42.968  42.892  1.00 18.89           O  
ATOM    172  CB  VAL A  26      11.945  44.901  42.443  1.00 19.73           C  
ATOM    173  CG1 VAL A  26      11.627  44.792  43.933  1.00 18.02           C  
ATOM    174  CG2 VAL A  26      13.447  44.837  42.223  1.00 17.73           C  
ATOM    175  N   ASP A  27       9.007  44.649  41.427  1.00 24.65           N  
ATOM    176  CA  ASP A  27       7.584  44.794  41.705  1.00 25.75           C  
ATOM    177  C   ASP A  27       6.810  43.510  41.488  1.00 26.91           C  
ATOM    178  O   ASP A  27       5.850  43.232  42.211  1.00 28.90           O  
ATOM    179  CB  ASP A  27       6.990  45.921  40.856  1.00 26.96           C  
ATOM    180  CG  ASP A  27       7.219  47.305  41.470  1.00 30.59           C  
ATOM    181  OD1 ASP A  27       6.857  48.320  40.826  1.00 32.47           O  
ATOM    182  OD2 ASP A  27       7.753  47.380  42.600  1.00 27.81           O  
ATOM    183  N   GLN A  28       7.223  42.721  40.503  1.00 25.75           N  
ATOM    184  CA  GLN A  28       6.541  41.462  40.241  1.00 25.52           C  
ATOM    185  C   GLN A  28       6.653  40.545  41.454  1.00 25.06           C  
ATOM    186  O   GLN A  28       5.733  39.774  41.748  1.00 25.70           O  
ATOM    187  CB  GLN A  28       7.132  40.780  39.009  1.00 25.57           C  
ATOM    188  CG  GLN A  28       6.833  41.515  37.728  1.00 26.41           C  
ATOM    189  CD  GLN A  28       5.344  41.715  37.521  1.00 27.53           C  
ATOM    190  OE1 GLN A  28       4.593  40.754  37.379  1.00 30.54           O  
ATOM    191  NE2 GLN A  28       4.911  42.968  37.505  1.00 29.01           N  
ATOM    192  N   CYS A  29       7.775  40.639  42.162  1.00 22.96           N  
ATOM    193  CA  CYS A  29       7.983  39.825  43.347  1.00 21.63           C  
ATOM    194  C   CYS A  29       7.146  40.367  44.497  1.00 22.43           C  
ATOM    195  O   CYS A  29       6.694  39.606  45.361  1.00 25.34           O  
ATOM    196  CB  CYS A  29       9.463  39.810  43.731  1.00 20.14           C  
ATOM    197  SG  CYS A  29       9.810  39.196  45.390  1.00 21.97           S  
ATOM    198  N   VAL A  30       6.922  41.679  44.497  1.00 20.87           N  
ATOM    199  CA  VAL A  30       6.134  42.325  45.542  1.00 20.00           C  
ATOM    200  C   VAL A  30       4.644  41.969  45.486  1.00 19.52           C  
ATOM    201  O   VAL A  30       4.047  41.574  46.493  1.00 18.30           O  
ATOM    202  CB  VAL A  30       6.287  43.859  45.476  1.00 20.36           C  
ATOM    203  CG1 VAL A  30       5.485  44.507  46.596  1.00 17.23           C  
ATOM    204  CG2 VAL A  30       7.771  44.238  45.593  1.00 20.01           C  
ATOM    205  N   SER A  31       4.045  42.106  44.314  1.00 19.09           N  
ATOM    206  CA  SER A  31       2.630  41.793  44.152  1.00 22.38           C  
ATOM    207  C   SER A  31       2.337  40.311  44.392  1.00 23.63           C  
ATOM    208  O   SER A  31       1.354  39.962  45.049  1.00 25.33           O  
ATOM    209  CB  SER A  31       2.183  42.174  42.754  1.00 21.09           C  
ATOM    210  OG  SER A  31       3.118  41.676  41.824  1.00 26.14           O  
ATOM    211  N   ALA A  32       3.190  39.444  43.852  1.00 23.31           N  
ATOM    212  CA  ALA A  32       3.031  38.007  44.021  1.00 22.37           C  
ATOM    213  C   ALA A  32       3.143  37.653  45.499  1.00 23.60           C  
ATOM    214  O   ALA A  32       2.563  36.675  45.961  1.00 24.98           O  
ATOM    215  CB  ALA A  32       4.099  37.274  43.229  1.00 21.40           C  
ATOM    216  N   PHE A  33       3.905  38.454  46.238  1.00 23.90           N  
ATOM    217  CA  PHE A  33       4.085  38.236  47.667  1.00 24.15           C  
ATOM    218  C   PHE A  33       2.790  38.597  48.403  1.00 24.62           C  
ATOM    219  O   PHE A  33       2.280  37.824  49.216  1.00 23.27           O  
ATOM    220  CB  PHE A  33       5.239  39.102  48.177  1.00 22.50           C  
ATOM    221  CG  PHE A  33       5.423  39.060  49.670  1.00 21.94           C  
ATOM    222  CD1 PHE A  33       5.932  37.926  50.292  1.00 22.02           C  
ATOM    223  CD2 PHE A  33       5.101  40.169  50.453  1.00 22.24           C  
ATOM    224  CE1 PHE A  33       6.123  37.894  51.677  1.00 21.84           C  
ATOM    225  CE2 PHE A  33       5.285  40.150  51.839  1.00 21.24           C  
ATOM    226  CZ  PHE A  33       5.798  39.012  52.452  1.00 22.21           C  
ATOM    227  N   GLU A  34       2.261  39.778  48.108  1.00 25.76           N  
ATOM    228  CA  GLU A  34       1.030  40.239  48.738  1.00 26.36           C  
ATOM    229  C   GLU A  34      -0.136  39.294  48.408  1.00 27.40           C  
ATOM    230  O   GLU A  34      -0.933  38.937  49.286  1.00 25.93           O  
ATOM    231  CB  GLU A  34       0.719  41.673  48.281  1.00 25.26           C  
ATOM    232  CG  GLU A  34       1.542  42.740  49.015  1.00 27.06           C  
ATOM    233  CD  GLU A  34       1.203  44.164  48.586  1.00 30.03           C  
ATOM    234  OE1 GLU A  34       1.779  44.633  47.581  1.00 29.64           O  
ATOM    235  OE2 GLU A  34       0.353  44.812  49.249  1.00 31.80           O  
ATOM    236  N   ALA A  35      -0.220  38.887  47.142  1.00 26.83           N  
ATOM    237  CA  ALA A  35      -1.268  37.984  46.699  1.00 26.79           C  
ATOM    238  C   ALA A  35      -1.197  36.675  47.492  1.00 27.91           C  
ATOM    239  O   ALA A  35      -2.175  36.281  48.120  1.00 29.28           O  
ATOM    240  CB  ALA A  35      -1.120  37.712  45.210  1.00 25.24           C  
ATOM    241  N   GLU A  36      -0.041  36.013  47.456  1.00 27.18           N  
ATOM    242  CA  GLU A  36       0.167  34.762  48.179  1.00 27.63           C  
ATOM    243  C   GLU A  36      -0.165  34.941  49.645  1.00 29.26           C  
ATOM    244  O   GLU A  36      -0.892  34.144  50.249  1.00 29.50           O  
ATOM    245  CB  GLU A  36       1.628  34.324  48.079  1.00 26.69           C  
ATOM    246  CG  GLU A  36       1.865  33.164  47.152  1.00 26.91           C  
ATOM    247  CD  GLU A  36       1.063  31.946  47.544  1.00 24.57           C  
ATOM    248  OE1 GLU A  36       1.378  31.325  48.581  1.00 22.98           O  
ATOM    249  OE2 GLU A  36       0.110  31.621  46.811  1.00 24.56           O  
ATOM    250  N   MET A  37       0.411  35.994  50.206  1.00 30.49           N  
ATOM    251  CA  MET A  37       0.232  36.347  51.601  1.00 31.50           C  
ATOM    252  C   MET A  37      -1.260  36.370  51.919  1.00 32.56           C  
ATOM    253  O   MET A  37      -1.714  35.706  52.845  1.00 33.33           O  
ATOM    254  CB  MET A  37       0.853  37.723  51.849  1.00 30.83           C  
ATOM    255  CG  MET A  37       1.551  37.878  53.170  1.00 31.40           C  
ATOM    256  SD  MET A  37       2.840  36.643  53.417  1.00 29.98           S  
ATOM    257  CE  MET A  37       2.805  36.523  55.195  1.00 32.05           C  
ATOM    258  N   ALA A  38      -2.023  37.129  51.140  1.00 33.19           N  
ATOM    259  CA  ALA A  38      -3.467  37.232  51.352  1.00 34.35           C  
ATOM    260  C   ALA A  38      -4.117  35.859  51.211  1.00 34.49           C  
ATOM    261  O   ALA A  38      -4.908  35.433  52.060  1.00 32.61           O  
ATOM    262  CB  ALA A  38      -4.081  38.207  50.338  1.00 33.73           C  
ATOM    263  N   ASP A  39      -3.767  35.182  50.125  1.00 34.53           N  
ATOM    264  CA  ASP A  39      -4.286  33.861  49.820  1.00 35.62           C  
ATOM    265  C   ASP A  39      -4.164  32.890  50.997  1.00 34.90           C  
ATOM    266  O   ASP A  39      -5.131  32.228  51.357  1.00 34.90           O  
ATOM    267  CB  ASP A  39      -3.556  33.305  48.599  1.00 37.87           C  
ATOM    268  CG  ASP A  39      -4.065  31.943  48.183  1.00 40.77           C  
ATOM    269  OD1 ASP A  39      -4.314  31.102  49.073  1.00 44.09           O  
ATOM    270  OD2 ASP A  39      -4.197  31.702  46.963  1.00 42.91           O  
ATOM    271  N   ILE A  40      -2.987  32.804  51.605  1.00 34.70           N  
ATOM    272  CA  ILE A  40      -2.809  31.887  52.725  1.00 36.23           C  
ATOM    273  C   ILE A  40      -2.974  32.531  54.101  1.00 38.35           C  
ATOM    274  O   ILE A  40      -3.473  31.902  55.035  1.00 39.52           O  
ATOM    275  CB  ILE A  40      -1.431  31.187  52.650  1.00 35.07           C  
ATOM    276  CG1 ILE A  40      -0.305  32.207  52.778  1.00 35.55           C  
ATOM    277  CG2 ILE A  40      -1.295  30.469  51.319  1.00 36.12           C  
ATOM    278  CD1 ILE A  40       1.069  31.610  52.584  1.00 34.30           C  
ATOM    279  N   GLY A  41      -2.559  33.786  54.227  1.00 39.80           N  
ATOM    280  CA  GLY A  41      -2.674  34.474  55.500  1.00 40.88           C  
ATOM    281  C   GLY A  41      -4.052  35.049  55.763  1.00 41.27           C  
ATOM    282  O   GLY A  41      -4.591  34.892  56.857  1.00 41.47           O  
ATOM    283  N   GLY A  42      -4.612  35.721  54.761  1.00 42.14           N  
ATOM    284  CA  GLY A  42      -5.932  36.323  54.871  1.00 41.40           C  
ATOM    285  C   GLY A  42      -6.365  36.823  56.238  1.00 41.84           C  
ATOM    286  O   GLY A  42      -6.732  36.032  57.104  1.00 43.69           O  
ATOM    287  N   ASP A  43      -6.326  38.139  56.434  1.00 40.96           N  
ATOM    288  CA  ASP A  43      -6.742  38.763  57.692  1.00 38.83           C  
ATOM    289  C   ASP A  43      -5.829  38.531  58.892  1.00 37.98           C  
ATOM    290  O   ASP A  43      -5.820  39.343  59.819  1.00 39.47           O  
ATOM    291  CB  ASP A  43      -8.178  38.343  58.042  1.00 38.53           C  
ATOM    292  N   ARG A  44      -5.069  37.442  58.897  1.00 35.87           N  
ATOM    293  CA  ARG A  44      -4.174  37.178  60.022  1.00 34.66           C  
ATOM    294  C   ARG A  44      -2.818  37.865  59.816  1.00 34.01           C  
ATOM    295  O   ARG A  44      -1.923  37.751  60.650  1.00 33.74           O  
ATOM    296  CB  ARG A  44      -3.984  35.673  60.208  1.00 33.92           C  
ATOM    297  N   PHE A  45      -2.678  38.572  58.695  1.00 32.90           N  
ATOM    298  CA  PHE A  45      -1.445  39.294  58.354  1.00 30.91           C  
ATOM    299  C   PHE A  45      -1.810  40.539  57.563  1.00 30.32           C  
ATOM    300  O   PHE A  45      -2.849  40.578  56.905  1.00 30.50           O  
ATOM    301  CB  PHE A  45      -0.498  38.451  57.473  1.00 27.61           C  
ATOM    302  CG  PHE A  45      -0.021  37.180  58.115  1.00 25.28           C  
ATOM    303  CD1 PHE A  45      -0.718  35.986  57.933  1.00 22.59           C  
ATOM    304  CD2 PHE A  45       1.129  37.173  58.902  1.00 22.43           C  
ATOM    305  CE1 PHE A  45      -0.275  34.798  58.528  1.00 21.99           C  
ATOM    306  CE2 PHE A  45       1.579  35.994  59.500  1.00 22.60           C  
ATOM    307  CZ  PHE A  45       0.873  34.803  59.312  1.00 20.98           C  
ATOM    308  N   ALA A  46      -0.944  41.546  57.620  1.00 30.04           N  
ATOM    309  CA  ALA A  46      -1.149  42.795  56.890  1.00 29.05           C  
ATOM    310  C   ALA A  46       0.215  43.210  56.332  1.00 28.49           C  
ATOM    311  O   ALA A  46       1.220  43.159  57.051  1.00 29.16           O  
ATOM    312  CB  ALA A  46      -1.698  43.873  57.829  1.00 27.06           C  
ATOM    313  N   VAL A  47       0.245  43.631  55.069  1.00 26.62           N  
ATOM    314  CA  VAL A  47       1.494  44.015  54.414  1.00 25.18           C  
ATOM    315  C   VAL A  47       1.700  45.505  54.110  1.00 25.26           C  
ATOM    316  O   VAL A  47       0.890  46.129  53.421  1.00 23.79           O  
ATOM    317  CB  VAL A  47       1.661  43.263  53.072  1.00 25.33           C  
ATOM    318  CG1 VAL A  47       3.106  43.348  52.605  1.00 23.46           C  
ATOM    319  CG2 VAL A  47       1.218  41.820  53.216  1.00 24.14           C  
ATOM    320  N   ASP A  48       2.805  46.050  54.612  1.00 23.86           N  
ATOM    321  CA  ASP A  48       3.176  47.441  54.366  1.00 25.01           C  
ATOM    322  C   ASP A  48       4.432  47.455  53.490  1.00 25.42           C  
ATOM    323  O   ASP A  48       5.455  46.863  53.847  1.00 24.98           O  
ATOM    324  CB  ASP A  48       3.467  48.184  55.678  1.00 24.59           C  
ATOM    325  CG  ASP A  48       2.237  48.333  56.552  1.00 24.27           C  
ATOM    326  OD1 ASP A  48       1.111  48.262  56.007  1.00 21.59           O  
ATOM    327  OD2 ASP A  48       2.404  48.538  57.779  1.00 24.07           O  
ATOM    328  N   VAL A  49       4.348  48.138  52.353  1.00 25.12           N  
ATOM    329  CA  VAL A  49       5.455  48.227  51.409  1.00 25.42           C  
ATOM    330  C   VAL A  49       6.215  49.549  51.500  1.00 27.12           C  
ATOM    331  O   VAL A  49       5.614  50.621  51.410  1.00 28.30           O  
ATOM    332  CB  VAL A  49       4.943  48.078  49.966  1.00 24.07           C  
ATOM    333  CG1 VAL A  49       6.114  48.081  48.995  1.00 23.98           C  
ATOM    334  CG2 VAL A  49       4.115  46.805  49.838  1.00 23.93           C  
ATOM    335  N   PHE A  50       7.536  49.471  51.664  1.00 27.98           N  
ATOM    336  CA  PHE A  50       8.373  50.670  51.742  1.00 28.50           C  
ATOM    337  C   PHE A  50       9.407  50.721  50.620  1.00 28.82           C  
ATOM    338  O   PHE A  50      10.163  49.774  50.406  1.00 28.73           O  
ATOM    339  CB  PHE A  50       9.097  50.757  53.082  1.00 27.11           C  
ATOM    340  CG  PHE A  50       8.192  50.650  54.270  1.00 28.20           C  
ATOM    341  CD1 PHE A  50       7.789  49.403  54.743  1.00 28.42           C  
ATOM    342  CD2 PHE A  50       7.751  51.791  54.925  1.00 27.58           C  
ATOM    343  CE1 PHE A  50       6.965  49.292  55.853  1.00 28.24           C  
ATOM    344  CE2 PHE A  50       6.927  51.695  56.032  1.00 28.81           C  
ATOM    345  CZ  PHE A  50       6.532  50.439  56.501  1.00 29.51           C  
ATOM    346  N   ASP A  51       9.435  51.847  49.917  1.00 29.70           N  
ATOM    347  CA  ASP A  51      10.360  52.046  48.810  1.00 29.16           C  
ATOM    348  C   ASP A  51      11.724  52.510  49.301  1.00 28.67           C  
ATOM    349  O   ASP A  51      11.836  53.243  50.292  1.00 27.78           O  
ATOM    350  CB  ASP A  51       9.760  53.048  47.819  1.00 28.49           C  
ATOM    351  CG  ASP A  51       8.471  52.532  47.190  1.00 30.11           C  
ATOM    352  OD1 ASP A  51       7.956  51.498  47.667  1.00 28.47           O  
ATOM    353  OD2 ASP A  51       7.970  53.151  46.226  1.00 33.66           O  
ATOM    354  N   VAL A  52      12.764  52.054  48.610  1.00 27.46           N  
ATOM    355  CA  VAL A  52      14.142  52.390  48.955  1.00 26.50           C  
ATOM    356  C   VAL A  52      14.968  52.536  47.670  1.00 25.03           C  
ATOM    357  O   VAL A  52      14.745  51.818  46.684  1.00 24.75           O  
ATOM    358  CB  VAL A  52      14.724  51.312  49.903  1.00 26.56           C  
ATOM    359  CG1 VAL A  52      16.208  51.272  49.805  1.00 30.03           C  
ATOM    360  CG2 VAL A  52      14.315  51.620  51.342  1.00 25.50           C  
ATOM    361  N   PRO A  53      15.927  53.477  47.657  1.00 24.21           N  
ATOM    362  CA  PRO A  53      16.754  53.691  46.460  1.00 24.58           C  
ATOM    363  C   PRO A  53      17.374  52.422  45.855  1.00 24.08           C  
ATOM    364  O   PRO A  53      17.047  52.043  44.726  1.00 24.07           O  
ATOM    365  CB  PRO A  53      17.800  54.699  46.939  1.00 24.01           C  
ATOM    366  CG  PRO A  53      17.065  55.473  47.984  1.00 24.28           C  
ATOM    367  CD  PRO A  53      16.333  54.385  48.743  1.00 23.95           C  
ATOM    368  N   GLY A  54      18.260  51.770  46.606  1.00 22.79           N  
ATOM    369  CA  GLY A  54      18.895  50.555  46.117  1.00 19.40           C  
ATOM    370  C   GLY A  54      19.127  49.512  47.199  1.00 17.07           C  
ATOM    371  O   GLY A  54      19.044  49.814  48.391  1.00 16.69           O  
ATOM    372  N   ALA A  55      19.435  48.287  46.776  1.00 15.42           N  
ATOM    373  CA  ALA A  55      19.670  47.165  47.687  1.00 13.03           C  
ATOM    374  C   ALA A  55      20.523  47.527  48.890  1.00 12.10           C  
ATOM    375  O   ALA A  55      20.274  47.067  50.004  1.00 10.47           O  
ATOM    376  CB  ALA A  55      20.315  46.000  46.929  1.00 14.74           C  
ATOM    377  N   TYR A  56      21.524  48.367  48.674  1.00 14.07           N  
ATOM    378  CA  TYR A  56      22.406  48.764  49.766  1.00 15.38           C  
ATOM    379  C   TYR A  56      21.653  49.452  50.909  1.00 14.69           C  
ATOM    380  O   TYR A  56      22.076  49.376  52.065  1.00 14.27           O  
ATOM    381  CB  TYR A  56      23.519  49.683  49.245  1.00 13.49           C  
ATOM    382  CG  TYR A  56      24.737  49.747  50.146  1.00 12.23           C  
ATOM    383  CD1 TYR A  56      25.560  48.636  50.316  1.00 13.06           C  
ATOM    384  CD2 TYR A  56      25.086  50.925  50.795  1.00 10.93           C  
ATOM    385  CE1 TYR A  56      26.708  48.703  51.105  1.00 12.71           C  
ATOM    386  CE2 TYR A  56      26.224  51.001  51.586  1.00 11.97           C  
ATOM    387  CZ  TYR A  56      27.035  49.889  51.734  1.00 13.30           C  
ATOM    388  OH  TYR A  56      28.190  49.975  52.490  1.00 15.28           O  
ATOM    389  N   GLU A  57      20.538  50.108  50.586  1.00 14.99           N  
ATOM    390  CA  GLU A  57      19.743  50.810  51.599  1.00 17.17           C  
ATOM    391  C   GLU A  57      18.780  49.921  52.390  1.00 17.85           C  
ATOM    392  O   GLU A  57      18.217  50.358  53.394  1.00 18.59           O  
ATOM    393  CB  GLU A  57      18.931  51.954  50.963  1.00 16.19           C  
ATOM    394  CG  GLU A  57      19.708  53.224  50.644  1.00 16.30           C  
ATOM    395  CD  GLU A  57      20.658  53.064  49.474  1.00 15.73           C  
ATOM    396  OE1 GLU A  57      20.197  52.835  48.324  1.00 15.05           O  
ATOM    397  OE2 GLU A  57      21.872  53.166  49.719  1.00 12.26           O  
ATOM    398  N   ILE A  58      18.588  48.682  51.945  1.00 17.65           N  
ATOM    399  CA  ILE A  58      17.669  47.771  52.618  1.00 16.03           C  
ATOM    400  C   ILE A  58      17.982  47.424  54.073  1.00 17.00           C  
ATOM    401  O   ILE A  58      17.101  47.483  54.929  1.00 18.55           O  
ATOM    402  CB  ILE A  58      17.524  46.455  51.819  1.00 17.12           C  
ATOM    403  CG1 ILE A  58      16.854  46.743  50.483  1.00 14.93           C  
ATOM    404  CG2 ILE A  58      16.684  45.442  52.599  1.00 16.77           C  
ATOM    405  CD1 ILE A  58      16.839  45.571  49.567  1.00 15.73           C  
ATOM    406  N   PRO A  59      19.235  47.060  54.387  1.00 16.86           N  
ATOM    407  CA  PRO A  59      19.498  46.721  55.789  1.00 17.02           C  
ATOM    408  C   PRO A  59      19.130  47.784  56.819  1.00 19.10           C  
ATOM    409  O   PRO A  59      18.359  47.522  57.741  1.00 19.79           O  
ATOM    410  CB  PRO A  59      20.989  46.388  55.789  1.00 15.79           C  
ATOM    411  CG  PRO A  59      21.189  45.796  54.432  1.00 13.56           C  
ATOM    412  CD  PRO A  59      20.397  46.736  53.542  1.00 15.68           C  
ATOM    413  N   LEU A  60      19.680  48.984  56.683  1.00 20.65           N  
ATOM    414  CA  LEU A  60      19.367  50.015  57.654  1.00 20.12           C  
ATOM    415  C   LEU A  60      17.867  50.271  57.719  1.00 20.03           C  
ATOM    416  O   LEU A  60      17.332  50.484  58.807  1.00 20.57           O  
ATOM    417  CB  LEU A  60      20.093  51.321  57.330  1.00 18.43           C  
ATOM    418  CG  LEU A  60      19.745  52.432  58.331  1.00 17.92           C  
ATOM    419  CD1 LEU A  60      20.165  52.011  59.748  1.00 13.50           C  
ATOM    420  CD2 LEU A  60      20.423  53.734  57.915  1.00 17.60           C  
ATOM    421  N   HIS A  61      17.187  50.243  56.570  1.00 19.06           N  
ATOM    422  CA  HIS A  61      15.746  50.493  56.556  1.00 20.35           C  
ATOM    423  C   HIS A  61      15.041  49.370  57.293  1.00 21.48           C  
ATOM    424  O   HIS A  61      14.204  49.622  58.156  1.00 22.67           O  
ATOM    425  CB  HIS A  61      15.200  50.598  55.125  1.00 19.91           C  
ATOM    426  CG  HIS A  61      14.144  51.656  54.956  1.00 22.22           C  
ATOM    427  ND1 HIS A  61      14.419  53.005  55.049  1.00 20.97           N  
ATOM    428  CD2 HIS A  61      12.814  51.563  54.705  1.00 21.55           C  
ATOM    429  CE1 HIS A  61      13.306  53.695  54.862  1.00 20.11           C  
ATOM    430  NE2 HIS A  61      12.318  52.845  54.651  1.00 20.26           N  
ATOM    431  N   ALA A  62      15.406  48.131  56.970  1.00 21.75           N  
ATOM    432  CA  ALA A  62      14.809  46.960  57.613  1.00 21.73           C  
ATOM    433  C   ALA A  62      14.996  47.024  59.116  1.00 21.27           C  
ATOM    434  O   ALA A  62      14.138  46.575  59.872  1.00 20.01           O  
ATOM    435  CB  ALA A  62      15.439  45.667  57.070  1.00 20.39           C  
ATOM    436  N   ARG A  63      16.119  47.591  59.548  1.00 22.31           N  
ATOM    437  CA  ARG A  63      16.410  47.688  60.972  1.00 23.76           C  
ATOM    438  C   ARG A  63      15.596  48.754  61.696  1.00 26.17           C  
ATOM    439  O   ARG A  63      15.173  48.548  62.833  1.00 27.93           O  
ATOM    440  CB  ARG A  63      17.894  47.948  61.191  1.00 22.64           C  
ATOM    441  CG  ARG A  63      18.242  48.193  62.646  1.00 23.57           C  
ATOM    442  CD  ARG A  63      19.713  48.467  62.827  1.00 23.08           C  
ATOM    443  NE  ARG A  63      19.988  48.909  64.186  1.00 25.84           N  
ATOM    444  CZ  ARG A  63      20.085  50.182  64.557  1.00 26.58           C  
ATOM    445  NH1 ARG A  63      19.943  51.164  63.668  1.00 24.12           N  
ATOM    446  NH2 ARG A  63      20.298  50.471  65.832  1.00 25.80           N  
ATOM    447  N   THR A  64      15.376  49.895  61.052  1.00 27.00           N  
ATOM    448  CA  THR A  64      14.605  50.960  61.681  1.00 27.32           C  
ATOM    449  C   THR A  64      13.178  50.462  61.871  1.00 26.66           C  
ATOM    450  O   THR A  64      12.584  50.630  62.941  1.00 27.28           O  
ATOM    451  CB  THR A  64      14.588  52.253  60.810  1.00 29.44           C  
ATOM    452  OG1 THR A  64      15.933  52.664  60.520  1.00 29.12           O  
ATOM    453  CG2 THR A  64      13.871  53.381  61.548  1.00 28.06           C  
ATOM    454  N   LEU A  65      12.634  49.856  60.818  1.00 25.98           N  
ATOM    455  CA  LEU A  65      11.284  49.305  60.854  1.00 24.28           C  
ATOM    456  C   LEU A  65      11.235  48.270  61.971  1.00 24.59           C  
ATOM    457  O   LEU A  65      10.479  48.413  62.934  1.00 24.95           O  
ATOM    458  CB  LEU A  65      10.944  48.648  59.510  1.00 22.39           C  
ATOM    459  CG  LEU A  65      10.615  49.577  58.336  1.00 21.91           C  
ATOM    460  CD1 LEU A  65      10.600  48.793  57.039  1.00 21.03           C  
ATOM    461  CD2 LEU A  65       9.260  50.230  58.569  1.00 22.04           C  
ATOM    462  N   ALA A  66      12.070  47.244  61.840  1.00 24.58           N  
ATOM    463  CA  ALA A  66      12.160  46.161  62.808  1.00 23.59           C  
ATOM    464  C   ALA A  66      12.201  46.639  64.257  1.00 24.43           C  
ATOM    465  O   ALA A  66      11.594  46.019  65.130  1.00 22.64           O  
ATOM    466  CB  ALA A  66      13.391  45.320  62.519  1.00 23.81           C  
ATOM    467  N   GLU A  67      12.915  47.731  64.522  1.00 25.87           N  
ATOM    468  CA  GLU A  67      13.008  48.228  65.894  1.00 27.18           C  
ATOM    469  C   GLU A  67      11.800  49.004  66.394  1.00 28.26           C  
ATOM    470  O   GLU A  67      11.726  49.305  67.581  1.00 28.26           O  
ATOM    471  CB  GLU A  67      14.266  49.073  66.089  1.00 27.43           C  
ATOM    472  CG  GLU A  67      15.556  48.254  66.105  1.00 30.43           C  
ATOM    473  CD  GLU A  67      16.794  49.103  66.342  1.00 32.30           C  
ATOM    474  OE1 GLU A  67      16.896  50.195  65.727  1.00 32.59           O  
ATOM    475  OE2 GLU A  67      17.667  48.670  67.130  1.00 31.71           O  
ATOM    476  N   THR A  68      10.851  49.327  65.516  1.00 27.59           N  
ATOM    477  CA  THR A  68       9.666  50.038  65.985  1.00 28.86           C  
ATOM    478  C   THR A  68       8.794  49.021  66.727  1.00 29.67           C  
ATOM    479  O   THR A  68       7.997  49.377  67.593  1.00 30.83           O  
ATOM    480  CB  THR A  68       8.832  50.653  64.831  1.00 27.00           C  
ATOM    481  OG1 THR A  68       8.088  49.621  64.173  1.00 27.63           O  
ATOM    482  CG2 THR A  68       9.734  51.350  63.828  1.00 25.84           C  
ATOM    483  N   GLY A  69       8.960  47.750  66.385  1.00 29.04           N  
ATOM    484  CA  GLY A  69       8.191  46.704  67.034  1.00 29.12           C  
ATOM    485  C   GLY A  69       6.817  46.464  66.426  1.00 29.79           C  
ATOM    486  O   GLY A  69       6.047  45.645  66.938  1.00 28.67           O  
ATOM    487  N   ARG A  70       6.509  47.162  65.334  1.00 29.66           N  
ATOM    488  CA  ARG A  70       5.216  47.015  64.682  1.00 29.72           C  
ATOM    489  C   ARG A  70       5.161  45.866  63.685  1.00 30.13           C  
ATOM    490  O   ARG A  70       4.102  45.583  63.137  1.00 31.35           O  
ATOM    491  CB  ARG A  70       4.815  48.302  63.958  1.00 32.29           C  
ATOM    492  CG  ARG A  70       4.729  49.557  64.832  1.00 36.00           C  
ATOM    493  CD  ARG A  70       3.752  50.568  64.218  1.00 38.72           C  
ATOM    494  NE  ARG A  70       3.979  50.757  62.785  1.00 38.86           N  
ATOM    495  CZ  ARG A  70       4.924  51.542  62.277  1.00 40.68           C  
ATOM    496  NH1 ARG A  70       5.729  52.225  63.091  1.00 38.81           N  
ATOM    497  NH2 ARG A  70       5.073  51.634  60.956  1.00 37.60           N  
ATOM    498  N   TYR A  71       6.286  45.201  63.437  1.00 29.48           N  
ATOM    499  CA  TYR A  71       6.272  44.094  62.485  1.00 28.54           C  
ATOM    500  C   TYR A  71       6.782  42.769  63.028  1.00 28.45           C  
ATOM    501  O   TYR A  71       7.709  42.720  63.835  1.00 29.13           O  
ATOM    502  CB  TYR A  71       7.050  44.469  61.230  1.00 27.57           C  
ATOM    503  CG  TYR A  71       6.528  45.723  60.589  1.00 26.46           C  
ATOM    504  CD1 TYR A  71       6.930  46.971  61.040  1.00 24.87           C  
ATOM    505  CD2 TYR A  71       5.581  45.661  59.569  1.00 26.68           C  
ATOM    506  CE1 TYR A  71       6.406  48.140  60.496  1.00 27.51           C  
ATOM    507  CE2 TYR A  71       5.044  46.820  59.017  1.00 28.73           C  
ATOM    508  CZ  TYR A  71       5.461  48.061  59.488  1.00 29.16           C  
ATOM    509  OH  TYR A  71       4.917  49.219  58.972  1.00 30.57           O  
ATOM    510  N   GLY A  72       6.157  41.688  62.577  1.00 28.45           N  
ATOM    511  CA  GLY A  72       6.558  40.371  63.028  1.00 27.78           C  
ATOM    512  C   GLY A  72       7.679  39.844  62.166  1.00 26.46           C  
ATOM    513  O   GLY A  72       8.374  38.916  62.553  1.00 26.35           O  
ATOM    514  N   ALA A  73       7.847  40.449  60.994  1.00 26.51           N  
ATOM    515  CA  ALA A  73       8.890  40.052  60.049  1.00 25.52           C  
ATOM    516  C   ALA A  73       9.016  41.091  58.944  1.00 24.30           C  
ATOM    517  O   ALA A  73       8.047  41.771  58.605  1.00 24.71           O  
ATOM    518  CB  ALA A  73       8.558  38.689  59.444  1.00 25.01           C  
ATOM    519  N   VAL A  74      10.214  41.205  58.379  1.00 22.60           N  
ATOM    520  CA  VAL A  74      10.459  42.159  57.308  1.00 21.55           C  
ATOM    521  C   VAL A  74      11.022  41.404  56.118  1.00 20.98           C  
ATOM    522  O   VAL A  74      11.828  40.506  56.299  1.00 23.49           O  
ATOM    523  CB  VAL A  74      11.508  43.220  57.728  1.00 21.07           C  
ATOM    524  CG1 VAL A  74      11.507  44.370  56.736  1.00 18.07           C  
ATOM    525  CG2 VAL A  74      11.234  43.699  59.145  1.00 16.57           C  
ATOM    526  N   LEU A  75      10.600  41.757  54.906  1.00 19.99           N  
ATOM    527  CA  LEU A  75      11.117  41.098  53.709  1.00 18.56           C  
ATOM    528  C   LEU A  75      11.868  42.109  52.838  1.00 19.03           C  
ATOM    529  O   LEU A  75      11.287  43.090  52.370  1.00 18.45           O  
ATOM    530  CB  LEU A  75       9.984  40.477  52.874  1.00 16.93           C  
ATOM    531  CG  LEU A  75      10.474  39.882  51.540  1.00 15.23           C  
ATOM    532  CD1 LEU A  75      11.166  38.559  51.813  1.00 11.74           C  
ATOM    533  CD2 LEU A  75       9.319  39.686  50.572  1.00 15.69           C  
ATOM    534  N   GLY A  76      13.159  41.861  52.627  1.00 18.78           N  
ATOM    535  CA  GLY A  76      13.965  42.735  51.794  1.00 18.86           C  
ATOM    536  C   GLY A  76      13.989  42.162  50.390  1.00 19.77           C  
ATOM    537  O   GLY A  76      14.247  40.969  50.203  1.00 20.32           O  
ATOM    538  N   THR A  77      13.714  42.996  49.395  1.00 19.13           N  
ATOM    539  CA  THR A  77      13.702  42.522  48.017  1.00 19.76           C  
ATOM    540  C   THR A  77      14.354  43.537  47.063  1.00 21.44           C  
ATOM    541  O   THR A  77      14.042  44.731  47.070  1.00 19.72           O  
ATOM    542  CB  THR A  77      12.251  42.193  47.570  1.00 18.00           C  
ATOM    543  OG1 THR A  77      12.272  41.600  46.266  1.00 18.06           O  
ATOM    544  CG2 THR A  77      11.388  43.448  47.553  1.00 11.87           C  
ATOM    545  N   ALA A  78      15.280  43.035  46.255  1.00 22.81           N  
ATOM    546  CA  ALA A  78      16.021  43.852  45.308  1.00 23.02           C  
ATOM    547  C   ALA A  78      16.611  42.939  44.236  1.00 23.13           C  
ATOM    548  O   ALA A  78      16.669  41.724  44.408  1.00 23.53           O  
ATOM    549  CB  ALA A  78      17.137  44.589  46.032  1.00 21.46           C  
ATOM    550  N   PHE A  79      17.048  43.537  43.135  1.00 22.82           N  
ATOM    551  CA  PHE A  79      17.636  42.793  42.035  1.00 22.11           C  
ATOM    552  C   PHE A  79      19.048  43.346  41.798  1.00 22.43           C  
ATOM    553  O   PHE A  79      19.230  44.312  41.065  1.00 22.93           O  
ATOM    554  CB  PHE A  79      16.771  42.971  40.783  1.00 20.87           C  
ATOM    555  CG  PHE A  79      17.086  42.006  39.665  1.00 21.55           C  
ATOM    556  CD1 PHE A  79      17.022  42.426  38.335  1.00 21.09           C  
ATOM    557  CD2 PHE A  79      17.414  40.678  39.933  1.00 20.85           C  
ATOM    558  CE1 PHE A  79      17.278  41.545  37.284  1.00 20.42           C  
ATOM    559  CE2 PHE A  79      17.671  39.788  38.891  1.00 22.16           C  
ATOM    560  CZ  PHE A  79      17.603  40.227  37.560  1.00 22.31           C  
ATOM    561  N   VAL A  80      20.042  42.735  42.432  1.00 22.90           N  
ATOM    562  CA  VAL A  80      21.430  43.171  42.291  1.00 24.16           C  
ATOM    563  C   VAL A  80      22.118  42.460  41.126  1.00 24.66           C  
ATOM    564  O   VAL A  80      22.507  41.295  41.249  1.00 25.29           O  
ATOM    565  CB  VAL A  80      22.228  42.880  43.572  1.00 24.37           C  
ATOM    566  CG1 VAL A  80      23.619  43.512  43.483  1.00 22.82           C  
ATOM    567  CG2 VAL A  80      21.459  43.382  44.775  1.00 22.87           C  
ATOM    568  N   VAL A  81      22.284  43.170  40.011  1.00 25.62           N  
ATOM    569  CA  VAL A  81      22.903  42.591  38.821  1.00 25.88           C  
ATOM    570  C   VAL A  81      24.285  43.130  38.514  1.00 27.50           C  
ATOM    571  O   VAL A  81      24.754  44.082  39.133  1.00 29.80           O  
ATOM    572  CB  VAL A  81      22.056  42.829  37.564  1.00 24.75           C  
ATOM    573  CG1 VAL A  81      20.626  42.373  37.797  1.00 26.42           C  
ATOM    574  CG2 VAL A  81      22.110  44.292  37.184  1.00 24.96           C  
ATOM    575  N   ASN A  82      24.921  42.494  37.536  1.00 28.12           N  
ATOM    576  CA  ASN A  82      26.249  42.861  37.064  1.00 26.36           C  
ATOM    577  C   ASN A  82      26.005  43.626  35.762  1.00 26.07           C  
ATOM    578  O   ASN A  82      25.643  43.035  34.740  1.00 25.05           O  
ATOM    579  CB  ASN A  82      27.076  41.589  36.802  1.00 26.68           C  
ATOM    580  CG  ASN A  82      28.453  41.886  36.224  1.00 26.14           C  
ATOM    581  OD1 ASN A  82      28.570  42.405  35.123  1.00 27.76           O  
ATOM    582  ND2 ASN A  82      29.499  41.557  36.972  1.00 26.48           N  
ATOM    583  N   GLY A  83      26.184  44.943  35.811  1.00 24.90           N  
ATOM    584  CA  GLY A  83      25.961  45.764  34.634  1.00 22.17           C  
ATOM    585  C   GLY A  83      27.069  45.718  33.598  1.00 20.96           C  
ATOM    586  O   GLY A  83      26.904  46.247  32.501  1.00 21.57           O  
ATOM    587  N   GLY A  84      28.197  45.103  33.934  1.00 19.87           N  
ATOM    588  CA  GLY A  84      29.286  45.016  32.978  1.00 21.25           C  
ATOM    589  C   GLY A  84      30.284  46.155  33.059  1.00 23.00           C  
ATOM    590  O   GLY A  84      31.119  46.319  32.169  1.00 22.70           O  
ATOM    591  N   ILE A  85      30.204  46.946  34.125  1.00 23.64           N  
ATOM    592  CA  ILE A  85      31.125  48.064  34.307  1.00 23.16           C  
ATOM    593  C   ILE A  85      31.782  47.975  35.674  1.00 21.82           C  
ATOM    594  O   ILE A  85      33.006  48.013  35.780  1.00 22.80           O  
ATOM    595  CB  ILE A  85      30.405  49.431  34.184  1.00 23.11           C  
ATOM    596  CG1 ILE A  85      29.658  49.515  32.850  1.00 22.63           C  
ATOM    597  CG2 ILE A  85      31.426  50.556  34.276  1.00 23.80           C  
ATOM    598  CD1 ILE A  85      28.785  50.750  32.714  1.00 20.67           C  
ATOM    599  N   TYR A  86      30.967  47.846  36.715  1.00 20.77           N  
ATOM    600  CA  TYR A  86      31.466  47.741  38.079  1.00 20.66           C  
ATOM    601  C   TYR A  86      31.119  46.365  38.635  1.00 22.28           C  
ATOM    602  O   TYR A  86      30.247  45.682  38.114  1.00 22.61           O  
ATOM    603  CB  TYR A  86      30.826  48.813  38.976  1.00 21.31           C  
ATOM    604  CG  TYR A  86      30.978  50.228  38.462  1.00 22.67           C  
ATOM    605  CD1 TYR A  86      29.890  50.911  37.906  1.00 22.80           C  
ATOM    606  CD2 TYR A  86      32.225  50.855  38.451  1.00 20.67           C  
ATOM    607  CE1 TYR A  86      30.044  52.177  37.344  1.00 21.66           C  
ATOM    608  CE2 TYR A  86      32.386  52.119  37.892  1.00 22.07           C  
ATOM    609  CZ  TYR A  86      31.295  52.771  37.337  1.00 20.91           C  
ATOM    610  OH  TYR A  86      31.469  54.000  36.756  1.00 22.19           O  
ATOM    611  N   ARG A  87      31.806  45.960  39.692  1.00 23.78           N  
ATOM    612  CA  ARG A  87      31.526  44.681  40.318  1.00 25.28           C  
ATOM    613  C   ARG A  87      30.357  44.867  41.275  1.00 26.36           C  
ATOM    614  O   ARG A  87      30.316  45.827  42.050  1.00 26.39           O  
ATOM    615  CB  ARG A  87      32.733  44.188  41.103  1.00 27.27           C  
ATOM    616  CG  ARG A  87      34.021  44.347  40.374  1.00 29.83           C  
ATOM    617  CD  ARG A  87      35.001  43.299  40.814  1.00 34.69           C  
ATOM    618  NE  ARG A  87      34.915  42.124  39.958  1.00 38.76           N  
ATOM    619  CZ  ARG A  87      35.808  41.139  39.959  1.00 40.34           C  
ATOM    620  NH1 ARG A  87      36.850  41.190  40.781  1.00 38.59           N  
ATOM    621  NH2 ARG A  87      35.674  40.120  39.115  1.00 39.84           N  
ATOM    622  N   HIS A  88      29.412  43.940  41.224  1.00 26.61           N  
ATOM    623  CA  HIS A  88      28.240  44.009  42.073  1.00 26.58           C  
ATOM    624  C   HIS A  88      28.372  43.104  43.293  1.00 26.69           C  
ATOM    625  O   HIS A  88      27.533  43.148  44.188  1.00 27.90           O  
ATOM    626  CB  HIS A  88      27.017  43.596  41.266  1.00 29.21           C  
ATOM    627  CG  HIS A  88      27.090  42.192  40.750  1.00 32.29           C  
ATOM    628  ND1 HIS A  88      28.180  41.708  40.056  1.00 33.18           N  
ATOM    629  CD2 HIS A  88      26.221  41.160  40.850  1.00 32.69           C  
ATOM    630  CE1 HIS A  88      27.979  40.437  39.754  1.00 31.69           C  
ATOM    631  NE2 HIS A  88      26.798  40.081  40.224  1.00 34.33           N  
ATOM    632  N   GLU A  89      29.425  42.296  43.341  1.00 25.48           N  
ATOM    633  CA  GLU A  89      29.604  41.361  44.451  1.00 26.81           C  
ATOM    634  C   GLU A  89      29.657  41.962  45.841  1.00 24.89           C  
ATOM    635  O   GLU A  89      28.946  41.509  46.735  1.00 26.89           O  
ATOM    636  CB  GLU A  89      30.864  40.503  44.259  1.00 29.69           C  
ATOM    637  CG  GLU A  89      30.848  39.627  43.028  1.00 33.49           C  
ATOM    638  CD  GLU A  89      31.191  40.393  41.769  1.00 35.81           C  
ATOM    639  OE1 GLU A  89      32.366  40.792  41.610  1.00 36.57           O  
ATOM    640  OE2 GLU A  89      30.283  40.600  40.941  1.00 37.58           O  
ATOM    641  N   PHE A  90      30.504  42.966  46.028  1.00 23.66           N  
ATOM    642  CA  PHE A  90      30.658  43.589  47.338  1.00 21.63           C  
ATOM    643  C   PHE A  90      29.342  44.088  47.927  1.00 20.16           C  
ATOM    644  O   PHE A  90      29.056  43.847  49.103  1.00 18.68           O  
ATOM    645  CB  PHE A  90      31.687  44.725  47.255  1.00 23.04           C  
ATOM    646  CG  PHE A  90      32.997  44.311  46.628  1.00 23.65           C  
ATOM    647  CD1 PHE A  90      33.418  44.867  45.421  1.00 22.83           C  
ATOM    648  CD2 PHE A  90      33.783  43.318  47.211  1.00 24.11           C  
ATOM    649  CE1 PHE A  90      34.601  44.435  44.800  1.00 23.37           C  
ATOM    650  CE2 PHE A  90      34.967  42.881  46.593  1.00 24.24           C  
ATOM    651  CZ  PHE A  90      35.370  43.443  45.384  1.00 20.51           C  
ATOM    652  N   VAL A  91      28.535  44.769  47.118  1.00 18.93           N  
ATOM    653  CA  VAL A  91      27.250  45.276  47.598  1.00 18.89           C  
ATOM    654  C   VAL A  91      26.319  44.120  47.930  1.00 18.93           C  
ATOM    655  O   VAL A  91      25.789  44.048  49.045  1.00 20.12           O  
ATOM    656  CB  VAL A  91      26.577  46.194  46.555  1.00 18.48           C  
ATOM    657  CG1 VAL A  91      25.170  46.565  46.993  1.00 14.57           C  
ATOM    658  CG2 VAL A  91      27.418  47.451  46.386  1.00 19.23           C  
ATOM    659  N   ALA A  92      26.135  43.215  46.970  1.00 16.58           N  
ATOM    660  CA  ALA A  92      25.281  42.049  47.154  1.00 15.55           C  
ATOM    661  C   ALA A  92      25.645  41.320  48.435  1.00 16.04           C  
ATOM    662  O   ALA A  92      24.775  40.941  49.223  1.00 15.39           O  
ATOM    663  CB  ALA A  92      25.422  41.115  45.983  1.00 16.84           C  
ATOM    664  N   SER A  93      26.940  41.131  48.648  1.00 15.86           N  
ATOM    665  CA  SER A  93      27.401  40.449  49.843  1.00 16.98           C  
ATOM    666  C   SER A  93      27.112  41.254  51.114  1.00 18.72           C  
ATOM    667  O   SER A  93      26.740  40.679  52.147  1.00 20.91           O  
ATOM    668  CB  SER A  93      28.903  40.158  49.747  1.00 15.48           C  
ATOM    669  OG  SER A  93      29.412  39.787  51.020  1.00 15.99           O  
ATOM    670  N   ALA A  94      27.283  42.576  51.047  1.00 16.74           N  
ATOM    671  CA  ALA A  94      27.046  43.415  52.216  1.00 14.22           C  
ATOM    672  C   ALA A  94      25.557  43.491  52.550  1.00 13.33           C  
ATOM    673  O   ALA A  94      25.181  43.557  53.719  1.00 11.41           O  
ATOM    674  CB  ALA A  94      27.620  44.817  51.992  1.00 15.28           C  
ATOM    675  N   VAL A  95      24.712  43.480  51.521  1.00 12.58           N  
ATOM    676  CA  VAL A  95      23.266  43.531  51.733  1.00 12.81           C  
ATOM    677  C   VAL A  95      22.784  42.203  52.342  1.00 13.86           C  
ATOM    678  O   VAL A  95      21.995  42.205  53.294  1.00 11.78           O  
ATOM    679  CB  VAL A  95      22.524  43.849  50.399  1.00 11.80           C  
ATOM    680  CG1 VAL A  95      21.032  43.708  50.562  1.00 10.66           C  
ATOM    681  CG2 VAL A  95      22.852  45.264  49.958  1.00  8.79           C  
ATOM    682  N   ILE A  96      23.286  41.076  51.823  1.00 13.70           N  
ATOM    683  CA  ILE A  96      22.903  39.767  52.350  1.00 13.53           C  
ATOM    684  C   ILE A  96      23.423  39.591  53.785  1.00 14.83           C  
ATOM    685  O   ILE A  96      22.692  39.102  54.645  1.00 15.71           O  
ATOM    686  CB  ILE A  96      23.401  38.594  51.421  1.00 13.27           C  
ATOM    687  CG1 ILE A  96      22.283  38.136  50.484  1.00  8.55           C  
ATOM    688  CG2 ILE A  96      23.768  37.359  52.247  1.00 13.13           C  
ATOM    689  CD1 ILE A  96      21.766  39.152  49.547  1.00  4.76           C  
ATOM    690  N   ASP A  97      24.669  39.990  54.051  1.00 17.76           N  
ATOM    691  CA  ASP A  97      25.235  39.894  55.414  1.00 19.71           C  
ATOM    692  C   ASP A  97      24.562  40.902  56.356  1.00 19.78           C  
ATOM    693  O   ASP A  97      24.321  40.609  57.534  1.00 19.18           O  
ATOM    694  CB  ASP A  97      26.750  40.198  55.442  1.00 21.98           C  
ATOM    695  CG  ASP A  97      27.604  39.091  54.835  1.00 22.93           C  
ATOM    696  OD1 ASP A  97      27.370  37.901  55.151  1.00 22.26           O  
ATOM    697  OD2 ASP A  97      28.528  39.424  54.052  1.00 23.69           O  
ATOM    698  N   GLY A  98      24.296  42.099  55.829  1.00 20.40           N  
ATOM    699  CA  GLY A  98      23.669  43.156  56.608  1.00 19.97           C  
ATOM    700  C   GLY A  98      22.314  42.771  57.175  1.00 21.32           C  
ATOM    701  O   GLY A  98      22.011  43.056  58.342  1.00 19.27           O  
ATOM    702  N   MET A  99      21.486  42.124  56.357  1.00 21.24           N  
ATOM    703  CA  MET A  99      20.174  41.721  56.836  1.00 22.72           C  
ATOM    704  C   MET A  99      20.346  40.718  57.964  1.00 24.65           C  
ATOM    705  O   MET A  99      19.727  40.864  59.017  1.00 28.01           O  
ATOM    706  CB  MET A  99      19.329  41.117  55.707  1.00 21.17           C  
ATOM    707  CG  MET A  99      18.878  42.131  54.683  1.00 17.44           C  
ATOM    708  SD  MET A  99      17.658  41.485  53.554  1.00 17.59           S  
ATOM    709  CE  MET A  99      18.661  40.841  52.260  1.00 18.12           C  
ATOM    710  N   MET A 100      21.195  39.710  57.751  1.00 24.46           N  
ATOM    711  CA  MET A 100      21.436  38.699  58.777  1.00 21.45           C  
ATOM    712  C   MET A 100      21.881  39.431  60.038  1.00 23.21           C  
ATOM    713  O   MET A 100      21.496  39.066  61.152  1.00 24.84           O  
ATOM    714  CB  MET A 100      22.524  37.720  58.319  1.00 18.17           C  
ATOM    715  CG  MET A 100      22.827  36.582  59.291  1.00 14.67           C  
ATOM    716  SD  MET A 100      21.438  35.436  59.561  1.00 17.32           S  
ATOM    717  CE  MET A 100      21.221  34.748  57.924  1.00  8.23           C  
ATOM    718  N   ASN A 101      22.686  40.476  59.855  1.00 23.77           N  
ATOM    719  CA  ASN A 101      23.188  41.270  60.975  1.00 22.22           C  
ATOM    720  C   ASN A 101      21.998  41.857  61.726  1.00 20.61           C  
ATOM    721  O   ASN A 101      21.912  41.762  62.953  1.00 18.90           O  
ATOM    722  CB  ASN A 101      24.117  42.382  60.448  1.00 23.38           C  
ATOM    723  CG  ASN A 101      24.539  43.377  61.533  1.00 26.67           C  
ATOM    724  OD1 ASN A 101      23.803  44.311  61.857  1.00 28.84           O  
ATOM    725  ND2 ASN A 101      25.726  43.177  62.099  1.00 26.74           N  
ATOM    726  N   VAL A 102      21.066  42.432  60.974  1.00 20.53           N  
ATOM    727  CA  VAL A 102      19.878  43.050  61.551  1.00 20.35           C  
ATOM    728  C   VAL A 102      19.006  42.060  62.307  1.00 19.92           C  
ATOM    729  O   VAL A 102      18.744  42.231  63.495  1.00 18.42           O  
ATOM    730  CB  VAL A 102      19.021  43.730  60.459  1.00 20.84           C  
ATOM    731  CG1 VAL A 102      17.796  44.390  61.077  1.00 22.21           C  
ATOM    732  CG2 VAL A 102      19.854  44.767  59.731  1.00 22.05           C  
ATOM    733  N   GLN A 103      18.569  41.008  61.630  1.00 20.84           N  
ATOM    734  CA  GLN A 103      17.705  40.044  62.291  1.00 23.03           C  
ATOM    735  C   GLN A 103      18.294  39.463  63.563  1.00 23.80           C  
ATOM    736  O   GLN A 103      17.557  39.200  64.510  1.00 24.38           O  
ATOM    737  CB  GLN A 103      17.283  38.916  61.337  1.00 23.23           C  
ATOM    738  CG  GLN A 103      18.369  37.960  60.875  1.00 23.80           C  
ATOM    739  CD  GLN A 103      17.773  36.766  60.156  1.00 24.97           C  
ATOM    740  OE1 GLN A 103      17.173  35.895  60.783  1.00 28.37           O  
ATOM    741  NE2 GLN A 103      17.910  36.732  58.838  1.00 24.93           N  
ATOM    742  N   LEU A 104      19.605  39.266  63.612  1.00 23.86           N  
ATOM    743  CA  LEU A 104      20.194  38.720  64.829  1.00 25.09           C  
ATOM    744  C   LEU A 104      20.243  39.761  65.942  1.00 27.04           C  
ATOM    745  O   LEU A 104      20.045  39.429  67.116  1.00 27.85           O  
ATOM    746  CB  LEU A 104      21.602  38.181  64.571  1.00 24.41           C  
ATOM    747  CG  LEU A 104      21.724  36.872  63.785  1.00 25.79           C  
ATOM    748  CD1 LEU A 104      23.200  36.514  63.636  1.00 24.29           C  
ATOM    749  CD2 LEU A 104      20.968  35.752  64.505  1.00 25.20           C  
ATOM    750  N   SER A 105      20.501  41.016  65.575  1.00 27.80           N  
ATOM    751  CA  SER A 105      20.581  42.089  66.563  1.00 26.94           C  
ATOM    752  C   SER A 105      19.194  42.469  67.055  1.00 25.33           C  
ATOM    753  O   SER A 105      18.969  42.574  68.260  1.00 25.57           O  
ATOM    754  CB  SER A 105      21.272  43.331  65.977  1.00 27.64           C  
ATOM    755  OG  SER A 105      20.347  44.183  65.323  1.00 28.00           O  
ATOM    756  N   THR A 106      18.262  42.672  66.131  1.00 23.73           N  
ATOM    757  CA  THR A 106      16.900  43.037  66.519  1.00 23.06           C  
ATOM    758  C   THR A 106      16.108  41.818  66.970  1.00 22.09           C  
ATOM    759  O   THR A 106      15.248  41.921  67.840  1.00 22.87           O  
ATOM    760  CB  THR A 106      16.125  43.704  65.372  1.00 21.22           C  
ATOM    761  OG1 THR A 106      15.797  42.723  64.390  1.00 20.49           O  
ATOM    762  CG2 THR A 106      16.957  44.811  64.736  1.00 20.08           C  
ATOM    763  N   GLY A 107      16.411  40.664  66.388  1.00 21.71           N  
ATOM    764  CA  GLY A 107      15.707  39.445  66.753  1.00 22.97           C  
ATOM    765  C   GLY A 107      14.468  39.255  65.897  1.00 23.48           C  
ATOM    766  O   GLY A 107      13.770  38.248  65.986  1.00 24.38           O  
ATOM    767  N   VAL A 108      14.203  40.241  65.053  1.00 23.84           N  
ATOM    768  CA  VAL A 108      13.052  40.214  64.175  1.00 22.95           C  
ATOM    769  C   VAL A 108      13.477  39.526  62.895  1.00 22.92           C  
ATOM    770  O   VAL A 108      14.532  39.825  62.357  1.00 23.55           O  
ATOM    771  CB  VAL A 108      12.578  41.657  63.862  1.00 24.56           C  
ATOM    772  CG1 VAL A 108      11.421  41.635  62.870  1.00 24.97           C  
ATOM    773  CG2 VAL A 108      12.176  42.366  65.158  1.00 20.14           C  
ATOM    774  N   PRO A 109      12.678  38.561  62.413  1.00 23.19           N  
ATOM    775  CA  PRO A 109      13.000  37.838  61.178  1.00 22.86           C  
ATOM    776  C   PRO A 109      13.022  38.751  59.953  1.00 22.85           C  
ATOM    777  O   PRO A 109      12.128  39.580  59.772  1.00 24.25           O  
ATOM    778  CB  PRO A 109      11.888  36.797  61.088  1.00 23.01           C  
ATOM    779  CG  PRO A 109      11.607  36.490  62.535  1.00 22.73           C  
ATOM    780  CD  PRO A 109      11.611  37.870  63.162  1.00 22.10           C  
ATOM    781  N   VAL A 110      14.056  38.604  59.130  1.00 20.81           N  
ATOM    782  CA  VAL A 110      14.181  39.388  57.910  1.00 17.92           C  
ATOM    783  C   VAL A 110      14.374  38.381  56.791  1.00 18.43           C  
ATOM    784  O   VAL A 110      15.397  37.715  56.741  1.00 18.48           O  
ATOM    785  CB  VAL A 110      15.411  40.327  57.949  1.00 17.26           C  
ATOM    786  CG1 VAL A 110      15.425  41.209  56.713  1.00 13.59           C  
ATOM    787  CG2 VAL A 110      15.392  41.178  59.207  1.00 15.18           C  
ATOM    788  N   LEU A 111      13.391  38.245  55.908  1.00 18.58           N  
ATOM    789  CA  LEU A 111      13.513  37.294  54.812  1.00 20.94           C  
ATOM    790  C   LEU A 111      14.180  37.932  53.610  1.00 21.08           C  
ATOM    791  O   LEU A 111      13.980  39.113  53.336  1.00 24.06           O  
ATOM    792  CB  LEU A 111      12.142  36.725  54.433  1.00 22.58           C  
ATOM    793  CG  LEU A 111      11.623  35.672  55.418  1.00 25.58           C  
ATOM    794  CD1 LEU A 111      11.061  36.351  56.663  1.00 27.29           C  
ATOM    795  CD2 LEU A 111      10.557  34.834  54.743  1.00 27.13           C  
ATOM    796  N   SER A 112      14.973  37.146  52.889  1.00 20.62           N  
ATOM    797  CA  SER A 112      15.702  37.661  51.736  1.00 19.14           C  
ATOM    798  C   SER A 112      15.154  37.333  50.361  1.00 17.71           C  
ATOM    799  O   SER A 112      15.026  36.172  49.990  1.00 15.95           O  
ATOM    800  CB  SER A 112      17.155  37.205  51.786  1.00 19.51           C  
ATOM    801  OG  SER A 112      17.814  37.538  50.572  1.00 24.18           O  
ATOM    802  N   ALA A 113      14.851  38.382  49.607  1.00 17.03           N  
ATOM    803  CA  ALA A 113      14.357  38.253  48.250  1.00 17.44           C  
ATOM    804  C   ALA A 113      15.289  39.103  47.391  1.00 19.32           C  
ATOM    805  O   ALA A 113      14.929  39.540  46.301  1.00 18.52           O  
ATOM    806  CB  ALA A 113      12.928  38.754  48.150  1.00 18.73           C  
ATOM    807  N   VAL A 114      16.493  39.344  47.913  1.00 21.59           N  
ATOM    808  CA  VAL A 114      17.516  40.114  47.203  1.00 21.93           C  
ATOM    809  C   VAL A 114      18.248  39.097  46.334  1.00 21.82           C  
ATOM    810  O   VAL A 114      19.012  38.284  46.845  1.00 23.56           O  
ATOM    811  CB  VAL A 114      18.517  40.778  48.198  1.00 21.14           C  
ATOM    812  CG1 VAL A 114      19.589  41.550  47.442  1.00 18.95           C  
ATOM    813  CG2 VAL A 114      17.772  41.718  49.132  1.00 19.27           C  
ATOM    814  N   LEU A 115      17.995  39.130  45.028  1.00 22.76           N  
ATOM    815  CA  LEU A 115      18.612  38.180  44.101  1.00 23.40           C  
ATOM    816  C   LEU A 115      19.666  38.762  43.166  1.00 24.60           C  
ATOM    817  O   LEU A 115      19.533  39.885  42.666  1.00 25.70           O  
ATOM    818  CB  LEU A 115      17.551  37.493  43.223  1.00 21.65           C  
ATOM    819  CG  LEU A 115      16.537  36.488  43.769  1.00 19.53           C  
ATOM    820  CD1 LEU A 115      17.199  35.651  44.862  1.00 19.03           C  
ATOM    821  CD2 LEU A 115      15.324  37.210  44.294  1.00 17.34           C  
ATOM    822  N   THR A 116      20.702  37.966  42.929  1.00 23.08           N  
ATOM    823  CA  THR A 116      21.793  38.314  42.035  1.00 23.40           C  
ATOM    824  C   THR A 116      21.846  37.166  41.026  1.00 24.48           C  
ATOM    825  O   THR A 116      22.227  36.043  41.360  1.00 26.00           O  
ATOM    826  CB  THR A 116      23.135  38.398  42.797  1.00 21.68           C  
ATOM    827  OG1 THR A 116      23.105  39.507  43.700  1.00 22.23           O  
ATOM    828  CG2 THR A 116      24.284  38.570  41.836  1.00 19.30           C  
ATOM    829  N   PRO A 117      21.442  37.425  39.781  1.00 24.51           N  
ATOM    830  CA  PRO A 117      21.464  36.362  38.773  1.00 25.04           C  
ATOM    831  C   PRO A 117      22.863  36.173  38.186  1.00 27.11           C  
ATOM    832  O   PRO A 117      23.705  37.070  38.292  1.00 28.03           O  
ATOM    833  CB  PRO A 117      20.465  36.864  37.747  1.00 23.62           C  
ATOM    834  CG  PRO A 117      20.736  38.346  37.756  1.00 23.08           C  
ATOM    835  CD  PRO A 117      20.890  38.674  39.230  1.00 23.49           C  
ATOM    836  N   HIS A 118      23.113  35.013  37.577  1.00 27.54           N  
ATOM    837  CA  HIS A 118      24.418  34.751  36.972  1.00 28.41           C  
ATOM    838  C   HIS A 118      24.665  35.705  35.814  1.00 29.23           C  
ATOM    839  O   HIS A 118      25.733  36.320  35.711  1.00 29.98           O  
ATOM    840  CB  HIS A 118      24.520  33.305  36.481  1.00 27.35           C  
ATOM    841  CG  HIS A 118      24.738  32.314  37.581  1.00 27.33           C  
ATOM    842  ND1 HIS A 118      25.785  32.414  38.472  1.00 26.02           N  
ATOM    843  CD2 HIS A 118      24.014  31.238  37.969  1.00 26.54           C  
ATOM    844  CE1 HIS A 118      25.692  31.447  39.366  1.00 25.91           C  
ATOM    845  NE2 HIS A 118      24.626  30.720  39.086  1.00 25.75           N  
ATOM    846  N   ASN A 119      23.681  35.829  34.936  1.00 29.52           N  
ATOM    847  CA  ASN A 119      23.830  36.728  33.812  1.00 32.57           C  
ATOM    848  C   ASN A 119      22.580  37.544  33.519  1.00 34.26           C  
ATOM    849  O   ASN A 119      21.484  37.010  33.315  1.00 35.75           O  
ATOM    850  CB  ASN A 119      24.255  35.959  32.551  1.00 33.19           C  
ATOM    851  CG  ASN A 119      25.711  35.512  32.601  1.00 34.34           C  
ATOM    852  OD1 ASN A 119      26.024  34.399  33.027  1.00 35.89           O  
ATOM    853  ND2 ASN A 119      26.612  36.392  32.175  1.00 36.99           N  
ATOM    854  N   TYR A 120      22.751  38.856  33.531  1.00 34.67           N  
ATOM    855  CA  TYR A 120      21.665  39.756  33.220  1.00 34.57           C  
ATOM    856  C   TYR A 120      22.282  40.824  32.328  1.00 34.68           C  
ATOM    857  O   TYR A 120      23.215  41.523  32.733  1.00 34.13           O  
ATOM    858  CB  TYR A 120      21.079  40.385  34.486  1.00 34.53           C  
ATOM    859  CG  TYR A 120      19.799  41.142  34.206  1.00 37.17           C  
ATOM    860  CD1 TYR A 120      18.620  40.469  33.860  1.00 36.26           C  
ATOM    861  CD2 TYR A 120      19.782  42.541  34.206  1.00 38.06           C  
ATOM    862  CE1 TYR A 120      17.454  41.179  33.511  1.00 37.45           C  
ATOM    863  CE2 TYR A 120      18.626  43.257  33.863  1.00 38.16           C  
ATOM    864  CZ  TYR A 120      17.468  42.576  33.515  1.00 38.68           C  
ATOM    865  OH  TYR A 120      16.346  43.302  33.163  1.00 37.87           O  
ATOM    866  N   HIS A 121      21.786  40.916  31.100  1.00 34.64           N  
ATOM    867  CA  HIS A 121      22.287  41.893  30.143  1.00 35.80           C  
ATOM    868  C   HIS A 121      21.159  42.740  29.572  1.00 37.77           C  
ATOM    869  O   HIS A 121      21.077  42.921  28.360  1.00 40.50           O  
ATOM    870  CB  HIS A 121      23.021  41.194  28.990  1.00 33.63           C  
ATOM    871  CG  HIS A 121      24.362  40.643  29.366  1.00 33.79           C  
ATOM    872  ND1 HIS A 121      25.350  40.403  28.436  1.00 33.45           N  
ATOM    873  CD2 HIS A 121      24.882  40.292  30.567  1.00 34.18           C  
ATOM    874  CE1 HIS A 121      26.422  39.930  29.051  1.00 34.80           C  
ATOM    875  NE2 HIS A 121      26.164  39.852  30.344  1.00 33.52           N  
ATOM    876  N   ASP A 122      20.298  43.253  30.445  1.00 38.70           N  
ATOM    877  CA  ASP A 122      19.165  44.086  30.039  1.00 40.10           C  
ATOM    878  C   ASP A 122      18.706  43.889  28.588  1.00 40.52           C  
ATOM    879  O   ASP A 122      18.755  44.818  27.777  1.00 41.93           O  
ATOM    880  CB  ASP A 122      19.483  45.571  30.277  1.00 40.17           C  
ATOM    881  CG  ASP A 122      20.720  46.032  29.530  0.50 40.06           C  
ATOM    882  OD1 ASP A 122      21.842  45.683  29.957  0.50 40.46           O  
ATOM    883  OD2 ASP A 122      20.571  46.738  28.511  0.50 39.80           O  
ATOM    884  N   SER A 123      18.267  42.675  28.265  1.00 40.17           N  
ATOM    885  CA  SER A 123      17.786  42.357  26.920  1.00 38.32           C  
ATOM    886  C   SER A 123      16.345  41.885  27.026  1.00 38.01           C  
ATOM    887  O   SER A 123      15.853  41.616  28.122  1.00 38.77           O  
ATOM    888  CB  SER A 123      18.644  41.256  26.281  1.00 37.82           C  
ATOM    889  OG  SER A 123      18.581  40.052  27.026  1.00 35.15           O  
ATOM    890  N   ALA A 124      15.671  41.775  25.889  1.00 37.40           N  
ATOM    891  CA  ALA A 124      14.283  41.341  25.892  1.00 37.00           C  
ATOM    892  C   ALA A 124      14.085  40.031  26.646  1.00 37.06           C  
ATOM    893  O   ALA A 124      13.333  39.988  27.613  1.00 37.63           O  
ATOM    894  CB  ALA A 124      13.767  41.212  24.464  1.00 37.59           C  
ATOM    895  N   GLU A 125      14.760  38.965  26.227  1.00 37.45           N  
ATOM    896  CA  GLU A 125      14.590  37.680  26.901  1.00 39.07           C  
ATOM    897  C   GLU A 125      15.060  37.690  28.348  1.00 37.52           C  
ATOM    898  O   GLU A 125      14.404  37.108  29.209  1.00 37.60           O  
ATOM    899  CB  GLU A 125      15.300  36.548  26.149  1.00 41.48           C  
ATOM    900  CG  GLU A 125      14.832  36.340  24.726  1.00 44.33           C  
ATOM    901  CD  GLU A 125      15.635  37.169  23.750  1.00 47.78           C  
ATOM    902  OE1 GLU A 125      16.880  37.136  23.848  1.00 50.02           O  
ATOM    903  OE2 GLU A 125      15.035  37.846  22.885  1.00 50.02           O  
ATOM    904  N   HIS A 126      16.194  38.334  28.620  1.00 36.91           N  
ATOM    905  CA  HIS A 126      16.693  38.405  29.990  1.00 34.91           C  
ATOM    906  C   HIS A 126      15.603  39.039  30.837  1.00 32.88           C  
ATOM    907  O   HIS A 126      15.088  38.429  31.778  1.00 33.10           O  
ATOM    908  CB  HIS A 126      17.955  39.270  30.088  1.00 36.65           C  
ATOM    909  CG  HIS A 126      19.233  38.518  29.868  1.00 38.98           C  
ATOM    910  ND1 HIS A 126      19.918  38.542  28.671  1.00 38.39           N  
ATOM    911  CD2 HIS A 126      19.950  37.720  30.695  1.00 37.92           C  
ATOM    912  CE1 HIS A 126      21.002  37.794  28.771  1.00 37.71           C  
ATOM    913  NE2 HIS A 126      21.045  37.283  29.990  1.00 37.86           N  
ATOM    914  N   HIS A 127      15.250  40.269  30.477  1.00 30.82           N  
ATOM    915  CA  HIS A 127      14.232  41.031  31.188  1.00 28.65           C  
ATOM    916  C   HIS A 127      12.933  40.245  31.361  1.00 27.33           C  
ATOM    917  O   HIS A 127      12.366  40.189  32.454  1.00 24.52           O  
ATOM    918  CB  HIS A 127      13.963  42.342  30.445  1.00 27.60           C  
ATOM    919  CG  HIS A 127      13.228  43.353  31.265  1.00 27.26           C  
ATOM    920  ND1 HIS A 127      11.862  43.318  31.440  1.00 26.46           N  
ATOM    921  CD2 HIS A 127      13.678  44.383  32.020  1.00 26.54           C  
ATOM    922  CE1 HIS A 127      11.502  44.278  32.272  1.00 25.15           C  
ATOM    923  NE2 HIS A 127      12.586  44.937  32.639  1.00 26.97           N  
ATOM    924  N   ARG A 128      12.471  39.634  30.274  1.00 27.50           N  
ATOM    925  CA  ARG A 128      11.246  38.845  30.300  1.00 28.32           C  
ATOM    926  C   ARG A 128      11.370  37.625  31.206  1.00 26.95           C  
ATOM    927  O   ARG A 128      10.442  37.304  31.952  1.00 28.20           O  
ATOM    928  CB  ARG A 128      10.871  38.410  28.885  1.00 31.14           C  
ATOM    929  CG  ARG A 128       9.883  37.273  28.839  1.00 33.77           C  
ATOM    930  CD  ARG A 128       9.379  37.038  27.432  1.00 37.93           C  
ATOM    931  NE  ARG A 128       8.851  35.684  27.289  1.00 43.87           N  
ATOM    932  CZ  ARG A 128       9.602  34.614  27.039  1.00 45.68           C  
ATOM    933  NH1 ARG A 128      10.917  34.738  26.894  1.00 47.18           N  
ATOM    934  NH2 ARG A 128       9.040  33.415  26.949  1.00 46.63           N  
ATOM    935  N   PHE A 129      12.512  36.947  31.148  1.00 24.22           N  
ATOM    936  CA  PHE A 129      12.718  35.777  31.983  1.00 23.11           C  
ATOM    937  C   PHE A 129      12.528  36.149  33.447  1.00 23.58           C  
ATOM    938  O   PHE A 129      11.708  35.554  34.148  1.00 24.04           O  
ATOM    939  CB  PHE A 129      14.123  35.213  31.799  1.00 23.30           C  
ATOM    940  CG  PHE A 129      14.391  33.992  32.627  1.00 22.09           C  
ATOM    941  CD1 PHE A 129      14.052  32.734  32.157  1.00 21.13           C  
ATOM    942  CD2 PHE A 129      14.922  34.110  33.910  1.00 22.58           C  
ATOM    943  CE1 PHE A 129      14.231  31.606  32.951  1.00 22.46           C  
ATOM    944  CE2 PHE A 129      15.104  32.995  34.715  1.00 23.66           C  
ATOM    945  CZ  PHE A 129      14.757  31.736  34.235  1.00 24.85           C  
ATOM    946  N   PHE A 130      13.277  37.146  33.907  1.00 23.13           N  
ATOM    947  CA  PHE A 130      13.186  37.569  35.304  1.00 23.78           C  
ATOM    948  C   PHE A 130      11.930  38.330  35.690  1.00 23.72           C  
ATOM    949  O   PHE A 130      11.563  38.354  36.861  1.00 23.56           O  
ATOM    950  CB  PHE A 130      14.425  38.371  35.691  1.00 21.78           C  
ATOM    951  CG  PHE A 130      15.679  37.562  35.651  1.00 21.28           C  
ATOM    952  CD1 PHE A 130      16.435  37.486  34.485  1.00 18.97           C  
ATOM    953  CD2 PHE A 130      16.068  36.815  36.761  1.00 18.67           C  
ATOM    954  CE1 PHE A 130      17.549  36.683  34.426  1.00 18.67           C  
ATOM    955  CE2 PHE A 130      17.180  36.008  36.711  1.00 18.55           C  
ATOM    956  CZ  PHE A 130      17.927  35.939  35.542  1.00 19.82           C  
ATOM    957  N   PHE A 131      11.284  38.968  34.722  1.00 25.67           N  
ATOM    958  CA  PHE A 131      10.046  39.684  35.013  1.00 28.43           C  
ATOM    959  C   PHE A 131       9.045  38.610  35.430  1.00 27.87           C  
ATOM    960  O   PHE A 131       8.273  38.782  36.369  1.00 27.06           O  
ATOM    961  CB  PHE A 131       9.518  40.406  33.764  1.00 30.64           C  
ATOM    962  CG  PHE A 131       8.184  41.081  33.970  1.00 32.54           C  
ATOM    963  CD1 PHE A 131       8.113  42.382  34.458  1.00 34.61           C  
ATOM    964  CD2 PHE A 131       6.999  40.407  33.698  1.00 31.59           C  
ATOM    965  CE1 PHE A 131       6.880  43.003  34.671  1.00 33.16           C  
ATOM    966  CE2 PHE A 131       5.774  41.013  33.907  1.00 31.05           C  
ATOM    967  CZ  PHE A 131       5.712  42.316  34.394  1.00 32.86           C  
ATOM    968  N   GLU A 132       9.084  37.488  34.719  1.00 29.00           N  
ATOM    969  CA  GLU A 132       8.183  36.376  34.999  1.00 29.61           C  
ATOM    970  C   GLU A 132       8.606  35.599  36.228  1.00 28.36           C  
ATOM    971  O   GLU A 132       7.823  35.391  37.141  1.00 30.51           O  
ATOM    972  CB  GLU A 132       8.122  35.428  33.797  1.00 29.04           C  
ATOM    973  CG  GLU A 132       7.761  36.125  32.490  1.00 29.64           C  
ATOM    974  CD  GLU A 132       7.799  35.192  31.302  1.00 30.68           C  
ATOM    975  OE1 GLU A 132       8.322  34.062  31.452  1.00 32.22           O  
ATOM    976  OE2 GLU A 132       7.317  35.589  30.215  1.00 31.64           O  
ATOM    977  N   HIS A 133       9.862  35.186  36.259  1.00 29.24           N  
ATOM    978  CA  HIS A 133      10.359  34.391  37.370  1.00 28.21           C  
ATOM    979  C   HIS A 133      10.227  35.065  38.731  1.00 27.83           C  
ATOM    980  O   HIS A 133      10.030  34.392  39.745  1.00 28.15           O  
ATOM    981  CB  HIS A 133      11.813  33.992  37.104  1.00 27.76           C  
ATOM    982  CG  HIS A 133      12.280  32.842  37.937  1.00 26.28           C  
ATOM    983  ND1 HIS A 133      13.208  32.981  38.946  1.00 26.42           N  
ATOM    984  CD2 HIS A 133      11.930  31.534  37.924  1.00 24.95           C  
ATOM    985  CE1 HIS A 133      13.410  31.808  39.520  1.00 24.87           C  
ATOM    986  NE2 HIS A 133      12.647  30.914  38.918  1.00 25.64           N  
ATOM    987  N   PHE A 134      10.317  36.387  38.769  1.00 27.12           N  
ATOM    988  CA  PHE A 134      10.200  37.072  40.043  1.00 26.82           C  
ATOM    989  C   PHE A 134       8.851  36.827  40.723  1.00 26.34           C  
ATOM    990  O   PHE A 134       8.776  36.835  41.957  1.00 25.30           O  
ATOM    991  CB  PHE A 134      10.484  38.575  39.885  1.00 28.30           C  
ATOM    992  CG  PHE A 134      11.807  39.008  40.487  1.00 28.31           C  
ATOM    993  CD1 PHE A 134      12.990  38.335  40.168  1.00 27.86           C  
ATOM    994  CD2 PHE A 134      11.867  40.068  41.392  1.00 29.24           C  
ATOM    995  CE1 PHE A 134      14.209  38.704  40.742  1.00 25.81           C  
ATOM    996  CE2 PHE A 134      13.089  40.451  41.975  1.00 28.66           C  
ATOM    997  CZ  PHE A 134      14.260  39.763  41.647  1.00 27.93           C  
ATOM    998  N   THR A 135       7.780  36.594  39.960  1.00 23.66           N  
ATOM    999  CA  THR A 135       6.529  36.323  40.652  1.00 23.68           C  
ATOM   1000  C   THR A 135       6.699  34.983  41.383  1.00 23.11           C  
ATOM   1001  O   THR A 135       6.229  34.824  42.511  1.00 22.67           O  
ATOM   1002  CB  THR A 135       5.287  36.270  39.715  1.00 23.45           C  
ATOM   1003  OG1 THR A 135       5.403  35.183  38.800  1.00 25.23           O  
ATOM   1004  CG2 THR A 135       5.141  37.569  38.948  1.00 24.92           C  
ATOM   1005  N   VAL A 136       7.403  34.034  40.765  1.00 21.85           N  
ATOM   1006  CA  VAL A 136       7.632  32.742  41.406  1.00 20.72           C  
ATOM   1007  C   VAL A 136       8.340  32.944  42.734  1.00 20.98           C  
ATOM   1008  O   VAL A 136       7.969  32.339  43.739  1.00 23.25           O  
ATOM   1009  CB  VAL A 136       8.508  31.796  40.541  1.00 21.96           C  
ATOM   1010  CG1 VAL A 136       8.797  30.485  41.302  1.00 16.94           C  
ATOM   1011  CG2 VAL A 136       7.808  31.501  39.228  1.00 21.96           C  
ATOM   1012  N   LYS A 137       9.356  33.801  42.740  1.00 20.45           N  
ATOM   1013  CA  LYS A 137      10.114  34.063  43.960  1.00 19.53           C  
ATOM   1014  C   LYS A 137       9.287  34.776  45.028  1.00 19.76           C  
ATOM   1015  O   LYS A 137       9.502  34.567  46.228  1.00 19.82           O  
ATOM   1016  CB  LYS A 137      11.367  34.885  43.639  1.00 17.18           C  
ATOM   1017  CG  LYS A 137      12.248  34.288  42.544  1.00 17.34           C  
ATOM   1018  CD  LYS A 137      12.757  32.883  42.888  1.00 11.67           C  
ATOM   1019  CE  LYS A 137      13.727  32.903  44.032  1.00 10.63           C  
ATOM   1020  NZ  LYS A 137      14.075  31.525  44.456  1.00 13.94           N  
ATOM   1021  N   GLY A 138       8.352  35.621  44.596  1.00 20.05           N  
ATOM   1022  CA  GLY A 138       7.505  36.337  45.542  1.00 18.89           C  
ATOM   1023  C   GLY A 138       6.612  35.387  46.316  1.00 19.10           C  
ATOM   1024  O   GLY A 138       6.453  35.519  47.527  1.00 17.99           O  
ATOM   1025  N   LYS A 139       6.028  34.419  45.610  1.00 21.92           N  
ATOM   1026  CA  LYS A 139       5.158  33.423  46.233  1.00 23.10           C  
ATOM   1027  C   LYS A 139       5.969  32.614  47.240  1.00 23.14           C  
ATOM   1028  O   LYS A 139       5.480  32.302  48.324  1.00 25.62           O  
ATOM   1029  CB  LYS A 139       4.538  32.504  45.165  1.00 21.99           C  
ATOM   1030  N   GLU A 140       7.210  32.281  46.885  1.00 23.22           N  
ATOM   1031  CA  GLU A 140       8.090  31.537  47.795  1.00 22.91           C  
ATOM   1032  C   GLU A 140       8.357  32.370  49.051  1.00 22.31           C  
ATOM   1033  O   GLU A 140       8.398  31.841  50.172  1.00 23.54           O  
ATOM   1034  CB  GLU A 140       9.455  31.246  47.158  1.00 22.30           C  
ATOM   1035  CG  GLU A 140       9.466  30.427  45.888  1.00 25.53           C  
ATOM   1036  CD  GLU A 140      10.891  30.223  45.357  1.00 27.29           C  
ATOM   1037  OE1 GLU A 140      11.035  29.706  44.230  1.00 28.54           O  
ATOM   1038  OE2 GLU A 140      11.863  30.577  46.067  1.00 25.58           O  
ATOM   1039  N   ALA A 141       8.572  33.670  48.853  1.00 19.64           N  
ATOM   1040  CA  ALA A 141       8.857  34.569  49.965  1.00 18.92           C  
ATOM   1041  C   ALA A 141       7.708  34.540  50.963  1.00 18.28           C  
ATOM   1042  O   ALA A 141       7.920  34.465  52.181  1.00 16.10           O  
ATOM   1043  CB  ALA A 141       9.086  35.996  49.450  1.00 18.43           C  
ATOM   1044  N   ALA A 142       6.489  34.579  50.429  1.00 18.51           N  
ATOM   1045  CA  ALA A 142       5.285  34.553  51.247  1.00 18.25           C  
ATOM   1046  C   ALA A 142       5.213  33.297  52.118  1.00 18.77           C  
ATOM   1047  O   ALA A 142       5.179  33.388  53.353  1.00 17.66           O  
ATOM   1048  CB  ALA A 142       4.058  34.645  50.351  1.00 17.23           C  
ATOM   1049  N   ARG A 143       5.206  32.130  51.476  1.00 20.28           N  
ATOM   1050  CA  ARG A 143       5.132  30.865  52.209  1.00 21.72           C  
ATOM   1051  C   ARG A 143       6.226  30.812  53.252  1.00 21.24           C  
ATOM   1052  O   ARG A 143       6.014  30.324  54.359  1.00 22.60           O  
ATOM   1053  CB  ARG A 143       5.289  29.668  51.267  1.00 21.94           C  
ATOM   1054  CG  ARG A 143       4.390  29.717  50.053  1.00 24.15           C  
ATOM   1055  CD  ARG A 143       4.385  28.395  49.309  1.00 25.75           C  
ATOM   1056  NE  ARG A 143       3.948  28.568  47.929  1.00 28.94           N  
ATOM   1057  CZ  ARG A 143       4.728  29.033  46.956  1.00 29.92           C  
ATOM   1058  NH1 ARG A 143       5.982  29.366  47.215  1.00 31.35           N  
ATOM   1059  NH2 ARG A 143       4.255  29.167  45.724  1.00 31.88           N  
ATOM   1060  N   ALA A 144       7.404  31.308  52.892  1.00 20.70           N  
ATOM   1061  CA  ALA A 144       8.522  31.315  53.825  1.00 20.35           C  
ATOM   1062  C   ALA A 144       8.180  32.205  55.010  1.00 20.07           C  
ATOM   1063  O   ALA A 144       8.368  31.823  56.172  1.00 20.41           O  
ATOM   1064  CB  ALA A 144       9.786  31.824  53.137  1.00 20.42           C  
ATOM   1065  N   CYS A 145       7.675  33.398  54.718  1.00 19.95           N  
ATOM   1066  CA  CYS A 145       7.327  34.318  55.783  1.00 21.33           C  
ATOM   1067  C   CYS A 145       6.286  33.740  56.731  1.00 19.69           C  
ATOM   1068  O   CYS A 145       6.453  33.811  57.947  1.00 19.28           O  
ATOM   1069  CB  CYS A 145       6.814  35.636  55.221  1.00 22.28           C  
ATOM   1070  SG  CYS A 145       6.223  36.685  56.553  1.00 28.14           S  
ATOM   1071  N   VAL A 146       5.210  33.184  56.177  1.00 19.74           N  
ATOM   1072  CA  VAL A 146       4.145  32.585  57.000  1.00 19.25           C  
ATOM   1073  C   VAL A 146       4.660  31.409  57.815  1.00 19.57           C  
ATOM   1074  O   VAL A 146       4.362  31.276  59.004  1.00 20.81           O  
ATOM   1075  CB  VAL A 146       2.962  32.059  56.144  1.00 16.59           C  
ATOM   1076  CG1 VAL A 146       2.001  31.283  57.022  1.00 17.46           C  
ATOM   1077  CG2 VAL A 146       2.238  33.211  55.471  1.00 14.51           C  
ATOM   1078  N   GLU A 147       5.433  30.551  57.168  1.00 20.61           N  
ATOM   1079  CA  GLU A 147       5.964  29.376  57.832  1.00 23.36           C  
ATOM   1080  C   GLU A 147       6.969  29.679  58.925  1.00 24.08           C  
ATOM   1081  O   GLU A 147       6.910  29.091  60.006  1.00 25.14           O  
ATOM   1082  CB  GLU A 147       6.582  28.448  56.798  1.00 24.19           C  
ATOM   1083  CG  GLU A 147       5.546  27.838  55.890  1.00 28.25           C  
ATOM   1084  CD  GLU A 147       6.139  27.326  54.603  1.00 30.17           C  
ATOM   1085  OE1 GLU A 147       7.273  26.799  54.645  1.00 31.25           O  
ATOM   1086  OE2 GLU A 147       5.465  27.445  53.556  1.00 30.75           O  
ATOM   1087  N   ILE A 148       7.893  30.593  58.664  1.00 24.33           N  
ATOM   1088  CA  ILE A 148       8.892  30.900  59.679  1.00 24.07           C  
ATOM   1089  C   ILE A 148       8.218  31.410  60.940  1.00 22.71           C  
ATOM   1090  O   ILE A 148       8.569  30.999  62.049  1.00 22.59           O  
ATOM   1091  CB  ILE A 148       9.941  31.931  59.176  1.00 23.44           C  
ATOM   1092  CG1 ILE A 148      10.968  32.181  60.280  1.00 24.91           C  
ATOM   1093  CG2 ILE A 148       9.275  33.208  58.743  1.00 23.98           C  
ATOM   1094  CD1 ILE A 148      11.776  30.931  60.666  1.00 24.48           C  
ATOM   1095  N   LEU A 149       7.239  32.294  60.769  1.00 21.65           N  
ATOM   1096  CA  LEU A 149       6.518  32.832  61.912  1.00 19.47           C  
ATOM   1097  C   LEU A 149       5.795  31.706  62.641  1.00 19.11           C  
ATOM   1098  O   LEU A 149       5.792  31.649  63.875  1.00 18.37           O  
ATOM   1099  CB  LEU A 149       5.544  33.908  61.448  1.00 17.28           C  
ATOM   1100  CG  LEU A 149       6.301  35.174  61.056  1.00 18.24           C  
ATOM   1101  CD1 LEU A 149       5.331  36.247  60.596  1.00 18.41           C  
ATOM   1102  CD2 LEU A 149       7.122  35.656  62.259  1.00 15.51           C  
ATOM   1103  N   ALA A 150       5.205  30.798  61.869  1.00 18.63           N  
ATOM   1104  CA  ALA A 150       4.514  29.654  62.438  1.00 18.76           C  
ATOM   1105  C   ALA A 150       5.523  28.818  63.225  1.00 20.15           C  
ATOM   1106  O   ALA A 150       5.319  28.495  64.403  1.00 20.96           O  
ATOM   1107  CB  ALA A 150       3.887  28.812  61.319  1.00 17.12           C  
ATOM   1108  N   ALA A 151       6.624  28.481  62.564  1.00 21.69           N  
ATOM   1109  CA  ALA A 151       7.671  27.664  63.169  1.00 22.95           C  
ATOM   1110  C   ALA A 151       8.177  28.224  64.484  1.00 24.51           C  
ATOM   1111  O   ALA A 151       8.447  27.481  65.424  1.00 24.81           O  
ATOM   1112  CB  ALA A 151       8.830  27.506  62.197  1.00 20.92           C  
ATOM   1113  N   ARG A 152       8.321  29.540  64.551  1.00 27.78           N  
ATOM   1114  CA  ARG A 152       8.812  30.154  65.775  1.00 29.28           C  
ATOM   1115  C   ARG A 152       7.827  29.924  66.909  1.00 28.91           C  
ATOM   1116  O   ARG A 152       8.224  29.556  68.016  1.00 30.42           O  
ATOM   1117  CB  ARG A 152       9.045  31.651  65.567  1.00 29.44           C  
ATOM   1118  CG  ARG A 152      10.032  31.967  64.453  1.00 30.30           C  
ATOM   1119  CD  ARG A 152      10.515  33.396  64.571  1.00 31.34           C  
ATOM   1120  NE  ARG A 152      11.269  33.564  65.804  1.00 33.50           N  
ATOM   1121  CZ  ARG A 152      11.519  34.734  66.370  1.00 33.51           C  
ATOM   1122  NH1 ARG A 152      11.068  35.845  65.806  1.00 35.13           N  
ATOM   1123  NH2 ARG A 152      12.214  34.792  67.499  1.00 31.67           N  
ATOM   1124  N   GLU A 153       6.544  30.119  66.619  1.00 29.35           N  
ATOM   1125  CA  GLU A 153       5.487  29.934  67.615  1.00 29.24           C  
ATOM   1126  C   GLU A 153       5.575  28.575  68.320  1.00 29.59           C  
ATOM   1127  O   GLU A 153       5.149  28.433  69.466  1.00 28.63           O  
ATOM   1128  CB  GLU A 153       4.104  30.112  66.960  1.00 26.93           C  
ATOM   1129  N   LYS A 154       6.149  27.579  67.652  1.00 31.23           N  
ATOM   1130  CA  LYS A 154       6.268  26.259  68.263  1.00 34.07           C  
ATOM   1131  C   LYS A 154       7.329  26.183  69.371  1.00 36.06           C  
ATOM   1132  O   LYS A 154       7.135  25.490  70.372  1.00 37.41           O  
ATOM   1133  CB  LYS A 154       6.542  25.205  67.189  1.00 33.67           C  
ATOM   1134  CG  LYS A 154       5.432  25.119  66.143  1.00 35.28           C  
ATOM   1135  CD  LYS A 154       5.546  23.867  65.290  1.00 36.50           C  
ATOM   1136  CE  LYS A 154       4.400  23.773  64.292  1.00 37.74           C  
ATOM   1137  NZ  LYS A 154       4.385  22.439  63.624  1.00 39.72           N  
ATOM   1138  N   ILE A 155       8.432  26.907  69.209  1.00 37.05           N  
ATOM   1139  CA  ILE A 155       9.501  26.899  70.206  1.00 38.39           C  
ATOM   1140  C   ILE A 155       8.973  27.068  71.632  1.00 38.96           C  
ATOM   1141  O   ILE A 155       8.441  28.164  71.914  1.00 40.15           O  
ATOM   1142  CB  ILE A 155      10.531  28.018  69.921  1.00 38.79           C  
ATOM   1143  CG1 ILE A 155      11.182  27.784  68.556  0.50 36.61           C  
ATOM   1144  CG2 ILE A 155      11.588  28.050  71.024  0.50 37.26           C  
ATOM   1145  CD1 ILE A 155      12.125  28.884  68.131  0.50 35.35           C  
TER    1146      ILE A 155                                                      
END
MOLECULE T0487_317_466.pdb
ATOM   2444  N   SER   317      10.299   6.901  51.930  1.00 72.05           N  
ATOM   2445  CA  SER   317       8.876   7.205  52.027  1.00 73.18           C  
ATOM   2446  C   SER   317       8.623   8.710  51.941  1.00 73.42           C  
ATOM   2447  O   SER   317       9.277   9.512  52.608  1.00 72.85           O  
ATOM   2448  CB  SER   317       8.270   6.636  53.328  1.00 72.42           C  
ATOM   2449  OG  SER   317       8.847   7.196  54.491  1.00 72.42           O  
ATOM   2450  N   ILE   318       7.674   9.068  51.083  1.00 75.17           N  
ATOM   2451  CA  ILE   318       7.266  10.447  50.853  1.00 76.64           C  
ATOM   2452  C   ILE   318       6.534  10.963  52.093  1.00 76.34           C  
ATOM   2453  O   ILE   318       5.683  10.281  52.656  1.00 76.86           O  
ATOM   2454  CB  ILE   318       6.352  10.509  49.611  1.00 78.09           C  
ATOM   2455  CG1 ILE   318       7.160  10.092  48.375  1.00 79.57           C  
ATOM   2456  CG2 ILE   318       5.768  11.897  49.445  1.00 76.73           C  
ATOM   2457  CD1 ILE   318       6.323   9.856  47.120  1.00 81.63           C  
ATOM   2458  N   PRO   319       6.865  12.183  52.536  1.00 76.40           N  
ATOM   2459  CA  PRO   319       6.267  12.823  53.720  1.00 76.49           C  
ATOM   2460  C   PRO   319       4.781  13.233  53.662  1.00 75.57           C  
ATOM   2461  O   PRO   319       4.320  13.839  52.690  1.00 74.41           O  
ATOM   2462  CB  PRO   319       7.186  14.023  53.949  1.00 75.91           C  
ATOM   2463  CG  PRO   319       7.553  14.418  52.548  1.00 75.48           C  
ATOM   2464  CD  PRO   319       7.837  13.082  51.885  1.00 76.26           C  
ATOM   2465  N   LYS   320       4.042  12.891  54.714  1.00 75.02           N  
ATOM   2466  CA  LYS   320       2.638  13.259  54.798  1.00 74.69           C  
ATOM   2467  C   LYS   320       2.621  14.736  55.159  1.00 74.67           C  
ATOM   2468  O   LYS   320       2.709  15.105  56.328  1.00 74.28           O  
ATOM   2469  CB  LYS   320       1.932  12.449  55.874  1.00 73.82           C  
ATOM   2470  N   LEU   321       2.544  15.569  54.132  1.00 75.17           N  
ATOM   2471  CA  LEU   321       2.518  17.013  54.281  1.00 76.56           C  
ATOM   2472  C   LEU   321       1.089  17.463  54.459  1.00 78.23           C  
ATOM   2473  O   LEU   321       0.190  16.965  53.781  1.00 79.23           O  
ATOM   2474  CB  LEU   321       3.052  17.688  53.022  1.00 75.87           C  
ATOM   2475  CG  LEU   321       4.509  18.104  52.880  1.00 76.18           C  
ATOM   2476  CD1 LEU   321       5.429  16.953  53.216  1.00 76.87           C  
ATOM   2477  CD2 LEU   321       4.735  18.580  51.453  1.00 75.72           C  
ATOM   2478  N   MET   322       0.866  18.408  55.358  1.00 79.65           N  
ATOM   2479  CA  MET   322      -0.482  18.908  55.537  1.00 81.28           C  
ATOM   2480  C   MET   322      -0.584  20.268  56.194  1.00 78.82           C  
ATOM   2481  O   MET   322      -0.027  20.503  57.261  1.00 76.72           O  
ATOM   2482  CB  MET   322      -1.334  17.905  56.308  1.00 85.67           C  
ATOM   2483  CG  MET   322      -0.895  17.647  57.725  1.00 90.88           C  
ATOM   2484  SD  MET   322      -2.240  16.800  58.586  1.00 98.69           S  
ATOM   2485  CE  MET   322      -2.381  15.260  57.570  1.00 96.37           C  
ATOM   2486  N   GLY   323      -1.295  21.159  55.514  1.00 77.51           N  
ATOM   2487  CA  GLY   323      -1.525  22.499  56.020  1.00 77.01           C  
ATOM   2488  C   GLY   323      -2.858  22.439  56.735  1.00 75.76           C  
ATOM   2489  O   GLY   323      -3.016  21.619  57.629  1.00 74.22           O  
ATOM   2490  N   ARG   324      -3.817  23.278  56.344  1.00 76.29           N  
ATOM   2491  CA  ARG   324      -5.133  23.244  56.970  1.00 76.56           C  
ATOM   2492  C   ARG   324      -5.740  21.866  56.714  1.00 77.94           C  
ATOM   2493  O   ARG   324      -6.434  21.318  57.561  1.00 77.88           O  
ATOM   2494  CB  ARG   324      -6.037  24.331  56.420  1.00 75.07           C  
ATOM   2495  CG  ARG   324      -7.306  24.476  57.209  1.00 72.49           C  
ATOM   2496  CD  ARG   324      -7.929  25.815  56.969  1.00 71.41           C  
ATOM   2497  NE  ARG   324      -9.012  26.048  57.905  1.00 69.72           N  
ATOM   2498  CZ  ARG   324      -9.626  27.212  58.060  1.00 69.49           C  
ATOM   2499  NH1 ARG   324      -9.266  28.264  57.336  1.00 68.09           N  
ATOM   2500  NH2 ARG   324     -10.592  27.323  58.956  1.00 69.88           N  
ATOM   2501  N   ARG   325      -5.486  21.307  55.536  1.00 80.31           N  
ATOM   2502  CA  ARG   325      -5.921  19.952  55.201  1.00 83.03           C  
ATOM   2503  C   ARG   325      -4.787  19.299  54.425  1.00 83.42           C  
ATOM   2504  O   ARG   325      -3.901  19.997  53.932  1.00 83.67           O  
ATOM   2505  CB  ARG   325      -7.200  19.946  54.350  1.00 84.59           C  
ATOM   2506  CG  ARG   325      -7.142  20.755  53.100  1.00 85.86           C  
ATOM   2507  CD  ARG   325      -8.465  20.554  52.422  1.00 87.95           C  
ATOM   2508  NE  ARG   325      -8.730  21.537  51.397  1.00 91.35           N  
ATOM   2509  CZ  ARG   325      -8.532  21.361  50.099  1.00 93.28           C  
ATOM   2510  NH1 ARG   325      -8.052  20.208  49.637  1.00 94.64           N  
ATOM   2511  NH2 ARG   325      -8.831  22.360  49.268  1.00 94.28           N  
ATOM   2512  N   ALA   326      -4.820  17.968  54.319  1.00 83.71           N  
ATOM   2513  CA  ALA   326      -3.778  17.239  53.581  1.00 83.29           C  
ATOM   2514  C   ALA   326      -3.311  17.993  52.313  1.00 82.66           C  
ATOM   2515  O   ALA   326      -4.100  18.666  51.647  1.00 81.68           O  
ATOM   2516  CB  ALA   326      -4.252  15.841  53.207  1.00 83.45           C  
ATOM   2517  N   VAL   327      -2.027  17.867  51.980  1.00 82.72           N  
ATOM   2518  CA  VAL   327      -1.460  18.556  50.822  1.00 83.20           C  
ATOM   2519  C   VAL   327      -0.366  17.737  50.128  1.00 83.72           C  
ATOM   2520  O   VAL   327       0.341  16.953  50.764  1.00 83.40           O  
ATOM   2521  CB  VAL   327      -0.872  19.922  51.258  1.00 83.36           C  
ATOM   2522  CG1 VAL   327      -0.036  20.521  50.156  1.00 83.27           C  
ATOM   2523  CG2 VAL   327      -1.994  20.873  51.620  1.00 84.19           C  
ATOM   2524  N   SER   328      -0.233  17.929  48.821  1.00 83.97           N  
ATOM   2525  CA  SER   328       0.771  17.228  48.045  1.00 84.91           C  
ATOM   2526  C   SER   328       2.097  17.981  48.107  1.00 85.65           C  
ATOM   2527  O   SER   328       3.171  17.402  47.935  1.00 85.53           O  
ATOM   2528  CB  SER   328       0.301  17.095  46.599  1.00 84.91           C  
ATOM   2529  OG  SER   328       1.401  17.009  45.710  1.00 86.91           O  
ATOM   2530  N   LYS   329       2.023  19.283  48.347  1.00 86.24           N  
ATOM   2531  CA  LYS   329       3.237  20.063  48.446  1.00 86.83           C  
ATOM   2532  C   LYS   329       3.124  21.362  49.205  1.00 86.35           C  
ATOM   2533  O   LYS   329       2.105  22.052  49.174  1.00 86.11           O  
ATOM   2534  CB  LYS   329       3.810  20.353  47.086  1.00 87.59           C  
ATOM   2535  CG  LYS   329       3.021  19.841  45.927  1.00 89.31           C  
ATOM   2536  CD  LYS   329       2.947  20.916  44.871  1.00 90.93           C  
ATOM   2537  CE  LYS   329       3.957  22.034  45.133  1.00 90.94           C  
ATOM   2538  NZ  LYS   329       5.330  21.519  45.427  1.00 92.30           N  
ATOM   2539  N   PRO   330       4.220  21.745  49.855  1.00 85.48           N  
ATOM   2540  CA  PRO   330       4.249  22.967  50.641  1.00 84.14           C  
ATOM   2541  C   PRO   330       3.553  24.168  50.022  1.00 82.55           C  
ATOM   2542  O   PRO   330       2.716  24.777  50.677  1.00 82.62           O  
ATOM   2543  CB  PRO   330       5.738  23.175  50.875  1.00 84.95           C  
ATOM   2544  CG  PRO   330       6.245  21.754  50.946  1.00 85.65           C  
ATOM   2545  CD  PRO   330       5.576  21.184  49.732  1.00 85.80           C  
ATOM   2546  N   ALA   331       3.852  24.505  48.772  1.00 80.28           N  
ATOM   2547  CA  ALA   331       3.209  25.674  48.183  1.00 78.76           C  
ATOM   2548  C   ALA   331       1.684  25.571  48.081  1.00 78.45           C  
ATOM   2549  O   ALA   331       0.999  26.580  47.873  1.00 78.42           O  
ATOM   2550  CB  ALA   331       3.800  25.963  46.829  1.00 78.23           C  
ATOM   2551  N   ASP   332       1.146  24.365  48.242  1.00 77.36           N  
ATOM   2552  CA  ASP   332      -0.298  24.186  48.148  1.00 75.44           C  
ATOM   2553  C   ASP   332      -1.019  24.803  49.328  1.00 74.34           C  
ATOM   2554  O   ASP   332      -2.213  25.116  49.243  1.00 74.41           O  
ATOM   2555  CB  ASP   332      -0.653  22.702  48.034  1.00 74.57           C  
ATOM   2556  CG  ASP   332      -0.469  22.162  46.622  1.00 75.05           C  
ATOM   2557  OD1 ASP   332      -0.159  22.970  45.707  1.00 73.23           O  
ATOM   2558  OD2 ASP   332      -0.645  20.933  46.431  1.00 73.69           O  
ATOM   2559  N   ALA   333      -0.289  24.983  50.424  1.00 72.21           N  
ATOM   2560  CA  ALA   333      -0.862  25.572  51.621  1.00 71.76           C  
ATOM   2561  C   ALA   333      -1.219  27.033  51.378  1.00 70.41           C  
ATOM   2562  O   ALA   333      -2.051  27.615  52.076  1.00 69.75           O  
ATOM   2563  CB  ALA   333       0.114  25.461  52.762  1.00 73.24           C  
ATOM   2564  N   LEU   334      -0.576  27.618  50.379  1.00 68.45           N  
ATOM   2565  CA  LEU   334      -0.824  28.996  50.024  1.00 67.50           C  
ATOM   2566  C   LEU   334      -2.237  29.187  49.540  1.00 67.37           C  
ATOM   2567  O   LEU   334      -2.750  30.298  49.530  1.00 69.17           O  
ATOM   2568  CB  LEU   334       0.107  29.427  48.896  1.00 66.53           C  
ATOM   2569  CG  LEU   334       1.557  29.702  49.266  1.00 65.00           C  
ATOM   2570  CD1 LEU   334       2.364  29.994  48.013  1.00 61.76           C  
ATOM   2571  CD2 LEU   334       1.586  30.876  50.223  1.00 64.01           C  
ATOM   2572  N   ARG   335      -2.875  28.107  49.124  1.00 66.58           N  
ATOM   2573  CA  ARG   335      -4.210  28.243  48.588  1.00 64.78           C  
ATOM   2574  C   ARG   335      -5.225  27.398  49.319  1.00 64.81           C  
ATOM   2575  O   ARG   335      -6.430  27.566  49.159  1.00 64.78           O  
ATOM   2576  CB  ARG   335      -4.192  27.905  47.128  1.00 62.96           C  
ATOM   2577  N   VAL   336      -4.737  26.477  50.124  1.00 64.46           N  
ATOM   2578  CA  VAL   336      -5.622  25.653  50.891  1.00 64.79           C  
ATOM   2579  C   VAL   336      -5.602  26.124  52.346  1.00 66.07           C  
ATOM   2580  O   VAL   336      -6.460  25.745  53.143  1.00 66.01           O  
ATOM   2581  CB  VAL   336      -5.197  24.194  50.775  1.00 65.47           C  
ATOM   2582  CG1 VAL   336      -5.638  23.411  52.002  1.00 66.52           C  
ATOM   2583  CG2 VAL   336      -5.799  23.604  49.519  1.00 64.80           C  
ATOM   2584  N   GLY   337      -4.621  26.961  52.686  1.00 66.62           N  
ATOM   2585  CA  GLY   337      -4.520  27.473  54.044  1.00 65.36           C  
ATOM   2586  C   GLY   337      -3.439  26.816  54.888  1.00 64.29           C  
ATOM   2587  O   GLY   337      -3.198  25.612  54.786  1.00 64.43           O  
ATOM   2588  N   PHE   338      -2.809  27.604  55.749  1.00 62.48           N  
ATOM   2589  CA  PHE   338      -1.731  27.112  56.587  1.00 61.70           C  
ATOM   2590  C   PHE   338      -2.143  26.124  57.659  1.00 62.63           C  
ATOM   2591  O   PHE   338      -3.282  26.112  58.110  1.00 62.38           O  
ATOM   2592  CB  PHE   338      -1.028  28.284  57.237  1.00 60.40           C  
ATOM   2593  CG  PHE   338      -0.640  29.349  56.267  1.00 60.55           C  
ATOM   2594  CD1 PHE   338      -0.650  30.684  56.638  1.00 59.19           C  
ATOM   2595  CD2 PHE   338      -0.289  29.022  54.968  1.00 59.51           C  
ATOM   2596  CE1 PHE   338      -0.324  31.667  55.727  1.00 58.74           C  
ATOM   2597  CE2 PHE   338       0.040  30.005  54.056  1.00 58.01           C  
ATOM   2598  CZ  PHE   338       0.020  31.324  54.433  1.00 57.93           C  
ATOM   2599  N   TYR   339      -1.181  25.300  58.064  1.00 62.84           N  
ATOM   2600  CA  TYR   339      -1.387  24.304  59.103  1.00 62.87           C  
ATOM   2601  C   TYR   339      -1.874  24.943  60.403  1.00 63.24           C  
ATOM   2602  O   TYR   339      -2.826  24.471  61.006  1.00 62.89           O  
ATOM   2603  CB  TYR   339      -0.087  23.560  59.377  1.00 61.85           C  
ATOM   2604  CG  TYR   339      -0.212  22.537  60.464  1.00 60.92           C  
ATOM   2605  CD1 TYR   339      -0.963  21.392  60.270  1.00 61.61           C  
ATOM   2606  CD2 TYR   339       0.411  22.719  61.698  1.00 62.51           C  
ATOM   2607  CE1 TYR   339      -1.102  20.444  61.275  1.00 63.04           C  
ATOM   2608  CE2 TYR   339       0.283  21.778  62.712  1.00 62.88           C  
ATOM   2609  CZ  TYR   339      -0.481  20.642  62.489  1.00 63.39           C  
ATOM   2610  OH  TYR   339      -0.652  19.706  63.480  1.00 66.50           O  
ATOM   2611  N   ARG   340      -1.197  25.997  60.845  1.00 64.30           N  
ATOM   2612  CA  ARG   340      -1.583  26.685  62.071  1.00 66.36           C  
ATOM   2613  C   ARG   340      -1.273  28.167  61.950  1.00 66.52           C  
ATOM   2614  O   ARG   340      -0.112  28.559  62.007  1.00 67.27           O  
ATOM   2615  CB  ARG   340      -0.845  26.126  63.287  1.00 66.95           C  
ATOM   2616  CG  ARG   340      -1.298  26.826  64.529  1.00 71.43           C  
ATOM   2617  CD  ARG   340      -0.500  26.520  65.760  1.00 76.04           C  
ATOM   2618  NE  ARG   340      -0.982  27.383  66.835  1.00 81.26           N  
ATOM   2619  CZ  ARG   340      -0.518  27.372  68.079  1.00 83.99           C  
ATOM   2620  NH1 ARG   340       0.455  26.537  68.425  1.00 85.05           N  
ATOM   2621  NH2 ARG   340      -1.035  28.194  68.981  1.00 85.76           N  
ATOM   2622  N   ALA   341      -2.315  28.989  61.819  1.00 66.67           N  
ATOM   2623  CA  ALA   341      -2.146  30.433  61.644  1.00 65.57           C  
ATOM   2624  C   ALA   341      -2.135  31.319  62.895  1.00 65.62           C  
ATOM   2625  O   ALA   341      -2.280  30.852  64.032  1.00 65.57           O  
ATOM   2626  CB  ALA   341      -3.178  30.947  60.657  1.00 65.25           C  
ATOM   2627  N   GLN   342      -1.968  32.616  62.659  1.00 65.20           N  
ATOM   2628  CA  GLN   342      -1.876  33.610  63.722  1.00 64.89           C  
ATOM   2629  C   GLN   342      -1.941  34.975  63.068  1.00 63.30           C  
ATOM   2630  O   GLN   342      -1.803  35.091  61.853  1.00 61.88           O  
ATOM   2631  CB  GLN   342      -0.521  33.481  64.428  1.00 67.97           C  
ATOM   2632  CG  GLN   342       0.647  33.354  63.433  1.00 70.81           C  
ATOM   2633  CD  GLN   342       1.999  33.825  63.968  1.00 74.50           C  
ATOM   2634  OE1 GLN   342       2.528  33.286  64.954  1.00 76.38           O  
ATOM   2635  NE2 GLN   342       2.574  34.834  63.302  1.00 74.60           N  
ATOM   2636  N   GLU   343      -2.148  36.012  63.872  1.00 62.50           N  
ATOM   2637  CA  GLU   343      -2.179  37.373  63.339  1.00 61.34           C  
ATOM   2638  C   GLU   343      -0.776  37.547  62.772  1.00 59.29           C  
ATOM   2639  O   GLU   343       0.200  37.224  63.437  1.00 58.93           O  
ATOM   2640  CB  GLU   343      -2.417  38.366  64.471  1.00 62.57           C  
ATOM   2641  CG  GLU   343      -2.841  39.735  64.019  1.00 64.18           C  
ATOM   2642  CD  GLU   343      -3.261  40.597  65.192  1.00 65.96           C  
ATOM   2643  OE1 GLU   343      -3.604  40.012  66.248  1.00 66.64           O  
ATOM   2644  OE2 GLU   343      -3.265  41.847  65.055  1.00 66.30           O  
ATOM   2645  N   THR   344      -0.664  38.051  61.554  1.00 56.61           N  
ATOM   2646  CA  THR   344       0.648  38.177  60.944  1.00 53.90           C  
ATOM   2647  C   THR   344       0.938  39.539  60.334  1.00 53.83           C  
ATOM   2648  O   THR   344       0.088  40.109  59.640  1.00 52.77           O  
ATOM   2649  CB  THR   344       0.820  37.085  59.857  1.00 52.39           C  
ATOM   2650  OG1 THR   344       0.655  35.792  60.449  1.00 51.47           O  
ATOM   2651  CG2 THR   344       2.183  37.162  59.218  1.00 52.21           C  
ATOM   2652  N   ALA   345       2.138  40.060  60.607  1.00 53.69           N  
ATOM   2653  CA  ALA   345       2.558  41.347  60.049  1.00 54.53           C  
ATOM   2654  C   ALA   345       3.881  41.194  59.246  1.00 55.31           C  
ATOM   2655  O   ALA   345       4.909  40.764  59.771  1.00 55.22           O  
ATOM   2656  CB  ALA   345       2.707  42.386  61.165  1.00 50.73           C  
ATOM   2657  N   LEU   346       3.833  41.534  57.966  1.00 54.57           N  
ATOM   2658  CA  LEU   346       4.991  41.428  57.106  1.00 54.74           C  
ATOM   2659  C   LEU   346       5.260  42.771  56.501  1.00 56.30           C  
ATOM   2660  O   LEU   346       4.344  43.482  56.115  1.00 55.24           O  
ATOM   2661  CB  LEU   346       4.733  40.452  55.962  1.00 54.66           C  
ATOM   2662  CG  LEU   346       3.997  39.151  56.277  1.00 54.58           C  
ATOM   2663  CD1 LEU   346       3.827  38.410  54.973  1.00 54.37           C  
ATOM   2664  CD2 LEU   346       4.756  38.307  57.298  1.00 52.86           C  
ATOM   2665  N   ALA   347       6.532  43.120  56.414  1.00 60.46           N  
ATOM   2666  CA  ALA   347       6.919  44.376  55.812  1.00 63.30           C  
ATOM   2667  C   ALA   347       7.773  44.004  54.626  1.00 65.99           C  
ATOM   2668  O   ALA   347       8.550  43.055  54.685  1.00 66.09           O  
ATOM   2669  CB  ALA   347       7.712  45.204  56.785  1.00 62.72           C  
ATOM   2670  N   LEU   348       7.605  44.733  53.537  1.00 69.75           N  
ATOM   2671  CA  LEU   348       8.388  44.493  52.345  1.00 73.27           C  
ATOM   2672  C   LEU   348       9.425  45.598  52.249  1.00 76.28           C  
ATOM   2673  O   LEU   348       9.079  46.774  52.340  1.00 77.09           O  
ATOM   2674  CB  LEU   348       7.488  44.501  51.105  1.00 72.63           C  
ATOM   2675  CG  LEU   348       8.164  44.752  49.756  1.00 72.07           C  
ATOM   2676  CD1 LEU   348       7.439  44.008  48.661  1.00 72.10           C  
ATOM   2677  CD2 LEU   348       8.178  46.255  49.469  1.00 73.08           C  
ATOM   2678  N   LEU   349      10.692  45.211  52.089  1.00 80.36           N  
ATOM   2679  CA  LEU   349      11.800  46.161  51.948  1.00 84.04           C  
ATOM   2680  C   LEU   349      12.382  45.977  50.559  1.00 86.93           C  
ATOM   2681  O   LEU   349      13.096  45.008  50.253  1.00 87.77           O  
ATOM   2682  CB  LEU   349      12.885  45.930  52.997  1.00 82.81           C  
ATOM   2683  CG  LEU   349      13.916  47.051  53.179  1.00 81.98           C  
ATOM   2684  CD1 LEU   349      14.826  46.645  54.316  1.00 82.06           C  
ATOM   2685  CD2 LEU   349      14.735  47.285  51.920  1.00 81.21           C  
ATOM   2686  N   ARG   350      12.050  46.955  49.744  1.00 90.06           N  
ATOM   2687  CA  ARG   350      12.362  47.071  48.349  1.00 93.96           C  
ATOM   2688  C   ARG   350      13.733  47.732  48.103  1.00 95.24           C  
ATOM   2689  O   ARG   350      13.850  48.951  48.188  1.00 95.36           O  
ATOM   2690  CB  ARG   350      11.304  48.000  47.798  1.00 96.66           C  
ATOM   2691  CG  ARG   350      11.495  49.406  48.486  1.00101.76           C  
ATOM   2692  CD  ARG   350      10.590  49.798  49.693  1.00103.10           C  
ATOM   2693  NE  ARG   350       9.486  50.645  49.232  1.00105.61           N  
ATOM   2694  CZ  ARG   350       9.581  51.934  48.897  1.00106.47           C  
ATOM   2695  NH1 ARG   350      10.744  52.556  48.989  1.00106.98           N  
ATOM   2696  NH2 ARG   350       8.518  52.596  48.422  1.00106.24           N  
ATOM   2697  N   LEU   351      14.772  46.986  47.781  1.00 96.20           N  
ATOM   2698  CA  LEU   351      16.052  47.640  47.574  1.00 97.27           C  
ATOM   2699  C   LEU   351      16.377  47.802  46.092  1.00 98.60           C  
ATOM   2700  O   LEU   351      17.488  48.177  45.718  1.00 99.70           O  
ATOM   2701  CB  LEU   351      17.128  46.840  48.280  1.00 96.71           C  
ATOM   2702  CG  LEU   351      17.973  47.559  49.313  1.00 96.99           C  
ATOM   2703  CD1 LEU   351      18.417  46.551  50.364  1.00 95.95           C  
ATOM   2704  CD2 LEU   351      19.154  48.220  48.605  1.00 97.39           C  
ATOM   2705  N   ASP   352      15.377  47.541  45.256  1.00 99.78           N  
ATOM   2706  CA  ASP   352      15.518  47.618  43.820  1.00100.88           C  
ATOM   2707  C   ASP   352      15.245  48.992  43.210  1.00101.16           C  
ATOM   2708  O   ASP   352      16.144  49.594  42.620  1.00101.17           O  
ATOM   2709  CB  ASP   352      14.631  46.551  43.149  1.00101.28           C  
ATOM   2710  N   GLY   353      14.038  49.521  43.346  1.00101.29           N  
ATOM   2711  CA  GLY   353      13.770  50.777  42.704  1.00101.77           C  
ATOM   2712  C   GLY   353      12.365  51.307  42.835  1.00103.52           C  
ATOM   2713  O   GLY   353      12.059  52.375  42.223  1.00104.04           O  
ATOM   2714  N   ALA   354      11.433  50.548  43.432  1.00104.23           N  
ATOM   2715  CA  ALA   354      10.122  51.237  43.436  1.00105.23           C  
ATOM   2716  C   ALA   354       9.317  51.465  44.684  1.00105.23           C  
ATOM   2717  O   ALA   354       9.797  51.996  45.764  1.00106.68           O  
ATOM   2718  CB  ALA   354       9.247  50.850  42.267  1.00104.97           C  
ATOM   2719  N   GLN   355       8.039  51.034  44.588  1.00105.18           N  
ATOM   2720  CA  GLN   355       7.230  51.266  45.690  1.00103.76           C  
ATOM   2721  C   GLN   355       6.644  50.033  46.286  1.00102.50           C  
ATOM   2722  O   GLN   355       7.300  49.476  47.191  1.00104.04           O  
ATOM   2723  CB  GLN   355       6.271  52.454  45.430  1.00102.82           C  
ATOM   2724  N   GLY   356       5.533  49.482  45.854  1.00 99.31           N  
ATOM   2725  CA  GLY   356       5.135  48.337  46.613  1.00 94.67           C  
ATOM   2726  C   GLY   356       5.205  46.878  46.347  1.00 91.77           C  
ATOM   2727  O   GLY   356       6.062  46.223  45.659  1.00 92.95           O  
ATOM   2728  N   TRP   357       4.295  46.331  47.110  1.00 88.45           N  
ATOM   2729  CA  TRP   357       4.070  44.946  47.004  1.00 84.96           C  
ATOM   2730  C   TRP   357       3.775  44.540  45.507  1.00 84.34           C  
ATOM   2731  O   TRP   357       2.870  45.085  44.898  1.00 83.43           O  
ATOM   2732  CB  TRP   357       2.898  44.641  47.927  1.00 80.64           C  
ATOM   2733  CG  TRP   357       3.415  44.501  49.266  1.00 75.95           C  
ATOM   2734  CD1 TRP   357       3.373  45.378  50.319  1.00 75.26           C  
ATOM   2735  CD2 TRP   357       3.918  43.303  49.749  1.00 73.93           C  
ATOM   2736  NE1 TRP   357       3.801  44.740  51.462  1.00 73.89           N  
ATOM   2737  CE2 TRP   357       4.146  43.456  51.128  1.00 72.85           C  
ATOM   2738  CE3 TRP   357       4.192  42.081  49.138  1.00 73.29           C  
ATOM   2739  CZ2 TRP   357       4.634  42.417  51.909  1.00 71.22           C  
ATOM   2740  CZ3 TRP   357       4.669  41.054  49.898  1.00 73.42           C  
ATOM   2741  CH2 TRP   357       4.888  41.220  51.278  1.00 71.91           C  
ATOM   2742  N   PRO   358       4.555  43.599  44.879  1.00 83.85           N  
ATOM   2743  CA  PRO   358       4.178  43.251  43.483  1.00 83.32           C  
ATOM   2744  C   PRO   358       2.817  42.550  43.464  1.00 82.44           C  
ATOM   2745  O   PRO   358       2.635  41.525  44.114  1.00 80.88           O  
ATOM   2746  CB  PRO   358       5.290  42.288  43.023  1.00 83.67           C  
ATOM   2747  CG  PRO   358       6.463  42.786  43.779  1.00 83.65           C  
ATOM   2748  CD  PRO   358       5.885  43.023  45.172  1.00 83.90           C  
ATOM   2749  N   GLU   359       1.876  43.137  42.730  1.00 81.62           N  
ATOM   2750  CA  GLU   359       0.517  42.624  42.624  1.00 81.43           C  
ATOM   2751  C   GLU   359       0.384  41.119  42.848  1.00 79.12           C  
ATOM   2752  O   GLU   359      -0.442  40.695  43.647  1.00 78.89           O  
ATOM   2753  CB  GLU   359      -0.084  42.987  41.258  1.00 83.94           C  
ATOM   2754  CG  GLU   359      -1.484  43.618  41.319  1.00 88.17           C  
ATOM   2755  CD  GLU   359      -1.458  45.142  41.524  1.00 91.26           C  
ATOM   2756  OE1 GLU   359      -0.634  45.638  42.329  1.00 92.64           O  
ATOM   2757  OE2 GLU   359      -2.275  45.846  40.886  1.00 91.99           O  
ATOM   2758  N   PHE   360       1.188  40.307  42.163  1.00 76.68           N  
ATOM   2759  CA  PHE   360       1.048  38.869  42.349  1.00 75.12           C  
ATOM   2760  C   PHE   360       1.481  38.335  43.714  1.00 73.72           C  
ATOM   2761  O   PHE   360       1.085  37.231  44.102  1.00 73.90           O  
ATOM   2762  CB  PHE   360       1.722  38.075  41.212  1.00 74.23           C  
ATOM   2763  CG  PHE   360       3.163  38.382  41.007  1.00 74.14           C  
ATOM   2764  CD1 PHE   360       3.551  39.472  40.242  1.00 76.28           C  
ATOM   2765  CD2 PHE   360       4.141  37.555  41.540  1.00 74.67           C  
ATOM   2766  CE1 PHE   360       4.912  39.735  40.004  1.00 76.47           C  
ATOM   2767  CE2 PHE   360       5.493  37.805  41.314  1.00 74.78           C  
ATOM   2768  CZ  PHE   360       5.880  38.897  40.543  1.00 74.49           C  
ATOM   2769  N   LEU   361       2.271  39.117  44.448  1.00 71.70           N  
ATOM   2770  CA  LEU   361       2.702  38.721  45.787  1.00 69.76           C  
ATOM   2771  C   LEU   361       1.597  39.093  46.799  1.00 68.49           C  
ATOM   2772  O   LEU   361       1.280  38.318  47.716  1.00 68.53           O  
ATOM   2773  CB  LEU   361       4.036  39.394  46.131  1.00 70.03           C  
ATOM   2774  CG  LEU   361       5.244  38.756  45.419  1.00 70.77           C  
ATOM   2775  CD1 LEU   361       6.454  39.634  45.580  1.00 70.87           C  
ATOM   2776  CD2 LEU   361       5.518  37.356  45.972  1.00 69.38           C  
ATOM   2777  N   ARG   362       0.996  40.266  46.605  1.00 65.18           N  
ATOM   2778  CA  ARG   362      -0.097  40.729  47.453  1.00 63.12           C  
ATOM   2779  C   ARG   362      -1.265  39.715  47.361  1.00 62.00           C  
ATOM   2780  O   ARG   362      -1.849  39.309  48.377  1.00 60.91           O  
ATOM   2781  CB  ARG   362      -0.535  42.120  46.982  1.00 61.86           C  
ATOM   2782  CG  ARG   362      -1.712  42.717  47.716  1.00 61.96           C  
ATOM   2783  CD  ARG   362      -2.222  43.940  46.978  1.00 63.92           C  
ATOM   2784  NE  ARG   362      -1.195  44.977  46.840  1.00 66.76           N  
ATOM   2785  CZ  ARG   362      -0.951  45.649  45.713  1.00 67.73           C  
ATOM   2786  NH1 ARG   362      -1.654  45.392  44.608  1.00 64.71           N  
ATOM   2787  NH2 ARG   362      -0.018  46.598  45.697  1.00 66.28           N  
ATOM   2788  N   ARG   363      -1.568  39.292  46.136  1.00 59.81           N  
ATOM   2789  CA  ARG   363      -2.631  38.329  45.863  1.00 59.48           C  
ATOM   2790  C   ARG   363      -2.433  37.003  46.619  1.00 59.25           C  
ATOM   2791  O   ARG   363      -3.341  36.530  47.330  1.00 58.56           O  
ATOM   2792  CB  ARG   363      -2.696  38.023  44.352  1.00 60.89           C  
ATOM   2793  CG  ARG   363      -4.066  38.203  43.685  1.00 64.51           C  
ATOM   2794  CD  ARG   363      -4.328  37.220  42.502  1.00 68.23           C  
ATOM   2795  NE  ARG   363      -3.397  37.355  41.371  1.00 72.07           N  
ATOM   2796  CZ  ARG   363      -2.158  36.848  41.319  1.00 73.24           C  
ATOM   2797  NH1 ARG   363      -1.651  36.139  42.336  1.00 72.33           N  
ATOM   2798  NH2 ARG   363      -1.404  37.079  40.249  1.00 71.98           N  
ATOM   2799  N   ALA   364      -1.254  36.397  46.467  1.00 56.54           N  
ATOM   2800  CA  ALA   364      -1.015  35.110  47.110  1.00 54.65           C  
ATOM   2801  C   ALA   364      -1.153  35.200  48.615  1.00 53.48           C  
ATOM   2802  O   ALA   364      -1.774  34.348  49.250  1.00 51.50           O  
ATOM   2803  CB  ALA   364       0.361  34.571  46.733  1.00 54.14           C  
ATOM   2804  N   LEU   365      -0.568  36.246  49.179  1.00 52.92           N  
ATOM   2805  CA  LEU   365      -0.625  36.452  50.605  1.00 52.01           C  
ATOM   2806  C   LEU   365      -2.068  36.660  51.080  1.00 51.54           C  
ATOM   2807  O   LEU   365      -2.523  35.955  51.986  1.00 48.93           O  
ATOM   2808  CB  LEU   365       0.270  37.641  50.977  1.00 52.84           C  
ATOM   2809  CG  LEU   365       1.779  37.436  50.757  1.00 51.97           C  
ATOM   2810  CD1 LEU   365       2.499  38.700  51.212  1.00 50.86           C  
ATOM   2811  CD2 LEU   365       2.299  36.205  51.532  1.00 48.79           C  
ATOM   2812  N   LEU   366      -2.786  37.601  50.453  1.00 52.27           N  
ATOM   2813  CA  LEU   366      -4.187  37.900  50.812  1.00 53.19           C  
ATOM   2814  C   LEU   366      -5.049  36.684  50.700  1.00 54.43           C  
ATOM   2815  O   LEU   366      -5.990  36.454  51.462  1.00 54.27           O  
ATOM   2816  CB  LEU   366      -4.782  38.972  49.903  1.00 49.80           C  
ATOM   2817  CG  LEU   366      -4.097  40.310  50.135  1.00 50.24           C  
ATOM   2818  CD1 LEU   366      -4.751  41.377  49.288  1.00 47.66           C  
ATOM   2819  CD2 LEU   366      -4.150  40.648  51.622  1.00 47.10           C  
ATOM   2820  N   ARG   367      -4.719  35.891  49.719  1.00 56.43           N  
ATOM   2821  CA  ARG   367      -5.479  34.720  49.535  1.00 58.74           C  
ATOM   2822  C   ARG   367      -5.095  33.624  50.499  1.00 58.78           C  
ATOM   2823  O   ARG   367      -5.946  32.898  51.004  1.00 58.29           O  
ATOM   2824  CB  ARG   367      -5.288  34.266  48.141  1.00 63.80           C  
ATOM   2825  CG  ARG   367      -6.427  33.468  47.735  1.00 70.46           C  
ATOM   2826  CD  ARG   367      -6.042  32.818  46.520  1.00 75.79           C  
ATOM   2827  NE  ARG   367      -5.764  33.833  45.523  1.00 81.56           N  
ATOM   2828  CZ  ARG   367      -5.668  33.552  44.238  1.00 83.54           C  
ATOM   2829  NH1 ARG   367      -5.827  32.289  43.859  1.00 83.52           N  
ATOM   2830  NH2 ARG   367      -5.449  34.516  43.350  1.00 83.58           N  
ATOM   2831  N   ALA   368      -3.800  33.496  50.757  1.00 58.48           N  
ATOM   2832  CA  ALA   368      -3.341  32.473  51.677  1.00 56.99           C  
ATOM   2833  C   ALA   368      -3.985  32.690  53.041  1.00 56.60           C  
ATOM   2834  O   ALA   368      -4.560  31.764  53.625  1.00 53.99           O  
ATOM   2835  CB  ALA   368      -1.828  32.503  51.790  1.00 55.43           C  
ATOM   2836  N   PHE   369      -3.913  33.915  53.549  1.00 56.73           N  
ATOM   2837  CA  PHE   369      -4.508  34.166  54.856  1.00 57.88           C  
ATOM   2838  C   PHE   369      -6.007  34.064  54.834  1.00 57.49           C  
ATOM   2839  O   PHE   369      -6.598  33.692  55.833  1.00 57.23           O  
ATOM   2840  CB  PHE   369      -4.081  35.518  55.414  1.00 58.82           C  
ATOM   2841  CG  PHE   369      -2.689  35.515  55.940  1.00 61.44           C  
ATOM   2842  CD1 PHE   369      -1.603  35.490  55.065  1.00 61.63           C  
ATOM   2843  CD2 PHE   369      -2.456  35.435  57.309  1.00 62.48           C  
ATOM   2844  CE1 PHE   369      -0.309  35.376  55.540  1.00 62.22           C  
ATOM   2845  CE2 PHE   369      -1.162  35.318  57.797  1.00 64.00           C  
ATOM   2846  CZ  PHE   369      -0.084  35.288  56.909  1.00 63.33           C  
ATOM   2847  N   GLY   370      -6.618  34.391  53.697  1.00 57.31           N  
ATOM   2848  CA  GLY   370      -8.060  34.285  53.592  1.00 56.52           C  
ATOM   2849  C   GLY   370      -8.456  32.831  53.780  1.00 57.41           C  
ATOM   2850  O   GLY   370      -9.400  32.514  54.513  1.00 58.60           O  
ATOM   2851  N   ALA   371      -7.711  31.931  53.149  1.00 56.71           N  
ATOM   2852  CA  ALA   371      -8.013  30.503  53.247  1.00 56.52           C  
ATOM   2853  C   ALA   371      -7.740  29.949  54.635  1.00 55.56           C  
ATOM   2854  O   ALA   371      -8.270  28.907  55.020  1.00 55.91           O  
ATOM   2855  CB  ALA   371      -7.206  29.720  52.197  1.00 55.62           C  
ATOM   2856  N   SER   372      -6.898  30.650  55.380  1.00 56.44           N  
ATOM   2857  CA  SER   372      -6.534  30.237  56.727  1.00 55.52           C  
ATOM   2858  C   SER   372      -7.477  30.867  57.739  1.00 54.67           C  
ATOM   2859  O   SER   372      -7.694  30.328  58.818  1.00 56.25           O  
ATOM   2860  CB  SER   372      -5.094  30.660  57.019  1.00 57.69           C  
ATOM   2861  OG  SER   372      -4.201  30.111  56.058  1.00 58.74           O  
ATOM   2862  N   GLY   373      -8.057  32.002  57.377  1.00 53.05           N  
ATOM   2863  CA  GLY   373      -8.966  32.673  58.281  1.00 51.55           C  
ATOM   2864  C   GLY   373      -8.183  33.413  59.345  1.00 49.80           C  
ATOM   2865  O   GLY   373      -8.461  33.284  60.540  1.00 51.12           O  
ATOM   2866  N   ALA   374      -7.212  34.203  58.905  1.00 45.58           N  
ATOM   2867  CA  ALA   374      -6.372  34.929  59.819  1.00 43.74           C  
ATOM   2868  C   ALA   374      -6.066  36.331  59.336  1.00 44.12           C  
ATOM   2869  O   ALA   374      -6.093  36.619  58.137  1.00 39.91           O  
ATOM   2870  CB  ALA   374      -5.092  34.163  60.047  1.00 43.55           C  
ATOM   2871  N   SER   375      -5.770  37.194  60.302  1.00 44.81           N  
ATOM   2872  CA  SER   375      -5.476  38.588  60.046  1.00 48.94           C  
ATOM   2873  C   SER   375      -4.039  38.777  59.579  1.00 49.80           C  
ATOM   2874  O   SER   375      -3.107  38.224  60.165  1.00 50.45           O  
ATOM   2875  CB  SER   375      -5.716  39.388  61.323  1.00 50.97           C  
ATOM   2876  OG  SER   375      -6.877  38.897  61.969  1.00 56.08           O  
ATOM   2877  N   LEU   376      -3.882  39.578  58.531  1.00 49.83           N  
ATOM   2878  CA  LEU   376      -2.594  39.868  57.952  1.00 51.97           C  
ATOM   2879  C   LEU   376      -2.426  41.345  57.679  1.00 52.80           C  
ATOM   2880  O   LEU   376      -3.380  42.015  57.293  1.00 53.63           O  
ATOM   2881  CB  LEU   376      -2.440  39.135  56.623  1.00 55.03           C  
ATOM   2882  CG  LEU   376      -1.167  39.516  55.853  1.00 56.99           C  
ATOM   2883  CD1 LEU   376       0.013  38.851  56.535  1.00 55.71           C  
ATOM   2884  CD2 LEU   376      -1.254  39.096  54.395  1.00 56.77           C  
ATOM   2885  N   ARG   377      -1.213  41.854  57.872  1.00 53.29           N  
ATOM   2886  CA  ARG   377      -0.934  43.248  57.557  1.00 54.93           C  
ATOM   2887  C   ARG   377       0.223  43.263  56.586  1.00 53.45           C  
ATOM   2888  O   ARG   377       1.235  42.658  56.849  1.00 53.65           O  
ATOM   2889  CB  ARG   377      -0.572  44.053  58.800  1.00 56.22           C  
ATOM   2890  CG  ARG   377      -1.758  44.486  59.625  1.00 60.28           C  
ATOM   2891  CD  ARG   377      -1.266  45.202  60.861  1.00 65.36           C  
ATOM   2892  NE  ARG   377      -2.328  45.801  61.662  1.00 69.05           N  
ATOM   2893  CZ  ARG   377      -2.106  46.706  62.612  1.00 72.24           C  
ATOM   2894  NH1 ARG   377      -0.864  47.101  62.862  1.00 73.53           N  
ATOM   2895  NH2 ARG   377      -3.116  47.216  63.310  1.00 73.11           N  
ATOM   2896  N   LEU   378       0.056  43.941  55.458  1.00 53.65           N  
ATOM   2897  CA  LEU   378       1.102  44.038  54.450  1.00 53.25           C  
ATOM   2898  C   LEU   378       1.775  45.402  54.512  1.00 52.89           C  
ATOM   2899  O   LEU   378       1.424  46.325  53.785  1.00 51.49           O  
ATOM   2900  CB  LEU   378       0.513  43.792  53.058  1.00 53.19           C  
ATOM   2901  CG  LEU   378       1.009  42.538  52.327  1.00 53.58           C  
ATOM   2902  CD1 LEU   378       1.225  41.401  53.299  1.00 53.98           C  
ATOM   2903  CD2 LEU   378       0.007  42.146  51.272  1.00 54.10           C  
ATOM   2904  N   HIS   379       2.750  45.510  55.404  1.00 54.02           N  
ATOM   2905  CA  HIS   379       3.499  46.749  55.597  1.00 55.10           C  
ATOM   2906  C   HIS   379       4.432  47.007  54.418  1.00 56.02           C  
ATOM   2907  O   HIS   379       4.548  46.189  53.524  1.00 56.33           O  
ATOM   2908  CB  HIS   379       4.318  46.658  56.890  1.00 51.91           C  
ATOM   2909  CG  HIS   379       3.486  46.596  58.133  1.00 51.99           C  
ATOM   2910  ND1 HIS   379       3.350  47.666  58.992  1.00 50.80           N  
ATOM   2911  CD2 HIS   379       2.751  45.591  58.667  1.00 51.96           C  
ATOM   2912  CE1 HIS   379       2.568  47.320  60.001  1.00 51.49           C  
ATOM   2913  NE2 HIS   379       2.190  46.067  59.827  1.00 50.88           N  
ATOM   2914  N   THR   380       5.086  48.157  54.434  1.00 58.20           N  
ATOM   2915  CA  THR   380       6.041  48.542  53.410  1.00 61.65           C  
ATOM   2916  C   THR   380       7.079  49.474  54.042  1.00 65.35           C  
ATOM   2917  O   THR   380       6.730  50.523  54.583  1.00 66.79           O  
ATOM   2918  CB  THR   380       5.372  49.296  52.264  1.00 61.35           C  
ATOM   2919  OG1 THR   380       4.535  48.407  51.522  1.00 61.64           O  
ATOM   2920  CG2 THR   380       6.426  49.874  51.330  1.00 64.54           C  
ATOM   2921  N   LEU   381       8.355  49.113  53.984  1.00 68.20           N  
ATOM   2922  CA  LEU   381       9.359  49.979  54.575  1.00 70.75           C  
ATOM   2923  C   LEU   381       9.731  51.112  53.640  1.00 74.35           C  
ATOM   2924  O   LEU   381      10.439  50.909  52.660  1.00 75.47           O  
ATOM   2925  CB  LEU   381      10.595  49.172  54.967  1.00 68.81           C  
ATOM   2926  CG  LEU   381      10.455  48.371  56.270  1.00 67.11           C  
ATOM   2927  CD1 LEU   381      11.417  47.215  56.273  1.00 64.80           C  
ATOM   2928  CD2 LEU   381      10.700  49.272  57.465  1.00 65.73           C  
ATOM   2929  N   HIS   382       9.221  52.305  53.938  1.00 79.18           N  
ATOM   2930  CA  HIS   382       9.520  53.490  53.137  1.00 83.84           C  
ATOM   2931  C   HIS   382      10.849  54.066  53.619  1.00 86.36           C  
ATOM   2932  O   HIS   382      11.100  55.273  53.550  1.00 86.56           O  
ATOM   2933  CB  HIS   382       8.416  54.543  53.279  1.00 84.63           C  
ATOM   2934  CG  HIS   382       7.060  54.053  52.882  1.00 87.02           C  
ATOM   2935  ND1 HIS   382       6.098  53.697  53.803  1.00 87.85           N  
ATOM   2936  CD2 HIS   382       6.506  53.851  51.663  1.00 88.30           C  
ATOM   2937  CE1 HIS   382       5.009  53.300  53.169  1.00 88.78           C  
ATOM   2938  NE2 HIS   382       5.230  53.383  51.869  1.00 89.57           N  
ATOM   2939  N   ALA   383      11.692  53.184  54.138  1.00 89.15           N  
ATOM   2940  CA  ALA   383      13.005  53.574  54.610  1.00 91.84           C  
ATOM   2941  C   ALA   383      13.917  53.228  53.460  1.00 93.75           C  
ATOM   2942  O   ALA   383      13.750  52.189  52.821  1.00 93.47           O  
ATOM   2943  CB  ALA   383      13.385  52.775  55.829  1.00 93.33           C  
ATOM   2944  N   HIS   384      14.877  54.098  53.190  1.00 96.22           N  
ATOM   2945  CA  HIS   384      15.800  53.872  52.089  1.00 98.18           C  
ATOM   2946  C   HIS   384      16.596  52.601  52.335  1.00 97.41           C  
ATOM   2947  O   HIS   384      16.378  51.919  53.342  1.00 96.85           O  
ATOM   2948  CB  HIS   384      16.721  55.086  51.946  1.00100.90           C  
ATOM   2949  CG  HIS   384      15.990  56.349  51.601  1.00103.91           C  
ATOM   2950  ND1 HIS   384      15.006  56.883  52.407  1.00104.49           N  
ATOM   2951  CD2 HIS   384      16.070  57.160  50.517  1.00104.73           C  
ATOM   2952  CE1 HIS   384      14.510  57.966  51.834  1.00104.83           C  
ATOM   2953  NE2 HIS   384      15.138  58.156  50.686  1.00104.91           N  
ATOM   2954  N   PRO   385      17.494  52.235  51.398  1.00 97.04           N  
ATOM   2955  CA  PRO   385      18.282  51.020  51.619  1.00 96.77           C  
ATOM   2956  C   PRO   385      18.951  51.220  52.973  1.00 96.28           C  
ATOM   2957  O   PRO   385      18.740  52.248  53.619  1.00 95.78           O  
ATOM   2958  CB  PRO   385      19.289  51.050  50.469  1.00 96.63           C  
ATOM   2959  CG  PRO   385      18.515  51.686  49.365  1.00 96.27           C  
ATOM   2960  CD  PRO   385      17.789  52.818  50.075  1.00 97.05           C  
ATOM   2961  N   SER   386      19.749  50.265  53.422  1.00 95.39           N  
ATOM   2962  CA  SER   386      20.406  50.466  54.702  1.00 95.77           C  
ATOM   2963  C   SER   386      21.328  51.688  54.626  1.00 94.13           C  
ATOM   2964  O   SER   386      22.545  51.549  54.585  1.00 94.15           O  
ATOM   2965  CB  SER   386      21.218  49.230  55.095  1.00 97.84           C  
ATOM   2966  OG  SER   386      21.940  49.466  56.299  1.00 99.03           O  
ATOM   2967  N   GLN   387      20.748  52.883  54.617  1.00 92.28           N  
ATOM   2968  CA  GLN   387      21.545  54.101  54.538  1.00 90.28           C  
ATOM   2969  C   GLN   387      21.216  55.164  55.592  1.00 88.47           C  
ATOM   2970  O   GLN   387      20.457  56.114  55.339  1.00 86.81           O  
ATOM   2971  CB  GLN   387      21.411  54.710  53.150  1.00 90.16           C  
ATOM   2972  CG  GLN   387      21.453  53.688  52.057  1.00 90.14           C  
ATOM   2973  CD  GLN   387      21.724  54.319  50.723  1.00 91.48           C  
ATOM   2974  OE1 GLN   387      21.320  53.798  49.682  1.00 92.20           O  
ATOM   2975  NE2 GLN   387      22.426  55.451  50.739  1.00 91.98           N  
ATOM   2976  N   GLY   388      21.809  54.999  56.769  1.00 86.08           N  
ATOM   2977  CA  GLY   388      21.599  55.948  57.836  1.00 84.79           C  
ATOM   2978  C   GLY   388      21.163  55.283  59.116  1.00 84.07           C  
ATOM   2979  O   GLY   388      20.703  54.144  59.109  1.00 84.15           O  
ATOM   2980  N   LEU   389      21.336  55.980  60.229  1.00 82.60           N  
ATOM   2981  CA  LEU   389      20.898  55.431  61.490  1.00 81.50           C  
ATOM   2982  C   LEU   389      19.380  55.504  61.403  1.00 80.28           C  
ATOM   2983  O   LEU   389      18.666  54.872  62.175  1.00 79.39           O  
ATOM   2984  CB  LEU   389      21.437  56.265  62.658  1.00 82.67           C  
ATOM   2985  CG  LEU   389      22.819  55.850  63.191  1.00 83.07           C  
ATOM   2986  CD1 LEU   389      22.688  54.543  63.955  1.00 83.88           C  
ATOM   2987  CD2 LEU   389      23.815  55.691  62.053  1.00 82.66           C  
ATOM   2988  N   ALA   390      18.902  56.274  60.429  1.00 78.98           N  
ATOM   2989  CA  ALA   390      17.474  56.433  60.193  1.00 77.68           C  
ATOM   2990  C   ALA   390      16.870  55.076  59.822  1.00 77.25           C  
ATOM   2991  O   ALA   390      15.749  54.757  60.237  1.00 77.78           O  
ATOM   2992  CB  ALA   390      17.238  57.436  59.079  1.00 76.68           C  
ATOM   2993  N   PHE   391      17.614  54.291  59.038  1.00 74.91           N  
ATOM   2994  CA  PHE   391      17.179  52.955  58.625  1.00 72.52           C  
ATOM   2995  C   PHE   391      17.006  52.123  59.894  1.00 73.50           C  
ATOM   2996  O   PHE   391      15.972  51.495  60.104  1.00 75.23           O  
ATOM   2997  CB  PHE   391      18.231  52.306  57.724  1.00 68.50           C  
ATOM   2998  CG  PHE   391      17.837  50.951  57.198  1.00 64.58           C  
ATOM   2999  CD1 PHE   391      16.902  50.829  56.175  1.00 64.14           C  
ATOM   3000  CD2 PHE   391      18.389  49.792  57.740  1.00 61.18           C  
ATOM   3001  CE1 PHE   391      16.529  49.574  55.709  1.00 62.48           C  
ATOM   3002  CE2 PHE   391      18.019  48.535  57.282  1.00 57.17           C  
ATOM   3003  CZ  PHE   391      17.098  48.419  56.275  1.00 60.15           C  
ATOM   3004  N   ARG   392      18.031  52.119  60.738  1.00 73.50           N  
ATOM   3005  CA  ARG   392      17.980  51.395  62.001  1.00 73.90           C  
ATOM   3006  C   ARG   392      16.692  51.821  62.726  1.00 74.41           C  
ATOM   3007  O   ARG   392      16.064  51.017  63.420  1.00 74.51           O  
ATOM   3008  CB  ARG   392      19.218  51.762  62.844  1.00 73.67           C  
ATOM   3009  CG  ARG   392      19.276  51.216  64.285  1.00 74.97           C  
ATOM   3010  CD  ARG   392      19.768  49.772  64.351  1.00 76.08           C  
ATOM   3011  NE  ARG   392      19.942  49.281  65.722  1.00 76.87           N  
ATOM   3012  CZ  ARG   392      21.102  49.251  66.378  1.00 77.54           C  
ATOM   3013  NH1 ARG   392      22.204  49.691  65.792  1.00 77.89           N  
ATOM   3014  NH2 ARG   392      21.167  48.753  67.611  1.00 77.04           N  
ATOM   3015  N   GLU   393      16.310  53.089  62.542  1.00 73.97           N  
ATOM   3016  CA  GLU   393      15.130  53.675  63.178  1.00 73.57           C  
ATOM   3017  C   GLU   393      13.833  53.191  62.546  1.00 73.21           C  
ATOM   3018  O   GLU   393      12.904  52.816  63.251  1.00 74.45           O  
ATOM   3019  CB  GLU   393      15.213  55.213  63.118  1.00 74.67           C  
ATOM   3020  CG  GLU   393      14.123  55.986  63.886  1.00 75.44           C  
ATOM   3021  CD  GLU   393      13.875  55.449  65.294  1.00 76.45           C  
ATOM   3022  OE1 GLU   393      14.830  54.941  65.923  1.00 76.72           O  
ATOM   3023  OE2 GLU   393      12.725  55.546  65.777  1.00 75.61           O  
ATOM   3024  N   ALA   394      13.769  53.198  61.220  1.00 71.93           N  
ATOM   3025  CA  ALA   394      12.577  52.736  60.518  1.00 71.04           C  
ATOM   3026  C   ALA   394      12.267  51.281  60.885  1.00 70.73           C  
ATOM   3027  O   ALA   394      11.098  50.876  60.933  1.00 71.78           O  
ATOM   3028  CB  ALA   394      12.776  52.860  59.019  1.00 69.08           C  
ATOM   3029  N   LEU   395      13.321  50.511  61.140  1.00 68.84           N  
ATOM   3030  CA  LEU   395      13.198  49.113  61.499  1.00 68.10           C  
ATOM   3031  C   LEU   395      12.650  48.965  62.897  1.00 67.98           C  
ATOM   3032  O   LEU   395      11.709  48.209  63.120  1.00 68.98           O  
ATOM   3033  CB  LEU   395      14.555  48.414  61.433  1.00 68.67           C  
ATOM   3034  CG  LEU   395      15.317  48.286  60.110  1.00 68.06           C  
ATOM   3035  CD1 LEU   395      16.546  47.435  60.372  1.00 67.35           C  
ATOM   3036  CD2 LEU   395      14.458  47.638  59.033  1.00 67.32           C  
ATOM   3037  N   ARG   396      13.249  49.679  63.843  1.00 68.20           N  
ATOM   3038  CA  ARG   396      12.820  49.621  65.238  1.00 68.08           C  
ATOM   3039  C   ARG   396      11.334  49.948  65.310  1.00 69.44           C  
ATOM   3040  O   ARG   396      10.568  49.292  66.015  1.00 69.34           O  
ATOM   3041  CB  ARG   396      13.602  50.626  66.066  1.00 65.37           C  
ATOM   3042  CG  ARG   396      13.337  50.537  67.552  1.00 63.99           C  
ATOM   3043  CD  ARG   396      13.753  51.830  68.256  1.00 63.64           C  
ATOM   3044  NE  ARG   396      13.033  52.992  67.735  1.00 63.64           N  
ATOM   3045  CZ  ARG   396      11.753  53.260  67.986  1.00 65.07           C  
ATOM   3046  NH1 ARG   396      11.026  52.455  68.766  1.00 63.14           N  
ATOM   3047  NH2 ARG   396      11.189  54.331  67.439  1.00 64.87           N  
ATOM   3048  N   LYS   397      10.941  50.971  64.560  1.00 70.84           N  
ATOM   3049  CA  LYS   397       9.556  51.416  64.493  1.00 72.07           C  
ATOM   3050  C   LYS   397       8.665  50.269  64.002  1.00 71.46           C  
ATOM   3051  O   LYS   397       7.656  49.947  64.620  1.00 71.57           O  
ATOM   3052  CB  LYS   397       9.462  52.622  63.549  1.00 73.71           C  
ATOM   3053  CG  LYS   397       8.128  53.363  63.579  1.00 77.32           C  
ATOM   3054  CD  LYS   397       8.177  54.596  62.677  1.00 79.13           C  
ATOM   3055  CE  LYS   397       6.802  54.934  62.101  1.00 80.43           C  
ATOM   3056  NZ  LYS   397       6.876  55.967  61.015  1.00 80.60           N  
ATOM   3057  N   ALA   398       9.064  49.649  62.895  1.00 71.06           N  
ATOM   3058  CA  ALA   398       8.335  48.532  62.294  1.00 69.23           C  
ATOM   3059  C   ALA   398       8.118  47.336  63.233  1.00 68.53           C  
ATOM   3060  O   ALA   398       7.054  46.719  63.237  1.00 67.92           O  
ATOM   3061  CB  ALA   398       9.066  48.071  61.058  1.00 67.15           C  
ATOM   3062  N   LYS   399       9.134  47.003  64.017  1.00 67.52           N  
ATOM   3063  CA  LYS   399       9.043  45.872  64.922  1.00 66.89           C  
ATOM   3064  C   LYS   399       8.131  46.231  66.074  1.00 67.65           C  
ATOM   3065  O   LYS   399       7.403  45.389  66.604  1.00 67.39           O  
ATOM   3066  CB  LYS   399      10.432  45.532  65.445  1.00 65.46           C  
ATOM   3067  CG  LYS   399      10.641  44.082  65.808  1.00 65.45           C  
ATOM   3068  CD  LYS   399      10.024  43.744  67.130  1.00 66.96           C  
ATOM   3069  CE  LYS   399      10.511  42.392  67.622  1.00 68.58           C  
ATOM   3070  NZ  LYS   399      10.209  41.303  66.663  1.00 70.49           N  
ATOM   3071  N   GLU   400       8.177  47.499  66.454  1.00 68.34           N  
ATOM   3072  CA  GLU   400       7.376  47.996  67.557  1.00 68.69           C  
ATOM   3073  C   GLU   400       5.926  47.962  67.115  1.00 66.99           C  
ATOM   3074  O   GLU   400       5.038  47.610  67.880  1.00 67.27           O  
ATOM   3075  CB  GLU   400       7.795  49.425  67.880  1.00 71.17           C  
ATOM   3076  CG  GLU   400       7.492  49.880  69.288  1.00 75.33           C  
ATOM   3077  CD  GLU   400       8.040  51.266  69.547  1.00 79.00           C  
ATOM   3078  OE1 GLU   400       7.455  52.253  69.032  1.00 78.91           O  
ATOM   3079  OE2 GLU   400       9.073  51.362  70.250  1.00 81.55           O  
ATOM   3080  N   GLU   401       5.703  48.326  65.860  1.00 65.26           N  
ATOM   3081  CA  GLU   401       4.374  48.336  65.284  1.00 63.47           C  
ATOM   3082  C   GLU   401       3.846  46.935  64.992  1.00 60.72           C  
ATOM   3083  O   GLU   401       2.770  46.783  64.439  1.00 60.47           O  
ATOM   3084  CB  GLU   401       4.374  49.164  64.005  1.00 66.24           C  
ATOM   3085  CG  GLU   401       4.370  50.656  64.235  1.00 72.45           C  
ATOM   3086  CD  GLU   401       4.380  51.433  62.931  1.00 78.43           C  
ATOM   3087  OE1 GLU   401       4.260  52.681  62.978  1.00 82.26           O  
ATOM   3088  OE2 GLU   401       4.513  50.799  61.858  1.00 81.15           O  
ATOM   3089  N   GLY   402       4.608  45.909  65.349  1.00 59.20           N  
ATOM   3090  CA  GLY   402       4.150  44.545  65.121  1.00 55.54           C  
ATOM   3091  C   GLY   402       4.650  43.728  63.934  1.00 51.64           C  
ATOM   3092  O   GLY   402       4.179  42.613  63.745  1.00 49.52           O  
ATOM   3093  N   VAL   403       5.576  44.246  63.134  1.00 49.33           N  
ATOM   3094  CA  VAL   403       6.083  43.462  62.017  1.00 47.55           C  
ATOM   3095  C   VAL   403       6.810  42.258  62.589  1.00 48.03           C  
ATOM   3096  O   VAL   403       7.432  42.346  63.642  1.00 50.13           O  
ATOM   3097  CB  VAL   403       7.025  44.269  61.144  1.00 46.21           C  
ATOM   3098  CG1 VAL   403       7.603  43.379  60.085  1.00 48.28           C  
ATOM   3099  CG2 VAL   403       6.269  45.413  60.482  1.00 43.87           C  
ATOM   3100  N   GLN   404       6.716  41.123  61.909  1.00 48.46           N  
ATOM   3101  CA  GLN   404       7.325  39.892  62.389  1.00 47.90           C  
ATOM   3102  C   GLN   404       8.401  39.325  61.467  1.00 49.46           C  
ATOM   3103  O   GLN   404       9.112  38.389  61.828  1.00 50.28           O  
ATOM   3104  CB  GLN   404       6.241  38.840  62.586  1.00 47.42           C  
ATOM   3105  CG  GLN   404       4.989  39.362  63.281  1.00 49.38           C  
ATOM   3106  CD  GLN   404       3.879  38.315  63.362  1.00 51.56           C  
ATOM   3107  OE1 GLN   404       3.423  37.765  62.340  1.00 52.27           O  
ATOM   3108  NE2 GLN   404       3.446  38.028  64.578  1.00 48.42           N  
ATOM   3109  N   ALA   405       8.519  39.875  60.270  1.00 50.59           N  
ATOM   3110  CA  ALA   405       9.515  39.387  59.334  1.00 53.14           C  
ATOM   3111  C   ALA   405       9.501  40.323  58.174  1.00 54.84           C  
ATOM   3112  O   ALA   405       8.491  40.952  57.900  1.00 55.84           O  
ATOM   3113  CB  ALA   405       9.182  37.989  58.873  1.00 53.11           C  
ATOM   3114  N   VAL   406      10.625  40.419  57.486  1.00 56.75           N  
ATOM   3115  CA  VAL   406      10.725  41.317  56.358  1.00 57.07           C  
ATOM   3116  C   VAL   406      11.093  40.546  55.101  1.00 59.00           C  
ATOM   3117  O   VAL   406      11.885  39.610  55.138  1.00 59.03           O  
ATOM   3118  CB  VAL   406      11.780  42.401  56.637  1.00 55.96           C  
ATOM   3119  CG1 VAL   406      11.832  43.397  55.500  1.00 54.50           C  
ATOM   3120  CG2 VAL   406      11.456  43.101  57.945  1.00 54.72           C  
ATOM   3121  N   LEU   407      10.473  40.940  53.997  1.00 61.07           N  
ATOM   3122  CA  LEU   407      10.708  40.341  52.705  1.00 63.09           C  
ATOM   3123  C   LEU   407      11.606  41.325  51.987  1.00 66.55           C  
ATOM   3124  O   LEU   407      11.230  42.478  51.779  1.00 66.76           O  
ATOM   3125  CB  LEU   407       9.402  40.198  51.923  1.00 62.13           C  
ATOM   3126  CG  LEU   407       9.506  39.345  50.652  1.00 60.93           C  
ATOM   3127  CD1 LEU   407       9.824  37.936  51.067  1.00 57.60           C  
ATOM   3128  CD2 LEU   407       8.219  39.377  49.851  1.00 59.77           C  
ATOM   3129  N   VAL   408      12.793  40.874  51.603  1.00 69.70           N  
ATOM   3130  CA  VAL   408      13.719  41.751  50.920  1.00 71.94           C  
ATOM   3131  C   VAL   408      13.802  41.433  49.441  1.00 74.01           C  
ATOM   3132  O   VAL   408      14.261  40.358  49.057  1.00 74.62           O  
ATOM   3133  CB  VAL   408      15.127  41.655  51.532  1.00 71.44           C  
ATOM   3134  CG1 VAL   408      16.000  42.775  50.970  1.00 70.84           C  
ATOM   3135  CG2 VAL   408      15.041  41.724  53.056  1.00 69.41           C  
ATOM   3136  N   LEU   409      13.322  42.373  48.627  1.00 76.67           N  
ATOM   3137  CA  LEU   409      13.341  42.271  47.168  1.00 78.86           C  
ATOM   3138  C   LEU   409      14.599  43.029  46.779  1.00 81.23           C  
ATOM   3139  O   LEU   409      14.623  44.262  46.789  1.00 81.47           O  
ATOM   3140  CB  LEU   409      12.118  42.958  46.562  1.00 77.86           C  
ATOM   3141  CG  LEU   409      10.877  42.124  46.250  1.00 78.49           C  
ATOM   3142  CD1 LEU   409       9.748  43.062  45.860  1.00 77.07           C  
ATOM   3143  CD2 LEU   409      11.156  41.144  45.118  1.00 78.28           C  
ATOM   3144  N   THR   410      15.643  42.292  46.425  1.00 83.76           N  
ATOM   3145  CA  THR   410      16.915  42.917  46.113  1.00 85.94           C  
ATOM   3146  C   THR   410      17.734  42.218  45.040  1.00 87.27           C  
ATOM   3147  O   THR   410      17.673  41.000  44.893  1.00 86.80           O  
ATOM   3148  CB  THR   410      17.772  42.986  47.400  1.00 86.84           C  
ATOM   3149  OG1 THR   410      19.074  43.510  47.104  1.00 88.27           O  
ATOM   3150  CG2 THR   410      17.914  41.585  48.011  1.00 85.89           C  
ATOM   3151  N   PRO   411      18.498  42.996  44.259  1.00 89.39           N  
ATOM   3152  CA  PRO   411      19.346  42.434  43.208  1.00 90.75           C  
ATOM   3153  C   PRO   411      20.306  41.502  43.927  1.00 91.92           C  
ATOM   3154  O   PRO   411      20.536  41.655  45.122  1.00 91.90           O  
ATOM   3155  CB  PRO   411      20.054  43.659  42.653  1.00 91.13           C  
ATOM   3156  CG  PRO   411      18.998  44.711  42.750  1.00 91.57           C  
ATOM   3157  CD  PRO   411      18.410  44.464  44.131  1.00 90.65           C  
ATOM   3158  N   PRO   412      20.875  40.523  43.222  1.00 93.41           N  
ATOM   3159  CA  PRO   412      21.803  39.609  43.894  1.00 94.43           C  
ATOM   3160  C   PRO   412      22.856  40.305  44.760  1.00 95.63           C  
ATOM   3161  O   PRO   412      23.463  41.297  44.362  1.00 94.80           O  
ATOM   3162  CB  PRO   412      22.400  38.822  42.736  1.00 93.95           C  
ATOM   3163  CG  PRO   412      21.223  38.717  41.798  1.00 94.37           C  
ATOM   3164  CD  PRO   412      20.668  40.133  41.817  1.00 93.59           C  
ATOM   3165  N   MET   413      23.050  39.772  45.960  1.00 97.99           N  
ATOM   3166  CA  MET   413      24.012  40.322  46.908  1.00100.79           C  
ATOM   3167  C   MET   413      25.176  39.367  47.126  1.00102.04           C  
ATOM   3168  O   MET   413      25.036  38.155  46.964  1.00102.08           O  
ATOM   3169  CB  MET   413      23.355  40.557  48.272  1.00101.82           C  
ATOM   3170  CG  MET   413      22.213  41.553  48.312  1.00103.45           C  
ATOM   3171  SD  MET   413      21.362  41.420  49.911  1.00103.53           S  
ATOM   3172  CE  MET   413      22.331  42.552  50.928  1.00103.98           C  
ATOM   3173  N   ALA   414      26.320  39.927  47.509  1.00103.97           N  
ATOM   3174  CA  ALA   414      27.504  39.127  47.796  1.00105.85           C  
ATOM   3175  C   ALA   414      27.099  38.386  49.040  1.00106.38           C  
ATOM   3176  O   ALA   414      26.309  38.885  49.842  1.00106.75           O  
ATOM   3177  CB  ALA   414      28.689  40.019  48.087  1.00106.57           C  
ATOM   3178  N   TRP   415      27.599  37.203  49.275  1.00106.66           N  
ATOM   3179  CA  TRP   415      27.041  36.636  50.450  1.00107.75           C  
ATOM   3180  C   TRP   415      27.507  37.346  51.743  1.00108.51           C  
ATOM   3181  O   TRP   415      27.047  37.028  52.857  1.00107.71           O  
ATOM   3182  CB  TRP   415      27.362  35.183  50.507  1.00107.61           C  
ATOM   3183  CG  TRP   415      28.169  35.004  51.626  1.00107.74           C  
ATOM   3184  CD1 TRP   415      29.261  35.775  52.019  1.00108.18           C  
ATOM   3185  CD2 TRP   415      27.979  34.030  52.600  1.00106.65           C  
ATOM   3186  NE1 TRP   415      29.739  35.310  53.201  1.00107.61           N  
ATOM   3187  CE2 TRP   415      28.984  34.225  53.578  1.00106.40           C  
ATOM   3188  CE3 TRP   415      27.072  32.967  52.731  1.00105.06           C  
ATOM   3189  CZ2 TRP   415      29.077  33.414  54.703  1.00104.51           C  
ATOM   3190  CZ3 TRP   415      27.164  32.167  53.831  1.00104.32           C  
ATOM   3191  CH2 TRP   415      28.176  32.387  54.809  1.00104.02           C  
ATOM   3192  N   GLU   416      28.441  38.280  51.617  1.00109.72           N  
ATOM   3193  CA  GLU   416      28.915  38.997  52.791  1.00109.87           C  
ATOM   3194  C   GLU   416      27.858  40.047  53.051  1.00108.38           C  
ATOM   3195  O   GLU   416      27.329  40.143  54.153  1.00108.88           O  
ATOM   3196  CB  GLU   416      30.297  39.624  52.537  1.00111.95           C  
ATOM   3197  CG  GLU   416      31.351  38.602  52.158  1.00112.92           C  
ATOM   3198  CD  GLU   416      32.528  39.217  51.425  1.00113.76           C  
ATOM   3199  OE1 GLU   416      32.291  40.073  50.543  1.00114.47           O  
ATOM   3200  OE2 GLU   416      33.683  38.832  51.716  1.00112.91           O  
ATOM   3201  N   ASP   417      27.515  40.807  52.018  1.00106.97           N  
ATOM   3202  CA  ASP   417      26.489  41.844  52.145  1.00105.86           C  
ATOM   3203  C   ASP   417      25.119  41.269  52.552  1.00105.07           C  
ATOM   3204  O   ASP   417      24.281  41.965  53.133  1.00105.88           O  
ATOM   3205  CB  ASP   417      26.358  42.631  50.827  1.00104.58           C  
ATOM   3206  N   ARG   418      24.900  39.994  52.254  1.00103.19           N  
ATOM   3207  CA  ARG   418      23.652  39.296  52.559  1.00101.00           C  
ATOM   3208  C   ARG   418      23.593  38.969  54.032  1.00 99.87           C  
ATOM   3209  O   ARG   418      22.557  39.111  54.694  1.00100.01           O  
ATOM   3210  CB  ARG   418      23.588  38.011  51.736  1.00101.30           C  
ATOM   3211  CG  ARG   418      22.351  37.139  51.911  1.00 99.48           C  
ATOM   3212  CD  ARG   418      22.535  35.869  51.084  1.00 98.59           C  
ATOM   3213  NE  ARG   418      21.295  35.149  50.805  1.00 98.83           N  
ATOM   3214  CZ  ARG   418      20.674  34.339  51.660  1.00 98.71           C  
ATOM   3215  NH1 ARG   418      21.177  34.137  52.873  1.00 99.15           N  
ATOM   3216  NH2 ARG   418      19.557  33.718  51.294  1.00 97.51           N  
ATOM   3217  N   ASN   419      24.713  38.516  54.554  1.00 98.07           N  
ATOM   3218  CA  ASN   419      24.773  38.194  55.948  1.00 95.93           C  
ATOM   3219  C   ASN   419      24.805  39.446  56.809  1.00 94.17           C  
ATOM   3220  O   ASN   419      24.329  39.454  57.946  1.00 92.71           O  
ATOM   3221  CB  ASN   419      26.012  37.338  56.185  1.00 96.39           C  
ATOM   3222  CG  ASN   419      25.676  35.954  56.656  1.00 96.33           C  
ATOM   3223  OD1 ASN   419      24.680  35.333  56.221  1.00 96.82           O  
ATOM   3224  ND2 ASN   419      26.504  35.446  57.553  1.00 95.71           N  
ATOM   3225  N   ARG   420      25.334  40.522  56.238  1.00 92.86           N  
ATOM   3226  CA  ARG   420      25.388  41.782  56.964  1.00 90.97           C  
ATOM   3227  C   ARG   420      23.952  42.269  57.188  1.00 88.97           C  
ATOM   3228  O   ARG   420      23.499  42.421  58.332  1.00 87.55           O  
ATOM   3229  CB  ARG   420      26.210  42.830  56.191  1.00 92.12           C  
ATOM   3230  CG  ARG   420      26.701  43.988  57.043  1.00 93.45           C  
ATOM   3231  CD  ARG   420      27.931  44.649  56.428  1.00 95.52           C  
ATOM   3232  NE  ARG   420      29.094  43.758  56.398  1.00 96.90           N  
ATOM   3233  CZ  ARG   420      30.325  44.139  56.061  1.00 97.50           C  
ATOM   3234  NH1 ARG   420      30.561  45.401  55.724  1.00 97.74           N  
ATOM   3235  NH2 ARG   420      31.319  43.260  56.056  1.00 98.04           N  
ATOM   3236  N   LEU   421      23.230  42.473  56.089  1.00 85.67           N  
ATOM   3237  CA  LEU   421      21.845  42.931  56.149  1.00 82.38           C  
ATOM   3238  C   LEU   421      20.997  42.089  57.102  1.00 80.89           C  
ATOM   3239  O   LEU   421      20.285  42.628  57.947  1.00 80.23           O  
ATOM   3240  CB  LEU   421      21.217  42.936  54.747  1.00 80.13           C  
ATOM   3241  CG  LEU   421      19.820  43.568  54.650  1.00 78.25           C  
ATOM   3242  CD1 LEU   421      19.712  44.748  55.617  1.00 76.32           C  
ATOM   3243  CD2 LEU   421      19.550  44.012  53.211  1.00 76.38           C  
ATOM   3244  N   LYS   422      21.080  40.772  56.974  1.00 79.37           N  
ATOM   3245  CA  LYS   422      20.317  39.898  57.851  1.00 79.24           C  
ATOM   3246  C   LYS   422      20.703  40.148  59.290  1.00 78.84           C  
ATOM   3247  O   LYS   422      19.888  39.974  60.195  1.00 78.89           O  
ATOM   3248  CB  LYS   422      20.563  38.420  57.517  1.00 80.27           C  
ATOM   3249  CG  LYS   422      19.726  37.900  56.357  1.00 80.84           C  
ATOM   3250  CD  LYS   422      19.998  36.440  56.090  1.00 81.25           C  
ATOM   3251  CE  LYS   422      18.871  35.825  55.279  1.00 81.95           C  
ATOM   3252  NZ  LYS   422      17.671  35.600  56.125  1.00 81.02           N  
ATOM   3253  N   ALA   423      21.951  40.559  59.498  1.00 78.91           N  
ATOM   3254  CA  ALA   423      22.456  40.832  60.840  1.00 78.05           C  
ATOM   3255  C   ALA   423      21.864  42.120  61.391  1.00 76.96           C  
ATOM   3256  O   ALA   423      21.506  42.196  62.566  1.00 75.31           O  
ATOM   3257  CB  ALA   423      23.971  40.925  60.819  1.00 79.78           C  
ATOM   3258  N   LEU   424      21.764  43.132  60.538  1.00 76.20           N  
ATOM   3259  CA  LEU   424      21.203  44.404  60.956  1.00 77.10           C  
ATOM   3260  C   LEU   424      19.767  44.193  61.455  1.00 77.44           C  
ATOM   3261  O   LEU   424      19.431  44.543  62.588  1.00 77.02           O  
ATOM   3262  CB  LEU   424      21.193  45.384  59.789  1.00 77.44           C  
ATOM   3263  CG  LEU   424      21.116  46.836  60.254  1.00 79.53           C  
ATOM   3264  CD1 LEU   424      22.511  47.331  60.559  1.00 81.77           C  
ATOM   3265  CD2 LEU   424      20.514  47.694  59.182  1.00 80.78           C  
ATOM   3266  N   LEU   425      18.938  43.596  60.598  1.00 76.81           N  
ATOM   3267  CA  LEU   425      17.534  43.326  60.893  1.00 75.30           C  
ATOM   3268  C   LEU   425      17.276  42.463  62.116  1.00 76.29           C  
ATOM   3269  O   LEU   425      16.482  42.836  62.978  1.00 76.39           O  
ATOM   3270  CB  LEU   425      16.867  42.639  59.708  1.00 73.34           C  
ATOM   3271  CG  LEU   425      17.056  43.225  58.320  1.00 72.81           C  
ATOM   3272  CD1 LEU   425      16.266  42.380  57.348  1.00 71.97           C  
ATOM   3273  CD2 LEU   425      16.606  44.669  58.278  1.00 71.87           C  
ATOM   3274  N   LEU   426      17.915  41.290  62.161  1.00 77.66           N  
ATOM   3275  CA  LEU   426      17.749  40.326  63.259  1.00 77.59           C  
ATOM   3276  C   LEU   426      18.077  40.987  64.564  1.00 77.63           C  
ATOM   3277  O   LEU   426      17.692  40.541  65.643  1.00 76.70           O  
ATOM   3278  CB  LEU   426      18.687  39.136  63.097  1.00 77.39           C  
ATOM   3279  CG  LEU   426      18.287  37.996  64.031  1.00 78.31           C  
ATOM   3280  CD1 LEU   426      17.374  37.077  63.257  1.00 79.63           C  
ATOM   3281  CD2 LEU   426      19.485  37.231  64.532  1.00 78.88           C  
ATOM   3282  N   ARG   427      18.825  42.059  64.435  1.00 78.65           N  
ATOM   3283  CA  ARG   427      19.238  42.814  65.566  1.00 80.33           C  
ATOM   3284  C   ARG   427      18.067  43.345  66.284  1.00 79.47           C  
ATOM   3285  O   ARG   427      17.932  43.269  67.503  1.00 80.34           O  
ATOM   3286  CB  ARG   427      19.980  44.044  65.150  1.00 83.88           C  
ATOM   3287  CG  ARG   427      20.371  44.679  66.370  1.00 87.75           C  
ATOM   3288  CD  ARG   427      21.159  43.586  67.016  1.00 90.99           C  
ATOM   3289  NE  ARG   427      22.507  44.065  67.059  1.00 94.46           N  
ATOM   3290  CZ  ARG   427      23.002  44.617  68.148  1.00 96.65           C  
ATOM   3291  NH1 ARG   427      22.238  44.693  69.237  1.00 96.88           N  
ATOM   3292  NH2 ARG   427      24.206  45.170  68.127  1.00 96.72           N  
ATOM   3293  N   GLU   428      17.296  44.023  65.462  1.00 78.10           N  
ATOM   3294  CA  GLU   428      16.094  44.687  65.853  1.00 77.18           C  
ATOM   3295  C   GLU   428      14.976  43.677  66.021  1.00 75.63           C  
ATOM   3296  O   GLU   428      13.828  44.038  66.238  1.00 74.74           O  
ATOM   3297  CB  GLU   428      15.775  45.726  64.786  1.00 77.14           C  
ATOM   3298  CG  GLU   428      16.764  46.891  64.804  1.00 79.44           C  
ATOM   3299  CD  GLU   428      16.807  47.583  66.162  1.00 79.89           C  
ATOM   3300  OE1 GLU   428      17.534  47.112  67.067  1.00 79.73           O  
ATOM   3301  OE2 GLU   428      16.091  48.592  66.329  1.00 80.91           O  
ATOM   3302  N   GLY   429      15.336  42.402  65.931  1.00 74.63           N  
ATOM   3303  CA  GLY   429      14.360  41.334  66.080  1.00 72.55           C  
ATOM   3304  C   GLY   429      13.550  40.984  64.840  1.00 69.54           C  
ATOM   3305  O   GLY   429      12.543  40.285  64.954  1.00 69.46           O  
ATOM   3306  N   LEU   430      13.989  41.435  63.666  1.00 65.59           N  
ATOM   3307  CA  LEU   430      13.263  41.170  62.429  1.00 63.62           C  
ATOM   3308  C   LEU   430      13.808  40.068  61.507  1.00 63.34           C  
ATOM   3309  O   LEU   430      14.744  40.307  60.733  1.00 63.73           O  
ATOM   3310  CB  LEU   430      13.150  42.468  61.627  1.00 62.33           C  
ATOM   3311  CG  LEU   430      12.451  43.641  62.324  1.00 62.79           C  
ATOM   3312  CD1 LEU   430      12.677  44.896  61.493  1.00 60.07           C  
ATOM   3313  CD2 LEU   430      10.941  43.359  62.534  1.00 59.66           C  
ATOM   3314  N   PRO   431      13.237  38.846  61.578  1.00 62.40           N  
ATOM   3315  CA  PRO   431      13.720  37.774  60.703  1.00 61.39           C  
ATOM   3316  C   PRO   431      13.654  38.230  59.249  1.00 62.47           C  
ATOM   3317  O   PRO   431      13.092  39.280  58.951  1.00 63.84           O  
ATOM   3318  CB  PRO   431      12.780  36.632  61.035  1.00 61.00           C  
ATOM   3319  CG  PRO   431      12.651  36.783  62.523  1.00 59.95           C  
ATOM   3320  CD  PRO   431      12.419  38.284  62.671  1.00 61.72           C  
ATOM   3321  N   SER   432      14.226  37.468  58.328  1.00 63.15           N  
ATOM   3322  CA  SER   432      14.231  37.925  56.943  1.00 62.84           C  
ATOM   3323  C   SER   432      14.320  36.826  55.883  1.00 64.22           C  
ATOM   3324  O   SER   432      14.755  35.700  56.150  1.00 63.59           O  
ATOM   3325  CB  SER   432      15.376  38.915  56.771  1.00 62.93           C  
ATOM   3326  OG  SER   432      16.518  38.491  57.521  1.00 62.22           O  
ATOM   3327  N   GLN   433      13.897  37.176  54.675  1.00 64.53           N  
ATOM   3328  CA  GLN   433      13.890  36.257  53.551  1.00 64.83           C  
ATOM   3329  C   GLN   433      14.243  37.037  52.303  1.00 66.12           C  
ATOM   3330  O   GLN   433      13.609  38.038  51.995  1.00 64.22           O  
ATOM   3331  CB  GLN   433      12.503  35.645  53.391  1.00 63.12           C  
ATOM   3332  CG  GLN   433      12.286  34.935  52.083  1.00 61.22           C  
ATOM   3333  CD  GLN   433      13.009  33.623  52.021  1.00 61.81           C  
ATOM   3334  OE1 GLN   433      13.014  32.867  53.001  1.00 61.91           O  
ATOM   3335  NE2 GLN   433      13.616  33.321  50.866  1.00 58.69           N  
ATOM   3336  N   ILE   434      15.263  36.571  51.593  1.00 69.20           N  
ATOM   3337  CA  ILE   434      15.715  37.229  50.377  1.00 72.35           C  
ATOM   3338  C   ILE   434      14.969  36.697  49.164  1.00 73.45           C  
ATOM   3339  O   ILE   434      14.593  35.527  49.114  1.00 72.73           O  
ATOM   3340  CB  ILE   434      17.248  37.024  50.163  1.00 73.51           C  
ATOM   3341  CG1 ILE   434      18.024  37.634  51.339  1.00 74.36           C  
ATOM   3342  CG2 ILE   434      17.692  37.647  48.846  1.00 71.51           C  
ATOM   3343  CD1 ILE   434      17.862  39.133  51.482  1.00 75.29           C  
ATOM   3344  N   LEU   435      14.758  37.574  48.192  1.00 75.09           N  
ATOM   3345  CA  LEU   435      14.073  37.214  46.963  1.00 78.54           C  
ATOM   3346  C   LEU   435      14.667  38.145  45.911  1.00 80.79           C  
ATOM   3347  O   LEU   435      14.323  39.328  45.854  1.00 79.86           O  
ATOM   3348  CB  LEU   435      12.559  37.434  47.120  1.00 78.73           C  
ATOM   3349  CG  LEU   435      11.603  36.787  46.111  1.00 78.79           C  
ATOM   3350  CD1 LEU   435      10.169  36.994  46.563  1.00 78.83           C  
ATOM   3351  CD2 LEU   435      11.822  37.381  44.726  1.00 78.56           C  
ATOM   3352  N   ASN   436      15.569  37.600  45.090  1.00 84.19           N  
ATOM   3353  CA  ASN   436      16.274  38.370  44.055  1.00 86.14           C  
ATOM   3354  C   ASN   436      15.351  39.053  43.064  1.00 87.85           C  
ATOM   3355  O   ASN   436      14.460  38.432  42.503  1.00 88.11           O  
ATOM   3356  CB  ASN   436      17.297  37.478  43.354  1.00 85.32           C  
ATOM   3357  CG  ASN   436      18.254  36.808  44.345  1.00 84.74           C  
ATOM   3358  OD1 ASN   436      18.461  37.299  45.455  1.00 82.94           O  
ATOM   3359  ND2 ASN   436      18.844  35.692  43.941  1.00 85.31           N  
ATOM   3360  N   VAL   437      15.606  40.345  42.862  1.00 91.02           N  
ATOM   3361  CA  VAL   437      14.801  41.244  42.034  1.00 94.25           C  
ATOM   3362  C   VAL   437      14.242  40.875  40.643  1.00 96.47           C  
ATOM   3363  O   VAL   437      13.060  41.133  40.385  1.00 97.05           O  
ATOM   3364  CB  VAL   437      15.489  42.650  41.966  1.00 95.19           C  
ATOM   3365  CG1 VAL   437      16.833  42.558  41.273  1.00 96.70           C  
ATOM   3366  CG2 VAL   437      14.571  43.654  41.278  1.00 95.32           C  
ATOM   3367  N   PRO   438      15.054  40.305  39.722  1.00 97.89           N  
ATOM   3368  CA  PRO   438      14.426  39.983  38.426  1.00 98.05           C  
ATOM   3369  C   PRO   438      13.326  38.957  38.696  1.00 98.73           C  
ATOM   3370  O   PRO   438      13.587  37.755  38.766  1.00 98.98           O  
ATOM   3371  CB  PRO   438      15.574  39.379  37.616  1.00 97.76           C  
ATOM   3372  CG  PRO   438      16.801  39.983  38.240  1.00 98.23           C  
ATOM   3373  CD  PRO   438      16.479  39.932  39.716  1.00 98.00           C  
ATOM   3374  N   LEU   439      12.100  39.431  38.872  1.00 99.19           N  
ATOM   3375  CA  LEU   439      11.000  38.530  39.171  1.00 99.12           C  
ATOM   3376  C   LEU   439       9.855  38.740  38.206  1.00 99.09           C  
ATOM   3377  O   LEU   439       9.476  39.878  37.905  1.00 97.78           O  
ATOM   3378  CB  LEU   439      10.523  38.746  40.612  1.00 99.18           C  
ATOM   3379  CG  LEU   439       9.556  37.710  41.188  1.00 99.34           C  
ATOM   3380  CD1 LEU   439      10.187  36.331  41.109  1.00 99.23           C  
ATOM   3381  CD2 LEU   439       9.221  38.060  42.631  1.00100.08           C  
ATOM   3382  N   ARG   440       9.307  37.629  37.727  1.00 99.55           N  
ATOM   3383  CA  ARG   440       8.206  37.663  36.780  1.00100.12           C  
ATOM   3384  C   ARG   440       7.058  36.770  37.217  1.00 99.18           C  
ATOM   3385  O   ARG   440       7.274  35.663  37.708  1.00 98.60           O  
ATOM   3386  CB  ARG   440       8.708  37.234  35.401  1.00102.04           C  
ATOM   3387  CG  ARG   440       9.632  38.252  34.753  1.00105.17           C  
ATOM   3388  CD  ARG   440      10.368  37.669  33.555  1.00107.50           C  
ATOM   3389  NE  ARG   440      11.251  36.575  33.954  1.00108.82           N  
ATOM   3390  CZ  ARG   440      12.046  35.911  33.120  1.00108.98           C  
ATOM   3391  NH1 ARG   440      12.073  36.231  31.830  1.00109.58           N  
ATOM   3392  NH2 ARG   440      12.812  34.927  33.577  1.00107.31           N  
ATOM   3393  N   GLU   441       5.839  37.270  37.034  1.00 98.47           N  
ATOM   3394  CA  GLU   441       4.624  36.543  37.389  1.00 98.07           C  
ATOM   3395  C   GLU   441       4.774  35.022  37.320  1.00 98.27           C  
ATOM   3396  O   GLU   441       4.696  34.328  38.333  1.00 96.98           O  
ATOM   3397  CB  GLU   441       3.472  36.976  36.467  1.00 97.87           C  
ATOM   3398  CG  GLU   441       2.655  38.176  36.959  1.00 96.22           C  
ATOM   3399  CD  GLU   441       1.281  37.774  37.499  1.00 94.70           C  
ATOM   3400  OE1 GLU   441       1.184  36.752  38.215  1.00 92.70           O  
ATOM   3401  OE2 GLU   441       0.298  38.490  37.216  1.00 93.59           O  
ATOM   3402  N   GLU   442       5.012  34.514  36.117  1.00 99.34           N  
ATOM   3403  CA  GLU   442       5.123  33.076  35.897  1.00100.22           C  
ATOM   3404  C   GLU   442       6.396  32.373  36.399  1.00 99.72           C  
ATOM   3405  O   GLU   442       6.890  31.459  35.739  1.00100.23           O  
ATOM   3406  CB  GLU   442       4.916  32.774  34.401  1.00 99.48           C  
ATOM   3407  N   GLU   443       6.917  32.772  37.556  1.00 98.53           N  
ATOM   3408  CA  GLU   443       8.109  32.122  38.110  1.00 97.47           C  
ATOM   3409  C   GLU   443       7.723  31.454  39.424  1.00 96.61           C  
ATOM   3410  O   GLU   443       8.488  31.423  40.392  1.00 95.83           O  
ATOM   3411  CB  GLU   443       9.230  33.139  38.339  1.00 97.80           C  
ATOM   3412  CG  GLU   443       9.740  33.767  37.060  1.00 98.79           C  
ATOM   3413  CD  GLU   443      11.049  34.493  37.250  1.00 99.76           C  
ATOM   3414  OE1 GLU   443      12.030  33.843  37.675  1.00 98.85           O  
ATOM   3415  OE2 GLU   443      11.097  35.711  36.970  1.00101.08           O  
ATOM   3416  N   ARG   444       6.514  30.908  39.412  1.00 95.98           N  
ATOM   3417  CA  ARG   444       5.894  30.238  40.549  1.00 95.19           C  
ATOM   3418  C   ARG   444       6.783  29.458  41.515  1.00 94.13           C  
ATOM   3419  O   ARG   444       6.556  29.491  42.722  1.00 94.37           O  
ATOM   3420  CB  ARG   444       4.769  29.330  40.051  1.00 94.15           C  
ATOM   3421  N   HIS   445       7.793  28.758  41.024  1.00 92.74           N  
ATOM   3422  CA  HIS   445       8.605  27.986  41.946  1.00 91.04           C  
ATOM   3423  C   HIS   445       9.434  28.795  42.955  1.00 88.56           C  
ATOM   3424  O   HIS   445       9.388  28.538  44.160  1.00 87.28           O  
ATOM   3425  CB  HIS   445       9.521  27.039  41.176  1.00 92.78           C  
ATOM   3426  CG  HIS   445      10.366  26.180  42.063  1.00 95.26           C  
ATOM   3427  ND1 HIS   445       9.827  25.294  42.974  1.00 95.37           N  
ATOM   3428  CD2 HIS   445      11.710  26.112  42.221  1.00 96.05           C  
ATOM   3429  CE1 HIS   445      10.803  24.719  43.656  1.00 96.00           C  
ATOM   3430  NE2 HIS   445      11.956  25.198  43.218  1.00 96.62           N  
ATOM   3431  N   ARG   446      10.183  29.777  42.474  1.00 85.80           N  
ATOM   3432  CA  ARG   446      11.026  30.550  43.373  1.00 83.17           C  
ATOM   3433  C   ARG   446      10.257  31.370  44.410  1.00 82.01           C  
ATOM   3434  O   ARG   446      10.481  31.224  45.614  1.00 81.48           O  
ATOM   3435  CB  ARG   446      11.954  31.472  42.573  1.00 81.52           C  
ATOM   3436  CG  ARG   446      13.395  31.513  43.082  1.00 79.01           C  
ATOM   3437  CD  ARG   446      14.050  32.836  42.712  1.00 79.07           C  
ATOM   3438  NE  ARG   446      13.729  33.228  41.342  1.00 77.93           N  
ATOM   3439  CZ  ARG   446      13.788  34.475  40.887  1.00 77.82           C  
ATOM   3440  NH1 ARG   446      14.154  35.459  41.692  1.00 77.88           N  
ATOM   3441  NH2 ARG   446      13.474  34.741  39.626  1.00 78.13           N  
ATOM   3442  N   TRP   447       9.345  32.223  43.960  1.00 80.42           N  
ATOM   3443  CA  TRP   447       8.626  33.051  44.910  1.00 79.75           C  
ATOM   3444  C   TRP   447       7.647  32.348  45.853  1.00 79.40           C  
ATOM   3445  O   TRP   447       7.453  32.810  46.972  1.00 79.31           O  
ATOM   3446  CB  TRP   447       7.945  34.231  44.207  1.00 79.05           C  
ATOM   3447  CG  TRP   447       6.848  33.912  43.253  1.00 79.39           C  
ATOM   3448  CD1 TRP   447       6.945  33.817  41.896  1.00 79.71           C  
ATOM   3449  CD2 TRP   447       5.457  33.777  43.564  1.00 79.97           C  
ATOM   3450  NE1 TRP   447       5.699  33.646  41.339  1.00 79.51           N  
ATOM   3451  CE2 TRP   447       4.767  33.619  42.342  1.00 80.10           C  
ATOM   3452  CE3 TRP   447       4.723  33.780  44.758  1.00 79.53           C  
ATOM   3453  CZ2 TRP   447       3.376  33.468  42.281  1.00 79.48           C  
ATOM   3454  CZ3 TRP   447       3.341  33.628  44.695  1.00 78.13           C  
ATOM   3455  CH2 TRP   447       2.684  33.475  43.466  1.00 78.28           C  
ATOM   3456  N   GLU   448       7.031  31.246  45.437  1.00 78.76           N  
ATOM   3457  CA  GLU   448       6.119  30.557  46.347  1.00 78.69           C  
ATOM   3458  C   GLU   448       6.924  30.041  47.537  1.00 78.31           C  
ATOM   3459  O   GLU   448       6.443  29.999  48.672  1.00 78.83           O  
ATOM   3460  CB  GLU   448       5.406  29.377  45.666  1.00 79.68           C  
ATOM   3461  CG  GLU   448       4.414  29.783  44.566  1.00 80.69           C  
ATOM   3462  CD  GLU   448       3.314  28.751  44.348  1.00 79.85           C  
ATOM   3463  OE1 GLU   448       3.616  27.538  44.371  1.00 79.77           O  
ATOM   3464  OE2 GLU   448       2.150  29.162  44.144  1.00 78.03           O  
ATOM   3465  N   ASN   449       8.158  29.641  47.280  1.00 77.42           N  
ATOM   3466  CA  ASN   449       8.990  29.155  48.363  1.00 76.32           C  
ATOM   3467  C   ASN   449       9.466  30.350  49.206  1.00 74.54           C  
ATOM   3468  O   ASN   449       9.367  30.324  50.436  1.00 74.07           O  
ATOM   3469  CB  ASN   449      10.167  28.341  47.798  1.00 77.23           C  
ATOM   3470  CG  ASN   449       9.737  26.961  47.295  1.00 76.85           C  
ATOM   3471  OD1 ASN   449       8.791  26.838  46.516  1.00 77.04           O  
ATOM   3472  ND2 ASN   449      10.438  25.923  47.736  1.00 76.34           N  
ATOM   3473  N   ALA   450       9.957  31.403  48.553  1.00 71.90           N  
ATOM   3474  CA  ALA   450      10.417  32.578  49.285  1.00 69.69           C  
ATOM   3475  C   ALA   450       9.325  32.988  50.270  1.00 69.06           C  
ATOM   3476  O   ALA   450       9.602  33.286  51.436  1.00 68.21           O  
ATOM   3477  CB  ALA   450      10.716  33.720  48.321  1.00 68.92           C  
ATOM   3478  N   LEU   451       8.081  32.979  49.791  1.00 67.35           N  
ATOM   3479  CA  LEU   451       6.932  33.343  50.603  1.00 65.40           C  
ATOM   3480  C   LEU   451       6.769  32.384  51.762  1.00 65.21           C  
ATOM   3481  O   LEU   451       6.316  32.776  52.838  1.00 65.37           O  
ATOM   3482  CB  LEU   451       5.665  33.351  49.754  1.00 65.42           C  
ATOM   3483  CG  LEU   451       5.039  34.714  49.435  1.00 66.59           C  
ATOM   3484  CD1 LEU   451       6.106  35.781  49.206  1.00 66.15           C  
ATOM   3485  CD2 LEU   451       4.147  34.563  48.204  1.00 65.91           C  
ATOM   3486  N   LEU   452       7.135  31.126  51.557  1.00 64.26           N  
ATOM   3487  CA  LEU   452       7.025  30.157  52.639  1.00 64.26           C  
ATOM   3488  C   LEU   452       8.072  30.401  53.735  1.00 64.39           C  
ATOM   3489  O   LEU   452       7.779  30.242  54.928  1.00 63.61           O  
ATOM   3490  CB  LEU   452       7.151  28.734  52.095  1.00 64.86           C  
ATOM   3491  CG  LEU   452       5.905  28.180  51.404  1.00 65.27           C  
ATOM   3492  CD1 LEU   452       6.292  27.008  50.531  1.00 65.89           C  
ATOM   3493  CD2 LEU   452       4.871  27.768  52.440  1.00 62.60           C  
ATOM   3494  N   GLY   453       9.284  30.790  53.335  1.00 63.39           N  
ATOM   3495  CA  GLY   453      10.325  31.048  54.318  1.00 64.16           C  
ATOM   3496  C   GLY   453       9.997  32.271  55.155  1.00 63.73           C  
ATOM   3497  O   GLY   453      10.199  32.297  56.376  1.00 62.75           O  
ATOM   3498  N   LEU   454       9.486  33.290  54.473  1.00 62.79           N  
ATOM   3499  CA  LEU   454       9.093  34.525  55.112  1.00 62.41           C  
ATOM   3500  C   LEU   454       8.059  34.193  56.198  1.00 61.23           C  
ATOM   3501  O   LEU   454       8.178  34.644  57.346  1.00 60.74           O  
ATOM   3502  CB  LEU   454       8.503  35.477  54.059  1.00 63.32           C  
ATOM   3503  CG  LEU   454       8.546  37.017  54.194  1.00 65.10           C  
ATOM   3504  CD1 LEU   454       7.134  37.555  54.338  1.00 65.05           C  
ATOM   3505  CD2 LEU   454       9.424  37.452  55.365  1.00 65.74           C  
ATOM   3506  N   LEU   455       7.079  33.362  55.850  1.00 59.72           N  
ATOM   3507  CA  LEU   455       6.020  33.008  56.794  1.00 60.24           C  
ATOM   3508  C   LEU   455       6.484  32.094  57.910  1.00 59.72           C  
ATOM   3509  O   LEU   455       6.103  32.276  59.069  1.00 58.97           O  
ATOM   3510  CB  LEU   455       4.820  32.373  56.062  1.00 60.75           C  
ATOM   3511  CG  LEU   455       3.989  33.269  55.131  1.00 59.94           C  
ATOM   3512  CD1 LEU   455       3.138  32.408  54.250  1.00 59.53           C  
ATOM   3513  CD2 LEU   455       3.133  34.227  55.925  1.00 59.15           C  
ATOM   3514  N   ALA   456       7.298  31.106  57.561  1.00 60.17           N  
ATOM   3515  CA  ALA   456       7.823  30.175  58.555  1.00 60.06           C  
ATOM   3516  C   ALA   456       8.624  30.955  59.594  1.00 60.28           C  
ATOM   3517  O   ALA   456       8.566  30.655  60.789  1.00 59.15           O  
ATOM   3518  CB  ALA   456       8.707  29.141  57.886  1.00 60.54           C  
ATOM   3519  N   LYS   457       9.361  31.958  59.122  1.00 60.97           N  
ATOM   3520  CA  LYS   457      10.174  32.802  59.988  1.00 63.58           C  
ATOM   3521  C   LYS   457       9.310  33.738  60.813  1.00 64.57           C  
ATOM   3522  O   LYS   457       9.644  34.070  61.948  1.00 65.77           O  
ATOM   3523  CB  LYS   457      11.171  33.621  59.160  1.00 63.49           C  
ATOM   3524  CG  LYS   457      12.306  32.780  58.600  1.00 65.51           C  
ATOM   3525  CD  LYS   457      13.165  33.544  57.604  1.00 65.97           C  
ATOM   3526  CE  LYS   457      14.015  32.576  56.780  1.00 66.12           C  
ATOM   3527  NZ  LYS   457      14.828  33.275  55.741  1.00 65.64           N  
ATOM   3528  N   ALA   458       8.194  34.166  60.240  1.00 64.66           N  
ATOM   3529  CA  ALA   458       7.298  35.062  60.940  1.00 63.69           C  
ATOM   3530  C   ALA   458       6.669  34.391  62.151  1.00 62.73           C  
ATOM   3531  O   ALA   458       5.910  35.015  62.877  1.00 62.93           O  
ATOM   3532  CB  ALA   458       6.220  35.547  59.993  1.00 64.34           C  
ATOM   3533  N   GLY   459       6.994  33.127  62.375  1.00 63.10           N  
ATOM   3534  CA  GLY   459       6.427  32.405  63.503  1.00 64.91           C  
ATOM   3535  C   GLY   459       5.185  31.656  63.054  1.00 66.83           C  
ATOM   3536  O   GLY   459       4.467  31.025  63.838  1.00 66.40           O  
ATOM   3537  N   LEU   460       4.942  31.719  61.756  1.00 67.91           N  
ATOM   3538  CA  LEU   460       3.795  31.074  61.182  1.00 69.78           C  
ATOM   3539  C   LEU   460       4.116  29.664  60.684  1.00 70.34           C  
ATOM   3540  O   LEU   460       5.007  29.473  59.870  1.00 71.78           O  
ATOM   3541  CB  LEU   460       3.287  31.938  60.053  1.00 72.34           C  
ATOM   3542  CG  LEU   460       1.951  31.526  59.467  1.00 76.66           C  
ATOM   3543  CD1 LEU   460       0.855  31.575  60.530  1.00 76.70           C  
ATOM   3544  CD2 LEU   460       1.644  32.475  58.326  1.00 79.44           C  
ATOM   3545  N   GLN   461       3.375  28.679  61.177  1.00 69.76           N  
ATOM   3546  CA  GLN   461       3.576  27.289  60.788  1.00 68.59           C  
ATOM   3547  C   GLN   461       2.760  26.843  59.566  1.00 66.95           C  
ATOM   3548  O   GLN   461       1.694  26.238  59.684  1.00 64.83           O  
ATOM   3549  CB  GLN   461       3.263  26.392  61.974  1.00 70.27           C  
ATOM   3550  CG  GLN   461       3.561  24.941  61.752  1.00 72.88           C  
ATOM   3551  CD  GLN   461       3.683  24.214  63.062  1.00 76.21           C  
ATOM   3552  OE1 GLN   461       3.032  24.584  64.047  1.00 77.16           O  
ATOM   3553  NE2 GLN   461       4.511  23.169  63.092  1.00 77.22           N  
ATOM   3554  N   VAL   462       3.302  27.157  58.396  1.00 66.06           N  
ATOM   3555  CA  VAL   462       2.729  26.830  57.100  1.00 65.72           C  
ATOM   3556  C   VAL   462       2.292  25.381  56.927  1.00 66.48           C  
ATOM   3557  O   VAL   462       1.133  25.105  56.610  1.00 66.90           O  
ATOM   3558  CB  VAL   462       3.742  27.133  56.002  1.00 64.49           C  
ATOM   3559  CG1 VAL   462       3.473  26.260  54.800  1.00 63.68           C  
ATOM   3560  CG2 VAL   462       3.683  28.598  55.643  1.00 64.45           C  
ATOM   3561  N   VAL   463       3.239  24.468  57.105  1.00 66.83           N  
ATOM   3562  CA  VAL   463       2.992  23.044  56.959  1.00 67.98           C  
ATOM   3563  C   VAL   463       3.602  22.259  58.094  1.00 68.60           C  
ATOM   3564  O   VAL   463       4.584  22.682  58.686  1.00 69.47           O  
ATOM   3565  CB  VAL   463       3.617  22.500  55.670  1.00 69.08           C  
ATOM   3566  CG1 VAL   463       3.567  20.979  55.678  1.00 69.81           C  
ATOM   3567  CG2 VAL   463       2.886  23.046  54.453  1.00 69.83           C  
ATOM   3568  N   ALA   464       3.022  21.103  58.380  1.00 69.70           N  
ATOM   3569  CA  ALA   464       3.529  20.229  59.425  1.00 72.30           C  
ATOM   3570  C   ALA   464       3.805  18.852  58.807  1.00 74.52           C  
ATOM   3571  O   ALA   464       3.051  18.384  57.954  1.00 74.47           O  
ATOM   3572  CB  ALA   464       2.521  20.112  60.552  1.00 71.04           C  
ATOM   3573  N   LEU   465       4.900  18.219  59.222  1.00 76.38           N  
ATOM   3574  CA  LEU   465       5.264  16.905  58.703  1.00 77.84           C  
ATOM   3575  C   LEU   465       4.616  15.832  59.569  1.00 78.78           C  
ATOM   3576  O   LEU   465       4.476  16.025  60.779  1.00 78.89           O  
ATOM   3577  CB  LEU   465       6.787  16.747  58.695  1.00 78.40           C  
ATOM   3578  CG  LEU   465       7.559  17.587  57.665  1.00 78.96           C  
ATOM   3579  CD1 LEU   465       9.050  17.574  57.985  1.00 79.72           C  
ATOM   3580  CD2 LEU   465       7.317  17.041  56.271  1.00 77.67           C  
ATOM   3581  N   SER   466       4.214  14.725  58.936  1.00 79.81           N  
ATOM   3582  CA  SER   466       3.549  13.588  59.596  1.00 80.82           C  
ATOM   3583  C   SER   466       3.950  13.415  61.045  1.00 80.84           C  
ATOM   3584  O   SER   466       3.274  13.917  61.938  1.00 81.56           O  
ATOM   3585  CB  SER   466       3.839  12.291  58.838  1.00 82.93           C  
ATOM   3586  OG  SER   466       5.235  12.037  58.766  1.00 84.15           O  
END
