
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 ( 2017),  selected  126 , name 2p0p_A
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 2p0p_A.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      S     178           -
LGA    A     2_A      L     179           -
LGA    S     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    R     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    T     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    H    12_A      -       -           -
LGA    R    13_A      -       -           -
LGA    I    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    T    16_A      -       -           -
LGA    E    17_A      -       -           -
LGA    I    18_A      -       -           -
LGA    I    19_A      -       -           -
LGA    V    20_A      -       -           -
LGA    D    21_A      -       -           -
LGA    A    22_A      -       -           -
LGA    E    23_A      -       -           -
LGA    D    24_A      -       -           -
LGA    K    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    E    27_A      -       -           -
LGA    R    28_A      -       -           -
LGA    A    29_A      -       -           -
LGA    M    30_A      -       -           -
LGA    G    31_A      -       -           -
LGA    W    32_A      -       -           -
LGA    Y    33_A      E     180           #
LGA    Y    34_A      A     181           -
LGA    -       -      W     182           -
LGA    Y    35_A      L     183           #
LGA    L    36_A      A     184          2.935
LGA    D    37_A      Q     185           -
LGA    D    38_A      -       -           -
LGA    T    39_A      G     186          2.611
LGA    L    40_A      H     187          4.579
LGA    E    41_A      P     188          1.301
LGA    F    42_A      L     189          2.092
LGA    P    43_A      P     190          4.915
LGA    F    44_A      K     191          2.461
LGA    M    45_A      R     192          1.402
LGA    G    46_A      V     193          1.523
LGA    K    47_A      R     194          0.906
LGA    W    48_A      N     195          1.585
LGA    K    49_A      A     196          3.307
LGA    K    50_A      Y     197          4.196
LGA    K    51_A      -       -           -
LGA    S    52_A      -       -           -
LGA    R    53_A      -       -           -
LGA    K    54_A      -       -           -
LGA    T    55_A      -       -           -
LGA    S    56_A      -       -           -
LGA    T    57_A      -       -           -
LGA    I    58_A      -       -           -
LGA    E    59_A      D     198          3.472
LGA    E    60_A      R     199          2.349
LGA    K    61_A      R     200          1.812
LGA    T    62_A      T     201          1.348
LGA    V    63_A      W     202          0.797
LGA    E    64_A      E     203          1.592
LGA    V    65_A      L     204          1.647
LGA    L    66_A      L     205          2.162
LGA    G    67_A      R     206          2.867
LGA    M    68_A      L     207          2.077
LGA    A    69_A      G     208          1.707
LGA    P    70_A      E     209          1.345
LGA    D    71_A      -       -           -
LGA    D    72_A      E     210          3.385
LGA    E    73_A      D     211          1.165
LGA    C    74_A      P     212          5.294
LGA    L    75_A      K     213           -
LGA    K    76_A      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    D    77_A      G     238          3.148
LGA    M    78_A      G     239          1.771
LGA    Y    79_A      R     240          2.866
LGA    -       -      V     241           -
LGA    V    80_A      A     242          1.269
LGA    E    81_A      W     243          1.322
LGA    V    82_A      V     244          0.921
LGA    A    83_A      A     245          1.058
LGA    D    84_A      D     246          1.208
LGA    I    85_A      P     247          1.689
LGA    G    86_A      -       -           -
LGA    G    87_A      K     248          3.466
LGA    K    88_A      D     249          2.367
LGA    D    89_A      P     250          2.537
LGA    D    90_A      R     251          2.380
LGA    D    91_A      K     252          1.312
LGA    V    92_A      P     253          0.933
LGA    Y    93_A      I     254          1.123
LGA    T    94_A      P     255          1.457
LGA    A    95_A      H     256          1.087
LGA    K    96_A      L     257          1.575
LGA    L    97_A      T     258          1.481
LGA    S    98_A      G     259          1.860
LGA    D    99_A      L     260          1.656
LGA    I   100_A      L     261          1.348
LGA    E   101_A      V     262          1.455
LGA    A   102_A      P     263          0.959
LGA    I   103_A      V     264          1.036
LGA    D   104_A      L     265          1.581
LGA    V   105_A      -       -           -
LGA    D   106_A      -       -           -
LGA    D   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    T   109_A      -       -           -
LGA    Q   110_A      -       -           -
LGA    E   111_A      -       -           -
LGA    A   112_A      -       -           -
LGA    I   113_A      -       -           -
LGA    A   114_A      -       -           -
LGA    D   115_A      -       -           -
LGA    W   116_A      -       -           -
LGA    L   117_A      -       -           -
LGA    Y   118_A      -       -           -
LGA    W   119_A      -       -           -
LGA    L   120_A      -       -           -
LGA    A   121_A      -       -           -
LGA    R   122_A      -       -           -
LGA    G   123_A      -       -           -
LGA    Y   124_A      -       -           -
LGA    K   125_A      -       -           -
LGA    F   126_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126   88    5.0     55    2.29    12.73     51.450     2.306

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.888584 * X  +   0.003435 * Y  +  -0.458700 * Z  +  59.148682
  Y_new =  -0.225498 * X  +  -0.867532 * Y  +  -0.443328 * Z  +  22.913839
  Z_new =  -0.399460 * X  +   0.497370 * Y  +  -0.770101 * Z  +  24.350718 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.568140   -0.573453  [ DEG:   147.1436    -32.8564 ]
  Theta =   0.410928    2.730665  [ DEG:    23.5444    156.4556 ]
  Phi   =  -0.248526    2.893066  [ DEG:   -14.2395    165.7605 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p0p_A                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p0p_A.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126   88   5.0   55   2.29   12.73  51.450
REMARK  ---------------------------------------------------------- 
MOLECULE 2p0p_A
HEADER    METAL BINDING PROTEIN                   28-FEB-07   2P0P              
TITLE     CALCIUM BINDING PROTEIN IN THE FREE FORM                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ALR1010 PROTEIN;                                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: CCBP;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ANABAENA SP.;                                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PCC 7120;                                                    
SOURCE   5 GENE: CCBP;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    CALCIUM BINDING, METAL BINDING PROTEIN                                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    X.ZHANG,Y.HU,C.JIN                                                    
REVDAT   2   22-APR-08 2P0P    1       MODEL  REMARK HELIX                      
REVDAT   1   25-MAR-08 2P0P    0                                                
JRNL        AUTH   X.ZHANG,Y.HU,B.XIA,C.JIN                                     
JRNL        TITL   SOLUTION STRUCTURES OF CCBP FROM ANABAENA REVEALS            
JRNL        TITL 2 A NEW FOLD AND NOVEL CALCIUM BINDING SITES                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2P0P A    1   126  UNP    Q8YY42   Q8YY42_ANASP     1    126             
SEQRES   1 A  126  MET ALA SER VAL GLU ARG ASP GLU THR ARG GLU HIS ARG          
SEQRES   2 A  126  ILE GLU THR GLU ILE ILE VAL ASP ALA GLU ASP LYS GLU          
SEQRES   3 A  126  GLU ARG ALA MET GLY TRP TYR TYR TYR LEU ASP ASP THR          
SEQRES   4 A  126  LEU GLU PHE PRO PHE MET GLY LYS TRP LYS LYS LYS SER          
SEQRES   5 A  126  ARG LYS THR SER THR ILE GLU GLU LYS THR VAL GLU VAL          
SEQRES   6 A  126  LEU GLY MET ALA PRO ASP ASP GLU CYS LEU LYS ASP MET          
SEQRES   7 A  126  TYR VAL GLU VAL ALA ASP ILE GLY GLY LYS ASP ASP ASP          
SEQRES   8 A  126  VAL TYR THR ALA LYS LEU SER ASP ILE GLU ALA ILE ASP          
SEQRES   9 A  126  VAL ASP ASP ASP THR GLN GLU ALA ILE ALA ASP TRP LEU          
SEQRES  10 A  126  TYR TRP LEU ALA ARG GLY TYR LYS PHE                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      67.966  25.039  18.626  1.00  0.00           N  
ATOM      2  CA  MET A   1      67.220  26.302  18.857  1.00  0.00           C  
ATOM      3  C   MET A   1      65.863  26.024  19.530  1.00  0.00           C  
ATOM      4  O   MET A   1      65.469  24.866  19.688  1.00  0.00           O  
ATOM      5  CB  MET A   1      67.088  27.150  17.569  1.00  0.00           C  
ATOM      6  CG  MET A   1      66.135  26.580  16.506  1.00  0.00           C  
ATOM      7  SD  MET A   1      65.914  27.643  15.052  1.00  0.00           S  
ATOM      8  CE  MET A   1      64.680  26.663  14.150  1.00  0.00           C  
ATOM      9  H1  MET A   1      68.871  25.227  18.223  1.00  0.00           H  
ATOM     10  H2  MET A   1      68.095  24.557  19.502  1.00  0.00           H  
ATOM     11  H3  MET A   1      67.445  24.432  18.013  1.00  0.00           H  
ATOM     12  HA  MET A   1      67.808  26.890  19.565  1.00  0.00           H  
ATOM     13  HB2 MET A   1      66.729  28.142  17.845  1.00  0.00           H  
ATOM     14  HB3 MET A   1      68.075  27.280  17.120  1.00  0.00           H  
ATOM     15  HG2 MET A   1      66.503  25.611  16.169  1.00  0.00           H  
ATOM     16  HG3 MET A   1      65.156  26.439  16.958  1.00  0.00           H  
ATOM     17  HE1 MET A   1      64.422  27.166  13.218  1.00  0.00           H  
ATOM     18  HE2 MET A   1      65.087  25.677  13.925  1.00  0.00           H  
ATOM     19  HE3 MET A   1      63.782  26.549  14.758  1.00  0.00           H  
ATOM     20  N   ALA A   2      65.139  27.079  19.939  1.00  0.00           N  
ATOM     21  CA  ALA A   2      63.848  26.946  20.617  1.00  0.00           C  
ATOM     22  C   ALA A   2      62.789  26.286  19.722  1.00  0.00           C  
ATOM     23  O   ALA A   2      61.984  25.495  20.213  1.00  0.00           O  
ATOM     24  CB  ALA A   2      63.363  28.330  21.076  1.00  0.00           C  
ATOM     25  H   ALA A   2      65.516  28.012  19.832  1.00  0.00           H  
ATOM     26  HA  ALA A   2      63.985  26.323  21.503  1.00  0.00           H  
ATOM     27  HB1 ALA A   2      63.221  28.989  20.217  1.00  0.00           H  
ATOM     28  HB2 ALA A   2      62.415  28.228  21.605  1.00  0.00           H  
ATOM     29  HB3 ALA A   2      64.093  28.772  21.753  1.00  0.00           H  
ATOM     30  N   SER A   3      62.778  26.627  18.427  1.00  0.00           N  
ATOM     31  CA  SER A   3      61.849  26.126  17.405  1.00  0.00           C  
ATOM     32  C   SER A   3      60.356  26.351  17.711  1.00  0.00           C  
ATOM     33  O   SER A   3      59.506  25.848  16.972  1.00  0.00           O  
ATOM     34  CB  SER A   3      62.162  24.657  17.078  1.00  0.00           C  
ATOM     35  OG  SER A   3      63.538  24.486  16.778  1.00  0.00           O  
ATOM     36  H   SER A   3      63.478  27.277  18.105  1.00  0.00           H  
ATOM     37  HA  SER A   3      62.050  26.699  16.500  1.00  0.00           H  
ATOM     38  HB2 SER A   3      61.895  24.029  17.928  1.00  0.00           H  
ATOM     39  HB3 SER A   3      61.568  24.348  16.216  1.00  0.00           H  
ATOM     40  HG  SER A   3      63.692  23.543  16.606  1.00  0.00           H  
ATOM     41  N   VAL A   4      60.018  27.135  18.743  1.00  0.00           N  
ATOM     42  CA  VAL A   4      58.656  27.592  19.032  1.00  0.00           C  
ATOM     43  C   VAL A   4      58.081  28.341  17.815  1.00  0.00           C  
ATOM     44  O   VAL A   4      56.882  28.288  17.543  1.00  0.00           O  
ATOM     45  CB  VAL A   4      58.685  28.417  20.338  1.00  0.00           C  
ATOM     46  CG1 VAL A   4      59.491  29.721  20.205  1.00  0.00           C  
ATOM     47  CG2 VAL A   4      57.281  28.729  20.865  1.00  0.00           C  
ATOM     48  H   VAL A   4      60.750  27.465  19.352  1.00  0.00           H  
ATOM     49  HA  VAL A   4      58.042  26.705  19.202  1.00  0.00           H  
ATOM     50  HB  VAL A   4      59.179  27.808  21.096  1.00  0.00           H  
ATOM     51 HG11 VAL A   4      60.500  29.525  19.845  1.00  0.00           H  
ATOM     52 HG12 VAL A   4      58.989  30.408  19.524  1.00  0.00           H  
ATOM     53 HG13 VAL A   4      59.570  30.198  21.178  1.00  0.00           H  
ATOM     54 HG21 VAL A   4      56.719  27.802  20.989  1.00  0.00           H  
ATOM     55 HG22 VAL A   4      57.355  29.223  21.834  1.00  0.00           H  
ATOM     56 HG23 VAL A   4      56.749  29.377  20.169  1.00  0.00           H  
ATOM     57  N   GLU A   5      58.963  28.985  17.051  1.00  0.00           N  
ATOM     58  CA  GLU A   5      58.739  29.573  15.754  1.00  0.00           C  
ATOM     59  C   GLU A   5      60.035  29.261  15.000  1.00  0.00           C  
ATOM     60  O   GLU A   5      61.117  29.213  15.599  1.00  0.00           O  
ATOM     61  CB  GLU A   5      58.454  31.074  15.904  1.00  0.00           C  
ATOM     62  CG  GLU A   5      58.420  31.800  14.556  1.00  0.00           C  
ATOM     63  CD  GLU A   5      57.327  31.234  13.637  1.00  0.00           C  
ATOM     64  OE1 GLU A   5      56.183  31.727  13.690  1.00  0.00           O  
ATOM     65  OE2 GLU A   5      57.594  30.269  12.883  1.00  0.00           O  
ATOM     66  H   GLU A   5      59.939  28.971  17.308  1.00  0.00           H  
ATOM     67  HA  GLU A   5      57.897  29.078  15.267  1.00  0.00           H  
ATOM     68  HB2 GLU A   5      57.495  31.206  16.407  1.00  0.00           H  
ATOM     69  HB3 GLU A   5      59.223  31.529  16.524  1.00  0.00           H  
ATOM     70  HG2 GLU A   5      58.241  32.859  14.737  1.00  0.00           H  
ATOM     71  HG3 GLU A   5      59.398  31.703  14.082  1.00  0.00           H  
ATOM     72  N   ARG A   6      59.926  29.003  13.701  1.00  0.00           N  
ATOM     73  CA  ARG A   6      61.001  28.479  12.869  1.00  0.00           C  
ATOM     74  C   ARG A   6      60.928  28.975  11.425  1.00  0.00           C  
ATOM     75  O   ARG A   6      61.786  28.598  10.626  1.00  0.00           O  
ATOM     76  CB  ARG A   6      60.933  26.946  12.952  1.00  0.00           C  
ATOM     77  CG  ARG A   6      59.664  26.360  12.303  1.00  0.00           C  
ATOM     78  CD  ARG A   6      59.491  24.868  12.619  1.00  0.00           C  
ATOM     79  NE  ARG A   6      59.216  24.627  14.051  1.00  0.00           N  
ATOM     80  CZ  ARG A   6      58.872  23.453  14.595  1.00  0.00           C  
ATOM     81  NH1 ARG A   6      58.753  22.361  13.844  1.00  0.00           N  
ATOM     82  NH2 ARG A   6      58.653  23.389  15.902  1.00  0.00           N  
ATOM     83  H   ARG A   6      59.011  29.098  13.269  1.00  0.00           H  
ATOM     84  HA  ARG A   6      61.956  28.809  13.284  1.00  0.00           H  
ATOM     85  HB2 ARG A   6      61.812  26.517  12.469  1.00  0.00           H  
ATOM     86  HB3 ARG A   6      60.955  26.678  14.007  1.00  0.00           H  
ATOM     87  HG2 ARG A   6      58.778  26.896  12.647  1.00  0.00           H  
ATOM     88  HG3 ARG A   6      59.730  26.488  11.221  1.00  0.00           H  
ATOM     89  HD2 ARG A   6      58.655  24.490  12.030  1.00  0.00           H  
ATOM     90  HD3 ARG A   6      60.396  24.332  12.326  1.00  0.00           H  
ATOM     91  HE  ARG A   6      59.287  25.431  14.666  1.00  0.00           H  
ATOM     92 HH11 ARG A   6      58.922  22.398  12.849  1.00  0.00           H  
ATOM     93 HH12 ARG A   6      58.494  21.464  14.235  1.00  0.00           H  
ATOM     94 HH21 ARG A   6      58.767  24.225  16.476  1.00  0.00           H  
ATOM     95 HH22 ARG A   6      58.380  22.533  16.365  1.00  0.00           H  
ATOM     96  N   ASP A   7      59.942  29.804  11.074  1.00  0.00           N  
ATOM     97  CA  ASP A   7      59.820  30.404   9.749  1.00  0.00           C  
ATOM     98  C   ASP A   7      59.597  31.902   9.930  1.00  0.00           C  
ATOM     99  O   ASP A   7      58.870  32.335  10.827  1.00  0.00           O  
ATOM    100  CB  ASP A   7      58.687  29.754   8.952  1.00  0.00           C  
ATOM    101  CG  ASP A   7      58.543  30.429   7.583  1.00  0.00           C  
ATOM    102  OD1 ASP A   7      57.867  31.477   7.503  1.00  0.00           O  
ATOM    103  OD2 ASP A   7      59.115  29.920   6.592  1.00  0.00           O  
ATOM    104  H   ASP A   7      59.260  30.115  11.762  1.00  0.00           H  
ATOM    105  HA  ASP A   7      60.745  30.255   9.190  1.00  0.00           H  
ATOM    106  HB2 ASP A   7      58.899  28.690   8.825  1.00  0.00           H  
ATOM    107  HB3 ASP A   7      57.754  29.851   9.504  1.00  0.00           H  
ATOM    108  N   GLU A   8      60.265  32.698   9.097  1.00  0.00           N  
ATOM    109  CA  GLU A   8      60.345  34.140   9.277  1.00  0.00           C  
ATOM    110  C   GLU A   8      59.053  34.889   8.923  1.00  0.00           C  
ATOM    111  O   GLU A   8      58.978  36.080   9.216  1.00  0.00           O  
ATOM    112  CB  GLU A   8      61.527  34.702   8.466  1.00  0.00           C  
ATOM    113  CG  GLU A   8      62.884  34.130   8.901  1.00  0.00           C  
ATOM    114  CD  GLU A   8      64.043  34.770   8.115  1.00  0.00           C  
ATOM    115  OE1 GLU A   8      64.398  34.266   7.025  1.00  0.00           O  
ATOM    116  OE2 GLU A   8      64.636  35.765   8.592  1.00  0.00           O  
ATOM    117  H   GLU A   8      60.824  32.292   8.361  1.00  0.00           H  
ATOM    118  HA  GLU A   8      60.541  34.312  10.337  1.00  0.00           H  
ATOM    119  HB2 GLU A   8      61.368  34.490   7.407  1.00  0.00           H  
ATOM    120  HB3 GLU A   8      61.559  35.783   8.602  1.00  0.00           H  
ATOM    121  HG2 GLU A   8      63.020  34.311   9.970  1.00  0.00           H  
ATOM    122  HG3 GLU A   8      62.894  33.050   8.744  1.00  0.00           H  
ATOM    123  N   THR A   9      58.038  34.259   8.316  1.00  0.00           N  
ATOM    124  CA  THR A   9      56.807  34.938   7.901  1.00  0.00           C  
ATOM    125  C   THR A   9      56.201  35.732   9.059  1.00  0.00           C  
ATOM    126  O   THR A   9      55.910  36.913   8.887  1.00  0.00           O  
ATOM    127  CB  THR A   9      55.826  33.916   7.305  1.00  0.00           C  
ATOM    128  OG1 THR A   9      56.446  33.196   6.260  1.00  0.00           O  
ATOM    129  CG2 THR A   9      54.567  34.573   6.733  1.00  0.00           C  
ATOM    130  H   THR A   9      58.108  33.267   8.100  1.00  0.00           H  
ATOM    131  HA  THR A   9      57.035  35.664   7.122  1.00  0.00           H  
ATOM    132  HB  THR A   9      55.535  33.213   8.082  1.00  0.00           H  
ATOM    133  HG1 THR A   9      57.015  32.522   6.707  1.00  0.00           H  
ATOM    134 HG21 THR A   9      53.938  33.817   6.264  1.00  0.00           H  
ATOM    135 HG22 THR A   9      53.999  35.044   7.535  1.00  0.00           H  
ATOM    136 HG23 THR A   9      54.841  35.329   5.996  1.00  0.00           H  
ATOM    137  N   ARG A  10      56.068  35.146  10.254  1.00  0.00           N  
ATOM    138  CA  ARG A  10      55.477  35.872  11.381  1.00  0.00           C  
ATOM    139  C   ARG A  10      56.337  37.070  11.780  1.00  0.00           C  
ATOM    140  O   ARG A  10      55.781  38.106  12.138  1.00  0.00           O  
ATOM    141  CB  ARG A  10      55.223  34.940  12.578  1.00  0.00           C  
ATOM    142  CG  ARG A  10      53.870  34.204  12.506  1.00  0.00           C  
ATOM    143  CD  ARG A  10      53.705  33.224  11.335  1.00  0.00           C  
ATOM    144  NE  ARG A  10      54.650  32.104  11.439  1.00  0.00           N  
ATOM    145  CZ  ARG A  10      54.707  31.020  10.662  1.00  0.00           C  
ATOM    146  NH1 ARG A  10      53.908  30.895   9.604  1.00  0.00           N  
ATOM    147  NH2 ARG A  10      55.572  30.061  10.965  1.00  0.00           N  
ATOM    148  H   ARG A  10      56.373  34.198  10.378  1.00  0.00           H  
ATOM    149  HA  ARG A  10      54.519  36.285  11.057  1.00  0.00           H  
ATOM    150  HB2 ARG A  10      56.043  34.230  12.678  1.00  0.00           H  
ATOM    151  HB3 ARG A  10      55.204  35.546  13.488  1.00  0.00           H  
ATOM    152  HG2 ARG A  10      53.728  33.655  13.437  1.00  0.00           H  
ATOM    153  HG3 ARG A  10      53.075  34.948  12.444  1.00  0.00           H  
ATOM    154  HD2 ARG A  10      52.688  32.828  11.365  1.00  0.00           H  
ATOM    155  HD3 ARG A  10      53.841  33.747  10.389  1.00  0.00           H  
ATOM    156  HE  ARG A  10      55.239  32.104  12.278  1.00  0.00           H  
ATOM    157 HH11 ARG A  10      53.229  31.609   9.383  1.00  0.00           H  
ATOM    158 HH12 ARG A  10      53.931  30.081   9.006  1.00  0.00           H  
ATOM    159 HH21 ARG A  10      56.235  30.184  11.743  1.00  0.00           H  
ATOM    160 HH22 ARG A  10      55.640  29.207  10.432  1.00  0.00           H  
ATOM    161  N   GLU A  11      57.666  36.970  11.685  1.00  0.00           N  
ATOM    162  CA  GLU A  11      58.551  38.086  12.000  1.00  0.00           C  
ATOM    163  C   GLU A  11      58.409  39.194  10.951  1.00  0.00           C  
ATOM    164  O   GLU A  11      58.333  40.367  11.314  1.00  0.00           O  
ATOM    165  CB  GLU A  11      60.011  37.626  12.134  1.00  0.00           C  
ATOM    166  CG  GLU A  11      60.208  36.705  13.347  1.00  0.00           C  
ATOM    167  CD  GLU A  11      61.698  36.440  13.620  1.00  0.00           C  
ATOM    168  OE1 GLU A  11      62.351  37.277  14.285  1.00  0.00           O  
ATOM    169  OE2 GLU A  11      62.224  35.390  13.185  1.00  0.00           O  
ATOM    170  H   GLU A  11      58.076  36.140  11.282  1.00  0.00           H  
ATOM    171  HA  GLU A  11      58.249  38.497  12.963  1.00  0.00           H  
ATOM    172  HB2 GLU A  11      60.332  37.112  11.228  1.00  0.00           H  
ATOM    173  HB3 GLU A  11      60.636  38.510  12.267  1.00  0.00           H  
ATOM    174  HG2 GLU A  11      59.763  37.173  14.228  1.00  0.00           H  
ATOM    175  HG3 GLU A  11      59.689  35.760  13.173  1.00  0.00           H  
ATOM    176  N   HIS A  12      58.304  38.853   9.662  1.00  0.00           N  
ATOM    177  CA  HIS A  12      58.052  39.847   8.622  1.00  0.00           C  
ATOM    178  C   HIS A  12      56.682  40.493   8.818  1.00  0.00           C  
ATOM    179  O   HIS A  12      56.552  41.709   8.664  1.00  0.00           O  
ATOM    180  CB  HIS A  12      58.117  39.222   7.224  1.00  0.00           C  
ATOM    181  CG  HIS A  12      59.477  38.710   6.827  1.00  0.00           C  
ATOM    182  ND1 HIS A  12      60.618  39.457   6.622  1.00  0.00           N  
ATOM    183  CD2 HIS A  12      59.787  37.412   6.531  1.00  0.00           C  
ATOM    184  CE1 HIS A  12      61.591  38.624   6.214  1.00  0.00           C  
ATOM    185  NE2 HIS A  12      61.130  37.360   6.137  1.00  0.00           N  
ATOM    186  H   HIS A  12      58.362  37.870   9.389  1.00  0.00           H  
ATOM    187  HA  HIS A  12      58.810  40.629   8.693  1.00  0.00           H  
ATOM    188  HB2 HIS A  12      57.396  38.406   7.160  1.00  0.00           H  
ATOM    189  HB3 HIS A  12      57.820  39.977   6.494  1.00  0.00           H  
ATOM    190  HD1 HIS A  12      60.714  40.461   6.736  1.00  0.00           H  
ATOM    191  HD2 HIS A  12      59.092  36.584   6.581  1.00  0.00           H  
ATOM    192  HE1 HIS A  12      62.601  38.934   5.972  1.00  0.00           H  
ATOM    193  N   ARG A  13      55.653  39.710   9.157  1.00  0.00           N  
ATOM    194  CA  ARG A  13      54.306  40.244   9.308  1.00  0.00           C  
ATOM    195  C   ARG A  13      54.273  41.201  10.483  1.00  0.00           C  
ATOM    196  O   ARG A  13      53.828  42.330  10.309  1.00  0.00           O  
ATOM    197  CB  ARG A  13      53.251  39.131   9.469  1.00  0.00           C  
ATOM    198  CG  ARG A  13      52.950  38.303   8.202  1.00  0.00           C  
ATOM    199  CD  ARG A  13      52.788  39.121   6.913  1.00  0.00           C  
ATOM    200  NE  ARG A  13      51.832  40.235   7.076  1.00  0.00           N  
ATOM    201  CZ  ARG A  13      51.877  41.415   6.443  1.00  0.00           C  
ATOM    202  NH1 ARG A  13      52.768  41.639   5.480  1.00  0.00           N  
ATOM    203  NH2 ARG A  13      51.017  42.367   6.783  1.00  0.00           N  
ATOM    204  H   ARG A  13      55.811  38.716   9.323  1.00  0.00           H  
ATOM    205  HA  ARG A  13      54.072  40.843   8.428  1.00  0.00           H  
ATOM    206  HB2 ARG A  13      53.552  38.455  10.270  1.00  0.00           H  
ATOM    207  HB3 ARG A  13      52.318  39.602   9.781  1.00  0.00           H  
ATOM    208  HG2 ARG A  13      53.749  37.586   8.033  1.00  0.00           H  
ATOM    209  HG3 ARG A  13      52.037  37.733   8.374  1.00  0.00           H  
ATOM    210  HD2 ARG A  13      53.774  39.498   6.633  1.00  0.00           H  
ATOM    211  HD3 ARG A  13      52.445  38.458   6.119  1.00  0.00           H  
ATOM    212  HE  ARG A  13      51.101  40.093   7.763  1.00  0.00           H  
ATOM    213 HH11 ARG A  13      53.420  40.920   5.205  1.00  0.00           H  
ATOM    214 HH12 ARG A  13      52.861  42.540   5.035  1.00  0.00           H  
ATOM    215 HH21 ARG A  13      50.351  42.215   7.551  1.00  0.00           H  
ATOM    216 HH22 ARG A  13      51.009  43.271   6.336  1.00  0.00           H  
ATOM    217  N   ILE A  14      54.768  40.800  11.654  1.00  0.00           N  
ATOM    218  CA  ILE A  14      54.683  41.650  12.832  1.00  0.00           C  
ATOM    219  C   ILE A  14      55.453  42.958  12.592  1.00  0.00           C  
ATOM    220  O   ILE A  14      54.925  44.036  12.878  1.00  0.00           O  
ATOM    221  CB  ILE A  14      55.078  40.841  14.089  1.00  0.00           C  
ATOM    222  CG1 ILE A  14      54.450  41.499  15.331  1.00  0.00           C  
ATOM    223  CG2 ILE A  14      56.587  40.631  14.268  1.00  0.00           C  
ATOM    224  CD1 ILE A  14      54.604  40.694  16.623  1.00  0.00           C  
ATOM    225  H   ILE A  14      55.124  39.868  11.750  1.00  0.00           H  
ATOM    226  HA  ILE A  14      53.629  41.918  12.932  1.00  0.00           H  
ATOM    227  HB  ILE A  14      54.631  39.852  13.969  1.00  0.00           H  
ATOM    228 HG12 ILE A  14      54.883  42.484  15.484  1.00  0.00           H  
ATOM    229 HG13 ILE A  14      53.387  41.619  15.144  1.00  0.00           H  
ATOM    230 HG21 ILE A  14      57.083  41.566  14.524  1.00  0.00           H  
ATOM    231 HG22 ILE A  14      56.777  39.898  15.052  1.00  0.00           H  
ATOM    232 HG23 ILE A  14      57.001  40.246  13.346  1.00  0.00           H  
ATOM    233 HD11 ILE A  14      55.650  40.669  16.929  1.00  0.00           H  
ATOM    234 HD12 ILE A  14      54.020  41.171  17.410  1.00  0.00           H  
ATOM    235 HD13 ILE A  14      54.239  39.677  16.476  1.00  0.00           H  
ATOM    236  N   GLU A  15      56.627  42.880  11.955  1.00  0.00           N  
ATOM    237  CA  GLU A  15      57.437  44.030  11.567  1.00  0.00           C  
ATOM    238  C   GLU A  15      56.652  45.004  10.680  1.00  0.00           C  
ATOM    239  O   GLU A  15      56.788  46.217  10.840  1.00  0.00           O  
ATOM    240  CB  GLU A  15      58.690  43.501  10.848  1.00  0.00           C  
ATOM    241  CG  GLU A  15      59.621  44.591  10.306  1.00  0.00           C  
ATOM    242  CD  GLU A  15      60.258  45.449  11.411  1.00  0.00           C  
ATOM    243  OE1 GLU A  15      60.783  44.891  12.399  1.00  0.00           O  
ATOM    244  OE2 GLU A  15      60.264  46.694  11.298  1.00  0.00           O  
ATOM    245  H   GLU A  15      56.985  41.956  11.672  1.00  0.00           H  
ATOM    246  HA  GLU A  15      57.755  44.562  12.462  1.00  0.00           H  
ATOM    247  HB2 GLU A  15      59.252  42.866  11.532  1.00  0.00           H  
ATOM    248  HB3 GLU A  15      58.381  42.888  10.003  1.00  0.00           H  
ATOM    249  HG2 GLU A  15      60.416  44.108   9.736  1.00  0.00           H  
ATOM    250  HG3 GLU A  15      59.054  45.216   9.616  1.00  0.00           H  
ATOM    251  N   THR A  16      55.819  44.491   9.772  1.00  0.00           N  
ATOM    252  CA  THR A  16      55.144  45.285   8.749  1.00  0.00           C  
ATOM    253  C   THR A  16      53.663  45.537   9.080  1.00  0.00           C  
ATOM    254  O   THR A  16      52.943  46.100   8.250  1.00  0.00           O  
ATOM    255  CB  THR A  16      55.364  44.652   7.359  1.00  0.00           C  
ATOM    256  OG1 THR A  16      54.928  43.310   7.304  1.00  0.00           O  
ATOM    257  CG2 THR A  16      56.838  44.699   6.936  1.00  0.00           C  
ATOM    258  H   THR A  16      55.677  43.477   9.734  1.00  0.00           H  
ATOM    259  HA  THR A  16      55.608  46.269   8.726  1.00  0.00           H  
ATOM    260  HB  THR A  16      54.794  45.225   6.626  1.00  0.00           H  
ATOM    261  HG1 THR A  16      55.565  42.767   7.808  1.00  0.00           H  
ATOM    262 HG21 THR A  16      57.187  45.733   6.941  1.00  0.00           H  
ATOM    263 HG22 THR A  16      57.457  44.113   7.616  1.00  0.00           H  
ATOM    264 HG23 THR A  16      56.942  44.302   5.926  1.00  0.00           H  
ATOM    265  N   GLU A  17      53.199  45.174  10.285  1.00  0.00           N  
ATOM    266  CA  GLU A  17      51.792  45.257  10.645  1.00  0.00           C  
ATOM    267  C   GLU A  17      51.564  45.820  12.058  1.00  0.00           C  
ATOM    268  O   GLU A  17      50.544  46.475  12.272  1.00  0.00           O  
ATOM    269  CB  GLU A  17      51.195  43.851  10.471  1.00  0.00           C  
ATOM    270  CG  GLU A  17      49.673  43.871  10.393  1.00  0.00           C  
ATOM    271  CD  GLU A  17      49.105  42.479  10.063  1.00  0.00           C  
ATOM    272  OE1 GLU A  17      49.333  41.981   8.935  1.00  0.00           O  
ATOM    273  OE2 GLU A  17      48.410  41.884  10.918  1.00  0.00           O  
ATOM    274  H   GLU A  17      53.777  44.576  10.858  1.00  0.00           H  
ATOM    275  HA  GLU A  17      51.286  45.927   9.948  1.00  0.00           H  
ATOM    276  HB2 GLU A  17      51.566  43.430   9.536  1.00  0.00           H  
ATOM    277  HB3 GLU A  17      51.509  43.210  11.296  1.00  0.00           H  
ATOM    278  HG2 GLU A  17      49.284  44.226  11.347  1.00  0.00           H  
ATOM    279  HG3 GLU A  17      49.388  44.578   9.612  1.00  0.00           H  
ATOM    280  N   ILE A  18      52.496  45.629  13.007  1.00  0.00           N  
ATOM    281  CA  ILE A  18      52.253  45.946  14.424  1.00  0.00           C  
ATOM    282  C   ILE A  18      53.255  46.975  14.964  1.00  0.00           C  
ATOM    283  O   ILE A  18      52.862  47.810  15.781  1.00  0.00           O  
ATOM    284  CB  ILE A  18      52.193  44.630  15.248  1.00  0.00           C  
ATOM    285  CG1 ILE A  18      51.019  43.760  14.721  1.00  0.00           C  
ATOM    286  CG2 ILE A  18      52.073  44.881  16.765  1.00  0.00           C  
ATOM    287  CD1 ILE A  18      50.553  42.597  15.609  1.00  0.00           C  
ATOM    288  H   ILE A  18      53.293  45.046  12.798  1.00  0.00           H  
ATOM    289  HA  ILE A  18      51.273  46.416  14.519  1.00  0.00           H  
ATOM    290  HB  ILE A  18      53.125  44.091  15.087  1.00  0.00           H  
ATOM    291 HG12 ILE A  18      50.150  44.398  14.553  1.00  0.00           H  
ATOM    292 HG13 ILE A  18      51.310  43.337  13.759  1.00  0.00           H  
ATOM    293 HG21 ILE A  18      51.132  45.387  16.988  1.00  0.00           H  
ATOM    294 HG22 ILE A  18      52.122  43.937  17.307  1.00  0.00           H  
ATOM    295 HG23 ILE A  18      52.899  45.487  17.130  1.00  0.00           H  
ATOM    296 HD11 ILE A  18      50.047  42.985  16.492  1.00  0.00           H  
ATOM    297 HD12 ILE A  18      49.848  41.980  15.051  1.00  0.00           H  
ATOM    298 HD13 ILE A  18      51.395  41.980  15.915  1.00  0.00           H  
ATOM    299  N   ILE A  19      54.505  46.991  14.485  1.00  0.00           N  
ATOM    300  CA  ILE A  19      55.538  47.923  14.964  1.00  0.00           C  
ATOM    301  C   ILE A  19      56.152  48.734  13.808  1.00  0.00           C  
ATOM    302  O   ILE A  19      57.306  49.154  13.875  1.00  0.00           O  
ATOM    303  CB  ILE A  19      56.570  47.221  15.886  1.00  0.00           C  
ATOM    304  CG1 ILE A  19      57.312  46.026  15.246  1.00  0.00           C  
ATOM    305  CG2 ILE A  19      55.952  46.875  17.256  1.00  0.00           C  
ATOM    306  CD1 ILE A  19      56.676  44.648  15.459  1.00  0.00           C  
ATOM    307  H   ILE A  19      54.787  46.274  13.827  1.00  0.00           H  
ATOM    308  HA  ILE A  19      55.051  48.675  15.587  1.00  0.00           H  
ATOM    309  HB  ILE A  19      57.334  47.965  16.091  1.00  0.00           H  
ATOM    310 HG12 ILE A  19      57.431  46.204  14.178  1.00  0.00           H  
ATOM    311 HG13 ILE A  19      58.309  45.979  15.682  1.00  0.00           H  
ATOM    312 HG21 ILE A  19      56.707  46.434  17.907  1.00  0.00           H  
ATOM    313 HG22 ILE A  19      55.579  47.782  17.730  1.00  0.00           H  
ATOM    314 HG23 ILE A  19      55.126  46.173  17.153  1.00  0.00           H  
ATOM    315 HD11 ILE A  19      57.193  43.916  14.839  1.00  0.00           H  
ATOM    316 HD12 ILE A  19      56.768  44.345  16.501  1.00  0.00           H  
ATOM    317 HD13 ILE A  19      55.624  44.674  15.196  1.00  0.00           H  
ATOM    318  N   VAL A  20      55.370  48.992  12.754  1.00  0.00           N  
ATOM    319  CA  VAL A  20      55.775  49.828  11.617  1.00  0.00           C  
ATOM    320  C   VAL A  20      56.225  51.234  12.046  1.00  0.00           C  
ATOM    321  O   VAL A  20      57.121  51.813  11.430  1.00  0.00           O  
ATOM    322  CB  VAL A  20      54.630  49.927  10.583  1.00  0.00           C  
ATOM    323  CG1 VAL A  20      54.513  48.613   9.812  1.00  0.00           C  
ATOM    324  CG2 VAL A  20      53.252  50.272  11.178  1.00  0.00           C  
ATOM    325  H   VAL A  20      54.433  48.619  12.742  1.00  0.00           H  
ATOM    326  HA  VAL A  20      56.627  49.343  11.135  1.00  0.00           H  
ATOM    327  HB  VAL A  20      54.888  50.706   9.867  1.00  0.00           H  
ATOM    328 HG11 VAL A  20      54.285  47.799  10.498  1.00  0.00           H  
ATOM    329 HG12 VAL A  20      53.727  48.691   9.061  1.00  0.00           H  
ATOM    330 HG13 VAL A  20      55.458  48.410   9.308  1.00  0.00           H  
ATOM    331 HG21 VAL A  20      53.299  51.218  11.716  1.00  0.00           H  
ATOM    332 HG22 VAL A  20      52.527  50.384  10.369  1.00  0.00           H  
ATOM    333 HG23 VAL A  20      52.899  49.488  11.848  1.00  0.00           H  
ATOM    334  N   ASP A  21      55.607  51.784  13.096  1.00  0.00           N  
ATOM    335  CA  ASP A  21      55.763  53.181  13.514  1.00  0.00           C  
ATOM    336  C   ASP A  21      56.810  53.337  14.629  1.00  0.00           C  
ATOM    337  O   ASP A  21      56.952  54.413  15.211  1.00  0.00           O  
ATOM    338  CB  ASP A  21      54.387  53.721  13.939  1.00  0.00           C  
ATOM    339  CG  ASP A  21      54.387  55.243  14.181  1.00  0.00           C  
ATOM    340  OD1 ASP A  21      54.765  56.009  13.265  1.00  0.00           O  
ATOM    341  OD2 ASP A  21      53.937  55.689  15.260  1.00  0.00           O  
ATOM    342  H   ASP A  21      54.892  51.245  13.560  1.00  0.00           H  
ATOM    343  HA  ASP A  21      56.099  53.764  12.656  1.00  0.00           H  
ATOM    344  HB2 ASP A  21      53.663  53.498  13.153  1.00  0.00           H  
ATOM    345  HB3 ASP A  21      54.067  53.198  14.843  1.00  0.00           H  
ATOM    346  N   ALA A  22      57.535  52.261  14.958  1.00  0.00           N  
ATOM    347  CA  ALA A  22      58.419  52.173  16.109  1.00  0.00           C  
ATOM    348  C   ALA A  22      59.750  51.569  15.668  1.00  0.00           C  
ATOM    349  O   ALA A  22      59.772  50.611  14.893  1.00  0.00           O  
ATOM    350  CB  ALA A  22      57.734  51.300  17.165  1.00  0.00           C  
ATOM    351  H   ALA A  22      57.451  51.422  14.395  1.00  0.00           H  
ATOM    352  HA  ALA A  22      58.600  53.164  16.530  1.00  0.00           H  
ATOM    353  HB1 ALA A  22      58.428  51.095  17.975  1.00  0.00           H  
ATOM    354  HB2 ALA A  22      56.860  51.816  17.564  1.00  0.00           H  
ATOM    355  HB3 ALA A  22      57.421  50.356  16.722  1.00  0.00           H  
ATOM    356  N   GLU A  23      60.862  52.088  16.183  1.00  0.00           N  
ATOM    357  CA  GLU A  23      62.210  51.769  15.707  1.00  0.00           C  
ATOM    358  C   GLU A  23      63.178  51.508  16.874  1.00  0.00           C  
ATOM    359  O   GLU A  23      64.357  51.230  16.646  1.00  0.00           O  
ATOM    360  CB  GLU A  23      62.720  52.909  14.803  1.00  0.00           C  
ATOM    361  CG  GLU A  23      61.890  53.084  13.521  1.00  0.00           C  
ATOM    362  CD  GLU A  23      62.513  54.138  12.589  1.00  0.00           C  
ATOM    363  OE1 GLU A  23      62.187  55.341  12.710  1.00  0.00           O  
ATOM    364  OE2 GLU A  23      63.325  53.775  11.706  1.00  0.00           O  
ATOM    365  H   GLU A  23      60.784  52.884  16.822  1.00  0.00           H  
ATOM    366  HA  GLU A  23      62.176  50.856  15.111  1.00  0.00           H  
ATOM    367  HB2 GLU A  23      62.717  53.844  15.365  1.00  0.00           H  
ATOM    368  HB3 GLU A  23      63.748  52.691  14.510  1.00  0.00           H  
ATOM    369  HG2 GLU A  23      61.832  52.124  13.002  1.00  0.00           H  
ATOM    370  HG3 GLU A  23      60.874  53.387  13.780  1.00  0.00           H  
ATOM    371  N   ASP A  24      62.695  51.555  18.119  1.00  0.00           N  
ATOM    372  CA  ASP A  24      63.473  51.291  19.329  1.00  0.00           C  
ATOM    373  C   ASP A  24      62.642  50.416  20.263  1.00  0.00           C  
ATOM    374  O   ASP A  24      61.411  50.489  20.241  1.00  0.00           O  
ATOM    375  CB  ASP A  24      63.838  52.616  20.013  1.00  0.00           C  
ATOM    376  CG  ASP A  24      64.576  52.366  21.337  1.00  0.00           C  
ATOM    377  OD1 ASP A  24      65.822  52.250  21.318  1.00  0.00           O  
ATOM    378  OD2 ASP A  24      63.903  52.257  22.383  1.00  0.00           O  
ATOM    379  H   ASP A  24      61.727  51.807  18.259  1.00  0.00           H  
ATOM    380  HA  ASP A  24      64.393  50.764  19.079  1.00  0.00           H  
ATOM    381  HB2 ASP A  24      64.467  53.205  19.343  1.00  0.00           H  
ATOM    382  HB3 ASP A  24      62.928  53.187  20.207  1.00  0.00           H  
ATOM    383  N   LYS A  25      63.296  49.582  21.077  1.00  0.00           N  
ATOM    384  CA  LYS A  25      62.629  48.626  21.961  1.00  0.00           C  
ATOM    385  C   LYS A  25      61.570  49.271  22.858  1.00  0.00           C  
ATOM    386  O   LYS A  25      60.550  48.633  23.107  1.00  0.00           O  
ATOM    387  CB  LYS A  25      63.669  47.845  22.786  1.00  0.00           C  
ATOM    388  CG  LYS A  25      64.428  48.734  23.787  1.00  0.00           C  
ATOM    389  CD  LYS A  25      65.526  47.975  24.535  1.00  0.00           C  
ATOM    390  CE  LYS A  25      66.184  48.962  25.509  1.00  0.00           C  
ATOM    391  NZ  LYS A  25      67.272  48.336  26.300  1.00  0.00           N  
ATOM    392  H   LYS A  25      64.306  49.595  21.082  1.00  0.00           H  
ATOM    393  HA  LYS A  25      62.111  47.912  21.322  1.00  0.00           H  
ATOM    394  HB2 LYS A  25      63.156  47.054  23.337  1.00  0.00           H  
ATOM    395  HB3 LYS A  25      64.381  47.375  22.106  1.00  0.00           H  
ATOM    396  HG2 LYS A  25      64.884  49.571  23.257  1.00  0.00           H  
ATOM    397  HG3 LYS A  25      63.726  49.124  24.524  1.00  0.00           H  
ATOM    398  HD2 LYS A  25      65.087  47.141  25.086  1.00  0.00           H  
ATOM    399  HD3 LYS A  25      66.264  47.600  23.825  1.00  0.00           H  
ATOM    400  HE2 LYS A  25      66.578  49.804  24.935  1.00  0.00           H  
ATOM    401  HE3 LYS A  25      65.414  49.353  26.179  1.00  0.00           H  
ATOM    402  HZ1 LYS A  25      66.927  47.569  26.857  1.00  0.00           H  
ATOM    403  HZ2 LYS A  25      68.007  47.988  25.702  1.00  0.00           H  
ATOM    404  HZ3 LYS A  25      67.687  49.008  26.930  1.00  0.00           H  
ATOM    405  N   GLU A  26      61.767  50.506  23.333  1.00  0.00           N  
ATOM    406  CA  GLU A  26      60.785  51.170  24.187  1.00  0.00           C  
ATOM    407  C   GLU A  26      59.512  51.450  23.384  1.00  0.00           C  
ATOM    408  O   GLU A  26      58.402  51.164  23.835  1.00  0.00           O  
ATOM    409  CB  GLU A  26      61.373  52.476  24.751  1.00  0.00           C  
ATOM    410  CG  GLU A  26      62.479  52.214  25.784  1.00  0.00           C  
ATOM    411  CD  GLU A  26      62.969  53.522  26.433  1.00  0.00           C  
ATOM    412  OE1 GLU A  26      62.398  53.944  27.465  1.00  0.00           O  
ATOM    413  OE2 GLU A  26      63.945  54.133  25.942  1.00  0.00           O  
ATOM    414  H   GLU A  26      62.605  51.031  23.079  1.00  0.00           H  
ATOM    415  HA  GLU A  26      60.526  50.508  25.016  1.00  0.00           H  
ATOM    416  HB2 GLU A  26      61.764  53.087  23.939  1.00  0.00           H  
ATOM    417  HB3 GLU A  26      60.574  53.040  25.232  1.00  0.00           H  
ATOM    418  HG2 GLU A  26      62.093  51.547  26.558  1.00  0.00           H  
ATOM    419  HG3 GLU A  26      63.318  51.705  25.302  1.00  0.00           H  
ATOM    420  N   GLU A  27      59.668  51.956  22.159  1.00  0.00           N  
ATOM    421  CA  GLU A  27      58.554  52.256  21.269  1.00  0.00           C  
ATOM    422  C   GLU A  27      57.847  50.955  20.878  1.00  0.00           C  
ATOM    423  O   GLU A  27      56.619  50.886  20.843  1.00  0.00           O  
ATOM    424  CB  GLU A  27      59.063  52.972  20.008  1.00  0.00           C  
ATOM    425  CG  GLU A  27      59.876  54.245  20.283  1.00  0.00           C  
ATOM    426  CD  GLU A  27      60.299  54.944  18.978  1.00  0.00           C  
ATOM    427  OE1 GLU A  27      60.701  54.254  18.012  1.00  0.00           O  
ATOM    428  OE2 GLU A  27      60.241  56.195  18.918  1.00  0.00           O  
ATOM    429  H   GLU A  27      60.606  52.073  21.796  1.00  0.00           H  
ATOM    430  HA  GLU A  27      57.845  52.902  21.788  1.00  0.00           H  
ATOM    431  HB2 GLU A  27      59.689  52.284  19.443  1.00  0.00           H  
ATOM    432  HB3 GLU A  27      58.202  53.239  19.393  1.00  0.00           H  
ATOM    433  HG2 GLU A  27      59.270  54.921  20.888  1.00  0.00           H  
ATOM    434  HG3 GLU A  27      60.771  53.986  20.853  1.00  0.00           H  
ATOM    435  N   ARG A  28      58.615  49.896  20.607  1.00  0.00           N  
ATOM    436  CA  ARG A  28      58.062  48.611  20.189  1.00  0.00           C  
ATOM    437  C   ARG A  28      57.356  47.901  21.338  1.00  0.00           C  
ATOM    438  O   ARG A  28      56.380  47.197  21.078  1.00  0.00           O  
ATOM    439  CB  ARG A  28      59.155  47.744  19.544  1.00  0.00           C  
ATOM    440  CG  ARG A  28      59.605  48.391  18.226  1.00  0.00           C  
ATOM    441  CD  ARG A  28      60.499  47.514  17.354  1.00  0.00           C  
ATOM    442  NE  ARG A  28      60.529  48.075  15.992  1.00  0.00           N  
ATOM    443  CZ  ARG A  28      60.633  47.400  14.846  1.00  0.00           C  
ATOM    444  NH1 ARG A  28      60.993  46.124  14.834  1.00  0.00           N  
ATOM    445  NH2 ARG A  28      60.346  48.030  13.719  1.00  0.00           N  
ATOM    446  H   ARG A  28      59.626  50.007  20.648  1.00  0.00           H  
ATOM    447  HA  ARG A  28      57.293  48.808  19.439  1.00  0.00           H  
ATOM    448  HB2 ARG A  28      60.002  47.622  20.220  1.00  0.00           H  
ATOM    449  HB3 ARG A  28      58.727  46.767  19.324  1.00  0.00           H  
ATOM    450  HG2 ARG A  28      58.709  48.622  17.658  1.00  0.00           H  
ATOM    451  HG3 ARG A  28      60.125  49.328  18.421  1.00  0.00           H  
ATOM    452  HD2 ARG A  28      61.506  47.476  17.772  1.00  0.00           H  
ATOM    453  HD3 ARG A  28      60.081  46.509  17.325  1.00  0.00           H  
ATOM    454  HE  ARG A  28      60.297  49.062  15.912  1.00  0.00           H  
ATOM    455 HH11 ARG A  28      61.228  45.642  15.687  1.00  0.00           H  
ATOM    456 HH12 ARG A  28      61.012  45.599  13.949  1.00  0.00           H  
ATOM    457 HH21 ARG A  28      59.973  48.979  13.753  1.00  0.00           H  
ATOM    458 HH22 ARG A  28      60.360  47.545  12.813  1.00  0.00           H  
ATOM    459  N   ALA A  29      57.771  48.126  22.588  1.00  0.00           N  
ATOM    460  CA  ALA A  29      57.020  47.662  23.744  1.00  0.00           C  
ATOM    461  C   ALA A  29      55.642  48.323  23.747  1.00  0.00           C  
ATOM    462  O   ALA A  29      54.645  47.647  23.985  1.00  0.00           O  
ATOM    463  CB  ALA A  29      57.775  47.953  25.049  1.00  0.00           C  
ATOM    464  H   ALA A  29      58.553  48.752  22.740  1.00  0.00           H  
ATOM    465  HA  ALA A  29      56.885  46.583  23.656  1.00  0.00           H  
ATOM    466  HB1 ALA A  29      58.762  47.493  25.021  1.00  0.00           H  
ATOM    467  HB2 ALA A  29      57.878  49.025  25.205  1.00  0.00           H  
ATOM    468  HB3 ALA A  29      57.219  47.536  25.889  1.00  0.00           H  
ATOM    469  N   MET A  30      55.557  49.623  23.439  1.00  0.00           N  
ATOM    470  CA  MET A  30      54.273  50.317  23.357  1.00  0.00           C  
ATOM    471  C   MET A  30      53.438  49.839  22.170  1.00  0.00           C  
ATOM    472  O   MET A  30      52.224  49.718  22.314  1.00  0.00           O  
ATOM    473  CB  MET A  30      54.466  51.837  23.347  1.00  0.00           C  
ATOM    474  CG  MET A  30      55.156  52.350  24.619  1.00  0.00           C  
ATOM    475  SD  MET A  30      54.270  52.090  26.188  1.00  0.00           S  
ATOM    476  CE  MET A  30      54.815  50.428  26.687  1.00  0.00           C  
ATOM    477  H   MET A  30      56.401  50.157  23.261  1.00  0.00           H  
ATOM    478  HA  MET A  30      53.694  50.073  24.242  1.00  0.00           H  
ATOM    479  HB2 MET A  30      55.058  52.130  22.480  1.00  0.00           H  
ATOM    480  HB3 MET A  30      53.489  52.316  23.267  1.00  0.00           H  
ATOM    481  HG2 MET A  30      56.148  51.907  24.695  1.00  0.00           H  
ATOM    482  HG3 MET A  30      55.293  53.424  24.495  1.00  0.00           H  
ATOM    483  HE1 MET A  30      55.887  50.329  26.531  1.00  0.00           H  
ATOM    484  HE2 MET A  30      54.592  50.280  27.742  1.00  0.00           H  
ATOM    485  HE3 MET A  30      54.294  49.656  26.126  1.00  0.00           H  
ATOM    486  N   GLY A  31      54.057  49.510  21.032  1.00  0.00           N  
ATOM    487  CA  GLY A  31      53.351  48.925  19.894  1.00  0.00           C  
ATOM    488  C   GLY A  31      52.695  47.596  20.280  1.00  0.00           C  
ATOM    489  O   GLY A  31      51.487  47.422  20.089  1.00  0.00           O  
ATOM    490  H   GLY A  31      55.050  49.704  20.940  1.00  0.00           H  
ATOM    491  HA2 GLY A  31      52.585  49.619  19.550  1.00  0.00           H  
ATOM    492  HA3 GLY A  31      54.058  48.755  19.082  1.00  0.00           H  
ATOM    493  N   TRP A  32      53.472  46.691  20.890  1.00  0.00           N  
ATOM    494  CA  TRP A  32      52.967  45.440  21.440  1.00  0.00           C  
ATOM    495  C   TRP A  32      51.829  45.704  22.429  1.00  0.00           C  
ATOM    496  O   TRP A  32      50.752  45.128  22.289  1.00  0.00           O  
ATOM    497  CB  TRP A  32      54.096  44.662  22.136  1.00  0.00           C  
ATOM    498  CG  TRP A  32      54.791  43.635  21.299  1.00  0.00           C  
ATOM    499  CD1 TRP A  32      55.933  43.807  20.598  1.00  0.00           C  
ATOM    500  CD2 TRP A  32      54.403  42.244  21.091  1.00  0.00           C  
ATOM    501  NE1 TRP A  32      56.286  42.620  19.987  1.00  0.00           N  
ATOM    502  CE2 TRP A  32      55.378  41.620  20.257  1.00  0.00           C  
ATOM    503  CE3 TRP A  32      53.319  41.447  21.522  1.00  0.00           C  
ATOM    504  CZ2 TRP A  32      55.284  40.274  19.878  1.00  0.00           C  
ATOM    505  CZ3 TRP A  32      53.209  40.099  21.132  1.00  0.00           C  
ATOM    506  CH2 TRP A  32      54.191  39.510  20.315  1.00  0.00           C  
ATOM    507  H   TRP A  32      54.463  46.876  20.994  1.00  0.00           H  
ATOM    508  HA  TRP A  32      52.589  44.840  20.613  1.00  0.00           H  
ATOM    509  HB2 TRP A  32      54.830  45.352  22.550  1.00  0.00           H  
ATOM    510  HB3 TRP A  32      53.668  44.121  22.979  1.00  0.00           H  
ATOM    511  HD1 TRP A  32      56.494  44.731  20.543  1.00  0.00           H  
ATOM    512  HE1 TRP A  32      57.121  42.515  19.428  1.00  0.00           H  
ATOM    513  HE3 TRP A  32      52.556  41.884  22.150  1.00  0.00           H  
ATOM    514  HZ2 TRP A  32      56.035  39.833  19.241  1.00  0.00           H  
ATOM    515  HZ3 TRP A  32      52.356  39.514  21.449  1.00  0.00           H  
ATOM    516  HH2 TRP A  32      54.098  38.474  20.017  1.00  0.00           H  
ATOM    517  N   TYR A  33      52.057  46.585  23.407  1.00  0.00           N  
ATOM    518  CA  TYR A  33      51.116  46.866  24.481  1.00  0.00           C  
ATOM    519  C   TYR A  33      49.775  47.330  23.915  1.00  0.00           C  
ATOM    520  O   TYR A  33      48.729  46.806  24.295  1.00  0.00           O  
ATOM    521  CB  TYR A  33      51.717  47.937  25.403  1.00  0.00           C  
ATOM    522  CG  TYR A  33      50.781  48.396  26.499  1.00  0.00           C  
ATOM    523  CD1 TYR A  33      49.794  49.365  26.233  1.00  0.00           C  
ATOM    524  CD2 TYR A  33      50.867  47.820  27.775  1.00  0.00           C  
ATOM    525  CE1 TYR A  33      48.862  49.717  27.221  1.00  0.00           C  
ATOM    526  CE2 TYR A  33      49.985  48.220  28.789  1.00  0.00           C  
ATOM    527  CZ  TYR A  33      48.969  49.163  28.519  1.00  0.00           C  
ATOM    528  OH  TYR A  33      48.107  49.536  29.505  1.00  0.00           O  
ATOM    529  H   TYR A  33      52.959  47.048  23.445  1.00  0.00           H  
ATOM    530  HA  TYR A  33      50.953  45.954  25.057  1.00  0.00           H  
ATOM    531  HB2 TYR A  33      52.629  47.545  25.854  1.00  0.00           H  
ATOM    532  HB3 TYR A  33      51.987  48.808  24.810  1.00  0.00           H  
ATOM    533  HD1 TYR A  33      49.722  49.820  25.257  1.00  0.00           H  
ATOM    534  HD2 TYR A  33      51.604  47.058  27.977  1.00  0.00           H  
ATOM    535  HE1 TYR A  33      48.071  50.406  26.965  1.00  0.00           H  
ATOM    536  HE2 TYR A  33      50.078  47.779  29.768  1.00  0.00           H  
ATOM    537  HH  TYR A  33      48.342  49.133  30.361  1.00  0.00           H  
ATOM    538  N   TYR A  34      49.812  48.308  23.007  1.00  0.00           N  
ATOM    539  CA  TYR A  34      48.643  48.930  22.426  1.00  0.00           C  
ATOM    540  C   TYR A  34      47.745  47.879  21.776  1.00  0.00           C  
ATOM    541  O   TYR A  34      46.569  47.787  22.140  1.00  0.00           O  
ATOM    542  CB  TYR A  34      49.114  49.997  21.428  1.00  0.00           C  
ATOM    543  CG  TYR A  34      48.043  50.462  20.469  1.00  0.00           C  
ATOM    544  CD1 TYR A  34      47.028  51.332  20.906  1.00  0.00           C  
ATOM    545  CD2 TYR A  34      48.044  49.981  19.148  1.00  0.00           C  
ATOM    546  CE1 TYR A  34      46.011  51.728  20.019  1.00  0.00           C  
ATOM    547  CE2 TYR A  34      47.030  50.371  18.256  1.00  0.00           C  
ATOM    548  CZ  TYR A  34      46.008  51.248  18.687  1.00  0.00           C  
ATOM    549  OH  TYR A  34      45.029  51.619  17.813  1.00  0.00           O  
ATOM    550  H   TYR A  34      50.709  48.676  22.721  1.00  0.00           H  
ATOM    551  HA  TYR A  34      48.075  49.419  23.217  1.00  0.00           H  
ATOM    552  HB2 TYR A  34      49.495  50.856  21.983  1.00  0.00           H  
ATOM    553  HB3 TYR A  34      49.942  49.596  20.841  1.00  0.00           H  
ATOM    554  HD1 TYR A  34      47.028  51.689  21.926  1.00  0.00           H  
ATOM    555  HD2 TYR A  34      48.823  49.301  18.826  1.00  0.00           H  
ATOM    556  HE1 TYR A  34      45.235  52.396  20.365  1.00  0.00           H  
ATOM    557  HE2 TYR A  34      47.036  49.994  17.242  1.00  0.00           H  
ATOM    558  HH  TYR A  34      44.373  52.221  18.203  1.00  0.00           H  
ATOM    559  N   TYR A  35      48.277  47.072  20.847  1.00  0.00           N  
ATOM    560  CA  TYR A  35      47.426  46.114  20.150  1.00  0.00           C  
ATOM    561  C   TYR A  35      46.999  44.992  21.102  1.00  0.00           C  
ATOM    562  O   TYR A  35      45.865  44.525  21.006  1.00  0.00           O  
ATOM    563  CB  TYR A  35      48.076  45.582  18.860  1.00  0.00           C  
ATOM    564  CG  TYR A  35      48.725  44.216  18.978  1.00  0.00           C  
ATOM    565  CD1 TYR A  35      50.074  44.111  19.355  1.00  0.00           C  
ATOM    566  CD2 TYR A  35      47.965  43.049  18.758  1.00  0.00           C  
ATOM    567  CE1 TYR A  35      50.672  42.850  19.506  1.00  0.00           C  
ATOM    568  CE2 TYR A  35      48.553  41.782  18.909  1.00  0.00           C  
ATOM    569  CZ  TYR A  35      49.913  41.677  19.281  1.00  0.00           C  
ATOM    570  OH  TYR A  35      50.492  40.453  19.419  1.00  0.00           O  
ATOM    571  H   TYR A  35      49.261  47.134  20.609  1.00  0.00           H  
ATOM    572  HA  TYR A  35      46.525  46.650  19.848  1.00  0.00           H  
ATOM    573  HB2 TYR A  35      47.292  45.508  18.106  1.00  0.00           H  
ATOM    574  HB3 TYR A  35      48.803  46.303  18.485  1.00  0.00           H  
ATOM    575  HD1 TYR A  35      50.650  45.006  19.531  1.00  0.00           H  
ATOM    576  HD2 TYR A  35      46.920  43.120  18.486  1.00  0.00           H  
ATOM    577  HE1 TYR A  35      51.714  42.787  19.786  1.00  0.00           H  
ATOM    578  HE2 TYR A  35      47.957  40.896  18.739  1.00  0.00           H  
ATOM    579  HH  TYR A  35      49.894  39.718  19.224  1.00  0.00           H  
ATOM    580  N   LEU A  36      47.875  44.566  22.022  1.00  0.00           N  
ATOM    581  CA  LEU A  36      47.575  43.484  22.946  1.00  0.00           C  
ATOM    582  C   LEU A  36      46.410  43.885  23.843  1.00  0.00           C  
ATOM    583  O   LEU A  36      45.411  43.173  23.869  1.00  0.00           O  
ATOM    584  CB  LEU A  36      48.823  43.118  23.763  1.00  0.00           C  
ATOM    585  CG  LEU A  36      48.579  42.048  24.847  1.00  0.00           C  
ATOM    586  CD1 LEU A  36      47.994  40.741  24.291  1.00  0.00           C  
ATOM    587  CD2 LEU A  36      49.910  41.743  25.538  1.00  0.00           C  
ATOM    588  H   LEU A  36      48.804  44.972  22.054  1.00  0.00           H  
ATOM    589  HA  LEU A  36      47.277  42.614  22.360  1.00  0.00           H  
ATOM    590  HB2 LEU A  36      49.590  42.758  23.076  1.00  0.00           H  
ATOM    591  HB3 LEU A  36      49.198  44.017  24.253  1.00  0.00           H  
ATOM    592  HG  LEU A  36      47.892  42.443  25.595  1.00  0.00           H  
ATOM    593 HD11 LEU A  36      48.629  40.354  23.494  1.00  0.00           H  
ATOM    594 HD12 LEU A  36      47.928  39.999  25.087  1.00  0.00           H  
ATOM    595 HD13 LEU A  36      46.988  40.912  23.906  1.00  0.00           H  
ATOM    596 HD21 LEU A  36      50.354  42.669  25.901  1.00  0.00           H  
ATOM    597 HD22 LEU A  36      49.739  41.089  26.388  1.00  0.00           H  
ATOM    598 HD23 LEU A  36      50.603  41.265  24.843  1.00  0.00           H  
ATOM    599  N   ASP A  37      46.489  45.027  24.529  1.00  0.00           N  
ATOM    600  CA  ASP A  37      45.428  45.484  25.426  1.00  0.00           C  
ATOM    601  C   ASP A  37      44.115  45.682  24.668  1.00  0.00           C  
ATOM    602  O   ASP A  37      43.054  45.312  25.168  1.00  0.00           O  
ATOM    603  CB  ASP A  37      45.824  46.791  26.116  1.00  0.00           C  
ATOM    604  CG  ASP A  37      44.708  47.245  27.070  1.00  0.00           C  
ATOM    605  OD1 ASP A  37      44.514  46.596  28.123  1.00  0.00           O  
ATOM    606  OD2 ASP A  37      44.044  48.267  26.780  1.00  0.00           O  
ATOM    607  H   ASP A  37      47.320  45.608  24.442  1.00  0.00           H  
ATOM    608  HA  ASP A  37      45.268  44.728  26.195  1.00  0.00           H  
ATOM    609  HB2 ASP A  37      46.747  46.647  26.678  1.00  0.00           H  
ATOM    610  HB3 ASP A  37      46.006  47.559  25.361  1.00  0.00           H  
ATOM    611  N   ASP A  38      44.188  46.203  23.439  1.00  0.00           N  
ATOM    612  CA  ASP A  38      43.029  46.335  22.552  1.00  0.00           C  
ATOM    613  C   ASP A  38      42.427  44.980  22.135  1.00  0.00           C  
ATOM    614  O   ASP A  38      41.235  44.910  21.828  1.00  0.00           O  
ATOM    615  CB  ASP A  38      43.416  47.144  21.307  1.00  0.00           C  
ATOM    616  CG  ASP A  38      42.219  47.338  20.361  1.00  0.00           C  
ATOM    617  OD1 ASP A  38      41.290  48.104  20.705  1.00  0.00           O  
ATOM    618  OD2 ASP A  38      42.221  46.768  19.247  1.00  0.00           O  
ATOM    619  H   ASP A  38      45.087  46.542  23.104  1.00  0.00           H  
ATOM    620  HA  ASP A  38      42.259  46.895  23.085  1.00  0.00           H  
ATOM    621  HB2 ASP A  38      43.789  48.122  21.618  1.00  0.00           H  
ATOM    622  HB3 ASP A  38      44.221  46.630  20.779  1.00  0.00           H  
ATOM    623  N   THR A  39      43.216  43.901  22.145  1.00  0.00           N  
ATOM    624  CA  THR A  39      42.785  42.567  21.725  1.00  0.00           C  
ATOM    625  C   THR A  39      42.289  41.731  22.914  1.00  0.00           C  
ATOM    626  O   THR A  39      41.375  40.925  22.734  1.00  0.00           O  
ATOM    627  CB  THR A  39      43.944  41.862  20.996  1.00  0.00           C  
ATOM    628  OG1 THR A  39      44.361  42.633  19.887  1.00  0.00           O  
ATOM    629  CG2 THR A  39      43.557  40.467  20.488  1.00  0.00           C  
ATOM    630  H   THR A  39      44.166  43.999  22.476  1.00  0.00           H  
ATOM    631  HA  THR A  39      41.957  42.669  21.022  1.00  0.00           H  
ATOM    632  HB  THR A  39      44.790  41.757  21.675  1.00  0.00           H  
ATOM    633  HG1 THR A  39      44.853  43.394  20.255  1.00  0.00           H  
ATOM    634 HG21 THR A  39      42.590  40.501  19.986  1.00  0.00           H  
ATOM    635 HG22 THR A  39      44.312  40.091  19.799  1.00  0.00           H  
ATOM    636 HG23 THR A  39      43.483  39.777  21.330  1.00  0.00           H  
ATOM    637  N   LEU A  40      42.859  41.910  24.113  1.00  0.00           N  
ATOM    638  CA  LEU A  40      42.439  41.191  25.313  1.00  0.00           C  
ATOM    639  C   LEU A  40      40.952  41.478  25.562  1.00  0.00           C  
ATOM    640  O   LEU A  40      40.575  42.633  25.765  1.00  0.00           O  
ATOM    641  CB  LEU A  40      43.258  41.614  26.549  1.00  0.00           C  
ATOM    642  CG  LEU A  40      44.745  41.212  26.567  1.00  0.00           C  
ATOM    643  CD1 LEU A  40      45.421  41.800  27.811  1.00  0.00           C  
ATOM    644  CD2 LEU A  40      44.993  39.709  26.511  1.00  0.00           C  
ATOM    645  H   LEU A  40      43.594  42.603  24.199  1.00  0.00           H  
ATOM    646  HA  LEU A  40      42.587  40.128  25.144  1.00  0.00           H  
ATOM    647  HB2 LEU A  40      43.198  42.698  26.636  1.00  0.00           H  
ATOM    648  HB3 LEU A  40      42.781  41.183  27.431  1.00  0.00           H  
ATOM    649  HG  LEU A  40      45.225  41.624  25.695  1.00  0.00           H  
ATOM    650 HD11 LEU A  40      46.497  41.623  27.767  1.00  0.00           H  
ATOM    651 HD12 LEU A  40      45.245  42.874  27.850  1.00  0.00           H  
ATOM    652 HD13 LEU A  40      45.020  41.343  28.715  1.00  0.00           H  
ATOM    653 HD21 LEU A  40      44.372  39.203  27.251  1.00  0.00           H  
ATOM    654 HD22 LEU A  40      44.774  39.345  25.504  1.00  0.00           H  
ATOM    655 HD23 LEU A  40      46.041  39.495  26.717  1.00  0.00           H  
ATOM    656  N   GLU A  41      40.109  40.447  25.613  1.00  0.00           N  
ATOM    657  CA  GLU A  41      38.688  40.541  25.962  1.00  0.00           C  
ATOM    658  C   GLU A  41      38.543  40.588  27.490  1.00  0.00           C  
ATOM    659  O   GLU A  41      37.819  39.802  28.103  1.00  0.00           O  
ATOM    660  CB  GLU A  41      37.907  39.384  25.312  1.00  0.00           C  
ATOM    661  CG  GLU A  41      37.822  39.549  23.789  1.00  0.00           C  
ATOM    662  CD  GLU A  41      36.765  40.589  23.373  1.00  0.00           C  
ATOM    663  OE1 GLU A  41      35.577  40.224  23.216  1.00  0.00           O  
ATOM    664  OE2 GLU A  41      37.105  41.778  23.180  1.00  0.00           O  
ATOM    665  H   GLU A  41      40.449  39.525  25.348  1.00  0.00           H  
ATOM    666  HA  GLU A  41      38.295  41.482  25.572  1.00  0.00           H  
ATOM    667  HB2 GLU A  41      38.398  38.439  25.550  1.00  0.00           H  
ATOM    668  HB3 GLU A  41      36.891  39.347  25.709  1.00  0.00           H  
ATOM    669  HG2 GLU A  41      38.801  39.843  23.409  1.00  0.00           H  
ATOM    670  HG3 GLU A  41      37.568  38.582  23.352  1.00  0.00           H  
ATOM    671  N   PHE A  42      39.325  41.468  28.112  1.00  0.00           N  
ATOM    672  CA  PHE A  42      39.408  41.614  29.558  1.00  0.00           C  
ATOM    673  C   PHE A  42      38.068  42.088  30.159  1.00  0.00           C  
ATOM    674  O   PHE A  42      37.296  42.759  29.463  1.00  0.00           O  
ATOM    675  CB  PHE A  42      40.586  42.542  29.919  1.00  0.00           C  
ATOM    676  CG  PHE A  42      40.421  44.012  29.566  1.00  0.00           C  
ATOM    677  CD1 PHE A  42      39.668  44.864  30.401  1.00  0.00           C  
ATOM    678  CD2 PHE A  42      41.048  44.548  28.424  1.00  0.00           C  
ATOM    679  CE1 PHE A  42      39.521  46.226  30.082  1.00  0.00           C  
ATOM    680  CE2 PHE A  42      40.902  45.910  28.105  1.00  0.00           C  
ATOM    681  CZ  PHE A  42      40.136  46.749  28.931  1.00  0.00           C  
ATOM    682  H   PHE A  42      39.862  42.091  27.518  1.00  0.00           H  
ATOM    683  HA  PHE A  42      39.629  40.626  29.948  1.00  0.00           H  
ATOM    684  HB2 PHE A  42      40.760  42.472  30.990  1.00  0.00           H  
ATOM    685  HB3 PHE A  42      41.488  42.160  29.440  1.00  0.00           H  
ATOM    686  HD1 PHE A  42      39.200  44.475  31.295  1.00  0.00           H  
ATOM    687  HD2 PHE A  42      41.654  43.922  27.785  1.00  0.00           H  
ATOM    688  HE1 PHE A  42      38.938  46.871  30.725  1.00  0.00           H  
ATOM    689  HE2 PHE A  42      41.388  46.310  27.226  1.00  0.00           H  
ATOM    690  HZ  PHE A  42      40.026  47.798  28.686  1.00  0.00           H  
ATOM    691  N   PRO A  43      37.791  41.816  31.451  1.00  0.00           N  
ATOM    692  CA  PRO A  43      38.547  40.925  32.329  1.00  0.00           C  
ATOM    693  C   PRO A  43      38.375  39.456  31.910  1.00  0.00           C  
ATOM    694  O   PRO A  43      37.369  39.081  31.302  1.00  0.00           O  
ATOM    695  CB  PRO A  43      37.996  41.180  33.736  1.00  0.00           C  
ATOM    696  CG  PRO A  43      36.544  41.580  33.477  1.00  0.00           C  
ATOM    697  CD  PRO A  43      36.624  42.336  32.152  1.00  0.00           C  
ATOM    698  HA  PRO A  43      39.605  41.185  32.320  1.00  0.00           H  
ATOM    699  HB2 PRO A  43      38.068  40.299  34.377  1.00  0.00           H  
ATOM    700  HB3 PRO A  43      38.526  42.019  34.185  1.00  0.00           H  
ATOM    701  HG2 PRO A  43      35.931  40.686  33.355  1.00  0.00           H  
ATOM    702  HG3 PRO A  43      36.149  42.208  34.277  1.00  0.00           H  
ATOM    703  HD2 PRO A  43      35.713  42.179  31.572  1.00  0.00           H  
ATOM    704  HD3 PRO A  43      36.767  43.401  32.340  1.00  0.00           H  
ATOM    705  N   PHE A  44      39.360  38.626  32.250  1.00  0.00           N  
ATOM    706  CA  PHE A  44      39.393  37.193  31.960  1.00  0.00           C  
ATOM    707  C   PHE A  44      40.052  36.473  33.138  1.00  0.00           C  
ATOM    708  O   PHE A  44      40.222  37.080  34.196  1.00  0.00           O  
ATOM    709  CB  PHE A  44      40.083  36.936  30.607  1.00  0.00           C  
ATOM    710  CG  PHE A  44      41.568  37.249  30.491  1.00  0.00           C  
ATOM    711  CD1 PHE A  44      42.010  38.576  30.317  1.00  0.00           C  
ATOM    712  CD2 PHE A  44      42.511  36.203  30.465  1.00  0.00           C  
ATOM    713  CE1 PHE A  44      43.375  38.853  30.123  1.00  0.00           C  
ATOM    714  CE2 PHE A  44      43.878  36.480  30.289  1.00  0.00           C  
ATOM    715  CZ  PHE A  44      44.311  37.805  30.109  1.00  0.00           C  
ATOM    716  H   PHE A  44      40.128  38.989  32.815  1.00  0.00           H  
ATOM    717  HA  PHE A  44      38.375  36.810  31.886  1.00  0.00           H  
ATOM    718  HB2 PHE A  44      39.934  35.884  30.362  1.00  0.00           H  
ATOM    719  HB3 PHE A  44      39.555  37.508  29.843  1.00  0.00           H  
ATOM    720  HD1 PHE A  44      41.304  39.388  30.320  1.00  0.00           H  
ATOM    721  HD2 PHE A  44      42.187  35.178  30.558  1.00  0.00           H  
ATOM    722  HE1 PHE A  44      43.704  39.873  29.984  1.00  0.00           H  
ATOM    723  HE2 PHE A  44      44.594  35.672  30.280  1.00  0.00           H  
ATOM    724  HZ  PHE A  44      45.361  38.017  29.960  1.00  0.00           H  
ATOM    725  N   MET A  45      40.416  35.197  33.006  1.00  0.00           N  
ATOM    726  CA  MET A  45      41.114  34.477  34.067  1.00  0.00           C  
ATOM    727  C   MET A  45      42.297  33.679  33.531  1.00  0.00           C  
ATOM    728  O   MET A  45      42.440  33.456  32.327  1.00  0.00           O  
ATOM    729  CB  MET A  45      40.131  33.612  34.875  1.00  0.00           C  
ATOM    730  CG  MET A  45      39.705  32.301  34.194  1.00  0.00           C  
ATOM    731  SD  MET A  45      39.360  30.936  35.340  1.00  0.00           S  
ATOM    732  CE  MET A  45      41.031  30.606  35.984  1.00  0.00           C  
ATOM    733  H   MET A  45      40.257  34.713  32.136  1.00  0.00           H  
ATOM    734  HA  MET A  45      41.534  35.204  34.760  1.00  0.00           H  
ATOM    735  HB2 MET A  45      40.609  33.374  35.822  1.00  0.00           H  
ATOM    736  HB3 MET A  45      39.241  34.199  35.102  1.00  0.00           H  
ATOM    737  HG2 MET A  45      38.815  32.496  33.593  1.00  0.00           H  
ATOM    738  HG3 MET A  45      40.482  31.956  33.516  1.00  0.00           H  
ATOM    739  HE1 MET A  45      41.376  31.434  36.604  1.00  0.00           H  
ATOM    740  HE2 MET A  45      41.010  29.699  36.586  1.00  0.00           H  
ATOM    741  HE3 MET A  45      41.732  30.468  35.165  1.00  0.00           H  
ATOM    742  N   GLY A  46      43.136  33.220  34.448  1.00  0.00           N  
ATOM    743  CA  GLY A  46      44.308  32.445  34.123  1.00  0.00           C  
ATOM    744  C   GLY A  46      44.870  31.753  35.345  1.00  0.00           C  
ATOM    745  O   GLY A  46      44.347  31.859  36.457  1.00  0.00           O  
ATOM    746  H   GLY A  46      42.991  33.504  35.428  1.00  0.00           H  
ATOM    747  HA2 GLY A  46      44.058  31.692  33.376  1.00  0.00           H  
ATOM    748  HA3 GLY A  46      45.075  33.106  33.714  1.00  0.00           H  
ATOM    749  N   LYS A  47      45.972  31.053  35.117  1.00  0.00           N  
ATOM    750  CA  LYS A  47      46.801  30.482  36.162  1.00  0.00           C  
ATOM    751  C   LYS A  47      48.151  31.178  36.074  1.00  0.00           C  
ATOM    752  O   LYS A  47      48.783  31.164  35.019  1.00  0.00           O  
ATOM    753  CB  LYS A  47      46.907  28.963  35.951  1.00  0.00           C  
ATOM    754  CG  LYS A  47      47.410  28.230  37.203  1.00  0.00           C  
ATOM    755  CD  LYS A  47      46.299  28.011  38.243  1.00  0.00           C  
ATOM    756  CE  LYS A  47      45.322  26.893  37.845  1.00  0.00           C  
ATOM    757  NZ  LYS A  47      44.409  26.533  38.960  1.00  0.00           N  
ATOM    758  H   LYS A  47      46.292  30.971  34.154  1.00  0.00           H  
ATOM    759  HA  LYS A  47      46.351  30.692  37.131  1.00  0.00           H  
ATOM    760  HB2 LYS A  47      45.932  28.562  35.681  1.00  0.00           H  
ATOM    761  HB3 LYS A  47      47.584  28.764  35.121  1.00  0.00           H  
ATOM    762  HG2 LYS A  47      47.816  27.264  36.906  1.00  0.00           H  
ATOM    763  HG3 LYS A  47      48.212  28.810  37.659  1.00  0.00           H  
ATOM    764  HD2 LYS A  47      46.757  27.758  39.199  1.00  0.00           H  
ATOM    765  HD3 LYS A  47      45.743  28.936  38.367  1.00  0.00           H  
ATOM    766  HE2 LYS A  47      44.736  27.224  36.985  1.00  0.00           H  
ATOM    767  HE3 LYS A  47      45.892  26.008  37.547  1.00  0.00           H  
ATOM    768  HZ1 LYS A  47      43.690  25.895  38.649  1.00  0.00           H  
ATOM    769  HZ2 LYS A  47      44.910  26.081  39.711  1.00  0.00           H  
ATOM    770  HZ3 LYS A  47      43.957  27.354  39.355  1.00  0.00           H  
ATOM    771  N   TRP A  48      48.584  31.807  37.160  1.00  0.00           N  
ATOM    772  CA  TRP A  48      49.935  32.323  37.292  1.00  0.00           C  
ATOM    773  C   TRP A  48      50.810  31.109  37.587  1.00  0.00           C  
ATOM    774  O   TRP A  48      50.731  30.533  38.672  1.00  0.00           O  
ATOM    775  CB  TRP A  48      49.982  33.399  38.391  1.00  0.00           C  
ATOM    776  CG  TRP A  48      51.250  34.191  38.547  1.00  0.00           C  
ATOM    777  CD1 TRP A  48      52.445  33.937  37.968  1.00  0.00           C  
ATOM    778  CD2 TRP A  48      51.467  35.398  39.346  1.00  0.00           C  
ATOM    779  NE1 TRP A  48      53.362  34.896  38.322  1.00  0.00           N  
ATOM    780  CE2 TRP A  48      52.811  35.840  39.152  1.00  0.00           C  
ATOM    781  CE3 TRP A  48      50.666  36.166  40.220  1.00  0.00           C  
ATOM    782  CZ2 TRP A  48      53.325  36.992  39.762  1.00  0.00           C  
ATOM    783  CZ3 TRP A  48      51.170  37.325  40.843  1.00  0.00           C  
ATOM    784  CH2 TRP A  48      52.493  37.742  40.606  1.00  0.00           C  
ATOM    785  H   TRP A  48      48.003  31.789  37.993  1.00  0.00           H  
ATOM    786  HA  TRP A  48      50.250  32.772  36.351  1.00  0.00           H  
ATOM    787  HB2 TRP A  48      49.186  34.115  38.190  1.00  0.00           H  
ATOM    788  HB3 TRP A  48      49.759  32.932  39.347  1.00  0.00           H  
ATOM    789  HD1 TRP A  48      52.671  33.110  37.313  1.00  0.00           H  
ATOM    790  HE1 TRP A  48      54.328  34.876  37.987  1.00  0.00           H  
ATOM    791  HE3 TRP A  48      49.647  35.860  40.409  1.00  0.00           H  
ATOM    792  HZ2 TRP A  48      54.347  37.299  39.592  1.00  0.00           H  
ATOM    793  HZ3 TRP A  48      50.533  37.907  41.495  1.00  0.00           H  
ATOM    794  HH2 TRP A  48      52.877  38.638  41.069  1.00  0.00           H  
ATOM    795  N   LYS A  49      51.596  30.687  36.595  1.00  0.00           N  
ATOM    796  CA  LYS A  49      52.485  29.522  36.636  1.00  0.00           C  
ATOM    797  C   LYS A  49      53.809  29.935  37.306  1.00  0.00           C  
ATOM    798  O   LYS A  49      54.888  29.702  36.760  1.00  0.00           O  
ATOM    799  CB  LYS A  49      52.717  29.017  35.190  1.00  0.00           C  
ATOM    800  CG  LYS A  49      51.464  28.862  34.309  1.00  0.00           C  
ATOM    801  CD  LYS A  49      50.494  27.748  34.721  1.00  0.00           C  
ATOM    802  CE  LYS A  49      51.033  26.370  34.315  1.00  0.00           C  
ATOM    803  NZ  LYS A  49      49.948  25.372  34.180  1.00  0.00           N  
ATOM    804  H   LYS A  49      51.597  31.205  35.730  1.00  0.00           H  
ATOM    805  HA  LYS A  49      52.016  28.741  37.239  1.00  0.00           H  
ATOM    806  HB2 LYS A  49      53.364  29.733  34.681  1.00  0.00           H  
ATOM    807  HB3 LYS A  49      53.250  28.066  35.230  1.00  0.00           H  
ATOM    808  HG2 LYS A  49      50.919  29.805  34.287  1.00  0.00           H  
ATOM    809  HG3 LYS A  49      51.789  28.675  33.285  1.00  0.00           H  
ATOM    810  HD2 LYS A  49      50.296  27.784  35.792  1.00  0.00           H  
ATOM    811  HD3 LYS A  49      49.558  27.924  34.194  1.00  0.00           H  
ATOM    812  HE2 LYS A  49      51.535  26.463  33.350  1.00  0.00           H  
ATOM    813  HE3 LYS A  49      51.764  26.033  35.054  1.00  0.00           H  
ATOM    814  HZ1 LYS A  49      49.235  25.706  33.528  1.00  0.00           H  
ATOM    815  HZ2 LYS A  49      50.306  24.499  33.823  1.00  0.00           H  
ATOM    816  HZ3 LYS A  49      49.519  25.175  35.086  1.00  0.00           H  
ATOM    817  N   LYS A  50      53.722  30.617  38.452  1.00  0.00           N  
ATOM    818  CA  LYS A  50      54.839  31.291  39.110  1.00  0.00           C  
ATOM    819  C   LYS A  50      56.016  30.340  39.299  1.00  0.00           C  
ATOM    820  O   LYS A  50      55.889  29.349  40.012  1.00  0.00           O  
ATOM    821  CB  LYS A  50      54.346  31.885  40.439  1.00  0.00           C  
ATOM    822  CG  LYS A  50      55.462  32.645  41.176  1.00  0.00           C  
ATOM    823  CD  LYS A  50      54.957  33.409  42.410  1.00  0.00           C  
ATOM    824  CE  LYS A  50      54.036  34.578  42.025  1.00  0.00           C  
ATOM    825  NZ  LYS A  50      53.619  35.385  43.198  1.00  0.00           N  
ATOM    826  H   LYS A  50      52.841  30.549  38.954  1.00  0.00           H  
ATOM    827  HA  LYS A  50      55.154  32.110  38.460  1.00  0.00           H  
ATOM    828  HB2 LYS A  50      53.520  32.563  40.227  1.00  0.00           H  
ATOM    829  HB3 LYS A  50      53.976  31.085  41.083  1.00  0.00           H  
ATOM    830  HG2 LYS A  50      56.214  31.926  41.508  1.00  0.00           H  
ATOM    831  HG3 LYS A  50      55.937  33.345  40.488  1.00  0.00           H  
ATOM    832  HD2 LYS A  50      54.427  32.719  43.069  1.00  0.00           H  
ATOM    833  HD3 LYS A  50      55.824  33.801  42.947  1.00  0.00           H  
ATOM    834  HE2 LYS A  50      54.566  35.220  41.317  1.00  0.00           H  
ATOM    835  HE3 LYS A  50      53.149  34.186  41.522  1.00  0.00           H  
ATOM    836  HZ1 LYS A  50      53.003  36.135  42.912  1.00  0.00           H  
ATOM    837  HZ2 LYS A  50      53.126  34.822  43.877  1.00  0.00           H  
ATOM    838  HZ3 LYS A  50      54.415  35.805  43.658  1.00  0.00           H  
ATOM    839  N   LYS A  51      57.175  30.648  38.711  1.00  0.00           N  
ATOM    840  CA  LYS A  51      58.386  29.834  38.879  1.00  0.00           C  
ATOM    841  C   LYS A  51      59.228  30.306  40.070  1.00  0.00           C  
ATOM    842  O   LYS A  51      60.132  29.595  40.499  1.00  0.00           O  
ATOM    843  CB  LYS A  51      59.187  29.831  37.562  1.00  0.00           C  
ATOM    844  CG  LYS A  51      60.158  28.642  37.482  1.00  0.00           C  
ATOM    845  CD  LYS A  51      60.826  28.541  36.106  1.00  0.00           C  
ATOM    846  CE  LYS A  51      61.767  27.328  36.085  1.00  0.00           C  
ATOM    847  NZ  LYS A  51      62.452  27.168  34.778  1.00  0.00           N  
ATOM    848  H   LYS A  51      57.217  31.463  38.113  1.00  0.00           H  
ATOM    849  HA  LYS A  51      58.080  28.808  39.089  1.00  0.00           H  
ATOM    850  HB2 LYS A  51      58.489  29.755  36.726  1.00  0.00           H  
ATOM    851  HB3 LYS A  51      59.739  30.767  37.463  1.00  0.00           H  
ATOM    852  HG2 LYS A  51      60.936  28.755  38.235  1.00  0.00           H  
ATOM    853  HG3 LYS A  51      59.609  27.718  37.675  1.00  0.00           H  
ATOM    854  HD2 LYS A  51      60.060  28.425  35.338  1.00  0.00           H  
ATOM    855  HD3 LYS A  51      61.394  29.453  35.913  1.00  0.00           H  
ATOM    856  HE2 LYS A  51      62.512  27.447  36.876  1.00  0.00           H  
ATOM    857  HE3 LYS A  51      61.187  26.429  36.307  1.00  0.00           H  
ATOM    858  HZ1 LYS A  51      61.789  27.031  34.030  1.00  0.00           H  
ATOM    859  HZ2 LYS A  51      63.016  27.975  34.557  1.00  0.00           H  
ATOM    860  HZ3 LYS A  51      63.064  26.364  34.792  1.00  0.00           H  
ATOM    861  N   SER A  52      58.935  31.484  40.622  1.00  0.00           N  
ATOM    862  CA  SER A  52      59.726  32.209  41.618  1.00  0.00           C  
ATOM    863  C   SER A  52      59.845  31.540  43.005  1.00  0.00           C  
ATOM    864  O   SER A  52      60.271  32.193  43.962  1.00  0.00           O  
ATOM    865  CB  SER A  52      59.118  33.616  41.747  1.00  0.00           C  
ATOM    866  OG  SER A  52      58.711  34.121  40.479  1.00  0.00           O  
ATOM    867  H   SER A  52      58.218  32.049  40.190  1.00  0.00           H  
ATOM    868  HA  SER A  52      60.736  32.308  41.219  1.00  0.00           H  
ATOM    869  HB2 SER A  52      58.248  33.570  42.401  1.00  0.00           H  
ATOM    870  HB3 SER A  52      59.855  34.287  42.193  1.00  0.00           H  
ATOM    871  HG  SER A  52      58.444  35.049  40.600  1.00  0.00           H  
ATOM    872  N   ARG A  53      59.448  30.271  43.159  1.00  0.00           N  
ATOM    873  CA  ARG A  53      59.624  29.511  44.397  1.00  0.00           C  
ATOM    874  C   ARG A  53      61.117  29.403  44.721  1.00  0.00           C  
ATOM    875  O   ARG A  53      61.946  29.401  43.809  1.00  0.00           O  
ATOM    876  CB  ARG A  53      58.981  28.126  44.202  1.00  0.00           C  
ATOM    877  CG  ARG A  53      58.794  27.336  45.504  1.00  0.00           C  
ATOM    878  CD  ARG A  53      58.112  26.000  45.200  1.00  0.00           C  
ATOM    879  NE  ARG A  53      58.298  25.045  46.299  1.00  0.00           N  
ATOM    880  CZ  ARG A  53      57.474  24.825  47.331  1.00  0.00           C  
ATOM    881  NH1 ARG A  53      56.340  25.509  47.470  1.00  0.00           N  
ATOM    882  NH2 ARG A  53      57.799  23.906  48.236  1.00  0.00           N  
ATOM    883  H   ARG A  53      59.213  29.749  42.324  1.00  0.00           H  
ATOM    884  HA  ARG A  53      59.111  30.044  45.200  1.00  0.00           H  
ATOM    885  HB2 ARG A  53      58.001  28.256  43.743  1.00  0.00           H  
ATOM    886  HB3 ARG A  53      59.604  27.538  43.524  1.00  0.00           H  
ATOM    887  HG2 ARG A  53      59.768  27.137  45.949  1.00  0.00           H  
ATOM    888  HG3 ARG A  53      58.188  27.905  46.209  1.00  0.00           H  
ATOM    889  HD2 ARG A  53      57.058  26.150  44.984  1.00  0.00           H  
ATOM    890  HD3 ARG A  53      58.573  25.576  44.313  1.00  0.00           H  
ATOM    891  HE  ARG A  53      59.173  24.529  46.241  1.00  0.00           H  
ATOM    892 HH11 ARG A  53      56.059  26.236  46.799  1.00  0.00           H  
ATOM    893 HH12 ARG A  53      55.711  25.349  48.243  1.00  0.00           H  
ATOM    894 HH21 ARG A  53      58.651  23.369  48.153  1.00  0.00           H  
ATOM    895 HH22 ARG A  53      57.210  23.706  49.032  1.00  0.00           H  
ATOM    896  N   LYS A  54      61.470  29.222  45.999  1.00  0.00           N  
ATOM    897  CA  LYS A  54      62.858  29.001  46.426  1.00  0.00           C  
ATOM    898  C   LYS A  54      63.503  27.830  45.674  1.00  0.00           C  
ATOM    899  O   LYS A  54      64.680  27.903  45.323  1.00  0.00           O  
ATOM    900  CB  LYS A  54      62.886  28.790  47.952  1.00  0.00           C  
ATOM    901  CG  LYS A  54      64.313  28.705  48.519  1.00  0.00           C  
ATOM    902  CD  LYS A  54      64.289  28.579  50.050  1.00  0.00           C  
ATOM    903  CE  LYS A  54      65.693  28.408  50.652  1.00  0.00           C  
ATOM    904  NZ  LYS A  54      66.539  29.620  50.516  1.00  0.00           N  
ATOM    905  H   LYS A  54      60.756  29.251  46.713  1.00  0.00           H  
ATOM    906  HA  LYS A  54      63.426  29.903  46.190  1.00  0.00           H  
ATOM    907  HB2 LYS A  54      62.376  29.628  48.430  1.00  0.00           H  
ATOM    908  HB3 LYS A  54      62.348  27.872  48.200  1.00  0.00           H  
ATOM    909  HG2 LYS A  54      64.820  27.833  48.104  1.00  0.00           H  
ATOM    910  HG3 LYS A  54      64.861  29.604  48.234  1.00  0.00           H  
ATOM    911  HD2 LYS A  54      63.806  29.456  50.487  1.00  0.00           H  
ATOM    912  HD3 LYS A  54      63.698  27.701  50.318  1.00  0.00           H  
ATOM    913  HE2 LYS A  54      65.584  28.169  51.713  1.00  0.00           H  
ATOM    914  HE3 LYS A  54      66.184  27.559  50.170  1.00  0.00           H  
ATOM    915  HZ1 LYS A  54      66.704  29.852  49.548  1.00  0.00           H  
ATOM    916  HZ2 LYS A  54      66.115  30.417  50.967  1.00  0.00           H  
ATOM    917  HZ3 LYS A  54      67.439  29.473  50.949  1.00  0.00           H  
ATOM    918  N   THR A  55      62.741  26.769  45.399  1.00  0.00           N  
ATOM    919  CA  THR A  55      63.211  25.567  44.714  1.00  0.00           C  
ATOM    920  C   THR A  55      63.213  25.725  43.179  1.00  0.00           C  
ATOM    921  O   THR A  55      63.566  24.782  42.469  1.00  0.00           O  
ATOM    922  CB  THR A  55      62.313  24.402  45.167  1.00  0.00           C  
ATOM    923  OG1 THR A  55      60.956  24.748  44.991  1.00  0.00           O  
ATOM    924  CG2 THR A  55      62.486  24.089  46.656  1.00  0.00           C  
ATOM    925  H   THR A  55      61.785  26.732  45.721  1.00  0.00           H  
ATOM    926  HA  THR A  55      64.236  25.358  45.026  1.00  0.00           H  
ATOM    927  HB  THR A  55      62.546  23.508  44.590  1.00  0.00           H  
ATOM    928  HG1 THR A  55      60.623  24.178  44.265  1.00  0.00           H  
ATOM    929 HG21 THR A  55      62.154  24.931  47.264  1.00  0.00           H  
ATOM    930 HG22 THR A  55      61.891  23.212  46.909  1.00  0.00           H  
ATOM    931 HG23 THR A  55      63.535  23.877  46.869  1.00  0.00           H  
ATOM    932  N   SER A  56      62.796  26.886  42.656  1.00  0.00           N  
ATOM    933  CA  SER A  56      62.554  27.163  41.238  1.00  0.00           C  
ATOM    934  C   SER A  56      61.488  26.250  40.599  1.00  0.00           C  
ATOM    935  O   SER A  56      61.365  26.213  39.373  1.00  0.00           O  
ATOM    936  CB  SER A  56      63.880  27.185  40.457  1.00  0.00           C  
ATOM    937  OG  SER A  56      64.852  27.994  41.109  1.00  0.00           O  
ATOM    938  H   SER A  56      62.593  27.656  43.280  1.00  0.00           H  
ATOM    939  HA  SER A  56      62.148  28.173  41.196  1.00  0.00           H  
ATOM    940  HB2 SER A  56      64.262  26.169  40.357  1.00  0.00           H  
ATOM    941  HB3 SER A  56      63.694  27.581  39.457  1.00  0.00           H  
ATOM    942  HG  SER A  56      65.666  27.971  40.577  1.00  0.00           H  
ATOM    943  N   THR A  57      60.715  25.509  41.398  1.00  0.00           N  
ATOM    944  CA  THR A  57      59.582  24.727  40.921  1.00  0.00           C  
ATOM    945  C   THR A  57      58.454  25.685  40.521  1.00  0.00           C  
ATOM    946  O   THR A  57      58.277  26.744  41.131  1.00  0.00           O  
ATOM    947  CB  THR A  57      59.116  23.754  42.024  1.00  0.00           C  
ATOM    948  OG1 THR A  57      60.208  23.318  42.821  1.00  0.00           O  
ATOM    949  CG2 THR A  57      58.396  22.522  41.472  1.00  0.00           C  
ATOM    950  H   THR A  57      60.858  25.529  42.396  1.00  0.00           H  
ATOM    951  HA  THR A  57      59.888  24.156  40.044  1.00  0.00           H  
ATOM    952  HB  THR A  57      58.424  24.280  42.677  1.00  0.00           H  
ATOM    953  HG1 THR A  57      60.827  22.837  42.249  1.00  0.00           H  
ATOM    954 HG21 THR A  57      58.124  21.860  42.295  1.00  0.00           H  
ATOM    955 HG22 THR A  57      57.482  22.824  40.959  1.00  0.00           H  
ATOM    956 HG23 THR A  57      59.040  21.985  40.775  1.00  0.00           H  
ATOM    957  N   ILE A  58      57.677  25.301  39.508  1.00  0.00           N  
ATOM    958  CA  ILE A  58      56.444  25.987  39.151  1.00  0.00           C  
ATOM    959  C   ILE A  58      55.459  25.845  40.321  1.00  0.00           C  
ATOM    960  O   ILE A  58      55.361  24.787  40.950  1.00  0.00           O  
ATOM    961  CB  ILE A  58      55.898  25.386  37.831  1.00  0.00           C  
ATOM    962  CG1 ILE A  58      56.856  25.612  36.635  1.00  0.00           C  
ATOM    963  CG2 ILE A  58      54.485  25.888  37.479  1.00  0.00           C  
ATOM    964  CD1 ILE A  58      56.946  27.058  36.128  1.00  0.00           C  
ATOM    965  H   ILE A  58      57.874  24.430  39.034  1.00  0.00           H  
ATOM    966  HA  ILE A  58      56.657  27.042  38.998  1.00  0.00           H  
ATOM    967  HB  ILE A  58      55.830  24.308  37.983  1.00  0.00           H  
ATOM    968 HG12 ILE A  58      57.861  25.284  36.902  1.00  0.00           H  
ATOM    969 HG13 ILE A  58      56.527  24.986  35.805  1.00  0.00           H  
ATOM    970 HG21 ILE A  58      53.762  25.520  38.206  1.00  0.00           H  
ATOM    971 HG22 ILE A  58      54.457  26.979  37.477  1.00  0.00           H  
ATOM    972 HG23 ILE A  58      54.192  25.518  36.495  1.00  0.00           H  
ATOM    973 HD11 ILE A  58      57.178  27.733  36.948  1.00  0.00           H  
ATOM    974 HD12 ILE A  58      57.735  27.127  35.378  1.00  0.00           H  
ATOM    975 HD13 ILE A  58      56.005  27.354  35.667  1.00  0.00           H  
ATOM    976  N   GLU A  59      54.695  26.904  40.563  1.00  0.00           N  
ATOM    977  CA  GLU A  59      53.553  26.973  41.454  1.00  0.00           C  
ATOM    978  C   GLU A  59      52.418  27.548  40.607  1.00  0.00           C  
ATOM    979  O   GLU A  59      52.660  28.283  39.645  1.00  0.00           O  
ATOM    980  CB  GLU A  59      53.840  27.876  42.665  1.00  0.00           C  
ATOM    981  CG  GLU A  59      55.000  27.372  43.535  1.00  0.00           C  
ATOM    982  CD  GLU A  59      55.128  28.153  44.855  1.00  0.00           C  
ATOM    983  OE1 GLU A  59      55.184  29.404  44.843  1.00  0.00           O  
ATOM    984  OE2 GLU A  59      55.198  27.503  45.922  1.00  0.00           O  
ATOM    985  H   GLU A  59      54.871  27.754  40.034  1.00  0.00           H  
ATOM    986  HA  GLU A  59      53.286  25.972  41.799  1.00  0.00           H  
ATOM    987  HB2 GLU A  59      54.065  28.886  42.318  1.00  0.00           H  
ATOM    988  HB3 GLU A  59      52.940  27.918  43.281  1.00  0.00           H  
ATOM    989  HG2 GLU A  59      54.834  26.315  43.758  1.00  0.00           H  
ATOM    990  HG3 GLU A  59      55.934  27.454  42.977  1.00  0.00           H  
ATOM    991  N   GLU A  60      51.174  27.223  40.954  1.00  0.00           N  
ATOM    992  CA  GLU A  60      50.019  27.511  40.119  1.00  0.00           C  
ATOM    993  C   GLU A  60      48.977  28.231  40.972  1.00  0.00           C  
ATOM    994  O   GLU A  60      48.338  27.618  41.831  1.00  0.00           O  
ATOM    995  CB  GLU A  60      49.493  26.194  39.520  1.00  0.00           C  
ATOM    996  CG  GLU A  60      50.475  25.572  38.518  1.00  0.00           C  
ATOM    997  CD  GLU A  60      49.835  24.386  37.782  1.00  0.00           C  
ATOM    998  OE1 GLU A  60      49.214  24.609  36.719  1.00  0.00           O  
ATOM    999  OE2 GLU A  60      49.961  23.230  38.248  1.00  0.00           O  
ATOM   1000  H   GLU A  60      51.012  26.665  41.780  1.00  0.00           H  
ATOM   1001  HA  GLU A  60      50.301  28.161  39.289  1.00  0.00           H  
ATOM   1002  HB2 GLU A  60      49.296  25.476  40.318  1.00  0.00           H  
ATOM   1003  HB3 GLU A  60      48.557  26.390  39.005  1.00  0.00           H  
ATOM   1004  HG2 GLU A  60      50.772  26.331  37.790  1.00  0.00           H  
ATOM   1005  HG3 GLU A  60      51.374  25.242  39.044  1.00  0.00           H  
ATOM   1006  N   LYS A  61      48.817  29.539  40.746  1.00  0.00           N  
ATOM   1007  CA  LYS A  61      47.870  30.385  41.477  1.00  0.00           C  
ATOM   1008  C   LYS A  61      46.774  30.810  40.512  1.00  0.00           C  
ATOM   1009  O   LYS A  61      47.071  31.422  39.487  1.00  0.00           O  
ATOM   1010  CB  LYS A  61      48.624  31.589  42.067  1.00  0.00           C  
ATOM   1011  CG  LYS A  61      47.704  32.583  42.790  1.00  0.00           C  
ATOM   1012  CD  LYS A  61      48.498  33.721  43.456  1.00  0.00           C  
ATOM   1013  CE  LYS A  61      49.107  33.338  44.815  1.00  0.00           C  
ATOM   1014  NZ  LYS A  61      48.079  33.020  45.839  1.00  0.00           N  
ATOM   1015  H   LYS A  61      49.412  29.994  40.053  1.00  0.00           H  
ATOM   1016  HA  LYS A  61      47.428  29.821  42.301  1.00  0.00           H  
ATOM   1017  HB2 LYS A  61      49.381  31.222  42.763  1.00  0.00           H  
ATOM   1018  HB3 LYS A  61      49.123  32.126  41.261  1.00  0.00           H  
ATOM   1019  HG2 LYS A  61      47.025  33.027  42.065  1.00  0.00           H  
ATOM   1020  HG3 LYS A  61      47.104  32.052  43.530  1.00  0.00           H  
ATOM   1021  HD2 LYS A  61      49.297  34.041  42.786  1.00  0.00           H  
ATOM   1022  HD3 LYS A  61      47.843  34.581  43.593  1.00  0.00           H  
ATOM   1023  HE2 LYS A  61      49.770  32.481  44.679  1.00  0.00           H  
ATOM   1024  HE3 LYS A  61      49.711  34.177  45.167  1.00  0.00           H  
ATOM   1025  HZ1 LYS A  61      48.505  32.792  46.725  1.00  0.00           H  
ATOM   1026  HZ2 LYS A  61      47.443  33.807  45.988  1.00  0.00           H  
ATOM   1027  HZ3 LYS A  61      47.505  32.244  45.548  1.00  0.00           H  
ATOM   1028  N   THR A  62      45.523  30.468  40.794  1.00  0.00           N  
ATOM   1029  CA  THR A  62      44.396  30.888  39.973  1.00  0.00           C  
ATOM   1030  C   THR A  62      44.197  32.398  40.148  1.00  0.00           C  
ATOM   1031  O   THR A  62      44.171  32.894  41.278  1.00  0.00           O  
ATOM   1032  CB  THR A  62      43.155  30.074  40.376  1.00  0.00           C  
ATOM   1033  OG1 THR A  62      43.517  28.716  40.577  1.00  0.00           O  
ATOM   1034  CG2 THR A  62      42.093  30.095  39.280  1.00  0.00           C  
ATOM   1035  H   THR A  62      45.313  29.901  41.602  1.00  0.00           H  
ATOM   1036  HA  THR A  62      44.632  30.684  38.928  1.00  0.00           H  
ATOM   1037  HB  THR A  62      42.741  30.476  41.301  1.00  0.00           H  
ATOM   1038  HG1 THR A  62      42.940  28.356  41.274  1.00  0.00           H  
ATOM   1039 HG21 THR A  62      42.491  29.638  38.374  1.00  0.00           H  
ATOM   1040 HG22 THR A  62      41.213  29.541  39.610  1.00  0.00           H  
ATOM   1041 HG23 THR A  62      41.802  31.120  39.066  1.00  0.00           H  
ATOM   1042  N   VAL A  63      44.052  33.124  39.041  1.00  0.00           N  
ATOM   1043  CA  VAL A  63      43.967  34.577  39.047  1.00  0.00           C  
ATOM   1044  C   VAL A  63      42.904  35.061  38.062  1.00  0.00           C  
ATOM   1045  O   VAL A  63      42.693  34.458  37.010  1.00  0.00           O  
ATOM   1046  CB  VAL A  63      45.348  35.208  38.742  1.00  0.00           C  
ATOM   1047  CG1 VAL A  63      46.350  35.018  39.892  1.00  0.00           C  
ATOM   1048  CG2 VAL A  63      46.004  34.693  37.447  1.00  0.00           C  
ATOM   1049  H   VAL A  63      44.130  32.650  38.138  1.00  0.00           H  
ATOM   1050  HA  VAL A  63      43.658  34.901  40.042  1.00  0.00           H  
ATOM   1051  HB  VAL A  63      45.190  36.279  38.627  1.00  0.00           H  
ATOM   1052 HG11 VAL A  63      45.901  35.336  40.832  1.00  0.00           H  
ATOM   1053 HG12 VAL A  63      46.652  33.974  39.974  1.00  0.00           H  
ATOM   1054 HG13 VAL A  63      47.238  35.622  39.709  1.00  0.00           H  
ATOM   1055 HG21 VAL A  63      46.923  35.247  37.256  1.00  0.00           H  
ATOM   1056 HG22 VAL A  63      46.246  33.634  37.536  1.00  0.00           H  
ATOM   1057 HG23 VAL A  63      45.333  34.838  36.601  1.00  0.00           H  
ATOM   1058  N   GLU A  64      42.239  36.164  38.404  1.00  0.00           N  
ATOM   1059  CA  GLU A  64      41.368  36.884  37.486  1.00  0.00           C  
ATOM   1060  C   GLU A  64      42.262  37.988  36.932  1.00  0.00           C  
ATOM   1061  O   GLU A  64      42.900  38.696  37.710  1.00  0.00           O  
ATOM   1062  CB  GLU A  64      40.151  37.454  38.230  1.00  0.00           C  
ATOM   1063  CG  GLU A  64      39.208  38.228  37.299  1.00  0.00           C  
ATOM   1064  CD  GLU A  64      37.964  38.736  38.049  1.00  0.00           C  
ATOM   1065  OE1 GLU A  64      37.988  39.867  38.586  1.00  0.00           O  
ATOM   1066  OE2 GLU A  64      36.938  38.019  38.090  1.00  0.00           O  
ATOM   1067  H   GLU A  64      42.493  36.644  39.262  1.00  0.00           H  
ATOM   1068  HA  GLU A  64      41.022  36.229  36.686  1.00  0.00           H  
ATOM   1069  HB2 GLU A  64      39.594  36.630  38.671  1.00  0.00           H  
ATOM   1070  HB3 GLU A  64      40.486  38.112  39.030  1.00  0.00           H  
ATOM   1071  HG2 GLU A  64      39.741  39.074  36.859  1.00  0.00           H  
ATOM   1072  HG3 GLU A  64      38.896  37.569  36.487  1.00  0.00           H  
ATOM   1073  N   VAL A  65      42.358  38.102  35.614  1.00  0.00           N  
ATOM   1074  CA  VAL A  65      43.237  39.035  34.931  1.00  0.00           C  
ATOM   1075  C   VAL A  65      42.365  40.224  34.531  1.00  0.00           C  
ATOM   1076  O   VAL A  65      41.451  40.094  33.713  1.00  0.00           O  
ATOM   1077  CB  VAL A  65      43.939  38.347  33.741  1.00  0.00           C  
ATOM   1078  CG1 VAL A  65      45.073  39.246  33.232  1.00  0.00           C  
ATOM   1079  CG2 VAL A  65      44.542  36.975  34.105  1.00  0.00           C  
ATOM   1080  H   VAL A  65      41.768  37.512  35.035  1.00  0.00           H  
ATOM   1081  HA  VAL A  65      44.001  39.375  35.629  1.00  0.00           H  
ATOM   1082  HB  VAL A  65      43.217  38.189  32.942  1.00  0.00           H  
ATOM   1083 HG11 VAL A  65      45.780  39.441  34.039  1.00  0.00           H  
ATOM   1084 HG12 VAL A  65      45.600  38.762  32.411  1.00  0.00           H  
ATOM   1085 HG13 VAL A  65      44.668  40.193  32.873  1.00  0.00           H  
ATOM   1086 HG21 VAL A  65      45.072  36.566  33.243  1.00  0.00           H  
ATOM   1087 HG22 VAL A  65      45.238  37.069  34.937  1.00  0.00           H  
ATOM   1088 HG23 VAL A  65      43.757  36.271  34.374  1.00  0.00           H  
ATOM   1089  N   LEU A  66      42.602  41.370  35.170  1.00  0.00           N  
ATOM   1090  CA  LEU A  66      41.747  42.549  35.059  1.00  0.00           C  
ATOM   1091  C   LEU A  66      41.942  43.244  33.710  1.00  0.00           C  
ATOM   1092  O   LEU A  66      41.010  43.876  33.216  1.00  0.00           O  
ATOM   1093  CB  LEU A  66      42.059  43.555  36.184  1.00  0.00           C  
ATOM   1094  CG  LEU A  66      41.418  43.240  37.549  1.00  0.00           C  
ATOM   1095  CD1 LEU A  66      41.951  41.955  38.193  1.00  0.00           C  
ATOM   1096  CD2 LEU A  66      41.681  44.410  38.503  1.00  0.00           C  
ATOM   1097  H   LEU A  66      43.413  41.429  35.782  1.00  0.00           H  
ATOM   1098  HA  LEU A  66      40.704  42.241  35.138  1.00  0.00           H  
ATOM   1099  HB2 LEU A  66      43.139  43.652  36.294  1.00  0.00           H  
ATOM   1100  HB3 LEU A  66      41.678  44.528  35.870  1.00  0.00           H  
ATOM   1101  HG  LEU A  66      40.340  43.141  37.420  1.00  0.00           H  
ATOM   1102 HD11 LEU A  66      41.639  41.089  37.611  1.00  0.00           H  
ATOM   1103 HD12 LEU A  66      43.038  41.985  38.254  1.00  0.00           H  
ATOM   1104 HD13 LEU A  66      41.535  41.845  39.193  1.00  0.00           H  
ATOM   1105 HD21 LEU A  66      41.237  44.209  39.478  1.00  0.00           H  
ATOM   1106 HD22 LEU A  66      42.753  44.565  38.617  1.00  0.00           H  
ATOM   1107 HD23 LEU A  66      41.234  45.321  38.102  1.00  0.00           H  
ATOM   1108  N   GLY A  67      43.142  43.156  33.136  1.00  0.00           N  
ATOM   1109  CA  GLY A  67      43.565  43.874  31.952  1.00  0.00           C  
ATOM   1110  C   GLY A  67      45.081  44.020  32.028  1.00  0.00           C  
ATOM   1111  O   GLY A  67      45.720  43.537  32.972  1.00  0.00           O  
ATOM   1112  H   GLY A  67      43.884  42.656  33.607  1.00  0.00           H  
ATOM   1113  HA2 GLY A  67      43.291  43.314  31.058  1.00  0.00           H  
ATOM   1114  HA3 GLY A  67      43.102  44.861  31.920  1.00  0.00           H  
ATOM   1115  N   MET A  68      45.669  44.688  31.041  1.00  0.00           N  
ATOM   1116  CA  MET A  68      47.074  45.072  31.119  1.00  0.00           C  
ATOM   1117  C   MET A  68      47.294  46.051  32.274  1.00  0.00           C  
ATOM   1118  O   MET A  68      46.400  46.818  32.643  1.00  0.00           O  
ATOM   1119  CB  MET A  68      47.584  45.656  29.799  1.00  0.00           C  
ATOM   1120  CG  MET A  68      47.616  44.591  28.695  1.00  0.00           C  
ATOM   1121  SD  MET A  68      48.932  44.797  27.468  1.00  0.00           S  
ATOM   1122  CE  MET A  68      50.369  44.395  28.501  1.00  0.00           C  
ATOM   1123  H   MET A  68      45.093  45.094  30.321  1.00  0.00           H  
ATOM   1124  HA  MET A  68      47.660  44.182  31.329  1.00  0.00           H  
ATOM   1125  HB2 MET A  68      46.973  46.504  29.489  1.00  0.00           H  
ATOM   1126  HB3 MET A  68      48.594  46.016  29.973  1.00  0.00           H  
ATOM   1127  HG2 MET A  68      47.743  43.606  29.147  1.00  0.00           H  
ATOM   1128  HG3 MET A  68      46.657  44.603  28.182  1.00  0.00           H  
ATOM   1129  HE1 MET A  68      51.267  44.432  27.891  1.00  0.00           H  
ATOM   1130  HE2 MET A  68      50.471  45.116  29.311  1.00  0.00           H  
ATOM   1131  HE3 MET A  68      50.254  43.396  28.922  1.00  0.00           H  
ATOM   1132  N   ALA A  69      48.506  46.017  32.830  1.00  0.00           N  
ATOM   1133  CA  ALA A  69      48.979  46.992  33.802  1.00  0.00           C  
ATOM   1134  C   ALA A  69      49.139  48.371  33.130  1.00  0.00           C  
ATOM   1135  O   ALA A  69      49.022  48.463  31.901  1.00  0.00           O  
ATOM   1136  CB  ALA A  69      50.304  46.469  34.374  1.00  0.00           C  
ATOM   1137  H   ALA A  69      49.201  45.395  32.430  1.00  0.00           H  
ATOM   1138  HA  ALA A  69      48.249  47.075  34.602  1.00  0.00           H  
ATOM   1139  HB1 ALA A  69      51.075  46.531  33.608  1.00  0.00           H  
ATOM   1140  HB2 ALA A  69      50.615  47.056  35.233  1.00  0.00           H  
ATOM   1141  HB3 ALA A  69      50.185  45.435  34.694  1.00  0.00           H  
ATOM   1142  N   PRO A  70      49.406  49.451  33.889  1.00  0.00           N  
ATOM   1143  CA  PRO A  70      49.781  50.736  33.316  1.00  0.00           C  
ATOM   1144  C   PRO A  70      50.905  50.586  32.286  1.00  0.00           C  
ATOM   1145  O   PRO A  70      51.889  49.872  32.514  1.00  0.00           O  
ATOM   1146  CB  PRO A  70      50.199  51.615  34.499  1.00  0.00           C  
ATOM   1147  CG  PRO A  70      49.381  51.041  35.653  1.00  0.00           C  
ATOM   1148  CD  PRO A  70      49.366  49.546  35.340  1.00  0.00           C  
ATOM   1149  HA  PRO A  70      48.896  51.168  32.844  1.00  0.00           H  
ATOM   1150  HB2 PRO A  70      51.263  51.484  34.711  1.00  0.00           H  
ATOM   1151  HB3 PRO A  70      49.971  52.667  34.323  1.00  0.00           H  
ATOM   1152  HG2 PRO A  70      49.839  51.248  36.621  1.00  0.00           H  
ATOM   1153  HG3 PRO A  70      48.364  51.435  35.615  1.00  0.00           H  
ATOM   1154  HD2 PRO A  70      50.260  49.091  35.763  1.00  0.00           H  
ATOM   1155  HD3 PRO A  70      48.468  49.080  35.749  1.00  0.00           H  
ATOM   1156  N   ASP A  71      50.773  51.297  31.168  1.00  0.00           N  
ATOM   1157  CA  ASP A  71      51.746  51.282  30.078  1.00  0.00           C  
ATOM   1158  C   ASP A  71      53.140  51.690  30.559  1.00  0.00           C  
ATOM   1159  O   ASP A  71      54.129  51.174  30.049  1.00  0.00           O  
ATOM   1160  CB  ASP A  71      51.290  52.179  28.917  1.00  0.00           C  
ATOM   1161  CG  ASP A  71      51.504  53.679  29.195  1.00  0.00           C  
ATOM   1162  OD1 ASP A  71      50.734  54.256  29.997  1.00  0.00           O  
ATOM   1163  OD2 ASP A  71      52.407  54.299  28.595  1.00  0.00           O  
ATOM   1164  H   ASP A  71      49.952  51.872  31.044  1.00  0.00           H  
ATOM   1165  HA  ASP A  71      51.799  50.259  29.703  1.00  0.00           H  
ATOM   1166  HB2 ASP A  71      51.855  51.894  28.028  1.00  0.00           H  
ATOM   1167  HB3 ASP A  71      50.237  51.989  28.704  1.00  0.00           H  
ATOM   1168  N   ASP A  72      53.223  52.543  31.587  1.00  0.00           N  
ATOM   1169  CA  ASP A  72      54.479  53.010  32.174  1.00  0.00           C  
ATOM   1170  C   ASP A  72      55.328  51.868  32.749  1.00  0.00           C  
ATOM   1171  O   ASP A  72      56.556  51.958  32.756  1.00  0.00           O  
ATOM   1172  CB  ASP A  72      54.177  54.031  33.276  1.00  0.00           C  
ATOM   1173  CG  ASP A  72      55.466  54.544  33.940  1.00  0.00           C  
ATOM   1174  OD1 ASP A  72      56.209  55.328  33.306  1.00  0.00           O  
ATOM   1175  OD2 ASP A  72      55.721  54.207  35.119  1.00  0.00           O  
ATOM   1176  H   ASP A  72      52.365  52.917  31.963  1.00  0.00           H  
ATOM   1177  HA  ASP A  72      55.059  53.508  31.396  1.00  0.00           H  
ATOM   1178  HB2 ASP A  72      53.632  54.873  32.843  1.00  0.00           H  
ATOM   1179  HB3 ASP A  72      53.534  53.566  34.027  1.00  0.00           H  
ATOM   1180  N   GLU A  73      54.700  50.778  33.204  1.00  0.00           N  
ATOM   1181  CA  GLU A  73      55.421  49.599  33.683  1.00  0.00           C  
ATOM   1182  C   GLU A  73      55.772  48.670  32.516  1.00  0.00           C  
ATOM   1183  O   GLU A  73      56.771  47.945  32.574  1.00  0.00           O  
ATOM   1184  CB  GLU A  73      54.586  48.850  34.735  1.00  0.00           C  
ATOM   1185  CG  GLU A  73      54.402  49.687  36.012  1.00  0.00           C  
ATOM   1186  CD  GLU A  73      53.767  48.874  37.153  1.00  0.00           C  
ATOM   1187  OE1 GLU A  73      54.472  48.053  37.784  1.00  0.00           O  
ATOM   1188  OE2 GLU A  73      52.572  49.081  37.462  1.00  0.00           O  
ATOM   1189  H   GLU A  73      53.689  50.714  33.120  1.00  0.00           H  
ATOM   1190  HA  GLU A  73      56.354  49.915  34.152  1.00  0.00           H  
ATOM   1191  HB2 GLU A  73      53.609  48.588  34.325  1.00  0.00           H  
ATOM   1192  HB3 GLU A  73      55.108  47.928  34.995  1.00  0.00           H  
ATOM   1193  HG2 GLU A  73      55.377  50.055  36.338  1.00  0.00           H  
ATOM   1194  HG3 GLU A  73      53.777  50.555  35.785  1.00  0.00           H  
ATOM   1195  N   CYS A  74      54.986  48.712  31.437  1.00  0.00           N  
ATOM   1196  CA  CYS A  74      55.043  47.766  30.331  1.00  0.00           C  
ATOM   1197  C   CYS A  74      56.035  48.182  29.236  1.00  0.00           C  
ATOM   1198  O   CYS A  74      55.924  47.740  28.095  1.00  0.00           O  
ATOM   1199  CB  CYS A  74      53.638  47.556  29.758  1.00  0.00           C  
ATOM   1200  SG  CYS A  74      52.496  46.987  31.050  1.00  0.00           S  
ATOM   1201  H   CYS A  74      54.273  49.431  31.394  1.00  0.00           H  
ATOM   1202  HA  CYS A  74      55.392  46.821  30.736  1.00  0.00           H  
ATOM   1203  HB2 CYS A  74      53.277  48.485  29.317  1.00  0.00           H  
ATOM   1204  HB3 CYS A  74      53.699  46.795  28.978  1.00  0.00           H  
ATOM   1205  HG  CYS A  74      52.415  48.150  31.720  1.00  0.00           H  
ATOM   1206  N   LEU A  75      57.017  49.023  29.571  1.00  0.00           N  
ATOM   1207  CA  LEU A  75      58.096  49.447  28.676  1.00  0.00           C  
ATOM   1208  C   LEU A  75      59.086  48.306  28.390  1.00  0.00           C  
ATOM   1209  O   LEU A  75      59.982  48.470  27.561  1.00  0.00           O  
ATOM   1210  CB  LEU A  75      58.846  50.656  29.289  1.00  0.00           C  
ATOM   1211  CG  LEU A  75      58.442  52.048  28.763  1.00  0.00           C  
ATOM   1212  CD1 LEU A  75      58.674  52.184  27.254  1.00  0.00           C  
ATOM   1213  CD2 LEU A  75      56.996  52.413  29.096  1.00  0.00           C  
ATOM   1214  H   LEU A  75      57.079  49.289  30.539  1.00  0.00           H  
ATOM   1215  HA  LEU A  75      57.657  49.730  27.722  1.00  0.00           H  
ATOM   1216  HB2 LEU A  75      58.742  50.644  30.376  1.00  0.00           H  
ATOM   1217  HB3 LEU A  75      59.914  50.550  29.093  1.00  0.00           H  
ATOM   1218  HG  LEU A  75      59.081  52.777  29.260  1.00  0.00           H  
ATOM   1219 HD11 LEU A  75      57.948  51.606  26.684  1.00  0.00           H  
ATOM   1220 HD12 LEU A  75      58.590  53.231  26.964  1.00  0.00           H  
ATOM   1221 HD13 LEU A  75      59.676  51.832  27.016  1.00  0.00           H  
ATOM   1222 HD21 LEU A  75      56.310  51.726  28.610  1.00  0.00           H  
ATOM   1223 HD22 LEU A  75      56.847  52.357  30.172  1.00  0.00           H  
ATOM   1224 HD23 LEU A  75      56.781  53.428  28.763  1.00  0.00           H  
ATOM   1225  N   LYS A  76      58.948  47.170  29.083  1.00  0.00           N  
ATOM   1226  CA  LYS A  76      59.924  46.082  29.088  1.00  0.00           C  
ATOM   1227  C   LYS A  76      59.273  44.704  29.011  1.00  0.00           C  
ATOM   1228  O   LYS A  76      59.892  43.791  28.470  1.00  0.00           O  
ATOM   1229  CB  LYS A  76      60.810  46.219  30.344  1.00  0.00           C  
ATOM   1230  CG  LYS A  76      60.021  46.181  31.670  1.00  0.00           C  
ATOM   1231  CD  LYS A  76      60.906  46.544  32.870  1.00  0.00           C  
ATOM   1232  CE  LYS A  76      60.111  46.573  34.186  1.00  0.00           C  
ATOM   1233  NZ  LYS A  76      59.127  47.688  34.259  1.00  0.00           N  
ATOM   1234  H   LYS A  76      58.193  47.109  29.745  1.00  0.00           H  
ATOM   1235  HA  LYS A  76      60.568  46.182  28.212  1.00  0.00           H  
ATOM   1236  HB2 LYS A  76      61.550  45.415  30.347  1.00  0.00           H  
ATOM   1237  HB3 LYS A  76      61.347  47.165  30.279  1.00  0.00           H  
ATOM   1238  HG2 LYS A  76      59.199  46.893  31.626  1.00  0.00           H  
ATOM   1239  HG3 LYS A  76      59.612  45.181  31.820  1.00  0.00           H  
ATOM   1240  HD2 LYS A  76      61.696  45.794  32.960  1.00  0.00           H  
ATOM   1241  HD3 LYS A  76      61.376  47.514  32.707  1.00  0.00           H  
ATOM   1242  HE2 LYS A  76      59.600  45.616  34.311  1.00  0.00           H  
ATOM   1243  HE3 LYS A  76      60.822  46.675  35.010  1.00  0.00           H  
ATOM   1244  HZ1 LYS A  76      59.586  48.582  34.163  1.00  0.00           H  
ATOM   1245  HZ2 LYS A  76      58.404  47.618  33.547  1.00  0.00           H  
ATOM   1246  HZ3 LYS A  76      58.666  47.684  35.159  1.00  0.00           H  
ATOM   1247  N   ASP A  77      58.050  44.531  29.515  1.00  0.00           N  
ATOM   1248  CA  ASP A  77      57.360  43.240  29.552  1.00  0.00           C  
ATOM   1249  C   ASP A  77      55.860  43.522  29.564  1.00  0.00           C  
ATOM   1250  O   ASP A  77      55.440  44.573  30.055  1.00  0.00           O  
ATOM   1251  CB  ASP A  77      57.769  42.461  30.812  1.00  0.00           C  
ATOM   1252  CG  ASP A  77      57.031  41.118  30.935  1.00  0.00           C  
ATOM   1253  OD1 ASP A  77      57.553  40.104  30.418  1.00  0.00           O  
ATOM   1254  OD2 ASP A  77      55.947  41.074  31.553  1.00  0.00           O  
ATOM   1255  H   ASP A  77      57.548  45.312  29.931  1.00  0.00           H  
ATOM   1256  HA  ASP A  77      57.614  42.649  28.671  1.00  0.00           H  
ATOM   1257  HB2 ASP A  77      58.845  42.280  30.783  1.00  0.00           H  
ATOM   1258  HB3 ASP A  77      57.564  43.070  31.693  1.00  0.00           H  
ATOM   1259  N   MET A  78      55.051  42.630  28.996  1.00  0.00           N  
ATOM   1260  CA  MET A  78      53.601  42.779  28.975  1.00  0.00           C  
ATOM   1261  C   MET A  78      53.028  42.416  30.355  1.00  0.00           C  
ATOM   1262  O   MET A  78      52.611  41.281  30.582  1.00  0.00           O  
ATOM   1263  CB  MET A  78      53.008  41.922  27.843  1.00  0.00           C  
ATOM   1264  CG  MET A  78      53.482  42.324  26.437  1.00  0.00           C  
ATOM   1265  SD  MET A  78      53.060  44.002  25.871  1.00  0.00           S  
ATOM   1266  CE  MET A  78      54.574  44.919  26.275  1.00  0.00           C  
ATOM   1267  H   MET A  78      55.441  41.788  28.592  1.00  0.00           H  
ATOM   1268  HA  MET A  78      53.357  43.823  28.775  1.00  0.00           H  
ATOM   1269  HB2 MET A  78      53.275  40.877  28.008  1.00  0.00           H  
ATOM   1270  HB3 MET A  78      51.921  41.994  27.876  1.00  0.00           H  
ATOM   1271  HG2 MET A  78      54.561  42.192  26.368  1.00  0.00           H  
ATOM   1272  HG3 MET A  78      53.030  41.624  25.735  1.00  0.00           H  
ATOM   1273  HE1 MET A  78      54.480  45.946  25.920  1.00  0.00           H  
ATOM   1274  HE2 MET A  78      54.733  44.934  27.352  1.00  0.00           H  
ATOM   1275  HE3 MET A  78      55.430  44.450  25.787  1.00  0.00           H  
ATOM   1276  N   TYR A  79      53.016  43.361  31.299  1.00  0.00           N  
ATOM   1277  CA  TYR A  79      52.446  43.138  32.626  1.00  0.00           C  
ATOM   1278  C   TYR A  79      50.917  43.226  32.586  1.00  0.00           C  
ATOM   1279  O   TYR A  79      50.340  43.963  31.779  1.00  0.00           O  
ATOM   1280  CB  TYR A  79      52.987  44.170  33.621  1.00  0.00           C  
ATOM   1281  CG  TYR A  79      54.448  44.015  33.981  1.00  0.00           C  
ATOM   1282  CD1 TYR A  79      54.836  43.090  34.970  1.00  0.00           C  
ATOM   1283  CD2 TYR A  79      55.416  44.819  33.353  1.00  0.00           C  
ATOM   1284  CE1 TYR A  79      56.188  42.970  35.333  1.00  0.00           C  
ATOM   1285  CE2 TYR A  79      56.770  44.697  33.703  1.00  0.00           C  
ATOM   1286  CZ  TYR A  79      57.165  43.768  34.692  1.00  0.00           C  
ATOM   1287  OH  TYR A  79      58.484  43.658  35.019  1.00  0.00           O  
ATOM   1288  H   TYR A  79      53.390  44.275  31.092  1.00  0.00           H  
ATOM   1289  HA  TYR A  79      52.735  42.145  32.970  1.00  0.00           H  
ATOM   1290  HB2 TYR A  79      52.826  45.169  33.223  1.00  0.00           H  
ATOM   1291  HB3 TYR A  79      52.409  44.096  34.541  1.00  0.00           H  
ATOM   1292  HD1 TYR A  79      54.094  42.474  35.456  1.00  0.00           H  
ATOM   1293  HD2 TYR A  79      55.123  45.531  32.595  1.00  0.00           H  
ATOM   1294  HE1 TYR A  79      56.472  42.264  36.101  1.00  0.00           H  
ATOM   1295  HE2 TYR A  79      57.503  45.304  33.200  1.00  0.00           H  
ATOM   1296  HH  TYR A  79      58.657  42.999  35.708  1.00  0.00           H  
ATOM   1297  N   VAL A  80      50.257  42.538  33.518  1.00  0.00           N  
ATOM   1298  CA  VAL A  80      48.806  42.496  33.652  1.00  0.00           C  
ATOM   1299  C   VAL A  80      48.443  42.651  35.129  1.00  0.00           C  
ATOM   1300  O   VAL A  80      49.173  42.176  36.002  1.00  0.00           O  
ATOM   1301  CB  VAL A  80      48.236  41.193  33.042  1.00  0.00           C  
ATOM   1302  CG1 VAL A  80      48.261  41.220  31.506  1.00  0.00           C  
ATOM   1303  CG2 VAL A  80      48.951  39.913  33.512  1.00  0.00           C  
ATOM   1304  H   VAL A  80      50.781  41.899  34.117  1.00  0.00           H  
ATOM   1305  HA  VAL A  80      48.368  43.336  33.123  1.00  0.00           H  
ATOM   1306  HB  VAL A  80      47.193  41.124  33.344  1.00  0.00           H  
ATOM   1307 HG11 VAL A  80      47.846  40.292  31.114  1.00  0.00           H  
ATOM   1308 HG12 VAL A  80      47.642  42.038  31.143  1.00  0.00           H  
ATOM   1309 HG13 VAL A  80      49.279  41.344  31.138  1.00  0.00           H  
ATOM   1310 HG21 VAL A  80      48.964  39.870  34.601  1.00  0.00           H  
ATOM   1311 HG22 VAL A  80      48.421  39.036  33.140  1.00  0.00           H  
ATOM   1312 HG23 VAL A  80      49.976  39.887  33.143  1.00  0.00           H  
ATOM   1313  N   GLU A  81      47.329  43.321  35.422  1.00  0.00           N  
ATOM   1314  CA  GLU A  81      46.801  43.394  36.781  1.00  0.00           C  
ATOM   1315  C   GLU A  81      45.995  42.126  37.032  1.00  0.00           C  
ATOM   1316  O   GLU A  81      45.280  41.651  36.142  1.00  0.00           O  
ATOM   1317  CB  GLU A  81      45.925  44.641  36.969  1.00  0.00           C  
ATOM   1318  CG  GLU A  81      46.784  45.895  37.161  1.00  0.00           C  
ATOM   1319  CD  GLU A  81      45.917  47.146  37.393  1.00  0.00           C  
ATOM   1320  OE1 GLU A  81      45.465  47.773  36.408  1.00  0.00           O  
ATOM   1321  OE2 GLU A  81      45.694  47.528  38.564  1.00  0.00           O  
ATOM   1322  H   GLU A  81      46.708  43.592  34.666  1.00  0.00           H  
ATOM   1323  HA  GLU A  81      47.620  43.427  37.500  1.00  0.00           H  
ATOM   1324  HB2 GLU A  81      45.271  44.767  36.106  1.00  0.00           H  
ATOM   1325  HB3 GLU A  81      45.309  44.510  37.860  1.00  0.00           H  
ATOM   1326  HG2 GLU A  81      47.444  45.745  38.018  1.00  0.00           H  
ATOM   1327  HG3 GLU A  81      47.412  46.036  36.283  1.00  0.00           H  
ATOM   1328  N   VAL A  82      46.103  41.580  38.241  1.00  0.00           N  
ATOM   1329  CA  VAL A  82      45.542  40.286  38.587  1.00  0.00           C  
ATOM   1330  C   VAL A  82      44.983  40.324  40.003  1.00  0.00           C  
ATOM   1331  O   VAL A  82      45.574  40.938  40.888  1.00  0.00           O  
ATOM   1332  CB  VAL A  82      46.599  39.171  38.439  1.00  0.00           C  
ATOM   1333  CG1 VAL A  82      46.902  38.881  36.965  1.00  0.00           C  
ATOM   1334  CG2 VAL A  82      47.926  39.450  39.165  1.00  0.00           C  
ATOM   1335  H   VAL A  82      46.664  42.038  38.953  1.00  0.00           H  
ATOM   1336  HA  VAL A  82      44.719  40.081  37.911  1.00  0.00           H  
ATOM   1337  HB  VAL A  82      46.178  38.264  38.868  1.00  0.00           H  
ATOM   1338 HG11 VAL A  82      45.972  38.669  36.442  1.00  0.00           H  
ATOM   1339 HG12 VAL A  82      47.393  39.734  36.497  1.00  0.00           H  
ATOM   1340 HG13 VAL A  82      47.548  38.011  36.893  1.00  0.00           H  
ATOM   1341 HG21 VAL A  82      47.742  39.666  40.217  1.00  0.00           H  
ATOM   1342 HG22 VAL A  82      48.561  38.567  39.110  1.00  0.00           H  
ATOM   1343 HG23 VAL A  82      48.445  40.294  38.709  1.00  0.00           H  
ATOM   1344  N   ALA A  83      43.870  39.635  40.227  1.00  0.00           N  
ATOM   1345  CA  ALA A  83      43.295  39.429  41.549  1.00  0.00           C  
ATOM   1346  C   ALA A  83      43.455  37.954  41.897  1.00  0.00           C  
ATOM   1347  O   ALA A  83      43.222  37.084  41.052  1.00  0.00           O  
ATOM   1348  CB  ALA A  83      41.827  39.856  41.567  1.00  0.00           C  
ATOM   1349  H   ALA A  83      43.452  39.138  39.447  1.00  0.00           H  
ATOM   1350  HA  ALA A  83      43.830  40.031  42.284  1.00  0.00           H  
ATOM   1351  HB1 ALA A  83      41.258  39.267  40.850  1.00  0.00           H  
ATOM   1352  HB2 ALA A  83      41.418  39.708  42.567  1.00  0.00           H  
ATOM   1353  HB3 ALA A  83      41.752  40.911  41.310  1.00  0.00           H  
ATOM   1354  N   ASP A  84      43.863  37.676  43.132  1.00  0.00           N  
ATOM   1355  CA  ASP A  84      44.221  36.338  43.603  1.00  0.00           C  
ATOM   1356  C   ASP A  84      42.979  35.540  43.984  1.00  0.00           C  
ATOM   1357  O   ASP A  84      42.750  35.229  45.152  1.00  0.00           O  
ATOM   1358  CB  ASP A  84      45.212  36.436  44.768  1.00  0.00           C  
ATOM   1359  CG  ASP A  84      45.638  35.059  45.291  1.00  0.00           C  
ATOM   1360  OD1 ASP A  84      45.508  34.045  44.576  1.00  0.00           O  
ATOM   1361  OD2 ASP A  84      46.167  34.997  46.422  1.00  0.00           O  
ATOM   1362  H   ASP A  84      43.980  38.436  43.793  1.00  0.00           H  
ATOM   1363  HA  ASP A  84      44.718  35.794  42.799  1.00  0.00           H  
ATOM   1364  HB2 ASP A  84      46.096  36.976  44.433  1.00  0.00           H  
ATOM   1365  HB3 ASP A  84      44.747  36.994  45.580  1.00  0.00           H  
ATOM   1366  N   ILE A  85      42.129  35.240  43.006  1.00  0.00           N  
ATOM   1367  CA  ILE A  85      40.926  34.431  43.210  1.00  0.00           C  
ATOM   1368  C   ILE A  85      41.246  33.026  43.762  1.00  0.00           C  
ATOM   1369  O   ILE A  85      40.365  32.374  44.321  1.00  0.00           O  
ATOM   1370  CB  ILE A  85      40.066  34.384  41.928  1.00  0.00           C  
ATOM   1371  CG1 ILE A  85      40.761  33.658  40.757  1.00  0.00           C  
ATOM   1372  CG2 ILE A  85      39.635  35.814  41.543  1.00  0.00           C  
ATOM   1373  CD1 ILE A  85      39.865  33.445  39.530  1.00  0.00           C  
ATOM   1374  H   ILE A  85      42.341  35.584  42.077  1.00  0.00           H  
ATOM   1375  HA  ILE A  85      40.335  34.930  43.979  1.00  0.00           H  
ATOM   1376  HB  ILE A  85      39.166  33.823  42.166  1.00  0.00           H  
ATOM   1377 HG12 ILE A  85      41.630  34.232  40.458  1.00  0.00           H  
ATOM   1378 HG13 ILE A  85      41.099  32.677  41.090  1.00  0.00           H  
ATOM   1379 HG21 ILE A  85      40.476  36.377  41.139  1.00  0.00           H  
ATOM   1380 HG22 ILE A  85      38.838  35.776  40.802  1.00  0.00           H  
ATOM   1381 HG23 ILE A  85      39.248  36.333  42.420  1.00  0.00           H  
ATOM   1382 HD11 ILE A  85      38.992  32.853  39.806  1.00  0.00           H  
ATOM   1383 HD12 ILE A  85      39.540  34.398  39.117  1.00  0.00           H  
ATOM   1384 HD13 ILE A  85      40.423  32.919  38.757  1.00  0.00           H  
ATOM   1385  N   GLY A  86      42.498  32.570  43.641  1.00  0.00           N  
ATOM   1386  CA  GLY A  86      42.985  31.318  44.200  1.00  0.00           C  
ATOM   1387  C   GLY A  86      43.414  31.440  45.667  1.00  0.00           C  
ATOM   1388  O   GLY A  86      43.774  30.425  46.266  1.00  0.00           O  
ATOM   1389  H   GLY A  86      43.181  33.145  43.159  1.00  0.00           H  
ATOM   1390  HA2 GLY A  86      42.209  30.556  44.116  1.00  0.00           H  
ATOM   1391  HA3 GLY A  86      43.847  31.001  43.614  1.00  0.00           H  
ATOM   1392  N   GLY A  87      43.383  32.640  46.258  1.00  0.00           N  
ATOM   1393  CA  GLY A  87      43.873  32.896  47.603  1.00  0.00           C  
ATOM   1394  C   GLY A  87      43.179  34.104  48.221  1.00  0.00           C  
ATOM   1395  O   GLY A  87      42.091  33.958  48.782  1.00  0.00           O  
ATOM   1396  H   GLY A  87      43.137  33.454  45.699  1.00  0.00           H  
ATOM   1397  HA2 GLY A  87      43.696  32.027  48.238  1.00  0.00           H  
ATOM   1398  HA3 GLY A  87      44.946  33.077  47.560  1.00  0.00           H  
ATOM   1399  N   LYS A  88      43.811  35.284  48.156  1.00  0.00           N  
ATOM   1400  CA  LYS A  88      43.346  36.476  48.878  1.00  0.00           C  
ATOM   1401  C   LYS A  88      41.938  36.905  48.457  1.00  0.00           C  
ATOM   1402  O   LYS A  88      41.185  37.381  49.303  1.00  0.00           O  
ATOM   1403  CB  LYS A  88      44.323  37.653  48.692  1.00  0.00           C  
ATOM   1404  CG  LYS A  88      45.770  37.379  49.136  1.00  0.00           C  
ATOM   1405  CD  LYS A  88      45.900  37.016  50.623  1.00  0.00           C  
ATOM   1406  CE  LYS A  88      47.382  36.876  50.999  1.00  0.00           C  
ATOM   1407  NZ  LYS A  88      47.569  36.528  52.430  1.00  0.00           N  
ATOM   1408  H   LYS A  88      44.696  35.329  47.652  1.00  0.00           H  
ATOM   1409  HA  LYS A  88      43.294  36.226  49.938  1.00  0.00           H  
ATOM   1410  HB2 LYS A  88      44.333  37.946  47.642  1.00  0.00           H  
ATOM   1411  HB3 LYS A  88      43.946  38.505  49.261  1.00  0.00           H  
ATOM   1412  HG2 LYS A  88      46.192  36.578  48.531  1.00  0.00           H  
ATOM   1413  HG3 LYS A  88      46.353  38.279  48.943  1.00  0.00           H  
ATOM   1414  HD2 LYS A  88      45.441  37.801  51.226  1.00  0.00           H  
ATOM   1415  HD3 LYS A  88      45.391  36.070  50.814  1.00  0.00           H  
ATOM   1416  HE2 LYS A  88      47.832  36.100  50.375  1.00  0.00           H  
ATOM   1417  HE3 LYS A  88      47.890  37.819  50.785  1.00  0.00           H  
ATOM   1418  HZ1 LYS A  88      47.184  37.239  53.033  1.00  0.00           H  
ATOM   1419  HZ2 LYS A  88      47.130  35.648  52.655  1.00  0.00           H  
ATOM   1420  HZ3 LYS A  88      48.550  36.443  52.650  1.00  0.00           H  
ATOM   1421  N   ASP A  89      41.601  36.733  47.176  1.00  0.00           N  
ATOM   1422  CA  ASP A  89      40.334  37.001  46.480  1.00  0.00           C  
ATOM   1423  C   ASP A  89      39.838  38.454  46.490  1.00  0.00           C  
ATOM   1424  O   ASP A  89      39.182  38.882  45.541  1.00  0.00           O  
ATOM   1425  CB  ASP A  89      39.247  36.034  46.971  1.00  0.00           C  
ATOM   1426  CG  ASP A  89      37.913  36.246  46.237  1.00  0.00           C  
ATOM   1427  OD1 ASP A  89      37.788  35.819  45.067  1.00  0.00           O  
ATOM   1428  OD2 ASP A  89      36.963  36.789  46.846  1.00  0.00           O  
ATOM   1429  H   ASP A  89      42.297  36.285  46.591  1.00  0.00           H  
ATOM   1430  HA  ASP A  89      40.516  36.758  45.433  1.00  0.00           H  
ATOM   1431  HB2 ASP A  89      39.588  35.008  46.819  1.00  0.00           H  
ATOM   1432  HB3 ASP A  89      39.096  36.180  48.042  1.00  0.00           H  
ATOM   1433  N   ASP A  90      40.189  39.237  47.508  1.00  0.00           N  
ATOM   1434  CA  ASP A  90      39.655  40.573  47.773  1.00  0.00           C  
ATOM   1435  C   ASP A  90      40.709  41.663  47.532  1.00  0.00           C  
ATOM   1436  O   ASP A  90      40.484  42.836  47.833  1.00  0.00           O  
ATOM   1437  CB  ASP A  90      39.150  40.598  49.222  1.00  0.00           C  
ATOM   1438  CG  ASP A  90      38.395  41.891  49.579  1.00  0.00           C  
ATOM   1439  OD1 ASP A  90      37.399  42.230  48.900  1.00  0.00           O  
ATOM   1440  OD2 ASP A  90      38.748  42.544  50.589  1.00  0.00           O  
ATOM   1441  H   ASP A  90      40.700  38.803  48.269  1.00  0.00           H  
ATOM   1442  HA  ASP A  90      38.810  40.763  47.110  1.00  0.00           H  
ATOM   1443  HB2 ASP A  90      38.481  39.749  49.377  1.00  0.00           H  
ATOM   1444  HB3 ASP A  90      40.013  40.470  49.880  1.00  0.00           H  
ATOM   1445  N   ASP A  91      41.870  41.290  46.984  1.00  0.00           N  
ATOM   1446  CA  ASP A  91      42.970  42.211  46.692  1.00  0.00           C  
ATOM   1447  C   ASP A  91      43.576  41.915  45.320  1.00  0.00           C  
ATOM   1448  O   ASP A  91      43.345  40.848  44.741  1.00  0.00           O  
ATOM   1449  CB  ASP A  91      44.034  42.165  47.802  1.00  0.00           C  
ATOM   1450  CG  ASP A  91      44.982  43.382  47.809  1.00  0.00           C  
ATOM   1451  OD1 ASP A  91      44.689  44.412  47.160  1.00  0.00           O  
ATOM   1452  OD2 ASP A  91      46.017  43.328  48.509  1.00  0.00           O  
ATOM   1453  H   ASP A  91      41.969  40.327  46.689  1.00  0.00           H  
ATOM   1454  HA  ASP A  91      42.568  43.224  46.658  1.00  0.00           H  
ATOM   1455  HB2 ASP A  91      43.530  42.125  48.770  1.00  0.00           H  
ATOM   1456  HB3 ASP A  91      44.618  41.252  47.679  1.00  0.00           H  
ATOM   1457  N   VAL A  92      44.355  42.867  44.814  1.00  0.00           N  
ATOM   1458  CA  VAL A  92      44.858  42.913  43.448  1.00  0.00           C  
ATOM   1459  C   VAL A  92      46.366  43.205  43.483  1.00  0.00           C  
ATOM   1460  O   VAL A  92      46.858  43.926  44.356  1.00  0.00           O  
ATOM   1461  CB  VAL A  92      44.071  43.991  42.655  1.00  0.00           C  
ATOM   1462  CG1 VAL A  92      44.381  43.988  41.150  1.00  0.00           C  
ATOM   1463  CG2 VAL A  92      42.543  43.851  42.801  1.00  0.00           C  
ATOM   1464  H   VAL A  92      44.563  43.668  45.402  1.00  0.00           H  
ATOM   1465  HA  VAL A  92      44.693  41.945  42.979  1.00  0.00           H  
ATOM   1466  HB  VAL A  92      44.349  44.968  43.047  1.00  0.00           H  
ATOM   1467 HG11 VAL A  92      43.873  44.826  40.673  1.00  0.00           H  
ATOM   1468 HG12 VAL A  92      45.448  44.110  40.974  1.00  0.00           H  
ATOM   1469 HG13 VAL A  92      44.040  43.059  40.693  1.00  0.00           H  
ATOM   1470 HG21 VAL A  92      42.237  44.058  43.827  1.00  0.00           H  
ATOM   1471 HG22 VAL A  92      42.036  44.570  42.156  1.00  0.00           H  
ATOM   1472 HG23 VAL A  92      42.231  42.844  42.530  1.00  0.00           H  
ATOM   1473  N   TYR A  93      47.082  42.643  42.512  1.00  0.00           N  
ATOM   1474  CA  TYR A  93      48.525  42.689  42.329  1.00  0.00           C  
ATOM   1475  C   TYR A  93      48.806  42.839  40.824  1.00  0.00           C  
ATOM   1476  O   TYR A  93      47.879  42.990  40.023  1.00  0.00           O  
ATOM   1477  CB  TYR A  93      49.140  41.391  42.889  1.00  0.00           C  
ATOM   1478  CG  TYR A  93      48.867  41.141  44.363  1.00  0.00           C  
ATOM   1479  CD1 TYR A  93      49.741  41.663  45.336  1.00  0.00           C  
ATOM   1480  CD2 TYR A  93      47.734  40.404  44.761  1.00  0.00           C  
ATOM   1481  CE1 TYR A  93      49.485  41.451  46.702  1.00  0.00           C  
ATOM   1482  CE2 TYR A  93      47.463  40.200  46.126  1.00  0.00           C  
ATOM   1483  CZ  TYR A  93      48.343  40.723  47.104  1.00  0.00           C  
ATOM   1484  OH  TYR A  93      48.111  40.532  48.433  1.00  0.00           O  
ATOM   1485  H   TYR A  93      46.584  42.077  41.830  1.00  0.00           H  
ATOM   1486  HA  TYR A  93      48.944  43.546  42.858  1.00  0.00           H  
ATOM   1487  HB2 TYR A  93      48.765  40.543  42.314  1.00  0.00           H  
ATOM   1488  HB3 TYR A  93      50.222  41.418  42.747  1.00  0.00           H  
ATOM   1489  HD1 TYR A  93      50.613  42.231  45.038  1.00  0.00           H  
ATOM   1490  HD2 TYR A  93      47.059  40.002  44.017  1.00  0.00           H  
ATOM   1491  HE1 TYR A  93      50.162  41.854  47.443  1.00  0.00           H  
ATOM   1492  HE2 TYR A  93      46.583  39.642  46.414  1.00  0.00           H  
ATOM   1493  HH  TYR A  93      47.285  40.059  48.614  1.00  0.00           H  
ATOM   1494  N   THR A  94      50.075  42.763  40.422  1.00  0.00           N  
ATOM   1495  CA  THR A  94      50.490  42.762  39.023  1.00  0.00           C  
ATOM   1496  C   THR A  94      51.308  41.489  38.778  1.00  0.00           C  
ATOM   1497  O   THR A  94      52.013  41.020  39.676  1.00  0.00           O  
ATOM   1498  CB  THR A  94      51.277  44.054  38.724  1.00  0.00           C  
ATOM   1499  OG1 THR A  94      50.510  45.188  39.088  1.00  0.00           O  
ATOM   1500  CG2 THR A  94      51.657  44.203  37.246  1.00  0.00           C  
ATOM   1501  H   THR A  94      50.802  42.582  41.101  1.00  0.00           H  
ATOM   1502  HA  THR A  94      49.612  42.738  38.380  1.00  0.00           H  
ATOM   1503  HB  THR A  94      52.194  44.053  39.316  1.00  0.00           H  
ATOM   1504  HG1 THR A  94      50.372  45.153  40.047  1.00  0.00           H  
ATOM   1505 HG21 THR A  94      52.144  45.164  37.084  1.00  0.00           H  
ATOM   1506 HG22 THR A  94      52.353  43.415  36.956  1.00  0.00           H  
ATOM   1507 HG23 THR A  94      50.767  44.140  36.620  1.00  0.00           H  
ATOM   1508  N   ALA A  95      51.216  40.943  37.565  1.00  0.00           N  
ATOM   1509  CA  ALA A  95      51.928  39.752  37.131  1.00  0.00           C  
ATOM   1510  C   ALA A  95      52.449  39.955  35.714  1.00  0.00           C  
ATOM   1511  O   ALA A  95      51.936  40.777  34.956  1.00  0.00           O  
ATOM   1512  CB  ALA A  95      50.995  38.536  37.196  1.00  0.00           C  
ATOM   1513  H   ALA A  95      50.627  41.403  36.870  1.00  0.00           H  
ATOM   1514  HA  ALA A  95      52.778  39.585  37.789  1.00  0.00           H  
ATOM   1515  HB1 ALA A  95      50.117  38.707  36.574  1.00  0.00           H  
ATOM   1516  HB2 ALA A  95      51.516  37.645  36.842  1.00  0.00           H  
ATOM   1517  HB3 ALA A  95      50.684  38.370  38.225  1.00  0.00           H  
ATOM   1518  N   LYS A  96      53.478  39.193  35.352  1.00  0.00           N  
ATOM   1519  CA  LYS A  96      53.979  39.153  33.986  1.00  0.00           C  
ATOM   1520  C   LYS A  96      52.982  38.306  33.202  1.00  0.00           C  
ATOM   1521  O   LYS A  96      52.709  37.180  33.625  1.00  0.00           O  
ATOM   1522  CB  LYS A  96      55.374  38.498  33.911  1.00  0.00           C  
ATOM   1523  CG  LYS A  96      56.534  39.154  34.689  1.00  0.00           C  
ATOM   1524  CD  LYS A  96      56.494  39.090  36.232  1.00  0.00           C  
ATOM   1525  CE  LYS A  96      56.190  37.707  36.845  1.00  0.00           C  
ATOM   1526  NZ  LYS A  96      57.299  36.726  36.717  1.00  0.00           N  
ATOM   1527  H   LYS A  96      53.823  38.515  36.011  1.00  0.00           H  
ATOM   1528  HA  LYS A  96      54.028  40.162  33.571  1.00  0.00           H  
ATOM   1529  HB2 LYS A  96      55.299  37.456  34.208  1.00  0.00           H  
ATOM   1530  HB3 LYS A  96      55.661  38.501  32.860  1.00  0.00           H  
ATOM   1531  HG2 LYS A  96      57.456  38.670  34.364  1.00  0.00           H  
ATOM   1532  HG3 LYS A  96      56.604  40.200  34.389  1.00  0.00           H  
ATOM   1533  HD2 LYS A  96      57.449  39.450  36.619  1.00  0.00           H  
ATOM   1534  HD3 LYS A  96      55.739  39.793  36.584  1.00  0.00           H  
ATOM   1535  HE2 LYS A  96      55.977  37.845  37.908  1.00  0.00           H  
ATOM   1536  HE3 LYS A  96      55.292  37.294  36.382  1.00  0.00           H  
ATOM   1537  HZ1 LYS A  96      58.082  36.979  37.303  1.00  0.00           H  
ATOM   1538  HZ2 LYS A  96      56.970  35.803  37.010  1.00  0.00           H  
ATOM   1539  HZ3 LYS A  96      57.630  36.647  35.767  1.00  0.00           H  
ATOM   1540  N   LEU A  97      52.481  38.767  32.053  1.00  0.00           N  
ATOM   1541  CA  LEU A  97      51.707  37.887  31.171  1.00  0.00           C  
ATOM   1542  C   LEU A  97      52.580  36.704  30.739  1.00  0.00           C  
ATOM   1543  O   LEU A  97      52.100  35.583  30.600  1.00  0.00           O  
ATOM   1544  CB  LEU A  97      51.208  38.664  29.946  1.00  0.00           C  
ATOM   1545  CG  LEU A  97      50.331  37.838  28.991  1.00  0.00           C  
ATOM   1546  CD1 LEU A  97      49.047  37.355  29.681  1.00  0.00           C  
ATOM   1547  CD2 LEU A  97      49.990  38.706  27.778  1.00  0.00           C  
ATOM   1548  H   LEU A  97      52.715  39.697  31.718  1.00  0.00           H  
ATOM   1549  HA  LEU A  97      50.853  37.511  31.736  1.00  0.00           H  
ATOM   1550  HB2 LEU A  97      50.637  39.528  30.286  1.00  0.00           H  
ATOM   1551  HB3 LEU A  97      52.078  39.020  29.391  1.00  0.00           H  
ATOM   1552  HG  LEU A  97      50.890  36.975  28.631  1.00  0.00           H  
ATOM   1553 HD11 LEU A  97      48.381  36.890  28.959  1.00  0.00           H  
ATOM   1554 HD12 LEU A  97      49.286  36.612  30.439  1.00  0.00           H  
ATOM   1555 HD13 LEU A  97      48.528  38.193  30.146  1.00  0.00           H  
ATOM   1556 HD21 LEU A  97      49.322  39.516  28.073  1.00  0.00           H  
ATOM   1557 HD22 LEU A  97      50.903  39.126  27.353  1.00  0.00           H  
ATOM   1558 HD23 LEU A  97      49.517  38.102  27.008  1.00  0.00           H  
ATOM   1559  N   SER A  98      53.884  36.959  30.610  1.00  0.00           N  
ATOM   1560  CA  SER A  98      54.965  36.016  30.366  1.00  0.00           C  
ATOM   1561  C   SER A  98      55.027  34.856  31.376  1.00  0.00           C  
ATOM   1562  O   SER A  98      55.734  33.878  31.133  1.00  0.00           O  
ATOM   1563  CB  SER A  98      56.272  36.825  30.388  1.00  0.00           C  
ATOM   1564  OG  SER A  98      56.075  38.055  29.710  1.00  0.00           O  
ATOM   1565  H   SER A  98      54.189  37.922  30.666  1.00  0.00           H  
ATOM   1566  HA  SER A  98      54.832  35.603  29.368  1.00  0.00           H  
ATOM   1567  HB2 SER A  98      56.553  37.032  31.421  1.00  0.00           H  
ATOM   1568  HB3 SER A  98      57.069  36.253  29.919  1.00  0.00           H  
ATOM   1569  HG  SER A  98      56.730  38.719  30.037  1.00  0.00           H  
ATOM   1570  N   ASP A  99      54.305  34.950  32.500  1.00  0.00           N  
ATOM   1571  CA  ASP A  99      54.340  33.993  33.609  1.00  0.00           C  
ATOM   1572  C   ASP A  99      52.932  33.460  33.918  1.00  0.00           C  
ATOM   1573  O   ASP A  99      52.686  32.849  34.957  1.00  0.00           O  
ATOM   1574  CB  ASP A  99      55.005  34.699  34.801  1.00  0.00           C  
ATOM   1575  CG  ASP A  99      55.530  33.797  35.923  1.00  0.00           C  
ATOM   1576  OD1 ASP A  99      55.835  32.607  35.698  1.00  0.00           O  
ATOM   1577  OD2 ASP A  99      55.775  34.366  37.015  1.00  0.00           O  
ATOM   1578  H   ASP A  99      53.763  35.780  32.654  1.00  0.00           H  
ATOM   1579  HA  ASP A  99      54.944  33.140  33.316  1.00  0.00           H  
ATOM   1580  HB2 ASP A  99      55.866  35.255  34.424  1.00  0.00           H  
ATOM   1581  HB3 ASP A  99      54.300  35.419  35.219  1.00  0.00           H  
ATOM   1582  N   ILE A 100      51.995  33.683  32.994  1.00  0.00           N  
ATOM   1583  CA  ILE A 100      50.584  33.330  33.113  1.00  0.00           C  
ATOM   1584  C   ILE A 100      50.179  32.440  31.940  1.00  0.00           C  
ATOM   1585  O   ILE A 100      50.761  32.472  30.853  1.00  0.00           O  
ATOM   1586  CB  ILE A 100      49.734  34.626  33.263  1.00  0.00           C  
ATOM   1587  CG1 ILE A 100      49.553  34.905  34.769  1.00  0.00           C  
ATOM   1588  CG2 ILE A 100      48.355  34.628  32.566  1.00  0.00           C  
ATOM   1589  CD1 ILE A 100      48.938  36.263  35.101  1.00  0.00           C  
ATOM   1590  H   ILE A 100      52.271  34.213  32.170  1.00  0.00           H  
ATOM   1591  HA  ILE A 100      50.455  32.730  34.012  1.00  0.00           H  
ATOM   1592  HB  ILE A 100      50.297  35.445  32.824  1.00  0.00           H  
ATOM   1593 HG12 ILE A 100      48.905  34.135  35.192  1.00  0.00           H  
ATOM   1594 HG13 ILE A 100      50.527  34.857  35.258  1.00  0.00           H  
ATOM   1595 HG21 ILE A 100      48.466  34.411  31.503  1.00  0.00           H  
ATOM   1596 HG22 ILE A 100      47.692  33.891  33.021  1.00  0.00           H  
ATOM   1597 HG23 ILE A 100      47.894  35.612  32.641  1.00  0.00           H  
ATOM   1598 HD11 ILE A 100      49.491  37.056  34.599  1.00  0.00           H  
ATOM   1599 HD12 ILE A 100      47.890  36.287  34.801  1.00  0.00           H  
ATOM   1600 HD13 ILE A 100      48.991  36.411  36.179  1.00  0.00           H  
ATOM   1601  N   GLU A 101      49.130  31.666  32.191  1.00  0.00           N  
ATOM   1602  CA  GLU A 101      48.454  30.802  31.240  1.00  0.00           C  
ATOM   1603  C   GLU A 101      46.986  31.216  31.270  1.00  0.00           C  
ATOM   1604  O   GLU A 101      46.357  31.173  32.327  1.00  0.00           O  
ATOM   1605  CB  GLU A 101      48.666  29.342  31.669  1.00  0.00           C  
ATOM   1606  CG  GLU A 101      47.910  28.347  30.780  1.00  0.00           C  
ATOM   1607  CD  GLU A 101      48.335  26.892  31.058  1.00  0.00           C  
ATOM   1608  OE1 GLU A 101      48.266  26.434  32.223  1.00  0.00           O  
ATOM   1609  OE2 GLU A 101      48.739  26.187  30.104  1.00  0.00           O  
ATOM   1610  H   GLU A 101      48.773  31.672  33.132  1.00  0.00           H  
ATOM   1611  HA  GLU A 101      48.865  30.944  30.240  1.00  0.00           H  
ATOM   1612  HB2 GLU A 101      49.733  29.119  31.621  1.00  0.00           H  
ATOM   1613  HB3 GLU A 101      48.330  29.221  32.700  1.00  0.00           H  
ATOM   1614  HG2 GLU A 101      46.837  28.450  30.954  1.00  0.00           H  
ATOM   1615  HG3 GLU A 101      48.104  28.600  29.735  1.00  0.00           H  
ATOM   1616  N   ALA A 102      46.452  31.669  30.135  1.00  0.00           N  
ATOM   1617  CA  ALA A 102      45.077  32.138  30.053  1.00  0.00           C  
ATOM   1618  C   ALA A 102      44.133  30.939  30.019  1.00  0.00           C  
ATOM   1619  O   ALA A 102      44.410  29.941  29.347  1.00  0.00           O  
ATOM   1620  CB  ALA A 102      44.896  32.989  28.797  1.00  0.00           C  
ATOM   1621  H   ALA A 102      47.003  31.626  29.285  1.00  0.00           H  
ATOM   1622  HA  ALA A 102      44.859  32.755  30.928  1.00  0.00           H  
ATOM   1623  HB1 ALA A 102      45.016  32.379  27.901  1.00  0.00           H  
ATOM   1624  HB2 ALA A 102      43.899  33.429  28.804  1.00  0.00           H  
ATOM   1625  HB3 ALA A 102      45.637  33.783  28.799  1.00  0.00           H  
ATOM   1626  N   ILE A 103      43.004  31.063  30.712  1.00  0.00           N  
ATOM   1627  CA  ILE A 103      41.996  30.015  30.846  1.00  0.00           C  
ATOM   1628  C   ILE A 103      40.626  30.611  30.505  1.00  0.00           C  
ATOM   1629  O   ILE A 103      40.307  31.731  30.901  1.00  0.00           O  
ATOM   1630  CB  ILE A 103      42.075  29.437  32.280  1.00  0.00           C  
ATOM   1631  CG1 ILE A 103      43.386  28.636  32.450  1.00  0.00           C  
ATOM   1632  CG2 ILE A 103      40.860  28.559  32.645  1.00  0.00           C  
ATOM   1633  CD1 ILE A 103      43.676  28.244  33.897  1.00  0.00           C  
ATOM   1634  H   ILE A 103      42.863  31.904  31.260  1.00  0.00           H  
ATOM   1635  HA  ILE A 103      42.207  29.210  30.141  1.00  0.00           H  
ATOM   1636  HB  ILE A 103      42.094  30.279  32.970  1.00  0.00           H  
ATOM   1637 HG12 ILE A 103      43.351  27.737  31.835  1.00  0.00           H  
ATOM   1638 HG13 ILE A 103      44.234  29.235  32.121  1.00  0.00           H  
ATOM   1639 HG21 ILE A 103      39.939  29.137  32.577  1.00  0.00           H  
ATOM   1640 HG22 ILE A 103      40.799  27.700  31.976  1.00  0.00           H  
ATOM   1641 HG23 ILE A 103      40.930  28.211  33.673  1.00  0.00           H  
ATOM   1642 HD11 ILE A 103      42.938  27.529  34.256  1.00  0.00           H  
ATOM   1643 HD12 ILE A 103      44.659  27.779  33.938  1.00  0.00           H  
ATOM   1644 HD13 ILE A 103      43.665  29.138  34.520  1.00  0.00           H  
ATOM   1645  N   ASP A 104      39.806  29.816  29.806  1.00  0.00           N  
ATOM   1646  CA  ASP A 104      38.392  30.084  29.515  1.00  0.00           C  
ATOM   1647  C   ASP A 104      38.151  31.465  28.880  1.00  0.00           C  
ATOM   1648  O   ASP A 104      37.150  32.131  29.152  1.00  0.00           O  
ATOM   1649  CB  ASP A 104      37.535  29.808  30.765  1.00  0.00           C  
ATOM   1650  CG  ASP A 104      36.024  29.830  30.468  1.00  0.00           C  
ATOM   1651  OD1 ASP A 104      35.578  29.197  29.483  1.00  0.00           O  
ATOM   1652  OD2 ASP A 104      35.255  30.424  31.260  1.00  0.00           O  
ATOM   1653  H   ASP A 104      40.175  28.937  29.445  1.00  0.00           H  
ATOM   1654  HA  ASP A 104      38.095  29.351  28.765  1.00  0.00           H  
ATOM   1655  HB2 ASP A 104      37.796  28.822  31.157  1.00  0.00           H  
ATOM   1656  HB3 ASP A 104      37.776  30.545  31.534  1.00  0.00           H  
ATOM   1657  N   VAL A 105      39.085  31.906  28.030  1.00  0.00           N  
ATOM   1658  CA  VAL A 105      39.018  33.199  27.347  1.00  0.00           C  
ATOM   1659  C   VAL A 105      38.697  33.013  25.853  1.00  0.00           C  
ATOM   1660  O   VAL A 105      38.703  31.889  25.341  1.00  0.00           O  
ATOM   1661  CB  VAL A 105      40.307  33.997  27.651  1.00  0.00           C  
ATOM   1662  CG1 VAL A 105      41.532  33.556  26.834  1.00  0.00           C  
ATOM   1663  CG2 VAL A 105      40.060  35.503  27.527  1.00  0.00           C  
ATOM   1664  H   VAL A 105      39.912  31.342  27.882  1.00  0.00           H  
ATOM   1665  HA  VAL A 105      38.190  33.763  27.778  1.00  0.00           H  
ATOM   1666  HB  VAL A 105      40.564  33.834  28.692  1.00  0.00           H  
ATOM   1667 HG11 VAL A 105      42.405  34.131  27.141  1.00  0.00           H  
ATOM   1668 HG12 VAL A 105      41.735  32.498  27.000  1.00  0.00           H  
ATOM   1669 HG13 VAL A 105      41.360  33.724  25.773  1.00  0.00           H  
ATOM   1670 HG21 VAL A 105      40.913  36.035  27.942  1.00  0.00           H  
ATOM   1671 HG22 VAL A 105      39.916  35.798  26.493  1.00  0.00           H  
ATOM   1672 HG23 VAL A 105      39.171  35.784  28.093  1.00  0.00           H  
ATOM   1673  N   ASP A 106      38.387  34.113  25.159  1.00  0.00           N  
ATOM   1674  CA  ASP A 106      38.094  34.118  23.728  1.00  0.00           C  
ATOM   1675  C   ASP A 106      39.335  33.739  22.926  1.00  0.00           C  
ATOM   1676  O   ASP A 106      40.466  34.001  23.342  1.00  0.00           O  
ATOM   1677  CB  ASP A 106      37.628  35.507  23.284  1.00  0.00           C  
ATOM   1678  CG  ASP A 106      37.277  35.534  21.788  1.00  0.00           C  
ATOM   1679  OD1 ASP A 106      36.190  35.036  21.417  1.00  0.00           O  
ATOM   1680  OD2 ASP A 106      38.097  36.026  20.983  1.00  0.00           O  
ATOM   1681  H   ASP A 106      38.426  35.010  25.619  1.00  0.00           H  
ATOM   1682  HA  ASP A 106      37.297  33.402  23.527  1.00  0.00           H  
ATOM   1683  HB2 ASP A 106      36.752  35.791  23.867  1.00  0.00           H  
ATOM   1684  HB3 ASP A 106      38.430  36.216  23.477  1.00  0.00           H  
ATOM   1685  N   ASP A 107      39.111  33.161  21.750  1.00  0.00           N  
ATOM   1686  CA  ASP A 107      40.162  32.678  20.862  1.00  0.00           C  
ATOM   1687  C   ASP A 107      41.161  33.774  20.507  1.00  0.00           C  
ATOM   1688  O   ASP A 107      42.360  33.519  20.547  1.00  0.00           O  
ATOM   1689  CB  ASP A 107      39.537  32.102  19.588  1.00  0.00           C  
ATOM   1690  CG  ASP A 107      40.618  31.624  18.604  1.00  0.00           C  
ATOM   1691  OD1 ASP A 107      41.210  30.546  18.832  1.00  0.00           O  
ATOM   1692  OD2 ASP A 107      40.830  32.291  17.567  1.00  0.00           O  
ATOM   1693  H   ASP A 107      38.154  33.077  21.441  1.00  0.00           H  
ATOM   1694  HA  ASP A 107      40.713  31.882  21.361  1.00  0.00           H  
ATOM   1695  HB2 ASP A 107      38.889  31.264  19.856  1.00  0.00           H  
ATOM   1696  HB3 ASP A 107      38.917  32.867  19.115  1.00  0.00           H  
ATOM   1697  N   ASP A 108      40.711  34.999  20.221  1.00  0.00           N  
ATOM   1698  CA  ASP A 108      41.626  36.060  19.794  1.00  0.00           C  
ATOM   1699  C   ASP A 108      42.466  36.566  20.969  1.00  0.00           C  
ATOM   1700  O   ASP A 108      43.608  36.986  20.787  1.00  0.00           O  
ATOM   1701  CB  ASP A 108      40.859  37.223  19.147  1.00  0.00           C  
ATOM   1702  CG  ASP A 108      41.727  38.093  18.217  1.00  0.00           C  
ATOM   1703  OD1 ASP A 108      42.719  37.604  17.630  1.00  0.00           O  
ATOM   1704  OD2 ASP A 108      41.353  39.265  17.988  1.00  0.00           O  
ATOM   1705  H   ASP A 108      39.720  35.220  20.317  1.00  0.00           H  
ATOM   1706  HA  ASP A 108      42.294  35.629  19.048  1.00  0.00           H  
ATOM   1707  HB2 ASP A 108      40.033  36.820  18.557  1.00  0.00           H  
ATOM   1708  HB3 ASP A 108      40.444  37.856  19.937  1.00  0.00           H  
ATOM   1709  N   THR A 109      41.924  36.480  22.189  1.00  0.00           N  
ATOM   1710  CA  THR A 109      42.664  36.791  23.406  1.00  0.00           C  
ATOM   1711  C   THR A 109      43.710  35.702  23.639  1.00  0.00           C  
ATOM   1712  O   THR A 109      44.889  36.017  23.808  1.00  0.00           O  
ATOM   1713  CB  THR A 109      41.678  36.907  24.579  1.00  0.00           C  
ATOM   1714  OG1 THR A 109      40.745  37.928  24.304  1.00  0.00           O  
ATOM   1715  CG2 THR A 109      42.370  37.276  25.886  1.00  0.00           C  
ATOM   1716  H   THR A 109      41.050  35.979  22.292  1.00  0.00           H  
ATOM   1717  HA  THR A 109      43.182  37.747  23.293  1.00  0.00           H  
ATOM   1718  HB  THR A 109      41.146  35.967  24.726  1.00  0.00           H  
ATOM   1719  HG1 THR A 109      40.406  37.811  23.405  1.00  0.00           H  
ATOM   1720 HG21 THR A 109      43.137  38.007  25.684  1.00  0.00           H  
ATOM   1721 HG22 THR A 109      41.657  37.700  26.593  1.00  0.00           H  
ATOM   1722 HG23 THR A 109      42.833  36.392  26.321  1.00  0.00           H  
ATOM   1723  N   GLN A 110      43.304  34.427  23.606  1.00  0.00           N  
ATOM   1724  CA  GLN A 110      44.206  33.310  23.834  1.00  0.00           C  
ATOM   1725  C   GLN A 110      45.345  33.351  22.808  1.00  0.00           C  
ATOM   1726  O   GLN A 110      46.507  33.236  23.187  1.00  0.00           O  
ATOM   1727  CB  GLN A 110      43.414  31.987  23.794  1.00  0.00           C  
ATOM   1728  CG  GLN A 110      44.012  30.891  24.691  1.00  0.00           C  
ATOM   1729  CD  GLN A 110      45.418  30.457  24.272  1.00  0.00           C  
ATOM   1730  OE1 GLN A 110      45.611  29.838  23.228  1.00  0.00           O  
ATOM   1731  NE2 GLN A 110      46.430  30.767  25.070  1.00  0.00           N  
ATOM   1732  H   GLN A 110      42.321  34.221  23.452  1.00  0.00           H  
ATOM   1733  HA  GLN A 110      44.632  33.437  24.831  1.00  0.00           H  
ATOM   1734  HB2 GLN A 110      42.400  32.166  24.150  1.00  0.00           H  
ATOM   1735  HB3 GLN A 110      43.342  31.627  22.766  1.00  0.00           H  
ATOM   1736  HG2 GLN A 110      44.022  31.246  25.723  1.00  0.00           H  
ATOM   1737  HG3 GLN A 110      43.357  30.019  24.657  1.00  0.00           H  
ATOM   1738 HE21 GLN A 110      46.269  31.284  25.921  1.00  0.00           H  
ATOM   1739 HE22 GLN A 110      47.373  30.551  24.788  1.00  0.00           H  
ATOM   1740  N   GLU A 111      45.037  33.581  21.530  1.00  0.00           N  
ATOM   1741  CA  GLU A 111      46.034  33.646  20.471  1.00  0.00           C  
ATOM   1742  C   GLU A 111      46.989  34.826  20.671  1.00  0.00           C  
ATOM   1743  O   GLU A 111      48.186  34.662  20.447  1.00  0.00           O  
ATOM   1744  CB  GLU A 111      45.344  33.730  19.099  1.00  0.00           C  
ATOM   1745  CG  GLU A 111      44.720  32.397  18.653  1.00  0.00           C  
ATOM   1746  CD  GLU A 111      45.784  31.367  18.233  1.00  0.00           C  
ATOM   1747  OE1 GLU A 111      46.255  31.412  17.073  1.00  0.00           O  
ATOM   1748  OE2 GLU A 111      46.149  30.488  19.046  1.00  0.00           O  
ATOM   1749  H   GLU A 111      44.059  33.659  21.260  1.00  0.00           H  
ATOM   1750  HA  GLU A 111      46.631  32.734  20.507  1.00  0.00           H  
ATOM   1751  HB2 GLU A 111      44.569  34.498  19.137  1.00  0.00           H  
ATOM   1752  HB3 GLU A 111      46.074  34.037  18.349  1.00  0.00           H  
ATOM   1753  HG2 GLU A 111      44.100  31.985  19.453  1.00  0.00           H  
ATOM   1754  HG3 GLU A 111      44.063  32.596  17.804  1.00  0.00           H  
ATOM   1755  N   ALA A 112      46.509  35.994  21.120  1.00  0.00           N  
ATOM   1756  CA  ALA A 112      47.381  37.143  21.364  1.00  0.00           C  
ATOM   1757  C   ALA A 112      48.368  36.837  22.497  1.00  0.00           C  
ATOM   1758  O   ALA A 112      49.556  37.143  22.394  1.00  0.00           O  
ATOM   1759  CB  ALA A 112      46.543  38.383  21.692  1.00  0.00           C  
ATOM   1760  H   ALA A 112      45.519  36.080  21.323  1.00  0.00           H  
ATOM   1761  HA  ALA A 112      47.949  37.347  20.455  1.00  0.00           H  
ATOM   1762  HB1 ALA A 112      45.974  38.229  22.609  1.00  0.00           H  
ATOM   1763  HB2 ALA A 112      47.203  39.241  21.822  1.00  0.00           H  
ATOM   1764  HB3 ALA A 112      45.862  38.590  20.869  1.00  0.00           H  
ATOM   1765  N   ILE A 113      47.879  36.210  23.569  1.00  0.00           N  
ATOM   1766  CA  ILE A 113      48.686  35.838  24.724  1.00  0.00           C  
ATOM   1767  C   ILE A 113      49.707  34.774  24.301  1.00  0.00           C  
ATOM   1768  O   ILE A 113      50.895  34.906  24.605  1.00  0.00           O  
ATOM   1769  CB  ILE A 113      47.748  35.369  25.862  1.00  0.00           C  
ATOM   1770  CG1 ILE A 113      46.879  36.559  26.340  1.00  0.00           C  
ATOM   1771  CG2 ILE A 113      48.541  34.748  27.028  1.00  0.00           C  
ATOM   1772  CD1 ILE A 113      45.722  36.149  27.248  1.00  0.00           C  
ATOM   1773  H   ILE A 113      46.887  35.989  23.597  1.00  0.00           H  
ATOM   1774  HA  ILE A 113      49.238  36.717  25.061  1.00  0.00           H  
ATOM   1775  HB  ILE A 113      47.085  34.598  25.466  1.00  0.00           H  
ATOM   1776 HG12 ILE A 113      47.493  37.284  26.865  1.00  0.00           H  
ATOM   1777 HG13 ILE A 113      46.445  37.075  25.487  1.00  0.00           H  
ATOM   1778 HG21 ILE A 113      47.883  34.507  27.862  1.00  0.00           H  
ATOM   1779 HG22 ILE A 113      49.014  33.819  26.707  1.00  0.00           H  
ATOM   1780 HG23 ILE A 113      49.316  35.434  27.364  1.00  0.00           H  
ATOM   1781 HD11 ILE A 113      45.055  37.000  27.378  1.00  0.00           H  
ATOM   1782 HD12 ILE A 113      45.165  35.328  26.796  1.00  0.00           H  
ATOM   1783 HD13 ILE A 113      46.102  35.856  28.224  1.00  0.00           H  
ATOM   1784  N   ALA A 114      49.264  33.744  23.574  1.00  0.00           N  
ATOM   1785  CA  ALA A 114      50.131  32.692  23.072  1.00  0.00           C  
ATOM   1786  C   ALA A 114      51.219  33.287  22.179  1.00  0.00           C  
ATOM   1787  O   ALA A 114      52.378  32.915  22.305  1.00  0.00           O  
ATOM   1788  CB  ALA A 114      49.306  31.655  22.305  1.00  0.00           C  
ATOM   1789  H   ALA A 114      48.275  33.687  23.352  1.00  0.00           H  
ATOM   1790  HA  ALA A 114      50.609  32.199  23.918  1.00  0.00           H  
ATOM   1791  HB1 ALA A 114      48.538  31.232  22.954  1.00  0.00           H  
ATOM   1792  HB2 ALA A 114      48.833  32.114  21.437  1.00  0.00           H  
ATOM   1793  HB3 ALA A 114      49.961  30.853  21.968  1.00  0.00           H  
ATOM   1794  N   ASP A 115      50.869  34.235  21.311  1.00  0.00           N  
ATOM   1795  CA  ASP A 115      51.821  34.837  20.383  1.00  0.00           C  
ATOM   1796  C   ASP A 115      52.869  35.685  21.108  1.00  0.00           C  
ATOM   1797  O   ASP A 115      54.036  35.648  20.723  1.00  0.00           O  
ATOM   1798  CB  ASP A 115      51.103  35.667  19.319  1.00  0.00           C  
ATOM   1799  CG  ASP A 115      52.099  36.161  18.258  1.00  0.00           C  
ATOM   1800  OD1 ASP A 115      52.643  35.322  17.505  1.00  0.00           O  
ATOM   1801  OD2 ASP A 115      52.293  37.389  18.133  1.00  0.00           O  
ATOM   1802  H   ASP A 115      49.894  34.510  21.246  1.00  0.00           H  
ATOM   1803  HA  ASP A 115      52.342  34.027  19.872  1.00  0.00           H  
ATOM   1804  HB2 ASP A 115      50.346  35.049  18.832  1.00  0.00           H  
ATOM   1805  HB3 ASP A 115      50.601  36.513  19.794  1.00  0.00           H  
ATOM   1806  N   TRP A 116      52.500  36.389  22.189  1.00  0.00           N  
ATOM   1807  CA  TRP A 116      53.475  37.059  23.049  1.00  0.00           C  
ATOM   1808  C   TRP A 116      54.438  36.033  23.653  1.00  0.00           C  
ATOM   1809  O   TRP A 116      55.654  36.230  23.609  1.00  0.00           O  
ATOM   1810  CB  TRP A 116      52.780  37.872  24.155  1.00  0.00           C  
ATOM   1811  CG  TRP A 116      53.688  38.318  25.267  1.00  0.00           C  
ATOM   1812  CD1 TRP A 116      53.681  37.820  26.524  1.00  0.00           C  
ATOM   1813  CD2 TRP A 116      54.808  39.263  25.227  1.00  0.00           C  
ATOM   1814  NE1 TRP A 116      54.706  38.383  27.254  1.00  0.00           N  
ATOM   1815  CE2 TRP A 116      55.440  39.274  26.507  1.00  0.00           C  
ATOM   1816  CE3 TRP A 116      55.377  40.094  24.239  1.00  0.00           C  
ATOM   1817  CZ2 TRP A 116      56.568  40.060  26.790  1.00  0.00           C  
ATOM   1818  CZ3 TRP A 116      56.505  40.894  24.510  1.00  0.00           C  
ATOM   1819  CH2 TRP A 116      57.103  40.877  25.782  1.00  0.00           C  
ATOM   1820  H   TRP A 116      51.525  36.389  22.474  1.00  0.00           H  
ATOM   1821  HA  TRP A 116      54.066  37.743  22.441  1.00  0.00           H  
ATOM   1822  HB2 TRP A 116      52.316  38.752  23.711  1.00  0.00           H  
ATOM   1823  HB3 TRP A 116      51.984  37.270  24.592  1.00  0.00           H  
ATOM   1824  HD1 TRP A 116      53.002  37.059  26.890  1.00  0.00           H  
ATOM   1825  HE1 TRP A 116      54.941  38.113  28.210  1.00  0.00           H  
ATOM   1826  HE3 TRP A 116      54.939  40.117  23.257  1.00  0.00           H  
ATOM   1827  HZ2 TRP A 116      57.029  40.019  27.768  1.00  0.00           H  
ATOM   1828  HZ3 TRP A 116      56.917  41.520  23.729  1.00  0.00           H  
ATOM   1829  HH2 TRP A 116      57.977  41.485  25.980  1.00  0.00           H  
ATOM   1830  N   LEU A 117      53.911  34.929  24.192  1.00  0.00           N  
ATOM   1831  CA  LEU A 117      54.729  33.892  24.816  1.00  0.00           C  
ATOM   1832  C   LEU A 117      55.682  33.282  23.784  1.00  0.00           C  
ATOM   1833  O   LEU A 117      56.874  33.139  24.062  1.00  0.00           O  
ATOM   1834  CB  LEU A 117      53.828  32.814  25.446  1.00  0.00           C  
ATOM   1835  CG  LEU A 117      53.067  33.298  26.697  1.00  0.00           C  
ATOM   1836  CD1 LEU A 117      51.874  32.380  26.983  1.00  0.00           C  
ATOM   1837  CD2 LEU A 117      53.982  33.341  27.926  1.00  0.00           C  
ATOM   1838  H   LEU A 117      52.905  34.801  24.170  1.00  0.00           H  
ATOM   1839  HA  LEU A 117      55.333  34.355  25.598  1.00  0.00           H  
ATOM   1840  HB2 LEU A 117      53.114  32.475  24.697  1.00  0.00           H  
ATOM   1841  HB3 LEU A 117      54.443  31.953  25.717  1.00  0.00           H  
ATOM   1842  HG  LEU A 117      52.680  34.302  26.526  1.00  0.00           H  
ATOM   1843 HD11 LEU A 117      51.180  32.414  26.143  1.00  0.00           H  
ATOM   1844 HD12 LEU A 117      52.211  31.354  27.132  1.00  0.00           H  
ATOM   1845 HD13 LEU A 117      51.350  32.722  27.876  1.00  0.00           H  
ATOM   1846 HD21 LEU A 117      54.364  32.344  28.148  1.00  0.00           H  
ATOM   1847 HD22 LEU A 117      54.821  34.010  27.745  1.00  0.00           H  
ATOM   1848 HD23 LEU A 117      53.419  33.705  28.787  1.00  0.00           H  
ATOM   1849  N   TYR A 118      55.182  32.961  22.588  1.00  0.00           N  
ATOM   1850  CA  TYR A 118      55.978  32.390  21.511  1.00  0.00           C  
ATOM   1851  C   TYR A 118      57.060  33.369  21.066  1.00  0.00           C  
ATOM   1852  O   TYR A 118      58.208  32.957  20.915  1.00  0.00           O  
ATOM   1853  CB  TYR A 118      55.093  32.005  20.313  1.00  0.00           C  
ATOM   1854  CG  TYR A 118      53.999  30.965  20.535  1.00  0.00           C  
ATOM   1855  CD1 TYR A 118      54.066  30.019  21.582  1.00  0.00           C  
ATOM   1856  CD2 TYR A 118      52.900  30.941  19.653  1.00  0.00           C  
ATOM   1857  CE1 TYR A 118      53.041  29.071  21.751  1.00  0.00           C  
ATOM   1858  CE2 TYR A 118      51.873  29.997  19.816  1.00  0.00           C  
ATOM   1859  CZ  TYR A 118      51.937  29.056  20.868  1.00  0.00           C  
ATOM   1860  OH  TYR A 118      50.934  28.144  21.018  1.00  0.00           O  
ATOM   1861  H   TYR A 118      54.187  33.082  22.425  1.00  0.00           H  
ATOM   1862  HA  TYR A 118      56.478  31.497  21.884  1.00  0.00           H  
ATOM   1863  HB2 TYR A 118      54.625  32.914  19.931  1.00  0.00           H  
ATOM   1864  HB3 TYR A 118      55.746  31.626  19.523  1.00  0.00           H  
ATOM   1865  HD1 TYR A 118      54.897  30.011  22.270  1.00  0.00           H  
ATOM   1866  HD2 TYR A 118      52.841  31.655  18.843  1.00  0.00           H  
ATOM   1867  HE1 TYR A 118      53.105  28.356  22.561  1.00  0.00           H  
ATOM   1868  HE2 TYR A 118      51.033  29.993  19.134  1.00  0.00           H  
ATOM   1869  HH  TYR A 118      51.072  27.538  21.764  1.00  0.00           H  
ATOM   1870  N   TRP A 119      56.734  34.655  20.895  1.00  0.00           N  
ATOM   1871  CA  TRP A 119      57.706  35.677  20.536  1.00  0.00           C  
ATOM   1872  C   TRP A 119      58.810  35.740  21.589  1.00  0.00           C  
ATOM   1873  O   TRP A 119      59.991  35.717  21.245  1.00  0.00           O  
ATOM   1874  CB  TRP A 119      57.007  37.038  20.405  1.00  0.00           C  
ATOM   1875  CG  TRP A 119      57.928  38.221  20.411  1.00  0.00           C  
ATOM   1876  CD1 TRP A 119      58.217  38.976  21.496  1.00  0.00           C  
ATOM   1877  CD2 TRP A 119      58.713  38.781  19.316  1.00  0.00           C  
ATOM   1878  NE1 TRP A 119      59.129  39.953  21.155  1.00  0.00           N  
ATOM   1879  CE2 TRP A 119      59.458  39.892  19.818  1.00  0.00           C  
ATOM   1880  CE3 TRP A 119      58.867  38.468  17.947  1.00  0.00           C  
ATOM   1881  CZ2 TRP A 119      60.298  40.658  18.997  1.00  0.00           C  
ATOM   1882  CZ3 TRP A 119      59.716  39.226  17.118  1.00  0.00           C  
ATOM   1883  CH2 TRP A 119      60.429  40.319  17.640  1.00  0.00           C  
ATOM   1884  H   TRP A 119      55.774  34.955  21.039  1.00  0.00           H  
ATOM   1885  HA  TRP A 119      58.159  35.419  19.578  1.00  0.00           H  
ATOM   1886  HB2 TRP A 119      56.428  37.048  19.481  1.00  0.00           H  
ATOM   1887  HB3 TRP A 119      56.309  37.164  21.232  1.00  0.00           H  
ATOM   1888  HD1 TRP A 119      57.806  38.821  22.486  1.00  0.00           H  
ATOM   1889  HE1 TRP A 119      59.521  40.624  21.829  1.00  0.00           H  
ATOM   1890  HE3 TRP A 119      58.320  37.634  17.531  1.00  0.00           H  
ATOM   1891  HZ2 TRP A 119      60.829  41.506  19.403  1.00  0.00           H  
ATOM   1892  HZ3 TRP A 119      59.818  38.968  16.072  1.00  0.00           H  
ATOM   1893  HH2 TRP A 119      61.073  40.905  16.998  1.00  0.00           H  
ATOM   1894  N   LEU A 120      58.436  35.786  22.869  1.00  0.00           N  
ATOM   1895  CA  LEU A 120      59.390  35.983  23.948  1.00  0.00           C  
ATOM   1896  C   LEU A 120      60.359  34.803  23.995  1.00  0.00           C  
ATOM   1897  O   LEU A 120      61.570  34.996  24.114  1.00  0.00           O  
ATOM   1898  CB  LEU A 120      58.624  36.153  25.270  1.00  0.00           C  
ATOM   1899  CG  LEU A 120      59.525  36.546  26.452  1.00  0.00           C  
ATOM   1900  CD1 LEU A 120      60.146  37.933  26.251  1.00  0.00           C  
ATOM   1901  CD2 LEU A 120      58.696  36.548  27.739  1.00  0.00           C  
ATOM   1902  H   LEU A 120      57.449  35.752  23.104  1.00  0.00           H  
ATOM   1903  HA  LEU A 120      59.948  36.892  23.725  1.00  0.00           H  
ATOM   1904  HB2 LEU A 120      57.861  36.923  25.143  1.00  0.00           H  
ATOM   1905  HB3 LEU A 120      58.117  35.214  25.504  1.00  0.00           H  
ATOM   1906  HG  LEU A 120      60.324  35.812  26.566  1.00  0.00           H  
ATOM   1907 HD11 LEU A 120      60.819  37.920  25.396  1.00  0.00           H  
ATOM   1908 HD12 LEU A 120      59.366  38.676  26.077  1.00  0.00           H  
ATOM   1909 HD13 LEU A 120      60.722  38.215  27.132  1.00  0.00           H  
ATOM   1910 HD21 LEU A 120      57.883  37.271  27.659  1.00  0.00           H  
ATOM   1911 HD22 LEU A 120      58.278  35.556  27.909  1.00  0.00           H  
ATOM   1912 HD23 LEU A 120      59.327  36.811  28.588  1.00  0.00           H  
ATOM   1913  N   ALA A 121      59.831  33.587  23.836  1.00  0.00           N  
ATOM   1914  CA  ALA A 121      60.611  32.363  23.778  1.00  0.00           C  
ATOM   1915  C   ALA A 121      61.493  32.295  22.520  1.00  0.00           C  
ATOM   1916  O   ALA A 121      62.632  31.833  22.598  1.00  0.00           O  
ATOM   1917  CB  ALA A 121      59.632  31.188  23.841  1.00  0.00           C  
ATOM   1918  H   ALA A 121      58.825  33.503  23.726  1.00  0.00           H  
ATOM   1919  HA  ALA A 121      61.261  32.323  24.654  1.00  0.00           H  
ATOM   1920  HB1 ALA A 121      59.119  31.192  24.803  1.00  0.00           H  
ATOM   1921  HB2 ALA A 121      58.884  31.290  23.052  1.00  0.00           H  
ATOM   1922  HB3 ALA A 121      60.171  30.247  23.724  1.00  0.00           H  
ATOM   1923  N   ARG A 122      61.000  32.767  21.368  1.00  0.00           N  
ATOM   1924  CA  ARG A 122      61.757  32.821  20.112  1.00  0.00           C  
ATOM   1925  C   ARG A 122      62.924  33.808  20.206  1.00  0.00           C  
ATOM   1926  O   ARG A 122      63.917  33.621  19.501  1.00  0.00           O  
ATOM   1927  CB  ARG A 122      60.796  33.193  18.965  1.00  0.00           C  
ATOM   1928  CG  ARG A 122      61.384  33.231  17.544  1.00  0.00           C  
ATOM   1929  CD  ARG A 122      61.967  31.893  17.065  1.00  0.00           C  
ATOM   1930  NE  ARG A 122      63.384  31.739  17.434  1.00  0.00           N  
ATOM   1931  CZ  ARG A 122      64.235  30.854  16.906  1.00  0.00           C  
ATOM   1932  NH1 ARG A 122      63.803  29.893  16.092  1.00  0.00           N  
ATOM   1933  NH2 ARG A 122      65.528  30.941  17.200  1.00  0.00           N  
ATOM   1934  H   ARG A 122      60.039  33.097  21.350  1.00  0.00           H  
ATOM   1935  HA  ARG A 122      62.167  31.826  19.931  1.00  0.00           H  
ATOM   1936  HB2 ARG A 122      59.970  32.481  18.959  1.00  0.00           H  
ATOM   1937  HB3 ARG A 122      60.374  34.177  19.168  1.00  0.00           H  
ATOM   1938  HG2 ARG A 122      60.573  33.502  16.866  1.00  0.00           H  
ATOM   1939  HG3 ARG A 122      62.137  34.016  17.465  1.00  0.00           H  
ATOM   1940  HD2 ARG A 122      61.385  31.068  17.478  1.00  0.00           H  
ATOM   1941  HD3 ARG A 122      61.890  31.863  15.977  1.00  0.00           H  
ATOM   1942  HE  ARG A 122      63.747  32.440  18.079  1.00  0.00           H  
ATOM   1943 HH11 ARG A 122      62.805  29.783  15.895  1.00  0.00           H  
ATOM   1944 HH12 ARG A 122      64.436  29.250  15.638  1.00  0.00           H  
ATOM   1945 HH21 ARG A 122      65.873  31.669  17.814  1.00  0.00           H  
ATOM   1946 HH22 ARG A 122      66.219  30.338  16.778  1.00  0.00           H  
ATOM   1947  N   GLY A 123      62.834  34.822  21.064  1.00  0.00           N  
ATOM   1948  CA  GLY A 123      63.910  35.764  21.319  1.00  0.00           C  
ATOM   1949  C   GLY A 123      63.340  37.091  21.800  1.00  0.00           C  
ATOM   1950  O   GLY A 123      62.516  37.701  21.117  1.00  0.00           O  
ATOM   1951  H   GLY A 123      62.014  34.887  21.655  1.00  0.00           H  
ATOM   1952  HA2 GLY A 123      64.576  35.343  22.074  1.00  0.00           H  
ATOM   1953  HA3 GLY A 123      64.485  35.939  20.409  1.00  0.00           H  
ATOM   1954  N   TYR A 124      63.802  37.560  22.959  1.00  0.00           N  
ATOM   1955  CA  TYR A 124      63.464  38.866  23.516  1.00  0.00           C  
ATOM   1956  C   TYR A 124      64.244  39.958  22.769  1.00  0.00           C  
ATOM   1957  O   TYR A 124      65.175  40.564  23.304  1.00  0.00           O  
ATOM   1958  CB  TYR A 124      63.745  38.842  25.027  1.00  0.00           C  
ATOM   1959  CG  TYR A 124      63.427  40.126  25.775  1.00  0.00           C  
ATOM   1960  CD1 TYR A 124      62.131  40.677  25.733  1.00  0.00           C  
ATOM   1961  CD2 TYR A 124      64.428  40.759  26.537  1.00  0.00           C  
ATOM   1962  CE1 TYR A 124      61.822  41.827  26.478  1.00  0.00           C  
ATOM   1963  CE2 TYR A 124      64.135  41.924  27.267  1.00  0.00           C  
ATOM   1964  CZ  TYR A 124      62.824  42.451  27.258  1.00  0.00           C  
ATOM   1965  OH  TYR A 124      62.538  43.542  28.016  1.00  0.00           O  
ATOM   1966  H   TYR A 124      64.482  37.018  23.474  1.00  0.00           H  
ATOM   1967  HA  TYR A 124      62.397  39.041  23.367  1.00  0.00           H  
ATOM   1968  HB2 TYR A 124      63.159  38.040  25.476  1.00  0.00           H  
ATOM   1969  HB3 TYR A 124      64.796  38.592  25.181  1.00  0.00           H  
ATOM   1970  HD1 TYR A 124      61.356  40.215  25.137  1.00  0.00           H  
ATOM   1971  HD2 TYR A 124      65.430  40.351  26.569  1.00  0.00           H  
ATOM   1972  HE1 TYR A 124      60.815  42.223  26.445  1.00  0.00           H  
ATOM   1973  HE2 TYR A 124      64.909  42.398  27.854  1.00  0.00           H  
ATOM   1974  HH  TYR A 124      61.577  43.706  28.062  1.00  0.00           H  
ATOM   1975  N   LYS A 125      63.923  40.171  21.488  1.00  0.00           N  
ATOM   1976  CA  LYS A 125      64.536  41.232  20.687  1.00  0.00           C  
ATOM   1977  C   LYS A 125      64.040  42.592  21.179  1.00  0.00           C  
ATOM   1978  O   LYS A 125      64.818  43.545  21.246  1.00  0.00           O  
ATOM   1979  CB  LYS A 125      64.203  41.038  19.197  1.00  0.00           C  
ATOM   1980  CG  LYS A 125      64.797  39.741  18.622  1.00  0.00           C  
ATOM   1981  CD  LYS A 125      64.447  39.566  17.138  1.00  0.00           C  
ATOM   1982  CE  LYS A 125      65.116  38.296  16.594  1.00  0.00           C  
ATOM   1983  NZ  LYS A 125      64.847  38.083  15.151  1.00  0.00           N  
ATOM   1984  H   LYS A 125      63.143  39.678  21.081  1.00  0.00           H  
ATOM   1985  HA  LYS A 125      65.620  41.195  20.815  1.00  0.00           H  
ATOM   1986  HB2 LYS A 125      63.122  41.030  19.064  1.00  0.00           H  
ATOM   1987  HB3 LYS A 125      64.606  41.884  18.638  1.00  0.00           H  
ATOM   1988  HG2 LYS A 125      65.883  39.771  18.735  1.00  0.00           H  
ATOM   1989  HG3 LYS A 125      64.412  38.882  19.174  1.00  0.00           H  
ATOM   1990  HD2 LYS A 125      63.364  39.486  17.027  1.00  0.00           H  
ATOM   1991  HD3 LYS A 125      64.802  40.434  16.580  1.00  0.00           H  
ATOM   1992  HE2 LYS A 125      66.194  38.377  16.749  1.00  0.00           H  
ATOM   1993  HE3 LYS A 125      64.755  37.434  17.160  1.00  0.00           H  
ATOM   1994  HZ1 LYS A 125      63.859  37.889  14.973  1.00  0.00           H  
ATOM   1995  HZ2 LYS A 125      65.118  38.884  14.602  1.00  0.00           H  
ATOM   1996  HZ3 LYS A 125      65.364  37.287  14.809  1.00  0.00           H  
ATOM   1997  N   PHE A 126      62.759  42.668  21.538  1.00  0.00           N  
ATOM   1998  CA  PHE A 126      62.063  43.783  22.158  1.00  0.00           C  
ATOM   1999  C   PHE A 126      60.775  43.204  22.761  1.00  0.00           C  
ATOM   2000  O   PHE A 126      60.080  43.937  23.494  1.00  0.00           O  
ATOM   2001  CB  PHE A 126      61.780  44.902  21.136  1.00  0.00           C  
ATOM   2002  CG  PHE A 126      61.196  44.468  19.801  1.00  0.00           C  
ATOM   2003  CD1 PHE A 126      59.805  44.310  19.648  1.00  0.00           C  
ATOM   2004  CD2 PHE A 126      62.045  44.248  18.697  1.00  0.00           C  
ATOM   2005  CE1 PHE A 126      59.269  43.959  18.396  1.00  0.00           C  
ATOM   2006  CE2 PHE A 126      61.510  43.870  17.454  1.00  0.00           C  
ATOM   2007  CZ  PHE A 126      60.119  43.732  17.299  1.00  0.00           C  
ATOM   2008  OXT PHE A 126      60.485  42.009  22.515  1.00  0.00           O  
ATOM   2009  H   PHE A 126      62.185  41.834  21.491  1.00  0.00           H  
ATOM   2010  HA  PHE A 126      62.681  44.185  22.962  1.00  0.00           H  
ATOM   2011  HB2 PHE A 126      61.108  45.628  21.593  1.00  0.00           H  
ATOM   2012  HB3 PHE A 126      62.716  45.427  20.944  1.00  0.00           H  
ATOM   2013  HD1 PHE A 126      59.147  44.473  20.490  1.00  0.00           H  
ATOM   2014  HD2 PHE A 126      63.115  44.364  18.806  1.00  0.00           H  
ATOM   2015  HE1 PHE A 126      58.202  43.860  18.274  1.00  0.00           H  
ATOM   2016  HE2 PHE A 126      62.173  43.674  16.620  1.00  0.00           H  
ATOM   2017  HZ  PHE A 126      59.704  43.440  16.343  1.00  0.00           H  
TER    2018      PHE A 126                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
