
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   69 (  544),  selected   69 , name 1wyx_B
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 1wyx_B.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     1_B      S     178           -
LGA    L     2_B      L     179           -
LGA    -       -      E     180           -
LGA    -       -      A     181           -
LGA    -       -      W     182           -
LGA    -       -      L     183           -
LGA    -       -      A     184           -
LGA    -       -      Q     185           -
LGA    -       -      G     186           -
LGA    -       -      H     187           -
LGA    -       -      P     188           -
LGA    N     3_B      L     189          5.660
LGA    V     4_B      P     190          1.829
LGA    L     5_B      K     191          3.273
LGA    -       -      R     192           -
LGA    A     6_B      V     193          1.039
LGA    K     7_B      R     194          0.900
LGA    A     8_B      N     195          0.859
LGA    L     9_B      A     196          1.319
LGA    Y    10_B      Y     197          1.383
LGA    D    11_B      -       -           -
LGA    N    12_B      -       -           -
LGA    V    13_B      -       -           -
LGA    A    14_B      -       -           -
LGA    E    15_B      -       -           -
LGA    S    16_B      -       -           -
LGA    P    17_B      -       -           -
LGA    D    18_B      -       -           -
LGA    E    19_B      -       -           -
LGA    L    20_B      -       -           -
LGA    S    21_B      -       -           -
LGA    F    22_B      -       -           -
LGA    R    23_B      -       -           -
LGA    K    24_B      D     198          1.502
LGA    G    25_B      R     199          0.770
LGA    D    26_B      R     200          1.300
LGA    I    27_B      T     201          1.327
LGA    M    28_B      W     202          0.864
LGA    T    29_B      E     203          1.472
LGA    V    30_B      L     204          1.368
LGA    L    31_B      L     205          1.071
LGA    E    32_B      R     206          1.352
LGA    Q    33_B      L     207          1.605
LGA    D    34_B      G     208          2.814
LGA    T    35_B      -       -           -
LGA    Q    36_B      E     209          3.997
LGA    G    37_B      E     210          2.838
LGA    L    38_B      D     211          2.968
LGA    D    39_B      P     212          5.542
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    G    40_B      R     240          1.693
LGA    W    41_B      V     241          1.336
LGA    W    42_B      A     242          0.610
LGA    L    43_B      W     243          0.349
LGA    C    44_B      V     244          0.488
LGA    S    45_B      A     245          0.553
LGA    L    46_B      D     246          1.250
LGA    H    47_B      P     247          2.209
LGA    G    48_B      K     248          3.683
LGA    -       -      D     249           -
LGA    -       -      P     250           -
LGA    -       -      R     251           -
LGA    R    49_B      K     252          4.044
LGA    Q    50_B      P     253          1.854
LGA    G    51_B      I     254          0.674
LGA    I    52_B      P     255          0.395
LGA    V    53_B      H     256          0.594
LGA    P    54_B      L     257          1.831
LGA    G    55_B      T     258          1.581
LGA    N    56_B      G     259          1.356
LGA    R    57_B      L     260          1.359
LGA    L    58_B      L     261          0.789
LGA    K    59_B      V     262          0.509
LGA    I    60_B      P     263          1.014
LGA    L    61_B      V     264          1.539
LGA    V    62_B      L     265          2.166
LGA    G    63_B      -       -           -
LGA    M    64_B      -       -           -
LGA    Y    65_B      -       -           -
LGA    D    66_B      -       -           -
LGA    K    67_B      -       -           -
LGA    K    68_B      -       -           -
LGA    P    69_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   69   88    5.0     46    2.11     6.52     47.452     2.078

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.148636 * X  +  -0.597834 * Y  +  -0.787719 * Z  +  71.139191
  Y_new =  -0.261870 * X  +  -0.791926 * Y  +   0.551614 * Z  +  27.034794
  Z_new =  -0.953589 * X  +   0.124290 * Y  +  -0.274263 * Z  +  53.079048 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.716098   -0.425495  [ DEG:   155.6209    -24.3791 ]
  Theta =   1.264938    1.876655  [ DEG:    72.4756    107.5244 ]
  Phi   =  -1.054546    2.087047  [ DEG:   -60.4210    119.5790 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wyx_B                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wyx_B.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   69   88   5.0   46   2.11    6.52  47.452
REMARK  ---------------------------------------------------------- 
MOLECULE 1wyx_B
HEADER    CELL ADHESION                           17-FEB-05   1WYX              
TITLE     THE CRYSTAL STRUCTURE OF THE P130CAS SH3 DOMAIN AT 1.1 A              
TITLE    2 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CRK-ASSOCIATED SUBSTRATE;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 SYNONYM: CRK-ASSOCIATED TYROSINE KINASE SUBSTRATE P130CAS,           
COMPND   6 CAS, P130CAS, BREAST CANCER ANTI-ESTROGEN RESISTANCE 1               
COMPND   7 PROTEIN;                                                             
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    BETA SHEETS                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.WISNIEWSKA,B.BOSSENMAIER,G.GEORGES,F.HESSE,M.DANGL,                 
AUTHOR   2 K.P.KUENKELE,I.IOANNIDIS,R.HUBER,R.A.ENGH                            
REVDAT   1   26-APR-05 1WYX    0                                                
JRNL        AUTH   M.WISNIEWSKA,B.BOSSENMAIER,G.GEORGES,F.HESSE,                
JRNL        AUTH 2 M.DANGL,K.P.KUNKELE,I.IOANNIDIS,R.HUBER,R.A.ENGH             
JRNL        TITL   THE 1.1 A RESOLUTION CRYSTAL STRUCTURE OF THE                
JRNL        TITL 2 P130CAS SH3 DOMAIN AND RAMIFICATIONS FOR LIGAND              
JRNL        TITL 3 SELECTIVITY                                                  
JRNL        REF    J.MOL.BIOL.                   V. 347  1005 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.14 ANGSTROMS.                                          
DBREF  1WYX A    1    69  UNP    P56945   BCA1_HUMAN       3     71             
DBREF  1WYX B    1    69  UNP    P56945   BCA1_HUMAN       3     71             
SEQRES   1 A   69  HIS LEU ASN VAL LEU ALA LYS ALA LEU TYR ASP ASN VAL          
SEQRES   2 A   69  ALA GLU SER PRO ASP GLU LEU SER PHE ARG LYS GLY ASP          
SEQRES   3 A   69  ILE MET THR VAL LEU GLU GLN ASP THR GLN GLY LEU ASP          
SEQRES   4 A   69  GLY TRP TRP LEU CYS SER LEU HIS GLY ARG GLN GLY ILE          
SEQRES   5 A   69  VAL PRO GLY ASN ARG LEU LYS ILE LEU VAL GLY MET TYR          
SEQRES   6 A   69  ASP LYS LYS PRO                                              
SEQRES   1 B   69  HIS LEU ASN VAL LEU ALA LYS ALA LEU TYR ASP ASN VAL          
SEQRES   2 B   69  ALA GLU SER PRO ASP GLU LEU SER PHE ARG LYS GLY ASP          
SEQRES   3 B   69  ILE MET THR VAL LEU GLU GLN ASP THR GLN GLY LEU ASP          
SEQRES   4 B   69  GLY TRP TRP LEU CYS SER LEU HIS GLY ARG GLN GLY ILE          
SEQRES   5 B   69  VAL PRO GLY ASN ARG LEU LYS ILE LEU VAL GLY MET TYR          
SEQRES   6 B   69  ASP LYS LYS PRO                                              
HET     MG    181       1                                                       
HET    EDO    177       4                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   3   MG    MG 2+                                                        
FORMUL   4  EDO    C2 H6 O2                                                     
FORMUL   5  HOH   *165(H2 O)                                                    
CRYST1   38.071   56.193   37.924  90.00 116.22  90.00 P 1 21 1      4          
ATOM    536  N   HIS B   1      31.505  43.897  32.280  1.00 21.77           N  
ATOM    537  CA  HIS B   1      30.816  42.617  32.602  1.00 19.82           C  
ATOM    538  C   HIS B   1      31.790  41.559  33.146  1.00 17.52           C  
ATOM    539  O   HIS B   1      31.648  41.102  34.282  1.00 18.20           O  
ATOM    540  CB  HIS B   1      30.076  42.090  31.361  1.00 21.22           C  
ATOM    541  CG  HIS B   1      29.269  40.851  31.606  1.00 24.32           C  
ATOM    542  ND1 HIS B   1      28.662  40.145  30.586  1.00 26.97           N  
ATOM    543  CD2 HIS B   1      28.966  40.190  32.748  1.00 26.52           C  
ATOM    544  CE1 HIS B   1      28.026  39.102  31.091  1.00 27.70           C  
ATOM    545  NE2 HIS B   1      28.192  39.108  32.401  1.00 28.44           N  
ATOM    546  N   LEU B   2      32.778  41.193  32.336  1.00 14.58           N  
ATOM    547  CA  LEU B   2      33.621  40.039  32.599  1.00 12.54           C  
ATOM    548  C   LEU B   2      35.089  40.416  32.584  1.00 11.61           C  
ATOM    549  O   LEU B   2      35.521  41.212  31.748  1.00 12.20           O  
ATOM    550  CB  LEU B   2      33.379  39.001  31.512  1.00 12.79           C  
ATOM    551  CG  LEU B   2      31.980  38.416  31.424  1.00 14.16           C  
ATOM    552  CD1 LEU B   2      31.900  37.469  30.241  1.00 15.25           C  
ATOM    553  CD2 LEU B   2      31.603  37.704  32.717  1.00 15.01           C  
ATOM    554  N   ASN B   3      35.831  39.820  33.510  1.00 10.59           N  
ATOM    555  CA  ASN B   3      37.283  39.871  33.529  1.00  9.83           C  
ATOM    556  C   ASN B   3      37.887  38.564  33.053  1.00  9.36           C  
ATOM    557  O   ASN B   3      37.387  37.479  33.363  1.00 10.11           O  
ATOM    558  CB  ASN B   3      37.795  40.173  34.940  1.00 10.90           C  
ATOM    559  CG  ASN B   3      37.619  41.636  35.332  1.00 13.15           C  
ATOM    560  OD1 ASN B   3      37.693  42.515  34.495  1.00 14.65           O  
ATOM    561  ND2 ASN B   3      37.399  41.887  36.617  1.00 16.43           N  
ATOM    562  N   VAL B   4      38.986  38.687  32.309  1.00  9.06           N  
ATOM    563  CA  VAL B   4      39.842  37.573  31.925  1.00  9.21           C  
ATOM    564  C   VAL B   4      40.352  36.814  33.150  1.00  8.62           C  
ATOM    565  O   VAL B   4      40.672  37.409  34.175  1.00  9.09           O  
ATOM    566  CB  VAL B   4      41.023  38.137  31.087  1.00 10.11           C  
ATOM    567  CG1 VAL B   4      42.107  37.110  30.870  1.00 10.89           C  
ATOM    568  CG2 VAL B   4      40.506  38.675  29.760  1.00 11.14           C  
ATOM    569  N   LEU B   5      40.396  35.494  33.028  1.00  9.45           N  
ATOM    570  CA  LEU B   5      41.078  34.631  33.987  1.00  9.91           C  
ATOM    571  C   LEU B   5      42.381  34.168  33.351  1.00  9.68           C  
ATOM    572  O   LEU B   5      42.442  33.918  32.135  1.00 10.19           O  
ATOM    573  CB  LEU B   5      40.246  33.412  34.368  1.00 10.59           C  
ATOM    574  CG  LEU B   5      39.035  33.637  35.281  1.00 11.89           C  
ATOM    575  CD1 LEU B   5      38.156  32.409  35.343  1.00 13.72           C  
ATOM    576  CD2 LEU B   5      39.504  33.967  36.680  1.00 14.56           C  
ATOM    577  N   ALA B   6      43.412  34.029  34.182  1.00  9.25           N  
ATOM    578  CA  ALA B   6      44.725  33.606  33.729  1.00  9.39           C  
ATOM    579  C   ALA B   6      45.291  32.592  34.709  1.00  9.15           C  
ATOM    580  O   ALA B   6      45.010  32.649  35.920  1.00 11.15           O  
ATOM    581  CB  ALA B   6      45.652  34.783  33.624  1.00 10.31           C  
ATOM    582  N   LYS B   7      46.104  31.680  34.178  1.00  9.28           N  
ATOM    583  CA  LYS B   7      46.754  30.649  34.976  1.00  9.77           C  
ATOM    584  C   LYS B   7      48.252  30.901  34.981  1.00  9.06           C  
ATOM    585  O   LYS B   7      48.862  31.170  33.948  1.00  9.10           O  
ATOM    586  CB  LYS B   7      46.455  29.270  34.400  1.00 10.61           C  
ATOM    587  CG  LYS B   7      47.043  28.092  35.170  1.00 13.14           C  
ATOM    588  CD  LYS B   7      46.553  26.806  34.515  1.00 17.03           C  
ATOM    589  CE  LYS B   7      46.990  25.543  35.204  1.00 19.11           C  
ATOM    590  NZ  LYS B   7      46.329  24.384  34.551  1.00 21.72           N  
ATOM    591  N   ALA B   8      48.846  30.793  36.162  1.00  8.86           N  
ATOM    592  CA  ALA B   8      50.279  30.940  36.334  1.00  9.17           C  
ATOM    593  C   ALA B   8      51.028  29.765  35.701  1.00  9.88           C  
ATOM    594  O   ALA B   8      50.754  28.607  35.990  1.00 10.74           O  
ATOM    595  CB  ALA B   8      50.613  31.023  37.807  1.00  9.74           C  
ATOM    596  N   LEU B   9      51.985  30.097  34.850  1.00 10.45           N  
ATOM    597  CA  LEU B   9      52.907  29.134  34.223  1.00 11.97           C  
ATOM    598  C   LEU B   9      54.129  28.849  35.082  1.00 11.83           C  
ATOM    599  O   LEU B   9      54.855  27.896  34.821  1.00 12.44           O  
ATOM    600  CB  LEU B   9      53.380  29.704  32.890  1.00 13.51           C  
ATOM    601  CG  LEU B   9      52.285  30.006  31.875  1.00 16.60           C  
ATOM    602  CD1 LEU B   9      52.830  30.792  30.708  1.00 17.76           C  
ATOM    603  CD2 LEU B   9      51.680  28.730  31.424  1.00 18.52           C  
ATOM    604  N   TYR B  10      54.373  29.716  36.059  1.00 11.74           N  
ATOM    605  CA  TYR B  10      55.562  29.681  36.900  1.00 12.62           C  
ATOM    606  C   TYR B  10      55.189  30.175  38.287  1.00 12.32           C  
ATOM    607  O   TYR B  10      54.164  30.846  38.468  1.00 13.01           O  
ATOM    608  CB  TYR B  10      56.632  30.617  36.328  1.00 13.64           C  
ATOM    609  CG  TYR B  10      56.993  30.370  34.881  1.00 14.98           C  
ATOM    610  CD1 TYR B  10      56.435  31.119  33.852  1.00 17.49           C  
ATOM    611  CD2 TYR B  10      57.917  29.390  34.546  1.00 17.50           C  
ATOM    612  CE1 TYR B  10      56.779  30.883  32.521  1.00 19.38           C  
ATOM    613  CE2 TYR B  10      58.259  29.147  33.232  1.00 19.15           C  
ATOM    614  CZ  TYR B  10      57.694  29.894  32.224  1.00 19.55           C  
ATOM    615  OH  TYR B  10      58.049  29.653  30.913  1.00 22.73           O  
ATOM    616  N   ASP B  11      56.033  29.870  39.265  1.00 12.61           N  
ATOM    617  CA  ASP B  11      55.994  30.540  40.558  1.00 13.32           C  
ATOM    618  C   ASP B  11      56.399  31.994  40.394  1.00 13.18           C  
ATOM    619  O   ASP B  11      57.103  32.358  39.465  1.00 13.51           O  
ATOM    620  CB  ASP B  11      56.993  29.914  41.545  1.00 13.68           C  
ATOM    621  CG  ASP B  11      56.575  28.568  42.057  1.00 14.09           C  
ATOM    622  OD1 ASP B  11      57.316  28.019  42.927  1.00 16.28           O  
ATOM    623  OD2 ASP B  11      55.555  27.966  41.673  1.00 14.83           O  
ATOM    624  N   ASN B  12      55.977  32.820  41.345  1.00 14.00           N  
ATOM    625  CA  ASN B  12      56.363  34.206  41.412  1.00 14.09           C  
ATOM    626  C   ASN B  12      56.509  34.616  42.870  1.00 14.05           C  
ATOM    627  O   ASN B  12      55.569  34.494  43.646  1.00 14.22           O  
ATOM    628  CB  ASN B  12      55.335  35.077  40.708  1.00 14.42           C  
ATOM    629  CG  ASN B  12      55.834  36.479  40.478  1.00 15.37           C  
ATOM    630  OD1 ASN B  12      56.715  36.708  39.645  1.00 18.08           O  
ATOM    631  ND2 ASN B  12      55.269  37.435  41.191  1.00 16.00           N  
ATOM    632  N   VAL B  13      57.702  35.067  43.239  1.00 13.76           N  
ATOM    633  CA  VAL B  13      58.001  35.511  44.592  1.00 14.12           C  
ATOM    634  C   VAL B  13      58.046  37.036  44.582  1.00 14.22           C  
ATOM    635  O   VAL B  13      58.943  37.636  44.007  1.00 14.50           O  
ATOM    636  CB  VAL B  13      59.337  34.917  45.105  1.00 14.58           C  
ATOM    637  CG1 VAL B  13      59.768  35.573  46.417  1.00 15.79           C  
ATOM    638  CG2 VAL B  13      59.232  33.408  45.277  1.00 15.70           C  
ATOM    639  N   ALA B  14      57.055  37.661  45.212  1.00 13.65           N  
ATOM    640  CA  ALA B  14      56.916  39.114  45.216  1.00 14.53           C  
ATOM    641  C   ALA B  14      58.194  39.791  45.668  1.00 15.31           C  
ATOM    642  O   ALA B  14      58.770  39.407  46.677  1.00 15.36           O  
ATOM    643  CB  ALA B  14      55.768  39.524  46.123  1.00 14.65           C  
ATOM    644  N   GLU B  15      58.608  40.794  44.911  1.00 16.48           N  
ATOM    645  CA  GLU B  15      59.792  41.578  45.229  1.00 17.80           C  
ATOM    646  C   GLU B  15      59.433  42.835  46.001  1.00 17.59           C  
ATOM    647  O   GLU B  15      60.323  43.523  46.497  1.00 18.77           O  
ATOM    648  CB  GLU B  15      60.525  41.948  43.943  1.00 18.91           C  
ATOM    649  CG  GLU B  15      62.030  42.065  44.070  1.00 21.98           C  
ATOM    650  CD  GLU B  15      62.700  42.063  42.714  1.00 25.67           C  
ATOM    651  OE1 GLU B  15      62.613  43.088  42.007  1.00 28.86           O  
ATOM    652  OE2 GLU B  15      63.289  41.027  42.346  1.00 28.46           O  
ATOM    653  N   SER B  16      58.139  43.146  46.069  1.00 17.12           N  
ATOM    654  CA  SER B  16      57.625  44.284  46.824  1.00 16.53           C  
ATOM    655  C   SER B  16      56.203  43.975  47.281  1.00 16.12           C  
ATOM    656  O   SER B  16      55.582  43.077  46.731  1.00 15.80           O  
ATOM    657  CB  SER B  16      57.604  45.538  45.957  1.00 17.00           C  
ATOM    658  OG  SER B  16      56.562  45.467  44.999  1.00 18.04           O  
ATOM    659  N   PRO B  17      55.677  44.696  48.266  1.00 15.27           N  
ATOM    660  CA  PRO B  17      54.308  44.442  48.725  1.00 14.64           C  
ATOM    661  C   PRO B  17      53.210  44.680  47.666  1.00 13.94           C  
ATOM    662  O   PRO B  17      52.129  44.132  47.813  1.00 13.88           O  
ATOM    663  CB  PRO B  17      54.158  45.381  49.925  1.00 14.72           C  
ATOM    664  CG  PRO B  17      55.556  45.667  50.340  1.00 15.77           C  
ATOM    665  CD  PRO B  17      56.349  45.722  49.090  1.00 15.24           C  
ATOM    666  N   ASP B  18      53.483  45.459  46.620  1.00 13.61           N  
ATOM    667  CA  ASP B  18      52.515  45.667  45.532  1.00 13.11           C  
ATOM    668  C   ASP B  18      52.385  44.504  44.579  1.00 12.35           C  
ATOM    669  O   ASP B  18      51.478  44.507  43.731  1.00 12.45           O  
ATOM    670  CB  ASP B  18      52.918  46.853  44.673  1.00 14.04           C  
ATOM    671  CG  ASP B  18      52.692  48.126  45.333  1.00 15.95           C  
ATOM    672  OD1 ASP B  18      51.966  48.150  46.337  1.00 16.67           O  
ATOM    673  OD2 ASP B  18      53.197  49.161  44.891  1.00 18.42           O  
ATOM    674  N   GLU B  19      53.308  43.561  44.658  1.00 12.84           N  
ATOM    675  CA  GLU B  19      53.344  42.431  43.743  1.00 12.34           C  
ATOM    676  C   GLU B  19      52.721  41.213  44.418  1.00 11.68           C  
ATOM    677  O   GLU B  19      52.952  40.971  45.610  1.00 12.10           O  
ATOM    678  CB  GLU B  19      54.807  42.126  43.358  1.00 13.31           C  
ATOM    679  CG  GLU B  19      54.943  41.014  42.328  1.00 14.31           C  
ATOM    680  CD  GLU B  19      56.364  40.784  41.823  1.00 15.21           C  
ATOM    681  OE1 GLU B  19      56.499  39.993  40.873  1.00 15.44           O  
ATOM    682  OE2 GLU B  19      57.329  41.390  42.349  1.00 17.82           O  
ATOM    683  N   LEU B  20      51.956  40.432  43.654  1.00 11.13           N  
ATOM    684  CA  LEU B  20      51.458  39.163  44.162  1.00 11.27           C  
ATOM    685  C   LEU B  20      52.533  38.084  44.130  1.00 11.33           C  
ATOM    686  O   LEU B  20      53.324  38.003  43.188  1.00 13.19           O  
ATOM    687  CB  LEU B  20      50.311  38.644  43.318  1.00 11.33           C  
ATOM    688  CG  LEU B  20      48.971  39.363  43.432  1.00 11.61           C  
ATOM    689  CD1 LEU B  20      47.986  38.671  42.467  1.00 12.11           C  
ATOM    690  CD2 LEU B  20      48.431  39.403  44.863  1.00 12.43           C  
ATOM    691  N   SER B  21      52.557  37.252  45.157  1.00 11.91           N  
ATOM    692  CA  SER B  21      53.234  35.975  45.081  1.00 12.78           C  
ATOM    693  C   SER B  21      52.216  34.942  44.645  1.00 12.51           C  
ATOM    694  O   SER B  21      51.041  35.025  44.993  1.00 13.28           O  
ATOM    695  CB  SER B  21      53.844  35.578  46.425  1.00 13.31           C  
ATOM    696  OG  SER B  21      54.900  36.447  46.798  1.00 14.39           O  
ATOM    697  N   PHE B  22      52.667  33.968  43.871  1.00 12.45           N  
ATOM    698  CA  PHE B  22      51.801  32.879  43.460  1.00 12.27           C  
ATOM    699  C   PHE B  22      52.625  31.689  43.049  1.00 12.57           C  
ATOM    700  O   PHE B  22      53.844  31.769  42.860  1.00 13.18           O  
ATOM    701  CB  PHE B  22      50.829  33.310  42.347  1.00 12.26           C  
ATOM    702  CG  PHE B  22      51.483  33.931  41.147  1.00 12.69           C  
ATOM    703  CD1 PHE B  22      52.023  33.138  40.125  1.00 11.97           C  
ATOM    704  CD2 PHE B  22      51.549  35.310  41.026  1.00 13.67           C  
ATOM    705  CE1 PHE B  22      52.578  33.710  39.002  1.00 12.66           C  
ATOM    706  CE2 PHE B  22      52.115  35.888  39.917  1.00 13.93           C  
ATOM    707  CZ  PHE B  22      52.636  35.083  38.894  1.00 13.55           C  
ATOM    708  N   ARG B  23      51.936  30.569  42.906  1.00 12.67           N  
ATOM    709  CA  ARG B  23      52.555  29.336  42.477  1.00 13.68           C  
ATOM    710  C   ARG B  23      52.074  28.932  41.105  1.00 12.50           C  
ATOM    711  O   ARG B  23      50.935  29.228  40.729  1.00 11.45           O  
ATOM    712  CB  ARG B  23      52.181  28.234  43.448  1.00 14.85           C  
ATOM    713  CG  ARG B  23      52.727  28.429  44.839  1.00 18.57           C  
ATOM    714  CD  ARG B  23      52.243  27.399  45.830  1.00 23.16           C  
ATOM    715  NE  ARG B  23      50.786  27.359  45.899  1.00 26.67           N  
ATOM    716  CZ  ARG B  23      50.082  26.582  46.720  1.00 29.16           C  
ATOM    717  NH1 ARG B  23      50.689  25.774  47.580  1.00 30.05           N  
ATOM    718  NH2 ARG B  23      48.754  26.624  46.685  1.00 30.31           N  
ATOM    719  N   LYS B  24      52.921  28.185  40.395  1.00 12.41           N  
ATOM    720  CA  LYS B  24      52.532  27.586  39.140  1.00 12.00           C  
ATOM    721  C   LYS B  24      51.184  26.874  39.308  1.00 12.11           C  
ATOM    722  O   LYS B  24      50.974  26.108  40.246  1.00 12.73           O  
ATOM    723  CB  LYS B  24      53.602  26.601  38.670  1.00 12.61           C  
ATOM    724  CG  LYS B  24      53.288  25.979  37.332  1.00 13.81           C  
ATOM    725  CD  LYS B  24      54.422  25.103  36.819  1.00 16.27           C  
ATOM    726  CE  LYS B  24      54.067  24.486  35.473  1.00 18.82           C  
ATOM    727  NZ  LYS B  24      55.147  23.604  34.938  1.00 21.77           N  
ATOM    728  N   GLY B  25      50.266  27.132  38.385  1.00 11.58           N  
ATOM    729  CA  GLY B  25      48.949  26.532  38.417  1.00 11.81           C  
ATOM    730  C   GLY B  25      47.868  27.393  39.051  1.00 11.66           C  
ATOM    731  O   GLY B  25      46.684  27.105  38.876  1.00 12.87           O  
ATOM    732  N   ASP B  26      48.244  28.422  39.808  1.00 10.99           N  
ATOM    733  CA  ASP B  26      47.242  29.311  40.392  1.00 10.81           C  
ATOM    734  C   ASP B  26      46.443  30.004  39.307  1.00 10.10           C  
ATOM    735  O   ASP B  26      46.988  30.409  38.279  1.00 10.80           O  
ATOM    736  CB  ASP B  26      47.876  30.362  41.296  1.00 11.18           C  
ATOM    737  CG  ASP B  26      48.326  29.797  42.623  1.00 12.73           C  
ATOM    738  OD1 ASP B  26      49.089  30.479  43.338  1.00 13.02           O  
ATOM    739  OD2 ASP B  26      47.982  28.657  43.011  1.00 17.03           O  
ATOM    740  N   ILE B  27      45.156  30.183  39.570  1.00 10.16           N  
ATOM    741  CA  ILE B  27      44.265  30.862  38.653  1.00 10.43           C  
ATOM    742  C   ILE B  27      43.838  32.187  39.266  1.00 10.07           C  
ATOM    743  O   ILE B  27      43.305  32.220  40.383  1.00 11.40           O  
ATOM    744  CB  ILE B  27      43.083  29.965  38.323  1.00 11.66           C  
ATOM    745  CG1 ILE B  27      43.582  28.731  37.555  1.00 13.23           C  
ATOM    746  CG2 ILE B  27      42.028  30.737  37.535  1.00 11.92           C  
ATOM    747  CD1 ILE B  27      42.522  27.686  37.330  1.00 14.42           C  
ATOM    748  N   MET B  28      44.068  33.264  38.534  1.00  9.56           N  
ATOM    749  CA  MET B  28      43.810  34.602  39.030  1.00  9.23           C  
ATOM    750  C   MET B  28      42.977  35.390  38.036  1.00  8.82           C  
ATOM    751  O   MET B  28      42.914  35.076  36.848  1.00  9.84           O  
ATOM    752  CB  MET B  28      45.125  35.316  39.326  1.00  9.73           C  
ATOM    753  CG  MET B  28      45.999  35.569  38.116  1.00  9.60           C  
ATOM    754  SD  MET B  28      47.717  35.991  38.540  1.00 11.53           S  
ATOM    755  CE  MET B  28      48.351  34.366  39.019  1.00 12.93           C  
ATOM    756  N   THR B  29      42.317  36.412  38.550  1.00  8.73           N  
ATOM    757  CA  THR B  29      41.548  37.334  37.748  1.00  9.21           C  
ATOM    758  C   THR B  29      42.417  38.483  37.281  1.00  8.23           C  
ATOM    759  O   THR B  29      43.128  39.099  38.082  1.00  8.95           O  
ATOM    760  CB  THR B  29      40.388  37.872  38.584  1.00 10.27           C  
ATOM    761  OG1 THR B  29      39.583  36.769  39.034  1.00 12.34           O  
ATOM    762  CG2 THR B  29      39.481  38.769  37.754  1.00 11.43           C  
ATOM    763  N   VAL B  30      42.332  38.789  35.999  1.00  8.22           N  
ATOM    764  CA  VAL B  30      43.046  39.919  35.446  1.00  8.41           C  
ATOM    765  C   VAL B  30      42.131  41.137  35.543  1.00  8.27           C  
ATOM    766  O   VAL B  30      41.089  41.206  34.886  1.00  9.67           O  
ATOM    767  CB  VAL B  30      43.452  39.669  33.979  1.00  8.89           C  
ATOM    768  CG1 VAL B  30      44.205  40.887  33.420  1.00  9.33           C  
ATOM    769  CG2 VAL B  30      44.324  38.406  33.858  1.00  8.94           C  
ATOM    770  N   LEU B  31      42.499  42.065  36.418  1.00  9.21           N  
ATOM    771  CA  LEU B  31      41.758  43.311  36.574  1.00  9.94           C  
ATOM    772  C   LEU B  31      42.133  44.347  35.524  1.00 10.96           C  
ATOM    773  O   LEU B  31      41.265  45.030  34.992  1.00 12.76           O  
ATOM    774  CB  LEU B  31      41.988  43.894  37.975  1.00  9.69           C  
ATOM    775  CG  LEU B  31      41.611  42.967  39.127  1.00 10.80           C  
ATOM    776  CD1 LEU B  31      42.025  43.568  40.440  1.00 11.15           C  
ATOM    777  CD2 LEU B  31      40.131  42.638  39.120  1.00 12.40           C  
ATOM    778  N   GLU B  32      43.417  44.473  35.236  1.00 10.89           N  
ATOM    779  CA  GLU B  32      43.909  45.467  34.277  1.00 11.86           C  
ATOM    780  C   GLU B  32      45.260  45.056  33.729  1.00 11.40           C  
ATOM    781  O   GLU B  32      46.217  44.960  34.467  1.00 12.67           O  
ATOM    782  CB  GLU B  32      44.067  46.844  34.960  1.00 12.90           C  
ATOM    783  CG  GLU B  32      44.318  47.976  33.982  1.00 15.71           C  
ATOM    784  CD  GLU B  32      44.458  49.330  34.650  1.00 17.46           C  
ATOM    785  OE1 GLU B  32      44.314  50.329  33.907  1.00 21.22           O  
ATOM    786  OE2 GLU B  32      44.719  49.412  35.886  1.00 17.27           O  
ATOM    787  N   GLN B  33      45.348  44.850  32.421  1.00 11.09           N  
ATOM    788  CA  GLN B  33      46.641  44.654  31.785  1.00 11.40           C  
ATOM    789  C   GLN B  33      47.381  45.981  31.731  1.00 12.74           C  
ATOM    790  O   GLN B  33      46.757  47.025  31.572  1.00 13.74           O  
ATOM    791  CB  GLN B  33      46.466  44.129  30.374  1.00 11.01           C  
ATOM    792  CG  GLN B  33      45.798  42.765  30.308  1.00 10.55           C  
ATOM    793  CD  GLN B  33      45.754  42.241  28.896  1.00 11.13           C  
ATOM    794  OE1 GLN B  33      46.700  42.460  28.145  1.00 12.46           O  
ATOM    795  NE2 GLN B  33      44.683  41.559  28.528  1.00 11.85           N  
ATOM    796  N   ASP B  34      48.700  45.923  31.870  1.00 13.32           N  
ATOM    797  CA  ASP B  34      49.552  47.111  31.782  1.00 14.52           C  
ATOM    798  C   ASP B  34      49.016  48.229  32.661  1.00 14.28           C  
ATOM    799  O   ASP B  34      48.797  49.372  32.229  1.00 15.69           O  
ATOM    800  CB  ASP B  34      49.673  47.578  30.330  1.00 15.24           C  
ATOM    801  CG  ASP B  34      50.597  46.714  29.519  1.00 15.95           C  
ATOM    802  OD1 ASP B  34      51.120  45.707  30.037  1.00 16.59           O  
ATOM    803  OD2 ASP B  34      50.877  47.007  28.332  1.00 19.23           O  
ATOM    804  N   THR B  35      48.814  47.891  33.924  1.00 13.50           N  
ATOM    805  CA  THR B  35      48.221  48.816  34.867  1.00 13.26           C  
ATOM    806  C   THR B  35      49.134  50.012  35.156  1.00 13.04           C  
ATOM    807  O   THR B  35      50.338  49.866  35.249  1.00 13.21           O  
ATOM    808  CB  THR B  35      47.852  48.047  36.158  1.00 13.44           C  
ATOM    809  OG1 THR B  35      47.078  48.875  37.022  1.00 13.39           O  
ATOM    810  CG2 THR B  35      49.089  47.675  36.980  1.00 13.62           C  
ATOM    811  N   GLN B  36      48.541  51.191  35.272  1.00 13.04           N  
ATOM    812  CA  GLN B  36      49.227  52.354  35.854  1.00 13.73           C  
ATOM    813  C   GLN B  36      50.560  52.670  35.157  1.00 14.82           C  
ATOM    814  O   GLN B  36      51.566  52.968  35.789  1.00 15.41           O  
ATOM    815  CB  GLN B  36      49.403  52.132  37.357  1.00 13.28           C  
ATOM    816  CG  GLN B  36      48.066  51.994  38.058  1.00 13.27           C  
ATOM    817  CD  GLN B  36      48.187  51.505  39.478  1.00 12.68           C  
ATOM    818  OE1 GLN B  36      48.715  52.210  40.328  1.00 14.00           O  
ATOM    819  NE2 GLN B  36      47.685  50.300  39.750  1.00 12.70           N  
ATOM    820  N   GLY B  37      50.546  52.554  33.834  1.00 15.74           N  
ATOM    821  CA  GLY B  37      51.671  52.951  33.008  1.00 16.67           C  
ATOM    822  C   GLY B  37      52.753  51.913  32.858  1.00 17.64           C  
ATOM    823  O   GLY B  37      53.754  52.150  32.191  1.00 18.21           O  
ATOM    824  N   LEU B  38      52.558  50.746  33.448  1.00 17.56           N  
ATOM    825  CA  LEU B  38      53.546  49.701  33.362  1.00 18.09           C  
ATOM    826  C   LEU B  38      53.375  48.940  32.051  1.00 18.34           C  
ATOM    827  O   LEU B  38      52.274  48.815  31.510  1.00 20.02           O  
ATOM    828  CB  LEU B  38      53.425  48.770  34.555  1.00 18.22           C  
ATOM    829  CG  LEU B  38      53.697  49.417  35.914  1.00 18.79           C  
ATOM    830  CD1 LEU B  38      53.420  48.398  37.009  1.00 19.68           C  
ATOM    831  CD2 LEU B  38      55.128  49.966  36.020  1.00 19.85           C  
ATOM    832  N   ASP B  39      54.493  48.479  31.524  1.00 18.41           N  
ATOM    833  CA  ASP B  39      54.502  47.680  30.320  1.00 18.37           C  
ATOM    834  C   ASP B  39      54.884  46.283  30.770  1.00 17.68           C  
ATOM    835  O   ASP B  39      56.000  46.046  31.208  1.00 18.53           O  
ATOM    836  CB  ASP B  39      55.521  48.254  29.336  1.00 19.02           C  
ATOM    837  CG  ASP B  39      55.489  47.575  27.980  1.00 20.54           C  
ATOM    838  OD1 ASP B  39      54.811  46.537  27.811  1.00 21.80           O  
ATOM    839  OD2 ASP B  39      56.137  48.018  27.004  1.00 24.03           O  
ATOM    840  N   GLY B  40      53.930  45.365  30.720  1.00 16.68           N  
ATOM    841  CA  GLY B  40      54.192  43.982  31.052  1.00 15.78           C  
ATOM    842  C   GLY B  40      53.783  43.584  32.455  1.00 14.70           C  
ATOM    843  O   GLY B  40      54.006  42.443  32.824  1.00 14.93           O  
ATOM    844  N   TRP B  41      53.213  44.519  33.223  1.00 13.53           N  
ATOM    845  CA  TRP B  41      52.741  44.252  34.582  1.00 13.33           C  
ATOM    846  C   TRP B  41      51.233  44.388  34.621  1.00 12.55           C  
ATOM    847  O   TRP B  41      50.687  45.400  34.218  1.00 13.77           O  
ATOM    848  CB  TRP B  41      53.393  45.198  35.581  1.00 13.90           C  
ATOM    849  CG  TRP B  41      54.835  44.921  35.769  1.00 15.36           C  
ATOM    850  CD1 TRP B  41      55.876  45.461  35.069  1.00 16.74           C  
ATOM    851  CD2 TRP B  41      55.413  44.025  36.716  1.00 15.65           C  
ATOM    852  NE1 TRP B  41      57.065  44.954  35.530  1.00 18.69           N  
ATOM    853  CE2 TRP B  41      56.811  44.069  36.544  1.00 17.59           C  
ATOM    854  CE3 TRP B  41      54.889  43.184  37.704  1.00 14.85           C  
ATOM    855  CZ2 TRP B  41      57.686  43.309  37.326  1.00 18.79           C  
ATOM    856  CZ3 TRP B  41      55.757  42.434  38.477  1.00 15.76           C  
ATOM    857  CH2 TRP B  41      57.139  42.502  38.283  1.00 17.56           C  
ATOM    858  N   TRP B  42      50.565  43.314  35.040  1.00 10.95           N  
ATOM    859  CA  TRP B  42      49.115  43.228  35.071  1.00 10.11           C  
ATOM    860  C   TRP B  42      48.610  43.265  36.505  1.00  9.36           C  
ATOM    861  O   TRP B  42      49.147  42.577  37.356  1.00 10.23           O  
ATOM    862  CB  TRP B  42      48.664  41.906  34.458  1.00  9.47           C  
ATOM    863  CG  TRP B  42      49.011  41.719  32.999  1.00 10.57           C  
ATOM    864  CD1 TRP B  42      49.872  42.463  32.221  1.00 12.05           C  
ATOM    865  CD2 TRP B  42      48.481  40.713  32.151  1.00 10.14           C  
ATOM    866  NE1 TRP B  42      49.897  41.968  30.940  1.00 12.54           N  
ATOM    867  CE2 TRP B  42      49.051  40.895  30.865  1.00 11.39           C  
ATOM    868  CE3 TRP B  42      47.580  39.670  32.337  1.00 10.88           C  
ATOM    869  CZ2 TRP B  42      48.746  40.068  29.792  1.00 12.69           C  
ATOM    870  CZ3 TRP B  42      47.269  38.859  31.259  1.00 12.45           C  
ATOM    871  CH2 TRP B  42      47.857  39.065  30.004  1.00 12.96           C  
ATOM    872  N   LEU B  43      47.575  44.050  36.769  1.00  8.92           N  
ATOM    873  CA  LEU B  43      46.933  44.064  38.079  1.00  8.72           C  
ATOM    874  C   LEU B  43      45.958  42.896  38.145  1.00  8.29           C  
ATOM    875  O   LEU B  43      45.064  42.812  37.298  1.00  8.61           O  
ATOM    876  CB  LEU B  43      46.193  45.387  38.279  1.00  8.88           C  
ATOM    877  CG  LEU B  43      45.627  45.619  39.676  1.00  9.52           C  
ATOM    878  CD1 LEU B  43      46.740  45.813  40.680  1.00 10.23           C  
ATOM    879  CD2 LEU B  43      44.724  46.835  39.658  1.00 11.50           C  
ATOM    880  N   CYS B  44      46.161  42.004  39.117  1.00  8.28           N  
ATOM    881  CA  CYS B  44      45.386  40.774  39.236  1.00  8.29           C  
ATOM    882  C   CYS B  44      44.880  40.587  40.660  1.00  7.92           C  
ATOM    883  O   CYS B  44      45.364  41.228  41.603  1.00  8.37           O  
ATOM    884  CB  CYS B  44      46.253  39.572  38.862  1.00  8.41           C  
ATOM    885  SG  CYS B  44      46.804  39.577  37.142  1.00  9.59           S  
ATOM    886  N   SER B  45      43.923  39.677  40.794  1.00  8.22           N  
ATOM    887  CA  SER B  45      43.347  39.308  42.073  1.00  8.94           C  
ATOM    888  C   SER B  45      43.394  37.789  42.184  1.00  8.24           C  
ATOM    889  O   SER B  45      42.985  37.085  41.270  1.00  9.59           O  
ATOM    890  CB  SER B  45      41.921  39.849  42.185  1.00 10.18           C  
ATOM    891  OG  SER B  45      41.331  39.578  43.434  1.00 13.59           O  
ATOM    892  N   LEU B  46      43.879  37.308  43.320  1.00  8.81           N  
ATOM    893  CA  LEU B  46      44.084  35.893  43.571  1.00  9.27           C  
ATOM    894  C   LEU B  46      43.659  35.576  44.990  1.00  9.26           C  
ATOM    895  O   LEU B  46      44.275  36.059  45.944  1.00  9.00           O  
ATOM    896  CB  LEU B  46      45.559  35.525  43.378  1.00 10.26           C  
ATOM    897  CG  LEU B  46      45.959  34.079  43.691  1.00 11.68           C  
ATOM    898  CD1 LEU B  46      45.185  33.061  42.853  1.00 13.00           C  
ATOM    899  CD2 LEU B  46      47.445  33.898  43.504  1.00 13.39           C  
ATOM    900  N   HIS B  47      42.600  34.792  45.128  1.00 10.43           N  
ATOM    901  CA  HIS B  47      42.081  34.390  46.432  1.00 11.85           C  
ATOM    902  C   HIS B  47      41.902  35.596  47.350  1.00 10.94           C  
ATOM    903  O   HIS B  47      42.209  35.520  48.536  1.00 11.31           O  
ATOM    904  CB  HIS B  47      43.004  33.356  47.098  1.00 13.33           C  
ATOM    905  CG  HIS B  47      43.133  32.071  46.341  1.00 18.51           C  
ATOM    906  ND1 HIS B  47      42.234  31.668  45.379  1.00 23.01           N  
ATOM    907  CD2 HIS B  47      44.061  31.090  46.419  1.00 22.16           C  
ATOM    908  CE1 HIS B  47      42.607  30.497  44.891  1.00 23.55           C  
ATOM    909  NE2 HIS B  47      43.710  30.123  45.509  1.00 23.20           N  
ATOM    910  N   GLY B  48      41.409  36.693  46.788  1.00 10.52           N  
ATOM    911  CA  GLY B  48      41.080  37.877  47.565  1.00 10.72           C  
ATOM    912  C   GLY B  48      42.205  38.896  47.718  1.00  9.67           C  
ATOM    913  O   GLY B  48      41.958  39.995  48.219  1.00 10.87           O  
ATOM    914  N   ARG B  49      43.429  38.535  47.346  1.00  8.95           N  
ATOM    915  CA  ARG B  49      44.560  39.450  47.382  1.00  9.28           C  
ATOM    916  C   ARG B  49      44.727  40.091  46.019  1.00  8.80           C  
ATOM    917  O   ARG B  49      44.414  39.475  45.003  1.00 10.78           O  
ATOM    918  CB  ARG B  49      45.834  38.697  47.756  1.00  9.42           C  
ATOM    919  CG  ARG B  49      45.773  38.037  49.118  1.00 10.19           C  
ATOM    920  CD  ARG B  49      47.095  37.457  49.586  1.00 11.73           C  
ATOM    921  NE  ARG B  49      46.950  36.811  50.889  1.00 13.61           N  
ATOM    922  CZ  ARG B  49      46.475  35.583  51.073  1.00 14.37           C  
ATOM    923  NH1 ARG B  49      46.132  34.807  50.057  1.00 14.57           N  
ATOM    924  NH2 ARG B  49      46.371  35.099  52.305  1.00 15.79           N  
ATOM    925  N   GLN B  50      45.221  41.321  45.986  1.00  8.42           N  
ATOM    926  CA  GLN B  50      45.421  42.070  44.753  1.00  8.33           C  
ATOM    927  C   GLN B  50      46.863  42.541  44.664  1.00  8.38           C  
ATOM    928  O   GLN B  50      47.442  42.958  45.661  1.00  9.20           O  
ATOM    929  CB  GLN B  50      44.478  43.275  44.743  1.00  8.29           C  
ATOM    930  CG  GLN B  50      44.422  44.006  43.428  1.00  8.92           C  
ATOM    931  CD  GLN B  50      43.607  45.281  43.488  1.00 10.20           C  
ATOM    932  OE1 GLN B  50      44.080  46.333  43.074  1.00 12.84           O  
ATOM    933  NE2 GLN B  50      42.381  45.191  43.991  1.00 10.97           N  
ATOM    934  N   GLY B  51      47.410  42.536  43.454  1.00  8.48           N  
ATOM    935  CA  GLY B  51      48.756  43.024  43.225  1.00  8.94           C  
ATOM    936  C   GLY B  51      49.117  42.907  41.770  1.00  8.85           C  
ATOM    937  O   GLY B  51      48.384  42.333  40.978  1.00  9.08           O  
ATOM    938  N   ILE B  52      50.278  43.437  41.421  1.00  9.38           N  
ATOM    939  CA  ILE B  52      50.789  43.323  40.061  1.00  9.83           C  
ATOM    940  C   ILE B  52      51.543  42.022  39.866  1.00  9.87           C  
ATOM    941  O   ILE B  52      52.073  41.418  40.794  1.00 10.62           O  
ATOM    942  CB  ILE B  52      51.631  44.551  39.637  1.00 10.99           C  
ATOM    943  CG1 ILE B  52      52.879  44.704  40.506  1.00 12.32           C  
ATOM    944  CG2 ILE B  52      50.759  45.777  39.701  1.00 12.17           C  
ATOM    945  CD1 ILE B  52      53.847  45.785  40.022  1.00 13.30           C  
ATOM    946  N   VAL B  53      51.544  41.594  38.610  1.00  9.82           N  
ATOM    947  CA  VAL B  53      52.092  40.311  38.188  1.00 11.03           C  
ATOM    948  C   VAL B  53      52.756  40.494  36.835  1.00 10.89           C  
ATOM    949  O   VAL B  53      52.218  41.202  35.996  1.00 10.67           O  
ATOM    950  CB  VAL B  53      50.934  39.294  38.018  1.00 12.03           C  
ATOM    951  CG1 VAL B  53      51.375  38.001  37.319  1.00 14.24           C  
ATOM    952  CG2 VAL B  53      50.258  39.033  39.353  1.00 11.97           C  
ATOM    953  N   PRO B  54      53.895  39.858  36.574  1.00 11.56           N  
ATOM    954  CA  PRO B  54      54.432  39.883  35.215  1.00 11.52           C  
ATOM    955  C   PRO B  54      53.529  39.078  34.278  1.00 11.03           C  
ATOM    956  O   PRO B  54      53.370  37.872  34.463  1.00 10.79           O  
ATOM    957  CB  PRO B  54      55.826  39.241  35.361  1.00 12.71           C  
ATOM    958  CG  PRO B  54      56.127  39.344  36.795  1.00 14.79           C  
ATOM    959  CD  PRO B  54      54.787  39.135  37.494  1.00 12.79           C  
ATOM    960  N   GLY B  55      52.994  39.742  33.262  1.00 11.77           N  
ATOM    961  CA  GLY B  55      52.094  39.121  32.322  1.00 11.84           C  
ATOM    962  C   GLY B  55      52.668  37.907  31.633  1.00 11.71           C  
ATOM    963  O   GLY B  55      51.953  36.960  31.320  1.00 12.04           O  
ATOM    964  N   ASN B  56      53.973  37.940  31.386  1.00 12.18           N  
ATOM    965  CA  ASN B  56      54.621  36.845  30.670  1.00 12.85           C  
ATOM    966  C   ASN B  56      54.780  35.572  31.505  1.00 12.78           C  
ATOM    967  O   ASN B  56      55.228  34.557  30.985  1.00 13.63           O  
ATOM    968  CB  ASN B  56      55.947  37.265  30.014  1.00 13.68           C  
ATOM    969  CG  ASN B  56      57.008  37.722  30.990  1.00 15.59           C  
ATOM    970  OD1 ASN B  56      58.024  38.308  30.567  1.00 20.21           O  
ATOM    971  ND2 ASN B  56      56.827  37.464  32.257  1.00 15.25           N  
ATOM    972  N   ARG B  57      54.369  35.595  32.773  1.00 12.04           N  
ATOM    973  CA  ARG B  57      54.317  34.394  33.592  1.00 12.12           C  
ATOM    974  C   ARG B  57      52.935  33.748  33.631  1.00 10.82           C  
ATOM    975  O   ARG B  57      52.743  32.779  34.354  1.00 11.96           O  
ATOM    976  CB  ARG B  57      54.790  34.716  35.001  1.00 12.79           C  
ATOM    977  CG  ARG B  57      56.264  35.122  34.987  1.00 15.96           C  
ATOM    978  CD  ARG B  57      56.805  35.671  36.259  1.00 20.26           C  
ATOM    979  NE  ARG B  57      58.256  35.493  36.288  1.00 24.50           N  
ATOM    980  CZ  ARG B  57      58.916  34.841  37.238  1.00 25.09           C  
ATOM    981  NH1 ARG B  57      58.258  34.313  38.262  1.00 26.18           N  
ATOM    982  NH2 ARG B  57      60.243  34.720  37.168  1.00 25.61           N  
ATOM    983  N   LEU B  58      52.009  34.264  32.824  1.00 10.52           N  
ATOM    984  CA  LEU B  58      50.623  33.796  32.791  1.00 10.52           C  
ATOM    985  C   LEU B  58      50.255  33.275  31.416  1.00 10.47           C  
ATOM    986  O   LEU B  58      50.874  33.633  30.403  1.00 12.07           O  
ATOM    987  CB  LEU B  58      49.657  34.938  33.112  1.00 10.64           C  
ATOM    988  CG  LEU B  58      49.904  35.689  34.411  1.00 11.24           C  
ATOM    989  CD1 LEU B  58      48.908  36.836  34.550  1.00 12.88           C  
ATOM    990  CD2 LEU B  58      49.862  34.767  35.623  1.00 12.35           C  
ATOM    991  N   LYS B  59      49.220  32.447  31.370  1.00  9.99           N  
ATOM    992  CA  LYS B  59      48.482  32.229  30.133  1.00 10.53           C  
ATOM    993  C   LYS B  59      47.012  32.542  30.360  1.00  9.72           C  
ATOM    994  O   LYS B  59      46.449  32.256  31.421  1.00 10.62           O  
ATOM    995  CB  LYS B  59      48.662  30.819  29.585  1.00 11.83           C  
ATOM    996  CG  LYS B  59      48.091  29.742  30.448  1.00 14.07           C  
ATOM    997  CD  LYS B  59      48.162  28.373  29.769  1.00 16.13           C  
ATOM    998  CE  LYS B  59      47.492  27.319  30.649  1.00 17.79           C  
ATOM    999  NZ  LYS B  59      47.657  25.930  30.126  1.00 18.88           N  
ATOM   1000  N   ILE B  60      46.386  33.123  29.351  1.00  9.86           N  
ATOM   1001  CA  ILE B  60      44.960  33.391  29.400  1.00 10.06           C  
ATOM   1002  C   ILE B  60      44.233  32.046  29.393  1.00 10.28           C  
ATOM   1003  O   ILE B  60      44.553  31.150  28.612  1.00 10.76           O  
ATOM   1004  CB  ILE B  60      44.557  34.240  28.185  1.00 10.78           C  
ATOM   1005  CG1 ILE B  60      45.136  35.657  28.331  1.00 12.09           C  
ATOM   1006  CG2 ILE B  60      43.051  34.280  28.054  1.00 11.35           C  
ATOM   1007  CD1 ILE B  60      44.972  36.545  27.121  1.00 13.43           C  
ATOM   1008  N   LEU B  61      43.241  31.898  30.269  1.00 10.12           N  
ATOM   1009  CA  LEU B  61      42.401  30.705  30.262  1.00 11.11           C  
ATOM   1010  C   LEU B  61      41.272  30.982  29.288  1.00 10.63           C  
ATOM   1011  O   LEU B  61      40.329  31.720  29.599  1.00 10.68           O  
ATOM   1012  CB  LEU B  61      41.851  30.396  31.654  1.00 11.71           C  
ATOM   1013  CG  LEU B  61      42.873  29.799  32.618  1.00 13.18           C  
ATOM   1014  CD1 LEU B  61      42.278  29.669  33.987  1.00 14.28           C  
ATOM   1015  CD2 LEU B  61      43.378  28.452  32.131  1.00 14.22           C  
ATOM   1016  N   VAL B  62      41.389  30.418  28.094  1.00 11.00           N  
ATOM   1017  CA  VAL B  62      40.512  30.765  27.007  1.00 11.64           C  
ATOM   1018  C   VAL B  62      39.078  30.366  27.324  1.00 11.02           C  
ATOM   1019  O   VAL B  62      38.794  29.231  27.720  1.00 11.44           O  
ATOM   1020  CB  VAL B  62      40.990  30.138  25.679  1.00 12.37           C  
ATOM   1021  CG1 VAL B  62      39.964  30.343  24.559  1.00 13.32           C  
ATOM   1022  CG2 VAL B  62      42.339  30.728  25.277  1.00 13.48           C  
ATOM   1023  N   GLY B  63      38.185  31.332  27.166  1.00 10.84           N  
ATOM   1024  CA  GLY B  63      36.776  31.146  27.385  1.00 11.77           C  
ATOM   1025  C   GLY B  63      36.319  31.312  28.813  1.00 11.62           C  
ATOM   1026  O   GLY B  63      35.122  31.337  29.006  1.00 12.62           O  
ATOM   1027  N   MET B  64      37.216  31.476  29.792  1.00  9.80           N  
ATOM   1028  CA  MET B  64      36.860  31.439  31.208  1.00  9.19           C  
ATOM   1029  C   MET B  64      36.992  32.830  31.805  1.00  8.60           C  
ATOM   1030  O   MET B  64      38.023  33.485  31.623  1.00  9.03           O  
ATOM   1031  CB  MET B  64      37.760  30.452  31.948  1.00  9.50           C  
ATOM   1032  CG  MET B  64      37.642  29.056  31.408  1.00 11.41           C  
ATOM   1033  SD  MET B  64      38.508  27.845  32.361  1.00 15.38           S  
ATOM   1034  CE  MET B  64      37.996  26.380  31.506  1.00 16.12           C  
ATOM   1035  N   TYR B  65      35.962  33.250  32.547  1.00  8.48           N  
ATOM   1036  CA  TYR B  65      35.840  34.630  33.005  1.00  8.83           C  
ATOM   1037  C   TYR B  65      35.332  34.705  34.422  1.00  9.48           C  
ATOM   1038  O   TYR B  65      34.688  33.785  34.934  1.00 10.37           O  
ATOM   1039  CB  TYR B  65      34.877  35.391  32.094  1.00  9.39           C  
ATOM   1040  CG  TYR B  65      35.364  35.441  30.687  1.00 10.22           C  
ATOM   1041  CD1 TYR B  65      36.413  36.292  30.342  1.00 11.02           C  
ATOM   1042  CD2 TYR B  65      34.866  34.590  29.720  1.00 10.71           C  
ATOM   1043  CE1 TYR B  65      36.908  36.337  29.070  1.00 11.15           C  
ATOM   1044  CE2 TYR B  65      35.362  34.629  28.421  1.00 10.79           C  
ATOM   1045  CZ  TYR B  65      36.385  35.503  28.122  1.00 10.37           C  
ATOM   1046  OH  TYR B  65      36.877  35.584  26.856  1.00 11.90           O  
ATOM   1047  N   ASP B  66      35.641  35.821  35.060  1.00 10.21           N  
ATOM   1048  CA  ASP B  66      35.220  36.127  36.404  1.00 12.29           C  
ATOM   1049  C   ASP B  66      34.337  37.357  36.279  1.00 13.23           C  
ATOM   1050  O   ASP B  66      34.680  38.326  35.587  1.00 13.39           O  
ATOM   1051  CB  ASP B  66      36.455  36.430  37.266  1.00 13.58           C  
ATOM   1052  CG  ASP B  66      36.174  36.393  38.735  1.00 14.99           C  
ATOM   1053  OD1 ASP B  66      35.110  35.868  39.134  1.00 17.41           O  
ATOM   1054  OD2 ASP B  66      36.988  36.870  39.554  1.00 17.51           O  
ATOM   1055  N   LYS B  67      33.195  37.346  36.939  1.00 15.38           N  
ATOM   1056  CA  LYS B  67      32.355  38.533  36.933  1.00 18.16           C  
ATOM   1057  C   LYS B  67      33.089  39.727  37.556  1.00 19.79           C  
ATOM   1058  O   LYS B  67      33.751  39.598  38.582  1.00 20.53           O  
ATOM   1059  CB  LYS B  67      31.046  38.273  37.686  1.00 18.93           C  
ATOM   1060  CG  LYS B  67      29.927  37.715  36.828  1.00 21.87           C  
ATOM   1061  CD  LYS B  67      28.545  38.066  37.398  1.00 24.37           C  
ATOM   1062  CE  LYS B  67      27.418  37.692  36.437  1.00 25.94           C  
ATOM   1063  NZ  LYS B  67      26.157  37.317  37.148  1.00 27.25           N  
ATOM   1064  N   LYS B  68      32.960  40.896  36.932  1.00 21.58           N  
ATOM   1065  CA  LYS B  68      33.591  42.127  37.424  1.00 23.74           C  
ATOM   1066  C   LYS B  68      33.257  42.536  38.875  1.00 25.72           C  
ATOM   1067  O   LYS B  68      34.064  43.228  39.505  1.00 26.56           O  
ATOM   1068  CB  LYS B  68      33.330  43.293  36.465  1.00 23.67           C  
ATOM   1069  CG  LYS B  68      34.254  43.283  35.263  1.00 24.09           C  
ATOM   1070  CD  LYS B  68      34.135  44.547  34.445  1.00 25.39           C  
ATOM   1071  CE  LYS B  68      35.067  44.524  33.248  1.00 26.06           C  
ATOM   1072  NZ  LYS B  68      36.467  44.880  33.632  1.00 27.39           N  
ATOM   1073  N   PRO B  69      32.091  42.163  39.407  1.00 27.32           N  
ATOM   1074  CA  PRO B  69      31.927  42.120  40.870  1.00 28.12           C  
ATOM   1075  C   PRO B  69      32.789  41.038  41.538  1.00 28.68           C  
ATOM   1076  O   PRO B  69      33.795  41.353  42.189  1.00 29.50           O  
ATOM   1077  CB  PRO B  69      30.428  41.819  41.054  1.00 28.20           C  
ATOM   1078  CG  PRO B  69      29.982  41.234  39.774  1.00 28.31           C  
ATOM   1079  CD  PRO B  69      30.822  41.883  38.714  1.00 27.77           C  
TER    1080      PRO B  69                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
