
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   72 ( 1027),  selected   72 , name 1ugv_A
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 1ugv_A.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S     178           -
LGA    S     2_A      L     179           -
LGA    S     3_A      E     180           -
LGA    G     4_A      A     181           -
LGA    S     5_A      W     182           -
LGA    S     6_A      L     183           -
LGA    G     7_A      A     184           -
LGA    T     8_A      Q     185           -
LGA    -       -      G     186           -
LGA    -       -      H     187           -
LGA    -       -      P     188           -
LGA    P     9_A      L     189           #
LGA    F    10_A      P     190          5.983
LGA    R    11_A      K     191          1.318
LGA    K    12_A      R     192          1.005
LGA    A    13_A      V     193          0.740
LGA    K    14_A      R     194          0.545
LGA    A    15_A      N     195          0.214
LGA    L    16_A      A     196          0.559
LGA    Y    17_A      Y     197          1.439
LGA    A    18_A      -       -           -
LGA    C    19_A      -       -           -
LGA    K    20_A      -       -           -
LGA    A    21_A      -       -           -
LGA    E    22_A      -       -           -
LGA    H    23_A      -       -           -
LGA    D    24_A      -       -           -
LGA    S    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    L    27_A      -       -           -
LGA    S    28_A      -       -           -
LGA    F    29_A      -       -           -
LGA    T    30_A      -       -           -
LGA    A    31_A      D     198          1.338
LGA    G    32_A      R     199          1.181
LGA    T    33_A      R     200          0.987
LGA    V    34_A      T     201          0.887
LGA    F    35_A      W     202          0.704
LGA    D    36_A      E     203          0.751
LGA    N    37_A      L     204          2.858
LGA    V    38_A      L     205          3.831
LGA    H    39_A      R     206          2.286
LGA    P    40_A      L     207          1.004
LGA    S    41_A      G     208          1.869
LGA    Q    42_A      E     209          2.764
LGA    E    43_A      E     210          1.893
LGA    P    44_A      D     211          4.361
LGA    -       -      P     212           -
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    G    45_A      R     240          0.935
LGA    W    46_A      V     241          0.813
LGA    L    47_A      A     242          0.349
LGA    E    48_A      W     243          0.447
LGA    G    49_A      V     244          1.293
LGA    T    50_A      A     245          0.692
LGA    L    51_A      D     246          1.473
LGA    N    52_A      P     247          3.269
LGA    -       -      K     248           -
LGA    G    53_A      D     249          1.460
LGA    -       -      P     250           -
LGA    -       -      R     251           -
LGA    K    54_A      K     252          2.840
LGA    T    55_A      P     253          0.749
LGA    G    56_A      I     254          1.436
LGA    L    57_A      P     255          0.814
LGA    I    58_A      H     256          0.389
LGA    P    59_A      L     257          1.661
LGA    E    60_A      T     258          1.438
LGA    N    61_A      G     259          1.750
LGA    Y    62_A      L     260          1.340
LGA    V    63_A      L     261          0.759
LGA    E    64_A      V     262          0.604
LGA    F    65_A      P     263          1.043
LGA    L    66_A      V     264          1.771
LGA    S    67_A      L     265          1.752
LGA    G    68_A      -       -           -
LGA    P    69_A      -       -           -
LGA    S    70_A      -       -           -
LGA    S    71_A      -       -           -
LGA    G    72_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   72   88    5.0     45    1.88     6.67     47.205     2.273

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.281891 * X  +   0.734571 * Y  +  -0.617206 * Z  +  50.483555
  Y_new =  -0.750342 * X  +   0.232120 * Y  +   0.618956 * Z  +  36.389370
  Z_new =   0.597933 * X  +   0.637594 * Y  +   0.485747 * Z  +  38.325432 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.919758   -2.221834  [ DEG:    52.6983   -127.3017 ]
  Theta =  -0.640920   -2.500673  [ DEG:   -36.7220   -143.2780 ]
  Phi   =  -1.930166    1.211427  [ DEG:  -110.5904     69.4096 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ugv_A                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ugv_A.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   72   88   5.0   45   1.88    6.67  47.205
REMARK  ---------------------------------------------------------- 
MOLECULE 1ugv_A
HEADER    PROTEIN BINDING                         20-JUN-03   1UGV              
TITLE     SOLUTION STRUCTURE OF THE SH3 DOMAIN OF HUMAN OLYGOPHREIN-1           
TITLE    2 LIKE PROTEIN (KIAA0621)                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: OLYGOPHRENIN-1 LIKE PROTEIN;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 SYNONYM: KIAA0621;                                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA HG04539;                                           
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P021021-18;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    BETA BARREL, GRAF PROTEIN, STRUCTURAL GENOMICS, RIKEN                 
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.INOUE,F.HAYASHI,M.SHIROUZU,T.TERADA,T.KIGAWA,M.INOUE,               
AUTHOR   2 T.YABUKI,M.AOKI,E.SEKI,T.MATSUDA,H.HIROTA,M.YOSHIDA,                 
AUTHOR   3 A.TANAKA,T.OSANAI,Y.MATSUO,O.OHARA,T.NAGASE,R.KIKUNO,                
AUTHOR   4 M.NAKAYAMA,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   5 INITIATIVE (RSGI)                                                    
REVDAT   1   20-DEC-03 1UGV    0                                                
JRNL        AUTH   K.INOUE,F.HAYASHI,M.SHIROUZU,T.TERADA,T.KIGAWA,              
JRNL        AUTH 2 M.INOUE,T.YABUKI,M.AOKI,E.SEKI,T.MATSUDA,H.HIROTA,           
JRNL        AUTH 3 M.YOSHIDA,A.TANAKA,T.OSANAI,Y.MATSUO,O.OHARA,                
JRNL        AUTH 4 T.NAGASE,R.KIKUNO,M.NAKAYAMA,S.YOKOYAMA                      
JRNL        TITL   SOLUTION STRUCTURE OF THE SH3 DOMAIN OF HUMAN                
JRNL        TITL 2 OLYGOPHREIN-1 LIKE PROTEIN (KIAA0621)                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1UGV A    8    66  UNP    Q9UNA1   RHG26_HUMAN    756    814             
SEQRES   1 A   72  GLY SER SER GLY SER SER GLY THR PRO PHE ARG LYS ALA          
SEQRES   2 A   72  LYS ALA LEU TYR ALA CYS LYS ALA GLU HIS ASP SER GLU          
SEQRES   3 A   72  LEU SER PHE THR ALA GLY THR VAL PHE ASP ASN VAL HIS          
SEQRES   4 A   72  PRO SER GLN GLU PRO GLY TRP LEU GLU GLY THR LEU ASN          
SEQRES   5 A   72  GLY LYS THR GLY LEU ILE PRO GLU ASN TYR VAL GLU PHE          
SEQRES   6 A   72  LEU SER GLY PRO SER SER GLY                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      21.802  47.584  37.084  1.00  0.00           N  
ATOM      2  CA  GLY A   1      20.978  46.393  36.962  1.00  0.00           C  
ATOM      3  C   GLY A   1      21.843  45.137  36.847  1.00  0.00           C  
ATOM      4  O   GLY A   1      22.722  45.062  35.990  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      20.324  46.310  37.831  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      20.334  46.479  36.087  1.00  0.00           H  
ATOM      7  H1  GLY A   1      21.299  48.448  37.077  1.00  0.00           H  
ATOM      8  N   SER A   2      21.564  44.182  37.721  1.00  0.00           N  
ATOM      9  CA  SER A   2      22.305  42.932  37.727  1.00  0.00           C  
ATOM     10  C   SER A   2      21.796  42.015  36.614  1.00  0.00           C  
ATOM     11  O   SER A   2      20.588  41.833  36.458  1.00  0.00           O  
ATOM     12  CB  SER A   2      22.196  42.232  39.083  1.00  0.00           C  
ATOM     13  OG  SER A   2      23.224  42.642  39.980  1.00  0.00           O  
ATOM     14  H   SER A   2      20.847  44.251  38.415  1.00  0.00           H  
ATOM     15  HA  SER A   2      23.343  43.212  37.547  1.00  0.00           H  
ATOM     16  HB2 SER A   2      21.222  42.449  39.525  1.00  0.00           H  
ATOM     17  HB3 SER A   2      22.246  41.154  38.939  1.00  0.00           H  
ATOM     18  HG  SER A   2      24.097  42.703  39.495  1.00  0.00           H  
ATOM     19  N   SER A   3      22.740  41.462  35.866  1.00  0.00           N  
ATOM     20  CA  SER A   3      22.400  40.569  34.772  1.00  0.00           C  
ATOM     21  C   SER A   3      21.669  41.342  33.673  1.00  0.00           C  
ATOM     22  O   SER A   3      20.458  41.541  33.749  1.00  0.00           O  
ATOM     23  CB  SER A   3      21.542  39.401  35.260  1.00  0.00           C  
ATOM     24  OG  SER A   3      22.144  38.715  36.354  1.00  0.00           O  
ATOM     25  H   SER A   3      23.719  41.616  35.999  1.00  0.00           H  
ATOM     26  HA  SER A   3      23.354  40.189  34.404  1.00  0.00           H  
ATOM     27  HB2 SER A   3      20.562  39.772  35.561  1.00  0.00           H  
ATOM     28  HB3 SER A   3      21.379  38.702  34.440  1.00  0.00           H  
ATOM     29  HG  SER A   3      22.294  39.348  37.114  1.00  0.00           H  
ATOM     30  N   GLY A   4      22.436  41.757  32.674  1.00  0.00           N  
ATOM     31  CA  GLY A   4      21.876  42.503  31.561  1.00  0.00           C  
ATOM     32  C   GLY A   4      22.226  41.842  30.227  1.00  0.00           C  
ATOM     33  O   GLY A   4      21.683  40.792  29.889  1.00  0.00           O  
ATOM     34  H   GLY A   4      23.421  41.590  32.620  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      20.794  42.564  31.668  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      22.257  43.524  31.575  1.00  0.00           H  
ATOM     37  N   SER A   5      23.132  42.484  29.503  1.00  0.00           N  
ATOM     38  CA  SER A   5      23.560  41.972  28.213  1.00  0.00           C  
ATOM     39  C   SER A   5      24.541  40.814  28.410  1.00  0.00           C  
ATOM     40  O   SER A   5      25.188  40.714  29.451  1.00  0.00           O  
ATOM     41  CB  SER A   5      24.203  43.074  27.369  1.00  0.00           C  
ATOM     42  OG  SER A   5      23.343  43.513  26.320  1.00  0.00           O  
ATOM     43  H   SER A   5      23.569  43.339  29.785  1.00  0.00           H  
ATOM     44  HA  SER A   5      22.651  41.624  27.724  1.00  0.00           H  
ATOM     45  HB2 SER A   5      24.456  43.920  28.008  1.00  0.00           H  
ATOM     46  HB3 SER A   5      25.136  42.706  26.942  1.00  0.00           H  
ATOM     47  HG  SER A   5      23.882  43.934  25.591  1.00  0.00           H  
ATOM     48  N   SER A   6      24.620  39.968  27.394  1.00  0.00           N  
ATOM     49  CA  SER A   6      25.510  38.821  27.441  1.00  0.00           C  
ATOM     50  C   SER A   6      26.942  39.282  27.722  1.00  0.00           C  
ATOM     51  O   SER A   6      27.350  40.356  27.283  1.00  0.00           O  
ATOM     52  CB  SER A   6      25.456  38.026  26.135  1.00  0.00           C  
ATOM     53  OG  SER A   6      25.895  38.799  25.021  1.00  0.00           O  
ATOM     54  H   SER A   6      24.090  40.057  26.549  1.00  0.00           H  
ATOM     55  HA  SER A   6      25.140  38.202  28.258  1.00  0.00           H  
ATOM     56  HB2 SER A   6      26.078  37.136  26.226  1.00  0.00           H  
ATOM     57  HB3 SER A   6      24.435  37.686  25.959  1.00  0.00           H  
ATOM     58  HG  SER A   6      26.889  38.735  24.931  1.00  0.00           H  
ATOM     59  N   GLY A   7      27.665  38.447  28.454  1.00  0.00           N  
ATOM     60  CA  GLY A   7      29.043  38.755  28.799  1.00  0.00           C  
ATOM     61  C   GLY A   7      29.602  37.731  29.790  1.00  0.00           C  
ATOM     62  O   GLY A   7      28.884  36.836  30.233  1.00  0.00           O  
ATOM     63  H   GLY A   7      27.326  37.575  28.807  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      29.654  38.764  27.896  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      29.098  39.752  29.233  1.00  0.00           H  
ATOM     66  N   THR A   8      30.878  37.896  30.106  1.00  0.00           N  
ATOM     67  CA  THR A   8      31.541  36.998  31.035  1.00  0.00           C  
ATOM     68  C   THR A   8      31.980  37.758  32.289  1.00  0.00           C  
ATOM     69  O   THR A   8      32.330  38.934  32.216  1.00  0.00           O  
ATOM     70  CB  THR A   8      32.699  36.324  30.296  1.00  0.00           C  
ATOM     71  OG1 THR A   8      33.372  35.582  31.309  1.00  0.00           O  
ATOM     72  CG2 THR A   8      33.747  37.328  29.811  1.00  0.00           C  
ATOM     73  H   THR A   8      31.454  38.628  29.740  1.00  0.00           H  
ATOM     74  HA  THR A   8      30.823  36.242  31.354  1.00  0.00           H  
ATOM     75  HB  THR A   8      32.332  35.715  29.471  1.00  0.00           H  
ATOM     76  HG1 THR A   8      33.262  34.601  31.144  1.00  0.00           H  
ATOM     77 HG21 THR A   8      34.239  37.784  30.671  1.00  0.00           H  
ATOM     78 HG22 THR A   8      34.488  36.813  29.200  1.00  0.00           H  
ATOM     79 HG23 THR A   8      33.261  38.102  29.218  1.00  0.00           H  
ATOM     80  N   PRO A   9      31.946  37.034  33.440  1.00  0.00           N  
ATOM     81  CA  PRO A   9      32.336  37.626  34.708  1.00  0.00           C  
ATOM     82  C   PRO A   9      33.857  37.769  34.802  1.00  0.00           C  
ATOM     83  O   PRO A   9      34.528  36.923  35.392  1.00  0.00           O  
ATOM     84  CB  PRO A   9      31.760  36.701  35.768  1.00  0.00           C  
ATOM     85  CG  PRO A   9      31.472  35.387  35.062  1.00  0.00           C  
ATOM     86  CD  PRO A   9      31.537  35.638  33.564  1.00  0.00           C  
ATOM     87  HA  PRO A   9      31.969  38.553  34.786  1.00  0.00           H  
ATOM     88  HB2 PRO A   9      32.465  36.558  36.587  1.00  0.00           H  
ATOM     89  HB3 PRO A   9      30.851  37.121  36.199  1.00  0.00           H  
ATOM     90  HG2 PRO A   9      32.198  34.629  35.354  1.00  0.00           H  
ATOM     91  HG3 PRO A   9      30.488  35.010  35.343  1.00  0.00           H  
ATOM     92  HD2 PRO A   9      32.252  34.971  33.082  1.00  0.00           H  
ATOM     93  HD3 PRO A   9      30.571  35.465  33.090  1.00  0.00           H  
ATOM     94  N   PHE A  10      34.356  38.845  34.212  1.00  0.00           N  
ATOM     95  CA  PHE A  10      35.785  39.109  34.221  1.00  0.00           C  
ATOM     96  C   PHE A  10      36.562  37.941  33.612  1.00  0.00           C  
ATOM     97  O   PHE A  10      35.972  36.940  33.209  1.00  0.00           O  
ATOM     98  CB  PHE A  10      36.199  39.275  35.685  1.00  0.00           C  
ATOM     99  CG  PHE A  10      35.320  40.247  36.474  1.00  0.00           C  
ATOM    100  CD1 PHE A  10      35.499  41.588  36.340  1.00  0.00           C  
ATOM    101  CD2 PHE A  10      34.359  39.769  37.310  1.00  0.00           C  
ATOM    102  CE1 PHE A  10      34.683  42.490  37.073  1.00  0.00           C  
ATOM    103  CE2 PHE A  10      33.542  40.671  38.043  1.00  0.00           C  
ATOM    104  CZ  PHE A  10      33.722  42.012  37.909  1.00  0.00           C  
ATOM    105  H   PHE A  10      33.803  39.528  33.734  1.00  0.00           H  
ATOM    106  HA  PHE A  10      35.951  40.005  33.623  1.00  0.00           H  
ATOM    107  HB2 PHE A  10      36.173  38.300  36.171  1.00  0.00           H  
ATOM    108  HB3 PHE A  10      37.231  39.623  35.722  1.00  0.00           H  
ATOM    109  HD1 PHE A  10      36.269  41.971  35.670  1.00  0.00           H  
ATOM    110  HD2 PHE A  10      34.215  38.694  37.416  1.00  0.00           H  
ATOM    111  HE1 PHE A  10      34.827  43.566  36.966  1.00  0.00           H  
ATOM    112  HE2 PHE A  10      32.773  40.288  38.712  1.00  0.00           H  
ATOM    113  HZ  PHE A  10      33.095  42.705  38.471  1.00  0.00           H  
ATOM    114  N   ARG A  11      37.876  38.107  33.564  1.00  0.00           N  
ATOM    115  CA  ARG A  11      38.741  37.078  33.012  1.00  0.00           C  
ATOM    116  C   ARG A  11      39.713  36.572  34.079  1.00  0.00           C  
ATOM    117  O   ARG A  11      39.888  37.209  35.116  1.00  0.00           O  
ATOM    118  CB  ARG A  11      39.537  37.612  31.819  1.00  0.00           C  
ATOM    119  CG  ARG A  11      39.037  36.999  30.508  1.00  0.00           C  
ATOM    120  CD  ARG A  11      38.824  38.078  29.445  1.00  0.00           C  
ATOM    121  NE  ARG A  11      38.448  37.452  28.157  1.00  0.00           N  
ATOM    122  CZ  ARG A  11      38.233  38.135  27.024  1.00  0.00           C  
ATOM    123  NH1 ARG A  11      38.356  39.469  27.014  1.00  0.00           N  
ATOM    124  NH2 ARG A  11      37.895  37.484  25.904  1.00  0.00           N  
ATOM    125  H   ARG A  11      38.349  38.924  33.894  1.00  0.00           H  
ATOM    126  HA  ARG A  11      38.063  36.288  32.690  1.00  0.00           H  
ATOM    127  HB2 ARG A  11      39.449  38.697  31.773  1.00  0.00           H  
ATOM    128  HB3 ARG A  11      40.594  37.383  31.951  1.00  0.00           H  
ATOM    129  HG2 ARG A  11      39.757  36.265  30.148  1.00  0.00           H  
ATOM    130  HG3 ARG A  11      38.102  36.467  30.685  1.00  0.00           H  
ATOM    131  HD2 ARG A  11      38.043  38.767  29.765  1.00  0.00           H  
ATOM    132  HD3 ARG A  11      39.735  38.663  29.321  1.00  0.00           H  
ATOM    133  HE  ARG A  11      38.348  36.457  28.130  1.00  0.00           H  
ATOM    134 HH11 ARG A  11      38.608  39.956  27.850  1.00  0.00           H  
ATOM    135 HH12 ARG A  11      38.195  39.979  26.168  1.00  0.00           H  
ATOM    136 HH21 ARG A  11      37.804  36.488  25.912  1.00  0.00           H  
ATOM    137 HH22 ARG A  11      37.735  37.993  25.057  1.00  0.00           H  
ATOM    138  N   LYS A  12      40.319  35.431  33.788  1.00  0.00           N  
ATOM    139  CA  LYS A  12      41.268  34.831  34.710  1.00  0.00           C  
ATOM    140  C   LYS A  12      42.534  34.437  33.947  1.00  0.00           C  
ATOM    141  O   LYS A  12      42.488  34.200  32.740  1.00  0.00           O  
ATOM    142  CB  LYS A  12      40.620  33.670  35.467  1.00  0.00           C  
ATOM    143  CG  LYS A  12      39.562  34.179  36.449  1.00  0.00           C  
ATOM    144  CD  LYS A  12      38.509  33.104  36.724  1.00  0.00           C  
ATOM    145  CE  LYS A  12      37.882  32.605  35.421  1.00  0.00           C  
ATOM    146  NZ  LYS A  12      36.494  32.150  35.655  1.00  0.00           N  
ATOM    147  H   LYS A  12      40.170  34.919  32.941  1.00  0.00           H  
ATOM    148  HA  LYS A  12      41.532  35.590  35.447  1.00  0.00           H  
ATOM    149  HB2 LYS A  12      40.162  32.980  34.760  1.00  0.00           H  
ATOM    150  HB3 LYS A  12      41.385  33.112  36.008  1.00  0.00           H  
ATOM    151  HG2 LYS A  12      40.041  34.473  37.384  1.00  0.00           H  
ATOM    152  HG3 LYS A  12      39.082  35.070  36.042  1.00  0.00           H  
ATOM    153  HD2 LYS A  12      38.965  32.270  37.256  1.00  0.00           H  
ATOM    154  HD3 LYS A  12      37.733  33.510  37.373  1.00  0.00           H  
ATOM    155  HE2 LYS A  12      37.890  33.402  34.678  1.00  0.00           H  
ATOM    156  HE3 LYS A  12      38.476  31.786  35.016  1.00  0.00           H  
ATOM    157  HZ1 LYS A  12      36.056  32.747  36.328  1.00  0.00           H  
ATOM    158  HZ2 LYS A  12      35.981  32.185  34.796  1.00  0.00           H  
ATOM    159  HZ3 LYS A  12      36.503  31.211  36.000  1.00  0.00           H  
ATOM    160  N   ALA A  13      43.636  34.378  34.680  1.00  0.00           N  
ATOM    161  CA  ALA A  13      44.912  34.017  34.088  1.00  0.00           C  
ATOM    162  C   ALA A  13      45.612  32.991  34.982  1.00  0.00           C  
ATOM    163  O   ALA A  13      45.348  32.924  36.181  1.00  0.00           O  
ATOM    164  CB  ALA A  13      45.753  35.277  33.878  1.00  0.00           C  
ATOM    165  H   ALA A  13      43.665  34.572  35.661  1.00  0.00           H  
ATOM    166  HA  ALA A  13      44.711  33.563  33.118  1.00  0.00           H  
ATOM    167  HB1 ALA A  13      46.627  35.034  33.273  1.00  0.00           H  
ATOM    168  HB2 ALA A  13      45.156  36.032  33.366  1.00  0.00           H  
ATOM    169  HB3 ALA A  13      46.076  35.663  34.845  1.00  0.00           H  
ATOM    170  N   LYS A  14      46.491  32.216  34.362  1.00  0.00           N  
ATOM    171  CA  LYS A  14      47.232  31.197  35.087  1.00  0.00           C  
ATOM    172  C   LYS A  14      48.726  31.516  35.024  1.00  0.00           C  
ATOM    173  O   LYS A  14      49.255  31.820  33.956  1.00  0.00           O  
ATOM    174  CB  LYS A  14      46.878  29.804  34.563  1.00  0.00           C  
ATOM    175  CG  LYS A  14      48.023  28.819  34.807  1.00  0.00           C  
ATOM    176  CD  LYS A  14      47.700  27.446  34.214  1.00  0.00           C  
ATOM    177  CE  LYS A  14      48.296  27.301  32.812  1.00  0.00           C  
ATOM    178  NZ  LYS A  14      49.771  27.197  32.884  1.00  0.00           N  
ATOM    179  H   LYS A  14      46.701  32.277  33.387  1.00  0.00           H  
ATOM    180  HA  LYS A  14      46.912  31.240  36.129  1.00  0.00           H  
ATOM    181  HB2 LYS A  14      45.973  29.445  35.054  1.00  0.00           H  
ATOM    182  HB3 LYS A  14      46.660  29.857  33.496  1.00  0.00           H  
ATOM    183  HG2 LYS A  14      48.939  29.205  34.362  1.00  0.00           H  
ATOM    184  HG3 LYS A  14      48.203  28.724  35.878  1.00  0.00           H  
ATOM    185  HD2 LYS A  14      48.094  26.664  34.863  1.00  0.00           H  
ATOM    186  HD3 LYS A  14      46.620  27.309  34.170  1.00  0.00           H  
ATOM    187  HE2 LYS A  14      47.886  26.415  32.327  1.00  0.00           H  
ATOM    188  HE3 LYS A  14      48.015  28.157  32.201  1.00  0.00           H  
ATOM    189  HZ1 LYS A  14      50.136  27.981  33.384  1.00  0.00           H  
ATOM    190  HZ2 LYS A  14      50.022  26.352  33.358  1.00  0.00           H  
ATOM    191  HZ3 LYS A  14      50.149  27.184  31.958  1.00  0.00           H  
ATOM    192  N   ALA A  15      49.365  31.438  36.182  1.00  0.00           N  
ATOM    193  CA  ALA A  15      50.789  31.715  36.271  1.00  0.00           C  
ATOM    194  C   ALA A  15      51.567  30.594  35.578  1.00  0.00           C  
ATOM    195  O   ALA A  15      51.379  29.419  35.889  1.00  0.00           O  
ATOM    196  CB  ALA A  15      51.186  31.877  37.739  1.00  0.00           C  
ATOM    197  H   ALA A  15      48.928  31.190  37.047  1.00  0.00           H  
ATOM    198  HA  ALA A  15      50.978  32.654  35.750  1.00  0.00           H  
ATOM    199  HB1 ALA A  15      50.668  31.131  38.341  1.00  0.00           H  
ATOM    200  HB2 ALA A  15      52.263  31.743  37.841  1.00  0.00           H  
ATOM    201  HB3 ALA A  15      50.910  32.875  38.082  1.00  0.00           H  
ATOM    202  N   LEU A  16      52.423  30.998  34.652  1.00  0.00           N  
ATOM    203  CA  LEU A  16      53.230  30.042  33.911  1.00  0.00           C  
ATOM    204  C   LEU A  16      54.351  29.521  34.813  1.00  0.00           C  
ATOM    205  O   LEU A  16      54.559  28.314  34.916  1.00  0.00           O  
ATOM    206  CB  LEU A  16      53.730  30.662  32.605  1.00  0.00           C  
ATOM    207  CG  LEU A  16      52.652  31.039  31.586  1.00  0.00           C  
ATOM    208  CD1 LEU A  16      53.218  31.966  30.508  1.00  0.00           C  
ATOM    209  CD2 LEU A  16      52.004  29.791  30.985  1.00  0.00           C  
ATOM    210  H   LEU A  16      52.570  31.955  34.404  1.00  0.00           H  
ATOM    211  HA  LEU A  16      52.584  29.206  33.645  1.00  0.00           H  
ATOM    212  HB2 LEU A  16      54.303  31.557  32.846  1.00  0.00           H  
ATOM    213  HB3 LEU A  16      54.418  29.960  32.132  1.00  0.00           H  
ATOM    214  HG  LEU A  16      51.869  31.591  32.106  1.00  0.00           H  
ATOM    215 HD11 LEU A  16      52.584  31.922  29.622  1.00  0.00           H  
ATOM    216 HD12 LEU A  16      53.244  32.988  30.885  1.00  0.00           H  
ATOM    217 HD13 LEU A  16      54.228  31.648  30.249  1.00  0.00           H  
ATOM    218 HD21 LEU A  16      51.982  29.880  29.899  1.00  0.00           H  
ATOM    219 HD22 LEU A  16      52.581  28.910  31.266  1.00  0.00           H  
ATOM    220 HD23 LEU A  16      50.986  29.693  31.363  1.00  0.00           H  
ATOM    221  N   TYR A  17      55.044  30.458  35.443  1.00  0.00           N  
ATOM    222  CA  TYR A  17      56.137  30.108  36.333  1.00  0.00           C  
ATOM    223  C   TYR A  17      55.937  30.726  37.718  1.00  0.00           C  
ATOM    224  O   TYR A  17      55.277  31.755  37.854  1.00  0.00           O  
ATOM    225  CB  TYR A  17      57.399  30.700  35.702  1.00  0.00           C  
ATOM    226  CG  TYR A  17      57.528  30.436  34.201  1.00  0.00           C  
ATOM    227  CD1 TYR A  17      56.924  31.286  33.297  1.00  0.00           C  
ATOM    228  CD2 TYR A  17      58.247  29.349  33.751  1.00  0.00           C  
ATOM    229  CE1 TYR A  17      57.044  31.038  31.883  1.00  0.00           C  
ATOM    230  CE2 TYR A  17      58.367  29.099  32.337  1.00  0.00           C  
ATOM    231  CZ  TYR A  17      57.760  29.956  31.474  1.00  0.00           C  
ATOM    232  OH  TYR A  17      57.874  29.721  30.139  1.00  0.00           O  
ATOM    233  H   TYR A  17      54.868  31.439  35.354  1.00  0.00           H  
ATOM    234  HA  TYR A  17      56.161  29.023  36.427  1.00  0.00           H  
ATOM    235  HB2 TYR A  17      57.408  31.777  35.874  1.00  0.00           H  
ATOM    236  HB3 TYR A  17      58.273  30.290  36.209  1.00  0.00           H  
ATOM    237  HD1 TYR A  17      56.354  32.146  33.652  1.00  0.00           H  
ATOM    238  HD2 TYR A  17      58.725  28.678  34.465  1.00  0.00           H  
ATOM    239  HE1 TYR A  17      56.571  31.700  31.159  1.00  0.00           H  
ATOM    240  HE2 TYR A  17      58.933  28.244  31.968  1.00  0.00           H  
ATOM    241  HH  TYR A  17      58.158  28.777  29.981  1.00  0.00           H  
ATOM    242  N   ALA A  18      56.518  30.071  38.713  1.00  0.00           N  
ATOM    243  CA  ALA A  18      56.410  30.543  40.083  1.00  0.00           C  
ATOM    244  C   ALA A  18      57.269  31.797  40.255  1.00  0.00           C  
ATOM    245  O   ALA A  18      58.437  31.812  39.869  1.00  0.00           O  
ATOM    246  CB  ALA A  18      56.817  29.422  41.042  1.00  0.00           C  
ATOM    247  H   ALA A  18      57.052  29.234  38.595  1.00  0.00           H  
ATOM    248  HA  ALA A  18      55.367  30.799  40.265  1.00  0.00           H  
ATOM    249  HB1 ALA A  18      56.977  29.836  42.038  1.00  0.00           H  
ATOM    250  HB2 ALA A  18      56.026  28.673  41.083  1.00  0.00           H  
ATOM    251  HB3 ALA A  18      57.738  28.958  40.689  1.00  0.00           H  
ATOM    252  N   CYS A  19      56.657  32.819  40.835  1.00  0.00           N  
ATOM    253  CA  CYS A  19      57.352  34.076  41.062  1.00  0.00           C  
ATOM    254  C   CYS A  19      57.326  34.374  42.563  1.00  0.00           C  
ATOM    255  O   CYS A  19      56.307  34.172  43.222  1.00  0.00           O  
ATOM    256  CB  CYS A  19      56.742  35.215  40.243  1.00  0.00           C  
ATOM    257  SG  CYS A  19      57.990  36.524  39.966  1.00  0.00           S  
ATOM    258  H   CYS A  19      55.707  32.799  41.146  1.00  0.00           H  
ATOM    259  HA  CYS A  19      58.374  33.936  40.713  1.00  0.00           H  
ATOM    260  HB2 CYS A  19      56.382  34.835  39.286  1.00  0.00           H  
ATOM    261  HB3 CYS A  19      55.879  35.628  40.766  1.00  0.00           H  
ATOM    262  HG  CYS A  19      58.862  36.078  40.866  1.00  0.00           H  
ATOM    263  N   LYS A  20      58.458  34.850  43.058  1.00  0.00           N  
ATOM    264  CA  LYS A  20      58.579  35.178  44.468  1.00  0.00           C  
ATOM    265  C   LYS A  20      58.585  36.699  44.635  1.00  0.00           C  
ATOM    266  O   LYS A  20      59.581  37.274  45.073  1.00  0.00           O  
ATOM    267  CB  LYS A  20      59.800  34.487  45.077  1.00  0.00           C  
ATOM    268  CG  LYS A  20      59.927  34.811  46.567  1.00  0.00           C  
ATOM    269  CD  LYS A  20      61.384  34.713  47.027  1.00  0.00           C  
ATOM    270  CE  LYS A  20      61.856  33.257  47.045  1.00  0.00           C  
ATOM    271  NZ  LYS A  20      61.774  32.703  48.415  1.00  0.00           N  
ATOM    272  H   LYS A  20      59.282  35.012  42.515  1.00  0.00           H  
ATOM    273  HA  LYS A  20      57.698  34.780  44.973  1.00  0.00           H  
ATOM    274  HB2 LYS A  20      59.718  33.409  44.941  1.00  0.00           H  
ATOM    275  HB3 LYS A  20      60.701  34.806  44.554  1.00  0.00           H  
ATOM    276  HG2 LYS A  20      59.550  35.815  46.758  1.00  0.00           H  
ATOM    277  HG3 LYS A  20      59.313  34.123  47.147  1.00  0.00           H  
ATOM    278  HD2 LYS A  20      62.020  35.297  46.361  1.00  0.00           H  
ATOM    279  HD3 LYS A  20      61.484  35.144  48.023  1.00  0.00           H  
ATOM    280  HE2 LYS A  20      61.244  32.661  46.368  1.00  0.00           H  
ATOM    281  HE3 LYS A  20      62.882  33.198  46.683  1.00  0.00           H  
ATOM    282  HZ1 LYS A  20      62.684  32.423  48.717  1.00  0.00           H  
ATOM    283  HZ2 LYS A  20      61.417  33.401  49.037  1.00  0.00           H  
ATOM    284  HZ3 LYS A  20      61.163  31.911  48.417  1.00  0.00           H  
ATOM    285  N   ALA A  21      57.464  37.307  44.278  1.00  0.00           N  
ATOM    286  CA  ALA A  21      57.328  38.750  44.383  1.00  0.00           C  
ATOM    287  C   ALA A  21      57.974  39.225  45.685  1.00  0.00           C  
ATOM    288  O   ALA A  21      57.785  38.614  46.735  1.00  0.00           O  
ATOM    289  CB  ALA A  21      55.849  39.132  44.292  1.00  0.00           C  
ATOM    290  H   ALA A  21      56.659  36.831  43.923  1.00  0.00           H  
ATOM    291  HA  ALA A  21      57.858  39.195  43.540  1.00  0.00           H  
ATOM    292  HB1 ALA A  21      55.259  38.447  44.901  1.00  0.00           H  
ATOM    293  HB2 ALA A  21      55.715  40.150  44.656  1.00  0.00           H  
ATOM    294  HB3 ALA A  21      55.521  39.070  43.254  1.00  0.00           H  
ATOM    295  N   GLU A  22      58.724  40.313  45.573  1.00  0.00           N  
ATOM    296  CA  GLU A  22      59.400  40.877  46.730  1.00  0.00           C  
ATOM    297  C   GLU A  22      58.780  42.226  47.100  1.00  0.00           C  
ATOM    298  O   GLU A  22      58.940  42.699  48.224  1.00  0.00           O  
ATOM    299  CB  GLU A  22      60.902  41.015  46.474  1.00  0.00           C  
ATOM    300  CG  GLU A  22      61.206  42.279  45.668  1.00  0.00           C  
ATOM    301  CD  GLU A  22      62.420  42.071  44.759  1.00  0.00           C  
ATOM    302  OE1 GLU A  22      63.470  41.662  45.300  1.00  0.00           O  
ATOM    303  OE2 GLU A  22      62.270  42.326  43.544  1.00  0.00           O  
ATOM    304  H   GLU A  22      58.873  40.803  44.715  1.00  0.00           H  
ATOM    305  HA  GLU A  22      59.239  40.162  47.536  1.00  0.00           H  
ATOM    306  HB2 GLU A  22      61.435  41.049  47.424  1.00  0.00           H  
ATOM    307  HB3 GLU A  22      61.264  40.140  45.935  1.00  0.00           H  
ATOM    308  HG2 GLU A  22      60.338  42.549  45.065  1.00  0.00           H  
ATOM    309  HG3 GLU A  22      61.394  43.112  46.346  1.00  0.00           H  
ATOM    310  N   HIS A  23      58.084  42.807  46.134  1.00  0.00           N  
ATOM    311  CA  HIS A  23      57.440  44.092  46.344  1.00  0.00           C  
ATOM    312  C   HIS A  23      55.982  43.874  46.756  1.00  0.00           C  
ATOM    313  O   HIS A  23      55.366  42.882  46.368  1.00  0.00           O  
ATOM    314  CB  HIS A  23      57.580  44.979  45.105  1.00  0.00           C  
ATOM    315  CG  HIS A  23      57.037  46.377  45.287  1.00  0.00           C  
ATOM    316  ND1 HIS A  23      57.139  47.071  46.479  1.00  0.00           N  
ATOM    317  CD2 HIS A  23      56.389  47.202  44.414  1.00  0.00           C  
ATOM    318  CE1 HIS A  23      56.574  48.259  46.321  1.00  0.00           C  
ATOM    319  NE2 HIS A  23      56.109  48.337  45.041  1.00  0.00           N  
ATOM    320  H   HIS A  23      57.959  42.415  45.222  1.00  0.00           H  
ATOM    321  HA  HIS A  23      57.971  44.578  47.162  1.00  0.00           H  
ATOM    322  HB2 HIS A  23      58.633  45.041  44.832  1.00  0.00           H  
ATOM    323  HB3 HIS A  23      57.062  44.504  44.272  1.00  0.00           H  
ATOM    324  HD1 HIS A  23      57.567  46.734  47.318  1.00  0.00           H  
ATOM    325  HD2 HIS A  23      56.143  46.967  43.380  1.00  0.00           H  
ATOM    326  HE1 HIS A  23      56.494  49.036  47.081  1.00  0.00           H  
ATOM    327  N   ASP A  24      55.474  44.817  47.536  1.00  0.00           N  
ATOM    328  CA  ASP A  24      54.101  44.740  48.004  1.00  0.00           C  
ATOM    329  C   ASP A  24      53.155  44.747  46.803  1.00  0.00           C  
ATOM    330  O   ASP A  24      52.336  43.842  46.646  1.00  0.00           O  
ATOM    331  CB  ASP A  24      53.752  45.939  48.887  1.00  0.00           C  
ATOM    332  CG  ASP A  24      52.255  46.203  49.060  1.00  0.00           C  
ATOM    333  OD1 ASP A  24      51.656  45.522  49.921  1.00  0.00           O  
ATOM    334  OD2 ASP A  24      51.744  47.076  48.327  1.00  0.00           O  
ATOM    335  H   ASP A  24      55.982  45.620  47.846  1.00  0.00           H  
ATOM    336  HA  ASP A  24      54.044  43.812  48.574  1.00  0.00           H  
ATOM    337  HB2 ASP A  24      54.195  45.788  49.872  1.00  0.00           H  
ATOM    338  HB3 ASP A  24      54.216  46.830  48.463  1.00  0.00           H  
ATOM    339  N   SER A  25      53.299  45.779  45.983  1.00  0.00           N  
ATOM    340  CA  SER A  25      52.467  45.916  44.800  1.00  0.00           C  
ATOM    341  C   SER A  25      52.412  44.587  44.041  1.00  0.00           C  
ATOM    342  O   SER A  25      51.346  44.168  43.593  1.00  0.00           O  
ATOM    343  CB  SER A  25      52.987  47.027  43.886  1.00  0.00           C  
ATOM    344  OG  SER A  25      52.002  47.454  42.950  1.00  0.00           O  
ATOM    345  H   SER A  25      53.966  46.511  46.118  1.00  0.00           H  
ATOM    346  HA  SER A  25      51.478  46.185  45.171  1.00  0.00           H  
ATOM    347  HB2 SER A  25      53.304  47.875  44.492  1.00  0.00           H  
ATOM    348  HB3 SER A  25      53.868  46.672  43.349  1.00  0.00           H  
ATOM    349  HG  SER A  25      51.107  47.093  43.207  1.00  0.00           H  
ATOM    350  N   GLU A  26      53.575  43.963  43.922  1.00  0.00           N  
ATOM    351  CA  GLU A  26      53.672  42.691  43.226  1.00  0.00           C  
ATOM    352  C   GLU A  26      52.964  41.593  44.023  1.00  0.00           C  
ATOM    353  O   GLU A  26      52.704  41.757  45.215  1.00  0.00           O  
ATOM    354  CB  GLU A  26      55.134  42.321  42.963  1.00  0.00           C  
ATOM    355  CG  GLU A  26      55.735  43.206  41.869  1.00  0.00           C  
ATOM    356  CD  GLU A  26      57.207  42.861  41.632  1.00  0.00           C  
ATOM    357  OE1 GLU A  26      58.000  43.082  42.572  1.00  0.00           O  
ATOM    358  OE2 GLU A  26      57.505  42.384  40.516  1.00  0.00           O  
ATOM    359  H   GLU A  26      54.437  44.311  44.290  1.00  0.00           H  
ATOM    360  HA  GLU A  26      53.165  42.842  42.274  1.00  0.00           H  
ATOM    361  HB2 GLU A  26      55.711  42.430  43.881  1.00  0.00           H  
ATOM    362  HB3 GLU A  26      55.200  41.274  42.666  1.00  0.00           H  
ATOM    363  HG2 GLU A  26      55.174  43.077  40.943  1.00  0.00           H  
ATOM    364  HG3 GLU A  26      55.645  44.254  42.154  1.00  0.00           H  
ATOM    365  N   LEU A  27      52.672  40.501  43.334  1.00  0.00           N  
ATOM    366  CA  LEU A  27      51.998  39.377  43.963  1.00  0.00           C  
ATOM    367  C   LEU A  27      52.860  38.122  43.811  1.00  0.00           C  
ATOM    368  O   LEU A  27      53.593  37.982  42.833  1.00  0.00           O  
ATOM    369  CB  LEU A  27      50.582  39.221  43.406  1.00  0.00           C  
ATOM    370  CG  LEU A  27      49.710  40.479  43.432  1.00  0.00           C  
ATOM    371  CD1 LEU A  27      48.507  40.330  42.498  1.00  0.00           C  
ATOM    372  CD2 LEU A  27      49.287  40.824  44.861  1.00  0.00           C  
ATOM    373  H   LEU A  27      52.887  40.377  42.365  1.00  0.00           H  
ATOM    374  HA  LEU A  27      51.905  39.605  45.025  1.00  0.00           H  
ATOM    375  HB2 LEU A  27      50.654  38.874  42.375  1.00  0.00           H  
ATOM    376  HB3 LEU A  27      50.075  38.440  43.972  1.00  0.00           H  
ATOM    377  HG  LEU A  27      50.303  41.314  43.061  1.00  0.00           H  
ATOM    378 HD11 LEU A  27      47.715  41.010  42.814  1.00  0.00           H  
ATOM    379 HD12 LEU A  27      48.806  40.570  41.478  1.00  0.00           H  
ATOM    380 HD13 LEU A  27      48.141  39.304  42.537  1.00  0.00           H  
ATOM    381 HD21 LEU A  27      48.683  40.012  45.267  1.00  0.00           H  
ATOM    382 HD22 LEU A  27      50.174  40.960  45.479  1.00  0.00           H  
ATOM    383 HD23 LEU A  27      48.704  41.744  44.855  1.00  0.00           H  
ATOM    384  N   SER A  28      52.743  37.240  44.793  1.00  0.00           N  
ATOM    385  CA  SER A  28      53.502  36.001  44.780  1.00  0.00           C  
ATOM    386  C   SER A  28      52.557  34.811  44.609  1.00  0.00           C  
ATOM    387  O   SER A  28      51.514  34.743  45.257  1.00  0.00           O  
ATOM    388  CB  SER A  28      54.325  35.847  46.061  1.00  0.00           C  
ATOM    389  OG  SER A  28      53.503  35.574  47.193  1.00  0.00           O  
ATOM    390  H   SER A  28      52.144  37.362  45.585  1.00  0.00           H  
ATOM    391  HA  SER A  28      54.174  36.083  43.926  1.00  0.00           H  
ATOM    392  HB2 SER A  28      55.046  35.039  45.934  1.00  0.00           H  
ATOM    393  HB3 SER A  28      54.896  36.758  46.239  1.00  0.00           H  
ATOM    394  HG  SER A  28      52.580  35.928  47.040  1.00  0.00           H  
ATOM    395  N   PHE A  29      52.957  33.900  43.733  1.00  0.00           N  
ATOM    396  CA  PHE A  29      52.159  32.715  43.469  1.00  0.00           C  
ATOM    397  C   PHE A  29      53.019  31.594  42.884  1.00  0.00           C  
ATOM    398  O   PHE A  29      54.207  31.788  42.626  1.00  0.00           O  
ATOM    399  CB  PHE A  29      51.094  33.112  42.445  1.00  0.00           C  
ATOM    400  CG  PHE A  29      51.616  34.010  41.320  1.00  0.00           C  
ATOM    401  CD1 PHE A  29      52.228  33.458  40.239  1.00  0.00           C  
ATOM    402  CD2 PHE A  29      51.468  35.359  41.404  1.00  0.00           C  
ATOM    403  CE1 PHE A  29      52.713  34.291  39.195  1.00  0.00           C  
ATOM    404  CE2 PHE A  29      51.952  36.192  40.361  1.00  0.00           C  
ATOM    405  CZ  PHE A  29      52.565  35.641  39.279  1.00  0.00           C  
ATOM    406  H   PHE A  29      53.807  33.962  43.211  1.00  0.00           H  
ATOM    407  HA  PHE A  29      51.738  32.389  44.420  1.00  0.00           H  
ATOM    408  HB2 PHE A  29      50.670  32.210  42.007  1.00  0.00           H  
ATOM    409  HB3 PHE A  29      50.284  33.627  42.960  1.00  0.00           H  
ATOM    410  HD1 PHE A  29      52.347  32.377  40.173  1.00  0.00           H  
ATOM    411  HD2 PHE A  29      50.977  35.802  42.271  1.00  0.00           H  
ATOM    412  HE1 PHE A  29      53.204  33.849  38.328  1.00  0.00           H  
ATOM    413  HE2 PHE A  29      51.834  37.274  40.427  1.00  0.00           H  
ATOM    414  HZ  PHE A  29      52.937  36.280  38.478  1.00  0.00           H  
ATOM    415  N   THR A  30      52.387  30.445  42.690  1.00  0.00           N  
ATOM    416  CA  THR A  30      53.080  29.293  42.139  1.00  0.00           C  
ATOM    417  C   THR A  30      52.514  28.938  40.764  1.00  0.00           C  
ATOM    418  O   THR A  30      51.315  29.082  40.524  1.00  0.00           O  
ATOM    419  CB  THR A  30      52.978  28.151  43.152  1.00  0.00           C  
ATOM    420  OG1 THR A  30      51.576  28.003  43.367  1.00  0.00           O  
ATOM    421  CG2 THR A  30      53.527  28.537  44.527  1.00  0.00           C  
ATOM    422  H   THR A  30      51.421  30.296  42.902  1.00  0.00           H  
ATOM    423  HA  THR A  30      54.127  29.559  41.995  1.00  0.00           H  
ATOM    424  HB  THR A  30      53.465  27.252  42.776  1.00  0.00           H  
ATOM    425  HG1 THR A  30      51.197  27.351  42.711  1.00  0.00           H  
ATOM    426 HG21 THR A  30      52.969  28.011  45.302  1.00  0.00           H  
ATOM    427 HG22 THR A  30      54.580  28.262  44.587  1.00  0.00           H  
ATOM    428 HG23 THR A  30      53.423  29.612  44.671  1.00  0.00           H  
ATOM    429  N   ALA A  31      53.402  28.479  39.893  1.00  0.00           N  
ATOM    430  CA  ALA A  31      53.005  28.101  38.547  1.00  0.00           C  
ATOM    431  C   ALA A  31      51.683  27.333  38.606  1.00  0.00           C  
ATOM    432  O   ALA A  31      51.509  26.456  39.450  1.00  0.00           O  
ATOM    433  CB  ALA A  31      54.124  27.287  37.895  1.00  0.00           C  
ATOM    434  H   ALA A  31      54.375  28.364  40.095  1.00  0.00           H  
ATOM    435  HA  ALA A  31      52.859  29.018  37.975  1.00  0.00           H  
ATOM    436  HB1 ALA A  31      53.720  26.346  37.524  1.00  0.00           H  
ATOM    437  HB2 ALA A  31      54.549  27.851  37.065  1.00  0.00           H  
ATOM    438  HB3 ALA A  31      54.902  27.083  38.631  1.00  0.00           H  
ATOM    439  N   GLY A  32      50.787  27.693  37.700  1.00  0.00           N  
ATOM    440  CA  GLY A  32      49.486  27.048  37.637  1.00  0.00           C  
ATOM    441  C   GLY A  32      48.442  27.843  38.427  1.00  0.00           C  
ATOM    442  O   GLY A  32      47.245  27.583  38.315  1.00  0.00           O  
ATOM    443  H   GLY A  32      50.936  28.408  37.017  1.00  0.00           H  
ATOM    444  HA2 GLY A  32      49.169  26.959  36.598  1.00  0.00           H  
ATOM    445  HA3 GLY A  32      49.557  26.037  38.038  1.00  0.00           H  
ATOM    446  N   THR A  33      48.935  28.792  39.207  1.00  0.00           N  
ATOM    447  CA  THR A  33      48.060  29.626  40.015  1.00  0.00           C  
ATOM    448  C   THR A  33      47.131  30.447  39.120  1.00  0.00           C  
ATOM    449  O   THR A  33      47.590  31.164  38.232  1.00  0.00           O  
ATOM    450  CB  THR A  33      48.937  30.484  40.929  1.00  0.00           C  
ATOM    451  OG1 THR A  33      49.249  29.622  42.020  1.00  0.00           O  
ATOM    452  CG2 THR A  33      48.161  31.635  41.573  1.00  0.00           C  
ATOM    453  H   THR A  33      49.911  28.997  39.293  1.00  0.00           H  
ATOM    454  HA  THR A  33      47.430  28.976  40.620  1.00  0.00           H  
ATOM    455  HB  THR A  33      49.811  30.856  40.395  1.00  0.00           H  
ATOM    456  HG1 THR A  33      49.722  28.806  41.688  1.00  0.00           H  
ATOM    457 HG21 THR A  33      48.674  31.957  42.479  1.00  0.00           H  
ATOM    458 HG22 THR A  33      48.100  32.469  40.873  1.00  0.00           H  
ATOM    459 HG23 THR A  33      47.155  31.298  41.825  1.00  0.00           H  
ATOM    460  N   VAL A  34      45.839  30.315  39.384  1.00  0.00           N  
ATOM    461  CA  VAL A  34      44.840  31.035  38.613  1.00  0.00           C  
ATOM    462  C   VAL A  34      44.452  32.314  39.358  1.00  0.00           C  
ATOM    463  O   VAL A  34      44.103  32.269  40.537  1.00  0.00           O  
ATOM    464  CB  VAL A  34      43.644  30.125  38.325  1.00  0.00           C  
ATOM    465  CG1 VAL A  34      42.443  30.937  37.836  1.00  0.00           C  
ATOM    466  CG2 VAL A  34      44.016  29.035  37.319  1.00  0.00           C  
ATOM    467  H   VAL A  34      45.473  29.730  40.108  1.00  0.00           H  
ATOM    468  HA  VAL A  34      45.293  31.309  37.661  1.00  0.00           H  
ATOM    469  HB  VAL A  34      43.362  29.638  39.258  1.00  0.00           H  
ATOM    470 HG11 VAL A  34      41.738  30.275  37.333  1.00  0.00           H  
ATOM    471 HG12 VAL A  34      41.953  31.410  38.687  1.00  0.00           H  
ATOM    472 HG13 VAL A  34      42.781  31.703  37.139  1.00  0.00           H  
ATOM    473 HG21 VAL A  34      43.170  28.849  36.656  1.00  0.00           H  
ATOM    474 HG22 VAL A  34      44.873  29.360  36.730  1.00  0.00           H  
ATOM    475 HG23 VAL A  34      44.267  28.118  37.852  1.00  0.00           H  
ATOM    476  N   PHE A  35      44.525  33.425  38.640  1.00  0.00           N  
ATOM    477  CA  PHE A  35      44.186  34.715  39.219  1.00  0.00           C  
ATOM    478  C   PHE A  35      42.737  35.093  38.902  1.00  0.00           C  
ATOM    479  O   PHE A  35      42.156  34.590  37.942  1.00  0.00           O  
ATOM    480  CB  PHE A  35      45.121  35.748  38.588  1.00  0.00           C  
ATOM    481  CG  PHE A  35      46.607  35.466  38.818  1.00  0.00           C  
ATOM    482  CD1 PHE A  35      47.229  35.958  39.922  1.00  0.00           C  
ATOM    483  CD2 PHE A  35      47.305  34.722  37.918  1.00  0.00           C  
ATOM    484  CE1 PHE A  35      48.609  35.695  40.136  1.00  0.00           C  
ATOM    485  CE2 PHE A  35      48.685  34.461  38.131  1.00  0.00           C  
ATOM    486  CZ  PHE A  35      49.306  34.952  39.236  1.00  0.00           C  
ATOM    487  H   PHE A  35      44.810  33.454  37.681  1.00  0.00           H  
ATOM    488  HA  PHE A  35      44.309  34.626  40.298  1.00  0.00           H  
ATOM    489  HB2 PHE A  35      44.931  35.788  37.515  1.00  0.00           H  
ATOM    490  HB3 PHE A  35      44.883  36.732  38.990  1.00  0.00           H  
ATOM    491  HD1 PHE A  35      46.669  36.552  40.644  1.00  0.00           H  
ATOM    492  HD2 PHE A  35      46.806  34.328  37.033  1.00  0.00           H  
ATOM    493  HE1 PHE A  35      49.107  36.089  41.021  1.00  0.00           H  
ATOM    494  HE2 PHE A  35      49.244  33.865  37.410  1.00  0.00           H  
ATOM    495  HZ  PHE A  35      50.365  34.751  39.400  1.00  0.00           H  
ATOM    496  N   ASP A  36      42.196  35.977  39.728  1.00  0.00           N  
ATOM    497  CA  ASP A  36      40.828  36.429  39.548  1.00  0.00           C  
ATOM    498  C   ASP A  36      40.835  37.832  38.937  1.00  0.00           C  
ATOM    499  O   ASP A  36      41.704  38.644  39.249  1.00  0.00           O  
ATOM    500  CB  ASP A  36      40.091  36.501  40.887  1.00  0.00           C  
ATOM    501  CG  ASP A  36      39.128  35.343  41.158  1.00  0.00           C  
ATOM    502  OD1 ASP A  36      39.493  34.205  40.792  1.00  0.00           O  
ATOM    503  OD2 ASP A  36      38.050  35.623  41.726  1.00  0.00           O  
ATOM    504  H   ASP A  36      42.677  36.381  40.507  1.00  0.00           H  
ATOM    505  HA  ASP A  36      40.366  35.691  38.893  1.00  0.00           H  
ATOM    506  HB2 ASP A  36      40.828  36.536  41.689  1.00  0.00           H  
ATOM    507  HB3 ASP A  36      39.532  37.436  40.927  1.00  0.00           H  
ATOM    508  N   ASN A  37      39.857  38.073  38.077  1.00  0.00           N  
ATOM    509  CA  ASN A  37      39.739  39.363  37.418  1.00  0.00           C  
ATOM    510  C   ASN A  37      41.132  39.859  37.027  1.00  0.00           C  
ATOM    511  O   ASN A  37      41.713  40.697  37.716  1.00  0.00           O  
ATOM    512  CB  ASN A  37      39.112  40.401  38.350  1.00  0.00           C  
ATOM    513  CG  ASN A  37      38.342  41.458  37.556  1.00  0.00           C  
ATOM    514  OD1 ASN A  37      38.301  41.447  36.336  1.00  0.00           O  
ATOM    515  ND2 ASN A  37      37.738  42.370  38.312  1.00  0.00           N  
ATOM    516  H   ASN A  37      39.153  37.406  37.828  1.00  0.00           H  
ATOM    517  HA  ASN A  37      39.100  39.186  36.553  1.00  0.00           H  
ATOM    518  HB2 ASN A  37      38.438  39.907  39.051  1.00  0.00           H  
ATOM    519  HB3 ASN A  37      39.890  40.882  38.943  1.00  0.00           H  
ATOM    520 HD21 ASN A  37      37.811  42.322  39.308  1.00  0.00           H  
ATOM    521 HD22 ASN A  37      37.209  43.103  37.884  1.00  0.00           H  
ATOM    522  N   VAL A  38      41.628  39.323  35.922  1.00  0.00           N  
ATOM    523  CA  VAL A  38      42.941  39.701  35.431  1.00  0.00           C  
ATOM    524  C   VAL A  38      42.787  40.769  34.344  1.00  0.00           C  
ATOM    525  O   VAL A  38      42.000  40.604  33.414  1.00  0.00           O  
ATOM    526  CB  VAL A  38      43.696  38.461  34.946  1.00  0.00           C  
ATOM    527  CG1 VAL A  38      44.989  38.852  34.228  1.00  0.00           C  
ATOM    528  CG2 VAL A  38      43.981  37.505  36.106  1.00  0.00           C  
ATOM    529  H   VAL A  38      41.149  38.643  35.366  1.00  0.00           H  
ATOM    530  HA  VAL A  38      43.496  40.128  36.266  1.00  0.00           H  
ATOM    531  HB  VAL A  38      43.060  37.940  34.231  1.00  0.00           H  
ATOM    532 HG11 VAL A  38      45.434  37.968  33.773  1.00  0.00           H  
ATOM    533 HG12 VAL A  38      44.767  39.587  33.454  1.00  0.00           H  
ATOM    534 HG13 VAL A  38      45.688  39.281  34.946  1.00  0.00           H  
ATOM    535 HG21 VAL A  38      44.270  38.078  36.987  1.00  0.00           H  
ATOM    536 HG22 VAL A  38      43.084  36.926  36.328  1.00  0.00           H  
ATOM    537 HG23 VAL A  38      44.790  36.829  35.830  1.00  0.00           H  
ATOM    538  N   HIS A  39      43.552  41.840  34.501  1.00  0.00           N  
ATOM    539  CA  HIS A  39      43.510  42.934  33.546  1.00  0.00           C  
ATOM    540  C   HIS A  39      44.903  43.553  33.414  1.00  0.00           C  
ATOM    541  O   HIS A  39      45.787  43.281  34.225  1.00  0.00           O  
ATOM    542  CB  HIS A  39      42.441  43.957  33.937  1.00  0.00           C  
ATOM    543  CG  HIS A  39      42.950  45.070  34.821  1.00  0.00           C  
ATOM    544  ND1 HIS A  39      43.801  46.061  34.363  1.00  0.00           N  
ATOM    545  CD2 HIS A  39      42.720  45.338  36.138  1.00  0.00           C  
ATOM    546  CE1 HIS A  39      44.065  46.882  35.369  1.00  0.00           C  
ATOM    547  NE2 HIS A  39      43.395  46.433  36.468  1.00  0.00           N  
ATOM    548  H   HIS A  39      44.189  41.966  35.261  1.00  0.00           H  
ATOM    549  HA  HIS A  39      43.222  42.502  32.587  1.00  0.00           H  
ATOM    550  HB2 HIS A  39      42.019  44.390  33.031  1.00  0.00           H  
ATOM    551  HB3 HIS A  39      41.630  43.440  34.452  1.00  0.00           H  
ATOM    552  HD1 HIS A  39      44.156  46.143  33.432  1.00  0.00           H  
ATOM    553  HD2 HIS A  39      42.089  44.753  36.807  1.00  0.00           H  
ATOM    554  HE1 HIS A  39      44.705  47.764  35.324  1.00  0.00           H  
ATOM    555  N   PRO A  40      45.059  44.396  32.358  1.00  0.00           N  
ATOM    556  CA  PRO A  40      46.329  45.056  32.109  1.00  0.00           C  
ATOM    557  C   PRO A  40      46.557  46.200  33.100  1.00  0.00           C  
ATOM    558  O   PRO A  40      45.821  47.187  33.095  1.00  0.00           O  
ATOM    559  CB  PRO A  40      46.252  45.528  30.666  1.00  0.00           C  
ATOM    560  CG  PRO A  40      44.775  45.527  30.307  1.00  0.00           C  
ATOM    561  CD  PRO A  40      44.035  44.742  31.377  1.00  0.00           C  
ATOM    562  HA  PRO A  40      47.086  44.419  32.251  1.00  0.00           H  
ATOM    563  HB2 PRO A  40      46.680  46.525  30.558  1.00  0.00           H  
ATOM    564  HB3 PRO A  40      46.815  44.866  30.009  1.00  0.00           H  
ATOM    565  HG2 PRO A  40      44.396  46.547  30.250  1.00  0.00           H  
ATOM    566  HG3 PRO A  40      44.621  45.075  29.327  1.00  0.00           H  
ATOM    567  HD2 PRO A  40      43.240  45.338  31.827  1.00  0.00           H  
ATOM    568  HD3 PRO A  40      43.567  43.849  30.961  1.00  0.00           H  
ATOM    569  N   SER A  41      47.577  46.029  33.929  1.00  0.00           N  
ATOM    570  CA  SER A  41      47.910  47.035  34.923  1.00  0.00           C  
ATOM    571  C   SER A  41      48.350  48.327  34.233  1.00  0.00           C  
ATOM    572  O   SER A  41      48.522  48.359  33.016  1.00  0.00           O  
ATOM    573  CB  SER A  41      49.006  46.534  35.865  1.00  0.00           C  
ATOM    574  OG  SER A  41      48.942  47.165  37.141  1.00  0.00           O  
ATOM    575  H   SER A  41      48.169  45.224  33.927  1.00  0.00           H  
ATOM    576  HA  SER A  41      46.992  47.196  35.489  1.00  0.00           H  
ATOM    577  HB2 SER A  41      48.915  45.456  35.989  1.00  0.00           H  
ATOM    578  HB3 SER A  41      49.983  46.722  35.417  1.00  0.00           H  
ATOM    579  HG  SER A  41      49.391  48.059  37.105  1.00  0.00           H  
ATOM    580  N   GLN A  42      48.522  49.363  35.042  1.00  0.00           N  
ATOM    581  CA  GLN A  42      48.939  50.655  34.525  1.00  0.00           C  
ATOM    582  C   GLN A  42      50.344  50.559  33.927  1.00  0.00           C  
ATOM    583  O   GLN A  42      50.678  51.290  32.996  1.00  0.00           O  
ATOM    584  CB  GLN A  42      48.880  51.727  35.615  1.00  0.00           C  
ATOM    585  CG  GLN A  42      47.592  52.546  35.509  1.00  0.00           C  
ATOM    586  CD  GLN A  42      47.728  53.647  34.454  1.00  0.00           C  
ATOM    587  OE1 GLN A  42      47.259  53.529  33.334  1.00  0.00           O  
ATOM    588  NE2 GLN A  42      48.391  54.719  34.874  1.00  0.00           N  
ATOM    589  H   GLN A  42      48.380  49.329  36.031  1.00  0.00           H  
ATOM    590  HA  GLN A  42      48.220  50.900  33.743  1.00  0.00           H  
ATOM    591  HB2 GLN A  42      48.936  51.257  36.597  1.00  0.00           H  
ATOM    592  HB3 GLN A  42      49.743  52.387  35.528  1.00  0.00           H  
ATOM    593  HG2 GLN A  42      46.760  51.891  35.251  1.00  0.00           H  
ATOM    594  HG3 GLN A  42      47.359  52.991  36.476  1.00  0.00           H  
ATOM    595 HE21 GLN A  42      48.750  54.753  35.807  1.00  0.00           H  
ATOM    596 HE22 GLN A  42      48.532  55.493  34.257  1.00  0.00           H  
ATOM    597  N   GLU A  43      51.129  49.650  34.486  1.00  0.00           N  
ATOM    598  CA  GLU A  43      52.491  49.448  34.019  1.00  0.00           C  
ATOM    599  C   GLU A  43      52.495  48.606  32.742  1.00  0.00           C  
ATOM    600  O   GLU A  43      51.592  47.800  32.523  1.00  0.00           O  
ATOM    601  CB  GLU A  43      53.352  48.801  35.105  1.00  0.00           C  
ATOM    602  CG  GLU A  43      53.915  49.856  36.060  1.00  0.00           C  
ATOM    603  CD  GLU A  43      52.794  50.712  36.652  1.00  0.00           C  
ATOM    604  OE1 GLU A  43      51.768  50.114  37.043  1.00  0.00           O  
ATOM    605  OE2 GLU A  43      52.989  51.946  36.702  1.00  0.00           O  
ATOM    606  H   GLU A  43      50.850  49.059  35.242  1.00  0.00           H  
ATOM    607  HA  GLU A  43      52.874  50.445  33.806  1.00  0.00           H  
ATOM    608  HB2 GLU A  43      52.757  48.079  35.665  1.00  0.00           H  
ATOM    609  HB3 GLU A  43      54.171  48.248  34.644  1.00  0.00           H  
ATOM    610  HG2 GLU A  43      54.468  49.367  36.862  1.00  0.00           H  
ATOM    611  HG3 GLU A  43      54.622  50.492  35.528  1.00  0.00           H  
ATOM    612  N   PRO A  44      53.548  48.828  31.910  1.00  0.00           N  
ATOM    613  CA  PRO A  44      53.681  48.099  30.660  1.00  0.00           C  
ATOM    614  C   PRO A  44      54.137  46.660  30.910  1.00  0.00           C  
ATOM    615  O   PRO A  44      55.122  46.430  31.612  1.00  0.00           O  
ATOM    616  CB  PRO A  44      54.676  48.903  29.840  1.00  0.00           C  
ATOM    617  CG  PRO A  44      55.412  49.792  30.830  1.00  0.00           C  
ATOM    618  CD  PRO A  44      54.635  49.776  32.137  1.00  0.00           C  
ATOM    619  HA  PRO A  44      52.794  48.029  30.203  1.00  0.00           H  
ATOM    620  HB2 PRO A  44      55.369  48.247  29.314  1.00  0.00           H  
ATOM    621  HB3 PRO A  44      54.166  49.501  29.084  1.00  0.00           H  
ATOM    622  HG2 PRO A  44      56.428  49.429  30.986  1.00  0.00           H  
ATOM    623  HG3 PRO A  44      55.491  50.808  30.445  1.00  0.00           H  
ATOM    624  HD2 PRO A  44      55.266  49.462  32.969  1.00  0.00           H  
ATOM    625  HD3 PRO A  44      54.252  50.765  32.382  1.00  0.00           H  
ATOM    626  N   GLY A  45      53.400  45.729  30.324  1.00  0.00           N  
ATOM    627  CA  GLY A  45      53.717  44.319  30.474  1.00  0.00           C  
ATOM    628  C   GLY A  45      53.511  43.862  31.919  1.00  0.00           C  
ATOM    629  O   GLY A  45      54.249  43.013  32.418  1.00  0.00           O  
ATOM    630  H   GLY A  45      52.601  45.924  29.755  1.00  0.00           H  
ATOM    631  HA2 GLY A  45      53.087  43.728  29.810  1.00  0.00           H  
ATOM    632  HA3 GLY A  45      54.750  44.140  30.176  1.00  0.00           H  
ATOM    633  N   TRP A  46      52.505  44.446  32.554  1.00  0.00           N  
ATOM    634  CA  TRP A  46      52.192  44.109  33.932  1.00  0.00           C  
ATOM    635  C   TRP A  46      50.672  43.997  34.059  1.00  0.00           C  
ATOM    636  O   TRP A  46      49.947  44.936  33.734  1.00  0.00           O  
ATOM    637  CB  TRP A  46      52.799  45.131  34.897  1.00  0.00           C  
ATOM    638  CG  TRP A  46      54.316  45.014  35.054  1.00  0.00           C  
ATOM    639  CD1 TRP A  46      55.264  45.791  34.512  1.00  0.00           C  
ATOM    640  CD2 TRP A  46      55.027  44.027  35.831  1.00  0.00           C  
ATOM    641  NE1 TRP A  46      56.528  45.378  34.881  1.00  0.00           N  
ATOM    642  CE2 TRP A  46      56.379  44.272  35.709  1.00  0.00           C  
ATOM    643  CE3 TRP A  46      54.542  42.962  36.611  1.00  0.00           C  
ATOM    644  CZ2 TRP A  46      57.358  43.495  36.339  1.00  0.00           C  
ATOM    645  CZ3 TRP A  46      55.534  42.195  37.235  1.00  0.00           C  
ATOM    646  CH2 TRP A  46      56.899  42.429  37.122  1.00  0.00           C  
ATOM    647  H   TRP A  46      51.909  45.136  32.142  1.00  0.00           H  
ATOM    648  HA  TRP A  46      52.657  43.149  34.154  1.00  0.00           H  
ATOM    649  HB2 TRP A  46      52.556  46.135  34.546  1.00  0.00           H  
ATOM    650  HB3 TRP A  46      52.332  45.013  35.875  1.00  0.00           H  
ATOM    651  HD1 TRP A  46      55.062  46.641  33.862  1.00  0.00           H  
ATOM    652  HE1 TRP A  46      57.470  45.835  34.579  1.00  0.00           H  
ATOM    653  HE3 TRP A  46      53.479  42.749  36.725  1.00  0.00           H  
ATOM    654  HZ2 TRP A  46      58.422  43.708  36.227  1.00  0.00           H  
ATOM    655  HZ3 TRP A  46      55.212  41.357  37.853  1.00  0.00           H  
ATOM    656  HH2 TRP A  46      57.610  41.785  37.640  1.00  0.00           H  
ATOM    657  N   LEU A  47      50.233  42.839  34.532  1.00  0.00           N  
ATOM    658  CA  LEU A  47      48.812  42.591  34.706  1.00  0.00           C  
ATOM    659  C   LEU A  47      48.421  42.888  36.154  1.00  0.00           C  
ATOM    660  O   LEU A  47      49.204  42.652  37.073  1.00  0.00           O  
ATOM    661  CB  LEU A  47      48.456  41.176  34.250  1.00  0.00           C  
ATOM    662  CG  LEU A  47      48.783  40.838  32.794  1.00  0.00           C  
ATOM    663  CD1 LEU A  47      48.309  39.427  32.439  1.00  0.00           C  
ATOM    664  CD2 LEU A  47      48.208  41.891  31.844  1.00  0.00           C  
ATOM    665  H   LEU A  47      50.830  42.081  34.795  1.00  0.00           H  
ATOM    666  HA  LEU A  47      48.279  43.284  34.055  1.00  0.00           H  
ATOM    667  HB2 LEU A  47      48.976  40.466  34.892  1.00  0.00           H  
ATOM    668  HB3 LEU A  47      47.388  41.023  34.406  1.00  0.00           H  
ATOM    669  HG  LEU A  47      49.866  40.853  32.674  1.00  0.00           H  
ATOM    670 HD11 LEU A  47      47.271  39.465  32.108  1.00  0.00           H  
ATOM    671 HD12 LEU A  47      48.931  39.025  31.639  1.00  0.00           H  
ATOM    672 HD13 LEU A  47      48.387  38.786  33.317  1.00  0.00           H  
ATOM    673 HD21 LEU A  47      48.584  42.875  32.123  1.00  0.00           H  
ATOM    674 HD22 LEU A  47      48.511  41.662  30.822  1.00  0.00           H  
ATOM    675 HD23 LEU A  47      47.121  41.885  31.910  1.00  0.00           H  
ATOM    676  N   GLU A  48      47.210  43.401  36.314  1.00  0.00           N  
ATOM    677  CA  GLU A  48      46.704  43.732  37.635  1.00  0.00           C  
ATOM    678  C   GLU A  48      45.448  42.916  37.943  1.00  0.00           C  
ATOM    679  O   GLU A  48      44.350  43.275  37.521  1.00  0.00           O  
ATOM    680  CB  GLU A  48      46.427  45.232  37.756  1.00  0.00           C  
ATOM    681  CG  GLU A  48      46.332  45.655  39.224  1.00  0.00           C  
ATOM    682  CD  GLU A  48      46.626  47.148  39.383  1.00  0.00           C  
ATOM    683  OE1 GLU A  48      46.119  47.920  38.541  1.00  0.00           O  
ATOM    684  OE2 GLU A  48      47.351  47.484  40.345  1.00  0.00           O  
ATOM    685  H   GLU A  48      46.579  43.590  35.561  1.00  0.00           H  
ATOM    686  HA  GLU A  48      47.502  43.460  38.327  1.00  0.00           H  
ATOM    687  HB2 GLU A  48      47.221  45.793  37.262  1.00  0.00           H  
ATOM    688  HB3 GLU A  48      45.497  45.476  37.243  1.00  0.00           H  
ATOM    689  HG2 GLU A  48      45.335  45.434  39.606  1.00  0.00           H  
ATOM    690  HG3 GLU A  48      47.037  45.076  39.819  1.00  0.00           H  
ATOM    691  N   GLY A  49      45.651  41.831  38.676  1.00  0.00           N  
ATOM    692  CA  GLY A  49      44.547  40.960  39.046  1.00  0.00           C  
ATOM    693  C   GLY A  49      44.374  40.910  40.566  1.00  0.00           C  
ATOM    694  O   GLY A  49      44.968  41.709  41.288  1.00  0.00           O  
ATOM    695  H   GLY A  49      46.548  41.545  39.016  1.00  0.00           H  
ATOM    696  HA2 GLY A  49      43.628  41.316  38.583  1.00  0.00           H  
ATOM    697  HA3 GLY A  49      44.730  39.955  38.664  1.00  0.00           H  
ATOM    698  N   THR A  50      43.557  39.964  41.004  1.00  0.00           N  
ATOM    699  CA  THR A  50      43.299  39.799  42.424  1.00  0.00           C  
ATOM    700  C   THR A  50      43.575  38.356  42.854  1.00  0.00           C  
ATOM    701  O   THR A  50      42.789  37.456  42.561  1.00  0.00           O  
ATOM    702  CB  THR A  50      41.862  40.249  42.699  1.00  0.00           C  
ATOM    703  OG1 THR A  50      41.846  41.619  42.306  1.00  0.00           O  
ATOM    704  CG2 THR A  50      41.534  40.285  44.193  1.00  0.00           C  
ATOM    705  H   THR A  50      43.078  39.318  40.410  1.00  0.00           H  
ATOM    706  HA  THR A  50      43.990  40.435  42.977  1.00  0.00           H  
ATOM    707  HB  THR A  50      41.149  39.625  42.158  1.00  0.00           H  
ATOM    708  HG1 THR A  50      41.993  41.694  41.320  1.00  0.00           H  
ATOM    709 HG21 THR A  50      40.452  40.280  44.327  1.00  0.00           H  
ATOM    710 HG22 THR A  50      41.965  39.411  44.681  1.00  0.00           H  
ATOM    711 HG23 THR A  50      41.951  41.191  44.634  1.00  0.00           H  
ATOM    712  N   LEU A  51      44.694  38.181  43.540  1.00  0.00           N  
ATOM    713  CA  LEU A  51      45.085  36.864  44.012  1.00  0.00           C  
ATOM    714  C   LEU A  51      44.718  36.727  45.490  1.00  0.00           C  
ATOM    715  O   LEU A  51      45.399  37.273  46.356  1.00  0.00           O  
ATOM    716  CB  LEU A  51      46.565  36.606  43.719  1.00  0.00           C  
ATOM    717  CG  LEU A  51      47.156  35.330  44.321  1.00  0.00           C  
ATOM    718  CD1 LEU A  51      46.792  34.107  43.475  1.00  0.00           C  
ATOM    719  CD2 LEU A  51      48.667  35.463  44.516  1.00  0.00           C  
ATOM    720  H   LEU A  51      45.329  38.919  43.773  1.00  0.00           H  
ATOM    721  HA  LEU A  51      44.513  36.130  43.444  1.00  0.00           H  
ATOM    722  HB2 LEU A  51      46.701  36.572  42.639  1.00  0.00           H  
ATOM    723  HB3 LEU A  51      47.140  37.457  44.086  1.00  0.00           H  
ATOM    724  HG  LEU A  51      46.715  35.180  45.307  1.00  0.00           H  
ATOM    725 HD11 LEU A  51      46.443  34.434  42.496  1.00  0.00           H  
ATOM    726 HD12 LEU A  51      47.672  33.475  43.354  1.00  0.00           H  
ATOM    727 HD13 LEU A  51      46.004  33.542  43.972  1.00  0.00           H  
ATOM    728 HD21 LEU A  51      48.986  34.814  45.331  1.00  0.00           H  
ATOM    729 HD22 LEU A  51      49.179  35.174  43.599  1.00  0.00           H  
ATOM    730 HD23 LEU A  51      48.911  36.497  44.759  1.00  0.00           H  
ATOM    731  N   ASN A  52      43.640  35.995  45.734  1.00  0.00           N  
ATOM    732  CA  ASN A  52      43.173  35.780  47.094  1.00  0.00           C  
ATOM    733  C   ASN A  52      42.851  37.130  47.737  1.00  0.00           C  
ATOM    734  O   ASN A  52      43.608  37.619  48.574  1.00  0.00           O  
ATOM    735  CB  ASN A  52      44.247  35.096  47.942  1.00  0.00           C  
ATOM    736  CG  ASN A  52      44.350  33.608  47.602  1.00  0.00           C  
ATOM    737  OD1 ASN A  52      43.422  32.837  47.786  1.00  0.00           O  
ATOM    738  ND2 ASN A  52      45.526  33.249  47.096  1.00  0.00           N  
ATOM    739  H   ASN A  52      43.091  35.555  45.024  1.00  0.00           H  
ATOM    740  HA  ASN A  52      42.295  35.143  46.996  1.00  0.00           H  
ATOM    741  HB2 ASN A  52      45.210  35.578  47.775  1.00  0.00           H  
ATOM    742  HB3 ASN A  52      44.011  35.215  48.999  1.00  0.00           H  
ATOM    743 HD21 ASN A  52      46.246  33.931  46.970  1.00  0.00           H  
ATOM    744 HD22 ASN A  52      45.691  32.296  46.842  1.00  0.00           H  
ATOM    745  N   GLY A  53      41.726  37.693  47.323  1.00  0.00           N  
ATOM    746  CA  GLY A  53      41.293  38.977  47.849  1.00  0.00           C  
ATOM    747  C   GLY A  53      42.482  39.923  48.033  1.00  0.00           C  
ATOM    748  O   GLY A  53      42.555  40.648  49.023  1.00  0.00           O  
ATOM    749  H   GLY A  53      41.114  37.289  46.642  1.00  0.00           H  
ATOM    750  HA2 GLY A  53      40.568  39.426  47.170  1.00  0.00           H  
ATOM    751  HA3 GLY A  53      40.789  38.831  48.804  1.00  0.00           H  
ATOM    752  N   LYS A  54      43.384  39.884  47.063  1.00  0.00           N  
ATOM    753  CA  LYS A  54      44.566  40.727  47.105  1.00  0.00           C  
ATOM    754  C   LYS A  54      44.939  41.147  45.682  1.00  0.00           C  
ATOM    755  O   LYS A  54      45.220  40.300  44.835  1.00  0.00           O  
ATOM    756  CB  LYS A  54      45.699  40.026  47.858  1.00  0.00           C  
ATOM    757  CG  LYS A  54      46.783  41.023  48.271  1.00  0.00           C  
ATOM    758  CD  LYS A  54      48.040  40.298  48.753  1.00  0.00           C  
ATOM    759  CE  LYS A  54      49.285  41.162  48.546  1.00  0.00           C  
ATOM    760  NZ  LYS A  54      50.161  41.104  49.738  1.00  0.00           N  
ATOM    761  H   LYS A  54      43.317  39.289  46.261  1.00  0.00           H  
ATOM    762  HA  LYS A  54      44.308  41.621  47.673  1.00  0.00           H  
ATOM    763  HB2 LYS A  54      45.300  39.529  48.742  1.00  0.00           H  
ATOM    764  HB3 LYS A  54      46.134  39.251  47.226  1.00  0.00           H  
ATOM    765  HG2 LYS A  54      47.031  41.667  47.426  1.00  0.00           H  
ATOM    766  HG3 LYS A  54      46.404  41.669  49.063  1.00  0.00           H  
ATOM    767  HD2 LYS A  54      47.938  40.048  49.809  1.00  0.00           H  
ATOM    768  HD3 LYS A  54      48.152  39.358  48.213  1.00  0.00           H  
ATOM    769  HE2 LYS A  54      49.833  40.817  47.669  1.00  0.00           H  
ATOM    770  HE3 LYS A  54      48.991  42.194  48.353  1.00  0.00           H  
ATOM    771  HZ1 LYS A  54      49.808  41.722  50.441  1.00  0.00           H  
ATOM    772  HZ2 LYS A  54      50.178  40.170  50.094  1.00  0.00           H  
ATOM    773  HZ3 LYS A  54      51.088  41.382  49.485  1.00  0.00           H  
ATOM    774  N   THR A  55      44.931  42.453  45.462  1.00  0.00           N  
ATOM    775  CA  THR A  55      45.264  42.995  44.156  1.00  0.00           C  
ATOM    776  C   THR A  55      46.699  43.526  44.151  1.00  0.00           C  
ATOM    777  O   THR A  55      47.143  44.137  45.123  1.00  0.00           O  
ATOM    778  CB  THR A  55      44.221  44.057  43.804  1.00  0.00           C  
ATOM    779  OG1 THR A  55      43.023  43.313  43.602  1.00  0.00           O  
ATOM    780  CG2 THR A  55      44.487  44.710  42.446  1.00  0.00           C  
ATOM    781  H   THR A  55      44.700  43.135  46.157  1.00  0.00           H  
ATOM    782  HA  THR A  55      45.221  42.186  43.428  1.00  0.00           H  
ATOM    783  HB  THR A  55      44.149  44.807  44.590  1.00  0.00           H  
ATOM    784  HG1 THR A  55      42.556  43.172  44.475  1.00  0.00           H  
ATOM    785 HG21 THR A  55      44.928  45.695  42.598  1.00  0.00           H  
ATOM    786 HG22 THR A  55      45.174  44.089  41.872  1.00  0.00           H  
ATOM    787 HG23 THR A  55      43.548  44.812  41.902  1.00  0.00           H  
ATOM    788  N   GLY A  56      47.385  43.276  43.045  1.00  0.00           N  
ATOM    789  CA  GLY A  56      48.760  43.723  42.900  1.00  0.00           C  
ATOM    790  C   GLY A  56      49.207  43.656  41.439  1.00  0.00           C  
ATOM    791  O   GLY A  56      48.384  43.488  40.541  1.00  0.00           O  
ATOM    792  H   GLY A  56      47.017  42.779  42.260  1.00  0.00           H  
ATOM    793  HA2 GLY A  56      48.856  44.744  43.268  1.00  0.00           H  
ATOM    794  HA3 GLY A  56      49.414  43.102  43.513  1.00  0.00           H  
ATOM    795  N   LEU A  57      50.511  43.793  41.245  1.00  0.00           N  
ATOM    796  CA  LEU A  57      51.077  43.751  39.908  1.00  0.00           C  
ATOM    797  C   LEU A  57      51.538  42.325  39.599  1.00  0.00           C  
ATOM    798  O   LEU A  57      52.126  41.661  40.450  1.00  0.00           O  
ATOM    799  CB  LEU A  57      52.181  44.800  39.760  1.00  0.00           C  
ATOM    800  CG  LEU A  57      51.757  46.254  39.976  1.00  0.00           C  
ATOM    801  CD1 LEU A  57      52.946  47.203  39.806  1.00  0.00           C  
ATOM    802  CD2 LEU A  57      50.591  46.628  39.061  1.00  0.00           C  
ATOM    803  H   LEU A  57      51.174  43.930  41.981  1.00  0.00           H  
ATOM    804  HA  LEU A  57      50.284  44.017  39.208  1.00  0.00           H  
ATOM    805  HB2 LEU A  57      52.975  44.564  40.468  1.00  0.00           H  
ATOM    806  HB3 LEU A  57      52.608  44.711  38.761  1.00  0.00           H  
ATOM    807  HG  LEU A  57      51.408  46.359  41.003  1.00  0.00           H  
ATOM    808 HD11 LEU A  57      52.870  48.014  40.529  1.00  0.00           H  
ATOM    809 HD12 LEU A  57      53.874  46.656  39.971  1.00  0.00           H  
ATOM    810 HD13 LEU A  57      52.942  47.613  38.796  1.00  0.00           H  
ATOM    811 HD21 LEU A  57      49.730  45.999  39.293  1.00  0.00           H  
ATOM    812 HD22 LEU A  57      50.328  47.674  39.215  1.00  0.00           H  
ATOM    813 HD23 LEU A  57      50.881  46.475  38.021  1.00  0.00           H  
ATOM    814  N   ILE A  58      51.254  41.897  38.377  1.00  0.00           N  
ATOM    815  CA  ILE A  58      51.631  40.563  37.945  1.00  0.00           C  
ATOM    816  C   ILE A  58      52.339  40.651  36.591  1.00  0.00           C  
ATOM    817  O   ILE A  58      51.943  41.436  35.730  1.00  0.00           O  
ATOM    818  CB  ILE A  58      50.415  39.635  37.944  1.00  0.00           C  
ATOM    819  CG1 ILE A  58      49.746  39.607  39.320  1.00  0.00           C  
ATOM    820  CG2 ILE A  58      50.794  38.233  37.462  1.00  0.00           C  
ATOM    821  CD1 ILE A  58      48.228  39.472  39.189  1.00  0.00           C  
ATOM    822  H   ILE A  58      50.774  42.444  37.690  1.00  0.00           H  
ATOM    823  HA  ILE A  58      52.336  40.169  38.678  1.00  0.00           H  
ATOM    824  HB  ILE A  58      49.684  40.031  37.238  1.00  0.00           H  
ATOM    825 HG12 ILE A  58      50.139  38.773  39.902  1.00  0.00           H  
ATOM    826 HG13 ILE A  58      49.988  40.520  39.865  1.00  0.00           H  
ATOM    827 HG21 ILE A  58      49.895  37.698  37.158  1.00  0.00           H  
ATOM    828 HG22 ILE A  58      51.475  38.312  36.614  1.00  0.00           H  
ATOM    829 HG23 ILE A  58      51.285  37.691  38.271  1.00  0.00           H  
ATOM    830 HD11 ILE A  58      47.922  38.476  39.507  1.00  0.00           H  
ATOM    831 HD12 ILE A  58      47.742  40.220  39.816  1.00  0.00           H  
ATOM    832 HD13 ILE A  58      47.938  39.626  38.149  1.00  0.00           H  
ATOM    833  N   PRO A  59      53.399  39.813  36.441  1.00  0.00           N  
ATOM    834  CA  PRO A  59      54.165  39.789  35.206  1.00  0.00           C  
ATOM    835  C   PRO A  59      53.395  39.070  34.097  1.00  0.00           C  
ATOM    836  O   PRO A  59      53.066  37.891  34.229  1.00  0.00           O  
ATOM    837  CB  PRO A  59      55.472  39.100  35.566  1.00  0.00           C  
ATOM    838  CG  PRO A  59      55.204  38.352  36.862  1.00  0.00           C  
ATOM    839  CD  PRO A  59      53.896  38.870  37.438  1.00  0.00           C  
ATOM    840  HA  PRO A  59      54.317  40.720  34.874  1.00  0.00           H  
ATOM    841  HB2 PRO A  59      55.782  38.416  34.777  1.00  0.00           H  
ATOM    842  HB3 PRO A  59      56.274  39.827  35.693  1.00  0.00           H  
ATOM    843  HG2 PRO A  59      55.142  37.280  36.679  1.00  0.00           H  
ATOM    844  HG3 PRO A  59      56.020  38.508  37.568  1.00  0.00           H  
ATOM    845  HD2 PRO A  59      53.187  38.059  37.603  1.00  0.00           H  
ATOM    846  HD3 PRO A  59      54.053  39.358  38.401  1.00  0.00           H  
ATOM    847  N   GLU A  60      53.130  39.807  33.030  1.00  0.00           N  
ATOM    848  CA  GLU A  60      52.405  39.254  31.898  1.00  0.00           C  
ATOM    849  C   GLU A  60      53.211  38.124  31.252  1.00  0.00           C  
ATOM    850  O   GLU A  60      52.650  37.270  30.569  1.00  0.00           O  
ATOM    851  CB  GLU A  60      52.070  40.342  30.876  1.00  0.00           C  
ATOM    852  CG  GLU A  60      51.721  39.730  29.519  1.00  0.00           C  
ATOM    853  CD  GLU A  60      50.735  40.616  28.754  1.00  0.00           C  
ATOM    854  OE1 GLU A  60      51.151  41.731  28.373  1.00  0.00           O  
ATOM    855  OE2 GLU A  60      49.587  40.158  28.569  1.00  0.00           O  
ATOM    856  H   GLU A  60      53.401  40.765  32.930  1.00  0.00           H  
ATOM    857  HA  GLU A  60      51.479  38.857  32.314  1.00  0.00           H  
ATOM    858  HB2 GLU A  60      51.232  40.939  31.237  1.00  0.00           H  
ATOM    859  HB3 GLU A  60      52.918  41.018  30.768  1.00  0.00           H  
ATOM    860  HG2 GLU A  60      52.629  39.600  28.930  1.00  0.00           H  
ATOM    861  HG3 GLU A  60      51.289  38.740  29.661  1.00  0.00           H  
ATOM    862  N   ASN A  61      54.513  38.158  31.493  1.00  0.00           N  
ATOM    863  CA  ASN A  61      55.401  37.147  30.943  1.00  0.00           C  
ATOM    864  C   ASN A  61      55.500  35.976  31.921  1.00  0.00           C  
ATOM    865  O   ASN A  61      56.433  35.177  31.846  1.00  0.00           O  
ATOM    866  CB  ASN A  61      56.809  37.708  30.732  1.00  0.00           C  
ATOM    867  CG  ASN A  61      56.768  39.000  29.914  1.00  0.00           C  
ATOM    868  OD1 ASN A  61      56.679  38.992  28.697  1.00  0.00           O  
ATOM    869  ND2 ASN A  61      56.837  40.107  30.647  1.00  0.00           N  
ATOM    870  H   ASN A  61      54.962  38.857  32.050  1.00  0.00           H  
ATOM    871  HA  ASN A  61      54.954  36.860  29.992  1.00  0.00           H  
ATOM    872  HB2 ASN A  61      57.277  37.900  31.698  1.00  0.00           H  
ATOM    873  HB3 ASN A  61      57.425  36.969  30.220  1.00  0.00           H  
ATOM    874 HD21 ASN A  61      56.909  40.044  31.642  1.00  0.00           H  
ATOM    875 HD22 ASN A  61      56.817  41.003  30.203  1.00  0.00           H  
ATOM    876  N   TYR A  62      54.527  35.909  32.818  1.00  0.00           N  
ATOM    877  CA  TYR A  62      54.493  34.848  33.810  1.00  0.00           C  
ATOM    878  C   TYR A  62      53.066  34.335  34.015  1.00  0.00           C  
ATOM    879  O   TYR A  62      52.800  33.594  34.959  1.00  0.00           O  
ATOM    880  CB  TYR A  62      54.990  35.474  35.114  1.00  0.00           C  
ATOM    881  CG  TYR A  62      56.275  34.845  35.656  1.00  0.00           C  
ATOM    882  CD1 TYR A  62      57.395  34.762  34.855  1.00  0.00           C  
ATOM    883  CD2 TYR A  62      56.313  34.360  36.948  1.00  0.00           C  
ATOM    884  CE1 TYR A  62      58.604  34.169  35.365  1.00  0.00           C  
ATOM    885  CE2 TYR A  62      57.522  33.767  37.459  1.00  0.00           C  
ATOM    886  CZ  TYR A  62      58.608  33.701  36.641  1.00  0.00           C  
ATOM    887  OH  TYR A  62      59.750  33.141  37.124  1.00  0.00           O  
ATOM    888  H   TYR A  62      53.771  36.563  32.872  1.00  0.00           H  
ATOM    889  HA  TYR A  62      55.116  34.031  33.449  1.00  0.00           H  
ATOM    890  HB2 TYR A  62      55.160  36.540  34.952  1.00  0.00           H  
ATOM    891  HB3 TYR A  62      54.208  35.387  35.867  1.00  0.00           H  
ATOM    892  HD1 TYR A  62      57.364  35.145  33.834  1.00  0.00           H  
ATOM    893  HD2 TYR A  62      55.428  34.425  37.581  1.00  0.00           H  
ATOM    894  HE1 TYR A  62      59.495  34.097  34.742  1.00  0.00           H  
ATOM    895  HE2 TYR A  62      57.566  33.380  38.477  1.00  0.00           H  
ATOM    896  HH  TYR A  62      59.637  32.914  38.092  1.00  0.00           H  
ATOM    897  N   VAL A  63      52.187  34.751  33.115  1.00  0.00           N  
ATOM    898  CA  VAL A  63      50.794  34.343  33.188  1.00  0.00           C  
ATOM    899  C   VAL A  63      50.353  33.808  31.823  1.00  0.00           C  
ATOM    900  O   VAL A  63      51.058  33.977  30.829  1.00  0.00           O  
ATOM    901  CB  VAL A  63      49.932  35.507  33.680  1.00  0.00           C  
ATOM    902  CG1 VAL A  63      50.108  35.722  35.184  1.00  0.00           C  
ATOM    903  CG2 VAL A  63      50.244  36.788  32.902  1.00  0.00           C  
ATOM    904  H   VAL A  63      52.412  35.354  32.351  1.00  0.00           H  
ATOM    905  HA  VAL A  63      50.724  33.538  33.919  1.00  0.00           H  
ATOM    906  HB  VAL A  63      48.888  35.251  33.498  1.00  0.00           H  
ATOM    907 HG11 VAL A  63      50.349  36.768  35.375  1.00  0.00           H  
ATOM    908 HG12 VAL A  63      49.184  35.461  35.699  1.00  0.00           H  
ATOM    909 HG13 VAL A  63      50.918  35.090  35.549  1.00  0.00           H  
ATOM    910 HG21 VAL A  63      50.912  36.555  32.072  1.00  0.00           H  
ATOM    911 HG22 VAL A  63      49.318  37.212  32.515  1.00  0.00           H  
ATOM    912 HG23 VAL A  63      50.724  37.507  33.565  1.00  0.00           H  
ATOM    913  N   GLU A  64      49.190  33.174  31.819  1.00  0.00           N  
ATOM    914  CA  GLU A  64      48.648  32.613  30.594  1.00  0.00           C  
ATOM    915  C   GLU A  64      47.118  32.624  30.636  1.00  0.00           C  
ATOM    916  O   GLU A  64      46.498  31.662  31.084  1.00  0.00           O  
ATOM    917  CB  GLU A  64      49.179  31.198  30.356  1.00  0.00           C  
ATOM    918  CG  GLU A  64      48.275  30.428  29.390  1.00  0.00           C  
ATOM    919  CD  GLU A  64      49.103  29.581  28.422  1.00  0.00           C  
ATOM    920  OE1 GLU A  64      50.007  28.874  28.917  1.00  0.00           O  
ATOM    921  OE2 GLU A  64      48.813  29.659  27.209  1.00  0.00           O  
ATOM    922  H   GLU A  64      48.623  33.041  32.632  1.00  0.00           H  
ATOM    923  HA  GLU A  64      49.001  33.266  29.795  1.00  0.00           H  
ATOM    924  HB2 GLU A  64      50.190  31.248  29.952  1.00  0.00           H  
ATOM    925  HB3 GLU A  64      49.240  30.665  31.304  1.00  0.00           H  
ATOM    926  HG2 GLU A  64      47.598  29.786  29.953  1.00  0.00           H  
ATOM    927  HG3 GLU A  64      47.656  31.129  28.829  1.00  0.00           H  
ATOM    928  N   PHE A  65      46.553  33.726  30.164  1.00  0.00           N  
ATOM    929  CA  PHE A  65      45.109  33.876  30.142  1.00  0.00           C  
ATOM    930  C   PHE A  65      44.428  32.576  29.709  1.00  0.00           C  
ATOM    931  O   PHE A  65      44.856  31.937  28.749  1.00  0.00           O  
ATOM    932  CB  PHE A  65      44.787  34.971  29.122  1.00  0.00           C  
ATOM    933  CG  PHE A  65      45.025  36.391  29.637  1.00  0.00           C  
ATOM    934  CD1 PHE A  65      44.026  37.058  30.278  1.00  0.00           C  
ATOM    935  CD2 PHE A  65      46.233  36.988  29.454  1.00  0.00           C  
ATOM    936  CE1 PHE A  65      44.247  38.376  30.757  1.00  0.00           C  
ATOM    937  CE2 PHE A  65      46.453  38.307  29.933  1.00  0.00           C  
ATOM    938  CZ  PHE A  65      45.456  38.973  30.574  1.00  0.00           C  
ATOM    939  H   PHE A  65      47.064  34.506  29.801  1.00  0.00           H  
ATOM    940  HA  PHE A  65      44.794  34.128  31.155  1.00  0.00           H  
ATOM    941  HB2 PHE A  65      45.395  34.812  28.231  1.00  0.00           H  
ATOM    942  HB3 PHE A  65      43.745  34.875  28.817  1.00  0.00           H  
ATOM    943  HD1 PHE A  65      43.059  36.579  30.425  1.00  0.00           H  
ATOM    944  HD2 PHE A  65      47.032  36.455  28.940  1.00  0.00           H  
ATOM    945  HE1 PHE A  65      43.447  38.910  31.270  1.00  0.00           H  
ATOM    946  HE2 PHE A  65      47.421  38.786  29.786  1.00  0.00           H  
ATOM    947  HZ  PHE A  65      45.624  39.986  30.941  1.00  0.00           H  
ATOM    948  N   LEU A  66      43.380  32.222  30.438  1.00  0.00           N  
ATOM    949  CA  LEU A  66      42.637  31.010  30.141  1.00  0.00           C  
ATOM    950  C   LEU A  66      41.371  31.371  29.362  1.00  0.00           C  
ATOM    951  O   LEU A  66      40.628  32.267  29.758  1.00  0.00           O  
ATOM    952  CB  LEU A  66      42.365  30.220  31.424  1.00  0.00           C  
ATOM    953  CG  LEU A  66      43.497  30.206  32.454  1.00  0.00           C  
ATOM    954  CD1 LEU A  66      42.976  30.575  33.845  1.00  0.00           C  
ATOM    955  CD2 LEU A  66      44.222  28.858  32.453  1.00  0.00           C  
ATOM    956  H   LEU A  66      43.038  32.748  31.218  1.00  0.00           H  
ATOM    957  HA  LEU A  66      43.268  30.387  29.507  1.00  0.00           H  
ATOM    958  HB2 LEU A  66      41.474  30.631  31.898  1.00  0.00           H  
ATOM    959  HB3 LEU A  66      42.136  29.190  31.151  1.00  0.00           H  
ATOM    960  HG  LEU A  66      44.226  30.964  32.172  1.00  0.00           H  
ATOM    961 HD11 LEU A  66      42.991  31.659  33.962  1.00  0.00           H  
ATOM    962 HD12 LEU A  66      41.955  30.211  33.959  1.00  0.00           H  
ATOM    963 HD13 LEU A  66      43.611  30.119  34.604  1.00  0.00           H  
ATOM    964 HD21 LEU A  66      43.793  28.216  31.684  1.00  0.00           H  
ATOM    965 HD22 LEU A  66      45.281  29.017  32.247  1.00  0.00           H  
ATOM    966 HD23 LEU A  66      44.108  28.384  33.428  1.00  0.00           H  
ATOM    967  N   SER A  67      41.164  30.653  28.267  1.00  0.00           N  
ATOM    968  CA  SER A  67      40.001  30.888  27.429  1.00  0.00           C  
ATOM    969  C   SER A  67      39.295  29.562  27.133  1.00  0.00           C  
ATOM    970  O   SER A  67      38.102  29.417  27.397  1.00  0.00           O  
ATOM    971  CB  SER A  67      40.392  31.584  26.124  1.00  0.00           C  
ATOM    972  OG  SER A  67      39.259  31.867  25.309  1.00  0.00           O  
ATOM    973  H   SER A  67      41.773  29.927  27.952  1.00  0.00           H  
ATOM    974  HA  SER A  67      39.353  31.543  28.010  1.00  0.00           H  
ATOM    975  HB2 SER A  67      40.917  32.511  26.352  1.00  0.00           H  
ATOM    976  HB3 SER A  67      41.088  30.952  25.571  1.00  0.00           H  
ATOM    977  HG  SER A  67      38.689  31.051  25.219  1.00  0.00           H  
ATOM    978  N   GLY A  68      40.061  28.629  26.587  1.00  0.00           N  
ATOM    979  CA  GLY A  68      39.524  27.322  26.251  1.00  0.00           C  
ATOM    980  C   GLY A  68      39.584  26.379  27.455  1.00  0.00           C  
ATOM    981  O   GLY A  68      40.351  26.607  28.389  1.00  0.00           O  
ATOM    982  H   GLY A  68      41.030  28.756  26.375  1.00  0.00           H  
ATOM    983  HA2 GLY A  68      38.493  27.424  25.915  1.00  0.00           H  
ATOM    984  HA3 GLY A  68      40.089  26.895  25.422  1.00  0.00           H  
ATOM    985  N   PRO A  69      38.742  25.313  27.393  1.00  0.00           N  
ATOM    986  CA  PRO A  69      38.692  24.335  28.467  1.00  0.00           C  
ATOM    987  C   PRO A  69      39.914  23.416  28.428  1.00  0.00           C  
ATOM    988  O   PRO A  69      40.202  22.803  27.402  1.00  0.00           O  
ATOM    989  CB  PRO A  69      37.382  23.591  28.261  1.00  0.00           C  
ATOM    990  CG  PRO A  69      36.973  23.860  26.821  1.00  0.00           C  
ATOM    991  CD  PRO A  69      37.818  25.012  26.303  1.00  0.00           C  
ATOM    992  HA  PRO A  69      38.722  24.793  29.355  1.00  0.00           H  
ATOM    993  HB2 PRO A  69      37.507  22.524  28.438  1.00  0.00           H  
ATOM    994  HB3 PRO A  69      36.620  23.943  28.956  1.00  0.00           H  
ATOM    995  HG2 PRO A  69      37.122  22.971  26.209  1.00  0.00           H  
ATOM    996  HG3 PRO A  69      35.913  24.111  26.767  1.00  0.00           H  
ATOM    997  HD2 PRO A  69      38.355  24.732  25.396  1.00  0.00           H  
ATOM    998  HD3 PRO A  69      37.202  25.876  26.055  1.00  0.00           H  
ATOM    999  N   SER A  70      40.600  23.349  29.560  1.00  0.00           N  
ATOM   1000  CA  SER A  70      41.785  22.514  29.669  1.00  0.00           C  
ATOM   1001  C   SER A  70      42.064  22.192  31.138  1.00  0.00           C  
ATOM   1002  O   SER A  70      42.111  21.025  31.522  1.00  0.00           O  
ATOM   1003  CB  SER A  70      42.998  23.196  29.034  1.00  0.00           C  
ATOM   1004  OG  SER A  70      43.838  22.266  28.355  1.00  0.00           O  
ATOM   1005  H   SER A  70      40.358  23.850  30.390  1.00  0.00           H  
ATOM   1006  HA  SER A  70      41.549  21.605  29.116  1.00  0.00           H  
ATOM   1007  HB2 SER A  70      42.660  23.959  28.333  1.00  0.00           H  
ATOM   1008  HB3 SER A  70      43.573  23.706  29.807  1.00  0.00           H  
ATOM   1009  HG  SER A  70      43.373  21.385  28.269  1.00  0.00           H  
ATOM   1010  N   SER A  71      42.241  23.247  31.919  1.00  0.00           N  
ATOM   1011  CA  SER A  71      42.516  23.091  33.338  1.00  0.00           C  
ATOM   1012  C   SER A  71      43.805  22.291  33.537  1.00  0.00           C  
ATOM   1013  O   SER A  71      44.345  21.731  32.584  1.00  0.00           O  
ATOM   1014  CB  SER A  71      41.349  22.405  34.051  1.00  0.00           C  
ATOM   1015  OG  SER A  71      40.713  23.270  34.987  1.00  0.00           O  
ATOM   1016  H   SER A  71      42.202  24.194  31.598  1.00  0.00           H  
ATOM   1017  HA  SER A  71      42.631  24.105  33.722  1.00  0.00           H  
ATOM   1018  HB2 SER A  71      40.620  22.069  33.314  1.00  0.00           H  
ATOM   1019  HB3 SER A  71      41.712  21.517  34.567  1.00  0.00           H  
ATOM   1020  HG  SER A  71      41.139  23.174  35.886  1.00  0.00           H  
ATOM   1021  N   GLY A  72      44.259  22.262  34.780  1.00  0.00           N  
ATOM   1022  CA  GLY A  72      45.474  21.540  35.117  1.00  0.00           C  
ATOM   1023  C   GLY A  72      46.674  22.487  35.182  1.00  0.00           C  
ATOM   1024  O   GLY A  72      46.862  23.190  36.173  1.00  0.00           O  
ATOM   1025  H   GLY A  72      43.813  22.720  35.549  1.00  0.00           H  
ATOM   1026  HA2 GLY A  72      45.350  21.039  36.077  1.00  0.00           H  
ATOM   1027  HA3 GLY A  72      45.657  20.765  34.373  1.00  0.00           H  
TER    1028      GLY A  72                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
