
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  108 ( 1608),  selected  108 , name 1x4c_A
# Molecule2: number of CA atoms   71 (  558),  selected   71 , name T0487_26_96.pdb
# PARAMETERS: 1x4c_A.T0487_26_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    R    12_A      -       -           -
LGA    R    13_A      -       -           -
LGA    S    14_A      -       -           -
LGA    E    15_A      P      26          4.955
LGA    N    16_A      W      27          0.946
LGA    R    17_A      R      28          0.897
LGA    V    18_A      L      29          0.986
LGA    V    19_A      E      30          1.005
LGA    V    20_A      V      31          0.595
LGA    S    21_A      V      32          1.037
LGA    G    22_A      L      33          2.444
LGA    L    23_A      D      34          4.411
LGA    -       -      P      35           -
LGA    P    24_A      P      36          3.163
LGA    P    25_A      P      37          1.466
LGA    S    26_A      G      38          3.169
LGA    -       -      R      39           -
LGA    -       -      E      40           -
LGA    G    27_A      E      41          3.175
LGA    S    28_A      V      42          2.421
LGA    W    29_A      Y      43          1.748
LGA    Q    30_A      P      44          2.854
LGA    D    31_A      L      45          2.932
LGA    L    32_A      L      46          1.629
LGA    K    33_A      A      47          1.774
LGA    D    34_A      Q      48          2.431
LGA    H    35_A      V      49          2.699
LGA    M    36_A      A      50          1.894
LGA    R    37_A      R      51          1.819
LGA    E    38_A      R      52          3.734
LGA    -       -      A      53           -
LGA    A    39_A      G      54          0.994
LGA    G    40_A      G      55          2.258
LGA    D    41_A      V      56          2.789
LGA    V    42_A      T      57          2.927
LGA    C    43_A      V      58          3.661
LGA    Y    44_A      R      59          3.516
LGA    A    45_A      M      60          2.990
LGA    D    46_A      G      61          2.845
LGA    V    47_A      D      62          3.054
LGA    Y    48_A      -       -           -
LGA    R    49_A      -       -           -
LGA    D    50_A      -       -           -
LGA    G    51_A      -       -           -
LGA    T    52_A      -       -           -
LGA    G    53_A      -       -           -
LGA    V    54_A      G      63          0.835
LGA    V    55_A      L      64          0.601
LGA    E    56_A      A      65          0.571
LGA    F    57_A      S      66          1.369
LGA    V    58_A      W      67          2.916
LGA    R    59_A      S      68          2.578
LGA    K    60_A      -       -           -
LGA    E    61_A      P      69          2.378
LGA    D    62_A      -       -           -
LGA    M    63_A      P      70          3.457
LGA    T    64_A      E      71          2.627
LGA    Y    65_A      V      72          2.181
LGA    A    66_A      L      73          2.084
LGA    V    67_A      V      74          4.459
LGA    R    68_A      L      75          4.518
LGA    K    69_A      -       -           -
LGA    L    70_A      -       -           -
LGA    D    71_A      -       -           -
LGA    N    72_A      E      76          3.170
LGA    T    73_A      G      77          1.879
LGA    K    74_A      T      78          1.745
LGA    F    75_A      L      79          2.111
LGA    R    76_A      A      80          2.052
LGA    S    77_A      R      81          2.661
LGA    H    78_A      -       -           -
LGA    E    79_A      M      82          3.227
LGA    G    80_A      G      83          2.581
LGA    E    81_A      Q      84          1.535
LGA    T    82_A      T      85          1.086
LGA    A    83_A      Y      86          1.411
LGA    Y    84_A      A      87          1.446
LGA    I    85_A      Y      88          1.276
LGA    R    86_A      R      89          0.793
LGA    V    87_A      L      90          0.776
LGA    K    88_A      Y      91          2.101
LGA    V    89_A      P      92          0.781
LGA    D    90_A      K      93          0.915
LGA    G    91_A      G      94          4.606
LGA    P    92_A      R      95           -
LGA    R    93_A      R      96           -
LGA    S    94_A      -       -           -
LGA    P    95_A      -       -           -
LGA    S    96_A      -       -           -
LGA    Y    97_A      -       -           -
LGA    G    98_A      -       -           -
LGA    R    99_A      -       -           -
LGA    S   100_A      -       -           -
LGA    R   101_A      -       -           -
LGA    S   102_A      -       -           -
LGA    S   103_A      -       -           -
LGA    G   104_A      -       -           -
LGA    P   105_A      -       -           -
LGA    S   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    G   108_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  108   71    5.0     65    2.50    18.46     59.523     2.499

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.919270 * X  +  -0.362977 * Y  +   0.152283 * Z  +  60.795162
  Y_new =   0.369406 * X  +  -0.929143 * Y  +   0.015278 * Z  +  16.379507
  Z_new =   0.135947 * X  +   0.070299 * Y  +   0.988219 * Z  +  58.977066 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.071017   -3.070575  [ DEG:     4.0690   -175.9310 ]
  Theta =  -0.136370   -3.005223  [ DEG:    -7.8134   -172.1866 ]
  Phi   =   2.759495   -0.382097  [ DEG:   158.1074    -21.8926 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x4c_A                                        
REMARK     2: T0487_26_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x4c_A.T0487_26_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  108   71   5.0   65   2.50   18.46  59.523
REMARK  ---------------------------------------------------------- 
MOLECULE 1x4c_A
HEADER    RNA BINDING PROTEIN                     14-MAY-05   1X4C              
TITLE     SOLUTION STRUCTURE OF RRM DOMAIN IN SPLICING FACTOR 2                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SPLICING FACTOR, ARGININE/SERINE-RICH 1;                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RRM DOMAIN;                                                
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: SFRS1;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040113-41;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, STRUCTURAL GENOMICS, RRM DOMAIN, NPPSFA, NATIONAL                
KEYWDS   2 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    F.HE,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,S.YOKOYAMA,          
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   14-NOV-05 1X4C    0                                                
JRNL        AUTH   F.HE,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,            
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF RRM DOMAIN IN SPLICING                 
JRNL        TITL 2 FACTOR 2                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1X4C A    8   102  UNP    Q6PDM2   SFRS1_MOUSE    112    206             
SEQRES   1 A  108  GLY SER SER GLY SER SER GLY GLY PRO PRO SER ARG ARG          
SEQRES   2 A  108  SER GLU ASN ARG VAL VAL VAL SER GLY LEU PRO PRO SER          
SEQRES   3 A  108  GLY SER TRP GLN ASP LEU LYS ASP HIS MET ARG GLU ALA          
SEQRES   4 A  108  GLY ASP VAL CYS TYR ALA ASP VAL TYR ARG ASP GLY THR          
SEQRES   5 A  108  GLY VAL VAL GLU PHE VAL ARG LYS GLU ASP MET THR TYR          
SEQRES   6 A  108  ALA VAL ARG LYS LEU ASP ASN THR LYS PHE ARG SER HIS          
SEQRES   7 A  108  GLU GLY GLU THR ALA TYR ILE ARG VAL LYS VAL ASP GLY          
SEQRES   8 A  108  PRO ARG SER PRO SER TYR GLY ARG SER ARG SER SER GLY          
SEQRES   9 A  108  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      67.415 -10.024  67.979  1.00  0.00           N  
ATOM      2  CA  GLY A   1      66.645  -9.152  68.846  1.00  0.00           C  
ATOM      3  C   GLY A   1      67.524  -8.318  69.758  1.00  0.00           C  
ATOM      4  O   GLY A   1      68.077  -8.825  70.732  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      66.048  -8.491  68.234  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      65.987  -9.755  69.454  1.00  0.00           H  
ATOM      7  H1  GLY A   1      66.997 -10.414  67.183  1.00  0.00           H  
ATOM      8  N   SER A   2      67.653  -7.033  69.439  1.00  0.00           N  
ATOM      9  CA  SER A   2      68.475  -6.128  70.233  1.00  0.00           C  
ATOM     10  C   SER A   2      67.638  -5.428  71.299  1.00  0.00           C  
ATOM     11  O   SER A   2      67.780  -4.227  71.526  1.00  0.00           O  
ATOM     12  CB  SER A   2      69.144  -5.089  69.331  1.00  0.00           C  
ATOM     13  OG  SER A   2      70.543  -5.046  69.555  1.00  0.00           O  
ATOM     14  H   SER A   2      67.185  -6.687  68.649  1.00  0.00           H  
ATOM     15  HA  SER A   2      69.240  -6.716  70.719  1.00  0.00           H  
ATOM     16  HB2 SER A   2      68.966  -5.344  68.297  1.00  0.00           H  
ATOM     17  HB3 SER A   2      68.728  -4.115  69.539  1.00  0.00           H  
ATOM     18  HG  SER A   2      70.992  -5.560  68.879  1.00  0.00           H  
ATOM     19  N   SER A   3      66.764  -6.189  71.951  1.00  0.00           N  
ATOM     20  CA  SER A   3      65.901  -5.642  72.990  1.00  0.00           C  
ATOM     21  C   SER A   3      64.951  -4.597  72.414  1.00  0.00           C  
ATOM     22  O   SER A   3      65.192  -4.049  71.340  1.00  0.00           O  
ATOM     23  CB  SER A   3      66.742  -5.023  74.109  1.00  0.00           C  
ATOM     24  OG  SER A   3      66.744  -5.847  75.261  1.00  0.00           O  
ATOM     25  H   SER A   3      66.697  -7.140  71.725  1.00  0.00           H  
ATOM     26  HA  SER A   3      65.318  -6.455  73.399  1.00  0.00           H  
ATOM     27  HB2 SER A   3      67.758  -4.901  73.765  1.00  0.00           H  
ATOM     28  HB3 SER A   3      66.333  -4.058  74.370  1.00  0.00           H  
ATOM     29  HG  SER A   3      65.843  -6.097  75.478  1.00  0.00           H  
ATOM     30  N   GLY A   4      63.870  -4.326  73.138  1.00  0.00           N  
ATOM     31  CA  GLY A   4      62.898  -3.347  72.685  1.00  0.00           C  
ATOM     32  C   GLY A   4      61.944  -2.924  73.783  1.00  0.00           C  
ATOM     33  O   GLY A   4      61.762  -3.642  74.766  1.00  0.00           O  
ATOM     34  H   GLY A   4      63.729  -4.794  73.988  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      63.425  -2.476  72.323  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      62.329  -3.773  71.871  1.00  0.00           H  
ATOM     37  N   SER A   5      61.334  -1.755  73.618  1.00  0.00           N  
ATOM     38  CA  SER A   5      60.397  -1.234  74.605  1.00  0.00           C  
ATOM     39  C   SER A   5      59.146  -0.680  73.929  1.00  0.00           C  
ATOM     40  O   SER A   5      59.234   0.105  72.986  1.00  0.00           O  
ATOM     41  CB  SER A   5      61.062  -0.143  75.446  1.00  0.00           C  
ATOM     42  OG  SER A   5      60.403   0.017  76.690  1.00  0.00           O  
ATOM     43  H   SER A   5      61.522  -1.228  72.811  1.00  0.00           H  
ATOM     44  HA  SER A   5      60.110  -2.051  75.253  1.00  0.00           H  
ATOM     45  HB2 SER A   5      62.092  -0.410  75.629  1.00  0.00           H  
ATOM     46  HB3 SER A   5      61.024   0.793  74.909  1.00  0.00           H  
ATOM     47  HG  SER A   5      59.912   0.840  76.690  1.00  0.00           H  
ATOM     48  N   SER A   6      57.983  -1.096  74.419  1.00  0.00           N  
ATOM     49  CA  SER A   6      56.714  -0.646  73.861  1.00  0.00           C  
ATOM     50  C   SER A   6      55.754  -0.218  74.968  1.00  0.00           C  
ATOM     51  O   SER A   6      56.042  -0.384  76.152  1.00  0.00           O  
ATOM     52  CB  SER A   6      56.078  -1.756  73.021  1.00  0.00           C  
ATOM     53  OG  SER A   6      55.978  -1.372  71.661  1.00  0.00           O  
ATOM     54  H   SER A   6      57.978  -1.723  75.172  1.00  0.00           H  
ATOM     55  HA  SER A   6      56.914   0.205  73.226  1.00  0.00           H  
ATOM     56  HB2 SER A   6      56.686  -2.646  73.088  1.00  0.00           H  
ATOM     57  HB3 SER A   6      55.088  -1.967  73.398  1.00  0.00           H  
ATOM     58  HG  SER A   6      55.720  -0.449  71.606  1.00  0.00           H  
ATOM     59  N   GLY A   7      54.612   0.334  74.571  1.00  0.00           N  
ATOM     60  CA  GLY A   7      53.626   0.778  75.540  1.00  0.00           C  
ATOM     61  C   GLY A   7      53.371   2.270  75.466  1.00  0.00           C  
ATOM     62  O   GLY A   7      53.439   2.969  76.475  1.00  0.00           O  
ATOM     63  H   GLY A   7      54.436   0.441  73.612  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      52.699   0.254  75.360  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      53.979   0.534  76.532  1.00  0.00           H  
ATOM     66  N   GLY A   8      53.076   2.760  74.266  1.00  0.00           N  
ATOM     67  CA  GLY A   8      52.815   4.175  74.085  1.00  0.00           C  
ATOM     68  C   GLY A   8      52.263   4.493  72.711  1.00  0.00           C  
ATOM     69  O   GLY A   8      51.060   4.409  72.466  1.00  0.00           O  
ATOM     70  H   GLY A   8      53.035   2.154  73.495  1.00  0.00           H  
ATOM     71  HA2 GLY A   8      52.105   4.498  74.831  1.00  0.00           H  
ATOM     72  HA3 GLY A   8      53.739   4.719  74.224  1.00  0.00           H  
ATOM     73  N   PRO A   9      53.155   4.871  71.782  1.00  0.00           N  
ATOM     74  CA  PRO A   9      52.772   5.210  70.408  1.00  0.00           C  
ATOM     75  C   PRO A   9      52.315   3.991  69.615  1.00  0.00           C  
ATOM     76  O   PRO A   9      52.795   2.874  69.815  1.00  0.00           O  
ATOM     77  CB  PRO A   9      54.061   5.783  69.813  1.00  0.00           C  
ATOM     78  CG  PRO A   9      55.155   5.166  70.613  1.00  0.00           C  
ATOM     79  CD  PRO A   9      54.607   4.993  72.002  1.00  0.00           C  
ATOM     80  HA  PRO A   9      51.998   5.963  70.387  1.00  0.00           H  
ATOM     81  HB2 PRO A   9      54.131   5.510  68.769  1.00  0.00           H  
ATOM     82  HB3 PRO A   9      54.060   6.858  69.910  1.00  0.00           H  
ATOM     83  HG2 PRO A   9      55.423   4.208  70.193  1.00  0.00           H  
ATOM     84  HG3 PRO A   9      56.013   5.822  70.629  1.00  0.00           H  
ATOM     85  HD2 PRO A   9      55.004   4.098  72.456  1.00  0.00           H  
ATOM     86  HD3 PRO A   9      54.832   5.858  72.607  1.00  0.00           H  
ATOM     87  N   PRO A  10      51.368   4.206  68.691  1.00  0.00           N  
ATOM     88  CA  PRO A  10      50.825   3.136  67.848  1.00  0.00           C  
ATOM     89  C   PRO A  10      51.841   2.631  66.829  1.00  0.00           C  
ATOM     90  O   PRO A  10      51.737   1.506  66.341  1.00  0.00           O  
ATOM     91  CB  PRO A  10      49.646   3.804  67.140  1.00  0.00           C  
ATOM     92  CG  PRO A  10      49.981   5.256  67.132  1.00  0.00           C  
ATOM     93  CD  PRO A  10      50.751   5.510  68.399  1.00  0.00           C  
ATOM     94  HA  PRO A  10      50.469   2.306  68.441  1.00  0.00           H  
ATOM     95  HB2 PRO A  10      49.554   3.413  66.137  1.00  0.00           H  
ATOM     96  HB3 PRO A  10      48.736   3.615  67.690  1.00  0.00           H  
ATOM     97  HG2 PRO A  10      50.591   5.486  66.270  1.00  0.00           H  
ATOM     98  HG3 PRO A  10      49.075   5.842  67.120  1.00  0.00           H  
ATOM     99  HD2 PRO A  10      51.505   6.266  68.237  1.00  0.00           H  
ATOM    100  HD3 PRO A  10      50.082   5.807  69.193  1.00  0.00           H  
ATOM    101  N   SER A  11      52.823   3.468  66.514  1.00  0.00           N  
ATOM    102  CA  SER A  11      53.855   3.108  65.549  1.00  0.00           C  
ATOM    103  C   SER A  11      54.186   1.620  65.638  1.00  0.00           C  
ATOM    104  O   SER A  11      54.910   1.187  66.533  1.00  0.00           O  
ATOM    105  CB  SER A  11      55.119   3.938  65.789  1.00  0.00           C  
ATOM    106  OG  SER A  11      55.068   5.160  65.074  1.00  0.00           O  
ATOM    107  H   SER A  11      52.851   4.353  66.937  1.00  0.00           H  
ATOM    108  HA  SER A  11      53.476   3.322  64.562  1.00  0.00           H  
ATOM    109  HB2 SER A  11      55.211   4.153  66.842  1.00  0.00           H  
ATOM    110  HB3 SER A  11      55.982   3.377  65.459  1.00  0.00           H  
ATOM    111  HG  SER A  11      55.687   5.784  65.462  1.00  0.00           H  
ATOM    112  N   ARG A  12      53.647   0.845  64.702  1.00  0.00           N  
ATOM    113  CA  ARG A  12      53.883  -0.594  64.675  1.00  0.00           C  
ATOM    114  C   ARG A  12      53.343  -1.209  63.388  1.00  0.00           C  
ATOM    115  O   ARG A  12      52.303  -0.790  62.876  1.00  0.00           O  
ATOM    116  CB  ARG A  12      53.230  -1.262  65.886  1.00  0.00           C  
ATOM    117  CG  ARG A  12      54.229  -1.832  66.879  1.00  0.00           C  
ATOM    118  CD  ARG A  12      53.577  -2.851  67.801  1.00  0.00           C  
ATOM    119  NE  ARG A  12      53.416  -4.150  67.155  1.00  0.00           N  
ATOM    120  CZ  ARG A  12      52.563  -5.080  67.574  1.00  0.00           C  
ATOM    121  NH1 ARG A  12      51.799  -4.853  68.634  1.00  0.00           N  
ATOM    122  NH2 ARG A  12      52.474  -6.237  66.932  1.00  0.00           N  
ATOM    123  H   ARG A  12      53.079   1.249  64.015  1.00  0.00           H  
ATOM    124  HA  ARG A  12      54.950  -0.755  64.718  1.00  0.00           H  
ATOM    125  HB2 ARG A  12      52.621  -0.533  66.400  1.00  0.00           H  
ATOM    126  HB3 ARG A  12      52.599  -2.067  65.540  1.00  0.00           H  
ATOM    127  HG2 ARG A  12      55.027  -2.315  66.336  1.00  0.00           H  
ATOM    128  HG3 ARG A  12      54.631  -1.027  67.474  1.00  0.00           H  
ATOM    129  HD2 ARG A  12      54.196  -2.970  68.678  1.00  0.00           H  
ATOM    130  HD3 ARG A  12      52.606  -2.482  68.094  1.00  0.00           H  
ATOM    131  HE  ARG A  12      53.971  -4.339  66.370  1.00  0.00           H  
ATOM    132 HH11 ARG A  12      51.864  -3.980  69.119  1.00  0.00           H  
ATOM    133 HH12 ARG A  12      51.158  -5.553  68.946  1.00  0.00           H  
ATOM    134 HH21 ARG A  12      53.049  -6.412  66.133  1.00  0.00           H  
ATOM    135 HH22 ARG A  12      51.833  -6.936  67.249  1.00  0.00           H  
ATOM    136  N   ARG A  13      54.055  -2.203  62.868  1.00  0.00           N  
ATOM    137  CA  ARG A  13      53.648  -2.873  61.639  1.00  0.00           C  
ATOM    138  C   ARG A  13      53.823  -1.954  60.433  1.00  0.00           C  
ATOM    139  O   ARG A  13      53.526  -2.335  59.301  1.00  0.00           O  
ATOM    140  CB  ARG A  13      52.190  -3.328  61.740  1.00  0.00           C  
ATOM    141  CG  ARG A  13      51.950  -4.728  61.201  1.00  0.00           C  
ATOM    142  CD  ARG A  13      52.561  -4.905  59.818  1.00  0.00           C  
ATOM    143  NE  ARG A  13      52.695  -6.314  59.455  1.00  0.00           N  
ATOM    144  CZ  ARG A  13      53.628  -7.115  59.954  1.00  0.00           C  
ATOM    145  NH1 ARG A  13      54.504  -6.651  60.835  1.00  0.00           N  
ATOM    146  NH2 ARG A  13      53.686  -8.386  59.575  1.00  0.00           N  
ATOM    147  H   ARG A  13      54.874  -2.492  63.321  1.00  0.00           H  
ATOM    148  HA  ARG A  13      54.278  -3.740  61.510  1.00  0.00           H  
ATOM    149  HB2 ARG A  13      51.890  -3.310  62.778  1.00  0.00           H  
ATOM    150  HB3 ARG A  13      51.572  -2.640  61.183  1.00  0.00           H  
ATOM    151  HG2 ARG A  13      52.397  -5.446  61.872  1.00  0.00           H  
ATOM    152  HG3 ARG A  13      50.886  -4.903  61.139  1.00  0.00           H  
ATOM    153  HD2 ARG A  13      51.928  -4.415  59.095  1.00  0.00           H  
ATOM    154  HD3 ARG A  13      53.538  -4.445  59.811  1.00  0.00           H  
ATOM    155  HE  ARG A  13      52.057  -6.677  58.806  1.00  0.00           H  
ATOM    156 HH11 ARG A  13      54.463  -5.694  61.124  1.00  0.00           H  
ATOM    157 HH12 ARG A  13      55.205  -7.257  61.211  1.00  0.00           H  
ATOM    158 HH21 ARG A  13      53.026  -8.739  58.911  1.00  0.00           H  
ATOM    159 HH22 ARG A  13      54.388  -8.988  59.951  1.00  0.00           H  
ATOM    160  N   SER A  14      54.303  -0.742  60.685  1.00  0.00           N  
ATOM    161  CA  SER A  14      54.513   0.234  59.623  1.00  0.00           C  
ATOM    162  C   SER A  14      55.935   0.146  59.077  1.00  0.00           C  
ATOM    163  O   SER A  14      56.687  -0.766  59.420  1.00  0.00           O  
ATOM    164  CB  SER A  14      54.239   1.649  60.138  1.00  0.00           C  
ATOM    165  OG  SER A  14      52.965   1.730  60.753  1.00  0.00           O  
ATOM    166  H   SER A  14      54.520  -0.495  61.611  1.00  0.00           H  
ATOM    167  HA  SER A  14      53.819   0.010  58.826  1.00  0.00           H  
ATOM    168  HB2 SER A  14      54.993   1.917  60.863  1.00  0.00           H  
ATOM    169  HB3 SER A  14      54.270   2.343  59.310  1.00  0.00           H  
ATOM    170  HG  SER A  14      52.326   1.239  60.232  1.00  0.00           H  
ATOM    171  N   GLU A  15      56.296   1.101  58.227  1.00  0.00           N  
ATOM    172  CA  GLU A  15      57.627   1.130  57.633  1.00  0.00           C  
ATOM    173  C   GLU A  15      57.710   2.187  56.534  1.00  0.00           C  
ATOM    174  O   GLU A  15      58.360   1.984  55.510  1.00  0.00           O  
ATOM    175  CB  GLU A  15      57.987  -0.243  57.063  1.00  0.00           C  
ATOM    176  CG  GLU A  15      56.814  -0.959  56.416  1.00  0.00           C  
ATOM    177  CD  GLU A  15      57.250  -1.973  55.375  1.00  0.00           C  
ATOM    178  OE1 GLU A  15      57.447  -1.577  54.208  1.00  0.00           O  
ATOM    179  OE2 GLU A  15      57.394  -3.162  55.730  1.00  0.00           O  
ATOM    180  H   GLU A  15      55.653   1.802  57.992  1.00  0.00           H  
ATOM    181  HA  GLU A  15      58.333   1.383  58.411  1.00  0.00           H  
ATOM    182  HB2 GLU A  15      58.762  -0.119  56.320  1.00  0.00           H  
ATOM    183  HB3 GLU A  15      58.363  -0.863  57.862  1.00  0.00           H  
ATOM    184  HG2 GLU A  15      56.254  -1.473  57.182  1.00  0.00           H  
ATOM    185  HG3 GLU A  15      56.180  -0.225  55.939  1.00  0.00           H  
ATOM    186  N   ASN A  16      57.044   3.315  56.756  1.00  0.00           N  
ATOM    187  CA  ASN A  16      57.041   4.403  55.784  1.00  0.00           C  
ATOM    188  C   ASN A  16      56.701   5.731  56.456  1.00  0.00           C  
ATOM    189  O   ASN A  16      56.059   6.595  55.857  1.00  0.00           O  
ATOM    190  CB  ASN A  16      56.037   4.114  54.665  1.00  0.00           C  
ATOM    191  CG  ASN A  16      54.974   3.118  55.087  1.00  0.00           C  
ATOM    192  OD1 ASN A  16      54.030   3.465  55.799  1.00  0.00           O  
ATOM    193  ND2 ASN A  16      55.121   1.874  54.649  1.00  0.00           N  
ATOM    194  H   ASN A  16      56.543   3.419  57.590  1.00  0.00           H  
ATOM    195  HA  ASN A  16      58.030   4.472  55.358  1.00  0.00           H  
ATOM    196  HB2 ASN A  16      55.548   5.035  54.381  1.00  0.00           H  
ATOM    197  HB3 ASN A  16      56.563   3.712  53.814  1.00  0.00           H  
ATOM    198 HD21 ASN A  16      55.897   1.670  54.086  1.00  0.00           H  
ATOM    199 HD22 ASN A  16      54.449   1.210  54.906  1.00  0.00           H  
ATOM    200  N   ARG A  17      57.136   5.886  57.703  1.00  0.00           N  
ATOM    201  CA  ARG A  17      56.879   7.107  58.455  1.00  0.00           C  
ATOM    202  C   ARG A  17      58.186   7.801  58.829  1.00  0.00           C  
ATOM    203  O   ARG A  17      59.044   7.217  59.491  1.00  0.00           O  
ATOM    204  CB  ARG A  17      56.075   6.792  59.718  1.00  0.00           C  
ATOM    205  CG  ARG A  17      55.717   8.023  60.534  1.00  0.00           C  
ATOM    206  CD  ARG A  17      55.042   7.646  61.844  1.00  0.00           C  
ATOM    207  NE  ARG A  17      53.671   7.188  61.641  1.00  0.00           N  
ATOM    208  CZ  ARG A  17      53.353   5.936  61.329  1.00  0.00           C  
ATOM    209  NH1 ARG A  17      54.304   5.023  61.186  1.00  0.00           N  
ATOM    210  NH2 ARG A  17      52.083   5.595  61.158  1.00  0.00           N  
ATOM    211  H   ARG A  17      57.643   5.162  58.125  1.00  0.00           H  
ATOM    212  HA  ARG A  17      56.301   7.769  57.827  1.00  0.00           H  
ATOM    213  HB2 ARG A  17      55.159   6.297  59.435  1.00  0.00           H  
ATOM    214  HB3 ARG A  17      56.655   6.130  60.343  1.00  0.00           H  
ATOM    215  HG2 ARG A  17      56.619   8.574  60.754  1.00  0.00           H  
ATOM    216  HG3 ARG A  17      55.046   8.643  59.959  1.00  0.00           H  
ATOM    217  HD2 ARG A  17      55.610   6.856  62.312  1.00  0.00           H  
ATOM    218  HD3 ARG A  17      55.030   8.513  62.490  1.00  0.00           H  
ATOM    219  HE  ARG A  17      52.952   7.846  61.740  1.00  0.00           H  
ATOM    220 HH11 ARG A  17      55.263   5.277  61.314  1.00  0.00           H  
ATOM    221 HH12 ARG A  17      54.062   4.081  60.953  1.00  0.00           H  
ATOM    222 HH21 ARG A  17      51.362   6.281  61.267  1.00  0.00           H  
ATOM    223 HH22 ARG A  17      51.845   4.653  60.924  1.00  0.00           H  
ATOM    224  N   VAL A  18      58.328   9.052  58.402  1.00  0.00           N  
ATOM    225  CA  VAL A  18      59.528   9.826  58.693  1.00  0.00           C  
ATOM    226  C   VAL A  18      59.224  10.977  59.645  1.00  0.00           C  
ATOM    227  O   VAL A  18      58.096  11.465  59.706  1.00  0.00           O  
ATOM    228  CB  VAL A  18      60.157  10.394  57.404  1.00  0.00           C  
ATOM    229  CG1 VAL A  18      60.984   9.329  56.700  1.00  0.00           C  
ATOM    230  CG2 VAL A  18      59.076  10.939  56.483  1.00  0.00           C  
ATOM    231  H   VAL A  18      57.609   9.464  57.879  1.00  0.00           H  
ATOM    232  HA  VAL A  18      60.247   9.167  59.158  1.00  0.00           H  
ATOM    233  HB  VAL A  18      60.813  11.207  57.676  1.00  0.00           H  
ATOM    234 HG11 VAL A  18      60.560   8.355  56.898  1.00  0.00           H  
ATOM    235 HG12 VAL A  18      60.982   9.517  55.637  1.00  0.00           H  
ATOM    236 HG13 VAL A  18      61.999   9.360  57.069  1.00  0.00           H  
ATOM    237 HG21 VAL A  18      58.662  10.131  55.898  1.00  0.00           H  
ATOM    238 HG22 VAL A  18      58.295  11.395  57.072  1.00  0.00           H  
ATOM    239 HG23 VAL A  18      59.507  11.676  55.821  1.00  0.00           H  
ATOM    240  N   VAL A  19      60.238  11.407  60.389  1.00  0.00           N  
ATOM    241  CA  VAL A  19      60.080  12.501  61.338  1.00  0.00           C  
ATOM    242  C   VAL A  19      60.656  13.798  60.784  1.00  0.00           C  
ATOM    243  O   VAL A  19      61.750  13.812  60.218  1.00  0.00           O  
ATOM    244  CB  VAL A  19      60.763  12.182  62.682  1.00  0.00           C  
ATOM    245  CG1 VAL A  19      60.516  13.299  63.685  1.00  0.00           C  
ATOM    246  CG2 VAL A  19      60.271  10.848  63.225  1.00  0.00           C  
ATOM    247  H   VAL A  19      61.115  10.977  60.296  1.00  0.00           H  
ATOM    248  HA  VAL A  19      59.023  12.636  61.519  1.00  0.00           H  
ATOM    249  HB  VAL A  19      61.826  12.108  62.513  1.00  0.00           H  
ATOM    250 HG11 VAL A  19      60.107  12.882  64.593  1.00  0.00           H  
ATOM    251 HG12 VAL A  19      61.448  13.799  63.904  1.00  0.00           H  
ATOM    252 HG13 VAL A  19      59.817  14.008  63.269  1.00  0.00           H  
ATOM    253 HG21 VAL A  19      59.757  10.310  62.444  1.00  0.00           H  
ATOM    254 HG22 VAL A  19      61.115  10.267  63.569  1.00  0.00           H  
ATOM    255 HG23 VAL A  19      59.595  11.022  64.048  1.00  0.00           H  
ATOM    256  N   VAL A  20      59.916  14.889  60.949  1.00  0.00           N  
ATOM    257  CA  VAL A  20      60.353  16.193  60.466  1.00  0.00           C  
ATOM    258  C   VAL A  20      60.714  17.115  61.625  1.00  0.00           C  
ATOM    259  O   VAL A  20      60.020  17.153  62.640  1.00  0.00           O  
ATOM    260  CB  VAL A  20      59.267  16.867  59.607  1.00  0.00           C  
ATOM    261  CG1 VAL A  20      59.830  18.087  58.895  1.00  0.00           C  
ATOM    262  CG2 VAL A  20      58.687  15.877  58.608  1.00  0.00           C  
ATOM    263  H   VAL A  20      59.052  14.815  61.408  1.00  0.00           H  
ATOM    264  HA  VAL A  20      61.229  16.044  59.851  1.00  0.00           H  
ATOM    265  HB  VAL A  20      58.472  17.195  60.260  1.00  0.00           H  
ATOM    266 HG11 VAL A  20      60.540  18.584  59.540  1.00  0.00           H  
ATOM    267 HG12 VAL A  20      60.323  17.777  57.985  1.00  0.00           H  
ATOM    268 HG13 VAL A  20      59.026  18.767  58.655  1.00  0.00           H  
ATOM    269 HG21 VAL A  20      58.924  16.199  57.605  1.00  0.00           H  
ATOM    270 HG22 VAL A  20      59.113  14.899  58.782  1.00  0.00           H  
ATOM    271 HG23 VAL A  20      57.615  15.829  58.729  1.00  0.00           H  
ATOM    272  N   SER A  21      61.806  17.857  61.465  1.00  0.00           N  
ATOM    273  CA  SER A  21      62.262  18.779  62.500  1.00  0.00           C  
ATOM    274  C   SER A  21      62.676  20.114  61.893  1.00  0.00           C  
ATOM    275  O   SER A  21      62.856  20.230  60.682  1.00  0.00           O  
ATOM    276  CB  SER A  21      63.432  18.171  63.274  1.00  0.00           C  
ATOM    277  OG  SER A  21      64.641  18.287  62.543  1.00  0.00           O  
ATOM    278  H   SER A  21      62.317  17.782  60.632  1.00  0.00           H  
ATOM    279  HA  SER A  21      61.439  18.945  63.181  1.00  0.00           H  
ATOM    280  HB2 SER A  21      63.544  18.685  64.216  1.00  0.00           H  
ATOM    281  HB3 SER A  21      63.236  17.123  63.456  1.00  0.00           H  
ATOM    282  HG  SER A  21      65.193  18.963  62.944  1.00  0.00           H  
ATOM    283  N   GLY A  22      62.828  21.125  62.745  1.00  0.00           N  
ATOM    284  CA  GLY A  22      63.220  22.440  62.276  1.00  0.00           C  
ATOM    285  C   GLY A  22      62.117  23.131  61.500  1.00  0.00           C  
ATOM    286  O   GLY A  22      62.386  23.923  60.596  1.00  0.00           O  
ATOM    287  H   GLY A  22      62.671  20.973  63.702  1.00  0.00           H  
ATOM    288  HA2 GLY A  22      63.485  23.050  63.128  1.00  0.00           H  
ATOM    289  HA3 GLY A  22      64.084  22.338  61.636  1.00  0.00           H  
ATOM    290  N   LEU A  23      60.871  22.833  61.853  1.00  0.00           N  
ATOM    291  CA  LEU A  23      59.723  23.430  61.182  1.00  0.00           C  
ATOM    292  C   LEU A  23      59.427  24.819  61.741  1.00  0.00           C  
ATOM    293  O   LEU A  23      59.578  25.080  62.935  1.00  0.00           O  
ATOM    294  CB  LEU A  23      58.493  22.534  61.336  1.00  0.00           C  
ATOM    295  CG  LEU A  23      58.283  21.488  60.240  1.00  0.00           C  
ATOM    296  CD1 LEU A  23      57.485  20.309  60.773  1.00  0.00           C  
ATOM    297  CD2 LEU A  23      57.584  22.108  59.038  1.00  0.00           C  
ATOM    298  H   LEU A  23      60.720  22.196  62.581  1.00  0.00           H  
ATOM    299  HA  LEU A  23      59.962  23.522  60.132  1.00  0.00           H  
ATOM    300  HB2 LEU A  23      58.580  22.013  62.277  1.00  0.00           H  
ATOM    301  HB3 LEU A  23      57.619  23.171  61.359  1.00  0.00           H  
ATOM    302  HG  LEU A  23      59.247  21.119  59.915  1.00  0.00           H  
ATOM    303 HD11 LEU A  23      56.983  20.598  61.684  1.00  0.00           H  
ATOM    304 HD12 LEU A  23      58.151  19.485  60.975  1.00  0.00           H  
ATOM    305 HD13 LEU A  23      56.753  20.009  60.038  1.00  0.00           H  
ATOM    306 HD21 LEU A  23      57.109  21.331  58.460  1.00  0.00           H  
ATOM    307 HD22 LEU A  23      58.312  22.621  58.424  1.00  0.00           H  
ATOM    308 HD23 LEU A  23      56.840  22.812  59.379  1.00  0.00           H  
ATOM    309  N   PRO A  24      58.992  25.732  60.860  1.00  0.00           N  
ATOM    310  CA  PRO A  24      58.664  27.109  61.243  1.00  0.00           C  
ATOM    311  C   PRO A  24      57.401  27.187  62.094  1.00  0.00           C  
ATOM    312  O   PRO A  24      56.575  26.274  62.109  1.00  0.00           O  
ATOM    313  CB  PRO A  24      58.447  27.809  59.899  1.00  0.00           C  
ATOM    314  CG  PRO A  24      58.050  26.720  58.964  1.00  0.00           C  
ATOM    315  CD  PRO A  24      58.789  25.492  59.422  1.00  0.00           C  
ATOM    316  HA  PRO A  24      59.480  27.580  61.769  1.00  0.00           H  
ATOM    317  HB2 PRO A  24      57.666  28.549  59.999  1.00  0.00           H  
ATOM    318  HB3 PRO A  24      59.364  28.284  59.586  1.00  0.00           H  
ATOM    319  HG2 PRO A  24      56.984  26.559  59.018  1.00  0.00           H  
ATOM    320  HG3 PRO A  24      58.341  26.977  57.956  1.00  0.00           H  
ATOM    321  HD2 PRO A  24      58.190  24.609  59.259  1.00  0.00           H  
ATOM    322  HD3 PRO A  24      59.736  25.408  58.908  1.00  0.00           H  
ATOM    323  N   PRO A  25      57.245  28.303  62.823  1.00  0.00           N  
ATOM    324  CA  PRO A  25      56.085  28.527  63.689  1.00  0.00           C  
ATOM    325  C   PRO A  25      54.801  28.748  62.895  1.00  0.00           C  
ATOM    326  O   PRO A  25      53.705  28.736  63.454  1.00  0.00           O  
ATOM    327  CB  PRO A  25      56.459  29.794  64.463  1.00  0.00           C  
ATOM    328  CG  PRO A  25      57.426  30.505  63.580  1.00  0.00           C  
ATOM    329  CD  PRO A  25      58.190  29.433  62.853  1.00  0.00           C  
ATOM    330  HA  PRO A  25      55.942  27.710  64.381  1.00  0.00           H  
ATOM    331  HB2 PRO A  25      55.572  30.387  64.638  1.00  0.00           H  
ATOM    332  HB3 PRO A  25      56.911  29.524  65.405  1.00  0.00           H  
ATOM    333  HG2 PRO A  25      56.892  31.127  62.877  1.00  0.00           H  
ATOM    334  HG3 PRO A  25      58.097  31.103  64.177  1.00  0.00           H  
ATOM    335  HD2 PRO A  25      58.436  29.757  61.854  1.00  0.00           H  
ATOM    336  HD3 PRO A  25      59.084  29.171  63.399  1.00  0.00           H  
ATOM    337  N   SER A  26      54.946  28.949  61.589  1.00  0.00           N  
ATOM    338  CA  SER A  26      53.799  29.176  60.717  1.00  0.00           C  
ATOM    339  C   SER A  26      53.578  27.986  59.789  1.00  0.00           C  
ATOM    340  O   SER A  26      52.552  27.891  59.117  1.00  0.00           O  
ATOM    341  CB  SER A  26      54.001  30.449  59.896  1.00  0.00           C  
ATOM    342  OG  SER A  26      54.445  31.519  60.711  1.00  0.00           O  
ATOM    343  H   SER A  26      55.848  28.947  61.203  1.00  0.00           H  
ATOM    344  HA  SER A  26      52.927  29.296  61.344  1.00  0.00           H  
ATOM    345  HB2 SER A  26      54.739  30.266  59.129  1.00  0.00           H  
ATOM    346  HB3 SER A  26      53.064  30.729  59.434  1.00  0.00           H  
ATOM    347  HG  SER A  26      54.032  31.455  61.575  1.00  0.00           H  
ATOM    348  N   GLY A  27      54.550  27.080  59.758  1.00  0.00           N  
ATOM    349  CA  GLY A  27      54.444  25.907  58.909  1.00  0.00           C  
ATOM    350  C   GLY A  27      53.324  24.980  59.337  1.00  0.00           C  
ATOM    351  O   GLY A  27      53.197  24.653  60.517  1.00  0.00           O  
ATOM    352  H   GLY A  27      55.346  27.207  60.315  1.00  0.00           H  
ATOM    353  HA2 GLY A  27      54.264  26.227  57.893  1.00  0.00           H  
ATOM    354  HA3 GLY A  27      55.378  25.364  58.945  1.00  0.00           H  
ATOM    355  N   SER A  28      52.508  24.558  58.377  1.00  0.00           N  
ATOM    356  CA  SER A  28      51.388  23.667  58.662  1.00  0.00           C  
ATOM    357  C   SER A  28      51.506  22.375  57.861  1.00  0.00           C  
ATOM    358  O   SER A  28      52.164  22.333  56.821  1.00  0.00           O  
ATOM    359  CB  SER A  28      50.063  24.362  58.340  1.00  0.00           C  
ATOM    360  OG  SER A  28      48.978  23.704  58.973  1.00  0.00           O  
ATOM    361  H   SER A  28      52.661  24.854  57.455  1.00  0.00           H  
ATOM    362  HA  SER A  28      51.414  23.429  59.715  1.00  0.00           H  
ATOM    363  HB2 SER A  28      50.101  25.383  58.688  1.00  0.00           H  
ATOM    364  HB3 SER A  28      49.903  24.349  57.272  1.00  0.00           H  
ATOM    365  HG  SER A  28      48.633  23.024  58.390  1.00  0.00           H  
ATOM    366  N   TRP A  29      50.862  21.322  58.352  1.00  0.00           N  
ATOM    367  CA  TRP A  29      50.894  20.026  57.683  1.00  0.00           C  
ATOM    368  C   TRP A  29      50.517  20.164  56.212  1.00  0.00           C  
ATOM    369  O   TRP A  29      51.192  19.622  55.337  1.00  0.00           O  
ATOM    370  CB  TRP A  29      49.944  19.048  58.376  1.00  0.00           C  
ATOM    371  CG  TRP A  29      48.535  19.126  57.868  1.00  0.00           C  
ATOM    372  CD1 TRP A  29      47.449  19.611  58.538  1.00  0.00           C  
ATOM    373  CD2 TRP A  29      48.064  18.706  56.584  1.00  0.00           C  
ATOM    374  NE1 TRP A  29      46.329  19.517  57.747  1.00  0.00           N  
ATOM    375  CE2 TRP A  29      46.680  18.966  56.542  1.00  0.00           C  
ATOM    376  CE3 TRP A  29      48.675  18.136  55.463  1.00  0.00           C  
ATOM    377  CZ2 TRP A  29      45.901  18.675  55.426  1.00  0.00           C  
ATOM    378  CZ3 TRP A  29      47.900  17.848  54.356  1.00  0.00           C  
ATOM    379  CH2 TRP A  29      46.526  18.118  54.344  1.00  0.00           C  
ATOM    380  H   TRP A  29      50.354  21.418  59.185  1.00  0.00           H  
ATOM    381  HA  TRP A  29      51.901  19.644  57.750  1.00  0.00           H  
ATOM    382  HB2 TRP A  29      50.298  18.040  58.221  1.00  0.00           H  
ATOM    383  HB3 TRP A  29      49.929  19.262  59.435  1.00  0.00           H  
ATOM    384  HD1 TRP A  29      47.479  20.005  59.541  1.00  0.00           H  
ATOM    385  HE1 TRP A  29      45.427  19.801  58.003  1.00  0.00           H  
ATOM    386  HE3 TRP A  29      49.734  17.922  55.453  1.00  0.00           H  
ATOM    387  HZ2 TRP A  29      44.841  18.877  55.401  1.00  0.00           H  
ATOM    388  HZ3 TRP A  29      48.357  17.408  53.481  1.00  0.00           H  
ATOM    389  HH2 TRP A  29      45.960  17.876  53.456  1.00  0.00           H  
ATOM    390  N   GLN A  30      49.437  20.892  55.948  1.00  0.00           N  
ATOM    391  CA  GLN A  30      48.972  21.100  54.582  1.00  0.00           C  
ATOM    392  C   GLN A  30      50.127  21.495  53.667  1.00  0.00           C  
ATOM    393  O   GLN A  30      50.213  21.039  52.527  1.00  0.00           O  
ATOM    394  CB  GLN A  30      47.887  22.177  54.549  1.00  0.00           C  
ATOM    395  CG  GLN A  30      46.564  21.692  53.976  1.00  0.00           C  
ATOM    396  CD  GLN A  30      45.479  22.748  54.038  1.00  0.00           C  
ATOM    397  OE1 GLN A  30      45.474  23.597  54.931  1.00  0.00           O  
ATOM    398  NE2 GLN A  30      44.552  22.702  53.089  1.00  0.00           N  
ATOM    399  H   GLN A  30      48.941  21.297  56.688  1.00  0.00           H  
ATOM    400  HA  GLN A  30      48.553  20.169  54.228  1.00  0.00           H  
ATOM    401  HB2 GLN A  30      47.713  22.527  55.555  1.00  0.00           H  
ATOM    402  HB3 GLN A  30      48.234  23.002  53.943  1.00  0.00           H  
ATOM    403  HG2 GLN A  30      46.715  21.414  52.942  1.00  0.00           H  
ATOM    404  HG3 GLN A  30      46.240  20.829  54.536  1.00  0.00           H  
ATOM    405 HE21 GLN A  30      44.620  21.996  52.411  1.00  0.00           H  
ATOM    406 HE22 GLN A  30      43.838  23.371  53.105  1.00  0.00           H  
ATOM    407  N   ASP A  31      51.012  22.346  54.175  1.00  0.00           N  
ATOM    408  CA  ASP A  31      52.162  22.802  53.405  1.00  0.00           C  
ATOM    409  C   ASP A  31      53.291  21.778  53.455  1.00  0.00           C  
ATOM    410  O   ASP A  31      53.847  21.397  52.423  1.00  0.00           O  
ATOM    411  CB  ASP A  31      52.655  24.150  53.934  1.00  0.00           C  
ATOM    412  CG  ASP A  31      53.277  25.006  52.848  1.00  0.00           C  
ATOM    413  OD1 ASP A  31      54.408  24.694  52.421  1.00  0.00           O  
ATOM    414  OD2 ASP A  31      52.633  25.990  52.426  1.00  0.00           O  
ATOM    415  H   ASP A  31      50.888  22.673  55.091  1.00  0.00           H  
ATOM    416  HA  ASP A  31      51.848  22.923  52.379  1.00  0.00           H  
ATOM    417  HB2 ASP A  31      51.821  24.689  54.359  1.00  0.00           H  
ATOM    418  HB3 ASP A  31      53.396  23.978  54.701  1.00  0.00           H  
ATOM    419  N   LEU A  32      53.627  21.334  54.662  1.00  0.00           N  
ATOM    420  CA  LEU A  32      54.691  20.354  54.848  1.00  0.00           C  
ATOM    421  C   LEU A  32      54.536  19.191  53.874  1.00  0.00           C  
ATOM    422  O   LEU A  32      55.505  18.754  53.252  1.00  0.00           O  
ATOM    423  CB  LEU A  32      54.688  19.835  56.287  1.00  0.00           C  
ATOM    424  CG  LEU A  32      55.477  18.549  56.538  1.00  0.00           C  
ATOM    425  CD1 LEU A  32      56.941  18.742  56.176  1.00  0.00           C  
ATOM    426  CD2 LEU A  32      55.337  18.113  57.990  1.00  0.00           C  
ATOM    427  H   LEU A  32      53.150  21.674  55.447  1.00  0.00           H  
ATOM    428  HA  LEU A  32      55.633  20.846  54.654  1.00  0.00           H  
ATOM    429  HB2 LEU A  32      55.102  20.607  56.917  1.00  0.00           H  
ATOM    430  HB3 LEU A  32      53.660  19.654  56.569  1.00  0.00           H  
ATOM    431  HG  LEU A  32      55.079  17.762  55.912  1.00  0.00           H  
ATOM    432 HD11 LEU A  32      57.526  18.831  57.079  1.00  0.00           H  
ATOM    433 HD12 LEU A  32      57.051  19.639  55.585  1.00  0.00           H  
ATOM    434 HD13 LEU A  32      57.286  17.891  55.606  1.00  0.00           H  
ATOM    435 HD21 LEU A  32      55.951  18.745  58.614  1.00  0.00           H  
ATOM    436 HD22 LEU A  32      55.659  17.086  58.089  1.00  0.00           H  
ATOM    437 HD23 LEU A  32      54.305  18.199  58.294  1.00  0.00           H  
ATOM    438  N   LYS A  33      53.311  18.693  53.746  1.00  0.00           N  
ATOM    439  CA  LYS A  33      53.026  17.582  52.846  1.00  0.00           C  
ATOM    440  C   LYS A  33      53.339  17.958  51.401  1.00  0.00           C  
ATOM    441  O   LYS A  33      53.770  17.119  50.611  1.00  0.00           O  
ATOM    442  CB  LYS A  33      51.559  17.162  52.970  1.00  0.00           C  
ATOM    443  CG  LYS A  33      51.124  16.156  51.918  1.00  0.00           C  
ATOM    444  CD  LYS A  33      49.663  16.336  51.544  1.00  0.00           C  
ATOM    445  CE  LYS A  33      49.382  15.835  50.135  1.00  0.00           C  
ATOM    446  NZ  LYS A  33      48.580  14.581  50.143  1.00  0.00           N  
ATOM    447  H   LYS A  33      52.580  19.083  54.270  1.00  0.00           H  
ATOM    448  HA  LYS A  33      53.654  16.752  53.133  1.00  0.00           H  
ATOM    449  HB2 LYS A  33      51.403  16.723  53.944  1.00  0.00           H  
ATOM    450  HB3 LYS A  33      50.936  18.040  52.876  1.00  0.00           H  
ATOM    451  HG2 LYS A  33      51.730  16.287  51.033  1.00  0.00           H  
ATOM    452  HG3 LYS A  33      51.266  15.157  52.308  1.00  0.00           H  
ATOM    453  HD2 LYS A  33      49.050  15.781  52.239  1.00  0.00           H  
ATOM    454  HD3 LYS A  33      49.413  17.387  51.600  1.00  0.00           H  
ATOM    455  HE2 LYS A  33      48.838  16.597  49.598  1.00  0.00           H  
ATOM    456  HE3 LYS A  33      50.323  15.647  49.640  1.00  0.00           H  
ATOM    457  HZ1 LYS A  33      47.861  14.619  50.894  1.00  0.00           H  
ATOM    458  HZ2 LYS A  33      49.198  13.761  50.312  1.00  0.00           H  
ATOM    459  HZ3 LYS A  33      48.101  14.458  49.228  1.00  0.00           H  
ATOM    460  N   ASP A  34      53.118  19.224  51.063  1.00  0.00           N  
ATOM    461  CA  ASP A  34      53.378  19.713  49.714  1.00  0.00           C  
ATOM    462  C   ASP A  34      54.872  19.678  49.403  1.00  0.00           C  
ATOM    463  O   ASP A  34      55.276  19.738  48.241  1.00  0.00           O  
ATOM    464  CB  ASP A  34      52.845  21.136  49.552  1.00  0.00           C  
ATOM    465  CG  ASP A  34      51.691  21.214  48.570  1.00  0.00           C  
ATOM    466  OD1 ASP A  34      50.530  21.068  49.005  1.00  0.00           O  
ATOM    467  OD2 ASP A  34      51.952  21.420  47.367  1.00  0.00           O  
ATOM    468  H   ASP A  34      52.772  19.846  51.739  1.00  0.00           H  
ATOM    469  HA  ASP A  34      52.864  19.064  49.022  1.00  0.00           H  
ATOM    470  HB2 ASP A  34      52.500  21.497  50.511  1.00  0.00           H  
ATOM    471  HB3 ASP A  34      53.640  21.774  49.197  1.00  0.00           H  
ATOM    472  N   HIS A  35      55.687  19.580  50.449  1.00  0.00           N  
ATOM    473  CA  HIS A  35      57.136  19.538  50.287  1.00  0.00           C  
ATOM    474  C   HIS A  35      57.628  18.098  50.177  1.00  0.00           C  
ATOM    475  O   HIS A  35      58.635  17.823  49.525  1.00  0.00           O  
ATOM    476  CB  HIS A  35      57.822  20.237  51.460  1.00  0.00           C  
ATOM    477  CG  HIS A  35      59.260  20.566  51.202  1.00  0.00           C  
ATOM    478  ND1 HIS A  35      59.702  21.842  50.923  1.00  0.00           N  
ATOM    479  CD2 HIS A  35      60.360  19.778  51.187  1.00  0.00           C  
ATOM    480  CE1 HIS A  35      61.010  21.823  50.744  1.00  0.00           C  
ATOM    481  NE2 HIS A  35      61.434  20.582  50.898  1.00  0.00           N  
ATOM    482  H   HIS A  35      55.306  19.534  51.350  1.00  0.00           H  
ATOM    483  HA  HIS A  35      57.383  20.059  49.373  1.00  0.00           H  
ATOM    484  HB2 HIS A  35      57.304  21.160  51.674  1.00  0.00           H  
ATOM    485  HB3 HIS A  35      57.778  19.595  52.328  1.00  0.00           H  
ATOM    486  HD1 HIS A  35      59.140  22.642  50.863  1.00  0.00           H  
ATOM    487  HD2 HIS A  35      60.388  18.711  51.366  1.00  0.00           H  
ATOM    488  HE1 HIS A  35      61.628  22.677  50.511  1.00  0.00           H  
ATOM    489  N   MET A  36      56.912  17.182  50.821  1.00  0.00           N  
ATOM    490  CA  MET A  36      57.278  15.770  50.798  1.00  0.00           C  
ATOM    491  C   MET A  36      56.882  15.130  49.470  1.00  0.00           C  
ATOM    492  O   MET A  36      57.390  14.069  49.107  1.00  0.00           O  
ATOM    493  CB  MET A  36      56.606  15.028  51.954  1.00  0.00           C  
ATOM    494  CG  MET A  36      56.775  15.718  53.297  1.00  0.00           C  
ATOM    495  SD  MET A  36      58.403  16.467  53.494  1.00  0.00           S  
ATOM    496  CE  MET A  36      59.422  15.012  53.712  1.00  0.00           C  
ATOM    497  H   MET A  36      56.120  17.461  51.326  1.00  0.00           H  
ATOM    498  HA  MET A  36      58.348  15.704  50.911  1.00  0.00           H  
ATOM    499  HB2 MET A  36      55.550  14.942  51.748  1.00  0.00           H  
ATOM    500  HB3 MET A  36      57.032  14.038  52.027  1.00  0.00           H  
ATOM    501  HG2 MET A  36      56.026  16.490  53.388  1.00  0.00           H  
ATOM    502  HG3 MET A  36      56.633  14.989  54.081  1.00  0.00           H  
ATOM    503  HE1 MET A  36      60.121  15.177  54.517  1.00  0.00           H  
ATOM    504  HE2 MET A  36      58.795  14.165  53.948  1.00  0.00           H  
ATOM    505  HE3 MET A  36      59.966  14.813  52.800  1.00  0.00           H  
ATOM    506  N   ARG A  37      55.974  15.782  48.751  1.00  0.00           N  
ATOM    507  CA  ARG A  37      55.510  15.275  47.464  1.00  0.00           C  
ATOM    508  C   ARG A  37      56.687  15.002  46.532  1.00  0.00           C  
ATOM    509  O   ARG A  37      56.700  14.006  45.809  1.00  0.00           O  
ATOM    510  CB  ARG A  37      54.552  16.273  46.815  1.00  0.00           C  
ATOM    511  CG  ARG A  37      53.216  16.389  47.530  1.00  0.00           C  
ATOM    512  CD  ARG A  37      52.197  17.145  46.690  1.00  0.00           C  
ATOM    513  NE  ARG A  37      52.835  17.962  45.662  1.00  0.00           N  
ATOM    514  CZ  ARG A  37      53.131  17.515  44.446  1.00  0.00           C  
ATOM    515  NH1 ARG A  37      52.849  16.264  44.110  1.00  0.00           N  
ATOM    516  NH2 ARG A  37      53.711  18.321  43.565  1.00  0.00           N  
ATOM    517  H   ARG A  37      55.605  16.623  49.093  1.00  0.00           H  
ATOM    518  HA  ARG A  37      54.986  14.348  47.642  1.00  0.00           H  
ATOM    519  HB2 ARG A  37      55.016  17.249  46.806  1.00  0.00           H  
ATOM    520  HB3 ARG A  37      54.365  15.965  45.797  1.00  0.00           H  
ATOM    521  HG2 ARG A  37      52.837  15.398  47.728  1.00  0.00           H  
ATOM    522  HG3 ARG A  37      53.362  16.913  48.462  1.00  0.00           H  
ATOM    523  HD2 ARG A  37      51.542  16.429  46.214  1.00  0.00           H  
ATOM    524  HD3 ARG A  37      51.619  17.785  47.340  1.00  0.00           H  
ATOM    525  HE  ARG A  37      53.052  18.890  45.890  1.00  0.00           H  
ATOM    526 HH11 ARG A  37      52.410  15.656  44.770  1.00  0.00           H  
ATOM    527 HH12 ARG A  37      53.071  15.931  43.192  1.00  0.00           H  
ATOM    528 HH21 ARG A  37      53.926  19.263  43.815  1.00  0.00           H  
ATOM    529 HH22 ARG A  37      53.933  17.983  42.650  1.00  0.00           H  
ATOM    530  N   GLU A  38      57.673  15.894  46.555  1.00  0.00           N  
ATOM    531  CA  GLU A  38      58.853  15.748  45.710  1.00  0.00           C  
ATOM    532  C   GLU A  38      59.304  14.292  45.651  1.00  0.00           C  
ATOM    533  O   GLU A  38      59.811  13.829  44.629  1.00  0.00           O  
ATOM    534  CB  GLU A  38      59.992  16.627  46.231  1.00  0.00           C  
ATOM    535  CG  GLU A  38      60.188  17.906  45.435  1.00  0.00           C  
ATOM    536  CD  GLU A  38      59.444  19.083  46.031  1.00  0.00           C  
ATOM    537  OE1 GLU A  38      59.533  19.284  47.260  1.00  0.00           O  
ATOM    538  OE2 GLU A  38      58.770  19.807  45.267  1.00  0.00           O  
ATOM    539  H   GLU A  38      57.604  16.667  47.153  1.00  0.00           H  
ATOM    540  HA  GLU A  38      58.588  16.071  44.714  1.00  0.00           H  
ATOM    541  HB2 GLU A  38      59.784  16.893  47.257  1.00  0.00           H  
ATOM    542  HB3 GLU A  38      60.911  16.060  46.196  1.00  0.00           H  
ATOM    543  HG2 GLU A  38      61.243  18.141  45.410  1.00  0.00           H  
ATOM    544  HG3 GLU A  38      59.832  17.746  44.427  1.00  0.00           H  
ATOM    545  N   ALA A  39      59.117  13.576  46.753  1.00  0.00           N  
ATOM    546  CA  ALA A  39      59.502  12.172  46.828  1.00  0.00           C  
ATOM    547  C   ALA A  39      58.522  11.291  46.062  1.00  0.00           C  
ATOM    548  O   ALA A  39      58.922  10.358  45.368  1.00  0.00           O  
ATOM    549  CB  ALA A  39      59.592  11.726  48.280  1.00  0.00           C  
ATOM    550  H   ALA A  39      58.707  14.001  47.537  1.00  0.00           H  
ATOM    551  HA  ALA A  39      60.483  12.071  46.386  1.00  0.00           H  
ATOM    552  HB1 ALA A  39      58.744  11.099  48.517  1.00  0.00           H  
ATOM    553  HB2 ALA A  39      60.503  11.168  48.430  1.00  0.00           H  
ATOM    554  HB3 ALA A  39      59.589  12.592  48.924  1.00  0.00           H  
ATOM    555  N   GLY A  40      57.234  11.595  46.192  1.00  0.00           N  
ATOM    556  CA  GLY A  40      56.216  10.820  45.505  1.00  0.00           C  
ATOM    557  C   GLY A  40      54.813  11.200  45.934  1.00  0.00           C  
ATOM    558  O   GLY A  40      54.330  12.287  45.612  1.00  0.00           O  
ATOM    559  H   GLY A  40      56.972  12.351  46.759  1.00  0.00           H  
ATOM    560  HA2 GLY A  40      56.313  10.981  44.443  1.00  0.00           H  
ATOM    561  HA3 GLY A  40      56.373   9.772  45.717  1.00  0.00           H  
ATOM    562  N   ASP A  41      54.154  10.303  46.659  1.00  0.00           N  
ATOM    563  CA  ASP A  41      52.797  10.549  47.130  1.00  0.00           C  
ATOM    564  C   ASP A  41      52.713  10.405  48.646  1.00  0.00           C  
ATOM    565  O   ASP A  41      53.244   9.454  49.220  1.00  0.00           O  
ATOM    566  CB  ASP A  41      51.817   9.584  46.460  1.00  0.00           C  
ATOM    567  CG  ASP A  41      52.301   9.121  45.100  1.00  0.00           C  
ATOM    568  OD1 ASP A  41      53.151   8.206  45.051  1.00  0.00           O  
ATOM    569  OD2 ASP A  41      51.830   9.671  44.083  1.00  0.00           O  
ATOM    570  H   ASP A  41      54.591   9.455  46.882  1.00  0.00           H  
ATOM    571  HA  ASP A  41      52.530  11.561  46.863  1.00  0.00           H  
ATOM    572  HB2 ASP A  41      51.690   8.715  47.091  1.00  0.00           H  
ATOM    573  HB3 ASP A  41      50.865  10.075  46.335  1.00  0.00           H  
ATOM    574  N   VAL A  42      52.045  11.357  49.291  1.00  0.00           N  
ATOM    575  CA  VAL A  42      51.892  11.337  50.741  1.00  0.00           C  
ATOM    576  C   VAL A  42      50.647  10.559  51.151  1.00  0.00           C  
ATOM    577  O   VAL A  42      49.633  10.577  50.452  1.00  0.00           O  
ATOM    578  CB  VAL A  42      51.807  12.762  51.316  1.00  0.00           C  
ATOM    579  CG1 VAL A  42      51.547  12.720  52.814  1.00  0.00           C  
ATOM    580  CG2 VAL A  42      53.079  13.538  51.009  1.00  0.00           C  
ATOM    581  H   VAL A  42      51.644  12.090  48.778  1.00  0.00           H  
ATOM    582  HA  VAL A  42      52.762  10.853  51.161  1.00  0.00           H  
ATOM    583  HB  VAL A  42      50.978  13.271  50.844  1.00  0.00           H  
ATOM    584 HG11 VAL A  42      52.146  13.473  53.304  1.00  0.00           H  
ATOM    585 HG12 VAL A  42      50.501  12.910  53.003  1.00  0.00           H  
ATOM    586 HG13 VAL A  42      51.811  11.746  53.197  1.00  0.00           H  
ATOM    587 HG21 VAL A  42      53.482  13.208  50.063  1.00  0.00           H  
ATOM    588 HG22 VAL A  42      52.855  14.593  50.954  1.00  0.00           H  
ATOM    589 HG23 VAL A  42      53.804  13.365  51.790  1.00  0.00           H  
ATOM    590  N   CYS A  43      50.730   9.878  52.289  1.00  0.00           N  
ATOM    591  CA  CYS A  43      49.610   9.093  52.794  1.00  0.00           C  
ATOM    592  C   CYS A  43      49.088   9.671  54.105  1.00  0.00           C  
ATOM    593  O   CYS A  43      47.903   9.551  54.420  1.00  0.00           O  
ATOM    594  CB  CYS A  43      50.030   7.637  52.995  1.00  0.00           C  
ATOM    595  SG  CYS A  43      48.946   6.701  54.098  1.00  0.00           S  
ATOM    596  H   CYS A  43      51.565   9.903  52.802  1.00  0.00           H  
ATOM    597  HA  CYS A  43      48.821   9.132  52.059  1.00  0.00           H  
ATOM    598  HB2 CYS A  43      50.037   7.136  52.039  1.00  0.00           H  
ATOM    599  HB3 CYS A  43      51.025   7.612  53.413  1.00  0.00           H  
ATOM    600  HG  CYS A  43      48.264   5.835  53.363  1.00  0.00           H  
ATOM    601  N   TYR A  44      49.979  10.296  54.866  1.00  0.00           N  
ATOM    602  CA  TYR A  44      49.609  10.889  56.146  1.00  0.00           C  
ATOM    603  C   TYR A  44      50.496  12.088  56.467  1.00  0.00           C  
ATOM    604  O   TYR A  44      51.713  12.040  56.285  1.00  0.00           O  
ATOM    605  CB  TYR A  44      49.713   9.849  57.262  1.00  0.00           C  
ATOM    606  CG  TYR A  44      49.755  10.452  58.649  1.00  0.00           C  
ATOM    607  CD1 TYR A  44      48.635  11.066  59.195  1.00  0.00           C  
ATOM    608  CD2 TYR A  44      50.917  10.408  59.411  1.00  0.00           C  
ATOM    609  CE1 TYR A  44      48.670  11.619  60.461  1.00  0.00           C  
ATOM    610  CE2 TYR A  44      50.959  10.956  60.679  1.00  0.00           C  
ATOM    611  CZ  TYR A  44      49.834  11.561  61.199  1.00  0.00           C  
ATOM    612  OH  TYR A  44      49.872  12.109  62.460  1.00  0.00           O  
ATOM    613  H   TYR A  44      50.907  10.358  54.561  1.00  0.00           H  
ATOM    614  HA  TYR A  44      48.585  11.223  56.073  1.00  0.00           H  
ATOM    615  HB2 TYR A  44      48.860   9.192  57.214  1.00  0.00           H  
ATOM    616  HB3 TYR A  44      50.616   9.271  57.124  1.00  0.00           H  
ATOM    617  HD1 TYR A  44      47.725  11.110  58.616  1.00  0.00           H  
ATOM    618  HD2 TYR A  44      51.797   9.935  59.001  1.00  0.00           H  
ATOM    619  HE1 TYR A  44      47.789  12.092  60.870  1.00  0.00           H  
ATOM    620  HE2 TYR A  44      51.871  10.912  61.257  1.00  0.00           H  
ATOM    621  HH  TYR A  44      50.787  12.241  62.723  1.00  0.00           H  
ATOM    622  N   ALA A  45      49.878  13.161  56.949  1.00  0.00           N  
ATOM    623  CA  ALA A  45      50.610  14.372  57.298  1.00  0.00           C  
ATOM    624  C   ALA A  45      50.100  14.964  58.606  1.00  0.00           C  
ATOM    625  O   ALA A  45      48.897  14.958  58.873  1.00  0.00           O  
ATOM    626  CB  ALA A  45      50.506  15.396  56.177  1.00  0.00           C  
ATOM    627  H   ALA A  45      48.907  13.138  57.072  1.00  0.00           H  
ATOM    628  HA  ALA A  45      51.652  14.110  57.416  1.00  0.00           H  
ATOM    629  HB1 ALA A  45      49.778  16.147  56.445  1.00  0.00           H  
ATOM    630  HB2 ALA A  45      51.468  15.862  56.026  1.00  0.00           H  
ATOM    631  HB3 ALA A  45      50.197  14.902  55.268  1.00  0.00           H  
ATOM    632  N   ASP A  46      51.019  15.474  59.419  1.00  0.00           N  
ATOM    633  CA  ASP A  46      50.660  16.071  60.700  1.00  0.00           C  
ATOM    634  C   ASP A  46      51.841  16.835  61.294  1.00  0.00           C  
ATOM    635  O   ASP A  46      52.972  16.350  61.290  1.00  0.00           O  
ATOM    636  CB  ASP A  46      50.193  14.991  61.678  1.00  0.00           C  
ATOM    637  CG  ASP A  46      48.759  15.197  62.125  1.00  0.00           C  
ATOM    638  OD1 ASP A  46      47.863  15.218  61.256  1.00  0.00           O  
ATOM    639  OD2 ASP A  46      48.533  15.334  63.346  1.00  0.00           O  
ATOM    640  H   ASP A  46      51.961  15.449  59.151  1.00  0.00           H  
ATOM    641  HA  ASP A  46      49.849  16.763  60.528  1.00  0.00           H  
ATOM    642  HB2 ASP A  46      50.265  14.025  61.198  1.00  0.00           H  
ATOM    643  HB3 ASP A  46      50.829  15.004  62.550  1.00  0.00           H  
ATOM    644  N   VAL A  47      51.568  18.033  61.801  1.00  0.00           N  
ATOM    645  CA  VAL A  47      52.607  18.864  62.397  1.00  0.00           C  
ATOM    646  C   VAL A  47      52.220  19.300  63.806  1.00  0.00           C  
ATOM    647  O   VAL A  47      51.041  19.489  64.107  1.00  0.00           O  
ATOM    648  CB  VAL A  47      52.884  20.115  61.543  1.00  0.00           C  
ATOM    649  CG1 VAL A  47      53.253  19.719  60.121  1.00  0.00           C  
ATOM    650  CG2 VAL A  47      51.679  21.043  61.550  1.00  0.00           C  
ATOM    651  H   VAL A  47      50.645  18.365  61.774  1.00  0.00           H  
ATOM    652  HA  VAL A  47      53.514  18.280  62.449  1.00  0.00           H  
ATOM    653  HB  VAL A  47      53.722  20.643  61.974  1.00  0.00           H  
ATOM    654 HG11 VAL A  47      54.327  19.649  60.034  1.00  0.00           H  
ATOM    655 HG12 VAL A  47      52.809  18.763  59.887  1.00  0.00           H  
ATOM    656 HG13 VAL A  47      52.885  20.466  59.433  1.00  0.00           H  
ATOM    657 HG21 VAL A  47      51.725  21.697  60.692  1.00  0.00           H  
ATOM    658 HG22 VAL A  47      50.772  20.458  61.510  1.00  0.00           H  
ATOM    659 HG23 VAL A  47      51.686  21.634  62.456  1.00  0.00           H  
ATOM    660  N   TYR A  48      53.221  19.459  64.666  1.00  0.00           N  
ATOM    661  CA  TYR A  48      52.985  19.872  66.044  1.00  0.00           C  
ATOM    662  C   TYR A  48      53.490  21.292  66.281  1.00  0.00           C  
ATOM    663  O   TYR A  48      54.309  21.807  65.519  1.00  0.00           O  
ATOM    664  CB  TYR A  48      53.673  18.907  67.012  1.00  0.00           C  
ATOM    665  CG  TYR A  48      53.533  17.454  66.618  1.00  0.00           C  
ATOM    666  CD1 TYR A  48      52.457  16.693  67.057  1.00  0.00           C  
ATOM    667  CD2 TYR A  48      54.479  16.841  65.805  1.00  0.00           C  
ATOM    668  CE1 TYR A  48      52.327  15.365  66.701  1.00  0.00           C  
ATOM    669  CE2 TYR A  48      54.357  15.512  65.442  1.00  0.00           C  
ATOM    670  CZ  TYR A  48      53.279  14.779  65.893  1.00  0.00           C  
ATOM    671  OH  TYR A  48      53.152  13.458  65.534  1.00  0.00           O  
ATOM    672  H   TYR A  48      54.139  19.293  64.367  1.00  0.00           H  
ATOM    673  HA  TYR A  48      51.920  19.846  66.221  1.00  0.00           H  
ATOM    674  HB2 TYR A  48      54.726  19.139  67.054  1.00  0.00           H  
ATOM    675  HB3 TYR A  48      53.242  19.027  67.995  1.00  0.00           H  
ATOM    676  HD1 TYR A  48      51.712  17.156  67.690  1.00  0.00           H  
ATOM    677  HD2 TYR A  48      55.322  17.418  65.453  1.00  0.00           H  
ATOM    678  HE1 TYR A  48      51.483  14.791  67.054  1.00  0.00           H  
ATOM    679  HE2 TYR A  48      55.102  15.054  64.809  1.00  0.00           H  
ATOM    680  HH  TYR A  48      53.776  12.928  66.037  1.00  0.00           H  
ATOM    681  N   ARG A  49      52.994  21.919  67.342  1.00  0.00           N  
ATOM    682  CA  ARG A  49      53.392  23.281  67.682  1.00  0.00           C  
ATOM    683  C   ARG A  49      54.727  23.287  68.421  1.00  0.00           C  
ATOM    684  O   ARG A  49      54.866  23.926  69.465  1.00  0.00           O  
ATOM    685  CB  ARG A  49      52.318  23.950  68.540  1.00  0.00           C  
ATOM    686  CG  ARG A  49      51.077  24.351  67.759  1.00  0.00           C  
ATOM    687  CD  ARG A  49      50.997  25.858  67.577  1.00  0.00           C  
ATOM    688  NE  ARG A  49      50.069  26.475  68.522  1.00  0.00           N  
ATOM    689  CZ  ARG A  49      50.110  27.759  68.860  1.00  0.00           C  
ATOM    690  NH1 ARG A  49      51.027  28.558  68.333  1.00  0.00           N  
ATOM    691  NH2 ARG A  49      49.233  28.246  69.727  1.00  0.00           N  
ATOM    692  H   ARG A  49      52.345  21.456  67.913  1.00  0.00           H  
ATOM    693  HA  ARG A  49      53.503  23.833  66.760  1.00  0.00           H  
ATOM    694  HB2 ARG A  49      52.019  23.267  69.321  1.00  0.00           H  
ATOM    695  HB3 ARG A  49      52.737  24.839  68.989  1.00  0.00           H  
ATOM    696  HG2 ARG A  49      51.109  23.884  66.785  1.00  0.00           H  
ATOM    697  HG3 ARG A  49      50.202  24.014  68.293  1.00  0.00           H  
ATOM    698  HD2 ARG A  49      51.979  26.279  67.724  1.00  0.00           H  
ATOM    699  HD3 ARG A  49      50.664  26.068  66.571  1.00  0.00           H  
ATOM    700  HE  ARG A  49      49.383  25.902  68.924  1.00  0.00           H  
ATOM    701 HH11 ARG A  49      51.689  28.194  67.677  1.00  0.00           H  
ATOM    702 HH12 ARG A  49      51.055  29.525  68.588  1.00  0.00           H  
ATOM    703 HH21 ARG A  49      48.540  27.647  70.128  1.00  0.00           H  
ATOM    704 HH22 ARG A  49      49.264  29.212  69.982  1.00  0.00           H  
ATOM    705  N   ASP A  50      55.705  22.574  67.874  1.00  0.00           N  
ATOM    706  CA  ASP A  50      57.028  22.499  68.482  1.00  0.00           C  
ATOM    707  C   ASP A  50      58.117  22.462  67.412  1.00  0.00           C  
ATOM    708  O   ASP A  50      59.217  21.967  67.649  1.00  0.00           O  
ATOM    709  CB  ASP A  50      57.133  21.262  69.376  1.00  0.00           C  
ATOM    710  CG  ASP A  50      57.391  21.616  70.826  1.00  0.00           C  
ATOM    711  OD1 ASP A  50      58.178  22.550  71.078  1.00  0.00           O  
ATOM    712  OD2 ASP A  50      56.803  20.959  71.712  1.00  0.00           O  
ATOM    713  H   ASP A  50      55.533  22.086  67.041  1.00  0.00           H  
ATOM    714  HA  ASP A  50      57.166  23.382  69.088  1.00  0.00           H  
ATOM    715  HB2 ASP A  50      56.209  20.705  69.318  1.00  0.00           H  
ATOM    716  HB3 ASP A  50      57.945  20.640  69.026  1.00  0.00           H  
ATOM    717  N   GLY A  51      57.798  22.991  66.234  1.00  0.00           N  
ATOM    718  CA  GLY A  51      58.759  23.007  65.146  1.00  0.00           C  
ATOM    719  C   GLY A  51      59.091  21.615  64.645  1.00  0.00           C  
ATOM    720  O   GLY A  51      60.173  21.384  64.103  1.00  0.00           O  
ATOM    721  H   GLY A  51      56.905  23.372  66.104  1.00  0.00           H  
ATOM    722  HA2 GLY A  51      58.350  23.584  64.329  1.00  0.00           H  
ATOM    723  HA3 GLY A  51      59.665  23.481  65.489  1.00  0.00           H  
ATOM    724  N   THR A  52      58.162  20.684  64.829  1.00  0.00           N  
ATOM    725  CA  THR A  52      58.363  19.307  64.397  1.00  0.00           C  
ATOM    726  C   THR A  52      57.132  18.772  63.675  1.00  0.00           C  
ATOM    727  O   THR A  52      56.043  19.331  63.787  1.00  0.00           O  
ATOM    728  CB  THR A  52      58.687  18.384  65.586  1.00  0.00           C  
ATOM    729  OG1 THR A  52      57.863  18.723  66.707  1.00  0.00           O  
ATOM    730  CG2 THR A  52      60.152  18.498  65.977  1.00  0.00           C  
ATOM    731  H   THR A  52      57.321  20.929  65.269  1.00  0.00           H  
ATOM    732  HA  THR A  52      59.203  19.290  63.717  1.00  0.00           H  
ATOM    733  HB  THR A  52      58.486  17.364  65.297  1.00  0.00           H  
ATOM    734  HG1 THR A  52      57.043  19.116  66.395  1.00  0.00           H  
ATOM    735 HG21 THR A  52      60.394  17.735  66.702  1.00  0.00           H  
ATOM    736 HG22 THR A  52      60.337  19.473  66.405  1.00  0.00           H  
ATOM    737 HG23 THR A  52      60.769  18.368  65.100  1.00  0.00           H  
ATOM    738  N   GLY A  53      57.312  17.684  62.931  1.00  0.00           N  
ATOM    739  CA  GLY A  53      56.208  17.092  62.201  1.00  0.00           C  
ATOM    740  C   GLY A  53      56.443  15.629  61.878  1.00  0.00           C  
ATOM    741  O   GLY A  53      57.420  15.035  62.334  1.00  0.00           O  
ATOM    742  H   GLY A  53      58.205  17.281  62.878  1.00  0.00           H  
ATOM    743  HA2 GLY A  53      55.311  17.179  62.795  1.00  0.00           H  
ATOM    744  HA3 GLY A  53      56.069  17.633  61.277  1.00  0.00           H  
ATOM    745  N   VAL A  54      55.543  15.046  61.093  1.00  0.00           N  
ATOM    746  CA  VAL A  54      55.658  13.643  60.711  1.00  0.00           C  
ATOM    747  C   VAL A  54      54.880  13.357  59.429  1.00  0.00           C  
ATOM    748  O   VAL A  54      53.706  13.705  59.314  1.00  0.00           O  
ATOM    749  CB  VAL A  54      55.145  12.714  61.827  1.00  0.00           C  
ATOM    750  CG1 VAL A  54      56.103  12.721  63.009  1.00  0.00           C  
ATOM    751  CG2 VAL A  54      53.746  13.124  62.260  1.00  0.00           C  
ATOM    752  H   VAL A  54      54.786  15.572  60.761  1.00  0.00           H  
ATOM    753  HA  VAL A  54      56.703  13.427  60.541  1.00  0.00           H  
ATOM    754  HB  VAL A  54      55.099  11.708  61.436  1.00  0.00           H  
ATOM    755 HG11 VAL A  54      57.113  12.582  62.654  1.00  0.00           H  
ATOM    756 HG12 VAL A  54      56.028  13.667  63.527  1.00  0.00           H  
ATOM    757 HG13 VAL A  54      55.846  11.919  63.684  1.00  0.00           H  
ATOM    758 HG21 VAL A  54      53.420  13.965  61.668  1.00  0.00           H  
ATOM    759 HG22 VAL A  54      53.066  12.296  62.115  1.00  0.00           H  
ATOM    760 HG23 VAL A  54      53.759  13.401  63.304  1.00  0.00           H  
ATOM    761  N   VAL A  55      55.545  12.721  58.470  1.00  0.00           N  
ATOM    762  CA  VAL A  55      54.917  12.387  57.197  1.00  0.00           C  
ATOM    763  C   VAL A  55      55.029  10.895  56.906  1.00  0.00           C  
ATOM    764  O   VAL A  55      56.023  10.259  57.251  1.00  0.00           O  
ATOM    765  CB  VAL A  55      55.548  13.176  56.035  1.00  0.00           C  
ATOM    766  CG1 VAL A  55      54.814  12.890  54.734  1.00  0.00           C  
ATOM    767  CG2 VAL A  55      55.547  14.667  56.340  1.00  0.00           C  
ATOM    768  H   VAL A  55      56.481  12.471  58.622  1.00  0.00           H  
ATOM    769  HA  VAL A  55      53.872  12.656  57.261  1.00  0.00           H  
ATOM    770  HB  VAL A  55      56.574  12.853  55.924  1.00  0.00           H  
ATOM    771 HG11 VAL A  55      53.864  12.425  54.953  1.00  0.00           H  
ATOM    772 HG12 VAL A  55      54.651  13.814  54.202  1.00  0.00           H  
ATOM    773 HG13 VAL A  55      55.409  12.223  54.127  1.00  0.00           H  
ATOM    774 HG21 VAL A  55      55.194  14.826  57.349  1.00  0.00           H  
ATOM    775 HG22 VAL A  55      56.551  15.055  56.245  1.00  0.00           H  
ATOM    776 HG23 VAL A  55      54.898  15.177  55.645  1.00  0.00           H  
ATOM    777  N   GLU A  56      54.001  10.344  56.265  1.00  0.00           N  
ATOM    778  CA  GLU A  56      53.986   8.927  55.926  1.00  0.00           C  
ATOM    779  C   GLU A  56      53.800   8.728  54.425  1.00  0.00           C  
ATOM    780  O   GLU A  56      52.721   8.967  53.883  1.00  0.00           O  
ATOM    781  CB  GLU A  56      52.867   8.210  56.686  1.00  0.00           C  
ATOM    782  CG  GLU A  56      53.277   6.855  57.237  1.00  0.00           C  
ATOM    783  CD  GLU A  56      52.103   5.906  57.385  1.00  0.00           C  
ATOM    784  OE1 GLU A  56      51.794   5.189  56.412  1.00  0.00           O  
ATOM    785  OE2 GLU A  56      51.493   5.883  58.475  1.00  0.00           O  
ATOM    786  H   GLU A  56      53.237  10.906  56.016  1.00  0.00           H  
ATOM    787  HA  GLU A  56      54.934   8.505  56.218  1.00  0.00           H  
ATOM    788  HB2 GLU A  56      52.555   8.833  57.513  1.00  0.00           H  
ATOM    789  HB3 GLU A  56      52.030   8.066  56.020  1.00  0.00           H  
ATOM    790  HG2 GLU A  56      53.997   6.411  56.566  1.00  0.00           H  
ATOM    791  HG3 GLU A  56      53.731   6.997  58.207  1.00  0.00           H  
ATOM    792  N   PHE A  57      54.864   8.291  53.756  1.00  0.00           N  
ATOM    793  CA  PHE A  57      54.821   8.062  52.317  1.00  0.00           C  
ATOM    794  C   PHE A  57      54.161   6.724  52.000  1.00  0.00           C  
ATOM    795  O   PHE A  57      54.569   5.679  52.508  1.00  0.00           O  
ATOM    796  CB  PHE A  57      56.234   8.099  51.732  1.00  0.00           C  
ATOM    797  CG  PHE A  57      56.937   9.408  51.944  1.00  0.00           C  
ATOM    798  CD1 PHE A  57      56.676  10.492  51.120  1.00  0.00           C  
ATOM    799  CD2 PHE A  57      57.858   9.559  52.968  1.00  0.00           C  
ATOM    800  CE1 PHE A  57      57.323  11.698  51.313  1.00  0.00           C  
ATOM    801  CE2 PHE A  57      58.508  10.762  53.167  1.00  0.00           C  
ATOM    802  CZ  PHE A  57      58.239  11.834  52.338  1.00  0.00           C  
ATOM    803  H   PHE A  57      55.698   8.119  54.244  1.00  0.00           H  
ATOM    804  HA  PHE A  57      54.237   8.852  51.874  1.00  0.00           H  
ATOM    805  HB2 PHE A  57      56.828   7.325  52.195  1.00  0.00           H  
ATOM    806  HB3 PHE A  57      56.181   7.919  50.668  1.00  0.00           H  
ATOM    807  HD1 PHE A  57      55.959  10.388  50.319  1.00  0.00           H  
ATOM    808  HD2 PHE A  57      58.070   8.719  53.617  1.00  0.00           H  
ATOM    809  HE1 PHE A  57      57.110  12.536  50.665  1.00  0.00           H  
ATOM    810  HE2 PHE A  57      59.223  10.864  53.969  1.00  0.00           H  
ATOM    811  HZ  PHE A  57      58.745  12.776  52.491  1.00  0.00           H  
ATOM    812  N   VAL A  58      53.138   6.762  51.152  1.00  0.00           N  
ATOM    813  CA  VAL A  58      52.419   5.553  50.764  1.00  0.00           C  
ATOM    814  C   VAL A  58      53.373   4.506  50.200  1.00  0.00           C  
ATOM    815  O   VAL A  58      53.166   3.305  50.373  1.00  0.00           O  
ATOM    816  CB  VAL A  58      51.332   5.858  49.718  1.00  0.00           C  
ATOM    817  CG1 VAL A  58      51.833   6.877  48.706  1.00  0.00           C  
ATOM    818  CG2 VAL A  58      50.888   4.580  49.023  1.00  0.00           C  
ATOM    819  H   VAL A  58      52.858   7.624  50.779  1.00  0.00           H  
ATOM    820  HA  VAL A  58      51.940   5.153  51.646  1.00  0.00           H  
ATOM    821  HB  VAL A  58      50.478   6.280  50.227  1.00  0.00           H  
ATOM    822 HG11 VAL A  58      51.682   7.874  49.095  1.00  0.00           H  
ATOM    823 HG12 VAL A  58      52.886   6.717  48.524  1.00  0.00           H  
ATOM    824 HG13 VAL A  58      51.286   6.766  47.781  1.00  0.00           H  
ATOM    825 HG21 VAL A  58      51.593   4.331  48.244  1.00  0.00           H  
ATOM    826 HG22 VAL A  58      50.849   3.774  49.742  1.00  0.00           H  
ATOM    827 HG23 VAL A  58      49.909   4.724  48.592  1.00  0.00           H  
ATOM    828  N   ARG A  59      54.419   4.970  49.524  1.00  0.00           N  
ATOM    829  CA  ARG A  59      55.406   4.071  48.932  1.00  0.00           C  
ATOM    830  C   ARG A  59      56.765   4.238  49.606  1.00  0.00           C  
ATOM    831  O   ARG A  59      57.402   5.285  49.494  1.00  0.00           O  
ATOM    832  CB  ARG A  59      55.532   4.337  47.432  1.00  0.00           C  
ATOM    833  CG  ARG A  59      54.195   4.472  46.722  1.00  0.00           C  
ATOM    834  CD  ARG A  59      53.830   3.199  45.975  1.00  0.00           C  
ATOM    835  NE  ARG A  59      52.917   2.356  46.742  1.00  0.00           N  
ATOM    836  CZ  ARG A  59      52.662   1.087  46.445  1.00  0.00           C  
ATOM    837  NH1 ARG A  59      53.250   0.517  45.402  1.00  0.00           N  
ATOM    838  NH2 ARG A  59      51.818   0.386  47.191  1.00  0.00           N  
ATOM    839  H   ARG A  59      54.532   5.937  49.420  1.00  0.00           H  
ATOM    840  HA  ARG A  59      55.064   3.059  49.083  1.00  0.00           H  
ATOM    841  HB2 ARG A  59      56.086   5.252  47.285  1.00  0.00           H  
ATOM    842  HB3 ARG A  59      56.075   3.521  46.979  1.00  0.00           H  
ATOM    843  HG2 ARG A  59      53.428   4.678  47.454  1.00  0.00           H  
ATOM    844  HG3 ARG A  59      54.253   5.288  46.017  1.00  0.00           H  
ATOM    845  HD2 ARG A  59      53.358   3.467  45.042  1.00  0.00           H  
ATOM    846  HD3 ARG A  59      54.735   2.644  45.774  1.00  0.00           H  
ATOM    847  HE  ARG A  59      52.471   2.758  47.516  1.00  0.00           H  
ATOM    848 HH11 ARG A  59      53.887   1.042  44.838  1.00  0.00           H  
ATOM    849 HH12 ARG A  59      53.057  -0.440  45.181  1.00  0.00           H  
ATOM    850 HH21 ARG A  59      51.372   0.812  47.977  1.00  0.00           H  
ATOM    851 HH22 ARG A  59      51.626  -0.569  46.966  1.00  0.00           H  
ATOM    852  N   LYS A  60      57.202   3.198  50.307  1.00  0.00           N  
ATOM    853  CA  LYS A  60      58.485   3.226  51.000  1.00  0.00           C  
ATOM    854  C   LYS A  60      59.560   3.863  50.125  1.00  0.00           C  
ATOM    855  O   LYS A  60      60.494   4.485  50.629  1.00  0.00           O  
ATOM    856  CB  LYS A  60      58.907   1.810  51.395  1.00  0.00           C  
ATOM    857  CG  LYS A  60      60.342   1.715  51.883  1.00  0.00           C  
ATOM    858  CD  LYS A  60      60.418   1.120  53.278  1.00  0.00           C  
ATOM    859  CE  LYS A  60      61.852   0.801  53.671  1.00  0.00           C  
ATOM    860  NZ  LYS A  60      62.311  -0.491  53.088  1.00  0.00           N  
ATOM    861  H   LYS A  60      56.648   2.391  50.361  1.00  0.00           H  
ATOM    862  HA  LYS A  60      58.368   3.820  51.894  1.00  0.00           H  
ATOM    863  HB2 LYS A  60      58.257   1.460  52.182  1.00  0.00           H  
ATOM    864  HB3 LYS A  60      58.798   1.162  50.537  1.00  0.00           H  
ATOM    865  HG2 LYS A  60      60.903   1.089  51.206  1.00  0.00           H  
ATOM    866  HG3 LYS A  60      60.772   2.706  51.900  1.00  0.00           H  
ATOM    867  HD2 LYS A  60      60.014   1.831  53.985  1.00  0.00           H  
ATOM    868  HD3 LYS A  60      59.834   0.212  53.306  1.00  0.00           H  
ATOM    869  HE2 LYS A  60      62.494   1.593  53.318  1.00  0.00           H  
ATOM    870  HE3 LYS A  60      61.912   0.741  54.748  1.00  0.00           H  
ATOM    871  HZ1 LYS A  60      63.270  -0.715  53.424  1.00  0.00           H  
ATOM    872  HZ2 LYS A  60      62.327  -0.429  52.050  1.00  0.00           H  
ATOM    873  HZ3 LYS A  60      61.669  -1.259  53.368  1.00  0.00           H  
ATOM    874  N   GLU A  61      59.421   3.702  48.813  1.00  0.00           N  
ATOM    875  CA  GLU A  61      60.382   4.263  47.869  1.00  0.00           C  
ATOM    876  C   GLU A  61      60.483   5.777  48.030  1.00  0.00           C  
ATOM    877  O   GLU A  61      61.578   6.337  48.068  1.00  0.00           O  
ATOM    878  CB  GLU A  61      59.981   3.916  46.433  1.00  0.00           C  
ATOM    879  CG  GLU A  61      60.749   2.740  45.854  1.00  0.00           C  
ATOM    880  CD  GLU A  61      59.890   1.864  44.964  1.00  0.00           C  
ATOM    881  OE1 GLU A  61      59.744   2.196  43.769  1.00  0.00           O  
ATOM    882  OE2 GLU A  61      59.362   0.848  45.460  1.00  0.00           O  
ATOM    883  H   GLU A  61      58.656   3.195  48.471  1.00  0.00           H  
ATOM    884  HA  GLU A  61      61.347   3.826  48.078  1.00  0.00           H  
ATOM    885  HB2 GLU A  61      58.928   3.677  46.414  1.00  0.00           H  
ATOM    886  HB3 GLU A  61      60.157   4.778  45.806  1.00  0.00           H  
ATOM    887  HG2 GLU A  61      61.575   3.119  45.270  1.00  0.00           H  
ATOM    888  HG3 GLU A  61      61.130   2.139  46.667  1.00  0.00           H  
ATOM    889  N   ASP A  62      59.332   6.434  48.123  1.00  0.00           N  
ATOM    890  CA  ASP A  62      59.290   7.883  48.279  1.00  0.00           C  
ATOM    891  C   ASP A  62      59.880   8.301  49.622  1.00  0.00           C  
ATOM    892  O   ASP A  62      60.426   9.396  49.756  1.00  0.00           O  
ATOM    893  CB  ASP A  62      57.850   8.388  48.162  1.00  0.00           C  
ATOM    894  CG  ASP A  62      56.971   7.449  47.360  1.00  0.00           C  
ATOM    895  OD1 ASP A  62      57.503   6.755  46.468  1.00  0.00           O  
ATOM    896  OD2 ASP A  62      55.751   7.408  47.622  1.00  0.00           O  
ATOM    897  H   ASP A  62      58.491   5.932  48.086  1.00  0.00           H  
ATOM    898  HA  ASP A  62      59.879   8.319  47.489  1.00  0.00           H  
ATOM    899  HB2 ASP A  62      57.428   8.488  49.152  1.00  0.00           H  
ATOM    900  HB3 ASP A  62      57.853   9.352  47.677  1.00  0.00           H  
ATOM    901  N   MET A  63      59.767   7.423  50.613  1.00  0.00           N  
ATOM    902  CA  MET A  63      60.289   7.702  51.946  1.00  0.00           C  
ATOM    903  C   MET A  63      61.815   7.712  51.939  1.00  0.00           C  
ATOM    904  O   MET A  63      62.441   8.725  52.254  1.00  0.00           O  
ATOM    905  CB  MET A  63      59.779   6.662  52.945  1.00  0.00           C  
ATOM    906  CG  MET A  63      60.290   6.879  54.361  1.00  0.00           C  
ATOM    907  SD  MET A  63      60.490   5.335  55.271  1.00  0.00           S  
ATOM    908  CE  MET A  63      62.064   4.768  54.632  1.00  0.00           C  
ATOM    909  H   MET A  63      59.321   6.566  50.445  1.00  0.00           H  
ATOM    910  HA  MET A  63      59.936   8.678  52.242  1.00  0.00           H  
ATOM    911  HB2 MET A  63      58.701   6.699  52.965  1.00  0.00           H  
ATOM    912  HB3 MET A  63      60.093   5.681  52.619  1.00  0.00           H  
ATOM    913  HG2 MET A  63      61.246   7.377  54.313  1.00  0.00           H  
ATOM    914  HG3 MET A  63      59.586   7.504  54.890  1.00  0.00           H  
ATOM    915  HE1 MET A  63      62.669   4.395  55.446  1.00  0.00           H  
ATOM    916  HE2 MET A  63      61.898   3.976  53.915  1.00  0.00           H  
ATOM    917  HE3 MET A  63      62.575   5.589  54.151  1.00  0.00           H  
ATOM    918  N   THR A  64      62.408   6.579  51.578  1.00  0.00           N  
ATOM    919  CA  THR A  64      63.861   6.458  51.534  1.00  0.00           C  
ATOM    920  C   THR A  64      64.475   7.536  50.646  1.00  0.00           C  
ATOM    921  O   THR A  64      65.593   7.990  50.888  1.00  0.00           O  
ATOM    922  CB  THR A  64      64.293   5.073  51.015  1.00  0.00           C  
ATOM    923  OG1 THR A  64      63.718   4.045  51.828  1.00  0.00           O  
ATOM    924  CG2 THR A  64      65.809   4.943  51.022  1.00  0.00           C  
ATOM    925  H   THR A  64      61.856   5.807  51.338  1.00  0.00           H  
ATOM    926  HA  THR A  64      64.237   6.577  52.539  1.00  0.00           H  
ATOM    927  HB  THR A  64      63.940   4.959  50.001  1.00  0.00           H  
ATOM    928  HG1 THR A  64      62.868   4.341  52.164  1.00  0.00           H  
ATOM    929 HG21 THR A  64      66.168   4.879  50.005  1.00  0.00           H  
ATOM    930 HG22 THR A  64      66.091   4.051  51.561  1.00  0.00           H  
ATOM    931 HG23 THR A  64      66.242   5.808  51.502  1.00  0.00           H  
ATOM    932  N   TYR A  65      63.737   7.939  49.617  1.00  0.00           N  
ATOM    933  CA  TYR A  65      64.211   8.960  48.692  1.00  0.00           C  
ATOM    934  C   TYR A  65      64.134  10.347  49.325  1.00  0.00           C  
ATOM    935  O   TYR A  65      65.047  11.159  49.178  1.00  0.00           O  
ATOM    936  CB  TYR A  65      63.389   8.930  47.401  1.00  0.00           C  
ATOM    937  CG  TYR A  65      63.676  10.089  46.473  1.00  0.00           C  
ATOM    938  CD1 TYR A  65      64.675  10.003  45.511  1.00  0.00           C  
ATOM    939  CD2 TYR A  65      62.949  11.270  46.558  1.00  0.00           C  
ATOM    940  CE1 TYR A  65      64.942  11.059  44.661  1.00  0.00           C  
ATOM    941  CE2 TYR A  65      63.208  12.331  45.712  1.00  0.00           C  
ATOM    942  CZ  TYR A  65      64.205  12.220  44.766  1.00  0.00           C  
ATOM    943  OH  TYR A  65      64.467  13.274  43.920  1.00  0.00           O  
ATOM    944  H   TYR A  65      62.854   7.538  49.476  1.00  0.00           H  
ATOM    945  HA  TYR A  65      65.242   8.741  48.455  1.00  0.00           H  
ATOM    946  HB2 TYR A  65      63.602   8.018  46.868  1.00  0.00           H  
ATOM    947  HB3 TYR A  65      62.339   8.958  47.652  1.00  0.00           H  
ATOM    948  HD1 TYR A  65      65.249   9.090  45.433  1.00  0.00           H  
ATOM    949  HD2 TYR A  65      62.169  11.353  47.300  1.00  0.00           H  
ATOM    950  HE1 TYR A  65      65.723  10.972  43.920  1.00  0.00           H  
ATOM    951  HE2 TYR A  65      62.632  13.241  45.793  1.00  0.00           H  
ATOM    952  HH  TYR A  65      64.570  12.947  43.024  1.00  0.00           H  
ATOM    953  N   ALA A  66      63.039  10.607  50.030  1.00  0.00           N  
ATOM    954  CA  ALA A  66      62.843  11.893  50.689  1.00  0.00           C  
ATOM    955  C   ALA A  66      63.943  12.159  51.712  1.00  0.00           C  
ATOM    956  O   ALA A  66      64.448  13.276  51.818  1.00  0.00           O  
ATOM    957  CB  ALA A  66      61.477  11.941  51.357  1.00  0.00           C  
ATOM    958  H   ALA A  66      62.346   9.918  50.111  1.00  0.00           H  
ATOM    959  HA  ALA A  66      62.875  12.664  49.933  1.00  0.00           H  
ATOM    960  HB1 ALA A  66      61.335  11.049  51.949  1.00  0.00           H  
ATOM    961  HB2 ALA A  66      61.418  12.811  51.995  1.00  0.00           H  
ATOM    962  HB3 ALA A  66      60.708  11.997  50.601  1.00  0.00           H  
ATOM    963  N   VAL A  67      64.309  11.125  52.462  1.00  0.00           N  
ATOM    964  CA  VAL A  67      65.349  11.248  53.476  1.00  0.00           C  
ATOM    965  C   VAL A  67      66.718  11.458  52.838  1.00  0.00           C  
ATOM    966  O   VAL A  67      67.673  11.853  53.507  1.00  0.00           O  
ATOM    967  CB  VAL A  67      65.404  10.000  54.379  1.00  0.00           C  
ATOM    968  CG1 VAL A  67      64.154   9.911  55.243  1.00  0.00           C  
ATOM    969  CG2 VAL A  67      65.571   8.742  53.540  1.00  0.00           C  
ATOM    970  H   VAL A  67      63.869  10.259  52.331  1.00  0.00           H  
ATOM    971  HA  VAL A  67      65.115  12.102  54.094  1.00  0.00           H  
ATOM    972  HB  VAL A  67      66.260  10.089  55.031  1.00  0.00           H  
ATOM    973 HG11 VAL A  67      63.937  10.885  55.660  1.00  0.00           H  
ATOM    974 HG12 VAL A  67      63.322   9.583  54.639  1.00  0.00           H  
ATOM    975 HG13 VAL A  67      64.320   9.207  56.044  1.00  0.00           H  
ATOM    976 HG21 VAL A  67      64.628   8.490  53.078  1.00  0.00           H  
ATOM    977 HG22 VAL A  67      66.312   8.917  52.773  1.00  0.00           H  
ATOM    978 HG23 VAL A  67      65.893   7.929  54.171  1.00  0.00           H  
ATOM    979  N   ARG A  68      66.805  11.193  51.538  1.00  0.00           N  
ATOM    980  CA  ARG A  68      68.057  11.352  50.809  1.00  0.00           C  
ATOM    981  C   ARG A  68      68.121  12.718  50.131  1.00  0.00           C  
ATOM    982  O   ARG A  68      69.080  13.469  50.311  1.00  0.00           O  
ATOM    983  CB  ARG A  68      68.208  10.245  49.764  1.00  0.00           C  
ATOM    984  CG  ARG A  68      68.537   8.887  50.360  1.00  0.00           C  
ATOM    985  CD  ARG A  68      68.771   7.846  49.277  1.00  0.00           C  
ATOM    986  NE  ARG A  68      70.068   7.190  49.419  1.00  0.00           N  
ATOM    987  CZ  ARG A  68      71.200   7.686  48.930  1.00  0.00           C  
ATOM    988  NH1 ARG A  68      71.193   8.836  48.271  1.00  0.00           N  
ATOM    989  NH2 ARG A  68      72.341   7.030  49.100  1.00  0.00           N  
ATOM    990  H   ARG A  68      66.009  10.881  51.060  1.00  0.00           H  
ATOM    991  HA  ARG A  68      68.868  11.279  51.519  1.00  0.00           H  
ATOM    992  HB2 ARG A  68      67.282  10.159  49.213  1.00  0.00           H  
ATOM    993  HB3 ARG A  68      69.000  10.516  49.083  1.00  0.00           H  
ATOM    994  HG2 ARG A  68      69.431   8.974  50.960  1.00  0.00           H  
ATOM    995  HG3 ARG A  68      67.713   8.568  50.982  1.00  0.00           H  
ATOM    996  HD2 ARG A  68      67.993   7.099  49.339  1.00  0.00           H  
ATOM    997  HD3 ARG A  68      68.727   8.332  48.314  1.00  0.00           H  
ATOM    998  HE  ARG A  68      70.096   6.338  49.902  1.00  0.00           H  
ATOM    999 HH11 ARG A  68      70.335   9.333  48.141  1.00  0.00           H  
ATOM   1000 HH12 ARG A  68      72.047   9.207  47.905  1.00  0.00           H  
ATOM   1001 HH21 ARG A  68      72.349   6.162  49.596  1.00  0.00           H  
ATOM   1002 HH22 ARG A  68      73.191   7.404  48.731  1.00  0.00           H  
ATOM   1003  N   LYS A  69      67.093  13.035  49.352  1.00  0.00           N  
ATOM   1004  CA  LYS A  69      67.029  14.310  48.647  1.00  0.00           C  
ATOM   1005  C   LYS A  69      66.305  15.359  49.484  1.00  0.00           C  
ATOM   1006  O   LYS A  69      66.706  16.523  49.520  1.00  0.00           O  
ATOM   1007  CB  LYS A  69      66.321  14.137  47.301  1.00  0.00           C  
ATOM   1008  CG  LYS A  69      67.104  13.303  46.303  1.00  0.00           C  
ATOM   1009  CD  LYS A  69      67.503  14.119  45.085  1.00  0.00           C  
ATOM   1010  CE  LYS A  69      68.424  13.333  44.165  1.00  0.00           C  
ATOM   1011  NZ  LYS A  69      69.851  13.720  44.344  1.00  0.00           N  
ATOM   1012  H   LYS A  69      66.356  12.395  49.247  1.00  0.00           H  
ATOM   1013  HA  LYS A  69      68.041  14.642  48.470  1.00  0.00           H  
ATOM   1014  HB2 LYS A  69      65.367  13.659  47.469  1.00  0.00           H  
ATOM   1015  HB3 LYS A  69      66.153  15.114  46.870  1.00  0.00           H  
ATOM   1016  HG2 LYS A  69      67.998  12.931  46.782  1.00  0.00           H  
ATOM   1017  HG3 LYS A  69      66.492  12.471  45.984  1.00  0.00           H  
ATOM   1018  HD2 LYS A  69      66.612  14.391  44.537  1.00  0.00           H  
ATOM   1019  HD3 LYS A  69      68.013  15.013  45.413  1.00  0.00           H  
ATOM   1020  HE2 LYS A  69      68.317  12.281  44.381  1.00  0.00           H  
ATOM   1021  HE3 LYS A  69      68.135  13.521  43.141  1.00  0.00           H  
ATOM   1022  HZ1 LYS A  69      70.381  12.938  44.779  1.00  0.00           H  
ATOM   1023  HZ2 LYS A  69      69.918  14.555  44.964  1.00  0.00           H  
ATOM   1024  HZ3 LYS A  69      70.277  13.949  43.424  1.00  0.00           H  
ATOM   1025  N   LEU A  70      65.239  14.940  50.156  1.00  0.00           N  
ATOM   1026  CA  LEU A  70      64.460  15.843  50.996  1.00  0.00           C  
ATOM   1027  C   LEU A  70      64.860  15.707  52.463  1.00  0.00           C  
ATOM   1028  O   LEU A  70      64.039  15.359  53.310  1.00  0.00           O  
ATOM   1029  CB  LEU A  70      62.965  15.559  50.835  1.00  0.00           C  
ATOM   1030  CG  LEU A  70      62.434  15.557  49.402  1.00  0.00           C  
ATOM   1031  CD1 LEU A  70      60.954  15.213  49.382  1.00  0.00           C  
ATOM   1032  CD2 LEU A  70      62.679  16.905  48.740  1.00  0.00           C  
ATOM   1033  H   LEU A  70      64.970  14.000  50.089  1.00  0.00           H  
ATOM   1034  HA  LEU A  70      64.664  16.854  50.672  1.00  0.00           H  
ATOM   1035  HB2 LEU A  70      62.766  14.590  51.263  1.00  0.00           H  
ATOM   1036  HB3 LEU A  70      62.425  16.315  51.388  1.00  0.00           H  
ATOM   1037  HG  LEU A  70      62.958  14.803  48.831  1.00  0.00           H  
ATOM   1038 HD11 LEU A  70      60.604  15.179  48.361  1.00  0.00           H  
ATOM   1039 HD12 LEU A  70      60.400  15.966  49.926  1.00  0.00           H  
ATOM   1040 HD13 LEU A  70      60.801  14.251  49.848  1.00  0.00           H  
ATOM   1041 HD21 LEU A  70      61.951  17.619  49.098  1.00  0.00           H  
ATOM   1042 HD22 LEU A  70      62.585  16.803  47.668  1.00  0.00           H  
ATOM   1043 HD23 LEU A  70      63.672  17.252  48.983  1.00  0.00           H  
ATOM   1044  N   ASP A  71      66.126  15.984  52.752  1.00  0.00           N  
ATOM   1045  CA  ASP A  71      66.635  15.894  54.115  1.00  0.00           C  
ATOM   1046  C   ASP A  71      67.607  17.033  54.408  1.00  0.00           C  
ATOM   1047  O   ASP A  71      68.724  17.057  53.893  1.00  0.00           O  
ATOM   1048  CB  ASP A  71      67.326  14.549  54.339  1.00  0.00           C  
ATOM   1049  CG  ASP A  71      68.347  14.600  55.458  1.00  0.00           C  
ATOM   1050  OD1 ASP A  71      69.473  15.082  55.212  1.00  0.00           O  
ATOM   1051  OD2 ASP A  71      68.023  14.157  56.579  1.00  0.00           O  
ATOM   1052  H   ASP A  71      66.735  16.256  52.032  1.00  0.00           H  
ATOM   1053  HA  ASP A  71      65.796  15.974  54.788  1.00  0.00           H  
ATOM   1054  HB2 ASP A  71      66.581  13.806  54.589  1.00  0.00           H  
ATOM   1055  HB3 ASP A  71      67.829  14.255  53.429  1.00  0.00           H  
ATOM   1056  N   ASN A  72      67.174  17.977  55.238  1.00  0.00           N  
ATOM   1057  CA  ASN A  72      68.005  19.120  55.597  1.00  0.00           C  
ATOM   1058  C   ASN A  72      67.932  20.204  54.527  1.00  0.00           C  
ATOM   1059  O   ASN A  72      68.921  20.882  54.245  1.00  0.00           O  
ATOM   1060  CB  ASN A  72      69.457  18.679  55.794  1.00  0.00           C  
ATOM   1061  CG  ASN A  72      70.231  19.621  56.698  1.00  0.00           C  
ATOM   1062  OD1 ASN A  72      69.743  20.028  57.751  1.00  0.00           O  
ATOM   1063  ND2 ASN A  72      71.444  19.971  56.286  1.00  0.00           N  
ATOM   1064  H   ASN A  72      66.274  17.904  55.617  1.00  0.00           H  
ATOM   1065  HA  ASN A  72      67.632  19.521  56.528  1.00  0.00           H  
ATOM   1066  HB2 ASN A  72      69.472  17.695  56.238  1.00  0.00           H  
ATOM   1067  HB3 ASN A  72      69.950  18.644  54.835  1.00  0.00           H  
ATOM   1068 HD21 ASN A  72      71.768  19.607  55.435  1.00  0.00           H  
ATOM   1069 HD22 ASN A  72      71.966  20.579  56.851  1.00  0.00           H  
ATOM   1070  N   THR A  73      66.753  20.364  53.934  1.00  0.00           N  
ATOM   1071  CA  THR A  73      66.549  21.366  52.895  1.00  0.00           C  
ATOM   1072  C   THR A  73      65.718  22.533  53.413  1.00  0.00           C  
ATOM   1073  O   THR A  73      65.072  22.436  54.455  1.00  0.00           O  
ATOM   1074  CB  THR A  73      65.853  20.761  51.662  1.00  0.00           C  
ATOM   1075  OG1 THR A  73      64.527  20.341  52.004  1.00  0.00           O  
ATOM   1076  CG2 THR A  73      66.640  19.577  51.121  1.00  0.00           C  
ATOM   1077  H   THR A  73      66.003  19.795  54.203  1.00  0.00           H  
ATOM   1078  HA  THR A  73      67.519  21.732  52.591  1.00  0.00           H  
ATOM   1079  HB  THR A  73      65.795  21.518  50.893  1.00  0.00           H  
ATOM   1080  HG1 THR A  73      64.178  20.915  52.691  1.00  0.00           H  
ATOM   1081 HG21 THR A  73      67.056  19.016  51.943  1.00  0.00           H  
ATOM   1082 HG22 THR A  73      67.439  19.936  50.488  1.00  0.00           H  
ATOM   1083 HG23 THR A  73      65.984  18.942  50.546  1.00  0.00           H  
ATOM   1084  N   LYS A  74      65.740  23.640  52.677  1.00  0.00           N  
ATOM   1085  CA  LYS A  74      64.986  24.829  53.060  1.00  0.00           C  
ATOM   1086  C   LYS A  74      63.514  24.685  52.686  1.00  0.00           C  
ATOM   1087  O   LYS A  74      63.155  24.736  51.510  1.00  0.00           O  
ATOM   1088  CB  LYS A  74      65.574  26.070  52.385  1.00  0.00           C  
ATOM   1089  CG  LYS A  74      64.922  27.369  52.824  1.00  0.00           C  
ATOM   1090  CD  LYS A  74      65.955  28.388  53.273  1.00  0.00           C  
ATOM   1091  CE  LYS A  74      66.290  29.370  52.159  1.00  0.00           C  
ATOM   1092  NZ  LYS A  74      67.529  28.983  51.430  1.00  0.00           N  
ATOM   1093  H   LYS A  74      66.275  23.658  51.855  1.00  0.00           H  
ATOM   1094  HA  LYS A  74      65.064  24.941  54.130  1.00  0.00           H  
ATOM   1095  HB2 LYS A  74      66.629  26.125  52.615  1.00  0.00           H  
ATOM   1096  HB3 LYS A  74      65.454  25.976  51.315  1.00  0.00           H  
ATOM   1097  HG2 LYS A  74      64.363  27.778  51.996  1.00  0.00           H  
ATOM   1098  HG3 LYS A  74      64.253  27.164  53.648  1.00  0.00           H  
ATOM   1099  HD2 LYS A  74      65.565  28.938  54.116  1.00  0.00           H  
ATOM   1100  HD3 LYS A  74      66.858  27.871  53.565  1.00  0.00           H  
ATOM   1101  HE2 LYS A  74      65.466  29.396  51.461  1.00  0.00           H  
ATOM   1102  HE3 LYS A  74      66.427  30.350  52.591  1.00  0.00           H  
ATOM   1103  HZ1 LYS A  74      67.638  29.565  50.577  1.00  0.00           H  
ATOM   1104  HZ2 LYS A  74      67.481  27.982  51.150  1.00  0.00           H  
ATOM   1105  HZ3 LYS A  74      68.359  29.121  52.040  1.00  0.00           H  
ATOM   1106  N   PHE A  75      62.668  24.503  53.694  1.00  0.00           N  
ATOM   1107  CA  PHE A  75      61.236  24.350  53.471  1.00  0.00           C  
ATOM   1108  C   PHE A  75      60.521  25.694  53.590  1.00  0.00           C  
ATOM   1109  O   PHE A  75      60.769  26.461  54.520  1.00  0.00           O  
ATOM   1110  CB  PHE A  75      60.645  23.357  54.472  1.00  0.00           C  
ATOM   1111  CG  PHE A  75      59.162  23.504  54.659  1.00  0.00           C  
ATOM   1112  CD1 PHE A  75      58.276  22.803  53.858  1.00  0.00           C  
ATOM   1113  CD2 PHE A  75      58.654  24.344  55.638  1.00  0.00           C  
ATOM   1114  CE1 PHE A  75      56.911  22.936  54.028  1.00  0.00           C  
ATOM   1115  CE2 PHE A  75      57.290  24.481  55.813  1.00  0.00           C  
ATOM   1116  CZ  PHE A  75      56.416  23.777  55.006  1.00  0.00           C  
ATOM   1117  H   PHE A  75      63.016  24.470  54.611  1.00  0.00           H  
ATOM   1118  HA  PHE A  75      61.095  23.969  52.472  1.00  0.00           H  
ATOM   1119  HB2 PHE A  75      60.836  22.352  54.127  1.00  0.00           H  
ATOM   1120  HB3 PHE A  75      61.118  23.500  55.432  1.00  0.00           H  
ATOM   1121  HD1 PHE A  75      58.661  22.145  53.092  1.00  0.00           H  
ATOM   1122  HD2 PHE A  75      59.335  24.896  56.269  1.00  0.00           H  
ATOM   1123  HE1 PHE A  75      56.231  22.384  53.396  1.00  0.00           H  
ATOM   1124  HE2 PHE A  75      56.906  25.139  56.579  1.00  0.00           H  
ATOM   1125  HZ  PHE A  75      55.350  23.882  55.142  1.00  0.00           H  
ATOM   1126  N   ARG A  76      59.634  25.972  52.640  1.00  0.00           N  
ATOM   1127  CA  ARG A  76      58.884  27.223  52.637  1.00  0.00           C  
ATOM   1128  C   ARG A  76      57.412  26.976  52.959  1.00  0.00           C  
ATOM   1129  O   ARG A  76      56.794  26.061  52.419  1.00  0.00           O  
ATOM   1130  CB  ARG A  76      59.010  27.913  51.277  1.00  0.00           C  
ATOM   1131  CG  ARG A  76      58.472  29.335  51.264  1.00  0.00           C  
ATOM   1132  CD  ARG A  76      59.092  30.155  50.143  1.00  0.00           C  
ATOM   1133  NE  ARG A  76      58.449  29.899  48.858  1.00  0.00           N  
ATOM   1134  CZ  ARG A  76      58.663  30.629  47.770  1.00  0.00           C  
ATOM   1135  NH1 ARG A  76      59.500  31.657  47.811  1.00  0.00           N  
ATOM   1136  NH2 ARG A  76      58.040  30.334  46.636  1.00  0.00           N  
ATOM   1137  H   ARG A  76      59.479  25.321  51.925  1.00  0.00           H  
ATOM   1138  HA  ARG A  76      59.304  27.863  53.396  1.00  0.00           H  
ATOM   1139  HB2 ARG A  76      60.053  27.943  50.997  1.00  0.00           H  
ATOM   1140  HB3 ARG A  76      58.466  27.338  50.543  1.00  0.00           H  
ATOM   1141  HG2 ARG A  76      57.403  29.303  51.123  1.00  0.00           H  
ATOM   1142  HG3 ARG A  76      58.700  29.803  52.209  1.00  0.00           H  
ATOM   1143  HD2 ARG A  76      58.991  31.203  50.382  1.00  0.00           H  
ATOM   1144  HD3 ARG A  76      60.140  29.902  50.068  1.00  0.00           H  
ATOM   1145  HE  ARG A  76      57.827  29.143  48.804  1.00  0.00           H  
ATOM   1146 HH11 ARG A  76      59.972  31.882  48.664  1.00  0.00           H  
ATOM   1147 HH12 ARG A  76      59.661  32.206  46.991  1.00  0.00           H  
ATOM   1148 HH21 ARG A  76      57.408  29.560  46.601  1.00  0.00           H  
ATOM   1149 HH22 ARG A  76      58.201  30.885  45.818  1.00  0.00           H  
ATOM   1150  N   SER A  77      56.862  27.800  53.845  1.00  0.00           N  
ATOM   1151  CA  SER A  77      55.465  27.668  54.243  1.00  0.00           C  
ATOM   1152  C   SER A  77      54.563  28.518  53.351  1.00  0.00           C  
ATOM   1153  O   SER A  77      55.036  29.391  52.624  1.00  0.00           O  
ATOM   1154  CB  SER A  77      55.289  28.082  55.706  1.00  0.00           C  
ATOM   1155  OG  SER A  77      54.084  28.807  55.890  1.00  0.00           O  
ATOM   1156  H   SER A  77      57.408  28.512  54.242  1.00  0.00           H  
ATOM   1157  HA  SER A  77      55.185  26.632  54.135  1.00  0.00           H  
ATOM   1158  HB2 SER A  77      55.262  27.200  56.326  1.00  0.00           H  
ATOM   1159  HB3 SER A  77      56.119  28.707  56.003  1.00  0.00           H  
ATOM   1160  HG  SER A  77      54.207  29.462  56.580  1.00  0.00           H  
ATOM   1161  N   HIS A  78      53.263  28.253  53.413  1.00  0.00           N  
ATOM   1162  CA  HIS A  78      52.293  28.991  52.611  1.00  0.00           C  
ATOM   1163  C   HIS A  78      52.341  30.481  52.939  1.00  0.00           C  
ATOM   1164  O   HIS A  78      51.838  31.309  52.178  1.00  0.00           O  
ATOM   1165  CB  HIS A  78      50.883  28.449  52.850  1.00  0.00           C  
ATOM   1166  CG  HIS A  78      50.448  28.523  54.280  1.00  0.00           C  
ATOM   1167  ND1 HIS A  78      50.504  27.447  55.141  1.00  0.00           N  
ATOM   1168  CD2 HIS A  78      49.947  29.553  55.002  1.00  0.00           C  
ATOM   1169  CE1 HIS A  78      50.056  27.810  56.330  1.00  0.00           C  
ATOM   1170  NE2 HIS A  78      49.712  29.085  56.271  1.00  0.00           N  
ATOM   1171  H   HIS A  78      52.947  27.544  54.010  1.00  0.00           H  
ATOM   1172  HA  HIS A  78      52.551  28.856  51.572  1.00  0.00           H  
ATOM   1173  HB2 HIS A  78      50.181  29.019  52.260  1.00  0.00           H  
ATOM   1174  HB3 HIS A  78      50.846  27.413  52.544  1.00  0.00           H  
ATOM   1175  HD1 HIS A  78      50.824  26.549  54.913  1.00  0.00           H  
ATOM   1176  HD2 HIS A  78      49.766  30.557  54.646  1.00  0.00           H  
ATOM   1177  HE1 HIS A  78      49.984  27.177  57.199  1.00  0.00           H  
ATOM   1178  N   GLU A  79      52.947  30.813  54.074  1.00  0.00           N  
ATOM   1179  CA  GLU A  79      53.056  32.203  54.502  1.00  0.00           C  
ATOM   1180  C   GLU A  79      54.225  32.896  53.804  1.00  0.00           C  
ATOM   1181  O   GLU A  79      54.357  34.117  53.859  1.00  0.00           O  
ATOM   1182  CB  GLU A  79      53.236  32.280  56.019  1.00  0.00           C  
ATOM   1183  CG  GLU A  79      51.945  32.083  56.796  1.00  0.00           C  
ATOM   1184  CD  GLU A  79      50.914  33.155  56.496  1.00  0.00           C  
ATOM   1185  OE1 GLU A  79      51.246  34.352  56.635  1.00  0.00           O  
ATOM   1186  OE2 GLU A  79      49.778  32.797  56.123  1.00  0.00           O  
ATOM   1187  H   GLU A  79      53.327  30.108  54.639  1.00  0.00           H  
ATOM   1188  HA  GLU A  79      52.141  32.708  54.231  1.00  0.00           H  
ATOM   1189  HB2 GLU A  79      53.936  31.518  56.326  1.00  0.00           H  
ATOM   1190  HB3 GLU A  79      53.639  33.250  56.272  1.00  0.00           H  
ATOM   1191  HG2 GLU A  79      51.526  31.122  56.537  1.00  0.00           H  
ATOM   1192  HG3 GLU A  79      52.169  32.105  57.852  1.00  0.00           H  
ATOM   1193  N   GLY A  80      55.069  32.105  53.149  1.00  0.00           N  
ATOM   1194  CA  GLY A  80      56.214  32.658  52.451  1.00  0.00           C  
ATOM   1195  C   GLY A  80      57.479  32.612  53.285  1.00  0.00           C  
ATOM   1196  O   GLY A  80      58.514  33.141  52.883  1.00  0.00           O  
ATOM   1197  H   GLY A  80      54.912  31.136  53.140  1.00  0.00           H  
ATOM   1198  HA2 GLY A  80      56.374  32.097  51.542  1.00  0.00           H  
ATOM   1199  HA3 GLY A  80      56.003  33.687  52.196  1.00  0.00           H  
ATOM   1200  N   GLU A  81      57.395  31.978  54.451  1.00  0.00           N  
ATOM   1201  CA  GLU A  81      58.542  31.868  55.344  1.00  0.00           C  
ATOM   1202  C   GLU A  81      59.349  30.609  55.039  1.00  0.00           C  
ATOM   1203  O   GLU A  81      58.788  29.539  54.803  1.00  0.00           O  
ATOM   1204  CB  GLU A  81      58.080  31.849  56.804  1.00  0.00           C  
ATOM   1205  CG  GLU A  81      58.465  33.099  57.578  1.00  0.00           C  
ATOM   1206  CD  GLU A  81      57.412  33.504  58.591  1.00  0.00           C  
ATOM   1207  OE1 GLU A  81      57.208  32.753  59.568  1.00  0.00           O  
ATOM   1208  OE2 GLU A  81      56.791  34.572  58.407  1.00  0.00           O  
ATOM   1209  H   GLU A  81      56.541  31.576  54.717  1.00  0.00           H  
ATOM   1210  HA  GLU A  81      59.170  32.731  55.186  1.00  0.00           H  
ATOM   1211  HB2 GLU A  81      57.005  31.752  56.827  1.00  0.00           H  
ATOM   1212  HB3 GLU A  81      58.521  30.997  57.296  1.00  0.00           H  
ATOM   1213  HG2 GLU A  81      59.392  32.912  58.101  1.00  0.00           H  
ATOM   1214  HG3 GLU A  81      58.605  33.911  56.880  1.00  0.00           H  
ATOM   1215  N   THR A  82      60.672  30.746  55.046  1.00  0.00           N  
ATOM   1216  CA  THR A  82      61.557  29.621  54.769  1.00  0.00           C  
ATOM   1217  C   THR A  82      62.223  29.119  56.045  1.00  0.00           C  
ATOM   1218  O   THR A  82      62.423  29.878  56.994  1.00  0.00           O  
ATOM   1219  CB  THR A  82      62.649  30.005  53.752  1.00  0.00           C  
ATOM   1220  OG1 THR A  82      62.983  31.389  53.890  1.00  0.00           O  
ATOM   1221  CG2 THR A  82      62.184  29.728  52.330  1.00  0.00           C  
ATOM   1222  H   THR A  82      61.060  31.624  55.243  1.00  0.00           H  
ATOM   1223  HA  THR A  82      60.964  28.826  54.346  1.00  0.00           H  
ATOM   1224  HB  THR A  82      63.529  29.408  53.949  1.00  0.00           H  
ATOM   1225  HG1 THR A  82      63.191  31.580  54.807  1.00  0.00           H  
ATOM   1226 HG21 THR A  82      61.435  30.453  52.048  1.00  0.00           H  
ATOM   1227 HG22 THR A  82      61.762  28.736  52.275  1.00  0.00           H  
ATOM   1228 HG23 THR A  82      63.024  29.800  51.656  1.00  0.00           H  
ATOM   1229  N   ALA A  83      62.564  27.834  56.062  1.00  0.00           N  
ATOM   1230  CA  ALA A  83      63.210  27.230  57.221  1.00  0.00           C  
ATOM   1231  C   ALA A  83      63.736  25.837  56.893  1.00  0.00           C  
ATOM   1232  O   ALA A  83      63.020  25.010  56.328  1.00  0.00           O  
ATOM   1233  CB  ALA A  83      62.240  27.169  58.392  1.00  0.00           C  
ATOM   1234  H   ALA A  83      62.379  27.280  55.276  1.00  0.00           H  
ATOM   1235  HA  ALA A  83      64.041  27.859  57.506  1.00  0.00           H  
ATOM   1236  HB1 ALA A  83      61.794  26.186  58.438  1.00  0.00           H  
ATOM   1237  HB2 ALA A  83      62.773  27.364  59.311  1.00  0.00           H  
ATOM   1238  HB3 ALA A  83      61.467  27.910  58.259  1.00  0.00           H  
ATOM   1239  N   TYR A  84      64.989  25.585  57.249  1.00  0.00           N  
ATOM   1240  CA  TYR A  84      65.613  24.292  56.990  1.00  0.00           C  
ATOM   1241  C   TYR A  84      65.006  23.208  57.875  1.00  0.00           C  
ATOM   1242  O   TYR A  84      64.944  23.350  59.097  1.00  0.00           O  
ATOM   1243  CB  TYR A  84      67.121  24.372  57.225  1.00  0.00           C  
ATOM   1244  CG  TYR A  84      67.791  25.508  56.482  1.00  0.00           C  
ATOM   1245  CD1 TYR A  84      67.948  25.462  55.102  1.00  0.00           C  
ATOM   1246  CD2 TYR A  84      68.264  26.625  57.160  1.00  0.00           C  
ATOM   1247  CE1 TYR A  84      68.560  26.497  54.419  1.00  0.00           C  
ATOM   1248  CE2 TYR A  84      68.874  27.664  56.484  1.00  0.00           C  
ATOM   1249  CZ  TYR A  84      69.020  27.594  55.115  1.00  0.00           C  
ATOM   1250  OH  TYR A  84      69.627  28.626  54.439  1.00  0.00           O  
ATOM   1251  H   TYR A  84      65.510  26.284  57.698  1.00  0.00           H  
ATOM   1252  HA  TYR A  84      65.432  24.039  55.955  1.00  0.00           H  
ATOM   1253  HB2 TYR A  84      67.308  24.512  58.279  1.00  0.00           H  
ATOM   1254  HB3 TYR A  84      67.580  23.448  56.902  1.00  0.00           H  
ATOM   1255  HD1 TYR A  84      67.585  24.601  54.560  1.00  0.00           H  
ATOM   1256  HD2 TYR A  84      68.147  26.675  58.232  1.00  0.00           H  
ATOM   1257  HE1 TYR A  84      68.673  26.443  53.346  1.00  0.00           H  
ATOM   1258  HE2 TYR A  84      69.235  28.524  57.029  1.00  0.00           H  
ATOM   1259  HH  TYR A  84      68.970  29.106  53.929  1.00  0.00           H  
ATOM   1260  N   ILE A  85      64.560  22.123  57.250  1.00  0.00           N  
ATOM   1261  CA  ILE A  85      63.960  21.013  57.980  1.00  0.00           C  
ATOM   1262  C   ILE A  85      64.746  19.724  57.764  1.00  0.00           C  
ATOM   1263  O   ILE A  85      65.408  19.554  56.741  1.00  0.00           O  
ATOM   1264  CB  ILE A  85      62.496  20.786  57.557  1.00  0.00           C  
ATOM   1265  CG1 ILE A  85      62.401  20.628  56.037  1.00  0.00           C  
ATOM   1266  CG2 ILE A  85      61.623  21.939  58.031  1.00  0.00           C  
ATOM   1267  CD1 ILE A  85      61.374  19.607  55.601  1.00  0.00           C  
ATOM   1268  H   ILE A  85      64.637  22.068  56.274  1.00  0.00           H  
ATOM   1269  HA  ILE A  85      63.976  21.260  59.032  1.00  0.00           H  
ATOM   1270  HB  ILE A  85      62.145  19.882  58.029  1.00  0.00           H  
ATOM   1271 HG12 ILE A  85      62.134  21.576  55.599  1.00  0.00           H  
ATOM   1272 HG13 ILE A  85      63.363  20.318  55.655  1.00  0.00           H  
ATOM   1273 HG21 ILE A  85      60.631  21.829  57.621  1.00  0.00           H  
ATOM   1274 HG22 ILE A  85      61.571  21.929  59.110  1.00  0.00           H  
ATOM   1275 HG23 ILE A  85      62.049  22.873  57.698  1.00  0.00           H  
ATOM   1276 HD11 ILE A  85      60.632  19.487  56.377  1.00  0.00           H  
ATOM   1277 HD12 ILE A  85      60.896  19.943  54.692  1.00  0.00           H  
ATOM   1278 HD13 ILE A  85      61.862  18.660  55.420  1.00  0.00           H  
ATOM   1279  N   ARG A  86      64.665  18.818  58.733  1.00  0.00           N  
ATOM   1280  CA  ARG A  86      65.368  17.544  58.648  1.00  0.00           C  
ATOM   1281  C   ARG A  86      64.382  16.383  58.579  1.00  0.00           C  
ATOM   1282  O   ARG A  86      63.390  16.352  59.308  1.00  0.00           O  
ATOM   1283  CB  ARG A  86      66.295  17.368  59.852  1.00  0.00           C  
ATOM   1284  CG  ARG A  86      67.643  16.758  59.500  1.00  0.00           C  
ATOM   1285  CD  ARG A  86      68.673  17.831  59.183  1.00  0.00           C  
ATOM   1286  NE  ARG A  86      69.224  18.435  60.393  1.00  0.00           N  
ATOM   1287  CZ  ARG A  86      69.975  17.776  61.267  1.00  0.00           C  
ATOM   1288  NH1 ARG A  86      70.266  16.498  61.066  1.00  0.00           N  
ATOM   1289  NH2 ARG A  86      70.439  18.396  62.344  1.00  0.00           N  
ATOM   1290  H   ARG A  86      64.122  19.012  59.525  1.00  0.00           H  
ATOM   1291  HA  ARG A  86      65.961  17.552  57.746  1.00  0.00           H  
ATOM   1292  HB2 ARG A  86      66.470  18.335  60.303  1.00  0.00           H  
ATOM   1293  HB3 ARG A  86      65.812  16.725  60.573  1.00  0.00           H  
ATOM   1294  HG2 ARG A  86      67.994  16.175  60.337  1.00  0.00           H  
ATOM   1295  HG3 ARG A  86      67.522  16.120  58.638  1.00  0.00           H  
ATOM   1296  HD2 ARG A  86      69.477  17.384  58.617  1.00  0.00           H  
ATOM   1297  HD3 ARG A  86      68.202  18.600  58.590  1.00  0.00           H  
ATOM   1298  HE  ARG A  86      69.023  19.379  60.560  1.00  0.00           H  
ATOM   1299 HH11 ARG A  86      69.917  16.030  60.254  1.00  0.00           H  
ATOM   1300 HH12 ARG A  86      70.831  16.004  61.726  1.00  0.00           H  
ATOM   1301 HH21 ARG A  86      70.224  19.359  62.499  1.00  0.00           H  
ATOM   1302 HH22 ARG A  86      71.005  17.898  63.003  1.00  0.00           H  
ATOM   1303  N   VAL A  87      64.659  15.428  57.695  1.00  0.00           N  
ATOM   1304  CA  VAL A  87      63.796  14.266  57.530  1.00  0.00           C  
ATOM   1305  C   VAL A  87      64.577  12.970  57.725  1.00  0.00           C  
ATOM   1306  O   VAL A  87      65.709  12.838  57.257  1.00  0.00           O  
ATOM   1307  CB  VAL A  87      63.135  14.250  56.139  1.00  0.00           C  
ATOM   1308  CG1 VAL A  87      62.100  13.139  56.052  1.00  0.00           C  
ATOM   1309  CG2 VAL A  87      62.508  15.600  55.832  1.00  0.00           C  
ATOM   1310  H   VAL A  87      65.463  15.509  57.142  1.00  0.00           H  
ATOM   1311  HA  VAL A  87      63.016  14.319  58.275  1.00  0.00           H  
ATOM   1312  HB  VAL A  87      63.900  14.055  55.402  1.00  0.00           H  
ATOM   1313 HG11 VAL A  87      62.078  12.593  56.985  1.00  0.00           H  
ATOM   1314 HG12 VAL A  87      61.127  13.569  55.863  1.00  0.00           H  
ATOM   1315 HG13 VAL A  87      62.359  12.466  55.249  1.00  0.00           H  
ATOM   1316 HG21 VAL A  87      62.411  15.718  54.763  1.00  0.00           H  
ATOM   1317 HG22 VAL A  87      61.531  15.656  56.290  1.00  0.00           H  
ATOM   1318 HG23 VAL A  87      63.135  16.387  56.225  1.00  0.00           H  
ATOM   1319  N   LYS A  88      63.966  12.016  58.417  1.00  0.00           N  
ATOM   1320  CA  LYS A  88      64.603  10.729  58.673  1.00  0.00           C  
ATOM   1321  C   LYS A  88      63.558   9.630  58.839  1.00  0.00           C  
ATOM   1322  O   LYS A  88      62.410   9.897  59.193  1.00  0.00           O  
ATOM   1323  CB  LYS A  88      65.477  10.809  59.926  1.00  0.00           C  
ATOM   1324  CG  LYS A  88      64.684  10.808  61.222  1.00  0.00           C  
ATOM   1325  CD  LYS A  88      64.264   9.403  61.618  1.00  0.00           C  
ATOM   1326  CE  LYS A  88      64.739   9.052  63.018  1.00  0.00           C  
ATOM   1327  NZ  LYS A  88      63.819   8.093  63.693  1.00  0.00           N  
ATOM   1328  H   LYS A  88      63.064  12.180  58.765  1.00  0.00           H  
ATOM   1329  HA  LYS A  88      65.226  10.492  57.825  1.00  0.00           H  
ATOM   1330  HB2 LYS A  88      66.147   9.962  59.938  1.00  0.00           H  
ATOM   1331  HB3 LYS A  88      66.060  11.718  59.886  1.00  0.00           H  
ATOM   1332  HG2 LYS A  88      65.297  11.222  62.009  1.00  0.00           H  
ATOM   1333  HG3 LYS A  88      63.801  11.416  61.093  1.00  0.00           H  
ATOM   1334  HD2 LYS A  88      63.185   9.338  61.589  1.00  0.00           H  
ATOM   1335  HD3 LYS A  88      64.688   8.699  60.916  1.00  0.00           H  
ATOM   1336  HE2 LYS A  88      65.720   8.609  62.952  1.00  0.00           H  
ATOM   1337  HE3 LYS A  88      64.792   9.957  63.604  1.00  0.00           H  
ATOM   1338  HZ1 LYS A  88      64.150   7.900  64.660  1.00  0.00           H  
ATOM   1339  HZ2 LYS A  88      63.790   7.196  63.166  1.00  0.00           H  
ATOM   1340  HZ3 LYS A  88      62.859   8.489  63.737  1.00  0.00           H  
ATOM   1341  N   VAL A  89      63.964   8.390  58.582  1.00  0.00           N  
ATOM   1342  CA  VAL A  89      63.066   7.249  58.705  1.00  0.00           C  
ATOM   1343  C   VAL A  89      62.775   6.933  60.168  1.00  0.00           C  
ATOM   1344  O   VAL A  89      63.675   6.567  60.924  1.00  0.00           O  
ATOM   1345  CB  VAL A  89      63.650   5.997  58.027  1.00  0.00           C  
ATOM   1346  CG1 VAL A  89      64.979   5.617  58.662  1.00  0.00           C  
ATOM   1347  CG2 VAL A  89      62.665   4.841  58.101  1.00  0.00           C  
ATOM   1348  H   VAL A  89      64.891   8.240  58.304  1.00  0.00           H  
ATOM   1349  HA  VAL A  89      62.137   7.500  58.211  1.00  0.00           H  
ATOM   1350  HB  VAL A  89      63.826   6.225  56.985  1.00  0.00           H  
ATOM   1351 HG11 VAL A  89      65.574   6.506  58.811  1.00  0.00           H  
ATOM   1352 HG12 VAL A  89      64.800   5.138  59.613  1.00  0.00           H  
ATOM   1353 HG13 VAL A  89      65.508   4.937  58.010  1.00  0.00           H  
ATOM   1354 HG21 VAL A  89      63.087   3.976  57.612  1.00  0.00           H  
ATOM   1355 HG22 VAL A  89      62.462   4.605  59.137  1.00  0.00           H  
ATOM   1356 HG23 VAL A  89      61.744   5.119  57.609  1.00  0.00           H  
ATOM   1357  N   ASP A  90      61.514   7.077  60.560  1.00  0.00           N  
ATOM   1358  CA  ASP A  90      61.105   6.804  61.934  1.00  0.00           C  
ATOM   1359  C   ASP A  90      61.684   5.481  62.421  1.00  0.00           C  
ATOM   1360  O   ASP A  90      61.985   4.593  61.624  1.00  0.00           O  
ATOM   1361  CB  ASP A  90      59.580   6.777  62.038  1.00  0.00           C  
ATOM   1362  CG  ASP A  90      59.101   6.515  63.452  1.00  0.00           C  
ATOM   1363  OD1 ASP A  90      59.319   7.383  64.322  1.00  0.00           O  
ATOM   1364  OD2 ASP A  90      58.508   5.442  63.688  1.00  0.00           O  
ATOM   1365  H   ASP A  90      60.842   7.372  59.910  1.00  0.00           H  
ATOM   1366  HA  ASP A  90      61.485   7.601  62.556  1.00  0.00           H  
ATOM   1367  HB2 ASP A  90      59.185   7.730  61.714  1.00  0.00           H  
ATOM   1368  HB3 ASP A  90      59.196   5.998  61.396  1.00  0.00           H  
ATOM   1369  N   GLY A  91      61.841   5.357  63.736  1.00  0.00           N  
ATOM   1370  CA  GLY A  91      62.385   4.139  64.307  1.00  0.00           C  
ATOM   1371  C   GLY A  91      63.578   4.401  65.203  1.00  0.00           C  
ATOM   1372  O   GLY A  91      63.838   5.534  65.613  1.00  0.00           O  
ATOM   1373  H   GLY A  91      61.582   6.098  64.323  1.00  0.00           H  
ATOM   1374  HA2 GLY A  91      61.614   3.650  64.885  1.00  0.00           H  
ATOM   1375  HA3 GLY A  91      62.689   3.482  63.504  1.00  0.00           H  
ATOM   1376  N   PRO A  92      64.330   3.338  65.522  1.00  0.00           N  
ATOM   1377  CA  PRO A  92      65.514   3.433  66.380  1.00  0.00           C  
ATOM   1378  C   PRO A  92      66.665   4.164  65.698  1.00  0.00           C  
ATOM   1379  O   PRO A  92      67.063   3.815  64.586  1.00  0.00           O  
ATOM   1380  CB  PRO A  92      65.886   1.970  66.636  1.00  0.00           C  
ATOM   1381  CG  PRO A  92      65.333   1.228  65.468  1.00  0.00           C  
ATOM   1382  CD  PRO A  92      64.080   1.958  65.070  1.00  0.00           C  
ATOM   1383  HA  PRO A  92      65.287   3.919  67.318  1.00  0.00           H  
ATOM   1384  HB2 PRO A  92      66.960   1.874  66.693  1.00  0.00           H  
ATOM   1385  HB3 PRO A  92      65.440   1.639  67.561  1.00  0.00           H  
ATOM   1386  HG2 PRO A  92      66.045   1.237  64.657  1.00  0.00           H  
ATOM   1387  HG3 PRO A  92      65.101   0.215  65.754  1.00  0.00           H  
ATOM   1388  HD2 PRO A  92      63.945   1.922  63.998  1.00  0.00           H  
ATOM   1389  HD3 PRO A  92      63.222   1.538  65.573  1.00  0.00           H  
ATOM   1390  N   ARG A  93      67.199   5.178  66.372  1.00  0.00           N  
ATOM   1391  CA  ARG A  93      68.304   5.958  65.830  1.00  0.00           C  
ATOM   1392  C   ARG A  93      69.645   5.397  66.297  1.00  0.00           C  
ATOM   1393  O   ARG A  93      69.735   4.777  67.356  1.00  0.00           O  
ATOM   1394  CB  ARG A  93      68.177   7.423  66.251  1.00  0.00           C  
ATOM   1395  CG  ARG A  93      68.386   8.405  65.112  1.00  0.00           C  
ATOM   1396  CD  ARG A  93      68.503   9.834  65.620  1.00  0.00           C  
ATOM   1397  NE  ARG A  93      69.680  10.022  66.461  1.00  0.00           N  
ATOM   1398  CZ  ARG A  93      69.877  11.092  67.223  1.00  0.00           C  
ATOM   1399  NH1 ARG A  93      68.976  12.065  67.249  1.00  0.00           N  
ATOM   1400  NH2 ARG A  93      70.975  11.191  67.962  1.00  0.00           N  
ATOM   1401  H   ARG A  93      66.839   5.408  67.254  1.00  0.00           H  
ATOM   1402  HA  ARG A  93      68.258   5.898  64.754  1.00  0.00           H  
ATOM   1403  HB2 ARG A  93      67.191   7.585  66.660  1.00  0.00           H  
ATOM   1404  HB3 ARG A  93      68.913   7.630  67.015  1.00  0.00           H  
ATOM   1405  HG2 ARG A  93      69.295   8.147  64.588  1.00  0.00           H  
ATOM   1406  HG3 ARG A  93      67.548   8.339  64.435  1.00  0.00           H  
ATOM   1407  HD2 ARG A  93      68.567  10.499  64.773  1.00  0.00           H  
ATOM   1408  HD3 ARG A  93      67.619  10.069  66.195  1.00  0.00           H  
ATOM   1409  HE  ARG A  93      70.358   9.315  66.458  1.00  0.00           H  
ATOM   1410 HH11 ARG A  93      68.148  11.993  66.694  1.00  0.00           H  
ATOM   1411 HH12 ARG A  93      69.126  12.870  67.825  1.00  0.00           H  
ATOM   1412 HH21 ARG A  93      71.656  10.458  67.945  1.00  0.00           H  
ATOM   1413 HH22 ARG A  93      71.122  11.996  68.535  1.00  0.00           H  
ATOM   1414  N   SER A  94      70.683   5.620  65.497  1.00  0.00           N  
ATOM   1415  CA  SER A  94      72.019   5.133  65.826  1.00  0.00           C  
ATOM   1416  C   SER A  94      72.025   3.614  65.959  1.00  0.00           C  
ATOM   1417  O   SER A  94      71.069   3.003  66.434  1.00  0.00           O  
ATOM   1418  CB  SER A  94      72.512   5.772  67.126  1.00  0.00           C  
ATOM   1419  OG  SER A  94      73.626   6.614  66.889  1.00  0.00           O  
ATOM   1420  H   SER A  94      70.548   6.122  64.667  1.00  0.00           H  
ATOM   1421  HA  SER A  94      72.682   5.417  65.022  1.00  0.00           H  
ATOM   1422  HB2 SER A  94      71.717   6.360  67.559  1.00  0.00           H  
ATOM   1423  HB3 SER A  94      72.803   4.995  67.818  1.00  0.00           H  
ATOM   1424  HG  SER A  94      73.956   6.953  67.726  1.00  0.00           H  
ATOM   1425  N   PRO A  95      73.131   2.989  65.527  1.00  0.00           N  
ATOM   1426  CA  PRO A  95      73.292   1.532  65.587  1.00  0.00           C  
ATOM   1427  C   PRO A  95      73.443   1.024  67.016  1.00  0.00           C  
ATOM   1428  O   PRO A  95      73.892   1.752  67.900  1.00  0.00           O  
ATOM   1429  CB  PRO A  95      74.575   1.283  64.792  1.00  0.00           C  
ATOM   1430  CG  PRO A  95      75.339   2.558  64.897  1.00  0.00           C  
ATOM   1431  CD  PRO A  95      74.310   3.654  64.949  1.00  0.00           C  
ATOM   1432  HA  PRO A  95      72.466   1.022  65.111  1.00  0.00           H  
ATOM   1433  HB2 PRO A  95      75.119   0.459  65.231  1.00  0.00           H  
ATOM   1434  HB3 PRO A  95      74.330   1.055  63.766  1.00  0.00           H  
ATOM   1435  HG2 PRO A  95      75.931   2.559  65.800  1.00  0.00           H  
ATOM   1436  HG3 PRO A  95      75.971   2.679  64.031  1.00  0.00           H  
ATOM   1437  HD2 PRO A  95      74.648   4.459  65.583  1.00  0.00           H  
ATOM   1438  HD3 PRO A  95      74.097   4.018  63.954  1.00  0.00           H  
ATOM   1439  N   SER A  96      73.064  -0.231  67.237  1.00  0.00           N  
ATOM   1440  CA  SER A  96      73.156  -0.836  68.560  1.00  0.00           C  
ATOM   1441  C   SER A  96      74.126  -2.013  68.555  1.00  0.00           C  
ATOM   1442  O   SER A  96      74.344  -2.647  67.522  1.00  0.00           O  
ATOM   1443  CB  SER A  96      71.775  -1.301  69.028  1.00  0.00           C  
ATOM   1444  OG  SER A  96      71.543  -0.934  70.377  1.00  0.00           O  
ATOM   1445  H   SER A  96      72.714  -0.762  66.491  1.00  0.00           H  
ATOM   1446  HA  SER A  96      73.524  -0.084  69.244  1.00  0.00           H  
ATOM   1447  HB2 SER A  96      71.017  -0.848  68.409  1.00  0.00           H  
ATOM   1448  HB3 SER A  96      71.714  -2.376  68.945  1.00  0.00           H  
ATOM   1449  HG  SER A  96      71.969  -1.567  70.960  1.00  0.00           H  
ATOM   1450  N   TYR A  97      74.706  -2.298  69.716  1.00  0.00           N  
ATOM   1451  CA  TYR A  97      75.656  -3.398  69.844  1.00  0.00           C  
ATOM   1452  C   TYR A  97      76.177  -3.503  71.274  1.00  0.00           C  
ATOM   1453  O   TYR A  97      75.947  -2.617  72.096  1.00  0.00           O  
ATOM   1454  CB  TYR A  97      76.825  -3.206  68.877  1.00  0.00           C  
ATOM   1455  CG  TYR A  97      77.162  -4.446  68.079  1.00  0.00           C  
ATOM   1456  CD1 TYR A  97      76.498  -4.735  66.894  1.00  0.00           C  
ATOM   1457  CD2 TYR A  97      78.144  -5.329  68.513  1.00  0.00           C  
ATOM   1458  CE1 TYR A  97      76.802  -5.868  66.163  1.00  0.00           C  
ATOM   1459  CE2 TYR A  97      78.455  -6.463  67.789  1.00  0.00           C  
ATOM   1460  CZ  TYR A  97      77.781  -6.727  66.614  1.00  0.00           C  
ATOM   1461  OH  TYR A  97      78.088  -7.857  65.888  1.00  0.00           O  
ATOM   1462  H   TYR A  97      74.492  -1.758  70.503  1.00  0.00           H  
ATOM   1463  HA  TYR A  97      75.141  -4.312  69.594  1.00  0.00           H  
ATOM   1464  HB2 TYR A  97      76.582  -2.421  68.179  1.00  0.00           H  
ATOM   1465  HB3 TYR A  97      77.705  -2.922  69.437  1.00  0.00           H  
ATOM   1466  HD1 TYR A  97      75.733  -4.059  66.544  1.00  0.00           H  
ATOM   1467  HD2 TYR A  97      78.668  -5.119  69.434  1.00  0.00           H  
ATOM   1468  HE1 TYR A  97      76.275  -6.075  65.243  1.00  0.00           H  
ATOM   1469  HE2 TYR A  97      79.221  -7.137  68.141  1.00  0.00           H  
ATOM   1470  HH  TYR A  97      78.523  -8.494  66.460  1.00  0.00           H  
ATOM   1471  N   GLY A  98      76.881  -4.592  71.563  1.00  0.00           N  
ATOM   1472  CA  GLY A  98      77.424  -4.796  72.893  1.00  0.00           C  
ATOM   1473  C   GLY A  98      78.091  -6.147  73.048  1.00  0.00           C  
ATOM   1474  O   GLY A  98      78.191  -6.910  72.088  1.00  0.00           O  
ATOM   1475  H   GLY A  98      77.031  -5.266  70.867  1.00  0.00           H  
ATOM   1476  HA2 GLY A  98      78.150  -4.022  73.095  1.00  0.00           H  
ATOM   1477  HA3 GLY A  98      76.622  -4.717  73.613  1.00  0.00           H  
ATOM   1478  N   ARG A  99      78.551  -6.443  74.260  1.00  0.00           N  
ATOM   1479  CA  ARG A  99      79.215  -7.711  74.536  1.00  0.00           C  
ATOM   1480  C   ARG A  99      79.270  -7.981  76.037  1.00  0.00           C  
ATOM   1481  O   ARG A  99      79.136  -9.121  76.478  1.00  0.00           O  
ATOM   1482  CB  ARG A  99      80.631  -7.706  73.956  1.00  0.00           C  
ATOM   1483  CG  ARG A  99      81.313  -6.350  74.023  1.00  0.00           C  
ATOM   1484  CD  ARG A  99      81.197  -5.603  72.703  1.00  0.00           C  
ATOM   1485  NE  ARG A  99      82.366  -4.767  72.444  1.00  0.00           N  
ATOM   1486  CZ  ARG A  99      82.466  -3.944  71.405  1.00  0.00           C  
ATOM   1487  NH1 ARG A  99      81.471  -3.849  70.533  1.00  0.00           N  
ATOM   1488  NH2 ARG A  99      83.560  -3.215  71.237  1.00  0.00           N  
ATOM   1489  H   ARG A  99      78.442  -5.792  74.985  1.00  0.00           H  
ATOM   1490  HA  ARG A  99      78.644  -8.495  74.062  1.00  0.00           H  
ATOM   1491  HB2 ARG A  99      81.234  -8.415  74.503  1.00  0.00           H  
ATOM   1492  HB3 ARG A  99      80.584  -8.011  72.921  1.00  0.00           H  
ATOM   1493  HG2 ARG A  99      80.847  -5.761  74.799  1.00  0.00           H  
ATOM   1494  HG3 ARG A  99      82.357  -6.494  74.255  1.00  0.00           H  
ATOM   1495  HD2 ARG A  99      81.096  -6.322  71.905  1.00  0.00           H  
ATOM   1496  HD3 ARG A  99      80.318  -4.977  72.736  1.00  0.00           H  
ATOM   1497  HE  ARG A  99      83.113  -4.821  73.075  1.00  0.00           H  
ATOM   1498 HH11 ARG A  99      80.644  -4.397  70.659  1.00  0.00           H  
ATOM   1499 HH12 ARG A  99      81.547  -3.228  69.752  1.00  0.00           H  
ATOM   1500 HH21 ARG A  99      84.313  -3.284  71.892  1.00  0.00           H  
ATOM   1501 HH22 ARG A  99      83.634  -2.597  70.455  1.00  0.00           H  
ATOM   1502  N   SER A 100      79.469  -6.922  76.815  1.00  0.00           N  
ATOM   1503  CA  SER A 100      79.545  -7.045  78.267  1.00  0.00           C  
ATOM   1504  C   SER A 100      80.943  -7.476  78.703  1.00  0.00           C  
ATOM   1505  O   SER A 100      81.505  -6.930  79.652  1.00  0.00           O  
ATOM   1506  CB  SER A 100      78.508  -8.051  78.770  1.00  0.00           C  
ATOM   1507  OG  SER A 100      77.970  -7.647  80.018  1.00  0.00           O  
ATOM   1508  H   SER A 100      79.569  -6.038  76.404  1.00  0.00           H  
ATOM   1509  HA  SER A 100      79.331  -6.076  78.694  1.00  0.00           H  
ATOM   1510  HB2 SER A 100      77.705  -8.126  78.053  1.00  0.00           H  
ATOM   1511  HB3 SER A 100      78.976  -9.018  78.890  1.00  0.00           H  
ATOM   1512  HG  SER A 100      77.904  -6.689  80.043  1.00  0.00           H  
ATOM   1513  N   ARG A 101      81.497  -8.460  78.001  1.00  0.00           N  
ATOM   1514  CA  ARG A 101      82.828  -8.967  78.315  1.00  0.00           C  
ATOM   1515  C   ARG A 101      83.802  -8.675  77.179  1.00  0.00           C  
ATOM   1516  O   ARG A 101      83.465  -8.824  76.004  1.00  0.00           O  
ATOM   1517  CB  ARG A 101      82.773 -10.473  78.581  1.00  0.00           C  
ATOM   1518  CG  ARG A 101      83.612 -10.913  79.769  1.00  0.00           C  
ATOM   1519  CD  ARG A 101      83.402 -12.384  80.088  1.00  0.00           C  
ATOM   1520  NE  ARG A 101      83.656 -12.683  81.493  1.00  0.00           N  
ATOM   1521  CZ  ARG A 101      82.779 -12.452  82.464  1.00  0.00           C  
ATOM   1522  NH1 ARG A 101      81.596 -11.925  82.183  1.00  0.00           N  
ATOM   1523  NH2 ARG A 101      83.085 -12.752  83.721  1.00  0.00           N  
ATOM   1524  H   ARG A 101      80.998  -8.856  77.255  1.00  0.00           H  
ATOM   1525  HA  ARG A 101      83.171  -8.466  79.207  1.00  0.00           H  
ATOM   1526  HB2 ARG A 101      81.748 -10.756  78.768  1.00  0.00           H  
ATOM   1527  HB3 ARG A 101      83.128 -10.994  77.705  1.00  0.00           H  
ATOM   1528  HG2 ARG A 101      84.655 -10.751  79.541  1.00  0.00           H  
ATOM   1529  HG3 ARG A 101      83.335 -10.323  80.632  1.00  0.00           H  
ATOM   1530  HD2 ARG A 101      82.380 -12.647  79.853  1.00  0.00           H  
ATOM   1531  HD3 ARG A 101      84.072 -12.970  79.477  1.00  0.00           H  
ATOM   1532  HE  ARG A 101      84.525 -13.074  81.724  1.00  0.00           H  
ATOM   1533 HH11 ARG A 101      81.363 -11.700  81.237  1.00  0.00           H  
ATOM   1534 HH12 ARG A 101      80.938 -11.754  82.916  1.00  0.00           H  
ATOM   1535 HH21 ARG A 101      83.976 -13.150  83.937  1.00  0.00           H  
ATOM   1536 HH22 ARG A 101      82.425 -12.579  84.451  1.00  0.00           H  
ATOM   1537  N   SER A 102      85.013  -8.259  77.536  1.00  0.00           N  
ATOM   1538  CA  SER A 102      86.035  -7.941  76.546  1.00  0.00           C  
ATOM   1539  C   SER A 102      86.377  -9.168  75.707  1.00  0.00           C  
ATOM   1540  O   SER A 102      86.590 -10.258  76.238  1.00  0.00           O  
ATOM   1541  CB  SER A 102      87.294  -7.412  77.235  1.00  0.00           C  
ATOM   1542  OG  SER A 102      87.177  -6.029  77.520  1.00  0.00           O  
ATOM   1543  H   SER A 102      85.221  -8.160  78.489  1.00  0.00           H  
ATOM   1544  HA  SER A 102      85.641  -7.175  75.897  1.00  0.00           H  
ATOM   1545  HB2 SER A 102      87.448  -7.946  78.160  1.00  0.00           H  
ATOM   1546  HB3 SER A 102      88.146  -7.563  76.587  1.00  0.00           H  
ATOM   1547  HG  SER A 102      86.985  -5.550  76.712  1.00  0.00           H  
ATOM   1548  N   SER A 103      86.430  -8.981  74.392  1.00  0.00           N  
ATOM   1549  CA  SER A 103      86.744 -10.073  73.478  1.00  0.00           C  
ATOM   1550  C   SER A 103      88.133  -9.893  72.872  1.00  0.00           C  
ATOM   1551  O   SER A 103      88.395  -8.915  72.174  1.00  0.00           O  
ATOM   1552  CB  SER A 103      85.696 -10.151  72.365  1.00  0.00           C  
ATOM   1553  OG  SER A 103      85.167 -11.461  72.253  1.00  0.00           O  
ATOM   1554  H   SER A 103      86.252  -8.089  74.029  1.00  0.00           H  
ATOM   1555  HA  SER A 103      86.725 -10.994  74.041  1.00  0.00           H  
ATOM   1556  HB2 SER A 103      84.890  -9.468  72.585  1.00  0.00           H  
ATOM   1557  HB3 SER A 103      86.152  -9.879  71.424  1.00  0.00           H  
ATOM   1558  HG  SER A 103      84.966 -11.801  73.128  1.00  0.00           H  
ATOM   1559  N   GLY A 104      89.018 -10.847  73.145  1.00  0.00           N  
ATOM   1560  CA  GLY A 104      90.369 -10.775  72.621  1.00  0.00           C  
ATOM   1561  C   GLY A 104      91.067 -12.121  72.632  1.00  0.00           C  
ATOM   1562  O   GLY A 104      91.846 -12.433  73.533  1.00  0.00           O  
ATOM   1563  H   GLY A 104      88.752 -11.603  73.709  1.00  0.00           H  
ATOM   1564  HA2 GLY A 104      90.331 -10.411  71.605  1.00  0.00           H  
ATOM   1565  HA3 GLY A 104      90.940 -10.082  73.221  1.00  0.00           H  
ATOM   1566  N   PRO A 105      90.788 -12.946  71.613  1.00  0.00           N  
ATOM   1567  CA  PRO A 105      91.384 -14.279  71.488  1.00  0.00           C  
ATOM   1568  C   PRO A 105      92.872 -14.221  71.160  1.00  0.00           C  
ATOM   1569  O   PRO A 105      93.470 -13.147  71.139  1.00  0.00           O  
ATOM   1570  CB  PRO A 105      90.605 -14.908  70.328  1.00  0.00           C  
ATOM   1571  CG  PRO A 105      90.127 -13.750  69.522  1.00  0.00           C  
ATOM   1572  CD  PRO A 105      89.869 -12.641  70.504  1.00  0.00           C  
ATOM   1573  HA  PRO A 105      91.235 -14.866  72.382  1.00  0.00           H  
ATOM   1574  HB2 PRO A 105      91.262 -15.546  69.754  1.00  0.00           H  
ATOM   1575  HB3 PRO A 105      89.781 -15.488  70.715  1.00  0.00           H  
ATOM   1576  HG2 PRO A 105      90.886 -13.456  68.813  1.00  0.00           H  
ATOM   1577  HG3 PRO A 105      89.214 -14.014  69.008  1.00  0.00           H  
ATOM   1578  HD2 PRO A 105      90.103 -11.684  70.061  1.00  0.00           H  
ATOM   1579  HD3 PRO A 105      88.842 -12.663  70.836  1.00  0.00           H  
ATOM   1580  N   SER A 106      93.463 -15.384  70.907  1.00  0.00           N  
ATOM   1581  CA  SER A 106      94.882 -15.466  70.584  1.00  0.00           C  
ATOM   1582  C   SER A 106      95.119 -15.198  69.101  1.00  0.00           C  
ATOM   1583  O   SER A 106      95.640 -14.147  68.724  1.00  0.00           O  
ATOM   1584  CB  SER A 106      95.434 -16.842  70.959  1.00  0.00           C  
ATOM   1585  OG  SER A 106      94.723 -17.875  70.297  1.00  0.00           O  
ATOM   1586  H   SER A 106      92.932 -16.208  70.939  1.00  0.00           H  
ATOM   1587  HA  SER A 106      95.397 -14.712  71.160  1.00  0.00           H  
ATOM   1588  HB2 SER A 106      96.474 -16.900  70.675  1.00  0.00           H  
ATOM   1589  HB3 SER A 106      95.342 -16.986  72.026  1.00  0.00           H  
ATOM   1590  HG  SER A 106      93.926 -18.081  70.788  1.00  0.00           H  
ATOM   1591  N   SER A 107      94.733 -16.156  68.263  1.00  0.00           N  
ATOM   1592  CA  SER A 107      94.905 -16.025  66.821  1.00  0.00           C  
ATOM   1593  C   SER A 107      93.677 -15.386  66.182  1.00  0.00           C  
ATOM   1594  O   SER A 107      92.618 -15.290  66.804  1.00  0.00           O  
ATOM   1595  CB  SER A 107      95.168 -17.394  66.192  1.00  0.00           C  
ATOM   1596  OG  SER A 107      94.092 -18.283  66.438  1.00  0.00           O  
ATOM   1597  H   SER A 107      94.324 -16.970  68.625  1.00  0.00           H  
ATOM   1598  HA  SER A 107      95.760 -15.388  66.646  1.00  0.00           H  
ATOM   1599  HB2 SER A 107      95.288 -17.280  65.126  1.00  0.00           H  
ATOM   1600  HB3 SER A 107      96.070 -17.814  66.614  1.00  0.00           H  
ATOM   1601  HG  SER A 107      93.270 -17.789  66.475  1.00  0.00           H  
ATOM   1602  N   GLY A 108      93.823 -14.950  64.935  1.00  0.00           N  
ATOM   1603  CA  GLY A 108      92.719 -14.326  64.231  1.00  0.00           C  
ATOM   1604  C   GLY A 108      92.105 -15.241  63.190  1.00  0.00           C  
ATOM   1605  O   GLY A 108      92.599 -16.342  62.952  1.00  0.00           O  
ATOM   1606  H   GLY A 108      94.691 -15.054  64.488  1.00  0.00           H  
ATOM   1607  HA2 GLY A 108      91.959 -14.052  64.949  1.00  0.00           H  
ATOM   1608  HA3 GLY A 108      93.077 -13.433  63.743  1.00  0.00           H  
TER    1609      GLY A 108                                                      
END
MOLECULE T0487_26_96.pdb
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
END
