
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 ( 1389),  selected   95 , name 1ufw_A
# Molecule2: number of CA atoms   71 (  558),  selected   71 , name T0487_26_96.pdb
# PARAMETERS: 1ufw_A.T0487_26_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    S     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    F    10_A      -       -           -
LGA    Q    11_A      -       -           -
LGA    G    12_A      -       -           -
LGA    P    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    D    15_A      P      26          3.033
LGA    A    16_A      W      27          2.646
LGA    T    17_A      R      28          2.221
LGA    V    18_A      L      29          1.342
LGA    V    19_A      E      30          1.219
LGA    V    20_A      V      31          1.211
LGA    N    21_A      V      32          1.253
LGA    L    22_A      L      33          0.466
LGA    Q    23_A      D      34          1.923
LGA    S    24_A      P      35          1.037
LGA    P    25_A      P      36          1.190
LGA    T    26_A      P      37          2.390
LGA    L    27_A      G      38          2.870
LGA    E    28_A      R      39          2.966
LGA    -       -      E      40           -
LGA    E    29_A      E      41          4.490
LGA    K    30_A      -       -           -
LGA    N    31_A      -       -           -
LGA    E    32_A      -       -           -
LGA    F    33_A      V      42          1.074
LGA    P    34_A      Y      43          3.778
LGA    E    35_A      P      44          1.579
LGA    D    36_A      -       -           -
LGA    L    37_A      L      45          1.904
LGA    R    38_A      L      46          2.962
LGA    T    39_A      A      47          2.851
LGA    E    40_A      Q      48          2.188
LGA    L    41_A      V      49          2.174
LGA    M    42_A      A      50          2.653
LGA    Q    43_A      R      51          2.727
LGA    T    44_A      R      52          2.513
LGA    L    45_A      A      53          2.104
LGA    G    46_A      G      54          3.259
LGA    S    47_A      -       -           -
LGA    Y    48_A      -       -           -
LGA    G    49_A      G      55          0.915
LGA    T    50_A      V      56          1.077
LGA    I    51_A      T      57          2.462
LGA    V    52_A      -       -           -
LGA    L    53_A      V      58          4.513
LGA    V    54_A      R      59          2.878
LGA    R    55_A      M      60          0.988
LGA    I    56_A      G      61          2.257
LGA    N    57_A      D      62          2.663
LGA    Q    58_A      -       -           -
LGA    G    59_A      -       -           -
LGA    Q    60_A      -       -           -
LGA    M    61_A      -       -           -
LGA    L    62_A      G      63          2.151
LGA    V    63_A      L      64          1.162
LGA    T    64_A      A      65          1.739
LGA    F    65_A      S      66          1.783
LGA    A    66_A      W      67          1.842
LGA    D    67_A      S      68          2.012
LGA    S    68_A      P      69          1.628
LGA    H    69_A      P      70          4.044
LGA    S    70_A      E      71          4.136
LGA    A    71_A      V      72          4.926
LGA    L    72_A      L      73          4.962
LGA    S    73_A      -       -           -
LGA    V    74_A      V      74          1.825
LGA    L    75_A      L      75          2.222
LGA    D    76_A      -       -           -
LGA    V    77_A      -       -           -
LGA    D    78_A      E      76          0.644
LGA    G    79_A      -       -           -
LGA    M    80_A      G      77          1.557
LGA    K    81_A      T      78          0.979
LGA    V    82_A      L      79          0.947
LGA    K    83_A      A      80          1.393
LGA    -       -      R      81           -
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    -       -      Q      84           -
LGA    G    84_A      T      85          2.249
LGA    R    85_A      Y      86          0.355
LGA    A    86_A      A      87          1.173
LGA    V    87_A      Y      88          0.643
LGA    K    88_A      R      89          1.465
LGA    I    89_A      L      90          0.919
LGA    S    90_A      Y      91          0.846
LGA    G    91_A      P      92          2.077
LGA    P    92_A      K      93          1.686
LGA    S    93_A      G      94          4.080
LGA    S    94_A      R      95           -
LGA    G    95_A      R      96           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   71    5.0     64    2.39    17.19     61.936     2.574

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.530149 * X  +  -0.243677 * Y  +  -0.812135 * Z  +  58.865829
  Y_new =   0.432990 * X  +  -0.901316 * Y  +  -0.012213 * Z  +  16.060600
  Z_new =  -0.729014 * X  +  -0.358121 * Y  +   0.583342 * Z  +  55.424034 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.550586    2.591006  [ DEG:   -31.5463    148.4537 ]
  Theta =   0.816881    2.324712  [ DEG:    46.8038    133.1962 ]
  Phi   =   2.456733   -0.684860  [ DEG:   140.7604    -39.2396 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ufw_A                                        
REMARK     2: T0487_26_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ufw_A.T0487_26_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   71   5.0   64   2.39   17.19  61.936
REMARK  ---------------------------------------------------------- 
MOLECULE 1ufw_A
HEADER    RNA BINDING PROTEIN                     10-JUN-03   1UFW              
TITLE     SOLUTION STRUCTURE OF RNP DOMAIN IN SYNAPTOJANIN 2                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SYNAPTOJANIN 2;                                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RNP DOMAIN;                                                
COMPND   5 EC: 3.1.3.36;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA HG01551;                                           
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P021015-22;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, RNP DOMAIN, SYNAPTOJANIN 2, STRUCTURAL GENOMICS, RIKEN           
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    F.HE,Y.MUTO,R.USHIKOSHI,M.SHIROUZU,T.TERADA,T.KIGAWA,                 
AUTHOR   2 M.INOUE,T.YABUKI,M.AOKI,E.SEKI,T.MATSUDA,H.HIROTA,M.YOSHIDA,         
AUTHOR   3 N.KOBAYASHI,A.TANAKA,T.OSANAI,Y.MATSUO,O.OHARA,T.NAGASE,             
AUTHOR   4 R.KIKUNO,M.NAKAYAMA,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   5 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   10-DEC-03 1UFW    0                                                
JRNL        AUTH   F.HE,Y.MUTO,R.USHIKOSHI,M.SHIROUZU,T.TERADA,                 
JRNL        AUTH 2 T.KIGAWA,M.INOUE,T.YABUKI,M.AOKI,E.SEKI,T.MATSUDA,           
JRNL        AUTH 3 H.HIROTA,M.YOSHIDA,N.KOBAYASHI,A.TANAKA,T.OSANAI,            
JRNL        AUTH 4 Y.MATSUO,O.OHARA,T.NAGASE,R.KIKUNO,M.NAKAYAMA,               
JRNL        AUTH 5 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF RNP DOMAIN IN SYNAPTOJANIN 2           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1UFW A    8    89  UNP    O15056   SYNJ2_HUMAN    829    910             
SEQRES   1 A   95  GLY SER SER GLY SER SER GLY SER SER PHE GLN GLY PRO          
SEQRES   2 A   95  LEU ASP ALA THR VAL VAL VAL ASN LEU GLN SER PRO THR          
SEQRES   3 A   95  LEU GLU GLU LYS ASN GLU PHE PRO GLU ASP LEU ARG THR          
SEQRES   4 A   95  GLU LEU MET GLN THR LEU GLY SER TYR GLY THR ILE VAL          
SEQRES   5 A   95  LEU VAL ARG ILE ASN GLN GLY GLN MET LEU VAL THR PHE          
SEQRES   6 A   95  ALA ASP SER HIS SER ALA LEU SER VAL LEU ASP VAL ASP          
SEQRES   7 A   95  GLY MET LYS VAL LYS GLY ARG ALA VAL LYS ILE SER GLY          
SEQRES   8 A   95  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      85.789   0.617  43.738  1.00  0.00           N  
ATOM      2  CA  GLY A   1      84.546   1.229  44.175  1.00  0.00           C  
ATOM      3  C   GLY A   1      83.563   0.170  44.679  1.00  0.00           C  
ATOM      4  O   GLY A   1      83.931  -0.989  44.859  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      84.749   1.949  44.967  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      84.100   1.782  43.349  1.00  0.00           H  
ATOM      7  H1  GLY A   1      86.205  -0.012  44.396  1.00  0.00           H  
ATOM      8  N   SER A   2      82.330   0.609  44.892  1.00  0.00           N  
ATOM      9  CA  SER A   2      81.290  -0.286  45.372  1.00  0.00           C  
ATOM     10  C   SER A   2      79.990  -0.036  44.606  1.00  0.00           C  
ATOM     11  O   SER A   2      79.100   0.656  45.097  1.00  0.00           O  
ATOM     12  CB  SER A   2      81.064  -0.111  46.875  1.00  0.00           C  
ATOM     13  OG  SER A   2      80.661   1.217  47.203  1.00  0.00           O  
ATOM     14  H   SER A   2      82.039   1.553  44.743  1.00  0.00           H  
ATOM     15  HA  SER A   2      81.662  -1.292  45.176  1.00  0.00           H  
ATOM     16  HB2 SER A   2      80.302  -0.814  47.211  1.00  0.00           H  
ATOM     17  HB3 SER A   2      81.980  -0.354  47.411  1.00  0.00           H  
ATOM     18  HG  SER A   2      80.907   1.425  48.149  1.00  0.00           H  
ATOM     19  N   SER A   3      79.922  -0.613  43.415  1.00  0.00           N  
ATOM     20  CA  SER A   3      78.745  -0.461  42.577  1.00  0.00           C  
ATOM     21  C   SER A   3      77.765  -1.607  42.837  1.00  0.00           C  
ATOM     22  O   SER A   3      76.621  -1.373  43.225  1.00  0.00           O  
ATOM     23  CB  SER A   3      79.126  -0.416  41.095  1.00  0.00           C  
ATOM     24  OG  SER A   3      79.956  -1.514  40.724  1.00  0.00           O  
ATOM     25  H   SER A   3      80.650  -1.174  43.023  1.00  0.00           H  
ATOM     26  HA  SER A   3      78.305   0.492  42.867  1.00  0.00           H  
ATOM     27  HB2 SER A   3      78.221  -0.424  40.488  1.00  0.00           H  
ATOM     28  HB3 SER A   3      79.644   0.519  40.884  1.00  0.00           H  
ATOM     29  HG  SER A   3      80.394  -1.328  39.845  1.00  0.00           H  
ATOM     30  N   GLY A   4      78.250  -2.819  42.616  1.00  0.00           N  
ATOM     31  CA  GLY A   4      77.430  -4.002  42.822  1.00  0.00           C  
ATOM     32  C   GLY A   4      76.833  -4.017  44.231  1.00  0.00           C  
ATOM     33  O   GLY A   4      75.622  -3.889  44.397  1.00  0.00           O  
ATOM     34  H   GLY A   4      79.181  -3.000  42.302  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      76.630  -4.027  42.084  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      78.033  -4.898  42.670  1.00  0.00           H  
ATOM     37  N   SER A   5      77.712  -4.172  45.210  1.00  0.00           N  
ATOM     38  CA  SER A   5      77.288  -4.205  46.599  1.00  0.00           C  
ATOM     39  C   SER A   5      76.220  -3.137  46.846  1.00  0.00           C  
ATOM     40  O   SER A   5      75.115  -3.449  47.285  1.00  0.00           O  
ATOM     41  CB  SER A   5      78.474  -3.997  47.543  1.00  0.00           C  
ATOM     42  OG  SER A   5      78.505  -4.968  48.585  1.00  0.00           O  
ATOM     43  H   SER A   5      78.697  -4.275  45.067  1.00  0.00           H  
ATOM     44  HA  SER A   5      76.874  -5.202  46.751  1.00  0.00           H  
ATOM     45  HB2 SER A   5      79.403  -4.046  46.975  1.00  0.00           H  
ATOM     46  HB3 SER A   5      78.420  -2.999  47.979  1.00  0.00           H  
ATOM     47  HG  SER A   5      79.113  -5.720  48.334  1.00  0.00           H  
ATOM     48  N   SER A   6      76.588  -1.899  46.552  1.00  0.00           N  
ATOM     49  CA  SER A   6      75.676  -0.783  46.735  1.00  0.00           C  
ATOM     50  C   SER A   6      74.321  -1.105  46.101  1.00  0.00           C  
ATOM     51  O   SER A   6      73.301  -1.131  46.787  1.00  0.00           O  
ATOM     52  CB  SER A   6      76.251   0.503  46.138  1.00  0.00           C  
ATOM     53  OG  SER A   6      77.235   1.091  46.984  1.00  0.00           O  
ATOM     54  H   SER A   6      77.490  -1.653  46.196  1.00  0.00           H  
ATOM     55  HA  SER A   6      75.574  -0.668  47.815  1.00  0.00           H  
ATOM     56  HB2 SER A   6      76.692   0.285  45.166  1.00  0.00           H  
ATOM     57  HB3 SER A   6      75.444   1.216  45.969  1.00  0.00           H  
ATOM     58  HG  SER A   6      77.370   0.526  47.797  1.00  0.00           H  
ATOM     59  N   GLY A   7      74.357  -1.341  44.797  1.00  0.00           N  
ATOM     60  CA  GLY A   7      73.145  -1.660  44.062  1.00  0.00           C  
ATOM     61  C   GLY A   7      72.220  -2.555  44.890  1.00  0.00           C  
ATOM     62  O   GLY A   7      71.109  -2.156  45.233  1.00  0.00           O  
ATOM     63  H   GLY A   7      75.191  -1.318  44.247  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      72.624  -0.740  43.796  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      73.402  -2.162  43.129  1.00  0.00           H  
ATOM     66  N   SER A   8      72.714  -3.748  45.186  1.00  0.00           N  
ATOM     67  CA  SER A   8      71.946  -4.703  45.967  1.00  0.00           C  
ATOM     68  C   SER A   8      72.063  -4.375  47.457  1.00  0.00           C  
ATOM     69  O   SER A   8      72.802  -5.036  48.186  1.00  0.00           O  
ATOM     70  CB  SER A   8      72.413  -6.135  45.701  1.00  0.00           C  
ATOM     71  OG  SER A   8      73.618  -6.442  46.397  1.00  0.00           O  
ATOM     72  H   SER A   8      73.619  -4.064  44.903  1.00  0.00           H  
ATOM     73  HA  SER A   8      70.916  -4.589  45.631  1.00  0.00           H  
ATOM     74  HB2 SER A   8      71.633  -6.834  46.002  1.00  0.00           H  
ATOM     75  HB3 SER A   8      72.568  -6.273  44.631  1.00  0.00           H  
ATOM     76  HG  SER A   8      74.054  -5.600  46.714  1.00  0.00           H  
ATOM     77  N   SER A   9      71.325  -3.354  47.867  1.00  0.00           N  
ATOM     78  CA  SER A   9      71.337  -2.931  49.256  1.00  0.00           C  
ATOM     79  C   SER A   9      70.161  -3.559  50.006  1.00  0.00           C  
ATOM     80  O   SER A   9      70.354  -4.246  51.007  1.00  0.00           O  
ATOM     81  CB  SER A   9      71.283  -1.406  49.367  1.00  0.00           C  
ATOM     82  OG  SER A   9      71.917  -0.935  50.553  1.00  0.00           O  
ATOM     83  H   SER A   9      70.726  -2.822  47.267  1.00  0.00           H  
ATOM     84  HA  SER A   9      72.284  -3.290  49.659  1.00  0.00           H  
ATOM     85  HB2 SER A   9      71.767  -0.961  48.497  1.00  0.00           H  
ATOM     86  HB3 SER A   9      70.245  -1.078  49.357  1.00  0.00           H  
ATOM     87  HG  SER A   9      71.662   0.018  50.723  1.00  0.00           H  
ATOM     88  N   PHE A  10      68.967  -3.302  49.491  1.00  0.00           N  
ATOM     89  CA  PHE A  10      67.760  -3.834  50.099  1.00  0.00           C  
ATOM     90  C   PHE A  10      67.779  -3.642  51.616  1.00  0.00           C  
ATOM     91  O   PHE A  10      68.337  -4.463  52.342  1.00  0.00           O  
ATOM     92  CB  PHE A  10      67.725  -5.331  49.786  1.00  0.00           C  
ATOM     93  CG  PHE A  10      66.436  -5.794  49.103  1.00  0.00           C  
ATOM     94  CD1 PHE A  10      66.213  -5.492  47.796  1.00  0.00           C  
ATOM     95  CD2 PHE A  10      65.514  -6.508  49.802  1.00  0.00           C  
ATOM     96  CE1 PHE A  10      65.017  -5.921  47.160  1.00  0.00           C  
ATOM     97  CE2 PHE A  10      64.318  -6.938  49.167  1.00  0.00           C  
ATOM     98  CZ  PHE A  10      64.095  -6.635  47.860  1.00  0.00           C  
ATOM     99  H   PHE A  10      68.818  -2.742  48.675  1.00  0.00           H  
ATOM    100  HA  PHE A  10      66.917  -3.287  49.676  1.00  0.00           H  
ATOM    101  HB2 PHE A  10      68.572  -5.579  49.147  1.00  0.00           H  
ATOM    102  HB3 PHE A  10      67.851  -5.888  50.715  1.00  0.00           H  
ATOM    103  HD1 PHE A  10      66.953  -4.919  47.234  1.00  0.00           H  
ATOM    104  HD2 PHE A  10      65.692  -6.751  50.849  1.00  0.00           H  
ATOM    105  HE1 PHE A  10      64.840  -5.679  46.113  1.00  0.00           H  
ATOM    106  HE2 PHE A  10      63.578  -7.510  49.728  1.00  0.00           H  
ATOM    107  HZ  PHE A  10      63.177  -6.965  47.373  1.00  0.00           H  
ATOM    108  N   GLN A  11      67.163  -2.552  52.050  1.00  0.00           N  
ATOM    109  CA  GLN A  11      67.102  -2.241  53.469  1.00  0.00           C  
ATOM    110  C   GLN A  11      66.171  -1.052  53.713  1.00  0.00           C  
ATOM    111  O   GLN A  11      66.512   0.085  53.388  1.00  0.00           O  
ATOM    112  CB  GLN A  11      68.498  -1.969  54.030  1.00  0.00           C  
ATOM    113  CG  GLN A  11      68.905  -3.045  55.039  1.00  0.00           C  
ATOM    114  CD  GLN A  11      70.007  -2.536  55.971  1.00  0.00           C  
ATOM    115  OE1 GLN A  11      70.285  -1.352  56.056  1.00  0.00           O  
ATOM    116  NE2 GLN A  11      70.617  -3.495  56.661  1.00  0.00           N  
ATOM    117  H   GLN A  11      66.711  -1.889  51.453  1.00  0.00           H  
ATOM    118  HA  GLN A  11      66.694  -3.134  53.944  1.00  0.00           H  
ATOM    119  HB2 GLN A  11      69.223  -1.938  53.216  1.00  0.00           H  
ATOM    120  HB3 GLN A  11      68.517  -0.990  54.510  1.00  0.00           H  
ATOM    121  HG2 GLN A  11      68.036  -3.343  55.627  1.00  0.00           H  
ATOM    122  HG3 GLN A  11      69.251  -3.933  54.510  1.00  0.00           H  
ATOM    123 HE21 GLN A  11      70.341  -4.449  56.544  1.00  0.00           H  
ATOM    124 HE22 GLN A  11      71.352  -3.262  57.297  1.00  0.00           H  
ATOM    125  N   GLY A  12      65.014  -1.355  54.281  1.00  0.00           N  
ATOM    126  CA  GLY A  12      64.031  -0.325  54.572  1.00  0.00           C  
ATOM    127  C   GLY A  12      62.709  -0.943  55.032  1.00  0.00           C  
ATOM    128  O   GLY A  12      62.365  -2.054  54.631  1.00  0.00           O  
ATOM    129  H   GLY A  12      64.743  -2.282  54.542  1.00  0.00           H  
ATOM    130  HA2 GLY A  12      64.414   0.340  55.345  1.00  0.00           H  
ATOM    131  HA3 GLY A  12      63.862   0.283  53.683  1.00  0.00           H  
ATOM    132  N   PRO A  13      61.985  -0.176  55.892  1.00  0.00           N  
ATOM    133  CA  PRO A  13      60.709  -0.637  56.411  1.00  0.00           C  
ATOM    134  C   PRO A  13      59.615  -0.537  55.346  1.00  0.00           C  
ATOM    135  O   PRO A  13      59.479   0.491  54.684  1.00  0.00           O  
ATOM    136  CB  PRO A  13      60.438   0.240  57.623  1.00  0.00           C  
ATOM    137  CG  PRO A  13      61.336   1.456  57.467  1.00  0.00           C  
ATOM    138  CD  PRO A  13      62.361   1.144  56.389  1.00  0.00           C  
ATOM    139  HA  PRO A  13      60.763  -1.604  56.658  1.00  0.00           H  
ATOM    140  HB2 PRO A  13      59.389   0.531  57.669  1.00  0.00           H  
ATOM    141  HB3 PRO A  13      60.661  -0.293  58.548  1.00  0.00           H  
ATOM    142  HG2 PRO A  13      60.747   2.332  57.191  1.00  0.00           H  
ATOM    143  HG3 PRO A  13      61.831   1.690  58.410  1.00  0.00           H  
ATOM    144  HD2 PRO A  13      62.338   1.888  55.594  1.00  0.00           H  
ATOM    145  HD3 PRO A  13      63.373   1.141  56.794  1.00  0.00           H  
ATOM    146  N   LEU A  14      58.862  -1.619  55.214  1.00  0.00           N  
ATOM    147  CA  LEU A  14      57.784  -1.666  54.240  1.00  0.00           C  
ATOM    148  C   LEU A  14      56.866  -0.460  54.443  1.00  0.00           C  
ATOM    149  O   LEU A  14      56.177  -0.036  53.516  1.00  0.00           O  
ATOM    150  CB  LEU A  14      57.057  -3.011  54.310  1.00  0.00           C  
ATOM    151  CG  LEU A  14      56.495  -3.398  55.679  1.00  0.00           C  
ATOM    152  CD1 LEU A  14      55.095  -2.817  55.883  1.00  0.00           C  
ATOM    153  CD2 LEU A  14      56.519  -4.916  55.872  1.00  0.00           C  
ATOM    154  H   LEU A  14      58.978  -2.451  55.757  1.00  0.00           H  
ATOM    155  HA  LEU A  14      58.235  -1.596  53.250  1.00  0.00           H  
ATOM    156  HB2 LEU A  14      56.236  -2.996  53.594  1.00  0.00           H  
ATOM    157  HB3 LEU A  14      57.747  -3.792  53.989  1.00  0.00           H  
ATOM    158  HG  LEU A  14      57.138  -2.967  56.448  1.00  0.00           H  
ATOM    159 HD11 LEU A  14      54.895  -2.073  55.112  1.00  0.00           H  
ATOM    160 HD12 LEU A  14      54.356  -3.615  55.817  1.00  0.00           H  
ATOM    161 HD13 LEU A  14      55.036  -2.347  56.865  1.00  0.00           H  
ATOM    162 HD21 LEU A  14      56.584  -5.147  56.936  1.00  0.00           H  
ATOM    163 HD22 LEU A  14      55.606  -5.349  55.463  1.00  0.00           H  
ATOM    164 HD23 LEU A  14      57.382  -5.335  55.356  1.00  0.00           H  
ATOM    165  N   ASP A  15      56.887   0.061  55.661  1.00  0.00           N  
ATOM    166  CA  ASP A  15      56.064   1.211  55.997  1.00  0.00           C  
ATOM    167  C   ASP A  15      56.480   2.401  55.131  1.00  0.00           C  
ATOM    168  O   ASP A  15      55.651   2.988  54.436  1.00  0.00           O  
ATOM    169  CB  ASP A  15      56.246   1.609  57.463  1.00  0.00           C  
ATOM    170  CG  ASP A  15      54.945   1.815  58.243  1.00  0.00           C  
ATOM    171  OD1 ASP A  15      54.119   2.621  57.765  1.00  0.00           O  
ATOM    172  OD2 ASP A  15      54.808   1.161  59.300  1.00  0.00           O  
ATOM    173  H   ASP A  15      57.450  -0.289  56.410  1.00  0.00           H  
ATOM    174  HA  ASP A  15      55.039   0.895  55.807  1.00  0.00           H  
ATOM    175  HB2 ASP A  15      56.833   0.837  57.963  1.00  0.00           H  
ATOM    176  HB3 ASP A  15      56.826   2.529  57.505  1.00  0.00           H  
ATOM    177  N   ALA A  16      57.764   2.722  55.198  1.00  0.00           N  
ATOM    178  CA  ALA A  16      58.300   3.831  54.429  1.00  0.00           C  
ATOM    179  C   ALA A  16      57.798   5.149  55.022  1.00  0.00           C  
ATOM    180  O   ALA A  16      57.402   6.053  54.289  1.00  0.00           O  
ATOM    181  CB  ALA A  16      57.910   3.668  52.958  1.00  0.00           C  
ATOM    182  H   ALA A  16      58.431   2.239  55.766  1.00  0.00           H  
ATOM    183  HA  ALA A  16      59.386   3.796  54.509  1.00  0.00           H  
ATOM    184  HB1 ALA A  16      57.946   2.613  52.687  1.00  0.00           H  
ATOM    185  HB2 ALA A  16      56.899   4.048  52.806  1.00  0.00           H  
ATOM    186  HB3 ALA A  16      58.605   4.227  52.333  1.00  0.00           H  
ATOM    187  N   THR A  17      57.831   5.215  56.345  1.00  0.00           N  
ATOM    188  CA  THR A  17      57.384   6.406  57.046  1.00  0.00           C  
ATOM    189  C   THR A  17      58.581   7.177  57.605  1.00  0.00           C  
ATOM    190  O   THR A  17      59.597   6.580  57.961  1.00  0.00           O  
ATOM    191  CB  THR A  17      56.383   5.976  58.120  1.00  0.00           C  
ATOM    192  OG1 THR A  17      55.309   5.399  57.383  1.00  0.00           O  
ATOM    193  CG2 THR A  17      55.745   7.167  58.837  1.00  0.00           C  
ATOM    194  H   THR A  17      58.155   4.475  56.935  1.00  0.00           H  
ATOM    195  HA  THR A  17      56.888   7.061  56.329  1.00  0.00           H  
ATOM    196  HB  THR A  17      56.847   5.294  58.833  1.00  0.00           H  
ATOM    197  HG1 THR A  17      55.648   4.652  56.813  1.00  0.00           H  
ATOM    198 HG21 THR A  17      56.501   7.679  59.434  1.00  0.00           H  
ATOM    199 HG22 THR A  17      55.336   7.858  58.101  1.00  0.00           H  
ATOM    200 HG23 THR A  17      54.946   6.813  59.490  1.00  0.00           H  
ATOM    201  N   VAL A  18      58.423   8.491  57.664  1.00  0.00           N  
ATOM    202  CA  VAL A  18      59.479   9.350  58.174  1.00  0.00           C  
ATOM    203  C   VAL A  18      58.855  10.552  58.885  1.00  0.00           C  
ATOM    204  O   VAL A  18      57.770  11.001  58.516  1.00  0.00           O  
ATOM    205  CB  VAL A  18      60.422   9.751  57.038  1.00  0.00           C  
ATOM    206  CG1 VAL A  18      61.190   8.537  56.510  1.00  0.00           C  
ATOM    207  CG2 VAL A  18      59.658  10.449  55.912  1.00  0.00           C  
ATOM    208  H   VAL A  18      57.594   8.969  57.373  1.00  0.00           H  
ATOM    209  HA  VAL A  18      60.051   8.772  58.900  1.00  0.00           H  
ATOM    210  HB  VAL A  18      61.148  10.458  57.439  1.00  0.00           H  
ATOM    211 HG11 VAL A  18      62.054   8.875  55.937  1.00  0.00           H  
ATOM    212 HG12 VAL A  18      61.525   7.926  57.348  1.00  0.00           H  
ATOM    213 HG13 VAL A  18      60.537   7.946  55.866  1.00  0.00           H  
ATOM    214 HG21 VAL A  18      60.366  10.854  55.188  1.00  0.00           H  
ATOM    215 HG22 VAL A  18      59.003   9.731  55.417  1.00  0.00           H  
ATOM    216 HG23 VAL A  18      59.060  11.260  56.327  1.00  0.00           H  
ATOM    217  N   VAL A  19      59.565  11.040  59.891  1.00  0.00           N  
ATOM    218  CA  VAL A  19      59.094  12.181  60.656  1.00  0.00           C  
ATOM    219  C   VAL A  19      59.766  13.453  60.133  1.00  0.00           C  
ATOM    220  O   VAL A  19      60.985  13.494  59.975  1.00  0.00           O  
ATOM    221  CB  VAL A  19      59.337  11.948  62.148  1.00  0.00           C  
ATOM    222  CG1 VAL A  19      60.734  11.374  62.393  1.00  0.00           C  
ATOM    223  CG2 VAL A  19      59.125  13.236  62.947  1.00  0.00           C  
ATOM    224  H   VAL A  19      60.447  10.669  60.184  1.00  0.00           H  
ATOM    225  HA  VAL A  19      58.019  12.262  60.497  1.00  0.00           H  
ATOM    226  HB  VAL A  19      58.609  11.215  62.495  1.00  0.00           H  
ATOM    227 HG11 VAL A  19      60.715  10.295  62.240  1.00  0.00           H  
ATOM    228 HG12 VAL A  19      61.440  11.827  61.697  1.00  0.00           H  
ATOM    229 HG13 VAL A  19      61.042  11.591  63.416  1.00  0.00           H  
ATOM    230 HG21 VAL A  19      59.377  13.060  63.993  1.00  0.00           H  
ATOM    231 HG22 VAL A  19      59.765  14.021  62.546  1.00  0.00           H  
ATOM    232 HG23 VAL A  19      58.082  13.542  62.871  1.00  0.00           H  
ATOM    233  N   VAL A  20      58.940  14.458  59.879  1.00  0.00           N  
ATOM    234  CA  VAL A  20      59.440  15.727  59.378  1.00  0.00           C  
ATOM    235  C   VAL A  20      59.241  16.806  60.444  1.00  0.00           C  
ATOM    236  O   VAL A  20      58.182  16.880  61.067  1.00  0.00           O  
ATOM    237  CB  VAL A  20      58.761  16.068  58.049  1.00  0.00           C  
ATOM    238  CG1 VAL A  20      59.128  17.481  57.593  1.00  0.00           C  
ATOM    239  CG2 VAL A  20      59.112  15.036  56.974  1.00  0.00           C  
ATOM    240  H   VAL A  20      57.950  14.416  60.011  1.00  0.00           H  
ATOM    241  HA  VAL A  20      60.507  15.610  59.191  1.00  0.00           H  
ATOM    242  HB  VAL A  20      57.683  16.036  58.205  1.00  0.00           H  
ATOM    243 HG11 VAL A  20      58.217  18.042  57.381  1.00  0.00           H  
ATOM    244 HG12 VAL A  20      59.689  17.984  58.382  1.00  0.00           H  
ATOM    245 HG13 VAL A  20      59.738  17.426  56.691  1.00  0.00           H  
ATOM    246 HG21 VAL A  20      58.237  14.422  56.761  1.00  0.00           H  
ATOM    247 HG22 VAL A  20      59.425  15.551  56.066  1.00  0.00           H  
ATOM    248 HG23 VAL A  20      59.923  14.401  57.331  1.00  0.00           H  
ATOM    249  N   ASN A  21      60.274  17.616  60.621  1.00  0.00           N  
ATOM    250  CA  ASN A  21      60.226  18.687  61.601  1.00  0.00           C  
ATOM    251  C   ASN A  21      60.880  19.940  61.014  1.00  0.00           C  
ATOM    252  O   ASN A  21      61.663  19.850  60.070  1.00  0.00           O  
ATOM    253  CB  ASN A  21      60.991  18.307  62.871  1.00  0.00           C  
ATOM    254  CG  ASN A  21      60.067  17.626  63.883  1.00  0.00           C  
ATOM    255  OD1 ASN A  21      59.352  18.265  64.638  1.00  0.00           O  
ATOM    256  ND2 ASN A  21      60.122  16.297  63.858  1.00  0.00           N  
ATOM    257  H   ASN A  21      61.131  17.548  60.110  1.00  0.00           H  
ATOM    258  HA  ASN A  21      59.168  18.831  61.817  1.00  0.00           H  
ATOM    259  HB2 ASN A  21      61.814  17.639  62.618  1.00  0.00           H  
ATOM    260  HB3 ASN A  21      61.429  19.199  63.317  1.00  0.00           H  
ATOM    261 HD21 ASN A  21      60.731  15.835  63.214  1.00  0.00           H  
ATOM    262 HD22 ASN A  21      59.555  15.762  64.484  1.00  0.00           H  
ATOM    263  N   LEU A  22      60.534  21.078  61.597  1.00  0.00           N  
ATOM    264  CA  LEU A  22      61.077  22.347  61.144  1.00  0.00           C  
ATOM    265  C   LEU A  22      62.257  22.739  62.034  1.00  0.00           C  
ATOM    266  O   LEU A  22      62.264  22.443  63.228  1.00  0.00           O  
ATOM    267  CB  LEU A  22      59.977  23.407  61.077  1.00  0.00           C  
ATOM    268  CG  LEU A  22      58.907  23.199  60.003  1.00  0.00           C  
ATOM    269  CD1 LEU A  22      58.200  24.515  59.670  1.00  0.00           C  
ATOM    270  CD2 LEU A  22      59.501  22.537  58.759  1.00  0.00           C  
ATOM    271  H   LEU A  22      59.896  21.141  62.365  1.00  0.00           H  
ATOM    272  HA  LEU A  22      61.444  22.200  60.127  1.00  0.00           H  
ATOM    273  HB2 LEU A  22      59.484  23.452  62.048  1.00  0.00           H  
ATOM    274  HB3 LEU A  22      60.444  24.378  60.912  1.00  0.00           H  
ATOM    275  HG  LEU A  22      58.151  22.520  60.400  1.00  0.00           H  
ATOM    276 HD11 LEU A  22      57.544  24.794  60.494  1.00  0.00           H  
ATOM    277 HD12 LEU A  22      58.944  25.298  59.516  1.00  0.00           H  
ATOM    278 HD13 LEU A  22      57.610  24.390  58.762  1.00  0.00           H  
ATOM    279 HD21 LEU A  22      59.847  21.534  59.011  1.00  0.00           H  
ATOM    280 HD22 LEU A  22      58.739  22.473  57.982  1.00  0.00           H  
ATOM    281 HD23 LEU A  22      60.341  23.130  58.397  1.00  0.00           H  
ATOM    282  N   GLN A  23      63.227  23.401  61.419  1.00  0.00           N  
ATOM    283  CA  GLN A  23      64.409  23.837  62.142  1.00  0.00           C  
ATOM    284  C   GLN A  23      64.097  25.089  62.966  1.00  0.00           C  
ATOM    285  O   GLN A  23      64.382  25.136  64.161  1.00  0.00           O  
ATOM    286  CB  GLN A  23      65.575  24.089  61.184  1.00  0.00           C  
ATOM    287  CG  GLN A  23      66.221  22.772  60.750  1.00  0.00           C  
ATOM    288  CD  GLN A  23      67.736  22.931  60.592  1.00  0.00           C  
ATOM    289  OE1 GLN A  23      68.434  23.388  61.481  1.00  0.00           O  
ATOM    290  NE2 GLN A  23      68.201  22.527  59.413  1.00  0.00           N  
ATOM    291  H   GLN A  23      63.213  23.639  60.448  1.00  0.00           H  
ATOM    292  HA  GLN A  23      64.665  23.012  62.806  1.00  0.00           H  
ATOM    293  HB2 GLN A  23      65.220  24.630  60.307  1.00  0.00           H  
ATOM    294  HB3 GLN A  23      66.319  24.722  61.669  1.00  0.00           H  
ATOM    295  HG2 GLN A  23      66.009  21.998  61.487  1.00  0.00           H  
ATOM    296  HG3 GLN A  23      65.786  22.443  59.806  1.00  0.00           H  
ATOM    297 HE21 GLN A  23      67.573  22.161  58.726  1.00  0.00           H  
ATOM    298 HE22 GLN A  23      69.179  22.591  59.213  1.00  0.00           H  
ATOM    299  N   SER A  24      63.514  26.071  62.294  1.00  0.00           N  
ATOM    300  CA  SER A  24      63.160  27.319  62.948  1.00  0.00           C  
ATOM    301  C   SER A  24      61.696  27.661  62.663  1.00  0.00           C  
ATOM    302  O   SER A  24      61.407  28.606  61.931  1.00  0.00           O  
ATOM    303  CB  SER A  24      64.071  28.459  62.490  1.00  0.00           C  
ATOM    304  OG  SER A  24      64.508  29.264  63.581  1.00  0.00           O  
ATOM    305  H   SER A  24      63.285  26.024  61.321  1.00  0.00           H  
ATOM    306  HA  SER A  24      63.311  27.139  64.013  1.00  0.00           H  
ATOM    307  HB2 SER A  24      64.938  28.046  61.974  1.00  0.00           H  
ATOM    308  HB3 SER A  24      63.539  29.081  61.770  1.00  0.00           H  
ATOM    309  HG  SER A  24      63.857  30.006  63.741  1.00  0.00           H  
ATOM    310  N   PRO A  25      60.787  26.854  63.274  1.00  0.00           N  
ATOM    311  CA  PRO A  25      59.361  27.062  63.093  1.00  0.00           C  
ATOM    312  C   PRO A  25      58.878  28.271  63.897  1.00  0.00           C  
ATOM    313  O   PRO A  25      59.524  28.679  64.860  1.00  0.00           O  
ATOM    314  CB  PRO A  25      58.714  25.759  63.534  1.00  0.00           C  
ATOM    315  CG  PRO A  25      59.755  25.042  64.378  1.00  0.00           C  
ATOM    316  CD  PRO A  25      61.093  25.725  64.148  1.00  0.00           C  
ATOM    317  HA  PRO A  25      59.159  27.271  62.137  1.00  0.00           H  
ATOM    318  HB2 PRO A  25      57.807  25.948  64.109  1.00  0.00           H  
ATOM    319  HB3 PRO A  25      58.426  25.156  62.673  1.00  0.00           H  
ATOM    320  HG2 PRO A  25      59.483  25.079  65.433  1.00  0.00           H  
ATOM    321  HG3 PRO A  25      59.812  23.990  64.100  1.00  0.00           H  
ATOM    322  HD2 PRO A  25      61.533  26.060  65.087  1.00  0.00           H  
ATOM    323  HD3 PRO A  25      61.810  25.048  63.684  1.00  0.00           H  
ATOM    324  N   THR A  26      57.744  28.810  63.471  1.00  0.00           N  
ATOM    325  CA  THR A  26      57.167  29.965  64.138  1.00  0.00           C  
ATOM    326  C   THR A  26      56.043  29.529  65.080  1.00  0.00           C  
ATOM    327  O   THR A  26      55.855  28.337  65.318  1.00  0.00           O  
ATOM    328  CB  THR A  26      56.712  30.953  63.064  1.00  0.00           C  
ATOM    329  OG1 THR A  26      57.703  30.843  62.047  1.00  0.00           O  
ATOM    330  CG2 THR A  26      56.813  32.408  63.526  1.00  0.00           C  
ATOM    331  H   THR A  26      57.225  28.473  62.686  1.00  0.00           H  
ATOM    332  HA  THR A  26      57.939  30.427  64.754  1.00  0.00           H  
ATOM    333  HB  THR A  26      55.702  30.722  62.725  1.00  0.00           H  
ATOM    334  HG1 THR A  26      58.616  30.904  62.451  1.00  0.00           H  
ATOM    335 HG21 THR A  26      55.822  32.773  63.801  1.00  0.00           H  
ATOM    336 HG22 THR A  26      57.475  32.470  64.390  1.00  0.00           H  
ATOM    337 HG23 THR A  26      57.213  33.020  62.718  1.00  0.00           H  
ATOM    338  N   LEU A  27      55.323  30.518  65.589  1.00  0.00           N  
ATOM    339  CA  LEU A  27      54.222  30.252  66.498  1.00  0.00           C  
ATOM    340  C   LEU A  27      53.167  29.407  65.782  1.00  0.00           C  
ATOM    341  O   LEU A  27      52.627  28.463  66.356  1.00  0.00           O  
ATOM    342  CB  LEU A  27      53.676  31.560  67.075  1.00  0.00           C  
ATOM    343  CG  LEU A  27      54.471  32.166  68.234  1.00  0.00           C  
ATOM    344  CD1 LEU A  27      54.453  33.695  68.170  1.00  0.00           C  
ATOM    345  CD2 LEU A  27      53.965  31.642  69.579  1.00  0.00           C  
ATOM    346  H   LEU A  27      55.483  31.485  65.389  1.00  0.00           H  
ATOM    347  HA  LEU A  27      54.620  29.673  67.332  1.00  0.00           H  
ATOM    348  HB2 LEU A  27      53.624  32.294  66.272  1.00  0.00           H  
ATOM    349  HB3 LEU A  27      52.654  31.385  67.413  1.00  0.00           H  
ATOM    350  HG  LEU A  27      55.510  31.853  68.136  1.00  0.00           H  
ATOM    351 HD11 LEU A  27      55.293  34.092  68.739  1.00  0.00           H  
ATOM    352 HD12 LEU A  27      54.533  34.016  67.131  1.00  0.00           H  
ATOM    353 HD13 LEU A  27      53.518  34.064  68.593  1.00  0.00           H  
ATOM    354 HD21 LEU A  27      52.913  31.371  69.491  1.00  0.00           H  
ATOM    355 HD22 LEU A  27      54.544  30.765  69.868  1.00  0.00           H  
ATOM    356 HD23 LEU A  27      54.079  32.418  70.336  1.00  0.00           H  
ATOM    357  N   GLU A  28      52.904  29.777  64.537  1.00  0.00           N  
ATOM    358  CA  GLU A  28      51.923  29.066  63.735  1.00  0.00           C  
ATOM    359  C   GLU A  28      52.312  27.591  63.607  1.00  0.00           C  
ATOM    360  O   GLU A  28      51.463  26.710  63.724  1.00  0.00           O  
ATOM    361  CB  GLU A  28      51.766  29.714  62.358  1.00  0.00           C  
ATOM    362  CG  GLU A  28      53.083  29.676  61.580  1.00  0.00           C  
ATOM    363  CD  GLU A  28      52.954  30.412  60.246  1.00  0.00           C  
ATOM    364  OE1 GLU A  28      52.467  31.563  60.277  1.00  0.00           O  
ATOM    365  OE2 GLU A  28      53.343  29.806  59.223  1.00  0.00           O  
ATOM    366  H   GLU A  28      53.348  30.547  64.077  1.00  0.00           H  
ATOM    367  HA  GLU A  28      50.984  29.154  64.281  1.00  0.00           H  
ATOM    368  HB2 GLU A  28      50.991  29.194  61.795  1.00  0.00           H  
ATOM    369  HB3 GLU A  28      51.438  30.747  62.475  1.00  0.00           H  
ATOM    370  HG2 GLU A  28      53.875  30.132  62.175  1.00  0.00           H  
ATOM    371  HG3 GLU A  28      53.374  28.640  61.402  1.00  0.00           H  
ATOM    372  N   GLU A  29      53.596  27.370  63.367  1.00  0.00           N  
ATOM    373  CA  GLU A  29      54.108  26.018  63.220  1.00  0.00           C  
ATOM    374  C   GLU A  29      54.187  25.330  64.584  1.00  0.00           C  
ATOM    375  O   GLU A  29      53.688  24.219  64.754  1.00  0.00           O  
ATOM    376  CB  GLU A  29      55.472  26.020  62.527  1.00  0.00           C  
ATOM    377  CG  GLU A  29      55.326  26.311  61.033  1.00  0.00           C  
ATOM    378  CD  GLU A  29      56.319  27.386  60.583  1.00  0.00           C  
ATOM    379  OE1 GLU A  29      55.935  28.574  60.649  1.00  0.00           O  
ATOM    380  OE2 GLU A  29      57.437  26.995  60.187  1.00  0.00           O  
ATOM    381  H   GLU A  29      54.281  28.094  63.273  1.00  0.00           H  
ATOM    382  HA  GLU A  29      53.386  25.502  62.588  1.00  0.00           H  
ATOM    383  HB2 GLU A  29      56.116  26.769  62.987  1.00  0.00           H  
ATOM    384  HB3 GLU A  29      55.957  25.054  62.667  1.00  0.00           H  
ATOM    385  HG2 GLU A  29      55.493  25.397  60.462  1.00  0.00           H  
ATOM    386  HG3 GLU A  29      54.309  26.639  60.819  1.00  0.00           H  
ATOM    387  N   LYS A  30      54.819  26.020  65.523  1.00  0.00           N  
ATOM    388  CA  LYS A  30      54.970  25.489  66.868  1.00  0.00           C  
ATOM    389  C   LYS A  30      53.614  24.989  67.369  1.00  0.00           C  
ATOM    390  O   LYS A  30      53.551  24.080  68.196  1.00  0.00           O  
ATOM    391  CB  LYS A  30      55.620  26.527  67.784  1.00  0.00           C  
ATOM    392  CG  LYS A  30      57.119  26.261  67.938  1.00  0.00           C  
ATOM    393  CD  LYS A  30      57.940  27.462  67.462  1.00  0.00           C  
ATOM    394  CE  LYS A  30      59.118  27.729  68.403  1.00  0.00           C  
ATOM    395  NZ  LYS A  30      60.003  28.773  67.842  1.00  0.00           N  
ATOM    396  H   LYS A  30      55.223  26.923  65.378  1.00  0.00           H  
ATOM    397  HA  LYS A  30      55.651  24.639  66.809  1.00  0.00           H  
ATOM    398  HB2 LYS A  30      55.464  27.526  67.376  1.00  0.00           H  
ATOM    399  HB3 LYS A  30      55.141  26.505  68.763  1.00  0.00           H  
ATOM    400  HG2 LYS A  30      57.349  26.051  68.982  1.00  0.00           H  
ATOM    401  HG3 LYS A  30      57.396  25.377  67.365  1.00  0.00           H  
ATOM    402  HD2 LYS A  30      58.311  27.277  66.454  1.00  0.00           H  
ATOM    403  HD3 LYS A  30      57.303  28.345  67.410  1.00  0.00           H  
ATOM    404  HE2 LYS A  30      58.746  28.043  69.378  1.00  0.00           H  
ATOM    405  HE3 LYS A  30      59.682  26.809  68.557  1.00  0.00           H  
ATOM    406  HZ1 LYS A  30      60.387  28.454  66.975  1.00  0.00           H  
ATOM    407  HZ2 LYS A  30      59.475  29.608  67.685  1.00  0.00           H  
ATOM    408  HZ3 LYS A  30      60.744  28.964  68.486  1.00  0.00           H  
ATOM    409  N   ASN A  31      52.563  25.603  66.848  1.00  0.00           N  
ATOM    410  CA  ASN A  31      51.212  25.232  67.232  1.00  0.00           C  
ATOM    411  C   ASN A  31      50.780  23.999  66.436  1.00  0.00           C  
ATOM    412  O   ASN A  31      50.303  23.021  67.010  1.00  0.00           O  
ATOM    413  CB  ASN A  31      50.223  26.359  66.930  1.00  0.00           C  
ATOM    414  CG  ASN A  31      49.528  26.837  68.206  1.00  0.00           C  
ATOM    415  OD1 ASN A  31      49.831  26.405  69.307  1.00  0.00           O  
ATOM    416  ND2 ASN A  31      48.583  27.748  67.999  1.00  0.00           N  
ATOM    417  H   ASN A  31      52.623  26.341  66.175  1.00  0.00           H  
ATOM    418  HA  ASN A  31      51.262  25.040  68.304  1.00  0.00           H  
ATOM    419  HB2 ASN A  31      50.749  27.193  66.464  1.00  0.00           H  
ATOM    420  HB3 ASN A  31      49.478  26.012  66.214  1.00  0.00           H  
ATOM    421 HD21 ASN A  31      48.384  28.060  67.070  1.00  0.00           H  
ATOM    422 HD22 ASN A  31      48.070  28.122  68.772  1.00  0.00           H  
ATOM    423  N   GLU A  32      50.964  24.085  65.127  1.00  0.00           N  
ATOM    424  CA  GLU A  32      50.599  22.988  64.246  1.00  0.00           C  
ATOM    425  C   GLU A  32      51.042  23.289  62.813  1.00  0.00           C  
ATOM    426  O   GLU A  32      50.797  24.380  62.299  1.00  0.00           O  
ATOM    427  CB  GLU A  32      49.096  22.712  64.309  1.00  0.00           C  
ATOM    428  CG  GLU A  32      48.746  21.417  63.573  1.00  0.00           C  
ATOM    429  CD  GLU A  32      47.275  21.407  63.149  1.00  0.00           C  
ATOM    430  OE1 GLU A  32      46.819  22.464  62.662  1.00  0.00           O  
ATOM    431  OE2 GLU A  32      46.642  20.344  63.321  1.00  0.00           O  
ATOM    432  H   GLU A  32      51.352  24.885  64.668  1.00  0.00           H  
ATOM    433  HA  GLU A  32      51.138  22.120  64.626  1.00  0.00           H  
ATOM    434  HB2 GLU A  32      48.778  22.640  65.349  1.00  0.00           H  
ATOM    435  HB3 GLU A  32      48.550  23.545  63.866  1.00  0.00           H  
ATOM    436  HG2 GLU A  32      49.382  21.310  62.694  1.00  0.00           H  
ATOM    437  HG3 GLU A  32      48.947  20.562  64.217  1.00  0.00           H  
ATOM    438  N   PHE A  33      51.687  22.302  62.208  1.00  0.00           N  
ATOM    439  CA  PHE A  33      52.168  22.448  60.845  1.00  0.00           C  
ATOM    440  C   PHE A  33      51.157  23.213  59.986  1.00  0.00           C  
ATOM    441  O   PHE A  33      49.965  22.912  60.008  1.00  0.00           O  
ATOM    442  CB  PHE A  33      52.336  21.037  60.277  1.00  0.00           C  
ATOM    443  CG  PHE A  33      53.517  20.890  59.316  1.00  0.00           C  
ATOM    444  CD1 PHE A  33      53.462  21.452  58.078  1.00  0.00           C  
ATOM    445  CD2 PHE A  33      54.623  20.196  59.700  1.00  0.00           C  
ATOM    446  CE1 PHE A  33      54.559  21.314  57.187  1.00  0.00           C  
ATOM    447  CE2 PHE A  33      55.719  20.059  58.807  1.00  0.00           C  
ATOM    448  CZ  PHE A  33      55.665  20.621  57.570  1.00  0.00           C  
ATOM    449  H   PHE A  33      51.884  21.419  62.633  1.00  0.00           H  
ATOM    450  HA  PHE A  33      53.102  23.007  60.887  1.00  0.00           H  
ATOM    451  HB2 PHE A  33      52.462  20.337  61.102  1.00  0.00           H  
ATOM    452  HB3 PHE A  33      51.420  20.754  59.757  1.00  0.00           H  
ATOM    453  HD1 PHE A  33      52.576  22.007  57.771  1.00  0.00           H  
ATOM    454  HD2 PHE A  33      54.666  19.745  60.691  1.00  0.00           H  
ATOM    455  HE1 PHE A  33      54.515  21.764  56.196  1.00  0.00           H  
ATOM    456  HE2 PHE A  33      56.605  19.503  59.115  1.00  0.00           H  
ATOM    457  HZ  PHE A  33      56.506  20.516  56.886  1.00  0.00           H  
ATOM    458  N   PRO A  34      51.686  24.213  59.231  1.00  0.00           N  
ATOM    459  CA  PRO A  34      50.844  25.024  58.367  1.00  0.00           C  
ATOM    460  C   PRO A  34      50.435  24.247  57.114  1.00  0.00           C  
ATOM    461  O   PRO A  34      51.123  23.312  56.707  1.00  0.00           O  
ATOM    462  CB  PRO A  34      51.673  26.259  58.056  1.00  0.00           C  
ATOM    463  CG  PRO A  34      53.113  25.885  58.372  1.00  0.00           C  
ATOM    464  CD  PRO A  34      53.093  24.597  59.181  1.00  0.00           C  
ATOM    465  HA  PRO A  34      49.991  25.257  58.834  1.00  0.00           H  
ATOM    466  HB2 PRO A  34      51.566  26.549  57.012  1.00  0.00           H  
ATOM    467  HB3 PRO A  34      51.350  27.108  58.659  1.00  0.00           H  
ATOM    468  HG2 PRO A  34      53.682  25.751  57.453  1.00  0.00           H  
ATOM    469  HG3 PRO A  34      53.600  26.682  58.935  1.00  0.00           H  
ATOM    470  HD2 PRO A  34      53.698  23.824  58.707  1.00  0.00           H  
ATOM    471  HD3 PRO A  34      53.499  24.752  60.180  1.00  0.00           H  
ATOM    472  N   GLU A  35      49.317  24.663  56.537  1.00  0.00           N  
ATOM    473  CA  GLU A  35      48.809  24.018  55.339  1.00  0.00           C  
ATOM    474  C   GLU A  35      49.602  24.475  54.113  1.00  0.00           C  
ATOM    475  O   GLU A  35      49.843  23.690  53.198  1.00  0.00           O  
ATOM    476  CB  GLU A  35      47.315  24.294  55.160  1.00  0.00           C  
ATOM    477  CG  GLU A  35      46.499  23.007  55.296  1.00  0.00           C  
ATOM    478  CD  GLU A  35      45.010  23.275  55.069  1.00  0.00           C  
ATOM    479  OE1 GLU A  35      44.696  23.901  54.034  1.00  0.00           O  
ATOM    480  OE2 GLU A  35      44.218  22.849  55.938  1.00  0.00           O  
ATOM    481  H   GLU A  35      48.764  25.425  56.875  1.00  0.00           H  
ATOM    482  HA  GLU A  35      48.958  22.950  55.499  1.00  0.00           H  
ATOM    483  HB2 GLU A  35      46.984  25.019  55.903  1.00  0.00           H  
ATOM    484  HB3 GLU A  35      47.139  24.738  54.180  1.00  0.00           H  
ATOM    485  HG2 GLU A  35      46.853  22.269  54.576  1.00  0.00           H  
ATOM    486  HG3 GLU A  35      46.648  22.581  56.289  1.00  0.00           H  
ATOM    487  N   ASP A  36      49.987  25.742  54.136  1.00  0.00           N  
ATOM    488  CA  ASP A  36      50.748  26.313  53.037  1.00  0.00           C  
ATOM    489  C   ASP A  36      52.074  25.563  52.898  1.00  0.00           C  
ATOM    490  O   ASP A  36      52.670  25.543  51.822  1.00  0.00           O  
ATOM    491  CB  ASP A  36      51.064  27.788  53.294  1.00  0.00           C  
ATOM    492  CG  ASP A  36      49.944  28.763  52.926  1.00  0.00           C  
ATOM    493  OD1 ASP A  36      48.829  28.575  53.459  1.00  0.00           O  
ATOM    494  OD2 ASP A  36      50.228  29.673  52.117  1.00  0.00           O  
ATOM    495  H   ASP A  36      49.787  26.374  54.884  1.00  0.00           H  
ATOM    496  HA  ASP A  36      50.111  26.202  52.160  1.00  0.00           H  
ATOM    497  HB2 ASP A  36      51.302  27.914  54.351  1.00  0.00           H  
ATOM    498  HB3 ASP A  36      51.958  28.055  52.732  1.00  0.00           H  
ATOM    499  N   LEU A  37      52.498  24.963  54.001  1.00  0.00           N  
ATOM    500  CA  LEU A  37      53.742  24.214  54.015  1.00  0.00           C  
ATOM    501  C   LEU A  37      53.445  22.736  53.751  1.00  0.00           C  
ATOM    502  O   LEU A  37      54.038  22.130  52.860  1.00  0.00           O  
ATOM    503  CB  LEU A  37      54.505  24.465  55.317  1.00  0.00           C  
ATOM    504  CG  LEU A  37      55.065  25.876  55.505  1.00  0.00           C  
ATOM    505  CD1 LEU A  37      56.005  25.937  56.711  1.00  0.00           C  
ATOM    506  CD2 LEU A  37      55.741  26.373  54.226  1.00  0.00           C  
ATOM    507  H   LEU A  37      52.007  24.984  54.872  1.00  0.00           H  
ATOM    508  HA  LEU A  37      54.361  24.592  53.201  1.00  0.00           H  
ATOM    509  HB2 LEU A  37      53.839  24.245  56.152  1.00  0.00           H  
ATOM    510  HB3 LEU A  37      55.331  23.756  55.373  1.00  0.00           H  
ATOM    511  HG  LEU A  37      54.233  26.550  55.711  1.00  0.00           H  
ATOM    512 HD11 LEU A  37      55.793  25.103  57.379  1.00  0.00           H  
ATOM    513 HD12 LEU A  37      57.038  25.876  56.370  1.00  0.00           H  
ATOM    514 HD13 LEU A  37      55.853  26.877  57.243  1.00  0.00           H  
ATOM    515 HD21 LEU A  37      54.980  26.683  53.510  1.00  0.00           H  
ATOM    516 HD22 LEU A  37      56.387  27.219  54.461  1.00  0.00           H  
ATOM    517 HD23 LEU A  37      56.339  25.569  53.795  1.00  0.00           H  
ATOM    518  N   ARG A  38      52.528  22.200  54.542  1.00  0.00           N  
ATOM    519  CA  ARG A  38      52.146  20.804  54.405  1.00  0.00           C  
ATOM    520  C   ARG A  38      52.102  20.409  52.928  1.00  0.00           C  
ATOM    521  O   ARG A  38      52.997  19.721  52.438  1.00  0.00           O  
ATOM    522  CB  ARG A  38      50.777  20.543  55.038  1.00  0.00           C  
ATOM    523  CG  ARG A  38      50.923  20.072  56.485  1.00  0.00           C  
ATOM    524  CD  ARG A  38      50.033  20.893  57.421  1.00  0.00           C  
ATOM    525  NE  ARG A  38      49.232  19.990  58.278  1.00  0.00           N  
ATOM    526  CZ  ARG A  38      48.057  19.457  57.917  1.00  0.00           C  
ATOM    527  NH1 ARG A  38      47.539  19.733  56.712  1.00  0.00           N  
ATOM    528  NH2 ARG A  38      47.400  18.648  58.760  1.00  0.00           N  
ATOM    529  H   ARG A  38      52.050  22.700  55.265  1.00  0.00           H  
ATOM    530  HA  ARG A  38      52.920  20.249  54.937  1.00  0.00           H  
ATOM    531  HB2 ARG A  38      50.179  21.454  55.006  1.00  0.00           H  
ATOM    532  HB3 ARG A  38      50.242  19.791  54.457  1.00  0.00           H  
ATOM    533  HG2 ARG A  38      50.656  19.017  56.557  1.00  0.00           H  
ATOM    534  HG3 ARG A  38      51.963  20.159  56.797  1.00  0.00           H  
ATOM    535  HD2 ARG A  38      50.647  21.545  58.041  1.00  0.00           H  
ATOM    536  HD3 ARG A  38      49.373  21.534  56.839  1.00  0.00           H  
ATOM    537  HE  ARG A  38      49.591  19.763  59.184  1.00  0.00           H  
ATOM    538 HH11 ARG A  38      48.029  20.337  56.084  1.00  0.00           H  
ATOM    539 HH12 ARG A  38      46.661  19.336  56.443  1.00  0.00           H  
ATOM    540 HH21 ARG A  38      47.786  18.442  59.658  1.00  0.00           H  
ATOM    541 HH22 ARG A  38      46.523  18.251  58.490  1.00  0.00           H  
ATOM    542  N   THR A  39      51.051  20.859  52.259  1.00  0.00           N  
ATOM    543  CA  THR A  39      50.878  20.561  50.847  1.00  0.00           C  
ATOM    544  C   THR A  39      52.221  20.636  50.118  1.00  0.00           C  
ATOM    545  O   THR A  39      52.663  19.656  49.521  1.00  0.00           O  
ATOM    546  CB  THR A  39      49.828  21.521  50.286  1.00  0.00           C  
ATOM    547  OG1 THR A  39      48.638  21.190  50.999  1.00  0.00           O  
ATOM    548  CG2 THR A  39      49.482  21.223  48.826  1.00  0.00           C  
ATOM    549  H   THR A  39      50.328  21.418  52.665  1.00  0.00           H  
ATOM    550  HA  THR A  39      50.521  19.535  50.754  1.00  0.00           H  
ATOM    551  HB  THR A  39      50.143  22.557  50.408  1.00  0.00           H  
ATOM    552  HG1 THR A  39      47.883  21.766  50.689  1.00  0.00           H  
ATOM    553 HG21 THR A  39      49.612  20.157  48.632  1.00  0.00           H  
ATOM    554 HG22 THR A  39      48.446  21.503  48.633  1.00  0.00           H  
ATOM    555 HG23 THR A  39      50.140  21.794  48.172  1.00  0.00           H  
ATOM    556  N   GLU A  40      52.832  21.809  50.191  1.00  0.00           N  
ATOM    557  CA  GLU A  40      54.116  22.026  49.545  1.00  0.00           C  
ATOM    558  C   GLU A  40      55.065  20.865  49.850  1.00  0.00           C  
ATOM    559  O   GLU A  40      55.803  20.415  48.972  1.00  0.00           O  
ATOM    560  CB  GLU A  40      54.728  23.361  49.974  1.00  0.00           C  
ATOM    561  CG  GLU A  40      54.326  24.481  49.014  1.00  0.00           C  
ATOM    562  CD  GLU A  40      52.804  24.618  48.938  1.00  0.00           C  
ATOM    563  OE1 GLU A  40      52.160  23.608  48.582  1.00  0.00           O  
ATOM    564  OE2 GLU A  40      52.318  25.731  49.237  1.00  0.00           O  
ATOM    565  H   GLU A  40      52.466  22.602  50.678  1.00  0.00           H  
ATOM    566  HA  GLU A  40      53.902  22.058  48.477  1.00  0.00           H  
ATOM    567  HB2 GLU A  40      54.401  23.608  50.984  1.00  0.00           H  
ATOM    568  HB3 GLU A  40      55.814  23.274  50.003  1.00  0.00           H  
ATOM    569  HG2 GLU A  40      54.763  25.423  49.345  1.00  0.00           H  
ATOM    570  HG3 GLU A  40      54.726  24.276  48.021  1.00  0.00           H  
ATOM    571  N   LEU A  41      55.017  20.413  51.094  1.00  0.00           N  
ATOM    572  CA  LEU A  41      55.863  19.313  51.524  1.00  0.00           C  
ATOM    573  C   LEU A  41      55.317  18.001  50.955  1.00  0.00           C  
ATOM    574  O   LEU A  41      56.038  17.264  50.283  1.00  0.00           O  
ATOM    575  CB  LEU A  41      56.005  19.310  53.046  1.00  0.00           C  
ATOM    576  CG  LEU A  41      57.385  19.679  53.593  1.00  0.00           C  
ATOM    577  CD1 LEU A  41      57.497  21.188  53.825  1.00  0.00           C  
ATOM    578  CD2 LEU A  41      57.707  18.880  54.858  1.00  0.00           C  
ATOM    579  H   LEU A  41      54.414  20.784  51.800  1.00  0.00           H  
ATOM    580  HA  LEU A  41      56.856  19.483  51.108  1.00  0.00           H  
ATOM    581  HB2 LEU A  41      55.274  20.005  53.461  1.00  0.00           H  
ATOM    582  HB3 LEU A  41      55.745  18.318  53.414  1.00  0.00           H  
ATOM    583  HG  LEU A  41      58.131  19.413  52.845  1.00  0.00           H  
ATOM    584 HD11 LEU A  41      56.550  21.568  54.205  1.00  0.00           H  
ATOM    585 HD12 LEU A  41      58.286  21.386  54.550  1.00  0.00           H  
ATOM    586 HD13 LEU A  41      57.737  21.683  52.884  1.00  0.00           H  
ATOM    587 HD21 LEU A  41      58.599  18.275  54.687  1.00  0.00           H  
ATOM    588 HD22 LEU A  41      57.886  19.566  55.685  1.00  0.00           H  
ATOM    589 HD23 LEU A  41      56.867  18.229  55.099  1.00  0.00           H  
ATOM    590  N   MET A  42      54.049  17.751  51.244  1.00  0.00           N  
ATOM    591  CA  MET A  42      53.398  16.542  50.769  1.00  0.00           C  
ATOM    592  C   MET A  42      53.579  16.378  49.259  1.00  0.00           C  
ATOM    593  O   MET A  42      53.801  15.269  48.773  1.00  0.00           O  
ATOM    594  CB  MET A  42      51.906  16.601  51.101  1.00  0.00           C  
ATOM    595  CG  MET A  42      51.685  16.812  52.599  1.00  0.00           C  
ATOM    596  SD  MET A  42      52.640  15.625  53.530  1.00  0.00           S  
ATOM    597  CE  MET A  42      53.041  16.607  54.965  1.00  0.00           C  
ATOM    598  H   MET A  42      53.469  18.356  51.790  1.00  0.00           H  
ATOM    599  HA  MET A  42      53.888  15.721  51.292  1.00  0.00           H  
ATOM    600  HB2 MET A  42      51.437  17.412  50.543  1.00  0.00           H  
ATOM    601  HB3 MET A  42      51.421  15.677  50.784  1.00  0.00           H  
ATOM    602  HG2 MET A  42      51.975  17.824  52.879  1.00  0.00           H  
ATOM    603  HG3 MET A  42      50.626  16.707  52.837  1.00  0.00           H  
ATOM    604  HE1 MET A  42      53.853  17.291  54.721  1.00  0.00           H  
ATOM    605  HE2 MET A  42      52.165  17.177  55.272  1.00  0.00           H  
ATOM    606  HE3 MET A  42      53.351  15.952  55.779  1.00  0.00           H  
ATOM    607  N   GLN A  43      53.480  17.498  48.558  1.00  0.00           N  
ATOM    608  CA  GLN A  43      53.630  17.492  47.112  1.00  0.00           C  
ATOM    609  C   GLN A  43      55.111  17.417  46.734  1.00  0.00           C  
ATOM    610  O   GLN A  43      55.465  16.823  45.717  1.00  0.00           O  
ATOM    611  CB  GLN A  43      52.966  18.721  46.488  1.00  0.00           C  
ATOM    612  CG  GLN A  43      53.844  19.963  46.653  1.00  0.00           C  
ATOM    613  CD  GLN A  43      53.236  21.166  45.929  1.00  0.00           C  
ATOM    614  OE1 GLN A  43      53.601  21.500  44.813  1.00  0.00           O  
ATOM    615  NE2 GLN A  43      52.290  21.793  46.622  1.00  0.00           N  
ATOM    616  H   GLN A  43      53.299  18.395  48.961  1.00  0.00           H  
ATOM    617  HA  GLN A  43      53.116  16.595  46.771  1.00  0.00           H  
ATOM    618  HB2 GLN A  43      52.783  18.540  45.429  1.00  0.00           H  
ATOM    619  HB3 GLN A  43      51.996  18.892  46.955  1.00  0.00           H  
ATOM    620  HG2 GLN A  43      53.959  20.193  47.713  1.00  0.00           H  
ATOM    621  HG3 GLN A  43      54.841  19.763  46.261  1.00  0.00           H  
ATOM    622 HE21 GLN A  43      52.037  21.466  47.532  1.00  0.00           H  
ATOM    623 HE22 GLN A  43      51.832  22.592  46.232  1.00  0.00           H  
ATOM    624  N   THR A  44      55.936  18.028  47.571  1.00  0.00           N  
ATOM    625  CA  THR A  44      57.369  18.038  47.337  1.00  0.00           C  
ATOM    626  C   THR A  44      57.970  16.666  47.653  1.00  0.00           C  
ATOM    627  O   THR A  44      58.411  15.955  46.752  1.00  0.00           O  
ATOM    628  CB  THR A  44      57.976  19.172  48.165  1.00  0.00           C  
ATOM    629  OG1 THR A  44      57.642  20.351  47.437  1.00  0.00           O  
ATOM    630  CG2 THR A  44      59.506  19.150  48.156  1.00  0.00           C  
ATOM    631  H   THR A  44      55.638  18.509  48.397  1.00  0.00           H  
ATOM    632  HA  THR A  44      57.543  18.226  46.279  1.00  0.00           H  
ATOM    633  HB  THR A  44      57.592  19.158  49.185  1.00  0.00           H  
ATOM    634  HG1 THR A  44      56.648  20.438  47.366  1.00  0.00           H  
ATOM    635 HG21 THR A  44      59.873  19.766  47.335  1.00  0.00           H  
ATOM    636 HG22 THR A  44      59.881  19.543  49.102  1.00  0.00           H  
ATOM    637 HG23 THR A  44      59.854  18.125  48.025  1.00  0.00           H  
ATOM    638  N   LEU A  45      57.970  16.337  48.937  1.00  0.00           N  
ATOM    639  CA  LEU A  45      58.510  15.064  49.383  1.00  0.00           C  
ATOM    640  C   LEU A  45      57.918  13.938  48.533  1.00  0.00           C  
ATOM    641  O   LEU A  45      58.628  13.017  48.133  1.00  0.00           O  
ATOM    642  CB  LEU A  45      58.285  14.883  50.885  1.00  0.00           C  
ATOM    643  CG  LEU A  45      58.649  16.080  51.766  1.00  0.00           C  
ATOM    644  CD1 LEU A  45      58.552  15.719  53.250  1.00  0.00           C  
ATOM    645  CD2 LEU A  45      60.029  16.632  51.400  1.00  0.00           C  
ATOM    646  H   LEU A  45      57.610  16.922  49.664  1.00  0.00           H  
ATOM    647  HA  LEU A  45      59.588  15.091  49.219  1.00  0.00           H  
ATOM    648  HB2 LEU A  45      57.235  14.644  51.050  1.00  0.00           H  
ATOM    649  HB3 LEU A  45      58.864  14.023  51.219  1.00  0.00           H  
ATOM    650  HG  LEU A  45      57.926  16.875  51.580  1.00  0.00           H  
ATOM    651 HD11 LEU A  45      59.460  16.034  53.762  1.00  0.00           H  
ATOM    652 HD12 LEU A  45      57.693  16.224  53.691  1.00  0.00           H  
ATOM    653 HD13 LEU A  45      58.431  14.641  53.354  1.00  0.00           H  
ATOM    654 HD21 LEU A  45      60.758  15.822  51.414  1.00  0.00           H  
ATOM    655 HD22 LEU A  45      59.992  17.071  50.404  1.00  0.00           H  
ATOM    656 HD23 LEU A  45      60.319  17.394  52.123  1.00  0.00           H  
ATOM    657  N   GLY A  46      56.621  14.049  48.281  1.00  0.00           N  
ATOM    658  CA  GLY A  46      55.926  13.051  47.486  1.00  0.00           C  
ATOM    659  C   GLY A  46      56.638  12.819  46.152  1.00  0.00           C  
ATOM    660  O   GLY A  46      56.872  11.678  45.759  1.00  0.00           O  
ATOM    661  H   GLY A  46      56.050  14.801  48.610  1.00  0.00           H  
ATOM    662  HA2 GLY A  46      55.870  12.113  48.040  1.00  0.00           H  
ATOM    663  HA3 GLY A  46      54.902  13.375  47.305  1.00  0.00           H  
ATOM    664  N   SER A  47      56.962  13.921  45.491  1.00  0.00           N  
ATOM    665  CA  SER A  47      57.642  13.853  44.210  1.00  0.00           C  
ATOM    666  C   SER A  47      58.680  12.728  44.227  1.00  0.00           C  
ATOM    667  O   SER A  47      58.567  11.764  43.471  1.00  0.00           O  
ATOM    668  CB  SER A  47      58.312  15.186  43.869  1.00  0.00           C  
ATOM    669  OG  SER A  47      58.563  15.316  42.473  1.00  0.00           O  
ATOM    670  H   SER A  47      56.768  14.847  45.819  1.00  0.00           H  
ATOM    671  HA  SER A  47      56.862  13.642  43.479  1.00  0.00           H  
ATOM    672  HB2 SER A  47      57.675  16.006  44.202  1.00  0.00           H  
ATOM    673  HB3 SER A  47      59.251  15.270  44.415  1.00  0.00           H  
ATOM    674  HG  SER A  47      58.405  16.261  42.184  1.00  0.00           H  
ATOM    675  N   TYR A  48      59.664  12.888  45.099  1.00  0.00           N  
ATOM    676  CA  TYR A  48      60.720  11.897  45.224  1.00  0.00           C  
ATOM    677  C   TYR A  48      60.163  10.479  45.077  1.00  0.00           C  
ATOM    678  O   TYR A  48      60.692   9.677  44.309  1.00  0.00           O  
ATOM    679  CB  TYR A  48      61.290  12.064  46.635  1.00  0.00           C  
ATOM    680  CG  TYR A  48      62.011  13.394  46.860  1.00  0.00           C  
ATOM    681  CD1 TYR A  48      61.301  14.503  47.275  1.00  0.00           C  
ATOM    682  CD2 TYR A  48      63.371  13.486  46.650  1.00  0.00           C  
ATOM    683  CE1 TYR A  48      61.979  15.755  47.488  1.00  0.00           C  
ATOM    684  CE2 TYR A  48      64.051  14.738  46.862  1.00  0.00           C  
ATOM    685  CZ  TYR A  48      63.321  15.810  47.271  1.00  0.00           C  
ATOM    686  OH  TYR A  48      63.963  16.993  47.473  1.00  0.00           O  
ATOM    687  H   TYR A  48      59.748  13.674  45.710  1.00  0.00           H  
ATOM    688  HA  TYR A  48      61.447  12.078  44.433  1.00  0.00           H  
ATOM    689  HB2 TYR A  48      60.477  11.976  47.356  1.00  0.00           H  
ATOM    690  HB3 TYR A  48      61.984  11.248  46.835  1.00  0.00           H  
ATOM    691  HD1 TYR A  48      60.226  14.430  47.442  1.00  0.00           H  
ATOM    692  HD2 TYR A  48      63.932  12.610  46.322  1.00  0.00           H  
ATOM    693  HE1 TYR A  48      61.431  16.637  47.816  1.00  0.00           H  
ATOM    694  HE2 TYR A  48      65.125  14.824  46.700  1.00  0.00           H  
ATOM    695  HH  TYR A  48      63.584  17.454  48.276  1.00  0.00           H  
ATOM    696  N   GLY A  49      59.102  10.215  45.825  1.00  0.00           N  
ATOM    697  CA  GLY A  49      58.466   8.909  45.787  1.00  0.00           C  
ATOM    698  C   GLY A  49      56.967   9.036  45.515  1.00  0.00           C  
ATOM    699  O   GLY A  49      56.561   9.601  44.501  1.00  0.00           O  
ATOM    700  H   GLY A  49      58.677  10.873  46.446  1.00  0.00           H  
ATOM    701  HA2 GLY A  49      58.930   8.298  45.011  1.00  0.00           H  
ATOM    702  HA3 GLY A  49      58.626   8.396  46.734  1.00  0.00           H  
ATOM    703  N   THR A  50      56.182   8.501  46.440  1.00  0.00           N  
ATOM    704  CA  THR A  50      54.736   8.547  46.313  1.00  0.00           C  
ATOM    705  C   THR A  50      54.079   8.535  47.695  1.00  0.00           C  
ATOM    706  O   THR A  50      54.295   7.614  48.481  1.00  0.00           O  
ATOM    707  CB  THR A  50      54.302   7.381  45.423  1.00  0.00           C  
ATOM    708  OG1 THR A  50      54.129   7.970  44.138  1.00  0.00           O  
ATOM    709  CG2 THR A  50      52.909   6.857  45.783  1.00  0.00           C  
ATOM    710  H   THR A  50      56.520   8.043  47.262  1.00  0.00           H  
ATOM    711  HA  THR A  50      54.463   9.489  45.838  1.00  0.00           H  
ATOM    712  HB  THR A  50      55.037   6.578  45.447  1.00  0.00           H  
ATOM    713  HG1 THR A  50      54.939   8.505  43.895  1.00  0.00           H  
ATOM    714 HG21 THR A  50      52.905   6.516  46.818  1.00  0.00           H  
ATOM    715 HG22 THR A  50      52.178   7.656  45.661  1.00  0.00           H  
ATOM    716 HG23 THR A  50      52.653   6.027  45.126  1.00  0.00           H  
ATOM    717  N   ILE A  51      53.290   9.569  47.949  1.00  0.00           N  
ATOM    718  CA  ILE A  51      52.600   9.688  49.222  1.00  0.00           C  
ATOM    719  C   ILE A  51      51.463   8.665  49.279  1.00  0.00           C  
ATOM    720  O   ILE A  51      50.538   8.713  48.470  1.00  0.00           O  
ATOM    721  CB  ILE A  51      52.141  11.130  49.449  1.00  0.00           C  
ATOM    722  CG1 ILE A  51      53.330  12.094  49.425  1.00  0.00           C  
ATOM    723  CG2 ILE A  51      51.332  11.250  50.742  1.00  0.00           C  
ATOM    724  CD1 ILE A  51      54.165  11.966  50.700  1.00  0.00           C  
ATOM    725  H   ILE A  51      53.119  10.314  47.304  1.00  0.00           H  
ATOM    726  HA  ILE A  51      53.318   9.451  50.006  1.00  0.00           H  
ATOM    727  HB  ILE A  51      51.480  11.412  48.629  1.00  0.00           H  
ATOM    728 HG12 ILE A  51      53.953  11.885  48.555  1.00  0.00           H  
ATOM    729 HG13 ILE A  51      52.969  13.117  49.322  1.00  0.00           H  
ATOM    730 HG21 ILE A  51      51.732  12.065  51.347  1.00  0.00           H  
ATOM    731 HG22 ILE A  51      50.289  11.456  50.501  1.00  0.00           H  
ATOM    732 HG23 ILE A  51      51.398  10.317  51.301  1.00  0.00           H  
ATOM    733 HD11 ILE A  51      55.224  11.972  50.443  1.00  0.00           H  
ATOM    734 HD12 ILE A  51      53.947  12.803  51.363  1.00  0.00           H  
ATOM    735 HD13 ILE A  51      53.919  11.031  51.204  1.00  0.00           H  
ATOM    736  N   VAL A  52      51.570   7.763  50.244  1.00  0.00           N  
ATOM    737  CA  VAL A  52      50.564   6.730  50.418  1.00  0.00           C  
ATOM    738  C   VAL A  52      49.826   6.959  51.739  1.00  0.00           C  
ATOM    739  O   VAL A  52      48.802   6.330  51.999  1.00  0.00           O  
ATOM    740  CB  VAL A  52      51.211   5.347  50.327  1.00  0.00           C  
ATOM    741  CG1 VAL A  52      52.092   5.235  49.081  1.00  0.00           C  
ATOM    742  CG2 VAL A  52      52.010   5.032  51.593  1.00  0.00           C  
ATOM    743  H   VAL A  52      52.326   7.731  50.898  1.00  0.00           H  
ATOM    744  HA  VAL A  52      49.851   6.823  49.598  1.00  0.00           H  
ATOM    745  HB  VAL A  52      50.415   4.608  50.241  1.00  0.00           H  
ATOM    746 HG11 VAL A  52      51.478   4.946  48.227  1.00  0.00           H  
ATOM    747 HG12 VAL A  52      52.563   6.197  48.881  1.00  0.00           H  
ATOM    748 HG13 VAL A  52      52.862   4.481  49.246  1.00  0.00           H  
ATOM    749 HG21 VAL A  52      52.436   4.032  51.514  1.00  0.00           H  
ATOM    750 HG22 VAL A  52      52.812   5.760  51.707  1.00  0.00           H  
ATOM    751 HG23 VAL A  52      51.350   5.079  52.460  1.00  0.00           H  
ATOM    752  N   LEU A  53      50.376   7.862  52.537  1.00  0.00           N  
ATOM    753  CA  LEU A  53      49.784   8.182  53.824  1.00  0.00           C  
ATOM    754  C   LEU A  53      50.599   9.289  54.495  1.00  0.00           C  
ATOM    755  O   LEU A  53      51.804   9.399  54.273  1.00  0.00           O  
ATOM    756  CB  LEU A  53      49.641   6.921  54.678  1.00  0.00           C  
ATOM    757  CG  LEU A  53      48.278   6.709  55.340  1.00  0.00           C  
ATOM    758  CD1 LEU A  53      47.757   8.012  55.951  1.00  0.00           C  
ATOM    759  CD2 LEU A  53      47.280   6.097  54.356  1.00  0.00           C  
ATOM    760  H   LEU A  53      51.209   8.370  52.317  1.00  0.00           H  
ATOM    761  HA  LEU A  53      48.778   8.560  53.637  1.00  0.00           H  
ATOM    762  HB2 LEU A  53      49.856   6.056  54.050  1.00  0.00           H  
ATOM    763  HB3 LEU A  53      50.402   6.946  55.457  1.00  0.00           H  
ATOM    764  HG  LEU A  53      48.402   5.998  56.157  1.00  0.00           H  
ATOM    765 HD11 LEU A  53      48.529   8.450  56.584  1.00  0.00           H  
ATOM    766 HD12 LEU A  53      47.502   8.709  55.153  1.00  0.00           H  
ATOM    767 HD13 LEU A  53      46.870   7.803  56.549  1.00  0.00           H  
ATOM    768 HD21 LEU A  53      47.742   5.252  53.847  1.00  0.00           H  
ATOM    769 HD22 LEU A  53      46.398   5.756  54.899  1.00  0.00           H  
ATOM    770 HD23 LEU A  53      46.987   6.847  53.622  1.00  0.00           H  
ATOM    771  N   VAL A  54      49.910  10.082  55.303  1.00  0.00           N  
ATOM    772  CA  VAL A  54      50.555  11.177  56.007  1.00  0.00           C  
ATOM    773  C   VAL A  54      49.819  11.436  57.323  1.00  0.00           C  
ATOM    774  O   VAL A  54      48.597  11.310  57.390  1.00  0.00           O  
ATOM    775  CB  VAL A  54      50.622  12.412  55.107  1.00  0.00           C  
ATOM    776  CG1 VAL A  54      51.564  12.179  53.925  1.00  0.00           C  
ATOM    777  CG2 VAL A  54      49.227  12.814  54.625  1.00  0.00           C  
ATOM    778  H   VAL A  54      48.930   9.986  55.479  1.00  0.00           H  
ATOM    779  HA  VAL A  54      51.576  10.867  56.232  1.00  0.00           H  
ATOM    780  HB  VAL A  54      51.023  13.236  55.698  1.00  0.00           H  
ATOM    781 HG11 VAL A  54      51.660  13.098  53.349  1.00  0.00           H  
ATOM    782 HG12 VAL A  54      52.545  11.878  54.295  1.00  0.00           H  
ATOM    783 HG13 VAL A  54      51.160  11.392  53.288  1.00  0.00           H  
ATOM    784 HG21 VAL A  54      49.317  13.498  53.780  1.00  0.00           H  
ATOM    785 HG22 VAL A  54      48.679  11.925  54.315  1.00  0.00           H  
ATOM    786 HG23 VAL A  54      48.691  13.308  55.436  1.00  0.00           H  
ATOM    787  N   ARG A  55      50.593  11.792  58.338  1.00  0.00           N  
ATOM    788  CA  ARG A  55      50.029  12.068  59.648  1.00  0.00           C  
ATOM    789  C   ARG A  55      50.801  13.200  60.329  1.00  0.00           C  
ATOM    790  O   ARG A  55      51.953  13.022  60.722  1.00  0.00           O  
ATOM    791  CB  ARG A  55      50.068  10.825  60.539  1.00  0.00           C  
ATOM    792  CG  ARG A  55      49.051  10.933  61.677  1.00  0.00           C  
ATOM    793  CD  ARG A  55      49.465  10.065  62.867  1.00  0.00           C  
ATOM    794  NE  ARG A  55      48.263   9.572  63.575  1.00  0.00           N  
ATOM    795  CZ  ARG A  55      48.289   8.645  64.544  1.00  0.00           C  
ATOM    796  NH1 ARG A  55      49.456   8.107  64.924  1.00  0.00           N  
ATOM    797  NH2 ARG A  55      47.149   8.258  65.130  1.00  0.00           N  
ATOM    798  H   ARG A  55      51.586  11.891  58.276  1.00  0.00           H  
ATOM    799  HA  ARG A  55      48.998  12.361  59.452  1.00  0.00           H  
ATOM    800  HB2 ARG A  55      49.859   9.938  59.942  1.00  0.00           H  
ATOM    801  HB3 ARG A  55      51.070  10.701  60.952  1.00  0.00           H  
ATOM    802  HG2 ARG A  55      48.962  11.972  61.992  1.00  0.00           H  
ATOM    803  HG3 ARG A  55      48.068  10.624  61.320  1.00  0.00           H  
ATOM    804  HD2 ARG A  55      50.066   9.224  62.523  1.00  0.00           H  
ATOM    805  HD3 ARG A  55      50.087  10.644  63.550  1.00  0.00           H  
ATOM    806  HE  ARG A  55      47.376   9.953  63.315  1.00  0.00           H  
ATOM    807 HH11 ARG A  55      50.307   8.397  64.486  1.00  0.00           H  
ATOM    808 HH12 ARG A  55      49.476   7.417  65.647  1.00  0.00           H  
ATOM    809 HH21 ARG A  55      46.278   8.659  64.847  1.00  0.00           H  
ATOM    810 HH22 ARG A  55      47.169   7.567  65.853  1.00  0.00           H  
ATOM    811  N   ILE A  56      50.135  14.340  60.449  1.00  0.00           N  
ATOM    812  CA  ILE A  56      50.745  15.500  61.076  1.00  0.00           C  
ATOM    813  C   ILE A  56      50.428  15.490  62.573  1.00  0.00           C  
ATOM    814  O   ILE A  56      49.271  15.352  62.965  1.00  0.00           O  
ATOM    815  CB  ILE A  56      50.311  16.783  60.364  1.00  0.00           C  
ATOM    816  CG1 ILE A  56      51.244  17.102  59.193  1.00  0.00           C  
ATOM    817  CG2 ILE A  56      50.209  17.949  61.349  1.00  0.00           C  
ATOM    818  CD1 ILE A  56      51.011  16.138  58.028  1.00  0.00           C  
ATOM    819  H   ILE A  56      49.198  14.477  60.127  1.00  0.00           H  
ATOM    820  HA  ILE A  56      51.824  15.410  60.950  1.00  0.00           H  
ATOM    821  HB  ILE A  56      49.316  16.624  59.949  1.00  0.00           H  
ATOM    822 HG12 ILE A  56      51.079  18.127  58.861  1.00  0.00           H  
ATOM    823 HG13 ILE A  56      52.281  17.037  59.522  1.00  0.00           H  
ATOM    824 HG21 ILE A  56      51.038  17.902  62.055  1.00  0.00           H  
ATOM    825 HG22 ILE A  56      50.250  18.891  60.803  1.00  0.00           H  
ATOM    826 HG23 ILE A  56      49.265  17.885  61.891  1.00  0.00           H  
ATOM    827 HD11 ILE A  56      50.952  16.701  57.097  1.00  0.00           H  
ATOM    828 HD12 ILE A  56      51.838  15.429  57.972  1.00  0.00           H  
ATOM    829 HD13 ILE A  56      50.078  15.597  58.185  1.00  0.00           H  
ATOM    830  N   ASN A  57      51.477  15.641  63.368  1.00  0.00           N  
ATOM    831  CA  ASN A  57      51.325  15.651  64.813  1.00  0.00           C  
ATOM    832  C   ASN A  57      51.409  17.093  65.320  1.00  0.00           C  
ATOM    833  O   ASN A  57      52.042  17.940  64.692  1.00  0.00           O  
ATOM    834  CB  ASN A  57      52.436  14.847  65.490  1.00  0.00           C  
ATOM    835  CG  ASN A  57      51.856  13.703  66.324  1.00  0.00           C  
ATOM    836  OD1 ASN A  57      51.611  13.830  67.513  1.00  0.00           O  
ATOM    837  ND2 ASN A  57      51.650  12.583  65.638  1.00  0.00           N  
ATOM    838  H   ASN A  57      52.415  15.753  63.041  1.00  0.00           H  
ATOM    839  HA  ASN A  57      50.351  15.199  65.003  1.00  0.00           H  
ATOM    840  HB2 ASN A  57      53.111  14.444  64.734  1.00  0.00           H  
ATOM    841  HB3 ASN A  57      53.029  15.503  66.127  1.00  0.00           H  
ATOM    842 HD21 ASN A  57      51.873  12.546  64.663  1.00  0.00           H  
ATOM    843 HD22 ASN A  57      51.273  11.779  66.095  1.00  0.00           H  
ATOM    844  N   GLN A  58      50.760  17.326  66.451  1.00  0.00           N  
ATOM    845  CA  GLN A  58      50.754  18.652  67.050  1.00  0.00           C  
ATOM    846  C   GLN A  58      52.058  19.385  66.729  1.00  0.00           C  
ATOM    847  O   GLN A  58      52.046  20.580  66.436  1.00  0.00           O  
ATOM    848  CB  GLN A  58      50.528  18.570  68.561  1.00  0.00           C  
ATOM    849  CG  GLN A  58      49.044  18.389  68.884  1.00  0.00           C  
ATOM    850  CD  GLN A  58      48.857  17.635  70.202  1.00  0.00           C  
ATOM    851  OE1 GLN A  58      49.551  16.679  70.504  1.00  0.00           O  
ATOM    852  NE2 GLN A  58      47.881  18.118  70.967  1.00  0.00           N  
ATOM    853  H   GLN A  58      50.248  16.632  66.955  1.00  0.00           H  
ATOM    854  HA  GLN A  58      49.914  19.172  66.590  1.00  0.00           H  
ATOM    855  HB2 GLN A  58      51.097  17.736  68.972  1.00  0.00           H  
ATOM    856  HB3 GLN A  58      50.900  19.476  69.037  1.00  0.00           H  
ATOM    857  HG2 GLN A  58      48.559  19.363  68.946  1.00  0.00           H  
ATOM    858  HG3 GLN A  58      48.555  17.842  68.076  1.00  0.00           H  
ATOM    859 HE21 GLN A  58      47.348  18.906  70.660  1.00  0.00           H  
ATOM    860 HE22 GLN A  58      47.682  17.692  71.851  1.00  0.00           H  
ATOM    861  N   GLY A  59      53.151  18.639  66.797  1.00  0.00           N  
ATOM    862  CA  GLY A  59      54.460  19.203  66.518  1.00  0.00           C  
ATOM    863  C   GLY A  59      55.344  18.199  65.774  1.00  0.00           C  
ATOM    864  O   GLY A  59      56.509  18.017  66.120  1.00  0.00           O  
ATOM    865  H   GLY A  59      53.152  17.668  67.036  1.00  0.00           H  
ATOM    866  HA2 GLY A  59      54.350  20.109  65.920  1.00  0.00           H  
ATOM    867  HA3 GLY A  59      54.942  19.494  67.451  1.00  0.00           H  
ATOM    868  N   GLN A  60      54.753  17.574  64.766  1.00  0.00           N  
ATOM    869  CA  GLN A  60      55.472  16.593  63.970  1.00  0.00           C  
ATOM    870  C   GLN A  60      54.762  16.373  62.633  1.00  0.00           C  
ATOM    871  O   GLN A  60      53.667  16.889  62.414  1.00  0.00           O  
ATOM    872  CB  GLN A  60      55.626  15.276  64.733  1.00  0.00           C  
ATOM    873  CG  GLN A  60      57.056  15.107  65.252  1.00  0.00           C  
ATOM    874  CD  GLN A  60      57.060  14.743  66.738  1.00  0.00           C  
ATOM    875  OE1 GLN A  60      56.318  15.288  67.539  1.00  0.00           O  
ATOM    876  NE2 GLN A  60      57.933  13.794  67.060  1.00  0.00           N  
ATOM    877  H   GLN A  60      53.804  17.729  64.490  1.00  0.00           H  
ATOM    878  HA  GLN A  60      56.457  17.024  63.800  1.00  0.00           H  
ATOM    879  HB2 GLN A  60      54.926  15.251  65.568  1.00  0.00           H  
ATOM    880  HB3 GLN A  60      55.372  14.440  64.079  1.00  0.00           H  
ATOM    881  HG2 GLN A  60      57.564  14.328  64.682  1.00  0.00           H  
ATOM    882  HG3 GLN A  60      57.613  16.030  65.098  1.00  0.00           H  
ATOM    883 HE21 GLN A  60      58.513  13.388  66.354  1.00  0.00           H  
ATOM    884 HE22 GLN A  60      58.011  13.487  68.009  1.00  0.00           H  
ATOM    885  N   MET A  61      55.415  15.605  61.772  1.00  0.00           N  
ATOM    886  CA  MET A  61      54.862  15.310  60.462  1.00  0.00           C  
ATOM    887  C   MET A  61      55.357  13.956  59.949  1.00  0.00           C  
ATOM    888  O   MET A  61      56.387  13.880  59.281  1.00  0.00           O  
ATOM    889  CB  MET A  61      55.267  16.408  59.477  1.00  0.00           C  
ATOM    890  CG  MET A  61      54.934  16.005  58.039  1.00  0.00           C  
ATOM    891  SD  MET A  61      55.182  17.392  56.943  1.00  0.00           S  
ATOM    892  CE  MET A  61      53.626  18.239  57.159  1.00  0.00           C  
ATOM    893  H   MET A  61      56.306  15.190  61.958  1.00  0.00           H  
ATOM    894  HA  MET A  61      53.781  15.281  60.601  1.00  0.00           H  
ATOM    895  HB2 MET A  61      54.749  17.334  59.727  1.00  0.00           H  
ATOM    896  HB3 MET A  61      56.335  16.606  59.565  1.00  0.00           H  
ATOM    897  HG2 MET A  61      55.566  15.171  57.731  1.00  0.00           H  
ATOM    898  HG3 MET A  61      53.902  15.663  57.977  1.00  0.00           H  
ATOM    899  HE1 MET A  61      52.816  17.511  57.176  1.00  0.00           H  
ATOM    900  HE2 MET A  61      53.639  18.791  58.099  1.00  0.00           H  
ATOM    901  HE3 MET A  61      53.472  18.933  56.332  1.00  0.00           H  
ATOM    902  N   LEU A  62      54.600  12.921  60.281  1.00  0.00           N  
ATOM    903  CA  LEU A  62      54.950  11.573  59.863  1.00  0.00           C  
ATOM    904  C   LEU A  62      54.404  11.324  58.456  1.00  0.00           C  
ATOM    905  O   LEU A  62      53.206  11.106  58.280  1.00  0.00           O  
ATOM    906  CB  LEU A  62      54.474  10.551  60.897  1.00  0.00           C  
ATOM    907  CG  LEU A  62      54.670  10.940  62.364  1.00  0.00           C  
ATOM    908  CD1 LEU A  62      55.940  11.775  62.546  1.00  0.00           C  
ATOM    909  CD2 LEU A  62      53.433  11.652  62.913  1.00  0.00           C  
ATOM    910  H   LEU A  62      53.764  12.991  60.825  1.00  0.00           H  
ATOM    911  HA  LEU A  62      56.038  11.514  59.827  1.00  0.00           H  
ATOM    912  HB2 LEU A  62      53.414  10.362  60.731  1.00  0.00           H  
ATOM    913  HB3 LEU A  62      54.998   9.613  60.718  1.00  0.00           H  
ATOM    914  HG  LEU A  62      54.800  10.027  62.945  1.00  0.00           H  
ATOM    915 HD11 LEU A  62      56.279  11.700  63.577  1.00  0.00           H  
ATOM    916 HD12 LEU A  62      56.718  11.403  61.878  1.00  0.00           H  
ATOM    917 HD13 LEU A  62      55.725  12.817  62.308  1.00  0.00           H  
ATOM    918 HD21 LEU A  62      52.563  11.381  62.315  1.00  0.00           H  
ATOM    919 HD22 LEU A  62      53.270  11.353  63.948  1.00  0.00           H  
ATOM    920 HD23 LEU A  62      53.583  12.731  62.866  1.00  0.00           H  
ATOM    921  N   VAL A  63      55.310  11.363  57.489  1.00  0.00           N  
ATOM    922  CA  VAL A  63      54.934  11.144  56.102  1.00  0.00           C  
ATOM    923  C   VAL A  63      55.289   9.710  55.703  1.00  0.00           C  
ATOM    924  O   VAL A  63      56.323   9.185  56.116  1.00  0.00           O  
ATOM    925  CB  VAL A  63      55.595  12.195  55.209  1.00  0.00           C  
ATOM    926  CG1 VAL A  63      55.371  11.875  53.729  1.00  0.00           C  
ATOM    927  CG2 VAL A  63      55.090  13.599  55.549  1.00  0.00           C  
ATOM    928  H   VAL A  63      56.282  11.540  57.641  1.00  0.00           H  
ATOM    929  HA  VAL A  63      53.854  11.271  56.031  1.00  0.00           H  
ATOM    930  HB  VAL A  63      56.668  12.169  55.399  1.00  0.00           H  
ATOM    931 HG11 VAL A  63      55.067  12.781  53.204  1.00  0.00           H  
ATOM    932 HG12 VAL A  63      56.297  11.496  53.296  1.00  0.00           H  
ATOM    933 HG13 VAL A  63      54.590  11.121  53.635  1.00  0.00           H  
ATOM    934 HG21 VAL A  63      54.546  14.006  54.696  1.00  0.00           H  
ATOM    935 HG22 VAL A  63      54.428  13.548  56.412  1.00  0.00           H  
ATOM    936 HG23 VAL A  63      55.939  14.243  55.779  1.00  0.00           H  
ATOM    937  N   THR A  64      54.412   9.117  54.905  1.00  0.00           N  
ATOM    938  CA  THR A  64      54.621   7.755  54.446  1.00  0.00           C  
ATOM    939  C   THR A  64      54.738   7.719  52.921  1.00  0.00           C  
ATOM    940  O   THR A  64      54.073   8.485  52.225  1.00  0.00           O  
ATOM    941  CB  THR A  64      53.480   6.894  54.988  1.00  0.00           C  
ATOM    942  OG1 THR A  64      53.505   7.127  56.393  1.00  0.00           O  
ATOM    943  CG2 THR A  64      53.762   5.396  54.855  1.00  0.00           C  
ATOM    944  H   THR A  64      53.575   9.552  54.575  1.00  0.00           H  
ATOM    945  HA  THR A  64      55.569   7.398  54.848  1.00  0.00           H  
ATOM    946  HB  THR A  64      52.534   7.155  54.513  1.00  0.00           H  
ATOM    947  HG1 THR A  64      52.607   6.936  56.789  1.00  0.00           H  
ATOM    948 HG21 THR A  64      53.157   4.982  54.048  1.00  0.00           H  
ATOM    949 HG22 THR A  64      54.818   5.243  54.631  1.00  0.00           H  
ATOM    950 HG23 THR A  64      53.513   4.894  55.790  1.00  0.00           H  
ATOM    951  N   PHE A  65      55.589   6.821  52.446  1.00  0.00           N  
ATOM    952  CA  PHE A  65      55.801   6.675  51.016  1.00  0.00           C  
ATOM    953  C   PHE A  65      55.510   5.243  50.562  1.00  0.00           C  
ATOM    954  O   PHE A  65      55.097   4.406  51.362  1.00  0.00           O  
ATOM    955  CB  PHE A  65      57.274   6.993  50.748  1.00  0.00           C  
ATOM    956  CG  PHE A  65      57.660   8.445  51.041  1.00  0.00           C  
ATOM    957  CD1 PHE A  65      58.051   8.805  52.293  1.00  0.00           C  
ATOM    958  CD2 PHE A  65      57.614   9.374  50.049  1.00  0.00           C  
ATOM    959  CE1 PHE A  65      58.409  10.152  52.565  1.00  0.00           C  
ATOM    960  CE2 PHE A  65      57.972  10.721  50.321  1.00  0.00           C  
ATOM    961  CZ  PHE A  65      58.363  11.081  51.573  1.00  0.00           C  
ATOM    962  H   PHE A  65      56.126   6.203  53.018  1.00  0.00           H  
ATOM    963  HA  PHE A  65      55.116   7.360  50.515  1.00  0.00           H  
ATOM    964  HB2 PHE A  65      57.894   6.333  51.354  1.00  0.00           H  
ATOM    965  HB3 PHE A  65      57.499   6.773  49.704  1.00  0.00           H  
ATOM    966  HD1 PHE A  65      58.088   8.060  53.087  1.00  0.00           H  
ATOM    967  HD2 PHE A  65      57.301   9.086  49.046  1.00  0.00           H  
ATOM    968  HE1 PHE A  65      58.722  10.441  53.568  1.00  0.00           H  
ATOM    969  HE2 PHE A  65      57.935  11.466  49.526  1.00  0.00           H  
ATOM    970  HZ  PHE A  65      58.637  12.115  51.782  1.00  0.00           H  
ATOM    971  N   ALA A  66      55.739   5.005  49.279  1.00  0.00           N  
ATOM    972  CA  ALA A  66      55.506   3.689  48.709  1.00  0.00           C  
ATOM    973  C   ALA A  66      56.778   2.849  48.842  1.00  0.00           C  
ATOM    974  O   ALA A  66      56.729   1.712  49.309  1.00  0.00           O  
ATOM    975  CB  ALA A  66      55.054   3.835  47.253  1.00  0.00           C  
ATOM    976  H   ALA A  66      56.075   5.692  48.634  1.00  0.00           H  
ATOM    977  HA  ALA A  66      54.707   3.217  49.280  1.00  0.00           H  
ATOM    978  HB1 ALA A  66      54.085   3.354  47.125  1.00  0.00           H  
ATOM    979  HB2 ALA A  66      54.970   4.893  47.005  1.00  0.00           H  
ATOM    980  HB3 ALA A  66      55.785   3.364  46.597  1.00  0.00           H  
ATOM    981  N   ASP A  67      57.887   3.441  48.421  1.00  0.00           N  
ATOM    982  CA  ASP A  67      59.169   2.760  48.488  1.00  0.00           C  
ATOM    983  C   ASP A  67      59.949   3.270  49.701  1.00  0.00           C  
ATOM    984  O   ASP A  67      59.580   4.277  50.302  1.00  0.00           O  
ATOM    985  CB  ASP A  67      60.005   3.037  47.238  1.00  0.00           C  
ATOM    986  CG  ASP A  67      59.500   2.365  45.959  1.00  0.00           C  
ATOM    987  OD1 ASP A  67      58.267   2.388  45.755  1.00  0.00           O  
ATOM    988  OD2 ASP A  67      60.359   1.844  45.215  1.00  0.00           O  
ATOM    989  H   ASP A  67      57.918   4.365  48.042  1.00  0.00           H  
ATOM    990  HA  ASP A  67      58.927   1.699  48.563  1.00  0.00           H  
ATOM    991  HB2 ASP A  67      60.041   4.115  47.074  1.00  0.00           H  
ATOM    992  HB3 ASP A  67      61.029   2.711  47.423  1.00  0.00           H  
ATOM    993  N   SER A  68      61.014   2.550  50.025  1.00  0.00           N  
ATOM    994  CA  SER A  68      61.849   2.916  51.156  1.00  0.00           C  
ATOM    995  C   SER A  68      62.997   3.814  50.689  1.00  0.00           C  
ATOM    996  O   SER A  68      63.251   4.860  51.284  1.00  0.00           O  
ATOM    997  CB  SER A  68      62.399   1.674  51.860  1.00  0.00           C  
ATOM    998  OG  SER A  68      63.344   0.978  51.053  1.00  0.00           O  
ATOM    999  H   SER A  68      61.307   1.731  49.531  1.00  0.00           H  
ATOM   1000  HA  SER A  68      61.192   3.458  51.837  1.00  0.00           H  
ATOM   1001  HB2 SER A  68      62.871   1.968  52.799  1.00  0.00           H  
ATOM   1002  HB3 SER A  68      61.576   1.006  52.113  1.00  0.00           H  
ATOM   1003  HG  SER A  68      63.345   0.006  51.287  1.00  0.00           H  
ATOM   1004  N   HIS A  69      63.658   3.372  49.630  1.00  0.00           N  
ATOM   1005  CA  HIS A  69      64.773   4.123  49.078  1.00  0.00           C  
ATOM   1006  C   HIS A  69      64.432   5.613  49.066  1.00  0.00           C  
ATOM   1007  O   HIS A  69      65.219   6.438  49.528  1.00  0.00           O  
ATOM   1008  CB  HIS A  69      65.153   3.590  47.694  1.00  0.00           C  
ATOM   1009  CG  HIS A  69      64.242   4.056  46.585  1.00  0.00           C  
ATOM   1010  ND1 HIS A  69      63.333   3.220  45.960  1.00  0.00           N  
ATOM   1011  CD2 HIS A  69      64.107   5.279  45.996  1.00  0.00           C  
ATOM   1012  CE1 HIS A  69      62.688   3.919  45.038  1.00  0.00           C  
ATOM   1013  NE2 HIS A  69      63.169   5.194  45.061  1.00  0.00           N  
ATOM   1014  H   HIS A  69      63.446   2.519  49.153  1.00  0.00           H  
ATOM   1015  HA  HIS A  69      65.622   3.958  49.742  1.00  0.00           H  
ATOM   1016  HB2 HIS A  69      66.174   3.898  47.466  1.00  0.00           H  
ATOM   1017  HB3 HIS A  69      65.149   2.501  47.722  1.00  0.00           H  
ATOM   1018  HD1 HIS A  69      63.189   2.253  46.170  1.00  0.00           H  
ATOM   1019  HD2 HIS A  69      64.676   6.175  46.250  1.00  0.00           H  
ATOM   1020  HE1 HIS A  69      61.908   3.540  44.376  1.00  0.00           H  
ATOM   1021  N   SER A  70      63.258   5.915  48.532  1.00  0.00           N  
ATOM   1022  CA  SER A  70      62.802   7.292  48.454  1.00  0.00           C  
ATOM   1023  C   SER A  70      63.099   8.018  49.769  1.00  0.00           C  
ATOM   1024  O   SER A  70      63.702   9.090  49.767  1.00  0.00           O  
ATOM   1025  CB  SER A  70      61.307   7.362  48.135  1.00  0.00           C  
ATOM   1026  OG  SER A  70      60.535   6.551  49.017  1.00  0.00           O  
ATOM   1027  H   SER A  70      62.623   5.239  48.159  1.00  0.00           H  
ATOM   1028  HA  SER A  70      63.368   7.737  47.636  1.00  0.00           H  
ATOM   1029  HB2 SER A  70      60.969   8.396  48.205  1.00  0.00           H  
ATOM   1030  HB3 SER A  70      61.140   7.040  47.108  1.00  0.00           H  
ATOM   1031  HG  SER A  70      61.069   5.754  49.303  1.00  0.00           H  
ATOM   1032  N   ALA A  71      62.662   7.403  50.857  1.00  0.00           N  
ATOM   1033  CA  ALA A  71      62.874   7.977  52.176  1.00  0.00           C  
ATOM   1034  C   ALA A  71      64.337   8.399  52.314  1.00  0.00           C  
ATOM   1035  O   ALA A  71      64.626   9.534  52.690  1.00  0.00           O  
ATOM   1036  CB  ALA A  71      62.455   6.965  53.245  1.00  0.00           C  
ATOM   1037  H   ALA A  71      62.173   6.530  50.850  1.00  0.00           H  
ATOM   1038  HA  ALA A  71      62.239   8.858  52.260  1.00  0.00           H  
ATOM   1039  HB1 ALA A  71      61.594   6.397  52.892  1.00  0.00           H  
ATOM   1040  HB2 ALA A  71      63.283   6.284  53.445  1.00  0.00           H  
ATOM   1041  HB3 ALA A  71      62.191   7.493  54.162  1.00  0.00           H  
ATOM   1042  N   LEU A  72      65.222   7.464  52.004  1.00  0.00           N  
ATOM   1043  CA  LEU A  72      66.649   7.726  52.089  1.00  0.00           C  
ATOM   1044  C   LEU A  72      66.958   9.066  51.419  1.00  0.00           C  
ATOM   1045  O   LEU A  72      67.492   9.973  52.055  1.00  0.00           O  
ATOM   1046  CB  LEU A  72      67.445   6.552  51.514  1.00  0.00           C  
ATOM   1047  CG  LEU A  72      68.566   6.916  50.538  1.00  0.00           C  
ATOM   1048  CD1 LEU A  72      69.608   7.813  51.210  1.00  0.00           C  
ATOM   1049  CD2 LEU A  72      69.196   5.660  49.934  1.00  0.00           C  
ATOM   1050  H   LEU A  72      64.979   6.542  51.700  1.00  0.00           H  
ATOM   1051  HA  LEU A  72      66.905   7.801  53.146  1.00  0.00           H  
ATOM   1052  HB2 LEU A  72      67.878   5.992  52.342  1.00  0.00           H  
ATOM   1053  HB3 LEU A  72      66.751   5.884  51.005  1.00  0.00           H  
ATOM   1054  HG  LEU A  72      68.132   7.486  49.717  1.00  0.00           H  
ATOM   1055 HD11 LEU A  72      69.975   8.545  50.492  1.00  0.00           H  
ATOM   1056 HD12 LEU A  72      69.151   8.330  52.055  1.00  0.00           H  
ATOM   1057 HD13 LEU A  72      70.438   7.203  51.565  1.00  0.00           H  
ATOM   1058 HD21 LEU A  72      69.017   4.811  50.593  1.00  0.00           H  
ATOM   1059 HD22 LEU A  72      68.750   5.464  48.959  1.00  0.00           H  
ATOM   1060 HD23 LEU A  72      70.269   5.811  49.818  1.00  0.00           H  
ATOM   1061  N   SER A  73      66.611   9.147  50.144  1.00  0.00           N  
ATOM   1062  CA  SER A  73      66.844  10.362  49.380  1.00  0.00           C  
ATOM   1063  C   SER A  73      66.264  11.567  50.123  1.00  0.00           C  
ATOM   1064  O   SER A  73      66.968  12.542  50.376  1.00  0.00           O  
ATOM   1065  CB  SER A  73      66.236  10.257  47.980  1.00  0.00           C  
ATOM   1066  OG  SER A  73      65.914   8.913  47.636  1.00  0.00           O  
ATOM   1067  H   SER A  73      66.177   8.404  49.634  1.00  0.00           H  
ATOM   1068  HA  SER A  73      67.927  10.447  49.299  1.00  0.00           H  
ATOM   1069  HB2 SER A  73      65.335  10.870  47.930  1.00  0.00           H  
ATOM   1070  HB3 SER A  73      66.936  10.661  47.249  1.00  0.00           H  
ATOM   1071  HG  SER A  73      65.333   8.897  46.823  1.00  0.00           H  
ATOM   1072  N   VAL A  74      64.984  11.458  50.451  1.00  0.00           N  
ATOM   1073  CA  VAL A  74      64.302  12.527  51.160  1.00  0.00           C  
ATOM   1074  C   VAL A  74      65.037  12.816  52.470  1.00  0.00           C  
ATOM   1075  O   VAL A  74      64.970  13.927  52.992  1.00  0.00           O  
ATOM   1076  CB  VAL A  74      62.831  12.161  51.367  1.00  0.00           C  
ATOM   1077  CG1 VAL A  74      62.127  13.197  52.246  1.00  0.00           C  
ATOM   1078  CG2 VAL A  74      62.112  12.001  50.027  1.00  0.00           C  
ATOM   1079  H   VAL A  74      64.419  10.662  50.241  1.00  0.00           H  
ATOM   1080  HA  VAL A  74      64.342  13.417  50.532  1.00  0.00           H  
ATOM   1081  HB  VAL A  74      62.794  11.203  51.884  1.00  0.00           H  
ATOM   1082 HG11 VAL A  74      61.844  12.737  53.194  1.00  0.00           H  
ATOM   1083 HG12 VAL A  74      62.801  14.032  52.436  1.00  0.00           H  
ATOM   1084 HG13 VAL A  74      61.234  13.559  51.738  1.00  0.00           H  
ATOM   1085 HG21 VAL A  74      62.287  10.997  49.638  1.00  0.00           H  
ATOM   1086 HG22 VAL A  74      61.041  12.153  50.168  1.00  0.00           H  
ATOM   1087 HG23 VAL A  74      62.494  12.737  49.319  1.00  0.00           H  
ATOM   1088  N   LEU A  75      65.720  11.794  52.965  1.00  0.00           N  
ATOM   1089  CA  LEU A  75      66.467  11.924  54.205  1.00  0.00           C  
ATOM   1090  C   LEU A  75      67.815  12.587  53.917  1.00  0.00           C  
ATOM   1091  O   LEU A  75      68.402  13.216  54.795  1.00  0.00           O  
ATOM   1092  CB  LEU A  75      66.585  10.567  54.903  1.00  0.00           C  
ATOM   1093  CG  LEU A  75      65.288   9.993  55.477  1.00  0.00           C  
ATOM   1094  CD1 LEU A  75      65.378   8.472  55.617  1.00  0.00           C  
ATOM   1095  CD2 LEU A  75      64.928  10.670  56.801  1.00  0.00           C  
ATOM   1096  H   LEU A  75      65.769  10.893  52.535  1.00  0.00           H  
ATOM   1097  HA  LEU A  75      65.894  12.576  54.865  1.00  0.00           H  
ATOM   1098  HB2 LEU A  75      66.994   9.849  54.192  1.00  0.00           H  
ATOM   1099  HB3 LEU A  75      67.308  10.660  55.713  1.00  0.00           H  
ATOM   1100  HG  LEU A  75      64.481  10.205  54.776  1.00  0.00           H  
ATOM   1101 HD11 LEU A  75      65.132   8.186  56.640  1.00  0.00           H  
ATOM   1102 HD12 LEU A  75      64.674   8.002  54.930  1.00  0.00           H  
ATOM   1103 HD13 LEU A  75      66.390   8.144  55.382  1.00  0.00           H  
ATOM   1104 HD21 LEU A  75      63.889  10.452  57.050  1.00  0.00           H  
ATOM   1105 HD22 LEU A  75      65.577  10.293  57.591  1.00  0.00           H  
ATOM   1106 HD23 LEU A  75      65.060  11.748  56.705  1.00  0.00           H  
ATOM   1107  N   ASP A  76      68.267  12.423  52.682  1.00  0.00           N  
ATOM   1108  CA  ASP A  76      69.535  12.998  52.267  1.00  0.00           C  
ATOM   1109  C   ASP A  76      69.310  14.439  51.806  1.00  0.00           C  
ATOM   1110  O   ASP A  76      69.996  15.354  52.260  1.00  0.00           O  
ATOM   1111  CB  ASP A  76      70.138  12.216  51.098  1.00  0.00           C  
ATOM   1112  CG  ASP A  76      71.564  11.710  51.326  1.00  0.00           C  
ATOM   1113  OD1 ASP A  76      71.800  11.151  52.418  1.00  0.00           O  
ATOM   1114  OD2 ASP A  76      72.385  11.892  50.400  1.00  0.00           O  
ATOM   1115  H   ASP A  76      67.784  11.910  51.973  1.00  0.00           H  
ATOM   1116  HA  ASP A  76      70.178  12.936  53.144  1.00  0.00           H  
ATOM   1117  HB2 ASP A  76      69.495  11.363  50.882  1.00  0.00           H  
ATOM   1118  HB3 ASP A  76      70.132  12.852  50.213  1.00  0.00           H  
ATOM   1119  N   VAL A  77      68.348  14.597  50.909  1.00  0.00           N  
ATOM   1120  CA  VAL A  77      68.025  15.911  50.381  1.00  0.00           C  
ATOM   1121  C   VAL A  77      67.311  16.727  51.460  1.00  0.00           C  
ATOM   1122  O   VAL A  77      67.103  17.929  51.299  1.00  0.00           O  
ATOM   1123  CB  VAL A  77      67.204  15.771  49.097  1.00  0.00           C  
ATOM   1124  CG1 VAL A  77      65.822  15.185  49.390  1.00  0.00           C  
ATOM   1125  CG2 VAL A  77      67.087  17.114  48.373  1.00  0.00           C  
ATOM   1126  H   VAL A  77      67.796  13.847  50.544  1.00  0.00           H  
ATOM   1127  HA  VAL A  77      68.963  16.405  50.130  1.00  0.00           H  
ATOM   1128  HB  VAL A  77      67.728  15.080  48.438  1.00  0.00           H  
ATOM   1129 HG11 VAL A  77      65.638  14.339  48.728  1.00  0.00           H  
ATOM   1130 HG12 VAL A  77      65.782  14.851  50.427  1.00  0.00           H  
ATOM   1131 HG13 VAL A  77      65.061  15.947  49.225  1.00  0.00           H  
ATOM   1132 HG21 VAL A  77      67.474  17.907  49.013  1.00  0.00           H  
ATOM   1133 HG22 VAL A  77      67.665  17.080  47.448  1.00  0.00           H  
ATOM   1134 HG23 VAL A  77      66.041  17.312  48.140  1.00  0.00           H  
ATOM   1135  N   ASP A  78      66.956  16.042  52.537  1.00  0.00           N  
ATOM   1136  CA  ASP A  78      66.270  16.689  53.643  1.00  0.00           C  
ATOM   1137  C   ASP A  78      66.872  18.077  53.869  1.00  0.00           C  
ATOM   1138  O   ASP A  78      66.145  19.052  54.051  1.00  0.00           O  
ATOM   1139  CB  ASP A  78      66.431  15.887  54.936  1.00  0.00           C  
ATOM   1140  CG  ASP A  78      66.286  16.700  56.224  1.00  0.00           C  
ATOM   1141  OD1 ASP A  78      65.383  17.562  56.252  1.00  0.00           O  
ATOM   1142  OD2 ASP A  78      67.084  16.441  57.151  1.00  0.00           O  
ATOM   1143  H   ASP A  78      67.128  15.065  52.661  1.00  0.00           H  
ATOM   1144  HA  ASP A  78      65.223  16.733  53.344  1.00  0.00           H  
ATOM   1145  HB2 ASP A  78      65.690  15.088  54.944  1.00  0.00           H  
ATOM   1146  HB3 ASP A  78      67.412  15.413  54.931  1.00  0.00           H  
ATOM   1147  N   GLY A  79      68.197  18.122  53.850  1.00  0.00           N  
ATOM   1148  CA  GLY A  79      68.906  19.374  54.052  1.00  0.00           C  
ATOM   1149  C   GLY A  79      68.183  20.531  53.359  1.00  0.00           C  
ATOM   1150  O   GLY A  79      68.262  21.674  53.806  1.00  0.00           O  
ATOM   1151  H   GLY A  79      68.781  17.325  53.702  1.00  0.00           H  
ATOM   1152  HA2 GLY A  79      68.991  19.581  55.119  1.00  0.00           H  
ATOM   1153  HA3 GLY A  79      69.920  19.289  53.662  1.00  0.00           H  
ATOM   1154  N   MET A  80      67.494  20.193  52.279  1.00  0.00           N  
ATOM   1155  CA  MET A  80      66.757  21.190  51.520  1.00  0.00           C  
ATOM   1156  C   MET A  80      65.969  22.115  52.449  1.00  0.00           C  
ATOM   1157  O   MET A  80      65.861  21.853  53.646  1.00  0.00           O  
ATOM   1158  CB  MET A  80      65.795  20.491  50.558  1.00  0.00           C  
ATOM   1159  CG  MET A  80      64.599  19.903  51.310  1.00  0.00           C  
ATOM   1160  SD  MET A  80      64.320  18.218  50.792  1.00  0.00           S  
ATOM   1161  CE  MET A  80      62.547  18.125  50.980  1.00  0.00           C  
ATOM   1162  H   MET A  80      67.434  19.261  51.923  1.00  0.00           H  
ATOM   1163  HA  MET A  80      67.511  21.763  50.981  1.00  0.00           H  
ATOM   1164  HB2 MET A  80      65.445  21.200  49.808  1.00  0.00           H  
ATOM   1165  HB3 MET A  80      66.319  19.698  50.025  1.00  0.00           H  
ATOM   1166  HG2 MET A  80      64.781  19.938  52.384  1.00  0.00           H  
ATOM   1167  HG3 MET A  80      63.708  20.502  51.120  1.00  0.00           H  
ATOM   1168  HE1 MET A  80      62.108  17.710  50.074  1.00  0.00           H  
ATOM   1169  HE2 MET A  80      62.305  17.484  51.829  1.00  0.00           H  
ATOM   1170  HE3 MET A  80      62.148  19.124  51.153  1.00  0.00           H  
ATOM   1171  N   LYS A  81      65.437  23.177  51.863  1.00  0.00           N  
ATOM   1172  CA  LYS A  81      64.661  24.142  52.623  1.00  0.00           C  
ATOM   1173  C   LYS A  81      63.317  24.371  51.928  1.00  0.00           C  
ATOM   1174  O   LYS A  81      63.252  24.436  50.701  1.00  0.00           O  
ATOM   1175  CB  LYS A  81      65.467  25.424  52.841  1.00  0.00           C  
ATOM   1176  CG  LYS A  81      66.394  25.290  54.051  1.00  0.00           C  
ATOM   1177  CD  LYS A  81      67.788  25.840  53.737  1.00  0.00           C  
ATOM   1178  CE  LYS A  81      68.872  24.823  54.102  1.00  0.00           C  
ATOM   1179  NZ  LYS A  81      69.571  25.234  55.340  1.00  0.00           N  
ATOM   1180  H   LYS A  81      65.529  23.383  50.888  1.00  0.00           H  
ATOM   1181  HA  LYS A  81      64.473  23.708  53.605  1.00  0.00           H  
ATOM   1182  HB2 LYS A  81      66.055  25.646  51.951  1.00  0.00           H  
ATOM   1183  HB3 LYS A  81      64.788  26.264  52.991  1.00  0.00           H  
ATOM   1184  HG2 LYS A  81      65.971  25.825  54.900  1.00  0.00           H  
ATOM   1185  HG3 LYS A  81      66.470  24.242  54.341  1.00  0.00           H  
ATOM   1186  HD2 LYS A  81      67.855  26.085  52.678  1.00  0.00           H  
ATOM   1187  HD3 LYS A  81      67.950  26.765  54.289  1.00  0.00           H  
ATOM   1188  HE2 LYS A  81      68.426  23.839  54.238  1.00  0.00           H  
ATOM   1189  HE3 LYS A  81      69.588  24.739  53.284  1.00  0.00           H  
ATOM   1190  HZ1 LYS A  81      69.442  26.215  55.487  1.00  0.00           H  
ATOM   1191  HZ2 LYS A  81      69.196  24.729  56.118  1.00  0.00           H  
ATOM   1192  HZ3 LYS A  81      70.547  25.036  55.253  1.00  0.00           H  
ATOM   1193  N   VAL A  82      62.279  24.488  52.742  1.00  0.00           N  
ATOM   1194  CA  VAL A  82      60.940  24.709  52.221  1.00  0.00           C  
ATOM   1195  C   VAL A  82      60.423  26.061  52.712  1.00  0.00           C  
ATOM   1196  O   VAL A  82      60.396  26.321  53.914  1.00  0.00           O  
ATOM   1197  CB  VAL A  82      60.029  23.543  52.609  1.00  0.00           C  
ATOM   1198  CG1 VAL A  82      58.578  23.827  52.215  1.00  0.00           C  
ATOM   1199  CG2 VAL A  82      60.519  22.232  51.990  1.00  0.00           C  
ATOM   1200  H   VAL A  82      62.340  24.434  53.739  1.00  0.00           H  
ATOM   1201  HA  VAL A  82      61.011  24.733  51.133  1.00  0.00           H  
ATOM   1202  HB  VAL A  82      60.066  23.435  53.694  1.00  0.00           H  
ATOM   1203 HG11 VAL A  82      58.265  23.118  51.448  1.00  0.00           H  
ATOM   1204 HG12 VAL A  82      57.936  23.721  53.090  1.00  0.00           H  
ATOM   1205 HG13 VAL A  82      58.499  24.841  51.826  1.00  0.00           H  
ATOM   1206 HG21 VAL A  82      60.556  22.335  50.906  1.00  0.00           H  
ATOM   1207 HG22 VAL A  82      61.516  22.004  52.368  1.00  0.00           H  
ATOM   1208 HG23 VAL A  82      59.836  21.426  52.257  1.00  0.00           H  
ATOM   1209  N   LYS A  83      60.025  26.889  51.756  1.00  0.00           N  
ATOM   1210  CA  LYS A  83      59.510  28.209  52.077  1.00  0.00           C  
ATOM   1211  C   LYS A  83      60.582  29.002  52.828  1.00  0.00           C  
ATOM   1212  O   LYS A  83      60.263  29.828  53.683  1.00  0.00           O  
ATOM   1213  CB  LYS A  83      58.184  28.099  52.833  1.00  0.00           C  
ATOM   1214  CG  LYS A  83      57.030  28.659  51.999  1.00  0.00           C  
ATOM   1215  CD  LYS A  83      56.760  27.781  50.775  1.00  0.00           C  
ATOM   1216  CE  LYS A  83      55.516  28.257  50.022  1.00  0.00           C  
ATOM   1217  NZ  LYS A  83      55.674  28.034  48.568  1.00  0.00           N  
ATOM   1218  H   LYS A  83      60.050  26.671  50.781  1.00  0.00           H  
ATOM   1219  HA  LYS A  83      59.303  28.717  51.134  1.00  0.00           H  
ATOM   1220  HB2 LYS A  83      57.987  27.055  53.078  1.00  0.00           H  
ATOM   1221  HB3 LYS A  83      58.252  28.640  53.775  1.00  0.00           H  
ATOM   1222  HG2 LYS A  83      56.131  28.721  52.612  1.00  0.00           H  
ATOM   1223  HG3 LYS A  83      57.267  29.673  51.678  1.00  0.00           H  
ATOM   1224  HD2 LYS A  83      57.623  27.803  50.110  1.00  0.00           H  
ATOM   1225  HD3 LYS A  83      56.627  26.745  51.089  1.00  0.00           H  
ATOM   1226  HE2 LYS A  83      54.638  27.723  50.384  1.00  0.00           H  
ATOM   1227  HE3 LYS A  83      55.348  29.315  50.218  1.00  0.00           H  
ATOM   1228  HZ1 LYS A  83      56.256  28.751  48.182  1.00  0.00           H  
ATOM   1229  HZ2 LYS A  83      56.097  27.142  48.411  1.00  0.00           H  
ATOM   1230  HZ3 LYS A  83      54.777  28.060  48.127  1.00  0.00           H  
ATOM   1231  N   GLY A  84      61.830  28.722  52.484  1.00  0.00           N  
ATOM   1232  CA  GLY A  84      62.951  29.397  53.115  1.00  0.00           C  
ATOM   1233  C   GLY A  84      63.168  28.884  54.540  1.00  0.00           C  
ATOM   1234  O   GLY A  84      63.965  29.445  55.290  1.00  0.00           O  
ATOM   1235  H   GLY A  84      62.081  28.048  51.789  1.00  0.00           H  
ATOM   1236  HA2 GLY A  84      63.854  29.241  52.526  1.00  0.00           H  
ATOM   1237  HA3 GLY A  84      62.767  30.472  53.136  1.00  0.00           H  
ATOM   1238  N   ARG A  85      62.445  27.825  54.870  1.00  0.00           N  
ATOM   1239  CA  ARG A  85      62.548  27.229  56.192  1.00  0.00           C  
ATOM   1240  C   ARG A  85      63.321  25.910  56.121  1.00  0.00           C  
ATOM   1241  O   ARG A  85      63.049  25.074  55.261  1.00  0.00           O  
ATOM   1242  CB  ARG A  85      61.164  26.970  56.790  1.00  0.00           C  
ATOM   1243  CG  ARG A  85      60.437  28.286  57.079  1.00  0.00           C  
ATOM   1244  CD  ARG A  85      60.948  28.923  58.372  1.00  0.00           C  
ATOM   1245  NE  ARG A  85      61.463  30.283  58.098  1.00  0.00           N  
ATOM   1246  CZ  ARG A  85      61.719  31.194  59.046  1.00  0.00           C  
ATOM   1247  NH1 ARG A  85      61.510  30.896  60.336  1.00  0.00           N  
ATOM   1248  NH2 ARG A  85      62.183  32.403  58.705  1.00  0.00           N  
ATOM   1249  H   ARG A  85      61.798  27.376  54.254  1.00  0.00           H  
ATOM   1250  HA  ARG A  85      63.086  27.967  56.788  1.00  0.00           H  
ATOM   1251  HB2 ARG A  85      60.573  26.368  56.100  1.00  0.00           H  
ATOM   1252  HB3 ARG A  85      61.263  26.395  57.711  1.00  0.00           H  
ATOM   1253  HG2 ARG A  85      60.582  28.975  56.247  1.00  0.00           H  
ATOM   1254  HG3 ARG A  85      59.365  28.102  57.158  1.00  0.00           H  
ATOM   1255  HD2 ARG A  85      60.144  28.969  59.107  1.00  0.00           H  
ATOM   1256  HD3 ARG A  85      61.737  28.306  58.804  1.00  0.00           H  
ATOM   1257  HE  ARG A  85      61.630  30.537  57.146  1.00  0.00           H  
ATOM   1258 HH11 ARG A  85      61.162  29.994  60.591  1.00  0.00           H  
ATOM   1259 HH12 ARG A  85      61.700  31.577  61.044  1.00  0.00           H  
ATOM   1260 HH21 ARG A  85      62.339  32.626  57.742  1.00  0.00           H  
ATOM   1261 HH22 ARG A  85      62.375  33.084  59.413  1.00  0.00           H  
ATOM   1262  N   ALA A  86      64.267  25.767  57.036  1.00  0.00           N  
ATOM   1263  CA  ALA A  86      65.080  24.563  57.088  1.00  0.00           C  
ATOM   1264  C   ALA A  86      64.245  23.412  57.652  1.00  0.00           C  
ATOM   1265  O   ALA A  86      63.677  23.527  58.737  1.00  0.00           O  
ATOM   1266  CB  ALA A  86      66.338  24.832  57.917  1.00  0.00           C  
ATOM   1267  H   ALA A  86      64.482  26.452  57.733  1.00  0.00           H  
ATOM   1268  HA  ALA A  86      65.378  24.320  56.068  1.00  0.00           H  
ATOM   1269  HB1 ALA A  86      66.699  23.897  58.345  1.00  0.00           H  
ATOM   1270  HB2 ALA A  86      67.110  25.262  57.278  1.00  0.00           H  
ATOM   1271  HB3 ALA A  86      66.101  25.531  58.720  1.00  0.00           H  
ATOM   1272  N   VAL A  87      64.199  22.330  56.891  1.00  0.00           N  
ATOM   1273  CA  VAL A  87      63.442  21.158  57.301  1.00  0.00           C  
ATOM   1274  C   VAL A  87      64.406  20.094  57.830  1.00  0.00           C  
ATOM   1275  O   VAL A  87      65.588  20.099  57.493  1.00  0.00           O  
ATOM   1276  CB  VAL A  87      62.579  20.659  56.141  1.00  0.00           C  
ATOM   1277  CG1 VAL A  87      63.321  20.796  54.809  1.00  0.00           C  
ATOM   1278  CG2 VAL A  87      62.130  19.216  56.373  1.00  0.00           C  
ATOM   1279  H   VAL A  87      64.663  22.244  56.010  1.00  0.00           H  
ATOM   1280  HA  VAL A  87      62.777  21.463  58.109  1.00  0.00           H  
ATOM   1281  HB  VAL A  87      61.687  21.284  56.092  1.00  0.00           H  
ATOM   1282 HG11 VAL A  87      64.348  20.453  54.928  1.00  0.00           H  
ATOM   1283 HG12 VAL A  87      62.821  20.190  54.051  1.00  0.00           H  
ATOM   1284 HG13 VAL A  87      63.319  21.840  54.497  1.00  0.00           H  
ATOM   1285 HG21 VAL A  87      61.599  19.148  57.322  1.00  0.00           H  
ATOM   1286 HG22 VAL A  87      61.467  18.906  55.564  1.00  0.00           H  
ATOM   1287 HG23 VAL A  87      63.002  18.562  56.397  1.00  0.00           H  
ATOM   1288  N   LYS A  88      63.863  19.207  58.652  1.00  0.00           N  
ATOM   1289  CA  LYS A  88      64.660  18.139  59.232  1.00  0.00           C  
ATOM   1290  C   LYS A  88      63.809  16.872  59.335  1.00  0.00           C  
ATOM   1291  O   LYS A  88      62.794  16.857  60.028  1.00  0.00           O  
ATOM   1292  CB  LYS A  88      65.265  18.585  60.564  1.00  0.00           C  
ATOM   1293  CG  LYS A  88      66.767  18.295  60.610  1.00  0.00           C  
ATOM   1294  CD  LYS A  88      67.382  18.800  61.916  1.00  0.00           C  
ATOM   1295  CE  LYS A  88      68.564  17.925  62.338  1.00  0.00           C  
ATOM   1296  NZ  LYS A  88      68.943  18.206  63.742  1.00  0.00           N  
ATOM   1297  H   LYS A  88      62.901  19.211  58.922  1.00  0.00           H  
ATOM   1298  HA  LYS A  88      65.489  17.944  58.551  1.00  0.00           H  
ATOM   1299  HB2 LYS A  88      65.092  19.651  60.709  1.00  0.00           H  
ATOM   1300  HB3 LYS A  88      64.766  18.067  61.384  1.00  0.00           H  
ATOM   1301  HG2 LYS A  88      66.937  17.223  60.514  1.00  0.00           H  
ATOM   1302  HG3 LYS A  88      67.258  18.772  59.763  1.00  0.00           H  
ATOM   1303  HD2 LYS A  88      67.715  19.830  61.791  1.00  0.00           H  
ATOM   1304  HD3 LYS A  88      66.628  18.801  62.702  1.00  0.00           H  
ATOM   1305  HE2 LYS A  88      68.303  16.873  62.230  1.00  0.00           H  
ATOM   1306  HE3 LYS A  88      69.415  18.110  61.682  1.00  0.00           H  
ATOM   1307  HZ1 LYS A  88      68.996  17.348  64.251  1.00  0.00           H  
ATOM   1308  HZ2 LYS A  88      69.833  18.662  63.762  1.00  0.00           H  
ATOM   1309  HZ3 LYS A  88      68.255  18.800  64.159  1.00  0.00           H  
ATOM   1310  N   ILE A  89      64.255  15.839  58.633  1.00  0.00           N  
ATOM   1311  CA  ILE A  89      63.546  14.571  58.638  1.00  0.00           C  
ATOM   1312  C   ILE A  89      64.333  13.556  59.469  1.00  0.00           C  
ATOM   1313  O   ILE A  89      65.560  13.512  59.404  1.00  0.00           O  
ATOM   1314  CB  ILE A  89      63.267  14.109  57.206  1.00  0.00           C  
ATOM   1315  CG1 ILE A  89      62.615  15.224  56.387  1.00  0.00           C  
ATOM   1316  CG2 ILE A  89      62.430  12.828  57.197  1.00  0.00           C  
ATOM   1317  CD1 ILE A  89      63.145  15.232  54.952  1.00  0.00           C  
ATOM   1318  H   ILE A  89      65.081  15.860  58.072  1.00  0.00           H  
ATOM   1319  HA  ILE A  89      62.581  14.737  59.117  1.00  0.00           H  
ATOM   1320  HB  ILE A  89      64.219  13.875  56.730  1.00  0.00           H  
ATOM   1321 HG12 ILE A  89      61.534  15.091  56.379  1.00  0.00           H  
ATOM   1322 HG13 ILE A  89      62.814  16.188  56.857  1.00  0.00           H  
ATOM   1323 HG21 ILE A  89      62.449  12.388  56.199  1.00  0.00           H  
ATOM   1324 HG22 ILE A  89      62.843  12.119  57.915  1.00  0.00           H  
ATOM   1325 HG23 ILE A  89      61.401  13.064  57.470  1.00  0.00           H  
ATOM   1326 HD11 ILE A  89      63.824  14.391  54.810  1.00  0.00           H  
ATOM   1327 HD12 ILE A  89      62.311  15.148  54.256  1.00  0.00           H  
ATOM   1328 HD13 ILE A  89      63.681  16.164  54.767  1.00  0.00           H  
ATOM   1329  N   SER A  90      63.594  12.763  60.232  1.00  0.00           N  
ATOM   1330  CA  SER A  90      64.206  11.752  61.074  1.00  0.00           C  
ATOM   1331  C   SER A  90      63.608  10.379  60.762  1.00  0.00           C  
ATOM   1332  O   SER A  90      62.712  10.262  59.928  1.00  0.00           O  
ATOM   1333  CB  SER A  90      64.023  12.085  62.557  1.00  0.00           C  
ATOM   1334  OG  SER A  90      65.059  11.528  63.361  1.00  0.00           O  
ATOM   1335  H   SER A  90      62.595  12.805  60.279  1.00  0.00           H  
ATOM   1336  HA  SER A  90      65.267  11.773  60.827  1.00  0.00           H  
ATOM   1337  HB2 SER A  90      64.007  13.167  62.685  1.00  0.00           H  
ATOM   1338  HB3 SER A  90      63.058  11.708  62.897  1.00  0.00           H  
ATOM   1339  HG  SER A  90      65.915  12.021  63.207  1.00  0.00           H  
ATOM   1340  N   GLY A  91      64.130   9.371  61.449  1.00  0.00           N  
ATOM   1341  CA  GLY A  91      63.659   8.010  61.254  1.00  0.00           C  
ATOM   1342  C   GLY A  91      62.855   7.530  62.464  1.00  0.00           C  
ATOM   1343  O   GLY A  91      63.426   7.221  63.509  1.00  0.00           O  
ATOM   1344  H   GLY A  91      64.859   9.474  62.125  1.00  0.00           H  
ATOM   1345  HA2 GLY A  91      63.039   7.960  60.358  1.00  0.00           H  
ATOM   1346  HA3 GLY A  91      64.509   7.347  61.091  1.00  0.00           H  
ATOM   1347  N   PRO A  92      61.509   7.483  62.278  1.00  0.00           N  
ATOM   1348  CA  PRO A  92      60.621   7.045  63.341  1.00  0.00           C  
ATOM   1349  C   PRO A  92      60.685   5.528  63.520  1.00  0.00           C  
ATOM   1350  O   PRO A  92      59.675   4.839  63.382  1.00  0.00           O  
ATOM   1351  CB  PRO A  92      59.243   7.537  62.931  1.00  0.00           C  
ATOM   1352  CG  PRO A  92      59.329   7.822  61.440  1.00  0.00           C  
ATOM   1353  CD  PRO A  92      60.799   7.842  61.053  1.00  0.00           C  
ATOM   1354  HA  PRO A  92      60.909   7.436  64.216  1.00  0.00           H  
ATOM   1355  HB2 PRO A  92      58.481   6.787  63.142  1.00  0.00           H  
ATOM   1356  HB3 PRO A  92      58.967   8.435  63.485  1.00  0.00           H  
ATOM   1357  HG2 PRO A  92      58.795   7.059  60.873  1.00  0.00           H  
ATOM   1358  HG3 PRO A  92      58.860   8.778  61.207  1.00  0.00           H  
ATOM   1359  HD2 PRO A  92      61.008   7.133  60.252  1.00  0.00           H  
ATOM   1360  HD3 PRO A  92      61.101   8.825  60.695  1.00  0.00           H  
ATOM   1361  N   SER A  93      61.883   5.049  63.824  1.00  0.00           N  
ATOM   1362  CA  SER A  93      62.092   3.625  64.023  1.00  0.00           C  
ATOM   1363  C   SER A  93      63.078   3.396  65.170  1.00  0.00           C  
ATOM   1364  O   SER A  93      64.153   3.993  65.198  1.00  0.00           O  
ATOM   1365  CB  SER A  93      62.602   2.959  62.743  1.00  0.00           C  
ATOM   1366  OG  SER A  93      61.606   2.926  61.724  1.00  0.00           O  
ATOM   1367  H   SER A  93      62.699   5.616  63.935  1.00  0.00           H  
ATOM   1368  HA  SER A  93      61.112   3.222  64.275  1.00  0.00           H  
ATOM   1369  HB2 SER A  93      63.476   3.498  62.378  1.00  0.00           H  
ATOM   1370  HB3 SER A  93      62.925   1.943  62.967  1.00  0.00           H  
ATOM   1371  HG  SER A  93      61.860   3.542  60.978  1.00  0.00           H  
ATOM   1372  N   SER A  94      62.677   2.528  66.088  1.00  0.00           N  
ATOM   1373  CA  SER A  94      63.512   2.213  67.234  1.00  0.00           C  
ATOM   1374  C   SER A  94      62.954   0.992  67.968  1.00  0.00           C  
ATOM   1375  O   SER A  94      61.845   1.034  68.497  1.00  0.00           O  
ATOM   1376  CB  SER A  94      63.612   3.406  68.188  1.00  0.00           C  
ATOM   1377  OG  SER A  94      64.935   3.932  68.249  1.00  0.00           O  
ATOM   1378  H   SER A  94      61.801   2.047  66.058  1.00  0.00           H  
ATOM   1379  HA  SER A  94      64.498   1.995  66.822  1.00  0.00           H  
ATOM   1380  HB2 SER A  94      62.925   4.188  67.863  1.00  0.00           H  
ATOM   1381  HB3 SER A  94      63.297   3.099  69.186  1.00  0.00           H  
ATOM   1382  HG  SER A  94      65.323   3.988  67.330  1.00  0.00           H  
ATOM   1383  N   GLY A  95      63.750  -0.067  67.976  1.00  0.00           N  
ATOM   1384  CA  GLY A  95      63.350  -1.298  68.636  1.00  0.00           C  
ATOM   1385  C   GLY A  95      63.943  -1.385  70.044  1.00  0.00           C  
ATOM   1386  O   GLY A  95      64.943  -0.731  70.341  1.00  0.00           O  
ATOM   1387  H   GLY A  95      64.652  -0.094  67.543  1.00  0.00           H  
ATOM   1388  HA2 GLY A  95      62.262  -1.349  68.692  1.00  0.00           H  
ATOM   1389  HA3 GLY A  95      63.677  -2.155  68.047  1.00  0.00           H  
TER    1390      GLY A  95                                                      
END
MOLECULE T0487_26_96.pdb
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
END
