
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 (  634),  selected   78 , name 1h6k_Z
# Molecule2: number of CA atoms   71 (  558),  selected   71 , name T0487_26_96.pdb
# PARAMETERS: 1h6k_Z.T0487_26_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K    38_Z      -       -           -
LGA    S    39_Z      P      26          6.009
LGA    C    40_Z      W      27          1.828
LGA    T    41_Z      R      28          1.728
LGA    L    42_Z      L      29          1.220
LGA    Y    43_Z      E      30          0.838
LGA    V    44_Z      V      31          0.629
LGA    G    45_Z      V      32          1.268
LGA    N    46_Z      L      33          2.729
LGA    L    47_Z      D      34          4.518
LGA    -       -      P      35           -
LGA    S    48_Z      P      36          2.429
LGA    F    49_Z      P      37          2.432
LGA    Y    50_Z      G      38          2.489
LGA    -       -      R      39           -
LGA    -       -      E      40           -
LGA    T    51_Z      E      41          3.181
LGA    T    52_Z      V      42          3.087
LGA    E    53_Z      Y      43          1.672
LGA    E    54_Z      P      44          2.464
LGA    Q    55_Z      L      45          2.758
LGA    I    56_Z      L      46          1.894
LGA    Y    57_Z      A      47          1.303
LGA    E    58_Z      Q      48          2.825
LGA    L    59_Z      V      49          3.369
LGA    F    60_Z      A      50          1.838
LGA    S    61_Z      R      51          2.029
LGA    K    62_Z      R      52          4.034
LGA    -       -      A      53           -
LGA    S    63_Z      G      54          0.313
LGA    G    64_Z      G      55          2.486
LGA    D    65_Z      V      56          2.892
LGA    I    66_Z      T      57          2.964
LGA    K    67_Z      V      58          3.980
LGA    K    68_Z      R      59          3.653
LGA    I    69_Z      M      60          2.364
LGA    I    70_Z      G      61          1.213
LGA    M    71_Z      D      62          2.227
LGA    G    72_Z      -       -           -
LGA    L    73_Z      -       -           -
LGA    D    74_Z      -       -           -
LGA    K    75_Z      -       -           -
LGA    M    76_Z      -       -           -
LGA    K    77_Z      -       -           -
LGA    C    81_Z      -       -           -
LGA    G    82_Z      -       -           -
LGA    F    83_Z      -       -           -
LGA    C    84_Z      -       -           -
LGA    F    85_Z      G      63          1.039
LGA    V    86_Z      L      64          0.463
LGA    E    87_Z      A      65          0.473
LGA    Y    88_Z      S      66          1.428
LGA    Y    89_Z      W      67          2.481
LGA    S    90_Z      S      68          2.407
LGA    R    91_Z      P      69          2.285
LGA    A    92_Z      -       -           -
LGA    D    93_Z      -       -           -
LGA    A    94_Z      P      70           #
LGA    E    95_Z      E      71          2.932
LGA    N    96_Z      V      72          2.957
LGA    A    97_Z      L      73          2.621
LGA    M    98_Z      V      74          3.873
LGA    R    99_Z      L      75          4.598
LGA    Y   100_Z      -       -           -
LGA    I   101_Z      -       -           -
LGA    N   102_Z      -       -           -
LGA    G   103_Z      E      76          2.913
LGA    T   104_Z      G      77          1.778
LGA    R   105_Z      T      78          1.545
LGA    L   106_Z      L      79          2.592
LGA    D   107_Z      A      80          4.624
LGA    -       -      R      81           -
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    -       -      Q      84           -
LGA    D   108_Z      T      85          2.621
LGA    R   109_Z      Y      86          2.612
LGA    I   110_Z      A      87          2.209
LGA    I   111_Z      Y      88          1.494
LGA    R   112_Z      R      89          1.278
LGA    T   113_Z      L      90          0.900
LGA    D   114_Z      Y      91          1.486
LGA    W   115_Z      P      92          0.575
LGA    D   116_Z      K      93          0.815
LGA    A   117_Z      G      94          2.000
LGA    G   118_Z      R      95          5.701
LGA    -       -      R      96           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78   71    5.0     61    2.65    11.48     59.131     2.220

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.547723 * X  +   0.701113 * Y  +  -0.456553 * Z  +  -3.568049
  Y_new =   0.736936 * X  +   0.662647 * Y  +   0.133509 * Z  + -47.090145
  Z_new =   0.396138 * X  +  -0.263324 * Y  +  -0.879622 * Z  +  80.094971 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.850723    0.290870  [ DEG:  -163.3344     16.6656 ]
  Theta =  -0.407307   -2.734285  [ DEG:   -23.3370   -156.6630 ]
  Phi   =   2.209959   -0.931634  [ DEG:   126.6213    -53.3787 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1h6k_Z                                        
REMARK     2: T0487_26_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1h6k_Z.T0487_26_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78   71   5.0   61   2.65   11.48  59.131
REMARK  ---------------------------------------------------------- 
MOLECULE 1h6k_Z
HEADER    NUCLEAR PROTEIN                         18-JUN-01   1H6K              
TITLE     NUCLEAR CAP BINDING COMPLEX                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CBP80;                                                     
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: MIF4G DOMAIN;                                              
COMPND   5 SYNONYM: NCBP 80 KDA SUBUNIT, CBP80;                                 
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES;                                                       
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: 20 KDA NUCLEAR CAP BINDING PROTEIN;                        
COMPND  10 CHAIN: X, Y;                                                         
COMPND  11 FRAGMENT: RNP DOMAIN;                                                
COMPND  12 SYNONYM: CBP20, NCBP 20 KDA SUBUNIT;                                 
COMPND  13 MOL_ID: 3;                                                           
COMPND  14 MOLECULE: 20 KDA NUCLEAR CAP BINDING PROTEIN;                        
COMPND  15 CHAIN: Z;                                                            
COMPND  16 FRAGMENT: RNP DOMAIN;                                                
COMPND  17 SYNONYM: CBP20, NCBP 20 KDA SUBUNIT                                  
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: TRICHOPLUSIA NI;                                  
SOURCE   5 EXPRESSION_SYSTEM_CELL_LINE: HIGH FIVE;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: BACULOVIRUS;                               
SOURCE   7 OTHER_DETAILS: EXPRESSION IN INSECT CELLS;                           
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  10 ORGANISM_COMMON: HUMAN;                                              
SOURCE  11 MOL_ID: 3;                                                           
SOURCE  12 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  13 ORGANISM_COMMON: HUMAN                                               
KEYWDS    M7G CAP, CAP-BINDING-COMPLEX, RNP DOMAIN, MIF4G DOMAIN, RNA           
KEYWDS   2 MATURATION, RNA EXPORT, CRYSTAL STRUCTURE, NUCLEAR PROTEIN           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.MAZZA,M.OHNO,A.SEGREF,I.W.MATTAJ,S.CUSACK                           
REVDAT   2   01-APR-03 1H6K    1       JRNL                                     
REVDAT   1   13-SEP-01 1H6K    0                                                
JRNL        AUTH   C.MAZZA,M.OHNO,A.SEGREF,I.W.MATTAJ,S.CUSACK                  
JRNL        TITL   CRYSTAL STRUCTURE OF THE HUMAN NUCLEAR CAP BINDING           
JRNL        TITL 2 COMPLEX.                                                     
JRNL        REF    MOL.CELL                      V.   8   383 2001              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1H6K A   20   670  UNP    Q09161   CB80_HUMAN      20    790             
DBREF  1H6K B   20   670  UNP    Q09161   CB80_HUMAN      20    790             
DBREF  1H6K C   20   670  UNP    Q09161   CB80_HUMAN      20    790             
DBREF  1H6K X   22    76  UNP             CB20_HUMAN      22    120             
DBREF  1H6K Y   22    76  UNP    P52298   CB20_HUMAN      22    120             
DBREF  1H6K Z   22    76  UNP    P52298   NCBP2_HUMAN     22    120             
SEQRES   1 A  757  LYS THR SER ASP ALA ASN GLU THR GLU ASP HIS LEU GLU          
SEQRES   2 A  757  SER LEU ILE CYS LYS VAL GLY GLU LYS SER ALA CYS SER          
SEQRES   3 A  757  LEU GLU SER ASN LEU GLU GLY LEU ALA GLY VAL LEU GLU          
SEQRES   4 A  757  ALA ASP LEU PRO ASN TYR LYS SER LYS ILE LEU ARG LEU          
SEQRES   5 A  757  LEU CYS THR VAL ALA ARG LEU LEU PRO GLU LYS LEU THR          
SEQRES   6 A  757  ILE TYR THR THR LEU VAL GLY LEU LEU ASN ALA ARG ASN          
SEQRES   7 A  757  TYR ASN PHE GLY GLY GLU PHE VAL GLU ALA MET ILE ARG          
SEQRES   8 A  757  GLN LEU LYS GLU SER LEU LYS ALA ASN ASN TYR ASN GLU          
SEQRES   9 A  757  ALA VAL TYR LEU VAL ARG PHE LEU SER ASP LEU VAL ASN          
SEQRES  10 A  757  CYS HIS VAL ILE ALA ALA PRO SER MET VAL ALA MET PHE          
SEQRES  11 A  757  GLU ASN PHE VAL SER VAL THR GLN GLU GLU ASP VAL PRO          
SEQRES  12 A  757  GLN VAL ARG ARG ASP TRP TYR VAL TYR ALA PHE LEU SER          
SEQRES  13 A  757  SER LEU PRO TRP VAL GLY LYS GLU LEU TYR GLU LYS LYS          
SEQRES  14 A  757  ASP ALA GLU MET ASP ARG ILE PHE ALA ASN THR GLU SER          
SEQRES  15 A  757  TYR LEU LYS ARG ARG GLN LYS THR HIS VAL PRO MET LEU          
SEQRES  16 A  757  GLN VAL TRP THR ALA ASP LYS PRO HIS PRO GLN GLU GLU          
SEQRES  17 A  757  TYR LEU ASP CYS LEU TRP ALA GLN ILE GLN LYS LEU LYS          
SEQRES  18 A  757  LYS ASP ARG TRP GLN GLU ARG HIS ILE LEU ARG PRO TYR          
SEQRES  19 A  757  LEU ALA PHE ASP SER ILE LEU CYS GLU ALA LEU GLN HIS          
SEQRES  20 A  757  ASN LEU PRO PRO PHE THR PRO PRO PRO HIS THR GLU ASP          
SEQRES  21 A  757  SER VAL TYR PRO MET PRO ARG VAL ILE PHE ARG MET PHE          
SEQRES  22 A  757  ASP TYR THR ASP ASP PRO GLU GLY PRO VAL MET PRO GLY          
SEQRES  23 A  757  SER HIS SER VAL GLU ARG PHE VAL ILE GLU GLU ASN LEU          
SEQRES  24 A  757  HIS CYS ILE ILE LYS SER HIS TRP LYS GLU ARG LYS THR          
SEQRES  25 A  757  CYS ALA ALA GLN LEU VAL SER TYR PRO GLY LYS ASN LYS          
SEQRES  26 A  757  ILE PRO LEU ASN TYR HIS ILE VAL GLU VAL ILE PHE ALA          
SEQRES  27 A  757  GLU LEU PHE GLN LEU PRO ALA PRO PRO HIS ILE ASP VAL          
SEQRES  28 A  757  MET TYR THR THR LEU LEU ILE GLU LEU CYS LYS LEU GLN          
SEQRES  29 A  757  PRO GLY SER LEU PRO GLN VAL LEU ALA GLN ALA THR GLU          
SEQRES  30 A  757  MET LEU TYR MET ARG LEU ASP THR MET ASN THR THR CYS          
SEQRES  31 A  757  VAL ASP ARG PHE ILE ASN TRP PHE SER HIS HIS LEU SER          
SEQRES  32 A  757  ASN PHE GLN PHE ARG TRP SER TRP GLU ASP TRP SER ASP          
SEQRES  33 A  757  CYS LEU SER GLN ASP PRO GLU SER PRO LYS PRO LYS PHE          
SEQRES  34 A  757  VAL ARG GLU VAL LEU GLU LYS CYS MET ARG LEU SER TYR          
SEQRES  35 A  757  HIS GLN ARG ILE LEU ASP ILE VAL PRO PRO THR PHE SER          
SEQRES  36 A  757  ALA LEU CYS PRO SER ASN PRO THR CYS ILE TYR LYS TYR          
SEQRES  37 A  757  GLY ASP GLU SER SER ASN SER LEU PRO GLY HIS SER VAL          
SEQRES  38 A  757  ALA LEU CYS LEU ALA VAL ALA PHE LYS SER LYS ALA THR          
SEQRES  39 A  757  ASN ASP GLU ILE PHE SER ILE LEU LYS ASP VAL PRO ASN          
SEQRES  40 A  757  PRO ASN GLN ASP ASP ASP ASP ASP GLU GLY PHE SER PHE          
SEQRES  41 A  757  ASN PRO LEU LYS ILE GLU VAL PHE VAL GLN THR LEU LEU          
SEQRES  42 A  757  HIS LEU ALA ALA LYS SER PHE SER HIS SER PHE SER ALA          
SEQRES  43 A  757  LEU ALA LYS PHE HIS GLU VAL PHE LYS THR LEU ALA GLU          
SEQRES  44 A  757  SER ASP GLU GLY LYS LEU HIS VAL LEU ARG VAL MET PHE          
SEQRES  45 A  757  GLU VAL TRP ARG ASN HIS PRO GLN MET ILE ALA VAL LEU          
SEQRES  46 A  757  VAL ASP LYS MET ILE ARG THR GLN ILE VAL ASP CYS ALA          
SEQRES  47 A  757  ALA VAL ALA ASN TRP ILE PHE SER SER GLU LEU SER ARG          
SEQRES  48 A  757  ASP PHE THR ARG LEU PHE VAL TRP GLU ILE LEU HIS SER          
SEQRES  49 A  757  THR ILE ARG LYS MET ASN LYS HIS VAL LEU LYS ILE GLN          
SEQRES  50 A  757  LYS GLU LEU GLU GLU ALA LYS GLU LYS LEU ALA ARG GLN          
SEQRES  51 A  757  HIS ASP GLY VAL LEU GLU GLU GLN ILE GLU ARG LEU GLN          
SEQRES  52 A  757  GLU LYS VAL GLU SER ALA GLN SER GLU GLN LYS ASN LEU          
SEQRES  53 A  757  PHE LEU VAL ILE PHE GLN ARG PHE ILE MET ILE LEU THR          
SEQRES  54 A  757  GLU HIS LEU VAL ARG CYS GLU THR ASP GLY THR SER VAL          
SEQRES  55 A  757  LEU THR PRO TRP TYR LYS ASN CYS ILE GLU ARG LEU GLN          
SEQRES  56 A  757  GLN ILE PHE LEU GLN HIS HIS GLN ILE ILE GLN GLN TYR          
SEQRES  57 A  757  MET VAL THR LEU GLU ASN LEU LEU PHE THR ALA GLU LEU          
SEQRES  58 A  757  ASP PRO HIS ILE LEU ALA VAL PHE GLN GLN PHE CYS ALA          
SEQRES  59 A  757  LEU GLN ALA                                                  
SEQRES   1 B  757  LYS THR SER ASP ALA ASN GLU THR GLU ASP HIS LEU GLU          
SEQRES   2 B  757  SER LEU ILE CYS LYS VAL GLY GLU LYS SER ALA CYS SER          
SEQRES   3 B  757  LEU GLU SER ASN LEU GLU GLY LEU ALA GLY VAL LEU GLU          
SEQRES   4 B  757  ALA ASP LEU PRO ASN TYR LYS SER LYS ILE LEU ARG LEU          
SEQRES   5 B  757  LEU CYS THR VAL ALA ARG LEU LEU PRO GLU LYS LEU THR          
SEQRES   6 B  757  ILE TYR THR THR LEU VAL GLY LEU LEU ASN ALA ARG ASN          
SEQRES   7 B  757  TYR ASN PHE GLY GLY GLU PHE VAL GLU ALA MET ILE ARG          
SEQRES   8 B  757  GLN LEU LYS GLU SER LEU LYS ALA ASN ASN TYR ASN GLU          
SEQRES   9 B  757  ALA VAL TYR LEU VAL ARG PHE LEU SER ASP LEU VAL ASN          
SEQRES  10 B  757  CYS HIS VAL ILE ALA ALA PRO SER MET VAL ALA MET PHE          
SEQRES  11 B  757  GLU ASN PHE VAL SER VAL THR GLN GLU GLU ASP VAL PRO          
SEQRES  12 B  757  GLN VAL ARG ARG ASP TRP TYR VAL TYR ALA PHE LEU SER          
SEQRES  13 B  757  SER LEU PRO TRP VAL GLY LYS GLU LEU TYR GLU LYS LYS          
SEQRES  14 B  757  ASP ALA GLU MET ASP ARG ILE PHE ALA ASN THR GLU SER          
SEQRES  15 B  757  TYR LEU LYS ARG ARG GLN LYS THR HIS VAL PRO MET LEU          
SEQRES  16 B  757  GLN VAL TRP THR ALA ASP LYS PRO HIS PRO GLN GLU GLU          
SEQRES  17 B  757  TYR LEU ASP CYS LEU TRP ALA GLN ILE GLN LYS LEU LYS          
SEQRES  18 B  757  LYS ASP ARG TRP GLN GLU ARG HIS ILE LEU ARG PRO TYR          
SEQRES  19 B  757  LEU ALA PHE ASP SER ILE LEU CYS GLU ALA LEU GLN HIS          
SEQRES  20 B  757  ASN LEU PRO PRO PHE THR PRO PRO PRO HIS THR GLU ASP          
SEQRES  21 B  757  SER VAL TYR PRO MET PRO ARG VAL ILE PHE ARG MET PHE          
SEQRES  22 B  757  ASP TYR THR ASP ASP PRO GLU GLY PRO VAL MET PRO GLY          
SEQRES  23 B  757  SER HIS SER VAL GLU ARG PHE VAL ILE GLU GLU ASN LEU          
SEQRES  24 B  757  HIS CYS ILE ILE LYS SER HIS TRP LYS GLU ARG LYS THR          
SEQRES  25 B  757  CYS ALA ALA GLN LEU VAL SER TYR PRO GLY LYS ASN LYS          
SEQRES  26 B  757  ILE PRO LEU ASN TYR HIS ILE VAL GLU VAL ILE PHE ALA          
SEQRES  27 B  757  GLU LEU PHE GLN LEU PRO ALA PRO PRO HIS ILE ASP VAL          
SEQRES  28 B  757  MET TYR THR THR LEU LEU ILE GLU LEU CYS LYS LEU GLN          
SEQRES  29 B  757  PRO GLY SER LEU PRO GLN VAL LEU ALA GLN ALA THR GLU          
SEQRES  30 B  757  MET LEU TYR MET ARG LEU ASP THR MET ASN THR THR CYS          
SEQRES  31 B  757  VAL ASP ARG PHE ILE ASN TRP PHE SER HIS HIS LEU SER          
SEQRES  32 B  757  ASN PHE GLN PHE ARG TRP SER TRP GLU ASP TRP SER ASP          
SEQRES  33 B  757  CYS LEU SER GLN ASP PRO GLU SER PRO LYS PRO LYS PHE          
SEQRES  34 B  757  VAL ARG GLU VAL LEU GLU LYS CYS MET ARG LEU SER TYR          
SEQRES  35 B  757  HIS GLN ARG ILE LEU ASP ILE VAL PRO PRO THR PHE SER          
SEQRES  36 B  757  ALA LEU CYS PRO SER ASN PRO THR CYS ILE TYR LYS TYR          
SEQRES  37 B  757  GLY ASP GLU SER SER ASN SER LEU PRO GLY HIS SER VAL          
SEQRES  38 B  757  ALA LEU CYS LEU ALA VAL ALA PHE LYS SER LYS ALA THR          
SEQRES  39 B  757  ASN ASP GLU ILE PHE SER ILE LEU LYS ASP VAL PRO ASN          
SEQRES  40 B  757  PRO ASN GLN ASP ASP ASP ASP ASP GLU GLY PHE SER PHE          
SEQRES  41 B  757  ASN PRO LEU LYS ILE GLU VAL PHE VAL GLN THR LEU LEU          
SEQRES  42 B  757  HIS LEU ALA ALA LYS SER PHE SER HIS SER PHE SER ALA          
SEQRES  43 B  757  LEU ALA LYS PHE HIS GLU VAL PHE LYS THR LEU ALA GLU          
SEQRES  44 B  757  SER ASP GLU GLY LYS LEU HIS VAL LEU ARG VAL MET PHE          
SEQRES  45 B  757  GLU VAL TRP ARG ASN HIS PRO GLN MET ILE ALA VAL LEU          
SEQRES  46 B  757  VAL ASP LYS MET ILE ARG THR GLN ILE VAL ASP CYS ALA          
SEQRES  47 B  757  ALA VAL ALA ASN TRP ILE PHE SER SER GLU LEU SER ARG          
SEQRES  48 B  757  ASP PHE THR ARG LEU PHE VAL TRP GLU ILE LEU HIS SER          
SEQRES  49 B  757  THR ILE ARG LYS MET ASN LYS HIS VAL LEU LYS ILE GLN          
SEQRES  50 B  757  LYS GLU LEU GLU GLU ALA LYS GLU LYS LEU ALA ARG GLN          
SEQRES  51 B  757  HIS ASP GLY VAL LEU GLU GLU GLN ILE GLU ARG LEU GLN          
SEQRES  52 B  757  GLU LYS VAL GLU SER ALA GLN SER GLU GLN LYS ASN LEU          
SEQRES  53 B  757  PHE LEU VAL ILE PHE GLN ARG PHE ILE MET ILE LEU THR          
SEQRES  54 B  757  GLU HIS LEU VAL ARG CYS GLU THR ASP GLY THR SER VAL          
SEQRES  55 B  757  LEU THR PRO TRP TYR LYS ASN CYS ILE GLU ARG LEU GLN          
SEQRES  56 B  757  GLN ILE PHE LEU GLN HIS HIS GLN ILE ILE GLN GLN TYR          
SEQRES  57 B  757  MET VAL THR LEU GLU ASN LEU LEU PHE THR ALA GLU LEU          
SEQRES  58 B  757  ASP PRO HIS ILE LEU ALA VAL PHE GLN GLN PHE CYS ALA          
SEQRES  59 B  757  LEU GLN ALA                                                  
SEQRES   1 C  757  LYS THR SER ASP ALA ASN GLU THR GLU ASP HIS LEU GLU          
SEQRES   2 C  757  SER LEU ILE CYS LYS VAL GLY GLU LYS SER ALA CYS SER          
SEQRES   3 C  757  LEU GLU SER ASN LEU GLU GLY LEU ALA GLY VAL LEU GLU          
SEQRES   4 C  757  ALA ASP LEU PRO ASN TYR LYS SER LYS ILE LEU ARG LEU          
SEQRES   5 C  757  LEU CYS THR VAL ALA ARG LEU LEU PRO GLU LYS LEU THR          
SEQRES   6 C  757  ILE TYR THR THR LEU VAL GLY LEU LEU ASN ALA ARG ASN          
SEQRES   7 C  757  TYR ASN PHE GLY GLY GLU PHE VAL GLU ALA MET ILE ARG          
SEQRES   8 C  757  GLN LEU LYS GLU SER LEU LYS ALA ASN ASN TYR ASN GLU          
SEQRES   9 C  757  ALA VAL TYR LEU VAL ARG PHE LEU SER ASP LEU VAL ASN          
SEQRES  10 C  757  CYS HIS VAL ILE ALA ALA PRO SER MET VAL ALA MET PHE          
SEQRES  11 C  757  GLU ASN PHE VAL SER VAL THR GLN GLU GLU ASP VAL PRO          
SEQRES  12 C  757  GLN VAL ARG ARG ASP TRP TYR VAL TYR ALA PHE LEU SER          
SEQRES  13 C  757  SER LEU PRO TRP VAL GLY LYS GLU LEU TYR GLU LYS LYS          
SEQRES  14 C  757  ASP ALA GLU MET ASP ARG ILE PHE ALA ASN THR GLU SER          
SEQRES  15 C  757  TYR LEU LYS ARG ARG GLN LYS THR HIS VAL PRO MET LEU          
SEQRES  16 C  757  GLN VAL TRP THR ALA ASP LYS PRO HIS PRO GLN GLU GLU          
SEQRES  17 C  757  TYR LEU ASP CYS LEU TRP ALA GLN ILE GLN LYS LEU LYS          
SEQRES  18 C  757  LYS ASP ARG TRP GLN GLU ARG HIS ILE LEU ARG PRO TYR          
SEQRES  19 C  757  LEU ALA PHE ASP SER ILE LEU CYS GLU ALA LEU GLN HIS          
SEQRES  20 C  757  ASN LEU PRO PRO PHE THR PRO PRO PRO HIS THR GLU ASP          
SEQRES  21 C  757  SER VAL TYR PRO MET PRO ARG VAL ILE PHE ARG MET PHE          
SEQRES  22 C  757  ASP TYR THR ASP ASP PRO GLU GLY PRO VAL MET PRO GLY          
SEQRES  23 C  757  SER HIS SER VAL GLU ARG PHE VAL ILE GLU GLU ASN LEU          
SEQRES  24 C  757  HIS CYS ILE ILE LYS SER HIS TRP LYS GLU ARG LYS THR          
SEQRES  25 C  757  CYS ALA ALA GLN LEU VAL SER TYR PRO GLY LYS ASN LYS          
SEQRES  26 C  757  ILE PRO LEU ASN TYR HIS ILE VAL GLU VAL ILE PHE ALA          
SEQRES  27 C  757  GLU LEU PHE GLN LEU PRO ALA PRO PRO HIS ILE ASP VAL          
SEQRES  28 C  757  MET TYR THR THR LEU LEU ILE GLU LEU CYS LYS LEU GLN          
SEQRES  29 C  757  PRO GLY SER LEU PRO GLN VAL LEU ALA GLN ALA THR GLU          
SEQRES  30 C  757  MET LEU TYR MET ARG LEU ASP THR MET ASN THR THR CYS          
SEQRES  31 C  757  VAL ASP ARG PHE ILE ASN TRP PHE SER HIS HIS LEU SER          
SEQRES  32 C  757  ASN PHE GLN PHE ARG TRP SER TRP GLU ASP TRP SER ASP          
SEQRES  33 C  757  CYS LEU SER GLN ASP PRO GLU SER PRO LYS PRO LYS PHE          
SEQRES  34 C  757  VAL ARG GLU VAL LEU GLU LYS CYS MET ARG LEU SER TYR          
SEQRES  35 C  757  HIS GLN ARG ILE LEU ASP ILE VAL PRO PRO THR PHE SER          
SEQRES  36 C  757  ALA LEU CYS PRO SER ASN PRO THR CYS ILE TYR LYS TYR          
SEQRES  37 C  757  GLY ASP GLU SER SER ASN SER LEU PRO GLY HIS SER VAL          
SEQRES  38 C  757  ALA LEU CYS LEU ALA VAL ALA PHE LYS SER LYS ALA THR          
SEQRES  39 C  757  ASN ASP GLU ILE PHE SER ILE LEU LYS ASP VAL PRO ASN          
SEQRES  40 C  757  PRO ASN GLN ASP ASP ASP ASP ASP GLU GLY PHE SER PHE          
SEQRES  41 C  757  ASN PRO LEU LYS ILE GLU VAL PHE VAL GLN THR LEU LEU          
SEQRES  42 C  757  HIS LEU ALA ALA LYS SER PHE SER HIS SER PHE SER ALA          
SEQRES  43 C  757  LEU ALA LYS PHE HIS GLU VAL PHE LYS THR LEU ALA GLU          
SEQRES  44 C  757  SER ASP GLU GLY LYS LEU HIS VAL LEU ARG VAL MET PHE          
SEQRES  45 C  757  GLU VAL TRP ARG ASN HIS PRO GLN MET ILE ALA VAL LEU          
SEQRES  46 C  757  VAL ASP LYS MET ILE ARG THR GLN ILE VAL ASP CYS ALA          
SEQRES  47 C  757  ALA VAL ALA ASN TRP ILE PHE SER SER GLU LEU SER ARG          
SEQRES  48 C  757  ASP PHE THR ARG LEU PHE VAL TRP GLU ILE LEU HIS SER          
SEQRES  49 C  757  THR ILE ARG LYS MET ASN LYS HIS VAL LEU LYS ILE GLN          
SEQRES  50 C  757  LYS GLU LEU GLU GLU ALA LYS GLU LYS LEU ALA ARG GLN          
SEQRES  51 C  757  HIS ASP GLY VAL LEU GLU GLU GLN ILE GLU ARG LEU GLN          
SEQRES  52 C  757  GLU LYS VAL GLU SER ALA GLN SER GLU GLN LYS ASN LEU          
SEQRES  53 C  757  PHE LEU VAL ILE PHE GLN ARG PHE ILE MET ILE LEU THR          
SEQRES  54 C  757  GLU HIS LEU VAL ARG CYS GLU THR ASP GLY THR SER VAL          
SEQRES  55 C  757  LEU THR PRO TRP TYR LYS ASN CYS ILE GLU ARG LEU GLN          
SEQRES  56 C  757  GLN ILE PHE LEU GLN HIS HIS GLN ILE ILE GLN GLN TYR          
SEQRES  57 C  757  MET VAL THR LEU GLU ASN LEU LEU PHE THR ALA GLU LEU          
SEQRES  58 C  757  ASP PRO HIS ILE LEU ALA VAL PHE GLN GLN PHE CYS ALA          
SEQRES  59 C  757  LEU GLN ALA                                                  
SEQRES   1 X   97  ASP GLN HIS PHE ARG GLY ASP ASN GLU GLU GLN GLU LYS          
SEQRES   2 X   97  LEU LEU LYS LYS SER CYS THR LEU TYR VAL GLY ASN LEU          
SEQRES   3 X   97  SER PHE TYR THR THR GLU GLU GLN ILE TYR GLU LEU PHE          
SEQRES   4 X   97  SER LYS SER GLY ASP ILE LYS LYS ILE ILE MET GLY LEU          
SEQRES   5 X   97  ASP LYS MET THR ALA CYS GLY PHE CYS PHE VAL GLU TYR          
SEQRES   6 X   97  TYR SER ARG ALA ASP ALA GLU ASN ALA MET ARG TYR ILE          
SEQRES   7 X   97  ASN GLY THR ARG LEU ASP ASP ARG ILE ILE ARG THR ASP          
SEQRES   8 X   97  TRP ASP ALA GLY PHE LYS                                      
SEQRES   1 Y   97  ASP GLN HIS PHE ARG GLY ASP ASN GLU GLU GLN GLU LYS          
SEQRES   2 Y   97  LEU LEU LYS LYS SER CYS THR LEU TYR VAL GLY ASN LEU          
SEQRES   3 Y   97  SER PHE TYR THR THR GLU GLU GLN ILE TYR GLU LEU PHE          
SEQRES   4 Y   97  SER LYS SER GLY ASP ILE LYS LYS ILE ILE MET GLY LEU          
SEQRES   5 Y   97  ASP LYS MET THR ALA CYS GLY PHE CYS PHE VAL GLU TYR          
SEQRES   6 Y   97  TYR SER ARG ALA ASP ALA GLU ASN ALA MET ARG TYR ILE          
SEQRES   7 Y   97  ASN GLY THR ARG LEU ASP ASP ARG ILE ILE ARG THR ASP          
SEQRES   8 Y   97  TRP ASP ALA GLY PHE LYS                                      
SEQRES   1 Z   98  ASP GLN HIS PHE ARG GLY ASP ASN GLU GLU GLN GLU LYS          
SEQRES   2 Z   98  LEU LEU LYS LYS SER CYS THR LEU TYR VAL GLY ASN LEU          
SEQRES   3 Z   98  SER PHE TYR THR THR GLU GLU GLN ILE TYR GLU LEU PHE          
SEQRES   4 Z   98  SER LYS SER GLY ASP ILE LYS LYS ILE ILE MET GLY LEU          
SEQRES   5 Z   98  ASP LYS MET LYS THR ALA CYS GLY PHE CYS PHE VAL GLU          
SEQRES   6 Z   98  TYR TYR SER ARG ALA ASP ALA GLU ASN ALA MET ARG TYR          
SEQRES   7 Z   98  ILE ASN GLY THR ARG LEU ASP ASP ARG ILE ILE ARG THR          
SEQRES   8 Z   98  ASP TRP ASP ALA GLY PHE LYS                                  
FORMUL   7  HOH   *1710(H2 O)                                                   
CRYST1   75.527  161.480  303.291  90.00  90.00  90.00 P 21 21 21   12          
ATOM  19177  N   LYS Z  38      61.566  -1.005  55.047  1.00 42.25           N  
ATOM  19178  CA  LYS Z  38      60.155  -1.337  55.438  1.00 41.64           C  
ATOM  19179  C   LYS Z  38      59.317  -0.117  55.830  1.00 40.40           C  
ATOM  19180  O   LYS Z  38      58.214   0.077  55.318  1.00 40.17           O  
ATOM  19181  CB  LYS Z  38      60.149  -2.349  56.575  1.00 42.60           C  
ATOM  19182  CG  LYS Z  38      59.438  -3.636  56.238  1.00 45.41           C  
ATOM  19183  CD  LYS Z  38      58.001  -3.388  55.835  1.00 49.53           C  
ATOM  19184  CE  LYS Z  38      57.335  -4.682  55.354  1.00 52.03           C  
ATOM  19185  NZ  LYS Z  38      55.923  -4.455  54.908  1.00 53.24           N  
ATOM  19186  N   SER Z  39      59.826   0.687  56.758  1.00 38.97           N  
ATOM  19187  CA  SER Z  39      59.107   1.881  57.180  1.00 37.35           C  
ATOM  19188  C   SER Z  39      58.890   2.825  56.003  1.00 36.19           C  
ATOM  19189  O   SER Z  39      59.756   2.961  55.140  1.00 36.40           O  
ATOM  19190  CB  SER Z  39      59.870   2.620  58.278  1.00 37.43           C  
ATOM  19191  OG  SER Z  39      59.231   3.846  58.576  1.00 37.66           O  
ATOM  19192  N   CYS Z  40      57.722   3.454  55.962  1.00 34.72           N  
ATOM  19193  CA  CYS Z  40      57.419   4.435  54.931  1.00 33.53           C  
ATOM  19194  C   CYS Z  40      57.181   5.763  55.604  1.00 32.65           C  
ATOM  19195  O   CYS Z  40      56.625   6.685  55.005  1.00 32.51           O  
ATOM  19196  CB  CYS Z  40      56.176   4.022  54.140  1.00 33.91           C  
ATOM  19197  SG  CYS Z  40      56.406   2.495  53.228  1.00 33.55           S  
ATOM  19198  N   THR Z  41      57.591   5.866  56.865  1.00 31.08           N  
ATOM  19199  CA  THR Z  41      57.317   7.067  57.633  1.00 30.60           C  
ATOM  19200  C   THR Z  41      58.543   7.829  58.099  1.00 30.02           C  
ATOM  19201  O   THR Z  41      59.523   7.249  58.558  1.00 29.89           O  
ATOM  19202  CB  THR Z  41      56.450   6.732  58.841  1.00 30.34           C  
ATOM  19203  OG1 THR Z  41      55.265   6.072  58.393  1.00 30.96           O  
ATOM  19204  CG2 THR Z  41      55.937   8.009  59.481  1.00 30.42           C  
ATOM  19205  N   LEU Z  42      58.458   9.143  57.999  1.00 30.10           N  
ATOM  19206  CA  LEU Z  42      59.540   9.995  58.423  1.00 30.40           C  
ATOM  19207  C   LEU Z  42      59.128  10.946  59.525  1.00 30.42           C  
ATOM  19208  O   LEU Z  42      58.029  11.495  59.506  1.00 29.68           O  
ATOM  19209  CB  LEU Z  42      60.035  10.823  57.243  1.00 30.50           C  
ATOM  19210  CG  LEU Z  42      60.487  10.031  56.017  1.00 30.31           C  
ATOM  19211  CD1 LEU Z  42      60.912  10.996  54.923  1.00 31.22           C  
ATOM  19212  CD2 LEU Z  42      61.614   9.091  56.392  1.00 30.91           C  
ATOM  19213  N   TYR Z  43      60.032  11.119  60.484  1.00 30.76           N  
ATOM  19214  CA  TYR Z  43      59.949  12.183  61.464  1.00 31.05           C  
ATOM  19215  C   TYR Z  43      60.488  13.359  60.693  1.00 31.07           C  
ATOM  19216  O   TYR Z  43      61.404  13.198  59.898  1.00 31.17           O  
ATOM  19217  CB  TYR Z  43      60.949  11.949  62.600  1.00 31.05           C  
ATOM  19218  CG  TYR Z  43      60.530  10.998  63.685  1.00 32.61           C  
ATOM  19219  CD1 TYR Z  43      61.072   9.727  63.770  1.00 33.69           C  
ATOM  19220  CD2 TYR Z  43      59.634  11.393  64.670  1.00 33.81           C  
ATOM  19221  CE1 TYR Z  43      60.707   8.861  64.789  1.00 33.90           C  
ATOM  19222  CE2 TYR Z  43      59.261  10.532  65.674  1.00 33.43           C  
ATOM  19223  CZ  TYR Z  43      59.792   9.275  65.732  1.00 34.44           C  
ATOM  19224  OH  TYR Z  43      59.411   8.428  66.761  1.00 36.17           O  
ATOM  19225  N   VAL Z  44      59.938  14.537  60.919  1.00 31.61           N  
ATOM  19226  CA  VAL Z  44      60.456  15.742  60.304  1.00 32.64           C  
ATOM  19227  C   VAL Z  44      60.675  16.715  61.448  1.00 33.78           C  
ATOM  19228  O   VAL Z  44      59.757  16.948  62.247  1.00 34.05           O  
ATOM  19229  CB  VAL Z  44      59.449  16.361  59.315  1.00 32.43           C  
ATOM  19230  CG1 VAL Z  44      60.041  17.591  58.674  1.00 32.24           C  
ATOM  19231  CG2 VAL Z  44      59.024  15.325  58.238  1.00 31.60           C  
ATOM  19232  N   GLY Z  45      61.879  17.273  61.536  1.00 34.79           N  
ATOM  19233  CA  GLY Z  45      62.209  18.210  62.596  1.00 35.56           C  
ATOM  19234  C   GLY Z  45      62.634  19.573  62.104  1.00 36.33           C  
ATOM  19235  O   GLY Z  45      62.894  19.763  60.916  1.00 36.34           O  
ATOM  19236  N   ASN Z  46      62.690  20.528  63.030  1.00 37.02           N  
ATOM  19237  CA  ASN Z  46      63.077  21.914  62.749  1.00 37.83           C  
ATOM  19238  C   ASN Z  46      62.057  22.756  62.005  1.00 38.15           C  
ATOM  19239  O   ASN Z  46      62.397  23.780  61.433  1.00 38.45           O  
ATOM  19240  CB  ASN Z  46      64.447  22.009  62.053  1.00 37.96           C  
ATOM  19241  CG  ASN Z  46      65.169  23.303  62.393  1.00 39.64           C  
ATOM  19242  OD1 ASN Z  46      65.198  23.700  63.565  1.00 40.64           O  
ATOM  19243  ND2 ASN Z  46      65.712  23.994  61.378  1.00 36.50           N  
ATOM  19244  N   LEU Z  47      60.797  22.355  62.039  1.00 39.02           N  
ATOM  19245  CA  LEU Z  47      59.764  23.124  61.358  1.00 40.02           C  
ATOM  19246  C   LEU Z  47      59.483  24.407  62.100  1.00 40.88           C  
ATOM  19247  O   LEU Z  47      59.540  24.439  63.330  1.00 41.17           O  
ATOM  19248  CB  LEU Z  47      58.468  22.318  61.266  1.00 39.84           C  
ATOM  19249  CG  LEU Z  47      58.562  21.055  60.413  1.00 40.00           C  
ATOM  19250  CD1 LEU Z  47      57.353  20.169  60.631  1.00 39.46           C  
ATOM  19251  CD2 LEU Z  47      58.697  21.440  58.957  1.00 39.52           C  
ATOM  19252  N   SER Z  48      59.185  25.468  61.361  1.00 41.51           N  
ATOM  19253  CA  SER Z  48      58.772  26.706  61.995  1.00 42.33           C  
ATOM  19254  C   SER Z  48      57.397  26.516  62.629  1.00 43.14           C  
ATOM  19255  O   SER Z  48      56.623  25.652  62.215  1.00 42.92           O  
ATOM  19256  CB  SER Z  48      58.729  27.854  60.991  1.00 42.16           C  
ATOM  19257  OG  SER Z  48      57.489  27.897  60.311  1.00 41.67           O  
ATOM  19258  N   PHE Z  49      57.111  27.334  63.636  1.00 44.12           N  
ATOM  19259  CA  PHE Z  49      55.845  27.312  64.364  1.00 44.82           C  
ATOM  19260  C   PHE Z  49      54.656  27.520  63.435  1.00 44.41           C  
ATOM  19261  O   PHE Z  49      53.628  26.879  63.592  1.00 44.44           O  
ATOM  19262  CB  PHE Z  49      55.867  28.397  65.458  1.00 45.53           C  
ATOM  19263  CG  PHE Z  49      54.542  28.602  66.163  1.00 48.57           C  
ATOM  19264  CD1 PHE Z  49      54.073  27.670  67.082  1.00 51.74           C  
ATOM  19265  CD2 PHE Z  49      53.781  29.742  65.923  1.00 51.17           C  
ATOM  19266  CE1 PHE Z  49      52.863  27.863  67.741  1.00 53.05           C  
ATOM  19267  CE2 PHE Z  49      52.570  29.943  66.576  1.00 52.47           C  
ATOM  19268  CZ  PHE Z  49      52.111  29.002  67.488  1.00 53.28           C  
ATOM  19269  N   TYR Z  50      54.805  28.410  62.461  1.00 44.23           N  
ATOM  19270  CA  TYR Z  50      53.729  28.693  61.517  1.00 44.24           C  
ATOM  19271  C   TYR Z  50      53.702  27.797  60.264  1.00 42.89           C  
ATOM  19272  O   TYR Z  50      52.972  28.087  59.308  1.00 43.13           O  
ATOM  19273  CB  TYR Z  50      53.715  30.175  61.123  1.00 45.30           C  
ATOM  19274  CG  TYR Z  50      55.075  30.812  60.925  1.00 49.35           C  
ATOM  19275  CD1 TYR Z  50      55.376  31.493  59.753  1.00 51.77           C  
ATOM  19276  CD2 TYR Z  50      56.040  30.772  61.924  1.00 51.33           C  
ATOM  19277  CE1 TYR Z  50      56.617  32.085  59.564  1.00 52.59           C  
ATOM  19278  CE2 TYR Z  50      57.276  31.368  61.751  1.00 52.68           C  
ATOM  19279  CZ  TYR Z  50      57.561  32.023  60.568  1.00 54.08           C  
ATOM  19280  OH  TYR Z  50      58.794  32.615  60.390  1.00 55.29           O  
ATOM  19281  N   THR Z  51      54.474  26.713  60.278  1.00 41.03           N  
ATOM  19282  CA  THR Z  51      54.458  25.766  59.163  1.00 39.28           C  
ATOM  19283  C   THR Z  51      53.199  24.899  59.244  1.00 38.67           C  
ATOM  19284  O   THR Z  51      52.922  24.292  60.276  1.00 38.65           O  
ATOM  19285  CB  THR Z  51      55.720  24.876  59.155  1.00 39.26           C  
ATOM  19286  OG1 THR Z  51      56.877  25.669  58.856  1.00 38.05           O  
ATOM  19287  CG2 THR Z  51      55.661  23.906  57.997  1.00 38.77           C  
ATOM  19288  N   THR Z  52      52.444  24.849  58.152  1.00 37.24           N  
ATOM  19289  CA  THR Z  52      51.173  24.130  58.105  1.00 35.93           C  
ATOM  19290  C   THR Z  52      51.235  22.773  57.422  1.00 35.20           C  
ATOM  19291  O   THR Z  52      52.139  22.483  56.632  1.00 34.20           O  
ATOM  19292  CB  THR Z  52      50.143  24.964  57.336  1.00 36.42           C  
ATOM  19293  OG1 THR Z  52      50.608  25.140  55.986  1.00 36.11           O  
ATOM  19294  CG2 THR Z  52      50.063  26.395  57.902  1.00 35.90           C  
ATOM  19295  N   GLU Z  53      50.224  21.965  57.710  1.00 33.38           N  
ATOM  19296  CA  GLU Z  53      50.049  20.669  57.097  1.00 32.86           C  
ATOM  19297  C   GLU Z  53      50.021  20.814  55.566  1.00 31.76           C  
ATOM  19298  O   GLU Z  53      50.553  19.973  54.841  1.00 31.27           O  
ATOM  19299  CB  GLU Z  53      48.730  20.070  57.593  1.00 33.27           C  
ATOM  19300  CG  GLU Z  53      48.360  18.722  57.011  1.00 34.54           C  
ATOM  19301  CD  GLU Z  53      47.029  18.204  57.558  1.00 36.64           C  
ATOM  19302  OE1 GLU Z  53      46.176  19.018  57.978  1.00 35.73           O  
ATOM  19303  OE2 GLU Z  53      46.835  16.976  57.559  1.00 39.56           O  
ATOM  19304  N   GLU Z  54      49.403  21.886  55.097  1.00 30.58           N  
ATOM  19305  CA  GLU Z  54      49.269  22.140  53.667  1.00 31.02           C  
ATOM  19306  C   GLU Z  54      50.643  22.326  53.011  1.00 30.06           C  
ATOM  19307  O   GLU Z  54      50.925  21.754  51.952  1.00 29.46           O  
ATOM  19308  CB  GLU Z  54      48.408  23.378  53.417  1.00 30.89           C  
ATOM  19309  CG  GLU Z  54      46.911  23.211  53.693  1.00 33.99           C  
ATOM  19310  CD  GLU Z  54      46.553  23.154  55.182  1.00 37.32           C  
ATOM  19311  OE1 GLU Z  54      47.363  23.593  56.038  1.00 35.59           O  
ATOM  19312  OE2 GLU Z  54      45.435  22.674  55.496  1.00 39.36           O  
ATOM  19313  N   GLN Z  55      51.489  23.122  53.656  1.00 29.51           N  
ATOM  19314  CA  GLN Z  55      52.832  23.385  53.134  1.00 29.44           C  
ATOM  19315  C   GLN Z  55      53.678  22.151  53.182  1.00 29.03           C  
ATOM  19316  O   GLN Z  55      54.516  21.933  52.316  1.00 29.42           O  
ATOM  19317  CB  GLN Z  55      53.504  24.509  53.909  1.00 29.27           C  
ATOM  19318  CG  GLN Z  55      52.785  25.829  53.779  1.00 28.98           C  
ATOM  19319  CD  GLN Z  55      53.109  26.750  54.936  1.00 31.63           C  
ATOM  19320  OE1 GLN Z  55      53.483  26.279  56.006  1.00 32.74           O  
ATOM  19321  NE2 GLN Z  55      52.973  28.057  54.727  1.00 32.68           N  
ATOM  19322  N   ILE Z  56      53.481  21.334  54.207  1.00 28.88           N  
ATOM  19323  CA  ILE Z  56      54.236  20.107  54.299  1.00 28.54           C  
ATOM  19324  C   ILE Z  56      53.787  19.168  53.187  1.00 28.56           C  
ATOM  19325  O   ILE Z  56      54.609  18.491  52.551  1.00 27.31           O  
ATOM  19326  CB  ILE Z  56      54.059  19.471  55.675  1.00 29.00           C  
ATOM  19327  CG1 ILE Z  56      54.751  20.344  56.725  1.00 30.14           C  
ATOM  19328  CG2 ILE Z  56      54.655  18.072  55.684  1.00 28.89           C  
ATOM  19329  CD1 ILE Z  56      54.260  20.141  58.128  1.00 31.75           C  
ATOM  19330  N   TYR Z  57      52.479  19.135  52.950  1.00 27.81           N  
ATOM  19331  CA  TYR Z  57      51.935  18.344  51.863  1.00 28.68           C  
ATOM  19332  C   TYR Z  57      52.587  18.735  50.536  1.00 28.30           C  
ATOM  19333  O   TYR Z  57      53.046  17.881  49.788  1.00 28.41           O  
ATOM  19334  CB  TYR Z  57      50.415  18.531  51.750  1.00 28.60           C  
ATOM  19335  CG  TYR Z  57      49.652  17.343  52.256  1.00 30.83           C  
ATOM  19336  CD1 TYR Z  57      49.487  16.213  51.467  1.00 33.41           C  
ATOM  19337  CD2 TYR Z  57      49.112  17.340  53.529  1.00 33.47           C  
ATOM  19338  CE1 TYR Z  57      48.802  15.100  51.940  1.00 35.18           C  
ATOM  19339  CE2 TYR Z  57      48.423  16.234  54.018  1.00 35.19           C  
ATOM  19340  CZ  TYR Z  57      48.268  15.126  53.225  1.00 36.94           C  
ATOM  19341  OH  TYR Z  57      47.590  14.039  53.727  1.00 39.98           O  
ATOM  19342  N   GLU Z  58      52.621  20.029  50.264  1.00 28.40           N  
ATOM  19343  CA  GLU Z  58      53.174  20.521  49.011  1.00 29.16           C  
ATOM  19344  C   GLU Z  58      54.647  20.144  48.833  1.00 28.64           C  
ATOM  19345  O   GLU Z  58      55.054  19.673  47.763  1.00 28.42           O  
ATOM  19346  CB  GLU Z  58      52.989  22.027  48.921  1.00 28.84           C  
ATOM  19347  CG  GLU Z  58      53.518  22.622  47.636  1.00 30.98           C  
ATOM  19348  CD  GLU Z  58      52.647  22.308  46.433  1.00 33.50           C  
ATOM  19349  OE1 GLU Z  58      51.577  21.678  46.598  1.00 35.38           O  
ATOM  19350  OE2 GLU Z  58      53.035  22.709  45.318  1.00 32.98           O  
ATOM  19351  N   LEU Z  59      55.441  20.322  49.891  1.00 28.43           N  
ATOM  19352  CA  LEU Z  59      56.877  20.056  49.809  1.00 27.84           C  
ATOM  19353  C   LEU Z  59      57.159  18.573  49.734  1.00 27.70           C  
ATOM  19354  O   LEU Z  59      57.842  18.087  48.825  1.00 26.86           O  
ATOM  19355  CB  LEU Z  59      57.629  20.675  50.998  1.00 28.30           C  
ATOM  19356  CG  LEU Z  59      59.114  20.284  51.095  1.00 27.76           C  
ATOM  19357  CD1 LEU Z  59      59.865  20.679  49.813  1.00 28.39           C  
ATOM  19358  CD2 LEU Z  59      59.788  20.930  52.308  1.00 28.29           C  
ATOM  19359  N   PHE Z  60      56.614  17.829  50.680  1.00 27.43           N  
ATOM  19360  CA  PHE Z  60      56.901  16.410  50.708  1.00 27.49           C  
ATOM  19361  C   PHE Z  60      56.277  15.600  49.548  1.00 27.25           C  
ATOM  19362  O   PHE Z  60      56.767  14.525  49.213  1.00 27.03           O  
ATOM  19363  CB  PHE Z  60      56.626  15.820  52.089  1.00 27.45           C  
ATOM  19364  CG  PHE Z  60      57.712  16.120  53.091  1.00 27.54           C  
ATOM  19365  CD1 PHE Z  60      57.769  17.346  53.721  1.00 26.24           C  
ATOM  19366  CD2 PHE Z  60      58.685  15.185  53.375  1.00 27.43           C  
ATOM  19367  CE1 PHE Z  60      58.773  17.630  54.629  1.00 26.75           C  
ATOM  19368  CE2 PHE Z  60      59.683  15.458  54.287  1.00 27.68           C  
ATOM  19369  CZ  PHE Z  60      59.728  16.686  54.912  1.00 26.85           C  
ATOM  19370  N   SER Z  61      55.252  16.139  48.899  1.00 27.09           N  
ATOM  19371  CA  SER Z  61      54.661  15.443  47.744  1.00 28.15           C  
ATOM  19372  C   SER Z  61      55.618  15.384  46.554  1.00 27.88           C  
ATOM  19373  O   SER Z  61      55.402  14.631  45.616  1.00 27.57           O  
ATOM  19374  CB  SER Z  61      53.332  16.084  47.311  1.00 28.11           C  
ATOM  19375  OG  SER Z  61      52.291  15.734  48.220  1.00 30.37           O  
ATOM  19376  N   LYS Z  62      56.677  16.176  46.606  1.00 27.91           N  
ATOM  19377  CA  LYS Z  62      57.650  16.210  45.523  1.00 28.39           C  
ATOM  19378  C   LYS Z  62      58.436  14.912  45.412  1.00 28.22           C  
ATOM  19379  O   LYS Z  62      58.976  14.592  44.361  1.00 27.71           O  
ATOM  19380  CB  LYS Z  62      58.567  17.438  45.674  1.00 28.69           C  
ATOM  19381  CG  LYS Z  62      57.818  18.719  45.372  1.00 29.04           C  
ATOM  19382  CD  LYS Z  62      58.679  19.946  45.504  1.00 32.29           C  
ATOM  19383  CE  LYS Z  62      57.848  21.191  45.233  1.00 32.00           C  
ATOM  19384  NZ  LYS Z  62      57.596  21.396  43.779  1.00 33.89           N  
ATOM  19385  N   SER Z  63      58.479  14.145  46.496  1.00 28.18           N  
ATOM  19386  CA  SER Z  63      59.158  12.871  46.443  1.00 28.75           C  
ATOM  19387  C   SER Z  63      58.190  11.705  46.216  1.00 28.44           C  
ATOM  19388  O   SER Z  63      58.615  10.576  45.980  1.00 29.00           O  
ATOM  19389  CB  SER Z  63      59.997  12.649  47.703  1.00 28.91           C  
ATOM  19390  OG  SER Z  63      59.185  12.202  48.764  1.00 29.95           O  
ATOM  19391  N   GLY Z  64      56.892  11.985  46.264  1.00 28.63           N  
ATOM  19392  CA  GLY Z  64      55.897  10.954  46.041  1.00 28.36           C  
ATOM  19393  C   GLY Z  64      54.585  11.144  46.788  1.00 28.69           C  
ATOM  19394  O   GLY Z  64      54.379  12.126  47.493  1.00 27.40           O  
ATOM  19395  N   ASP Z  65      53.683  10.186  46.628  1.00 28.83           N  
ATOM  19396  CA  ASP Z  65      52.368  10.309  47.230  1.00 29.90           C  
ATOM  19397  C   ASP Z  65      52.355  10.071  48.718  1.00 30.00           C  
ATOM  19398  O   ASP Z  65      52.782   9.028  49.204  1.00 29.46           O  
ATOM  19399  CB  ASP Z  65      51.373   9.411  46.532  1.00 30.72           C  
ATOM  19400  CG  ASP Z  65      51.376   9.628  45.052  1.00 32.45           C  
ATOM  19401  OD1 ASP Z  65      51.868   8.737  44.341  1.00 36.21           O  
ATOM  19402  OD2 ASP Z  65      50.984  10.693  44.524  1.00 33.77           O  
ATOM  19403  N   ILE Z  66      51.836  11.068  49.414  1.00 30.99           N  
ATOM  19404  CA  ILE Z  66      51.748  11.061  50.861  1.00 32.29           C  
ATOM  19405  C   ILE Z  66      50.450  10.435  51.342  1.00 33.34           C  
ATOM  19406  O   ILE Z  66      49.360  10.843  50.939  1.00 33.54           O  
ATOM  19407  CB  ILE Z  66      51.818  12.486  51.387  1.00 31.62           C  
ATOM  19408  CG1 ILE Z  66      53.229  13.058  51.181  1.00 30.73           C  
ATOM  19409  CG2 ILE Z  66      51.389  12.525  52.870  1.00 31.59           C  
ATOM  19410  CD1 ILE Z  66      53.306  14.526  51.427  1.00 29.08           C  
ATOM  19411  N   LYS Z  67      50.582   9.453  52.219  1.00 34.26           N  
ATOM  19412  CA  LYS Z  67      49.429   8.834  52.839  1.00 35.39           C  
ATOM  19413  C   LYS Z  67      48.883   9.690  53.978  1.00 35.75           C  
ATOM  19414  O   LYS Z  67      47.676   9.939  54.073  1.00 36.10           O  
ATOM  19415  CB  LYS Z  67      49.813   7.453  53.373  1.00 35.56           C  
ATOM  19416  CG  LYS Z  67      48.660   6.733  54.060  1.00 37.84           C  
ATOM  19417  CD  LYS Z  67      48.954   5.254  54.240  1.00 39.79           C  
ATOM  19418  CE  LYS Z  67      47.722   4.537  54.763  1.00 41.65           C  
ATOM  19419  NZ  LYS Z  67      48.037   3.143  55.147  1.00 44.33           N  
ATOM  19420  N   LYS Z  68      49.772  10.182  54.833  1.00 35.64           N  
ATOM  19421  CA  LYS Z  68      49.313  10.893  56.007  1.00 36.18           C  
ATOM  19422  C   LYS Z  68      50.360  11.817  56.580  1.00 35.68           C  
ATOM  19423  O   LYS Z  68      51.539  11.498  56.584  1.00 34.89           O  
ATOM  19424  CB  LYS Z  68      48.926   9.867  57.076  1.00 36.19           C  
ATOM  19425  CG  LYS Z  68      48.224  10.422  58.289  1.00 39.19           C  
ATOM  19426  CD  LYS Z  68      47.914   9.260  59.216  1.00 41.60           C  
ATOM  19427  CE  LYS Z  68      47.055   9.641  60.409  1.00 44.04           C  
ATOM  19428  NZ  LYS Z  68      46.892   8.401  61.230  1.00 46.33           N  
ATOM  19429  N   ILE Z  69      49.907  12.969  57.056  1.00 35.73           N  
ATOM  19430  CA  ILE Z  69      50.768  13.879  57.760  1.00 36.03           C  
ATOM  19431  C   ILE Z  69      50.188  14.144  59.140  1.00 36.76           C  
ATOM  19432  O   ILE Z  69      48.986  14.388  59.295  1.00 37.00           O  
ATOM  19433  CB  ILE Z  69      50.934  15.179  57.011  1.00 35.96           C  
ATOM  19434  CG1 ILE Z  69      51.864  14.968  55.812  1.00 36.44           C  
ATOM  19435  CG2 ILE Z  69      51.547  16.230  57.926  1.00 34.69           C  
ATOM  19436  CD1 ILE Z  69      51.948  16.173  54.929  1.00 37.98           C  
ATOM  19437  N   ILE Z  70      51.045  14.062  60.148  1.00 36.86           N  
ATOM  19438  CA  ILE Z  70      50.630  14.336  61.514  1.00 37.40           C  
ATOM  19439  C   ILE Z  70      51.490  15.444  62.079  1.00 38.10           C  
ATOM  19440  O   ILE Z  70      52.700  15.286  62.206  1.00 37.51           O  
ATOM  19441  CB  ILE Z  70      50.774  13.070  62.364  1.00 37.35           C  
ATOM  19442  CG1 ILE Z  70      49.803  11.997  61.870  1.00 37.18           C  
ATOM  19443  CG2 ILE Z  70      50.536  13.384  63.850  1.00 37.37           C  
ATOM  19444  CD1 ILE Z  70      50.171  10.609  62.278  1.00 36.93           C  
ATOM  19445  N   MET Z  71      50.875  16.579  62.394  1.00 38.97           N  
ATOM  19446  CA  MET Z  71      51.616  17.675  62.992  1.00 40.90           C  
ATOM  19447  C   MET Z  71      51.866  17.362  64.474  1.00 42.15           C  
ATOM  19448  O   MET Z  71      51.001  16.809  65.151  1.00 42.21           O  
ATOM  19449  CB  MET Z  71      50.843  18.971  62.822  1.00 40.64           C  
ATOM  19450  CG  MET Z  71      50.433  19.217  61.383  1.00 40.83           C  
ATOM  19451  SD  MET Z  71      51.870  19.359  60.291  1.00 40.02           S  
ATOM  19452  CE  MET Z  71      52.365  21.065  60.700  1.00 42.67           C  
ATOM  19453  N   GLY Z  72      53.055  17.686  64.965  1.00 43.61           N  
ATOM  19454  CA  GLY Z  72      53.393  17.416  66.351  1.00 45.87           C  
ATOM  19455  C   GLY Z  72      54.125  16.103  66.528  1.00 47.35           C  
ATOM  19456  O   GLY Z  72      54.429  15.409  65.554  1.00 47.72           O  
ATOM  19457  N   LEU Z  73      54.406  15.755  67.778  1.00 48.77           N  
ATOM  19458  CA  LEU Z  73      55.156  14.548  68.092  1.00 50.17           C  
ATOM  19459  C   LEU Z  73      54.277  13.403  68.601  1.00 51.35           C  
ATOM  19460  O   LEU Z  73      54.758  12.288  68.809  1.00 51.47           O  
ATOM  19461  CB  LEU Z  73      56.268  14.865  69.088  1.00 50.33           C  
ATOM  19462  CG  LEU Z  73      57.568  15.386  68.463  1.00 50.62           C  
ATOM  19463  CD1 LEU Z  73      58.531  15.919  69.521  1.00 50.65           C  
ATOM  19464  CD2 LEU Z  73      58.234  14.288  67.625  1.00 49.82           C  
ATOM  19465  N   ASP Z  74      52.991  13.667  68.792  1.00 52.61           N  
ATOM  19466  CA  ASP Z  74      52.091  12.616  69.241  1.00 53.95           C  
ATOM  19467  C   ASP Z  74      51.520  11.896  68.030  1.00 54.56           C  
ATOM  19468  O   ASP Z  74      50.657  12.422  67.330  1.00 54.32           O  
ATOM  19469  CB  ASP Z  74      50.964  13.177  70.107  1.00 54.13           C  
ATOM  19470  CG  ASP Z  74      49.910  12.140  70.424  1.00 55.38           C  
ATOM  19471  OD1 ASP Z  74      50.273  11.006  70.810  1.00 56.64           O  
ATOM  19472  OD2 ASP Z  74      48.688  12.365  70.309  1.00 57.47           O  
ATOM  19473  N   LYS Z  75      52.007  10.686  67.794  1.00 55.48           N  
ATOM  19474  CA  LYS Z  75      51.617   9.930  66.619  1.00 56.79           C  
ATOM  19475  C   LYS Z  75      50.176   9.445  66.670  1.00 58.14           C  
ATOM  19476  O   LYS Z  75      49.618   9.040  65.658  1.00 58.25           O  
ATOM  19477  CB  LYS Z  75      52.574   8.764  66.384  1.00 56.51           C  
ATOM  19478  CG  LYS Z  75      52.650   8.344  64.943  1.00 55.51           C  
ATOM  19479  CD  LYS Z  75      53.738   7.329  64.732  1.00 53.92           C  
ATOM  19480  CE  LYS Z  75      53.816   6.926  63.280  1.00 50.75           C  
ATOM  19481  NZ  LYS Z  75      54.703   5.763  63.132  1.00 49.94           N  
ATOM  19482  N   MET Z  76      49.568   9.479  67.847  1.00 59.90           N  
ATOM  19483  CA  MET Z  76      48.160   9.120  67.937  1.00 61.82           C  
ATOM  19484  C   MET Z  76      47.325  10.357  67.625  1.00 62.58           C  
ATOM  19485  O   MET Z  76      46.131  10.399  67.918  1.00 62.74           O  
ATOM  19486  CB  MET Z  76      47.814   8.572  69.314  1.00 62.10           C  
ATOM  19487  CG  MET Z  76      48.663   7.398  69.734  1.00 63.89           C  
ATOM  19488  SD  MET Z  76      48.123   6.742  71.317  1.00 68.79           S  
ATOM  19489  CE  MET Z  76      46.706   5.717  70.795  1.00 67.16           C  
ATOM  19490  N   LYS Z  77      47.987  11.360  67.039  1.00 63.49           N  
ATOM  19491  CA  LYS Z  77      47.368  12.618  66.604  1.00 64.37           C  
ATOM  19492  C   LYS Z  77      47.027  13.583  67.744  1.00 64.71           C  
ATOM  19493  O   LYS Z  77      47.185  14.804  67.606  1.00 64.79           O  
ATOM  19494  CB  LYS Z  77      46.151  12.344  65.714  1.00 64.55           C  
ATOM  19495  CG  LYS Z  77      46.449  11.368  64.577  1.00 65.43           C  
ATOM  19496  CD  LYS Z  77      45.215  11.065  63.742  1.00 67.66           C  
ATOM  19497  CE  LYS Z  77      44.951  12.163  62.722  1.00 68.67           C  
ATOM  19498  NZ  LYS Z  77      43.709  11.912  61.937  1.00 69.46           N  
ATOM  19499  N   CYS Z  81      56.094  22.207  68.432  1.00 44.93           N  
ATOM  19500  CA  CYS Z  81      57.398  21.591  68.811  1.00 44.80           C  
ATOM  19501  C   CYS Z  81      58.345  21.445  67.613  1.00 43.95           C  
ATOM  19502  O   CYS Z  81      59.439  20.899  67.749  1.00 44.13           O  
ATOM  19503  CB  CYS Z  81      57.176  20.226  69.463  1.00 44.72           C  
ATOM  19504  SG  CYS Z  81      56.376  19.007  68.388  1.00 46.91           S  
ATOM  19505  N   GLY Z  82      57.915  21.915  66.446  1.00 42.89           N  
ATOM  19506  CA  GLY Z  82      58.740  21.869  65.245  1.00 41.75           C  
ATOM  19507  C   GLY Z  82      58.867  20.519  64.561  1.00 40.80           C  
ATOM  19508  O   GLY Z  82      59.667  20.362  63.639  1.00 40.92           O  
ATOM  19509  N   PHE Z  83      58.086  19.541  65.002  1.00 39.90           N  
ATOM  19510  CA  PHE Z  83      58.150  18.214  64.411  1.00 39.07           C  
ATOM  19511  C   PHE Z  83      56.834  17.801  63.748  1.00 38.11           C  
ATOM  19512  O   PHE Z  83      55.768  18.337  64.061  1.00 38.02           O  
ATOM  19513  CB  PHE Z  83      58.512  17.177  65.479  1.00 39.76           C  
ATOM  19514  CG  PHE Z  83      59.982  17.111  65.803  1.00 40.31           C  
ATOM  19515  CD1 PHE Z  83      60.778  16.131  65.244  1.00 41.99           C  
ATOM  19516  CD2 PHE Z  83      60.558  18.027  66.672  1.00 42.20           C  
ATOM  19517  CE1 PHE Z  83      62.140  16.063  65.534  1.00 43.13           C  
ATOM  19518  CE2 PHE Z  83      61.909  17.969  66.975  1.00 43.46           C  
ATOM  19519  CZ  PHE Z  83      62.706  16.984  66.403  1.00 43.64           C  
ATOM  19520  N   CYS Z  84      56.921  16.849  62.823  1.00 36.65           N  
ATOM  19521  CA  CYS Z  84      55.734  16.231  62.236  1.00 35.19           C  
ATOM  19522  C   CYS Z  84      56.092  14.862  61.694  1.00 35.05           C  
ATOM  19523  O   CYS Z  84      57.269  14.503  61.623  1.00 34.69           O  
ATOM  19524  CB  CYS Z  84      55.092  17.109  61.148  1.00 35.48           C  
ATOM  19525  SG  CYS Z  84      55.859  17.035  59.508  1.00 33.36           S  
ATOM  19526  N   PHE Z  85      55.071  14.078  61.362  1.00 34.39           N  
ATOM  19527  CA  PHE Z  85      55.272  12.783  60.746  1.00 34.24           C  
ATOM  19528  C   PHE Z  85      54.770  12.853  59.302  1.00 33.75           C  
ATOM  19529  O   PHE Z  85      53.699  13.404  59.037  1.00 33.32           O  
ATOM  19530  CB  PHE Z  85      54.515  11.675  61.498  1.00 34.51           C  
ATOM  19531  CG  PHE Z  85      55.006  11.435  62.914  1.00 35.43           C  
ATOM  19532  CD1 PHE Z  85      54.527  12.196  63.970  1.00 36.51           C  
ATOM  19533  CD2 PHE Z  85      55.933  10.444  63.182  1.00 36.49           C  
ATOM  19534  CE1 PHE Z  85      54.978  11.971  65.279  1.00 37.60           C  
ATOM  19535  CE2 PHE Z  85      56.379  10.212  64.472  1.00 36.64           C  
ATOM  19536  CZ  PHE Z  85      55.905  10.981  65.524  1.00 35.40           C  
ATOM  19537  N   VAL Z  86      55.556  12.330  58.367  1.00 33.05           N  
ATOM  19538  CA  VAL Z  86      55.110  12.238  56.983  1.00 32.18           C  
ATOM  19539  C   VAL Z  86      55.146  10.784  56.611  1.00 32.13           C  
ATOM  19540  O   VAL Z  86      56.183  10.156  56.703  1.00 32.39           O  
ATOM  19541  CB  VAL Z  86      55.983  13.033  55.998  1.00 32.19           C  
ATOM  19542  CG1 VAL Z  86      55.450  12.858  54.566  1.00 30.47           C  
ATOM  19543  CG2 VAL Z  86      56.018  14.505  56.386  1.00 31.29           C  
ATOM  19544  N   GLU Z  87      54.001  10.245  56.221  1.00 31.82           N  
ATOM  19545  CA  GLU Z  87      53.912   8.849  55.832  1.00 32.25           C  
ATOM  19546  C   GLU Z  87      53.601   8.727  54.350  1.00 31.92           C  
ATOM  19547  O   GLU Z  87      52.655   9.328  53.863  1.00 31.76           O  
ATOM  19548  CB  GLU Z  87      52.825   8.142  56.644  1.00 32.08           C  
ATOM  19549  CG  GLU Z  87      52.620   6.680  56.278  1.00 33.56           C  
ATOM  19550  CD  GLU Z  87      51.467   6.066  57.043  1.00 35.86           C  
ATOM  19551  OE1 GLU Z  87      50.688   6.838  57.643  1.00 37.46           O  
ATOM  19552  OE2 GLU Z  87      51.331   4.831  57.057  1.00 36.10           O  
ATOM  19553  N   TYR Z  88      54.405   7.936  53.648  1.00 32.61           N  
ATOM  19554  CA  TYR Z  88      54.216   7.687  52.227  1.00 32.80           C  
ATOM  19555  C   TYR Z  88      53.595   6.306  52.017  1.00 33.51           C  
ATOM  19556  O   TYR Z  88      53.657   5.447  52.896  1.00 33.31           O  
ATOM  19557  CB  TYR Z  88      55.568   7.726  51.502  1.00 32.20           C  
ATOM  19558  CG  TYR Z  88      56.160   9.105  51.412  1.00 30.63           C  
ATOM  19559  CD1 TYR Z  88      55.848   9.947  50.353  1.00 28.27           C  
ATOM  19560  CD2 TYR Z  88      57.031   9.573  52.390  1.00 28.31           C  
ATOM  19561  CE1 TYR Z  88      56.392  11.206  50.271  1.00 28.53           C  
ATOM  19562  CE2 TYR Z  88      57.583  10.828  52.306  1.00 25.96           C  
ATOM  19563  CZ  TYR Z  88      57.256  11.641  51.253  1.00 27.67           C  
ATOM  19564  OH  TYR Z  88      57.792  12.906  51.167  1.00 28.08           O  
ATOM  19565  N   TYR Z  89      53.001   6.103  50.848  1.00 33.80           N  
ATOM  19566  CA  TYR Z  89      52.466   4.805  50.488  1.00 34.75           C  
ATOM  19567  C   TYR Z  89      53.598   3.864  50.124  1.00 35.25           C  
ATOM  19568  O   TYR Z  89      53.481   2.650  50.268  1.00 35.96           O  
ATOM  19569  CB  TYR Z  89      51.494   4.940  49.317  1.00 34.73           C  
ATOM  19570  CG  TYR Z  89      50.207   5.631  49.688  1.00 34.61           C  
ATOM  19571  CD1 TYR Z  89      49.219   4.961  50.404  1.00 34.40           C  
ATOM  19572  CD2 TYR Z  89      49.978   6.953  49.335  1.00 33.17           C  
ATOM  19573  CE1 TYR Z  89      48.035   5.595  50.752  1.00 33.52           C  
ATOM  19574  CE2 TYR Z  89      48.813   7.587  49.678  1.00 33.37           C  
ATOM  19575  CZ  TYR Z  89      47.837   6.901  50.380  1.00 34.73           C  
ATOM  19576  OH  TYR Z  89      46.671   7.542  50.733  1.00 36.36           O  
ATOM  19577  N   SER Z  90      54.710   4.409  49.638  1.00 35.43           N  
ATOM  19578  CA  SER Z  90      55.817   3.538  49.271  1.00 35.09           C  
ATOM  19579  C   SER Z  90      57.152   3.931  49.895  1.00 34.68           C  
ATOM  19580  O   SER Z  90      57.445   5.110  50.119  1.00 34.18           O  
ATOM  19581  CB  SER Z  90      55.945   3.403  47.757  1.00 35.38           C  
ATOM  19582  OG  SER Z  90      56.905   4.298  47.232  1.00 36.75           O  
ATOM  19583  N   ARG Z  91      57.950   2.911  50.164  1.00 34.43           N  
ATOM  19584  CA  ARG Z  91      59.266   3.065  50.755  1.00 34.33           C  
ATOM  19585  C   ARG Z  91      60.162   3.910  49.848  1.00 33.70           C  
ATOM  19586  O   ARG Z  91      60.825   4.846  50.306  1.00 33.22           O  
ATOM  19587  CB  ARG Z  91      59.870   1.687  50.976  1.00 34.63           C  
ATOM  19588  CG  ARG Z  91      61.334   1.708  51.357  1.00 36.40           C  
ATOM  19589  CD  ARG Z  91      61.602   2.185  52.767  1.00 37.25           C  
ATOM  19590  NE  ARG Z  91      63.021   2.096  53.101  1.00 39.19           N  
ATOM  19591  CZ  ARG Z  91      63.500   2.125  54.338  1.00 39.17           C  
ATOM  19592  NH1 ARG Z  91      62.675   2.229  55.371  1.00 38.37           N  
ATOM  19593  NH2 ARG Z  91      64.805   2.054  54.545  1.00 39.99           N  
ATOM  19594  N   ALA Z  92      60.154   3.588  48.554  1.00 32.71           N  
ATOM  19595  CA  ALA Z  92      60.938   4.343  47.582  1.00 31.65           C  
ATOM  19596  C   ALA Z  92      60.724   5.849  47.697  1.00 30.72           C  
ATOM  19597  O   ALA Z  92      61.677   6.611  47.623  1.00 30.05           O  
ATOM  19598  CB  ALA Z  92      60.636   3.875  46.153  1.00 31.99           C  
ATOM  19599  N   ASP Z  93      59.476   6.263  47.896  1.00 29.59           N  
ATOM  19600  CA  ASP Z  93      59.142   7.677  47.970  1.00 29.42           C  
ATOM  19601  C   ASP Z  93      59.634   8.329  49.262  1.00 29.63           C  
ATOM  19602  O   ASP Z  93      60.030   9.498  49.272  1.00 29.09           O  
ATOM  19603  CB  ASP Z  93      57.639   7.885  47.819  1.00 29.42           C  
ATOM  19604  CG  ASP Z  93      57.127   7.477  46.449  1.00 28.81           C  
ATOM  19605  OD1 ASP Z  93      57.942   7.166  45.559  1.00 26.96           O  
ATOM  19606  OD2 ASP Z  93      55.923   7.442  46.184  1.00 29.06           O  
ATOM  19607  N   ALA Z  94      59.602   7.573  50.349  1.00 29.47           N  
ATOM  19608  CA  ALA Z  94      60.111   8.086  51.607  1.00 29.87           C  
ATOM  19609  C   ALA Z  94      61.624   8.210  51.480  1.00 29.70           C  
ATOM  19610  O   ALA Z  94      62.206   9.191  51.929  1.00 29.59           O  
ATOM  19611  CB  ALA Z  94      59.742   7.159  52.753  1.00 29.73           C  
ATOM  19612  N   GLU Z  95      62.255   7.214  50.853  1.00 29.79           N  
ATOM  19613  CA  GLU Z  95      63.702   7.244  50.650  1.00 29.80           C  
ATOM  19614  C   GLU Z  95      64.116   8.490  49.897  1.00 29.03           C  
ATOM  19615  O   GLU Z  95      65.106   9.122  50.238  1.00 29.06           O  
ATOM  19616  CB  GLU Z  95      64.182   6.035  49.870  1.00 30.12           C  
ATOM  19617  CG  GLU Z  95      63.950   4.712  50.567  1.00 34.37           C  
ATOM  19618  CD  GLU Z  95      64.599   3.547  49.824  1.00 38.26           C  
ATOM  19619  OE1 GLU Z  95      64.337   3.391  48.607  1.00 40.61           O  
ATOM  19620  OE2 GLU Z  95      65.367   2.797  50.462  1.00 41.12           O  
ATOM  19621  N   ASN Z  96      63.352   8.835  48.864  1.00 28.16           N  
ATOM  19622  CA  ASN Z  96      63.662  10.002  48.059  1.00 27.61           C  
ATOM  19623  C   ASN Z  96      63.429  11.290  48.839  1.00 27.58           C  
ATOM  19624  O   ASN Z  96      64.063  12.325  48.568  1.00 26.24           O  
ATOM  19625  CB  ASN Z  96      62.879   9.977  46.735  1.00 27.77           C  
ATOM  19626  CG  ASN Z  96      63.547   9.093  45.693  1.00 28.12           C  
ATOM  19627  OD1 ASN Z  96      64.762   8.954  45.686  1.00 29.65           O  
ATOM  19628  ND2 ASN Z  96      62.755   8.468  44.835  1.00 27.76           N  
ATOM  19629  N   ALA Z  97      62.528  11.238  49.818  1.00 26.82           N  
ATOM  19630  CA  ALA Z  97      62.350  12.399  50.686  1.00 27.28           C  
ATOM  19631  C   ALA Z  97      63.595  12.520  51.582  1.00 27.19           C  
ATOM  19632  O   ALA Z  97      64.127  13.602  51.751  1.00 27.97           O  
ATOM  19633  CB  ALA Z  97      61.064  12.299  51.515  1.00 26.56           C  
ATOM  19634  N   MET Z  98      64.071  11.406  52.119  1.00 27.47           N  
ATOM  19635  CA  MET Z  98      65.317  11.416  52.884  1.00 28.69           C  
ATOM  19636  C   MET Z  98      66.472  11.940  52.040  1.00 29.05           C  
ATOM  19637  O   MET Z  98      67.347  12.635  52.539  1.00 29.28           O  
ATOM  19638  CB  MET Z  98      65.661  10.010  53.374  1.00 28.02           C  
ATOM  19639  CG  MET Z  98      64.776   9.529  54.503  1.00 29.87           C  
ATOM  19640  SD  MET Z  98      65.102  10.437  56.021  1.00 31.50           S  
ATOM  19641  CE  MET Z  98      66.845   9.979  56.295  1.00 30.81           C  
ATOM  19642  N   ARG Z  99      66.460  11.621  50.751  1.00 28.86           N  
ATOM  19643  CA  ARG Z  99      67.544  12.022  49.867  1.00 28.58           C  
ATOM  19644  C   ARG Z  99      67.539  13.477  49.459  1.00 27.99           C  
ATOM  19645  O   ARG Z  99      68.588  14.092  49.369  1.00 27.87           O  
ATOM  19646  CB  ARG Z  99      67.521  11.198  48.572  1.00 28.29           C  
ATOM  19647  CG  ARG Z  99      67.912   9.750  48.717  1.00 28.21           C  
ATOM  19648  CD  ARG Z  99      67.664   8.950  47.459  1.00 26.86           C  
ATOM  19649  NE  ARG Z  99      68.078   7.572  47.650  1.00 29.01           N  
ATOM  19650  CZ  ARG Z  99      67.413   6.527  47.189  1.00 28.74           C  
ATOM  19651  NH1 ARG Z  99      66.305   6.700  46.483  1.00 29.47           N  
ATOM  19652  NH2 ARG Z  99      67.869   5.310  47.413  1.00 28.74           N  
ATOM  19653  N   TYR Z 100      66.355  14.020  49.214  1.00 28.09           N  
ATOM  19654  CA  TYR Z 100      66.237  15.296  48.546  1.00 28.29           C  
ATOM  19655  C   TYR Z 100      65.477  16.415  49.233  1.00 29.13           C  
ATOM  19656  O   TYR Z 100      65.635  17.571  48.868  1.00 28.72           O  
ATOM  19657  CB  TYR Z 100      65.640  15.043  47.151  1.00 28.20           C  
ATOM  19658  CG  TYR Z 100      66.407  13.979  46.414  1.00 28.31           C  
ATOM  19659  CD1 TYR Z 100      67.784  14.092  46.247  1.00 27.81           C  
ATOM  19660  CD2 TYR Z 100      65.774  12.856  45.908  1.00 26.81           C  
ATOM  19661  CE1 TYR Z 100      68.504  13.110  45.587  1.00 27.00           C  
ATOM  19662  CE2 TYR Z 100      66.488  11.874  45.255  1.00 25.92           C  
ATOM  19663  CZ  TYR Z 100      67.848  12.015  45.091  1.00 26.03           C  
ATOM  19664  OH  TYR Z 100      68.560  11.054  44.446  1.00 23.77           O  
ATOM  19665  N   ILE Z 101      64.627  16.079  50.199  1.00 30.29           N  
ATOM  19666  CA  ILE Z 101      63.828  17.088  50.875  1.00 30.71           C  
ATOM  19667  C   ILE Z 101      64.517  17.443  52.180  1.00 31.19           C  
ATOM  19668  O   ILE Z 101      64.574  18.607  52.594  1.00 31.65           O  
ATOM  19669  CB  ILE Z 101      62.427  16.519  51.160  1.00 30.81           C  
ATOM  19670  CG1 ILE Z 101      61.752  16.072  49.860  1.00 31.82           C  
ATOM  19671  CG2 ILE Z 101      61.579  17.523  51.906  1.00 31.21           C  
ATOM  19672  CD1 ILE Z 101      61.283  17.199  49.003  1.00 34.20           C  
ATOM  19673  N   ASN Z 102      65.026  16.398  52.821  1.00 32.18           N  
ATOM  19674  CA  ASN Z 102      65.823  16.492  54.027  1.00 32.77           C  
ATOM  19675  C   ASN Z 102      66.944  17.490  53.775  1.00 32.86           C  
ATOM  19676  O   ASN Z 102      67.589  17.447  52.736  1.00 32.57           O  
ATOM  19677  CB  ASN Z 102      66.383  15.108  54.330  1.00 33.59           C  
ATOM  19678  CG  ASN Z 102      67.293  15.081  55.541  1.00 35.64           C  
ATOM  19679  OD1 ASN Z 102      67.094  15.810  56.507  1.00 37.46           O  
ATOM  19680  ND2 ASN Z 102      68.282  14.211  55.497  1.00 36.44           N  
ATOM  19681  N   GLY Z 103      67.134  18.429  54.697  1.00 32.65           N  
ATOM  19682  CA  GLY Z 103      68.172  19.433  54.537  1.00 32.45           C  
ATOM  19683  C   GLY Z 103      67.872  20.550  53.553  1.00 32.28           C  
ATOM  19684  O   GLY Z 103      68.789  21.223  53.101  1.00 33.23           O  
ATOM  19685  N   THR Z 104      66.609  20.743  53.184  1.00 31.63           N  
ATOM  19686  CA  THR Z 104      66.263  21.868  52.317  1.00 31.20           C  
ATOM  19687  C   THR Z 104      65.334  22.754  53.111  1.00 31.93           C  
ATOM  19688  O   THR Z 104      65.055  22.462  54.273  1.00 31.95           O  
ATOM  19689  CB  THR Z 104      65.647  21.424  50.962  1.00 30.98           C  
ATOM  19690  OG1 THR Z 104      64.429  20.709  51.183  1.00 29.97           O  
ATOM  19691  CG2 THR Z 104      66.554  20.409  50.286  1.00 29.86           C  
ATOM  19692  N   ARG Z 105      64.835  23.821  52.503  1.00 32.15           N  
ATOM  19693  CA  ARG Z 105      64.056  24.797  53.266  1.00 33.03           C  
ATOM  19694  C   ARG Z 105      62.543  24.730  53.175  1.00 32.93           C  
ATOM  19695  O   ARG Z 105      61.973  24.449  52.125  1.00 32.48           O  
ATOM  19696  CB  ARG Z 105      64.490  26.224  52.907  1.00 33.29           C  
ATOM  19697  CG  ARG Z 105      65.963  26.489  53.139  1.00 34.75           C  
ATOM  19698  CD  ARG Z 105      66.358  27.959  53.098  1.00 37.43           C  
ATOM  19699  NE  ARG Z 105      67.807  28.080  53.206  1.00 40.51           N  
ATOM  19700  CZ  ARG Z 105      68.446  28.366  54.330  1.00 40.58           C  
ATOM  19701  NH1 ARG Z 105      67.765  28.587  55.453  1.00 38.11           N  
ATOM  19702  NH2 ARG Z 105      69.767  28.444  54.331  1.00 40.20           N  
ATOM  19703  N   LEU Z 106      61.912  25.046  54.305  1.00 32.84           N  
ATOM  19704  CA  LEU Z 106      60.476  25.195  54.411  1.00 32.96           C  
ATOM  19705  C   LEU Z 106      60.280  26.353  55.386  1.00 33.98           C  
ATOM  19706  O   LEU Z 106      60.723  26.280  56.533  1.00 33.31           O  
ATOM  19707  CB  LEU Z 106      59.834  23.921  54.941  1.00 32.74           C  
ATOM  19708  CG  LEU Z 106      58.301  23.943  54.895  1.00 32.66           C  
ATOM  19709  CD1 LEU Z 106      57.797  24.349  53.501  1.00 31.10           C  
ATOM  19710  CD2 LEU Z 106      57.761  22.591  55.277  1.00 32.32           C  
ATOM  19711  N   ASP Z 107      59.646  27.422  54.915  1.00 35.14           N  
ATOM  19712  CA  ASP Z 107      59.499  28.647  55.696  1.00 37.20           C  
ATOM  19713  C   ASP Z 107      60.896  29.159  56.037  1.00 37.80           C  
ATOM  19714  O   ASP Z 107      61.134  29.677  57.130  1.00 37.86           O  
ATOM  19715  CB  ASP Z 107      58.679  28.396  56.970  1.00 37.41           C  
ATOM  19716  CG  ASP Z 107      58.053  29.665  57.540  1.00 38.89           C  
ATOM  19717  OD1 ASP Z 107      58.274  30.766  56.993  1.00 37.56           O  
ATOM  19718  OD2 ASP Z 107      57.312  29.653  58.544  1.00 42.20           O  
ATOM  19719  N   ASP Z 108      61.817  28.978  55.092  1.00 38.63           N  
ATOM  19720  CA  ASP Z 108      63.201  29.429  55.225  1.00 38.95           C  
ATOM  19721  C   ASP Z 108      64.008  28.735  56.322  1.00 38.77           C  
ATOM  19722  O   ASP Z 108      65.129  29.139  56.615  1.00 39.74           O  
ATOM  19723  CB  ASP Z 108      63.312  30.955  55.365  1.00 39.24           C  
ATOM  19724  CG  ASP Z 108      64.740  31.444  55.155  1.00 40.79           C  
ATOM  19725  OD1 ASP Z 108      65.395  30.992  54.181  1.00 41.23           O  
ATOM  19726  OD2 ASP Z 108      65.288  32.260  55.927  1.00 42.02           O  
ATOM  19727  N   ARG Z 109      63.460  27.674  56.901  1.00 37.94           N  
ATOM  19728  CA  ARG Z 109      64.199  26.889  57.876  1.00 37.73           C  
ATOM  19729  C   ARG Z 109      64.659  25.593  57.236  1.00 37.66           C  
ATOM  19730  O   ARG Z 109      63.924  24.997  56.452  1.00 37.79           O  
ATOM  19731  CB  ARG Z 109      63.318  26.534  59.074  1.00 37.82           C  
ATOM  19732  CG  ARG Z 109      62.807  27.724  59.870  1.00 38.30           C  
ATOM  19733  CD  ARG Z 109      62.121  27.321  61.161  1.00 38.87           C  
ATOM  19734  NE  ARG Z 109      63.036  26.667  62.100  1.00 41.08           N  
ATOM  19735  CZ  ARG Z 109      63.892  27.327  62.893  1.00 42.23           C  
ATOM  19736  NH1 ARG Z 109      63.948  28.655  62.849  1.00 42.03           N  
ATOM  19737  NH2 ARG Z 109      64.693  26.663  63.719  1.00 42.29           N  
ATOM  19738  N   ILE Z 110      65.860  25.149  57.591  1.00 37.16           N  
ATOM  19739  CA  ILE Z 110      66.403  23.892  57.095  1.00 37.10           C  
ATOM  19740  C   ILE Z 110      65.796  22.756  57.883  1.00 36.51           C  
ATOM  19741  O   ILE Z 110      66.038  22.620  59.082  1.00 36.06           O  
ATOM  19742  CB  ILE Z 110      67.926  23.864  57.252  1.00 37.08           C  
ATOM  19743  CG1 ILE Z 110      68.558  24.979  56.429  1.00 37.79           C  
ATOM  19744  CG2 ILE Z 110      68.484  22.511  56.828  1.00 37.70           C  
ATOM  19745  CD1 ILE Z 110      70.033  25.119  56.659  1.00 41.71           C  
ATOM  19746  N   ILE Z 111      65.009  21.920  57.224  1.00 36.14           N  
ATOM  19747  CA  ILE Z 111      64.355  20.854  57.969  1.00 36.03           C  
ATOM  19748  C   ILE Z 111      65.197  19.601  58.002  1.00 35.89           C  
ATOM  19749  O   ILE Z 111      66.139  19.463  57.226  1.00 35.76           O  
ATOM  19750  CB  ILE Z 111      62.938  20.596  57.440  1.00 36.37           C  
ATOM  19751  CG1 ILE Z 111      62.973  20.049  56.010  1.00 36.42           C  
ATOM  19752  CG2 ILE Z 111      62.099  21.880  57.526  1.00 35.55           C  
ATOM  19753  CD1 ILE Z 111      61.598  19.979  55.376  1.00 38.51           C  
ATOM  19754  N   ARG Z 112      64.884  18.710  58.939  1.00 35.73           N  
ATOM  19755  CA  ARG Z 112      65.614  17.463  59.083  1.00 36.10           C  
ATOM  19756  C   ARG Z 112      64.614  16.336  59.080  1.00 35.06           C  
ATOM  19757  O   ARG Z 112      63.556  16.443  59.678  1.00 35.20           O  
ATOM  19758  CB  ARG Z 112      66.388  17.411  60.414  1.00 36.78           C  
ATOM  19759  CG  ARG Z 112      67.027  18.707  60.853  1.00 40.24           C  
ATOM  19760  CD  ARG Z 112      67.462  18.727  62.348  1.00 45.16           C  
ATOM  19761  NE  ARG Z 112      68.003  20.036  62.721  1.00 48.30           N  
ATOM  19762  CZ  ARG Z 112      68.025  20.524  63.946  1.00 51.05           C  
ATOM  19763  NH1 ARG Z 112      67.542  19.819  64.962  1.00 52.55           N  
ATOM  19764  NH2 ARG Z 112      68.538  21.732  64.160  1.00 54.00           N  
ATOM  19765  N   THR Z 113      64.950  15.241  58.426  1.00 34.18           N  
ATOM  19766  CA  THR Z 113      64.053  14.106  58.416  1.00 33.28           C  
ATOM  19767  C   THR Z 113      64.845  12.874  58.756  1.00 33.35           C  
ATOM  19768  O   THR Z 113      66.041  12.817  58.519  1.00 32.95           O  
ATOM  19769  CB  THR Z 113      63.427  13.927  57.024  1.00 33.46           C  
ATOM  19770  OG1 THR Z 113      64.458  13.573  56.083  1.00 31.26           O  
ATOM  19771  CG2 THR Z 113      62.882  15.251  56.502  1.00 32.69           C  
ATOM  19772  N   ASP Z 114      64.175  11.887  59.320  1.00 33.65           N  
ATOM  19773  CA  ASP Z 114      64.801  10.621  59.606  1.00 34.69           C  
ATOM  19774  C   ASP Z 114      63.705   9.584  59.726  1.00 35.20           C  
ATOM  19775  O   ASP Z 114      62.540   9.918  59.936  1.00 34.89           O  
ATOM  19776  CB  ASP Z 114      65.655  10.670  60.882  1.00 35.44           C  
ATOM  19777  CG  ASP Z 114      66.585   9.474  60.996  1.00 36.47           C  
ATOM  19778  OD1 ASP Z 114      66.988   8.941  59.944  1.00 38.92           O  
ATOM  19779  OD2 ASP Z 114      66.945   8.976  62.081  1.00 39.48           O  
ATOM  19780  N   TRP Z 115      64.093   8.327  59.578  1.00 35.85           N  
ATOM  19781  CA  TRP Z 115      63.167   7.223  59.589  1.00 36.98           C  
ATOM  19782  C   TRP Z 115      62.466   7.031  60.919  1.00 37.97           C  
ATOM  19783  O   TRP Z 115      63.082   7.103  61.981  1.00 37.72           O  
ATOM  19784  CB  TRP Z 115      63.906   5.939  59.232  1.00 36.85           C  
ATOM  19785  CG  TRP Z 115      64.402   5.962  57.830  1.00 38.46           C  
ATOM  19786  CD1 TRP Z 115      65.695   6.135  57.407  1.00 38.19           C  
ATOM  19787  CD2 TRP Z 115      63.608   5.845  56.654  1.00 38.13           C  
ATOM  19788  NE1 TRP Z 115      65.746   6.119  56.033  1.00 38.55           N  
ATOM  19789  CE2 TRP Z 115      64.475   5.942  55.546  1.00 38.86           C  
ATOM  19790  CE3 TRP Z 115      62.245   5.649  56.420  1.00 38.90           C  
ATOM  19791  CZ2 TRP Z 115      64.020   5.856  54.234  1.00 38.52           C  
ATOM  19792  CZ3 TRP Z 115      61.796   5.574  55.116  1.00 39.49           C  
ATOM  19793  CH2 TRP Z 115      62.682   5.676  54.040  1.00 38.18           C  
ATOM  19794  N   ASP Z 116      61.169   6.787  60.846  1.00 39.31           N  
ATOM  19795  CA  ASP Z 116      60.420   6.378  62.010  1.00 40.80           C  
ATOM  19796  C   ASP Z 116      60.313   4.868  61.881  1.00 42.22           C  
ATOM  19797  O   ASP Z 116      59.322   4.347  61.401  1.00 42.59           O  
ATOM  19798  CB  ASP Z 116      59.047   7.034  62.030  1.00 40.45           C  
ATOM  19799  CG  ASP Z 116      58.235   6.632  63.236  1.00 39.85           C  
ATOM  19800  OD1 ASP Z 116      57.129   7.167  63.394  1.00 39.29           O  
ATOM  19801  OD2 ASP Z 116      58.623   5.778  64.072  1.00 39.08           O  
ATOM  19802  N   ALA Z 117      61.363   4.165  62.289  1.00 44.33           N  
ATOM  19803  CA  ALA Z 117      61.421   2.721  62.115  1.00 46.26           C  
ATOM  19804  C   ALA Z 117      60.886   1.969  63.323  1.00 47.92           C  
ATOM  19805  O   ALA Z 117      60.814   2.517  64.432  1.00 48.13           O  
ATOM  19806  CB  ALA Z 117      62.847   2.275  61.789  1.00 46.20           C  
ATOM  19807  N   GLY Z 118      60.522   0.709  63.097  1.00 49.53           N  
ATOM  19808  CA  GLY Z 118      59.928  -0.138  64.122  1.00 51.58           C  
ATOM  19809  C   GLY Z 118      60.739  -0.269  65.398  1.00 52.68           C  
ATOM  19810  O   GLY Z 118      60.260  -0.836  66.387  1.00 53.31           O  
TER   19811      GLY Z 118                                                      
END
MOLECULE T0487_26_96.pdb
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
END
