
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  238 ( 1839),  selected  238 , name 2vss_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2vss_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    G     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    W     8_A      P      32           #
LGA    K     9_A      R      33          0.905
LGA    T    10_A      P      34          0.662
LGA    V    11_A      T      35          0.359
LGA    K    12_A      S      36          0.314
LGA    V    13_A      A      37          0.768
LGA    E    14_A      R      38          1.983
LGA    I    15_A      Q      39          1.966
LGA    E    16_A      L      40          2.792
LGA    D    17_A      D      41          2.144
LGA    G    18_A      G      42          2.060
LGA    I    19_A      I      43          1.453
LGA    A    20_A      R      44          1.068
LGA    F    21_A      N      45          0.866
LGA    V    22_A      I      46          0.708
LGA    I    23_A      V      47          0.158
LGA    L    24_A      L      48          0.622
LGA    N    25_A      S      49          1.074
LGA    R    26_A      N      50          0.740
LGA    P    27_A      P      51          0.650
LGA    E    28_A      K      52          0.551
LGA    K    29_A      K      53          0.720
LGA    R    30_A      R      54          0.844
LGA    N    31_A      N      55          0.457
LGA    A    32_A      T      56          0.483
LGA    M    33_A      L      57          0.352
LGA    S    34_A      S      58          0.413
LGA    P    35_A      L      59          0.260
LGA    T    36_A      A      60          0.443
LGA    L    37_A      M      61          0.989
LGA    N    38_A      L      62          1.206
LGA    R    39_A      K      63          1.363
LGA    E    40_A      S      64          1.429
LGA    M    41_A      L      65          1.605
LGA    I    42_A      Q      66          1.703
LGA    D    43_A      S      67          1.377
LGA    V    44_A      D      68          1.100
LGA    L    45_A      I      69          1.110
LGA    E    46_A      L      70          1.032
LGA    T    47_A      H      71          0.483
LGA    L    48_A      D      72          4.318
LGA    E    49_A      A      73          0.930
LGA    Q    50_A      D      74          3.400
LGA    D    51_A      S      75          3.940
LGA    P    52_A      N      76          3.706
LGA    A    53_A      D      77          3.526
LGA    A    54_A      L      78          2.843
LGA    G    55_A      K      79          1.445
LGA    V    56_A      V      80          0.889
LGA    L    57_A      I      81          0.588
LGA    V    58_A      I      82          0.433
LGA    L    59_A      I      83          0.616
LGA    T    60_A      S      84          0.363
LGA    G    61_A      A      85          0.445
LGA    A    62_A      E      86          1.031
LGA    G    63_A      G      87          1.292
LGA    E    64_A      P      88          1.296
LGA    A    65_A      V      89          1.746
LGA    W    66_A      F      90          1.422
LGA    T    67_A      S      91          1.054
LGA    A    68_A      S      92          1.224
LGA    G    69_A      G      93          1.138
LGA    M    70_A      H      94          1.098
LGA    D    71_A      D      95          1.488
LGA    L    72_A      L      96          1.349
LGA    -       -      K      97           -
LGA    -       -      E      98           -
LGA    -       -      L      99           -
LGA    -       -      T     100           -
LGA    -       -      E     101           -
LGA    A    81_A      E     102          4.217
LGA    G    82_A      Q     103          4.152
LGA    P    83_A      G     104          4.856
LGA    E    84_A      R     105          3.593
LGA    I    85_A      D     106          3.013
LGA    L    86_A      Y     107          3.395
LGA    Q    87_A      H     108          3.272
LGA    E    88_A      A     109          3.188
LGA    K    89_A      E     110          2.958
LGA    I    90_A      V     111          2.856
LGA    R    91_A      F     112          2.314
LGA    R    92_A      Q     113          1.881
LGA    E    93_A      T     114          1.367
LGA    A    94_A      C     115          1.427
LGA    S    95_A      S     116          1.198
LGA    Q    96_A      K     117          1.284
LGA    W    97_A      V     118          1.188
LGA    Q    98_A      M     119          2.471
LGA    W    99_A      -       -           -
LGA    K   100_A      M     120          1.249
LGA    L   101_A      H     121          0.534
LGA    L   102_A      I     122          0.600
LGA    R   103_A      R     123          1.272
LGA    M   104_A      N     124          2.232
LGA    Y   105_A      H     125          1.068
LGA    A   106_A      P     126          0.453
LGA    K   107_A      V     127          0.552
LGA    P   108_A      P     128          1.159
LGA    T   109_A      V     129          1.150
LGA    I   110_A      I     130          0.700
LGA    A   111_A      A     131          0.621
LGA    M   112_A      M     132          0.367
LGA    V   113_A      V     133          0.656
LGA    N   114_A      N     134          1.293
LGA    G   115_A      G     135          1.334
LGA    W   116_A      L     136          1.292
LGA    C   117_A      A     137          0.380
LGA    F   118_A      T     138          0.339
LGA    G   119_A      A     139          0.390
LGA    G   120_A      A     140          0.847
LGA    G   121_A      G     141          1.611
LGA    F   122_A      C     142          2.533
LGA    S   123_A      Q     143          2.485
LGA    P   124_A      L     144          2.141
LGA    L   125_A      V     145          1.412
LGA    V   126_A      A     146          2.077
LGA    A   127_A      S     147          2.209
LGA    C   128_A      C     148          1.191
LGA    D   129_A      D     149          0.757
LGA    L   130_A      I     150          0.601
LGA    A   131_A      A     151          0.737
LGA    I   132_A      V     152          0.390
LGA    C   133_A      A     153          0.273
LGA    A   134_A      S     154          0.530
LGA    D   135_A      D     155          0.544
LGA    E   136_A      K     156          0.882
LGA    A   137_A      S     157          1.058
LGA    T   138_A      S     158          1.904
LGA    F   139_A      F     159          1.175
LGA    G   140_A      A     160          0.917
LGA    L   141_A      T     161          1.162
LGA    S   142_A      P     162          0.958
LGA    E   143_A      G     163          1.118
LGA    I   144_A      V     164          1.886
LGA    N   145_A      N     165          1.775
LGA    W   146_A      V     166          1.699
LGA    G   147_A      G     167          1.847
LGA    I   148_A      L     168          1.986
LGA    P   149_A      F     169          1.674
LGA    P   150_A      C     170          1.236
LGA    G   151_A      S     171          3.006
LGA    N   152_A      T     172          2.289
LGA    L   153_A      -       -           -
LGA    V   154_A      P     173          1.412
LGA    S   155_A      G     174          1.189
LGA    K   156_A      V     175          2.178
LGA    A   157_A      A     176          1.241
LGA    M   158_A      L     177          1.484
LGA    A   159_A      A     178          1.652
LGA    D   160_A      R     179          1.487
LGA    T   161_A      A     180          1.740
LGA    V   162_A      V     181          0.809
LGA    G   163_A      P     182          1.361
LGA    H   164_A      R     183          1.976
LGA    R   165_A      K     184          1.454
LGA    Q   166_A      V     185          1.293
LGA    S   167_A      A     186          1.410
LGA    L   168_A      L     187          1.406
LGA    Y   169_A      E     188          1.513
LGA    Y   170_A      M     189          1.372
LGA    I   171_A      L     190          1.463
LGA    M   172_A      F     191          1.708
LGA    T   173_A      T     192          1.611
LGA    G   174_A      G     193          0.954
LGA    K   175_A      E     194          0.945
LGA    T   176_A      P     195          1.053
LGA    F   177_A      I     196          1.951
LGA    G   178_A      S     197          1.828
LGA    G   179_A      A     198          1.558
LGA    Q   180_A      Q     199          1.503
LGA    K   181_A      E     200          1.665
LGA    A   182_A      A     201          1.518
LGA    A   183_A      L     202          0.757
LGA    E   184_A      L     203          1.289
LGA    M   185_A      H     204          1.443
LGA    G   186_A      G     205          1.160
LGA    L   187_A      L     206          0.374
LGA    V   188_A      L     207          0.337
LGA    N   189_A      S     208          0.688
LGA    E   190_A      K     209          1.239
LGA    S   191_A      V     210          0.835
LGA    V   192_A      V     211          0.586
LGA    P   193_A      P     212          0.817
LGA    L   194_A      E     213          0.767
LGA    A   195_A      A     214          1.257
LGA    Q   196_A      E     215          1.088
LGA    L   197_A      L     216          0.452
LGA    R   198_A      Q     217          0.224
LGA    E   199_A      E     218          0.523
LGA    V   200_A      E     219          0.650
LGA    T   201_A      T     220          0.596
LGA    I   202_A      M     221          0.308
LGA    E   203_A      R     222          0.687
LGA    L   204_A      I     223          1.082
LGA    A   205_A      A     224          0.821
LGA    R   206_A      R     225          1.179
LGA    N   207_A      K     226          1.320
LGA    L   208_A      I     227          1.202
LGA    L   209_A      A     228          1.501
LGA    E   210_A      S     229          2.068
LGA    K   211_A      L     230          1.761
LGA    N   212_A      S     231          1.084
LGA    P   213_A      R     232          1.329
LGA    V   214_A      P     233          1.652
LGA    V   215_A      V     234          1.274
LGA    L   216_A      V     235          1.122
LGA    R   217_A      S     236          1.878
LGA    A   218_A      L     237          2.157
LGA    A   219_A      G     238          1.979
LGA    K   220_A      K     239          2.553
LGA    H   221_A      A     240          2.726
LGA    G   222_A      T     241          2.313
LGA    F   223_A      F     242          2.408
LGA    K   224_A      Y     243          2.806
LGA    R   225_A      K     244          2.915
LGA    C   226_A      Q     245          2.234
LGA    R   227_A      L     246          2.535
LGA    E   228_A      P     247          0.665
LGA    L   229_A      Q     248          0.434
LGA    T   230_A      D     249          0.215
LGA    W   231_A      L     250          1.040
LGA    E   232_A      G     251          1.627
LGA    Q   233_A      T     252          1.490
LGA    N   234_A      A     253          1.244
LGA    E   235_A      Y     254          2.563
LGA    D   236_A      Y     255          2.572
LGA    Y   237_A      L     256          1.932
LGA    L   238_A      T     257          1.490
LGA    Y   239_A      S     258          2.675
LGA    A   240_A      Q     259          3.451
LGA    K   241_A      A     260          2.942
LGA    L   242_A      M     261          3.000
LGA    D   243_A      V     262          4.047
LGA    Q   244_A      D     263          4.381
LGA    S   245_A      N     264          3.700
LGA    R   246_A      L     265          4.365
LGA    L   247_A      A     266          5.290
LGA    L   248_A      L     267           #
LGA    D   249_A      R     268          5.062
LGA    -       -      D     269           -
LGA    -       -      G     270           -
LGA    -       -      Q     271           -
LGA    -       -      E     272           -
LGA    -       -      G     273           -
LGA    -       -      I     274           -
LGA    -       -      T     275           -
LGA    -       -      A     276           -
LGA    -       -      F     277           -
LGA    -       -      L     278           -
LGA    -       -      Q     279           -
LGA    -       -      K     280           -
LGA    -       -      R     281           -
LGA    -       -      K     282           -
LGA    -       -      P     283           -
LGA    -       -      V     284           -
LGA    -       -      W     285           -
LGA    -       -      S     286           -
LGA    -       -      H     287           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  238  256    5.0    230    1.83    22.61     81.370    11.928

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.915354 * X  +   0.141453 * Y  +   0.376986 * Z  +  33.587921
  Y_new =  -0.036610 * X  +  -0.961621 * Y  +   0.271927 * Z  +  87.328011
  Z_new =   0.400982 * X  +   0.235108 * Y  +   0.885402 * Z  +  66.617119 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.259548   -2.882045  [ DEG:    14.8710   -165.1290 ]
  Theta =  -0.412589   -2.729004  [ DEG:   -23.6396   -156.3604 ]
  Phi   =  -3.101618    0.039975  [ DEG:  -177.7096      2.2904 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vss_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vss_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  238  256   5.0  230   1.83   22.61  81.370
REMARK  ---------------------------------------------------------- 
MOLECULE 2vss_A
HEADER    LYASE                                   29-APR-08   2VSS              
TITLE     WILD-TYPE HYDROXYCINNAMOYL-COA HYDRATASE LYASE IN COMPLEX             
TITLE    2 WITH ACETYL-COA AND VANILLIN                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND   3 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE;                       
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 EC: 4.2.1.101;                                                       
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND   9 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE;                       
COMPND  10 CHAIN: E;                                                            
COMPND  11 EC: 4.2.1.101;                                                       
COMPND  12 ENGINEERED: YES;                                                     
COMPND  13 MOL_ID: 3;                                                           
COMPND  14 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  15 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE;                       
COMPND  16 CHAIN: F;                                                            
COMPND  17 EC: 4.2.1.101;                                                       
COMPND  18 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE   5 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   6 STRAIN: AN103;                                                       
SOURCE   7 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH U.K.;             
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  12 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  13 STRAIN: AN103;                                                       
SOURCE  14 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH U.K.;             
SOURCE  15 MOL_ID: 3;                                                           
SOURCE  16 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  17 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  19 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  20 STRAIN: AN103;                                                       
SOURCE  21 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH U.K.              
KEYWDS    LYASE, ALDOLASE, CROTONASE, HYDRATASE                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.P.BENNETT,L.M.BERTIN,A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN             
REVDAT   1   27-MAY-08 2VSS    0                                                
JRNL        AUTH   J.P.BENNETT,L.M.BERTIN,B.MOULTON,I.J.S.FAIRLAMB,             
JRNL        AUTH 2 A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN                           
JRNL        TITL   A TERNARY COMPLEX OF HYDROXYCINNAMOYL-COA                    
JRNL        TITL 2 HYDRATASE-LYASE (HCHL) WITH ACETYL-COENZYME A AND            
JRNL        TITL 3 VANILLIN GIVES INSIGHTS INTO SUBSTRATE SPECIFICITY           
JRNL        TITL 4 AND MECHANISM.                                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.22 ANGSTROMS.                                          
DBREF  2VSS A    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS B    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS C    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS D    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS E    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS F    1   276  UNP    O69762   O69762_PSEFL     1    276             
SEQRES   1 A  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 A  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 A  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 A  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 A  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 A  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 A  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 A  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 A  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 A  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 A  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 A  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 A  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 A  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 A  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 A  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 A  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 A  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 A  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 A  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 A  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 A  276  TYR LYS ARG                                                  
SEQRES   1 B  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 B  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 B  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 B  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 B  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 B  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 B  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 B  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 B  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 B  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 B  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 B  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 B  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 B  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 B  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 B  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 B  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 B  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 B  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 B  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 B  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 B  276  TYR LYS ARG                                                  
SEQRES   1 C  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 C  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 C  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 C  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 C  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 C  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 C  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 C  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 C  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 C  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 C  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 C  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 C  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 C  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 C  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 C  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 C  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 C  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 C  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 C  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 C  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 C  276  TYR LYS ARG                                                  
SEQRES   1 D  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 D  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 D  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 D  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 D  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 D  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 D  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 D  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 D  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 D  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 D  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 D  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 D  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 D  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 D  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 D  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 D  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 D  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 D  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 D  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 D  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 D  276  TYR LYS ARG                                                  
SEQRES   1 E  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 E  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 E  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 E  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 E  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 E  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 E  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 E  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 E  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 E  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 E  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 E  276  ILE ASN TYR GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 E  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 E  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 E  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 E  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 E  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 E  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 E  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 E  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 E  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 E  276  TYR LYS ARG                                                  
SEQRES   1 F  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 F  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 F  276  PRO GLU ARG ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 F  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 F  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 F  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 F  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 F  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 F  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 F  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 F  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 F  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 F  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 F  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 F  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 F  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 F  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 F  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 F  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 F  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 F  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 F  276  TYR LYS ARG                                                  
HET    ACO  B1251      51                                                       
HET    ACO  D1249      51                                                       
HET    ACO  E1250      51                                                       
HET    ACO  F1249      51                                                       
HET    V55  D1250      11                                                       
HETNAM     ACO ACETYL COENZYME *A                                               
HETNAM     V55 4-HYDROXY-3-METHOXYBENZALDEHYDE                                  
FORMUL   7  ACO    4(C23 H38 N7 O17 P3 S1)                                      
FORMUL   8  V55    C8 H8 O3                                                     
FORMUL   9  HOH   *316(H2 O1)                                                   
CRYST1   90.223  130.595  144.663  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   TYR A   4     -36.782 105.619  20.387  1.00 52.70           N  
ATOM      2  CA  TYR A   4     -35.921 106.719  20.917  1.00 52.68           C  
ATOM      3  C   TYR A   4     -35.992 108.006  20.110  1.00 53.39           C  
ATOM      4  O   TYR A   4     -35.139 108.891  20.244  1.00 53.33           O  
ATOM      5  CB  TYR A   4     -34.499 106.215  21.061  1.00 52.14           C  
ATOM      6  CG  TYR A   4     -34.413 105.094  22.063  1.00 51.85           C  
ATOM      7  CD1 TYR A   4     -34.632 105.331  23.415  1.00 51.89           C  
ATOM      8  CD2 TYR A   4     -34.139 103.787  21.661  1.00 51.04           C  
ATOM      9  CE1 TYR A   4     -34.576 104.289  24.347  1.00 52.66           C  
ATOM     10  CE2 TYR A   4     -34.077 102.744  22.583  1.00 50.62           C  
ATOM     11  CZ  TYR A   4     -34.297 103.002  23.923  1.00 51.85           C  
ATOM     12  OH  TYR A   4     -34.251 101.972  24.846  1.00 52.37           O  
ATOM     13  N   GLU A   5     -37.043 108.112  19.293  1.00 54.37           N  
ATOM     14  CA  GLU A   5     -37.335 109.294  18.481  1.00 54.37           C  
ATOM     15  C   GLU A   5     -37.260 110.566  19.336  1.00 54.31           C  
ATOM     16  O   GLU A   5     -38.046 110.719  20.286  1.00 53.71           O  
ATOM     17  CB  GLU A   5     -38.723 109.114  17.814  1.00 55.30           C  
ATOM     18  CG  GLU A   5     -39.366 110.340  17.058  1.00 55.19           C  
ATOM     19  CD  GLU A   5     -38.521 110.878  15.897  1.00 55.44           C  
ATOM     20  OE1 GLU A   5     -37.284 110.662  15.894  1.00 55.38           O  
ATOM     21  OE2 GLU A   5     -39.085 111.524  14.985  1.00 51.44           O  
ATOM     22  N   GLY A   6     -36.267 111.419  19.034  1.00 53.65           N  
ATOM     23  CA  GLY A   6     -36.103 112.751  19.653  1.00 53.25           C  
ATOM     24  C   GLY A   6     -35.968 112.853  21.173  1.00 53.18           C  
ATOM     25  O   GLY A   6     -36.317 113.880  21.759  1.00 53.68           O  
ATOM     26  N   ARG A   7     -35.453 111.797  21.802  1.00 52.58           N  
ATOM     27  CA  ARG A   7     -35.225 111.717  23.253  1.00 51.78           C  
ATOM     28  C   ARG A   7     -33.984 112.491  23.782  1.00 51.23           C  
ATOM     29  O   ARG A   7     -33.987 113.034  24.914  1.00 51.20           O  
ATOM     30  CB  ARG A   7     -35.087 110.249  23.632  1.00 51.76           C  
ATOM     31  CG  ARG A   7     -34.941 110.039  25.115  1.00 54.38           C  
ATOM     32  CD  ARG A   7     -35.567 108.727  25.562  1.00 59.41           C  
ATOM     33  NE  ARG A   7     -34.998 108.293  26.841  1.00 62.58           N  
ATOM     34  CZ  ARG A   7     -35.203 107.090  27.378  1.00 65.29           C  
ATOM     35  NH1 ARG A   7     -35.962 106.197  26.734  1.00 64.86           N  
ATOM     36  NH2 ARG A   7     -34.639 106.771  28.550  1.00 64.86           N  
ATOM     37  N   TRP A   8     -32.916 112.494  22.980  1.00 50.09           N  
ATOM     38  CA  TRP A   8     -31.656 113.140  23.359  1.00 48.84           C  
ATOM     39  C   TRP A   8     -31.316 114.257  22.423  1.00 49.18           C  
ATOM     40  O   TRP A   8     -31.520 114.152  21.202  1.00 48.12           O  
ATOM     41  CB  TRP A   8     -30.489 112.134  23.435  1.00 47.73           C  
ATOM     42  CG  TRP A   8     -30.731 111.136  24.499  1.00 45.51           C  
ATOM     43  CD1 TRP A   8     -30.662 111.341  25.842  1.00 44.67           C  
ATOM     44  CD2 TRP A   8     -31.166 109.791  24.313  1.00 44.04           C  
ATOM     45  NE1 TRP A   8     -31.016 110.183  26.516  1.00 45.06           N  
ATOM     46  CE2 TRP A   8     -31.321 109.219  25.594  1.00 43.99           C  
ATOM     47  CE3 TRP A   8     -31.410 109.003  23.187  1.00 44.17           C  
ATOM     48  CZ2 TRP A   8     -31.706 107.891  25.782  1.00 47.35           C  
ATOM     49  CZ3 TRP A   8     -31.791 107.685  23.368  1.00 45.31           C  
ATOM     50  CH2 TRP A   8     -31.948 107.144  24.658  1.00 46.17           C  
ATOM     51  N   LYS A   9     -30.804 115.320  23.029  1.00 49.75           N  
ATOM     52  CA  LYS A   9     -30.478 116.549  22.345  1.00 50.96           C  
ATOM     53  C   LYS A   9     -29.240 116.397  21.446  1.00 50.99           C  
ATOM     54  O   LYS A   9     -29.243 116.838  20.300  1.00 51.53           O  
ATOM     55  CB  LYS A   9     -30.250 117.644  23.390  1.00 51.58           C  
ATOM     56  CG  LYS A   9     -31.014 118.923  23.130  1.00 54.89           C  
ATOM     57  CD  LYS A   9     -30.692 119.974  24.188  1.00 59.81           C  
ATOM     58  CE  LYS A   9     -31.655 119.894  25.392  1.00 62.58           C  
ATOM     59  NZ  LYS A   9     -31.214 120.758  26.547  1.00 62.36           N  
ATOM     60  N   THR A  10     -28.184 115.758  21.955  1.00 50.52           N  
ATOM     61  CA  THR A  10     -26.914 115.683  21.204  1.00 49.65           C  
ATOM     62  C   THR A  10     -26.562 114.278  20.663  1.00 49.30           C  
ATOM     63  O   THR A  10     -25.574 114.130  19.962  1.00 49.12           O  
ATOM     64  CB  THR A  10     -25.717 116.259  22.025  1.00 49.54           C  
ATOM     65  OG1 THR A  10     -25.482 115.421  23.151  1.00 49.88           O  
ATOM     66  CG2 THR A  10     -25.956 117.682  22.524  1.00 47.87           C  
ATOM     67  N   VAL A  11     -27.373 113.263  20.983  1.00 49.53           N  
ATOM     68  CA  VAL A  11     -27.185 111.874  20.509  1.00 49.87           C  
ATOM     69  C   VAL A  11     -28.460 111.297  19.865  1.00 50.54           C  
ATOM     70  O   VAL A  11     -29.572 111.743  20.185  1.00 50.71           O  
ATOM     71  CB  VAL A  11     -26.795 110.933  21.676  1.00 49.85           C  
ATOM     72  CG1 VAL A  11     -26.234 109.608  21.143  1.00 49.76           C  
ATOM     73  CG2 VAL A  11     -25.785 111.615  22.596  1.00 50.34           C  
ATOM     74  N   LYS A  12     -28.310 110.284  19.001  1.00 50.85           N  
ATOM     75  CA  LYS A  12     -29.481 109.581  18.415  1.00 51.59           C  
ATOM     76  C   LYS A  12     -29.455 108.029  18.574  1.00 51.75           C  
ATOM     77  O   LYS A  12     -28.396 107.412  18.425  1.00 52.05           O  
ATOM     78  CB  LYS A  12     -29.660 109.984  16.934  1.00 50.99           C  
ATOM     79  N   VAL A  13     -30.597 107.380  18.862  1.00 51.89           N  
ATOM     80  CA  VAL A  13     -30.593 105.900  18.836  1.00 51.51           C  
ATOM     81  C   VAL A  13     -31.502 105.259  17.766  1.00 51.86           C  
ATOM     82  O   VAL A  13     -32.654 105.655  17.555  1.00 51.62           O  
ATOM     83  CB  VAL A  13     -30.687 105.240  20.267  1.00 51.78           C  
ATOM     84  CG1 VAL A  13     -30.412 103.729  20.214  1.00 51.24           C  
ATOM     85  CG2 VAL A  13     -29.661 105.875  21.193  1.00 50.38           C  
ATOM     86  N   GLU A  14     -30.931 104.283  17.070  1.00 52.30           N  
ATOM     87  CA  GLU A  14     -31.602 103.562  15.996  1.00 53.17           C  
ATOM     88  C   GLU A  14     -31.320 102.068  16.086  1.00 53.39           C  
ATOM     89  O   GLU A  14     -30.243 101.619  15.651  1.00 53.57           O  
ATOM     90  CB  GLU A  14     -31.114 104.083  14.648  1.00 52.82           C  
ATOM     91  CG  GLU A  14     -31.813 105.380  14.216  1.00 54.48           C  
ATOM     92  CD  GLU A  14     -31.260 105.985  12.913  1.00 54.28           C  
ATOM     93  OE1 GLU A  14     -30.400 105.353  12.237  1.00 55.63           O  
ATOM     94  OE2 GLU A  14     -31.682 107.116  12.580  1.00 55.56           O  
ATOM     95  N   ILE A  15     -32.254 101.305  16.660  1.00 53.41           N  
ATOM     96  CA  ILE A  15     -32.110  99.857  16.672  1.00 54.58           C  
ATOM     97  C   ILE A  15     -32.721  99.285  15.397  1.00 55.34           C  
ATOM     98  O   ILE A  15     -33.800  99.705  14.961  1.00 55.42           O  
ATOM     99  CB  ILE A  15     -32.793  99.167  17.889  1.00 55.24           C  
ATOM    100  CG1 ILE A  15     -32.345  99.753  19.242  1.00 55.93           C  
ATOM    101  CG2 ILE A  15     -32.561  97.641  17.866  1.00 55.96           C  
ATOM    102  CD1 ILE A  15     -33.366 100.659  19.864  1.00 56.53           C  
ATOM    103  N   GLU A  16     -32.024  98.329  14.794  1.00 55.95           N  
ATOM    104  CA  GLU A  16     -32.556  97.582  13.657  1.00 56.41           C  
ATOM    105  C   GLU A  16     -32.134  96.128  13.816  1.00 56.62           C  
ATOM    106  O   GLU A  16     -30.957  95.792  13.671  1.00 56.77           O  
ATOM    107  CB  GLU A  16     -32.113  98.177  12.299  1.00 56.79           C  
ATOM    108  CG  GLU A  16     -30.676  98.706  12.191  1.00 56.16           C  
ATOM    109  CD  GLU A  16     -30.151  98.712  10.751  1.00 57.31           C  
ATOM    110  OE1 GLU A  16     -30.225  97.627  10.138  1.00 59.04           O  
ATOM    111  OE2 GLU A  16     -29.649  99.762  10.234  1.00 56.09           O  
ATOM    112  N   ASP A  17     -33.100  95.287  14.178  1.00 56.92           N  
ATOM    113  CA  ASP A  17     -32.895  93.843  14.300  1.00 56.98           C  
ATOM    114  C   ASP A  17     -31.702  93.467  15.191  1.00 56.24           C  
ATOM    115  O   ASP A  17     -30.811  92.715  14.766  1.00 56.57           O  
ATOM    116  N   GLY A  18     -31.697  93.991  16.412  1.00 55.30           N  
ATOM    117  CA  GLY A  18     -30.675  93.639  17.404  1.00 53.59           C  
ATOM    118  C   GLY A  18     -29.559  94.654  17.538  1.00 51.99           C  
ATOM    119  O   GLY A  18     -29.062  94.893  18.637  1.00 51.95           O  
ATOM    120  N   ILE A  19     -29.160  95.263  16.427  1.00 50.99           N  
ATOM    121  CA  ILE A  19     -28.091  96.273  16.456  1.00 48.90           C  
ATOM    122  C   ILE A  19     -28.628  97.626  16.876  1.00 47.60           C  
ATOM    123  O   ILE A  19     -29.477  98.177  16.191  1.00 46.30           O  
ATOM    124  CB  ILE A  19     -27.453  96.451  15.073  1.00 49.79           C  
ATOM    125  CG1 ILE A  19     -27.412  95.095  14.325  1.00 49.28           C  
ATOM    126  CG2 ILE A  19     -26.094  97.153  15.207  1.00 47.98           C  
ATOM    127  CD1 ILE A  19     -26.604  95.115  13.022  1.00 48.94           C  
ATOM    128  N   ALA A  20     -28.143  98.162  17.998  1.00 45.98           N  
ATOM    129  CA  ALA A  20     -28.395  99.567  18.287  1.00 45.31           C  
ATOM    130  C   ALA A  20     -27.239 100.442  17.820  1.00 45.01           C  
ATOM    131  O   ALA A  20     -26.168 100.429  18.413  1.00 45.31           O  
ATOM    132  CB  ALA A  20     -28.683  99.807  19.739  1.00 43.99           C  
ATOM    133  N   PHE A  21     -27.483 101.224  16.776  1.00 45.17           N  
ATOM    134  CA  PHE A  21     -26.580 102.309  16.360  1.00 45.59           C  
ATOM    135  C   PHE A  21     -26.696 103.508  17.304  1.00 45.55           C  
ATOM    136  O   PHE A  21     -27.771 104.110  17.444  1.00 46.28           O  
ATOM    137  CB  PHE A  21     -26.883 102.735  14.922  1.00 45.78           C  
ATOM    138  CG  PHE A  21     -26.611 101.652  13.929  1.00 46.58           C  
ATOM    139  CD1 PHE A  21     -27.515 100.597  13.764  1.00 46.69           C  
ATOM    140  CD2 PHE A  21     -25.427 101.647  13.204  1.00 44.21           C  
ATOM    141  CE1 PHE A  21     -27.235  99.579  12.854  1.00 47.84           C  
ATOM    142  CE2 PHE A  21     -25.150 100.634  12.314  1.00 45.05           C  
ATOM    143  CZ  PHE A  21     -26.047  99.600  12.127  1.00 44.91           C  
ATOM    144  N   VAL A  22     -25.608 103.823  17.983  1.00 44.60           N  
ATOM    145  CA  VAL A  22     -25.570 105.006  18.801  1.00 45.18           C  
ATOM    146  C   VAL A  22     -24.855 106.072  17.969  1.00 45.70           C  
ATOM    147  O   VAL A  22     -23.689 105.919  17.643  1.00 44.92           O  
ATOM    148  CB  VAL A  22     -24.801 104.732  20.122  1.00 45.82           C  
ATOM    149  CG1 VAL A  22     -24.602 106.021  20.909  1.00 45.55           C  
ATOM    150  CG2 VAL A  22     -25.499 103.634  20.955  1.00 44.77           C  
ATOM    151  N   ILE A  23     -25.565 107.136  17.623  1.00 45.92           N  
ATOM    152  CA  ILE A  23     -25.028 108.147  16.737  1.00 46.75           C  
ATOM    153  C   ILE A  23     -24.737 109.466  17.454  1.00 46.95           C  
ATOM    154  O   ILE A  23     -25.662 110.193  17.874  1.00 47.19           O  
ATOM    155  CB  ILE A  23     -25.974 108.416  15.577  1.00 46.40           C  
ATOM    156  CG1 ILE A  23     -26.376 107.096  14.921  1.00 47.57           C  
ATOM    157  CG2 ILE A  23     -25.321 109.314  14.551  1.00 47.21           C  
ATOM    158  CD1 ILE A  23     -27.811 107.111  14.349  1.00 48.72           C  
ATOM    159  N   LEU A  24     -23.447 109.769  17.587  1.00 46.58           N  
ATOM    160  CA  LEU A  24     -23.026 111.108  18.049  1.00 46.25           C  
ATOM    161  C   LEU A  24     -23.582 112.220  17.140  1.00 45.84           C  
ATOM    162  O   LEU A  24     -23.375 112.215  15.943  1.00 45.37           O  
ATOM    163  CB  LEU A  24     -21.512 111.202  18.243  1.00 45.53           C  
ATOM    164  CG  LEU A  24     -20.845 110.160  19.168  1.00 44.21           C  
ATOM    165  CD1 LEU A  24     -19.357 110.393  19.177  1.00 42.51           C  
ATOM    166  CD2 LEU A  24     -21.372 110.170  20.580  1.00 44.53           C  
ATOM    167  N   ASN A  25     -24.297 113.168  17.732  1.00 46.66           N  
ATOM    168  CA  ASN A  25     -25.168 114.013  16.940  1.00 48.11           C  
ATOM    169  C   ASN A  25     -25.013 115.534  17.147  1.00 49.16           C  
ATOM    170  O   ASN A  25     -25.976 116.261  17.473  1.00 48.97           O  
ATOM    171  CB  ASN A  25     -26.616 113.531  17.085  1.00 47.56           C  
ATOM    172  CG  ASN A  25     -27.515 113.990  15.943  1.00 48.45           C  
ATOM    173  OD1 ASN A  25     -28.721 114.095  16.129  1.00 47.23           O  
ATOM    174  ND2 ASN A  25     -26.941 114.256  14.763  1.00 47.55           N  
ATOM    175  N   ARG A  26     -23.784 116.004  16.912  1.00 49.56           N  
ATOM    176  CA  ARG A  26     -23.504 117.426  16.769  1.00 50.47           C  
ATOM    177  C   ARG A  26     -22.617 117.595  15.523  1.00 51.08           C  
ATOM    178  O   ARG A  26     -21.460 118.022  15.633  1.00 51.32           O  
ATOM    179  CB  ARG A  26     -22.827 117.976  18.038  1.00 50.32           C  
ATOM    180  CG  ARG A  26     -23.621 117.656  19.304  1.00 50.89           C  
ATOM    181  CD  ARG A  26     -22.931 118.073  20.566  1.00 52.20           C  
ATOM    182  NE  ARG A  26     -22.896 119.528  20.718  1.00 51.87           N  
ATOM    183  CZ  ARG A  26     -21.785 120.261  20.769  1.00 50.95           C  
ATOM    184  NH1 ARG A  26     -20.581 119.694  20.692  1.00 46.95           N  
ATOM    185  NH2 ARG A  26     -21.890 121.577  20.909  1.00 49.20           N  
ATOM    186  N   PRO A  27     -23.151 117.245  14.334  1.00 51.22           N  
ATOM    187  CA  PRO A  27     -22.311 117.200  13.145  1.00 51.80           C  
ATOM    188  C   PRO A  27     -21.802 118.608  12.765  1.00 52.09           C  
ATOM    189  O   PRO A  27     -20.723 118.755  12.203  1.00 51.27           O  
ATOM    190  CB  PRO A  27     -23.238 116.607  12.076  1.00 51.86           C  
ATOM    191  CG  PRO A  27     -24.595 116.898  12.527  1.00 52.08           C  
ATOM    192  CD  PRO A  27     -24.551 116.901  14.029  1.00 51.74           C  
ATOM    193  N   GLU A  28     -22.596 119.609  13.135  1.00 53.06           N  
ATOM    194  CA  GLU A  28     -22.284 121.032  13.057  1.00 54.03           C  
ATOM    195  C   GLU A  28     -21.059 121.443  13.911  1.00 53.70           C  
ATOM    196  O   GLU A  28     -20.416 122.479  13.648  1.00 53.48           O  
ATOM    197  CB  GLU A  28     -23.536 121.813  13.492  1.00 54.83           C  
ATOM    198  CG  GLU A  28     -23.481 123.301  13.257  1.00 58.09           C  
ATOM    199  CD  GLU A  28     -24.792 123.847  12.681  1.00 64.79           C  
ATOM    200  OE1 GLU A  28     -25.149 123.528  11.507  1.00 62.98           O  
ATOM    201  OE2 GLU A  28     -25.468 124.610  13.422  1.00 69.08           O  
ATOM    202  N   LYS A  29     -20.740 120.650  14.934  1.00 52.72           N  
ATOM    203  CA  LYS A  29     -19.537 120.900  15.716  1.00 52.02           C  
ATOM    204  C   LYS A  29     -18.616 119.706  15.576  1.00 51.72           C  
ATOM    205  O   LYS A  29     -17.699 119.541  16.362  1.00 52.07           O  
ATOM    206  CB  LYS A  29     -19.880 121.171  17.187  1.00 52.31           C  
ATOM    207  CG  LYS A  29     -20.699 122.446  17.465  1.00 52.45           C  
ATOM    208  CD  LYS A  29     -19.896 123.690  17.227  1.00 53.74           C  
ATOM    209  CE  LYS A  29     -20.664 124.940  17.541  1.00 55.18           C  
ATOM    210  NZ  LYS A  29     -19.889 126.145  17.044  1.00 57.72           N  
ATOM    211  N   ARG A  30     -18.865 118.882  14.557  1.00 51.47           N  
ATOM    212  CA  ARG A  30     -18.033 117.700  14.235  1.00 51.43           C  
ATOM    213  C   ARG A  30     -18.120 116.646  15.342  1.00 50.88           C  
ATOM    214  O   ARG A  30     -17.172 115.888  15.568  1.00 50.18           O  
ATOM    215  CB  ARG A  30     -16.568 118.089  13.942  1.00 51.57           C  
ATOM    216  CG  ARG A  30     -16.205 118.258  12.447  1.00 54.10           C  
ATOM    217  CD  ARG A  30     -17.047 119.342  11.802  1.00 58.64           C  
ATOM    218  NE  ARG A  30     -17.059 119.303  10.337  1.00 61.84           N  
ATOM    219  CZ  ARG A  30     -18.005 119.865   9.583  1.00 63.02           C  
ATOM    220  NH1 ARG A  30     -17.931 119.793   8.265  1.00 64.27           N  
ATOM    221  NH2 ARG A  30     -19.043 120.479  10.143  1.00 62.84           N  
ATOM    222  N   ASN A  31     -19.282 116.645  16.012  1.00 49.91           N  
ATOM    223  CA  ASN A  31     -19.660 115.753  17.126  1.00 48.60           C  
ATOM    224  C   ASN A  31     -18.758 115.936  18.337  1.00 47.78           C  
ATOM    225  O   ASN A  31     -18.473 114.977  19.091  1.00 46.86           O  
ATOM    226  CB  ASN A  31     -19.743 114.290  16.689  1.00 49.00           C  
ATOM    227  CG  ASN A  31     -20.604 114.094  15.446  1.00 49.97           C  
ATOM    228  OD1 ASN A  31     -21.668 114.705  15.307  1.00 50.81           O  
ATOM    229  ND2 ASN A  31     -20.171 113.210  14.561  1.00 49.85           N  
ATOM    230  N   ALA A  32     -18.328 117.183  18.523  1.00 46.82           N  
ATOM    231  CA  ALA A  32     -17.444 117.514  19.640  1.00 47.20           C  
ATOM    232  C   ALA A  32     -18.154 117.196  20.948  1.00 46.91           C  
ATOM    233  O   ALA A  32     -19.380 117.378  21.077  1.00 47.26           O  
ATOM    234  CB  ALA A  32     -16.923 118.968  19.573  1.00 46.79           C  
ATOM    235  N   MET A  33     -17.390 116.639  21.892  1.00 46.65           N  
ATOM    236  CA  MET A  33     -17.963 116.141  23.154  1.00 45.89           C  
ATOM    237  C   MET A  33     -18.114 117.210  24.241  1.00 44.87           C  
ATOM    238  O   MET A  33     -17.182 117.475  24.965  1.00 44.89           O  
ATOM    239  CB  MET A  33     -17.155 114.945  23.636  1.00 45.68           C  
ATOM    240  CG  MET A  33     -17.134 113.830  22.601  1.00 45.55           C  
ATOM    241  SD  MET A  33     -16.186 112.406  23.086  1.00 46.25           S  
ATOM    242  CE  MET A  33     -14.633 112.855  22.390  1.00 47.16           C  
ATOM    243  N   SER A  34     -19.288 117.845  24.309  1.00 44.15           N  
ATOM    244  CA  SER A  34     -19.629 118.816  25.359  1.00 43.25           C  
ATOM    245  C   SER A  34     -20.097 118.110  26.605  1.00 43.48           C  
ATOM    246  O   SER A  34     -20.474 116.928  26.540  1.00 44.04           O  
ATOM    247  CB  SER A  34     -20.773 119.704  24.908  1.00 43.01           C  
ATOM    248  OG  SER A  34     -21.855 118.907  24.516  1.00 41.06           O  
ATOM    249  N   PRO A  35     -20.090 118.821  27.762  1.00 43.50           N  
ATOM    250  CA  PRO A  35     -20.705 118.234  28.950  1.00 43.27           C  
ATOM    251  C   PRO A  35     -22.128 117.716  28.692  1.00 44.36           C  
ATOM    252  O   PRO A  35     -22.543 116.729  29.299  1.00 45.36           O  
ATOM    253  CB  PRO A  35     -20.701 119.400  29.941  1.00 43.37           C  
ATOM    254  CG  PRO A  35     -19.540 120.202  29.568  1.00 41.97           C  
ATOM    255  CD  PRO A  35     -19.490 120.137  28.065  1.00 42.74           C  
ATOM    256  N   THR A  36     -22.876 118.355  27.801  1.00 44.13           N  
ATOM    257  CA  THR A  36     -24.253 117.938  27.555  1.00 43.82           C  
ATOM    258  C   THR A  36     -24.262 116.534  26.932  1.00 44.65           C  
ATOM    259  O   THR A  36     -24.977 115.648  27.419  1.00 45.79           O  
ATOM    260  CB  THR A  36     -25.071 118.997  26.749  1.00 43.88           C  
ATOM    261  OG1 THR A  36     -25.287 120.138  27.585  1.00 41.39           O  
ATOM    262  CG2 THR A  36     -26.442 118.423  26.335  1.00 43.59           C  
ATOM    263  N   LEU A  37     -23.438 116.344  25.899  1.00 44.41           N  
ATOM    264  CA  LEU A  37     -23.162 115.054  25.291  1.00 44.93           C  
ATOM    265  C   LEU A  37     -22.710 113.962  26.297  1.00 45.24           C  
ATOM    266  O   LEU A  37     -23.185 112.838  26.230  1.00 46.46           O  
ATOM    267  CB  LEU A  37     -22.109 115.218  24.183  1.00 45.04           C  
ATOM    268  CG  LEU A  37     -21.974 114.028  23.245  1.00 44.99           C  
ATOM    269  CD1 LEU A  37     -21.889 114.493  21.848  1.00 41.95           C  
ATOM    270  CD2 LEU A  37     -20.772 113.180  23.624  1.00 47.74           C  
ATOM    271  N   ASN A  38     -21.833 114.312  27.227  1.00 44.58           N  
ATOM    272  CA  ASN A  38     -21.345 113.384  28.206  1.00 44.60           C  
ATOM    273  C   ASN A  38     -22.479 112.856  29.114  1.00 45.20           C  
ATOM    274  O   ASN A  38     -22.626 111.644  29.250  1.00 45.80           O  
ATOM    275  CB  ASN A  38     -20.166 113.977  29.010  1.00 42.98           C  
ATOM    276  CG  ASN A  38     -18.944 114.286  28.136  1.00 41.68           C  
ATOM    277  OD1 ASN A  38     -18.717 113.656  27.098  1.00 41.98           O  
ATOM    278  ND2 ASN A  38     -18.132 115.228  28.580  1.00 35.48           N  
ATOM    279  N   ARG A  39     -23.274 113.760  29.697  1.00 46.03           N  
ATOM    280  CA  ARG A  39     -24.447 113.409  30.491  1.00 46.85           C  
ATOM    281  C   ARG A  39     -25.397 112.532  29.688  1.00 47.38           C  
ATOM    282  O   ARG A  39     -25.845 111.502  30.209  1.00 48.83           O  
ATOM    283  CB  ARG A  39     -25.191 114.669  30.962  1.00 46.78           C  
ATOM    284  CG  ARG A  39     -24.370 115.504  31.932  1.00 48.11           C  
ATOM    285  CD  ARG A  39     -25.174 116.608  32.627  1.00 47.94           C  
ATOM    286  NE  ARG A  39     -25.083 117.858  31.864  1.00 50.79           N  
ATOM    287  CZ  ARG A  39     -24.067 118.729  31.946  1.00 52.07           C  
ATOM    288  NH1 ARG A  39     -23.024 118.511  32.773  1.00 50.49           N  
ATOM    289  NH2 ARG A  39     -24.102 119.835  31.202  1.00 51.46           N  
ATOM    290  N   GLU A  40     -25.693 112.902  28.432  1.00 46.15           N  
ATOM    291  CA  GLU A  40     -26.712 112.137  27.649  1.00 45.38           C  
ATOM    292  C   GLU A  40     -26.253 110.729  27.292  1.00 44.75           C  
ATOM    293  O   GLU A  40     -27.062 109.763  27.333  1.00 44.30           O  
ATOM    294  CB  GLU A  40     -27.162 112.869  26.398  1.00 44.56           C  
ATOM    295  CG  GLU A  40     -27.848 114.163  26.692  1.00 46.81           C  
ATOM    296  CD  GLU A  40     -28.535 114.736  25.477  1.00 49.42           C  
ATOM    297  OE1 GLU A  40     -27.922 114.712  24.401  1.00 51.43           O  
ATOM    298  OE2 GLU A  40     -29.687 115.218  25.594  1.00 50.16           O  
ATOM    299  N   MET A  41     -24.951 110.625  26.985  1.00 44.45           N  
ATOM    300  CA  MET A  41     -24.283 109.329  26.712  1.00 43.09           C  
ATOM    301  C   MET A  41     -24.328 108.373  27.877  1.00 41.58           C  
ATOM    302  O   MET A  41     -24.539 107.202  27.688  1.00 41.10           O  
ATOM    303  CB  MET A  41     -22.855 109.522  26.237  1.00 43.61           C  
ATOM    304  CG  MET A  41     -22.743 109.902  24.736  1.00 43.49           C  
ATOM    305  SD  MET A  41     -23.490 108.701  23.593  1.00 42.52           S  
ATOM    306  CE  MET A  41     -22.506 107.234  24.024  1.00 43.93           C  
ATOM    307  N   ILE A  42     -24.154 108.884  29.086  1.00 41.69           N  
ATOM    308  CA  ILE A  42     -24.371 108.078  30.292  1.00 41.29           C  
ATOM    309  C   ILE A  42     -25.778 107.478  30.268  1.00 41.62           C  
ATOM    310  O   ILE A  42     -25.973 106.251  30.376  1.00 41.48           O  
ATOM    311  CB  ILE A  42     -24.230 108.923  31.612  1.00 41.94           C  
ATOM    312  CG1 ILE A  42     -22.820 109.545  31.742  1.00 39.81           C  
ATOM    313  CG2 ILE A  42     -24.756 108.087  32.837  1.00 39.49           C  
ATOM    314  CD1 ILE A  42     -22.601 110.465  32.931  1.00 39.86           C  
ATOM    315  N   ASP A  43     -26.745 108.373  30.090  1.00 42.19           N  
ATOM    316  CA  ASP A  43     -28.173 108.040  30.044  1.00 43.62           C  
ATOM    317  C   ASP A  43     -28.490 107.042  28.924  1.00 43.17           C  
ATOM    318  O   ASP A  43     -29.218 106.076  29.148  1.00 43.14           O  
ATOM    319  CB  ASP A  43     -28.979 109.328  29.815  1.00 44.36           C  
ATOM    320  CG  ASP A  43     -30.471 109.103  29.876  1.00 46.61           C  
ATOM    321  OD1 ASP A  43     -30.918 108.143  30.551  1.00 46.79           O  
ATOM    322  OD2 ASP A  43     -31.190 109.920  29.255  1.00 51.94           O  
ATOM    323  N   VAL A  44     -27.950 107.302  27.733  1.00 42.17           N  
ATOM    324  CA  VAL A  44     -28.038 106.382  26.601  1.00 41.72           C  
ATOM    325  C   VAL A  44     -27.549 104.964  26.930  1.00 42.89           C  
ATOM    326  O   VAL A  44     -28.299 104.005  26.707  1.00 42.04           O  
ATOM    327  CB  VAL A  44     -27.229 106.916  25.411  1.00 41.08           C  
ATOM    328  CG1 VAL A  44     -27.022 105.830  24.354  1.00 39.99           C  
ATOM    329  CG2 VAL A  44     -27.891 108.156  24.849  1.00 40.81           C  
ATOM    330  N   LEU A  45     -26.303 104.860  27.444  1.00 43.42           N  
ATOM    331  CA  LEU A  45     -25.634 103.572  27.724  1.00 44.31           C  
ATOM    332  C   LEU A  45     -26.317 102.779  28.824  1.00 45.72           C  
ATOM    333  O   LEU A  45     -26.352 101.552  28.783  1.00 46.31           O  
ATOM    334  CB  LEU A  45     -24.164 103.764  28.114  1.00 42.74           C  
ATOM    335  CG  LEU A  45     -23.246 104.309  27.046  1.00 40.74           C  
ATOM    336  CD1 LEU A  45     -21.808 104.211  27.534  1.00 37.73           C  
ATOM    337  CD2 LEU A  45     -23.430 103.580  25.709  1.00 40.13           C  
ATOM    338  N   GLU A  46     -26.855 103.484  29.809  1.00 47.28           N  
ATOM    339  CA  GLU A  46     -27.638 102.863  30.853  1.00 48.69           C  
ATOM    340  C   GLU A  46     -28.975 102.293  30.313  1.00 49.64           C  
ATOM    341  O   GLU A  46     -29.312 101.119  30.565  1.00 51.05           O  
ATOM    342  CB  GLU A  46     -27.889 103.886  31.949  1.00 49.22           C  
ATOM    343  CG  GLU A  46     -26.701 104.068  32.863  1.00 50.45           C  
ATOM    344  CD  GLU A  46     -26.854 105.215  33.858  1.00 52.73           C  
ATOM    345  OE1 GLU A  46     -27.742 106.076  33.714  1.00 55.94           O  
ATOM    346  OE2 GLU A  46     -26.062 105.264  34.805  1.00 55.89           O  
ATOM    347  N   THR A  47     -29.721 103.124  29.580  1.00 49.41           N  
ATOM    348  CA  THR A  47     -30.982 102.745  28.918  1.00 49.20           C  
ATOM    349  C   THR A  47     -30.843 101.588  27.953  1.00 48.68           C  
ATOM    350  O   THR A  47     -31.671 100.677  27.951  1.00 49.48           O  
ATOM    351  CB  THR A  47     -31.557 103.932  28.158  1.00 48.91           C  
ATOM    352  OG1 THR A  47     -31.727 104.985  29.098  1.00 50.86           O  
ATOM    353  CG2 THR A  47     -32.928 103.619  27.547  1.00 48.34           C  
ATOM    354  N   LEU A  48     -29.813 101.624  27.126  1.00 47.50           N  
ATOM    355  CA  LEU A  48     -29.587 100.534  26.188  1.00 46.60           C  
ATOM    356  C   LEU A  48     -29.193  99.192  26.874  1.00 46.71           C  
ATOM    357  O   LEU A  48     -29.435  98.097  26.317  1.00 45.96           O  
ATOM    358  CB  LEU A  48     -28.590 100.961  25.103  1.00 45.78           C  
ATOM    359  CG  LEU A  48     -29.101 101.940  24.039  1.00 45.24           C  
ATOM    360  CD1 LEU A  48     -27.993 102.418  23.047  1.00 42.31           C  
ATOM    361  CD2 LEU A  48     -30.277 101.292  23.251  1.00 43.23           C  
ATOM    362  N   GLU A  49     -28.635  99.288  28.089  1.00 46.29           N  
ATOM    363  CA  GLU A  49     -28.201  98.126  28.842  1.00 46.37           C  
ATOM    364  C   GLU A  49     -29.406  97.268  29.290  1.00 46.53           C  
ATOM    365  O   GLU A  49     -29.286  96.057  29.496  1.00 46.13           O  
ATOM    366  CB  GLU A  49     -27.372  98.551  30.074  1.00 46.44           C  
ATOM    367  CG  GLU A  49     -26.588  97.401  30.663  1.00 47.83           C  
ATOM    368  CD  GLU A  49     -26.266  97.536  32.144  1.00 51.45           C  
ATOM    369  OE1 GLU A  49     -27.125  97.921  32.980  1.00 54.82           O  
ATOM    370  OE2 GLU A  49     -25.125  97.230  32.491  1.00 52.43           O  
ATOM    371  N   GLN A  50     -30.556  97.905  29.459  1.00 47.12           N  
ATOM    372  CA  GLN A  50     -31.721  97.247  30.069  1.00 48.39           C  
ATOM    373  C   GLN A  50     -32.774  96.929  29.031  1.00 48.78           C  
ATOM    374  O   GLN A  50     -33.793  96.324  29.339  1.00 50.12           O  
ATOM    375  CB  GLN A  50     -32.293  98.146  31.170  1.00 48.27           C  
ATOM    376  CG  GLN A  50     -31.298  98.379  32.327  1.00 49.21           C  
ATOM    377  CD  GLN A  50     -31.024  97.087  33.117  1.00 50.87           C  
ATOM    378  OE1 GLN A  50     -29.868  96.726  33.391  1.00 52.86           O  
ATOM    379  NE2 GLN A  50     -32.093  96.392  33.482  1.00 48.32           N  
ATOM    380  N   ASP A  51     -32.523  97.361  27.804  1.00 49.25           N  
ATOM    381  CA  ASP A  51     -33.418  97.161  26.681  1.00 50.13           C  
ATOM    382  C   ASP A  51     -33.127  95.793  26.067  1.00 50.82           C  
ATOM    383  O   ASP A  51     -32.004  95.598  25.566  1.00 51.03           O  
ATOM    384  CB  ASP A  51     -33.183  98.260  25.647  1.00 49.69           C  
ATOM    385  CG  ASP A  51     -34.195  98.243  24.513  1.00 50.88           C  
ATOM    386  OD1 ASP A  51     -35.058  97.342  24.483  1.00 53.69           O  
ATOM    387  OD2 ASP A  51     -34.124  99.128  23.626  1.00 52.55           O  
ATOM    388  N   PRO A  52     -34.115  94.840  26.101  1.00 50.90           N  
ATOM    389  CA  PRO A  52     -33.945  93.558  25.395  1.00 50.83           C  
ATOM    390  C   PRO A  52     -33.711  93.764  23.904  1.00 50.77           C  
ATOM    391  O   PRO A  52     -33.020  92.955  23.276  1.00 51.35           O  
ATOM    392  CB  PRO A  52     -35.277  92.829  25.643  1.00 50.15           C  
ATOM    393  CG  PRO A  52     -35.810  93.415  26.863  1.00 49.28           C  
ATOM    394  CD  PRO A  52     -35.428  94.872  26.784  1.00 51.56           C  
ATOM    395  N   ALA A  53     -34.232  94.861  23.356  1.00 50.80           N  
ATOM    396  CA  ALA A  53     -34.148  95.122  21.903  1.00 51.00           C  
ATOM    397  C   ALA A  53     -32.706  95.239  21.339  1.00 50.55           C  
ATOM    398  O   ALA A  53     -32.409  94.657  20.303  1.00 51.31           O  
ATOM    399  CB  ALA A  53     -35.036  96.345  21.499  1.00 50.84           C  
ATOM    400  N   ALA A  54     -31.833  95.968  22.037  1.00 50.12           N  
ATOM    401  CA  ALA A  54     -30.397  96.128  21.703  1.00 48.68           C  
ATOM    402  C   ALA A  54     -29.547  94.950  22.135  1.00 47.77           C  
ATOM    403  O   ALA A  54     -29.465  94.643  23.309  1.00 47.65           O  
ATOM    404  CB  ALA A  54     -29.863  97.374  22.388  1.00 48.70           C  
ATOM    405  N   GLY A  55     -28.881  94.311  21.196  1.00 47.16           N  
ATOM    406  CA  GLY A  55     -28.048  93.160  21.521  1.00 46.77           C  
ATOM    407  C   GLY A  55     -26.562  93.449  21.347  1.00 46.62           C  
ATOM    408  O   GLY A  55     -25.716  92.787  21.959  1.00 47.06           O  
ATOM    409  N   VAL A  56     -26.262  94.449  20.517  1.00 46.03           N  
ATOM    410  CA  VAL A  56     -24.894  94.887  20.196  1.00 45.76           C  
ATOM    411  C   VAL A  56     -25.021  96.369  19.862  1.00 45.46           C  
ATOM    412  O   VAL A  56     -25.993  96.766  19.209  1.00 43.84           O  
ATOM    413  CB  VAL A  56     -24.209  94.060  19.023  1.00 44.73           C  
ATOM    414  CG1 VAL A  56     -25.142  93.895  17.877  1.00 46.11           C  
ATOM    415  CG2 VAL A  56     -22.874  94.679  18.587  1.00 45.20           C  
ATOM    416  N   LEU A  57     -24.080  97.174  20.377  1.00 44.31           N  
ATOM    417  CA  LEU A  57     -24.109  98.606  20.139  1.00 43.87           C  
ATOM    418  C   LEU A  57     -23.011  99.031  19.180  1.00 43.59           C  
ATOM    419  O   LEU A  57     -21.944  98.493  19.197  1.00 43.35           O  
ATOM    420  CB  LEU A  57     -24.021  99.391  21.445  1.00 44.25           C  
ATOM    421  CG  LEU A  57     -25.274  99.679  22.280  1.00 42.25           C  
ATOM    422  CD1 LEU A  57     -25.974  98.406  22.765  1.00 40.32           C  
ATOM    423  CD2 LEU A  57     -24.806 100.558  23.436  1.00 41.19           C  
ATOM    424  N   VAL A  58     -23.311  99.973  18.317  1.00 43.86           N  
ATOM    425  CA  VAL A  58     -22.384 100.371  17.290  1.00 45.13           C  
ATOM    426  C   VAL A  58     -22.273 101.879  17.450  1.00 45.42           C  
ATOM    427  O   VAL A  58     -23.297 102.582  17.434  1.00 45.64           O  
ATOM    428  CB  VAL A  58     -22.849  99.970  15.805  1.00 44.83           C  
ATOM    429  CG1 VAL A  58     -21.981 100.669  14.752  1.00 44.03           C  
ATOM    430  CG2 VAL A  58     -22.745  98.478  15.584  1.00 44.20           C  
ATOM    431  N   LEU A  59     -21.046 102.362  17.623  1.00 44.97           N  
ATOM    432  CA  LEU A  59     -20.874 103.740  18.061  1.00 44.89           C  
ATOM    433  C   LEU A  59     -20.268 104.505  16.960  1.00 44.17           C  
ATOM    434  O   LEU A  59     -19.120 104.252  16.552  1.00 43.72           O  
ATOM    435  CB  LEU A  59     -20.017 103.873  19.331  1.00 45.30           C  
ATOM    436  CG  LEU A  59     -19.686 105.329  19.740  1.00 45.53           C  
ATOM    437  CD1 LEU A  59     -20.942 106.122  20.146  1.00 43.24           C  
ATOM    438  CD2 LEU A  59     -18.656 105.332  20.881  1.00 44.83           C  
ATOM    439  N   THR A  60     -21.069 105.440  16.483  1.00 43.26           N  
ATOM    440  CA  THR A  60     -20.786 106.109  15.249  1.00 43.70           C  
ATOM    441  C   THR A  60     -21.157 107.595  15.325  1.00 43.90           C  
ATOM    442  O   THR A  60     -21.718 108.049  16.322  1.00 42.44           O  
ATOM    443  CB  THR A  60     -21.370 105.305  14.024  1.00 43.88           C  
ATOM    444  OG1 THR A  60     -20.598 105.583  12.864  1.00 42.31           O  
ATOM    445  CG2 THR A  60     -22.873 105.549  13.753  1.00 44.50           C  
ATOM    446  N   GLY A  61     -20.802 108.349  14.288  1.00 44.61           N  
ATOM    447  CA  GLY A  61     -21.019 109.802  14.294  1.00 45.56           C  
ATOM    448  C   GLY A  61     -21.854 110.323  13.123  1.00 45.93           C  
ATOM    449  O   GLY A  61     -21.711 109.859  11.972  1.00 45.19           O  
ATOM    450  N   ALA A  62     -22.737 111.279  13.426  1.00 46.26           N  
ATOM    451  CA  ALA A  62     -23.517 111.925  12.406  1.00 46.71           C  
ATOM    452  C   ALA A  62     -22.582 112.806  11.558  1.00 47.33           C  
ATOM    453  O   ALA A  62     -21.685 113.476  12.115  1.00 47.33           O  
ATOM    454  CB  ALA A  62     -24.660 112.750  13.038  1.00 46.67           C  
ATOM    455  N   GLY A  63     -22.763 112.780  10.227  1.00 46.72           N  
ATOM    456  CA  GLY A  63     -22.027 113.681   9.346  1.00 47.27           C  
ATOM    457  C   GLY A  63     -20.642 113.145   9.051  1.00 48.11           C  
ATOM    458  O   GLY A  63     -20.445 111.930   9.012  1.00 48.57           O  
ATOM    459  N   GLU A  64     -19.672 114.047   8.870  1.00 48.33           N  
ATOM    460  CA  GLU A  64     -18.316 113.677   8.431  1.00 49.05           C  
ATOM    461  C   GLU A  64     -17.410 113.143   9.545  1.00 48.22           C  
ATOM    462  O   GLU A  64     -16.425 112.463   9.265  1.00 48.68           O  
ATOM    463  CB  GLU A  64     -17.596 114.887   7.838  1.00 48.56           C  
ATOM    464  CG  GLU A  64     -18.227 115.648   6.663  1.00 51.47           C  
ATOM    465  CD  GLU A  64     -17.235 116.727   6.170  1.00 52.33           C  
ATOM    466  OE1 GLU A  64     -16.210 117.041   6.884  1.00 58.09           O  
ATOM    467  OE2 GLU A  64     -17.459 117.249   5.074  1.00 55.64           O  
ATOM    468  N   ALA A  65     -17.695 113.520  10.789  1.00 47.05           N  
ATOM    469  CA  ALA A  65     -16.858 113.154  11.917  1.00 46.33           C  
ATOM    470  C   ALA A  65     -17.377 111.910  12.652  1.00 46.36           C  
ATOM    471  O   ALA A  65     -18.592 111.647  12.739  1.00 45.38           O  
ATOM    472  CB  ALA A  65     -16.757 114.306  12.872  1.00 45.84           C  
ATOM    473  N   TRP A  66     -16.433 111.122  13.157  1.00 46.20           N  
ATOM    474  CA  TRP A  66     -16.768 110.195  14.177  1.00 46.13           C  
ATOM    475  C   TRP A  66     -16.946 111.096  15.429  1.00 45.75           C  
ATOM    476  O   TRP A  66     -18.071 111.350  15.834  1.00 44.66           O  
ATOM    477  CB  TRP A  66     -15.717 109.081  14.280  1.00 45.68           C  
ATOM    478  CG  TRP A  66     -16.133 108.017  15.255  1.00 46.56           C  
ATOM    479  CD1 TRP A  66     -17.184 107.114  15.126  1.00 45.29           C  
ATOM    480  CD2 TRP A  66     -15.529 107.752  16.538  1.00 48.33           C  
ATOM    481  NE1 TRP A  66     -17.245 106.301  16.247  1.00 48.63           N  
ATOM    482  CE2 TRP A  66     -16.250 106.671  17.130  1.00 48.59           C  
ATOM    483  CE3 TRP A  66     -14.468 108.342  17.262  1.00 46.18           C  
ATOM    484  CZ2 TRP A  66     -15.927 106.164  18.409  1.00 47.09           C  
ATOM    485  CZ3 TRP A  66     -14.161 107.838  18.516  1.00 46.37           C  
ATOM    486  CH2 TRP A  66     -14.891 106.755  19.079  1.00 44.34           C  
ATOM    487  N   THR A  67     -15.841 111.613  15.979  1.00 46.45           N  
ATOM    488  CA  THR A  67     -15.828 112.781  16.913  1.00 47.35           C  
ATOM    489  C   THR A  67     -14.492 113.556  16.775  1.00 48.10           C  
ATOM    490  O   THR A  67     -13.424 112.962  16.582  1.00 47.96           O  
ATOM    491  CB  THR A  67     -16.152 112.413  18.437  1.00 47.03           C  
ATOM    492  OG1 THR A  67     -15.967 113.551  19.287  1.00 47.18           O  
ATOM    493  CG2 THR A  67     -15.251 111.336  18.978  1.00 47.09           C  
ATOM    494  N   ALA A  68     -14.568 114.881  16.837  1.00 49.10           N  
ATOM    495  CA  ALA A  68     -13.382 115.743  16.722  1.00 49.58           C  
ATOM    496  C   ALA A  68     -12.729 115.989  18.129  1.00 50.17           C  
ATOM    497  O   ALA A  68     -11.850 116.901  18.305  1.00 50.55           O  
ATOM    498  CB  ALA A  68     -13.731 117.059  15.992  1.00 48.80           C  
ATOM    499  N   GLY A  69     -13.154 115.154  19.091  1.00 49.37           N  
ATOM    500  CA  GLY A  69     -12.682 115.166  20.465  1.00 49.44           C  
ATOM    501  C   GLY A  69     -13.520 116.039  21.377  1.00 50.12           C  
ATOM    502  O   GLY A  69     -14.659 116.320  21.049  1.00 49.05           O  
ATOM    503  N   MET A  70     -12.947 116.478  22.518  1.00 50.94           N  
ATOM    504  CA  MET A  70     -13.690 117.337  23.456  1.00 51.93           C  
ATOM    505  C   MET A  70     -14.023 118.729  22.901  1.00 51.24           C  
ATOM    506  O   MET A  70     -13.227 119.352  22.215  1.00 50.01           O  
ATOM    507  CB  MET A  70     -13.028 117.457  24.854  1.00 52.63           C  
ATOM    508  CG  MET A  70     -12.728 116.143  25.589  1.00 56.54           C  
ATOM    509  SD  MET A  70     -13.990 114.817  25.871  1.00 62.40           S  
ATOM    510  CE  MET A  70     -15.087 115.499  27.152  1.00 62.45           C  
ATOM    511  N   ASP A  71     -15.231 119.187  23.217  1.00 52.19           N  
ATOM    512  CA  ASP A  71     -15.692 120.533  22.905  1.00 54.09           C  
ATOM    513  C   ASP A  71     -14.942 121.589  23.756  1.00 55.84           C  
ATOM    514  O   ASP A  71     -15.203 121.727  24.975  1.00 55.01           O  
ATOM    515  CB  ASP A  71     -17.193 120.598  23.180  1.00 54.09           C  
ATOM    516  CG  ASP A  71     -17.864 121.770  22.518  1.00 54.40           C  
ATOM    517  OD1 ASP A  71     -17.406 122.912  22.684  1.00 54.80           O  
ATOM    518  OD2 ASP A  71     -18.886 121.539  21.844  1.00 56.52           O  
ATOM    519  N   LEU A  72     -14.012 122.307  23.103  1.00 57.60           N  
ATOM    520  CA  LEU A  72     -13.293 123.463  23.682  1.00 58.96           C  
ATOM    521  C   LEU A  72     -14.200 124.698  23.674  1.00 59.51           C  
ATOM    522  O   LEU A  72     -14.627 125.162  24.730  1.00 60.30           O  
ATOM    523  N   ALA A  81     -14.337 128.112  33.974  1.00 66.85           N  
ATOM    524  CA  ALA A  81     -15.745 127.719  34.139  1.00 66.18           C  
ATOM    525  C   ALA A  81     -16.405 128.494  35.306  1.00 66.25           C  
ATOM    526  O   ALA A  81     -16.543 129.745  35.243  1.00 65.88           O  
ATOM    527  CB  ALA A  81     -15.872 126.168  34.319  1.00 66.15           C  
ATOM    528  N   GLY A  82     -16.793 127.733  36.349  1.00 65.67           N  
ATOM    529  CA  GLY A  82     -17.538 128.200  37.579  1.00 64.10           C  
ATOM    530  C   GLY A  82     -16.669 127.900  38.803  1.00 61.26           C  
ATOM    531  O   GLY A  82     -15.447 128.143  38.729  1.00 61.96           O  
ATOM    532  N   PRO A  83     -17.251 127.325  39.907  1.00 58.98           N  
ATOM    533  CA  PRO A  83     -16.409 126.929  41.085  1.00 56.04           C  
ATOM    534  C   PRO A  83     -15.471 125.778  40.718  1.00 53.16           C  
ATOM    535  O   PRO A  83     -15.778 124.992  39.789  1.00 52.21           O  
ATOM    536  CB  PRO A  83     -17.421 126.478  42.145  1.00 56.41           C  
ATOM    537  CG  PRO A  83     -18.669 126.110  41.386  1.00 58.41           C  
ATOM    538  CD  PRO A  83     -18.676 126.972  40.101  1.00 59.45           C  
ATOM    539  N   GLU A  84     -14.335 125.692  41.410  1.00 49.97           N  
ATOM    540  CA  GLU A  84     -13.309 124.649  41.111  1.00 47.40           C  
ATOM    541  C   GLU A  84     -13.919 123.219  41.024  1.00 44.78           C  
ATOM    542  O   GLU A  84     -13.598 122.466  40.075  1.00 43.59           O  
ATOM    543  CB  GLU A  84     -12.165 124.689  42.142  1.00 47.41           C  
ATOM    544  CG  GLU A  84     -10.978 123.691  41.879  1.00 50.15           C  
ATOM    545  CD  GLU A  84     -11.289 122.188  42.169  1.00 52.26           C  
ATOM    546  OE1 GLU A  84     -12.207 121.875  42.972  1.00 50.52           O  
ATOM    547  OE2 GLU A  84     -10.579 121.318  41.592  1.00 52.31           O  
ATOM    548  N   ILE A  85     -14.781 122.885  42.010  1.00 41.64           N  
ATOM    549  CA  ILE A  85     -15.489 121.600  42.118  1.00 40.34           C  
ATOM    550  C   ILE A  85     -16.240 121.173  40.876  1.00 39.82           C  
ATOM    551  O   ILE A  85     -16.330 119.979  40.569  1.00 40.02           O  
ATOM    552  CB  ILE A  85     -16.423 121.483  43.429  1.00 40.74           C  
ATOM    553  CG1 ILE A  85     -16.627 120.013  43.804  1.00 40.49           C  
ATOM    554  CG2 ILE A  85     -17.788 122.261  43.336  1.00 38.12           C  
ATOM    555  CD1 ILE A  85     -15.448 119.441  44.560  1.00 36.58           C  
ATOM    556  N   LEU A  86     -16.747 122.128  40.120  1.00 40.01           N  
ATOM    557  CA  LEU A  86     -17.487 121.748  38.911  1.00 41.84           C  
ATOM    558  C   LEU A  86     -16.708 120.828  37.956  1.00 42.50           C  
ATOM    559  O   LEU A  86     -17.314 119.934  37.346  1.00 43.76           O  
ATOM    560  CB  LEU A  86     -18.034 122.984  38.192  1.00 41.40           C  
ATOM    561  CG  LEU A  86     -18.977 122.762  37.012  1.00 44.06           C  
ATOM    562  CD1 LEU A  86     -20.173 121.791  37.326  1.00 46.24           C  
ATOM    563  CD2 LEU A  86     -19.448 124.132  36.543  1.00 46.38           C  
ATOM    564  N   GLN A  87     -15.394 121.081  37.815  1.00 43.22           N  
ATOM    565  CA  GLN A  87     -14.424 120.289  36.987  1.00 45.08           C  
ATOM    566  C   GLN A  87     -14.362 118.805  37.327  1.00 44.20           C  
ATOM    567  O   GLN A  87     -14.316 117.968  36.427  1.00 43.30           O  
ATOM    568  CB  GLN A  87     -13.000 120.849  37.170  1.00 44.52           C  
ATOM    569  CG  GLN A  87     -12.040 120.470  36.067  1.00 47.58           C  
ATOM    570  CD  GLN A  87     -10.607 121.037  36.285  1.00 48.70           C  
ATOM    571  OE1 GLN A  87      -9.951 120.800  37.336  1.00 50.70           O  
ATOM    572  NE2 GLN A  87     -10.131 121.787  35.298  1.00 48.00           N  
ATOM    573  N   GLU A  88     -14.309 118.498  38.632  1.00 44.49           N  
ATOM    574  CA  GLU A  88     -14.398 117.134  39.127  1.00 43.75           C  
ATOM    575  C   GLU A  88     -15.573 116.442  38.484  1.00 42.87           C  
ATOM    576  O   GLU A  88     -15.408 115.358  37.977  1.00 42.51           O  
ATOM    577  CB  GLU A  88     -14.616 117.087  40.650  1.00 44.82           C  
ATOM    578  CG  GLU A  88     -13.542 117.720  41.529  1.00 48.55           C  
ATOM    579  CD  GLU A  88     -12.279 116.932  41.472  1.00 57.69           C  
ATOM    580  OE1 GLU A  88     -12.142 115.999  42.318  1.00 60.47           O  
ATOM    581  OE2 GLU A  88     -11.467 117.189  40.530  1.00 62.23           O  
ATOM    582  N   LYS A  89     -16.760 117.075  38.505  1.00 42.56           N  
ATOM    583  CA  LYS A  89     -18.004 116.500  37.958  1.00 41.59           C  
ATOM    584  C   LYS A  89     -17.941 116.283  36.452  1.00 41.38           C  
ATOM    585  O   LYS A  89     -18.271 115.221  35.963  1.00 41.15           O  
ATOM    586  CB  LYS A  89     -19.188 117.430  38.271  1.00 41.81           C  
ATOM    587  CG  LYS A  89     -20.499 116.937  37.726  1.00 40.23           C  
ATOM    588  CD  LYS A  89     -21.733 117.691  38.335  1.00 43.68           C  
ATOM    589  N   ILE A  90     -17.506 117.319  35.730  1.00 40.50           N  
ATOM    590  CA  ILE A  90     -17.359 117.287  34.309  1.00 40.03           C  
ATOM    591  C   ILE A  90     -16.284 116.270  33.879  1.00 40.45           C  
ATOM    592  O   ILE A  90     -16.509 115.527  32.963  1.00 41.52           O  
ATOM    593  CB  ILE A  90     -17.166 118.756  33.735  1.00 40.31           C  
ATOM    594  CG1 ILE A  90     -18.498 119.543  33.841  1.00 39.59           C  
ATOM    595  CG2 ILE A  90     -16.646 118.763  32.282  1.00 38.70           C  
ATOM    596  CD1 ILE A  90     -18.350 120.979  33.438  1.00 40.60           C  
ATOM    597  N   ARG A  91     -15.138 116.213  34.542  1.00 39.54           N  
ATOM    598  CA  ARG A  91     -14.181 115.136  34.299  1.00 38.36           C  
ATOM    599  C   ARG A  91     -14.823 113.756  34.618  1.00 39.39           C  
ATOM    600  O   ARG A  91     -14.706 112.841  33.828  1.00 39.92           O  
ATOM    601  CB  ARG A  91     -12.884 115.377  35.093  1.00 36.87           C  
ATOM    602  CG  ARG A  91     -12.080 116.574  34.528  1.00 34.97           C  
ATOM    603  CD  ARG A  91     -10.786 116.814  35.289  1.00 35.70           C  
ATOM    604  NE  ARG A  91      -9.895 117.766  34.602  1.00 34.61           N  
ATOM    605  CZ  ARG A  91      -8.744 118.178  35.103  1.00 34.27           C  
ATOM    606  NH1 ARG A  91      -8.383 117.718  36.287  1.00 32.41           N  
ATOM    607  NH2 ARG A  91      -7.946 119.006  34.429  1.00 32.89           N  
ATOM    608  N   ARG A  92     -15.578 113.630  35.712  1.00 40.33           N  
ATOM    609  CA  ARG A  92     -16.205 112.351  36.051  1.00 40.41           C  
ATOM    610  C   ARG A  92     -17.203 111.873  35.007  1.00 40.30           C  
ATOM    611  O   ARG A  92     -17.211 110.703  34.657  1.00 40.90           O  
ATOM    612  CB  ARG A  92     -16.885 112.408  37.394  1.00 41.63           C  
ATOM    613  CG  ARG A  92     -17.404 110.981  37.846  1.00 45.11           C  
ATOM    614  CD  ARG A  92     -18.392 111.070  39.000  1.00 46.22           C  
ATOM    615  NE  ARG A  92     -18.134 112.245  39.827  1.00 46.28           N  
ATOM    616  CZ  ARG A  92     -19.070 113.131  40.104  1.00 49.67           C  
ATOM    617  NH1 ARG A  92     -20.303 112.951  39.615  1.00 49.19           N  
ATOM    618  NH2 ARG A  92     -18.793 114.163  40.879  1.00 48.93           N  
ATOM    619  N   GLU A  93     -17.983 112.788  34.456  1.00 40.25           N  
ATOM    620  CA  GLU A  93     -19.036 112.444  33.504  1.00 40.28           C  
ATOM    621  C   GLU A  93     -18.492 112.150  32.122  1.00 39.66           C  
ATOM    622  O   GLU A  93     -19.052 111.282  31.424  1.00 39.55           O  
ATOM    623  CB  GLU A  93     -20.117 113.533  33.395  1.00 40.34           C  
ATOM    624  CG  GLU A  93     -20.590 114.094  34.689  1.00 41.57           C  
ATOM    625  CD  GLU A  93     -21.605 115.229  34.483  1.00 43.40           C  
ATOM    626  OE1 GLU A  93     -21.432 116.095  33.554  1.00 43.83           O  
ATOM    627  OE2 GLU A  93     -22.587 115.229  35.291  1.00 49.70           O  
ATOM    628  N   ALA A  94     -17.453 112.885  31.692  1.00 37.92           N  
ATOM    629  CA  ALA A  94     -16.662 112.439  30.545  1.00 37.21           C  
ATOM    630  C   ALA A  94     -16.287 110.952  30.764  1.00 37.92           C  
ATOM    631  O   ALA A  94     -16.650 110.132  29.981  1.00 39.05           O  
ATOM    632  CB  ALA A  94     -15.406 113.322  30.352  1.00 36.79           C  
ATOM    633  N   SER A  95     -15.569 110.589  31.823  1.00 38.92           N  
ATOM    634  CA  SER A  95     -15.059 109.218  31.924  1.00 40.09           C  
ATOM    635  C   SER A  95     -16.185 108.221  32.081  1.00 40.34           C  
ATOM    636  O   SER A  95     -16.038 107.076  31.709  1.00 39.96           O  
ATOM    637  CB  SER A  95     -14.173 109.025  33.145  1.00 40.12           C  
ATOM    638  OG  SER A  95     -13.379 110.140  33.465  1.00 44.27           O  
ATOM    639  N   GLN A  96     -17.306 108.655  32.666  1.00 41.22           N  
ATOM    640  CA  GLN A  96     -18.379 107.749  33.001  1.00 41.74           C  
ATOM    641  C   GLN A  96     -18.893 106.974  31.768  1.00 42.04           C  
ATOM    642  O   GLN A  96     -19.088 105.761  31.849  1.00 41.80           O  
ATOM    643  CB  GLN A  96     -19.483 108.481  33.766  1.00 41.77           C  
ATOM    644  CG  GLN A  96     -20.561 107.533  34.345  1.00 44.64           C  
ATOM    645  CD  GLN A  96     -20.015 106.528  35.380  1.00 49.61           C  
ATOM    646  OE1 GLN A  96     -18.832 106.579  35.775  1.00 52.48           O  
ATOM    647  NE2 GLN A  96     -20.877 105.628  35.831  1.00 48.27           N  
ATOM    648  N   TRP A  97     -19.061 107.647  30.620  1.00 41.44           N  
ATOM    649  CA  TRP A  97     -19.543 106.938  29.433  1.00 41.53           C  
ATOM    650  C   TRP A  97     -18.402 106.455  28.524  1.00 41.98           C  
ATOM    651  O   TRP A  97     -18.538 105.403  27.825  1.00 42.71           O  
ATOM    652  CB  TRP A  97     -20.567 107.748  28.613  1.00 40.45           C  
ATOM    653  CG  TRP A  97     -19.977 108.886  27.750  1.00 41.12           C  
ATOM    654  CD1 TRP A  97     -19.798 110.223  28.123  1.00 41.28           C  
ATOM    655  CD2 TRP A  97     -19.544 108.800  26.380  1.00 39.21           C  
ATOM    656  NE1 TRP A  97     -19.299 110.947  27.059  1.00 40.16           N  
ATOM    657  CE2 TRP A  97     -19.125 110.105  25.987  1.00 38.98           C  
ATOM    658  CE3 TRP A  97     -19.450 107.746  25.450  1.00 37.85           C  
ATOM    659  CZ2 TRP A  97     -18.643 110.374  24.722  1.00 37.92           C  
ATOM    660  CZ3 TRP A  97     -18.979 108.029  24.192  1.00 39.56           C  
ATOM    661  CH2 TRP A  97     -18.592 109.338  23.834  1.00 39.06           C  
ATOM    662  N   GLN A  98     -17.308 107.229  28.493  1.00 40.82           N  
ATOM    663  CA  GLN A  98     -16.253 106.966  27.543  1.00 40.66           C  
ATOM    664  C   GLN A  98     -15.621 105.609  27.793  1.00 40.11           C  
ATOM    665  O   GLN A  98     -15.235 104.938  26.837  1.00 41.26           O  
ATOM    666  CB  GLN A  98     -15.213 108.089  27.556  1.00 40.20           C  
ATOM    667  CG  GLN A  98     -15.747 109.383  26.898  1.00 41.56           C  
ATOM    668  CD  GLN A  98     -14.732 110.495  26.876  1.00 42.79           C  
ATOM    669  OE1 GLN A  98     -14.995 111.622  26.393  1.00 45.79           O  
ATOM    670  NE2 GLN A  98     -13.551 110.194  27.389  1.00 44.19           N  
ATOM    671  N   TRP A  99     -15.505 105.203  29.063  1.00 39.39           N  
ATOM    672  CA  TRP A  99     -14.847 103.954  29.380  1.00 38.95           C  
ATOM    673  C   TRP A  99     -15.339 103.271  30.676  1.00 40.16           C  
ATOM    674  O   TRP A  99     -15.334 102.037  30.750  1.00 40.87           O  
ATOM    675  CB  TRP A  99     -13.295 104.127  29.377  1.00 38.27           C  
ATOM    676  CG  TRP A  99     -12.781 105.215  30.357  1.00 37.93           C  
ATOM    677  CD1 TRP A  99     -12.642 106.540  30.096  1.00 35.98           C  
ATOM    678  CD2 TRP A  99     -12.429 105.048  31.750  1.00 35.37           C  
ATOM    679  NE1 TRP A  99     -12.198 107.197  31.194  1.00 33.70           N  
ATOM    680  CE2 TRP A  99     -12.037 106.311  32.226  1.00 37.76           C  
ATOM    681  CE3 TRP A  99     -12.350 103.939  32.618  1.00 37.54           C  
ATOM    682  CZ2 TRP A  99     -11.629 106.524  33.558  1.00 35.77           C  
ATOM    683  CZ3 TRP A  99     -11.947 104.135  33.930  1.00 34.73           C  
ATOM    684  CH2 TRP A  99     -11.602 105.431  34.390  1.00 36.38           C  
ATOM    685  N   LYS A 100     -15.730 104.038  31.691  1.00 40.39           N  
ATOM    686  CA  LYS A 100     -16.133 103.459  32.990  1.00 42.29           C  
ATOM    687  C   LYS A 100     -17.380 102.590  32.781  1.00 42.07           C  
ATOM    688  O   LYS A 100     -17.432 101.462  33.210  1.00 42.82           O  
ATOM    689  CB  LYS A 100     -16.439 104.531  34.045  1.00 40.41           C  
ATOM    690  CG  LYS A 100     -15.273 105.309  34.500  1.00 43.93           C  
ATOM    691  CD  LYS A 100     -15.546 106.143  35.813  1.00 43.98           C  
ATOM    692  CE  LYS A 100     -14.217 106.292  36.579  1.00 46.20           C  
ATOM    693  NZ  LYS A 100     -14.155 107.377  37.602  1.00 47.09           N  
ATOM    694  N   LEU A 101     -18.399 103.114  32.116  1.00 42.46           N  
ATOM    695  CA  LEU A 101     -19.478 102.230  31.688  1.00 42.58           C  
ATOM    696  C   LEU A 101     -19.036 101.429  30.474  1.00 42.74           C  
ATOM    697  O   LEU A 101     -19.281 100.225  30.454  1.00 45.28           O  
ATOM    698  CB  LEU A 101     -20.780 102.982  31.396  1.00 41.99           C  
ATOM    699  CG  LEU A 101     -21.603 103.582  32.531  1.00 41.76           C  
ATOM    700  CD1 LEU A 101     -22.660 104.568  32.013  1.00 38.09           C  
ATOM    701  CD2 LEU A 101     -22.261 102.434  33.281  1.00 41.67           C  
ATOM    702  N   LEU A 102     -18.392 102.060  29.481  1.00 41.20           N  
ATOM    703  CA  LEU A 102     -18.187 101.416  28.185  1.00 40.77           C  
ATOM    704  C   LEU A 102     -17.142 100.321  28.130  1.00 41.32           C  
ATOM    705  O   LEU A 102     -17.356  99.308  27.436  1.00 41.48           O  
ATOM    706  CB  LEU A 102     -17.911 102.437  27.072  1.00 41.93           C  
ATOM    707  CG  LEU A 102     -17.998 102.055  25.573  1.00 42.16           C  
ATOM    708  CD1 LEU A 102     -19.388 101.443  25.313  1.00 38.46           C  
ATOM    709  CD2 LEU A 102     -17.700 103.254  24.640  1.00 44.64           C  
ATOM    710  N   ARG A 103     -15.999 100.494  28.796  1.00 40.07           N  
ATOM    711  CA  ARG A 103     -14.950  99.497  28.597  1.00 39.52           C  
ATOM    712  C   ARG A 103     -15.390  98.046  28.966  1.00 39.19           C  
ATOM    713  O   ARG A 103     -15.155  97.097  28.226  1.00 39.19           O  
ATOM    714  CB  ARG A 103     -13.647  99.927  29.258  1.00 38.26           C  
ATOM    715  CG  ARG A 103     -12.584  98.911  29.221  1.00 37.25           C  
ATOM    716  CD  ARG A 103     -11.366  99.501  29.758  1.00 38.56           C  
ATOM    717  NE  ARG A 103     -10.282  98.556  29.911  1.00 31.66           N  
ATOM    718  CZ  ARG A 103      -9.817  98.085  31.056  1.00 36.91           C  
ATOM    719  NH1 ARG A 103     -10.377  98.412  32.214  1.00 35.58           N  
ATOM    720  NH2 ARG A 103      -8.784  97.237  31.026  1.00 37.57           N  
ATOM    721  N   MET A 104     -16.034  97.895  30.108  1.00 40.51           N  
ATOM    722  CA  MET A 104     -16.590  96.607  30.549  1.00 39.09           C  
ATOM    723  C   MET A 104     -18.151  96.606  30.393  1.00 40.05           C  
ATOM    724  O   MET A 104     -18.877  95.995  31.220  1.00 40.07           O  
ATOM    725  CB  MET A 104     -16.202  96.355  32.015  1.00 39.85           C  
ATOM    726  CG  MET A 104     -14.693  96.283  32.337  1.00 39.22           C  
ATOM    727  SD  MET A 104     -13.848  94.876  31.536  1.00 43.08           S  
ATOM    728  CE  MET A 104     -12.219  95.170  32.149  1.00 45.22           C  
ATOM    729  N   TYR A 105     -18.696  97.249  29.357  1.00 38.55           N  
ATOM    730  CA  TYR A 105     -20.166  97.226  29.146  1.00 38.37           C  
ATOM    731  C   TYR A 105     -20.739  95.791  29.051  1.00 38.96           C  
ATOM    732  O   TYR A 105     -20.093  94.907  28.462  1.00 39.83           O  
ATOM    733  CB  TYR A 105     -20.497  97.956  27.857  1.00 38.15           C  
ATOM    734  CG  TYR A 105     -21.939  98.486  27.717  1.00 39.42           C  
ATOM    735  CD1 TYR A 105     -22.751  98.066  26.659  1.00 39.06           C  
ATOM    736  CD2 TYR A 105     -22.475  99.420  28.635  1.00 37.35           C  
ATOM    737  CE1 TYR A 105     -24.041  98.565  26.486  1.00 38.43           C  
ATOM    738  CE2 TYR A 105     -23.754  99.919  28.473  1.00 39.14           C  
ATOM    739  CZ  TYR A 105     -24.533  99.489  27.370  1.00 38.47           C  
ATOM    740  OH  TYR A 105     -25.808  99.997  27.159  1.00 39.25           O  
ATOM    741  N   ALA A 106     -21.939  95.564  29.590  1.00 38.69           N  
ATOM    742  CA  ALA A 106     -22.582  94.239  29.537  1.00 40.46           C  
ATOM    743  C   ALA A 106     -22.697  93.606  28.130  1.00 41.03           C  
ATOM    744  O   ALA A 106     -22.465  92.407  27.950  1.00 41.32           O  
ATOM    745  CB  ALA A 106     -23.987  94.265  30.222  1.00 40.07           C  
ATOM    746  N   LYS A 107     -23.071  94.433  27.159  1.00 42.51           N  
ATOM    747  CA  LYS A 107     -23.299  94.019  25.787  1.00 43.41           C  
ATOM    748  C   LYS A 107     -22.096  94.315  24.869  1.00 43.76           C  
ATOM    749  O   LYS A 107     -21.314  95.264  25.110  1.00 43.73           O  
ATOM    750  CB  LYS A 107     -24.534  94.753  25.263  1.00 43.75           C  
ATOM    751  CG  LYS A 107     -25.782  94.467  26.099  1.00 45.80           C  
ATOM    752  CD  LYS A 107     -27.019  95.249  25.690  1.00 44.36           C  
ATOM    753  CE  LYS A 107     -28.235  94.547  26.308  1.00 46.66           C  
ATOM    754  NZ  LYS A 107     -29.429  95.326  25.953  1.00 49.15           N  
ATOM    755  N   PRO A 108     -21.952  93.529  23.783  1.00 44.16           N  
ATOM    756  CA  PRO A 108     -20.783  93.840  22.941  1.00 43.36           C  
ATOM    757  C   PRO A 108     -20.945  95.193  22.254  1.00 43.44           C  
ATOM    758  O   PRO A 108     -22.087  95.670  22.032  1.00 43.47           O  
ATOM    759  CB  PRO A 108     -20.734  92.682  21.934  1.00 42.99           C  
ATOM    760  CG  PRO A 108     -22.084  92.053  21.969  1.00 44.14           C  
ATOM    761  CD  PRO A 108     -22.765  92.402  23.259  1.00 42.81           C  
ATOM    762  N   THR A 109     -19.796  95.804  21.952  1.00 42.77           N  
ATOM    763  CA  THR A 109     -19.717  97.151  21.421  1.00 41.66           C  
ATOM    764  C   THR A 109     -18.692  97.154  20.310  1.00 42.52           C  
ATOM    765  O   THR A 109     -17.625  96.502  20.410  1.00 42.67           O  
ATOM    766  CB  THR A 109     -19.281  98.152  22.497  1.00 42.29           C  
ATOM    767  OG1 THR A 109     -17.956  97.833  22.980  1.00 39.19           O  
ATOM    768  CG2 THR A 109     -20.273  98.158  23.640  1.00 36.85           C  
ATOM    769  N   ILE A 110     -19.058  97.828  19.231  1.00 43.08           N  
ATOM    770  CA  ILE A 110     -18.175  98.069  18.104  1.00 43.65           C  
ATOM    771  C   ILE A 110     -18.161  99.557  17.764  1.00 43.71           C  
ATOM    772  O   ILE A 110     -19.208 100.179  17.571  1.00 44.06           O  
ATOM    773  CB  ILE A 110     -18.648  97.307  16.819  1.00 44.20           C  
ATOM    774  CG1 ILE A 110     -18.912  95.815  17.105  1.00 42.91           C  
ATOM    775  CG2 ILE A 110     -17.621  97.467  15.732  1.00 42.09           C  
ATOM    776  CD1 ILE A 110     -19.559  95.020  15.915  1.00 43.16           C  
ATOM    777  N   ALA A 111     -16.971 100.114  17.653  1.00 43.51           N  
ATOM    778  CA  ALA A 111     -16.813 101.464  17.101  1.00 43.35           C  
ATOM    779  C   ALA A 111     -16.790 101.382  15.586  1.00 43.08           C  
ATOM    780  O   ALA A 111     -15.984 100.654  15.016  1.00 43.53           O  
ATOM    781  CB  ALA A 111     -15.556 102.125  17.619  1.00 42.26           C  
ATOM    782  N   MET A 112     -17.700 102.119  14.956  1.00 42.41           N  
ATOM    783  CA  MET A 112     -17.746 102.274  13.514  1.00 42.67           C  
ATOM    784  C   MET A 112     -17.307 103.691  13.175  1.00 41.82           C  
ATOM    785  O   MET A 112     -18.112 104.631  13.181  1.00 40.62           O  
ATOM    786  CB  MET A 112     -19.152 101.997  12.979  1.00 42.82           C  
ATOM    787  CG  MET A 112     -19.298 101.980  11.430  1.00 43.52           C  
ATOM    788  SD  MET A 112     -20.938 101.456  10.860  1.00 45.51           S  
ATOM    789  CE  MET A 112     -22.021 102.737  11.453  1.00 45.91           C  
ATOM    790  N   VAL A 113     -16.014 103.817  12.884  1.00 41.95           N  
ATOM    791  CA  VAL A 113     -15.336 105.127  12.780  1.00 41.90           C  
ATOM    792  C   VAL A 113     -15.425 105.635  11.352  1.00 42.66           C  
ATOM    793  O   VAL A 113     -14.611 105.304  10.503  1.00 43.31           O  
ATOM    794  CB  VAL A 113     -13.873 105.069  13.292  1.00 41.11           C  
ATOM    795  CG1 VAL A 113     -13.298 106.447  13.432  1.00 40.95           C  
ATOM    796  CG2 VAL A 113     -13.793 104.344  14.582  1.00 38.54           C  
ATOM    797  N   ASN A 114     -16.446 106.446  11.116  1.00 43.35           N  
ATOM    798  CA  ASN A 114     -16.829 106.905   9.797  1.00 43.74           C  
ATOM    799  C   ASN A 114     -15.982 108.047   9.267  1.00 44.94           C  
ATOM    800  O   ASN A 114     -15.965 108.294   8.036  1.00 46.17           O  
ATOM    801  CB  ASN A 114     -18.322 107.316   9.800  1.00 43.16           C  
ATOM    802  CG  ASN A 114     -18.659 108.285  10.930  1.00 43.52           C  
ATOM    803  OD1 ASN A 114     -18.612 107.945  12.126  1.00 41.15           O  
ATOM    804  ND2 ASN A 114     -18.996 109.493  10.560  1.00 42.90           N  
ATOM    805  N   GLY A 115     -15.296 108.764  10.168  1.00 45.57           N  
ATOM    806  CA  GLY A 115     -14.517 109.954   9.797  1.00 44.86           C  
ATOM    807  C   GLY A 115     -13.709 110.489  10.968  1.00 45.77           C  
ATOM    808  O   GLY A 115     -13.330 109.688  11.884  1.00 45.23           O  
ATOM    809  N   TRP A 116     -13.454 111.821  10.950  1.00 44.95           N  
ATOM    810  CA  TRP A 116     -12.630 112.515  11.967  1.00 44.91           C  
ATOM    811  C   TRP A 116     -12.679 111.838  13.355  1.00 44.39           C  
ATOM    812  O   TRP A 116     -13.754 111.677  13.968  1.00 43.69           O  
ATOM    813  CB  TRP A 116     -12.994 113.986  12.084  1.00 46.47           C  
ATOM    814  CG  TRP A 116     -13.057 114.747  10.741  1.00 48.19           C  
ATOM    815  CD1 TRP A 116     -14.179 115.130  10.068  1.00 50.52           C  
ATOM    816  CD2 TRP A 116     -11.950 115.228   9.966  1.00 50.77           C  
ATOM    817  NE1 TRP A 116     -13.852 115.816   8.900  1.00 53.00           N  
ATOM    818  CE2 TRP A 116     -12.488 115.887   8.814  1.00 52.15           C  
ATOM    819  CE3 TRP A 116     -10.556 115.146  10.111  1.00 51.04           C  
ATOM    820  CZ2 TRP A 116     -11.674 116.463   7.817  1.00 51.11           C  
ATOM    821  CZ3 TRP A 116      -9.735 115.744   9.115  1.00 51.86           C  
ATOM    822  CH2 TRP A 116     -10.302 116.388   7.988  1.00 50.80           C  
ATOM    823  N   CYS A 117     -11.518 111.376  13.808  1.00 42.74           N  
ATOM    824  CA  CYS A 117     -11.402 110.873  15.168  1.00 41.79           C  
ATOM    825  C   CYS A 117     -10.217 111.571  15.846  1.00 41.02           C  
ATOM    826  O   CYS A 117      -9.085 111.279  15.496  1.00 41.44           O  
ATOM    827  CB  CYS A 117     -11.264 109.357  15.145  1.00 41.62           C  
ATOM    828  SG  CYS A 117     -11.194 108.632  16.780  1.00 42.70           S  
ATOM    829  N   PHE A 118     -10.472 112.528  16.753  1.00 39.85           N  
ATOM    830  CA  PHE A 118      -9.401 113.256  17.454  1.00 39.87           C  
ATOM    831  C   PHE A 118      -9.430 113.154  18.960  1.00 39.65           C  
ATOM    832  O   PHE A 118     -10.472 112.860  19.526  1.00 39.26           O  
ATOM    833  CB  PHE A 118      -9.389 114.705  17.093  1.00 39.25           C  
ATOM    834  CG  PHE A 118      -8.919 114.939  15.722  1.00 43.04           C  
ATOM    835  CD1 PHE A 118      -9.815 115.166  14.710  1.00 44.09           C  
ATOM    836  CD2 PHE A 118      -7.542 114.910  15.428  1.00 45.54           C  
ATOM    837  CE1 PHE A 118      -9.357 115.377  13.430  1.00 48.57           C  
ATOM    838  CE2 PHE A 118      -7.073 115.123  14.160  1.00 46.90           C  
ATOM    839  CZ  PHE A 118      -7.972 115.348  13.149  1.00 46.54           C  
ATOM    840  N   GLY A 119      -8.254 113.344  19.558  1.00 38.90           N  
ATOM    841  CA  GLY A 119      -8.063 113.617  20.989  1.00 39.66           C  
ATOM    842  C   GLY A 119      -8.898 112.744  21.893  1.00 40.24           C  
ATOM    843  O   GLY A 119      -8.761 111.532  21.861  1.00 41.18           O  
ATOM    844  N   GLY A 120      -9.786 113.356  22.668  1.00 40.58           N  
ATOM    845  CA  GLY A 120     -10.574 112.637  23.650  1.00 41.16           C  
ATOM    846  C   GLY A 120     -11.429 111.496  23.106  1.00 41.60           C  
ATOM    847  O   GLY A 120     -11.928 110.649  23.903  1.00 41.32           O  
ATOM    848  N   GLY A 121     -11.575 111.455  21.775  1.00 41.45           N  
ATOM    849  CA  GLY A 121     -12.320 110.402  21.059  1.00 41.50           C  
ATOM    850  C   GLY A 121     -11.641 109.030  21.099  1.00 43.18           C  
ATOM    851  O   GLY A 121     -12.260 108.015  20.754  1.00 43.71           O  
ATOM    852  N   PHE A 122     -10.368 108.958  21.493  1.00 42.44           N  
ATOM    853  CA  PHE A 122      -9.685 107.673  21.513  1.00 41.92           C  
ATOM    854  C   PHE A 122     -10.074 106.842  22.710  1.00 42.78           C  
ATOM    855  O   PHE A 122      -9.973 105.607  22.656  1.00 44.61           O  
ATOM    856  CB  PHE A 122      -8.175 107.844  21.503  1.00 41.35           C  
ATOM    857  CG  PHE A 122      -7.596 108.225  20.146  1.00 42.35           C  
ATOM    858  CD1 PHE A 122      -7.912 109.447  19.549  1.00 41.34           C  
ATOM    859  CD2 PHE A 122      -6.655 107.400  19.522  1.00 41.62           C  
ATOM    860  CE1 PHE A 122      -7.377 109.798  18.310  1.00 41.30           C  
ATOM    861  CE2 PHE A 122      -6.092 107.765  18.266  1.00 42.88           C  
ATOM    862  CZ  PHE A 122      -6.456 108.961  17.676  1.00 39.82           C  
ATOM    863  N   SER A 123     -10.459 107.491  23.819  1.00 41.65           N  
ATOM    864  CA  SER A 123     -10.976 106.777  24.973  1.00 41.07           C  
ATOM    865  C   SER A 123     -12.239 105.931  24.591  1.00 40.34           C  
ATOM    866  O   SER A 123     -12.158 104.742  24.602  1.00 40.41           O  
ATOM    867  CB  SER A 123     -11.200 107.721  26.180  1.00 41.00           C  
ATOM    868  OG  SER A 123      -9.982 108.317  26.629  1.00 40.28           O  
ATOM    869  N   PRO A 124     -13.387 106.540  24.211  1.00 39.75           N  
ATOM    870  CA  PRO A 124     -14.485 105.621  23.807  1.00 39.50           C  
ATOM    871  C   PRO A 124     -14.120 104.658  22.629  1.00 39.16           C  
ATOM    872  O   PRO A 124     -14.649 103.557  22.559  1.00 39.28           O  
ATOM    873  CB  PRO A 124     -15.625 106.571  23.426  1.00 38.85           C  
ATOM    874  CG  PRO A 124     -14.957 107.888  23.169  1.00 39.27           C  
ATOM    875  CD  PRO A 124     -13.784 107.948  24.093  1.00 39.05           C  
ATOM    876  N   LEU A 125     -13.224 105.070  21.728  1.00 38.70           N  
ATOM    877  CA  LEU A 125     -12.740 104.197  20.674  1.00 37.97           C  
ATOM    878  C   LEU A 125     -12.141 102.881  21.188  1.00 38.26           C  
ATOM    879  O   LEU A 125     -12.367 101.787  20.599  1.00 38.74           O  
ATOM    880  CB  LEU A 125     -11.654 104.901  19.832  1.00 37.32           C  
ATOM    881  CG  LEU A 125     -11.004 104.121  18.666  1.00 35.16           C  
ATOM    882  CD1 LEU A 125     -12.019 103.719  17.624  1.00 33.89           C  
ATOM    883  CD2 LEU A 125      -9.836 104.883  18.028  1.00 35.94           C  
ATOM    884  N   VAL A 126     -11.241 102.992  22.171  1.00 38.51           N  
ATOM    885  CA  VAL A 126     -10.576 101.806  22.658  1.00 37.54           C  
ATOM    886  C   VAL A 126     -11.441 100.994  23.629  1.00 38.73           C  
ATOM    887  O   VAL A 126     -11.418  99.762  23.564  1.00 38.91           O  
ATOM    888  CB  VAL A 126      -9.116 102.077  23.030  1.00 37.96           C  
ATOM    889  CG1 VAL A 126      -8.428 100.788  23.603  1.00 40.63           C  
ATOM    890  CG2 VAL A 126      -8.376 102.528  21.786  1.00 33.69           C  
ATOM    891  N   ALA A 127     -12.289 101.688  24.431  1.00 39.14           N  
ATOM    892  CA  ALA A 127     -13.332 101.065  25.295  1.00 38.61           C  
ATOM    893  C   ALA A 127     -14.311 100.131  24.546  1.00 39.66           C  
ATOM    894  O   ALA A 127     -14.526  98.975  24.962  1.00 38.99           O  
ATOM    895  CB  ALA A 127     -14.077 102.133  26.073  1.00 37.70           C  
ATOM    896  N   CYS A 128     -14.891 100.607  23.436  1.00 40.29           N  
ATOM    897  CA  CYS A 128     -15.561  99.702  22.486  1.00 40.30           C  
ATOM    898  C   CYS A 128     -14.704  98.429  22.263  1.00 41.02           C  
ATOM    899  O   CYS A 128     -13.445  98.477  22.243  1.00 40.32           O  
ATOM    900  CB  CYS A 128     -15.861 100.405  21.158  1.00 40.55           C  
ATOM    901  SG  CYS A 128     -17.109 101.737  21.254  1.00 39.14           S  
ATOM    902  N   ASP A 129     -15.372  97.279  22.138  1.00 40.76           N  
ATOM    903  CA  ASP A 129     -14.617  96.051  22.100  1.00 41.12           C  
ATOM    904  C   ASP A 129     -13.856  95.939  20.792  1.00 41.84           C  
ATOM    905  O   ASP A 129     -12.623  95.775  20.798  1.00 41.61           O  
ATOM    906  CB  ASP A 129     -15.494  94.840  22.341  1.00 40.59           C  
ATOM    907  CG  ASP A 129     -16.243  94.924  23.624  1.00 41.33           C  
ATOM    908  OD1 ASP A 129     -15.661  95.328  24.679  1.00 40.57           O  
ATOM    909  OD2 ASP A 129     -17.428  94.556  23.589  1.00 37.56           O  
ATOM    910  N   LEU A 130     -14.598  96.071  19.687  1.00 41.88           N  
ATOM    911  CA  LEU A 130     -14.023  95.972  18.364  1.00 41.63           C  
ATOM    912  C   LEU A 130     -14.173  97.294  17.658  1.00 41.67           C  
ATOM    913  O   LEU A 130     -14.930  98.133  18.101  1.00 40.65           O  
ATOM    914  CB  LEU A 130     -14.691  94.828  17.593  1.00 42.02           C  
ATOM    915  CG  LEU A 130     -14.545  93.467  18.304  1.00 41.90           C  
ATOM    916  CD1 LEU A 130     -15.399  92.372  17.716  1.00 39.56           C  
ATOM    917  CD2 LEU A 130     -13.055  93.054  18.348  1.00 44.83           C  
ATOM    918  N   ALA A 131     -13.430  97.495  16.569  1.00 41.73           N  
ATOM    919  CA  ALA A 131     -13.592  98.711  15.781  1.00 42.38           C  
ATOM    920  C   ALA A 131     -13.332  98.533  14.286  1.00 43.28           C  
ATOM    921  O   ALA A 131     -12.384  97.881  13.876  1.00 44.30           O  
ATOM    922  CB  ALA A 131     -12.730  99.847  16.353  1.00 41.94           C  
ATOM    923  N   ILE A 132     -14.199  99.131  13.477  1.00 43.55           N  
ATOM    924  CA  ILE A 132     -13.966  99.262  12.058  1.00 43.42           C  
ATOM    925  C   ILE A 132     -14.005 100.749  11.671  1.00 42.90           C  
ATOM    926  O   ILE A 132     -14.904 101.496  12.032  1.00 42.58           O  
ATOM    927  CB  ILE A 132     -14.973  98.374  11.215  1.00 44.22           C  
ATOM    928  CG1 ILE A 132     -14.882  96.893  11.652  1.00 43.82           C  
ATOM    929  CG2 ILE A 132     -14.720  98.511   9.709  1.00 42.24           C  
ATOM    930  CD1 ILE A 132     -16.145  96.202  11.719  1.00 45.41           C  
ATOM    931  N   CYS A 133     -13.012 101.179  10.932  1.00 42.39           N  
ATOM    932  CA  CYS A 133     -13.030 102.537  10.425  1.00 42.63           C  
ATOM    933  C   CYS A 133     -13.077 102.534   8.893  1.00 42.83           C  
ATOM    934  O   CYS A 133     -12.688 101.535   8.256  1.00 43.08           O  
ATOM    935  CB  CYS A 133     -11.804 103.319  10.912  1.00 40.23           C  
ATOM    936  SG  CYS A 133     -10.309 102.641  10.266  1.00 40.18           S  
ATOM    937  N   ALA A 134     -13.513 103.664   8.324  1.00 43.46           N  
ATOM    938  CA  ALA A 134     -13.374 103.964   6.880  1.00 43.52           C  
ATOM    939  C   ALA A 134     -11.924 104.359   6.530  1.00 44.38           C  
ATOM    940  O   ALA A 134     -11.301 105.121   7.278  1.00 45.52           O  
ATOM    941  CB  ALA A 134     -14.302 105.108   6.541  1.00 42.73           C  
ATOM    942  N   ASP A 135     -11.381 103.862   5.415  1.00 44.31           N  
ATOM    943  CA  ASP A 135     -10.035 104.246   4.906  1.00 44.98           C  
ATOM    944  C   ASP A 135      -9.830 105.770   4.923  1.00 45.86           C  
ATOM    945  O   ASP A 135      -8.690 106.304   5.109  1.00 45.43           O  
ATOM    946  CB  ASP A 135      -9.830 103.733   3.439  1.00 43.84           C  
ATOM    947  CG  ASP A 135      -9.733 102.203   3.349  1.00 43.38           C  
ATOM    948  OD1 ASP A 135      -9.295 101.567   4.329  1.00 42.25           O  
ATOM    949  OD2 ASP A 135     -10.081 101.607   2.307  1.00 44.19           O  
ATOM    950  N   GLU A 136     -10.963 106.439   4.683  1.00 46.58           N  
ATOM    951  CA  GLU A 136     -11.063 107.871   4.455  1.00 46.99           C  
ATOM    952  C   GLU A 136     -11.036 108.634   5.761  1.00 46.95           C  
ATOM    953  O   GLU A 136     -10.818 109.827   5.780  1.00 48.20           O  
ATOM    954  CB  GLU A 136     -12.350 108.200   3.672  1.00 47.59           C  
ATOM    955  CG  GLU A 136     -12.408 107.656   2.195  1.00 48.02           C  
ATOM    956  CD  GLU A 136     -13.159 106.304   1.992  1.00 49.44           C  
ATOM    957  OE1 GLU A 136     -13.434 105.501   2.957  1.00 47.33           O  
ATOM    958  OE2 GLU A 136     -13.448 106.030   0.796  1.00 50.75           O  
ATOM    959  N   ALA A 137     -11.235 107.944   6.866  1.00 46.83           N  
ATOM    960  CA  ALA A 137     -11.183 108.589   8.176  1.00 46.17           C  
ATOM    961  C   ALA A 137      -9.772 109.067   8.578  1.00 44.80           C  
ATOM    962  O   ALA A 137      -8.760 108.408   8.311  1.00 44.10           O  
ATOM    963  CB  ALA A 137     -11.798 107.648   9.256  1.00 46.50           C  
ATOM    964  N   THR A 138      -9.739 110.218   9.239  1.00 43.57           N  
ATOM    965  CA  THR A 138      -8.511 110.775   9.800  1.00 42.98           C  
ATOM    966  C   THR A 138      -8.499 110.775  11.359  1.00 42.35           C  
ATOM    967  O   THR A 138      -9.429 111.259  12.018  1.00 41.65           O  
ATOM    968  CB  THR A 138      -8.195 112.227   9.214  1.00 43.32           C  
ATOM    969  OG1 THR A 138      -8.298 112.216   7.777  1.00 42.76           O  
ATOM    970  CG2 THR A 138      -6.825 112.726   9.618  1.00 42.41           C  
ATOM    971  N   PHE A 139      -7.403 110.271  11.916  1.00 41.38           N  
ATOM    972  CA  PHE A 139      -7.192 110.260  13.363  1.00 42.05           C  
ATOM    973  C   PHE A 139      -6.048 111.161  13.682  1.00 42.27           C  
ATOM    974  O   PHE A 139      -5.177 111.374  12.848  1.00 43.83           O  
ATOM    975  CB  PHE A 139      -6.827 108.863  13.909  1.00 41.10           C  
ATOM    976  CG  PHE A 139      -7.790 107.747  13.537  1.00 40.61           C  
ATOM    977  CD1 PHE A 139      -7.848 107.248  12.227  1.00 39.79           C  
ATOM    978  CD2 PHE A 139      -8.603 107.161  14.513  1.00 39.70           C  
ATOM    979  CE1 PHE A 139      -8.709 106.205  11.890  1.00 40.15           C  
ATOM    980  CE2 PHE A 139      -9.464 106.121  14.187  1.00 38.52           C  
ATOM    981  CZ  PHE A 139      -9.525 105.640  12.859  1.00 39.08           C  
ATOM    982  N   GLY A 140      -5.996 111.657  14.917  1.00 42.95           N  
ATOM    983  CA  GLY A 140      -4.819 112.338  15.361  1.00 41.68           C  
ATOM    984  C   GLY A 140      -4.950 112.720  16.805  1.00 42.92           C  
ATOM    985  O   GLY A 140      -6.052 112.899  17.342  1.00 42.84           O  
ATOM    986  N   LEU A 141      -3.799 112.844  17.438  1.00 43.20           N  
ATOM    987  CA  LEU A 141      -3.724 113.166  18.837  1.00 43.44           C  
ATOM    988  C   LEU A 141      -3.175 114.570  18.875  1.00 43.37           C  
ATOM    989  O   LEU A 141      -2.047 114.808  19.235  1.00 40.88           O  
ATOM    990  CB  LEU A 141      -2.834 112.157  19.574  1.00 43.23           C  
ATOM    991  CG  LEU A 141      -3.342 110.751  19.460  1.00 42.45           C  
ATOM    992  CD1 LEU A 141      -2.240 109.804  19.797  1.00 47.19           C  
ATOM    993  CD2 LEU A 141      -4.504 110.559  20.356  1.00 39.38           C  
ATOM    994  N   SER A 142      -4.062 115.479  18.513  1.00 45.09           N  
ATOM    995  CA  SER A 142      -3.808 116.909  18.302  1.00 46.80           C  
ATOM    996  C   SER A 142      -3.541 117.691  19.614  1.00 46.87           C  
ATOM    997  O   SER A 142      -3.066 118.834  19.579  1.00 48.06           O  
ATOM    998  CB  SER A 142      -5.068 117.493  17.666  1.00 46.40           C  
ATOM    999  OG  SER A 142      -6.192 117.071  18.479  1.00 51.02           O  
ATOM   1000  N   GLU A 143      -3.851 117.085  20.756  1.00 45.77           N  
ATOM   1001  CA  GLU A 143      -3.581 117.702  22.037  1.00 45.34           C  
ATOM   1002  C   GLU A 143      -2.283 118.495  22.075  1.00 44.43           C  
ATOM   1003  O   GLU A 143      -2.312 119.709  22.237  1.00 44.53           O  
ATOM   1004  CB  GLU A 143      -3.524 116.618  23.099  1.00 45.74           C  
ATOM   1005  CG  GLU A 143      -4.892 116.151  23.516  1.00 46.86           C  
ATOM   1006  CD  GLU A 143      -5.300 114.872  22.832  1.00 46.87           C  
ATOM   1007  OE1 GLU A 143      -4.776 114.552  21.780  1.00 46.18           O  
ATOM   1008  OE2 GLU A 143      -6.161 114.167  23.368  1.00 51.72           O  
ATOM   1009  N   ILE A 144      -1.167 117.788  21.898  1.00 42.91           N  
ATOM   1010  CA  ILE A 144       0.195 118.325  21.983  1.00 42.02           C  
ATOM   1011  C   ILE A 144       0.331 119.663  21.225  1.00 42.39           C  
ATOM   1012  O   ILE A 144       0.909 120.619  21.730  1.00 41.97           O  
ATOM   1013  CB  ILE A 144       1.217 117.242  21.481  1.00 40.41           C  
ATOM   1014  CG1 ILE A 144       2.681 117.579  21.814  1.00 40.33           C  
ATOM   1015  CG2 ILE A 144       1.096 117.027  19.968  1.00 40.79           C  
ATOM   1016  CD1 ILE A 144       3.002 117.813  23.246  1.00 39.88           C  
ATOM   1017  N   ASN A 145      -0.251 119.716  20.029  1.00 44.21           N  
ATOM   1018  CA  ASN A 145      -0.317 120.925  19.211  1.00 46.69           C  
ATOM   1019  C   ASN A 145      -1.069 122.124  19.838  1.00 47.25           C  
ATOM   1020  O   ASN A 145      -0.643 123.270  19.684  1.00 47.75           O  
ATOM   1021  CB  ASN A 145      -0.864 120.553  17.838  1.00 46.92           C  
ATOM   1022  CG  ASN A 145       0.114 119.681  17.062  1.00 47.96           C  
ATOM   1023  OD1 ASN A 145       1.332 119.755  17.279  1.00 45.24           O  
ATOM   1024  ND2 ASN A 145      -0.407 118.853  16.169  1.00 45.34           N  
ATOM   1025  N   TRP A 146      -2.150 121.843  20.570  1.00 48.24           N  
ATOM   1026  CA  TRP A 146      -2.882 122.870  21.365  1.00 48.68           C  
ATOM   1027  C   TRP A 146      -2.255 123.160  22.742  1.00 47.75           C  
ATOM   1028  O   TRP A 146      -2.829 123.896  23.529  1.00 47.76           O  
ATOM   1029  CB  TRP A 146      -4.331 122.412  21.578  1.00 48.59           C  
ATOM   1030  CG  TRP A 146      -5.215 122.580  20.367  1.00 52.07           C  
ATOM   1031  CD1 TRP A 146      -5.758 121.569  19.633  1.00 55.73           C  
ATOM   1032  NE1 TRP A 146      -6.516 122.082  18.633  1.00 59.08           N  
ATOM   1033  N   GLY A 147      -1.122 122.524  23.061  1.00 47.22           N  
ATOM   1034  CA  GLY A 147      -0.397 122.773  24.301  1.00 45.75           C  
ATOM   1035  C   GLY A 147      -0.993 122.044  25.472  1.00 45.55           C  
ATOM   1036  O   GLY A 147      -0.843 122.488  26.610  1.00 46.12           O  
ATOM   1037  N   ILE A 148      -1.679 120.924  25.226  1.00 44.55           N  
ATOM   1038  CA  ILE A 148      -1.974 119.982  26.329  1.00 42.91           C  
ATOM   1039  C   ILE A 148      -1.486 118.547  26.087  1.00 41.81           C  
ATOM   1040  O   ILE A 148      -1.559 118.033  24.986  1.00 41.24           O  
ATOM   1041  CB  ILE A 148      -3.439 119.953  26.761  1.00 42.77           C  
ATOM   1042  CG1 ILE A 148      -4.352 119.711  25.556  1.00 44.82           C  
ATOM   1043  CG2 ILE A 148      -3.795 121.232  27.545  1.00 43.67           C  
ATOM   1044  CD1 ILE A 148      -5.728 119.081  25.941  1.00 48.23           C  
ATOM   1045  N   PRO A 149      -1.013 117.873  27.138  1.00 41.26           N  
ATOM   1046  CA  PRO A 149      -0.715 116.447  26.940  1.00 39.73           C  
ATOM   1047  C   PRO A 149      -2.058 115.738  26.828  1.00 39.42           C  
ATOM   1048  O   PRO A 149      -3.105 116.360  27.126  1.00 39.66           O  
ATOM   1049  CB  PRO A 149       0.011 116.076  28.247  1.00 40.45           C  
ATOM   1050  CG  PRO A 149      -0.502 116.975  29.256  1.00 41.05           C  
ATOM   1051  CD  PRO A 149      -0.765 118.309  28.529  1.00 40.62           C  
ATOM   1052  N   PRO A 150      -2.095 114.477  26.369  1.00 38.42           N  
ATOM   1053  CA  PRO A 150      -3.464 113.925  26.228  1.00 37.25           C  
ATOM   1054  C   PRO A 150      -4.234 113.737  27.566  1.00 38.14           C  
ATOM   1055  O   PRO A 150      -3.671 113.241  28.559  1.00 38.11           O  
ATOM   1056  CB  PRO A 150      -3.220 112.572  25.531  1.00 37.15           C  
ATOM   1057  CG  PRO A 150      -1.886 112.689  24.879  1.00 36.80           C  
ATOM   1058  CD  PRO A 150      -1.066 113.539  25.872  1.00 38.15           C  
ATOM   1059  N   GLY A 151      -5.530 114.056  27.590  1.00 38.11           N  
ATOM   1060  CA  GLY A 151      -6.283 114.007  28.833  1.00 37.64           C  
ATOM   1061  C   GLY A 151      -7.221 112.802  28.942  1.00 38.27           C  
ATOM   1062  O   GLY A 151      -7.429 112.083  27.965  1.00 39.41           O  
ATOM   1063  N   ASN A 152      -7.838 112.612  30.111  1.00 37.44           N  
ATOM   1064  CA  ASN A 152      -8.692 111.459  30.361  1.00 37.38           C  
ATOM   1065  C   ASN A 152      -7.879 110.228  30.031  1.00 38.16           C  
ATOM   1066  O   ASN A 152      -6.683 110.230  30.360  1.00 38.78           O  
ATOM   1067  CB  ASN A 152     -10.038 111.532  29.622  1.00 36.62           C  
ATOM   1068  CG  ASN A 152     -11.099 110.684  30.275  1.00 37.27           C  
ATOM   1069  OD1 ASN A 152     -11.171 109.477  30.041  1.00 41.33           O  
ATOM   1070  ND2 ASN A 152     -11.942 111.294  31.072  1.00 37.79           N  
ATOM   1071  N   LEU A 153      -8.463 109.203  29.378  1.00 36.82           N  
ATOM   1072  CA  LEU A 153      -7.755 107.901  29.274  1.00 35.47           C  
ATOM   1073  C   LEU A 153      -7.092 107.755  27.896  1.00 35.15           C  
ATOM   1074  O   LEU A 153      -6.784 106.668  27.457  1.00 35.89           O  
ATOM   1075  CB  LEU A 153      -8.709 106.695  29.591  1.00 34.64           C  
ATOM   1076  CG  LEU A 153      -8.679 106.156  31.011  1.00 31.73           C  
ATOM   1077  CD1 LEU A 153      -7.480 105.230  31.205  1.00 33.29           C  
ATOM   1078  CD2 LEU A 153      -8.585 107.318  31.931  1.00 28.48           C  
ATOM   1079  N   VAL A 154      -6.932 108.863  27.192  1.00 35.43           N  
ATOM   1080  CA  VAL A 154      -6.428 108.851  25.813  1.00 35.02           C  
ATOM   1081  C   VAL A 154      -5.105 108.052  25.715  1.00 35.90           C  
ATOM   1082  O   VAL A 154      -5.033 107.081  24.926  1.00 36.98           O  
ATOM   1083  CB  VAL A 154      -6.307 110.318  25.254  1.00 35.60           C  
ATOM   1084  CG1 VAL A 154      -5.604 110.373  23.946  1.00 34.85           C  
ATOM   1085  CG2 VAL A 154      -7.707 110.949  25.137  1.00 31.47           C  
ATOM   1086  N   SER A 155      -4.110 108.368  26.549  1.00 34.52           N  
ATOM   1087  CA  SER A 155      -2.799 107.702  26.402  1.00 34.32           C  
ATOM   1088  C   SER A 155      -2.882 106.221  26.677  1.00 35.14           C  
ATOM   1089  O   SER A 155      -2.116 105.477  26.126  1.00 36.54           O  
ATOM   1090  CB  SER A 155      -1.715 108.365  27.254  1.00 32.00           C  
ATOM   1091  OG  SER A 155      -1.561 109.636  26.713  1.00 33.49           O  
ATOM   1092  N   LYS A 156      -3.852 105.794  27.494  1.00 36.50           N  
ATOM   1093  CA  LYS A 156      -4.000 104.385  27.891  1.00 35.63           C  
ATOM   1094  C   LYS A 156      -4.690 103.597  26.807  1.00 36.97           C  
ATOM   1095  O   LYS A 156      -4.321 102.421  26.521  1.00 38.25           O  
ATOM   1096  CB  LYS A 156      -4.740 104.271  29.238  1.00 35.79           C  
ATOM   1097  CG  LYS A 156      -4.834 102.835  29.865  1.00 34.43           C  
ATOM   1098  CD  LYS A 156      -3.475 102.215  30.035  1.00 29.72           C  
ATOM   1099  CE  LYS A 156      -3.644 100.814  30.691  1.00 36.07           C  
ATOM   1100  NZ  LYS A 156      -2.332 100.412  31.260  1.00 32.06           N  
ATOM   1101  N   ALA A 157      -5.693 104.231  26.213  1.00 37.16           N  
ATOM   1102  CA  ALA A 157      -6.292 103.763  24.973  1.00 37.26           C  
ATOM   1103  C   ALA A 157      -5.211 103.460  23.916  1.00 37.08           C  
ATOM   1104  O   ALA A 157      -5.208 102.399  23.341  1.00 38.28           O  
ATOM   1105  CB  ALA A 157      -7.315 104.782  24.456  1.00 35.40           C  
ATOM   1106  N   MET A 158      -4.285 104.368  23.673  1.00 36.71           N  
ATOM   1107  CA  MET A 158      -3.111 104.042  22.837  1.00 36.46           C  
ATOM   1108  C   MET A 158      -2.291 102.850  23.404  1.00 37.24           C  
ATOM   1109  O   MET A 158      -2.077 101.851  22.708  1.00 38.34           O  
ATOM   1110  CB  MET A 158      -2.191 105.292  22.702  1.00 36.77           C  
ATOM   1111  CG  MET A 158      -2.801 106.459  21.883  1.00 37.09           C  
ATOM   1112  SD  MET A 158      -3.138 105.959  20.159  1.00 38.88           S  
ATOM   1113  CE  MET A 158      -1.511 106.032  19.362  1.00 37.32           C  
ATOM   1114  N   ALA A 159      -1.865 102.951  24.662  1.00 36.23           N  
ATOM   1115  CA  ALA A 159      -1.030 101.950  25.290  1.00 37.66           C  
ATOM   1116  C   ALA A 159      -1.602 100.551  25.097  1.00 38.31           C  
ATOM   1117  O   ALA A 159      -0.819  99.592  24.947  1.00 40.10           O  
ATOM   1118  CB  ALA A 159      -0.799 102.239  26.808  1.00 35.48           C  
ATOM   1119  N   ASP A 160      -2.926 100.428  25.083  1.00 37.46           N  
ATOM   1120  CA  ASP A 160      -3.569  99.107  25.003  1.00 38.21           C  
ATOM   1121  C   ASP A 160      -3.597  98.524  23.611  1.00 37.40           C  
ATOM   1122  O   ASP A 160      -3.603  97.316  23.460  1.00 39.32           O  
ATOM   1123  CB  ASP A 160      -5.026  99.172  25.519  1.00 37.71           C  
ATOM   1124  CG  ASP A 160      -5.133  99.011  27.049  1.00 39.33           C  
ATOM   1125  OD1 ASP A 160      -4.112  98.851  27.795  1.00 39.22           O  
ATOM   1126  OD2 ASP A 160      -6.275  99.048  27.508  1.00 41.65           O  
ATOM   1127  N   THR A 161      -3.644  99.369  22.577  1.00 36.95           N  
ATOM   1128  CA  THR A 161      -3.854  98.855  21.209  1.00 35.51           C  
ATOM   1129  C   THR A 161      -2.682  99.081  20.268  1.00 34.38           C  
ATOM   1130  O   THR A 161      -2.560  98.422  19.258  1.00 33.80           O  
ATOM   1131  CB  THR A 161      -5.109  99.485  20.601  1.00 35.76           C  
ATOM   1132  OG1 THR A 161      -4.994 100.913  20.673  1.00 38.56           O  
ATOM   1133  CG2 THR A 161      -6.361  99.069  21.379  1.00 34.57           C  
ATOM   1134  N   VAL A 162      -1.859 100.083  20.553  1.00 35.51           N  
ATOM   1135  CA  VAL A 162      -0.872 100.544  19.581  1.00 34.98           C  
ATOM   1136  C   VAL A 162       0.466 100.345  20.282  1.00 35.78           C  
ATOM   1137  O   VAL A 162       0.557 100.553  21.491  1.00 35.46           O  
ATOM   1138  CB  VAL A 162      -1.060 102.025  19.155  1.00 35.70           C  
ATOM   1139  CG1 VAL A 162       0.064 102.459  18.176  1.00 33.56           C  
ATOM   1140  CG2 VAL A 162      -2.451 102.275  18.553  1.00 31.69           C  
ATOM   1141  N   GLY A 163       1.478  99.930  19.519  1.00 35.06           N  
ATOM   1142  CA  GLY A 163       2.799  99.660  20.047  1.00 33.60           C  
ATOM   1143  C   GLY A 163       3.453 100.905  20.661  1.00 33.39           C  
ATOM   1144  O   GLY A 163       3.002 102.057  20.448  1.00 31.33           O  
ATOM   1145  N   HIS A 164       4.523 100.645  21.421  1.00 32.62           N  
ATOM   1146  CA  HIS A 164       5.215 101.637  22.206  1.00 32.24           C  
ATOM   1147  C   HIS A 164       5.786 102.784  21.327  1.00 33.56           C  
ATOM   1148  O   HIS A 164       5.452 103.983  21.539  1.00 33.91           O  
ATOM   1149  CB  HIS A 164       6.250 100.906  23.079  1.00 30.83           C  
ATOM   1150  CG  HIS A 164       7.149 101.809  23.863  1.00 31.63           C  
ATOM   1151  ND1 HIS A 164       6.889 102.183  25.168  1.00 27.49           N  
ATOM   1152  CD2 HIS A 164       8.313 102.421  23.515  1.00 31.24           C  
ATOM   1153  CE1 HIS A 164       7.842 103.005  25.579  1.00 28.10           C  
ATOM   1154  NE2 HIS A 164       8.726 103.158  24.595  1.00 28.46           N  
ATOM   1155  N   ARG A 165       6.603 102.442  20.324  1.00 33.68           N  
ATOM   1156  CA  ARG A 165       7.260 103.466  19.449  1.00 34.49           C  
ATOM   1157  C   ARG A 165       6.242 104.368  18.680  1.00 35.09           C  
ATOM   1158  O   ARG A 165       6.383 105.616  18.638  1.00 35.40           O  
ATOM   1159  CB  ARG A 165       8.230 102.776  18.434  1.00 33.20           C  
ATOM   1160  CG  ARG A 165       9.467 102.112  19.062  1.00 31.43           C  
ATOM   1161  CD  ARG A 165      10.345 103.149  19.812  1.00 27.74           C  
ATOM   1162  NE  ARG A 165      11.660 102.604  20.027  1.00 25.10           N  
ATOM   1163  CZ  ARG A 165      12.612 103.152  20.771  1.00 26.90           C  
ATOM   1164  NH1 ARG A 165      12.366 104.284  21.418  1.00 27.33           N  
ATOM   1165  NH2 ARG A 165      13.791 102.532  20.905  1.00 27.05           N  
ATOM   1166  N   GLN A 166       5.282 103.711  18.020  1.00 35.88           N  
ATOM   1167  CA  GLN A 166       4.129 104.348  17.386  1.00 37.64           C  
ATOM   1168  C   GLN A 166       3.244 105.198  18.295  1.00 36.04           C  
ATOM   1169  O   GLN A 166       2.888 106.305  17.934  1.00 35.41           O  
ATOM   1170  CB  GLN A 166       3.259 103.310  16.628  1.00 37.41           C  
ATOM   1171  CG  GLN A 166       4.080 102.509  15.611  1.00 41.24           C  
ATOM   1172  CD  GLN A 166       3.249 101.626  14.664  1.00 41.97           C  
ATOM   1173  OE1 GLN A 166       3.111 101.934  13.487  1.00 51.21           O  
ATOM   1174  NE2 GLN A 166       2.706 100.541  15.174  1.00 45.56           N  
ATOM   1175  N   SER A 167       2.813 104.666  19.434  1.00 36.57           N  
ATOM   1176  CA  SER A 167       2.067 105.498  20.386  1.00 34.61           C  
ATOM   1177  C   SER A 167       2.840 106.819  20.684  1.00 34.93           C  
ATOM   1178  O   SER A 167       2.316 107.929  20.530  1.00 34.06           O  
ATOM   1179  CB  SER A 167       1.794 104.768  21.677  1.00 33.29           C  
ATOM   1180  OG  SER A 167       0.828 103.793  21.506  1.00 31.16           O  
ATOM   1181  N   LEU A 168       4.069 106.673  21.124  1.00 34.50           N  
ATOM   1182  CA  LEU A 168       4.878 107.807  21.496  1.00 35.48           C  
ATOM   1183  C   LEU A 168       5.057 108.755  20.288  1.00 36.68           C  
ATOM   1184  O   LEU A 168       4.979 109.969  20.444  1.00 37.66           O  
ATOM   1185  CB  LEU A 168       6.230 107.339  22.059  1.00 33.82           C  
ATOM   1186  CG  LEU A 168       6.310 106.967  23.551  1.00 32.89           C  
ATOM   1187  CD1 LEU A 168       7.734 106.314  23.833  1.00 29.35           C  
ATOM   1188  CD2 LEU A 168       5.975 108.180  24.516  1.00 30.35           C  
ATOM   1189  N   TYR A 169       5.275 108.210  19.093  1.00 37.70           N  
ATOM   1190  CA  TYR A 169       5.348 109.030  17.871  1.00 37.94           C  
ATOM   1191  C   TYR A 169       4.149 109.985  17.682  1.00 38.13           C  
ATOM   1192  O   TYR A 169       4.339 111.194  17.543  1.00 37.80           O  
ATOM   1193  CB  TYR A 169       5.437 108.156  16.631  1.00 38.91           C  
ATOM   1194  CG  TYR A 169       5.678 108.986  15.356  1.00 38.89           C  
ATOM   1195  CD1 TYR A 169       6.976 109.388  14.996  1.00 39.35           C  
ATOM   1196  CD2 TYR A 169       4.632 109.312  14.501  1.00 37.15           C  
ATOM   1197  CE1 TYR A 169       7.220 110.110  13.863  1.00 38.74           C  
ATOM   1198  CE2 TYR A 169       4.865 110.065  13.339  1.00 41.76           C  
ATOM   1199  CZ  TYR A 169       6.167 110.432  13.017  1.00 39.80           C  
ATOM   1200  OH  TYR A 169       6.432 111.162  11.853  1.00 44.66           O  
ATOM   1201  N   TYR A 170       2.950 109.418  17.623  1.00 37.51           N  
ATOM   1202  CA  TYR A 170       1.696 110.131  17.377  1.00 38.42           C  
ATOM   1203  C   TYR A 170       1.306 111.090  18.529  1.00 37.44           C  
ATOM   1204  O   TYR A 170       0.735 112.151  18.327  1.00 36.76           O  
ATOM   1205  CB  TYR A 170       0.572 109.078  17.039  1.00 39.72           C  
ATOM   1206  CG  TYR A 170       0.816 108.504  15.617  1.00 42.11           C  
ATOM   1207  CD1 TYR A 170       0.849 109.364  14.509  1.00 43.99           C  
ATOM   1208  CD2 TYR A 170       1.085 107.157  15.388  1.00 44.23           C  
ATOM   1209  CE1 TYR A 170       1.117 108.930  13.242  1.00 45.15           C  
ATOM   1210  CE2 TYR A 170       1.354 106.687  14.042  1.00 43.93           C  
ATOM   1211  CZ  TYR A 170       1.358 107.595  12.991  1.00 44.60           C  
ATOM   1212  OH  TYR A 170       1.623 107.211  11.689  1.00 40.27           O  
ATOM   1213  N   ILE A 171       1.597 110.686  19.750  1.00 36.82           N  
ATOM   1214  CA  ILE A 171       1.378 111.519  20.908  1.00 35.07           C  
ATOM   1215  C   ILE A 171       2.349 112.702  20.875  1.00 36.24           C  
ATOM   1216  O   ILE A 171       1.921 113.873  21.002  1.00 38.51           O  
ATOM   1217  CB  ILE A 171       1.533 110.694  22.197  1.00 35.31           C  
ATOM   1218  CG1 ILE A 171       0.335 109.730  22.388  1.00 32.89           C  
ATOM   1219  CG2 ILE A 171       1.669 111.597  23.499  1.00 33.29           C  
ATOM   1220  CD1 ILE A 171       0.582 108.781  23.620  1.00 33.80           C  
ATOM   1221  N   MET A 172       3.628 112.419  20.693  1.00 34.81           N  
ATOM   1222  CA  MET A 172       4.611 113.442  20.701  1.00 35.03           C  
ATOM   1223  C   MET A 172       4.570 114.379  19.490  1.00 36.58           C  
ATOM   1224  O   MET A 172       4.777 115.585  19.657  1.00 37.68           O  
ATOM   1225  CB  MET A 172       6.015 112.854  20.878  1.00 36.79           C  
ATOM   1226  CG  MET A 172       6.249 112.252  22.248  1.00 32.98           C  
ATOM   1227  SD  MET A 172       7.755 111.291  22.308  1.00 31.73           S  
ATOM   1228  CE  MET A 172       9.097 112.543  22.386  1.00 27.30           C  
ATOM   1229  N   THR A 173       4.286 113.867  18.285  1.00 36.31           N  
ATOM   1230  CA  THR A 173       4.299 114.712  17.110  1.00 35.49           C  
ATOM   1231  C   THR A 173       2.959 115.376  16.848  1.00 36.38           C  
ATOM   1232  O   THR A 173       2.947 116.452  16.275  1.00 37.45           O  
ATOM   1233  CB  THR A 173       4.713 113.961  15.799  1.00 35.74           C  
ATOM   1234  OG1 THR A 173       3.743 112.950  15.525  1.00 37.35           O  
ATOM   1235  CG2 THR A 173       6.106 113.349  15.879  1.00 31.87           C  
ATOM   1236  N   GLY A 174       1.834 114.753  17.221  1.00 36.56           N  
ATOM   1237  CA  GLY A 174       0.506 115.303  16.919  1.00 36.53           C  
ATOM   1238  C   GLY A 174       0.082 115.097  15.450  1.00 38.76           C  
ATOM   1239  O   GLY A 174      -0.903 115.721  14.987  1.00 38.44           O  
ATOM   1240  N   LYS A 175       0.822 114.245  14.718  1.00 39.68           N  
ATOM   1241  CA  LYS A 175       0.576 113.914  13.302  1.00 40.78           C  
ATOM   1242  C   LYS A 175      -0.649 113.015  13.107  1.00 40.56           C  
ATOM   1243  O   LYS A 175      -0.943 112.138  13.909  1.00 39.87           O  
ATOM   1244  CB  LYS A 175       1.848 113.286  12.652  1.00 40.99           C  
ATOM   1245  CG  LYS A 175       3.028 114.312  12.339  1.00 42.62           C  
ATOM   1246  CD  LYS A 175       4.316 113.535  12.115  1.00 44.62           C  
ATOM   1247  CE  LYS A 175       5.524 114.462  11.806  1.00 50.24           C  
ATOM   1248  NZ  LYS A 175       5.305 115.284  10.553  1.00 58.87           N  
ATOM   1249  N   THR A 176      -1.378 113.271  12.025  1.00 41.29           N  
ATOM   1250  CA  THR A 176      -2.629 112.575  11.727  1.00 41.32           C  
ATOM   1251  C   THR A 176      -2.291 111.314  10.900  1.00 41.89           C  
ATOM   1252  O   THR A 176      -1.225 111.218  10.308  1.00 41.54           O  
ATOM   1253  CB  THR A 176      -3.617 113.484  10.927  1.00 40.58           C  
ATOM   1254  OG1 THR A 176      -2.956 113.947   9.757  1.00 41.09           O  
ATOM   1255  CG2 THR A 176      -4.051 114.667  11.701  1.00 40.62           C  
ATOM   1256  N   PHE A 177      -3.183 110.330  10.897  1.00 41.98           N  
ATOM   1257  CA  PHE A 177      -2.959 109.145  10.120  1.00 42.18           C  
ATOM   1258  C   PHE A 177      -4.326 108.699   9.670  1.00 42.82           C  
ATOM   1259  O   PHE A 177      -5.320 109.023  10.305  1.00 42.97           O  
ATOM   1260  CB  PHE A 177      -2.211 108.070  10.912  1.00 41.88           C  
ATOM   1261  CG  PHE A 177      -2.783 107.795  12.291  1.00 41.28           C  
ATOM   1262  CD1 PHE A 177      -2.433 108.588  13.385  1.00 41.52           C  
ATOM   1263  CD2 PHE A 177      -3.644 106.745  12.491  1.00 38.62           C  
ATOM   1264  CE1 PHE A 177      -2.972 108.325  14.642  1.00 43.37           C  
ATOM   1265  CE2 PHE A 177      -4.169 106.471  13.737  1.00 41.22           C  
ATOM   1266  CZ  PHE A 177      -3.834 107.267  14.818  1.00 41.70           C  
ATOM   1267  N   GLY A 178      -4.377 108.000   8.545  1.00 42.55           N  
ATOM   1268  CA  GLY A 178      -5.644 107.610   7.973  1.00 43.42           C  
ATOM   1269  C   GLY A 178      -6.094 106.247   8.481  1.00 44.53           C  
ATOM   1270  O   GLY A 178      -5.404 105.612   9.305  1.00 44.58           O  
ATOM   1271  N   GLY A 179      -7.271 105.823   8.027  1.00 44.78           N  
ATOM   1272  CA  GLY A 179      -7.849 104.518   8.382  1.00 46.27           C  
ATOM   1273  C   GLY A 179      -6.970 103.288   8.154  1.00 46.93           C  
ATOM   1274  O   GLY A 179      -6.958 102.386   8.992  1.00 48.12           O  
ATOM   1275  N   GLN A 180      -6.237 103.226   7.042  1.00 47.56           N  
ATOM   1276  CA  GLN A 180      -5.362 102.059   6.774  1.00 47.76           C  
ATOM   1277  C   GLN A 180      -4.178 101.961   7.761  1.00 47.06           C  
ATOM   1278  O   GLN A 180      -3.795 100.847   8.207  1.00 47.70           O  
ATOM   1279  CB  GLN A 180      -4.861 102.025   5.322  1.00 47.28           C  
ATOM   1280  CG  GLN A 180      -5.906 101.494   4.325  1.00 49.36           C  
ATOM   1281  CD  GLN A 180      -6.093  99.955   4.344  1.00 51.52           C  
ATOM   1282  OE1 GLN A 180      -7.226  99.444   4.366  1.00 47.66           O  
ATOM   1283  NE2 GLN A 180      -4.977  99.225   4.330  1.00 53.71           N  
ATOM   1284  N   LYS A 181      -3.617 103.113   8.109  1.00 45.36           N  
ATOM   1285  CA  LYS A 181      -2.561 103.146   9.087  1.00 44.23           C  
ATOM   1286  C   LYS A 181      -3.116 102.812  10.468  1.00 42.74           C  
ATOM   1287  O   LYS A 181      -2.445 102.142  11.218  1.00 41.08           O  
ATOM   1288  CB  LYS A 181      -1.832 104.485   9.073  1.00 45.18           C  
ATOM   1289  CG  LYS A 181      -0.689 104.609  10.097  1.00 47.15           C  
ATOM   1290  CD  LYS A 181       0.324 103.439  10.034  1.00 50.51           C  
ATOM   1291  CE  LYS A 181       1.802 103.922   9.953  1.00 52.44           C  
ATOM   1292  NZ  LYS A 181       2.457 104.287  11.260  1.00 50.06           N  
ATOM   1293  N   ALA A 182      -4.331 103.262  10.785  1.00 41.30           N  
ATOM   1294  CA  ALA A 182      -4.989 102.865  12.015  1.00 41.30           C  
ATOM   1295  C   ALA A 182      -5.063 101.321  12.200  1.00 41.87           C  
ATOM   1296  O   ALA A 182      -4.686 100.806  13.268  1.00 40.67           O  
ATOM   1297  CB  ALA A 182      -6.387 103.512  12.118  1.00 41.20           C  
ATOM   1298  N   ALA A 183      -5.534 100.601  11.171  1.00 42.63           N  
ATOM   1299  CA  ALA A 183      -5.575  99.119  11.192  1.00 44.15           C  
ATOM   1300  C   ALA A 183      -4.199  98.436  11.281  1.00 44.73           C  
ATOM   1301  O   ALA A 183      -4.042  97.429  11.963  1.00 45.60           O  
ATOM   1302  CB  ALA A 183      -6.373  98.559   9.996  1.00 42.47           C  
ATOM   1303  N   GLU A 184      -3.200  98.967  10.609  1.00 45.18           N  
ATOM   1304  CA  GLU A 184      -1.887  98.344  10.688  1.00 47.59           C  
ATOM   1305  C   GLU A 184      -1.194  98.559  12.069  1.00 45.71           C  
ATOM   1306  O   GLU A 184      -0.378  97.746  12.498  1.00 45.73           O  
ATOM   1307  CB  GLU A 184      -1.011  98.795   9.523  1.00 47.19           C  
ATOM   1308  CG  GLU A 184       0.348  99.378   9.939  1.00 52.95           C  
ATOM   1309  CD  GLU A 184       1.190  99.887   8.754  1.00 54.92           C  
ATOM   1310  OE1 GLU A 184       0.607 100.217   7.666  1.00 66.10           O  
ATOM   1311  OE2 GLU A 184       2.446  99.971   8.909  1.00 62.79           O  
ATOM   1312  N   MET A 185      -1.525  99.656  12.739  0.50 44.95           N  
ATOM   1313  CA  MET A 185      -1.019  99.928  14.067  0.50 44.09           C  
ATOM   1314  C   MET A 185      -1.658  99.013  15.110  0.50 43.82           C  
ATOM   1315  O   MET A 185      -0.997  98.596  16.049  0.50 43.15           O  
ATOM   1316  CB  MET A 185      -1.270 101.384  14.426  0.50 44.10           C  
ATOM   1317  CG  MET A 185      -0.089 102.282  14.083  0.50 44.35           C  
ATOM   1318  SD  MET A 185      -0.602 103.985  13.917  0.50 43.98           S  
ATOM   1319  CE  MET A 185      -1.504 104.360  15.420  0.50 41.73           C  
ATOM   1328  N   GLY A 186      -2.934  98.691  14.911  1.00 43.04           N  
ATOM   1329  CA  GLY A 186      -3.701  97.917  15.877  1.00 42.66           C  
ATOM   1330  C   GLY A 186      -4.742  98.751  16.611  1.00 42.11           C  
ATOM   1331  O   GLY A 186      -5.349  98.278  17.559  1.00 40.94           O  
ATOM   1332  N   LEU A 187      -4.939 100.002  16.171  1.00 41.61           N  
ATOM   1333  CA  LEU A 187      -5.900 100.888  16.816  1.00 41.30           C  
ATOM   1334  C   LEU A 187      -7.341 100.372  16.630  1.00 41.06           C  
ATOM   1335  O   LEU A 187      -8.193 100.483  17.506  1.00 40.27           O  
ATOM   1336  CB  LEU A 187      -5.735 102.309  16.284  1.00 40.80           C  
ATOM   1337  CG  LEU A 187      -6.516 103.379  17.013  1.00 41.78           C  
ATOM   1338  CD1 LEU A 187      -5.898 103.581  18.462  1.00 37.47           C  
ATOM   1339  CD2 LEU A 187      -6.588 104.702  16.220  1.00 42.04           C  
ATOM   1340  N   VAL A 188      -7.581  99.784  15.467  1.00 41.49           N  
ATOM   1341  CA  VAL A 188      -8.905  99.289  15.072  1.00 40.65           C  
ATOM   1342  C   VAL A 188      -8.689  97.899  14.449  1.00 41.43           C  
ATOM   1343  O   VAL A 188      -7.528  97.524  14.116  1.00 40.17           O  
ATOM   1344  CB  VAL A 188      -9.611 100.290  14.087  1.00 40.16           C  
ATOM   1345  CG1 VAL A 188      -9.938 101.658  14.782  1.00 35.84           C  
ATOM   1346  CG2 VAL A 188      -8.748 100.480  12.792  1.00 40.46           C  
ATOM   1347  N   ASN A 189      -9.781  97.129  14.314  1.00 41.43           N  
ATOM   1348  CA  ASN A 189      -9.705  95.796  13.704  1.00 42.54           C  
ATOM   1349  C   ASN A 189      -9.369  95.778  12.189  1.00 43.87           C  
ATOM   1350  O   ASN A 189      -8.581  94.922  11.718  1.00 43.44           O  
ATOM   1351  CB  ASN A 189     -10.964  94.940  14.003  1.00 42.32           C  
ATOM   1352  CG  ASN A 189     -11.102  94.606  15.488  1.00 42.16           C  
ATOM   1353  OD1 ASN A 189     -11.706  95.360  16.231  1.00 40.28           O  
ATOM   1354  ND2 ASN A 189     -10.490  93.501  15.931  1.00 44.84           N  
ATOM   1355  N   GLU A 190      -9.954  96.724  11.452  1.00 44.86           N  
ATOM   1356  CA  GLU A 190      -9.969  96.675  10.003  1.00 46.06           C  
ATOM   1357  C   GLU A 190     -10.262  98.053   9.423  1.00 45.78           C  
ATOM   1358  O   GLU A 190     -10.942  98.843  10.047  1.00 46.38           O  
ATOM   1359  CB  GLU A 190     -11.077  95.734   9.607  1.00 46.72           C  
ATOM   1360  CG  GLU A 190     -10.803  94.863   8.416  1.00 50.32           C  
ATOM   1361  CD  GLU A 190     -11.970  93.890   8.218  1.00 54.09           C  
ATOM   1362  OE1 GLU A 190     -12.842  93.816   9.154  1.00 53.06           O  
ATOM   1363  OE2 GLU A 190     -12.002  93.224   7.148  1.00 52.20           O  
ATOM   1364  N   SER A 191      -9.721  98.354   8.250  1.00 46.01           N  
ATOM   1365  CA  SER A 191     -10.081  99.588   7.567  1.00 46.26           C  
ATOM   1366  C   SER A 191     -10.728  99.194   6.242  1.00 46.72           C  
ATOM   1367  O   SER A 191     -10.126  98.427   5.481  1.00 47.41           O  
ATOM   1368  CB  SER A 191      -8.832 100.453   7.324  1.00 46.77           C  
ATOM   1369  OG  SER A 191      -9.132 101.838   7.347  1.00 43.63           O  
ATOM   1370  N   VAL A 192     -11.948  99.678   5.975  1.00 46.99           N  
ATOM   1371  CA  VAL A 192     -12.651  99.368   4.697  1.00 47.99           C  
ATOM   1372  C   VAL A 192     -12.980 100.676   3.939  1.00 48.75           C  
ATOM   1373  O   VAL A 192     -12.997 101.737   4.560  1.00 49.34           O  
ATOM   1374  CB  VAL A 192     -13.927  98.459   4.902  1.00 47.73           C  
ATOM   1375  CG1 VAL A 192     -13.535  97.093   5.425  1.00 46.75           C  
ATOM   1376  CG2 VAL A 192     -14.917  99.080   5.851  1.00 47.34           C  
ATOM   1377  N   PRO A 193     -13.203 100.638   2.606  1.00 49.10           N  
ATOM   1378  CA  PRO A 193     -13.773 101.928   2.155  1.00 50.15           C  
ATOM   1379  C   PRO A 193     -15.048 102.374   2.919  1.00 50.01           C  
ATOM   1380  O   PRO A 193     -15.749 101.542   3.482  1.00 50.54           O  
ATOM   1381  CB  PRO A 193     -13.991 101.727   0.633  1.00 49.53           C  
ATOM   1382  CG  PRO A 193     -13.001 100.682   0.258  1.00 49.12           C  
ATOM   1383  CD  PRO A 193     -12.958  99.731   1.472  1.00 49.13           C  
ATOM   1384  N   LEU A 194     -15.279 103.685   2.989  1.00 50.17           N  
ATOM   1385  CA  LEU A 194     -16.493 104.238   3.603  1.00 50.00           C  
ATOM   1386  C   LEU A 194     -17.754 103.625   3.035  1.00 50.57           C  
ATOM   1387  O   LEU A 194     -18.670 103.238   3.791  1.00 50.17           O  
ATOM   1388  CB  LEU A 194     -16.523 105.761   3.448  1.00 49.69           C  
ATOM   1389  CG  LEU A 194     -17.674 106.559   4.050  1.00 49.13           C  
ATOM   1390  CD1 LEU A 194     -17.914 106.190   5.497  1.00 45.77           C  
ATOM   1391  CD2 LEU A 194     -17.338 108.060   3.902  1.00 45.54           C  
ATOM   1392  N   ALA A 195     -17.780 103.515   1.702  1.00 51.05           N  
ATOM   1393  CA  ALA A 195     -18.913 102.972   0.977  1.00 51.35           C  
ATOM   1394  C   ALA A 195     -19.332 101.621   1.556  1.00 51.80           C  
ATOM   1395  O   ALA A 195     -20.514 101.259   1.516  1.00 52.31           O  
ATOM   1396  CB  ALA A 195     -18.557 102.841  -0.524  1.00 51.84           C  
ATOM   1397  N   GLN A 196     -18.361 100.893   2.106  1.00 52.14           N  
ATOM   1398  CA  GLN A 196     -18.557  99.543   2.659  1.00 53.03           C  
ATOM   1399  C   GLN A 196     -18.494  99.419   4.234  1.00 53.34           C  
ATOM   1400  O   GLN A 196     -18.514  98.294   4.810  1.00 54.35           O  
ATOM   1401  CB  GLN A 196     -17.565  98.617   1.951  1.00 53.13           C  
ATOM   1402  CG  GLN A 196     -17.757  98.667   0.415  1.00 56.52           C  
ATOM   1403  CD  GLN A 196     -16.453  98.622  -0.361  1.00 60.48           C  
ATOM   1404  OE1 GLN A 196     -15.596  97.760  -0.112  1.00 62.48           O  
ATOM   1405  NE2 GLN A 196     -16.293  99.550  -1.321  1.00 61.15           N  
ATOM   1406  N   LEU A 197     -18.459 100.561   4.933  1.00 52.46           N  
ATOM   1407  CA  LEU A 197     -18.371 100.576   6.409  1.00 51.46           C  
ATOM   1408  C   LEU A 197     -19.594  99.982   7.116  1.00 51.08           C  
ATOM   1409  O   LEU A 197     -19.440  99.145   8.008  1.00 50.77           O  
ATOM   1410  CB  LEU A 197     -18.099 101.997   6.936  1.00 50.90           C  
ATOM   1411  CG  LEU A 197     -17.728 102.103   8.417  1.00 51.12           C  
ATOM   1412  CD1 LEU A 197     -16.512 101.275   8.708  1.00 50.58           C  
ATOM   1413  CD2 LEU A 197     -17.502 103.518   8.836  1.00 50.84           C  
ATOM   1414  N   ARG A 198     -20.792 100.437   6.742  1.00 50.88           N  
ATOM   1415  CA  ARG A 198     -22.030 100.033   7.439  1.00 51.10           C  
ATOM   1416  C   ARG A 198     -22.310  98.517   7.302  1.00 50.47           C  
ATOM   1417  O   ARG A 198     -22.791  97.877   8.229  1.00 50.66           O  
ATOM   1418  CB  ARG A 198     -23.216 100.882   6.962  1.00 50.92           C  
ATOM   1419  CG  ARG A 198     -24.443 100.779   7.860  1.00 51.71           C  
ATOM   1420  CD  ARG A 198     -25.625 101.624   7.371  1.00 52.13           C  
ATOM   1421  NE  ARG A 198     -26.713 101.624   8.354  1.00 53.68           N  
ATOM   1422  CZ  ARG A 198     -26.733 102.356   9.486  1.00 57.84           C  
ATOM   1423  NH1 ARG A 198     -25.718 103.189   9.816  1.00 56.04           N  
ATOM   1424  NH2 ARG A 198     -27.781 102.254  10.320  1.00 56.87           N  
ATOM   1425  N   GLU A 199     -21.937  97.973   6.145  1.00 50.29           N  
ATOM   1426  CA  GLU A 199     -22.111  96.582   5.739  1.00 50.14           C  
ATOM   1427  C   GLU A 199     -21.148  95.657   6.476  1.00 49.41           C  
ATOM   1428  O   GLU A 199     -21.541  94.638   7.084  1.00 49.52           O  
ATOM   1429  CB  GLU A 199     -21.815  96.512   4.245  1.00 49.96           C  
ATOM   1430  CG  GLU A 199     -22.070  95.164   3.539  1.00 51.28           C  
ATOM   1431  CD  GLU A 199     -21.931  95.299   1.990  1.00 52.25           C  
ATOM   1432  OE1 GLU A 199     -20.898  95.870   1.492  1.00 48.50           O  
ATOM   1433  OE2 GLU A 199     -22.873  94.844   1.280  1.00 54.75           O  
ATOM   1434  N   VAL A 200     -19.875  96.006   6.395  1.00 48.43           N  
ATOM   1435  CA  VAL A 200     -18.848  95.214   7.025  1.00 47.85           C  
ATOM   1436  C   VAL A 200     -19.125  95.125   8.524  1.00 47.54           C  
ATOM   1437  O   VAL A 200     -19.031  94.023   9.130  1.00 47.34           O  
ATOM   1438  CB  VAL A 200     -17.453  95.772   6.693  1.00 47.59           C  
ATOM   1439  CG1 VAL A 200     -16.403  95.230   7.667  1.00 47.68           C  
ATOM   1440  CG2 VAL A 200     -17.081  95.420   5.239  1.00 46.02           C  
ATOM   1441  N   THR A 201     -19.539  96.269   9.082  1.00 47.03           N  
ATOM   1442  CA  THR A 201     -19.806  96.411  10.526  1.00 47.26           C  
ATOM   1443  C   THR A 201     -21.025  95.616  10.938  1.00 47.31           C  
ATOM   1444  O   THR A 201     -21.007  94.936  11.969  1.00 47.24           O  
ATOM   1445  CB  THR A 201     -20.034  97.891  10.931  1.00 46.93           C  
ATOM   1446  OG1 THR A 201     -18.824  98.652  10.740  1.00 47.42           O  
ATOM   1447  CG2 THR A 201     -20.496  98.002  12.379  1.00 46.49           C  
ATOM   1448  N   ILE A 202     -22.084  95.703  10.126  1.00 47.73           N  
ATOM   1449  CA  ILE A 202     -23.338  95.001  10.424  1.00 47.38           C  
ATOM   1450  C   ILE A 202     -23.089  93.512  10.419  1.00 47.71           C  
ATOM   1451  O   ILE A 202     -23.619  92.789  11.237  1.00 47.29           O  
ATOM   1452  CB  ILE A 202     -24.485  95.466   9.489  1.00 47.51           C  
ATOM   1453  CG1 ILE A 202     -25.171  96.667  10.122  1.00 45.72           C  
ATOM   1454  CG2 ILE A 202     -25.499  94.325   9.144  1.00 46.40           C  
ATOM   1455  CD1 ILE A 202     -25.810  97.536   9.132  1.00 47.69           C  
ATOM   1456  N   GLU A 203     -22.238  93.062   9.511  1.00 48.52           N  
ATOM   1457  CA  GLU A 203     -21.941  91.645   9.421  1.00 49.67           C  
ATOM   1458  C   GLU A 203     -21.182  91.095  10.645  1.00 49.65           C  
ATOM   1459  O   GLU A 203     -21.454  89.979  11.141  1.00 49.78           O  
ATOM   1460  CB  GLU A 203     -21.166  91.384   8.155  1.00 49.65           C  
ATOM   1461  CG  GLU A 203     -21.215  89.983   7.721  1.00 52.70           C  
ATOM   1462  CD  GLU A 203     -20.523  89.866   6.434  1.00 58.21           C  
ATOM   1463  OE1 GLU A 203     -19.325  89.495   6.472  1.00 61.14           O  
ATOM   1464  OE2 GLU A 203     -21.134  90.241   5.403  1.00 60.20           O  
ATOM   1465  N   LEU A 204     -20.215  91.873  11.125  1.00 49.59           N  
ATOM   1466  CA  LEU A 204     -19.588  91.551  12.388  1.00 48.81           C  
ATOM   1467  C   LEU A 204     -20.598  91.653  13.539  1.00 47.96           C  
ATOM   1468  O   LEU A 204     -20.697  90.729  14.329  1.00 48.63           O  
ATOM   1469  CB  LEU A 204     -18.369  92.421  12.608  1.00 49.06           C  
ATOM   1470  CG  LEU A 204     -17.616  92.243  13.902  1.00 48.79           C  
ATOM   1471  CD1 LEU A 204     -16.991  90.848  13.880  1.00 49.42           C  
ATOM   1472  CD2 LEU A 204     -16.591  93.350  13.901  1.00 47.91           C  
ATOM   1473  N   ALA A 205     -21.366  92.739  13.615  1.00 47.27           N  
ATOM   1474  CA  ALA A 205     -22.423  92.862  14.636  1.00 47.01           C  
ATOM   1475  C   ALA A 205     -23.296  91.620  14.687  1.00 47.16           C  
ATOM   1476  O   ALA A 205     -23.600  91.134  15.737  1.00 48.26           O  
ATOM   1477  CB  ALA A 205     -23.282  94.112  14.393  1.00 46.69           C  
ATOM   1478  N   ARG A 206     -23.684  91.106  13.532  1.00 47.57           N  
ATOM   1479  CA  ARG A 206     -24.510  89.932  13.439  1.00 48.38           C  
ATOM   1480  C   ARG A 206     -23.846  88.621  13.848  1.00 48.21           C  
ATOM   1481  O   ARG A 206     -24.539  87.718  14.371  1.00 48.11           O  
ATOM   1482  CB  ARG A 206     -25.116  89.827  12.037  1.00 49.18           C  
ATOM   1483  CG  ARG A 206     -26.548  90.295  12.090  1.00 52.61           C  
ATOM   1484  CD  ARG A 206     -26.964  91.147  10.932  1.00 57.38           C  
ATOM   1485  NE  ARG A 206     -28.199  91.855  11.279  1.00 60.44           N  
ATOM   1486  CZ  ARG A 206     -28.947  92.522  10.404  1.00 62.33           C  
ATOM   1487  NH1 ARG A 206     -30.044  93.131  10.828  1.00 64.10           N  
ATOM   1488  NH2 ARG A 206     -28.597  92.591   9.111  1.00 60.28           N  
ATOM   1489  N   ASN A 207     -22.534  88.491  13.614  1.00 47.89           N  
ATOM   1490  CA  ASN A 207     -21.821  87.297  14.103  1.00 47.68           C  
ATOM   1491  C   ASN A 207     -21.866  87.207  15.651  1.00 47.47           C  
ATOM   1492  O   ASN A 207     -21.982  86.112  16.260  1.00 47.45           O  
ATOM   1493  CB  ASN A 207     -20.384  87.227  13.569  1.00 47.48           C  
ATOM   1494  CG  ASN A 207     -19.574  86.119  14.240  1.00 48.35           C  
ATOM   1495  OD1 ASN A 207     -19.475  84.995  13.737  1.00 50.43           O  
ATOM   1496  ND2 ASN A 207     -19.052  86.413  15.421  1.00 48.59           N  
ATOM   1497  N   LEU A 208     -21.793  88.383  16.267  1.00 46.70           N  
ATOM   1498  CA  LEU A 208     -21.770  88.522  17.719  1.00 45.55           C  
ATOM   1499  C   LEU A 208     -23.148  88.265  18.317  1.00 44.95           C  
ATOM   1500  O   LEU A 208     -23.264  87.802  19.455  1.00 45.50           O  
ATOM   1501  CB  LEU A 208     -21.287  89.935  18.100  1.00 44.98           C  
ATOM   1502  CG  LEU A 208     -19.884  90.458  17.702  1.00 44.10           C  
ATOM   1503  CD1 LEU A 208     -19.652  91.838  18.285  1.00 39.00           C  
ATOM   1504  CD2 LEU A 208     -18.759  89.492  18.097  1.00 43.91           C  
ATOM   1505  N   LEU A 209     -24.190  88.600  17.571  1.00 44.26           N  
ATOM   1506  CA  LEU A 209     -25.569  88.451  18.062  1.00 44.34           C  
ATOM   1507  C   LEU A 209     -25.996  86.987  18.171  1.00 44.09           C  
ATOM   1508  O   LEU A 209     -26.947  86.653  18.858  1.00 43.70           O  
ATOM   1509  CB  LEU A 209     -26.533  89.194  17.137  1.00 43.84           C  
ATOM   1510  CG  LEU A 209     -26.651  90.658  17.480  1.00 42.83           C  
ATOM   1511  CD1 LEU A 209     -27.505  91.329  16.415  1.00 43.16           C  
ATOM   1512  CD2 LEU A 209     -27.265  90.757  18.871  1.00 39.75           C  
ATOM   1513  N   GLU A 210     -25.273  86.150  17.438  1.00 44.83           N  
ATOM   1514  CA  GLU A 210     -25.395  84.717  17.438  1.00 45.65           C  
ATOM   1515  C   GLU A 210     -24.776  84.086  18.687  1.00 46.18           C  
ATOM   1516  O   GLU A 210     -25.053  82.923  18.991  1.00 46.57           O  
ATOM   1517  CB  GLU A 210     -24.725  84.175  16.178  1.00 45.50           C  
ATOM   1518  CG  GLU A 210     -25.532  84.492  14.972  1.00 48.75           C  
ATOM   1519  CD  GLU A 210     -24.864  84.056  13.690  1.00 54.58           C  
ATOM   1520  OE1 GLU A 210     -23.931  83.211  13.768  1.00 56.14           O  
ATOM   1521  OE2 GLU A 210     -25.267  84.571  12.606  1.00 54.13           O  
ATOM   1522  N   LYS A 211     -23.951  84.846  19.422  1.00 46.07           N  
ATOM   1523  CA  LYS A 211     -23.382  84.328  20.668  1.00 45.70           C  
ATOM   1524  C   LYS A 211     -24.369  84.483  21.848  1.00 46.21           C  
ATOM   1525  O   LYS A 211     -25.172  85.427  21.871  1.00 46.55           O  
ATOM   1526  CB  LYS A 211     -22.012  84.962  20.974  1.00 44.51           C  
ATOM   1527  CG  LYS A 211     -21.027  85.131  19.763  1.00 43.36           C  
ATOM   1528  CD  LYS A 211     -20.640  83.826  18.991  1.00 41.15           C  
ATOM   1529  CE  LYS A 211     -19.687  84.110  17.810  1.00 40.96           C  
ATOM   1530  NZ  LYS A 211     -19.581  82.936  16.879  1.00 43.14           N  
ATOM   1531  N   ASN A 212     -24.337  83.534  22.789  1.00 45.70           N  
ATOM   1532  CA  ASN A 212     -24.995  83.719  24.065  1.00 46.27           C  
ATOM   1533  C   ASN A 212     -24.408  84.994  24.746  1.00 46.69           C  
ATOM   1534  O   ASN A 212     -23.192  85.059  25.015  1.00 46.13           O  
ATOM   1535  CB  ASN A 212     -24.809  82.451  24.907  1.00 45.73           C  
ATOM   1536  CG  ASN A 212     -25.680  82.428  26.192  1.00 46.89           C  
ATOM   1537  OD1 ASN A 212     -25.951  83.462  26.819  1.00 48.27           O  
ATOM   1538  ND2 ASN A 212     -26.065  81.210  26.613  1.00 42.47           N  
ATOM   1539  N   PRO A 213     -25.261  86.021  24.999  1.00 47.21           N  
ATOM   1540  CA  PRO A 213     -24.758  87.298  25.559  1.00 47.02           C  
ATOM   1541  C   PRO A 213     -23.907  87.129  26.831  1.00 47.36           C  
ATOM   1542  O   PRO A 213     -22.789  87.671  26.893  1.00 48.12           O  
ATOM   1543  CB  PRO A 213     -26.035  88.112  25.864  1.00 47.78           C  
ATOM   1544  CG  PRO A 213     -27.154  87.447  25.136  1.00 46.91           C  
ATOM   1545  CD  PRO A 213     -26.724  86.033  24.760  1.00 47.11           C  
ATOM   1546  N   VAL A 214     -24.410  86.385  27.825  1.00 46.47           N  
ATOM   1547  CA  VAL A 214     -23.704  86.234  29.117  1.00 45.78           C  
ATOM   1548  C   VAL A 214     -22.300  85.615  28.987  1.00 45.30           C  
ATOM   1549  O   VAL A 214     -21.377  85.982  29.705  1.00 45.31           O  
ATOM   1550  CB  VAL A 214     -24.546  85.417  30.124  1.00 45.61           C  
ATOM   1551  CG1 VAL A 214     -23.764  85.162  31.409  1.00 45.78           C  
ATOM   1552  CG2 VAL A 214     -25.879  86.127  30.402  1.00 44.15           C  
ATOM   1553  N   VAL A 215     -22.192  84.657  28.069  1.00 45.25           N  
ATOM   1554  CA  VAL A 215     -20.969  83.961  27.666  1.00 44.68           C  
ATOM   1555  C   VAL A 215     -20.022  84.907  26.925  1.00 45.00           C  
ATOM   1556  O   VAL A 215     -18.811  84.765  27.054  1.00 46.10           O  
ATOM   1557  CB  VAL A 215     -21.342  82.724  26.773  1.00 44.49           C  
ATOM   1558  CG1 VAL A 215     -20.119  81.998  26.219  1.00 43.48           C  
ATOM   1559  CG2 VAL A 215     -22.176  81.764  27.567  1.00 43.95           C  
ATOM   1560  N   LEU A 216     -20.574  85.867  26.174  1.00 44.45           N  
ATOM   1561  CA  LEU A 216     -19.788  86.801  25.391  1.00 44.61           C  
ATOM   1562  C   LEU A 216     -19.178  87.842  26.340  1.00 45.53           C  
ATOM   1563  O   LEU A 216     -18.008  88.241  26.202  1.00 45.19           O  
ATOM   1564  CB  LEU A 216     -20.663  87.519  24.341  1.00 44.34           C  
ATOM   1565  CG  LEU A 216     -20.138  87.885  22.935  1.00 42.91           C  
ATOM   1566  CD1 LEU A 216     -20.968  88.971  22.315  1.00 40.55           C  
ATOM   1567  CD2 LEU A 216     -18.681  88.234  22.893  1.00 40.34           C  
ATOM   1568  N   ARG A 217     -19.997  88.282  27.293  1.00 45.99           N  
ATOM   1569  CA  ARG A 217     -19.581  89.217  28.329  1.00 45.95           C  
ATOM   1570  C   ARG A 217     -18.446  88.617  29.180  1.00 44.96           C  
ATOM   1571  O   ARG A 217     -17.477  89.272  29.452  1.00 45.03           O  
ATOM   1572  CB  ARG A 217     -20.807  89.543  29.191  1.00 46.13           C  
ATOM   1573  CG  ARG A 217     -20.669  90.758  30.078  1.00 49.50           C  
ATOM   1574  CD  ARG A 217     -21.740  90.774  31.174  1.00 51.76           C  
ATOM   1575  NE  ARG A 217     -23.060  90.638  30.562  1.00 55.59           N  
ATOM   1576  CZ  ARG A 217     -24.109  90.071  31.150  1.00 54.89           C  
ATOM   1577  NH1 ARG A 217     -23.987  89.581  32.365  1.00 53.46           N  
ATOM   1578  NH2 ARG A 217     -25.268  89.966  30.495  1.00 54.39           N  
ATOM   1579  N   ALA A 218     -18.560  87.361  29.575  1.00 44.04           N  
ATOM   1580  CA  ALA A 218     -17.509  86.694  30.356  1.00 42.66           C  
ATOM   1581  C   ALA A 218     -16.171  86.660  29.616  1.00 41.21           C  
ATOM   1582  O   ALA A 218     -15.085  86.793  30.210  1.00 39.75           O  
ATOM   1583  CB  ALA A 218     -17.951  85.238  30.677  1.00 43.30           C  
ATOM   1584  N   ALA A 219     -16.268  86.410  28.315  1.00 40.43           N  
ATOM   1585  CA  ALA A 219     -15.084  86.189  27.502  1.00 40.35           C  
ATOM   1586  C   ALA A 219     -14.325  87.528  27.234  1.00 40.38           C  
ATOM   1587  O   ALA A 219     -13.111  87.596  27.447  1.00 40.40           O  
ATOM   1588  CB  ALA A 219     -15.449  85.413  26.174  1.00 39.35           C  
ATOM   1589  N   LYS A 220     -15.059  88.574  26.855  1.00 39.57           N  
ATOM   1590  CA  LYS A 220     -14.480  89.893  26.551  1.00 40.61           C  
ATOM   1591  C   LYS A 220     -14.024  90.691  27.777  1.00 41.44           C  
ATOM   1592  O   LYS A 220     -13.008  91.344  27.746  1.00 42.86           O  
ATOM   1593  CB  LYS A 220     -15.445  90.717  25.683  1.00 39.84           C  
ATOM   1594  CG  LYS A 220     -16.697  91.229  26.384  1.00 40.37           C  
ATOM   1595  CD  LYS A 220     -17.841  91.480  25.392  1.00 40.59           C  
ATOM   1596  CE  LYS A 220     -18.968  92.294  26.006  1.00 43.65           C  
ATOM   1597  NZ  LYS A 220     -18.472  93.666  26.431  1.00 44.23           N  
ATOM   1598  N   HIS A 221     -14.779  90.632  28.870  1.00 42.70           N  
ATOM   1599  CA  HIS A 221     -14.364  91.201  30.154  1.00 40.92           C  
ATOM   1600  C   HIS A 221     -13.198  90.444  30.715  1.00 40.62           C  
ATOM   1601  O   HIS A 221     -12.270  91.047  31.246  1.00 41.63           O  
ATOM   1602  CB  HIS A 221     -15.508  91.093  31.150  1.00 41.06           C  
ATOM   1603  CG  HIS A 221     -16.656  91.972  30.809  1.00 38.18           C  
ATOM   1604  ND1 HIS A 221     -17.714  92.173  31.658  1.00 39.33           N  
ATOM   1605  CD2 HIS A 221     -16.918  92.695  29.697  1.00 38.59           C  
ATOM   1606  CE1 HIS A 221     -18.567  93.016  31.103  1.00 42.98           C  
ATOM   1607  NE2 HIS A 221     -18.113  93.337  29.902  1.00 41.47           N  
ATOM   1608  N   GLY A 222     -13.250  89.124  30.626  1.00 39.95           N  
ATOM   1609  CA  GLY A 222     -12.131  88.316  31.090  1.00 38.83           C  
ATOM   1610  C   GLY A 222     -10.857  88.588  30.315  1.00 38.22           C  
ATOM   1611  O   GLY A 222      -9.785  88.644  30.887  1.00 37.97           O  
ATOM   1612  N   PHE A 223     -10.956  88.784  29.007  1.00 38.85           N  
ATOM   1613  CA  PHE A 223      -9.764  89.080  28.256  1.00 38.98           C  
ATOM   1614  C   PHE A 223      -9.132  90.426  28.634  1.00 39.87           C  
ATOM   1615  O   PHE A 223      -7.912  90.485  28.791  1.00 41.72           O  
ATOM   1616  CB  PHE A 223      -9.951  88.991  26.742  1.00 39.02           C  
ATOM   1617  CG  PHE A 223      -8.729  89.439  25.997  1.00 39.16           C  
ATOM   1618  CD1 PHE A 223      -8.561  90.798  25.639  1.00 40.58           C  
ATOM   1619  CD2 PHE A 223      -7.696  88.560  25.748  1.00 39.67           C  
ATOM   1620  CE1 PHE A 223      -7.406  91.252  25.025  1.00 36.55           C  
ATOM   1621  CE2 PHE A 223      -6.540  89.019  25.127  1.00 38.48           C  
ATOM   1622  CZ  PHE A 223      -6.407  90.389  24.781  1.00 37.30           C  
ATOM   1623  N   LYS A 224      -9.921  91.501  28.757  1.00 39.17           N  
ATOM   1624  CA  LYS A 224      -9.381  92.816  29.025  1.00 38.23           C  
ATOM   1625  C   LYS A 224      -8.748  92.836  30.405  1.00 39.16           C  
ATOM   1626  O   LYS A 224      -7.710  93.520  30.615  1.00 37.96           O  
ATOM   1627  CB  LYS A 224     -10.488  93.863  29.016  1.00 38.81           C  
ATOM   1628  CG  LYS A 224     -11.285  93.893  27.744  1.00 38.18           C  
ATOM   1629  CD  LYS A 224     -11.859  95.268  27.478  1.00 33.78           C  
ATOM   1630  CE  LYS A 224     -12.847  95.242  26.351  1.00 36.79           C  
ATOM   1631  NZ  LYS A 224     -13.479  96.610  26.041  1.00 34.47           N  
ATOM   1632  N   ARG A 225      -9.378  92.102  31.357  1.00 38.25           N  
ATOM   1633  CA  ARG A 225      -8.899  92.048  32.739  1.00 36.76           C  
ATOM   1634  C   ARG A 225      -7.675  91.202  32.856  1.00 35.78           C  
ATOM   1635  O   ARG A 225      -6.813  91.524  33.626  1.00 36.72           O  
ATOM   1636  CB  ARG A 225      -9.973  91.556  33.718  1.00 36.83           C  
ATOM   1637  CG  ARG A 225      -9.494  91.513  35.186  1.00 39.16           C  
ATOM   1638  CD  ARG A 225      -9.522  92.890  35.794  1.00 41.58           C  
ATOM   1639  NE  ARG A 225     -10.870  93.478  35.764  1.00 43.89           N  
ATOM   1640  CZ  ARG A 225     -11.100  94.787  35.745  1.00 43.52           C  
ATOM   1641  NH1 ARG A 225     -12.350  95.218  35.732  1.00 37.55           N  
ATOM   1642  NH2 ARG A 225     -10.069  95.661  35.725  1.00 41.19           N  
ATOM   1643  N   CYS A 226      -7.578  90.115  32.108  1.00 34.93           N  
ATOM   1644  CA  CYS A 226      -6.417  89.224  32.255  1.00 35.38           C  
ATOM   1645  C   CYS A 226      -5.040  89.835  31.887  1.00 35.76           C  
ATOM   1646  O   CYS A 226      -3.964  89.386  32.403  1.00 35.88           O  
ATOM   1647  CB  CYS A 226      -6.657  87.894  31.527  1.00 35.66           C  
ATOM   1648  SG  CYS A 226      -6.257  87.845  29.765  1.00 35.58           S  
ATOM   1649  N   ARG A 227      -5.089  90.831  31.001  1.00 35.56           N  
ATOM   1650  CA  ARG A 227      -3.953  91.671  30.627  1.00 35.12           C  
ATOM   1651  C   ARG A 227      -3.338  92.340  31.885  1.00 36.01           C  
ATOM   1652  O   ARG A 227      -2.145  92.626  31.963  1.00 36.61           O  
ATOM   1653  CB  ARG A 227      -4.466  92.739  29.660  1.00 35.07           C  
ATOM   1654  CG  ARG A 227      -5.170  92.187  28.380  1.00 33.18           C  
ATOM   1655  CD  ARG A 227      -5.129  93.244  27.206  1.00 35.20           C  
ATOM   1656  NE  ARG A 227      -3.746  93.662  26.947  1.00 34.38           N  
ATOM   1657  CZ  ARG A 227      -3.387  94.713  26.195  1.00 38.00           C  
ATOM   1658  NH1 ARG A 227      -4.292  95.450  25.591  1.00 33.18           N  
ATOM   1659  NH2 ARG A 227      -2.090  95.019  26.022  1.00 32.39           N  
ATOM   1660  N   GLU A 228      -4.138  92.544  32.921  1.00 36.78           N  
ATOM   1661  CA  GLU A 228      -3.639  93.203  34.139  1.00 35.49           C  
ATOM   1662  C   GLU A 228      -3.066  92.213  35.189  1.00 35.93           C  
ATOM   1663  O   GLU A 228      -2.445  92.609  36.205  1.00 34.94           O  
ATOM   1664  CB  GLU A 228      -4.779  94.022  34.679  1.00 35.69           C  
ATOM   1665  CG  GLU A 228      -5.465  94.988  33.632  1.00 34.88           C  
ATOM   1666  CD  GLU A 228      -6.700  95.693  34.223  1.00 36.31           C  
ATOM   1667  OE1 GLU A 228      -7.177  95.263  35.286  1.00 39.72           O  
ATOM   1668  OE2 GLU A 228      -7.193  96.693  33.678  1.00 36.80           O  
ATOM   1669  N   LEU A 229      -3.302  90.912  34.971  1.00 35.86           N  
ATOM   1670  CA  LEU A 229      -3.059  89.903  36.005  1.00 35.16           C  
ATOM   1671  C   LEU A 229      -1.973  89.004  35.587  1.00 34.22           C  
ATOM   1672  O   LEU A 229      -1.844  88.750  34.410  1.00 35.58           O  
ATOM   1673  CB  LEU A 229      -4.345  89.089  36.267  1.00 36.35           C  
ATOM   1674  CG  LEU A 229      -5.319  89.585  37.362  1.00 38.38           C  
ATOM   1675  CD1 LEU A 229      -5.373  91.072  37.510  1.00 37.39           C  
ATOM   1676  CD2 LEU A 229      -6.726  89.049  37.175  1.00 36.56           C  
ATOM   1677  N   THR A 230      -1.205  88.476  36.535  1.00 34.06           N  
ATOM   1678  CA  THR A 230      -0.215  87.423  36.257  1.00 32.69           C  
ATOM   1679  C   THR A 230      -0.942  86.115  35.837  1.00 34.23           C  
ATOM   1680  O   THR A 230      -2.191  86.044  35.901  1.00 34.13           O  
ATOM   1681  CB  THR A 230       0.657  87.125  37.486  1.00 31.17           C  
ATOM   1682  OG1 THR A 230      -0.181  86.527  38.506  1.00 32.21           O  
ATOM   1683  CG2 THR A 230       1.288  88.391  38.018  1.00 30.16           C  
ATOM   1684  N   TRP A 231      -0.162  85.109  35.405  1.00 33.26           N  
ATOM   1685  CA  TRP A 231      -0.694  83.798  35.048  1.00 34.71           C  
ATOM   1686  C   TRP A 231      -1.360  83.111  36.261  1.00 35.63           C  
ATOM   1687  O   TRP A 231      -2.478  82.577  36.176  1.00 36.69           O  
ATOM   1688  CB  TRP A 231       0.417  82.900  34.442  1.00 33.29           C  
ATOM   1689  CG  TRP A 231       0.699  83.215  32.974  1.00 35.36           C  
ATOM   1690  CD1 TRP A 231       1.165  84.398  32.452  1.00 32.03           C  
ATOM   1691  CD2 TRP A 231       0.487  82.338  31.836  1.00 33.98           C  
ATOM   1692  NE1 TRP A 231       1.265  84.321  31.102  1.00 30.37           N  
ATOM   1693  CE2 TRP A 231       0.866  83.073  30.680  1.00 35.14           C  
ATOM   1694  CE3 TRP A 231       0.040  81.011  31.695  1.00 30.76           C  
ATOM   1695  CZ2 TRP A 231       0.820  82.514  29.373  1.00 33.37           C  
ATOM   1696  CZ3 TRP A 231      -0.004  80.436  30.391  1.00 33.81           C  
ATOM   1697  CH2 TRP A 231       0.366  81.204  29.249  1.00 34.96           C  
ATOM   1698  N   GLU A 232      -0.676  83.134  37.398  1.00 36.37           N  
ATOM   1699  CA  GLU A 232      -1.249  82.604  38.603  1.00 36.93           C  
ATOM   1700  C   GLU A 232      -2.521  83.306  39.054  1.00 36.09           C  
ATOM   1701  O   GLU A 232      -3.424  82.631  39.574  1.00 37.31           O  
ATOM   1702  CB  GLU A 232      -0.219  82.668  39.723  1.00 37.34           C  
ATOM   1703  CG  GLU A 232       1.044  81.867  39.352  1.00 46.02           C  
ATOM   1704  CD  GLU A 232       2.095  82.614  38.407  1.00 54.36           C  
ATOM   1705  OE1 GLU A 232       2.265  83.912  38.443  1.00 48.56           O  
ATOM   1706  OE2 GLU A 232       2.762  81.810  37.659  1.00 56.91           O  
ATOM   1707  N   GLN A 233      -2.567  84.642  38.968  1.00 34.42           N  
ATOM   1708  CA  GLN A 233      -3.786  85.388  39.341  1.00 33.14           C  
ATOM   1709  C   GLN A 233      -4.895  85.025  38.404  1.00 32.34           C  
ATOM   1710  O   GLN A 233      -6.060  84.851  38.816  1.00 31.47           O  
ATOM   1711  CB  GLN A 233      -3.582  86.919  39.352  1.00 32.04           C  
ATOM   1712  CG  GLN A 233      -2.673  87.364  40.523  1.00 31.33           C  
ATOM   1713  CD  GLN A 233      -2.287  88.878  40.429  1.00 34.22           C  
ATOM   1714  OE1 GLN A 233      -2.163  89.585  41.442  1.00 35.54           O  
ATOM   1715  NE2 GLN A 233      -2.089  89.339  39.239  1.00 34.89           N  
ATOM   1716  N   ASN A 234      -4.513  84.864  37.146  1.00 32.26           N  
ATOM   1717  CA  ASN A 234      -5.476  84.512  36.099  1.00 34.16           C  
ATOM   1718  C   ASN A 234      -6.072  83.071  36.191  1.00 34.02           C  
ATOM   1719  O   ASN A 234      -7.178  82.849  35.777  1.00 35.04           O  
ATOM   1720  CB  ASN A 234      -4.912  84.827  34.709  1.00 33.37           C  
ATOM   1721  CG  ASN A 234      -5.167  86.253  34.293  1.00 33.95           C  
ATOM   1722  OD1 ASN A 234      -6.276  86.787  34.478  1.00 36.21           O  
ATOM   1723  ND2 ASN A 234      -4.168  86.881  33.687  1.00 29.38           N  
ATOM   1724  N   GLU A 235      -5.369  82.127  36.786  1.00 34.86           N  
ATOM   1725  CA  GLU A 235      -5.921  80.812  36.932  1.00 36.23           C  
ATOM   1726  C   GLU A 235      -7.167  80.907  37.802  1.00 37.00           C  
ATOM   1727  O   GLU A 235      -8.191  80.312  37.493  1.00 37.27           O  
ATOM   1728  CB  GLU A 235      -4.919  79.857  37.608  1.00 37.41           C  
ATOM   1729  CG  GLU A 235      -5.428  78.385  37.555  1.00 34.10           C  
ATOM   1730  CD  GLU A 235      -4.619  77.435  38.405  1.00 37.23           C  
ATOM   1731  OE1 GLU A 235      -3.944  77.889  39.395  1.00 32.63           O  
ATOM   1732  OE2 GLU A 235      -4.693  76.203  38.077  1.00 38.40           O  
ATOM   1733  N   ASP A 236      -7.030  81.660  38.897  1.00 36.78           N  
ATOM   1734  CA  ASP A 236      -8.103  81.971  39.822  1.00 37.28           C  
ATOM   1735  C   ASP A 236      -9.190  82.813  39.127  1.00 36.46           C  
ATOM   1736  O   ASP A 236     -10.368  82.478  39.156  1.00 37.20           O  
ATOM   1737  CB  ASP A 236      -7.508  82.698  41.037  1.00 36.99           C  
ATOM   1738  CG  ASP A 236      -8.512  82.978  42.085  1.00 38.02           C  
ATOM   1739  OD1 ASP A 236      -9.692  82.662  41.823  1.00 38.05           O  
ATOM   1740  OD2 ASP A 236      -8.123  83.515  43.157  1.00 32.06           O  
ATOM   1741  N   TYR A 237      -8.781  83.891  38.477  1.00 36.01           N  
ATOM   1742  CA  TYR A 237      -9.710  84.870  37.984  1.00 33.48           C  
ATOM   1743  C   TYR A 237     -10.502  84.325  36.754  1.00 34.19           C  
ATOM   1744  O   TYR A 237     -11.736  84.524  36.673  1.00 33.41           O  
ATOM   1745  CB  TYR A 237      -8.940  86.146  37.617  1.00 33.57           C  
ATOM   1746  CG  TYR A 237      -9.804  87.029  36.752  1.00 33.18           C  
ATOM   1747  CD1 TYR A 237      -9.721  87.019  35.366  1.00 34.08           C  
ATOM   1748  CD2 TYR A 237     -10.786  87.811  37.334  1.00 36.78           C  
ATOM   1749  CE1 TYR A 237     -10.566  87.829  34.590  1.00 32.77           C  
ATOM   1750  CE2 TYR A 237     -11.632  88.602  36.574  1.00 37.39           C  
ATOM   1751  CZ  TYR A 237     -11.530  88.607  35.219  1.00 33.74           C  
ATOM   1752  OH  TYR A 237     -12.433  89.439  34.564  1.00 32.50           O  
ATOM   1753  N   LEU A 238      -9.801  83.697  35.776  1.00 32.77           N  
ATOM   1754  CA  LEU A 238     -10.491  83.170  34.553  1.00 33.38           C  
ATOM   1755  C   LEU A 238     -11.417  81.977  34.808  1.00 33.87           C  
ATOM   1756  O   LEU A 238     -12.401  81.827  34.135  1.00 33.61           O  
ATOM   1757  CB  LEU A 238      -9.501  82.815  33.451  1.00 31.42           C  
ATOM   1758  CG  LEU A 238      -8.673  84.015  32.973  1.00 33.71           C  
ATOM   1759  CD1 LEU A 238      -7.311  83.643  32.234  1.00 31.68           C  
ATOM   1760  CD2 LEU A 238      -9.583  84.990  32.176  1.00 29.49           C  
ATOM   1761  N   TYR A 239     -11.082  81.135  35.789  1.00 35.35           N  
ATOM   1762  CA  TYR A 239     -11.930  80.004  36.151  1.00 35.10           C  
ATOM   1763  C   TYR A 239     -13.114  80.528  36.901  1.00 35.15           C  
ATOM   1764  O   TYR A 239     -14.182  80.005  36.721  1.00 36.04           O  
ATOM   1765  CB  TYR A 239     -11.183  78.939  36.953  1.00 34.71           C  
ATOM   1766  CG  TYR A 239     -10.579  77.824  36.114  1.00 34.96           C  
ATOM   1767  CD1 TYR A 239      -9.214  77.531  36.199  1.00 36.10           C  
ATOM   1768  CD2 TYR A 239     -11.362  77.046  35.255  1.00 35.02           C  
ATOM   1769  CE1 TYR A 239      -8.648  76.473  35.471  1.00 35.99           C  
ATOM   1770  CE2 TYR A 239     -10.801  75.980  34.488  1.00 34.31           C  
ATOM   1771  CZ  TYR A 239      -9.437  75.700  34.606  1.00 35.50           C  
ATOM   1772  OH  TYR A 239      -8.825  74.662  33.883  1.00 32.53           O  
ATOM   1773  N   ALA A 240     -12.948  81.598  37.686  1.00 35.93           N  
ATOM   1774  CA  ALA A 240     -14.098  82.256  38.322  1.00 36.55           C  
ATOM   1775  C   ALA A 240     -14.993  82.870  37.249  1.00 37.01           C  
ATOM   1776  O   ALA A 240     -16.219  82.788  37.332  1.00 38.47           O  
ATOM   1777  CB  ALA A 240     -13.681  83.306  39.398  1.00 36.01           C  
ATOM   1778  N   LYS A 241     -14.412  83.458  36.219  1.00 36.81           N  
ATOM   1779  CA  LYS A 241     -15.277  84.133  35.247  1.00 37.12           C  
ATOM   1780  C   LYS A 241     -16.108  83.093  34.527  1.00 37.16           C  
ATOM   1781  O   LYS A 241     -17.255  83.350  34.204  1.00 39.05           O  
ATOM   1782  CB  LYS A 241     -14.477  84.993  34.239  1.00 35.83           C  
ATOM   1783  CG  LYS A 241     -14.004  86.324  34.748  1.00 34.10           C  
ATOM   1784  CD  LYS A 241     -15.113  87.154  35.424  1.00 34.98           C  
ATOM   1785  CE  LYS A 241     -15.801  88.098  34.463  1.00 30.62           C  
ATOM   1786  NZ  LYS A 241     -16.761  89.019  35.118  1.00 30.15           N  
ATOM   1787  N   LEU A 242     -15.498  81.938  34.248  1.00 37.01           N  
ATOM   1788  CA  LEU A 242     -16.080  80.828  33.478  1.00 36.74           C  
ATOM   1789  C   LEU A 242     -17.247  80.263  34.242  1.00 37.02           C  
ATOM   1790  O   LEU A 242     -18.263  79.942  33.623  1.00 37.70           O  
ATOM   1791  CB  LEU A 242     -15.026  79.709  33.303  1.00 37.45           C  
ATOM   1792  CG  LEU A 242     -15.080  78.322  32.608  1.00 36.33           C  
ATOM   1793  CD1 LEU A 242     -15.836  77.263  33.317  1.00 37.89           C  
ATOM   1794  CD2 LEU A 242     -15.621  78.438  31.268  1.00 40.04           C  
ATOM   1795  N   ASP A 243     -17.081  80.130  35.565  1.00 36.09           N  
ATOM   1796  CA  ASP A 243     -18.065  79.509  36.483  1.00 37.24           C  
ATOM   1797  C   ASP A 243     -19.235  80.444  36.781  1.00 38.54           C  
ATOM   1798  O   ASP A 243     -20.381  79.981  36.944  1.00 37.48           O  
ATOM   1799  CB  ASP A 243     -17.430  79.150  37.835  1.00 35.95           C  
ATOM   1800  CG  ASP A 243     -16.586  77.885  37.796  1.00 35.95           C  
ATOM   1801  OD1 ASP A 243     -16.663  77.079  36.829  1.00 37.04           O  
ATOM   1802  OD2 ASP A 243     -15.848  77.671  38.785  1.00 35.52           O  
ATOM   1803  N   GLN A 244     -18.924  81.748  36.925  1.00 38.72           N  
ATOM   1804  CA  GLN A 244     -19.927  82.819  36.897  1.00 39.70           C  
ATOM   1805  C   GLN A 244     -20.775  82.775  35.591  1.00 40.84           C  
ATOM   1806  O   GLN A 244     -22.007  82.929  35.613  1.00 41.27           O  
ATOM   1807  CB  GLN A 244     -19.201  84.182  37.073  1.00 40.60           C  
ATOM   1808  CG  GLN A 244     -20.062  85.459  36.972  1.00 39.87           C  
ATOM   1809  CD  GLN A 244     -19.243  86.759  37.107  1.00 39.10           C  
ATOM   1810  OE1 GLN A 244     -19.437  87.519  38.058  1.00 37.54           O  
ATOM   1811  NE2 GLN A 244     -18.349  87.018  36.140  1.00 35.18           N  
ATOM   1812  N   SER A 245     -20.120  82.553  34.457  1.00 41.64           N  
ATOM   1813  CA  SER A 245     -20.803  82.406  33.198  1.00 43.24           C  
ATOM   1814  C   SER A 245     -21.835  81.251  33.228  1.00 45.46           C  
ATOM   1815  O   SER A 245     -23.018  81.432  32.908  1.00 45.80           O  
ATOM   1816  CB  SER A 245     -19.798  82.109  32.111  1.00 42.87           C  
ATOM   1817  OG  SER A 245     -20.418  82.208  30.849  1.00 39.95           O  
ATOM   1818  N   ARG A 246     -21.366  80.070  33.610  1.00 47.27           N  
ATOM   1819  CA  ARG A 246     -22.172  78.859  33.640  1.00 48.58           C  
ATOM   1820  C   ARG A 246     -23.384  78.999  34.568  1.00 49.86           C  
ATOM   1821  O   ARG A 246     -24.314  78.239  34.444  1.00 50.65           O  
ATOM   1822  CB  ARG A 246     -21.290  77.657  34.018  1.00 48.57           C  
ATOM   1823  N   LEU A 247     -23.374  79.980  35.471  1.00 51.76           N  
ATOM   1824  CA  LEU A 247     -24.471  80.228  36.427  1.00 53.14           C  
ATOM   1825  C   LEU A 247     -25.508  81.220  35.888  1.00 54.79           C  
ATOM   1826  O   LEU A 247     -26.707  81.024  36.018  1.00 55.16           O  
ATOM   1827  CB  LEU A 247     -23.914  80.754  37.762  1.00 52.36           C  
ATOM   1828  CG  LEU A 247     -24.935  81.286  38.800  1.00 52.63           C  
ATOM   1829  CD1 LEU A 247     -25.537  80.165  39.665  1.00 51.23           C  
ATOM   1830  CD2 LEU A 247     -24.385  82.397  39.690  1.00 52.60           C  
ATOM   1831  N   LEU A 248     -25.018  82.304  35.308  1.00 57.33           N  
ATOM   1832  CA  LEU A 248     -25.848  83.376  34.779  1.00 59.41           C  
ATOM   1833  C   LEU A 248     -26.357  82.962  33.407  1.00 61.01           C  
ATOM   1834  O   LEU A 248     -27.303  83.554  32.888  1.00 61.74           O  
ATOM   1835  CB  LEU A 248     -25.042  84.691  34.774  1.00 59.58           C  
ATOM   1836  CG  LEU A 248     -24.431  85.002  36.154  1.00 59.37           C  
ATOM   1837  CD1 LEU A 248     -23.503  86.183  36.091  1.00 61.45           C  
ATOM   1838  CD2 LEU A 248     -25.532  85.220  37.217  1.00 60.45           C  
ATOM   1839  N   ASP A 249     -25.660  81.975  32.830  1.00 62.81           N  
ATOM   1840  CA  ASP A 249     -26.179  80.863  31.974  1.00 64.71           C  
ATOM   1841  C   ASP A 249     -26.304  81.072  30.495  1.00 65.38           C  
ATOM   1842  O   ASP A 249     -25.412  80.523  29.849  1.00 66.42           O  
ATOM   1843  CB  ASP A 249     -27.333  79.985  32.604  1.00 65.15           C  
ATOM   1844  CG  ASP A 249     -28.740  80.254  32.013  1.00 66.92           C  
ATOM   1845  OD1 ASP A 249     -29.345  79.335  31.401  1.00 67.21           O  
ATOM   1846  OD2 ASP A 249     -29.265  81.372  32.191  1.00 68.40           O  
ATOM   1847  N   THR A 250     -27.212  81.715  29.947  1.00 65.85           N  
TER    1848      THR A 250                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
