
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  226 ( 1886),  selected  226 , name 1ve3_B
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 1ve3_B.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_B      M       1           -
LGA    -       -      S       2           -
LGA    -       -      E       3           -
LGA    -       -      N       4           -
LGA    -       -      K       5           -
LGA    -       -      K       6           -
LGA    F     3_B      K       7          1.102
LGA    -       -      F       8           -
LGA    K     4_B      D       9          3.962
LGA    E     5_B      K      10           -
LGA    Y     6_B      -       -           -
LGA    Y     7_B      K      11           #
LGA    R     8_B      G      12          3.357
LGA    -       -      A      13           -
LGA    -       -      K      14           -
LGA    V     9_B      N      15          4.410
LGA    F    10_B      -       -           -
LGA    P    11_B      -       -           -
LGA    T    12_B      -       -           -
LGA    Y    13_B      M      16          3.724
LGA    T    14_B      D      17          2.031
LGA    D    15_B      E      18          2.828
LGA    -       -      I      19           -
LGA    I    16_B      S      20          3.320
LGA    N    17_B      K      21          1.996
LGA    S    18_B      T      22          0.895
LGA    Q    19_B      L      23          2.550
LGA    E    20_B      F      24          2.181
LGA    Y    21_B      -       -           -
LGA    R    22_B      A      25          1.576
LGA    S    23_B      P      26          3.423
LGA    R    24_B      I      27          2.716
LGA    I    25_B      Y      28          1.489
LGA    E    26_B      P      29          4.208
LGA    T    27_B      I      30          4.283
LGA    L    28_B      I      31          1.890
LGA    E    29_B      A      32          2.945
LGA    P    30_B      E      33          3.152
LGA    L    31_B      N      34          2.114
LGA    L    32_B      I      35          0.794
LGA    X    33_B      I      36          1.242
LGA    K    34_B      N      37          1.890
LGA    Y    35_B      R      38          2.648
LGA    X    36_B      F      39          3.404
LGA    K    37_B      G      40          1.342
LGA    K    38_B      I      41          2.414
LGA    R    39_B      T      42          2.229
LGA    G    40_B      A      43          2.867
LGA    -       -      G      44           -
LGA    K    41_B      N      45          0.473
LGA    V    42_B      C      46          0.376
LGA    L    43_B      I      47          0.491
LGA    D    44_B      D      48          0.480
LGA    L    45_B      I      49          0.822
LGA    A    46_B      G      50          0.849
LGA    C    47_B      S      51          0.632
LGA    G    48_B      G      52          0.642
LGA    V    49_B      P      53          0.924
LGA    G    50_B      G      54          0.796
LGA    G    51_B      A      55          0.702
LGA    F    52_B      L      56          0.899
LGA    S    53_B      S      57          0.794
LGA    F    54_B      I      58          1.085
LGA    L    55_B      A      59          1.431
LGA    L    56_B      L      60          1.619
LGA    E    57_B      A      61          1.455
LGA    D    58_B      K      62          1.540
LGA    Y    59_B      Q      63          2.520
LGA    G    60_B      S      64          2.925
LGA    -       -      D      65           -
LGA    F    61_B      F      66          0.802
LGA    E    62_B      S      67          0.682
LGA    V    63_B      I      68          0.287
LGA    V    64_B      R      69          0.433
LGA    G    65_B      A      70          0.531
LGA    V    66_B      L      71          0.657
LGA    D    67_B      D      72          0.129
LGA    I    68_B      F      73          0.306
LGA    S    69_B      S      74          0.402
LGA    E    70_B      K      75          0.523
LGA    D    71_B      H      76          0.677
LGA    X    72_B      M      77          0.336
LGA    I    73_B      N      78          0.398
LGA    R    74_B      E      79          0.272
LGA    K    75_B      I      80          0.338
LGA    A    76_B      A      81          0.398
LGA    R    77_B      L      82          0.357
LGA    E    78_B      K      83          0.332
LGA    Y    79_B      N      84          0.506
LGA    A    80_B      I      85          1.059
LGA    K    81_B      A      86          1.188
LGA    S    82_B      D      87          0.784
LGA    R    83_B      A      88          1.006
LGA    E    84_B      D      89          1.324
LGA    S    85_B      L      90          0.711
LGA    N    86_B      N      91          2.548
LGA    -       -      D      92           -
LGA    -       -      R      93           -
LGA    V    87_B      I      94          0.668
LGA    E    88_B      Q      95          0.281
LGA    F    89_B      I      96          0.272
LGA    I    90_B      V      97          1.332
LGA    V    91_B      Q      98          1.109
LGA    G    92_B      G      99          0.574
LGA    D    93_B      D     100          0.663
LGA    A    94_B      V     101          0.664
LGA    R    95_B      H     102          0.523
LGA    K    96_B      N     103          0.509
LGA    L    97_B      I     104          0.947
LGA    S    98_B      P     105          1.575
LGA    F    99_B      I     106          1.089
LGA    E   100_B      E     107          1.111
LGA    D   101_B      D     108          0.507
LGA    K   102_B      N     109          0.643
LGA    T   103_B      Y     110          0.954
LGA    F   104_B      A     111          0.950
LGA    D   105_B      D     112          0.654
LGA    Y   106_B      L     113          0.993
LGA    V   107_B      I     114          0.920
LGA    I   108_B      V     115          0.786
LGA    F   109_B      S     116          1.800
LGA    I   110_B      R     117          1.409
LGA    D   111_B      G     118          1.261
LGA    S   112_B      S     119          1.061
LGA    I   113_B      V     120          1.996
LGA    V   114_B      F     121          2.471
LGA    H   115_B      F     122          1.407
LGA    F   116_B      W     123          1.655
LGA    E   117_B      E     124          3.324
LGA    P   118_B      -       -           -
LGA    L   119_B      -       -           -
LGA    E   120_B      D     125          1.436
LGA    L   121_B      V     126          1.216
LGA    N   122_B      T     127          1.080
LGA    Q   123_B      T     128          1.013
LGA    V   124_B      A     129          0.977
LGA    F   125_B      F     130          0.410
LGA    K   126_B      R     131          0.425
LGA    E   127_B      E     132          0.511
LGA    V   128_B      I     133          0.710
LGA    R   129_B      Y     134          0.584
LGA    R   130_B      R     135          0.463
LGA    V   131_B      I     136          0.763
LGA    L   132_B      L     137          0.977
LGA    K   133_B      K     138          0.945
LGA    P   134_B      S     139          0.987
LGA    S   135_B      G     140          1.200
LGA    G   136_B      G     141          0.965
LGA    K   137_B      K     142          0.980
LGA    F   138_B      T     143          1.636
LGA    I   139_B      Y     144          1.443
LGA    X   140_B      I     145          1.016
LGA    Y   141_B      G     146          1.601
LGA    F   142_B      G     147          2.525
LGA    T   143_B      G     148          4.874
LGA    D   144_B      F     149           -
LGA    L   145_B      G     150           -
LGA    R   146_B      N     151           -
LGA    -       -      K     152           -
LGA    -       -      E     153           -
LGA    -       -      L     154           -
LGA    E   147_B      R     155           #
LGA    L   148_B      D     156           -
LGA    L   149_B      S     157           -
LGA    -       -      I     158           -
LGA    P   150_B      S     159          5.486
LGA    R   151_B      A     160          5.512
LGA    -       -      E     161           -
LGA    L   152_B      M     162          3.517
LGA    K   153_B      I     163          2.006
LGA    E   154_B      R     164          2.729
LGA    S   155_B      K     165          3.040
LGA    L   156_B      N     166          3.497
LGA    V   157_B      -       -           -
LGA    V   158_B      -       -           -
LGA    G   159_B      -       -           -
LGA    Q   160_B      -       -           -
LGA    K   161_B      -       -           -
LGA    Y   162_B      -       -           -
LGA    W   163_B      P     167          5.008
LGA    I   164_B      D     168          4.148
LGA    S   165_B      W     169           -
LGA    K   166_B      K     170           -
LGA    V   167_B      E     171           #
LGA    I   168_B      -       -           -
LGA    P   169_B      -       -           -
LGA    D   170_B      -       -           -
LGA    Q   171_B      -       -           -
LGA    E   172_B      -       -           -
LGA    E   173_B      -       -           -
LGA    R   174_B      -       -           -
LGA    T   175_B      -       -           -
LGA    V   176_B      -       -           -
LGA    V   177_B      -       -           -
LGA    I   178_B      -       -           -
LGA    E   179_B      -       -           -
LGA    F   180_B      -       -           -
LGA    K   181_B      -       -           -
LGA    S   182_B      -       -           -
LGA    E   183_B      -       -           -
LGA    Q   184_B      -       -           -
LGA    D   185_B      -       -           -
LGA    S   186_B      -       -           -
LGA    F   187_B      -       -           -
LGA    R   188_B      -       -           -
LGA    V   189_B      -       -           -
LGA    R   190_B      -       -           -
LGA    F   191_B      F     172           #
LGA    N   192_B      N     173           -
LGA    -       -      R     174           -
LGA    -       -      K     175           -
LGA    V   193_B      N     176           #
LGA    -       -      I     177           -
LGA    -       -      S     178           -
LGA    -       -      Q     179           -
LGA    W   194_B      E     180          5.518
LGA    G   195_B      N     181          2.045
LGA    K   196_B      V     182          1.262
LGA    T   197_B      E     183          0.531
LGA    G   198_B      R     184          0.692
LGA    V   199_B      F     185          1.073
LGA    E   200_B      Q     186          1.532
LGA    L   201_B      N     187          1.302
LGA    L   202_B      V     188          0.662
LGA    A   203_B      L     189          2.132
LGA    K   204_B      D     190          3.393
LGA    -       -      E     191           -
LGA    L   205_B      I     192          2.487
LGA    Y   206_B      G     193          4.480
LGA    F   207_B      V     194          2.885
LGA    T   208_B      S     195          3.793
LGA    K   209_B      S     196          4.132
LGA    E   210_B      Y     197          4.273
LGA    A   211_B      E     198          4.088
LGA    E   212_B      I     199          4.981
LGA    E   213_B      I     200          4.410
LGA    K   214_B      L     201          3.137
LGA    -       -      E     202           -
LGA    V   215_B      D     203          2.354
LGA    G   216_B      E     204          5.870
LGA    N   217_B      -       -           -
LGA    Y   218_B      -       -           -
LGA    S   219_B      G     205          3.791
LGA    Y   220_B      F     206          1.953
LGA    L   221_B      W     207          2.277
LGA    T   222_B      I     208          3.048
LGA    V   223_B      I     209          1.634
LGA    Y   224_B      I     210          1.059
LGA    N   225_B      S     211          0.917
LGA    P   226_B      K     212          2.445
LGA    K   227_B      T     213           #
LGA    -       -      D     214           -
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  226  218    5.0    172    2.20    13.95     62.906     7.488

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.735709 * X  +   0.410238 * Y  +  -0.538922 * Z  +  51.940628
  Y_new =  -0.513222 * X  +  -0.856894 * Y  +   0.048340 * Z  +  25.658503
  Z_new =  -0.441968 * X  +   0.312151 * Y  +   0.840968 * Z  + -98.281982 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.355418   -2.786175  [ DEG:    20.3639   -159.6361 ]
  Theta =   0.457791    2.683802  [ DEG:    26.2295    153.7705 ]
  Phi   =  -2.532487    0.609105  [ DEG:  -145.1008     34.8992 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ve3_B                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ve3_B.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  226  218   5.0  172   2.20   13.95  62.906
REMARK  ---------------------------------------------------------- 
MOLECULE 1ve3_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   26-MAR-04   1VE3              
TITLE     CRYSTAL STRUCTURE OF PH0226 PROTEIN FROM PYROCOCCUS                   
TITLE    2 HORIKOSHII OT3                                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PH0226;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: METHYL TRANSFERASE, SAM DEPENDENT                           
COMPND   5 METHYLTRANSFERASE;                                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    DIMER, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,               
KEYWDS   2 RSGI, STRUCTURAL GENOMICS, UNKNOWN FUNCTION, NPPSFA,                 
KEYWDS   3 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   4 ANALYSES                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.K.LOKANATH,H.YAMAMOTO,N.KUNISHIMA,RIKEN STRUCTURAL                  
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   13-MAY-08 1VE3    1       REMARK VERSN                             
REVDAT   1   24-MAY-05 1VE3    0                                                
JRNL        AUTH   N.K.LOKANATH,H.YAMAMOTO,N.KUNISHIMA                          
JRNL        TITL   CRYSTAL STRUCTURE OF PH0226 PROTEIN FROM                     
JRNL        TITL 2 PYROCOCCUS HORIKOSHII OT3                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  1VE3 A    1   227  UNP    O57965   O57965_PYRHO     1    227             
DBREF  1VE3 B    1   227  UNP    O57965   O57965_PYRHO     1    227             
SEQRES   1 A  227  MSE GLY PHE LYS GLU TYR TYR ARG VAL PHE PRO THR TYR          
SEQRES   2 A  227  THR ASP ILE ASN SER GLN GLU TYR ARG SER ARG ILE GLU          
SEQRES   3 A  227  THR LEU GLU PRO LEU LEU MSE LYS TYR MSE LYS LYS ARG          
SEQRES   4 A  227  GLY LYS VAL LEU ASP LEU ALA CYS GLY VAL GLY GLY PHE          
SEQRES   5 A  227  SER PHE LEU LEU GLU ASP TYR GLY PHE GLU VAL VAL GLY          
SEQRES   6 A  227  VAL ASP ILE SER GLU ASP MSE ILE ARG LYS ALA ARG GLU          
SEQRES   7 A  227  TYR ALA LYS SER ARG GLU SER ASN VAL GLU PHE ILE VAL          
SEQRES   8 A  227  GLY ASP ALA ARG LYS LEU SER PHE GLU ASP LYS THR PHE          
SEQRES   9 A  227  ASP TYR VAL ILE PHE ILE ASP SER ILE VAL HIS PHE GLU          
SEQRES  10 A  227  PRO LEU GLU LEU ASN GLN VAL PHE LYS GLU VAL ARG ARG          
SEQRES  11 A  227  VAL LEU LYS PRO SER GLY LYS PHE ILE MSE TYR PHE THR          
SEQRES  12 A  227  ASP LEU ARG GLU LEU LEU PRO ARG LEU LYS GLU SER LEU          
SEQRES  13 A  227  VAL VAL GLY GLN LYS TYR TRP ILE SER LYS VAL ILE PRO          
SEQRES  14 A  227  ASP GLN GLU GLU ARG THR VAL VAL ILE GLU PHE LYS SER          
SEQRES  15 A  227  GLU GLN ASP SER PHE ARG VAL ARG PHE ASN VAL TRP GLY          
SEQRES  16 A  227  LYS THR GLY VAL GLU LEU LEU ALA LYS LEU TYR PHE THR          
SEQRES  17 A  227  LYS GLU ALA GLU GLU LYS VAL GLY ASN TYR SER TYR LEU          
SEQRES  18 A  227  THR VAL TYR ASN PRO LYS                                      
SEQRES   1 B  227  MSE GLY PHE LYS GLU TYR TYR ARG VAL PHE PRO THR TYR          
SEQRES   2 B  227  THR ASP ILE ASN SER GLN GLU TYR ARG SER ARG ILE GLU          
SEQRES   3 B  227  THR LEU GLU PRO LEU LEU MSE LYS TYR MSE LYS LYS ARG          
SEQRES   4 B  227  GLY LYS VAL LEU ASP LEU ALA CYS GLY VAL GLY GLY PHE          
SEQRES   5 B  227  SER PHE LEU LEU GLU ASP TYR GLY PHE GLU VAL VAL GLY          
SEQRES   6 B  227  VAL ASP ILE SER GLU ASP MSE ILE ARG LYS ALA ARG GLU          
SEQRES   7 B  227  TYR ALA LYS SER ARG GLU SER ASN VAL GLU PHE ILE VAL          
SEQRES   8 B  227  GLY ASP ALA ARG LYS LEU SER PHE GLU ASP LYS THR PHE          
SEQRES   9 B  227  ASP TYR VAL ILE PHE ILE ASP SER ILE VAL HIS PHE GLU          
SEQRES  10 B  227  PRO LEU GLU LEU ASN GLN VAL PHE LYS GLU VAL ARG ARG          
SEQRES  11 B  227  VAL LEU LYS PRO SER GLY LYS PHE ILE MSE TYR PHE THR          
SEQRES  12 B  227  ASP LEU ARG GLU LEU LEU PRO ARG LEU LYS GLU SER LEU          
SEQRES  13 B  227  VAL VAL GLY GLN LYS TYR TRP ILE SER LYS VAL ILE PRO          
SEQRES  14 B  227  ASP GLN GLU GLU ARG THR VAL VAL ILE GLU PHE LYS SER          
SEQRES  15 B  227  GLU GLN ASP SER PHE ARG VAL ARG PHE ASN VAL TRP GLY          
SEQRES  16 B  227  LYS THR GLY VAL GLU LEU LEU ALA LYS LEU TYR PHE THR          
SEQRES  17 B  227  LYS GLU ALA GLU GLU LYS VAL GLY ASN TYR SER TYR LEU          
SEQRES  18 B  227  THR VAL TYR ASN PRO LYS                                      
HET    MSE  A  33       8                                                       
HET    MSE  A  36       8                                                       
HET    MSE  A  72       8                                                       
HET    MSE  A 140       8                                                       
HET    MSE  B  33       8                                                       
HET    MSE  B  36       8                                                       
HET    MSE  B  72       8                                                       
HET    MSE  B 140       8                                                       
HET    SAM  A 302      27                                                       
HET    SAM  B 301      27                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  SAM    2(C15 H22 N6 O5 S)                                           
FORMUL   5  HOH   *178(H2 O)                                                    
CRYST1   58.167   58.167  252.463  90.00  90.00 120.00 P 32 2 1     12          
ATOM   1771  N   GLY B   2       8.378  -1.004  23.667  1.00 42.61           N  
ATOM   1772  CA  GLY B   2       7.597  -0.151  24.609  1.00 41.07           C  
ATOM   1773  C   GLY B   2       6.522  -0.953  25.307  1.00 42.85           C  
ATOM   1774  O   GLY B   2       6.235  -2.085  24.917  1.00 43.95           O  
ATOM   1775  N   PHE B   3       5.931  -0.380  26.350  1.00 44.34           N  
ATOM   1776  CA  PHE B   3       4.887  -1.070  27.085  1.00 42.87           C  
ATOM   1777  C   PHE B   3       4.012  -0.136  27.928  1.00 42.22           C  
ATOM   1778  O   PHE B   3       4.216   1.083  27.938  1.00 35.20           O  
ATOM   1779  CB  PHE B   3       5.510  -2.184  27.942  1.00 45.52           C  
ATOM   1780  CG  PHE B   3       6.018  -1.741  29.283  1.00 46.71           C  
ATOM   1781  CD1 PHE B   3       6.496  -0.453  29.490  1.00 47.34           C  
ATOM   1782  CD2 PHE B   3       6.055  -2.651  30.341  1.00 49.48           C  
ATOM   1783  CE1 PHE B   3       7.001  -0.076  30.728  1.00 48.47           C  
ATOM   1784  CE2 PHE B   3       6.559  -2.288  31.585  1.00 49.82           C  
ATOM   1785  CZ  PHE B   3       7.034  -0.997  31.779  1.00 51.30           C  
ATOM   1786  N   LYS B   4       3.036  -0.732  28.615  1.00 40.47           N  
ATOM   1787  CA  LYS B   4       2.075  -0.002  29.434  1.00 42.23           C  
ATOM   1788  C   LYS B   4       2.631   1.104  30.322  1.00 40.89           C  
ATOM   1789  O   LYS B   4       2.298   2.271  30.138  1.00 40.66           O  
ATOM   1790  CB  LYS B   4       1.248  -0.975  30.297  1.00 44.65           C  
ATOM   1791  CG  LYS B   4       0.312  -0.276  31.293  1.00 48.57           C  
ATOM   1792  CD  LYS B   4      -0.556   0.767  30.599  1.00 49.59           C  
ATOM   1793  CE  LYS B   4      -1.326   1.631  31.600  1.00 49.60           C  
ATOM   1794  NZ  LYS B   4      -0.529   2.027  32.827  1.00 52.82           N  
ATOM   1795  N   GLU B   5       3.459   0.748  31.295  1.00 40.00           N  
ATOM   1796  CA  GLU B   5       4.002   1.761  32.191  1.00 39.28           C  
ATOM   1797  C   GLU B   5       4.774   2.846  31.446  1.00 35.37           C  
ATOM   1798  O   GLU B   5       4.628   4.029  31.733  1.00 36.31           O  
ATOM   1799  CB  GLU B   5       4.903   1.116  33.245  1.00 42.17           C  
ATOM   1800  CG  GLU B   5       5.463   2.116  34.242  1.00 49.01           C  
ATOM   1801  CD  GLU B   5       5.115   1.779  35.681  1.00 50.92           C  
ATOM   1802  OE1 GLU B   5       5.511   0.692  36.156  1.00 53.59           O  
ATOM   1803  OE2 GLU B   5       4.448   2.605  36.340  1.00 52.67           O  
ATOM   1804  N   TYR B   6       5.590   2.434  30.485  1.00 31.25           N  
ATOM   1805  CA  TYR B   6       6.396   3.350  29.685  1.00 28.71           C  
ATOM   1806  C   TYR B   6       5.542   4.427  29.008  1.00 27.51           C  
ATOM   1807  O   TYR B   6       5.862   5.613  29.076  1.00 24.97           O  
ATOM   1808  CB  TYR B   6       7.162   2.553  28.620  1.00 24.78           C  
ATOM   1809  CG  TYR B   6       7.962   3.385  27.646  1.00 27.07           C  
ATOM   1810  CD1 TYR B   6       9.182   3.949  28.016  1.00 26.19           C  
ATOM   1811  CD2 TYR B   6       7.508   3.592  26.340  1.00 27.93           C  
ATOM   1812  CE1 TYR B   6       9.935   4.694  27.113  1.00 26.31           C  
ATOM   1813  CE2 TYR B   6       8.251   4.336  25.426  1.00 29.39           C  
ATOM   1814  CZ  TYR B   6       9.467   4.884  25.822  1.00 27.29           C  
ATOM   1815  OH  TYR B   6      10.212   5.617  24.931  1.00 27.36           O  
ATOM   1816  N   TYR B   7       4.460   4.016  28.352  1.00 26.26           N  
ATOM   1817  CA  TYR B   7       3.593   4.972  27.660  1.00 28.90           C  
ATOM   1818  C   TYR B   7       2.710   5.799  28.601  1.00 31.01           C  
ATOM   1819  O   TYR B   7       2.240   6.881  28.234  1.00 30.18           O  
ATOM   1820  CB  TYR B   7       2.730   4.252  26.617  1.00 24.92           C  
ATOM   1821  CG  TYR B   7       3.522   3.845  25.395  1.00 24.78           C  
ATOM   1822  CD1 TYR B   7       4.261   4.785  24.683  1.00 23.42           C  
ATOM   1823  CD2 TYR B   7       3.572   2.517  24.974  1.00 24.86           C  
ATOM   1824  CE1 TYR B   7       5.043   4.415  23.582  1.00 24.13           C  
ATOM   1825  CE2 TYR B   7       4.352   2.132  23.869  1.00 22.81           C  
ATOM   1826  CZ  TYR B   7       5.087   3.091  23.183  1.00 22.17           C  
ATOM   1827  OH  TYR B   7       5.893   2.737  22.120  1.00 23.66           O  
ATOM   1828  N   ARG B   8       2.487   5.301  29.812  1.00 31.76           N  
ATOM   1829  CA  ARG B   8       1.681   6.051  30.763  1.00 36.90           C  
ATOM   1830  C   ARG B   8       2.537   7.125  31.408  1.00 35.33           C  
ATOM   1831  O   ARG B   8       2.053   8.205  31.692  1.00 37.13           O  
ATOM   1832  CB  ARG B   8       1.104   5.142  31.846  1.00 39.50           C  
ATOM   1833  CG  ARG B   8       0.244   5.871  32.877  1.00 43.54           C  
ATOM   1834  CD  ARG B   8      -0.431   4.870  33.778  1.00 46.78           C  
ATOM   1835  NE  ARG B   8       0.503   4.305  34.748  1.00 50.69           N  
ATOM   1836  CZ  ARG B   8       1.068   5.011  35.731  1.00 52.80           C  
ATOM   1837  NH1 ARG B   8       0.790   6.314  35.876  1.00 53.04           N  
ATOM   1838  NH2 ARG B   8       1.920   4.438  36.571  1.00 53.53           N  
ATOM   1839  N   VAL B   9       3.818   6.829  31.606  1.00 35.25           N  
ATOM   1840  CA  VAL B   9       4.738   7.775  32.232  1.00 35.36           C  
ATOM   1841  C   VAL B   9       5.168   8.915  31.312  1.00 34.50           C  
ATOM   1842  O   VAL B   9       5.288  10.062  31.745  1.00 36.06           O  
ATOM   1843  CB  VAL B   9       6.000   7.055  32.748  1.00 35.90           C  
ATOM   1844  CG1 VAL B   9       7.030   8.077  33.197  1.00 37.08           C  
ATOM   1845  CG2 VAL B   9       5.631   6.126  33.897  1.00 35.49           C  
ATOM   1846  N   PHE B  10       5.412   8.604  30.047  1.00 31.66           N  
ATOM   1847  CA  PHE B  10       5.822   9.630  29.099  1.00 32.87           C  
ATOM   1848  C   PHE B  10       4.634  10.079  28.260  1.00 31.54           C  
ATOM   1849  O   PHE B  10       4.131   9.323  27.446  1.00 35.43           O  
ATOM   1850  CB  PHE B  10       6.928   9.102  28.182  1.00 31.33           C  
ATOM   1851  CG  PHE B  10       8.175   8.711  28.913  1.00 31.61           C  
ATOM   1852  CD1 PHE B  10       8.391   7.386  29.293  1.00 30.97           C  
ATOM   1853  CD2 PHE B  10       9.129   9.672  29.244  1.00 32.36           C  
ATOM   1854  CE1 PHE B  10       9.539   7.022  29.990  1.00 30.13           C  
ATOM   1855  CE2 PHE B  10      10.284   9.321  29.944  1.00 32.42           C  
ATOM   1856  CZ  PHE B  10      10.489   7.991  30.317  1.00 30.79           C  
ATOM   1857  N   PRO B  11       4.180  11.326  28.446  1.00 30.17           N  
ATOM   1858  CA  PRO B  11       3.041  11.883  27.704  1.00 28.09           C  
ATOM   1859  C   PRO B  11       3.344  12.064  26.213  1.00 27.28           C  
ATOM   1860  O   PRO B  11       2.456  12.334  25.402  1.00 26.56           O  
ATOM   1861  CB  PRO B  11       2.805  13.214  28.414  1.00 29.06           C  
ATOM   1862  CG  PRO B  11       4.197  13.641  28.751  1.00 28.63           C  
ATOM   1863  CD  PRO B  11       4.794  12.353  29.306  1.00 28.87           C  
ATOM   1864  N   THR B  12       4.613  11.885  25.868  1.00 26.61           N  
ATOM   1865  CA  THR B  12       5.095  12.049  24.507  1.00 25.33           C  
ATOM   1866  C   THR B  12       4.266  11.387  23.411  1.00 23.15           C  
ATOM   1867  O   THR B  12       4.088  11.961  22.337  1.00 19.37           O  
ATOM   1868  CB  THR B  12       6.532  11.505  24.380  1.00 26.86           C  
ATOM   1869  OG1 THR B  12       7.322  11.975  25.481  1.00 34.05           O  
ATOM   1870  CG2 THR B  12       7.144  11.968  23.091  1.00 30.05           C  
ATOM   1871  N   TYR B  13       3.783  10.179  23.688  1.00 21.54           N  
ATOM   1872  CA  TYR B  13       3.022   9.395  22.722  1.00 24.40           C  
ATOM   1873  C   TYR B  13       1.548   9.151  23.086  1.00 25.78           C  
ATOM   1874  O   TYR B  13       0.814   8.506  22.322  1.00 23.63           O  
ATOM   1875  CB  TYR B  13       3.731   8.050  22.534  1.00 27.18           C  
ATOM   1876  CG  TYR B  13       5.233   8.173  22.300  1.00 29.88           C  
ATOM   1877  CD1 TYR B  13       5.736   8.639  21.086  1.00 31.72           C  
ATOM   1878  CD2 TYR B  13       6.144   7.803  23.290  1.00 30.61           C  
ATOM   1879  CE1 TYR B  13       7.116   8.725  20.858  1.00 34.89           C  
ATOM   1880  CE2 TYR B  13       7.522   7.890  23.078  1.00 31.83           C  
ATOM   1881  CZ  TYR B  13       7.999   8.346  21.861  1.00 34.38           C  
ATOM   1882  OH  TYR B  13       9.357   8.412  21.640  1.00 38.03           O  
ATOM   1883  N   THR B  14       1.114   9.672  24.234  1.00 23.85           N  
ATOM   1884  CA  THR B  14      -0.257   9.472  24.683  1.00 27.21           C  
ATOM   1885  C   THR B  14      -1.041  10.740  25.044  1.00 27.67           C  
ATOM   1886  O   THR B  14      -2.267  10.710  25.075  1.00 26.54           O  
ATOM   1887  CB  THR B  14      -0.290   8.530  25.892  1.00 29.65           C  
ATOM   1888  OG1 THR B  14       0.548   9.063  26.928  1.00 35.76           O  
ATOM   1889  CG2 THR B  14       0.219   7.145  25.500  1.00 31.53           C  
ATOM   1890  N   ASP B  15      -0.350  11.845  25.311  1.00 27.03           N  
ATOM   1891  CA  ASP B  15      -1.028  13.098  25.659  1.00 26.26           C  
ATOM   1892  C   ASP B  15      -0.888  14.045  24.479  1.00 26.47           C  
ATOM   1893  O   ASP B  15       0.076  14.802  24.387  1.00 23.87           O  
ATOM   1894  CB  ASP B  15      -0.398  13.726  26.912  1.00 26.35           C  
ATOM   1895  CG  ASP B  15      -1.185  14.937  27.441  1.00 27.38           C  
ATOM   1896  OD1 ASP B  15      -2.104  15.435  26.755  1.00 24.70           O  
ATOM   1897  OD2 ASP B  15      -0.871  15.397  28.559  1.00 26.99           O  
ATOM   1898  N   ILE B  16      -1.851  13.982  23.561  1.00 28.02           N  
ATOM   1899  CA  ILE B  16      -1.838  14.835  22.374  1.00 29.92           C  
ATOM   1900  C   ILE B  16      -1.794  16.320  22.724  1.00 27.79           C  
ATOM   1901  O   ILE B  16      -1.334  17.132  21.930  1.00 31.24           O  
ATOM   1902  CB  ILE B  16      -3.084  14.570  21.473  1.00 31.23           C  
ATOM   1903  CG1 ILE B  16      -3.063  13.124  20.973  1.00 32.69           C  
ATOM   1904  CG2 ILE B  16      -3.082  15.524  20.278  1.00 33.10           C  
ATOM   1905  CD1 ILE B  16      -4.236  12.738  20.091  1.00 33.70           C  
ATOM   1906  N   ASN B  17      -2.257  16.674  23.914  1.00 28.92           N  
ATOM   1907  CA  ASN B  17      -2.255  18.080  24.320  1.00 30.40           C  
ATOM   1908  C   ASN B  17      -0.939  18.499  24.986  1.00 29.09           C  
ATOM   1909  O   ASN B  17      -0.732  19.681  25.273  1.00 30.13           O  
ATOM   1910  CB  ASN B  17      -3.433  18.358  25.271  1.00 31.64           C  
ATOM   1911  CG  ASN B  17      -4.795  18.118  24.614  1.00 37.01           C  
ATOM   1912  OD1 ASN B  17      -5.085  18.666  23.551  1.00 40.96           O  
ATOM   1913  ND2 ASN B  17      -5.635  17.305  25.252  1.00 37.13           N  
ATOM   1914  N   SER B  18      -0.045  17.540  25.207  1.00 23.92           N  
ATOM   1915  CA  SER B  18       1.235  17.818  25.861  1.00 24.68           C  
ATOM   1916  C   SER B  18       2.255  18.555  24.984  1.00 22.98           C  
ATOM   1917  O   SER B  18       2.264  18.405  23.759  1.00 19.47           O  
ATOM   1918  CB  SER B  18       1.867  16.512  26.352  1.00 23.28           C  
ATOM   1919  OG  SER B  18       2.384  15.769  25.264  1.00 23.82           O  
ATOM   1920  N   GLN B  19       3.124  19.344  25.620  1.00 22.25           N  
ATOM   1921  CA  GLN B  19       4.163  20.068  24.880  1.00 23.40           C  
ATOM   1922  C   GLN B  19       5.073  19.070  24.167  1.00 22.79           C  
ATOM   1923  O   GLN B  19       5.517  19.317  23.043  1.00 22.52           O  
ATOM   1924  CB  GLN B  19       5.002  20.956  25.814  1.00 25.88           C  
ATOM   1925  CG  GLN B  19       4.266  22.185  26.350  1.00 23.21           C  
ATOM   1926  CD  GLN B  19       5.104  22.982  27.347  1.00 26.41           C  
ATOM   1927  OE1 GLN B  19       6.301  22.729  27.523  1.00 23.11           O  
ATOM   1928  NE2 GLN B  19       4.474  23.951  28.002  1.00 24.10           N  
ATOM   1929  N   GLU B  20       5.338  17.934  24.803  1.00 22.35           N  
ATOM   1930  CA  GLU B  20       6.186  16.925  24.175  1.00 24.10           C  
ATOM   1931  C   GLU B  20       5.548  16.415  22.876  1.00 23.96           C  
ATOM   1932  O   GLU B  20       6.198  16.403  21.831  1.00 25.33           O  
ATOM   1933  CB  GLU B  20       6.441  15.736  25.120  1.00 23.11           C  
ATOM   1934  CG  GLU B  20       7.365  16.022  26.315  1.00 25.56           C  
ATOM   1935  CD  GLU B  20       6.704  16.821  27.451  1.00 28.68           C  
ATOM   1936  OE1 GLU B  20       5.476  17.073  27.402  1.00 25.37           O  
ATOM   1937  OE2 GLU B  20       7.424  17.183  28.410  1.00 30.09           O  
ATOM   1938  N   TYR B  21       4.282  16.002  22.945  1.00 23.22           N  
ATOM   1939  CA  TYR B  21       3.565  15.481  21.769  1.00 24.45           C  
ATOM   1940  C   TYR B  21       3.503  16.547  20.672  1.00 25.13           C  
ATOM   1941  O   TYR B  21       3.855  16.291  19.520  1.00 25.09           O  
ATOM   1942  CB  TYR B  21       2.144  15.044  22.175  1.00 25.01           C  
ATOM   1943  CG  TYR B  21       1.515  13.986  21.287  1.00 26.03           C  
ATOM   1944  CD1 TYR B  21       1.348  14.199  19.916  1.00 26.52           C  
ATOM   1945  CD2 TYR B  21       1.068  12.771  21.821  1.00 27.02           C  
ATOM   1946  CE1 TYR B  21       0.754  13.233  19.097  1.00 27.24           C  
ATOM   1947  CE2 TYR B  21       0.470  11.800  21.009  1.00 26.42           C  
ATOM   1948  CZ  TYR B  21       0.317  12.040  19.649  1.00 26.86           C  
ATOM   1949  OH  TYR B  21      -0.270  11.090  18.839  1.00 28.61           O  
ATOM   1950  N   ARG B  22       3.066  17.752  21.033  1.00 28.45           N  
ATOM   1951  CA  ARG B  22       2.996  18.857  20.072  1.00 28.06           C  
ATOM   1952  C   ARG B  22       4.327  19.045  19.357  1.00 28.22           C  
ATOM   1953  O   ARG B  22       4.368  19.257  18.145  1.00 27.45           O  
ATOM   1954  CB  ARG B  22       2.649  20.168  20.772  1.00 29.05           C  
ATOM   1955  CG  ARG B  22       1.258  20.229  21.375  1.00 33.68           C  
ATOM   1956  CD  ARG B  22       1.053  21.578  22.053  1.00 39.43           C  
ATOM   1957  NE  ARG B  22      -0.281  21.725  22.625  1.00 44.88           N  
ATOM   1958  CZ  ARG B  22      -1.408  21.723  21.919  1.00 48.20           C  
ATOM   1959  NH1 ARG B  22      -1.375  21.580  20.600  1.00 51.92           N  
ATOM   1960  NH2 ARG B  22      -2.572  21.866  22.535  1.00 49.81           N  
ATOM   1961  N   SER B  23       5.415  18.978  20.119  1.00 27.48           N  
ATOM   1962  CA  SER B  23       6.753  19.151  19.568  1.00 29.50           C  
ATOM   1963  C   SER B  23       7.053  18.164  18.440  1.00 30.17           C  
ATOM   1964  O   SER B  23       7.604  18.544  17.401  1.00 31.10           O  
ATOM   1965  CB  SER B  23       7.797  19.003  20.672  1.00 29.69           C  
ATOM   1966  OG  SER B  23       9.105  19.099  20.136  1.00 36.34           O  
ATOM   1967  N   ARG B  24       6.708  16.898  18.646  1.00 28.08           N  
ATOM   1968  CA  ARG B  24       6.931  15.890  17.615  1.00 28.86           C  
ATOM   1969  C   ARG B  24       6.057  16.230  16.406  1.00 26.80           C  
ATOM   1970  O   ARG B  24       6.490  16.117  15.266  1.00 26.72           O  
ATOM   1971  CB  ARG B  24       6.565  14.491  18.134  1.00 28.27           C  
ATOM   1972  CG  ARG B  24       7.346  14.047  19.380  1.00 31.13           C  
ATOM   1973  CD  ARG B  24       6.692  12.823  20.002  1.00 32.16           C  
ATOM   1974  NE  ARG B  24       6.481  11.826  18.976  1.00 35.66           N  
ATOM   1975  CZ  ARG B  24       5.329  11.218  18.718  1.00 31.06           C  
ATOM   1976  NH1 ARG B  24       4.225  11.473  19.414  1.00 32.87           N  
ATOM   1977  NH2 ARG B  24       5.291  10.366  17.719  1.00 34.01           N  
ATOM   1978  N   ILE B  25       4.828  16.660  16.657  1.00 28.79           N  
ATOM   1979  CA  ILE B  25       3.930  16.995  15.558  1.00 30.63           C  
ATOM   1980  C   ILE B  25       4.485  18.131  14.705  1.00 33.00           C  
ATOM   1981  O   ILE B  25       4.552  18.020  13.479  1.00 32.97           O  
ATOM   1982  CB  ILE B  25       2.529  17.386  16.073  1.00 31.95           C  
ATOM   1983  CG1 ILE B  25       1.831  16.151  16.664  1.00 34.03           C  
ATOM   1984  CG2 ILE B  25       1.706  17.996  14.937  1.00 33.02           C  
ATOM   1985  CD1 ILE B  25       0.424  16.415  17.193  1.00 33.45           C  
ATOM   1986  N   GLU B  26       4.909  19.211  15.352  1.00 32.15           N  
ATOM   1987  CA  GLU B  26       5.430  20.359  14.625  1.00 35.61           C  
ATOM   1988  C   GLU B  26       6.765  20.079  13.950  1.00 36.12           C  
ATOM   1989  O   GLU B  26       7.090  20.695  12.941  1.00 36.51           O  
ATOM   1990  CB  GLU B  26       5.530  21.568  15.565  1.00 38.87           C  
ATOM   1991  CG  GLU B  26       4.223  21.801  16.344  1.00 44.50           C  
ATOM   1992  CD  GLU B  26       4.147  23.154  17.040  1.00 48.42           C  
ATOM   1993  OE1 GLU B  26       5.133  23.560  17.692  1.00 47.50           O  
ATOM   1994  OE2 GLU B  26       3.080  23.804  16.946  1.00 49.74           O  
ATOM   1995  N   THR B  27       7.536  19.147  14.495  1.00 35.72           N  
ATOM   1996  CA  THR B  27       8.823  18.809  13.902  1.00 35.42           C  
ATOM   1997  C   THR B  27       8.634  18.025  12.608  1.00 35.40           C  
ATOM   1998  O   THR B  27       9.411  18.171  11.663  1.00 35.31           O  
ATOM   1999  CB  THR B  27       9.689  17.954  14.855  1.00 34.06           C  
ATOM   2000  OG1 THR B  27       9.938  18.679  16.062  1.00 33.67           O  
ATOM   2001  CG2 THR B  27      11.020  17.613  14.205  1.00 33.22           C  
ATOM   2002  N   LEU B  28       7.597  17.198  12.559  1.00 35.90           N  
ATOM   2003  CA  LEU B  28       7.357  16.389  11.373  1.00 38.21           C  
ATOM   2004  C   LEU B  28       6.360  16.988  10.396  1.00 38.86           C  
ATOM   2005  O   LEU B  28       6.381  16.664   9.210  1.00 39.01           O  
ATOM   2006  CB  LEU B  28       6.897  14.979  11.780  1.00 36.84           C  
ATOM   2007  CG  LEU B  28       7.895  14.146  12.605  1.00 35.73           C  
ATOM   2008  CD1 LEU B  28       7.329  12.754  12.856  1.00 35.75           C  
ATOM   2009  CD2 LEU B  28       9.224  14.044  11.862  1.00 36.97           C  
ATOM   2010  N   GLU B  29       5.497  17.870  10.894  1.00 40.72           N  
ATOM   2011  CA  GLU B  29       4.460  18.492  10.070  1.00 42.52           C  
ATOM   2012  C   GLU B  29       4.921  18.959   8.684  1.00 41.67           C  
ATOM   2013  O   GLU B  29       4.347  18.564   7.674  1.00 42.10           O  
ATOM   2014  CB  GLU B  29       3.817  19.661  10.831  1.00 44.66           C  
ATOM   2015  CG  GLU B  29       2.541  20.195  10.188  1.00 48.64           C  
ATOM   2016  CD  GLU B  29       1.838  21.247  11.041  1.00 50.51           C  
ATOM   2017  OE1 GLU B  29       0.761  21.726  10.624  1.00 50.92           O  
ATOM   2018  OE2 GLU B  29       2.357  21.597  12.125  1.00 50.84           O  
ATOM   2019  N   PRO B  30       5.968  19.798   8.617  1.00 41.33           N  
ATOM   2020  CA  PRO B  30       6.456  20.285   7.319  1.00 42.66           C  
ATOM   2021  C   PRO B  30       7.072  19.205   6.436  1.00 42.61           C  
ATOM   2022  O   PRO B  30       6.905  19.224   5.222  1.00 42.08           O  
ATOM   2023  CB  PRO B  30       7.466  21.359   7.711  1.00 39.73           C  
ATOM   2024  CG  PRO B  30       8.015  20.833   9.007  1.00 41.38           C  
ATOM   2025  CD  PRO B  30       6.771  20.354   9.721  1.00 41.08           C  
ATOM   2026  N   LEU B  31       7.787  18.268   7.052  1.00 43.17           N  
ATOM   2027  CA  LEU B  31       8.414  17.240   6.238  1.00 43.56           C  
ATOM   2028  C   LEU B  31       7.369  16.312   5.623  1.00 43.62           C  
ATOM   2029  O   LEU B  31       7.488  15.864   4.490  1.00 43.61           O  
ATOM   2030  CB  LEU B  31       9.363  16.437   7.130  1.00 44.24           C  
ATOM   2031  CG  LEU B  31      10.404  17.320   7.821  1.00 45.64           C  
ATOM   2032  CD1 LEU B  31      11.090  16.608   8.988  1.00 44.74           C  
ATOM   2033  CD2 LEU B  31      11.519  17.772   6.878  1.00 46.47           C  
ATOM   2034  N   LEU B  32       6.268  16.055   6.316  1.00 43.88           N  
ATOM   2035  CA  LEU B  32       5.191  15.238   5.765  1.00 45.94           C  
ATOM   2036  C   LEU B  32       4.460  15.928   4.615  1.00 49.06           C  
ATOM   2037  O   LEU B  32       4.187  15.306   3.587  1.00 49.27           O  
ATOM   2038  CB  LEU B  32       4.185  14.876   6.864  1.00 42.34           C  
ATOM   2039  CG  LEU B  32       4.678  13.926   7.963  1.00 41.82           C  
ATOM   2040  CD1 LEU B  32       3.638  13.816   9.071  1.00 41.33           C  
ATOM   2041  CD2 LEU B  32       4.964  12.558   7.361  1.00 38.87           C  
HETATM 2042  N   MSE B  33       4.147  17.210   4.782  1.00 51.13           N  
HETATM 2043  CA  MSE B  33       3.428  17.940   3.744  1.00 54.22           C  
HETATM 2044  C   MSE B  33       4.272  18.226   2.508  1.00 53.08           C  
HETATM 2045  O   MSE B  33       3.741  18.538   1.442  1.00 53.41           O  
HETATM 2046  CB  MSE B  33       2.852  19.236   4.312  1.00 57.96           C  
HETATM 2047  CG  MSE B  33       1.782  18.995   5.369  1.00 65.44           C  
HETATM 2048 SE   MSE B  33       0.465  17.665   4.823  1.00 75.50          SE  
HETATM 2049  CE  MSE B  33       1.301  16.085   5.558  1.00 71.77           C  
ATOM   2050  N   LYS B  34       5.585  18.108   2.651  1.00 51.12           N  
ATOM   2051  CA  LYS B  34       6.486  18.337   1.535  1.00 49.59           C  
ATOM   2052  C   LYS B  34       6.464  17.130   0.604  1.00 48.45           C  
ATOM   2053  O   LYS B  34       6.861  17.228  -0.556  1.00 49.12           O  
ATOM   2054  CB  LYS B  34       7.911  18.561   2.041  1.00 49.61           C  
ATOM   2055  CG  LYS B  34       8.962  18.527   0.945  1.00 49.70           C  
ATOM   2056  CD  LYS B  34      10.351  18.766   1.488  1.00 49.51           C  
ATOM   2057  CE  LYS B  34      11.388  18.646   0.383  1.00 50.33           C  
ATOM   2058  NZ  LYS B  34      12.772  18.804   0.905  1.00 48.80           N  
ATOM   2059  N   TYR B  35       5.992  15.997   1.122  1.00 45.82           N  
ATOM   2060  CA  TYR B  35       5.927  14.758   0.354  1.00 42.69           C  
ATOM   2061  C   TYR B  35       4.522  14.225   0.192  1.00 41.86           C  
ATOM   2062  O   TYR B  35       4.328  13.140  -0.359  1.00 41.79           O  
ATOM   2063  CB  TYR B  35       6.782  13.686   1.021  1.00 42.03           C  
ATOM   2064  CG  TYR B  35       8.247  14.000   0.992  1.00 40.85           C  
ATOM   2065  CD1 TYR B  35       8.950  13.997  -0.209  1.00 39.84           C  
ATOM   2066  CD2 TYR B  35       8.931  14.330   2.157  1.00 39.82           C  
ATOM   2067  CE1 TYR B  35      10.298  14.317  -0.252  1.00 38.85           C  
ATOM   2068  CE2 TYR B  35      10.283  14.652   2.125  1.00 40.33           C  
ATOM   2069  CZ  TYR B  35      10.957  14.643   0.918  1.00 38.99           C  
ATOM   2070  OH  TYR B  35      12.290  14.959   0.875  1.00 40.21           O  
HETATM 2071  N   MSE B  36       3.547  14.983   0.679  1.00 41.25           N  
HETATM 2072  CA  MSE B  36       2.149  14.588   0.600  1.00 41.12           C  
HETATM 2073  C   MSE B  36       1.307  15.729   0.027  1.00 42.38           C  
HETATM 2074  O   MSE B  36       0.189  15.979   0.478  1.00 41.44           O  
HETATM 2075  CB  MSE B  36       1.638  14.212   1.996  1.00 40.79           C  
HETATM 2076  CG  MSE B  36       2.401  13.070   2.681  1.00 38.87           C  
HETATM 2077 SE   MSE B  36       1.706  12.685   4.466  1.00 40.77          SE  
HETATM 2078  CE  MSE B  36      -0.028  12.022   3.980  1.00 36.68           C  
ATOM   2079  N   LYS B  37       1.847  16.418  -0.974  1.00 46.33           N  
ATOM   2080  CA  LYS B  37       1.140  17.534  -1.592  1.00 48.54           C  
ATOM   2081  C   LYS B  37      -0.193  17.089  -2.179  1.00 48.89           C  
ATOM   2082  O   LYS B  37      -1.176  17.826  -2.149  1.00 49.04           O  
ATOM   2083  CB  LYS B  37       2.007  18.169  -2.679  1.00 49.77           C  
ATOM   2084  CG  LYS B  37       3.315  18.746  -2.157  1.00 53.04           C  
ATOM   2085  CD  LYS B  37       4.138  19.374  -3.277  1.00 56.25           C  
ATOM   2086  CE  LYS B  37       5.442  19.955  -2.749  1.00 56.78           C  
ATOM   2087  NZ  LYS B  37       5.185  20.967  -1.685  1.00 58.64           N  
ATOM   2088  N   LYS B  38      -0.226  15.868  -2.695  1.00 50.37           N  
ATOM   2089  CA  LYS B  38      -1.439  15.327  -3.289  1.00 50.62           C  
ATOM   2090  C   LYS B  38      -2.289  14.674  -2.202  1.00 51.53           C  
ATOM   2091  O   LYS B  38      -1.924  13.634  -1.653  1.00 50.56           O  
ATOM   2092  CB  LYS B  38      -1.063  14.306  -4.365  1.00 51.89           C  
ATOM   2093  CG  LYS B  38      -2.137  14.040  -5.407  1.00 52.91           C  
ATOM   2094  CD  LYS B  38      -1.579  13.178  -6.543  1.00 55.48           C  
ATOM   2095  CE  LYS B  38      -2.604  12.965  -7.652  1.00 56.90           C  
ATOM   2096  NZ  LYS B  38      -2.053  12.188  -8.800  1.00 56.54           N  
ATOM   2097  N   ARG B  39      -3.421  15.296  -1.885  1.00 51.77           N  
ATOM   2098  CA  ARG B  39      -4.316  14.772  -0.860  1.00 52.11           C  
ATOM   2099  C   ARG B  39      -4.910  13.433  -1.298  1.00 50.14           C  
ATOM   2100  O   ARG B  39      -5.164  13.221  -2.482  1.00 51.73           O  
ATOM   2101  CB  ARG B  39      -5.439  15.778  -0.589  1.00 53.83           C  
ATOM   2102  CG  ARG B  39      -4.956  17.167  -0.174  1.00 56.26           C  
ATOM   2103  CD  ARG B  39      -4.358  17.173   1.224  1.00 57.00           C  
ATOM   2104  NE  ARG B  39      -3.849  18.488   1.614  1.00 57.36           N  
ATOM   2105  CZ  ARG B  39      -2.743  19.044   1.127  1.00 57.47           C  
ATOM   2106  NH1 ARG B  39      -2.013  18.407   0.227  1.00 57.87           N  
ATOM   2107  NH2 ARG B  39      -2.365  20.246   1.539  1.00 58.76           N  
ATOM   2108  N   GLY B  40      -5.124  12.532  -0.345  1.00 47.30           N  
ATOM   2109  CA  GLY B  40      -5.687  11.233  -0.671  1.00 45.15           C  
ATOM   2110  C   GLY B  40      -6.001  10.370   0.537  1.00 43.89           C  
ATOM   2111  O   GLY B  40      -6.219  10.882   1.637  1.00 42.52           O  
ATOM   2112  N   LYS B  41      -6.029   9.055   0.327  1.00 42.93           N  
ATOM   2113  CA  LYS B  41      -6.320   8.092   1.388  1.00 42.65           C  
ATOM   2114  C   LYS B  41      -5.027   7.761   2.149  1.00 41.72           C  
ATOM   2115  O   LYS B  41      -4.020   7.379   1.546  1.00 39.74           O  
ATOM   2116  CB  LYS B  41      -6.916   6.820   0.777  1.00 44.65           C  
ATOM   2117  CG  LYS B  41      -7.943   6.106   1.649  1.00 47.68           C  
ATOM   2118  CD  LYS B  41      -8.578   4.943   0.885  1.00 50.17           C  
ATOM   2119  CE  LYS B  41      -9.850   4.426   1.554  1.00 51.43           C  
ATOM   2120  NZ  LYS B  41      -9.620   3.795   2.885  1.00 54.68           N  
ATOM   2121  N   VAL B  42      -5.065   7.903   3.472  1.00 39.46           N  
ATOM   2122  CA  VAL B  42      -3.892   7.655   4.305  1.00 37.81           C  
ATOM   2123  C   VAL B  42      -4.096   6.647   5.435  1.00 35.21           C  
ATOM   2124  O   VAL B  42      -5.114   6.666   6.129  1.00 35.53           O  
ATOM   2125  CB  VAL B  42      -3.392   8.968   4.946  1.00 38.06           C  
ATOM   2126  CG1 VAL B  42      -2.124   8.714   5.750  1.00 39.62           C  
ATOM   2127  CG2 VAL B  42      -3.144  10.008   3.875  1.00 37.86           C  
ATOM   2128  N   LEU B  43      -3.111   5.770   5.610  1.00 33.97           N  
ATOM   2129  CA  LEU B  43      -3.132   4.776   6.682  1.00 31.72           C  
ATOM   2130  C   LEU B  43      -2.063   5.159   7.712  1.00 29.98           C  
ATOM   2131  O   LEU B  43      -0.870   5.170   7.401  1.00 28.59           O  
ATOM   2132  CB  LEU B  43      -2.826   3.371   6.143  1.00 31.19           C  
ATOM   2133  CG  LEU B  43      -2.574   2.291   7.209  1.00 31.02           C  
ATOM   2134  CD1 LEU B  43      -3.801   2.170   8.107  1.00 28.66           C  
ATOM   2135  CD2 LEU B  43      -2.261   0.947   6.558  1.00 29.29           C  
ATOM   2136  N   ASP B  44      -2.504   5.484   8.924  1.00 29.89           N  
ATOM   2137  CA  ASP B  44      -1.614   5.839  10.027  1.00 30.07           C  
ATOM   2138  C   ASP B  44      -1.364   4.508  10.733  1.00 27.65           C  
ATOM   2139  O   ASP B  44      -2.146   4.100  11.577  1.00 30.07           O  
ATOM   2140  CB  ASP B  44      -2.316   6.807  10.989  1.00 31.87           C  
ATOM   2141  CG  ASP B  44      -1.388   7.346  12.077  1.00 35.78           C  
ATOM   2142  OD1 ASP B  44      -0.283   6.787  12.274  1.00 35.85           O  
ATOM   2143  OD2 ASP B  44      -1.774   8.333  12.748  1.00 34.70           O  
ATOM   2144  N   LEU B  45      -0.278   3.835  10.376  1.00 27.41           N  
ATOM   2145  CA  LEU B  45       0.054   2.521  10.945  1.00 25.25           C  
ATOM   2146  C   LEU B  45       0.686   2.660  12.333  1.00 24.05           C  
ATOM   2147  O   LEU B  45       1.714   3.308  12.468  1.00 26.79           O  
ATOM   2148  CB  LEU B  45       1.007   1.802   9.982  1.00 22.89           C  
ATOM   2149  CG  LEU B  45       1.108   0.282  10.125  1.00 25.23           C  
ATOM   2150  CD1 LEU B  45      -0.267  -0.323  10.382  1.00 21.06           C  
ATOM   2151  CD2 LEU B  45       1.734  -0.289   8.871  1.00 22.57           C  
ATOM   2152  N   ALA B  46       0.088   2.030  13.344  1.00 23.05           N  
ATOM   2153  CA  ALA B  46       0.571   2.151  14.726  1.00 23.19           C  
ATOM   2154  C   ALA B  46       0.297   3.619  15.104  1.00 23.45           C  
ATOM   2155  O   ALA B  46       1.204   4.339  15.540  1.00 21.01           O  
ATOM   2156  CB  ALA B  46       2.085   1.850  14.803  1.00 17.75           C  
ATOM   2157  N   CYS B  47      -0.962   4.037  14.943  1.00 21.79           N  
ATOM   2158  CA  CYS B  47      -1.387   5.424  15.175  1.00 23.19           C  
ATOM   2159  C   CYS B  47      -1.355   5.984  16.592  1.00 22.19           C  
ATOM   2160  O   CYS B  47      -1.451   7.199  16.775  1.00 21.67           O  
ATOM   2161  CB  CYS B  47      -2.801   5.635  14.611  1.00 22.12           C  
ATOM   2162  SG  CYS B  47      -4.084   4.678  15.435  1.00 24.90           S  
ATOM   2163  N   GLY B  48      -1.235   5.116  17.589  1.00 21.95           N  
ATOM   2164  CA  GLY B  48      -1.215   5.597  18.959  1.00 23.27           C  
ATOM   2165  C   GLY B  48      -2.565   6.198  19.303  1.00 24.85           C  
ATOM   2166  O   GLY B  48      -3.613   5.586  19.053  1.00 23.82           O  
ATOM   2167  N   VAL B  49      -2.549   7.402  19.866  1.00 23.61           N  
ATOM   2168  CA  VAL B  49      -3.788   8.079  20.214  1.00 23.60           C  
ATOM   2169  C   VAL B  49      -4.303   8.979  19.093  1.00 24.47           C  
ATOM   2170  O   VAL B  49      -5.234   9.765  19.301  1.00 23.22           O  
ATOM   2171  CB  VAL B  49      -3.623   8.860  21.506  1.00 22.93           C  
ATOM   2172  CG1 VAL B  49      -3.304   7.899  22.626  1.00 20.94           C  
ATOM   2173  CG2 VAL B  49      -2.536   9.889  21.338  1.00 17.93           C  
ATOM   2174  N   GLY B  50      -3.682   8.866  17.917  1.00 24.75           N  
ATOM   2175  CA  GLY B  50      -4.134   9.586  16.738  1.00 25.81           C  
ATOM   2176  C   GLY B  50      -3.685  10.985  16.387  1.00 27.98           C  
ATOM   2177  O   GLY B  50      -4.135  11.507  15.372  1.00 28.52           O  
ATOM   2178  N   GLY B  51      -2.825  11.602  17.189  1.00 28.02           N  
ATOM   2179  CA  GLY B  51      -2.377  12.954  16.888  1.00 28.37           C  
ATOM   2180  C   GLY B  51      -2.010  13.220  15.430  1.00 30.65           C  
ATOM   2181  O   GLY B  51      -2.353  14.264  14.877  1.00 29.05           O  
ATOM   2182  N   PHE B  52      -1.292  12.303  14.797  1.00 28.96           N  
ATOM   2183  CA  PHE B  52      -0.924  12.500  13.404  1.00 30.43           C  
ATOM   2184  C   PHE B  52      -2.101  12.250  12.456  1.00 32.17           C  
ATOM   2185  O   PHE B  52      -2.142  12.792  11.351  1.00 33.27           O  
ATOM   2186  CB  PHE B  52       0.264  11.611  13.050  1.00 28.48           C  
ATOM   2187  CG  PHE B  52       1.558  12.113  13.609  1.00 29.39           C  
ATOM   2188  CD1 PHE B  52       2.228  13.169  12.996  1.00 29.02           C  
ATOM   2189  CD2 PHE B  52       2.079  11.576  14.779  1.00 29.20           C  
ATOM   2190  CE1 PHE B  52       3.395  13.680  13.543  1.00 29.69           C  
ATOM   2191  CE2 PHE B  52       3.246  12.082  15.332  1.00 30.51           C  
ATOM   2192  CZ  PHE B  52       3.905  13.134  14.713  1.00 29.17           C  
ATOM   2193  N   SER B  53      -3.052  11.428  12.885  1.00 31.67           N  
ATOM   2194  CA  SER B  53      -4.228  11.161  12.072  1.00 33.10           C  
ATOM   2195  C   SER B  53      -5.069  12.433  12.026  1.00 34.06           C  
ATOM   2196  O   SER B  53      -5.506  12.855  10.955  1.00 33.85           O  
ATOM   2197  CB  SER B  53      -5.044  10.016  12.661  1.00 31.72           C  
ATOM   2198  OG  SER B  53      -4.410   8.769  12.413  1.00 34.08           O  
ATOM   2199  N   PHE B  54      -5.279  13.048  13.192  1.00 34.34           N  
ATOM   2200  CA  PHE B  54      -6.054  14.285  13.285  1.00 33.48           C  
ATOM   2201  C   PHE B  54      -5.360  15.389  12.485  1.00 35.02           C  
ATOM   2202  O   PHE B  54      -6.015  16.214  11.833  1.00 32.71           O  
ATOM   2203  CB  PHE B  54      -6.206  14.710  14.749  1.00 31.64           C  
ATOM   2204  CG  PHE B  54      -6.936  13.703  15.598  1.00 32.09           C  
ATOM   2205  CD1 PHE B  54      -8.151  13.159  15.171  1.00 30.61           C  
ATOM   2206  CD2 PHE B  54      -6.401  13.277  16.812  1.00 32.11           C  
ATOM   2207  CE1 PHE B  54      -8.816  12.209  15.941  1.00 33.84           C  
ATOM   2208  CE2 PHE B  54      -7.059  12.322  17.596  1.00 30.80           C  
ATOM   2209  CZ  PHE B  54      -8.268  11.785  17.165  1.00 33.25           C  
ATOM   2210  N   LEU B  55      -4.032  15.402  12.533  1.00 34.16           N  
ATOM   2211  CA  LEU B  55      -3.284  16.396  11.788  1.00 35.35           C  
ATOM   2212  C   LEU B  55      -3.619  16.254  10.298  1.00 37.03           C  
ATOM   2213  O   LEU B  55      -3.946  17.235   9.623  1.00 36.67           O  
ATOM   2214  CB  LEU B  55      -1.783  16.202  11.991  1.00 36.44           C  
ATOM   2215  CG  LEU B  55      -0.890  17.120  11.151  1.00 38.34           C  
ATOM   2216  CD1 LEU B  55      -1.130  18.565  11.563  1.00 39.55           C  
ATOM   2217  CD2 LEU B  55       0.578  16.750  11.336  1.00 38.54           C  
ATOM   2218  N   LEU B  56      -3.548  15.025   9.798  1.00 36.11           N  
ATOM   2219  CA  LEU B  56      -3.814  14.755   8.390  1.00 37.33           C  
ATOM   2220  C   LEU B  56      -5.255  15.020   7.990  1.00 37.84           C  
ATOM   2221  O   LEU B  56      -5.517  15.438   6.865  1.00 38.29           O  
ATOM   2222  CB  LEU B  56      -3.429  13.316   8.041  1.00 35.59           C  
ATOM   2223  CG  LEU B  56      -1.938  12.997   8.209  1.00 37.15           C  
ATOM   2224  CD1 LEU B  56      -1.675  11.567   7.777  1.00 37.02           C  
ATOM   2225  CD2 LEU B  56      -1.099  13.955   7.379  1.00 35.78           C  
ATOM   2226  N   GLU B  57      -6.189  14.770   8.902  1.00 38.20           N  
ATOM   2227  CA  GLU B  57      -7.596  15.016   8.616  1.00 40.76           C  
ATOM   2228  C   GLU B  57      -7.779  16.519   8.445  1.00 41.99           C  
ATOM   2229  O   GLU B  57      -8.504  16.967   7.562  1.00 42.10           O  
ATOM   2230  CB  GLU B  57      -8.467  14.503   9.763  1.00 41.03           C  
ATOM   2231  CG  GLU B  57      -9.920  14.946   9.708  1.00 43.96           C  
ATOM   2232  CD  GLU B  57     -10.727  14.393  10.864  1.00 45.25           C  
ATOM   2233  OE1 GLU B  57     -10.297  14.566  12.028  1.00 44.59           O  
ATOM   2234  OE2 GLU B  57     -11.790  13.782  10.611  1.00 45.98           O  
ATOM   2235  N   ASP B  58      -7.105  17.294   9.291  1.00 43.40           N  
ATOM   2236  CA  ASP B  58      -7.185  18.748   9.221  1.00 44.63           C  
ATOM   2237  C   ASP B  58      -6.685  19.246   7.876  1.00 45.70           C  
ATOM   2238  O   ASP B  58      -7.048  20.340   7.445  1.00 46.03           O  
ATOM   2239  CB  ASP B  58      -6.348  19.404  10.322  1.00 44.37           C  
ATOM   2240  CG  ASP B  58      -6.956  19.242  11.691  1.00 44.74           C  
ATOM   2241  OD1 ASP B  58      -8.145  18.872  11.778  1.00 45.68           O  
ATOM   2242  OD2 ASP B  58      -6.240  19.499  12.684  1.00 48.07           O  
ATOM   2243  N   TYR B  59      -5.845  18.448   7.220  1.00 45.64           N  
ATOM   2244  CA  TYR B  59      -5.301  18.828   5.920  1.00 46.49           C  
ATOM   2245  C   TYR B  59      -6.100  18.268   4.748  1.00 44.45           C  
ATOM   2246  O   TYR B  59      -5.655  18.318   3.602  1.00 44.17           O  
ATOM   2247  CB  TYR B  59      -3.838  18.397   5.809  1.00 49.17           C  
ATOM   2248  CG  TYR B  59      -2.881  19.356   6.476  1.00 53.02           C  
ATOM   2249  CD1 TYR B  59      -2.582  20.588   5.896  1.00 56.32           C  
ATOM   2250  CD2 TYR B  59      -2.290  19.043   7.699  1.00 55.46           C  
ATOM   2251  CE1 TYR B  59      -1.716  21.488   6.518  1.00 57.22           C  
ATOM   2252  CE2 TYR B  59      -1.425  19.935   8.332  1.00 57.09           C  
ATOM   2253  CZ  TYR B  59      -1.144  21.153   7.737  1.00 57.88           C  
ATOM   2254  OH  TYR B  59      -0.301  22.039   8.365  1.00 57.93           O  
ATOM   2255  N   GLY B  60      -7.276  17.724   5.040  1.00 43.56           N  
ATOM   2256  CA  GLY B  60      -8.127  17.201   3.987  1.00 42.05           C  
ATOM   2257  C   GLY B  60      -7.858  15.794   3.486  1.00 42.05           C  
ATOM   2258  O   GLY B  60      -8.252  15.450   2.371  1.00 41.16           O  
ATOM   2259  N   PHE B  61      -7.186  14.977   4.290  1.00 39.99           N  
ATOM   2260  CA  PHE B  61      -6.913  13.600   3.895  1.00 37.16           C  
ATOM   2261  C   PHE B  61      -7.996  12.706   4.473  1.00 36.50           C  
ATOM   2262  O   PHE B  61      -8.655  13.066   5.455  1.00 38.05           O  
ATOM   2263  CB  PHE B  61      -5.561  13.136   4.437  1.00 36.95           C  
ATOM   2264  CG  PHE B  61      -4.380  13.684   3.697  1.00 34.86           C  
ATOM   2265  CD1 PHE B  61      -3.833  12.990   2.625  1.00 34.43           C  
ATOM   2266  CD2 PHE B  61      -3.800  14.885   4.083  1.00 36.62           C  
ATOM   2267  CE1 PHE B  61      -2.721  13.479   1.954  1.00 33.73           C  
ATOM   2268  CE2 PHE B  61      -2.688  15.385   3.419  1.00 35.10           C  
ATOM   2269  CZ  PHE B  61      -2.147  14.680   2.350  1.00 35.34           C  
ATOM   2270  N   GLU B  62      -8.199  11.554   3.846  1.00 35.86           N  
ATOM   2271  CA  GLU B  62      -9.161  10.576   4.339  1.00 36.70           C  
ATOM   2272  C   GLU B  62      -8.264   9.658   5.170  1.00 34.98           C  
ATOM   2273  O   GLU B  62      -7.427   8.935   4.623  1.00 32.47           O  
ATOM   2274  CB  GLU B  62      -9.794   9.809   3.181  1.00 39.08           C  
ATOM   2275  CG  GLU B  62     -10.857   8.822   3.621  1.00 44.40           C  
ATOM   2276  CD  GLU B  62     -11.554   8.168   2.453  1.00 46.89           C  
ATOM   2277  OE1 GLU B  62     -12.376   7.256   2.690  1.00 49.99           O  
ATOM   2278  OE2 GLU B  62     -11.281   8.570   1.302  1.00 47.91           O  
ATOM   2279  N   VAL B  63      -8.446   9.690   6.486  1.00 33.43           N  
ATOM   2280  CA  VAL B  63      -7.592   8.930   7.388  1.00 31.22           C  
ATOM   2281  C   VAL B  63      -8.148   7.726   8.127  1.00 30.14           C  
ATOM   2282  O   VAL B  63      -9.256   7.753   8.664  1.00 34.96           O  
ATOM   2283  CB  VAL B  63      -6.987   9.877   8.470  1.00 30.45           C  
ATOM   2284  CG1 VAL B  63      -5.956   9.123   9.321  1.00 28.95           C  
ATOM   2285  CG2 VAL B  63      -6.356  11.095   7.807  1.00 29.78           C  
ATOM   2286  N   VAL B  64      -7.351   6.667   8.159  1.00 30.05           N  
ATOM   2287  CA  VAL B  64      -7.695   5.464   8.902  1.00 28.94           C  
ATOM   2288  C   VAL B  64      -6.513   5.229   9.836  1.00 28.72           C  
ATOM   2289  O   VAL B  64      -5.353   5.264   9.413  1.00 28.43           O  
ATOM   2290  CB  VAL B  64      -7.860   4.218   8.013  1.00 30.65           C  
ATOM   2291  CG1 VAL B  64      -8.304   3.045   8.880  1.00 31.27           C  
ATOM   2292  CG2 VAL B  64      -8.895   4.469   6.924  1.00 33.75           C  
ATOM   2293  N   GLY B  65      -6.799   5.013  11.111  1.00 28.72           N  
ATOM   2294  CA  GLY B  65      -5.729   4.781  12.062  1.00 26.99           C  
ATOM   2295  C   GLY B  65      -5.860   3.403  12.666  1.00 25.99           C  
ATOM   2296  O   GLY B  65      -6.921   3.037  13.153  1.00 28.46           O  
ATOM   2297  N   VAL B  66      -4.782   2.636  12.628  1.00 24.69           N  
ATOM   2298  CA  VAL B  66      -4.775   1.283  13.177  1.00 24.59           C  
ATOM   2299  C   VAL B  66      -3.685   1.152  14.228  1.00 24.23           C  
ATOM   2300  O   VAL B  66      -2.559   1.589  14.008  1.00 22.70           O  
ATOM   2301  CB  VAL B  66      -4.479   0.217  12.069  1.00 24.93           C  
ATOM   2302  CG1 VAL B  66      -4.191  -1.139  12.708  1.00 21.68           C  
ATOM   2303  CG2 VAL B  66      -5.649   0.112  11.112  1.00 21.59           C  
ATOM   2304  N   ASP B  67      -4.035   0.545  15.361  1.00 24.38           N  
ATOM   2305  CA  ASP B  67      -3.086   0.304  16.441  1.00 25.45           C  
ATOM   2306  C   ASP B  67      -3.501  -0.999  17.134  1.00 24.96           C  
ATOM   2307  O   ASP B  67      -4.691  -1.312  17.247  1.00 23.52           O  
ATOM   2308  CB  ASP B  67      -3.053   1.488  17.433  1.00 19.30           C  
ATOM   2309  CG  ASP B  67      -1.777   1.494  18.311  1.00 23.85           C  
ATOM   2310  OD1 ASP B  67      -1.696   0.682  19.256  1.00 20.83           O  
ATOM   2311  OD2 ASP B  67      -0.852   2.303  18.055  1.00 19.60           O  
ATOM   2312  N   ILE B  68      -2.510  -1.769  17.567  1.00 26.36           N  
ATOM   2313  CA  ILE B  68      -2.757  -3.041  18.237  1.00 27.31           C  
ATOM   2314  C   ILE B  68      -3.295  -2.864  19.656  1.00 27.12           C  
ATOM   2315  O   ILE B  68      -3.874  -3.785  20.228  1.00 27.84           O  
ATOM   2316  CB  ILE B  68      -1.454  -3.869  18.345  1.00 29.37           C  
ATOM   2317  CG1 ILE B  68      -1.773  -5.297  18.801  1.00 33.66           C  
ATOM   2318  CG2 ILE B  68      -0.520  -3.238  19.364  1.00 27.50           C  
ATOM   2319  CD1 ILE B  68      -2.518  -6.104  17.762  1.00 38.62           C  
ATOM   2320  N   SER B  69      -3.087  -1.688  20.233  1.00 24.92           N  
ATOM   2321  CA  SER B  69      -3.523  -1.449  21.605  1.00 27.99           C  
ATOM   2322  C   SER B  69      -4.945  -0.926  21.758  1.00 29.29           C  
ATOM   2323  O   SER B  69      -5.288   0.144  21.244  1.00 28.62           O  
ATOM   2324  CB  SER B  69      -2.555  -0.475  22.294  1.00 28.16           C  
ATOM   2325  OG  SER B  69      -3.083  -0.035  23.535  1.00 27.82           O  
ATOM   2326  N   GLU B  70      -5.762  -1.688  22.477  1.00 30.56           N  
ATOM   2327  CA  GLU B  70      -7.144  -1.298  22.755  1.00 33.36           C  
ATOM   2328  C   GLU B  70      -7.149   0.034  23.503  1.00 33.17           C  
ATOM   2329  O   GLU B  70      -7.908   0.937  23.168  1.00 30.75           O  
ATOM   2330  CB  GLU B  70      -7.833  -2.350  23.634  1.00 36.98           C  
ATOM   2331  CG  GLU B  70      -7.956  -3.722  23.005  1.00 43.58           C  
ATOM   2332  CD  GLU B  70      -9.232  -3.888  22.218  1.00 49.36           C  
ATOM   2333  OE1 GLU B  70      -9.528  -3.014  21.376  1.00 52.85           O  
ATOM   2334  OE2 GLU B  70      -9.941  -4.893  22.440  1.00 51.84           O  
ATOM   2335  N   ASP B  71      -6.299   0.154  24.520  1.00 33.05           N  
ATOM   2336  CA  ASP B  71      -6.251   1.388  25.296  1.00 35.03           C  
ATOM   2337  C   ASP B  71      -5.909   2.580  24.429  1.00 33.57           C  
ATOM   2338  O   ASP B  71      -6.446   3.671  24.607  1.00 31.27           O  
ATOM   2339  CB  ASP B  71      -5.231   1.281  26.433  1.00 38.35           C  
ATOM   2340  CG  ASP B  71      -5.549   0.155  27.387  1.00 42.73           C  
ATOM   2341  OD1 ASP B  71      -6.745  -0.181  27.525  1.00 45.48           O  
ATOM   2342  OD2 ASP B  71      -4.607  -0.390  27.999  1.00 44.98           O  
HETATM 2343  N   MSE B  72      -5.009   2.359  23.486  1.00 32.48           N  
HETATM 2344  CA  MSE B  72      -4.588   3.412  22.600  1.00 30.93           C  
HETATM 2345  C   MSE B  72      -5.768   3.848  21.734  1.00 29.38           C  
HETATM 2346  O   MSE B  72      -6.069   5.041  21.628  1.00 27.30           O  
HETATM 2347  CB  MSE B  72      -3.436   2.903  21.748  1.00 33.52           C  
HETATM 2348  CG  MSE B  72      -2.403   3.966  21.458  1.00 38.59           C  
HETATM 2349 SE   MSE B  72      -1.286   4.560  22.969  1.00 39.92          SE  
HETATM 2350  CE  MSE B  72      -2.371   4.400  24.531  1.00 40.20           C  
ATOM   2351  N   ILE B  73      -6.442   2.875  21.128  1.00 26.80           N  
ATOM   2352  CA  ILE B  73      -7.586   3.174  20.281  1.00 25.96           C  
ATOM   2353  C   ILE B  73      -8.744   3.778  21.081  1.00 27.21           C  
ATOM   2354  O   ILE B  73      -9.456   4.634  20.580  1.00 29.31           O  
ATOM   2355  CB  ILE B  73      -8.087   1.917  19.540  1.00 26.33           C  
ATOM   2356  CG1 ILE B  73      -6.972   1.349  18.654  1.00 25.89           C  
ATOM   2357  CG2 ILE B  73      -9.318   2.273  18.678  1.00 25.82           C  
ATOM   2358  CD1 ILE B  73      -6.499   2.288  17.574  1.00 26.85           C  
ATOM   2359  N   ARG B  74      -8.926   3.339  22.322  1.00 28.72           N  
ATOM   2360  CA  ARG B  74     -10.001   3.868  23.162  1.00 31.88           C  
ATOM   2361  C   ARG B  74      -9.758   5.367  23.375  1.00 32.91           C  
ATOM   2362  O   ARG B  74     -10.681   6.178  23.270  1.00 32.63           O  
ATOM   2363  CB  ARG B  74     -10.038   3.133  24.509  1.00 34.65           C  
ATOM   2364  CG  ARG B  74     -11.273   3.429  25.361  1.00 40.81           C  
ATOM   2365  CD  ARG B  74     -11.283   2.596  26.642  1.00 44.37           C  
ATOM   2366  NE  ARG B  74     -10.971   1.191  26.383  1.00 48.09           N  
ATOM   2367  CZ  ARG B  74      -9.882   0.574  26.837  1.00 50.15           C  
ATOM   2368  NH1 ARG B  74      -9.000   1.236  27.580  1.00 49.25           N  
ATOM   2369  NH2 ARG B  74      -9.665  -0.700  26.537  1.00 50.76           N  
ATOM   2370  N   LYS B  75      -8.512   5.737  23.658  1.00 31.62           N  
ATOM   2371  CA  LYS B  75      -8.167   7.144  23.856  1.00 31.91           C  
ATOM   2372  C   LYS B  75      -8.265   7.950  22.559  1.00 28.74           C  
ATOM   2373  O   LYS B  75      -8.695   9.101  22.572  1.00 27.93           O  
ATOM   2374  CB  LYS B  75      -6.750   7.286  24.438  1.00 33.28           C  
ATOM   2375  CG  LYS B  75      -6.686   7.145  25.955  1.00 39.49           C  
ATOM   2376  CD  LYS B  75      -5.277   7.413  26.503  1.00 40.97           C  
ATOM   2377  CE  LYS B  75      -4.370   6.197  26.390  1.00 45.06           C  
ATOM   2378  NZ  LYS B  75      -4.728   5.120  27.365  1.00 45.86           N  
ATOM   2379  N   ALA B  76      -7.858   7.355  21.441  1.00 26.98           N  
ATOM   2380  CA  ALA B  76      -7.924   8.055  20.160  1.00 26.10           C  
ATOM   2381  C   ALA B  76      -9.381   8.388  19.849  1.00 27.47           C  
ATOM   2382  O   ALA B  76      -9.685   9.455  19.326  1.00 28.03           O  
ATOM   2383  CB  ALA B  76      -7.335   7.183  19.044  1.00 23.14           C  
ATOM   2384  N   ARG B  77     -10.284   7.471  20.171  1.00 28.41           N  
ATOM   2385  CA  ARG B  77     -11.697   7.707  19.901  1.00 31.82           C  
ATOM   2386  C   ARG B  77     -12.224   8.814  20.807  1.00 32.39           C  
ATOM   2387  O   ARG B  77     -13.044   9.632  20.387  1.00 31.45           O  
ATOM   2388  CB  ARG B  77     -12.486   6.405  20.066  1.00 31.98           C  
ATOM   2389  CG  ARG B  77     -12.183   5.403  18.936  1.00 33.70           C  
ATOM   2390  CD  ARG B  77     -12.831   4.032  19.136  1.00 35.33           C  
ATOM   2391  NE  ARG B  77     -12.573   3.170  17.982  1.00 38.04           N  
ATOM   2392  CZ  ARG B  77     -12.643   1.841  17.996  1.00 37.30           C  
ATOM   2393  NH1 ARG B  77     -12.969   1.201  19.109  1.00 37.69           N  
ATOM   2394  NH2 ARG B  77     -12.356   1.149  16.899  1.00 36.78           N  
ATOM   2395  N   GLU B  78     -11.732   8.849  22.042  1.00 34.74           N  
ATOM   2396  CA  GLU B  78     -12.127   9.891  22.989  1.00 34.98           C  
ATOM   2397  C   GLU B  78     -11.692  11.230  22.390  1.00 35.63           C  
ATOM   2398  O   GLU B  78     -12.479  12.177  22.312  1.00 33.99           O  
ATOM   2399  CB  GLU B  78     -11.450   9.666  24.346  1.00 36.95           C  
ATOM   2400  CG  GLU B  78     -12.095   8.582  25.198  1.00 40.17           C  
ATOM   2401  CD  GLU B  78     -11.135   7.975  26.219  1.00 46.52           C  
ATOM   2402  OE1 GLU B  78     -10.271   8.712  26.756  1.00 47.36           O  
ATOM   2403  OE2 GLU B  78     -11.253   6.757  26.491  1.00 46.55           O  
ATOM   2404  N   TYR B  79     -10.440  11.301  21.946  1.00 34.59           N  
ATOM   2405  CA  TYR B  79      -9.933  12.531  21.354  1.00 35.21           C  
ATOM   2406  C   TYR B  79     -10.759  12.913  20.119  1.00 35.71           C  
ATOM   2407  O   TYR B  79     -11.066  14.086  19.907  1.00 34.17           O  
ATOM   2408  CB  TYR B  79      -8.461  12.373  20.955  1.00 37.21           C  
ATOM   2409  CG  TYR B  79      -7.470  12.513  22.096  1.00 40.69           C  
ATOM   2410  CD1 TYR B  79      -7.455  13.657  22.902  1.00 42.97           C  
ATOM   2411  CD2 TYR B  79      -6.516  11.527  22.337  1.00 40.79           C  
ATOM   2412  CE1 TYR B  79      -6.509  13.817  23.915  1.00 43.30           C  
ATOM   2413  CE2 TYR B  79      -5.565  11.672  23.343  1.00 42.71           C  
ATOM   2414  CZ  TYR B  79      -5.563  12.819  24.130  1.00 43.92           C  
ATOM   2415  OH  TYR B  79      -4.614  12.965  25.119  1.00 41.82           O  
ATOM   2416  N   ALA B  80     -11.117  11.911  19.319  1.00 34.21           N  
ATOM   2417  CA  ALA B  80     -11.899  12.133  18.103  1.00 35.92           C  
ATOM   2418  C   ALA B  80     -13.282  12.701  18.421  1.00 35.97           C  
ATOM   2419  O   ALA B  80     -13.802  13.530  17.683  1.00 36.32           O  
ATOM   2420  CB  ALA B  80     -12.035  10.819  17.315  1.00 32.72           C  
ATOM   2421  N   LYS B  81     -13.866  12.253  19.524  1.00 39.45           N  
ATOM   2422  CA  LYS B  81     -15.185  12.718  19.944  1.00 43.00           C  
ATOM   2423  C   LYS B  81     -15.140  14.209  20.301  1.00 43.73           C  
ATOM   2424  O   LYS B  81     -16.005  14.982  19.892  1.00 42.72           O  
ATOM   2425  CB  LYS B  81     -15.641  11.906  21.154  1.00 44.79           C  
ATOM   2426  CG  LYS B  81     -17.132  11.969  21.463  1.00 49.58           C  
ATOM   2427  CD  LYS B  81     -17.444  11.158  22.730  1.00 52.31           C  
ATOM   2428  CE  LYS B  81     -16.874   9.738  22.644  1.00 53.57           C  
ATOM   2429  NZ  LYS B  81     -16.817   9.058  23.973  1.00 54.71           N  
ATOM   2430  N   SER B  82     -14.120  14.610  21.054  1.00 43.28           N  
ATOM   2431  CA  SER B  82     -13.982  16.001  21.468  1.00 44.47           C  
ATOM   2432  C   SER B  82     -13.583  16.920  20.318  1.00 43.86           C  
ATOM   2433  O   SER B  82     -13.772  18.130  20.393  1.00 42.83           O  
ATOM   2434  CB  SER B  82     -12.955  16.119  22.597  1.00 44.63           C  
ATOM   2435  OG  SER B  82     -11.662  15.769  22.140  1.00 49.31           O  
ATOM   2436  N   ARG B  83     -13.025  16.347  19.256  1.00 44.28           N  
ATOM   2437  CA  ARG B  83     -12.621  17.134  18.095  1.00 44.19           C  
ATOM   2438  C   ARG B  83     -13.634  16.954  16.965  1.00 43.34           C  
ATOM   2439  O   ARG B  83     -13.494  17.547  15.894  1.00 42.33           O  
ATOM   2440  CB  ARG B  83     -11.225  16.705  17.613  1.00 45.01           C  
ATOM   2441  CG  ARG B  83     -10.137  16.874  18.663  1.00 46.08           C  
ATOM   2442  CD  ARG B  83      -8.726  16.704  18.115  1.00 46.59           C  
ATOM   2443  NE  ARG B  83      -7.744  17.111  19.122  1.00 48.19           N  
ATOM   2444  CZ  ARG B  83      -6.452  17.330  18.888  1.00 47.92           C  
ATOM   2445  NH1 ARG B  83      -5.945  17.184  17.670  1.00 46.02           N  
ATOM   2446  NH2 ARG B  83      -5.664  17.715  19.883  1.00 48.01           N  
ATOM   2447  N   GLU B  84     -14.648  16.133  17.219  1.00 42.25           N  
ATOM   2448  CA  GLU B  84     -15.683  15.846  16.228  1.00 42.92           C  
ATOM   2449  C   GLU B  84     -15.062  15.257  14.962  1.00 41.99           C  
ATOM   2450  O   GLU B  84     -15.637  15.344  13.875  1.00 42.16           O  
ATOM   2451  CB  GLU B  84     -16.465  17.124  15.895  1.00 44.32           C  
ATOM   2452  CG  GLU B  84     -17.312  17.627  17.061  1.00 46.71           C  
ATOM   2453  CD  GLU B  84     -18.057  18.914  16.750  1.00 47.41           C  
ATOM   2454  OE1 GLU B  84     -18.775  19.405  17.642  1.00 46.48           O  
ATOM   2455  OE2 GLU B  84     -17.925  19.433  15.619  1.00 50.31           O  
ATOM   2456  N   SER B  85     -13.889  14.643  15.122  1.00 38.52           N  
ATOM   2457  CA  SER B  85     -13.146  14.040  14.014  1.00 35.58           C  
ATOM   2458  C   SER B  85     -13.872  12.894  13.309  1.00 33.84           C  
ATOM   2459  O   SER B  85     -14.672  12.182  13.913  1.00 32.83           O  
ATOM   2460  CB  SER B  85     -11.794  13.515  14.518  1.00 33.21           C  
ATOM   2461  OG  SER B  85     -11.126  12.780  13.505  1.00 28.35           O  
ATOM   2462  N   ASN B  86     -13.572  12.706  12.029  1.00 31.24           N  
ATOM   2463  CA  ASN B  86     -14.187  11.614  11.282  1.00 33.12           C  
ATOM   2464  C   ASN B  86     -13.180  10.516  10.944  1.00 34.01           C  
ATOM   2465  O   ASN B  86     -13.469   9.609  10.149  1.00 33.51           O  
ATOM   2466  CB  ASN B  86     -14.852  12.156  10.018  1.00 31.51           C  
ATOM   2467  CG  ASN B  86     -16.048  13.028  10.340  1.00 31.92           C  
ATOM   2468  OD1 ASN B  86     -17.003  12.572  10.974  1.00 33.93           O  
ATOM   2469  ND2 ASN B  86     -15.999  14.285   9.924  1.00 32.45           N  
ATOM   2470  N   VAL B  87     -11.996  10.602  11.551  1.00 33.28           N  
ATOM   2471  CA  VAL B  87     -10.955   9.596  11.339  1.00 33.11           C  
ATOM   2472  C   VAL B  87     -11.506   8.273  11.843  1.00 31.81           C  
ATOM   2473  O   VAL B  87     -12.183   8.225  12.864  1.00 33.44           O  
ATOM   2474  CB  VAL B  87      -9.660   9.909  12.145  1.00 33.83           C  
ATOM   2475  CG1 VAL B  87      -8.666   8.745  12.019  1.00 34.85           C  
ATOM   2476  CG2 VAL B  87      -9.035  11.195  11.657  1.00 33.47           C  
ATOM   2477  N   GLU B  88     -11.224   7.199  11.120  1.00 34.07           N  
ATOM   2478  CA  GLU B  88     -11.677   5.878  11.525  1.00 35.10           C  
ATOM   2479  C   GLU B  88     -10.522   5.164  12.230  1.00 34.33           C  
ATOM   2480  O   GLU B  88      -9.473   4.927  11.634  1.00 32.59           O  
ATOM   2481  CB  GLU B  88     -12.122   5.072  10.300  1.00 36.84           C  
ATOM   2482  CG  GLU B  88     -12.288   3.592  10.578  1.00 40.61           C  
ATOM   2483  CD  GLU B  88     -12.655   2.795   9.347  1.00 42.26           C  
ATOM   2484  OE1 GLU B  88     -12.016   2.988   8.290  1.00 44.13           O  
ATOM   2485  OE2 GLU B  88     -13.576   1.960   9.443  1.00 44.95           O  
ATOM   2486  N   PHE B  89     -10.715   4.843  13.503  1.00 33.20           N  
ATOM   2487  CA  PHE B  89      -9.687   4.154  14.268  1.00 33.75           C  
ATOM   2488  C   PHE B  89     -10.108   2.698  14.416  1.00 33.85           C  
ATOM   2489  O   PHE B  89     -11.277   2.405  14.681  1.00 34.88           O  
ATOM   2490  CB  PHE B  89      -9.505   4.814  15.648  1.00 29.14           C  
ATOM   2491  CG  PHE B  89      -8.843   6.172  15.592  1.00 28.53           C  
ATOM   2492  CD1 PHE B  89      -7.493   6.292  15.266  1.00 28.39           C  
ATOM   2493  CD2 PHE B  89      -9.574   7.329  15.842  1.00 26.64           C  
ATOM   2494  CE1 PHE B  89      -6.884   7.541  15.189  1.00 28.08           C  
ATOM   2495  CE2 PHE B  89      -8.980   8.589  15.768  1.00 26.40           C  
ATOM   2496  CZ  PHE B  89      -7.627   8.698  15.439  1.00 28.91           C  
ATOM   2497  N   ILE B  90      -9.150   1.792  14.237  1.00 33.43           N  
ATOM   2498  CA  ILE B  90      -9.402   0.354  14.327  1.00 33.16           C  
ATOM   2499  C   ILE B  90      -8.290  -0.345  15.113  1.00 31.72           C  
ATOM   2500  O   ILE B  90      -7.116  -0.018  14.957  1.00 29.99           O  
ATOM   2501  CB  ILE B  90      -9.439  -0.306  12.916  1.00 33.84           C  
ATOM   2502  CG1 ILE B  90     -10.346   0.482  11.968  1.00 37.98           C  
ATOM   2503  CG2 ILE B  90      -9.940  -1.744  13.029  1.00 33.57           C  
ATOM   2504  CD1 ILE B  90     -10.353  -0.055  10.531  1.00 38.37           C  
ATOM   2505  N   VAL B  91      -8.661  -1.301  15.961  1.00 31.41           N  
ATOM   2506  CA  VAL B  91      -7.669  -2.059  16.707  1.00 30.50           C  
ATOM   2507  C   VAL B  91      -7.155  -3.089  15.710  1.00 31.39           C  
ATOM   2508  O   VAL B  91      -7.901  -3.973  15.307  1.00 34.42           O  
ATOM   2509  CB  VAL B  91      -8.291  -2.805  17.901  1.00 29.18           C  
ATOM   2510  CG1 VAL B  91      -7.285  -3.798  18.475  1.00 28.07           C  
ATOM   2511  CG2 VAL B  91      -8.720  -1.816  18.966  1.00 27.44           C  
ATOM   2512  N   GLY B  92      -5.895  -2.970  15.304  1.00 30.78           N  
ATOM   2513  CA  GLY B  92      -5.345  -3.904  14.338  1.00 28.95           C  
ATOM   2514  C   GLY B  92      -3.846  -4.142  14.461  1.00 29.08           C  
ATOM   2515  O   GLY B  92      -3.149  -3.451  15.215  1.00 25.10           O  
ATOM   2516  N   ASP B  93      -3.359  -5.110  13.685  1.00 27.00           N  
ATOM   2517  CA  ASP B  93      -1.955  -5.522  13.698  1.00 27.91           C  
ATOM   2518  C   ASP B  93      -1.226  -5.148  12.409  1.00 27.86           C  
ATOM   2519  O   ASP B  93      -1.571  -5.637  11.328  1.00 28.74           O  
ATOM   2520  CB  ASP B  93      -1.885  -7.038  13.892  1.00 28.75           C  
ATOM   2521  CG  ASP B  93      -0.508  -7.524  14.340  1.00 24.10           C  
ATOM   2522  OD1 ASP B  93       0.515  -6.864  14.043  1.00 22.23           O  
ATOM   2523  OD2 ASP B  93      -0.469  -8.588  14.983  1.00 23.85           O  
ATOM   2524  N   ALA B  94      -0.210  -4.296  12.527  1.00 24.33           N  
ATOM   2525  CA  ALA B  94       0.568  -3.864  11.368  1.00 25.63           C  
ATOM   2526  C   ALA B  94       1.266  -5.026  10.664  1.00 25.97           C  
ATOM   2527  O   ALA B  94       1.659  -4.912   9.498  1.00 25.47           O  
ATOM   2528  CB  ALA B  94       1.613  -2.823  11.794  1.00 24.74           C  
ATOM   2529  N   ARG B  95       1.425  -6.145  11.365  1.00 26.48           N  
ATOM   2530  CA  ARG B  95       2.104  -7.295  10.772  1.00 29.18           C  
ATOM   2531  C   ARG B  95       1.198  -8.041   9.804  1.00 30.61           C  
ATOM   2532  O   ARG B  95       1.671  -8.797   8.959  1.00 32.51           O  
ATOM   2533  CB  ARG B  95       2.624  -8.221  11.874  1.00 26.69           C  
ATOM   2534  CG  ARG B  95       3.636  -7.524  12.792  1.00 27.38           C  
ATOM   2535  CD  ARG B  95       3.921  -8.333  14.046  1.00 26.47           C  
ATOM   2536  NE  ARG B  95       2.697  -8.647  14.773  1.00 25.55           N  
ATOM   2537  CZ  ARG B  95       2.642  -9.465  15.818  1.00 25.25           C  
ATOM   2538  NH1 ARG B  95       3.746 -10.049  16.265  1.00 20.77           N  
ATOM   2539  NH2 ARG B  95       1.482  -9.721  16.397  1.00 26.11           N  
ATOM   2540  N   LYS B  96      -0.106  -7.803   9.919  1.00 32.97           N  
ATOM   2541  CA  LYS B  96      -1.086  -8.421   9.035  1.00 33.51           C  
ATOM   2542  C   LYS B  96      -2.392  -7.629   9.094  1.00 32.91           C  
ATOM   2543  O   LYS B  96      -3.191  -7.778  10.021  1.00 32.41           O  
ATOM   2544  CB  LYS B  96      -1.318  -9.882   9.433  1.00 36.87           C  
ATOM   2545  CG  LYS B  96      -2.413 -10.569   8.631  1.00 42.74           C  
ATOM   2546  CD  LYS B  96      -2.194 -10.401   7.135  1.00 44.89           C  
ATOM   2547  CE  LYS B  96      -3.395 -10.882   6.344  1.00 47.75           C  
ATOM   2548  NZ  LYS B  96      -3.178 -10.716   4.883  1.00 50.50           N  
ATOM   2549  N   LEU B  97      -2.594  -6.780   8.093  1.00 32.24           N  
ATOM   2550  CA  LEU B  97      -3.779  -5.932   8.012  1.00 32.98           C  
ATOM   2551  C   LEU B  97      -4.927  -6.580   7.236  1.00 34.40           C  
ATOM   2552  O   LEU B  97      -4.710  -7.431   6.381  1.00 35.26           O  
ATOM   2553  CB  LEU B  97      -3.408  -4.607   7.353  1.00 29.52           C  
ATOM   2554  CG  LEU B  97      -2.258  -3.831   8.001  1.00 28.90           C  
ATOM   2555  CD1 LEU B  97      -1.799  -2.729   7.064  1.00 25.98           C  
ATOM   2556  CD2 LEU B  97      -2.708  -3.265   9.329  1.00 29.89           C  
ATOM   2557  N   SER B  98      -6.150  -6.152   7.529  1.00 35.05           N  
ATOM   2558  CA  SER B  98      -7.332  -6.700   6.872  1.00 37.65           C  
ATOM   2559  C   SER B  98      -7.723  -5.963   5.589  1.00 38.54           C  
ATOM   2560  O   SER B  98      -8.616  -6.405   4.867  1.00 39.24           O  
ATOM   2561  CB  SER B  98      -8.519  -6.678   7.837  1.00 37.32           C  
ATOM   2562  OG  SER B  98      -8.875  -5.344   8.153  1.00 36.94           O  
ATOM   2563  N   PHE B  99      -7.060  -4.846   5.306  1.00 37.37           N  
ATOM   2564  CA  PHE B  99      -7.377  -4.070   4.116  1.00 40.06           C  
ATOM   2565  C   PHE B  99      -7.067  -4.835   2.838  1.00 41.45           C  
ATOM   2566  O   PHE B  99      -6.207  -5.719   2.819  1.00 40.63           O  
ATOM   2567  CB  PHE B  99      -6.601  -2.751   4.113  1.00 39.61           C  
ATOM   2568  CG  PHE B  99      -6.775  -1.945   5.361  1.00 39.81           C  
ATOM   2569  CD1 PHE B  99      -8.030  -1.480   5.737  1.00 39.82           C  
ATOM   2570  CD2 PHE B  99      -5.682  -1.662   6.176  1.00 39.01           C  
ATOM   2571  CE1 PHE B  99      -8.197  -0.743   6.908  1.00 40.10           C  
ATOM   2572  CE2 PHE B  99      -5.837  -0.930   7.342  1.00 39.46           C  
ATOM   2573  CZ  PHE B  99      -7.095  -0.467   7.713  1.00 38.71           C  
ATOM   2574  N   GLU B 100      -7.778  -4.492   1.769  1.00 42.83           N  
ATOM   2575  CA  GLU B 100      -7.563  -5.138   0.481  1.00 44.43           C  
ATOM   2576  C   GLU B 100      -6.302  -4.541  -0.113  1.00 43.35           C  
ATOM   2577  O   GLU B 100      -5.855  -3.479   0.327  1.00 42.92           O  
ATOM   2578  CB  GLU B 100      -8.754  -4.891  -0.453  1.00 46.56           C  
ATOM   2579  CG  GLU B 100     -10.052  -5.563  -0.013  1.00 51.16           C  
ATOM   2580  CD  GLU B 100      -9.897  -7.064   0.193  1.00 54.61           C  
ATOM   2581  OE1 GLU B 100      -9.324  -7.733  -0.698  1.00 56.27           O  
ATOM   2582  OE2 GLU B 100     -10.355  -7.573   1.242  1.00 54.98           O  
ATOM   2583  N   ASP B 101      -5.723  -5.213  -1.103  1.00 41.64           N  
ATOM   2584  CA  ASP B 101      -4.508  -4.719  -1.736  1.00 42.03           C  
ATOM   2585  C   ASP B 101      -4.759  -3.371  -2.406  1.00 41.91           C  
ATOM   2586  O   ASP B 101      -5.893  -3.049  -2.767  1.00 41.57           O  
ATOM   2587  CB  ASP B 101      -3.998  -5.706  -2.795  1.00 46.25           C  
ATOM   2588  CG  ASP B 101      -3.959  -7.147  -2.296  1.00 49.70           C  
ATOM   2589  OD1 ASP B 101      -3.525  -7.383  -1.148  1.00 50.17           O  
ATOM   2590  OD2 ASP B 101      -4.355  -8.049  -3.066  1.00 52.80           O  
ATOM   2591  N   LYS B 102      -3.693  -2.594  -2.562  1.00 40.49           N  
ATOM   2592  CA  LYS B 102      -3.755  -1.283  -3.205  1.00 41.45           C  
ATOM   2593  C   LYS B 102      -4.922  -0.414  -2.748  1.00 40.94           C  
ATOM   2594  O   LYS B 102      -5.659   0.129  -3.579  1.00 38.98           O  
ATOM   2595  CB  LYS B 102      -3.824  -1.455  -4.723  1.00 42.57           C  
ATOM   2596  CG  LYS B 102      -2.644  -2.197  -5.322  1.00 43.89           C  
ATOM   2597  CD  LYS B 102      -2.875  -2.499  -6.799  1.00 45.75           C  
ATOM   2598  CE  LYS B 102      -1.663  -3.177  -7.420  1.00 45.63           C  
ATOM   2599  NZ  LYS B 102      -1.299  -4.416  -6.679  1.00 47.28           N  
ATOM   2600  N   THR B 103      -5.077  -0.268  -1.434  1.00 39.29           N  
ATOM   2601  CA  THR B 103      -6.159   0.536  -0.876  1.00 38.77           C  
ATOM   2602  C   THR B 103      -5.775   1.990  -0.615  1.00 37.79           C  
ATOM   2603  O   THR B 103      -6.556   2.900  -0.883  1.00 37.19           O  
ATOM   2604  CB  THR B 103      -6.661  -0.042   0.472  1.00 39.04           C  
ATOM   2605  OG1 THR B 103      -7.227  -1.340   0.271  1.00 39.12           O  
ATOM   2606  CG2 THR B 103      -7.720   0.869   1.081  1.00 42.15           C  
ATOM   2607  N   PHE B 104      -4.565   2.206  -0.107  1.00 36.18           N  
ATOM   2608  CA  PHE B 104      -4.119   3.541   0.263  1.00 33.94           C  
ATOM   2609  C   PHE B 104      -3.156   4.274  -0.660  1.00 33.64           C  
ATOM   2610  O   PHE B 104      -2.373   3.669  -1.389  1.00 33.09           O  
ATOM   2611  CB  PHE B 104      -3.486   3.489   1.660  1.00 34.38           C  
ATOM   2612  CG  PHE B 104      -4.393   2.936   2.725  1.00 32.38           C  
ATOM   2613  CD1 PHE B 104      -5.294   3.763   3.391  1.00 31.54           C  
ATOM   2614  CD2 PHE B 104      -4.361   1.584   3.045  1.00 28.50           C  
ATOM   2615  CE1 PHE B 104      -6.150   3.248   4.363  1.00 30.69           C  
ATOM   2616  CE2 PHE B 104      -5.212   1.061   4.012  1.00 30.72           C  
ATOM   2617  CZ  PHE B 104      -6.112   1.894   4.672  1.00 27.18           C  
ATOM   2618  N   ASP B 105      -3.223   5.601  -0.600  1.00 32.27           N  
ATOM   2619  CA  ASP B 105      -2.337   6.460  -1.368  1.00 34.04           C  
ATOM   2620  C   ASP B 105      -1.077   6.686  -0.526  1.00 34.50           C  
ATOM   2621  O   ASP B 105       0.009   6.933  -1.057  1.00 35.67           O  
ATOM   2622  CB  ASP B 105      -3.020   7.802  -1.657  1.00 34.98           C  
ATOM   2623  CG  ASP B 105      -4.244   7.653  -2.541  1.00 35.31           C  
ATOM   2624  OD1 ASP B 105      -4.102   7.149  -3.670  1.00 34.89           O  
ATOM   2625  OD2 ASP B 105      -5.348   8.033  -2.105  1.00 39.34           O  
ATOM   2626  N   TYR B 106      -1.241   6.601   0.794  1.00 33.80           N  
ATOM   2627  CA  TYR B 106      -0.136   6.784   1.737  1.00 33.34           C  
ATOM   2628  C   TYR B 106      -0.293   5.899   2.966  1.00 30.88           C  
ATOM   2629  O   TYR B 106      -1.404   5.543   3.361  1.00 31.71           O  
ATOM   2630  CB  TYR B 106      -0.064   8.223   2.263  1.00 31.47           C  
ATOM   2631  CG  TYR B 106       0.030   9.326   1.232  1.00 34.52           C  
ATOM   2632  CD1 TYR B 106      -1.116   9.928   0.716  1.00 33.05           C  
ATOM   2633  CD2 TYR B 106       1.270   9.804   0.812  1.00 34.03           C  
ATOM   2634  CE1 TYR B 106      -1.027  10.987  -0.186  1.00 35.19           C  
ATOM   2635  CE2 TYR B 106       1.370  10.853  -0.085  1.00 36.02           C  
ATOM   2636  CZ  TYR B 106       0.221  11.444  -0.580  1.00 34.83           C  
ATOM   2637  OH  TYR B 106       0.337  12.485  -1.474  1.00 35.90           O  
ATOM   2638  N   VAL B 107       0.843   5.577   3.572  1.00 30.63           N  
ATOM   2639  CA  VAL B 107       0.902   4.811   4.810  1.00 28.19           C  
ATOM   2640  C   VAL B 107       2.025   5.480   5.600  1.00 28.69           C  
ATOM   2641  O   VAL B 107       3.166   5.503   5.139  1.00 29.42           O  
ATOM   2642  CB  VAL B 107       1.289   3.324   4.588  1.00 29.24           C  
ATOM   2643  CG1 VAL B 107       1.355   2.590   5.938  1.00 27.64           C  
ATOM   2644  CG2 VAL B 107       0.280   2.650   3.682  1.00 25.12           C  
ATOM   2645  N   ILE B 108       1.700   6.063   6.755  1.00 26.02           N  
ATOM   2646  CA  ILE B 108       2.721   6.697   7.592  1.00 26.83           C  
ATOM   2647  C   ILE B 108       2.994   5.779   8.779  1.00 24.07           C  
ATOM   2648  O   ILE B 108       2.077   5.182   9.339  1.00 23.42           O  
ATOM   2649  CB  ILE B 108       2.297   8.104   8.130  1.00 26.93           C  
ATOM   2650  CG1 ILE B 108       1.089   7.981   9.058  1.00 28.25           C  
ATOM   2651  CG2 ILE B 108       1.979   9.039   6.969  1.00 32.02           C  
ATOM   2652  CD1 ILE B 108       0.727   9.287   9.758  1.00 25.61           C  
ATOM   2653  N   PHE B 109       4.262   5.692   9.160  1.00 24.87           N  
ATOM   2654  CA  PHE B 109       4.714   4.826  10.252  1.00 23.42           C  
ATOM   2655  C   PHE B 109       5.708   5.653  11.070  1.00 23.48           C  
ATOM   2656  O   PHE B 109       6.887   5.721  10.744  1.00 22.01           O  
ATOM   2657  CB  PHE B 109       5.382   3.604   9.614  1.00 24.31           C  
ATOM   2658  CG  PHE B 109       5.817   2.555  10.579  1.00 22.19           C  
ATOM   2659  CD1 PHE B 109       4.911   1.975  11.455  1.00 23.53           C  
ATOM   2660  CD2 PHE B 109       7.126   2.076  10.542  1.00 24.30           C  
ATOM   2661  CE1 PHE B 109       5.293   0.929  12.280  1.00 25.02           C  
ATOM   2662  CE2 PHE B 109       7.523   1.026  11.362  1.00 24.86           C  
ATOM   2663  CZ  PHE B 109       6.602   0.449  12.233  1.00 24.20           C  
ATOM   2664  N   ILE B 110       5.212   6.275  12.137  1.00 24.22           N  
ATOM   2665  CA  ILE B 110       6.019   7.167  12.971  1.00 24.59           C  
ATOM   2666  C   ILE B 110       6.348   6.664  14.384  1.00 23.60           C  
ATOM   2667  O   ILE B 110       5.474   6.174  15.084  1.00 23.09           O  
ATOM   2668  CB  ILE B 110       5.288   8.547  13.119  1.00 25.89           C  
ATOM   2669  CG1 ILE B 110       4.956   9.123  11.734  1.00 27.38           C  
ATOM   2670  CG2 ILE B 110       6.160   9.520  13.905  1.00 25.89           C  
ATOM   2671  CD1 ILE B 110       4.082  10.372  11.775  1.00 29.28           C  
ATOM   2672  N   ASP B 111       7.608   6.824  14.792  1.00 25.22           N  
ATOM   2673  CA  ASP B 111       8.090   6.439  16.125  1.00 26.20           C  
ATOM   2674  C   ASP B 111       7.538   5.135  16.708  1.00 24.24           C  
ATOM   2675  O   ASP B 111       7.088   5.120  17.839  1.00 19.58           O  
ATOM   2676  CB  ASP B 111       7.787   7.553  17.147  1.00 29.30           C  
ATOM   2677  CG  ASP B 111       8.548   8.840  16.871  1.00 34.23           C  
ATOM   2678  OD1 ASP B 111       9.744   8.759  16.516  1.00 38.45           O  
ATOM   2679  OD2 ASP B 111       7.953   9.936  17.028  1.00 33.74           O  
ATOM   2680  N   SER B 112       7.566   4.034  15.978  1.00 24.71           N  
ATOM   2681  CA  SER B 112       7.022   2.828  16.585  1.00 26.63           C  
ATOM   2682  C   SER B 112       7.878   1.604  16.327  1.00 24.46           C  
ATOM   2683  O   SER B 112       7.505   0.485  16.682  1.00 24.33           O  
ATOM   2684  CB  SER B 112       5.599   2.584  16.072  1.00 26.12           C  
ATOM   2685  OG  SER B 112       5.642   1.984  14.800  1.00 33.78           O  
ATOM   2686  N   ILE B 113       9.047   1.827  15.742  1.00 23.04           N  
ATOM   2687  CA  ILE B 113       9.923   0.730  15.388  1.00 24.26           C  
ATOM   2688  C   ILE B 113      10.494  -0.102  16.551  1.00 22.79           C  
ATOM   2689  O   ILE B 113      10.831  -1.265  16.355  1.00 23.09           O  
ATOM   2690  CB  ILE B 113      11.064   1.247  14.459  1.00 26.58           C  
ATOM   2691  CG1 ILE B 113      11.592   0.102  13.608  1.00 28.04           C  
ATOM   2692  CG2 ILE B 113      12.194   1.883  15.281  1.00 26.06           C  
ATOM   2693  CD1 ILE B 113      12.700   0.526  12.659  1.00 30.93           C  
ATOM   2694  N   VAL B 114      10.573   0.459  17.756  1.00 21.25           N  
ATOM   2695  CA  VAL B 114      11.115  -0.297  18.889  1.00 22.28           C  
ATOM   2696  C   VAL B 114      10.265  -1.509  19.256  1.00 21.17           C  
ATOM   2697  O   VAL B 114      10.722  -2.392  19.967  1.00 21.77           O  
ATOM   2698  CB  VAL B 114      11.274   0.578  20.160  1.00 22.71           C  
ATOM   2699  CG1 VAL B 114      12.215   1.735  19.873  1.00 19.83           C  
ATOM   2700  CG2 VAL B 114       9.898   1.079  20.635  1.00 21.74           C  
ATOM   2701  N   HIS B 115       9.035  -1.557  18.758  1.00 22.48           N  
ATOM   2702  CA  HIS B 115       8.142  -2.676  19.050  1.00 21.29           C  
ATOM   2703  C   HIS B 115       8.352  -3.869  18.132  1.00 20.81           C  
ATOM   2704  O   HIS B 115       7.789  -4.931  18.373  1.00 18.63           O  
ATOM   2705  CB  HIS B 115       6.686  -2.241  18.914  1.00 22.59           C  
ATOM   2706  CG  HIS B 115       6.215  -1.340  20.007  1.00 23.39           C  
ATOM   2707  ND1 HIS B 115       5.763  -1.816  21.219  1.00 22.42           N  
ATOM   2708  CD2 HIS B 115       6.116   0.009  20.070  1.00 21.72           C  
ATOM   2709  CE1 HIS B 115       5.404  -0.798  21.981  1.00 24.49           C  
ATOM   2710  NE2 HIS B 115       5.608   0.320  21.307  1.00 24.00           N  
ATOM   2711  N   PHE B 116       9.161  -3.712  17.088  1.00 21.10           N  
ATOM   2712  CA  PHE B 116       9.342  -4.806  16.134  1.00 21.46           C  
ATOM   2713  C   PHE B 116      10.741  -5.417  16.001  1.00 21.67           C  
ATOM   2714  O   PHE B 116      11.712  -4.710  15.750  1.00 22.05           O  
ATOM   2715  CB  PHE B 116       8.889  -4.342  14.738  1.00 21.22           C  
ATOM   2716  CG  PHE B 116       7.508  -3.745  14.709  1.00 23.98           C  
ATOM   2717  CD1 PHE B 116       6.417  -4.491  14.261  1.00 21.26           C  
ATOM   2718  CD2 PHE B 116       7.287  -2.453  15.171  1.00 21.29           C  
ATOM   2719  CE1 PHE B 116       5.129  -3.959  14.273  1.00 21.49           C  
ATOM   2720  CE2 PHE B 116       5.996  -1.907  15.187  1.00 24.87           C  
ATOM   2721  CZ  PHE B 116       4.916  -2.666  14.738  1.00 22.28           C  
ATOM   2722  N   GLU B 117      10.835  -6.733  16.166  1.00 22.18           N  
ATOM   2723  CA  GLU B 117      12.113  -7.419  15.968  1.00 23.30           C  
ATOM   2724  C   GLU B 117      12.227  -7.527  14.429  1.00 22.72           C  
ATOM   2725  O   GLU B 117      11.280  -7.204  13.712  1.00 23.28           O  
ATOM   2726  CB  GLU B 117      12.099  -8.808  16.631  1.00 22.33           C  
ATOM   2727  CG  GLU B 117      11.143  -9.824  16.033  1.00 25.49           C  
ATOM   2728  CD  GLU B 117      11.125 -11.153  16.803  1.00 30.29           C  
ATOM   2729  OE1 GLU B 117      12.204 -11.716  17.077  1.00 34.40           O  
ATOM   2730  OE2 GLU B 117      10.026 -11.644  17.127  1.00 30.61           O  
ATOM   2731  N   PRO B 118      13.373  -7.973  13.906  1.00 23.55           N  
ATOM   2732  CA  PRO B 118      13.515  -8.074  12.449  1.00 22.93           C  
ATOM   2733  C   PRO B 118      12.435  -8.813  11.663  1.00 23.86           C  
ATOM   2734  O   PRO B 118      11.918  -8.285  10.675  1.00 23.23           O  
ATOM   2735  CB  PRO B 118      14.904  -8.685  12.286  1.00 25.23           C  
ATOM   2736  CG  PRO B 118      15.658  -8.062  13.425  1.00 20.95           C  
ATOM   2737  CD  PRO B 118      14.667  -8.200  14.575  1.00 22.25           C  
ATOM   2738  N   LEU B 119      12.064 -10.015  12.080  1.00 22.33           N  
ATOM   2739  CA  LEU B 119      11.041 -10.726  11.323  1.00 22.50           C  
ATOM   2740  C   LEU B 119       9.679 -10.036  11.382  1.00 22.86           C  
ATOM   2741  O   LEU B 119       8.897 -10.121  10.433  1.00 23.95           O  
ATOM   2742  CB  LEU B 119      10.932 -12.181  11.787  1.00 25.80           C  
ATOM   2743  CG  LEU B 119      10.386 -12.493  13.175  1.00 29.19           C  
ATOM   2744  CD1 LEU B 119       8.859 -12.519  13.102  1.00 33.13           C  
ATOM   2745  CD2 LEU B 119      10.906 -13.844  13.639  1.00 30.30           C  
ATOM   2746  N   GLU B 120       9.392  -9.336  12.474  1.00 20.94           N  
ATOM   2747  CA  GLU B 120       8.109  -8.648  12.583  1.00 23.09           C  
ATOM   2748  C   GLU B 120       8.078  -7.386  11.717  1.00 23.03           C  
ATOM   2749  O   GLU B 120       7.067  -7.108  11.073  1.00 24.24           O  
ATOM   2750  CB  GLU B 120       7.800  -8.292  14.043  1.00 22.61           C  
ATOM   2751  CG  GLU B 120       7.739  -9.497  14.969  1.00 25.16           C  
ATOM   2752  CD  GLU B 120       7.597  -9.115  16.446  1.00 26.42           C  
ATOM   2753  OE1 GLU B 120       8.233  -8.121  16.882  1.00 24.63           O  
ATOM   2754  OE2 GLU B 120       6.856  -9.822  17.171  1.00 28.78           O  
ATOM   2755  N   LEU B 121       9.170  -6.622  11.711  1.00 23.07           N  
ATOM   2756  CA  LEU B 121       9.231  -5.404  10.896  1.00 24.73           C  
ATOM   2757  C   LEU B 121       9.156  -5.819   9.426  1.00 25.35           C  
ATOM   2758  O   LEU B 121       8.605  -5.103   8.601  1.00 26.27           O  
ATOM   2759  CB  LEU B 121      10.527  -4.618  11.135  1.00 22.79           C  
ATOM   2760  CG  LEU B 121      10.555  -3.252  10.410  1.00 23.91           C  
ATOM   2761  CD1 LEU B 121       9.489  -2.341  11.022  1.00 24.41           C  
ATOM   2762  CD2 LEU B 121      11.922  -2.596  10.520  1.00 23.32           C  
ATOM   2763  N   ASN B 122       9.706  -6.986   9.109  1.00 26.22           N  
ATOM   2764  CA  ASN B 122       9.673  -7.504   7.744  1.00 27.53           C  
ATOM   2765  C   ASN B 122       8.226  -7.750   7.311  1.00 28.30           C  
ATOM   2766  O   ASN B 122       7.848  -7.428   6.184  1.00 31.18           O  
ATOM   2767  CB  ASN B 122      10.458  -8.814   7.643  1.00 25.77           C  
ATOM   2768  CG  ASN B 122      10.564  -9.320   6.211  1.00 28.13           C  
ATOM   2769  OD1 ASN B 122      11.159  -8.665   5.357  1.00 27.68           O  
ATOM   2770  ND2 ASN B 122       9.987 -10.491   5.945  1.00 27.88           N  
ATOM   2771  N   GLN B 123       7.421  -8.328   8.202  1.00 26.57           N  
ATOM   2772  CA  GLN B 123       6.018  -8.592   7.893  1.00 27.91           C  
ATOM   2773  C   GLN B 123       5.256  -7.279   7.702  1.00 27.99           C  
ATOM   2774  O   GLN B 123       4.357  -7.182   6.858  1.00 27.77           O  
ATOM   2775  CB  GLN B 123       5.376  -9.421   9.014  1.00 27.94           C  
ATOM   2776  CG  GLN B 123       5.724 -10.897   8.934  1.00 32.32           C  
ATOM   2777  CD  GLN B 123       5.880 -11.562  10.289  1.00 36.20           C  
ATOM   2778  OE1 GLN B 123       5.210 -11.207  11.263  1.00 37.19           O  
ATOM   2779  NE2 GLN B 123       6.767 -12.550  10.351  1.00 39.08           N  
ATOM   2780  N   VAL B 124       5.621  -6.267   8.485  1.00 24.74           N  
ATOM   2781  CA  VAL B 124       4.970  -4.970   8.372  1.00 24.06           C  
ATOM   2782  C   VAL B 124       5.264  -4.386   6.992  1.00 25.43           C  
ATOM   2783  O   VAL B 124       4.348  -3.938   6.299  1.00 26.02           O  
ATOM   2784  CB  VAL B 124       5.461  -3.963   9.448  1.00 24.39           C  
ATOM   2785  CG1 VAL B 124       4.815  -2.586   9.208  1.00 22.66           C  
ATOM   2786  CG2 VAL B 124       5.099  -4.465  10.840  1.00 19.26           C  
ATOM   2787  N   PHE B 125       6.534  -4.397   6.591  1.00 24.98           N  
ATOM   2788  CA  PHE B 125       6.890  -3.856   5.293  1.00 28.08           C  
ATOM   2789  C   PHE B 125       6.157  -4.562   4.140  1.00 30.97           C  
ATOM   2790  O   PHE B 125       5.719  -3.907   3.185  1.00 32.31           O  
ATOM   2791  CB  PHE B 125       8.407  -3.907   5.078  1.00 25.61           C  
ATOM   2792  CG  PHE B 125       9.191  -2.932   5.932  1.00 24.21           C  
ATOM   2793  CD1 PHE B 125       8.555  -1.895   6.616  1.00 26.09           C  
ATOM   2794  CD2 PHE B 125      10.576  -3.023   6.007  1.00 22.82           C  
ATOM   2795  CE1 PHE B 125       9.291  -0.964   7.356  1.00 24.99           C  
ATOM   2796  CE2 PHE B 125      11.319  -2.104   6.737  1.00 19.98           C  
ATOM   2797  CZ  PHE B 125      10.674  -1.067   7.416  1.00 24.96           C  
ATOM   2798  N   LYS B 126       6.012  -5.883   4.213  1.00 31.61           N  
ATOM   2799  CA  LYS B 126       5.306  -6.595   3.150  1.00 31.39           C  
ATOM   2800  C   LYS B 126       3.827  -6.219   3.119  1.00 31.16           C  
ATOM   2801  O   LYS B 126       3.215  -6.189   2.052  1.00 31.84           O  
ATOM   2802  CB  LYS B 126       5.454  -8.115   3.302  1.00 33.66           C  
ATOM   2803  CG  LYS B 126       6.876  -8.618   3.059  1.00 37.38           C  
ATOM   2804  CD  LYS B 126       6.924 -10.119   2.788  1.00 38.85           C  
ATOM   2805  CE  LYS B 126       6.520 -10.928   3.997  1.00 40.27           C  
ATOM   2806  NZ  LYS B 126       6.519 -12.385   3.707  1.00 42.56           N  
ATOM   2807  N   GLU B 127       3.247  -5.931   4.281  1.00 30.84           N  
ATOM   2808  CA  GLU B 127       1.847  -5.541   4.338  1.00 30.98           C  
ATOM   2809  C   GLU B 127       1.652  -4.108   3.873  1.00 31.75           C  
ATOM   2810  O   GLU B 127       0.611  -3.775   3.307  1.00 32.85           O  
ATOM   2811  CB  GLU B 127       1.287  -5.710   5.754  1.00 32.15           C  
ATOM   2812  CG  GLU B 127       0.896  -7.142   6.054  1.00 33.72           C  
ATOM   2813  CD  GLU B 127      -0.225  -7.631   5.152  1.00 34.02           C  
ATOM   2814  OE1 GLU B 127      -1.406  -7.349   5.447  1.00 33.39           O  
ATOM   2815  OE2 GLU B 127       0.078  -8.287   4.137  1.00 36.50           O  
ATOM   2816  N   VAL B 128       2.650  -3.265   4.111  1.00 29.15           N  
ATOM   2817  CA  VAL B 128       2.574  -1.878   3.689  1.00 30.76           C  
ATOM   2818  C   VAL B 128       2.633  -1.862   2.155  1.00 33.04           C  
ATOM   2819  O   VAL B 128       1.796  -1.253   1.500  1.00 32.63           O  
ATOM   2820  CB  VAL B 128       3.737  -1.041   4.299  1.00 28.72           C  
ATOM   2821  CG1 VAL B 128       3.831   0.316   3.616  1.00 27.96           C  
ATOM   2822  CG2 VAL B 128       3.492  -0.838   5.823  1.00 24.72           C  
ATOM   2823  N   ARG B 129       3.616  -2.554   1.592  1.00 34.55           N  
ATOM   2824  CA  ARG B 129       3.756  -2.635   0.143  1.00 37.97           C  
ATOM   2825  C   ARG B 129       2.474  -3.192  -0.485  1.00 37.45           C  
ATOM   2826  O   ARG B 129       2.065  -2.772  -1.563  1.00 36.97           O  
ATOM   2827  CB  ARG B 129       4.941  -3.530  -0.214  1.00 40.25           C  
ATOM   2828  CG  ARG B 129       5.002  -3.962  -1.673  1.00 46.63           C  
ATOM   2829  CD  ARG B 129       6.295  -4.714  -1.938  1.00 52.16           C  
ATOM   2830  NE  ARG B 129       6.367  -5.273  -3.285  1.00 56.76           N  
ATOM   2831  CZ  ARG B 129       5.580  -6.245  -3.733  1.00 58.05           C  
ATOM   2832  NH1 ARG B 129       4.655  -6.772  -2.940  1.00 59.62           N  
ATOM   2833  NH2 ARG B 129       5.729  -6.700  -4.972  1.00 59.86           N  
ATOM   2834  N   ARG B 130       1.839  -4.128   0.210  1.00 36.71           N  
ATOM   2835  CA  ARG B 130       0.622  -4.740  -0.282  1.00 35.37           C  
ATOM   2836  C   ARG B 130      -0.583  -3.806  -0.327  1.00 35.41           C  
ATOM   2837  O   ARG B 130      -1.222  -3.674  -1.369  1.00 36.55           O  
ATOM   2838  CB  ARG B 130       0.268  -5.975   0.549  1.00 34.15           C  
ATOM   2839  CG  ARG B 130      -0.986  -6.689   0.044  1.00 34.93           C  
ATOM   2840  CD  ARG B 130      -1.272  -7.986   0.784  1.00 34.76           C  
ATOM   2841  NE  ARG B 130      -1.815  -7.778   2.123  1.00 32.44           N  
ATOM   2842  CZ  ARG B 130      -3.003  -7.241   2.384  1.00 34.25           C  
ATOM   2843  NH1 ARG B 130      -3.802  -6.840   1.401  1.00 33.78           N  
ATOM   2844  NH2 ARG B 130      -3.398  -7.110   3.643  1.00 35.95           N  
ATOM   2845  N   VAL B 131      -0.903  -3.161   0.793  1.00 33.75           N  
ATOM   2846  CA  VAL B 131      -2.067  -2.281   0.831  1.00 32.82           C  
ATOM   2847  C   VAL B 131      -1.894  -0.931   0.139  1.00 32.22           C  
ATOM   2848  O   VAL B 131      -2.856  -0.176  -0.000  1.00 32.11           O  
ATOM   2849  CB  VAL B 131      -2.557  -2.054   2.284  1.00 33.11           C  
ATOM   2850  CG1 VAL B 131      -3.028  -3.374   2.876  1.00 30.58           C  
ATOM   2851  CG2 VAL B 131      -1.452  -1.440   3.132  1.00 30.71           C  
ATOM   2852  N   LEU B 132      -0.678  -0.629  -0.304  1.00 31.53           N  
ATOM   2853  CA  LEU B 132      -0.427   0.629  -0.999  1.00 34.66           C  
ATOM   2854  C   LEU B 132      -0.708   0.504  -2.493  1.00 37.41           C  
ATOM   2855  O   LEU B 132      -0.532  -0.562  -3.080  1.00 37.12           O  
ATOM   2856  CB  LEU B 132       1.025   1.064  -0.845  1.00 32.56           C  
ATOM   2857  CG  LEU B 132       1.510   1.864   0.361  1.00 31.60           C  
ATOM   2858  CD1 LEU B 132       3.001   2.075   0.198  1.00 27.18           C  
ATOM   2859  CD2 LEU B 132       0.791   3.206   0.459  1.00 27.67           C  
ATOM   2860  N   LYS B 133      -1.148   1.602  -3.098  1.00 40.27           N  
ATOM   2861  CA  LYS B 133      -1.404   1.627  -4.530  1.00 40.55           C  
ATOM   2862  C   LYS B 133      -0.022   1.785  -5.141  1.00 40.83           C  
ATOM   2863  O   LYS B 133       0.888   2.298  -4.494  1.00 40.10           O  
ATOM   2864  CB  LYS B 133      -2.283   2.823  -4.904  1.00 41.49           C  
ATOM   2865  CG  LYS B 133      -3.696   2.762  -4.339  1.00 44.15           C  
ATOM   2866  CD  LYS B 133      -4.484   4.012  -4.704  1.00 48.61           C  
ATOM   2867  CE  LYS B 133      -5.897   3.948  -4.149  1.00 49.46           C  
ATOM   2868  NZ  LYS B 133      -6.635   5.224  -4.374  1.00 53.30           N  
ATOM   2869  N   PRO B 134       0.156   1.334  -6.391  1.00 41.35           N  
ATOM   2870  CA  PRO B 134       1.452   1.435  -7.069  1.00 40.64           C  
ATOM   2871  C   PRO B 134       2.012   2.849  -7.065  1.00 40.08           C  
ATOM   2872  O   PRO B 134       3.225   3.046  -7.016  1.00 39.69           O  
ATOM   2873  CB  PRO B 134       1.138   0.928  -8.474  1.00 41.74           C  
ATOM   2874  CG  PRO B 134       0.091  -0.108  -8.215  1.00 40.91           C  
ATOM   2875  CD  PRO B 134      -0.813   0.591  -7.218  1.00 40.71           C  
ATOM   2876  N   SER B 135       1.122   3.833  -7.115  1.00 40.01           N  
ATOM   2877  CA  SER B 135       1.537   5.230  -7.108  1.00 39.32           C  
ATOM   2878  C   SER B 135       1.683   5.755  -5.679  1.00 38.26           C  
ATOM   2879  O   SER B 135       2.146   6.877  -5.467  1.00 37.77           O  
ATOM   2880  CB  SER B 135       0.516   6.080  -7.869  1.00 38.40           C  
ATOM   2881  OG  SER B 135      -0.783   5.940  -7.316  1.00 39.05           O  
ATOM   2882  N   GLY B 136       1.295   4.932  -4.705  1.00 37.80           N  
ATOM   2883  CA  GLY B 136       1.358   5.323  -3.307  1.00 36.43           C  
ATOM   2884  C   GLY B 136       2.721   5.688  -2.744  1.00 35.53           C  
ATOM   2885  O   GLY B 136       3.730   5.655  -3.440  1.00 35.34           O  
ATOM   2886  N   LYS B 137       2.741   6.038  -1.460  1.00 35.28           N  
ATOM   2887  CA  LYS B 137       3.973   6.418  -0.781  1.00 35.19           C  
ATOM   2888  C   LYS B 137       4.026   5.827   0.622  1.00 34.04           C  
ATOM   2889  O   LYS B 137       3.015   5.788   1.324  1.00 35.17           O  
ATOM   2890  CB  LYS B 137       4.065   7.944  -0.670  1.00 35.86           C  
ATOM   2891  CG  LYS B 137       3.946   8.667  -2.003  1.00 41.57           C  
ATOM   2892  CD  LYS B 137       5.286   9.219  -2.445  1.00 44.60           C  
ATOM   2893  CE  LYS B 137       5.537  10.605  -1.858  1.00 47.12           C  
ATOM   2894  NZ  LYS B 137       4.753  11.665  -2.569  1.00 47.65           N  
ATOM   2895  N   PHE B 138       5.205   5.361   1.019  1.00 32.67           N  
ATOM   2896  CA  PHE B 138       5.403   4.814   2.359  1.00 31.83           C  
ATOM   2897  C   PHE B 138       6.314   5.798   3.068  1.00 30.02           C  
ATOM   2898  O   PHE B 138       7.468   5.971   2.677  1.00 29.93           O  
ATOM   2899  CB  PHE B 138       6.088   3.443   2.322  1.00 29.68           C  
ATOM   2900  CG  PHE B 138       6.431   2.898   3.690  1.00 28.28           C  
ATOM   2901  CD1 PHE B 138       7.558   2.103   3.870  1.00 28.55           C  
ATOM   2902  CD2 PHE B 138       5.634   3.189   4.796  1.00 26.65           C  
ATOM   2903  CE1 PHE B 138       7.886   1.609   5.129  1.00 30.38           C  
ATOM   2904  CE2 PHE B 138       5.950   2.699   6.054  1.00 27.11           C  
ATOM   2905  CZ  PHE B 138       7.080   1.909   6.226  1.00 29.13           C  
ATOM   2906  N   ILE B 139       5.792   6.442   4.103  1.00 28.60           N  
ATOM   2907  CA  ILE B 139       6.575   7.419   4.852  1.00 29.87           C  
ATOM   2908  C   ILE B 139       6.755   6.985   6.296  1.00 29.10           C  
ATOM   2909  O   ILE B 139       5.776   6.826   7.025  1.00 29.14           O  
ATOM   2910  CB  ILE B 139       5.890   8.797   4.831  1.00 28.99           C  
ATOM   2911  CG1 ILE B 139       5.663   9.230   3.376  1.00 31.37           C  
ATOM   2912  CG2 ILE B 139       6.746   9.821   5.583  1.00 28.69           C  
ATOM   2913  CD1 ILE B 139       4.917  10.550   3.241  1.00 32.62           C  
HETATM 2914  N   MSE B 140       7.998   6.789   6.713  1.00 28.98           N  
HETATM 2915  CA  MSE B 140       8.235   6.379   8.088  1.00 31.04           C  
HETATM 2916  C   MSE B 140       9.292   7.210   8.776  1.00 29.82           C  
HETATM 2917  O   MSE B 140      10.124   7.862   8.142  1.00 31.48           O  
HETATM 2918  CB  MSE B 140       8.626   4.899   8.170  1.00 32.01           C  
HETATM 2919  CG  MSE B 140      10.062   4.575   7.816  1.00 38.06           C  
HETATM 2920 SE   MSE B 140      10.526   2.717   8.292  1.00 44.81          SE  
HETATM 2921  CE  MSE B 140      11.099   2.974  10.116  1.00 43.02           C  
ATOM   2922  N   TYR B 141       9.257   7.176  10.093  1.00 30.01           N  
ATOM   2923  CA  TYR B 141      10.208   7.927  10.878  1.00 30.20           C  
ATOM   2924  C   TYR B 141      10.376   7.267  12.227  1.00 31.19           C  
ATOM   2925  O   TYR B 141       9.444   6.651  12.735  1.00 29.55           O  
ATOM   2926  CB  TYR B 141       9.703   9.359  11.086  1.00 30.43           C  
ATOM   2927  CG  TYR B 141      10.479  10.087  12.143  1.00 31.83           C  
ATOM   2928  CD1 TYR B 141      11.686  10.707  11.844  1.00 33.38           C  
ATOM   2929  CD2 TYR B 141      10.071  10.056  13.477  1.00 30.96           C  
ATOM   2930  CE1 TYR B 141      12.464  11.269  12.836  1.00 34.07           C  
ATOM   2931  CE2 TYR B 141      10.848  10.613  14.475  1.00 32.05           C  
ATOM   2932  CZ  TYR B 141      12.041  11.213  14.151  1.00 33.63           C  
ATOM   2933  OH  TYR B 141      12.833  11.755  15.135  1.00 33.61           O  
ATOM   2934  N   PHE B 142      11.570   7.395  12.797  1.00 32.68           N  
ATOM   2935  CA  PHE B 142      11.827   6.874  14.133  1.00 35.26           C  
ATOM   2936  C   PHE B 142      13.050   7.558  14.741  1.00 35.99           C  
ATOM   2937  O   PHE B 142      13.998   7.905  14.037  1.00 36.35           O  
ATOM   2938  CB  PHE B 142      11.988   5.347  14.127  1.00 37.19           C  
ATOM   2939  CG  PHE B 142      13.337   4.868  13.693  1.00 38.78           C  
ATOM   2940  CD1 PHE B 142      13.612   4.632  12.351  1.00 38.91           C  
ATOM   2941  CD2 PHE B 142      14.333   4.621  14.638  1.00 40.55           C  
ATOM   2942  CE1 PHE B 142      14.860   4.152  11.953  1.00 38.63           C  
ATOM   2943  CE2 PHE B 142      15.582   4.141  14.252  1.00 40.77           C  
ATOM   2944  CZ  PHE B 142      15.846   3.904  12.903  1.00 38.03           C  
ATOM   2945  N   THR B 143      13.006   7.760  16.054  1.00 35.56           N  
ATOM   2946  CA  THR B 143      14.069   8.434  16.777  1.00 33.86           C  
ATOM   2947  C   THR B 143      15.214   7.508  17.132  1.00 34.25           C  
ATOM   2948  O   THR B 143      15.019   6.473  17.773  1.00 32.74           O  
ATOM   2949  CB  THR B 143      13.519   9.065  18.062  1.00 35.50           C  
ATOM   2950  OG1 THR B 143      12.363   9.850  17.742  1.00 35.04           O  
ATOM   2951  CG2 THR B 143      14.574   9.952  18.727  1.00 36.27           C  
ATOM   2952  N   ASP B 144      16.414   7.888  16.709  1.00 33.44           N  
ATOM   2953  CA  ASP B 144      17.600   7.099  16.989  1.00 35.26           C  
ATOM   2954  C   ASP B 144      17.757   7.042  18.502  1.00 35.12           C  
ATOM   2955  O   ASP B 144      17.537   8.037  19.181  1.00 33.00           O  
ATOM   2956  CB  ASP B 144      18.835   7.749  16.367  1.00 37.46           C  
ATOM   2957  CG  ASP B 144      20.087   6.921  16.574  1.00 38.43           C  
ATOM   2958  OD1 ASP B 144      20.341   6.012  15.758  1.00 38.82           O  
ATOM   2959  OD2 ASP B 144      20.802   7.170  17.566  1.00 40.06           O  
ATOM   2960  N   LEU B 145      18.130   5.875  19.021  1.00 36.75           N  
ATOM   2961  CA  LEU B 145      18.292   5.683  20.459  1.00 39.23           C  
ATOM   2962  C   LEU B 145      19.182   6.752  21.100  1.00 40.52           C  
ATOM   2963  O   LEU B 145      18.864   7.276  22.167  1.00 39.21           O  
ATOM   2964  CB  LEU B 145      18.866   4.289  20.741  1.00 38.76           C  
ATOM   2965  CG  LEU B 145      18.964   3.853  22.202  1.00 38.18           C  
ATOM   2966  CD1 LEU B 145      17.574   3.763  22.804  1.00 38.52           C  
ATOM   2967  CD2 LEU B 145      19.674   2.505  22.290  1.00 38.39           C  
ATOM   2968  N   ARG B 146      20.295   7.074  20.451  1.00 41.28           N  
ATOM   2969  CA  ARG B 146      21.195   8.082  20.987  1.00 43.90           C  
ATOM   2970  C   ARG B 146      20.465   9.394  21.295  1.00 43.74           C  
ATOM   2971  O   ARG B 146      20.843  10.103  22.218  1.00 42.15           O  
ATOM   2972  CB  ARG B 146      22.345   8.318  20.008  1.00 45.14           C  
ATOM   2973  CG  ARG B 146      23.287   7.127  19.902  1.00 47.43           C  
ATOM   2974  CD  ARG B 146      24.185   7.213  18.683  1.00 48.24           C  
ATOM   2975  NE  ARG B 146      23.465   6.890  17.453  1.00 50.54           N  
ATOM   2976  CZ  ARG B 146      24.032   6.811  16.251  1.00 51.95           C  
ATOM   2977  NH1 ARG B 146      25.335   7.032  16.111  1.00 52.22           N  
ATOM   2978  NH2 ARG B 146      23.300   6.501  15.187  1.00 50.67           N  
ATOM   2979  N   GLU B 147      19.412   9.700  20.536  1.00 44.53           N  
ATOM   2980  CA  GLU B 147      18.639  10.931  20.738  1.00 45.25           C  
ATOM   2981  C   GLU B 147      17.402  10.736  21.626  1.00 44.76           C  
ATOM   2982  O   GLU B 147      16.955  11.672  22.293  1.00 44.74           O  
ATOM   2983  CB  GLU B 147      18.178  11.512  19.395  1.00 44.27           C  
ATOM   2984  CG  GLU B 147      19.273  11.672  18.355  1.00 48.84           C  
ATOM   2985  CD  GLU B 147      18.806  12.450  17.131  1.00 51.47           C  
ATOM   2986  OE1 GLU B 147      18.627  13.685  17.243  1.00 54.88           O  
ATOM   2987  OE2 GLU B 147      18.607  11.830  16.061  1.00 51.09           O  
ATOM   2988  N   LEU B 148      16.850   9.525  21.626  1.00 43.88           N  
ATOM   2989  CA  LEU B 148      15.657   9.221  22.418  1.00 44.25           C  
ATOM   2990  C   LEU B 148      15.901   9.183  23.927  1.00 43.83           C  
ATOM   2991  O   LEU B 148      15.068   9.649  24.710  1.00 43.12           O  
ATOM   2992  CB  LEU B 148      15.064   7.881  21.977  1.00 43.86           C  
ATOM   2993  CG  LEU B 148      13.849   7.385  22.769  1.00 44.90           C  
ATOM   2994  CD1 LEU B 148      12.743   8.430  22.723  1.00 43.88           C  
ATOM   2995  CD2 LEU B 148      13.367   6.055  22.187  1.00 46.47           C  
ATOM   2996  N   LEU B 149      17.033   8.613  24.327  1.00 43.55           N  
ATOM   2997  CA  LEU B 149      17.378   8.513  25.741  1.00 43.25           C  
ATOM   2998  C   LEU B 149      17.429   9.882  26.412  1.00 42.17           C  
ATOM   2999  O   LEU B 149      16.856  10.074  27.487  1.00 41.37           O  
ATOM   3000  CB  LEU B 149      18.722   7.803  25.910  1.00 44.66           C  
ATOM   3001  CG  LEU B 149      18.744   6.327  25.516  1.00 47.23           C  
ATOM   3002  CD1 LEU B 149      20.165   5.790  25.626  1.00 47.67           C  
ATOM   3003  CD2 LEU B 149      17.798   5.547  26.419  1.00 46.45           C  
ATOM   3004  N   PRO B 150      18.120  10.852  25.788  1.00 41.56           N  
ATOM   3005  CA  PRO B 150      18.214  12.194  26.367  1.00 42.35           C  
ATOM   3006  C   PRO B 150      16.841  12.820  26.565  1.00 42.78           C  
ATOM   3007  O   PRO B 150      16.572  13.441  27.595  1.00 43.57           O  
ATOM   3008  CB  PRO B 150      19.058  12.949  25.345  1.00 41.44           C  
ATOM   3009  CG  PRO B 150      19.963  11.874  24.815  1.00 42.01           C  
ATOM   3010  CD  PRO B 150      18.999  10.732  24.612  1.00 40.26           C  
ATOM   3011  N   ARG B 151      15.972  12.650  25.570  1.00 44.43           N  
ATOM   3012  CA  ARG B 151      14.618  13.193  25.630  1.00 46.16           C  
ATOM   3013  C   ARG B 151      13.829  12.552  26.770  1.00 44.45           C  
ATOM   3014  O   ARG B 151      13.106  13.231  27.498  1.00 44.24           O  
ATOM   3015  CB  ARG B 151      13.899  12.971  24.291  1.00 48.82           C  
ATOM   3016  CG  ARG B 151      14.356  13.923  23.187  1.00 53.06           C  
ATOM   3017  CD  ARG B 151      13.754  13.567  21.832  1.00 56.98           C  
ATOM   3018  NE  ARG B 151      12.301  13.407  21.879  1.00 60.43           N  
ATOM   3019  CZ  ARG B 151      11.557  13.057  20.833  1.00 62.51           C  
ATOM   3020  NH1 ARG B 151      12.127  12.833  19.655  1.00 62.61           N  
ATOM   3021  NH2 ARG B 151      10.243  12.919  20.964  1.00 63.00           N  
ATOM   3022  N   LEU B 152      13.978  11.244  26.930  1.00 42.65           N  
ATOM   3023  CA  LEU B 152      13.274  10.544  27.989  1.00 42.86           C  
ATOM   3024  C   LEU B 152      13.720  11.053  29.368  1.00 44.06           C  
ATOM   3025  O   LEU B 152      12.882  11.322  30.230  1.00 41.39           O  
ATOM   3026  CB  LEU B 152      13.511   9.034  27.872  1.00 43.53           C  
ATOM   3027  CG  LEU B 152      12.944   8.382  26.603  1.00 43.89           C  
ATOM   3028  CD1 LEU B 152      13.327   6.912  26.562  1.00 43.19           C  
ATOM   3029  CD2 LEU B 152      11.430   8.537  26.582  1.00 41.50           C  
ATOM   3030  N   LYS B 153      15.030  11.199  29.568  1.00 43.48           N  
ATOM   3031  CA  LYS B 153      15.545  11.683  30.848  1.00 45.62           C  
ATOM   3032  C   LYS B 153      14.965  13.064  31.170  1.00 45.85           C  
ATOM   3033  O   LYS B 153      14.604  13.338  32.314  1.00 46.10           O  
ATOM   3034  CB  LYS B 153      17.076  11.750  30.821  1.00 45.54           C  
ATOM   3035  CG  LYS B 153      17.752  10.401  30.609  1.00 46.87           C  
ATOM   3036  CD  LYS B 153      19.272  10.519  30.570  1.00 47.62           C  
ATOM   3037  CE  LYS B 153      19.914   9.158  30.353  1.00 49.86           C  
ATOM   3038  NZ  LYS B 153      21.401   9.225  30.280  1.00 51.48           N  
ATOM   3039  N   GLU B 154      14.873  13.928  30.162  1.00 46.63           N  
ATOM   3040  CA  GLU B 154      14.315  15.267  30.356  1.00 47.46           C  
ATOM   3041  C   GLU B 154      12.873  15.191  30.864  1.00 46.52           C  
ATOM   3042  O   GLU B 154      12.485  15.944  31.756  1.00 44.01           O  
ATOM   3043  CB  GLU B 154      14.358  16.062  29.046  1.00 50.68           C  
ATOM   3044  CG  GLU B 154      15.745  16.575  28.678  1.00 55.61           C  
ATOM   3045  CD  GLU B 154      15.785  17.245  27.314  1.00 58.59           C  
ATOM   3046  OE1 GLU B 154      15.576  16.543  26.299  1.00 59.66           O  
ATOM   3047  OE2 GLU B 154      16.025  18.473  27.257  1.00 60.11           O  
ATOM   3048  N   SER B 155      12.084  14.280  30.295  1.00 44.89           N  
ATOM   3049  CA  SER B 155      10.697  14.115  30.717  1.00 43.82           C  
ATOM   3050  C   SER B 155      10.656  13.650  32.163  1.00 41.42           C  
ATOM   3051  O   SER B 155       9.855  14.145  32.958  1.00 41.57           O  
ATOM   3052  CB  SER B 155       9.968  13.093  29.832  1.00 44.37           C  
ATOM   3053  OG  SER B 155       9.897  13.526  28.484  1.00 46.70           O  
ATOM   3054  N   LEU B 156      11.520  12.695  32.507  1.00 40.78           N  
ATOM   3055  CA  LEU B 156      11.560  12.184  33.878  1.00 40.74           C  
ATOM   3056  C   LEU B 156      11.842  13.290  34.897  1.00 41.93           C  
ATOM   3057  O   LEU B 156      11.270  13.296  35.990  1.00 42.59           O  
ATOM   3058  CB  LEU B 156      12.619  11.081  34.033  1.00 38.39           C  
ATOM   3059  CG  LEU B 156      12.328   9.655  33.546  1.00 38.16           C  
ATOM   3060  CD1 LEU B 156      10.831   9.356  33.601  1.00 37.63           C  
ATOM   3061  CD2 LEU B 156      12.843   9.487  32.151  1.00 39.13           C  
ATOM   3062  N   VAL B 157      12.728  14.222  34.552  1.00 41.86           N  
ATOM   3063  CA  VAL B 157      13.031  15.309  35.477  1.00 43.16           C  
ATOM   3064  C   VAL B 157      11.730  16.048  35.775  1.00 42.91           C  
ATOM   3065  O   VAL B 157      11.423  16.352  36.930  1.00 42.49           O  
ATOM   3066  CB  VAL B 157      14.044  16.310  34.882  1.00 43.23           C  
ATOM   3067  CG1 VAL B 157      14.354  17.408  35.905  1.00 43.59           C  
ATOM   3068  CG2 VAL B 157      15.314  15.586  34.481  1.00 44.12           C  
ATOM   3069  N   VAL B 158      10.967  16.333  34.722  1.00 43.10           N  
ATOM   3070  CA  VAL B 158       9.699  17.033  34.874  1.00 44.44           C  
ATOM   3071  C   VAL B 158       8.767  16.203  35.753  1.00 45.16           C  
ATOM   3072  O   VAL B 158       7.997  16.745  36.550  1.00 44.52           O  
ATOM   3073  CB  VAL B 158       9.022  17.267  33.509  1.00 45.26           C  
ATOM   3074  CG1 VAL B 158       7.688  17.969  33.705  1.00 45.46           C  
ATOM   3075  CG2 VAL B 158       9.934  18.095  32.615  1.00 44.86           C  
ATOM   3076  N   GLY B 159       8.855  14.883  35.605  1.00 45.34           N  
ATOM   3077  CA  GLY B 159       8.016  13.993  36.389  1.00 46.74           C  
ATOM   3078  C   GLY B 159       8.373  14.030  37.863  1.00 47.00           C  
ATOM   3079  O   GLY B 159       7.507  13.870  38.725  1.00 47.35           O  
ATOM   3080  N   GLN B 160       9.654  14.243  38.149  1.00 46.96           N  
ATOM   3081  CA  GLN B 160      10.141  14.306  39.521  1.00 47.59           C  
ATOM   3082  C   GLN B 160       9.907  13.004  40.287  1.00 47.88           C  
ATOM   3083  O   GLN B 160       9.807  13.016  41.514  1.00 47.99           O  
ATOM   3084  CB  GLN B 160       9.470  15.461  40.278  1.00 47.61           C  
ATOM   3085  CG  GLN B 160       9.769  16.854  39.730  1.00 48.11           C  
ATOM   3086  CD  GLN B 160       9.400  17.952  40.716  1.00 49.12           C  
ATOM   3087  OE1 GLN B 160       9.966  18.029  41.807  1.00 50.87           O  
ATOM   3088  NE2 GLN B 160       8.447  18.802  40.339  1.00 45.74           N  
ATOM   3089  N   LYS B 161       9.818  11.886  39.573  1.00 47.50           N  
ATOM   3090  CA  LYS B 161       9.592  10.598  40.223  1.00 47.52           C  
ATOM   3091  C   LYS B 161      10.586   9.515  39.815  1.00 47.31           C  
ATOM   3092  O   LYS B 161      11.181   8.858  40.669  1.00 48.85           O  
ATOM   3093  CB  LYS B 161       8.174  10.096  39.948  1.00 46.63           C  
ATOM   3094  CG  LYS B 161       7.866   8.790  40.657  1.00 48.84           C  
ATOM   3095  CD  LYS B 161       6.469   8.292  40.358  1.00 50.37           C  
ATOM   3096  CE  LYS B 161       6.254   6.911  40.949  1.00 50.19           C  
ATOM   3097  NZ  LYS B 161       4.939   6.340  40.551  1.00 52.64           N  
ATOM   3098  N   TYR B 162      10.755   9.322  38.511  1.00 46.18           N  
ATOM   3099  CA  TYR B 162      11.674   8.313  38.010  1.00 46.13           C  
ATOM   3100  C   TYR B 162      12.926   8.901  37.380  1.00 47.05           C  
ATOM   3101  O   TYR B 162      12.945  10.055  36.944  1.00 46.74           O  
ATOM   3102  CB  TYR B 162      11.005   7.434  36.950  1.00 44.48           C  
ATOM   3103  CG  TYR B 162       9.743   6.734  37.378  1.00 44.74           C  
ATOM   3104  CD1 TYR B 162       8.515   7.387  37.342  1.00 45.75           C  
ATOM   3105  CD2 TYR B 162       9.766   5.398  37.773  1.00 46.33           C  
ATOM   3106  CE1 TYR B 162       7.335   6.725  37.675  1.00 47.49           C  
ATOM   3107  CE2 TYR B 162       8.591   4.726  38.113  1.00 48.69           C  
ATOM   3108  CZ  TYR B 162       7.380   5.398  38.057  1.00 47.91           C  
ATOM   3109  OH  TYR B 162       6.209   4.736  38.350  1.00 51.42           O  
ATOM   3110  N   TRP B 163      13.968   8.081  37.334  1.00 46.84           N  
ATOM   3111  CA  TRP B 163      15.231   8.446  36.712  1.00 49.82           C  
ATOM   3112  C   TRP B 163      15.719   7.155  36.060  1.00 50.25           C  
ATOM   3113  O   TRP B 163      15.419   6.067  36.551  1.00 51.15           O  
ATOM   3114  CB  TRP B 163      16.237   8.943  37.761  1.00 51.98           C  
ATOM   3115  CG  TRP B 163      16.631   7.915  38.786  1.00 54.69           C  
ATOM   3116  CD1 TRP B 163      17.574   6.935  38.647  1.00 55.90           C  
ATOM   3117  CD2 TRP B 163      16.070   7.748  40.096  1.00 55.46           C  
ATOM   3118  NE1 TRP B 163      17.634   6.168  39.788  1.00 57.16           N  
ATOM   3119  CE2 TRP B 163      16.721   6.644  40.693  1.00 56.63           C  
ATOM   3120  CE3 TRP B 163      15.077   8.423  40.823  1.00 55.80           C  
ATOM   3121  CZ2 TRP B 163      16.413   6.199  41.984  1.00 56.75           C  
ATOM   3122  CZ3 TRP B 163      14.770   7.980  42.107  1.00 56.90           C  
ATOM   3123  CH2 TRP B 163      15.438   6.877  42.673  1.00 56.72           C  
ATOM   3124  N   ILE B 164      16.435   7.264  34.944  1.00 50.48           N  
ATOM   3125  CA  ILE B 164      16.951   6.073  34.276  1.00 51.21           C  
ATOM   3126  C   ILE B 164      18.113   5.519  35.097  1.00 51.97           C  
ATOM   3127  O   ILE B 164      19.196   6.101  35.126  1.00 52.09           O  
ATOM   3128  CB  ILE B 164      17.438   6.393  32.843  1.00 50.76           C  
ATOM   3129  CG1 ILE B 164      16.245   6.801  31.973  1.00 49.85           C  
ATOM   3130  CG2 ILE B 164      18.140   5.175  32.241  1.00 49.78           C  
ATOM   3131  CD1 ILE B 164      16.592   7.043  30.516  1.00 48.33           C  
ATOM   3132  N   SER B 165      17.882   4.392  35.759  1.00 52.20           N  
ATOM   3133  CA  SER B 165      18.908   3.785  36.593  1.00 53.72           C  
ATOM   3134  C   SER B 165      19.893   2.890  35.849  1.00 54.68           C  
ATOM   3135  O   SER B 165      21.001   2.658  36.335  1.00 55.35           O  
ATOM   3136  CB  SER B 165      18.263   2.968  37.710  1.00 53.76           C  
ATOM   3137  OG  SER B 165      17.859   1.697  37.237  1.00 54.73           O  
ATOM   3138  N   LYS B 166      19.507   2.388  34.679  1.00 53.91           N  
ATOM   3139  CA  LYS B 166      20.397   1.494  33.944  1.00 53.78           C  
ATOM   3140  C   LYS B 166      20.004   1.274  32.480  1.00 52.77           C  
ATOM   3141  O   LYS B 166      18.817   1.231  32.142  1.00 51.52           O  
ATOM   3142  CB  LYS B 166      20.453   0.151  34.676  1.00 55.88           C  
ATOM   3143  CG  LYS B 166      21.498  -0.828  34.181  1.00 58.81           C  
ATOM   3144  CD  LYS B 166      21.536  -2.039  35.104  1.00 61.95           C  
ATOM   3145  CE  LYS B 166      22.590  -3.057  34.690  1.00 63.86           C  
ATOM   3146  NZ  LYS B 166      22.567  -4.248  35.594  1.00 65.61           N  
ATOM   3147  N   VAL B 167      21.022   1.140  31.629  1.00 49.56           N  
ATOM   3148  CA  VAL B 167      20.863   0.908  30.193  1.00 47.59           C  
ATOM   3149  C   VAL B 167      21.628  -0.370  29.850  1.00 46.39           C  
ATOM   3150  O   VAL B 167      22.844  -0.336  29.668  1.00 45.43           O  
ATOM   3151  CB  VAL B 167      21.459   2.071  29.373  1.00 48.06           C  
ATOM   3152  CG1 VAL B 167      21.328   1.781  27.882  1.00 46.52           C  
ATOM   3153  CG2 VAL B 167      20.758   3.373  29.733  1.00 46.38           C  
ATOM   3154  N   ILE B 168      20.916  -1.490  29.765  1.00 44.29           N  
ATOM   3155  CA  ILE B 168      21.538  -2.788  29.492  1.00 42.12           C  
ATOM   3156  C   ILE B 168      21.317  -3.307  28.067  1.00 40.28           C  
ATOM   3157  O   ILE B 168      20.233  -3.797  27.727  1.00 38.29           O  
ATOM   3158  CB  ILE B 168      21.001  -3.850  30.469  1.00 44.57           C  
ATOM   3159  CG1 ILE B 168      20.864  -3.247  31.866  1.00 45.14           C  
ATOM   3160  CG2 ILE B 168      21.937  -5.045  30.509  1.00 44.00           C  
ATOM   3161  CD1 ILE B 168      20.008  -4.083  32.809  1.00 47.61           C  
ATOM   3162  N   PRO B 169      22.344  -3.212  27.213  1.00 37.96           N  
ATOM   3163  CA  PRO B 169      22.180  -3.696  25.844  1.00 37.46           C  
ATOM   3164  C   PRO B 169      22.391  -5.208  25.714  1.00 35.93           C  
ATOM   3165  O   PRO B 169      22.976  -5.847  26.582  1.00 33.88           O  
ATOM   3166  CB  PRO B 169      23.228  -2.905  25.083  1.00 37.76           C  
ATOM   3167  CG  PRO B 169      24.350  -2.848  26.079  1.00 39.90           C  
ATOM   3168  CD  PRO B 169      23.634  -2.515  27.372  1.00 38.11           C  
ATOM   3169  N   ASP B 170      21.868  -5.755  24.626  1.00 35.24           N  
ATOM   3170  CA  ASP B 170      21.992  -7.163  24.286  1.00 35.25           C  
ATOM   3171  C   ASP B 170      22.269  -7.108  22.787  1.00 34.61           C  
ATOM   3172  O   ASP B 170      21.343  -7.143  21.972  1.00 31.06           O  
ATOM   3173  CB  ASP B 170      20.688  -7.916  24.544  1.00 35.41           C  
ATOM   3174  CG  ASP B 170      20.801  -9.391  24.225  1.00 38.49           C  
ATOM   3175  OD1 ASP B 170      21.474  -9.731  23.231  1.00 37.86           O  
ATOM   3176  OD2 ASP B 170      20.210 -10.215  24.959  1.00 42.38           O  
ATOM   3177  N   GLN B 171      23.547  -7.004  22.435  1.00 35.10           N  
ATOM   3178  CA  GLN B 171      23.969  -6.907  21.039  1.00 36.98           C  
ATOM   3179  C   GLN B 171      23.547  -8.038  20.109  1.00 35.21           C  
ATOM   3180  O   GLN B 171      23.119  -7.788  18.987  1.00 35.54           O  
ATOM   3181  CB  GLN B 171      25.489  -6.736  20.968  1.00 40.41           C  
ATOM   3182  CG  GLN B 171      25.974  -5.431  21.575  1.00 45.43           C  
ATOM   3183  CD  GLN B 171      25.156  -4.244  21.106  1.00 49.01           C  
ATOM   3184  OE1 GLN B 171      24.968  -4.043  19.906  1.00 53.07           O  
ATOM   3185  NE2 GLN B 171      24.666  -3.448  22.051  1.00 51.79           N  
ATOM   3186  N   GLU B 172      23.671  -9.274  20.569  1.00 35.32           N  
ATOM   3187  CA  GLU B 172      23.307 -10.430  19.756  1.00 38.01           C  
ATOM   3188  C   GLU B 172      21.832 -10.418  19.336  1.00 39.15           C  
ATOM   3189  O   GLU B 172      21.497 -10.810  18.215  1.00 40.04           O  
ATOM   3190  CB  GLU B 172      23.633 -11.720  20.524  1.00 38.63           C  
ATOM   3191  CG  GLU B 172      22.918 -12.975  20.039  1.00 43.74           C  
ATOM   3192  CD  GLU B 172      23.281 -13.362  18.619  1.00 47.27           C  
ATOM   3193  OE1 GLU B 172      24.492 -13.462  18.320  1.00 47.94           O  
ATOM   3194  OE2 GLU B 172      22.353 -13.575  17.806  1.00 48.70           O  
ATOM   3195  N   GLU B 173      20.958  -9.957  20.229  1.00 37.92           N  
ATOM   3196  CA  GLU B 173      19.527  -9.908  19.942  1.00 38.17           C  
ATOM   3197  C   GLU B 173      19.052  -8.558  19.416  1.00 35.90           C  
ATOM   3198  O   GLU B 173      17.882  -8.397  19.076  1.00 35.69           O  
ATOM   3199  CB  GLU B 173      18.713 -10.276  21.187  1.00 39.09           C  
ATOM   3200  CG  GLU B 173      18.063 -11.650  21.105  1.00 45.71           C  
ATOM   3201  CD  GLU B 173      18.722 -12.680  22.004  1.00 47.58           C  
ATOM   3202  OE1 GLU B 173      18.657 -12.513  23.244  1.00 48.74           O  
ATOM   3203  OE2 GLU B 173      19.298 -13.656  21.470  1.00 47.57           O  
ATOM   3204  N   ARG B 174      19.952  -7.584  19.365  1.00 34.03           N  
ATOM   3205  CA  ARG B 174      19.591  -6.271  18.857  1.00 31.03           C  
ATOM   3206  C   ARG B 174      18.510  -5.633  19.725  1.00 29.44           C  
ATOM   3207  O   ARG B 174      17.514  -5.126  19.211  1.00 26.48           O  
ATOM   3208  CB  ARG B 174      19.091  -6.401  17.410  1.00 33.38           C  
ATOM   3209  CG  ARG B 174      20.156  -6.878  16.409  1.00 36.73           C  
ATOM   3210  CD  ARG B 174      19.520  -7.246  15.069  1.00 38.16           C  
ATOM   3211  NE  ARG B 174      18.762  -6.142  14.486  1.00 39.86           N  
ATOM   3212  CZ  ARG B 174      19.269  -5.234  13.658  1.00 39.87           C  
ATOM   3213  NH1 ARG B 174      20.545  -5.288  13.299  1.00 36.47           N  
ATOM   3214  NH2 ARG B 174      18.492  -4.270  13.182  1.00 39.15           N  
ATOM   3215  N   THR B 175      18.693  -5.691  21.042  1.00 26.16           N  
ATOM   3216  CA  THR B 175      17.741  -5.083  21.970  1.00 28.48           C  
ATOM   3217  C   THR B 175      18.481  -4.412  23.118  1.00 29.22           C  
ATOM   3218  O   THR B 175      19.675  -4.655  23.335  1.00 29.71           O  
ATOM   3219  CB  THR B 175      16.755  -6.110  22.586  1.00 27.39           C  
ATOM   3220  OG1 THR B 175      17.484  -7.117  23.284  1.00 25.19           O  
ATOM   3221  CG2 THR B 175      15.882  -6.751  21.513  1.00 26.95           C  
ATOM   3222  N   VAL B 176      17.764  -3.564  23.847  1.00 28.83           N  
ATOM   3223  CA  VAL B 176      18.323  -2.857  24.986  1.00 28.76           C  
ATOM   3224  C   VAL B 176      17.255  -2.722  26.069  1.00 31.18           C  
ATOM   3225  O   VAL B 176      16.061  -2.581  25.776  1.00 30.31           O  
ATOM   3226  CB  VAL B 176      18.841  -1.448  24.574  1.00 29.75           C  
ATOM   3227  CG1 VAL B 176      17.678  -0.558  24.128  1.00 28.17           C  
ATOM   3228  CG2 VAL B 176      19.590  -0.812  25.730  1.00 28.61           C  
ATOM   3229  N   VAL B 177      17.685  -2.801  27.319  1.00 32.32           N  
ATOM   3230  CA  VAL B 177      16.775  -2.670  28.444  1.00 34.54           C  
ATOM   3231  C   VAL B 177      17.065  -1.348  29.130  1.00 36.53           C  
ATOM   3232  O   VAL B 177      18.217  -0.943  29.259  1.00 37.00           O  
ATOM   3233  CB  VAL B 177      16.964  -3.806  29.468  1.00 36.75           C  
ATOM   3234  CG1 VAL B 177      16.146  -3.524  30.727  1.00 37.58           C  
ATOM   3235  CG2 VAL B 177      16.544  -5.132  28.857  1.00 37.33           C  
ATOM   3236  N   ILE B 178      16.015  -0.657  29.539  1.00 36.82           N  
ATOM   3237  CA  ILE B 178      16.182   0.603  30.237  1.00 37.68           C  
ATOM   3238  C   ILE B 178      15.356   0.485  31.503  1.00 39.31           C  
ATOM   3239  O   ILE B 178      14.161   0.213  31.449  1.00 37.56           O  
ATOM   3240  CB  ILE B 178      15.691   1.789  29.394  1.00 37.15           C  
ATOM   3241  CG1 ILE B 178      16.552   1.911  28.136  1.00 36.48           C  
ATOM   3242  CG2 ILE B 178      15.766   3.072  30.209  1.00 37.22           C  
ATOM   3243  CD1 ILE B 178      16.052   2.921  27.141  1.00 38.80           C  
ATOM   3244  N   GLU B 179      16.011   0.651  32.645  1.00 41.88           N  
ATOM   3245  CA  GLU B 179      15.323   0.554  33.918  1.00 45.56           C  
ATOM   3246  C   GLU B 179      15.062   1.935  34.478  1.00 46.47           C  
ATOM   3247  O   GLU B 179      15.981   2.741  34.627  1.00 46.85           O  
ATOM   3248  CB  GLU B 179      16.148  -0.244  34.930  1.00 47.65           C  
ATOM   3249  CG  GLU B 179      15.422  -0.443  36.250  1.00 52.13           C  
ATOM   3250  CD  GLU B 179      16.318  -0.980  37.342  1.00 55.54           C  
ATOM   3251  OE1 GLU B 179      15.781  -1.384  38.395  1.00 58.46           O  
ATOM   3252  OE2 GLU B 179      17.555  -0.991  37.156  1.00 57.78           O  
ATOM   3253  N   PHE B 180      13.799   2.202  34.780  1.00 46.98           N  
ATOM   3254  CA  PHE B 180      13.407   3.479  35.344  1.00 49.12           C  
ATOM   3255  C   PHE B 180      13.140   3.226  36.816  1.00 51.45           C  
ATOM   3256  O   PHE B 180      12.177   2.546  37.172  1.00 53.65           O  
ATOM   3257  CB  PHE B 180      12.153   3.999  34.644  1.00 47.36           C  
ATOM   3258  CG  PHE B 180      12.304   4.114  33.154  1.00 44.76           C  
ATOM   3259  CD1 PHE B 180      12.050   3.020  32.328  1.00 43.66           C  
ATOM   3260  CD2 PHE B 180      12.739   5.303  32.576  1.00 44.62           C  
ATOM   3261  CE1 PHE B 180      12.229   3.112  30.951  1.00 41.31           C  
ATOM   3262  CE2 PHE B 180      12.923   5.403  31.196  1.00 42.03           C  
ATOM   3263  CZ  PHE B 180      12.665   4.307  30.385  1.00 41.90           C  
ATOM   3264  N   LYS B 181      14.011   3.750  37.671  1.00 53.25           N  
ATOM   3265  CA  LYS B 181      13.855   3.547  39.102  1.00 55.62           C  
ATOM   3266  C   LYS B 181      13.237   4.750  39.794  1.00 56.92           C  
ATOM   3267  O   LYS B 181      13.424   5.895  39.380  1.00 55.15           O  
ATOM   3268  CB  LYS B 181      15.206   3.227  39.745  1.00 57.68           C  
ATOM   3269  CG  LYS B 181      15.115   2.891  41.223  1.00 58.98           C  
ATOM   3270  CD  LYS B 181      16.471   2.516  41.796  1.00 60.71           C  
ATOM   3271  CE  LYS B 181      16.337   2.057  43.240  1.00 59.93           C  
ATOM   3272  NZ  LYS B 181      17.657   1.711  43.825  1.00 61.26           N  
ATOM   3273  N   SER B 182      12.500   4.468  40.860  1.00 58.88           N  
ATOM   3274  CA  SER B 182      11.850   5.491  41.650  1.00 62.25           C  
ATOM   3275  C   SER B 182      11.962   5.157  43.127  1.00 64.99           C  
ATOM   3276  O   SER B 182      12.290   4.043  43.516  1.00 64.88           O  
ATOM   3277  CB  SER B 182      10.379   5.551  41.237  1.00 60.82           C  
ATOM   3278  OG  SER B 182       9.576   4.967  42.263  1.00 59.26           O  
ATOM   3279  N   GLU B 183      11.708   6.141  43.983  1.00 68.10           N  
ATOM   3280  CA  GLU B 183      11.771   5.934  45.424  1.00 71.29           C  
ATOM   3281  C   GLU B 183      10.646   4.984  45.835  1.00 72.40           C  
ATOM   3282  O   GLU B 183      10.829   4.116  46.689  1.00 72.06           O  
ATOM   3283  CB  GLU B 183      11.624   7.277  46.153  1.00 73.05           C  
ATOM   3284  CG  GLU B 183      11.067   7.192  47.576  1.00 75.26           C  
ATOM   3285  CD  GLU B 183      11.988   6.474  48.547  1.00 77.04           C  
ATOM   3286  OE1 GLU B 183      12.325   5.297  48.300  1.00 78.87           O  
ATOM   3287  OE2 GLU B 183      12.370   7.088  49.567  1.00 76.89           O  
ATOM   3288  N   GLN B 184       9.487   5.154  45.208  1.00 73.91           N  
ATOM   3289  CA  GLN B 184       8.319   4.337  45.500  1.00 75.76           C  
ATOM   3290  C   GLN B 184       8.410   2.966  44.838  1.00 76.30           C  
ATOM   3291  O   GLN B 184       8.332   1.934  45.506  1.00 77.31           O  
ATOM   3292  CB  GLN B 184       7.047   5.047  45.028  1.00 76.99           C  
ATOM   3293  CG  GLN B 184       6.842   6.450  45.596  1.00 79.32           C  
ATOM   3294  CD  GLN B 184       7.610   7.524  44.836  1.00 80.63           C  
ATOM   3295  OE1 GLN B 184       8.837   7.488  44.743  1.00 81.24           O  
ATOM   3296  NE2 GLN B 184       6.881   8.492  44.290  1.00 81.62           N  
ATOM   3297  N   ASP B 185       8.574   2.964  43.519  1.00 75.97           N  
ATOM   3298  CA  ASP B 185       8.665   1.726  42.755  1.00 75.16           C  
ATOM   3299  C   ASP B 185       9.671   1.865  41.619  1.00 74.15           C  
ATOM   3300  O   ASP B 185      10.571   2.701  41.674  1.00 74.60           O  
ATOM   3301  CB  ASP B 185       7.291   1.374  42.189  1.00 75.81           C  
ATOM   3302  CG  ASP B 185       6.705   2.496  41.356  1.00 77.02           C  
ATOM   3303  OD1 ASP B 185       7.283   2.810  40.294  1.00 77.32           O  
ATOM   3304  OD2 ASP B 185       5.672   3.066  41.767  1.00 76.52           O  
ATOM   3305  N   SER B 186       9.517   1.039  40.589  1.00 72.27           N  
ATOM   3306  CA  SER B 186      10.410   1.085  39.437  1.00 69.76           C  
ATOM   3307  C   SER B 186       9.896   0.161  38.345  1.00 67.23           C  
ATOM   3308  O   SER B 186       9.064  -0.713  38.598  1.00 67.89           O  
ATOM   3309  CB  SER B 186      11.825   0.661  39.834  1.00 70.51           C  
ATOM   3310  OG  SER B 186      11.873  -0.721  40.141  1.00 71.08           O  
ATOM   3311  N   PHE B 187      10.386   0.363  37.127  1.00 63.68           N  
ATOM   3312  CA  PHE B 187       9.981  -0.468  36.004  1.00 58.99           C  
ATOM   3313  C   PHE B 187      11.031  -0.420  34.910  1.00 56.18           C  
ATOM   3314  O   PHE B 187      11.909   0.439  34.909  1.00 53.74           O  
ATOM   3315  CB  PHE B 187       8.637  -0.002  35.434  1.00 58.78           C  
ATOM   3316  CG  PHE B 187       8.697   1.331  34.737  1.00 57.93           C  
ATOM   3317  CD1 PHE B 187       8.833   2.509  35.461  1.00 57.52           C  
ATOM   3318  CD2 PHE B 187       8.600   1.406  33.351  1.00 57.33           C  
ATOM   3319  CE1 PHE B 187       8.869   3.741  34.815  1.00 57.10           C  
ATOM   3320  CE2 PHE B 187       8.635   2.630  32.696  1.00 56.27           C  
ATOM   3321  CZ  PHE B 187       8.770   3.801  33.428  1.00 56.86           C  
ATOM   3322  N   ARG B 188      10.938  -1.354  33.977  1.00 54.62           N  
ATOM   3323  CA  ARG B 188      11.822  -1.192  32.836  1.00 52.59           C  
ATOM   3324  C   ARG B 188      11.197  -1.785  31.578  1.00 48.21           C  
ATOM   3325  O   ARG B 188      10.165  -2.442  31.616  1.00 48.68           O  
ATOM   3326  CB  ARG B 188      13.140  -1.902  33.149  1.00 55.39           C  
ATOM   3327  CG  ARG B 188      12.961  -3.409  33.326  1.00 58.97           C  
ATOM   3328  CD  ARG B 188      14.192  -4.063  33.965  1.00 63.55           C  
ATOM   3329  NE  ARG B 188      13.936  -4.376  35.374  1.00 67.77           N  
ATOM   3330  CZ  ARG B 188      14.854  -5.119  36.018  1.00 69.06           C  
ATOM   3331  NH1 ARG B 188      15.937  -5.534  35.384  1.00 69.26           N  
ATOM   3332  NH2 ARG B 188      14.668  -5.430  37.304  1.00 70.57           N  
ATOM   3333  N   VAL B 189      11.773  -1.351  30.468  1.00 43.08           N  
ATOM   3334  CA  VAL B 189      11.215  -1.649  29.159  1.00 39.40           C  
ATOM   3335  C   VAL B 189      12.333  -2.162  28.265  1.00 34.67           C  
ATOM   3336  O   VAL B 189      13.489  -1.783  28.438  1.00 33.77           O  
ATOM   3337  CB  VAL B 189      10.600  -0.377  28.519  1.00 38.82           C  
ATOM   3338  CG1 VAL B 189      11.664   0.699  28.374  1.00 40.68           C  
ATOM   3339  CG2 VAL B 189      10.004  -0.704  27.165  1.00 41.20           C  
ATOM   3340  N   ARG B 190      11.993  -3.026  27.319  1.00 32.24           N  
ATOM   3341  CA  ARG B 190      12.988  -3.543  26.389  1.00 32.30           C  
ATOM   3342  C   ARG B 190      12.633  -3.078  24.980  1.00 29.53           C  
ATOM   3343  O   ARG B 190      11.516  -3.262  24.518  1.00 31.65           O  
ATOM   3344  CB  ARG B 190      13.046  -5.076  26.432  1.00 34.44           C  
ATOM   3345  CG  ARG B 190      14.139  -5.658  25.531  1.00 37.68           C  
ATOM   3346  CD  ARG B 190      14.209  -7.191  25.554  1.00 42.51           C  
ATOM   3347  NE  ARG B 190      15.199  -7.713  26.500  1.00 44.61           N  
ATOM   3348  CZ  ARG B 190      15.008  -7.829  27.811  1.00 47.59           C  
ATOM   3349  NH1 ARG B 190      15.976  -8.312  28.579  1.00 48.78           N  
ATOM   3350  NH2 ARG B 190      13.848  -7.476  28.355  1.00 48.79           N  
ATOM   3351  N   PHE B 191      13.587  -2.457  24.307  1.00 26.81           N  
ATOM   3352  CA  PHE B 191      13.371  -1.974  22.953  1.00 27.78           C  
ATOM   3353  C   PHE B 191      14.111  -2.826  21.934  1.00 26.12           C  
ATOM   3354  O   PHE B 191      15.157  -3.402  22.238  1.00 25.02           O  
ATOM   3355  CB  PHE B 191      13.910  -0.540  22.777  1.00 25.57           C  
ATOM   3356  CG  PHE B 191      13.233   0.494  23.617  1.00 30.23           C  
ATOM   3357  CD1 PHE B 191      11.857   0.486  23.784  1.00 31.10           C  
ATOM   3358  CD2 PHE B 191      13.974   1.510  24.212  1.00 33.58           C  
ATOM   3359  CE1 PHE B 191      11.219   1.472  24.532  1.00 33.10           C  
ATOM   3360  CE2 PHE B 191      13.341   2.502  24.962  1.00 36.40           C  
ATOM   3361  CZ  PHE B 191      11.963   2.479  25.121  1.00 33.43           C  
ATOM   3362  N   ASN B 192      13.559  -2.913  20.731  1.00 23.74           N  
ATOM   3363  CA  ASN B 192      14.253  -3.575  19.641  1.00 21.48           C  
ATOM   3364  C   ASN B 192      15.093  -2.404  19.113  1.00 23.64           C  
ATOM   3365  O   ASN B 192      14.560  -1.317  18.870  1.00 21.52           O  
ATOM   3366  CB  ASN B 192      13.271  -4.029  18.584  1.00 20.58           C  
ATOM   3367  CG  ASN B 192      12.550  -5.271  18.989  1.00 21.50           C  
ATOM   3368  OD1 ASN B 192      13.148  -6.353  19.023  1.00 24.52           O  
ATOM   3369  ND2 ASN B 192      11.269  -5.137  19.334  1.00 18.23           N  
ATOM   3370  N   VAL B 193      16.400  -2.600  18.976  1.00 22.59           N  
ATOM   3371  CA  VAL B 193      17.269  -1.524  18.513  1.00 23.88           C  
ATOM   3372  C   VAL B 193      17.458  -1.581  17.011  1.00 23.31           C  
ATOM   3373  O   VAL B 193      17.780  -2.630  16.444  1.00 24.41           O  
ATOM   3374  CB  VAL B 193      18.638  -1.591  19.206  1.00 24.57           C  
ATOM   3375  CG1 VAL B 193      19.569  -0.526  18.632  1.00 25.65           C  
ATOM   3376  CG2 VAL B 193      18.459  -1.391  20.707  1.00 26.07           C  
ATOM   3377  N   TRP B 194      17.253  -0.441  16.366  1.00 21.32           N  
ATOM   3378  CA  TRP B 194      17.374  -0.370  14.923  1.00 23.08           C  
ATOM   3379  C   TRP B 194      18.318   0.716  14.431  1.00 25.59           C  
ATOM   3380  O   TRP B 194      18.314   1.843  14.934  1.00 24.78           O  
ATOM   3381  CB  TRP B 194      15.993  -0.148  14.283  1.00 20.45           C  
ATOM   3382  CG  TRP B 194      15.114  -1.372  14.268  1.00 22.65           C  
ATOM   3383  CD1 TRP B 194      14.164  -1.720  15.193  1.00 21.70           C  
ATOM   3384  CD2 TRP B 194      15.124  -2.418  13.288  1.00 19.93           C  
ATOM   3385  NE1 TRP B 194      13.580  -2.919  14.843  1.00 21.43           N  
ATOM   3386  CE2 TRP B 194      14.154  -3.369  13.680  1.00 20.65           C  
ATOM   3387  CE3 TRP B 194      15.862  -2.642  12.112  1.00 21.92           C  
ATOM   3388  CZ2 TRP B 194      13.900  -4.532  12.939  1.00 21.07           C  
ATOM   3389  CZ3 TRP B 194      15.610  -3.798  11.371  1.00 20.82           C  
ATOM   3390  CH2 TRP B 194      14.634  -4.731  11.791  1.00 22.72           C  
ATOM   3391  N   GLY B 195      19.114   0.367  13.426  1.00 25.80           N  
ATOM   3392  CA  GLY B 195      20.022   1.332  12.841  1.00 27.26           C  
ATOM   3393  C   GLY B 195      19.513   1.713  11.462  1.00 28.77           C  
ATOM   3394  O   GLY B 195      18.853   0.910  10.787  1.00 28.17           O  
ATOM   3395  N   LYS B 196      19.813   2.939  11.043  1.00 27.75           N  
ATOM   3396  CA  LYS B 196      19.406   3.433   9.733  1.00 30.07           C  
ATOM   3397  C   LYS B 196      19.679   2.387   8.648  1.00 30.84           C  
ATOM   3398  O   LYS B 196      18.817   2.103   7.817  1.00 32.41           O  
ATOM   3399  CB  LYS B 196      20.170   4.719   9.404  1.00 31.64           C  
ATOM   3400  CG  LYS B 196      19.826   5.349   8.053  1.00 35.14           C  
ATOM   3401  CD  LYS B 196      20.766   6.516   7.764  1.00 38.37           C  
ATOM   3402  CE  LYS B 196      20.255   7.426   6.648  1.00 38.91           C  
ATOM   3403  NZ  LYS B 196      20.267   6.797   5.307  1.00 41.48           N  
ATOM   3404  N   THR B 197      20.881   1.821   8.666  1.00 28.91           N  
ATOM   3405  CA  THR B 197      21.280   0.819   7.684  1.00 33.24           C  
ATOM   3406  C   THR B 197      20.466  -0.472   7.744  1.00 32.63           C  
ATOM   3407  O   THR B 197      20.107  -1.021   6.707  1.00 33.86           O  
ATOM   3408  CB  THR B 197      22.792   0.485   7.821  1.00 36.14           C  
ATOM   3409  OG1 THR B 197      23.563   1.581   7.310  1.00 39.92           O  
ATOM   3410  CG2 THR B 197      23.144  -0.774   7.048  1.00 38.68           C  
ATOM   3411  N   GLY B 198      20.174  -0.965   8.946  1.00 31.75           N  
ATOM   3412  CA  GLY B 198      19.384  -2.183   9.045  1.00 30.00           C  
ATOM   3413  C   GLY B 198      17.967  -1.968   8.519  1.00 31.06           C  
ATOM   3414  O   GLY B 198      17.441  -2.776   7.755  1.00 28.22           O  
ATOM   3415  N   VAL B 199      17.339  -0.869   8.931  1.00 30.34           N  
ATOM   3416  CA  VAL B 199      15.982  -0.564   8.492  1.00 30.81           C  
ATOM   3417  C   VAL B 199      15.917  -0.502   6.966  1.00 32.18           C  
ATOM   3418  O   VAL B 199      15.039  -1.109   6.339  1.00 30.29           O  
ATOM   3419  CB  VAL B 199      15.517   0.785   9.072  1.00 31.44           C  
ATOM   3420  CG1 VAL B 199      14.079   1.075   8.645  1.00 31.21           C  
ATOM   3421  CG2 VAL B 199      15.638   0.758  10.594  1.00 31.18           C  
ATOM   3422  N   GLU B 200      16.855   0.234   6.378  1.00 31.97           N  
ATOM   3423  CA  GLU B 200      16.917   0.384   4.931  1.00 34.03           C  
ATOM   3424  C   GLU B 200      17.124  -0.954   4.232  1.00 31.54           C  
ATOM   3425  O   GLU B 200      16.483  -1.232   3.223  1.00 32.25           O  
ATOM   3426  CB  GLU B 200      18.037   1.354   4.549  1.00 36.44           C  
ATOM   3427  CG  GLU B 200      17.639   2.808   4.637  1.00 42.46           C  
ATOM   3428  CD  GLU B 200      18.782   3.743   4.290  1.00 47.90           C  
ATOM   3429  OE1 GLU B 200      19.463   3.509   3.265  1.00 49.35           O  
ATOM   3430  OE2 GLU B 200      18.995   4.721   5.040  1.00 51.12           O  
ATOM   3431  N   LEU B 201      18.012  -1.780   4.773  1.00 31.11           N  
ATOM   3432  CA  LEU B 201      18.278  -3.100   4.193  1.00 31.00           C  
ATOM   3433  C   LEU B 201      16.962  -3.841   3.972  1.00 29.66           C  
ATOM   3434  O   LEU B 201      16.705  -4.342   2.882  1.00 30.53           O  
ATOM   3435  CB  LEU B 201      19.175  -3.928   5.123  1.00 31.01           C  
ATOM   3436  CG  LEU B 201      19.823  -5.226   4.596  1.00 35.04           C  
ATOM   3437  CD1 LEU B 201      20.613  -5.904   5.726  1.00 33.36           C  
ATOM   3438  CD2 LEU B 201      18.768  -6.176   4.071  1.00 34.43           C  
ATOM   3439  N   LEU B 202      16.124  -3.908   5.006  1.00 28.83           N  
ATOM   3440  CA  LEU B 202      14.847  -4.609   4.884  1.00 26.67           C  
ATOM   3441  C   LEU B 202      13.836  -3.846   4.038  1.00 25.81           C  
ATOM   3442  O   LEU B 202      13.105  -4.444   3.240  1.00 23.23           O  
ATOM   3443  CB  LEU B 202      14.249  -4.896   6.269  1.00 26.91           C  
ATOM   3444  CG  LEU B 202      15.018  -5.880   7.161  1.00 29.82           C  
ATOM   3445  CD1 LEU B 202      14.265  -6.080   8.478  1.00 30.17           C  
ATOM   3446  CD2 LEU B 202      15.172  -7.219   6.448  1.00 27.98           C  
ATOM   3447  N   ALA B 203      13.787  -2.527   4.203  1.00 24.68           N  
ATOM   3448  CA  ALA B 203      12.839  -1.725   3.434  1.00 27.38           C  
ATOM   3449  C   ALA B 203      13.045  -1.903   1.931  1.00 29.70           C  
ATOM   3450  O   ALA B 203      12.084  -2.106   1.185  1.00 29.21           O  
ATOM   3451  CB  ALA B 203      12.966  -0.242   3.798  1.00 26.44           C  
ATOM   3452  N   LYS B 204      14.302  -1.842   1.499  1.00 29.57           N  
ATOM   3453  CA  LYS B 204      14.633  -1.950   0.086  1.00 31.85           C  
ATOM   3454  C   LYS B 204      14.338  -3.288  -0.582  1.00 33.53           C  
ATOM   3455  O   LYS B 204      14.535  -3.441  -1.790  1.00 33.41           O  
ATOM   3456  CB  LYS B 204      16.095  -1.561  -0.131  1.00 32.10           C  
ATOM   3457  CG  LYS B 204      16.348  -0.074   0.053  1.00 33.88           C  
ATOM   3458  CD  LYS B 204      17.825   0.256  -0.041  1.00 36.96           C  
ATOM   3459  CE  LYS B 204      18.053   1.757  -0.013  1.00 39.45           C  
ATOM   3460  NZ  LYS B 204      19.513   2.077   0.001  1.00 40.88           N  
ATOM   3461  N   LEU B 205      13.868  -4.258   0.187  1.00 33.16           N  
ATOM   3462  CA  LEU B 205      13.518  -5.540  -0.398  1.00 35.41           C  
ATOM   3463  C   LEU B 205      12.153  -5.369  -1.059  1.00 36.22           C  
ATOM   3464  O   LEU B 205      11.823  -6.056  -2.025  1.00 35.48           O  
ATOM   3465  CB  LEU B 205      13.419  -6.621   0.689  1.00 35.81           C  
ATOM   3466  CG  LEU B 205      14.668  -6.956   1.505  1.00 35.59           C  
ATOM   3467  CD1 LEU B 205      14.302  -7.979   2.589  1.00 35.89           C  
ATOM   3468  CD2 LEU B 205      15.757  -7.510   0.581  1.00 36.80           C  
ATOM   3469  N   TYR B 206      11.378  -4.421  -0.539  1.00 35.92           N  
ATOM   3470  CA  TYR B 206      10.024  -4.179  -1.022  1.00 36.46           C  
ATOM   3471  C   TYR B 206       9.757  -2.786  -1.580  1.00 36.14           C  
ATOM   3472  O   TYR B 206       8.720  -2.556  -2.196  1.00 38.40           O  
ATOM   3473  CB  TYR B 206       9.042  -4.443   0.123  1.00 36.62           C  
ATOM   3474  CG  TYR B 206       9.356  -5.716   0.868  1.00 37.64           C  
ATOM   3475  CD1 TYR B 206       9.007  -6.958   0.340  1.00 36.86           C  
ATOM   3476  CD2 TYR B 206      10.056  -5.689   2.084  1.00 38.66           C  
ATOM   3477  CE1 TYR B 206       9.351  -8.136   0.992  1.00 39.52           C  
ATOM   3478  CE2 TYR B 206      10.401  -6.868   2.742  1.00 37.89           C  
ATOM   3479  CZ  TYR B 206      10.043  -8.082   2.193  1.00 39.73           C  
ATOM   3480  OH  TYR B 206      10.362  -9.250   2.844  1.00 39.71           O  
ATOM   3481  N   PHE B 207      10.668  -1.853  -1.345  1.00 35.70           N  
ATOM   3482  CA  PHE B 207      10.464  -0.494  -1.827  1.00 36.52           C  
ATOM   3483  C   PHE B 207      11.710   0.103  -2.436  1.00 36.28           C  
ATOM   3484  O   PHE B 207      12.813  -0.415  -2.280  1.00 35.56           O  
ATOM   3485  CB  PHE B 207      10.046   0.455  -0.693  1.00 34.96           C  
ATOM   3486  CG  PHE B 207       8.927  -0.047   0.170  1.00 35.87           C  
ATOM   3487  CD1 PHE B 207       9.180  -0.918   1.224  1.00 36.15           C  
ATOM   3488  CD2 PHE B 207       7.623   0.383  -0.045  1.00 36.37           C  
ATOM   3489  CE1 PHE B 207       8.149  -1.350   2.059  1.00 36.40           C  
ATOM   3490  CE2 PHE B 207       6.586  -0.044   0.785  1.00 37.80           C  
ATOM   3491  CZ  PHE B 207       6.853  -0.915   1.839  1.00 36.06           C  
ATOM   3492  N   THR B 208      11.503   1.219  -3.119  1.00 35.95           N  
ATOM   3493  CA  THR B 208      12.584   1.988  -3.716  1.00 38.25           C  
ATOM   3494  C   THR B 208      12.538   3.303  -2.926  1.00 39.09           C  
ATOM   3495  O   THR B 208      11.453   3.821  -2.626  1.00 38.32           O  
ATOM   3496  CB  THR B 208      12.339   2.233  -5.232  1.00 39.43           C  
ATOM   3497  OG1 THR B 208      11.131   2.979  -5.415  1.00 41.21           O  
ATOM   3498  CG2 THR B 208      12.197   0.904  -5.960  1.00 37.42           C  
ATOM   3499  N   LYS B 209      13.706   3.827  -2.574  1.00 39.96           N  
ATOM   3500  CA  LYS B 209      13.805   5.050  -1.781  1.00 42.73           C  
ATOM   3501  C   LYS B 209      13.611   6.336  -2.580  1.00 44.81           C  
ATOM   3502  O   LYS B 209      14.452   6.688  -3.405  1.00 46.23           O  
ATOM   3503  CB  LYS B 209      15.162   5.094  -1.072  1.00 41.59           C  
ATOM   3504  CG  LYS B 209      15.088   5.619   0.349  1.00 44.27           C  
ATOM   3505  CD  LYS B 209      16.403   5.459   1.098  1.00 43.38           C  
ATOM   3506  CE  LYS B 209      17.287   6.687   0.957  1.00 44.92           C  
ATOM   3507  NZ  LYS B 209      18.487   6.587   1.841  1.00 43.93           N  
ATOM   3508  N   GLU B 210      12.510   7.040  -2.320  1.00 45.13           N  
ATOM   3509  CA  GLU B 210      12.223   8.288  -3.018  1.00 46.06           C  
ATOM   3510  C   GLU B 210      13.048   9.421  -2.419  1.00 47.03           C  
ATOM   3511  O   GLU B 210      13.826  10.067  -3.117  1.00 46.76           O  
ATOM   3512  CB  GLU B 210      10.731   8.639  -2.920  1.00 46.96           C  
ATOM   3513  CG  GLU B 210      10.312   9.857  -3.764  1.00 47.90           C  
ATOM   3514  CD  GLU B 210       8.891  10.351  -3.474  1.00 49.00           C  
ATOM   3515  OE1 GLU B 210       7.939   9.546  -3.541  1.00 47.61           O  
ATOM   3516  OE2 GLU B 210       8.724  11.558  -3.189  1.00 51.00           O  
ATOM   3517  N   ALA B 211      12.884   9.654  -1.121  1.00 47.53           N  
ATOM   3518  CA  ALA B 211      13.610  10.731  -0.457  1.00 48.50           C  
ATOM   3519  C   ALA B 211      14.035  10.415   0.972  1.00 49.35           C  
ATOM   3520  O   ALA B 211      13.774   9.330   1.501  1.00 49.35           O  
ATOM   3521  CB  ALA B 211      12.772  12.000  -0.475  1.00 46.66           C  
ATOM   3522  N   GLU B 212      14.677  11.396   1.597  1.00 50.46           N  
ATOM   3523  CA  GLU B 212      15.166  11.255   2.960  1.00 51.96           C  
ATOM   3524  C   GLU B 212      15.320  12.648   3.582  1.00 51.35           C  
ATOM   3525  O   GLU B 212      15.636  13.614   2.887  1.00 52.34           O  
ATOM   3526  CB  GLU B 212      16.510  10.534   2.918  1.00 53.05           C  
ATOM   3527  CG  GLU B 212      16.988   9.966   4.225  1.00 55.76           C  
ATOM   3528  CD  GLU B 212      18.303   9.236   4.063  1.00 56.55           C  
ATOM   3529  OE1 GLU B 212      19.339   9.903   3.851  1.00 56.99           O  
ATOM   3530  OE2 GLU B 212      18.296   7.992   4.131  1.00 57.34           O  
ATOM   3531  N   GLU B 213      15.085  12.747   4.885  1.00 49.43           N  
ATOM   3532  CA  GLU B 213      15.196  14.017   5.595  1.00 47.39           C  
ATOM   3533  C   GLU B 213      15.763  13.768   6.986  1.00 47.18           C  
ATOM   3534  O   GLU B 213      15.109  13.143   7.820  1.00 45.31           O  
ATOM   3535  CB  GLU B 213      13.820  14.674   5.739  1.00 48.30           C  
ATOM   3536  CG  GLU B 213      13.146  15.093   4.443  1.00 48.25           C  
ATOM   3537  CD  GLU B 213      13.871  16.224   3.737  1.00 49.38           C  
ATOM   3538  OE1 GLU B 213      14.389  17.128   4.426  1.00 49.77           O  
ATOM   3539  OE2 GLU B 213      13.908  16.220   2.491  1.00 48.80           O  
ATOM   3540  N   LYS B 214      16.971  14.256   7.243  1.00 45.95           N  
ATOM   3541  CA  LYS B 214      17.571  14.063   8.551  1.00 45.33           C  
ATOM   3542  C   LYS B 214      16.918  14.988   9.573  1.00 45.37           C  
ATOM   3543  O   LYS B 214      16.705  16.173   9.313  1.00 46.53           O  
ATOM   3544  CB  LYS B 214      19.079  14.325   8.508  1.00 45.12           C  
ATOM   3545  CG  LYS B 214      19.723  14.344   9.890  1.00 45.07           C  
ATOM   3546  CD  LYS B 214      21.220  14.605   9.847  1.00 44.88           C  
ATOM   3547  CE  LYS B 214      22.004  13.364   9.440  1.00 47.32           C  
ATOM   3548  NZ  LYS B 214      23.483  13.598   9.498  1.00 45.86           N  
ATOM   3549  N   VAL B 215      16.588  14.427  10.729  1.00 42.51           N  
ATOM   3550  CA  VAL B 215      15.979  15.178  11.814  1.00 41.23           C  
ATOM   3551  C   VAL B 215      16.895  14.966  13.010  1.00 42.60           C  
ATOM   3552  O   VAL B 215      17.222  13.831  13.359  1.00 40.81           O  
ATOM   3553  CB  VAL B 215      14.568  14.648  12.136  1.00 40.36           C  
ATOM   3554  CG1 VAL B 215      13.916  15.514  13.202  1.00 40.25           C  
ATOM   3555  CG2 VAL B 215      13.724  14.635  10.873  1.00 39.13           C  
ATOM   3556  N   GLY B 216      17.319  16.059  13.633  1.00 44.02           N  
ATOM   3557  CA  GLY B 216      18.224  15.934  14.757  1.00 46.01           C  
ATOM   3558  C   GLY B 216      19.565  15.496  14.203  1.00 47.99           C  
ATOM   3559  O   GLY B 216      19.919  15.869  13.084  1.00 48.40           O  
ATOM   3560  N   ASN B 217      20.307  14.690  14.956  1.00 49.26           N  
ATOM   3561  CA  ASN B 217      21.609  14.237  14.486  1.00 51.17           C  
ATOM   3562  C   ASN B 217      21.642  12.803  13.958  1.00 51.51           C  
ATOM   3563  O   ASN B 217      22.483  12.478  13.117  1.00 51.99           O  
ATOM   3564  CB  ASN B 217      22.653  14.407  15.598  1.00 52.92           C  
ATOM   3565  CG  ASN B 217      23.110  15.851  15.755  1.00 53.79           C  
ATOM   3566  OD1 ASN B 217      22.299  16.777  15.745  1.00 54.97           O  
ATOM   3567  ND2 ASN B 217      24.414  16.047  15.909  1.00 55.35           N  
ATOM   3568  N   TYR B 218      20.731  11.952  14.425  1.00 50.34           N  
ATOM   3569  CA  TYR B 218      20.718  10.556  13.980  1.00 48.99           C  
ATOM   3570  C   TYR B 218      19.363   9.993  13.540  1.00 46.34           C  
ATOM   3571  O   TYR B 218      19.243   8.791  13.298  1.00 46.42           O  
ATOM   3572  CB  TYR B 218      21.286   9.657  15.083  1.00 52.20           C  
ATOM   3573  CG  TYR B 218      22.548  10.185  15.730  1.00 55.98           C  
ATOM   3574  CD1 TYR B 218      22.502  10.838  16.965  1.00 56.39           C  
ATOM   3575  CD2 TYR B 218      23.787  10.049  15.099  1.00 58.11           C  
ATOM   3576  CE1 TYR B 218      23.661  11.345  17.558  1.00 58.71           C  
ATOM   3577  CE2 TYR B 218      24.954  10.552  15.681  1.00 59.31           C  
ATOM   3578  CZ  TYR B 218      24.884  11.199  16.909  1.00 60.90           C  
ATOM   3579  OH  TYR B 218      26.036  11.700  17.477  1.00 61.85           O  
ATOM   3580  N   SER B 219      18.344  10.839  13.436  1.00 42.28           N  
ATOM   3581  CA  SER B 219      17.028  10.362  13.024  1.00 38.09           C  
ATOM   3582  C   SER B 219      16.705  10.737  11.586  1.00 37.36           C  
ATOM   3583  O   SER B 219      17.246  11.699  11.040  1.00 35.77           O  
ATOM   3584  CB  SER B 219      15.953  10.905  13.962  1.00 36.15           C  
ATOM   3585  OG  SER B 219      16.205  10.465  15.285  1.00 35.25           O  
ATOM   3586  N   TYR B 220      15.809   9.975  10.973  1.00 35.89           N  
ATOM   3587  CA  TYR B 220      15.436  10.223   9.589  1.00 35.16           C  
ATOM   3588  C   TYR B 220      13.959  10.028   9.296  1.00 35.60           C  
ATOM   3589  O   TYR B 220      13.287   9.227   9.948  1.00 34.58           O  
ATOM   3590  CB  TYR B 220      16.243   9.283   8.686  1.00 35.92           C  
ATOM   3591  CG  TYR B 220      17.736   9.512   8.726  1.00 38.93           C  
ATOM   3592  CD1 TYR B 220      18.327  10.483   7.923  1.00 40.24           C  
ATOM   3593  CD2 TYR B 220      18.552   8.795   9.604  1.00 41.41           C  
ATOM   3594  CE1 TYR B 220      19.695  10.744   7.990  1.00 44.08           C  
ATOM   3595  CE2 TYR B 220      19.925   9.049   9.681  1.00 44.40           C  
ATOM   3596  CZ  TYR B 220      20.486  10.026   8.869  1.00 44.85           C  
ATOM   3597  OH  TYR B 220      21.837  10.284   8.926  1.00 49.67           O  
ATOM   3598  N   LEU B 221      13.452  10.773   8.323  1.00 33.34           N  
ATOM   3599  CA  LEU B 221      12.091  10.602   7.875  1.00 32.75           C  
ATOM   3600  C   LEU B 221      12.386  10.122   6.456  1.00 33.54           C  
ATOM   3601  O   LEU B 221      13.028  10.833   5.683  1.00 35.38           O  
ATOM   3602  CB  LEU B 221      11.334  11.917   7.838  1.00 33.15           C  
ATOM   3603  CG  LEU B 221       9.975  11.842   7.139  1.00 30.38           C  
ATOM   3604  CD1 LEU B 221       8.938  12.641   7.909  1.00 35.26           C  
ATOM   3605  CD2 LEU B 221      10.118  12.371   5.713  1.00 33.89           C  
ATOM   3606  N   THR B 222      11.965   8.907   6.123  1.00 33.62           N  
ATOM   3607  CA  THR B 222      12.244   8.354   4.809  1.00 33.38           C  
ATOM   3608  C   THR B 222      10.976   8.153   4.000  1.00 34.52           C  
ATOM   3609  O   THR B 222       9.931   7.782   4.535  1.00 34.56           O  
ATOM   3610  CB  THR B 222      12.986   7.008   4.935  1.00 33.66           C  
ATOM   3611  OG1 THR B 222      14.107   7.154   5.815  1.00 33.93           O  
ATOM   3612  CG2 THR B 222      13.495   6.563   3.586  1.00 35.98           C  
ATOM   3613  N   VAL B 223      11.082   8.405   2.701  1.00 34.46           N  
ATOM   3614  CA  VAL B 223       9.960   8.258   1.787  1.00 36.38           C  
ATOM   3615  C   VAL B 223      10.264   7.120   0.821  1.00 35.76           C  
ATOM   3616  O   VAL B 223      11.288   7.130   0.139  1.00 37.19           O  
ATOM   3617  CB  VAL B 223       9.724   9.557   0.980  1.00 38.42           C  
ATOM   3618  CG1 VAL B 223       8.512   9.399   0.086  1.00 38.37           C  
ATOM   3619  CG2 VAL B 223       9.534  10.738   1.935  1.00 38.22           C  
ATOM   3620  N   TYR B 224       9.366   6.145   0.774  1.00 35.90           N  
ATOM   3621  CA  TYR B 224       9.538   4.985  -0.082  1.00 36.11           C  
ATOM   3622  C   TYR B 224       8.405   4.828  -1.073  1.00 36.80           C  
ATOM   3623  O   TYR B 224       7.272   5.280  -0.839  1.00 36.88           O  
ATOM   3624  CB  TYR B 224       9.621   3.700   0.753  1.00 34.17           C  
ATOM   3625  CG  TYR B 224      10.914   3.518   1.523  1.00 34.58           C  
ATOM   3626  CD1 TYR B 224      12.095   3.158   0.870  1.00 33.98           C  
ATOM   3627  CD2 TYR B 224      10.958   3.707   2.908  1.00 32.06           C  
ATOM   3628  CE1 TYR B 224      13.284   2.991   1.575  1.00 34.74           C  
ATOM   3629  CE2 TYR B 224      12.143   3.543   3.625  1.00 33.16           C  
ATOM   3630  CZ  TYR B 224      13.303   3.184   2.950  1.00 33.06           C  
ATOM   3631  OH  TYR B 224      14.478   3.021   3.643  1.00 31.48           O  
ATOM   3632  N   ASN B 225       8.742   4.199  -2.196  1.00 37.71           N  
ATOM   3633  CA  ASN B 225       7.786   3.879  -3.247  1.00 40.26           C  
ATOM   3634  C   ASN B 225       7.911   2.361  -3.387  1.00 41.26           C  
ATOM   3635  O   ASN B 225       9.001   1.816  -3.297  1.00 41.23           O  
ATOM   3636  CB  ASN B 225       8.183   4.484  -4.594  1.00 41.52           C  
ATOM   3637  CG  ASN B 225       8.185   5.988  -4.581  1.00 41.28           C  
ATOM   3638  OD1 ASN B 225       8.997   6.611  -5.256  1.00 42.97           O  
ATOM   3639  ND2 ASN B 225       7.275   6.585  -3.822  1.00 40.80           N  
ATOM   3640  N   PRO B 226       6.804   1.659  -3.560  1.00 44.43           N  
ATOM   3641  CA  PRO B 226       6.663   0.202  -3.721  1.00 48.79           C  
ATOM   3642  C   PRO B 226       7.257  -0.339  -5.029  1.00 53.00           C  
ATOM   3643  O   PRO B 226       7.926   0.391  -5.766  1.00 53.85           O  
ATOM   3644  CB  PRO B 226       5.154  -0.020  -3.678  1.00 47.08           C  
ATOM   3645  CG  PRO B 226       4.567   1.339  -3.464  1.00 44.95           C  
ATOM   3646  CD  PRO B 226       5.580   2.246  -3.008  1.00 46.04           C  
ATOM   3647  N   LYS B 227       7.001  -1.619  -5.320  1.00 57.54           N  
ATOM   3648  CA  LYS B 227       7.538  -2.257  -6.531  1.00 61.31           C  
ATOM   3649  C   LYS B 227       7.205  -3.755  -6.572  1.00 64.10           C  
ATOM   3650  O   LYS B 227       5.995  -4.071  -6.417  1.00 65.70           O  
ATOM   3651  CB  LYS B 227       9.053  -2.004  -6.586  1.00 60.80           C  
ATOM   3652  CG  LYS B 227       9.915  -3.178  -6.183  1.00 59.26           C  
ATOM   3653  CD  LYS B 227      11.069  -2.811  -5.316  1.00 57.57           C  
ATOM   3654  CE  LYS B 227      12.077  -3.939  -5.340  1.00 57.61           C  
ATOM   3655  NZ  LYS B 227      13.245  -3.584  -4.499  1.00 58.18           N  
ATOM   3656  OXT LYS B 227       8.136  -4.572  -6.776  1.00 66.92           O  
TER    3657      LYS B 227                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
