
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  137 ( 2173),  selected  137 , name 2ys3_A
# Molecule2: number of CA atoms  101 ( 1588),  selected  101 , name T0482_7_107.pdb
# PARAMETERS: 2ys3_A.T0482_7_107.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      P     7_A           -
LGA    S     2_A      G     8_A           -
LGA    S     3_A      H     9_A           -
LGA    G     4_A      L    10_A           -
LGA    S     5_A      H    11_A           -
LGA    S     6_A      L    12_A           -
LGA    G     7_A      V    13_A           -
LGA    I     8_A      S    14_A           -
LGA    P     9_A      L    15_A           -
LGA    E    10_A      P    16_A           -
LGA    L    11_A      G    17_A           -
LGA    K    12_A      L    18_A           -
LGA    D    13_A      -       -           -
LGA    H    14_A      -       -           -
LGA    L    15_A      -       -           -
LGA    R    16_A      -       -           -
LGA    I    17_A      -       -           -
LGA    F    18_A      -       -           -
LGA    R    19_A      -       -           -
LGA    P    20_A      -       -           -
LGA    R    21_A      -       -           -
LGA    K    22_A      -       -           -
LGA    L    23_A      -       -           -
LGA    T    24_A      -       -           -
LGA    L    25_A      -       -           -
LGA    K    26_A      -       -           -
LGA    G    27_A      -       -           -
LGA    Y    28_A      -       -           -
LGA    R    29_A      -       -           -
LGA    Q    30_A      -       -           -
LGA    H    31_A      -       -           -
LGA    W    32_A      -       -           -
LGA    V    33_A      -       -           -
LGA    V    34_A      -       -           -
LGA    F    35_A      -       -           -
LGA    K    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    T    38_A      D    19_A           #
LGA    T    39_A      Q    20_A           -
LGA    L    40_A      Q    21_A           -
LGA    S    41_A      -       -           -
LGA    Y    42_A      -       -           -
LGA    Y    43_A      -       -           -
LGA    K    44_A      -       -           -
LGA    S    45_A      -       -           -
LGA    Q    46_A      -       -           -
LGA    D    47_A      -       -           -
LGA    E    48_A      -       -           -
LGA    A    49_A      -       -           -
LGA    P    50_A      -       -           -
LGA    G    51_A      -       -           -
LGA    D    52_A      -       -           -
LGA    P    53_A      -       -           -
LGA    I    54_A      -       -           -
LGA    Q    55_A      -       -           -
LGA    Q    56_A      -       -           -
LGA    L    57_A      -       -           -
LGA    N    58_A      -       -           -
LGA    L    59_A      D    22_A           #
LGA    K    60_A      I    23_A          3.668
LGA    G    61_A      N    24_A          1.864
LGA    C    62_A      I    25_A          1.866
LGA    E    63_A      H    26_A          1.799
LGA    V    64_A      I    27_A          1.584
LGA    V    65_A      R    28_A          1.607
LGA    P    66_A      Y    29_A          1.697
LGA    D    67_A      E    30_A          2.600
LGA    V    68_A      V    31_A          2.816
LGA    N    69_A      R    32_A          2.815
LGA    V    70_A      -       -           -
LGA    S    71_A      Q    33_A          3.941
LGA    -       -      N    34_A           -
LGA    -       -      A    35_A           -
LGA    -       -      E    36_A           -
LGA    -       -      S    37_A           -
LGA    G    72_A      G    38_A          3.429
LGA    Q    73_A      A    39_A          1.922
LGA    K    74_A      Y    40_A          1.228
LGA    F    75_A      V    41_A          1.502
LGA    C    76_A      H    42_A          2.305
LGA    I    77_A      F    43_A          1.871
LGA    K    78_A      D    44_A          0.873
LGA    L    79_A      M    45_A          1.036
LGA    L    80_A      D    46_A          0.436
LGA    V    81_A      G    47_A          2.486
LGA    P    82_A      E    48_A          2.234
LGA    -       -      I    49_A           -
LGA    -       -      D    50_A           -
LGA    S    83_A      G    51_A          5.059
LGA    P    84_A      K    52_A          4.988
LGA    E    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    M    87_A      P    53_A          3.376
LGA    S    88_A      F    54_A          1.335
LGA    E    89_A      S    55_A          0.570
LGA    I    90_A      D    56_A          1.040
LGA    Y    91_A      S    57_A          0.901
LGA    L    92_A      F    58_A          1.086
LGA    R    93_A      E    59_A          1.243
LGA    C    94_A      L    60_A          1.626
LGA    Q    95_A      P    61_A          3.125
LGA    D    96_A      R    62_A          3.574
LGA    -       -      D    63_A           -
LGA    -       -      T    64_A           -
LGA    E    97_A      A    65_A          1.389
LGA    Q    98_A      F    66_A          2.808
LGA    Q    99_A      N    67_A          2.249
LGA    Y   100_A      F    68_A          1.997
LGA    A   101_A      A    69_A          3.996
LGA    R   102_A      S    70_A          3.214
LGA    W   103_A      D    71_A          2.588
LGA    M   104_A      A    72_A          3.428
LGA    A   105_A      -       -           -
LGA    G   106_A      -       -           -
LGA    C   107_A      T    73_A          3.174
LGA    R   108_A      R    74_A           -
LGA    L   109_A      V    75_A           -
LGA    -       -      A    76_A           -
LGA    -       -      Q    77_A           -
LGA    -       -      K    78_A           -
LGA    -       -      H    79_A           -
LGA    -       -      G    80_A           -
LGA    A   110_A      L    81_A           #
LGA    S   111_A      H    82_A           -
LGA    K   112_A      P    83_A           -
LGA    -       -      K    84_A           -
LGA    G   113_A      F    85_A          4.346
LGA    R   114_A      G    86_A          3.226
LGA    T   115_A      A    87_A          1.954
LGA    M   116_A      I    88_A          1.455
LGA    A   117_A      T    89_A          1.012
LGA    D   118_A      R    90_A          1.368
LGA    S   119_A      V    91_A          1.698
LGA    S   120_A      H    92_A          1.583
LGA    Y   121_A      -       -           -
LGA    T   122_A      K    93_A           #
LGA    S   123_A      E    94_A          3.926
LGA    E   124_A      Y    95_A          0.914
LGA    V   125_A      -       -           -
LGA    Q   126_A      D    96_A          2.672
LGA    A   127_A      A    97_A          2.315
LGA    I   128_A      M    98_A          2.839
LGA    L   129_A      F    99_A          2.938
LGA    A   130_A      E   100_A          1.649
LGA    F   131_A      D   101_A          1.338
LGA    L   132_A      I   102_A          2.258
LGA    S   133_A      R   103_A          2.976
LGA    L   134_A      A   104_A          2.588
LGA    Q   135_A      K   105_A          3.006
LGA    -       -      L   106_A           -
LGA    R   136_A      H   107_A          3.300
LGA    T   137_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  137  101    5.0     64    2.54     6.25     43.477     2.425

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.138230 * X  +  -0.930572 * Y  +  -0.339011 * Z  +  -1.229871
  Y_new =  -0.613062 * X  +  -0.349232 * Y  +   0.708655 * Z  +  -6.659513
  Z_new =  -0.777848 * X  +   0.109878 * Y  +  -0.618773 * Z  +  -2.022931 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.965850   -0.175742  [ DEG:   169.9307    -10.0693 ]
  Theta =   0.891234    2.250359  [ DEG:    51.0639    128.9361 ]
  Phi   =  -1.349031    1.792562  [ DEG:   -77.2938    102.7062 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ys3_A                                        
REMARK     2: T0482_7_107.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ys3_A.T0482_7_107.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  137  101   5.0   64   2.54    6.25  43.477
REMARK  ---------------------------------------------------------- 
MOLECULE 2ys3_A
HEADER    SIGNALING PROTEIN                       03-APR-07   2YS3              
TITLE     SOLUTION STRUCTURE OF THE PH DOMAIN OF KINDLIN-3 FROM HUMAN           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNC-112-RELATED PROTEIN 2;                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PH DOMAIN, UNP RESIDUES 349-478;                           
COMPND   5 SYNONYM: KINDLIN-3, MIG2-LIKE;                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: URP2;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060904-05;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PH DOMAIN, UNC-112-RELATED PROTEIN 2, KINDLIN-3, STRUCTURAL           
KEYWDS   2 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   3 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, SIGNALING PROTEIN              
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,M.SATO,S.KOSHIBA,S.WATANABE,T.HARADA,T.KIGAWA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   09-OCT-07 2YS3    0                                                
JRNL        AUTH   H.LI,M.SATO,S.KOSHIBA,S.WATANABE,T.HARADA,T.KIGAWA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE PH DOMAIN OF KINDLIN-3             
JRNL        TITL 2 FROM HUMAN                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YS3 A    8   137  UNP    Q86UX7   URP2_HUMAN     349    478             
SEQRES   1 A  137  GLY SER SER GLY SER SER GLY ILE PRO GLU LEU LYS ASP          
SEQRES   2 A  137  HIS LEU ARG ILE PHE ARG PRO ARG LYS LEU THR LEU LYS          
SEQRES   3 A  137  GLY TYR ARG GLN HIS TRP VAL VAL PHE LYS GLU THR THR          
SEQRES   4 A  137  LEU SER TYR TYR LYS SER GLN ASP GLU ALA PRO GLY ASP          
SEQRES   5 A  137  PRO ILE GLN GLN LEU ASN LEU LYS GLY CYS GLU VAL VAL          
SEQRES   6 A  137  PRO ASP VAL ASN VAL SER GLY GLN LYS PHE CYS ILE LYS          
SEQRES   7 A  137  LEU LEU VAL PRO SER PRO GLU GLY MET SER GLU ILE TYR          
SEQRES   8 A  137  LEU ARG CYS GLN ASP GLU GLN GLN TYR ALA ARG TRP MET          
SEQRES   9 A  137  ALA GLY CYS ARG LEU ALA SER LYS GLY ARG THR MET ALA          
SEQRES  10 A  137  ASP SER SER TYR THR SER GLU VAL GLN ALA ILE LEU ALA          
SEQRES  11 A  137  PHE LEU SER LEU GLN ARG THR                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      11.054   3.885 -20.959  1.00  0.00           N  
ATOM      2  CA  GLY A   1      11.578   2.546 -20.764  1.00  0.00           C  
ATOM      3  C   GLY A   1      11.540   1.719 -22.033  1.00  0.00           C  
ATOM      4  O   GLY A   1      10.793   2.027 -22.962  1.00  0.00           O  
ATOM      5  H1  GLY A   1      10.832   4.195 -21.862  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      12.600   2.618 -20.424  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      10.991   2.049 -20.007  1.00  0.00           H  
ATOM      8  N   SER A   2      12.350   0.664 -22.075  1.00  0.00           N  
ATOM      9  CA  SER A   2      12.410  -0.207 -23.243  1.00  0.00           C  
ATOM     10  C   SER A   2      11.430  -1.368 -23.104  1.00  0.00           C  
ATOM     11  O   SER A   2      11.568  -2.209 -22.216  1.00  0.00           O  
ATOM     12  CB  SER A   2      13.830  -0.744 -23.432  1.00  0.00           C  
ATOM     13  OG  SER A   2      14.682   0.248 -23.979  1.00  0.00           O  
ATOM     14  H   SER A   2      12.922   0.471 -21.303  1.00  0.00           H  
ATOM     15  HA  SER A   2      12.137   0.378 -24.108  1.00  0.00           H  
ATOM     16  HB2 SER A   2      14.226  -1.053 -22.478  1.00  0.00           H  
ATOM     17  HB3 SER A   2      13.806  -1.590 -24.104  1.00  0.00           H  
ATOM     18  HG  SER A   2      14.829   0.066 -24.910  1.00  0.00           H  
ATOM     19  N   SER A   3      10.439  -1.407 -23.990  1.00  0.00           N  
ATOM     20  CA  SER A   3       9.434  -2.462 -23.966  1.00  0.00           C  
ATOM     21  C   SER A   3       8.761  -2.603 -25.328  1.00  0.00           C  
ATOM     22  O   SER A   3       8.376  -1.613 -25.948  1.00  0.00           O  
ATOM     23  CB  SER A   3       8.382  -2.169 -22.894  1.00  0.00           C  
ATOM     24  OG  SER A   3       7.568  -3.304 -22.652  1.00  0.00           O  
ATOM     25  H   SER A   3      10.383  -0.708 -24.675  1.00  0.00           H  
ATOM     26  HA  SER A   3       9.931  -3.389 -23.726  1.00  0.00           H  
ATOM     27  HB2 SER A   3       8.876  -1.893 -21.975  1.00  0.00           H  
ATOM     28  HB3 SER A   3       7.753  -1.354 -23.224  1.00  0.00           H  
ATOM     29  HG  SER A   3       6.649  -3.034 -22.599  1.00  0.00           H  
ATOM     30  N   GLY A   4       8.623  -3.843 -25.788  1.00  0.00           N  
ATOM     31  CA  GLY A   4       7.998  -4.093 -27.073  1.00  0.00           C  
ATOM     32  C   GLY A   4       6.687  -4.842 -26.944  1.00  0.00           C  
ATOM     33  O   GLY A   4       5.692  -4.289 -26.476  1.00  0.00           O  
ATOM     34  H   GLY A   4       8.950  -4.595 -25.249  1.00  0.00           H  
ATOM     35  HA2 GLY A   4       7.814  -3.147 -27.562  1.00  0.00           H  
ATOM     36  HA3 GLY A   4       8.673  -4.676 -27.683  1.00  0.00           H  
ATOM     37  N   SER A   5       6.684  -6.104 -27.363  1.00  0.00           N  
ATOM     38  CA  SER A   5       5.483  -6.928 -27.297  1.00  0.00           C  
ATOM     39  C   SER A   5       5.671  -8.084 -26.319  1.00  0.00           C  
ATOM     40  O   SER A   5       6.657  -8.818 -26.391  1.00  0.00           O  
ATOM     41  CB  SER A   5       5.135  -7.471 -28.685  1.00  0.00           C  
ATOM     42  OG  SER A   5       4.454  -6.496 -29.457  1.00  0.00           O  
ATOM     43  H   SER A   5       7.509  -6.487 -27.727  1.00  0.00           H  
ATOM     44  HA  SER A   5       4.673  -6.306 -26.949  1.00  0.00           H  
ATOM     45  HB2 SER A   5       6.042  -7.749 -29.198  1.00  0.00           H  
ATOM     46  HB3 SER A   5       4.499  -8.338 -28.580  1.00  0.00           H  
ATOM     47  HG  SER A   5       5.057  -5.780 -29.671  1.00  0.00           H  
ATOM     48  N   SER A   6       4.718  -8.239 -25.406  1.00  0.00           N  
ATOM     49  CA  SER A   6       4.780  -9.303 -24.411  1.00  0.00           C  
ATOM     50  C   SER A   6       3.415  -9.518 -23.760  1.00  0.00           C  
ATOM     51  O   SER A   6       2.479  -8.753 -23.989  1.00  0.00           O  
ATOM     52  CB  SER A   6       5.820  -8.970 -23.340  1.00  0.00           C  
ATOM     53  OG  SER A   6       7.131  -9.256 -23.797  1.00  0.00           O  
ATOM     54  H   SER A   6       3.957  -7.622 -25.400  1.00  0.00           H  
ATOM     55  HA  SER A   6       5.072 -10.212 -24.914  1.00  0.00           H  
ATOM     56  HB2 SER A   6       5.758  -7.921 -23.096  1.00  0.00           H  
ATOM     57  HB3 SER A   6       5.623  -9.558 -22.456  1.00  0.00           H  
ATOM     58  HG  SER A   6       7.739  -9.240 -23.054  1.00  0.00           H  
ATOM     59  N   GLY A   7       3.312 -10.565 -22.948  1.00  0.00           N  
ATOM     60  CA  GLY A   7       2.061 -10.863 -22.277  1.00  0.00           C  
ATOM     61  C   GLY A   7       1.692  -9.815 -21.247  1.00  0.00           C  
ATOM     62  O   GLY A   7       2.483  -8.919 -20.951  1.00  0.00           O  
ATOM     63  H   GLY A   7       4.093 -11.141 -22.803  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       1.275 -10.922 -23.015  1.00  0.00           H  
ATOM     65  HA3 GLY A   7       2.150 -11.821 -21.783  1.00  0.00           H  
ATOM     66  N   ILE A   8       0.485  -9.924 -20.701  1.00  0.00           N  
ATOM     67  CA  ILE A   8       0.012  -8.976 -19.699  1.00  0.00           C  
ATOM     68  C   ILE A   8       0.902  -8.996 -18.461  1.00  0.00           C  
ATOM     69  O   ILE A   8       1.293 -10.052 -17.963  1.00  0.00           O  
ATOM     70  CB  ILE A   8      -1.439  -9.278 -19.279  1.00  0.00           C  
ATOM     71  CG1 ILE A   8      -2.370  -9.200 -20.491  1.00  0.00           C  
ATOM     72  CG2 ILE A   8      -1.888  -8.310 -18.195  1.00  0.00           C  
ATOM     73  CD1 ILE A   8      -3.834  -9.330 -20.137  1.00  0.00           C  
ATOM     74  H   ILE A   8      -0.101 -10.659 -20.978  1.00  0.00           H  
ATOM     75  HA  ILE A   8       0.041  -7.988 -20.135  1.00  0.00           H  
ATOM     76  HB  ILE A   8      -1.472 -10.277 -18.873  1.00  0.00           H  
ATOM     77 HG12 ILE A   8      -2.232  -8.249 -20.983  1.00  0.00           H  
ATOM     78 HG13 ILE A   8      -2.122  -9.995 -21.179  1.00  0.00           H  
ATOM     79 HG21 ILE A   8      -2.342  -7.444 -18.652  1.00  0.00           H  
ATOM     80 HG22 ILE A   8      -2.608  -8.798 -17.555  1.00  0.00           H  
ATOM     81 HG23 ILE A   8      -1.035  -8.003 -17.610  1.00  0.00           H  
ATOM     82 HD11 ILE A   8      -4.438  -8.982 -20.964  1.00  0.00           H  
ATOM     83 HD12 ILE A   8      -4.066 -10.365 -19.935  1.00  0.00           H  
ATOM     84 HD13 ILE A   8      -4.049  -8.735 -19.262  1.00  0.00           H  
ATOM     85  N   PRO A   9       1.229  -7.800 -17.949  1.00  0.00           N  
ATOM     86  CA  PRO A   9       2.075  -7.653 -16.761  1.00  0.00           C  
ATOM     87  C   PRO A   9       1.373  -8.114 -15.489  1.00  0.00           C  
ATOM     88  O   PRO A   9       0.433  -7.472 -15.020  1.00  0.00           O  
ATOM     89  CB  PRO A   9       2.349  -6.148 -16.705  1.00  0.00           C  
ATOM     90  CG  PRO A   9       1.197  -5.526 -17.416  1.00  0.00           C  
ATOM     91  CD  PRO A   9       0.800  -6.500 -18.491  1.00  0.00           C  
ATOM     92  HA  PRO A   9       3.008  -8.186 -16.869  1.00  0.00           H  
ATOM     93  HB2 PRO A   9       2.397  -5.826 -15.674  1.00  0.00           H  
ATOM     94  HB3 PRO A   9       3.282  -5.928 -17.200  1.00  0.00           H  
ATOM     95  HG2 PRO A   9       0.379  -5.374 -16.727  1.00  0.00           H  
ATOM     96  HG3 PRO A   9       1.499  -4.587 -17.855  1.00  0.00           H  
ATOM     97  HD2 PRO A   9      -0.270  -6.480 -18.642  1.00  0.00           H  
ATOM     98  HD3 PRO A   9       1.316  -6.276 -19.412  1.00  0.00           H  
ATOM     99  N   GLU A  10       1.835  -9.231 -14.934  1.00  0.00           N  
ATOM    100  CA  GLU A  10       1.249  -9.778 -13.716  1.00  0.00           C  
ATOM    101  C   GLU A  10       2.328 -10.069 -12.677  1.00  0.00           C  
ATOM    102  O   GLU A  10       3.452 -10.438 -13.020  1.00  0.00           O  
ATOM    103  CB  GLU A  10       0.468 -11.055 -14.028  1.00  0.00           C  
ATOM    104  CG  GLU A  10      -0.874 -10.800 -14.693  1.00  0.00           C  
ATOM    105  CD  GLU A  10      -1.785 -12.013 -14.654  1.00  0.00           C  
ATOM    106  OE1 GLU A  10      -2.304 -12.328 -13.562  1.00  0.00           O  
ATOM    107  OE2 GLU A  10      -1.977 -12.646 -15.713  1.00  0.00           O  
ATOM    108  H   GLU A  10       2.587  -9.698 -15.356  1.00  0.00           H  
ATOM    109  HA  GLU A  10       0.571  -9.040 -13.315  1.00  0.00           H  
ATOM    110  HB2 GLU A  10       1.061 -11.674 -14.685  1.00  0.00           H  
ATOM    111  HB3 GLU A  10       0.293 -11.590 -13.106  1.00  0.00           H  
ATOM    112  HG2 GLU A  10      -1.365  -9.984 -14.184  1.00  0.00           H  
ATOM    113  HG3 GLU A  10      -0.705 -10.529 -15.725  1.00  0.00           H  
ATOM    114  N   LEU A  11       1.979  -9.901 -11.407  1.00  0.00           N  
ATOM    115  CA  LEU A  11       2.917 -10.145 -10.316  1.00  0.00           C  
ATOM    116  C   LEU A  11       2.654 -11.499  -9.666  1.00  0.00           C  
ATOM    117  O   LEU A  11       1.506 -11.922  -9.528  1.00  0.00           O  
ATOM    118  CB  LEU A  11       2.813  -9.035  -9.270  1.00  0.00           C  
ATOM    119  CG  LEU A  11       3.749  -7.841  -9.462  1.00  0.00           C  
ATOM    120  CD1 LEU A  11       3.116  -6.571  -8.915  1.00  0.00           C  
ATOM    121  CD2 LEU A  11       5.090  -8.101  -8.793  1.00  0.00           C  
ATOM    122  H   LEU A  11       1.070  -9.605 -11.196  1.00  0.00           H  
ATOM    123  HA  LEU A  11       3.914 -10.146 -10.731  1.00  0.00           H  
ATOM    124  HB2 LEU A  11       1.799  -8.664  -9.280  1.00  0.00           H  
ATOM    125  HB3 LEU A  11       3.026  -9.470  -8.304  1.00  0.00           H  
ATOM    126  HG  LEU A  11       3.925  -7.696 -10.519  1.00  0.00           H  
ATOM    127 HD11 LEU A  11       2.151  -6.804  -8.492  1.00  0.00           H  
ATOM    128 HD12 LEU A  11       2.995  -5.856  -9.715  1.00  0.00           H  
ATOM    129 HD13 LEU A  11       3.753  -6.152  -8.150  1.00  0.00           H  
ATOM    130 HD21 LEU A  11       5.547  -7.161  -8.524  1.00  0.00           H  
ATOM    131 HD22 LEU A  11       5.736  -8.633  -9.475  1.00  0.00           H  
ATOM    132 HD23 LEU A  11       4.939  -8.696  -7.903  1.00  0.00           H  
ATOM    133  N   LYS A  12       3.726 -12.175  -9.264  1.00  0.00           N  
ATOM    134  CA  LYS A  12       3.612 -13.480  -8.625  1.00  0.00           C  
ATOM    135  C   LYS A  12       4.506 -13.560  -7.391  1.00  0.00           C  
ATOM    136  O   LYS A  12       5.729 -13.654  -7.505  1.00  0.00           O  
ATOM    137  CB  LYS A  12       3.985 -14.589  -9.611  1.00  0.00           C  
ATOM    138  CG  LYS A  12       3.176 -14.557 -10.895  1.00  0.00           C  
ATOM    139  CD  LYS A  12       1.762 -15.069 -10.677  1.00  0.00           C  
ATOM    140  CE  LYS A  12       1.198 -15.704 -11.940  1.00  0.00           C  
ATOM    141  NZ  LYS A  12       0.584 -14.691 -12.843  1.00  0.00           N  
ATOM    142  H   LYS A  12       4.615 -11.785  -9.402  1.00  0.00           H  
ATOM    143  HA  LYS A  12       2.585 -13.612  -8.319  1.00  0.00           H  
ATOM    144  HB2 LYS A  12       5.030 -14.492  -9.865  1.00  0.00           H  
ATOM    145  HB3 LYS A  12       3.826 -15.546  -9.135  1.00  0.00           H  
ATOM    146  HG2 LYS A  12       3.127 -13.539 -11.255  1.00  0.00           H  
ATOM    147  HG3 LYS A  12       3.664 -15.178 -11.633  1.00  0.00           H  
ATOM    148  HD2 LYS A  12       1.774 -15.810  -9.891  1.00  0.00           H  
ATOM    149  HD3 LYS A  12       1.129 -14.243 -10.387  1.00  0.00           H  
ATOM    150  HE2 LYS A  12       1.998 -16.204 -12.464  1.00  0.00           H  
ATOM    151  HE3 LYS A  12       0.445 -16.425 -11.659  1.00  0.00           H  
ATOM    152  HZ1 LYS A  12       0.159 -13.924 -12.284  1.00  0.00           H  
ATOM    153  HZ2 LYS A  12      -0.156 -15.133 -13.424  1.00  0.00           H  
ATOM    154  HZ3 LYS A  12       1.308 -14.287 -13.471  1.00  0.00           H  
ATOM    155  N   ASP A  13       3.890 -13.525  -6.215  1.00  0.00           N  
ATOM    156  CA  ASP A  13       4.630 -13.597  -4.961  1.00  0.00           C  
ATOM    157  C   ASP A  13       3.679 -13.720  -3.775  1.00  0.00           C  
ATOM    158  O   ASP A  13       2.631 -13.075  -3.737  1.00  0.00           O  
ATOM    159  CB  ASP A  13       5.515 -12.360  -4.795  1.00  0.00           C  
ATOM    160  CG  ASP A  13       6.882 -12.537  -5.424  1.00  0.00           C  
ATOM    161  OD1 ASP A  13       7.554 -13.541  -5.108  1.00  0.00           O  
ATOM    162  OD2 ASP A  13       7.281 -11.671  -6.231  1.00  0.00           O  
ATOM    163  H   ASP A  13       2.913 -13.449  -6.191  1.00  0.00           H  
ATOM    164  HA  ASP A  13       5.258 -14.474  -4.996  1.00  0.00           H  
ATOM    165  HB2 ASP A  13       5.031 -11.514  -5.262  1.00  0.00           H  
ATOM    166  HB3 ASP A  13       5.645 -12.158  -3.741  1.00  0.00           H  
ATOM    167  N   HIS A  14       4.051 -14.555  -2.808  1.00  0.00           N  
ATOM    168  CA  HIS A  14       3.230 -14.763  -1.621  1.00  0.00           C  
ATOM    169  C   HIS A  14       3.666 -13.836  -0.490  1.00  0.00           C  
ATOM    170  O   HIS A  14       4.757 -13.983   0.061  1.00  0.00           O  
ATOM    171  CB  HIS A  14       3.318 -16.220  -1.164  1.00  0.00           C  
ATOM    172  CG  HIS A  14       2.744 -16.456   0.198  1.00  0.00           C  
ATOM    173  ND1 HIS A  14       3.507 -16.847   1.279  1.00  0.00           N  
ATOM    174  CD2 HIS A  14       1.474 -16.354   0.654  1.00  0.00           C  
ATOM    175  CE1 HIS A  14       2.731 -16.975   2.340  1.00  0.00           C  
ATOM    176  NE2 HIS A  14       1.492 -16.681   1.987  1.00  0.00           N  
ATOM    177  H   HIS A  14       4.897 -15.040  -2.897  1.00  0.00           H  
ATOM    178  HA  HIS A  14       2.208 -14.537  -1.881  1.00  0.00           H  
ATOM    179  HB2 HIS A  14       2.778 -16.842  -1.864  1.00  0.00           H  
ATOM    180  HB3 HIS A  14       4.355 -16.523  -1.146  1.00  0.00           H  
ATOM    181  HD1 HIS A  14       4.473 -17.007   1.269  1.00  0.00           H  
ATOM    182  HD2 HIS A  14       0.606 -16.067   0.077  1.00  0.00           H  
ATOM    183  HE1 HIS A  14       3.053 -17.269   3.327  1.00  0.00           H  
ATOM    184  HE2 HIS A  14       0.704 -16.779   2.562  1.00  0.00           H  
ATOM    185  N   LEU A  15       2.807 -12.883  -0.149  1.00  0.00           N  
ATOM    186  CA  LEU A  15       3.103 -11.931   0.916  1.00  0.00           C  
ATOM    187  C   LEU A  15       2.664 -12.476   2.271  1.00  0.00           C  
ATOM    188  O   LEU A  15       2.220 -13.620   2.376  1.00  0.00           O  
ATOM    189  CB  LEU A  15       2.408 -10.596   0.641  1.00  0.00           C  
ATOM    190  CG  LEU A  15       2.646  -9.986  -0.741  1.00  0.00           C  
ATOM    191  CD1 LEU A  15       1.503  -9.059  -1.121  1.00  0.00           C  
ATOM    192  CD2 LEU A  15       3.974  -9.242  -0.774  1.00  0.00           C  
ATOM    193  H   LEU A  15       1.953 -12.816  -0.625  1.00  0.00           H  
ATOM    194  HA  LEU A  15       4.170 -11.775   0.933  1.00  0.00           H  
ATOM    195  HB2 LEU A  15       1.345 -10.746   0.757  1.00  0.00           H  
ATOM    196  HB3 LEU A  15       2.753  -9.887   1.380  1.00  0.00           H  
ATOM    197  HG  LEU A  15       2.689 -10.780  -1.474  1.00  0.00           H  
ATOM    198 HD11 LEU A  15       1.581  -8.800  -2.165  1.00  0.00           H  
ATOM    199 HD12 LEU A  15       1.553  -8.162  -0.522  1.00  0.00           H  
ATOM    200 HD13 LEU A  15       0.561  -9.557  -0.942  1.00  0.00           H  
ATOM    201 HD21 LEU A  15       4.379  -9.186   0.225  1.00  0.00           H  
ATOM    202 HD22 LEU A  15       3.815  -8.244  -1.155  1.00  0.00           H  
ATOM    203 HD23 LEU A  15       4.665  -9.767  -1.416  1.00  0.00           H  
ATOM    204  N   ARG A  16       2.788 -11.650   3.304  1.00  0.00           N  
ATOM    205  CA  ARG A  16       2.403 -12.050   4.653  1.00  0.00           C  
ATOM    206  C   ARG A  16       0.900 -11.891   4.858  1.00  0.00           C  
ATOM    207  O   ARG A  16       0.371 -10.780   4.812  1.00  0.00           O  
ATOM    208  CB  ARG A  16       3.161 -11.218   5.689  1.00  0.00           C  
ATOM    209  CG  ARG A  16       4.540 -11.765   6.018  1.00  0.00           C  
ATOM    210  CD  ARG A  16       4.984 -11.356   7.415  1.00  0.00           C  
ATOM    211  NE  ARG A  16       6.408 -11.596   7.629  1.00  0.00           N  
ATOM    212  CZ  ARG A  16       6.907 -12.768   8.004  1.00  0.00           C  
ATOM    213  NH1 ARG A  16       6.103 -13.802   8.207  1.00  0.00           N  
ATOM    214  NH2 ARG A  16       8.215 -12.908   8.179  1.00  0.00           N  
ATOM    215  H   ARG A  16       3.149 -10.751   3.157  1.00  0.00           H  
ATOM    216  HA  ARG A  16       2.664 -13.089   4.778  1.00  0.00           H  
ATOM    217  HB2 ARG A  16       3.278 -10.212   5.313  1.00  0.00           H  
ATOM    218  HB3 ARG A  16       2.583 -11.187   6.601  1.00  0.00           H  
ATOM    219  HG2 ARG A  16       4.512 -12.844   5.963  1.00  0.00           H  
ATOM    220  HG3 ARG A  16       5.249 -11.384   5.299  1.00  0.00           H  
ATOM    221  HD2 ARG A  16       4.782 -10.304   7.548  1.00  0.00           H  
ATOM    222  HD3 ARG A  16       4.419 -11.926   8.138  1.00  0.00           H  
ATOM    223  HE  ARG A  16       7.022 -10.845   7.485  1.00  0.00           H  
ATOM    224 HH11 ARG A  16       5.117 -13.699   8.074  1.00  0.00           H  
ATOM    225 HH12 ARG A  16       6.481 -14.683   8.488  1.00  0.00           H  
ATOM    226 HH21 ARG A  16       8.826 -12.131   8.028  1.00  0.00           H  
ATOM    227 HH22 ARG A  16       8.590 -13.790   8.462  1.00  0.00           H  
ATOM    228  N   ILE A  17       0.218 -13.008   5.084  1.00  0.00           N  
ATOM    229  CA  ILE A  17      -1.224 -12.993   5.297  1.00  0.00           C  
ATOM    230  C   ILE A  17      -1.587 -13.604   6.646  1.00  0.00           C  
ATOM    231  O   ILE A  17      -1.225 -14.743   6.942  1.00  0.00           O  
ATOM    232  CB  ILE A  17      -1.967 -13.756   4.184  1.00  0.00           C  
ATOM    233  CG1 ILE A  17      -1.917 -12.967   2.874  1.00  0.00           C  
ATOM    234  CG2 ILE A  17      -3.406 -14.023   4.595  1.00  0.00           C  
ATOM    235  CD1 ILE A  17      -2.747 -13.581   1.768  1.00  0.00           C  
ATOM    236  H   ILE A  17       0.695 -13.864   5.109  1.00  0.00           H  
ATOM    237  HA  ILE A  17      -1.553 -11.963   5.280  1.00  0.00           H  
ATOM    238  HB  ILE A  17      -1.476 -14.708   4.042  1.00  0.00           H  
ATOM    239 HG12 ILE A  17      -2.285 -11.969   3.049  1.00  0.00           H  
ATOM    240 HG13 ILE A  17      -0.893 -12.916   2.532  1.00  0.00           H  
ATOM    241 HG21 ILE A  17      -3.422 -14.705   5.432  1.00  0.00           H  
ATOM    242 HG22 ILE A  17      -3.877 -13.094   4.878  1.00  0.00           H  
ATOM    243 HG23 ILE A  17      -3.942 -14.460   3.765  1.00  0.00           H  
ATOM    244 HD11 ILE A  17      -2.835 -14.645   1.932  1.00  0.00           H  
ATOM    245 HD12 ILE A  17      -3.731 -13.135   1.766  1.00  0.00           H  
ATOM    246 HD13 ILE A  17      -2.268 -13.402   0.817  1.00  0.00           H  
ATOM    247  N   PHE A  18      -2.307 -12.840   7.461  1.00  0.00           N  
ATOM    248  CA  PHE A  18      -2.721 -13.306   8.780  1.00  0.00           C  
ATOM    249  C   PHE A  18      -4.194 -12.994   9.029  1.00  0.00           C  
ATOM    250  O   PHE A  18      -4.652 -11.878   8.788  1.00  0.00           O  
ATOM    251  CB  PHE A  18      -1.860 -12.659   9.866  1.00  0.00           C  
ATOM    252  CG  PHE A  18      -2.330 -12.957  11.261  1.00  0.00           C  
ATOM    253  CD1 PHE A  18      -2.347 -14.258  11.738  1.00  0.00           C  
ATOM    254  CD2 PHE A  18      -2.757 -11.936  12.096  1.00  0.00           C  
ATOM    255  CE1 PHE A  18      -2.779 -14.536  13.021  1.00  0.00           C  
ATOM    256  CE2 PHE A  18      -3.190 -12.208  13.379  1.00  0.00           C  
ATOM    257  CZ  PHE A  18      -3.201 -13.509  13.843  1.00  0.00           C  
ATOM    258  H   PHE A  18      -2.566 -11.941   7.169  1.00  0.00           H  
ATOM    259  HA  PHE A  18      -2.582 -14.375   8.811  1.00  0.00           H  
ATOM    260  HB2 PHE A  18      -0.846 -13.018   9.774  1.00  0.00           H  
ATOM    261  HB3 PHE A  18      -1.871 -11.588   9.732  1.00  0.00           H  
ATOM    262  HD1 PHE A  18      -2.016 -15.062  11.095  1.00  0.00           H  
ATOM    263  HD2 PHE A  18      -2.750 -10.918  11.734  1.00  0.00           H  
ATOM    264  HE1 PHE A  18      -2.786 -15.554  13.379  1.00  0.00           H  
ATOM    265  HE2 PHE A  18      -3.520 -11.403  14.020  1.00  0.00           H  
ATOM    266  HZ  PHE A  18      -3.540 -13.724  14.845  1.00  0.00           H  
ATOM    267  N   ARG A  19      -4.929 -13.990   9.514  1.00  0.00           N  
ATOM    268  CA  ARG A  19      -6.350 -13.823   9.794  1.00  0.00           C  
ATOM    269  C   ARG A  19      -6.707 -14.408  11.157  1.00  0.00           C  
ATOM    270  O   ARG A  19      -7.077 -15.576  11.282  1.00  0.00           O  
ATOM    271  CB  ARG A  19      -7.189 -14.493   8.705  1.00  0.00           C  
ATOM    272  CG  ARG A  19      -7.308 -13.667   7.434  1.00  0.00           C  
ATOM    273  CD  ARG A  19      -7.853 -14.496   6.280  1.00  0.00           C  
ATOM    274  NE  ARG A  19      -7.060 -15.701   6.050  1.00  0.00           N  
ATOM    275  CZ  ARG A  19      -7.403 -16.654   5.190  1.00  0.00           C  
ATOM    276  NH1 ARG A  19      -8.518 -16.541   4.483  1.00  0.00           N  
ATOM    277  NH2 ARG A  19      -6.629 -17.720   5.037  1.00  0.00           N  
ATOM    278  H   ARG A  19      -4.507 -14.857   9.686  1.00  0.00           H  
ATOM    279  HA  ARG A  19      -6.565 -12.765   9.802  1.00  0.00           H  
ATOM    280  HB2 ARG A  19      -6.738 -15.441   8.450  1.00  0.00           H  
ATOM    281  HB3 ARG A  19      -8.183 -14.669   9.088  1.00  0.00           H  
ATOM    282  HG2 ARG A  19      -7.978 -12.840   7.615  1.00  0.00           H  
ATOM    283  HG3 ARG A  19      -6.332 -13.292   7.167  1.00  0.00           H  
ATOM    284  HD2 ARG A  19      -8.868 -14.783   6.509  1.00  0.00           H  
ATOM    285  HD3 ARG A  19      -7.842 -13.893   5.385  1.00  0.00           H  
ATOM    286  HE  ARG A  19      -6.231 -15.803   6.563  1.00  0.00           H  
ATOM    287 HH11 ARG A  19      -9.103 -15.738   4.596  1.00  0.00           H  
ATOM    288 HH12 ARG A  19      -8.774 -17.259   3.834  1.00  0.00           H  
ATOM    289 HH21 ARG A  19      -5.787 -17.807   5.568  1.00  0.00           H  
ATOM    290 HH22 ARG A  19      -6.888 -18.436   4.389  1.00  0.00           H  
ATOM    291  N   PRO A  20      -6.594 -13.579  12.205  1.00  0.00           N  
ATOM    292  CA  PRO A  20      -6.900 -13.991  13.578  1.00  0.00           C  
ATOM    293  C   PRO A  20      -8.391 -14.220  13.797  1.00  0.00           C  
ATOM    294  O   PRO A  20      -8.797 -14.841  14.778  1.00  0.00           O  
ATOM    295  CB  PRO A  20      -6.410 -12.811  14.421  1.00  0.00           C  
ATOM    296  CG  PRO A  20      -6.469 -11.639  13.502  1.00  0.00           C  
ATOM    297  CD  PRO A  20      -6.158 -12.174  12.131  1.00  0.00           C  
ATOM    298  HA  PRO A  20      -6.355 -14.883  13.855  1.00  0.00           H  
ATOM    299  HB2 PRO A  20      -7.064 -12.678  15.272  1.00  0.00           H  
ATOM    300  HB3 PRO A  20      -5.402 -12.997  14.759  1.00  0.00           H  
ATOM    301  HG2 PRO A  20      -7.456 -11.206  13.521  1.00  0.00           H  
ATOM    302  HG3 PRO A  20      -5.730 -10.908  13.794  1.00  0.00           H  
ATOM    303  HD2 PRO A  20      -6.718 -11.636  11.381  1.00  0.00           H  
ATOM    304  HD3 PRO A  20      -5.099 -12.109  11.931  1.00  0.00           H  
ATOM    305  N   ARG A  21      -9.204 -13.714  12.874  1.00  0.00           N  
ATOM    306  CA  ARG A  21     -10.651 -13.863  12.966  1.00  0.00           C  
ATOM    307  C   ARG A  21     -11.132 -15.040  12.121  1.00  0.00           C  
ATOM    308  O   ARG A  21     -12.198 -14.984  11.510  1.00  0.00           O  
ATOM    309  CB  ARG A  21     -11.347 -12.578  12.513  1.00  0.00           C  
ATOM    310  CG  ARG A  21     -11.150 -11.411  13.466  1.00  0.00           C  
ATOM    311  CD  ARG A  21     -12.036 -11.540  14.695  1.00  0.00           C  
ATOM    312  NE  ARG A  21     -13.438 -11.267  14.392  1.00  0.00           N  
ATOM    313  CZ  ARG A  21     -14.448 -11.676  15.152  1.00  0.00           C  
ATOM    314  NH1 ARG A  21     -14.212 -12.371  16.255  1.00  0.00           N  
ATOM    315  NH2 ARG A  21     -15.697 -11.388  14.808  1.00  0.00           N  
ATOM    316  H   ARG A  21      -8.821 -13.228  12.113  1.00  0.00           H  
ATOM    317  HA  ARG A  21     -10.900 -14.052  14.000  1.00  0.00           H  
ATOM    318  HB2 ARG A  21     -10.960 -12.295  11.546  1.00  0.00           H  
ATOM    319  HB3 ARG A  21     -12.406 -12.769  12.425  1.00  0.00           H  
ATOM    320  HG2 ARG A  21     -10.117 -11.385  13.781  1.00  0.00           H  
ATOM    321  HG3 ARG A  21     -11.394 -10.494  12.951  1.00  0.00           H  
ATOM    322  HD2 ARG A  21     -11.949 -12.545  15.081  1.00  0.00           H  
ATOM    323  HD3 ARG A  21     -11.696 -10.838  15.443  1.00  0.00           H  
ATOM    324  HE  ARG A  21     -13.635 -10.754  13.580  1.00  0.00           H  
ATOM    325 HH11 ARG A  21     -13.272 -12.588  16.517  1.00  0.00           H  
ATOM    326 HH12 ARG A  21     -14.975 -12.677  16.826  1.00  0.00           H  
ATOM    327 HH21 ARG A  21     -15.879 -10.863  13.977  1.00  0.00           H  
ATOM    328 HH22 ARG A  21     -16.456 -11.696  15.380  1.00  0.00           H  
ATOM    329  N   LYS A  22     -10.336 -16.104  12.092  1.00  0.00           N  
ATOM    330  CA  LYS A  22     -10.679 -17.295  11.324  1.00  0.00           C  
ATOM    331  C   LYS A  22      -9.733 -18.445  11.653  1.00  0.00           C  
ATOM    332  O   LYS A  22      -8.617 -18.229  12.129  1.00  0.00           O  
ATOM    333  CB  LYS A  22     -10.628 -16.992   9.825  1.00  0.00           C  
ATOM    334  CG  LYS A  22     -11.464 -17.940   8.983  1.00  0.00           C  
ATOM    335  CD  LYS A  22     -12.950 -17.655   9.132  1.00  0.00           C  
ATOM    336  CE  LYS A  22     -13.759 -18.331   8.036  1.00  0.00           C  
ATOM    337  NZ  LYS A  22     -15.222 -18.273   8.310  1.00  0.00           N  
ATOM    338  H   LYS A  22      -9.498 -16.087  12.601  1.00  0.00           H  
ATOM    339  HA  LYS A  22     -11.684 -17.584  11.590  1.00  0.00           H  
ATOM    340  HB2 LYS A  22     -10.987 -15.986   9.661  1.00  0.00           H  
ATOM    341  HB3 LYS A  22      -9.603 -17.057   9.491  1.00  0.00           H  
ATOM    342  HG2 LYS A  22     -11.189 -17.826   7.946  1.00  0.00           H  
ATOM    343  HG3 LYS A  22     -11.269 -18.955   9.300  1.00  0.00           H  
ATOM    344  HD2 LYS A  22     -13.284 -18.023  10.091  1.00  0.00           H  
ATOM    345  HD3 LYS A  22     -13.109 -16.588   9.079  1.00  0.00           H  
ATOM    346  HE2 LYS A  22     -13.557 -17.836   7.100  1.00  0.00           H  
ATOM    347  HE3 LYS A  22     -13.455 -19.366   7.968  1.00  0.00           H  
ATOM    348  HZ1 LYS A  22     -15.756 -18.339   7.421  1.00  0.00           H  
ATOM    349  HZ2 LYS A  22     -15.462 -17.375   8.779  1.00  0.00           H  
ATOM    350  HZ3 LYS A  22     -15.501 -19.060   8.930  1.00  0.00           H  
ATOM    351  N   LEU A  23     -10.184 -19.668  11.395  1.00  0.00           N  
ATOM    352  CA  LEU A  23      -9.377 -20.853  11.663  1.00  0.00           C  
ATOM    353  C   LEU A  23      -7.985 -20.713  11.053  1.00  0.00           C  
ATOM    354  O   LEU A  23      -7.835 -20.620   9.835  1.00  0.00           O  
ATOM    355  CB  LEU A  23     -10.067 -22.100  11.106  1.00  0.00           C  
ATOM    356  CG  LEU A  23     -11.466 -22.393  11.650  1.00  0.00           C  
ATOM    357  CD1 LEU A  23     -12.107 -23.538  10.884  1.00  0.00           C  
ATOM    358  CD2 LEU A  23     -11.402 -22.713  13.136  1.00  0.00           C  
ATOM    359  H   LEU A  23     -11.081 -19.777  11.016  1.00  0.00           H  
ATOM    360  HA  LEU A  23      -9.280 -20.953  12.733  1.00  0.00           H  
ATOM    361  HB2 LEU A  23     -10.146 -21.984  10.036  1.00  0.00           H  
ATOM    362  HB3 LEU A  23      -9.439 -22.952  11.328  1.00  0.00           H  
ATOM    363  HG  LEU A  23     -12.086 -21.517  11.522  1.00  0.00           H  
ATOM    364 HD11 LEU A  23     -11.633 -23.636   9.919  1.00  0.00           H  
ATOM    365 HD12 LEU A  23     -13.160 -23.336  10.749  1.00  0.00           H  
ATOM    366 HD13 LEU A  23     -11.986 -24.456  11.439  1.00  0.00           H  
ATOM    367 HD21 LEU A  23     -10.372 -22.821  13.438  1.00  0.00           H  
ATOM    368 HD22 LEU A  23     -11.932 -23.634  13.329  1.00  0.00           H  
ATOM    369 HD23 LEU A  23     -11.860 -21.911  13.697  1.00  0.00           H  
ATOM    370  N   THR A  24      -6.968 -20.702  11.910  1.00  0.00           N  
ATOM    371  CA  THR A  24      -5.589 -20.574  11.457  1.00  0.00           C  
ATOM    372  C   THR A  24      -4.631 -21.283  12.407  1.00  0.00           C  
ATOM    373  O   THR A  24      -4.906 -21.411  13.600  1.00  0.00           O  
ATOM    374  CB  THR A  24      -5.172 -19.097  11.333  1.00  0.00           C  
ATOM    375  OG1 THR A  24      -3.835 -19.006  10.832  1.00  0.00           O  
ATOM    376  CG2 THR A  24      -5.263 -18.395  12.679  1.00  0.00           C  
ATOM    377  H   THR A  24      -7.153 -20.779  12.869  1.00  0.00           H  
ATOM    378  HA  THR A  24      -5.516 -21.030  10.479  1.00  0.00           H  
ATOM    379  HB  THR A  24      -5.842 -18.606  10.642  1.00  0.00           H  
ATOM    380  HG1 THR A  24      -3.472 -18.142  11.043  1.00  0.00           H  
ATOM    381 HG21 THR A  24      -6.104 -18.787  13.233  1.00  0.00           H  
ATOM    382 HG22 THR A  24      -5.399 -17.335  12.524  1.00  0.00           H  
ATOM    383 HG23 THR A  24      -4.354 -18.564  13.236  1.00  0.00           H  
ATOM    384  N   LEU A  25      -3.506 -21.742  11.871  1.00  0.00           N  
ATOM    385  CA  LEU A  25      -2.505 -22.438  12.672  1.00  0.00           C  
ATOM    386  C   LEU A  25      -1.100 -21.953  12.330  1.00  0.00           C  
ATOM    387  O   LEU A  25      -0.814 -21.599  11.186  1.00  0.00           O  
ATOM    388  CB  LEU A  25      -2.603 -23.949  12.447  1.00  0.00           C  
ATOM    389  CG  LEU A  25      -3.595 -24.696  13.339  1.00  0.00           C  
ATOM    390  CD1 LEU A  25      -5.013 -24.538  12.811  1.00  0.00           C  
ATOM    391  CD2 LEU A  25      -3.222 -26.168  13.436  1.00  0.00           C  
ATOM    392  H   LEU A  25      -3.343 -21.611  10.914  1.00  0.00           H  
ATOM    393  HA  LEU A  25      -2.704 -22.223  13.711  1.00  0.00           H  
ATOM    394  HB2 LEU A  25      -2.894 -24.112  11.421  1.00  0.00           H  
ATOM    395  HB3 LEU A  25      -1.623 -24.372  12.614  1.00  0.00           H  
ATOM    396  HG  LEU A  25      -3.562 -24.276  14.335  1.00  0.00           H  
ATOM    397 HD11 LEU A  25      -5.662 -25.243  13.306  1.00  0.00           H  
ATOM    398 HD12 LEU A  25      -5.023 -24.723  11.747  1.00  0.00           H  
ATOM    399 HD13 LEU A  25      -5.359 -23.533  13.004  1.00  0.00           H  
ATOM    400 HD21 LEU A  25      -4.103 -26.749  13.665  1.00  0.00           H  
ATOM    401 HD22 LEU A  25      -2.488 -26.303  14.216  1.00  0.00           H  
ATOM    402 HD23 LEU A  25      -2.809 -26.496  12.493  1.00  0.00           H  
ATOM    403  N   LYS A  26      -0.224 -21.941  13.329  1.00  0.00           N  
ATOM    404  CA  LYS A  26       1.153 -21.503  13.135  1.00  0.00           C  
ATOM    405  C   LYS A  26       1.199 -20.082  12.582  1.00  0.00           C  
ATOM    406  O   LYS A  26       2.014 -19.769  11.716  1.00  0.00           O  
ATOM    407  CB  LYS A  26       1.884 -22.455  12.186  1.00  0.00           C  
ATOM    408  CG  LYS A  26       2.484 -23.665  12.881  1.00  0.00           C  
ATOM    409  CD  LYS A  26       1.407 -24.624  13.360  1.00  0.00           C  
ATOM    410  CE  LYS A  26       2.010 -25.860  14.009  1.00  0.00           C  
ATOM    411  NZ  LYS A  26       2.406 -26.879  12.997  1.00  0.00           N  
ATOM    412  H   LYS A  26      -0.512 -22.235  14.220  1.00  0.00           H  
ATOM    413  HA  LYS A  26       1.644 -21.519  14.096  1.00  0.00           H  
ATOM    414  HB2 LYS A  26       1.187 -22.804  11.438  1.00  0.00           H  
ATOM    415  HB3 LYS A  26       2.682 -21.914  11.697  1.00  0.00           H  
ATOM    416  HG2 LYS A  26       3.129 -24.184  12.188  1.00  0.00           H  
ATOM    417  HG3 LYS A  26       3.060 -23.331  13.732  1.00  0.00           H  
ATOM    418  HD2 LYS A  26       0.784 -24.119  14.085  1.00  0.00           H  
ATOM    419  HD3 LYS A  26       0.806 -24.928  12.516  1.00  0.00           H  
ATOM    420  HE2 LYS A  26       2.883 -25.567  14.571  1.00  0.00           H  
ATOM    421  HE3 LYS A  26       1.280 -26.293  14.676  1.00  0.00           H  
ATOM    422  HZ1 LYS A  26       3.252 -26.562  12.483  1.00  0.00           H  
ATOM    423  HZ2 LYS A  26       1.633 -27.026  12.316  1.00  0.00           H  
ATOM    424  HZ3 LYS A  26       2.616 -27.784  13.464  1.00  0.00           H  
ATOM    425  N   GLY A  27       0.319 -19.225  13.091  1.00  0.00           N  
ATOM    426  CA  GLY A  27       0.278 -17.848  12.636  1.00  0.00           C  
ATOM    427  C   GLY A  27       0.028 -17.736  11.146  1.00  0.00           C  
ATOM    428  O   GLY A  27      -1.100 -17.912  10.683  1.00  0.00           O  
ATOM    429  H   GLY A  27      -0.308 -19.530  13.780  1.00  0.00           H  
ATOM    430  HA2 GLY A  27      -0.510 -17.330  13.163  1.00  0.00           H  
ATOM    431  HA3 GLY A  27       1.222 -17.376  12.867  1.00  0.00           H  
ATOM    432  N   TYR A  28       1.080 -17.441  10.391  1.00  0.00           N  
ATOM    433  CA  TYR A  28       0.968 -17.302   8.944  1.00  0.00           C  
ATOM    434  C   TYR A  28       1.005 -18.667   8.261  1.00  0.00           C  
ATOM    435  O   TYR A  28       1.577 -19.621   8.786  1.00  0.00           O  
ATOM    436  CB  TYR A  28       2.097 -16.421   8.406  1.00  0.00           C  
ATOM    437  CG  TYR A  28       1.977 -14.969   8.812  1.00  0.00           C  
ATOM    438  CD1 TYR A  28       2.486 -14.522  10.024  1.00  0.00           C  
ATOM    439  CD2 TYR A  28       1.356 -14.045   7.980  1.00  0.00           C  
ATOM    440  CE1 TYR A  28       2.378 -13.197  10.399  1.00  0.00           C  
ATOM    441  CE2 TYR A  28       1.245 -12.717   8.346  1.00  0.00           C  
ATOM    442  CZ  TYR A  28       1.756 -12.298   9.557  1.00  0.00           C  
ATOM    443  OH  TYR A  28       1.648 -10.977   9.926  1.00  0.00           O  
ATOM    444  H   TYR A  28       1.954 -17.313  10.817  1.00  0.00           H  
ATOM    445  HA  TYR A  28       0.022 -16.829   8.728  1.00  0.00           H  
ATOM    446  HB2 TYR A  28       3.041 -16.792   8.776  1.00  0.00           H  
ATOM    447  HB3 TYR A  28       2.096 -16.466   7.327  1.00  0.00           H  
ATOM    448  HD1 TYR A  28       2.971 -15.229  10.682  1.00  0.00           H  
ATOM    449  HD2 TYR A  28       0.956 -14.376   7.033  1.00  0.00           H  
ATOM    450  HE1 TYR A  28       2.778 -12.869  11.347  1.00  0.00           H  
ATOM    451  HE2 TYR A  28       0.758 -12.014   7.688  1.00  0.00           H  
ATOM    452  HH  TYR A  28       1.294 -10.469   9.193  1.00  0.00           H  
ATOM    453  N   ARG A  29       0.387 -18.750   7.087  1.00  0.00           N  
ATOM    454  CA  ARG A  29       0.347 -19.996   6.331  1.00  0.00           C  
ATOM    455  C   ARG A  29       0.736 -19.761   4.874  1.00  0.00           C  
ATOM    456  O   ARG A  29       0.204 -18.866   4.217  1.00  0.00           O  
ATOM    457  CB  ARG A  29      -1.049 -20.617   6.404  1.00  0.00           C  
ATOM    458  CG  ARG A  29      -1.206 -21.864   5.550  1.00  0.00           C  
ATOM    459  CD  ARG A  29      -0.778 -23.113   6.307  1.00  0.00           C  
ATOM    460  NE  ARG A  29      -0.954 -24.323   5.508  1.00  0.00           N  
ATOM    461  CZ  ARG A  29      -0.186 -24.636   4.471  1.00  0.00           C  
ATOM    462  NH1 ARG A  29       0.804 -23.832   4.108  1.00  0.00           N  
ATOM    463  NH2 ARG A  29      -0.408 -25.756   3.793  1.00  0.00           N  
ATOM    464  H   ARG A  29      -0.052 -17.954   6.720  1.00  0.00           H  
ATOM    465  HA  ARG A  29       1.057 -20.676   6.776  1.00  0.00           H  
ATOM    466  HB2 ARG A  29      -1.262 -20.879   7.430  1.00  0.00           H  
ATOM    467  HB3 ARG A  29      -1.772 -19.886   6.071  1.00  0.00           H  
ATOM    468  HG2 ARG A  29      -2.243 -21.968   5.266  1.00  0.00           H  
ATOM    469  HG3 ARG A  29      -0.596 -21.763   4.666  1.00  0.00           H  
ATOM    470  HD2 ARG A  29       0.263 -23.017   6.573  1.00  0.00           H  
ATOM    471  HD3 ARG A  29      -1.374 -23.195   7.205  1.00  0.00           H  
ATOM    472  HE  ARG A  29      -1.679 -24.931   5.759  1.00  0.00           H  
ATOM    473 HH11 ARG A  29       0.974 -22.988   4.616  1.00  0.00           H  
ATOM    474 HH12 ARG A  29       1.381 -24.070   3.326  1.00  0.00           H  
ATOM    475 HH21 ARG A  29      -1.153 -26.364   4.064  1.00  0.00           H  
ATOM    476 HH22 ARG A  29       0.170 -25.989   3.011  1.00  0.00           H  
ATOM    477  N   GLN A  30       1.667 -20.570   4.379  1.00  0.00           N  
ATOM    478  CA  GLN A  30       2.128 -20.449   3.000  1.00  0.00           C  
ATOM    479  C   GLN A  30       0.957 -20.534   2.026  1.00  0.00           C  
ATOM    480  O   GLN A  30       0.208 -21.512   2.022  1.00  0.00           O  
ATOM    481  CB  GLN A  30       3.151 -21.541   2.685  1.00  0.00           C  
ATOM    482  CG  GLN A  30       4.587 -21.130   2.967  1.00  0.00           C  
ATOM    483  CD  GLN A  30       5.491 -22.317   3.238  1.00  0.00           C  
ATOM    484  OE1 GLN A  30       5.365 -22.987   4.262  1.00  0.00           O  
ATOM    485  NE2 GLN A  30       6.410 -22.583   2.318  1.00  0.00           N  
ATOM    486  H   GLN A  30       2.053 -21.263   4.952  1.00  0.00           H  
ATOM    487  HA  GLN A  30       2.600 -19.484   2.893  1.00  0.00           H  
ATOM    488  HB2 GLN A  30       2.924 -22.413   3.280  1.00  0.00           H  
ATOM    489  HB3 GLN A  30       3.071 -21.799   1.639  1.00  0.00           H  
ATOM    490  HG2 GLN A  30       4.969 -20.594   2.111  1.00  0.00           H  
ATOM    491  HG3 GLN A  30       4.598 -20.482   3.830  1.00  0.00           H  
ATOM    492 HE21 GLN A  30       6.453 -22.005   1.525  1.00  0.00           H  
ATOM    493 HE22 GLN A  30       7.008 -23.344   2.467  1.00  0.00           H  
ATOM    494  N   HIS A  31       0.805 -19.504   1.200  1.00  0.00           N  
ATOM    495  CA  HIS A  31      -0.274 -19.463   0.220  1.00  0.00           C  
ATOM    496  C   HIS A  31       0.214 -18.876  -1.102  1.00  0.00           C  
ATOM    497  O   HIS A  31       1.322 -18.348  -1.186  1.00  0.00           O  
ATOM    498  CB  HIS A  31      -1.445 -18.638   0.755  1.00  0.00           C  
ATOM    499  CG  HIS A  31      -2.352 -19.406   1.666  1.00  0.00           C  
ATOM    500  ND1 HIS A  31      -2.311 -20.779   1.786  1.00  0.00           N  
ATOM    501  CD2 HIS A  31      -3.326 -18.985   2.507  1.00  0.00           C  
ATOM    502  CE1 HIS A  31      -3.223 -21.170   2.658  1.00  0.00           C  
ATOM    503  NE2 HIS A  31      -3.852 -20.100   3.111  1.00  0.00           N  
ATOM    504  H   HIS A  31       1.433 -18.754   1.250  1.00  0.00           H  
ATOM    505  HA  HIS A  31      -0.606 -20.475   0.049  1.00  0.00           H  
ATOM    506  HB2 HIS A  31      -1.060 -17.792   1.305  1.00  0.00           H  
ATOM    507  HB3 HIS A  31      -2.036 -18.281  -0.078  1.00  0.00           H  
ATOM    508  HD1 HIS A  31      -1.707 -21.378   1.301  1.00  0.00           H  
ATOM    509  HD2 HIS A  31      -3.634 -17.962   2.671  1.00  0.00           H  
ATOM    510  HE1 HIS A  31      -3.420 -22.190   2.953  1.00  0.00           H  
ATOM    511  HE2 HIS A  31      -4.631 -20.113   3.705  1.00  0.00           H  
ATOM    512  N   TRP A  32      -0.620 -18.977  -2.131  1.00  0.00           N  
ATOM    513  CA  TRP A  32      -0.271 -18.458  -3.449  1.00  0.00           C  
ATOM    514  C   TRP A  32      -1.111 -17.232  -3.790  1.00  0.00           C  
ATOM    515  O   TRP A  32      -2.340 -17.296  -3.816  1.00  0.00           O  
ATOM    516  CB  TRP A  32      -0.469 -19.539  -4.513  1.00  0.00           C  
ATOM    517  CG  TRP A  32       0.036 -19.138  -5.866  1.00  0.00           C  
ATOM    518  CD1 TRP A  32      -0.655 -19.182  -7.044  1.00  0.00           C  
ATOM    519  CD2 TRP A  32       1.339 -18.636  -6.181  1.00  0.00           C  
ATOM    520  NE1 TRP A  32       0.141 -18.736  -8.072  1.00  0.00           N  
ATOM    521  CE2 TRP A  32       1.369 -18.395  -7.569  1.00  0.00           C  
ATOM    522  CE3 TRP A  32       2.483 -18.365  -5.426  1.00  0.00           C  
ATOM    523  CZ2 TRP A  32       2.498 -17.897  -8.213  1.00  0.00           C  
ATOM    524  CZ3 TRP A  32       3.603 -17.872  -6.068  1.00  0.00           C  
ATOM    525  CH2 TRP A  32       3.605 -17.641  -7.450  1.00  0.00           C  
ATOM    526  H   TRP A  32      -1.490 -19.411  -2.002  1.00  0.00           H  
ATOM    527  HA  TRP A  32       0.770 -18.173  -3.427  1.00  0.00           H  
ATOM    528  HB2 TRP A  32       0.057 -20.432  -4.213  1.00  0.00           H  
ATOM    529  HB3 TRP A  32      -1.523 -19.758  -4.602  1.00  0.00           H  
ATOM    530  HD1 TRP A  32      -1.675 -19.520  -7.140  1.00  0.00           H  
ATOM    531  HE1 TRP A  32      -0.127 -18.672  -9.013  1.00  0.00           H  
ATOM    532  HE3 TRP A  32       2.502 -18.535  -4.360  1.00  0.00           H  
ATOM    533  HZ2 TRP A  32       2.515 -17.714  -9.278  1.00  0.00           H  
ATOM    534  HZ3 TRP A  32       4.497 -17.656  -5.500  1.00  0.00           H  
ATOM    535  HH2 TRP A  32       4.502 -17.255  -7.908  1.00  0.00           H  
ATOM    536  N   VAL A  33      -0.440 -16.115  -4.052  1.00  0.00           N  
ATOM    537  CA  VAL A  33      -1.125 -14.873  -4.392  1.00  0.00           C  
ATOM    538  C   VAL A  33      -0.756 -14.410  -5.797  1.00  0.00           C  
ATOM    539  O   VAL A  33       0.346 -14.674  -6.281  1.00  0.00           O  
ATOM    540  CB  VAL A  33      -0.788 -13.753  -3.390  1.00  0.00           C  
ATOM    541  CG1 VAL A  33      -1.670 -12.537  -3.633  1.00  0.00           C  
ATOM    542  CG2 VAL A  33      -0.938 -14.255  -1.962  1.00  0.00           C  
ATOM    543  H   VAL A  33       0.540 -16.125  -4.015  1.00  0.00           H  
ATOM    544  HA  VAL A  33      -2.189 -15.057  -4.352  1.00  0.00           H  
ATOM    545  HB  VAL A  33       0.241 -13.460  -3.540  1.00  0.00           H  
ATOM    546 HG11 VAL A  33      -2.707 -12.819  -3.528  1.00  0.00           H  
ATOM    547 HG12 VAL A  33      -1.429 -11.769  -2.913  1.00  0.00           H  
ATOM    548 HG13 VAL A  33      -1.498 -12.162  -4.631  1.00  0.00           H  
ATOM    549 HG21 VAL A  33      -1.575 -15.127  -1.951  1.00  0.00           H  
ATOM    550 HG22 VAL A  33       0.033 -14.513  -1.568  1.00  0.00           H  
ATOM    551 HG23 VAL A  33      -1.379 -13.479  -1.352  1.00  0.00           H  
ATOM    552  N   VAL A  34      -1.685 -13.718  -6.449  1.00  0.00           N  
ATOM    553  CA  VAL A  34      -1.458 -13.216  -7.799  1.00  0.00           C  
ATOM    554  C   VAL A  34      -2.177 -11.890  -8.021  1.00  0.00           C  
ATOM    555  O   VAL A  34      -3.391 -11.793  -7.837  1.00  0.00           O  
ATOM    556  CB  VAL A  34      -1.928 -14.227  -8.861  1.00  0.00           C  
ATOM    557  CG1 VAL A  34      -1.831 -13.624 -10.254  1.00  0.00           C  
ATOM    558  CG2 VAL A  34      -1.117 -15.512  -8.769  1.00  0.00           C  
ATOM    559  H   VAL A  34      -2.543 -13.539  -6.011  1.00  0.00           H  
ATOM    560  HA  VAL A  34      -0.395 -13.062  -7.924  1.00  0.00           H  
ATOM    561  HB  VAL A  34      -2.963 -14.465  -8.667  1.00  0.00           H  
ATOM    562 HG11 VAL A  34      -2.168 -14.346 -10.983  1.00  0.00           H  
ATOM    563 HG12 VAL A  34      -2.449 -12.740 -10.307  1.00  0.00           H  
ATOM    564 HG13 VAL A  34      -0.804 -13.359 -10.460  1.00  0.00           H  
ATOM    565 HG21 VAL A  34      -1.623 -16.296  -9.311  1.00  0.00           H  
ATOM    566 HG22 VAL A  34      -0.140 -15.349  -9.196  1.00  0.00           H  
ATOM    567 HG23 VAL A  34      -1.014 -15.799  -7.732  1.00  0.00           H  
ATOM    568  N   PHE A  35      -1.422 -10.872  -8.418  1.00  0.00           N  
ATOM    569  CA  PHE A  35      -1.988  -9.551  -8.665  1.00  0.00           C  
ATOM    570  C   PHE A  35      -2.268  -9.348 -10.151  1.00  0.00           C  
ATOM    571  O   PHE A  35      -1.384  -9.519 -10.991  1.00  0.00           O  
ATOM    572  CB  PHE A  35      -1.036  -8.463  -8.161  1.00  0.00           C  
ATOM    573  CG  PHE A  35      -1.405  -7.083  -8.626  1.00  0.00           C  
ATOM    574  CD1 PHE A  35      -2.652  -6.551  -8.340  1.00  0.00           C  
ATOM    575  CD2 PHE A  35      -0.504  -6.318  -9.349  1.00  0.00           C  
ATOM    576  CE1 PHE A  35      -2.994  -5.281  -8.767  1.00  0.00           C  
ATOM    577  CE2 PHE A  35      -0.839  -5.047  -9.777  1.00  0.00           C  
ATOM    578  CZ  PHE A  35      -2.087  -4.529  -9.487  1.00  0.00           C  
ATOM    579  H   PHE A  35      -0.460 -11.012  -8.546  1.00  0.00           H  
ATOM    580  HA  PHE A  35      -2.917  -9.482  -8.123  1.00  0.00           H  
ATOM    581  HB2 PHE A  35      -1.042  -8.461  -7.082  1.00  0.00           H  
ATOM    582  HB3 PHE A  35      -0.038  -8.677  -8.512  1.00  0.00           H  
ATOM    583  HD1 PHE A  35      -3.363  -7.139  -7.778  1.00  0.00           H  
ATOM    584  HD2 PHE A  35       0.472  -6.722  -9.578  1.00  0.00           H  
ATOM    585  HE1 PHE A  35      -3.970  -4.879  -8.538  1.00  0.00           H  
ATOM    586  HE2 PHE A  35      -0.128  -4.461 -10.340  1.00  0.00           H  
ATOM    587  HZ  PHE A  35      -2.351  -3.536  -9.820  1.00  0.00           H  
ATOM    588  N   LYS A  36      -3.506  -8.986 -10.469  1.00  0.00           N  
ATOM    589  CA  LYS A  36      -3.907  -8.759 -11.853  1.00  0.00           C  
ATOM    590  C   LYS A  36      -4.196  -7.282 -12.100  1.00  0.00           C  
ATOM    591  O   LYS A  36      -4.486  -6.533 -11.168  1.00  0.00           O  
ATOM    592  CB  LYS A  36      -5.142  -9.596 -12.191  1.00  0.00           C  
ATOM    593  CG  LYS A  36      -5.587  -9.466 -13.637  1.00  0.00           C  
ATOM    594  CD  LYS A  36      -4.574 -10.078 -14.590  1.00  0.00           C  
ATOM    595  CE  LYS A  36      -5.079 -10.064 -16.024  1.00  0.00           C  
ATOM    596  NZ  LYS A  36      -6.232 -10.987 -16.217  1.00  0.00           N  
ATOM    597  H   LYS A  36      -4.168  -8.866  -9.754  1.00  0.00           H  
ATOM    598  HA  LYS A  36      -3.090  -9.065 -12.488  1.00  0.00           H  
ATOM    599  HB2 LYS A  36      -4.923 -10.635 -11.995  1.00  0.00           H  
ATOM    600  HB3 LYS A  36      -5.958  -9.283 -11.556  1.00  0.00           H  
ATOM    601  HG2 LYS A  36      -6.533  -9.972 -13.761  1.00  0.00           H  
ATOM    602  HG3 LYS A  36      -5.704  -8.418 -13.876  1.00  0.00           H  
ATOM    603  HD2 LYS A  36      -3.656  -9.512 -14.538  1.00  0.00           H  
ATOM    604  HD3 LYS A  36      -4.386 -11.100 -14.294  1.00  0.00           H  
ATOM    605  HE2 LYS A  36      -5.386  -9.060 -16.275  1.00  0.00           H  
ATOM    606  HE3 LYS A  36      -4.274 -10.367 -16.678  1.00  0.00           H  
ATOM    607  HZ1 LYS A  36      -6.055 -11.616 -17.025  1.00  0.00           H  
ATOM    608  HZ2 LYS A  36      -7.099 -10.441 -16.398  1.00  0.00           H  
ATOM    609  HZ3 LYS A  36      -6.373 -11.565 -15.363  1.00  0.00           H  
ATOM    610  N   GLU A  37      -4.117  -6.871 -13.362  1.00  0.00           N  
ATOM    611  CA  GLU A  37      -4.372  -5.484 -13.731  1.00  0.00           C  
ATOM    612  C   GLU A  37      -5.416  -4.860 -12.811  1.00  0.00           C  
ATOM    613  O   GLU A  37      -5.108  -3.976 -12.010  1.00  0.00           O  
ATOM    614  CB  GLU A  37      -4.842  -5.397 -15.185  1.00  0.00           C  
ATOM    615  CG  GLU A  37      -3.750  -5.709 -16.196  1.00  0.00           C  
ATOM    616  CD  GLU A  37      -4.077  -5.195 -17.584  1.00  0.00           C  
ATOM    617  OE1 GLU A  37      -5.121  -5.602 -18.137  1.00  0.00           O  
ATOM    618  OE2 GLU A  37      -3.290  -4.386 -18.118  1.00  0.00           O  
ATOM    619  H   GLU A  37      -3.882  -7.517 -14.061  1.00  0.00           H  
ATOM    620  HA  GLU A  37      -3.447  -4.938 -13.628  1.00  0.00           H  
ATOM    621  HB2 GLU A  37      -5.651  -6.096 -15.332  1.00  0.00           H  
ATOM    622  HB3 GLU A  37      -5.203  -4.397 -15.374  1.00  0.00           H  
ATOM    623  HG2 GLU A  37      -2.830  -5.250 -15.866  1.00  0.00           H  
ATOM    624  HG3 GLU A  37      -3.620  -6.780 -16.246  1.00  0.00           H  
ATOM    625  N   THR A  38      -6.656  -5.325 -12.929  1.00  0.00           N  
ATOM    626  CA  THR A  38      -7.747  -4.812 -12.110  1.00  0.00           C  
ATOM    627  C   THR A  38      -8.412  -5.931 -11.317  1.00  0.00           C  
ATOM    628  O   THR A  38      -9.540  -5.786 -10.844  1.00  0.00           O  
ATOM    629  CB  THR A  38      -8.811  -4.106 -12.971  1.00  0.00           C  
ATOM    630  OG1 THR A  38      -8.975  -4.798 -14.213  1.00  0.00           O  
ATOM    631  CG2 THR A  38      -8.419  -2.659 -13.237  1.00  0.00           C  
ATOM    632  H   THR A  38      -6.840  -6.030 -13.585  1.00  0.00           H  
ATOM    633  HA  THR A  38      -7.336  -4.090 -11.420  1.00  0.00           H  
ATOM    634  HB  THR A  38      -9.750  -4.115 -12.435  1.00  0.00           H  
ATOM    635  HG1 THR A  38      -9.713  -4.417 -14.697  1.00  0.00           H  
ATOM    636 HG21 THR A  38      -8.515  -2.451 -14.292  1.00  0.00           H  
ATOM    637 HG22 THR A  38      -7.395  -2.502 -12.931  1.00  0.00           H  
ATOM    638 HG23 THR A  38      -9.067  -2.002 -12.679  1.00  0.00           H  
ATOM    639  N   THR A  39      -7.707  -7.049 -11.175  1.00  0.00           N  
ATOM    640  CA  THR A  39      -8.230  -8.193 -10.439  1.00  0.00           C  
ATOM    641  C   THR A  39      -7.192  -8.743  -9.467  1.00  0.00           C  
ATOM    642  O   THR A  39      -6.011  -8.404  -9.546  1.00  0.00           O  
ATOM    643  CB  THR A  39      -8.671  -9.321 -11.392  1.00  0.00           C  
ATOM    644  OG1 THR A  39      -9.099  -8.766 -12.641  1.00  0.00           O  
ATOM    645  CG2 THR A  39      -9.798 -10.137 -10.780  1.00  0.00           C  
ATOM    646  H   THR A  39      -6.815  -7.104 -11.575  1.00  0.00           H  
ATOM    647  HA  THR A  39      -9.094  -7.865  -9.881  1.00  0.00           H  
ATOM    648  HB  THR A  39      -7.827  -9.974 -11.568  1.00  0.00           H  
ATOM    649  HG1 THR A  39      -9.046  -9.438 -13.325  1.00  0.00           H  
ATOM    650 HG21 THR A  39     -10.551  -9.471 -10.385  1.00  0.00           H  
ATOM    651 HG22 THR A  39      -9.407 -10.751  -9.983  1.00  0.00           H  
ATOM    652 HG23 THR A  39     -10.239 -10.768 -11.538  1.00  0.00           H  
ATOM    653  N   LEU A  40      -7.639  -9.593  -8.549  1.00  0.00           N  
ATOM    654  CA  LEU A  40      -6.749 -10.191  -7.561  1.00  0.00           C  
ATOM    655  C   LEU A  40      -7.350 -11.472  -6.990  1.00  0.00           C  
ATOM    656  O   LEU A  40      -8.502 -11.489  -6.558  1.00  0.00           O  
ATOM    657  CB  LEU A  40      -6.469  -9.198  -6.431  1.00  0.00           C  
ATOM    658  CG  LEU A  40      -5.207  -9.457  -5.608  1.00  0.00           C  
ATOM    659  CD1 LEU A  40      -4.695  -8.163  -4.994  1.00  0.00           C  
ATOM    660  CD2 LEU A  40      -5.479 -10.491  -4.526  1.00  0.00           C  
ATOM    661  H   LEU A  40      -8.591  -9.826  -8.536  1.00  0.00           H  
ATOM    662  HA  LEU A  40      -5.820 -10.433  -8.055  1.00  0.00           H  
ATOM    663  HB2 LEU A  40      -6.382  -8.216  -6.870  1.00  0.00           H  
ATOM    664  HB3 LEU A  40      -7.314  -9.217  -5.759  1.00  0.00           H  
ATOM    665  HG  LEU A  40      -4.435  -9.846  -6.257  1.00  0.00           H  
ATOM    666 HD11 LEU A  40      -5.000  -8.111  -3.960  1.00  0.00           H  
ATOM    667 HD12 LEU A  40      -5.105  -7.322  -5.533  1.00  0.00           H  
ATOM    668 HD13 LEU A  40      -3.616  -8.138  -5.055  1.00  0.00           H  
ATOM    669 HD21 LEU A  40      -5.161 -11.465  -4.870  1.00  0.00           H  
ATOM    670 HD22 LEU A  40      -6.536 -10.514  -4.308  1.00  0.00           H  
ATOM    671 HD23 LEU A  40      -4.933 -10.229  -3.632  1.00  0.00           H  
ATOM    672  N   SER A  41      -6.560 -12.541  -6.991  1.00  0.00           N  
ATOM    673  CA  SER A  41      -7.014 -13.827  -6.474  1.00  0.00           C  
ATOM    674  C   SER A  41      -5.854 -14.609  -5.868  1.00  0.00           C  
ATOM    675  O   SER A  41      -4.712 -14.493  -6.313  1.00  0.00           O  
ATOM    676  CB  SER A  41      -7.669 -14.645  -7.589  1.00  0.00           C  
ATOM    677  OG  SER A  41      -8.798 -13.973  -8.119  1.00  0.00           O  
ATOM    678  H   SER A  41      -5.651 -12.464  -7.349  1.00  0.00           H  
ATOM    679  HA  SER A  41      -7.746 -13.635  -5.703  1.00  0.00           H  
ATOM    680  HB2 SER A  41      -6.954 -14.805  -8.381  1.00  0.00           H  
ATOM    681  HB3 SER A  41      -7.986 -15.599  -7.192  1.00  0.00           H  
ATOM    682  HG  SER A  41      -8.785 -14.031  -9.077  1.00  0.00           H  
ATOM    683  N   TYR A  42      -6.154 -15.406  -4.848  1.00  0.00           N  
ATOM    684  CA  TYR A  42      -5.137 -16.206  -4.177  1.00  0.00           C  
ATOM    685  C   TYR A  42      -5.608 -17.647  -3.999  1.00  0.00           C  
ATOM    686  O   TYR A  42      -6.753 -17.980  -4.303  1.00  0.00           O  
ATOM    687  CB  TYR A  42      -4.795 -15.598  -2.816  1.00  0.00           C  
ATOM    688  CG  TYR A  42      -5.923 -15.681  -1.815  1.00  0.00           C  
ATOM    689  CD1 TYR A  42      -7.123 -15.015  -2.031  1.00  0.00           C  
ATOM    690  CD2 TYR A  42      -5.791 -16.428  -0.650  1.00  0.00           C  
ATOM    691  CE1 TYR A  42      -8.157 -15.088  -1.118  1.00  0.00           C  
ATOM    692  CE2 TYR A  42      -6.820 -16.508   0.268  1.00  0.00           C  
ATOM    693  CZ  TYR A  42      -8.001 -15.836   0.030  1.00  0.00           C  
ATOM    694  OH  TYR A  42      -9.028 -15.912   0.942  1.00  0.00           O  
ATOM    695  H   TYR A  42      -7.083 -15.456  -4.538  1.00  0.00           H  
ATOM    696  HA  TYR A  42      -4.251 -16.203  -4.796  1.00  0.00           H  
ATOM    697  HB2 TYR A  42      -3.944 -16.117  -2.401  1.00  0.00           H  
ATOM    698  HB3 TYR A  42      -4.544 -14.556  -2.949  1.00  0.00           H  
ATOM    699  HD1 TYR A  42      -7.241 -14.430  -2.932  1.00  0.00           H  
ATOM    700  HD2 TYR A  42      -4.865 -16.953  -0.466  1.00  0.00           H  
ATOM    701  HE1 TYR A  42      -9.081 -14.562  -1.305  1.00  0.00           H  
ATOM    702  HE2 TYR A  42      -6.698 -17.094   1.168  1.00  0.00           H  
ATOM    703  HH  TYR A  42      -8.666 -15.974   1.828  1.00  0.00           H  
ATOM    704  N   TYR A  43      -4.715 -18.497  -3.504  1.00  0.00           N  
ATOM    705  CA  TYR A  43      -5.035 -19.902  -3.286  1.00  0.00           C  
ATOM    706  C   TYR A  43      -4.343 -20.431  -2.034  1.00  0.00           C  
ATOM    707  O   TYR A  43      -3.408 -19.816  -1.519  1.00  0.00           O  
ATOM    708  CB  TYR A  43      -4.624 -20.736  -4.501  1.00  0.00           C  
ATOM    709  CG  TYR A  43      -4.799 -20.013  -5.818  1.00  0.00           C  
ATOM    710  CD1 TYR A  43      -4.100 -18.844  -6.089  1.00  0.00           C  
ATOM    711  CD2 TYR A  43      -5.665 -20.499  -6.789  1.00  0.00           C  
ATOM    712  CE1 TYR A  43      -4.257 -18.180  -7.291  1.00  0.00           C  
ATOM    713  CE2 TYR A  43      -5.827 -19.843  -7.995  1.00  0.00           C  
ATOM    714  CZ  TYR A  43      -5.122 -18.684  -8.240  1.00  0.00           C  
ATOM    715  OH  TYR A  43      -5.282 -18.027  -9.439  1.00  0.00           O  
ATOM    716  H   TYR A  43      -3.817 -18.172  -3.282  1.00  0.00           H  
ATOM    717  HA  TYR A  43      -6.104 -19.981  -3.153  1.00  0.00           H  
ATOM    718  HB2 TYR A  43      -3.583 -21.006  -4.408  1.00  0.00           H  
ATOM    719  HB3 TYR A  43      -5.222 -21.633  -4.532  1.00  0.00           H  
ATOM    720  HD1 TYR A  43      -3.423 -18.451  -5.344  1.00  0.00           H  
ATOM    721  HD2 TYR A  43      -6.217 -21.408  -6.593  1.00  0.00           H  
ATOM    722  HE1 TYR A  43      -3.704 -17.273  -7.485  1.00  0.00           H  
ATOM    723  HE2 TYR A  43      -6.505 -20.238  -8.738  1.00  0.00           H  
ATOM    724  HH  TYR A  43      -4.421 -17.868  -9.834  1.00  0.00           H  
ATOM    725  N   LYS A  44      -4.807 -21.577  -1.549  1.00  0.00           N  
ATOM    726  CA  LYS A  44      -4.234 -22.193  -0.358  1.00  0.00           C  
ATOM    727  C   LYS A  44      -2.937 -22.923  -0.694  1.00  0.00           C  
ATOM    728  O   LYS A  44      -2.007 -22.957   0.111  1.00  0.00           O  
ATOM    729  CB  LYS A  44      -5.233 -23.168   0.269  1.00  0.00           C  
ATOM    730  CG  LYS A  44      -5.660 -24.287  -0.666  1.00  0.00           C  
ATOM    731  CD  LYS A  44      -6.726 -25.165  -0.035  1.00  0.00           C  
ATOM    732  CE  LYS A  44      -6.159 -26.000   1.103  1.00  0.00           C  
ATOM    733  NZ  LYS A  44      -7.122 -27.039   1.563  1.00  0.00           N  
ATOM    734  H   LYS A  44      -5.555 -22.020  -2.002  1.00  0.00           H  
ATOM    735  HA  LYS A  44      -4.018 -21.408   0.351  1.00  0.00           H  
ATOM    736  HB2 LYS A  44      -4.783 -23.612   1.145  1.00  0.00           H  
ATOM    737  HB3 LYS A  44      -6.115 -22.619   0.566  1.00  0.00           H  
ATOM    738  HG2 LYS A  44      -6.057 -23.854  -1.573  1.00  0.00           H  
ATOM    739  HG3 LYS A  44      -4.798 -24.894  -0.902  1.00  0.00           H  
ATOM    740  HD2 LYS A  44      -7.515 -24.537   0.353  1.00  0.00           H  
ATOM    741  HD3 LYS A  44      -7.129 -25.826  -0.789  1.00  0.00           H  
ATOM    742  HE2 LYS A  44      -5.256 -26.483   0.761  1.00  0.00           H  
ATOM    743  HE3 LYS A  44      -5.926 -25.346   1.930  1.00  0.00           H  
ATOM    744  HZ1 LYS A  44      -7.270 -26.960   2.589  1.00  0.00           H  
ATOM    745  HZ2 LYS A  44      -6.752 -27.988   1.348  1.00  0.00           H  
ATOM    746  HZ3 LYS A  44      -8.036 -26.918   1.080  1.00  0.00           H  
ATOM    747  N   SER A  45      -2.884 -23.505  -1.888  1.00  0.00           N  
ATOM    748  CA  SER A  45      -1.702 -24.236  -2.330  1.00  0.00           C  
ATOM    749  C   SER A  45      -1.598 -24.233  -3.852  1.00  0.00           C  
ATOM    750  O   SER A  45      -2.574 -24.504  -4.550  1.00  0.00           O  
ATOM    751  CB  SER A  45      -1.744 -25.676  -1.812  1.00  0.00           C  
ATOM    752  OG  SER A  45      -0.573 -26.384  -2.181  1.00  0.00           O  
ATOM    753  H   SER A  45      -3.658 -23.442  -2.485  1.00  0.00           H  
ATOM    754  HA  SER A  45      -0.834 -23.741  -1.920  1.00  0.00           H  
ATOM    755  HB2 SER A  45      -1.821 -25.666  -0.736  1.00  0.00           H  
ATOM    756  HB3 SER A  45      -2.603 -26.180  -2.231  1.00  0.00           H  
ATOM    757  HG  SER A  45      -0.315 -26.135  -3.071  1.00  0.00           H  
ATOM    758  N   GLN A  46      -0.408 -23.924  -4.357  1.00  0.00           N  
ATOM    759  CA  GLN A  46      -0.177 -23.884  -5.796  1.00  0.00           C  
ATOM    760  C   GLN A  46      -1.006 -24.946  -6.510  1.00  0.00           C  
ATOM    761  O   GLN A  46      -1.468 -24.736  -7.632  1.00  0.00           O  
ATOM    762  CB  GLN A  46       1.308 -24.091  -6.101  1.00  0.00           C  
ATOM    763  CG  GLN A  46       1.770 -23.401  -7.373  1.00  0.00           C  
ATOM    764  CD  GLN A  46       3.140 -23.866  -7.826  1.00  0.00           C  
ATOM    765  OE1 GLN A  46       4.163 -23.330  -7.398  1.00  0.00           O  
ATOM    766  NE2 GLN A  46       3.167 -24.868  -8.697  1.00  0.00           N  
ATOM    767  H   GLN A  46       0.331 -23.717  -3.748  1.00  0.00           H  
ATOM    768  HA  GLN A  46      -0.476 -22.911  -6.153  1.00  0.00           H  
ATOM    769  HB2 GLN A  46       1.890 -23.705  -5.276  1.00  0.00           H  
ATOM    770  HB3 GLN A  46       1.499 -25.149  -6.200  1.00  0.00           H  
ATOM    771  HG2 GLN A  46       1.058 -23.610  -8.159  1.00  0.00           H  
ATOM    772  HG3 GLN A  46       1.807 -22.336  -7.197  1.00  0.00           H  
ATOM    773 HE21 GLN A  46       2.313 -25.245  -8.995  1.00  0.00           H  
ATOM    774 HE22 GLN A  46       4.040 -25.189  -9.006  1.00  0.00           H  
ATOM    775  N   ASP A  47      -1.193 -26.085  -5.852  1.00  0.00           N  
ATOM    776  CA  ASP A  47      -1.968 -27.180  -6.425  1.00  0.00           C  
ATOM    777  C   ASP A  47      -3.314 -26.679  -6.944  1.00  0.00           C  
ATOM    778  O   ASP A  47      -3.616 -26.805  -8.130  1.00  0.00           O  
ATOM    779  CB  ASP A  47      -2.187 -28.278  -5.382  1.00  0.00           C  
ATOM    780  CG  ASP A  47      -0.933 -29.089  -5.124  1.00  0.00           C  
ATOM    781  OD1 ASP A  47      -0.451 -29.751  -6.067  1.00  0.00           O  
ATOM    782  OD2 ASP A  47      -0.432 -29.061  -3.981  1.00  0.00           O  
ATOM    783  H   ASP A  47      -0.800 -26.192  -4.960  1.00  0.00           H  
ATOM    784  HA  ASP A  47      -1.407 -27.587  -7.251  1.00  0.00           H  
ATOM    785  HB2 ASP A  47      -2.497 -27.824  -4.451  1.00  0.00           H  
ATOM    786  HB3 ASP A  47      -2.962 -28.945  -5.729  1.00  0.00           H  
ATOM    787  N   GLU A  48      -4.115 -26.114  -6.047  1.00  0.00           N  
ATOM    788  CA  GLU A  48      -5.428 -25.598  -6.416  1.00  0.00           C  
ATOM    789  C   GLU A  48      -5.388 -24.942  -7.793  1.00  0.00           C  
ATOM    790  O   GLU A  48      -6.047 -25.396  -8.728  1.00  0.00           O  
ATOM    791  CB  GLU A  48      -5.915 -24.588  -5.373  1.00  0.00           C  
ATOM    792  CG  GLU A  48      -6.551 -25.233  -4.153  1.00  0.00           C  
ATOM    793  CD  GLU A  48      -7.917 -25.819  -4.448  1.00  0.00           C  
ATOM    794  OE1 GLU A  48      -8.920 -25.088  -4.300  1.00  0.00           O  
ATOM    795  OE2 GLU A  48      -7.986 -27.008  -4.826  1.00  0.00           O  
ATOM    796  H   GLU A  48      -3.817 -26.043  -5.116  1.00  0.00           H  
ATOM    797  HA  GLU A  48      -6.115 -26.430  -6.447  1.00  0.00           H  
ATOM    798  HB2 GLU A  48      -5.075 -23.994  -5.045  1.00  0.00           H  
ATOM    799  HB3 GLU A  48      -6.646 -23.939  -5.832  1.00  0.00           H  
ATOM    800  HG2 GLU A  48      -5.905 -26.025  -3.802  1.00  0.00           H  
ATOM    801  HG3 GLU A  48      -6.654 -24.487  -3.380  1.00  0.00           H  
ATOM    802  N   ALA A  49      -4.609 -23.871  -7.910  1.00  0.00           N  
ATOM    803  CA  ALA A  49      -4.481 -23.153  -9.172  1.00  0.00           C  
ATOM    804  C   ALA A  49      -3.685 -23.967 -10.188  1.00  0.00           C  
ATOM    805  O   ALA A  49      -2.972 -24.909  -9.842  1.00  0.00           O  
ATOM    806  CB  ALA A  49      -3.824 -21.800  -8.945  1.00  0.00           C  
ATOM    807  H   ALA A  49      -4.107 -23.557  -7.129  1.00  0.00           H  
ATOM    808  HA  ALA A  49      -5.474 -22.983  -9.562  1.00  0.00           H  
ATOM    809  HB1 ALA A  49      -2.823 -21.815  -9.351  1.00  0.00           H  
ATOM    810  HB2 ALA A  49      -4.402 -21.033  -9.439  1.00  0.00           H  
ATOM    811  HB3 ALA A  49      -3.781 -21.594  -7.887  1.00  0.00           H  
ATOM    812  N   PRO A  50      -3.810 -23.597 -11.471  1.00  0.00           N  
ATOM    813  CA  PRO A  50      -4.656 -22.478 -11.894  1.00  0.00           C  
ATOM    814  C   PRO A  50      -6.142 -22.783 -11.736  1.00  0.00           C  
ATOM    815  O   PRO A  50      -6.993 -21.938 -12.013  1.00  0.00           O  
ATOM    816  CB  PRO A  50      -4.301 -22.303 -13.372  1.00  0.00           C  
ATOM    817  CG  PRO A  50      -3.814 -23.643 -13.806  1.00  0.00           C  
ATOM    818  CD  PRO A  50      -3.133 -24.244 -12.608  1.00  0.00           C  
ATOM    819  HA  PRO A  50      -4.417 -21.573 -11.355  1.00  0.00           H  
ATOM    820  HB2 PRO A  50      -5.181 -22.004 -13.924  1.00  0.00           H  
ATOM    821  HB3 PRO A  50      -3.532 -21.552 -13.474  1.00  0.00           H  
ATOM    822  HG2 PRO A  50      -4.649 -24.256 -14.110  1.00  0.00           H  
ATOM    823  HG3 PRO A  50      -3.112 -23.532 -14.620  1.00  0.00           H  
ATOM    824  HD2 PRO A  50      -3.281 -25.313 -12.587  1.00  0.00           H  
ATOM    825  HD3 PRO A  50      -2.080 -24.006 -12.615  1.00  0.00           H  
ATOM    826  N   GLY A  51      -6.448 -23.997 -11.287  1.00  0.00           N  
ATOM    827  CA  GLY A  51      -7.832 -24.392 -11.101  1.00  0.00           C  
ATOM    828  C   GLY A  51      -8.723 -23.224 -10.730  1.00  0.00           C  
ATOM    829  O   GLY A  51      -9.317 -22.586 -11.601  1.00  0.00           O  
ATOM    830  H   GLY A  51      -5.728 -24.630 -11.082  1.00  0.00           H  
ATOM    831  HA2 GLY A  51      -8.196 -24.833 -12.016  1.00  0.00           H  
ATOM    832  HA3 GLY A  51      -7.880 -25.130 -10.313  1.00  0.00           H  
ATOM    833  N   ASP A  52      -8.819 -22.942  -9.436  1.00  0.00           N  
ATOM    834  CA  ASP A  52      -9.646 -21.841  -8.952  1.00  0.00           C  
ATOM    835  C   ASP A  52      -9.179 -21.375  -7.577  1.00  0.00           C  
ATOM    836  O   ASP A  52      -8.908 -22.175  -6.681  1.00  0.00           O  
ATOM    837  CB  ASP A  52     -11.113 -22.267  -8.889  1.00  0.00           C  
ATOM    838  CG  ASP A  52     -11.900 -21.482  -7.858  1.00  0.00           C  
ATOM    839  OD1 ASP A  52     -12.105 -20.269  -8.068  1.00  0.00           O  
ATOM    840  OD2 ASP A  52     -12.309 -22.080  -6.841  1.00  0.00           O  
ATOM    841  H   ASP A  52      -8.321 -23.486  -8.790  1.00  0.00           H  
ATOM    842  HA  ASP A  52      -9.548 -21.023  -9.648  1.00  0.00           H  
ATOM    843  HB2 ASP A  52     -11.569 -22.113  -9.856  1.00  0.00           H  
ATOM    844  HB3 ASP A  52     -11.166 -23.316  -8.633  1.00  0.00           H  
ATOM    845  N   PRO A  53      -9.079 -20.049  -7.404  1.00  0.00           N  
ATOM    846  CA  PRO A  53      -8.644 -19.445  -6.140  1.00  0.00           C  
ATOM    847  C   PRO A  53      -9.678 -19.612  -5.032  1.00  0.00           C  
ATOM    848  O   PRO A  53     -10.828 -19.968  -5.291  1.00  0.00           O  
ATOM    849  CB  PRO A  53      -8.472 -17.966  -6.494  1.00  0.00           C  
ATOM    850  CG  PRO A  53      -9.382 -17.746  -7.654  1.00  0.00           C  
ATOM    851  CD  PRO A  53      -9.385 -19.036  -8.428  1.00  0.00           C  
ATOM    852  HA  PRO A  53      -7.698 -19.852  -5.812  1.00  0.00           H  
ATOM    853  HB2 PRO A  53      -8.755 -17.356  -5.648  1.00  0.00           H  
ATOM    854  HB3 PRO A  53      -7.443 -17.773  -6.756  1.00  0.00           H  
ATOM    855  HG2 PRO A  53     -10.375 -17.516  -7.302  1.00  0.00           H  
ATOM    856  HG3 PRO A  53      -9.004 -16.942  -8.268  1.00  0.00           H  
ATOM    857  HD2 PRO A  53     -10.357 -19.211  -8.865  1.00  0.00           H  
ATOM    858  HD3 PRO A  53      -8.623 -19.019  -9.192  1.00  0.00           H  
ATOM    859  N   ILE A  54      -9.262 -19.352  -3.797  1.00  0.00           N  
ATOM    860  CA  ILE A  54     -10.154 -19.472  -2.650  1.00  0.00           C  
ATOM    861  C   ILE A  54     -11.293 -18.461  -2.732  1.00  0.00           C  
ATOM    862  O   ILE A  54     -12.431 -18.765  -2.374  1.00  0.00           O  
ATOM    863  CB  ILE A  54      -9.396 -19.268  -1.325  1.00  0.00           C  
ATOM    864  CG1 ILE A  54      -8.563 -20.509  -0.992  1.00  0.00           C  
ATOM    865  CG2 ILE A  54     -10.372 -18.962  -0.198  1.00  0.00           C  
ATOM    866  CD1 ILE A  54      -7.401 -20.226  -0.066  1.00  0.00           C  
ATOM    867  H   ILE A  54      -8.334 -19.073  -3.654  1.00  0.00           H  
ATOM    868  HA  ILE A  54     -10.570 -20.469  -2.654  1.00  0.00           H  
ATOM    869  HB  ILE A  54      -8.737 -18.421  -1.438  1.00  0.00           H  
ATOM    870 HG12 ILE A  54      -9.195 -21.242  -0.518  1.00  0.00           H  
ATOM    871 HG13 ILE A  54      -8.165 -20.921  -1.909  1.00  0.00           H  
ATOM    872 HG21 ILE A  54     -10.932 -18.071  -0.440  1.00  0.00           H  
ATOM    873 HG22 ILE A  54     -11.052 -19.792  -0.076  1.00  0.00           H  
ATOM    874 HG23 ILE A  54      -9.825 -18.806   0.720  1.00  0.00           H  
ATOM    875 HD11 ILE A  54      -6.489 -20.163  -0.642  1.00  0.00           H  
ATOM    876 HD12 ILE A  54      -7.568 -19.291   0.446  1.00  0.00           H  
ATOM    877 HD13 ILE A  54      -7.316 -21.023   0.657  1.00  0.00           H  
ATOM    878  N   GLN A  55     -10.978 -17.259  -3.204  1.00  0.00           N  
ATOM    879  CA  GLN A  55     -11.976 -16.204  -3.334  1.00  0.00           C  
ATOM    880  C   GLN A  55     -11.461 -15.073  -4.218  1.00  0.00           C  
ATOM    881  O   GLN A  55     -10.545 -14.345  -3.837  1.00  0.00           O  
ATOM    882  CB  GLN A  55     -12.354 -15.659  -1.956  1.00  0.00           C  
ATOM    883  CG  GLN A  55     -13.479 -16.430  -1.284  1.00  0.00           C  
ATOM    884  CD  GLN A  55     -14.198 -15.613  -0.230  1.00  0.00           C  
ATOM    885  OE1 GLN A  55     -14.361 -16.053   0.909  1.00  0.00           O  
ATOM    886  NE2 GLN A  55     -14.635 -14.416  -0.605  1.00  0.00           N  
ATOM    887  H   GLN A  55     -10.053 -17.079  -3.473  1.00  0.00           H  
ATOM    888  HA  GLN A  55     -12.853 -16.633  -3.795  1.00  0.00           H  
ATOM    889  HB2 GLN A  55     -11.486 -15.699  -1.315  1.00  0.00           H  
ATOM    890  HB3 GLN A  55     -12.666 -14.631  -2.062  1.00  0.00           H  
ATOM    891  HG2 GLN A  55     -14.194 -16.728  -2.036  1.00  0.00           H  
ATOM    892  HG3 GLN A  55     -13.064 -17.311  -0.815  1.00  0.00           H  
ATOM    893 HE21 GLN A  55     -14.470 -14.133  -1.529  1.00  0.00           H  
ATOM    894 HE22 GLN A  55     -15.104 -13.867   0.057  1.00  0.00           H  
ATOM    895  N   GLN A  56     -12.055 -14.934  -5.399  1.00  0.00           N  
ATOM    896  CA  GLN A  56     -11.655 -13.891  -6.336  1.00  0.00           C  
ATOM    897  C   GLN A  56     -12.449 -12.611  -6.099  1.00  0.00           C  
ATOM    898  O   GLN A  56     -13.655 -12.654  -5.850  1.00  0.00           O  
ATOM    899  CB  GLN A  56     -11.851 -14.368  -7.776  1.00  0.00           C  
ATOM    900  CG  GLN A  56     -13.311 -14.506  -8.178  1.00  0.00           C  
ATOM    901  CD  GLN A  56     -13.480 -14.957  -9.615  1.00  0.00           C  
ATOM    902  OE1 GLN A  56     -12.664 -15.711 -10.142  1.00  0.00           O  
ATOM    903  NE2 GLN A  56     -14.546 -14.495 -10.259  1.00  0.00           N  
ATOM    904  H   GLN A  56     -12.779 -15.546  -5.644  1.00  0.00           H  
ATOM    905  HA  GLN A  56     -10.608 -13.685  -6.175  1.00  0.00           H  
ATOM    906  HB2 GLN A  56     -11.381 -13.662  -8.444  1.00  0.00           H  
ATOM    907  HB3 GLN A  56     -11.377 -15.333  -7.891  1.00  0.00           H  
ATOM    908  HG2 GLN A  56     -13.782 -15.230  -7.531  1.00  0.00           H  
ATOM    909  HG3 GLN A  56     -13.796 -13.548  -8.056  1.00  0.00           H  
ATOM    910 HE21 GLN A  56     -15.154 -13.896  -9.776  1.00  0.00           H  
ATOM    911 HE22 GLN A  56     -14.681 -14.769 -11.189  1.00  0.00           H  
ATOM    912  N   LEU A  57     -11.768 -11.474  -6.178  1.00  0.00           N  
ATOM    913  CA  LEU A  57     -12.409 -10.181  -5.972  1.00  0.00           C  
ATOM    914  C   LEU A  57     -11.876  -9.145  -6.957  1.00  0.00           C  
ATOM    915  O   LEU A  57     -10.709  -9.185  -7.343  1.00  0.00           O  
ATOM    916  CB  LEU A  57     -12.185  -9.700  -4.538  1.00  0.00           C  
ATOM    917  CG  LEU A  57     -10.882 -10.150  -3.876  1.00  0.00           C  
ATOM    918  CD1 LEU A  57     -10.447  -9.148  -2.816  1.00  0.00           C  
ATOM    919  CD2 LEU A  57     -11.043 -11.535  -3.266  1.00  0.00           C  
ATOM    920  H   LEU A  57     -10.809 -11.504  -6.380  1.00  0.00           H  
ATOM    921  HA  LEU A  57     -13.469 -10.307  -6.139  1.00  0.00           H  
ATOM    922  HB2 LEU A  57     -12.196  -8.621  -4.544  1.00  0.00           H  
ATOM    923  HB3 LEU A  57     -13.006 -10.064  -3.935  1.00  0.00           H  
ATOM    924  HG  LEU A  57     -10.104 -10.202  -4.625  1.00  0.00           H  
ATOM    925 HD11 LEU A  57     -10.340  -9.652  -1.867  1.00  0.00           H  
ATOM    926 HD12 LEU A  57     -11.192  -8.371  -2.730  1.00  0.00           H  
ATOM    927 HD13 LEU A  57      -9.501  -8.712  -3.102  1.00  0.00           H  
ATOM    928 HD21 LEU A  57     -11.883 -12.035  -3.726  1.00  0.00           H  
ATOM    929 HD22 LEU A  57     -11.216 -11.444  -2.204  1.00  0.00           H  
ATOM    930 HD23 LEU A  57     -10.144 -12.110  -3.436  1.00  0.00           H  
ATOM    931  N   ASN A  58     -12.740  -8.217  -7.357  1.00  0.00           N  
ATOM    932  CA  ASN A  58     -12.356  -7.169  -8.296  1.00  0.00           C  
ATOM    933  C   ASN A  58     -11.798  -5.956  -7.558  1.00  0.00           C  
ATOM    934  O   ASN A  58     -12.550  -5.147  -7.012  1.00  0.00           O  
ATOM    935  CB  ASN A  58     -13.556  -6.754  -9.149  1.00  0.00           C  
ATOM    936  CG  ASN A  58     -14.625  -6.051  -8.338  1.00  0.00           C  
ATOM    937  OD1 ASN A  58     -15.268  -6.656  -7.480  1.00  0.00           O  
ATOM    938  ND2 ASN A  58     -14.823  -4.765  -8.606  1.00  0.00           N  
ATOM    939  H   ASN A  58     -13.658  -8.238  -7.014  1.00  0.00           H  
ATOM    940  HA  ASN A  58     -11.587  -7.568  -8.941  1.00  0.00           H  
ATOM    941  HB2 ASN A  58     -13.221  -6.083  -9.927  1.00  0.00           H  
ATOM    942  HB3 ASN A  58     -13.990  -7.634  -9.600  1.00  0.00           H  
ATOM    943 HD21 ASN A  58     -14.274  -4.348  -9.303  1.00  0.00           H  
ATOM    944 HD22 ASN A  58     -15.508  -4.285  -8.096  1.00  0.00           H  
ATOM    945  N   LEU A  59     -10.475  -5.835  -7.544  1.00  0.00           N  
ATOM    946  CA  LEU A  59      -9.815  -4.719  -6.874  1.00  0.00           C  
ATOM    947  C   LEU A  59     -10.507  -3.400  -7.205  1.00  0.00           C  
ATOM    948  O   LEU A  59     -10.754  -2.578  -6.322  1.00  0.00           O  
ATOM    949  CB  LEU A  59      -8.343  -4.653  -7.280  1.00  0.00           C  
ATOM    950  CG  LEU A  59      -7.413  -5.661  -6.602  1.00  0.00           C  
ATOM    951  CD1 LEU A  59      -6.033  -5.626  -7.239  1.00  0.00           C  
ATOM    952  CD2 LEU A  59      -7.321  -5.381  -5.109  1.00  0.00           C  
ATOM    953  H   LEU A  59      -9.928  -6.511  -7.995  1.00  0.00           H  
ATOM    954  HA  LEU A  59      -9.880  -4.888  -5.808  1.00  0.00           H  
ATOM    955  HB2 LEU A  59      -8.286  -4.816  -8.345  1.00  0.00           H  
ATOM    956  HB3 LEU A  59      -7.981  -3.661  -7.049  1.00  0.00           H  
ATOM    957  HG  LEU A  59      -7.816  -6.656  -6.732  1.00  0.00           H  
ATOM    958 HD11 LEU A  59      -5.958  -4.767  -7.888  1.00  0.00           H  
ATOM    959 HD12 LEU A  59      -5.879  -6.527  -7.815  1.00  0.00           H  
ATOM    960 HD13 LEU A  59      -5.282  -5.562  -6.465  1.00  0.00           H  
ATOM    961 HD21 LEU A  59      -7.469  -4.326  -4.931  1.00  0.00           H  
ATOM    962 HD22 LEU A  59      -6.347  -5.674  -4.748  1.00  0.00           H  
ATOM    963 HD23 LEU A  59      -8.082  -5.946  -4.590  1.00  0.00           H  
ATOM    964  N   LYS A  60     -10.817  -3.205  -8.481  1.00  0.00           N  
ATOM    965  CA  LYS A  60     -11.482  -1.988  -8.930  1.00  0.00           C  
ATOM    966  C   LYS A  60     -12.723  -1.705  -8.089  1.00  0.00           C  
ATOM    967  O   LYS A  60     -13.813  -2.187  -8.390  1.00  0.00           O  
ATOM    968  CB  LYS A  60     -11.869  -2.107 -10.406  1.00  0.00           C  
ATOM    969  CG  LYS A  60     -11.859  -0.782 -11.147  1.00  0.00           C  
ATOM    970  CD  LYS A  60     -13.185  -0.054 -11.007  1.00  0.00           C  
ATOM    971  CE  LYS A  60     -13.115   1.349 -11.590  1.00  0.00           C  
ATOM    972  NZ  LYS A  60     -12.537   2.323 -10.624  1.00  0.00           N  
ATOM    973  H   LYS A  60     -10.594  -3.897  -9.139  1.00  0.00           H  
ATOM    974  HA  LYS A  60     -10.788  -1.168  -8.814  1.00  0.00           H  
ATOM    975  HB2 LYS A  60     -11.175  -2.776 -10.894  1.00  0.00           H  
ATOM    976  HB3 LYS A  60     -12.864  -2.524 -10.471  1.00  0.00           H  
ATOM    977  HG2 LYS A  60     -11.074  -0.160 -10.743  1.00  0.00           H  
ATOM    978  HG3 LYS A  60     -11.669  -0.968 -12.195  1.00  0.00           H  
ATOM    979  HD2 LYS A  60     -13.948  -0.611 -11.530  1.00  0.00           H  
ATOM    980  HD3 LYS A  60     -13.440   0.014  -9.959  1.00  0.00           H  
ATOM    981  HE2 LYS A  60     -12.499   1.327 -12.476  1.00  0.00           H  
ATOM    982  HE3 LYS A  60     -14.113   1.665 -11.854  1.00  0.00           H  
ATOM    983  HZ1 LYS A  60     -13.298   2.851 -10.150  1.00  0.00           H  
ATOM    984  HZ2 LYS A  60     -11.920   2.996 -11.120  1.00  0.00           H  
ATOM    985  HZ3 LYS A  60     -11.977   1.823  -9.904  1.00  0.00           H  
ATOM    986  N   GLY A  61     -12.548  -0.915  -7.032  1.00  0.00           N  
ATOM    987  CA  GLY A  61     -13.663  -0.580  -6.166  1.00  0.00           C  
ATOM    988  C   GLY A  61     -13.338  -0.782  -4.699  1.00  0.00           C  
ATOM    989  O   GLY A  61     -13.818  -0.039  -3.842  1.00  0.00           O  
ATOM    990  H   GLY A  61     -11.656  -0.557  -6.840  1.00  0.00           H  
ATOM    991  HA2 GLY A  61     -13.931   0.454  -6.325  1.00  0.00           H  
ATOM    992  HA3 GLY A  61     -14.507  -1.204  -6.425  1.00  0.00           H  
ATOM    993  N   CYS A  62     -12.525  -1.791  -4.409  1.00  0.00           N  
ATOM    994  CA  CYS A  62     -12.138  -2.090  -3.035  1.00  0.00           C  
ATOM    995  C   CYS A  62     -11.426  -0.901  -2.399  1.00  0.00           C  
ATOM    996  O   CYS A  62     -11.163   0.103  -3.060  1.00  0.00           O  
ATOM    997  CB  CYS A  62     -11.232  -3.323  -2.995  1.00  0.00           C  
ATOM    998  SG  CYS A  62      -9.536  -3.011  -3.535  1.00  0.00           S  
ATOM    999  H   CYS A  62     -12.175  -2.348  -5.136  1.00  0.00           H  
ATOM   1000  HA  CYS A  62     -13.037  -2.297  -2.476  1.00  0.00           H  
ATOM   1001  HB2 CYS A  62     -11.191  -3.697  -1.982  1.00  0.00           H  
ATOM   1002  HB3 CYS A  62     -11.648  -4.086  -3.636  1.00  0.00           H  
ATOM   1003  HG  CYS A  62      -9.550  -2.836  -4.848  1.00  0.00           H  
ATOM   1004  N   GLU A  63     -11.118  -1.022  -1.110  1.00  0.00           N  
ATOM   1005  CA  GLU A  63     -10.439   0.045  -0.385  1.00  0.00           C  
ATOM   1006  C   GLU A  63      -9.014  -0.363  -0.025  1.00  0.00           C  
ATOM   1007  O   GLU A  63      -8.738  -1.534   0.236  1.00  0.00           O  
ATOM   1008  CB  GLU A  63     -11.215   0.403   0.884  1.00  0.00           C  
ATOM   1009  CG  GLU A  63     -10.403   1.204   1.888  1.00  0.00           C  
ATOM   1010  CD  GLU A  63      -9.664   0.325   2.878  1.00  0.00           C  
ATOM   1011  OE1 GLU A  63      -8.634  -0.265   2.493  1.00  0.00           O  
ATOM   1012  OE2 GLU A  63     -10.117   0.228   4.037  1.00  0.00           O  
ATOM   1013  H   GLU A  63     -11.354  -1.847  -0.638  1.00  0.00           H  
ATOM   1014  HA  GLU A  63     -10.401   0.912  -1.028  1.00  0.00           H  
ATOM   1015  HB2 GLU A  63     -12.085   0.981   0.610  1.00  0.00           H  
ATOM   1016  HB3 GLU A  63     -11.538  -0.511   1.363  1.00  0.00           H  
ATOM   1017  HG2 GLU A  63      -9.681   1.803   1.352  1.00  0.00           H  
ATOM   1018  HG3 GLU A  63     -11.072   1.854   2.434  1.00  0.00           H  
ATOM   1019  N   VAL A  64      -8.110   0.611  -0.014  1.00  0.00           N  
ATOM   1020  CA  VAL A  64      -6.712   0.355   0.313  1.00  0.00           C  
ATOM   1021  C   VAL A  64      -6.189   1.372   1.320  1.00  0.00           C  
ATOM   1022  O   VAL A  64      -6.018   2.549   0.999  1.00  0.00           O  
ATOM   1023  CB  VAL A  64      -5.825   0.391  -0.945  1.00  0.00           C  
ATOM   1024  CG1 VAL A  64      -4.387   0.043  -0.595  1.00  0.00           C  
ATOM   1025  CG2 VAL A  64      -6.368  -0.555  -2.006  1.00  0.00           C  
ATOM   1026  H   VAL A  64      -8.390   1.525  -0.232  1.00  0.00           H  
ATOM   1027  HA  VAL A  64      -6.647  -0.632   0.746  1.00  0.00           H  
ATOM   1028  HB  VAL A  64      -5.842   1.394  -1.345  1.00  0.00           H  
ATOM   1029 HG11 VAL A  64      -4.188   0.324   0.430  1.00  0.00           H  
ATOM   1030 HG12 VAL A  64      -4.233  -1.020  -0.714  1.00  0.00           H  
ATOM   1031 HG13 VAL A  64      -3.717   0.580  -1.250  1.00  0.00           H  
ATOM   1032 HG21 VAL A  64      -7.157  -1.157  -1.583  1.00  0.00           H  
ATOM   1033 HG22 VAL A  64      -6.757   0.019  -2.833  1.00  0.00           H  
ATOM   1034 HG23 VAL A  64      -5.572  -1.198  -2.357  1.00  0.00           H  
ATOM   1035  N   VAL A  65      -5.933   0.912   2.541  1.00  0.00           N  
ATOM   1036  CA  VAL A  65      -5.427   1.781   3.595  1.00  0.00           C  
ATOM   1037  C   VAL A  65      -3.967   1.472   3.910  1.00  0.00           C  
ATOM   1038  O   VAL A  65      -3.612   0.356   4.290  1.00  0.00           O  
ATOM   1039  CB  VAL A  65      -6.258   1.643   4.885  1.00  0.00           C  
ATOM   1040  CG1 VAL A  65      -5.575   2.358   6.040  1.00  0.00           C  
ATOM   1041  CG2 VAL A  65      -7.665   2.180   4.671  1.00  0.00           C  
ATOM   1042  H   VAL A  65      -6.089  -0.035   2.736  1.00  0.00           H  
ATOM   1043  HA  VAL A  65      -5.502   2.802   3.251  1.00  0.00           H  
ATOM   1044  HB  VAL A  65      -6.330   0.594   5.132  1.00  0.00           H  
ATOM   1045 HG11 VAL A  65      -4.736   2.927   5.667  1.00  0.00           H  
ATOM   1046 HG12 VAL A  65      -6.279   3.024   6.518  1.00  0.00           H  
ATOM   1047 HG13 VAL A  65      -5.224   1.631   6.757  1.00  0.00           H  
ATOM   1048 HG21 VAL A  65      -7.838   2.327   3.616  1.00  0.00           H  
ATOM   1049 HG22 VAL A  65      -8.382   1.473   5.060  1.00  0.00           H  
ATOM   1050 HG23 VAL A  65      -7.773   3.123   5.188  1.00  0.00           H  
ATOM   1051  N   PRO A  66      -3.100   2.482   3.747  1.00  0.00           N  
ATOM   1052  CA  PRO A  66      -1.664   2.343   4.008  1.00  0.00           C  
ATOM   1053  C   PRO A  66      -1.358   2.189   5.495  1.00  0.00           C  
ATOM   1054  O   PRO A  66      -1.780   3.006   6.313  1.00  0.00           O  
ATOM   1055  CB  PRO A  66      -1.077   3.652   3.474  1.00  0.00           C  
ATOM   1056  CG  PRO A  66      -2.200   4.628   3.550  1.00  0.00           C  
ATOM   1057  CD  PRO A  66      -3.454   3.838   3.296  1.00  0.00           C  
ATOM   1058  HA  PRO A  66      -1.241   1.510   3.467  1.00  0.00           H  
ATOM   1059  HB2 PRO A  66      -0.246   3.956   4.094  1.00  0.00           H  
ATOM   1060  HB3 PRO A  66      -0.744   3.512   2.457  1.00  0.00           H  
ATOM   1061  HG2 PRO A  66      -2.231   5.077   4.531  1.00  0.00           H  
ATOM   1062  HG3 PRO A  66      -2.077   5.388   2.792  1.00  0.00           H  
ATOM   1063  HD2 PRO A  66      -4.274   4.236   3.876  1.00  0.00           H  
ATOM   1064  HD3 PRO A  66      -3.697   3.843   2.243  1.00  0.00           H  
ATOM   1065  N   ASP A  67      -0.621   1.137   5.836  1.00  0.00           N  
ATOM   1066  CA  ASP A  67      -0.258   0.878   7.224  1.00  0.00           C  
ATOM   1067  C   ASP A  67       1.242   0.628   7.354  1.00  0.00           C  
ATOM   1068  O   ASP A  67       1.669  -0.324   8.008  1.00  0.00           O  
ATOM   1069  CB  ASP A  67      -1.036  -0.324   7.761  1.00  0.00           C  
ATOM   1070  CG  ASP A  67      -2.531  -0.078   7.790  1.00  0.00           C  
ATOM   1071  OD1 ASP A  67      -2.941   1.099   7.723  1.00  0.00           O  
ATOM   1072  OD2 ASP A  67      -3.293  -1.064   7.880  1.00  0.00           O  
ATOM   1073  H   ASP A  67      -0.314   0.522   5.138  1.00  0.00           H  
ATOM   1074  HA  ASP A  67      -0.516   1.751   7.803  1.00  0.00           H  
ATOM   1075  HB2 ASP A  67      -0.842  -1.181   7.133  1.00  0.00           H  
ATOM   1076  HB3 ASP A  67      -0.704  -0.538   8.767  1.00  0.00           H  
ATOM   1077  N   VAL A  68       2.038   1.489   6.727  1.00  0.00           N  
ATOM   1078  CA  VAL A  68       3.489   1.362   6.774  1.00  0.00           C  
ATOM   1079  C   VAL A  68       4.081   2.219   7.886  1.00  0.00           C  
ATOM   1080  O   VAL A  68       3.590   3.311   8.170  1.00  0.00           O  
ATOM   1081  CB  VAL A  68       4.130   1.765   5.432  1.00  0.00           C  
ATOM   1082  CG1 VAL A  68       3.296   1.258   4.267  1.00  0.00           C  
ATOM   1083  CG2 VAL A  68       4.303   3.275   5.358  1.00  0.00           C  
ATOM   1084  H   VAL A  68       1.638   2.227   6.223  1.00  0.00           H  
ATOM   1085  HA  VAL A  68       3.727   0.326   6.966  1.00  0.00           H  
ATOM   1086  HB  VAL A  68       5.108   1.309   5.373  1.00  0.00           H  
ATOM   1087 HG11 VAL A  68       3.177   0.187   4.349  1.00  0.00           H  
ATOM   1088 HG12 VAL A  68       2.325   1.731   4.286  1.00  0.00           H  
ATOM   1089 HG13 VAL A  68       3.793   1.494   3.338  1.00  0.00           H  
ATOM   1090 HG21 VAL A  68       4.464   3.569   4.332  1.00  0.00           H  
ATOM   1091 HG22 VAL A  68       3.414   3.757   5.737  1.00  0.00           H  
ATOM   1092 HG23 VAL A  68       5.154   3.570   5.954  1.00  0.00           H  
ATOM   1093  N   ASN A  69       5.139   1.718   8.513  1.00  0.00           N  
ATOM   1094  CA  ASN A  69       5.799   2.439   9.596  1.00  0.00           C  
ATOM   1095  C   ASN A  69       7.315   2.419   9.418  1.00  0.00           C  
ATOM   1096  O   ASN A  69       7.995   1.510   9.896  1.00  0.00           O  
ATOM   1097  CB  ASN A  69       5.425   1.826  10.947  1.00  0.00           C  
ATOM   1098  CG  ASN A  69       4.151   2.419  11.517  1.00  0.00           C  
ATOM   1099  OD1 ASN A  69       3.055   1.915  11.274  1.00  0.00           O  
ATOM   1100  ND2 ASN A  69       4.290   3.496  12.282  1.00  0.00           N  
ATOM   1101  H   ASN A  69       5.485   0.842   8.242  1.00  0.00           H  
ATOM   1102  HA  ASN A  69       5.459   3.463   9.568  1.00  0.00           H  
ATOM   1103  HB2 ASN A  69       5.280   0.762  10.825  1.00  0.00           H  
ATOM   1104  HB3 ASN A  69       6.226   1.999  11.649  1.00  0.00           H  
ATOM   1105 HD21 ASN A  69       5.195   3.843  12.433  1.00  0.00           H  
ATOM   1106 HD22 ASN A  69       3.484   3.900  12.664  1.00  0.00           H  
ATOM   1107  N   VAL A  70       7.838   3.427   8.728  1.00  0.00           N  
ATOM   1108  CA  VAL A  70       9.273   3.527   8.489  1.00  0.00           C  
ATOM   1109  C   VAL A  70      10.062   3.272   9.768  1.00  0.00           C  
ATOM   1110  O   VAL A  70      11.170   2.738   9.729  1.00  0.00           O  
ATOM   1111  CB  VAL A  70       9.654   4.911   7.931  1.00  0.00           C  
ATOM   1112  CG1 VAL A  70      11.161   5.021   7.757  1.00  0.00           C  
ATOM   1113  CG2 VAL A  70       8.937   5.171   6.616  1.00  0.00           C  
ATOM   1114  H   VAL A  70       7.244   4.120   8.372  1.00  0.00           H  
ATOM   1115  HA  VAL A  70       9.542   2.781   7.756  1.00  0.00           H  
ATOM   1116  HB  VAL A  70       9.340   5.662   8.643  1.00  0.00           H  
ATOM   1117 HG11 VAL A  70      11.413   6.016   7.423  1.00  0.00           H  
ATOM   1118 HG12 VAL A  70      11.648   4.822   8.701  1.00  0.00           H  
ATOM   1119 HG13 VAL A  70      11.490   4.301   7.022  1.00  0.00           H  
ATOM   1120 HG21 VAL A  70       8.094   4.500   6.525  1.00  0.00           H  
ATOM   1121 HG22 VAL A  70       8.587   6.192   6.592  1.00  0.00           H  
ATOM   1122 HG23 VAL A  70       9.618   5.005   5.794  1.00  0.00           H  
ATOM   1123  N   SER A  71       9.483   3.655  10.900  1.00  0.00           N  
ATOM   1124  CA  SER A  71      10.134   3.471  12.193  1.00  0.00           C  
ATOM   1125  C   SER A  71      10.881   2.141  12.239  1.00  0.00           C  
ATOM   1126  O   SER A  71      11.969   2.047  12.805  1.00  0.00           O  
ATOM   1127  CB  SER A  71       9.102   3.529  13.321  1.00  0.00           C  
ATOM   1128  OG  SER A  71       8.850   4.868  13.712  1.00  0.00           O  
ATOM   1129  H   SER A  71       8.598   4.075  10.867  1.00  0.00           H  
ATOM   1130  HA  SER A  71      10.844   4.273  12.324  1.00  0.00           H  
ATOM   1131  HB2 SER A  71       8.178   3.085  12.983  1.00  0.00           H  
ATOM   1132  HB3 SER A  71       9.475   2.980  14.174  1.00  0.00           H  
ATOM   1133  HG  SER A  71       8.088   5.203  13.235  1.00  0.00           H  
ATOM   1134  N   GLY A  72      10.286   1.114  11.641  1.00  0.00           N  
ATOM   1135  CA  GLY A  72      10.908  -0.197  11.625  1.00  0.00           C  
ATOM   1136  C   GLY A  72      10.889  -0.832  10.249  1.00  0.00           C  
ATOM   1137  O   GLY A  72      10.574  -2.014  10.107  1.00  0.00           O  
ATOM   1138  H   GLY A  72       9.418   1.248  11.206  1.00  0.00           H  
ATOM   1139  HA2 GLY A  72      11.932  -0.102  11.952  1.00  0.00           H  
ATOM   1140  HA3 GLY A  72      10.379  -0.841  12.313  1.00  0.00           H  
ATOM   1141  N   GLN A  73      11.225  -0.045   9.232  1.00  0.00           N  
ATOM   1142  CA  GLN A  73      11.243  -0.537   7.859  1.00  0.00           C  
ATOM   1143  C   GLN A  73      10.081  -1.492   7.608  1.00  0.00           C  
ATOM   1144  O   GLN A  73      10.254  -2.555   7.011  1.00  0.00           O  
ATOM   1145  CB  GLN A  73      12.569  -1.241   7.564  1.00  0.00           C  
ATOM   1146  CG  GLN A  73      13.790  -0.380   7.848  1.00  0.00           C  
ATOM   1147  CD  GLN A  73      14.272  -0.505   9.280  1.00  0.00           C  
ATOM   1148  OE1 GLN A  73      14.975  -1.453   9.630  1.00  0.00           O  
ATOM   1149  NE2 GLN A  73      13.895   0.454  10.118  1.00  0.00           N  
ATOM   1150  H   GLN A  73      11.466   0.887   9.408  1.00  0.00           H  
ATOM   1151  HA  GLN A  73      11.143   0.313   7.201  1.00  0.00           H  
ATOM   1152  HB2 GLN A  73      12.633  -2.131   8.171  1.00  0.00           H  
ATOM   1153  HB3 GLN A  73      12.589  -1.522   6.522  1.00  0.00           H  
ATOM   1154  HG2 GLN A  73      14.589  -0.683   7.188  1.00  0.00           H  
ATOM   1155  HG3 GLN A  73      13.539   0.652   7.657  1.00  0.00           H  
ATOM   1156 HE21 GLN A  73      13.334   1.178   9.769  1.00  0.00           H  
ATOM   1157 HE22 GLN A  73      14.192   0.397  11.050  1.00  0.00           H  
ATOM   1158  N   LYS A  74       8.895  -1.106   8.068  1.00  0.00           N  
ATOM   1159  CA  LYS A  74       7.702  -1.927   7.892  1.00  0.00           C  
ATOM   1160  C   LYS A  74       6.748  -1.292   6.887  1.00  0.00           C  
ATOM   1161  O   LYS A  74       6.646  -0.068   6.799  1.00  0.00           O  
ATOM   1162  CB  LYS A  74       6.992  -2.123   9.234  1.00  0.00           C  
ATOM   1163  CG  LYS A  74       5.750  -2.992   9.143  1.00  0.00           C  
ATOM   1164  CD  LYS A  74       5.010  -3.049  10.470  1.00  0.00           C  
ATOM   1165  CE  LYS A  74       5.788  -3.847  11.506  1.00  0.00           C  
ATOM   1166  NZ  LYS A  74       5.106  -3.846  12.831  1.00  0.00           N  
ATOM   1167  H   LYS A  74       8.820  -0.248   8.535  1.00  0.00           H  
ATOM   1168  HA  LYS A  74       8.015  -2.890   7.517  1.00  0.00           H  
ATOM   1169  HB2 LYS A  74       7.679  -2.584   9.928  1.00  0.00           H  
ATOM   1170  HB3 LYS A  74       6.701  -1.155   9.618  1.00  0.00           H  
ATOM   1171  HG2 LYS A  74       5.089  -2.584   8.393  1.00  0.00           H  
ATOM   1172  HG3 LYS A  74       6.042  -3.994   8.861  1.00  0.00           H  
ATOM   1173  HD2 LYS A  74       4.870  -2.044  10.838  1.00  0.00           H  
ATOM   1174  HD3 LYS A  74       4.048  -3.517  10.316  1.00  0.00           H  
ATOM   1175  HE2 LYS A  74       5.883  -4.865  11.161  1.00  0.00           H  
ATOM   1176  HE3 LYS A  74       6.769  -3.411  11.615  1.00  0.00           H  
ATOM   1177  HZ1 LYS A  74       4.703  -2.908  13.025  1.00  0.00           H  
ATOM   1178  HZ2 LYS A  74       5.787  -4.082  13.582  1.00  0.00           H  
ATOM   1179  HZ3 LYS A  74       4.341  -4.549  12.839  1.00  0.00           H  
ATOM   1180  N   PHE A  75       6.047  -2.132   6.132  1.00  0.00           N  
ATOM   1181  CA  PHE A  75       5.100  -1.653   5.132  1.00  0.00           C  
ATOM   1182  C   PHE A  75       3.963  -2.651   4.936  1.00  0.00           C  
ATOM   1183  O   PHE A  75       4.143  -3.698   4.313  1.00  0.00           O  
ATOM   1184  CB  PHE A  75       5.812  -1.405   3.800  1.00  0.00           C  
ATOM   1185  CG  PHE A  75       7.174  -0.791   3.953  1.00  0.00           C  
ATOM   1186  CD1 PHE A  75       8.287  -1.587   4.169  1.00  0.00           C  
ATOM   1187  CD2 PHE A  75       7.341   0.583   3.880  1.00  0.00           C  
ATOM   1188  CE1 PHE A  75       9.541  -1.023   4.312  1.00  0.00           C  
ATOM   1189  CE2 PHE A  75       8.592   1.152   4.022  1.00  0.00           C  
ATOM   1190  CZ  PHE A  75       9.694   0.347   4.236  1.00  0.00           C  
ATOM   1191  H   PHE A  75       6.172  -3.098   6.248  1.00  0.00           H  
ATOM   1192  HA  PHE A  75       4.687  -0.721   5.488  1.00  0.00           H  
ATOM   1193  HB2 PHE A  75       5.929  -2.347   3.283  1.00  0.00           H  
ATOM   1194  HB3 PHE A  75       5.212  -0.741   3.198  1.00  0.00           H  
ATOM   1195  HD1 PHE A  75       8.169  -2.659   4.227  1.00  0.00           H  
ATOM   1196  HD2 PHE A  75       6.479   1.213   3.712  1.00  0.00           H  
ATOM   1197  HE1 PHE A  75      10.401  -1.655   4.479  1.00  0.00           H  
ATOM   1198  HE2 PHE A  75       8.708   2.224   3.961  1.00  0.00           H  
ATOM   1199  HZ  PHE A  75      10.673   0.789   4.347  1.00  0.00           H  
ATOM   1200  N   CYS A  76       2.794  -2.321   5.475  1.00  0.00           N  
ATOM   1201  CA  CYS A  76       1.628  -3.188   5.361  1.00  0.00           C  
ATOM   1202  C   CYS A  76       0.543  -2.533   4.512  1.00  0.00           C  
ATOM   1203  O   CYS A  76       0.482  -1.309   4.402  1.00  0.00           O  
ATOM   1204  CB  CYS A  76       1.075  -3.520   6.748  1.00  0.00           C  
ATOM   1205  SG  CYS A  76       0.101  -5.041   6.812  1.00  0.00           S  
ATOM   1206  H   CYS A  76       2.714  -1.473   5.960  1.00  0.00           H  
ATOM   1207  HA  CYS A  76       1.941  -4.103   4.881  1.00  0.00           H  
ATOM   1208  HB2 CYS A  76       1.900  -3.630   7.439  1.00  0.00           H  
ATOM   1209  HB3 CYS A  76       0.444  -2.709   7.079  1.00  0.00           H  
ATOM   1210  HG  CYS A  76       0.904  -6.027   7.179  1.00  0.00           H  
ATOM   1211  N   ILE A  77      -0.310  -3.357   3.914  1.00  0.00           N  
ATOM   1212  CA  ILE A  77      -1.392  -2.858   3.074  1.00  0.00           C  
ATOM   1213  C   ILE A  77      -2.711  -3.545   3.411  1.00  0.00           C  
ATOM   1214  O   ILE A  77      -2.890  -4.734   3.148  1.00  0.00           O  
ATOM   1215  CB  ILE A  77      -1.085  -3.065   1.578  1.00  0.00           C  
ATOM   1216  CG1 ILE A  77       0.276  -2.461   1.226  1.00  0.00           C  
ATOM   1217  CG2 ILE A  77      -2.182  -2.448   0.723  1.00  0.00           C  
ATOM   1218  CD1 ILE A  77       0.912  -3.081   0.002  1.00  0.00           C  
ATOM   1219  H   ILE A  77      -0.211  -4.324   4.040  1.00  0.00           H  
ATOM   1220  HA  ILE A  77      -1.493  -1.798   3.257  1.00  0.00           H  
ATOM   1221  HB  ILE A  77      -1.063  -4.126   1.382  1.00  0.00           H  
ATOM   1222 HG12 ILE A  77       0.157  -1.406   1.041  1.00  0.00           H  
ATOM   1223 HG13 ILE A  77       0.950  -2.603   2.059  1.00  0.00           H  
ATOM   1224 HG21 ILE A  77      -1.854  -2.402  -0.304  1.00  0.00           H  
ATOM   1225 HG22 ILE A  77      -3.073  -3.054   0.789  1.00  0.00           H  
ATOM   1226 HG23 ILE A  77      -2.397  -1.451   1.078  1.00  0.00           H  
ATOM   1227 HD11 ILE A  77       0.686  -4.136  -0.026  1.00  0.00           H  
ATOM   1228 HD12 ILE A  77       0.521  -2.607  -0.886  1.00  0.00           H  
ATOM   1229 HD13 ILE A  77       1.982  -2.942   0.043  1.00  0.00           H  
ATOM   1230  N   LYS A  78      -3.634  -2.787   3.993  1.00  0.00           N  
ATOM   1231  CA  LYS A  78      -4.940  -3.320   4.364  1.00  0.00           C  
ATOM   1232  C   LYS A  78      -5.927  -3.196   3.207  1.00  0.00           C  
ATOM   1233  O   LYS A  78      -6.392  -2.100   2.891  1.00  0.00           O  
ATOM   1234  CB  LYS A  78      -5.482  -2.587   5.593  1.00  0.00           C  
ATOM   1235  CG  LYS A  78      -6.892  -3.004   5.977  1.00  0.00           C  
ATOM   1236  CD  LYS A  78      -7.641  -1.874   6.662  1.00  0.00           C  
ATOM   1237  CE  LYS A  78      -9.136  -1.956   6.398  1.00  0.00           C  
ATOM   1238  NZ  LYS A  78      -9.930  -1.393   7.526  1.00  0.00           N  
ATOM   1239  H   LYS A  78      -3.433  -1.845   4.177  1.00  0.00           H  
ATOM   1240  HA  LYS A  78      -4.816  -4.365   4.604  1.00  0.00           H  
ATOM   1241  HB2 LYS A  78      -4.830  -2.784   6.431  1.00  0.00           H  
ATOM   1242  HB3 LYS A  78      -5.486  -1.526   5.392  1.00  0.00           H  
ATOM   1243  HG2 LYS A  78      -7.429  -3.288   5.084  1.00  0.00           H  
ATOM   1244  HG3 LYS A  78      -6.837  -3.848   6.650  1.00  0.00           H  
ATOM   1245  HD2 LYS A  78      -7.470  -1.934   7.726  1.00  0.00           H  
ATOM   1246  HD3 LYS A  78      -7.269  -0.929   6.289  1.00  0.00           H  
ATOM   1247  HE2 LYS A  78      -9.362  -1.402   5.500  1.00  0.00           H  
ATOM   1248  HE3 LYS A  78      -9.408  -2.992   6.260  1.00  0.00           H  
ATOM   1249  HZ1 LYS A  78     -10.936  -1.341   7.265  1.00  0.00           H  
ATOM   1250  HZ2 LYS A  78      -9.593  -0.436   7.757  1.00  0.00           H  
ATOM   1251  HZ3 LYS A  78      -9.831  -1.995   8.368  1.00  0.00           H  
ATOM   1252  N   LEU A  79      -6.244  -4.324   2.582  1.00  0.00           N  
ATOM   1253  CA  LEU A  79      -7.176  -4.341   1.461  1.00  0.00           C  
ATOM   1254  C   LEU A  79      -8.578  -4.728   1.925  1.00  0.00           C  
ATOM   1255  O   LEU A  79      -8.822  -5.872   2.310  1.00  0.00           O  
ATOM   1256  CB  LEU A  79      -6.696  -5.318   0.386  1.00  0.00           C  
ATOM   1257  CG  LEU A  79      -7.210  -5.063  -1.031  1.00  0.00           C  
ATOM   1258  CD1 LEU A  79      -6.577  -3.806  -1.610  1.00  0.00           C  
ATOM   1259  CD2 LEU A  79      -6.930  -6.263  -1.924  1.00  0.00           C  
ATOM   1260  H   LEU A  79      -5.840  -5.165   2.880  1.00  0.00           H  
ATOM   1261  HA  LEU A  79      -7.210  -3.347   1.043  1.00  0.00           H  
ATOM   1262  HB2 LEU A  79      -5.618  -5.276   0.359  1.00  0.00           H  
ATOM   1263  HB3 LEU A  79      -7.009  -6.311   0.678  1.00  0.00           H  
ATOM   1264  HG  LEU A  79      -8.280  -4.912  -0.997  1.00  0.00           H  
ATOM   1265 HD11 LEU A  79      -5.773  -4.083  -2.275  1.00  0.00           H  
ATOM   1266 HD12 LEU A  79      -6.189  -3.197  -0.807  1.00  0.00           H  
ATOM   1267 HD13 LEU A  79      -7.322  -3.248  -2.157  1.00  0.00           H  
ATOM   1268 HD21 LEU A  79      -7.864  -6.673  -2.279  1.00  0.00           H  
ATOM   1269 HD22 LEU A  79      -6.399  -7.015  -1.359  1.00  0.00           H  
ATOM   1270 HD23 LEU A  79      -6.330  -5.952  -2.767  1.00  0.00           H  
ATOM   1271  N   LEU A  80      -9.495  -3.767   1.884  1.00  0.00           N  
ATOM   1272  CA  LEU A  80     -10.872  -4.006   2.299  1.00  0.00           C  
ATOM   1273  C   LEU A  80     -11.784  -4.174   1.086  1.00  0.00           C  
ATOM   1274  O   LEU A  80     -11.961  -3.247   0.296  1.00  0.00           O  
ATOM   1275  CB  LEU A  80     -11.372  -2.853   3.170  1.00  0.00           C  
ATOM   1276  CG  LEU A  80     -12.399  -3.217   4.241  1.00  0.00           C  
ATOM   1277  CD1 LEU A  80     -11.708  -3.759   5.483  1.00  0.00           C  
ATOM   1278  CD2 LEU A  80     -13.257  -2.010   4.591  1.00  0.00           C  
ATOM   1279  H   LEU A  80      -9.240  -2.876   1.568  1.00  0.00           H  
ATOM   1280  HA  LEU A  80     -10.891  -4.918   2.876  1.00  0.00           H  
ATOM   1281  HB2 LEU A  80     -10.516  -2.419   3.666  1.00  0.00           H  
ATOM   1282  HB3 LEU A  80     -11.819  -2.116   2.518  1.00  0.00           H  
ATOM   1283  HG  LEU A  80     -13.050  -3.992   3.859  1.00  0.00           H  
ATOM   1284 HD11 LEU A  80     -11.596  -2.966   6.207  1.00  0.00           H  
ATOM   1285 HD12 LEU A  80     -10.733  -4.140   5.215  1.00  0.00           H  
ATOM   1286 HD13 LEU A  80     -12.301  -4.556   5.908  1.00  0.00           H  
ATOM   1287 HD21 LEU A  80     -13.038  -1.692   5.600  1.00  0.00           H  
ATOM   1288 HD22 LEU A  80     -14.301  -2.277   4.516  1.00  0.00           H  
ATOM   1289 HD23 LEU A  80     -13.041  -1.204   3.903  1.00  0.00           H  
ATOM   1290  N   VAL A  81     -12.362  -5.363   0.949  1.00  0.00           N  
ATOM   1291  CA  VAL A  81     -13.259  -5.652  -0.165  1.00  0.00           C  
ATOM   1292  C   VAL A  81     -14.602  -6.175   0.331  1.00  0.00           C  
ATOM   1293  O   VAL A  81     -14.674  -7.049   1.196  1.00  0.00           O  
ATOM   1294  CB  VAL A  81     -12.642  -6.684  -1.129  1.00  0.00           C  
ATOM   1295  CG1 VAL A  81     -13.518  -6.854  -2.360  1.00  0.00           C  
ATOM   1296  CG2 VAL A  81     -11.231  -6.272  -1.519  1.00  0.00           C  
ATOM   1297  H   VAL A  81     -12.183  -6.063   1.610  1.00  0.00           H  
ATOM   1298  HA  VAL A  81     -13.420  -4.733  -0.711  1.00  0.00           H  
ATOM   1299  HB  VAL A  81     -12.588  -7.635  -0.618  1.00  0.00           H  
ATOM   1300 HG11 VAL A  81     -14.558  -6.801  -2.073  1.00  0.00           H  
ATOM   1301 HG12 VAL A  81     -13.299  -6.070  -3.069  1.00  0.00           H  
ATOM   1302 HG13 VAL A  81     -13.321  -7.815  -2.813  1.00  0.00           H  
ATOM   1303 HG21 VAL A  81     -10.938  -5.404  -0.947  1.00  0.00           H  
ATOM   1304 HG22 VAL A  81     -10.551  -7.085  -1.316  1.00  0.00           H  
ATOM   1305 HG23 VAL A  81     -11.205  -6.035  -2.573  1.00  0.00           H  
ATOM   1306  N   PRO A  82     -15.692  -5.627  -0.225  1.00  0.00           N  
ATOM   1307  CA  PRO A  82     -17.054  -6.024   0.146  1.00  0.00           C  
ATOM   1308  C   PRO A  82     -17.398  -7.432  -0.329  1.00  0.00           C  
ATOM   1309  O   PRO A  82     -17.021  -7.834  -1.430  1.00  0.00           O  
ATOM   1310  CB  PRO A  82     -17.930  -4.990  -0.566  1.00  0.00           C  
ATOM   1311  CG  PRO A  82     -17.110  -4.530  -1.721  1.00  0.00           C  
ATOM   1312  CD  PRO A  82     -15.680  -4.580  -1.260  1.00  0.00           C  
ATOM   1313  HA  PRO A  82     -17.210  -5.957   1.212  1.00  0.00           H  
ATOM   1314  HB2 PRO A  82     -18.848  -5.459  -0.894  1.00  0.00           H  
ATOM   1315  HB3 PRO A  82     -18.155  -4.177   0.108  1.00  0.00           H  
ATOM   1316  HG2 PRO A  82     -17.257  -5.190  -2.562  1.00  0.00           H  
ATOM   1317  HG3 PRO A  82     -17.383  -3.518  -1.984  1.00  0.00           H  
ATOM   1318  HD2 PRO A  82     -15.029  -4.853  -2.077  1.00  0.00           H  
ATOM   1319  HD3 PRO A  82     -15.385  -3.629  -0.841  1.00  0.00           H  
ATOM   1320  N   SER A  83     -18.114  -8.175   0.508  1.00  0.00           N  
ATOM   1321  CA  SER A  83     -18.506  -9.540   0.173  1.00  0.00           C  
ATOM   1322  C   SER A  83     -19.993  -9.757   0.432  1.00  0.00           C  
ATOM   1323  O   SER A  83     -20.584  -9.172   1.340  1.00  0.00           O  
ATOM   1324  CB  SER A  83     -17.684 -10.542   0.986  1.00  0.00           C  
ATOM   1325  OG  SER A  83     -16.309 -10.463   0.653  1.00  0.00           O  
ATOM   1326  H   SER A  83     -18.384  -7.798   1.371  1.00  0.00           H  
ATOM   1327  HA  SER A  83     -18.308  -9.693  -0.877  1.00  0.00           H  
ATOM   1328  HB2 SER A  83     -17.799 -10.329   2.038  1.00  0.00           H  
ATOM   1329  HB3 SER A  83     -18.035 -11.543   0.780  1.00  0.00           H  
ATOM   1330  HG  SER A  83     -16.176 -10.788  -0.241  1.00  0.00           H  
ATOM   1331  N   PRO A  84     -20.615 -10.619  -0.386  1.00  0.00           N  
ATOM   1332  CA  PRO A  84     -22.042 -10.935  -0.267  1.00  0.00           C  
ATOM   1333  C   PRO A  84     -22.353 -11.747   0.986  1.00  0.00           C  
ATOM   1334  O   PRO A  84     -23.513 -12.038   1.275  1.00  0.00           O  
ATOM   1335  CB  PRO A  84     -22.330 -11.760  -1.524  1.00  0.00           C  
ATOM   1336  CG  PRO A  84     -21.016 -12.360  -1.891  1.00  0.00           C  
ATOM   1337  CD  PRO A  84     -19.974 -11.353  -1.490  1.00  0.00           C  
ATOM   1338  HA  PRO A  84     -22.648 -10.041  -0.274  1.00  0.00           H  
ATOM   1339  HB2 PRO A  84     -23.063 -12.521  -1.297  1.00  0.00           H  
ATOM   1340  HB3 PRO A  84     -22.701 -11.114  -2.306  1.00  0.00           H  
ATOM   1341  HG2 PRO A  84     -20.872 -13.284  -1.353  1.00  0.00           H  
ATOM   1342  HG3 PRO A  84     -20.978 -12.534  -2.956  1.00  0.00           H  
ATOM   1343  HD2 PRO A  84     -19.078 -11.852  -1.153  1.00  0.00           H  
ATOM   1344  HD3 PRO A  84     -19.752 -10.691  -2.315  1.00  0.00           H  
ATOM   1345  N   GLU A  85     -21.309 -12.108   1.725  1.00  0.00           N  
ATOM   1346  CA  GLU A  85     -21.473 -12.887   2.948  1.00  0.00           C  
ATOM   1347  C   GLU A  85     -21.030 -12.085   4.168  1.00  0.00           C  
ATOM   1348  O   GLU A  85     -21.551 -12.266   5.267  1.00  0.00           O  
ATOM   1349  CB  GLU A  85     -20.674 -14.188   2.861  1.00  0.00           C  
ATOM   1350  CG  GLU A  85     -21.222 -15.173   1.842  1.00  0.00           C  
ATOM   1351  CD  GLU A  85     -20.231 -16.267   1.495  1.00  0.00           C  
ATOM   1352  OE1 GLU A  85     -20.053 -17.190   2.316  1.00  0.00           O  
ATOM   1353  OE2 GLU A  85     -19.633 -16.198   0.400  1.00  0.00           O  
ATOM   1354  H   GLU A  85     -20.408 -11.845   1.443  1.00  0.00           H  
ATOM   1355  HA  GLU A  85     -22.521 -13.126   3.051  1.00  0.00           H  
ATOM   1356  HB2 GLU A  85     -19.654 -13.953   2.590  1.00  0.00           H  
ATOM   1357  HB3 GLU A  85     -20.678 -14.665   3.830  1.00  0.00           H  
ATOM   1358  HG2 GLU A  85     -22.112 -15.631   2.246  1.00  0.00           H  
ATOM   1359  HG3 GLU A  85     -21.474 -14.635   0.939  1.00  0.00           H  
ATOM   1360  N   GLY A  86     -20.061 -11.196   3.965  1.00  0.00           N  
ATOM   1361  CA  GLY A  86     -19.561 -10.380   5.056  1.00  0.00           C  
ATOM   1362  C   GLY A  86     -18.566  -9.336   4.591  1.00  0.00           C  
ATOM   1363  O   GLY A  86     -18.950  -8.235   4.197  1.00  0.00           O  
ATOM   1364  H   GLY A  86     -19.682 -11.095   3.066  1.00  0.00           H  
ATOM   1365  HA2 GLY A  86     -20.395  -9.883   5.529  1.00  0.00           H  
ATOM   1366  HA3 GLY A  86     -19.080 -11.022   5.779  1.00  0.00           H  
ATOM   1367  N   MET A  87     -17.284  -9.682   4.637  1.00  0.00           N  
ATOM   1368  CA  MET A  87     -16.230  -8.765   4.218  1.00  0.00           C  
ATOM   1369  C   MET A  87     -14.981  -9.530   3.791  1.00  0.00           C  
ATOM   1370  O   MET A  87     -14.894 -10.744   3.971  1.00  0.00           O  
ATOM   1371  CB  MET A  87     -15.887  -7.795   5.350  1.00  0.00           C  
ATOM   1372  CG  MET A  87     -16.759  -6.550   5.370  1.00  0.00           C  
ATOM   1373  SD  MET A  87     -16.712  -5.645   3.811  1.00  0.00           S  
ATOM   1374  CE  MET A  87     -15.386  -4.485   4.133  1.00  0.00           C  
ATOM   1375  H   MET A  87     -17.039 -10.574   4.960  1.00  0.00           H  
ATOM   1376  HA  MET A  87     -16.599  -8.201   3.373  1.00  0.00           H  
ATOM   1377  HB2 MET A  87     -16.006  -8.306   6.294  1.00  0.00           H  
ATOM   1378  HB3 MET A  87     -14.858  -7.486   5.244  1.00  0.00           H  
ATOM   1379  HG2 MET A  87     -17.779  -6.844   5.567  1.00  0.00           H  
ATOM   1380  HG3 MET A  87     -16.415  -5.899   6.159  1.00  0.00           H  
ATOM   1381  HE1 MET A  87     -15.783  -3.615   4.635  1.00  0.00           H  
ATOM   1382  HE2 MET A  87     -14.641  -4.954   4.760  1.00  0.00           H  
ATOM   1383  HE3 MET A  87     -14.933  -4.187   3.199  1.00  0.00           H  
ATOM   1384  N   SER A  88     -14.018  -8.812   3.225  1.00  0.00           N  
ATOM   1385  CA  SER A  88     -12.774  -9.425   2.769  1.00  0.00           C  
ATOM   1386  C   SER A  88     -11.569  -8.594   3.200  1.00  0.00           C  
ATOM   1387  O   SER A  88     -10.945  -7.919   2.383  1.00  0.00           O  
ATOM   1388  CB  SER A  88     -12.785  -9.577   1.247  1.00  0.00           C  
ATOM   1389  OG  SER A  88     -13.334 -10.827   0.864  1.00  0.00           O  
ATOM   1390  H   SER A  88     -14.146  -7.847   3.109  1.00  0.00           H  
ATOM   1391  HA  SER A  88     -12.703 -10.403   3.221  1.00  0.00           H  
ATOM   1392  HB2 SER A  88     -13.379  -8.788   0.812  1.00  0.00           H  
ATOM   1393  HB3 SER A  88     -11.773  -9.513   0.875  1.00  0.00           H  
ATOM   1394  HG  SER A  88     -14.145 -10.682   0.371  1.00  0.00           H  
ATOM   1395  N   GLU A  89     -11.251  -8.650   4.490  1.00  0.00           N  
ATOM   1396  CA  GLU A  89     -10.121  -7.902   5.029  1.00  0.00           C  
ATOM   1397  C   GLU A  89      -8.865  -8.766   5.067  1.00  0.00           C  
ATOM   1398  O   GLU A  89      -8.777  -9.718   5.845  1.00  0.00           O  
ATOM   1399  CB  GLU A  89     -10.445  -7.390   6.435  1.00  0.00           C  
ATOM   1400  CG  GLU A  89      -9.433  -6.389   6.966  1.00  0.00           C  
ATOM   1401  CD  GLU A  89      -9.326  -6.414   8.478  1.00  0.00           C  
ATOM   1402  OE1 GLU A  89      -8.889  -7.447   9.026  1.00  0.00           O  
ATOM   1403  OE2 GLU A  89      -9.680  -5.399   9.114  1.00  0.00           O  
ATOM   1404  H   GLU A  89     -11.788  -9.206   5.091  1.00  0.00           H  
ATOM   1405  HA  GLU A  89      -9.943  -7.058   4.381  1.00  0.00           H  
ATOM   1406  HB2 GLU A  89     -11.416  -6.917   6.418  1.00  0.00           H  
ATOM   1407  HB3 GLU A  89     -10.476  -8.231   7.111  1.00  0.00           H  
ATOM   1408  HG2 GLU A  89      -8.465  -6.619   6.548  1.00  0.00           H  
ATOM   1409  HG3 GLU A  89      -9.731  -5.397   6.656  1.00  0.00           H  
ATOM   1410  N   ILE A  90      -7.895  -8.429   4.224  1.00  0.00           N  
ATOM   1411  CA  ILE A  90      -6.644  -9.174   4.161  1.00  0.00           C  
ATOM   1412  C   ILE A  90      -5.459  -8.288   4.530  1.00  0.00           C  
ATOM   1413  O   ILE A  90      -5.335  -7.165   4.042  1.00  0.00           O  
ATOM   1414  CB  ILE A  90      -6.412  -9.767   2.760  1.00  0.00           C  
ATOM   1415  CG1 ILE A  90      -7.459 -10.840   2.456  1.00  0.00           C  
ATOM   1416  CG2 ILE A  90      -5.008 -10.346   2.655  1.00  0.00           C  
ATOM   1417  CD1 ILE A  90      -8.720 -10.292   1.823  1.00  0.00           C  
ATOM   1418  H   ILE A  90      -8.025  -7.661   3.630  1.00  0.00           H  
ATOM   1419  HA  ILE A  90      -6.705  -9.987   4.870  1.00  0.00           H  
ATOM   1420  HB  ILE A  90      -6.501  -8.971   2.036  1.00  0.00           H  
ATOM   1421 HG12 ILE A  90      -7.037 -11.565   1.778  1.00  0.00           H  
ATOM   1422 HG13 ILE A  90      -7.736 -11.332   3.377  1.00  0.00           H  
ATOM   1423 HG21 ILE A  90      -4.927 -11.211   3.296  1.00  0.00           H  
ATOM   1424 HG22 ILE A  90      -4.814 -10.636   1.633  1.00  0.00           H  
ATOM   1425 HG23 ILE A  90      -4.288  -9.602   2.962  1.00  0.00           H  
ATOM   1426 HD11 ILE A  90      -8.504  -9.339   1.360  1.00  0.00           H  
ATOM   1427 HD12 ILE A  90      -9.076 -10.983   1.072  1.00  0.00           H  
ATOM   1428 HD13 ILE A  90      -9.477 -10.161   2.582  1.00  0.00           H  
ATOM   1429  N   TYR A  91      -4.588  -8.803   5.391  1.00  0.00           N  
ATOM   1430  CA  TYR A  91      -3.411  -8.059   5.825  1.00  0.00           C  
ATOM   1431  C   TYR A  91      -2.167  -8.518   5.071  1.00  0.00           C  
ATOM   1432  O   TYR A  91      -1.752  -9.673   5.181  1.00  0.00           O  
ATOM   1433  CB  TYR A  91      -3.202  -8.229   7.330  1.00  0.00           C  
ATOM   1434  CG  TYR A  91      -4.319  -7.647   8.167  1.00  0.00           C  
ATOM   1435  CD1 TYR A  91      -4.887  -6.420   7.846  1.00  0.00           C  
ATOM   1436  CD2 TYR A  91      -4.804  -8.322   9.279  1.00  0.00           C  
ATOM   1437  CE1 TYR A  91      -5.907  -5.883   8.607  1.00  0.00           C  
ATOM   1438  CE2 TYR A  91      -5.826  -7.794  10.046  1.00  0.00           C  
ATOM   1439  CZ  TYR A  91      -6.373  -6.575   9.706  1.00  0.00           C  
ATOM   1440  OH  TYR A  91      -7.389  -6.045  10.467  1.00  0.00           O  
ATOM   1441  H   TYR A  91      -4.741  -9.704   5.744  1.00  0.00           H  
ATOM   1442  HA  TYR A  91      -3.583  -7.014   5.611  1.00  0.00           H  
ATOM   1443  HB2 TYR A  91      -3.130  -9.280   7.560  1.00  0.00           H  
ATOM   1444  HB3 TYR A  91      -2.283  -7.738   7.616  1.00  0.00           H  
ATOM   1445  HD1 TYR A  91      -4.520  -5.881   6.984  1.00  0.00           H  
ATOM   1446  HD2 TYR A  91      -4.373  -9.277   9.543  1.00  0.00           H  
ATOM   1447  HE1 TYR A  91      -6.336  -4.929   8.342  1.00  0.00           H  
ATOM   1448  HE2 TYR A  91      -6.191  -8.335  10.907  1.00  0.00           H  
ATOM   1449  HH  TYR A  91      -7.592  -6.643  11.191  1.00  0.00           H  
ATOM   1450  N   LEU A  92      -1.576  -7.607   4.307  1.00  0.00           N  
ATOM   1451  CA  LEU A  92      -0.378  -7.917   3.535  1.00  0.00           C  
ATOM   1452  C   LEU A  92       0.808  -7.087   4.014  1.00  0.00           C  
ATOM   1453  O   LEU A  92       0.807  -5.862   3.904  1.00  0.00           O  
ATOM   1454  CB  LEU A  92      -0.626  -7.660   2.047  1.00  0.00           C  
ATOM   1455  CG  LEU A  92      -1.960  -8.161   1.493  1.00  0.00           C  
ATOM   1456  CD1 LEU A  92      -2.374  -7.344   0.279  1.00  0.00           C  
ATOM   1457  CD2 LEU A  92      -1.871  -9.638   1.139  1.00  0.00           C  
ATOM   1458  H   LEU A  92      -1.953  -6.704   4.260  1.00  0.00           H  
ATOM   1459  HA  LEU A  92      -0.153  -8.963   3.679  1.00  0.00           H  
ATOM   1460  HB2 LEU A  92      -0.579  -6.595   1.883  1.00  0.00           H  
ATOM   1461  HB3 LEU A  92       0.166  -8.143   1.493  1.00  0.00           H  
ATOM   1462  HG  LEU A  92      -2.724  -8.044   2.249  1.00  0.00           H  
ATOM   1463 HD11 LEU A  92      -2.096  -7.871  -0.622  1.00  0.00           H  
ATOM   1464 HD12 LEU A  92      -1.877  -6.386   0.303  1.00  0.00           H  
ATOM   1465 HD13 LEU A  92      -3.444  -7.194   0.293  1.00  0.00           H  
ATOM   1466 HD21 LEU A  92      -2.335  -9.807   0.179  1.00  0.00           H  
ATOM   1467 HD22 LEU A  92      -2.379 -10.220   1.893  1.00  0.00           H  
ATOM   1468 HD23 LEU A  92      -0.833  -9.935   1.095  1.00  0.00           H  
ATOM   1469  N   ARG A  93       1.822  -7.765   4.545  1.00  0.00           N  
ATOM   1470  CA  ARG A  93       3.016  -7.091   5.041  1.00  0.00           C  
ATOM   1471  C   ARG A  93       4.213  -7.369   4.136  1.00  0.00           C  
ATOM   1472  O   ARG A  93       4.506  -8.522   3.814  1.00  0.00           O  
ATOM   1473  CB  ARG A  93       3.326  -7.544   6.468  1.00  0.00           C  
ATOM   1474  CG  ARG A  93       4.481  -6.790   7.108  1.00  0.00           C  
ATOM   1475  CD  ARG A  93       5.812  -7.472   6.834  1.00  0.00           C  
ATOM   1476  NE  ARG A  93       6.875  -6.965   7.697  1.00  0.00           N  
ATOM   1477  CZ  ARG A  93       8.126  -7.412   7.662  1.00  0.00           C  
ATOM   1478  NH1 ARG A  93       8.469  -8.368   6.810  1.00  0.00           N  
ATOM   1479  NH2 ARG A  93       9.037  -6.900   8.480  1.00  0.00           N  
ATOM   1480  H   ARG A  93       1.765  -8.742   4.605  1.00  0.00           H  
ATOM   1481  HA  ARG A  93       2.820  -6.029   5.042  1.00  0.00           H  
ATOM   1482  HB2 ARG A  93       2.448  -7.397   7.080  1.00  0.00           H  
ATOM   1483  HB3 ARG A  93       3.575  -8.594   6.454  1.00  0.00           H  
ATOM   1484  HG2 ARG A  93       4.513  -5.788   6.703  1.00  0.00           H  
ATOM   1485  HG3 ARG A  93       4.322  -6.744   8.175  1.00  0.00           H  
ATOM   1486  HD2 ARG A  93       5.699  -8.532   7.003  1.00  0.00           H  
ATOM   1487  HD3 ARG A  93       6.084  -7.299   5.804  1.00  0.00           H  
ATOM   1488  HE  ARG A  93       6.644  -6.259   8.335  1.00  0.00           H  
ATOM   1489 HH11 ARG A  93       7.784  -8.754   6.192  1.00  0.00           H  
ATOM   1490 HH12 ARG A  93       9.411  -8.701   6.784  1.00  0.00           H  
ATOM   1491 HH21 ARG A  93       8.782  -6.179   9.124  1.00  0.00           H  
ATOM   1492 HH22 ARG A  93       9.978  -7.237   8.453  1.00  0.00           H  
ATOM   1493  N   CYS A  94       4.898  -6.308   3.727  1.00  0.00           N  
ATOM   1494  CA  CYS A  94       6.062  -6.437   2.858  1.00  0.00           C  
ATOM   1495  C   CYS A  94       7.354  -6.410   3.670  1.00  0.00           C  
ATOM   1496  O   CYS A  94       7.426  -5.763   4.715  1.00  0.00           O  
ATOM   1497  CB  CYS A  94       6.076  -5.315   1.818  1.00  0.00           C  
ATOM   1498  SG  CYS A  94       4.620  -5.285   0.747  1.00  0.00           S  
ATOM   1499  H   CYS A  94       4.615  -5.415   4.017  1.00  0.00           H  
ATOM   1500  HA  CYS A  94       5.991  -7.387   2.350  1.00  0.00           H  
ATOM   1501  HB2 CYS A  94       6.128  -4.364   2.327  1.00  0.00           H  
ATOM   1502  HB3 CYS A  94       6.947  -5.428   1.190  1.00  0.00           H  
ATOM   1503  HG  CYS A  94       5.034  -5.384  -0.508  1.00  0.00           H  
ATOM   1504  N   GLN A  95       8.367  -7.119   3.184  1.00  0.00           N  
ATOM   1505  CA  GLN A  95       9.655  -7.177   3.867  1.00  0.00           C  
ATOM   1506  C   GLN A  95      10.369  -5.831   3.796  1.00  0.00           C  
ATOM   1507  O   GLN A  95      10.959  -5.379   4.778  1.00  0.00           O  
ATOM   1508  CB  GLN A  95      10.533  -8.268   3.252  1.00  0.00           C  
ATOM   1509  CG  GLN A  95      10.735  -8.112   1.752  1.00  0.00           C  
ATOM   1510  CD  GLN A  95      11.592  -9.214   1.162  1.00  0.00           C  
ATOM   1511  OE1 GLN A  95      11.230 -10.391   1.209  1.00  0.00           O  
ATOM   1512  NE2 GLN A  95      12.735  -8.839   0.602  1.00  0.00           N  
ATOM   1513  H   GLN A  95       8.246  -7.613   2.348  1.00  0.00           H  
ATOM   1514  HA  GLN A  95       9.469  -7.418   4.903  1.00  0.00           H  
ATOM   1515  HB2 GLN A  95      11.502  -8.245   3.728  1.00  0.00           H  
ATOM   1516  HB3 GLN A  95      10.073  -9.228   3.433  1.00  0.00           H  
ATOM   1517  HG2 GLN A  95       9.769  -8.131   1.269  1.00  0.00           H  
ATOM   1518  HG3 GLN A  95      11.213  -7.163   1.563  1.00  0.00           H  
ATOM   1519 HE21 GLN A  95      12.959  -7.884   0.602  1.00  0.00           H  
ATOM   1520 HE22 GLN A  95      13.310  -9.531   0.213  1.00  0.00           H  
ATOM   1521  N   ASP A  96      10.312  -5.197   2.631  1.00  0.00           N  
ATOM   1522  CA  ASP A  96      10.954  -3.902   2.432  1.00  0.00           C  
ATOM   1523  C   ASP A  96      10.016  -2.935   1.717  1.00  0.00           C  
ATOM   1524  O   ASP A  96       8.861  -3.262   1.446  1.00  0.00           O  
ATOM   1525  CB  ASP A  96      12.246  -4.067   1.631  1.00  0.00           C  
ATOM   1526  CG  ASP A  96      12.094  -5.045   0.483  1.00  0.00           C  
ATOM   1527  OD1 ASP A  96      10.959  -5.203  -0.016  1.00  0.00           O  
ATOM   1528  OD2 ASP A  96      13.109  -5.652   0.082  1.00  0.00           O  
ATOM   1529  H   ASP A  96       9.825  -5.609   1.886  1.00  0.00           H  
ATOM   1530  HA  ASP A  96      11.193  -3.499   3.404  1.00  0.00           H  
ATOM   1531  HB2 ASP A  96      12.536  -3.108   1.227  1.00  0.00           H  
ATOM   1532  HB3 ASP A  96      13.025  -4.427   2.286  1.00  0.00           H  
ATOM   1533  N   GLU A  97      10.522  -1.743   1.414  1.00  0.00           N  
ATOM   1534  CA  GLU A  97       9.727  -0.729   0.732  1.00  0.00           C  
ATOM   1535  C   GLU A  97       9.580  -1.059  -0.751  1.00  0.00           C  
ATOM   1536  O   GLU A  97       8.592  -0.687  -1.384  1.00  0.00           O  
ATOM   1537  CB  GLU A  97      10.371   0.650   0.896  1.00  0.00           C  
ATOM   1538  CG  GLU A  97      11.615   0.846   0.046  1.00  0.00           C  
ATOM   1539  CD  GLU A  97      12.884   0.432   0.764  1.00  0.00           C  
ATOM   1540  OE1 GLU A  97      13.249  -0.761   0.683  1.00  0.00           O  
ATOM   1541  OE2 GLU A  97      13.513   1.298   1.407  1.00  0.00           O  
ATOM   1542  H   GLU A  97      11.450  -1.542   1.657  1.00  0.00           H  
ATOM   1543  HA  GLU A  97       8.748  -0.714   1.185  1.00  0.00           H  
ATOM   1544  HB2 GLU A  97       9.650   1.406   0.623  1.00  0.00           H  
ATOM   1545  HB3 GLU A  97      10.645   0.784   1.933  1.00  0.00           H  
ATOM   1546  HG2 GLU A  97      11.518   0.254  -0.852  1.00  0.00           H  
ATOM   1547  HG3 GLU A  97      11.694   1.891  -0.220  1.00  0.00           H  
ATOM   1548  N   GLN A  98      10.569  -1.759  -1.296  1.00  0.00           N  
ATOM   1549  CA  GLN A  98      10.549  -2.140  -2.704  1.00  0.00           C  
ATOM   1550  C   GLN A  98       9.282  -2.918  -3.040  1.00  0.00           C  
ATOM   1551  O   GLN A  98       8.465  -2.474  -3.847  1.00  0.00           O  
ATOM   1552  CB  GLN A  98      11.782  -2.979  -3.044  1.00  0.00           C  
ATOM   1553  CG  GLN A  98      13.096  -2.245  -2.828  1.00  0.00           C  
ATOM   1554  CD  GLN A  98      13.391  -1.241  -3.925  1.00  0.00           C  
ATOM   1555  OE1 GLN A  98      12.558  -0.996  -4.799  1.00  0.00           O  
ATOM   1556  NE2 GLN A  98      14.582  -0.655  -3.887  1.00  0.00           N  
ATOM   1557  H   GLN A  98      11.329  -2.027  -0.739  1.00  0.00           H  
ATOM   1558  HA  GLN A  98      10.567  -1.234  -3.291  1.00  0.00           H  
ATOM   1559  HB2 GLN A  98      11.783  -3.864  -2.426  1.00  0.00           H  
ATOM   1560  HB3 GLN A  98      11.726  -3.273  -4.081  1.00  0.00           H  
ATOM   1561  HG2 GLN A  98      13.049  -1.719  -1.885  1.00  0.00           H  
ATOM   1562  HG3 GLN A  98      13.896  -2.969  -2.796  1.00  0.00           H  
ATOM   1563 HE21 GLN A  98      15.195  -0.900  -3.162  1.00  0.00           H  
ATOM   1564 HE22 GLN A  98      14.800  -0.002  -4.583  1.00  0.00           H  
ATOM   1565  N   GLN A  99       9.123  -4.081  -2.416  1.00  0.00           N  
ATOM   1566  CA  GLN A  99       7.956  -4.920  -2.651  1.00  0.00           C  
ATOM   1567  C   GLN A  99       6.669  -4.159  -2.355  1.00  0.00           C  
ATOM   1568  O   GLN A  99       5.646  -4.369  -3.007  1.00  0.00           O  
ATOM   1569  CB  GLN A  99       8.026  -6.182  -1.787  1.00  0.00           C  
ATOM   1570  CG  GLN A  99       6.963  -7.214  -2.130  1.00  0.00           C  
ATOM   1571  CD  GLN A  99       7.171  -8.528  -1.404  1.00  0.00           C  
ATOM   1572  OE1 GLN A  99       7.014  -8.609  -0.185  1.00  0.00           O  
ATOM   1573  NE2 GLN A  99       7.526  -9.567  -2.150  1.00  0.00           N  
ATOM   1574  H   GLN A  99       9.809  -4.381  -1.784  1.00  0.00           H  
ATOM   1575  HA  GLN A  99       7.958  -5.208  -3.691  1.00  0.00           H  
ATOM   1576  HB2 GLN A  99       8.995  -6.638  -1.915  1.00  0.00           H  
ATOM   1577  HB3 GLN A  99       7.902  -5.901  -0.751  1.00  0.00           H  
ATOM   1578  HG2 GLN A  99       5.995  -6.819  -1.857  1.00  0.00           H  
ATOM   1579  HG3 GLN A  99       6.989  -7.398  -3.193  1.00  0.00           H  
ATOM   1580 HE21 GLN A  99       7.632  -9.429  -3.115  1.00  0.00           H  
ATOM   1581 HE22 GLN A  99       7.667 -10.429  -1.707  1.00  0.00           H  
ATOM   1582  N   TYR A 100       6.726  -3.271  -1.368  1.00  0.00           N  
ATOM   1583  CA  TYR A 100       5.564  -2.479  -0.984  1.00  0.00           C  
ATOM   1584  C   TYR A 100       5.145  -1.543  -2.114  1.00  0.00           C  
ATOM   1585  O   TYR A 100       4.058  -1.676  -2.675  1.00  0.00           O  
ATOM   1586  CB  TYR A 100       5.867  -1.669   0.278  1.00  0.00           C  
ATOM   1587  CG  TYR A 100       4.881  -0.551   0.531  1.00  0.00           C  
ATOM   1588  CD1 TYR A 100       3.603  -0.819   1.009  1.00  0.00           C  
ATOM   1589  CD2 TYR A 100       5.226   0.774   0.294  1.00  0.00           C  
ATOM   1590  CE1 TYR A 100       2.699   0.199   1.242  1.00  0.00           C  
ATOM   1591  CE2 TYR A 100       4.329   1.798   0.526  1.00  0.00           C  
ATOM   1592  CZ  TYR A 100       3.067   1.506   0.999  1.00  0.00           C  
ATOM   1593  OH  TYR A 100       2.170   2.523   1.230  1.00  0.00           O  
ATOM   1594  H   TYR A 100       7.569  -3.147  -0.885  1.00  0.00           H  
ATOM   1595  HA  TYR A 100       4.751  -3.160  -0.777  1.00  0.00           H  
ATOM   1596  HB2 TYR A 100       5.847  -2.328   1.133  1.00  0.00           H  
ATOM   1597  HB3 TYR A 100       6.850  -1.230   0.189  1.00  0.00           H  
ATOM   1598  HD1 TYR A 100       3.320  -1.845   1.199  1.00  0.00           H  
ATOM   1599  HD2 TYR A 100       6.216   0.999  -0.077  1.00  0.00           H  
ATOM   1600  HE1 TYR A 100       1.711  -0.029   1.612  1.00  0.00           H  
ATOM   1601  HE2 TYR A 100       4.616   2.822   0.335  1.00  0.00           H  
ATOM   1602  HH  TYR A 100       1.895   2.904   0.393  1.00  0.00           H  
ATOM   1603  N   ALA A 101       6.017  -0.595  -2.442  1.00  0.00           N  
ATOM   1604  CA  ALA A 101       5.741   0.362  -3.507  1.00  0.00           C  
ATOM   1605  C   ALA A 101       5.188  -0.337  -4.743  1.00  0.00           C  
ATOM   1606  O   ALA A 101       4.237   0.139  -5.364  1.00  0.00           O  
ATOM   1607  CB  ALA A 101       7.000   1.140  -3.857  1.00  0.00           C  
ATOM   1608  H   ALA A 101       6.867  -0.540  -1.958  1.00  0.00           H  
ATOM   1609  HA  ALA A 101       5.003   1.063  -3.141  1.00  0.00           H  
ATOM   1610  HB1 ALA A 101       6.737   2.000  -4.454  1.00  0.00           H  
ATOM   1611  HB2 ALA A 101       7.484   1.468  -2.948  1.00  0.00           H  
ATOM   1612  HB3 ALA A 101       7.672   0.505  -4.414  1.00  0.00           H  
ATOM   1613  N   ARG A 102       5.789  -1.469  -5.097  1.00  0.00           N  
ATOM   1614  CA  ARG A 102       5.357  -2.232  -6.261  1.00  0.00           C  
ATOM   1615  C   ARG A 102       3.905  -2.679  -6.110  1.00  0.00           C  
ATOM   1616  O   ARG A 102       3.030  -2.242  -6.857  1.00  0.00           O  
ATOM   1617  CB  ARG A 102       6.259  -3.451  -6.462  1.00  0.00           C  
ATOM   1618  CG  ARG A 102       7.656  -3.101  -6.947  1.00  0.00           C  
ATOM   1619  CD  ARG A 102       8.581  -4.307  -6.902  1.00  0.00           C  
ATOM   1620  NE  ARG A 102       9.976  -3.937  -7.124  1.00  0.00           N  
ATOM   1621  CZ  ARG A 102      10.955  -4.821  -7.273  1.00  0.00           C  
ATOM   1622  NH1 ARG A 102      10.694  -6.120  -7.224  1.00  0.00           N  
ATOM   1623  NH2 ARG A 102      12.200  -4.407  -7.472  1.00  0.00           N  
ATOM   1624  H   ARG A 102       6.541  -1.797  -4.561  1.00  0.00           H  
ATOM   1625  HA  ARG A 102       5.435  -1.591  -7.126  1.00  0.00           H  
ATOM   1626  HB2 ARG A 102       6.349  -3.975  -5.522  1.00  0.00           H  
ATOM   1627  HB3 ARG A 102       5.803  -4.105  -7.188  1.00  0.00           H  
ATOM   1628  HG2 ARG A 102       7.596  -2.747  -7.966  1.00  0.00           H  
ATOM   1629  HG3 ARG A 102       8.062  -2.323  -6.317  1.00  0.00           H  
ATOM   1630  HD2 ARG A 102       8.493  -4.775  -5.932  1.00  0.00           H  
ATOM   1631  HD3 ARG A 102       8.277  -5.006  -7.666  1.00  0.00           H  
ATOM   1632  HE  ARG A 102      10.191  -2.982  -7.164  1.00  0.00           H  
ATOM   1633 HH11 ARG A 102       9.758  -6.436  -7.076  1.00  0.00           H  
ATOM   1634 HH12 ARG A 102      11.434  -6.784  -7.338  1.00  0.00           H  
ATOM   1635 HH21 ARG A 102      12.401  -3.428  -7.510  1.00  0.00           H  
ATOM   1636 HH22 ARG A 102      12.937  -5.072  -7.584  1.00  0.00           H  
ATOM   1637  N   TRP A 103       3.659  -3.553  -5.141  1.00  0.00           N  
ATOM   1638  CA  TRP A 103       2.314  -4.060  -4.893  1.00  0.00           C  
ATOM   1639  C   TRP A 103       1.343  -2.917  -4.618  1.00  0.00           C  
ATOM   1640  O   TRP A 103       0.423  -2.672  -5.398  1.00  0.00           O  
ATOM   1641  CB  TRP A 103       2.323  -5.032  -3.712  1.00  0.00           C  
ATOM   1642  CG  TRP A 103       2.745  -6.420  -4.088  1.00  0.00           C  
ATOM   1643  CD1 TRP A 103       4.022  -6.892  -4.181  1.00  0.00           C  
ATOM   1644  CD2 TRP A 103       1.885  -7.515  -4.425  1.00  0.00           C  
ATOM   1645  NE1 TRP A 103       4.009  -8.215  -4.554  1.00  0.00           N  
ATOM   1646  CE2 TRP A 103       2.710  -8.621  -4.710  1.00  0.00           C  
ATOM   1647  CE3 TRP A 103       0.499  -7.670  -4.512  1.00  0.00           C  
ATOM   1648  CZ2 TRP A 103       2.193  -9.860  -5.076  1.00  0.00           C  
ATOM   1649  CZ3 TRP A 103      -0.013  -8.900  -4.874  1.00  0.00           C  
ATOM   1650  CH2 TRP A 103       0.832  -9.983  -5.152  1.00  0.00           C  
ATOM   1651  H   TRP A 103       4.399  -3.865  -4.579  1.00  0.00           H  
ATOM   1652  HA  TRP A 103       1.991  -4.587  -5.779  1.00  0.00           H  
ATOM   1653  HB2 TRP A 103       3.007  -4.669  -2.960  1.00  0.00           H  
ATOM   1654  HB3 TRP A 103       1.329  -5.086  -3.293  1.00  0.00           H  
ATOM   1655  HD1 TRP A 103       4.904  -6.302  -3.988  1.00  0.00           H  
ATOM   1656  HE1 TRP A 103       4.802  -8.776  -4.686  1.00  0.00           H  
ATOM   1657  HE3 TRP A 103      -0.169  -6.847  -4.301  1.00  0.00           H  
ATOM   1658  HZ2 TRP A 103       2.832 -10.705  -5.292  1.00  0.00           H  
ATOM   1659  HZ3 TRP A 103      -1.082  -9.039  -4.947  1.00  0.00           H  
ATOM   1660  HH2 TRP A 103       0.389 -10.926  -5.432  1.00  0.00           H  
ATOM   1661  N   MET A 104       1.555  -2.220  -3.507  1.00  0.00           N  
ATOM   1662  CA  MET A 104       0.698  -1.101  -3.133  1.00  0.00           C  
ATOM   1663  C   MET A 104       0.292  -0.293  -4.360  1.00  0.00           C  
ATOM   1664  O   MET A 104      -0.888  -0.220  -4.704  1.00  0.00           O  
ATOM   1665  CB  MET A 104       1.414  -0.197  -2.126  1.00  0.00           C  
ATOM   1666  CG  MET A 104       0.757   1.162  -1.956  1.00  0.00           C  
ATOM   1667  SD  MET A 104      -1.034   1.051  -1.777  1.00  0.00           S  
ATOM   1668  CE  MET A 104      -1.197   1.066   0.006  1.00  0.00           C  
ATOM   1669  H   MET A 104       2.305  -2.463  -2.926  1.00  0.00           H  
ATOM   1670  HA  MET A 104      -0.190  -1.505  -2.672  1.00  0.00           H  
ATOM   1671  HB2 MET A 104       1.428  -0.689  -1.165  1.00  0.00           H  
ATOM   1672  HB3 MET A 104       2.430  -0.043  -2.458  1.00  0.00           H  
ATOM   1673  HG2 MET A 104       1.163   1.637  -1.076  1.00  0.00           H  
ATOM   1674  HG3 MET A 104       0.981   1.766  -2.823  1.00  0.00           H  
ATOM   1675  HE1 MET A 104      -1.973   0.375   0.302  1.00  0.00           H  
ATOM   1676  HE2 MET A 104      -0.261   0.771   0.456  1.00  0.00           H  
ATOM   1677  HE3 MET A 104      -1.457   2.061   0.335  1.00  0.00           H  
ATOM   1678  N   ALA A 105       1.275   0.313  -5.016  1.00  0.00           N  
ATOM   1679  CA  ALA A 105       1.019   1.115  -6.207  1.00  0.00           C  
ATOM   1680  C   ALA A 105       0.085   0.387  -7.168  1.00  0.00           C  
ATOM   1681  O   ALA A 105      -0.771   1.003  -7.802  1.00  0.00           O  
ATOM   1682  CB  ALA A 105       2.328   1.462  -6.901  1.00  0.00           C  
ATOM   1683  H   ALA A 105       2.196   0.218  -4.694  1.00  0.00           H  
ATOM   1684  HA  ALA A 105       0.551   2.036  -5.894  1.00  0.00           H  
ATOM   1685  HB1 ALA A 105       2.768   0.565  -7.310  1.00  0.00           H  
ATOM   1686  HB2 ALA A 105       2.136   2.166  -7.699  1.00  0.00           H  
ATOM   1687  HB3 ALA A 105       3.007   1.903  -6.187  1.00  0.00           H  
ATOM   1688  N   GLY A 106       0.258  -0.928  -7.273  1.00  0.00           N  
ATOM   1689  CA  GLY A 106      -0.576  -1.716  -8.160  1.00  0.00           C  
ATOM   1690  C   GLY A 106      -2.024  -1.756  -7.713  1.00  0.00           C  
ATOM   1691  O   GLY A 106      -2.937  -1.645  -8.532  1.00  0.00           O  
ATOM   1692  H   GLY A 106       0.957  -1.364  -6.744  1.00  0.00           H  
ATOM   1693  HA2 GLY A 106      -0.527  -1.294  -9.152  1.00  0.00           H  
ATOM   1694  HA3 GLY A 106      -0.194  -2.726  -8.191  1.00  0.00           H  
ATOM   1695  N   CYS A 107      -2.235  -1.914  -6.411  1.00  0.00           N  
ATOM   1696  CA  CYS A 107      -3.583  -1.970  -5.857  1.00  0.00           C  
ATOM   1697  C   CYS A 107      -4.337  -0.672  -6.127  1.00  0.00           C  
ATOM   1698  O   CYS A 107      -5.476  -0.689  -6.592  1.00  0.00           O  
ATOM   1699  CB  CYS A 107      -3.526  -2.238  -4.352  1.00  0.00           C  
ATOM   1700  SG  CYS A 107      -3.051  -3.928  -3.920  1.00  0.00           S  
ATOM   1701  H   CYS A 107      -1.467  -1.997  -5.808  1.00  0.00           H  
ATOM   1702  HA  CYS A 107      -4.106  -2.782  -6.338  1.00  0.00           H  
ATOM   1703  HB2 CYS A 107      -2.807  -1.570  -3.902  1.00  0.00           H  
ATOM   1704  HB3 CYS A 107      -4.500  -2.049  -3.924  1.00  0.00           H  
ATOM   1705  HG  CYS A 107      -1.729  -3.974  -3.847  1.00  0.00           H  
ATOM   1706  N   ARG A 108      -3.693   0.452  -5.829  1.00  0.00           N  
ATOM   1707  CA  ARG A 108      -4.303   1.761  -6.038  1.00  0.00           C  
ATOM   1708  C   ARG A 108      -4.712   1.944  -7.497  1.00  0.00           C  
ATOM   1709  O   ARG A 108      -5.823   2.387  -7.790  1.00  0.00           O  
ATOM   1710  CB  ARG A 108      -3.335   2.870  -5.624  1.00  0.00           C  
ATOM   1711  CG  ARG A 108      -3.246   3.071  -4.120  1.00  0.00           C  
ATOM   1712  CD  ARG A 108      -1.939   3.739  -3.724  1.00  0.00           C  
ATOM   1713  NE  ARG A 108      -1.864   5.120  -4.196  1.00  0.00           N  
ATOM   1714  CZ  ARG A 108      -2.549   6.120  -3.653  1.00  0.00           C  
ATOM   1715  NH1 ARG A 108      -3.355   5.894  -2.625  1.00  0.00           N  
ATOM   1716  NH2 ARG A 108      -2.428   7.349  -4.138  1.00  0.00           N  
ATOM   1717  H   ARG A 108      -2.787   0.402  -5.461  1.00  0.00           H  
ATOM   1718  HA  ARG A 108      -5.187   1.816  -5.419  1.00  0.00           H  
ATOM   1719  HB2 ARG A 108      -2.349   2.627  -5.992  1.00  0.00           H  
ATOM   1720  HB3 ARG A 108      -3.658   3.798  -6.071  1.00  0.00           H  
ATOM   1721  HG2 ARG A 108      -4.068   3.696  -3.800  1.00  0.00           H  
ATOM   1722  HG3 ARG A 108      -3.311   2.109  -3.633  1.00  0.00           H  
ATOM   1723  HD2 ARG A 108      -1.857   3.732  -2.647  1.00  0.00           H  
ATOM   1724  HD3 ARG A 108      -1.120   3.178  -4.149  1.00  0.00           H  
ATOM   1725  HE  ARG A 108      -1.274   5.309  -4.954  1.00  0.00           H  
ATOM   1726 HH11 ARG A 108      -3.447   4.970  -2.256  1.00  0.00           H  
ATOM   1727 HH12 ARG A 108      -3.868   6.650  -2.216  1.00  0.00           H  
ATOM   1728 HH21 ARG A 108      -1.821   7.522  -4.913  1.00  0.00           H  
ATOM   1729 HH22 ARG A 108      -2.944   8.101  -3.729  1.00  0.00           H  
ATOM   1730  N   LEU A 109      -3.806   1.601  -8.406  1.00  0.00           N  
ATOM   1731  CA  LEU A 109      -4.071   1.729  -9.834  1.00  0.00           C  
ATOM   1732  C   LEU A 109      -5.309   0.931 -10.232  1.00  0.00           C  
ATOM   1733  O   LEU A 109      -6.094   1.365 -11.075  1.00  0.00           O  
ATOM   1734  CB  LEU A 109      -2.862   1.251 -10.642  1.00  0.00           C  
ATOM   1735  CG  LEU A 109      -1.624   2.147 -10.591  1.00  0.00           C  
ATOM   1736  CD1 LEU A 109      -0.363   1.328 -10.817  1.00  0.00           C  
ATOM   1737  CD2 LEU A 109      -1.730   3.262 -11.620  1.00  0.00           C  
ATOM   1738  H   LEU A 109      -2.938   1.254  -8.111  1.00  0.00           H  
ATOM   1739  HA  LEU A 109      -4.246   2.772 -10.048  1.00  0.00           H  
ATOM   1740  HB2 LEU A 109      -2.581   0.277 -10.272  1.00  0.00           H  
ATOM   1741  HB3 LEU A 109      -3.168   1.167 -11.675  1.00  0.00           H  
ATOM   1742  HG  LEU A 109      -1.556   2.600  -9.612  1.00  0.00           H  
ATOM   1743 HD11 LEU A 109       0.408   1.658 -10.136  1.00  0.00           H  
ATOM   1744 HD12 LEU A 109      -0.025   1.461 -11.834  1.00  0.00           H  
ATOM   1745 HD13 LEU A 109      -0.576   0.284 -10.642  1.00  0.00           H  
ATOM   1746 HD21 LEU A 109      -1.234   4.146 -11.247  1.00  0.00           H  
ATOM   1747 HD22 LEU A 109      -2.771   3.484 -11.804  1.00  0.00           H  
ATOM   1748 HD23 LEU A 109      -1.260   2.948 -12.542  1.00  0.00           H  
ATOM   1749  N   ALA A 110      -5.478  -0.234  -9.618  1.00  0.00           N  
ATOM   1750  CA  ALA A 110      -6.623  -1.090  -9.904  1.00  0.00           C  
ATOM   1751  C   ALA A 110      -7.899  -0.521  -9.292  1.00  0.00           C  
ATOM   1752  O   ALA A 110      -8.969  -0.575  -9.901  1.00  0.00           O  
ATOM   1753  CB  ALA A 110      -6.371  -2.500  -9.389  1.00  0.00           C  
ATOM   1754  H   ALA A 110      -4.818  -0.526  -8.954  1.00  0.00           H  
ATOM   1755  HA  ALA A 110      -6.742  -1.140 -10.976  1.00  0.00           H  
ATOM   1756  HB1 ALA A 110      -5.751  -2.454  -8.507  1.00  0.00           H  
ATOM   1757  HB2 ALA A 110      -7.314  -2.966  -9.144  1.00  0.00           H  
ATOM   1758  HB3 ALA A 110      -5.870  -3.077 -10.152  1.00  0.00           H  
ATOM   1759  N   SER A 111      -7.781   0.021  -8.085  1.00  0.00           N  
ATOM   1760  CA  SER A 111      -8.927   0.596  -7.389  1.00  0.00           C  
ATOM   1761  C   SER A 111      -9.548   1.725  -8.205  1.00  0.00           C  
ATOM   1762  O   SER A 111     -10.770   1.853  -8.279  1.00  0.00           O  
ATOM   1763  CB  SER A 111      -8.505   1.117  -6.013  1.00  0.00           C  
ATOM   1764  OG  SER A 111      -9.542   1.876  -5.417  1.00  0.00           O  
ATOM   1765  H   SER A 111      -6.902   0.034  -7.651  1.00  0.00           H  
ATOM   1766  HA  SER A 111      -9.661  -0.185  -7.259  1.00  0.00           H  
ATOM   1767  HB2 SER A 111      -8.272   0.282  -5.371  1.00  0.00           H  
ATOM   1768  HB3 SER A 111      -7.631   1.744  -6.121  1.00  0.00           H  
ATOM   1769  HG  SER A 111      -9.305   2.807  -5.431  1.00  0.00           H  
ATOM   1770  N   LYS A 112      -8.697   2.541  -8.816  1.00  0.00           N  
ATOM   1771  CA  LYS A 112      -9.159   3.661  -9.629  1.00  0.00           C  
ATOM   1772  C   LYS A 112      -9.474   3.207 -11.051  1.00  0.00           C  
ATOM   1773  O   LYS A 112      -9.726   4.027 -11.932  1.00  0.00           O  
ATOM   1774  CB  LYS A 112      -8.104   4.768  -9.657  1.00  0.00           C  
ATOM   1775  CG  LYS A 112      -7.674   5.234  -8.277  1.00  0.00           C  
ATOM   1776  CD  LYS A 112      -8.591   6.324  -7.747  1.00  0.00           C  
ATOM   1777  CE  LYS A 112      -8.021   6.970  -6.493  1.00  0.00           C  
ATOM   1778  NZ  LYS A 112      -8.536   8.354  -6.299  1.00  0.00           N  
ATOM   1779  H   LYS A 112      -7.733   2.388  -8.719  1.00  0.00           H  
ATOM   1780  HA  LYS A 112     -10.061   4.047  -9.179  1.00  0.00           H  
ATOM   1781  HB2 LYS A 112      -7.231   4.404 -10.179  1.00  0.00           H  
ATOM   1782  HB3 LYS A 112      -8.504   5.617 -10.193  1.00  0.00           H  
ATOM   1783  HG2 LYS A 112      -7.700   4.395  -7.598  1.00  0.00           H  
ATOM   1784  HG3 LYS A 112      -6.667   5.622  -8.335  1.00  0.00           H  
ATOM   1785  HD2 LYS A 112      -8.711   7.083  -8.505  1.00  0.00           H  
ATOM   1786  HD3 LYS A 112      -9.553   5.891  -7.512  1.00  0.00           H  
ATOM   1787  HE2 LYS A 112      -8.295   6.370  -5.639  1.00  0.00           H  
ATOM   1788  HE3 LYS A 112      -6.945   7.004  -6.578  1.00  0.00           H  
ATOM   1789  HZ1 LYS A 112      -8.836   8.488  -5.311  1.00  0.00           H  
ATOM   1790  HZ2 LYS A 112      -9.351   8.522  -6.923  1.00  0.00           H  
ATOM   1791  HZ3 LYS A 112      -7.794   9.046  -6.522  1.00  0.00           H  
ATOM   1792  N   GLY A 113      -9.459   1.895 -11.265  1.00  0.00           N  
ATOM   1793  CA  GLY A 113      -9.745   1.356 -12.581  1.00  0.00           C  
ATOM   1794  C   GLY A 113      -8.493   1.155 -13.412  1.00  0.00           C  
ATOM   1795  O   GLY A 113      -8.426   0.242 -14.235  1.00  0.00           O  
ATOM   1796  H   GLY A 113      -9.252   1.288 -10.524  1.00  0.00           H  
ATOM   1797  HA2 GLY A 113     -10.246   0.406 -12.468  1.00  0.00           H  
ATOM   1798  HA3 GLY A 113     -10.402   2.037 -13.102  1.00  0.00           H  
ATOM   1799  N   ARG A 114      -7.499   2.010 -13.195  1.00  0.00           N  
ATOM   1800  CA  ARG A 114      -6.244   1.923 -13.932  1.00  0.00           C  
ATOM   1801  C   ARG A 114      -5.606   0.547 -13.759  1.00  0.00           C  
ATOM   1802  O   ARG A 114      -6.092  -0.283 -12.991  1.00  0.00           O  
ATOM   1803  CB  ARG A 114      -5.275   3.009 -13.459  1.00  0.00           C  
ATOM   1804  CG  ARG A 114      -5.754   4.421 -13.752  1.00  0.00           C  
ATOM   1805  CD  ARG A 114      -4.956   5.453 -12.971  1.00  0.00           C  
ATOM   1806  NE  ARG A 114      -5.119   6.799 -13.514  1.00  0.00           N  
ATOM   1807  CZ  ARG A 114      -4.408   7.845 -13.112  1.00  0.00           C  
ATOM   1808  NH1 ARG A 114      -3.488   7.703 -12.168  1.00  0.00           N  
ATOM   1809  NH2 ARG A 114      -4.614   9.038 -13.655  1.00  0.00           N  
ATOM   1810  H   ARG A 114      -7.612   2.715 -12.526  1.00  0.00           H  
ATOM   1811  HA  ARG A 114      -6.461   2.077 -14.978  1.00  0.00           H  
ATOM   1812  HB2 ARG A 114      -5.137   2.913 -12.392  1.00  0.00           H  
ATOM   1813  HB3 ARG A 114      -4.325   2.865 -13.952  1.00  0.00           H  
ATOM   1814  HG2 ARG A 114      -5.640   4.619 -14.807  1.00  0.00           H  
ATOM   1815  HG3 ARG A 114      -6.795   4.503 -13.478  1.00  0.00           H  
ATOM   1816  HD2 ARG A 114      -5.291   5.447 -11.944  1.00  0.00           H  
ATOM   1817  HD3 ARG A 114      -3.910   5.184 -13.009  1.00  0.00           H  
ATOM   1818  HE  ARG A 114      -5.793   6.927 -14.213  1.00  0.00           H  
ATOM   1819 HH11 ARG A 114      -3.329   6.805 -11.757  1.00  0.00           H  
ATOM   1820 HH12 ARG A 114      -2.953   8.493 -11.867  1.00  0.00           H  
ATOM   1821 HH21 ARG A 114      -5.306   9.150 -14.368  1.00  0.00           H  
ATOM   1822 HH22 ARG A 114      -4.079   9.826 -13.352  1.00  0.00           H  
ATOM   1823  N   THR A 115      -4.515   0.312 -14.482  1.00  0.00           N  
ATOM   1824  CA  THR A 115      -3.812  -0.962 -14.411  1.00  0.00           C  
ATOM   1825  C   THR A 115      -2.302  -0.761 -14.473  1.00  0.00           C  
ATOM   1826  O   THR A 115      -1.822   0.257 -14.970  1.00  0.00           O  
ATOM   1827  CB  THR A 115      -4.240  -1.905 -15.551  1.00  0.00           C  
ATOM   1828  OG1 THR A 115      -3.678  -1.459 -16.792  1.00  0.00           O  
ATOM   1829  CG2 THR A 115      -5.755  -1.961 -15.667  1.00  0.00           C  
ATOM   1830  H   THR A 115      -4.176   1.013 -15.077  1.00  0.00           H  
ATOM   1831  HA  THR A 115      -4.064  -1.431 -13.471  1.00  0.00           H  
ATOM   1832  HB  THR A 115      -3.873  -2.898 -15.335  1.00  0.00           H  
ATOM   1833  HG1 THR A 115      -4.185  -1.824 -17.522  1.00  0.00           H  
ATOM   1834 HG21 THR A 115      -6.140  -0.966 -15.830  1.00  0.00           H  
ATOM   1835 HG22 THR A 115      -6.171  -2.363 -14.754  1.00  0.00           H  
ATOM   1836 HG23 THR A 115      -6.030  -2.594 -16.498  1.00  0.00           H  
ATOM   1837  N   MET A 116      -1.558  -1.739 -13.965  1.00  0.00           N  
ATOM   1838  CA  MET A 116      -0.101  -1.669 -13.964  1.00  0.00           C  
ATOM   1839  C   MET A 116       0.430  -1.401 -15.369  1.00  0.00           C  
ATOM   1840  O   MET A 116       1.454  -0.741 -15.539  1.00  0.00           O  
ATOM   1841  CB  MET A 116       0.493  -2.969 -13.421  1.00  0.00           C  
ATOM   1842  CG  MET A 116       1.823  -2.780 -12.710  1.00  0.00           C  
ATOM   1843  SD  MET A 116       2.282  -4.204 -11.704  1.00  0.00           S  
ATOM   1844  CE  MET A 116       1.481  -5.528 -12.606  1.00  0.00           C  
ATOM   1845  H   MET A 116      -1.999  -2.526 -13.582  1.00  0.00           H  
ATOM   1846  HA  MET A 116       0.191  -0.853 -13.320  1.00  0.00           H  
ATOM   1847  HB2 MET A 116      -0.206  -3.406 -12.723  1.00  0.00           H  
ATOM   1848  HB3 MET A 116       0.644  -3.654 -14.243  1.00  0.00           H  
ATOM   1849  HG2 MET A 116       2.592  -2.618 -13.450  1.00  0.00           H  
ATOM   1850  HG3 MET A 116       1.752  -1.912 -12.071  1.00  0.00           H  
ATOM   1851  HE1 MET A 116       1.962  -6.467 -12.368  1.00  0.00           H  
ATOM   1852  HE2 MET A 116       0.439  -5.577 -12.326  1.00  0.00           H  
ATOM   1853  HE3 MET A 116       1.561  -5.341 -13.666  1.00  0.00           H  
ATOM   1854  N   ALA A 117      -0.272  -1.918 -16.371  1.00  0.00           N  
ATOM   1855  CA  ALA A 117       0.129  -1.733 -17.761  1.00  0.00           C  
ATOM   1856  C   ALA A 117       0.434  -0.267 -18.053  1.00  0.00           C  
ATOM   1857  O   ALA A 117       1.340   0.045 -18.825  1.00  0.00           O  
ATOM   1858  CB  ALA A 117      -0.957  -2.244 -18.696  1.00  0.00           C  
ATOM   1859  H   ALA A 117      -1.080  -2.435 -16.172  1.00  0.00           H  
ATOM   1860  HA  ALA A 117       1.021  -2.317 -17.931  1.00  0.00           H  
ATOM   1861  HB1 ALA A 117      -1.083  -3.307 -18.553  1.00  0.00           H  
ATOM   1862  HB2 ALA A 117      -1.887  -1.739 -18.478  1.00  0.00           H  
ATOM   1863  HB3 ALA A 117      -0.672  -2.049 -19.719  1.00  0.00           H  
ATOM   1864  N   ASP A 118      -0.329   0.627 -17.433  1.00  0.00           N  
ATOM   1865  CA  ASP A 118      -0.139   2.059 -17.627  1.00  0.00           C  
ATOM   1866  C   ASP A 118       1.215   2.506 -17.084  1.00  0.00           C  
ATOM   1867  O   ASP A 118       1.788   1.859 -16.208  1.00  0.00           O  
ATOM   1868  CB  ASP A 118      -1.261   2.840 -16.940  1.00  0.00           C  
ATOM   1869  CG  ASP A 118      -1.418   4.240 -17.502  1.00  0.00           C  
ATOM   1870  OD1 ASP A 118      -0.712   5.153 -17.025  1.00  0.00           O  
ATOM   1871  OD2 ASP A 118      -2.248   4.424 -18.416  1.00  0.00           O  
ATOM   1872  H   ASP A 118      -1.036   0.315 -16.829  1.00  0.00           H  
ATOM   1873  HA  ASP A 118      -0.171   2.257 -18.687  1.00  0.00           H  
ATOM   1874  HB2 ASP A 118      -2.194   2.312 -17.074  1.00  0.00           H  
ATOM   1875  HB3 ASP A 118      -1.045   2.917 -15.885  1.00  0.00           H  
ATOM   1876  N   SER A 119       1.720   3.616 -17.612  1.00  0.00           N  
ATOM   1877  CA  SER A 119       3.009   4.148 -17.185  1.00  0.00           C  
ATOM   1878  C   SER A 119       2.928   4.693 -15.762  1.00  0.00           C  
ATOM   1879  O   SER A 119       3.859   4.540 -14.972  1.00  0.00           O  
ATOM   1880  CB  SER A 119       3.473   5.250 -18.139  1.00  0.00           C  
ATOM   1881  OG  SER A 119       4.113   4.701 -19.279  1.00  0.00           O  
ATOM   1882  H   SER A 119       1.216   4.087 -18.308  1.00  0.00           H  
ATOM   1883  HA  SER A 119       3.725   3.340 -17.207  1.00  0.00           H  
ATOM   1884  HB2 SER A 119       2.618   5.824 -18.464  1.00  0.00           H  
ATOM   1885  HB3 SER A 119       4.169   5.897 -17.627  1.00  0.00           H  
ATOM   1886  HG  SER A 119       4.644   5.378 -19.705  1.00  0.00           H  
ATOM   1887  N   SER A 120       1.805   5.330 -15.443  1.00  0.00           N  
ATOM   1888  CA  SER A 120       1.602   5.902 -14.117  1.00  0.00           C  
ATOM   1889  C   SER A 120       2.109   4.956 -13.033  1.00  0.00           C  
ATOM   1890  O   SER A 120       2.610   5.392 -11.997  1.00  0.00           O  
ATOM   1891  CB  SER A 120       0.119   6.205 -13.892  1.00  0.00           C  
ATOM   1892  OG  SER A 120      -0.283   7.351 -14.622  1.00  0.00           O  
ATOM   1893  H   SER A 120       1.098   5.419 -16.117  1.00  0.00           H  
ATOM   1894  HA  SER A 120       2.162   6.824 -14.064  1.00  0.00           H  
ATOM   1895  HB2 SER A 120      -0.472   5.361 -14.214  1.00  0.00           H  
ATOM   1896  HB3 SER A 120      -0.053   6.384 -12.840  1.00  0.00           H  
ATOM   1897  HG  SER A 120      -0.085   7.223 -15.553  1.00  0.00           H  
ATOM   1898  N   TYR A 121       1.976   3.657 -13.280  1.00  0.00           N  
ATOM   1899  CA  TYR A 121       2.418   2.648 -12.325  1.00  0.00           C  
ATOM   1900  C   TYR A 121       3.728   3.061 -11.664  1.00  0.00           C  
ATOM   1901  O   TYR A 121       3.788   3.268 -10.451  1.00  0.00           O  
ATOM   1902  CB  TYR A 121       2.589   1.297 -13.022  1.00  0.00           C  
ATOM   1903  CG  TYR A 121       3.431   0.314 -12.240  1.00  0.00           C  
ATOM   1904  CD1 TYR A 121       2.986  -0.201 -11.028  1.00  0.00           C  
ATOM   1905  CD2 TYR A 121       4.670  -0.100 -12.713  1.00  0.00           C  
ATOM   1906  CE1 TYR A 121       3.751  -1.098 -10.310  1.00  0.00           C  
ATOM   1907  CE2 TYR A 121       5.442  -0.998 -12.001  1.00  0.00           C  
ATOM   1908  CZ  TYR A 121       4.979  -1.494 -10.800  1.00  0.00           C  
ATOM   1909  OH  TYR A 121       5.744  -2.389 -10.088  1.00  0.00           O  
ATOM   1910  H   TYR A 121       1.569   3.370 -14.124  1.00  0.00           H  
ATOM   1911  HA  TYR A 121       1.657   2.555 -11.565  1.00  0.00           H  
ATOM   1912  HB2 TYR A 121       1.618   0.852 -13.176  1.00  0.00           H  
ATOM   1913  HB3 TYR A 121       3.065   1.452 -13.980  1.00  0.00           H  
ATOM   1914  HD1 TYR A 121       2.024   0.111 -10.648  1.00  0.00           H  
ATOM   1915  HD2 TYR A 121       5.030   0.290 -13.653  1.00  0.00           H  
ATOM   1916  HE1 TYR A 121       3.389  -1.487  -9.370  1.00  0.00           H  
ATOM   1917  HE2 TYR A 121       6.403  -1.308 -12.384  1.00  0.00           H  
ATOM   1918  HH  TYR A 121       5.863  -3.190 -10.604  1.00  0.00           H  
ATOM   1919  N   THR A 122       4.779   3.180 -12.469  1.00  0.00           N  
ATOM   1920  CA  THR A 122       6.090   3.569 -11.964  1.00  0.00           C  
ATOM   1921  C   THR A 122       6.037   4.935 -11.291  1.00  0.00           C  
ATOM   1922  O   THR A 122       6.776   5.200 -10.343  1.00  0.00           O  
ATOM   1923  CB  THR A 122       7.138   3.605 -13.092  1.00  0.00           C  
ATOM   1924  OG1 THR A 122       8.458   3.569 -12.536  1.00  0.00           O  
ATOM   1925  CG2 THR A 122       6.976   4.856 -13.942  1.00  0.00           C  
ATOM   1926  H   THR A 122       4.669   3.001 -13.427  1.00  0.00           H  
ATOM   1927  HA  THR A 122       6.399   2.831 -11.237  1.00  0.00           H  
ATOM   1928  HB  THR A 122       6.998   2.738 -13.722  1.00  0.00           H  
ATOM   1929  HG1 THR A 122       8.626   4.384 -12.057  1.00  0.00           H  
ATOM   1930 HG21 THR A 122       5.941   5.160 -13.938  1.00  0.00           H  
ATOM   1931 HG22 THR A 122       7.284   4.645 -14.955  1.00  0.00           H  
ATOM   1932 HG23 THR A 122       7.587   5.649 -13.537  1.00  0.00           H  
ATOM   1933  N   SER A 123       5.158   5.800 -11.786  1.00  0.00           N  
ATOM   1934  CA  SER A 123       5.011   7.142 -11.233  1.00  0.00           C  
ATOM   1935  C   SER A 123       4.645   7.083  -9.753  1.00  0.00           C  
ATOM   1936  O   SER A 123       4.904   8.022  -9.002  1.00  0.00           O  
ATOM   1937  CB  SER A 123       3.940   7.919 -12.004  1.00  0.00           C  
ATOM   1938  OG  SER A 123       4.128   9.317 -11.866  1.00  0.00           O  
ATOM   1939  H   SER A 123       4.596   5.530 -12.543  1.00  0.00           H  
ATOM   1940  HA  SER A 123       5.957   7.649 -11.339  1.00  0.00           H  
ATOM   1941  HB2 SER A 123       3.995   7.661 -13.050  1.00  0.00           H  
ATOM   1942  HB3 SER A 123       2.964   7.659 -11.619  1.00  0.00           H  
ATOM   1943  HG  SER A 123       5.061   9.525 -11.959  1.00  0.00           H  
ATOM   1944  N   GLU A 124       4.043   5.971  -9.342  1.00  0.00           N  
ATOM   1945  CA  GLU A 124       3.641   5.789  -7.953  1.00  0.00           C  
ATOM   1946  C   GLU A 124       4.786   5.210  -7.127  1.00  0.00           C  
ATOM   1947  O   GLU A 124       5.086   5.693  -6.035  1.00  0.00           O  
ATOM   1948  CB  GLU A 124       2.420   4.871  -7.867  1.00  0.00           C  
ATOM   1949  CG  GLU A 124       1.105   5.582  -8.134  1.00  0.00           C  
ATOM   1950  CD  GLU A 124       0.532   6.236  -6.890  1.00  0.00           C  
ATOM   1951  OE1 GLU A 124       0.926   5.838  -5.775  1.00  0.00           O  
ATOM   1952  OE2 GLU A 124      -0.310   7.148  -7.035  1.00  0.00           O  
ATOM   1953  H   GLU A 124       3.864   5.258  -9.990  1.00  0.00           H  
ATOM   1954  HA  GLU A 124       3.381   6.757  -7.554  1.00  0.00           H  
ATOM   1955  HB2 GLU A 124       2.530   4.077  -8.591  1.00  0.00           H  
ATOM   1956  HB3 GLU A 124       2.378   4.440  -6.878  1.00  0.00           H  
ATOM   1957  HG2 GLU A 124       1.267   6.344  -8.880  1.00  0.00           H  
ATOM   1958  HG3 GLU A 124       0.389   4.863  -8.505  1.00  0.00           H  
ATOM   1959  N   VAL A 125       5.422   4.169  -7.657  1.00  0.00           N  
ATOM   1960  CA  VAL A 125       6.535   3.523  -6.970  1.00  0.00           C  
ATOM   1961  C   VAL A 125       7.595   4.540  -6.563  1.00  0.00           C  
ATOM   1962  O   VAL A 125       8.149   4.467  -5.467  1.00  0.00           O  
ATOM   1963  CB  VAL A 125       7.187   2.443  -7.853  1.00  0.00           C  
ATOM   1964  CG1 VAL A 125       8.367   1.807  -7.134  1.00  0.00           C  
ATOM   1965  CG2 VAL A 125       6.164   1.389  -8.251  1.00  0.00           C  
ATOM   1966  H   VAL A 125       5.137   3.829  -8.531  1.00  0.00           H  
ATOM   1967  HA  VAL A 125       6.147   3.045  -6.082  1.00  0.00           H  
ATOM   1968  HB  VAL A 125       7.555   2.915  -8.752  1.00  0.00           H  
ATOM   1969 HG11 VAL A 125       8.896   1.158  -7.817  1.00  0.00           H  
ATOM   1970 HG12 VAL A 125       9.033   2.580  -6.780  1.00  0.00           H  
ATOM   1971 HG13 VAL A 125       8.008   1.229  -6.295  1.00  0.00           H  
ATOM   1972 HG21 VAL A 125       5.242   1.564  -7.717  1.00  0.00           H  
ATOM   1973 HG22 VAL A 125       5.982   1.449  -9.313  1.00  0.00           H  
ATOM   1974 HG23 VAL A 125       6.542   0.408  -8.004  1.00  0.00           H  
ATOM   1975  N   GLN A 126       7.870   5.488  -7.452  1.00  0.00           N  
ATOM   1976  CA  GLN A 126       8.865   6.520  -7.185  1.00  0.00           C  
ATOM   1977  C   GLN A 126       8.383   7.469  -6.093  1.00  0.00           C  
ATOM   1978  O   GLN A 126       8.967   7.532  -5.011  1.00  0.00           O  
ATOM   1979  CB  GLN A 126       9.170   7.306  -8.461  1.00  0.00           C  
ATOM   1980  CG  GLN A 126       9.451   6.424  -9.666  1.00  0.00           C  
ATOM   1981  CD  GLN A 126      10.913   6.037  -9.780  1.00  0.00           C  
ATOM   1982  OE1 GLN A 126      11.798   6.786  -9.365  1.00  0.00           O  
ATOM   1983  NE2 GLN A 126      11.174   4.864 -10.344  1.00  0.00           N  
ATOM   1984  H   GLN A 126       7.394   5.493  -8.308  1.00  0.00           H  
ATOM   1985  HA  GLN A 126       9.767   6.032  -6.849  1.00  0.00           H  
ATOM   1986  HB2 GLN A 126       8.326   7.937  -8.692  1.00  0.00           H  
ATOM   1987  HB3 GLN A 126      10.037   7.927  -8.288  1.00  0.00           H  
ATOM   1988  HG2 GLN A 126       8.863   5.522  -9.582  1.00  0.00           H  
ATOM   1989  HG3 GLN A 126       9.164   6.956 -10.561  1.00  0.00           H  
ATOM   1990 HE21 GLN A 126      10.418   4.321 -10.652  1.00  0.00           H  
ATOM   1991 HE22 GLN A 126      12.110   4.590 -10.430  1.00  0.00           H  
ATOM   1992  N   ALA A 127       7.317   8.206  -6.383  1.00  0.00           N  
ATOM   1993  CA  ALA A 127       6.756   9.151  -5.425  1.00  0.00           C  
ATOM   1994  C   ALA A 127       6.781   8.579  -4.011  1.00  0.00           C  
ATOM   1995  O   ALA A 127       7.074   9.290  -3.049  1.00  0.00           O  
ATOM   1996  CB  ALA A 127       5.335   9.523  -5.820  1.00  0.00           C  
ATOM   1997  H   ALA A 127       6.895   8.111  -7.263  1.00  0.00           H  
ATOM   1998  HA  ALA A 127       7.358  10.048  -5.450  1.00  0.00           H  
ATOM   1999  HB1 ALA A 127       5.113   9.113  -6.794  1.00  0.00           H  
ATOM   2000  HB2 ALA A 127       4.643   9.122  -5.094  1.00  0.00           H  
ATOM   2001  HB3 ALA A 127       5.241  10.598  -5.852  1.00  0.00           H  
ATOM   2002  N   ILE A 128       6.473   7.292  -3.894  1.00  0.00           N  
ATOM   2003  CA  ILE A 128       6.462   6.625  -2.597  1.00  0.00           C  
ATOM   2004  C   ILE A 128       7.867   6.530  -2.016  1.00  0.00           C  
ATOM   2005  O   ILE A 128       8.171   7.144  -0.992  1.00  0.00           O  
ATOM   2006  CB  ILE A 128       5.862   5.211  -2.698  1.00  0.00           C  
ATOM   2007  CG1 ILE A 128       4.429   5.277  -3.230  1.00  0.00           C  
ATOM   2008  CG2 ILE A 128       5.898   4.523  -1.341  1.00  0.00           C  
ATOM   2009  CD1 ILE A 128       3.963   3.989  -3.874  1.00  0.00           C  
ATOM   2010  H   ILE A 128       6.250   6.778  -4.697  1.00  0.00           H  
ATOM   2011  HA  ILE A 128       5.845   7.209  -1.928  1.00  0.00           H  
ATOM   2012  HB  ILE A 128       6.466   4.635  -3.381  1.00  0.00           H  
ATOM   2013 HG12 ILE A 128       3.759   5.500  -2.414  1.00  0.00           H  
ATOM   2014 HG13 ILE A 128       4.363   6.062  -3.969  1.00  0.00           H  
ATOM   2015 HG21 ILE A 128       6.777   4.840  -0.800  1.00  0.00           H  
ATOM   2016 HG22 ILE A 128       5.015   4.789  -0.778  1.00  0.00           H  
ATOM   2017 HG23 ILE A 128       5.927   3.452  -1.479  1.00  0.00           H  
ATOM   2018 HD11 ILE A 128       3.970   4.102  -4.947  1.00  0.00           H  
ATOM   2019 HD12 ILE A 128       4.627   3.185  -3.592  1.00  0.00           H  
ATOM   2020 HD13 ILE A 128       2.962   3.762  -3.542  1.00  0.00           H  
ATOM   2021  N   LEU A 129       8.723   5.756  -2.674  1.00  0.00           N  
ATOM   2022  CA  LEU A 129      10.099   5.580  -2.225  1.00  0.00           C  
ATOM   2023  C   LEU A 129      10.638   6.867  -1.606  1.00  0.00           C  
ATOM   2024  O   LEU A 129      11.254   6.844  -0.541  1.00  0.00           O  
ATOM   2025  CB  LEU A 129      10.988   5.151  -3.393  1.00  0.00           C  
ATOM   2026  CG  LEU A 129      10.967   3.663  -3.741  1.00  0.00           C  
ATOM   2027  CD1 LEU A 129      11.705   3.409  -5.046  1.00  0.00           C  
ATOM   2028  CD2 LEU A 129      11.577   2.842  -2.614  1.00  0.00           C  
ATOM   2029  H   LEU A 129       8.423   5.292  -3.483  1.00  0.00           H  
ATOM   2030  HA  LEU A 129      10.106   4.804  -1.474  1.00  0.00           H  
ATOM   2031  HB2 LEU A 129      10.673   5.700  -4.267  1.00  0.00           H  
ATOM   2032  HB3 LEU A 129      12.007   5.420  -3.149  1.00  0.00           H  
ATOM   2033  HG  LEU A 129       9.941   3.344  -3.870  1.00  0.00           H  
ATOM   2034 HD11 LEU A 129      11.736   2.348  -5.242  1.00  0.00           H  
ATOM   2035 HD12 LEU A 129      12.711   3.791  -4.971  1.00  0.00           H  
ATOM   2036 HD13 LEU A 129      11.189   3.910  -5.854  1.00  0.00           H  
ATOM   2037 HD21 LEU A 129      12.589   2.572  -2.873  1.00  0.00           H  
ATOM   2038 HD22 LEU A 129      10.992   1.947  -2.463  1.00  0.00           H  
ATOM   2039 HD23 LEU A 129      11.581   3.427  -1.705  1.00  0.00           H  
ATOM   2040  N   ALA A 130      10.400   7.986  -2.281  1.00  0.00           N  
ATOM   2041  CA  ALA A 130      10.858   9.282  -1.796  1.00  0.00           C  
ATOM   2042  C   ALA A 130      10.038   9.740  -0.595  1.00  0.00           C  
ATOM   2043  O   ALA A 130      10.584  10.006   0.476  1.00  0.00           O  
ATOM   2044  CB  ALA A 130      10.788  10.317  -2.909  1.00  0.00           C  
ATOM   2045  H   ALA A 130       9.905   7.940  -3.125  1.00  0.00           H  
ATOM   2046  HA  ALA A 130      11.891   9.181  -1.496  1.00  0.00           H  
ATOM   2047  HB1 ALA A 130      10.470  11.264  -2.501  1.00  0.00           H  
ATOM   2048  HB2 ALA A 130      11.765  10.428  -3.359  1.00  0.00           H  
ATOM   2049  HB3 ALA A 130      10.082   9.992  -3.659  1.00  0.00           H  
ATOM   2050  N   PHE A 131       8.726   9.829  -0.779  1.00  0.00           N  
ATOM   2051  CA  PHE A 131       7.830  10.256   0.290  1.00  0.00           C  
ATOM   2052  C   PHE A 131       8.262   9.666   1.629  1.00  0.00           C  
ATOM   2053  O   PHE A 131       8.405  10.385   2.619  1.00  0.00           O  
ATOM   2054  CB  PHE A 131       6.391   9.839  -0.024  1.00  0.00           C  
ATOM   2055  CG  PHE A 131       5.442  10.054   1.120  1.00  0.00           C  
ATOM   2056  CD1 PHE A 131       5.103  11.335   1.525  1.00  0.00           C  
ATOM   2057  CD2 PHE A 131       4.889   8.975   1.791  1.00  0.00           C  
ATOM   2058  CE1 PHE A 131       4.230  11.537   2.576  1.00  0.00           C  
ATOM   2059  CE2 PHE A 131       4.015   9.170   2.843  1.00  0.00           C  
ATOM   2060  CZ  PHE A 131       3.685  10.453   3.237  1.00  0.00           C  
ATOM   2061  H   PHE A 131       8.349   9.603  -1.656  1.00  0.00           H  
ATOM   2062  HA  PHE A 131       7.878  11.332   0.351  1.00  0.00           H  
ATOM   2063  HB2 PHE A 131       6.032  10.413  -0.865  1.00  0.00           H  
ATOM   2064  HB3 PHE A 131       6.376   8.789  -0.277  1.00  0.00           H  
ATOM   2065  HD1 PHE A 131       5.529  12.185   1.008  1.00  0.00           H  
ATOM   2066  HD2 PHE A 131       5.146   7.972   1.484  1.00  0.00           H  
ATOM   2067  HE1 PHE A 131       3.975  12.541   2.882  1.00  0.00           H  
ATOM   2068  HE2 PHE A 131       3.590   8.322   3.358  1.00  0.00           H  
ATOM   2069  HZ  PHE A 131       3.003  10.609   4.059  1.00  0.00           H  
ATOM   2070  N   LEU A 132       8.468   8.354   1.652  1.00  0.00           N  
ATOM   2071  CA  LEU A 132       8.884   7.666   2.869  1.00  0.00           C  
ATOM   2072  C   LEU A 132      10.106   8.339   3.484  1.00  0.00           C  
ATOM   2073  O   LEU A 132      10.127   8.641   4.677  1.00  0.00           O  
ATOM   2074  CB  LEU A 132       9.191   6.198   2.569  1.00  0.00           C  
ATOM   2075  CG  LEU A 132       8.066   5.398   1.912  1.00  0.00           C  
ATOM   2076  CD1 LEU A 132       8.602   4.094   1.342  1.00  0.00           C  
ATOM   2077  CD2 LEU A 132       6.951   5.127   2.911  1.00  0.00           C  
ATOM   2078  H   LEU A 132       8.338   7.835   0.831  1.00  0.00           H  
ATOM   2079  HA  LEU A 132       8.067   7.719   3.574  1.00  0.00           H  
ATOM   2080  HB2 LEU A 132      10.046   6.167   1.912  1.00  0.00           H  
ATOM   2081  HB3 LEU A 132       9.440   5.716   3.504  1.00  0.00           H  
ATOM   2082  HG  LEU A 132       7.653   5.973   1.096  1.00  0.00           H  
ATOM   2083 HD11 LEU A 132       8.092   3.868   0.418  1.00  0.00           H  
ATOM   2084 HD12 LEU A 132       8.434   3.295   2.050  1.00  0.00           H  
ATOM   2085 HD13 LEU A 132       9.661   4.191   1.154  1.00  0.00           H  
ATOM   2086 HD21 LEU A 132       6.022   5.524   2.530  1.00  0.00           H  
ATOM   2087 HD22 LEU A 132       7.187   5.601   3.852  1.00  0.00           H  
ATOM   2088 HD23 LEU A 132       6.853   4.061   3.061  1.00  0.00           H  
ATOM   2089  N   SER A 133      11.124   8.571   2.661  1.00  0.00           N  
ATOM   2090  CA  SER A 133      12.352   9.207   3.124  1.00  0.00           C  
ATOM   2091  C   SER A 133      12.051  10.538   3.807  1.00  0.00           C  
ATOM   2092  O   SER A 133      12.634  10.863   4.843  1.00  0.00           O  
ATOM   2093  CB  SER A 133      13.310   9.428   1.953  1.00  0.00           C  
ATOM   2094  OG  SER A 133      14.648   9.557   2.404  1.00  0.00           O  
ATOM   2095  H   SER A 133      11.048   8.307   1.720  1.00  0.00           H  
ATOM   2096  HA  SER A 133      12.819   8.546   3.840  1.00  0.00           H  
ATOM   2097  HB2 SER A 133      13.251   8.587   1.278  1.00  0.00           H  
ATOM   2098  HB3 SER A 133      13.032  10.331   1.428  1.00  0.00           H  
ATOM   2099  HG  SER A 133      15.247   9.231   1.728  1.00  0.00           H  
ATOM   2100  N   LEU A 134      11.138  11.303   3.220  1.00  0.00           N  
ATOM   2101  CA  LEU A 134      10.757  12.599   3.772  1.00  0.00           C  
ATOM   2102  C   LEU A 134      10.183  12.446   5.176  1.00  0.00           C  
ATOM   2103  O   LEU A 134      10.552  13.182   6.091  1.00  0.00           O  
ATOM   2104  CB  LEU A 134       9.736  13.282   2.861  1.00  0.00           C  
ATOM   2105  CG  LEU A 134      10.096  13.348   1.377  1.00  0.00           C  
ATOM   2106  CD1 LEU A 134       8.915  13.849   0.562  1.00  0.00           C  
ATOM   2107  CD2 LEU A 134      11.312  14.239   1.162  1.00  0.00           C  
ATOM   2108  H   LEU A 134      10.708  10.990   2.398  1.00  0.00           H  
ATOM   2109  HA  LEU A 134      11.646  13.210   3.823  1.00  0.00           H  
ATOM   2110  HB2 LEU A 134       8.803  12.747   2.952  1.00  0.00           H  
ATOM   2111  HB3 LEU A 134       9.603  14.295   3.216  1.00  0.00           H  
ATOM   2112  HG  LEU A 134      10.343  12.354   1.029  1.00  0.00           H  
ATOM   2113 HD11 LEU A 134       8.840  13.279  -0.352  1.00  0.00           H  
ATOM   2114 HD12 LEU A 134       9.058  14.893   0.325  1.00  0.00           H  
ATOM   2115 HD13 LEU A 134       8.007  13.733   1.135  1.00  0.00           H  
ATOM   2116 HD21 LEU A 134      11.215  14.757   0.220  1.00  0.00           H  
ATOM   2117 HD22 LEU A 134      12.204  13.631   1.151  1.00  0.00           H  
ATOM   2118 HD23 LEU A 134      11.376  14.958   1.966  1.00  0.00           H  
ATOM   2119  N   GLN A 135       9.279  11.485   5.339  1.00  0.00           N  
ATOM   2120  CA  GLN A 135       8.655  11.236   6.633  1.00  0.00           C  
ATOM   2121  C   GLN A 135       9.691  11.267   7.752  1.00  0.00           C  
ATOM   2122  O   GLN A 135       9.467  11.870   8.801  1.00  0.00           O  
ATOM   2123  CB  GLN A 135       7.936   9.886   6.624  1.00  0.00           C  
ATOM   2124  CG  GLN A 135       6.918   9.745   5.505  1.00  0.00           C  
ATOM   2125  CD  GLN A 135       5.889   8.667   5.783  1.00  0.00           C  
ATOM   2126  OE1 GLN A 135       5.378   8.554   6.898  1.00  0.00           O  
ATOM   2127  NE2 GLN A 135       5.581   7.867   4.769  1.00  0.00           N  
ATOM   2128  H   GLN A 135       9.026  10.932   4.572  1.00  0.00           H  
ATOM   2129  HA  GLN A 135       7.931  12.017   6.808  1.00  0.00           H  
ATOM   2130  HB2 GLN A 135       8.670   9.102   6.515  1.00  0.00           H  
ATOM   2131  HB3 GLN A 135       7.423   9.758   7.567  1.00  0.00           H  
ATOM   2132  HG2 GLN A 135       6.405  10.688   5.382  1.00  0.00           H  
ATOM   2133  HG3 GLN A 135       7.438   9.500   4.591  1.00  0.00           H  
ATOM   2134 HE21 GLN A 135       6.029   8.016   3.910  1.00  0.00           H  
ATOM   2135 HE22 GLN A 135       4.919   7.161   4.921  1.00  0.00           H  
ATOM   2136  N   ARG A 136      10.824  10.612   7.521  1.00  0.00           N  
ATOM   2137  CA  ARG A 136      11.894  10.564   8.510  1.00  0.00           C  
ATOM   2138  C   ARG A 136      12.098  11.930   9.158  1.00  0.00           C  
ATOM   2139  O   ARG A 136      11.659  12.953   8.628  1.00  0.00           O  
ATOM   2140  CB  ARG A 136      13.197  10.096   7.861  1.00  0.00           C  
ATOM   2141  CG  ARG A 136      13.101   8.718   7.225  1.00  0.00           C  
ATOM   2142  CD  ARG A 136      14.420   8.301   6.596  1.00  0.00           C  
ATOM   2143  NE  ARG A 136      15.299   7.640   7.557  1.00  0.00           N  
ATOM   2144  CZ  ARG A 136      16.596   7.436   7.349  1.00  0.00           C  
ATOM   2145  NH1 ARG A 136      17.160   7.840   6.219  1.00  0.00           N  
ATOM   2146  NH2 ARG A 136      17.330   6.827   8.271  1.00  0.00           N  
ATOM   2147  H   ARG A 136      10.943  10.151   6.665  1.00  0.00           H  
ATOM   2148  HA  ARG A 136      11.608   9.857   9.274  1.00  0.00           H  
ATOM   2149  HB2 ARG A 136      13.479  10.803   7.094  1.00  0.00           H  
ATOM   2150  HB3 ARG A 136      13.970  10.066   8.614  1.00  0.00           H  
ATOM   2151  HG2 ARG A 136      12.833   7.999   7.985  1.00  0.00           H  
ATOM   2152  HG3 ARG A 136      12.338   8.738   6.460  1.00  0.00           H  
ATOM   2153  HD2 ARG A 136      14.217   7.621   5.783  1.00  0.00           H  
ATOM   2154  HD3 ARG A 136      14.916   9.181   6.214  1.00  0.00           H  
ATOM   2155  HE  ARG A 136      14.903   7.335   8.399  1.00  0.00           H  
ATOM   2156 HH11 ARG A 136      16.609   8.300   5.522  1.00  0.00           H  
ATOM   2157 HH12 ARG A 136      18.136   7.686   6.064  1.00  0.00           H  
ATOM   2158 HH21 ARG A 136      16.908   6.522   9.124  1.00  0.00           H  
ATOM   2159 HH22 ARG A 136      18.304   6.675   8.113  1.00  0.00           H  
ATOM   2160  N   THR A 137      12.767  11.941  10.307  1.00  0.00           N  
ATOM   2161  CA  THR A 137      13.027  13.181  11.028  1.00  0.00           C  
ATOM   2162  C   THR A 137      14.148  13.976  10.366  1.00  0.00           C  
ATOM   2163  O   THR A 137      15.262  13.480  10.203  1.00  0.00           O  
ATOM   2164  CB  THR A 137      13.405  12.909  12.496  1.00  0.00           C  
ATOM   2165  OG1 THR A 137      12.318  12.261  13.169  1.00  0.00           O  
ATOM   2166  CG2 THR A 137      13.754  14.203  13.214  1.00  0.00           C  
ATOM   2167  H   THR A 137      13.091  11.095  10.678  1.00  0.00           H  
ATOM   2168  HA  THR A 137      12.123  13.771  11.014  1.00  0.00           H  
ATOM   2169  HB  THR A 137      14.268  12.259  12.516  1.00  0.00           H  
ATOM   2170  HG1 THR A 137      11.675  12.919  13.445  1.00  0.00           H  
ATOM   2171 HG21 THR A 137      14.824  14.337  13.214  1.00  0.00           H  
ATOM   2172 HG22 THR A 137      13.397  14.158  14.233  1.00  0.00           H  
ATOM   2173 HG23 THR A 137      13.286  15.034  12.706  1.00  0.00           H  
TER    2174      THR A 137                                                      
END
MOLECULE T0482_7_107.pdb
EXPDTA     NMR, 20 STRUCTURES
ATOM     97  N   PRO A   7      -1.524  11.209   1.755  1.00  0.00           N 
ATOM     98  CA  PRO A   7      -0.374  10.698   2.544  1.00  0.00           C 
ATOM     99  C   PRO A   7      -0.850   9.805   3.722  1.00  0.00           C 
ATOM    100  O   PRO A   7      -1.278  10.304   4.769  1.00  0.00           O 
ATOM    101  CB  PRO A   7       0.357  11.990   3.010  1.00  0.00           C 
ATOM    102  CG  PRO A   7      -0.693  13.067   2.965  1.00  0.00           C 
ATOM    103  CD  PRO A   7      -1.639  12.691   1.839  1.00  0.00           C 
ATOM    104  HA  PRO A   7       0.295  10.112   1.912  1.00  0.00           H 
ATOM    105 2HB  PRO A   7       1.175  12.209   2.329  1.00  0.00           H 
ATOM    106 1HB  PRO A   7       0.755  11.857   4.011  1.00  0.00           H 
ATOM    107 2HG  PRO A   7      -0.229  14.028   2.770  1.00  0.00           H 
ATOM    108 1HG  PRO A   7      -1.226  13.101   3.913  1.00  0.00           H 
ATOM    109 2HD  PRO A   7      -1.329  13.151   0.907  1.00  0.00           H 
ATOM    110 1HD  PRO A   7      -2.654  12.988   2.079  1.00  0.00           H 
ATOM    111  N   GLY A   8      -0.828   8.476   3.495  1.00  0.00           N 
ATOM    112  CA  GLY A   8      -1.248   7.480   4.493  1.00  0.00           C 
ATOM    113  C   GLY A   8      -2.274   6.471   3.961  1.00  0.00           C 
ATOM    114  O   GLY A   8      -2.481   5.419   4.582  1.00  0.00           O 
ATOM    115  H   GLY A   8      -0.501   8.160   2.624  1.00  0.00           H 
ATOM    116 2HA  GLY A   8      -1.674   7.981   5.357  1.00  0.00           H 
ATOM    117 1HA  GLY A   8      -0.369   6.938   4.816  1.00  0.00           H 
ATOM    118  N   HIS A   9      -2.906   6.777   2.799  1.00  0.00           N 
ATOM    119  CA  HIS A   9      -4.036   5.976   2.252  1.00  0.00           C 
ATOM    120  C   HIS A   9      -4.258   6.233   0.734  1.00  0.00           C 
ATOM    121  O   HIS A   9      -3.912   7.285   0.219  1.00  0.00           O 
ATOM    122  CB  HIS A   9      -5.320   6.285   3.075  1.00  0.00           C 
ATOM    123  CG  HIS A   9      -6.600   5.708   2.529  1.00  0.00           C 
ATOM    124  ND1 HIS A   9      -7.504   6.454   1.813  1.00  0.00           N 
ATOM    125  CD2 HIS A   9      -7.111   4.456   2.576  1.00  0.00           C 
ATOM    126  CE1 HIS A   9      -8.507   5.700   1.449  1.00  0.00           C 
ATOM    127  NE2 HIS A   9      -8.304   4.476   1.894  1.00  0.00           N 
ATOM    128  H   HIS A   9      -2.612   7.568   2.302  1.00  0.00           H 
ATOM    129  HA  HIS A   9      -3.784   4.925   2.378  1.00  0.00           H 
ATOM    130 2HB  HIS A   9      -5.440   7.359   3.139  1.00  0.00           H 
ATOM    131 1HB  HIS A   9      -5.194   5.897   4.079  1.00  0.00           H 
ATOM    132  HD1 HIS A   9      -7.432   7.415   1.622  1.00  0.00           H 
ATOM    133  HD2 HIS A   9      -6.669   3.600   3.069  1.00  0.00           H 
ATOM    134  HE1 HIS A   9      -9.362   6.027   0.875  1.00  0.00           H 
ATOM    135  HE2 HIS A   9      -9.027   3.830   2.038  1.00  0.00           H 
ATOM    136  N   LEU A  10      -4.830   5.233   0.035  1.00  0.00           N 
ATOM    137  CA  LEU A  10      -5.185   5.300  -1.392  1.00  0.00           C 
ATOM    138  C   LEU A  10      -6.605   4.693  -1.551  1.00  0.00           C 
ATOM    139  O   LEU A  10      -6.861   3.572  -1.112  1.00  0.00           O 
ATOM    140  CB  LEU A  10      -4.118   4.513  -2.232  1.00  0.00           C 
ATOM    141  CG  LEU A  10      -3.964   4.864  -3.759  1.00  0.00           C 
ATOM    142  CD1 LEU A  10      -2.752   4.129  -4.371  1.00  0.00           C 
ATOM    143  CD2 LEU A  10      -5.232   4.548  -4.578  1.00  0.00           C 
ATOM    144  H   LEU A  10      -5.018   4.397   0.485  1.00  0.00           H 
ATOM    145  HA  LEU A  10      -5.199   6.343  -1.700  1.00  0.00           H 
ATOM    146 2HB  LEU A  10      -4.344   3.454  -2.152  1.00  0.00           H 
ATOM    147 1HB  LEU A  10      -3.151   4.673  -1.763  1.00  0.00           H 
ATOM    148  HG  LEU A  10      -3.771   5.929  -3.848  1.00  0.00           H 
ATOM    149 1HD1 LEU A  10      -1.853   4.401  -3.832  1.00  0.00           H 
ATOM    150 2HD1 LEU A  10      -2.633   4.414  -5.410  1.00  0.00           H 
ATOM    151 3HD1 LEU A  10      -2.899   3.060  -4.308  1.00  0.00           H 
ATOM    152 1HD2 LEU A  10      -5.076   4.802  -5.618  1.00  0.00           H 
ATOM    153 2HD2 LEU A  10      -6.065   5.124  -4.196  1.00  0.00           H 
ATOM    154 3HD2 LEU A  10      -5.468   3.492  -4.500  1.00  0.00           H 
ATOM    155  N   HIS A  11      -7.521   5.455  -2.162  1.00  0.00           N 
ATOM    156  CA  HIS A  11      -8.909   5.023  -2.451  1.00  0.00           C 
ATOM    157  C   HIS A  11      -9.022   4.538  -3.915  1.00  0.00           C 
ATOM    158  O   HIS A  11      -8.440   5.144  -4.808  1.00  0.00           O 
ATOM    159  CB  HIS A  11      -9.859   6.222  -2.187  1.00  0.00           C 
ATOM    160  CG  HIS A  11     -11.311   6.011  -2.554  1.00  0.00           C 
ATOM    161  ND1 HIS A  11     -12.115   7.025  -3.033  1.00  0.00           N 
ATOM    162  CD2 HIS A  11     -12.106   4.912  -2.473  1.00  0.00           C 
ATOM    163  CE1 HIS A  11     -13.331   6.558  -3.230  1.00  0.00           C 
ATOM    164  NE2 HIS A  11     -13.352   5.285  -2.896  1.00  0.00           N 
ATOM    165  H   HIS A  11      -7.258   6.357  -2.423  1.00  0.00           H 
ATOM    166  HA  HIS A  11      -9.168   4.208  -1.778  1.00  0.00           H 
ATOM    167 2HB  HIS A  11      -9.500   7.080  -2.747  1.00  0.00           H 
ATOM    168 1HB  HIS A  11      -9.827   6.467  -1.132  1.00  0.00           H 
ATOM    169  HD1 HIS A  11     -11.837   7.951  -3.202  1.00  0.00           H 
ATOM    170  HD2 HIS A  11     -11.792   3.914  -2.187  1.00  0.00           H 
ATOM    171  HE1 HIS A  11     -14.169   7.125  -3.598  1.00  0.00           H 
ATOM    172  HE2 HIS A  11     -14.164   4.745  -2.804  1.00  0.00           H 
ATOM    173  N   LEU A  12      -9.781   3.446  -4.141  1.00  0.00           N 
ATOM    174  CA  LEU A  12      -9.995   2.857  -5.482  1.00  0.00           C 
ATOM    175  C   LEU A  12     -11.490   2.576  -5.724  1.00  0.00           C 
ATOM    176  O   LEU A  12     -12.110   1.830  -4.975  1.00  0.00           O 
ATOM    177  CB  LEU A  12      -9.193   1.535  -5.642  1.00  0.00           C 
ATOM    178  CG  LEU A  12      -7.639   1.670  -5.707  1.00  0.00           C 
ATOM    179  CD1 LEU A  12      -6.956   0.282  -5.754  1.00  0.00           C 
ATOM    180  CD2 LEU A  12      -7.218   2.547  -6.912  1.00  0.00           C 
ATOM    181  H   LEU A  12     -10.225   3.025  -3.380  1.00  0.00           H 
ATOM    182  HA  LEU A  12      -9.648   3.566  -6.232  1.00  0.00           H 
ATOM    183 2HB  LEU A  12      -9.523   1.038  -6.552  1.00  0.00           H 
ATOM    184 1HB  LEU A  12      -9.444   0.894  -4.804  1.00  0.00           H 
ATOM    185  HG  LEU A  12      -7.294   2.168  -4.805  1.00  0.00           H 
ATOM    186 1HD1 LEU A  12      -7.273  -0.256  -6.639  1.00  0.00           H 
ATOM    187 2HD1 LEU A  12      -7.230  -0.289  -4.875  1.00  0.00           H 
ATOM    188 3HD1 LEU A  12      -5.881   0.403  -5.771  1.00  0.00           H 
ATOM    189 1HD2 LEU A  12      -7.556   2.093  -7.836  1.00  0.00           H 
ATOM    190 2HD2 LEU A  12      -6.140   2.646  -6.937  1.00  0.00           H 
ATOM    191 3HD2 LEU A  12      -7.659   3.531  -6.817  1.00  0.00           H 
ATOM    192  N   VAL A  13     -12.051   3.244  -6.737  1.00  0.00           N 
ATOM    193  CA  VAL A  13     -13.336   2.894  -7.399  1.00  0.00           C 
ATOM    194  C   VAL A  13     -13.076   3.039  -8.916  1.00  0.00           C 
ATOM    195  O   VAL A  13     -12.109   3.725  -9.296  1.00  0.00           O 
ATOM    196  CB  VAL A  13     -14.527   3.828  -6.930  1.00  0.00           C 
ATOM    197  CG1 VAL A  13     -15.858   3.513  -7.660  1.00  0.00           C 
ATOM    198  CG2 VAL A  13     -14.735   3.741  -5.402  1.00  0.00           C 
ATOM    199  H   VAL A  13     -11.580   4.036  -7.069  1.00  0.00           H 
ATOM    200  HA  VAL A  13     -13.578   1.856  -7.176  1.00  0.00           H 
ATOM    201  HB  VAL A  13     -14.255   4.855  -7.166  1.00  0.00           H 
ATOM    202 1HG1 VAL A  13     -15.729   3.647  -8.725  1.00  0.00           H 
ATOM    203 2HG1 VAL A  13     -16.639   4.177  -7.311  1.00  0.00           H 
ATOM    204 3HG1 VAL A  13     -16.149   2.486  -7.461  1.00  0.00           H 
ATOM    205 1HG2 VAL A  13     -15.544   4.398  -5.098  1.00  0.00           H 
ATOM    206 2HG2 VAL A  13     -13.829   4.040  -4.895  1.00  0.00           H 
ATOM    207 3HG2 VAL A  13     -14.981   2.723  -5.124  1.00  0.00           H 
ATOM    208  N   SER A  14     -13.897   2.435  -9.805  1.00  0.00           N 
ATOM    209  CA  SER A  14     -13.634   2.491 -11.249  1.00  0.00           C 
ATOM    210  C   SER A  14     -14.392   3.701 -11.809  1.00  0.00           C 
ATOM    211  O   SER A  14     -15.602   3.825 -11.575  1.00  0.00           O 
ATOM    212  CB  SER A  14     -14.108   1.193 -11.941  1.00  0.00           C 
ATOM    213  OG  SER A  14     -13.741   1.176 -13.314  1.00  0.00           O 
ATOM    214  H   SER A  14     -14.777   2.087  -9.568  1.00  0.00           H 
ATOM    215  HA  SER A  14     -12.561   2.613 -11.412  1.00  0.00           H 
ATOM    216 2HB  SER A  14     -15.188   1.105 -11.864  1.00  0.00           H 
ATOM    217 1HB  SER A  14     -13.651   0.341 -11.457  1.00  0.00           H 
ATOM    218  HG  SER A  14     -14.208   0.462 -13.761  1.00  0.00           H 
ATOM    219  N   LEU A  15     -13.686   4.605 -12.504  1.00  0.00           N 
ATOM    220  CA  LEU A  15     -14.301   5.816 -13.070  1.00  0.00           C 
ATOM    221  C   LEU A  15     -15.236   5.433 -14.251  1.00  0.00           C 
ATOM    222  O   LEU A  15     -14.894   4.533 -15.035  1.00  0.00           O 
ATOM    223  CB  LEU A  15     -13.192   6.848 -13.458  1.00  0.00           C 
ATOM    224  CG  LEU A  15     -12.126   6.418 -14.537  1.00  0.00           C 
ATOM    225  CD1 LEU A  15     -12.578   6.764 -15.978  1.00  0.00           C 
ATOM    226  CD2 LEU A  15     -10.733   7.029 -14.237  1.00  0.00           C 
ATOM    227  H   LEU A  15     -12.733   4.445 -12.654  1.00  0.00           H 
ATOM    228  HA  LEU A  15     -14.911   6.258 -12.283  1.00  0.00           H 
ATOM    229 2HB  LEU A  15     -12.665   7.103 -12.541  1.00  0.00           H 
ATOM    230 1HB  LEU A  15     -13.685   7.754 -13.803  1.00  0.00           H 
ATOM    231  HG  LEU A  15     -12.016   5.339 -14.497  1.00  0.00           H 
ATOM    232 1HD1 LEU A  15     -11.837   6.415 -16.690  1.00  0.00           H 
ATOM    233 2HD1 LEU A  15     -12.689   7.836 -16.077  1.00  0.00           H 
ATOM    234 3HD1 LEU A  15     -13.525   6.286 -16.189  1.00  0.00           H 
ATOM    235 1HD2 LEU A  15     -10.023   6.705 -14.987  1.00  0.00           H 
ATOM    236 2HD2 LEU A  15     -10.392   6.700 -13.265  1.00  0.00           H 
ATOM    237 3HD2 LEU A  15     -10.795   8.111 -14.245  1.00  0.00           H 
ATOM    238  N   PRO A  16     -16.448   6.073 -14.363  1.00  0.00           N 
ATOM    239  CA  PRO A  16     -17.434   5.743 -15.418  1.00  0.00           C 
ATOM    240  C   PRO A  16     -16.866   5.982 -16.835  1.00  0.00           C 
ATOM    241  O   PRO A  16     -16.247   7.022 -17.106  1.00  0.00           O 
ATOM    242  CB  PRO A  16     -18.642   6.673 -15.098  1.00  0.00           C 
ATOM    243  CG  PRO A  16     -18.065   7.780 -14.273  1.00  0.00           C 
ATOM    244  CD  PRO A  16     -16.955   7.147 -13.467  1.00  0.00           C 
ATOM    245  HA  PRO A  16     -17.746   4.703 -15.334  1.00  0.00           H 
ATOM    246 2HB  PRO A  16     -19.388   6.117 -14.538  1.00  0.00           H 
ATOM    247 1HB  PRO A  16     -19.093   7.050 -16.012  1.00  0.00           H 
ATOM    248 2HG  PRO A  16     -18.825   8.194 -13.618  1.00  0.00           H 
ATOM    249 1HG  PRO A  16     -17.668   8.564 -14.918  1.00  0.00           H 
ATOM    250 2HD  PRO A  16     -17.337   6.725 -12.541  1.00  0.00           H 
ATOM    251 1HD  PRO A  16     -16.180   7.876 -13.251  1.00  0.00           H 
ATOM    252  N   GLY A  17     -17.074   4.995 -17.717  1.00  0.00           N 
ATOM    253  CA  GLY A  17     -16.491   4.985 -19.061  1.00  0.00           C 
ATOM    254  C   GLY A  17     -15.361   3.967 -19.184  1.00  0.00           C 
ATOM    255  O   GLY A  17     -15.148   3.398 -20.260  1.00  0.00           O 
ATOM    256  H   GLY A  17     -17.649   4.248 -17.447  1.00  0.00           H 
ATOM    257 2HA  GLY A  17     -16.104   5.969 -19.310  1.00  0.00           H 
ATOM    258 1HA  GLY A  17     -17.269   4.735 -19.770  1.00  0.00           H 
ATOM    259  N   LEU A  18     -14.629   3.741 -18.070  1.00  0.00           N 
ATOM    260  CA  LEU A  18     -13.489   2.804 -18.026  1.00  0.00           C 
ATOM    261  C   LEU A  18     -13.995   1.352 -17.944  1.00  0.00           C 
ATOM    262  O   LEU A  18     -13.786   0.564 -18.878  1.00  0.00           O 
ATOM    263  CB  LEU A  18     -12.565   3.146 -16.822  1.00  0.00           C 
ATOM    264  CG  LEU A  18     -11.286   2.264 -16.636  1.00  0.00           C 
ATOM    265  CD1 LEU A  18     -10.365   2.318 -17.878  1.00  0.00           C 
ATOM    266  CD2 LEU A  18     -10.522   2.674 -15.355  1.00  0.00           C 
ATOM    267  H   LEU A  18     -14.867   4.225 -17.248  1.00  0.00           H 
ATOM    268  HA  LEU A  18     -12.918   2.926 -18.946  1.00  0.00           H 
ATOM    269 2HB  LEU A  18     -13.161   3.074 -15.917  1.00  0.00           H 
ATOM    270 1HB  LEU A  18     -12.248   4.180 -16.929  1.00  0.00           H 
ATOM    271  HG  LEU A  18     -11.593   1.231 -16.512  1.00  0.00           H 
ATOM    272 1HD1 LEU A  18     -10.893   1.940 -18.743  1.00  0.00           H 
ATOM    273 2HD1 LEU A  18      -9.487   1.707 -17.708  1.00  0.00           H 
ATOM    274 3HD1 LEU A  18     -10.055   3.340 -18.066  1.00  0.00           H 
ATOM    275 1HD2 LEU A  18      -9.649   2.044 -15.234  1.00  0.00           H 
ATOM    276 2HD2 LEU A  18     -11.164   2.554 -14.491  1.00  0.00           H 
ATOM    277 3HD2 LEU A  18     -10.209   3.709 -15.426  1.00  0.00           H 
ATOM    278  N   ASP A  19     -14.673   1.023 -16.827  1.00  0.00           N 
ATOM    279  CA  ASP A  19     -15.207  -0.327 -16.570  1.00  0.00           C 
ATOM    280  C   ASP A  19     -16.367  -0.235 -15.566  1.00  0.00           C 
ATOM    281  O   ASP A  19     -16.154   0.074 -14.392  1.00  0.00           O 
ATOM    282  CB  ASP A  19     -14.083  -1.273 -16.043  1.00  0.00           C 
ATOM    283  CG  ASP A  19     -14.572  -2.707 -15.753  1.00  0.00           C 
ATOM    284  OD1 ASP A  19     -15.077  -3.371 -16.683  1.00  0.00           O 
ATOM    285  OD2 ASP A  19     -14.447  -3.184 -14.604  1.00  0.00           O 
ATOM    286  H   ASP A  19     -14.821   1.715 -16.146  1.00  0.00           H 
ATOM    287  HA  ASP A  19     -15.589  -0.725 -17.509  1.00  0.00           H 
ATOM    288 2HB  ASP A  19     -13.666  -0.849 -15.135  1.00  0.00           H 
ATOM    289 1HB  ASP A  19     -13.293  -1.330 -16.787  1.00  0.00           H 
ATOM    290  N   GLN A  20     -17.601  -0.473 -16.047  1.00  0.00           N 
ATOM    291  CA  GLN A  20     -18.811  -0.441 -15.212  1.00  0.00           C 
ATOM    292  C   GLN A  20     -18.952  -1.771 -14.446  1.00  0.00           C 
ATOM    293  O   GLN A  20     -19.638  -2.702 -14.884  1.00  0.00           O 
ATOM    294  CB  GLN A  20     -20.082  -0.121 -16.069  1.00  0.00           C 
ATOM    295  CG  GLN A  20     -20.203   1.352 -16.540  1.00  0.00           C 
ATOM    296  CD  GLN A  20     -19.119   1.782 -17.538  1.00  0.00           C 
ATOM    297  OE1 GLN A  20     -18.051   2.270 -17.156  1.00  0.00           O 
ATOM    298  NE2 GLN A  20     -19.390   1.619 -18.824  1.00  0.00           N 
ATOM    299  H   GLN A  20     -17.698  -0.678 -16.999  1.00  0.00           H 
ATOM    300  HA  GLN A  20     -18.685   0.360 -14.482  1.00  0.00           H 
ATOM    301 2HB  GLN A  20     -20.964  -0.349 -15.480  1.00  0.00           H 
ATOM    302 1HB  GLN A  20     -20.085  -0.758 -16.947  1.00  0.00           H 
ATOM    303 2HG  GLN A  20     -20.148   1.997 -15.673  1.00  0.00           H 
ATOM    304 1HG  GLN A  20     -21.173   1.487 -17.008  1.00  0.00           H 
ATOM    305 2HE2 GLN A  20     -20.256   1.233 -19.070  1.00  0.00           H 
ATOM    306 1HE2 GLN A  20     -18.712   1.891 -19.479  1.00  0.00           H 
ATOM    307  N   GLN A  21     -18.229  -1.843 -13.323  1.00  0.00           N 
ATOM    308  CA  GLN A  21     -18.253  -2.971 -12.386  1.00  0.00           C 
ATOM    309  C   GLN A  21     -18.057  -2.406 -10.977  1.00  0.00           C 
ATOM    310  O   GLN A  21     -17.362  -1.389 -10.806  1.00  0.00           O 
ATOM    311  CB  GLN A  21     -17.137  -3.996 -12.730  1.00  0.00           C 
ATOM    312  CG  GLN A  21     -17.169  -5.302 -11.906  1.00  0.00           C 
ATOM    313  CD  GLN A  21     -16.076  -6.297 -12.307  1.00  0.00           C 
ATOM    314  OE1 GLN A  21     -16.263  -7.107 -13.214  1.00  0.00           O 
ATOM    315  NE2 GLN A  21     -14.933  -6.255 -11.635  1.00  0.00           N 
ATOM    316  H   GLN A  21     -17.645  -1.082 -13.106  1.00  0.00           H 
ATOM    317  HA  GLN A  21     -19.226  -3.453 -12.446  1.00  0.00           H 
ATOM    318 2HB  GLN A  21     -16.173  -3.523 -12.578  1.00  0.00           H 
ATOM    319 1HB  GLN A  21     -17.223  -4.257 -13.781  1.00  0.00           H 
ATOM    320 2HG  GLN A  21     -18.136  -5.775 -12.042  1.00  0.00           H 
ATOM    321 1HG  GLN A  21     -17.046  -5.055 -10.856  1.00  0.00           H 
ATOM    322 2HE2 GLN A  21     -14.843  -5.598 -10.921  1.00  0.00           H 
ATOM    323 1HE2 GLN A  21     -14.221  -6.886 -11.881  1.00  0.00           H 
ATOM    324  N   ASP A  22     -18.655  -3.067  -9.977  1.00  0.00           N 
ATOM    325  CA  ASP A  22     -18.577  -2.626  -8.576  1.00  0.00           C 
ATOM    326  C   ASP A  22     -17.223  -3.037  -7.987  1.00  0.00           C 
ATOM    327  O   ASP A  22     -17.087  -4.115  -7.404  1.00  0.00           O 
ATOM    328  CB  ASP A  22     -19.759  -3.213  -7.751  1.00  0.00           C 
ATOM    329  CG  ASP A  22     -19.741  -2.828  -6.254  1.00  0.00           C 
ATOM    330  OD1 ASP A  22     -19.571  -3.714  -5.384  1.00  0.00           O 
ATOM    331  OD2 ASP A  22     -19.891  -1.624  -5.945  1.00  0.00           O 
ATOM    332  H   ASP A  22     -19.128  -3.901 -10.182  1.00  0.00           H 
ATOM    333  HA  ASP A  22     -18.645  -1.536  -8.565  1.00  0.00           H 
ATOM    334 2HB  ASP A  22     -19.737  -4.294  -7.837  1.00  0.00           H 
ATOM    335 1HB  ASP A  22     -20.690  -2.857  -8.177  1.00  0.00           H 
ATOM    336  N   ILE A  23     -16.190  -2.218  -8.247  1.00  0.00           N 
ATOM    337  CA  ILE A  23     -14.882  -2.380  -7.609  1.00  0.00           C 
ATOM    338  C   ILE A  23     -14.695  -1.215  -6.635  1.00  0.00           C 
ATOM    339  O   ILE A  23     -14.928  -0.050  -6.983  1.00  0.00           O 
ATOM    340  CB  ILE A  23     -13.684  -2.511  -8.656  1.00  0.00           C 
ATOM    341  CG1 ILE A  23     -13.206  -1.140  -9.277  1.00  0.00           C 
ATOM    342  CG2 ILE A  23     -14.069  -3.505  -9.777  1.00  0.00           C 
ATOM    343  CD1 ILE A  23     -11.995  -0.499  -8.596  1.00  0.00           C 
ATOM    344  H   ILE A  23     -16.317  -1.488  -8.895  1.00  0.00           H 
ATOM    345  HA  ILE A  23     -14.909  -3.306  -7.026  1.00  0.00           H 
ATOM    346  HB  ILE A  23     -12.846  -2.960  -8.120  1.00  0.00           H 
ATOM    347 2HG1 ILE A  23     -14.018  -0.422  -9.237  1.00  0.00           H 
ATOM    348 1HG1 ILE A  23     -12.928  -1.283 -10.315  1.00  0.00           H 
ATOM    349 1HG2 ILE A  23     -13.249  -3.606 -10.478  1.00  0.00           H 
ATOM    350 2HG2 ILE A  23     -14.943  -3.142 -10.305  1.00  0.00           H 
ATOM    351 3HG2 ILE A  23     -14.292  -4.474  -9.348  1.00  0.00           H 
ATOM    352 1HD1 ILE A  23     -12.217  -0.305  -7.554  1.00  0.00           H 
ATOM    353 2HD1 ILE A  23     -11.763   0.433  -9.090  1.00  0.00           H 
ATOM    354 3HD1 ILE A  23     -11.147  -1.164  -8.669  1.00  0.00           H 
ATOM    355  N   ASN A  24     -14.353  -1.554  -5.398  1.00  0.00           N 
ATOM    356  CA  ASN A  24     -14.068  -0.582  -4.346  1.00  0.00           C 
ATOM    357  C   ASN A  24     -13.066  -1.203  -3.375  1.00  0.00           C 
ATOM    358  O   ASN A  24     -13.285  -2.299  -2.847  1.00  0.00           O 
ATOM    359  CB  ASN A  24     -15.359  -0.070  -3.644  1.00  0.00           C 
ATOM    360  CG  ASN A  24     -16.286  -1.164  -3.116  1.00  0.00           C 
ATOM    361  OD1 ASN A  24     -16.199  -1.563  -1.958  1.00  0.00           O 
ATOM    362  ND2 ASN A  24     -17.171  -1.666  -3.973  1.00  0.00           N 
ATOM    363  H   ASN A  24     -14.280  -2.510  -5.190  1.00  0.00           H 
ATOM    364  HA  ASN A  24     -13.581   0.271  -4.826  1.00  0.00           H 
ATOM    365 2HB  ASN A  24     -15.923   0.534  -4.348  1.00  0.00           H 
ATOM    366 1HB  ASN A  24     -15.078   0.563  -2.808  1.00  0.00           H 
ATOM    367 2HD2 ASN A  24     -17.185  -1.311  -4.887  1.00  0.00           H 
ATOM    368 1HD2 ASN A  24     -17.765  -2.384  -3.662  1.00  0.00           H 
ATOM    369  N   ILE A  25     -11.938  -0.500  -3.196  1.00  0.00           N 
ATOM    370  CA  ILE A  25     -10.764  -0.971  -2.451  1.00  0.00           C 
ATOM    371  C   ILE A  25     -10.221   0.217  -1.653  1.00  0.00           C 
ATOM    372  O   ILE A  25     -10.222   1.356  -2.139  1.00  0.00           O 
ATOM    373  CB  ILE A  25      -9.608  -1.495  -3.399  1.00  0.00           C 
ATOM    374  CG1 ILE A  25     -10.131  -2.536  -4.436  1.00  0.00           C 
ATOM    375  CG2 ILE A  25      -8.430  -2.089  -2.576  1.00  0.00           C 
ATOM    376  CD1 ILE A  25      -9.111  -2.967  -5.474  1.00  0.00           C 
ATOM    377  H   ILE A  25     -11.906   0.417  -3.535  1.00  0.00           H 
ATOM    378  HA  ILE A  25     -11.067  -1.768  -1.773  1.00  0.00           H 
ATOM    379  HB  ILE A  25      -9.219  -0.635  -3.944  1.00  0.00           H 
ATOM    380 2HG1 ILE A  25     -10.978  -2.118  -4.970  1.00  0.00           H 
ATOM    381 1HG1 ILE A  25     -10.456  -3.431  -3.919  1.00  0.00           H 
ATOM    382 1HG2 ILE A  25      -7.635  -2.401  -3.245  1.00  0.00           H 
ATOM    383 2HG2 ILE A  25      -8.773  -2.946  -2.010  1.00  0.00           H 
ATOM    384 3HG2 ILE A  25      -8.045  -1.342  -1.893  1.00  0.00           H 
ATOM    385 1HD1 ILE A  25      -9.569  -3.666  -6.155  1.00  0.00           H 
ATOM    386 2HD1 ILE A  25      -8.273  -3.445  -4.984  1.00  0.00           H 
ATOM    387 3HD1 ILE A  25      -8.759  -2.105  -6.028  1.00  0.00           H 
ATOM    388  N   HIS A  26      -9.790  -0.046  -0.427  1.00  0.00           N 
ATOM    389  CA  HIS A  26      -9.086   0.923   0.411  1.00  0.00           C 
ATOM    390  C   HIS A  26      -7.667   0.375   0.593  1.00  0.00           C 
ATOM    391  O   HIS A  26      -7.521  -0.815   0.856  1.00  0.00           O 
ATOM    392  CB  HIS A  26      -9.795   1.066   1.797  1.00  0.00           C 
ATOM    393  CG  HIS A  26     -11.306   1.197   1.770  1.00  0.00           C 
ATOM    394  ND1 HIS A  26     -12.106   0.832   2.833  1.00  0.00           N 
ATOM    395  CD2 HIS A  26     -12.158   1.660   0.818  1.00  0.00           C 
ATOM    396  CE1 HIS A  26     -13.369   1.063   2.538  1.00  0.00           C 
ATOM    397  NE2 HIS A  26     -13.425   1.566   1.323  1.00  0.00           N 
ATOM    398  H   HIS A  26      -9.945  -0.938  -0.061  1.00  0.00           H 
ATOM    399  HA  HIS A  26      -9.046   1.888  -0.093  1.00  0.00           H 
ATOM    400 2HB  HIS A  26      -9.402   1.943   2.299  1.00  0.00           H 
ATOM    401 1HB  HIS A  26      -9.568   0.195   2.400  1.00  0.00           H 
ATOM    402  HD1 HIS A  26     -11.791   0.444   3.677  1.00  0.00           H 
ATOM    403  HD2 HIS A  26     -11.887   2.016  -0.165  1.00  0.00           H 
ATOM    404  HE1 HIS A  26     -14.214   0.866   3.177  1.00  0.00           H 
ATOM    405  HE2 HIS A  26     -14.248   1.778   0.837  1.00  0.00           H 
ATOM    406  N   ILE A  27      -6.632   1.213   0.442  1.00  0.00           N 
ATOM    407  CA  ILE A  27      -5.231   0.800   0.655  1.00  0.00           C 
ATOM    408  C   ILE A  27      -4.631   1.734   1.713  1.00  0.00           C 
ATOM    409  O   ILE A  27      -4.342   2.889   1.438  1.00  0.00           O 
ATOM    410  CB  ILE A  27      -4.367   0.863  -0.670  1.00  0.00           C 
ATOM    411  CG1 ILE A  27      -5.003  -0.016  -1.805  1.00  0.00           C 
ATOM    412  CG2 ILE A  27      -2.892   0.432  -0.400  1.00  0.00           C 
ATOM    413  CD1 ILE A  27      -4.245  -0.003  -3.128  1.00  0.00           C 
ATOM    414  H   ILE A  27      -6.809   2.142   0.228  1.00  0.00           H 
ATOM    415  HA  ILE A  27      -5.211  -0.228   1.030  1.00  0.00           H 
ATOM    416  HB  ILE A  27      -4.350   1.899  -1.002  1.00  0.00           H 
ATOM    417 2HG1 ILE A  27      -6.014   0.331  -2.005  1.00  0.00           H 
ATOM    418 1HG1 ILE A  27      -5.052  -1.046  -1.477  1.00  0.00           H 
ATOM    419 1HG2 ILE A  27      -2.866  -0.597  -0.063  1.00  0.00           H 
ATOM    420 2HG2 ILE A  27      -2.460   1.063   0.368  1.00  0.00           H 
ATOM    421 3HG2 ILE A  27      -2.303   0.526  -1.304  1.00  0.00           H 
ATOM    422 1HD1 ILE A  27      -4.774  -0.612  -3.849  1.00  0.00           H 
ATOM    423 2HD1 ILE A  27      -3.252  -0.404  -2.985  1.00  0.00           H 
ATOM    424 3HD1 ILE A  27      -4.178   1.010  -3.502  1.00  0.00           H 
ATOM    425  N   ARG A  28      -4.461   1.212   2.912  1.00  0.00           N 
ATOM    426  CA  ARG A  28      -3.893   1.936   4.051  1.00  0.00           C 
ATOM    427  C   ARG A  28      -2.453   1.471   4.225  1.00  0.00           C 
ATOM    428  O   ARG A  28      -2.190   0.273   4.173  1.00  0.00           O 
ATOM    429  CB  ARG A  28      -4.735   1.635   5.320  1.00  0.00           C 
ATOM    430  CG  ARG A  28      -4.268   2.331   6.615  1.00  0.00           C 
ATOM    431  CD  ARG A  28      -5.196   2.012   7.802  1.00  0.00           C 
ATOM    432  NE  ARG A  28      -4.780   2.692   9.038  1.00  0.00           N 
ATOM    433  CZ  ARG A  28      -5.565   2.918  10.102  1.00  0.00           C 
ATOM    434  NH1 ARG A  28      -6.853   2.609  10.074  1.00  0.00           N 
ATOM    435  NH2 ARG A  28      -5.055   3.463  11.194  1.00  0.00           N 
ATOM    436  H   ARG A  28      -4.724   0.286   3.047  1.00  0.00           H 
ATOM    437  HA  ARG A  28      -3.915   3.005   3.845  1.00  0.00           H 
ATOM    438 2HB  ARG A  28      -4.735   0.561   5.487  1.00  0.00           H 
ATOM    439 1HB  ARG A  28      -5.757   1.946   5.124  1.00  0.00           H 
ATOM    440 2HG  ARG A  28      -4.259   3.403   6.455  1.00  0.00           H 
ATOM    441 1HG  ARG A  28      -3.266   1.998   6.855  1.00  0.00           H 
ATOM    442 2HD  ARG A  28      -5.188   0.942   7.974  1.00  0.00           H 
ATOM    443 1HD  ARG A  28      -6.206   2.323   7.549  1.00  0.00           H 
ATOM    444  HE  ARG A  28      -3.851   2.976   9.087  1.00  0.00           H 
ATOM    445 1HH1 ARG A  28      -7.258   2.207   9.252  1.00  0.00           H 
ATOM    446 2HH1 ARG A  28      -7.429   2.778  10.877  1.00  0.00           H 
ATOM    447 1HH2 ARG A  28      -4.081   3.705  11.226  1.00  0.00           H 
ATOM    448 2HH2 ARG A  28      -5.638   3.639  11.992  1.00  0.00           H 
ATOM    449  N   TYR A  29      -1.520   2.408   4.386  1.00  0.00           N 
ATOM    450  CA  TYR A  29      -0.120   2.079   4.660  1.00  0.00           C 
ATOM    451  C   TYR A  29       0.343   2.884   5.878  1.00  0.00           C 
ATOM    452  O   TYR A  29       0.193   4.113   5.923  1.00  0.00           O 
ATOM    453  CB  TYR A  29       0.775   2.295   3.402  1.00  0.00           C 
ATOM    454  CG  TYR A  29       0.919   3.736   2.880  1.00  0.00           C 
ATOM    455  CD1 TYR A  29       1.995   4.543   3.276  1.00  0.00           C 
ATOM    456  CD2 TYR A  29      -0.010   4.289   1.996  1.00  0.00           C 
ATOM    457  CE1 TYR A  29       2.132   5.833   2.814  1.00  0.00           C 
ATOM    458  CE2 TYR A  29       0.131   5.583   1.527  1.00  0.00           C 
ATOM    459  CZ  TYR A  29       1.200   6.351   1.944  1.00  0.00           C 
ATOM    460  OH  TYR A  29       1.331   7.643   1.500  1.00  0.00           O 
ATOM    461  H   TYR A  29      -1.780   3.354   4.348  1.00  0.00           H 
ATOM    462  HA  TYR A  29      -0.072   1.019   4.928  1.00  0.00           H 
ATOM    463 2HB  TYR A  29       0.368   1.693   2.593  1.00  0.00           H 
ATOM    464 1HB  TYR A  29       1.769   1.924   3.616  1.00  0.00           H 
ATOM    465  HD1 TYR A  29       2.730   4.140   3.961  1.00  0.00           H 
ATOM    466  HD2 TYR A  29      -0.853   3.689   1.669  1.00  0.00           H 
ATOM    467  HE1 TYR A  29       2.971   6.435   3.136  1.00  0.00           H 
ATOM    468  HE2 TYR A  29      -0.603   5.993   0.844  1.00  0.00           H 
ATOM    469  HH  TYR A  29       2.260   7.825   1.314  1.00  0.00           H 
ATOM    470  N   GLU A  30       0.830   2.161   6.889  1.00  0.00           N 
ATOM    471  CA  GLU A  30       1.320   2.727   8.146  1.00  0.00           C 
ATOM    472  C   GLU A  30       2.724   2.190   8.394  1.00  0.00           C 
ATOM    473  O   GLU A  30       2.901   0.979   8.560  1.00  0.00           O 
ATOM    474  CB  GLU A  30       0.393   2.334   9.327  1.00  0.00           C 
ATOM    475  CG  GLU A  30      -1.074   2.767   9.177  1.00  0.00           C 
ATOM    476  CD  GLU A  30      -1.896   2.506  10.444  1.00  0.00           C 
ATOM    477  OE1 GLU A  30      -2.382   1.374  10.628  1.00  0.00           O 
ATOM    478  OE2 GLU A  30      -2.071   3.435  11.258  1.00  0.00           O 
ATOM    479  H   GLU A  30       0.869   1.193   6.780  1.00  0.00           H 
ATOM    480  HA  GLU A  30       1.355   3.814   8.063  1.00  0.00           H 
ATOM    481 2HB  GLU A  30       0.789   2.783  10.237  1.00  0.00           H 
ATOM    482 1HB  GLU A  30       0.414   1.252   9.446  1.00  0.00           H 
ATOM    483 2HG  GLU A  30      -1.523   2.220   8.352  1.00  0.00           H 
ATOM    484 1HG  GLU A  30      -1.105   3.827   8.942  1.00  0.00           H 
ATOM    485  N   VAL A  31       3.716   3.081   8.411  1.00  0.00           N 
ATOM    486  CA  VAL A  31       5.100   2.694   8.661  1.00  0.00           C 
ATOM    487  C   VAL A  31       5.310   2.491  10.166  1.00  0.00           C 
ATOM    488  O   VAL A  31       5.168   3.426  10.963  1.00  0.00           O 
ATOM    489  CB  VAL A  31       6.101   3.756   8.089  1.00  0.00           C 
ATOM    490  CG1 VAL A  31       7.579   3.365   8.368  1.00  0.00           C 
ATOM    491  CG2 VAL A  31       5.846   3.944   6.576  1.00  0.00           C 
ATOM    492  H   VAL A  31       3.510   4.029   8.264  1.00  0.00           H 
ATOM    493  HA  VAL A  31       5.281   1.746   8.141  1.00  0.00           H 
ATOM    494  HB  VAL A  31       5.908   4.705   8.584  1.00  0.00           H 
ATOM    495 1HG1 VAL A  31       7.795   2.405   7.915  1.00  0.00           H 
ATOM    496 2HG1 VAL A  31       7.749   3.300   9.433  1.00  0.00           H 
ATOM    497 3HG1 VAL A  31       8.244   4.114   7.949  1.00  0.00           H 
ATOM    498 1HG2 VAL A  31       5.992   3.006   6.057  1.00  0.00           H 
ATOM    499 2HG2 VAL A  31       6.534   4.679   6.178  1.00  0.00           H 
ATOM    500 3HG2 VAL A  31       4.830   4.286   6.410  1.00  0.00           H 
ATOM    501  N   ARG A  32       5.643   1.256  10.526  1.00  0.00           N 
ATOM    502  CA  ARG A  32       5.896   0.833  11.906  1.00  0.00           C 
ATOM    503  C   ARG A  32       7.346   0.340  11.980  1.00  0.00           C 
ATOM    504  O   ARG A  32       7.948   0.008  10.952  1.00  0.00           O 
ATOM    505  CB  ARG A  32       4.916  -0.307  12.304  1.00  0.00           C 
ATOM    506  CG  ARG A  32       4.998  -0.761  13.789  1.00  0.00           C 
ATOM    507  CD  ARG A  32       4.409  -2.152  14.004  1.00  0.00           C 
ATOM    508  NE  ARG A  32       4.377  -2.570  15.419  1.00  0.00           N 
ATOM    509  CZ  ARG A  32       4.117  -3.823  15.844  1.00  0.00           C 
ATOM    510  NH1 ARG A  32       3.940  -4.810  14.972  1.00  0.00           N 
ATOM    511  NH2 ARG A  32       4.059  -4.089  17.142  1.00  0.00           N 
ATOM    512  H   ARG A  32       5.766   0.589   9.818  1.00  0.00           H 
ATOM    513  HA  ARG A  32       5.766   1.683  12.575  1.00  0.00           H 
ATOM    514 2HB  ARG A  32       5.114  -1.168  11.671  1.00  0.00           H 
ATOM    515 1HB  ARG A  32       3.899   0.025  12.114  1.00  0.00           H 
ATOM    516 2HG  ARG A  32       4.458  -0.049  14.404  1.00  0.00           H 
ATOM    517 1HG  ARG A  32       6.038  -0.774  14.102  1.00  0.00           H 
ATOM    518 2HD  ARG A  32       5.020  -2.858  13.448  1.00  0.00           H 
ATOM    519 1HD  ARG A  32       3.399  -2.172  13.615  1.00  0.00           H 
ATOM    520  HE  ARG A  32       4.541  -1.871  16.090  1.00  0.00           H 
ATOM    521 1HH1 ARG A  32       4.001  -4.633  13.983  1.00  0.00           H 
ATOM    522 2HH1 ARG A  32       3.748  -5.738  15.294  1.00  0.00           H 
ATOM    523 1HH2 ARG A  32       4.211  -3.359  17.813  1.00  0.00           H 
ATOM    524 2HH2 ARG A  32       3.862  -5.023  17.459  1.00  0.00           H 
ATOM    525  N   GLN A  33       7.916   0.305  13.183  1.00  0.00           N 
ATOM    526  CA  GLN A  33       9.278  -0.182  13.398  1.00  0.00           C 
ATOM    527  C   GLN A  33       9.241  -1.548  14.104  1.00  0.00           C 
ATOM    528  O   GLN A  33       8.695  -1.668  15.199  1.00  0.00           O 
ATOM    529  CB  GLN A  33      10.112   0.837  14.227  1.00  0.00           C 
ATOM    530  CG  GLN A  33      10.094   2.295  13.722  1.00  0.00           C 
ATOM    531  CD  GLN A  33      10.625   2.478  12.299  1.00  0.00           C 
ATOM    532  OE1 GLN A  33      11.831   2.616  12.086  1.00  0.00           O 
ATOM    533  NE2 GLN A  33       9.728   2.539  11.320  1.00  0.00           N 
ATOM    534  H   GLN A  33       7.399   0.599  13.953  1.00  0.00           H 
ATOM    535  HA  GLN A  33       9.747  -0.310  12.427  1.00  0.00           H 
ATOM    536 2HB  GLN A  33      11.149   0.504  14.248  1.00  0.00           H 
ATOM    537 1HB  GLN A  33       9.740   0.840  15.240  1.00  0.00           H 
ATOM    538 2HG  GLN A  33      10.694   2.900  14.390  1.00  0.00           H 
ATOM    539 1HG  GLN A  33       9.071   2.657  13.757  1.00  0.00           H 
ATOM    540 2HE2 GLN A  33       8.780   2.463  11.560  1.00  0.00           H 
ATOM    541 1HE2 GLN A  33      10.047   2.667  10.406  1.00  0.00           H 
ATOM    542  N   ASN A  34       9.791  -2.570  13.437  1.00  0.00           N 
ATOM    543  CA  ASN A  34      10.073  -3.899  14.031  1.00  0.00           C 
ATOM    544  C   ASN A  34      11.561  -3.977  14.409  1.00  0.00           C 
ATOM    545  O   ASN A  34      12.392  -3.360  13.754  1.00  0.00           O 
ATOM    546  CB  ASN A  34       9.684  -5.067  13.057  1.00  0.00           C 
ATOM    547  CG  ASN A  34      10.487  -5.200  11.737  1.00  0.00           C 
ATOM    548  OD1 ASN A  34      10.576  -6.289  11.190  1.00  0.00           O 
ATOM    549  ND2 ASN A  34      11.099  -4.142  11.222  1.00  0.00           N 
ATOM    550  H   ASN A  34      10.044  -2.421  12.513  1.00  0.00           H 
ATOM    551  HA  ASN A  34       9.480  -3.993  14.941  1.00  0.00           H 
ATOM    552 2HB  ASN A  34       8.638  -4.956  12.795  1.00  0.00           H 
ATOM    553 1HB  ASN A  34       9.801  -6.008  13.585  1.00  0.00           H 
ATOM    554 2HD2 ASN A  34      11.047  -3.299  11.691  1.00  0.00           H 
ATOM    555 1HD2 ASN A  34      11.561  -4.250  10.367  1.00  0.00           H 
ATOM    556  N   ALA A  35      11.890  -4.732  15.463  1.00  0.00           N 
ATOM    557  CA  ALA A  35      13.290  -4.924  15.913  1.00  0.00           C 
ATOM    558  C   ALA A  35      14.095  -5.817  14.937  1.00  0.00           C 
ATOM    559  O   ALA A  35      15.325  -5.902  15.038  1.00  0.00           O 
ATOM    560  CB  ALA A  35      13.302  -5.505  17.335  1.00  0.00           C 
ATOM    561  H   ALA A  35      11.175  -5.183  15.958  1.00  0.00           H 
ATOM    562  HA  ALA A  35      13.764  -3.947  15.952  1.00  0.00           H 
ATOM    563 1HB  ALA A  35      14.323  -5.601  17.686  1.00  0.00           H 
ATOM    564 2HB  ALA A  35      12.831  -6.480  17.334  1.00  0.00           H 
ATOM    565 3HB  ALA A  35      12.754  -4.849  18.000  1.00  0.00           H 
ATOM    566  N   GLU A  36      13.386  -6.469  13.998  1.00  0.00           N 
ATOM    567  CA  GLU A  36      13.981  -7.370  13.003  1.00  0.00           C 
ATOM    568  C   GLU A  36      14.697  -6.589  11.875  1.00  0.00           C 
ATOM    569  O   GLU A  36      15.887  -6.809  11.622  1.00  0.00           O 
ATOM    570  CB  GLU A  36      12.869  -8.279  12.419  1.00  0.00           C 
ATOM    571  CG  GLU A  36      13.323  -9.215  11.280  1.00  0.00           C 
ATOM    572  CD  GLU A  36      12.177 -10.041  10.683  1.00  0.00           C 
ATOM    573  OE1 GLU A  36      11.908 -11.160  11.173  1.00  0.00           O 
ATOM    574  OE2 GLU A  36      11.521  -9.564   9.732  1.00  0.00           O 
ATOM    575  H   GLU A  36      12.415  -6.351  13.989  1.00  0.00           H 
ATOM    576  HA  GLU A  36      14.709  -7.995  13.516  1.00  0.00           H 
ATOM    577 2HB  GLU A  36      12.075  -7.645  12.041  1.00  0.00           H 
ATOM    578 1HB  GLU A  36      12.468  -8.889  13.221  1.00  0.00           H 
ATOM    579 2HG  GLU A  36      14.083  -9.886  11.663  1.00  0.00           H 
ATOM    580 1HG  GLU A  36      13.759  -8.606  10.495  1.00  0.00           H 
ATOM    581  N   SER A  37      13.970  -5.671  11.209  1.00  0.00           N 
ATOM    582  CA  SER A  37      14.483  -4.925  10.024  1.00  0.00           C 
ATOM    583  C   SER A  37      14.617  -3.417  10.315  1.00  0.00           C 
ATOM    584  O   SER A  37      15.155  -2.659   9.498  1.00  0.00           O 
ATOM    585  CB  SER A  37      13.536  -5.167   8.813  1.00  0.00           C 
ATOM    586  OG  SER A  37      14.001  -4.528   7.627  1.00  0.00           O 
ATOM    587  H   SER A  37      13.059  -5.491  11.514  1.00  0.00           H 
ATOM    588  HA  SER A  37      15.469  -5.310   9.771  1.00  0.00           H 
ATOM    589 2HB  SER A  37      12.549  -4.786   9.043  1.00  0.00           H 
ATOM    590 1HB  SER A  37      13.467  -6.229   8.619  1.00  0.00           H 
ATOM    591  HG  SER A  37      14.531  -5.151   7.111  1.00  0.00           H 
ATOM    592  N   GLY A  38      14.134  -2.991  11.486  1.00  0.00           N 
ATOM    593  CA  GLY A  38      14.043  -1.571  11.818  1.00  0.00           C 
ATOM    594  C   GLY A  38      12.745  -1.004  11.274  1.00  0.00           C 
ATOM    595  O   GLY A  38      11.676  -1.339  11.769  1.00  0.00           O 
ATOM    596  H   GLY A  38      13.804  -3.653  12.124  1.00  0.00           H 
ATOM    597 2HA  GLY A  38      14.886  -1.030  11.397  1.00  0.00           H 
ATOM    598 1HA  GLY A  38      14.057  -1.462  12.896  1.00  0.00           H 
ATOM    599  N   ALA A  39      12.832  -0.183  10.225  1.00  0.00           N 
ATOM    600  CA  ALA A  39      11.649   0.341   9.520  1.00  0.00           C 
ATOM    601  C   ALA A  39      10.990  -0.747   8.646  1.00  0.00           C 
ATOM    602  O   ALA A  39      11.680  -1.587   8.058  1.00  0.00           O 
ATOM    603  CB  ALA A  39      12.030   1.568   8.663  1.00  0.00           C 
ATOM    604  H   ALA A  39      13.721   0.099   9.939  1.00  0.00           H 
ATOM    605  HA  ALA A  39      10.930   0.669  10.281  1.00  0.00           H 
ATOM    606 1HB  ALA A  39      12.477   2.328   9.294  1.00  0.00           H 
ATOM    607 2HB  ALA A  39      11.145   1.978   8.195  1.00  0.00           H 
ATOM    608 3HB  ALA A  39      12.738   1.278   7.894  1.00  0.00           H 
ATOM    609  N   TYR A  40       9.651  -0.736   8.615  1.00  0.00           N 
ATOM    610  CA  TYR A  40       8.839  -1.526   7.659  1.00  0.00           C 
ATOM    611  C   TYR A  40       7.460  -0.857   7.508  1.00  0.00           C 
ATOM    612  O   TYR A  40       7.109   0.021   8.301  1.00  0.00           O 
ATOM    613  CB  TYR A  40       8.708  -3.024   8.103  1.00  0.00           C 
ATOM    614  CG  TYR A  40       7.592  -3.358   9.113  1.00  0.00           C 
ATOM    615  CD1 TYR A  40       7.764  -3.160  10.484  1.00  0.00           C 
ATOM    616  CD2 TYR A  40       6.365  -3.897   8.687  1.00  0.00           C 
ATOM    617  CE1 TYR A  40       6.763  -3.475  11.382  1.00  0.00           C 
ATOM    618  CE2 TYR A  40       5.372  -4.200   9.583  1.00  0.00           C 
ATOM    619  CZ  TYR A  40       5.570  -3.999  10.923  1.00  0.00           C 
ATOM    620  OH  TYR A  40       4.568  -4.332  11.809  1.00  0.00           O 
ATOM    621  H   TYR A  40       9.182  -0.173   9.270  1.00  0.00           H 
ATOM    622  HA  TYR A  40       9.343  -1.485   6.691  1.00  0.00           H 
ATOM    623 2HB  TYR A  40       9.652  -3.336   8.538  1.00  0.00           H 
ATOM    624 1HB  TYR A  40       8.537  -3.629   7.219  1.00  0.00           H 
ATOM    625  HD1 TYR A  40       8.697  -2.748  10.847  1.00  0.00           H 
ATOM    626  HD2 TYR A  40       6.191  -4.064   7.629  1.00  0.00           H 
ATOM    627  HE1 TYR A  40       6.917  -3.311  12.441  1.00  0.00           H 
ATOM    628  HE2 TYR A  40       4.436  -4.607   9.225  1.00  0.00           H 
ATOM    629  HH  TYR A  40       4.164  -5.170  11.535  1.00  0.00           H 
ATOM    630  N   VAL A  41       6.675  -1.257   6.493  1.00  0.00           N 
ATOM    631  CA  VAL A  41       5.313  -0.724   6.293  1.00  0.00           C 
ATOM    632  C   VAL A  41       4.272  -1.847   6.460  1.00  0.00           C 
ATOM    633  O   VAL A  41       4.377  -2.903   5.826  1.00  0.00           O 
ATOM    634  CB  VAL A  41       5.120  -0.056   4.879  1.00  0.00           C 
ATOM    635  CG1 VAL A  41       3.846   0.823   4.856  1.00  0.00           C 
ATOM    636  CG2 VAL A  41       6.357   0.755   4.444  1.00  0.00           C 
ATOM    637  H   VAL A  41       7.014  -1.927   5.867  1.00  0.00           H 
ATOM    638  HA  VAL A  41       5.131   0.038   7.054  1.00  0.00           H 
ATOM    639  HB  VAL A  41       4.980  -0.853   4.149  1.00  0.00           H 
ATOM    640 1HG1 VAL A  41       3.933   1.615   5.590  1.00  0.00           H 
ATOM    641 2HG1 VAL A  41       2.977   0.220   5.090  1.00  0.00           H 
ATOM    642 3HG1 VAL A  41       3.716   1.257   3.870  1.00  0.00           H 
ATOM    643 1HG2 VAL A  41       6.543   1.550   5.155  1.00  0.00           H 
ATOM    644 2HG2 VAL A  41       6.190   1.186   3.464  1.00  0.00           H 
ATOM    645 3HG2 VAL A  41       7.223   0.109   4.403  1.00  0.00           H 
ATOM    646  N   HIS A  42       3.292  -1.607   7.335  1.00  0.00           N 
ATOM    647  CA  HIS A  42       2.101  -2.452   7.494  1.00  0.00           C 
ATOM    648  C   HIS A  42       0.995  -1.928   6.558  1.00  0.00           C 
ATOM    649  O   HIS A  42       0.576  -0.775   6.679  1.00  0.00           O 
ATOM    650  CB  HIS A  42       1.637  -2.417   8.980  1.00  0.00           C 
ATOM    651  CG  HIS A  42       0.253  -2.984   9.237  1.00  0.00           C 
ATOM    652  ND1 HIS A  42      -0.006  -4.326   9.399  1.00  0.00           N 
ATOM    653  CD2 HIS A  42      -0.949  -2.365   9.343  1.00  0.00           C 
ATOM    654  CE1 HIS A  42      -1.297  -4.504   9.582  1.00  0.00           C 
ATOM    655  NE2 HIS A  42      -1.888  -3.333   9.557  1.00  0.00           N 
ATOM    656  H   HIS A  42       3.357  -0.813   7.894  1.00  0.00           H 
ATOM    657  HA  HIS A  42       2.359  -3.477   7.222  1.00  0.00           H 
ATOM    658 2HB  HIS A  42       1.642  -1.390   9.326  1.00  0.00           H 
ATOM    659 1HB  HIS A  42       2.337  -2.985   9.577  1.00  0.00           H 
ATOM    660  HD1 HIS A  42       0.663  -5.041   9.409  1.00  0.00           H 
ATOM    661  HD2 HIS A  42      -1.134  -1.301   9.266  1.00  0.00           H 
ATOM    662  HE1 HIS A  42      -1.786  -5.456   9.732  1.00  0.00           H 
ATOM    663  HE2 HIS A  42      -2.854  -3.204   9.431  1.00  0.00           H 
ATOM    664  N   PHE A  43       0.527  -2.777   5.637  1.00  0.00           N 
ATOM    665  CA  PHE A  43      -0.545  -2.423   4.684  1.00  0.00           C 
ATOM    666  C   PHE A  43      -1.856  -3.149   5.057  1.00  0.00           C 
ATOM    667  O   PHE A  43      -1.820  -4.285   5.548  1.00  0.00           O 
ATOM    668  CB  PHE A  43      -0.139  -2.807   3.240  1.00  0.00           C 
ATOM    669  CG  PHE A  43       1.185  -2.214   2.740  1.00  0.00           C 
ATOM    670  CD1 PHE A  43       1.224  -0.962   2.134  1.00  0.00           C 
ATOM    671  CD2 PHE A  43       2.385  -2.924   2.856  1.00  0.00           C 
ATOM    672  CE1 PHE A  43       2.412  -0.442   1.654  1.00  0.00           C 
ATOM    673  CE2 PHE A  43       3.568  -2.404   2.380  1.00  0.00           C 
ATOM    674  CZ  PHE A  43       3.584  -1.162   1.785  1.00  0.00           C 
ATOM    675  H   PHE A  43       0.906  -3.676   5.583  1.00  0.00           H 
ATOM    676  HA  PHE A  43      -0.707  -1.348   4.725  1.00  0.00           H 
ATOM    677 2HB  PHE A  43      -0.925  -2.484   2.559  1.00  0.00           H 
ATOM    678 1HB  PHE A  43      -0.056  -3.887   3.170  1.00  0.00           H 
ATOM    679  HD1 PHE A  43       0.310  -0.387   2.039  1.00  0.00           H 
ATOM    680  HD2 PHE A  43       2.380  -3.902   3.315  1.00  0.00           H 
ATOM    681  HE1 PHE A  43       2.428   0.532   1.185  1.00  0.00           H 
ATOM    682  HE2 PHE A  43       4.484  -2.969   2.482  1.00  0.00           H 
ATOM    683  HZ  PHE A  43       4.514  -0.756   1.408  1.00  0.00           H 
ATOM    684  N   ASP A  44      -2.997  -2.470   4.833  1.00  0.00           N 
ATOM    685  CA  ASP A  44      -4.359  -3.047   4.955  1.00  0.00           C 
ATOM    686  C   ASP A  44      -5.135  -2.746   3.672  1.00  0.00           C 
ATOM    687  O   ASP A  44      -5.175  -1.593   3.244  1.00  0.00           O 
ATOM    688  CB  ASP A  44      -5.142  -2.432   6.150  1.00  0.00           C 
ATOM    689  CG  ASP A  44      -4.435  -2.600   7.496  1.00  0.00           C 
ATOM    690  OD1 ASP A  44      -4.476  -3.711   8.067  1.00  0.00           O 
ATOM    691  OD2 ASP A  44      -3.835  -1.624   7.994  1.00  0.00           O 
ATOM    692  H   ASP A  44      -2.927  -1.527   4.586  1.00  0.00           H 
ATOM    693  HA  ASP A  44      -4.283  -4.124   5.087  1.00  0.00           H 
ATOM    694 2HB  ASP A  44      -6.122  -2.905   6.218  1.00  0.00           H 
ATOM    695 1HB  ASP A  44      -5.294  -1.372   5.965  1.00  0.00           H 
ATOM    696  N   MET A  45      -5.741  -3.765   3.047  1.00  0.00           N 
ATOM    697  CA  MET A  45      -6.638  -3.568   1.890  1.00  0.00           C 
ATOM    698  C   MET A  45      -8.014  -4.187   2.170  1.00  0.00           C 
ATOM    699  O   MET A  45      -8.100  -5.355   2.536  1.00  0.00           O 
ATOM    700  CB  MET A  45      -6.005  -4.167   0.603  1.00  0.00           C 
ATOM    701  CG  MET A  45      -4.753  -3.414   0.113  1.00  0.00           C 
ATOM    702  SD  MET A  45      -4.014  -4.131  -1.369  1.00  0.00           S 
ATOM    703  CE  MET A  45      -5.384  -4.102  -2.520  1.00  0.00           C 
ATOM    704  H   MET A  45      -5.569  -4.680   3.348  1.00  0.00           H 
ATOM    705  HA  MET A  45      -6.772  -2.500   1.743  1.00  0.00           H 
ATOM    706 2HB  MET A  45      -6.742  -4.148  -0.195  1.00  0.00           H 
ATOM    707 1HB  MET A  45      -5.730  -5.198   0.790  1.00  0.00           H 
ATOM    708 2HG  MET A  45      -4.008  -3.421   0.899  1.00  0.00           H 
ATOM    709 1HG  MET A  45      -5.023  -2.389  -0.106  1.00  0.00           H 
ATOM    710 1HE  MET A  45      -5.707  -3.084  -2.675  1.00  0.00           H 
ATOM    711 2HE  MET A  45      -6.202  -4.688  -2.125  1.00  0.00           H 
ATOM    712 3HE  MET A  45      -5.065  -4.525  -3.464  1.00  0.00           H 
ATOM    713  N   ASP A  46      -9.090  -3.404   1.953  1.00  0.00           N 
ATOM    714  CA  ASP A  46     -10.474  -3.828   2.282  1.00  0.00           C 
ATOM    715  C   ASP A  46     -11.513  -3.099   1.399  1.00  0.00           C 
ATOM    716  O   ASP A  46     -11.311  -1.950   1.014  1.00  0.00           O 
ATOM    717  CB  ASP A  46     -10.780  -3.593   3.790  1.00  0.00           C 
ATOM    718  CG  ASP A  46     -10.745  -2.111   4.211  1.00  0.00           C 
ATOM    719  OD1 ASP A  46     -11.805  -1.546   4.557  1.00  0.00           O 
ATOM    720  OD2 ASP A  46      -9.656  -1.509   4.211  1.00  0.00           O 
ATOM    721  H   ASP A  46      -8.952  -2.513   1.571  1.00  0.00           H 
ATOM    722  HA  ASP A  46     -10.546  -4.898   2.083  1.00  0.00           H 
ATOM    723 2HB  ASP A  46     -10.047  -4.131   4.380  1.00  0.00           H 
ATOM    724 1HB  ASP A  46     -11.762  -4.005   4.020  1.00  0.00           H 
ATOM    725  N   GLY A  47     -12.619  -3.795   1.091  1.00  0.00           N 
ATOM    726  CA  GLY A  47     -13.722  -3.249   0.274  1.00  0.00           C 
ATOM    727  C   GLY A  47     -14.694  -4.355  -0.109  1.00  0.00           C 
ATOM    728  O   GLY A  47     -14.804  -5.329   0.638  1.00  0.00           O 
ATOM    729  H   GLY A  47     -12.691  -4.719   1.419  1.00  0.00           H 
ATOM    730 2HA  GLY A  47     -13.317  -2.800  -0.624  1.00  0.00           H 
ATOM    731 1HA  GLY A  47     -14.251  -2.496   0.842  1.00  0.00           H 
ATOM    732  N   GLU A  48     -15.392  -4.242  -1.265  1.00  0.00           N 
ATOM    733  CA  GLU A  48     -16.205  -5.349  -1.807  1.00  0.00           C 
ATOM    734  C   GLU A  48     -16.282  -5.277  -3.350  1.00  0.00           C 
ATOM    735  O   GLU A  48     -16.906  -4.393  -3.934  1.00  0.00           O 
ATOM    736  CB  GLU A  48     -17.629  -5.382  -1.180  1.00  0.00           C 
ATOM    737  CG  GLU A  48     -18.451  -4.078  -1.306  1.00  0.00           C 
ATOM    738  CD  GLU A  48     -19.870  -4.198  -0.729  1.00  0.00           C 
ATOM    739  OE1 GLU A  48     -20.103  -3.774   0.426  1.00  0.00           O 
ATOM    740  OE2 GLU A  48     -20.767  -4.707  -1.437  1.00  0.00           O 
ATOM    741  H   GLU A  48     -15.343  -3.411  -1.783  1.00  0.00           H 
ATOM    742  HA  GLU A  48     -15.700  -6.277  -1.540  1.00  0.00           H 
ATOM    743 2HB  GLU A  48     -17.534  -5.625  -0.123  1.00  0.00           H 
ATOM    744 1HB  GLU A  48     -18.179  -6.183  -1.660  1.00  0.00           H 
ATOM    745 2HG  GLU A  48     -18.525  -3.815  -2.357  1.00  0.00           H 
ATOM    746 1HG  GLU A  48     -17.923  -3.282  -0.789  1.00  0.00           H 
ATOM    747  N   ILE A  49     -15.591  -6.224  -3.993  1.00  0.00           N 
ATOM    748  CA  ILE A  49     -15.570  -6.320  -5.474  1.00  0.00           C 
ATOM    749  C   ILE A  49     -16.518  -7.408  -5.978  1.00  0.00           C 
ATOM    750  O   ILE A  49     -16.443  -8.551  -5.529  1.00  0.00           O 
ATOM    751  CB  ILE A  49     -14.120  -6.577  -6.000  1.00  0.00           C 
ATOM    752  CG1 ILE A  49     -13.161  -5.456  -5.479  1.00  0.00           C 
ATOM    753  CG2 ILE A  49     -14.096  -6.661  -7.553  1.00  0.00           C 
ATOM    754  CD1 ILE A  49     -11.703  -5.680  -5.795  1.00  0.00           C 
ATOM    755  H   ILE A  49     -14.919  -6.673  -3.456  1.00  0.00           H 
ATOM    756  HA  ILE A  49     -15.899  -5.358  -5.875  1.00  0.00           H 
ATOM    757  HB  ILE A  49     -13.791  -7.539  -5.605  1.00  0.00           H 
ATOM    758 2HG1 ILE A  49     -13.252  -5.384  -4.399  1.00  0.00           H 
ATOM    759 1HG1 ILE A  49     -13.444  -4.507  -5.914  1.00  0.00           H 
ATOM    760 1HG2 ILE A  49     -14.443  -5.727  -7.981  1.00  0.00           H 
ATOM    761 2HG2 ILE A  49     -14.741  -7.463  -7.890  1.00  0.00           H 
ATOM    762 3HG2 ILE A  49     -13.087  -6.857  -7.893  1.00  0.00           H 
ATOM    763 1HD1 ILE A  49     -11.357  -6.578  -5.305  1.00  0.00           H 
ATOM    764 2HD1 ILE A  49     -11.132  -4.838  -5.439  1.00  0.00           H 
ATOM    765 3HD1 ILE A  49     -11.570  -5.777  -6.862  1.00  0.00           H 
ATOM    766  N   ASP A  50     -17.397  -7.008  -6.934  1.00  0.00           N 
ATOM    767  CA  ASP A  50     -18.531  -7.814  -7.434  1.00  0.00           C 
ATOM    768  C   ASP A  50     -19.528  -8.069  -6.270  1.00  0.00           C 
ATOM    769  O   ASP A  50     -20.337  -8.997  -6.290  1.00  0.00           O 
ATOM    770  CB  ASP A  50     -18.011  -9.132  -8.115  1.00  0.00           C 
ATOM    771  CG  ASP A  50     -19.090  -9.936  -8.867  1.00  0.00           C 
ATOM    772  OD1 ASP A  50     -19.443 -11.057  -8.433  1.00  0.00           O 
ATOM    773  OD2 ASP A  50     -19.597  -9.443  -9.897  1.00  0.00           O 
ATOM    774  H   ASP A  50     -17.271  -6.119  -7.317  1.00  0.00           H 
ATOM    775  HA  ASP A  50     -19.041  -7.211  -8.175  1.00  0.00           H 
ATOM    776 2HB  ASP A  50     -17.568  -9.762  -7.349  1.00  0.00           H 
ATOM    777 1HB  ASP A  50     -17.234  -8.873  -8.826  1.00  0.00           H 
ATOM    778  N   GLY A  51     -19.455  -7.185  -5.247  1.00  0.00           N 
ATOM    779  CA  GLY A  51     -20.244  -7.313  -4.024  1.00  0.00           C 
ATOM    780  C   GLY A  51     -19.589  -8.192  -2.966  1.00  0.00           C 
ATOM    781  O   GLY A  51     -20.138  -8.337  -1.869  1.00  0.00           O 
ATOM    782  H   GLY A  51     -18.830  -6.434  -5.322  1.00  0.00           H 
ATOM    783 2HA  GLY A  51     -21.219  -7.726  -4.262  1.00  0.00           H 
ATOM    784 1HA  GLY A  51     -20.384  -6.328  -3.605  1.00  0.00           H 
ATOM    785  N   LYS A  52     -18.422  -8.797  -3.291  1.00  0.00           N 
ATOM    786  CA  LYS A  52     -17.698  -9.716  -2.394  1.00  0.00           C 
ATOM    787  C   LYS A  52     -16.756  -8.966  -1.440  1.00  0.00           C 
ATOM    788  O   LYS A  52     -15.719  -8.451  -1.887  1.00  0.00           O 
ATOM    789  CB  LYS A  52     -16.897 -10.749  -3.231  1.00  0.00           C 
ATOM    790  CG  LYS A  52     -17.778 -11.707  -4.067  1.00  0.00           C 
ATOM    791  CD  LYS A  52     -18.702 -12.570  -3.172  1.00  0.00           C 
ATOM    792  CE  LYS A  52     -19.616 -13.512  -3.970  1.00  0.00           C 
ATOM    793  NZ  LYS A  52     -20.494 -14.303  -3.071  1.00  0.00           N 
ATOM    794  H   LYS A  52     -18.037  -8.656  -4.176  1.00  0.00           H 
ATOM    795  HA  LYS A  52     -18.424 -10.243  -1.814  1.00  0.00           H 
ATOM    796 2HB  LYS A  52     -16.280 -11.346  -2.561  1.00  0.00           H 
ATOM    797 1HB  LYS A  52     -16.239 -10.205  -3.907  1.00  0.00           H 
ATOM    798 2HG  LYS A  52     -17.133 -12.362  -4.643  1.00  0.00           H 
ATOM    799 1HG  LYS A  52     -18.391 -11.121  -4.745  1.00  0.00           H 
ATOM    800 2HD  LYS A  52     -19.322 -11.914  -2.569  1.00  0.00           H 
ATOM    801 1HD  LYS A  52     -18.085 -13.170  -2.511  1.00  0.00           H 
ATOM    802 2HE  LYS A  52     -19.008 -14.192  -4.553  1.00  0.00           H 
ATOM    803 1HE  LYS A  52     -20.240 -12.926  -4.635  1.00  0.00           H 
ATOM    804 1HZ  LYS A  52     -19.920 -14.924  -2.473  1.00  0.00           H 
ATOM    805 2HZ  LYS A  52     -21.150 -14.884  -3.627  1.00  0.00           H 
ATOM    806 3HZ  LYS A  52     -21.046 -13.663  -2.461  1.00  0.00           H 
ATOM    807  N   PRO A  53     -17.078  -8.923  -0.103  1.00  0.00           N 
ATOM    808  CA  PRO A  53     -16.271  -8.193   0.891  1.00  0.00           C 
ATOM    809  C   PRO A  53     -14.951  -8.920   1.207  1.00  0.00           C 
ATOM    810  O   PRO A  53     -14.908 -10.159   1.282  1.00  0.00           O 
ATOM    811  CB  PRO A  53     -17.206  -8.117   2.123  1.00  0.00           C 
ATOM    812  CG  PRO A  53     -18.041  -9.359   2.027  1.00  0.00           C 
ATOM    813  CD  PRO A  53     -18.242  -9.606   0.542  1.00  0.00           C 
ATOM    814  HA  PRO A  53     -16.048  -7.186   0.541  1.00  0.00           H 
ATOM    815 2HB  PRO A  53     -17.820  -7.221   2.063  1.00  0.00           H 
ATOM    816 1HB  PRO A  53     -16.625  -8.090   3.041  1.00  0.00           H 
ATOM    817 2HG  PRO A  53     -18.993  -9.209   2.524  1.00  0.00           H 
ATOM    818 1HG  PRO A  53     -17.514 -10.194   2.483  1.00  0.00           H 
ATOM    819 2HD  PRO A  53     -19.175  -9.168   0.201  1.00  0.00           H 
ATOM    820 1HD  PRO A  53     -18.233 -10.669   0.326  1.00  0.00           H 
ATOM    821  N   PHE A  54     -13.879  -8.138   1.392  1.00  0.00           N 
ATOM    822  CA  PHE A  54     -12.543  -8.666   1.695  1.00  0.00           C 
ATOM    823  C   PHE A  54     -11.845  -7.771   2.719  1.00  0.00           C 
ATOM    824  O   PHE A  54     -12.084  -6.561   2.760  1.00  0.00           O 
ATOM    825  CB  PHE A  54     -11.685  -8.813   0.400  1.00  0.00           C 
ATOM    826  CG  PHE A  54     -11.315  -7.508  -0.332  1.00  0.00           C 
ATOM    827  CD1 PHE A  54     -12.199  -6.909  -1.232  1.00  0.00           C 
ATOM    828  CD2 PHE A  54     -10.070  -6.901  -0.136  1.00  0.00           C 
ATOM    829  CE1 PHE A  54     -11.851  -5.754  -1.906  1.00  0.00           C 
ATOM    830  CE2 PHE A  54      -9.727  -5.746  -0.808  1.00  0.00           C 
ATOM    831  CZ  PHE A  54     -10.617  -5.173  -1.692  1.00  0.00           C 
ATOM    832  H   PHE A  54     -13.993  -7.167   1.344  1.00  0.00           H 
ATOM    833  HA  PHE A  54     -12.667  -9.654   2.141  1.00  0.00           H 
ATOM    834 2HB  PHE A  54     -12.227  -9.442  -0.299  1.00  0.00           H 
ATOM    835 1HB  PHE A  54     -10.761  -9.322   0.653  1.00  0.00           H 
ATOM    836  HD1 PHE A  54     -13.169  -7.361  -1.401  1.00  0.00           H 
ATOM    837  HD2 PHE A  54      -9.365  -7.347   0.558  1.00  0.00           H 
ATOM    838  HE1 PHE A  54     -12.548  -5.305  -2.600  1.00  0.00           H 
ATOM    839  HE2 PHE A  54      -8.760  -5.289  -0.641  1.00  0.00           H 
ATOM    840  HZ  PHE A  54     -10.346  -4.270  -2.221  1.00  0.00           H 
ATOM    841  N   SER A  55     -11.010  -8.393   3.554  1.00  0.00           N 
ATOM    842  CA  SER A  55     -10.126  -7.707   4.494  1.00  0.00           C 
ATOM    843  C   SER A  55      -8.772  -8.430   4.472  1.00  0.00           C 
ATOM    844  O   SER A  55      -8.675  -9.614   4.824  1.00  0.00           O 
ATOM    845  CB  SER A  55     -10.748  -7.685   5.911  1.00  0.00           C 
ATOM    846  OG  SER A  55     -11.035  -8.997   6.384  1.00  0.00           O 
ATOM    847  H   SER A  55     -11.003  -9.371   3.558  1.00  0.00           H 
ATOM    848  HA  SER A  55      -9.985  -6.680   4.149  1.00  0.00           H 
ATOM    849 2HB  SER A  55     -11.671  -7.120   5.888  1.00  0.00           H 
ATOM    850 1HB  SER A  55     -10.062  -7.212   6.596  1.00  0.00           H 
ATOM    851  HG  SER A  55     -10.208  -9.424   6.634  1.00  0.00           H 
ATOM    852  N   ASP A  56      -7.743  -7.706   4.040  1.00  0.00           N 
ATOM    853  CA  ASP A  56      -6.400  -8.241   3.772  1.00  0.00           C 
ATOM    854  C   ASP A  56      -5.363  -7.364   4.484  1.00  0.00           C 
ATOM    855  O   ASP A  56      -5.573  -6.160   4.649  1.00  0.00           O 
ATOM    856  CB  ASP A  56      -6.149  -8.260   2.235  1.00  0.00           C 
ATOM    857  CG  ASP A  56      -4.816  -8.921   1.840  1.00  0.00           C 
ATOM    858  OD1 ASP A  56      -3.799  -8.216   1.677  1.00  0.00           O 
ATOM    859  OD2 ASP A  56      -4.781 -10.163   1.716  1.00  0.00           O 
ATOM    860  H   ASP A  56      -7.886  -6.752   3.904  1.00  0.00           H 
ATOM    861  HA  ASP A  56      -6.340  -9.256   4.163  1.00  0.00           H 
ATOM    862 2HB  ASP A  56      -6.161  -7.241   1.862  1.00  0.00           H 
ATOM    863 1HB  ASP A  56      -6.960  -8.804   1.756  1.00  0.00           H 
ATOM    864  N   SER A  57      -4.265  -7.976   4.937  1.00  0.00           N 
ATOM    865  CA  SER A  57      -3.132  -7.254   5.530  1.00  0.00           C 
ATOM    866  C   SER A  57      -1.823  -7.933   5.100  1.00  0.00           C 
ATOM    867  O   SER A  57      -1.684  -9.155   5.218  1.00  0.00           O 
ATOM    868  CB  SER A  57      -3.252  -7.219   7.075  1.00  0.00           C 
ATOM    869  OG  SER A  57      -4.499  -6.677   7.494  1.00  0.00           O 
ATOM    870  H   SER A  57      -4.217  -8.952   4.883  1.00  0.00           H 
ATOM    871  HA  SER A  57      -3.137  -6.234   5.151  1.00  0.00           H 
ATOM    872 2HB  SER A  57      -2.456  -6.607   7.486  1.00  0.00           H 
ATOM    873 1HB  SER A  57      -3.175  -8.223   7.469  1.00  0.00           H 
ATOM    874  HG  SER A  57      -4.576  -5.766   7.178  1.00  0.00           H 
ATOM    875  N   PHE A  58      -0.878  -7.134   4.591  1.00  0.00           N 
ATOM    876  CA  PHE A  58       0.451  -7.607   4.164  1.00  0.00           C 
ATOM    877  C   PHE A  58       1.506  -6.595   4.608  1.00  0.00           C 
ATOM    878  O   PHE A  58       1.246  -5.398   4.618  1.00  0.00           O 
ATOM    879  CB  PHE A  58       0.497  -7.850   2.628  1.00  0.00           C 
ATOM    880  CG  PHE A  58       0.152  -6.642   1.736  1.00  0.00           C 
ATOM    881  CD1 PHE A  58       1.153  -5.895   1.109  1.00  0.00           C 
ATOM    882  CD2 PHE A  58      -1.174  -6.277   1.507  1.00  0.00           C 
ATOM    883  CE1 PHE A  58       0.837  -4.837   0.281  1.00  0.00           C 
ATOM    884  CE2 PHE A  58      -1.488  -5.215   0.686  1.00  0.00           C 
ATOM    885  CZ  PHE A  58      -0.484  -4.495   0.071  1.00  0.00           C 
ATOM    886  H   PHE A  58      -1.077  -6.175   4.508  1.00  0.00           H 
ATOM    887  HA  PHE A  58       0.656  -8.551   4.673  1.00  0.00           H 
ATOM    888 2HB  PHE A  58      -0.201  -8.649   2.387  1.00  0.00           H 
ATOM    889 1HB  PHE A  58       1.492  -8.192   2.359  1.00  0.00           H 
ATOM    890  HD1 PHE A  58       2.193  -6.157   1.270  1.00  0.00           H 
ATOM    891  HD2 PHE A  58      -1.968  -6.837   1.988  1.00  0.00           H 
ATOM    892  HE1 PHE A  58       1.627  -4.266  -0.188  1.00  0.00           H 
ATOM    893  HE2 PHE A  58      -2.522  -4.948   0.521  1.00  0.00           H 
ATOM    894  HZ  PHE A  58      -0.732  -3.665  -0.577  1.00  0.00           H 
ATOM    895  N   GLU A  59       2.684  -7.086   5.010  1.00  0.00           N 
ATOM    896  CA  GLU A  59       3.763  -6.250   5.570  1.00  0.00           C 
ATOM    897  C   GLU A  59       5.064  -6.484   4.803  1.00  0.00           C 
ATOM    898  O   GLU A  59       5.443  -7.630   4.539  1.00  0.00           O 
ATOM    899  CB  GLU A  59       3.950  -6.556   7.078  1.00  0.00           C 
ATOM    900  CG  GLU A  59       2.683  -6.318   7.924  1.00  0.00           C 
ATOM    901  CD  GLU A  59       2.854  -6.655   9.415  1.00  0.00           C 
ATOM    902  OE1 GLU A  59       3.364  -7.745   9.738  1.00  0.00           O 
ATOM    903  OE2 GLU A  59       2.457  -5.842  10.271  1.00  0.00           O 
ATOM    904  H   GLU A  59       2.842  -8.049   4.916  1.00  0.00           H 
ATOM    905  HA  GLU A  59       3.479  -5.203   5.461  1.00  0.00           H 
ATOM    906 2HB  GLU A  59       4.743  -5.927   7.472  1.00  0.00           H 
ATOM    907 1HB  GLU A  59       4.245  -7.597   7.196  1.00  0.00           H 
ATOM    908 2HG  GLU A  59       1.889  -6.925   7.523  1.00  0.00           H 
ATOM    909 1HG  GLU A  59       2.397  -5.274   7.823  1.00  0.00           H 
ATOM    910  N   LEU A  60       5.734  -5.386   4.449  1.00  0.00           N 
ATOM    911  CA  LEU A  60       6.993  -5.396   3.690  1.00  0.00           C 
ATOM    912  C   LEU A  60       8.065  -4.632   4.479  1.00  0.00           C 
ATOM    913  O   LEU A  60       7.801  -3.504   4.905  1.00  0.00           O 
ATOM    914  CB  LEU A  60       6.767  -4.752   2.297  1.00  0.00           C 
ATOM    915  CG  LEU A  60       5.928  -5.606   1.289  1.00  0.00           C 
ATOM    916  CD1 LEU A  60       5.480  -4.774   0.071  1.00  0.00           C 
ATOM    917  CD2 LEU A  60       6.721  -6.865   0.849  1.00  0.00           C 
ATOM    918  H   LEU A  60       5.371  -4.515   4.727  1.00  0.00           H 
ATOM    919  HA  LEU A  60       7.314  -6.425   3.555  1.00  0.00           H 
ATOM    920 2HB  LEU A  60       7.736  -4.555   1.843  1.00  0.00           H 
ATOM    921 1HB  LEU A  60       6.266  -3.799   2.442  1.00  0.00           H 
ATOM    922  HG  LEU A  60       5.028  -5.947   1.790  1.00  0.00           H 
ATOM    923 1HD1 LEU A  60       6.345  -4.370  -0.440  1.00  0.00           H 
ATOM    924 2HD1 LEU A  60       4.846  -3.958   0.400  1.00  0.00           H 
ATOM    925 3HD1 LEU A  60       4.919  -5.400  -0.612  1.00  0.00           H 
ATOM    926 1HD2 LEU A  60       6.968  -7.466   1.715  1.00  0.00           H 
ATOM    927 2HD2 LEU A  60       7.633  -6.572   0.344  1.00  0.00           H 
ATOM    928 3HD2 LEU A  60       6.114  -7.456   0.174  1.00  0.00           H 
ATOM    929  N   PRO A  61       9.283  -5.234   4.700  1.00  0.00           N 
ATOM    930  CA  PRO A  61      10.419  -4.533   5.347  1.00  0.00           C 
ATOM    931  C   PRO A  61      10.906  -3.349   4.498  1.00  0.00           C 
ATOM    932  O   PRO A  61      10.579  -3.277   3.318  1.00  0.00           O 
ATOM    933  CB  PRO A  61      11.498  -5.639   5.481  1.00  0.00           C 
ATOM    934  CG  PRO A  61      11.162  -6.628   4.410  1.00  0.00           C 
ATOM    935  CD  PRO A  61       9.650  -6.630   4.333  1.00  0.00           C 
ATOM    936  HA  PRO A  61      10.145  -4.169   6.326  1.00  0.00           H 
ATOM    937 2HB  PRO A  61      11.429  -6.090   6.466  1.00  0.00           H 
ATOM    938 1HB  PRO A  61      12.493  -5.228   5.348  1.00  0.00           H 
ATOM    939 2HG  PRO A  61      11.533  -7.611   4.678  1.00  0.00           H 
ATOM    940 1HG  PRO A  61      11.594  -6.314   3.460  1.00  0.00           H 
ATOM    941 2HD  PRO A  61       9.229  -7.336   5.042  1.00  0.00           H 
ATOM    942 1HD  PRO A  61       9.321  -6.870   3.327  1.00  0.00           H 
ATOM    943  N   ARG A  62      11.653  -2.422   5.123  1.00  0.00           N 
ATOM    944  CA  ARG A  62      12.271  -1.254   4.439  1.00  0.00           C 
ATOM    945  C   ARG A  62      12.963  -1.628   3.088  1.00  0.00           C 
ATOM    946  O   ARG A  62      12.952  -0.840   2.133  1.00  0.00           O 
ATOM    947  CB  ARG A  62      13.292  -0.566   5.391  1.00  0.00           C 
ATOM    948  CG  ARG A  62      14.632  -1.326   5.562  1.00  0.00           C 
ATOM    949  CD  ARG A  62      15.616  -0.656   6.537  1.00  0.00           C 
ATOM    950  NE  ARG A  62      16.993  -1.161   6.352  1.00  0.00           N 
ATOM    951  CZ  ARG A  62      17.438  -2.395   6.676  1.00  0.00           C 
ATOM    952  NH1 ARG A  62      16.658  -3.281   7.289  1.00  0.00           N 
ATOM    953  NH2 ARG A  62      18.687  -2.727   6.402  1.00  0.00           N 
ATOM    954  H   ARG A  62      11.711  -2.470   6.099  1.00  0.00           H 
ATOM    955  HA  ARG A  62      11.467  -0.556   4.227  1.00  0.00           H 
ATOM    956 2HB  ARG A  62      12.835  -0.466   6.370  1.00  0.00           H 
ATOM    957 1HB  ARG A  62      13.507   0.428   5.015  1.00  0.00           H 
ATOM    958 2HG  ARG A  62      15.107  -1.402   4.588  1.00  0.00           H 
ATOM    959 1HG  ARG A  62      14.420  -2.327   5.924  1.00  0.00           H 
ATOM    960 2HD  ARG A  62      15.301  -0.847   7.558  1.00  0.00           H 
ATOM    961 1HD  ARG A  62      15.617   0.414   6.361  1.00  0.00           H 
ATOM    962  HE  ARG A  62      17.628  -0.538   5.934  1.00  0.00           H 
ATOM    963 1HH1 ARG A  62      15.710  -3.048   7.528  1.00  0.00           H 
ATOM    964 2HH1 ARG A  62      17.013  -4.192   7.519  1.00  0.00           H 
ATOM    965 1HH2 ARG A  62      19.298  -2.070   5.954  1.00  0.00           H 
ATOM    966 2HH2 ARG A  62      19.029  -3.640   6.645  1.00  0.00           H 
ATOM    967  N   ASP A  63      13.509  -2.863   3.034  1.00  0.00           N 
ATOM    968  CA  ASP A  63      14.270  -3.396   1.889  1.00  0.00           C 
ATOM    969  C   ASP A  63      13.370  -3.680   0.662  1.00  0.00           C 
ATOM    970  O   ASP A  63      13.822  -3.557  -0.479  1.00  0.00           O 
ATOM    971  CB  ASP A  63      15.014  -4.687   2.337  1.00  0.00           C 
ATOM    972  CG  ASP A  63      15.954  -5.276   1.264  1.00  0.00           C 
ATOM    973  OD1 ASP A  63      17.051  -4.718   1.056  1.00  0.00           O 
ATOM    974  OD2 ASP A  63      15.602  -6.289   0.624  1.00  0.00           O 
ATOM    975  H   ASP A  63      13.394  -3.443   3.813  1.00  0.00           H 
ATOM    976  HA  ASP A  63      15.009  -2.648   1.614  1.00  0.00           H 
ATOM    977 2HB  ASP A  63      14.279  -5.438   2.613  1.00  0.00           H 
ATOM    978 1HB  ASP A  63      15.608  -4.456   3.214  1.00  0.00           H 
ATOM    979  N   THR A  64      12.090  -4.015   0.902  1.00  0.00           N 
ATOM    980  CA  THR A  64      11.126  -4.404  -0.155  1.00  0.00           C 
ATOM    981  C   THR A  64       9.813  -3.608  -0.002  1.00  0.00           C 
ATOM    982  O   THR A  64       8.790  -3.966  -0.596  1.00  0.00           O 
ATOM    983  CB  THR A  64      10.831  -5.948  -0.127  1.00  0.00           C 
ATOM    984  OG1 THR A  64      10.411  -6.339   1.185  1.00  0.00           O 
ATOM    985  CG2 THR A  64      12.059  -6.778  -0.549  1.00  0.00           C 
ATOM    986  H   THR A  64      11.743  -3.920   1.810  1.00  0.00           H 
ATOM    987  HA  THR A  64      11.550  -4.152  -1.125  1.00  0.00           H 
ATOM    988  HB  THR A  64      10.022  -6.158  -0.820  1.00  0.00           H 
ATOM    989  HG1 THR A  64      10.391  -7.298   1.240  1.00  0.00           H 
ATOM    990 1HG2 THR A  64      11.811  -7.830  -0.527  1.00  0.00           H 
ATOM    991 2HG2 THR A  64      12.881  -6.591   0.134  1.00  0.00           H 
ATOM    992 3HG2 THR A  64      12.360  -6.504  -1.552  1.00  0.00           H 
ATOM    993  N   ALA A  65       9.865  -2.507   0.782  1.00  0.00           N 
ATOM    994  CA  ALA A  65       8.704  -1.623   1.020  1.00  0.00           C 
ATOM    995  C   ALA A  65       8.240  -0.960  -0.283  1.00  0.00           C 
ATOM    996  O   ALA A  65       7.048  -0.895  -0.557  1.00  0.00           O 
ATOM    997  CB  ALA A  65       9.049  -0.561   2.074  1.00  0.00           C 
ATOM    998  H   ALA A  65      10.710  -2.304   1.237  1.00  0.00           H 
ATOM    999  HA  ALA A  65       7.897  -2.234   1.412  1.00  0.00           H 
ATOM   1000 1HB  ALA A  65       8.179   0.051   2.277  1.00  0.00           H 
ATOM   1001 2HB  ALA A  65       9.852   0.069   1.716  1.00  0.00           H 
ATOM   1002 3HB  ALA A  65       9.363  -1.049   2.989  1.00  0.00           H 
ATOM   1003  N   PHE A  66       9.221  -0.494  -1.073  1.00  0.00           N 
ATOM   1004  CA  PHE A  66       9.001   0.180  -2.378  1.00  0.00           C 
ATOM   1005  C   PHE A  66       8.574  -0.807  -3.492  1.00  0.00           C 
ATOM   1006  O   PHE A  66       8.283  -0.394  -4.616  1.00  0.00           O 
ATOM   1007  CB  PHE A  66      10.281   0.951  -2.784  1.00  0.00           C 
ATOM   1008  CG  PHE A  66      10.816   1.835  -1.659  1.00  0.00           C 
ATOM   1009  CD1 PHE A  66      11.880   1.414  -0.857  1.00  0.00           C 
ATOM   1010  CD2 PHE A  66      10.223   3.062  -1.377  1.00  0.00           C 
ATOM   1011  CE1 PHE A  66      12.335   2.195   0.184  1.00  0.00           C 
ATOM   1012  CE2 PHE A  66      10.681   3.840  -0.343  1.00  0.00           C 
ATOM   1013  CZ  PHE A  66      11.738   3.406   0.441  1.00  0.00           C 
ATOM   1014  H   PHE A  66      10.131  -0.547  -0.723  1.00  0.00           H 
ATOM   1015  HA  PHE A  66       8.196   0.899  -2.243  1.00  0.00           H 
ATOM   1016 2HB  PHE A  66      10.066   1.586  -3.641  1.00  0.00           H 
ATOM   1017 1HB  PHE A  66      11.057   0.243  -3.069  1.00  0.00           H 
ATOM   1018  HD1 PHE A  66      12.355   0.460  -1.062  1.00  0.00           H 
ATOM   1019  HD2 PHE A  66       9.398   3.409  -1.985  1.00  0.00           H 
ATOM   1020  HE1 PHE A  66      13.161   1.857   0.797  1.00  0.00           H 
ATOM   1021  HE2 PHE A  66      10.216   4.797  -0.137  1.00  0.00           H 
ATOM   1022  HZ  PHE A  66      12.092   4.022   1.258  1.00  0.00           H 
ATOM   1023  N   ASN A  67       8.513  -2.106  -3.156  1.00  0.00           N 
ATOM   1024  CA  ASN A  67       7.995  -3.162  -4.053  1.00  0.00           C 
ATOM   1025  C   ASN A  67       6.468  -3.320  -3.874  1.00  0.00           C 
ATOM   1026  O   ASN A  67       5.854  -4.195  -4.503  1.00  0.00           O 
ATOM   1027  CB  ASN A  67       8.720  -4.508  -3.756  1.00  0.00           C 
ATOM   1028  CG  ASN A  67      10.211  -4.571  -4.147  1.00  0.00           C 
ATOM   1029  OD1 ASN A  67      10.731  -5.648  -4.436  1.00  0.00           O 
ATOM   1030  ND2 ASN A  67      10.922  -3.449  -4.168  1.00  0.00           N 
ATOM   1031  H   ASN A  67       8.812  -2.367  -2.264  1.00  0.00           H 
ATOM   1032  HA  ASN A  67       8.190  -2.868  -5.078  1.00  0.00           H 
ATOM   1033 2HB  ASN A  67       8.202  -5.306  -4.281  1.00  0.00           H 
ATOM   1034 1HB  ASN A  67       8.657  -4.708  -2.694  1.00  0.00           H 
ATOM   1035 2HD2 ASN A  67      10.482  -2.607  -3.940  1.00  0.00           H 
ATOM   1036 1HD2 ASN A  67      11.872  -3.511  -4.405  1.00  0.00           H 
ATOM   1037  N   PHE A  68       5.888  -2.465  -2.994  1.00  0.00           N 
ATOM   1038  CA  PHE A  68       4.460  -2.478  -2.648  1.00  0.00           C 
ATOM   1039  C   PHE A  68       3.555  -2.379  -3.883  1.00  0.00           C 
ATOM   1040  O   PHE A  68       2.650  -3.178  -4.018  1.00  0.00           O 
ATOM   1041  CB  PHE A  68       4.117  -1.352  -1.629  1.00  0.00           C 
ATOM   1042  CG  PHE A  68       4.151   0.080  -2.197  1.00  0.00           C 
ATOM   1043  CD1 PHE A  68       5.359   0.693  -2.541  1.00  0.00           C 
ATOM   1044  CD2 PHE A  68       2.977   0.791  -2.415  1.00  0.00           C 
ATOM   1045  CE1 PHE A  68       5.393   1.956  -3.083  1.00  0.00           C 
ATOM   1046  CE2 PHE A  68       3.011   2.057  -2.954  1.00  0.00           C 
ATOM   1047  CZ  PHE A  68       4.217   2.642  -3.290  1.00  0.00           C 
ATOM   1048  H   PHE A  68       6.476  -1.848  -2.515  1.00  0.00           H 
ATOM   1049  HA  PHE A  68       4.273  -3.435  -2.162  1.00  0.00           H 
ATOM   1050 2HB  PHE A  68       4.820  -1.402  -0.807  1.00  0.00           H 
ATOM   1051 1HB  PHE A  68       3.124  -1.537  -1.229  1.00  0.00           H 
ATOM   1052  HD1 PHE A  68       6.281   0.154  -2.377  1.00  0.00           H 
ATOM   1053  HD2 PHE A  68       2.023   0.342  -2.156  1.00  0.00           H 
ATOM   1054  HE1 PHE A  68       6.341   2.412  -3.342  1.00  0.00           H 
ATOM   1055  HE2 PHE A  68       2.090   2.593  -3.116  1.00  0.00           H 
ATOM   1056  HZ  PHE A  68       4.238   3.638  -3.714  1.00  0.00           H 
ATOM   1057  N   ALA A  69       3.812  -1.395  -4.779  1.00  0.00           N 
ATOM   1058  CA  ALA A  69       2.968  -1.129  -5.968  1.00  0.00           C 
ATOM   1059  C   ALA A  69       2.750  -2.362  -6.864  1.00  0.00           C 
ATOM   1060  O   ALA A  69       1.723  -2.452  -7.540  1.00  0.00           O 
ATOM   1061  CB  ALA A  69       3.541   0.035  -6.782  1.00  0.00           C 
ATOM   1062  H   ALA A  69       4.534  -0.753  -4.600  1.00  0.00           H 
ATOM   1063  HA  ALA A  69       1.995  -0.814  -5.591  1.00  0.00           H 
ATOM   1064 1HB  ALA A  69       2.866   0.291  -7.588  1.00  0.00           H 
ATOM   1065 2HB  ALA A  69       4.501  -0.244  -7.192  1.00  0.00           H 
ATOM   1066 3HB  ALA A  69       3.669   0.898  -6.138  1.00  0.00           H 
ATOM   1067  N   SER A  70       3.719  -3.295  -6.867  1.00  0.00           N 
ATOM   1068  CA  SER A  70       3.591  -4.571  -7.581  1.00  0.00           C 
ATOM   1069  C   SER A  70       2.582  -5.487  -6.856  1.00  0.00           C 
ATOM   1070  O   SER A  70       1.629  -5.966  -7.467  1.00  0.00           O 
ATOM   1071  CB  SER A  70       4.982  -5.244  -7.682  1.00  0.00           C 
ATOM   1072  OG  SER A  70       5.938  -4.362  -8.264  1.00  0.00           O 
ATOM   1073  H   SER A  70       4.539  -3.131  -6.357  1.00  0.00           H 
ATOM   1074  HA  SER A  70       3.231  -4.362  -8.588  1.00  0.00           H 
ATOM   1075 2HB  SER A  70       4.914  -6.133  -8.297  1.00  0.00           H 
ATOM   1076 1HB  SER A  70       5.327  -5.519  -6.692  1.00  0.00           H 
ATOM   1077  HG  SER A  70       5.510  -3.523  -8.482  1.00  0.00           H 
ATOM   1078  N   ASP A  71       2.790  -5.676  -5.533  1.00  0.00           N 
ATOM   1079  CA  ASP A  71       1.988  -6.621  -4.716  1.00  0.00           C 
ATOM   1080  C   ASP A  71       0.567  -6.097  -4.432  1.00  0.00           C 
ATOM   1081  O   ASP A  71      -0.396  -6.816  -4.628  1.00  0.00           O 
ATOM   1082  CB  ASP A  71       2.705  -6.946  -3.384  1.00  0.00           C 
ATOM   1083  CG  ASP A  71       1.993  -8.057  -2.582  1.00  0.00           C 
ATOM   1084  OD1 ASP A  71       1.260  -7.755  -1.614  1.00  0.00           O 
ATOM   1085  OD2 ASP A  71       2.157  -9.243  -2.934  1.00  0.00           O 
ATOM   1086  H   ASP A  71       3.516  -5.175  -5.094  1.00  0.00           H 
ATOM   1087  HA  ASP A  71       1.904  -7.537  -5.293  1.00  0.00           H 
ATOM   1088 2HB  ASP A  71       2.758  -6.045  -2.779  1.00  0.00           H 
ATOM   1089 1HB  ASP A  71       3.718  -7.271  -3.602  1.00  0.00           H 
ATOM   1090  N   ALA A  72       0.477  -4.860  -3.910  1.00  0.00           N 
ATOM   1091  CA  ALA A  72      -0.798  -4.140  -3.659  1.00  0.00           C 
ATOM   1092  C   ALA A  72      -1.756  -4.176  -4.870  1.00  0.00           C 
ATOM   1093  O   ALA A  72      -2.974  -4.266  -4.708  1.00  0.00           O 
ATOM   1094  CB  ALA A  72      -0.501  -2.686  -3.254  1.00  0.00           C 
ATOM   1095  H   ALA A  72       1.301  -4.443  -3.622  1.00  0.00           H 
ATOM   1096  HA  ALA A  72      -1.282  -4.625  -2.815  1.00  0.00           H 
ATOM   1097 1HB  ALA A  72      -0.029  -2.167  -4.079  1.00  0.00           H 
ATOM   1098 2HB  ALA A  72       0.170  -2.678  -2.402  1.00  0.00           H 
ATOM   1099 3HB  ALA A  72      -1.419  -2.180  -2.988  1.00  0.00           H 
ATOM   1100  N   THR A  73      -1.182  -4.106  -6.079  1.00  0.00           N 
ATOM   1101  CA  THR A  73      -1.939  -4.250  -7.332  1.00  0.00           C 
ATOM   1102  C   THR A  73      -2.302  -5.733  -7.594  1.00  0.00           C 
ATOM   1103  O   THR A  73      -3.441  -6.040  -7.949  1.00  0.00           O 
ATOM   1104  CB  THR A  73      -1.141  -3.667  -8.538  1.00  0.00           C 
ATOM   1105  OG1 THR A  73      -0.950  -2.253  -8.349  1.00  0.00           O 
ATOM   1106  CG2 THR A  73      -1.846  -3.916  -9.880  1.00  0.00           C 
ATOM   1107  H   THR A  73      -0.217  -3.955  -6.116  1.00  0.00           H 
ATOM   1108  HA  THR A  73      -2.862  -3.679  -7.229  1.00  0.00           H 
ATOM   1109  HB  THR A  73      -0.162  -4.143  -8.567  1.00  0.00           H 
ATOM   1110  HG1 THR A  73      -0.325  -2.116  -7.632  1.00  0.00           H 
ATOM   1111 1HG2 THR A  73      -2.838  -3.479  -9.862  1.00  0.00           H 
ATOM   1112 2HG2 THR A  73      -1.929  -4.981 -10.062  1.00  0.00           H 
ATOM   1113 3HG2 THR A  73      -1.277  -3.464 -10.679  1.00  0.00           H 
ATOM   1114  N   ARG A  74      -1.316  -6.626  -7.391  1.00  0.00           N 
ATOM   1115  CA  ARG A  74      -1.441  -8.090  -7.607  1.00  0.00           C 
ATOM   1116  C   ARG A  74      -2.608  -8.699  -6.792  1.00  0.00           C 
ATOM   1117  O   ARG A  74      -3.410  -9.475  -7.319  1.00  0.00           O 
ATOM   1118  CB  ARG A  74      -0.091  -8.770  -7.248  1.00  0.00           C 
ATOM   1119  CG  ARG A  74      -0.047 -10.304  -7.400  1.00  0.00           C 
ATOM   1120  CD  ARG A  74       1.334 -10.879  -7.031  1.00  0.00           C 
ATOM   1121  NE  ARG A  74       1.378 -12.353  -7.150  1.00  0.00           N 
ATOM   1122  CZ  ARG A  74       2.390 -13.063  -7.676  1.00  0.00           C 
ATOM   1123  NH1 ARG A  74       3.445 -12.456  -8.206  1.00  0.00           N 
ATOM   1124  NH2 ARG A  74       2.331 -14.384  -7.672  1.00  0.00           N 
ATOM   1125  H   ARG A  74      -0.452  -6.280  -7.089  1.00  0.00           H 
ATOM   1126  HA  ARG A  74      -1.637  -8.245  -8.663  1.00  0.00           H 
ATOM   1127 2HB  ARG A  74       0.154  -8.524  -6.217  1.00  0.00           H 
ATOM   1128 1HB  ARG A  74       0.680  -8.350  -7.884  1.00  0.00           H 
ATOM   1129 2HG  ARG A  74      -0.277 -10.564  -8.428  1.00  0.00           H 
ATOM   1130 1HG  ARG A  74      -0.793 -10.745  -6.746  1.00  0.00           H 
ATOM   1131 2HD  ARG A  74       1.564 -10.611  -6.006  1.00  0.00           H 
ATOM   1132 1HD  ARG A  74       2.079 -10.441  -7.686  1.00  0.00           H 
ATOM   1133  HE  ARG A  74       0.607 -12.843  -6.783  1.00  0.00           H 
ATOM   1134 1HH1 ARG A  74       3.497 -11.456  -8.217  1.00  0.00           H 
ATOM   1135 2HH1 ARG A  74       4.199 -12.995  -8.593  1.00  0.00           H 
ATOM   1136 1HH2 ARG A  74       1.536 -14.855  -7.274  1.00  0.00           H 
ATOM   1137 2HH2 ARG A  74       3.080 -14.921  -8.064  1.00  0.00           H 
ATOM   1138  N   VAL A  75      -2.703  -8.307  -5.518  1.00  0.00           N 
ATOM   1139  CA  VAL A  75      -3.766  -8.751  -4.603  1.00  0.00           C 
ATOM   1140  C   VAL A  75      -5.114  -8.080  -4.955  1.00  0.00           C 
ATOM   1141  O   VAL A  75      -6.171  -8.698  -4.806  1.00  0.00           O 
ATOM   1142  CB  VAL A  75      -3.361  -8.516  -3.094  1.00  0.00           C 
ATOM   1143  CG1 VAL A  75      -3.126  -7.030  -2.774  1.00  0.00           C 
ATOM   1144  CG2 VAL A  75      -4.377  -9.140  -2.108  1.00  0.00           C 
ATOM   1145  H   VAL A  75      -2.036  -7.687  -5.180  1.00  0.00           H 
ATOM   1146  HA  VAL A  75      -3.882  -9.821  -4.750  1.00  0.00           H 
ATOM   1147  HB  VAL A  75      -2.410  -9.027  -2.942  1.00  0.00           H 
ATOM   1148 1HG1 VAL A  75      -4.042  -6.472  -2.932  1.00  0.00           H 
ATOM   1149 2HG1 VAL A  75      -2.354  -6.633  -3.419  1.00  0.00           H 
ATOM   1150 3HG1 VAL A  75      -2.816  -6.920  -1.741  1.00  0.00           H 
ATOM   1151 1HG2 VAL A  75      -4.472 -10.201  -2.297  1.00  0.00           H 
ATOM   1152 2HG2 VAL A  75      -5.345  -8.669  -2.230  1.00  0.00           H 
ATOM   1153 3HG2 VAL A  75      -4.037  -8.991  -1.089  1.00  0.00           H 
ATOM   1154  N   ALA A  76      -5.063  -6.833  -5.477  1.00  0.00           N 
ATOM   1155  CA  ALA A  76      -6.268  -6.064  -5.850  1.00  0.00           C 
ATOM   1156  C   ALA A  76      -6.974  -6.713  -7.054  1.00  0.00           C 
ATOM   1157  O   ALA A  76      -8.201  -6.859  -7.069  1.00  0.00           O 
ATOM   1158  CB  ALA A  76      -5.889  -4.613  -6.184  1.00  0.00           C 
ATOM   1159  H   ALA A  76      -4.191  -6.435  -5.679  1.00  0.00           H 
ATOM   1160  HA  ALA A  76      -6.941  -6.053  -4.995  1.00  0.00           H 
ATOM   1161 1HB  ALA A  76      -5.212  -4.599  -7.029  1.00  0.00           H 
ATOM   1162 2HB  ALA A  76      -5.399  -4.157  -5.331  1.00  0.00           H 
ATOM   1163 3HB  ALA A  76      -6.776  -4.046  -6.429  1.00  0.00           H 
ATOM   1164  N   GLN A  77      -6.162  -7.125  -8.042  1.00  0.00           N 
ATOM   1165  CA  GLN A  77      -6.653  -7.753  -9.279  1.00  0.00           C 
ATOM   1166  C   GLN A  77      -7.008  -9.228  -9.051  1.00  0.00           C 
ATOM   1167  O   GLN A  77      -7.849  -9.785  -9.772  1.00  0.00           O 
ATOM   1168  CB  GLN A  77      -5.651  -7.583 -10.449  1.00  0.00           C 
ATOM   1169  CG  GLN A  77      -4.273  -8.216 -10.229  1.00  0.00           C 
ATOM   1170  CD  GLN A  77      -3.381  -8.128 -11.464  1.00  0.00           C 
ATOM   1171  OE1 GLN A  77      -2.637  -7.160 -11.649  1.00  0.00           O 
ATOM   1172  NE2 GLN A  77      -3.459  -9.133 -12.325  1.00  0.00           N 
ATOM   1173  H   GLN A  77      -5.199  -7.018  -7.910  1.00  0.00           H 
ATOM   1174  HA  GLN A  77      -7.571  -7.239  -9.551  1.00  0.00           H 
ATOM   1175 2HB  GLN A  77      -5.512  -6.520 -10.629  1.00  0.00           H 
ATOM   1176 1HB  GLN A  77      -6.092  -8.021 -11.342  1.00  0.00           H 
ATOM   1177 2HG  GLN A  77      -4.402  -9.260  -9.959  1.00  0.00           H 
ATOM   1178 1HG  GLN A  77      -3.785  -7.701  -9.411  1.00  0.00           H 
ATOM   1179 2HE2 GLN A  77      -4.075  -9.868 -12.125  1.00  0.00           H 
ATOM   1180 1HE2 GLN A  77      -2.893  -9.102 -13.125  1.00  0.00           H 
ATOM   1181  N   LYS A  78      -6.365  -9.857  -8.043  1.00  0.00           N 
ATOM   1182  CA  LYS A  78      -6.742 -11.199  -7.557  1.00  0.00           C 
ATOM   1183  C   LYS A  78      -8.146 -11.164  -6.911  1.00  0.00           C 
ATOM   1184  O   LYS A  78      -8.851 -12.172  -6.875  1.00  0.00           O 
ATOM   1185  CB  LYS A  78      -5.672 -11.721  -6.555  1.00  0.00           C 
ATOM   1186  CG  LYS A  78      -5.885 -13.175  -6.073  1.00  0.00           C 
ATOM   1187  CD  LYS A  78      -4.740 -13.696  -5.165  1.00  0.00           C 
ATOM   1188  CE  LYS A  78      -3.396 -13.835  -5.900  1.00  0.00           C 
ATOM   1189  NZ  LYS A  78      -3.464 -14.823  -7.012  1.00  0.00           N 
ATOM   1190  H   LYS A  78      -5.596  -9.418  -7.625  1.00  0.00           H 
ATOM   1191  HA  LYS A  78      -6.772 -11.864  -8.415  1.00  0.00           H 
ATOM   1192 2HB  LYS A  78      -5.661 -11.072  -5.684  1.00  0.00           H 
ATOM   1193 1HB  LYS A  78      -4.697 -11.663  -7.032  1.00  0.00           H 
ATOM   1194 2HG  LYS A  78      -5.969 -13.824  -6.942  1.00  0.00           H 
ATOM   1195 1HG  LYS A  78      -6.818 -13.221  -5.517  1.00  0.00           H 
ATOM   1196 2HD  LYS A  78      -5.024 -14.669  -4.772  1.00  0.00           H 
ATOM   1197 1HD  LYS A  78      -4.613 -13.012  -4.333  1.00  0.00           H 
ATOM   1198 2HE  LYS A  78      -2.642 -14.163  -5.192  1.00  0.00           H 
ATOM   1199 1HE  LYS A  78      -3.108 -12.875  -6.304  1.00  0.00           H 
ATOM   1200 1HZ  LYS A  78      -3.722 -15.764  -6.642  1.00  0.00           H 
ATOM   1201 2HZ  LYS A  78      -2.544 -14.895  -7.484  1.00  0.00           H 
ATOM   1202 3HZ  LYS A  78      -4.176 -14.531  -7.713  1.00  0.00           H 
ATOM   1203  N   HIS A  79      -8.544  -9.970  -6.421  1.00  0.00           N 
ATOM   1204  CA  HIS A  79      -9.883  -9.736  -5.844  1.00  0.00           C 
ATOM   1205  C   HIS A  79     -10.934  -9.356  -6.915  1.00  0.00           C 
ATOM   1206  O   HIS A  79     -12.097  -9.150  -6.561  1.00  0.00           O 
ATOM   1207  CB  HIS A  79      -9.823  -8.651  -4.730  1.00  0.00           C 
ATOM   1208  CG  HIS A  79      -9.238  -9.128  -3.423  1.00  0.00           C 
ATOM   1209  ND1 HIS A  79      -8.108  -8.588  -2.846  1.00  0.00           N 
ATOM   1210  CD2 HIS A  79      -9.665 -10.085  -2.565  1.00  0.00           C 
ATOM   1211  CE1 HIS A  79      -7.871  -9.190  -1.700  1.00  0.00           C 
ATOM   1212  NE2 HIS A  79      -8.796 -10.102  -1.503  1.00  0.00           N 
ATOM   1213  H   HIS A  79      -7.908  -9.223  -6.448  1.00  0.00           H 
ATOM   1214  HA  HIS A  79     -10.212 -10.670  -5.391  1.00  0.00           H 
ATOM   1215 2HB  HIS A  79     -10.824  -8.290  -4.525  1.00  0.00           H 
ATOM   1216 1HB  HIS A  79      -9.223  -7.820  -5.079  1.00  0.00           H 
ATOM   1217  HD1 HIS A  79      -7.548  -7.885  -3.235  1.00  0.00           H 
ATOM   1218  HD2 HIS A  79     -10.536 -10.716  -2.687  1.00  0.00           H 
ATOM   1219  HE1 HIS A  79      -7.054  -8.970  -1.031  1.00  0.00           H 
ATOM   1220  HE2 HIS A  79      -8.704 -10.853  -0.873  1.00  0.00           H 
ATOM   1221  N   GLY A  80     -10.557  -9.291  -8.214  1.00  0.00           N 
ATOM   1222  CA  GLY A  80     -11.533  -9.018  -9.294  1.00  0.00           C 
ATOM   1223  C   GLY A  80     -11.312  -7.720 -10.069  1.00  0.00           C 
ATOM   1224  O   GLY A  80     -12.272  -6.996 -10.349  1.00  0.00           O 
ATOM   1225  H   GLY A  80      -9.639  -9.502  -8.466  1.00  0.00           H 
ATOM   1226 2HA  GLY A  80     -12.542  -9.007  -8.882  1.00  0.00           H 
ATOM   1227 1HA  GLY A  80     -11.476  -9.830 -10.000  1.00  0.00           H 
ATOM   1228  N   LEU A  81     -10.051  -7.419 -10.427  1.00  0.00           N 
ATOM   1229  CA  LEU A  81      -9.723  -6.369 -11.432  1.00  0.00           C 
ATOM   1230  C   LEU A  81      -9.052  -7.044 -12.637  1.00  0.00           C 
ATOM   1231  O   LEU A  81      -8.228  -7.946 -12.465  1.00  0.00           O 
ATOM   1232  CB  LEU A  81      -8.778  -5.239 -10.870  1.00  0.00           C 
ATOM   1233  CG  LEU A  81      -9.440  -4.074 -10.065  1.00  0.00           C 
ATOM   1234  CD1 LEU A  81     -10.495  -3.342 -10.914  1.00  0.00           C 
ATOM   1235  CD2 LEU A  81     -10.031  -4.561  -8.735  1.00  0.00           C 
ATOM   1236  H   LEU A  81      -9.318  -7.923 -10.025  1.00  0.00           H 
ATOM   1237  HA  LEU A  81     -10.656  -5.914 -11.768  1.00  0.00           H 
ATOM   1238 2HB  LEU A  81      -8.246  -4.790 -11.706  1.00  0.00           H 
ATOM   1239 1HB  LEU A  81      -8.039  -5.704 -10.234  1.00  0.00           H 
ATOM   1240  HG  LEU A  81      -8.670  -3.345  -9.823  1.00  0.00           H 
ATOM   1241 1HD1 LEU A  81     -11.306  -4.018 -11.167  1.00  0.00           H 
ATOM   1242 2HD1 LEU A  81     -10.040  -2.979 -11.825  1.00  0.00           H 
ATOM   1243 3HD1 LEU A  81     -10.890  -2.503 -10.360  1.00  0.00           H 
ATOM   1244 1HD2 LEU A  81     -10.446  -3.725  -8.184  1.00  0.00           H 
ATOM   1245 2HD2 LEU A  81      -9.252  -5.021  -8.142  1.00  0.00           H 
ATOM   1246 3HD2 LEU A  81     -10.812  -5.288  -8.922  1.00  0.00           H 
ATOM   1247  N   HIS A  82      -9.420  -6.614 -13.848  1.00  0.00           N 
ATOM   1248  CA  HIS A  82      -8.747  -7.029 -15.093  1.00  0.00           C 
ATOM   1249  C   HIS A  82      -7.687  -5.973 -15.485  1.00  0.00           C 
ATOM   1250  O   HIS A  82      -7.828  -4.808 -15.103  1.00  0.00           O 
ATOM   1251  CB  HIS A  82      -9.788  -7.234 -16.232  1.00  0.00           C 
ATOM   1252  CG  HIS A  82     -10.710  -8.413 -16.018  1.00  0.00           C 
ATOM   1253  ND1 HIS A  82     -11.999  -8.471 -16.508  1.00  0.00           N 
ATOM   1254  CD2 HIS A  82     -10.502  -9.599 -15.392  1.00  0.00           C 
ATOM   1255  CE1 HIS A  82     -12.536  -9.632 -16.191  1.00  0.00           C 
ATOM   1256  NE2 HIS A  82     -11.652 -10.333 -15.515  1.00  0.00           N 
ATOM   1257  H   HIS A  82     -10.169  -5.985 -13.911  1.00  0.00           H 
ATOM   1258  HA  HIS A  82      -8.238  -7.971 -14.910  1.00  0.00           H 
ATOM   1259 2HB  HIS A  82      -9.266  -7.395 -17.170  1.00  0.00           H 
ATOM   1260 1HB  HIS A  82     -10.399  -6.348 -16.319  1.00  0.00           H 
ATOM   1261  HD1 HIS A  82     -12.450  -7.769 -17.025  1.00  0.00           H 
ATOM   1262  HD2 HIS A  82      -9.596  -9.910 -14.892  1.00  0.00           H 
ATOM   1263  HE1 HIS A  82     -13.533  -9.958 -16.452  1.00  0.00           H 
ATOM   1264  HE2 HIS A  82     -11.857 -11.145 -15.006  1.00  0.00           H 
ATOM   1265  N   PRO A  83      -6.595  -6.361 -16.235  1.00  0.00           N 
ATOM   1266  CA  PRO A  83      -5.561  -5.401 -16.737  1.00  0.00           C 
ATOM   1267  C   PRO A  83      -6.128  -4.285 -17.654  1.00  0.00           C 
ATOM   1268  O   PRO A  83      -5.462  -3.276 -17.889  1.00  0.00           O 
ATOM   1269  CB  PRO A  83      -4.564  -6.314 -17.502  1.00  0.00           C 
ATOM   1270  CG  PRO A  83      -4.762  -7.675 -16.899  1.00  0.00           C 
ATOM   1271  CD  PRO A  83      -6.237  -7.763 -16.594  1.00  0.00           C 
ATOM   1272  HA  PRO A  83      -5.050  -4.931 -15.903  1.00  0.00           H 
ATOM   1273 2HB  PRO A  83      -3.547  -5.962 -17.357  1.00  0.00           H 
ATOM   1274 1HB  PRO A  83      -4.790  -6.317 -18.566  1.00  0.00           H 
ATOM   1275 2HG  PRO A  83      -4.178  -7.773 -15.987  1.00  0.00           H 
ATOM   1276 1HG  PRO A  83      -4.471  -8.445 -17.609  1.00  0.00           H 
ATOM   1277 2HD  PRO A  83      -6.416  -8.432 -15.762  1.00  0.00           H 
ATOM   1278 1HD  PRO A  83      -6.795  -8.092 -17.467  1.00  0.00           H 
ATOM   1279  N   LYS A  84      -7.366  -4.481 -18.138  1.00  0.00           N 
ATOM   1280  CA  LYS A  84      -8.084  -3.502 -18.983  1.00  0.00           C 
ATOM   1281  C   LYS A  84      -8.407  -2.216 -18.189  1.00  0.00           C 
ATOM   1282  O   LYS A  84      -8.498  -1.127 -18.763  1.00  0.00           O 
ATOM   1283  CB  LYS A  84      -9.385  -4.143 -19.541  1.00  0.00           C 
ATOM   1284  CG  LYS A  84      -9.183  -5.533 -20.199  1.00  0.00           C 
ATOM   1285  CD  LYS A  84      -8.175  -5.517 -21.380  1.00  0.00           C 
ATOM   1286  CE  LYS A  84      -8.673  -4.711 -22.596  1.00  0.00           C 
ATOM   1287  NZ  LYS A  84      -9.898  -5.301 -23.192  1.00  0.00           N 
ATOM   1288  H   LYS A  84      -7.818  -5.316 -17.913  1.00  0.00           H 
ATOM   1289  HA  LYS A  84      -7.434  -3.246 -19.814  1.00  0.00           H 
ATOM   1290 2HB  LYS A  84      -9.814  -3.474 -20.280  1.00  0.00           H 
ATOM   1291 1HB  LYS A  84     -10.097  -4.259 -18.727  1.00  0.00           H 
ATOM   1292 2HG  LYS A  84     -10.143  -5.890 -20.561  1.00  0.00           H 
ATOM   1293 1HG  LYS A  84      -8.818  -6.223 -19.443  1.00  0.00           H 
ATOM   1294 2HD  LYS A  84      -7.991  -6.540 -21.691  1.00  0.00           H 
ATOM   1295 1HD  LYS A  84      -7.238  -5.085 -21.038  1.00  0.00           H 
ATOM   1296 2HE  LYS A  84      -7.897  -4.692 -23.351  1.00  0.00           H 
ATOM   1297 1HE  LYS A  84      -8.893  -3.697 -22.288  1.00  0.00           H 
ATOM   1298 1HZ  LYS A  84      -9.713  -6.277 -23.501  1.00  0.00           H 
ATOM   1299 2HZ  LYS A  84     -10.203  -4.747 -24.013  1.00  0.00           H 
ATOM   1300 3HZ  LYS A  84     -10.667  -5.311 -22.493  1.00  0.00           H 
ATOM   1301  N   PHE A  85      -8.575  -2.382 -16.861  1.00  0.00           N 
ATOM   1302  CA  PHE A  85      -8.742  -1.277 -15.890  1.00  0.00           C 
ATOM   1303  C   PHE A  85      -7.506  -0.352 -15.878  1.00  0.00           C 
ATOM   1304  O   PHE A  85      -7.622   0.863 -15.679  1.00  0.00           O 
ATOM   1305  CB  PHE A  85      -8.978  -1.887 -14.478  1.00  0.00           C 
ATOM   1306  CG  PHE A  85      -9.107  -0.877 -13.331  1.00  0.00           C 
ATOM   1307  CD1 PHE A  85      -8.052  -0.657 -12.436  1.00  0.00           C 
ATOM   1308  CD2 PHE A  85     -10.289  -0.165 -13.138  1.00  0.00           C 
ATOM   1309  CE1 PHE A  85      -8.176   0.253 -11.400  1.00  0.00           C 
ATOM   1310  CE2 PHE A  85     -10.407   0.744 -12.103  1.00  0.00           C 
ATOM   1311  CZ  PHE A  85      -9.357   0.949 -11.231  1.00  0.00           C 
ATOM   1312  H   PHE A  85      -8.606  -3.301 -16.518  1.00  0.00           H 
ATOM   1313  HA  PHE A  85      -9.614  -0.702 -16.182  1.00  0.00           H 
ATOM   1314 2HB  PHE A  85      -8.154  -2.559 -14.248  1.00  0.00           H 
ATOM   1315 1HB  PHE A  85      -9.888  -2.475 -14.505  1.00  0.00           H 
ATOM   1316  HD1 PHE A  85      -7.122  -1.200 -12.563  1.00  0.00           H 
ATOM   1317  HD2 PHE A  85     -11.121  -0.319 -13.819  1.00  0.00           H 
ATOM   1318  HE1 PHE A  85      -7.351   0.413 -10.718  1.00  0.00           H 
ATOM   1319  HE2 PHE A  85     -11.330   1.289 -11.973  1.00  0.00           H 
ATOM   1320  HZ  PHE A  85      -9.458   1.659 -10.423  1.00  0.00           H 
ATOM   1321  N   GLY A  86      -6.328  -0.944 -16.131  1.00  0.00           N 
ATOM   1322  CA  GLY A  86      -5.050  -0.245 -16.002  1.00  0.00           C 
ATOM   1323  C   GLY A  86      -4.503  -0.368 -14.593  1.00  0.00           C 
ATOM   1324  O   GLY A  86      -4.081   0.620 -13.984  1.00  0.00           O 
ATOM   1325  H   GLY A  86      -6.329  -1.878 -16.417  1.00  0.00           H 
ATOM   1326 2HA  GLY A  86      -5.170   0.803 -16.256  1.00  0.00           H 
ATOM   1327 1HA  GLY A  86      -4.345  -0.693 -16.690  1.00  0.00           H 
ATOM   1328  N   ALA A  87      -4.539  -1.604 -14.072  1.00  0.00           N 
ATOM   1329  CA  ALA A  87      -4.053  -1.917 -12.723  1.00  0.00           C 
ATOM   1330  C   ALA A  87      -2.509  -1.847 -12.673  1.00  0.00           C 
ATOM   1331  O   ALA A  87      -1.939  -0.888 -12.143  1.00  0.00           O 
ATOM   1332  CB  ALA A  87      -4.589  -3.294 -12.286  1.00  0.00           C 
ATOM   1333  H   ALA A  87      -4.914  -2.326 -14.612  1.00  0.00           H 
ATOM   1334  HA  ALA A  87      -4.457  -1.173 -12.041  1.00  0.00           H 
ATOM   1335 1HB  ALA A  87      -5.670  -3.300 -12.342  1.00  0.00           H 
ATOM   1336 2HB  ALA A  87      -4.286  -3.499 -11.268  1.00  0.00           H 
ATOM   1337 3HB  ALA A  87      -4.193  -4.065 -12.937  1.00  0.00           H 
ATOM   1338  N   ILE A  88      -1.840  -2.864 -13.253  1.00  0.00           N 
ATOM   1339  CA  ILE A  88      -0.359  -2.942 -13.308  1.00  0.00           C 
ATOM   1340  C   ILE A  88       0.151  -2.513 -14.703  1.00  0.00           C 
ATOM   1341  O   ILE A  88       1.319  -2.169 -14.873  1.00  0.00           O 
ATOM   1342  CB  ILE A  88       0.129  -4.404 -12.954  1.00  0.00           C 
ATOM   1343  CG1 ILE A  88       1.685  -4.461 -12.764  1.00  0.00           C 
ATOM   1344  CG2 ILE A  88      -0.354  -5.429 -14.016  1.00  0.00           C 
ATOM   1345  CD1 ILE A  88       2.242  -5.819 -12.370  1.00  0.00           C 
ATOM   1346  H   ILE A  88      -2.352  -3.595 -13.648  1.00  0.00           H 
ATOM   1347  HA  ILE A  88       0.050  -2.255 -12.563  1.00  0.00           H 
ATOM   1348  HB  ILE A  88      -0.342  -4.674 -12.012  1.00  0.00           H 
ATOM   1349 2HG1 ILE A  88       1.976  -3.754 -11.993  1.00  0.00           H 
ATOM   1350 1HG1 ILE A  88       2.167  -4.182 -13.689  1.00  0.00           H 
ATOM   1351 1HG2 ILE A  88      -0.052  -6.432 -13.733  1.00  0.00           H 
ATOM   1352 2HG2 ILE A  88       0.078  -5.192 -14.981  1.00  0.00           H 
ATOM   1353 3HG2 ILE A  88      -1.434  -5.393 -14.097  1.00  0.00           H 
ATOM   1354 1HD1 ILE A  88       1.785  -6.150 -11.448  1.00  0.00           H 
ATOM   1355 2HD1 ILE A  88       3.312  -5.743 -12.228  1.00  0.00           H 
ATOM   1356 3HD1 ILE A  88       2.037  -6.535 -13.152  1.00  0.00           H 
ATOM   1357  N   THR A  89      -0.758  -2.527 -15.689  1.00  0.00           N 
ATOM   1358  CA  THR A  89      -0.455  -2.236 -17.105  1.00  0.00           C 
ATOM   1359  C   THR A  89      -0.475  -0.723 -17.419  1.00  0.00           C 
ATOM   1360  O   THR A  89      -0.211  -0.314 -18.558  1.00  0.00           O 
ATOM   1361  CB  THR A  89      -1.482  -3.000 -17.999  1.00  0.00           C 
ATOM   1362  OG1 THR A  89      -2.806  -2.780 -17.479  1.00  0.00           O 
ATOM   1363  CG2 THR A  89      -1.195  -4.515 -18.037  1.00  0.00           C 
ATOM   1364  H   THR A  89      -1.684  -2.747 -15.462  1.00  0.00           H 
ATOM   1365  HA  THR A  89       0.540  -2.616 -17.327  1.00  0.00           H 
ATOM   1366  HB  THR A  89      -1.434  -2.613 -19.014  1.00  0.00           H 
ATOM   1367  HG1 THR A  89      -3.365  -2.408 -18.175  1.00  0.00           H 
ATOM   1368 1HG2 THR A  89      -1.239  -4.921 -17.034  1.00  0.00           H 
ATOM   1369 2HG2 THR A  89      -0.208  -4.695 -18.450  1.00  0.00           H 
ATOM   1370 3HG2 THR A  89      -1.933  -5.010 -18.654  1.00  0.00           H 
ATOM   1371  N   ARG A  90      -0.800   0.098 -16.406  1.00  0.00           N 
ATOM   1372  CA  ARG A  90      -0.725   1.567 -16.492  1.00  0.00           C 
ATOM   1373  C   ARG A  90       0.533   2.016 -15.742  1.00  0.00           C 
ATOM   1374  O   ARG A  90       0.660   1.732 -14.540  1.00  0.00           O 
ATOM   1375  CB  ARG A  90      -1.994   2.212 -15.854  1.00  0.00           C 
ATOM   1376  CG  ARG A  90      -2.208   3.716 -16.171  1.00  0.00           C 
ATOM   1377  CD  ARG A  90      -2.627   3.955 -17.637  1.00  0.00           C 
ATOM   1378  NE  ARG A  90      -2.886   5.381 -17.933  1.00  0.00           N 
ATOM   1379  CZ  ARG A  90      -3.411   5.851 -19.080  1.00  0.00           C 
ATOM   1380  NH1 ARG A  90      -3.732   5.030 -20.072  1.00  0.00           N 
ATOM   1381  NH2 ARG A  90      -3.611   7.150 -19.221  1.00  0.00           N 
ATOM   1382  H   ARG A  90      -1.100  -0.300 -15.564  1.00  0.00           H 
ATOM   1383  HA  ARG A  90      -0.652   1.865 -17.535  1.00  0.00           H 
ATOM   1384 2HB  ARG A  90      -1.945   2.098 -14.774  1.00  0.00           H 
ATOM   1385 1HB  ARG A  90      -2.865   1.671 -16.207  1.00  0.00           H 
ATOM   1386 2HG  ARG A  90      -1.281   4.250 -15.978  1.00  0.00           H 
ATOM   1387 1HG  ARG A  90      -2.981   4.112 -15.519  1.00  0.00           H 
ATOM   1388 2HD  ARG A  90      -3.526   3.383 -17.842  1.00  0.00           H 
ATOM   1389 1HD  ARG A  90      -1.831   3.607 -18.289  1.00  0.00           H 
ATOM   1390  HE  ARG A  90      -2.664   6.028 -17.227  1.00  0.00           H 
ATOM   1391 1HH1 ARG A  90      -3.587   4.043 -19.973  1.00  0.00           H 
ATOM   1392 2HH1 ARG A  90      -4.131   5.389 -20.918  1.00  0.00           H 
ATOM   1393 1HH2 ARG A  90      -3.378   7.777 -18.472  1.00  0.00           H 
ATOM   1394 2HH2 ARG A  90      -4.001   7.513 -20.069  1.00  0.00           H 
ATOM   1395  N   VAL A  91       1.483   2.667 -16.442  1.00  0.00           N 
ATOM   1396  CA  VAL A  91       2.668   3.246 -15.787  1.00  0.00           C 
ATOM   1397  C   VAL A  91       2.232   4.461 -14.935  1.00  0.00           C 
ATOM   1398  O   VAL A  91       1.983   5.559 -15.451  1.00  0.00           O 
ATOM   1399  CB  VAL A  91       3.833   3.618 -16.804  1.00  0.00           C 
ATOM   1400  CG1 VAL A  91       4.455   2.343 -17.425  1.00  0.00           C 
ATOM   1401  CG2 VAL A  91       3.373   4.587 -17.924  1.00  0.00           C 
ATOM   1402  H   VAL A  91       1.383   2.756 -17.409  1.00  0.00           H 
ATOM   1403  HA  VAL A  91       3.061   2.484 -15.106  1.00  0.00           H 
ATOM   1404  HB  VAL A  91       4.616   4.116 -16.232  1.00  0.00           H 
ATOM   1405 1HG1 VAL A  91       4.830   1.698 -16.639  1.00  0.00           H 
ATOM   1406 2HG1 VAL A  91       5.277   2.614 -18.077  1.00  0.00           H 
ATOM   1407 3HG1 VAL A  91       3.707   1.809 -17.998  1.00  0.00           H 
ATOM   1408 1HG2 VAL A  91       2.584   4.126 -18.506  1.00  0.00           H 
ATOM   1409 2HG2 VAL A  91       4.205   4.823 -18.575  1.00  0.00           H 
ATOM   1410 3HG2 VAL A  91       3.002   5.502 -17.483  1.00  0.00           H 
ATOM   1411  N   HIS A  92       2.041   4.214 -13.622  1.00  0.00           N 
ATOM   1412  CA  HIS A  92       1.611   5.252 -12.673  1.00  0.00           C 
ATOM   1413  C   HIS A  92       2.725   6.301 -12.547  1.00  0.00           C 
ATOM   1414  O   HIS A  92       3.779   6.029 -11.982  1.00  0.00           O 
ATOM   1415  CB  HIS A  92       1.242   4.649 -11.290  1.00  0.00           C 
ATOM   1416  CG  HIS A  92       0.083   3.671 -11.333  1.00  0.00           C 
ATOM   1417  ND1 HIS A  92      -1.236   4.053 -11.206  1.00  0.00           N 
ATOM   1418  CD2 HIS A  92       0.057   2.322 -11.494  1.00  0.00           C 
ATOM   1419  CE1 HIS A  92      -2.014   2.989 -11.292  1.00  0.00           C 
ATOM   1420  NE2 HIS A  92      -1.253   1.929 -11.465  1.00  0.00           N 
ATOM   1421  H   HIS A  92       2.198   3.305 -13.292  1.00  0.00           H 
ATOM   1422  HA  HIS A  92       0.724   5.731 -13.090  1.00  0.00           H 
ATOM   1423 2HB  HIS A  92       0.968   5.458 -10.614  1.00  0.00           H 
ATOM   1424 1HB  HIS A  92       2.102   4.133 -10.883  1.00  0.00           H 
ATOM   1425  HD1 HIS A  92      -1.555   4.969 -11.050  1.00  0.00           H 
ATOM   1426  HD2 HIS A  92       0.915   1.678 -11.627  1.00  0.00           H 
ATOM   1427  HE1 HIS A  92      -3.092   2.988 -11.233  1.00  0.00           H 
ATOM   1428  HE2 HIS A  92      -1.559   1.004 -11.383  1.00  0.00           H 
ATOM   1429  N   LYS A  93       2.492   7.482 -13.133  1.00  0.00           N 
ATOM   1430  CA  LYS A  93       3.489   8.568 -13.188  1.00  0.00           C 
ATOM   1431  C   LYS A  93       3.647   9.235 -11.810  1.00  0.00           C 
ATOM   1432  O   LYS A  93       4.724   9.737 -11.469  1.00  0.00           O 
ATOM   1433  CB  LYS A  93       3.075   9.600 -14.267  1.00  0.00           C 
ATOM   1434  CG  LYS A  93       2.959   9.017 -15.694  1.00  0.00           C 
ATOM   1435  CD  LYS A  93       2.605  10.069 -16.786  1.00  0.00           C 
ATOM   1436  CE  LYS A  93       1.178  10.666 -16.665  1.00  0.00           C 
ATOM   1437  NZ  LYS A  93       1.033  11.660 -15.562  1.00  0.00           N 
ATOM   1438  H   LYS A  93       1.610   7.638 -13.536  1.00  0.00           H 
ATOM   1439  HA  LYS A  93       4.443   8.132 -13.472  1.00  0.00           H 
ATOM   1440 2HB  LYS A  93       3.807  10.403 -14.287  1.00  0.00           H 
ATOM   1441 1HB  LYS A  93       2.111  10.022 -13.996  1.00  0.00           H 
ATOM   1442 2HG  LYS A  93       2.193   8.246 -15.689  1.00  0.00           H 
ATOM   1443 1HG  LYS A  93       3.908   8.558 -15.956  1.00  0.00           H 
ATOM   1444 2HD  LYS A  93       2.700   9.596 -17.760  1.00  0.00           H 
ATOM   1445 1HD  LYS A  93       3.319  10.882 -16.729  1.00  0.00           H 
ATOM   1446 2HE  LYS A  93       0.476   9.859 -16.496  1.00  0.00           H 
ATOM   1447 1HE  LYS A  93       0.925  11.158 -17.595  1.00  0.00           H 
ATOM   1448 1HZ  LYS A  93       1.721  12.431 -15.678  1.00  0.00           H 
ATOM   1449 2HZ  LYS A  93       1.192  11.205 -14.642  1.00  0.00           H 
ATOM   1450 3HZ  LYS A  93       0.076  12.062 -15.570  1.00  0.00           H 
ATOM   1451  N   GLU A  94       2.556   9.207 -11.022  1.00  0.00           N 
ATOM   1452  CA  GLU A  94       2.523   9.729  -9.643  1.00  0.00           C 
ATOM   1453  C   GLU A  94       2.995   8.671  -8.620  1.00  0.00           C 
ATOM   1454  O   GLU A  94       2.924   8.912  -7.406  1.00  0.00           O 
ATOM   1455  CB  GLU A  94       1.092  10.213  -9.311  1.00  0.00           C 
ATOM   1456  CG  GLU A  94       0.583  11.336 -10.238  1.00  0.00           C 
ATOM   1457  CD  GLU A  94      -0.884  11.706  -9.996  1.00  0.00           C 
ATOM   1458  OE1 GLU A  94      -1.771  11.134 -10.672  1.00  0.00           O 
ATOM   1459  OE2 GLU A  94      -1.167  12.561  -9.125  1.00  0.00           O 
ATOM   1460  H   GLU A  94       1.732   8.819 -11.388  1.00  0.00           H 
ATOM   1461  HA  GLU A  94       3.200  10.577  -9.584  1.00  0.00           H 
ATOM   1462 2HB  GLU A  94       1.072  10.578  -8.288  1.00  0.00           H 
ATOM   1463 1HB  GLU A  94       0.413   9.368  -9.391  1.00  0.00           H 
ATOM   1464 2HG  GLU A  94       0.696  11.002 -11.267  1.00  0.00           H 
ATOM   1465 1HG  GLU A  94       1.199  12.220 -10.093  1.00  0.00           H 
ATOM   1466  N   TYR A  95       3.476   7.503  -9.118  1.00  0.00           N 
ATOM   1467  CA  TYR A  95       4.135   6.486  -8.279  1.00  0.00           C 
ATOM   1468  C   TYR A  95       5.365   7.088  -7.593  1.00  0.00           C 
ATOM   1469  O   TYR A  95       5.620   6.779  -6.446  1.00  0.00           O 
ATOM   1470  CB  TYR A  95       4.545   5.236  -9.115  1.00  0.00           C 
ATOM   1471  CG  TYR A  95       5.515   4.274  -8.392  1.00  0.00           C 
ATOM   1472  CD1 TYR A  95       6.863   4.178  -8.774  1.00  0.00           C 
ATOM   1473  CD2 TYR A  95       5.098   3.507  -7.302  1.00  0.00           C 
ATOM   1474  CE1 TYR A  95       7.742   3.349  -8.104  1.00  0.00           C 
ATOM   1475  CE2 TYR A  95       5.978   2.674  -6.635  1.00  0.00           C 
ATOM   1476  CZ  TYR A  95       7.293   2.602  -7.033  1.00  0.00           C 
ATOM   1477  OH  TYR A  95       8.162   1.777  -6.358  1.00  0.00           O 
ATOM   1478  H   TYR A  95       3.386   7.329 -10.076  1.00  0.00           H 
ATOM   1479  HA  TYR A  95       3.423   6.180  -7.516  1.00  0.00           H 
ATOM   1480 2HB  TYR A  95       5.016   5.567 -10.034  1.00  0.00           H 
ATOM   1481 1HB  TYR A  95       3.652   4.675  -9.373  1.00  0.00           H 
ATOM   1482  HD1 TYR A  95       7.216   4.759  -9.619  1.00  0.00           H 
ATOM   1483  HD2 TYR A  95       4.065   3.558  -6.987  1.00  0.00           H 
ATOM   1484  HE1 TYR A  95       8.780   3.294  -8.417  1.00  0.00           H 
ATOM   1485  HE2 TYR A  95       5.631   2.089  -5.797  1.00  0.00           H 
ATOM   1486  HH  TYR A  95       7.726   0.944  -6.165  1.00  0.00           H 
ATOM   1487  N   ASP A  96       6.110   7.947  -8.322  1.00  0.00           N 
ATOM   1488  CA  ASP A  96       7.323   8.614  -7.801  1.00  0.00           C 
ATOM   1489  C   ASP A  96       7.007   9.511  -6.587  1.00  0.00           C 
ATOM   1490  O   ASP A  96       7.827   9.639  -5.678  1.00  0.00           O 
ATOM   1491  CB  ASP A  96       8.008   9.445  -8.910  1.00  0.00           C 
ATOM   1492  CG  ASP A  96       8.579   8.562 -10.026  1.00  0.00           C 
ATOM   1493  OD1 ASP A  96       7.841   8.243 -10.981  1.00  0.00           O 
ATOM   1494  OD2 ASP A  96       9.759   8.151  -9.938  1.00  0.00           O 
ATOM   1495  H   ASP A  96       5.848   8.128  -9.252  1.00  0.00           H 
ATOM   1496  HA  ASP A  96       8.009   7.832  -7.481  1.00  0.00           H 
ATOM   1497 2HB  ASP A  96       8.818  10.029  -8.479  1.00  0.00           H 
ATOM   1498 1HB  ASP A  96       7.280  10.130  -9.336  1.00  0.00           H 
ATOM   1499  N   ALA A  97       5.803  10.107  -6.585  1.00  0.00           N 
ATOM   1500  CA  ALA A  97       5.326  10.970  -5.487  1.00  0.00           C 
ATOM   1501  C   ALA A  97       5.018  10.140  -4.217  1.00  0.00           C 
ATOM   1502  O   ALA A  97       5.357  10.536  -3.100  1.00  0.00           O 
ATOM   1503  CB  ALA A  97       4.099  11.770  -5.945  1.00  0.00           C 
ATOM   1504  H   ALA A  97       5.212   9.961  -7.353  1.00  0.00           H 
ATOM   1505  HA  ALA A  97       6.119  11.679  -5.254  1.00  0.00           H 
ATOM   1506 1HB  ALA A  97       3.784  12.445  -5.157  1.00  0.00           H 
ATOM   1507 2HB  ALA A  97       3.286  11.095  -6.178  1.00  0.00           H 
ATOM   1508 3HB  ALA A  97       4.344  12.345  -6.829  1.00  0.00           H 
ATOM   1509  N   MET A  98       4.338   9.006  -4.405  1.00  0.00           N 
ATOM   1510  CA  MET A  98       4.095   8.012  -3.331  1.00  0.00           C 
ATOM   1511  C   MET A  98       5.418   7.385  -2.814  1.00  0.00           C 
ATOM   1512  O   MET A  98       5.594   7.159  -1.619  1.00  0.00           O 
ATOM   1513  CB  MET A  98       3.161   6.917  -3.897  1.00  0.00           C 
ATOM   1514  CG  MET A  98       2.554   5.951  -2.868  1.00  0.00           C 
ATOM   1515  SD  MET A  98       1.484   4.703  -3.631  1.00  0.00           S 
ATOM   1516  CE  MET A  98       0.508   5.665  -4.781  1.00  0.00           C 
ATOM   1517  H   MET A  98       3.896   8.869  -5.270  1.00  0.00           H 
ATOM   1518  HA  MET A  98       3.598   8.517  -2.511  1.00  0.00           H 
ATOM   1519 2HB  MET A  98       3.715   6.332  -4.624  1.00  0.00           H 
ATOM   1520 1HB  MET A  98       2.341   7.403  -4.410  1.00  0.00           H 
ATOM   1521 2HG  MET A  98       1.971   6.512  -2.151  1.00  0.00           H 
ATOM   1522 1HG  MET A  98       3.355   5.437  -2.351  1.00  0.00           H 
ATOM   1523 1HE  MET A  98       1.155   6.105  -5.526  1.00  0.00           H 
ATOM   1524 2HE  MET A  98      -0.012   6.446  -4.247  1.00  0.00           H 
ATOM   1525 3HE  MET A  98      -0.213   5.023  -5.265  1.00  0.00           H 
ATOM   1526  N   PHE A  99       6.315   7.121  -3.766  1.00  0.00           N 
ATOM   1527  CA  PHE A  99       7.653   6.536  -3.543  1.00  0.00           C 
ATOM   1528  C   PHE A  99       8.479   7.417  -2.592  1.00  0.00           C 
ATOM   1529  O   PHE A  99       9.036   6.926  -1.598  1.00  0.00           O 
ATOM   1530  CB  PHE A  99       8.364   6.379  -4.916  1.00  0.00           C 
ATOM   1531  CG  PHE A  99       9.773   5.779  -4.878  1.00  0.00           C 
ATOM   1532  CD1 PHE A  99      10.906   6.597  -4.812  1.00  0.00           C 
ATOM   1533  CD2 PHE A  99       9.962   4.397  -4.912  1.00  0.00           C 
ATOM   1534  CE1 PHE A  99      12.172   6.051  -4.782  1.00  0.00           C 
ATOM   1535  CE2 PHE A  99      11.231   3.855  -4.884  1.00  0.00           C 
ATOM   1536  CZ  PHE A  99      12.335   4.680  -4.817  1.00  0.00           C 
ATOM   1537  H   PHE A  99       6.034   7.320  -4.670  1.00  0.00           H 
ATOM   1538  HA  PHE A  99       7.520   5.556  -3.096  1.00  0.00           H 
ATOM   1539 2HB  PHE A  99       8.428   7.356  -5.384  1.00  0.00           H 
ATOM   1540 1HB  PHE A  99       7.752   5.746  -5.550  1.00  0.00           H 
ATOM   1541  HD1 PHE A  99      10.785   7.675  -4.786  1.00  0.00           H 
ATOM   1542  HD2 PHE A  99       9.097   3.743  -4.964  1.00  0.00           H 
ATOM   1543  HE1 PHE A  99      13.041   6.698  -4.731  1.00  0.00           H 
ATOM   1544  HE2 PHE A  99      11.361   2.784  -4.912  1.00  0.00           H 
ATOM   1545  HZ  PHE A  99      13.331   4.252  -4.794  1.00  0.00           H 
ATOM   1546  N   GLU A 100       8.531   8.729  -2.905  1.00  0.00           N 
ATOM   1547  CA  GLU A 100       9.299   9.709  -2.124  1.00  0.00           C 
ATOM   1548  C   GLU A 100       8.654   9.971  -0.745  1.00  0.00           C 
ATOM   1549  O   GLU A 100       9.364  10.256   0.232  1.00  0.00           O 
ATOM   1550  CB  GLU A 100       9.487  11.024  -2.904  1.00  0.00           C 
ATOM   1551  CG  GLU A 100       8.188  11.775  -3.220  1.00  0.00           C 
ATOM   1552  CD  GLU A 100       8.413  13.113  -3.918  1.00  0.00           C 
ATOM   1553  OE1 GLU A 100       8.721  13.118  -5.126  1.00  0.00           O 
ATOM   1554  OE2 GLU A 100       8.297  14.167  -3.256  1.00  0.00           O 
ATOM   1555  H   GLU A 100       8.051   9.040  -3.699  1.00  0.00           H 
ATOM   1556  HA  GLU A 100      10.279   9.274  -1.958  1.00  0.00           H 
ATOM   1557 2HB  GLU A 100       9.985  10.797  -3.843  1.00  0.00           H 
ATOM   1558 1HB  GLU A 100      10.134  11.680  -2.329  1.00  0.00           H 
ATOM   1559 2HG  GLU A 100       7.653  11.944  -2.290  1.00  0.00           H 
ATOM   1560 1HG  GLU A 100       7.572  11.151  -3.861  1.00  0.00           H 
ATOM   1561  N   ASP A 101       7.313   9.859  -0.678  1.00  0.00           N 
ATOM   1562  CA  ASP A 101       6.566   9.938   0.591  1.00  0.00           C 
ATOM   1563  C   ASP A 101       7.044   8.829   1.546  1.00  0.00           C 
ATOM   1564  O   ASP A 101       7.445   9.103   2.675  1.00  0.00           O 
ATOM   1565  CB  ASP A 101       5.037   9.810   0.338  1.00  0.00           C 
ATOM   1566  CG  ASP A 101       4.196   9.798   1.637  1.00  0.00           C 
ATOM   1567  OD1 ASP A 101       3.781  10.883   2.104  1.00  0.00           O 
ATOM   1568  OD2 ASP A 101       3.970   8.708   2.209  1.00  0.00           O 
ATOM   1569  H   ASP A 101       6.814   9.717  -1.511  1.00  0.00           H 
ATOM   1570  HA  ASP A 101       6.773  10.908   1.038  1.00  0.00           H 
ATOM   1571 2HB  ASP A 101       4.845   8.893  -0.211  1.00  0.00           H 
ATOM   1572 1HB  ASP A 101       4.716  10.646  -0.274  1.00  0.00           H 
ATOM   1573  N   ILE A 102       6.995   7.586   1.045  1.00  0.00           N 
ATOM   1574  CA  ILE A 102       7.371   6.379   1.795  1.00  0.00           C 
ATOM   1575  C   ILE A 102       8.872   6.366   2.192  1.00  0.00           C 
ATOM   1576  O   ILE A 102       9.186   5.946   3.296  1.00  0.00           O 
ATOM   1577  CB  ILE A 102       6.952   5.080   0.992  1.00  0.00           C 
ATOM   1578  CG1 ILE A 102       5.390   5.028   0.855  1.00  0.00           C 
ATOM   1579  CG2 ILE A 102       7.492   3.774   1.638  1.00  0.00           C 
ATOM   1580  CD1 ILE A 102       4.835   3.822   0.114  1.00  0.00           C 
ATOM   1581  H   ILE A 102       6.629   7.478   0.146  1.00  0.00           H 
ATOM   1582  HA  ILE A 102       6.786   6.395   2.715  1.00  0.00           H 
ATOM   1583  HB  ILE A 102       7.387   5.157  -0.004  1.00  0.00           H 
ATOM   1584 2HG1 ILE A 102       5.054   5.916   0.329  1.00  0.00           H 
ATOM   1585 1HG1 ILE A 102       4.947   5.024   1.841  1.00  0.00           H 
ATOM   1586 1HG2 ILE A 102       7.104   3.678   2.645  1.00  0.00           H 
ATOM   1587 2HG2 ILE A 102       8.571   3.803   1.677  1.00  0.00           H 
ATOM   1588 3HG2 ILE A 102       7.184   2.916   1.052  1.00  0.00           H 
ATOM   1589 1HD1 ILE A 102       5.238   3.791  -0.888  1.00  0.00           H 
ATOM   1590 2HD1 ILE A 102       3.759   3.900   0.063  1.00  0.00           H 
ATOM   1591 3HD1 ILE A 102       5.102   2.915   0.639  1.00  0.00           H 
ATOM   1592  N   ARG A 103       9.792   6.849   1.319  1.00  0.00           N 
ATOM   1593  CA  ARG A 103      11.250   6.864   1.657  1.00  0.00           C 
ATOM   1594  C   ARG A 103      11.562   7.892   2.760  1.00  0.00           C 
ATOM   1595  O   ARG A 103      12.472   7.680   3.572  1.00  0.00           O 
ATOM   1596  CB  ARG A 103      12.169   7.019   0.397  1.00  0.00           C 
ATOM   1597  CG  ARG A 103      12.073   8.333  -0.411  1.00  0.00           C 
ATOM   1598  CD  ARG A 103      12.959   9.483   0.108  1.00  0.00           C 
ATOM   1599  NE  ARG A 103      12.919  10.630  -0.821  1.00  0.00           N 
ATOM   1600  CZ  ARG A 103      12.215  11.763  -0.650  1.00  0.00           C 
ATOM   1601  NH1 ARG A 103      11.569  12.003   0.477  1.00  0.00           N 
ATOM   1602  NH2 ARG A 103      12.164  12.658  -1.621  1.00  0.00           N 
ATOM   1603  H   ARG A 103       9.473   7.177   0.456  1.00  0.00           H 
ATOM   1604  HA  ARG A 103      11.459   5.881   2.085  1.00  0.00           H 
ATOM   1605 2HB  ARG A 103      11.930   6.200  -0.279  1.00  0.00           H 
ATOM   1606 1HB  ARG A 103      13.200   6.891   0.706  1.00  0.00           H 
ATOM   1607 2HG  ARG A 103      11.041   8.664  -0.402  1.00  0.00           H 
ATOM   1608 1HG  ARG A 103      12.356   8.130  -1.438  1.00  0.00           H 
ATOM   1609 2HD  ARG A 103      13.982   9.132   0.186  1.00  0.00           H 
ATOM   1610 1HD  ARG A 103      12.612   9.791   1.089  1.00  0.00           H 
ATOM   1611  HE  ARG A 103      13.433  10.530  -1.655  1.00  0.00           H 
ATOM   1612 1HH1 ARG A 103      11.604  11.347   1.228  1.00  0.00           H 
ATOM   1613 2HH1 ARG A 103      11.022  12.838   0.570  1.00  0.00           H 
ATOM   1614 1HH2 ARG A 103      12.657  12.497  -2.480  1.00  0.00           H 
ATOM   1615 2HH2 ARG A 103      11.623  13.497  -1.507  1.00  0.00           H 
ATOM   1616  N   ALA A 104      10.784   8.990   2.798  1.00  0.00           N 
ATOM   1617  CA  ALA A 104      10.911  10.016   3.848  1.00  0.00           C 
ATOM   1618  C   ALA A 104      10.304   9.512   5.169  1.00  0.00           C 
ATOM   1619  O   ALA A 104      10.874   9.709   6.237  1.00  0.00           O 
ATOM   1620  CB  ALA A 104      10.240  11.320   3.405  1.00  0.00           C 
ATOM   1621  H   ALA A 104      10.064   9.084   2.136  1.00  0.00           H 
ATOM   1622  HA  ALA A 104      11.972  10.211   3.998  1.00  0.00           H 
ATOM   1623 1HB  ALA A 104      10.365  12.076   4.170  1.00  0.00           H 
ATOM   1624 2HB  ALA A 104       9.183  11.149   3.236  1.00  0.00           H 
ATOM   1625 3HB  ALA A 104      10.695  11.666   2.489  1.00  0.00           H 
ATOM   1626  N   LYS A 105       9.113   8.899   5.068  1.00  0.00           N 
ATOM   1627  CA  LYS A 105       8.384   8.275   6.193  1.00  0.00           C 
ATOM   1628  C   LYS A 105       9.185   7.149   6.885  1.00  0.00           C 
ATOM   1629  O   LYS A 105       9.189   7.047   8.112  1.00  0.00           O 
ATOM   1630  CB  LYS A 105       7.035   7.725   5.649  1.00  0.00           C 
ATOM   1631  CG  LYS A 105       5.956   7.453   6.708  1.00  0.00           C 
ATOM   1632  CD  LYS A 105       5.529   8.726   7.462  1.00  0.00           C 
ATOM   1633  CE  LYS A 105       4.398   8.459   8.459  1.00  0.00           C 
ATOM   1634  NZ  LYS A 105       3.126   8.088   7.782  1.00  0.00           N 
ATOM   1635  H   LYS A 105       8.628   8.947   4.226  1.00  0.00           H 
ATOM   1636  HA  LYS A 105       8.182   9.055   6.914  1.00  0.00           H 
ATOM   1637 2HB  LYS A 105       7.227   6.797   5.113  1.00  0.00           H 
ATOM   1638 1HB  LYS A 105       6.632   8.439   4.943  1.00  0.00           H 
ATOM   1639 2HG  LYS A 105       6.345   6.733   7.424  1.00  0.00           H 
ATOM   1640 1HG  LYS A 105       5.086   7.024   6.218  1.00  0.00           H 
ATOM   1641 2HD  LYS A 105       5.193   9.465   6.740  1.00  0.00           H 
ATOM   1642 1HD  LYS A 105       6.384   9.123   8.000  1.00  0.00           H 
ATOM   1643 2HE  LYS A 105       4.233   9.348   9.054  1.00  0.00           H 
ATOM   1644 1HE  LYS A 105       4.697   7.644   9.111  1.00  0.00           H 
ATOM   1645 1HZ  LYS A 105       2.791   8.877   7.190  1.00  0.00           H 
ATOM   1646 2HZ  LYS A 105       2.393   7.863   8.485  1.00  0.00           H 
ATOM   1647 3HZ  LYS A 105       3.273   7.258   7.178  1.00  0.00           H 
ATOM   1648  N   LEU A 106       9.835   6.303   6.073  1.00  0.00           N 
ATOM   1649  CA  LEU A 106      10.764   5.252   6.553  1.00  0.00           C 
ATOM   1650  C   LEU A 106      11.969   5.862   7.293  1.00  0.00           C 
ATOM   1651  O   LEU A 106      12.514   5.244   8.209  1.00  0.00           O 
ATOM   1652  CB  LEU A 106      11.261   4.346   5.371  1.00  0.00           C 
ATOM   1653  CG  LEU A 106      10.479   3.013   5.133  1.00  0.00           C 
ATOM   1654  CD1 LEU A 106       8.976   3.257   4.962  1.00  0.00           C 
ATOM   1655  CD2 LEU A 106      11.045   2.245   3.916  1.00  0.00           C 
ATOM   1656  H   LEU A 106       9.644   6.363   5.127  1.00  0.00           H 
ATOM   1657  HA  LEU A 106      10.197   4.645   7.258  1.00  0.00           H 
ATOM   1658 2HB  LEU A 106      12.303   4.089   5.538  1.00  0.00           H 
ATOM   1659 1HB  LEU A 106      11.213   4.932   4.459  1.00  0.00           H 
ATOM   1660  HG  LEU A 106      10.600   2.376   6.004  1.00  0.00           H 
ATOM   1661 1HD1 LEU A 106       8.585   3.768   5.831  1.00  0.00           H 
ATOM   1662 2HD1 LEU A 106       8.464   2.313   4.852  1.00  0.00           H 
ATOM   1663 3HD1 LEU A 106       8.800   3.863   4.081  1.00  0.00           H 
ATOM   1664 1HD2 LEU A 106      10.508   1.313   3.793  1.00  0.00           H 
ATOM   1665 2HD2 LEU A 106      12.094   2.027   4.073  1.00  0.00           H 
ATOM   1666 3HD2 LEU A 106      10.934   2.841   3.017  1.00  0.00           H 
ATOM   1667  N   HIS A 107      12.381   7.063   6.863  1.00  0.00           N 
ATOM   1668  CA  HIS A 107      13.452   7.827   7.525  1.00  0.00           C 
ATOM   1669  C   HIS A 107      12.904   8.573   8.768  1.00  0.00           C 
ATOM   1670  O   HIS A 107      13.686   8.991   9.639  1.00  0.00           O 
ATOM   1671  CB  HIS A 107      14.090   8.813   6.507  1.00  0.00           C 
ATOM   1672  CG  HIS A 107      15.289   9.570   7.026  1.00  0.00           C 
ATOM   1673  ND1 HIS A 107      16.525   8.984   7.199  1.00  0.00           N 
ATOM   1674  CD2 HIS A 107      15.429  10.855   7.429  1.00  0.00           C 
ATOM   1675  CE1 HIS A 107      17.367   9.873   7.681  1.00  0.00           C 
ATOM   1676  NE2 HIS A 107      16.728  11.018   7.828  1.00  0.00           N 
ATOM   1677  H   HIS A 107      11.949   7.450   6.073  1.00  0.00           H 
ATOM   1678  HA  HIS A 107      14.213   7.121   7.855  1.00  0.00           H 
ATOM   1679 2HB  HIS A 107      13.342   9.536   6.195  1.00  0.00           H 
ATOM   1680 1HB  HIS A 107      14.414   8.256   5.636  1.00  0.00           H 
ATOM   1681  HD1 HIS A 107      16.750   8.051   6.995  1.00  0.00           H 
ATOM   1682  HD2 HIS A 107      14.659  11.614   7.432  1.00  0.00           H 
ATOM   1683  HE1 HIS A 107      18.406   9.694   7.922  1.00  0.00           H 
ATOM   1684  HE2 HIS A 107      17.070  11.790   8.325  1.00  0.00           H 
END
